﻿USE sofia;
DROP TABLE IF EXISTS sofia.kpr_vpl;
CREATE TABLE kpr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kpr_vpl WRITE;
INSERT INTO kpr_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Genembo mave ari ekoko embo da dengoro indari ava jo ningae arira, dubo ekoko embode dabade jo umo ae arira, a ari ekoko embode dabade jo tatedo, God dere jirae arira, genembo amo, nu ivugaghae a dubo jamaghae irarira. ");
INSERT INTO kpr_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Genembo amo, nu Bajari da Agho Dari uju eraira. Sifo a tumba evia inono, nu dubo evevaghae Bajari da Agho Dari tegutuse, dubo kotise irira. ");
INSERT INTO kpr_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Nu kau ika uvu betuda govetero viviterira, amingori. Nunda igi baduru use, a sifo furureari beká jighiraira. Jo sifo reda gharasa edo avae arira. Nu rea eraira amo, isambu eveva bekári. ");
INSERT INTO kpr_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","O ari ekoko embo mo, ne jo kau amingo iraeri. Ne kau roera eni, susu beká tefori, anoso a ifu vanembori. Ne sena yaurai fuseari ghumburaira, ainda kaugori. ");
INSERT INTO kpr_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","God bekáda bekáda ategi ururari, ne jo fetae arera. Evetu genembo God kotae eraera amo, ne esike yarera. Ne jo evetu genembo eveva ainde dabade irae arera. ");
INSERT INTO kpr_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Ainda beká mo: Bajari nu ari eveva embo ava bu tavo use, nu ari ekoko embo ava fuge kotae ari, ya sirivo arera. ");
INSERT INTO kpr_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Endada oro oro redae God dodo janje ekoko eraeri? Ne redae manaka beká irae ava gayeraeri? ");
INSERT INTO kpr_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Endada kini (king) mane God ighagha use irera. Nenda kokotofu, Bajari a nunda Genembo gategusira aikena, osogo ari dae sedo dabade tatedo irera. ");
INSERT INTO kpr_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“Namonde nenda agho dari do buvore!” “Nenda sari fuge doyore!” aminge seraera. ");
INSERT INTO kpr_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Bajari nunda anumba vasa utuda anumbirise, gegha jise, ne tefo tefo manaka gayeraera aindae dere jiraira. ");
INSERT INTO kpr_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","God nu dubo eko edo oju aoro dae resira. ");
INSERT INTO kpr_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Nanda kini ututu kakara Saion, aminda fiteno irira,” Bajari aminge resira. ");
INSERT INTO kpr_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Kini doriri aminda irira, aimi resira, “Nu nandae sisira, ” Ni nanda Mandiri. Na oroko nimokena resena, “Na ninda Afa bekári. ");
INSERT INTO kpr_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","9","Benunu saresa, na natofo isambu ninda ungoda fitarena. Ne kefata aurimi ari aimi de bejaresa. Kau okia fugeoro, du de fusuruma eraira, aminga ava aso itatama arera. Enda isambu ninda tofo arira. ");
INSERT INTO kpr_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Avori, endada kini mane a giti jighari nemokena resena, erá mema eove dae sise, dubo kotise nanda geka ningivu!” ");
INSERT INTO kpr_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Oju igheghi ghae Bajari tumonde bainghaore! Ghamo dadada ghururari nundae ivuga aore! ");
INSERT INTO kpr_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Nu janje eko totoi totoi eraira. Ava sedo, erama janje eko edo nimo sari totoi totoi ambeoso dae sedo, God da Mandikena kauboi dadarigedo tumonde bainghe! Mave numokena ambo sose feteraira amo, ivugaghae irarira. ");
INSERT INTO kpr_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Arie, Bajari, nanda gitofu digarigo eredo, namokena osogo bu refera. ");
INSERT INTO kpr_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Ne namoá ava sise eminge resera, “God ni jo sonembae arira.” ");
INSERT INTO kpr_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Avata arie, Bajari, ni sifo ghousa evia inono nanda dara jokáda nanda beredae buraena. Ni nandae ninda duró muturaesa. Edo nanda fakina mutari kato nimori. ");
INSERT INTO kpr_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Na Bajari da sonembadae kori sirureono, nu nunda doriri kakara aminda irise, nanda kori ningiraira. ");
INSERT INTO kpr_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Na tumba ghousa eveva aviraena da beká mo, Bajari nu na kaifa eraira. ");
INSERT INTO kpr_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Nanda gitofu nanjogoimi na jimbe birurugherera aindae, na jo oju ae arena. ");
INSERT INTO kpr_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Arie, Bajari, ere fu! Namo sonembase, nanda God! Nanda gitofu sovoda dege, nenda fakina rojare! ");
INSERT INTO kpr_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Sonemba mo, Bajari kena ghe foa gheraira. Nunda esimbugari nunda natofokena irare! ");
INSERT INTO kpr_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Arie God, nanda sorega kato, na nimokena benunu sarena, ningi! Na dara jokáda tereteno, nine sonembusesi. Oroko eminda nandae joka edo nanda banungari ningi! ");
INSERT INTO kpr_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Ne ghousa mavega ava nanda binodae bengoso arevu? Ne ghousa mavega ava god beká irae dubo ruruse, amboda amboda arevu? ");
INSERT INTO kpr_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Kasama evu, evetu genembo eveva ava, Bajari nunda tofodae sedo gategusira. Ava sedo na numokena kori seraena amo, nu ningiraira. ");
INSERT INTO kpr_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Erá janje ekoghae irise, aimi ari ekoko eose! Aindae ninda avari vasada fase irise nanda geka evia durumugedo kote gogoghombe! ");
INSERT INTO kpr_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Bajari da joba beká ava mutaresa. Aminguse, ninda tumondari numokena fitaresa. ");
INSERT INTO kpr_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Natofo digari benunu seraera, “Arie, Bajari, ninda esimbugari mokogo namanekena bofu! Arie, Bajari, ninda kavevera aimi, namane fuge garesa.” ");
INSERT INTO kpr_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Avata, ivuga nine nandae futusesa amo, teriagori. O ne faravada vuji a asi vaini da muká bambudo kirumo use, ivuga eraera amo, jo amingo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Arie, Bajari, na nanjigo fasarena, dubo jamaghae avarena. Ai resira amo, nisuka, nine na kaifa tavo eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Arie Bajari, nanda geka memaghae setena, ava ningi! ");
INSERT INTO kpr_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Nanda God a Kini, na sonembadae koko resena, ningi! Arie Bajari, na nimokena banungerena. ");
INSERT INTO kpr_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Ataeghae beká nanda beka niningeresa. Na tofo simbugedo, iji kosughiri, na nimokena benunu sise, mino saso ningari dae kaifa erena. ");
INSERT INTO kpr_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","God, ari ekoko embo rea eraera ava ni imboe eraesa. Ari eko da aito ninda dombuda itako jo fetae arira. ");
INSERT INTO kpr_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Ni ivuga kakato imboe eraesa, kotugo ari ekoko embo gari beghagha beká eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Ni gungubo kakato isasambu urureaso, sirivo eraera. Kotugo, mave kokomana de gogorogheraera, nébarago imboe beká ava eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Avata, ninda dubo bari tomanako aindae na ya ninda kamboda tereraena. Na ninda kambo kakarada tere banunguse, igheghighae tumonde baingheraena. ");
INSERT INTO kpr_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Bajari, nanda gitofu digari bekári. Giti jijighururaso, ninda uju ava aone! Ninda emboro namokena ijugaso isagha ururari gosuse, ainda amboda amboda aone! ");
INSERT INTO kpr_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Nanda gitofu da geka jo itako tumondari da kaugo iraeri. Ne, reju irira isambu, de tisari dae kotise irá gheraera. Nenda geka mo, vivi futo bekári. Avata, nenda kokomana dederuse daoro sirivo aoro dae kotise irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Nenda dara aindae nemoá bu memakena fitaso itatama use, ghamo baeteri. Ne reju ari kotise manaka gayeraera aimi, totofo nemoa gambari sirivo aeteri. Ne ari ekoko futo use, nimokena osogo eraera ágido, ondi, ninda dombuda do darigaore! ");
INSERT INTO kpr_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","O evetu genembo nimokena ambo sose fetarera amo, ivugaghae irore dae resena. Sifo ghousa evia dubo jamaghae yaru sise irá ghedo ghaore! Mave ni dubo buraira ava ivuga aoro dae sise, tavo e! ");
INSERT INTO kpr_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Geka bekári, Bajari, mave ninda sari ava eraera amo, nine esimbugeraesa. Ninda dubo bari bere amingo aimi ne gagara eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Arie Bajari, erá nandae janje eko use na dombuda seose! Ninda dubo ekoko ariimi erá nandae mema muteose! ");
INSERT INTO kpr_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Arie Bajari, namokena fakina dadabetira, nandae joka aetesi. Na gofedo irena, ava sedo fakina bofu baone. ");
INSERT INTO kpr_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Nanda jebuga isambu fakarago, dara bouvugo beká ava itatama eraena. Arie Bajari, ni nanjigo nembo na sonembaresi? ");
INSERT INTO kpr_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Fu, na sonembase! Bajari, nandae joka use, erá ambeono dae sise, na saghimbe bu! ");
INSERT INTO kpr_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Ambari embo da vasa aminda mave ni jo kotae eraera. Aminda mave eniimi nindae jo sakai sae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Na dubo mema aimi tumba evia mema itatama use, gevei erena. Nanda avari vasa jivui safegeraira. Nanda guto jivuimi sasaka eraira. ");
INSERT INTO kpr_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Gitofuimi mema futero na sorara eno diti babojegetiri, gari erebunena. ");
INSERT INTO kpr_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Bajari, nanda sorara ningira. Ava sedo, ari eko embo nemokena resena, na do darige esike fetevu! ");
INSERT INTO kpr_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Namo sonembare dae sorara eraena, nu nininguse, nanda benunu da mino muturaira. ");
INSERT INTO kpr_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Nanda gitofu mo, ne meka gosuse manamana arera. Edo, dudukughe manamana ururoro, ondari darigarera. ");
INSERT INTO kpr_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Arie Bajari, nanda God, na nimokena ambo sose fetari dae refena. Mave na ondi dari dae erera ava, na saghimbe bu, darigaone! ");
INSERT INTO kpr_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","O jo sonembae aresa amo, nanda gitofu raiyoni (lion) da kaugo use, na bu ya sonemba irae vasa aminda gambu torere tarere ghaoro ambarena. ");
INSERT INTO kpr_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","4","Arie Bajari, nanda God, nanda komanakena dara o aito aetena, o susu tefo nanda gitofu sosighi aetena, avavaga aetena amo, ");
INSERT INTO kpr_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","ninda ghabu sokinimbe, gitofuimi na ondi sandi budo, atai fati gitoro fonja dikai gambu fase ambaeteni. ");
INSERT INTO kpr_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Arie Bajari, nanda gitofu dubo ekoko use, namokena isoro ari dae erera. Ava sedo, ere fetedo ninda janje eko da fakinaimi sorega fumbaetesi. Arie God ere, na soraetesi! Inonoda ijujaso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Aminguse, evetu genembo isambu bu fu tatedo, ukuge gosuse, kaifa ase! ");
INSERT INTO kpr_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Bajari nine fu, endada natofo isambu ijujase! Arie Bajari, na ijujaresa amo, nanda eveva mavego eregosesa ava kotaetesi. Arie, God Iká Bekáda, na dara eni jo ae ava kotise, nandae “eveva” saetesi. ");
INSERT INTO kpr_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Arie, God evevago a numo beká nimori. Namanenda kotari a uju ava gosuse ijujeraira da God barago nimori. Evetu genembo ari eko eraera amo, se doyore! Aminguse, ari eveva embo ava sonembe! ");
INSERT INTO kpr_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","God Iká Bekáda amo, nanda bereri. God daba aimi, mave nunda geka ningiraira ava, sonemberaira. ");
INSERT INTO kpr_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","God nu bekáda bekáda ijujuse, ari ekoko embo da mino sifo evia inono muturaira. ");
INSERT INTO kpr_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Nenda ari ekoko jo doyae arera amo, God nemoa dari dae sise, nunda kaiya vegedo, nunda feva jighi otombe asi bu asugedo, ");
INSERT INTO kpr_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","isoro da ambi goroba simbugedo, feva da goroba mendo buburaghae aimi kato arira. ");
INSERT INTO kpr_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Givu! Ari ekoko embo ne ari eko da emboro rerebuse irera, kotugo, dara use komana derari dae sedo manaka garuse irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Avata nenda geka gunguboimi evetu genembo mendeni deraetera aimi, jovereghedo nemoa gambarira. ");
INSERT INTO kpr_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Ainda mino ava buraera. Kotugo nenda dara eraera ainda bouvu ava jovereghe nemokena asugeraira. ");
INSERT INTO kpr_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Bajari dambu ijujuse, bekáda bekáda mino muturaira aindae, aiyakoe resena. Na Bajari Iká Bekáda aikena yaruimi didivuse sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Arie, Bajari namanenda Bajari Ninda javo teria ainda bino ava ivegedo iri, reighi isambu niningerera. Nindae sakai seraera amo, viti ya utuda buvuraira. ");
INSERT INTO kpr_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Sasingako a ami mindari aimi, nindae sakai sise yaru divuraera. Ninda gitofu isambu, jo eniimi inono edo, ni dae arera. Evetu genembo mave nimokena osogo eraera, avata ninda fakinaimi buregeraesa. ");
INSERT INTO kpr_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Utu nine usesa ava, a inua a damana nine nunda vasada fifitusesa ava, na fuge gido, ");
INSERT INTO kpr_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","yove seraena! Ata, genembo mo, rejori? Nu jo rejo eni iraeri, ava sedo, ni redae nu koteraesi? Nu taká tefo genembo ava sedo, nu redae bu tavo tatau eraesi? ");
INSERT INTO kpr_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Avata ni eteso genembo sirorusira amo, ninda duruda, bajari edo irira. Numokena usasa, duró, a bino ava, nine kavevera edo futusesi. ");
INSERT INTO kpr_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Ni nu gategedo seteso, nu roera isambu nine eteso sirorusira, ainda bajari ava, nune edo irira. ");
INSERT INTO kpr_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Roera resena emo, sifi burumakava a sino fuka taima jokáda irá gheraera, ");
INSERT INTO kpr_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","rika ikáda ghumburaera, oka, a eva da roera isasambu, ainda bajari, nune edo irira. ");
INSERT INTO kpr_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Arie, Bajari, namanenda Bajari. Ninda javo teria ainda bino ava ivegedo iri, reighi isambu niningerera. ");
INSERT INTO kpr_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Arie Bajari, na janje isambuimi nindae sakai sarena. Nanda gae gitida rea eteso sirorusira ava osa sarena. ");
INSERT INTO kpr_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Arie, Bajari, God Iká Bekáda Iresa na nindae ivugaimi tamo erari beká erira. Na nindae sakai sise, ninda javo jighono erarira. ");
INSERT INTO kpr_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Ni nanjigo buvuraesa amo, nanda gitofu ojuimi sumbudo du ambu fafaseraera. ");
INSERT INTO kpr_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Ainda susu mo, ninda anumba vasada anumbedo, bekáda bekáda ijujuse, nanda sari ava bekáva kasama edo na sonembetesi. ");
INSERT INTO kpr_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Nunda oro oro ekoko use, ni jo tumondae eraera ava, ni bu ambari kena fitesi. Ne sosighi beká ava etesi, nine nenda javo ghaje fugeteso binó irae beká ava etira. ");
INSERT INTO kpr_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Arie, namanenda gitofo makoe vekaghae museteri, nine nenda reighi sosighi e jighi jovereghari beká etesi. Ne amboda eniimi jo kotae arera. ");
INSERT INTO kpr_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","O Bajari mo, nu kini (king) edo, evovodae irira. Nu evetu genembo ijujari da vasa e vatetena etiri fetirira. ");
INSERT INTO kpr_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Nune evetu genembo isasambu dambu dambughae ijujuse, evetu genembo isasambu bekáda bekáda use kaifa arira. ");
INSERT INTO kpr_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Bajari mo, nu evetu genembo babate binó tefo ainda ambo sosari vasari, evetu genembo mendeniimi nemokena mema muturaera ainda sifoda, numo nenda jungari vasa kíkanghari bekári. ");
INSERT INTO kpr_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Bajari mave ni kasama erera amo, nenda tumondari nimokena fifiterera, Ai resira amo, mave nimokena furaria amo, eni jo imboe ae aresa. ");
INSERT INTO kpr_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Arie! Bajari ututu Saion aminda anumbirise, nunda natofo kaifa eraira aindae, isimbaore! Nu rea usira ava, natofo isambu kena isagha saore! ");
INSERT INTO kpr_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Kikita mo, God da tofori, ororo gutuse sorara eraera aindae kotise, mino mutarira. Nenda mema mave erefutira ainda mino ava, God nune mutarira. ");
INSERT INTO kpr_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Arie Bajari, nanda gitofu nandae mema muturaera, ava gaetesi! Arie Bajari, nandae joka edo, erá doyeoso ambeone! ");
INSERT INTO kpr_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Aso, na Jerusalem embo da dombuda fete, nindae sakai resena da beká saono ne ningarera. Edo, na sonembusesa aindae, ivuga arena. ");
INSERT INTO kpr_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Oro mendeni mave ni jo tumondae eraera aimi, bako ghambudo, aminda totofo du vovosegeteri. Ne totofo nenda vaghoda teretero nemoá fatira. ");
INSERT INTO kpr_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Bajari nange bekáda bekáda ijujeraira aimi, nu mavejuri, ava ijugeari kasama eraera. Nune etiri, ari ekoko embo ava, totofo nenda vaghoda teretero, aimi fatira. ");
INSERT INTO kpr_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Ari ekoko embo isasambu ambari embo da vasada vosarera. Oro mave God imboe eraera isambu, aminda vosarera. ");
INSERT INTO kpr_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Avata makasi embo da mema amboda God kote simbugarira. Kotugo makasi embo da gigitari ava beká arira, jo dadabae arira. ");
INSERT INTO kpr_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Arie Bajari, ere fu! Erá doyeoso, natofoimi ninda geka bu fugeure! Oro mave ni jo tumondae eraera ava, bu fiti, ninda dombuda fetoro, nenda ari ekoko ainda mino ava mutu baore! ");
INSERT INTO kpr_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Arie Bajari, nemoá jo God iraeri, ne taká tefo evetu genembo ava kasama aoro dae sise, aso ne ojuimi ghamo takeghari itatama aeteri. ");
INSERT INTO kpr_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Arie Bajari, ni redae soka beká fefeteresi? Namane dara itatameraera da sifoda, ni redae tofo jungeraesi? ");
INSERT INTO kpr_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Ari ekoko embo gogore use, evetu genembo vagho fitiraera aminga ava use, makasi embo nenda derariimi sandido, nemokena mema erefutera. ");
INSERT INTO kpr_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Ari ekoko embo amo, ne oduso use, dighighi eraera, aindae totofo sakai seraera. Dighighi kakato amo, Bajari dae jijivu sise, numokena gukai muturaira. ");
INSERT INTO kpr_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Ari ekoko embo nenda gogoreimi misurugururari, Bajari dae jo igheghi ae eraera, Ne gogore use, God iraeva seraera. ");
INSERT INTO kpr_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Ari ekoko embo roera reju eraera, ainda beká isambu siroreraira. God evetu genembo nange ijujeraera ava jo kasama ae use, kokomanekena dere jiraera. ");
INSERT INTO kpr_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Ne totofo koteraera, “Namane jo nanjigo gofae arera. Namane sifo ghousa ivuga use irarera, dara á itako jo foa namane bae arira.” ");
INSERT INTO kpr_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Nenda sarida mo, simbora ari, gungubo sari, kotugo katiyavara ari aimi bedo edo irira. Ne rea seraera aimi, dara bu foa gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Ne reighi tinguda jungedo iritirise, dara tefo embo ava daoro amboro dae kaifa gigita eraera. Ne mavejoá ufena daoro ambarera ava kato eraera. ");
INSERT INTO kpr_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Ne raiyoni (lion) da kaugo ava use, jungedo kato use kaifa eraera. Ne junge kato urureoro makasi embo foa, nenda vaghoda teterurureoro, sandi bu jumbu ya gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Nene, evetu genembo gogofegari ava sandeoro, du de sirivo e fafaseoro nenda fakina dadaberaira. ");
INSERT INTO kpr_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Ne totofo koteraera, “Namonde rea eraera ava, God jo kotae ari ava,” seraera. “Nu diti gajedo itako jo gae eraira.” ");
INSERT INTO kpr_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Arie Bajari, ari ekoko embo oindae mema mutu! Arie God, mave mema eretafera ava kotaetesi! ");
INSERT INTO kpr_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Ari ekoko embo nange nange kotise, God ighagha use, eminge seraeri, “Namokena mema jo mutae arira.” ");
INSERT INTO kpr_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Avata geka bekári: God, nene dara rea eraera, kotugo mema muturaera ava isambu ni gido, ainda mino mutari koteraesa. Evetu genembo gogofegari ne totofo ninda ungoda fitiraera. Sasingu babate ainda sonemba kato nimori. ");
INSERT INTO kpr_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Evetu genemboá ari ekoko eraera, ainda fakina ava de bejedo, nenda kosasa ainda mino ava futururaso, sirivo aore! ");
INSERT INTO kpr_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Bajari mo, kini edo evovodae irira. Evetu genembo god mendeni tumonderaera ava, nune sari, nunda reighi do dumbarera. ");
INSERT INTO kpr_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Arie, Bajari, ni gogofegari da benunu ava jave ningiraesa. Nenda sorara ningido nine ne sonembedo, fakina futuse eghovo deraesa. ");
INSERT INTO kpr_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Ari ekoko embo ava, nene katiyavara edo ghusera ava doyorodae sise, ni bate bagha a sabua da sorara ningido sonemberaesa. ");
INSERT INTO kpr_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Na Bajari tumonduse numokena ambo sose fetarena. Ágido, na gitofukena eminge saeteni, “Erá gogovara use, namokena eminge seose: ‘Rika da kaugo edo doririda ghumbu ya jungase!’” ");
INSERT INTO kpr_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Ai resira amo, gi! Ari ekoko embo itumuda jungutuse, nenda goroba fevada fifitige afedo, evetu genembo eveva ava gayari dae kato eraera. ");
INSERT INTO kpr_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Irari isambu beje soesa arira da sifoda genembo eveva nange ari? ");
INSERT INTO kpr_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Bajari nunda kambo kakara jokáda irira, Bajari nunda anumba vasa utuda irira. Aminda irise, evetu genembo tano reda reda endada irise, rejo eraera ava, ditimi gosuse kasama eraira. ");
INSERT INTO kpr_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Nu evetu genembo eveva a eko ava dere gosuse, mave agho dari bejise, de goroghari uju eraira ava, gari imboe beká eraira. ");
INSERT INTO kpr_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Nu imo buburago, imbosi eko masaghae ava muteari ari ekoko embokena vose foa gheraira. Nu yaura veverago aimi avari ghamo baoro dae muturaira. ");
INSERT INTO kpr_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Ainda beká mo, Bajari mo kosasa tefori, nu aito fugari eveva ava dubo buraira. Mave amingarira aimi, ne nunda dombu gosuse ivuga use irarera. ");
INSERT INTO kpr_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Bajari, namane sonembe! Nimo tumondari embo endada eni jo iraeri. Kotugo geka beká sari embo barago, eni jo tambari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Ne isambu tofo tofo gungubo sise irá gheraera. Ne kokomana dederuse, geka vivi futo seraera. ");
INSERT INTO kpr_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","4","Arie Bajari, mave geka vivi futo seraera, ava daso ambarera. Kotugo, mave totofo sakai sise eminge seraera, “Namondeda sari aimi namondeda uju ava barera. Namonde rea ava sarera, jo mave eniimi gajari da kaugo iraeri.” nembarago daso ambarera. ");
INSERT INTO kpr_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Avata Bajari resira, “Na furari dae javi erena. Ainda beká mo, evetu genembo mendeni, makasi embo ava sosighi edo mema muturaera, katiyavara urureoro gogofegari memaghae aoro sise irá gheraera. Na oroko eredo, sonemba uju eraera ava futuse, ne gagara arena.” ");
INSERT INTO kpr_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Kau auri siliva (silver) umbu 7 ava itioro avi jeka voseari, siliva beká isagha eraira, aminga ava Bajari rea beka gagojuse setiri fetirira ava foa isagha arira. ");
INSERT INTO kpr_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","8","Ari ekoko embo reighi isambu nemo vanembori. Ne meka gari da ari eraera, aindae sakai futo seraera. Arie Bajari, sifo ghousa namane kaifa use, evetu genembo avavagaikena kosegaetesi. ");
INSERT INTO kpr_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Arie Bajari, ni ghousa kau mavega ava na kotae aresi? Ai, kotae beká usesi. Ghousa mavega ava na nimo geono dae sise jungeraesi? ");
INSERT INTO kpr_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Atá ghousa mavega ava mema bouvu ghae irareni? Sifo tumba evia inono nanda ghamo joká memaimi bedo edo, irá gheraira amo, mavegori? Nanda gitofui na de atai fafotusera ava, na ghousa mavega irareni? ");
INSERT INTO kpr_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Arie Bajari, nanda God, namoá fuge gido, nanda benunu ningido, mino saetesi! Nanda fakina sekago mutaso baeteni, erá doyeoso na ambeone! ");
INSERT INTO kpr_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Erá doyeoso, nanda gitofuimi, “Namane nu de atai fateri!” seore! Kotugo, doyeoso, nandae, “Makoede, durira!” seore! ");
INSERT INTO kpr_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","O ni nandae veka eveva use, na dubo buraesa, aminda gaiga gayeraena. Na saso jebugarena aindae, na riria arena. ");
INSERT INTO kpr_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Arie Bajari, na nindae yaru divarena da beká mo, namokena veka eveva eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Mave tofo mandi “God tefo” erekotira amo, nu daghe irise, sari garera. Evetu genembo avavaga nenda dubo joká bebeta edo irera. Ne tafasara beká ava eraera. Eni jo ari eveva ae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Bajari utuda irise, evetu genembo fuge gosuse, evetu genembo dubo kotise numoa tumonde baingheraera ava, tava eraira. ");
INSERT INTO kpr_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Avata ne isasambu emboro eveva do dariguse ari ekoko eraera. Ne totofo bebeta edo irera. Jo dabakoimi ari eveva ae eraira, eniko tefo bekári. ");
INSERT INTO kpr_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Bajari resira, “Ari ekoko embokena kotari tefori? Ne nanda natofokena bagia use, namokena jo banungae eraera.” ");
INSERT INTO kpr_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Avata amboda ne ghamo takegha arira. Ainda beká mo, God evetu genembo nunda sari ava eraera ainde dabade, fetirari garera. ");
INSERT INTO kpr_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Ari ekoko emboi evetu genembo eveva ainda kotari a uju ava buregeraera. Avata evetu genembo eveva nenda ambo sose fetari da vasa Bajari numori. ");
INSERT INTO kpr_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Arie, jebuga Saion ghedo foa Israel embo kena sirorare! Bajari nenda ati ghayafa sekago mutari barera amo, Jacob da imemesiri, Israel embo, isasambu ivuga use irarera. ");
INSERT INTO kpr_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Bajari, ninda irari vasa kakara jokáda mave terari? Mave ninda ututu Saion aminda viti ya tumonde bainghari mo, inonori? ");
INSERT INTO kpr_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Genembo mave God da geka isambu ningido, sifo ghousa evia geka beká sise, ari dambo vanembo eraera, a nu avori. ");
INSERT INTO kpr_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Genembo amo nu kokomanakena aji jo sae eraira, a nemokena ari ekoko jo ae eraira. A nu nano namendidae unongu jo sae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Genembo amo, mave God imboe eraira, numbarago imboe eraira. Avata mave Bajari tumonduse, nunda sari avanembo eraera, genembo amo ne kakara eraira. Genembo amo evovodae nu rea beka gagojusira, ava eraira. Nunda beka gajari ava use, mema bouvu mavega itatama eraira aindae, nu jo kotae eraira. Nu rea ari beka gagojusira, ava ari sirorarira. ");
INSERT INTO kpr_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Genembo amo, nunda sonemba eraira ainda etoda, mino ainghae jo bae arira. Genembo amo, nunda komana eni ava koto sifoda genembo eni dara jo ae, aikena gungubo sare dae sise, moni mutari sarira amo, itako jo bae arira. Genembo mave ari avavaga use irarira amo, nu evovodae evevada fetarira. ");
INSERT INTO kpr_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Arie, God! Sonembe, gagara aso, na nimokena ambo sose fetone! Na ninda sonemba a kaifa tavo ari ava tumonderena. ");
INSERT INTO kpr_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Na Bajari kena eminge seraena, “Ni nanda Bajariri, roera eveva namokena irira ava, isambu nimokena-ghe foa gheraira!” ");
INSERT INTO kpr_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Bajari da natofo endada irise, nu tumonde gogoghomberaera amo, ne evevago a numo bekári. Nemo kotise, na ivuga e gogoghomberaena. ");
INSERT INTO kpr_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Evetu genembo mave god a sukaru mendeni tumonduse, nenda sonembadae sise, aminda sufuse irá gheraera amo, ne dara digari tamburaera. Avata ainda susu mo: nemori! Ava sedo, god a sukaru mendeni setena aikena, na jo joba futuse, ororo ava jo averegae arena, a kotugo na jo ne tumonde bainghae arena. ");
INSERT INTO kpr_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Bajari, nanda jebuga a sonemba ainda susu isasambu, nisuka nimori! Nine, rejo namokena daiva eraira ava, nine muturaesa. A kotugo, rea namokena amboda sirorarira ava, ninda ungoda irira ava sedo, nine kaifa eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Ni kavevera use, namokena joba muturaesa amo, eveva bekári. Ava kotise, eveva seraena. ");
INSERT INTO kpr_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Na Bajari dae sakai seraena. Ainda susu mo: na erá dara eone dae sise, nu nanda emboro ijuguse, tumbaghae nanda dubo jokáda geka sise, dengoro indiraira! ");
INSERT INTO kpr_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Bajari namokena sifo ghousa irira ava, na kasama use irá gheraena. Nu namokena ojira, utua fetirira ava sedo, jo rejo enii derari, na jo gofae, fete gogoghombarena. ");
INSERT INTO kpr_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Aindae sedo, na aiyako sise, ivuga beká ava use, dara a mema foa gheraira aindae, na jo itako oju ae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Ainda susu mo: ni na kaifa ururaso, ambari da fakinaimi jo namoá derae arira. Na ni tumonde gogoghombuse, ninda saramana eraena ava sedo, na jo doyaso ambari embode dabade sifo ghousa irá ghae arena. ");
INSERT INTO kpr_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Na nange jebuga tambaetena ava kotise, nine nanda emboro ijugaresa. Ni namonde dabade irá gheraera ava itatamuse, na ninda dombuda irise, riria beká ava use, evovodae ivuga use irarena. ");
INSERT INTO kpr_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Arie Bajari, na rea ava nimokena koko sise resena ava, ningi! Na geka beká seraena, ava sedo nanda benunu resena evia, jave ningi! ");
INSERT INTO kpr_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Koto sifoda namo ijujuse, nandae “kosasa tefo” saresa. Ai resira amo, ari eveva a eko mave eraera, isambu ni kasama eresa. ");
INSERT INTO kpr_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Ni tumbaghae fesa, nanda kotari a nanda janje joká fuge gosuse ijujusesa amo, nanda eko eni jo tambae usesi. Kotugo, nanda aviva kaifa use, reju seraena aminda barago, sembae eni jo sirurono ningae ri. ");
INSERT INTO kpr_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Na ninda sari ava use, evetu genembo ekoko a gogore a tafasara kakato ainda amboda jo yae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Na ninda kotuda fetirise, jo roimi dimbari durae edo ghuseni. ");
INSERT INTO kpr_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Arie God, na nimokena banungerena. Ai resira amo: na kasama erena, ni mino namokena saresa. Ava sedo, dengoro javuse, nanda geka ningase! ");
INSERT INTO kpr_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Arie, nanda Sonemba Kato, ninda dubo bari duroghaeimi ijuguse, na gitofuda ungoda saghimbe bu! Ai resira amo, mave ninda ungo gimandukena ambo sose fetarira amo, gitofudae jo oju ae arira. ");
INSERT INTO kpr_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","9","Evetu genembo nenda yeye kaifa eraera aminga ava, na kaifa edo gagara e! Erá, evetu genembo ekoko namokena tataya eraera, namoa deoro dae sise, ninda ghabuimi na gagara e! Ai resira amo, ne na daoro ambono dae sise, jimbi birurughedo irera. ");
INSERT INTO kpr_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Nemokena joka ari tefori. Ne totofo sakai futo sise, gogore eraera. ");
INSERT INTO kpr_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Ne na anakora jimbe birurughedo, namoa fugoro endada durono dae, goroto tava use irera. ");
INSERT INTO kpr_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Nemo kau laiyoniimi (lion) ari guse, namoa sosighi ari dae kato eraera. Kau raiyoni fakina kato ari guse, namoa ufena sandari dae kato eraera. ");
INSERT INTO kpr_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Arie, Bajari, ere foama, evetu genembo namoa, katiyavara eraera ava, nemoa dedo, atai fati fetaso dae resena. Ninda kaiya dika soveni soveni aimi, ari ekoko embo dege, darigaoro jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Arie Bajari, ninda sonemba da fakina aimi, na evetu genembo enda da irari ava nembo kotise, irá gheraera ainda ungoda saghimbe bu, jebugaone! Mino eko nendae sedo simbugusesa ava mutaso, mema ruruse itatama aore! Nemo, kotugo nenda sasingu barago, mino daba ava itatama ururoro, a kotugo nenda imemesiri barago ainda mema itatamarera. ");
INSERT INTO kpr_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Avata na ninda dombuda fetirise ni garena. Ainda susu mo, nanda irari dambugori. Na avi eroruse, dombu basari nangae minonde minonde gosuse, ivuga beká ava use irarena. ");
INSERT INTO kpr_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Arie Bajari, ni dubo ererurena. Nanda sorega a fakina mutari kato nimori. ");
INSERT INTO kpr_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Bajari mo, nu nanda sorega mutari katori. Numokena tere fetono, na gagara arira. Nanda God mo, sorega mutari kato bekári. A nu nanda sonemba kato fakinagori. Na numokena junge feteraena. Nanda bere mo, numori, a fakina nune futurureari jebuga eraena. ");
INSERT INTO kpr_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Bajari dae sakai resena. Na numokena kori seteno, na gitofuda ungoda ava sonembusira. ");
INSERT INTO kpr_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Ambari da fakina evagoimi na kosege birurughedo afurugusira. ");
INSERT INTO kpr_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Ambari da fakina aimi namoa kosege jimbe birurughedo, namoa ivasi fiti bari dae kato usira. ");
INSERT INTO kpr_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Na nanda dara jokáda irise, Bajari dae kori siseni. Nanda God kena sonemba dae soraraghae kori seteno, nunda kambo kakara jokáda irise, nanda beka niningusira. ");
INSERT INTO kpr_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Amingetiri, enda javi use daradaraghiri, doriri susu javi javi use, ginoginoghusira. Ainda beká mo, God janje ekoko usira. ");
INSERT INTO kpr_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Imbosi nunda mendo tokáda gubighiri, nunda bekada avaraka buburaghae oeno veverago ava buvurutusira. ");
INSERT INTO kpr_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Utu jighi torere afigedo, foroga ingago nunda ata duruda fiti ainghae vose fusira. ");
INSERT INTO kpr_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Nu nunda Serubim aminda anumbetiri, yauraimi bu ghufusira. ");
INSERT INTO kpr_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Numo tumba jokáda afuregedo, borija da foroga ingagoimi doghusira. ");
INSERT INTO kpr_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Usasa nunda dombukena jaragheraira aminda ghedo biria avaraka buburago avavagai tarighiri, borija dombu eni yaurago tamo ghamanago, foroga ingago jokáda ghe beje buvurutusira. ");
INSERT INTO kpr_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Aminguse, Bajari Iká Bekáda nunda beka duka utuda ghe gururu didiviri nininguseri. ");
INSERT INTO kpr_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Nunda feva da goroba aimi afetiri, nunda gitofu sisigaga useri. Nu setiri biria tarighiri, ne oju e sufuseri. ");
INSERT INTO kpr_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Arie Bajari, ninda gitofu dombuda sise, kovionoghae koko seteso, eva kafuru da duru saghe fasedo enda susu isagha usira. ");
INSERT INTO kpr_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Bajari nu ikáda ghe sirige, na karaje kafuruda ghe jumbarigetiri vivituseni. ");
INSERT INTO kpr_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Nanda fakina dadabetiri, na nanda gitofu fakina kakato da ungoda ireno, God na saghimbe rurusira. ");
INSERT INTO kpr_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Dara ainda sifoda, ne na dari dae sufusera, avata Bajari na gagara usira. ");
INSERT INTO kpr_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Bajari nandae riria eraira aindae, nune sonembedo na budo jebuga vasada fitiri jebuguseni. ");
INSERT INTO kpr_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Na ari dambu use irá gheraena, aindae, Bajari nandae mino eveva muturaira. Namokena kosasa jo tambaeri, ágido na esimbugusira. ");
INSERT INTO kpr_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Na Bajari da Agho Dari rea resira ava useni. Na nanda God kena jo ari eko eni edo, gukai mutaeri. ");
INSERT INTO kpr_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Na nunda Agho Dari rea resira isambu kaifa useni. Na nunda sari eni jo kosasaghaeri. ");
INSERT INTO kpr_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Na ari eko eni jo ae eraena amo, nu kasamari. Amo na tofo ari sembae ari ava reeta eraena. ");
INSERT INTO kpr_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Na ari dambu use irá gheraena aindae, nu nandae mino eveva muturaira. Ai resira amo, na dara jo ae eraena, nu kasamari. ");
INSERT INTO kpr_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Arie Bajari, evetu genembo mave ni tumonduse irá gheraera, nemokena ninda beka gajari ava eraesa. Nimokena mave bekáda bekáda use, irá gheraera aikena, veka eveva eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Mave da irari forosogo beká ava irarira aikena, ni kavevera beká eraesa. O genembo mave aito eko fugeraira aikena mo, ni aito fugari eko beká eoso itatama eraira. ");
INSERT INTO kpr_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Ni tumbari embo ava sonemberaesa, o ivuga use totofo sakai seraera amo, eoso tumberaera. ");
INSERT INTO kpr_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Arie Bajari, nine nanda tumba emo jighi tonenembedo, nanda usasa muturaesa. ");
INSERT INTO kpr_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Gitofo nanjogo irera, ava daono dae sise, fakina nine muturaesa. Kotugo, gitofu da furu jarigari da fakina barago, nine muturaesa. ");
INSERT INTO kpr_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","God emo nu rea eraira amo, dambugo bekári! Nu rea seraira, ainda beká siroreraira. Mave numokena junge feteraera, ainda bere mo, numori. ");
INSERT INTO kpr_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Bajari nusukako numoa God ri, eni tefori. Namondeda sorega mutari kato, God nusuka numori. ");
INSERT INTO kpr_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","God nune eari, na fakina eraena. Nune eari, na emboroda kotae kotae ya foa gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Nune eari, na ata fete simbugeraena. Nune kaifa urureari na doririda jebuga deingheraena. ");
INSERT INTO kpr_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Isoro tataya aono dae sedo, nune na ijugeraira. Feva auri ari ava jighi otombedo goroba afari da aito ava ijugeraira. ");
INSERT INTO kpr_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Arie Bajari, nine gagara use, na sonembusesi. Na kaifa eso, binode edo irena. Ninda fakina tomanakoimi namoa kosegiri irena. ");
INSERT INTO kpr_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Na ondi kosege sandaetera ava, nine tavo eso, na jo gofae useni. ");
INSERT INTO kpr_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Nanda gitofu ondi sandi bambu tefo edo, isambu deteno sirivu useri, eni jo doyono jebuga yae usira. ");
INSERT INTO kpr_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Nane ne deteno du fafasusera amo, sekago jo erae arera. Nanda dombuda du ambu fafasedo irera. ");
INSERT INTO kpr_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Nine isoro ari da fakina ava, namokena futusesa aimi, gitofu de atai fati fefetuseni. ");
INSERT INTO kpr_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Nine eoso, nanda gitofu na do sumburaera. Mave na imboe gambue usera ava, nane de sosighi useni. ");
INSERT INTO kpr_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Ne sonembadae koko siseri, avata mave jo sonembari jebugae useri. Bajari kena kori siseri, avata nu jo ningae usira. ");
INSERT INTO kpr_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Ne fati jaseteno, kau fonja yauraimi fuseari ya dadaberaira, ainda kaugo useri. Ne, kau emboroda tauya fatiraera, aminga ava useni. ");
INSERT INTO kpr_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Evetu genembo gogore kakato eredo, namoa dari dae kotisera ainde isoro eno, na sonembeteso jebuguseni. Nine seteso na oro mendeni mendeni da bajari edo irena. Evetu genembo na berefoá isambu nanda sari ava eraera. ");
INSERT INTO kpr_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Teana embo nandae igheghi edo, nanda dombuda tumoi bainghuse, nane rea seraena, ava eraera. ");
INSERT INTO kpr_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Ne rojedo, ungo ata dadara garuse, nenda jungari vasa do buvuraera. ");
INSERT INTO kpr_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Bajari evovo dae irira, nanda sorega mutari katodae sakai saore! God namo sonembeari jebugeraena, ainda binó ava sakai sise, nunda javo jighono ikáda erare! ");
INSERT INTO kpr_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","God nandae gitofu de atai fati fetari da fakina ava muturaira. Oro mendeni mendeni nune fitiari vosedo, nanda ata duruda irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Nune namoa gitofu kena sonembeari jebugeraena. Arie Bajari, nine na gagara urureaso, nanda gitofu janje ekoko ari kakato de atai fati feteraena. ");
INSERT INTO kpr_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Ava sedo, Bajari, na oro mendeni mendeni jokáda irise, nindae sakai seraena. Yaruimi didivuse ninda javo jighi eono ereraira. ");
INSERT INTO kpr_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","God nune de atai fati fetari da fakina ava nunda kini dae muturaira. Kotugo nunda dubo bari ava, Kini David edo nunda imendi gamendikena evovodae ijugudo yarira. ");
INSERT INTO kpr_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Utu enda God etiri sirorusira ainda jokáda, God da usasa iri eregosena! Nu kau nangega etiri sirorusira amo, isagha beká iri eregosena! ");
INSERT INTO kpr_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Eri! Ungobu use tumba jireari, inua a damana janimberaira, a sifoghae sifo ate areghurureari ainda jokáda, na God da duro ava gosuse koteraena. ");
INSERT INTO kpr_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Iji, inua, a damana mo, geka vironu jo sae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Avata nenda duro, evetu genembo reda irera, isambu gi kasama erera. Utu mo, iji da irari vasadae God esimbugusira. ");
INSERT INTO kpr_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Iji da duro mo, kau gimasa nunda datu gagara unumbari dae sedo, gogho edo, kamboda ghe foa buvuraira, ainda kaugori. ");
INSERT INTO kpr_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Nu sovenikena vitido, ya jarige sovenikena voseraira. Nunda usasa a vevera mo, ave jo darigari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Bajari da Agho Dari jo sembae iraeri, isambu eveva vanembori. Ningarena amo, na ivugaghae irá ghedo gharena. Ningido tumondarena amo, na jo gofae arena. Genembo kotari tufako ningarira amo, jiro afigari dubo kotarira. ");
INSERT INTO kpr_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Bajari da Agho Dari isambu, beká avanembori. Na Agho Dari amo ningido amingarena amo, na ivugaghae irá ghedo gharena. Bajari da Agho Dari amo, inono a dambu bekári. Kotarena amo, munju afigarira. ");
INSERT INTO kpr_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Bajari da tumonde bainghari mo, evevagori. Sifo ghousa, aminguse irarena. Bajari ijujeraira amo, nu inononda ategi eraira. Geka beká seraira amo, evovodae irarira. ");
INSERT INTO kpr_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Bajari dae uju use, mamaso ari mo, jo kau auri “gold” evevago a finje da firukago iraeri. Roera resena emo, kikitakori. Nu mindafu bekári. ");
INSERT INTO kpr_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Na ninda saramana katori. Na ninda Geka a Agho Dari tegarena amo, kotari seka sirorari barena. Ninda Geka jokáda rea resira ava arena amo, na jebugarena. ");
INSERT INTO kpr_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Na ari ekoko mendeni usena ava kotae edo, jo vujegae irena ava, nine giraesa amo, joka edo, kote doyaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Na tavo use buregururaso, erá eko eniimi foa dereuri, na gofedo gogore eone! Amingururaso, na ari eveva avanembo aone! Erá ari eko teria irira aimi, na unumbeuri eko beká ainda jokáda teredo ambeone! ");
INSERT INTO kpr_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Sonembururaso, na dubo kotise, geka eveva avanembo sirurono ningido, ivuga aetesi! Arie, Bajari, ni nanda jebuga kaifa eraesa, a na sonemberaesa. ");
INSERT INTO kpr_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Namanenda kini (king), ni sifo reda dara jokada fetaresa, Bajari ni sonembare! Namanenda abua Jacob da God tumondedo ghusira aimi, nimoa gitofukena kosege fetare! ");
INSERT INTO kpr_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Nunda Tafaroro Ari Kambo kakara aminda ghe sonemba nimokena mutare! Nunda sonemba ututu Saion aminda ghe mutari fuse, ni sonembare! ");
INSERT INTO kpr_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Nu, ninda fuyo erefutesa isambu eindae dubo eveva are! Kotugo, ninda sino fuka de ojedo joba dunguteresa isambu eindae, dubo jama use ivuga are! ");
INSERT INTO kpr_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Ninda janje jokáda rea uju eraesa, edo rea ari dae koteraesa ava, isambu futururari beká sirorare! ");
INSERT INTO kpr_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Nine gitofu dedo atai fati fetaresa aindae, namane ivugaimi fumbu aruguse, divu fusedo ghuse, namondeda God dae sakai saore! Ni rejudae benunu saresa, ainda mino mutare! ");
INSERT INTO kpr_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Oroko ava na kasama erena, Bajari nunda kini gategusira ava sonemburureari gitofu de atai fati feteraira. God nunda irari vasa kakara utuda irise ningido, nunda fakina tomanako ava futurureari, nunda kiniimi gitofu de atai fati feteraira. ");
INSERT INTO kpr_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Evetu genembo mendeni mo, isoro sifoda nenda tumondari nenda founa ghasemo javo sariot (chariot), a nenda sino fuka javo hosi aminda fifituse irera. O namonde mo, gitofo dari da fakina bari dae sise, Bajari namondeda God ava tumonduse irera. ");
INSERT INTO kpr_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Mave tumondari nenda ghasemo sariot seraera, o nenda sino fuka hosi seraera aikena fitiraera, ne dudo gogofegarera. O namonde mo, ere fetedo, fakina e fetarera. ");
INSERT INTO kpr_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Arie Bajari, namanenda kini sonembaso, gitofu de atai fetare dae resera. Namane sifo reda nimokena banungarera, ningi! ");
INSERT INTO kpr_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Arie Bajari, ninda fakina futusesa aindae, kini ivuga erira. Ni sonembeteso, gitofu sosoghi e rurusira aindae, ivuga tomanako beká erira! ");
INSERT INTO kpr_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Nunda janje jokáda rea uju usira ava futusesi. Rejodae benunu sisira ava, jo jighi jijinimbaeri. ");
INSERT INTO kpr_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Nu buvurutiri, ni ghaito tero fugutuse joba numo bekáimi esimbugusesi. Aminguse, kotofu da kekesa auri goldi (gold) numo beká aimi ari ava bu, nunda jiroda asugusesi. ");
INSERT INTO kpr_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Nu nimokena jebugadae benunu setiri, ni jebuga evovodae irari ava futusesi. ");
INSERT INTO kpr_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Ni sonembusesa aimi, nu duró usira. Nine sonembeteso, nu binó a duró budo irira. ");
INSERT INTO kpr_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Geka bekári: ninda esimbugari evovodae numokena irira. Nu ninda dombuda irira aindae, ivuga use irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Kini nu Bajari Iká Bekáda ava tumonderaira. Bajari nu kini barago dubo buraira aindae, jo rejoimi nu derari durae arira. ");
INSERT INTO kpr_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Nunda gitofu isambu sandi barira. Natofo numokena osogo futo use irera isambu sandi bambarira. ");
INSERT INTO kpr_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Numo buvarira da sifo aminda ne avaraka bubura da vevera aimi dungari avarera. Bajari, janje eko edo, avaraka mutari, ne avarira. ");
INSERT INTO kpr_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Kini nune, nenda sasingu isambu dari sirivo e tefo arera. Enda eminda nenda imemesiri gamemisiri ava eniko jo irae arera. ");
INSERT INTO kpr_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Kotugo, numokena osogo use, kotari ekoko ava manaka gayeraera, avata beká jo sirorae arira. ");
INSERT INTO kpr_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Nunda feva aimi nemokena afari gido, ne jovereghe oju sumbarera. ");
INSERT INTO kpr_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Arie, Bajari, ninda fakina tomanako aindae, ni jighoro eraresa. Namane ninda fakina aindae sakai sise, yaru divarera. ");
INSERT INTO kpr_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Nanda God, nanda God, redae na dotutusesi? Namo sonembaso dae sorara janjagughae use janje gagojusira, avata ni redae na jo sonembaeri? ");
INSERT INTO kpr_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Arie, nanda God, na ijighae nimokena kori seraena. Avata, nanda kori jo ningae eraesa. A na tumbaghae barago kori sise, jo avae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Avata Kini kakarago beká nimori. Israel embo nindae sakai sise, ninda javono gatise jigheoro ereraesa. ");
INSERT INTO kpr_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Namanenda abua mane nimoa tumondedo ghuseri. Nenda tumondari nimokena fifiturureoro, nine sonembeoso jebugedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Ne dara jokáda fete irise, nimokena seoro, sore bu esike ya ghedo ghusesi. Nenda tumondari nimokena fifitusera, ainda beká siroretiri ivuga useri. ");
INSERT INTO kpr_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","O namoako mo, jo genembo iraeri, sivoro da kaugori. Evetu genembo isambu namoa gi sari futo use dere jiraera. ");
INSERT INTO kpr_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Evetu genembo mave namo giraera amo, ne isambu namoa dere jise, aviva sanambughuse gifoa gitorotoro eraera. ");
INSERT INTO kpr_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Gegha jise seraera, “Genembo nunda bouvu mema Bajari kena fifituse, gaiga numokena gayeraira, nangetirai jo sari jebugaeri? Bajari nundae ivuga ariá seraira. Nangetirai nu sonembaeri?” ");
INSERT INTO kpr_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Bajari, bebede ninda sonemba namokena emingusesi! Namo nine aya da tini jokáda bu fesa jebuga siroruseni. Kotugo, na ami rise ireno, nine tavo eso babojuseni. ");
INSERT INTO kpr_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Na sirorusena ai tano, nanda gaiga nimori, kotugo God na sifo ghousa tumondudo refena amo, nisuka nimori. ");
INSERT INTO kpr_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Dara buvari dae erira. Erá na do darige esike yeose! Mave eni na jo sonembae arira. ");
INSERT INTO kpr_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Nanda gitofu kau burumakava da kandana aminga aimi na gayari dae erera. Namoa nene jimbe birurugheteri, kau burumukava babaigo Basani Frovensi iritirira, aimi ari gerera. ");
INSERT INTO kpr_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Nenda beka fafangegerera ava kau laioni (lion) imi oka bayau budo gangara sise, gambu torere tarere gheraira, namokena amingerera. ");
INSERT INTO kpr_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Nanda fakina dadabetira. Kau uvu endáda averegari getira. Nanda etu isambu didisugaetira, aminga ava, nanda kotari dadabetiri, bune jarutuse irena. ");
INSERT INTO kpr_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Nanda fakina kikisa gharaseraira aminga ava dadabetira. Nanda aviva saghedo viti beka ikáda takegha erira. Amingiri, namoa ambono dae fonjada fuge dotesi. ");
INSERT INTO kpr_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Gegenembo ekoko aimi na kosege, sino maneimi ariguse, nanda ungu ata gae babasigerera. ");
INSERT INTO kpr_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Nanda tamo jokáda etu isambu tege tefo ari inonori. Nanda gitofu namoa tataseguse irera. ");
INSERT INTO kpr_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Ne nanda tamo asugari dae kikindoro garuse soroé barera. ");
INSERT INTO kpr_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Arie, Bajari, erá na do esike yeose! Tavaraghe fu, na sonembase! ");
INSERT INTO kpr_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","21","Gitofo amo isoro da kaiyaimi na jaoro ambono dae eraera aikena, na sainghimbe bu! Mendeni gambari sino o laioni (lion) da kaugo namoa gambari dae use irera. Mendeni, burumukava kandana aminga ava na koreimi gayari dae use irera. Namokena nenda dombuda fakina tefori. Ágido, na sonembaso jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Aso, na nanda natofo da dombuda nindae sakai sise, ninda javo jighono erare! Na natofo totorugarera ainda jokáda ere fetedo, nindae sakai sise, ni rea usesa ava osa sarena. ");
INSERT INTO kpr_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","“Bajari da saramana kakato, nemokena resena, nundae sakai sevu! Jacob da imendi gamendi numoa kakara evu! Natofo Israel embo numoa tumonde bainghevu! ");
INSERT INTO kpr_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Nu mave mema aimi jarutuse sorara eraera ava, jo imboe use, gi gagairego ae eraira. Nu nemokena gukai mutarigo itako jo ae eraira. Nanjigo sonemba dae kori seraera amo, nu ningido sonemberaira.” ");
INSERT INTO kpr_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Beká resena, natofo ninda dombuda totorugururoro, ainda jokáda na ere fetedo, ni rea usesa, aindae ninda javo jighono erarira. Natofo nimoa tumonde baingheraera ainda dombuda, na ere nimokena sino fuka rea joba mutari beka gagojusena, ava futuse dungono avarira. ");
INSERT INTO kpr_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Amingaono, makasi embo nenda uju ava inonoda mindarera. Mave Bajari uju use foa totorugarera aimi, nundae sakai sarera. Nenda janje joká ivugaimi bedo are! ");
INSERT INTO kpr_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Endada evetu genembo Bajari kotae usera, aimi sekago kotarera. Evetu genembo utu gambari utu gambari irera, aimi jovereghe numokena furarera. Endada oro oro isasambu numoa tumonde bainghedo gharera. ");
INSERT INTO kpr_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Ainda beká mo, reighi isasambu da kini mo, Bajari numori. Ne isambu nune kaifa eraira. ");
INSERT INTO kpr_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Gogore kakato endada irera isambu aimi numokena tumoi baingharera. Kotugo, evetu genembo endada irera isambu nébarago, numoa tumonde baingharera. ");
INSERT INTO kpr_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Maveju maveju sifo amboda sirorarera, némbarago numoa tumonde baingharera. Ai resira amo, evetu genembo oroko irera aimi Bajari da binó ava nenda sasingukena siruroro ningido, nenda imemesiri amboda sirorarera aikena, osa saoro ningarera. ");
INSERT INTO kpr_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Bajari nange nunda natofokena jebuga futusira ava, evetu genembo amboda sirorarera, aikena barago, nene osa saoro ningarera. ");
INSERT INTO kpr_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Bajari nu nanda kaifa katori, namokena isambu inonoda muturaira. ");
INSERT INTO kpr_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Nu nandae vasa eveva simbugeari janguteraena. Janguteono, nanda Giti Jighari nune nanda emboro ava ijugeraira. ");
INSERT INTO kpr_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Emboroda, uvu bayau futurureari, jebuguse dubo jama eraena. Na nange nange ari eveva aetena ainda emboro ava ijugeari, aminda irureono natofo fuge gido, nundae sakai seraera. ");
INSERT INTO kpr_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Na aminguse, ambari dae use, tumba da fakina aindae jo oju ae arena. Ainda beká mo: ni nangae dabade deinghaeraera. Nanda ambari da sifo aminda, sonemba eveva mutaresa. ");
INSERT INTO kpr_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","A eni mo: nanda gitofu da uju ekoko ava bureguse, na unumbedo seaso, nenda dombuda ninda kirumo mindiraena. Na ivuga eraena. Na furureono gido, na ategi use, usu da mukaimi nanda jiroda averegeraesa aindae sedo, na ivuga beká ava eraena. Namo esimbuguse, ninda sonemba a dubo jama muteaso foa, nanda dubo jokáda vasa bedo edo fumbu fetare! ");
INSERT INTO kpr_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Geka bekári. Na endada irono, ni na tavo use kavevera ururaso, ninda kamboda irá ghedo gharena. ");
INSERT INTO kpr_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Reju endada irira isambu Bajari da tofori. Endada mave irira nébarago isasambu nunda fitariri. ");
INSERT INTO kpr_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Enda mo, kafuru irira ainda etoda simbugetiri aminda ghedo vivitusira. Enda da susu nune eva jokáda dadurusira. ");
INSERT INTO kpr_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Bajari da doriri ominda mave vitiyari da kaugori? Nunda banungari kambo kakara ominda mave ya terari? ");
INSERT INTO kpr_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Mave nu aito fugarikena a kotarikena kosasa jo ae eraera. Mave beka gajari jo tefo tefo ae eraera. A mave god beká irae jo tumonde bainghae eraera aimi ya terarera. ");
INSERT INTO kpr_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Bajari ne esimbuguse nemokena nunda jebuga mutarira. God kotua gatise, nendae “eveva” sarira. ");
INSERT INTO kpr_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Evetu genembo God kena foa gheraera, Jacob da God tava edo nunda dombuda feteraera nendae resena. ");
INSERT INTO kpr_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Guro tomanakoó fugevu ya afige fetare, guro anakora itero irira amo, dovu afige fetari, Kini (king) teria durode foa terare! ");
INSERT INTO kpr_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Kini teria durode resera emo, mavejori? Bajari fakinago a Iká Bekáda numori. Isoro tataya jokáda gitofu de atai fati feteraira, amo numori. ");
INSERT INTO kpr_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Guro tomanakoó fugevu ya afige fetare, guro anakora itero irira amo, dovu afige fetari, Bajari teria durode foa terare! ");
INSERT INTO kpr_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Kini teria durode resera emo mavejuri? Bajari isoro kakato da giti jighari, Kini teria durode amo, numori. ");
INSERT INTO kpr_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","2","Arie, Bajari, na nimokena benunu sise resena: arie God, na ni tumonderena. Meka geono dae sise, na sonembaso dae resena. Erá doyeóso, gitofui na dedo ivuga use gegha jiriore! ");
INSERT INTO kpr_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Mave ni tumonderaera amo, ne meka jo gae arera. Avata, nimokena mave osogo futo arera, ainda evetu genembo ne meka garera. ");
INSERT INTO kpr_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Arie, Bajari, ninda emboro eveva ijugaso gaone! ");
INSERT INTO kpr_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Ninda geka da beká ava ijugaso, ainda amboda amboda aone! Ainda beká mo, God namokena jebuga muturaira, amo nimori. Na sifo ghousa evia nimoa tumonderaena. ");
INSERT INTO kpr_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Arie, Bajari, ninda kavevera a dubo bari ijugudo refesa, ava kotedo sekago amingaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Ninda dubo bari evovodae udo refesa, kotugo ninda veka eveva udo refesa ava kotise, na nange babojuse ari ekoko use, kosasaghudo fusena, ava nandae kote doyaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Bajari nu dambugo a evevagori. Ava sedo, ari ekoko embo emboro ningi aminda yaetera, ava nune ijugeraira. ");
INSERT INTO kpr_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Tumbari embo ava giti jijighuse bu emboro evevakena ise, nunda uju ava nemokena ijugeraira. ");
INSERT INTO kpr_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Mave nunda evovo sari ava use, nunda Agho Dari kaifa eraira, kotugo nu rea sisira ava use irera ava, ne nune dubo ruruse, giti jighiraira. ");
INSERT INTO kpr_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Bajari, ninda beka gajari kaifa use, nanda ari ekoko kote do! Ai resira amo, nanda ari ekoko digarigori. ");
INSERT INTO kpr_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Mave Bajari igheghi eraera ava, nune kaifa use, emboro ningi aminda yaetera, ava ijugeraira. ");
INSERT INTO kpr_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Evetu genembo amo susu iti fafode edo evovodae aminguse irarera. Amingururoro, nenda sasingu enda evia nenda tofodae barera. ");
INSERT INTO kpr_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Bajari, mave igheghi eraera, nemokena nune komana edo nunda evovo sari da beká ava ijugurureari ningiraera. ");
INSERT INTO kpr_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Na sonemba Bajari kena bari dae gigiturureono, nune na sifo ghousa evia dara memaghae da jokáda saghimbe buraira. ");
INSERT INTO kpr_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Bajari, jovereghe namoa gosuse, nandae joka e! Ai resira amo, na bate beká use eregofena. ");
INSERT INTO kpr_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Mema namokena refira ava baji tomanako beká etira, ava saso dubo jama aone! Kotugo, na mema bouvu itatama erena ava, bu fugaetesi! ");
INSERT INTO kpr_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Nanda ghamo vevera a bouvu mema itatama eraena ava kotise, nanda ari ekoko isambu kote do! ");
INSERT INTO kpr_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Nanda gitofu nanjogo irera ava fuge gi! Na imboe gamboe beká eraera, ava gaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Meka geone dae sise, na nimokena ambo sose fefetururono, na gagara edo sonembuse, kaifa aso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Na nimoa tumonduse, nanda aito eveva fugeraena, a nanda geka bekáda bekáda seraena aindae, na gagara e! ");
INSERT INTO kpr_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Arie, Bajari, ninda natofo Israel embo dara itatama eraera ava, sonembaso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Arie Bajari, na kosasa tefori, na jo mana managhae ni tumondae eraena. Ava sedo, nandae “eveva” saresa. ");
INSERT INTO kpr_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Arie Bajari, nanda ari rea eraena ava, ijujedo na dere gi! Nanda janje jokáda rea uju eraena, a reju koteraena ava ijuje gi! ");
INSERT INTO kpr_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Ninda dubo bari evovodae irira aimi, nanda emboro isagha erira. Ninda geka beká tumonduse deingheraena. ");
INSERT INTO kpr_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Na jo derari kakatode tatae eraena. Kotugo, evetu genembo nenda gunguboimi natofo dereraera ainde dabade, jo anumbedo umo gaumo ae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Na ari ekoko embode tatari beghagha eraira, kotugo ari ekoko embode jo anumbedo umo gaumo ae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Arie Bajari, na jo dara embo irae ava ijuguse, nanda ungo seghedo viti ya ninda olta dombuda yaru divari jokáda tere ya foa ghuse, nimoa tumonde baingheraena. ");
INSERT INTO kpr_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Aminguse, na aiyakoe sise yaruimi didivuse, nine ari eveva gaveva ututeraesa, ava isimberaena. ");
INSERT INTO kpr_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Arie Bajari, ni kambo eminda ireaso, ninda fakina duroghae isagha eraira ava na dubo bu gogoghomberaena. ");
INSERT INTO kpr_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Ari ekoko embo a kotugo kokomana de babarigari kakato daso amboro dae aresa, ainda sifoda, na erá deose! ");
INSERT INTO kpr_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Evetu genembo resena amo, ne evovodae ari ekoko use, komana da mendo bari dae sise ufena moni muturaera. ");
INSERT INTO kpr_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Avata nasukako namo jo amingae eraena, na emboro sokumako a dambugo beká aminda yari dae inini eraena, ava sedo nandae joka use na sonembaso jebugarena. ");
INSERT INTO kpr_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Na vasa evevada fetirise daradae jo oju ae eraena. Nunda natofo tafaroro ari dae totorugururoro, na jokáda ere fetedo, Bajari dae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Bajari nu nanda usasa a nanda sonemba ava, nune edo irira. Na jo mavedae oju ae arena. Dara dombu eni dombu eni namokena foa ghaetira avata, Bajari nune kosegedo na sonembeari, sifo evia inono na jo oju ae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Ari ekoko embo isoro ari dae beje buvudo, namo dari dae kato eraera amo, ne ata dimbeari duraera. ");
INSERT INTO kpr_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Isoro embo dabade tatedo isambu aimi, foa na jimbe birurugharera amo, na jo oju ae arena, na taká God tumonduse irarena. ");
INSERT INTO kpr_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Roera dabako aindae, Bajari kena benunu sido refena. Dabako aindae, na uju beká ava eraena. Amo eviri. Na nange enda eminda jebuga irise, sifo ghousa Bajari da kamboda iraeteni! Aminguse, na nunda eveva ava itatamuse, benunu saono, nu nandae dengoro indaeti! ");
INSERT INTO kpr_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Dara da sifoda, nune gagara ari, na numokena ambo sose fetarena. Nunda Kambo Kakara aminda, na kaifa ururari eveva irarena. Na kaifa use, nune na ghamana mindafu ainda etoda fitari fetedo, gitofudae jo oju ae arena. ");
INSERT INTO kpr_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Aminguse, nanda gitofu namoá jimbe birurugheraera ava, nane dedo atai fati fetarena. Na ivuga use koko sise, joba nunda Kambo Kakara jokáda mutarena. Na yaru didivuse, Bajari dae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Bajari, na kori nimokena sarena amo, ningaetesi! Nanda benunu ningido, joka edo mino use sonembaetesi! ");
INSERT INTO kpr_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Ni eminge sisesi, “Fu, nandae tumonde bainghase!” aminge sisesa amo, nanda ghamo eretiri, mino eminge siseni, “Bajari, na erenare!” ");
INSERT INTO kpr_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Erá namokena jungeose! Erá namokena janje eko eose! Erá dirigeóso ninda saramana kato esike yeure! Arie, Bajari, nanda sonemba kato, ni nanda sonemba edo iriasi. Erá oroko na dodo dumbudo yeose! ");
INSERT INTO kpr_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Nanda aya afa na dodo dumbudo yarera, avata Bajari mo, nu na kaifa use irarira. ");
INSERT INTO kpr_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Bajari, ninda uju, na rea aono dae seraesa ava, namokena ijugaetesi! Ijuguse, giti jijighururu, erá nanda gitofu digari foa namo tambeore dae sise, nangae emboro evevada deinghaore! ");
INSERT INTO kpr_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Erá na doyeóso, gitofu nenda uju namokena eore! Ainda beká mo: nanda gitofu foa nandae gungubo sise, namokena katiyavara eraera. ");
INSERT INTO kpr_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Na kasama erena, na jebuga irono, ni kavevera ururaso, na gosuse irarena. ");
INSERT INTO kpr_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Bajari tumonduse irivu! Numoa tumonduse, erá bunarigo eove! Bajari tumonduse irivu! ");
INSERT INTO kpr_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Arie Bajari, nanda sorega kato, nanda kori ningaso dae resena. Erá dengoro gajeose! Ai resira amo, nanda kori mino jo sae aresa amo, na ambudo natofo amomonjegedo irera, aminga ava edo irarena. ");
INSERT INTO kpr_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Na sonemba dae sorara erena, ningi! Na nanjigo benunu sise, ninda vasa kakara ava fuge gosuse, ungo jighono erarira amo, nanda kori ningi! ");
INSERT INTO kpr_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Erama eóso, evetu genembo ekoko mave tefo bekaimi nano namendide eveva irari da geka sise, nenda janje joká mo imboe gamboe ari ava irira, ainde dabade ambeóne! ");
INSERT INTO kpr_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Ne rejo eraera, mino ava mutu baore! Nenda ari ekokoda mino mutu baore! Nenda ari reju eraera, ainda mino beká ava mutu bu ghamo baore! ");
INSERT INTO kpr_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Bajari rea usira, a rea etiri sirorusira ava, evetu genembo amo ne beká irae ariá koteraera. Ava gido, Bajari ne dari sirivo e dadabarera. ");
INSERT INTO kpr_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Na sonembadae kori seteno niningusira aindae, Bajari dae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Bajari mo, nanda bereri. Namo gagara use, kosege feteraira. Nanda tumondari isambu numokena futurureono na sonemberaira. Nanda janje joká ivuga use yaruimi dubo jeuro use, sakai seraena. ");
INSERT INTO kpr_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Nunda natofo da fakina ainda susu mo, Bajari numori. Nunda kini gategusira ava, gaga ");
INSERT INTO kpr_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Arie Bajari, evetu genembo ninda tofo ava esimbuge! Ne nine kaifa use, tavo ururaso, evovodae irore! ");
INSERT INTO kpr_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Ne maveju maveju utuda ireva, nemokena resena: Bajari dae sakai sevu! Nunda duró a fakinadae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Bajari da Javo durode aindae sakai sevu! God kakarago beká ai fururari garesa amo, nunda dombuda tumonde bainghevu! ");
INSERT INTO kpr_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Bajari da beka duka mo, evada sirurari ningarera. God durode ainda beka mo, barara evakena fugari tatarigho ningarera. ");
INSERT INTO kpr_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Bajari da beka duka fakina a duroghaeimi sirurari ningarera. ");
INSERT INTO kpr_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Bajari da beka dukaimi ika saoro ava dari jorarira, Lebanon da saoro barago nunda bekai dari jorarira. ");
INSERT INTO kpr_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Nunda bekaimi fugari, doriri Lebanon Frovensi aminda dadaragaruse, borumakava mandiimi jorujorugharigo urureari, Doriri Hermon mo, borumakava kandana seka bajariimi vurari garira. ");
INSERT INTO kpr_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Bajari da beka dukaimi fugari, biria tarigharira. ");
INSERT INTO kpr_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Nunda bekaimi sari reighi evetu genembo a uvu iraeda vasa dara gharira, kotugo reighi uvu bayau iraeda vasa Kadesh aminda dara gharira. ");
INSERT INTO kpr_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Bajari da beka dukaimi ari ika odemo ava jajovururari, nunda igi dore vosarira. Aminge ururari, natofo nunda kamboda irera aimi koko sise, “Arie God Da Duro sirorerira evia, givu!” sarera. ");
INSERT INTO kpr_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Usegha gisi mo, Bajari nunda tofori. Nune king edo, evovodae kaifa use irarira. ");
INSERT INTO kpr_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Bajari nunda natofokena fakina futuse, nunda dubo jama aimi ne esimbugarira. ");
INSERT INTO kpr_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Arie Bajari, nine na sonembeteso jebuguseni. Ni jo aso, nanda gitofu na bu nenda gegha yarukena fitaeri. Aindae na sakai sise, ninda javo jighono erare! ");
INSERT INTO kpr_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Arie Bajari, nanda God, na nimokena sonembadae sorara eteno, nine eteso nanda kae dadabusira. ");
INSERT INTO kpr_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Nanda dangio uro bekada ghe saghimbe rurusesi. Na janje dodo ambari emboda bako jokáda vosari dae itako useni. Avata nanda dangio nine dirigeteso, sekago jovereghe fusira. ");
INSERT INTO kpr_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Arie God da natofo kakara, nemokena resena. “Yaru didivuse sakai sevu! ” God kakara, nunda ari rea usira, ava kotise, nundae aiyakoe sevu! ");
INSERT INTO kpr_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Ainda beká mo, nu janje ekoko jo ghousago ae eraira. Avata, nu sifo ghousa kavevera use, irá gheraira. Tumbaghae jivu gutarera, avata sifo atarira amo, dubo jama tambarera. ");
INSERT INTO kpr_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Na fakina budo nasukako siseni, “Na jo itako gofono de atai fatae arera.” ");
INSERT INTO kpr_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Arie Bajari, namokena veka eveva edo ghusesi. Na nine eteso, doriri susu gambu fefetusira, aminga ava useni. Avata ainda amboda ni tofo jungeteso, na gae irise, oju useni. ");
INSERT INTO kpr_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Arie Bajari, na mema use, nimokena benunu siseni. Nandae joka edo sonembaso dae sise, eminge siseni. ");
INSERT INTO kpr_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“Na jo sonembae aso, ambono furugarera amo, nimokena eveva eni rea sirorari baetesi? Ambari embo jo nimokena sakai sari da kaugo iraeri. Kotugo, ne ninda kavevera eraesa aindae, itako jo osa sae arera.” ");
INSERT INTO kpr_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Arie Bajari, na resena evia ningido, nandae joka aso dae resena! Arie Bajari, namo sonembe! ");
INSERT INTO kpr_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Na to rovarova usena ava, nine bu fugeteso divu fusedo gherena. Nine vujeteso, ivuga use atai fefeterena. ");
INSERT INTO kpr_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Ava sedo na jo itako beka dodo irae arena. Na beka afigedo, nindae sakai yaruimi isimbuse irarena. Arie Bajari, nanda God, nimoa tumonde bainghuse, evovodae nindae aiyakoe sise irá gharena. ");
INSERT INTO kpr_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Arie, Bajari na ambo nimokena sose fetari refena. Erá doyeoso, gitofuimi na dereore! God ari dambu beká ari kato nimori, ágido namoa gitofukena bu darige! ");
INSERT INTO kpr_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Na nange resena ningi! Oroko nembo tavaraghe fu, sonembaso jebugaone! Nanda ambo sose fetari vasa nimori, ava sedo na gagara e! Nanda sorega kato aso jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Beká resena, nanda ambo sose fetari vasa, a sorega kato nimori. Nine nanda emboro ijuguse, giti bu iruraso, yaono dae beka gagojusesi. Aminguse, iruru yaone! ");
INSERT INTO kpr_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Erá doyeóso, vagho nanda bega se fifitusera, aminda yeóne! Ainda beká mo, nanda jungari vasa nimori. ");
INSERT INTO kpr_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Tofo nanda jebuga nine tavo aso dae sise, ninda ungoda fifiterena. Arie Bajari God, ni rea seraesa, ava eraesa. Ava sedo, na sonembaso jebugarena. ");
INSERT INTO kpr_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Evetu genembo ove mane a god beká irae tumonde bainghuse irá gheraera ava, ni gari beghagha beká eraesa. Avata namo, nanda tumondari Bajari nisuka nimokena fifituse irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Ninda dubo bari teriago aindae, ivuga use, riria arena. Na mema itatama urureono, ni giraesa. Nanda ghamo jokáda bouvu itatama eraena, ni kasama eresa. ");
INSERT INTO kpr_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Ni na jo doyaso gitofui sandi bu yaeri. Na emboro evevada fiteso, dubo jamaghae ya foa gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","10","Arie, Bajari, nandae joka e! Ai resira, na dara beni. Na sorara teria futo use, diti kokoi edo yaya resira. Nanda etu jorujara ghetiri, gevei use, ambari dae urogho erena. Ainda susu mo, nanda irari isambu memai janje gagojururari, na jivu menjuga gutise, gofeteni. Na dubo mema use, fakina dadabetiri rojeteni. Na geveiimi etu goghorogo erena. ");
INSERT INTO kpr_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Nanda gitofu isasambu, kotugo mokogo mo nanda nano namendi barago nandae seraera, “Foká tamonda!” O nanda kokomana mendeni na emboroda tamburaera, nandae oju sumburaera. ");
INSERT INTO kpr_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Ambari embo kotae eraera aminga ava, evetu genembo isasambu na kotae useri. Namoa kau sena fugari guseri. ");
INSERT INTO kpr_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Beká resena, nandae gitofu use, isi basi sirureoro ningiraena. Tingu tanga isambu gitofu vanembori. Ne nandae osogo use, namoa ufena daoro ambono dae manaka eregarera. ");
INSERT INTO kpr_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Avata, Bajari, nanda God nimori. Ava sedo, nanda tumondari isambu nimokena fifiterena. ");
INSERT INTO kpr_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Na sifo ghousa ninda kaifada irá gheraena. Namoa sonembedo, nanda gitofukena bu darige! Mave nandae mema erefutera aikena, bu darige. ");
INSERT INTO kpr_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Na ninda saramana katori. Nandae mendo vivi use, kavevera e! Ninda dubo bari udo refesa aimi, na sonembe jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Arie, Bajari, ninda sonembadae kori resena. Ava sedo, erá doyeoso na meka geone! O ari ekoko embo mo, do meka gaore! Nenda beka jighi gotaso guga use ambudo, ambari embo da vasada yaore! ");
INSERT INTO kpr_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Gungubo kakato isasambu da beka jighi gotaso guga aoro dae resena. Na, ivuga kakato mave meka irae tamoi tamoi use, evetu genembo eveva dere jise, jijivu seraera, aindae resena. ");
INSERT INTO kpr_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Arie, evetu genembo ni igheghi use, irá gheraera ainda e simbugari eveva nanjogo fiteso irira! Amboda mutaso barera. Ninda natofo ni tumonderaera, ava nine gagara edo tavo use nemokena eveva eraesa ava, evetu genembo isambu kasama eraera. ");
INSERT INTO kpr_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Evetu genembo mendeni ninda natofo daoro amboro dae manaka gayeraera aikena, nine bu, ninda jungari vasada fitaresa. Gitofuimi nendae jijivu ekoko saetera aikena, ne nine bu darigedo, ninda sasoro eveva aminda jungaresa. ");
INSERT INTO kpr_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Bajari dae sakai saore! Gitofui na dari dae sedo, jimbe birurughusera, avata, nunda dubo bari tomanakogo bekáimi namokena ijuguse, na sonembetiri jebuguseni. ");
INSERT INTO kpr_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Na nune ondari nunda dombu do darigariá kotise, oju useni. Avata, nunda sonembadae kori seteno ningido sonembusira. ");
INSERT INTO kpr_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Mave Bajari tumonderaeva, nemokena resena ningivu! Numoa dubo buvu! Evetu genembo numoa tumonderaera ava Bajari nune gagara eraira. O ivuga kakato, aikena reju baetera, ava mutarira. Amo nu mema mutari itatamarera. ");
INSERT INTO kpr_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Ne maveju maveju Bajari gigituse ireva, nemokena resena. Ghamo gambari fakina eve! ");
INSERT INTO kpr_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Evetu genembo maveda ari ekoko Bajari kote doyeraira amo, ne ivuga beká ava arera. Mave dara aoro gido, Bajari kote dotutuse mino mutari jo sae arira amo, nembarago dubo jama use ivuga arera. ");
INSERT INTO kpr_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Genembo maveda ari Bajari jo ijujuse, nunda dara jo tava ae arira amo, nu ivuga arira. Mave nunda komana jo itako derae eraira amo, nu ivuga arira. ");
INSERT INTO kpr_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Avata namo, nanda ari ekoko jo vujegae irise, na isonga numboru sorara janjagughae use iriana, tamo roroghotetiri sifo dadabusira. ");
INSERT INTO kpr_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Bajari, sifo a tumba evia inono, nine na deaso nanda fakina dadabe gogoghombedo ghusira. Kau borija da sifo aminda, mungo voseari iji totoi aveari kaingheraira aminga ava, nanda fakina dadabusira. ");
INSERT INTO kpr_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Dadabetiri, nanda ari ekoko nimokena vujeguseni. Nanda ari sembae ava, jo jungae useni. Nanda dubo jovereghetiri, nanda ari ekoko nimokena vujegeteno ningido, ni nanda ari ekoko isasambu kote dotutusesi. ");
INSERT INTO kpr_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Ava sedo, kau nimokena banungusena aminga ava, ninda evetu genembo tumondari kakato dara jokáda fetirise itatamarera amo, nimokena banungaeteri. Amingarera amo, dara kau usegha gisi aminga ava foa nemokena bejarira amo, ne jo derari itatamae arera. ");
INSERT INTO kpr_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Ni nanda tere jungari vasa fakaragori. Ni na sonembeaso, dara da mema eniko jo itatamae eraena. Ni na gagara easo, na nimokena ambo sose feteraena ava sedo, na beka fainghedo, ninda sonemba ava kotise, yaru divuraena. ");
INSERT INTO kpr_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Bajari eminge resira, “Ni reda yaetesa ainda emboro ava nane ijugaono garesa. Na ninda dengoro induduse, emboro eveva ijugarena. ");
INSERT INTO kpr_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Erá gogore eose! Hosi (horse) o sino fuka ‘mule’ seraera, ainda kiki mo eviri: nu kotae kotae eraira. Ava sedo, ninda uju ava are dae sedo, auri nunda bekada dighido fakinaghae jumbaso, mema itatamuse, ninda uju aminda yarira. Erá hosi (horse) da gogorego eose!” ");
INSERT INTO kpr_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Ari ekoko embo nenda dara da bouvu ava fumbarera, avata evetu genembo mave Bajari tumonderaera amo, nunda dubo bari evovodae irira aimi, ne gagara ari evevada irarera. ");
INSERT INTO kpr_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Ne mave ari eveva a dambu eraeva amo, ne riria use ivuga evu! Bajari nu rea nendae usera ava kotise, ivuga evu! Ne mave nunda geka ningiraeva amo, ne ivuga use, koko sevu! ");
INSERT INTO kpr_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Ne maveju mavejuimi kosasa tefo ireva, nemokena resena. Bajari rea usira aindae ivuga use fumbu arugevu! Ne maveju mavejuimi nunda sari ava eraeva, isambu nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Gita aimi doruse, Bajari dae aiyakoe sevu! Yuka doruse, nundae yaru sevu! ");
INSERT INTO kpr_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Yaru seka nundae gate divuvu! Gita doruse, asi fativu, duka garigo ururari, ivugai fumbu arugevu! ");
INSERT INTO kpr_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Ai resira amo, Bajari da geka mo beká ava nembori. Kotugo, nu rea eraira amo, isambu numo bekári. ");
INSERT INTO kpr_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Evetu genembo mave ari dambugo use bekáda bekáda eraera ava, Bajari nu uju beká eraira. Nu evovodae dubo buraira, aimi endaé bedo edo irira. ");
INSERT INTO kpr_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Utu mo, Bajari nunda bekaimi setiri sirorusira. Iji, tambuno, a damana mane nune setiri sirorusira. ");
INSERT INTO kpr_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Karaje nune doregetiri fira, vasa dabako fefetusira. Kafuru teria nunda bogu bogu usira. ");
INSERT INTO kpr_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Evetu genembo endada ireva isambu, Bajari dae oju use, igheghi evu! Endada nunda oro oro isambu nemokena resena. Numoa kakara evu! ");
INSERT INTO kpr_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Ainda beká mo, geka nune sisira aimi, enda sirorusira. Nune setiri, roera isambu sirorusira. ");
INSERT INTO kpr_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Enda da oro oro rea ari kotise manaka gayeraera ava, Bajari nune buregeraira. Ne rea ari seoro feteraira ava, nune gajeari, beká jo sirorae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","O nune manaka garuse, rea ari sarira, ainda beká siroredo evovodae irarira, jo sifo nanjigo tano ae arira. ");
INSERT INTO kpr_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Oro mave Bajari nenda God dae sedo budo irera, ivugaghae irarera. Nune natofo nunda tofodae gategusira, ne ivuga use irarera. ");
INSERT INTO kpr_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Bajari, utuda ghe diti duruda use, evetu genembo isasambu giraira. ");
INSERT INTO kpr_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Nunda anumba vasada anumbirise, dombu durukena use, endada evetu genembo rea eraera ava, nu giraira. ");
INSERT INTO kpr_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Evetu genembo isasambu nenda janje joká nune etiri sirorusira. Ava sedo, ne rea eraera a koteraera isasambu ava, nune gi kasama urureari siroreraera. ");
INSERT INTO kpr_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Kini jo nunda isoro kakato da fakina aimi gitofu de sosighi e bae arira. Isoro embo jo nunda fakina aimi gitofu de duboda fatae arira. ");
INSERT INTO kpr_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Hosi da fakina barago amingori. Mave hosi da fakina tumonduse isoro arira aimi jo gitofu de sosighi e bae arira. Roera isambu tegetena, ainda fakina tomanakogo aimi jo ari jebuga tambae arera. ");
INSERT INTO kpr_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Bajari, evetu genembo mave nundae oju use, igheghi eraera ava gosurari irá gheraera, evetu genembo mave nunda dubo bari tomanakogo ava tumonduse irá gheraera ava, ");
INSERT INTO kpr_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","nune sonemburureari ne jebuga irá gheraera. Baimara sifoda nune kaifa urureari, ne uvu bayaughae irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Namondeda gigitari isambu Bajari kena fitiraera. Namondeda gagara ari kato a sonemba kato numori. ");
INSERT INTO kpr_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Nune eari, namonde dubo jama eraera. Namondeda tumondari nunda javo kakara aminda fitiraera. ");
INSERT INTO kpr_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Arie, Bajari, ninda dubo bari namanekena evovodae irira, aimi namane esimbuge! Namane nimoa gigitururoro esimbugaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Na sifo evia inono, God kena aiyakoe sise irarena. Na nundae sakai sise irarena, sifo nanjigo aminda nundae sakai sari jo doyae arena. ");
INSERT INTO kpr_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Nu rejo nandae usira ava kotise, nundae sakai sise irarena. Evetu genembo mave gitofuimi deoro dara jokáda irise mema itatameraeva amo nembarago, nundae sakai sirurono ningido, ivuga evu! ");
INSERT INTO kpr_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Bajari nu teria beká ava sedo, ne na sonembedo, Bajari da bino aindae osa sise sakai saore! Nunda javo aindae sakai dabade saore! ");
INSERT INTO kpr_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Na Bajari kena benunu seteno ningido, na vujegetiri, nanda oju isambu dadabe tefo usira. ");
INSERT INTO kpr_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Evetu genembo mave gitofuimi deoro, dara jokáda irise mema itatameraera amo, ne Bajari kena dombu fainghedo ivuga eraera. Aminguse, ne jo sifo nanjigo aminda dubo mema ae arera. ");
INSERT INTO kpr_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Evetu genembo fakina tefo embo aimi, numokena kori seoro, nu ningiraira. Ningido, ne dara ainda jokáda ava sonembuse, saghimbe buraira. ");
INSERT INTO kpr_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Evetu genembo mave Bajari kakara use tumonderaera ava, nunda aneyaimi kaifa use, saghimbe buraera. ");
INSERT INTO kpr_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Bajari da kavevera ava, ni tofo mandi, itatame gi! Evetu genembo mave numokena ya nunda sonemba itatamururoro ne kaifa arira amo, ne ivuga beká ava arera. ");
INSERT INTO kpr_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Bajari da natofo isambu, nemokena resena. Bajari kakara use tumondevu! Evetu genembo mave nunda geka ningiraera amo, ne rejo baetera ava budo, inono edo irera. ");
INSERT INTO kpr_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Raiyoni (lions) bayaudae ighoi itatamuse tava eraera, avata evetu genembo mave Bajari da geka ningiraera amo, ne inono beká ava arera, roera eveva enidae dubo mema jo ae arera. ");
INSERT INTO kpr_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Nanda kokomana, evetu genembo seseka, fuvu, sirurono ningove! Niningururovo, ne nange Bajari kakara use tumondaeteva ava, ijugaono ningareva! ");
INSERT INTO kpr_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Ne endada ivugaghae irari uju eraeva, ai? Ne eminda ghousa jebuga irise, ivugaghae irari uju eraeva, ai? ");
INSERT INTO kpr_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Avori, erá aji seove, a erá gungubo seove! ");
INSERT INTO kpr_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Ari eko da emboro ava imboe edo gukai futuse, ari eveva avanembo use irivu! Mainungari da emboro ava, fakina use ininighae tava evu! ");
INSERT INTO kpr_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Bajari nu, evetu genbembo ari eveva a dambu eraera ava, kaifa use, nenda kori ningiraira, a nenda irari ava, giraira. ");
INSERT INTO kpr_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Avata evetu genembo mave ari ekoko eraera ainde, nu osogo edo tataya use deraira. Amingurureari, ne amburaera amo, evetu genembo ne jo kakara use kotae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Avata evetu genembo ari eveva a dambu eraera amo, ne Bajari kena kori sirureoro ningiraira. Aminguse nu, ne dara ainda jokáda ava sonembuse, saghimbe buraira. ");
INSERT INTO kpr_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Evetu genembo mave dubo mema use irera aikena, Bajari foa utua feteraira, a evetu genembo mave bune jarutuse, fakina jo bae eraera ava, nune sonemberaira. ");
INSERT INTO kpr_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Genembo eveva mo, nu dara digari ainda mema itatameraira, avata dara isambu rea itatameraira ainda jokáda, Bajari foa nu budo sonemberaira. ");
INSERT INTO kpr_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Bajari nu sonembuse kaifa e gogoghomburureari, nu eveva irá gheraira, jo nunda etu eniko degagae arira. ");
INSERT INTO kpr_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Ekoimi foa, evetu genembo ari ekoko eraera ava, deari amburaera. A evetu genembo mave ari eveva embo imboe eraera amo, ne ainda bouvu fufuse mino eko buraera. ");
INSERT INTO kpr_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Avata Bajari nunda natofo sonembarira. Mave numokena ya, nunda sonemba a kaifa ari aindae uju eraera amo, ne nunda sonemba ruruse, mino eko jo bae arera. ");
INSERT INTO kpr_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Bajari, evetu genembo mave namokena osogo futo erera ainde osogo e! A kotugo, evetu genembo mave namokena isoro erera ainde, isoro aso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Ninda bere bu jighido, ere fu, namoa gagara use dombukena kosege fetase! ");
INSERT INTO kpr_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Gitofu namoa ondi utua erera, aindae ninda gika vara ghae jighi erari nandae sorega fumbu! “Ninda sonemba kato namori,” ava saso ningido, dubo jama aone! ");
INSERT INTO kpr_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Evetu genembo mave namoa daoro ambono dae ufena manaka garuse kato erera ava, nine dedo atai duboda fafatigaso, mana mana use meka gaoro dae resena. Ondi dubo bunedo jovereghaore! ");
INSERT INTO kpr_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Bajari, nine se, ninda Aneya ne ondirari, kau kikisa gharasa yauraimi fuseari ghumbu ya gheraira aminga ava, sumbu ya baghimbaore! ");
INSERT INTO kpr_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Bajari, nine aso, nenda dombukena tumba jinjanghururari a emboro seriseri ghari, ninda aneyaimi ne ondi dari du fafasaore! ");
INSERT INTO kpr_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Ai resira amo, na nemokena dara jo aeri. Avata, ne susu tefo namoa ufena daoro ambono dae sise, bako ghafuse a ivasi fitari guseri. ");
INSERT INTO kpr_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Avata ne kotae kotae iroro, nemoa sosighi aso itatamarera. Ne totofo nemoa nenda vaghoimi dorurari a kotugo totofo nene nenda bakoda du vovoseguse sirivo e tefo arera. ");
INSERT INTO kpr_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Amingaoro, na Bajari dae ivuga arena. Na sari, jebugarena aindae, na ivuga arena. ");
INSERT INTO kpr_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Na nanda janje joka isambuimi Bajari kena sarena, “Arie Bajari, endada a utuda nimongo eni tefori. Rorojegari amo, nine fakina kakatokena kosegeraesa. A makasi irari jarutuse irera barago, nine evetu genembo nemoa degi degi eraera, aikena kosegeraesa.” ");
INSERT INTO kpr_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Natofoimi aji sise, nane dara ariá gesire eraera, avata na berefo bekári. ");
INSERT INTO kpr_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Na nendae ari eveva urureono, ne namokena mino ari ekoko ututeraera. Amingeoro, na dubo mema bekáimi bune jarutuse irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","14","Sifo reda ne kae tambudo ghusera, nanda aya, koro mandako a kotugo komana eni kae bu ambari dae ururoro, joka use banungaetena aminga ava use, Bajari nemo sonembari jebugaoro dae sise, na nendae rovarova use, nendae sedo banungedo ghuseni, a kotugo, uvu bayau kanangara use janje joka isambuimi nendae sedo banungedo ghuseni. Na nendae sedo dubo mema use, tumo darido ya foa ghedo ghuseni. ");
INSERT INTO kpr_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Avata dara namokena sirorusira, da sifo aminda, ne isasambu ivuga useri. Evetu genembo na berefoimi totorugedo, namo dere jise dedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Inono daguna embo dere jiraera aminga ava use, ne namokena dombu fakara futo use, dere jiseri. ");
INSERT INTO kpr_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Arie Bajari, rekato sifo ghousa gosuraso nandae emingeraeri? Evetu genembo amo laioni (lion) da ari aminga use, namo daoro ambono dae eraera, aikena na sainghimbe bu! ");
INSERT INTO kpr_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Amingaresa amo, na nindae aiyakoe sarena. Ninda natofo tomanako totorugarera ainda dombuda fetedo, nindae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Erá eoso, evetu genembo gungubo kakato namokena gitofu eraera aimi, na nenda dere jirarikena fiteore! Erá eoso, evetu genembo susu tefo na imboe gamboe eraera aimi, dubo mema arena sifoda gi mendó fainghuse ivuga eore! ");
INSERT INTO kpr_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Nano namendi da geka ava jo sae eraera. Ne tatera genembo dubo jamada irera, ainda javoda geka gungubo kau eni kau eni ava sise undeoro, baji tomanako eraira. ");
INSERT INTO kpr_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Ne namoa gesire use, koko siseri, “Namane, rea etesa, geri!” ");
INSERT INTO kpr_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Avata, Bajari, ni ava gosusesi. Ava sedo, erá namokena tumbedo, ya tofo mandi soka beká eose! ");
INSERT INTO kpr_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Arie Bajari, tofo ere fete, nandae sorega fumbu! Nanda God, tofo nandae enjise, namo sonembuse sorega fumbu! ");
INSERT INTO kpr_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Arie Bajari, nanda God, nimo dambugo bekári, ava sedo, nandae “kosasa tefori” saso dae resena. Era doyeoso, nanda gitofuimi na dedo gegha jiriore! ");
INSERT INTO kpr_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Erá doyeoso ne totofo seore, “Makoe! Nu sandi beri! Amo namonde rea uju usera ava, beká etira!” ");
INSERT INTO kpr_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Evetu genembo mave, na mema tafurureono, namoa dere jiraera ava dedo, atai duboda fati tefo edo aso dubo bunarera. Evetu genembo mave nesuka nemoa nembo eveva sise, na ighagha eraera ava aso, nenda javo eko ari mekai jarutarera. ");
INSERT INTO kpr_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Evetu genembo mave, ijujari kato nandae “kosasa tefori” sare dae uju arera aimi, ivugai fumbu arugedo ghuse eminge sarera, “Bajari mo nu teriagori! Nunda saramana kato koto sifoda jebugetira aindae, nu ivuga erira!” ");
INSERT INTO kpr_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Sifo aminda, ni bekáda bekáda eraesa aindae, na osa sise, evovodae nindae sakai sise irarena. ");
INSERT INTO kpr_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Ari ekoko embo da janje jokáda ari eko aimi misurugururari, nu God imboe use, God dae igheghi itako jo ae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Ainda susu mo, nu tofo numokena sarira, “Na jiro raugo bekári, ágido, na rea eraena, God jo tambudo dombuda sari da kaugo iraeri.” ");
INSERT INTO kpr_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Nunda geka isambu ekoko beká sise, gungubo teria futo seraira. Nu dubo kotari da emboro kosasaghuse, nu sifo nanjigo aminda kotofu da ari ava jo ae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Nu kambo jokáda fase irise, kotari ekoko kotise fase irá gheraira. Nu tofo numoa bu sembaeda fifituse, ari eko ari da goroto nanjogo foa gheraira ava, itako jo darigae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Arie Bajari, ninda dubo bari teriago bekári, utu tambudo irira. Ninda beka gajari nanjogo aresa, ava evovodae kaifa udo yaresa, tano tefori. ");
INSERT INTO kpr_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Doriri ghousa vitaira utuda vaghuse fetirira, ainda ghousa jo ave kasama arigo iraeri. Aminga ava, God ari dambu ava nembo eraira ainda kafuru, jo mave tambae arira. Kotugo, nu evetu genembo bekáda bekáda ategi eraira da aito fugari mo, amingori, tano tefori. Sino fuka a evetu genembo barago nine kaifa eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Arie God, ninda dubo bari evovodae eraesa amo, numo bekári. Evetu genembo isambu ninda ghabu duruda tereoro, nine gagara eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Kirumu nine berugeraesa ava nene mindiraera. Nine seoso, ninda esimbugari, usegha buvuraira aminga ava namanekena bejedo foa gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Jebuga da susu mo nimori, nimokena ghedo foa gheraira. Ninda usasa jarageraira aimi, namane sifo sevo eregosera. ");
INSERT INTO kpr_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Evetu genembo ni kasama erera ava evovodae dubo budo ghe! Kotugo evetu genembo ari dambugo eraera aikena ninda jebuga ghasido yaresa! ");
INSERT INTO kpr_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Erá doyeoso, gegenembo ivuga kakatoimi na deore! Evetu genembo ekoko barago, erá doyeoso, na ondioro sumbione! ");
INSERT INTO kpr_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Arie givu! Evetu genembo ekoko reda du fafasetera. O, gi! Ominda burudughe fafasedo, erari erebunera. ");
INSERT INTO kpr_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Erá ari ekoko embo rea arera aindae, mema use, kotari futo eove! Ari ekoko ari kakato rea arera aindae, erá bengoso futo eove! ");
INSERT INTO kpr_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Ai resira amo, kau kikisa gharasa edo aviraira, ne aminga ava use, totoi nembo manje tefo arera. Kotugo, vive gharasa edo aviraira aminga ava, ne ambu tefo arera. ");
INSERT INTO kpr_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Tumondari isambu Bajari kena fifituse, ari eveva nembo edo ghevu! Amingareva, ne nenda enda nane futusena aminda irise, mema eni tefo, dubo jamaghae irareva. ");
INSERT INTO kpr_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Ninda ivuga Bajari kena bari dae kotise iraresa amo, ninda janje jokáda rea uju beká use koteraesa ava, nune mutari baresa. ");
INSERT INTO kpr_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Ninda kotari a uju isambu Bajari da ungoda fiti! Tumondari isambu numokena fifitururaso, nune sonembarira. ");
INSERT INTO kpr_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Nune ari, ninda irari dambugo beká, kau isonga iji janimberaira aminga ava use, ijugururari isagha ari natofo garera. ");
INSERT INTO kpr_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Erá, evetu genembo ari ekoko ururoro nenda gugua nanjogo dige fasarira, o evetu genembo mave dara ari dae manaka gayeraera aindae, janje takegha eure! Durumugedo Bajari sonembari dae, gigita use iri! ");
INSERT INTO kpr_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Nimokena dubo mema futo ari, o janje eko ari avaga erá afigeuri fureure! Roera avavagaimi dara undiari siroreraira. ");
INSERT INTO kpr_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Evetu genembo mave nenda tumondari Bajari kena fifituse irá gheraera aimi, enda nene tofo arera. O ari ekoko embo mo, ondari do buvarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Ari ekoko embo mo, totoi manjarera. Nemo gari dae kakova aresa, avata ne itako jo tambae aresa. ");
INSERT INTO kpr_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","O tumbari embo aimi enda nene budo, gugua ghayafade edo, ririaghae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Genembo ari ekoko ari kato aimi genembo eveva ava ambare dae aito use, imboe gamboe use, ababa gambu bainbaingheraira. ");
INSERT INTO kpr_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Avata, Bajari ari ekoko ari kakato aindae gegha jiraira. Ainda susu mo, nemo sosighi ari da sifo utua ari dae erira ava, nu kasama erira. ");
INSERT INTO kpr_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Ari ekoko embo nene eredo, makasi a jarutari embo, kotugo evetu genembo aito eveva fugeraera ava isambu, dedo gaedo ghaoro amboro dae sise, nenda isoro da kaiya jigheoro erorureari, a nenda feva jighi otomberaera. ");
INSERT INTO kpr_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Avata, God nenda feva jighi joredo, totofo nenda isoro da kaiya aimi nemoa jari ambarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Genembo eveva ainda gugua jo anjaga iraeri, avata eveva use irá gheraira, ava sedo, ivuga tambarira. O ari ekoko embo mo, nenda ghayafa digarigo, avata ekoko use irá gheraera aindae, ivuga jo tambae arera. ");
INSERT INTO kpr_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Ainda susu mo, Bajari nune ari, ekoko embo da fakina, ava dadabarira. O evetu genembo eveva da mo, nune gagara arira. ");
INSERT INTO kpr_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Evetu genembo Bajari da sari ava nembo eraera amo, nune kaifa tavo eraira. Kotugo enda nene anumbirera amo, evovodae nenda tofodae barera. ");
INSERT INTO kpr_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Baimara sifoda ne jo mema itatama use, meka gae arera. Baimara sifoda ne inono beká irarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","O ari ekoko embo mo, ambu tefo arera. Bajari dae osogo ari kakato mo, manjarera. Kau vare joka gharasedo dore dudurugeraira, amingari garera. A kau imbosi yauraimi bu ghumbu irureari dadaberaira, ava arera. ");
INSERT INTO kpr_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Genembo ari eko ari kato roera se bambudo, mino jo mutae eraira. O genembo ari eveva embo mo, kavevera use nunda gugua soro eraira. ");
INSERT INTO kpr_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Evetu genembo mavejoa Bajari esimbugarira, aimi enda nenda tofodae barera. O evetu genembo mavejoa nune simbora arira amo, ondari buvarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Evetu genembo da emboro mo, Bajari nune ijugeraira. Evetu genembo nune uju eraira ava, nu gagara eraira. ");
INSERT INTO kpr_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Ne ata de fokugharera amo, ne jo du burudughe fasae arera. Ainda susu mo, Bajari nune jijighururari, totoi erarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Na bajido ghousago iriani. Ava oroko na genembako eteni. Avata, Bajari genembo eveva ava jo doyari na gaeri. Kotugo, nunda sasingu barago, bayaudae benunu sise, deinghururoro jo gaeri. ");
INSERT INTO kpr_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Genembo amo sifo ghousa soro vesa use, kokomana rejudae benunu sarera, sonembarira. God genembo amo esimbuguse, sasingu mutari barira. ");
INSERT INTO kpr_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Ari ekoko da ari amo dodo, ari eveva vanembo use irareva amo, nenda imemesiri gamemisiri sifo ghousa enda eminda irarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Ainda beká mo, Bajari ari dambu aindae uju use, natofo nunda sari ava eraera aikena, gukai jo mutae arira. Nemo evovodae nune gagara eraira. O ari ekoko embo da imemisiri gamemisiri mo, nune ondari darigarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Ari eveva gaveva embo aimi enda nenda tofodae budo, aminda dighi anumbedo evovodae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Genembo eveva mo, nu geka evevago a kotofu geka ava seraira. Nu rea eraira, ava evetu genembo isambukena inonoda inonoda eraira. ");
INSERT INTO kpr_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Nu God da Agho Dari ava bu nunda janje jokáda fiti kaifa use, jo sifo nanjigo emboro kosasaghedo, ajagha yae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Ari eko embo mo, genembo eveva ava dari ambare dae sise, kato use irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Avata, Bajari genembo eveva amo jo itako doyari, nunda gitofu da vaghoda terae arira. Aminguse, koto ari sifoda jo doyari, genembo eveva amo mema tambae arira. ");
INSERT INTO kpr_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Nenda gigitari isambu Bajari kena fifituse, nunda sari ava edo ghevu! Amingururovo gido aindae, ne kakara use, enda nemokena mutari bareva. Budo gosururovo, ari ekoko embo God nune ondari darigarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Anakora na genembo ghambura, geka ningae tambuno ava gosuseni. Nu kau Lebanon da beriberiya aminga ava use, ika mendeni do darige viti ikáda vagheraira. Aminguse, evetu genembo digari ava nune kateyavara edo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Avata amboda, na sekago aminda buvudo, nu jo aminda irari gaeri. Na numoa gari dae kakova usena, avata nu jo itako tambaeri. ");
INSERT INTO kpr_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Genembo eveva ava gi gogoghombaresa, a genembo ari dambugo ava kote garesa. Ai resira amo, genembo mainugarighae irá gheraira, ainda imemesiri gamemisiri digari sirorarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","O, ari ekoko ari kakato mo, God nune dari amomonjegarera. Kotugo nenda imemisiri gamemisiri barago vekaghae musarera. ");
INSERT INTO kpr_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Bajari gegenembo dambugo ava, dara sifoda nune gagara use sonembeari jebugeraera. ");
INSERT INTO kpr_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Ne ambo numokena sosiroro, nune ne sonembuse, darakena saighimbe buraira. Nune nemoa ari ekoko embokena saighimbe bu darigeari jebugeraera. ");
INSERT INTO kpr_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Arie, Bajari, erá ninda janje ekoimi na dombuda seose! ");
INSERT INTO kpr_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Ai resira amo, na ninda feva da gorobaimi na gaetesi. Na nine deteso du faseteni. ");
INSERT INTO kpr_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Ninda janje eko etesa, aimi na tamo mema teria futo itatama erena. Nanda ari ekoko teria futo aindae, nanda tamo isambu gambisi gambisi etira. ");
INSERT INTO kpr_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Ai resira amo, nanda ari ekoko teriago beká aimi afurugetiri, usegha jokáda mindi ambari gerena. Nanda ari ekoko da mema ava bouvugori, jo nane fumbarigo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Nanda gogore tamonda tamo gambisi futo edo masa use metegerira. ");
INSERT INTO kpr_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Na kukurufa use, otombedo, isonga numboro sorara urureono, tumba jiraira. ");
INSERT INTO kpr_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Kae tambudo, tamo veriveri teria beká iri, ambari dae erena. ");
INSERT INTO kpr_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Na rojari beká edo, fakina dadabetiri, nanda janje feriferi ghuse, mema siri, aoro sise fasirena. ");
INSERT INTO kpr_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Arie, Bajari, na rea uju eraena, ni isambu kasama eresa. Na aoro sise fasirena ábarago, isambu niningeresa. ");
INSERT INTO kpr_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Nanda janje feriferi ghiri, na rojari beká eteni. Namokena ivuga isambu dadabetira. ");
INSERT INTO kpr_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Na tamo gambisi beda etiri, aindae nanda kokomana a nano namendi itako jo foa nanda tinguda fetae eraera. Nanda ambo bego ajagha beká irá gheraera, jo foa na gae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Evetu genembo namo daoro ambono dae uju use, ivasi fifitigeraera. Evetu genembo mendeni na mema itatama use gofono dae sise, manaka gayeraera. ");
INSERT INTO kpr_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Namo dengoro gajetiri a guga embo da kaugo use, beka jo sae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Na guga a dengoro irae embo mave geka jo ningae irise, mino jo sae eraira da kaugori. ");
INSERT INTO kpr_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Avata, Bajari, nanda tumondari nimokena fifituse irá gheraena. Kotugo, Bajari nanda God, nanda benunu ningido sonembaresa. ");
INSERT INTO kpr_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Erá doyeoso, na mema eretafena aindae, gitofu na dere jiriore! Erá doyeoso, nane dara aono, nandae “makoede” sise, na bu gego yaru kena fifituse, dere jireore! ");
INSERT INTO kpr_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Ai resira amo, nanda kae teria beká saviri, na durari dae itatako erena. ");
INSERT INTO kpr_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Na nanda ari ekoko vujegeraena. Nanda kosasa aindae mema use irena. ");
INSERT INTO kpr_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Nanda gitofu fakina kakatori, ne kae itako jo tambae eraera. Ne susu tefo na imboe gamboe eraera. ");
INSERT INTO kpr_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Na ari dambugo ari dae inini use irá gheraena aindae, evetu genembo mendeni nandae osogo eraera. Na nendae ari eveva eraena, avata namokena ari ekoko eraera. ");
INSERT INTO kpr_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Arie, Bajari, erá na doyeose! Nanda God, erá na darige, soka yeose! ");
INSERT INTO kpr_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Arie, Bajari, namo saso jebugari kato nimori, oroko namo sonembe! ");
INSERT INTO kpr_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Na siseni, “Na rea arena, kaifa e gogoghombuse arena. Kotugo nanda beka kaifa use, geka eko eni jo saono buvae arira. Ava sedo, na evetu genembo ekoko da dombuda irise, geka itako eni jo sae arena.” ");
INSERT INTO kpr_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Na beka gotedo, geka eni itako jo saeri. Eveva geka barago jo saeri. Avata, nanda mema ava baji tomanako usira. ");
INSERT INTO kpr_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Amo nanda mema aindae oju useni. Na kotari futo usena, avata eko beká useni. Na ghousa mavega irari bunise ategi useni: ");
INSERT INTO kpr_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Bajari, na ghousa mavega ava irareni? Na nanjigo ambareni? Nanda ambari da sifo saso ningaeteni. ");
INSERT INTO kpr_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Nange eteso, na jo ghousa irae areni? Na ninda dombuda jo ghousa irae arena. Geka bekári, namane evetu genembo jebuga irá gheraera amo, inono ghamo asegeraera amingori. ");
INSERT INTO kpr_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Namanenda irari mo, dangio da kaugori, beká tefori. Namane tefo janjagu eraera. Namane gugua bambu dabade eraera, avata mave rete bambarira amo, namane berefori. ");
INSERT INTO kpr_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Bajari, nanda gigita ari mo, jo soesa ae eraena. Nanda kaifa gigita ari mo, nimokenari. ");
INSERT INTO kpr_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Nanda ari ekoko bu fugaso, jebugaone! Kotugo erá eoso, evetu genembo gogovara use God imboe eraera aimi, na dere jiriore! ");
INSERT INTO kpr_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Na beka gotedo, geka eni itako jo sae arena. Ainda susu mo, nine eteso na mema tafuse irena. ");
INSERT INTO kpr_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Erá, nanda ari ekoko da mino futuse, na sekago deose! Na deteso ambari dae itako erena. ");
INSERT INTO kpr_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Ni evetu genembo da ari ekoko ainda mino futuse, ghoghora sise dombuda seraesa. Aminguse, ne rea dubo buraera ava, kau jiriko aimi mindeari bakomba eraira, aminga ava sosighi eraesa. Geka bekári, namane evetu genembo jebuga irá gheraera amo, inono ghamo asegeraera amingori. ");
INSERT INTO kpr_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Arie, Bajari, nanda banungari ningi! Namo sonembaso dae sorara erena, ningi! Na sorara ururono ningaresa, fu, na sonembase! Ai resira amo, nanda afamane abuamane usera avavaga, namo ninda esa embori, sifo tufako ava nembo irarena. ");
INSERT INTO kpr_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Ninda ungu sokinembaso dae resena. Doyaso, na jo ambae irise, ivuga itako edo, na ambono dadabare!” ");
INSERT INTO kpr_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Na durumugedo, Bajari da sonemba dae kaifa use ireno, nu nanda sorara jave ninigusira. ");
INSERT INTO kpr_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Na bako eko beká tauya aminda ghe jumbiri vivituseni. Eteno, na budo enda fakarada fitiri fetedo jebuguseni. ");
INSERT INTO kpr_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","God dae sakai sari da yaru seka eni ava divono dae sedo, namokena ijugusira. Natofo digari evia gosuse, ne dudukughedo, nenda tumondari Bajari kena fitarera. ");
INSERT INTO kpr_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Mave, natofo ove keveraera, a god gungubo tumonde bainghari kakatode dabade jo tatae irise, God beká ava tumonduse irarera amo, ne ivuga ghae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Arie Bajari, namaneda God, ni namanendae roera digari ambari usesi. Mave eni jo ninda tega iraeri. Namane ninda eveva ava tamboro dae sise, manaka gayeraesa. Ni rea eraesa da digari ava, jo nane tege sari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Ni fuyo a joba mutari ava jo uju ae eraesa. Sino fuka olta (altar) da dungoro dae ni jo uju ae, a ari ekoko kote doyaso dae sedo, sino fuka dungoro dae barago, ni jo uju aeri. Ninda uju mo, na ninda geka ningaeteni. Ava sedo, ninda geka ningono dae sise, namokena dengoro futusesi. ");
INSERT INTO kpr_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Eteso, “Na evirere,” siseni. “Ninda Agho Dari jokáda, rea aono dae sisesa, ava irira.” ");
INSERT INTO kpr_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Ava ari dae sedo refena. Ninda uju ava ivugaghae arena. Nanda God, ninda ijuga nanda janje jokáda fiteno irira. ");
INSERT INTO kpr_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Arie Bajari, namane sonemberaesa ainda bino eveva ava, ninda natofo isambu totorugusera da dombuda osa siseni, kotugo sise irarena. Jo itako doyae, sise irarena, ava ni kasama eresa. ");
INSERT INTO kpr_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Na jebuga da bino ava jo kivo edo, nasuka bu jighiraeri. Na sifo ghousa ninda sonemba aindae sise, irá gheraena. Ni rea ari sisesa, ava eraesa aindae barago, osa sise irá gheraena. Ninda natofo totorugeraera ainda jokáda na eredo ninda sari nange eraesa ava, a evovodae namane dubo buraesa, ava osa sise, itako jo beka gotae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Arie Bajari, na kasama erena, ni nandae joka eraesa. Ni rea ari sisesa ava use, na dubo buraesa aimi, na gagara ururaso irarena. ");
INSERT INTO kpr_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Na dara digari futo, jo tegari da kaugo irae aimi jimbe birurughetira. Nanda ari ekoko jo daba etoto irae aimi nanda irari kosasaghetiri, na emboro erebunena. Nanda kosasa da digari nanda beo amingori. Aimi etiri, nanda fakina dadabetiri, dubo bunise irena. ");
INSERT INTO kpr_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Arie Bajari, oroko nembo tavaraghe fu, na sonembase jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Mave na daoro ambono dae eraera ovia, sosighi urururaso dubo bunore! Mave nanda dara aindae ivuga eraera amo, buregaso ne meka gosuse jovereghe darigaore! ");
INSERT INTO kpr_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Mave namoa dere jiraera amo, aso oju edo ungu ata dadadaghururari, meka garera. ");
INSERT INTO kpr_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Nimokena mave furarera isambu, ivuga use riria aore! Mave ninda sonembadae ivuga eraera, ne aiyakoe sise eminge sise irarera, “Bajari teriago beká nimori!” ");
INSERT INTO kpr_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Na makasi edo jarutuse irena, avata Bajari, ni na kotise irá gheraesa. Arie nanda God, nanda sonemba kato nimori, tavaraghe fu, na sonembase jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Mave makasi embo sonembuse irá gheraera, God ne esimbugururari ivugaghae irarera. Ne dara barera, Bajari ne sonembarira. ");
INSERT INTO kpr_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Bajari, ne sonembuse gagara ururari jebuga irarera. Nu jo doyari, ne gitofu da sari ningari ae arera. Nune sonembari, ne enda nune futusira aminda, ivuga ghae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Ne kae barera amo, Bajari sonembururari jebugarera. ");
INSERT INTO kpr_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Na tofo nandae eminge siseni, “Bajari, na nimokena dara useni. Nandae joka use saso na jebugarera.” ");
INSERT INTO kpr_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Nanda gitofu nane mema itatama use ambono dadabare dae uju use, geka mendeni mendeni seraira. ");
INSERT INTO kpr_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Mave namo gari foa gheraera amo, ne jo geka bekáda bekáda sae eraera. Nanda kae da bino eko eni ningarera amo, ne totoi totoi nati do buvudo osa sarera. ");
INSERT INTO kpr_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Nanda kae nange bouvu digaetira, ava kotise, nandae mave imboe eraera, aimi unongu tofo tofo dengoroda se ningiraera. ");
INSERT INTO kpr_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Aminguse seraera, “Nu kae budo ambari dae urogho erira, itako jo jebugedo erae arira.” ");
INSERT INTO kpr_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Nanda eni, nundae nanda komana beká irariá sise, nangae uvu bayau dabade sore mindido ghusera aimi, na gukai futusira. ");
INSERT INTO kpr_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Arie Bajari, joka edo, nandae fakina sekago mutaso budo aimi nanda gitofu kena mino aone! ");
INSERT INTO kpr_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Nanda gitofu na jo dedo atai fati fetae usira, aindae na kasama erena, ni nandae ivuga eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Ni na sonemberaesa ainda beká mo, na rea eraena isambu beká vanembori. Na kaifa ururaso, ninda dombuda evovodae irarena. ");
INSERT INTO kpr_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Bajari, Israel embo da God dae sakai saore! Oroko a evovodae nundae sakai sise irore! Ai bekári. Ai bekári. ");
INSERT INTO kpr_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Sino fuka eni diya (deer) seraera, aimi dubo sagheari uvu tava eraira aminga ava, God, na nimo tava erena. ");
INSERT INTO kpr_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","God jebuga iresa, nimoa tava erena. Na nanjigo ya ninda dombuda tumonde bainghaeteni? ");
INSERT INTO kpr_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Nanda gitofu nandae eminge sise irera, “Ninda God nangetirai ni sonembaeri?” Sifo tumba evia soraraghae irena. Jivu nanda bayauri. ");
INSERT INTO kpr_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Anakora na giti jighido, natofode yaru didivuse vuredo jasedo ghuse, God dae sakai sise, nunda Kamboda ya teredo ghuseri. Ava kotise aindae, mema eraena. ");
INSERT INTO kpr_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Na redae mema ereni? Na redae bune jarutereni? Avori, jo amingae arena. Na sekago nanda tumondari nanda God a sonemba katokena fifituse, nundae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","7","Janje gagojurureari, na sekago numoa koteraena. Dubo mema nanda janje jokáda mo, kau voru viti bari gerira. Dubo bunari kau uvu usegha doriri Hermon nengae Mizar ghaekena ghedo jorughuse, vose foa Jordan buvuraira, amingaimi na fatira. ");
INSERT INTO kpr_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Ijighae Bajari da kavevera a dubo bari namokena irá gheraira. Tumbaghae, God nandae jebuga muturaira aikena, nunda yaru muturaira aimi yaru, didivuse banungeraena. ");
INSERT INTO kpr_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","God namokena sorega muturaira, numokena resena. “Redae na kotae eteso, nanda gitofuda ari ekoko einda bovu fufuse irareni?” ");
INSERT INTO kpr_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Evovodae nandae koviono sise, “Ninda God nangetirai ni sonembaeri?” sirureoro, na ambaetena, ava koteraena. ");
INSERT INTO kpr_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Na redae mema ereni? Na redae bune jarutereni? Avori, jo amingae arena. Na sekago nanda tumondari nanda God a sonemba katokena fifituse, nundae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Arie God, evetu genembo ni buneraera, gungubo kakato, a evetu genembo ekoko ainda dombuda ere, na sonembuse, “Embavokena kosasa tefo beká”, ava saetesi. ");
INSERT INTO kpr_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Nimo nanda sonemba katori, ava redae na doteso, gitofu mema namokena futero, ainda bouvu erefufeni? ");
INSERT INTO kpr_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Ninda Geka Beká a usasa mutu foa, na giti jijighuse bu ya Saion, ninda doriri kakara aminda buvudo, ninda banungari kambo nimo irá gheraesa, aminda terone! ");
INSERT INTO kpr_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Aminda teredo, na ninda olta (altar) da yaone! Arie God, nimoa nanda ivuga da susuri. Arie God, nanda God, na gita bu doruse, nindae sakai sise, yaru divarena. ");
INSERT INTO kpr_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Na redae mema ereni? Na redae bune jarutereni? Avori, jo amingae arena. Na sekago nanda tumondari nanda God a sonemba katokena fifituse, nundae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Arie God, anakora beká avia abua agira mane da sifoda, ni ari tomanako rea usesa ava setero, totofo namanenda dengoroi nininguseri. ");
INSERT INTO kpr_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Ni aminguse, evetu genembo ni jo tumondae usera ava, nine tofo ondeso buvu dariguseri. O ninda natofo mo, seteso, nenda enda futusesa aminda dighi anumbuseri. Aminguse, oro mendenikena fakarago eso, tofo ninda natofo sonembeteso aimi iti fafode useri. ");
INSERT INTO kpr_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Ninda natofo jo nenda misi gandigha aimi isoro edo enda baeri. A ne jo totofo nenda fakinai gitofu dedo enda baeri. Ni ne dubo budo ghusesa ava ijuguse, tofo mandi nemonde ise enda sanghimbe rurusevu. ");
INSERT INTO kpr_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Nanda Kini a nanda God, Jacob da imemesiri Israel embo da gitofu de atai fati feteraira amo, nimori. ");
INSERT INTO kpr_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Ninda fakinaimi namane gitofu ava dedo atai fati feteraera. ");
INSERT INTO kpr_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Na jo nanda feva, O nanda misi gandigha ava tumondururono, aimi na sonembaeri. ");
INSERT INTO kpr_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Tefo, namanenda sonemba kato namane gitofu jokáda sorisira, a evetu genembo namane imboe eraera ava, de atai fati fefetusira, amo nimori. ");
INSERT INTO kpr_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Namane evovodae nindae sakai sise a aiyakoe sise irarera. ");
INSERT INTO kpr_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Avata oroko mo, ni nange namane gukai muteso, gitofu namane de atai fati fefetumutari. Namane isorodae ya gheraera ainda jokáda, ni tefori. ");
INSERT INTO kpr_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Ni eteso namane gitofu dae oju sufero, namanenda gugua rea irira ava, nene sosighi e barimutari. ");
INSERT INTO kpr_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Ni ghabu sokinimbeteso, namane sino fuka de ojarigo umutari. Kotugo, namane mendeni kotae fuge doteso, teana embo da reighi aminda sisigaga edo irera. ");
INSERT INTO kpr_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Tofo ninda natofo, jo mino kitako oriri ari da kaugo irae avata, mino kitako da oriri umutasi. ");
INSERT INTO kpr_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Namanenda kokomana tinguda irá gheraera aimi, namanendae rea umutasa ava gido, dere jise gegha seraera. ");
INSERT INTO kpr_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Nine eteso, natofo nunda oro oro namane gi derejise gegha seraera. Ne namanendae fakina tefova sise, mendó faingheraera. ");
INSERT INTO kpr_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","16","Nanda gitofui unongu sise, nandae mendo kininje kananje ghuse dere jiraera, a evetu genembo na imboe eraera, aimi koviono seraera aindae, na sifo ghousa evia meka giraena. ");
INSERT INTO kpr_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Namane ni jo kotae eraera, a ninda evovo geka jo bejae eraera. Avata, ari avavaga namanekena sirorerira. ");
INSERT INTO kpr_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Namane nimokena jo gukai mutaeri, a ninda Agho Dari ava jo bejaeri. ");
INSERT INTO kpr_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Avata ni namane bu, taima sino evetu genembo gamburaera da vasa aminda fiteso, tumba jinjanghari jokáda irera. ");
INSERT INTO kpr_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Namane nimokena gukai futuse, teana embo da god kena banungaetera amo, ");
INSERT INTO kpr_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","ni anakora namane tambaetesi. Ai resira amo, namanenda kotari jungarida mo, isasambu ni kasama eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Avata, namane ni tumonduse irera aindae, gitofuimi namane kau sifi (sheep) de ojari geraera, aminga ava use, namane sifo ghousa evia dorureoro sirivo eraera. ");
INSERT INTO kpr_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Arie Bajari, diti fange ere! Ni redae ravesi? Diti fange ere, namane erá doyari beká eose! ");
INSERT INTO kpr_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Ni redae namanekena junguteresi? Namanenda dara a mema erá kotae eose! ");
INSERT INTO kpr_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Namane endada du degigitege fafaseteri. Sonemba eni tefo gido, namane gofedo, fonja jokáda fafaseteri. ");
INSERT INTO kpr_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Fu, namane sorase! Namane evovodae dubo buraesa aindae, fu, namane sonembase! ");
INSERT INTO kpr_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Na kini da javoda nanda duboda yaru eveva gaveva irira, aimi gate divarena. Gembono dae sise, nanda kotari geka eveva gavevaimi bedo erira. Buku gembari kato nunda sonemba susufikena buraira aminga ava, nanda aviva aimi na sonembari kini da yaru gembarena. ");
INSERT INTO kpr_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Gegenembo iritirera ainda jokáda, genembo mendode sovode beká nimori. Nimo geka seoso ghamo beungheraera. Sifo ghousa God nimoa esimbugeraira. ");
INSERT INTO kpr_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Nanda kini fakinago, gogho use, ninda isoroda kaiya ifuda dighi. Ai bekári, ni duroghaeri. ");
INSERT INTO kpr_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Kini da aito fugari ava fugutuse, ninda isoro kakato da giti jighido, evetu genembo nanjogo geka bekáda bekáda seraera, a ari bekáda bekáda eraera ava sorise, ninda gitofu sosighi e baresa. Ninda fakinaimi ninda gitofu de atai fati fetaresa. ");
INSERT INTO kpr_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Ninda feva da goroba isambu sighonogori, aimi ninda gitofu da gomoda gayeraesa. Oro oro irera, a isambu ninda ata duruda du fafasegeraera. ");
INSERT INTO kpr_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","God nimokena kini da anumba vasa futusira, ainda fakina jo nanjigo dadabae arira, evovodae irarira. Ninda natofo inonoda kaifa eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Ni ari dambu beká ava uju use, ari ekoko mo, gari imboe eraesa aindae, God nine tumonde baingheraesa aimi, nimoa gategedo, usu muká ninda jiroda avereguse, nunda ivuga barago, mutiri itatama use iresa. Kini eni nunda ivuga avavaga jo bae irira. ");
INSERT INTO kpr_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Ika moor (myrrh) a alo (aloe) a kotugo kásia (cassia) jasisera, ainda muká muno futo ava ninda embo boka aimi muno yavegeraira. Kini da kambo Sino fuka elefanti (elefant) da kore aimi gogho usera aminda, yaru didivururoro umo aresa. ");
INSERT INTO kpr_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Ninda kaifa kakato totorugetera ainda jokáda, kini mendeni da ade jamena ojighera fetirera. Ninda avo anumba ainda ungo gimandukena ninda datu gagara, ninda evetu seka ereruresa, aimi fetirira. Datu gagara ainda gogho mo isambu goldi (gold) numo bekáimi ariri. ");
INSERT INTO kpr_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Arie Kini da Datu Gagara, oroko dengoro indari dae erena, ningi! Kini kena vai edo, ninda natofo a kotugo nano namendi dodo, ninda kotari irari sekakena fitaresa. ");
INSERT INTO kpr_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Ni eveva gagara aindae kini sereregharira, ninda bajari numori, ava sedo nunda sari ava edo ghe! ");
INSERT INTO kpr_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Bogu nati Tyre seraera aimi ninda dombu doruse, fuyo fitarera. Kokotofu susu iti fafode nanjogo iritirera barago, ninda dombu darera. ");
INSERT INTO kpr_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Arie! Kini da datu gagara kini da kamboda teteriri eregosera! Nunda embo duroghae amo, goldi (gold) imi arigo firiseri. ");
INSERT INTO kpr_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Kini da datu gagara amo nunda embo gembari gegembaghaeimi avido irurari, nunda ade jamena tamo sandi iruroro, ne isambu unumbe bu yaoro kini kena terarera. ");
INSERT INTO kpr_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Ne ivugaghae riria use foa kinida kamboda terarera. ");
INSERT INTO kpr_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Arie nanda kini, nimokena resena, ningi! Ninda sasingu vide jamena ghagurugo sirorarera aimi, nembua maneda vasa nene budo kini arera. Nine aso, enda da frovensi isambu ainda kini nene edo, kaifa arera. ");
INSERT INTO kpr_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Nanda yaru gembena evia sise, ninda bino jighoro eroruse irarira evovodae, a kotugo evetu genembo isasambu sakai nindae sarera, kotugo evovodae sido yarera. Nanda yaru gembena evia didivururoro ninda binó ivegedo irurari, evetu genembo isambu nindae sakai sido evovodae yarera. ");
INSERT INTO kpr_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","God nu namondeda tere jungari vasa fakaragori a fakina ava, nune edo irira. Nu namonde dabade irise, sifo evia inono, namonde sonembari dae kato eraira. Dara rea sirorarira amo, nu anakora sumbudo namonde sonembarira. ");
INSERT INTO kpr_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Ava sedo, namonde jo oju ae arera. Enda daradaragharira, o doriri gigisedo ya eva jokáda tifugharira, ");
INSERT INTO kpr_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","o eva teria eredo, duka didivuse, sumbu viti founada beje foró arira, o reighi jajovurari aimi, doriri daradaragharira, avata namonde aindae jo oju ae arera. ");
INSERT INTO kpr_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","God da reighi aminda, uvu eni eresufira. Aimi, God Iká Bekáda irira ainda kambo kakara kena dubo jama muturaira. ");
INSERT INTO kpr_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","God reighi aminda irá gheraira ava sedo, jo nanjigo aminda daoro bejae arira. Nu sifo ataeghae eredo, reighi ava sonembarira. ");
INSERT INTO kpr_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Natofo endada irera, oju teria beká use, ungo ata dadaragayeraera. Frovensi a reighi isambu nenda gavanaghae dabade, ere fetedo ungo ata dadaragayeraera. God nunda bekaimi barara fugeari, enda munjeraira. ");
INSERT INTO kpr_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Bajari Fakina Kato namondeda jokáda irira, Jacob da God mo, nu namondeda tere jungari vasa fakaragori. ");
INSERT INTO kpr_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Fuvu, Bajari rea etiri sirorusira ava, fuge gaove! Nu nange nunda fakina ijuguse, enda da reighi mendeni dorusira, ava kote givu! ");
INSERT INTO kpr_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Evetu genembo endada isoro use irera ava, nune gajedo seari doyeraera. Nu nenda feva ava jighi joredo, nenda goroba fafaki ava fati jore fugedo, nenda bere ava dungeari aviraira. ");
INSERT INTO kpr_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Aminguse, nu eminge seraira, “Tataya dovu! Durumuguse, sunghe fete evia kasama evu: Nasuka namoá, na God! Enda jokáda a enda da natofo jokáda, jo eni namongo iraeri. Na teria bekári. Na giti jighari edo irena. Ava natofo kasama edo nandae sakai sarera”. ");
INSERT INTO kpr_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Bajari Fakina Kato namondeda jokáda irira, Jacob da God mo, nu namondeda tere jungari vasa fakaragori. ");
INSERT INTO kpr_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Natofo isambu ivugai ghabu foku foku ghevu! Yaru divu fumbu aruguse, God dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Ai resira amo, Bajari iká bekáda mo, igheghi ari da kaugori. Kokotofu isambu irera ainda iká bekáda, numori. A enda utu gambari utu gambari isambu ainda giti nune jighiraira. ");
INSERT INTO kpr_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Nune etiri, namane oro nunda nunda atai de fati fefetuseri. Kotugo, nune setiri, natofo endada irera, namondeda sari ningari useri. ");
INSERT INTO kpr_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","God namonde dubo ruruse, enda nune gatege futusira. Enda nune futusira aindae, namane Jacob da imemesiri ivuga erera. ");
INSERT INTO kpr_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","God nunda anumba vasada vitiya gheraira aminda, ivugai fumbu aruguse tavuya fusiroro, Bajari viti ya gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Namondeda God kena sakai sise, yaru divore! Namondeda Kinikena sakai sise, yaru divore! ");
INSERT INTO kpr_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","God mo kini iká bekádari. Nu enda da numamori. Yaruimi nundae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","God nunda anumba vasa kakarago aminda anumbirira. Aminda anumbirise, oro mendeni mendeni ava tavo eraira. ");
INSERT INTO kpr_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Oro isambu da babojegari, Abraham da God da natofo de dabade totorugedo irera. Ai resira amo, nunda fakina tomanako mo, jo isoro embo da amingo iraeri. Nunda giti jighari mo, fakina ghaeri. ");
INSERT INTO kpr_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Bajari mo iká bekádari. God da reighi aminda, nunda doriri kakara aminda fetirise, numoa sakai sarera, evevari. Amingaore! ");
INSERT INTO kpr_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Saion, God da ututu mo, ikáda a numo bekári. Enda da oro oro isambu, Kini tomanako ainda bogu begaya gosuse, ivuga eraera. ");
INSERT INTO kpr_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Reighi Jerusalem da furu aminda mave terarira amo, ambo sose fetari da vasa eveva God kena tambarira ava, nune ijugusira. ");
INSERT INTO kpr_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Kini nanjogo totorugedo, ututu Saion ava sosighi ari dae fuseri. ");
INSERT INTO kpr_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Avata, ne ava gi dudukughedo, beka sari bunise, oju sufuseri. ");
INSERT INTO kpr_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","7","Aminda ne ojuimi biri jarutuse, kau evetu mandi sasingu fumbari dae use, mema itatameraira, o bouti da natofo eva dika kanjijigo da jokáda ise oju eraira, ava useri. ");
INSERT INTO kpr_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","O namonde mo, God rea usira ava namonde nininguseri. Avata, oroko namondeda God, Bajari fakina kato ainda reighida teredo, totofo namondeda ditiimi eregosera. Reighié, nune evovodae tavo ururari dara eni jo tambae arira. ");
INSERT INTO kpr_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Arie God, ninda kamboda tere irise, namane dubo rurudo refesa ava koteraera. ");
INSERT INTO kpr_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","11","Evetu genembo isasambu irera, nindae sakai sise irera. Ninda binó tomanakoi ivegedo ira utu gambari utu gambari tafusira. Ni bekáda bekáda use, natofo kaifa eraesa aindae, ututu Saion da natofo ivuga arera! Natofo ijujuse aito eveva fugeraesa aindae, Judah frovensi aminda reighi nanjogo iritirera ava ivuga arera! ");
INSERT INTO kpr_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","13","God da natofo, na nemokena resena, namonde furu fakarago ututu Saion eminda dighi birurughusera, aminda viti denghe birurughuse, ainda duró ava tege givu! Aminda birurughuse, isoro embo da jungari vasa nanjogo irira, ava tege gae budo kotise irivu! Amingaovo dae resena da beká mo, sasingu amboda sirorarera aikena eminge sareva. ");
INSERT INTO kpr_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","“God roeraé isambu etiri sirorusira, namondeda God ri. Evovodae irarira. A namondeda giti evovodae jijighuse irarira.” ");
INSERT INTO kpr_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","2","Gekaé ninguvu! Sabua kotofu, makasi embo, evetu genembo iti fafode isambu, nemokena resena, dengoro jave ningivu! ");
INSERT INTO kpr_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Ghuna basetiri, na oroko geka isagha sari dae erena, ningivu! ");
INSERT INTO kpr_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Na gita doruse geka jungarida ava saono vosarira. Amingedo, geka da tuka se disugaono ningareva. ");
INSERT INTO kpr_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","6","Evetu genembo ekoko, nenda gugua ghayafadae sakai sise, sonemba aminda tambari dae kotise irera aimi, nanda gitofu edo irera. Gitofu resena, aimi na jimbe birurugharera, o mema dombu eni dombu eni nanjigo sirorarira amo, na jo oju ae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Genembo eni jebuga irari dae sise, God kena ghamanai ombu bari da kaugo iraeri. Jebuga irari da mino tambudo, God kena mutari jo genembo eni ae arira. ");
INSERT INTO kpr_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Ainda tuka mo, evetu genembo da jebuga ainda mino mo, teria bekári. Jo itako tambudo, mutari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Mino rea mutaetira, aimi jo itako sonembari, nu ofofo darige jebuga evovodae irari tambae arira. ");
INSERT INTO kpr_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Namonde isambu kasama erera, genembo eni jo ambudo nunda gugua bu yae arira. Evetu genembo isasambu, eveva a ekoko, dubo kotari kakato a jiro fafakara embo isambu ambudo, nenda gugua gayafa nenda imemesiridae do darigeraera. ");
INSERT INTO kpr_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Ne jebuga iriara da sifo aminda mo, ne enda nenda tofodae bu jighiriari. Avata oroko mo, ofofo nemo evovodae irari da vasari. Aminda evovodae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Genembo binóde aikena kau daba avori. Nu binonde irira aimi jo sonembari jebugae arira. Nu sino fukai ambarigo arira. ");
INSERT INTO kpr_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Evetu genembo mave totofo nemoa tumonderaera ava kote givu. Mave nesuka nenda gugua tumonderaera, aikena eminge sirorarira. ");
INSERT INTO kpr_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Ambari mo, evetu genembo setena, ainda giti jighari use, nune unumbe bu ya dari, sifi ambari garera. Evetu genembo kosasa tefo aimi ne de atai fatoro, ambudo totoi masa arera. Nenda reighi dodo ofofo vasada irarera. ");
INSERT INTO kpr_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Avata, God namoa nune ambari da fakina aminda ava saghimbe bari jebugarena. ");
INSERT INTO kpr_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Erá, genembo eni guguade arira aindae, dubo mema eove! Komana ati ghayafade ururarira ainda sifoda, erá mema eove! ");
INSERT INTO kpr_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Ai resira amo, nu ambarira, nunda gugua jo bu yae arira. Jo nunda gugua dabade ya ofofoda vosae arira. ");
INSERT INTO kpr_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Genembo mave endada irise, nunda irari aindae ivuga ururari natofo nundae sakai sarera, ");
INSERT INTO kpr_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","numoa barago nombua mane ambudo, ningaminda isera, daba aminda vosarira. Vosedo, usasa jo gae irise, evovodae tumbada irarira. ");
INSERT INTO kpr_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Genembo binode aikena kau daba avori. Nu binonde irira aimi jo sonembari jebugae arira. Nu sino fukai ambarigo arira. ");
INSERT INTO kpr_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Bajari God fakina tofo aimi beka afigedo, evetu genembo iji vitarida a iji vosarida irera, ava isambu numokena furoro dae aghi erira. ");
INSERT INTO kpr_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","God nunda ututu Saion gari duróde aminda ghedo, nunda usasa janimberaira. ");
INSERT INTO kpr_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Namondeda God refira, a jo sainghe furaeri. Nu avaraka buburaghae dombuda aviri, yaura vovoga aimi jimbi birurughiri refira. ");
INSERT INTO kpr_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Nunda natofo kau nange ijujarira ava, utu endaghae foa gosuroro ijujari dae resira. ");
INSERT INTO kpr_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","“Nanda natofo nanda geka ningiraera, a nanda evovo geka kaifa ari dae sise, joba namokena de dungedo futusera, ava aghi aovo furore!” ");
INSERT INTO kpr_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Utu da duróimi ijugerira, God mo, ari bekáda bekáda ava nembo eraira. A ijujari kato beká, numori. ");
INSERT INTO kpr_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Nanda natofo Israel embo, nininguruvu, saone! God, nenda God namori. Nenda kosasa rea eraeva isambu, tegono ningareva. ");
INSERT INTO kpr_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ne dombuda sari dae erena, avata, nenda joba muturaeva ekori o sinofuka de dunge muturaeva jo inono irae ava erá koteóve! ");
INSERT INTO kpr_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Eregoseva? Borumakau da kandana nenda karoda irira, a gouti unduraeva barago, redae bareni? ");
INSERT INTO kpr_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Ai resira amo, taimada sino fuka a borumakava nanjogo jiro fumbari aminda unduraeva isambu nanda fitariri. ");
INSERT INTO kpr_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Taima da rika a roera endada jebuga irera ábarago nanda tofori. ");
INSERT INTO kpr_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Na ighoi ambaetena, jo nendae bayau dae benunu sae aeteni. Ainda beká mo, enda da roera reju irera, isambu nanda tofori. ");
INSERT INTO kpr_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Na burumakauva kandana ainda fisí, o gouti da ororo mindarena, aĩ? ");
INSERT INTO kpr_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Ava sedo, God fakina kato, na ne dombuda resena ainda beká mo eviri. Ne rea namokena mutari siseva ava, mutareva. Avata nenda joba beká namokena mutareva amo, beka afigedo nandae aiyakoe sareva, avori. ");
INSERT INTO kpr_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Dara nanjigo furarira amo, nandae kori sevu, ne sonembururono nandae sakai saove! ");
INSERT INTO kpr_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Avata God ari ekoko embokena eminge resira, “Nanda Agho Dari redae teguterevu? Kotugo nanda evovo geka nombua manekena futusena, aindae redae sakai resevu?” ");
INSERT INTO kpr_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Aminge resena da beká mo, ne dengoro indiraena ava bu fugeraeva. Nanda geka itako jo bae eraeva. ");
INSERT INTO kpr_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Ne bagia kakato tambudo, nemonde komana usevu. Aminguse, yagera kakato ainde dabade tatedo, umo use ireva. ");
INSERT INTO kpr_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Ne evovodae besiga use, geka eko sari dae kaifa use irá gheraeva. Ne kotae kotae gungubo seraeva. ");
INSERT INTO kpr_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Ne totofo nenda nano namendi dae aji seraeva. A nenda irari gosuse ijujeraesa. ");
INSERT INTO kpr_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Ne amingudo fuseva ava, na rejo eni jo saeri. Amingudo feno gido, na nemongo ava kotisevu. Avata oroko ne dara eraeva ava isagha sise, dombuda resena, ningivu! ");
INSERT INTO kpr_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Na ningi ningaego eraeva, ava dengoro afige ningivu! Jo nanda geka ningae areva amo, ne sosighi aono, jo mave ne sonembae arira. ");
INSERT INTO kpr_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Na kakara ari sareva amo, beka afigedo, nandae aiyakoe sareva. Ainda beká mo, nenda joba beká namokena mutareva, aiyakoe sari avori. Mave nanda geka ningido amingarira amo, ne na sonembuse jebuga mutarena. ");
INSERT INTO kpr_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Arie, God, ninda dubo bari sifo ghousa ijugeraesa aindae sise, na joka aetesi! Ninda joka ari tomanako aimi, nanda ari ekoko isasambu ghaje fugaetesi. ");
INSERT INTO kpr_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Nanda ari ekoko isambu seghaso, na eveva aone! ");
INSERT INTO kpr_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Nanda dara ava, na kasama erena. Nanda ari ekoko ainda bouvu ava, sifo evia inono, na itatamuse irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Na nimokena ari eko useni, nisuka ninda dombuda ari eko eteno gido, aindae ni nandae “eko” sisesi. Ava sedo, namo ijujeresa amo, evevada eresa. Ã kotugo, nanda dara da bouvu ava fumbono dae resesa amo, geka bekári. ");
INSERT INTO kpr_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Na sirorusena amo, ari eko jokáda siroredo refena. O saone, na aya tambuno ambo tafusegusira ai tano ghedo, na ari eko jokáda siroredo refena. ");
INSERT INTO kpr_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Ni geka beká sari ã ari beká ari ava uju eraesa. Avori, ninda dubo kotari ava namokena mutaso sembudo, nanda dubo joká bedo are! ");
INSERT INTO kpr_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Nanda ari ekoko bu darigaso, na eveva aone! Nanda ari ekoko seghe kosughe fugaso, na eveva aone, nanda asisi forosogo beká ava are! Avata rofoma amo jo foyago beká iraeri. O namo segharesa amo, nanda dubo joká foyago beká ava arira. ");
INSERT INTO kpr_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","“Avori” saso, na sekago divu fuse, sino tavuya da duka nininguse, riria aone! Ni nanda jebuga fati munjisesi, a kotugo, nanda fakina ava jighi bejisesi. Avata sonembaso, na sekago dubo jama arena. ");
INSERT INTO kpr_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Ninda diti gajaetesi! Erá fuge, nanda ari ekoko geose! A nanda ari ekoko isasambu ghaje fugaetesi! ");
INSERT INTO kpr_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Arie, God, nanda dubo aso, eveva ã kakara are. Ã kotugo, asisi seka eni, ni tumonde gogoghombarira ava, nanda dubo jokáda fitaso irare. ");
INSERT INTO kpr_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Erá na dirigeóso, ni do buvu ya esike irione! Ninda Asisi Kakara namokena erá bu dirigeóso yeure! ");
INSERT INTO kpr_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Ninda sonemba muteaso, namane ivuga eraera. Ainda ivuga ava, sekago mutaso itatamaone! Ã kotugo, na nange ninda geka ningido, sekago ava ari uju arena ava kotise, ni sonembaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Amingaresa amo, na ninda agho dari ari ekoko embokena ijugaono kasama use, ne dubo jovereghari, foa ni tambarera. ");
INSERT INTO kpr_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Arie, God, na genembo deteno ororo gutusira ainda bouvu ava, joka edo erá namokena muteose dae sise, benunu resena. Sonembaso, na jebuga irarena. Aminguse, na ninda kavevera aindae, ivugaghae osa sarena. ");
INSERT INTO kpr_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Bajari, sonembaso, na beka fainghedo, nindae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Na joba nimokena mutaetena, avata ni joba amo jo uju ae eraesa. Joba futuse dungeoro avirureari ni gido, jo ivuga ae eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","O joba nane mutarena amo, na tumo darido, nanda ari ekoko vujeguse, nanda asisi ninda ungoda fitarena. Arie, God, evetu genembo namoá avaga tumo darido nimokena ya gheraera, nenda asisi ava, ni jo imboe use ighagha ae aresa. ");
INSERT INTO kpr_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Arie, God, ututu Saion gido, veka eveva ururaso fakina barira. Jerusalem da furu ava, sekago dighaso, namane gajari irarera. ");
INSERT INTO kpr_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Amingaso gido, joba nine mutoro dae sisesa ava mutarera. Mutoro gido, ni ivuga aresa. Amo, burumakava (bulls) ninda oltada fiti dungoro gido, ni ivuga aresa. ");
INSERT INTO kpr_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Arie kotofuko, ni redae ninda dara eraesa aindae sakai seraesi? Ni rekato evovodae evetu genembo God tumonderaera, ava katiyavara use, tofo sakai seraesi? ");
INSERT INTO kpr_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Ni kokomana sosighi ari dae manaka garuse irá gheraesa. Ni aji, a unongu ava seraesa, gharita da dikagori. Ni sifo ghousa tefo tefo gesire use irá gheraesa. ");
INSERT INTO kpr_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Ni ari eveva gaveva imboe use, ari ekoko ari ava ninda uju bekári. Kotugo geka beká jo sae irise, gungubo teria futo seraesa. ");
INSERT INTO kpr_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Arie, ni genembo aviva fotatari! Ni nanjigo gekaimi mema mutaso, komana itatama arira aindae, ivuga aresa. ");
INSERT INTO kpr_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Ava sedo, God ni dari ghamo ruruse iraresa. Ni reda iresa, aminda ghe God ni saghimbe bu fugarira. Ni diti jebuga iresa, ava sandi bu fugari du degite ambaresa. ");
INSERT INTO kpr_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Avaga nimokena sirorari, evetu genembo irari dambugo ava gido dudukugharera. Amingedo, ne tuturo edo, nimoa dere jise eminge sarera, ");
INSERT INTO kpr_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Givu, genembo eregoseva emo, nunda tumondari tofo nunda guguakena fifituse, nu gugua aimi sonembari, jebuga tambaetira ava kotise, irá ghusira. Nu jo God kena ambo sosise, fakina bae usira.” ");
INSERT INTO kpr_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Avata namo ika orivi da kaugo, God da kamboda viti irise, igi bababaghuse javuji eraira, amingori. God na evovodae dubo buraira, ava tumonduse irena. ");
INSERT INTO kpr_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Ni rea usesa ava kotise, na sifo ghousa aiyakoe sise sakai sarena. Ninda natofo da dombuda na ere fetedo, ni eveva eraesa ava, osa saono ningarera. ");
INSERT INTO kpr_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Mave “God tefo” kotarira amo, nu gogovara ai sari garira. Evetu genembo avavaga nenda dubo joká bebeta edo irera. Nenda ari isambu foká da kaugori. Eniimi jo ari eveva ae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","God utuda irise, evetu genembo fuge gosuse, evetu genembo dubo kotise, numoa tumonde baingheraera ava, tava eraira. ");
INSERT INTO kpr_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Avata ne isasambu emboro kosasaghedo ari ekoko eraera. Ne totofo bebeta edo irera. Jo dabakoimi ari eveva ae eraira, eniko tefo bekári. ");
INSERT INTO kpr_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","God resira, “Ari ekoko embokena kotari tefori. Ne nanda natofokena bagia use, namokena jo banungae eraera.” ");
INSERT INTO kpr_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Giti ne jo oju ae, avata ne amboda ghamo takegha arera. Giti amingo ava jo itatama aeri. Ai resira amo, God nunda natofo Israel embo da gitofu ava dari sirivu aoro, nenda etu bu mainge mainge arira. Bajari anakora ne imboe use, gukai futusira, ágido, Israel embo eredo, ne de atai fati fetarera. ");
INSERT INTO kpr_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Arie, jebuga Saion ghedo foa Israel embo kena sirorare! God nenda ati ghayafa sekago mutari barera amo, Jacob da imemesiri, Israel embo, isasambu ivuga use irarera. ");
INSERT INTO kpr_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Arie, God, ninda javo fakinagoimi na sonembuse, vujege jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Arie, God, nanda benunu resena evia, ningaso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Ivuga kakato namo dari dae refera. Evetu genembo joka ari tefo, God ningi ningae eraera, aimi namo tambu doaro ambono dae refera. ");
INSERT INTO kpr_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Avata, nanda sonemba a sorega fumbari kato mo, God numori. ");
INSERT INTO kpr_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Gitofu nandae ari ekoko ari seraera, aimi jovereghe nemoa gayare! Nu rea ari sisira ava use, ne sosighi arira. ");
INSERT INTO kpr_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Arie Bajari, na ivugaghae joba nimokena mutarena. Ni kavevera eraesa aindae, na nimokena aiyakoe sise sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Na dara nanjogo da jokáda ireno, na bu darigeteso jebuguseni. Nanda gitofo doreso, nanda diti mokoi gosuseni. ");
INSERT INTO kpr_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Arie God, nanda benunu ningi! Erá, nanda benunu resena evia imboe use, ninda dengoro gajeose! ");
INSERT INTO kpr_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Nanda benunu ningido na sonembe! Na mema itatama use, kotari tomanako futo use, garoro eteni. ");
INSERT INTO kpr_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Gitofuimi na daoro ambono dae setero ningido, ungu ata dadadagherira. Ari ekoko emboimi na kateyavara urureoro, dubo vevera use irena. Ne namokena dara bu refera. Aminguse, ne janje ekoghae na gari imboe eraera. ");
INSERT INTO kpr_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Na ghamo takegha erena. Na daoro ambaetena aindae oju use, gofari beká edo irena. ");
INSERT INTO kpr_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Beká resena, na ojuimi duduku dudukughuse ungu ata dadadagherira. Nanda tamo ghaunja bambariguse, ghamo kenkenghedo gherira. ");
INSERT INTO kpr_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Namokena ungu kau rika ribo da ghabu iraeti! Na ghumbu esike yama ghamo asegaeteni. ");
INSERT INTO kpr_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Na ghumbu soka beká yama reighi evetu genembo a uvu irae da vasada iraeteni. ");
INSERT INTO kpr_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Na bibitaimi ghumbu yama, nasuka nanda jungari vasa tambu jungaeteni. Yaura vovoga eko beká darige ya esike jungaeteni. ");
INSERT INTO kpr_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Arie Bajari, aso nanda gitofu beka soesa saore! Ainda susu mo, reighi begaya aminda kaera tataya a titigho ari avanembo urureari giraena. ");
INSERT INTO kpr_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Kaera tataya a titigho ariimi birurughuse, sifo tumba ava, kusia bagia a dara dombu eni dombu eni bu refera. ");
INSERT INTO kpr_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Sosighi ariimi vasa isambu bedo edo irira. Maketa vasada, kokomana katiyavaraimi a kotugo kokomana derariimi ganjimberira. ");
INSERT INTO kpr_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Gitofu eniimi namoa dere jise gegha yaruda fitaetira amo, na fakina edo fetaeteni. O nanda vasai namoa e darigedo, totofo sakai sise na dere jiraetira amo, na numokena jungaeteni. ");
INSERT INTO kpr_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Avata genembo namokena mema bouvu erefutira, amo nimori. Ni nanda karona, nanda ambo bego, a kotugo nanda komana beká edo iriasi. ");
INSERT INTO kpr_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Nangae kiki eveva gaveva dabade se ningido ghuseri, a kotugo God da tafaroro kamboda teredo, tafaroro dabade edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Bajari, aso nanda gitofu isambu evetu genembo seka irise amomonjegarera. Aso, nenda ofofoda diti jebuga furugaoro dae resena! Nenda ofo kambo mo ari ekokoimi bedo edo irira a nenda janje joká barago ekokori. ");
INSERT INTO kpr_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Avata namo, Bajari God kena sonemba dae kori saono, nune namoa saghimbe bari jebugarena. ");
INSERT INTO kpr_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Ataeghae, isonga a kotugo tumba evia inono nanda bouvu, mema numokena osa sise a aoro sirureono, nu nanda banungari ningiraira. ");
INSERT INTO kpr_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Gegenembo digari futo namo daoro ambono dae eraera, avata God na gagara urureari, na jebuga jovereghe foa gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Ne God jo igheghi ae irise, dubo jovereghari imboe eraera. Ava sedo, God roera isasambu reju irira ava kaifa eraira, aimi nanda benunu ningido, ne dedo atai duboda fatarira. ");
INSERT INTO kpr_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Nanda komana manai nunda beka gajari ava bejise, nunda kokomana ava dedo gaedo ghari dae usira. ");
INSERT INTO kpr_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Nunda geka mo nu vivigori, avata nunda janje jokáda kokomana imboe ariimi bedo usira. Nunda geka mo, ferukogori, avata rea sisira aimi, garureari mema siroredo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Nenda bouvu mema Bajari kena fiti dovu, nendae sorega nune fumbarira. Nu jo itatako doyari, evetu genembo bekáda bekáda eraera ava, gitofuimi de atai fatae arera. ");
INSERT INTO kpr_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Avata God, evetu genembo kokomana aito use daoro ambarera, ava seka iroro, nine rete budo foama nenda ofofoda gorogharesa. O namo, na God nisuka nimoa tumondarena. ");
INSERT INTO kpr_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Arie God, nandae joka aresa. Ai resira amo, nanda gitofu na de babasigeraera. Sifo evia inono namokena mema bouvu muturaera. ");
INSERT INTO kpr_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Osogo ari kakato sifo evia inono namokena mema bouvu muturaera. Namokena tataya eraera amo, jo daba etoto iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Arie, Bajari, na sifo reda oju eraena amo, nanda tumondari nimokena fitiraena. ");
INSERT INTO kpr_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","God nunda sari nanjogo ava eraira aindae, na sakai seraena. Na nanda tumondari God kena fitiraena, ava sedo, genembo eni namokena rejoa arira, na redae oju areni? ");
INSERT INTO kpr_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Nanda gitofu sifo evia inono namokena dara dombu eni dombu eni eraera. Nenda kotari namokena eko vanembori. ");
INSERT INTO kpr_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Namoa daoro ambono dae uju use, ne foa dabade junge fetedo, nanda yari furari fuge gosuse, namoa kato eraera. ");
INSERT INTO kpr_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Arie, God, nenda ari eko ari dae koteraera aindae, daso ghamo barera! Ninda janje ekoimi ururaso kasama edo, ghamo barera. ");
INSERT INTO kpr_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Nanda irari jarutarigo amo, ni kasama eraesa. Nanda diti jivu ninda roroda averege kaifa aso dae resena. Nanda jivu nanjogo vovoserira tegedo, ninda bukuda gembeso irira, tano. ");
INSERT INTO kpr_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Na nimokena sonembadae kori sarena amo, nanda gitofu kosegaso jovereghe yarera. Aimi na kasama arena, God nangae irera. ");
INSERT INTO kpr_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Bajari nunda sari nanjogo urureari na sakai seraena amo, nangae irera ava kasama erena. ");
INSERT INTO kpr_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Na nanda tumondari numokena fitiraena, ava sedo, genembo eni namokena rejoa arira, na redae oju areni? ");
INSERT INTO kpr_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Arie God, na nimokena joba rea mutari dae beka gagojusena, ava mutarena. Nindae aiyakoe sise nanda joba nimokena mutarena. ");
INSERT INTO kpr_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Ai resira amo, na tataya jokáda ambaeteni, avata na saghimbe beso jebuguseni. Ni jo doyaso gitofuimi na de atai fati fetae useri. Ágido, ninda dombuda usasa gosuse, jebuga irena. ");
INSERT INTO kpr_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Arie God, nandae joka beká, joka beká aetesi, ainda susumo na nimokena ambo sose fetari refena. Ninda ghabu duruda terono, yaura vovoga ekoimi na afuregaetira, ava darigari ghamo asegarena. ");
INSERT INTO kpr_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Na God ika bekáda aikena kori seraena. God, namokena rea aono dae uju eraira, ava nune ari beká sirorarira. ");
INSERT INTO kpr_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Nune utuda irise nanda benunu da mino futuse sari na jebugarena. Evetu genembo namoa kateyavara eraera ava, nune dedo atai duboda fatarira. Aminguse, God namokena rea ari sisira ava use, na evovodae dubo buraira ava ijugarira. ");
INSERT INTO kpr_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Nanda gitofu, raioni (lion) genembo mindiraera da kakaugo aimi na jimbe birurugheteri. Nenda dika mane mo, kau goroba a feva da goroba amingori. Nenda aviva mo, kaeya da dikagori. ");
INSERT INTO kpr_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Arie God, ninda teria kau mavega ava utu aminda ijuge, isagha are! Ninda usasa mutaso vose endaé beda are! ");
INSERT INTO kpr_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Nanda gitofuimi nane ombono bari dae sedo, futo bariseri. Na dubo bunise irena. Na vosono sandari dae sedo, nanda emboroda bako ghaghambuguseri, avata makoe, ne totofo du vovoseguseri. ");
INSERT INTO kpr_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Arie God, nanda tumondari nimokena amo jo roimi ari doyae arena. Na yaru didivuse, ninda javo jighono erarira. ");
INSERT INTO kpr_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Arie namoako, erone! Nanda gita a yuka ghae, divari dae erena! Nane giti yaru didivururono, iji vitarira. ");
INSERT INTO kpr_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Arie Bajari, evetu genembo utu gambari utu gambari irera, ainda dombuda nindae aiyakoe sarena. Natofo isambu irera, ainda dombuda fetedo, ninda javo jighono erarira. ");
INSERT INTO kpr_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Ni dubo rurudo refesa aimi, enda beda edo viti ya utu tamburaira. Ni rea ari seraesa ava, bekáda bekáda eraesa, aimi viti ya utu tamburaira. ");
INSERT INTO kpr_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Arie God, ninda teria kau mavega ava utu aminda ijuge, isagha are! Ninda usasa mutaso vose endaé beda are! ");
INSERT INTO kpr_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Reighi da babojegari ne geka bekáda bekáda vegeraeva, ai? Ne evetu genembo isambu inonoda ijujeraeva, ai? ");
INSERT INTO kpr_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Tefo! Nenda kotarida mo ari ekoko nanjogo aeteva ava kotise ireva. Aminguse, kusia bagia reighi eminda ututuse kaera tataya eraeva. ");
INSERT INTO kpr_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Ari ekoko embo ne tini jokáda siroredo buvurutusera, ai tano ghedo kosasa udo refera. Ne sirorusera, ai tano ghedo, gungubo sise irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","5","Jingabu da kakaugo ava nenda beka kae aimi beda edo irira. Avata, ne jo, jingabu mendeni genembo kosimi urureari tamo dedo jo gambae eraera, aminga ava iraeri. Ne geka ningaego use, sifo ghousa eko use irá gheraera, iji nanjigo jo dababae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Arie God, gegenembo ekoko setena, raioni (lion) ekoko aikena eraera, aminga ava use, nenda bekada dika de jojorege. Arie Bajari, raioni fakina kato einda dika jighi sosofughe! ");
INSERT INTO kpr_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Gegenembo amo uvu usoro sagheraira amingo ava use, manje tefo aore! Kau vive a kikisa emboroda fati jasivi geraera ava, nemokena amingari gaso dae uju erena. ");
INSERT INTO kpr_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Nine aso, ne kau tutubia ambu totoi tive enda jineraira amingari gaore dae uju erena, o kau kokoiya ambari ava siroredo sifo sevo jo gae eraira amingari gaoro dae uju erena. ");
INSERT INTO kpr_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Na uju erena, ne jo itatama ae iroro, kau vive firirigheoro, gharasa eari, yaurai bu fuseari manjeraira aminga ava, God janje ekoko edo, ne dari ambore! ");
INSERT INTO kpr_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","God ari ekoko embo sifo reda nenda ari ekoda mino futuse, ne dari ambarera amo, dambu irari emboimi gido, dubo jama ghae vure jasise, ari ekoko emboda ororo yausi gutuse ya foa gharera. ");
INSERT INTO kpr_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Ava gosuse, natofoimi eminge sarera, “Geka bekári, evetu genembo dambugo irá gheraera, nenda mino sirorari barera. Geka bekári, God amboda enda da evetu genembo ijujarira seraera amo, beká seraera.” ");
INSERT INTO kpr_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Arie, nanda God, nanda gitofukena namo sonembe! Mave namoa dari dae erera aikena, kosege fete! ");
INSERT INTO kpr_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Evetu genembo ari ekoko ari kakato aikena na sonembe! Evetu genembo kokomana anakora detero amomonjegusera evia, erá doyeoso, na deore! ");
INSERT INTO kpr_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","4","Bajari, gi! Evetu genembo setena, nemokena joka ari tefo bekári, aimi na daoro ambono dae, junge kaifa erera. Arie Bajari, na kosege dari dae sise, junge fetari dae eresufera da beká mo, jo nanda ari eko eni usena, o dara usena, o kosasa eni usena, aindae sise erera. ");
INSERT INTO kpr_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Bajari God fakina isambu da tofo, Israel da God, ere fu, na sorase! Evetu genembo ni ighagha edo, namane dari dae sise, aito usera aikena, erá joka eose! Ne rea usera ainda mino ava mutu, budo itatama aore! ");
INSERT INTO kpr_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Ne ungobu evia inono jovereghe foa, bogu begaya eminda sino maneimi gangara sise deindangheraera, aminga ava eraera. ");
INSERT INTO kpr_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Evetu genembo setena buvudo, kateyavara use, jijivu ekoko resera ningi! Geka ekoko nenda bekáda buvuruterira amo, tataya da kaiya ainda kaugori. Ne rea resera amo, mave enii jo ningae ari ava kotise, resera. ");
INSERT INTO kpr_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Avata Bajari, ni nendae gegha jiraesa, evetu genembo ni ighagha eraera ava, dere jise gegha seraesa. ");
INSERT INTO kpr_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Arie God, na ambo nimokena sose feteono, fakina nine futururaso, na fete gogoghomberaena. ");
INSERT INTO kpr_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Nanda God na dubo buraira aimi, namokena fuse, nanda gitofu de atai fati fefetuse, ijugururari garena. ");
INSERT INTO kpr_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Arie God, namanenda Bajari a sorega kato, namanenda gitofu daso ambarera amo, nanda natofo ninda sonemba kotae arera. Ava sedo, ninda fakinaimi, ne ondido bu soesa fugaresa. ");
INSERT INTO kpr_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Nenda bekaimi dara eraera, nenda geka isambu ekoko vanembori. Totofo nenda gogore ariimi jovereghe nemoa gayari ambore! Gitofu resena aimi, gungubo sise, jijivu teria futo seraera aindae, ");
INSERT INTO kpr_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","ninda janje ekoimi ne sosighi aso manjarera. Amingaso, evetu genembo utu gambari utu gambari aminda isambu kasama arera, God ni Israel tavo use kaifa eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Ne ungobu evia inono jovereghe foa, bogu begaya eminda sino maneimi gangara sise deindangheraera, aminga ava eraera. ");
INSERT INTO kpr_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Kau sino mane bayau tava use, jo mindoro inono ae urureari, gangaraghae deindanghuse eraera, amingeraera. ");
INSERT INTO kpr_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Avata namo, ninda fakina aindae yaru divarena. Sifo evia inono nindae beka fainghedo, na evovodae dubo buraesa aindae, yaruimi koko fuge divarena. Ni na gagara urureaso, nanda dara sifoda nimokena ambo sose feteraena. ");
INSERT INTO kpr_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Na nindae sakai sarena. Nimo nanda bereri. Arie God, nanda sorega kato nimori. God, nine na evovodae dubo buraesa. ");
INSERT INTO kpr_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Arie God, ni namane imboe use namane de atai fati fefetusesi. Ni namanekena janje ekoko use iriasi. Avata oroko mo, dubo jama edo jovereghe, namane jighaso erore! ");
INSERT INTO kpr_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Nine eteso, reighi Israel eminda enda daradara ghuse, sasarigedo betira betira ari usira. Enda benbanghuse embebegerira. Ava sedo oroko ava, aso, fa nunda ari fatonga ava are! ");
INSERT INTO kpr_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Nine eteso, namanekena roera fakarago siroriri, mema teriago beká eretafera. Namanekena uvu fakara mutari geteso, namane teteteghuse ya foa gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Evetu genembo ni igheghi eraera, aikena tataya refira ava darigaoro dae sise, ninda sonembada tano jigheso eretira. ");
INSERT INTO kpr_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Ninda natofo dubo buraesa ava, nange darakena darige jebugaetera ava kotise resena, namanenda benunu ningi! Ningido, ninda fakina tomanakoimi namane saghimbe, bu darige jebugaore! ");
INSERT INTO kpr_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","God nunda tafaroro kambo kakarago aminda irise sisira, “Reighi Sekem nane sosighi e budo, tano ghoredo, nanda natofokena soro vesa arena. Enda uvu ghajughu tevisa Sukot seraera, ábarago nane sosighi e budo, tano ghoredo, soro vesa arena. ");
INSERT INTO kpr_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Gilead frovensi mo, nandari, a kotugo Oro Manasseh ningiaminda anumbirera, ábarago nanda tofori. Ephraim ondi da jokáda mo, nanda isoro embo sirorudo refera, kotugo Judah ondi da jokáda nanda kini (king) sirorudo refera. ");
INSERT INTO kpr_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","O Moab mo, nanda uvu dimbu gutari agha dae ererurena. A kotugo natofo Edom da vasa nanda tofori. Ata anoso goroghusena amo, nanda yoyovari, aimi imbara ururono irarira. Filistia embo da enda sosighi e ruruse, na sosighi e bari da kuvai koko fuge resena.” ");
INSERT INTO kpr_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Arie God, na mave unumbari ya Edom embo da reighi begaya beká Sela, karo iti kinkanghusera, aminda beje terareni? Na mave giti jighi bu ya aminda teredo sosighi areni? ");
INSERT INTO kpr_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Arie God, ni namane mo, imboe beká usesi, ai? Arie God, ni namaneda isoro embo tataya ari dae yarera, ni yaresa, ai? ");
INSERT INTO kpr_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Arie! Sonemba futuru, gitofude isoro aore! Evetu genembokena sonemba bari sarera amo, beká eni jo sirorari bae arera. ");
INSERT INTO kpr_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Namonde God sonembururari tataya arera amo, gitofu de sosighié atai duboda fafatigarera. Amo nune namondeda gitofu firirighari, du fafasarera. ");
INSERT INTO kpr_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Arie God, nanda sorara ningi! Nanda benunu ningaso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Na vasa ajagha beká aminda fetirise, nimokena kori resena. Mana mana use resena, na budo fitaso, ambo sose fetari vasa eveva aminda jungase! ");
INSERT INTO kpr_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Ainda susu mo, ni nanda jungari vasa evevari. Aminda nanda gitofu na jo tambae arera. ");
INSERT INTO kpr_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Na do evovodae ninda vasa kakarago aminda irone! Arie, namoako, ninda ghabu duruda afurugaso, eveva irone! ");
INSERT INTO kpr_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Arie God, ni nanda beka gajari ningesi. Ningido, natofo ni igheghi eraera, aikena rea mutaresa ava, anakora namokena muteso ruruseni. ");
INSERT INTO kpr_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Kini da irari da ghaeko do ghousago yare! Nunda jebuga erá totoi gombu eure! ");
INSERT INTO kpr_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Arie God, nu evovodae ninda dombuda irise, namane kaifa edo ghare! Nu dubo buraesa, ágido nu nange kaifa ari sisesa ava use, nu kaifa edo ghe! ");
INSERT INTO kpr_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Amingururaso, nindae sakai sise, evovodae ninda javoda yaru didivuse sakai sarera. Sifo evia inono, nanda beka gajojuse rea mutari sisena, ava mutono baresa. ");
INSERT INTO kpr_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Na durumugedo, God da sonemba kaifa use irena, God nusuka na sonemburureari, dara a mema jokáda jebugeraena. ");
INSERT INTO kpr_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Namo nusukako nune gagara urureari irá gheraena. Nanda sorega nune fufurureari, evevada irá gheraena. Numokena ambo sose fefeturureono, gitofuimi jo fua na de atai duboda fatae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Na karo bunununghari amingori, namokena fakina dadabetira. Ne rekato na sifo ghousa de babasegari dae eraevu? ");
INSERT INTO kpr_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Na sifo ghousa fitovo vosono dae manaka garuse irá gheraeva. Ne nandae aji sise irá gheraeva. Nenda bekaimi nandae sakai seraeva. Avata nenda janje jokaimi na simbora eraeva. ");
INSERT INTO kpr_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Na nanda tumondari isasambuimi God kena fifituse irá gheraena. Namo sonembari jebugari dae sise, nusukako numoa gigituse irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Namo nusukako nune gagara urureari irá gheraena. Nanda sorega nune futurureari, evevada irá gheraena, numokena ambo sose fefeturureono, gitofuimi jo fua na de atai duboda fatae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Nanda jebuga nengae binóghaeda susu mo, God numori. Namo gagara ari kato fakinago mo, numori. Numo nanda bereri. ");
INSERT INTO kpr_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Arie, nanda natofo, nenda tumondari sifo ghousa God kena fifituse irá ghedo ghevu! Nenda bouvu mema ava numokena sedo ghevu! Ainda susu mo, namondeda bere numori. ");
INSERT INTO kpr_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Endada evetu genembo isasambu mo, eni jo ghousago irae arera. Kokotofu kotugo sabua isasambu God da dombuda eveva eni tefori. Nenda bouvu kau mavego ava sikere aetesa amo, isambu tefo bekári. ");
INSERT INTO kpr_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Kokomana dederuse, nenda gugua baresa ava, erá koteove! Erá komanada gugua bagia bareva aindae totofo sakai seove! O nenda gugua moni roera diguturarira amo, erá gido ghamo beove! ");
INSERT INTO kpr_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Avori, fakina isambu God da tofori, ava nune sirureari na umbo nanjogo ningido ghuseni. ");
INSERT INTO kpr_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Kotugo ni evetu genembo isasambu dubo buraesa. Arie Bajari, nisukako nine evetu genembo isambu da ari rea eraera aminda gosuse, mino mutaso barera. ");
INSERT INTO kpr_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Arie God, nanda God nimori. Nanda janje nimokena afigedo gherena. Nanda janje joka isasambuimi nindae uju beká erena. Kau enda kareva irae kainghari beká betira sasarigariguse nanda asisi nindae uju use angasa angasa gherira. ");
INSERT INTO kpr_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Ninda vasa kakara aminda isagha aso gaeteni. Ninda fakina, a duro kakaraghae ava ijugaso gari uju erena. ");
INSERT INTO kpr_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Ninda dubo bari, a kotugo kavevera mo, numo bekári, jo roera eni enda eminda amingo iraeri. Na aindae sedo nindae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Na sifo ghousa nindae aiyakoe sido ya ambarena. Na nanda ungo jighono erorurari nimokena banunguse irá gharena. ");
INSERT INTO kpr_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Ninda dombuda fetirise, nanda asisi kirumu berugaso mindi inono arira. Nindae roro use yaruimi sakai sise irarena. ");
INSERT INTO kpr_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Na avari vasada fasirise, nimoa koteraena, tumba soro ghousa nimoa kotise fase irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Ni sifo ghousa na sonemberaesa aindae, ninda ghabu itumo duruda irise, na ririaghae yaru seraena. ");
INSERT INTO kpr_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Na nimokena gangono ururono, ninda ungoimi na kaifa e tavo ururaso, jebuga irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Mave namoa daoro ambono dae kato eraera, ne ambari embo da vasada ya vovosegarera. ");
INSERT INTO kpr_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Ne isoro tataya use, daoro sirivo arera. Nenda tamo gambari sino maneimi mindarera. ");
INSERT INTO kpr_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","God sonembureari nunda gitofu de atai fatiraira aindae, kini (king) riria use irá gheraira. Mave God da javoda beka gajarera aimi, nundae sakai sise, nunda javo jighoro erarira. O gungubo kakato mo, God sari ambarera. ");
INSERT INTO kpr_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Arie God, nanda memadae resena, ningi! Nanda gitofudae oju erena. Namo sonembaso jebugari dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Ari ekoko emboimi manaka garuse irera. Namoa ufena daoro ambono dae kato erera ava sedo, kosege fete! ");
INSERT INTO kpr_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Ne avivaimi mema mutari dae sise, kotise irá gheraera. Geka seraera, kaiya siverego afari aminga ava, seoro mema siroreraira. ");
INSERT INTO kpr_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Ne meka jo gae irise, gungubo seoro ivege ya gheraira. Ne ufena evetu genembo eveva gaveva aindae aji sise, nenda bino eoro sembae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Ne totorugedo, kokomana daoro sirivo aore dae tofo tofo ghamo dedoruse manaka gayeraera. Nenda ivasi reda fifitigarera ava kotise, eminge seraera, “Ifu mave jo fumbae arira.” ");
INSERT INTO kpr_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Ne dara ari dae manaka garuse seraera, “Namonde taká tafasara ari da manaka beká ava gaeteri.” Ai resira amo, genembo da janje jokáda kotari rea irá gheraira amo, jungari bekári. ");
INSERT INTO kpr_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Avata God nunda goroba nemokena afuse, ne totoi nembo gagayegeraira. ");
INSERT INTO kpr_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Ainda susu mo, ne rea sisera aindae, ne sosighi arira. Evetu genembo nemoa gido gifua gitorotoro edo gharera. ");
INSERT INTO kpr_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Ainda beká sirorari gido, evetu genembo isasambu oju edo, God rea usira a etiri sirorusira ava kotise, aindae osa sarera. ");
INSERT INTO kpr_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Eveva gaveva irari embodae resena. Bajari rea usira aindae riria evu! Numokena ambo sose fetevu! Evetu genembo eveva gaveva isasambu sakai numoa saore! ");
INSERT INTO kpr_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Arie God, Saion aminda iresa, namane rejo ava ari dae beka gagosusera ava use, nindae sakai sarera, amo evevari. ");
INSERT INTO kpr_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","3","Ni evetu genemboda benunu ningido sonemberaesa. Ágido, endada iritirera nenda ari ekoko da bouvu aindae nimokena furarera. Namaneda ari ekokoimi namonde bu fatiraira, avata ni ari ekoko amo kote doyeraesa. ");
INSERT INTO kpr_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Ni mavejua gategedo unumbedo, ninda vasa kakarago aminda iroro dae fitaresa, aimi dubo jamaghae irarera. Namane ninda kambo kakarago ainda roera eveva gaveva ava barise, ivuga ghae iritirarera. ");
INSERT INTO kpr_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Arie God, namaneda jebuga mutari kato, ninda ari babaigo gae gitida eregosera aimi, namanenda benunu ningido, namane gitofu kena sorega fumburaesa. Endada evetu genembo reighi isasambu da iritirera, a soka beká evada a butuda iritirera, nenda tumondari isambu nimokena fitiraera. ");
INSERT INTO kpr_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Ninda fakina teriago beká ava ijuguse, doriri isasambu nine ututusesi. ");
INSERT INTO kpr_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Nine eva anje gugugugheraira ava, eoso binono gamburaira, a kotugo evetu genembo gogore use nimokena osogo futo eraera ava, nine eoso songheraera. ");
INSERT INTO kpr_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Endada evetu genembo tano reda reda isambu ninda tano babaigo eraesa, ava gosuse oju use, ghamo takegha eraera. Ninda ari ututeraesa aindae, utu gambari utu gambari ivugaghai fumbu aruguse irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Enda nine tavo tatau use, borija muturaesa. Nine eoso, enda raugo use bayau roera digari futo vivitigeraera. Arie God, nine ninda sasaka averegeoso, uvu isambu bedo ututeraera. Nine enda esimbuguse seoso, roera veka vivitegeraera. Emo ninda ariri. ");
INSERT INTO kpr_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Nine borija muteoso enda gae dureraera aminda dise, sasaka aimi enda safegeraira. Nine borija muteoso enda raugo use, roera veka seka vivitigeraira. ");
INSERT INTO kpr_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Nimo kavevera katori ava sedo ghaeko sifoda bayau dige faseraira. Ninda yari furari aminda dige faseraira. ");
INSERT INTO kpr_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Oka mane ningaminda kaifa eoso, mamandi digari fumburaera. Ganasa, enda fumbari aminda ivuga siroreraira. ");
INSERT INTO kpr_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Eke vasada sifi aimi dige faseari, enda tevisa farava vujiimi dige fasedo gherira, isambu aimi ivugaghae fumbu aruguse yaru divuraera. ");
INSERT INTO kpr_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Evetu genembo isambu, God da javo jighoro erorurari, ivugai fumbu arugaore! ");
INSERT INTO kpr_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Yaruimi isimbuse, God nunda javo durode ava jighoro erorurari, nundae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Sevu, “Arie God, ni rea ututeraesa evia gido, ghamo kenghari ungo ata dadadagheraira. Ninda fakina teriago beká ava gido, ninda gitofu ojuimi ninda dombuda tumoi baingheraera. ");
INSERT INTO kpr_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Evetu genembo endada iritirera isasambu, nimoa tumonde bainghaeraera. Ne nindae yaru sise, sakai seraera, ne yaruimi javono nimoa gatise seraera.” ");
INSERT INTO kpr_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Fuvu gaove, God rea evetu genembo dae etiri, nenda gae gitida gi dudukughusera, ava kotovo dae sise resena. ");
INSERT INTO kpr_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Nune etiri, eva gasumbetiri atai enda bekáda fete sembiseri. Susu aindae namane aminda fete ivugaimi vure jasiseri. ");
INSERT INTO kpr_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Nu fakinago bekári, ava sedo nu evovodae irise, oro nunda nunda ava ditimi jighi jijinimberaira. Gogore, osogo ari kakato nimokena osogo jo ae aoro dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Arie, endada nunda oro oro nemokena resena, ningivu, God tumonde bainghuse, sakai saore! Sakai beka teriago siruroro, isambu ningore! ");
INSERT INTO kpr_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Nune kaifa iri namonde jebuga irera, a kotugo namonde jo doyari duraeri. ");
INSERT INTO kpr_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Arie God, ni namane bu dere gosusesi. Kau siliva (silver) avarakada itioro, jeka voseari beká vanembo buraera amingava, nine namane dere gosusesi. ");
INSERT INTO kpr_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Nine namane bu feso, ninda vaghoda teteruseri. Namanenda gukada mema bouvugo ava fifitigusesi. ");
INSERT INTO kpr_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Nine eteso, namane gitofuimi fati jasedo iseri, mema tafusera evia inono evetu genembo avarakada mema a kotugo usegha da mema tamburaera amingori. Avata oroko nine eteso namane digutuse, iti susu fafode irera. ");
INSERT INTO kpr_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Na ninda kambo Jerusalem aminda joba nimokena dungari dae tige yarena, na nimokena joba rea mutari beka gagojusena, ava mutarena. ");
INSERT INTO kpr_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Na dara jokáda irise, nimokena rea mutari sisena ava, mutarena. ");
INSERT INTO kpr_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Na sino fuka unduse irena, ava olta (altar) da dungoro dae joba bu furarena. Na borumukava da kandana o gouti (goat) eini ava de ojedo dungono, imbosi nimokena utuda viti yarira. ");
INSERT INTO kpr_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Fuvu, ningove! Natofo maveju maveju God tumonde baingheraeva, fuvu, ningove! Na nemokena God nandae rea usira ava sarena. ");
INSERT INTO kpr_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Na numokena sonembadae kori siseni. Na yaru nunda javoda sakai sise, didivuseni. ");
INSERT INTO kpr_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Nanda dara jo vujegae aetena amota, Bajari nanda benunu jo ningae aetira. ");
INSERT INTO kpr_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Avata na geka beká resena, God na sonembusira, na rea sise banungusena, nu niningusira. ");
INSERT INTO kpr_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","God dae sakai resena, ainda beká mo, na banungusena amo, nu jo ningi ningae da kaugo aeri, a nunda dubo bari a kavevera namokena jo doyaeri. ");
INSERT INTO kpr_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Arie God namanendae joka use esimbugase! Namanendae kavevera ase! ");
INSERT INTO kpr_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Amingaresa amo, natofo tomanakogo endada irera ninda uju ava kasama arera. Kotugo, jebuga mutari da fakina ninda tofo edo irira, ábarago natofo isambu kasama arera. ");
INSERT INTO kpr_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Arie God, nanda uju mo, evetu genembo isasambu nindae sakai sise, ninda javo jighoro erarira. ");
INSERT INTO kpr_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Na uju erena amo, oro oro isasambu dubo jeuro use vurejasore. Ainda susu mo, ni natofo isambu inono da ijujeraesa. Kotugo endada oro isasambudae emboro eveva nine ijugeraesa. ");
INSERT INTO kpr_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Arie God nanda uju mo, evetu genembo isasambu nindae sakai sise, ninda javo jighoro erarira. ");
INSERT INTO kpr_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Namondeda vasada bayau eveva gaveva ava beká jijighusira. God, namondeda God, namonde esimbugusira. ");
INSERT INTO kpr_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Beká resena, God namonde esimbugusira. Oro nunda nunda utu gambari utu gambari aminda irera, nundae igheghi aoro dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Arie God, ere fete! Ondi, ninda gitofu sumbu taraghaore! Evetu genembo ni imboe gamboe eraera ava, ondi bera beraghe, rojedo sumbu taraghaore! ");
INSERT INTO kpr_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Ondi bera beraghe, ne kau imbosi rave ise dadaberaira aminguse, a kotugo tavaya avaraka dombuda tiveraira avavaga use, ya tefo aore! Arie God, ari eko embo ninda dombuda ambu tefo aoro dae uju erena. ");
INSERT INTO kpr_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Kotugo nanda uju eni mo, evetu genembo God da sari vanembo eraera aimi, nunda dombuda fetirise, ivugaghae ivisa kavisa arera. Aminguse, ne divu fusedo ghuse, ivugaimi fumbu arugarera. ");
INSERT INTO kpr_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","God kena yaru divore! Javono numoa gatise, yaru divore! Nunda emboro rerebevu, nu foroga nunda ghasemodae budo, etoda anumbe furare! Nunda javo mo Bajari ri. Nunda dombuda fete ivuga aore! ");
INSERT INTO kpr_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","God, nunda tafaroro kambo kakara jokáda irise, babate da afa edo, roriri kaifa eraira. ");
INSERT INTO kpr_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Totofo irae a babate ainda kambo nune simbuge muturaira, a kotugo dibura embo nune unumbeari buvu, dubo jama eraera. O gogore osogo futo ari kakato baimara a memaghae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Arie God, ninda natofo giti beso uvu bayau irae vasada sefusera da sifo aminda, ");
INSERT INTO kpr_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Israel embo da God, doriri Sinai aminda isagha etiri nunda natofo gosusera, aimi fusira aindae, enda daradaragiri borija utudaghe ati tino tafusegarigusira. ");
INSERT INTO kpr_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Arie God, nine borija mokogo dirari dae eteso dise, ninda reighi fanotedo irei ava, jovereghedo fira, ari fatonga ava usira. ");
INSERT INTO kpr_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Ninda natofo Israel embo aminda dighi anumbuseri. God, ni kavevera use, makasi embokena reju daiva usira ava, nine muteso ruruseri. ");
INSERT INTO kpr_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Bajari aghi aoro dae setiri, evevetu reighida iritirisera aimi, bino budo era siseri, ");
INSERT INTO kpr_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“Kini (King) mane nenda isoro embode namonde sosighi ari fusera, aimi oju sumberi.” Amingusera amo, Israel embo evevetu natida iritirisera aimi, roera bagia barise fera oju sufuse goro ghusera, ava soro e bariseri. ");
INSERT INTO kpr_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Ainda jokáda, rika ribo da ove nunda tamo mo, auri siliva (silver) aimi gutuseri, ghabu mo auri goldi (gold) garigoimi gutuseri. (Avata ne mendeni meka givu! Ne redae isoro sifoda sifi da karoda jungutusevu?) ");
INSERT INTO kpr_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","God fakina kato doriri Salmoni aminda kini mane ondiri, oju sufusera da sifo amo, nune etiri borija dombu eni yaughari beká aimi rururughe vovosusira. ");
INSERT INTO kpr_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Arie, doriri Bashan, ninda mendo digari futo, ninda natofo barago amingori! ");
INSERT INTO kpr_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Arie Bashan embo, ne redae God nunda doriri Saion gategusira ava, tataseguse, dere erejirevu? Bajari aminda dighi anumbusira, a kotugo evovodae aminda irarira. ");
INSERT INTO kpr_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Bajari, nunda isoro ghasemo digarigo jo tegari da kaugo irae ainde Sainai ghedo ira, vasa kakarago aminda teterusira. ");
INSERT INTO kpr_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Nu utuda vitise, evetu genembo mendeni sandi bundisira ava unumbe budo vitisira. Evetu genembo gogore kakato barago numokena joba muturaera. Bajari God aminda irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Bajari dae sakai saore! Nu sifo inono evia namondeda mema bouvu nune fumburaira. Namonde nune seari jebugeraera. ");
INSERT INTO kpr_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Namondeda God mo, sari jebugari katori. Mave seari namonde ambarida vaghodaghe buvuraera amo, Bajari numori. ");
INSERT INTO kpr_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","O ari eko embo numokena osogo eraera, ainda jiro ava nune dari bebejegarira. ");
INSERT INTO kpr_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Bajari aindae eminge sisira, “Nenda gitofu nane sandido, doriri Bashan ghedo bu fua nenda ungoda fitarena. A kotugo nenda gitofu mendeni eva kafurudaghe sandi bu fua nenda ungoda fitarena. ");
INSERT INTO kpr_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Fitono, nenda gitofo daovo gitofuda ororoimi gaunghe vitari aminda sive sembiyareva. Kotugo nenda sino mane aimi gitofu da ororo ava sosofuse mindoro inono arera.” ");
INSERT INTO kpr_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Arie God, nine gitofu sosighi usesa ainda totorugari tomanakogo erera evia, natofo isambu eregosera. Arie God, ni giti jijighururaso, natofo ninda amboda ya, ninda vasa kakarago jokáda teterero eregosera. ");
INSERT INTO kpr_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Yaru divari kakato giti etero, gita dari kakato ambo gaetero, a kotugo ade jamena ghasaghasa eredorera aimi, soroda fetedo refera. ");
INSERT INTO kpr_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Arie, Jacob da veka beká Israel embo nemokena resena, eminda totoruge ireva, Bajari God dae sakai saovo dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Oro veveyako Benjamin ondi giti Judah ondi nenda giti jigharide nenda oro oro ava ambo gayoro, Sebulun ondi nenda giti jigharide fitoro a kotugo Naphtali ondi nenda giti jigharide ambo gaedo refera. ");
INSERT INTO kpr_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","29","Arie Bajari, kini (king) mane ninda fuyo tige, kambo Jerusalem bu foa gheraera, eminda namane sorise, ninda fakina nange ijugusesa, kau daba aminga ava sekago ijugaso gaore! ");
INSERT INTO kpr_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Arie Bajari, Egypt embo ava dombuda sase! Oro oro mendeni burumakava da kandana nenda mamandi da kaugo use, gogore eraera barago, dombuda saso, oju edo nenda siliva (silver) nimokena joba mutore! (Evetu genembo isoro uju eraera ava, soesa ondi bera beraghe taraghaore!) ");
INSERT INTO kpr_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Egypt embo nenda gavana mane mendeni dirigaoro furarera. Ethiopia embo nenda ungo jighoro erorurari God kena banungarera. ");
INSERT INTO kpr_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","33","Enda da oro oro isasambukena eminge resena, God dae yaru divuvu! Bajari utu etoda, utu anakora etiri sirorusira da etoda, anumbedo ya gheraera aikena, yaru didivuse sakai sevu! Nunda beka teriago utuda barara fugeraira aminga ava ningivu! ");
INSERT INTO kpr_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","God nu fakina isambu da tofo ava isuri basuri evu! Nu kini (king) ri. Nunda usasa Israel embokena futuse, kaifa e tavo eraira. Utuda mo, nunda fakina tomanakogo isagha erira. ");
INSERT INTO kpr_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","God nunda vasa kakarada ghe fururari evetu genembo itatamedo, ghamo kengheraera. God Israel embo tumonde baingheraera aindae resena. Nunda natofokena nunda fakina tomanakogo ava futurureari, ne fakina eraera. Ava sedo, God dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Arie God, na sonembe, uvu gaunganghe viti ojira, na duboi tatano erira. ");
INSERT INTO kpr_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Na fororo basusuda tifugherena, enda fakara eminda gegori. Na uvu kafuru sorodari, a kotugo eva fumbasa futo use, fatari mindi ambono dae erira. ");
INSERT INTO kpr_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Na sonembaso dae kori sise irana, fakina dadaberira, dubo ghoré ghoré mema resira, kotugo ninda sonemba kakovuse, sorara eno, nanda diti yaya iri, gari erebunena. ");
INSERT INTO kpr_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Evetu genembo susu tefo namoa imboe eraera ava, genembo eni da beo tegaetera amo, darige vitaetira. Nanda gitofu gungubo futo sise namokena osogo eraera. Ne fakina beká use, namoa daoro ambono dae eraera. Ne kateyavara etero, roera nanda tofo, na jo bagia ae, ava nemokena futuseni. ");
INSERT INTO kpr_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Arie God, nanda ari ekoko mo jo nimokena jungarigo iraeri. Na gogovara da ari use irena ava, ni kasamari. ");
INSERT INTO kpr_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Arie Bajari God Fakina kato, erá doyeoso nane eono, evetu genembo nimo tumonderaera ava, meka geore! Arie God, Israel embo da tofo, erá doyeoso nane eono, evetu genembo nimoa tumonde baingheraera, ainda javo sembae eure! ");
INSERT INTO kpr_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Na nimoa tumonde baingheraena aindae, namokena geka ekoko sesegero, na mekai jaruterena. ");
INSERT INTO kpr_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Nanda nano namendikena na kau mo teano embogo edo irena, nanda ambo begoimi namokena kau oro enidae arigo eraera. ");
INSERT INTO kpr_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Nanda kotari enikena jo fitae, nanda kotari a uju isambu ninda tafaroro kambokena fifituse irá gheraena. Jijivu ekoko nimokena sesegeraera, ainda bouvu ava, nane fumburaena. ");
INSERT INTO kpr_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Na uvu bayau reta use tofo fitiono vovosurureari, natofo nandae geka ekoko sesegeraera. ");
INSERT INTO kpr_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Na tou rovarova urureono, ne nandae gegha jiraera. ");
INSERT INTO kpr_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Emboro soró soró ava nenda kiki namoa nembo sariva nembori, a kotugo uvu fakara mindi jiro birurughari yaru namoa isimberaera. ");
INSERT INTO kpr_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","O namo, Bajari, nimokena banungarena. Nine sifo reda uju aresa aminda, na sonembe. Ni na dubo bu gogoghomberaesa, kotugo na sonembari dae sisesa aindae, na sonembaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Erá na tauya basusuda tifugheono dae sise, na sonembe! Erá gitofuimi na deoro dae sise, na kaifa ururu! Kotugo uvu kafuru aminda na kaifa ururu, jebuga irone! ");
INSERT INTO kpr_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Erá doyeoso, na useghami viti jarigiure! Erá doyeoso, na ghighi eminda mindi ambeone, o tifughe ambari emboda bakoda voseone! ");
INSERT INTO kpr_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Arie Bajari, nandae evovodae kavevera use, dubo buraesa aindae, na sonembe! Nandae joka eraesa aindae, namokena jovereghe! ");
INSERT INTO kpr_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Na ninda saramana katori. Erá nanda dombuda jungeose! Na dara eko beká eretafena. Tavaraghe fu, na sonembase. ");
INSERT INTO kpr_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Fu namokena utua edo sonembaso jebugaone! Gitofu da ungoda na saghimbe bu darige. ");
INSERT INTO kpr_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Nandae jijivu ekoko seraera, ava ni kasama eresa. Kotugo, nanda gitofu nange eoro, na meka giraena a nanda javo sembae eraira, ava ni eregosesa. Nanda gitofo isambu ni kasama eresa. ");
INSERT INTO kpr_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Jijivu ekoko futo sari aimi na ghamo gaetiri bune jaruterena. Nandae joka edo sonembaetira aindae, gigitusena, avata aminda eni gegori. Mave na eghovo daetera ava kotise kakovusena, avata gegori. ");
INSERT INTO kpr_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Na ighoi usira, nandae kae ava futuseri. Na dubo saghusira, nandae vaini dokegha ava futuseri. ");
INSERT INTO kpr_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Na uju erena, nenda kirumu karumu rise, aimi ari kosasaghedo sirivu aeteri. Kau daba aminga ava, ne God kena sino fuka dungarera ava rise, aimi ari gofe dudo ghuse irore. ");
INSERT INTO kpr_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Aso, nenda diti digoi are, kotugo nenda guka degagururari, evovodae gofuse irore! ");
INSERT INTO kpr_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Ninda janje ekoko averege nemokena vosare! Aso ninda girivaita aimi asugari itatama arera. ");
INSERT INTO kpr_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Na uju erena, ne reda dighi anumbusera, aminda natofo sirivu aeteri, kotugo nenda dobo do dumbaeteri. ");
INSERT INTO kpr_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Ai resira amo, evetu genembo nine ghamo baoro dae usesa aikena, ne mema bouvu erefutera. Kotugo, evetu genembo nine eteso, mema eretafera aindae unongu seraera. ");
INSERT INTO kpr_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Nenda ari ekoko isambu gembu fitido ghe! Erá doyeoso, ninda jebuga muturaesa, ava tambu beore! ");
INSERT INTO kpr_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Na uju erena, nenda javo jebuga evovodae irarida buku aminda ghajaresa. Ninda natofoda javo gembaresa ainghae dabade, itako jo gembae aresa. ");
INSERT INTO kpr_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Avata namo mema itatama use, mana mana beká ava erena. Arie God, na saighimbe bu fiti jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Na yaru didivuse, God dae sakai sarena. Na nundae aiyakoe sise irarena aimi, nunda fakina tomanako isagha arira. ");
INSERT INTO kpr_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Sino fuka da mamandi o burumakava da kandana eni bu oje dungedo joba mutarera amo, Bajari ivuga itako arira. O nundae sakai sarena amo, nu ivuga ambari ava arira. ");
INSERT INTO kpr_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Evetu genembo mave mema itatama use irera aimi, God da sonemba garera, ne ivugai jarutarera. Evetu genembo God tumonde baingheraera aikena ghamo erarira. ");
INSERT INTO kpr_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Ai resira amo, Bajari makasi embo da benunu ningiraira, a kotugo nunda natofo diburada irera ava, kotise irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Arie utu, enda a karaje a kotugo sino fuka, oka, a rika nanjogo ainda jokáda ireva, ne isambu God dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Ai resira amo, God nune sari Jeruselem embo jebugarera, a kotugo sonemba futuse, Judah frovensi da reighi nanjogo nune sekago itarira. Nunda natofo aminda dighi anumbedo, enda ava nene tofo arera. ");
INSERT INTO kpr_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","God da saramana kakato Israel embo da imemisiri gamemisiri aimi enda ava nene tofo arera. Kotugo, evetu genembo mave numoa dubo buraera aimi, aminda irarera. ");
INSERT INTO kpr_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Arie God, nine namoa dara kena sainghimbe baso jebugaone. Bajari, oroko nembo foa na sonembase! ");
INSERT INTO kpr_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Gegenembo mendeni namoa daoro ambono dae erera, ava dedo atai dubo da fatido aso, dubo bunedo meka gaore! Kotugo gegenembo mendeni, na dara jokáda irena aindae, ivugai jaruterera, ava ondaso jovereghe yaoro, aso nenda binó dadabare! ");
INSERT INTO kpr_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Gegenembo aimi namoa sise dere jido gherera, ava fugaso gofedo meka gaore! ");
INSERT INTO kpr_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","O evetu genembo nimokena ya gheraera amo, aso ne dubo jama use vure jasedo ghaore! Evetu genembo nine saghimbe beso jebugusera aimi, nindae aiyakoe sise eminge sise irore, “God nusukako numóa teriagori!” ");
INSERT INTO kpr_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Arie God, na rojari a kotugo na makasi bekári. Ava sedo tavareghe, namokena fu! Arie Bajari, nanda sonemba kato eni tefori. Erá gaimbo eose, totoigo fu, na sonembase! ");
INSERT INTO kpr_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Arie Bajari, na nimokena ojeni. Namo kaifa aso dae resena. Erama doyeoso, gitofuimi na de atai duboda fatiore! ");
INSERT INTO kpr_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Ni ari dambugo beká eraesa, ágido na sonembaso dae resena, a kotugo na darakena saghimbe bu! Nanda benunu ningido, na sonembaso jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Saso na nimokena junge fetarena! Nine se, nimokena tere fetono, na gagara ase! Nanda ambo sosari vasa a kotugo bere mo, nimori. ");
INSERT INTO kpr_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Arie nanda God, namoa ari ekoko ari kakato aikena saghimbe bu darige! Evetu enembo sembae use, namokena mema mutari koteraera aikena, na saghimbe baso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Arie Bajari, fakina isambu da tofo, nanda gigitari isasambu nimokenari. Na sasingako irise tuturo edo nanda tumondari nimokena fifituseni. ");
INSERT INTO kpr_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Nanda gaiga nimokena garuse irá gheraena. Na sirorusena, ai tano, nine kaifa e tavo eso irena. Na evovodae nindae sakai sise, irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Nanda sorega fumbari kato fakingo nimori. Ninda sonemba namokena gosuse, ni mavega ava natofo tomanako kasama useri. ");
INSERT INTO kpr_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Na sifo evia inono ava nindae sakai sise, ninda duro usasaghae aindae osa seraena. ");
INSERT INTO kpr_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Jo, na embako usena aindae, na imboe ae aresa! Erá, namokena fakina dadabariá sise, na doyeose! ");
INSERT INTO kpr_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Nanda gitofo na daoro ambono dae uju eraera. Aminguse, ne se ningido irise, namo daoro ambono dae, manaka gaeyeraera. ");
INSERT INTO kpr_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Ne eminge seraera, “God nundae guka futusira. Erevu, namonde sumbu nu sandi baore! Nunda sorega fumbari kato eni tefori.” seraera. ");
INSERT INTO kpr_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Arie God, erá soka iriose! Arie nanda God, oroko nembo foa na sonembase! ");
INSERT INTO kpr_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Evetu genembo mave namoa dedo gaedo ghari dae arera, ava dedo atai duboda fafatigedo sosighi aso dae uju erena. Evetu genembo mave namokena mema mutari dae kato erera amo, aso meka gosuroro, nenda binó sembae are dae uju erena. ");
INSERT INTO kpr_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Na sifo evia inono ava nanda gigitari nimokena fitido gharena. Na giti nindae sakai sedo ghusena, oroko mo, tuturo edo, teria beká sido yarena. ");
INSERT INTO kpr_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Ninda ari eveva gaveva mo, jo tegari da kaugo ututeraesa aindae, vironu sedo gharena. Sifo evia inono ava nine sonembeoso namane jebuga tamburaera ava, sedo gharena. ");
INSERT INTO kpr_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Bajari God, ninda fakina muturaesa ava budo, aimi fuama, na ninda kavevera tomanakogo aindae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Na sasingu ireno ai tano, na nine ijugedo usesi. A ninda tano gae gitida gi dudukugharigo ututeraesa aindae, osa sise irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Arie God, oroko na embako eteno, beo furigha mongago etira evia, erá na doyeose! Nangae irise, na ninda ari babaigo ututeraesa, a kotugo ninda fakina tomanakogo ava sirurono, nanda sasingu imemesiri gamemisiri ningido ghaore! ");
INSERT INTO kpr_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Arie God, ari eveva gaveva utututeraesa amo, jo tegari da kaugo iraeri. Ninda fakinaimi ututusesa aminga ava, evetu genembo eniimi jo ari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Nine namokena dara a mema itatama aono dae futusesi. Avata nanda fakina sekago nine mutudo, na kaifa ururaso jo ambae irarena. ");
INSERT INTO kpr_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Nine sekago sonembaso na genembo binode ava arena. Ni nandae kavenu sekago saresa. ");
INSERT INTO kpr_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Arie nanda God, geka bekári, na nindae gita doruse sakai sarena. Arie, Israel embo da God kakarago, ni rea seraesa, isambu urureaso beká siroreraira aindae, nanda gita doruse yaru nimokena divarena. ");
INSERT INTO kpr_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Na nine sonembeteso jebugusena aindae, na nindae dubo jeuro use, gita doruse ivugai yaru sise fumbu arugarena. Dubo joka isambuimi nindae yaru sarena. ");
INSERT INTO kpr_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Evetu genembo namokena mema mutari dae kato usera ava, nine dedo atai duboda fafatigeteso, nenda bino sembae usira ágido, na sifo evia inono ninda ari dambugo ututeraesa aindae, vironu sedo gharena. ");
INSERT INTO kpr_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Arie God, ni nange sifo ghousa ari dambugo beká use ijujeraesa, ainda aito ava ijuge, namanenda kini kasama edo aimi ijujare! Ni nange bekáda bekáda use, natofo ijujeraesa ava, dengoro induduraso, namanenda kini (king) ningido amingare! ");
INSERT INTO kpr_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Nanda uju, God, ni amingaso, kini nu bekáda bekáda use, ninda natofo kaifa tavo arira. A kotugo, makasi embo sonemba tefo, nenda sorega kato mo, kini nu kavevera use, ne kaifa e gogoghombare dae, uju erena. ");
INSERT INTO kpr_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Nanda uju, nunda kaifada vare aminda bayau dighi fasarira, a kotugo evetu genembo da irari barago ivu durari irarera. ");
INSERT INTO kpr_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Na uju erena, sonembururaso namanenda kini makasi embo ava sorise, bekáda bekáda use kaifa arira! A kotugo evetu genembo mave makasi embo kateyavara eraera, aikena gitofu use dari itatama arera. ");
INSERT INTO kpr_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Na uju erena, iji nengae tambunoghae utuda ghousa mavega janimbuse irarera, ainghae dabade kini nunda natofo kaifa use irarira. ");
INSERT INTO kpr_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Na uju erena, borija kikisa etoda dise nunda esimbugari bu foa gheraira, kotugo ghasisi vareda dise esimbugari muteari bayau vitiraira aminga ava, kini nunda natofo kaifa use esimbugari bu furarira. ");
INSERT INTO kpr_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Na uju erena, kini nu ghousa mavego irarira, evetu genembo aito dambugo beká fugutuse irarera. A kotugo tambuno ghousa mavega janimbuse irarira, nunda natofo kena gugua ghayafa sirorari ivugaghae irá ghedo ghaore! ");
INSERT INTO kpr_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Na uju erena, kini da kaifa ari tano eva sovenikena ghedo ya sovenikena buvarira. Kotugo, uvu (Euphrates) Eiferate ghedo ya enda tano reda irira, aminda buvarira. ");
INSERT INTO kpr_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Na uju erena, nunda gitofu reighi evetu genembo a uvu irae vasada irari emboi nunda dombuda kauboi dadarigedo numoa tumoi baingharera. Nundae osogo eraera aimi, foama fororoda dombuimi dari fafasarera. ");
INSERT INTO kpr_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Na uju erena, Spain embo da kini a kotugo reighi butu butu ainda kini mane a reighi Sheba nengae Seba ghae da kini mane ainde dabade, numokena fuyo mutarera. ");
INSERT INTO kpr_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Beká resena, kini mane nanjogo irera isambu, nunda dombuda kauboi dadariguse tumoi baingharera. Nunda oro oro ainda evetu genembo isasambu nunda duruda iritirise, nunda sari ava edo gharera. ");
INSERT INTO kpr_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Makasi embo numokena sonembadae kori seraera ava, nune bu darigeari jebugeraera. Natofo mavekena gitofuimi kateyavara eraera, nébarago numokena sonembadae kori sirureoro sonemberaira. ");
INSERT INTO kpr_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Kini nu joka ari katori, rojari embo a kotugo makasi embodae joka eraira. Sonemba tefo embo ava sonembeari jo ambae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Natofo sonemba tefo setena ava gitofuimi mema futero tafuse irera ava, nune seari jebugeraera. A mavekena gitofuimi dari gayari dae eraera, nébarago dara jokáda saghimbe bu darigheraira. Ainda beká mo, nenda jebuga numokena teriago bekári. ");
INSERT INTO kpr_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Kini ghousago irare! Na uju erena, reighi Sheba da goldi (gold) ava nundae mutoro barira. A nundae banungururoro, God numo evovodae esimbugururari irare! ");
INSERT INTO kpr_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Na uju erena, vare isambu eminda bayau dige fasarira. A kotugo enda jiro fumbari aminda barago, bayau dige fasarira. Kau Lebanon frovensi iritirira aminga ava vitari garera. Na uju erena, reighi bogu begaya isasambu, kau ekeda badurugo ava use, natofo digari beká sirorarera. ");
INSERT INTO kpr_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Na uju erena, kini da binó evovodae irare! Nunda binó evovodae, kau iji janimbariguse irira, aminga ava irare! Na uju erena, evetu genembo isambu nunda jokáda esimbugari baeteri, nunda oro oro isambu sakai numoa sarera. ");
INSERT INTO kpr_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Bajari, Israel embo da God, aindae sakai saore! Nusukako roera durode ava ututeraira. ");
INSERT INTO kpr_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Nunda javo duro usasaghae ava sifo ghousa sakai sise jighoro eredo ghare! Nunda duró usasaghaeimi enda isasambu afurugare! Ai bekári, a kotugo, Ai bekári! ");
INSERT INTO kpr_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","(Eminda tano erena. Jesse da mandi David da banungari tano eviri.) ");
INSERT INTO kpr_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Geka bekári, natofo Israel embo jokáda mave janje joká keosogo beká eraera aikena, God ari eveva beká eraira. ");
INSERT INTO kpr_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","O namo, nanda tumondari feghako usira. Jo soka irae, nanda tumondari dadabe tefo aetira. ");
INSERT INTO kpr_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Ainda tuka mo, na evetu genembo God da Agho Dari ighagha use, “A jo rejo eni iraeri,” sise, ivuga futo usera aindae bengoso useni. Ari eko embokena roera isambu eveva siroreraera, siseni. ");
INSERT INTO kpr_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Ne fakinago a tamo mema eni tefori. Ne jo totoi kae tambae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Nemokena mema eni tefori, jo evetu genembo mendenigo memaghae iritirá gheraera amingo iraeri. Evetu genembo mendeni mema tamburaera avaga nemokena tefori. ");
INSERT INTO kpr_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Susu aindae nenda ivuga amota, kau guri duboda dighido isagha beká giraera ava gareva. A kotugo meka irae titigho ari ava nenda goghori. ");
INSERT INTO kpr_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Evetu genembo amo rea koteraera aimi misurugurureari eko vanembo eraera. Ne ari ekoko dombu eni dombu eni ari dae manaka garuse irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Ne God dere jise, itatako jo oju ae eraera, a kotugo nunda natofo ava kateyavara beká eraera. Nemo ivuga kakatori. A kotugo ne evetu genembo mendenikena mema mutari dae manaka gayeraera. ");
INSERT INTO kpr_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Ne God utuda irira aikena, geka ekoko seseguse ivuga ututeraera. A kotugo God da Agho Dari ighagha use, “A jo rejo eni iraeri.” sise, evetu genembo endada irera aikena, katiyavara use irera. ");
INSERT INTO kpr_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Susu aindae, nene rea seraera ava, God da natofo barago aminguse, nenda ambo gayeraera, a kotugo nene rea seraera ava totoi tumonderaera. ");
INSERT INTO kpr_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","A kotugo ari ekoko embo setena, eminge seraera, “Namonde rea eraera evia, God jo gae eraira. God ika bekáda irira jo kasama ae arira.” ");
INSERT INTO kpr_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Ari ekoko embokena gugua diguterira, a kotugo sifo ghousa digutuse irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Arie namoako, redae soro ghousa ari eko darigari dae korai use ireni? Redae korai janjago use ari eveva vanembo udo refeni? ");
INSERT INTO kpr_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Arie God, nandae mo, sifo ghousa mema ava muturaesa, sifo inono evia ataeghae nandae mema ava ghamo baono dae eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Na avaga saetena amota, a jo ninda natofo da kaugo iraeri. Ava sedo, na ainda kotari ighagha ari dae sise, resena. ");
INSERT INTO kpr_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Na ari evia nange kasama aetena aindae inini useni. Avata nanda munju jo inono ae etiri, mana mana udo fena, ");
INSERT INTO kpr_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","amboda, na ena, ninda tafaroro kambo jokáda teredo, nanda kotari afigetiri, ari ekoko embokena amboda rea sirorarira amo, kasama useni. ");
INSERT INTO kpr_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Arie Dara! Ari ekoko embo amo, God seriri vasada fitari, jo numbo irae, ne gosasaghe vovosegedo ambu tefo arera. ");
INSERT INTO kpr_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Ne totoigo amomonjegarera. Ne ya ambari embo da vasa eko aminda vovosegarera. ");
INSERT INTO kpr_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Nemoa taká aturu avavagori. Tumbaghae aturu edo, sifo ateari, kotae eraera amingori. Arie Bajari, ni nanjigo eraresa amo, ne manjarera. ");
INSERT INTO kpr_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Na kotari ekoko use itatamari sembae beká use, dubo mema useni. ");
INSERT INTO kpr_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Na kavakava edo kotari dadabeari, sino fuka da ari ava edo ghuseni. Na ni itatako jo kasama aeri. ");
INSERT INTO kpr_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Avata na sifo ghousa ninda tinguda irá ghedo ghuseni. A kotugo, nine namoa ungoda bu jighi irá ghedo ghusesi. ");
INSERT INTO kpr_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Ninda ijugaimi namoa giti buraesa, a kotugo sifo gombuda nine namoa nati joká doruse unumbaresa. ");
INSERT INTO kpr_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Nisukako nimoa nanda uju bekári. Utuda a kotugo, endada eni nimongo tefo gido, nanda uju isambu nimokena fifituse irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Nanda fisíkena a kotugo asisikena rojaetena, avata God nu irira. Numo nanda fakinari, nusukako numoa evovodae nanda tofo bekári. ");
INSERT INTO kpr_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","O evetu genembo mave God tumonde bainghari imboe gamboe eraera amo ambarera. Ainda tuka mo, evetu genembo mave ni dodo, ove kevari ava tumonde baingheraera amo, nine daso sirivo arera. ");
INSERT INTO kpr_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","O namo taká God da tinguda irarena amo, evevago bekári. Namo Bajari God ava nanda ambo sose fetari vasadae ruruseni. Nune rea ututusira, ava osa sedo gharena. ");
INSERT INTO kpr_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Arie God, namane mo, ninda natofo bekári. Susu redae namane doyari beká usesi? Namanekena redae evovodae janje ekoko eraesi? ");
INSERT INTO kpr_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Ninda natofo anakora gategusesa ava sekago kotaso dae resena. Namane sabua use irero, ninda natofo beká aoro dae sedo, namane nange saghimbe bu darigusesa, a kotugo ututu Saion irá ghedo ghusesa, aindae barago sekago kotedo, joka aso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Reighié sosighi e de bebejegusera, ainda jokáda deinghuse fuge garesa, titigho beká useri. Gitofuimi ninda tafaroro kambo jokáda roera isambu titigho beká useri. ");
INSERT INTO kpr_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Gitofu ninda tafaroro kambo sosighi use javono gatise, koko fumbu aruguseri. A kotugo ninda vasa sosighi e rurusera aindae, nenda sobeya dadarigetero fefetuseri. ");
INSERT INTO kpr_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Ne kau faragho sarari embo karivako aimi ika mane je dive gafeoro vose fafaseraira. Aminguse roera reju irei ava, dive gafetero vovosusira. ");
INSERT INTO kpr_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","A kotugo nenda karivako nengae koroba (crowbar) ghae aimi ika faiyaghae botou dae tendi birurughusera, ava isasambu de bunununguseri. ");
INSERT INTO kpr_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Ne ninda tafaroro kambo jighi bununghetero vosetiri, avarakaimi dungutuseri. Ne vasa nimo tumonde baingheraera ava bebeta etero, ninda bino sembae usira. ");
INSERT INTO kpr_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Nenda uju mo, namane ava fati bebetegaeteri. Enda eminda God da Tafaroro vasa isasambu nene dungetero aviseri. ");
INSERT INTO kpr_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Ninda fakinaimi tano eni aso gaetera ava gigitusera. Avata tefori. Feroveta eni jo fetaeri. A kotugo, ari amo sifo nanjigo tano arira ava, mave eni jo kasama aeri. ");
INSERT INTO kpr_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Arie God, namanenda gitofuimi nimoa ghousa mavega dere jirareri? Ne sifo ghousa nindae jijivu sise irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Susu redae namane sonembari imboe eraesi? Ni redae tumbe taunghe irá gheraesi? Ne daso sirivo aoro dae uju eraera! ");
INSERT INTO kpr_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Arie God, bebede beká ni namanenda kini (king) edo, umbu nanjogo namane sonembudo fusesi. ");
INSERT INTO kpr_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Ninda fakina tomanakogo aimi nine eva jighi sarigusesi. A kotugo, evada gambauva mane irera, ainda jiro fati mumunjegusesi. ");
INSERT INTO kpr_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Nine eva gambauva da giti jighari ainda gifua fati mumunjegedo, reighi evetu genembo a uvu irae vasada nunda tamo soro vesa eteso, sino fuka aimi riseri. ");
INSERT INTO kpr_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Uvu veveyako karevada a kotugo ghamana tokáda kirikara gheraera ava nine eteso siroredo sumburaira. Kotugo nine eteso uvu babai amo gasumbedo irira. ");
INSERT INTO kpr_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Nine seteso, sifo nengae tumbaghae siroruseri. Nine seteso, iji nengae tambunoghae nenda vasada fefeteguseri. ");
INSERT INTO kpr_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Enda da tano nine fifitigusesi. Baimara sifo nengae ghaeko sifo ghae nine usesi. ");
INSERT INTO kpr_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Avata, Bajari, ninda gitofu nindae gegha jiraera, a kotugo gogovara embo nimoa ighagha urureoro ninda javo eko eraira, ava kotaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Arie Bajari erá, ninda natofo da asisi ribogo rojari beká ava, gitofu ekoko eikena fuge doyeose! Ninda natofo nindae sedo mema eretafera ava, erá kotae eose! ");
INSERT INTO kpr_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Beka gajari nine namanekena usesa ava kotedo ghe! Enda eminda vasa tumba aminda isambu titigho ari vanembori. ");
INSERT INTO kpr_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Arie Bajari, evetu genembo mendeni gitofuimi kateyavara ero, mema tafuse irera ava, erá doyeoso, meka geore! Sonembururaso, bate foivo nindae sakai sise, ninda javo jighoro erarira. ");
INSERT INTO kpr_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Arie God, javi e fu, ninda gitofu ava koto use ijujase! Evetu genembo ni ighagha baghagha use, sifo ghousa gegha jiraera ava, kotaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Ninda gitofu janje ekoghae fumbu aruguse irera ava, erá kotae eose! Ninda gitofu gogore use, koko se doyae tambuno erera ava, erá kotae eose! ");
INSERT INTO kpr_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Arie God, namane nimokena aiyakoe—aiyakoe beká resera. Namane ninda binó teria aindae osa resera. Nine tano nanjogo urureoso gi dudukugheraera, aindae vironu seraera. ");
INSERT INTO kpr_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","God resira, “Na evetu genembo ijujari da sifo seteno fetirira, a kotugo na evetu genembo nenda ari rea eraera aminda bekáda bekáda ategi arena. ");
INSERT INTO kpr_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Endada evetu genembo a roera nanjogo jebuga iritirera, ojuimi ungo ata dadadaghururoro, enda barago dara dara gharira, avata nunda susu nane anakora fiteno fefetusira ava, aono gambu kinghari beká edo irarira. ");
INSERT INTO kpr_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Ari ekoko ari kakato, erá gogore eoro dae sise, irá gheraena! ");
INSERT INTO kpr_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Totofo sakai sise, nenda binodae bengoso futo eraera, doyoro dae sise irá gheraena.” ");
INSERT INTO kpr_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Evetu genembo ijujari da fakina mo, jo iji vitarikena o iji vosarikena, jo ningaminda tambari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Tefo, God nusukako ijujari inonori. Evetu genembo mendeni seari darige buvuraera, a mendeni nune seari, vose mema itatama eraera. ");
INSERT INTO kpr_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Ai resira amo, Bajari nunda ungoda agha eni bu jighirira. Agha amo nunda janje ekoko da vaini (wine) fakinaghae aimi bedo edo irira. Nune averegeari vovosurureari ari ekoko embo ai rise, ghaghonoko ainghae mindi tefo eraera. ");
INSERT INTO kpr_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","O namo, God Jacob tumonde bainghedo ghusira, ainda bino ava evovodae osa sise nundae sakai sido yarena. ");
INSERT INTO kpr_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Ari ekoko embo da fakina ava nune dari bejarira, o ari eveva gaveva embo da fakina ava, nune ambisegari baji tomanako arira. ");
INSERT INTO kpr_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","God da binó Judah Frovensi aminda mindafu bekári. Israel Frovensi aminda nunda Javo kakara eraera. ");
INSERT INTO kpr_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Nunda dobo Salem o Jerusalem seraera aminda fitiri fetirira. Nunda irari vasa ututu Saion aminda irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Vasa aminda gitofu da feva goroba mane ava nune fati jojorugusira, nenda bere, a kotugo nenda isoro da kaeya mane, nenda ambi goroba isasambu ava, nune fati jojorugusira. ");
INSERT INTO kpr_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Arie God, duro usasago beká mo, nimori. Ni doriri aminda ninda gitofu dedo, atai duboda fafatigusesa amindaghe jovereghe fuse, ninda duró, kini (king) da gogho aminga ava asugedo deinghe refesa. ");
INSERT INTO kpr_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Nenda isoro embo da genembo fakinago beká ainda gugua ava nine sosighi e rurusesi. Oroko mo, ne isambu ambu fafase irera. Nenda fakina kotugo nenda kasama isasambu dika irae ututusira. ");
INSERT INTO kpr_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Arie Jacob da God, nine katiyavara use seteso, hosi (horse) mane isoro embo nenda etoda anumbe sufuse, isoro usera ainde dabade isambu du fafasedo amomonjeguseri. ");
INSERT INTO kpr_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Avata Bajari, evetu genembo isasambu nindae oju eraera. Nine janje ekoko aresa da sifo aminda, mave eniko ninda dombuda jo fetae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","9","Gitofuimi kateyavara ero, mema tafuse iritirera ava, sonembaso jebugaoro dae sise, ni utuda irise, ategi ari erorusesa amo, ni reju ava ari dae kotisesa ava seteso, endada evetu genembo isasambu oju beká use beka gotiseri. ");
INSERT INTO kpr_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Evetu genembo nu janje ekoko eraera, avata nine eoso, nindae sakai seraera. Evetu genembo nimokena isoro tataya doyeraera aimi, ninda kirumu sifo seteso fefetusira aminda tafaroro use, nimoa tumonde bainghedo gharera. ");
INSERT INTO kpr_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Nenda Bajari God kena rea mutari beka gagojuseva ava mutuvu! Ne oro mendeni tinguda iritireva isasambu, numokena fuyo tige fuvu! God nune seari natofo isambu nundae oju eraera. ");
INSERT INTO kpr_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Gavana da kokotofu nenda babojegaride, ivuga ari kakato amo nune fitiari vovosegeraera, a kotugo nune eari kini mane binonde amo ojuimi ungo ata dadadagheraera. ");
INSERT INTO kpr_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","2","Na God kena sorara eraena. Ningare dae sedo, sorara use irá gheraena. Na dara tamburaena da sifo aminda na Bajari kena benunu seraena, tumba ghousa ava nanda ungo jigheono ikáda erorureari benunu seraena, avata dubo jama jo tambae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Na God koteraena, avata kote jo tambae use jaredo, ghosio seraena. Nu nanangedo tambaetena ava kote simbuguse irá gheraena, avata na dubo buneraena. ");
INSERT INTO kpr_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Arie Bajari, nine tumba ghousa ava na jo doyaso fase avi jebugae eraena aindae, na ghamo vevera tafuse, geka sari buneraena. ");
INSERT INTO kpr_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Na reju ava anakora namokena siroredo ghusira ava koteraena, a kotugo ghaeko ana ainda irari ava erekotena. ");
INSERT INTO kpr_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Na tumbaghae kotari tomanakogo beká ava kotise irá ghraena. Kote simbugari dae use, nasuka namokena eminge ategi eraena, ");
INSERT INTO kpr_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Bajari namonde sifo ghousa gukai mutarira ai? Nu jo sekago namondekena ivuga ae arira, tano? ");
INSERT INTO kpr_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Namonde dubo buraira amo, dotira, aĩ? Nunda beka gajari namondekena usira amo, oroko fugetira, aĩ? ");
INSERT INTO kpr_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Avose, God namondedae joka ari dae sisira ava, kotae usira, tanojo? Avose, namondedae joka edo ghusira ava, nunda janje ekoimi etiri dadabusira, tanojo?” ");
INSERT INTO kpr_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Aminge kotise, na eminge siseni, na roera reimi iri, dubo mema tomanakogo eretafena amo, God namondekena rea edo ghusira ava oroko jo ae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Bajari, na nine roera babaigo edo ghusesa ava kote tambarena. Tano dombu eni dombu eni anakora eteso dudukuhusera, ava kotedo gharena. ");
INSERT INTO kpr_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Ni roera rea usesa isambu kotarena. Nine tano dombu eni dombu eni eteso dudukuhusera, ava kotedo gharena. ");
INSERT INTO kpr_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Arie God, roera isambu nine eraesa amo kakaragori, God babaigo a nimongo eni tefori. ");
INSERT INTO kpr_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","God, nine tano mendeni mendeni easo siroreraira. Ninda fakina ava oro mendeni mendenikena ijugeteso isagha usira. ");
INSERT INTO kpr_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Ninda fakinaimi ninda natofo Jacob nengae Joseph ghaeda imemisiri ava sonembeteso jebuguseri. ");
INSERT INTO kpr_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Arie God, evetu genembo oju use ungo ata dadadagheraera aminga ava, uvu ninda dombuda fetirise, oju edo tiro taraghuseri. Karaje kafuru ghighi ábarago nindae oju use aminguseri. ");
INSERT INTO kpr_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Foroga borija dise, utu gambari utu gambari biria tarighuse, barara fugutusira. ");
INSERT INTO kpr_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Ninda barara gururu gararaghuse kerere karara ghiri a kotugo biria tarighuse usasa tomanako use, jaraghetiri enda isagha usira. Amingiri, dumo firi, enda barago daradaraghusira. ");
INSERT INTO kpr_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Ni eva anjeraira ainda jokada tere deinghedo isesi. A kotugo karaje ghighi aminda sive sembesa sovenikena buvurutusesi. Avata ninda ata kotu mave jo gaeri. ");
INSERT INTO kpr_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Ni sifi kaifa kato aminga ava use, ninda evetu genembo unumbedo isesi, Moses nengae Aron ghae giti bero nemonde isevu. ");
INSERT INTO kpr_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Nanda evetu genembo dengoro javevu! Nanda ijuga erena evia ningido, bu jighi fetevu! ");
INSERT INTO kpr_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Na kotofuda dubo kotari ava sari dae erena. Aminguse, tuka sufurono geka jungarida anakora sirorusira, ava se disugari dae arena. ");
INSERT INTO kpr_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Roera abuamane setero niningusera a kasama usera ava, ");
INSERT INTO kpr_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","namondeda sasingukena jo jungae arera. Namondeda imemesiri amboda sirorarera nemokena barago saoro ningarera. Amo Bajari da fakina a roera rejua ava edo ghusira, kotugo nunda tano dombu eni dombu eni etero, dudukughusera, ainda bino ava saoro ningarera. ");
INSERT INTO kpr_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Nunda evovo Israel embokena futusira, a nunda Agho Dari Jacob da imendi gamendikena futusira. Amingedo, namondeda abua mane kena, nunda agho dari nanjogo nenda sasingukena ijugaoro dae sisira. ");
INSERT INTO kpr_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Ainda beká mo, imendi gamendi seka sirorarera ningi kasama edo, nenda sasingu sirorarera barago, saoro kasama aeteri. ");
INSERT INTO kpr_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Emboro eminguse, némbarago nenda tumondari God kena fitaeteri. Aminguse, God reava nemokena usira ava kote gosuse, evovodae nunda Agho Dari ava edo ghaeteri. ");
INSERT INTO kpr_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Ne jo nombuamane da ari ava ae aeteri. Nombuamane gogore use, geka bu fugari kakatori. Ne God jo tumonde gogoghombae edo ghuseri, a nunda sari ava jo evovodae ae edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Ephraim ondi nenda feva nunda gorobaghae bambudo, iseri. Avata tataya sirorusira ainda sifoda, ne oju edo do sufuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Ne God de dabade beka gagojusera, ava bejedo, nunda Agho Dari imboe use, jo kaifa ae useri. ");
INSERT INTO kpr_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Nu rea ava nemokena usira amo, kotae useri, a tano mendeni mendeni nemokena etiri gosusera, ábarago ne kotae useri. ");
INSERT INTO kpr_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Nenda nombuamane gosero, vasa tevisa Soan aminda, amo reighi Egypt ainda jokáda, nu tano mendeni mendeni etiri gosuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Nune etiri, karaje sarige furu digharige fetetero, Israel embo sembera, betu sovenikena vivituseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Ijighae mo, emboro kasama aoro dae sedo, God foroga muteari, giti irureari ne gosuse amboda amboda ya ghedo ghuseri. A tumba ghousa mo, God avaraka buburaghae muteari, giti irureari, ne gosuse amboda amboda ya ghedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Reighi evetu genembo a uvu irae vasa aminda nune setiri, ghamana sarigusira. Sarigetiri, uvu duru bekáda ava fira vitiri riseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Nune etiri, uvu ghoghoro ava aroroda kirighe fira buvudo, uvu tomanako dukaghae sufusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Avata, ne God kena ari eko doyae tambuno edo ghuseri, ne reighi uvu a evetu genembo irae vasa aminda God Ika Bekáda irá gheraira aikena, osogo edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Ne avito sise, bayau mutari mindari dae sise, God dere gosuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Ne God dae bauso use geka eminge siseri, “Reighi uvu a evetu genembo irae vasa eminda God bayau mutari inonori, aĩ? ");
INSERT INTO kpr_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Geka bekári, nune ghamana de sarigetiri, uvu tomanako ava averege fira vovosusira. Avata, nu oka bayaughae nunda evetu genembodae mutari inonori, aĩ, tefo?” ");
INSERT INTO kpr_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Ava ningido, Bajari dubo ekoko usira. Edo, nunda natofo mendeni setiri avarakai dungetiri ambubuduruseri. Aminguse, nunda dubo ekoko nemokena baji tomanako beká usira. ");
INSERT INTO kpr_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Ai resira amo, nenda tumondari God kena tefori. Nu sari ne jebugaetera, ava ne jo tumondae edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Avata, nu utu iká ominda kena setiri afigetiri ");
INSERT INTO kpr_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","utuda farava da vuji futuse, mena mindoro dae sedo setiri vose firi riseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Ágido, ne anera da bayau ava riseri, a nanjogo mindari sisera, isambu God nune futusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Kotugo, nu etiri, yaura iji vitarikenaghe sufusira, a nunda fakinaimi etiri, yaura beina doririkenaghe tuturo e sufusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","A nunda evetu genembokena mo, rika mane da digari mo, inono kora da ghonesa aminga ava mutiri vosefusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Rika mane du fafasusera amo, dobo itutugusera ainda soroda a demo damo isasambu du birurughe fafasuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Amingetiri, evetu genembo mindi tini babojusira. God ne reju ava uju usera ava futusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Avata, nenda bayau da oduso, jo tukughae iriri, ne mokogo mokogo rero, ");
INSERT INTO kpr_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","God nemokena dubo ekoko edo, nenda gegenembo fakina kakato, amo Israel da gegenembo seseka gari garigo ava detiri amomonjeguseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","God nu amingusira, avata, ne ari ekoko jo doyae, udo fuseri. Aminguse, God tano nanjogo ututusira ava jo gi tumondae useri. ");
INSERT INTO kpr_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Ava sedo, ne iji nanjogo jebuga iraetera ava, God gafugetiri tufoko etiri ambubuduruseri. Nenda jebuga irari da ghaeko ava dara a ojuimi gafugetiri, amomonjeguseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Sifo mendeni mendeni ne deari amomonjegedo ghusera ainda sifoda, nenda mendeni dubo joveregheari, sekago God kena fa ghuseri. Aminguse, ne sororaghae numokena vujeguse, benunu sedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Sifo aminda, God mo nenda bere ava, a God fakina kato nemo sonembari jebugaoro dae sedo fusira, ava sekago kotiseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Avata, nenda geka mo, isambu gungubori. Geka rea ava sedo ghusira amo, beká eni tefori. ");
INSERT INTO kpr_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Ne numokena jo dubo dabako aeri. Ne God de dabade beka gagojuse, rea ari dae sisera ava, nene jo kaifa ae useri. ");
INSERT INTO kpr_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Avata, God nunda evetu genembokena joka edo ghusira. Nenda ari ekoko kote dotutuse, jo dari amomonjegaeri. Sifo mendeni mendeni nu janje ekoko edo ghusira, avata, fati fetedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Nemo ambari embori, a kotugo ne taká yaura sumbu ya dadaberaira, amingo ava kotedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Sifo digari beká reighi uvu a evetu genembo irae vasa aminda numokena osogo edo ghuseri. ifo digari beká ava urureoro, nu mema edo ghusira! ");
INSERT INTO kpr_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Sifo ghousa rea edo ghusera, ne ari daba ava use, God dere gido ghuseri. Aminguse, Israel embo da God kakara aikena ghamo vevera bu foa ghedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Nunda fakina teriago ava ne kotae useri. Ne nanjigo gitofu da ungoda saghimbe rurusira, ava ne jo kotaeri. ");
INSERT INTO kpr_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Nu nange enda tevisa Soan Egypt provensi aminda nunda fakina ijuguse, roera mendeni mendeni usira, kotugo tano mendeni mendeni etiri dudukughusera, ábarago kotae edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Nune etiri, uvu ororo jinisira. Etiri, Egypt embo uvu reda bu mindaetera ava buniseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Soini mutiri fera, nemokena buvu etero vevera teria beká itatama useri, a gerakuimi nenda reighi bebeta usira. ");
INSERT INTO kpr_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","A sisi mutiri fera, nenda bare baka mindi tefo useri. Amingetero, bayau beká usira amo, jo digarigo sirorari bambudo mindaeri. ");
INSERT INTO kpr_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Nune nenda vaini da asi ava borija dombu eni aisi yaurago aimi detiri amomonjeguseri, a nenda ika kayuyu barago ais (ice) imi etiri amomonjeguseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","A nenda buramakau barago boriji aisi avavaga setena, aimi detiri amomonjeguseri, a nenda sino fukamane mendeni biria barara aimi detiri amomonjeguseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Nu dubo eko beká ava usira nemokena. Aminguse, nunda janje eko nemokena bu fuse setiri, nunda anera mane ambari budo fero, itatama useri. ");
INSERT INTO kpr_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Nu nemokena janje ekoko beká usira, ava jo jighi fetaeri. Jo avori sari jebugae useri. Nu tauno eko mutiri, iri bambu sirivo useri. ");
INSERT INTO kpr_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Nu Egypt embo da ofo kambo daba daba da vide jamena bebego siroredo irara, ava detiri amomonjeguseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Inono sifi kaifa kato eraira aminga nunda evetu enembo unumbe bu buvurutusira. Buvu, reighi uvu a evetu genembo irae vasa aminda tavo udo budo fusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Nune emboro ijuguse, eveva jebuga budo isira aindae, ne jo oju aeri. Avata, nenda gitofu mo, evaimi viti fira, fatiri amomonjeguseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Ne budo, nunda enda kakara aminda, a doriri nune gitofukena isoro e rurusira aminda fira buvurutusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Nune setiri, evetu genembo aminda giti dighi iriara ava, nunda evetu genemboimi ondero buvutero, ne era teteruseri. Nenda enda budo, Israel embo dae ghasedo, nenda ofo kambo barago nunda natofodae futusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Avata, ne God Iká Beká aikena osogo bu fuseri. Aminguse, nu dere gosuse, nunda Agho Dari jo kaifa aeri. ");
INSERT INTO kpr_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Aminguse, ne osogo use, nombua mane nange edo ghusera aminga ava use, God da sari ava ighagha useri. Ne rea sedo ghusera amo, goroba otombari amingori. ");
INSERT INTO kpr_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Ne eteni emboda tumondari ava eoro, nu dubo ekoko edo ghusira. Ove kave ava tumondeoro gido, nu dubo eko beká ava edo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","God ava gosusira amo, nu dubo eko usira. Amingedo, nunda natofokena guka mutudo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Nunda dobo reighi Sailo aminda namonde Israel embode dabade irá ghedo ghusira ava gukai futusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Nu ungo bebesugetiri, namondeda gitofui nunda fakina a usasa da tano, amo Agho Dari da Mauva ava, nene ruruseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Nu nunda natofodae dubo ekoko usira. Amingedo, ungo sokinembetiri, gitofui namonde dedo gaedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Genembo gimasa seka bajari isambu isoroda de tefo useri. Etero, ade jamena mavekena vai ari? ");
INSERT INTO kpr_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Gitofui fristi mane de tefo useri. Amingedo, jo doyoro, nenda roriri sorara rovarova jo aeri. ");
INSERT INTO kpr_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Avori, Bajari kau genembo eni inono avise irara, erari da kaugo arira, o vaini da fakinaimi derari, diti fangarira aminga ava nune usira. ");
INSERT INTO kpr_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Aminge eredo, nunda gitofu ondi detiri, tukughedo amboi iseri. Ne de duboda fati fetetiri, nunda gitofo meka gosuse irá ghedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Avata, nu Joseph da imendi gamendi gukai futusira. A Ephraim ondi mo, eni jo gatege baeri. ");
INSERT INTO kpr_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Ainda vasada mo, Judah ondi, a ututu Saion dubo bu gogoghombedo ghusira ava gatege rurusira. ");
INSERT INTO kpr_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Reighi aminda nunda Tafaroro Kambo inono nunda irari vasa utuda amingo ava itutusira. Inono enda evovodae fakina e fetirira, aminga ava usira. ");
INSERT INTO kpr_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","71","God da saramana kato, David, nunda sifi ekeroro jokáda kaifa use iriri, God nune David gategedo, Israel embo da kini (king) a kotugo nenda sifi kaifa kato aminga ava are dae sisira. ");
INSERT INTO kpr_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Etiri, David natofo kaveveraimi unumbusira. Kaifa use, dubo kotise ne giti jighido ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Arie God, gitofu ni jo tumondae eraera aimi, ninda enda ava bari dae fera namanekena isoro useri. Edo, nene ninda Kambo Kakarago ava bebeta edo, reighi Jerusalem ava basa eko beká jijighuseri. ");
INSERT INTO kpr_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Ne ninda natofo Israel embo ava dedo, tamo rika riduna mane aimi mindoro dae dodo iseri. Ninda saramana kakato da tamo ava taima sino fukaimi mindoro dae useri. ");
INSERT INTO kpr_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Ne ninda natofo Israel embo ava dive gafetero ororo vose gaunghusira. Ororoimi reighi Jerusalem isambu yausa gaghari gusira. Kokomana bu furugari embo eniko jo fetaeri. ");
INSERT INTO kpr_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Oro mendeni God jo tumonde bainghae eraera tinguda iritirera aimi, namanendae jijivu ekoko sesegeraera. Ne namanendae gegha jise, ã kotugo namanedae makoede sise, dere jise gegha yaru eraera. ");
INSERT INTO kpr_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Arie Bajari, namanekena evovodae janje eko use iraresa, ai? Ninda janje eko beká namanekena eraesa ava, nanjigo tukughari? ");
INSERT INTO kpr_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Namane dodo, oro mendeni ni jo tumonde bainghae eraera aikena janje eko aetesi. Natofo nimokena jo tumonduse banungae eraera aikena, ninda dubo eko ava ijugaetesi. ");
INSERT INTO kpr_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Ai resira amo, nene ninda natofo Israel embo ava detero amomonjeguseri. Ninda reighi teria ava, nene basa eko beká ava jijighuseri. ");
INSERT INTO kpr_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Erá avia abua da ari ekoko aindae sedo namanedae mema mutudo, ghamo baoro dae eose! Oroko namanendae joka aetesi. Namanenda gigitari isasambu dadabetira. ");
INSERT INTO kpr_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Arie God, namane sonembuse, a kotugo namane gitofukena bu darige jebugaore! Ninda binódae sedo, namane dara jokáda saghimbe ruruse, namanenda ari ekoko kote doyaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Redae oro mendeni mendeni namanekena eminge sareri, “Nenda God da sonemba mo, redari?” Ninda saramana kakato ava oro mendeni mendeniimi dive gafetero, ororo yausa gaghari gusira aindae nine daso ghamo baoro dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Dibura embo aoro sise irera, ava ningaso dae resena. Evetu genembo amboro dae setero diburada iritirera ava, ninda fakina teriago aimi vujege, buvu jebugaore! ");
INSERT INTO kpr_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Arie Bajari, namanenda gitofu dengesida irá gheraera aikena, ninda javoda jijivu ekoko sisera, ainda mino futuse, etoda mokogo mutaso, itatamudo yarera. ");
INSERT INTO kpr_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Amingaso, namane ninda totofo, ninda sifi (sheep) mane kaifa eraesa, nindae aiyakoe sise irarera. A namane, namanenda sasingu, imemesiri gamemesiride nindae sakai sido yarera. ");
INSERT INTO kpr_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Arie, Israel embo tavo tatau ari kato, namane Joseph da imendi gamendi Israel embo da giti jijighuse, tavo tatau eraesa. Ni kini (king) edo Serubim maneda ikáda anumberaesa aimi, dengoro namanekena fiti! ");
INSERT INTO kpr_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Oro Ephraim, Benjamin a Manasseh ondikena isagha aso gaore! Fu, ninda fakina namanekena ijuguse, namane sonembaso jebugaore! ");
INSERT INTO kpr_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Arie God, sonembaso, namaneda irari nunda ari fatonga aeti. Namanekena joka ururaso, namane jebugaore! ");
INSERT INTO kpr_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Arie Bajari God, fakina isambu da tofo, ni ghousa mavega ninda evetu genembo kena dubo eko use, namanenda banungari jo ningae aresi? ");
INSERT INTO kpr_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Ni namaneda bayau dubo vevera ava futusesi, jivu ava agha tomanakoda averege mindoro dae futusesi. ");
INSERT INTO kpr_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Ni doteso, oro mendeni namanenda tinguda iritirera aimi, namanenda enda soro vesa ari dae tataya use irera. Aminguse, namanendae jijivu ekoko seraera. ");
INSERT INTO kpr_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Arie God, fakina isambu da tofo, sonembaso namaneda irari nunda ari fatonga aeti. Namanekena joka ururaso, namane jebugaore! ");
INSERT INTO kpr_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Ni vaini da asi veka Egypt aminda ghe bu fesa, oro mendeni mendeni ondeso, nenda enda do buvurutero nenda endada govusesi. ");
INSERT INTO kpr_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Ni aminda govari dae sedo, enda jedo goveteso, nunda besisi enda jokáda vose gogogho edo, reighi isambu bedo usira. ");
INSERT INTO kpr_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Enda jiro fumbari isambu nunda itumuimi gajojusira, ika babai Lebanon frovensi ami ");
INSERT INTO kpr_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Nunda fafatuimi siregetiri era, eva Mediterranean aminda buvurutuseri, a kotugo era uvu Euphrates aminda barago buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Ni redae furu dighi birurughetero ireira ava, de bejeteso vovosusi? Oroko mave vare aminda ya buvu darige yari dae arera, aimi ninda vaini da vuji kotae kotae bagia ari inonori. ");
INSERT INTO kpr_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Bao fukaimi fati beteraera. Kotugo taima sino fukaimi ainda vuji mindiraera. ");
INSERT INTO kpr_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","God, fakina isambu da tofo, dombu namanekena jovereghe! Utudaghe diti fuge vose fururari namane gase! Aminguse fu, ninda natofo sonembaso jebugaore! ");
INSERT INTO kpr_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Fu, asi seka evia govedo, tavo eteso baji fakina usira ava, sonembaso jebugare! ");
INSERT INTO kpr_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Namanenda gitofuimi divetero fasetiri avarakai dungutuseri. Gi, dombuda sise, dege amomonjegaore! ");
INSERT INTO kpr_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Evetu genembo nine gategusesa, a oro nine eteso fakina usera ava, tavo use, gagara e fete! ");
INSERT INTO kpr_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Amingaresa amo, namane sifo nanjigo aminda ni jo sekago gukai mutae arera. Namane tavo ururaso jebuga irarera amo, ni jighoro erase! ");
INSERT INTO kpr_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Bajari God, fakina isambu da tofo, namanekena joka ururaso, namane jebugaore! ");
INSERT INTO kpr_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Namondeda sonemba kato God dae ivuga ghae fumbu arugaore! Jacob da God dae sakai sise, yaru didivuse fumbu arugaore! ");
INSERT INTO kpr_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Foyago da ghasaghasa (tambourine) doruse, yaru tuturo edo divore! A yaru ningari vivi ava gita dombu eni dombu eni aimi doruse divore! ");
INSERT INTO kpr_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Tambuno seka jorugharira ainda kirumudae, a tambuno vosiya tifughe jorughedo gharira, ainda kirumudae barago tavuya fusevu! ");
INSERT INTO kpr_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Emo Israel embo da agho dariri. Geka emo Jacob da God kena ghe fusira. ");
INSERT INTO kpr_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Agho dari setena ava, Egypt embo dedo gaedo ghusira da sifo aminda Israel embodae futusira. Genembo eni na jo kasama ae, geka eminge siri niningusena, amo eviri: ");
INSERT INTO kpr_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“Na ango bouvu nenda sagada ava bu fiteno vovosusira. Egypt aminda kanda fumbudo ghuseva barago, nane seteno fitevo vovosusira. ");
INSERT INTO kpr_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Ne dubo mema use, javono namoa gatetevo sonembuseni. Nanda junge irari vasa, biria barara jokáda irise, nenda tumondari uvu Meribah dengesida dere gosuseni. ");
INSERT INTO kpr_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Nanda natofo, ningivu! Dombuda sari dae erena. Israel embo nanda geka ningaeteva, aindae uju erena. ");
INSERT INTO kpr_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Ne jo sifo nanjigo aminda oro eninda god tumonde bainghae areva. ");
INSERT INTO kpr_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Bajari God ne unumbe Egypt ghedo bu fusira amo, namori. Ava sedo nenda beka fangevu, bayau mutono mindove! ");
INSERT INTO kpr_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Avata nanda natofo nanda geka jo ningae eraera. Israel embo nanda geka jo bae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Ava sedo na ungo bebesugeteno ghambura da irari ava use irá ghuseri, kotugo reju uju usera ava, edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Nanda natofo nanda geka ningaetera aindae, uju erena. A Israel embo nanda geka baetera, aindae uju erena. ");
INSERT INTO kpr_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Amingaetera, na nenda gitofu totoigo de atai duboda fataeteni, nenda isoro embo isambu barago de atai duboda fataeteni. ");
INSERT INTO kpr_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Mave na imboe eraera amo, ne ojuimi tumo taroroda sire nanda dombuda anosegaeteri. Nenda dara eraera da mino mo, evovodae tafudo yaeteri. ");
INSERT INTO kpr_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Avata ne nanda natofori. Ava sedo, na farava evevago bekáimi undaeteni a taimada finje firukago aimi undono, tini bajaetira.” ");
INSERT INTO kpr_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Enda da babojegari babai babai nanjigo totorugeraera einda jokáda God nu giti jighiraira. Amo, enda da kokotofu nenda oro oroimi gungubo sise “namondeda god” sedo ghusera, nenda dombuda God nunda kotari seari voseraira. ");
INSERT INTO kpr_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Ne evetu genembo ari ekoko eraera ava ijujareva amo, bekáda bekáda use ijujevu! A ari ekoko embo ava ijujeraesa amo, erá nemo sonembuse, eko arera ava, kivo eose! ");
INSERT INTO kpr_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Ne makasi embo a babate embo gagara use irareva! Kotugo iti fafo iraede embo barago inonoda kaifa tavo use irareva! ");
INSERT INTO kpr_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Makasi a fakina tefo embo ava ari ekoko embo da ungoda sainghimbe baovo ne jebugarera. ");
INSERT INTO kpr_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Ne rekato bunari a daghari bekári! Ne ghaghi garuse, evovodae kosasa eraeva. Koto da sifoda geka beká eini jo isagha ae eraira, gungubo vanembori. ");
INSERT INTO kpr_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","“Ne god maneri” siseni. Ne isasambu God tomanako iká bekáda irá gheraira ainda sasinguri. ");
INSERT INTO kpr_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Avata ne isambu endada gegenembo amburaera aminga ava ambareva. Kini nanjogo enda eminda irera aminga ava ambu tefo areva. ");
INSERT INTO kpr_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Ava sedo, Afa God fu, enda é nine ijujase! Oro nanjogo enda eminda irera, isasambu ninda tofori. ");
INSERT INTO kpr_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Arie God, erá beka gote iriose. Erá tumbe tauntaunghe irise, beka baka sae use iriose! ");
INSERT INTO kpr_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Gi! Ninda gitofu osogo nimokena bu refera. Mave ni imboe eraera ábarago nemonde tataya ari dae erera. ");
INSERT INTO kpr_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Ninda natofokena ufena manaka eregarera. Ne ninda natofo tavo tatau eraesa ainde, tataya ari dae sise, agho ituterera. ");
INSERT INTO kpr_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","“Fuvu,” resera, “Oro Israel embo daoro vekaghae sirivo aore! Amingaoro, Israel embo da javo manjarira.” ");
INSERT INTO kpr_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Ne dubo dabako edo manaka gae, oro mendenide tatedo, nemonde tataya ari dae sise resera. ");
INSERT INTO kpr_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Oro nanjogode tatari sisera, amo eviri: Edom ondi, Ishmael ondi, Moab ondi á Hakri embode dabade. ");
INSERT INTO kpr_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","A kotugo Gebal ondi, Ammon ondi, Amalek ondi, Philistia ondi á Tyre embode dabade. ");
INSERT INTO kpr_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Assyria ondi barago kotugo Lot da imendi gamendi Amori embo edo Moab embo seraera ainde tatedo tataya ari dae resera. ");
INSERT INTO kpr_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Midia embo dae rea ava usesa, a kotugo uvu Kislon aminda Sisera nengae Jabin ghaekena rea usesa aminga ava, oro oroko nembo tegetena aikena, kau daba ava aso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Ne reighi Endor aminda deteso amomonje getero, nenda tamo bete endada vovosegusira. ");
INSERT INTO kpr_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","12","Nenda giti jijighigari Oreb nengae Zeeb ghae kena usesa, kau daba ava e! Zebah nengae Zalmunna ghae siseri, “Namonde enda é God da tofori ava namondeda tofodae baore!” Avori, gegenembo etoto naká ava setero ningido, rea usesa, oro tegetena, ainda babojegari kena avavaga use, daso amomonje gaoro dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","God natakoé inono fonja o farava vuji anoso yauraimi bambu kotae kotae gorogheraira aminga ava e! ");
INSERT INTO kpr_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Kau avaraka taimada gambu aviraira aminga ava, a enda fumbarida gambu bubura eraira aminga ava, ");
INSERT INTO kpr_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","ninda yaura vovoga aimi ondaso sumbarera, a ninda yaura fakinago bekáimi ondi, oju aore! ");
INSERT INTO kpr_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Arie Bajari, nenda dombu mekai afuruge, ninda fakina ava gido kasama e gogoghombaore! ");
INSERT INTO kpr_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Ne isoroda dedo gaedo ghaoro evovodae ojughae irore! A meka gosudo ya ambore! ");
INSERT INTO kpr_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Bajari iká bekáda, utu enda kaifa eraira, nisuka nimori, ava kasama aore! ");
INSERT INTO kpr_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Bajari Fakina Isambu da Tofo, na ninda banungari kambo dae dubo ererurena. ");
INSERT INTO kpr_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Na nanangedo Bajari da Banungari Kambo jokáda iraetena, aindae uju erena! Arie, Bajari God, evovodae irá gheraesa, nanda tamo a asisi isambuimi ivugaghae nimokena yaru seraena. ");
INSERT INTO kpr_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Arie Bajari Fakina Isambu da Tofo, nanda kini (king) a nanda God, rika veveyako barago ninda kamboda moghá fitiraera a kaughoro barago nenda mamandi fumbudo, ninda olta (altar) dengesida kaifa eraera. ");
INSERT INTO kpr_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Mave ninda banungari kamboda irá gheraera amo, ivuga use irera. Ne evovodae yaru sise ninda javo jigheoro ereraira. ");
INSERT INTO kpr_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Evetu genembo mave nimokena fakina buraera amo, ne ivuga use irera, a mave evovodae doriri Saion aminda yari dae uju eraera, nembarago ivuga use irera. ");
INSERT INTO kpr_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Ne govi eni uvu tefo javo Baka aminda deinghe sembi yarera amo, reighi aminda, uvu kirikara gharira, a ghaeko sifo dadaba ururari borija tuturo edo dise, uvu sirorarira. ");
INSERT INTO kpr_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Aminguse, ne fakina rurudo yarera. Ne ya Saion buvudo, god mendeni irera nenda God beká ava, aminda irari garera. ");
INSERT INTO kpr_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Arie Bajari God Fakina Isambu da Tofo, Jacob da God, nanda benunu ningi! ");
INSERT INTO kpr_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Arie God, namane da kini nine gategusesa ava, esimbuge! ");
INSERT INTO kpr_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Iji dabako ninda tafaroro kamboda anumbiraetena a nu evevagori, iji 1,000 ava reighi mendeni kena irari mo, jo amingo iraeri. Arie nanda God, ninda kambo guro bekada fetaetena amo, evevari, jo kusia bagia ari kakato da kamboda irari amingo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Bajari mo, namondeda bere a Kini usasago bekári. Nunda kavevera a tumondari namonde kena eraira, aimi namonde esimbugeraira. Ari eveva embokena roera eveva reju ava uju eraera, ivugaghae muturaira. ");
INSERT INTO kpr_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Bajari Fakina Isambu da Tofo, mave ni tumonderaera amo, ne ivuga use irera. ");
INSERT INTO kpr_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Bajari, ni ninda natofo da enda dae joka usesi. Ni sifo aminda sonembeteso, Israel sekago ati ghayafade useri. ");
INSERT INTO kpr_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Ninda natofo da ari ekoko kote dotutusesi, a nenda dimbari isambu kote dodo gukai futusesi. ");
INSERT INTO kpr_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Dubo ekoko nemokena edo ghusesa tukughusesi. Aminguse, ninda dubo ekoko da fakina jighi fefetusesi. ");
INSERT INTO kpr_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Arie God, namanenda jebuga da susu nimori. Namane bu jovereghe fu! Aminguse, namanekena bauso sosou eraesa, ava dodo, dubo jama e! ");
INSERT INTO kpr_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Are! Ni evovodae namanekena dubo ekoko use iraresa, ai? Ninda dubo ekoko jo nanjigo fua tukughae arira, ai? ");
INSERT INTO kpr_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Sonembe, namane ninda natofo sekago fakina edo, ni jighoro erase! ");
INSERT INTO kpr_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Arie Bajari, namane nange evovo dae dubo buraesa ava, aso isagha ari gaore! Namane sonembuse, ninda jebuga mutaso baore! ");
INSERT INTO kpr_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Bajari God reava resira ava, na niningerena: namonde nunda totofori. Ágido, namonde jo sekago jovereghe yama daghari da ari ae arera amo, nunda mainungari namonde kena mutarira. ");
INSERT INTO kpr_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Geka bekári, nu simbuge fetedo, mave numo igheghi eraera ava sonembari jebugarera. Kotugo namonde sonembeari jebugeraera ainda duro ava, namondeda reighi eminda irarira. ");
INSERT INTO kpr_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","God rea ari dae sisira ainda beká ava nune ari nunda dubo bari ainghae dabade isagha ari garera. Akotugo dambugo irari nengae mainungari ghae barago sifo daba aminda isagha ari garera. ");
INSERT INTO kpr_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Namonde Israel embo God tumonde baingheraera aimi ungo God kena sirigaoro, God aito kakara fugeraira aimi nunda ungo sirige namonde unumbarira. ");
INSERT INTO kpr_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Bajari namonde esimbugari susu iti fafode arera. Aminguse, namondeda enda emo oka bayau digutururari mindarera. ");
INSERT INTO kpr_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Ari dambugo ari aimi, Bajari da emboro rerebe, giti irurari, nu amboda yarira. ");
INSERT INTO kpr_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Arie Bajari, na gofari bekári. Na tofo sonembari da emboro eni tefori. Ava sedo, nanda benunu ningido, na sonembe! ");
INSERT INTO kpr_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Na ni tumonduse, ninda sari ava eraena, na ninda saramana katori. Ava sedo, ambari dae erena ava sonembe, jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Nanda God nimori. Na banungurureono sifo ate fa ya tumba jiraira. Ava sedo, nandae joka aso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Arie Bajari, nanda benunu nimokena viti ya gheraira. Na ninda saramana katori. Ava sedo sonembaso, na ivuga aone! ");
INSERT INTO kpr_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Ni namanekena veka eveva use, namanenda ari ekoko kote doyeraesa. Mave nimokena banungeraera aindae, ni evovodae dubo buraesa. ");
INSERT INTO kpr_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Bajari, nanda benunu ningi! Nanda kori nininguse, na sonembe! ");
INSERT INTO kpr_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Ni nanda banungari ningiraesa, ava sedo na dara tafuse, nimokena kori seraena. ");
INSERT INTO kpr_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Arie Bajari, god eni nimongo tefori. Nine usesa avavaga enimi jo ae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Oro isasambu nine eteso sirorusera aimi, fua tumoi bainghuse ni tumondarera. Ninda javo tomanako ava jighoro erarira. ");
INSERT INTO kpr_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Ni fakinago bekári, a ni tano dombu eni a ari gae gitida ava eoso siroreraira. God nisuka nimori. ");
INSERT INTO kpr_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Arie Bajari, ni rejoa aono dae uju eresa ava, ijugaso amingaone! Ijuge, na dubo dabako use nindae farago jighone! ");
INSERT INTO kpr_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Arie Bajari, nanda God, nanda janje joká isambu aimi ni jighono eraresa. Ninda javo tomanakogo kau mavega ava natofo isambu kena evovodae osa sise irarena. ");
INSERT INTO kpr_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Evovodae ninda dubo bari tomanakoi na dubo buraesa! Aminguse, na ujeda ava sonembe beso jebuguseni. ");
INSERT INTO kpr_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Arie God, evetu genembo ivuga kakato aimi eredo, namoa dari dae refera. Tafasara kakato, ninda geka jo ningae eraera aimi, na daoro ambono dae erera. ");
INSERT INTO kpr_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Avata, Arie Bajari, ni joka ari a dubo bari da God ri. Ni evovodae durumuguse kavevera eraesa, kotugo ni rea ari dae beka gajeraesa ava, isambu urureoso beká siroreraira. ");
INSERT INTO kpr_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Jovereghe namo gosuse, joka e! Aya nindae farago edo ghusira, aminga ava use irena. Ava sedo, fakina futururaso jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Bajari, ninda kavevera eraesa, ainda beká ava ijugururaso isagha are! Amingarira amo, evetu genembo na imboe gamboe eraera ava, na nange sonembuse yove sisesa ava gosuse, meka garera. ");
INSERT INTO kpr_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Enda jiro fumbari kakara aminda Bajari nunda bogu begaya didighusira. ");
INSERT INTO kpr_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Israel jokáda reighi mendeni mendeni iritirira, avata Bajari Jerusalem ava dubo bu gogoghomberaira. ");
INSERT INTO kpr_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","God da bogu begaya aminda dighi ireva, nemokena resena. Geka eveva gaveva nendae setiri vovoserira, ningivu! ");
INSERT INTO kpr_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Oro ningiami nanda sari ava eraera, tege nanda bukuda gembarena amo, na oro Egypt nengae Babylon ghae da javo ava, nébarago gembarena. Evetu genembo Jerusalem aminda siroredo irera, tege nanda bukuda gembarena amo, na Philistia embo, Taia embo Ethiopia embo da javo ava gembarena. ");
INSERT INTO kpr_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Saion dae mo, eminge sarera, “Nunda oro oro nanjogo ainda sirorari vasa mo, Jerusalem numori. Ainda sedo, God iká bekáda aimi sari fakina e fetarira.” ");
INSERT INTO kpr_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Bajari nunda oro oro nanjogoda javo gefuse, ne isasambu Jerusalem aminda siroredo, Jerusalem embo beká irarira ava gembarira. ");
INSERT INTO kpr_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Amingari, Jerusalem embo divu fusedo ghuse eminge sise irarera, “Arie Jerusalem, namanenda jebuga a esimbugari da susumo nimori.” ");
INSERT INTO kpr_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Arie Bajari God, nanda jebuga mutari kato, sifo ate refira evia inono, na nimokena sonembadae koko seraena a tumbaghae barago foa nimokena banungeraena. ");
INSERT INTO kpr_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Nanda banungari ningi! A na ninda sonemba dae kori seraena barago, ningi! ");
INSERT INTO kpr_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Dara digari beká namokena foa gheraira aimi, na ambari dae itako erena. ");
INSERT INTO kpr_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Namo evetu genembo nanjogo ambari dae erera, amingori. Nanda fakina isambu dadabetira. ");
INSERT INTO kpr_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Na fitero aena, ambari embode feteteni. Na ambari embo ambu ujo da fafasirera ainda kaugori. Na evetu genembo kotae eteso nimokena ajagha irise ninda sonemba jo bae eraera, amingori. ");
INSERT INTO kpr_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Na bu fugeteso, ujo jokáda vose faseteni. Bako ghousago a tumba jinjagharigo beká, aminda vosedo irena. ");
INSERT INTO kpr_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Ninda dubo ekoko da bouvu aimi fatiri faseteni! Na ninda janje eko da bouvu inono eva da kaugoi fatiri vose duruda fasirena. ");
INSERT INTO kpr_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Nine eteso, nano namendi na gukai mutudo, na gari imboe eraera. Na nange buvu jebugaetena da emboro, gaje tefo etira. ");
INSERT INTO kpr_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Ninda janje eko ava itatamuse, sorara eno diti jivu aimi afurugetiri, roera garikena fakara erira. Bajari, sifo evia inono nindae kori sise, nanda ungo jigheono erorureari benunu seraena. ");
INSERT INTO kpr_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","O ambari embo kote gi! Ni ambari embokena tano mendeni mendeni eraesa, ai? O ne eredo yaru sise, ninda javo jigheoro ereraira, ai? ");
INSERT INTO kpr_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","O ambari embo ninda dubo bari itatama edo, aindae osa seraera, ai? O ambari embo bete dadaberaera ainda jokáda ninda sonemba a kavevera eraesa aindae osa jo sae eraera, aĩ? ");
INSERT INTO kpr_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Aminga ava, ambari embo aimi ninda tano mendeni mendeni tumba jinjagharida irera, aimi jo gae eraera. A ambari embo ofofo da kotari dadabusira, aimi ninda veka eveva gaveva eraesa, ava ne jo kotae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Avata Bajari, na jo amingo iraeri. Sifo atuterira evia inono, nimokena sonembaso dae kori sise banungeraena. ");
INSERT INTO kpr_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Bajari, ni redae na imboe eresi? Ni redae na gukai erefutesi? ");
INSERT INTO kpr_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Na mandi seka sirorusena aitano ghedo, na tamo vevera itatamuse ambari dae ghosuguseni. Nandae mema muturaesa da bouvu ava fufuse, nanda tamo eregofira. ");
INSERT INTO kpr_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Ninda janje ekoko teria bekáimi na afuregetira. Na dari beká deteso, ambududurerena. ");
INSERT INTO kpr_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Sifo tumba evia ninda mema muturaesa, kau useghai na jimbe birurughari getira. Jebuga da gorota isambu gaje doindanghetira. ");
INSERT INTO kpr_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Nine eteso, nanda kokomana utua beká isambu na imboe eteri. Amingetero, tumba aimi nusuka nanda karona eraira. ");
INSERT INTO kpr_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Arie Bajari, ni evovodae na dubo buraesa aindae, nimokena yaru didivuse irarena. Ninda beká gajari namokena isambu eraesa aindae, osa sarena. ");
INSERT INTO kpr_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Na kasama erena ninda dubo bari evovodae irira. A ninda sari bekava nembori jo dombu eni ae arira, kau utu fakinaé fetirira aminga ava evovodae irarira. ");
INSERT INTO kpr_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Ni sisesi, “Na genembo eni gategedo nangae tofo tofo beka gagojuseri. Nanda saramana kato David kena beka gagojuse eminge siseni, ");
INSERT INTO kpr_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Ninda imendi gamendiimi evovodae kini nene edo gharera. Na evovodae nine kini edo irari da vasa ava kaifa ururono irarira jo eniimi bae arera’”. ");
INSERT INTO kpr_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Tano fakina ghae garigo beká eraesa aindae ninda natofo aneya utuda irera aimi yaru divuraera. Bajari, ninda sari isambu kaifa udo refesa aindae, ninda aneya kakarago osa sise yaru divuraera. ");
INSERT INTO kpr_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Bajari, mave utuda irera amo, jo nimongo iraeri. Aneya mane utuda irera á jo nemonde fitoro inono ari iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Aneya da giti jighari kakato totorugedo irera isambu, nindae oju eraera. A mave ni jimbe birurughe fetirágheraera aimi, isambu nindae oju eraera. ");
INSERT INTO kpr_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Bajari, God Fakina Isambu da Tofo, ninda fakina ava jo enií ghae inono arigo iraeri. Evovodae ni reava seraesa ava aminge eoso siroreraira. ");
INSERT INTO kpr_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Karaje fakina kato emo ninda sari ningariri. Eva anje foa gheraira, nine seaso binono eraira. ");
INSERT INTO kpr_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Ni eva da gambauva nombua teria ava nine deteso ambududurusira. Ninda fakina aimi gitofu de atai duboda fafotusesi. ");
INSERT INTO kpr_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Utu a enda amo ninda tofori. Utu gambari utu gambari aminda reju irera ava, nine eteso sirorusira. ");
INSERT INTO kpr_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Reighi utu gambari utu isambu ninda fitariri. Doriri Tabor nengae Hermon ghae ivuga use nimokena yaru divuraera. ");
INSERT INTO kpr_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Ni fakinago bekári! Ninda fakina mo, tomanako bekári!. ");
INSERT INTO kpr_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Ni geka bekáda bekáda sise ari bekáda bekáda use irágheraesa aindae, ninda avo anumba fete gogoghombedo irira. Ni rea eraesa aimi ijugeraira, dubo bari kato nimori, a kotugo ni rea seraesa ava eoso beká siroreraira. ");
INSERT INTO kpr_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Evetu genembo mave ninda dombuda usasa jokáda deinghuse, nindae yaru divu fumbu aruguse tumonde baingheraera, ne ivuga use irarera. ");
INSERT INTO kpr_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Nindae sise ne sifo ghousa evia ivuga eraera. Ninda kavevera aindae sakai sise ninda javo jighioro ereraira. ");
INSERT INTO kpr_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Tataya sifoda namane sonembeoso gitofo de atai fati feteraera. Ninda dubo bari tomanako bekáimi namane sonembeaso gitofu fakinago ava dedo gaedo gherera. ");
INSERT INTO kpr_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Arie Bajari, namane kaifa arida genembo ava, nine gategusesi. Namane Israel emboda God kakara nimori. Namane da kini (king) ava nine gatege futusesi. ");
INSERT INTO kpr_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Anakora beka saramana kakato ninda sari ava edo ghusera aikena, eminge sisesi, “Na isoro embo binonde eni Israel embo jokáda ghe gatege sonembuse, numo kini are dae siseni.” ");
INSERT INTO kpr_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Nanda saramana kato David ava, usu kakarai jijighuse eteno, kini (king) usira. ");
INSERT INTO kpr_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Nanda fakina evovodae numokena irarira, nanda fakina aimi sonembururari nu fakina edo fetarira. ");
INSERT INTO kpr_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Gitofu numo dari dae arera amo, nu jo dae arera. Ari ekoko embo nemonde tataya arera amo nu jo dedo atai fati fetae arera. ");
INSERT INTO kpr_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Nunda gitofu nane daono sirivo e tefo arera, a mave nu imboe eraera, ábarago daono amomonje garera. ");
INSERT INTO kpr_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Na nu dubo ruruse, rea nundae sisena ava, jo kotae edo gharena. Amingururono, nu evovo dae sosighi use, fati fetedo gharira. ");
INSERT INTO kpr_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Nunda enda mutarena amo, eva Mediteranian seraera, aminda ghe ya, uvu tomanako Eupharates seraera, aminda tano arira. ");
INSERT INTO kpr_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Nu nandae eminge sarira, “Nanda God a afa mo, nimori. Ni nanda gagara a sonembari katori.” ");
INSERT INTO kpr_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Nu nanda mandi bego dae barena. Kini mane nanjogo irera, einda jokáda kini tomanakogo beká nune arira. ");
INSERT INTO kpr_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Na numokena beka gagojusena ava evovodae ava udo yarena, a nanda agho dari reava usena, amo evovo dae irarira. ");
INSERT INTO kpr_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Nunda sasingu reighié nene kaifa udo yarera. Utu evovodae irá gheraira aminga ava, nunda imendi gamendi nene kini udo yarera. ");
INSERT INTO kpr_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","“Avata, nunda imendi gamendi nanda agho dari imboe use, nanda agho dari jo amboda amboda ae arera. ");
INSERT INTO kpr_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","A nanda ijuga gukai mutudo, nanda agho dari jo kaifa ae arera amo, ");
INSERT INTO kpr_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","avori, nenda ari eko dae na ne daono ghamo barera, a nenda kosasadae bouvu mutono, nene barera. ");
INSERT INTO kpr_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Avata nanda dubo bari David kena jo nanjigo tano ae arira. A na beka rea ava gagojusena amo jo bejae arena. ");
INSERT INTO kpr_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Na agho reava nangae dabade sise dorusera, ainda geka da mendó eni jo kote doyae arena. Na beka gagojuse rea sisena, ainda geka eni jo kosasaghaono durae arira. ");
INSERT INTO kpr_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Nanda javo kakaragoimi javono tofo gatise, beka gajeteno fetedo evovodae irarira. Na jo sifo nanjigo aminda David kena gungubo sae arena. ");
INSERT INTO kpr_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Nunda imendi gamendi evovodae sirorudo yarera. Nunda natofo kaifa ururono, iji janimbuse irá gheraira aminga ava ne kini udo yarera. ");
INSERT INTO kpr_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Tambuno evovodae irira amingudo yarira. Utu evovodae irira, aminga ava kini (king) udo yarera.” ");
INSERT INTO kpr_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Avata ninda kini gategusesa aikena dubo ekoko edo, nu imboe use, gukai muteso, nusuka fetetira. ");
INSERT INTO kpr_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Ninda saramana kato ghae rea ava tofo tofo beka gagojuseva ava, nine bejedo, nunda kini (king) da gogho kekesa avavaga bu fugeteso, fororoda du fasetira. ");
INSERT INTO kpr_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Nunda bogu begaya furu dighi birurughusera ava, ninda fakina aimi de bejisesi. Nunda isoro embo da jungari vasa isambu barago nine de bejeteso, bununughuseri. ");
INSERT INTO kpr_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Amingetiri, aminda mave ya fa gheraera aimi nunda gugua bagia eraera, a oro mendeni tinguda iritirera, aimi nundae gegha jiraera. ");
INSERT INTO kpr_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Ni sonembeteso, gitofui nu dedo atai duboda fafotuseri. Amingeteso, ne isambu ivuga useri. ");
INSERT INTO kpr_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Nine eteso, nunda ambi goroba mendo baumba usira. Ni ungo sokinimbeteso, gitofuimi isoroda nu de duboda atai fafotuseri. ");
INSERT INTO kpr_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Aminguse, nunda kini da kotofu ungo jighari, kefata avavaga ava saghimbe bu babaregusesi. Nunda kini da avo anumba barago jighi rokombeteso du fasusira. ");
INSERT INTO kpr_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Nine bouvu futeso, nu genembo seka ava, nunda sifo jo buvae iriri totoi embako usira. Amingedo, meka gosuse irira. ");
INSERT INTO kpr_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Arie Bajari, ni redae evovodae na gi gagaerego eraesi? Junge iraresa ai? Ninda dubo ekoko ghousa mavega ava avaraka avariguse irari? Gi gagaerego eraesi. ");
INSERT INTO kpr_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Nanda jebuga tufako beka erira, ava kotaetesi! Namane endada evetu genembo isambu nine eteso siroruseri, ava kotaso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Mave jo ambae jebuga irari? Namane evetu genembo eni jo uje da fakina darigae arera. ");
INSERT INTO kpr_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Arie Bajari, ni giti namane dubo budo ghusesa da beká oroko redari? A ni David kena beka gagojuse sonembari sisesa, ábarago redari? ");
INSERT INTO kpr_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Ninda saramana kato namori. Nandae jijivu sisera ava, erá kotae eose! Gitofui nandae jijivu sisera ava na gambu tainghuse irena. ");
INSERT INTO kpr_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Arie Bajari, ninda gitofui kini nine gategusesa, aindae jijivu sise “nimoá” seraera. Nu reda ya foa gheraira aminda, ne aminge seraera. ");
INSERT INTO kpr_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Bajari da javo evovodae jighoro erarira! Ai bekári, Ai bekári. ");
INSERT INTO kpr_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Arie, Bajari, ni evovodae namanenda irari vasa, namanenda nati ava, nine edo iresa. ");
INSERT INTO kpr_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Ni doriri a enda jo aso sirorae iriri ainda gitida, ni evovodae iriasi. A kotugo, ni iresa, a evovodae iraresa. ");
INSERT INTO kpr_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Ni seaso evetu genembo jovereghedo sekago fonja jineraera. ");
INSERT INTO kpr_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Ghaeko 1,000 tegaresa amo, nimokena mo, kau sifo dabako da kaugori. Ghaeko a sifo amo, inono sife irara jiriri dadabumuta, aminga ava dadabarira. O kau tumba jokáda sifo goroto tufako ya dadaberaira, aminga ava dadabarira. ");
INSERT INTO kpr_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","6","Kau usegha o gisi foa, roera isambu bu yeari dadaberaira aminga ava, ni namane beoso dadaberaera, amo kau aturu da kaugori. Namane mo, kau vive sifoghae vitido vuji gatedo, kotugo tumba jireari gharasa edo aviraira aminga ava eraera. ");
INSERT INTO kpr_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Ninda janje ekoimi namane deaso sirivo eraera. Ninda janje eko teria beká aindae, namane oju beká ava use, ungo ata dadadagheraera. ");
INSERT INTO kpr_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Ni namanenda ari ekoko ninda dombuda fitiraesa. Namanenda ari ekoko ufena eraera ava, ninda usasada fiti gosuse irá gheraesa. ");
INSERT INTO kpr_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Ni janje eko eari seaso namane amburaera, jo ghousa irá ghae eraera. Namanenda jebuga, kau beka roboghoi sirureoro ya dadaberaira aminga ava eraira. ");
INSERT INTO kpr_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Ghaeko 70 edo irarera amo, inonori, namanenda boandari. O namane fakina beká ava arera amo, ghaeko 80 edo iria ambarera. Avata ainda jokáda, dara a mema avanembo itatamuse iria gheraera. A kotugo, namane totoi namanenda jebuga dodo ambeoro dadaberaira. ");
INSERT INTO kpr_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Mave eniimi, ninda janje eko ainda bouvu isambu jo itatamae usira! Mave eniimi, oju ninda janje eko teria beká bu foa gheraira ava, jo itatame gogoghombae eraira! ");
INSERT INTO kpr_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Namanenda irari enda eminda, sifo tufako irarera ava ijugaso, namane gi kasama use, dubo kote gogoghombarera. ");
INSERT INTO kpr_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Arie, Bajari, ninda janje eko namanekena nanjigo dadabari? Bajari, jovereghe fu, namane ninda saramana kakato, namanekena joka aetesi! ");
INSERT INTO kpr_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Sifo ava inono, ninda dubo bari averegaso, namanenda dubo joká bedo beká are! Amingaresa amo, namane yaru didivuse, namanenda jebuga jokáda sifo ghousa ivuga use irarera. ");
INSERT INTO kpr_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Giti, ni namanekena dubo mema muteaso, namane ghaeko ghousa dubo mema tafuse irá ghedo ghuseri. Ava sedo, kau giti dubo mema begogo futusesa aminga ava, oroko dubo jama a ivuga begogo mutaso itatamuse irore! ");
INSERT INTO kpr_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Sonembaso, namane ninda saramana kakato ninda ari fakina ava gaore! A kotugo sonembaso, namanenda imemesiri nembarago ninda fakina duroghae ava gaore! ");
INSERT INTO kpr_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Bajari namanenda God, sonembaso ninda esimbugari namanekena irare! Namane rea ari dae erekotera ava, sonembururaso inononda aoro beká sirorare! ");
INSERT INTO kpr_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Mave Bajari Iká Beká irira, aikena ya nunda sonemba bari dae sise irá gheraira amo, Bajari Fakina Isambu da Tofo, aimi genembo amo, tavo ururari eveva irarira, Bajari da dombuda. ");
INSERT INTO kpr_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Aminguse, nu Bajari kena eminge sarira, “Nanda ambo sose fetari vasa amo, nimori. Ni nandae sedo isoro edo, namo kaifa urureaso, nanda gitofu jo foa na dae eraera. Ni nanda God, na nimo tumonduse irena,” aminge sarira. ");
INSERT INTO kpr_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","God ni kaifa ururari, ni jo ya vagho jungetero irira aminda teraso fatae arira. A kotugo, ambari da kae jo foa ninda tamonda vitae arira. ");
INSERT INTO kpr_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Nunda ghabuimi ni gagara edo kaifa ururari, ni eveva iraresa. Nunda kaifa ari mo, jo nanjigo aminda dadabae arira. Kau bere tamo gajeraira aminga ava, nu ni kaifa use gajari, ni ambo numokena sose fetaresa. ");
INSERT INTO kpr_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Dara tumbaghae foa gheraira aindae, jo oju ae aresa. O gitofu isonga ufena foa, isoro ari dae beje buveoro gi dudukugheraesa aindae, jo oju ae aresa. ");
INSERT INTO kpr_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","O taono ambari tumbaghae bu foa gheari, natofo digari buraera, aindae jo oju ae aresa. O ambari da kae aimi isonga sosighi eari amburaera, aindae jo oju ae aresa. ");
INSERT INTO kpr_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Gegenembo 1,000 ninda dengesida fetarera, avata ne isambu ambu fafasarera. O saone, gegenembo 10,000 ninda ungo gimandu kena fetarera, avata isambu ambududururoro, ni eveva fetaresa, jo mema eni ninda tamonda sirorae arira. ");
INSERT INTO kpr_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Aminguse, ni ditii fuge gosuse, ari ekoko embo mino rejo buraera ava kasama aresa. ");
INSERT INTO kpr_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Avata nimo, ni benunu seteso Bajari gagara etiri, ni ambo numokena sose fetedo iresa. Bajari Iká Bekáda ninda tavo kato edo irira. ");
INSERT INTO kpr_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Ava sedo, dara eniko jo foa nimokena sirorae arira, mema dombu eni dombu eni ava, jo foa ninda kamboda buvae arira. ");
INSERT INTO kpr_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Ainda beká mo: God nunda aneya ni kaifa aoro dae sedo dengoro indari, ni reda yaresa amo, ne gagara ururoro deingharesa. ");
INSERT INTO kpr_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Aneya nenda ungoimi ni unumbe bu ya foa ghururoro, ninda ata jo ghamanai de fokughari mema sae arira. ");
INSERT INTO kpr_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Aminguse, ni raiyoni (lions) a jingabu ava dedo atai fati fetaresa. Raiyoni (lions) tataya kakato a jingabu kaeghae ava dedo atai fati fetaresa. ");
INSERT INTO kpr_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","God eminge resira, “Evetu genembo mave na dubo buraera amo, na sonembarena. Na, evetu genembo mave nandae sise, ‘Bajari’ seraera amo, na ne sonembuse gagara eono, ne namokena ambo sose fetarera. ");
INSERT INTO kpr_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Ne namokena kori sarera amo, sifo daba aminda, na mino sarena. Ne dara jokáda fetarera amo, na namonde dabade fetarera. A kotugo, na nemo sonembuse, dara da ungoda ava saghimbe budo, vasa evevada fitido, nenda javo jighono erarira. ");
INSERT INTO kpr_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Na nanda mino eveva, sifo ghousago enda eminda irari, ava mutono, ivuga use dubo jama arera. A nanda sonemba ijugaono garera,” God aminge resira. ");
INSERT INTO kpr_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Arie Bajari, nimokena aiyakoe sari mo, evevago bekári. Arie God ika bekáda iresa, javono nimoa gatise yaru sarera, evevari. ");
INSERT INTO kpr_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","3","Ninda kavevera eraesa aindae, gita dombu eni dombu eniimi doruse evovodae sifoghae osa sedo gharera, a kotugo ninda geka seteso irira isambu eraesa aindae osa sedo gharera, ábarago evevari. ");
INSERT INTO kpr_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Arie Bajari, ninda ari babaigo eraesa aimi eari, na dubo eveva beká eraena. Nine rea ututusesa aindae na ivugaghae yaru sise dubo jeuro edo gharera. ");
INSERT INTO kpr_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Arie Bajari, ninda aito fugari ava babaigo bekári. Ninda kotari mo, kafurugori. ");
INSERT INTO kpr_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Geka sari dae erena ava, genembo ghuna irae jo kasama ae arira. Genembo kotari tufako aimi mino jo bae arira, amo eviri: ");
INSERT INTO kpr_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Ari ekoko embo, vive totoi vitiraira aminga ava, ne digeraera. Aminga ava, evetu genembo kosasa teria futo eraera, aikena gugua dige faseraira. Avata sifo amboda Bajari sari ne ambu tefo arera. ");
INSERT INTO kpr_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Ainda tuka mo, Bajari, nimo God ikada bekári, evovodae iresa. ");
INSERT INTO kpr_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Namane kasama erera, nindae osogo ari kakato amomonjegarera, a kotugo ari ekoko embo da fakina ava nine daso bejarira. ");
INSERT INTO kpr_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Nine eteso, nanda fakina kau borumakava babaigo ainda fakinago avavago edo irira. Na esimbugeteso, ivugaghae irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Nanda gitofu da fakina deteso bejisira amo na gosuseni, a kotugo ari ekoko embo mema dae dimbia sorara ero nininguseni. ");
INSERT INTO kpr_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","O irari dambugo irari embo ninda sari ava eraera amo, kau ika goroba totoigo vitiraera aminga ava, ne digarigo eraera. A kotugo nenda bajari kau ika beriberia babaigo Lebenon iritirera aminga ava, bajarera. ");
INSERT INTO kpr_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Nemo kau ika mane Bajari da kambo jokáda govetero iritirera, ainda kakaugori. God da tafaroro kambo aminda irise, eveva itatamuse irera. ");
INSERT INTO kpr_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Ana edo irera, avata beká jijighuse irera, a kotugo evovodae baduru use, igi yauya ghuse fakinago beká iritirera. ");
INSERT INTO kpr_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Aminda fuge gosuse kasama erera, Bajari numo dambugo bekári. Nanda gagara katokena, kosasa eni tefori. ");
INSERT INTO kpr_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Bajari numo Kiniri (king). Nunda fakina duroghae, inono embo asugeraera aminga ava, asugedo irira. Enda nune fitiri, fete gogoghomberira. ");
INSERT INTO kpr_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Arie Bajari, utu enda ae gitida ni iriasi. Ni sifo aminda kini edo, amingudo refesa. Ninda avo anumba da fakina jo nanjigo dadabae arira. ");
INSERT INTO kpr_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Arie Bajari, kafuru ghighi beka duka javi eraira, eva anje gugugugheraira. ");
INSERT INTO kpr_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Avata, Bajari, fakinago beká utuda irá gheraira, nunda fakina mindafugo bekári, jo kafuru eva da gugugughari amingo iraeri. Eva fumbasa eraira da fakina barago, jo numongo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Arie Bajari, ninda Agho Dari mo evovodae irarira. Ninda tafaroro kambo kakara kakarago beká edo irira, a evovodae amingudo yarira. ");
INSERT INTO kpr_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Arie Bajari, God ari ekoko embo ghamo baoro dae eraira, nimori. Nendae janje eko eraesa ava, ijugaso gaore! ");
INSERT INTO kpr_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Evetu genembo isasambu ainda ijujari kato nimori. Arie, ere fu! Evetu enembo totofo sakai sise, ivuga futo eraera, ainda mino ava, mutaso baore! ");
INSERT INTO kpr_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Arie Bajari, ari ekoko embo amo ghousa mavega ivuga ghae irareri? ");
INSERT INTO kpr_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Tafasara embo ghousa mavega totofo sakai sido yareri, ákotugo nenda tafasara eraera aindae sakai seraeri? ");
INSERT INTO kpr_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Arie Bajari, ne ninda natofo ava fati bebetegerera, ne ninda totofo ava kateyavara futo use mema erefutera. ");
INSERT INTO kpr_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Ne roriri a babate ava dorureoro amomonjegeraera, a kotugo oro mendeni esa fera, namondeda endada iritirera ava, de goregheraera. ");
INSERT INTO kpr_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Aminguse seraera, “Bajari namonde jo gae eraira. Namonde rea eraera ava, Israel embo da God jo kasama ae eraira.” ");
INSERT INTO kpr_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Aminge seraeva aindae resena, ne daghariri. Ne kasama nanjigo barevu? ");
INSERT INTO kpr_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","God namondeda dengoro mane ututusira, ava nenda geka ningari jo inono iraeri? God namondeda diti ututusira, aikena gari fakarari? Givu! ");
INSERT INTO kpr_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Enda da natofo nanjogo irera, aindae ghoghora nune seraira. Avata jo ghoghora vanembo sae arira. Nenda aito fugari da mino barago mutari, itatama arera. Evetu genembo isasambu ainda ijuga kato numori. Ágido, kasama nunda tofori. ");
INSERT INTO kpr_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Evetu genembo rea koteraera amo, Bajari nu kasamari. Ne jo kote simbugae eraera, ava nu kasamari. ");
INSERT INTO kpr_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Arie Bajari, evetu genembo nine dengoro induduse, ninda agho dari ijugeraesa, aimi ivuga use irera! ");
INSERT INTO kpr_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Gitofu aimi nemokena dombu kosero refera ainda jokáda, ninda natofo dae goroto mutaso jangutururoro, ni gitofu da vagho simbugaso vosarera. ");
INSERT INTO kpr_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Ainda tuka mo, Bajari nunda natofo, jo doyae arira. Evetu genembo nunda tofo dae gategusira aikena, gukai jo mutae arira. ");
INSERT INTO kpr_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Sifo aminda, aito fugari sembae use koto edo ghusera, ava dodo geka bekáda bekáda sise koto udo yarera. Avavaga sirorarira amo, natofo eveva isambu ivugaghae amboda amboda udo yarera. ");
INSERT INTO kpr_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Gitofu osogo ari dae sedo fusera amo, na mave sonembari dae erorusi? Na mave sorise, gitofude osogo usi? ");
INSERT INTO kpr_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Bajari, na jo sorae aetira amota, na ambudo, totoi vosiya, ambari embode dabade fasaeteni. ");
INSERT INTO kpr_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Arie Bajari, “Na durariá” kotiseni. Avata ninda kavevera eraesa aimi na jigheso eroruseni. ");
INSERT INTO kpr_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Na mana mana use dubo buneraena amo, nandae kavenu nine seoso na saga faingheraira. ");
INSERT INTO kpr_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Ni itako jo, gavana mane ari eko ari da emboro rerebuse agho deraera ainde dabade, fetae aresa. ");
INSERT INTO kpr_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Gavana mane resena, evetu genembo eveva derari dae sise, manaka gayeraera, kotugo nenda ujuda use, evetu genembo dara jo ae usera ava, seoro deoro amburaera. ");
INSERT INTO kpr_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Avata Bajari, namoa soreraira, nanda God nane tumonde baingheraena aimi nandae sorega nune eraira. ");
INSERT INTO kpr_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Ari ekoko embo resena, nenda ari ekoko aindae sari ghamo barera. A kotugo nenda ari ekoko edo ghusera aindae nemoa basa eko beká ava jigharira. Namondeda Bajari God, aimi dari sirivo arera. ");
INSERT INTO kpr_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","2","Fuvu, ya totorugaore! Bajari kena dubo jeuro use, yaru divore! Namondeda kaifa a sonemba katokena, ivugaghae beka fainghe sakai saore! Aminguse, ya Bajari kena tere nunda dombuda fetedo, “aiyakoe” saore! Ivugaghae aruguse, sakai sise yaru numokena divore! ");
INSERT INTO kpr_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Ainda tuka mo: Bajari God nu iká bekádari. Nu god mendeni irera, nenda dombu bekádari. ");
INSERT INTO kpr_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Enda isambu nunda tofori. Beku enda jokáda irira amo, nunda fitariri. Endada doriri fetirira a barago, nunda fitariri. ");
INSERT INTO kpr_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Eva a enda mo, nune setiri sirorusira ava sedo, nune kaifa eraira. ");
INSERT INTO kpr_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Ava sedo, fuvu ya totorugaore! Bajari namonde setiri sirorusera ainda dombuda, tumoi bainghuse kauboi dadarigaore! ");
INSERT INTO kpr_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Nu namondeda God, a kau sifi (sheep) kaifa kato nunda sifi (sheep) kaifa eraira, daba aminga ava, God namonde kaifa eraira. Oroko God beka sirurari ningareva amo, ");
INSERT INTO kpr_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","erama gogore edo, God ighagha eove dae resena. “Kau nembuamane reighi Meriba aminda usera aminga ava, eove dae sise resena. Ne reighi uvu a evetu genembo irae vasada, Masa aminda usera, aminga ava eove!” ");
INSERT INTO kpr_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","10","Nembuamane usera aindae, God eminge resira: “Ne na ighagha edo, nanda fakina ava dere gosuseri. Ne ghaeko 40 ainda jokáda, nange nanda fakinaimi tavo eno gosusera ava kotae edo, nanda fakina sekago dere gosuseri. Na aindae sedo nembua manedae janje eko etiri siseni, ‘Ne na sifo ghousa ighagha eraera, a nanda sari ava jo ningae eraera.’ ");
INSERT INTO kpr_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Aminge sedo, na dubo eko etiri, durumuguse beka gagojuse eminge siseni, ‘Ne jo ya, reighi ne jangutaoro dae sedo, nemokena mutari dae kotisena aminda, namonde dabade tere jangutae arera,’ aminge siseni.” ");
INSERT INTO kpr_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Arie, endada evetu genembo isambu! Bajari dae yaru seka saore! Bajari kena yaru saore! ");
INSERT INTO kpr_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Bajari kena yaru sise, nunda javo jighoro erare! Nune sonembetiri namonde jebugusera ainda binó ava, sifo evia inono vironu sedo ghaore! ");
INSERT INTO kpr_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Nu duroderi a nunda ari isambu fakinagori. Ainda binó ava oro isambukena vironu siruroro dudukughaore! ");
INSERT INTO kpr_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Airesira, Bajari numo teriagori, a kotugo sakai teriago mo nundae saore! Ove keveraera aindae igheghi jo ae arera. Bajari nusuka nundae igheghi aore! ");
INSERT INTO kpr_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Ai resira amo, oro mendeni mendeni ne isambu god mendeni ava, tumonde baingheraera, fakina tefori. O Bajari, numo utuda roera isambu nune ututusira. ");
INSERT INTO kpr_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Numo duró a usasa aimi doghedo irira, fakina tomanakogo a usasa garigo beká aimi nunda tafaroro kambo beda edo irira. ");
INSERT INTO kpr_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Arie, endada evetu genembo nenda ghagurude isambu, Bajari da javo jighivu, erare! Nunda duró a fakina tomanakogo aindae numokena sakai sise jighoro erare! ");
INSERT INTO kpr_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Bajari da javo durode ava jighoro erare! Ango fayaya bambu fuvu, nunda tafaroro vasada terove! ");
INSERT INTO kpr_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","God kakarago beká ai fururari garesa amo, nunda dombuda tumonde bainghevu! Endada evetu genembo isasambu, nemokena resena, nunda dombuda igheghi ojughae tumonde bainghevu! ");
INSERT INTO kpr_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Endada oro oro isambukena saore, “Bajari numo Kini (king) ri! Enda mo, nune fitiri susu gambu fetirira, jo itako gisighae arira. Nu evetu genembo isasambu ava nenda ari ekoko a eveva eraera, aminda gosuse ijujarira.” ");
INSERT INTO kpr_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Utu endaghae nemokena resena, dubo eveva use, ivuga aovo dae resena. Eva a eva da roera gindovi gandovi isambu, nemokena resena, duka aovo dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Vare a vare jokáda reju iritireva, nemokena resena, ririaghae koko sevu! Ika mane taimada iritireva isambu, nemokena resena, ivugaimi fumbu arugevu! ");
INSERT INTO kpr_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Ai resira amo, Bajari endada evetu genembo ijujari dae refira. Nu endada evetu genembo isasambukena inono use, ne bekáda bekáda ijujarira. ");
INSERT INTO kpr_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Bajari numo kiniri, enda riria aso dae resena! Butu utu gambari utu gambari aminda fugedo ireva isambu ivuga aovo dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Foroga aimi a tumba jinjangharigo aimi nu doghedo irira. Roera isambu nune bekáda bekáda use kaifa e goghomberaira. ");
INSERT INTO kpr_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Avaraka aimi nunda dombukena ise, evetu genembo numokena osogo use irágheraera ava, dungiari aviraera. ");
INSERT INTO kpr_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Nunda biria tarighuse usasa jaraghurureari, enda aimi gido ungo ata dadadagheraira. ");
INSERT INTO kpr_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Enda jiro fumbari kau tavaya tiveraira aminga ava, endada oro oro iritirera, ainda Bajari da dombuda tivarira. ");
INSERT INTO kpr_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Utu da roeraimi ijugerira, God numo, ari bekáda bekáda vanembo eraira. Evetu genembo nunda oro oro isasambu nunda duro giraera. ");
INSERT INTO kpr_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Evetu genembo mave ove keve ava tumonde baingheraera, ne meka garera. Ainda beká amo, ove mo, fakina tefori, nenda god mane amo isasambu Bajari da dombuda numoa tumonde baingharera. ");
INSERT INTO kpr_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Arie Bajari God, nenda gitofu ijujuse easo ghamo buraera ava ningido, evetu genembo Saion iritirera a evetu genembo Judah bogu begaya digari futo aminda iritirera, riria aimi jaruteraera. ");
INSERT INTO kpr_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Arie Bajari Fakina Kato, natofo isasambu endada iritirera ainda kaifaé tavo arikato amo nimori. Nimo ika bekadari, god mane ninda duruda iritirera jo nimongo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Mave ari ekoko imboe eraera ava, Bajari nune dubo buraira. Nunda natofo da jebuga nune tavo eraira. Kotugo ari ekoko ari kakato ainda fakinkena saghimbe buraira. ");
INSERT INTO kpr_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Evetu genembo mave God da sari ava eraera aikena, God da usasa janimberaira, a kotugo nunda ivuga futurureari itatama eraera. ");
INSERT INTO kpr_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Arie, ari eveva gaveva embo, Bajari nendae rea usira aindae, riria use irivu! God kakarago beká rea usira ava kotise, nundae aiyakoe sedo ghevu! ");
INSERT INTO kpr_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Arie, Bajari kena yaru seka saore! Ainda susu mo, nu tano a ari fakinago etiri sirorusira. Tofo nunda fakina aimi a nunda ungo kakarago aimi, nune gitofu sosighi usira. ");
INSERT INTO kpr_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Nunda gitofu sosighi usira ava, Bajari nusuka osa sisira. Nunda natofo nange sonembetiri jebugusera ava, nune osa setiri, endada oro oro isambu ne kasama useri. ");
INSERT INTO kpr_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Nunda natofo Israel embokena beka gagojuse rea ari sisira ava kotise, ne dubo ruruse ava usira. God namanenda gitofu sosighi usira ava, evetu genembo endada irera isasambu, ne gosuseri. ");
INSERT INTO kpr_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Evetu genembo endada ireva, nemokena resena, ivugaghae Bajari kena yaru sise dubo jeuro evu! Nunda yaruimi sakai sise dubo jeuro use ivugaghae arugevu! ");
INSERT INTO kpr_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Bajari dae sakai sise, yaru dubo jeuro evu! Gita mane da duka aimi numokena yaru sise sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Tavuya dombu eini dombu enimi fusise, Bajari, namondeda kinikena ivugaghae koko fuge arugaore! ");
INSERT INTO kpr_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Eva, nimokena kotugo reju ava ninda jokáda iritirira nemokena resena, Bajari kena duka use yaru sevu! Enda akotugo roera ninda etoda iritirera isasambu nemokena resena, Bajari kena yaru divuvu! ");
INSERT INTO kpr_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Uvu mane barago, nemokena resena, kotugo enda jiro fumbari mane nemokena resena, ungo de fokufoku ghuse, Bajari da dombuda dabade ivuga use yaru sevu! ");
INSERT INTO kpr_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Ainda tuka mo, Bajari nune enda kaifa ari dae refira. Nu endada evetu genembo isasambukena inonoda use, bekáda bekáda use ne kaifa arira. ");
INSERT INTO kpr_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Bajari, numo kini evovodae irira, susu aindae evetu genembo isasambu oju aimi ungo ata dadadagheraera. Nunda anumba vasada serubim soroda anumburureari enda daradaragheraira. ");
INSERT INTO kpr_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Bajari Saion aminda anumbetiri nunda duro aminda ghedo refira. Evetu genembo isasambu da Bajari fakinago nusuka numori. ");
INSERT INTO kpr_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Evetu genembo isambu nunda javo tomanakogo akotugo duroghae ava javono gatise, sakai sarera. Kakarago beká amo, numori. ");
INSERT INTO kpr_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Arie, Kini fakina kato, ari dambugo irari embo ava dubo buraesa. Nine Israel eminda ari eveva ava bu fusesi. Nine Israel kaifa use inono beká edo ari bekáda bekáda eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Namondeda Bajari God kena sakai saore, kakarago beká mo numori. Nunda anumba vasa da dombuda tere tumonde bainghevu! Kakarago beká mo numori! ");
INSERT INTO kpr_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Nunda fristi mane mo, Moses nengae Aaron ghae useri, a kotugo Samuel barago numokena banungedo ghusira. Bajari kena nene seoro, nu ningido ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Nu foroga darido irurari ainda jokádaghe nemokena geka seari, ne nunda Agho Dari kotugo rea aoro dae sisira, ava edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Arie Bajari namaneda God, ni ninda natofo Israel emboda benunu ningido ghusesi. Geka bekári, ni nenda kosasa da mino nu futusesi, avata nenda ari ekoko kote dodo ghusesi. ");
INSERT INTO kpr_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Namondeda Bajari God kena sakai saore! Namondeda Bajari God kakarago bekári. Ágido nunda doriri kakara aminda numoá tumonde bainghevu! ");
INSERT INTO kpr_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Namonde isambu endada irera, dubo evevaghae beka fainghedo, Bajari kena yaru divore! ");
INSERT INTO kpr_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Nunda geka ningido, ivugaghae yaru didivuse, nunda dombuda tere fetore! ");
INSERT INTO kpr_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Aminguse, namonde kasama arera: God nu Bajariri! Namonde jo namondeda kotariimi siroraeri. Namonde, God nune setiri siroruseri. Namonde nunda natofori, nu namonde kaifa eraira. ");
INSERT INTO kpr_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Nunda kambo guro teria afigetiri irira aminda, “aiyakoe” sise, ya terore! Ya nundae sakai sise, jokáda terore! Nundae “aiyakoe” sise, nunda javo kakara aore! ");
INSERT INTO kpr_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Ainda beká mo: Bajari sifo ghousa evia veka eveva use irira. Nu kavevera ari kato a joka ari katori. Nu namonde joka use, dubo budo ghusira, dubo buraira, a dubo ruruse irarira. Nunda kaifa ari mo, namondeda imemesiri siroruse itatamudo yarera. ");
INSERT INTO kpr_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Arie Bajari, nanda yaru mo, namane dubo ruruse bekáda bekáda eraesa aindae, yaru divarena. ");
INSERT INTO kpr_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Nanda aito fugarena, kosasa eni tefori. Ni nanjigo namokena furaresi? Nanda kamboda na irari dambugo beká ava arena. ");
INSERT INTO kpr_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Aminguse, na jo doyono, ari sembaego nanda kamboda sirorae arira. Mave God gukai muturaera, rea eraera ava, na imboe beká ava eraena. Na jo itako nemonde dabade tatedo umo gaumo ae arena. ");
INSERT INTO kpr_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Na aroro kaifa ari da gorotoda jo kosasaghae arena. Na jo ari eko enimi bebeta ae arena. ");
INSERT INTO kpr_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Mave evetu genembo mendenidae unongu kivuimi siruroro ningarena amo, saono ne daoro ambarera. Genembo mave riria use, tofo nunda javo jighari erarira amo, ondono darigarira. ");
INSERT INTO kpr_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Nane evetu genembo God tumonderaera a geka bekáda bekáde sise irá gheraera ava, nemokena, “avori” saono, nanda kamboda teredo irarera. Mave aroro kaifa ari da gorotoda kosasa jo ae eraera, avanembo doyono nandae saramana arera. ");
INSERT INTO kpr_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Gungubo futo seraera aimi, nanda kamboda jo irae arira. Geka vivi sise, gesire use irari embo eni, jo nanda dombuda fetae arira. ");
INSERT INTO kpr_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Evetu genembo ekoko Bajari da reighi begaiya namonde irera eminda amo, sifo evia inono nanjigo tambarena ava, daono sirivo arera. ");
INSERT INTO kpr_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Arie Bajari, nanda banungari ningaetesi, sonemba dae sorara erena, ningi! ");
INSERT INTO kpr_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Na kae budo irise resena erá ningi ningaego eóse! Na nanjigo nimokena kori sarena, dengoro jave ningaso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Ai resira amo, nanda jebuga kau imbosi aminga ava rave ise dadabari gerira. Nanda tamo kau avarakai veri vara gheraira, amingori. ");
INSERT INTO kpr_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","God na detiri taká, kau eke gharasa e muse vosari guse rojari beká erena. Na bayau mindari jo uju ae erena. ");
INSERT INTO kpr_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Na kae saviri aoro sise, gevei etu yavarara gerena. ");
INSERT INTO kpr_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Namoako kau rika reighi uvu a evetu genembo irae vasada irari gerena. Kau rika kafu reighi do dumboro notuda irari gerena. ");
INSERT INTO kpr_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Na itako jo avae eraena, namoa kau rika dabako tainako aimi nati enoda anumbirari gerena. ");
INSERT INTO kpr_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Sifo inono evia isonga numboro nandae osogo ari kakato namoa dere jise, namokena geka ekoko mendeni mendeni sesegeraera. Dere jirari kakato amo simboro use eminge seraera, “Mave embavo jighiri nunda kae dika etiri, kae saviri aoro sise irira, aminga ava namondeda kae dika aeti!” ");
INSERT INTO kpr_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","10","Ainda susu mo, nandae janje ekoko edo na esike fugeteso, na bayau avegha ava rise, a nanda uvu diti jivughae baingoro ururari ava rise irena. ");
INSERT INTO kpr_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Nanda jebuga kau ungobu use tutumbageraira amingori. Namoa kau kikisa gharasa ari gerena. ");
INSERT INTO kpr_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Avata, arie Bajari, kini (king) kotofuko mo nimori, evovodae iresa. Evetu genembo ghaeko ghaeko evia siroruse irarera aimi ninda binó nininguse irarera. ");
INSERT INTO kpr_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Nine sifo gategusesa ava ojighira buvira aindae, ni orokoé foa tuturo edo Saion dae joka aresa. ");
INSERT INTO kpr_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Ai resira amo, reighié gitofuimi sosighi edo de bejisera, avata ninda saramana kakato ava jo kotae irise, Saion dubo buraera. De bejetero tise fasirira gido, ninda saramana kakato mema use irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Bajari, endada oro oro isambu ninda duró gido ungo ata dadadagharira. Enda da kini isambu ninda dombuda ojuimi ungo ata dadadagharera. ");
INSERT INTO kpr_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Ainda tuka mo, Bajari nu sekago Saion itarira. Nu sifo aminda ari ainda duró isagha ururari garera. ");
INSERT INTO kpr_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Nunda natofo imboe e fugetiri yabayaba ghuse irera, ainda banungari ava jave ningarira. ");
INSERT INTO kpr_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Bajari rea ari dae erira ava gosuse, gembovo, evetu genembo sifo amboda sirorudo yarera aimi, tege nundae sakai sise irore! ");
INSERT INTO kpr_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Eminge sevu ningore, “Bajari nunda irari vasa kakarago iká beká utudaghe nunda natofo gari dae diti fugetiri vovosusira amo, ");
INSERT INTO kpr_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","nunda natofo Israel embo ava gitofui kateyavara ero, sabua use ambari da aoro sero niningusira. O gotofuimi daoro amboro dae sisera, ava nune vujegetiri jejebuguseri.” ");
INSERT INTO kpr_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","22","Amingari, natofo nanjogo averege foa Jerusalem tafaroro kamboda teteruroro, enda da babojegari gavana mane isasambu ainde dabade teredo, Saion aminda tumonde bainghuse, Bajari da javoda sakai sise irarera. ");
INSERT INTO kpr_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Na endada jo ghousago irae aono dae sedo, Bajariimi nanda fakina de bejedo, nanda sifo soroda gafugusira. ");
INSERT INTO kpr_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Avata na sorara use, numokena siseni, “Arie nanda Bajari God evovodae iresa, nimokena kori resena: erá eoso na genembo seka irise ambeone! ");
INSERT INTO kpr_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Anakora beká giti tuturoda ni enda edo, utu ninda ghabui eteso sirorusira. ");
INSERT INTO kpr_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Nemo manjarera, o nimo, tano tefori, evovodae iresa. Ne taká kau embo boka manai edo bununungheraera aminga ava, aoro gaghe fugaresa. Kau genembo eni nunda asugari manai kosughe fugutuse, seka asugeraira aminga ava aresa. ");
INSERT INTO kpr_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","O nimo jo genembako ae, taká ava iresa. Nimokena tano tefori, evovodae iresa. ");
INSERT INTO kpr_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Kotugo ninda totofo Israel embo da imemesiri gamemisiri mo, kaifa e gagara ururaso, nimokena ambo sose fetirise irarera.” ");
INSERT INTO kpr_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Arie, namoáko, nanda dubo jokáimi, Bajari kena sakai saone! Arie, namoáko, nanda kotari a nanda fakina isambuimi, nunda javo kakara aindae sakai saone! ");
INSERT INTO kpr_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Arie, namoáko, nunda kavevera namokena eraira ava, isasambu kotise irarena. Ava kotise, nanda dubo jokáimi, Bajari kena sakai saone! ");
INSERT INTO kpr_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Nu emingeraira. Nu nanda ari ekoko isasambu kote doyeraira. Nu nanda kae a tamo vevera isasambu seari darigeari, na jebugeraena. ");
INSERT INTO kpr_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Na ambaetena, avata nune kosegedo na dubo ruruse nunda joka ariimi na afurugeari, jebuga irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Roera eveva nune muteari, nanda irari eveva use irá gheraena. Aminguse, na jovereghe genembo seka bajari da kaugo use, riduna da fakina aminga ava eraena. ");
INSERT INTO kpr_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Evetu genembo makasi embokena mema a bouvu muturaera ava, Bajari nune bekáda bekáda ijujuse, makasi emboá sonemberaira. ");
INSERT INTO kpr_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Nunda uju a kotari ava, Moses kena afigedo, nunda ari fakinaghae, Israel embokena ijugeari gido ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Bajari nu joka use, namonde dubo ruruse irá gheraira. Nu jo totoi janje eko ae eraira. Nu sifo evia inono, namonde dubo bu gogoghomberaira. Nunda dubo bari amo, jo nanjigo aminda dadabae arira. ");
INSERT INTO kpr_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Nu jo sifo ghousa namonde dombuda sae eraira. Janje eko nu eraira avata, jo evovodae ava kotise irae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Namondeda ari ekoko a dara eraera ava ijujuse, nu jo ainda mino beká ava inono use, mutae eraira. Mino eko rea baetera avata, nu kote doyeraira. ");
INSERT INTO kpr_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Utu enda ikáda irira, ainda gomboi darari jo tege bari da kaugo iraeri. Kotugo Bajari da dubo bari, mave nu kakara eraera aikena, amingori. Jo namonde tege kasama ari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Utu gambari utu gambari soveni soveni da soró jo tege bari da kaugo iraeri. Kotugo Bajari namonde da ari ekoko fugeraira ainda soró ghousa amingori. Fugeari ya dadaberaira, jo tege bari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Kau genembo eni nunda sasingukena veka eveva eraira aminga ava, God namonde mave nu kakara eraera aikena barago, veka eveva eraira. ");
INSERT INTO kpr_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Nu namonde kasama e gogoghomberaira. Nu nange endaimi budo namonde etiri sirorusera ava, nu kotise irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Namonde evetu genembo da irari a jebuga mo, kau kikisa da kaugori. Kau taima joka vitido, vuji gateraira aminga ava, namonde siroredo bajiraera. ");
INSERT INTO kpr_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Avata yauraimi fuseari, joka vuji dore vose dadabeari jo gae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Avata mave Bajari igheghi use tumonde baingheraera amo, nu sifo ghousa dubo buraira. A kotugo, nenda sasingu a nenda imemesirikena kavevera sifo ghousa eraira. ");
INSERT INTO kpr_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Nenda sasingu a imemesiri resena emo, na mave nunda emboroda ise, nunda agho dari ningi kaifa eraera aindae resena. Nunda kavevera ari, sifo ghousa nemokena muturaira. ");
INSERT INTO kpr_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Bajari nunda kini (king) da avo anumba durode utuda fitiri irira, aminda anumbirise, natofo a roera isambu ava, nune kaifa eraira. ");
INSERT INTO kpr_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Aneya fakina kakato, Bajari da geka a agho dari ningido eraeva, nemokena resena: Bajari dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Utu da fakina isasambu, a kotugo, Bajari da saramana a aghi kakato nunda uju eraeva, nemokena resena: Bajari dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Evetu genembo, sifo fuka, a roera isasambu, nune etiri siroruseva, nemokena resena. Ne reda irise nunda kaifa ari itatameraeva aindae, Bajari dae sakai sevu! Na barago nanda dubo joká isambuimi Bajari kena saone! ");
INSERT INTO kpr_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Arie namoako! Bajari dae sakai saone! Arie Bajari, nanda God, tomanakogo mo, nimori. Ninda tamo asugari mo, usasa duroghae aimi asugedo iresa. ");
INSERT INTO kpr_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Ni tofo usasa aimi doghedo iresa. Ni utu kau sasoro darari gusesi. ");
INSERT INTO kpr_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Ninda nati da gima mo, foroga ikáda iti simbugusesi. Kotugo foroga mo, ninda ghasemo dae budo, yaura da ghabuda vose deingheraesa. ");
INSERT INTO kpr_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Yaura mo, ninda aghi kakatori, edo avaraka bubura mo, ninda saramana kakatori. ");
INSERT INTO kpr_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Nine simbugeteso endaé nunda vasada susu gambu takegha edo, javi itatako jo ae arira. ");
INSERT INTO kpr_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Enda mo, ni evaimi emboi afurugarigo usesi. A doriri barago evaimi afurugusira. ");
INSERT INTO kpr_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Avata, ni uvu isambu dombuda avito sisesa ainda sifoda ne oju sufuseri. Ni koko fuge sisesa da sifo aminda ne sumbudo era dadabuseri. ");
INSERT INTO kpr_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Uvu doriri mane do gisighe vose tevisada fetetiri, doriri mane isagha ututusira. Oroko nunda vasa nine simbugusesa aminda irira. ");
INSERT INTO kpr_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Ni enda sekago afurugeure dae tano garusesa ava, nu itako jo jarigari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Nine eoso, enda tevisa karevada uvu kirikara ghuse sumburaira, kotugo enda jiro fumbari da soróda barago uvu sumburaira. ");
INSERT INTO kpr_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Taima da sino fuka uvu daba aminda mindiraera, taima da donki (donkey) uvu daba ava rise, dubo jo saghae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Ika mane uvu tinguda iritirira ainda jokada, rika mane mogha fafatu da fitido beka sise, iritirá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Ni utuda ghe borija muteaso enda jiro fumbari etoda vovosegeraira, eoso endada ninda esimbugari aimi bedo eraira. ");
INSERT INTO kpr_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Borumakava mindore dae sise nine eoso kikisa vivitigeraira, kotugo namane roera veka mane vareda govedo bayau bu mindoro dae sedo, enda esimbugeaso vivitigeraira. ");
INSERT INTO kpr_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Aminguse, asi vaini govedo bambu rise dubo jama tafuse, orivi muka bu dombu jighoro jaraghurari, kotugo farava inge rise, fakina baore dae sedo amingusesi. ");
INSERT INTO kpr_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Lebanon aminda ika mainada babai Bajari nunda tofodae sedo govusira, borija teriago buraera. ");
INSERT INTO kpr_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Rika mane, nenda mogha aminda itiraera. O rika ebena da kakaugo mane maina ainda ikada nenda mogha fifitigeraera. ");
INSERT INTO kpr_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Taima gouti babaigo ne kunika da iritirá gheraera, kotugo kaisi aroro tokáda junge iritirá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Tambuno mo, ghaeko baimara da tano ijugare dae sise, nine seteso sirorusira. Kotugo iji sifo reda ya voseraira ava nine seoso, nu kasama use ya voseraira. ");
INSERT INTO kpr_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Nine seoso tumba ainda jokada taima sino fuka isambu foa buvudo ghatagheraera. ");
INSERT INTO kpr_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Raiyoni seka babojegari gangara ghae nenda oka bayau God nine muturaesa ava bu mindari dae, kakova eraera. ");
INSERT INTO kpr_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Iji vitiraira amo, ne sekago jovereghe ya nenda tokáda fafaseraera. ");
INSERT INTO kpr_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Amingurureoro, evetu genembo eredo ya buvu nenda saramana eraera, kotugo saramana use iroro, ungobu eraira. ");
INSERT INTO kpr_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Arie Bajari, roera digari futo emo nine usesi! Roera isasambu dubo kotise e gogoghombusesi! Sino fuka, sivoro kororo mane dombu eni dombu eni nine eteso, aimi enda bedo edo irira. ");
INSERT INTO kpr_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Eva barago kotore, teria kotugo beraghari. Oka, kotugo roera dombu eni dombu eni, babaimi a veveyako ava jokáda iritirera, jo tegari da kaugo mo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Bouti mane eva etoda sumbu ya foa gheraera, kotugo gambauva nombura da kaugo babaigo ava eteso aminda yaru use irira. ");
INSERT INTO kpr_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Ne isasambu nenda ighoi sifoda nimoa gigitururoro, nenda uvu bayau nine muturaesa. ");
INSERT INTO kpr_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Nenda bayau rea muturaesa, ne ava mindiraera. Sino fuka nine unduraesa, isambu inono beka irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Ni gukai muturaesa ainda sifoda, ne oju eraera. Ninda janje asegari nemokena buraesa amo, ne amburaera, kotugo fonja aimi usesa, aminda jovereghe fonja jineraera. ");
INSERT INTO kpr_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","O ni enda eminda jebuga seka sirorare dae saresa amo, ninda Asisi mutaso ne siroredo fetarera. ");
INSERT INTO kpr_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Nanda uju enda eminda, Bajari da duroimi beda edo evovo dae iraeti! Nu rea setiri sirorusira aindae Bajari nune ivuga are dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Nu fuge enda giraira amo, enda daradara gheraira. Nu doriri mane nunda ungoimi dereraira amo, ne imbosi gombe gambe geraera. ");
INSERT INTO kpr_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Na enda eminda ghousa mavega irarena, Bajari kena yaru sise irarena. Sifo ghousa God kena yaruimi sakai sise irarena, ambari tano. ");
INSERT INTO kpr_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Nanda yaru sarena aindae nu ivuga aeti, ai resira amo, nanda ivuga Bajari kena ghe foa gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Nanda uju ari eko embo enda eminda ava sosighi aetesi. Ari ekoko embo ava ambu tefo aeteri. Arie namoako! Bajari dae sakai saone! Bajari dae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Namonde Bajari dae aiyakoe saore! Nu teria beká irira aindae, osa saore! Nune rea usira aindae, endada oro oro isambukena osa siruroro ningore! ");
INSERT INTO kpr_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Bajari dae yaru sise, sakai saore! Nune roera eveva gaveva nanjogo ututusira aindae, numokena yaruimi sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Namonde mo, nunda tofo ágido ivuga aore! Namonde maveju maveju numoa tumonde baingeraera, nundae ivugaghae vure jasedo ghaore! ");
INSERT INTO kpr_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Bajari kena yasivu, sonemba tambove! A kotugo, sifo ghousa numoa tumonde bainghuse irivu! ");
INSERT INTO kpr_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","God da saramana kato Abraham da imemisiri gamemisiri kena resena, ningivu! Kotugo nunda imendi Jacob da veka nune gategusira ava, eminge kotovo dae resena, ningivu! God da tano gi dudukugharigo, a kotugo nu nange Abraham ondi da gitofu ijujari dae sisira, ava kotevu! ");
INSERT INTO kpr_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Bajari mo, namonde God ri. Nunda Agho Dari mo, reighi isasambudae sisira. ");
INSERT INTO kpr_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Nu kotua gatise, rea ari sisira ava evovodae amingudo yarira. Nunda beka gajari mendeni isambu barago ghaeko evia inono evovodae nune use irarira. ");
INSERT INTO kpr_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Nune Abraham ghae kotua gatise rea setero fefetusira, kotugo nunda beka gajari Isaac kena sisira ábarago edo gharira. ");
INSERT INTO kpr_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Bajari Jacob ghae dabade sekago kotua gatise, emingari sisira, amo eviri: ");
INSERT INTO kpr_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","“Reighi Keinani (Canaan) ava nane mutono, ninda tofodae baresa.” sisira. ");
INSERT INTO kpr_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Sifo amo God da natofo reighi Keinani (Canaan) aminda mo, jo anjaga iraeri, ne esa embo amingo ava iriari. ");
INSERT INTO kpr_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Ne yabayaba ghuse, oro eninda reighida ghe ya reighi enikena ghedo ghuseri. Ne kotofu enikena buvudo, kotugo ya kotofu enikena buvudo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Avata, God jo doyari mave eniimi bouvu mema nemokena mutaeri. Ne kaifa use, nune kini (king) nanjogokena nange ghoghora sedo ghusira, amo eviri: ");
INSERT INTO kpr_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","“Nanda saramana kakato gategusena evia, erá deove! Kotugo nanda feroveta barago erá dereove!” God aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Avori Bajari setiri baimara ava reighi Keinani aminda sirorusira. Kotugo nenda bayau isambu nune saghimbe rurusira. ");
INSERT INTO kpr_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Nu amingusira, avata anakora nunda natofo gategusira ainda genembo eni Joseph, sabua are dae oriro usera ava, giti dirigetiri isira. ");
INSERT INTO kpr_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Nunda ata seni (chains) auri arimi bundiseri a kotugo nunda dubo auri eniimi bundiseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Aminge iriri, nune gimasa irise, rea osa sisira amo, beká sirorusira. Joseph geka beká vanembo sedo ghusira ava, geka Bajari numokena sisira, ai siroretiri gosuseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Sifo aminda, Egypt emboda kini (king) oro oro nanjogo kaifa edo ghusira aimi setiri, dibura do buvurutusira. ");
INSERT INTO kpr_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Etiri, kini setiri, Joseph Egypt da gavana a roera isambu reighi Egypt aminda ainda bajari edo irei. ");
INSERT INTO kpr_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Kini amingusira amo, nune setiri gavana da babojegari a kini da dengoro indari kakato barago, Joseph da sari ningari edo irero, nunda geka da amboda amboda aoro dae sisira. ");
INSERT INTO kpr_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Aminge fetetiri, Joseph numamo Jacob ningi eredo, núbarago ira, Noah da mandi Ham da imemesiri jokáda Egypt aminda buvudo, esa embo da kaugo ava edo irá ghedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Bajari setiri, Jacob da imemesiri digarigo siroruseri. Amingusera aindae, nenda fakina aimi gitofuda fakina ava do darigusira. ");
INSERT INTO kpr_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Nune etiri, Egypt emboimi natofo Israel embo ava imboe gamboe useri. Aminguse, Israel embo deredo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Amingero, nunda saramana kato Moses diriguse God Moses da koro Aaron barago, gategedo dirigetiri nengae jovereghe Egypt iseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Nene God da tano gi dudukughari ava ututeoro gido ghuseri, a tano gae gitida ava reighi Egypt aminda ututedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","God setiri reighi aminda tumba jinjanghusira, avata, Egypt embo nunda geka jo ningae useri. ");
INSERT INTO kpr_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Nune setiri, nenda uvu isambu ororo jinetiri, oka mane isasambu amomonjeguseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Nenda reighi tomanako isambu gerakuimi bedo usira. Amingiri, kini da nati barago nemo vanembo usira. ");
INSERT INTO kpr_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","A kotugo God setiri, soinimi a jejeraimi funghuse reighi tomanako nemo vanembo useri. ");
INSERT INTO kpr_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Nune borija beká bureguse setiri, borija dombu eni yaughari kau ghamana da kaugo aimi diríri, biria tarighusira. ");
INSERT INTO kpr_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Nune sosighi use, nenda vaini da asi a ika figi seraera isambu de bunununghetiri vovoseguseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Nune furore dae aghi etiri, sisi mane, jo tegari da kaugo irae aimi fera buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Nene ika igi mane reighi jokáda isasambu mindi tefo useri. Vareda bayau barago isambu mindi tefo useri. ");
INSERT INTO kpr_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Ainda amboda God Egypt embo da vide jamena bebego detiri sirivo useri. Aminguse nu Egypt embo da fakina da susu ava de tisisira. ");
INSERT INTO kpr_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Amingetiri, Israel embo era, Egypt embokena nenda guri sosighi use, ruruseri. Bero, God ne unumbetiri, Egypt do buvurutuseri. Ne tamo kae gego, fakinaghae buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Egypt embo nendae oju usera aindae, Israel embo ne do darigetero, dubo jama beká useri. ");
INSERT INTO kpr_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","God forogaimi nunda natofodae sasoro dadudurureari, tumbaghae usasa mutare dae sedo, avaraka mutudo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Ne benunu setero, rika ribo da kaugo avavago futusira, kotugo roera farava da kaugo utuda ghe muteari bu mindido ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Nune ghamana afigetiri, uvu jojojoghe vovosusira ava, reighi uvu a evetu genembo irae vasada uvu teria eni sumbari gusira. ");
INSERT INTO kpr_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Ainda beká mo, nunda saramana kato Abraham kena rea ari dae sise beka gagojusira ava kotise, amingusira. ");
INSERT INTO kpr_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Aindae sedo, nunda natofo gategusira ava nune unumbiri, ne yaru sise, ivugaghae fumbu aruguse reighi Egypt dodo buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","45","Avori, nunda natofo nange nunda Agho Dari kotugo nu rea aoro dae sisira, kaifa aetera ava kotise, nune oro mendeni da enda bu mutiri nene ruruseri. A kotugo, nenda vareghae daba ghabuda bariseri. Bajari dae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Bajari da javo jighoro erare! Erorurari, nunda dubo bari gombu tefo, nu eveva vanembo eraira aindae numokena aiyakoe sevu! ");
INSERT INTO kpr_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Mave eni jo Bajari roera babaigo eraira isasambu tege tefo use, osa sari da kaugo iraeri. Mave nundae sakai sari saetira amo, jo nunda ari eveva eraira, ainghae inono ae aetira. ");
INSERT INTO kpr_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Evetu genembo mave nunda uju ava use, evovodae ari eveva gaveva use irá gheraera amo, ivugaghae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Arie Bajari, ni sifo reda ninda natofo sonembaresa amo, nábarago kotaetesi! Sifo reda sonembururaso jebuga tambarera, nábarago kotaso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Ninda natofo gategusesa ava, nanjigo saso ati ghayafade arera amo, saso, ne redae ivuga arera, na ainda jokáda irarena. Aminguse, ninda natofode dabade tatedo, nindae sakai sise irarera. ");
INSERT INTO kpr_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Afa, abua mane ari ekoko usera aminga ava, namane barago kotari ekoko kotise, ari ekoko edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Namanenda avia abua Egypt aminda ninda tano gi dudukugharigo ututusesa ava, ne jo kote simbugae useri. Umbu nanjogo nemokena kavevera edo ghusesa, ava ne kotae edo ghuseri. Arie God, Fakina Tofo, ne amingedo, eva kokoigo aminda osogo nimokena bu fuseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Avata, nunda fakina tomanakogo ava ijugari gaoro dae sise, nu rea ari dae sedo, beka gagojusira ava use setiri, ne jejebuguseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Nune dombuda sise setiri, Eva Kokoigo saghedo kainghusira. Etiri, nunda natofo unumbedo bu enda kaingharida sefuseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Nune, evetu genembo ne gari imboe edo ghusera aikena sonembetiri, ne jebuguseri. Nenda gitofukena ne sainghimbe bu darigusira. ");
INSERT INTO kpr_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","O nenda gitofu mo, uvuimi fatiri mindi sirivuseri, eniko jo fetaeri. ");
INSERT INTO kpr_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Amingetiri, nunda beka gajari isambu ava nunda natofo tumonduseri. Edo, yaru didivuse, nundae sakai siseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Avata, nu nendae sedo rea usira ava ne totoi nembo kotae useri. Amingedo nenda uju use, God da kotari ningari dae sedo jo kaifa aeri. ");
INSERT INTO kpr_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Reighi uvu a evetu genembo irae da vasa aminda ne masaru useri. Aminguse, ne God ava bu derarikena fifituseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Amingusera aindae, ne rejodae uju usera ava nune futusira. Avata, ainghae dabade tauno eko ava setiri nenda jokáda itatama useri. ");
INSERT INTO kpr_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Aminda evetu genembo uvu bayau irae vasada ne Moses dae mendó mendó useri, kotugo genembo God gategusira, Aaron dae barago, mendó mendó useri. ");
INSERT INTO kpr_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Amingero, enda beka fangedo, osogo ari kakato da giti jighari, Dathan dukughedo, a kotugo, nenda giti jighari eni, javo Abiram, nunda ambo jimbide dabade dukughusira. ");
INSERT INTO kpr_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Amingiri, avarakai vosefira, evetu genembo mendeni nengae da geka ningido ari ekoá usera ainda etoda, vose dungetiri aviseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Nene doriri Sainai aminda goldi (gold) budo, ove kevuse, borumakava mandi da kaugo ava edo, tumonde bainghedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Ne God duro usasaghae ava ighagha use, borumakava kikisa mindiraira ainda dangio ava budo tumonde bainghedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","22","Aminguse, God Noah da mandi Ham da imemesiri jokáda Egypt aminda, nunda tano fakinagoimi sonembetiri jejebugusera ava, ne kotae useri. Amo roera gi dudukugharigo Egypt aminda a kotugo eva kokoigo aminda usira, aindae resena. ");
INSERT INTO kpr_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","God ava gido, janje eko edo nunda natofo sosighi ari dae sisira amo, beká siroraetira. Avata God nunda saramana kato, javo Moses, gategusira aimi eredo, erá natofo ambeure dae sise, nu God buregusira. ");
INSERT INTO kpr_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Ainda amboda, ne reighi uvu bayau da vasa nemokena mutaetira ava, imboe useri. Ainda susu mo, ne God da beka gajari ava jo tumondaeri. ");
INSERT INTO kpr_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Aminguse, nenda dobo jokáda iritirise, Bajari dae isi basi sise, ningi ningaego useri. ");
INSERT INTO kpr_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Aindae sedo, nu koveonoghae eminge sisira, “Ne na uvu a evetu genembo irae vasa eminda saono, sirivu ututareva. ");
INSERT INTO kpr_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Nenda imendi gamendi barago, na nenda gitofu, na jo tumonde bainghae eraera, ainda jokáda goroghaono ya, oro mendenida reighi aminda sirivu ututarera.” ");
INSERT INTO kpr_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Amboda, reighi Peor aminda God nunda natofo Israel embo god eni Baal seraera, ainda tumodari embode tatedo, Baal tumonde bainghuse, ove kevari jebuga tefo, ainda dombuda bayau joba dungutusera, ava bu riseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Amingetero, Bajari da janje ekoko ava nenda aito fugutusera aimi etiri, tauno eko beká nenda jokáda bejetiri sirivo useri. ");
INSERT INTO kpr_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Avata, Aaron da mandi Phinehas ere fetedo, ari eko gagara mandighae amo gaetiri ambududurusera aindae, tauno eko amo tukughusira. ");
INSERT INTO kpr_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Avori, nune amingetiri gido, God nundae “ni eveva” sisira. Aminge sisira ainda binó ava, ai tano ghedo refira, kotugo evovodae ivigedo yarira. ");
INSERT INTO kpr_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Uvu ghoghoro Meriba aminda evetu genembo isi basi setero Bajari janje ekoko usira aindae, Moses barago dara tafusira. ");
INSERT INTO kpr_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Ne rea usera aindae, Moses janje eko beká etiri, ghoghora sisira amo, jo itako durumugedo kotise saeri. ");
INSERT INTO kpr_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Ainda amboda, Bajari oro mendeni daoro amboro dae sisira, ava ne jo ae irise, ");
INSERT INTO kpr_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","oro resena ainde dabade minode minode fifituse teana embo da tumondari eko, kotugo kiki eko ainda amboda amboda edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Aminguse, God da natofo ove kevari dombu eni dombu eni ava tumonde bainghedo ghusera aindae, ne God da bouvu ava itatama e sirivo useri. ");
INSERT INTO kpr_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Ne totofo nenda sasingu veveyako ade vide ava jebuga irioro, Keinani embo da ove kevari da dombuda joba dungoro dae mutudo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Nenda sasingu dara iritiraede ava Keinani da ove kevusera aindae joba futuseri. Amingero, enda bebeta usira. ");
INSERT INTO kpr_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Ne aminguse totofo bebeta useri. Ne aminguse God nusuka numoa tumonde bainghoro dae sisira ava, gukai futuseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Amingetero, Bajari nunda natofo Israel embokena janje ekoko use, nemoa gari beghagha beká usira. ");
INSERT INTO kpr_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Nu do darigetiri, oro mendeni ove kevari dombu eini dombu eni tumonde bainghedo ghusera, aimi sero nenda sari ningari use iritiriari a kotugo, nenda gitofu mendeniimi ne katiyavara use kaifa edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Gitofuimi nemoa kateyavara urureoro, nendae bouvu mema tambudo ghuseri. Gitofuda sarida nembo iritirise, nenda sari ava use iriá ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Sifo nanjogo Bajari nune sonembeari, dara darigedo ghuseri. Avata nene geredo osogo numokena bu fuse ari ekoda tofo edo iriari. ");
INSERT INTO kpr_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Avata sifo reda numokena koko fuge sorara usera amo, Bajari niningusira. A kotugo, ne nanjigo mema bouvu fufuse, kori sisera, nu kasama usira. ");
INSERT INTO kpr_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Nemoa kotise nu beka gagojuse rea ari sisira ava kotisira. Ne dubo bu gogoghomberaira aindae, nu joka usira. ");
INSERT INTO kpr_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Nune setiri, teana embo nunda natofo Israel embo sandido katiyavara edo ghusera, aimi tuturo edo nendae joka useri. ");
INSERT INTO kpr_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Arie Bajari God, namane sonembe jebugaore! Ninda javo kakara jighoro erare dae sise, namane ningiaminda gorogheteso oro mendenida jokáda irera, amindaghe namane ava bu jovereghe fu! ");
INSERT INTO kpr_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Namonde Israel embo da Bajari God dae sakai saore! Sakai saore nundae oroko a kotugo evovodae. Evetu genembo isambu sevu, “Ai bekári”. Sakai saore, Bajari dae! ");
INSERT INTO kpr_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Bajari da dubo bari gombu tefo, nu eveva vanembo eraira aindae, numokena aiyakoe sevu! ");
INSERT INTO kpr_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","3","Mave Bajari sonembetiri jebuguseva, ne isambu geka setena ava sise, nundae sakai sevu! Ne teana embo da reighida irevo, ne nune gitofu kena saghimbe budo, utu gambari, utu gambaridaghe jovereghe fusira. ");
INSERT INTO kpr_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Mendeni reighi uvu a evetu genembo irae vasada baghimbedo yabayaba ghuse, reighi bogu begaya aminda ya anumbari emboro bunedo iritiriari. ");
INSERT INTO kpr_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Ne uvu bayaudae baimarai sirivo use, ambari dae ghosuguseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Aminguse, ne dara jokáda irise, Bajari nemo sonembare dae sorara etero, nenda bouvu nune itimbetiri jebuguseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Nune giti biri, reighi bogu begayada ningia aminda dighi anumbaetera, ava kasama edo, emboro dambu aminda iseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Arie, ne nunda dubo bari a kavevera teriago a tano gi dudukugharigo nendae ututusira aindae, aiyakoe saovo dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Ai resira amo, mave uvu bayaudae baimara itatameraera aikena, uvu bayau nune muturaira. ");
INSERT INTO kpr_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Mendeni seni (chains) auri arimi bundetero dibura use vasa tumba jinjanghari beká aminda iritiriari. ");
INSERT INTO kpr_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Ainda susu mo, ne God Iká bekáda irira, ainda Agho Dari ava ighagha use, nu rea aoro dae sisira ava, gungubo sariá sise, jo ae edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Susu aindae, nemokena saramana teria futo futiri, janjagu use janje gajedo ghusira. Ne du fafasedo ghusera, mave jo sonembae edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Sifo aminda, ne dara jokáda irise, Bajari nemo sonembare dae sorara etero, nenda bouvu nune itimbetiri jebuguseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Ne vasa tumba jinjanghari jokáda irero, ne nune unumbe bu buvudo, seni auri aimi bundisera ava, nune detiri bunununghe vovosusira. ");
INSERT INTO kpr_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Arie ne, Bajari da dubo bari a kavevera teriago a tano gi dudukugharigo nendae ututusira, aindae aiyakoe saoro dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Ainda susu mo, gitofoda furu da guro babai auri bronsi (bronze) ari ava nune de bununugheari voseraira. A kotugo, kamboda boraga auri ari barago, nune dive gafeari voseraira. ");
INSERT INTO kpr_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Evetu genembo mendeni geka ningi ningaego use ari ekoko edo ghusera aimi daghari gogovara edo, ne rea edo ghusera aindae, mema bouvu itatama use iria ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Ne oka, uvu bayau gari beghagha use, ambari dae ghosuguseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Aminguse, ne dara jokáda irise, Bajari nemo sonembare dae sorara etero, nenda bouvu nune itimbetiri jebuguseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Ne ambaetera, avata geka nune sisira aimi sonembetiri jo ambae useri. ");
INSERT INTO kpr_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Arie ne, nunda dubo bari a kavevera teriago a tano gi dudukugharigo nendae ututusira, aindae aiyakoe saoro dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Ne nundae aiyakoe sise, joba futuse, yaru sise, nu rea usira aindae, divu fusedo ghaovo dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Mendeni ghasemoda vovosegedo evada, ghamana bari dae use, ya foa ghuse gugua oriro use eva teriada deinghedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Ne Bajari evada rea edo ghusira, a nunda tano gi dudukugharigo edo ghusira, isambu gi tefo useri. ");
INSERT INTO kpr_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Nune seari yaura vovoga fakinago usumbeari, karaje dereari eva babai eredo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Ghasemo babai bu fugeari ikáda viti ya, evada tifughe vosedo, viti foa kounghedo ghusira. Amingiri, bouti da saramana kakato oju use beka dadabuseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Ne uvu sembae mindi jiro birurughari kavakava ariguse teteteghe ya foa ghuseri. Nenda kasama kau mavega isambu beká irae usira. ");
INSERT INTO kpr_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Aminguse, ne dara jokáda irise, Bajari nemo sonembare dae sorara etero, nenda bouvu nune itimbetiri jebuguseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Eva yaura vovoga nune setiri, songhedo binono gafugusira. ");
INSERT INTO kpr_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Binono etiri, ne dubo jama ero, fafo reda ya terari dae uju usera aminda, ne nune unumbetiri jebuga era, aminda tere dadoruseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Arie ne, nunda dubo bari a kavevera teriago a tano gi dudukugharigo nendae ututusira, aindae aiyakoe saoro dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Natofo tafaroro ari totorugarera ainda jokáda fetedo, nunda javo jighoro eredo ghaetira. Kotugo babojegari totorugarera ainda jokáda barago, nundae sakai saoro dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Bajari etiri, uvu mane gasumbedo, kareva da uvu kainghedo, kainghari beká usira. ");
INSERT INTO kpr_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Evetu genembo aminda iritirise, ari ekoko edo ghusera aindae, nune etiri, enda karevaghae ava jovereghe enda karajemi bebeta usira avaga edo irei. ");
INSERT INTO kpr_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Nune etiri, reighi uvu a evetu genembo irae vasada uvu gaunghuse, enda kainghari aminda uvu kirikara ghuse tuturo edo sufusira. ");
INSERT INTO kpr_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Nune evetu genembo baimarai sirivo ari dae usera ava, bu vasa aminda dighi anumbaoro dae sedo, bu fitiri, nene bogu begaya dighido anumbuseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Nene je govedo ghuse, bayau goveoro beká digarigo jigheari bu mindido ghuseri. Nene enda je govedo vaini (wine) da asi govetero vuji digarigo jighi vosetiri bariseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Nunda natofo nune esimbugetiri, ne ghagurugo sirorero, nune setiri, fuka borumakava mane digituseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","God da natofo nenda gitofuimi fera ne de atai fati fefetuse, sino fuka dae ari guse katiyavara ero, mema tambudo jarutusera da sifoda, ");
INSERT INTO kpr_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","God katiyavara ari kakato yarata aikena nunda janje ekoko ava averegetiri, savavara uvu bayau irae vasada yabayaba ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","O makasi embo dae kavenu sise, nenda bouvu nune itimbetiri jebuguseri. Ainghae dabade, nune setiri nenda mandi sasingu digarigo siroruseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Avavaga sirorusira amo, evetu genembo eveva irá gheraera ava gosuse ivuga useri, o ari ekoko embo ava gido ne beka dadabuseri. ");
INSERT INTO kpr_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Mave dubo kotaride irá gheraera amo, na geka setena emo kotise irarera. Bajari da dubo bari a kavevera teriago ava kotise iroro dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Arie God, nanda tumondari nimokena jo nanjigo dadabae arira. Nanda dubo isambuimi nindae sakai sise, yaru divarena. ");
INSERT INTO kpr_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Arie, nanda gita yukaghae erevu! Sifo nane karigaone! ");
INSERT INTO kpr_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Arie Bajari, na reighi isasambu da oro mendeni mendeni jokáda fetirise, nindae sakai sarena. Na reighi isasambu da oro mendeni mendeni aikena nindae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Ai resira amo, ninda dubo bari a kavevera amo, teriago bekári, utu viti darigedo irira. Ninda beka gajari namanekena isambu kaifa eraesa, aimi aira utu tambudo irira. ");
INSERT INTO kpr_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Arie God, utuda ninda javo jighi erorurari, enda evia ninda duro aimi afurugedo ijuge, gaore! Arie God, utuda ninda fakina a duró ava ijugururu! ");
INSERT INTO kpr_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Ninda natofo dubo buraesa ava ninda fakinaimi sonembe! Namanenda benunu ningido, ninda fakinaimi namane gitofukena saghimbe bu darigaso jebugari dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","God nunda tafaroro kambo kakarago aminda irise sisira, “Reighi Sekem nane sosighi e budo, tano ghoredo, nanda natofokena soro vesa arena. Enda uvu ghajughu tevisa Sukot seraera, ábarago nane sosighi e budo, tano ghoredo, soro vesa arena. ");
INSERT INTO kpr_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Gilead frovensi mo, nandari, a kotugo Oro Manasseh ningiaminda anumbirera, ábarago nanda tofori. Ephraim ondi mo, nanda jiro gagara ari kato da kaugori, kotugo Judah ondi mo, nane kotofu edo irena da tanogori. ");
INSERT INTO kpr_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","O Moab mo, nanda uvu dimbu gutari agha dae ererurena. A kotugo Edom aminda nanda ata anoso goroghari da vasari. Ata anoso goroghusena amo, nanda yoyovari, aimi imbara ururono irarira. Filistia embo da enda sosighi e ruruse, na sosighi e bari da kuvai koko fuge resena.” ");
INSERT INTO kpr_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Arie God, na mave giti bari ya reighi karo kinghari ominda terareni? Nanda giti mave bari Edom yareni? ");
INSERT INTO kpr_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Bajari, ni namane imboe fugutusesi, aĩ? Ni namanenda isoro embo unumbedo ya tataya aresa, aĩ? ");
INSERT INTO kpr_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Arie, sonembaso isoro ari dae resena, ai resira amo, endada evetu genembokena sonemba bari eni tefori. ");
INSERT INTO kpr_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Sonemba God kena ruruse, isoro arera inono arira. Namondeda gitofu nune de atai duboda fatarira. ");
INSERT INTO kpr_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Arie God, na sakai nindae seraena. Erá beka gote tauntaungheose! ");
INSERT INTO kpr_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Ai resira amo, ari ekoko embo, nandae osogo use, geka gungubo nanda javoda sesegerera. ");
INSERT INTO kpr_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Nandae jijivu ekoko beká resuterera. Na eko eni jo ae ava, susu tefo resera. ");
INSERT INTO kpr_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Na ne dubo ruruse, nemoá sonembaso dae banungedo ghuseni. Avata, na gofono dae sise, unongu seraera. ");
INSERT INTO kpr_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Na ne dubo ruruse, nendae ari eveva beká urureono, ne mino namoá imboe use, namokena ari ekoko beká ava eraera. ");
INSERT INTO kpr_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Genembo eko eni gatege, nundae aji sare! Unongu sari kato eni dirigaoro ya, numoa kotoda fitare! ");
INSERT INTO kpr_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Koto sifoda nu gofaetira. Nunda benunu seraira barago, ijujari katoimi gungubo sariá sise, sari gofarira. ");
INSERT INTO kpr_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Genembo amo oroko nembo ambaeti! Nunda saramana da vasa ava, genembo eniimi baeti! ");
INSERT INTO kpr_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Nu ambari, nunda sasingu babate aoro, noaro rori baetira. ");
INSERT INTO kpr_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Nunda sasingu nati do bayaudae benunu sise deinghaore! Evetu genembo mendenimi ne ondoro, numamo da kambo bunununghari ava do darigaore! ");
INSERT INTO kpr_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Nu mavekena moni benunu se bambudo, jo mutae usira aimi, numoa koto use nunda gugua soesa baeti! Teana emboimi nunda gugua ghayafa korai use budo irira ava, soesa barera. ");
INSERT INTO kpr_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Nundae mave enimi jo joka ae aetira. Kotugo mave enimi nunda sasingu babatedae kavevera itako jo ae aetira. ");
INSERT INTO kpr_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Nunda sasingu amboro dae resena. Amingaoro, nunda oro manje tefo aeti. ");
INSERT INTO kpr_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Numamo nombua mane da ari ekoko usera, kotugo noi da ari eko ava, erá Bajari kote doyeure dae sise resena, evovodae kotise irare! ");
INSERT INTO kpr_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Genembo ainda natofo da ari ekoko ava Bajari sifo ghousa kotise, ne dari amboro, nenda binó barago ya dadabaeti. ");
INSERT INTO kpr_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Ai resira amo, genembo amo nu evetu genembo mendeni dae joka ari berefori, evetu genembo tofo irae embo ava, evetu genembo gugua roera dae jarutuse irera ava, nemokena mema bouvu futuse detiri sirivuseri. ");
INSERT INTO kpr_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Giti nu evetu genembo mendeni girivaita ari ava uju beká edo ghusira, avori, nunda girivaita ari aimi tofo numoa bare. Nu esimbugari da emboro imboe usira, ágido numokena esimbugari eni erá siroreure! ");
INSERT INTO kpr_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Nu evetu genembo mendeni girivaita ari ava nembo use irei, eveva mo uvá gae baseari, fisi yaya eraira aminga ava, nunda girivaita aimi tofo nunda tamonda gambare! ");
INSERT INTO kpr_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Kotugo, nunda girivaita aimi tofo numokena asuge, kikifu edo evovodae irare! ");
INSERT INTO kpr_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Bajari, nanda gitofu namokena osogo use, jijivu seraera, ainda beká ava jovereghe nemokena ururaso, ghamo baore dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Arie Bajari God, ni nange sonembari beka gagojusesa ava use, na sonembe! Ni na dubo bu goghombuse, kavevera eraesa aindae, na sonembaso jebugari dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Na tofo iraede kotugo makasi bekári, nanda janje joka mema ai jaruterena. ");
INSERT INTO kpr_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Kau ungobu use, reighi tutumbe geraira, na amingari gerena. Kau sisi ambari yaurai fuseari ya gheraira, amingari gerena. ");
INSERT INTO kpr_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Uvu bayau tefo etiri, na kaubo roroghoterira, na kau irae, gevei etu yavarara geteni. ");
INSERT INTO kpr_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Evetu genembo na sifo reda garera, namoa dere jise, nandae gifua gitorotoro use, gegha jiraera. ");
INSERT INTO kpr_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Arie Bajari God, na dubo buraesa aindae, na sonembaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Arie Bajari, nisuka nine na sonembedo, sanghimbeoso jebugeraena ava ijugaso, nandae osogo ari kakato kasama aore! ");
INSERT INTO kpr_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Ne namoa girivaita arera amo, namoa esimbugaresa. Evetu genembo namokena ari eko arera ava, sosighi aso itatama arera. Amingururaso, ninda saramana kato, dubo jama arira. ");
INSERT INTO kpr_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Mave namokena gitofu eraera ava aso, meka gaeteri. Mekavata meka garera. ");
INSERT INTO kpr_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","O namo, taká koko fuge Bajari kena aiyakoe sise, nundae sakai sarena, nunda natofo tafaroro ari dae totorugarera ainda jokáda fete, nunda javo jighono erarira. ");
INSERT INTO kpr_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Ainda susu mo, tofo irae embo ava nune soreraira, kotugo mave gitofuimi daoro amboro dae seraera ava, nune sanghimbe beari jebugeraera. ");
INSERT INTO kpr_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Bajari nu nanda bajari aikena sisira, “Fu, nanda ungu gimanduda anumbiraso, ninda gitofu ninda fakina ava gosururoro ne de bundedo bu foama, ninda ata duruda fitono fafasaore!” ");
INSERT INTO kpr_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Bajari nune ari, ninda kini (king) edo reighi kaifa eraesa ava tuturo edo, Saion eminda ghe beraraghe ya foa ghururari, ninda gitofuda kini barago nine edo ne kaifa aresa. ");
INSERT INTO kpr_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Ninda gitofude isoro aresa ainda sifoda, ninda natofo nenda ujuda foa ninda ambo gayarera. Kau sifoda mungo rurugheraira, aminga ava ninda gigimasa seka bajari ninda ambo gayari dae, Doriri Kakara aminda nimo sonembari dae fufuregarera. ");
INSERT INTO kpr_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Bajari, beka gagojuse kotua gatisira, ava sedo nu jo ighagha ae arira. “Ni kau Melchizedek avavaga fristi edo, evovodae amingedo iraresa.” ");
INSERT INTO kpr_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Bajari mo, ninda ungo gimandukenari. Amboda nunda janje ekoko arira ainda sifoda, nu kini (king) nanjogo dedo duboda fatarira. ");
INSERT INTO kpr_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Nune oro mendeni ava, ambu dadabaore dae use, de goroghari isoro vasa ganjimbe fafasarera, endada kokotofu nune dedo atai duboda fafategarira. ");
INSERT INTO kpr_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Kini (king) emboro tinguda kareva da uvu ava rise, aimi fakina arira. Nunda gitofu isambu dedo duboda atai fafategarira. ");
INSERT INTO kpr_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Bajari dae sakai saore! Nunda natofo tafaroro ari totorugarera ainda jokada teredo, nanda janje joká isambuimi Bajari dae aiyakoe sarena. ");
INSERT INTO kpr_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Bajari da ari ava roera garigarigo ava ututeraira! Maveju maveju nu uju eraera, aimi nunda ari ovia kotise irágheraera. ");
INSERT INTO kpr_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Nunda ari rea ututeraira ava isambu bino ghaeri, kotofu da ari ava nembo eraira, nunda irari dambugo beká ava jo nanjigo tano ae arira. ");
INSERT INTO kpr_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Bajari da ari garigarigo eraira ava, kotoro dae eraira. Kavevera a joka ari kato, numori. ");
INSERT INTO kpr_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Evetu genembo mave nu kakara eraera, ainda uvu bayau nune muturaira. Nu nunda kotua gatari ava jo sifo nanjigo kote doyae arira. ");
INSERT INTO kpr_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Nunda fakina ava nunda natofo kena ijuguse, teana embo da enda ghabuda bambu nendae futusira. ");
INSERT INTO kpr_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Nu rea ari dae sisira ava, bekáda bekáda use irágheraira. Nunda natofo rea aoro dae sise, nenda fakina mavega ava, kote simbugedo sisira. ");
INSERT INTO kpr_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Namonde rea aoro dae sisira amo, nu ari dambugo use geka bekáda bekáda sisira. Kotugo geka sisira amo, evovodae irarira, tano tefori. ");
INSERT INTO kpr_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Nu nunda natofo vujegetiri, jebuga irera. Nemokena beka gajari rea usira ava, evovodae irarira, tano tefori. Kakarago, a fakina kato amo, numori! ");
INSERT INTO kpr_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Dubo kotari bari da emboro amo, Bajari kakara use nundae igheghi aresa. Evetu genembo mave nunda sari ava kaifa use, irágheraera aikena, nune kotari eveva muteari buraera. Evovodae numokena sakai sise irarera! ");
INSERT INTO kpr_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Bajari dae sakai saore! Evetu genembo mave Bajari kakara use, nunda sari ava ari dae mamasa use irá gheraera amo, ivuga ghae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Genembo eveva einda mandi sasingu reighi Israel aminda susu iti fafode edo kokotofu nene arera. Aminguse, nunda imemesiri gamemesiri aikena esimbugari sirorari barera. ");
INSERT INTO kpr_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Nunda ghaguru aikena moni guguade nene arera, nemokena evovodae digutuse irarira. ");
INSERT INTO kpr_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Gegenembo eveva gaveva emingori, joka ari kakato, kavevera ari kakato, a kotugo ari dambugo use irá gheraera aikena, tumba jinjanghari ainda jokada usasa janimberaira. ");
INSERT INTO kpr_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Evetu genembo mave komana da benunu ningido totoi sonemberaera, kotugo mave nenda bisinisi bekáda bekáda use komana jo derae eraera amo, ne ivugaghae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Eveva evetu genembo itako jo gofae arera, nenda binó jo nanjigo dadabae arira. ");
INSERT INTO kpr_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Mema bouvu da binó aindae jo oju ae eraera, ne tumonde gogoghombuse nenda kotari isambu Bajari kena fifituse irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Ne janje jo bunedo kotari futo ae eraera, a oju jo ae eraera. God nenda gitofu de sosighi ari garera. ");
INSERT INTO kpr_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Ne babate embokena ivugaghae soro use, jo daghae eraera. Ne genembo kotofuko binoderi. Ne kakara ururoro irá gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Evetu genembo setena ava, natofo ekoko aimi gido janje ekoko arera, ne imboe gamboe use, dika gambu ghininji ghananja gharera, avata ne manje tefo arera. Ne rejodae gigitusera, ainda beká eni jo sorarari baeri. ");
INSERT INTO kpr_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Bajari dae sakai saore! Ne Bajari da saramana eraeva, emboimi nunda javo jighivu, erare! ");
INSERT INTO kpr_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Namonde isambu oroko a evovodae Bajari da javo jighoro erare! ");
INSERT INTO kpr_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Iji vitari kena kotugo iji vosari kena Bajari da javo jighivu erare! ");
INSERT INTO kpr_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Bajari nune endada oro oro isambu kaifa eraira. Nunda duro aimi utu da roera isasambu darigedo iká bekáda irira. ");
INSERT INTO kpr_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Evetu genembo eni Bajari namonde tumonde baingheraera, ainda kaugo tefori. Nu ika bekáda irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Avata nu ukuge, utu enda giraira. ");
INSERT INTO kpr_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Makasi embo beká sena vasada iritirá gheraera ava nune jigheari ereraera. Irari dae jarutuse irá gheraera, rejodae mema eraera ava, nune futuse, ne jigheari ereraera. ");
INSERT INTO kpr_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Aminguse, evetu genembo ava nune sonembeari ne vitido, nenda natofoda kokotofude umo gaumo edo gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Nune seari, evevetu erova mandi sasingu fufuse, dubo jama edo ivugaghae nenda ofo kamboda irá gheraera. Bajari dae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Jacob da imemisiri gamemisiri Israel embo oro eni geka dombu eni tinongu tanongu seraera, ainda reighi Egypt iriara ava dodo isera da sifo aminda, ");
INSERT INTO kpr_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Judah ondi God da natofo kakarago useri. Israel embo tofo nunda natofo bekádae rurusira. ");
INSERT INTO kpr_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","God isagha etiri, Eva Kokoigo gido gasumbusira, kotugo Jordan uvu tukughe fefetusira. ");
INSERT INTO kpr_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Doriri gouti vurari guseri, kotugo enda jiro fumbari ne kau sifi kandana ai jorujoru ghari guseri. ");
INSERT INTO kpr_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Arie, Eva, roi nangetiri, ni gasimbusesi? Arie, Jordan, nímbarago, ni redae sumbari tukughusesi? ");
INSERT INTO kpr_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Arie, Doriri, ne redae gouti vurari gusevu? Arie, Enda Jiro Fumbari mane, ne redae sifi kandana aimi jorujoru gharigusevu? ");
INSERT INTO kpr_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","8","Arie, Enda, Bajari God Jacob tumonde bainghedo ghusira, aimi etiri ghamana uvu jinendo, nunda bogu bogu usira, a kotugo ganasa sarigedo uvu jojoghusira, nune furarira ainda sifoda nundae ojuimi daradara ghaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Arie Bajari, ninda beka gajari nanjogo eteso fefetusira, kotugo namanedae ghamo buraesa aindae, namane nisuka nimoa kakara use ninda javo jighoro erarira. Jo evetu genembo eni kakara ae arera. ");
INSERT INTO kpr_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Redae oro mendeni namanekena ategi emingeraeri? “God nene tumonde baingheraeva amo reda iri?” ");
INSERT INTO kpr_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Namondeda God mo utuda irira. Nu rea uju eraira, amo ava eraira. ");
INSERT INTO kpr_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","O evetu genembo mendeni da god mane beká iritiraeri, siliva (silver) kotugo goldi (gold) imi ariri, evetu genemboimi tefo ghabuimi ututuseri. ");
INSERT INTO kpr_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Ne beka ghaeri, avata beka jo sae eraera, ne diti ghaeri, avata ditii jo gae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Ne dengoro ghaeri, avata jo ningae eraera, ne mendo ghaeri, avata masa jo fumbae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Ne ungo ghaeri, avata jo sire bae eraera, ne ata ghaeri, avata jo fete ya foa ghae eraera, ne ghoreghore duka tefori. ");
INSERT INTO kpr_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Ove mave kevarira, kotugo mave nenda tumondari aminda fitarira amo, nenda ove mane da kakaugo aoro dae sise resena. ");
INSERT INTO kpr_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Arie, natofo Israel embo, nenda tumondari Bajari kena fitivu! Ne nune sonembuse, gagara eraira. ");
INSERT INTO kpr_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Arie, God da fristi mane, nenda tumondari Bajari kena fitivu! Ne nune sonembuse, gagara eraira. ");
INSERT INTO kpr_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Arie, ne mave Bajari dae igheghi use, numoa tumonde baingheraeva, nemokena resena. Nenda tumondari Bajari kena fitivu! Ne nune sonembuse, gagara eraira. ");
INSERT INTO kpr_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Bajari nune namonde kotise esimbugarira. Namonde Israel embo a God da fristi mane dabade isambu nune esimbugarira. ");
INSERT INTO kpr_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Evetu genembo isasambu numoa kakara eraera ava, binode kotugo bino iraede dabade nune esimbugarira. ");
INSERT INTO kpr_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Na uju erena Bajari nemokena mandi sasingu digarigo nemokena, kotugo nenda imemisiri gamemisiri amboda sirorarera aikena mutaeti. ");
INSERT INTO kpr_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Na uju erena, Bajari utu a enda usira aimi ne esimbugaeti! ");
INSERT INTO kpr_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Utu mo, Bajari nusuka nunda reighiri. O enda mo, namonde evetu genembo kena futusira. ");
INSERT INTO kpr_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Evetu genembo amomonjegedo, ambari embo da vasada vosedo irera amo, ne Bajari dae sakai jo sae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","O namonde jebuga emboimi numokena aiyakoe sarera, oroko a evovodae! Bajari dae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Bajari nanda kori ningiraira aindae, na nu dubo buraena. Beká resena, na benunu sirureono ningiraira. ");
INSERT INTO kpr_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Na kori seraena ningiraira. Ava sedo, na sifo ghousa jo ambae iris e, numokena banungedo gharena. ");
INSERT INTO kpr_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Ambari na asimi ivasi arigusira. Na rekato ambono furugarera kotise, ghamo takegha etiri, oju beka use, kotari futo useni. ");
INSERT INTO kpr_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Aindae sedo na Bajari kena kori sise eminge siseni, “Arie Bajari, benunu resena. Namoa ambari kena sainghimbe baso jebugaeteni.” ");
INSERT INTO kpr_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Bajari mo joka ari kato, ari dambugo beká eraira. Kavevera kato beká God numori. ");
INSERT INTO kpr_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Bajari evetu genembo sasinguko da tumondari avaga tofo mandi gagara eraira. Giti evetu genembo na sosighi ari dae etero, nune na sainghimbe biri jebuguseni. ");
INSERT INTO kpr_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Arie namoako, dubo jama ase, ainda susu mo, Bajari nandae eveva usira. ");
INSERT INTO kpr_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Arie Bajari, ambaetena ava, na saghimbe beso jebuguseni. Nanda diti jivu nine ghajisesi. Nine kaifa eso, gitofuimi na jo de atai fataeri. ");
INSERT INTO kpr_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Bajari amingusira aindae, na oroko nunda dombuda enda eminda jebuga ya foa gherena. ");
INSERT INTO kpr_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Na kotiseni, “Na dara eko beka beni.” Avata nanda tumondari God kena jo doyaeri. ");
INSERT INTO kpr_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Na manamana use eminge siseni, “Evetu genembo eni jo tumondae arena.” ");
INSERT INTO kpr_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Bajari nandae kavevera eraira aindae, numokena rea mutareni? ");
INSERT INTO kpr_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Bajari namo setiri jebugusena aindae, aiyakoe sise, vaini ava jobadae numokena mutarena. ");
INSERT INTO kpr_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Nunda natofo totorugedo tafaroro ururoro jokada, na rea beka gagojuse, numokena mutari dae sisena, ava mutarena. ");
INSERT INTO kpr_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Bajari God da natofo, nunda dombuda dambugo beká irá gheraera, eni nanjigo ambarera amo, nu mema teriago ava itatama arira. ");
INSERT INTO kpr_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Arie Bajari, na ninda saramana katori, nanda aya nimokena saramana usira, aminga ava eraena. Na asiimi bundisira ava nine vujeteso na jebuguseni. ");
INSERT INTO kpr_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Na nimokena aiyakoe sise, sino fuka de oje dungedo mutarena. Kotugo nanda benunu barago, joba mutarena. ");
INSERT INTO kpr_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","19","Ninda natofo isasambu ninda tafaroro kambo Jerusalem aminda totorugedo iroro, nimokena rea beka gagojuse mutari dae sisena ava, nenda dombuda mutono baresa. Bajari dae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Enda da oro oro isambu, Bajari dae sakai sevu! Evetu genembo isasambu, nunda javo jighivu erare! ");
INSERT INTO kpr_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Ai resira amo, Bajari, nu namonde dubo bu gogoghomberaira. Kotugo, nunda sari ava evovodae aminguse irarira. Bajari dae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Arie, Bajari dae aiyakoe sevu, ainda susu mo nu evevago bekári, a nunda dubo bari a kavevera evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Natofo Israel embo geka eminge sevu, “Nunda dubo bari a kavevera mo evovodae irira.” ");
INSERT INTO kpr_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","God da fristi mane isambu eminge sevu, “Nunda dubo bari a kavevera mo evovodae irira.” ");
INSERT INTO kpr_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Evetu genembo God dae igheghi use, numoa tumonde baingheraeva, isambu eminge sevu, “Nunda dubo bari a kavevera mo evovo dae irira.” ");
INSERT INTO kpr_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Na memai jarutuse Bajari namo sonembare dae seteno, nune sonembedo na vujegetiri kotae ya foa gherena. ");
INSERT INTO kpr_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Bajari mo nangae dabade irera, na jo itako oju ae arena, mave eni jo namokena mema mutae arera. ");
INSERT INTO kpr_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Bajari mo nanda tofori. Namo nune sonemberaira. Na gosurono, mave namokena gitofu ututeraera ava dedo atai duboda fafategarira. ");
INSERT INTO kpr_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Bajari tumonduse sonemba tambari mo evevagori. Endada evetu genembo kena gaiga gayari mo jo eveva iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Bajari tumonduse sonemba tambari mo evevagori. Endada giti jijighigari kena gaiga gayari mo jo eveva iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Gitofu digarigo aimi namoa koseguseri, avata Bajari da fakina aimi nemoa sosighi useni. ");
INSERT INTO kpr_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Nene kosekase guse, namoa jimbe birurughuseri, avata Bajari da fakina aimi nemoa sosighi useni. ");
INSERT INTO kpr_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Namoa kosekaseguse, kau fafakena aimi ari guse burughe buvurutuseri. Avata arivo gambu burughedo sekago totoigo soana eraira aminga ava use dadabuseri. Bajari da fakina aimi nemoa sosighi useni. ");
INSERT INTO kpr_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Namokena teria futo fati fero, aimi na rojiseni, avata Bajari na sonembusira. ");
INSERT INTO kpr_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Bajari mo nanda fakina da susuri a na javono numoa gateraena. Nune sonembetiri na jebuguseni. ");
INSERT INTO kpr_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Ningivu! God da natofo nenda dobo jokáda iritirise gitofu sosighi e bari da kuvai sise fumbu arugerera, “Bajari da fakina tomanakogo beká aimi sonembetiri namaneda gitofu sosighi useri.” ");
INSERT INTO kpr_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Bajari da fakina tomanakogo isoro jokada sonembetiri gitofu dedo, atai duboda fafatiguseri. ");
INSERT INTO kpr_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Na jo ambae irise, Bajari rea usira ava, vironu sido yarena. ");
INSERT INTO kpr_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Na dara usena aindae, Bajari etiri na mema itatama useni, avata jo doyari na ambaeri. ");
INSERT INTO kpr_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","God da tafaroro kambo da guro mane nandae afifigevu, ya jokada tere Bajari dae aiyakoe saone! ");
INSERT INTO kpr_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Emo Bajari da gurori. Bajari mavedae “eveva” sarira, ainembo foa terarera. ");
INSERT INTO kpr_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Bajari, nanda benunu ningido sonembusesa aindae, nimokena sakai resena. Nine eteso, na gitofu dedo atai duboda fafatiguseni. ");
INSERT INTO kpr_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Ghamana eni, kambo itari kakatoi imboe edo fugutusera ava, Bajari nune budo tutumbi dae sedo fiti simbugedo, aminda tuturo edo, nunda kambo itari dae erira. ");
INSERT INTO kpr_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Emo Bajari da ariri. Namonde gido dudukugherera. ");
INSERT INTO kpr_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Sifo emo Bajari nunda gitofu dedo atai duboda fafotusira, namonde isasambu ivuga use dubo jamaghae yaru divore! ");
INSERT INTO kpr_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Arie Bajari, namane sonembe jebugaore! Arie Bajari, namane sonembururu, rea gigiterera ava beká sirorare! ");
INSERT INTO kpr_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Orokaiva, buvuruteresare! God ni esimbugetiri, nunda javoda refesa. Bajari da tafaroro kambo eminda fetirise, namane ne isasambu esimbugerera. ");
INSERT INTO kpr_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Bajari mo nu God ri. Nunda usasa namondekena janimberira. Ika fafatu jore ungoi bambu ambo gaya ambo gaya gaedo, olta kakara aminda jimbe birurughuse divore! ");
INSERT INTO kpr_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","God nane tumonde baingheraena, amo nimori. Nindae aiyakoe resena. Na evetu genembo isasambukena ninda eveva kau mavego ava vironu sarena. ");
INSERT INTO kpr_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Evetu genembo isambu, Bajari dae aiyakoe sevu! Ainda susu mo nu evevagori, a nunda dubo bari a kavevera mo evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Mave Bajari da Agho Dari jokada irise, nunda uju ava nembo eraira amo, nu ivugaghae irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","God da Agho Dari ava mave nininguse, dubo joká isambu numokena muturaira amo, nu ririaghae irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Ne Bajari da emboro da ise, ari eko eni jo ae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Bajari, ninda agho dari namane dae mutudo, dubo joká isambuimi tumonduse kaifa aoro dae sisesi. ");
INSERT INTO kpr_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Na nange dubo joká isambuimi ninda sari ava tumonduse, ininighae kaifa areni? ");
INSERT INTO kpr_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Amingarena amota! Na nimokena fuse, ni rea sisesa isambu arena amo, na meka jo gae arena. ");
INSERT INTO kpr_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Ninda agho dari dambugo ava kasama arena amo, nanda dubo joká forosagoimi nindae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Na ninda sari, ava tumonduse, kaifa arena. Ava sedo, na erá doyeose! ");
INSERT INTO kpr_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Genembo seka bajari kau nange nange irari keosogo beká irari? Amo, ninda geka ainda amboda amboda use irarira. ");
INSERT INTO kpr_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Nanda janje joká isambuimi ninda saramana ari dae egiraena. Erá, ni agho dari rea sisesa ava kosasaghedo doyeone! Aindae, na kaifa e! ");
INSERT INTO kpr_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Erá nimokena ari eko eono dae sise, ninda geka nanda janje jokáda fiteno irira. ");
INSERT INTO kpr_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Arie Bajari, nindae sakai resena. Ninda emboro namokena ijuge! ");
INSERT INTO kpr_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Na ninda Agho Dari gefusesa ava isambu tegutuse evetu genembo kena vironu sise irarena. ");
INSERT INTO kpr_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Na ninda Agho Dari ava ari dae, ivuga beká eraena, moni a gugua roera kena jo kotae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Na ninda sari ava, nane tegutuse irena. Na ninda kau mavega ava kotise irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Na ninda sari ava uju beká eraena. Ninda geka ava, na itako jo kote doyae arena. ");
INSERT INTO kpr_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Na ninda saramana katori. Nandae ari eveva edo ghe! Amingururaso na irise, ninda geka ava kaifa edo ghaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Aso, nanda diti basari, ninda Agho Dari jokáda geka beká garigarigo nanjogo iritirira ava garena. ");
INSERT INTO kpr_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Namo eminda endada sifo tufako irarena. Ninda uju rea aoro dae seraesa ava, erá namokena jungeose! ");
INSERT INTO kpr_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Nanda ghamo beunghetiri itatamerena, ninda agho dari sifo ghousa ningari uju eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Ivuga kakato anakora nine girivaita eteso irera, a ni rea seraesa ava mave aindae emboro kosasagherae ");
INSERT INTO kpr_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Na ninda dengoro indari kaifa eraena. Ava sedo, evetu genembo setena, dere jise, a jijivu seraera nemokena, namoa bu darigase! ");
INSERT INTO kpr_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Reighi da babojegari totorugedo namoa ufena daoro ambono dae manaka gayeraera, avata namo ninda sari futusesa ava tegutuse irarena. ");
INSERT INTO kpr_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Ninda geka gefusesa ava, tegetuse, na dubo jama eraena, ninda agho dari gefusesa, aimi namoa ijuguse jighi dambu eraira. ");
INSERT INTO kpr_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Namoa atai duboda fatero ambari dae erena, ninda beka gajari ava use na sonembe, janje asegaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Na rea isambu usena ava, vujeguseni. Eteno, ni “avori” sisesi. Ninda sari ava ijugaso, gaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Ninda sari da tuka ava kasama aono dae sise, na sonembe! Amingaso, ninda ijuga garigarigo ava dubo jokai kotedo ghaone. ");
INSERT INTO kpr_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Namoa dubo mema aimi afurugetira. Ni rea ari dae beka gagojusesa ava use, namokena fakina bofu baone, ninda geka ava e! ");
INSERT INTO kpr_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Erá emboro sembae da yeone dae sise, na Kaifa e! Kotugo ninda kavevera eraesa aimi, ninda Agho Dari ava ijugaso gaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Na tofo ninda sari ava ari dae gateguseni. Ninda agho dari kau mavega ava, tege tuka kasama useni, ");
INSERT INTO kpr_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Arie Bajari, na ninda agho dari ava tegedo aminguseni. Erá eoso, na evetu genembo mendeni da dombuda meka geone! ");
INSERT INTO kpr_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Ni rea seraesa ava nembo edo gharena. Ainda susu mo, nanda kasama teriago mo, nine mutaresa. ");
INSERT INTO kpr_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Arie Bajari, ninda sari da tuka ava ijugururaso, na sifo ghousa evia kaifa edo ghaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Ninda Agho Dari ava se disugaso gaone, gido nanda janje joká isambuimi kaifa edo ghaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Giti jijighururu, na ni rea sisesa da emboro aminda fetedo yaone! Ainda susu mo, ninda sari aminda na dubo jama tamburaena. ");
INSERT INTO kpr_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Giti jijighururu, moni gugua ghayafa da dighighi ari jo ae, ni rea sisesa ava nembo kaifa aone! ");
INSERT INTO kpr_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Eráma doyeso, na god beká iritirae ava tumondeone! Ninda geka ava use, nandae ari eveva e! ");
INSERT INTO kpr_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Na ninda saramana katori, evetu genembo ninda sari eraera aikena, beka gagojusesa ava namokena aso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Natofoimi namokena jijivu ekoko seoro oju eraena ava kosege, ghamo asegaone! Ninda agho dari gari garigo bekári. ");
INSERT INTO kpr_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Na ninda sari ava ari dae uju eraena. Nimo numo bekári. Ágido, nandae jebuga seka ava bufu baone! ");
INSERT INTO kpr_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Arie Bajari, ninda dubo bari kau mavegori ava, ijugaso gaone! Ni beka gagojuse nange ari sisesa ava use, na sonembe jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Amingaso, evetu genembo namokena jijivu seraera ne mino saono sari bunarera. Ainda susu mo, nanda tumondari ninda geka kena fitiraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Nanda gigitari mo, ninda agho dari kenari. Ava sedo, sonembururaso, na sifo ghousa evia geka bekáda bekáda sarena. ");
INSERT INTO kpr_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Na sifo ghousa evia ninda Agho Dari rea resira, ");
INSERT INTO kpr_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Na gitofudae jo mema ae arena, ainda susu mo, ninda sari ava ari dae, inini eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Ninda agho dari ava kini (king) nanjogo kena vironu sise, itako jo meka ae arena. ");
INSERT INTO kpr_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Ni rea seraesa ava na dubo buraena. Ava sedo na aminguse, ivuga eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Ni rea seraesa ava, na dubo ruruse kakara eraena. Ninda sari futusesa ava, na dubo jokai kotedo gharena. ");
INSERT INTO kpr_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Na ninda saramana katori. Namokena geka sisesa, aimi etiri namokena gigitari sirorusira, ava kotedo aso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Na bouvu mema jokáda fefeteno, ninda beka gajari aimi etiri jebugusena aindae, dubo jama useni. ");
INSERT INTO kpr_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Ivuga kakato sifo ghousa evia nandae aji sise fiteoro voseraena, avata na ninda Agho Dari jo gukai mutae arena. ");
INSERT INTO kpr_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Arie Bajari, ninda agho dari abua manekena futusesa, aimi ghamo jama bu foa gheraira, ava koteraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Sifo reda ari ekoko embo ninda Agho Dari bejoro garena, na janje ekoko beká eraira. ");
INSERT INTO kpr_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Nanda irari sifo tufako enda eminda irise, ninda sari ava kotise, na yaru mane gateraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Arie Bajari, tumba ghae na nimoa koteraena. Ninda Agho Dari ava amboda amboda arena. ");
INSERT INTO kpr_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Nanda makoe mo, ninda sari nanjogo ava udo refena. ");
INSERT INTO kpr_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Arie Bajari, nisuka nimoa nanda ujuri. Ninda geka kaifa are dae beka gagojerena. ");
INSERT INTO kpr_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Nanda janje joká isambuimi nimokena benunu resena, ni beka gagojusesa aminguse, nandae joká edo esimbugaso dae, resena. ");
INSERT INTO kpr_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Nanda irari ava fuge gosuse resena. Ninda geka ava use irari dae, beka gagojerena. ");
INSERT INTO kpr_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Jo itako gaimbo ae, na totoigo ni rea sisesa ava ari dae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Ari ekoko ari kakato namoa ninda Agho Daro doyono dae sedo, nenda vagho simbugeteri. Avata, ninda Agho Dari jo kotae ae arena. ");
INSERT INTO kpr_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Ninda Agho Dari dambugo eraesa aindae, na tumba soroda nindae sakai sari dae ereraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Nanda umo gaumo kokomana mo, evetu genembo nindae saramana use, ninda sari kaifa eraera, avori. ");
INSERT INTO kpr_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Arie Bajari, enda mo, ninda dubo bari a kavevera aimi beda edo irira. Ninda sari ava namokena ijuge, gaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Arie Bajari, na ninda saramana katori. Nandae ari eveva eraesa. Ni geka seteso, beká namokena siroretira. ");
INSERT INTO kpr_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Namokena ijugururaso na dubo kotise, kasama égogogho arena. Ainda susu mo, ni rea sisesa, na ava tumonderaena. ");
INSERT INTO kpr_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Na sembae use, kosasaghedo ghusena, aindae eoso, na ghamo budo ghuseni. Avata oroko mo, na rea sisesa ava kaifa eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Nimo evevagori, kavevera katori. Ijuge, ninda sari ava aone! ");
INSERT INTO kpr_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Ivuga kakato nanda bino sembae are dae, nanda javoda aji siseri. Avata nanda kotari isasambuimi na ninda sari ava ningido amingeraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Ninda Agho Dari rea resira, ainda kasama nemokena tefori. Avata ninda Agho Dari aindae na ivuga erena. ");
INSERT INTO kpr_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Nane ghamo baono dae usesa aimi namokena eveva usira. Ainda susu mo, amingeteso, ninda sari ava, na kasama useni. ");
INSERT INTO kpr_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Agho Dari nine futusesa, ainda tuka namokena teriagori. Jo moni nanjogo endada iritirira amingo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Nine eteso na siroruseni, a nine kaifa urureaso, jebuga irá gheraena. Ninda rea sisesa ava kasama aono dae sise, nanda kotari afige! ");
INSERT INTO kpr_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Nanda tumondari ninda geka kena fitiraena, ava gosuse, evetu genembo nimoa kakara eraera, aimi ivuga use irera. ");
INSERT INTO kpr_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Arie Bajari, ninda agho dari ava eraesa aindae resena. Ni namoa ijujuse, seteso ghamo rurusena amo, eveva ava usesi. ");
INSERT INTO kpr_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Na ninda saramana katori. Nine beka gagojuse rea sisesa, ava use, ninda dubo bari tomanakogo aimi aso, dubo jama aone! ");
INSERT INTO kpr_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Nandae joka edo, sonembaso, na jebugaone! Ainda susu mo, ninda Agho Dari aimi namokena ivuga bu foa gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Evetu genembo ivuga kakato namoa tefo tefo gesire eraera, nemokena aso, meka gaoro dae resena. O namo, ninda sari nanjogo ava, nanda kotari isambuimi kotise irarena. ");
INSERT INTO kpr_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Evetu genembo isasambu mave ninda Agho Dari kasama edo nimoa kakara eraera, ava saso, namokena furore! ");
INSERT INTO kpr_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Erá meka geono dae sise resena: na nange, ninda sari nanjogo ava, isambu kaifa e gogoghombaetena, ava uju eraena! ");
INSERT INTO kpr_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Arie, Bajari, namo saso jebugarena ainda sifo kaifa use irana, na garoro buvira. Na ninda Geka ava tumonderaena. ");
INSERT INTO kpr_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Ni rea ari dae beka gagojusesa ava kaifa use, diti emboro use irana bunedo, ategi erena, “Ni nanjigo nandae kavenu saso, na ghamo asegareni?” ");
INSERT INTO kpr_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Na jo evetu genembo eni da kaugo iraeri. Namoa kau amingori, vaini da kofiri manai bununughedo irira. Avata, ninda sari ava jo itoko kotae ae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Na ghousa mavega ava kaifa ururono, evetu enembo namokena mema muturaera ava, aso ghamo bareri? ");
INSERT INTO kpr_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Evetu genembo ivuga kakato ninda Agho Dari jo ningido kaifa ae eraera aimi, namo sandi bari dae vagho bako simbuguseri. ");
INSERT INTO kpr_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Ni rea seraesa ava, geka beká vanembori. Evetu genembo namokena mema futuse, gungubo tefo tefo resera, ainda dombuda na sainghimbe bu! ");
INSERT INTO kpr_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Ne na detero ambari itako useni. Avata, ninda sari ava jo itako gukai mutaeri. ");
INSERT INTO kpr_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Ni na dubo bu gogoghomberaesa aindae, nandae veka eveva ururaso, na ninda Agho Dari ava, ningido kaifa arena. ");
INSERT INTO kpr_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Arie Bajari, ninda geka evovodae irarira, utuda susu gambudo irira. ");
INSERT INTO kpr_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Ni geka nanjogu seteso fetirira ava amingudo yaresa. Enda é nine seteso susu gambu fefotusira aminge irira. ");
INSERT INTO kpr_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Roera isasambu ninda agho dari da irira. Ainda susu mo nemo isasambu ninda sari ningariri. ");
INSERT INTO kpr_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Ninda Agho Dari dae jo ivuga use irae aetena amo, mema bouvu itatama eraena, ai ambaeteni. ");
INSERT INTO kpr_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Na jo itatako ninda sari kotae ae arena. Ainda susu mo, aimi na kaifa eso, jebuga irena. ");
INSERT INTO kpr_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Nasukako namo nindari, sonembe, jebugaone! Ninda sari ava ari dae edo giraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Ari ekoko embo namoa ufena daoro ambono dae kato erera. Avata, ninda Agho Dari ava nanda janje jokáda fitono irari kotedo gharena. ");
INSERT INTO kpr_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Na kasama erena, roera isasambu nenda tano ghaeri. Avata, ni rea sisesa amo, evevago bekári, tano tefori. ");
INSERT INTO kpr_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Ninda Agho Dari mo, nange nanda dubo bari bekári. Sifo tumba evia kotise irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Ninda uju rea aoro dae sisesa ainghae irena. Sifo ghousa aimi urureari na dubo kotaride eraena amo, jo nandae gitofu eraera ainda dubo kotarigo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Na dubo kotari kasama teriagori, jo nanda ijuga kakato isasambu ainda kotari kasamago iraeri. Ainda susu mo, na ninda agho dari tegutuse, dubo jokai kotise irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Nanda dubo kotari kasama teriagori, jo afa koro da dubo kotari kasamago iraeri. Ainda susu mo, ninda sari ava ningido amingeraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Na ari ekoko da emboro do dariguseni. Ainda susu mo, ninda geka rea resira ava ari dae uju use irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Na ninda agho dari isambu futusesa ava, eni jo bu fugaeri. Ainda susu mo, nisuka nimoa nanda ijuga katori. ");
INSERT INTO kpr_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Geka ninda bekada buvuruterira ava jeurugo bekári, jo finjeda firukago iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Ninda sari aminda na dubo kotari buraena. Ava sedo, na ari ekoko da emboro aminda yari imboe eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Nanefa aminga ava, ninda Geka aimi nanda emboro ijugeraira. A kotugo na ningia aminda yaetena, ninda Gekaimi jaraghurureari ya gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Ninda agho dari eveva gaveva ava ari dae sedo javono gatise, beka gagojusena ava aono beká sirorarira. ");
INSERT INTO kpr_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Arie Bajari, nanda tamo gambisi futo edo kae saviri ambududurerena. Beka gagojusesa aminga ava use, kaifa ururu, na jebuga irone! ");
INSERT INTO kpr_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Arie Bajari, nindae banunguse, aiyakoe resena, ningi! A kotugo, ninda agho dari aono dae resesa ava, ijuge! ");
INSERT INTO kpr_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Na dara ambari jokáda fetirise, ambari dae jo oju aeri. Ninda Agho Dari kotido yarena. ");
INSERT INTO kpr_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Ari ekoko emboimi namoa daoro ambono dae vagho useri. Avata, ninda sari ava, na jo itako bu fugaeri. ");
INSERT INTO kpr_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Ninda sari ava, nanda jebuga evovodae irari da yeyeri. Aimi nanda janje dereari erorureari riria eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Na tofo mandi kotiseni, ninda Agho Dari rea resira, ava use iria ambarena. ");
INSERT INTO kpr_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Evetu genembo dubo etoto eraera ava, na gari imboe beká eraena. Avata, na ninda Agho Dari ava uju beká eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Nimoa nanda ambo sosari vasari akotugo nanda bereri. Ninda geka sisesa, ava gigituse irágheraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Ari ekoko embo nemokena resena, na dodo darige ajagha yasivu! Na God tumonde baingheraena, aimi rea sisira ava amingarena. ");
INSERT INTO kpr_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Nine beka gagojusesa ava use, fakina nandae bofu bu jebugaone! Erá eóso, na rea gigiteraena ava, jo sirorae euri na meka geóne! ");
INSERT INTO kpr_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Na jighi fete, jebugaone! Ninda sari ava ningi kaifa use irarena. ");
INSERT INTO kpr_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Evetu genembo mave ninda sari bejeraera ava ondeaso darigeraera. Beká resena, ne reju ava ari dae manaka gayarera, ava de tisaso beká jo sirorae arira. ");
INSERT INTO kpr_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Ari ekoko embo ava inono sena a susunda avavago babarageraesa. Aindae sedo, ninda Agho Dari ava ghamo buraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Nindae oju beká eraena. Ninda agho dari usesa aimi etiri na ojuimi jaruteraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Na rea etena amo, dambu a evevagori. Erá na gitofu jokada doyeóse! ");
INSERT INTO kpr_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Na ninda saramana katori. Namo sonembari dae beka gajaso dae resena! Erá doyeóso gegenembo totofo sakai sari kakato aimi na kateyavara use, nandae mema muteóre! ");
INSERT INTO kpr_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Namoa gitofukena sanghimbe baso jebugaono dae beka gagojusesa ava diti emboro use irena. ");
INSERT INTO kpr_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Bajari, na dubo buraesa aindae, ninda sari aono dae sisesa, ava ijugaso gaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Na ninda saramana katori. Nanda kotari afigaso, ninda sari ava kasama aone! ");
INSERT INTO kpr_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Bajari, oroko mo, eredo javi aso dae resena. Ainda susu mo, natofo ninda Agho Dari erebejera. ");
INSERT INTO kpr_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Geka bekári, na goldi (gold) nu uju eraena. Avata ni rea seraesa ava, uju beká eraena. Nanda uju goldi o goldi numo beká aikena jo amingo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Ninda sari eveva gaveva irariá seraena susu aindae, emboro sembaeda yari na imboe eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Ninda Agho Dari amo garigarigori. Nanda kotari isambu aimi ava eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Ninda geka se didisugarera aimi, usasa janimbururari bunari emboá dubo kotarera. ");
INSERT INTO kpr_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Dubo sagheari uvudae beka angasa angasa eraera, aminga ava ni rea seraesa ava, ari dae use irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Natofo nimoa dubo buraera aikena eraesa aminga ava use, dombu namokena edo, nandae joka aso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Ni beka gagojuse rea ari sisesa, ava ururaso, na ari ekoimi jo bajari ururari gofae arena. ");
INSERT INTO kpr_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Ninda sari ava aetena ava kotise, evetu genembo namoa kateyavara use, namokena mema bouvu erefutera aikena, namoa saghimbe baso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Na esimbuguse, fu nangae irore! Irise, ninda sari ava ijugaso gaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Natofo ninda Agho Dari jo kaifa ae use, erebejera aindae, nanda diti jivu rururarakuse uvui sumbari gerira. ");
INSERT INTO kpr_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Arie Bajari, nimo dambugo bekári, a ninda Agho Dari isambu eveva gavevari. ");
INSERT INTO kpr_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Agho Dari futusesa amo, beká ava nembori. Inono a dambugo bekári. ");
INSERT INTO kpr_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Nanda gitofu ninda geka itako jo budo amboda amboda ae eraera aindae, nanda janje eko janje jokáda avarakai avarigerira. ");
INSERT INTO kpr_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Na kasama erena: ninda beka gajari nanjogo ainda beká sirorarira. Ava sedo na ghamo buraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Namo jo genembo mindafu eni iraeri. Akotugo na derejiraera. Avata, na ninda Sari ava kotise irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Ni evovodae ari eveva vanembo use irágheraesa akotugo, ninda Agho Dari ainda beká sifo ghousa siroreari giraera. ");
INSERT INTO kpr_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Na ganjibetiri jarutuse bouvu mema teria fufuse irena, avata, nine rea sisesa aindae, ivuga use irena. ");
INSERT INTO kpr_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Ninda Agho Dari beká ava nembori. Nanda kotari afige, jebuga tambone! ");
INSERT INTO kpr_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Arie Bajari, nanda kotari isambuimi nimokena benunu resena. Mino saresa amo, ninda sari ava use irarena. ");
INSERT INTO kpr_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Ninda sonemba a jebuga ghae mutaso dae kori resena. Amingaso, ninda Agho Dari rea resira ava aone! ");
INSERT INTO kpr_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Iji jo vitae iriari, na ninda sonemba dae benunu seraena. Ninda geka rea resira ava kaifa gigita use irena. ");
INSERT INTO kpr_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Tumba soro ghousa ninda beka gajari dubo jokai kotari dae sise, na jo avae irise fase irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Arie Bajari, na sifo ghousa dubo buraesa aindae, ningaso dae resena. Nandae joka use sonembururaso jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Evetu genembo namokena mema mutari dae sise, manaka gaedo ojera utua erera. Avata, evetu genembo amo ninda Agho Dari itako jo kaifa ae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Arie Bajari, nimo nanda tinguda iresa, a kotugo, ninda geka rea sisesa ava isambu beká ava nembori, tano tefori. ");
INSERT INTO kpr_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Giti beká na ningi kasama useni, ninda Agho Dari sifo ghousa irare dae sise, seteso fefetusira. ");
INSERT INTO kpr_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Na mema eretafena emoko fuge gosuse, saso jebugaeteni. Ainda susu mo, ninda Agho Dari ava na kotise irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Nandae sorega fufuse, namoa gitofukena bu darige! Sonembe, ni rea ari dae beka gagojusesa, ava e! ");
INSERT INTO kpr_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Ari ekoko embo ne jebuga jo tambae arera. Ai resira, ne ninda sari ava, jo ae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Bajari, nimo kavevera katori. Ninda joka ari kau mavega ava ijuguse na sonembe, jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Natofo, namokena gitofu use kateyavara eraera, digariri. Avata, na jo gofedo, ninda Agho Dari itako imboe aeri. ");
INSERT INTO kpr_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Evetu genembo tumondari tefo sifo reda giraena, na bero tugari dae eraena. Ainda susu mo, ne ninda Geka ava jo kaifa ae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Bajari, namoa gi, ninda sari ava, na uju beká eraena. Ni na dubo buraesa ava, jo itako nanjigo aminda doyarigo iraeri. Ava sedo, na sonembe jebugaone! ");
INSERT INTO kpr_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Ninda geka isambu beká vanembori. Akotugo, ninda Agho Dari kosasa tefori, isambu evovodae irarira. ");
INSERT INTO kpr_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Reighi da babojegari a giti jijighigari namoa susu tefo osogo use mema mutari dae eraera, avata na ninda Geka kakara beká eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Ninda beka gajari ututusesa aindae ivugai jaruterena. Kau evetu genembo gugua sosighi ea budo ivuga beká eraira, aminga ava eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Na geka gungubo ningari beghagha use, imboe beká ava eraena. Avata, na ninda Agho Dari seteso fefetusira ava, uju beká eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Na sifo evia inono ninda Agho Dari kosasa tefo aindae aiyakoe sise irágheraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Evetu genembo ninda Agho Dari uju eraera, nemo dubo jama mindafugo tambarera. A kotugo, roera eni aimi jo nemokena ari gofari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Arie Bajari, namo sonembaso jebuga tambarena da sifo kaifa use irena. Akotugo, ni rea seraesa, ava eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Nanda kotari isambu aimi ninda Agho Dari dubo buraena, ágido amboda amboda eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Ninda sari ava use, ninda Agho Dari futusesa ava eraena. Ainda beká mo, na rea eraena isambu, nine giraesa. ");
INSERT INTO kpr_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Arie Bajari, nanda sorara emo, nange ya nimokena buvari ningaetesi. Ni rea ari dae beka gagojusesa, ava use nanda kotari afigaso, kasama baeteni! ");
INSERT INTO kpr_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Nanda benunu nimokena erena ningaetesi. Ni rea ari dae beka gagojusesa, ava use, na sonembaso jebugaeteni! ");
INSERT INTO kpr_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Na sifo ghousa nindae sakai sise irarena. Ainda susu mo, ninda sari ava namokena ijugeoso giraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Ninda geka yaruimi isimbuse irarena. Ainda susu mo, ni rea seraesa aminda, kosasa tefori. ");
INSERT INTO kpr_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Sifo ghousa namo sonembari dae iriro use iraetesi! Ainda susu mo, na ninda sari aminda feteraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Arie Bajari, nine saso jebugarena da sifo ava kaifa use irena. Ninda Agho Dari amboda amboda use ivuga eraena. ");
INSERT INTO kpr_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Doyaso, na jebuga irise, nindae sakai saone! Na uju erena ninda Agho Dari aimi na sonembaeti! ");
INSERT INTO kpr_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Kau sifi enimi baghimbari gedo irira, aminga ava na emboroda yaba yaba ghuse irena. Avata ni rea sisesa ava, na jo kotae useni. Ava sedo, foa namoa kakova edo unumbaso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Na darada fetedo ghusena da sifo aminda, Bajari namo sonembare dae banungedo ghuseni. Banungeono ningido na nune sonembedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Arie Bajari, namoa gungubo kakato a derari kakato eikena bu darigaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Gungubo kakato, God nendae nange ari? Nu nendae kau nange ari ghamo barevu? ");
INSERT INTO kpr_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Ne taká isoro emboda feva da goroba mendó sighonogo aimi gae babasiguse, avaraka imo kokoigo beká aimi dungari avareva. ");
INSERT INTO kpr_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Nenda jokáda irari mo, eko bekári, kau esa yavai ya, evetu genembo nenda otu ekoko reighi Meseki o Keda embo ainda irari da kaugori. ");
INSERT INTO kpr_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Na evetu genembo beisiga tataya kakatode ghousa futo irana, imboe beká erira. ");
INSERT INTO kpr_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Na dubo jama da genembori, avata ne nanjigo beisiga tataya dodo iroro dae sarena amo, ne isoro ari dae sarera. ");
INSERT INTO kpr_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Na doriri fuge gosuse, god a sukaru mendeni tumonde bainghari dae sise, ove aminda keve dadorusera aikena, dombu fainghedo banungarena, ai tefo? Avata na jo amingae arena! Ainda susu mo: nanda sonemba jo aminda ghe furae eraira. Avata nanda sonemba reda ghe foa gherai? ");
INSERT INTO kpr_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Nanda sonemba mo, Bajari utu a enda etiri sirorusira, numokena ghedo foa gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Nu ni jo doyari gofae aresa. Nimo tavo ari kato mo, nu diti fangedo, sifo evia inono ni kaifa use irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Amo, Israel embo da tavo ari kato mo, nu jo diti bainghae eraira, a kotugo, nu jo avae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Bajari nune, ni bu kaifa use tavo e gogoghomberaira. Nu ninda dengesida fetirise, ninda gitofu da fakina ava gagojuse ni kaifa eraira. ");
INSERT INTO kpr_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Sifo ateraira ainda jokáda, iji aimi dara o mema eni jo bu furae arira. A kotugo, tumba jiraira ainda jokáda, inua aimi barago dara a mema eni jo bu furae arira. ");
INSERT INTO kpr_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Ainda beká mo: dara rea furarira ava, isasambu Bajari nune koseguse kaifa e gogoghombururari, ni eveva irá gharesa. ");
INSERT INTO kpr_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Nune ni kaifa tavo e gogoghombururari, ni oroko a sifo ghousa evia, eveva ya foa ghuse irá gharesa. ");
INSERT INTO kpr_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Nandae eminge sisera aindae, ivuga useni, “Javi e namonde Bajari da tafaroro kamboda yaore!” ");
INSERT INTO kpr_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Arie Jerusalem ko, namane refara buveri, ninda furu jokada fetirera! ");
INSERT INTO kpr_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Jerusalem sekago bogu begaya beká dighi anumbuseri, garigo beká takegha takegha itutuseri. ");
INSERT INTO kpr_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Bajari Israel da oro oro aikena rea sisira, ava use, Bajari da natofo isasambu nundae sakai saridae, vasa eminda viti foa gheraera. ");
INSERT INTO kpr_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","David da imemisiri kini (king) edo ghusera, vasa eminda anumbedo, nenda natofo Israel embo da mema bouvu ijujeoro dambu edo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Jerusalem aminda dubo jama sirorare dae banungaore! “Evetu genembo nindae ghamo buraera aikena, fakina sirorare!” ");
INSERT INTO kpr_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Ninda furu jokáda natofo nange dubo jamaghae iroro, kotugo ainghae dabade kokotofu da kambo babai iritirera aminda, dara a mema bouvu eni erá tereure dae benunu resena. ");
INSERT INTO kpr_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Nanda nano namendi a kokomana Jerusalem irera kotise, Jerusalem dae resena, “Dubo jama nimokena irare!” ");
INSERT INTO kpr_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Namondeda Bajari God da tafaroro kambo eminda irira aindae kotise, reighi einda jokáda irari eveva sirorare dae banungerena. ");
INSERT INTO kpr_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Arie Bajari, ni utu ominda irise utu enda kaifa eraesa aindae, nanda dombu nimokena faingherena. ");
INSERT INTO kpr_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Arie Bajari, namaneda God, kau sabua kakato gegenembo o evevetu bayau a sonemba nenda babojegarikena buraera aminga ava, namaneda dombu nimokena fifituse iroro, namanendae joka edo sonembaetesi! ");
INSERT INTO kpr_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Arie Bajari, namanedae joka e! Namanendae joka beká aso dae resena. Ai resira, evetu genembo namane ighagha use, sino fukadae ari geraera. ");
INSERT INTO kpr_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Iti fafo gugua ghayafade aimi namane ava teria futo ighagha use, jo evetu genembo irae sise, sero, namane irari barago erera. Ainghae dabade, meka irae ivuga tefo tefo ari kakatoimi namane ava kateyavara beká use irera. ");
INSERT INTO kpr_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Bajari, namonde jo sorae aetira amo, namonde nange aeteri? Arie, Israel embo sevu! ");
INSERT INTO kpr_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","3","“Gitofui janje ekoko beká use, namonde dedo gaedo ghari dae isoro edo ghusera ainda sifo aminda, Bajari namonde jo sorae aetira amo, ne namonde diti jebuga dukunghaeteri. ");
INSERT INTO kpr_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Useghai roera bu sivari guse, uvuimi fati tifughari geraira aminga ava, gitofuimi namondekena aeteri. ");
INSERT INTO kpr_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","O eva babai aimi ghasemo fatari, natofo mindi sirivo arigaetera aminga ava, gitofuimi namondekena aeteri.” ");
INSERT INTO kpr_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Avata erevu! Namonde Bajari dae aiyakoe saore, nu jo doyari gitofui namonde sosighi aeri. ");
INSERT INTO kpr_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Namonde kau rika vatafa fitari kakato da vatafada kosughe buvari guseri, vatafa da asi tafusegetiri, namonde jebuguseri. ");
INSERT INTO kpr_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Namondeda sonemba Bajari utu enda ari katoimi nusuka nune eraira. ");
INSERT INTO kpr_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Evetu genembo mave tumondari Bajari kena fifituse irá gheraera amo, nemo kau doriri Saion amingori. Amo jo itako dara daraghuse gisighe yae arera, ne susu gambudo irera. ");
INSERT INTO kpr_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Kau doriri mane aimi Jerusalem jimbe birurughe fefetegirera aminga ava, Bajari oroko nunda natofo jimbe birurughedo evovodae aminguse irarira. ");
INSERT INTO kpr_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Ekoko emboi jo sifo ghousa eveva emboda endada irise, giti nene jo jighae arera. Ainda beká mo, ekoko emboi ghousago giti jighari nene aetera amo, eveva embo nembarago, avose, tuturo edo ari ekoko aeteri. ");
INSERT INTO kpr_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Bajari, mave ari eveva eraera aikena ari eveva e, mave ninda sari ava nembo eraera aikena! ");
INSERT INTO kpr_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","O ni sifo nanjigo ari ekoko embo daso ghamo baoro dae aresa, mave ninda uju eraera ava dodo, ekoko erera nemoa nembo daso ghamo barera. Dubo jama Israel embokena irare! ");
INSERT INTO kpr_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Bajari namonde gitofu reighida ghedo bu jovereghe sekago Jerusalem eminda, bu fusira amo, namonde jo tumondaeri. Kau aturu ari guseri. ");
INSERT INTO kpr_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Amingedo, namonde ava ivuga use, ivugai gegha kekeku sise jighi fumbu aruguseri. Aminguse irero, oro mendeni gido namondedae eminge siseri, “Bajari, nendae roera babaigo erira.” ");
INSERT INTO kpr_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","“Ai bekári,” siseri. Nu namondedae roera babaigo ava usira. Etiri, namonde dubo jama erera. ");
INSERT INTO kpr_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Arie Bajari, kau iji feteari uvu saghedo iriari borija sekago dise, uvu gaunghe viti betu bamburaira aminga ava, namane enda eminda irari kena esimbugaso sekago iti fafode aore! ");
INSERT INTO kpr_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Mave soraraghae govusera, ivugaghae je gambedo gharera. ");
INSERT INTO kpr_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Mave jivu menjuga gutuse, roera veka fumbu govari dae isera, je gambedo sigina sagina edo, jovereghe kuvai ghae furarera. ");
INSERT INTO kpr_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Bajari kambo jo itae arira amo, kambo itari embo nenda fakina soesa arera. Reighi bogu begaya ava Bajari jo gagara ae arira amo, gitofu kato ari embo nenda fakina soesa arera. ");
INSERT INTO kpr_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Oka bayaudae sifo ataeda ere tumba jirari soroda avido ghari mo, jo eveva iraeri. Ai resira, Bajari mavejoa dubo buraira aikena, ne aviroro nune muturaira. ");
INSERT INTO kpr_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Mandi sasingu mo fuyori, Bajari muturaira. Esimbugari beká nemori. ");
INSERT INTO kpr_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Vide jamena genembo seka bajarikena siroreraera amo, kau isoro embo feva da goroba eni afari dae sise, fitiri irira, amingori. ");
INSERT INTO kpr_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Genembo mave vide jamena digari sari sirorarera amo, koto sifoda, nunda geka bouvu arira. ");
INSERT INTO kpr_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Mave Bajari da uju ava use, nunda amboda amboda arira amo, ne ivugaghae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Ni rejodae saramana eraesa, ainda beká ava sirorari baresa. Budo, susu iti fafode edo, ivugaghae iraresa. ");
INSERT INTO kpr_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Nearo kau vaini da asi jigharigo amingori, sasingu ghagurago beká fumbarira. Ni bayau mindari dae anumbaresa amo, ninda vide jamena ghaguruimi anumbe jimbe birurugharera ava, kau ika orivi tamonda batuno sasangi birurugheraira, amingori. ");
INSERT INTO kpr_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Genembo mave Bajari da uju ava use irá gheraira amo, Bajari nu setena ava, aminguse esimbugarira. ");
INSERT INTO kpr_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Bajari Saion irise, ni esimbugare! Ni jo ambae ghousa mavega ava iraresa, Jerusalem aminda gugua ghayafa iti fafode arira gaso dae resena! ");
INSERT INTO kpr_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","A kotugo, ni jo ambae irise, ninda imemesiri siroraoro gaso dae resena. Dubo jama Israel embokena irare! ");
INSERT INTO kpr_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Israel ondi, ne seka babojevo gitofu nendae kau nange use mema bouvu futero babojuseva ava, sevu ningore! ");
INSERT INTO kpr_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","“Namane seka babojero, namane da gitofu namanekena ari ekoko use, mema bouvu futero itatamuseri. Ne amingusera avata namane fakina edo jo gofaeri. ");
INSERT INTO kpr_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Ne namane da guka ambi aimi ghinjebuse deoro rabijuse sasarigedo ghusira ava, namane da guka isambu buvá aimi bedo edo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Avata Bajari, bekáda bekáda seraira aimi, gitofu da dombuda nenda asi vujegetiri, namane do buvudo jebuge irera.” ");
INSERT INTO kpr_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Evetu genembo isambu mave Saion gari imboe eraera ava, nange ondi bere bereghaso meka gosuse jovereghe yaeteri. ");
INSERT INTO kpr_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Ne kikisa veka ghamana etoda vose batuno edo, jo vitae gharasa eraira, amingari gaeteri. ");
INSERT INTO kpr_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Jo evetu genembo eni aimi rete dabade ae arera, o jo sijari sijari edo, fumbu yae arera. ");
INSERT INTO kpr_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Evetu genembo mave jo foa ne gi dariguse, “Bajari, ne esimbugare!” o “Namane ne Bajari da javoda esimbugerera,” avavaga itako jo sae aeteri. ");
INSERT INTO kpr_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Arie Bajari, na dara kau irae, eko beká ainda jokáda irise, namo sonembaso dae sorara erena. ");
INSERT INTO kpr_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Arie Bajari, nanda sorara ningaso dae resena, nandae joka use sonembaso dae sorara erena, ningi! ");
INSERT INTO kpr_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Ni namanenda ari ekoko gembu fifituse irá edo, namane ijujari dae saetesa amo, mave jaunghe vatafaghe jebugari? ");
INSERT INTO kpr_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Avata, ni ari ekoko kote doyeraesa aindae, namane nindae oju igheghi use, tumonde baingheraera. ");
INSERT INTO kpr_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Na Bajari da sonemba ava kaifa gigita use, nunda geka rea setiri fefetusira, ava tumonduse irá gheraena. ");
INSERT INTO kpr_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Na Bajari foa sonembarira, na aindae ivuga ghae, kaifa eraena. Isoro embo da kaifa kato ivugaghae sifo atare dae kaifa eraira da ivuga, jo nanda ivuga amingo iraeri. Sekago resena, ituru embo setena, ainda ivuga jo nanda ivuga amingo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Arie Israel embo, nenda gigitari Bajari kena fitivu! Ainda susu mo, nunda dubo bari teriagori. Aimi namonde dubo bu gogoghombuse evovo dae namonde sonembari dae kato use irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Nune, nunda natofo Israel embo, nenda ari ekokoda mino mutudo sari jebugarera. ");
INSERT INTO kpr_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Arie Bajari, na ivuga use, nandae sakai saore dae edo ghusena ava imboe edo dotutuse, meka irae namo gaore dae jajaghedo ghusena ava dotutuseni. Na roera babaigo garigarigo kokotofu kasama kakato da ari jo nanda ari da kaugo irae ava ari dae jo kotari futo ae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Tatera, na durumugeteno nanda janje joká jama etira. Kau sasingu ami mindari noi da ami gambu beka do songhe fase irá gheraira aminga ava, nanda janje joká isambu songhetira. ");
INSERT INTO kpr_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Arie Israel embo, oroko eitano sifo ghousa evovodae nenda tumondari Bajari kena fifituse irivu! ");
INSERT INTO kpr_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Arie Bajari, David, kotugo nunda mema ambarako beká itatama edo ghusira ava, erá kotae eose! ");
INSERT INTO kpr_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Bajari, God fakina kato Jacob tumonde bainghedo ghusira, nimokena resena: David rea ari beka gagojusira ava kotaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“Na jo nanda natida ya nanda avari vasada fase avae arena. ");
INSERT INTO kpr_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","Na itatako jo jangutae a jo avae irise, ");
INSERT INTO kpr_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","Bajari God fakina kato Jacob tumonde bainghedo ghusira, ainda kambo itarena.” ");
INSERT INTO kpr_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Namane Bethlehem irise, Agho Dari nunda mauvaghae da binó ningido era, vare jokáda reighi Jearim dengesi aminda torughuseri. ");
INSERT INTO kpr_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Namane siseri, “Avata oroko mo tafaroro kambo jokáda irira. Fuvu, Bajari da irari vasada yaore! Ya, nunda anunbedo irari vasada teredo numoa tumonde bainghaore!” ");
INSERT INTO kpr_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Arie Bajari, ere, ninda fakinada tano, ninda Agho Dari da mauvadae resera ainghae, fu, ninda kamboda tere evovodae iraso dae resera. ");
INSERT INTO kpr_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Sonembe, ninda fristi mane ari eveva vanembo aore! Sonembe, ninda natofo fumbu aruguse irore! ");
INSERT INTO kpr_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Bajari, ninda saramana kato David kena kotua gatisesa ava kotise, ninda kini gategeteso oroko irira ava, erá ighagha eose! ");
INSERT INTO kpr_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Ai resira amo, Bajari, ni David kena kotua gatisesa, jo doyae aresa. Ni kotua eminge gatisesi, “Nane aono, ninda mandi enimi ninda vasa budo, kini arira. ");
INSERT INTO kpr_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","A kotugo, ninda sasingu vide jamena nanda beka gajari a nanda agho dari futusena ava, amboda amboda arera amo, nenda sasingu nébarago evovodae numamoda vasa budo, kini udo yarera.” ");
INSERT INTO kpr_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Bajari, nu reighi Saion ava gategedo, eminda irari dae sisira. ");
INSERT INTO kpr_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Nu sisira, “Nanda uju, na vasa eminda irise, nanda natofo kaifa udo yarena.” ");
INSERT INTO kpr_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Reighi Saion embo reju baetera, ava nane esimbuguse, reighi ainda makasi emboda uvu bayau nane mutarena. ");
INSERT INTO kpr_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Nane esimbugururono reighi ainda fristi maneda aito eveva fugutudo yarera. Nane aono reighi ainda natofo tumondari embo dubo jama use ivugai divu fusedo gharera. ");
INSERT INTO kpr_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Nane aono, David da imendi eni siroredo Kini fakinago edo fetarira. Kini resena ava, gategedo sonembururono reighié kaifa udo yarira. ");
INSERT INTO kpr_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Nane aono, nunda gitofu meka gosuse mekai jarutarera. Avata nane sonembururono, nunda reighi nunda natofo isambu nune kaifa ururari, riria use irarera. ");
INSERT INTO kpr_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Arie, God da natofo dubo dabako edo irarera, namonde mino eveva itatama use ivugaghae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Amo kau usu muno yavegari Aaron da jiroda averegetero yoyaghuse vose nunda besosoda ghe vose fira, nunda tamo asugari dubokena vovosusira. ");
INSERT INTO kpr_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Dubo dabako edo irari nunda esimbugarighaeri, kau doriri Hermon da mungo doriri Saion kunikada vosari garira. Bajari nunda esimbugari aminda mutari sisira, jebuga evovodae irari tano tefori. ");
INSERT INTO kpr_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Bajari da saramana kakato, isambu fuvu! Bajari dae sakai saore! Mave nunda tafaroro kambo jokada tumbaghae saramana eraeva isambu nendae resena. ");
INSERT INTO kpr_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Tafaroro kambo jokáda nenda ghabu jighivu erorurari, Bajari dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Bajari, utu a enda ari kato, Saion aminda irise, ne esimbugare dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","2","Bajari dae sakai saore! Bajari da saramana embo nunda kambo jokáda fetireva, nunda Tafaroro Kamboda dendegu aminda ireva, nendae resena. Bajari da javo jighivu, erare! ");
INSERT INTO kpr_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Bajari kavevera kato, ágido nundae sakai saore! Numo evevagori, ava sedo nunda javo jighoro erare! ");
INSERT INTO kpr_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Ai resira, Bajari Jacob ava gategusira. Natofo Israel embo ava nunda tofo aoro dae rurusira. ");
INSERT INTO kpr_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Na kasama erena, Bajari namonde tumonde baingheraera, nu teriari. Eini numongo tefori. ");
INSERT INTO kpr_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Nu nusuka nunda uju rea koteraira, utuda kotugo endada, eva jokáda kotugo kafuru duru bekáda ava eraira. ");
INSERT INTO kpr_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Nune eari, utu gambari utu gambari aminda borija da foroga dariraira, nune eari, biria tarighuse, borija diraira. Kotugo nune yaura nunda serukuda afigeari buvu ya foa gheraira. ");
INSERT INTO kpr_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Egypt aminda bebego sirorusera ava, evetu genembo kotugo sino fukade dabade, isasambu detiri sirivuseri. ");
INSERT INTO kpr_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Kotugo, Egypt aminda nenda kini nunda kokotofude ari ghamo baore dae use, nunda tano kotugo ari gae gitida ava, ijugedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Nune oro mendeni mendeni titighedo, kotugo nenda kini fakina kakato detiri sirivuseri. ");
INSERT INTO kpr_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Sihon, Amorite embo da kini, Og, Bashan da kini, kotugo Kainan embo da kini mane iritiriara isambu detiri sirivuseri. ");
INSERT INTO kpr_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Nune kini mane einda enda isambu nunda natofokena futusira, nunda natofo Israel embokena futusira. ");
INSERT INTO kpr_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Arie Bajari, ninda binó evovodae irarira, ninda binó evovodae sise irarera. Evetu genembo sifo amboda sirorudo yarera, ni jo bunae arera. ");
INSERT INTO kpr_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Ai resira, Bajari, nunda natofo sonembuse, nenda vara nune jifegarira. Nunda saramana embodae joka arira. ");
INSERT INTO kpr_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Oro mendeni mendenida god mane ove nu genembori, siliva (silver) kotugo goldi (gold) imi ariri. Evetu genemboimi ungoi eraera. ");
INSERT INTO kpr_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Ne beka ghaeri, avata beka jo sae eraera. Ne diti ghaeri, avata jo gae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Ne dengoro ghaeri, avata jo ningae eraera. Ne janje itatako jo asegae eraera. ");
INSERT INTO kpr_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Nanda uju evetu genembo mave god gungubo ove mane eraera, kotugo evetu genembo mave nenda tumondari ove god gungubo aikena fitiraera amo, ove god gungubo ainda kakaugo aminga ava aeteri. ");
INSERT INTO kpr_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Bajari dae sakai sevu! Israel embo nundae sakai sevu! God da fristi mane, nébarago nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Ne Levi ondi, Bajari dae sakai sevu! Mave nundae igheghi use, numoa tumonde baingheraeva barago, nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Bajari dae sakai sevu! Ne mave Saion ireva, nunda irari vasa Jerusalem aminda ireva, nemokena resena. Bajari dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Aiyakoe saore, Bajari dae, ainda susumo nu evevagori, nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Arie namondeda God, nu god mendeni irera, ainda iká bekáda irira, aikena aiyakoe sevu, nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Babojegari isambu ainda Bajari aikena aiyakoe sevu, nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Nusuka tano babaigo eari gi duduku gheraera, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Nunda kotari kasamade aimi utu etiri sirorusira, nundae sakai sevu, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Nune setiri kafuru etoda enda sirorusira, nundae sakai sevu, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Iji nengae tambuno ghae nune etiri jaragheraera, nundae sakai sevu, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Iji mo sifo kaifa are dae usira, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Tambuno damanade tumba kaifa aore dae usira, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Egypt embo vide jamena bebego isambu nune detiri sirivusera, aindae sakai sevu, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Nune giti biri namonde Israel embo Egypt ghedo buvurutuseri, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Nunda ungo fakinagoimi namonde unumbetiri buvurutuseri, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Nune setiri eva kokoigo Israel embo da dombuda sarigusira, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Sarigetiri, Israel embo nune unumbetiri sefuseri, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","O Egypt embo da kini fero nunda isoro embode nune fatiri mindi sirivuseri, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Nune giti beari, nunda natofo Israel embo evetu genembo a uvu irae vasa aminda deinghedo ghusera, aindae numokena sakai sevu, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Kini mane fakina kakato nanjogo ava, nune detiri sirivusera aindae, sakai sevu, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Kini mane binode binode ava nune detiri sirivuseri, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Amo Sihon, Amorite embo da kini avo, ainda susumo nunda dubo bari evovodae irira, ");
INSERT INTO kpr_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","kotugo Og, Bashan embo da kini detiri ambududurusira aindae barago sakai sevu, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Kini mane resera, ainda enda nune bambu nunda natofokena soro usira, nunda dubo bari evovodae irira, ");
INSERT INTO kpr_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","namondeda natofo Israel embo, nunda saramana kakato, aikena soro etiri nenda tofodae rurusera, aindae sakai sevu, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Namonde gitofu kena gofedo ghusera ainda sifoda, nu namonde itatako jo kotae ae edo ghusira, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Namonde gitofukena sainghimbe beari, namonde jebugedo ghusera, aindae sakai sevu, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Evetu genembo isambu a roera isambu endada, utukena a kotugo evada jebuga irera, ainda uvu bayau nune muturaira, aindae numokena sakai sevu, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Arie, God utuda irá gheraira aikena sakai sevu, ainda susumo nunda dubo bari evovodae irira. ");
INSERT INTO kpr_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Namonde gitofu reighida buvurutuse, ututu Saion kotise, Babylon aminda uvu iritirera, ainda betuda anumbedo dimbiya useri. ");
INSERT INTO kpr_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Amingedo, namaneda gita mane ika fatu da esege dodo, jo sekago bu divae edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Ai resira amo, Babylon embo namonde sandi budo isera, aimi yaru eminge saoro dae siseri, “Saion da yaru eni ava siruruvu, ningore!” siseri. ");
INSERT INTO kpr_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Namonde teana embo da reighida nange Bajari kena yaru gatise divareri? ");
INSERT INTO kpr_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Arie Jerusalem ko, na ni kotae arena, Bajari aso nanda ungo gimanduimi gita dari jo inono ae aeteni. ");
INSERT INTO kpr_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Arie Jerusalem ko, na nindae ivugai jarutusena ava kotae arena mo. Na yaru sari bunaeteni! ");
INSERT INTO kpr_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Arie Bajari, Jerusalem gitofuimi rurusira da sifo aminda Edom embo nange usera ava kotaetesi! Ne eminge sise, jo itako doyae tambuno use, “Jighi torerevu, vose endada fasare!” resera ava kotaetesi. ");
INSERT INTO kpr_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Babylon, nimoa titigho arera. Namanendae nange usesa aindae, mino evetu genembo mave arera ivugaghae irarera! ");
INSERT INTO kpr_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Evetu genembo mave nenda sasingu veveyako bambudo, ghamana tamonda dari fusuruma arira, ivugaghae irarera! ");
INSERT INTO kpr_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Arie Bajari, nanda janje joká isambuimi na nindae aiyakoe sarena. Ove kevarida god evetu genemboimi eraera, einda dombuda yaruimi nimoa sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Na dombu ninda kambo kakara ava fuge gosuse, tumoi bainghuse, ninda javo jighono erarira. Ainda susu mo, nimo dubo bari bekári. Ni rea sisesa ava eraesa. A kotugo ninda javo jigheso ikáda eroriri, ninda geka da fakina isagha erira. ");
INSERT INTO kpr_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Namo sonembaso dae kori sisena, ni ningido mino sisesi. Ninda fakina aimi eteso na fakina useni. ");
INSERT INTO kpr_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Arie Bajari, kini (king) kokotofu endada irera, isasambu nindae sakai sise, ninda javo jighoro erarira. Ainda susu mo, ni rea ari dae beka gagojuse sisesa amo, ne nininguseri. ");
INSERT INTO kpr_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Bajari, nine rea usesa, a kotugo ninda duró tomanakogo ava nene yaruimi isimbarera. ");
INSERT INTO kpr_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Bajari, nimo iká bekáda iresa, avata makasi embo nine kaifa tavo ururaso irá gheraera, o ivuga kakato mo, ninda dombuda jo jungae arera. ");
INSERT INTO kpr_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Namokena dara digari futo siroreraira ainda sifoda, nine kaifa urureaso jebuga irá gheraena. Gitofu namokena janje ekoko eraera amo, nine namo soredo, ninda fakina tomanakogo aimi sonembeoso na jebugeraena. ");
INSERT INTO kpr_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Ni rea ari dae beka gagojusesa ava, isasambu aresa. Bajari ninda dubo bari mo, evovodae irira. Ni saramana rea ari dae tuturo garusesa, amingudo yasi tano ase! ");
INSERT INTO kpr_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Bajari, ni na dere gido kasama e gogoghomberaesa. ");
INSERT INTO kpr_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Na rea eraena ava, isambu ni kasama eresa. Ni soka fetedo, anakora nanda kotari gi tefo eresa. ");
INSERT INTO kpr_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Na saramana arena o jangutarena amo, ni na giraesa. Nanda ari rea eraena ava, isambu kasama eresa. ");
INSERT INTO kpr_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Na beka jo sae iriono, ni giti kasama easo gido, amboda na geka seraena. ");
INSERT INTO kpr_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Ninda ungoimi, na gagara edo kosegeraesa. Ninda fakinaimi na gajeaso, dara jo itatamae eraena. ");
INSERT INTO kpr_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Nane resena, ni na kasama eresa, avata ninda kasama mo, jo nane dubo kotise kasama ari da kaugo iraeri. Ainda beká mo: ninda kasama teria a jungarida ava sedo, jo nane dubo kotise kasama ari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Na jo reda ya jungono ni tava ae aresa! Na ninda dombuda jo reda ya jungari da kaugo mo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Na utuda vitiyaetena amo, ni aminda iraso tambaeteni. O na ambari embo da vasada vosaetena amo, ni aminda iraso tambaeteni. ");
INSERT INTO kpr_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","O na rika da kaugo edo ghumbudo, eva da butu isambu darigedo, soka ya aminda iraetena amo, ");
INSERT INTO kpr_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","ni aminda irise, ninda ungoimi nanda emboro ijuguse, na sonembaetesi. ");
INSERT INTO kpr_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Na tumbakena eminge saeteni, “Fu, namo gagara ase!” O na usasa janimberaira aikena eminge saeteni, “Jovereghe, tumba jine!” ");
INSERT INTO kpr_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Aminge saeteni, avata ni tumba aindae jo kotae eraesa. Tumba jirarira o iji janimbarira, nimokena inonori. Tumba a usasa mo, nimokena inonori, jo dombu eni iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Ni na eteso, nanda tamo isambu sirorusira. Ni na budo fesa dabako eteso, na aya da tinida siroruseni. ");
INSERT INTO kpr_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Na nimokena aindae sakai seraena. Ainda susu mo: na jungarida ava eteso siroruseni. Ni rea eraesa amo, isambu eveva bekári, evetu genembo gi bunedo dudukugheraera. Ava, nanda dubo isambuimi itatamuse kasama erena. ");
INSERT INTO kpr_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Ni durumuguse kotise, nanda etu aya da tinida esimbugeteso sirorusira. Na jokáda irise babojusena ainda sifo aminda, ni kasama usesa amo, na amindari. Na jo sirorae ireno ainda gitida, ");
INSERT INTO kpr_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","ni na gosusesi. Nanda sifo nanjogo enda eminda jebuga irarena ava, ni anakora tegedo ninda bukuda gefusesi. Tegedo gefusesa amo, na jo sirorae ireno ainda sifo aminda, ni nanda sifo tegedo gefusesi. ");
INSERT INTO kpr_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Arie, God, ninda kotari mo, eveva bekári, jo nane kasama e bari da kaugo iraeri. Kotugo, ni na koteraesa amo, jo umbu dabako o etoto aminda ava, jo kotae eraesa, ni na sifo evia inono koteraesa. ");
INSERT INTO kpr_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Na ninda kotari namokena irira, ainda inono tege bari dae aetena amo, kora da ghonesa irira omo, tege tefo aeteni! Na fase avido diti fange ereraena ainda sifo aminda, na itatameraena, ni nangae dabade irera, na jo avirureono ni na jo doyae eraesa. ");
INSERT INTO kpr_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Arie, God, nanda uju mo, eviri. Ni nange ari ekoko embo daso ambaeteri! Nange gegenembo tataya kakato na do darigaoro, na nasukako iraeteni! ");
INSERT INTO kpr_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Ne nindae sise, geka eko seraera, ninda javo eoro eko eraira. ");
INSERT INTO kpr_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Arie, Bajari! Na ne imboe beká ava eraena! Mave ni imboe eraera ava, na imboe beká eraena. Mave ninda geka jo ningae irise, nimokena isoro ari dae seraera amo, na aindae imboe beká use, ningari mo beghagha eraira. ");
INSERT INTO kpr_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Ne nanda gitofu sise, na ne imboe beká use, ningari mo, beghagha eraira. ");
INSERT INTO kpr_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Arie, God! Nanda irari ijuje dere gaetesi! Nanda kotari kasama edo, na dere gido, nanda kotari tambaetesi! ");
INSERT INTO kpr_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Nanda dubo joká dere gaetesi. Ari eko eni aminda iraetira amo, tambu seghe fugedo, na unumbe bu giti jijighururaso, na jebuga evovodae irari ainda emboro ava tambaeteni! ");
INSERT INTO kpr_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Arie Bajari, namoa ari eko embo aikena sonembe bu darige! Evetu genembo jiro ghambura aikena na kosege fete. ");
INSERT INTO kpr_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Ne evovodae ari sembae ari dae manaka garuse, sifo ghousa nene gayeoro, mendeni avo ghoghora tataya kunumberaera. ");
INSERT INTO kpr_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Nenda aviva kau jingabu ekoko ainda kae amingori, geka nenda bekada buvuraira ava, jingabu jumi da kae da kaugori. ");
INSERT INTO kpr_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Arie Bajari, namoa jiro ghambura embo da ari ekoko aminda kosege fete, nandae janje ekoko tefo tefo use, namo ambono dae manaka eregarera. ");
INSERT INTO kpr_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Meka irae ivuga kakato namoa ufena dari dae vagho junge fiti simbugerera, ne asi aimi ivasi ututedo nanda emboro aminda namoa ivasi e bari dae fifituseri. ");
INSERT INTO kpr_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Na Bajari kena resena, “Nanda God nimori.” Arie Bajari, mema use namo sonembaso dae sorara erena, ningi! ");
INSERT INTO kpr_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Arie Bajari, nanda Bajari, nanda sorega ari kato nimori. Isoro jokada na daetera ava, nandae sorega nine usesi. ");
INSERT INTO kpr_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Arie Bajari, ari ekoko embo nenda kotari da uju beká rejo dae use manaka eregarera ava, erá eoso, beká siroreure! ");
INSERT INTO kpr_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Erá eoso, ari eko emboimi nandae ivugai atai feteore! Namoa kateyavara use, geka ekoko resuterera, nange geka daba aimi jighi jovereghe nemoa gambare! ");
INSERT INTO kpr_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Avaraka imo kokoigo veriverigo ava mutu nenda etoda dudurugare! Ne bambu goroghe, bako eko aminda vovosegedo vitari bunedo iritirore! ");
INSERT INTO kpr_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Evetu genembo mave kokomana dae aji sise, nenda javoda geka gungubo gesire eraera, ava aso gogofe gaore! Aso, ghambura evetu genembo aikena, dara dombu eni dombu eni aimi ari sirivo aore! ");
INSERT INTO kpr_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Bajari, namo kasamari, makasi embo rejo dae mema eraera, nine sorise sonembaresa. A kotugo evetu genembo mave makasikena katiyavara eraera, aikena nine gitofo edo, vara jifegeraesa. ");
INSERT INTO kpr_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Beká resena, mave ni tumonduse ninda sari ava nembo eraera, ne ninda dombuda jebuga fetirise, nindae aiyakoe sise irarera. ");
INSERT INTO kpr_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Arie Bajari, na nimokena kori resena, na oroko nembako senembaso dae resena! Na sifo reda senembaso dae benunu sarena, ningi! ");
INSERT INTO kpr_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Ungobughae joba nimokena dungutuse, yabiyabina dungoro muno viviturureari, ivuga eraesa aminga ava, na sifo reda benunu sise, ungo nimokena jighono erarira, ivuga aminga ava aso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Arie Bajari, erá geka sembae seono dae sise, nanda beka tavo aso dae resena! Kaifa kato eini gategaso, fetedo nanda avivi kaifa are! ");
INSERT INTO kpr_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Erama sembae kotise ari ekoko eono dae sise, nanda dubo joká kaifa aso dae resena. Erá doyeoso, na ari eko embo da kirumo aminda ya nemonde dabade tatedo, nenda aito ava fugeone! ");
INSERT INTO kpr_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Genembo eveva aimi na dengoro induduse, dombuda sarira amo, nandae kavevera use aminge sarira. Avata, ari ekoko embo nandae sakai sari sarera amo, na itoko jo ningae arena. Ainda beká mo, nenda ari ekoko beká eure dae sise benunu seraena. ");
INSERT INTO kpr_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Nenda babojegari sifo reda bambu ghotaghaoro, fanada dudurugarera, evetu genembo gido, kasama arera, Bajari da geka mo bekári. ");
INSERT INTO kpr_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Kau ika faragho sare gafe kiro karo eraera aminga ava, gitofui etero, namaneda etu mane ofofo bako bekada soesa mainge mainge edo iritirera. ");
INSERT INTO kpr_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Avata, arie Bajari nanda God, nanda tumondari nimokena fifituse irena. Namo gagara aso dae sise, eraena. Erá doyeoso, na deoro ambeone! ");
INSERT INTO kpr_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Namo ivasi ari dae vagho fifiterera aminda, na gagara e! Ari ekoko embo da ivasi fitari aminda na kosege fete. ");
INSERT INTO kpr_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Aso, ari ekoko embo totofo nenda vaghoda tetururoro, nemoa ivasi ururari na jo dae doyoro yari resena. ");
INSERT INTO kpr_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Na Bajari namo sonembare dae koko fuge sorara use, ghasegai isimberaena. ");
INSERT INTO kpr_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Nanda mema janje jokáda isambu numokena averegeono, ningiraira. Nanda mema isasambu numokena se tefo eraena. ");
INSERT INTO kpr_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Na sifo reda gofedo ghamo takegha urureari, na nange aetena ava, nu kasama eraira. Nanda emboro evovodae aminda ya gheraena aminda, gitofu namoa ufena sandari dae vagho junge fifituseri. ");
INSERT INTO kpr_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Nanda tingu tanga fuge gosuse, imana samana eraena, avata tofo da kaugo eni jo gae eraena. Ne na bunariri, namo sorari embo eni tefori. Nandae genembo mave jo sae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Arie Bajari, na sonembadae mema use, nimokena resena, “Bajari nanda gagara ari kato nisuka nimori. Enda eminda irise nisuka nimoa uju eraena.” ");
INSERT INTO kpr_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Namo sonembaso dae ghasega resena, ningi sonembe! Na gofedo, rojari beká erena. Nanda gitofu fakina kakatori. Na jo nemongo iraeri. Ágido namoa sonembe bu darigaso dae resena. ");
INSERT INTO kpr_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Na memai bundetiri irena, vujegaso jebugaone! Amingaresa, ni nandae kavevera tomanako beká eraesa aindae, na ninda natofo tafaroro ururoro, ainda jokáda fete irise, nindae sakai sarena. ");
INSERT INTO kpr_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Arie Bajari, nanda banungari ningi! Ninda natofokena bekáda bekáda eraesa. Aminguse, nanda benunu ningi! Ninda sari ava nembo eraesa. Aminguse, na sonembe! ");
INSERT INTO kpr_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Na ninda saramana katori. Avata, erá nanda eko ijujeose! Ai resira amo, ninda dombuda jo evetu genembo eniimi fetari inono iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Nanda gitofuimi na ondi sandi budo fugetiri dureno, atai fati gitetiri faseteni. Na bu vasa tumbago ainda jokáda fitiri na kau ambari embo anakora ambududurusera, aminga ava erena. ");
INSERT INTO kpr_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Ava sedo, na kotari dadabetiri ambari dae itako erena. Arie namoako, na nange aeteni, ava erebunena. ");
INSERT INTO kpr_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Ni nange edo ghusesa, ava kotise irena. Na ninda tano duroghae udo refesa, isambu kotedo gherena. Ni nange usesa isambu ava erekotena. ");
INSERT INTO kpr_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Na banunguse, nanda ungo jigheono ereraira. Kau dubo sagheari, uvu mindari dae angasa angasa eraera aminga ava, nanda asisi nimoa tambari dae uju erira. ");
INSERT INTO kpr_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Arie Bajari, tavaraghe foa, nanda benunu ningaetesi! Erá nandae jungeose! Ninda dombu namokena jungaresa amo, na anakora ambudo ambari embo da vasada vosarena. ");
INSERT INTO kpr_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Ni tumonduse irena, ágido sifo ghousa ataeghae ninda dubo bari ava ijugururu, gaone! Nanda asisi isambu futuse nimokena benunu sise irá gheraena, ava sedo nanda emboro ijugururu, yaone! ");
INSERT INTO kpr_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Arie Bajari, na nimokena afote fetari ya gheraena. Namoa gitofukena saghimbe bu darige! ");
INSERT INTO kpr_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","God nane tumonde baingheraena amo, nimori. Ninda uju ava ijuge, ava aone! Ninda asisi eveva aimi na ununbe, emboro evevada yaone! ");
INSERT INTO kpr_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Arie Bajari, ni nange ari sisesa ava use, namoa gitofukena saghimbe bu darige! Ninda kavevera eraesa aimi na sonembe, mema namokena foa gheraira ava darigaone! ");
INSERT INTO kpr_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Ni na dubo buraesa aindae, nanda gitofu isambu dive gafe sirivu e tefo aore! Na ninda saramana kato, ava sedo evetu genembo na daoro ambono dae aito eraera, isambu sosighi e! ");
INSERT INTO kpr_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Bajari, namo gagara ari katodae sakai saore! Na ambi goroba jighono dae nune ijuguse, isoro aono dae fakina muturaira. ");
INSERT INTO kpr_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Nu sifo ghousa namoa dubo ruruse, na gagara eraira. Nu nandae sorega fumburaira, na nunda itumuda iriono, nune seari jebugeraena. Nanda tumondari numokena fifituse, na jebuga irá gheraena. Nune oro oro isambu fiteari vose, nanda duruda irioro, nane kaifa eraena. ");
INSERT INTO kpr_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Arie Bajari, genembo mo, rejori? Nu jo rejo eni iraeri, ava ni redae koteraesi? Nu taká tefo genembo, ágido redae bu tavo tatau eraesi? ");
INSERT INTO kpr_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Numo taká kau janje asegeraera, ainda kaugori, nunda jebuga, foroga iji gajeari, yaurai bu fuseari itumu totoi totoi ya dadaberaira, amingori. ");
INSERT INTO kpr_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Arie Bajari, utu jighi torere afige vose fu! Kunikada doriri mane sire jighi imbosi gubighare! ");
INSERT INTO kpr_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Biria barara mutu tarighuse, ninda gitofu ondari taraghaore! Ninda feva aimi afuse ondiruru, oju sumbore! ");
INSERT INTO kpr_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Ninda ungo utudaghe sirege vosefurari, na kafurudaghe jumbu vitone! Bu darigaso jebugaone! Oro mendeni da fakina kau irae aikena na bu darige! ");
INSERT INTO kpr_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Gitofuá geka beká eni itako jo sae eraera. Nenda geka tumondaoro dae God da javono gatise, beka gajeraera, avata aminda beká eni tefori. ");
INSERT INTO kpr_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Arie God, na nindae yaru seka gate divarena. Na gita doruse nimokena yaru sarena. ");
INSERT INTO kpr_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Mave seari, kini (king) mane nenda gitofu sosighi e atai fati fateraera, amo nimori. A kotugo mave, ninda saramana kato, David, bu darigeari jebugedo gherira, ábarago nimori. ");
INSERT INTO kpr_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Oro mendenida fakina kau irae aikena na bu darige! Gitofuá geka beká eni itako jo sae eraera. Nenda geka tumondaoro dae God da javono gatise, beka gajeraera, avata aminda beká eni tefori. ");
INSERT INTO kpr_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Amingaresa amo, namanenda vide jamena seka bajarera amo, faragho faragho eveva ikai bajarigarera. Namanenda sasingu ade jamena mendode sovode gari garigo kini (king) da nati botou da faiya gembari gengebago aminga ava bajarigarera. ");
INSERT INTO kpr_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Namanenda bayau seruku vasa bayau nunda dombu dombu aimi bedo ururari, namanenda sifi da mamandi ghagurugo 10,000 darigedo siroruse irari garera. ");
INSERT INTO kpr_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Namanenda burumakau da mamandi nunda sifoda eveva fumbu averegarera. Namaneda reighi jokáda jivu menjuga jo gutae aeteri. ");
INSERT INTO kpr_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Geka isuru erena evia, oro mavekena beká arira amo, ivuga ghae irivu! Evetu genembo Bajari nenda God dae budo numoa tumonde baingharera amo, ivugaghae irarera! ");
INSERT INTO kpr_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","God nane tumonde baingheraena, a kotugo, nanda kini mo nimori. Nindae sakai sise, ninda javo teria ava jighono iká bekáda erarira. Na nindae sifo ghousa a kotugo, evovodae aiyakoe sise, irá gharena ");
INSERT INTO kpr_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Sifo ghousa na nindae aiyakoe sedo gharena. Nindae sifo ghousa a kotugo evovodae sakai sise irarena. ");
INSERT INTO kpr_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Bajari mo, nu teriagori. Sakai numoa sari evevari. Numo teriago bekári jo kasama arida kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Nine rea usesa aindae, namane oroko jebuga irera, nindae sakai sido iruroro, namaneda sasingu ningido, némbarago eredo, nenda sasingukena saoro ningido osa sarera. ");
INSERT INTO kpr_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Ninda duró usasaghae ava osa siruroro ningido, ninda ari gae gitida ututeraesa ava, nanda janje jokai kotedo gharena. ");
INSERT INTO kpr_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Ninda ari gae gitida ututeraesa setena, ava natofoi osa siruroro, ninda bino teria aindae nane barago vironu sedo gharena. ");
INSERT INTO kpr_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Evetu genembo isasambu ninda aito eveva aindae osa sise, ninda kavevera teriago ava yaruimi isimbarera. ");
INSERT INTO kpr_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Bajari mo, dubo bari a kotugo, joka ari katori. Nunda dubo bari mo, evovodae irira, a kotugo gaimboghae janje ekoko eraira. ");
INSERT INTO kpr_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Nu evetu genembo isasambudae kavevera eraira, a kotugo roera isasambu nune usira aindae joka eraira. ");
INSERT INTO kpr_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Arie Bajari, endada utuda a kotugo, evada roera nine usesa isasambu nindae sakai sarera. A kotugo, ninda natofo isasambu nindae aiyakoe sarera. ");
INSERT INTO kpr_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Ni kini (king) edo iresa da duró ainda binó ava osa sarera. Aminguse, ninda fakina teriago aindae isagha sarera. ");
INSERT INTO kpr_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Evetu genembo isasambu ninda tano babaigo gae gitida ututusesa ava kasama aoro dae sise, a kotugo, ni kini edo iresa ainda duró fakinaghae kasama aoro dae sise, amingarera. ");
INSERT INTO kpr_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Nimo utu enda a kotugo, eva da kini edo evovodae iresa. Bajari, rea beka gagojuse, ari dae sisira ava, nune eraira. Nu rea eraira amo, joka use eraira. ");
INSERT INTO kpr_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Bajari mave mema use goferaira ava, nune sonembeari jebugeraira. Gogofegedo irera, ava jijighurureari ere feteraera. ");
INSERT INTO kpr_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Endada evetu genembo, sino fuka, sivoro kororo, eva da oka mane gindovi gandovi isasambu diti nimoa gosuse gigiturureoro, nenda baimara sifoda nenda bayau inononda muturaesa. ");
INSERT INTO kpr_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Ni ungo isambukena javoregheoso nenda uvu bayau inonoda buraera. ");
INSERT INTO kpr_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Bajari da aito fugari isambu dambugo bekári. Nu rea eraira amo, joka use eraira. ");
INSERT INTO kpr_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Evetu genembo mave bekáda bekáda janje isambuimi Bajari dae kori sarera, nu anakora utua edo irira. ");
INSERT INTO kpr_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Evetu genembo mave Bajari kakara eraera aikena reju ava daiva eraira, nune nemokena muturaira. Ne nanjigo numokena kori seraera, nune ningido sonembeari jebugeraera. ");
INSERT INTO kpr_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Evetu genembo mave Bajari dubo buraera ava gagara eraira. Avata, ari ekoko use irá gheraera ava deari sirivo eraera. ");
INSERT INTO kpr_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Namo sifo ghousa Bajari dae sakai sise irá gharena. Utuda endada evada reju ava jebuga irira, aikena resena, evovodae nunda javo kakara aindae sakai sise, nunda javo jighovo erare. ");
INSERT INTO kpr_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Bajari dae sakai saore! Arie namoako, nanda dubo jokáimi Bajari dae sakai saone! ");
INSERT INTO kpr_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Na Bajari dae sakai sise irá ambari tano, na sifo ghousa God nane tumonde baingheraena aikena, yaruimi sakai sise irarena. ");
INSERT INTO kpr_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Nenda tumondari erá endada evetu genembo da babojegari kena fitiove! Endada evetu genemboimi jo saoro jebugae areva. ");
INSERT INTO kpr_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Ne sifo reda ambarera, ne jovereghe fonja jinarera, sifo aminda ne rea ari dae kotisera, isambu soesa tefo arira. ");
INSERT INTO kpr_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","God, Jacob tumonde bainghedo ghusira aimi maveju ava sonembarira amo, ne ivugaghae irarera. A mave nenda gigitari God kena fitarera, nébarago ivugaghae irarera. ");
INSERT INTO kpr_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","God, utu, enda a eva, kotugo roera ainda jokáda iritirira, isasambu nune etiri sirorusira, aimi rea ari dae seraera ava, nune edo gherira. ");
INSERT INTO kpr_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Nu ijujuse, evetu genembo gitofuimi mema futero, mema itatamuse irera, ava soreraira. Kotugo baimara eretafera ainda bayau, nune muturaira. Bajari, nune dibura embo seari dibura do buvututururoro, ");
INSERT INTO kpr_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","diti digoide seari sifo sevo giraera. Evetu genembo gofedo irera, ava, Bajari nune jighiari ereraera. Evetu genembo dambugo mo, Bajari nune dubo buraira. ");
INSERT INTO kpr_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Teana embo namondeda reighida irera ava, Bajari nune kaifa eraira. Roriri nenda sasingu babatede nenda sonemba nune eraira. O ari ekoko embo da kotari nune eari beje soesa eraira. ");
INSERT INTO kpr_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Bajari mo kini (king) edo evovodae irira. Arie Israel embo, reighi Saion ireva, nenda God ne evovodae kaifa use irarira. Bajari dae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Bajari dae sakai saore! Ainda susu mo, namondeda God ava yaruimi sakai sise sari mo, evevagori! ");
INSERT INTO kpr_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Bajari nune Jerusalem gitofuimi bejisera ava, ari fatonga arira. Israel embo gitofui bambu isera ava, sekago bu jovereghe refira. ");
INSERT INTO kpr_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Ghamo memai bunedo irera, ainda gambisi ava nune doghedo seari jebugeraera. ");
INSERT INTO kpr_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Nu damana nanjogo uju usira ava, setiri siroretiri, isambu nenda javo javo nune jijighusira. ");
INSERT INTO kpr_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Namondeda Bajari mo teriago a fakinago bekári. Nunda dubo kotari jo maveda tega iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Tumo darido irari embo nune soredo jighiari ereraera. O eko embo mo, nune endada kambata eraera. ");
INSERT INTO kpr_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Nenda bekaimi Bajari dae aiyakoe sise yaru sevu! Gita doruse, nundae yaru gatevu! ");
INSERT INTO kpr_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Nune forogaimi utu doghedo simbugeari, borija endada dido eari, kunikada eke batuno use vivitigeraira. ");
INSERT INTO kpr_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Bao oka da bayau nune muturaira. A ogha mamandi bayaudae kori sirurureoro nune unduraira. ");
INSERT INTO kpr_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Hosi da tutu ava numokena jo rejo eni iraeri, kotugo isoro genembo da fakina aindae, nu jo kotae eraira. ");
INSERT INTO kpr_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","O mave nundae igheghi use, nu kakara eraera aikena, ivuga eraira. Kau daba aminga ava, mave nunda dubo bari a kavevera tumonduse irera, nendae ivuga eraira. ");
INSERT INTO kpr_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Arie! Jerusalem embo, Bajari dae sakai sevu! Saion aminda ireva, nenda God dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Ai resira amo, nenda furuda guru mane ava isambu nune kaifa urureari eveva irá gheraeva. Nenda natofo aminda isambu, nune esimbugeraira. ");
INSERT INTO kpr_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Nenda reighida tano nune kaifa urureari, gitofu terari manamana use irá gheraera. Nenda farava vuji garigarigo ava nune futurureari, inonoda budo gheraeva. ");
INSERT INTO kpr_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Nune endada nunda uju ava sirorare dae seari nunda uju seraira ava, totoi nembo siroreraira. ");
INSERT INTO kpr_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Aisi (ice) yaurago ava nune muteari borija dirarigo use vose enda afuregeraira. Sifo daba daba aisi muteari, mungaghae vose avegha fonja raraghari ghedo enda afurugeraira. ");
INSERT INTO kpr_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Nu borija dombu eni aisi babai yaurago ava averegeari jeviri da udumu aminga ava vose faseraira. Yaura nune nanjigo muturaira, mave ainda jokáda fetari jo inono iraeri. ");
INSERT INTO kpr_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Avata nune seari aisi amo tiveraira. Yaura vevera sumbare dae seari tivedo uvu sumburaira. ");
INSERT INTO kpr_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Nunda geka nunda natofo Jacob da sasingukena mutudo gheraira. Nunda ijuga kotugo Agho Dari ghaseari nunda natofo Israel embo buraera. ");
INSERT INTO kpr_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Nu oro mendenidae jo amingaeri, nunda Agho Dari ne bunariri. Bajari dae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Bajari dae sakai saore! Ne utu iká bekáda iritireva, aimi utudaghe Bajari dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Nunda aneya mane isambu, nunda isoro embo utuda ireva, nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Iji nengae tambunoghae, nundae sakai sevu! Damana mane jaraghuse nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Utu iká bekáda kotugo borija utu ikáda jungedo irira, aimi nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Ne isasambu Bajari da javo jighovo erare dae resena! Ainda susu mo, nune setiri, ne sirorusevu. ");
INSERT INTO kpr_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Nunda sarida, ne nenda vasada siroredo, evovodae aminda iritirera. Nu nange setiri fetirera, ainda geka ava ne jo bu fugae arera. ");
INSERT INTO kpr_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Enda emindaghe, eva da oka mane, kotugo karaje kafuru jokáda gambauva iritirera aimi, Bajari dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","Biria barara, borija dombu eni aisi yaurago diraira, a kotugo yaura vovoga isambu ne nunda sari ava ningiraeva. ");
INSERT INTO kpr_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Enda jiro fumbari, doriri mane, taima da ika mane, kotugo mindari vuji da ika mane nanjogo, aimi nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","Sino fuka tamo dari tamo dae isasambu, jingabu, sivoro kororo, kotugo rika mane aimi nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Kini mane isasambu, natofo nanjogo ireva, gavana mane, sabua kokotofu nanjogo ireva isasambu aimi, nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","Ade mose, yarata seka bajari, evevetako embabako, kotugo sasingako barago isasambu aimi nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Ne isasambu Bajari da javo jighivo erare dae resena! Nunda javo mo, javo isasambu ainda iká bekádari. Nunda duró mo, utu enda ainda iká bekádari. ");
INSERT INTO kpr_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Nunda dubo bari natofo Israel embo mo, nune etiri fakina edo irera. Susu aindae nunda natofo isasambukena resena, Bajari dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Bajari dae sakai saore! Arie, endada evetu genembo isambu, Bajari dae yaru seka sevu! Nunda natofo tafarorodae totorugarera, ainda jokáda nunda javo jighoro erare! ");
INSERT INTO kpr_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Israel embo, nune setiri siroruseva aindae, ivuga evu! Ainda susu mo, Saion embo nu nenda kini (king) edo irira aindae, gogho edo, divu fusedo ghevu! ");
INSERT INTO kpr_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Divu fusedo ghuse, nunda javo jighivu erare! Sino da dukaimi gita da javimi nundae sakai saore! ");
INSERT INTO kpr_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Ai resira amo, Bajari nunda natofo dae ghamo buraira. Nu tumbari embo ava binóde aoro dae sise, nenda gitofu sosighi eraera. ");
INSERT INTO kpr_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","God da natofo gitofu da vasa sosighi usera aindae, ivugai jarutuse, tumba soró aminda yaru ivugai roro bambarera. ");
INSERT INTO kpr_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","God dae sakai koko fuge sise, saoro dae resena. Nenda isoro da kaiya dika soveni soveni siverego ungoi bambu jighirise, ");
INSERT INTO kpr_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","oro mendeni ava atai duboda fatido, natofo mendeni daoro ghamo barera. ");
INSERT INTO kpr_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Ainda natofoda kini (king) kokotofu ava seinimi bundarera. Nenda babojegari seini auri arimi bundarera. ");
INSERT INTO kpr_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","God da sari ava use, ne oro mendeni ava daoro ghamo barera. Setena amingarera aimi God da natofo da duró isagha arira. Bajari dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Bajari dae sakai sevu! God nunda Kambo Kakara jokáda irira, nundae sakai sevu! Nu utuda irise, nunda fakina ijugeraira aindae, nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Nunda ari fakina rea edo ghusira aindae, nundae sakai sevu! Numo teria bekári aindae, nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Tavuya bu fusise, nundae sakai sevu! Gita dombu eni dombu eni roera mendeni avavaga bu doruse, nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Divari sino bu doruse ivisa use, nundae sakai sevu! Sino (guitars) bu doruse, a feku fusise, nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Roera ghasaghasa, baighara avavaga bu ivisa use, nundae sakai sevu! Roera eni simbaro (cymbals) seraera, mereki da kaugo ava ungo soveni-soveni bu doruse, fumbu aruguse, nundae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Evetu genembo, sino fuka, ã roera jebuga irise, ghamo asegeraera isambu, nundae sakai sevu! Bajari dae sakai sevu! ");
INSERT INTO kpr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","David nengae Abraham ghae da imendi, Iesu Keriso ri. Nunda nombuamane da kiki mo eviri. ");
INSERT INTO kpr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham da mandi mo Isaac ri. Isaac da mandi mo Jacob ri. Jacob da vide jamena mendeni, ne Judah de dabade siroruseri. ");
INSERT INTO kpr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah da vide jamena etoto naká, Perez nengae Zerah ghaeri. (Perez nengae Zerah ghae da noi javo mo, Tamar ri.) Perez da mandi mo Hezron ri. Hezron da mandi mo Ram ri. ");
INSERT INTO kpr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram da mandi mo Amminadab ri. Amminadab da mandi mo Nahshon ri. Nahshon da mandi mo Salmon ri. ");
INSERT INTO kpr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon da mandi mo Boaz ri. (Boaz da noi javo mo, Rahab ri.) Boaz da mandi mo Obed ri. (Obed da noi javo mo, Ruth ri.) Obed da mandi mo Jesse ri. ");
INSERT INTO kpr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse da mandi mo David ri. Nu namonde Israel embo da kini (king) nune usira. David da mandi mo Solomon ri. (Solomon da noi mo, giti Uriah kena vai edo iriri, David saghimbe rurusira). ");
INSERT INTO kpr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon da mandi mo Rehoboam ri. Rehoboam da mandi mo Abijah ri. Abijah da mandi mo Asa ri. ");
INSERT INTO kpr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa da mandi mo Jehoshaphat ri. Jehoshaphat da mandi mo Joram ri. Joram da mandi mo Uzziah ri. ");
INSERT INTO kpr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah da mandi mo Jotham ri. Jotham da mandi mo Ahaz ri. Ahaz da mandi mo Hezekiah ri. ");
INSERT INTO kpr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah da mandi mo Manasseh ri. Manasseh da mandi mo Amon ri. Amon da mandi mo Josiah ri. ");
INSERT INTO kpr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah da vide jamena mendeni, ne Jechoniah de dabade siroruseri. Sifo aminda, Babylon emboimi fera namonde Israel embo da abuamane ava, sosighi edo nenda reighi Babylon aminda budo iseri. ");
INSERT INTO kpr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Budo ero, Jechoniah da mandi Shealtiel aminda sirorusira. Shealtiel da mandi mo Zerubbabel ri. ");
INSERT INTO kpr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel da mandi mo Abiud ri. Abiud da mandi mo Eliakim ri. Eliakim da mandi mo Azor ri. ");
INSERT INTO kpr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor da mandi mo Zadok ri. Zadok da mandi mo Achim ri. Achim da mandi mo Eliud ri. ");
INSERT INTO kpr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud da mandi mo Eleazar ri. Eleazar da mandi mo Matthan ri. Matthan da mandi mo Jacob ri. ");
INSERT INTO kpr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob da mandi mo Joseph ri. Joseph mo nu, Iesu da noi Mary da nuvuri. Iesu resena eindae, natofoimi seraera, “God Genembo eni mutari sisira amo, numori,” aminge seraera. ");
INSERT INTO kpr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Avori, Abraham tano ghe fira David kena buvurutusira ainda soro aminda, Iesu da nombuamane 14 ava sirivo udo fuseri. Tano David tano ghe fusira aminda, Babylon emboimi fera namonde Jusi embo da abuamane ava sosighi usera, ainda soro aminda barago, Iesu da nombuamane 14 ava sirivo udo fuseri. A kotugo, sifo aminda ghedo fira Iesu sirorusira, a barago, nunda nombuamane 14 ava sirivo udo fuseri. ");
INSERT INTO kpr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Keriso nange nange sirorusira, amo eviri. Iesu da noi Mary ava, genembo Joseph kena datu didighuseri. Datu dighero, nengae nunda nunda irise, Mary nu Asisi Kakara da fakinaimi kauri usira ava, itatamusira. ");
INSERT INTO kpr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mary nu kauri etiri gido, nunda datu genembo Joseph, bune jaredo Mary doyari kotisira. Avata nu genembo evevari, a nu sifo ghousa kotofuko da ari ava edo ghusira. A gido, erá meka geure dae sise, nu ufena doyari kotisira. ");
INSERT INTO kpr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nu ava kotise, aturu usira. Aturuda, aneya numokena isagha etiri gosusira. Giri, aneya Joseph kena sisira, “David da imendi, iresa. Ninda datu gagara Mary, ava fitarésa! Jo oju ae aresa. Ainda beká mo: nu jo emboroda kauri aeri. Nu Asisi Kakara da fakinaimi, kauri edo irira. ");
INSERT INTO kpr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nu mandi fumbarira amo, nunda javo Iesu, ava jighareva! (Javo Iesu da tuka mo: ‘Sari Jebugari Katori’.) Iesu jighareva, ainda beká mo: nunda natofo da ari ekoko da bouvu, nune fumbarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Setiri dadabetiri, Joseph diti fangedo erorusira. Eredo, Bajari da aneya rea numokena sisira ava use, Mary fifitusira. Fifitusira avata, nengae jo dabade avae irise, nu mandi fufusira. Fumbiri, Joseph mandi ainda javo Iesu jijighusira. Ari evia sirorusira amo, jo tefo siroraeri. Susudae sirorusira. God nu rea nunda ferovetakena setiri gefusira, ava beká are dae sedo sirorusira. God setiri, geka gefusira amo eviri: “Gagara seka eni genemboghae jo avae irise, kauri edo mandi fumbarira. Fumbari, natofo mandi ainda javo Emmanuel jigharera. (Emmanuel da tuka mo: ‘God Namonde Dabade Irera’.)” ");
INSERT INTO kpr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu nu frovensi Judia aminda, reighi javo Bethlehem ainda jokáda sirorusira. Genembo javo Herod, nu kini (king) edo frovensi Judia, nune kaifa edo ghusira. Iesu siroretiri ainda amboda, gegenembo mendeni damana da aito ava gi kasama edo ghusera aimi, iji vitarikena ghedo fera, reighi Jerusalem aminda buvudo ");
INSERT INTO kpr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ategi useri, “Kokoi Jusi embo da kini (king) ari dae sedo, sirorumutara amo, redari? Nunda damana iji vitarikena ominda, vivitiri gido, namane numo tambudo tumonde bainghari dae sedo referere,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aminge setero, Kini (King) Herod manamana usira, Jerusalem embo isambude dabade. ");
INSERT INTO kpr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Manamana edo, Herod setiri fristi+ da babojegari, Moses da Geka ijuga kakatode+ dabade fera totorugetero, Herod nemokena ategi usira, “God Genembo eni dirigari furare dae sisira amo, reda siroraeti?” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aminge setiri, ne siseri, “Nu frovensi Judia ainda jokáda, reighi Bethlehem aminda siroraeti. God setiri nunda feroveta eniimi geka aindae, eminge gefusira: ");
INSERT INTO kpr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Frovensi Judia aminda, reighi Bethlehem ainda bajari jo kitako iraeri. Frovensi Judia ainda babojegari mendeni, ne jo numongo iraeri. Ainda beká mo: Bethlehem jokáda Bajari tomanako eni siroredo, nanda natofo Israel embo kaifa arira.’” Fristi+ da babojegari a Moses da Geka ijuga kakato+, aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Setero dadabetiri, Herod ufena aghi etiri, kasama kakato iji vitarikena ghedo fusera amo, fera Herod de dabade geka siseri. Kokoi da damana nanjigo isagha etiri gosusera ava, nene setero Herod niningusira. ");
INSERT INTO kpr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ningido, ne diriguse sisira, “Yasivu, tava e gogoghombedo kokoiá tambove! Tambareva amo, fuvu saovo, nambarago yama kokoiá tambudo tumonde bainghaonasi!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Setiri, ne Herod do eredo era soroda, damanaá sekago gosuseri. Damana, ne giti nenda reighi iji vitarikena aminda gosusera, daba ava gosuseri. Gido, damana da amboda amboda udo iseri. Era, damana mo, kokoi da irari vasa ainda ikáda jaraghiri gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Damana aminda jaraghiri gido, ivuga ambari ava useri. ");
INSERT INTO kpr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ivuga use, kambo aminda teredo mandiá noi Mary ghae gosuseri. Gido, kauboi dadarigedo, mandiá tumonde bainghuseri. Amingedo, nenda javo afigedo, joba mandikena futuseri. Auri ‘gold’, ika javo frankinsens (frankincense) ainda muka, a ika eni javo moor (myrrh) ainda muka ava futuseri. ");
INSERT INTO kpr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mutudo, ne aminda avise aturu useri. Aturuda God nemokena sisira, “Ne jo Herod kena jovereghe yae areva. Ne Herod dodo, emboro eninda yasivu!” aminge sisira. Setiri ningido, ne aminguseri. ");
INSERT INTO kpr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kokotofu eredo ero, Joseph aturu usira. Aturuda, Bajari da aneya numokena isagha edo sisira, “Eredo, nearo mandighae budo, reighié dodo, Egypt aminda sumbu yasivu! Aminda buvudo irovo, amboda saono jovereghe furareva. Ainda beká mo, Herod mandiá dari ambare dae tava erira.” ");
INSERT INTO kpr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aminge setiri, Joseph eredo noaro mandighae budo, tumba daba aminda reighi Egypt iseri. ");
INSERT INTO kpr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Era buvudo aminda irero, Herod ambiri gido ainda amboda, jovereghe fuseri. Bajari setiri ne amingusera amo, jo tefo aeri. Nunda geka rea setiri feroveta eniimi gefusira ava, beká are dae sedo, nune setiri ne aminguseri. Nunda geka ferovetakena setiri gefusira amo, eviri: “Nanda Mandi dae kori seteno, Egypt ghedo buvudo fusira,” feroveta aminge gefusira. ");
INSERT INTO kpr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod kokotofu iji vitarida ghe esa fera numo dederusera, ava kasama edo, janje eko usira. Janje eko etiri, reighi Bethlehem a reighi mendeni ainda tinguda irera, ainda vide jamena ghaeko etoto jo darigae iriara, ava daoro amboro dae sisira. (Kokotofu damanadae rea Herod kena sisera ava kotise, nu ghaeko etoto sisira.) ");
INSERT INTO kpr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Setiri amingero, feroveta Jeremiah rea sisira ava, sirorusira. Jeremiah nu eminge sisira: ");
INSERT INTO kpr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Reighi Rama aminda, dimbia sorara ero nininguseri. Novia Rachel nunda sasingudae dubo mema use, sorara janjagu usira. Nunda sasingu isambu amomonjegusera aindae, dubo memai fira nu fure gagojusira. Mave foa nu jo eghovo dari irae beká ava usira,” Jeremiah aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Joseph nu reighi Egypt aminda iriri, Herod ambiri ainda amboda, Joseph aturu usira. Aturuda, Bajari da aneya sekago numokena isagha edo, ");
INSERT INTO kpr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","geka sisira, “Evetu genembo, mandi daoro ambare dae kotisera amo, ambududuruseri. Ava sedo, eredo nearo mandighae budo, reighi tomanako Israel aminda, jovereghe yasivu!” aneya aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Setiri, Joseph eredo mandiá noighae budo, nemonde jovereghedo reighi tomanako Israel aminda iseri. ");
INSERT INTO kpr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Archelaus nu, numamo Herod da vasa budo kini (king) edo, reighi tomanako Israel da frovensi eni javo Judia ava, nune kaifa edo ghusira. Ava ningido, Joseph aminda anumbari oju usira. Oju use iriri, aturuda, geka mendeni ijugetero ningido, eredo noaro mandighae budo, nemonde frovensi Galilee aminda iseri. ");
INSERT INTO kpr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Era, reighi Nasareth aminda dighi anumbuseri. Joseph nu jo tefo amingaeri. God nunda geka ferovetakena setiri gefusera, ava beká sirorare dae sedo, God setiri Joseph amingusira. Feroveta rea gefusera amo, eviri: “Natofoi nundae, ‘Nu Nasareth embori,’ sarera.” aminge gefuseri. ");
INSERT INTO kpr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ainda amboda, John Bafataito Ari Kato ira reighi, uvu a evetu genembo irae da vasa frovensi Judia aminda, tuturo edo vironu sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Vironu eminge sedo ghusira, “God nunda natofo+ kaifa ari da sifo ojighira utuako erira. Ava sedo, fuvu eminda, nenda ari ekoko vujegedo doyove!” aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Feroveta Isaiah anakora beká nunda buku jokáda John da saramana aindae, eminge gefusira: “Mave reighi uvu a evetu genembo irae da vasa aminda fetirise, beka fainghedo geka resira: ‘Bajari da emboro rerebevu dambu are!’” aminge gefusira. ");
INSERT INTO kpr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John nu sino fuka javo kamero (camel), ainda anoso ava firedo, asugedo ghusira. A nunda ifu dighari barago, kau daba ava edo, dighido ghusira. John nu aminda irise, sisi a finje ava, bayaudae rise irá ghusira. ");
INSERT INTO kpr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","John nu vironu sirureari, evetu genembo isambu eredo, nenda frovensi Judia da reighi mendeni, nenda reighi Jerusalem, a kotugo nenda reighi mendeni uvu Jordan tingu aminda ghedo foa John kena totorugedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Totorugedo, nenda ari ekoko vujegeoro, John ne uvu Jordan aminda bafataito edo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Umbu eni, Moses da Geka kaifa kakato+ a Sadusi embo+ mendeni, ne dabade fera, John nemo bafataito are dae sedo totorugetero gido, nu eminge sisira, “Ne Satan da sasinguri. Ne na jo derae areva. Ne dubo jo jovereghae ireva. God nenda ari ekoko aindae, janje eko use mino mutari erekotira ava, ne jo reda darige yae areva. ");
INSERT INTO kpr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ágido dubo jovereghe veka eveva use irivu! Amingururovo gido, ne dubo joveregheteva, ava God a natofo isambu kasama arera. ");
INSERT INTO kpr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Erá eminge seove, ‘Abraham namanenda abua gido, God namane uju eraira,’ aminge erá seove! God nu uju aetira amo, nu sari ghamana iritirira eimi, Abraham da sasingu jinaeteri. God jo evetu genembo da oróda, jo kotae eraira. Maveju Israel embo o oro eni amo, God jo kotae eraira. ");
INSERT INTO kpr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","God nu, ika karivakoi susuda jari dae, simbugedo refira. (Ika resena emo, nemori.) Ika vuji eveva jigharira, a nu irarira. O jo eveva jighae arira amo, God ika amo jedo avarakada dungari avarira. ");
INSERT INTO kpr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nenda dubo jovereghari da tano ava ijugari dae sedo, ne tefo uvu vanemboimi eraena. Avata Genembo eni, nanda amboda refira amo, nu nenda mendeni ava, Asisi Kakara nengae avarakaghae aimi bafataito arira. Nu genembo teria bekári. Na jo numongo iraeri. Na taká sabua+ bekári. ");
INSERT INTO kpr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Genembo amo, nu vare numamo eninda kaugori. Nune farava veka budo, soro ari dae sedo, simbugedo refira. Nu soro edo farava da beká ava simbuge budo, nunda kamboda fitari irarira. O veka da anoso nengae farava da ifu amo budo, avarakada fugari vosedo evovodae aminda irarira,” John nu Moses da Geka kaifa kakato+ a Sadusi embo+, nemokena aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sifo aminda, Iesu frovensi Galilee aminda ghedo ira, uvu Jordan aminda, John kena buvurutusira. Buvudo, numokena sisira, “Namo bafataito aso dae refena!” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","John nu bureguse sisira, “Nane, ni bafataito aono dae resesa. Amo jo inono iraeri. Geka bekári: namoá, nine bafataito aetesi,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Setiri, Iesu mino sisira, “Avata do, refira ava furare! Ni, na bafataito aresa! Aminguse, nangae God da uju ava arera,” Iesu aminge setiri, John ‘avori’ sedo, nu eredo Iesu bafataito usira. ");
INSERT INTO kpr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Etiri dadabetiri, Iesu uvuda ghe vivitiri ainghae dabade, utu afigetiri, Asisi Kakara kau, ribo avavaga isagha edo numokena vovosusira. John nu gosiri, vose fira Iesu kena asugusira. ");
INSERT INTO kpr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Asugetiri, beka utuda ghe isagha siri ne nininguseri, “Emo nanda dubo bari Mandiri. Na, nundae ivuga beká use, aiyakoe resena!” geka aminge setiri dadabusira. ");
INSERT INTO kpr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ainda amboda, God da Asisi imi Iesu unumbe budo ira, reighi uvu a evetu genembo irae da vasa aminda isira. Satan foa nunda fakina ava dere gare dae sedo, budo isira. ");
INSERT INTO kpr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ira buvudo aminda irise, sifo a tumba 40 ainda jokáda, Iesu nu bayau eni jo mindaeri. Aminguse, ighoi itatamiri, ");
INSERT INTO kpr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Satan fira numokena sisira, “Ni God da Mandi iraresa amo, se ghamanaé farava jinari mindase!” ");
INSERT INTO kpr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aminge setiri, Iesu mino sisira, “God da Geka eminge resira: ‘Evetu genembo oka bayau vanembo kotarera amo, God da jebuga beká jo tambae arera. God da Geka rea resira aimi, evetu genembo jebugarera.’” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Setiri dadabetiri, Satan nu Iesu unumbe budo, God da reighi kakara Jerusalem aminda ira teredo, God da Kambo+ ainda enoda viti ira fetedo, ");
INSERT INTO kpr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Satan jovereghe Iesu kena sisira, “Ni God da Mandi iraresa amo, jaunghe gaone! Jaunghaso dae resena ainda susu mo, God da Geka eminge resira: ‘God nunda aneya, ni kaifa aoro dae sari, nene ni kaifa ururoro, ni vosiya nenda ungoda desembedo vose fetaresa. Ninda ata jo ghamanai de fokughuse, jorae arira,’” Satan aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Setiri, Iesu mino numokena sisira, “Resesa amo, geka bekári. Avata vasa eninda, God da Geka eminge resira: ‘Nenda Bajari God ava, jo dere gari dae, ae areva,’” Iesu aminge sisira, numokena. ");
INSERT INTO kpr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Setiri dadabetiri, Satan nu Iesu unumbe budo ira, doriri mindafu eni aminda buvurutusira. Buvu aminda fetedo, reighi a frovensi isasambu endada irira, ainda fakina a duro ava ijugetiri gosusira. ");
INSERT INTO kpr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Gosiri, Satan sisira, “Iesu, ni kauboi darido na tumonde baingharesa amo, reighi einda duro oroko eregosesa evia, nindae mutono baresa,” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iesu mino numokena sisira, “Na dodo yasi! God da Geka eminge resira: ‘Nenda Bajari God nusuka numoá, tumonde bainghuse, nunda uju avanembo areva!’” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Setiri ningido, Satan nu dodo iri, aneya mendeni fera Iesu sonembuseri. ");
INSERT INTO kpr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sifo aminda, Kini (King) Herod setiri nunda mendeni era, John Bafataito Ari Kato ava sandi diburada fifituseri. Etero ava ningido, Iesu eredo frovensi Galilee aminda isira. ");
INSERT INTO kpr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nu reighi Nasareth aminda jo sekago irá ghae edo ghusira. Nu ya reighi javo Kaponiam, aminda irá ghusira. Kaponiam mo, uvu da teria javo Galilee, ainda betuda irira. Namonde Israel embo nunda oro oro aimi enda soro vesa edo rurusera da sifo aminda, namondeda oro etoto, Zebulun a Naphtali ondide dabade, reighi amo nene ruruseri. ");
INSERT INTO kpr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iesu amingusira amo, nu jo tefo aeri. God da feroveta Isaiah rea sisira ava beká are dae sedo, nu amingusira. Isaiah geka sisira amo, eviri: ");
INSERT INTO kpr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun ondi nengae Naphtali ondighae da reighi ava, Israel embo da gitofuimi sosighi edo bu jighirera. Uvu Jordan beina onakena a emingekena isambu, gitofuimi sosighi edo bu jighirera. Frovensi Galilee da enda isambu, gitofuimi sosighi edo nenda tofodae ruruseri. ");
INSERT INTO kpr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Gitofu frovensi Galilee aminda tumbaghae iriara ava, ne usasa tomanako gosuseri. A mendeni ambari dae urogho usera nembarago, God da usasa jaraghiri gosuseri.” God setiri Isaiah aminge sisira. Ainda beká mo: Iesu amboda foa vironu sarira, ava kotise sisira. ");
INSERT INTO kpr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sifo aminda, Iesu tuturo edo geka emo vironu sedo ghusira, “God nunda natofo+ kaifa ari da sifo ojighira utua erira. Ava sedo, nenda ari ekoko vujegedo dovu!” aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sifo eni, Iesu nu ira, Galilee uvu da teria irira aminda buvudo, ainda dengesida deinghudo ise, Simon (o Peter seraera) nunda namendi Andrew ghae, ne voto voyuvaimi oka barero gosusira. Nemo oka bambari embori. ");
INSERT INTO kpr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Avo gido, nemokena sisira, “Nengae fuvu, namonde dabade irise, dengoro indono ningido, oka bamburaeva aminga ava, nengae ya evetu genembo unumbedo, God Afakena bu furove!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aminge siri ainghae dabade, nengae javi e eredo nenda voto voyuva aminda dodo, nunda amboda iseri. ");
INSERT INTO kpr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Era, Zebedee da sasingu etoto naká, James nengae John ghae, ava tafuseri. Nengae numamode dabade, ghaka+ jokáda voto voyuva toka difero gosuseri. Gido, Iesu nemokena kori siri ainghae dabade, ");
INSERT INTO kpr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","nengae eredo numamo ghaka+ aminda dodo, Iesu da amboda iseri. ");
INSERT INTO kpr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu frovensi Galilee aminda birurughudo ise, dengoro indari kamboda+ teredo vironu sedo ghusira. God nunda natofo+ nange kaifa eraira, ainda Bino Eveva ava ijuguse seari ningido ghuseri. Aminguse, evetu genembo mendeni kae ekoko dombu eni dombu eni budo iriara ava, seari jejebugedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Amingiri, nunda bino iri, evetu genembo frovensi Syria aminda iriara, nembarago nininguseri. Ningido, kae evetu genembo Iesu kena budo fuseri. Mendeni mo, sukaruimi asugetero iriari. Mendeni mo, jinongu tambudo ghuseri. A mendeni mo, ungo ata dimbiri iriara ava, isambu unumbe budo fera Iesu kena buvero gido, setiri ne jejebuguseri. ");
INSERT INTO kpr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Amingetiri, nunda bino iri, evetu genembo digari ningido eredo, numo gari dae sedo nunda amboda iseri. Frovensi Galilee embo, Frovensi Judia embo (Jerusalem embo ainde dabade), Frovensi Dekapoles embo, a Frovensi Perea embode dabade, isambu totorugedo Iesu da amboda iseri. ");
INSERT INTO kpr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesu evetu genembo totorugusera ava gido, nu enda jiro fumbari aminda vitíra anumbusira. Anumbetiri, nunda mendeni fera numokena totorugetero, ");
INSERT INTO kpr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nu tuturo edo nemokena dengoro induduse, eminge sisira: ");
INSERT INTO kpr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Evetu genembo mave eminge koteraera: ‘Namokena eveva eni tefori,’ mave aminge koteraera amo, ne endada irise, ivugaghae iraeteri. Ainda beká mo: ne sifo amboda God da vasa eveva aminda teroro, God ne kaifa ururari irarera. ");
INSERT INTO kpr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Evetu genembo mave sorara a dubo memaghae irá gheraera amo, ne endada irise, ivugaghae iraeteri. Ainda beká mo: God ne sifo amboda, eghovo de budo kaifa ururari, ivugaghae irarera. ");
INSERT INTO kpr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Evetu genembo mave enda eminda irise durumugedo, jo totofo nemoá nembo kotae eraera amo, ne ivugaghae iraeteri. Ainda beká mo: God nunda sonemba a esimbugari rea mutari sisira ava, sifo amboda mutari nene barera. ");
INSERT INTO kpr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Evetu genembo mave enda eminda irise geka beká vanembo uju use, ari eveva use irá gheraera amo, ne ivugaghae iraeteri. Ainda beká mo: sifo amboda, ivuga a dubo jamaimi, nenda ghamo joká bedo arira. ");
INSERT INTO kpr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Evetu genembo mave enda eminda irise, nenda kokomanadae joka use sonemberaera amo, ne ivugaghae iraeteri. Ainda beká mo: sifo amboda, God evetu genembo amo joka edo unumbarira. ");
INSERT INTO kpr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Evetu genembo mave enda eminda irise, nenda dubo joká simbugedo, kotari eveva avanembo kotise irá gheraera amo, ne ivugaghae iraeteri. Ainda beká mo: sifo amboda, ne ya God da dombu garera. ");
INSERT INTO kpr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Evetu genembo mave enda eminda irise, mainungari da emboro ava tava use irá gheraera amo, ne ivugaghae iraeteri. Ainda beká mo: sifo amboda, God nemokena, ‘Ne nanda sasinguri,’ sarira. ");
INSERT INTO kpr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Evetu genembo mave enda eminda irise, geka eveva siruroro, o ari eveva ururoro aindae, gitofuimi nemokena fakarago use bouvu futururoro mema itatamarera amo, ne ivugaghae iraeteri. Ainda beká mo: sifo amboda, ne God da vasa eveva aminda ya teroro, God ne kaifa ururari irarera. ");
INSERT INTO kpr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“O ne namo tumondururovo aindae sedo, evetu genembo mendeni nendae aji sise jijivu sarera, o dedo gaedo ghuse gungubo sarera amo, ");
INSERT INTO kpr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ne endada irise, ivugaghae iraetevu. Ainda beká mo: ne mema itatamuse, kau God da feroveta mema itatamedo ghusera aminga ava, itatamareva. Amo, evetu genembo mendeni ne God da feroveta aikena, fakarago use bouvu muteoro mema itatamedo ghuseri. Ava sedo, ne sifo amboda God da vasa aminda, mino eveva ava bareva,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Aminge sise, Iesu sisira, “Evetu genembo isambu endada irera emo, ne kau bayau okia jokáda vendido itiraera, ainda kaugori. A nemo, kau karaje bayau etoda averegeraera, ainda kaugo ava edo ireva. Karaje bayauda fitido mindiraera aimi, dubo eveva itatameraera. Kau daba aminga ava, ne natofo jokáda ari eveva ururovo gido, evetu genembo isambu, ne God da emboro+ eveva ava kotise, itatamuse irarera. O karaje sasaka edo tive janje dadabarira amo, emboroda fugoro evetu genembo ise kotae fatarera. Kau daba aminga ava, nenda ari ekoko dotutuseva ava, sekago tuturo edo use, ne God doyareva amo, evetu genembo jo foama nemokena sonemba a eveva eni jo bae arera. ");
INSERT INTO kpr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ne natofo isambu da usasa da kaugo ava edo irevva. Kote givu! Reighi doririrda dighido irera ovia, jo jungari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","A kotugo, namonde arivo injibarera amo, jo bu ya ambokena ae arera, o jo bu gagara ae arera. Namonde, emboro ijugari dae sedo, arivo injibe jigheoro jaragheraira. ");
INSERT INTO kpr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kau daba aminga ava, erá nanda usasa bu jungeove dae resena. Ari eveva use a geka beká sise, nanda usasa natofo isambu kena ijugururovo nemokena gosuse, God Afa utuda irira, nunda javo jighoro erarira!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Aminge sise, Iesu sisira, “God da Geka Moses a feroveta mendeninde dabade gefusera amo, oroko irira. Erá nandae eminge seove: Iesu nu, God da Geka Moses gefusira ava, sari dadabare dae sedo ojighira, ava erá seove dae sise resena! Na, God da Geka Moses gefusira ava, jo nane saono dadabare dae sedo furaeri. Na ijugaono, Geka gefusira ainda beká ava, sirorare dae sedo refena. ");
INSERT INTO kpr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kotovo dae sise, eminge resena. Utu endaghae jo ya tano tambae irari, God da Geka Moses gefusira amo, jo dabako reda kosasaghae arira. God da Geka ainda mendo mendo irira ava isasambu, ainda beká ava sirorari gido, God amboda sari utu endaghae isambu dadabarira. ");
INSERT INTO kpr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ava sedo, mave God da Agho Dari da mendo kitako beká eni ava bejise, evetu genembo mendeni nune unumbe bu yarira amo, nu sifo amboda God da vasada, mandi ijoghako beká ava arira. O mave God da Agho Dari ava kaifa use, evetu genembo mendeni amingaoro dae sarira amo, nu sifo amboda God da vasa aminda, genembo kotofuko arira. ");
INSERT INTO kpr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Moses da Geka ijuga kakato+ a kaifa kakato+, ne God da Agho Dari ava kaifa eraera. Avata ne, jo inononda kaifa ae eraera. Ava sedo, na nemokena eminge resena. Ne, Moses da Geka ijuga kakato+ a kaifa kakato+ rea eraera ava, nene e darigedo, God da Agho Dari kaifa e gogoghombareva. Ne jo amingae areva amo, ne God da vasada jo terovo, nune kaifa ae arira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Aminge sedo, Iesu sisira, “Abua Moses nu abuamanekena geka mendeni mendeni sisira ava, ne kasama ereva. Ainda geka eni mo eviri: ‘Erama komana deóso ambeure! Komana daso ambarira amo, ni sandi bu ya jaji (judge) da dombuda koto arera,’ Moses abuamanekena aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Avata na oroko nemokena eminge resena, ningivu! Mave nunda namendighae beisiga use, janje eko arira amo, God nunda ari eko oimi, kau komana dari ambari da kaugo ava kotarira. Nu aindae sedo, amboda numokena ategi arira. O mave nunda namendikena jijivu sarira amo, nu budo ya kaniseremane da dombuda koto arera. O mave jijivu sise nunda namendikena sarira, ‘Nane saono bu mindase! Guka dagaya futo!’ aminge sarira amo, nu ari ekoko mino mutari vasa a ainda avaraka ava utua beká arira. ");
INSERT INTO kpr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Erá amingava siroreure dae sise, ni emingaetesi! Ni olta (altar) da dombuda fetedo, ninda joba God kena mutari dae use, dara eni ninda namendikena usesa ava kotaresa amo, ");
INSERT INTO kpr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","eveva mo, ninda joba olta (altar) da dombuda fiti dodo, ni jovereghe ya buvudo, ninda namendighae ategi edo mainungareva. Ainda amboda, ni sekago jovereghe foama teredo, ninda joba God kena mutaresa. ");
INSERT INTO kpr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“O ninda komana nimokena koto ari sarira amo, emboroda tambudo ategi use, geka eveva sise mainungareva. O jo amingae aresa amo, ni ya koto vasada buvaso, komana ni budo jaji (judge) kena mutari, nune budo sari, forisi (police) ni budo ya diburada fitarera. ");
INSERT INTO kpr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Amingarera amo, ni jo totoi doyoro buvudo ya dubo jama ae aresa. Jaji ninda dara da mino rea sarira, ava aso dadabari, amboda foa buvaresa. ");
INSERT INTO kpr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Moses geka eni sisira ava, namonde niningudo refera. Amo eviri: ‘Kombo yagera ava erá eove!’ aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Avata na oroko nemokena eminge resena, ningivu! Mave fuge evetu eni gido, yagera ari dae kotarira amo, a darari. Amo, ni aminge kotiruraso, ninda janje jokáda, ari eko anakora sirorarira. ");
INSERT INTO kpr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Avori, ninda diti gimandukena aimi gosuse, ni ari eko aso sirorarira amo, gunumbe fugaresa. Eveva mo: ni tamo tomanako da roera dabako bu fugedo, iria ambu ya God kena buvaso, nune ni kaifa arira. O ni diti etoto aminge irise, ari ekoko use iria ambudo, ya ari ekoko mino mutari vasa aminda teraresa amo, eko a bouvugori. ");
INSERT INTO kpr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","O ninda ungo gimandu aimi dara aso, ari eko sirorarira amo, gafuge fugaresa. Eveva mo: ni tamo tomanako da roera dabako bu fugedo, irá ambu ya God kena buvaso, nune ni kaifa arira. O ni ungo etoto aminge irise, ari ekoko use iria ambudo, ya ari ekoko mino mutari vasa aminda teraresa amo, eko a bouvugori. ");
INSERT INTO kpr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Moses Geka eni sisira ava, namonde niningudo refera. Amo eviri: ‘Mave nunda evetu doyari sarira amo, nu giti nunda geka gembu mutari yari, noaro bu gosururari, nu doyarira,’ aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Avata na oroko nemokena eminge resena, ningivu! Nearo dara jo ae ava, tefo doyaresa amo, a darari. Ni amingaso, nearo ya genembo enikena vai edo irarira amo, ainda javo yagerari. Amingarira ainda susu nimori.” ");
INSERT INTO kpr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Moses geka eni abuamanekena sisira ava, namonde niningudo refera. Amo eviri: ‘Ni Bajari da javoda rea ari saresa amo, amingaresa. Jo doyae aresa.’ Abuamane aminge sedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","36","Avata oroko na nemokena eminge resena, ningivu! Ninda geka tumondaoro dae sedo beka gagojuse, jo Bajari da javoda beka gajae aresa. Ni tefo ‘Ai, amingarena.’ sedo amingaresa, o ‘Tefo, jo ae arena,’ sedo doyaresa. Ni jo Baiboro (Bible) da javo sise, beka gajae aresa. ");
INSERT INTO kpr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Amo, ni eminge saresa, ‘Ai, amingarena,’ o ‘Tefo, jo amingae arena.’ Tufako aminge saresa amo, inono arira. O ni evetu genembo mendeni da javoda beka gajaresa, ainda susu mo Satan ri,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Moses geka eni sisira ava, namonde niningudo refera. Amo eviri: ‘Komana nimokena dara arira amo, ni minonda mutaresa. Ni jo kote doyae aresa,’ aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Avata na, nemokena eminge resena! Mave dara nimokena arira amo, ainda mino jo ae aresa. Ninda sovo gimandukena megha arira amo, jovereghe, umbefukena barago megha are! ");
INSERT INTO kpr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mave ninda tamo asugari kosughe bari dae sedo, ni bu ya koto arira amo, ninda javo desamugedo iraresa ábarago, mutaso barira. ");
INSERT INTO kpr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Rome embo da isoro kato genembo eni, nimo tambudo, nunda gugua fumbu yaso dae sarira amo, ni jo ututu (kilometres) etoto avanembo fumbu jarige fitae aresa. Ni ivugaghae sonembuse, genembo ainda gugua ututu (kilometres) avononde avavaga fumbudo, nengae yareva. ");
INSERT INTO kpr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","O mave nimokena roera enidae benunu sarira amo, tefo mutu bare! A mave roera eni uju ari bu ya edo, sekago bu foa mutari sarira amo, mutu bare! ");
INSERT INTO kpr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Moses geka eni sisira ava, namonde niningudo refera. Amo eviri: ‘Evetu genembo ni uju eraera amo, ne dubo baetesi. O mave ni imboe eraera amo, nimbarago ne imboe aetesi,’ aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Avata na nemokena eminge resena, ningivu! Nenda gitofu dubo buvu! Mave nemokena dara eraera, o nendae aji seraera amo, nendae sedo banungevu! ");
INSERT INTO kpr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Amingareva amo, ne God Afa da sasingu beká ava areva. Amo, ne kasama ereva: evetu genembo eveva a ekoko ainde dabade, God nunda usasa muteari janimberaira, a borija muteari diraira. Ne kau daba aminga ava use, evetu genembo eveva a ekoko ainde dabade, veka eveva aetevu. ");
INSERT INTO kpr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Evetu genembo mave ne dubo buraera, avanembo dubo bareva amo, God aindae ne jo esimbugae arira. Evetu genembo ekoko beká, takesi bari kakato avavaga, ne amingeraera. O evetu genembo ne imboe eraera, ava dubo bareva amo, God aindae ne esimbugarira. ");
INSERT INTO kpr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Evetu genembo maveghae komana areva, aikena nembo geka sareva amo, jo nene seka tuturo edo aeri. Evetu genembo mave God da Geka jo ningae irera, nembarago kau daba ava eraera. O nemo, nenda gitofu dubo budo nemonde dabade geka saovo dae sise resena! ");
INSERT INTO kpr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Afa utuda irira ai, evetu genembo isambukena veka eveva eraira. Ne kau daba aminga ava, evetu genembo isambukena veka eveva use irareva!” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iesu eminge sisira, “Ni erama, natofo nimo sakai saoro dae sise, evetu genembo sonembeose! God kotise, evetu genembo mendeni sonembari saresa amo, ni junjugai sonembaresa. O natofo gosururoro, ni evetu genembo sonembaresa amo, God Afa, amingaresa aindae, ni jo esimbugae arira. ");
INSERT INTO kpr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Evetu genembo mendeni, ne dubo etoto use sonemberaera. Amo ne, dengoro indari da kamboda+ o emboroda ise, makasi embo sonemburureoro, natofo giraera. A nu geka bekári, avata ne jo evetu genembo sonembari dae sise, amingae eraera. Nemo gungubo kakatori! Amo natofo nemoá sakai saoro dae sise eraera. Amingeraera amo, nenda mino mo, evetu genembo nemoá sakai seraera, avakori. Amboda, God Afakena, mino eni jo bae arera. ");
INSERT INTO kpr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Ava sedo, ni evetu genembo mendeni sonembari saresa amo, ni junjugai sonembaresa. Ninda mendeni a ninda kokomana beká, ne jo kasama ae iroro, evetu genembo sonembaresa. Amingedo, junjugai sonembururaso, God Afa gido, ainda mino eveva ava nimokena mutari baresa,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Aminge sise, Iesu sisira, “Evetu genembo mendeni nemoá sakai saoro dae sise, natofo gosururoro, ne dengoro indari kamboda+ o emboro dengesida fetirise, banungeraera. Amingeraera amo, nenda mino mo, evetu genemboi nemoá sakai seraera, avakori. Amboda, God Afakena, mino eni jo bae arera. ");
INSERT INTO kpr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ava sedo, ni banungari dae aresa amo, ni ya ninda kamboda tere guro gajedo, banungaresa. Ni ditiimi God Afa jo gae eraesa, avata junjugai banungururaso nu gido, aindae mino eveva ava nimokena mutari baresa. ");
INSERT INTO kpr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Eni mo: ni banungari dae aresa amo, erá babotuse kotae kotae banungeose! Namonde Jusi embo da gitofu God da Geka jo ningae irera, nene koteraera amo: ne kotae kotae sise, ghousa futo banunguse irarera amo, God nenda geka ningariá koteraera. ");
INSERT INTO kpr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ni erá amingeose! Ni jo tuturo edo benunu sae iresa avata, God ninda irari anakora gido, nimokena rejo daiva erira ava, nu kasama use irira. ");
INSERT INTO kpr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ava sedo, ne eminge banungareva: ‘Namanenda Afa, utuda iresa! Ninda javo kakara use jighoro erare! ");
INSERT INTO kpr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Utuda ninda uju avanembo siroreraira. Kau daba aminga ava, enda eminda sirorare! Amingare dae sedo, fu namane kaifa ururaso, namonde irore! ");
INSERT INTO kpr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Oroko eminda, namanendae bayau mutaso baore! ");
INSERT INTO kpr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Evetu genembo namanekena ari ekoko urureoro, namane gido kote doyeraera. Aminga ava, namanenda ari ekoko eraera amo, kote doyaso dae resera! ");
INSERT INTO kpr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Erama namane derarikena budo yeose! A Satan da derari aminda, namanendae kosege fetaetesi!’ Kau aminge banungevu! ");
INSERT INTO kpr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Avori, evetu genembo nimokena dara eraera, ava kote doyaresa amo, ari ekoko nine eraesa amo, Nimamo utuda irira ai, kote doyarira. ");
INSERT INTO kpr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","O ni evetu genembo mendeni da ari ekoko jo kote doyae aresa amo, ninda ari ekoko barago, Nimamo jo kote doyae arira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Aminge sise, Iesu sisira, “Evetu genembo mendeni gungubo ava use, bayau kanangara eraera. Nemo natofo nemoá gido sakai saoro dae sise, amingeraera. Amingeraera amo, nenda mino mo, evetu genemboi nemoá sakai seraera, avakori. Amboda, God kena mino eni jo bae arera. ");
INSERT INTO kpr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ava sedo, ne God kena ya buvari dae sedo, bayau kanangara ari dae areva amo, ne God kotise, junjugai areva. Jo isagha rovarova ururovo natofo gae arera. Ne bayau kanangara ari sareva amo, eveva mo: ne dombu seghuse, beo gae simbuguse iraetevu! ");
INSERT INTO kpr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Erama natofo kasama eore dae sise, amingaetevu. God Afa nu nusuka kasama use, ainda mino eveva ava nemokena mutarira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Aminge sise, Iesu sisira, “Erama nenda gugua enda eminda dabade use iriove! Nenda gugua enda eminda dabade use irareva amo, jirikoimi mindarira, karakarajeka arira, a tafasara kakatoimi foama beje bagia arera. Ava sedo, ne enda eminda irise, erá gugua eveva bari dae kotise, dubo mema eove! ");
INSERT INTO kpr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Eveva mo, ne God da uju avanembo ururovo gido, ainda beká utuda siroraeti! Utuda mo, jiriko a karakarajeka aimi jo rururari eko ae eraira, a tafasara kakatoimi jo beje bagia ae eraera. Dara avavaga, utuda eni tefori. Ava sedo, ne God da uju avanembo ururovo gido, ainda beká utuda siroraeti. ");
INSERT INTO kpr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ainda beká mo: nenda gugua reda irá gheraira aminda, nenda dubo joká muturaeva. Ava sedo, nenda gugua utuda bari kotareva amo, nenda dubo joká isambu God kena futuse iraetevu! ");
INSERT INTO kpr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ninda diti amo, inono ninda tamo da arivori, arivo injibeoro jaragheraira, avavagori. Ni gi gogoghombaresa amo, ninda emboro usasa ari garesa. ");
INSERT INTO kpr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","O ninda diti digoi arira amo, ni tamo isambu tumba arira. Kau daba aminga ava, ninda dubo joká ari ekokoimi bedo arira amo, ni tumba eko beká ainda jokáda iraresa. ");
INSERT INTO kpr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ni bajari etoto aikena, jo saramana ae aresa. Amingari saresa amo, eni dubo bu gogogho aresa, eni imboe aresa. Bajari eninda geka ningido, nunda saramana e gogoghombaresa. Aminguse, bajari eninda geka imboe use, nunda saramana imboeghae aresa. Ninda dubo monikena mutaresa amo, God kena jo mutae aresa. O God kena dubo mutaresa amo, moni jo kotae aresa. ");
INSERT INTO kpr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Namonde uvu bayau jo mindae arera amo, ambarera. A namonde tamo asugari bu asugaeteri. Avata na, uvu bayau a tamo asugari dae, erama teria futo koteove dae sise resena. Ainda tuka mo eviri: ninda jebuga mo susuri. Bayau jo susu iraeri. A tamo mo, susuri. Tamo asugari mo, jo susu iraeri. ");
INSERT INTO kpr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Rika ghumburaera, ava givu! Ne jo vare je govae eraera, a vurukuda bayau jo fitae eraera. Avata God ne kaifa use, nenda bayau muturaira. Avori, God nu rika itako koteraira. Avata evetu genembo mo teriago kotise, tavo e gogogho eraira, ne asisighae ava sedo. Avori, God rika kaifa use bayau muturaira amo, nemokena kau daba aminga ava, bayau mutari bareva. ");
INSERT INTO kpr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Geka setena, daba ava sari dae erena. Ni baimara buvari bayau dadabarira aindae, oju use teria futo kotaresa o jo kotae aresa, avata, ninda ambari da sifo furarira amo, ni ambaresa. Ava sedo, ne uvu bayau erá teria futo koteove dae sise resena. ");
INSERT INTO kpr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kotugo tamo asugari reda bareva aindae sedo, jo dubo mema ae aetevu. Vare joka kote givu! Vare joka mo, jo saramana use fire asugae eraira. ");
INSERT INTO kpr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Avata vare joka mo, gari evevago bekári. O Kini (King) Solomon ava kote givu! Nu iti fafode ava sedo, nunda tamo asugari isambu evevagori. Avata nunda tamo asugari jo vare joka amingo iraeri. Vare joka mo, evevago bekári. ");
INSERT INTO kpr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kikisa ava kote givu! Oroko irira. Avata sifode gaforo gharasa ari dungoro avarira. Nu roera veyako bekári. Avata God nunda gari evevago fifitusira. Ava sedo, kasama evu! God vare joka kote simbugarira amo, nembarago kaifa use, nemokena tamo asugari mutari bareva, ne asisighae ava sedo. ");
INSERT INTO kpr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ava sedo, uvu bayau reda bu mindareva, o tamo asugari reda bu asugareva aindae, erama dubo mema eove! ");
INSERT INTO kpr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Namondeda gitofu mave God da Geka jo bae irera, ne roera aindae kotise dubo mema eraera.) Avata nemo jo amingae areva. Ainda susu mo: God Afa nenda irari ava gosuse, nemokena rejo daiva eraira, nu anakora kasama use irira. ");
INSERT INTO kpr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ava sedo, ne giti nunda saramana a uju ava areva. Amingururovo, uvu bayau a tamo asugari, nune mutari bareva. ");
INSERT INTO kpr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Avori, erá dara amboda furarira aindae kotise, nenda fakina soesa eove! Ainda beká mo: dara amboda kau mavega sirorarira ava, ne jo kasama aeri. Ava sedo, eveva mo: bouvu oroko erefufesa avanembo kotaresa. Redae ni dara amboda kau mavega sirorarira ava kotise, dubo memaghae iraresi? ");
INSERT INTO kpr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Erá ninda komana da ari ekoko ijujeose! Amingaresa amo, God ninda ari ekoko barago ijujarira. ");
INSERT INTO kpr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Evetu genembo mendeni da ari ekoko ijujaresa amo, God kau daba ava ni ijujarira. A evetu genembo mendenikena mino kau nangego mutaresa amo, God nimokena kau daba avaga mutarira. ");
INSERT INTO kpr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","A eni mo: erama ninda ari ekoko mindafu irarira amo dotutuse, ninda komana da ari eko kitako ava ijujeose! ");
INSERT INTO kpr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ni redae faragho ninda ditida gae fetirira amo sofughae irise, ni komanada ditida fonja ava fusaso buvare dae eresi? ");
INSERT INTO kpr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nimo gungubo katori! Faragho ditida fetiriri ainghae iresa avata, nangetiraimi komana da ditida fonja ava fusaso buvare dae resesi? Eveva mo, giti ninda ari eko tomanako ava vujegaso eveva ari gido, amboda ya ninda komana sonembaresa. ");
INSERT INTO kpr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Geka eni mo: namonde roera kakara o roera eveva amo, jo sino fukadae mutae eraera. Ainda beká mo: sino fukakena kotari tefori. Ava sedo, sino fuka roera eveva amo atai fati fetedo, jovereghe namonde gambarira. Kau daba aminga ava, evetu genembo God da Geka imboe eraera aikena, God da roera a Geka jo kotae kotae mutae areva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Aminge sise, Iesu sisira, “God Afakena benunu sareva amo, bareva. Tava areva amo, tambareva. Goingoinghareva amo, God nendae guro afigarira. ");
INSERT INTO kpr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ainda beká mo: mave benunu sarira amo, mutari barira. Mave tava arira amo, tambarira. A mave goingoingharira amo, God Afa nundae guro afigarira. ");
INSERT INTO kpr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kote givu! Ne mendeni ghaguruderi. Ninda mandi isiadae benunu sarira amo, ni ghamana ava mutaresa, ai? ");
INSERT INTO kpr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O okadae benunu sarira amo, ni jingabuá mutaresa, ai? ");
INSERT INTO kpr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tefo, ni jo amingae aresa. Ne ari ekoko embori, avata nenda sasingu tavo eveva eraeva. God Afa nu veka eveva bekári. Ava sedo, kau nenda sasingu tavo eveva eraeva aminga ava, mave God Afakena benunu sarera amo, God nemoá tavo e gogoghombuse, roera evevago beká ava mutarira. ");
INSERT INTO kpr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“God setiri, Moses a feroveta nene geka rea gefusera, ainda tuka mo eviri: ‘Ni rea evetu genembo nimokena aoro dae koteraesa, kau daba aminga ava, ni nemokena edo ghaetesi!’” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Aminge sise, Iesu sisira, “Guro etoto naká ainda geka sari dae erena. Guro eni sokumakori, a eni beraghari. Guro sokumako aminda terari dae fakina evu! Ainda susu mo: guro eni beraghari, a ainda emboro teriari. Ava sedo, evetu genembo digari aminda ya terarera. Avata aminda ya terareva amo, eko tambudo sirivo areva. ");
INSERT INTO kpr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","O guro eni sokumako irira, aminda yari mo fakaragori. Ava sedo, evetu genembo daba daba aimi ya aminda terarera. Avata aminda ya terareva amo, jebuga evovodae irari ava tuve bareva. ");
INSERT INTO kpr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kote gogoghombevu! Evetu genembo mendeni nemokena yama, gungubo sise eminge sarera, ‘Namane God da ferovetari,’ aminge sarera. Nenda gari kau evevagori, sifi (sheep) da kakaugori. Avata nenda dubo joká mo, eko bekári, gambari sino da kaugori. ");
INSERT INTO kpr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nenda gari a nenda geka rea sarera amo, isambu eveva vanembori. Avata amo erá koteove! Nenda ari rea arera amo, kote gogoghombuse gareva! Kaura, jo ya asi buaretifa aminda jighido irari, bu mindae arera. A mofi da vuji mo, jo ya ika fokono aminda jighido irari, bu foa mindae arera. ");
INSERT INTO kpr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Kau daba aminga ava, ika evevai vitarira amo, nu vuji eveva a babaigo jigharira. O ika ekoi vitarira amo, vuji sembae jigharira. Ika eveva aminda, jo vuji eko bambae eraera. A ika eko aminda, vuji eveva jo bambae eraera. ");
INSERT INTO kpr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Vare jokáda, ika o roera eni vuji jo jighi gogoghombae arira amo, namonde jeoro gharasa edo aveari dungeraera. ");
INSERT INTO kpr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Avori, feroveta setena amo, ne, kau ika vuji jigheari, ika ainda kau mavega kasama eraera aminga ava, nenda ari avega ururoro gido, nenda kau aminda kasama areva. ");
INSERT INTO kpr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Oroko evetu genembo digari namokena kori sise, eminge seraera, ‘Bajari! Bajari!’ seraera, avata jo aindae sedo, doyono God da vasada terae arera. Mave God Afa da uju beká ava use irarera ainembo, God da vasa eveva aminda teroro, God ne kaifa ururari irarera. ");
INSERT INTO kpr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sifo aminda, evetu genembo digari namokena eminge sarera, ‘Bajari, namane ninda javoda God da Geka sedo ghuseri. Ninda javoda sukaru ondeoro, evetu genembo da jokáda ghe foa buvudo ghuseri. A ninda javoda tano a ari mendeni mendeni eoro, evetu genembo jo gae iriara ava, nenda gitida siroreari gido dudukughedo ghuseri,’ aminge sarera. ");
INSERT INTO kpr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Avata Sifo aminda, na mino nemokena eminge sarena, ‘Na ne erebunena. Yasivu, ajagha fetove! Ne ari ekoko embori,’ aminge sarena. ");
INSERT INTO kpr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Avori, mave nanda geka evia ningido amingarira amo, nu kau genembo eni dubo kotaride amingori. Genembo amo, nu kambo itari dae sedo, vasa eveva tambudo aminda simbugedo, bako ghambu gogoghombe tutumbi darido, ghamana endaghae vendi gaetiri fakara e gogoghombetiri, ainda etoda nunda kambo iti dotiri fetetira. ");
INSERT INTO kpr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ainda amboda, yaura tuturo edo sufiri, borija tomanako dido usegha buvira, avata kambo amo jo gofaeri, nunda kambo eveva itira ava sedo. ");
INSERT INTO kpr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","O mave nanda geka evia ningido jo ae arira amo, nu kau genembo eni kotari iraede amingori. Genembo resena emo, nunda kambo ghonesada itira, bako jo ghambu simbugae. ");
INSERT INTO kpr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Etiri, amboda yaura tuturo edo sufiri, borija tomanako dido usegha bejetira. Beje tutumbi ghambu osinimbetiri kamboá du de bunununghe fasetira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu aminge setiri dadabetiri, natofo isambu ningi dudukughuseri. ");
INSERT INTO kpr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ainda beká mo: Moses da Geka ijuga kakato+ dengoro indido ghusera, a kau eniri. O Iesu dengoro indudusira amo, geka nunda fakinaghae dabade sisira. ");
INSERT INTO kpr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu eredo, enda fumbari ainda jiroda ghe vose fira iri, natofo digari ambari eko nunda amboda amboda iseri. ");
INSERT INTO kpr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ero, genembo eni bedode aimi, ira Iesu kena buvudo kauboi dadarigedo sisira, “Bajari, na kasama erena, ni uju aresa amo, na saso jebugarena,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Setiri, Iesu nunda ungoi sirege tamonda jijighuse sisira, “Ai, na uju erena. Jebugaresa!” Iesu aminge siri ainghae dabade, gambisi dadabetiri jebugusira. ");
INSERT INTO kpr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Etiri, Iesu numokena sisira, “Seteno jebugetesa emo, erá osa seose! Ere yasi, fristikena+ ninda tamo ijugaso gari, Moses da Geka aminda, God kena joba rea mutaso dae resira, ava mutaresa! Amingaresa amo, ni jebugetesa ava, evetu genembo isambu kasama arera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Aminge sedo, Iesu ira reighi javo Kaponiam aminda teteriri, Rome embo da isoro kakato da giti jighari eni fira nu tafusira. Tambudo, benunu sisira, ");
INSERT INTO kpr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bajari, nanda saramana kato eni kae tambudo, kamboda fasirira. Ungo ata ambiri, dubo mema teriago eretafira,” aminge setiri, Iesu mino sisira, ");
INSERT INTO kpr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Avori, na ya saono jebugarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Setiri, isoro kakato da giti jighari eminge sisira, “Bajari, ni genembo teriari. Na genembo ijoghakori. Jo nine foa nanda kamboda terari da kaugo iraeri. Na kasama erena, saso jebugari da fakina mo, nimokena irira. Ni taká soka fetedo bekai saresa amo, nanda saramana kato jebugarira. ");
INSERT INTO kpr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na, nanda babojegari da geka ningiraena, kotugo nanda mendeni nanda geka ningiraera. Nanda isoro kato enikena, ‘Yasi!’ sarena amo, yarira. O enikena, ‘Fu!’ sarena amo, furarira. A kotugo, nanda saramana katokena saramana eni are dae sarena amo, nu amingarira.” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Giti jighari amo, aminge siri nunda geka ava ningido, Iesu dudukughusira. Dudukughe jovereghedo, evetu genembo nunda amboda isera aikena sisira, “Na eminge saono ningivu! Namo irena evia, tumondari kau évavaga ava jo gae iriana ava, nanda tuturoda orokoá eregosenere. Israel embo da jokáda barago, tumondari kau evavaga ava jo gae irena. ");
INSERT INTO kpr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Geka emo kote gogoghombaetevu! Namonde Israel embo da gitofu digari, iji vitari a iji vosarikena ghedo yama God da vasa aminda teredo, Abraham, Isaac, a Jacob de dabade anumbaoro, God Afa ne kaifa ururari irarera. ");
INSERT INTO kpr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Avata, Abraham da sasingu mendeni God da vasada ya teraetera avata, ne tumondari tefo gido, God ne ajagha fugari dika ghininji ghananja ghuse tumbada irarera,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aminge sedo, nu jovereghedo isoro kakato da giti jigharikena sisira, “Avori, jovereghe kamboda yasi! Rea tumonderesa, ava sirorarira,” aminge siri ainghae dabade, giti jighari ainda saramana kato jebugusira. ");
INSERT INTO kpr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iesu ira Peter da kamboda teredo, Peter da imboti kae tambudo, tamo veriveri iri fasiriri gosusira. ");
INSERT INTO kpr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gido, sire ungoda jighiri tamo jama etiri, nu jebuge eredo bayau simbugedo numokena futusira. ");
INSERT INTO kpr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Sifo daba aminda tumba jiriri, evetu genembo reighi aminda, evetu genembo kae dombu eni eni budo iriara ava, Iesu kena budo fuseri. Fera buvero, Iesu setiri sukaru evetu genembo mendeni da tamonda asugetero iriara ava, vose darigetero jebuguseri, a kae evetu genembo mendeni ainde dabade, isambu jejebuguseri. ");
INSERT INTO kpr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iesu amingusira amo, jo tefo aeri. Susudae usira. God nu rea nunda feroveta Isaiah kena setiri gefusira ava, beká isagha are dae sedo, nu amingusira. Isaiah gefusira amo, eviri: “Nu tofo mandi namonde da kae da bouvu fufuse, setiri namonde jebuguseri.” ");
INSERT INTO kpr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Evetu genembo digarigo totorugusera ava gido, Iesu jovereghe nunda ambo jimbikena, nemonde dabade sirige uvu da teria aminda sembi yari dae sisira. ");
INSERT INTO kpr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aminge siri, Moses da Geka ijuga kato eni fira buvudo, numokena sisira, “Ijuga Kato, Na ni tumonderena. Ni reda yaresa amo, nangae yarera,” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu mino sisira, “Agari a rika, ne moghaghaeri. Avata, Evetu Genembo da Koro+, nunda kambo a avari vasa eni tefori. Ni nangae dabade deingharera amo, ni avari vasa jo tambae aresa,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Setiri, nunda ambo jimbi eni eminge sisira, “Bajari, nanda afa nu embako beká etira. Nu ambari gido irise, nangae deingharera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Setiri ningido, Iesu mino numokena eminge sisira, “Dodo fu, nangae oroko yaore! Evetu genembo mave God da Geka jo ningi tumondae eraera amo, ne kau ambari embo da kaugori. Ava sedo, mave ambarira amo, dovu, nene bu ya furugaore! Avo gido, ni fu, nangae yaore!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aminge sedo, Iesu nunda ambo jimbide dabade ghakada+ vosedo sembiseri. ");
INSERT INTO kpr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sembero, eva yaura vovogoghae eko beká ava erorusira. Eredo, ghaka+ de rosari dae usira. Avata Iesu nu fase aviri, ");
INSERT INTO kpr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","nunda ambo jimbi era nu deretero eretiri, numokena siseri, “Bajari, sonembe! Namonde sirivo ari dae erera!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Setero, Iesu kovionoghae sisira, “Ne redae oju erevu? Nemokena tumondari tefori!” aminge sedo, nu eredo eva yaura tukughare dae sedo, kovionoghae beka fuge setiri, eva yaura tukughedo binono usira. Amingetiri, ne isambu dudukughuseri. ");
INSERT INTO kpr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dudukughedo, ne tofo tofo se nininguseri, “Arie! Genemboé kau avegorai, nune setiri eva yaura nunda geka ningi? Ari emo, jo evetu genemboi ari da kaugo iraeri!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Amingetiri dadabetiri, ne sembera Gedara ondi da reighi aminda tere dadoruseri. Dari vivitero, gegenembo etoto naká, bekuda ghe buvudo vose fera Iesu tafuseri. (Beku resena emo, ambari embo aminda furugedo ghuseri.) Gegenembo amo, nengae sukarui asugetero daghedo iriari. Nengae evetu genembo ondi soesa dedo ghuseri. Amingedo ghusera aindae, evetu genembo emboro aminda jo ya foa ghae edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nengae Iesu nunda mendeninde ava tambudo, koko eminge siseri, “Arie, God da Mandi! Ni redae namanekena refesi? Namanekena mema mutari dae refesa, ai? Sifo mo, jo foa buvae irira,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Vasa aminda, fukamane digarigoimi bayau rise ya foa ghero gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gido, sukaruimi Iesu kena benunu siseri, “Ni namane ondaso buvoro dae saresa amo, se, namane yama fukamane da jokáda terore!” aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iesu “Yasivu!” Setiri, sukaru gegenembo ainda tamonda iriara ava, vose darigedo era, fukamane da jokáda tere asugetero, fukamaneá isambu sumbu fusi kenana sedo era, reighi ganasa aminda ghasaghe vosedo, uvuda mindi sirivo useri. ");
INSERT INTO kpr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Amingetero gido, fuka ainda kaifa kakato, sumbudo era reighi bogu aminda buvudo, Iesu rea etiri gosusera, ainda bino ava isambu osa setero natofo nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ningido, reighi ainda natofo isambu eredo, Iesu tambari dae sedo fuseri. Fera, nu gido benunu siseri, “Eveva mo, ni namanenda reighi a endaé dodo yaetesi.” ");
INSERT INTO kpr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Aminge benunu setero, Iesu eredo nunda ambo jimbi ainde dabade ghakada+ vosedo jovereghe sovenikena aminda sembiseri. Sembera, nunda reighi aminda tere dadoruseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Darido vitero, evetu genembo mendeniimi, genembo eni ava budo, Iesu kena fuseri. Genembo amo, nu ungo ata dimbarideri. Ava bu ghaghada fitero fasetiri, fumbudo fuseri. Iesu kae genembo ainda kokomana da tumondari ava gido, kae genembo aikena sisira, “Nanda mandi, fakina edo ivuga aso dae resena! God ninda ari ekoko kote dotira,” sisira. ");
INSERT INTO kpr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aminge siri, Moses da Geka ijuga kakato+ mendeni aminda anumbirisera aimi ningido, minonde minonde se nininguseri, “Genembo omo, God da javo etiri eko erira. Numo namonde daba avori. Nu jo dombu eni iraeri. Ava sedo, nu nange nange God da javoda resi? Amo ekori!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ne rea kotisera a sisera ava, Iesu kasama usira. Kasama edo nemokena sisira, “Ne redae kotari ekoko erekotevu? ");
INSERT INTO kpr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kote givu! Ne erekoteva: na benunu sarena amo, God genembo einda ari ekoko jo kote doyae ari, ava erekoteva? A nenda kotari eni mo: nu jebugare dae saetena amo, jo jebugae aeti? ");
INSERT INTO kpr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Avori, nanda fakina ijugaono gareva. Evetu Genembo da Korokena+ mo, ari ekoko kote doyari da fakina ava irira. Ava kasama aovo dae sedo, saono genemboé jebugarira,” aminge sedo, nu jovereghedo genembo ungo ata dimbaride aikena sisira, “Eredo, ninda ghaito gaghe budo, kamboda yasi!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Setiri, genembo amo eredo, kamboda isira. ");
INSERT INTO kpr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Etiri gido, natofo isambu oju edo God dae sakai siseri. Sakai sisera da beká mo: God nu fakina avavaga evetu genembokena futusira. ");
INSERT INTO kpr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nanda javo Matthew. Na takesi bari kato edo iriana ainda sifo aminda, Iesu reighi aminda ghe eredo fira, nanda saramana kamboda buvurutusira. Buvudo, na aminda anumbireno gido, namokena sisira, “Fu, nangae yaore!” setiri, na eredo nunda amboda iseni. ");
INSERT INTO kpr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ainda amboda, namonde bayau dabade mindari dae sedo, Iesu fira nanda kamboda teredo anumbusira. Nane seteno, takesi bari kakato mendeni a ari ekoko embo mendeni fera, namane namonde dabade anumbuseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Etero, Moses da Geka kaifa kakato+ mendeni ava gido, Iesu da ambo jimbikena ategi useri, “Takesi bari kakato, ne gegenembo ekokori. A evetu genembo mendeni, takesi bari kakatode dabade ojera anumbirera omo, nembarago ari ekoko embori. Ava sedo, nenda ijuga kato redae takesi bari kakato a ari ekoko embode dabade anumbedo bayau rereri?” aminge sero, Iesu tofo niningusira. ");
INSERT INTO kpr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ningido sisira, “Evetu genembo tamo kae iraede amo, ne dogetadae jo uju ae eraera. Avata evetu genembo tamo kaede amo, ne dogetadae uju eraera. Ari ekoko embodae joka aovo dae sedo, na nemokena eminge resena, ningivu! God kena joba muturaeva amo, evevari. ");
INSERT INTO kpr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Avata kotugo yasivu, God da Geka emo kotise kasama e gogoghombaove! ‘Nanda uju beká mo, joka ariri. Jo namokena joba mutari iraeri.’ Ava sedo, ari ekoko embodae joka use irareva! Evetu genembo mendeni nenda kotari mo, ‘Ne jo ari ekoko embo irae,’ ava koteraera. Evetu genembo amo, na jo aghi ae arena. O evetu genembo mendeni ne kasama eraera, ‘Ne ari ekoko embori.’ Evetu genembo amo, na uju use aghi eraena,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ainda amboda, John Bafataito Ari Kato da ambo jimbi Iesu kena fera buvudo ategi useri, “Namane a Moses da Geka kaifa kakato+ de dabade God dae bayau kanangara use banungeraera. Avata ninda ambo jimbi, ne nange jo amingae eraeri?” ");
INSERT INTO kpr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aminge setero, Iesu mino nemokena sisira, “Kote givu! Mandi gimasa eni, nu evetu fifitururari kirumo arera da sifo aminda, nunda kokomana ne jo sorara ae arera. O genembo evetu fitira ava, gitofui sandi bu ya daoro ambarira ainda sifoda, ne dubo mema use, tuturo edo nundae kanangara arera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Aminge ijuguse sisira, “Embo boka eni manai edo toka basarira amo, namonde jo embo sogho seka ava gafugedo aimi, tauta gayae arera. Ainda susu mo: tauta gayarera amo, ainda békada torerarira. ");
INSERT INTO kpr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kau daba ava, vaini (wine) seka jo budo kofiri manai aminda, averegaoro vosedo irae arira. Amingarera amo, vaini (wine) seka da fakinaimi fumbari, kofiri bejari vaini (wine) averege vose soesa arira. Ava sedo, vaini (wine) seka kofiri sekada averegeraera. Amingururoro, vaini (wine) kofirighae eveva irarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesu nu aminge siri, Jusi embo da kotofu eni fira, Iesu kena buvudo nunda dombuda kauboi dadarigedo, eminge sisira, “Nanda gagara oroko nembo ambira. Avata fu nangae yama, ninda ungoimi tamonda jighaso jebugare!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aminge setiri, Iesu eredo kotofuko ainda amboda iri, namane nunda ambo jimbi barago nunda amboda iseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Namane ero, evetu eni fira namane emboro soroda tafusira. Evetu resena emo, nu kae budo tambuno gosuse irise, ghaeko 12 ava dadabusira. Evetu aimi Iesu da gukakena ira buvudo, ungo sirege nunda tamo asugari tinguda jijighusira. ");
INSERT INTO kpr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nu amingusira da beká mo: nu eminge kotisira, “Na tefo Iesu da tamo asugari aminda jigharena amo, na jebugarena,” aminge kotise, tamo asugari tinguda jijighusira. ");
INSERT INTO kpr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jijighiri, Iesu evetu genembo da jokáda jovereghedo, fuge evetuá gido numokena sisira, “Nanda gagara, fakina edo ivuga aso dae resena. Ainda beká mo: ninda tumondariimi jebugetesi,” Iesu aminge siri ainghae dabade, evetuá jebugusira. ");
INSERT INTO kpr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Amingetiri, namane sekago javi edo, kotofuko ainda kamboda iseri. Era buvudo kamboda teredo, feku fusari kakato a natofo digari, gagara furugari dae sedo totorugusera amo, ne dubo memai ghamo gajetiri dimbia sorara use, fugedo irero namane gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Gido, Iesu nemokena sisira, “Ne isambu eredo yasivu buvove! Gagara emo jo ambaeri. Nu ravira,” aminge setiri, ne numoá dere jiseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aminge sero, nu ondiri ne eredo, era buvurutuseri. Buvero, Iesu gagara da avari vasada tere fetedo, sirege gagara ainda ungoda jighiri nu erorusira. ");
INSERT INTO kpr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iesu amingusira, ainda bino iri, reighi digari frovensi aminda nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu nu reighi amo dodo iri, gegenembo etoto diti digoide aimi eredo, Iesu da amboda iseri. Nengae ise, koko sise eminge siseri, “Kini (King) David da Mandi God mutari sisira amo, nimori. Ava sedo, namane joka eyo!” aminge sido iseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aminge sido ero, namane era dabade kambo eninda teredo, gegenembo etoto naká amo fera Iesu kena buvero, nu nemokena ategi usira, “Ne nange erekotevu? Na sarena amo, nengae jebugareva, ai tefo?” aminge setiri, nengae siseri, “Ai, namane tumonderera. Saresa amo, namane jebugarera,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aminge setero, Iesu ungo sirege ditida dederuse sisira, “Ne rea tumondereva ava, nemokena sirorare!” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","diti eveva usira. Etiri, Iesu kovionoghae nemokena sisira, “Erama jebugeteva ava, osa seove!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ne buregusira, avata nengae reighiá dodo era, nenda diti eveva usira ava, osa setero, reighi digari frovensi aminda nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Gegenembo etoto naká jebugedo yari dae javi ero, kotugo evetu genembo mendeni, genembo eni budo fera teteruseri. Genembo resena emo, nu sukarui asugetiri guga edo irei. ");
INSERT INTO kpr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iesu setiri, sukaru genembo ainda jokáda ghe fira buviri beka afigetiri, genemboá tuturo edo beka sisira. Beka siri, evetu genembo ningido dudukughuseri. Dudukughedo, siseri, “Namondeda reighi Israel eminda namonde eminga jo gae iriara ava, namondeda gitida siroretiri eregosera!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Avata Moses da Geka kaifa kakato+ eminge sedo ghuseri, “Sukaru da bajari javo Satan imi, nunda fakina muteari, Iesu budo, sukaru bu fugeraira,” aminge sedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu aminguse, frovensi aminda birurughudo ya foa ghusira, reighi isambu aminda. Dengoro indari kambo aminda, God Afa nunda natofo+ nange kaifa eraira, ainda Bino Eveva ava vironu sedo ghusira. A kae evetu genembo, kae dombu eni dombu eni, ava seari isambu jejebugedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Evetu genembo a natofo numokena totorugedo ghusera, ava gosuse, nendae joka edo ghusira. Ainda beká mo: ne kau sifi (sheep) giti jighari iraede ainda kakaugo ava use, dubo mema use jebuga da sonemba eni jo tambaeri. ");
INSERT INTO kpr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ava gido, nunda ambo jimbikena sisira, “Ghaeko da sifo buviri, vare beká etira. Avata bayau bambari embo jo digari iraeri. ");
INSERT INTO kpr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ava sedo, vare Numamokena bayau bambari embodae benunu sevu!” namanekena aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu aghi etiri namane totorugetero, fakina namanekena futusira. Amo nu, sukaru bu fugari a saoro kae evetu genembo jebugari ainda fakina ava, namanekena futusira. ‘Namane’ sise resena emo, Bajari namane nunda ambo jimbi beká 12 ava gategusira, aindae resena. ");
INSERT INTO kpr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amo, namanenda javo eviri. Giti mo, Simon (o Peter seraera), a nunda namendi Andrew ri. Mendeni mo, ne Zebedee da sasingu James nengae John ghaeri. ");
INSERT INTO kpr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Mendeni mo, Philip nengae Bartholomew ghaeri. Mendeni mo, namane Thomas ghaeri. (Namo, giti takesi bari kato edo iriani). Mendeni mo, Thaddaeus nengae Alphaeus da mandighaeri. Alphaeus da mandi resena emo, nu James da nunombori. ");
INSERT INTO kpr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","A kotugo eni mo, Simon da nunombo o Simon ‘Reighi Susu’ seraera, a eni mo, Keriot embo javo Judas. Judas resena emo, nune aito etiri Iesu doruseri. ");
INSERT INTO kpr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Javo setena amo, namane isambu 12 evia, Iesu dirigari yaoro dae sise, eminge sisira, “Namonde Israel embo da gitofukena o Samaria embokena, ne jo yae areva. ");
INSERT INTO kpr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ne namondeda natofo, Israel embokena ya vironu sareva. Ainda beká mo: ne God da natofori+. Avata ne God da emboro+ kosasaghedo, ambari dae erera. ");
INSERT INTO kpr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yasivu! God nunda natofo+ kaifa arira da sifo ojira utua etira ava, osa saovo ningore! ");
INSERT INTO kpr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Saovo, kae evetu genembo jejebugaore! Saovo, ambari embo sekago jebuge erore! Saovo, evetu genembo tamo bedode jejebugaore! A sukaru evetu genembokena asugedo irarera amo, ondovo vose darigaoro, jejebugaore! Ne ainda fakina ava, mino tefo bevu. Kau daba aminga ava, tefo sonembevu, evetu genembo jejebugaore! ");
INSERT INTO kpr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ne esa yareva. Avata moni eni, ghamana (gold, silver o copper), jo budo ainghae deinghae areva. ");
INSERT INTO kpr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Erá nenda javo, tamo asugari da tuka, ata asugari, a nenda ketua budo yeove! Ainda susu mo: saramana kato nu saramana ururari, nati embo nunda uvu bayau tefo mutoro baeti. ");
INSERT INTO kpr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ne ya reighi eninda buvareva amo, genembo evevago tambudo ya numokena avareva. Erá ya kambo eninda aveove! Kambo daba aminda irise, saramana aovo dadabari, javi edo yareva. ");
INSERT INTO kpr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ne kambo ningiaminda buvareva amo, eminge sise ategi evu, ‘Bajari da dubo jama nemokena furare!’ aminge ategi evu! ");
INSERT INTO kpr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kambo resena, ainda natofo ivugaghae nati joká doruse unumbarera amo, ne Bajari da dubo jama ategi use mutareva ava, dovu nemokena irare! O ne imboe arera amo, ne Bajari da dubo jama saghimbe buvu! ");
INSERT INTO kpr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A eni mo: kambo o reighi eninda natofo ne ighagha edo, nenda geka jo ningae edo nendae nati joká jo dae arera amo, reighiá do buvurutuse, nenda ata danghevu, fonja aminda vosare! ");
INSERT INTO kpr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kotovo dae sise resena. Amingareva amo, Ategi da Sifo aminda, God nu Sodom a Gomora embodae itako joka arira. O reighi aindae, jo joka ae arira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ningi gogoghombevu! Ne kau sasingako amingo ava, na ne dirigeteno gegenembo ekoko aikena yari dae ereva. Ne kote gogoghombaetevu. Avata erá ari ekoko ari dae sedo manaka garuse aindae, fakina eove! ");
INSERT INTO kpr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Diti gosuse kaifa evu! Ainda beká mo: evetu genembo mendeniimi, ne sandi bu yaoro, nenda dengoro indari kambo+ aminda terovo koto use, ne ambíi daoro mema itatamareva. ");
INSERT INTO kpr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ne nanda natofo edo ireva ava sedo, ne sandi dedo bu jumbu yaoro, gavana da babojegari a kini (kings) mendeni da dombuda fetovo koto arera. Koto ururoro, ne nanda Bino Eveva ava, osa sirurovo ne nenda natofode ningarera. ");
INSERT INTO kpr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nenda koto ari da sifoda, geka rea sareva a nange saeteva aindae, erá teria futo koteove! Ainda beká mo: sifo aminda, ne rea sari dae areva, Asisi Kakara ai ijugururari ne geka sareva. ");
INSERT INTO kpr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ne jo totofo nenda kotari ava sae areva. God Afa da Asisiimi, sonembururari nunda geka ava sareva. ");
INSERT INTO kpr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sifo ava fururarira amo, gegenembo nenda jamena ava sandi mutoro daoro ambarera. Kau daba aminga ava, gegenembo nenda sasingu ava sandi mutoro daoro ambarera. A sasingu barago, noi numamo ava sandi mutoro daoro ambarera. ");
INSERT INTO kpr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ne namo tumonderaeva aindae sedo, evetu genembo isambu ne imboe arera. Avata mave fakina edo, namo tumonduse jo ighagha ae iria, ambari tano arira amo, jebuga evovodae irari ava, nune tuve barira. ");
INSERT INTO kpr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ne nanda natofo edo ireva aindae sedo, ne daoro mema itatamareva amo, avori, reighi amo dodo, reighi eninda ya aminda saramana areva. Aminguse, reighi tomanako Israel einda jokáda birurughuse, vironu sise Israel embo da reighi mendeni aminda jo ya buvae irovo, Evetu Genembo da Koro+ jovereghe furarira. ");
INSERT INTO kpr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ijuga kato mo, nu teriari. O nunda ambo jimbi mo, ne kikitakori. Kau daba aminga ava, kotofu nu teriari. O nunda sabua+ mo, ne kikitakori. Evetu genemboimi ijuga katoá o kotofuá jo kakara ae arera amo, nenda ambo jimbi barago jo kakara ae arera. ");
INSERT INTO kpr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ne namoá avavaga ari dae sedo, nanda ambo jimbi edo ireva. Ava sedo, evetu genembo nandae siruroro ningiraeva aminga ava, amboda nendae siruroro ningareva amo, ne ivuga aetevu! Evetu genembo mendeni ‘na Satan va’ seraera. Ava sedo, nendae, ‘ne sukaruva’ siruroro ningareva amo, erá aindae manamana use dubo mema eove!” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Aminge sise, Iesu sisira, “Avori, evetu genembodae erá oju eove! Oroko rea ufena use jungeraera amo, amboda isaghada garera. Oroko rea kivo eraera amo, amboda isagha saoro ningarera. ");
INSERT INTO kpr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na oroko rea sainghe seraena amo, amboda ne vironuda sareva. Eminda namonde rea kikiako se ningeraera amo, ne amboda ofotighida fetedo koko sise sareva, evetu genembo da dombuda. ");
INSERT INTO kpr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Avori, evetu genembo ne imboe arera amo, ne daoro ambareva. Avata amo, tamoi ambarira. Asisi nu irarira. O God ne imboe arira amo, ne dari tamo a asisighae dabade ya, ari ekoko mino mutari vasada teredo evovodae irareva. Aindae sedo, God nusuka nundae oju aetevu! ");
INSERT INTO kpr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Eni mo: rika kaghá ajamena kote givu! Ne rika isambu etoto ombari saeteva amo, toea dabako avavagai ombaetevu. Amo, ne roera kikitakori. Avata God Afa jo doyae arira amo, eni jo ambae arira. God nu rika kaghá ajamena kaifa e gogoghomberaira. ");
INSERT INTO kpr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Ava sedo, ne God tumonduse ambari dae oju jo ae aetevu. Ainda beká mo: God nu rika kaghá ajamena itako dubo buraira. Avata God da dubo bari namonde evetu genembokena mo, teriago bekári. Nenda jiroda, beo anakora afige gi tege tefo usira. Ava sedo, ne jo kosasaghari da kaugo iraeri. Erá oju eove! God Afa nu rika kaghá ajamena kaifa eraira amo, kau daba aminga ava, ne kaifa e gogoghomberaira. ");
INSERT INTO kpr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Na eminge resena: mave nanda tofo edo irise, natofo da dombuda Evetu Genembo da Koro+ da javo jighari erarira amo, Evetu Genembo da Koro+ genemboá, nu God Afa da aneya da dombuda jo ighagha ae arira. ");
INSERT INTO kpr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","O mave na natofo da dombuda imboe edo ighagha arira amo, numbarago God Afa da aneya da dombuda, Evetu Genembo da Koro+ nu imboe edo ighagha arira. ");
INSERT INTO kpr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ne erekoteva, na mainungari bu furariá reseva. Tefo. Ne erá aminge koteove! Na beisiga a ghoghora tataya ava bu refena. ");
INSERT INTO kpr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Evetu genembo namoá tumondaoro dae, o ighagha aoro dae sedo, refena. Amingururono, vide jamena nenda numamomanede dabade beisiga edo sarigarera. Ade jamena nenda noimanede dabade beisiga edo sarigarera. A mamandisiri nenda imbobotide dabade beisiga edo sarigarera. ");
INSERT INTO kpr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sifo aminda, genembo ainda natofo beká aimi, numokena gitofu arera. ");
INSERT INTO kpr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Mave noi numamo dubo ruruse aindae, na kotae arira amo, nu jo nanda natofo ari da kaugo iraeri. Kau daba aminga ava, mave nunda mandi o nunda gagara dubo ruruse aindae, na kotae arira amo, nu jo nanda natofo ari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mave nanda ambo jimbi edo, namonde dabade deinghari sarira amo, nu emingarira. Nu namoá tumonderaira aindae sedo, gitofuimi nu daoro ambare dae sarera amo, nu jo oju ae arira. A nane rea eraena ava, nu ari kau daba ava udo yarira. Nu jo amingae arira amo, nu jo nanda ambo jimbi ae arira. ");
INSERT INTO kpr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mave nu enda da gugua kotise, nanda javodae ambari dae oju edo na doyarira amo, nu sifo amboda ambarira. O mave nandae sedo ambarira amo, nu amboda jebuga evovodae irari ava tuve barira. ");
INSERT INTO kpr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mave nindae nati joká doruse, bu tavo arira amo, nu inono, namoá nati joká doruse, bu tavo arira. Kotugo, mave nandae nati joká doruse, bu tavo arira amo, nu inono, God Afa namo dirigetiri fusena, ava nati joká doruse, bu tavo arira. ");
INSERT INTO kpr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kau daba aminga ava, mave God da aghi kato nati joká doruse, nu God da javoda refira aindae sedo, bu tavo arira amo, God Afa amboda rea nunda aghi kato aikena mutarira, kau daba ava mutari, genembo nati joká dorusira, ábarago barira. Kau daba aminga ava, mave genembo evevadae nati joká doruse, nu genembo eveva aindae sedo bu tavo arira amo, God Afa amboda rea genembo eveva aikena mutarira, kau daba ava mutari, genembo nati joká dorusira, ábarago barira. ");
INSERT INTO kpr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A geka kau daba ava kotovo dae resena. Mave nanda ambo jimbi ijoghako eni gido kotarira, ‘Genembo omo, nu Iesu da ambo jimbi ava sedo, na sonembe uvu mutarena,’ aminge kotise, uvu mutarira amo, na numokena mino mutono barira. Jo kosasaghae arira. Emo, geka beká nemokena resena,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu nunda ambo jimbi 12 ava dengoro indiri dadabetiri, nu eredo reighiá dodo, ainda tinguda, reighi mendeni aminda deinghuse vironu sise ijugedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","John Bafataito Ari Kato sandi diburada fitero irise, Iesu rea edo ghusira, ainda bino ava niningusira. Ningido, nunda ambo jimbi dirigetiri, Iesu gari dae sedo iseri. ");
INSERT INTO kpr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Era, Iesu kena buvudo, ategi useri, “Ni, se ningore! God Genembo eni dirigari furarira ava, John vironu sise sedo ghusira amo, nimori, ai? O namane genembo eni kaifa aore?” aminge ategi useri. ");
INSERT INTO kpr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Etero, Iesu nemokena sisira, “Ne jovereghe yasivu! Na rea eno eregoseva, a seno niningereva, ava osa sevu, John ningare! ");
INSERT INTO kpr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na seteno evetu genembo diti digoide ava, fangetiri sifo sevo eregosera. Seteno evetu genembo daguna, jebuge eredo atai fete deingherera. Seteno evetu genembo tamo bedode a isode, utetegetiri jebugeteri. Dengoro gajari embo amo, seteno dengoro afigetiri, geka niningerera. Seteno ambari embo uroda ghe, jebuge ereteri. A vironu seno, makasi embo ne God da Bino Eveva ava niningerera. ");
INSERT INTO kpr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mave nandae sedo meka gosuse aindae, na jo imboe ae arira amo, nu amboda dubo jama tambarira,” aminge setiri ningido, John da aghi kakato jovereghe iseri. ");
INSERT INTO kpr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","9","Ne jovereghe ero, nu tuturo edo natofokena John da geka ava vironu eminge sisira, “Ne giti redae reighi uvu ã evetu genembo irae da vasa aminda isevu? Ne jo reighi gari dae sedo yaeri. Ne John gari dae sedo isevu. A ne, genembo kau mavega ava tambari dae sedo isevu? Genembo dubo kotari iraede, ai, dubo kotaride? Ne jo nunda tamo asugari ã gogho ava gari dae sedo yaeri. Ava gari kotaeteva amo, ne ya kotofu da kamboda tava aetevu. Ava sedo, rejo tambari dae sedo isevu? Avori, saono ningivu! Nemo, God da feroveta ava tambari dae sedo isevu. Emo, na geka beká sari dae erena. Feroveta digari irera einda teriago mo, John ri. ");
INSERT INTO kpr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","A God Afa, John nanda emboro rerebare dae sedo, numoá gategusira. God nunda Geka John dae sise, setiri gefusera amo, eviri: ‘Kote gi! Nanda aghi kato ava, giti dirigaono ya ninda emboro rerebururari, ni amboda yaresa,’ aminge gefuseri. ");
INSERT INTO kpr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kotugo na eminge resena. John Bafataito Ari Kato nu genembo teria bekári. enembo eni numongoá jo sirorae irera. Avata na emboro+ seka God kena afigaono, mave aminda ise a tumonduse God da natofo+ arira amo, nunda dubo kotari a ivuga amo teria arira. Aimi, John da dubo kotari a ivuga amo darigarira. ");
INSERT INTO kpr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","John tuturo edo geka sisira, ai tano ghedo ojira oroko eminda buvira. inda jokáda, evetu genembo God kena teredo nunda natofo+ ari dae sise, utu da guro ava ininighae eresorera. ");
INSERT INTO kpr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","John jo sirorae iriri, God nunda natofo+ kau nange nange kaifa arira ava, Moses a God da ferovetaimi gefudo fero John sirorusira. ");
INSERT INTO kpr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ava sedo, geka evia ningido tumondaovo dae sise resena. God da feroveta Elijah jovereghe furariá, sedo ghusera amo, John dae sedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Geka emo, dengoro jave ningi gogogho aovo dae sise resena. ");
INSERT INTO kpr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Evetu genembo oroko endada siroredo ireva emo, kau mavegori? Ava sari dae erena. Ne John Bafataito Ari Kato imboe usevu, a kotugo na imboe ereva. Nemo sasingako da kakaugori. Sasingako mo, ne ofotighida yaru use tofo tofo beisiga use, ghoghora eminge sirureoro ningiraera, ");
INSERT INTO kpr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ne imboe kakatori! Namane esimbuguse yaru divari da kau etera, ne jo namonde divaeri. Amboda, kau ambari budo sorara arigetera, ne jo namonde sorara aeri. Ne beisiga a imboe kakatori!’ amo sasingui eraera. Evetu genembo oroko endada siroredo ireva emo, ne kau daba ava eraeva. ");
INSERT INTO kpr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","John Bafataito Ari Kato fira, vaini (wine) reeta use God tambari dae sise, bayau kanangara edo ghusira. Eari, ne sedo ghusevu, ‘Sukarui John kena asugetiri daghusira,’ aminge sedo ghusevu. ");
INSERT INTO kpr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","O Evetu Genembo da Koro+ foa bayau rise vaini (wine) rirureari gido seraeva, ‘Genemboé givu! Nu bayau mindari kato, a vaini (wine) da oduso katori. Nu evetu genembo eko beká aikena, komana eraira.’ Evetu genembo oroko endada siroredo ireva emo, ne aminguse beisiga eraeva. Avata na eminge resena. Na mavejori, a John mavejori, ava evetu genembo duboi kotarera amo, ne kasama arera,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iesu tuturo edo, reighi mendenikena ghoghora sisira. Nu reighi mendeni aminda ise, tano isagha eari siroreari, evetu genembo ne jo gae iriara ava, nenda gitida siroreari gido dudukughedo ghuseri. Nu evetu genembo aindae, ghoghora sisira. Ainda tuka mo: ne nunda tano eari gido ghusera, avata nenda ari ekoko jo vujegedo dubo jovereghaeri. Ghoghora sise, eminge sisira, ");
INSERT INTO kpr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Arie, Korasin embo a Betsaida embo! Nemokena sari dae erena! Ne sifo amboda mema teria beká ava itatamareva. Ainda beká mo: ne nanda tano a ari mendeni mendeni eono gido ghuseva, avata ne dubo jo jovereghae, kau daba ava ireva. O nanda fakina a tano evia, namondeda gitofu da reighi Taiar a Saidon aminda, ijugaono gaetera amo, ne anakora nenda ari ekoko vujeguse, dubo jovereghari da tano ijuguse, bovora fire asuge vaya gutaeteri. ");
INSERT INTO kpr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ava sedo, Ategi da Sifo aminda, Taiar a Saidon embokena God joka ari, ne mema itako tambarera. O reighi Korasin a Betsaida embo resena emo, ne mema teria beká ava tambarera. ");
INSERT INTO kpr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Kaponiam embo, nemokena kau daba ava resena. Ne totofo nenda javo jighovo erare dae erekoteva. Avata jo amingae areva. Amo, God sari ne bako eko aminda dudo ya vosareva. Ainda beká mo: ne nanda tano a ari mendeni mendeni eono gido ghuseva, avata ne dubo jo jovereghae, kau daba ava ireva. O nanda fakina a tano evia, namondeda gitofu da reighi Sodom aminda, ijugaono gaetera amo, ne anakora nenda ari ekoko vujegedo dubo jovereghaoro, God joka ari ne jo sirivo ae, oroko iraeteri. ");
INSERT INTO kpr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Evia kotovo dae resena: Ategi da Sifo foa buvarira aminda, Sodom embo nenda ari ekokodae God anakora dorusira amo, ne mema itako tambarera. O Kaponiam embo nemokena eminge resena: God nemokena mema teria beká ava mutari bareva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sifo aminda, Iesu banunguse sisira, “Afa, ni utu a enda da Bajari nimori. Na nimokena aiyakoe resena. Ainda susu mo: ninda geka kivo edo evetu genembo diti basari kena jo ijugae usesi, avata evetu genembo kotari veveyako a diti basae embo aikena ijugeteso isagha usira. ");
INSERT INTO kpr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Amo, ni amingari dae uju usesi,” Iesu aminge banungetiri dadabetiri, nu tuturo edo sekago natofokena vironu sisira, ");
INSERT INTO kpr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Nanda Afa roera isasambu evia, nane kaifa aono dae sedo, futusira. God nusuka nunda Mandi kasama erira. Kau daba aminga, God da Mandi nusuka nune, numamo kasama erira. A evetu genembo mendeni nune gategarira amo, nune ijugururari, ne God Afa kasama arera. ");
INSERT INTO kpr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Namokena fuvu! Mave irise bouvu erefufira amo, namokena fururovo, nanda dubo jama nemokena futurono, dubo eveva use jangutareva. ");
INSERT INTO kpr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nanda ango sagada evia budo fufurovo, na ijugaono kasama areva. Na sabua+ da ari ava use, veka eveva edo durumuguse ijugururono, nenda asisi jokáda aimi, dubo jama torughuse jangutareva. ");
INSERT INTO kpr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ai resira amo: nanda ango mo feghakori, a saramana nane muturaena amo, jo bouvu iraeri,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ainda amboda Jangutari da Sifo aminda, namane Iesu de dabade, genembo eninda vare begatada sembise, namane ighoi etiri, farava da vuji ava bambudo, ungoi jase rido iseri. ");
INSERT INTO kpr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Namane amingero, Moses da Geka kaifa kakato+ mendeni ava gido Iesu kena siseri, “E gi! Ninda ambo jimbi namondeda agho dari ava bejise, farava omo bambu rerera. Jangutari da Sifoda, ari ovia use saramana arigetera omo, jo ae aeteri,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Setero, Iesu eredo nemokena mino sisira, “Ne namondeda abua David da kiki eni tegutusevu, ai? David nunda mendeninde dabade, ighoii sirivo use, nange usira amo, tegutusevu, ai tefo? ");
INSERT INTO kpr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nu ira God da Kamboda+ teredo, farava God kena futusera aindae, benunu setiri fristi+ mutiri, David nunda mendeninde dabade budo riseri. Amingusera amo, ne namondeda agho dari ava bejiseri. Agho dari bejisera amo, eviri: ‘Fristi+ nesuka farava kakara amo mindaeteri,’ agho dari aminge resira. ");
INSERT INTO kpr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","O eni mo kote givu! Geka God setiri Moses gefusira, ainda jokáda eminge ijugerira: God da Kambo+ ainda saramana use, fristi+ ne Jangutari da Sifo jo kotae eraera. Ne God da Kambo+ jokáda saramana mendeni eraera amo, namondeda agho dari ava bejeraera. Avata ne God da saramana ava use bejeraera aindae, God nu jo janje eko ae eraira,” ");
INSERT INTO kpr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Iesu aminge sise, nu tofo numoá kivo use eminge sisira, “Genembo eni eminda irira, a nu genembo teriari. O God da Kambo+ mo kitakori. ");
INSERT INTO kpr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","O God da Geka eni mo eviri: ‘Nanda Agho Dari kotise, joba namokena mutareva amo, evevari. Avata, nanda uju beká mo: ne totofo nenda ghamo jokáda, joka ari a kote doyari ava irari iraetevu,’ God da Geka aminge resira. God da Geka evia kasama e gogoghombaeteva amo, evetu genembo mendeni, kotari a ari eveva eraera aikena, ne jo ghoghora sae aetevu. ");
INSERT INTO kpr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","“Geka beká mo eviri: Jangutari da Sifo aminda rea ava aetera amo, ábarago, Evetu Genembo da Koro+ nunda sari ningariri,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Setiri dadabetiri, Iesu vareá dodo ira, nenda dengoro indari kamboda+ teterusira. ");
INSERT INTO kpr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Genembo eni ungo gimandu dimbaride amo, aminda anumbiriri, Iesu ira teterusira. Teretiri, evetu genembo mendeni aminda anumbiriserai, ne Iesu dederuroro geka sembae sari ningido koto ari dae sedo, numokena ategi useri, “Se ningore! Namondeda Agho Dari nange resi? Jangutari da Sifo aminda, sonembaoro kae evetu genembo jebugedo ghaeteri, ai? Jo sonembedo ghae aeteri? Ava se ningore!” ");
INSERT INTO kpr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aminge setero, Iesu mino eminge sisira, “Kote givu! Nenda sifi (sheep) eni Jangutari da Sifo aminda, ya bakoda vosaetira amo, ne nangaetevu? Ya jumbovo vitaeti? Ai, doyovo aminda iraeti? ");
INSERT INTO kpr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","God nu sifi (sheep) itako koteraira, o evetu genembo mo, nu dubo bu gogoghomberaira. Ava sedo, namondeda Agho Dari ijugerira amo, namonde evetu genembo Jangutari da Sifo aminda barago sonembaeteri,” ");
INSERT INTO kpr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Iesu aminge sedo, jovereghedo genembo ungo dimbaride aikena sisira, “Ninda ungo jujurege, gaone!” aminge setiri, genemboá nunda ungo Iesu kena siregiri eveva usira, ungo soveni avavaga usira. ");
INSERT INTO kpr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Avata Moses da Geka kaifa kakato+ mo, ne ava gido eredo era buvudo, ne Iesu nange daoro ambaetira aindae, manaka garuse se nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","Ne manaka garero, Iesu ava ningido reighiá dodo isira. Iri, evetu genembo digari nu tambudo, nemonde dabade iseri. Ise, Iesu setiri kae evetu genembo isambu jejebuguseri. Jejebugetero, Iesu kovionoghae nemokena sisira, “Ne seteno jejebugeteva amo, erá osa seóvo ningeore!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aminge sisira da beká mo: God da feroveta Isaiah rea nundae sisira ava beká sirorare dae sedo, Iesu aminge sisira. Isaiah nu eminge sisira: ");
INSERT INTO kpr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nanda Saramana Kato gategusena amo, eviri. Na nundae ivuga beká use, dubo bu gogoghomberaena. Na numokena nanda Asisi mutono budo, nanda javoda evetu genembo bekáda bekáda ategi arira. ");
INSERT INTO kpr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Avata aminguse, nu durumugarira. Nu jo bibita ae arira. Beka fakara jo sae arira. Nu emboroda ise, sainghiako roboghoi sido yarira. ");
INSERT INTO kpr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tumondari o jebuga kitakatako ava tambarira aimi, undari mindafu arira. Aminguse, geka beká a God da Geka beká ava jighari baji mindafu beká ari, ");
INSERT INTO kpr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","evetu genembo isambu nu tumondarera,” Isaiah da geka Iesu dae aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ainda amboda, evetu genembo mendeni genembo eni ava, Iesu kena budo fuseri. Genembo amo, sukarui asugetiri guga edo diti sembae etiri irei. Ava gido, Iesu setiri nu jebugedo, beka sise ditii fuge gosusira. ");
INSERT INTO kpr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Etiri, natofo isambu fuge nu gido, manamana use se nininguseri, “Kini (King) David da Mandi God mutari sisira amo, numori tanojo.” ");
INSERT INTO kpr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ava sero ningido, Moses da Geka kaifa kakato+ eredo eminge siseri, “Genembo omo, jo tofo nunda fakinaimi o God da fakinaimi, sukaru bu fugae eraira. Omo nu, sukaru da bajari javo Satan, nunda fakina ava muteari budo aimi, sukaru bu fugeraira,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Avata ne rea kotise sisera, Iesu anakora kasama usira. Kasama edo aindae sisira, “Frovensi eni ainda natofo beisiga edo, soroda sarigarera amo, frovensi ainda fakina soesa arira. Kau daba aminga ava, reighi eni o oro eni beisiga edo, soroda sarigarera amo, reighi o oro amo jo fakina edo fetae arera. ");
INSERT INTO kpr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na Satan da fakina budo aimi, nunda sukaru bu fugeraena ava sedo, na Satan da eniva reseva. Avori, saono ningivu! Satan da natofo tofo tofo beisiga edo, soroda sarigarera amo, fakina edo fetarera, ai? Ava kote givu! ");
INSERT INTO kpr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Eni mo: ne eminge sise reseva, Satan namokena fakina muteari budo aimi, na sukaru bu fugeraena. Avata, nenda ambo jimbi totofo aghi useva, nenda ari ava kote givu! Nenda ambo jimbi sukaru ondiraera amo, mave da fakinaimi ondiraeri? Kote givu! Ava sedo, totofo nenda ambo jimbi eraera ava kotise, kasama evu! Ne nandae aji sise gungubo setevu! ");
INSERT INTO kpr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Geka beká mo: na God da Asisi da fakinaimi, sukaru bu fugeraena. Sukaru bu fugeteno, God da fakina isagha etiri eregoseva. Evia gosuse, God evetu genembo tofo kaifa ari sisira, ainda sifo orokoá ojira nemokena buvira, ava kotaetevu! ");
INSERT INTO kpr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Mave jo kotae kotae, genembo fakina kato ainda kambo beje teredo, nunda roera a gugua bagia ae arira. Nu giti, genembo fakina kato amo, sandi bundedo amboda nunda roera a gugua sosighi arira. Kau daba aminga ava, na Asisi Kakara da fakinaimi, Satan da fakina gajedo, seono nunda sukaru vose darigeraera. ");
INSERT INTO kpr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mave na jo sonembae arira amo, nu inono, Satan sonembarira. Kau daba aminga ava, mave na jo sonembae, a evetu genembo unumbae arira amo, nu inono, evetu genembo ondari soesa ururoro, Satan foa ne barira. ");
INSERT INTO kpr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Na aindae sedo nemokena resena. Mave ari eko eni edo o geka eko eni sedo, amboda God kena vujegarira amo, God nunda ari eko amo kote doyarira. Avata mave Asisi Kakara da javo eko arira amo, God nunda ari eko amo jo kote doyae arira. ");
INSERT INTO kpr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kau daba aminga ava, mave Evetu Genembo da Koro+ da javo eko arira amo, God nunda ari eko amo kote doyarira. O mave Asisi Kakara da javo eko arira amo, God nunda ari eko amo jo kote doyae arira, evovodae irarira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Aminge sise, Iesu sisira, “Vuji eveva bambari saresa amo, ya ika eveva aminda bambaresa. O ika eko aminda, vuji eveva eni jo bambae aresa. Ainda beká mo: ika kau mavego amo, nunda vujida gi kasama aresa. ");
INSERT INTO kpr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ne kau daba avori. Ne Satan da sasinguri. Ava sedo, geka eko avanembo seraeva. Ainda tuka mo: genembo nunda dubo jokáda rea kotise irá gheraira amo, avanembo sise irá gheraira. ");
INSERT INTO kpr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Genembo eveva amo, nunda dubo jokáda eveva vanembo ava koteraira. Aminge kotise, geka eveva vanembo sise, veka eveva use irá gheraira. O genembo eko amo, nunda dubo jokáda eko vanembo ava koteraira. Aminge kotise, geka eko vanembo sise, nunda irari a evetu genembo mendeni da irari aimi bebeta eraira. ");
INSERT INTO kpr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na nemokena resena: Ategi da Sifo aminda, God nu evetu genembo isambu da geka ava ijujarira. Evetu genembo ne, geka rea kotae kotae seraera, ava ijujarira. ");
INSERT INTO kpr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Geka rea nine sedo ghusesa, ava ijujedo, God nimokena mino eveva o eko ava mutarira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sifo eni, Moses da Geka ijuga kakato+ a kaifa kakato+ eredo benunu siseri, “Ijuga Kato, ni tano eni aso gari dae resera!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Setero, Iesu ningido sisira, “Evetu genembo siroredo oroko endada irera, ne taká ekoko bekári. Ne God itako jo kotae eraera. A ainda mendeni nemori. Ne tano ijugaono gari dae reseva. Avata na jo ururono gae areva. Nu dabako, Jonah rea usira ava ururono, ne gido dudukughareva. ");
INSERT INTO kpr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“Jonah nu, sifo tumba etodaba naká, oka da tini jokáda ireira edo, fira buvurutusira. Kau daba aminga ava, Evetu Genembo da Koro+ sifo tumba etodaba naká, enda jokáda iria edo erarira. ");
INSERT INTO kpr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","A Ategi da Sifo aminda, Nineva embo eredo God da dombuda fetedo, nenda ari ekoko eraeva aindae, osa sarera. Ainda beká mo: Jonah vironu setiri ningido aindae, nenda kotari eko a nenda ari ekoko vujeguseri. O nemo, genembo fetirise geka resira, einda geka ningari imboe eraeva. Avata, Jonah nu genembo ijoghakori. O genembo oroko fete geka resira emo, nu teria bekári. ");
INSERT INTO kpr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Frovensi Siba ainda evetu kotofuko amo eredo, Ategi da Sifo aminda God da dombuda fetedo, nenda ari ekoko eraeva aindae, osa sarira. Ainda beká mo: nu reighi soka beká aminda ireira ava dodo, Kini (King) Solomon da dubo kotari a ijuga ava ningari dae sedo fusira. O nemo, genembo oroko fetirise resira einda geka ningari imboe eraeva. Avata, Solomon nu genembo ijoghakori. O genembo oroko fetirise geka resira emo, nu teria bekári. Ava sedo, ne redae nanda geka jo tumondae erevu? Amingereva amo, eko bekári!” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Aminge sise, Iesu sisira, “Sukaru genembo enikena asugetiri ireira aimi eredo, genembo da jokáda ghe buvudo, jangutari da vasa tambari dae, ya reighi uvu irae da vasa aminda birurughuse deingharira. ");
INSERT INTO kpr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tava e bune jaredo eminge sarira, ‘Na eminda birurughuse iria jararena amo, jovereghe ya nanda kambo manai aminda terarena.’ Aminge sedo, jovereghe ya nunda kambo manaiá tambarira. kambo amo, nasara tafono etero eveva edo irira. Kau, kambo joká seghe gogho eraera aminga ava, genembo da dubo jokáda tambarira. ");
INSERT INTO kpr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tambudo, jovereghe ya nunda kokomana 7, sukaru ekoko beká ava, unumbe budo foama, genembo aikena asugarera. Giti mo, genembo amo, mema itako itatamuse irei. Avata, sukaru dabako aimi yama, nunda kokomana 7 ekoko beká ava unumbe nemonde 8 edo foama, genembo aikena asugarera amo, nu mema teria beká ava itatamarira. Evetu genembo oroko siroredo endada irera eikena, kau daba aminga ava sirorarira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu aminge siri, nunda noi a nunda jamenade fera buvudo isaghada fetedo, numokena geka sari dae siseri. ");
INSERT INTO kpr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Setero, enii eredo ira Iesu kena sisira, “Nei a ninda jamenade dabade isaghada fetirise, nimokena geka sari dae kaifa erera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Setiri, Iesu jovereghe ategi usira, “Nanda aya a nanda jamena mavejori?” ");
INSERT INTO kpr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Iesu aminge sedo, ungo namanekena sireguse sisira, “Givu! Nanda ambo jimbi eregoseva emo, nanda aya a nanda jamenari. ");
INSERT INTO kpr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mave nanda Afa utuda irira, ainda uju ava use irarera amo, nanda ai ghasovu, nanda nano namendi, a nanda aya mo, nemori,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sifo daba aminda, Iesu kamboda ghe ira, uvu da teria irira ainda betuda anumbedo, tuturo edo ijugusira. ");
INSERT INTO kpr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ijugiri, evetu genembo digari numokena fera totorugedo vasa ganjibuseri. Etero jaredo, nu ghaka+ feghiri gido, ghaka+ jokáda vose anumbetiri, evetu genembo isambu fera buvudo, uvu betuda fefetuseri. ");
INSERT INTO kpr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Fetetero, Iesu nemokena kasiaimi sise, geka mendeni mendeni ijuguse, eminge sisira, “Genembo eni eredo, farava veka govari dae sedo, aira nunda vareda buvudo, ");
INSERT INTO kpr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","tuturo edo, veka giririghe budo jife jafe getira. Etiri, veka mendeni mo, begatada vosetiri, rikamanei ojighera minderi. ");
INSERT INTO kpr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Veka mendeni mo, aroro etoda vosedo totoi batuno etiri, ");
INSERT INTO kpr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ijiimi aviri gharasa etira. Enda jo teria irae ava sedo, besisi jo baeri. ");
INSERT INTO kpr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Veka mendeni mo, vive titifaghae ainda jokáda vosedo, viveghae dabade itira. Ainghae vitido, vivei gaetiri dadabetira. ");
INSERT INTO kpr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A veka mendeni mo, enda eveva aminda vosedo vitira. Vitido, beká jighira amo, mendeni 100, mendeni 60, a mendeni 30, avavaga jighira. ");
INSERT INTO kpr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kasia setena amo, dengoro jave ningi gogoghombevu!” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Setiri dadabetiri, namane Iesu kena era ategi useri, “Ni redae, evetu genembo mendenikena geka vironu kasiai seraesi?” namane aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iesu sisira, “God Afa, kau nange nunda natofo+ kaifa eraira, ainda geka mendeni ava kivo usira. Ne nanda ambo jimbiri. Ava sedo, nu rea kivo usira ava, nemokena isagha saono ningi kasama aovo dae seraena. O mendenikena jo amingae eraena. ");
INSERT INTO kpr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ainda beká mo: mave God da Geka ningido kotari eveva koteraira amo, God sonembari nu kote gogoghombarira. Avata mave God da Geka jo kotae eraira amo, God nunda kotari isambu bari dadabarira. ");
INSERT INTO kpr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ava sedo, na mendenikena kasiaimi ijugeraena da beká mo eviri: ne ditiimi gosuse jo gi gogogho ae arera, a dengoroi nininguse jo kasama ae arera. ");
INSERT INTO kpr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ne amboda amingarera aindae, Isaiah gekaé gefusira. Geka evia, orokoá beká siroretiri eregosevere. Amo eviri: ‘Ne dengoroimi ningido, tuka jo kasama ae areva. Ne ditiimi gaovo, diti jo basae arira. ");
INSERT INTO kpr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ainda beká mo: natofo eikena kotari jo afigae irira. Erama nanda geka ningeore dae sise, nenda dengoro gagojuseri. Erama nanda Geka tege kasama eore dae sise, nenda diti gagojuseri. Ava jo ae aetera amo, dengoroimi ningido, ditiimi gosuse tege kasama e gogoghombedo, ne dubo namokena jovereghaoro, na saono jebuga tambaeteri,’ Isaiah aminge gefusira. ");
INSERT INTO kpr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Na nemokena resena. Emo nenda makoeri! Ne diti fangedo dengoro afigetevu. ");
INSERT INTO kpr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Emo kotovo dae resena. Ne rea giraeva a ningiraeva ava, God da natofo+ digari a God da feroveta digari, ne ningari dae a gari dae uju edo ghuseri. Avata ne jo gaeri a ningaeri. Avata orokoé, ne giraeva a ningiraeva aindae sedo, ne ivuga aetevu!” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Aminge sise, Iesu sisira, “Genembo aira vare govetira, ainda kasia da beká ava ningi kasama aovo dae sise resena. ");
INSERT INTO kpr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mave God da Bino Eveva, nange God nunda natofo+ kaifa eraira, ava ningido tuka jo kasama ae eraira amo, nu rea ningiraira ava, amboda Satan foama, nunda dubo jokáda ufena saghimbe buraira. Amo inono, farava veka begatada vosetira, ainda kaugori. ");
INSERT INTO kpr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Veka mendeni aroro etoda vosetira, ainda tuka mo eviri. Mave God da Geka ningido ivugaghae buraira, ");
INSERT INTO kpr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","avata nunda dubo jokáda tumondari jo inono ae arira. Ava sedo, nu sifo tufako tumonduse irari, dara sirorarira, o nu God da Geka tumonderaira aindae, gitofu numokena fakarago use mema mutarera amo, nu oju use fakina jo ae irise totoi gofarira. ");
INSERT INTO kpr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Veka mendeni vive titifaghae ainda jokáda vosetira, ainda tuka mo eviri. Mave God da Geka ava ningido, nunda irari ava kotise, a enda da gugua ava bari dae koteraira aimi, God da Geka ava gajeari bunedo kotae eraira. Amingeraira amo, nunda tumondari da beká ava jo sirorae eraira. ");
INSERT INTO kpr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","O veka mendeni, enda evevada vosetira, ainda tuka mo eviri. Mave God da Geka ningido kasama eraira. Ainda beká jighiraira amo, 100, 60, a 30 avavaga jighiraira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu aminge sise, kasia eni eminge sisira, “God da natofo+ nenda irari kau emingori. Genembo eni farava veka eveva budo, aira nunda vareda govetira. ");
INSERT INTO kpr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Etiri, tumba eninda, nunda gitofu eniimi ojira, farava jokáda vive eko ava gove dodo aira. Vive amo, nunda tamo a ifu kau farava da tamogori. Jo totoi kasama edo tuse fugari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Viveá govetiri, farava viveghae jinemba edo viti mindafu edo, beká jighari da sifo ava utua etira. Etiri, vive mendeni ainda kau isagha beká ava etiri gido, ");
INSERT INTO kpr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","vare numamo da saramana kakato mendeni aera numokena seteri, ‘Arie, Bajari! Nimoá vare eveva govetesi. Avata, vive eko jokáda emo, nange siroreti?’ ne aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","genemboá mino nemokena setira, ‘Nanda gitofu eniimi ojira govetira,’ aminge setira. Setiri, ne numokena seteri, ‘Ya vive tusore, ai? Namane nangareri?’ ");
INSERT INTO kpr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Aminge setero, nu setira, ‘Tefo, dovu irare! Ainda beká mo: ne vive tusareva amo tususe, farava veka eveva ainghae dabade tusareva tanojo. ");
INSERT INTO kpr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aminge dovu, farava vive eko ainghae dabade irise, safufu ari gido, na bambari kakatokena eminge saono ningarera, ‘Giti yama vive eko tusedo, avarakada dungari dae sedo, sijareva. Amboda yama farava bambudo, nanda kamboda fitareva!’ vare numamoá aminge setira. Kotugo God da natofo+, nenda irari kau amingori,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Iesu aminge sise, kasia ika mainekena fifituse sisira, ‘God da natofo+ digarigo eraera amo, kau ika maine da vujiimi vose batuno edo vitiraira, ainda kaugori. Maine da vuji mo, veveyako bekári. Nu jo ika mendeni da vujigo iraeri. Avata vuji avavaga, genembo enii bu yama nunda vareda govarira amo, nu viti vareda roera isambu darigedo mindafu ari, rikamane foa nenda mogha ainda fafatuda fitarera. Kau daba aminga ava, God da natofo+ tuturo edo digarigo sirorarera,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesu aminge sise, kasia yistikena fifituse sisira, “Kasia eni mo eviri. God da Bino Eveva urureari, evetu genembo ningido nunda natofo+ eraera amo, kau yisti farava jokáda tiveraira, ainda kaugori. Yistiá, evetu eni okia mindafu budo farava averegari vosari, yisti itatako bu ainghae gae joveregharira amo, yisti tive ya aimi, farava isambu baji vitido okia bedo arira. Amo inono, God da Bino Eveva urureari, evetu genembo ningido God da natofo+ digarigo siroreraera, amingori,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu natofokena vironu sise, kasia ainembo ijugedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Geka feroveta enii sisira ava, beká are dae sedo, Iesu amingedo ghusira. Geka amo eviri: ‘Nemokena dengoro induduse, kasiai sarena. Enda jo saono sirorae iriri, na irise, rea kotedo kivo usena ava, kasiai nemokena saono ningarera,’ feroveta aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesu kasia mendeni setiri dadabetiri ainda amboda, nu evetu genembo numokena totorugusera ava dodo ira, kambo eninda teterusira. Etiri, namane era numokena buvudo siseri, “Se ningore! Kasia vive eko eni govari setesa, ainda tuka mo, rejori?” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Namane aminge setero, Iesu mino sisira, “Genembo farava veka eveva govetira amo, Evetu Genembo da Korodae+ seteni. ");
INSERT INTO kpr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Vare setena amo, kau namondeda enda eviri. Veka eveva mo, inono, evetu genembo dubo jovereghedo God da natofo+ arera. Kotugo vive eko setena amo, inono, evetu genembo Satan da geka ningarera. ");
INSERT INTO kpr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","A gitofu mave vive eko govetira amo, Satan numori. Vive eko tusari a farava vuji bambari da sifo setena amo, inono, God Afa sari enda dadabari da sifori. Vive tusari kakato a vuji bambari kakato setena amo, ne inono, God da aneyari. ");
INSERT INTO kpr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kau namonde vive tusedo avarakai dungeraera aminga ava, enda dadabari da sifo aminda sirorarira. ");
INSERT INTO kpr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Evetu Genembo da Koro+ nunda aneya dirigari, evetu genembo jokáda deingharera. Deinghuse, evetu genembo mendeni nenda nano namendi ari ekoko aoro dae sedo dereraera, ari ekoko embo mendeninde dabade, ava gatege bundedo, ");
INSERT INTO kpr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","avaraka mindafu ainda jokáda fugoro vosedo, sorara use dika ghininji ghananja ghuse irarera. ");
INSERT INTO kpr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Amingururoro sifo aminda, God nunda natofo+ bu vasa evevada fifitururari, nenda duro kau iji da usasa aminga ava janimbarira. Geka emo, ningi kote gogoghombaovo dae sise resena,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Aminge sise, Iesu sisira, “Ne nange edo gido, God da jebuga torughaeteva, ainda geka eni eviri. Sifo eni, evetu genembo mendeni, nenda roera koana doghe vendi budo aera, vare jokáda jungedo doteri. Junge dodo ero, genembo eni amboda deinghudo erara tambira. Tambudo, ivuga beká ava use, doghariá sekago bu vasa daba aminda jungetira. Jungedo, koana barira ava kotedo aindae, riria ambariá edo, aira nunda gugua a roviravi isambu budo, oriro edo ainda moniimi budo, vare amo ombira. Kau daba aminga ava, ne God da jebuga ava, bari dae sedo, nenda roera a gugua isambu tefo fugareva, amo avori. ");
INSERT INTO kpr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","A kasia eni mo eviri: God da jebuga kau nange nange tava aetevu? Kau genembo eni guri evevago, a roera garigo ava tava edo ghetira, ainda kaugori. ");
INSERT INTO kpr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Umbu eni nu deinghudo aira, guri eni evevago beká ava tambira. Guri mendeni isambu jo amingo iraeri. Ava tambudo, genemboá eredo aira, nunda gugua a roviravi isambu ai budo oriro edo, ainda moniimi, guriá ombira. Avori, ne kau daba ava use, God da jebuga tava aetevu. ");
INSERT INTO kpr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Geka eni sari dae erena. God nu, evetu genembo nunda dombuda iroro kaifa ari dae sedo, aghi eraira. Nunda aghi mo kau, oka bambudo foa gatege bairoba buraera, ainda kaugori. Oka bambari kakato voto barido ragho arera amo, ne oka kau dombu eni dombu eni ava bambarera. ");
INSERT INTO kpr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bamboro dadabari, ya ghaka+ darido, oka kasama use gategarera. Eveva mo sovenikena vendarera, a ekoko amo fugarera. ");
INSERT INTO kpr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Enda tano ari da sifo aminda, kau daba ava arera. Aneyamane yama, evetu genembo eveva ainda jokáda vosedo, ijujudo ise evetu genembo ekoko gatege ambudo, ");
INSERT INTO kpr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","avaraka mindafu ainda jokáda fugoro vosedo, sorara use dika ghininji ghananja ghuse irarera,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu aminge sise, namanekena sisira, “Ne, geka setena amo, kasama ereva?” Setiri, namane, nunda ambo jimbii siseri, “Ai, kasama erera.” ");
INSERT INTO kpr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Setero, nu sekago namanekena sisira, “Avori, ne eregoseva: God nu, Moses da Geka ijuga kato+ eni ava aghi ari ningido, nunda natofo+ jokáda teredo nunda mandi beká arira amo, nu kau kambo numamo, ainda kaugo arira. Kambo numamoá, nu saramana da mendo gosuse, umbu eni nunda roera manai ava vege simbugedo aimi, saramana arira. Kotugo umbu eni, roera seka keve simbugedo o vege simbugedo aimi, saramana arira. Ainda tuka mo: nu, God da Geka manai Moses gefusira, a kotugo geka seka bu refena ébarago, isambu kasama erira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu kasia amo setiri dadabetiri, nu eredo reighiá dodo, ");
INSERT INTO kpr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","jovereghedo nunda reighi Nasareth aminda isira. Ira buvudo, nu tuturo edo nenda reighi da dengoro indari kambo+ aminda, natofo dengoro indudusira. Amingiri, evetu genembo mendeni nunda geka ava ningido dudukughuseri. Dudukughedo siseri, “Nu nange dubo koterai? A mave seari, nu tano a ari mendeni mendeni urureari namondeda gitida giraeri? ");
INSERT INTO kpr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nu jo genembo teria o kotofu eni iraeri. Numo taká kau namondegori. Nunda noi mo Mary, a nunda jamena James, Joseph, Simon, a Judas, ne isambu reighi ei embori. ");
INSERT INTO kpr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nunda ghaghasovu barago, ne eminda irá gheraera. Avata nu nange emingerai?” ");
INSERT INTO kpr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nasareth embo ne Iesu ighagha use aminge siseri. Amingero, Iesu eredo nemokena sisira, “Feroveta da geka ava, evetu genembo isambu, ningido nu kakara eraera. Avata feroveta totofo nunda natofoi, ne nu jo tumonduse kakara ae eraera. Kau daba aminga ava, ne namokena eraeva. Namo nenda eniri, avo gido, ne na jo tumondae eraeva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ne nu jo tumondae usera aindae, nu ari a tano digarigo reighi aminda, jo ururari gae edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sifo aminda, Frovensi Galilee ainda kotofuko javo Herod, nu Iesu da bino ava niningusira. ");
INSERT INTO kpr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ningido, nunda mendenidae eminge sisira, “John Bafataito Ari Kato seteno dorusera ava, ambarida ghe jebuge erorusira amo, numori tano. Ambarida ghe jebuge erorusira aimi, nu fakina tomanako budo saramana eraira,” Herod aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ainda beká mo: Herod giti setiri nunda mendeni era John sandi bundedo diburada fifituseri. Nu amingusira da susu mo: nunda koro Philip noaro javo Herodias, ");
INSERT INTO kpr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ava saghimbe bu fifitusira aindae, John nu Herod kena ghoghora eminge sedo ghusira, “Ni evetué bu fifitusesa amo, agho dari bejisesi,” aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Amingiri, Herod nu John dari ambare dae kotisira. Avata Jusi embo John nu ferovetava sedo ghusera aindae, Herod oju usira. ");
INSERT INTO kpr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Avori, Herod da sirorari sifo aminda, nu evetu genembo mendeninde dabade kirumo useri. Kirumo ero, Herodias da gagara ira teredo yaru didiviri gido, Herod ivuga beká ava usira. ");
INSERT INTO kpr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ava sedo, gagara aikena beka gagojuse sisira, “Ninda uju ava se ningone! Ni rejodae benunu saresa amo, mutarena,” Herod aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Herodias da gagara, noi rea uju usira ava kotedo, eminge sisira, “John Bafataito Ari Kato da gifua ava, gafuge rooróda vendi mutaso, oroko eminda barena!” sisira. ");
INSERT INTO kpr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Setiri ningido, Kini (King) Herod dubo mema ambarako usira. Avata nunda esa embo da dombuda beka gagojusira aindae, nu bouvu edo, nunda mendeni amingaoro dae sisira. ");
INSERT INTO kpr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Setiri, ne era dibura da vasa aminda teredo, John duboda divegedo, ");
INSERT INTO kpr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","gifua ava rooróda vendi budo fera gagara aikena futuseri. Mutero budo ira, noikena mutiri rurusira. ");
INSERT INTO kpr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Etiri dadabetiri, John da ambo jimbi fera, nunda tamo budo era ofofoda furuguseri. Furugedo, era Iesu kena osa siseri. ");
INSERT INTO kpr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ava osa setero ningido, Iesu namane budo era ghakada+ vosedo, reighi evetu genembo irae da vasa aminda sembiseri. Sembisera ainda bino ava, evetu genembo ningido, nenda reighi isambu dodo Iesu da amboda era, uvu da teria ainda dengesida atai giti era buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Namane amboda buvudo, ghaka+ dari vitido, evetu genembo natofogo ava, totorugedo irero gosuseri. Gido, Iesu nendae joka edo, setiri nenda kae evetu genembo jejebuguseri. ");
INSERT INTO kpr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Amingero ungobu etiri, namane Iesu kena era buvudo siseri, “Iji dadabetira, a eminda evetu genembo a kambo tefori. Ava sedo, natofo dirigaso yama reighi mendeni mendeni aminda, bayau ombu mindarera!” siseri. Setero, Iesu namanekena sisira, ");
INSERT INTO kpr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","“Redae yareri? Bayau nene mutuvu mindore!” ");
INSERT INTO kpr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Setiri, namane numokena siseri, “Namanekena farava ghabu soveni a oka etoto naká ava irira. Rejo eni tefori,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Setero, Iesu sisira, “Avori, namokena bofuvu!” aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","nu natofo kikisada anumbaoro dae sisira. Setiri, ne fuge anumbetero, Iesu nu farava ghabu soveni a oka etoto naká ava budo, dombu utuda fainghuse, God kena ‘aiyakoe’ sisira. Sedo, farava jighi embebegedo namanekena mutiri, budo era evetu genembokena soro useri. ");
INSERT INTO kpr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Soro etero, evetu genembo isasambu mindero inono etiri, mendeni dotero fasusira. Ava namane rete budo, kanda babai isambu 12 ava vevenduseri. ");
INSERT INTO kpr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Gegenembo bayau risera amo, inono 5,000 avavagori. Evevetu a sasingu jo tegaeri. ");
INSERT INTO kpr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mindero dadabiri ainghae dabade, Iesu setiri namane ghakada+ vosedo, giti sembi yari dae ero, nu fetedo evetu genembo isambu dirigusira. ");
INSERT INTO kpr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Dirigetiri ero, nu nusuka enda jiro fumbari aminda, banungari dae sedo vitisira. Tumba jiriri, Iesu nusuka vasa aminda iriri, ");
INSERT INTO kpr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","namane sembu fera soroda buvurutero, yaura dombuda fusira aimi, eva yaura ai ghaka+ jighi jovereghari dae usira. ");
INSERT INTO kpr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sifo da tumba aminda, Iesu vose eva etoda fete deinghe namanekena sembu fusira. ");
INSERT INTO kpr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Firi gido, namane oju beká ava edo, “Omo sukaruri!” sise, koko siseri. ");
INSERT INTO kpr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Namane koko sero nininguse ainghae dabade, Iesu namanekena sisira, “Fakina evu! Namori! Erá oju eove!” Iesu aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peter eredo numokena sisira, “Geka beká, ni Iesu gido resesa? Nimo iraresa amota, se, nambarago vose eva etoda fete, nimokena yaone!” Peter aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Setiri, Iesu, “Fu!” setiri, Peter ghakada+ ghe vose, eva etoda fete Iesu kena isira. ");
INSERT INTO kpr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ise, soroda eva yaura ava itatamedo, oju edo fati basedo vovosusira. Vovosuse, kori sisira, “Arie, Bajari, namo sonembe!” aminge siri, ");
INSERT INTO kpr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ainghae dabade Iesu nunda ungo sirege Peter rurusira. Budo, sisira, “Ninda tumondari jo inono iraeri. Ni redae dubo bunetesi?” aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","nengae ghakada+ vítero, yaura tukughedo binono usira. ");
INSERT INTO kpr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Etiri, namane ghakada+ kaifa erusera amo, kauboi dadarigedo Iesu tumonde bainghuseri. Use, siseri, “Geka bekári: ni God da Mandiri!” ");
INSERT INTO kpr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Aminge sedo, namane Iesu de dabade sembera reighi Genesaret aminda tere dadoruseri. Genesaret resena emo, reighi savavarari. Kotugo ainda jokáda, reighi veveyako mendeni irei. ");
INSERT INTO kpr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ghaka+ dari vitero, evetu genembo ne fuge Iesu gido kasama useri. Kasama edo, kae evetu genembo bu furoro dae sedo, aghi mutero reighi mendeni mendeni aminda era, kae evetu genembo unumbedo budo fuseri. ");
INSERT INTO kpr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Budo fera buvudo, evetu genembo aimi, ne Iesu kena benunu siseri, nange kae embo Iesu da tamo asugari da tingu ava deredo jejebugaeteri. Aminge setero, mave sire dederusira amo, nu jebugusira. ");
INSERT INTO kpr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ainda amboda, Moses da Geka kaifa kakato+ a ijuga kakato+ mendeni, Jerusalem ghedo fera Iesu kena buvudo, numokena namanendae ategi useri, ");
INSERT INTO kpr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Namondeda abuamane rea edo ghusera a ijugedo ghusera ava, ninda ambo jimbi jo amingae eraera. Ne abuamane da kiki ava kakara use, nenda ungo giti seghedo, bayau amboda bu mindido ghaeteri. Ne redae jo amingae eraeri? Se ningore!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Setero, Iesu mino nemokena sisira, “Nanda ambo jimbi ne, abuamane da agho dari doyariá reseva. Avata na nemokena resena. Nenda kotari a nenda uju ava use, nene God da Agho Dari ava dotutusevu. ");
INSERT INTO kpr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God eminge sisira: ‘Nei nimamo kakara use, nenda geka ava ningivu!’ A eni mo: ‘Mave noi o numamokena jijivu sarira amo, devu ambare!’ ");
INSERT INTO kpr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Avata nemo, eminge ijugeraeva: genembo mave, noi numamo ighagha use, nunda gugua budo God kena mutari sise, noi numamo jo sonembae arira amo, avori. Ne aminge ijugeraeva. ");
INSERT INTO kpr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Evetu genembo avavaga use, noi numamo jo sonembae eraera amo, ne ‘avori’ seraeva. Aminguse, ne God da Geka ava dotutuse, nenda kotari ava seovo buveari, geka bekáva sise eraeva. ");
INSERT INTO kpr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ne gungubo kakatori! God da feroveta Isaiah nendae sise, geka beká eminge gefusira: ");
INSERT INTO kpr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bajari resira, ‘Evetu genembo emo, bekaimi na kakara eraera. Avata nenda dubo jokáda mo, ne soka bekári. ");
INSERT INTO kpr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ne na tumonde baingheraera, avata beká eni tefori. Ne aminda sonemba eni jo bae arera. Ainda beká mo: ne evetu genembo da kotari ava, God da Agho Dariva sise ijugeraera,’ Geka amo God setiri, Isaiah nendae sedo gefusira,” Iesu aminge sisira. Ainda beká mo: ne sembae kotedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Setiri dadabetiri, Iesu evetu genembo isambukena kori setiri, fera numokena totorugetero, Iesu nemokena sisira, “Ne erekoteva, evetu genembo ungo jo seghae iria edo, bayau bu mindarera aimi, tamo bebeta arira. Eva ningido, kasama aovo dae sise resena. ");
INSERT INTO kpr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Evetu genembo rea mindarera aimi, nenda tamo jo bebeta ae arira. O geka sembae evetu genembo da békada buvarira aimi, ne bebeta arira. Ava ningido, kasama aovo dae sise resena!” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Setiri dadabetiri, namane era numokena buvudo siseri, “Nine setesa, ava ningido Moses da Geka kaifa kakato+ meka geri,” namane aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Iesu mino sisira, “Amo dovu! Moses da Geka kaifa kakato+ erá koteove! Amboda, nanda Afa utuda irira aimi eredo foama, geka bekáda bekáda sise, evetu genembo ijujarira. Kau genembo vare vive eraira aminga ava, arira. Ijuga kakato jo nune govari fetae usera ava, tuse babarigarira. O ijuga kakato nune govetiri fefetusera, avanembo doyari fetarera. ");
INSERT INTO kpr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ava sedo, Moses da Geka kaifa kakato+ mo, erá koteove! Ne diti digoideri. A ne eregoseva: genembo diti digoide aimi, jo ya nunda komana diti digoide ava unumbedo, nengae emboro evevada yae arera. Nengae dabade emboro kosasaghedo ya bakoda durarera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Setiri, Peter eredo sisira, “Kasia da tuka ava ijugaso ningore!” Peter aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu namanekena sisira, “Ne nangetiraimi geka setena da beká ava jo kasama ae erevu? Nemo nanda ambo jimbiri. Avata na eregosena, nenda kotari kikitakori, evetu genembo mendeni da kotarigori. ");
INSERT INTO kpr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ne anakora geka evia kasama aetevu! Genembo bayau rea mindarira amo, tininda vosiyari ya foká ari dadabarira. ");
INSERT INTO kpr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Avata nu geka rea bekaimi seraira amo, dubo joká isambuimi seraira. Aimi nu bebeta eraira. ");
INSERT INTO kpr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ainda tuka mo: nu rea dubo jokáda koteraira aimi, nu derari komana dari ambarira, kombo yagera arira, bagia arira, gungubo sarira, aji sarira, a ari ekoko mendeni arira. ");
INSERT INTO kpr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aimi genembo da dubo joká bebeta eraira. Avata Moses da Geka kaifa kakato+ da ijuga ava kotae edo, ungo jo seghae iria edo bayau mindareva aimi, nenda dubo joká jo bebeta ae arira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu nu reighiá dodo, ira gitofu da reighi etoto, javo Taiar a Saidon, ainda frovensi aminda teterusira. ");
INSERT INTO kpr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Teteriri, oro Keinan embo da evetu eni fira numokena buvudo sisira, “Bajari, David da Mandi God mutari sisira amo, nimori. Ava sedo, na joka aso dae resena. Sukarui nanda gagarakena asugetiri, mema teria ava itatamuse irira.” ");
INSERT INTO kpr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aminge sisira avata, Iesu numokena geka mino eni jo sae usira. Namane numokena era siseri, “Evetué dirige yare! Nu namondeda amboda amboda fuse beisiga udo refira.” ");
INSERT INTO kpr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aminge setero, nu sisira, “Na jo oro mendeni mendeni ava sonembari dae sedo furaeri. Namondeda natofo Jusi embo God dodo irera, ava sonembaono dae sedo, God na dirigetiri fuseni,” nu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Namane Iesu de dabade aminge sero ningido, evetuá fira dombukena buvudo, kauboi dadarigedo Iesu kena sisira, “Bajari, namo sonembe!” ");
INSERT INTO kpr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aminge setiri, Iesu mino numokena eminge sisira, “Ne namanenda gitofuri. Namane nendae ‘sinova’ seraera. God namanenda abua Abraham gategusira, a namanenda oro barago gategusira. Ava sedo, God da sasingu giti bayau mindaeteri. Nenda bayau budo sinodae fugarena amo, jo eveva iraeri. Ava sedo, ni redae sonembareni?” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Setiri, evetuá sisira, “Ai, Bajari! A nu beká resesa. Avata evetu genembo beká bayau rirureoro, susunda dudurugeari, sinomane ne ava mindiraera. Ava sedo, na joka edo sonembaso dae resena.” ");
INSERT INTO kpr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aminge setiri, Iesu mino numokena sisira, “Aiya, evetugo! Ni na tumonde gogogho eresa! Ava sedo, benunu setesa, ava nimokena sirorare!” Iesu nu aminge siri ainghae dabade sukaru darigetiri, evetu ainda gagara jebugusira. ");
INSERT INTO kpr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu namane budo reighiá dodo ira, uvu da teria javo Galilee ainda tinguda isira. Aminda ise, Iesu enda jiro fumbari aminda viti ganasa ifuda anumbusira. ");
INSERT INTO kpr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Anumbetiri, evetu genembo digari fera numokena totoruguseri. Evetu genembo ata sembaede, diti digoide, ungo ata ambaride, beka guga, a kae evetu genembo mendeni ainde dabade ava budo fera, Iesu da dombuda buvudo fitero anoseguseri. Anosegetero, Iesu setiri jejebuguseri. ");
INSERT INTO kpr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jejebugedo, evetu genembo beka gugaá tuturo edo beka siseri. Ata sembae eveva useri. Ungo ata ambari jejebuguseri. A diti digoideá diti eveva usira. Amingiri, evetu genembo isasambu ava gido dudukughuseri. Dudukughedo, ne Israel embo da God dae sakai siseri. ");
INSERT INTO kpr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Amboda, Iesu kori setiri, namane era numokena buvero sisira, “Evetu genembo namonde sifo etodaba naká deinghuse bayau dadabetiri gido, na nendae joka erira. Erama dirigeóno kambo da ise, emboroda ighoii sirivo eore dae sise resena!” Iesu aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","namane numokena siseri, “Namonde nange nange farava budo mutoro mindareri? Reighi eminda, evetu genembo a nati tefo ava sedo, bayau tefori,” namane aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Setero, Iesu namanekena ategi usira, “Nemokena farava nanjogo iri?” setiri, namane siseri, “Namanekena farava 7 a oka veveyako etoto naká ava irira,” aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iesu natofo endada anumbaoro dae sisira. ");
INSERT INTO kpr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Setiri, ne fuge anumbetero, Iesu farava 7 okaghae budo God Afakena ‘aiyakoe’ sedo, jighi embebegedo namanekena mutiri budo, evetu genembo isambukena soro useri. ");
INSERT INTO kpr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Etero budo, ne isasambu mindero inono usira. Etiri, mendeni dotero fasusira ava rete budo, kanda babaimi isambu 7 ava vendero bedo usira. ");
INSERT INTO kpr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Gegenembo bayau risera amo, inono 4,000 avavagori. Evevetu a sasingu jo tegaeri. ");
INSERT INTO kpr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Etiri dadabetiri, Iesu natofo amo dirigetiri ero, nu ghakada+ vosedo, Megadan embo da reighida sembisira. ");
INSERT INTO kpr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Moses da Geka kaifa kakato+ mendeni nemonde Sadusi embo+ ainde dabade, Iesu deroro beka sembae sari ningari dae sedo, numokena fuseri. Geka sembae sari ningido, numoá bu koto ari dae sedo, Iesu kena fera siseri, “Ni God da fakina aimi, tano aso gari dae resera!” ");
INSERT INTO kpr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Aminge setero, Iesu mino eminge sisira, “Nenda kotari kikitakori. Yaura sufurureari gido, ‘Eva erari dae erira,’ ava koteraeva. O foroga dadorureari gido, ‘Reighi eko arira,’ ava koteraeva. Ne yaura a foroga gido, ainda tuka kasama e gogoghomberaeva. Avata roera a tano oroko siroreari giraeva amo, redae buneraevu? ");
INSERT INTO kpr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Evetu genembo siroredo oroko endada irera, ne taká ekoko bekári. Ne God itako jo kotae eraera. Ainda mendeni mo, nemori. Ne tano ijugaono gari dae reseva. Avata na jo ururono gae areva. Nu, dabako ururono gareva. Jonah ambarigedo iji etodaba naká oka da tini jokáda ireira edo, fira buvurutusira. Kau daba aminga ava namokena sirorari gido bunareva,” Iesu aminge sedo, Moses da Geka kaifa kakato+ a Sadusi embo+ aminda dodo isira. ");
INSERT INTO kpr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Namane uvu da teria aminda sembisera amo, namane kasama useri, farava kotae dodo sembiseri. ");
INSERT INTO kpr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Amingetero, Iesu namanekena sisira, “Diti gi gogoghombevu! Moses da Geka kaifa kakato+ a Sadusi embo+ nenda yisti (yeast) ava imboe edo, darigaovo dae resena.” ");
INSERT INTO kpr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nu aminge setiri, namane farava bekáva kotise, tofo tofo se nininguseri, “Omo rejodae resi? Namonde farava kotae dotera aindae resira, tanojo,” namane aminge bunise se nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Namane rejodae se niningusera ava, Iesu kasama edo namanekena sisira, “Nemokena tumondari tefori! Ne redae faravadae resevu? ");
INSERT INTO kpr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ne nangetirai anakora kasama ae iriavu? Kote givu! Na giti farava ghabu soveni jighi embebegedo ghaseteno, gegenembo 5,000 mindero inono etiri, kanda babai nanjogo ava vevendusevu? A kote givu! ");
INSERT INTO kpr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","A kotugo, amboda farava 7 ava jighi embebegedo ghaseteno, gegenembo 4,000 mindero inono etiri, kanda babaimi nanjogo ava vevendusevu? A barago kote givu! Ai resira amo: farava saono sirorari da fakina namokena irira. Ava kotaetevu! ");
INSERT INTO kpr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ne anakora kasama aetevu: na Moses da Geka kaifa kakato+ a Sadusi embo+ da yisti setena amo, na jo farava beká aindae sise saeri,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aminge setiri, namane kasama useri: nu jo farava ingari da yistidae saeri. Nu kasia sise, Moses da Geka kaifa kakato+ a Sadusi embo+ da ijuga erá ningeore dae sisira. ");
INSERT INTO kpr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Amboda, namane Iesu da karona edo era, reighi javo Sesaria Filipai ava utua edo, Iesu tofo nundae sedo ategi usira, “Sevu ningone! Evetu genembo nange erekoteri? Evetu Genembo da Koro+ mavejori?” aminge ategi usira. ");
INSERT INTO kpr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ategi etiri, namane eminge siseri, “Mendeni koteraera, John Bafataito Ari Kato ambarida ghe, jebugedo erariá seraera amo, nimori. A mendeni mo, Elijah, Jeremiah, o feroveta eni ambudo ambarida ghe jebugedo erariá seraera amo, nimori. Evetu genembo ne aminge kotise seraera.” ");
INSERT INTO kpr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Namane aminge setero, Iesu sekago ategi usira, “Atá, ne nange erekotevu? Na mavejori? Sevu ningone!” setiri, ");
INSERT INTO kpr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Peter mino eminge sisira, “God evovodae irira aimi, nunda Mandi mutari sisira, amo nimori. Namanenda ari ekoko kote doyari dae sedo, ni dirigetiri fusesi.” ");
INSERT INTO kpr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aminge setiri, Iesu Peter kena sisira, “Arie, Simon, Jonah da mandi! Geka setesa ava, God ijugetiri kasama etesi. Ainda tuka mo: jo evetu genembo nene kasama ari da kaugo iraeri. Nanda Afa utuda irira aimi, setiri kasama etesi. ");
INSERT INTO kpr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nimokena resena: ninda javo seka Peter jijigherena. Ainda tuka mo: ghamanari. Ghamana amo, nu susu ari ainda etoda, nanda ekaresia+ nane itarena. Nanda ekaresia+ resena emo, fakina ururari, Ambari imi jo foa nanda ekaresia gajari inono ae arira. ");
INSERT INTO kpr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na nimokena ki (key) eni mutari dae erena. Aimi guro afigaso, natofo God kena ya buvoro nune kaifa arira. Ni endada irise rea digharesa amo, God Afa utuda irise digharira. Kau daba aminga ava, ni endada irise rea vujegaresa amo, God Afa utuda irise vujegarira.” ");
INSERT INTO kpr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aminge sedo, Iesu kovionoghae namane erama nu Keriso numoá, osa seóro evetu genembo ningeore dae sedo buregusira. ");
INSERT INTO kpr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Iesu aminge sisira ainda amboda, nu tuturo edo isagha beká dengoro induduse, namanekena eminge sedo ghusira, “Na yama Jerusalem aminda terono, evetu genembo da babojegari, fristi+ da kokotofu, a Moses da Geka ijuga kakatoi+ na sandido, namokena mema tomanako mutoro itatamarena. Amo emingarera. Ne saoro evetu genembo mendeniimi na daoro ambudo, sifo etodaba naká dadabari ainda amboda, na sekago ambarida ghe jebuge erarena.” ");
INSERT INTO kpr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Setiri dadabetiri, Peter nu eredo Iesu budo nengae era ajagha fetedo, Peter tuturo edo Iesu dombuda sisira, ‘Bajari, seteso ningera ava, erama siroreure dae sedo, God buregaeti. Amo nimokena jo sirorae aeti,” Peter aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Avata Iesu jovereghedo Peter kena eminge sisira, “Satan, na darigaso dae resena. Ni namo buregari dae eresa. Kotari resesa emo, jo God da kotari iraeri. Amo evetu genembo da kotariri,” Iesu Peter kena aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","namane isambukena sisira, “Mave nanda ambo jimbi edo, namonde dabade deinghari sarira amo, nu emingarira. Nu nunda uju amo dodo, nanda uju avanembo arira Nu namo tumonduse, gitofudae jo oju ae, mema ã bouvu fufudo ya ambarira, a nu avori. A nane rea eraena ava, nu ari kau daba ava udo yarira. Amingarira amo, nu nanda ambo jimbi edo, namonde dabade deingharera. ");
INSERT INTO kpr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ainda tuka mo: mave nu enda einda gugua kotise, a ambari dae oju use na doyarira amo, nu sifo amboda ambarira. O mave nandae sedo ambarira amo, nu amboda jebuga evovodae irari ava tuve barira. ");
INSERT INTO kpr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mave nu enda da gugua ava dubo ruruse, roera isambu nunda tofo sise, jebuga evovodae irari ava kosasaghedo ambarira amo, givu! Aimi nu sonembarira, ai? Avata aimi, nu jo sonembae arira. ");
INSERT INTO kpr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ainda tuka mo: Evetu Genembo da Koro+, jovereghe aneyade dabade a God Afa da usasa ainda jokáda vose furarira. Sifo aminda, nu evetu genembo isambu nenda irari ava ijujedo, ainda mino mutarira. Ari ekoko usera, ainda mino eko mutarira. O ari eveva usera, ainda mino eveva ava mutarira. ");
INSERT INTO kpr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A na geka beká nemokena resena. Ne mendeni eminda fetireva emo, ne jo ambae irovo, Evetu Genembo da Koro+ nunda fakina budo, kau kini (king) da kaugo ava edo fururari gareva,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sifo 6 ava dadabetiri ainda amboda, Iesu nu eredo, Peter, James, a nunda mandako John, gatege budo nemonde esike era, doriri mindafu eni aminda vitiseri. Vasa aminda evetu genembo eni tefori. ");
INSERT INTO kpr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Doririda viti fetedo gosero, Iesu nu jovereghedo kau eni usira. Nunda dombu mo, kau iji da usasa aminga ava edo jaraghusira. A nunda tamo asugari barago, foyago beká ava use, usasa beká ava usira. ");
INSERT INTO kpr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Etiri, Moses Elijah ghae, ne giti beká endada iriara ava, nengae fera isagha edo Iesu de dabade geka se niningero, nunda ambo jimbi etodaba naká ne gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Gido, Peter Iesu kena sisira, “Bajari, namane budo ojesa aindae sedo, na ivuga erena. Ni nange erekotesi? Eveva mo, na dobo etodaba naká eminda itone? Eni nindae, eni Moses dae, a eni Elijah dae itone, ai?” ");
INSERT INTO kpr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peter aminge siri, foroga eni foyago beká ava fira, nenda jiro agada fefetusira. Fetiriri, foroga ainda jokáda beka siri ne nininguseri, “Emo nanda dubo bari Mandiri. Na, nundae ivuga beká use, aiyakoe resena. Nunda geka ava ningivu!” beka aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Siri, nunda ambo jimbi etodaba naká ne oju beká ava edo endada du fafasuseri. ");
INSERT INTO kpr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Du fafasetero, Iesu nemokena ira tamonda deredo sisira, “Erevu! Erá oju eove!” ");
INSERT INTO kpr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Setiri, ne dombu fainghedo, Iesu nusuka fetiriri gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Gido, ne jovereghe Iesu de dabade vose fuse, Iesu nemokena sisira, “Oroko rea geva amo, erá osa seove! Evetu Genembo da Koro+ daoro ambudo, ambarida ghe jebuge erarira, ainda amboda osa sareva, a nu avori,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Setiri, Peter, James, a John numokena ategi useri, “Moses da Geka ijuga kakato+ eminge seraera: ‘Elijah giti endada ireira ava, sekago jovereghe furarira ainda amboda, God Genembo eni mutari sisira amo, sirorarira.’ Amo redae aminge seraeri?” ne aminge ategi useri. ");
INSERT INTO kpr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Etero, Iesu nemokena sisira, “Aminge seraera ainda beká mo: Elijah giti foama Evetu Genembo da Korodae+, emboro rerebuse roera simbugaetira. ");
INSERT INTO kpr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Avata, na nemokena resena: amo anakora sirorusira. Elijah anakora jovereghe fira iriri, evetu genembo mendeniimi nu bunedo, budo nenda uju ava useri. Amboda Evetu Genembo da Korokena+, kau daba aminga ava use, mema numokena mutoro itatamarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Setiri, nunda ambo jimbi kasama useri: nu Elijah sisira amo, John Bafataito Ari Kato dae sisira. ");
INSERT INTO kpr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ne vose fera namanekena, a evetu genembo mendeni totorugedo irisera aikena, buvurutuseri. Buvero, genembo eni ira, Iesu da dombuda kauboi dadarigedo sisira, ");
INSERT INTO kpr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Arie, Bajari! Nanda mandidae joka aetesi! Nu jinongu tambudo eko beká ava eraira. Umbu mendeni, nu ungo ata dadadagheari, endada du fasedo, afufe ya avaraka etoda vitiraira o uvuda tifugheraira. ");
INSERT INTO kpr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Amingeraira ava, budo ojena ninda ambo jimbikena ijugetena ava, ne jo aoro jebugaeri. Etiri, na bune jaredo, nimokena bu refena.” ");
INSERT INTO kpr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Setiri, Iesu eminge sisira, “Ne isambu sembae eraeva. Nangetiraimi ne tumondari tefori? Eveva mo: na ne doyaetena ava avori! Na erebunena. Avori, mandi reseva, namokena budo fuvu gaone vae!” ");
INSERT INTO kpr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aminge setiri budo fera buvero, Iesu nu sukarukena kovionoghae setiri, sukaru mandi ainda jokáda ava vose darigetiri, mandiá jebugusira. ");
INSERT INTO kpr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Amingetiri dadabetiri ainda amboda, namane kikiako era, Iesu de dabade se nininguseri, “Namane ondera amo, nangetiraimi sukaru jo vose darigaeri?” ");
INSERT INTO kpr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aminge setero, Iesu namanekena sisira, “Nenda tumondari jo inono irae, ava sedo, seteva, nu jo jebugaeri. Kotovo dae resena. Nenda tumondari itako, kau ika maine ainda vuji da kaugo ava iraetira amo, ne doriri oindae, ‘Darige yasi, sovenikena fetase!’ saeteva amo, nu amingaeti. Ne rejo saeteva amo, siroraeti. ");
INSERT INTO kpr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Avata sukarudae eminge resena. Sukaru eviviga ondari sareva amo, bayau kanangara use God kena utua fetedo, banunguse irareva. Emboro eni tefori,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sifo eni, Iesu da dorevare isambu namane namonde dabade, Frovensi Galilee aminda totorugetero, Iesu namanekena sisira, “Evetu Genembo da Koro+ ava sandido, gegenembo mendeni da ungoda fitoro ");
INSERT INTO kpr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","daoro ambarira. Avata sifo etodaba naká dadabari ainda amboda, God sari nu ambarida ghe jebuge erarira,” nu aminge setiri, namane ningido bate dombu useri. ");
INSERT INTO kpr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu namonde dabade era reighi Kaponiam aminda teretero, God da Kambo+ ainda takesi bari kakato Peter kena era ategi useri, “Nenda ijuga kato God da Kambo+ da takesi omburaira, ai tefo?” aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peter sisira, “Ai, omburaira. Redae resevu?” aminge sisira. Sedo, kamboda ira teretiri, Iesu giti tuturo edo aindae ategi usira, “Simon, ninda kotari ava se ningone! Enda eminda kini (kings) a kokotofu mavekena takesi buraeri, nenda sasingukena, ai, gitofukena?” setiri, ");
INSERT INTO kpr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter, “Gitofukena buraera,” setiri, Iesu sisira, “Beká resesa. Kini (king)da sasingu ne takesi jo ombae eraera. Ava sedo, na God da Kambo+ da takesi jo ombae aeteni. ");
INSERT INTO kpr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Avata erá dumo eore dae sedo, ombarena. Avori, emingaresa. Yasi, uvu da teria ainda betuda fetedo, kimai fugaso, oka eni giti foa gambari jumbaresa, ainda békada, moni+ eni tambaresa. Amo, nangaeda takesi da inono ava baresa. Avori, moni ava budo yama, nangaeda takesi ai ombaresa,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sifo daba aminda, namanenda mendeni era Iesu kena buvudo ategi useri, “God da natofo+ ainda jokáda, genembo teria beká mavejori?” namane aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iesu nu mandi kitako eni setiri fira buviri, namanenda soroda fitiri fefetusira. ");
INSERT INTO kpr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Fetetiri, Iesu eminge sisira, “Geka emo kotovo dae resena. Sasingu ne ivuga use geka ningi tumonderaera. Ava sedo, ni jo dubo jovereghedo, sasingakoi eraera, ainda kaugo ava ae aresa amo, ni jo God da natofo+ eni ae aresa. ");
INSERT INTO kpr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mave tofo fitari vosedo, kau mandi ijoghako eminga ava arira amo, nu God da natofo+ jokáda teria beká ava arira. ");
INSERT INTO kpr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","A geka eni mo: mave, nanda javoda sasingu evivaga ava nati joká doruse, bu tavo arira amo, nu inono, namoá nati joká doruse, bu tavo arira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Aminge sise, Iesu sisira, “O genembo mave foa, sasingako evavagoimi namo tumonderaera, ava derari, ari ekoko arera amo, derari kato amo, amboda mema mindafugo ava tambarira. Eveva mo: genemboá nanda sasingu jo derae irari, gitofui foa, ghamana mindafu budo genembo ainda duboda dighido, bu fugari kafuruda tifughari dadabaeti. O nu, sasingu namo tumonderaera eminga ava, derari gido, God aindae mema mutari tambarira amo, eko a bouvugori. ");
INSERT INTO kpr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Enda eminda derari foa gheraira amo, eko bekári. Jo darigari da kaugo iraeri. A enda da natofo isambukena derari foa gheraira amo, mará, bouvu a veverago ava itatamuse irera. Avata genembo mave nunda kokomana derari ari ekoko arera amo, nu mema teria beká ava tambarira. ");
INSERT INTO kpr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ninda ungo o ata aimi, dara aso ari eko sirorarira amo, gafuge fugaresa. Eveva mo: ni ungo o ata soveni taukaka iria ambudo, ya God kena jebuga tambaetesi. O ni ungo a ata etoto aminge irise, ari ekoko use iria ambudo, ya ari ekoko mino mutari vasa avarakaghae aminda teraresa amo, eko a bouvugori. ");
INSERT INTO kpr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","O ninda ditiimi gosuse, ni ari eko aso sirorarira amo, gunumbe fugaresa. Eveva mo: ni diti soveni taukaka iria ambudo, ya God kena jebuga tambaetesi. O ni diti etoto aminge irise, ari ekoko use iria ambudo, ya ari ekoko mino mutari vasa avarakaghae aminda teraresa amo, eko a bouvugori,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Aminge sise, Iesu namanekena sisira, “Na eminge resena. Erá sasingu emingako ava kotae use imboe eove! Ainda susu mo: God ne dubo bu gogoghomberaira. A sasingu emingako amo, nenda aneya sifo ghousa God Afa utuda irira, ainda dombuda fetirá gheraera. ");
INSERT INTO kpr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Evetu Genembo da Koro+, evetu genembo sirivo use irera ava, sonembari dae sedo fusira. ");
INSERT INTO kpr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Aminge sise, Iesu sisira, “Ninda namendi eni nimokena dara arira amo, yasi nengae kikiako dabade anumbedo, ninda dubo mema saso ningare! Ninda geka ningido nu dubo jama arira amo, avori, nengae dubo dabako edo irareva. ");
INSERT INTO kpr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","O ninda geka jo ningae arira amo, God da Geka rea aso dae resira, ava aresa. Evetu genembo etoto o etodaba ava budo ya, ninda namendide dabade anumbedo, dubo kotare dae sedo, geka sekago sirurovo ningarira! ");
INSERT INTO kpr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","O nu evetu genembo ainda geka barago jo ningae arira amo, ni dara ainda susu ekaresiakena+ isagha saso ningarera. Nu tumondari+ embo da geka barago jo ningae arira amo, ne kau gitofu da kau aminga ava, nu imboe use, nemonde jo dabade umo gamo ae areva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Aminge sise, Iesu sisira, “Na aindae sedo, kasama aovo dae eminge resena. Ne endada irise rea dighareva amo, God Afa utuda irise digharira. Kau daba aminga ava, ne endada irise rea vujegareva amo, God Afa utuda irise daba ava vujegarira. ");
INSERT INTO kpr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","“Eni mo, evia sari dae erena. Etoto o etodaba nanda javoda totorugareva amo, na namonde dabade totorugarera. Ava sedo, nengae komanaghae dabade dubo dabako edo, nanda javoda rejodae banungareva amo, nanda Afa utuda irira aimi ningido sari, nenda uju amo sirorarira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Amboda, Peter Iesu kena ira ategi usira, “Bajari, nanda namendi dara namokena arira amo, na umbu nanjogo kote doyareni? Umbu 7 ava kote doyarena, ai? Nange areni?” ");
INSERT INTO kpr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Peter aminge setiri, Iesu sisira, “Tefo, umbu 7 ava jo sae aresa. Ni umbu 500 saresa ava, avori. Ainda susu mo: ninda namendi da dara ni jo tegae aresa. ");
INSERT INTO kpr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","God da natofo dara eraera, nange tofo tofo kote doyaetera ava, kasama aovo dae sedo, kiki eni sari dae erena. Kini (king) eni tuturo edo, nunda natofo numokena moni rea mutaetera ava, dere gira. ");
INSERT INTO kpr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nu tuturo edo amingiri, nunda mendeni genembo eni unumbedo budo ojeri. Genemboá nu kini kena K600,000,000 ava mutaetira. ");
INSERT INTO kpr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Avata nunda moni+ ava daiva etira. Etiri, kini (king) eminge setira, ‘Avori, genemboé noaroghae, nunda sasingude, a nunda roera isambu oriro aovo, ainda moni+ ava barena,’ kini aminge setira. ");
INSERT INTO kpr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Setiri, genemboá nu kini da ata duruda kauboi dadarigedo setira, ‘Nandae joka use durumugururaso, na moni tambudo, mutono isambu baresa,’ nu aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","kini genembo aindae joka edo setira, ‘Ni dara usesi. Avata rea mutaetesa ava, na kote dotutuse, jo bae arena,’ kini aminge sedo, genemboá dotiri aira. ");
INSERT INTO kpr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Avata genemboá aira, nunda komana eni tambira. Nunda komana amo genembo aikena K1,000 avavaga mutaetira. Genemboá nunda komana ava tambudo, duboda safuse setira, “Nanda moni+ bofu baoneta!’ ");
INSERT INTO kpr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Setiri, nunda komanaá du fasedo setira, ‘Nandae joka use durumugururaso, na moni tambudo, isambu mutono baresa,’ aminge setira. ");
INSERT INTO kpr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Avata genembo amo, nu jo joka aeri. Nunda moni mutari bari dae sedo, setiri nunda komana diburada fiteri. ");
INSERT INTO kpr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Genembo diburada fitera ainda kokomana mendeniimi ava gido bune jaredo, kinikena aera osa seteri. ");
INSERT INTO kpr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Setero ningido, kini aghi etiri, genemboá ojira buviri, numokena setira, ‘Ni genembo ekori! Ni namokena benunu seteso, moni isambu namokena mutaetesa ava, na kote dotutuse jo baeri. ");
INSERT INTO kpr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na nindae joka etena, kau daba aminga ava, ni komanadae joka aetesi.’ ");
INSERT INTO kpr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kini nu janje eko beká ava edo, aminge sedo, dibura kaifa kakatokena setira, ‘Genembo emo bu yasivu! Kaifa ururovo, moni isambu mutari baono gido, doyovo ya buvarira,’ kini aminge setira,” Iesu aminge sise, kiki tano ari dae sedo, eminge sisira, “Avori, kini da kiki ainda tuka ava kotovo dae resena. Ninda namendi nimokena dara arira ava, ni jo dubo isambuimi kote doyae aresa amo, ");
INSERT INTO kpr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","nanda Afa utuda irira aimi, ninda ari ekoko barago jo kote doyae arira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu aminge setiri dadabetiri, nu Frovensi Galilee dodo, uvu Jordan sembudo betu soveni iji vitarikena, aminda ira, Frovensi Judia aminda teterusira. ");
INSERT INTO kpr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aminda, evetu genembo digari totorugedo, nunda amboda amboda ero, nu setiri ne jejebuguseri. ");
INSERT INTO kpr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Moses da Geka kaifa kakato+ mendeni fera, numo deroro geka sembae sari ningari dae sedo, ategi useri, “Namondeda Agho Dari nange resi? Se ningore! Genembo kotae kotae nunda ujuda noaro doyaeti, ai?” ");
INSERT INTO kpr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aminge setero, Iesu sisira, “God geka setiri Moses gefusira amo, tegutusevu, ai? Geka amo eviri: ‘Tuturoda, God utu enda etiri sirorusira. Ainda sifoda, nu setiri, genembo evetughae siroruseri.’ ");
INSERT INTO kpr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A geka eni mo: ‘Aindae sedo, genembo noi numamo dodo evetu fitido, nengae tamo fisi dabako arera.’ Amo God da Gekari. ");
INSERT INTO kpr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ava sedo, evetu genemboghae nenda irari, jo nunda nunda iraeri. Nenda irari dabakori. Aindae sedo, God setiri dabade tatisera ava, jo evetu genemboi vujegari da kaugo iraeri. Ava sedo, genembo noaro jo doyae arira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Setiri, Moses da Geka kaifa kakato+ sekago ategi useri, “Ni resesa amo, namane kasama erera. Avata Moses eminge sisira, ‘Nearo doyari saresa amo, ninda geka gembudo mutaso nearo bu gosururari, doyaresa,’ Moses nu aminge sisira. Ava sedo, ni evetu jo doyae ari da geka resesa ava, geka beká iraetira amo, Moses redae aminge sisi? Nengae Moses ghae da geka jo foa dabako aeri.” ");
INSERT INTO kpr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ne aminge setero, Iesu mino nemokena eminge sisira, “Ne gogore vanembori, a ijuga jo bae eraeva; ava sedo, Moses aminge gefusira. Avata tuturoda, God utu enda etiri sirorusira ainda sifoda, gegenembo nenda evevetu jo doyae edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ava sedo, geka emo ningido kasama aovo dae resena. Genembo, noaro yagera jo ae irarira, ava dodo ya, evetu eni fitarira amo, nu evetu giti fifitusira aikena dara arira. Ainda javo mo yagerari,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Setiri, namane numokena siseri, “Evetu genemboghae amingaoro dae saresa amo, namane evevetu jo fitae arera, tanojo.” ");
INSERT INTO kpr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aminge setero, Iesu sisira, “Ari emo jo evetu genembo isambui ari da kaugo iraeri. Nu, mavekena God fakina mutarira amo, nu amingarira. ");
INSERT INTO kpr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gegenembo mendeni evetu jo fitae eraera da susu, jo dabako iraeri. Mendeni mo, jebure tefo siroruseri. Mendeni mo, evetu genembo ungoimi eoro amingedo irá gheraera. A mendeni mo, God da saramana a nunda natofo sonembari dae kotise, evetu jo fitae eraera. Mave inono arira amo, nu amingare!” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Evetu genembo mendeni nenda sasingu, Iesu banunguse esimbugare dae sedo budo fuseri. Budo fera buvero gido, namane ghoghora siseri. ");
INSERT INTO kpr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Avata Iesu ava gido, namanekena sisira, “Sasingako emo, erama buregeove! Dovu namokena furore! Ainda tuka mo: ne ivuga use nanda geka ningi tumonderaera. Mave amingarira amo, nu God da natofo+ arira,” ");
INSERT INTO kpr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Iesu aminge sise, nunda ungo sasingu da tamonda fitiri dadabetiri, reighiá dodo isira. ");
INSERT INTO kpr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sifo eni, genembo eni Iesu kena fira ategi usira, “Ijuga Kato, na eveva rejo ava edo, jebuga evovodae irari amo tambareni?” ");
INSERT INTO kpr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aminge setiri, Iesu sisira, “Ni redae namokena ari eveva aindae ategi eresi? God nusuka numoá evevari. Jebuga evovodae irari ava tambari dae saresa amo, God da Agho Dari ava kaifa use iraresa,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Setiri, genemboá ategi usira, “Agho Dari ningaindae resesi?” aminge setiri, Iesu mino numokena sisira: “Erama komana deóvo ambeure! Erama yagera eove! Erama, bagia eove! Erama komanakena dederuse gungubo seove! ");
INSERT INTO kpr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nei nimamo kakara use, nenda geka ningido ghevu! Ni tofo dubo buraesa, kau daba ava, ninda komana dubo baresa!” ");
INSERT INTO kpr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Iesu aminge setiri, genemboá numokena eminge sisira, “Resesa amo, na kaifa edo ghuseni a kaifa eraena. Avata amo jo inono iraeri tanojo. Ava sedo, ainda etoda sekago rea aetena, ava se ningone!” ");
INSERT INTO kpr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aminge setiri, Iesu sisira, “Ni edo gido, jebuga tambari saresa amo, jovereghe ya kamboda buvudo, ninda roera a gugua isambu oriro edo, ainda moni ava budo, makasi embokena ghasaresa. Ghasedo ni furaso namonde dabade deingharera. Amingaresa amo, ni amboda ya gugua evevago utuda baresa.” ");
INSERT INTO kpr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Iesu aminge setiri ningido, genemboá dubo memaghae Iesu dodo isira. Ainda beká mo: genembo ainda gugua jo daba etoto iraeri. ");
INSERT INTO kpr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iri gido, Iesu namanekena sisira, “Evetu genembo susu iti fafode amo, foa God da natofo+ arikena, fakarago bekári. ");
INSERT INTO kpr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Setena, daba ava sari dae erena. Sino fuka javo kamero (camel), ava kote givu! Nu jo totoi ningu toka aminda tere ya sovenikena buvae arira. Avata nu aminda tere yari mo, raugakori. O evetu genembo guguade aimi God da natofo+ ari dae sarera amo, fakarago bekári.” ");
INSERT INTO kpr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iesu aminge setiri, namane ningi dudukughedo siseri, “Aminge saresa amo, God da natofo+ mave ari?” ");
INSERT INTO kpr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ava setero, Iesu namane tataseguse sisira, “Amo jo, evetu genembo endada irera einda ari da kaugo iraeri. Ne jo totofo nenda fakinaimi, God da natofo+ ae arera. Avata God mo inonori. Nune roera isambu ari sirorarira.” ");
INSERT INTO kpr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Setiri, Peter eredo minonda eminge sisira, “Kote gi! Namane nindae sedo, namanenda kambo a roera isambu dodo namonde deingheraera. Namane aindae sedo rejo eni barera, ai?” ");
INSERT INTO kpr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aminge setiri, Iesu namanekena sisira, “Na geka beká nemokena resena. Utu a enda seka aminda, Evetu Genembo da Koro+ kotofu edo, nunda avo anumba durode aminda anumbururari, nembarago kokotofu da avo anumba 12 aminda anumbirise, Israel embo da oro isambu 12 ava, nene kaifa edo ghareva. ");
INSERT INTO kpr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A mave nandae sedo, nunda kambo, nunda nano namendi, nunda ghaghasovu, nunda noi numamo, nunda sasingu, o nunda enda doyarira amo, natofo a roera resena emo, aminga ava, siroruse digutururari ruruse, jebuga evovodae irari, ábarago tuve barira. ");
INSERT INTO kpr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Avata mendeni ne oroko kokotofu edo irera amo, ne sifo amboda vose sabua+ edo irarera. O mendeni ne oroko sabua+ edo irera amo, sifo amboda, ne viti kokotofu edo irarera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Aminge sise, Iesu sisira, “God nunda natofo+ kaifa eraira amo, kau emingori. Asi vuji da vare eni ainda numamo eredo, sifoghae saramana kakato ava tava ari dae sedo aira. ");
INSERT INTO kpr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Aira, gegenembo mendeni tambudo, nene foa saramana aoro dae sise, nenda mino+ K10 avavaga mutari dae setira. Aminge sedo, ne dirigetiri nunda vareda aera. ");
INSERT INTO kpr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Aera, saramana tuturo edo ero, vare numamoá iji vitiri, (9 koroko) eredo aira, ombari vasa aminda buvudo, gegenembo mendeni tefo irero tambira. ");
INSERT INTO kpr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tambudo, setira, ‘Ne ya nanda vareda saramana ururovo ungobu ari, nenda mino kasama use mutarena,’ aminge setira. ");
INSERT INTO kpr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Setiri, ne javi edo aera, saramana tuturo edo eteri. Amingero, vare numamoá isonga (12 koroko) edo, kotugo iji aira vekenengetiri (3 koroko) sekago aira, kau daba aminga ava, gegenembo mendenikena setira. ");
INSERT INTO kpr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ainda amboda ungobu (5 koroko) ari dae iri, vare numamo daba ai sekago aira, ombari vasada gegenembo mendeni irero ava tambira. Tambudo, setira, ‘Ne redae isonga ghousa evia, vasa daba eminda fugedo irevu?’ aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ne mino numokena seteri, ‘Ainda beká mo: mave eni jo foa, namane saramana aoro dae saeri. Ava sedo, namane fugedo irera,’ setero, nu sekago setira, ‘Avori, na ne mutono ya, evetu genembo giti seteno aera saramana erera, aminda buvudo nemonde dabade saramana areva,’ aminge setira. ");
INSERT INTO kpr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Aminge sedo, nu iriri ungobu etiri aira, saramana kakato da giti jighari aikena setira, ‘Saramana kakato amboda ungobu (5 koroko) ari dae iri ojighera tuturo edo saramana etera ava, giti se furore!” aminge setiri, giti jighariá jovereghe aira setiri, ne javi edo ojeri. ");
INSERT INTO kpr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ojero, nenda mino+ K10 mutira. ");
INSERT INTO kpr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ava futiri, saramana giti tuturo etera aimi, gido koteteri, ‘Avose, namonde mino+ itako teria barera tanojo.’ Avata nu mino kau daba ava, nemokena mutira. ");
INSERT INTO kpr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mutiri budo, ne dubo ekoko use vare numamo aikena seteri, ");
INSERT INTO kpr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Gegenembo amboda tambu seteso ojera amo, ne saramana jo umbu ghousago aeri. Ne sifo tufako saramana eteri. O namane, sifoghae tuturo edo, saramana ero ojira ungobu etira. Ava sedo nangetiraimi nene bera, kau daba ava namanekena mutesi?’ aminge seteri. ");
INSERT INTO kpr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Setero, vare numamoá eredo nenda genembo enikena sisira, ‘Nanda komana, resena evia, ningaresa tano! Na ni jo deraeri. Ni saramana aso mino+ K10 mutari setena amo, ni ‘avori’ setesi. Ava sedo, aminge muteni. ");
INSERT INTO kpr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Avori, ava budo kamboda yasi! Gegenembo amboda saramana etera, nembarago mino kau daba ava mutari uju eteni. ");
INSERT INTO kpr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Moni mo nandari. Ava sedo, na bajariri. Nanda uju ava arena. Avose, na kavevera etena aindae, ni dubo mema eresa tanojo.” ");
INSERT INTO kpr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tano ari dae use, sisira, “Ava sedo, mave giti edo erira amo, nu foa ambo gayarira. A mave ambo gaedo refira amo, nu ya darige giti arira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesu nu Jerusalem vitise, namane 12 gategusira avanembo budo, dabade tatedo esike ise, eminge sisira, ");
INSERT INTO kpr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ningivu! Namonde reighi Jerusalem yari dae viti refera. Reighi ominda, evetu genembo mendeniimi Evetu Genembo da Koro+ ava sandi bundedo, fristi+ da kokotofu a Moses da Geka ijuga kakato+ da ungoda fitarera. Fitoro budo, numoá daoro ambare dae sarera. ");
INSERT INTO kpr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Daoro ambare dae sedo, nu budo namonde Israel embo da gitofukena mutoro, budo dere jise ambíimi dedo, budo yama arafa daoro ambarira. Ambudo, sifo etodaba naká dadabari ainda amboda, God sari nu sekago ambarida ghe jebugedo erarira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Iesu aminge sisira ainda amboda, Zebedee noaro nunda vide jamenade dabade fera Iesu kena buvudo, evetuá kauboi dadarigedo, numo sonembare dae benunu sisira. ");
INSERT INTO kpr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Setiri, Iesu numokena ategi usira, “Na rea aono dae resesi?” setiri, evetuá sisira, “Ni amboda kini (king) aresa ainda sifoda, nanda sasingu etoto nakáé saso, eni ninda ungo gimandukena, a eni umbefukena anumbarera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Setiri, Iesu nangedo ambaetira ava kotise, mino nemokena sisira, “Ne rea benunu reseva ava, ne jo kasama use sae ereva. Ne erekoteva: na agha Afa mutari bu fumbu rise mema itatamarena amo, ne kau daba ava areva, ai? O gitofuimi bouvu a mema namokena mutarera amo, ne kau daba ava fumbareva, ai?” aminge setiri, ne mino siseri, “Ai, namane aoro inono arira.” ");
INSERT INTO kpr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ne aminge setero, nu nemokena sisira, “Resevare. Ne agha nane fumbu rise mema itatamarena ava budo, kau daba aminga ava areva. Avata mave nanda ungo gimandukena a kotugo umbefukena anumbarira ava, jo nane gategari da kaugo iraeri. Nanda Afa mavejoá gategedo simbugetiri irera amo, ne aminda anumbarera,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ne aminge benunu sisera ava, namane ghabu sovenisoveni aimi ningido, John nengae James ghae kena dubo ekoko useri. ");
INSERT INTO kpr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Etero, Iesu namane isambukena kori setiri fera totoruguseri. Totorugetero, nu sisira, “Enda da gavana mendeni nange eraera ava, ne eregoseva. Enda da kokotofu a babojegari mendeni, ne kovionoghae seoro nenda natofo nenda geka ningido ava eraera. ");
INSERT INTO kpr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Avata ne, jo amingae areva. Mave nenda jokáda bajari ari dae sarira amo, ne isambu nune sonembarira. ");
INSERT INTO kpr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","A mave nenda giti jighari dae sarira amo, nu tofo sabua+ da ari ava use, ne kaifa arira. ");
INSERT INTO kpr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Amo nu, kau namongo ava arira. Evetu Genembo da Koro+ nu evetu genembo sonembuse, nenda ari ekoko da mino futuse, ambari dae sedo fusira. Jo evetu genembo numoá sonembaoro dae sedo furaeri,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Namane Iesu de dabade reighi Jericho dodo yari dae ero, natofo digari fera totorugetero, namane namonde dabade iseri. ");
INSERT INTO kpr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ero, gegenembo diti digoide etoto, emboro tinguda anumbirisera aimi, Iesu fira utua iri, ava setero ningido, ne tuturo edo koko sedo ghuseri, “Kini (King) David da Mandi God mutari sisira amo, nimori. Ava sedo, namane joka eyo!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Setero, natofo isambu ghoghora sise, beka doyoro dae bureguseri. Buregusera avata, nengae jo itako doyae, nengae sekago koko sise beka teriago beká kori siseri, “Kini David da Mandi God mutari sisira amo, nimori! Ava sedo, namane joka eyo!” ");
INSERT INTO kpr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Aminge setero, Iesu ava ningido fete kori setiri, nengae eredo numokena fuseri. Fera buvero, sisira, “Na rea aono dae uju erevu?” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Setiri, ne siseri, “Bajari, saso namanenda diti eveva use, afigari sifo sevo gaeteri!” ");
INSERT INTO kpr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aminge setero, Iesu nu joka edo ungo sirege ditida jijighusira. Jijighiri ainghae dabade diti eveva edo afigetiri, fuge gosuseri. Gido, nengae eredo Iesu da amboda iseri. ");
INSERT INTO kpr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesu nunda ambo jimbide era, reighi Jerusalem utua use, reighi Betfeij aminda buvurutuseri. Betfeij resena emo, nu enda jiro fumbari javo Orivi seraera, ainda ganasa ifudari. Aminda buvudo, Iesu namanenda jokáda, gegenembo etoto naká gategedo diriguse, ");
INSERT INTO kpr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","eminge sisira, “Reighi dombukena eregoseva? Ominda ya buvurutuse, gareva. Donki (donkey) nunda mandighae buri edo dighero fetirera, ava tambareva. Amo vujegedo, nengae namokena bu furovo dae resena. ");
INSERT INTO kpr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nengae amingururovo, mave nendae ategi arira amo, eminge sevu, ‘Bajari donki (donkey) evia uju erira.’ Aminge sareva amo, nu ‘avori’ sari nengae budo furareva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Feroveta rea kotise gefusira ava, beká sirorare dae sedo, Iesu nu amingusira. Geka gefusira amo, eviri: ");
INSERT INTO kpr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saion+ embokena saso ningore! Givu! Oroko nenda kini (king) foa buvari dae erira. Nu donki (donkey) da mandi ainda gukada viti anumbedo refira. Sainghiako durumugedo refira,” feroveta aminge gefusira. ");
INSERT INTO kpr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Avori, Iesu rea uju use sisira ava, nengae era aminguseri. ");
INSERT INTO kpr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Donki (donkey) nunda mandighae ava budo fera, nenda tamo asugari mendeni ava kose javureghedo, donki nunda mandighae ainda gukada fifituseri. Fitero, Iesu viti donki mandi ainda gukada anumbusira. ");
INSERT INTO kpr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Anumbedo javi iri, natofo digari ambari aimi, nenda tamo asugari mendeni ava kosedo emboroda dudo ero, nu ainda etoda fetedo isira. A mendeni, ika fafatu joredo emboroda dudo ero, nu ainda etoda fetedo isira. ");
INSERT INTO kpr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Evetu genembo ambo garusera, a giti edo isera aimi, tuturo edo koko sise a nati joká doruse, eminge siseri, “Orokaiva, orokaiva! David da Mandi God mutari sisira amo, nimori. Buvuruteresare! Bajari da javoda refira, aindae sakai saore! Orokaiva, iká bekádari!” aminge sise, nati joká doruse sero, reighi Jerusalem aminda era teteruseri. ");
INSERT INTO kpr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesu de dabade teterero, Jerusalem embo isambu dudukughedo manamana use eminge siseri, “Omo mavejori?” ");
INSERT INTO kpr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aminge setero, evetu genembo Iesu de dabade fusera aimi, mino siseri, “Emo Frovensi Galilee a reighi Nasareth embori. Feroveta javo Iesu seraera amo, numori,” ne aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu ira God da Kambo+ aminda tere fetedo, evetu genembo oriro use, a ofuse irisera ava, isambu ondiri buvurutuseri. A gegenembo moni oriro edo ghusera, nenda ghagha jighi jovereghusira, a gegenembo rika ribo oriro edo ghusera, nenda avo anumba ábarago jighi rokombusira. ");
INSERT INTO kpr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aminguse, nemokena sisira, “God setiri nunda Geka jokáda rea gembero irira amo, eviri: ‘Nanda Kambo+ mo, banungari da kambori,’ God aminge sisira. Avata ne teredo emingevo, Kambo+ emo kau tafasara kakato da dobo a beku da kau avavaga edo irira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Iesu nu God da Kambo+ jokáda iriri, evetu genembo diti digoide a ungo ata dimbaride ava, numokena fera buvero, setiri ne jejebuguseri. ");
INSERT INTO kpr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Avata fristi+ da kokotofu a Moses da Geka ijuga kakato+, ne janje ekoko useri. Sasingako ne koko a kori sise eminge siseri, “David da Mandi God mutari sisira amo, nimori. Orokaiva!” aminge sero nininguse, a Iesu tano dombu eni dombu eni etiri sirorusira ava gido, fristi+ da kokotofu a Moses da Geka ijuga kakato+ janje ekoko useri. ");
INSERT INTO kpr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Edo, Iesu kena siseri, “Ni, sasingakoimi resera omo, niningeresa?” aminge setero, Iesu mino nemokena sisira, “Ai, niningerena. Amo jo eko iraeri. Ne emingerera amo, anakora God da Geka jokáda gembero irira, ava erera. Amo eviri: ‘Ni seteso, sasingako a ami mindari amo, ne nindae sakai evevago beká ava seraera,’” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aminge sedo, Iesu ne dodo Jerusalem ghedo buvudo, ira reighi Bethany aminda avisira. ");
INSERT INTO kpr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ravisira eredo, sifoghae jovereghe namane namonde dabade, Jerusalem yari dae ise, Iesu nu emboro soroda ighoi usira. ");
INSERT INTO kpr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Etiri, nu diti fuge ika kayuyu emboro tinguda fetiriri gosusira. Gido, nu vuji tosimbe mindari dae terisira. Avata beká tefori. Igi vanembo ava gido, nu sisira, “Sifo amboda, ikaé, beká jo sekago jighae arira,” aminge siri ainghae dabade, ika kayuyu gharasa edo avisira. ");
INSERT INTO kpr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Namane ava gido manamana use siseri, “E kau nange nange etirai? Ika emo nange totoi gharasa edo ravi?” aminge sise ategi useri, numokena. ");
INSERT INTO kpr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ategi etero, nu sisira, “Na geka beká nemokena resena. Ne tumondareva, a jo itako manamana ae areva amo, na rea eteno kayuyukena siroretira, kau daba aminga ava, nene saovo sirorarira. A eni mo: ne tumonduse, doriri oindae, ‘Darige yasi evada tifughase!’ saeteva amo, God sonembari, doriri omo darige ya evada tifugharira. ");
INSERT INTO kpr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ne tumondareva amo, rejodae benunu sise banungareva, ava sirorari bareva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu ira God da Kamboda+ teterusira. Teredo ijugiri, fristi+ da kokotofu, a namonde Jusi embo da babojegari, fera numokena ategi use siseri, “Se ningore! Mave setiri ni saramana emo eresi? Ni mave da javoda geka emo vironu resesi?” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Setero, Iesu mino nemokena sisira, “Nambarago nemokena geka dabako ategi arena. Einda mino sareva amo, na mave da javoda ojena amo, isagha saono ningareva. ");
INSERT INTO kpr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sevu ningone! John Bafataito Ari Kato, mave da javoda evetu genembo bafataito edo ghusi, evetu genembo da javoda ai, God da javoda?” aminge setiri, ne tuturo edo tofo tofo beisiga use, se nininguseri, “Namonde kau nange nange sareri? Namonde, ‘God da javoda bafataito edo ghusira,’ sarera amo, nu, ‘Ne redae John jo tumondae usevu?’ sarira. ");
INSERT INTO kpr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","O namonde, ‘Evetu genembo da javoda bafataito edo ghusira,’ sarera amo, natofo eminda totorugetera eimi, namonde darera. Ainda tuka mo: evetu genembo isambu ne koteraera amo, John nu God da feroveta eniri. Ava sedo, namonde aminge sarera amo, natofoé namondekena rea arera, aindae oju erera.” ");
INSERT INTO kpr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ne aminge sise, Iesu kena mino eminge siseri, “Namane erebunera,” aminge setero, Iesu nemokena sisira, “Avori, nambarago mave da javoda saramana eraena, nemokena jo saono ningae areva,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Aminge sise, Iesu sisira, “Nenda kotari ava sevu ningone! Genembo eni nunda vide jamena etoto naká iriara ava, sifo eni nu eredo begokena eminge setira, “Yasi, nanda vareda saramana ase!” ");
INSERT INTO kpr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Aminge setiri, nunda mandi begoá setira, “Resesa ava, na imboe erena,” aminge sedo, amboda nu dubo jovereghetiri, aira saramana etira. ");
INSERT INTO kpr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kotugo ainda amboda, genemboá eredo nunda mandi ambodae, kau daba ava setira. Setiri, nunda mandi ambo numamokena, ‘Avori, amingarena,’ setira. Aminge setira, avata nu jo yaeri. ");
INSERT INTO kpr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ava sedo, numamo da uju amo, mave eti? Begoi eti, ai, amboi eti? Sevu ningone!” Iesu aminge setiri, ne, “Begoi etira,” siseri. Setero, Iesu sekago fristi+ da kokotofu a Jusi embo da babojegari aikena sisira, “Ava sedo, na nemokena eminge resena: takesi bari kakato a evevetu saghere kakato, ne giti God da natofo+ aoro, God ne kaifa ururari irarera. O nemo, ambo gayareva. ");
INSERT INTO kpr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ainda beká mo: John Bafataito Ari Kato fira, nemokena emboro eveva ijugusira amo, ne nu jo tumondae usevu. Avata takesi bari kakato a evevetu saghere kakato, ne John da geka ava tumonduseri. Tumondusera ava gido, nembarago tumondaetevu. Avata ne jo tumondae usevu,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iesu aminge sise, sekago fristi+ da kokotofu a Jusi embo da babojegari aindae sisira, “Kasia eni ningovo dae resena. Genembo eni aira vare simbugedo vaini da asi ava govetira. Govedo, furu dighi birurughetira. Ainda amboda, nu asi vuji da muka ava simbari vosari bari dae sedo, bako ghambira. Ghambudo, kaifa kakato da vasa iti vitira. Itiri dadabetiri, nunda vare amo, evetu genembo mendeniimi saramana use moni futururoro bari dae sedo, mutira. Evetu genembo aimi vare ava kaifa ero, nu reighi eninda aira. ");
INSERT INTO kpr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Avori, asi vuji bambari da sifo ojira buviri gido, vare numamoá nunda boanda bari dae sedo, nunda saramana kakato mendeniimi dirigetiri kaifa kakato aikena aera. ");
INSERT INTO kpr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Aera buvero, kaifa kakatoá eredo, vare numamo ainda saramana kato eni ava sandi de babasegeteri, eni detero ambira, a eni ghamanai afe doruse onderi. ");
INSERT INTO kpr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Etero ainda amboda, vare numamoá saramana kakato mendeni dirigetiri aera. Digarigo dirigetiri aera buvero, vare kaifa kakato ne sekago kau daba ava eteri. ");
INSERT INTO kpr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Amboda beká, tofo nunda mandi diriguse, eminge kotetira, ‘Avose, nanda mandiva kakara arera tanojo,’ aminge kotise, nunda mandi ava dirigetiri aira. ");
INSERT INTO kpr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Avata vare kaifa kakato ne mandiá gosuse tofo tofo se ningeri, ‘Mandi omo, vare einda numamo da mandiri. Amboda vare emo, nune barira. Ava sedo fuvu, namonde nu daoro ambari, vare emo namondeda tofodae baore!’ ne aminge seteri. ");
INSERT INTO kpr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aminge sedo, ne eredo, mandiá vare jokáda sandi jumbudo aera isaghada buvudo, detero ambira. ");
INSERT INTO kpr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Avori, kote givu! Vare numamoá eredo foama, vare kaifa kakato aikena nange ari? Sevu ningone!” Iesu aminge setiri, ne mino numokena siseri, ");
INSERT INTO kpr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“Nu kaifa kakato ekoko amo dari ambarera. Amboro, kaifa kakato eveva ava gategari, vare kaifa e gogoghombuse, nunda boanda ava vuji bambari da sifo aminda, mutudo gharera,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Setero, Iesu tofo numoá ijuguse nemokena sisira, “God da Geka emo tegutusevu tanojo: ‘Ghamana eni, kambo itari kakatoi imboe edo fugutusera ava, Bajari nune budo tutumbidae sedo fiti simbugedo, aminda tuturo edo, nunda kambo itari dae erira. Emo Bajari da ariri. Namonde gido dudukugherera,’ God da Geka aminge resira. ");
INSERT INTO kpr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ava sedo, nemokena saono ningovo dae resena. Amboda God da natofo+ ava, jo nene kaifa ae areva, a kotugo ne totofo jo nunda natofo+ ae areva. O evetu genembo mendeni, God da natofo+ da eveva ava kotise, God da uju avanembo eraera ava, Bajari sari nunda natofo, nene kaifa arera. ");
INSERT INTO kpr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Eni mo: ghamana kasia da setena, ainda geka mendeni eviri. Mave ghamana etoda durarira amo, nu de gite ambarira. O ghamana aimi maveda etoda du fatarira amo, nunda tamo fati tafere ari ambarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Setiri, fristi+ da kokotofu a Moses da Geka kaifa kakato+, ne vare da kasia ava ningido kasama useri, Iesu kasia amo nendae sisira. ");
INSERT INTO kpr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ava kasama edo, numoá sandi bundari dae kotiseri, avata jo inono aeri. Ainda tuka mo: evetu genembo natofogo ainda kotari mo, Iesu nu feroveta eniri. Fristi+ da kokotofu a Moses da Geka kaifa kakato+, ne ava kasama edo, evetu genembo totorugusera aindae oju edo, Iesu jo sandaeri. ");
INSERT INTO kpr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Aminge sise, Iesu sekago kasia eni eminge sisira, ");
INSERT INTO kpr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Evetu genembo nange God da natofo+ arera amo, kau emingori. Kini (king) eninda mandi evetu fitari setiri aindae, numamo kirumo simbuguse irei. ");
INSERT INTO kpr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Aminguse, nunda aghi kakato dirigetiri aera, kirumo da sifo ava osa setero, nunda natofo gategetira, ai ningeri. Amboda sifo ojira buviri gido, nunda saramana kakato mutiri evetu genembo gategetira aikena, aghi ari dae sedo aera. Aera aghi etera avata, evetu genembo mavejoá kini gategedo furore dae setira, ne imboe eteri. ");
INSERT INTO kpr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Etero, kini nu saramana kakato mendeni sekago diriguse, eminge setira, ‘Eminge sevu, evetu genembo ningore, “Nanda kirumo simbugeteno irira. Burumakava (steers) a burumakava da mamandi (calves) evevago ava de ojetero irira. Roera isasambu simbugetero irira. Ava sedo, evetu fitari da kirumo ari dae erera. Ne fuvu!” aminge sevu!’ kini aminge setira. ");
INSERT INTO kpr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Setiri, ne aera evetu genembokena aminge seteri. Avata evetu genembo amo, ne kini da geka jo ningaeri. Eni eredo, nunda vareda aira. Eni kini da geka kotae edo, nunda bisnis (business), moni saramana ari dae sedo, aira. ");
INSERT INTO kpr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A mendeni ne, kini (king) ainda saramana kakato ava, sandi de babasegetero amomonjegeteri. ");
INSERT INTO kpr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Etero, kini janje eko beká ava etiri, nunda isoro kakato dirigetiri aera, evetu genembo kini da saramana kakato detero amomonjegetera, ainda reighi sosighi edo, nati dungetero avira. ");
INSERT INTO kpr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Etiri, kiniá kori setiri, nunda saramana kakato totorugetero nemokena setira, ‘Kirumo simbugetero irira, avata evetu genembo giti furoro dae setena amo, jo nene mindae arera. Ne ekokori. ");
INSERT INTO kpr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Oroko emo yasivu, emboro teria aminda ise, evetu genembo mavejuá tambareva, ava aghi evu!’ aminge setira. ");
INSERT INTO kpr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Setiri, nunda saramana kakato buvudo aera, evetu genembo isambu mavejoá tambera, ava unumbe budo ojeri, evetu genembo eveva a ekoko ainde dabade. Etero, aimi ojera buvudo, kini (king) da kambo bedo etira. ");
INSERT INTO kpr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nunda kamboda totorugetero, kini (king) nunda esa embo gari dae sedo aira teretira. Teredo, genembo eniá fuge gira. Genembo amo, nu jo gogho edo, nunda asugari evevago eni jo asuge furaeri. ");
INSERT INTO kpr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kini (king) ava gido, nundae ategi etira, ‘Nanda komana, ni nangetirai ninda tamo asugari ekoi asugedo ojesa teretesi? Aminguse, namondeda agho dari erebejesa,’ aminge setiri, genemboá geka rejo eni jo saeri. ");
INSERT INTO kpr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Etiri, kini (king) nunda saramana kakatokena setira, ‘Genembo emo, jo inono iraeri. Ava sedo, nu sandi ungo ata bundedo, bu yasivu, ajagha fitovo, tumba jokáda irise, sorara use dika ghininji ghananja ghuse irare!’” ");
INSERT INTO kpr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Iesu aminge sise, tano ari dae use sisira, “God evetu genembo digari ava kori seraira, avata daba daba gategeraira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kasia ava ningido, Moses da Geka kaifa kakato+ eredo Iesu geka sembae sirurari ningido, numoá bu koto ari dae, esike era fetedo manaka garuseri. ");
INSERT INTO kpr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Manaka gaedo, nenda ambo jimbi mendeni nemonde Kini (King) Herod da ambo jimbide dabade, ava dirigetero, Iesu kena iseri. Era, Iesu dederuseri, “Ijuga Kato, namane kasama erera, ni geka beká avanembo sifo ghousa ijugeraesa. Ni evetu genembo da kotari amo jo oju ae use, God da uju avanembo ijugeraesa. ");
INSERT INTO kpr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ava sedo, se ningore! Namondeda Agho Dari nange resi? Namondeda gitofu Rome embo da kotofukena takesi ombarera, ai tefo? Ava se ningore!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Avata numo dederuse sisera, ava itatamusedo, Iesu eminge sisira, “Ne gungubo kakatori. Ne redae na dedererevu? Setiri, moni budo ijuguseri. ");
INSERT INTO kpr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ijugetero gido, Iesu ategi usira, “Moni tamonda, dangio a javo emo, mavedari?” aminge ategi etiri, ");
INSERT INTO kpr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ne siseri, “Rome embo da kotofu, namonde Caesar seraera, nundari,” aminge setero ningido, Iesu sisira, “Avori, Caesar da tofo amo, Caesar dae mutuvu bare! A God da tofo amo, God dae mutuvu bare!” Iesu aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ne ningido buniseri. Bunedo, ne Iesu dodo iseri. ");
INSERT INTO kpr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sifo daba aminda, Jusi embo da mendeni, aindae Sadusi embo+ seraera aimi eredo, Iesu kena fuseri. (Sadusi embo+ resena emo, ambari embo jo sekago jebugedo erae arera, ava koteraera.) ");
INSERT INTO kpr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Aimi fera Iesu kena ategi use siseri, “Ijuga Kato, Moses eminge ijugedo ghusira: ‘Genembo mave evetu fitari, mandi sasingu jo sirorae iroro genemboá ambari nunda rori irarira amo, nunda ambo bego eniimi roriá fitarira. Genembo ambarira ainda veka sirorare dae sedo, fitarira,’ Moses aminge ijugedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Avori, kiki eni sari dae erera. Ningi! Ambo bego isambu 7 ava namondeda jokáda iriara ava, bego beká ai evetu fifitusira, ava sasingu eni jo sirorae irero nu ambududurusira. Ambiri, rori amo nunda diroruimi fifitusira. ");
INSERT INTO kpr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aminguse, fifitero refara, ambo nemboi bu fitido ireira ambududurusira. ");
INSERT INTO kpr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ainda amboda beká, roriá ambududurusira. ");
INSERT INTO kpr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Avori, se ningore! Amboda sifo eninda, evetu genembo isambu jebuge erarera, seraesa. Gegenembo isambu 7 aimi evetu dabako ava fifituseri. Ava sedo, iria edo, erari da sifoda, evetu amo maveda evetu ari? Bego aindari, o ambo aindari, ai maveda evetu ari? Ava se ningore!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Setero, Iesu mino nemokena sisira, “Ne sembae beká ava erekoteva. Ainda tuka mo: ne God da Geka rea resira, a God da fakina ava, ne erebuneva. ");
INSERT INTO kpr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Evetu genembo ambarida ghe jebuge erarera ainda sifo aminda, ne kau aneya da kau aminga ava irise, genembo evetu jo fitae arira, a evetu genembokena jo vai ae arira. ");
INSERT INTO kpr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kotugo ambari embo, ambarida ghe jebugedo erarera, ainda geka eni sari dae erena. Ningivu! God nu Geka evia ningovo dae sisira, amo tegutusevu, ai? Kote givu! ");
INSERT INTO kpr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘God, nembuamane Abraham, Isaac, a Jacob anakora endada irise tumonduse iriara, a kotugo oroko tumonduse irera amo, namori.’ God aminge sisira aindae, namonde kasama erera: ambari embo mo jo amboro dadabaeri. Ava sedo evetu genembo isambu, ambari embo a jebuga embo isasambu, God da dombuda jebuga irera,” Iesu aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","evetu genembo aminda totorugedo irisera amo, nunda ijuga ava ningido dudukughuseri. ");
INSERT INTO kpr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iesu geka evevago setiri ningido, Sadusi embo+ mino sari buniseri. Sadusi embo+ mino sari bunisera, ainda bino ava iri, Moses da Geka kaifa kakato+ ningido, Iesu kena fera totoruguseri. ");
INSERT INTO kpr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Totorugedo, nenda ijuga kato eni, Iesu geka sembae sirurari ningari dae ategi usira, ");
INSERT INTO kpr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ijuga Kato, God da Agho Dari jokáda, geka mindafu beká ningiavori?” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu mino sisira: “‘Ninda Bajari God kena, ninda dubo a ninda kotari isasambuimi futuse, nusuka numoá ava, dubo bu gogoghombaresa!’ ");
INSERT INTO kpr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Amo God da Agho Dari mindafu bekári. ");
INSERT INTO kpr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nunda Agho Dari setena ainda kaugo eni mo, eviri: ‘Ni tofo dubo buraesa, kau daba aminga ava, ninda komana barago dubo baresa.’ ");
INSERT INTO kpr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","God rea setiri Moses gefusira, a feroveta mendeni gefusera, ainda susu mo eviri,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Setiri dadabetiri ainda amboda, Moses da Geka kaifa kakato+ numokena totorugusera aikena ategi usira, ");
INSERT INTO kpr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nenda kotari sevu ningone! God evetu genembo sonembuse, Genembo eni mutari dae sisira amo, mavejori? Oro mavekena sirorari?” Iesu aminge setiri, ne mino siseri, “Amo, nu David da sasingu a imemesiri ainda jokáda sirorarira. Nu David da Mandi eniri,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Setero, Iesu nemokena sisira, “Ne geka reseva, a kotugo David tofo mandi gefusira ava, jo foa geka dabako ae irira. God da Asisi imi David sonembiri Genemboá tumonduse, ‘Nu nanda Bajari,’ gefusira. Geka David gefusira resena amo, eviri: ");
INSERT INTO kpr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bajari nu nanda Bajarikena sisira, “Fu, nanda ungo gimanduda anumbiraso, ninda gitofu ninda fakina ava gosururoro, ne de bundedo bu foama, ninda ata duruda fitono fafasaore!” Bajari aminge sisira,’ ava David gefusira. ");
INSERT INTO kpr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Avori, genembo mo, nunda sasingu da bajariri. Mandi eni jo viti numamo da bajari bae aeti. Ava sedo David, Genembo amboda furarira ava kotise, ‘Nu nanda Bajari,’ sisira amo, nu jo nunda mandi ava kotise saeri. Nu Genembo aindae igheghi use, nunda Bajari arira ava sise sisira. Ava sedo, nenda geka seteva amo, jo inono iraeri.” ");
INSERT INTO kpr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iesu aminge setiri, ne manamana edo geka da mino sari buniseri. Bunisera ai tano aminda, mave eni jo fakina edo, sekago Iesu kena ategi use, gisae edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iesu aminge setiri dadabetiri ainda amboda, nu namane a evetu genembo totorugusera aikena eminge sisira, ");
INSERT INTO kpr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Moses da Geka ijuga kakato+ a kaifa kakato+, ne Moses da vasa budo ijugeraera. ");
INSERT INTO kpr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ava sedo, ne rea seraera a ijugeraera ava, amingareva. Avata ne rea eraera ava, erá eove dae sise resena. Ainda beká mo: ne rea aovo dae seraera ava, ne totofo jo use sae eraera. Ne sembae eraera. ");
INSERT INTO kpr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ne agho dari digari simbugedo, seoro natofo janjagu use irá gheraera. Avata Moses da Geka ijuga kakato+ a kaifa kakato+, ne totofo nenda agho dari jo kaifa use, ainda bouvu jo itako fumbae eraera. ");
INSERT INTO kpr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Moses da Geka ijuga kakato+ a kaifa kakato+, ne rea eraera ava, natofo nemo gido nendae sakai saoro dae sise eraera. Moses da Geka kotise, ne God da Geka mendeni gembudo, ungoda a dombuda dighido deingheraera, a tamo asugari da embo, sori babai ghoghousa gateraera. Avata ne jo God kotise amingae eraera. Evetu genembo mendeni, nendae sakai saoro dae sedo, eraera. ");
INSERT INTO kpr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kirumoda yarera o banungari dae yarera amo, ne vasa evevada anumbari dae uju eraera. ");
INSERT INTO kpr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kau daba aminga ava, ne uju eraera, ne ya ombari vasada buvurutururoro gido, evetu genembo ne kakara use, ‘Ijuga Kato’ sise ategi aoro dae uju eraera. ");
INSERT INTO kpr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ne jo amingae areva. Mave ni ategi use, jo ‘Ijuga Kato’ sae arira. Ainda beká mo: ne isambu nano namendide inonori. Nenda Ijuga Kato dabako irira. ");
INSERT INTO kpr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A ni genembo eni ategi use, jo ‘Afa’ sae aresa. Ainda beká mo: nenda Afa dabako utuda irira. ");
INSERT INTO kpr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A mave ni ategi use, jo ‘Bajari’ sae arira. Ainda beká mo: nenda ari ekoko kote doyari dae sedo, God nenda Bajari dabako mutari sisira. ");
INSERT INTO kpr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mave nenda jokáda giti jighari arira amo, ne isambu nune sonembarira. ");
INSERT INTO kpr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mave tofo nunda javo jighari erarira amo, nu foa ambokena arira. O mave nu tofo fitari vosarira amo, amboda natofoi fitoro nu vitarira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Aminge sise, Iesu sisira, “Arie, Moses da Geka ijuga kakato+ a kaifa kakato+! Ne taká amboda mema itatamareva. Ne gungubo kakatori! Ne totofo God da natofo+ jo ae ireva. A evetu genembo mendeni God da natofo+ ari dae uju eraera ava, nene buregeraeva. ");
INSERT INTO kpr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Arie, Moses da Geka ijuga kakato+ a kaifa kakato+! Ne taká amboda mema itatamareva. Ne gungubo kakatori! Ne dederuse, roriri da kambo a gugua ava nenda tofodae ruruse, natofo nemoá gido nendae sakai saore dae sedo, ya God da Kamboda+ tere fetedo ghousa futo banungeraeva. Aindae sedo, ne mema eko beká ava tambareva. ");
INSERT INTO kpr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Arie, Moses da Geka ijuga kakato+ a kaifa kakato+! Ne taká amboda mema itatamareva. Ne gungubo kakatori! Genembo eni nangedo nenda ambo jimbi aetira aindae sedo, ne e gogoghomberaeva. Avata, mave nenda ambo jimbi arira amo, nu nenda ijuga sembae ava nininguse, ari eko beká ava arira. Ne aindae sedo, mema tambareva. ");
INSERT INTO kpr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Arie, ne ijuga kakato sembaeri! Ne amboda taká mema mindafu beká ava itatamareva. Ne diti digoide mamaneri. Ava nange edo evetu genembo mendenidae emboro ijugeraevu? Ne sembae ijuguse eminge seraeva, “Genembo eni, God da Kambo+ ainda javoda beka gajedo irise, ya nunda beka gajari ava bejarira amo, ne ‘avori’ seraeva. O genembo daba aimi, auri eni ‘gold’ seraera God da Kamboda+ irira, ainda javoda beka gajedo irise, ya nunda beka gajari ava bejarira amo, ne ‘agho dari beká ava bejariá’ seraeva. ");
INSERT INTO kpr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Amo, ne daghedo sarigeraeva. God da Kambo+ da ‘gold’ o moni amo, God da Kambo+ da fakinaimi etiri kakara edo irira. Ava sedo, erá ‘God da Kambo+ kitako’ sise, ‘God da Kambo+ moni mindafu’, ava seove! God da Kambo+ da javoda rea beka gajaresa amo, amingaresa. A God da Kambo+ da moni ainda javoda rea beka gajaresa amo, amingaresa. ");
INSERT INTO kpr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Eni mo, ne eminge ijugeraeva. Genembo eni olta (altar) da javoda beka gajedo irise, ya nunda beka gajari ava bejarira amo, ne ‘avori’ seraeva. O genembo daba aimi, joba eni oltada fifitusera, ainda javoda beka gajedo irise, ya nunda beka gajari ava bejarira amo, ne ‘agho dari beká ava bejariá’ seraeva. ");
INSERT INTO kpr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Amo, na sekago resena: ne daghedo ireva. Olta da fakinaimi joba kakara arira. Ava sedo, erá ‘olta kitako’ sise, ‘joba olta etoda fitiraera, teriava,’ seove! ");
INSERT INTO kpr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ainda beká mo: mave olta da javoda beka gajarira amo, nu olta (altar) da javoda a joba oltada fasirira, ainda javoda beka gajarira. Jo dombu eni iraeri. ");
INSERT INTO kpr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mave God da Kambo+ ainda javoda beka gajarira amo, nu jo God da Kambo+ ainda javoda nembo beka gajae arira. God nu aminda irá gheraira ava sedo, nu God da javo ainghae dabade beka gajarira. Jo dombu eni iraeri. ");
INSERT INTO kpr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kau daba aminga ava, mave utu da javoda beka gajarira amo, nu utu da javoda, God da avo anumba da javoda, a tofo God da javoda beka gajarira. God nu aminda anumbirá gheraira ava sedo, jo dombu eni iraeri. Ne natofokena beka gajari da emboro sembae ijugeraeva, aindae sedo, ne mema tambareva. ");
INSERT INTO kpr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Arie, Moses da Geka ijuga kakato+ a kaifa kakato+! Ne taká amboda mema mindafugo itatamareva. Ne gungubo kakatori! Nenda gugua tomanako a nenda roera veveyako kau mosou, yabiyabina, a karaje ava budo, diti ghabu sovenisoveni fitido, diti eni budo God kena muturaeva. A nu evevari. Ne amingareva. Avata, amo kitakori. O Agho Dari da geka tomanako mo: inono da ari, joka ari, geka bekáda bekáda sari a ari bekáda bekáda ariri. Roera kikitako ava, nene eraeva. Avata roera teriago evia, ne jo ae eraeva. ");
INSERT INTO kpr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ne diti tefori. Ne emboro sembae ava ijugeraeva. God da Geka mendeni, ne kaifa eraeva. Avata geka mindafu evia, ne kotae eraeva. Ne aindae sedo mema tambareva. ");
INSERT INTO kpr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","26","“Arie, Moses da Geka ijuga kakato+ a kaifa kakato+! Ne taká mema mindafugo ava, amboda tambareva. Ne gungubo kakato a diti tefori! Ne kau genembo eni, nunda agha kofiri fokakena seghuse, jokakena jo seghae etira. Avavaga, ne gogho etevo nenda tamo eveva etira. Avata nenda dubo joká jo simbugae ireva. Ne ari ekokoi doghetiri jokáda ireva. Nenda dighighi ari a sosighi ari amo dodo, nenda ari ekoko vujegedo dubo joká ava simbugareva amo, ne gegenembo eveva edo irareva, dubo jokáda a kotugo nenda irari tamo isaghada. Ava jo ae eraeva aindae sedo, ne mema tambareva. ");
INSERT INTO kpr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Arie, Moses da Geka ijuga kakato+ a kaifa kakato+! Ne taká mema itatamareva. Ne gungubo kakatori! Nemo kau ambari embo da ofofo gomogori. Isaghakena mo, simbuge gogoghombetevo gari eveva erira. Avata jokáda mo, anakora betedo masa erira. ");
INSERT INTO kpr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kau daba aminga ava, natofo ne gido ‘evevava’ seraera, ne tamo gogho eraeva aindae. Avata nenda dubo joká mo, gunguboimi a ari ekokoimi bedo edo irira. Ne aindae sedo mema tambareva. ");
INSERT INTO kpr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“Arie, Moses da geka ijuga kakato+ a kaifa kakato+! Ne taká amboda mema mindafugo ava itatamareva. Evetu genembo evevago a God da feroveta, nenda ofofo ava esimbuguse, totofo eminge seraeva, ‘Namane abuamane da sifo aminda siroredo iraetera amo, namane God da feroveta jo daoro sirivo ae aeteri. Abuamane edo ghusera avavaga, namane jo ae aeteri,’ aminge sise seraeva. ");
INSERT INTO kpr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aminge seraeva avata, e givu! Nombuamane rea koteraera, kau daba aminga ava, nenda imemesiri koteraera. Ava sedo, geka beká mo: nembuamane rea kotedo ghusera a edo ghusera, ne kau daba aminga ava eraeva. Nemo, nembuamane feroveta dedo ghusera, ainda imemesiri bekári. ");
INSERT INTO kpr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ava sedo, nembuamane rea edo ghusera avavaga, oroko eminda evu ya dadabare! ");
INSERT INTO kpr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ne ekoko, Satan da sasinguri! Ne nange nange ari ekoko mino mutari da vasa omo darige yarevu? Amo jo nene darige yari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Nene dara eraeva, ainda bouvu fumbovo dae sedo, na feroveta, evetu genembo dubo kotari kakato, a God da Geka ijuga kakato+ mendeni dirigaono nemokena yarera. Yama, nanda javoda siruroro, nene mendeni sandi daovo sirivo arera, mendeni arafa daovo ambarera, mendeni sandido nenda dengoro indari da kambo+ aminda koto areva, a mendeni ondovo ya, reighi mendeni mendeni ominda, emboroda deinghuse irarera. ");
INSERT INTO kpr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Amingururovo, God da natofo evevago detero sirivo usera ainda mino isambu ava, God nemokena mutari, nene ruruse itatamareva. Tuturoda, Abel detiri ambududurusira, tano aminda ghe fira, Barachiah da mandi Zechariah, God da Kamboda+ detero olta (altar) dombuda ambududurusira, ainda mino isambu, ne oroko siroredo ireva, nene ruruse itatamareva. Geka beká resena. Ainda mema ne jo darigae areva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Aminge sise, Iesu sisira, “Arie mará, nanda natofo Jerusalem emboko! Ne God da feroveta deovo amburaera, a nunda aghi kakato ghamanai deovo sirivo eraera. Kau kokora nunda mamandi ghabui doghe sandi faseraira aminga ava, ne nane kaifa use, undari dae uju edo ghuseni, avata ne na buregusevu. ");
INSERT INTO kpr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ava sedo, God nunda Kambo+ nenda jokáda irira ava, do dumbari, ne tefo irareva. ");
INSERT INTO kpr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Geka beká: amboda ne na jo gae irovo, na reighi emo doyono, nesuka irise dubo jovereghedo, nati joká dorurovo gido, na jovereghe foa buvono, ne ategi emingareva, ‘Orokaiva! God ni esimbugetiri, nunda javoda refesa! Orokaiva!’ nandae aminge ategi use nati joká dorurovo, furono gareva,” Iesu aminge setiri dadabusira. ");
INSERT INTO kpr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu javi edo, God da Kambo+ dodo yari dae iri, namane numokena era, God da Kambo+ ainda vasa mendeni ainde dabade ijugari dae sedo, buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Buvero, nu namanekena sisira, “Ne God da Kambo+ ovia gosuse reseva, ai? Avori, ningivu! Na nemokena eminge resena. Gitofuimi foama Kambo+ omo de bejoro, oinda ghamana aveverege vose dadabarira ainda amboda, ghamana eniko jo nunda vasa ireira, aminda irae arira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesu nu enda jiro fumbari javo Orivi, aminda ira anumbiriri, namane numokena era, namonde kikiako anumbedo, ategi useri, “Ni, ‘God da Kambo+ de bejarera,’ setesa amo, nanjigo areri? Enda dadabari da sifo a ninda jovereghe furari da sifo ava, namane nange kasama areri? Rea sirorarira amo, nange kasama aeteri?” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Setero, Iesu mino namanekena sisira, “Diti gosuse kaifa evu! Erama, nemo dederuse gungubo sarera, ava tumondeove! ");
INSERT INTO kpr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ainda tuka mo: evetu genembo digari foa, gungubo sise, eminge sarera, ‘God evetu genembo da ari ekokodae, Genembo eni mutari sisira amo, namori,’ ne aminge sise, evetu genembo digari ava deroro, nemoá tumondarera. ");
INSERT INTO kpr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tataya ururoro ningareva, a soka beká isoro ururoro, ainda bino ava ningareva. A nu sirorarira avata, erá oju eove! Ainda beká mo: aminge siruroro ningareva, avata enda emo, jo sifo aminda dadabae arira. ");
INSERT INTO kpr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Natofo mendeni mendeni a gavana mendeni mendeni eredo, tofo tofo isoro ururoro ningareva. Endada, baimara eko sirorurari, dumo fururari itatamedo ghareva. ");
INSERT INTO kpr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ava sirorarira amo, inono, evetu tamo bouvu edo iriama edo, mandi sasingu javi urureari mema itatameraira aminga ava, enda da mema sifo aminda tuturo arira. ");
INSERT INTO kpr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Sifo aminda, evetu genembo mendeniimi foa ne sandido, gavana nemokena fakarago are dae sedo, a nemo dari ambovo dae sedo, gavanakena mutoro barira. Ne namo tumonderaeva aindae sedo, enda da natofo isambu ne imboe arera. ");
INSERT INTO kpr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sifo aminda, natofo digari namoá giti tumondusera aimi, na ighagha use, nenda tumondari doyarera. Aminguse, ne imboe edo tofo tofo aito arera. ");
INSERT INTO kpr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Sifo aminda, feroveta gungubo kakato foama, evetu genembo digari ava derarera. Foa gungubo sise, eminge sarera, ‘God da feroveta eni mo namori,’ sarera. Aminge sise, evetu genembo digari ava dederururoro, ne ‘bekáva’ sise tumondarera. ");
INSERT INTO kpr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ari ekoko viti mindafu ururari aimi, evetu genembo digari ainda dubo bari amo dadabarira. ");
INSERT INTO kpr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Avata mave fakina edo, namoá tumonduse jo ighagha ae iria ambarira amo, nu jebuga evovodae irari ava tuve barira. ");
INSERT INTO kpr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A kotugo, God nange nunda natofo+ kaifa eraira, ainda bino ava vironu siruroro, natofo nunda oro oro isasambu ningoro inono ari gido, enda sifo aminda tano arira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","(Iesu da geka eregefena evia, mave tegarira amo, nu ningido kote simbugare dae sise resena.) Aminge sise, Iesu sisira, “God da feroveta Daniel nu eminge sisira, ‘Amboda roera eko beká ava bu foa fitoro, God da vasa kakara nunda Kambo+ joká aminda fetari, aimi bebeta arira.’ Ava bu foa fitoro fetirari, ");
INSERT INTO kpr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ne Frovensi Judia eminda irise gareva amo, ne eredo sumbu yasivu, doriri ominda jungove! ");
INSERT INTO kpr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mave nunda ofoda anumbirari, sifoá foa buvari garira amo, nu jo ere kambo jokáda, gugua eni bari dae jo terae arira. Nu taká eredo sumbarira. ");
INSERT INTO kpr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","A mave vareda saramana ururari, sifoá foa buvarira amo, nu jo nunda tamo asugari bari dae sedo jovereghe kamboda yae arira. Nu taká sumbarira. ");
INSERT INTO kpr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mará! Na evevetu mave sifo aminda tamo bouvu edo irarera aindae, dubo mema erena. Ainda beká mo: evevetu sifo aminda tamo bouvu edo irarera, o sasingu veveyako unduse ami futuse irarera amo, ne sumbari dae ató barago use, mema mindafugo ava itatamarera. ");
INSERT INTO kpr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","God kena banungururuvu, erama dara resena evia, yaura teria da sifoda o Jangutari da Sifo aminda siroreure! Ainda susu mo: sifo aminda siroraetira amo, sumbu darigari fakarago aeti. ");
INSERT INTO kpr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ainda beká mo: mema a bouvu sifo aminda sirorarira amo, teria bekári. Enda sirorusira ai tano ghedo ojira orokoé, mema aminga ava jo sirorae irira. Kotugo mema a bouvu resena emo, ainda amboda barago, jo sekago aminga ava sirorae arira. ");
INSERT INTO kpr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Avata jo ghousa irae arira. God setiri fetirira amo, eviri. Dara furarira amo, jo ghousa irae arira. Ghousago iraetira amo, evetu genembo isambu sirivo aeteri. Avata God nunda natofo gategusira, nendae kotise sari, dara furarira amo, jo ghousago irae arira. ");
INSERT INTO kpr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Sifo aminda, mave nemokena sarira, ‘God namondeda ari ekokodae, Genembo eni mutari dae sisira amo, eviri. Fuvu gaove!’ sarira. O ‘Numo omindari,’ aminge sarira amo, erá tumondeove! ");
INSERT INTO kpr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ainda beká mo: gegenembo mendeni eredo, foa gungubo sise, ‘Genembo eni God mutari sisira amo, namori,’ sarera. Nemo feroveta gungubo kakatode dabade foama, God da natofokena dederururoro, ‘bekáva’ sise, nemoá tumondaeteri. Aminguse, ne tano a ari mendeni mendeni ururoro evetu genembo ne jo gae iriara ava, nenda gitida sirorari garera. ");
INSERT INTO kpr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dara resena emo, jo sirorae iriri, nu mavega ava kasama edo, fakina aovo dae sedo, orokoá seteno niningereva. ");
INSERT INTO kpr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Setena, daba ava sari dae erena. Evetu genembo mendeni eredo eminge sarera, ‘Keriso reighi uvu irae da vasa aminda irira.’ Aminge sarera amo, erá aminda gari dae yeove! O eminge sarera, ‘Keriso ominda jungedo irira.’ Aminge sarera amo, nenda geka erá tumondeove! ");
INSERT INTO kpr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ainda beká mo: Evetu Genembo da Koro+ jovereghe furarira amo, nu jo ufena furae arira. Nu, kau biria tarighedo sovenisoveni sarige feteari giraera aminga ava, Evetu Genembo da Koro+ fururari, evetu genembo isasambu garera. ");
INSERT INTO kpr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ambari embo da tamo reda betirarira, rika riduna aminda josarera,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Aminge sise, Iesu sisira, “Dara setena dadabarira ainda amboda mo, utu da fakina raugo edo javi ururari, iji da usasa dadabururari, inua jo janimbae arira. A damana utuda dore vosarira. ");
INSERT INTO kpr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ainda amboda, Evetu Genembo da Koro+ da tano, utuda isagha ururari, evetu genembo isasambu endada irera, ne ava garera. Gido, sorara ururoro, Evetu Genembo da Koro+ vose fururari garera amo, foroga etoda fetedo nunda fakina a usasa tomanako ainghae, vose fururari garera. ");
INSERT INTO kpr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Gosururoro, tavuya fusari, Evetu Genembo da Koro+ nunda aneya dirigari endada vose foa, iji vitarikena a vosarikena, kotugo foriforimanakena a yavatakena, aminda yama, nunda natofo gategusira ava unumbe budo yarera,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Aminge sise, Iesu sisira, “Ika kayuyu da ijugaboro ava kasama evu! Ika amo tuturo edo, tunó seka yaughururari gareva amo, ne kasama areva, ‘Borija da sifo buvira ava sedo, beká jighari da sifo utua erira.’ ");
INSERT INTO kpr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kau daba aminga ava, roera setena ava sirorurari gareva amo, ne kasama areva, ‘Sifo utua iri, tuturo ari dae erira.’ ");
INSERT INTO kpr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Geka evia kotovo dae sise resena! Roera setena ava sirorurari, evetu genembo oroko siroredo endada irera, mendeni garera. Mendeni ambarera, avata mendeni jo ambae iroro sirorari garera. ");
INSERT INTO kpr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Utu a enda dadabarira avata, nanda geka jo dadabae arira, evovodae irarira.” ");
INSERT INTO kpr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Aminge sise, Iesu sisira, “Avata Evetu Genembo da Koro+, nanjigo jovereghe furarira ainda Sifo amo, mave jo kasama aeri. Aneya ne jo kasama aeri, a God da Mandi barago, nu jo kasama aeri. God Afa nusukako kasama erira. ");
INSERT INTO kpr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kau evetu genembo Noah da sifoda edo ghusera aminga ava, evetu genembo amboda kotae kotae ururoro, Evetu Genembo da Koro+ jovereghe furarira. ");
INSERT INTO kpr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Usegha a gisi jo furae iriri ainda gitida mo, umo gamo use, kirumo use, evetu fifitero a vai ero, Noah nunda ghakada+ vivitusira. ");
INSERT INTO kpr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Vitiri, rea sirorarira ava, ne bunari gido kotae kotae ero, usegha a gisi fira buvudo gaunghetiri mindi sirivo useri. Evetu genembo kau daba aminga ava ururoro, Evetu Genembo da Koro+ jovereghe furarira. ");
INSERT INTO kpr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Furarira da sifo aminda, genembo eni nunda komanaghae vareda saramana ururoro, foama eni ruruse eni doyarera. ");
INSERT INTO kpr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Evetu eni nunda komanaghae farava jasiroro, foama eni ruruse eni doyarera. ");
INSERT INTO kpr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ava sedo, kaifa use gigitevu! Ainda susu mo: nenda Bajari sifo reda furarira ava, ne erebuneva. ");
INSERT INTO kpr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Avata geka evia kasama areva. Ainda sifo kau emingori. Kambo numamo, tafasara kato foa buvari da sifo ava ningi kasama aetira amo, nu diti fangedo kaifa aeti, jo doyari foa nunda Kambo+ bejae aeti. ");
INSERT INTO kpr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ne aindae sedo, nandae tefode numonde kaifa esimbuguse irivu! Ainda susu mo: Evetu Genembo da Koro+ jovereghe furarira da sifoá, ne bunise irovo jovereghe furarira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Saramana kato dubo koteraira, a saramana e gogoghomberaira amo, kau emingori. Saramana kato amo saramana e gogoghombeari gido, nunda bajari seari saramana kato amo viti bajari da duruda fetedo, saramana kakato mendeninde, nenda saramana gategedo, nenda bayau soro edo, kambo a roera isambu kaifa urureari, bajariá ya deingheraira. ");
INSERT INTO kpr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kaifa e gogoghombururari nunda bajari jovereghe furarira amo, saramana katoá aindae ivuga beká ava arira. ");
INSERT INTO kpr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na eminge resena: bajariá nunda kambo a nunda roera isambu saramana kato aikena mutari, evovodae kaifa edo gharira. ");
INSERT INTO kpr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","O saramana kato nu genembo eko iraetira amo, nu eminge kotaeti, ‘Nanda bajari jo totoi furae, ghousa futo irarira, tano.’ ");
INSERT INTO kpr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nu aminge kotedo tuturo edo, nunda bajari da saramana kakato mendeni ava, soesa ondi dedo, nu uvu fakara ainda oduso kakato mendeninde dabade anumbedo, uvu amo mindido ghaeteri. ");
INSERT INTO kpr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aminguse, nunda bajari da furari sifo ava kotae edo irari, nunda bajari amo foa buvarira. ");
INSERT INTO kpr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Buvudo gido, saramana kato amo, dedo dive gafari ambarira. Gungubo kakatokena eraera, avavaga numokena ari ambarira. Gungubo kakatode dabade sorara use, dika ghininji ghananja ghuse irarera,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Aminge sise, Iesu sekago sisira, “Sifo aminda, evetu genembo nange God da vasa evevada teroro ne kaifa arira, ainda kasia eni sari dae erena. Amo eviri. Genembo eni nu evetu fifituse, kirumo ari dae sedo aira. Iri, ade jamena ghabu sovenisoveni aimi nenda nanefa budo, genemboá unumbe bu furari dae sedo aera. ");
INSERT INTO kpr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ade jamena ghabu soveni mo, nenda munju kikitakori. A ghabu soveni mo, nenda munju evevagori. ");
INSERT INTO kpr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Munju kikitako amo, ne nanefa da uvu jo teria baeri. ");
INSERT INTO kpr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","O munju evevago amo, ne uvu botoro eni budo aera. ");
INSERT INTO kpr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aera, emboro soroda fete kaifa eteri. Avata genemboá jo totoi furae etira. Etiri, ne diti bainghetiri fafasedo averi. ");
INSERT INTO kpr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Tumba soroda, ‘Fuvu! Genembo evirere, tambove!’ kori aminge siri ningido, ");
INSERT INTO kpr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ade jamena diti fange eredo, nanefa da vuiki (wick) jighero vitira. ");
INSERT INTO kpr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Vitiri, munju kikitako amo, ne eredo nenda kokomanakena seteri, ‘Nenda uvu itako namane sonembevu!’ ne aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ade jamena munju eveva amo, ne seteri, ‘Tefo. Emo jo namonde dabade baoro inono ae arira. Ne yasivu, bisnis (business) embokena seka ombove!’ ne aminge seteri. ");
INSERT INTO kpr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Setero, ade jamena munju kikitako amo, ne uvu ombari dae sedo ero, genemboá ojighira buvira. Buviri, ade jamena uvu budo aera amo, ne eredo genembo ainde dabade kirumo ari dae aera, kamboda teretero guro gajetira. ");
INSERT INTO kpr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Guro gajetiri ainda amboda, ade jamena mendeni amo ojera buvudo, ajagha fetedo kori seteri, ‘Bajari, Bajari, guro afige, namane terore!’ aminge seteri. ");
INSERT INTO kpr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Setero, nu nemokena setira, ‘Geka bekári: ne mavejori, na erebunena,’ genemboá aminge setiri dadabetira.” ");
INSERT INTO kpr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Iesu aminge sedo, tano ari dae use eminge sisira, “Kaifa use irivu! Ainda beká mo: Evetu Genembo da Koro+ sifo nanjigo jovereghe furarira ava, ne bunariri,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Aminge sise, Iesu sisira, “Setena, daba ava sari dae erena. Sifo amo kau emingori. Genembo eni esa yari dae kotetira. Kotise, aghi etiri nunda saramana kakato totorugetero, nunda gugua a moni+ nene kaifa aoro dae sedo, mutiri beri. ");
INSERT INTO kpr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Amo, nenda irari kau mavegoá, a nenda munju kau mavega ava gi kasama edo, nunda roera ghasetiri beri. Eni K30,000 bira, eni K12,000 bira, a eni K6,000 bira. Mutiri bero, genemboá javi edo aira. ");
INSERT INTO kpr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Iri, saramana kato K30,000 bira amo, nu eredo aira, aimi bisnis (business) a oriro use sekago K30,000 bira. ");
INSERT INTO kpr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Saramana kato K12,000 bira amo, nu kau daba ava use, aimi saramana use sekago K12,000 bira. ");
INSERT INTO kpr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Avata, nenda komana eni K6,000 bira amo, nu eredo aira bako ghambudo, nunda bajari da moni+ aminda fiti fatira. ");
INSERT INTO kpr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Sifo ghousa ambari ava dadabetiri ainda amboda, bajari jovereghe ojira. Ojira setiri, nunda saramana kakato etodaba naká ojera buvero, nunda moni+ futusira aimi rea usera, aindae ategi etira. ");
INSERT INTO kpr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Saramana kato K30,000 bira amo, aira teredo, K30,000 etiri sirorusira ava, futuse setira, ‘Ninda K30,000 futusesa amo, eviri. Kotugo K30,000 emo, nane saramana eteno siroretira.’ ");
INSERT INTO kpr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Aminge setiri ningido, nunda bajari numokena setira, ‘Aiyakoe beká resena! Ni e gogoghombetesi. Ni saramana kato evevagori. Nanda roera jo digari iraeko mutena ava, nangedo eteso digetiri besi. Ava sedo, oroko nanda roera digari ava mutono, nine kaifa aresa. Fu, nangae dabade ivuga aore!’ aminge setira. ");
INSERT INTO kpr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Kotugo setiri, saramana kato K12,000 bira amo, aira teredo setira, ‘Ninda K12,000 futusesa amo, eviri. Kotugo K12,000 emo, nane saramana eteno siroretira.’ ");
INSERT INTO kpr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Aminge setiri ningido, nunda bajari numokena setira, ‘Aiyakoe beká resena! Ni e gogoghombetesi. Ni saramana kato evevagori. Nanda gugua jo digari iraeko mutena ava, nangedo eteso digetiri besi! Ava sedo, oroko nanda roera digari ava mutono, nine kaifa aresa. Fu, nangae dabade ivuga aore!’ aminge setira. ");
INSERT INTO kpr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kotugo setiri, nenda komana K6,000 bira amo, aira teredo setira, ‘Bajari, na kasama erena, ni genembo fakaragori. Evetu genembo mendeni roera goveoro, ainda vuji nine ya bamburaesa. A evetu genembo mendeni roera veka goveoro, ainda beká nine ya buraesa. ");
INSERT INTO kpr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Na aindae oju edo, ninda moni+ budo ena endada ghambu fiti fateni. Gi! Ninda moni mutesa amo, evirere,’ aminge setira. ");
INSERT INTO kpr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Setiri, saramana kato ainda bajari eredo setira, ‘Ni saramana kato ekori! Ni imboe kato, guka dagaya bekári! Ninda kotari mo: evetu genembo mendeni roera govoro, ainda vuji ava nane ya bambariri, a evetu genembo mendeni roera veka govoro, ainda beká ava nane ya bambari ava, koteraesa. ");
INSERT INTO kpr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ava sedo, ni nange nanda moni evia bu ya banikada (bank) fitaso, aminda irari saramana ururoro, ainda baako sirorari, na jovereghe foa bae eteni!’ aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","nu jovereghedo nunda mendenikena setira, ‘Ne moni numokena saghimbe budo, genembo eni K25,000 rurusira, aikena mutuvu bare! ");
INSERT INTO kpr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ainda beká mo: mavekena rea irarira amo, mendeni mutoro, nune bari inono beká ava arira. O mavekena tefo beká, o itako irarira amo, ábarago saghimbe baoro, nu makasi beká ava arira. ");
INSERT INTO kpr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Avori, genembo guka dagayaó sandi bu yasivu, fugovo ajagha ya tumbada irise, aminda sorara use dika ghininji ghananja ghuse irare!’ saramana kakato da bajari aminge sedo tano etira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Aminge sise, Iesu sisira, “Evetu Genembo da Koro+ kini (king) arira ainda sifoda, nu nunda aneya isambude dabade foama, nunda avo anumba usasago aminda viti anumbarira. ");
INSERT INTO kpr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Anumbirari, saoro enda da natofo a evetu genembo isambu foa, nunda dombuda totorugarera. Totorugaoro, kini tuturo edo, eveva gatege budo nunda ungo gimanduda fitarira, a ekokoá nunda ungo umbefukena fitarira. Kau sifi (sheep) kaifa kato, nunda sifi gatege ruruse gouti (goats) doyeraira, aminga ava arira. ");
INSERT INTO kpr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Evetu genembo eveva amo, gatege budo nunda ungo gimandukena fifituse, ekoko amo nunda ungo umbefukena doyarira. ");
INSERT INTO kpr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Amingedo, kini, evetu genembo ungo gimandukena fetarera aikena sarira, ‘Fuvu, God Afa utu a enda use, vasa eveva nendae sise esimbugusira, aminda yaovo, ne esimbugedo kaifa ari dae resira. Fuvu, ya aminda terove! ");
INSERT INTO kpr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na uvu bayaudae ighoi itatameno, mutevo ruruseni. Na jo nenda tofo iraeri. Avata feno gido, joka etiri na bu kaifa usevu. ");
INSERT INTO kpr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na embo boka tefo ireno, mutevo na tamo gagara useni. Na kae bu fasireno, ne feva uvu ika sonembedo futusevu. Na diburada fitero teredo ireno, ne feva buvevo, na nenda dombu gido, ghamo aseguseni,’ kini (king) aminge sarira. ");
INSERT INTO kpr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Sari dadabari gido, evetu genembo eveva aimi eminge sarera, ‘Bajari, nange resesi? Ni nanjigo ighoi itatameso, namane gido uvu bayau futuseri? ");
INSERT INTO kpr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","O ni nanjigo teana embo da kaugo edo fesa buveso, namane gido ni bu kaifa useri? O ni nanjigo embo boka tefo ireso, namane gido sonembuse futuseri? ");
INSERT INTO kpr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","O ni nanjigo kae bu fasireso, namane gido uvu ika budo era sonembuseri? O, ni nanjigo diburada ireso gido, namane era buvero, ni namanenda dombu gido dubo jama usesi?’ aminge sarera. ");
INSERT INTO kpr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Aminge saoro, kini (king) sekago nemokena sarira, ‘Sonemba evia nanda nano namendi, foivo batekena edo ghuseva amo, ne namokena edo ghusevu,’ kini nu aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","evetu genembo ekoko ungo umbefukena fetarera aikena eminge sarira, ‘God Satan nunda aneyade dabade ya terore dae sedo, vasa eninda avaraka simbugusira. Nembarago vasa daba aminda ya terovo dae resena. Ava sedo, yasivu terove! ");
INSERT INTO kpr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na uvu bayaudae ighoi itatameno, ne na jo sonembuse mutae usevu. ");
INSERT INTO kpr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na teana embo da kaugo edo fena buveno, ne na jo bu kaifa ae usevu. Na embo boka tefo ireno tambudo, na jo sonembedo mutae usevu. Na kae bu fasireno, ne uvu ika jo sonembedo mutae usevu, a na diburada ireno, ne jo furovo na nenda dombu gido ghamo asegae useni,’ ");
INSERT INTO kpr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","kini nu aminge sari dadabari, ne mino numokena sarera, ‘Bajari, nange resesi? Ni vasa reda ighoi itatameso, namane ni gido jo sonembae useri? Ni nanjigo feso gido, namane ni jo sonembae useri? Ni nanjigo embo boka tefo ireso o kae budo fasireso o diburada ireso, namane jo joka edo ni sonembae useri? Se ningore!’ aminge sarera. ");
INSERT INTO kpr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Aminge saoro, kini sekago nemokena sarira, ‘Nanda nano namendi, foivo bate da mema a dubo mema gido, jo joka edo sonembae edo ghuseva, amo namokena edo ghusevu,’ kini nu aminge sari dadabari, ");
INSERT INTO kpr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","nu evetu genembo amo dirigari yama, vasa eninda mema evovodae itatamuse irarera. O evetu genembo eveva amo, ne vasa eninda yama jebuga evovodae irari ainda vasada buvudo, dubo jamaghae evovodae irarera,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu aminge ijugetiri dadabetiri, nu namanekena sisira, ");
INSERT INTO kpr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Sifo etoto dadabari ainda amboda, namonde Jusi embo da kirumo javo Jarige Yari da Kirumo+, ava foa buvarira. Sifo aminda, evetu genembo mendeni, ne Evetu Genembo da Koro+ sandido daoro ambare dae sedo, gitofukena mutarera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sifo daba aminda, fristi+ da kokotofu a Jusi embo da babojegari era, fristi+ da giti jighari javo Caiaphas da kamboda totoruguseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Totorugedo, Iesu ufena sandi daoro ambare dae sedo, manaka garuse ");
INSERT INTO kpr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","eminge siseri, “Namonde Jarige Yari da Kirumo+ da sifo aminda, jo ae arera. Ainda tuka mo: amingarera amo, natofo tomanako kirumodae totorugarera aimi, ne janje eko edo titigho arera tanojo,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu nu ira reighi javo Bethany aminda buvudo, genembo javo Simon Refero aikena ");
INSERT INTO kpr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","iriri, evetu eni usu da muka aimi budo fira, Iesu kena teterusira. Botoro ghamana arabasta aimi usera, ainda jokáda usu ava vendero iriri budo fusira. Usu muka resena emo, munonderi, a nunda minó mo teria bekári. Ava bu fira teredo, Iesu bayau riri, usuimi nunda jiroda averegusira. ");
INSERT INTO kpr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Averegetiri dadabetiri gido, namanenda mendeni janje eko useri. Edo siseri, “Omo nange edo soesa averegetiri dadabeti? ");
INSERT INTO kpr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Omo budo oriro aetera amo, ainda moni digarigo sirorari budo makasi embokena ghasaeteri,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Avata namane aminge sero, Iesu itatamedo namanekena sisira, “Redae evetué dombuda resevu? Nu namokena veka eveva etira. ");
INSERT INTO kpr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Eregoseva: makasi embo ne sifo ghousa, nemonde dabade irá gheraeva; ava sedo, nemo sonembari sareva amo, sonembuse irá ghareva. O namo, jo namonde dabade sifo ghousa irae arera. ");
INSERT INTO kpr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Averegetira emo, nanda tamo simbugedo namo bu furugarera aindae sedo, etira. ");
INSERT INTO kpr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na geka beká resena. Ningivu! Nanda Bino Eveva reda ya buvari ningarera amo, evetué rea namokena etira ava, erá kotae eore dae sedo, vironu sise, nunda bino evia sise irarera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ainda amboda, namane 12 namanenda jokáda, genembo eni Keriot embo javo Judas aimi eredo, fristi+ da kokotofukena ira, ");
INSERT INTO kpr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","eminge sisira, “Na Iesu nenda ungoda fitarena amo, ne rejoá nandae mutarevu?” aminge setiri, ne moni+ babai 30, inono K1,200 avavaga tegedo, numokena futuseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mutero budo, Judas tuturo edo, Iesu nange ufena budo nenda ungoda fitaetira, ainda emboro ava kakova usira. ");
INSERT INTO kpr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yisti Kanangara Ari da Kirumo+ ainda sifo kakara tuturo iri, sifo daba aminda, namane Iesu kena era ategi useri, “Namane Jarige Yari da Kirumo+ reda esimbugaoro dae uju eresi?” ");
INSERT INTO kpr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aminge setero, nu sisira, “Jerusalem aminda yasivu! Genembo eni aminda irirare. Numokena yasivu eminge saove, ‘Ijuga kato eminge setira, “Nanda sifo buvira. Ava sedo, nanda ambo jimbide ninda kamboda Jarige Yari da Kirumo+ ava dabade mindarera,” ’” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Setiri, namane eredo era, Iesu rea sisira amo, isagha etiri Jarige Yari da Kirumo+ simbuguseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Simbugetero dadabetiri ungobu iri, namane 12 a Iesu de dabade bayau mindari dae sedo, era anumbuseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Anumbedo, bayau rise ainda jokáda, Iesu eminge sisira, “Na nemokena geka beká sari dae erena. Namonde anumbirera einda jokáda, genembo eniimi, namoá gitofukena aito arira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Setiri, namane dudukughedo dubo mema use, tuturo edo daba daba numokena ategi useri, “Bajari, ni mavedae resesi? Se ningore! Ni namokena resesa, ai?” namane isambu aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Setero, Iesu mino sisira, “Genembo mave nangae ungo dabade, bayau sukada fati bu rerera, amo numori. ");
INSERT INTO kpr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","God da Geka jokáda rea gembero irira, amo eviri: ‘Evetu Genembo da Koro+ ambarira,’ aminge gefuseri. A aminge sirorarira. Avata, genembo mave nu aito ari ambarira amo, nu mema a bouvu teriago beká ava barira. Eveva mo, nu jo sirorae aeti!” ");
INSERT INTO kpr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iesu aminge setiri dadabetiri, genembo mave amboda Iesu aito usira aimi eredo, Iesu kena ategi usira. Amo, na Judas dae resena. Avori, Judas nu eredo ategi usira, “Ijuga Kato, ni mavejodae resesi? Nandae resesa, ai?” aminge setiri, Iesu mino numokena sisira, “Resesa, avori!” ");
INSERT INTO kpr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Setiri dadabetiri, ne bayau rise, Iesu nu farava budo, God Afakena ‘aiyakoe’ sedo, esimbugedo jighi embebegedo, namanekena futusira. Futuse sisira, “Emo nanda tamori. Bu mindivu!” aminge sedo ");
INSERT INTO kpr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ainda amboda, nu agha bu jighiri eretiri, God kena ‘aiyakoe’ sedo, namanekena futuse sisira, “Ne isambu mindivu! ");
INSERT INTO kpr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Emo nanda ororori. Nanda ororoimi, God nu, numokena ya buvari da emboro+ seka, afigari dae erira. Evetu genembo digari da jebugadae sedo, nanda ororo averegaono vosedo emboro+ afigari, God nenda ari ekoko kote doyarira. ");
INSERT INTO kpr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na nemokena resena: na vaini (wine) jo mindae irono, Afa sari ne nunda vasa eveva aminda ya terovo, namonde dabade anumbedo, na vaini sekago aminda mindarena,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iesu aminge setiri dadabetiri, namane eredo yaru eni divudo, kambo dodo enda jiro fumbari javo Orivi, aminda iseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Aminda ise, Iesu namanekena sisira, “Tumba erejirira einda jokáda, ne isambu na dodo sumbareva. God da Geka jokáda rea aindae sedo gembero irira amo eviri: ‘God sifi (sheep) kaifa katoá dari ambari gido, sifi sarigedo nunda nunda sumbarera,’ God da Geka aminge resira. ");
INSERT INTO kpr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Avata kotugo, God sari na ambarida ghe jebugedo erarena ainda amboda, na ya Frovensi Galilee aminda buvuruturono, ne amboda furareva,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Setiri, Peter numokena sisira, “Bajari, ninda mendeni ni ighagha edo doyarera, tanojo. Avata namo, ni itako jo doyae arena.” ");
INSERT INTO kpr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Peter aminge setiri, Iesu numokena sisira, “Na nimokena geka beká resena. Sifode, kokora sifo jo karigae irari, ni na umbu etodaba naká ighagha aresa.” ");
INSERT INTO kpr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Aminge setiri, Peter numokena sisira, “Na ni jo ighagha ae beká arena. Na nangae dabade ambarera amo, avori,” Peter aminge sisira. Kotugo namane isambu geka daba ava siseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ainda amboda, Iesu namane namonde dabade era, reighi javo Getsemani aminda buvudo, nu namanekena sisira, “Ne eminda anumbirovo, na ya ominda banungarena,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aminge sedo, nu Peter a Zebedee da vide jamena etoto naká ava budo, nemonde era fetedo, Iesu nu dubo mema ambarako usira. ");
INSERT INTO kpr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Etiri, nemokena sisira, “Nanda dubo jokáda, bouvu mindafu beká ava erefufena. Fufuse, na ambududurerena. Ne diti fakara edo, eminda fetedo namo kaifa ururuvu!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aminge sedo, ne dodo itako ira, dombui du fasedo banunguse sisira, “Arie, nanda Afa! Emboro eni tambaetesa amo, mema oroko namokena refira evia, saso darigaeti! Avata, na jo nanda uju ava ari dae sae erena. Ninda uju ava arena!” ");
INSERT INTO kpr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aminge sedo, nu ere jovereghedo namanenda mendeni etodaba naká, Peter, James, a John kena ira buvudo, ne fafase avéro tambudo, Peter kena eminge sisira, “Fasireva, ai raveva? Ne redae sifo tufako jo diti fakara edo, na itako kaifa aeri? ");
INSERT INTO kpr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Erá Satan foa nemo dereuri ari eko eove dae sise, diti fakara edo banungevu! Nenda uju a kotari namokenari. Avata nenda tamo imboe edo, diti bouvu etiri, ne fakina jo ae ereva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aminge sedo, nu jovereghe ira banunguse sisira, “Arie, nanda Afa! Emboro eni jo inono ae aetira amo, na, emboro simbugusesa aminda ise, ninda uju ava use ambarena. Ninda uju ava sirorare!” aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","jovereghedo ira buvudo, ne sekago diti bainghetiri fafasedo avéro tafusira. ");
INSERT INTO kpr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ava gido, nu sekago jovereghe ira, kau daba aminga ava sekago banungetiri dadabusira. ");
INSERT INTO kpr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dadabetiri, ira Peter, James, a John kena sisira, “Ne ravava amo, nangetiraimi kotugo sekago fase ravevu? Givu! Sifo buvira! Oroko Evetu Genembo da Koro+ ari ekoko embo da ungoda fitarira. ");
INSERT INTO kpr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Erevu namonde ya gaore! Givu! Genembo namo aito erira amo, evia buvirere!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu aminge siri, namanenda eni javo Judas, fira buvurutusira. Fristi+ da kokotofu a Jusi embo da babojegari, ne evetu genembo mendeni dirigetero, kaiya a gandigha ava budo, Judas de dabade fera buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Giti ne jo javi edo furae irise, gitofu Iesu kau nange kasama aetera aindae, Judas nu eminge sisira, “Sandi muno arena amo, numora avori. Ururono aminda kasama edo, nu sandareva!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas gitofude dabade fera buvudo, Judas dambu Iesu kena ira sisira, “Ijuga Kato, iresa,” aminge sedo, Iesu sandi muno usira. ");
INSERT INTO kpr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Etiri, Iesu numokena sisira, “Nanda komana, ni rea eresa amo, totoi e!” aminge setiri, gitofu fera Iesu sanduduseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sandudero, namanenda eni ungoimi nunda kaiya budo jighiri eretiri, fristi+ da giti jighari ainda saramana kato da dengoro ava, kaiyaimi je gafugetiri dudurusira. ");
INSERT INTO kpr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Etiri, Iesu numokena sisira, “Erá amingeose! Ninda kaiya voruda vendi! Ai resira amo: isoro kakato ne, isoro udo ya sirivo arera. ");
INSERT INTO kpr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ne kasama aetevu: nanda Afa sonembare dae sedo benunu sarena amo, nu aneya 70,000 avavaga mutari foama na sonembarera. ");
INSERT INTO kpr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Avata na amingaetena amo, God da Geka rea resira, ainda beká jo sirorae aeti. Ava sedo dovu na sandore!” Iesu aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","jovereghe gitofukena eminge sisira, “Ne redae kaiya a gandigha budo, namo sandari dae sedo refevu? Na jo tafasara kato iraeri. Na namonde sifo ghousa God da Kamboda+ ijugedo ghusena amo, ne nangusirai na aminda jo sandae edo ghusevu? ");
INSERT INTO kpr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Avata ne emingereva da beká mo: God da Geka rea resira, ava beká are dae sedo, nene etevo sirorerira,” Iesu aminge sisira. Aminge setiri ningido, namane isambu oju edo, nu do sufuseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Natofo Iesu sandudusera amo, budo era, fristi+ da giti jighari javo Caiaphas, ainda kamboda buvurutuseri. Moses da Geka ijuga kakato+ a Jusi embo da babojegari totorugedo irero, Iesu bu teteruseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","O Peter mo, nu itako ambokena fetiriri, Iesu budo ero, nu amboda amboda udo ira, fristi+ da giti jighari javo Caiaphas, nunda kambo da furu aminda teredo, ofotighida buvudo fefetusira. Fetedo, ne Iesu kena rea arera ava, itatame gari dae sedo, Peter isoro kakato mendeni ainde dabade anumbusira. ");
INSERT INTO kpr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","60","Avori, fristi+ da kokotofu a kaniseremane isambu aminda totorugusera aimi, Iesu daoro ambare dae sedo, susu kakova useri. Susu tambari dae sedo, setero evetu genembo mendeni fera teredo, Iesu dae aji siseri. Ne gungubo teria futo siseri. Avata numo saoro ambari da susu eni jo tambaeri. Ainda amboda, gegenembo etoto ere fetedo, ");
INSERT INTO kpr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","eminge siseri, “Genembo emo, nu eminge sisira, ‘God da Kambo+ nane jighi bejedo, sifo etodaba naká ainda jokáda sekago itono fetarira. Amingari mo, namokena inonori,’” etoto nakái aminge setero ningido, ");
INSERT INTO kpr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","fristi+ da giti jighari eredo, Iesu kena ategi usira, “Geka setera aindae, ni reju eni saresa? Evetu genembo resera emo, geka bekári?” ");
INSERT INTO kpr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aminge sisira, avata Iesu nu geka reju eni jo saeri. Etiri, fristi+ da giti jighari sekago Iesu kena sisira, “God irira, ainda javoda resena. Ni mino se ningore! God evetu genembo da ari ekoko kote doyari dae sedo, nunda Mandi mutari sisira amo, nimori, ai? O, jo nimo iraeri? Se ningore!” ");
INSERT INTO kpr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nu aminge setiri, Iesu mino numokena sisira, “Resesa, avori. Kotugo nemokena resena: amboda ne, Evetu Genembo da Koro+, God Fakina Kato ainda ungo gimandukena anumbirari gareva, a kotugo utu da foroga etoda fetedo vose fururari gareva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Setiri ningido, fristi+ da giti jighari janje eko etiri, nunda tamo asugari ava jighi ijejegusira. Aminguse, sisira, “Nu aminge siri, God da javo eko erira. Geka eni redae ningareri? Nunda ari eko ava, tofo siri niningerevere! ");
INSERT INTO kpr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ava ne nange erekotevu?” aminge sisira. Setiri, ne siseri, “Geka evia siri ningera aindae sedo, nu daoro ambarira,” aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ne tuturo edo nunda dombuda kosiva useri, a nunda sovoda ungo joghai megha useri. ");
INSERT INTO kpr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Aminguse, nu dere jise eminge siseri, “Ni God dirigari furariá seraesa. Ava sedo, javo se, namane ningore! Ni mave eredori?” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peter nu kambo ofotighida kaifa use anumbiriri, gagara saramana kato eniimi fira Peter kena sisira, “Ni, Galilee embo genembo javo Iesu sedo ghusera, ainde dabade deinghedo ghusesi. Amo nimori,” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peter natofo isambu da dombuda ighagha use sisira, “Ni geka resesa amo, na bunariri,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aminge sedo, nu eredo ira, emboro békada fefetusira. Aminda fetiriri, gagara saramana kato enii fira numoá gido, kau daba ava, gegenembo aminda fetirisera aikena sisira, “Genembo emo, Nasareth embo Iesu de dabade deinghedo ghusira,” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peter sekago ighagha use kovionoghae sisira, “God da dombuda nemokena resena. Genembo reseva amo, na bunari bekári,” ");
INSERT INTO kpr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aminge setiri, itako fetedo ainda amboda, genembo eni aminda fetirisira aimi eredo fira buvudo, Peter kena sisira, “Geka bekári. Nunda eni nimori. Ainda beká mo: ni Galilee embo da geka duka ava seso ningido, na kasama erena, ni taká Galilee embori,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Setiri, Peter God da javoda, beka gagojuse sisira, “Na gungubo sarena amo, God na darira. Genembo reseva amo, na bunari bekári!” Peter aminge siri, kokora sifo karigusira. ");
INSERT INTO kpr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Karigiri, Iesu rea numokena sisira ava, Peter kotisira. Iesu sisira amo, eviri: “Kokora sifo jo karigae irari, ni na umbu etodaba naká ighagha aresa,” Iesu rea numokena sisira ava kotise, Peter buvudo ira isaghada fetedo, sorara janjagughae usira. ");
INSERT INTO kpr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sifo atetiri, fristi+ da kokotofu a namonde Jusi embo da babojegari, Iesu daoro ambare dae sedo manaka garuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Amingedo, ne Iesu seiniimi (chain) bundedo budo era, Rome embo da kotofu javo Pilate, Frovensi Judia kaifa edo ghusira ainda ungoda fifituseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iesu daoro ambare dae sero ningido, Judas Iesu aito usira aimi dubo jovereghetiri, moni+ babai 30 futusera ava budo, sekago fristi+ da kokotofu a Jusi embo da babojegarikena ira futusira. ");
INSERT INTO kpr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Futuse, sisira, “Na dara embori! Genembo aito use nenda ungoda fiteno, daovo ambare dae ereva omo, genembo evevagori,” aminge sisira. Setiri, ne numokena siseri, “A jo namanekena sae aresa. A tofo ninda darari.” ");
INSERT INTO kpr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aminge setero ningido, Judas moniá God da Kambo+ jokáda fuge dodo, nu buvudo ira, tofo mandi duboda ivasi edo ambududurusira. ");
INSERT INTO kpr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Fristi+ da kokotofu ne moni ava rete budo, dabade se nininguse siseri, “Emo aito da minori. Ava sedo, e budo God kena joba mutarera amo, namondeda Agho Dari bejarera,” aminge sise, manaka garuse eminguseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ne moni aimi, okia jighari kato eni ainda enda ava, ofofodae sedo ofuseri. Ne gitofu ambeoro gido, aminda furugedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aindae sedo, enda ofusera, ainda javo ‘Ororo’ jijighuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Amingero, God da feroveta Jeremiah rea sisira, ainda beká ava sirorusira. Nu eminge sisira: “Bajari namokena rea aono dae sisira ava, nene useri. Israel embo, ne genembodae moni 30 (kau K360 avavaga) mutari sisera, ava budo aimi, okia jighari kato aikena enda ofuseri.” God aminge setiri Jeremiah gefusira. ");
INSERT INTO kpr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iesu nu frovensi da kotofu javo Pilate, ainda dombuda fetetiri, Pilate Iesu kena ategi use sisira, “Se ningone! Geka bekári: ni Jusi embo da kiniri (king), ai tefo?” aminge setiri, Iesu numokena sisira, “Ava nine resesare,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Avata fristi+ da kokotofu a evetu genembo da babojegari nundae aji sise, geka ekoko mendeni mendeni sisera aindae, nu mino jo saeri. ");
INSERT INTO kpr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ava ningido, Pilate numokena ategi usira, “Ni dara a geka sembae sariá evetu genemboi sero niningeresa. Ava sedo, ni redae mino jo sae eresi?” Pilate aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Avata Iesu aindae mino eni itako jo saeri. Etiri gido, kotofuá nu dudukughedo bunisira. ");
INSERT INTO kpr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jarige Yari da Kirumo+ ainda sifoda, frovensi da kotofuá sifo ghousa emingedo ghusira. Dibura embo eni nenda uju ava, natofoi benunu seoro ningido, nu doyeari tefo foa buvudo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sifo aminda, genembo eni javo Iesu Barabbas, diburada irei. Genembo amo nu eko bekári, edo nu binonderi. ");
INSERT INTO kpr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Avori, Pilate nu genembo eni doyari ya buvaetira, ava kotise iriri, evetu genembo Iesu koto ari dae sedo totorugetero, nu nemokena ategi usira, “Genembo nenda uju ava sevu ningone! Mavejoá doyono buvu yari? Iesu Barabbas seraera, ai, Iesu Keriso seraera ava, sevu ningone!” ");
INSERT INTO kpr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilate nu aminge sisira da beká mo: nu kasama usira, ne Iesu sandi numokena budo fusera da susu mo, jo Iesu da ari ekodae bu furaeri. Amo, fristi+ da kokotofu a Jusi embo da babojegari ne, evetu genembo digari Iesu da geka ningido ghusera ava gido, dubo eko etiri, nu aindae sanduduseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilate nu, koto da vasada kaifa use anumbiriri, noaro geka eni gembu mutiri firi rurusira. Noaro eminge sisira, “Genembo javo Iesu, koto use iresa amo, genembo evevari. Nu doyaso yaeti. Ainda susu mo: tumbade aturuda na nundae sedo, dubo vevera tambeni,” noaro aminge gembudo sisira. ");
INSERT INTO kpr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Avata fristi+ da kokotofu a Jusi embo da babojegari, Iesu daoro ambududururari, Barabbas ava doyari foa buvare dae uju use setero, evetu genembo ne geka ava tumonduseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Etero, Pilate nemokena ategi usira, “Avori, sevu ningone! Na genembo ningiava saono buvu yari?” aminge setiri, ne, “Barabbas,” siseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Setero, Pilate ategi usira, “Atá, genembo eni javo Iesu, evetu genembo mendeni Keriso seraera emo, nange areni? Sevu ningone!” aminge setiri, ne isambu, “Arafa dege!” siseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Setero, Pilate sisira, “Atá, nunda dara rejuri? Sevu ningone!” setiri, ne tuturo edo koko sise fumbu aruguse, “Arafa dege!” siseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nunda geka sisira ava jo ningae, ne tuturo edo titigho ari da kau ava ero gido, Pilate setiri uvu budo fira buviri, evetu genembo da dombuda ijugaboro fifituse, nu ungo seghusira. Seghedo, sisira, “Dara einda dongono evia, segheteno vovoserirere. Nene setevo, genembo emo ambarira. Ainda bouvu, jo nane fumbae arena,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Aminge setiri, natofo isambu mino numokena siseri, “Genembo ava ambarira ainda mino mo, namane, a kotugo namanenda sasingu a imemesiriimi barera!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Setero, Pilate natofoda uju ava use, Barabbas dotiri buvurutusira. Etiri, Pilate setiri nunda isoro kakato mendeni Iesu ambíimi detero ainda amboda, nu Iesu budo arafa daore dae sedo, isoro kakato mendeni da ungoda fifitusira. ");
INSERT INTO kpr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilate da isoro kakato ne Iesu budo era, gavana da kamboda teredo aghi etero, nenda mendeni isambu totorugedo, nemonde Iesu jimbe birurughuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jimbe birurughedo, nunda tamo asugari ava isorogo jumbero kosughusira. Amingedo, ne embo unju tamo a ghousago ava bu fera asuguseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Asugedo, ne asi titifaghae bu kefu edo kini (king) da kekesa avavaga edo, nunda jiroda asuguseri. Edo, kotofu da ketua avavaga ari dae sedo, sebore ifu divege bu fera nunda ungoda fitero Iesu jighi fefetusira. Nu dere jise, kau kini tumonde baingheraera, avaga useri. Aminguse, ne sedo ghuseri, “Orokaiva! Jusi embo da kini buviro! Orokaiva!” ");
INSERT INTO kpr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aminge sise, kosiva use seboreimi nunda jiroda dedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Dere jirero dadabetiri, nenda embo Iesu kena asugusera ava kosughedo, tofo nunda ava bu fera numokena asuguseri. Amingedo, nu arafa dari dae sedo jumbudo iseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Reighi Jerusalem ghe buvudo ise, Sairin embo eni javo Simon ava tambudo, setero nu Iesu sonembedo nunda korosi fumbiri nemonde iseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Era, reighi javo Golgota, aminda buvurutuseri. Golgota resena einda tuka mo, namondeda gekaimi ‘Ambari Embo da Jiro Aghati da Vasa’ seraera. ");
INSERT INTO kpr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aminda buvudo, nu erá mema itatameure dae sedo, vaini (wine) budo fiyoghaghae baingoro edo mindare dae Iesu kena futuseri, avata nu itako dere gido dotutusira. ");
INSERT INTO kpr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Etiri, Iesu tautaimi arafa dedo, kikindoro garuse nunda tamo asugari ava soro edo ruruseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Etero dadabetiri, anumbirise numo kaifa useri. ");
INSERT INTO kpr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nu redae koto usira da susu ava ijugaoro kasama aoro dae sedo, ika sogho aminda gembudo Iesu da jiro agada detero takegha usira. Gefusera amo eviri: “Emo Jusi embo da Kini (King), javo Iesu ri.” aminge gefuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tafasara kakato etoto naká barago, budo era Iesu de dabade arafa doruseri, eni gimandukena, a eni umbefukena. ");
INSERT INTO kpr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Evetu genembo mendeni foa Iesu gi dariguse, dere jise gifua gitorotoro use eminge sedo ghuseri, ");
INSERT INTO kpr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ni erekotesa amo, ni God da Mandiri. A eni mo: ni God da Kambo+ jighi bejedo, sifo etodaba naká ainda jokáda sekago itaso fetare dae sisesi. Ava sedo, tofo sonembedo korosida ghe vose fete gaore!” ne aminge sedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kau daba aminga ava, fristi+ da kokotofu, Moses da Geka ijuga kakato+, a Jusi embo da babojegari, eminge dere jise sedo ghuseri, ");
INSERT INTO kpr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nu seari, evetu genembo mendeni jejebugedo ghuseri. Avata nu nangetirai, tofo sonembedo vosae eri? Nunda kotari mo: namonde Israel embo da kini (king) mo numori. Ava sedo, tofo sonembedo, korosida ghe vose fetarira amo, namonde gido nu tumondarera. ");
INSERT INTO kpr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nu God tumonduse, nu God da Mandiva seraira. Avori, namonde fete gaore! God foa nu sonembarira, ai tefo?” aminge sedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tafasara kakato Iesu de dabade arafa dorusera, nembarago Iesu dere jiseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Isonga 12 koroko iri, reighi isambu aminda tumba jido iriri ira, ungobu 3 koroko iri, reighi sekago usasa usira. ");
INSERT INTO kpr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ungobu 3 koroko iri, Iesu koko sise nunda gekaimi sisira, “Eli, Eli, lema sabatani?” Ainda tuka mo, namondeda gekaimi eminge saeteri: “Nanda God, nanda God, redae na dotesi?” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Evetu genembo mendeni aminda fetirisera aimi, sembae ningido eminge siseri, “Genembo emo, nu feroveta javo Elijah dae kori resira,” ava siseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Iesu aminge siri ainghae dabade, genembo eni sumbu viti fetedo, roera eni sofeya ava budo, faragho mendoda vakimbedo, vaini (wine) dokegha ainda jokáda fatiri sasaka etiri budo ira, Iesu mindare dae sedo, nunda békada fifitusira. ");
INSERT INTO kpr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Amingiri, mendeni siseri, “Namonde gaore! Elijah foa sonembarira, ai tefo?” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Setero, Iesu sekago beka mindafugo koko sise, ghamo asegari dotutusira. ");
INSERT INTO kpr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iesu amingiri, God da Kambo+ ainda jokáda, nunda vasa kakara ava, erá evetu genemboi tere gido ambeore dae sedo, embo teria eniimi gajetero ireira ava, soroda ijejege ikáda ghe vose fira duruda buvurutusira. Etiri, enda daradaraghiri, ghamana tofo bebejegusira. ");
INSERT INTO kpr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Amingiri, ofofo gomo mendeni totofo afifigusira. A God setiri, nunda natofo mendeni ofofoda ghe jebugedo eroruseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Eredo irero, Iesu ambarida ghe erorusira ainda amboda, ne era God da reighi kakara Jerusalem aminda teredo deinghero, evetu genembo mendeni ne gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Isoro kakato nenda giti jigharide dabade Iesu kaifa ero, enda daradaraghiri roera mendeni siroriri gido, oju use eminge siseri, “Geka bekári: emo God da Mandiri,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Iesu ambududuriri, evevetu mendeni ne esike fetirise gosuseri. Evevetu resena eimi, ne Galilee ghedo fera Iesu de dabade deinghuse nu sonembedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nenda jokáda, evevetu eviri: Magdara embo evetu eni javo Mary, Mary da nunombo, amo James nengae Joseph ghae da noi, a Zebedee noarori. ");
INSERT INTO kpr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ungobu iri, Arimatia embo genembo eni javo Joseph fira buvurutusira. Numbarago Iesu da ambo jimbi eniri. Genembo guguaderi. ");
INSERT INTO kpr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nu ira Pilate kena teredo, Iesu da tamo mutari bu ya furugari dae sedo benunu sisira. Setiri, Pilate Iesu da tamoá mutoro dae setiri, mutero Joseph rurusira. ");
INSERT INTO kpr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Budo, nu embo yokura foyago seka ava budo aimi doghedo, ");
INSERT INTO kpr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","nunda ofofo seka, ghamana toka basisera, aminda budo ira teredo fifitusira. Fitido, guro gajari dae sedo, ghamana mindafu ava afufetiri ira aimi, toka gajetiri dodo isira. ");
INSERT INTO kpr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Joseph nu amingiri, Magdara embo evetu javo Mary, nunda nunomboghae, aminda irise nene gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sifo atetiri, fristi+ da kokotofu a Moses da Geka kaifa kakato+ era Pilate kena totoruguseri. (Amo, Jarige Yari da Kirumodae+ simbugusera da sifoá dadabetiri, sifo atetiri Pilate kena totoruguseri.) ");
INSERT INTO kpr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Pilate kena totorugedo, siseri, “Kotofuko, genembo Iesu jebuga irise, gungubo sise eminge sedo ghusira, ‘Sifo etodaba naká ainda amboda, God sari na ambarida ghe jebugedo erarena,’ nu aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ava sedo, saso ninda isoro kakato mendeni ya, ofofo kaifa ururoro sifo etodaba naká dadabare! Amingaresa amo, nunda ambo jimbi jo yama, nunda tamo ufena bu ya jungedo eminge sae arera, ‘Givu! Nu erorusira; ava sedo, nunda tamo eminda tefori,’ ava jo sae arera. Amingaresa amo, evevari. Ainda beká mo: Iesu numo jebuge erari dae giti sisira amo, evetu genembo daba daba aimi tumonduseri. O nunda ambo jimbi ya nunda tamo ufena bu ya jungedo, nu jebuge erariá saetera amo, natofo digari ne geka bekáva sise tumondururoro, dara mindafu ava siroraeti.” ");
INSERT INTO kpr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Setero, Pilate sisira, “Avori, isoro kakato mendeni mutono bareva. Budo yasivu, ofofo kaifa e gogoghombevu!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Setiri, fristi+ da kokotofu a Moses da Geka kaifa kakato+ era, ofofo da guro ava gaje gogoghombuseri. Guro gagojuse, ainda békada gavana da tano fatero takegha usira. Etiri, setero, isoro kakato aminda kaifa ero, ne dodo iseri. ");
INSERT INTO kpr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Fura Tomanako sifo atutiri, Magdara embo evetu Mary, nunda nunomboghae ofofo gari dae sedo iseri. ");
INSERT INTO kpr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ero, Bajari da aneya eni anakora vose firi, dumo mindafugo eredo enda daradaragherirare. Iri, aneya guroá afige afufetiri, esike ira fasetiri, nu etoda viti anumbusira. ");
INSERT INTO kpr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nunda gari kau biria avavaga usira, a nunda tamo asugari foyago beká ava usira. ");
INSERT INTO kpr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Etiri, isoro kakato ava gido, oju beká ava use, ungo ata dadadaghuse du fafasedo, ambari da kakaugo ava useri. ");
INSERT INTO kpr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Etero, aneya amo evevetukena sisira, “Erá oju eove dae resena. Na kasama erena, ne Iesu arafa dorusera, ava kakova ereva. ");
INSERT INTO kpr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nu eminda tefori. Nu rea sisira ava, beká siroretira. Amo, God setiri nu ambarida ghe jebugedo eretira. Fuvu, nunda tamo reda fitero fasusira ava, ijugaono gaove! ");
INSERT INTO kpr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Oroko nembo totoi jovereghe yasivu, nunda ambo jimbikena eminge saove: ‘Nu ambarida ghe jebugedo eretira. Eredo, nu giti Frovensi Galilee aminda erira. Ava sedo, ne eredo nunda amboda yasivu, aminda tambove!’ aminge sevu, nunda ambo jimbi ningore! Avori, resena evia, erá kotae eove!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aneya aminge setiri ningido, ne jovereghe ofofo dodo bibitai ise, oju use a ivugaghae, namanekena osa sari dae sedo sufuseri. ");
INSERT INTO kpr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sufuse, Iesu emboro soroda tafuseri. Tambero, nu nemokena, “Refeva,” sisira. Setiri, ne era numokena buvudo, nunda atada sandi fafasuseri. Aminguse, nu tumonde bainghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Etero, Iesu nemokena sisira, “Erá oju eove! Yasivu, nanda nano namendi saovo Frovensi Galilee aminda yaore! Ne na ominda tambudo garera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Evevetu amo emboro soroda ero, isoro kakato ofofo kaifa edo ghusera aimi eredo, jovereghe era reighida teteruseri. Teredo, rea sirorusira ava, fristi+ da kokotofukena osa setero nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ningido, fristi+ da kokotofu ne eredo era Jusi embo da babojegari tambudo, nemonde dabade anumbedo manaka garuseri. Manaka garuse, eminguseri. Geka ava kivo aore dae sedo, ne isoro kakato aikena moni teriago futuseri, ");
INSERT INTO kpr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Futuse, siseri, “Mave ategi arira amo, eminge sevu, ‘Namane avéro, Iesu da ambo jimbi fera, nunda tamo ava ufena budo iseri,’ aminge sevu! ");
INSERT INTO kpr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","O frovensi da kotofu ainda bino ava ningarira amo, erá oju eove! Namane numokena saoro dubo jama edo, nemokena rejo eni jo ae arira,” ne aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Setero, isoro kakatoá ne minó ava budo, aminge sedo ghuseri. Seoro ningido, oroko Jusi embo geka beká ava bunise, kau daba aminga ava totofo se ningiraera. ");
INSERT INTO kpr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Iesu nu enda jiro fumbari eni gategedo, aminda yaoro dae sisira ava ningido, namane isambu 11 aimi aminda era, nu fetiriri gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Gido, namanenda mendeni manamana useri. Avata namane isambu nu tumonde bainghuseri. ");
INSERT INTO kpr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Etero, nu namanekena fira buvudo eminge sisira, “God Afa geka isambu a fakina isambu, namokena mutiri ruruseni, endada a utuda. ");
INSERT INTO kpr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ava sedo, ne eredo yasivu, natofo nunda oro oro isambukena vironu sirurovo ningido, ne nanda ambo jimbi aore! Aminguse, ne God, Afa, Mandi, a Asisi Kakara da javoda bafataito areva. ");
INSERT INTO kpr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na rea aovo dae sedo ghusena ava, ijugururovo natofo isambu ningido tumonduse amingaore! Amingururovo, na namonde dabade tatedo iroro, enda a sifo foa tano arira,” Iesu aminge sisira. Avori, nanda geka tano eviri. ");
INSERT INTO kpr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iesu Keriso, God da Mandi ainda Bino Eveva eminge tuturo usira. ");
INSERT INTO kpr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God da feroveta, javo Isaiah, nu anakora beká nunda buku jokáda geka evia gefusira: “Kote gi! Nanda aghi kato ava, giti dirigaono ya, ninda emboro rerebururari, ni amboda yaresa. ");
INSERT INTO kpr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Aghi kato amo, nu reighi uvu a evetu genembo irae da vasa aminda fetirise, beka fainghedo geka resira, ‘Bajari da emboro rerebevu dambu are!’” Isaiah aminge gefusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ava sedo, John Bafataito Ari Kato ira, reighi uvu a evetu genembo irae da vasa aminda buvudo, evetu genembo bafataito use eminge sedo ghusira, “Fuvu, eminda! Nenda ari ekoko vujegururovo bafataito aono, God nenda ari ekoko kote doyare!” John vironu aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aminge sirureari, evetu genembo isambu eredo, nenda frovensi Judia a nenda reighi Jerusalem ghedo, foa John kena totorugedo ghuseri. Totorugedo, nenda ari ekoko vujegeoro, John ne uvu Jordan aminda bafataito edo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John nu sino fuka javo kamero (camel), ainda anoso aimi firedo, asugedo ghusira. A nunda ifu dighari barago, kau daba ava edo, dighido ghusira. John nu aminda irise, sisi a finje ava, nunda bayaudae rise irá ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Avori, nu eminge vironu sedo ghusira, “Genembo eni nanda amboda refira amo, nu genembo teria bekári. Na jo numongo iraeri. Na taká sabua+ bekári. ");
INSERT INTO kpr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne tefo uvu vanemboimi bafataito eraena. O numo, ne Asisi Kakara aimi bafataito arira,” aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sifo aminda, Iesu nunda reighi Nasareth frovensi Galilee aminda ghedo fira, uvu Jordan aminda buvudo ira uvuda vose fetetiri, John nu bafataito usira. ");
INSERT INTO kpr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Etiri dadabetiri, Iesu uvuda ghe vivitiri ainghae dabade, John gosiri utu afigetiri, Asisi Kakara kau ribo avavaga jinendo, vose fira Iesu kena asugetiri gosusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Asugiri, beka utuda ghe isagha siri ne nininguseri, “Nimo nanda dubo bari Mandiri. Na, nindae ivuga use, aiyakoe beká resena!” ");
INSERT INTO kpr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Se dadabiri ainghae dabade, Asisi Kakara aimi Iesu unumbe budo, reighi uvu a evetu genembo irae da vasa aminda isira. ");
INSERT INTO kpr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ira, aminda sifo 40 ava iriri, Satan fira numokena buvudo nunda fakina ava dere gido ghusira. Iesu nu taima da sino fukade iriri, God da aneya mendeni fera numo kaifa use, sonembedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kini (King) Herod setiri, John Bafataito Ari Katoá sandi budo diburada fifitusera ainda amboda, Iesu ira Frovensi Galilee aminda teredo, tuturo edo God da Bino Eveva ava, vironu sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Vironu eminge sedo ghusira, “God sifo fifitusira ava ojira buvira! God evetu genembo kaifa ari da sifo utua etira. Nenda ari ekoko vujege dodo, God da Bino Eveva ava tumondevu!” aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Amingudo ira, Galilee uvu da teria ainda dengesida deinghusira. Aminda deinghudo ise, Simon nunda namendi Andrew ghae, voto voyuvaimi oka barero gosusira. Nemo oka bambari embori. ");
INSERT INTO kpr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Gido, nemokena sisira, “Nengae fuvu, namonde dabade irise, dengoro indono ningido, oka bamburaeva aminga ava, nengae ya evetu genembo unumbedo, God Afakena bu furove!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Siri ainghae dabade, nengae eredo nenda voto voyuva aminda dodo, nunda amboda iseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Era itako ambo soka use, Zebedee da sasingu etoto naká, James nengae John ghae, ghakada+ fetedo voto toka difero gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Gosuse ainghae dabade, Iesu nemokena kori setiri, nengae eredo numamo a nunda saramana kakatode ghaka+ aminda dodo, Iesu da amboda iseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu nunda natofode era, reighi eni javo Kaponiam aminda buvurutuseri. Buvudo, Jangutari da Sifo fira buviri gido, Iesu anakora ira dengoro indari da kamboda+ teredo, tuturo edo dengoro indudusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dengoro indudiri, natofo ava ningido dudukughuseri. Ainda beká mo: Moses da Geka ijuga kakato+ dengoro indido ghusera, a kau eniri. O Iesu dengoro indudusira amo, geka nunda fakinaghae dabade sisira. ");
INSERT INTO kpr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Genembo enikena, sukarui asugetiri ireira aimi, tere anumbedo, Iesu geka siri ningido, nu koko sisira, ");
INSERT INTO kpr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Agá Iesu, Nasareth embo, ni namanekena nange ari dae fumutasi? Ni saso namane sirivo aoro dae sedo fumutasi, ai? Namane ni kasama erera. Ni God da Genembo Kakarago Bekári,” sukaru genembokena asugusira aimi, aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Setiri, Iesu numokena kovionoghae sisira, “Beka dodo, genembo ainda jokáda ghe fu buvase!” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","sukaru irisira aimi eretiri, genembo ungo ata dadadaghiri koko teriago sise, vose dariguseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ava gido, evetu genembo isambu dudukughedo, minonde minonde se nininguseri, “Emo rejori? E geka seka siroretira! Nu fakina katori. Nunda fakinaghae seari, sukaru nunda geka ningido, evetu genembo da jokáda ghe foa buvuraera,” aminge se nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aminge sise irero, Iesu da bino ava reighi isambu frovensi Galilee aminda iri nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iesu nu setiri, sukaru genembo da jokáda ghe vose darigusira. Ari ovia usira ainda amboda, Iesu nu James John ghae, a nunda ambo jimbi mendeninde dabade, dengoro indari da kambo+ dodo era, Simon nengae Andrew ghae da kamboda teteruseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon da imboti nu kae tambudo tamo vevera iri, kambo aminda fasiriri, teteruseri. Teterero ainghae dabade, Iesu kena setero niningusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ningido, nu ira teredo sire nunda ungoda jighiri eroriri, tamo vevera darigiri jebugusira. Jebugedo, bayau simbugedo nemokena futusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Sifo daba aminda tumba jiriri, kae evetu genembo reighi aminda iriara ava, isambu budo fera Iesu kena buvurutuseri. Mendeni sukarui asugetero iriara, ainghae dabade budo fera buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kaponiam embo isasambu kambo dendeguda totorugedo guro békada fefetuseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Totorugetero, Iesu nu setiri kae evetu genembo digari jejebugetero, kae kau eni kau eniá isambu dadabusira. Kotugo, mendenikena sukarui asugetero iriara ava, nu setiri sukaru do vose dariguseri. Sukaru amo, ne Iesu mavejori, ava kasama useri. Ava sedo, Iesu kovionoghae bureguse, beka erá seore dae sisira. ");
INSERT INTO kpr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ainda tumba soroda, Iesu eredo kambo dodo reighida ghe buvudo, evetu genembo irae da vasa aminda ira banungusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Banungiri, Simon nunda mendeninde dabade eredo, numo tava udo era tafuseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tambudo siseri, “Evetu genembo isasambu eredo nimo tava use irera.” ");
INSERT INTO kpr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aminge sisera avata, Iesu nemokena sisira, “Namonde yaore! Na reighi mendeni einda dengesida ya vironu aminda barago sarena. Ainda beká mo: na vironu sari dae sedo fuseni. Ava sedo, namonde yarera!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Reighi isambu frovensi Galilee aminda birurughuse, dengoro indari kamboda+ teterudo ise vironu sedo ghusira. Ava seari, sukaru evetu genembo da tamonda ghe vose darigedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Genembo eni tamo bedode eko beká edo ireira aimi, Iesu kena fira kauboi dadarigedo benunu sisira, “Na kasama erena: ni uju aresa amo, na saso jebugarena.” ");
INSERT INTO kpr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Aminge setiri, Iesu genembo aindae joka edo, ungo siregedo nunda tamonda jijighuse sisira, “Ai, na uju erena. Jebugaresa!” ");
INSERT INTO kpr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aminge siri ainghae dabade, gambisi utetegetiri jebugusira. ");
INSERT INTO kpr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Etiri, Iesu nu diriguse, kovionoghae ");
INSERT INTO kpr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","eminge sisira, “Seteno jebugetesa emo, erá osa seose! Ere yasi, ninda tamo fristikena+ ijugaso gari, Moses da Geka aminda, rea God kena mutaso dae resira, ava mutaresa! Amingaresa amo, ni jebugetesa ava, evetu genembo isambu kasama arera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Avata genembo amo, nu jo amingaeri. Nu evetu genembo isambukena osa setiri, numo jebugusira da binó ava reighi isambu aminda ivegedo isira. Ava sedo, Iesu reighi bogu eninda jo isaghada ya terari da kaugo irae usira. Etiri, nu evetu genembo irae da vasa aminda ira iriri, reighi isambu ainda evetu genembo ya numokena buvudo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sifo nanjogoá dadabetiri, Iesu nu sekago jovereghe ira reighi Kaponiam buvurutusira. Ainda bino ava ivegedo isira. ");
INSERT INTO kpr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iri, evetu genembo digari ningi kasama edo, fera numokena totoruguseri. Totorugedo, natofoimi kambo bedo edo mambe kosegetero, mendeni ya terari manamana useri. ");
INSERT INTO kpr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Iesu nu vironu siri, gegenembo avononde naká aimi genembo eni ungo ata dimbaride ava fumbudo fuseri. ");
INSERT INTO kpr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Fumbudo fera buvudo, natofoimi kambo bedo edo vasa kosegetero gido, Iesu kena ya terari manamana edo, genembo fumbu ririda viti sisoro gukada anumbedo, sisoro jighi afiguseri. Afigedo, genembo ghaghada fasiriri ainghae tino edo, siregetero vovosusira. ");
INSERT INTO kpr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Vosetiri, ne tumonde gogogho usera ava gido, Iesu kae genembo aikena sisira, “Nanda mandi, God ninda ari ekoko kote dotira,” Iesu aminge siri ningido, ");
INSERT INTO kpr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Moses da Geka ijuga kakato+ mendeni aminda anumbirisera aimi, ne dubo jokái totofo kotiseri, ");
INSERT INTO kpr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Genembo omo nange ominge resi? Nu aminge sise God da javo etiri eko erira. God nusukako ari ekoko kote doyeraira. Jo tefo genembo eniimi kote doyari iraeri.” ");
INSERT INTO kpr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aminge kotero ainghae dabade, Iesu nunda asisiimi nenda kotari ava kasama edo sisira, “Ne redae kotari ekoko erekotevu? ");
INSERT INTO kpr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kote givu! Ne erekoteva: na benunu sarena amo, God genembo einda ari ekoko jo kote doyae ari ava, erekoteva. A nenda kotari eni mo: nu jebugare dae sarena amo, nu jo jebugae ariá erekoteva. ");
INSERT INTO kpr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Avori, nanda fakina ijugaono gareva. Evetu Genembo da Korokena+ mo, ari ekoko kote doyari da fakina irira. Ava kasama aovo dae sedo, saono genemboé jebugarira,” aminge sedo, nu jovereghe genembo ungo ata dimbaride aikena sisira, ");
INSERT INTO kpr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Eredo, ninda ghaito gaghe budo kamboda yasi!” ");
INSERT INTO kpr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aminge setiri, genemboá eredo, nunda ghaito gaghe budo ira buviri, evetu genembo isambu gi dudukughedo buniseri. Bunedo, God dae sakai sise siseri, “Namonde evavaga jo gae iriara ava, orokoá siroretiri, namondeda ditii eregosera!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu sekago Galilee uvu da teria aminda ira buviri, natofo isambu fera numokena totorugetero, dengoro indudusira. ");
INSERT INTO kpr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dengoro indiri dadabetiri, nu isira amo, Alphaeus da mandi Levi, takesi ombari da kambo aminda anumbiriri gosusira. Gido, Iesu numokena sisira, “Fu nangae yaore!” aminge setiri, Levi nu eredo nunda amboda isira. ");
INSERT INTO kpr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ainda amboda, Iesu ira Levi da kamboda buvudo, kirumo usera ava risira. Takesi bari gegenembo a ari ekoko embo digari Iesu da amboda isera aimi, fera Iesu nunda ambo jimbide dabade anumbedo bayau riseri. ");
INSERT INTO kpr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Moses da Geka kaifa kakato+ a ijuga kakato+ mendeniimi, Iesu takesi bari kakato a ari ekoko embo ainde dabade anumbedo bayau rero gosuseri. Gido, nunda ambo jimbikena ategi useri, “Takesi bari kakato ne gegenembo ekokori. A evetu genembo mendeni, takesi bari kakatode dabade ojera anumbirera omo, nembarago ari ekoko embori. Ava sedo, nenda ijuga kato redae takesi bari kakato a ari ekoko embode dabade anumbedo bayau rereri?” ");
INSERT INTO kpr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aminge sisera ava ningido, Iesu sisira, “Mave, ‘Na kae tefori,’ sarira amo, dogeta jo numokena yae arira. O mave, ‘Na kae beni,’ sarira amo, dogeta numokena yarira. Kau daba aminga ava, mave nunda ari ekoko jo vujegae irise, ‘Na mandi eveva a ari eko eni tefori,’ sarira amo, na nu jo aghi ae arena. O mave nunda ari ekoko vujeguse, ‘Na ari ekoko embori,’ sarira amo, numoá aghi arena,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","John da ambo jimbi a Moses da Geka kaifa kakato+ da ambo jimbi kanangara ero gido, evetu genembo fera Iesu kena buvudo ategi useri, “John da ambo jimbi a Moses da Geka kaifa kakato+ da ambo jimbi, God dae kanangara use banungeraera. Avata ninda ambo jimbi, ne nange amingae eraeri?” aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu mino nemokena sisira, “Kote givu! Mandi gimasa eni, nu evetu fifitururari kirumo arera da sifo aminda, nunda kokomana ne bayau jo kanangara ae arera. ");
INSERT INTO kpr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","O genembo evetu fitira ava, gitofui sandi bu ya daoro ambarira ainda sifo aminda, nunda kokomana dubo mema use, tuturo edo nundae kanangara arera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Aminge sedo, evetu genembo nangedo ari manai dodo, ari seka aimi God kakara aetera, ava ijugusira. Ijuguse, kasia evia sisira, “Embo boka eni manai edo toka basarira, namonde jo embo sogho seka gafugedo aimi, tauta gayae arera. Ainda susu mo: embo seka gafuge baresa amo, eko arira. A embo seka manaikena tauta gayaresa amo, jo eveva ae arira. ");
INSERT INTO kpr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kau daba ava, vaini (wine) seka jo budo, kofiri manai aminda averegaoro vosedo irae arira. Amingarera amo, vaini (wine) seka da fakinaimi, fumbari kofiri bejari, vaini averege vose soesa arira. Ava sedo, vaini seka kofiri sekada averegeraera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jangutari da Sifo eninda, Iesu nunda ambo jimbide vare jokáda tere sembiseri. Sembise, nunda ambo jimbi tuturo edo farava da vuji ava bambudo, ungoi jase rido iseri. ");
INSERT INTO kpr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Amingero, Moses da Geka kaifa kakato+ mendeni ava fuge gido, Iesu kena siseri, “Kote gi! Ninda ambo jimbi nangetiraimi Jangutari da Sifoda farava da vuji bambu jase rise, namondeda agho dari erebejeri? Jangutari da Sifoda, saramana jo ae aeteri.” ");
INSERT INTO kpr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Aminge setero, Iesu nemokena sisira, “Ne nanda ambo jimbikena ghoghora reseva, ai? Namondeda abua David nunda mendeninde dabade, uvu bayau dadabetiri ighoii sirivo use, nange usira ainda kiki amo tegutusevu, ai tefo? ");
INSERT INTO kpr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nu, fristi+ da giti jighari javo Abiathar ireira ainda sifoda ira, God da Kambo+ aminda teredo, farava God kena futusera aindae benunu setiri, fristi+ mutiri David budo risira. Rise, nunda mendenikena mutiri ne riseri. Risera amo, ne agho dari bejiseri. Agho dari bejisera amo eviri: ‘Fristi+ nesuka, farava kakara amo mindarera,’ agho dari aminge resira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aminge sedo, nu nemokena sisira, “God nu giti evetu genembo usira. Amboda, Jangutari da Sifo amo, nemo sonembari dae sedo gategusira. Nu jo Jangutari da Sifo giti gategedo, amboda evetu genembo, Jangutari da Sifo ava kaifa aoro dae sedo, ne jo ae usira. Nu giti evetu genembo usira. ");
INSERT INTO kpr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Geka beká mo eviri: Jangutari da Sifo aminda rea ava aetera amo, a barago, Evetu Genembo da Koro+ nunda sari ningariri,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesu nu sekago jovereghedo ira, dengoro indari da kamboda+ teterusira. Genembo eni ungo dimbaride amo, aminda iriri teterusira. ");
INSERT INTO kpr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Moses da Geka kaifa kakato+ ne, Iesu ari sembae ari gido, numo bu koto ari dae sedo kotiseri. Avori, Iesu nu nange Jangutari da Sifo aminda, genembo ungo dimbaride ava sari jebugururari gido, nu budo koto aetera aindae kato useri. ");
INSERT INTO kpr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kato ero, Iesu genembo ungo dimbaride aikena sisira, “Eredo, fu buvase!” ");
INSERT INTO kpr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aminge sedo, nu natofokena sisira, “Namonde Jangutari da Sifo aminda, evetu genembo sonembarera, ai, nemokena mema mutarera? Sonembaoro jebugarera, ai, daoro sirivo arera?” aminge setiri, ne mino numokena sari buniseri. ");
INSERT INTO kpr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Amingetero, ne dubo joka iraede ava gido, dubo mema use, janje eko etiri, nemoá gi ya foa ghedo, nu jovereghe genembo aikena sisira, “Ninda ungo jujurege gaone!” aminge setiri, genemboá nunda ungo Iesu kena siregiri, eveva usira. ");
INSERT INTO kpr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Amingetiri gido, Moses da Geka kaifa kakato+ eredo era buvudo, Herod da ambo jimbide dabade, Iesu nange daoro ambarira aindae, manaka garuseri. ");
INSERT INTO kpr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu nunda ambo jimbide dabade reighiá dodo era, uvu da teria javo Galilee aminda buvero, evetu genembo digarigo aimi, nunda amboda iseri. Frovensi Judia, ");
INSERT INTO kpr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","reighi Jerusalem, Frovensi Idumea, frovensi eni uvu Jordan beine sovenikena irira, a Taiar a Saidon da reighi mendeni, ainda natofo digarigo Iesu da bino ava ningido, fera numokena buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Buvudo, nu doghetero jaredo, Iesu nunda ambo jimbikena, ghaka+ simbugaoro dae sisira. Ainda tuka mo: evetu genembo erá numo mimeore dae sise sisira. ");
INSERT INTO kpr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nu giti kae evetu genembo digarigo ava, setiri jejebuguseri. Ava gido, evetu genembo kae mendeni mendeni rurusera amo, ne fera numokena buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Buvurutuse, evetu genembo mavekena sukarui asugetero iriara amo, nemo sukaruimi fugetero duduruguse, koko sise eminge siseri, “Ni God da Mandiri.” ");
INSERT INTO kpr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aminge sero, Iesu nu mavejo ava erá isagha seore dae sise, kovionoghae buregusira. ");
INSERT INTO kpr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesu ira, doririda vitido, gegenembo mavejoá uju usira, avanembo aghi etiri fuseri. ");
INSERT INTO kpr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Fera buvero, gegenembo 12 ava gategusira. Gategedo, nu eminge sisira, “Ne nanda karona edo, namonde dabade deingharera,” aminge sedo, nu sisira, “A kotugo, ne ya vironu saovo dae, nane diriguse, ");
INSERT INTO kpr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sukaru ondovo ya buvari da fakina ava mutono, budo yareva,” aminge sise, gegenembo 12 ava gategusira. ");
INSERT INTO kpr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Gegenembo gategusira, amo eviri. Nu Simon gategedo, nunda javo seka eni, Peter jijighusira. ");
INSERT INTO kpr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Mendeni mo, Zebedee da sasingu, James nengae John ghae gategedo, nenda javo seka eni, Boanerges ava jijighusira. Ainda tuka mo: ‘Sasingu Amo Barara da Kakaugori’. ");
INSERT INTO kpr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","A kotugo, gegenembo mendeni mo eviri: Andrew, Philip, Bartholomew, Matthew, Thomas, James da nunombo (numamo javo Alphaeus), Thaddaeus, Simon ‘Reighi Susu’ seraera, ");
INSERT INTO kpr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","a Keriot embo Judas ri. Judas resena emo, nune Iesu aito usira. ");
INSERT INTO kpr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ainda amboda Iesu ira natida buvurutusira amo, evetu genembo sekago totorugetero, Iesu nunda ambo jimbide jo anumbe uvu bayau mindari da goroto jo tambae useri. ");
INSERT INTO kpr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jo mindae irero, nunda nano namendi ava ningido siseri, “Nu daghedo irira,” aminge sedo, numo sandi bu yari dae fuseri. ");
INSERT INTO kpr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moses da Geka ijuga kakato+ Jerusalem ghedo fusera aimi, eminge siseri, “Sukaru da bajari javo Satan, nune Iesu kena asugedo nunda fakina ava, muteari budo aimi, nu sukaru bu fugeraira,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Setero, Iesu nemo furoro dae kori setiri fero, nemokena kasiai sisira, “Satan nangetiraimi tofo numoá bu fugari? Amo, nu tofo numorita! ");
INSERT INTO kpr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Evia kote givu! Frovensi eni ainda natofo beisiga edo, soroda sarigarera amo, frovensi da fakina soesa arira. ");
INSERT INTO kpr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kau daba aminga ava, reighi eni o oro eni beisiga edo, soroda sarigarera amo, reighi o oro amo, jo fakina edo fetae arera. ");
INSERT INTO kpr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","‘Na Satan da fakina budo aimi, nunda sukaru bu fugeraena ava sedo, na Satan da eniri,’ aminge sise reseva. Avorita, saono ningivu! Satan da natofo tofo tofo beisiga edo, soroda sarigarera amo, ne jo fakina edo fetae arera. ");
INSERT INTO kpr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Mave jo kotae kotae, genembo fakina kato ainda kambo beje teredo, nunda roera a gugua jo bagia ae eraira. Nu giti genembo fakina katoá sandi bundedo, amboda nunda roera a gugua sosighi arira. Kau daba aminga ava, na Asisi Kakara da fakinaimi, Satan da fakina gajedo, seono nunda sukaru foa buvuraera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Avori, Moses da Geka ijuga kakato+ giti eminge siseri, “Iesu mo, sukarui asugusira,” siseri. Setero, aindae sedo, Iesu eminge sisira, “Kote givu! Na nemokena geka beká resena! Mave ari eko eni edo o geka eko eni sedo, amboda God kena vujegarira amo, God nunda ari eko amo kote doyarira. Avata ne eminge seraeva, ‘Iesu nu jo Asisi Kakara da saramana ae eraira; numo Satan da fakinaimi eraira.’ Ne aminge sise, Asisi Kakara da javo eko eraeva. A kotugo, mave Asisi Kakara da javo eko arira amo, God nunda ari eko amo jo kote doyae arira, sifo ghousa evia irarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ainda amboda, Iesu da noi nunda jamenade fera buvudo isaghada fetedo, nu foa buvare dae siseri. ");
INSERT INTO kpr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Evetu genembo digari Iesu kena anumbirisera aimi siseri, “Nei a ninda jamenade isaghada fetirise, nimo ya buvaso gari dae uju erera.” ");
INSERT INTO kpr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aminge setero, nu sisira, “Nanda aya a nanda jamena mavejori?” aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","evetu genembo anumbirisera, ava fuge gosuse sisira, “Givu! Evetu genembo anumbirera emo, nanda aya a nanda jamenari. ");
INSERT INTO kpr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mave God da uju ava use irarera amo, nanda ai ghasovu, nanda nano namendi, a nanda aya mo, nemori,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu nu eredo ira, Galilee uvu da teria irira ainda betuda buvudo, sekago tuturo edo ijugusira. Ijugiri, evetu genembo digari numokena fera totorugedo vasa ganjibuseri. Aindae sedo, nu ghaka+ evada feghiri gido, ghaka+ jokáda vose anumbetiri, evetu genembo isambu buvudo uvu betuda fefetuseri. ");
INSERT INTO kpr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Fetetero, Iesu nemokena kasiaimi geka mendeni mendeni ijuguse, eminge sisira, ");
INSERT INTO kpr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kote givu! Genembo eni eredo, farava veka govari dae sedo, aira vareda buvudo, ");
INSERT INTO kpr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","tuturo edo, veka giririghe budo jife jafe getira. Etiri, veka mendeni mo, begatada vosetiri, rikamanei ojighera minderi. ");
INSERT INTO kpr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Veka mendeni mo, aroro etoda vosedo totoi batuno etiri, ijiimi aviri gharasa etira. Enda jo teria irae ava sedo, besisi jo bae etira. ");
INSERT INTO kpr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Veka mendeni mo, vive titifaghae ainda jokáda vosedo, viveghae dabade vitira. Ainghae vitido, vivei gaetiri dadabetira, beká jo ae etira. ");
INSERT INTO kpr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A veka mendeni mo, enda evevada vosedo vitira. Viti, beká digarigo jighira. Amo, mendeni 30, mendeni 60, a mendeni 100 avavaga jighira,” kasia evia se dotutuse, ");
INSERT INTO kpr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iesu eminge sisira, “Kasia setena amo, dengoro jave ningi gogoghombevu!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Natofo nu dodo isera ainda amboda, Iesu da ambo jimbi 12 nunda kokomana mendeninde dabade fera numokena kasia da tuka aindae ategi useri. ");
INSERT INTO kpr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ategi etero, Iesu nemokena sisira, “God Afa kau nange nunda natofo+ kaifa eraira, ainda geka mendeni ava kivo usira. Ne nanda ambo jimbiri. Ava sedo, nu rea kivo usira amo, nemokena isagha saono ningi kasama aovo dae sise, seraena. O natofo mendenikena geka isambu kasiaimi ijugeraena. ");
INSERT INTO kpr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Aminge ijugeraena da beká mo eviri: ‘Erama nenda dubo joveregheuri gido, God nenda ari ekoko kote doyeure dae sise, ne garera, avata ne jo gi gogoghombae arera. Ne dengoroi ningarera, avata ne jo ningi kasama e gogoghombae arera.’ God da Geka ava kotise kasiaimi ijugeraena,” aminge setiri dadabusira. ");
INSERT INTO kpr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Dadabetiri, Iesu nemokena ategi usira, “Ne nangetiraimi kasia da tuka erebunevu? Amboda kotugo, na sekago kasia sarena amo, ne nange tuka kasama arevu? Avori, kasia setena, ainda tuka ava ijugaono kasama areva. ");
INSERT INTO kpr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Vare govari kato veka govetira amo, God da Gekari. ");
INSERT INTO kpr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Veka mendeni emboro begatada vosetira, ainda tuka mo eviri. Evetu genembo mave God da Geka ningeoro Satan foa, God da Geka ningiraera ava, nenda jokáda ufena saghimbe buraira, amingori. ");
INSERT INTO kpr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kau daba aminga ava, veka mendeni enda aroroghae aminda vosetira, ainda tuka mo eviri. Evetu genembo mave God da Geka ningido ivugaghae buraera, amingori. ");
INSERT INTO kpr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Avata nenda dubo jokáda tumondari jo inono ae arira. Ava sedo, ne sifo tufako tumonduse iroro, dara sirorarira, o ne God da Geka tumonderaira aindae, gitofu nemokena fakarago use mema mutarera amo, ne oju use totoi gofarera. ");
INSERT INTO kpr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Veka mendeni vive titifaghae ainda jokáda vosetira, ainda tuka mo eviri. Amo, evetu genembo mave God da Geka ningiraera, amingori. ");
INSERT INTO kpr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Avata amboda nenda irari, reighi da gugua, a fisi da uju ava koteraera. Aimi, God da Geka gajeari, nenda tumondari da beká ava jo sirorae eraira. ");
INSERT INTO kpr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Avata veka mendeni enda eveva aminda vosetira, ainda tuka mo eviri. Evetu genembo mave God da Geka ningido bu kaifa urureoro, vitido beká jighiraira amo, 30, 60, a 100 avavaga jighiraira, amingori,” Iesu kasia ainda tuka aminge setiri nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu sekago kasia sisira, “Namonde jo arivo injibedo budo okia jokáda vendae eraera, o jo ghaitoi gajae eraera. Namonde, arivo isaghada jigheoro jaragheraira. ");
INSERT INTO kpr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Roera oroko jungedo irira, amboda foa isagha ari kasama arera. A roera oroko kivo etero irira, amboda isagha vironu sirurari ningarera. Kau daba aminga ava kasia resera einda beká mo, amboda kasama arera. ");
INSERT INTO kpr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Geka setena amo, dengoro jave ningi gogoghombevu!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aminge sise, nu sekago sisira, “Ne rea niningereva ava, kote gogoghombevu! Ne rea evetu genembokena mutareva amo, God nemokena mino kau daba ava futuse, ainda etoda mendeni bu fitido, ainghae mutarira. ");
INSERT INTO kpr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ainda beká mo: mave God da Geka ningido, kotari eveva koteraira amo, God sonembari nu kote gogoghombarira. Avata mave God da Geka jo kotae eraira amo, God nunda kotari isambu bari dadabarira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu aminge sise, kasia eni sisira, “God da natofo nange siroreraera amo, emingori. Nu inono, genembo eni nu veka giririghe budo endada jife jafe ge dotutusira. ");
INSERT INTO kpr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Dodo ainda amboda, sifo tumba ava, avido eredo ghuse deinghurureari, veka nusuka batuno edo vitiraira. Ava kau nange vitiraira ava, nu bunariri. ");
INSERT INTO kpr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Endaimi eveva muteari, veka batuno edo, viti beká jighido safufu eraira. ");
INSERT INTO kpr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Safufu eari gido, ‘Bambari da sifo buviro!’ sedo, genembo nunda saramana kakato dirigeari, ya kaiyaimi dive bamburaera. Kau daba aminga ava, evetu genembo mendeni tuturo edo, God da Geka niningurureoro, tumondari siroreari, ne foama nunda sasingu eraera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu kasia ika mainekena fifituse sisira, “God da natofo+ kau nange digarigo eraera ava, sari dae erena. ");
INSERT INTO kpr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","God da natofo+ tuturo edo, nange digarigo siroreraera amo, kau ika maine da vujiimi vose batuno edo vitiraira, ainda kaugori. Maine da vuji mo, veveyako bekári. Nu jo ika mendeni da vujigo iraeri. ");
INSERT INTO kpr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Avata vuji avavaga, genembo enii bu yama nunda vareda govari vitarira amo, nu viti vareda roera isambu darigedo mindafu beká ava edo, fafatu saredo itumu siroreari, rikamane foama nenda mogha fafatu aminda fitiraera. Kau daba aminga ava, God da natofo+ tuturo edo digarigo eraera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu nu kasia kau daba aimi, evetu genembokena ijugedo ghusira. Ijugurureari, ne duboi kotise, ainda tuka ava inonoda kasama aetera, ava sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nu natofokena kasia ainembo ijugedo ghusira. Avata ne dodo esike irureoro nunda ambo jimbide dabade anumbirise, nesuka nemokena kasia da tuka ava isagha ijugeari, ne ningido ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Sifo daba aminda, ungobu iri, Iesu nunda ambo jimbikena sisira, “Namonde sembi ya betu sovenida darore!” ");
INSERT INTO kpr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aminga setiri, nunda ambo jimbi ghaka+ nune irisira aminda vosedo, evetu genembo anumbirisera dodo, ne sirigedo ghaka+ mendeni ainde dabade betu sovenida sembiseri. ");
INSERT INTO kpr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Sembera, soroda buvurutero, eva yaura vovogoghae eko beká ava erorusira. Eredo, ghaka+ de rosari dae usira. Avata, Iesu nu ghaka+ ghaemboda guto gae fase aviri, nunda ambo jimbi deretero eretiri, numokena siseri, “Ijuga Kato, namonde sirivo ari dae erera emo, nangetiraimi ni kotae fase ravesi?” ");
INSERT INTO kpr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aminge setero, nu eredo yaura bureguse kovionoghae sisira, “Dodo binono e!” aminge setiri, eva yaura tukughedo binono usira. ");
INSERT INTO kpr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Amingetiri, nemokena sisira, “Ne redae oju etevu? Nemokena tumondari tefori!” ");
INSERT INTO kpr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aminge setiri, ne dudukughedo tofo tofo se nininguseri, “Arie! Genemboé kau avegorai? Nune setiri, eva yaura nunda geka ningi! Ari emo, jo evetu genemboi ari da kaugo iraeri!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu nunda ambo jimbide uvu da teria javo Galilee, aminda sembera, Gerasa ondi da reighi sovenikena aminda teteruseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tere ghaka+ darido, vitari dae iri, genembo sukarui asugetero ireira aimi, beku jokáda ghe buvu vose fira nu tafusira. Beku resena emo, ambari embo aminda furugedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Genembo amo, kambo tefori; nu ofofo beku aminda irá ghedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Evetu genemboimi foama nu sandido, ungo ata seinii (chains) bundedo ghuseri. Avata nu ereari, seini (chains) bunununghedo ghusira. Amingeari, evetu genembo nu sandi bundari bunedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sifo tumba ava inono, nu ofofo a doriri aminda birurughuse koko sise, ghamana aimi budo, nunda tamo iseri edo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Avori, genembo amo, nu soka beká Iesu fuge gido, numokena sumbu fira buvudo, Iesu da dombuda tumoi bainghusira. ");
INSERT INTO kpr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Bainghetiri, Iesu sukaru aikena sisira, “Sukaru, nindae resena! Genembo ainda jokáda ghe fu buvase!” aminge setiri, koko sisira, “Iesu, ni God Teria Beká ainda Mandiri! Ni redae namanekena refesi? Namane God da dombuda, nimokena benunu resera. Namanekena erama mema muteose!” aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iesu nemokena ategi usira, “Ne mavejori? Sevu ningone!” aminge setiri, ne siseri, “Namanenda javo mo ‘Digariri’. Ainda beká mo: namane digarigo irera,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aminge sedo, ne sekago siseri, “Namane uju beká ava erera, ni jo namane dirigaso vasaé dodo, reighi eninda yae arera,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Vasa ganasa jo soka irae aminda, fuka 2,000 amingo ava bayau rise ya foa ghero gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Gido, sukarui benunu siseri, “Namane nange saso yama, fukamane da jokáda teraeteri!” aminge benunu siseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Setero, Iesu ‘avori’ setiri, sukaru genembo ainda tamonda iriara aimi, vose darigedo era fukamane da jokáda tere asugetero, fukamane amo sumbu fusikenana sedo era, vasa ganasa aminda ghasaghe vosedo, uvuda mindi sirivo useri. ");
INSERT INTO kpr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Etero gido, fuka kaifa kakatoi sumbu era, reighi bogu aminda a reighi mendeni mendeni aminda buvudo, rea gosusera ava osa setero, evetu genembo nininguseri. Ningido, ne eredo, geka sisera ainda beká ava, ningari dae a gari dae sedo, Iesu kena fuseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Fera buvudo, genemboá jebugedo boka ujudo anumbiriri gosuseri. Gido, oju useri. ");
INSERT INTO kpr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Evetu genembo mendeni, mave rejo siroretiri ditiimi gosusera aimi, osa setero evetu genembo nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ningido, Iesu nu nange ne dodo jovereghe yaetira, aindae benunu siseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Setero, Iesu nu ira ghakada+ vivitiri, genembo giti setiri sukaru nu do buvero jebugusira aimi, fira Iesu kena benunu sisira, “Na nange nangae yaeteri!” ");
INSERT INTO kpr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Setiri, Iesu numokena sisira, “Tefo, ni jo namonde yae arera. Ni jovereghedo, kamboda yasi! God joka edo ni kau nange sonembetiri jebugetesa ava, osa saso ninda kokomana ningore!” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Setiri, genemboá nu jovereghe ira, Frovensi Dekapoles, reighi isambu ghabu sovenisoveni ireira aminda birurughudo ise, Iesu numokena rea usira ava, osa seari evetu genembo isambu, ava ningido dudukughedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu nunda ambo jimbide dabade jovereghe, uvu da teria aminda sembera dari viti fefetero, evetu genembo digari fera nu jimbe fefetuseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jimbe fetetero, dengoro indari kambo+ da bajari eni javo Jairus, fira numo gido, tumoi bainghusira. ");
INSERT INTO kpr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Bainghedo, nunda ghamo joká isambu numokena futuse sisira, “Nanda gagara ijoghako kae budo ambari dae erira. Fu, ninda ungoimi tamonda jighaso jebugare!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Setiri, Iesu eredo nemonde iseri. Evetu genembo natofo ainde dabade ise, minonde minonde gotatara udo iseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ero, evetu eni fira, nu emboro soroda tafusira. Evetu resena emo, nu kae budo tambuno gosuse irise, ghaeko 12 ava dadabusira. ");
INSERT INTO kpr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nu dogeta mendenikena sonemba bari dae sedo, ya ghedo ghusira. Avata nu jo jebugaeri. Dogetakena ya foa ghuse, nunda moni fuge dadabusira. Avata nunda kae jo dadabae irise, teria usira. ");
INSERT INTO kpr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Avori, evetu aimi Iesu da bino ava ningi eredo, nunda amboda ira, ");
INSERT INTO kpr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","nunda tamo asugarida jijighusira. Nu amingusira da beká mo: nu kotisira, “Na tefo nunda tamo asugari aminda jigharena amo, na jebugarena,” aminge kotisira. ");
INSERT INTO kpr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nunda tamo asugarida jijighiri, nunda kae ororo tukughedo dadabiri itatamusira, “Na jebugeteni!” aminge kotisira. ");
INSERT INTO kpr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kotiri, Iesu nunda fakina mavekena sefusira ava, tofo itatamusira. Itatamuse, nu anakora evetu genembo da soroda jovereghe fetedo sisira, “Mave nanda tamo asugarida jighi?” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","nunda ambo jimbi siseri, “Ni redae aminge resesi? Namonde natofo jokáda gotatara udo refera emo, ni ‘mave sire jighariá’ resesi?” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Avata Iesu nu mave nunda tamo asugarida jijighusira, ava kasama ari dae sedo, gi ya foa ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Amingiri, evetuá Iesu nange etiri jebugusira ava kotise, evetu ojughae ungo ata dadaragaruse, Iesu kena ira buvudo, nunda ata duruda du fasusira. Fasedo, numokena rea sirorusira ava, isambu setiri niningusira. ");
INSERT INTO kpr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Setiri, Iesu numokena sisira, “Nanda gagara, ninda tumondariimi ni jebugetesi. Ava sedo, dubo jamaghae yasi, jebuga irase!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Evetu aikena geka jo se dadabae iriri, aghi kakato mendeni Jairus da kamboda ghe fera buvudo, Jairus kena siseri, “Ninda gagara ambira. Ava sedo, Ijuga Kato erá tefo fuse janjagu eure dae resera.” ");
INSERT INTO kpr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aminge setero ningido, nenda geka ningi dotutuse, Iesu Jairus kena sisira, “Erá oju eose! Ni taká tumonde!” ");
INSERT INTO kpr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aminge sedo, erama evetu genembo nemonde dabade yeore dae sedo buregusira. Buregedo, Iesu nu Peter, James, a James da mandako John, ava budo nemonde dabade era, ");
INSERT INTO kpr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairus da kamboda buvudo, evetu genembo digari dimbia sorara ero gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iesu ira kambo jokáda teredo, nemokena sisira, “Ne redae dimbia sorara erevu? Gagara mo jo ambaeri, nu ravira.” ");
INSERT INTO kpr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aminge setiri, ne tuturo edo numoá dere jiseri. Dere jirero aindae, Iesu ne ondiri era buvero, gagara ainda noi numamo, a nunda ambo jimbi etodaba naká ainde dabade, gagara da avari vasada era teteruseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tere fetetero, Iesu gagara ungoda jighido, reighi ainda gekaimi, “Talitha kumi!” sisira. Ainda tuka mo eviri: “Nanda gagara, eraso dae resena.” ");
INSERT INTO kpr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aminge siri ainghae dabade, gagara amo jebuge erorusira. Gagara ainda ghaeko mo, isambu 12 ava sedo, nu ya foa ghiri gi dudukughedo buniseri. ");
INSERT INTO kpr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bunero gido, Iesu, erá osa seore dae sise bureguse, bayau gagara aikena mutoro mindare dae sisira. ");
INSERT INTO kpr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu nunda ambo jimbide dabade eredo reighiá dodo, nunda reighi Nasareth aminda era buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Buvudo irise, Jangutari da Sifo aminda ira, dengoro indari da kambo+ aminda teredo, tuturo edo ijugusira. Ijugiri, evetu genembo nunda geka sisira ava, ningi dudukughedo siseri, “Numo kafentari (carpenter). Nunda noi mo Mary; nunda jamena mo James, Joses, Judas, a Simon ri. A nunda ghaghasovu barago, ne eminda irá gheraera. Ne isambu reighi ei embori. Nu jo genembo teria iraeri. Ava nu fakina a dubo kotarié reda rurusi? Nu nange nange dubo koterai? Nu nange nange nunda fakinaimi, ari mendeni mendeni etiri siroretiri, namonde gae iriara ava, namondeda gitida eregoseri?” aminge sedo, dubo ekoko edo, nu ighagha useri. ");
INSERT INTO kpr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Amingetero, Iesu nemokena sisira, “Feroveta da geka ava, evetu genembo isambu, ne ningido nu kakara eraera. Avata feroveta tofo nunda natofo, nunda oro, a nunda ghaguru aimi, nu jo tumonduse kakara ae eraera. Kau daba aminga ava, ne namokena eraeva. Namo nenda eniri, avo gido, ne na jo tumondae eraeva,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Evetu genembo nu jo tumondae usera aindae sedo, nu ari a tano bouvu fakinaghae digarigo, aminda jo aeri. Nu dabako evia usira. Nu kae evetu genembo da tamonda ungoi jijighuse setiri jejebuguseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Evetu genembo jo tumondae usera ava gido, Iesu nu dudukughusira. Dudukughedo, nu reighi Nasareth dodo, reighi mendeni Nasareth ainda dengesida irira, aminda ise, evetu genembokena ijugedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iesu nunda ambo jimbi 12 ava, aghi etiri numokena fuseri. Fera buvero, ne gategedo, etoto etoto dirigusira. Diriguse, nu sukaru bu fugari da fakina ava nemokena futuse, ");
INSERT INTO kpr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","eminge sisira, “Ne jo totoi jovereghe furae areva, avata ne roera digari futo jo bu ainghae deinghae areva. Erá bayau, moni, a javo bambudo yeove! Ne ketua avanembo bu yasivu! ");
INSERT INTO kpr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nenda ata asugari a nenda tamo asugari asugedo yareva. Avata erama tamo asugarida tuka bu yeove! ");
INSERT INTO kpr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ne ya reighi eninda buvudo kambo ningiaminda terovo, evetu genembo ne ivugaghae nati joká darera amo, kambo daba aminda avise, saramana aovo dadabari gido, kambo a reighi amo dodo yareva. ");
INSERT INTO kpr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","O ne ya reighi eninda buvovo, evetu genembo ne jo ivugaghae nati joká dedo ne bu undae arera, a nenda geka jo ningae arera amo, reighiá do buvurutuse, nenda ata danghevu, fonja aminda vosare! God nu evetu genembo amo ighagha arira. Ava kasama aoro dae sedo, amingevu!” Iesu aminge sedo, ne dirigetiri iseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Era buvudo, ne evetu genembo dubo jovereghaoro dae sise, vironu sedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","A kotugo, ne sukaru digari ava ondeoro evetu genembo da jokáda ghe vose darigedo ghuseri, a ne orivi (olive) da muka simbe budo aimi, kae evetu genembo da tamonda davedo seoro jejebugedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ne rea ava edo ghusera, ainda bino ava iri, Kini (King) Herod niningusira. Ainda beká mo: Iesu da bino ava, reighi isambu aminda ivegedo iri nininguseri. Ningido, evetu genembo mendeni Iesu dae sedo ghuseri, “John Bafataito Ari Kato seteno dorusera ava, ambarida ghe jebuge erorusira amo, numori tano. Ambarida ghe jebuge erorusira aimi, nu fakina tomanako budo saramana eraira,” aminge sedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mendeni ne eminge sedo ghuseri, “God da feroveta javo Elijah, sekago jovereghe furariá seraera amo, numori tano.” A mendeni sedo ghuseri, “Numo God da feroveta eni, abuamane da sifoda iriara, ainda kaugori,” aminge sedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","O Kini (King) Herod bino ava niningusira amo, nu eminge sisira, “John Bafataito Ari Kato seteno duboda divegetero ambududurusira ava, ambarida ghe jebuge eredo deingherira tano,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ainda beká mo: Herod John kena emingusira. Nu setiri, nunda mendeni era, John sandi bundedo diburada fifituseri. Nu amingusira da susu mo: nunda koro Philip da noaro javo Herodias ava, saghimbe bu fifitusira. ");
INSERT INTO kpr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Aindae sise, John nu Herod kena ghoghora sise eminge sedo ghusira, “Ni evetué bu fifitusesa amo, agho dari bejisesi!” aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias aindae sedo, John kena dubo eko etiri, numo dari dae uju usira. Avata Herod nu ditii jijinimbiri, evetuá John dari bunisira. ");
INSERT INTO kpr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Amingusira da beká mo: Herod kasama usira, John nu genembo eveva a kakaragori. Ava sedo, nu John ava ditii jijinimbedo ghusira. Amingeari, John foa numokena geka seari ningido, ivuga edo ghusira. Avata, nu jo tumondae edo ghusira. ");
INSERT INTO kpr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodias nu John dari dae kotise iriri, Herod da sirorari sifo fira buviri, nu aminda goroto tafusira. Amo emingusira. Herod da sirorari sifo fira buviri, Herod nu gavana da kokotofu, nunda isoro kakato da babojegari, a frovensi Galilee da gegenembo babai frovensi aminda iriara, isambu aghi etiri fera totorugetero, nendae sedo kirumo usira. ");
INSERT INTO kpr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kirumo ero, Herodias da gagara ira teredo, yaru didiviri gido, Herod nunda esa embode dabade ivuga beká ava useri. Ava sedo, Herod gagara aikena sisira, “Ninda uju ava se ningone! Ni rejodae benunu saresa ava, na nimokena mutarena.” ");
INSERT INTO kpr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Aminge sise, beka gagojuse sisira, “Ni uju aresa amo, na nanda enda tano edo, nanda gugua diti etoto fugedo, ni soveni baso na soveni baono dae saresa, amingarena.” ");
INSERT INTO kpr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aminge setiri ningido, ira noikena buvudo ategi usira, “Na rejodae benunu sareni?” setiri, noi minonda sisira, “Ni John Bafataito Ari Kato da gifua ava, benunu saso mutarira.” ");
INSERT INTO kpr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aminge setiri ningido, gagara jovereghe bibitai sumbudo ira kinikena buvudo benunu sisira, “John Bafataito Ari Kato da gifua ava, oroko nembo gafugedo rooróda vendi mutaso barena,” aminge benunu sisira. ");
INSERT INTO kpr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Setiri ningido, Kini (King) Herod nu dubo mema ambari eko usira. Avata nunda esa embo da dombuda beka gagojusira aindae, nu bouvu edo, gagara da geka buregari bunisira. ");
INSERT INTO kpr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Amingedo, John da gifua gafuge bu furare dae sedo nunda isoro kato eni sifo daba aminda dirigetiri isira. ");
INSERT INTO kpr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ira, dibura da vasa aminda teredo, John duboda divegedo, gifua ava rooróda vendi budo fira gagara aikena futusira. Mutiri budo ira, noikena mutiri rurusira. ");
INSERT INTO kpr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Etiri dadabetiri, John da ambo jimbi ava ningido era, nunda tamo budo fera, ofofoda furuguseri. John nunda ambari mo, amingusira ava kotise, Herod nu Iesu da bino ningido, John jovereghe furariá kotisira. ");
INSERT INTO kpr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Avori, Iesu da ambo jimbi jovereghe fera buvudo, ne rea usera a ijugusera ava, Iesu kena osa siseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sisera ava, evetu genembo digari nemokena ya foa ghero, Iesu nunda ambo jimbide dabade anumbe bayau mindari da goroto jo tambaeri. Aindae sedo, Iesu nemokena sisira, “Fuvu, namonde kikiako yama vasa esike, evetu genembo irae da vasa aminda jangutarera!” ");
INSERT INTO kpr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aminge sedo, ghakada+ vosedo, evetu genembo irae da vasa aminda sembiseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Uvu da teria aminda sembero, evetu genembo digari nemoá gi kasama edo, nenda reighi isambu dodo uvu dengesida sumbudo giti era buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iesu amboda buvudo ghaka+ dari vitido, evetu genembo natofogo ava totorugedo irero gosusira. Gido, nendae joka usira. Ainda beká mo: ‘Ne kau sifi (sheep) giti jighari iraede, ainda kaugo ava edo iriari,’ ava kotise, nemokena roera mendeni mendeni ava ijugusira. ");
INSERT INTO kpr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ijugiri ungobu etiri, nunda ambo jimbi 12 ai fera numokena siseri, “Iji dadabetira, eminda evetu genembo a kambo tefori. ");
INSERT INTO kpr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ava sedo, natofo dirigaso, yama reighi mendeni mendeni aminda, bayau ombu mindore!” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Setero, Iesu nemokena sisira, “Bayau nene mutuvu mindore!” Setiri, ne numokena siseri, “Ni erekotesa amo, namane yama K2,000 aimi farava ombu mutoro mindoro dae sise resesa, ai?” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Setero, nu nemokena sisira, “Nemokena farava nanjogori? Yasivu gaove!” Setiri, era gido jovereghe fera siseri, “Farava ghabu soveni a oka etoto nakári.” ");
INSERT INTO kpr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Aminge setero ningido, nu nunda ambo jimbikena sisira, “Evetu genembo sevu, nunda diti diti kikisada fuge anumbaore!” aminge setiri, ne era setero ");
INSERT INTO kpr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","evetu genembo sarigedo diti mendeni 100 a mendeni 50 avavaga fuge anumbuseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Anumbetero, Iesu nu farava ghabu soveni a oka etoto naká ava budo, dombu utuda fainghedo God kena ‘aiyakoe’ sisira. Sedo, farava jighi embebegedo, natofokena ghasoro mindoro dae sedo, nunda ambo jimbikena futusira. Oka etoto naká ainghae dabade budo soro aoro dae sedo futusira. ");
INSERT INTO kpr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mutiri budo soro etero, isasambu mindero inono usira. ");
INSERT INTO kpr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mindero inono etiri, mendeni dotero fasusira ava, Iesu da ambo jimbiimi rete budo kanda babai isambu 12 ava vevenduseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Gegenembo bayau risera amo, inono 5,000 avavagori. Evevetu a sasingu jo tegaeri. ");
INSERT INTO kpr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mindero dadabiri ainghae dabade, Iesu nu setiri nunda ambo jimbi ghakada+ vosedo, ne giti uvu da teria sovenikena reighi Betsaida aminda yari dae sembiseri. Sembero, Iesu evetu genembo totorugusera ava dirigusira. ");
INSERT INTO kpr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Dirigetiri ero, nu enda jiro fumbari, aminda banungari dae sedo vitisira. ");
INSERT INTO kpr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tumba jiriri, nu nusuka vasa aminda iriri, ghakada+ isera amo, ne sembera soroda buvurutero, ");
INSERT INTO kpr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","yaura dombukena firi ghanda davusera, jo inono ae usira. Amingero, Iesu gosusira. Gido, sifo da tumba aminda, Iesu vose eva etoda fete deinghe nemokena isira. Ira ghaka+ darigari dae iri, ");
INSERT INTO kpr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ne fuge gido, ‘sukaruva’ sedo, koko siseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ainda beká mo: numo gosuse, ne isambu oju beká ava useri. Oju ero, Iesu tavarige sisira, “Fakina evu! Namori! Erá oju eove!” ");
INSERT INTO kpr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aminge sedo, Iesu nu ira ghakada+ vivitiri, yaura tukughedo binono usira. Binono etiri gido, ne dubo buniseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ainda susu mo: Iesu nunda fakina nemokena ijuguse, farava soro etiri natofo mindero inono usira ainda tuka ava, ne jo kasama ae useri. Ava sedo, nu nemokena buviri, yaura tukughe binono usira ainda tuka barago, jo kasama ae useri. Ainda beká mo: nenda munju jo afigae usira. ");
INSERT INTO kpr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Avori, ne Iesu de dabade sembera, reighi Genesaret aminda dadoruseri. Genesaret resena emo, reighi savavarari. Kotugo ainda jokáda, reighi veveyako mendeni irei. ");
INSERT INTO kpr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ghaka+ dari vitéro, evetu genembo ne Iesu gido kasama useri. ");
INSERT INTO kpr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kasama edo, kae evetu genembo bu furari dae sedo, ne anakora era nenda reighi aminda, kae evetu genembo fafasedo iritiriara ava, ghaghada fiti fumbudo, numokena fuseri. Evetu genembo, nu reighi reda iriri setero niningusera, vasa aminda kae evetu genembo budo fuseri. ");
INSERT INTO kpr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nu reda isira, reighi babai a reighi kikitako aminda, natofoimi nunda bino ava ningido, kae evetu genembo fumbudo maketa vasada budo fuseri. Budo fera buvudo, evetu genembo aimi, ne Iesu kena benunu siseri, nange kae embo Iesu da tamo asugari da tingu ava deredo jejebugaeteri. Aminge setero, mave sire dederusira amo, nu jebugusira. ");
INSERT INTO kpr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Moses da Geka kaifa kakato+ a Jusi embo isambu nenda kiki kakara use, ungo jo seghae arera amo, ne bayau jo mindae arera. Ne maketa vasa dodo ya kamboda vitido, roera ombarera ava jo seghae arera amo, ne jo mindae arera. A eni mo, ne agha, okia, a rooro ábarago segheraera. Aminguse, ne kiki mendeni mendeni ava kakara use eraera. Avori, Moses da Geka kaifa kakato a ijuga kakato+ mendeni Jerusalem ghedo fera buvudo Iesu kena totoruguseri. Totorugusera amo, ne Iesu da ambo jimbi ungo jo seghae bayau rero gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Gido, ategi useri, “Ninda ambo jimbi redae namondeda kiki dodo, ungo jo seghae bayau bu mindiraeri?” ");
INSERT INTO kpr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aminge setero, nu eminge sisira, “Ne gungubo kakatori. God da feroveta Isaiah nendae sise, geka beká gefusira. Amo eviri: ‘Bajari resira, “Evetu genembo emo, bekaimi na kakara eraera. Avata nenda dubo jokáda mo, ne soka bekári. ");
INSERT INTO kpr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ne na tumonde baingheraera, avata beká eni tefo bekári. Ne aminda sonemba eni jo bae arera. Ainda beká mo: ne evetu genembo da kotari ava, ne nanda Agho Dariva sise ijugeraera.’ Geka amo God setiri, Isaiah nendae sedo gefusira. ");
INSERT INTO kpr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ne evetu genembo da kotari a uju ava bu jighirise, God da Agho Dari ava dotutusevu.” ");
INSERT INTO kpr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Aminge sedo, Iesu sekago sisira, “Ne nangetiraimi God da Agho Dari bu fugedo, totofo nenda kiki ava use dara eraevu! ");
INSERT INTO kpr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Na redae aminge reseni? Ijugaono gareva. God setiri, Moses eminge sisira: ‘Nei nimamo kakara use, nenda geka ava ningivu!’ A eni mo: ‘Mave noi o numamokena jijivu sarira amo, devu ambare!’ Moses aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Avata nemo, eminge ijugeraeva. Genembo mave noi numamo ighagha use, nunda gugua budo ‘Korban’ sise, ");
INSERT INTO kpr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","noi numamo jo sonembae arira amo, avori. Ne aminge ijugeraeva. (‘Korban’ da tuka mo, roera God kena mutariri.) Evetu genembo aminguse, noi numamo jo sonembae eraera amo, ne ‘avori’ seraeva. ");
INSERT INTO kpr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aminguse, ne God da Geka ava dotutuse, nenda kotari ava seovo buveari, geka bekáva sise seraeva. A ne roera mendeni mendeni kau daba ava ijugeraeva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Setiri dadabetiri, Iesu kori setiri evetu genembo sekago fera numokena totoruguseri. Totorugetero, nemokena sisira, “Ne isambu, ningido kasama aovo dae resena. Ne erekoteva, evetu genembo ungo jo seghae iria edo bayau bu mindarera aimi, tamo bebeta arira. ");
INSERT INTO kpr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Avata, evetu genembo rea mindarera aimi, nenda tamo jo bebeta ae arira. O evetu genembo da dubo jokáda kotari sembae o geka sembae buvarira aimi, ne bebeta arira. ");
INSERT INTO kpr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ava ningido kasama aovo dae sise resena!” ");
INSERT INTO kpr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Aminge sedo, evetu genembo dendeguda totorugusera ava dodo, nunda ambo jimbi ainde dabade kamboda teteruseri. Teredo, nunda ambo jimbi, Iesu kasia sisira ainda tukadae, ategi useri. ");
INSERT INTO kpr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ategi etero, Iesu nemokena sisira, “Ne nangetiraimi geka setena da beká ava, jo kasama ae erevu? Ne nanda ambo jimbiri. Avata na eregosena, nenda kotari kikitakori, evetu genembo mendeni da kotarigori. ");
INSERT INTO kpr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","23","Ne anakora geka evia kasama aetevu. Genembo bayau rea mindarira aimi, jo nu bebeta ae arira. Ainda beká mo: genembo bayau mindarira amo, jo nunda dubo jokáda terae arira. Bayau amo nu tininda vosiya foká jinendo ya vosarira. Avata genembo rea dubo jokáda koteraira aimi, nu bebeta eraira. Ainda tuka mo: kotari ekoko, bagia ari, kombo yagera ari, dighighi ari, evetu genembo kae jighoro ambari, komana daoro ambari, ari ekoko ari, gungubo sari, oduso ari, kotae kotae emboroda sino da ari ava use deinghari, bengoso ari, aji sari, tofo sakai sari, gogore edo kotae kotae sari, kotari amo genembo da dubo jokáda ghe foa buvuraira aimi, nu bebeta eraira,” aminge sisira. Aminge sise, Iesu ijugusira: evetu genembo jo bayau rise, aimi bebeta ae eraera. Ari ekoko nenda dubo jokáda buvuraira aimi, bebeta eraira. ");
INSERT INTO kpr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu nu reighiá dodo ira, gitofu da reighi etoto, javo Taiar a Saidon, ainda frovensi aminda buvudo, kambo eninda teterusira. Nu junge ufena ya teraetira ava uju usira, avata nu jo junge yari da kaugo iraeri. ");
INSERT INTO kpr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nu fira buvurutusira da bino ava ningido, evetu eni anakora fira numokena buvudo, nunda ata duruda du fasusira. Evetu resena emo, nu Greek embori, reighi Sairofonisia aminda sirorusira. Nu nunda gagara ijoghako ainghae irá ghedo ghusira. Gagara ijoghako aikena sukaru asugetiri irei. Avori, evetu amo ira Iesu da ata duruda du fasedo, numo sonembedo sukaru ondari nunda gagara da jokáda ghe vose darigare dae sedo, benunu sisira. ");
INSERT INTO kpr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aminge benunu setiri, Iesu numokena sisira, “Ne namanenda gitofuri. Namane nendae ‘sinova’ seraera. God namanenda abua Abraham gategusira, a namanenda oro barago gategusira. Ava sedo, God da sasingu giti bayau mindaeteri. Nenda bayau budo sinodae fugarena amo, jo eveva iraeri. Ava sedo, ni redae sonembareni?” ");
INSERT INTO kpr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aminge sisira avata, evetuá mino eminge sisira, “Ai, Bajari! A nu beká resesa. Avata sasingu mo, bayau rirureoro susunda dudurugeraera amo, sinomanei bu mindiraera. Ava sedo, nandae joka edo sonembaso dae resena!” ");
INSERT INTO kpr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aminge setiri, Iesu sisira, “Ni beká resesa. Ava sedo, kamboda yasi gase! Ni geka mino eveva setesa ágido, na sukaru ondeno ninda gagara da jokáda ghe vose darigetira.” ");
INSERT INTO kpr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aminge setiri, nu jovereghe ira, kamboda buvurutusira. Buvurutusira amo, sukaru nu anakora vose darigetiri, gagara fase avíri gosusira. ");
INSERT INTO kpr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ainda amboda, Iesu eredo reighi Taiar dodo ira, reighi Saidon dodo, Frovensi Dekapoles, reighi isambu ghabu sovenisoveni ireira aminda sembira, uvu da teria javo Galilee aminda buvurutusira. ");
INSERT INTO kpr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Buviri, evetu genembo mendeni eredo, genembo dengoro irae, a beka guga ava, numokena bu fuseri. Bu fera, Iesu nunda ungoimi genembo da tamonda jighare dae benunu siseri. ");
INSERT INTO kpr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aminge setero ningido, Iesu genemboá budo, evetu genembo dodo nengae kikiako esike era, nunda ungo konsirari aimi genembo ainda dengoroda siregetiri teretiri, kosiva edo genembo da avivada dederusira. ");
INSERT INTO kpr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Amingedo, nu dombu utuda fainghuse, ghamo aseguse nenda gekaimi, “Efata!” sisira. Ainda tuka mo: “Afige!” ");
INSERT INTO kpr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aminge siri ainghae dabade, dengoro afigetiri, aviva vujegedo dambu etiri beka dambu sisira. ");
INSERT INTO kpr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Evetu genembo ava gi dudukughedo bunari beká buniseri, nu geka nunda bekaimi sisira aindae. Dudukughuse siseri, “Nu rea eraira amo, isambu eveva beká eraira. Nu taká eari dengoro afigeraira, a aviva vujege dambu eari geka seraera,” aminge siseri. Avata Iesu nu, erama osa seóro dae sise buregusira. Aminguse, nu umbu digarigo buregedo ghusira, avata ne nunda geka jo ningae, osa sido ya ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sifo aminda, evetu genembo sekago fera totorugedo irero, sifo etodaba naká dadabetiri, bayau dadabetiri gido, Iesu nunda ambo jimbikena kori setiri, numokena fera buvero sisira, ");
INSERT INTO kpr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Evetu genembo namonde sifo etodaba naká deinghuse bayau dadabetiri gido, na nendae joka erira. ");
INSERT INTO kpr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na ne oroko bayau tefo dirigaono natida yarera amo, ne emboro soroda ighoii sirivo arera. Mendeni mo, nenda reighi soka bekári. Ava sedo, na nange evetu genembo dirigareni? Namonde sonembaeteri!” ");
INSERT INTO kpr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aminge setiri, nunda ambo jimbi eminge siseri, “Namonde nange nange farava budo mutoro mindareri? Reighi eminda, evetu genembo a nati tefo ava sedo, bayau tefori.” ");
INSERT INTO kpr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aminge setero, Iesu nemokena ategi usira, “Nemokena farava nanjogo iri?” setiri, ne “7” siseri. ");
INSERT INTO kpr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Setero, Iesu natofo endada anumbaoro dae setiri, ne fuge anumbuseri. Anumbetero, Iesu farava 7 ava budo, God Afakena ‘aiyakoe’ sedo, jighi embebegedo, evetu genembo isambukena ghasoro dae, nunda ambo jimbikena futusira. ");
INSERT INTO kpr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Oka veveyako nanjogoko nemokena iritirisira ábarago, esimbugedo nunda ambo jimbikena futuse, soro aoro dae sisira. ");
INSERT INTO kpr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Soro etero, evetu genembo budo mindero inono usira. Inono etiri, mendeni dotero fasusira ava, rete budo kanda babaimi isambu 7 ava vendero bedo usira. ");
INSERT INTO kpr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Evetu genembo bayau risera amo, inono 4,000 avavagori. ");
INSERT INTO kpr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Etiri dadabetiri, Iesu evetu genembo dirigetiri ero ainghae dabade, nunda ambo jimbide ghakada+ vosedo, reighi javo Dalmanuta aminda sembiseri. ");
INSERT INTO kpr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Moses da Geka kaifa kakato+ mendeni Iesu kena era buvudo, Iesu de dabade beisiga useri. Nenda uju mo: numo deroro geka sembae sari ningido, nu bu koto ari dae sedo, eminge siseri, “Ni God da fakina aimi, tano aso gari dae resera!” ");
INSERT INTO kpr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Aminge setero ningido, Iesu nu dubo memaghae ghamo asegedo sisira, “Ne redae tano aono dae resevu? Na geka beká nemokena resena. Evetu genembo siroredo oroko endada irera emo, ne jo tano eni ururono gae arera,” ");
INSERT INTO kpr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aminge sedo, ne dodo nunda ambo jimbide dabade, jovereghe sembiseri. ");
INSERT INTO kpr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iesu da ambo jimbi farava dabako budo, farava mendeni kotae dodo sembero, ");
INSERT INTO kpr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesu nemokena sisira, “Ditii gi gogoghombevu! Moses da Geka kaifa kakato+ da yisti (yeast) a Kini (King) Herod da yisti ava imboe edo darigaovo dae resena,” Aminge setiri ningido, nunda ambo jimbi farava bekáva kotise, tofo tofo se nininguseri, ");
INSERT INTO kpr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","“Omo rejodae resi? Namonde farava kotae dotera aindae resira tanojo,” ne aminge bunise se nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ne rejodae se niningusera, ava kasama edo, Iesu nemokena sisira, “Ne redae faravadae resevu? Ne nangetiraimi geka da tuka anakora kasama ae irevu? Ne munju tefori! ");
INSERT INTO kpr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ne diti digoideri, ai? Ne dengoro iraeri, ai? Kote givu! ");
INSERT INTO kpr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Na giti farava ghabu soveni jighi embebegedo ghaseteno, gegenembo 5,000 mindero inono etiri, kanda babai nanjogo ava vevendusevu?” aminge setiri, ne “12” siseri. ");
INSERT INTO kpr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Setero, nu sekago sisira, “A na farava 7 budo jighi embebegedo ghaseteno, evetu genembo 4,000 mindero inono etiri, ne kanda babai nanjogo ava vevendusevu?” aminge setiri, ne “7” siseri. ");
INSERT INTO kpr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Setero, nu sisira, “Oroko ava kasama ereva, ai? Farava saono sirorari da fakina namokena irira. Ava kotaetevu! Avata na yisti (yeast) sise, na jo faravadae kotaeri. Na ijuga eko aindae kotise, yisti (yeast) seteni,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Aminge setiri dadabetiri, reighi Betsaida aminda tere darido vivituseri. Vitéro, evetu genembo mendeni ne genembo diti digoide ava unumbe budo fuseri. Bu fera, Iesu kena buvudo, Iesu nunda tamonda derari jebugare dae sedo, benunu siseri. ");
INSERT INTO kpr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Setero, Iesu nu genembo diti digoide ava ungoda budo unumbe, nengae kamboá dodo itako ambo soka iseri. Era fetedo, genembo da ditída kosiva edo nunda ungo ditída sire jijighuse, ategi usira, “Ni rejo eni eregosesa?” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","diti fuge gido sisira, “Na evetu genembo deinghero eregosena, avata nemo kau ika da kaugo ava deinghero eregosena.” ");
INSERT INTO kpr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Setiri, Iesu sekago nunda ungoi genembo ainda ditída sire jijighusira. Jighiri fuge giri, diti eveva etiri, nu roera isambu isagha etiri gosusira. ");
INSERT INTO kpr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Amingetiri, Iesu nu genemboá kamboda yare dae diriguse sisira, “Ni dambu ninda kamboda yasi! Erá jovereghe reighi teriada ya tereose!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ainda amboda, Iesu nunda ambo jimbide dabade reighi Sesaria Filipai aminda iseri. Ise, emboro soroda, Iesu nemokena ategi usira, “Sevu ningone! Evetu genembo nange erekoteri? Na mavejori?” ");
INSERT INTO kpr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aminge setiri, ne numokena mino eminge siseri, “Evetu genembo mendeni koteraera, John Bafataito Ari Kato ambarida ghe, jebugedo erariá seraera amo, nimori tano. A mendeni koteraera, God da feroveta Elijah jovereghe furariá seraera amo, nimori. A mendeni koteraera, God da feroveta eni ambarida ghe, jebugedo erariá seraera amo, nimori. Evetu genembo ne aminge kotise seraera.” ");
INSERT INTO kpr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aminge setero, Iesu sekago ategi usira, “Atá, ne nange erekotevu? Na mavejori? Sevu ningone!” aminge setiri, Peter mino sisira, “God namanenda ari ekoko kote doyari dae sise, Genembo eni dirigari furare dae sisira, amo nimori.” ");
INSERT INTO kpr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aminge setiri, erama nu mavejori ava osa seóro, evetu genembo ningeore dae sedo, Iesu buregusira. ");
INSERT INTO kpr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Amingedo, nu tuturo edo isagha beká dengoro induduse, nemokena eminge sisira, “Evetu genembo da kokotofu, fristi+ da babojegari, a Moses da Geka ijuga kakato,+ ne Evetu Genembo da Korokena+ mema tomanako mutoro itatamarira. Amo emingarera. Na ighagha edo saoro, evetu genembo mendeniimi na daoro ambudo, sifo etodaba naká dadabari ainda amboda, na sekago ambarida ghe jebuge erarena,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Isagha beká setiri ningido, Peter nu eredo Iesu budo nengae era ajagha fetedo, Peter tuturo edo nu dombuda sise, erá aminge seure dae sisira. ");
INSERT INTO kpr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Avata Iesu jovereghe nunda ambo jimbi gido, Peter dombuda sisira, “Satan, na darigaso dae resena! Resesa amo, jo God da kotari iraeri. Amo evetu genembo da kotariri!” ");
INSERT INTO kpr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iesu aminge sedo kori setiri, evetu genembo totorugusera, a nunda ambo jimbi fera numokena buvurutuseri. Buvero, Iesu nemokena sisira, “Mave nanda ambo jimbi edo, namonde dabade deinghari sarira amo, nu emingarira. Nunda uju ava dodo, nanda uju avanembo arira. Nu namo tumonduse, gitofudae jo oju ae, mema ã bouvu fufudo ya ambarira, a nu avori. A nane rea eraena ava, nu kau daba ava udo yarira. Amingarira amo, nu nanda ambo jimbi edo, namonde dabade deingharera. ");
INSERT INTO kpr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ainda tuka mo: mave enda einda gugua kotise a ambari dae oju use, na doyarira amo, nu sifo amboda ambarira. O mave nandae a nanda binodae sedo ambarira amo, nu amboda jebuga evovodae irari ava tuve barira. ");
INSERT INTO kpr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mave nu enda da gugua ava dubo ruruse, roera isambu nunda tofo sise, jebuga evovodae irari ava kosasaghedo ambarira amo, givu! ");
INSERT INTO kpr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aimi nu sonembarira, ai? Avata aimi, nu jo sonembae arira. ");
INSERT INTO kpr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A eni mo: mave nanda ijugadae meka gosuse, evetu genembo oroko endada irise, ari ekoko use God kotae eraera ainda dombuda, Evetu Genembo da Koro+ ighagha arira amo, amboda na God Afa da usasa jokáda, nunda aneya kakarade vose furarena ainda sifo aminda, na genemboá barago ighagha arena.” ");
INSERT INTO kpr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aminge sedo, nu nemokena sisira, “Na geka beká nemokena resena. Ne mendeni nanda dombuda fetireva emo, ne jo ambae irovo, God tofo mandi nunda fakinaimi evetu genembo kaifa ari da sifo foa buvari gareva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sifo 6 ava dadabetiri ainda amboda, Iesu nu eredo, Peter, James, a John budo, nemonde kikiako esike era, doriri mindafu eni aminda vitiseri. Doririda viti fetedo gosero, Iesu nu jovereghedo usasago beká ava usira. ");
INSERT INTO kpr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A nunda tamo asugari barago, janimbedo foyago beká ava usira. Amo, jo evevetu roera segheraera, ainda kaugo iraeri. Foyago beká ava usira. ");
INSERT INTO kpr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Etiri, Elijah Moses ghae, ne giti beká endada iriara ava, nengae fera isagha edo, Iesu de dabade geka se nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Se niningero, Peter, James, a John oju edo aindae, Peter geka rejo saetira ava bunise, Iesu kena sisira, “Bajari, namane budo ojesa aindae sedo, na ivuga erena. Ni nange erekotesi? Eveva mo, namane dobo etodaba naká eminda itore, eni nindae, eni Moses dae, ã eni Elijah dae itore, ai?” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Setiri, foroga fira nenda jiro agada fetiriri ainda jokáda, beka siri nininguseri. Amo eminge sisira, “Emo nanda dubo bari Mandiri. Nunda geka ava ningivu!” ");
INSERT INTO kpr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Setiri dadabiri ainghae dabade, ne dudukughedo diti fange, jovereghusera amo, Iesu nusuka fetiriri gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Gido, jovereghe, ne Iesu de dabade vose fuse, Iesu nemokena sisira, “Ne oroko rea geva amo, erá osa seove! Evetu Genembo da Koro+ daoro ambudo, ambarida ghe jebuge erarira ainda amboda osa sareva, a nu avori,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Setiri, ne rea gosusera ava kivo use, evetu genembo mendenikena jo osa saeri. Avata ne ainda tuka ava bunise, tofo tofo se nininguseri, “Nu ambarida ghe jebuge erariá resira da tuka mo, rejori?” ");
INSERT INTO kpr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Se nininguse, numokena ategi useri, “Moses da Geka ijuga kakato+ eminge seraera, ‘Elijah giti endada ireira amo, sekago jovereghe furarira ainda amboda, Genembo God mutari sisira amo, sirorarira.’ Amo redae aminge seraeri?” ");
INSERT INTO kpr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Aminge setero, Iesu nemokena sisira, “Moses da Geka ijuga kakato+ aminge seraera, ainda beká mo eviri. Elijah nu giti foama, Evetu Genembo da Koro+ dae emboro rerebuse, roera simbugaeti. Avata na nemokena eminge resena. Elijah nu anakora fusira. Fusira amo, God da Geka nundae rea resira ava, numokena sirorusira. Elijah jovereghe fira iriri, evetu genembo nu budo nenda uju ava use, mema mutero itatamusira. A kotugo, Evetu Genembo da Koro+ ava kote givu! God da Geka nundae nange resi? Ava givu! ‘Evetu Genembo da Koro+ foa buvari gido, evetu genembo nu imboe edo, mema a bouvu mutoro itatamarira.’ God da Geka nundae aminge resira amo, redae resi? Ava kotovo dae resena,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Setiri dadabetiri, Iesu, Peter, James, a John, nemonde vosera, nunda ambo jimbi mendeni doriri duruda dotutusera, aikena buvurutuseri. Buvurutuse, evetu genembo natofogo aminda totorugusera ava gosuseri. A kotugo, Moses da Geka ijuga kakato+ mendeni mo, Iesu da ambo jimbide dabade beisiga ero gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Evetu genembo totorugusera amo, ne Iesu fuge gosuse dudukughuseri. Dudukughedo, numokena sumbudo era, nati joká doruseri. ");
INSERT INTO kpr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Etero, Iesu nunda ambo jimbidae ategi usira, “Ne redae beisiga erevu?” ");
INSERT INTO kpr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aminge setiri, evetu genembo totorugusera ainda jokáda, genembo eniimi numokena sisira, “Ijuga Kato, nanda mandi nimokena budo ojeni. Nanda mandi resena emo, sukaruimi asugetiri irise, beka jo sae eraira. ");
INSERT INTO kpr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","A kotugo sifo mendeni, sukaruimi nunda tamonda asuge bu fugeari, endada du fasedo, yaiva tabetabe vovosurureari dika ghininji ghananja ghuse, ungo ata taintangheraira. Avori, nanda mandi emo nimokena bu ojena avata, ni jo tambae edo, ninda ambo jimbiimi bu fugoro dae setena ava, ne jo aoro inono ae etiri gido, na nimokena bu ojena resena.” ");
INSERT INTO kpr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aminge setiri, Iesu nemokena ghoghora sise sisira, “Ne sembae eraeva! Nangetiraimi ne tumondari tefori? Eveva mo: na ne doyaetena ava avori. Na erebunena. Avori, mandiá namokena budo fuvu gaone vae!” ");
INSERT INTO kpr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aminge setiri, mandiá numokena budo fera buvero, sukaru ai Iesu gosuse, anakora eredo mandiá fugetiri, endada du afufuse, ungo ata dadadaghiri, yaiva tabetabe vovosusira. ");
INSERT INTO kpr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Amingiri, Iesu numamokena ategi usira, “Ninda mandi mo, sifo reda sukaru numokena asugusi?” aminge setiri, numamo sisira, “Siroredo itako bajiri gido, asugusira. ");
INSERT INTO kpr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Asugedo, sukarui mandi emo dari ambare dae sedo, mandi bu fugeari, avaraka etoda dudo gheraira, o uvuda tifugheraira. Ni inono aresa amo, namanendae joka edo sonembaresa!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Setiri, Iesu mino numokena sisira, “Ni aminge sise, redae bouvu namokena fifiteresi? Nine tumonde! Mave tumondarira amo, nu roera isambu ari inono arira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Setiri nininguse ainghae dabade, mandi numamo beka fainghedo sisira, “Na itako tumonderena! Nine sonembaso, nanda tumondari fakina arira!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Aminge sise, evetu genembo natofogo fera tototo ghero gido, Iesu kovionoghae sukarukena sisira, “Nine eteso, mandi dengoro gajedo beka guga usira. Ava sedo, vose darigaso dae resena. Erama numokena sekago asugeose!” ");
INSERT INTO kpr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aminge setiri, sukaru koko sedo mandi bu fugetiri, dudo ungo ata eko beká edo dadadaghiri, fira buvurutusira. Buviri, mandiá ambari embo da kaugo usira. Amingiri gido, evetu genembo siseri, “Arie, mandi ambira!” siseri. ");
INSERT INTO kpr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Avata Iesu nu mandiá ungoda jighiri erorusira. ");
INSERT INTO kpr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ainda amboda nu nunda ambo jimbide dabade, evetu genembo dodo kambo eninda teteruseri. Teredo, ne kikiako anumbedo, nunda ambo jimbi ategi useri, “Namane ondera amo, nangetiraimi sukaru jo vose darigaeri?” ");
INSERT INTO kpr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aminge setero, Iesu sisira, “Jo tefo aovo, sukaru foa buvae arira. Ne na tumondedo banunguse, sukaru ondovo foa buvarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Reighiá dodo era, Frovensi Galilee aminda teredo sembiseri. Sembise, numo ambarira da geka amo, nunda ambo jimbikena ijugusira. Aindae sedo, numo isira da vasa ava, evetu genembo erá kasama eore dae sise imboe usira. Aminda ise, geka ava ijuguse eminge sisira, ");
INSERT INTO kpr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","“Evetu Genembo da Koro+ ava sandido, gegenembo mendeni da ungoda fitoro daoro ambarira. Avata sifo etodaba naká dadabari, God sari nu ambarida ghe jebuge erarira,” ava nunda ambo jimbikena setiri nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Gekaá sisira ainda tuka ava, ne buniseri. Bunedo, Iesu kena ategi e ningari oju useri. ");
INSERT INTO kpr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Frovensi Galilee sembise, emboro soroda, Iesu da ambo jimbi beisiga use, eminge se nininguseri, “Iesu nu namondeda giti jighariri. Avata nunda amboda mave namondeda giti jighari?” Aminge se nininguse, Iesu de dabade reighi Kaponiam buvudo, kambo eninda era teteruseri. Teredo, Iesu ategi usira, “Ne emboro soroda geka rea se ningevu?” aminge ategi usira. ");
INSERT INTO kpr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Avata ne beka dodo irero gido, Iesu nu anumbedo kori setiri, nunda ambo jimbi 12 ava numokena fera buvero sisira, “Mave nenda giti jighari ari sarira amo, nu tofo fitari vosari ne isambu da aghi kato use irarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aminge sise, nu mandi kitako eni ovinembe budo nenda soroda fifitusira. Fitido, nemokena sisira, ");
INSERT INTO kpr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mave, nanda javoda sasingu evavaga ava nati joká doruse, bu tavo arira amo, nu inono, namoá nati joká doruse, bu tavo arira. A kotugo, mave na nati joká doruse, bu tavo arira amo, nu inono, God Afa na dirigetiri fusena, numoá nati joká doruse, bu tavo arira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Setiri, John sisira, “Ijuga Kato, genembo eniimi ninda javoda sukaru bu fugutiri gido, namane nu doyare dae siseri. Ainda beká mo: nu jo namonde dabade deinghae eraira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Avata Iesu sisira, “Amo erá amingeove! Ainda susu mo: mave sukaru ondari buvarira, o ari fakina mendeni evia avaga nanda javoda arira amo, nu jo totoi dubo jovereghedo, nanda javo eko ae arira. ");
INSERT INTO kpr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mave namondeda gitofu jo sonembae eraira amo, nu kau, namonde sonembuse ariá eraira. ");
INSERT INTO kpr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na geka beká nemokena resena! Mave eminge kotarira, ‘Genembo omo, nu Iesu da ambo jimbi ava sedo, na sonembe uvu mutarena,’ aminge kotise, uvu nimokena mutarira amo, na amboda mino mutono barira. Jo kosasaghae arira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Setiri dadabetiri, nu sekago sisira, “Genembo mave foa, sasingako evavagoimi namo tumonderaera, ava derari, ari ekoko arera amo, derari kato amo, amboda mema mindafugo ava tambarira. Eveva mo: genemboá nanda sasingu jo derae irari, gitofu eni foama, ghamana mindafu budo, genembo ainda duboda dighido, bu fugari evada tifughari dadabaeti. O nu, sasingu namo tumonderaera evia, derari gido, God aindae mema mutari tambarira amo, eko a bouvugori. ");
INSERT INTO kpr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","A eni mo: ninda ungo aimi dara aso ari eko sirorarira amo, gafuge fugaresa. Eveva mo: ni ungo soveni taukaka iria ambudo, ya God kena jebuga tambaresa. O ni ungo etoto aminge irise, ari ekoko use iria ambudo, ya ari ekoko mino mutari vasa aminda teraresa amo, eko a bouvugori. Aminda teraresa amo, ni sifo ghousa ava avarakai avirurari ainda jokáda iraresa. ");
INSERT INTO kpr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","O ninda ata barago aimi dara aso ari eko sirorarira amo, gafuge fugaresa. Eveva mo: ni ata soveni taukakai iria ambudo, ya God kena jebuga tambaresa. O ni ata etoto aminge irise, ari ekoko use iria ambudo, ya ari ekoko mino mutari vasa aminda teraresa amo, eko a bouvugori. ");
INSERT INTO kpr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","O ninda diti aimi gosuse, ni ari eko aso sirorarira amo, gunumbe fugaresa. Eveva mo: ni diti soveni taukakai iria ambudo, ya God kena jebuga tambaetesi. O ni diti etoto aminge irise, ari ekoko use iria ambudo, ya ari ekoko mino mutari vasa aminda teraresa amo, eko a bouvugori. ");
INSERT INTO kpr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ari ekoko mino mutari vasa aminda, jifa ava ninda tamonda irari, ni avarakai sifo ghousa ava avirurari ainda jokáda iraresa. ");
INSERT INTO kpr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kau karaje bayau jokáda voseraira aminga ava, evetu genembo isambu avaraka jokáda vosarera. ");
INSERT INTO kpr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Karaje mo roera evevari. Avata karaje sasaka edo nunda janje dadaberaira aminga ava, genembo da dubo bari sembae arira amo, genembo nu eko arira. Ava sedo, ne tofo tofo dubo ruruse dubo jamaghae irivu!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu reighi Kaponiam dodo Frovensi Judia aminda teredo uvu Jordan sémbiri, evetu genembo sekago fera numokena totoruguseri. Totorugetero, nu natofo ijugedo ghusira, kau daba ava use sekago ijugusira. ");
INSERT INTO kpr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ijugiri, Moses da Geka kaifa kakato+ mendeni fera, Iesu geka sembae sari ningari dae sedo, ategi useri, “Namondeda agho dari nange resi? Se ningore! Genembo nunda evetu imboe edo doyaeti, ai tefo?” ");
INSERT INTO kpr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Aminge setero, Iesu mino nemokena sisira, “Moses rea aovo dae sedo gefusi?” setiri, ");
INSERT INTO kpr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ne siseri, “Moses da sifoda emingedo ghuseri. Genembo nunda evetu imboe edo doyari saetira amo, nu giti redae noaro doyaetira ava, gembu mutari noaro bu gosururari, ainda amboda noaro doyarira. Moses amingaoro dae sisira.” ");
INSERT INTO kpr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aminge setero, Iesu nemokena sisira, “Ne gogore a jiro fafakara ava sedo, Moses nu aminge gefusira. ");
INSERT INTO kpr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Avata tuturoda, God utu enda etiri sirorusira ainda sifoda, nu setiri, genembo evetughae siroruseri. ");
INSERT INTO kpr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","God da Geka eminge resira: ‘Aindae sedo, genembo noi numamo dodo evetu fitido, nengae tamo fisi dabako arera.’ aminge resira. Ava sedo, evetu genemboghae nenda irari, jo nunda nunda iraeri. Nenda irari dabakori. ");
INSERT INTO kpr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aindae sedo, God setiri dabade tatisera amo, jo evetu genemboi vujegari da kaugo iraeri. Ava sedo, genembo noaro jo doyae arira!” nu Moses da Geka kaifa kakatokena+ aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Setiri dadabetiri ainda amboda, kamboda teredo nunda ambo jimbiimi geka daba ava sekago numokena ategi useri. ");
INSERT INTO kpr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Etero, Iesu minonda sisira, “Genembo eni noaro dodo, nu ya evetu eni fitarira amo, nu evetu giti fifitusira aikena dara arira. Ainda javo yagerari. ");
INSERT INTO kpr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","O evetu nuvu dodo genembo enikena vai arira amo, ainda javo barago yagerari,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Evetu genembo mendeni nenda sasingu ava, Iesu nunda ungoi esimbugare dae sedo, budo fuseri. Budo fera numokena buvero gido, Iesu da ambo jimbi ghoghora siseri. ");
INSERT INTO kpr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu ava gido, janje eko usira. Etiri, nemokena sisira, “Sasingako emo erama buregeove! Dovu, namokena furore! Ainda tuka mo: ne ivuga use nanda geka ningi tumonderaera. Mave amingarira amo, nu God da natofo+ arira. ");
INSERT INTO kpr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Geka evia kotovo dae resena. Mave jo sasingako da kaugo ava ae arira, a kotugo God jo tumondae arira amo, nu God da natofo+ jo ae arira.” ");
INSERT INTO kpr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aminge sise, nu sasingu ovinembedo, ungo tamonda fifituse, ne isambu esimbugusira. ");
INSERT INTO kpr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu yari dae iri, genembo eni numokena sumbu buvudo kauboi dadarigedo bainghusira. Bainghedo, numokena ategi usira, “Ni ijuga kato evevari. Ava sedo, se ningone! Na rejo ava edo, jebuga evovodae irari ava tambareni?” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu sisira, “Ni redae nandae ‘eveva’ resesi? God nusuka numoá evevari. ");
INSERT INTO kpr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","God da Agho Dari ni kasama eresa: ‘Erama komana deóvo ambeure! Erama yagera eove! Erama bagia eove! Erama komana dederuse gungubo seove! Erama komana dederuse, nunda roera baetira ava, saghimbe beove! Nei nimamo kakara use, nenda geka ningido ghevu!’” ");
INSERT INTO kpr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iesu aminge setiri, genemboá mino numokena sisira, “Na siroredo gimasada irise, agho dari resesa ava kaifa udo refuana genembo eteni.” ");
INSERT INTO kpr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Setiri, Iesu nu fuge gosuse dubo ruruse sisira, “Dabako jo ae iresa. Ninda gugua a roera isambu oriro edo, ainda moni budo makasi embokena ghasaresa. Ghasedo, ni furaso namonde dabade deinghaore! Amingaresa amo, ni amboda ya gugua evevago utuda baresa.” ");
INSERT INTO kpr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aminge setiri, kotofuá dombu jovereghedo dubo memaghae, Iesu dodo isira. Ainda beká mo: genembo ainda gugua mo jo daba etoto iraeri. ");
INSERT INTO kpr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Genembo iri, Iesu jovereghe nunda ambo jimbi fuge gosuse sisira, “Evetu genembo susu iti fafode amo, foa God da natofo+ arikena fakarago bekári,” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","nunda ambo jimbi nunda geka ava ningido dudukughuseri. Dudukughetero gido, Iesu nu sekago nemokena sisira, “Arie, nanda sasingu! God da natofo+ ari mo fakaragori. ");
INSERT INTO kpr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sino fuka, javo kamero (camel), ava kote givu! Nu jo totoi ningu toka aminda tere ya sovenikena buvae arira. Avata nu aminda tere yari amo, raugakori. O evetu genembo guguade aimi God da natofo+ ari dae sarera amo, fakarago bekári!” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Setiri ningido, ne dudukughedo bunise ategi useri, “Aminge saresa amo, God da natofo+ mave ari?” ");
INSERT INTO kpr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ava setero, Iesu nemoá tataseguse sisira, “Amo jo, evetu genembo endada irera einda ari da kaugo iraeri. Ne jo totofo nenda fakinaimi, God da natofo+ ae arera. Avata God mo inonori. Nune roera isambu ari sirorarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Setiri, Peter tuturo edo Iesu kena sisira, “Kote gi! Namane nindae sedo, namanenda kambo a roera isambu dodo, namonde dabade deingheraera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Setiri, Iesu minonda sisira, “Na geka beká nemokena resena. Mave nandae sedo, nunda kambo, nunda nano namendi, nunda ghaghasovu, nunda noi numamo, nunda sasingu, o nunda enda doyarira amo, natofo a roera resena emo, aminga ava siroruse digutururari, nu enda eminda irise barira. Avata kotugo, natofo a roera setena ainghae dabade, nu dara a mema mindafugo tafuse itatamarira. Aminguse, nu jebuga evovodae irari ábarago sifo amboda tuve barira. ");
INSERT INTO kpr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Avata mendeni oroko kokotofu edo irera amo, ne sifo amboda vose sabua edo irarera. O mendeni oroko sabua edo irera amo, ne sifo amboda viti kokotofu edo irarera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesu nunda ambo jimbide dabade, Jerusalem aminda yari dae vitera, emboro soroda buvurutusira amo, Iesu nu giti iri, ne amboda ise, nunda ambo jimbi manamana useri. A evetu genembo mendeni amboda isera amo, ne oju useri. Amingetero, Iesu nunda ambo jimbi 12 ava budo esike era, numokena amboda reju sirorarira ava, sekago ijugusira. ");
INSERT INTO kpr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ijuguse sisira, “Ningivu! Namonde reighi Jerusalem yari dae viti refera. Reighi ominda, evetu genembo mendeniimi Evetu Genembo da Koro+ sandi bundedo, fristi+ da kokotofu a Moses da Geka ijuga kakato+ da ungoda fitarera. Fitoro budo, namonde Israel embo da gitofukena mutarera. ");
INSERT INTO kpr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mutoro, bu dere jise, nundae kosiva edo ambíimi de bu yama daoro ambarira. Ambudo, sifo etodaba naká dadabari ainda amboda, nu sekago ambarida ghe, jebugedo erarira,” ava ijugusira. ");
INSERT INTO kpr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ainda amboda, Zebedee da sasingu, James nengae John ghae, fera numokena buvudo siseri, “Ijuga Kato, ni namane rea uju erera ava, aso dae resera,” aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesu nemokena sisira, “Na nendae rea aono dae resevu?” ");
INSERT INTO kpr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aminge setiri, ne siseri, “Ninda usasaghae furaresa ainda sifoda, saso namane ninda giti jighari use, eni ninda ungo gimandukena anumbaeti, a eni ninda ungo umbefukena anumbaeti,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Setero, Iesu nu nange ambaetira ava kotise, nemokena sisira, “Ne rea benunu reseva ava, ne jo kasama use sae ereva. Ne erekoteva, na agha, Afa mutari bu fumbu rise, mema itatamarena aminga ava areva, ai? O gitofuimi bouvu a mema namokena mutarera aminga ava fumbareva, ai? Namo bafataito fakarago arera aminga ava, bafataito aoro itatamareva, ai? Amo, na nange nange mema itatamuse ambarena, aminga ava areva, ai?” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Setiri, ne siseri, “Ai, namane aoro inono arira,” setero, Iesu nemokena sisira, “Resevare! Ne agha nane fumbu rise mema itatamarena ava budo, kau daba aminga ava areva. A na nange bafataito arera amo, kau daba aminga ava, ne bafataito aoro itatamareva. ");
INSERT INTO kpr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Avata, mave nanda ungo gimandukena a umbefukena anumbarira ava, jo nane gategari da kaugo iraeri. God Afa mavejoá gategedo simbugetiri irera amo, ne aminda anumbarera,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Setiri, Iesu da ambo jimbi mendeni ghabu sovenisoveni aimi James nengae John ghae da geka ava ningido, janje ekoko useri. ");
INSERT INTO kpr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Etero, Iesu ne isambu kori setiri, fera numokena totorugetero sisira, “Nenda gitofu da kokotofu a babojegari mendeni fakina kakatori. Ne kovionoghae seoro, evetu genembo nenda sari avanembo ningido, ava eraera. ");
INSERT INTO kpr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Avata ne jo amingae areva. Mave nenda jokáda bajari ari dae sarira amo, ne isambu nune sonembarira. ");
INSERT INTO kpr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","A mave nenda giti jighari dae sarira amo, nu tofo sabua da ari ava use, ne isasambu nune kaifa arira. ");
INSERT INTO kpr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ainda susu mo: Evetu Genembo da Koro+ evetu genembo sonembuse nenda ari ekoko da mino futuse, ambari dae sedo fusira. Jo evetu genembo numoá sonembaoro dae sedo furaeri. Ava sedo, ne kau namongo ava areva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Setiri dadabetiri, emboroda ise Iesu nunda ambo jimbide dabade reighi Jericho buvu teredo jokáda ero, evetu genembo natofogoi fera nemonde dabade iseri. Era, reighi do buvari dae use, Timaeus da mandi javo Bartimaeus diti digoide amo, nunda bayau ombari dae sedo, monidae benunu sise, emboro dengesida anumbiriri tafuseri. ");
INSERT INTO kpr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nu aminda anumbirise, Nasareth embo genembo javo Iesu fira utua iri, ava setero ningido, nu tuturo edo koko sise sedo ghusira, “Arie, Iesu! Kini (King) David da Mandi God mutari sisira amo, nimori! Ava sedo, na joka eyo!” aminge siri, ");
INSERT INTO kpr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","evetu genembo digari nu beka doyare dae sedo bureguseri. Buregusera avata, nu jo itako doyaeri. Numo koko sise sekago kori sisira, “Kini (King) David da Mandi God mutari sisira amo, nimori! Ava sedo, na joka eyo!” ");
INSERT INTO kpr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Aminge setiri ningido, Iesu fetedo sisira, “Sevu furari gaone!” setiri, ne genembo diti digoide aikena kori sise siseri, “Dubo jamaghae ere! Iesu ni furaso dae resira,” aminge setero, ");
INSERT INTO kpr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimaeus nunda tamo asugari ava kosughe fugedo jaunghe eredo Iesu kena isira. ");
INSERT INTO kpr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ira buviri, Iesu numokena sisira, “Na rea aono dae uju eresi?” setiri, genembo diti digoideá sisira, “Ijuga Kato, saso nanda diti afigari sifo sevo gaeteni!” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu sisira, “Yasi! Ninda tumondariimi jebugetesi!” aminge siri ainghae dabade, diti anakora afigetiri, nu Iesu da amboda isira. ");
INSERT INTO kpr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iesu nunda ambo jimbide dabade era reighi Jerusalem utua use, reighi Betfeij nengae Bethany ghae aminda buvurutuseri. Betfeij nengae Bethany ghae resena emo, nu enda jiro fumbari javo Orivi seraera, ainda ganasa ifudari. ");
INSERT INTO kpr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Buvudo, nunda ambo jimbi etoto naká gategedo diriguse nemokena sisira, “Reighi omo eregoseva? Ominda ya buvudo, donki (donkey) da mandi eni buri edo dighero fetirira, ava tambareva. Donki (donkey) resena emo, mave jo viti aminda anumbe deinghae irira. Ava vujege bu furovo dae resena. ");
INSERT INTO kpr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Vujegururovo, mave nemokena bureguse, ‘Redae vujegerevu!’ sarira amo, eminge sevu, ‘Bajari nu uju erira. Itako deinghari dadabari, oroko bu foa eminda fitarera,’ aminge sevu!” ");
INSERT INTO kpr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Setiri ne era, donki (donkey) buri edo dighero emboro isaghada fetiriri, ava tambudo vujeguseri. ");
INSERT INTO kpr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Vujegero, evetu genembo aminda fetirisera aimi siseri, “Ne donki (donkey) redae vujegerevu?” ");
INSERT INTO kpr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aminge setero, Iesu nemokena rea sisira ava setero ningido, “avori” setero, donki budo iseri. ");
INSERT INTO kpr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Donki Iesu kena bu fera buvudo, nenda tamo asugari kosedo, javureghe donki da gukada asugetero, Iesu viti anumbusira. ");
INSERT INTO kpr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Anumbedo javi edo iri, natofo digari nenda tamo asugari ava kosedo emboroda dudo ero, nu ainda etoda fetedo isira. A mendeni era, vare jokáda ika igi gafugedo bu fera, numoá kakara ari dae, emboroda dudo ero ainda etoda isira. ");
INSERT INTO kpr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Evetu genembo giti fete isera, a mendeni ambo gaedo fusera aimi, koko sise a nati joká doruse eminge siseri, “Orokaiva! Orokaiva! David da Mandi, God mutari sisira amo, nimori! Buvuruteresare! Bajari da javoda refira aindae, sakai saore! Orokaiva!” aminge koko sise nati joká doruse iseri. ");
INSERT INTO kpr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aminguse, reighi Jerusalem aminda era teredo, Iesu ira God da kambo+ aminda teterusira. Teredo indiro iri, ungobu etiri gido, nu do buvudo, nunda ambo jimbi 12 ainde dabade jovereghe reighi Bethany aminda iseri. ");
INSERT INTO kpr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ne sifoghae eredo, reighi Bethany dodo ise, Iesu nu emboro soroda ighoi usira. ");
INSERT INTO kpr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Edo, nu diti fuge ika kayuyu igighae itako soka fetiriri gosusira. Iesu nu, igi yaughiri gido, beká tambari dae sedo isira. Ira buvurutusira amo, jo jighae iriri ava gosusira. Ainda beká mo: beká jighari da sifo jo foa buvaeri. ");
INSERT INTO kpr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Avori, beká jo tambae edo, Iesu ika aikena sisira, “Mave jo amboda foa ninda beká tambu mindae arira,” aminge siri, nunda ambo jimbi nininguseri. ");
INSERT INTO kpr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ningero dadabetiri, ne era Jerusalem aminda buvurutuseri. Buvudo era, God da kambo+ aminda teredo, Iesu nu, evetu genembo oriro use, a ofuse irisera ava, isambu ondiri buvurutuseri. A gegenembo moni oriro edo ghusera, ainda ghagha isambu jighi jovereghusira, a gegenembo rika ribo oriro edo moni budo ghusera, nenda avo anumba ábarago jighi rokombusira. ");
INSERT INTO kpr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ainghae dabade, erama evetu genembo totofo nenda roera eni fumbu God da Kambo+ jokáda tere sembi yeore dae buregusira. ");
INSERT INTO kpr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aminguse, nu nemokena dengoro induduse sisira, “God setiri nunda geka jokáda geka eni gembero irira amo eviri: ‘Nanda kambo mo, evetu genembo isambu endada irera, nenda banungari da kambori.’ God aminge sisira. Avata ne teredo amingevo, kambo emo kau tafasara kakato da dobo a beku da kau avaga edo irira,” ");
INSERT INTO kpr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aminge setiri, fristi+ da kokotofu a Moses da Geka ijuga kakato+ ava ningido, numo daoro ambare dae sedo, tuturo edo emboro kakova useri. Evetu genembo isambu nunda ijuga ningido dudukughusera aindae sedo, ne nundae oju useri. ");
INSERT INTO kpr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Avori, tumba jiriri, Iesu nunda ambo jimbide dabade reighi dotutuseri. ");
INSERT INTO kpr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sifo ataeghae beká, ne emboroda ise, ika kayuyu Iesu simbora usira ava gosuseri. Ikaá avi gharasa edo vose besisighae dabade avisira ava gido, ");
INSERT INTO kpr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter nu, Iesu rea usira ava kotise, Iesu kena sisira, “Ijuga Kato, gi! Ika kayuyu nine sife simbora umutasa, gharasa edo avi dadabedo fetirira!” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesu nemokena sisira, “Na geka beká nemokena resena! God tumondevu! ");
INSERT INTO kpr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mave nunda dubo jokái tumonde gogoghombuse, ‘Na rea sarena amo, sirorarira,’ kotarira amo, God nu sonembari sirorarira. A gido, mave tumonduse doriri ovia gosuse, ‘Darige yasi, evada tifughase!’ sarira amo, God sonembari, doriri omo ya evada tifugharira. ");
INSERT INTO kpr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ava sedo, na eminge resena: ne God tumonduse rejodae benunu sise banungareva amo, ava sirorari bareva. ");
INSERT INTO kpr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","A eni mo: ne rejodae banunguse, mave nemokena dara eni usira, ava kotareva amo, ne daba aminda, nenda komana da ari ekoá kote doyareva. Ainda susu mo: amingareva amo, Nimamo utuda irira, numbarago nenda ari ekoko kote doyarira. ");
INSERT INTO kpr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","O ne komana da ari ekoko jo kote doyae areva amo, Nimamo utuda irira ábarago, nenda ari ekoko jo kote doyae arira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Setiri dadabetiri, ne era reighi Jerusalem aminda sekago teteruseri. Teredo, nu ira God da Kambo+ aminda buvudo tere aminda deinghiri, fristi+ da kokotofu, Moses da geka ijuga kakato+, a evetu genembo da babojegari, nemonde dabade fera numokena buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Buvudo siseri, “Se ningore! Mave setiri ni saramana emo eresi? Ni maveda javoda geka emo vironu resesi?” ");
INSERT INTO kpr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aminge setero, Iesu nemokena sisira, “Na nemokena ategi dabako arena. Einda mino sareva amo, na maveda javoda ojena amo, isagha saono ningareva. ");
INSERT INTO kpr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sevu ningone! John Bafataito Ari Kato, maveda javoda evetu genembo bafataito edo ghusi, evetu genembo da javoda ai, God da javoda?” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Setiri, ne tofo tofo beisiga use, se nininguseri, “Namonde kau nange nange sareri? Namonde, ‘God da javoda bafataito edo ghusira,’ sarera amo, nu, ‘Ne redae John jo tumondae usevu?’ sarira. ");
INSERT INTO kpr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","O kotugo, namonde, ‘Evetu genembo da javoda bafataito edo ghusira,’ sarera amo, avose natofo namondedae nange areri?” aminge siseri. Ainda tuka mo: evetu genembo isambu kotisera amo, ‘John nu God da feroveta eniri,’ Ava sedo, fristi+ da kokotofu, Moses da geka ijuga kakato+, a evetu genembo da babojegari, erama evetu genembo ne deore dae sise oju edo, Iesu ategi usira da mino sari buniseri. ");
INSERT INTO kpr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bunise, Iesu kena siseri, “Namane erebunera,” aminge setero, Iesu sisira, “Avori, nambarago maveda javoda saramana eraena, nemokena jo saono ningae areva,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Aminge sedo, Iesu tuturo edo nemokena kasiaimi sisira, “Kasia eni ningovo dae resena. Genembo eni aira vare simbugedo vaini da asi ava govetira. Govedo, furu dighi birurughetira. Ainda amboda, nu asi vuji da muka ava simbari vosari bari dae sedo, bako ghambira. Ghambudo, kaifa kakato da vasa iti vitira. Itiri dadabetiri, nunda vare amo evetu genembo mendeni saramana use moni futururoro bari dae sedo, mutira. Evetu genembo aimi, vare ava kaifa ero, nu reighi eninda aira. ");
INSERT INTO kpr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Avori, asi vuji bambari da sifo buviri gido, vare numamoá nunda saramana kato eni dirigetiri, vare da kaifa kakatokena aira. ");
INSERT INTO kpr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Aira buviri, vare kaifa kakato ne saramana kato aikena roera eni jo mutae, nu sandi dedo ondero jovereghe aira. ");
INSERT INTO kpr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Amingetero gido, vare numamo sekago, nunda saramana kato eni dirigetiri aira buviri, vare kaifa kakato numbarago doruse jiroda je basetero ororo buvurutiri, nu dere jise avoda doruseri. ");
INSERT INTO kpr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Amingetero ainda amboda, vare numamo nunda saramana kato eni dirigetiri aira buvira. Buviri, ne numoá detero ambira. Aminguse irero, vare numamo nunda saramana kakato mendeni mendeni dirigeari ya ghedo gheteri. Ya buveoro gido, vare kaifa kakato nunda saramana kakato mendeni dedo ondido gheteri, mendeni deoro ambudo gheteri. ");
INSERT INTO kpr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Amboda beká mo, vare numamo tofo nunda mandi nusukako fetetira. Fetedo iriri, numamo nu dubo bu gogoghombedo, numoá diriguse eminge kotetira, ‘Avose, nanda mandiva kakara arera tanojo,’ aminge kotise, nunda mandi ava dirigetiri aira. ");
INSERT INTO kpr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Avata vare kaifa kakato ne numoá gosuse, tofo tofo se ningeri, ‘Mandi omo, vare einda numamo da mandiri. Amboda vare emo, nune barira. Ava sedo fuvu, namonde nu daoro ambari, vare emo namondeda tofodae baore!’ aminge se ningido, ");
INSERT INTO kpr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ne eredo, mandi amo vare jokáda sandi detero ambiri, nunda tamo jumbu budo aera buvudo, vare isaghakena fugeteri. ");
INSERT INTO kpr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Avori, kote givu! Vare numamoá nange ari? Saono ningove! Nu foama vare kaifa kakato ava dari amboro, vare amo budo evetu genembo mendenii kaifa aoro dae sedo mutarira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Aminge sedo, nu tofo numoá ijuguse, kasia da tuka ijugari dae use sisira, “God da Geka emo tegutusevu tanojo: ‘Ghamana eni, kambo itari kakatoi imboe edo fugutusera ava, Bajari nune budo tutumbidae sedo fiti simbugedo, aminda tuturo edo, nunda kambo itari dae erira. ");
INSERT INTO kpr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Emo Bajari da ariri. Namane gido dudukugherera,’ God da Geka amo tegutusevu, ai?” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Setiri ningido, fristi+ da kokotofu, Moses da geka ijuga kakato+, a evetu genembo da babojegari, ne Iesu sandi bundari dae kotiseri. Ainda beká mo: ne kasama useri, Iesu nendae sedo vare da kasia omo sisira. Nu sandaetera avata, ne natofo da kotari aindae oju edo, nu dodo iseri. ");
INSERT INTO kpr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Isera ainda amboda ne, Moses da Geka kaifa kakato+ mendeni Herod da ambo jimbi mendeninde dabade ava dirigetero, Iesu derari dae iseri. Nenda uju beká mo: Iesu geka sembae sirurari ningido, nu bu koto ari dae uju useri. ");
INSERT INTO kpr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aindae era Iesu kena siseri, “Ijuga Kato, namane kasama erera, ni geka beká avanembo sifo ghousa ijugeraesa. Ni evetu genembo da kotari amo jo oju ae use, God da uju avanembo ijugeraesa. Ava sedo, se ningore! Namondeda Agho Dari nange resi? Namondeda gitofu Rome embo da kotofukena takesi ombarera, ai tefo? Ava se ningore!” ");
INSERT INTO kpr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aminge setero, ne numo derari dae kotido fusera ava kasama edo, Iesu nemokena sisira, “Ne gungubo kakatori! Ne redae na dedererevu? Moni eni budo fuvu gaoneta!” setiri, ");
INSERT INTO kpr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ne moni dabako budo fera ijuguseri. Ijugetero gido, Iesu ategi usira, “Moni+ tamonda, dangio a javo emo, mavedari?” aminge setiri, ne siseri, “Rome embo da kotofu, namonde Caesar seraera, nundari.” ");
INSERT INTO kpr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Setero, Iesu nemokena sisira, “Avori, Caesar da tofo amo, Caesar dae mutuvu bare! A God da tofo amo, God dae mutuvu bare!” aminge setiri, ne ningido buniseri. ");
INSERT INTO kpr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jusi embo da mendeni aindae, Sadusi embo+ seraera. Sadusi embo+ resena emo, nenda kotari: ambari embo jo sekago jebugedo erae arera. Avori, Sadusi embo+ mendeni Iesu kena fera buvudo ategi useri, ");
INSERT INTO kpr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ijuga Kato, God setiri, Moses nu namondeda Agho Dari emo gefusira: ‘Genembo mave evetu fitari, mandi sasingu jo sirorae iroro, genemboá ambari nunda rori irarira amo, nunda ambo bego eniimi, roriá fitarira. Genembo ambududurusira, ainda veka sirorare dae sedo, amingarira.’ ");
INSERT INTO kpr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Avori, kiki eni sari dae erera. Ningi! Vide jamena isambu 7 ava siroredo iriari. Bego mo, nu evetu fifitusira ava, sasingu eni jo sirorae irero, nu ambududurusira. ");
INSERT INTO kpr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ambiri, rori amo nunda diroruimi fifitusira. Fifitusira ava, sasingu eni jo sirorae irero, nu ambududurusira. ");
INSERT INTO kpr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aminguse, fifitero refara, ambo nemboi bu fitido ireira ambududurusira. Ainda amboda beká, roriá ambududurusira. ");
INSERT INTO kpr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Amboda evetu genembo isambu jebuge erariá, seraesa. Avori, se ningore! Gegenembo isambu 7 aimi evetuá fifituseri. Ava sedo, iria edo, erari da sifoda, evetuá maveda evetu ari? Bego aindari, o ambo aindari, ai maveda evetu ari? Ava se ningore!” ");
INSERT INTO kpr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aminge setero, Iesu nemokena sisira, “Ne sembae beká ava erekoteva. Ainda tuka mo: ne God da Geka rea resira, a God da fakina ava, ne erebuneva. ");
INSERT INTO kpr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Evetu genembo ambarida ghe jebuge erarera ainda sifo aminda, ne kau aneya da kau aminga ava irise, genembo evetu jo fitae arira, a evetu genembokena jo vai ae arira. ");
INSERT INTO kpr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Kotugo, ambari embo ambarida ghe jebugedo erarera, ainda geka eni sari dae erena. Ningivu! Ne God da Geka Moses da buku jokáda irira, a tegutusevu, ai? Ika orobu veveyako ainda jokáda avaraka gambudo bubura iri Moses gosusira amo, God nu Moses da nombuamane anakora sirivo usera aindae, geka evia Moses kena setiri nunda bukuda gefusira: ‘God, nembuamane, Abraham, Isaac, a Jacob anakora endada irise tumonduse iriara, a kotugo oroko tumonduse irera amo, namori.’ God aminge sisira aindae, namonde kasama erera: ambari embo mo jo amboro dadabaeri. ");
INSERT INTO kpr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ava sedo evetu genembo isambu, ambari embo a jebuga embo isasambu, God da dombuda jebuga irera. Ava sedo, ambari embo jo jebugedo erae ariá koteraeva amo, ne sembae koteraeva,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moses da Geka ijuga kato+ eni fira buvudo, ne geka se niningero, ava niningusira. Iesu nemokena mino eveva beká sisira ava ningido, nu Iesu kena ategi usira, “God da Agho Dari jokáda, geka mindafu beká mo, ningiavori?” sisira. ");
INSERT INTO kpr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Setiri, Iesu mino sisira, “Mindafu beká mo eviri: ‘Israel embo, nemokena resena, ningivu! Bajari God nusuka numoá namondeda Bajariri. Namondeda Bajari God kena ninda dubo, fakina, a kotari isasambuimi futuse, nusuka numoá dubo bu gogoghombaresa!’ ");
INSERT INTO kpr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Agho Dari teria setena, ainda kaugo eni mo eviri: ‘Ni tofo dubo buraesa, kau daba aminga ava, ninda komana barago dubo baresa!’ Agho Dari etoto resena emo, mindafu bekári, mendeni mo veveyakori,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Setiri, Moses da Geka ijuga katoimi sisira, “Ijuga Kato, ni geka se gogoghombetesi! ‘God nu dabakori, eni tefori.’ A nu geka bekári. A kotugo, ‘namonde dubo, fakina, a kotari isasambuimi futuse, nu dubo bu gogoghombarera,’ a ‘namonde totofo dubo buraera, komana kau daba ava dubo barera,’ amo, mindafu bekári. ");
INSERT INTO kpr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","O God kena banunguse, nundae sedo, namondeda sino fuka isambu de dungoro avaetira amo, ijoghakori,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nu dubo kotise geka amo sisira, ava gido, Iesu numokena sisira, “Ni God kena aesa utua etesi!” Ainda amboda, mave numokena sekago ategi ari oju useri. ");
INSERT INTO kpr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu nu God da Kambo+ aminda ijuguse sisira, “Moses da Geka ijuga kakato+ ne seraera, ‘God evetu genembo sonembuse, Genembo eni mutari dae sisira amo, David da mandiri.’ Amo nange reseri? Kote givu! ");
INSERT INTO kpr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David nu tofo mandi, Asisi Kakara geka numokena siri ningido gefusira: ‘Bajari nu nanda Bajarikena sisira, “Fu, nanda ungo gimandukena anumbiraso, ninda gitofu ninda fakina ava gosuroro, ne de bundedo bu foama, ninda ata duruda fitono fafasaore!” ’ Bajari aminge setiri, David gefusira. ");
INSERT INTO kpr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Avori, genembo mo, nunda sasingu da bajariri. Mandi eni jo viti numamo da bajari bae aeti. Ava sedo David, Genembo amboda furarira ava kotise, ‘Nu nanda Bajari,’ sisira amo, nu jo nunda mandi ava kotise saeri. Nu Genembo aindae igheghi use, nunda Bajari arira ava sise sisira. Ava sedo, geka Moses da Geka ijuga kakatoimi seraera amo, jo inono iraeri,” aminge siri ningido, evetu genembo totorugusera amo, ne ivuga useri. ");
INSERT INTO kpr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Amingero, nu nemokena ijuguse sisira, “Moses da Geka ijuga kakatodae+ eminge resena. Nenda irari ava ijuje gi gogoghombevu! Ne emingeraera. Natofoi nemoá sakai sise kakara aoro dae sedo, nenda tamo asugari koburu edo deingheraera. Deinghudo ya ombari vasada buvuruturoro gido, evetu genembo tumoi bainghedo, nemoá kakara use ategi e gogoghombaoro dae uju eraera. ");
INSERT INTO kpr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","A nenda uju mo: ne kirumo a banungari dae use, totofo nenda fisi da uju ava kotise, anumbari vasa eveva vanembo gategeraera. ");
INSERT INTO kpr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ne roriri dederuse, nenda kambo a gugua ava nenda tofodae ruruse, natofo nemoá gido sakai saore dae sise, ya God da Kamboda+ tere fetedo ghousago banungeraera. Avata God mo, nu aindae sedo sifo amboda nemokena mino eko beká ava mutarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Setiri dadabetiri, Iesu nu God da Kambo+ jokáda deinghedo ira, joba mutari da rooroá gido, nu sembira vasa sovenikena anumbusira. Anumbirise, evetu genembo fera moni fifitero gosusira. Evetu genembo guguade, moni teriago bu fera fifitero gosusira. ");
INSERT INTO kpr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ainda amboda, rori eni, makasi bekári, aimi fira moni+ ingigago veveyako beká etoto naká, ainda inono 10 toea da kaugo, ava fifitiri gosusira. ");
INSERT INTO kpr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Gido, Iesu kori setiri, nunda ambo jimbi fera buvu fetetero, nemokena sisira, “Na nemokena geka beká resena. Rori eregoseva omo, nu makasi bekári. Avata nu joba fitira amo, teria bekári. Mendeni da mo, jo rori aimi fitira, ainghae inono iraeri. ");
INSERT INTO kpr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ainda beká mo: mendenikena gugua tomanakori, avata ne itako fiteri. Rori omo, tefo bekári, avata nu isambu fitira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu nu javi edo ira, God da Kamboda+ ghedo yari dae iri, nunda ambo jimbi eniimi Iesu kena sisira, “Ijuga Kato, God da Kambo+ evia fuge gi! Ghamana babai oimi budo, God da Kambo+, nunda vasa mendeni ainde dabade itutusera amo, evevago bekári! Eregosesa?” ");
INSERT INTO kpr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aminge setiri, Iesu numokena sisira, “Ni ghamana babai evia gosuse resesa, ai? Na nimokena eminge resena. Gitofuimi foama kambo omo de bejoro, oinda ghamana aveverege vose dadabarira ainda amboda, ghamana eniko jo nunda vasa ireira, aminda jo irae arira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesu nu enda jiro fumbari javo Orivi, aminda ira, God da Kambo+ sovenikena anumbiriri, Peter, James, John, a Andrew kikiako fera numokena ategi useri, ");
INSERT INTO kpr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ni God da Kambo+ bejarera, setesa amo, nanjigo areri? Ainda sifo ava namane nange kasama aeteri?” ");
INSERT INTO kpr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aminge setero, Iesu sisira, “Diti gosuse kaifa evu! Erama, mave nemo dederuse gungubo sarera, ava tumondeove! ");
INSERT INTO kpr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ainda tuka mo: evetu genembo digari foama gungubo sise, ‘Evetu Genembo da Koro+ namori,’ sise, natofo deroro nemoá tumondarera. ");
INSERT INTO kpr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tataya ururoro ningareva, a soka beká isoro ururoro, ainda bino ava ningareva. A nu sirorarira avata, erá oju eove! Ainda beká mo: aminge siruroro ningareva, avata enda emo jo sifo aminda dadabae arira. ");
INSERT INTO kpr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Natofo mendeni mendeni a gavana mendeni mendeni eredo, tofo tofo isoro ururoro ningareva. Endada, dumo fururari baimara eko beká ava sirorurari itatamedo ghareva. Kau, evetu tamo bouvu edo iriama edo, mandi sasingu javi urureari mema itatameraira aminga ava, enda da mema sifo aminda tuturo arira.” ");
INSERT INTO kpr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Diti gosuse, totofo kaifa evu! Ainda beká mo: evetu genembo mendeniimi foa, ne sandi budo yaoro, nenda dengoro indari kambo+ mendeni aminda terovo koto arera. Koto use, ne ambíi daoro mema tambareva. Ne namo tumonderaeva aindae sedo, ne sandi bu yaoro, gavana a kini (kings) mendeni da dombuda fetovo koto arera. Koto ururoro, ne nanda Bino Eveva ava osa sirurovo, nenda natofode ningarera. ");
INSERT INTO kpr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nanda Bino Eveva evia saovo enda da natofo isambu ningoro dadabari ainda amboda, enda emo dadabarira. ");
INSERT INTO kpr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Avori, ne koto ari da sifoda, geka rea sareva aindae, erá teria futo koteove! Ainda beká mo: sifo aminda, Asisi Kakara aimi ijugururari sareva. Ne totofo nenda kotari ava jo sae areva. Asisi Kakara aimi sonembururari nunda geka ava sareva. ");
INSERT INTO kpr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Sifo ava fururarira amo, gegenembo nenda jamena ava sandi mutoro daoro ambarera. Kau daba aminga ava, gegenembo nenda sasingu ava sandi mutoro daoro ambarera. A sasingu barago, noi numamo ava sandi mutoro daoro ambarera. ");
INSERT INTO kpr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ne namoá tumonderaeva aindae sedo, evetu genembo isambu ne imboe arera. Avata mave fakina edo, namoá tumonduse jo ighagha ae iria ambarira amo, nu jebuga evovodae irari ava tuve barira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(Iesu da geka eregefena evia, mave teguterira amo, nu ningido kote simbugare dae sise resena.) Iesu eminge sisira, “Amboda, roera eko beká ava bu foa fitoro, God da Kambo+ joká aminda fetirise, aimi bebeta arira. Ava bu foa fitoro fetirari, ne frovensi Judia eminda irise gareva amo, ne eredo sumbu yasivu doriri ominda jungove! ");
INSERT INTO kpr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mave nunda ofoda anumbirari, sifoá foa buvari garira amo, nu jo ere kambo jokáda, roera eni bari dae jo terae arira. Nu taká sumbarira. ");
INSERT INTO kpr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","A mave vareda saramana ururari, sifoá foa buvarira amo, nu jo nunda tamo asugari bari dae sedo, jovereghe kamboda yae arira. Nu taká sumbarira. ");
INSERT INTO kpr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mará! Na, evevetu mave sifo aminda tamo bouvu edo irarera, aindae dubo mema erena. Ainda beká mo: evevetu sifo aminda tamo bouvu edo irarera, o sasingu veveyako unduse ami futuse irarera amo, ne sumbari dae ató barago use, mema mindafugo ava itatamarera. ");
INSERT INTO kpr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","God kena banungururuvu, erama dara resena evia, yaura teria da sifo aminda siroreure! ");
INSERT INTO kpr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ainda beká mo: mema a bouvu, sifo aminda sirorarira amo, teria bekári. God setiri enda sirorusira, ai tano ghedo ojira orokoé, aminga ava jo sirorae irira. Kotugo mema a bouvu resena emo, ainda amboda barago, jo sekago aminga ava sirorae arira. ");
INSERT INTO kpr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Avata jo ghousa irae arira. God setiri fetirira amo, eviri. Dara furarira amo, jo ghousa irae arira. Ghousago iraetira amo, evetu genembo isambu sirivo aeteri. Avata God nunda natofo gategusira, nendae sise sari, dara furarira amo, jo ghousago irae arira. ");
INSERT INTO kpr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Sifo aminda, mave nemokena, ‘God namondeda ari ekokodae Genembo eni mutari sisira amo, eviri. Fuvu gaove!’ sarira. O, ‘Numo omindari. Yasivu gaove!’ sarira amo, erá tumondeove! ");
INSERT INTO kpr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ainda beká mo: gegenembo mendeni eredo, foa gungubo sise, ‘Genembo eni God mutari sisira amo, namori,’ sarera. Nemo feroveta gungubo kakatode dabade foa, God da natofokena nange edo gido dederururoro, ‘bekáva’ sise, nemoá tumondaeteri. Aminguse, ne tano a ari mendeni mendeni ururoro, evetu genembo ne jo gae iriara ava, nenda gitida sirorurari garera. ");
INSERT INTO kpr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ava sedo, diti gosuse totofo kaifa evu! Rea amboda sirorarira ava, jo sirorae iriri, orokoá seteno niningerevere.” ");
INSERT INTO kpr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","“Dara setena dadabarira ainda amboda mo, utu da fakina raugo edo javi ururari, iji da usasa dadabururari, inua jo janimbae arira. A damana utuda dore vosarira. ");
INSERT INTO kpr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ainda amboda, evetu genembo diti fainghedo, Evetu Genembo da Koro+ vose fururari garera. Nu foroga jokáda, fakina tomanako a usasaghae vose fururari garera. ");
INSERT INTO kpr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Gosururoro, Evetu Genembo da Koro+ nunda aneya dirigari, endada vose foa, iji vitarikena a vosarikena, kotugo foriforimanakena a yavatakena, aminda yama, nunda natofo gategusira, ava unumbe budo yarera.” ");
INSERT INTO kpr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ika kayuyu da ijugaboro ava kasama evu! Ika amo tuturo edo, tunó seka yaughururari gareva amo, ne kasama areva, ‘Borija da sifo buvira ava sedo, beká jighari da sifo utua erira.’ ");
INSERT INTO kpr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kau daba aminga ava, roera setena ava sirorurari gareva amo, ne kasama areva, ‘Sifo utua iri, tuturo ari dae erira.’ ");
INSERT INTO kpr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Geka evia kotovo dae sise resena! Roera setena ava sirorurari, evetu genembo oroko siroredo endada irera, mendeni garera. Mendeni ambarera, avata mendeni jo ambae iroro sirorari garera. ");
INSERT INTO kpr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Utu a enda dadabarira, avata nanda geka jo dadabae arira, evovodae irarira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Aminge sedo, sisira, “Avata Evetu Genembo da Koro+ nanjigo jovereghe furarira, ainda sifo amo, mave jo kasama aeri. Aneya ne jo kasama aeri, a God da Mandi barago, nu jo kasama aeri. God Afa nusukako kasama erira. ");
INSERT INTO kpr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kaifa use irivu! Ainda beká mo: Evetu Genembo da Koro+ nanjigo jovereghe furarira ava, ne berefo bekári. ");
INSERT INTO kpr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sifo amo kau emingori. Genembo eni esa yari dae kotetira. Kotedo, nunda saramana kakato aikena saramana nunda nunda ijugetira. Aminguse, nu guro kaifa katokena setira, ‘Namoá kaifa gigita use iri! ");
INSERT INTO kpr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ainda susu mo: ni kambo numamo nanjigo jovereghe furarira ava, erebunesa. Nu ungobughae, tumba soroda, sifoghae, o isonga furarira ava, ni berefori. ");
INSERT INTO kpr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ni aviruraso na jovereghe furarena amo, jo eveva iraeri! Ava sedo, kaifa e gogoghombe!’ aminge setira. ");
INSERT INTO kpr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A kambo numamoá nunda guro kaifa katokena geka rea sisira amo, na daba ava nemokena resena. A na rea nemokena resena emo, evetu genembo isambukena barago kau daba ava resena, ningivu! Namoá kaifa gigita use irivu!” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jarige Yari da Kirumo+ a Yisti Kanangara Ari da Kirumo+ jo ae irise, sifo etoto ainda gitida, fristi+ da kokotofu a Moses da Geka ijuga kakato+ tuturo edo, Iesu ufena sandi daoro ambare dae emboro kakova useri. ");
INSERT INTO kpr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Aminguse, eminge siseri, “Namonde Jarige Yari da Kirumo+ da sifo aminda, jo ae arera. Ainda tuka mo: amingarera amo, natofo tomanako kirumodae totorugarera aimi, janje ekoko edo titigho arera tanojo,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu nu ira, reighi Bethany aminda buvudo irise, genembo javo Simon Refero, ainda kamboda teterusira. Tere anumbedo bayau riri, evetu eni usu da muka javo nard ava budo fira, Iesu kena teterusira. Botoro ghamana javo arabasta aimi usera, ainda jokáda usu ava vendero iriri budo fusira. Usu muka budo fusira amo, munonderi, a jo uvughae baingoro aeri; ava sedo nunda mino mo, teria bekári. Evetuá teredo ira, Iesu kena buvudo botoro jighi bejedo, usu nard aimi Iesu da jiroda averegusira. ");
INSERT INTO kpr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Averegetiri dadabetiri gido, evetu genembo mendeni aminda irisera aimi, janje ekoko edo, tofo tofo se nininguseri, “Usu omo nangedo soesa averegetiri dadabeti? ");
INSERT INTO kpr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Omo budo oriro aetera amo, ainda moni+ K3,000 avaga mutoro budo, makasi embokena ghasaetera amo, avori,” aminge sise, evetu aikena ghoghora siseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Avata Iesu nemokena sisira, “Dovu, evetué amingare! Ne redae nu dombuda resevu? Nu namokena veka eveva etira. ");
INSERT INTO kpr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Eregoseva: makasi embo ne sifo ghousa nemonde dabade irá ghareva. Ava sedo, nemo sonembari sareva amo, sonembuse irareva. O namo, jo namonde dabade sifo ghousa irae arera. ");
INSERT INTO kpr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Averegetira emo, nanda tamo simbugedo bu furugarera, aindae sedo etira. ");
INSERT INTO kpr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na geka beká resena! Ningivu! Nanda Bino Eveva reda ya buvari ningarera amo, evetué rea namokena etira ava, erá kotae eore dae sedo, vironu sise, nunda bino evia sise irarera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Setiri, nunda ambo jimbi 12 ainda jokáda, genembo eni, Keriot embo javo Judas aimi eredo, Iesu dere budo gitofu da ungoda fitari dae sedo, fristi+ da kokotofukena isira. ");
INSERT INTO kpr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ira setiri ningido, ivuga edo, numokena moni mutari dae beka gagojuseri. Etero ningido, Judas nu tuturo edo, Iesu nange sandido nenda ungoda fitaetira, ainda emboro ava kakova usira. ");
INSERT INTO kpr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yisti (Yeast) Kanangara Ari da Kirumo+ ainda sifo kakara tuturo eari, sifi (sheep) da mamandi Jarige Yari da Kirumo+ aminda iti mindari dae sedo, de ojedo ghuseri. Sifo resena daba aminda, Iesu da ambo jimbi numokena ategi useri, “Namane vasa ningiaminda ya, Jarige Yari da Kirumo esimbugaoro dae uju eresi?” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Setero, nu nunda ambo jimbi etoto diriguse sisira, “Yasivu Jerusalem teredo, genembo eni okia bu uvu dimbudo, fururari tambudo, nunda amboda yasivu! ");
INSERT INTO kpr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nu reda ya terarira amo, vasa daba aminda yasivu teredo, kambo numamokena sevu, ‘Ijuga kato eminge setira, “Na vasa reda tere, nanda ambo jimbide dabade, Jarige Yari da Kirumo+ simbugedo mindareri?” ’ aminge sevu! ");
INSERT INTO kpr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aminge saovo, nune ne bu ya kambo duruda, a dodo, viti vasa ikáda ijugari gareva. Vasa eveva mo aminda simbugetero irira, ava tambareva. Namondedae sedo, kirumo aminda simbugevu!” ");
INSERT INTO kpr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aminge setiri ningido, nunda ambo jimbi etoto eredo era Jerusalem teteruseri. Teredo, roera isambu Iesu sisira, ava tambudo, Jarige Yari da Kirumo+ aminda simbuguseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Simbugetero ungobu iri, Iesu nunda ambo jimbi 12 ainde dabade era teteruseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tere anumbedo, bayau rise Iesu nemokena sisira, “Na nemokena geka beká sari dae erena. Namonde bayau rerera einda jokáda, genembo eni anumbirira aimi, namoá gitofukena aito arira.” ");
INSERT INTO kpr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Aminge setiri, namane dudukughedo, dubo mema use, nusuka nusuka se nininguse daba daba numokena ategi useri, “Ni mavedae resesi? Se ningore! Ni namokena resesa, ai?” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Setero, nu nemokena sisira, “Ne isambu 12 ava nane aghi usena ainda jokáda, genembo eni mave, nangae ungo dabade bayau sukada fati bu rerera amo, numori. ");
INSERT INTO kpr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","God da Geka jokáda rea gembero irira amo, eviri: ‘Evetu Genembo da Koro ambarira!’ aminge gefuseri. A nu aminge sirorarira. Avata, genembo mave aito ari ambarira amo, nu mema a bouvu teriago beká barira,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Setiri dadabetiri, ne bayau rise, Iesu nu farava budo, God kena ‘aiyakoe’ sedo esimbugedo, jighi embebegedo nemokena ghasisira. Ghasise sisira, “Emo nanda tamori. Bu mindivu!” aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","kotugo agha jighiri eretiri, God kena ‘aiyakoe’ sedo, nemokena mutiri ne isambu riseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mindido, Iesu sisira, “Emo nanda ororori. Nanda ororoimi, God numokena ya buvari da emboro+ seka, afigari dae erira. Evetu genembo digari da jebugadae sedo, nanda ororo averegaono vosedo, emboro+ afigarira. ");
INSERT INTO kpr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na nemokena geka beká resena! Na vaini (wine) jo mindae irono, God sari nunda natofo+ nunda vasa aminda ya terarera da sifo aminda, na vaini (wine) sekago aminda mindarena.” ");
INSERT INTO kpr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iesu aminge setiri dadabetiri, ne eredo yaru eni divudo, kamboá dodo enda jiro fumbari javo Orivi, aminda iseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Aminda ise, Iesu nemokena sisira, “Ne isambu na do sumbareva. God da Geka jokáda, rea aindae sedo gembero irira amo eviri: ‘God nu, sifi (sheep) kaifa kato dari ambari gido, sifi sarigedo nunda nunda sumbarera,’ God da Geka aminge resira. ");
INSERT INTO kpr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Avata kotugo, God sari, na ambarida ghe jebugedo erarena ainda amboda, na ya frovensi Galilee aminda buvuruturono, ne amboda furareva.” ");
INSERT INTO kpr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Aminge setiri, Peter numokena sisira, “Bajari, ninda mendenii ni ighagha edo doyarera tanojo. Avata namo, ni itako jo doyae arena,” Peter aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Setiri, Iesu numokena sisira, “Na nimokena geka beká resena! Oroko tumbaghae, kokora umbu etoto naká sifo jo karigae irari, ni na umbu etodaba naká ighagha aresa,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Setiri, Peter nu kovionoghae sisira, “Na ni jo ighagha ae beká arena! Na nangae dabade ambarera amo, avori!” aminge sisira. Kotugo, nunda ambo jimbi isambu, ne geka daba ava siseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iesu nunda ambo jimbide dabade era, reighi javo Getsemani aminda buvudo, nu nemokena sisira, “Ne eminda anumbirovo, na ya ominda banungarena.” ");
INSERT INTO kpr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aminge sedo, nu Peter, James, a John ava budo, nemonde era vasa esike fetedo, Iesu nu dubo mema ambari eko ava usira. ");
INSERT INTO kpr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Etiri, nemokena sisira, “Nanda dubo jokáda, bouvu mindafu beká ava erefufena. Fufuse, na ambududurerena. Ne diti fakara edo, eminda fetedo namo kaifa ururuvu!” ");
INSERT INTO kpr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aminge sedo, ne dodo itako ira dombui du fasedo, nu nange mema da sifo ovia darigaetira, aindae banungusira. ");
INSERT INTO kpr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Banunguse sisira, “Arie, Afako! Emo, isambu nine ari da kaugori! Mema teria namokena refira evia, saso darigaeti! Avata jo nanda uju ava ae arena, ninda uju ava arena.” ");
INSERT INTO kpr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aminge sedo, nu ere jovereghedo, nunda ambo jimbikena ira buvudo, ne fafase avéro tafusira. Tambudo, nu Peter kena sisira, “Simon, fasiresa, ai ravesa? Ni redae sifo tufako jo diti fakara edo, na itako kaifa aeri?” ");
INSERT INTO kpr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Aminge sedo, nemokena sisira, “Erá Satan foa nemo dereuri ari eko eove dae sise, diti fakara edo banungevu! Nenda uju a kotari namokenari. Avata nenda tamo imboe edo, diti bouvu etiri, ne fakina jo ae ereva.” ");
INSERT INTO kpr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aminge sedo, nu jovereghe ira banunguse, geka daba ava sisira. ");
INSERT INTO kpr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Setiri dadabetiri, jovereghe ira buvudo, ne sekago diti bainghetiri fafase avéro tafusira. Avori, ne diti fainghedo numoá gido, geka sari buniseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Etero, Iesu sekago jovereghe ira banungedo, jovereghe fira buvudo sisira, “Ne ravava amo, nangetiraimi kotugo sekago fase ravevu? Avori, sifo buvira! Oroko, Evetu Genembo da Koro+ ari ekoko embo da ungoda fitarira. ");
INSERT INTO kpr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Erevu namonde ya gaore! Givu! Genembo namo aito erira amo, evia buvirere!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu aminge siri, nunda ambo jimbi 12 ainda eni javo Judas fira buvurutusira. Fristi+ da kokotofu, Moses da Geka ijuga kakato a Jusi embo da babojegari, ne evetu genembo mendeni dirigetero kaiya a gandigha ava budo, Judas de dabade fera buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Giti, ne jo javi edo furae irise, gitofu Iesu kau nange kasama aetera aindae sedo, Judas nu eminge sisira, “Sandi muno arena amo, numora avori. Ururono aminda kasama edo, numoá sandido kaifa use bu yasivu!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas gitofude dabade fera buvudo, Judas dambu Iesu kena ira sisira, “Ijuga Kato, iresa!” aminge sedo, Iesu sandi muno usira. ");
INSERT INTO kpr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Amingetiri gido, gitofu fera Iesu sanduduseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sandudero, genembo eni aminda fetirisira aimi, nunda kaiya bu jighiri eretiri, fristi+ da giti jighari ainda saramana kato da dengoro ava je gafugetiri dudurusira. ");
INSERT INTO kpr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ainda amboda, Iesu nemokena sisira, “Ne redae kaiya a gandigha budo, namo sandari dae sedo refevu? Na jo tafasara kato iraeri. ");
INSERT INTO kpr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Namonde sifo ghousa God da Kamboda+ irise ijugedo ghusena amo, ne nangusiraimi aminda na jo sandae edo ghusevu? Avata ne emingereva da beká mo: God da Geka rea resira, ava beká are dae sedo, nene etevo sirorerira,” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","nunda ambo jimbi isambu oju edo, nu do sufuseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sufero, mandi gimasa eni emboi avisira amo, nu Iesu da amboda firi gido, numo sandari dae etero, ");
INSERT INTO kpr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","sumbiri, embo ujuge duriri, nu tefo tamoi sufusira. ");
INSERT INTO kpr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Amingetiri, Iesu budo era, fristi+ da kokotofu da giti jigharikena buvurutuseri. Fristi+ da kokotofu, evetu genembo da babojegari, a Moses da geka ijuga kakato+ totorugedo irero, Iesu bu teteruseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","O Peter mo, nu itako ambokena fetiriri, Iesu budo ero, nu amboda amboda udo ira fristi+ da giti jighari da kambo furu aminda teredo ofotighida buvudo fefetusira. Fetedo, ungo ata mesari dae sedo ira, isoro kakato mendeni ainde dabade anumbusira. ");
INSERT INTO kpr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Avori, fristi+ da kokotofu a kaniseremane isambu aminda totorugusera aimi, Iesu daoro ambare dae sedo, susu kakova useri. Susu tambari dae sedo, setero evetu genembo mendeni fera teredo, Iesu dae aji siseri. Ne gungubo teria futo siseri. Avata numo saoro ambari da susu eni jo tambaeri. ");
INSERT INTO kpr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ainda amboda, mendeni ere fetedo gungubo osa sise, nundae eminge siseri, ");
INSERT INTO kpr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nu eminge siri namane nininguseri, ‘God da Kambo+ evetu genemboimi itutusera ava, nane bejedo sifo etodaba naká ainda jokáda, nasukako itono fetarira, jo enii na sonembae arera,’ nu aminge setiri namane nininguseri.” ");
INSERT INTO kpr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aminge sisera avata, nenda geka jo mendo dabako aeri. ");
INSERT INTO kpr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Etero, fristi+ da giti jighari ere fetedo, Iesu kena ategi usira, “Geka setera aindae, ni rejo eni saresa? Evetu genembo resera emo, geka bekári?” ");
INSERT INTO kpr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aminge sisira, avata Iesu nu beka dodo geka rejo eni jo saeri. Etiri, fristi+ da giti jighari sekago Iesu kena ategi usira, “Se ningore! God namonde kakara eraera, ainda Mandi nu evetu genembo da ari ekoko kote doyari dae sedo mutari sisira amo, nimori, ai?” ");
INSERT INTO kpr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aminge setiri, Iesu sisira, “Resesa avori! Ne amboda Evetu Genembo da Koro+, God Fakina Kato ainda ungo gimandukena anumbirari gareva, a kotugo utuda ghe foroga jokáda vose fururari gareva.” ");
INSERT INTO kpr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aminge setiri ningido, fristi+ da giti jighari janje eko etiri, nunda tamo asugari jighi ijejegedo sisira, “Ningevu! Nu aminge siri, God da javo eko erira. Geka eni redae ningareri? ");
INSERT INTO kpr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nunda ari eko ava, tofo siri niningerevere! Ava ne nange erekotevu?” setiri, ne isambu numoá daoro ambare dae siseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sedo, mendeni tuturo edo numokena kosiva edo, embo budo fera diti gajedo, nu umbebaimi doruse siseri, “‘Ni God da feroveta,’ seraesa. Ava sedo, se ningore! Ni mave eredori?” aminge setero dadabetiri, fristi+ da isoro kakato, nembarago Iesu doruseri. ");
INSERT INTO kpr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter nu kambo ofotighida anumbiriri, fristi+ da giti jighari da saramana kato gagara eniimi fira, ");
INSERT INTO kpr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peter ungo ata mesise anumbiriri, ava fuge gido sisira, “Evetu genembo Nasareth embo genembo javo Iesu ainde dabade deinghedo ghusera, ainda eni nimori,” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peter ighagha use sisira, “Ni geka resesa amo, na bunariri!” aminge sedo, nu eredo ira, emboro békada fetiriri, kokora beka sisira. ");
INSERT INTO kpr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Setiri, gagara daba aimi, nu aminda fetiriri gido, sekago evetu genembokena sisira, “Genembo emo, nu Iesu da eniri,” sisira. ");
INSERT INTO kpr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Avata nu sekago ighagha usira. Ainda amboda, evetu genembo aminda fetirisera aimi siseri, “Geka bekári. Nimo Galilee embori; ava sedo, ni nunda eniri! Amo jo ighagha ae aresa!” ");
INSERT INTO kpr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aminge setero, Peter God da javoda beka gagojuse sisira, “Na gungubo sarena amo, God na darira. Genembo reseva amo, na bunari bekári!” ");
INSERT INTO kpr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aminge siri, kokora sekago sifo karigusira. Sifo karigiri, Iesu rea numokena sisira ava Peter kotisira, “Kokora umbu etoto naká sifo jo karigae irari, ni na umbu etodaba naká ighagha aresa.” Peter ava kotedo tuturo edo sorara janjagughae usira. ");
INSERT INTO kpr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sifo atetiri, fristi+ da kokotofu, evetu genembo da babojegari, a Moses da Geka ijuga kakato+, kanisere isambude dabade manaka garuseri. Manaka gaetero dadabetiri, ne Iesu seiniimi (chains) bundedo budo era, Rome embo da kotofu, javo Pilate, frovensi Judia kaifa edo ghusira, nunda ungoda fifituseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Fitero, Pilate da dombuda fetetiri, Pilate Iesu kena ategi usira, “Se ningone! Geka bekári: ni Jusi embo da kiniri, ai tefo?” setiri, Iesu minonda sisira, “Ava nine resesare!” ");
INSERT INTO kpr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Aminge setiri, fristi+ da kokotofu nundae aji sise, geka ekoko mendeni mendeni siseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Setero, Pilate sekago ategi usira, “Ni dara eraesa a geka sembae seraesa ava, gegenembo ei sero niningeresere. Ava sedo, ni redae mino jo sae eresi?” sisira. ");
INSERT INTO kpr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Avata Iesu amboda geka eni jo sae usira. Amingetiri gido, Pilate bunisira. ");
INSERT INTO kpr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jarige Yari da Kirumo+ ainda sifoda, Pilate sifo ghousa emingedo ghusira. Dibura embo eni nenda uju ava, natofoi benunu seoro ningido, nu doyeari tefo foa buvudo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sifo aminda, genembo gogore kato eni javo Barabbas dibura jokáda irei. Natofo mendeni gavana imboe use, titigho usera ainda sifo aminda, Barabbas resena eimi, genembo eni detiri ambududurusira. ");
INSERT INTO kpr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Avori, Pilate nu genembo eni doyari ya buvaetira ava kotise iriri, evetu genembo natofogo Pilate kena fera buvudo, Pilate da kiki setena evia kotise, tuturo edo genembo eni diburada ghe foa buvare dae sedo, benunu siseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Benunu setero, Pilate nemokena ategi usira, “Avori, ne mavejoá uju erevu? Na saono, Jusi embo nenda kini (king) ava foa isaghada buvare, ai? Sevu ningone!” ");
INSERT INTO kpr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Aminge sisira da beká mo: nu kasama usira, fristi da kokotofu a Jusi embo da babojegari ne, evetu genembo digari Iesu da geka ningido ghusera ava gido, dubo eko etiri, nu aindae sanduduseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Avata natofo nange Barabbas foa buvare dae benunu saetera ava kotise, fristi+ da kokotofu natofo da ghamo deretiri eretiri, ne Barabbas foa buvare dae setero, ");
INSERT INTO kpr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate sekago nemokena ategi usira, “Atá, na genembo eni, Jusi embo da kini (king) seraeva emo, nange areni!” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ne koko sedo, “Amo, arafa dege!” siseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Setero, Pilate sisira, “Atá, nunda dara rejori? Sevu ningone!” setiri, ne koko sedo fumbu aruguse siseri, “Arafa dege!” ");
INSERT INTO kpr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aminge setero, Pilate nu, evetu genembo dubo eveva aoro dae sedo, emingusira. Nu Barabbas dotiri fira isaghada buvurutusira. Ainda amboda nu setiri, nunda mendeni Iesu budo ambíimi doruseri. Detero, Pilate nu arafa daoro dae sedo, isoro kakato mendeni da ungoda fifitusira. ");
INSERT INTO kpr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Isoro kakato aimi Iesu budo era, gavana da kambo mindafu ainda furu da guro aminda teredo dendeguda buvurutuseri. Dendegu da javo mo, ‘Praetorium’ seraera. Aminda buvudo, kori setero, nenda mendeni isambu fera totoruguseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Totorugedo, ne embo unju tamoi budo fera Iesu kena asuguseri. Asugedo, ne asi titifaghae bu kefu edo kau kini (king) da kekesa avaga edo, nunda jiroda asuguseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Asugetero fetetiri, tuturo edo nu dere jise, ategi use sedo ghuseri, “Orokaiva! Jusi embo da kini buviro! Orokaiva!” aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ambii budo nunda jiroda doruse kosiva use bainghedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Dere jirero dadabetiri, nenda embo unju tamo Iesu kena asugusera ava kosughedo, tofo nunda ava bu fera numokena asuguseri. Amingedo, nu arafa dari dae sedo, jumbudo iseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Emboro soroda, Sairin embo genembo eni, javo Simon ava, reighi Jerusalem teteriri tambudo, kovionoghae setero, nu Iesu da korosi ava fufusira. (Simon resena emo, nu Alexander a Rufus ghae da numamori.) ");
INSERT INTO kpr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Avori, ne Iesu budo era, reighi javo Golgota, aminda buvurutuseri. Golgota resena, einda tuka mo namondeda gekaimi, ‘Ambari Embo da Jiro Aghati da Vasa’ seraera. ");
INSERT INTO kpr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Aminda buvudo, nu erá mema itatameure dae sedo, vaini (wine) budo a fiyogha eni, moor (myrrh) seraera, ainghae baingoro edo futuseri. Futusera avata, nu jo bae, dotutusira. ");
INSERT INTO kpr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Dotiri, iji vitiri (9 koroko), Iesu tautaimi arafa detero takegha etiri, nunda tamo asugari kosughe budo, mave nunda embo boka ningiava baetira, ava kasama ari dae sedo, kikindoro garuseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Etero dadabetiri, nu redae koto usira da susu ava ijugaoro kasama aoro dae sedo, faiya gembudo Iesu da jiro agada detero takegha usira, amo eviri: “Emo Jusi embo da Kiniri!” aminge gefuseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tafasara kakato etoto naká ábarago budo era, Iesu de dabade arafa doruseri, eni gimandukena, a eni umbefukena. ");
INSERT INTO kpr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Amingero, God da Geka rea sisera ava isagha usira. Amo eviri: “Nu ari eko embova kotise siseri.” ");
INSERT INTO kpr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Evetu genembo mendeni foa Iesu gi dariguse, dere jise gifua gitorotoro use sedo ghuseri, “Ai, makoede! Ni erekotesa amo, ni God da Mandiri. A eni mo: ni God da Kambo+ jighi bejedo, sifo etodaba naká, ainda jokáda sekago itaso fetare dae sisesi. ");
INSERT INTO kpr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ava sedo, tofo sonembedo korosida ghe vose fete gaore!” ne aminge sedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kau daba aminga ava, fristi+ da kokotofu a Moses da Geka ijuga kakato+, ne Iesu dere jise tofo tofo se nininguseri, “Nu seari, evetu genembo mendeni jejebugedo ghuseri. Avata nu nangetirai tofo sonembedo vosae eri! ");
INSERT INTO kpr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nunda kotari mo: God namondeda ari ekoko kote doyari dae sedo, Genembo eni mutari sisira amo, numori. A nunda kotari eni mo: namonde Israel embo da kini (king) mo numori. Ava sedo, tofo sonembedo korosida ghe vose foa fetarira amo, namonde gido nu tumondarera,” aminge sedo ghuseri. Kotugo, tafasara kakato Iesu de dabade arafa dorusera aimi, nengae Iesu dere jiseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Isonga (12 koroko) iri, reighi isambu aminda tumba jido iriri ira, ungobu (3 koroko) iri, reighi sekago usasa usira. ");
INSERT INTO kpr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ungobu iri, Iesu koko sisira, “Eloi! Eloi! Lema sabatani!” Ainda tuka mo: namondeda gekaimi saeteri, “Nanda God! Nanda God! Redae na dotesi?” ");
INSERT INTO kpr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aminge setiri, evetu genembo mendeni aminda fetirisera aimi, sembae ningido eminge siseri, “Ningivu! Nu God da feroveta javo Elijah, aindae kori resira,” siseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Iesu aminge siri, genembo eni sumbu viti fetedo, roera eni sofeya ava budo, faragho mendoda vakimbedo, vaini (wine) dokegha ainda jokáda fatiri sasaka etiri, budo ira, Iesu mindare dae sedo, nunda bekada fifituse sisira, “Namonde gaore! Elijah foa nu sonembarira, ai tefo?” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iesu beka mindafugo koko sedo, ghamo asegari dotutusira. ");
INSERT INTO kpr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ambududuriri, God da Kambo+ ainda jokáda, nunda vasa kakara ava, evetu genembo erá tere gido ambeore dae sedo, embo teria eniimi gajetero ireira ava, soroda ijejege ikáda ghe vose fira, duruda buvurutusira. ");
INSERT INTO kpr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Etiri, isoro kakato da giti jighari Iesu da dombuda fetirisira aimi, Iesu nange ambududurusira, ava gido, “Geka bekári: emo God da Mandiri!” sisira. ");
INSERT INTO kpr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Iesu ambududuriri, evevetu mendeni ne esike fetirise gosuseri. Evevetu resena ainda jokáda mo, evevetu eviri: Magdara embo evetu eni javo Mary, Mary da nunombo, amo James Kitako nengae Joses ghae da noi, a Salome ri. ");
INSERT INTO kpr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Evevetu resena eimi, ne Frovensi Galilee ghedo fera, Iesu de dabade deinghuse nu sonembedo ghuseri. Evevetu resena, a kotugo evevetu digari, Iesu de dabade viti fera reighi Jerusalem buvurutusera, ainde dabade esike fetirise gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sifo atarira amo, Jangutari da Sifori. Ava sedo, ungobu iri gido, Arimatia embo genembo eni javo Joseph, fakina edo ira, Iesu da tamo budo ya furugari dae sedo, Pilate kena benunu sisira. ");
INSERT INTO kpr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph resena emo, nu genembo binonderi, a kotugo kanisere jokáda irei. Numbarago God foa nunda natofo+ kaifa arira da sifo ava kaifa use irei. ");
INSERT INTO kpr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nune eredo ira Pilate kena teredo, Iesu da tamo mutari bu ya furugari dae sedo, benunu setiri ningido, Pilate dudukughusira. Dudukughedo, isoro kakato da giti jighari aghi etiri fira buviri, ategi usira, “Iesu ambira ai, jebuga irira?” setiri, ");
INSERT INTO kpr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","giti jighari amo, “Anakora ambira!” sisira. Setiri, Pilate Iesu da tamoá Joseph kena mutoro dae sisira. ");
INSERT INTO kpr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aminge setiri, Joseph mane eredo era, embo yokura foyago ava ombudo budo fera, Iesu da tamo korosida ghe bu fitero vosetiri, simbuge doghedo budo era, ofofo eni ghamana toka basisera, aminda bu teredo fifituseri. Fitido, ghamana mindafu ava afufetero ira, aimi toka gagojusira. ");
INSERT INTO kpr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nu reda fifitusira ava, Magdara embo evetu javo Mary, nunombo Joses da noighae aminda irise, nene gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jangutari da Sifo dadabetiri gido, Magdara embo evetu javo Mary, a nunda nunombo, James da noi, a Salome, nemonde dabade era, usu eni muno futo ava, Iesu da tamonda davari dae sedo, ofuseri, ");
INSERT INTO kpr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Amingedo, Fura Tomanako ataeghae beká sifo atutiri, evevetu aimi eredo ofofoda iseri. ");
INSERT INTO kpr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ofofoda ise siseri, “Namondedae ghamana teriaó, mave afufari darigari namonde terareri?” aminge sise, ");
INSERT INTO kpr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","diti fuge gosusera amo, ghamana mindafu amo anakora afufedo darigetiri, toka isagha edo iriri gosuseri. ");
INSERT INTO kpr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gido, era tokada teredo, mandi gimasa eni tamo asugari foyago aimi asugedo, gimandukena anumbiriri gi dudukughedo buniseri. ");
INSERT INTO kpr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Bunéro, nu sisira, “Erá buneove! Ne Nasareth embo genembo javo Iesu arafa dorusera ava kakova ereva, ai? Numo ambarida ghe jebugedo eretira! Nu eminda tefori. Nunda tamo reda fitero fasusira, ava ijugaono gaove! ");
INSERT INTO kpr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yasivu! Nunda ambo jimbi, Peter de dabade, nemokena eminge sevu ningore! ‘Nu frovensi Galilee aminda giti erira. Ava sedo, ne eredo nunda amboda yasivu, aminda tambove! Nu aminda tambari mo, nu anakora jebuga irise, setiri ne niningusevu.’” ");
INSERT INTO kpr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Gimasaá aminge setiri, ne jovereghe fera isaghada buvudo sufuseri. Ainda susu mo: ne oju edo dudukughedo, ungo ata dadadaghuseri. Ne oju beká ava usera ava sedo, ne sumbudo era reighida buvurutusera amo, ne osa jo saeri. ");
INSERT INTO kpr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesu nu Fura Tomanako ainda sifoghae ambarida ghe jebuge eredo, Magdara embo evetu javo Mary kena, isagha etiri gosusira. Mary resena emo, numokena giti sukaru 7 aimi asugetero ireira ava, Iesu nunda jokáda ghe ondiri vose dariguseri. ");
INSERT INTO kpr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mary Iesu gido, jovereghe ira, Iesu da kokomana dubo mema use sorara usera aikena buvudo, Iesu erorusira da bino ava osa sisira. ");
INSERT INTO kpr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Eminge sisira, “Iesu ambarida ghe jebugedo eretiri na geni!” aminge setiri niningusera avata, ne manamana edo jo tumondae useri. ");
INSERT INTO kpr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ainda amboda, Iesu da kokomana etoto naká, emboroda deinghudo ero, Iesu dombu beka jovereghe kau eni edo, nemokena isagha usira. ");
INSERT INTO kpr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nu kasama edo, jovereghe era buvudo, nenda kokomana isambukena osa siseri. Avata nenda geka barago, jo tumondae useri. ");
INSERT INTO kpr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ainda amboda, Iesu da ambo jimbi 11 aimi, ne bayau rero, nu nemokena isagha etiri gosuseri. Ne diti jo basari nu tumondae usera aindae, nu dombuda sisira. Ainda susu mo: Iesu ambarida ghe jebuge erorusira ava, evetu genembo mendenii gido era nunda ambo jimbikena osa setero niningusera avata, nenda gogoreimi use, jo tumondae useri. ");
INSERT INTO kpr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Dombuda sedo, ainda amboda nemokena sisira, “Nanda Bino budo reighi isambu aminda yasivu! Natofo isambukena sevu ningore! ");
INSERT INTO kpr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mave tumondedo bafataito arira amo, jebuga evovodae irari ava tuve budo, God da vasada teredo sifo ghousa irarira. Avata mave jo tumondae arira amo, na saono numo ari ekoko mino mutari vasada terarira. ");
INSERT INTO kpr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mave tumondarira amo, nu fakina edo tano mendeni mendeni use emingarira. Nanda javoda a nanda fakinaimi, nu sukaru ondari vose darigarera. Asisi Kakara numokena asugari, aviva jovereghari geka mendeni nu bunari ava, nunda bekaimi sarira. ");
INSERT INTO kpr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Jingabu bu jighari gambarira amo, nu jo ambae arira. Kae mindarira amo, nu jo ambae arira. O, evetu genembo kae tambudo irarera amo, ungo tamonda fitari, ne jejebugarera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Setiri dadabetiri, God setiri Iesu utuda vitisira. Vitíra teredo, God da ungo gimanduda anumbusira. ");
INSERT INTO kpr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Etiri, nunda ambo jimbi era reighi isambu aminda, Iesu da Bino ava osa sedo ghuseri. Bajari nu sonembeari, nunda ambo jimbi tano mendeni mendeni eoro siroredo ghusira. Aminge siroreari gido, nenda geka mo geka beká ava, evetu genembo kasama edo ghuseri. Avori, nanda geka tano eviri. ");
INSERT INTO kpr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Arie, Theophilus ko! Na ni ategi beká ava erena. Namanenda jokáda rea sirorusira ainda Bino ava, evetu genembo digari aimi osa sise, gembero irira. ");
INSERT INTO kpr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","E jo duboi kotise gembaeri. Evetu genembo mendeni diti mokoi gido, Iesu da bino evia, vironu seoro ningido ghusera, ava gefuseri. ");
INSERT INTO kpr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ava sedo, kotofuko, nane kotisena amo, eveva mo: na nindae gembu gogoghombaeteni. Ainda beká mo: na roera digari emo isambu, nunda tuturo da ghe ijuje ningi gogoghombuseni. ");
INSERT INTO kpr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Na emingerena ainda tuka mo: ni rea niningusesa ainda beká ava, kasama e gogoghombaetesi. Yari budo gi! ");
INSERT INTO kpr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kini (King) Herod nu reighi Israel kaifa use ireira ainda sifoda, God da fristi+ eni javo Zechariah irei. Zechariah resena emo, nu Abijah da imendiri. A nu Abijah da imemesiride dabade, God da Kamboda+ fristi+ da saramana edo ghuseri. Noaro da javo mo, Elizabeth ri. Elizabeth da numamo mo, numbarago fristiri. ");
INSERT INTO kpr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zechariah noaroghae mo, God da dombuda veka eveva use, Nunda agho dari kaifa e gogoghombedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nengae erova irarara edo, evetako embako useri. ");
INSERT INTO kpr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Avori, fristimane God da Kamboda+ saramana edo ghusera ava, Zechariah nunda boanda ari dae sedo, ira Jerusalem aminda saramana use irei. Fristi+ da kiki mo eviri: mavejo mavejo yabiyabina (incense) oltada (altar) dungedo ghaetira ava, gategari dae use, kikindoro avavaga gaedo ghuseri. Sifo eninda kikindoro garusera amo, Zechariah da javo ava isagha etiri gido, nu eredo ira God da Kamboda+ yabiyabina (incense) God kena dungari avare dae sedo teterusira. ");
INSERT INTO kpr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nu amingiri sifo aminda, evetu genembo digari isaghakena fete banungero, ");
INSERT INTO kpr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","aneya fira Zechariah kena olta (altar) beina gimandukena isagha usira. ");
INSERT INTO kpr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Isagha etiri, nu gi dudukughedo oju usira. ");
INSERT INTO kpr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Oju iri, aneya numokena sisira, “Zechariah, erá oju eose! God ninda benunu ningira. Ava sedo, nearo Elizabeth kauri edo mandi fumbarira. Mandi javo mo, John jighareva. ");
INSERT INTO kpr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Numo sirorarira amo, ne ivuga use dubo eveva beká ava areva, ã evetu genembo mendeni barago ivuga beká ava arera. ");
INSERT INTO kpr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mandi amo, nu God da dombuda kotofuko edo irarira. Vaini (wine) o uvu fakara jo mindae arira. Nu jo sirorae, noi da tininda irari, Asisi Kakara aimi numokena asugarira. ");
INSERT INTO kpr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Asugari gido, nu Israel embo digarigo ava, nenda Bajari God kena unumbe bu jovereghe furarira. ");
INSERT INTO kpr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nu God da feroveta Elijah da kau aminga ava edo, God da Asisi ã God da fakina aimi, giti yama Bajari da emboro simbuguse irarira. Sasingu noi numamode bu foa tatari dubo dabako arera. Kotugo, gogore kakato ábarago bu jovereghari kotari eveva ava kotarera. Aminguse, nu Bajari da natofo nenda dubo joká esimbugururari iroro furarira,” aneya aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Setiri, Zechariah mino numokena sisira, “Na nangedo ni tumondareni? Namane Elizabeth ghae evetako embako eteri,” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","aneya sisira, “Nanda javo Gabriel ri. Na sifo ghousa God da dombuda irá gheraena. Na, Nune dirigetiri bino eveva evia nimokena osa sari dae ojigheni. ");
INSERT INTO kpr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ni nanda geka evia jo tumondae eresa avata, geka einda beká mo sirorarira. Ava sedo, ni beka guga ari iraso, ninda mandi sirorari gido, beka afigarira,” aneya aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nengae God da Kamboda+ geka sero, evetu genembo isaghada fefetusera amo, kaifa e jarutuseri. ");
INSERT INTO kpr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bunise irero, Zechariah fira buvudo beka sari bunisira, ava gosuseri. Gosero, aneya rea setiri niningusira ava, ungoi ijugetiri gosuseri. Gido, ne kasama usera amo, aneya fira numokena isagha etiri, diti mokoi gosusira. ");
INSERT INTO kpr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zechariah da saramana sifo dadabetiri, nu Jerusalem dodo jovereghe natida isira. ");
INSERT INTO kpr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ira natida buvudo irise, noaro Elizabeth kauri usira. Kauri edo jo deinghae kamboda irise, tambuno ghabu soveni taukaka dadabusira. ");
INSERT INTO kpr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Dadabetiri sisira, “Aiyakoe! Giti na erova iriono, evetu genembo na dere jireoro meka gido ghuseni. Orokoá Bajari sonembetiri na dubo eveva use irena,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth kauri edo iriri, tambuno ghabu soveni dadabetiri ainda amboda, God sekago nunda aneya javo Gabriel ava dirigetiri, Frovensi Galilee, reighi Nasareth aminda isira. ");
INSERT INTO kpr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Gagara javo Mary kena, geka osa sari dae isira. Gagara emo, nu genembo javo Joseph kena, vai are dae sedo datu dighero irei. Joseph resena emo, nu Kini (King) David da imendi eniri. ");
INSERT INTO kpr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aneya ira buvudo, eminge sisira, “Mary, iresa. God ninda irari evevago ava gido, ivuga erira. Ni ategi use esimbugerira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Setiri, Mary nu aneya da geka ava ningi dudukughedo geka da tuka ava bunisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Etiri, aneya sekago numokena sisira, “Mary, erá oju eose! God ni dubo ererurira. ");
INSERT INTO kpr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ni kauri edo, mandiá fumbaresa amo, nunda javo Iesu jigharesa. ");
INSERT INTO kpr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nu kotofuko arira. God Teria Beká aimi, nundae ‘nanda Mandi’ sarira. Kini (King) David evetu genembo kaifa e gogoghombedo ghusira; kau daba aminga ava, namondeda Bajari God sari, ninda Mandi kotofuko edo, ");
INSERT INTO kpr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","nune nembua Jacob da imemesiri evovodae kaifa ururari irarera. Nunda fakina jo tano ae arira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Setiri, Mary mino aneyakena sisira, “Nu kau nange nangedo namokena sirorari? Na jo genemboghae iraeri,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Setiri, aneya numokena sisira, “Amo jo genembo da fakinaimi sirorae arira. God nunda Asisi Kakara mutari nimokena vose asugarira. Aminguse, God da fakina aimi afuregari, ni Mandi Kakara fumbaresa. Aindae sedo, God nundae ‘nanda Mandi’ sarira. ");
INSERT INTO kpr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ninda ghato Elizabeth ava kote gi! Nu ‘erovava’ sedo ghuseri. Nu evetako avata, oroko nu kauri edo iriri, tambuno ghabu soveni sembudo ghabu sovenida dabako ava dadabari dae erira. ");
INSERT INTO kpr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God kena fakara eni tefori. Nu rea sarira amo, beká sirorarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Setiri, Mary numokena sisira, “Na Bajari da aderi. Ava sedo, nunda uju setesa amo, namokena sirorare!” aminge setiri, aneya eredo darigusira. ");
INSERT INTO kpr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ainda amboda, Mary nunda roera bibitai simbuge bu eredo beina doririkena ira, Judia frovensi buvudo, nunda ghato da reighi aminda buvurutusira. ");
INSERT INTO kpr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Buvudo ira Zechariah da kamboda teredo, nunda ghato Elizabeth gido ategi usira. ");
INSERT INTO kpr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","43","Ategi etiri, nunda ghato Elizabeth ava niningiri, kokoi nunda tini jokáda dudukughedo javi javi usira. Amingiri, Asisi Kakara Elizabeth kena vose asugetiri, nu dubo kotedo beka fainghe sisira, “Arie, ni nanda Bajari da noiri! Ava redae namokena ojesi? Nane eredo nimo gari dae yaetena, ava avori. Namokena ojighesa aindae, na ivuga beká ava erena. God ni esimbuge gogoghombusira. Ninda mandi fumbaresa amo, numbarago esimbuge gogoghombarira. ");
INSERT INTO kpr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ni ategi eso, kokoi nanda tininda ava ningido, ivuga use javi javi etira. ");
INSERT INTO kpr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Geka Bajari da aneya aimi nimokena sisira, ava beká are dae sedo tumonde gogoghombusesi. Aindae sedo, Bajari ni esimbugerira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aminge setiri, Mary eminge sisira, “Nanda ghamo joká isambuimi, Bajarikena sakai resena. ");
INSERT INTO kpr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","49","Nanda asisiimi ivuga erira. Ainda susu mo: na sabuari, avata God Fakina Kato namo kotedo sonembuse veka eveva erira. Ava sedo, orokoá evetu genembo tuturo edo, nandae sarera, ‘God Mary esimbugusira.’ Nunda javo kakara bekári. ");
INSERT INTO kpr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Evetu genembo God igheghi use kakara eraera amo, God joka use ne dubo buraira. Ã kotugo, nenda sasingu ã imemesiri barago, joka use esimbugeraira. ");
INSERT INTO kpr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nunda ungo siregusira da fakina aimi, evetu genembo gogore kakato amo, bambu soesa babarigusira. Etiri, nenda ujuda manaka garusera amo, dotero dadabusira. ");
INSERT INTO kpr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nune seari, reighi mendeni da kini (king) babai, nenda vasa do vosedo, sabua edo ghuseri. Kotugo Nune seari, sabua mendeni vitido kokotofu edo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Evetu genembo baimarai sirivo edo ghusera amo, sonembuse oka bayau muteari mindido ghuseri. Aminguse, evetu genembo mendeni guguade amo, dirigeari ighoii sirivo udo ya ghuseri. ");
INSERT INTO kpr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nu beka gagojuse, Abraham ã namonde Abraham da sasingukena joka use, evovodae sonembari sisira. God ava kotise, namonde Israel embo, nunda gigimasa ã ade jamena, ava sonembusira.” ");
INSERT INTO kpr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary Elizabeth ghae irise tambuno etodaba dadabetiri, jovereghedo nunda natida isira. ");
INSERT INTO kpr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabeth da fumbari sifo buviri, mandiá fufusira. ");
INSERT INTO kpr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Fumbiri, nati embo ã nunda natofo isambu, Bajari nu nange nange sonembetiri mandi fufusira ava ningido, Elizabeth de ivuga useri. ");
INSERT INTO kpr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mandiá siroretiri, fura dabako dadabetiri, nunda vika mendo anoso gafugari dae sedo, evetu genembo mendeni fera buvudo, nunda vika mendo anoso ava gafugedo, numamo da javo Zechariah ava jighari dae siseri. ");
INSERT INTO kpr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Setero, noi sisira, “Tefo, nunda javo John jigharera.” ");
INSERT INTO kpr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Setiri, mino numokena siseri, “Ninda oro ainda jokáda, javo emo tefori.” ");
INSERT INTO kpr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aminge sedo, numamokena ungoi use, nunda uju mo, javo rejoá jigharera aindae ategi useri. ");
INSERT INTO kpr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Etero, Zechariah nu roera eni mutoro mandi da javo gembari dae ungoi etiri gido, mutero bu eminge gefusira: ‘Nunda javo mo, John ri.’ Aminge gembiri gido, natofo isambu dudukughuseri. ");
INSERT INTO kpr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zechariah gefiri beka vujegetiri, geka sise tuturo edo God dae sakai sisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Amingetiri, nati embo reighi aminda oju useri. Oju ero, bino ivegedo iri, evetu genembo Judia frovensi beina doririkena irá ghedo ghusera, isambu nininguseri. ");
INSERT INTO kpr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mave bino ava niningusera amo, isambu kotari futo use siseri, “Mandié baji teria arira amo, amboda rejoá ari?” Ainda susu mo: mandiá Bajari da esimbugari jokáda irei. ");
INSERT INTO kpr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","John numamo Zechariah, Asisi Kakara ai vose asugetiri, God da Geka ava itatamuse geka evia sisira: ");
INSERT INTO kpr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Namonde Israel embo da Bajari God dae sakai saore, nu fira nunda fakinaimi namonde sonembusira ava sedo. ");
INSERT INTO kpr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nune namonde sonembare dae sedo, Sonemba Kato tomanako, nunda gimasa David da imendi eni ava futusira. ");
INSERT INTO kpr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Anakora beká, God setiri nunda ferovetaimi gembero irira: ");
INSERT INTO kpr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘God namondeda gitofu ava kosegari namonde jebugarera. Ã kotugo, evetu genembo namondekena gitofu eraera, ainda ungoda ghe saghimbe bari jebugarera,’ aminge gembero irira. ");
INSERT INTO kpr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nune namondeda abuamanedae joka edo, nunda beka gajari kakara ava, kaifa ari sisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Namondeda abua agira beká Abraham kena beka gagojuse, sisira, ‘Ninda gitofu ã ninda sasingu da gitofu ava, nane kosegaono jebugareva. Nenda gitofudae jo oju ae, namoá tumonde bainghedo ghareva. ");
INSERT INTO kpr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Aminguse, ne evovodae nanda natofo kakarago beká ava use irareva.’” Zechariah aminge sedo, jovereghe nunda kokoi John kena eminge sisira, ");
INSERT INTO kpr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Nanda mandi, ninda geka barago irira: God Teria Beká, nunda Geka ava isagha saso dae sedo, ni gategusira. Ni giti yama, Bajari da emboro esimbugaresa. ");
INSERT INTO kpr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Bajari nu nange nunda natofo da ari ekoko kote doyari jebugarera ava, nemokena osa saso ningarera. ");
INSERT INTO kpr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Namondeda God, namondedae joka edo tavo use unduraira. Sifo atedo iji viteari, tumba dadaberaira kau aminga ava, God da sonemba a God da usasa utuda ghe janimbeari, evetu genembo ambari dae oju eraera amo, usasa ava gido, dubo jama arera,” Zechariah aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nunda mandi baji tomanako use, dubo gekaghae babojusira. Nu reighi uvu ã evetu genembo irae da vasa aminda ireira edo, tuturo edo Israel embokena vironu sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sifo aminda, Rome embo da kotofu javo Augustus, agho dorusira amo eviri. Evetu genembo Rome emboimi kaifa edo ghusera aimi ya, nenda nombuamane da reighi aminda, nenda oro ainde dabade javo gembaeteri. ");
INSERT INTO kpr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Genembo javo Quirinius, nu Syria frovensi da kotofu edo ireira ainda sifoda, evetu genembo da javo jo gembae iriara ava, tuturo edo nenda javo gefuseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ava sedo, evetu genembo isambu eredo era, nenda reighida buvudo, nenda oro ainde dabade javo gefuseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Genembo javo Joseph setena amo, numbarago Nasareth ghedo ira, Frovensi Galilee dodo, Judia frovensi reighi javo Bethlehem aminda buvurutusira. Bethlehem resena emo, reighi aminda giti Kini (King) David sirorusira. Joseph mo, Kini (King) David da imendi eniri. Aindae sedo, aminda javo gembari dae sedo isira. ");
INSERT INTO kpr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Isira amo, nunda datu gagara Mary ava budo, nengae dabade iseri. Mary nu tamo bouvu edo irei. ");
INSERT INTO kpr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Era, Bethlehem buvudo, aminda esa embo da kamboda avari vasa tefo gido, ne era sino fuka da kamboda tere aminda irá ghuseri. Aminda irero, Mary da fumbari sifo fira buviri itatamusira. Itatamedo, nunda mandi bego fumbudo emboimi doghedo, sino fuka da bayau mindari vasa aminda fitiri fasusira. ");
INSERT INTO kpr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Vasa eni Bethlehem dengesida, evetu genembo mendeni nenda sifi (sheep) kaifa ero, Mary nu mandiá fufusira. ");
INSERT INTO kpr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Fumbiri, Bajari da aneya, sifi kaifa kakatokena isagha etiri, God da usasaimi jaraghetiri gido, oju beká ava useri. ");
INSERT INTO kpr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Oju ero, aneya nemokena sisira, “Erá oju eove! Na Bino Eveva nemokena sari dae erena. Bino resena eindae, evetu genembo isambu ivuga arera. ");
INSERT INTO kpr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","God nenda ari ekoko kote doyari dae ã nemo sonembari dae sedo, nenda Sonemba Kato dirigetiri ojighira orokoá siroretira. David da reighi Bethlehem ominda siroretira. Emo, Bajari Keriso dae resena. ");
INSERT INTO kpr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Siroretira ava gari dae areva amo, mandiá emboimi doghedo, sino fuka da bayau mindari vasa aminda fitero fasirira, ava gareva,” ");
INSERT INTO kpr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","aminge siri ainghae dabade, aneya digari ambari beká ava, utuda ghe fera isagha edo, aneya giti fira isagha usira, ainde dabade fetedo, God dae sakai siseri: ");
INSERT INTO kpr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God Teria, a Iká Bekáda irira, aikena sakai sise resera! Ã evetu genembo endada God nune uju eraira, aikena dubo jama mutari irare!” Aminge sedo, aneya do jovereghedo utuda vitiseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Vitéro, sifi (sheep) kaifa kakato tofo tofo se nininguseri, “Fuvu, namonde Bethlehem yaore! Bajari namondekena rea osa setiri ningera ava, ya gaore!” aminge sedo, ");
INSERT INTO kpr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ne bibitai era buvudo, Joseph noaro Mary ghae tambudo, mandiá sino fuka da bayau mindari vasa, aminda fitero fasiriri gosuseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Gido, aneya geka rea mandidae setiri niningusera ava, osa setero nininguseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mave sifi (sheep) kaifa kakato da geka niningusera amo, ne isambu dudukughedo buniseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Avata Mary nu sifo ghousa geka ava, nunda dubo jokái kotise irá ghusira. ");
INSERT INTO kpr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sifi (sheep) kaifa kakato eredo jovereghe iseri. Ise, aneya geka setiri niningusera ava, God kena sakai sise yarui didivudo iseri. Ainda beká mo: aneya geka setiri niningusera ainda beká ava, isagha etiri gosuseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mandiá siroretiri fura dabako dadabetiri, vika mendo anoso gafugari da sifo buviri, nunda javo, Iesu ava jijighuseri. Javo Iesu mo, noi jo kauri ae iriri, aneya fira futusira, ava jijighuseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Sifo 30 ava dadabari dae iri gido, Joseph noaro Mary ghae mandiá budo, Moses da Geka rea resira ava ari dae sedo, Jerusalem iseri. Moses da Geka resena amo eviri. Evevetu ghasongana eraera amo, jo totoi ya God da Kamboda+ terae eraera. Ne sifo tufako kaifa use iria edo ainda amboda, tamo seghe simbugedo, joba budo, ya God da Kamboda+ teredo muturaera. Avori, ne Jerusalem iseri, Mary da javoda, joba God kena mutari dae sedo, ã kotugo, mandiá God kena ijugari dae sedo, iseri. Mandi ijugusera ainda tuka mo, Bajari da Agho Dari eminge ijugerira: “Vide jamena bebego fumburaera amo, isambu kakarari, God kena.” Ã kotugo, Bajari da Agho Dari joba rea mutoro dae sisira amo, gumbara etoto o ribo etoto naká ava mutari dae sedo, Jerusalem iseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sifo aminda, genembo eveva javo Simeon, reighi Jerusalem aminda irei. Nu God kakara use, God nange nange Israel embo sonembarira, ava kaifa use irei. Nu Asisi Kakara ghaeri. ");
INSERT INTO kpr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Asisi Kakara ai numokena sisira, “Ni jo ambae irise, God da Sonemba Kato garesa. God evetu genembo da ari ekoko kote doyari dae sedo, Genembo mutari endada vosarira, ava garesa,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Avori, sifo eni, Asisi Kakara imi setiri, Simeon eredo God da Kamboda+ ira teredo, kaifa iri, noi numamoghae nenda mandi Iesu budo, Agho Dari rea resira ava ari dae sedo, amboda era teteruseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tere fetetero, Simeon mandiá bu ovinembedo, God kena aiyakoe sise eminge sisira: ");
INSERT INTO kpr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bajari, namokena beka gagojusesa, ava ojighira isagha etiri eregosenere. Orokoá saso na nimokena dubo jamaghae yarena! ");
INSERT INTO kpr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","32","Ainda tuka mo: ninda Sonemba, nunda oro oro aimi gaoro dae sedo, simbugusesa ava, ditii eregosenere. Mandi emo, namane Israel embo da duro a usasari. Janimbururari, namane Israel embo da gitofu ninda emboro ava garera.” ");
INSERT INTO kpr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aminge setiri, Simeon rea mandidae sisira ava ningido, noi numamoghae dudukughuseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Amingetero, Simeon ne esimbuguse, Mary kena sisira, “Mandi emo, Israel embo da kotari ava isagha are dae sedo, God nu gategusira. Numo God da tanori. Evetu genembo mendeni ne ivugaghae, mandi evia gosuse jebugarera. O mendeni, numoá gido imboe aoro, God sari nunda jebuga ne jo tambae arera. Evetu genembo amingururoro, nenda kotari eveva, ai, eko ava, God gido kasama arira. A evetu genembo ninda Mandi imboe ururoro gido, mema ninda ghamo jokáda gayarira,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Evetu rori eni javo Anna, numo God da feroveta eniri. Nunda oro javo Asher, a numamo da javo mo Phanuel. Nu vai edo irise ghaeko 7 ava dadabetiri, nuvu ambududurusira. Ambiri, nu rori edo irise, ghaeko 84 ava usira. Nu sifo ava inono, God da Kamboda+ irise, bayau kanangara use, God tumonde bainghedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeon Iesu noikena geka siri, Anna fira nemokena buvurutusira. Buvudo Anna tuturo edo, God dae sakai sisira. Aminge sedo, nu Iesu da bino ava, evetu genembo digari Jerusalem aminda, God da Sonemba kaifa edo ghusera aikena, osa setiri nininguseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bajari da Agho Dari rejo resira ava, Joseph noaro Mary ghae etero dadabetiri, ne mandide jovereghe era, nenda reighi Nasareth, Frovensi Galilee aminda buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Buvudo, mandiá dubo gekaghae baji mindafu iri, God mandiá esimbugusira. ");
INSERT INTO kpr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ghaeko ava inono, Iesu noi numamode dabade Jarige Yari da Kirumo+ ari dae sedo, Jerusalem aminda ya ghedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iesu ghaeko 12 etiri, kirumo edo ghusera, kau daba aminga ava ari dae sedo, sekago noi numamode dabade Jerusalem iseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Era, kirumo etero dadabetiri, noi numamo natofode jovereghe natida ero, Iesu Jerusalem aminda fefetusira. Fefetusira ava, noi numamo jo kasama aeri. ");
INSERT INTO kpr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nenda kotari mo: Iesu nu natofode dabade yariá kotise era, emboro soroda tumba jiriri, nenda nano namendi ã kokomanakena tava useri. ");
INSERT INTO kpr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tava usera avata, jo tambaeri. Bune jaredo, sekago jovereghe numo tava udo Jerusalem iseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tava ero sifo etodaba naká dadabetiri ainda amboda, nu God da Kambo+ jokáda tafuseri. Nu Israel embo da ijuga kakatode dabade anumbedo, geka minonde minonde se niningero tafuseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ijuga kakato aimi ategi eoro, Iesu geka numo beká ava seari ningido, evetu genembo aminda irisera amo, ne dudukughedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Noi numamoghae Iesu gi dudukughedo, noi Iesu kena sisira, “Nanda mandi, ni redae emingumutasi? Eteso, namane nimamoghae, nimo tava edo, bune jarutumutari.” ");
INSERT INTO kpr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aminge setiri, Iesu nemokena sisira, “Redae na tava umutavu? Na Afa da saramana arena amo, ne anakora kasama aetevu,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Avata ne mino jo bae useri. ");
INSERT INTO kpr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Amingedo, nu noi numamode dabade jovereghe era, reighi Nasareth aminda buvudo irise, noi numamoghae da geka nininguse, aghi edo ghusira. Avata Jerusalem aminda geka sisera ava, noi Mary dubo jokái kotise irá ghusira. ");
INSERT INTO kpr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Avori, Iesu nu dubo kotise babojusira. Amingiri, God nu dubo budo ghusira, ã evetu genembo barago, nu dubo budo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Genembo javo Tiberius, nu Rome embo a evetu genembo isambu da kotofu teria edo iriri, ghaeko 15 ava dadabusira. Ainda sifo aminda, genembo javo Pontius Pilate, nu Judia frovensi ainda kotofu edo irei. Kini (King) Herod nu Frovensi Galilee kaifa edo ghusira, a Herod da namendi Philip, Ituria ã Trakonaitas frovensi ava, nune kaifa edo ghusira. Genembo javo Lysanias, nu Abelin frovensi ainda kotofu edo irei. ");
INSERT INTO kpr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Reighi Jerusalem aminda, fristi+ da giti jighari etoto naká, javo Annas nengae Caiaphas ghae, fristi+ nene kaifa edo ghuseri. Sifo aminda, Zechariah da mandi John, reighi uvu a evetu genembo irae da vasa aminda ira iriri, God nunda geka ava, John osa sare dae sedo futusira. ");
INSERT INTO kpr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mutiri gido, John eredo uvu Jordan ainda dengesida ise fuse, vironu eminge sedo ghusira, “Fuvu eminda, nenda ari ekoko vujegururovo, bafataito aono, God nenda ari ekoko kote doyare!” vironu aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","God da feroveta Isaiah anakora beká, John nunda saramana rea arira ava, nunda bukuda eminge gefusira: “Mave reighi uvu a evetu genembo irae da vasa aminda fetirise, koko fuge vironu resira, ‘Bajari da emboro rerebevu dambu are! ");
INSERT INTO kpr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Enda doriri ghambuvu, vose tevisa are! Urokuto amo furevu, viti dambu are! Emboro birurughari amo rerebevu, ya dambu are! Enda vitari vosari ábarago, jevu vose vivisegare! ");
INSERT INTO kpr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Amingururovo, God da sonemba ava isagha ari, evetu genembo isambu garera!’” aminge gefusira. ");
INSERT INTO kpr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Evetu genembo digari, nemoá bafataito are dae sedo, John kena foa ghedo ghuseri. Furureoro, nemokena eminge sedo ghusira, “Ne Satan da sasinguri. Ne na jo derae areva. Ne dubo jo jovereghae ireva. God nenda ari ekoko aindae, janje eko use mino mutari erekotira ava, ne jo reda darige yae areva. ");
INSERT INTO kpr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ágido, dubo jovereghedo, veka eveva use irivu! Erá eminge seove! ‘Abraham namanenda abua gido, God namane uju eraira!’ aminge erá seove! God nu uju aetira amo, nu sari ghamana iritirira eimi, Abraham da sasingu jinaeteri. God evetu genembo da oro aindae, jo kotae eraira. Mavejo Israel embo o oro eni amo, God jo kotae eraira. ");
INSERT INTO kpr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","God nu, ika karivakoi susuda jari dae sedo, simbugedo refira. (Ika resena emo, nemori.) Ika vuji eveva jigharira amo, irarira. O jo eveva jighae arira amo, God ika amo jedo avarakada dungari avarira,” aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Seari, evetu genembo ategi edo ghuseri, “Namane nange nange areri?” ");
INSERT INTO kpr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Seoro, John nu mino eminge sedo ghusira, “Nenda tamo asugari etoto irarira amo, eni kosughe mutuvu, makasi emboi baore! Nenda bayau irarira ábarago, budo soro evu!” aminge sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Sifo eni, takesi bari kakato mendeni fera buvudo, nemo bafataito are dae sise, eminge siseri, “Ijuga Kato, se ningore! Namane rejoá areri?” aminge setero, ");
INSERT INTO kpr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","John sisira, “Takesi da mino beká avanembo buvu! Erá kokomana dederuse mino teria beove!” ");
INSERT INTO kpr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aminge setiri, isoro kakato mendeni, nembarago ategi useri, “Se ningore! Namane mo, nange areri?” setero, John nemokena sisira, “Erá nenda fakinaimi evetu genembo katiyavara use, nenda moni saghimbe beove! Erá koto use, mino bari dae sedo, gungubo seove! Geka bekáda sevu! Erá nenda saramana eraeva, ainda minondae sedo beisiga eove!” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","John geka ava siri ningido, evetu genembo kotisera amo, “Genembo eni God mutari sisira amo, avose, numori tanojo!” ");
INSERT INTO kpr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aminge kotero, John itatamedo sisira, “Namo, ne tefo uvuimi bafataito eraena. Avata nanda amboda, Genembo eni refira. Numo, genembo teria bekári. Na jo numongo iraeri. Na taká sabua bekári. Numo ne Asisi Kakara nengae avarakaghae aimi bafataito arira. ");
INSERT INTO kpr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Genembo amo, nu vare numamo da kaugori. Nune farava veka budo gategari dae sedo, simbuge refira. Gategedo, farava da beká ava simbuge budo, nunda kamboda fitari irarira. O anoso ifughae amo budo, avaraka sukainghae tambuno aminda fugari vosedo, evovodae aminda irarira,” John aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Geka evia ã kotugo, geka mendeni mendeni sise, John nu God da Bino Eveva ava, evetu genembokena vironu sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aminge sise, nu frovensi da kotofu Herod dae ghoghora sedo ghusira. Ainda susu mo: nunda koro jo ambae iriri, noaro javo Herodias ava saghimbe bu fifitusira. Ã kotugo, ari ekoko mendeni ava edo ghusira. ");
INSERT INTO kpr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ari ekoko mendeni edo ghusira ainda etoda usira amo, nu setiri, John bu diburada fifituseri. ");
INSERT INTO kpr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","John jo dibura ae irise, evetu genembo numokena foa ghusera amo, isambu bafataito edo ghusira. Ainda amboda Iesu fira buviri, John numbarago bafataito usira. Amingetiri, Iesu nu banungiri utu afigetiri, ");
INSERT INTO kpr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Asisi Kakara kau ribo ava jine vose fira, Iesu kena asugusira. Vose asugetiri, beka utuda ghe eminge sisira, “Nimo nanda dubo bari Mandiri. Na nindae ivuga use, aiyakoe beká resena!” ");
INSERT INTO kpr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu da ghaeko 30 avaga dadabiri, nu tuturo edo God Afa da saramana ava, isaghada edo ghusira. Evetu genembo kotedo ghusera amo: Iesu nu Joseph da mandiri. Joseph da numamo mo Heli ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli da numamo mo Matthat ri. Matthat da numamo mo Levi ri. Levi da numamo mo Melchi ri. Melchi da numamo mo Jannai ri. Jannai da numamo mo Joseph ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph da numamo mo Mattathias ri. Mattathias da numamo mo Amos ri. Amos da numamo mo Nahum ri. Nahum da numamo mo Esli ri. Esli da numamo mo Naggai ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai da numamo mo Maath ri. Maath da numamo mo Mattathias ri. Mattathias da numamo mo Semein ri. Semein da numamo mo Josech ri. Josech da numamo mo Joda ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda da numamo mo Joanan ri. Joanan da numamo mo Rhesa ri. Rhesa da numamo mo Zerubbabel ri. Zerubbabel da numamo mo Shealtiel ri. Shealtiel da numamo mo Neri ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri da numamo mo Melchi ri. Melchi da numamo mo Addi ri. Addi da numamo mo Cosam ri. Cosam da numamo mo Elmadam ri. Elmadam da numamo mo Er ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er da numamo mo Joshua ri. Joshua da numamo mo Eliezer ri. Eliezer da numamo mo Jorim ri. Jorim da numamo mo Matthat ri. Matthat da numamo mo Levi ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi da numamo mo Simeon ri. Simeon da numamo mo Judah ri. Judah da numamo mo Joseph ri. Joseph da numamo mo Jonam ri. Jonam da numamo mo Eliakim ri. Eliakim da numamo mo, ");
INSERT INTO kpr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea ri. Melea da numamo mo Menna ri. Menna da numamo mo Mattatha ri. Mattatha da numamo mo Nathan ri. Nathan da numamo mo David ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David da numamo mo Jesse ri. Jesse da numamo mo Obed ri. Obed da numamo mo Boaz ri. Boaz da numamo mo Salmon ri. Salmon da numamo mo Nahshon ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon da numamo mo Amminadab ri. Amminadab da numamo mo Admin ri. Admin da numamo mo Arni ri. Arni da numamo mo Hezron ri. Hezron da numamo mo Perez ri. Perez da numamo mo Judah ri. Judah da numamo mo, ");
INSERT INTO kpr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacob ri. Jacob da numamo mo Isaac ri. Isaac da numamo mo Abraham ri. Abraham da numamo mo Terah ri. Terah da numamo mo Nahor ri. Nahor da numamo mo, ");
INSERT INTO kpr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug ri. Serug da numamo mo Reu ri. Reu da numamo mo Peleg ri. Peleg da numamo mo Eber ri. Eber da numamo mo Shelah ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah da numamo mo Cainan ri. Cainan da numamo mo Arphaxad ri. Arphaxad da numamo mo Shem ri. Shem da numamo mo Noah ri. Noah da numamo mo Lamech ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech da numamo mo Methuselah ri. Methuselah da numamo mo Enoch ri. Enoch da numamo mo Jared ri. Jared da numamo mo Mahalaleel ri. Mahalaleel da numamo mo Cainan ri. ");
INSERT INTO kpr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainan da numamo mo Enos ri. Enos da numamo mo Seth ri. Seth da numamo mo Adam ri. Ã Adam da numamo mo God ri. ");
INSERT INTO kpr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu nu, Asisi Kakara ai asugetiri dubo kotise, Jordan Uvuda ghe jovereghe isira. Asisi Kakara aimi nu unumbe budo ira, reighi uvu ã evetu genembo irae da vasa aminda isira. ");
INSERT INTO kpr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Buvudo ira, sifo 40 aminda iriri, Satan fira numokena buvudo, nunda fakina ava dere gosusira. Iesu bayau jo mindae, kanangara use iriri, sifo 40 ava dadabiri, nu ighoi usira. ");
INSERT INTO kpr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Etiri gido, Satan numokena sisira, “Ni God da Mandi iraresa amo, se ghamanaé farava jinari mindase!” ");
INSERT INTO kpr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Setiri, Iesu mino sisira, “God da Geka eminge resira: ‘Evetu genembo oka bayau vanembo kotarera amo, God da jebuga beká jo tambae arera.’” ");
INSERT INTO kpr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aminge setiri, Satan Iesu unumbe bu vitira, reighi ã frovensi isasambu endada irira, ainda fakina ã duro ava, jighi afigetiri fuge gosusira. ");
INSERT INTO kpr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Gosiri, Satan numokena sisira, “Reighi mendeni mendeni eregosesa evia, God nunda ungo sokinembetiri nane ruruseni. Genembo mavejoá uju arena amo, nane saono nu reighi einda kotofuko arira. A enda einda reighi isasambu da fakina ã gugua numokena mutarena. ");
INSERT INTO kpr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ava sedo, Iesu, ni namoá tumonde baingharesa amo, reighi einda duro eregosesa evia, nimokena mutono baresa,” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu mino numokena sisira, “God da Geka eminge resira: ‘Nenda Bajari God nusuka numoá, tumonde bainghuse, nunda uju avanembo areva!’” ");
INSERT INTO kpr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Setiri, Satan nu Iesu unumbe budo Jerusalem aminda ira buvudo, God da Kambo+ ainda enoda viti ira fetedo, Satan jovereghe Iesu kena sisira, “Ni God da Mandi iraresa amo, jaunghe gaone! ");
INSERT INTO kpr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Jaunghaso dae resena ainda susu mo, God da Geka eminge resira: ‘God nunda aneya ni kaifa aoro dae sedo, dengoro indarira.’ ");
INSERT INTO kpr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","A God da Geka eni barago eminge resira, ‘Aneya nene ni kaifa ururoro, ni vosiya nenda ungoda desembedo vose fetaresa. Ninda ata jo ghamanai de fokughuse, jorae arira.’” Satan aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu mino numokena sisira, “Resesa amo, geka bekári. Avata vasa eninda, God da Geka eminge resira: ‘Nenda Bajari God ava, jo dere gari dae ae areva.’” ");
INSERT INTO kpr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aminge setiri, Satan nu derari Iesu durari gari dae usira ava, jo inono ae etiri gido, nu Iesu sifo tufako do darigusira. ");
INSERT INTO kpr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Iesu Asisi Kakara ai asugusira ava jo darigae iriri ainghae dabade, jovereghe ira Frovensi Galilee aminda buvurutusira. Buvudo, reighi mendeni kena ise, natofo da dengoro indari kambo+ mendeni aminda vironu seari ningido, nundae sakai sedo ghuseri. Sakai sero, nunda bino ivegedo iri, ‘evetu genembo frovensi aminda, isambu nininguseri. ");
INSERT INTO kpr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iesu nunda reighi Nasareth aminda ira buvudo, nu evovodae edo ghusira aminga ava use, Jangutari da Sifoda, ira dengoro indari da kamboda+ teterusira. Teredo, God da Geka tegari dae erorusira. ");
INSERT INTO kpr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Eretiri, God da Geka Isaiah gefusira ava, mutero bu afigedo, geka evia tambudo tegutusira: ");
INSERT INTO kpr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bajari da Asisi namokena asugetiri irena. Ainda beká mo: evetu genembo makasi embokena, Bino Eveva saono dae sedo, na gategusira. Evetu genembo ari ekoi bundetiri irera ava, saono vujege doyoro dae sedo, Bajari setiri ojigheni. Evetu genembo diti digoide ava sonembaono, diti afigari gaoro dae sedo, na mutiri ojigheni. Evetu genembo, nenda kokotofuimi jo tavo ae eraera ava, foa sonembaono jejebugaoro dae sedo, setiri ojigheni. ");
INSERT INTO kpr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","A God, ghaeko eminda nunda jebuga ijugarira, ava osa saono dae sedo, setiri na ojigheni.” Geka ava tegutusira. ");
INSERT INTO kpr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tegedo, Iesu buku gajedo, kaifa katokena mutiri biri nu anumbusira. Anumbetiri, dengoro indari da kambo+ aminda, evetu genembo isambu fuge Iesu gosero, ");
INSERT INTO kpr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","nu tuturo edo sisira, “Geka oroko nembo teguteno ningeva amo, beká sirorerirere,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iesu geka numo beká ava se disugetiri niningero, tamo gafusira. Etiri ne jovereghe tofo tofo se nininguse yove siseri, “Emo Joseph da mandiri. Nu kotari emo reda rurusi?” aminge setero, ");
INSERT INTO kpr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iesu nemokena sisira, “Ne rea kotise, uju ereva amo, na kasama erena. Amo, namokena eminge sari dae ereva, ‘Geka tege beká sirorariá setesa amo, reighi Kaponiam aminda rea eteso binó setero niningusera ava, sekago eminda ururaso namane gido, tumondaore!’ ");
INSERT INTO kpr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Avori, na nemokena eminge resena: feroveta da geka ava, evetu genembo isambu ningido kakara eraera. Avata feroveta tofo nunda totofoi, nu jo tumonduse kakara ae eraera. Aminguse, na nati joká jo dae etevu. ");
INSERT INTO kpr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Kote givu! Ne feroveta Elijah da kiki kasama ereva. Elijah banungetiri, borija jo dirae iriri baimara tomanako siroredo, ghaeko 3 1/2 dadabusira. Ainda sifoda, roriri digari namondeda reighi Israel eminda iriari. ");
INSERT INTO kpr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Avata God setiri Elijah ira, gitofu da frovensi Saidon reighi Serafet aminda buvudo, gitofu da rori eniá sonembusira. O tofo namondeda roriri eni jo sonembaeri. ");
INSERT INTO kpr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ã kotugo, feroveta Elisha da sifoda, evetu genembo digari namondeda reighi Israel eminda kae budo iriari. Avata God jo sari ne jebugaeri. God setiri namonde Jusi embo da gitofu, Syria embo, genembo javo Naaman, nusuka numoá jebugusira.” ");
INSERT INTO kpr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aminge setiri, evetu genembo dengoro indari da kambo+ aminda irisera, aimi ningido, janje ekoko beká ava useri. ");
INSERT INTO kpr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aminguse, ne eredo Iesu ungoda jumbudo, nati jokáda vitererisera reighiá do darigedo, vitera jiroda kounghuseri. Viti fetedo, Iesu fananda fugoro vosiya de ambare dae ero, ");
INSERT INTO kpr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","nu jovereghedo ira, natofo jokáda teredo isira. ");
INSERT INTO kpr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ainda amboda, Iesu ira, Frovensi Galilee reighi Kaponiam aminda buvurutusira. Buvudo, Jangutari da Sifo aminda, ira dengoro indari da kamboda+ teredo, tuturo edo dengoro indudusira. ");
INSERT INTO kpr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Indudiri, natofo geka ava ningido dudukughuseri. Ainda beká mo: Iesu dengoro indudusira amo, geka nunda fakinaghae dabade sisira. ");
INSERT INTO kpr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Genembo eni, sukarui asugetero ireira amo, tere anumbedo, Iesu geka siri ningido, nu sukaru da fakinaimi koko sise sisira, ");
INSERT INTO kpr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Agá, Iesu, Nasareth embo, ni namanekena nange ari dae fumutasi? Ni saso namane sirivo aoro dae sedo fumutasi, ai? Namane ni kasama erera. Ni God da Genembo kakarago bekári,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Setiri, Iesu numokena kovionoghae sisira, “Beka dodo, genembo ainda jokáda ghe fu buvase!” aminge setiri, sukaruimi fugetiri genembo natofo da dombuda duduriri, nu vose darigusira. Sukaru numokena rejo eni jo aeri. ");
INSERT INTO kpr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ava gido, evetu genembo isambu dudukughedo dabade se nininguseri, “Geka emo rejori? Nu geka fakinaghae seari sukaru ningido, evetu genembo da jokáda ghe vose darigeraera,” aminge siseri. ");
INSERT INTO kpr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aminge sero, Iesu da Bino ava ivegedo iri, reighi isambu nininguseri. ");
INSERT INTO kpr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu dengoro indari da kamboá+ dodo ira, Simon da kamboda teterusira. Teretiri, Simon da imboti kae budo, tamo vevera teria beká iri fasirisira ava, setero niningusira. ");
INSERT INTO kpr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iesu ava ningido ira, nunda dengesida fetedo, kovionoghae tamo vevera aikena setiri darigiri jebugusira. Jebugedo, anakora nu eredo bayau simbugedo nemokena futusira. ");
INSERT INTO kpr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tumba jiriri, evetu genembo kae dombu eni dombu eni bambudo iriara ava, isambu nenda kokomanaimi budo fera Iesu kena buvurutuseri. Buvero, Iesu nunda ungo nenda tamonda jighiri, ne isambu jejebuguseri. ");
INSERT INTO kpr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sukaru evetu genembo da tamonda iriara, ábarago ondiri vose dariguseri. Amingiri, ne koko siseri, “Ni God da Mandiri!” Aminge setero, Iesu nu kovionoghae, beka erá seóro dae sise buregusira. Ainda susu mo: sukaru kasama useri, God genembo eni mutari sisira amo, Iesu ri. Ava sedo, erá sukarui seóro natofo numo kasama eóro dae sise, Iesu ne buregusira. ");
INSERT INTO kpr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sifo atetiri, Iesu eredo reighiá dodo, evetu genembo irae da vasa aminda iri, evetu genembo tuturo edo numoá tava useri. Tava udo era tambudo, nu nemonde irare dae benunu siseri. ");
INSERT INTO kpr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Avata nu sisira, “God nange nange nunda natofo+ kaifa eraira ainda Bino Eveva ava saono dae sedo, na dirigetiri fuseni. Ava sedo, na ya reighi mendeni mendeni aminda, Bino evia inononda sise deingharena.” ");
INSERT INTO kpr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aminge sedo, Iesu nu eredo Israel embo da reighi aminda birurughuse, dengoro indari da kamboda+ teterudo ise, vironu sedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sifo eni, Iesu ira, Genesaret Uvu Teria ainda dengesida fetiriri, evetu genembo God da Geka ningari dae sedo, tofo tofo mimudo era numokena buvurutuseri. ");
INSERT INTO kpr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Avori, kora aminda ghaka+ etoto naká jerighetero iriri, oka bambari embo vose nenda voto seghero gosusira. ");
INSERT INTO kpr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Gido, Iesu vosira ghaka+ eninda vivitusira. Ghaka amo, Simon da ri. Viti fetedo, gembu sirigedo amboi buvare dae sisira. Setiri gembu buviri, Iesu ghakada+ anumbedo, evetu genembo ava dengoro indudusira. ");
INSERT INTO kpr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Indiri dadabetiri, jovereghedo Simon kena sisira, “Gembu vosivu, kafuruda vosedo, voyuva fuge jumbove!” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon sisira, “Bajari, tumbaghae fugutero atetira ainda jokáda, oka eniko jo baeri. Avata nine resesa ágido, sekago fuge garena.” ");
INSERT INTO kpr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aminge sedo, voyuva fugetero vosetiri, oka jo sari irae ava barido, jumbero voto bejari dae usira. ");
INSERT INTO kpr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Etiri, ne nenda kokomana ghaka+ eninda anumbirero gido, ne foa nemo sonembaore dae sedo, ungoi farighuseri. Farighetero, fera sonembedo bero, ghaka+ etoto naká bedo edo rosari dae usira. ");
INSERT INTO kpr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Etiri, Simon nunda kokomanade dabade oka digari jufusera ava gido, dudukughuseri. Kotugo, Simon da kokomana ghaka eninda, nembarago gido dudukughuseri. Nunda kokomana resena emo, Zebedee da sasingu, James nengae John ghaeri. Avori, Simon (o Peter seraera) aimi, Iesu da dombuda kauboi dadarigedo sisira, “Bajari, na dodo yasi! Na ari eko embori.” Aminge setiri, Iesu numokena sisira, “Erá oju eose! Ni oka báresa eminga ava, sifo amboda evetu genembo digari aghi edo unumbaso, foa nanda natofo arera!” ");
INSERT INTO kpr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aminge setiri ningido, ghaka+ fafoda jumbero vitiri, ne ati ghayafa isambu dodo, Iesu da amboda iseri. ");
INSERT INTO kpr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sifo eni, Iesu ira reighi eninda buvudo, genembo tamo bedo gaetiri eko beká edo ireira, ava tafusira. Tambiri, nu Iesuá gido, endada du fasedo sisira, “Bajari, ni uju aresa amo, na saso jebugarena,” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu ungo siregedo nunda tamonda jijighuse sisira, “Ai, na uju erena. Jebugaresa!” aminge siri ainghae dabade, gambisi utetegetiri jebugusira. ");
INSERT INTO kpr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Etiri, Iesu kovionoghae sisira, “Seteno jebugetesa emo, erá osa seose! Ere yasi, fristikena+ ninda tamo ijugaso gari, Moses da Geka aminda, God kena joba rea mutaso dae resira, ava mutu! Amingaresa amo, ni jebugetesa ava, evetu genembo isambu kasama arera,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Avata Iesu da bino amo, ivegedo iri reighi reighi ningido, evetu genembo natofogo beká ava javi edo, nunda geka ningari dae ã nemo sari jebugari dae sedo, ya ghedo ghuseri. ");
INSERT INTO kpr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Avata nu evetu genembo kakagedo ya reighi evetu genembo irae da vasa aminda, banunguse irá ghedo ghusira. ");
INSERT INTO kpr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sifo eni, Iesu ira kambo eninda tere anumbedo dengoro indudusira. Moses da Geka kaifa kakato+ ã ijuga kakato+ mendeni, reighi Jerusalem ghedo ã kotugo reighi isambu Galilee ã Judia frovensi aminda ghedo fera, numokena totorugedo, anumbe niningero, nu dengoro indudusira. Bajari da fakina numokena iriri ainghae setiri, evetu genembo mendeni jejebuguseri. ");
INSERT INTO kpr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Ijugiri, gegenembo mendeniimi, genembo ungo ata dimbaride ava, ghagha dighi fumbudo fuseri. Fera buvudo, kambo evetu genemboi bedo edo mambe kosegetero, ya terari buniseri. Bunedo, genemboá fumbu isaghakena ririda viti sisoro gukada anumbuseri. Anumbedo sisoro ghoretero toka isagha etiri, asiimi ghaghada dighido genembo ainghae dotero, evetu genembo da jokáda vosira Iesu da dombuda fasusira. ");
INSERT INTO kpr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Fasetiri, ne tumonde gogogho usera ava gido, Iesu genembo aikena sisira, “Nanda komana, God ninda ari ekoko kote dotira,” aminge siri ningido, ");
INSERT INTO kpr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Moses da Geka ijuga kakato ã kaifa kakato+ tuturo edo eminge kotiseri, “Genembo omo, nu eminge sise God da javo etiri eko erira. God nusukako ari ekoko kote doyeraira. Jo tefo genembo eniimi ari ekoko kote doyari da kaugo iraeri,” aminge kotiseri. ");
INSERT INTO kpr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aminge kotero, Iesu nenda kotari ava kasama edo sisira, “Ne redae kotari ekoko erekotevu? ");
INSERT INTO kpr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kote givu! Ne erekoteva: na benunu sarena amo, God genembo einda ari ekoko jo kote doyae ari ava erekoteva. A nenda kotari eni mo: nu jebugare dae saetena amo, jo jebugae aeti, ne aminge erekoteva na kasama erena. ");
INSERT INTO kpr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Avori, nanda fakina ijugaono gareva. Evetu Genembo da Koro+ kena mo, ari ekoko kote doyari da fakina ava irira. Ava kasama aovo dae sedo, saono genemboé jebugarira,” aminge sedo, jovereghe genembo ungo ata dimbaride aikena sisira, “Eredo, ghaito budo kamboda yasi!” ");
INSERT INTO kpr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aminge siri ainghae dabade, genembo amo natofo da dombuda eredo, nunda ghaito gaghe budo, God dae sakai sido kamboda isira. ");
INSERT INTO kpr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Amingetiri, evetu genembo isambu dudukughedo buniseri. Bunedo, oju edo God dae sakai sise, eminge siseri, “Namonde evia jo gae iriara ava, orokoá siroretiri, namondeda ditii eregoserere.” ");
INSERT INTO kpr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ainda amboda, Iesu kamboda ghe buvudo ira, takesi bari kato javo Levi, nunda saramana da kamboda anumbiriri gosusira. Gido sisira, “Fu, nangae yaore!” aminge setiri, ");
INSERT INTO kpr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi eredo, nunda saramana ã gugua isambu dodo, Iesu da amboda isira. ");
INSERT INTO kpr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ainda amboda, Levi aghi etiri, takesi bari kakato mendeni ã evetu genembo mendeninde dabade fera anumbedo, Iesu dae sedo kirumo tomanako useri. ");
INSERT INTO kpr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Usera ava, Moses da Geka kaifa kakato+ ã ijuga kakatode+ gido, beisiga use, Iesu da ambo jimbikena siseri, “Takesi bari kakato mo, gegenembo ekokori. Ã evetu genembo mendeni, takesi bari kakatode dabade ojighera anumbirera omo, nembarago ari ekoko embori. Ava sedo, ni redae, nemonde dabade anumbedo bayau reresi?” ");
INSERT INTO kpr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aminge setero, Iesu mino nemokena sisira, “Mave, ‘Na kae tefori,’ sarira amo, dogeta (doctor) numokena jo yae arira. O mave, ‘Na kae beni,’ sarira amo, dogeta (doctor) numokena yarira. ");
INSERT INTO kpr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kau daba aminga ava, mave nunda ari ekoko jo vujegae irise, ‘Na mandi eveva a ari eko eni tefori,’ sarira amo, na nu jo aghi ae arena. O mave nunda ari ekoko vujeguse, ‘Na ari eko embori,’ sarira amo, na numoá esimbugaono dubo jovereghare dae aghi arena,” aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Evetu genembo mendeni Iesu kena ategi useri, “John da ambo jimbi ã Moses da Geka kaifa kakato+ da ambo jimbi, God dae bayau kanangara use banungeraera. Avata ninda ambo jimbi mo, ne sifo ghousa evia uvu bayau mindiraera,” aminge setero, ");
INSERT INTO kpr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu mino nemokena sisira, “Kote givu! Mandi gimasa eni evetu fifitururari kirumo arera da sifo aminda mo, mave jo sari nunda kokomana bayau kanangara ae arera. ");
INSERT INTO kpr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","O genembo evetu fitira ava, gitofui sandi bu ya daoro ambarira da sifoda, nunda kokomana dubo mema use, tuturo edo nundae kanangara arera,” Iesu aminge sisira. ");
INSERT INTO kpr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Aminge sedo, Iesu kasia evia sisira, “Embo boka eni manai edo toka basarira amo, jo embo sogho seka gafugedo aimi, tauta gayae arera. Ainda susu mo: tauta gayarera amo, ainda békada torerarira. ");
INSERT INTO kpr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kau daba aminga ava, vaini (wine) seka jo budo, kofiri manai aminda averegaoro vosedo irae arira. Amingarera amo, vaini (wine) seka da fakinaimi fumbari, kofiri bejari vaini (wine) averege vose soesa arira. ");
INSERT INTO kpr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ava sedo, vaini (wine) seka amo, kofiri sekada averegeraera. ");
INSERT INTO kpr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Evetu genembo mendeni vaini (wine) manai ava mindarera ainda amboda, ne jo sekago jovereghe vaini (wine) seka ava mindae arera. Ne vaini (wine) manai amo, evevago seraera.” ");
INSERT INTO kpr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jangutari da Sifo eninda, Iesu nunda ambo jimbide dabade vare jokáda tere sembiseri. Sembise, nunda ambo jimbi tuturo edo farava vuji ava bambudo, ungoi jase rido iseri. ");
INSERT INTO kpr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Amingero, Moses da Geka kaifa kakato+ mendeni ava fuge gido siseri, “Nangetiraimi ne Jangutari da Sifoda, farava vuji ava bambu jase rise, namonde da agho dari erebejevu? Jangutari da Sifoda, saramana eteva amo, jo ae aetevu,” aminge setero, ");
INSERT INTO kpr_vpl VALUES ("LK6_3","072_6_3"