﻿USE sofia;
DROP TABLE IF EXISTS sofia.kpjNT_vpl;
CREATE TABLE kpjNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kpjNT_vpl WRITE;
INSERT INTO kpjNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kaheka Jesuisi Kristu labiehekỹ rare. Juhuu tahe Abraõ heka Davi labiehekỹ rare. Iribi tahe Davi heka Jesuisi Kristu labiehekỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibutumy ilabiebohonimy arelyykre. Juhuu tybynimy arelyykre idi iriòrenimy: Abraõ, Ijai, Ijaò, ");
INSERT INTO kpjNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda, Peresi, (Peresi seriòre tahe Zera inire. Isereny tahe Tamara inire.) Esraõ, ");
INSERT INTO kpjNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araõ, Aminadabe, Nasaõ, Salmaõ, ");
INSERT INTO kpjNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Boasi, (Raabe, Boasise rare.) Obede, Rute, Ijese, Kie. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Davi hãwyy heka Uria hãwyy juhuu raremyhỹ. Iribi Davi‑wana roire. Salomaõ iriòre rare. Tii heka Roaboaõ tyby rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Idi Abia reare. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Idi Asa, Josafa, Joraõ, ");
INSERT INTO kpjNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia, Jòtaõ, Aka, Ezekia, ");
INSERT INTO kpjNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekia, Manase, Amo, ");
INSERT INTO kpjNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia, Jekonia, taseriòre‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilonia‑ribi rohonyreu tahe tiiboho reare, Jekonia riòre wahe: Salatieli (Tii Babilonia‑ki reare.) Zorobabe, ");
INSERT INTO kpjNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abiude, Eliaki, Azo, ");
INSERT INTO kpjNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadòki, Aki, Eliude, ");
INSERT INTO kpjNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliaza, Matỹ, Ijaò, ");
INSERT INTO kpjNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ijaò tahe Jyje tyby rare, Jyje tahe Marie hãbu. Jesuisi tahe Kristu Deuxu deòdỹỹna rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kia labiehekỹ sõwe tahe 14my rare, Abraõ‑ribi Davi‑ò wahe. Tule labieboho 14my rasõwerenyre Davi‑ribi Babilonia hãwã‑ò ridyreny ixideewimy aõkõ ròte‑ò. Ixyby 14my rasõwerenyre. Iribi tahe Jesuisi reare. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kawese heka Jesuisi Kristu reare. Juhuu Marie Jyje‑wana roikremy rare. Tii ijadòmaule tahe Deuxu Tyytybytyhy ribòtònyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jyje hãbu òbiti rare. Tai tahe riixãwididỹỹnykemy rõhõtinyre. Kia õmo‑ò rarybeõlere tuu. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kiau ỹju tamy rarybere tarasina‑ki: —Jyje, Davi riòre riòre. Ahãwyy, Marie, biteònyõke. Tuu bexihãwyynykre. Iriòre dori Deuxu Tyytybytyhy riòre rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Jesuisimy raninykre. Kiani tahe irybereny rare: tarasadu. Ibutumy iny dori iòraruna‑ribi ritakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Iwese Deuxu rybe ihetxiu rarybere wese tahe tii wiji riwinyre. Kia wese ihetxiu rybe rare: ");
INSERT INTO kpjNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","—Ijadòma rabòtònykre. Iriòreni heka Emanueli rarekre. Kiani tahe irybe‑ki kia rare: Deuxu iny‑wana ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iribi tahe Jyje dexixade tarasina‑ribi. Iwese Inynyrỹreny tuu tamy rarybere wesemy heka tii riwinyre. Tii‑wana ratxiõre. Tii aõhe risỹnyõre. ");
INSERT INTO kpjNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Uladu reare xiery tii aõhe rira. Tamy niõ riwahinyre, Jesuisi wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Belẽ hãwã‑ki Jesuisi reare, Judeia bede‑ki wahe. Iòlò Herodi iòlòmy raremyhỹ. Iu reareu, Hãbu Erytyhy mahãdu taina tỹmyramy robirenyre. Tai tahe iòlò mahãduõ doidenyde biura‑ribi Jerusalẽ hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tiiboho rỹỹraxirenyre: —Iule judeu mahãdu iòlò aõbo kaki reare. Jiarỹboho itainamy rabirenyre tahe nadoidenyde riwowydynyrenykemy. Kaiboho teerytenyte aõbo titxibo ratxireri? ");
INSERT INTO kpjNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tahe inyõ Herodiko relyyrenyre. Herodi kia roholareu sõwemy riòtiinyre. Tule ibutumy Jerusalẽ hãwã mahãdu riòtiinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tahe Herodi ibutumy dinodu mahãdu ributunyre: Xiwena wahidỹỹdu dinodu, bede ywina tyyriti erydu mahãdu tule. Tahe tamyreny rỹỹraxire: —Titxibo Kristu reakemy timybo tyyriti‑ki ròritidỹỹmy roire? ");
INSERT INTO kpjNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tiiboho tamy rarybere: —Judeia bede‑ki, Belẽ hãwã‑ki wahe. Kia tahe ihetxiu rybedu riritinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","—Kai Belẽ hãwã mahãdu. Judeia bede hãwãõ. Kai hãwã yja iny rõhõtinyre. Tahe inatyhy aõkõ rare. Kai hãwã nihikỹre. Aribi dori dinoduõ ròhònykre. Wamahãdu iòlòmy ronykre. Idinodumy rarekre, judeu mahãdu dinodu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tahe Herodi heka biura mahãdu ributunyre ibutumy iny‑ribi wasimy. Tamy rỹỹraxire: —Tiutxubo taina ròhònyre? Tahe rirawyònyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tamyreny rarybere: —Kaiboho boibenyke Belẽ hãwã‑ò. Idi tahe uladu‑ki mahabenykre. Iu wadee manarybebedenykre. Jiarỹ tule tamy arakre ariwowydynykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Biura Hãbu Erytyhy mahãdu roholarenyre. Tahe roirenyre. Ryki ixityre tainamy robirenyre. Uladu tyrehekỹle ritoosònyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Iu tahe sõwemy reysarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Heto‑ò rehemynyre. Tahe ralorenyre. Uladu rare Marie‑wana. Tahe tatiowotimy reserenyre riwowydynykemy. Isaureny riraynyre tamy riwahinykremy: womati tỹrỹrỹhỹkỹ, hee aderòna, aderònatyhy wana. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Idi tahe Biura Hãbu Erytyhy mahãdu rarasinyre. Deuxu tamy rarybere: —Kaiboho Herodi‑ò bòòsebenyõke. Tai tahe rywitxira‑di tasubedereny‑ò ròòserenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Biura mahãdu tahe ròireny rahudi tahe Inynyrỹ ỹju nade Jyje‑ò rybemy, irasina‑ki tamy rarybere: —Ariòre, ise‑wana bidyke Egito bede‑ò. Herodi dori uladu rubudỹỹmy ratxireri. Adee tiu ararybekreule kaò bòdòòseke. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tai Jyjeboho rumy rahenyrenyre Egito bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Herodi rubusỹtybymy tahe dòòsedenyde. Tii riwinyre iwese ihetxiu tyyriti rarybere wese, Deuxu rybedu rybe wahe: —Wariòre Egito bede‑ribi nadidyde. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodi reburere. Biura Hãbu Erytyhy mahãdu dori tii riitxenanyre. Tai ibutumy uladu rirubunyre Belẽ hãwã‑ki, tule ijõ iòhò hãwã‑ki. Ibutumy howỹtòdu rirubunyre inataõ beòra ijõdikeki tahe rirubunyõre. Tai Jesuisi rirubunykemy risỹnyre, iwese tii rareu Biura Hãbu Erytyhy mahãdu tamy rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kiamy ta rỹire iwese Deuxu rybedu rarybere wese, Jeremia wahe: ");
INSERT INTO kpjNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","—Rama hãwã‑ribi ibru‑ò iny roholamyhỹre. Rakeli rare. Tii robumyhỹre. Ibutumy iriòre ituere. Tai robumyhỹre. Inyõ riteysanyõtyhy iriòre rurureki. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodi tahe rurureu, Inynyrỹ ỹju heka Jyje rasina‑ki tamy nade. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Tamy rarybere: —Bòòsebenyke judeu bede‑ò. Uladu ise‑wana bidyke. Kia rirubunykemy risỹnymyhỹré tahe, rurure. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tahe Jyjeboho ròirenyre judeu bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Akelau tahe Herodi riòre ronyre iòlòmy, tyby deròwymy. Tai kowa‑ò Jyje ròirenyõre sỹmy. Rasina‑ki rybeõ rieryre Kalileia‑ò ròirenykemy. Tai tahe ròirenyre kowa‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazare hãwã‑ki rasỹnyrenyre. Kia tahe riwinyre iwese Inynyrỹ rybedu ihetxiu rarybere wese: —Nazare ludu tii rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kiau Judeia bederahy‑ki Joaõ Sebedỹỹdu heka iny‑ò rarybemyhỹre: ");
INSERT INTO kpjNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Deuxu Iòlòna bededỹỹnana iòhòmy ratxireri. Aòraruna‑ribi biixãwibenyke, bexirãhĩke! ");
INSERT INTO kpjNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Joaõmy heka Isaia ihetxiu riritinyre kawese: Inyõ bederahy‑ki ryryreri: —Inynyrỹ dee ryòbiti biwinyke. Biywinyke ryõ tamy kanakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Joaõ kamelo radetyy ityy rare. Iròdutyy iwereysanare. Seihikỹle bidi‑wana irỹsỹna rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ibutumy iny tamy ròirenyre irybe‑ò roholakemy iòhò hãwã‑ribi, Jerusalẽ, Judeia, Jordaõ bero‑ribi wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tamy òrarunamy relyyrenyre rabedewomy tamy relyyrenyre. Tai tahe Joaõ heka bero Jordaõ‑ki tii riratysebenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fariseu mahãdu, saduseu mahãdu doide tamy riratysebenykemy. Kiau Joaõ tamyreny rarybere: —Hemylala mahãdu! Deuxu aõhõkỹmydỹỹnana‑ribi mahenybenyõtyhy. Aõhe inatyhy? ");
INSERT INTO kpjNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Juhuu aõwiwihikỹ widỹỹna biwinybeny. Tai tahe iny rierykre kaiboho aòraru‑ribi inatyhymy texihutenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Fariseu mahãdu, kaiboho tahõtinytenyte: Abraõ heka inylabiehekỹreny rare. Rikirãhĩõtyhy. Deuxu‑ò kia aõ aõkõ rare. Tamy wikeki mana‑ribi Deuxu heka Abraõ riòkòreõ riwinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Woma tahe òwòru‑ribi iòhòmy rỹira. Òwòru bederaty wiwihikỹ ihoõkeki, kedesekre. Rasõkre. Woma heka Deuxu aõhõkỹmydỹỹnana wese rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jiarỹ bedi araratisebedỹỹnyra aòraruna‑ribi texirãhĩteki. Jesuisi tahe Deuxu Tyytybytyhy‑di ròratisebedỹỹkre heòty‑wana riratysebenykre. Tii waratyre awityhymy ratxireri. Jiarỹ riwaixỹrunymy watxireri iwa ariwykeki. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tii maixõmo risykre. Maixõmo ributunyre tahyna‑ò. Irỹnysi heòty‑di riworonykre. Heòty itueõna heka rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Idi tahe Kalileia bede‑ribi Jesuisi nade bero Jordaõ‑ò. Tii Joaõ‑ò nade riratysebenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Joaõ aõkõmy rarybere: —Jiarỹ tahe aõ aõkõ rare. Kai biwaratysebenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesuisi tahe tamy rarybere: —Deuxu deewina heka kia rare. Rikiwinykre. Tahe Joaõ riratisebedỹỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ròratisebenymy rahudi tahe Jesuisi ròtuòra. Biuwetyy rarayre Jesuisi tahe bòtòenimy robire, itxi dobehede, Deuxu Tyytybytyhy wahe. Rybeõ biu‑ribi narybede: ");
INSERT INTO kpjNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","—Kia heka Wariòre rare. Jiarỹ heka sõwemy tukure. Idi wadeysareri. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Idi tahe Deuxu Tyytybytyhy heka Jesuisi ridyre bederahy‑ò. Tai Satanasi riurihikemy tamy rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesuisi heka 40 txumy, 40 rumy heka aõ rirỹsỹõhyy bede idi rỹire. Sõwemy heka rama risamy tai raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Taile Satanasi tamy nade. Tahe iurihiximy tamy rarybere: —Kai inatyhy Deuxu Riòre ahãte wana heka mana‑di orotxumy biwitxiranymy biwinyke ahinamy. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tahe Jesuisi dirawyònyde: Deuxu Ritidỹỹna‑ki kiamy roire: —Iny heka orotxudile aõkõ irumy rỹirakre. Ibutumy Deuxu rybedile iny irumy rỹirakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Idi Satanasi heka Jesuisi ridyre Jerusalẽ hãwã‑ò. Templo heto ratyre tahe ritidire. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tahe tamy rarybere: —Kai inatyhy Deuxu Riòre ahãte wana heka katyre‑ribi ixi‑di behukre bede‑ò. Buruõtyhy heka besekeki. Deuxu taỹju kiditeònykre aramykemy. Bede‑ò aõkõ beseke. Ijõ tyyriti rarybere: —Deuxu araywinykre taỹju‑di. Tii ỹju kiditeònykre tebò‑di ariijekemy. Awa ritõmonyõtyhy manatyre‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesuisi rirawyònyre: —Tyyriti tule rarybere: —Deuxu uritere biurihiõke. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iribi Diabo heka Jesuisi ridyre hãwãlòõ‑ò. Tamy ibutumy bede iòlòna riteòsinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tahe tamy Satanasi rarybere: —Beseke atiowotimy tahe biwawowydynykeki, adee kia ibutumy iòlòna wiwihikỹ ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","—Make Satanasi, Jesuisi rarybere: —Tyyriti rarybere: —Deuxu‑ò sohojile deàlàna, wowydyna biwahinyke. Tiile bityhynykre. Deòdu tamy sohojile mabeke. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Satanasi tahe Jesuisi‑ribi rexitare. Ỹju mahãdu rehemynyre iyrubudỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Joaõ òludu heka ròtenawo‑ki ritidira. Kia Jesuisi roholareu, Kalileia bede‑ò ròòsere. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazare‑ribi rare Kafanaõ hãwã‑ki rasỹnykremy rare. Tii aho‑ki iòhòre, Kalileia aho wahe. Zebulõ bede, Natali bede tahe inatxi hãwã ibiòwa rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kia tahe Isaia Tyyriti rarybere wese: ");
INSERT INTO kpjNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","—Zebulõ bede, Natali bede, Jordaõ bero kowawe‑ribi ijà‑ò. Ahohokỹry‑ki. Kai judeukõdu mahãdu bede rare, Kalileia wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Iny kowasỹ mahãdu bede luru‑ki rasỹnymyhỹre. Tahe tiiboho loosònahakỹmy robirenyre. Bede lurusỹ mahãdu‑ki tahe Deuxu loosòna ritoosònyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Iribi tahe Jesuisi ritelenyre Deuxu rybe ritỹnynykemy. Tii rarybere: —Aòraruna‑ribi bexirãhĩke. Deuxu Iòlòna bededỹỹnana dori iòhòmy ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kalileia aho ijàti‑ki Jesuisi rariamy ratximyhỹ. Tahe inatxi waxidu seriòremy robire, Simaõ Pedro, tule Andre ijõre. Rià‑di utura rimymyhỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesuisi tamyreny rarybere: —Bodoike wahemy. Iny wadee bimykre. Iwese araerynanykremy bimyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aõwesele tahe tarià ririrenyre. Jesuisi‑wana roirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Roirenyre tahe inatxi ijõ seriòre‑ki Jesuisi robire. Txiau ijõni rare. Joaõ ijõre. Tiiboho Zebedeu riòre roire. Tiiboho talawo‑ki ronyrenyre rià riywinyrenymy. Jesuisi tamyreny rarybere: —Wahemy bòdòike. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tai tahe tybyreny ririrenyre. Jesuisi hemy ròirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ibutumy Kalileia bedey‑ki Jesuisi rariamyhỹre. Tii judeu dohodỹỹna heto‑ki rarybemyhỹre. Deuxu Iòlònamy ritỹnynymyhỹre, Rybe Wihikỹ Tỹmyra wahe. Sõwemy webinadu mahãdu riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesuisimy iny relyyre ibutumy hãwã hãwã‑ki Siria bede ibutumy. Tai tahe sõwemy webinadu mahãdu didydenyde tamy, iny tyytybybina‑di, iny iumy imyremyrehekỹ wahe. Jesuisi ibutumy iny riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iny sõwehekỹ riheludunyre, Kalileia bede‑ribi, Debòwiò hãwã‑ribi, Jerusalẽ‑ribi, Judeia bede‑ribi, tule Jordaõ bero kowa‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Jesuisi inymy sõwemy robireu, raòwònyre hãwãlò ratya‑ò, Ierydỹỹna mahãdu tamy doidenyde. Taile rierynadỹỹnymy ronymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Deuxuko‑ki iny ibinamy rỹimyhỹre. Kia iny tuu rexierymyhỹre, teysatyhy rare. Tii deysana sõwemy tai ratximyhỹre, Deuxu Iòlòna heka ihõrõrenymy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Robumy rỹirakeki teysamy heka rỹirakre. Ibedewona wiòhedỹỹna rybe‑di heka tamy kanakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kia inytyhy‑di widee ratxireri, tii heka teysahyymy ratximyhỹre. Ibutumy heka iny ihõrõlehekỹle rỹirakre. Bede bede heka ihõrõmy rarekre teysamy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Inyõ‑ò òbitinamy lobiximy rurukeki tahe teysamy rarekre. Deuxu tamy òbitina riwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Inyõ ruxetòena‑di ratxireri. Deuxu heka tamy ruxetòena‑di rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Inyõ irayky òbitimy ratxikeki tii heka teysamy rarekre. Tii dori Deuxumy robikre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Inyõ ywina‑di wiwana rỹirake teysamy rarekre. Ywinaõ‑di rarekré, teysamy rarekre. Tii dori rarinikre: Deuxu riòremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Inyõ aõhõkỹmy dỹỹnana reuròkeki, tii dori òbitimy rurukeki, tii tulesỹ teysamy rarekre. Deuxu Iòlòna dori ihõrõmy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Inyõ umyreny relyykeki uritere hekỹle. Ruirybe‑di umyreny relyykeki, aõhõkỹmydỹỹnana adee riwahinykre wana, tai tahe beysakre. Awimy mohõtinykre. Kai dori biu‑ò mahenykre. Tai tahe beysakre kai awimy nohõtykre. Uritere nohõti rosarenyõmy. Kia wese tule Deuxu rybemy rybedu aõhõkỹmy rotỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kaiboho heka saawesemy atximahãtenyte, jyyra wesemy wahe bede mahãdu iny‑ò, kai dori kiamy bede mahãdu tewiòhenanyte. Auri tahe urihimyò biõnonykeki tahe aurihixina heka urihimyòlemy releke. Kaa jyyra urile idi adehu rỹikre iny ityre rariakremy. Awiòhedỹỹna biõnonykeki tahe aõma aõkõ beleke. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","15","Kai loosòna wesemy atximahãte kabede mahãdu iny‑ò. Hãwãõ hãwãlò ratyy‑ki roikeki, tiu heka rexiwòõtyhy itỹnyhyy roimyhỹke. Loosònaõ iny ritoosònykeki, tule heka tiu heka hyna rawoõ‑ki roiõtyhy roosòmy. Aõma roosònanymyhỹre ibutu heto jurajuramy heka ibutu ritxuxanymyhỹre. Aõma tamana‑ki rỹimyhỹreki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kaiboho tule amahãdureny awiwihikỹmy robikeki tahe Deuxu‑ò wowydyna riwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jiarỹ heka anaõde bede ywina tuededỹỹmy. Anade aõ Deuxu dee rybedu tuededỹỹmy aõkõ heka anade. Anade ibutumy aõmybo rarybere widỹỹmy. Timybo rarybere wese heka ibutumy tuu rotỹỹnymy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Inatyhymy adeereny ararybekre bede ywina tyyritiy‑ribi tiu ijõ iõõtyhy ijõ sohoji ritiwedena yreõ reseõhyykre. Ibutumy roikre aõhebo rotỹỹnymyhỹreò bede konanako‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Inyõ tõhõti urihimyò bede ywina rosakeki rexidelenymyhỹre iny ribedeerynyõkemy iny ritohonyõmyhỹkemy. Hãbu tahe iyjamy Deuxuko‑ò rarekre, Deuxuko‑txi. Inyõ rityhynymyhỹre irybe iny rybedeerynymyhỹre. Tii tahe Deuxu Iòlòna‑ò nihikỹmy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kaiboho aõma fariseu mahãdu‑ribi awityhymy ixi‑di mohõtinybenykeki. Tiu heka Deuxu Iòlòna‑ò aròterenyõmy. Kaiboho heka awi toite aõma fariseu mahãdu judeu mahãdu wedu ratyre heka awi boibeke. Kia aõkõkeki tahe malòbenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ihetxiu bede ywina Tyyriti kawesemy rare: —Kai inyõ birubunykeki heka iòwynamy iny akanarubunyke. Kia heka bede ywina heka rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tahe warybe urihimyò iwitxira bede ywina‑ribi. Kai inyõ‑ò maraykynykeki. Tai tahe brebunahakỹ‑ki tate. Abiòwa‑ò bininikeki itxỹtemy. Tamy kai marybekeki: —Kai aõki awiõre. Tai tahe akỹnadykre heka aõma ywisidỹỹduko‑ò araòwynykre. Inyõ‑ò kai makyaranynykeki kai brebuna‑ki texilòròmy tate. Kai inyõ deramy mabekeki uriteremy nodu tamy marybekeki, tai brebuna‑ki tate. Inyõ òsỹny aradykre wisidỹỹdu mahãdu‑ò. Inydee ratyhymy mabeke wana aõkõ raremy marybekeki, heòty kõnana bede‑ò make lau brebuna‑ki tate. Iòhãrure kai heòty bede‑ò makemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kaki aõma nieru xiwena wahidỹỹna‑ò behemynykeki inyõ‑wana aõhe widee botỹỹnykeki õhõti rosaõlemy ahãte wana. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Deuxu heka axiwena tewahinyõhyymyhỹte aõma xiwena bire‑ki heka birike. Tahe biijeke aseriòre juhuu. Aõma wana biòbitinybenyke widee marybebenyke. Iribi tahe tamy bedehemynyke xiwena wahidỹỹna‑ò wahe tadevenymy atximahãte wana hãbuõ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Aõma tai tahe iòraru‑ki aòludumy relera wana. Tamy behemynyke aõma timybo tii‑wana widi biywinykemy timybo adeve biòwynykemy tamy heka bitobiny òrale heka aõma rieryke urenana. Aradyhemy aõma ywisidỹỹna ube‑ò, idi ywisidỹỹna mahãdu, idi soldado. Tai tahe bitobinyke bede rierykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Inatyhy heka adee ararybekre ròtenawo‑ki malòkeki. Tiu heka aòlòkòmy aõma iòwy mahumy adi rõhõtinykre. Idi mohõtinyke xiery heka bòhònyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Juhuu ihetxiu heka kaweselemy Tyyriti‑ki rarybere: —Òtaõmy! (Bede ywina tyyriti‑ki wahe.) Kawesemy heka jiarỹ rebedeerynywãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Òtamy rõhõtinykeki hãwyy‑ò retehekeki òtamy rexinohõtinykeki. Tai heka tii òta òraru riwinymyhỹre. Iwese iwitxira hãwyy‑wana roireri yrubule taheka òta òraru riwinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Arueõ òraruna‑txi araatykeki, bitake. Awityhymy biu‑ki malòke kawesekile heka awire, Deuxusỹ‑ò malòke wahe. Arue wiòmy tahe awiõmy biu‑txi arue yremy heòty bede‑ò make tahe ibinatyhyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tule eraõ bitake iurelemy era‑di make biu‑txi. Aumy ibutuhukỹlemy heòty bede‑ò rakehãrele tahe awiõre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Bede ywina heka kawesemy ròhònyre iny‑ò juhuu wahe: —Inyõ tahãwyy ixi‑ribi riteònykeki rixãwididỹỹnyra tamy tyyritiõ riritinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Iwitxira rybe‑di jiarỹ arukile tahe hãbu tahãwyy riatyra. Inyõ uritere òta òtana òraru‑ki ixi‑ribi tahãwyy riteònymyhỹre. Tai tahe hãwyy roimyhỹre hãbu witxira hãbuõ‑wana. Tai tahe òta òtadumy kia hãwyy rininire. Adỹỹwe òraru‑ò riteònyre tahãwyy riteònyre uritere òhyynaòle. Tai tahe tii adỹỹwe òrarunaòle heka riteònyre. Taile heka hãwyy hãbu witxiramy heka roimyhỹre ahãbuõ tahãwyy uritere hyynaòle riteònymyhỹre mahãdu hãbu heka. Tii heka tule òtadumy relemyhỹre hãwyy òta òtaduõ heka roireki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Juhuu heka ihetxiu kia wesemy Deuxu tamyreny kia rarybere: —Taholatenyte kiamy Deuxu heka uritere ruiõmy atximahãbenyke Deuxu‑ò biwinybenykemy marybemy bimykeki biwinybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tahe jiarỹ heka kiamy adeereny ararybekre. Aõwidỹỹmy ixi‑di nohõtirenyõmy ryberenyõmy iwidỹỹmy. Ixinohõtidỹỹmy ryberenyõmy ariwinykre biwawiòhenanyke wana biu‑ribi wawiòhenanykre wana. Uritere heka tuu ryberenyõmykre kia wesemy biubrò‑ki aõkõ biu dori Deuxu rynana rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kiamy uritere rybeõmy bedebrò‑ki aõkõ aõ biwinykemy aõmy mabekemy. Bede dori Deuxu idi ratximyhỹre rare. Deuxu waa elehyna dori bede rare. Jerusalẽ hãwãbrò‑ki tule aõkõ, tii dori Iòlòtyhy hãwã rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tule arade‑di widỹỹmy uritere dori rybeõmy kai dori awitxiranyõtyhy arade iura‑ò ilyby‑ò urile araykywydynakile tuu ratxike. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aõma araykywydynakile heka tuu riwitxiranykemy idi tahõtinymyhỹte. Kiamy heka tarybemahãte iwidỹỹnamy teuremy tarybemyhỹte: —Kohe, kiale ariwinykremy marybeke ada aõkõre, ariwinyõtyhymy aõbo. Kiamy marybekeki iratylemy kohe, aõkõre myỹ aõbo. Sõwemy marybekeki tahe aõbina binahakỹle heka ròhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ihetxiu bede ywina ròhònyre. Inyõ witxira rueõ ribinadỹỹnykeki, iny witxira tule iwesele riwinyke. Kia widỹỹdu rue heka ribinadỹỹnyke. Rue heka wilemy raòwynyre rueõwilemy. Juhu tasỹ ỹjuõlemy raòwynyre. Jiarỹ tahe rebedeerynyre kawesemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Inyõ aõbinamy adee riwinykeki, aõ aõkõ tamy biwinyke. Inyõ aòsỹny rihetenykeki, tule iwyò‑di beake rehetenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Uritere aòludu‑ò ixiòwydỹỹõmy. Aõma ijõ atyy ritakeki heka tule tamy arahana biwahinyke. Inyõ sohoji urixinamy adee ixidinymy reake wana. Inatximy heka tii‑wana beake. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Inyõ ixitòedỹỹmy aõ aribi riwykeki tamy biwahinyke tule inyõ aribi aõ huòtemy riwyke wana. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Abròrò itue‑di tamy òkeseõmyke iwòde‑ki ihuòtemy biwahinyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ihetxiu heka taholatenyte kawesemy: —Kai heka aõ hãwã ludu mahãdu luumy heka madònymyhỹke. Aòludumy aki ratxike wana tukumy atxike teramy atximahãke. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","46","Tahe iwitxiramy ararybekre. Aòludu heka arabedeerynyke. Tukumy mabekemy inyõ aõhõkỹmydỹỹnana rotỹỹnyreri wana tamy rexitòenyke. Kia wese‑ki heka inytyby riòremy mabeke, Deuxu riòremy wahe. Tii dori juu riòlòdỹỹnymyhỹre inybina tyre‑ki wahe. Tule iny wiwihikỹ tule‑ki aõma biu heka tule riteònymyhỹre. Aõma iny òbitikõdu mahãdu tule‑ò. Tule òbiti mahãdu tule riteònymyhỹre. Aõma tukumy ahãte sohoji ratximyhỹre sohojile kai itukukeki. Kia heka awi aõkõ rare ibutumy òraru mahãdu heka tule riwinyremyhỹre kia wese. Aõma urile rybedỹỹ azry mahãdu, Aseriòre mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tulesỹ kia aõma aõkõ rare aõma tule heka judeukõdu mahãdu dori tule riwinyke, tii Deuxu rierykõre. ");
INSERT INTO kpjNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Òbitityhymy kaiboho boibeke. Aõma jiarỹ heka arabedeerynyrenyreri biu‑ki inytybyreny ratximyhỹre dori òbitityhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Wahisidỹỹna wiwihikỹ kai hãburu‑ki iwahisidỹỹõmy iny‑ò. Kai itxerenaõnamy biwahinymyhỹ. Aõkõkeki tiu inytybyreny‑ribi bitaõtyhy aòwy awahisidỹỹna. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","4","Kai biwahinykeu iny adee aõmybo rurumyhỹreó. Uritere ibutumy iny itxerenamy iwahidỹỹõmyhỹ. Inyõ‑ò òbiti mahãdumy riwisỹnymyhỹre mahãdu, kia wesemy heka tii riwinymyhỹre heka. Dohodỹỹmy heto‑ki tuu riwinymyhỹre kia wesemy tule ibutumy hãwãhãkỹ ruetyawetyamy tuu riwinyrerimy ihỹre. Inatyhy dori adee rarybereri: —Aõma wahisidỹỹnatyhymy heka adee rarybereri: —Wahisidỹỹnaõ ixidee ritamyhỹre. Aõbo Deuxu wahisidỹỹnaõ heka adee riwahinyõtyhy. Tai heka Deuxu wahisidỹỹnatyhy riwahinyõtyhy tamyreny. Iny‑ò aõ biwahinykeki, abiòatyhy‑ò belyyõke. Wasilemy tamyreny awiòhedỹỹna biwahinyke. Iny tybyreny dori ibutumy aõna aõna ròtena rieryre aõwahisidỹỹna adee kidiwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Iwese budu mahãdu riwinymyhỹre wese uritere iwidỹỹõmyke. Kia wesemy aõkõ heka bexitòenyke. Ibuturu‑ò rexitòenymyhỹre dohodỹỹna hetowo‑ki heka lamamy rexitòenymyhỹre. Hãwãy‑ki dori rexitòenymyhỹre ibutu itxerenakemy. Inatyhymy heka adee rarybere: —Atarasana ibutumy ritare. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Inatyhy dori ritare. —Bexitòenykeu malòke aheto jurawo‑ò. Ixi‑di biijòtòbònyke. Ierykõnamy boo ratximyhỹreò heka bexitòenymy myike. Ibutumy heka boo aõbo wasimy iny riwinyriwinymyhỹremy robimyhỹre. Tai‑ki tahe bede ywina wihikỹ heka adee kidiwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tule rexitòenymyhỹreu uritere irehemy idi lamaõmy uritere ixityre ixityremy tamy ixitòedỹỹõmy wiwesewesehyyle. Judeukõdu mahãdu dori kawesemy riwinymyhỹre. Kiamy heka raraykywydynanymyhỹre aõma rexitòenyre ehehekỹkeki heka roholatyhykemy rohõtinymyhỹrenyre uritere widỹỹõmy iwese tii riwinymyhỹre wesemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Inytybyreny dori rierymyhỹre aõmybo iny raraykynymyhỹré. Inyboho heka rexitòenymyhỹreu rierymyhỹre aõmybo inyboho rurumyhỹrenyre. Iny sõwemy rarybemyhỹrele aõkõ heka tii roholamyhỹre. Aõmybo iny rurumyhỹrenyre, heka bexitòenybenyke. Kia wese: ");
INSERT INTO kpjNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wahareny, biu‑ki atximahãte. Anityhy iny ibutumy rityhynykemy idi rierykemy watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Aiòlòna heka wymy kanake. Iny adeewile riwinykemy iwese biu‑ki relemyhỹre wese. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Wadeereny txuõ txuõ rỹsỹna bidiwahinyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Waòrarunareny õhõti‑ribi bitosadỹỹnyke. Iwese jiarỹ inyõ òraruna wanohõti iribi aritosadỹỹnymyhỹre wese. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Isiratyhy urihixina‑ribi heka biwayrubunyke, òraruna‑txi reseke lau. Aõna aõna bina‑ò bidiwaijebenyke. Iòlòna, ruru, loosòna heka ahõrõhyy rare. Kie. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","15","—Inyõ ariixãwidinykeki iaõbina‑ribi. Tule inytybyreny riwaiixãwididỹỹnyke. Deuxu iòraruna‑ribi riixãwididỹỹnyke. Beinareheke wana. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Uritere aòsỹny bedeòtiidỹỹõmy iwese budu mahãdu rỹira wesemy. Tai heka byreõmy iny‑di txuu rỹimyhỹremy widi retehemyhỹre. Wiji õhõtireny reake. Heka raòwynyra inarehena irareny. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tai narehereheu tainarehenyteu. Atarina‑di ahãtemy beake aòsỹny bisuhòke. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Inywitxira heka anaeryõtyhy kai tenarehemy atxiteri. Inytybyreny sohojile heka rierymyhỹre. Inyõ tuu robiõtyhy. Tii tahe ibutumy aõna aõnamy robimy wasimy rỹiramy. Iribi tahe tii araòwynyrenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Aõna aõna butudỹỹõmy tyy, nieru, aõna aõna wiwihikỹ butudỹỹõmy kabede‑ki. Txudòera dori ibutumy kabede‑ki tuu riroxike aõna aõnamy. Aõma rararỹỹnyke iaõmydỹỹna ibutumy rararỹỹnyke rahuke. Wasidu tamy ralòke. Iaõmydỹỹna‑ò sõweò wyremy rasinyke iaõmydỹỹna‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kaki ibutudỹỹlemy heka biu‑ò bibutunyke. Tai heka txudòera aõ riròõtyhy tule rararyõtyhy. Tule wasidu aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Titxibo aõmydỹỹnana ratxireri iwesele taheka arayky ratximyhỹre. Biu‑ki aõbo ada bede‑ki aõbo. Aõma bede‑ki araykywydyna ratxireri wana heka kakile taraykywydynanyte. Biu‑ki araykywydyna ratxireri wana heka biu‑ki heka arayky aõmydỹỹna butuna raykywydyna ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Arue heka loosòna wesemy rare. Aumy dee itỹnykeki heka aumy ibutumy loosòna‑di tỹximy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aumy ibinakeki tahe bede loro‑ki matxike. Aumy bede lorohokỹ‑ki ratxikeki ibinatyhymy matxike aõma butunale‑di iny rõhõtinykeki heka tiu Deuxu iny riwiòhenyõtyhy. Deòdumy heka releõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Inatxi wedu‑ki dori inyõ rityynyõtyhy. Tule heka tii roholamyhỹre ijõ‑ribi tahe tõhõti rosamyhỹre. Inyõ Deuxu deòdumy releõtyhy tii aõna aõna butunadile rõhõtinymyhỹreki. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tai heka tuu rarybereri adeereny. Uritere nohõtiyreõmy arỹsỹnamy tule atyymy, idi matykynykemy. Aumy dori rỹsỹna ratyre aõnityhymy ratximyhỹre. Tule aumy tyky ratyre aõnimy ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nawii‑di inihe betehebenyke. Tiiboho heka aõòworumy aõkõ ròbròmyhỹrenyre. Aramyre heka aõma tarỹsỹna wydymy bederahymy tarỹsỹna riyrubunyõhyymyhỹre heto nihikỹ‑ò. Deuxu biu‑ki ratximyhỹré heka nawii riyrubunymyhỹre irỹsỹna tamy riwahinymyhỹre. Kaiboho tahe iratyretyhy toite, Deuxu‑ki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sõwetyhymy maraykywydynanykeki aõbohe, arumy aõbo arirarehemy mariake. Aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Uritere nohõtiyreõmyke atyymy. Betehemyhỹ inihe noijasa‑di. Aõma tiiboho heka raaõmysỹdỹỹõhykymyhỹre. Tai tyky wihikỹ‑di rexityynyke. Tyy ixidee riwinyõtyhy. Ihãre tahe Deuxu rityynywihikỹre heka tyy wihikỹ tamy riwahinyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Salomaõ heka itykynihikỹra. Ihãre tahe ityky heka awityhy aõkõ rare. Noijasa heka iratyre ityky wityhyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Deuxu heka noijasa ritykynymyhỹre aõma noijasa heka wijilemy idi ihỹre. Biurasòmy tahe ixãwilemy reamyhỹre, risõra. Tii heka tyky adee kidiwahinykre. Nohõtiyreõmy tahe. Tii dori adee kidiwahinykre tykyõ. Aityhyna dori ibutetyhyre heka. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tahe raykyõmy nohõtiõmy titxiribibo arỹsỹna bidiwykré, atyky amona. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tyhydỹỹdukõdu mahãdu heka kiaòle heka ritõhõtidỹỹnymyhỹre. Inytybyreny heka rierymyhỹre aõmybo tarumahãte. Ibutumy heka araerymyhỹre aõmybo taruterimahãte. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tii Deuxu aõma dỹỹnana sohojidile. Manaykynykeki heka tii ibutumy adee riwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Uritere nohõtiyreõmy aõbo biurasò kia aõmydỹỹnana‑ò. Rỹire dori sõwemy wiji biaõmysỹdỹnanykremy biwinykré. Iwitxiramy bidiwinykre iwitxira aõmydỹỹnanaõ. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iny witxira witxira‑di ywisidỹỹõkeki. Aywisidỹỹna wesemy heka Deuxu ruxetòena‑di ywisidỹỹmy araywinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Iny teywinymahãte wesemy heka Deuxu araywinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kai heka òwòru nihikỹereõ arue‑ki ijõdikeki, aõherekibo bederarasi sõmo‑di inywitxira rue‑ribi bitakemy atxiteri. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tai heka kai bobiõtyhy itarasa‑ki wahe. Arue‑ki dori òwòruere ijõdireki heka bobiõtyhy. Òwòru ere dori aòraruna sõwemy rỹire wesemy heka atximahãte. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kai texibònyteri. Aòraruna‑ribi juhuu bexiòbitinykre. Idi tahe aseriòre òraruna‑ki biwiòhenanykre. Aòraruny‑di rierymy idi òbitimy betehekre iòraruna‑ribi iixitarasadỹỹmy biwiòhenanykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Inyõ heka utura rati mana wiwihikỹ‑di rehuõtyhy aõma ixỹni herina‑txi. Ixỹni dori ityre rariake tahe riõnonyke adee heka kanakemy wahe. Iwese tule heka ijòròsa‑ò biwahinydỹỹõmyke. Rybewiwihikỹ hãbu òrarudutyhy‑ò iwahisidỹỹõmyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","9","Rexitòenykeki tahe bitake kia. Biekeki tahe tai mahake. Bihetenykeki heka iny adee riraynyke ijòtòbòna. Inyõ heka Tyby‑ò rỹsỹnaõmy rexitòenykeki, mana heka tyby tamy riwahinyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Uturaõmy rexitòenykeki tahe hemylala binahakỹ tamy tiu riwahinyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kai aõna aõna wiwihikỹ biwahinyke heka teerymyhỹte auladu‑ò wahe, hãbu òrarudu hãrele wahe. Aõbo heka tule Deuxu inytybyreny inydeereny riwahinyke aõna aõnaõ wihikỹõ. Rexitòenykeki tahe tamy ariwahinyke. Inytybyreny heka tamy riwahinyke. Iwese iny witxira teyrubunymahãte wesele heka iny araywinymy ixi‑di tahõtinymahãte wese. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tule kai aõwiwi inyõ ixidee aõhebo rotỹỹnymyhỹkemy taruterí, kiaweselemy tamy botỹỹnymahãke. Kia heka Moisesi bede ywina tyyriti‑ki roire. Kiale Deuxumy rybedu mahãdu ribedeerynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Biu bede wiwihikỹ kia ryỹijòhỹtỹdile malokre. Heòty ijò bederyijò heka nihikỹ rare. Iny kia ryhykỹ irumy rakre heka isirare iny ibute kowa ralore. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Irumy nonona ijò tahe ihỹtỹre. Ryy heka ihỹtỹre heka ibutere iny ryhỹtỹ‑di ròtedu timy bede erydỹỹkõdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Bexiijebenyke kia mahãdu lau Deuxu rybe rybedu mahãdu tyhymy aõkõ lau wahe. Budoeni wese ratximyhỹre inytyhy wesemy. Tawo‑ki tahe inatyhy rare ahola debore wesemy heka ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Teeryte wesemy ibederaty‑ò betehekeki. Hede‑ò heka uvamy figomy tule tiu iratyõna. Iaõmydỹỹna‑ò bierybenyke tibo roiré. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Tii heka bierybenyke aõhebo rotỹỹnyre wana teerytenyte. Tii heka riitxenanyõtyhy kia aõma matyty matynimy heka tiu biitxenanyõtyhy. Tule betehekeki, bierybenyke aõwesele heka òwòruõ bierybenyke. Aõma bederatyõ birỹsỹkeki tiu heka bederaty wihikỹõ arỹsỹõna òwòru ratyy‑ò, bederatybinahakỹ tule rierykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Òwòruõ bederaty wihikỹmy raratynyõkeki heka hemy raòròròke rokoke. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","21","Kia weselemy heka iny teerytenyte. Aõhebo iny rotỹỹnyke wahe. Tai tahe terytenyte heka, tetehetenyterikile wahe. Òbiti mahãdu wesemy rarybemyhỹre. Tahe òbitimy aõkõre ihỹre. Sõwemy heka iny tawedumy riwaninire. Ihãrele tahe biu‑ò ralòõtyhy. Deuxu tyhydỹỹdule tahe ralokre. Ywisidỹỹnatxu heka kawesemy wadee rarybekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sõwemy iny wahe: —Wanyrỹ, Wanyrỹ, jiarỹ hewa iny iwitxira sõwemy aijyy rarybemy rare wahe. Tule heka tyytybybina reteònymy rarewãhã. Tule deytena wiwihikỹ heka ani‑di rewinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tai tahe jiarỹ tamy ararybekre heka: —Kõrehe, kaiboho aõ wamahãdumy aõkõ atximahãte. Umy reerykõre. Waribi bexitake. Aòraruna dori sõwere. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kawesemy heka iny bede eryna ratximyhỹre. Warybe‑ò roholamyhỹreu heka aõwesele riywinymy rityhynymyhỹre. Kia hãbu hetowidỹỹdu wesemy heka rare. Iheto heka manatyre‑ki riwinyre. Tii heka ibedeery sõwemy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Biu heka beòra heka rariamyhỹre. Iu tahe biu rejuxunymyhỹre, yhy rebonyre. Tahe tiu reseõtyhy manatyre‑ki dori riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Warybe ijohonadu tahe iwitxiramy ihỹre. Hãbu itxỹte tahe warybe‑ribi aõwesele tõhõtireny rosamy reamyhỹre. Kaiboho aõbedeeryhykỹ aõkõre roire. Tii heka iwese hãbu ỹnarakile heto riwinymyhỹ wese rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Biu risebenykeu, beòra rareareu, yhy rebonyreu tahe iheto reseke, ibutumy iõre, rahura. ");
INSERT INTO kpjNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Ibutumy heka Jesuisi rybe erysydỹỹna‑ò bede riòtiinyre. Tii heka hãbu erysydỹỹdu wesemy tii ribedeerymyhỹre. Aõ judeu wedu wesemy aõkõ ribedeerynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tiu hãwãlò‑ribi dobehedeu, sõwemy heka iny ihemy doidemyde webinadu, tybina heka tamy nade. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wowydyna rybe‑di heka tamy rarybere: —Adee wikeki heka kai biwateytenyke. Jesuisi dirawyònyde: ");
INSERT INTO kpjNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","—Wadee awire, arateytenykre. Tahe tamy tebò ritytere tamy reerimy. Ityybinana riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tahe Jesuisi tamy rarybere: —Boholakre, iny‑ò uritere rybeõmy. Kai tahe makre xiwena wahidỹỹdu‑ò xiwenaõ biwahinykre. Idi tahe Moisesi bede ywina raryberewesemy xiwenaõ biwahinykre. Kai tahe iny rierykemy heka yteny ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesuisi Kafanaõ hãwã‑ò rehemynyreu heka hãbu soldado weduõ tamy rehemynyre. Tii tahe Jesuisi‑ò rexitòenyre: ");
INSERT INTO kpjNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Wadeòdu biteytenyke raterenymy ratxireri waheto‑ki. Sõwemy aõhõkõmy rotỹỹnyreri. Ibinatyhymy roireri rexisiranymy raratykõhykylemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tai tahe Jesuisi tamy rarybere: —Rakakre, tai ariteyteynykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Idi soldado wedu rariwyònyre: —Aõkõre, Kai hãbu wiwihikỹ tate. Jiarỹ tahe hãbu aõ aõkõmy jiarỹ watxiwãhãre. Waheto‑ò manalòõtyhy. Karibile marybekre tamy taile taile tahe wadeòdu reytekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jiarỹ dori reyryre. Jiarỹ heka tule hãbu weduõmy watxiwãhãre. Soldado heka sõwemy riwatyhynymyhỹre. Iny sohoji‑ò aõma rakremy rarybemyhỹré heka, ramymyhỹre. Tule ijõ dee rarybemyhỹre: —Manake, tai tahe namyhỹde. Ijõ dee rarybemyhỹre wana: —Kai biwinyke, idi riwinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","11","Tai tahe Jesuisi ribedeòtiidỹỹnyre irybe‑ki wahe. Tahe rarybere erydỹỹna mahãdu‑ò: —Judeu mahãduy‑ki tai rahaõre ijõ‑ki kahãbu wesemy inatyhynana sõwereki. Sõwemy heka judeukõdu mahãdu rityynykre kia weselemy. Ijõ txu aõ wiji aõkõ heka riroxirenyke: Abraõ, Ijai, Ijaò‑wana biu‑ki heka riroxirenyke bede ludu iny mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Judeu mahãduõ ròirenyõkre tamy. Tule kaibohoõ tahe aõhetykrebo. Ijõ mahãdu dori bede lorohokỹ‑txi resekre. Taiki tahe irynamy rurykre aõkõmydỹỹnana‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Taita Jesuisi soldado dinodu‑ò rarybere: —Makre, timybo wiji tahõtinymy tetyhynyte wesemy heka rarekre. Iurele teòdu reytere. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iribi tahe Jesuisi Pedro heto‑ò ralòre. Iriòre lahi heka aõma rubuna nihikỹ roimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tahe Jesuisi rimyre tebò‑di tamy rerire. Idi tahe irubuna iribi ròhònyre. Tai tahe tii ronyre. Ronymy tahe rỹsỹna riwinymyhỹ tamyreny. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Txiorotyhymy inyõ didyde aõma tyytybybina nihikỹ‑di ratximyhỹõ. Iu Jesuisi sohoji rybeõmy rarybereu tahe aõwesele iribi ròhònyre. Kia webinadu didyde, tule reytere. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iwese ihetxiu Isaia ryberiti rarybere wesemy heka tule riwinyre: Jesuisi riwinyre. Kiamy wahe. Wabinanareny waribireny riwyre. Inatyhyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iny sõwemy ributunyreu. Tai tahe taerydỹỹna mahãdu‑ò tii rarybere: —Rokoirenyhe kanawe‑ribi ijà‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tai judeu mahãdu, bede ywina bederydỹỹduõ tamy rarybere: —Awana arakre titxibo makreu heka ahekile anakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tahe Jesuisi dirawyònyde tamy heka rarybereri: —Ijòrò heka ihãloo dire, ibỹtỹ dire, nawii bỹtỹ isỹ dire. Tahe jiarỹ, Deuxu Riòre Hãbutyhyhykỹ wahe, wahetoõre, waherinaõre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ka ijõ iheludu mahãduõ tamy rarybere: —Wanyrỹ, waha heka rurura. Tai heka juhuu arituunykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tamy rarybere: —Manake, wijile biwaheludunyke. Rubuõmy rỹira, rubu mahãdu heka rituunykemy idi ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesuisi hãworo‑ki ronyre tahe reurore. Ieryredỹỹna mahãdu riheludunyrenyre kia lawokile. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ahobetya‑ki tahe yhy debore nihikỹ tamyreny rehemynyre. Tahe òbò nihikỹmy resemyhỹre. Uritereribile yhyhykỹ bee riòbònyra hãwò rilỹmynyke iòhòtyhyre. Jesuisi tahe rõrõmy roimyhỹ iu. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tai tahe ierydỹỹna mahãdu heka riixixadỹỹnyre. Tamy raryberenyre: —Biwayrubunyke, Wanyrỹ. Aõkõkeki, rukururenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesuisi tamyreny rarybere: —Aõherekibo kaiboho taberutenyteri? Aityhyna sõwe aõkõ atxitenyteri. Jesuisi tahe rỹimy reare. Yhy debure‑ò, òbò‑ò rarybere: —Biyryke, bede binahakỹ. Tahe aõwesele ibutumy riyryra. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ierydỹỹna mahãdu urile ribedeòtiinyre. Tiiboho raryberenyre: —Aõhãbubo tii ihỹre. Òbò, tahe yhy‑wana tamy roholare. Iwese tii rarybere wese rityhynyre. Irybemynale riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kalileia aho ijõ weribi ijana‑ò ritehemynyre. Kowa bede heka Kadara inire. Tule hãbu inatxi heka tyytybybina‑di tai rasỹnyrenyre wabedewo‑ki. Kiary‑ki tahe ibutumy iny ruberure. Iribi tahe ròhònymy reare. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aõwesele heka ryrymy roirenyre Jesuisi‑ò rarybekremy: —Aõwe wadireny tate, Deuxu Riòre? Kai aõbina binahakỹmy wahõrõdỹỹõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tahe kowa‑ki ixỹni juramy riroximy rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tyytybybina tahe Jesuisi‑ò rexitòenyre: —Biwatòenybenykeki, ixỹni jurawomy aralorenykemy biwateònyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tahe Jesuisi rarybere: —Bòibenyke hãbuwo‑ribi. Tahe ròirenyre ixỹniwo‑ò. Ixỹni jura tahe ibutumy rejuxunyre ijòtira‑ribi. Berawo‑txi tahe rabòròròre. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ixỹni‑di itxeredu mahãdu tahe hãwã‑ò roirenyre ijyymy. ");
INSERT INTO kpjNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kia hãwã ludu mahãdu tahe roirenyre Jesuisi‑ò itxeremy. Tai tahe tamy rarybere ibede‑ribi ròhònykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ribererenyre aõma hãwò nihikỹro‑ò reuròrerenykremy kanawe‑ribi ijà‑ò. Tai tahe Jesuisi tahãwã‑ò rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tai tahe didydenyde weryrybòõ byre‑di idi betyky‑di ramyremyrenymy roimyhỹre. Tahe hãbu mahãdu inatyhyna Jesuisi rieryreu heka hãbu dee rarybere: —Waexi, beysake, aòraruna dori reixãwididỹỹnyra. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tai tahe ritidỹỹna bederydỹỹdu mahãdu retehereri. Ixideele heka rarybemahã: —Kia heka ibinamy Deuxumy rarybereri. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iyky Jesuisi rieryre tahe tamyreny rarybere: —Kai aõbo ibinamy waki tahateri arayky‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Timybo heka kaiboho tahõtinyteri. Aõma iòraruna ariixãwidinyke aõbo ada iumy ariteytenyke aõbo? Aõbohe isiratyhyre wadee tahõtinyte wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Deuxu‑ribi waruru dire. Kabede‑ki heka òraruna ariixãwididỹỹnyke jiarỹ heka Deuxu Riòre Hãbu tyhyhykỹ rareki wahe. Tamy rarybekre: —Myike, abyre bimykre ta mariakre asỹ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tai tahe hãbu aõwesele rỹimy reare. Tahe taheto‑ò rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tahe bede inysõwetyhy heka ribedeòtiidỹỹnyre. Deuxu heka wowydyna riwahinyre. Tii iny‑ò ruru riwahinyreki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesuisi iribi rariamy rare. Tai tahe tii Mateu‑wana heka witxi reare ryki: —Jiarỹ heka nieru butudỹỹna heto‑ki ranymahã. Jiarỹ rebutunymahã aõma inyòwydỹỹna heka rebutunymyhỹre. Iu Jesuisi wadee rarybere: —Manake waerydỹỹnaõmy heka beleke. Tai tahe jiarỹ tii‑wana heka rare aõwesele heka ihemy rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tai jiarỹ retobinyre kanakemy waheto‑ò. Waheto‑ki riroxikemy taerydỹỹna mahãdu‑wana. Tai tahe sõwemy heka iny waery mahãdu dòidenyde, òrarudu nihikỹ mahãdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tule heka fariseu mahãduõ tai ratximyhỹ. Tahe Jesuisi erydỹỹna mahãduõ kiaõ‑ò heka rarybere: —Aõherekibo Jesuisi òrarudu nihikỹ mahãdu‑wana riroxireri? ");
INSERT INTO kpjNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Tai Jesuisi roholarehe tamy rarybere: —Aõma òhotibedu heka, webinadu mahãdulemy aõnityhymy rarumahãre. Òhotibedu‑ò kanakemy. Binadu mahãdu‑ò tahe tiu ararariòwyõtyhy aõma òbiti widỹỹdu mahãduòle heka anade. Warurumy rurumyhỹle mahãdu ariwiòhenanykemy anade. Aõ awihikỹmy ixi‑di rõhõtinyreriò aõkõ wahe. Deuxu Ryberiti‑ki tahe kaweselemy roire: Ixiwe heka wadee awiõre aruxetòena wadee awire. Kaiboho bierybenyke aõbo katyyriti rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tahe Jesuisi‑ò rarybere Joaõ eryna mahãdu: —Aõherekibo Joaõ Sebedeỹỹdu kia erydỹỹna mahãdu renarehemyhỹre rexitòenykreu. Fariseu mahãdu erydỹỹna heka tule heka renarehemyhỹre. Ihãrele taheka aõherekibo abedeerydỹỹna mahãdu heka tiu iwesemy riwinymyhỹre. Aõherekibo ka. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Taita Jesuisi dirawyònyde: —Iu iny inyhãwyymy roimyhỹreu heka iny reysamyhỹre. Aõma kia weryrybò hãwyy kialiina heka teysamy ratxirerimy ihỹre. Tiu rirubunyõhymyhỹre teti‑ò. Tahe aõutxumy tahe weryrybò hãwyymy heridu heka inyõ ritakremy ratximyhỹre. Iu tahe renarehekre heka. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Uritere inyõ deratyby ritòbònyõtyhy tyytỹmyra‑di. Inyõ itòbòna tỹmyra‑di ritòbònykeki, raykake heka iura ranihikỹke. Aõma iwesele rare aõma vĩĩ tỹmyra iròdutyy tỹmyrahakỹle ritidikreu. Aõma itỹmyra‑ò heka iròdutyy itỹmyrahakỹle raykake. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aõhe tiu vĩĩ tỹmyra iròdutyy tyby‑ò rihynyõtyhy. Inyõ kia wesemy riwinykeki taheka raykake heka rejuxunykre irube. Ihyna heka rabinake. Vĩĩ wihikỹ taheka aõma iròdutyy tỹmyra hyynawo‑ki ka awimy rỹike. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iu dohodỹỹdu hetoõ bede erydỹỹduõ heka Jesuisi‑ò nade tariòre rurureki wahe. Tai ta Jesuisimy reàlàre tamy heka rarybere: —Aõma wariòre rarurura wahirari wahe. Kai waheto‑ò manake wariòre ruru‑ribi biixixanykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tahe Jesuisi taerydỹỹna mahãdu‑wana roirenyre tii wana wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Tahe hãwyy rõhõtinyre heka: —Jikarỹ heka ityky reroti‑kò karirikrekule karekytekre. Tii dori ihãlubu rihyõhyy raremyhỹre waò inatxi reurò beòramy. Iòhòmy iribi reare. Ireroti wereysanakile rimymy resere. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Taita Jesuisi ròòsemy reare. Tuu robire tamy rỹraxire: —Lerỹ, awi heka rare. Aityhyna heka arateyteynyre. Inatyhymy teyteta. Tai tahe hãwyy aõwesele reytemy reare. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Idi tahe aõwesele rehemynymy reare. Judeu wiuna bedeerydỹỹdu heto‑ò rehemynyre. Tai heka hãwyy sõwemy robumy rỹimyhỹ rubura‑ki rawiunymy rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tai tahe Jesuisi tamyreny rarybereri: —Bòibenyke hewahe. Hirarihikỹ heka ruruõhyky roireri. Urile heka rõrõmy roireri. Tahe iny rutxuenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tai iny sõwemy ròhònyre iribi. Tahe Jesuisi ralòre titxibo hirarihikỹ roireriò. Debò‑ki rimyre tahe riteytenyre. Rexixare ixyby. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ibutu bede bedemyhe inina‑ò roholare. Kia deytena riwinyraò. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tahe hãbu ruetà inatxi Jesuisi riheludunyre heka. Kia hetoy‑ribi wahe. Tamy heka raryberenyre: —Kai heka iòlò Davi riokore tate. Tai tahe ruxetòena‑di biwawotòenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Idi tahe Jesuisi taheto‑ò ralore tai rasỹnymy ratximyhỹò. Iny mahãdu ihewomy rare tahe ralòre. Tamy rarybere: —Inatyhymy aõbo tetyhynytenyte, ixyby arãitxeredỹỹnykeò. Tiiboho raryberenyre: —Kohe Wanyrỹ, retyhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesuisi rarybere: —Ainytyhynadireki arue tabita. Aõwesele robirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","31","Jesuisi heka rarybere tarurumy tamyreny uritere ijyyõmykremy. Tai tahe aõma ròirenyre ibutuko relyyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Idita tako‑ò rexidorunymy reareki tasỹ kia hãbuõ‑txi reare tyytybybina‑di ratximyhỹõ. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tahe Jesuisi‑ò didydenyde hãbu irybeõna kia tyytybybina òraru‑ki wahe. Jesuisi tuu òlòdỹỹnyre iribi. Iule tahe hãbu aõwesele heka rarybere iroo‑ki. Kia iny ibutumy ribedeòtiidỹỹnyre. Timy heka rarybeõhyyre iko‑ki juhuu raremyhỹu. Tuu rabiõhe iwesedỹỹnadumy. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Idi tahe fariseu mahãdu rarybere: —Tyytybybina‑di ratximyhỹre. Tai heka tyytybybinahakỹ reteònymyhỹre iny‑ribi. Ihãrele heka Satanasi‑di ihỹre. Tyytybybinatyhy wedu heka ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","36","Idi tahe ibutumy hãwã hãwã‑di Jesuisi rariamy rare ròbedeerydỹỹmy. Judeu mahãdu dohodỹỹna heto‑ki relyymyhỹre, Rybewihikỹmy. Tai Iòlòna kia ritỹnynymy tuu relyymy. Ibutumy iny bina bina kia heka riteytenyre. Iny nade ihewo‑ribi. Sõwemy heka iny aõna aõna bina binahakỹ riwinymyhỹre idi rỹimyhỹ. Titxibo rakre heka rieryõhykymyhỹre ta aõna aõna òraru‑ki idinoduõreki wahe. Tai tahe Jesuisi riwotòenymyhỹre ibutumy tiiboho dori budoeni wese ratximyhỹre, itxeredu ihoõreki. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tai tahe taerydỹỹnana mahãdu‑ò Jesuisi rarybereri: —Iny heka maixõmo sõwehekỹ rỹira wese heka iny ratximyhỹre. Aõma ibutelemy heka arixidu rỹira. ");
INSERT INTO kpjNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bexitòenyke Deuxu‑ò. Tii heka bederomy maixõmo rỹira wedu rare. Bexitòenyke tamy aõbo maixõmo arixidu‑ò kiditeònykemy. Irybe‑di heka raaõmysỹdỹỹkre ibedero‑ki. Ibutu bedero‑ki heka idi raaõmysỹdỹỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ributunyre Jesuisi aõma tawa‑ò inatxi reurò kia bede erydỹỹna mahãdu. Tamy heka ruru riwahinyre. Aõma tyytybybina riteònykemy. Tule tamy riwahinyre ibutu binana deytena heka riwahinyre tamy. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kia heka tadeòdỹỹmahãdurenynimy ararybekre. Juhuu heka Simaõ Pedro. Juhuu heka Simaõ inire, ihewomy tahe Pedromy naninide. Andre ijõ. Tii heka Pedro seriòre rare. Txiau, Joaõ‑wana heka Zebedeu riòre rare: ");
INSERT INTO kpjNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi tasỹ ijõ rare. Idi tahe Bartolomeu ijõre. Tome ijõre. Mateu ijõre, jiarỹ wahe. Jiarỹ nieru tarasaduõ rare, imposto tarasadu wahe. Ijõ Txiau tasỹ Afeu riòre rare. Tadeu ijõre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simaõ ijõre. Tii Kana bede luduõ rare. Judasi Isariò ijõre. Tii heka Jesuisi tyhedỹỹdu rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesuisi taerydỹỹna mahãdu waòinatxi reruòmy riteònyre. Tamyreny rarybere: —Judeukõdu mahãdu‑ò aõkõkre reteònyre. Aõma Samaria mahãdu hãwã heka ralòõhyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kaiboho heka bòibenyke judeu mahãdu‑ò sohojile. Tiiboho Israeli riokore mahãduõ ihỹre. Aõma budoeni reòsamyhỹre mahadu wesemy tiiboho ratximyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Aõma tamy marybebenyke: —Deuxu Iòlòna biu‑ki heka aõwesele kedehemynykemy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Webinadu mahãdu heka biteytenyke. Aõma iny rubu‑wana witxi beakeki, biixixadỹỹnyke rubu‑ribi. Tykybina yjy yjyhykỹ‑ribi iny biteytenyke. Tyytybybina inywo‑ribi biteònyke. Iwese aõ tetate wese iòwykõ heka ijõ‑ò biwahinymahãke, iòwykõ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Uritere nieru wydyõmy, womati tỹrỹrỹhỹkỹ nieru aõkõ, prata womati nieru aõkõ, cobre womati nieru aõkõ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Aõma anieru hyna nihikỹ wydyõmy, awa ijõ wydyõmy, ijõ dera wydyõmy. Aõma òwòru arirana wiòhedỹỹna wydyõmy. Aõmysỹdỹỹdu taòwy riwykre. Kia òbitire. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Hetoõ malòke. Kia heka arayrubunykre. Adee riwahinykre ibutumy aõmybo rarumyhỹkre. Iu hãwãõ‑ò malokreu, hãbu ityhydỹỹdu mahãduõ biijekre. Taihyy bonykrehyy tahe iwitxira hãwã‑ò iribihyymy makre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Iu hetoõ‑ò malòkeu Deuxu ywina tamy marybekre, Deuxu deysanamy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kai awimy ityhydỹỹdu hetomy rỹike wana, biwahinyke aàlàna tamyreny. Kai òbitimy aõkõ atxiteri wana tahe uritere tamy Deuxu deysanamy tamy wahidỹỹõmy. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aõma tii arybe‑ò roholaõkeki, kai hãwã‑ribi bexitake taheto‑ribi wahe. Tahe iribi bòhònykeu tahe awabrybyxi biubỹtỹnymy bòhònyke. Tii tahe tamyreny rioimyhỹre. Aõma tamyreny ibinatyhykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Inatyhymy heka adee ararybekre. Sodoma hãwã mahãdu, Komora hãwã mahãdu inatyhymy heka ibinare tamyreny tahe isiraõkre aõhõkỹmy dỹỹnana wahe. Aõma kia hãwã arybe‑ò raholara heka kia ratyre heka tamy isiraõkre. Kia hãwã tahe aõnityhymy aõhõkỹmy rotỹỹnykre. Ywisidỹỹna txu heka rỹekreu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Iwese budoeni ijòrò aholay‑ki rỹikre wese heka kaiboho boibekre. Hemylala erydỹỹna wesemy heka maraykynykre. Idi tahe sõwemy aõma ywina‑di maraykynybenykre bòtòewesena‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","18","Uritere inatyhy heka aramykre araròtenykre dohodỹỹna hetowo‑ò adi ralokre. Waòraru‑ki heka bede dinodu mahãdu heka araywisidỹỹnynakre. Judeukõdu mahãduko Rybewihikỹ Tỹmyra rarybekre. Tiiboho arahãtenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aõ heka belyyke ikoreny ibutumy roholakemy. Aramykeu heka uritere nohõtiõmyke aõmybo marybekremy ywisidỹỹna‑ki wahe. Bede heka ariwahinykre rybe ibededỹỹnanau. Rybeõmyke, urile rybeõmyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kai ixiwanale aõkõ marybeke. Aõma Deuxu Tyytybytyhy arãwiòhenanymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Inyõ heka taseriòre rityhenykre. Tybyõ tule tariòre rityhenykre. Aõma iriòre tasỹ tyby‑ò iky reakre idi rirubunykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ihyy ibyrymy heka aluu aõkõkre waòraru‑ki. Ibutumy iny deramy rarehyyke waòraru‑ki: Inyõ tule òbitimy rarekreki, ikonanatxu‑u, Deuxu Iòlòna‑ò ralokre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tahe anatakre. Aõma hãwãhãkỹõ‑ki atxikeki mahenykre ijõ hãwã‑ò. Ihewoludu ikonana hãwã hãwãhãkỹ‑ribi behemynyke‑ribi tahe adòòsekre. Judeu hãwãhãkỹõ‑ò behemynykrekõule tahe adòòsekre, jiarỹ Hãbutyhyhykỹ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Aõma bedeerydỹỹdu mahãdu tahe aõma ierydỹỹna mahãdu ratyre rare. Tule iwedu deòdu ratyre heka ihỹre. Iwesereny tahe boibebenykre. Tahe awedu tate. Inyõ tahe riwarinimyhỹre Satanasi, Belisibu wahe raremy. Tahe iwesele heka iny araninikre waweselemy, ibinatyhyre wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","28","Jiarỹ adee wiji relyyreri. Biurasòmy heka tuu bedelyykre ibutu ijohonanamy adeereny relyyreri. Wasimy wijirumy adeereny relyyre. Biurasòmy tahe ibutu ijohonanamy tuu belyybenykre. Uritere ilau brebuõmy. Aõbo wasimy rỹire heka ibutumy ratỹnykre. Uritere ilau brebuõmyke. Adeelekre rirubunykre atyytyby ta rirubunyõtyhy. Iruruõre dori atyytyby rirubunyké. Deuxule tahe bityhynyke. Tii dorihe iruru‑di heka rare. Tii bede luru‑txi heka atyytyby bede luru heòty‑txi heka adi rehuke. Bityhynyke idile maraykynyke. Hãbu lau brebuõmy hãbu aõbina bina riwinymyhỹre lau brebuõmy. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nawiiõ iny riwymyhỹre womati nieru iyja‑di, iòwy riòre iny heka riwymyhỹre. Ibutumy heka Deuxu nawii rieryre sohoji sohojimy. Tiu heka Deuxu rieryõhyymyhỹre nawii sõmo rurumyhỹreu heka tiu rieryrykõmy idi reteheõtyhy. Kiawese aõbo tahõtinymahãte. Aõkõre, inatyhymy idi retehemyhỹre. Ijõ rurumyhỹreu heka tuu robimyhỹre. Aõma Deuxu heka anaerymyhỹre nawii sõmo ratyre heka aumy rierymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ara erymy heka aõma arati‑ki tiwesebo radeti rỹimyhỹre heka rierymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Breburenykõmykre, kaiboho dori nawii ratyre Deuxu‑ò toite. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","33","Kai marybeke: —Jiarỹ retyhynyre dori tahe umy arelyyke. Jiarỹ heka umy ararybeke inynyrỹ dee biu‑ki wahe. Iny sõwehekỹy‑ki riwatxiõnykeki tule aratxiõnyke jiarỹ Wahako‑ò. Jiarỹ heka suò anade. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Aõ ywina wydymy aõkõre heka anade. Jiarỹ heka ywina aõkõre diwyde. Bedejeijeidỹỹmy anade iribi wadee wou rỹikremy. Hãbu heka tybe òludumy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tule hãwyy tadi òludumy arisynykre. Tule iriokorese tariòrelahi òludumy arisynykre. Aõma inyõ òludu heka tasỹ mahãdu òludumy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Boluu adireny boreny heka boibekre. Kia luumy heka boibekre. Tai tahe iratyremy boibekre aõkõkeki tahe waluuõkeki tahe wahõrõ mahãdumy aõkõ boibeke. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","39","Kaweselemy boibeõkeki. Tai tahe kai wahõrõ mahãdumy aõkõhe mabekre. Aõma biyrurubunytyhykeki tahe kai ihãrele aõkre. Aõma kai waòraru‑ki aõhõkỹmy botỹỹnykeki wadee waaõmysỹdỹỹ òraru‑ki inyõ anarubunykeki aõhe adee rutỹỹnykeki. Tai tahe aumy ròhònykre inyõ tasỹ‑ò aradykeki iwese tii tasỹ‑ò riwadyra wesele heka aradykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Tii riwadyra wana Deuxu heka ridymyhỹre riwateònyreki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Deuxu rybeduõ bidybenykeki. Tii Deuxu‑ò arãwahinykre. Deuxu adee uriiõno kadiwahinykre. Adeereny kidiwahinykre. Wahisidỹỹna ritakre wese heka tule kai bitakre. Adeereny ararybekre. Deuxu hõrõ mahãdu heka bimymahãbenyke. Aheto‑ò bidybenyke hãbuwi ihỹrenyre. Tiiboho dori wese uriiõno ritarenykre wesele kaiboho bitabenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kai uladu‑ò bemonaõ biwahinykeki bedi imonamy. Tai tahe kanakre inatyhymy adee aõ kidiwahinykre. Kai waòraru‑ki ityhydỹỹdu‑ò bee biwahinykeki, inatyhymy heka aòwy adee kanakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesuisi heka rexihure aõma taerydỹỹna mahãdu waòinatxi bedeerydỹỹna‑ribi. Kia bede ywina tamyreny riwahinyre. Rexihureu tahe rare ròhònyre iribi hãwã‑di. Aõma rybe ritỹnydỹỹmy rakremy hãwã hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Idi tahe ròtenywokile heka iu Joaõ roimyhỹ. Aõbo Jesuisi tahe iu aõna aõna wiwihikỹ ritxienymyhỹreu heka Joaõ tamy roholare. Ròtenywo‑ki roimyhỹ‑ribi. Idi tahe Joaõ taerydỹỹna mahãdu riteònyre Jesuisi‑ò dỹỹraximy: ");
INSERT INTO kpjNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—Kohe, anaraòdenyde tate. Aõma Deuxu deòdỹỹna wahe kanakre aõbo ihewo‑ribi. Ariraòrenykre aõbo urihimyò. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tai Jesuisi rirawònyre: —Aõma bòòsebenyke ixybyle Joaõ‑ò. Belyybenykre ikò aõna aõna wiwihikỹ rewinyre arureny‑ki tule tabite wamyreny. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aõma iruetàhàkỹ heka. Reruedỹỹnymy rare wahe. Itiere tasỹ retinywãhãre dinoduhukỹ ityy reytemyhỹre. Aõma ijõ Rybewihikỹ Tỹmyra roholaõhyymyhỹre tasỹ tule reijohonadỹỹnyre. Aõma rubu tule rubu‑ribi reixixadỹỹnyre. Rybewihikỹ Tỹmyramy heka retỹnydỹỹnyre ibutu iny‑ò wahe, iny aõkõ mahãdu‑ò wahe. Tule Joaõ‑ò marybebenyke kaweselemy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Maratyhybenykeki, beysabenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Iribi ròhònyreu tahe Jesuisi heka rarybere Joaõ bededỹỹnanamy. Aõmybo wahe Joaõ‑di rõhõtinyrenyre aõmy tuu bedi nohõtinyrenyre tamy itxereny bederahy ròirenyreki wahe. Otxirarade wese yhy‑ki tahõtinyteri. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","9","Ada aõma hãbu urimynodutyhymy aõbo idi rõhõtinyrenyre. Aõma butòre wesemy idi rõhõtinyrenyre. Ada iwitxiramy aõbo idi tahõtinytenyte hãbu tyywihikỹdiremy idi rahõtinytenyte. Iòlò taheto wihikỹ‑ki ratximyhỹre. Aõkõre, kia iny heka aõ Deuxu rybeduõmybo tahõtinytenyte. Inatyhy tii kia rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iratyre heka tii rare. Aõma dori Tyyriti‑ki rarybemyhỹre: —Tii heka wako‑ki kadehemynykremy ratximyhỹre, wamy relyykemy, wary riywinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","14","Inatyhy heka rare. Tii heka ibutu hãbu ratyre ratximyhỹre. Ihãrele tahe heka Deuxu Iòlòna‑ki heka ijõ iny iratyre ratximyhỹre. Hãbu binahakỹ heka Deuxu Iòlòna‑ò raaõbinanymyhỹre. Joaõ rexidelenyre rybe itỹnydỹỹmy rexidelenyreuhyyle heka ritelemy ralore. Tule wiji nalòmyhỹde sõwemy. Iu Joaõ rehemynykõle heka tuu rarybemyhỹre ibutu Deuxu rybedu mahãdu heka tuu rarybemy raremyhỹ. Tule Moisesi bede ywina kia rarybere. Tii Eliasi wesele ihỹre. Tetyhynytenyte aõbo. Iwese Deuxu rarybereri wesemy heka tii nade. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Inyõ ierysymy rurukeki, roholake wiji. Aõmybo ararybekre kainymy tiwesebo rỹimyhỹremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tiiboho heka iwese weryry uladu risinymyhỹre wesemy ihỹrenyre. Kiamy heka tiinamahãdu‑ò rarybemyhỹre: ");
INSERT INTO kpjNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","—Jiarỹboho heka aõma wiunawihikỹ‑di rawinymyhỹrenyre. Idi tahe teysatenyõhyymãhãtenyte. Tahe wiuna bederarysyna‑di heka rawiunymyhỹrenyre. Ta bedewoõhyymahãtenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Joaõ Sebedỹỹdu heka riroxiõre. Vĩĩmy riõõre. Inywesereny tai tarybetenyte: —Tii raitxỹtemy ihỹre. Tyytybybina‑di ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","—Jiarỹ Deuxu Riòre heka rehemynyre Hãbutyhyhykỹ wahe. Jiarỹ reroximyhỹre. Reõmyhỹre tahe kiaboho heka waluu aõkõ heka toite. Urile heka wamy tarybemyhỹtenyte wabyre nihikỹremy wabemomohõkỹremy. Aõma òrarudu kia liinatyhy heka jiarỹ rare. Aõ ikõkõlemy heka taraykynymyhỹtenyte ihãrele taheka òbitilemy ixi‑di tanohõtimyhỹtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesuisi heka sõwemy aõwiwihikỹmy riwinymy raremy. Ihãrele heka imahãdu rityhynyõhyymyhỹre heka. Kia Jesuisi heka rarybere kia hãwã mahãdumy. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","22","Orasi hãwã aõ heka adee binatyhymy kanakre amahãdu‑ò wahe. Besaida hãwã mahãdu, kaiboho aõna aõna wiwihikỹmy tabitenyte ahãwãreny‑ki. Tiu heka ixi‑txi õhõtireny reaõhykymyhỹre. Jiarỹ aõma Tiro hãwã‑ki Sidõ hãwã‑ki aõna aõna wiwihikỹ ariwinyre wana inihe heka ixi‑txi tõhõtireny reare iniheka saumy tyky rexityynyre tule brybysi ixityrereny heka rexihumy. Sidõ hãwã Tiro hãwã heka urihimyò adeereny isirakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","24","Kafanaõ hãwã mahãdu! Kaiboho heka tule ixitxireny õhõtireny reaõhykyre. Aõma kaiboho heka awireny ixidireny tahoõtinymahãtenyte, awityhyremy. Kaiboho heka òhòtenamy bekoabenykre bedebina heòtyhykỹ‑ò dori besebenykre. Sõwemy dori aõwiwihikỹmy kaiboho tabitenyte. Deysana wiwihikỹ‑di wahe. Tiu heka ixi‑txi õhõtireny reaõhykymy aòrarureny‑txi. Aõ wiwihikỹ Sodoma hãwã‑ki rewinyre wana wahe. Tiu heka rabinaõhyyre inihe heka wiji‑ò. Aõkõ botỹỹbenykre aõma Sodoma hãwã ratyre heka aõhõkỹmy botỹỹnybenykre, Deuxu ywisidỹỹnatxu. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tahe Jesuisi rexitòenyre Deuxu‑ò: —Waha, biu bede‑wana iwedu atximahãte. Kai uladu‑ò aõna aõna tetỹnynyte. Tewòmahãte heka kia ibedeeryhykỹ lau heka tewòmahãte. Kai ixi‑di bedeeryhykỹmy rõhõtinymyhỹre lau wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tii heka adeewinare. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ibutumy heka Waha wadee riwahinyre tii heka riwaeryre. Jiarỹ tule tii reeryre. Aõma ixidee wikeki inydee ariteòsinyke. Timybo Waha rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Elehydỹỹmy buruke aõbo? Manake wadee. Jiarỹ heka araelehynykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Walòtityreherina ixidee bitidibenyke. Tai tahe wawana maaõmysỹdỹỹbenyke. Arabederynykre heka ywina‑di. Aritidiõtyhy heka aõ utxiehekỹ atyrereny. Elehyna adeereny ariwahinykre awo araykyreny‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Aaõmysỹdỹỹna adeereny rewahinymyhỹre isiraõre heka. Iutxiemy aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabado txuu, judeu elehynatxu Jesuisi rariamy ròirenyre maixõmoni oworu‑ki. Tahe rekoarenyre aõma maixõmoni oworuro‑di heka irenyre. Kia heka tahe Jesuisi taerydỹỹna mahãdu heka riarimyhỹre aõma riyrenykremy rama rahuraki. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iu‑ki tahe fariseu mahãduõ retehemy ratximyhỹre. Tiiboho tahe rarybere kia Jesuisi‑ò rarybere: —Kia hewa brebuna rare aõma sabadotxu riwinymyhỹré: —Aõherekibo aerydỹỹna mahãdu iu riwinyrereri. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tahe Jesuisi tamy rỹỹraxire aõma ijyymy ikoreny relyyre iwese Davi riwinyre wesemy heka riwinyreri ramy rahureu. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davi riki heka ralòre Deuxu dohodỹỹna hetowo‑ò heka ralore. Tai tahe rirỹsỹmyhỹ kia aõma xiwena‑ki heka riymy. Kia orotxu heka aõma xiwena‑ò hidỹỹna mahãduòle rỹimy. Tahe ihãrele heka riyrenyre heka. Taijoi mahãdu‑ò riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kia wesemy aõma tariakõte bede ywina tyyriti‑ki wahe. Aõma xiwena wahidỹỹdu heka rityynyõhyymyhỹre. Aõma sabadotxu kia wahisidỹỹna. Xiwena bede ywina wahe. Iu dohodỹỹna hetowo‑ki ratximyhỹu. Tii heka sabadotxu bede ywina rityhynyõhyymyhỹre. Tahe heka aõbina bina riwinyrenyõhyymyhỹre. Kia tahe heka tule heka bede ywina tyyriti heka ritidỹỹna roire. Idi tariatenyõte. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Inatyhymy heka adee ararybekre. Inyõ kaki ratxikeki jiarỹ heka kaki heka inyõ ratximyhỹre aõma dohodỹỹnahakỹ heto‑ki wahe. Dohodỹỹdu mahãdu ratyre heka watximahãre jiarỹ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kiamy heka ritidỹỹna rỹimyhỹre. Jiarỹ heka xiwena luure ihãre tahe sõwemy heka iratyre ruxetòena luure. Jiarỹ aõma xiwena luure ihãre tahe iratyre heka aõma ruxetòena luure sỹ. Kaiboho terytenyte wana. Aõma heka ibinamy tarybehyynyhỹte inyõ teòsamy ratxikeò. Aõma aõ riwinyrenykõhyyre. Kiamy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Jiarỹ dori Deuxu Riòre Hãbu watximyhỹre. Jiarỹ tule aõma sabadotxu wedu wãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tai tahe Jesuisi nade heka ixyby aõma tohodỹỹnareny heto‑ò. Ralòre heka sabadotxu. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hãbuõ ratximyhỹre debò binare. Debò rayjayja ihỹmyhỹre. Tahe fariseu mahãdu heka Jesuisi‑di mynamy ratximyhỹre. Aõ rybebinamy rarybeke òraru‑ki rimykemy. Tai tahe rỹỹraxire Jesuisi‑ò: —Timyrebohe brebuna aõbo sabadotxu deytedỹỹ ada aõkõre aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tai ta Jesuisi rirariwònyre: —Kaweselemy rõkõhõtinyrenyke. Kai heka aõmy abudoeni sohojilere. Sabadotxu heka reseke hãlooro‑txi aribi. Timybo mohõtinyke aõma bitake hãlooro‑ribi. Inatyhyre aõbo. Sabadotxu hãrele bitake. Kohe, inatyhyra. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hãbu heka budoeni ratyre heka iòwy rare. Aõma sabadotxu aõwaxinyre heka reyteke. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tai hãbu‑ò rarybere Jesuisi: —Ebò biditytyke. Debò ritytyra ta wiwesele debò relere awimy. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseu mahãdu heka wii ributunyre, iribi ròhòrenyreu wahe. Widee raryberenyre: —Aõma timybo rikisỹnyrenykre rikimyrenykre rikirubunyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tahe Jesuisi rierymyhỹ kiamy rarybermyhỹreny heka roholamyhỹ. Tahe Jesuisi rierymy heka. Iribi irehemy ratximyhỹreny hãrele, rierymy heka. Iribi tahe rexitare heka hãwã‑ribi wahe. Idi heka ihemy heka rare riheludunyre. Sõwemy heka webinadu ihemy rare. Ibutumy riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Teyteydỹỹna mahãdu‑ò rarybere: —Uritere itỹnydỹỹõmykremy tuu ijyyõmykremy inyko‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ihexiu Isaia tyyriti‑ki heka kawesemy rỹimyhỹre. Tii heka Deuxu rybeduõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","—Kaheka Wadeòdu rare. Tuure heka jiarỹ, tii heka retare. Rehitxinyre. Tii heka deysana wadee riwahinymyhỹre Tatyytybytyhy tamy ariwahinykre. Ywisidỹỹna txuu heka ibutuko‑ò relyykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tii heka ryryõtyhy rebureõtyhy heka inyõ‑wana widee. Tiu heka inyõ roholaõtyhy irybe dee. Ryki heka inyõ irybe‑ò roholaõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aõma bòtòreõ irybòhòmy roikeki. Tii raòròõtyhyy. Txuheòtyjurà loosòna urihimyòkeki heka tiu ruriõtyhy eleti‑di. Tii ritakre iaõbinana, inatyhynaõ binana wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ibutumy heka iraròsòna iribi ritakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hãbu rybeõ ruetàõ heka iny didydenyde Jesuisi‑ò wahe ralòmyhỹreki wahe. Tii tyytybybina iwo‑ò ralòmyhỹreki wahe. Jesuisi tyytybybina riteònyre. Tai irue heka awimy relere rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ibutu iny sõwe heka heka ribedeòtiidỹỹnyre. Widee tahe raryberenyre: —Ka heka Davi riore riòre òsana rare, Deuxu deòdỹỹna wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tahe fariseu mahãdu‑ò roholare. Tahe rarybere Jesuisimy: —Tii inatyhymy tyytybybina riteònymyhỹre inywo‑ribi. Aõma tyytybybina wedu ruru‑di heka riteònymyhỹre. Belisibu ruru‑di wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesuisi heka rieryre iraykyreny. Tai tahe tamy rarybere: —Ijyymy heka tamy rarybere. Iòlòna mahãdu wiribi ibutumy rexihitxinykeki tahe rexihukre ibutumy wiribireny. Tahe hãwã mahãdu taijoiy‑ribi rexihitxinykeki, awi aõkõ rare tai wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wiribi rexihitxinyke wana. Tule awi aõkõ rare tai wahe. Aõma Satanasi rexideònykeki tahe tayreny‑ribi rexitake. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Belisibu ruru‑di tyytybybina ariteònyke wana aõdibohe aheludu mahãdu riteònykemy ratximyhỹre. Tiiboho heka aywisidỹỹdurenymy ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Jiarỹ Tyytybytyhy ruru‑di ariteònykeki heka kaiboho arurunareny Deuxu‑ribi nade. Iòlòna adeereny rehemynyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Inyõ heka hãbu rurutere hetowo‑txi ralòõtyhy wasimy wahe. Tai rawasinymy ratximyhỹkeki tahe urile juhuu hãbu ritaataake. Idi tahe iheto‑ribi aõdibo rawasinyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Inyõ wabiòwamy aõkõ ihỹre wana heka, waòludu rare. Inyõ wawana ibutumy ratxiõmyhỹre wana tahe raybàtàmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Inatyhymy jiarỹ adee anarybekre. Ibutu òraruna kanaixãwididỹỹke. Hãbu aõtxile aõbina bina rarybemyhỹre. Sohojile taruxãwidỹỹõtyhy. Aõtxile inyõ aõbina binamy Deuxu Tyytybytyhy rarybekeki. Tii aòraru rataõtyhy. Kia heka òraruna tiiehyymy rarekemy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hãbutyhyhykỹ heka Deuxu riòremy aõbina binamy iny rarybekeki, wamy wahe, tii tahe ixãwidina dire. Deuxu Tyytybytyhyhymy rarybekeki, tii tahe iixãwidinyõhyyre. Tiehyy kia òraruna‑di rareke. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesuisi rawesenanyre iny òwòru wese rare. Òwòru awimy rỹike wana, tai heka iratywihikỹõ‑ki iny rahake. Ruru rasunymyhỹre raruburerimy ihỹre. Kia tasỹ iratywimy aõkõ rỹike ibinamy. Aõma òwòru iny rierymyhỹre aõbo iribi iraty dejuxunymyhỹde òraru‑ki iny rierymyhỹre, awire. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","Kaiboho heka hemylala mahãdu wesemy atximyhỹtenyte. Kaiboho heka abinatyhymy ahãtenyte. Timybo heka kaiboho aõwiwihikỹmy marybebenyke. Arayky aõbina bina hakỹlemy tõhõtinyteri wana. Tai taheka ary tuu ròhònyke ary tuu rarybeke. Aõma hãbu wihikỹõ ratxiremyhỹre wana aõnana wiwihikỹle tarayky‑ki riyrubunymyhỹre. Tii heka rarybemyhỹre. Hãbu bina tahe tarayky‑ribi ibinalemy rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ibutumy aõmybo iny rarybemyhỹre heka ywisidỹỹna txu tuu rarybemyhỹre rierymy timykibo tuu rarybere wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Òrarukibo rarybere: —Arybe òraru‑ki heka ywisidỹỹna‑ki atxiteri. Bitakemy aõbo ada aõkõre aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Bedeerydỹỹdu mahãdumy heka fariseu mahãduõ tamy rarybereri: —Erydỹỹdu, wadeereny biteòsinyke awiwihikỹõ. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesuisi dirawyònyde: —Iny kamahãdu heka ibinatyhy rare aõ awiwihikỹ rexitòenymyhỹre. Abina binale wahe. Aõ wihikỹle bobiõtyhy. Tahe sohoji aõwiwihikỹõmy heka mohõtinyke. Jonasi widỹỹna wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonasi Deuxu rybeduõ widỹỹna wahe. Tii inataõ txu inataõ rumy uturahakỹ wona‑ki ihỹmyhỹwesemy. Iwese Deuxu Riòre Hãbutyhyhykỹ bede‑ki rarekremyhỹ wesemy inataõ txumy inataõ rumy. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninive hãwã mahãdu heka roholarenytxi tõhõtireny reare. Iu Jonasi rybe ritỹnydỹỹreu wahe. Tahe inyõ kaiboho tamy taholatenyte. Sõwemy heka iny Jonasi ratyremy ihỹre. Ihỹrele kaiboho ixitxireny õhõtireny reaõre. Ninive tamahãdu tahe ibinany adeereny rarybekre. Ywisidỹỹnatxu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Iòlò Hãwyyõ heka ibòò irehe‑ribi nade. Aõma Salomaõ bede erydỹỹna‑ò roholakemy. Kaiboho heka inyõ‑ò taholatenyte. Salomaõ ratyre heka sõwe inihikỹ ihỹre. Ihãrele ta ixitxi nohõtireny reaõre. Ywisidỹỹnatxu heka Iòlò hãwyy ibinanamy kỹnarybekre umyreny wahe. Ywisidỹỹnatxu. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Aõma tyytybybina hãbu‑ribi ròhònykreu tahe elehyydỹỹna riijekre. Aõma bedebinana tòteehekỹ tahe tuu reakre. Ihỹre tahe tai rahaõhyykre elehyna‑ki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tai tahe ixidee rybekre: —Aròòsekre kỹhe. Iribi ranywỹhỹreò anakre. Tai tahe kia hãbu‑ki rahara. Tyyrahakỹmy iwo‑ki iruxeramy. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tai tahe ijõ‑txi reare. Debò inatxi reurò tyytybybina‑txi iratyre tyhy wahe ibinare. Tai tahe ridyke tahãbu‑ki rasỹnyrenykemy. Kia hãbu heka iwese juhu raremyhỹre ratyre ibinamy ratximyhỹre. Kaiboho heka kia tyytybybina wese atximyhỹtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesuisi tahe ijõ‑ò rarybere ijõ ijoi‑ò, tai tahe ise rehemynyre, iseriòreboho‑wana. Sõwemy iny mahãdu‑ò heka rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Inyõ tamy rarybere: —Inyõ heka arãijereri adi ahelỹỹna. Kie heka rehemynyreri adee rarybekemy adi ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesuisi dirawyònyde: —Mota heka nadireri, mota heka waseriòrereri? ");
INSERT INTO kpjNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tai tahe tebòhe riteòsiriteòsinyre taerydỹỹna mahãduõ‑ò. Ka heka nadi rare. Ka heka waseriòrere. Ka ijõ heka waseriòre. ");
INSERT INTO kpjNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Wahadeewi riwinymyhỹreki tahe, tii heka nadi rare. Waseriòre rare. Waha dori biu‑ki ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Itxu taheka Jesuisi rare heto‑ribi Kalileia aho ijà‑ò. Tahe tai ronyre. Tahe rexiterenyre Jesuisi iny ribedeerynymy. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tai ibututyhymy heka iny wirotyre. Tai tahe Jesuisi rexitareny urihimyò hãworo‑ò ronymy rexitaranyre. Iny sõwehekỹ mahãdu tahe aho ijàkile heka roholamy rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tii heka relyymyhỹre aõma ijyyõ relyyre: —Aõna aõna wese ijyy rawesenanyre. Hãbu alòbòròmy rara. Tii heka alòbòròna dehudu rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ijõ heka idi rehumyhỹu heka ijõ ryro‑txi resere. Nawii heka riròmyhỹre riore heka. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Ijõ tahe rejuxunyre aõma manarutysu‑txi. Tii tahe raumynyre aõwesele. Iraruxiõlemy heka rỹimyhỹ suu ibutureki. Idi bedetòtee rimoedỹỹnyre. Idi tahe rurure. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Òwòrudỹỹ resere edey‑txi. Idi ta ruhunyre edewanale. Idi tahe ede riòdesedỹỹnymyhỹre. Tai heka raratynyõlemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ijõ tahe resere suwitxirawihikỹ‑txi. Tai tahe sõwemy raratynyre. Sohoji òwòruty‑ribi tahe 30my raratynyre iraty wahe. Ijõ 60my raratynyre iribi. Ijõ ta 100my raratynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tahe Jesuisi heka rarybere: —Kia boholatyhymy bonyke. Õhõtirenydikeki boholabenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tai tahe ierydỹỹna mahãdu Jesuisi ritỹỹraxinyre: —Aõherekibo kai ijyy‑di bierynanykemy atxiteri, rawesenanyreri wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tai tahe dirawyònyde: —Kaiboho aõmybo Deuxu reerynanyre kaiboho bierybenyke. Ijõ mahãdu tiu ijyy rieryõtyhy. Kaiboho dori Deuxu Òlòna teerytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Hãbuõ iaõdikeki ijõ heka iratyre tamy ariwahinyke. Tai tahe sõwemy tamy rauhenyke. Tahe hãbu ihoõkeki ibutelemy ijõdikeki heka kiale iribi ibutumy aritakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Retehemy ihãre tahe robiõhyymyhỹrenyre tahe ririõhyymyhỹre. Tai heka ijyy‑di reerynanymy watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Iwese Isaia tyyriti‑ki roire wese heka tiiboho ihỹrenyre: —Roholamyhỹre, roholamyhỹre ihãre tahe rieryõhyymyhỹre. Retehemy ihãre tahe tiu robiõhykymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","—Irayky tererenyreki wahe rieryõre heka. Õhõtireny heka ritòbònymyhỹre ta ijohonana‑ribi. Tarue ribrenymyhỹre robike lau. Tahe wadee ròòseõtyhy. Aõkõre heka ariteytenykemy idi watximyhỹre. Tibo heka terareny aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jesuisi ijõ relyymyhỹre tamyreny: —Kaiboho heka eysamy atxitenyteri. Kaiboho heka bobibenyke tahe bierybenyke. Aõmybo kaiboho tabitenyteri heka, taholatenyteri wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ihetxiu mahãdu, hỹỹna mahãdu wahe, tuu lobiximy riwisỹnymyhỹre. Aõma aõwobo kaiboho taholamyhỹtenyteò heka roholakemy riwisỹnymyhỹre tahe roholaõhyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Tahe boholake heka adee aritỹnynyke aõbo ijyy rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Òwòruty ryro‑txi resemyhỹre heka iny ijoireny wesemy ihỹre. Ijohona tuuwesemy wahe. Tibo roholamyreny ihỹre tahe rieryõhyymyrenyre. Aõma Satanasi heka nade tai tahe warybe heka iribireny ritamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ijõ manarutysu‑txi resemyhỹ mahãdu tahe ijõ ijohonadu wesemy heka roire. Tiiboho heka deysana‑di roholamyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","22","Tai tahe urihimyòle rityhynymyhỹrenyre aõhõkỹmy dỹỹnana kanakeu tahe aõwesele riatyke ririmy reake. Kia edey‑txi resera tasỹ aõma ijõ ijohonadu mahãdu wesemy heka rare. Tiiboho heka aõma 1000 nierule aõnityhymy idi rõhõtinymyhỹrenyre nierudile. Tai tahe rexibedewonymyhỹrenyre. Tiu heka Deuxu aõmydỹỹna riwinyõhyymyhỹre, Deuxu Rybe riwiòhenanyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kia suwitxira wihikỹ‑txi resera wana tahe iwitxira ijohonadu mahãdu wesemy heka rare. Tiiboho heka roholamyhỹrenyre rityhynymyhỹre sõwemy Deuxu dee roholamyhỹreny heka. Ijõ 100my wesemy raratynyre. Ijõ 60my raratynyre ijõ 30my raratynyre. Iny sohoji sohojiõ heka Deuxu‑ò aõ riwinyrerimy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Idi tahe iwitxira ijyymy relyyre Jesuisi tamyreny: —Deuxu Iòlòna heka kia wesemy ihỹre. Oworudu heka aõma alòbòròna wihikỹõ ritòbrònymyhỹre taoworuro‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","28","Tahe iòluduõ rumy heka tamy nade. Tahe iu ibutumy iny rõrõmyhỹreu, asibinaty‑di tamy rehure. Tai tahe alòbòròna asibina‑wana ruhunyre kia aõma ede wana wimy urilemy. Taiki tahe kia aõma oworudu kia aõmysỹdỹỹdu mahãdu. Tuu heka ijyy‑di nade tuu ijyymy. Idinodu rarybere: —Aõma waòludu heka kia riwinyre wadee. Idi oworudu narybede: —Aõhebohe arotỹỹnyrenykre? Ta idile aõbohe arisiherenykre araxirenyre. Tai tahe rirawyònyre: ");
INSERT INTO kpjNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","—Aõkõre wahe, kia ibutumy alòbòròna rirarutxinykre. Ixinamy heka ratybienykre tii‑wana wiurilemy kia maixõmo arixina bededỹỹnamy bede relerekeu tahe iribi raarike. Ararybekre heka tamy kia aõma oworu‑di raaõmysỹdỹỹkreò. Juhu delemy asi arisykre. Tahe ritoonykre. Idi tahe maixõmo heka riarikre kia maixõmo hetowo‑ò riyrubunykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tahe Jesuisi ijõ ijyy witxiramy relyymyhỹre: —Aõma Deuxu Iòlòna heka aõma alòbòròna sõmo sõmo wesemy ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Aõma raumynyreri heka aõma òwòru iyjatyhymy ibutumy òwòruty‑ribi rariewesele relemyhỹre. Taiki tahe kia nawiile tuu rỹtỹnymyhỹre kia òwòru‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Uri paõ uri ixiòlòdỹỹna heka Deuxu Iòlòna wesemy heka kia ihỹre. Hãwyy heka paõ riwinymyhỹreu, riurinymyhỹreu tahe ibutumy raubỹtỹmyhỹre kia ibemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tai tahe rexiòlònymyhỹre Jesuisi heka sõwemy tuu relyymy raremyhỹ. Iu iny ribedeerynymy raremyhỹu. Tiiemy heka Jesuisi relyyhyy raremyhỹ iu ròbedeerydỹỹmy raremyhỹu. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Deuxu rybedu dori ihetxiu rarybere: —Jiarỹ ijyy‑di rebedeerynymyhỹre. Aõma tuu relyymyhỹre heka ierykõna rare. Tiuhe rieryõhyymyhỹre. Iu bede rexideelenyrauhyyle. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Idi tahe Jesuisi rexitare iny sõwey‑ribi rexitare. Hetoõ‑ò heka ralore. Tai tahe aõmybohe wakoreny inihe bedelyyke. Aòludu inybo arasỹnyremy. Kia ijyy heka aõma hãbu ede‑di rehure ioworu‑ò, taòludu oworu‑ò. Kia inihe wadee bitỹnynyke aõbo rare wahe. Kia ijyy telyyté. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tai tahe Jesuisi tii dirawyònyde: —Kia hãbu alòbòròna wihikỹ ribòrònyre heka Deuxu Riòre Hãbutyhyhykỹ, rare wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","Ioworu heka ibutu bede heka roimyhỹ wesemy roimyhỹre. Aõma alòbòròna wihikỹre heka ityhydỹỹdu iwese rỹirawesemy rỹira. Asi tahe kia ityhydỹỹdukõdu mahãdu wesemy heka ihỹre. Aõma kia iòludumy rarybereri tahe kia Satanasile heka ihỹre. Kia iyresynamy rarybereri aõbo bedekonana heka tuu rininimy heka tuu rarybereri. Kia ỹju heka iyresydumyhỹ tuu rarybereri. Kia rimykre ede riorokremy rarybereri heka aõma ityhydỹỹdukõdu mahãdu heka tuu rininimy rarybereri. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ritakre heka rihitxinykre. Heòty bedehekỹ heka idi rehukre risõkre iu wahe. Iwesele taheka bedekonana heka rarakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Deuxu Riòre, Hãbutyhyhykỹ heka aõma ỹju riteònykre ibutu iny ributunykremy. Ityhydỹỹdukõdu mahãdu ijõ iny òraruna‑txi rityhedỹỹdu mahãdu heka ibutumy ributunykre widee. Ibutumy aõbina bina widỹỹdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Idi tii rihukre. Tai tahe ryrykre aõkỹmy rotỹỹnykre tai. Robumyhỹre taju. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kiau aõma Deuxu hõrõ mahãdu tahe Waha Iòlòmy ronymyhỹre kie ronykre. Tiiboho loosòny wesemy heka ritoosònanykre txuu loosòna wesemy. Õhõtirenydikeki ibutumy heka boholabenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Deuxu Iòlòna tahe nieru wesemy ratximyhỹre. Aõma nieru heka hynaõ‑ki rahara nieru‑di tỹximy aõma surawo‑ki idi hãbu ixyby riwore. Tai tahe tii reysatyhymy ròòsere. Kia ibutumy taaõmydỹỹna‑di heka rohonyre. Kia bedero riwykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Ijõ tahe tule Deuxu Iòlòna wesemy ka ratximyhỹre. Iwese ixiura wydydu ihỹre wesemy heka Deuxu Iòlòna ihỹre. Iwydydu heka iijese iijesemy riwymyhỹre. Aõwi riererimy riererimy heka tai rahamyhỹre iruxera‑ki tii tahe riwymyhỹre. Kiau tahe tai rahare aõ òwyhykỹõ‑ki heka rahare. Tii idi tahe rohonyre ibutumy taaõmydỹỹna‑di idi tahe kia iwydymy idi ratxireriò riwyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Riàõ wese heka tule Deuxu òlòna ihỹre. Aõma rià‑di iny rehumyhỹre wana heka ibutumy utura rimymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kia aõma idi tahe idi raixỹnymyhỹre riarimyhỹre iky‑ribi. Aõma awi‑di awihe riarirerimy iky‑ribi. Ibinare rihitxinymy iribi. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kia bedekonanau tahe iweselemy heka rarekre. Kia aõma ỹju heka riarikre awi heka ibinau‑ribi riarikre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Rehukre heòty bedebinakỹ‑ò wahe. Tai ki tahe rirajuamyhỹkre ta aõhõkỹmy rotỹỹnymyhỹkre. Txuu rikyinymyhỹkre ");
INSERT INTO kpjNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tahe Jesuisi tamy rỹỹraxire: —Kiamy ibutumy teerymyhỹtenyte? Tiiboho riraòwònyrenyre: —Kohe, reerymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Idi Jesuisi rarybere: —Inyõ bede ywina bedeerydỹỹna heka rityhynyreu, waheludu rarekreu wahe. Tii tahe iwese hãbu butudỹỹdumy ratximyhỹre wese heka ronymyhỹre. Tii heka ibutudỹỹna heto‑ribi ritamyhỹre, tasỹ mahãdu‑ò riwahinykemy. Aõ tyby aõ tỹmyra. Ibutumy heka ritamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tahe iribi Jesuisi rexitareu, ");
INSERT INTO kpjNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","tahe tahãwã‑ò ròòsere. Judeu dohodỹỹna heto‑ki ribedeerynyre. Tahe ibutumy ribedeòtiidỹỹnyre. Tiribibo heka tii bedeeryna rierymyhỹre: —Timyrekibohe aõwiwihikỹ rierymyhỹre. Tii kỹny heka aõma òwòru besedỹỹwidỹỹdu riòre heka rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Jyje riòre wahe. Marie heka tule rare ise wahe. Txiau, Simaõ, Jyje, Judasi‑wana iseriòre ihỹre tule wahe inatyhy? ");
INSERT INTO kpjNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","—Iseriòre hãwyy heka tule kaki rasỹnymyhỹre inatyhy. Timyrakibohe aõna aõna ikõkõ rierymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tahe rityhynyõhyymyhỹre heka tai wahe. Jesuisi tamyreny rarybere: —Deuxu Riòre Hãbutyhyhykỹ heka tiu tauludu wijirana hãwã‑ki inyõ rityhynyõtyhy rybeduõ ihetomy ijirana‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tai tahe aõna aõna wiwihikỹ heka tai riwinyõhyyre, rityhynyõmyhỹreki. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kia bedeu tahe Herodi, Kalileia iòlò, Jesuisini‑ò roholare. Aõikõkõ heka riwinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","My heka rarybere teòdu mahãdu‑ò: —Kia Joaõ Sebedỹỹdule aõbohe rubu‑ribi riixixadỹỹnyre. Tai tahe tii aõikõkõ riwinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodi tahe juhuu Joaõ ròtenawo‑ki riteònyre. Tii taseriòre hãwyy òraru‑ki kia wesemy riwinyre, Herodia òraru‑ki wahe. Herodia heka Filipi hãwyy rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juhuu Joaõ Herodi‑ò rarybere: —Awi aõkõ rare. Kai dori aseriòre hãwyy‑wana atxiteri. Uritere heriõmyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tai tahe Herodi heka Joaõ rubudỹỹmy riwisỹnyre. Urile ruberumy judeu mahãdu lau. Tamyreny Deuxu rybeduõmy rỹiramy Joaõ Sebedỹỹdu rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodi kai beòramy bede reareu tahe worana bedehesi ritxienyrenyre. Herodia riòre ijadòma heka iko‑ò resemyhỹre. Iixe‑ki tahe awimy Herodi rahare, Ijadòma luure wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tii tahe tamy rarybere kanakemy. Aõmybo wadee bexitòenykre. Inatyhymy adee ibutumy ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tai ise ijadòma‑ò rarybere: —Aõma bexitòenykre: Sebedỹkỹdu ratilemy tamy bexitòenykre. Tai tahe ijadòma tamy rexitòenyre: —Wadeke bidiwyke Joaõ Sebedỹkỹdu rati, pratoro‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tai tahe iòlòhe rabedewore. Ibutu ijohonaru‑ò dori tuu rarybere ijadòma‑ò. Tahe ibutumy riwinyke rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tahe ihãrele iòlò heka soldadoõ riteònyre ròtenawo‑ò kia Joaõ rati resymy. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Inyõ diwyde pratoro‑ki. Ijadòma‑ò heka riwahinyre. Tahe tii tadi‑ò idi rare. Riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Idi tahe Joaõ erydỹỹna mahãdu dioryde iumy, riwykremy, rituunykremy. Iribi tahe roirenyre Jesuisiko relyyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kia roholareu tahe Jesuisi ròhònyre ixisohojilemy bederahu‑txi. Hãwò‑di rexitaranyre rare. Iny sõwemy bede‑di ròirenyre ihemy titxibo iru‑ki rakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Rehemynyreu tahe iny sõwehekỹmy Jesuisi robire. Tai tahe Jesuisi riwotòenyre. Ibutumy riteytenyre webinadu mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tahe ratxioronyre. Tahe ierydỹỹna mahãdu tamy nade. Tamy rarybere: —Txuu ratxioronyra. Bederahy‑ki dori atxiteri. Iny tahe biteònykre hãwãõ‑ò tai rỹsỹna ixidee riwykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tahe Jesuisi rirawyònyre: —Aõkõre, ariteònyõtyhy jiarỹ. Kaibohole tahe aõ tamy bidiwahinybedenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jiarỹboho kỹny diwatxiõnyreri iruyre orotxu‑di, utura inatxire. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tai tahe Jesuisi narybede: —Bidiwahiny wadee. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesuisi tahe ibutumy iny asityre‑ki ronykemy risỹnyre. Orotxu inaubiòwa, utura inatxi rỹire, utura‑wana rimyre tahe ritehere biu‑txi àlàna Deuxu‑ò riwahinyre. Idi tahe paõ riyreyrenymyhỹre teòdu mahãdu‑ò riwahinyre. Idi rare iny sõwehekỹ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ibutumy iny riroxirenyre ihãre rihydyre. Kia iuhe‑di ierydỹỹna mahãdu 12 weriri ritỹxinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hãbumy 5000 òsana rỹimyhỹre. Ihãre tahe uladu‑di rariaõhyyre hãwyyboho‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tahe Jesuisi taerydỹỹna mahãdu riteònyre aho kanawe‑ribi ijà‑ò reuròrenykemy hãwò‑di. Jesuisi tahe rarire iny sõwehekỹ mahãdu rirybedỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jesuisi heka iny tahetoreny‑ò riteònyremy rahudi tahe tii raòwònyre hãwãlò ratyy‑ò ixitòedỹỹmy. Taihyyle idi bede roronyre ixi sohojihyyle. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kiaule hãwò ahotya‑ki rare. Òbò nihikỹy‑txi ixinalemy ratximyhỹre. Tiò tiò òbò riwelòrò riwelòròmy idi rehumyhỹ. Yhy deade txura‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Rudile tahe Jesuisi biura‑di heka rare taerydỹỹna mahãdu‑ò, beratyredile heka rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iu Jesuisile betyredile tamy rarau tahe, tiiboho heka ruberurenyre. Rirajuarenyre: —Worỹsỹ òsana inydee rareri. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tai tahe Jesuisi rarybere: —Aworeny bitamadỹỹnybenyke. Jiarỹle watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tahe Pedro rarybere: —Wanyrỹ, inatyhymy kai atxiteriwana heka wadee manyarybeke betyre‑ki arariakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tahe Jesuisi tamy rarybere: —Manake wahe. Aõwesele tahe Pedro hãwò‑ribi ròhònymy reare, Jesuisi‑ò rakemy. Betyre‑ki rariare. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yhylemy tahe robure. Tii urile ruberure. Tai ijirahakỹlemy riwisỹnyra berahatxi‑ò. Tai tahe Pedro rarybere: —Biwatakewa Wanyrỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tahe Jesuisi rimyre: —Ainatyhynakỹny ibutelemy atxiteri. Aõherekibo heka tiwatyhynyõteri. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Idi hãworo‑ò wiwana rorukurenyre. Yhy ruhure. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ierydỹỹna mahãdu Jesuisimy reàlàre. Inatyhymy heka kai Deuxu Riòretyhy tate. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tai tahe reuròrenyre Kenesare bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ibutumy iny kowa Jesuisi rieryrenyre. Ti ibutumy webinadu mahãdu‑ò relyyrenyre Jesuisimy. Tahe hãwã ikõkõ‑ribi ritelenymy didydenyde. ");
INSERT INTO kpjNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tahe Jesuisi‑ò rarybere. Ixinamy watyky‑ò rerike, awimy relerenykemy. Ibutumy tamy rerire heka reytere. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jerusalẽ hãwã‑ribi bede ywina bede erydỹỹna mahãduõ dehemynyde Jesuisi‑wana rarybekemy. Tiiboho‑wana tule fariseu mahãduõ dehemynyde. Tiiboho heka Jesuisi‑ò rỹỹraxirenyre: ");
INSERT INTO kpjNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Aõherekibo aerydỹỹna mahãdu tebòreny risuhòkõreri roxiko‑ki. Inydeereny kia bede ywina rare. Aõherekibo rityhynyõreri ihetxiu lahi rybe. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesuisi rirawyònyre ỹỹraxina‑di: —Aõherekibo kaiboho Deuxu rybe tetyhynyõteri kaiboho lahirybele tetyhynytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Deuxu bede ywina kawesemy rarybere: —Boo adi‑wana ibutumy heka bityhynybenyke. Inyõ rybebina tadi‑ò tyby‑ò rarybekeki. Tii tahe ruruke, tuu bede ywina rybe wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kaiboho tahe kawesemy tebedeerynytemy tewitxiranyte: Inyõ tadimy tybymy rarybekeki Wanieru Deuxu‑ò wahisidỹỹnamy. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tai tahe inieru‑ei tyby tadi‑wana riwiòhenanyõre kia bede ywina witxira tewinymahãte. Deuxu bede ywina rityhynyõreki. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kaiboho itxerenadu mahãdu atxitenyteri. Isaia inatyhymy umy rarybereu: ");
INSERT INTO kpjNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","—Kia mahãdu wadee rybe‑di riwadeàlànanyrenyre. Wowydyna wadee riwahinymyhỹrenyre. Inatyhymy aõkõ heka kai tarybemahãte. Arayky dori Deuxu‑ribi irehemy ratximyhỹre. Teerytyhyõlemy heka atximahãte. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iwowydyna heka wadee aõ aõkõ rare. Wabede ywina ribedeerynyõtyhy. Texibedeerynymahãtenyte abede ywinarenydile. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesuísí rexidelenymy ribedeerynyre: —Boholabeny warybe‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Brebuna roxina‑di biroxibenykeki, aõ adeereny ibinaõtyhy aõ aryrenymy ralòmyhỹre aõkõ heka ibinare. Ryribi ròhòmyhỹre heka ibinare, arybe wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tai tahe Jesuisi erydỹỹna mahãdu Jesuisiko rarybere: —Fariseu mahãdu kỹny tamy awiõre kia wiji tuu tarybeta wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tahe Jesuisi rarybere: —Aõhere aõkõ rare. Timyre aõkõ rare. Ixinamy tuu raryberenyre. Iorutere‑di nohõtirenyõmy. Kia fariseu bedeeryna lòbòròna wese rare. Waha ribòrònyõre. Ibutumy waha ribòrònyõre suribi mahãdu ritakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Inatxi hãbu ruetà widee ryò ritỹnynymyhỹre wese. Hãwãry‑ribi wiwanale hãloo‑txi resekre. Tiiboho ixinamy biribenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tahe Pedro Jesuisi‑ò rỹỹraxire: —Wakoreny inihe biditynynyke, roxina brebuna ijyy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kaiboho ibutu wese atxitenyteri. Teeryõtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ibutumy iny aõ rirỹsỹmyhỹre weryri‑di ramyhỹre tahe ròhònymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tahe inyõ rybebinamy rarybemyhỹre. Tii iwo ibinare, irayky ibutumy ibinare tai wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Raykywydyna binahakỹ‑ribi heka òtaòtana, rubuna, wasina, ruina ujõmo inyry‑ribi ròhònymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kia aõmydỹỹnana iny risurisumyhỹre, inydee ibinare. Tahe roxinako‑ki iny tebò risuhòmyhỹré, kia tahe aõ aõkõ rare, ibina aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iribi tahe kia‑ribi ròhònyreu tahe Jesuisi rare irehetytymy Tiro hãwã‑ò Sidõ hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kana bede hãwyyõ tamy nade. Tahe tamy rexitòenyre: —Wahĩ, Davi riòkòre, biwaruxetoènyke hewa. Waritxòre heka tykytyby bina‑di iwoku‑ki ratximyhỹre. Anohõkỹmy heka idi rotỹkỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tahe Jesuisi aõmy rarybeõhyyre tamy. Taerydỹỹna mahãdu tahe rarybere: —Biteònyke hewa. Inyboho dori riixiranyrenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesuisi tahe rarybere: —Jiarỹ Deuxu riwateònyre judeu mahãduòle, tabudoeni mahãdu iõre mahãdu wese wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hãwyy ixityre nade. Tatiowotimy resere. TAhe ixityre tamy rarybere: —Biwawikòhenanyke hewa, Wahĩ. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesuisi rirawyònyre: —Awiòhedỹỹna kia wese rare aõma hãbuõ tariòre‑ribi rỹsỹna riwyra tahe idi rehura ijòròsaòle. Kiawese rarekre, jiarỹ arawiòhenanykeki. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hãwyy rarybere: —Inatyhy rare. Kuladu‑ribi ano rỹsỹna resemyhỹre bede‑txi, tiki tahe itxòròsa ritxòre idi riwymy reakamy riròmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Inatyhymy Jesuisi rirawyònyre: —Kai ainatyhyna sõwere. Adee ariwinykre aõmybo textitòenyteri. Iule iriòre reytemy rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tahe Jesuisi ròòsere ixityre Kalileia ahohokỹ‑ò. Raòwònymy rare hãwãlò‑ò. Iratytyre ronyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sõwemy heka iny webinadu didyde: itiere mahãdu, iruetà mahãdu, irybeõ mahãdu, aõ ikõkõ heka bina bina witxira witxira idi rare. Jesuisiko‑ò heka ritidirenyreki ibutumy riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iny ruetà rỹira mahãdu itxeretyhymy riwinyre. Rarybekõmy rỹira mahãdu, rarybemy rỹimyhỹ teysamy. Itiere rỹira mahãdu, rariamy rỹimyhỹ. Tai ibutumy iny ribedeòtiidỹỹnyre heka tahe judeu mahãdu Deuxu‑ò wowydyna riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesuisi rarybere taerydỹỹna mahãdu‑ò kanakemy. Tahe tamyreny rarybere: —Jiarỹ kỹny rewotòenyreri kainy mahãdu rỹireridi. Inataõ txumy bede riera waki. Aõ heka ihokõre rirỹsỹrenykemy. Iòwedỹỹkõlemy ariteònykeki heka ijõ reseke ryrowetyakile. Rama riatyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tai tahe ierydỹỹna mahãdu rarybere: —Inyboho bederahy‑ki, titxibo heka rỹsỹna arimykre iny sõwehekỹ‑ò ariwahinyrenykremy? ");
INSERT INTO kpjNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tahe Jesuisi tamyreny ritỹỹraxinyre: —Tiwesebo roxina‑di atxitenyteri. Tahe rirawyònyre: —Debò inatxi reurò orotxu sõmo sõmomy idi watxireri utura deyre ijõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesuisi rarybere ibutumy iny ronykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tahe tíí rexitòenyre Deuxumy reàlàre. Orotxu, utura‑wana riereerenyre tahe taerydỹỹna mahãdu‑ò riwahinyre idi rakremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ibutumy riroxire heka kia iny sõwehekỹ ta rihydyre. Tabyre rahudi tahe riarire ierydỹỹna mahãdu. Tai tahe rahure tỹxihikỹlemy. Debò inatxi reurò weririmy heka ritỹxinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tahe 4000 hãbumy riòwenyre, kia txuu wahe. Uladu, hãwyy‑di rariaõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","TAhe Jesuisi iny‑ò rarybere tasỹ‑ò ròòsekemy ixyby. Iribi tahe Jesuisi hãwò‑di reuròmy rare Magadã hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseu mahãdu saduseu mahãdu nade Jesuisi‑ò iurihixidỹỹmy riitxenanyrenykemy: —Aõbedeerydỹỹnabo heka biu‑ki iribi rexitòenyre. Biwateòsinyke heka aõwiwihikỹ‑di biu‑ò jiarỹboho arieyrenykre, kai inatyhy tate wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Idi tahe Jesuisi rarybere: —Kaiboho heka awirenyre biuwetyky erysy‑ki. Jesuisi rarybere: —Kia rybe tarybemahãte. Txiorotxumy heka biuwetyy isòhòkỹra‑ki, biurasòmy tahe awimy txu kedeakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Biurasou ibede lyby lybymy txu‑di kedeakeki tahe biu ròahyyhyy bede txu rariakre. Myhe tarybemahãte. Kaiboho heka iwitxira aõhebo rotỹỹnykre heka teerytenykõlemahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Iny kamahãdu heka ibutumy ibina binare. Tiu heka rityhynyõhyymyhỹrenyre. Rexitòenymyhỹrenyre heka biu‑ò rityhynykemy. Tahe riwahinyõtyhy heka aõma bedeerynaõ. Kia Jonasi‑ò bedeeryna rareõle tahe tamy rakre heka. Tahe Jesuisi rexitamy rare iribireny. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Idi tahe aho weribiijà‑ò reuròrenyreu tahe, tõhõtireny rosare tarỹsỹnareny‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesuisi tamy rarybere: —Fariseu mahãdu, saduseu mahãdu iurina‑ò bexiebenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ierydỹỹna mahãdu tahe widee rarybere: —Tii kia rarybere iny orotxu diwyõdeki. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesuisi roholare aõmybo raryberenyre tahe tamyreny rarybere: —Aityhynareny urihimyòre. Aõherekibo orotxumy jiarỹ rarybererimy tahõtinytenyte? ");
INSERT INTO kpjNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tiu kaiboho bierybenyõtyhy. Iruyre orotxumy remyre. Idi 5000 hãbumy reòwenyre. Ihãre tahe weriri txỹxi tỹxihikỹlemy rỹimyhỹre rauhenyre. Itxi aõbo õhõtireny reakõmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ixityreu tasỹ 4000my reòwenyre, debò inatxi reurò orotxu‑di. Ixiyrubule rauhenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Jiarỹ orotxumy rarybeõre. Fariseu mahãdu, saduseu mahãdu urina‑ribi bexiebenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tai ierydỹỹna mahãdu rieryrenyre aõmybo rarybemyhỹmy Jesuisi heka fariseu saduseu bedeerydỹỹnamy rarybereri. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Idi tahe Sesaria Filipi hãwã iòhòmy rehemynyre. Jesuisi rỹỹraxire taerydỹỹna mahãdu‑ò: —Iny wamy rarybereri. Mobo heka jiarỹ raremy heka wadi rỹireri. Jiarỹ Hãbutyhyhykỹ rare, Deuxu Riòre wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ijõ kỹny rarybemy rỹireri: —Kai riki heka Joaõ Sebedỹỹdu atxiteri. Ijõ riki Elia atxiterimy adi rỹireri. Ijõ tahe Jeremiamy adi rỹireri. Ijõ heka Deuxu rybeduõ riki heka atxiterimy adi rỹireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tai tahe Jesuisi rỹỹraxire taerydỹỹna mahãdu‑ò: —Mowexe watxirerimy wexe wadi tahõtinytenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simaõ Pedro heka rarybere: —Kai Kristu atxiteri Deuxu deòdỹỹna heka tate. Kai heka Deuxu Riòre tate. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","18","Tahe Jesuisi rirawyònyre Pedro‑ò: —Inatyhymy Pedro tate, Waha, biu‑ki Mana ani rare. Boholake, ratximyhỹrele kia adee riteòsinyre. Iny aõkõ kia adee riteòsinyre. Wadohodỹỹna mahãdu kia mana tyre‑ò ariwinykre. Rubu dori heka tiu ituedeõna. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Waiòlòna rayna heka adee ariwahinykre. Kabede‑ki aõwidỹỹ adee binakeki tule biu‑ki ariijõnykre. Aõtxiletxibo aõwidỹỹmy burukre tasỹ biu‑ki tule adee ariwinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jiarỹ inatyhymy Deuxu deòdỹỹna rare. Tuu ijyyrenyõmyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Iribi tahe Jesuisi itỹny relyymy taerydỹỹna mahãdu‑ò. Rurukremy heka relyyre: —Arakre heka Jerusalẽ‑ò. Tai heka matuari mahãdu, õnosõna bedeeryna mahãdu, xiwena wahidỹỹdu mahãdu‑wana riwarubunykre. Inataõ txu‑di tahe ixyby rubu‑ribi adexixakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Idi tahe Pedro heka Jesuisi ridyre ijõ erydỹỹna‑ribi tahe tamy rarybere: —Aõkõre, Wanyrỹ, tiu heka tiiboho ararubunyrenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tahe Jesuisi rarybere Pedro‑ò: —Waribi bexihitxinyke. Kai heka Satanasi weselemy atximahãte. Iwese kai taraykynymahãte heka aõ Deuxu deewinamy aõkõ tuu tahõtinymahãte hãbudeewile rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Idi tahe Jesuisi rarybere taerydỹỹna mahãdu‑ò: —Inyõ wawananomy rurukeki, ixi‑ribi heka tõhõti rosake. Nomy rurukeki heka taitxeò rimyke idi tahe wahemy kanake. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Inyõ wahemy rariakemy ixi‑di rõhõtinyhyyke wana heka irumy inonana irehemy ixi‑di ratxikeki heka tii ihãrele ruruke. Inyõ taumy riõnonykeki waòraru‑ki tai tahe tii ròtake. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Inyõ heka ibutumy aõna aõna bede‑ki ributunykeki. Tahe ihãrele heka tii ruruke. Tule umytuedeõna riõnonyre. Aõ tarasana tamy aõ aõkõ rare. Iny iruna riòwynyõhyymyhỹre, ixiyby tamy kanake wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jiarỹ, Deuxu Riòre, Hãbutyhyhykỹ dori kanakre wana aõwesele. Taỹju loosòna‑ki tii kanake. Iny ibutumy ariòwynykre bibutunymy aõbo iny riwinymyhỹré heka aõwiwihikỹ aõbina bina. ");
INSERT INTO kpjNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iu jiarỹ, Deuxu Riòre, Hãbutyhyhykỹ, kanakeu tahe inyõ kaibohoõ tuu robikre, Iòlòmy kanakreu. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Reare heka debò sohoji reurò txumy. Tahe Jesuisi ridyre Pedro, Txiau, Joaõ‑wana. Joaõ tahe Txiau seriòre rare. Tahe raòwònyre tiiboho‑wana hãwãlò ratòòhòkỹ ratyy‑ò. Inyõ heka tii wana raõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ikoreny‑ki tahe Jesuisi rexiwitxiranyre. Iòsana heka roosòre. Txuwesehekỹle relere iòsana heka ratỹrỹrỹnyre. Ityky tasỹ rauranyhỹkỹre. Tahe roosòna itoosònadihikỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iu tahe tuu robire Moisesi rubu, Elia rubu, Jesuisi‑wana widee rarybemyhỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tahe Pedro tamy rarybere: —Awire, Wanyrỹ, kawese watxirenyreri kaki. Adee wikeki hetomy ariwinyrenykre ijõ adeekre, ijõ ta Moisesiõkre, ijõ Eliaõkre. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Iu Pedro rarybereriule tahe biuwetyky urahakỹ relere. Iyribile rybeõ narybede: —Kia heka Wariòre waluu heka rare. Boholabeny irybe‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Idi tahe ierydỹỹna tamy roholareu, tahe ruberure. Tahe reserenyre iòsanareny bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesuisi tamyreny nade: —Breburenyõmyke hewa bodorukubedenyke heka. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Reteherenyre tahe Jesuisi sohojile tai rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Iribi tahe diberenydenyde hãwãlò ratyy‑ribi, Jesuisi narybede: —Uritere waijyyõmyke inyko wiji tuu tabitimy. Iu jiarỹ, Deuxu Riòre Hãbutyhyhykỹ, rubu‑ribi riixixanykreu tahe tuu belyykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tahe ierydỹỹna mahãdu Jesuisi‑ò rỹỹraxire: —Aõherekibo tarybetenyteri —Elia juhuu kanakemy ako‑ò juhuu kanakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesuisi rirawyònyre: —Inatyhy rare tii juhuu kanakre. Ibutumy heka bede riywinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tule ararybekre kiamy: —Elia nade tahe ihãrele heka iny rieryõhyyre. Aõhõkỹmy risỹnyre. Iwese Elia aõhõkỹmy risỹnyre wesele tahe Deuxu Riòre Hãbu heka aõhõkỹmy risynykre, jiarỹ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tai tahe Jesuisi erydỹỹna mahãdu rieryrenyre aõmybo Eliamy tii raryberemy Joaõ Sebedỹỹdule tahe Jesuisi rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iribi tahe dòòsedenyde iny sõwemy riraõmy rỹimyhỹre. Hãbu‑ò nade Jesuisiko‑ò tatiowomy resere: ");
INSERT INTO kpjNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Wanyrỹ, ruxetòena wariòre‑di biwahinyke. Irayky awimy aõkõ ratximyhỹre. Bera‑txi resemyhỹre. Heòtyru‑txi resemyhỹre. Ibutumy aõna aõna riwinyrerimy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aerydỹỹna mahãdu‑ò heka adidyde tahe tiu riteytenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesuisi rirawyònyre tamyreny: —Kaiboho isira mahãdu atxitenyteri. Aõ heka inatyhyna heka akireny ijõkõre. Tiwese bede dỹỹnana bohe araòludunyrenykre. Bedese inihe bididy uladu wadee. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tahe Jesuisi rarybere kia uladuwo‑ki ratximyhỹò: —Iribi wa bohonyke! Tahe uladu reytemy reare. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Idi ierydỹỹna mahãdu Jesuisiòle rarybere: —Aõherekibohe jiarỹboho tyytybybina iribi reteònykõreri? ");
INSERT INTO kpjNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aõmareki kiehe ainatyhyna ibutetyhyreki òwòruty sõmowesele ainatyhyna dikeki heka kai aõwiwihikỹ biwinyke. Kai hãwãlòõ‑ò marybeke: —Iribi bexitake! Tai tahe hãwãlò rexitake iwitxira suò. Aõ aõkõ adee isirake, ainatyhyna direki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kia tyytyby bina iwitxira rare. Isiratyhyre heka. Kaiboho bexitòenybenykeki, binarehebenykeki, ixiery tyytybybina biteònybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Kalileia bede‑ki Jesuisi taerydỹỹna mahãdu‑wana ributunyre. Tai Jesuisi rarybere tamy: —Jiarỹ, Deuxu Riòre Hãbu, rare. Tai inyõ riwahinykre hãbubinaõ‑ò warubudỹỹmy. Inataõ txu‑di tahe rubu‑ribi adexixakre. Tai tahe ierydỹỹna mahãdu rabedewo nihikỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iu tiiboho heka Kafanaõ hãwã‑ò ritehemynyreu, inyõ Pedro‑ò nade. Tii dohodỹỹna òwy butudỹỹdu rare. Tahe rarybere: —Awedu aõbohe tii rexiòwynykekõ. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro rirawyònyre: —Tii riòwynymyhỹre. Tai tahe Pedro rakemy reare. Iu Pedro tuu Jesuisi‑ò rarybekemy hetowo‑ò raloreu, Jesuisi juhuu rarybere: —Moribibo iòlò rexitòenymyhỹre òwydỹỹnamy. Mynydu mahãdu‑ribi aõbo ada ta taijoiribile aõbohe rotamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro tahe rirawyònyre: —Mynydu mahãduòle rexitòenymyhỹre. —Inatyhy rare, Jesuisi rarybere. Iijoi mahãdu òsana riòwynyõhykymyhỹre. Jesuisi rarybere: —Ihãre tahe ròkòòwydỹỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Òbitimy rakaòwònyrenykre. Kia Templo heto òwymy. Ibinamy kia iny‑ò ariwinyõtyhy. Kai heka makre ahohokỹ‑ò awaxi‑di behukre. Juhu utura kanakrele heka bidimykre. Idi iry biraynykre. Tai nieruõ‑ki mahake. Iribi biditamy tahe makre iny òwydỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Iule tahe Jesuisi erydỹỹna mahãdu tamy rehemynyre rỹỹraxire: —Mobohe Deuxu Iòlòna‑ki nihikỹmy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesuisi heka ratximyhỹ uladuõ ibire‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Idi tamy rarybere: —Kai uladu weseleõmy mabeõkeki, Deuxu Iòlòna‑ò malòbenyõtyhy ");
INSERT INTO kpjNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Uladu wese maraykynybenykeki heka, tii tahe Deuxu Iòlòna‑ki inatyhymy rỹirakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kai waòraru‑ki uladu kawesemy biwiòhenanykeki tiwawiòhenanymahãte ");
INSERT INTO kpjNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kai uladuõ òraruna‑txi resekemy risỹnykeki, kai abinatyhymy atximahãte. Inyõ òy ritakamy reroti‑di aratakemy heka inyõ adi rehuke bera‑txi. Tii tahe awityhyre adee. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Sõwemy heka aõna aõna rỹira wary‑ribi iny riatykemy. Tii adee ibinatyhyre. Tiiemy heka tuhyy rarekre. Inydee heka ibinakre heka. Wary‑ribi riòlòdỹỹnymyhỹre heka tamy ibinakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ebò òraru‑ki tahe wainatyhyry‑ribi bexitakeki, ebò biòròmy idi behuke. Awityhyre heka adee Deuxu Iòlòna‑ò malòkre sohoji ebòdile. Inatxi ebò‑di heòty bedebina‑ò malòkeki, awiõre heka. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tule arue sohoji òraru‑ki kia òrarunamy beseke lau, urile bitake idi behuke. Arue wiò‑di heòty bedebina‑ò malòheny arue‑di wiòle. Biu bedewihikỹ‑ò malòke tahe awire heka arueyremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Iny nihikỹ ityhy iny yja mahãdu heka tuuõre. Uritere heka iweserenyõmy atxibenyke kaiboho bexiijebenyke tamy. Iny aõkõ mahãdu dori tii iỹju dire heka. Iỹjureny heka Deuxuko tii ibutumy relyymyhỹre tureny. Idi õhõtireny‑ribi bosabenyõke. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Jiarỹ Hãbutyhyhykỹ rare, Deuxu Riòre wahe. Ityhydỹỹdukõdu mahãdu ibutumy aritakemy anade. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Rakawesenanykre heka kaijyy wesemy. Rakarybekre heka kahãbu 100 budoeni ijõdire wesemy. Sohoji heka iõre iy‑ribi. Kia hãbu idi itxeredu tahe iy‑ribi iõre rakre ijesemy. Iuhe tahe hãwãlò‑ki riroximy ririre. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tai rahakre wana heka teysamy ratxikre. Kia sohoji òrarukile reysakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iwesetyhylemy taheka inyõ iõõtyhy Waha‑ribi. Tamy dori kia ibinare. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Inyõ adee rexiòrarunykeki tahe tamy makre rybemy. Uritere inywitxirako‑txi rybeõmy tuu. Tahe tamyhyylemy marybeke. Aityhydỹỹdu seriòre heka arybe‑ò roholakeki, tahe ixi‑txi tõhõti reake wana, ixi dee ibinamy rõhõtinyra wana, tai tahe kai ixyby tii‑wana ityhydỹỹdu seriòre biòwamy beleke. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aõhe wana tahe arybe‑ò roholaõhyykre, tahe ixityre make inyõ wana rexibiòwanymy. Iny inatximy ixihe‑ki bidyke. Tii tahe arybe‑ò ijohonaduke inatyhy raremy arybera‑txi resekemy wahe. Iu dohodỹỹna‑ki rarybekreu, tai tasỹ tii rarybeke teòsamy aõkõ ratximyhỹrelemy rarybeke. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tii irybereny‑ò roholaõkeki, tai tahe dohodỹỹna mahãdu‑ò belyyke. Tii irybereny‑ò roholaõkeki, tai tahe biteònyke. Tii iwese òrarudu mahãdu heka adee rarekre, bede dinodu‑ò nieru wydydu wese wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Iwese kaiboho waityhydỹỹdu mahãdu kabede‑ki rõhõtinyre wesele, tule araykywesetyhyle Deuxu biu‑ki rõhõtinykre. Aõbo adee kabede‑ki aõwidỹỹ ibinare ada awire heka tule biu‑ki ibinamy rarekre, awimy rarekre. Arybe riwitxiranyõtyhy kowa biu bede‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Iwitxiraõmy adeereny ararybekre: —Ijõ titxibo inatxi ada inataõ ityhydỹỹdu seriòre wiweselemy raraykynykre. Waha‑ò rexitòenymyhỹreki iwese rexitòenyre wesele heka tamy riwinykre biu‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Titxibo waniòraru‑ki inatxi, inataõ wii ributunykre heka, jiarỹ taile watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tahe Pedro rỹỹraxire Jesuisi‑ò: —Bede erydỹỹdu! Waityhydỹỹdu seriòre heka wadee rexiòrarunykeki, tiwesebo sõwe ariixãwididỹỹnykre ixi‑ribi debò inatxi reurò, my aõbo? ");
INSERT INTO kpjNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesuisi rirawyònyre: —Aõkõre, debòinatximy aõkõre, 490 wesemy wahe. Ixityre ixityre biixãwidỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Deuxu Iòlòna kawesemy rare: —Iòlòõ heka teòdu mahãdu kia contamy robikemy idi ratxireri. Tiwesebo inieru‑di rasiranyre wesemy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sohoji teòdu juhuu dehemynyde. Sõwemy heka tevedỹỹna ratximyhỹre, 1000,000 womati tỹrỹrỹhỹkỹ nieru wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Inieruõre heka iòwydỹỹna wahe. Idi rohonykemy heka iwedu riteònyre deòdu mahãdu wesemy. Tariòre‑wana tahãwyy‑wana ibutumy deòdumy roirekemy. Aõbo tai rỹimyhỹ heka ibutumy idi rohonyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tai kia deòdu heka tatiowotimy resere kia iòlòko‑txi: —Waiòlòreny, txioinihe biwaraòkre ariòwynykre ibutumy. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tai tahe iòlò riwotòenyre aõma ixinahykylemy ritusanyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tai tahe kia hãbu he rare kia urihimyò tamy radevenymyhỹò heka rexinohõtidỹỹnyre. Tai tahe hãbu lòtikile rimyre. Rierenymy resere ribòtòrarytxynyre: —Bidiwaòwynykre kỹnyhe wijityhyle. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tai tahe tatiowomy resere, rarybere: —Txiokre inihe ariòwynykre ibutulemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tai tahe rirutyre ròtenawo‑ò idi riòtenyre. Riwotòenyreõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Itxeredu mahãdu heka rabedewore tai tahe ibutumy relyyre iòlòko. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tai tahe ixityre tamy rarariòwyre tamy rarybere: —Aõherewe, deòdu binahakỹ, jiarỹ araixãwididỹỹnyre ibutumy inatyhy? Kai dori ixitòedỹỹna wadee tewinyta. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aõherekibohe aleina kia adee nadevenymyhỹde kia teixãwidinyõta, iwese jiarỹ araixãwidinyre wese. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tai tahe tii rimyre reburere itere iòlò, tai imynymy riteònyre rotenawo‑ò riòwynykre xiery riòlòdỹỹnykremy. Tai aõhõkỹmy rotỹỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesuisi rexihura narybede: —Kiawesele heka adeereny rarekre. Ityhydỹỹdu seriòre taseriòre riixãwidinyõkeki heka iwesele heka waha adi riwisỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesuisi ibedeerydỹỹna‑ribi rexihureu, Kalileia bede‑ribi ròhònyre. Bero Jordaõ weribiijà‑ò reurore, Judeia hãwã bede kanawe‑ribi ijà‑ò rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tai tahe sõwemy iny webinadu mahãdu rỹire. Idi tahe ihemy rare. Ibutumy riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariseu mahãdu imynymy idi riwisỹnymyhỹre aõbinamy rarybekeki rimykemy. Tai tahe tamy dỹỹraximy namyhỹde aõsirahakỹmybo: —Iny bede ywinareny tahãwyy riteònymyhỹre urirybelemy, wiribi resekemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesuisi dirawyònyde: —Ritidỹỹnamy aõbo tariaõmyhỹte idi? —Deuxu ibutu widỹỹdu heka juhuu hãbu hãwyy‑wana riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Idi tahe rarybere: —Hãbu heka tybyboho‑wana tadiboho‑wana wiribi rexihitxinymyhỹre tai tahe tahãwyywanale wii ributunymy rỹira. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Inatxi heka sohoji weselemy rarekre, hãbu tahãwyy‑wana. Deuxu heka hãbu tahãwyy‑wana ributunyreu, inyõ heka tiu rihitxinyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tahe ijõmy fariseu mahãdu ritỹỹraxinyre: —Aõherekibo Moisesi kawesemy juhuu rarybere: —Hãbu tahãwyy riteònykeki juhuu urile tyyriti tamy riwahinyke riteònykekoki. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tahe Jesuisi kawesemy rarybere: —Kaiboho heka ieryna urihimyòlereki aõ isirareki heka kia riwinyre. Juhuu tahe kawese aõkõ rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aõmale tahe ixinamy riteònyke ixi‑ribi òta òtadule heka aõwaxiny tuu riteònyre ixi‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tai tahe ierydỹỹna mahãdu rarybere Jesuisi‑ò: —Tahe kiawesekeki heka uritere heriõmy hãwyyõmy, hãbuõmy. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesuisi tahe dirawyònyde: —Kaa bede eryna heka aõ ibutuhukỹ‑ò aõkõ tureri aõma Deuxu bede eryna tamy riwahinymyhỹreòle heka tureri. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aõtxi‑ki tahe tuu hãbuõ rỹira hãwyymy heridumy aõkõ rỹira. Ijõ hãbuõ tahe tiiemy tunodumy rỹirerimy ihỹre. Iwitxira hãbu‑ò rexiwahinymy rỹireriki heka tuu rỹirerimy ihỹre. Ijõ tahe tuu rỹirerimy ihỹre aõma Deuxu aõmysỹdỹỹna òraru‑ki wahe. Kaa rybe tahe inyõ tahe rityhynykeki tii inatyhymy rityhynyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Inyõ didyde uladuõ Jesuisi‑ò tamy rexitòenykemy tebò iraty tyre‑ki roirerilemy. Ierydỹỹna mahãdu tahe uritere iixiradỹỹõmyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tahe Jesuisi rarybere: —Ixinamy kanamyhỹke uladu wadee. Uritere itinysỹrenyõmy. Uladu wesemy dori Deuxu Iòlòna ròtedu mahãdu ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesuisi tahe iratytyre tebò ritidire tamy rexitòenyre. Idi tahe Jesuisi rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aõu tahe hãbuõ Jesuisi‑ò nade: —Erydỹỹdu, aõhebo arotỹỹnykre. Aõma, timykibo umytuedeõna aritakemy wahe. Aõwidỹỹ wiwihikỹbo ariwinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesuisi rarybere: —Aõherekibo wadee aõwiwihikỹmy widỹỹ tỹỹraxiteri? Iny sohojile awi rare, Deuxule wahe. Kai bede ywina ibutumy bityhynyke, umytuedeõna hakỹ‑ò molokre. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Aõbedeywinabo arityhynykre? Tahe Jesuisi rirawyònyre: —Rubudỹỹõmy, Òta òta widỹỹõmy, wasiõmy, ruiõmy, ");
INSERT INTO kpjNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Adi boo‑wana bityhynyke, iwese ixiluure wese heka abireludu mahãdu luuke. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hãbu rarybere: —Kia heka aõu aõu jiarỹ retyhynyre. Aõijõmybo arotỹỹnykre? ");
INSERT INTO kpjNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesuisi rirawyònyre: —Kai òbitimy mabekekile aõmydỹỹna‑di ibutumy. Kia idi bohonyke òwy tahe biwahinyke urimynodu mahãdu‑ò. Tai sõwemy aõna aõna biu‑ki ahõrõmykre. Iribi tahe biwaheludunyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Iu hãbu kia roholareu tahe rabedewonihikỹre inieru sõwereki heka rabedewore. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tai tahe Jesuisi taerydỹỹna mahãdu ribedeerynyre: —Isiratyhyre heka biu bede‑ò ralòke aõma ityhy nihikỹkeki. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Isirare heka aõma kamelo tyy rurena òtumy ralòke heka isirare, inatyhy? Tai tahe aõma ityhy mahãdu ralòke tarasanamy reake heka isirare. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jesuisi erydỹỹna mahãdu ribedeòtiinyre kai‑ò roholareu. Tai tahe rõhõtinyre: —Aõkõre isiratyhyre tuu ròte. Inyõ tarasanamy reaõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesuisi tamyreny retehere tahe rarybere: —Inatyhy rare hãbu‑ò isirare. Deuxu dee tahe isiraõle rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tai tahe Pedro rarybere: —Jiarỹboho ibutumy aõmydỹỹnareny adiridenyde. Araheludunymy watxiwãhãre. Aõma ritarenykre? ");
INSERT INTO kpjNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesuisi tahe dirawyònyde: —Kiamy heka adee ararybekre. Jiarỹ Deuxu Riòre Hãbu tyhyhykỹ wahe. Kaiboho heka tule borukubenyke aiòlònaryna‑ki iu ibutumy ratỹmyrakreu. Kaiboho iny sohoji sohojimy judeu ijoiõ biywisidỹỹnanybenykre, waijoi waòinatxi reurò mahãduõ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Inyõ kia ibutumy aõbo waòraru‑ki ririmyhỹre iwese taheto ririmyhỹre waòraru‑ki, taseriòre, tadi, tyby, uladu, taoworu, ririmyhỹre. Kia sohoji sohoji‑ribi heka aõ sohoji sohoji òwymy 100 ritakre. Tule umytuedeòna ijõmy ritakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Inyõ nihikỹmy ityhymy ratxirerimy ihỹre, tii iyjalemy relekre, aõma aõkõ tai relekre. Tule iyja nihikỹmy relekre. Sõwemy urimynodu kaki rỹirerimy ihỹre tahe biu‑ki inihikỹmy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesuisi tasỹ riteòsinyreri ijyyõ timyrebo Deuxu Iòlòna. Hãbu aõmysỹdỹỹdu heka oworu widỹỹmy heka riteranymy tamy rarybemyhỹre: ");
INSERT INTO kpjNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","—Aõmamy araòwynykre, sohoji prata womati nieru, iwese ibutumy raòwynymyhỹre wese, sohoji txuòwy wahe. Tai tahe tii raaõmysỹdỹỹre uva oworu‑di raaõmysỹdỹỹmyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","4","Idi tahe tii reare 9 horau tule, txutyeu tule, titxibo iaõmysỹdỹỹna rỹireri titxibo hãbu teaõmysỹdỹỹmyhỹò. Tahe tuu robire urile ratximyhỹmyhe idi retehemyhỹ. Tai tahe tamy rarybere: —Maaõmysỹdỹỹke hewa, waoworu‑ki. Ikonana txu heka òbitihyky araòwynykemy adi watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tiiboho raaõmysỹdỹỹre tule. Txutye tasỹ ixiyrubule ijõ riteranyre aõma iwese kia juhuu ijõ‑ò rarybera wesele. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Txuinyòbira‑ò ijõ rimyre, tule ijõ txiorotxure. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Iruyre hora‑ò ijõ tasỹ riteònyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tahe txiorotxumy ròhònyra tahe kia iòwydỹỹdu tamy ryryre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tahe 1 womati nieru tamy riwahinyre, sohoji hora raaõmysỹdỹỹre mahãdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tahe txusohojimy raaõmysỹdỹỹre tahe iratyre ròtakremy ixi‑di rõhõtinyre. Tahe tule riòwynyra iwese ijõ riòwynyra weselemy, 1 womati nieru, sohoji sohoji wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tai tahe rimyre nieru urile tamy rexibinanymy rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","—Kowa heka sohoji horale raaõmysỹdỹỹhãrele heka 1 teòwynyta. Jiarỹ boho tahe txuhyy raaõmysỹdỹỹra, bede tòtee‑ki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tahe iwedu rarybere: —Wabiòwa, adeereny rarybera. Wiji 1 womati nieru ariwahinykremy heka inatyhy? Tuheka adeereny rewahinyre. Aribi rawasinyora. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Boibenykre heka ibutumy araòwynyreri. Wiwesetyhylemy heka araòwynyrenyreri, iwese rarybere wese. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Hora sohojilemy raaõmysỹdỹỹraò sohojimy wanieru ariòwynykre inatyhy. Tamy wanieru ariwahinykemy ixideewimy, aõhe inatyhy? Aõherekibo tebureteri? Jiarỹ urihimyò raaõmysỹdỹỹraò wawiremy tarybetenyteri wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesuisi tahe rexihure kia rybe‑di, kiamykre bede: —Ikoludu heka ihewoludu‑ò resekre. Ihewoludu tasỹ iko‑ò resekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tai tahe Jesuisi ròwònyre Jerusalẽ hãwã‑ò. Iny‑ribi tawaò inatxi reurò mahãdu rihitxinyre. Tamy relyyre timybo aõhebo rotỹỹnykremy Jerusalẽ hãwã‑ki: ");
INSERT INTO kpjNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Jiarỹ, Hãbutyhyhykỹ adee ararybekre: —Inyõ riwawahinykre aõma‑ò Xiwena wahidỹỹdu wedu mahãdu‑ò. Tule diwatyhenykre judeu wedu mahãdu‑ò. Tahe riwarubunykemy heka tiiboho wamy rarybekre ijõ iny‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tii heka riwamykre tahe riwawahinykre Roma iòlò‑ò, judeukõdu mahãdu iòlò wahe. Ibinatyhymy aõhebo riwasỹnymy riwahetenyre. Itxeò nihikỹ‑ò riwatamadỹỹnykre. Tahe txu inataõ‑di rubu‑ribi areixixanykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeu riòrese Jesuisi‑ò nade. Tatiowotimy resere tahe rexitòenyre aõmybo Jesuisi‑ò tariòre‑wana nade. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesuisi tamy rarybere: —Aõbo rare hãwyy rarybere: —Waritxòre inatxi hãbu rare. Tikiboho kỹnyhe, aikòlònykuna rynana‑ki ronykre awana. Ijõ aruruna‑txi, ijõ ahywe‑txi wahe, kai aikòlòkuna‑kò malokreku wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesuisi heka iriòre‑ò rarybere: —Kaiboho aõmybo texitòenyteri teerykõleteri. Kai Txiau, kai Joaõ, teerytenyte aõbo aõhebo wadi rotỹỹnykre arurukre dori jiarỹ kaiboho tulekre? Tiiboho dirawyònyde: —Tulekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tahe Jesuisi rarybere: —Inatyhy rare kaiboho tule aõhõkỹmy botỹỹnybenykre. Tahe mobo warora‑txi ada waruruna weribi rynana‑txi ronykre. Jiarỹ reerykõre. Wahale heka rieryre. Tiile tamy riywinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Idi tahe debòwiò ierydỹỹna mahãdu kia rieryre aõmybo Txiaku Joaõboho rexitòenyrenyrá. Tai tahe tiiboho rakyarananyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tahe Jesuisi ibutumy taerydỹỹna mahãdu tamy kanakemy rarybere: —Iny iòlò iruru dire. Ibutumy dinodu tahe kia weselere —taijoi mahãdu riteònymyhỹre. Teòdu mahãdu riteònymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tahe aõ tuukre aõkõ heka rare ayreny‑ki. Inyõ dinodumy ixidikre heka deòdumy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kia iny nihikỹmy ixi‑di rexinohõtinyreri tasỹ aõ aõkõ tii rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Iwese jiarỹ riwinyre wesemy heka rarekre. Hãbutyhyhykỹ aõ dinodumy aõkõ anade. Iwese deòdu rỹira wesemy heka nade waumy riwahinykremy rubu‑ò kabede‑ki. Tai sõwemy iny ritakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iu Ijeriò hãwã‑ribi ròirenyreu, tahe sõwemy iny riheludunyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Inatxi iruetàmy heka ronymyhỹ iu Jesuisi ibire‑di rareu. Tiiboho roholarenyre kia Jesuisi raremy. Rexidelenyre ryryre Jesuisi‑ò: —Davi riokore, wadee hewa ruxetòena biwahinyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tai tahe iòhòmy iny iribi rỹimyhỹ rarybere: —Txiokre inihe, biyryke! Ixityre ryryre tarurutyhy: —Inynyrỹ Davi riokore, Biwawotòenyke hewa. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesuisi tamy rarybere: —Aõwexe adeereny ariwinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Wanyrỹ, Kai wa bidiwaruenykre warue biraynykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tahe Jesuisi riwotòenyre iruebymy reare tebò‑di. Aõwesele tahe ruòmy reare. Tai tahe Jesuisihe riheludunyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesuisiboho tahe rehemynyrenyre Jerusalẽ hãwã iòhòmy. Betabaji hãwã‑ò heka rehemynyre. Kia Oliveira hãwãlò‑ribi irehemy aõkõ ihỹre. Tahe Jesuisi inatxi iny riteònyre hãwã‑ò, taerydỹỹna mahãdu wahe. Tamy rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Juhu hãwã dele‑ò malokreule aõma bobikre, jumenta tariòre‑wana. Tahe bitaanalawekre ta bididykre kaò. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Inyõ aratỹỹraxinykre wana, tai tahe kiamy bisỹnykre aõma: —Wawedu hewa idi ratxikemy rõhõtinyreri. Tai ki tahe ahemy kiditeònykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kia ihetxiu ritidỹỹna tuheka relemy roimyhỹre. Kamy rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","—Marybeke heka Jerusalẽ hãwã‑ò: —Deuxu Iòlòna heka kanakre adeereny wahe. Tii inihikỹ wesemy aõkõ kedehemynymy, jumenta tyre‑ki heka kedehemynykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tahe ierydỹỹna mahãdu riwinyre iwese Jesuisi rarybere weselemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Didyde tahe jumenta tariòre‑wana. Ihetyreny jumenta tyre ritidire. Jesuisi ityre ronyre tahe idi rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tahe inyõ sõwemy‑ribi tahetyreny‑di rehumyhỹre iryko‑txi idi rariakemy ityre‑di. Ijõ tasỹ hereru‑di iryko‑txi rehure iryube hetymy ityre‑di rariakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sõwemy tai iny rirajuamy rỹimyhỹ iko‑ò, ihewo‑ò: —Iòlò Davi riokore heka sõwemy iny wowydyna tamy iny riwahinyreri. Tii Deuxu Riòre Hãbu rare. Deuxu deysana heka tamy biwahinyke! ");
INSERT INTO kpjNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesuisi hãwãy‑ki rehemynyreu, ibutumy iny ribedeòtiidỹỹnyre: —Mohãbuwe kia ralòreri Jerusalẽ hãwã‑ki wahe? ");
INSERT INTO kpjNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tai tahe iny mahãdu rarybere: —Aõkõre, kia Deuxu rybeduõ rare. Jesuisi inire Kalileia bede‑ribi Nazare hãwã‑ribi dehemynyde. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tahe ralore Deuxu dohodỹỹna heto‑ò. Tai kia aõna aõna‑di rohonyreri heka riteònyre. Kia aõma nieru wiuròna iòwòruwebese tahe riatyre. Kia aõma bòtòe dohodỹỹdu ryna ibutumy ritxiwire riatyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tahe Jesuisi rarybere: —Deuxu Tyyriti rarybere: —Dohodỹỹna heto heka waha heto rare, ixitòedỹỹna heto rare. —Kaiboho heka inywasidu mahãdu‑di tetỹxinytenyta. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Sõwemy iny itiere, iruetà, nade Jesuisi‑ò dohodỹỹna heto‑ò. Jesuisi taile riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tahe xiwena wahidỹỹdu wedu tuu robire. Tule judeu bede ywina bede eryna mahãdu robireu tahe, aõma uladu templo‑ki ryrymy rỹimyhỹò aõma: —Davi riokore heka Deuxudeewina rare. Tai tahe kia rybe‑ò reburerenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tiiboho tahe raryberenyre Jesuisi‑ò: —Kai aõbo taholate aõbo rarybereri. Jesuisi rirawyònyre: —Kohe, raholare. Kaiboho teeryõtenyte: —Uladu dori wowydyna tamy riwahinykre. Tiu aõbo tariatenyõhyymahãte kia Tyyriti‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tahe Jesuisi iribi ròhònyre Betỹnia hãwã‑ò. Taile tahe ruu idi rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Biurasò txumy tahe tii dòòsede Jerusalẽ‑ò. Tahe rama risare iu. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Òwòruõ tai rỹire. Tai tahe diaride figoraty‑ò. Tahe iratyõre, txirule rỹire. Tai Jesuisi rarybere òwòru‑ò: —Tiu heka kai maratynyõtyhy aõwesele tahe irade rairuxỹrure. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tai tahe ierydỹỹna mahãdu heka ribedeòtiidỹỹnyre: —Timykibo heka aõwesele rairumyrõmy reareri. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tahe Jesuisi tamy rarybere: —Kai ainatyhyna ijõdikeki heka iwesele biwinyke. Iratyre biwinyke. Kaiboho heka bitxiõnyõkeki kaa hãwãlò‑ò dori marybekre kiamy: —Iribi bexitake tahe aho‑ò boikre. Tai hãwãlò‑ò aõwesele heka ahoro‑ò roikre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Aõtxile kai bexitòenykre heka adee ijõ rỹikre. Bityhynytyhykeki, tahe ibutumy bitake. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tai Jesuisi dehemynyde Deuxu dohodỹỹna heto‑ò. Tai tahe ròbedeerydỹỹmy ratximyhỹ. Tahe xiwena wahidỹỹdu mahãdu, tule judeu bede ywina erydỹỹna mahãdu tule tamy dỹỹraximy nade. Tai tahe Jesuisi‑ò rỹỹraxire: —Morurudibo heka kai aõmydỹỹnana tewinymahãte? Mobo heka arateranyre kia biwinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tai tahe Jesuisi tamy rarybere: —Kai aõbo myỹraxikeki wadee tai ako tuu arelyykre. Kai dỹỹraxinaõmy bidiwatỹnynykeki tahe, adee tuu arelyykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","—Joaõ Sebedỹỹdu heka morurudibo nade morybekibo tuu tadiwinymahãte wesemy. Morybekibo Joaõ iny risebenymyhỹre. Deuxu Rybe‑ki aõbo ada iny rybe‑ki aõbo. Tai tahe widee rarybe raryberenyre: —Aõma Deuxu Rybe‑ki tuu ròsebedỹỹmyhỹre. Mykeki rakarybenykre taheka: —Aõherekibo tetyhynytenyõte myle tii risỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aõmamy rikisỹnyrenykeki: —Iny rybekile tii tahe nade. Myỹ rikisỹnyrenykeki tasỹ kia ijoi inydeereny rakyarananyke. Joaõ Sebedỹỹdu dori ibutumy iny rityhynyrenyre moma tii Deuxu deòduõ ratximyhỹre heka. Rakarybenyõkre tahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tai tahe Jesuisi‑ò raryberenyre: —Aõkõre, reeryrenyõre heka irawyòdỹỹ titxiribibo iruru nade. Tahe Jesuisi rirawyònyre: —Tule jiarỹ ỹỹraxina adeereny aritỹnynyrenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ijõ Jesuisi relyyre: —Timybo maraykynybenykre ka ijyymy arelyykre. Hãbuõ heka inatximy iriòre raremyhỹ. Tariòre dela‑ò rarybere: —Dàà, maaõmysỹdỹỹkre waoworu‑ki, wiji wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tahe tamy dirawyònyde: —Waha, araõkre hewa. Ihãrele tahe tawo rirahòrere rakremy. Tahe rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Idi tahe tyby rarybere helỹỹna‑ò: —Kai tule makre waaõmysỹdỹỹna biwinykremy: —Dei wahe, arakre araaõmysỹdỹỹkre. Ihãrele tahe tii raõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Adeereny inihe araỹraxikre. —Tibohe weryrybò aõma tybyrybe rityhynyre? Tai tahe dirawyònyde: —Juduludule irybe rityhynyre. Tai tahe Jesuisi tamy rarybere: —Iny òrarudu tyhy heka wydena‑wana ralòkre biu bede ròtena‑ò. Ihãrele tahe kaiboho birònybenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Joaõ Sebedỹỹdu dori adeereny rarybere. Ihãrele tahe kaiboho ixitxireny aòrarureny‑txi õhõtireny reakemy Deuxu bityhynykemy. Kaiboho heka teramy tekoamahãte tahe sõwemy òrarudu mahãdu wydena mahãdu rityhynyrenyre. Kaiboho tuu tabitenyte ihãrele teerytenykõte. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ijõ ijyymy arelyykre: —Hãbuõ heka uva oworuhukỹle ritòbrònyre. Tahe òtityna riwinyre. Tai tahe utà riwinyre yrubudỹỹdu mahãdu itxerenamy. Tai tahe rihuòtere oworu wahe hãbu mahãduõ‑ò. Tii tahe rabedetỹinymy rare taheto‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Iu uva bederaty kia siredenamy bede reareu, riherehe txuramy ixidee ritxuakemy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tai tahe huòtedu mahãdumy heka teòdu mahãdulemy raòhòtere. Ijõ tahe rirubunyre ijõ manadile tamy rehunanymy rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Iribi tasỹ teòdu mahãduõ didyde sõwetyhymy juhuna ludu ratyre. Tahe ixybyle tuu raòhòtere juhuu iwese tuu rotỹỹnyra wesele. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tahe iwedutyhy rõhõtinyre: —Aõma wariòrele kòri ariteònykre. Tai tahe wariòre rityhynykre heka. Tahe tariòre diteònyde. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tahe huòtedu mahãdu weryrybòmy robireu, tahe wideereny rarybere: —Kaa heka iwedu riòrele rare. Aõma iwedu rurukreu iaõna aõna, ioworu heka ixideereny rikimyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tahe rirubunyrenyre iumy‑di rehurenyre oworuro‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tahe Jesuisi rarybere: —Adeereny araỹraxikre aõbo iwedu tamyreny riwinykre huòtedu mahãdu‑ò iu tii rehemynykreu wahe. Timybohe tii riwinykre? ");
INSERT INTO kpjNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tiiboho dirawyònydenyde: —Kia rirubunykre ibutumy hãbu bina. Inywitxira‑ò huòtenamy ele elemy wijuramy riatykre‑ò riwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tahe Jesuisi tamy rỹỹraxire: —Kaiboho aõbo Ryberiti‑di tariaõletenyteri: —Mana‑di heka heto widỹỹdu rehumyhỹre kia manale heto hàtxi‑ki ritidimy roimyhỹre. Jiarỹ kia mana wese rare. Inynyrỹ Deuxu kia riwahinyre. Tai awi heka rare. Ijõ riwiòhenanyre, mana wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tahe Jesuisi tamyreny rarybere: —Tule jiarỹ adeereny ararybekre: —Deuxu Iòlòna heka aribi ritakre. Tahe inywitxira‑ò aribi riwahinykre. Inyõ txura wylemy riwahinykremy Deuxu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kia iny mana tyre resemyhỹkre heka tii heka wiòròmy ixòdumy rare. Mana inytyre resekeki tasỹ iny risurusurunyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Inyõ roholakeki kia aõbo aõma xiwena wahidỹỹdu mahãdu roholamy rỹimyhỹ tule fariseu mahãdu. Tule rexierymyhỹrenyre tiiboho Jesuisi turenyle rarybereri heka rierymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tai heka tii mahãdu rimykemy idi riwisỹnymyhỹ tahe iny sõwehekỹ lau ruberumyhỹrenyre. Iny mahãdu dori idi rõhõtiny tii Deuxu rybeduõ ratximyhỹremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesuisi heka rexidelenyre ijyymy relyykremy: ");
INSERT INTO kpjNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Timybo Deuxu Iòlòna rare ijyymy heka relyykre. —Iòlòõ heka tariòre herinamy worana bedehesi riywinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Iaõmydỹỹnana ròrarukõmy rỹidi tahe teòdu mahãdu iòrysymy roire. Rexihumy rỹireriki iaõmydỹỹnana, kanakremy wahe. Tahe òrysyna noderamy reare. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ijõ riteònyre teòduõ iny ritobinykremy. Aõhere tahaka, wabroreni kỹnyhe rerubunyre heka. Ibutumy heka waaõmydỹỹna rehumy rỹireri. Tahe kedea kedeake heka kòdòidenyke heka. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tahe timy heka irybe rityhynyrenyõhyyre. Iny sohoji sohoji tatyyresi‑di ijohona‑ò, ijõ taaõmysỹdỹỹna‑ò rea reare, ijõ taoworu‑ò reare. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ijõ lobidỹỹna reburere teòdu mahãdu dee. Tii teòdu dee heka rawobinare. Ijõ aõbina bina heka ritxienyre ijõ rirubunyre dori. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tai tahe iòlò reburere lobidỹdỹna mahãdumy bina bina raòhòtedỹỹnyre, rirubunyre. Ihãwã ritoonyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tai iòlò rarybere teòduboho‑ò: —Waworana bedehesi rexihumy rỹireri ibutumy. Kia iny mahãdu ijoi juhuu retobinyra heka aõ ibina heka roire. Urile riòmysanymyhỹrenye. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tai tahe ibutumy boibenykre hãwã‑ò ibutumy iny‑txi bekoabenybekre heka bitobinybenybekre ibutumy waworana bedehesina‑ò kedea kedeakremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tai tahe didyde iny wiwihikỹ, iny ityhy iny bina mahãdu. Hetowo tahe ritỹxire tỹmyra mahãdu‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tahe iòlò ralore hetowo‑ò kia iny mahãdu dee rybemy. Tahe tii robire hãbuõmy kia worana bedehesi kia tykyõmy ratxirerimy. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tai tahe tamy iòlò rarybere: —Waliiny, aõherekiwe worana bedehesi kia tyky‑di aõkõ atxiteri? Kia tahe hãbu rybeõmy riijere. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tai tahe iòlò aõma rarybere teòdu mahãdu‑ò: —Bimybenyke kaa hãbu. Waa bitaataabenyke imy behubenyke tahe idi diòlòdỹỹmy idi rehukre luruhukỹ‑ò. Tai Aõhõkỹmy dỹỹnana‑ki tai txuraruti rikyikyinymy. Tai rahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tai tahe Jesuisi rarybere: —Sõwemy iny heka kidirahukre tahe ibutemy kanaarikre. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tai tahe fariseu mahãdu ròhònyre wii rotyre. Aõbinamy Jesuisi rarybekeule heka rimykemy idi rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kia aõma fariseu ijoiõ heka riteònyre Jesuisi‑ò. Tule Herodi ijoi mahãdu riteònyre. Rỹỹraxire Jesuisi‑ò: —Erydỹỹdu, kai heka hãbuwi tate, hãbu òbiti. Kai heka tòbedeerydỹỹmahãte Deuxu deewinamy. Awire aõbo ariòwynyrenykre Roma hãwã mahãdu dinodu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kai heka ixinamy aõma adee iny rarybererimy ihỹre. Timybo iny raraykynyrerimy ihỹre. Iny bede ywinareny aõbohe ixinamy nieru aõna aõna òwydỹỹnamy ròhònyke aõbohe awire? ");
INSERT INTO kpjNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tai Jesuisi heka rierymyhỹ aõma awimy aõkõ tai rahareri heka rexierymyhỹre: —Kaiboho òbitimy aõkõ toite. Aõherekibo heka kai biwaitxenanybenykemy wamynymy wadi atxitenyteri? ");
INSERT INTO kpjNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Timybohe nieru‑ki rakaharenykre aõna aõna òwydỹỹnamy. Biditeòsinyke kia‑ò arierykremy. Tai tahe tamy riteòsinyre womati nieruõ. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tahe Jesuisi ritỹỹraxinyre: —Motyytybybo koa rỹire. Monibo ityre‑ki koa roire? ");
INSERT INTO kpjNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tai tahe rirawyònyre: —Roma hãwã iòlònile tai roire. Tai tahe Jesuisi rarybere: —Tibo Roma hãwã iòlò nierubo heka tamy biwahinykre. Tibo Deuxu nierule tasỹ tamy biwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tai tahe urile ribedeòtiidỹỹnyre. Tai ririrenyre ròirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tahe kia txule saduseu mahãduõ heka dòidenyde Jesuisi‑ò. Rityhynyõhyymyhỹre kia aõma rubu‑bibi ixixana heka rityhynyõhyymyhỹre, saduseu mahãdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tamy rarybere: —Erydỹỹdu, Moisesi tyyriti heka kawesemy ribedeerynyre: —Aõma hãbumy hãwyy heridumy roikeki aõbohe timykibo hãwyy uladu‑di ratxikeki. Hãbuõ iriòrekõ‑di rurukeki tai tahe iseriòre heka iriòrese tyby‑wana roike. Tai heka kia hãbu rubuweleu, kia deròwymy heka uladu ritybienyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aõu heka debò inatxi seriòremy kaki rasỹnymy raremyhỹ. Telareny heka roire hãwyymy tahe iriòrekõlemy rurure. Tahe ihãwyytybyhe kia iseriòrewanale roire. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ihelỹỹna sỹ tule rurure. Kia heka ibutumy debò inatxi reurò tii‑wana roihyyre iriòrekõule. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tahe hãwyy heka tule rurure. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tai tahe kia ruru‑ribi rexixakreu tahe, tiwexe ihãbukre? Ibutumy dorihe tii‑wana heka roilehekỹlera. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tai tahe Jesuisi rirawyònyre: —Kaiboho teerytenykõlemahãtenyte timybo Tyyriti‑ki roimyhỹre. Deuxu ruru tule teeryõte. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tiu iny rubu‑ribi rexixakreu iwitxiramy rexixakre. Ỹju wesemy ronykre. Timy heka hãbumy hãwyymy roiõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kaiboho heka tetyhynytenyõhyymahãtenyte rubu‑ribi ixixana. Idi heka tariatenyõhyymahãtenyte timybo Deuxu rarybere? ");
INSERT INTO kpjNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kiamy heka rarybere: —Jiarỹ heka Abraõ Deuxu rare. Ijai Deuxu rare. Ijaò Deuxu jiarỹ rare. Tii heka iru mahãdu Deuxu heka tii ihỹre rubu mahãdu Deuxu aõkõ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iu iny sõwe ribedeerynyreu, tahe urile iny ribedeòtiidỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseu mahãdu doidenyde Jesuisi‑ò wii rotyrenyre. Roholareki wahe aõma saduceu mahãdu ribedeòtiidỹỹnyrenyreki. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bede ywina erỹdỹỹna mahãduõ rỹỹraxire heka aõmybo Jesuisi‑ò. Tii rimykemy heka idi riwisỹnymy kia rybebinaõmy rirawyònykeki rimykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tahe rỹỹraxire: —Erydỹỹdu, tibohe aõbo bede ywina kia‑ribi aõnityhymyhewe bedeòtiidỹỹnamy ratximyhỹre. Wakoreny inihe tuu bedelyykre. Tibo kidiòtiidỹỹnamy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tahe Jesuisi dirawyònyde: —Iny Deuxureny iny iòlòreny luuke heka. Ibutumy awo‑ribi heka iluuke, ibutumy aruruna‑ribi, ibutumy arayky‑ribi luuke heka. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tii heka inatyhy bedeòtiidỹỹna tyhymy ratximyhỹre ibutu bede ywina‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ijõ ihelỹỹna tahe iwesele heka rare: Iwese ixiluure wese heka ibutu luuke. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ibutumy Moisesi bede ywina heka juhuu rare. Tule Deuxu rybedu mahãdu erydỹỹna heka iribile rare. Kia bede ywina inatxi‑ribi heka ibutumy iny bede eryna ròhònyre. Kia inatxi bityhynymy bohonykeki iuhe heka tetyhynymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Iu fariseu mahãdu iweroramy rỹimyhỹò tahe rỹỹraxire Jesuisi tamy: ");
INSERT INTO kpjNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Mobo Deuxu deòdỹỹnamy ihỹre, Kristu wahe? Moriòrebo tii ihỹre. Tai tahe tiiboho rirawyònyrenyre: —Moma Davi riokore òsana. Tahe ijõ Jesuisi rỹỹraxire: ");
INSERT INTO kpjNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Tai tahe aõherekibo Davi heka Wanyrỹmy rininire Deuxu Tyytybytyhy irybe riwiòhenanyreu wahe. Davi dori kawesemy rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Deuxu wawedu‑ò rarybere. —Bodonyke warurunawe‑ribi, jiarỹ heka aòludu mahãdu‑di arawo‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davi tawedumy Kristu rininirehãre, timykibo Kristu iriokore riokorekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tahe inyõ heka Jesuisi rirawyònyõhyyre. Tai tahe ruberumyhỹre tamy rỹỹraxike lau. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesuisi heka iny sõwe nihikỹ ribedeerynymyhỹ taerydỹỹna mahãdu‑wana. Tii rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Judeu bedeerydỹỹdu mahãdu heka Moisesi bede ywina bede erydỹỹna mahãduõ rare. fariseu mahãdu tule bede ywina riwinymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iwese ribedeerynyre wese tahe bityhynykre. Uritere iwese tii riwinymyhỹre wese uritere iwidỹỹõmy. Aõwidỹỹmy rarybemyhỹrenyrehãre tahe aõwitxira heka riwinymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tiiboho heka atyrereny riòdònynihikỹmyhỹre bede ywina. Ihãre tahe rityhynyrenyõhyymahãrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Aõma òbitimy ratxike sỹny heka iny tamy roholamyhỹre ixi‑di ratxirerimy ihỹre. Aõma walabu riòreõ heka rỹimyhỹre axiò‑ki bede ywina heka ritidimy roimyhỹre ityky ijeti retydyna bede ywina‑txi tõhõti reakemy tuu riwinyrenyre. Sõwemy heka iretydyna riwinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ronymyhỹreu heka ikoòhòkỹle ronymyhỹre, worana bedehesina rỹi‑wana wahe. Dohodỹỹna heto‑ki heka tule ronymyhỹre, iko‑ò tuu rexisỹnymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hãwãy‑ki iny tamy ryrymyhỹre: —Waerydỹỹdu, Habimy, kia tahe irybe‑ki bede erydỹỹdu rare. Tii tahe tamyreny awire. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tai tahe Jesuisi tamyreny rarybere: —Kaiboho heka uritere Habimy inyõ adeereny irykõmy ihỹke. Deuxu sohojile bede erydỹỹdu heka rare. Ibutumy kaiboho seriòre wesemy atximahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kasu‑ki taheka inyõ heka tiu wahamy inyõ widee rarybeõtyhy Deuxu biu‑ki ratximyhỹrele tuu bininibenyke heka. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Uritere Wawedu myỹ inyõ kia nidỹỹõmy. Deuxu deòdỹỹnale heka awedu ratximyhỹre Mesia wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Anihikỹmy ixi‑di mohõtinykeki tahe, kia iny biwiòhenanyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kia ityhy rare ixi‑di rõhõtinymyhỹre, tii heka ihewo‑ribi rabedewokre. Ihewo‑ribi tahe aõma aõkõ relekre. Kia iaõkõmy ixi‑di rõhõtinykre tahe nihikỹmy heka relekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Belàhàxe! Kaiboho itxenadỹỹluku. Ibina adeereny kanakre, kai bede erydỹỹna mahãdu, fariseu mahãdu. Kaiboho uritere iny ròtedỹỹrenyõmy Deuxu Iòlòna‑ò. Kaiboho birònybenyõtyhy tule iny ròtedỹỹ‑ò biebenyke. Kaiboho bexisỹnybenyke òbitinamy. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Aixitòedỹỹna rehereheki wahe hãwã ube‑ki. Kaiboho urile iny teitxenanymahãtenyte. Aõma wytese urimynodu heka iheto‑ribi teteònymahãtenyte kaiboho heka abinarenyre. Tai heka kaiboho yla aõkõ aõhõkỹmy botỹỹnybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Belàhàxe! Kaiboho ibutumy iny aratyhynyrenykemy ixi‑di tahõtinymahãtenyte. Tai heka iny tesỹnymahãtenyte òrarudutyhymy wahe ixiratyre heka teijiradỹỹnymahãtenyte. Aòraru‑ki heka aõhõkỹmy botỹỹnybenykre. Iny‑di atxikemy heka tahõtinymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kaiboho ruetà mahãdu wesemy kai ahãte. Kaiboho heka kia wesemy tebedeerynytenyte. Inyõ heka Deuxu bede eryna heto riwawiòhenanykeki heka aõna aõna ariwinykre. Myỹ marybebenykeki, heka aõ aõkõ heka rare. Deuxu dohodỹỹna heto womati tỹrỹrỹhỹkỹ‑di marybekeki heka, tii heka rityhynyhyy. Ibutumy heka kia bede ywina òta òta tewinymahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kaiboho heka bede erydỹỹdu bede erytyhykõ mahãdu atxitenyteri dohodỹỹna heto kia‑ò ralòkeki. Aõbo bedeòtiidỹỹna tyhyre womati tỹrỹrỹhỹkỹ aõbo ada dohodỹỹna hetole aõbo teeryõte, Deuxu Dohodỹỹna heto wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kaiboho tule tebedeerynyte kawesemy. Inyõ tarybe inatyhy‑di rarybekeki, tai heka kia xiwena wahidỹỹna‑di rarybekeki, tai tahe tii rityhynyõkeki, awira. Tahe tii xiwena wahidỹỹna tyre‑ki rarybekeki tahe, tii òbitimy heka rarybeke. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kaiboho ruetà mahãdu wese, kaiboho heka erydỹỹnakõdu mahãdumy toite. Aõbo awityhyre? Xiwena wahidỹỹna aõbo ada ityre‑ki wahidỹỹna roimyhỹre aõbo? ");
INSERT INTO kpjNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wahisidỹỹna heka wiwesele rare. Aõma xiwena tyre‑ki roire wana tule wiwesele rare. Aõma xiwena tyre‑ki roiõre wana wahe heka aõ aõkõ rare. Xiwena utàle heka rierymyhỹre inatyhy rare. Myheka kai mararybekeki heka tai tahe kai heka xiwena utàlemy tarybeteri. Ibutumy iny ityre‑ki rỹire bohomy tule heka tai tuu tarybeteri. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Deuxu dohodỹỹna heto òraru‑ki kai koityhyxemy marybekeki heka tai heka kai dohodỹỹna hetomy tarybeteri hãre tahe Deuxu iwo‑ki ratxirerilemy tuu tarybeteri. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Biu òraru‑ki ka koityhyxenyteri marybekeki, Deuxusỹmy tarybeteri. Tii dori tarynana‑ki ronyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Belàhàxe! fariseu mahãdu! Kaiboho heka itxenadỹỹdu mahãduõ toite. Tule bede ywina bede erydỹỹdu mahãdu. Adeereny heka ibinamy ratxikre. Arỹsỹna uri juraõ heka kai Deuxu‑ò tewahinyte, hortelã, erva‑doce, cominho wahe. Kaiboho heka aõninihikỹ tetyhynytenyõhyymahãtenyte. Iwese òbitina, ruxetòena, inatyhyna kia‑ribi heka õhõti losamyhỹre ibutumy. Aõmydỹỹna jura wahisidỹỹna heka awi rare. Tahe tule uritere õhõti losaõmyke aõwitxira‑ribi wahe. Aõbo bedeòtiidỹỹnare bede ywina‑ki. Kaiboho heka bede erydỹỹdu toite hãre tahe teerytenyõte. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Belàhàxe! Kai hãbuõ wese rare. Tiiboho imona berareny‑ribi ohoruxõmo riarimahãre. Ihãrele tahe tiiboho iròdu nihikỹ rirỹsỹmyhỹre. Iwesele kaiboho tule terỹsỹmyhỹtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Belàhàxe fariseu mahãdu, bede ywina bede erydỹỹna mahãdu. Amona deoreny tesuhòmahãtenyte iwe. Iwo tahe ka isuhukỹlemy rỹimyhỹre. Itxenadỹỹna rỹire. Aõma aumy weselemy heka kia ratximyhỹre. Aõma aumy heka webòròsityy tyrare heka. Araykywo‑ki tahe ibutu itxenadỹỹ heka tai rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Belàhàxe fariseu mahãdu! Kaiboho taruetà mahãdu. Kai mona hynawo bisuhòke heka biòtinyke. Aõma bisuhòke ihỹre tahe arayky bityranykre. Tahe ibutumy heka aumy ryranykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","—Belàhàxe fariseu mahãdu! Kaiboho heka koityhyxenyteri. Rubu heto wiwihikỹ ixideereny tewinymahãtenyte. Kaiboho heka iwesetyhylemy toite. Aõma webòròsitylydu heka iruxeramy idi toite. Aõma aworeny‑ki tahe aõma iny rubu idi ròhòkỹdileka atxitenyteri mahãtenyte. Ibutumy aõbina bina awo‑ki arayky‑ki idi atxiteri mahãtenyte. Aumyreny‑ki heka tykywihikỹ texitykyny mahãtenyte. Aõma hãbu wihikỹwesemy. Hãbu òbitimy matxibenyke myheka iny adi rõhõtirenykemy heka tuu texitykynymahãtenyte. Araykywo‑ki tahe arimyrenywo‑ki tahe ibutu itxenadỹỹna‑di heka toite, òrarudu mahãdu toite. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Belàhàxe! Tai heka kaiboho Deuxu rybedu mahãduõ rirubunyre. Kaa nohõti ijaranamy tuu tewinymahãtenyte. Awabederenywo‑ki heka noijasa ruxerahakỹle tetidite. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kaiboho heka tarybemahãtenyte. —Tiu wahareny riwinyre wese heka ariwinyrenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kiamy tarybeteu heka hãbu bina riòremy texininite. Bowesele toite. Iriòre toite. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Iwese juhuu ibinamy riwinyre wese heka iwesetyhyle aõhebo tatỹỹnymahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Iwese hemylala deborehekỹ wesemy heka kaiboho atximahãtenyte. Boreny tule iweselere. Timybo heka kaiboho heòty bede‑ribi mahenybenyke? Kaiboho heòty bede‑ò boibenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Adeereny ariteònykre aõma Deuxu rybeduõ hãbu erydu, tyyriti erydu wahe. Kaiboho bidirubunybedenykre. Ohodỹỹna heto‑ki ijõ bidihetenybedenykre awaru hetenaõ‑di. Itxeòtyre‑ki ijõ bidirubunybedenykre. Ijõ heka biheludumykre hãwã hãwã‑ò tamy ibinamy riwinykremy. Aõhõkỹmy dỹỹnana heka tamy biwahinybenykre ijõ hãwã‑ò rakreu. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Kia heka hãbu ibutumy rurure tyby òraru‑ki wahe. Dohodỹỹna hetowokile rirubunyrenyre. Kaiboho Abeli juhuu terubunytenyte ikonana tahe Zacaria, Barakia riòre wahe. Òbitityhy juratya‑ki heka tuu tewinytenyte. Wijinabòdu mahãdu tai aõhõkỹmy rotỹỹnykre. Ibutumy ibinamy kai atyre‑ò kedesekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesuisi ikonana tahe rarybere: —Jerusalẽ hãwã mahãdu, kaiboho heka terubunytenyte Deuxu rybemy rybedu mahãdu. Jiarỹ heka aramykemy adi rewisỹnyreri wariòre wesemy tahe waderarenyre kaiboho. Iwese hãnieõ iriòre ridyre wese idewo‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aheto heka ixisohojilemy rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kaheka ararybekre adeereny: —Wamy heka bobiõtyhy ixityre. Kai heka Deuxu deòdỹỹna bidykreule wamy bobikre. Iu rarybereu, Deuxu deysanamy, wamy bobikre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iu Jesuisi ròhònyreu dohodỹỹna‑ribi, ierydỹỹna mahãdu tamy rarybere dohodỹỹna heto itxeremy ròikemy, eleri‑ò wahe. Tai tahe Jesuisi dirawyònyde: ");
INSERT INTO kpjNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","—Inatyhy rare, awi heka rare. Urile tahe kidiixãwididỹỹnykre heka. Timy heka manaõ wityre‑ki roiõhyykre. Ibutumy bede‑ò idi rehukre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iribi tahe Jesuisi rehemynyre Oliveira hãwãlò‑ò heka ronyre. Tai tahe erydỹỹna mahãdu tii ritỹỹraxinyre iny sõwe‑ribi: —Tiubohe ibutumy kedeixixãwididỹỹnykre. Tiuboho ibutumy bede konanadỹỹnamy reakre. Timybohe rikieryrenykre kai bedehemynyke aõma bede ibutumy rexihukre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tahe Jesuisi tamy rarybere: —Uritere inyõ aitxenadỹỹõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sõwemyhe iny itxenadỹỹnamy rỹirakre. Jiarỹ Kristu rare, Deuxu deòdỹỹna heka jiarỹ rare, myheka adee kanarybekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kaiboho heka boholamy mabekre iny aõbina ròhònymyhỹkre: boholamahãkre. Ihãre tahe iny rarybekre aõma: —Karibi heka aõbina urihimyò ròhònykre. Myhe rarybemahãkre. Ihãrele tahe kòdòòseõkre aõma ikonana urihimyò. Ibutumy heka kia wesemy relekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aõma kia wesemy heka bede roimyhỹ rarekre aõbo iny witxira witxira heka ibutumy iòlòna heka riteranymyhỹkre. Aõbinamy. Tai heka raaõbinanymy rỹirakre. Aõma rama ijara reakre. Bede ibutumy ramytatakre hãwãõ‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kia heka iwese hãwyy uladu dese wesemy robumyhỹre wese tukre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Adeereny heka aõhõkỹmydỹỹnana tiiboho riwahinykre aõma wani òraru‑ki wahe. Ijõ kaibohoõ heka ararubunyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sõwemy heka iny riatymyhỹkre wary‑ribi heka riatymy ririmyhỹkre. Wii rityhenymyhỹkre. Widee rakyarananymyhỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Rybebina rybeduõ heka sõwemy kedehemynykre tahe kia heka sõwemy iny riitxenanymyhỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Iu heka òraru nihikỹ iu ròhònykremy roimyhỹre. Sõwemy heka luuna‑di rỹiramyhỹ katahe wiji ixãwikre heka ihomy aõkõ relekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kia idi hyy rỹirakre ikonana‑ò. Tii mahãdu tahe tarasanamy reakremy rỹira. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ibutumyhe kia iny‑ò rybe tỹnydỹỹnamy reakremy rỹira, Deuxu Rybewihikỹ Tỹmyra wahe. Ibutu iny witxira witxira heka roholakre rybe wihikỹ‑ò. Kia rahudi hikỹle heka taheka kedehemynykre heka ikonana. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Aõbinahakỹ tyhybohe ibinatyhy rỹikre. Tii heka rỹikre heka aõma Deuxu ubetyre‑ki, Deuxu isỹ‑ki, kiaweselemy heka rỹikre. Bieryke aõbo kia rare. Bieryke aõbo kia rare Danieli heka Deuxu rybeduõ ihetxiu kiamy heka rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","—Judeia mahãdu bede‑ribi tahe kia bihenybenyke. Ibutumy heka bòibenykre hãwãlò bede‑ò biòturònykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","—Kia bededỹỹnanau heka tiu aõ bimyõtyhy ahetowo‑ribi. Tiiemy heka ròhònyhykyle rakre aõwesele wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Iu bedero raaõmysỹdỹỹkreu heka tiu kòdòòseõtyhy tatyky itxemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tule aõma hãwyy bòtòmy rỹira kia bedeu aõhõkỹmy rotỹỹnykremy rỹira. Kia tohouã‑di ratxireri tahe tamy isirakre heka itybiedỹỹ idi rakeò heka isirakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bedejutytykõkemy heka bexitòenyke ahena mahenykeu. Tule sabado txu aõkõkemy bexitòenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tiu heka aõhõkỹmy dỹỹnanamy iny rotỹỹnyõhyymyhỹre kaa aõhõkỹmy dỹỹnana nihikỹmy. Tule tiu tuu robiõhyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kia Deuxu irokorehemykre wana heka ibutumy iny ituekre. Kaa urihimyòlekre wana tahe kai Deuxu hõrõ mahãdule tuukre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Aõma Mesia heka kowa‑ò rehemynyra, Deuxu deòdỹỹna wahe. Ihãre tahe kai heka inyõ adee rarybekeki tahe tetyhynyõhyyte heka. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kia iu kedehemynykreu tahe aõ Kristu tyhy aõkõ heka rarekre. Aõma rybedu itxenadỹỹdu heka tule aõna aõna wiwihikỹ riwinykre. Aõma ityhydỹỹdu dori riitxenanykemy idi riwisỹnykre: ");
INSERT INTO kpjNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Boholake, juhuu dori adee relyyreri ibutumy aõhebo rotỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Aõma arateòwarinyre dori tuu. Kia Mesia, Deuxu Deòdỹỹna heka ròòsereri. Beteheke bederahy‑ki, tule hetowo‑ki. Iu tahe timy heka tamy itxeremy raõtyhy inatyhy aõkõreki. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Iu jiarỹ Deuxu Riòre Hãbutyhyhykỹ arehemynykreu ibutumy heka rierykre loosòna delaana wesele heka wadehemynyna heka rarekre biu ibutumy ritỹxinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Iwese aõ rubu roimyhỹre, rara heka tamy rabutumyhỹre. Kaiboho rierykre iu rehemynykreu. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Iu kia bede dỹỹnanamy reakreu tahe txulyby heka kòdòhònykre. Ahãdu tule rybynykre. Taina tule ixewesehekỹle kanakre. Ibutumy ramytatakre biu‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Iule tahe kia wadehemynynamy iny robikre. Sõwemy heka hinana ibrunana bede bedemy rỹirakre. Ibutumy heka iny robikre wadehemynynamy biuwetyky‑ki, jiarỹ dori, Deuxu Riòre, Hãbutyhyhykỹ rare. Loosòna ruruna sõwekreu, tahe arehemynykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tule wajuròna‑di, ỹju aditeònykre iu, ajuròna wodỹỹhỹkỹ‑di. Tahe ibutumy wahõrõ mahãdu he ixidee aributunykre bede bede‑ribi, ibutu rehetyhy‑ribi wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesuisi tule relyyre: —Ijyyõmy heka ako arelyykre. Kai heka ibede erynamy bimykre. Iu kia figueira òwòru hãbu wiji tybiehekỹ. Kia aõma iruru tỹmyra rurunymyhỹré. Tule aõma txirubò tỹmyra ròhònykre. Tiu tahe bierykre. Kai iòhòra bohe wyra. Myhe tamy besekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iwesetyhyle taheka kai heka bierykre. Aõma wadehemynyna ròhòny relekre wahe aòbitikre wadehemynyna iu, aõhõkỹmydỹỹnana wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tiu kia bededỹỹnanaule heka bedekõnyna rexihukre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Biu heka bede‑wana ituekre warybe tahe aõu aõu heka rỹihyymy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Inyõ heka rieryõhyymyhỹre. Tiubo txuu ruu kai konany rỹimyhỹre wahe Ỹju dori tiu rieryõhyymyhỹre. Aõma, jiarỹ Deuxu Riòre dori rieryõre. Aõma Waha Deuxule tahe rierymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noe bededỹỹnana wesemy heka rỹimyhỹkre iny risinykre kia bedeu. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ibutumy heka worana bedehesi rỹikre kiau. Lisisò tahe rỹikre. Herina lisina aõma hãwyymy herina. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tahe Noe bededỹỹnana wesemy heka reakre. Iu heka beòra rariare. Tahe rityyhynyõhyyre tiiboho. Tahe heka raòwònyre rariare ibutumy ituere. Iwesele tii heka rarekre heka, wadehemynyna Deuxu Riòre Hãbutyhyhykỹ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Inatxi hãbu heka oworu‑ki raaõmysỹdỹỹkre. Ijõ heka rakre dynamy reakre. Ijõ tahe rarikre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tule inatxi hãwyy heka raaõmysỹdỹỹkre heto‑ki ratxikre mai risyrenykre. Ijõ heka dynamy reakre ijõ heka rarikre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tai heka iny rexiywinymy rỹimyhỹkemy rybe roimyhỹre awedureny kanakreki. Tiubo rehemynykre, teeryõte. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aõma hãbuõ kanakeki heka tiu aõma hãbuõ itxeredumy ronykeki heka, tiu hãbuõ iribi rawasinyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bexiywinymy heka wadehemynyna biijemy bonyke, jiarỹ Deuxu Riòre Hãbutyhyhykỹ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ijõ Jesuisi relyyre: —Inyõ tadinodu deòdutyhymy ratxikeki, tii aõmysỹdỹỹna riwinyhyy ronymyhỹke tamy. Iheto riywinyhyyke. Teòdu mahãdu txuõ txuõlemy riywinymahãke. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kia riwinykeki, deysamy rarekre teòdu rehemynykreu. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Inatyhymy ararybekre: —Kia deòdu tadinodu aõmydỹỹnana ibutumy idi riywinykre, riyrubunykre. Tii ibutu wedu rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Ibinamy tahe tii rõhõtinykeki, kiawesemy riwinykre: Deòdumy raòhòtemyhỹ, lisilemy ronymyhỹ, riroximyhỹ momodu mahãdu‑wana riõmyhỹ. Tii ixidee rarybekre: —Wawedu kedehemynyõtyhy, aõtxile ariwinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Iu rehemynyõkremy rõhõtinyreu, iwedu kiaule rehemynykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tai tahe raòhòtebinakre. Heòty bede‑ò riteònykre, Iwese itxena mahãdu tii riteònykre wese. Kia‑ò rahinykre, robukre, txuraruti rikyikyinymy aõhõkỹmy dỹỹnana òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesuisi ijõ relyyre: —Kia txu heka Deuxu Iòlòna ka ijyy wesemy rarekre. Debòwiò ijadòma heka hãbumy herina riraòmyhỹrenyre. Iny sohoji sohoji heka toosòna riwyre iximynamyna. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Iruyrele tahe tõhõti reare aõma adỹỹ‑di ritỹxinykemy. Ihony tahe tõhõti rosare iruyre wasỹ, ijõ tule ihyna‑ki riwykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Weryrybò rehemynyõre, tai tahe ijadòma mahãdu ele rihynymy rỹimyhỹ tehemynyna riiraòmyhỹrenyre. Iny sohoji sohoji heka toosòna riwyre iximynamyna. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tai tahe rarybera: —Tỹmyra mahãdu‑ò wahe rehemynyreri. Birybenybenyke ruwetya. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tai tahe ijadòma mahãdu he rituranymy rỹimyhỹre. Toosò itỹnytyhymy rookemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kia ijõ tahe tõhõti rosare mahãdu tahe uritere riijere. Itoodỹỹmy idi riwisỹnymyhỹ. Aõma widee he rexitòenyre: —Urihimykò inihe wahõrõ‑kò biditxiwike karihukòtekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tai tahe kialemy risỹnyre: —Anokõre wadehunale dokuri rỹire. Bikòryke tahe ijõ itxe tahe. Maa. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Idi tahe ròireny iõbradỹỹmy. Tai titxi tai rohonymyhỹreò. Iòrysymy iõbradỹỹmy ròirenyra rookile tahe dehemynyde kia tỹmyra mahãdu wahe. Tahe rironyrenyre ibutumy riroxikemy. Riratòbònyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tai tahe kia iruyre ijadòma iõbradỹỹmy rare tahe dehemynyde: —Wahĩ, itxòtòbòna wadeke bidirakynybedenyke! ");
INSERT INTO kpjNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tai tahe kialemy rirawyònyre: —Jiarỹ umyreny reeryõre. Kie riki ijyy. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tahe Jesuisi rarybere: —Tai kaiboho bexiywinymy ahãbenyke wadehemynyna biijebeny. Teerytenykõte dori tiubo adòòsekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tii ijõ rarybere: —Ijõ ijyymy adeereny arabedeerynykre timybo Deuxu Iòlòna raremy. Inyõ heka rakemy ratximyhỹre ijõ bede‑ò ratỹinykemy. Tii tahe taaõmydỹỹnana ririre teòdu mahãdu‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tanieru tahe tamy riwahinyre timykibo isiraõmy nieru ritamyhỹre myheka tamy riwahinyre. Ijõ‑ò 5000 riwahinyre. Ijõ‑ò 2000 riwahinyre. Ijõ‑ò 1000 riwahinyre. Idi tahe tii rare tabede tỹinamy. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kia iruyre ritara heka aõna aõna riõbranymyhỹre. Diwymyhỹre tasỹ idi rohonyrerimy ihỹre. Tai wylemy heka inieru rabuture. Ijõ ixityre iruyremy ritxienyre iratyretyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kia ijõ inatximy tamy riwahinyre tasỹ tulere aõwesele raaõmysỹdỹỹre ta ròtare tule ijõ inatximy ixityre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kia sohojimy tamy riwahinyre tahe urile riyrubunyre inieru hãloole riare tamy tahe riyrubunykemy heka riare. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Sõwemy rabededỹỹnana‑ribi tahe iwedureny dehemynyde. Tahe tamyreny rarariòwyre takõtareny riòbitinykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Iruyre riwyre heka debòwiò diwyde: —Beteheiny wawedu ijõ iruyre anieru tyre rebutunyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tahe tawedu sõwemy riwowydynyre iaõmysỹdỹỹna wiwihikỹmy ròhònyraki wahe. Kiamy heka tamy rarybere: —Òbitimy idi taaõmysỹdỹỹteki heka. Sõwemy heka adee ariwahinykre riywinykemy. Aõwaxinyhe bitelenykre aõmysỹdỹỹna. Kai heka wawana beysanihikỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Idi tahe kia inatximy ròtaré sỹ dehemynyde: —Beteheke, inatxi tasỹ inaubiòwa ixityre adee rewinyra. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tahe iwedu rarybere: —Awityhymyhe taaõmysỹdỹỹta! Kai heka deòdu wihikỹ tate. Kai ibutedile sõwemy tewinyte tahe sõwemy ixityre adee ariwahinykre riwahinykemy. Kai heka wawana beysanihikỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kia sohojimy tamy riwahinyre tahe rarybemyhe retximyhỹ: —Kai heka hãbu nieru tarasaery heka tate. Aõ taaõmysỹdỹỹteri‑ribi aõkõ heka nieru tetamahãte. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tai heka jiarỹ raberumahã alau watxireri. Tai heka rewore iny lau. Tahe tii sohojidile ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Iwedu rarybere: —Kai heka eoruxerere, awi aõkõ heka tate! Inyõ tehuòtekõta heka idi urihimyò ityre ròtakelemy wahe. Kai tiwaeryte wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aõherekibo banco‑ki aõkõ tetidite. Kia huòteòwy wanieru‑ribi ritarerimy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bitabohe kia nieru‑di atxitere, tahe kia debòwiò ritaraò wahe biwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kia òbitimy raaõmysỹdỹỹra heka sõwetyhymy ròtakre. Kia òbitimy raaõmysỹdỹỹõmyhỹre kia heka ròõnodỹỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kia deòdu bimybenyke. Tii dorihe ibinatyhyre inihe bede luruhukỹ‑ò idi behubenykre. Tai heka tii aõhõkỹmy rotỹỹnykre rahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesuisi tahe ikonana rarybere: —Iu jiarỹ, Deuxu Riòre Hãbutyhyhykỹ, arehemynykreu heka Waiòlònary‑ò aronykre. Arehemynykre waỹju mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ibutumy heka bede iny mahãdu wako‑ki ributunykre. Iwese budoeni itxeredu heka tabudoeni, budòe‑wana wiribi rihitxinymyhỹre wese heka bede iny mahãdu wiribi arihitxinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wabudoeni heka warurunawe‑ribi arisỹnykre. Budòe tahe wahywe‑ribi arihitxinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Idi tahe waruruna ludu‑ò ararybere: —Manake hewa, beysabenyke. Waha Iòlòna‑ò rokonykre. Myheka tamy ararybekre. Juhuu bedeu ihetxiu heka ywimy adireny kia rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Rama tahe riwasanyreu rỹsỹna wadee tewahinytenyte. Iu bemy rarureu, wadee tewahinytenyte. Jiarỹ heka tori rare asỹ‑ò tiwadytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jiarỹ heka watykyhoho aõkõu, kaibohole wadee tewahinytenyte. Binamy rỹimy rarewãhã, waroramy tadòitenyte ròtenawo‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tai tahe òbiti mahãdu rarybekre: —Wanyrỹ, tiu taheka ramamy heka wadeereny teate —Adee rewahinyrenyre? Tiubo heka bemy tarumy tatemahã adee rewahinyrenyre? ");
INSERT INTO kpjNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tiubo heka kai torimy tatemahã idi wahetoreny‑ò aradyrenyre. Tiubo atykyõmy tatemahã‑di, tyky adee rewahinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tiubo ròtena‑ki tỹimy tatemahã‑ò ada webinadumy tatemahã‑ò, aroramy ròirenyre. Wanohõti atxi reaõhyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tai Jesuisi rarybere: —Jiarỹ, Iòlò, tamy ararybekre: —Iu kaiboho waityhydỹỹdu seriòre mahãdureny‑ò waòraru‑ki tewinymy toitemahãu, wadeele tuu tewinytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Idi tahe kia wahywenawe‑ribi ludu tamy ararybekre: —Boibenyke karibi kaiboho heka abinarenyre heòty bede‑ò ihyymy boibenykre ixi‑di ariteònykre. Diabo tatyytybybinasỹ‑ò idi boibenykre. Deuxu isỹ tamy riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tiu rama riwasareu rỹsỹna kaiboho wadee tewahinytenyõhyyta. Iu bemy rarureu heka ijõ wadee tewahinytenyõhyyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Torimy rarewahãu, tiu tiwatobinytenyõhyyte. Tykyõ wadee tewahinytenyõhyyte. Binamy rãimy rarewãhã ròtenawo‑ki wororana webinadumy tahe tòiõhyyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tai tahe kiamy rarybekre: —Wanyrỹ, tiubohe tuu rewinyrenykõre. Wanohõti heka reaõhyymyhỹre aramamy rubuna‑txi, abemy rubuna‑txi, torimy tatemahãu, atyykõmy tatemahãu, ròtenawo‑ki webinadumy tatemahãu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tahe jiarỹ Iòlò tamy ararybekre: —Kaiboho heka waityhydỹỹdu seriòreõ tewiòhenanyõmahãtenyte tai heka tiwawiòhenanytenyõte. ");
INSERT INTO kpjNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tahe Jesuisi ikonanamy rarybere: —Tai tahe tii tiuhyymy rakre heòty bede‑ò, aõhõkỹmydỹỹnana‑ò. Òbiti mahãdu heka umytuedeõna‑ò rakre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kia taijyy rahudi tahe Jesuisi taerymahãdu‑ò rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Ixityre inatxi txu‑di tasỹ aõma Pascoa worana bedehesimy rỹikre. Kaiboho tahe kia teerytenyte. Iu iny riwatyhenykre Deuxu Riòre Hãbu wahe. Irahu‑di tahe itxeònihikỹ‑ò riwatamadỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tahe aõwesele heka xiwena wahidỹỹdu wedu mahãdu ributunyre heka judeu wedu mahãdu‑wana wahe. Kaifa heto wii rotyre. Xiwena wahidỹỹdu mahãdu wedu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Wiwana heka raryberenyre: —Timybohe Jesuisi aõhebo rikisỹnyrenykre aõma teburemy ijiranakõnahakỹle. Timybo rikisiraõnyrenykre, rikimyrenykre, rikirubunyrenykre. Urile iny tuu rierykõre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pascoa worana bedehesi rỹireu tahe aõkõlemy idi rỹire. Kia worana bedehesiko‑ki iny raaõbinanykeki dori ibutuhukỹlemy heka raaõbinanyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesuisi heka rare Betỹnia hãwã‑ò hãbu tykybinaõ‑wana heka isỹ‑ò rare, Simaõ heto‑ò wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iu iheto‑ki riroximyhỹreu tahe hãwyyõ tamy rare aderòna lỹnyrehekỹõ‑di manaurahyna‑ki. Tai tahe Jesuisi tyre ritxiwire, iratityre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ierydỹỹna mahãdu heka urihimyò heka rebure riòre iòraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iòwy nihikỹtyhyre dorihe. Tai heka tanieru uriterehekỹle rahuraki heka tai rawobinamy. Idi rohonykewile heka rare aõma iòwy tahe iny aõkõ mahãdu‑ò riwahinykewihikỹle tii rõhõtinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tahe Jesuisi rierytyhymy aõmybo tuu raryberenyrerimy: —Aõherekibo kaiboho ibinamy tarybetenyteri hãwyy‑ò. Aõwidỹỹnana wihikỹ wadee riwinyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aõma kaiboho heka urimynodu mahãdu‑wana ihyymy boibekre. Ibutulemy awanareny jiarỹ watxiwãhãde. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tii heka wahãloodỹỹna riwaywinyra aderòna watyre ritxiwireu. Kia tahe wadee riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Boholake, iny itxi tõhõti reahyy rỹirakre iòraru‑ki. Rybewihikỹ Tỹmyramy ritỹnydỹỹmyhỹkre heka rierymyhỹkre bede bedemy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iribi tahe Judasi Isariò, tii waò inatxi reuròõ rare, tii heka ròhònyre ierydỹỹna mahãduy‑ribi. Tahe rare xiwena wahidỹỹdu mahãdu wedu‑ò. Tahe tamy rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Adeereny Jesuisi ariwahikre wana heka tiwesebo biwaòwynybenykre? Kiamy tahe 30 prata womati nieru myhe tamy riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Judasi kia ribile rarunymy raremyhỹ dohodỹỹnaõmy Jesuisi tamy riwahinykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pascoa worana bedehesi rỹireule rexidelenyre, Paõ iuridỹỹkõ, kia txu rỹimyhỹ wahe. Jesuisi erydỹỹna mahãdu tai ritỹỹraxinyre: —Titxiwexe rikirỹsỹkre Pascoa worana bedehesi jiarỹboho dori ariywinyrenykemy? ");
INSERT INTO kpjNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tahe Jesuisi rirawyònyre: —Hãbuõ hãwãhãkỹ‑ki ratximyhỹre tii riwaeryre. Tahe tamy marybekre: —Wawedu kỹny rarybereri aõma aheto‑ki heka Pascoa worana bedehesina rirỹsỹkremy taerydỹỹna mahãdu‑wana. Ibededỹỹna dori iòhòre riki. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tai tahe taerydỹỹna mahãdu kia riwinyre idi kowa worana bedehesi rỹsỹna riywinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bedesòmy tahe tai riroximy rorukumyhỹreny, taerydỹỹna waò inatxi reurò mahãdu‑wana wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Aõma inyõ heka riwatyhenykremy ratximyhỹre. Jesuisi heka tuu rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","—Mowexe tii rarekre. Tiiboho rabedewomy roire, tai tahe widee rarybere: —Jiarỹ kõaõboka. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tahe Jesuisi rarybere: —Kia wawana pratoro tebò rearerile taheka tiikre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iwese Deuxu Tyyriti‑ki Rybe roire wese heka arurukremy jiarỹ Deuxu Riòre Hãbutyhyhykỹ watxiwãhãre. Kia hãbu riwatyhenykre tahe tamy heka ibinatyhykre. Ratybienykõre wana inihe awityhyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tai tahe Judasi ityhedỹỹdu rarybere: —Erydỹỹdu, jiarỹ aõbohe rare? Tahe Jesuisi tamy rarybere: —Kaityhy wahe tate. Kaile tarybeta. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tai tahe Jesuisi orotxu sohojiõ rimyre ibutumy riroxireu, tahe riyreyrenymyhỹre tahe inysohoji sohoji‑ò riwahinyre. Tai tahe tamy Jesuisi rarybere: —Kia biybenyke heka. Waumy wese heka kia ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Idi vĩĩ monahynaõ rimymy rexitòenyre Deuxu‑ò. Idi tahe tamy riwahinyre iribi sohoji sohoji riõrenykemy. —Biõrenyke kaa dori wahãlubu wesemy ratxireri. Tai sõwemy iny biu‑ò rahenykre Deuxu dee. Ibutumy òraruna ixãwididỹỹmy heka tuu ròhònyra. Wahãlubu heka Deuxu, iny‑wana wii riwoàxinykre rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tahe boholake warybe‑ò. Awanareny heka ixityre vĩĩ monamy ariõõtyhy. Kia Waha Iòlòna‑ò dehemynynahykyle tahe awanareny ixyby tuu ariõkre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Idi tahe wiuõ rawiunyrenyre idi tahe Oliveira hãwãlò‑ò ròirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesuisi tamyreny rarybere: —Wijiru heka ibutumy kaiboho biwaribenykre. Tyyriti‑ki heka roire kiawesemy: Budoeni‑di itxeredu rirubunykre. Ibutumy budoeni raubỹtỹkre bede bedemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","—Waixixana kỹnyikreu tahe Kalileia bede‑ki awanareny aratxikre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro tahe rarybere: —Ibutumy ararirenykre wana tahe jiarỹ aõkõre. Ararirenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tai Jesuisi heka Pedro‑ò rarybere: —Kai heka hãnie dele robukõdile biwatxiõ‑ribi bexihukre, inataõmy wahe. Tuu wijiru rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro dirawyònyde: —Aõkõre wa, arurukre heka tahe urile aratxiõnyõtyhy. Tule ibutumy ijõ ierydỹỹna tule Pedro wesele rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tahe Jesuisi ridyrenyre bederaty oworuõ‑ò, aõma Kesemani ninadu‑ò ridyre: —Kakile bonykre arakre dori ixitòedỹỹmy kowa‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tahe Jesuisi heka Pedro ridyre ixi‑wana. Tule Zebedeu riòre wiwana ridyrenyre. Tahe Jesuisi rabedeòtiidỹỹre aõhõkỹmy rotỹỹnyre bedeòtiidỹỹ òrarukile. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tii tahe tamy rarybere: —Kaki wawanale atxibekre. Watyytyby heka tỹxihikỹlemy bedeòtiidỹỹ‑di ratxireri. Waki bexiebekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Urile tahe tako‑ò rariareu tahe resere bede‑ò. Jesuisi tahe tyby‑ò rarybere: —Waha, rubu mona waribi bitake adeewikeki. Aõkõkeki tahe ariõkre, arurukre adeewilemy aõhebo arotỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Idi tahe dòòsede kia ierydỹỹna inataõ tai rõrõmyhỹò heka ixyby dòòsemy nade. Jesuisi rarybere: —Pedro! Kai heka timy sohoji horamy adi bede rỹiõtyhy wawana. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bexixaruhyy atxibeke bexitòenymy. Aõkõkeki tahe òraruna kanamykre. Kai heka òbitimy matxikemy tahõtinymahãte. Aumy tahe ibinare heka arurukõre wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ixityre rare rexitòenykemy. Tahe Jesuisi rarybere: —Waha, adeewinale ariwinykre. Aõhõkỹmydỹỹnana monamy heka ariõkre. Kia mona waribi bitaõkeki ihãrele heka arurukre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tai dòòsede tai rõrõmyhỹrenyòle heka nade. Tiiboho ixixamy rỹiõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tahe ròòsere ixybyle ikonanamy. Iweselemy rexitòenyre tyby‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Idi tahe dòòsede taerydỹỹna mahãdu‑ò rarybere: —Bexielehynybeny. Watyhedỹỹdu naderi. Rexihumyhe rare. Hãbubina mahãdu rehemynyre. Jiarỹ Deuxu Riòre Hãbutyhyhykỹ, wahe. Bexixabeny, rakakre watyhedỹỹdu dori rehemynyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tahe Judasi dehemynyde waòinatxi reuròõ wahe. Jesuisi rarybereu, tii nade sõwemy hãbu‑di mayrehe‑di, òhòte‑di tõnori‑di widotyde. Judeu mahãdu wedu tahe iteòdỹỹdure xiwena wahidỹỹdu wedu wana wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Juhuu Judasi tamyreny bede riywinyre. Kamy rexirybenymy: —Iòsỹny‑ò aruwokrele heka tiikre. Tiile bimybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tahe Judasi rarybere: —Rareri, Wawedu. Iòsỹny‑ò ruwore. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tahe Jesuisi rarybere Judasi‑ò: —Iò, aõwaxiny aõbo biwinykre iwidỹỹmy tateri. Tahe Jesuisi imahãdu rimyre. Ritaataare. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tahe Jesuisi mahãduõ mayrehe‑di rimymy resere. Tai hãbuõ‑ò reare. Tai tahe tõhõtile rikòròmy idi reare, xiwena wahidỹỹdu wedu deòduõ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tahe Jesuisi tamy rarybere. Aõkõre amayrehe birutyke irasirahanawomy. Kia dori inyõ maydese rimymy resekre heka tule rurukre maydeselemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Karibi ixitarasamy arurukeki dori wahaòle ararybekre. Tai tahe waha sõwemy ỹju kiditeònyke, 12 aõbinadu ijoi mahãdu wahe. Kia teeryõtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ihãrele tahe ibutumy tuu bededỹỹnana relekre iwese ritidỹỹna‑ki roimyhỹre wese. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tahe Jesuisi rỹỹraxire tamyreny: —Aõbo jiarỹ raremy wadi tahõtinytenyteri. Wasidu aõbo. Kai dori waòrysymy tehemynyte maydese‑di, tõnori‑di. Aõherekibo wahe. Jiarỹ heka arabedeerynyrenyre txuõ txuõlemy wahe Deuxu dohodỹỹna heto‑ki. Aõherekibo taile tiwamytenykõte kowa watxiwãhãure. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kia ibutumy Deuxu Ritidỹỹna‑ki roimyhỹre. Tai tahe tuu bededỹỹnana relekre iwese Deuxu rybedu mahãdu rarybere. Ibutumy aõna aõnamy rotỹỹnymy raremyhỹ. Tai tahe taryberahu‑di. Ibutumy iery mahãdu iribi tahe robỹtỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tiiboho heka Jesuisi ridyrenyre Kaifa heto‑ò, xiwena wahidỹỹdu wedu wahe. Tai ibutumy judeu mahãdu wedu ributunyre bede ywina erydu mahãdu tule wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro irehetyty‑ribi riheludunyre. Iheto ube‑ki tahe ronyre yrubu dỹỹdu‑wana. Tahe rehere aõhebo rotỹỹnykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Xiwena dinodu mahãdu tahe ributunyre Jesuisimy raruikremy heka riijemy. Aõma rirubunykre òbirele heka tuu rarybemyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tahe inyõ‑ki heka rahaõhyyre turybedu wahe. Iny sõwemy tahe relyyre. Ihãrele rirubunyõhyyre. Iroona‑ribi tahe inatxi hãbu dehemynyde. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tai tahe kiamyhe tuu relyyre: —Aõma Jesuisi rarybere: —Aõwesele heka Deuxu dohodỹỹna heto ariatymy idi areake. Inataõ txudi tasỹ ixityre aditamadỹỹke, ibutumy adiwinyke. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tai tahe xiwena dinodu heka Jesuisi‑ò ryyraxire: —Aõbo marybekre kia umy ijyy rohonyreriki? ");
INSERT INTO kpjNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesuisi tahe rybeõlemy ronyre roholare. Ixityre tamy rỹỹraxire: —Kai heka inatyhy tyhymy Deuxu Riòremy kai atximahãte. Mesia aõbohe kai tate? Deuxu riwaeryre inatyhymy rarybereri. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesuisi dirawyònyde tamy: —Kaile kia tarybete. Ibutumy iny‑ò ararybekre: —Kaiboho ibutumy bobibenykre Deuxu Riòre Hãbutyhyhykỹmy, jiarỹle wahe. Tii heka Deuxu rurunawe‑ribi heka ronykre. Iribi tahe kanakre biuwetyky‑ki. Jiarỹle wahe tiire. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tai tahe xiwena dinodu tatyky riykare. Reburere kie: —Aõhere tahaka. Deuxumy heka ibinatyhylemy tarybemahãte. Ijõ iny‑ò aroholaõkre, rexihura! ");
INSERT INTO kpjNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ibutumy kaiboho irybe‑ò taholatenyteri, inatyhy? Aõbo rikiwinykre tii ibinatyhyre dori, rikirubunyrenykre tahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tahe iòsỹny‑ò rarybexinyre. Rihetenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tamy ihetedỹỹdu rarybere: —Marybeke Kristu, mobo arahetenyra inihe. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro tahe ube‑ki ronymyhỹ. Tahe ijadòma heka deòduõ tamy rehemynyre: —Kai anõbo Jesuisi Kalileia ludu‑wana atximahã. Kumymy rabire. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Iny ibutuko Pedro rarybere: —Aõkõre, aõmybo arybe reeryõhykyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tai tahe rare ijò‑ò. Ijõ ijadòma deòduõ rarybere kamahãduko: —Inatyhymy heka tiki Jesuisi Nazareludu mahãduno tiki rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ixityrele Pedro ritxiõnyre: —Reerykõre wahe hãbu. Tiu heka rabiõwãhãre. Inatyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Idi hãbuõ heka narybede tamy: —Inatyhy rare. Kakỹny irybe weselemy tarybeteri, Kalileia rybe wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tahe Pedro rarybere: —Jiarỹ reerykõreri, tuu heka rabiõwãhãre. Deuxu riwaeryre inatyhymy rarybereri. Iule taheka hãnie hãbu robumy reare. ");
INSERT INTO kpjNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tahe Pedro tõhõti itxi reare. Jesuisi rarybere weselemy heka tii riwinyra. Ritxiõnyre. Tai tahe Pedro ròhònymy reare heka rahinyhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ijõ biurasò ruidile tahe rỹire. Xiwena wahidỹỹdu wedu ributunyre judeu mahãdu wedu‑wana. Timywexe aõhe rikisỹnyrenykre. Rikirubunyrenykemy heka idi watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Roma dinodu‑ò òsana rikidyrenykre. Tahe tiiboho Jesuisi ritaataare idi ridyrenyre tamy, Pilato‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judasi heka rieryre. Tai tahe tii rabedewonihikỹre rityhenyreki wahe. Tai tahe raraykynyre tawo‑ò raòhòrere. Tahe nieru òkesedỹỹmy idi rõhõtinyre. Tahe nieru diwyde, 30 prata womati nieru tahe riòkesedỹỹnykremy judeu wedu mahãdu‑ò, Xiwena wahidỹỹdu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tahe Judasi rarybere: —Ixãwirahe, jiarỹ raòrarunyra hãbu òbitityhymy ratximyhỹrele retyhenyre heka. Tahe judeu mahãdu dinodu rarybere: —Jiarỹboho, kia aõ aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tahe Judasi nieru‑di bedetyrele rihure. Tahe ròhònyre iribi. Tahe rare. Rerotihikỹ‑di rexibòtòtaare. Rexirubunyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tai tahe xiwena wahidỹỹdu wedu riwyre nieru bede‑ribi: —Aõwexe kanieru rikiwinyrenykre? Dohodỹỹna hetowo‑ò rikirutyrenyke heka aõkõre. Aõma dori rare rubuòwymy iwahidỹỹ heka rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Urile suõle rikiwyrenykre idi. Tai tamy wabede rikiwinyrenykre. Aõma tori kaki rurukreu tahe rikitoonyrenykre tamyle wahe. Tai tahe tiiboho riwyrenyre aõma butxi widỹỹna subede heka riwinyrenyre. Kia heka inire suni wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kia bedero tahe rininire aõma Hãlubu Bederomy heka rininire. Wiji tule ini rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Iwese Jeremia tyyriti‑ki roire wesele heka tii riwinyre: Tahe 30 —Womati nieruõ‑di heka bedero riwyre butxiwidỹỹdu‑ribi. Iwese kai riwateònyre wese. Kia iòwy rare judeu mahãdu‑ò tamy riwahinyre wahe. Txiõdỹỹna òwy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesuisi heka Pilato, bede dinodusỹ‑ki ratximyhỹ. Pilato tahe tamy rỹỹraxire: —Kai aõbo judeu mahãdu iòlò atxiteri? Jesuisi dirawyònyde: —Kai tuu tarybeta. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Xiwena wahidỹỹdu wedu heka tamy rarybere: —Jesuisi rirawyònyõhyyre. Judeu mahãdu wedu‑ò tule rirawyònyõre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato tahe tamy rarybere: —Kai aõbohe rybe‑ò taholate. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tule tamy Jesuisi dirawyònyõhyyde. Byy! Urile Pilato ribedeòtiidỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pascoa worana bedehesi bededỹỹnana tikiemy tuure. Ròtenawo‑ribi heka sohoji beòra beòrahyyle ixinamy inyõ rexideònymyhỹ, inysõwe rybe òraru‑ki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kia beòra tahe hãbu ibinatytyre ròtenawo‑ki rỹire. Baraba inire. Ibutumy iny tuu rieryre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aõma Pascoa worana bedehesi rỹireu ibutumy iny ributunyre. Tahe Pilato ritỹỹraxinyre: —Tibohe ixinamy ariteònykre Jesuisi Kristu aõbo ada Baraba aõbo? ");
INSERT INTO kpjNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tahe iny heka ibutumy urile Jesuisi Kristu luure heka. Tai tahe judeu dohodỹỹdu wedu mahãdu tahe aõkõ tamy waritimy rityhenyrenyre. Pilato kia rieryre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Iu tabede ywina dohodỹỹna‑ki Pilato rỹireu, ihãwyy tamy tyyriti riwahinyre. Kawese heka rarybere aõma: —Ixinamy Jesuisi bitekònykre. Anobinatytymybo dokuri rarasino txu wadi reakareri. Jikarỹ anohõkỹmy dỹkỹnana sõwemy ratỹkỹnyre Jesuisi kòraru‑ki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Iny sõwehekỹ‑ò heka xiwena wahidỹỹdu mahãdu wedu rarybere: —Kaiboho mararybebenyke: —Baraba ixinamy biteònykre. Tiiboho dirawyònyde: —Jesuisi birubunykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Iribi Pilato rarybere: —Tiwexe ixinamy ariteònykre? Tiiboho dirawyònyde: —Baraba biteònykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato tahe rỹỹraxire: —Aõhebo tahe arotỹỹnykre Jesuisi‑di, Kristu‑di? —Itxeò nihikỹ‑ki bitamadỹỹnykre. Birubunykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato tamy rỹỹraxire: —Aõbinahakỹ aõbo riwinyraki? Tai tahe ibutumy iny rirajuamy rỹimyhỹ: —Birubunyke kia bitamadỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato iny sõwe‑di aõ riwinyõhyyre aõbinatyhy òsana ròhònykremy idi rõhõtinyre, tai tahe inyõ rarybere: —Bee kidiwykremy baciaro‑ki. Tahe tebò risuhore iny sõwehekỹko‑ki. Tamy rarybere: —Jiarỹ kỹny waòraru‑ki aõkõ heka rurukre. Kaiboho heka irubudỹỹ erydumyhe boibekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tahe ibutumy iny rarybere: —Awire, inyboho heka irubudỹỹdu erydumy rokoirekre, tule wariòrereny òraru‑ki wahe ihãlubu rejuxunykre. Soldado ridyre itxeò nihikỹ‑ò ritamadỹỹnykremy rirubunykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tai tahe Pilato heka Baraba riteònyre ixinalemy. Iribi tahe Jesuisimy raòhòtere. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilato soldado mahãdu urile idi juhu risinyre, soldado tyamy ritidire. Pilato heto‑ò ridyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ityky iribi ritare tahe aõma tykysò‑di ritidire heka juhu rihetynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Iòdỹỹmy tahe idi ede lòrilòrihikỹ irati‑ò ridekremy. Òwòruõ tebò‑ò ritidire. Tai iko‑ò resere tatiowotimy. Raryberenyre: —Awire, kai judeu Iòlòtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ityre rarybexinyre. Òwòru rimyre tahe iratimy tuu raòhòtere. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Iribi ritarenyrenyre ihõrõ itykyle ixityre rirutyre ityre‑ki. Idi tahe ryò ròirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Iu ròhònyreu, hãbuõ Sireni bede luduõ‑wana witxi reare. Tamyhe rarybere Jesuisi itxeò riwykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tahe Kòkòta hãwãlò‑ò rehemynyre. Aõma, rubu ratityby wesemy heka rare. Tai tahe Kòkòtamy heka rininimyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tii vĩĩ riurinyre bee ihyra‑wana, idi tahe Jesuisi‑ò kia riwahinyre. Iurihi‑di teramy reare. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tahe itxeò nihikỹ‑ki ritamadỹỹnyre. Irahu‑di tahe ityy heka ritxuatxuarenyre wimy rarudeòsanyre tibo iwydydukemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Idi tahe retehemy rorukumyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Irati tyre‑ki tahe ritidỹỹnaõ roire: —Kia Heka Jesuisi Rare, judeu Iòlò Mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tule wasidu brebunahakỹ tii‑wana ritamadỹỹnyrenyre itxeò hòkỹ‑ki, ijõ iruru‑ribi, ijõ ihywe‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iny ibire‑di reamyhỹ idi risinymyhỹ kamy rexirybenymy: ");
INSERT INTO kpjNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Kai inihe bexitake, kai Deuxu Riòre tateki. Bodobeheke itxeò nihikỹ‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kai heka arurudiremy iximy tarybemahãte. Dohodỹỹna biatykemy heka iximy tarybete tahe inataõtxu‑di heka biwinykemy tarybeta. Tule xiwena wahidỹỹdu wedu mahãdu idi risinyre. Tii tahe rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Tii heka iny iwitxira witxira aõbina bina‑ribi ritamyhỹre ihãre tahe taaõbina bina‑ribi rexitaõtyhy. Tii heka aõ judeu mahãdu iòlò aõkõ rare. Myheka tuu rarybemyhỹ. Kia itxeòhòkỹ‑ribi kedexiberesedỹỹnykekile tahe rikityhynyrenykre inatyhymy. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tii heka iximy rarybemyhỹre Deuxu Riòre raremy, Deuxu rityhynymyhỹremy. Reketeherenykre inihe aõbo Deuxu riwiòhenanykremy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wasidu mahãdu kia itxeò nihikỹ rỹire iwesele heka tamy rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Txutyeu tahe bede luruhukỹ bede reare, txioro tirehehekỹule bede kamy reare. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kiaule tahe bede ratỹnyre Jesuisi iu ryryre: —Eli Eli Lema Sabatani. Kiamyhe rarybere: —WaDeuxu, WaDeuxu, aõherekibo waribi õhõti rosare? ");
INSERT INTO kpjNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tai tahe iny sõwe mahãdu irybe‑ò doholade. Ijõ kiamy narybede: —Eliasi‑ò hòwa ryryreri. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kia ele elemy riwinyre noseõ. Idi tahe vĩĩõ rirymy tamy idi riteònyre. Teòrehemy riwinyre bemy rimonykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ijõhe raryberenyre: —Txiokre inihe inatyhymy aõbo reketeherenykre inatyhymy aõbo Eliasi iwiòhenadỹỹmy kanakremy aõbo inihe. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesuisi ixityre rirajuare. Rurure. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kia dohodỹỹna heto‑ki heka ixiwòtenaõ rỹimyhỹre ierykõna. Tahe urile idi ixiwanale ruamy reare iratyre‑ribi bede‑ò. Suuhe ramytatare. Mana rabòhòbòhònyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Wabede hãlooõ heka riraynyre. Deuxu hõrõ mahãdu sõwemy rubu‑ribi riixixanyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wabede‑ribi ròhònyrenyre. Iu Jesuisi rubu‑ribi riixixareu tahe Jerusalẽ‑ò ròirenyre. Tai tahe sõwemyhe iny tuu robire. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tai heka soldado dinoduõ ratximyhỹ idi retehemy. Tule soldado mahãduõ tii‑wana ratximyhỹre. Ibutumy tuu robirenyre. Tai tahe tabrebu‑ribi narybedenyde: —Tii inatyhymy Deuxu Riòre heka rare. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hãwyyõ tule retehemy ratximyhỹre irehe‑ribi idi. Aõma hãwyy Jesuisi riwiòhenanymy raremyhỹ heka idi retehemyhỹre. Tiiboho Kalileia bede‑ribi doide. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Marie Madalena, Marie Txiause Jyjese, Zebedeu riòrese tule tai ratximyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bedesòmy Jyje rehemynyre. Tii ityhy heka rare Arimatea hãwã luduõ ratximyhỹre. Tii Jesuisi tyhydỹỹduõ ratximyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tai Jesuisi umy rexitòenyre Pilato‑ribi. Tai tahe Pilato rarybere: —Tamy biwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Tahe Jyje linho tyky rirahananymy. Tai tahe aõma wabede tỹmyrahakỹ riamy roireriò heka rituunykremy idi rara. Idi mana nihikỹ ritidire txiò. Idi ròirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Marie Madalena ijõ Marie‑wana taile retehemy ronyre wabede‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ijõ txu tahe fariseu mahãdu wedu tule xiwena wahidỹỹdu wedu heka Pilato‑ò sexta feira rahudi tahe, judeu mahãdu elehyna txu wahe ituere. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Jesuisi irumy raremyhỹu tii rarybere: —Rubu‑ribi heka ariixixanykre inataõ txu‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ruimy rare tahe ihãrele tahe biyrubunyke iwabede. Aõkõkre‑wana tahe ierydỹỹna mahãdu heka iumy riwykre. Tai tahe rarybere: —Tii rexiixixanyre. Tai tahe ibutu rityhynykre iruina. Kia ibinatyhymy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tai tahe Pilato riteònyre soldado mahãduõ txiò‑ki. Tamy rarybere: —Awimy biyrubunyke! ");
INSERT INTO kpjNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kia bede erynaõ heka tamy ritidire. Txiò‑ribi resekreule heka rieryrenykre. Tahe soldado mahãdu riyrubunymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ijõ txu rudile tahe Marie Madalena, Marieõ‑wana rare ihãloona‑ò itxeremy, domingo, nobiutxu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aõwesele tahe iu suu ramytatare. Wanyrỹ ỹju heka dobehede biu‑ribi iu. Tahe hãloo ijò‑ribi mana ritamy ityre ronyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Iòsỹny heka urile ritoosònyhỹkỹre. Ityky tasỹ iurahakỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Idi itxeredu mahãdu heka aõma ruberunihikỹrenyre. Urile rõhõtiberemy reserenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ỹju rarybere hãwyy‑ò: —Uritere berebuõmyrenyke. Kai aõbo Jesuisi teijeteri, inatyhy? Aõma itxeò ritamadỹỹnyrenyre wahe. Reeryre kia. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aõkõre kaki aõkõ heka ratxireri. Tii dori rubu‑ribi rexiixixanyre iwese tii iximy rarybere wese wahe. Beteheke inihe iherina tyby‑ò tai juhu roimyhỹò. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Make karibi ele elemy ierydỹỹnako belyykre tii rubu‑ribi rexiixixanyraki. Tii heka rara Kalileia‑ò tamy wirotyreriò. Matahe, relyyra dorihe adeereny. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tai tahe rakòrunyrenyre, hãwyyboho. Ruberumy ròirenyre tasỹ reysamy ròirenyre. Ierydỹỹna mahãdu‑ò heka riijemyhỹre aõma ỹju rybemy ikoreny relyykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Iu rakòrunyrenyraule tahe wii reòbynyra. Jesuisiwanale heka itxi rekoare. Idi tamy rehemynyre iòhòmy. Iwa rimyrenyre tahe riwowydynyre. Jesuisi tamy rarybere: —Toiteri aõbo! ");
INSERT INTO kpjNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Uritere breburenyõmyke. Boibeny tahe ijyymy waityhydỹỹdu mahãdu seriòre‑ò heka Kalileia‑ò aròirenykemy. Tai tiiboho‑wana wii areòbynyrenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tai tahe tiiboho ròirenyre. Kiaule tahe wabede soldado itxeredu rehemynyre xiwena wahidỹỹdu wedu‑ò wahe. Tahe ibutumy relyyre iko. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tai tahe nieruõ riwahinyre ruiõmy relyykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tamyreny raryberenyre: —Ierydỹỹna mahãdu heka ridyra watỹireny reòbylemy. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tai tahe bede dinodu rierykreu heka aõ adee beleõtyhy aõbinahakỹõ. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tai tahe nieru sõwemy riwyrenymy tahe tuu ròirenyre ruimy. Wiji dori tuu ijyy rỹira. Ibutumy judeu mahãdu kia rybe‑ò rityhynymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Idi tahe ierydỹỹna mahãdu ròirenyre Kalileia‑ò. Tiobo Jesuisi riteònyrenyremy juhutyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesuisimy robirenyreu tahe tiiboho bede‑ò reserenyre tahe riwowydynyrenyre. Ijõ mahãduõ riseõnylemy idi rõhõtinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tai tahe Jesuisi iòhòtyhymy tamyreny relere kiamy tamy rarybere: —Waruruna heka ibutu ratyre ratximyhỹre kabede‑ki tule, biu‑ki tule. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tai kaiboho waha deòdumy boibenyke ibutumy iny bede bede mahãdu‑ò, bede bede konananahakỹ mahãdu‑ò ihyy behemynybenyke. Waityhydỹỹdumy heka bitxienybenyke. Wahanimy, tule Deuxu Riòrenimy, tule Deuxu Tyytybytyhynimy, tahe bòratisebedỹỹnybenyke wadeòdurenymy, Waha, Ityytybytyhy, Iriòre kaboho deròwymy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ibutumy aõbo wabede ywina adee rewahinyredi bibedeerykre. Uritere nohõti losarenyõmy awanarenyhyy dori ararekre bededỹỹnanahyy rekehemynykre.");
INSERT INTO kpjNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kaki heka Rybe Wihikỹ juhu kaki roire. Ka Rybe Wihikỹ Jesuisi Kristumy heka rarybereri. Tii heka Deuxu Riòre rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Myheka Isaia tyyriti‑ki kia rybe rỹire: Deuxu rarybere: —Boholake, waõwàdàdu ariteònykre akomy. Tii ary riwinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tii ryrymyhỹ bederahy‑ki: —Kai biwinykre rywihikỹ Wanyrỹ dee. Òbiti tamy biwinyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Joaõ Sebedỹỹdu bederahy‑txi taile ihỹmyhỹ rybe tyyriti ritỹnynymyhỹ. Tii sebenaõmy riòbitinymyhỹ. Kia riwinykemy ixi‑txi tõhõti reakemy taòraru‑txi kia Deuxu ritakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ibutumy Judeia bede ludu mahãdu Jerusalẽ hãwã mahãdu‑wana rare bederahy‑ò. Taòrarumy relyymy rahudi tahe, Joaõ risebenyre bero Jordaõ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Joaõ rexityynyre kamelo rade tyy‑di, tule iròdutyy wereysana iwetya‑ki roimyhỹre. Irỹsỹna raremyhỹ, seihikỹle bidi‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Joaõ rybe tyyriti ritỹnynydỹỹmy rarybemyhỹ: —Jiarỹ aõ aõkõ rare, waruru‑di aõkõ. Inyõ wahewomy kanakre tahe iruru waruru ratyredỹỹnadu rare. Waratyre awityhyke. Jiarỹ riwaixỹrunymy watxireri iwataana ese‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jiarỹ bedi arãsebenyre. Tii heka Deuxu Tyytybytyhy‑di arãsebenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kiatxu Jesuisi nade Nazare Kalileia bede ludu‑ribi. Joaõ tii risebenyre Jordaõ bero‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tii bera‑ribi dotuodeu biuwetyky rarayre. Deuxu Tyytybytyhy heka bòtòe wese tamy dobehede. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Deuxu rybe‑ò roholare biu‑ribi: —Kai heka Wariòre waluu tate. Adi wadeysawihikỹreri. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aõwesele Deuxu Tyytybytyhy heka Jesuisi riteònyre bederahy‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tii bederahy‑ki 40 txumy bede idi rỹire. Satanasi aõhõkỹmy risỹnymy Jesuisi raremyhỹ. Iròdu deborehekỹ tai rỹiramyhỹ. Ỹjureny iyrubudỹỹmy rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Joaõ rare ròtenawo‑ò, idita Jesuisi Rybe Wihikỹ ritỹnynykremy dehemynyde Kalileia‑ò. Jesuisi heka Rybe Wihikỹ ritỹnynydỹỹre: —Deuxu Iòlòna bede‑ò wahe. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesuisi rarybera: —Bededỹỹnanahe bede reara. Deuxu Iòlòna bedehe iòhòra. Kaiboho ixi‑txi õhõtireny reake aòrarureny‑txi bityhynybenyke Deuxu Rybe Wihikỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesuisi aho ijàti‑ki rariamy ihỹmyhỹ. Tii robira tuureny taseriòre‑wana ihỹmyhỹ‑ò, Simaõ Pedro, Andre‑wana. Tiiboho rehumy ihỹmyhỹreny rià‑di. Tiiboho heka waxidu roire. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesuisi rarybera tamyreny: —Kaiboho bodoibedenyke wahemy. Tai tahe araerynanyrenykre iny rimykemy utura temyta wese. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tahe aõwesele rià ririrenyre. Roire Jesuisi‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iko roire Joaõ, Txiau, taseriòre‑wana. Tiiboho heka Zebedeu riòre roire. Tiiboho hãworo‑ki ratximyhỹreny rià riywinymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesuisi tamyreny rarybera: —Wahemy bòdòike. Tahe aõwesele tybyreny ririrenyre teòdu‑wana. Tahe tiiboho roire Jesuisi‑wana ierydỹỹnamy roirekemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tiiboho rirònyrenyre Kafanaõ hãwã‑ò. Judeu mahãdu aõmysỹdỹỹna txu aõkõ. Jesuisi ralore judeu mahãdu dohodỹỹna heto‑ò erydỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kowa mahãdu urile bede riòtiinyre irybe‑ki. Tii heka irurutyhy‑di rierynanyre, ierydỹỹdu mahãdu wese aõkõ rohodỹỹnanymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kia bedeu heka hãbu tyytybybina‑di ratximyhỹre dohodỹỹna heto‑ki. Tyytybybina hãbuwo‑ribi rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Aõhebo wadi botỹỹnykre Jesuisi Nazare ludu. Biwahubenykre aõbo? Jiarỹ araeryre mobo kai tatehe, kai heka hãbuõtyhy inatyhy Deuxu‑ribi kai tate. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesuisi tarurumy rarybere: —Kai rybeõmyke. Iribi bòhònyke tyytybybina. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tyytybybina hãbu riatyre riworỹsỹworỹsỹnylemy. Tyytybybina ryryre rybe iteremy, idi ròhònyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ibutumy iny ribedeòtiinyre. Ritỹỹraxinyre ijõ: —Aõwexe ratxireri, aõerydỹỹnatỹmyrabo ratxireri. Tii riteònyre tyytybybina. Tyytybybina Jesuisi rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ityhynina Kalileia bede bedemy reare. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tahe dohodỹỹna heto‑ribi ròhònyrenyre. Jesuisi, Txiau, Joaõ‑wana roirenyre Simaõ, Andreboho heto‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simaõ riòre lahi roimyhỹ rubunamy. Tahe aõwesele tuu relyyre Jesuisiko. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesuisi rimyre tebò‑ki, tahe, aõwesele irubuna ixãwira. Idi tahe hãwyy tamyreny bede redere. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Txu ralòmy rahudi, ibutumy tamy didydenyde inybina bina. Tule iny tyytybybina tamy didydenyde. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ibutumy iny hãwã ludu iheto ijò wirotyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tii ibutumy binana òta òta riywinyre. Sõwemy tyytybybina riòlòdỹỹnyre. Tyytybybina Jesuisi rierymyhỹre. Tai tahe Jesuisi riijõnyre tyytybybina rarybekeò. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Rudile Jesuisi rare bederahy‑txi rexitòenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simaõ, ijõ mahãdu‑wana Jesuisi ijesetyhymy roire. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tiiboho Jesuisi raharenyre. Tamy rarybere: —Ibutumy iny arãijereri. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesuisi tamyreny rarybere: —Rokoikehe rekexinoranyrenyke hãwã witxira‑ò. Jiarỹ tamyreny rybe tyyriti aritỹnynykremy. Iurenana tahe jiarỹ anade. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesuisi rare ibutumy Kalileia bede‑ò. Tyytybybina iny‑ribi riteònyre. Tule dohodỹỹna heto‑ki tii rybe tyyriti ritỹnynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Hãbu tyybina mahãduõ Jesuisi‑ò nade. Tii tatiowotimy resere Jesuisiko‑ò. Tahe Jesuisi‑ò hãbu rarybere: —Adee awikeki tahe, biwateytenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesuisi juhu urile riwotòenyre. Tii hãbu ritorunyre. Tahe rarybere: —Wadee awire, atyy awimy relekre. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tahe aõwesele ityybina reytera. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesuisi hãbu riteònyre. Rarybere: —Kai tahe inyõdee rybeõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kai bexiteòsinykre Deuxu aõmysỹdỹỹdu‑ò. Iwese Moisesi ròerynadỹỹnyre wese, kai bexiteòsinykre. Kia heka inydee deòsinamy riteòsinyre. Kia iny rieryke timybo teytemy atximahãtemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tahe hãbu rare ibutumy inyko relyyra. Kia heka Jesuisi tahe uritere hãwãhãkỹõ‑ò ralòõhyyre. Tahe bederahykile rarire. Ibutumy iny tamy rare ibutumy bede bede‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tiutxuõmybo Jesuisi dòòsede Kafanaõ‑ò. Idi tahe rybe reare rehemynymy ratximyhỹ heto‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tahe iny, aõriòre aõkõ, tamy wirotyre heto ijò‑ò. Tahe Jesuisi relyymyhỹ Deuxu rybemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hãbu inaubiòwa heka hãbubina‑di tamy detyydenyde. Kia hãbu rawòronyre taumy‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Jesuisi‑ò rehemynyõhykylere iny sõwereki. Tahe raòwònyrenyre idi heto ratyytyre‑ò. Hetotyre riraynyrenyre tahe reru‑di diberesedỹỹnydenyde byretyre‑ki Jesuisiko‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesuisi rieryre hãbu rityhynyrenyre, tai rarybere hãbubina‑ò: —Waexi aòraru‑ribi araixitarasadỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bede ywina erydỹỹ mahãdu rorukurenyreri, ixideele rarybemy rỹimyhỹre: ");
INSERT INTO kpjNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Aõherekibo hãbu kiawese rarybereri. Tii iòwe òwelemy rarybereri. Deuxu dee aõbina binalemy rarybereri. Mobo tahe òraru‑ribi iny ritake. Deuxule òraru‑ribi iny ritake. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuisile roholaõlere ihãrele rieryre aõmybo raryberenyre. Tai tahe Jesuisi tamyreny rarybere: —Aõherekibo kiawese tarybetenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tibohe isiraõtyhyre, tuu ararybeke: —Aòraru‑ribi anaixitarasadỹỹnyre ada myike, abyre bimyke, mariake. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kaiboho bierykemy Deuxu Riòre Hãbutyhyhykỹ irurudire iny òraru‑ribi iny ritakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Tahe hãbubina‑ò rarybere: —Boholake, myike, abyre bimyke tahe makre aheto‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tahe hãbu rỹire, tabyre rimymy tahe rare ibutumy inyru‑ò. Ibutumy bede riòtiinyre tahe reàlàre Deuxumy. Ibutumy rarybere: —Tiu heka aõmy kawese rabiõhyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesuisi rare ahohokỹ ijà‑ò. Ibutumy tamy doide. Tii iny ribedeerynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Levi, Afeu riòre, ronymyhỹ nierumynydu hetowo‑ki. Jesuisi ibire‑di rareò, tii robira. Jesuisi heka Levi‑ò rarybere: —Waijoimy mynake. Tahe rỹimy reare Jesuisi ijoi‑ò ralore. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesuisi taerydỹỹna‑wana rorukure Levi hetowo‑ki. Tule nierumynydu mahãduõ ronymyhỹre òrarudu‑wana. Ibutumy riroximyhỹrenyre. Sõwemy heka kia iny mahãdu Jesuisi riheludunyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bede ywina erydỹỹ mahãdu, lahi rybe‑di erydỹỹna mahãdu tuu robirenyra. Idi raryberenyre Jesuisi erydỹỹna mahãdu‑ò —Aõherekibo tii riroxireri òrarudu‑wana, nierumynydu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesuisi roholareu, tamyreny rarybere: —Iny ibinaõkeki tahe luahidu tamy kanaõtyhy. Tahe iny ibinakeki, tamy kanake bina‑ò. Òbiti mahãdu itxemy aõkõ anade. Tahe òrarudu mahãdu itxemy anade. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Joaõ erydỹỹna mahãdu, lahi rybe‑di erydỹỹdu mahãdu‑wana byreõhyky txuu tutyhyle rỹimyhỹrenyre. Tahe roire Jesuisi dỹỹraxidỹỹmy. Inyõ Jesuisi ritỹỹraxinyre: —Aõherekibo Joaõ erydỹỹna mahãdu byreõmy rỹiõmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesuisi rirawyònyre: —Heriduõ, itxeredu‑wana ratxireriu, byreõmy rỹiõtyhy tutyhylemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tiutxulemybo tahe heridu iribi kanatakre, tai tahe byreõmy kỹnyikre tutyhylemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Moheka tyytỹmyra dòbòna ritidikre tyytyby‑ò. Idi inatyhymy dòbòna rayjakre tahe tyytyby sõwemy raykake. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Moheka òteti bederatyrube tỹmyra rihynymyhỹre iròdutyy walabuutybywo‑ò. Idi tahe raberyrònymyhỹreu, urile iròdutyy walabuu raykake tahe irube rejujuke. Tule iròdutyy walabuu ribinadỹỹnymyhỹre. Irubetỹmyra awire heka iròdutyy walabuu tỹmyrarokile. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Judeu elehydỹỹnareny txu Jesuisiboho ririranymyhỹrenyre maixõmo wesena oworumy, tai ierydỹỹna riòròmyhỹrenyre riroxirenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tahe lahi rybe‑di erydỹỹdu mahãdu rarybere Jesuisi‑ò: —Aõherekibo aerydỹỹna mahãdu riwinyreri aõwidỹỹna aõkõ karare sabado txu. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tahe Jesuisi tamy rarybere: —Kaiboho aõbo teriranyõletenyta tyyriti‑di. Iwese Daviboho‑wana aõhebo rotỹỹnyreri aõmy rekoarenymahãu, rama rahumyhỹrenyu. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tii ralore hetotyhy‑ò. Tai tahe orotxu sira ybina riyre, tule tamahãdu‑ò riwahinyre. Kia tahe Deuxu deòdule rirỹsỹmyhỹre. Kia Davi aõhebo rotỹỹnyre Abiata heka Deuxu deòdu wedurau. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesuisi tamyreny rarybere: —Sabado txu heka rawidỹỹre inydee, iny tahe rawidỹỹõre sabado txu dee. ");
INSERT INTO kpjNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Deuxu Riòre Hãbutyhyhykỹ tahe sabado txu wedu rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ixityre Jesuisi ralore dohodỹỹna hetowo‑ò. Hãbu debò binahakỹõ tai ratximyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Lahi rybe‑di erydỹỹdu mahãdu Jesuisi retehemyhỹrenyre. Jesuisi sabado txuule riteytenykeki, tiiboho rarybekemy aõbinabinakibo raharenykemy Jesuisi. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesuisi heka hãbubina‑ò rarybere: —Manake. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tahe Jesuisi ijõ mahãdu‑ò rarybere: —Aõwihikỹwidỹỹ awire ada aõbinalemy widỹỹ awire. Tibohe awire, itarasa‑ki aõbo ada rubu‑ki aõbo. Hãbu mahãdu urile riyryre. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesuisi tamyreny retehere raõbinamy. Tii heka iaõna aõna riwotòenyrenymyhỹ. Jesuisi hãbu debò bina‑ò rarybera: —Ebò biterenyke. Tai tebò riterenyreu, aõwesele awimy relere. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lahi rybe‑di erydỹỹdu mahãdu rara Iòlò Herodi mahãdu‑ò. Tiiboho raryberenyre timybo tahe Jesuisi rirubunyrenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesuisi rexitare taerydỹỹna mahãdu wana aho‑ò. Tahe sõwemy iny Judeia mahãdu, Kalileia mahãdu riheludunyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ibutumy aõna aõna roholare Jesuisi riwinyreò. Tahe sõwemy tamy nade: Jerusalẽ hãwã mahãdu, Idumeia hãwã mahãdu. Iny Jordaõ bero ijà‑ribi tule nade. Tule iny Tiro hãwã, Sidõ beà hãwã‑ribi iòhòmy tamy nade. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tahe Jesuisi taery mahãdu‑ò rarybere: —Walawò bidiwykre. Iny sõwemy dori rehemynyreri. Kidiwawotõmonykre òsana. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ibutumy bina mahãdu ibymy tebò reareri ixideytedỹỹmy. Urile iny sõwemy riywinyre dori. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tyytybybina Jesuisi reteherenyreu, urile iko‑txi resere ryryreri: —Kai Deuxu Riòre tate. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tai tahe Jesuisi rarybere tyytybybina‑ò, uritere iteòsidỹỹõmykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tii raòwònyre bederatòòmy. Tahe taerydỹỹna‑ò ryryre tibo tamy reòbykemy. Tahe tamy nade. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tahe ierydỹỹna waòinatxi reuròmy rarunyre tii‑wana rarekemy, rybe ritỹnynydỹỹkemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tule iruru‑di rarekemy inybina riteytenykemy. Tule irurudikemy tyytybybina riteònykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kie ierydỹỹnanirenyre: Simaõ, (tii tahe Jesuisi ijõni riwahinyre, Pedromy) ");
INSERT INTO kpjNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Txiau ijõ, tii Zebedeu riòre rare. Kia seriòre Jesuisi rininirenyre, Boanejimy, inireny. Kia heka irybereny rare, Biumytxy riòrereny. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ijõ heka Andre, Filipi, Bartolomeu, Mateu, Tome, Tadeu, Txiau. (Kia Txiau heka Afeu riòre rare.) Ijõ Simaõ iwitxira, (tii brebuõmy rybe‑ki, tasubedeluudu wahe.) ");
INSERT INTO kpjNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judasi Isariò ijõre, kia heka Jesuisi riwahinyre iòludu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tahe Jesuisi nalode taheto‑ò. Ixityre iny sõwemy tamy nade. Tai tahe Jesuisi taerydỹỹna‑wana riroxiõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Idi tahe Jesuisi leinareny itxỹtesana roholarenyreu, riòryrenyre. Tiiboho raryberenyre: —Jesuisi itxỹte iòhòlere. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bede ywina erydỹỹ mahãdu doide Jerusalẽ‑ribi rarybemyhỹrenyre: —Belisibu idi ratximyhỹre. Tyytyby wedu ruru‑di tyytybybina iny‑ribi riteònyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesuisi inyko ijyymy relyyre: —Timy taheka Satanasi rexiteònykre Satanasi. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Iòlòna wiribi rexihitxinykeki tahe, rexihukre ibutumy wiludu. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tahe sỹro luduõ wiribi rahitxikeki, rỹiõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanasi rỹikeki reburemy, tii ixiòbitile rexirubunyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Inyõ heka hãbu rurutere hetowo‑txi ralòõtyhy. Tai rawasinykeki, urile iny ritaataake. Urile hãbu rataataakeki, iròòbymy iny rawasinyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Inatyhy jiarỹ adee ararybereri, ibutumy òraru heka kanaixãwidinykre hãbu dee aõtxile aõbina binamy rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kia inyõ aõtxile aõbina binamy Deuxu Tyytybytyhymy rarybekeki, tiu heka iòraru rataõtyhy. Kia òraru riwinyre tiiehyymy rarekemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesuisimy kiamy narybedenyde: —Tii heka tyytybybina dire. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tadi tahelỹỹna‑wana nade. Tahe ahanakile ritamanyre. Tamy riteònyrenyre iòrysymy. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iny sõwemy iwerora‑di ronyre. Tahe Jesuisise‑ò rarybere: —Adi aseriòre‑wana ahanakile nyide, araijereri. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesuisi rarybere: —Mowe nadi rare, waseriòreboho rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Juhu urile idi retehereri iwerora‑ki. Tahe rarybere: —Betehekre, kaiboho ibutumy kaki nadiwesere, waseriòre wese toite. ");
INSERT INTO kpjNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Inyõ aõna aõna riwinymyhỹkeki, Deuxu dee awira. Kia heka nadi, waseriòre roire. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesuisi ròòsera ahobero ijà‑ò iny dohodỹỹmy. Sõwemy iny wirotyre. Tai Jesuisi ronyre hãworo‑ò tahe rexitaranyre ahoro‑ò. Aho ijà‑ò iny wirotyre ijohonamy. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tii aõna aõna sõwemy roerydỹỹnanyre ijyytyhydile. Kaa ijyymy tii relyyre: ");
INSERT INTO kpjNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Boholake, alòbòròna‑di dehudu rara alòbòrònamy. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Alòbòròna‑di rehumyhỹu, ijõ ryro‑txi resere. Tahe nawiixõmo rirore. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ijõ rejujure manarutàsu‑txi. Tahe aõwesele raumynyre iraruxiõlemy su dori ibutere. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Irauxiõreki, bede tòtee alòbòròna rimoenyre idi rurura. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ijõ oworuty resere edehu‑txi idi ruhunyre edewanale. Tai tahe ede‑ò riòdesenyre tai raratynyõlere. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ijõ resere su witxira wihikỹ‑txi. Kia tahe raumynyre. Tahe sohoji oworutyõ 30my iraty raratynyre. Ijõ oworuty 60my raratynyre. Ijõ tahe 100my raratynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tii rarybera: —Kaiboho aõbo õhõtidirenyre, inatyhymy warybe‑ò boholake. Adee awikeki, bierybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iny robỹtỹreu, ijõ rarilere ierydỹỹna mahãdu‑wana. Tiiboho rỹỹraxire Jesuisi‑ò: —Aõhekemybo telyyta ijyymy. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesuisi tamyreny rarybera: —Deuxu Iòlòna rybemy Deuxu araerynanykre. Kia heka tuu teeryõmahãte. Kowaboho‑ò jiarỹ urile ijyymy relyyra. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tai tahe kia wesele relyyra. Iny retehemyhỹkemy tahe robiõhyymyhỹre. Roholamyhỹre ta, rieryõhyymyhỹre. Tai tahe ralòkemy aõkõ, taòraru riixãwididỹỹnakemy aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tii tamy rarybere: —Kaiboho aõbo teeryõhyyletenyteri ijyy. Ihãre tahe timykibo bierybenyke ijyy ibutumy. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aloborodu rehumyhỹ alòbòròna‑di. Kia oworuty heka rybe wese rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Oworuty ryijàti ludu heka iwese uriijohonadu wese heka rare. Rybe‑ò roholarenyreu, Satanasi nade rybe iwo‑ribi ritakremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Manarutàsu ludu iwese iny reysamy roholareri. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Iny urihimyòle rarorehenymyhỹre iraruxi sõweõreki. Idihe rasirara irybe. Tule iny ralahatxinamyreki, ihyyle tahe riixãwidinyra. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ede rawo ludu iwese iny witxira roholareri. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tiiboho taaõmydỹỹnadile rõhõtinymyhỹre. Sõwemy nieru‑di ratxikemy rexinohõtinymyhỹre ta nieru riitxenanymyhỹre. Ijõ aõna aõnadile rexinohõtinymyhỹre. Kia aõna aõna rybe rirarutxinymyhỹre. Tai tahe rybe raratynyõmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Suwihikỹ ludu iwese iny witxira roholareri. Kia inatyhymy rỹireri heka raratynyre alòbòròna raratynyre wese. Ijõ raratynyre 30my, ijõ tahe 60my raratynyre. Ijõ tahe 100my raratynyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tii rarybera tamyreny‑ò: —Uritere loosòna ideõmyke butxi worawo‑txi ada herina raworawoõ‑txi aõbo. Loosòna bidekre bedewiõ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Inyõ iwòteõmy aõna aõna tiiehyymy. Tiutxulemybo ratỹnykemy ihỹre. Iwòteõmy atximahãbenyke aõu bodobikemy atximahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kaiboho aõbo õhõtidirenyre, inatyhymy boholake. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tahe Jesuisi tamyreny rarybera: —Kaiboho inatyhymy boholabeny tamy taholamahãtenyteò. Urihixina iwese teõteri wesele, kai biwykre. Ihãre tahe biwykre ijõ teõta‑ribi ritamy. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hãbuõ ijõdikeki tamyle rawahidỹỹke, tahe hãbuõ ijõõkeki iribi ratatyhyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesuisi relyyra kia ijyymy: —Deuxu Iòlòna kia ijyy wese rare. Hãbu rehumyhỹre alòbòròna‑di suò. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Hãbu rumy rõrõmyhỹre txulemy rexixamyhỹre. Tii rieryõlemyhỹre timybo alòbòròna ratybienymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Suu ixi dee sohojile raratymyra. Juhuu iòle ramyhỹre. Idi tahe raratynymyhỹre, ihewonau, tahe, iraty rasònymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bederaty rasònymyhỹreu, iyresydu riteònymyhỹre. Mayrabu‑di riòròkemy bederatysò butudỹỹna dori rexihumyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tii rarybera, Deuxu Iòlòna wexe aõwesere. Aõ‑ò wexe rikioirenykre. Tiwexe ijyy kawesere. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kia heka mostardaty wesere. Tii heka iylatyhymy ratximyhỹre kabede‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tahe tii raumynymyhỹre wana, ireitòbòròdỹỹ ratyre rarurururunymyhỹre. Tahe nawii tamyle rasỹnymyhỹre. Iubòròrò rawolemy taheto riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tahe Jesuisi Deuxu rybemy rierynanymyhỹre. Kia ijyy wese sõwemy ijyy rierynanymyhỹre. Kialemy iny‑ò Jesuisi relyymyhỹ ibutumy tamy reny ritynynynyhỹreki. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kia‑ò riòbitinyõlere ijyyõ. Tahe iny‑ribi irehemy taerydỹỹna‑ò riòbitinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iu txu txiorolemy Jesuisi rarybere taerydỹỹna‑ò: —Rikiòhòrerenyke kowa weribi ijà‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sõwemy iny rarire aho ijà‑ki. Tahe taerydỹỹna tamy ralore. Roire hãwò‑di. Tahe ijõ hãwò idi ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tahe bede binahakỹ rexidelenyre yhymy. Tahe òbò hãwò rihãtenymyhỹ tai ritỹmynykemy ritelenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tai tahe Jesuisi rõrõmy roimyhỹ tòro‑ki irati tarahynatyre‑ki. Tai tahe riixixanyre. Ijõ rarybere: —Waerydỹỹdu, adeehe awimy aõbo iny ituerenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Rexixamy Jesuisi. Tii yhy riixãwididỹỹnyre. Tii ahohokỹ‑ò rarybere: —Biyryke! Tai bede ruhuwihikỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tamyreny rarybere: —Aõherekibo kaiboho taberutenyteri? Deuxu aõbo tetyhynyõmahãtenyte? ");
INSERT INTO kpjNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tai tahe tiiboho bede riòtiinyrenyra. Tahe widee raryberenyre: —Mowexe tuu yhy ahohokỹ‑wana irybe riywinyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ritehemynyrenyre ijõ berohokỹ weribi ijàna‑ò. Kowa heka ibutumy hãwãhãkỹ Kadarena inirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesuisi hãworo‑ribi resereu, hãbu tyytybybina‑di robire ròhònyreri wabede‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kia heka tiiemy rasỹnymy raremyhỹ wabede‑ki. Katahe wiji moheka womati reroti‑di rataataaõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aõdorihe òhòõre tebò iwa rataataare womati reroti‑di. Tiiemy heka rimoenymyhỹ. Teòruty ludu tawararu ludu tule ritòtynymyhỹre iyresymy. Moheka iruruõre iny erydỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Txuu ruu‑wana heka tii rasỹnyre wabedewo‑ki. Tii rariamyhỹre bederatòòmy. Tule rirajuamy tai rexihãtenyre mana‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tai tahe Jesuisimy robireu, tii raijaranyre Jesuisi‑ò. Resere tatiowotimy Jesuisiko‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesuisi tyytybybina‑ò rarybere: —Iribi bòhònyke. Tahe tyytybybina rarybera: —Aõwe wadi tate. Kai, Jesuisi, ibutumy inyõ dee inyratyre tate. Kai Deuxu Riòre tate. Làhàmy làhà, uritere aõbina binahakỹmy wahõrõdỹỹõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesuisi ritỹỹraxinyre: —Mobohe anire. Tyytybybina rirawyònyre: —Wanireny sõwetyhyre wasõwerenyreki. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Urile karibi wateòdỹỹrenyõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tahe kowa‑ki ixỹni juramy riroximy rỹimyhỹ bederatòò‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ibutumy tyytybybina rexitòenyrenyre: —Biwateònybenyke ixỹni jurawomy aralòrenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tahe Jesuisi riteònyre. Tyytybybina aõwesele ròhònyre tahe ixỹniwomy ralore. Ixỹni jura tahe raòrunyre rejuxunyre ijòtira‑ribi. Berawo‑txi tahe rabòròròre ahohokỹ‑ki. Inatxi mil ixỹni rabòròròre. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ixỹni‑di itxeredu reare ijyymy ibutumy hãwã hãwãmy relyyrenyre. Tahe iny dirahude tamy itxeremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tiiboho Jesuisi‑ò doideu, tuu robirenyra hãbu tyytybybina‑di raremyhỹ. Tii rexityynymy ronymyhỹre. Tii heka òbitimy rõhõtinymyhỹre. Tai iny mahãdu rabedeòtiidỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tiiboho tuu robirenyre, ijõ‑ò relyyrenyre ixỹni ijyymy, timybo aõhebo rotỹỹnyremy hãbu tyytybybina‑di ratximyhỹre. Tule relyyrenyre timybo rotỹỹnyre ixỹni jura. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Iny rexitòenyre Jesuisi‑ò rexitakremy isureny‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesuisi hãworo‑ò ralore. Tahe hãbu tyytybybina‑di ratximyhỹre, rexitòenyre Jesuisi‑wana rakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tahe Jesuisi idy derare. Tamy rarybera: —Mahe asỹ‑ò, aijoi‑ò belyyke aõna aõna Deuxu adee riwinyremy, iwese tii araruxetòenymyhỹre wese. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tahe hãbu rare Debòwiò hãwãreny‑ò. Ibutumy Jesuisi aõna aõnamy ixidee riwinyremy relyyre. Ibutumy iny ribedeòtiidỹỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ixityre Jesuisi rare ahohokỹ weribi ijà‑ò. Ixidee iny sõwemy ributunyre. Tii heka ihỹmyhỹ ahohokỹ ijà‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tahe dehemynyde tamy dohodỹỹna heto weduõ. Ijairu inire. Tii Jesuisi robireu, resere tatiowotimy iko‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ijairu rarybere Jesuisi‑ò: —Wariòre irubu iòhòtyhylemy roireri. Kai manakre tamy ebò bitidikremy. Tai awimy relekre, ruruõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tahe Jesuisi tii‑wana rare. Iny sõwemy tule rare iòhòkile tamy rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kia heka hãwyyõ binamy ramyhỹre. Ihãlubu rejuxunymy raremyhỹ. Beòra waòinatxi reuròmy rejuxunymyhỹre, rihuõhyy raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tii aõhõkỹmy rotỹỹnymyhỹre sõwemy òhotibedu mahãdu‑di. Tahe awimy rotỹỹõlemyhỹre. Urile tanieru ibutumy rahure òhotibedu mahãdu‑ki. Awimy releõlemy, ire bede‑ò resere. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tahe roholare Jesuisi nina‑ò tahe iòhò‑ki nade inyy‑ki. Idi ihewo‑ribi rimyra ityynora‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Hãwyy ixidee rarybemyhỹre: —Krile itykynora‑ki karimykeki, karekyteke. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tahe aõwesele ihãlubu ijera ixãwire. Ixidee awimy rõhõtinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesuisi rieryre iruru iribi ròhònyremy, tai rarybere: —Mobo watyynora rimyra. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tahe ierydỹỹna raryberenyra aõherekibo tuu tarybeta ibutumy taheka iny abirelemy rỹireri. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesuisi retehemyhỹre urile mobo rarekemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hãwyy rierymyhỹ aõhebo rotỹỹnyre. Tii ruberumy Jesuisiko‑ò resere relyykemy iko. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesuisi rarybera: —Lerỹ, atyhydỹỹna kỹnyhe aratara. Mahe, kai dori texiywinyta. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tii rarybemyhỹò, dohodỹỹna wedu deòdu rehemynyrenyreri. Tiiboho raryberenyra: —Wawedu, Ijairu, ariòre rurumy roireri. Aõmybo tahe Erydỹỹdu‑di atxiteri. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesuisi kia‑ò roholara tahe rarybera dohodỹỹna wedu‑ò: —Brebuõmy, urile bityhynykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesuisi‑wana roire, Pedro, ijõ Txiau, ijõ Joaõ. Joaõ heka Txiau seriòre rare. Kaòle heka reòbyre tii‑wana rakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Dohodỹỹna wedu heto‑ò dehemynydeu, ixiyjadỹỹ‑ò roholara, robureriò, rirajuareriò. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesuisi ralore tahe rarybera: —Aõherekibo tabutenyteri. Hirarihikỹ rurumy aõkõ roireri. Tii urile rõrõreri. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Juhu urile tai rutxuenyrenyra Jesuisi‑ki. Tahe Jesuisi ibutumy iny riòlòdỹỹnyra hetowo‑ribi. Tahe isele, tybyle, ixidee rimyrenyra ratxirenykemy. Tahe tamy rirònyrenyre tai hirarihikỹ roimyhỹò. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesuisi hirarihikỹ debò rimyre tahe rarybera: —Talita kumi. (Katahe iwitxira rybemy rarybera. Kiamyreri heka, mynyikemy.) ");
INSERT INTO kpjNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aõwesele hirarihikỹ rỹimy reara. Tahe rariara aõmyreki iwyra waòinatxi reuròmy iwyramy. Tahe urile bede riòtiinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesuisi riteranyre moõ rierydỹỹkemy aõkõ. Jesuisi tule rarybere: —Rỹsỹna tamy biwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesuisi dexitade kowa bede‑ribi. Tahe tauladu tybiena hãwã‑ò dehemynyde. Taerydỹỹna mahãdu riheludunyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabado txumy rierynanyre dohodỹỹna heto‑ki. Sõwemy iny roholamy rỹimyhỹ bede riòtiinymy. Tahe rarybere: —Tiribibo kia hãbu aõna aõna bede rieryre. Aõbedeeryhykỹbo ratximyhỹre. Timyta heka bedeòby riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kia aõbohe aõwidỹỹdule ratxireri, Marie riòrele. Tiiboho aõbohe Txiau, Jyje, Judasi, Simaõ, seriòrebohole ratxirenyreri. Terỹboho aõbohe tule kakile ratxireri. Ibutumy iny heka Jesuisi derarenyre. Irybe rityhynyõre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesuisi rarybere tamyreny: —Deuxu rybedỹỹdu heka tyhydỹỹna ritaõlekre tahãwãreny‑ribi, taijoi‑ribi, tasỹ‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tahe Jesuisi kowa‑ki bedeòby riwinyõlere. Urile tebò ritidire inybina bina tyre, taile riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesuisi urile bede idireny riòtiinyre rityhynyõlemyhỹrenyreki. Tahe Jesuisi reurore hãwã hãwã‑di erydỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tii ixidee ributunyre tawaòinatxi erydỹỹna mahãdu. Tii riteònyre inatxi inatxi iubỹtỹnyre. Tamyreny taruru‑ribi riwahinyre tyytybybina deòdỹỹki. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jesuisi tuu rarybere: —Urile biwykre adebòna. Uritere orotxu aõkõ, nieruhyna aõkõ, nieru wereysanawo‑ki aõkõ, iwydysyrenyõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Uritere waubehetyõmy noõmykre. Uritere inatximy wirawomy tyy‑di ixityydỹỹõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hãwã‑txi malòkeki, tiiemy taile bonykre tiubedemybo iribihyyle bòhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Titxi behemynybenykeki, uritere iny erarenymy reakeki, roholaõkeki, txiòrare, urileta awareny bitòtynykre bede erynamy. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tahe tiiboho roire. Rybe ritỹnydỹỹmyhỹre iny ixidee rexirahĩrenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tyytybybina irehemy iny‑ribi ririradỹỹnykemy. Sõwemy inybina tyre òlỹre ritxiwire. Tai tahe riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kia heka iòlò Herodi roholara. Jesuisini dori erynatyhymy raremyhỹ. Tahe ijõboho rarybemyhỹreny: —Joaõ Sebedỹỹdu rexixara rubu‑ribi. Ijõ rarybemyhỹreny: —Eliale ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ijõ rarybera: —Deuxu rybedỹỹdu ratxireri. Deuxu rybedỹỹduõ wese heka ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodi roholareu aõbo Jesuisi riwinyreu, rarybera: —Kia hãbu Joaõ ratxireri. Kia heka irati reorore heka rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kia heka iòlò Herodi riteònyre imynamy. Idi tahe ritisanyre ròtenawo‑ò. Taseriòre hãwyy òraru‑ki kia riwinyre. Filipi iseriòreni rare. Iseriòre hãwyyni Herodia rare. Herodi, Herodia‑wana roire iseriòre riòrese‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juhuule Joaõ rarybere Herodi‑ò: —Kai aõkõre aseriòre hãwyy‑di mabeõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodia tamy iky reamyhỹ rirubunykemy ratximyhỹ tahe aõkõhyylere. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodi tahe Joaõ rityhynyre. Tii rierymyhỹre Joaõ hãbu wihikỹõ ratximyhỹ. Tai riyrubunyre ròtenawo‑ki. Herodi Joaõ roholareu, urile bede riòtiinyre urile roholawihikỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kia txuu ibeòra reare Herodi lisina berenamy riwinyre. Tahe ibutumy hãwã dinodu, soldado wedu mahãdu, tule ibutumy hãbu ninihikỹ Kalileia mahãdu‑ribi rihuòtere. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ijadòma ralore resere, Herodia riòre. Herodi, iny huòtedu mahãdu‑wana tamyreny awire. Iòlò ijadòma‑ò rarybera: —Aõtxile aõma wadee bexitòenyke, adee ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Inatyhymy adee ararybekre. Waaõna aõna iweeremy bexitòenykeki, adee ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ijadòma tadi ritỹỹraxinyre aõmybo tahe tamy rexitòenykre. Ise rarybera: —Joaõ Sebedỹkỹdu rati kai bexitòenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tahe ijadòma ròòsere iòlò‑ò. Tahe ijadòma rarybera: —Joaõ Sebedỹkỹdu rati kai biwahinykre hyna tyre‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Iòlò sõwemy rabedewore irybe‑ki. Rexitxiõnyõlere iny dori sõwemy ibire‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Iòlò soldado rariare Joaõ rati òrysymy. Tahe irati riorore ròtena‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tahe irati diwyde besetyre‑ki. Ijadòma‑ò riwahinyre, tahe ijadòma tadi‑ò riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Joaõ erydỹỹna rieryreu tahe, nade iumy òrysymy. Tahe iumy riwyre wabede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesuisi erydỹỹna mahãdu ròòserenyre Jesuisi‑ò. Tahe relyyrenyra ibutumy aõmydỹỹnana tule ibutumy rierynanymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesuisi tamy rarybere: —Inyboho sohojile rokoireny bederahy‑txi ixielehydỹỹmy. Tii dori rarybera tamy heka byrena iòhòtyhyõlere tamy roxina raòhòõlere. Iny sõwemy tamy wii reutydynyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tahe tiiboho sohojile hãwò‑di roire bederahy‑txi inyõ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Iny sõwemy tuu robira ròhònyrerimy. Tahe iny ibutumy hãwã hãwã ludu raijaranyre tòròsòna‑ò. Tiibohole juhu rehemynyre iko‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesuisi rororeu, tahe inymy sõwemy robire, riraòreriò. Jesuisi tamy ratòenymyhỹre. Tiiboho dori iwese budoeni idi itxereduõmy rỹireri wesemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Txuu raloreu, ierydỹỹna mahãdu Jesuisi‑ò roire. Tiiboho rarybere: —Ka kỹnyhe bederahy roire txuuke rexihura. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kai tahe iny biteònykre hãwã hãwã mahãdu‑ò rỹsỹna ixideereny õbradỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesuisi tamyreny rarybera: —Kaiboho tamy rỹsỹna biwahinykre. Tahe raryberenyre: —Timybo tahe inyboho 200 prata womati nieru‑di orotxu rikiõbranyrenykre. Timy wexe tamyreny rỹsỹna rikiwahinyrenykre. Jesuisi tamyreny rarybera: ");
INSERT INTO kpjNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—Tiwese orotxu bohe rỹire. Maa tamy itxeremy. Idi tahe rieryrenyreu, rarybera: —orotxu iruyre, utura inatxi. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Idi tahe Jesuisi iny rabòròhòkỹ asityre rorukukremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Idi tahe iny rabòròhòkỹ wii rirareare, ijõ sĩwẽtamy, ijõ 100my. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesuisi orotxu utura‑wana rimyre tahe retehere biu‑ò Deuxu‑ò rexitòenyre. Idi tahe orotxu reòròòròre. Riwahinyre taerydỹỹna mahãdu‑ò riwykremy iny‑ò. Tule utura inatxi wirarea riwahinyre iny mahãdu dee. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ibutumy iny riroxire. Rihydymy rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Idi tahe ritỹxinyre waòinatxi reurò weririmy orotxu yre yre utura‑wana rauhenyredi. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kia heka rerỹsỹre 5000 inymy rỹsỹna‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Juhu Jesuisi riteònyre taerydỹỹna mahãdu ixiko‑ò kanaijõwe‑ribi ijà‑ò, Besaida hãwã‑ò. Tii tahe ririre iny riteònykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tahe riteònyreu, tii rare ixitòedỹỹmy bede ratòòhòkỹ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Txioro bedesou hãwò ahotya‑ki ratximyhỹre. Jesuisi suki ratximyhỹre ixisohojile. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tahe yhy rebònymyhỹ iutedereny‑ribi. Hãwò rariaõlemyhỹ. Tahe Jesuisi tuu robire txu ijera iòhò‑di. Tahe betyredile tamyreny rariare. Jesuisi iratyrereny wese rariakre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tahe tuu robireu, betyre‑di rariareriò, tiiboho unisỹna rõhõtinyrenyre, rirajuarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tahe ibutumy tuu robira ibutumy ruberurenyre. Jesuisi aõwesele rarybere: —Urile beysabeny, breburenyõmy. Jiarỹle watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tii ralore tamyreny hãworo‑ò. Yhy urile ixãwire. Ierydỹỹnaboho bede riòtiinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tiiboho ruberurenyre, orotxu bedeòbyna dori rierykõrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tiiboho riòhòrenyreu, ritehemynyre Kenesare‑ò. Kia‑ki hãwò ritisarenyra. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tahe hãworo‑ribi ròtuòreriu, ibutumy iny Jesuisi rieryra. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Juhu raòrunyrenyre bina bina mahãdu òrysymy. Idi tahe didydenyde roholarenyre titxibo tai Jesuisi ratximyhỹò. ");
INSERT INTO kpjNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tii raloreu iny hãwã‑ò aõbo ada hãwãhãkỹ‑ò aõbo ada bedero‑ò aõbo, tiiemy iny bina bina mahãdu iryko‑txi ritidire. Tai tamy rexitòenihikỹre tamy debò reakemy ityynora‑ò. Ibutumy tamy debò reareu, tahe riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jesuisi‑ò ributunyre fariseu mahãdu lahi rybe‑di erydỹỹdu mahãdu wahe. Tule bede ywina erydỹỹ mahãduributunyre. Jerusalẽ‑ribi ritehemynyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Jesuisi erydỹỹna mahãdu tebò risuhòõmy riroxireri. Fariseu mahãdu, Bede ywina erydỹỹ mahãdu‑wana Jesuisi‑ò ritỹỹraxinyrenyre: —Aõherekibo aerydỹỹna tebò risuhòõmy riroximyhỹrenyre. Aõherekibo ihetxiu bede ywidỹỹnana rityhynyõreri. Lahi rybe‑di erydỹỹdu mahãdu judeu mahãdu‑wana ihetxiu iwidỹỹnana riwinymyhỹrenyre. Tii heka tebò tiu suròduõmy riroxiõmyhỹre. Tiiboho aõna aõna wydyna heto‑ribi dòòsemahãdeu, tiu heka rõhõõdile riroxiõmyhỹre. Sõwemy iwidỹỹnareny rityhynymyhỹre. Bemona butxi, womati bese‑wana risuhòrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesuisi tamy dirawyònyde: —Isaia juhuule rarybere tiwesebo kaiboho toite. Kaiboho itxenadỹỹdu toite. Riritinymy rỹire: —Kaiboho riwawowydynymyhỹre tary‑di. Tahe awo‑ribi waluuõlemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kaiboho riwawowydynyre tahe watxi nohõti ijeraõlerenymy. Kai teerynanyteri erydỹỹna‑di iny nohõti‑ribi namyhỹdeòle. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kai Deuxu erydỹỹna tyhydỹỹõmy. Iny erydỹỹnale tetyhynytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tii tamyreny rarybera: —Kaiboho aõbo ijõ bihõrõnybenyleke, biaõmysỹnybenyke. Deuxu rybe bede ywina kaiboho tetyhynyõlemyhỹtenyte. Arybe bede ywinale tetyhynyõlemyhỹtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisesi rarybera: —Kaiboho biytyhynybenyke adirybe‑ò, tybyrybe‑ò. Inyõ tadimy tybymy iehehemy rarybekeki, aõtaxiny ruruke. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kaiboho teerynanyteri hãbuõ‑ò tadi tybywana‑ò rarybekemy: —Wanieru waribi bitaõke. Ariwahiny dori Deuxu‑ò. Wanieru heka korbỹ rare. (Korbỹ heka uri wahidỹỹna rare, iwitxira rybe wahe.) ");
INSERT INTO kpjNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jesuisi rarybehyymy rare: —Kiawese rierynanymy raremyhỹ, kaiboho uritere hãbuõ tadiboho‑ò aõmydỹỹõmy rarekemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kawese ityhydỹỹrenyõmy Deuxu rybe, aerydỹỹna òraru‑ki. Sõwemy aõna aõna kawese tatỹỹnytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tahe Jesuisi ixityre rarybera inysõwe‑ò: —Bodoholabenyke, ibutumy bierybenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Aõbo iny‑ò ralòmyhỹre, kia tahe iny risunyõlemyhỹre, inywo‑ribi tahe namyhỹde kia tahe iny risunymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Inyõ bierybenykeki, boholawibenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tahe iny‑ribi ròhònyreu, heto‑ò raloreu, ierydỹỹna mahãdu tahe tamy rỹỹraxire ijyymy. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tii tamyreny rarybere: —Kaiboho tule aõbo teeryõmahãtenyte. Aõbo iny‑ò ralòmyhỹre, kia iny risỹnyõlemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tawotyhy‑ò dori ralòõlemyhỹre. Urile weryri‑ò ralòmyhỹre idi umy‑ribi ròhònymyhỹre. (Ibutumy rỹsỹna tahe awire riki.) ");
INSERT INTO kpjNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tule rarybere: —Aõbo iny‑ribi namyhỹde, kia risurisunymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Inywo‑ribi tahe ròhònymyhỹre ibutumy nohõtinana binahakỹ. Kia heka rare nohõtinana binahakỹ: òta òtalemy, wasilemy, rubudỹỹlemy, ijõ hãbu riòrese ridymy, ");
INSERT INTO kpjNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ibutumy aõna aõna wedu iny ratyrekemy, binamy rõhõtinymyhỹre, ruilemy, aõbina binaõle, itxeredu, aõbina binalemy rybedu, tule itxỹtelemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kia heka ibutumy bina bina inywo‑ribi namyhỹde. Kia heka iny rexisunymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesuisi rexitare. Tahe r re Tiro hãwãreny‑ò, Sidõ beà hãwã hãwã‑ò. Tahe tii ralore hetowo‑txi tahe moõ rierykõdi ixidire hetowo‑txi. Ralòrau tahe, rexiwòke aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Jesuisi tyhynina‑ò hãwyy roholare, tahe tamy nade, tatiowotimy resere. Iriòre‑riki tyytybybina dire. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kia heka hãwyy Grego mahãdu rare. Ilahinanire heka Siru Senisia. Tii Jesuisi‑ò rỹỹraxire tyytybybina iriòre‑ribi deòdỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tahe Jesuisi tamy rarybere: —Txioiny, juhu inihe uladu mahãdu riroxikre. Wadee awiõre uladu‑ribi rỹsỹna ritake ijòròsa‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hãwyy rirawyònyra: —Inatyhy rare, Wãhĩ. Kurile rỹsỹna kyre kyre rejujumahãre. Kòwòruku bese‑ribi, kuladu‑ribi. Kiamy heka itxoòròsa rirakuximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tahe Jesuisi tamy rarybera: —Kia rybe òraru‑ki heka kaa tarybeta tyytybybina ariòre‑ribi rohonyra. Kia bòòsekre aheto‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hãwyy taheto‑ki rehemynyreu, iriòre‑ki rahara byretyre‑ki roire. Hãwyy rieryre tyytybybina iribi ròhònyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tai tahe Jesuisi ixityre rexitare Tiro hãwãreny‑ribi, Sidõ beà hãwã reny‑ò rara Kalileia aho‑ò. Tii raremyhỹu, Debòwiò hãwã hãwã reny ririre. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tahe tamy didydenyde hãbuõ nohõtityõ. Tii roholaõlemyhỹre. Tule awimy rarybeõhyylemyhỹre. Tahe rexitòenyrenyra Jesuisi‑ò, tebò ityre ritidikemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesuisi tii ritare inysõwehekỹ‑ribi tahe tebò ritidire tõhõti‑ò. Tahe rarybexinyre tahe idi tòròtòbymy reare. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tahe Jesuisi tarue ruwyre biu‑txi, ele‑di reare. Tahe rarybere: —Ebata. (Kia heka rybe riwiuròsòdỹỹmy rare, —Biraynyke.) ");
INSERT INTO kpjNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aõwesele tõhõti riraynyre. Tòròtò riykoykonyre. Tii aõwesele awimy rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesuisi rarybere: —Uritere iny‑ò ijyyõmykremy. Ihãrele tahe ibutumy kiamy iny‑ò relyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Idi bede riòtiinyrenyre. Tahe raryberenyre: —Ibutumy tii riteytenymyhỹre. Tii nohõtity aõwesele roholamyhỹre. Hãbu rybeõ aõwesele rirybedỹỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kia txuu ixityre iny sõwemy ributunyre. Kiau tule aõrỹsỹnamy ijõõhyylere. Jesuisi taerydỹỹna mahãdu ixidee ributunyre. Tahe tamyreny rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Jiarỹ inysõwe rewotòenyreri. Tiiboho txuu inataõ waki rỹireri byreõlemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jiarỹ byreõlemy ariteònyrenykeki, ryrowetyakile reserenykre iòderawyrinymy. Tule, iny sõwemy irehe‑ribi nade. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ierydỹỹna tamy dirawyònyde: —Timytaka inyboho tamyreny orotxu rikiwahinyrenykre kabederahy‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tii ritỹỹraxinyre: —Tiwesebo orotxu kai ijõdire. Tiiboho rarybere: —Debò inatxi reuròmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesuisi iny sõwemy risỹdỹỹnykremy sutyre‑ò. Tii orotxu debòinatxi reuròmy rimyra. Tii rexitòenyreu tahe riorore. Tahe riwahinyre taerydỹỹna mahãdu‑ò riwykemy iny sõwe‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tule utura ibutemy rỹimyhỹ. Tahe rexitòenymy rahudi tahe taerydỹỹna‑ò rarybere: —Kaa tule biwybenyke iny sõwe‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tiiboho riroxirenyremy tahe rihydymy ratximyhỹ. Iyre yre rauhenyre riwyrenyre weriri debò inatxi reuròmy riwyrenyre rỹỹximy. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Inaubiòwa mil iny iòhòmy rỹimyhỹ. Tahe Jesuisi rexideòwarinyre iny sõwe‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tii ralore hãworo‑ò taerydỹỹna‑wana. Tiiboho roire Damanuta hãwãreny‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Lahi rybe‑di erydỹỹdu mahãdu nade fariseu mahãdu wahe. Tiiboho tamy nade rybe òbitidỹỹmy. Tiiboho rỹỹraxirenyra bede erydỹỹnaõ kiditeòsinykremy. Lahi rybe mahãdu rierykemy tii inatyhy rare urenana. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tii raelewesenanyre tawo‑ki rarybere: —Aõherekibo kaa iny mahãdu rỹỹraximyhỹre bede erydỹỹnamy. Inatyhymy jiarỹ ararybekre: —Bede erydỹỹna heka tamy rawahidỹỹõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tahe idi Jesuisi rexitare. Hãworo‑ò ralore. Idi rohorere kanawe‑ribi ijà‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ierydỹỹnaboho tahe tõhõti rosare orotxu wydysy‑ribi. Sohojityhyle heka orotxu roimyhỹ hãworo‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesuisi tamy ribedeerynyre: —Beteheiny, biyrubuny, lahi rybe mahãdu, Herodi mahãdu‑wana wirỹsỹna uri‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jesuisi erydỹỹna mahãdu ixideele rarybere: —Aõherekibo Jesuisi kia rarybereri. Inyboho iorotxurenyõreriki òsana. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesuisi heka rieryra tahe rarybera: —Aõherekibo raryberemy orotxu ijõõremy. Kaiboho aõbo teerytenyõte. Kaiboho aõbo arawoxierynyrenyõre. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kaiboho aõbo arueõrenyre. Tabiõletenyteri. Kaiboho aõbo itxi õhõtireny reaõlereri. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jiarỹ 5000my iny‑ò orotxu reareareu, tiwesebo weririmy orotxu yre yre‑di ritỹxinyre. Tahe tiiboho rirawyònyre: —Waòinatxi reurò weririmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tahe debòinatxi reurò orotxumy reòròra 4000 inymy, tiwesebo weriri orotxu yre yre‑di ritỹxinyre. Tiiboho rirawyònyre: —Debòinatxi reuròmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tahe tamyreny rarybere: —Timyrekibo tahe teerytenyõte. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Dehemynyde Besaida hãwã‑ò. Tahe hãbu ruetà‑di tamy didydenyde. Rexitòenyrenyre tamy debò reakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesuisi tebòmy rimyre tahe ridyre hãwã‑ribi bederahy‑ò. Iruetyre rarybexinyre. Tebòmy tamy reare. Tahe ritỹỹraxinyre: —Aõmybo aõbo tabiteri. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hãbu tahe biu‑txi tarue riukora, tahe rarybera: —Hãbumy rabira, òwòru wese rỹireriò, rariareri. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ixityrele Jesuisi tebò reare irue‑ò. Hãbu heka irue reyteramy òbitilemy retehereri. Robire irehetyhy‑ò itỹnyhỹkỹlemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tahe Jesuisi riteònyre isỹ‑ò urile ihãwã‑ribi ròòseõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesuisi taerydỹỹna mahãdu‑wana ròhònyrenyre Sesaria Filipi hãwãreny‑ò. Ryki taerydỹỹnareny‑ò ritỹỹraxinyre: —Mowe hãbureny wamy raryberenyra jiarỹ raremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tiiboho rirawyònyra: —Joaõ Sebedỹỹdu riki, ijõ Eliasi riki, ijõ riki Deuxu rybedỹỹduõ. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tahe Jesuisi tamyreny ritỹỹraxinyra: —Kaiboho, mobo tarybetenyte jiarỹ raremy. Tahe Pedro rirawyònyre: —Kai Kristu atximahãte. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tii raraybinihikỹmy ixi‑ki rarybera: —Inyko wamy ijyyõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesuisi rexiranyre erydỹỹmy: —Deuxu Riòre Hãbutyhyhykỹ heka aõna aõnamy aõhõkỹmy rotỹỹnynihikỹkre. Matuari mahãdu heka ixideramy rynanakre. Tule Deuxu aõmysỹdỹỹdu wedu, Bede ywina erydỹỹ mahãdu ixideramy rynanakre. Jesuisi kudurukre idi tahe txu inataõ rỹidi kedexixakre rubu‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Idi tahe iòrurehekỹlemy tamy rarybere. Pedro iny‑ribi Jesuisi ritare, tahe tamy rarybere: —Kawese rybeõmyreke. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesuisi ròòsemy reare, retehemyhỹ taerydỹỹna‑ò tahe Pedro‑ò rarybere: —Bexitake wako‑ribi Satanasi. Kai dori Deuxu ijoi aõkõ atximahãte. Kai hãbu ijoi tate. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesuisi ributunyre iny sõwehekỹ, taerydỹỹna‑wana tahe rarybere: —Inyõ wahemy kanakeki, ixideele rexirahĩke, tahe taitxeò rimyke riwaheludunykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mobo taumy tarasamy rurukeki, riononykre. Tahe aõtxile iny waluukeki, Rybewihikỹ luukeki, taumy wadee riononykeki, kia heka taumy ritakre. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aõbo tahe awire, ibutumy aõna aõna bitake tai aumy biononyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aõbo tahe iny riwahinykre taumy wydyna òkesena aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kai wijinabòdu òrarudu mahãdu rare, òta òtadu rare. Aõtxile iny walau warybe lau raixỹrukeki, tule Deuxu Riòre Hãbutyhyhykỹ ilau kanaixỹrukre tii nadeu ỹjuwihikỹ‑di boo wowydyna‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tii tamyreny rarybere: —Inatyhymy adeereny ararybekre. Ijõõ kaki ratximyhỹre ruruõtyhy Deuxu Iòlònau taruru‑di kedehemynykreu. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tahe debò sohoji txuu rỹidi, Pedro, Txiau, Joaõ‑wana Jesuisi ridyre. Tiiboho sohojile bederatòò‑ò roire. Jesuisi tamyreny rexiwitxiranyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ityy heka urile rabòtòranyre. Iurahakỹmy relere suròna ratyre heka rauranymy ritoosònyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tahe tamyreny dexitỹnynyde Eliasi, Moisesi‑wana tahe rarybemyhỹre Jesuisi‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro rarybere Jesuisi‑ò: —Wawedu, awityhymy inihe kaki ratxirenyreri tahe rikiwinyrenykre inataõ hetomy, ijõ adee, ijõ Moisesi‑ò, ijõ Eliasi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedro rieryõlemyhỹre aõmybo rarybekemy ruberumyhỹremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nonoe dobehede iubòròna bede ritòbònyre. Tahe rarybere reare rybeuni iy‑ribi: —Kia heka wariòre waluu rare. Kaiboho tamy boholabenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tiiboho reteherenyre tahe inyõ robiõlerenyre. Jesuisilemy robirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dobehedeu tahe inydee Jesuisi rarybere: —Uritere inyõ‑ò tuu ijyyõmykre aõmybo tobitemy. Uritere Deuxu Riòre Hãbutyhyhykỹ rubu‑ribi rexixareu, tai tahe tuu belyybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kia rybe wasimy riworenyre. Ixideerenyle wii ritỹỹraxinyrenyre: —Aõmybo rarybereri, rubu‑ribi rexixamy nade. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tiiboho tamy rỹỹaxirenyre: —Aõherekibo bede ywina erydỹỹ mahãdu rarybere Eliasi juhu kanakremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tii rirawyònyre: —Inatyhymy, Eliasi juhu nade. Ibutumy aõna aõna riywinykremy. Tewesebo raritinanymy rỹireri: —Deuxu Riòre Hãbutyhyhykỹ aõna aõnamy aõhõkỹmy rotỹỹnynihikỹre. Tahe tii inydee awiõhyykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Adeereny ararybekre: —Eliasi nade. Tule iny ixideewilemy tamy riwinyrenyre. Kaheka iaõmydỹỹnana riritinanymy rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","15","Jesuisi dehemynydeu taerydỹỹna mahãdu‑ò, tahe robire iny sõwehekỹmy tahe bede ywina erydỹỹ mahãdu taerydỹỹna‑wana ritxiõnymyhỹre. Tahe Jesuisimy robireu, tahe tiiboho riumysaõnyrenyre. Raòrunyrenyre irybedỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tamy rỹỹraxire: —Aõmybo tamyreny tatỹỹraxinyteri. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Inyõ rirawyònyre: —Erydỹỹdu, wariòre adee redyreri. Tii tyytybybina rybeõhõkỹ‑di ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tyytybybina rimyreu tahe riatyre bede‑ò. Idi tahe urile txuu riyiyinyre. Tahe tii rubureriwesele roire. Aerydỹỹna‑ò jiarỹ rarybera tyytybybina riteranykremy, tahe tiiboho iruruõhyymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesuisi tamyreny rarybere: —Tiwesebededỹỹnanabo wijinabòdu ityhyõlemy rỹira. Tiwesebededỹỹnanabo awanareny ariijekemy. Wadee uladu bididyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tahe didydenyde Jesuisi‑ò. Jesuisimy robireu tahe tyytybybina urile raitxỹteitxỹtenymy resere. Idi tahe urile bede‑ki rara òhòremy raratymyhỹ rybexi irywomy ròhònymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesuisi rỹỹraxire uladutyby‑ò tiubedemybo taheka kaa binana tamy dehemynyde. Tii rarybere: —Uladuylaule idi ròrarunyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tiwese wese aõkõ idi rehure bera‑ò, heòty‑ò rahukemy. Aõ biwinykeki, jiarỹboho biwawiòhenanyke wijile. Kai biwaruxetòenybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesuisi rarybere: —Kai bityhynykeki, ibutumy aõna aõna rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aõwesele uladutyby ryryre idi tahe rarybere: —Jiarỹ retyhynyre, biwiòhenanykre aõbo rauhenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesuisi iny sõwemy robire wii rotyrerimy, tahe riteranyre tyytybybina‑ò: —Kai tyytyby rybeõ tule roholaõ iribi bòhònykre, tiu ixityre malòõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tyytybybina ryryre. Uladu ritxỹtenyre idi tahe ròhònyre. Uladu rubuwesele roire herimy. Tahe iny sõwemy rarybere: —Tii rurura. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesuisi rimyre tebò ritamadỹỹnyremy tahe uladu rỹire lamamy. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Heto ralorenyreu ierydỹỹna mahãdu tamy rỹỹraxirenyre: —Aõherekibo jiarỹboho tyytybybina riteònyõrenyra. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tamyreny rarybere: —Kaiboho bexitòenybenykeki byreõna‑di bonybenykeki, kiawesele heka ròhònyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iribi ròhònyreu, Kalileia lowysy‑di roirenyre. Jesuisi heka inyerydỹỹderamyhỹ tai ratximyhỹki. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Taerydỹỹna mahãdu Jesuisi rierynanymyhỹre. Jesuisi tamyreny rarybere: —Deuxu Riòre Hãbutyhyhykỹ heka rawahidỹỹkre hãburenyõ‑ò. Tii hãbureny rirubunykre. Idi tahe txu inataõ txuu rỹidi tahe kedexixakre rubu‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tiiboho rierykõlere tahe ruberurenyre tỹỹraxidỹỹki. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Idi tahe rehemynyre Kafanaõ‑ò. Ralore heto‑ò. Jesuisi tamyreny rỹỹraxire: —Aõmywe widee tarybetenyteri ryro‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tiiboho urile roholarenyre rybeõlemy. Ryro‑ki dori rarybemyhỹ mowexe wiribi aõnimy ròhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tahe Jesuisi ronyrenyredi, Jesuisi taerydỹỹna mahãdu ributunyre erydỹỹmy: —Inyõ juhuludumy rarekemy ratxikeki, tai heka tii ihewoludukre. Tule tii reakre ibutumy deòdumy. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tahe Jesuisi uladuõ rimyre risỹnyre iubetya‑txi tahe taerydỹỹna‑ò rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Moõ uladu kawese wadee riwiòhenanykeki, riwawiòhenanyre. Moõ riwawiòhenanykeki, tule wateòdỹỹdule riwiòhenanyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Joaõ tamy rarybere: —Erydỹỹdu, jiarỹboho tuu rabirenyra inyõ tyytybybina‑di ani‑ò rehureriò. Tahe iny mahãdureny aõkõ rare. Tahe jiarỹboho tamy reijõnyrenyre iny mahãdureny dori aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tahe Jesuisi rarybere: —Biijõnybenyõkre. Inyõ wani‑di bedeòby riwinykeki, wanimy heka ibinamy rarybeõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iny òluduõkeki, tii heka iny ijoi rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Inyõ beõ adeereny waninamy riwahinykre‑wana, kai waerydỹỹna dori tate, inatyhymy adee ararybekre. Tii tawahidỹỹna ritakre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Inyõ kaa uladu ityhydỹỹdu riatykre òraruna‑txi, kia heka tamy awire tòti‑ki myna ritaamy idi bera‑txi rehure. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ebòle araatykeki òraruna‑txi, juhuule adee awire ebò biòròke. Kia heka awityhykre iny welytyle ralokre biu‑ò, tahe awiõtyhykre heòtytòteehekỹ‑ò ralòkeki debò inatxi‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tai mohõ ruruõtyhy. Heòty ruruõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Awa araatykeki òraruna‑txi, juhuule adee awire awa biòròke kia awire iny rariake awa sohojilemy, awiõre heka heòtytòteehekỹ‑ò ralokre awa inatxi‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tai mohõ ruruõtyhy. Heòty ruruõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Arue araatykeki òraruna‑txi, bitake idi behuke juhuule adee awire arue sohoji‑di Deuxu Iòlò biu‑ò ralokre, tahe awiõre heòtytòteehekỹ‑ò ralokre arue inatxi‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tai mohõ ruruõtyhy. Heòty ruruõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ibutumy iny heka heòty‑di rijyyranykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jyyra heka awire, saa wahe. Urile taruru riononykeki, tiwesebo tarỹsỹna uri ixybyle tawo‑ki bitidikre. Kaiboho ibutumy widee eysarenylere. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesuisi iribi rexitare. Tahe rare Judeia bede bede‑ò, tule Jordaõ kanawe‑ribi ijà‑ò. Iny sõwemy tamy ributunyre, tahe tiiboho Jesuisi rierynanyre. Tii reòarimy tuu ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tamy lahi rybe‑di erydỹỹdu mahãdu dehemynydenyde irutaadỹỹrenymy. Tahe tamy rỹỹraxinyre: —Hãbu aõbo tahãwyy ririleke, awire aõbo ibinare aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tahe Jesuisi tamyreny rirawyònyre: —Aõrybe bede ywina‑di Moisesi rierynanyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tahe tiiboho Jesuisi‑ò dirawyònydenyde: —Tii rierynanyre iny tahãwyy ririkemy. Urile juhuu hãwyy bede erydỹỹna rybe tyyriti riwinykemy, idi tahe tahãwyy ririkemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesuisi tamyreny rarybere: —Õhõtitxyre dori Moisesi kia rybe bede ywina adee riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Juhu bedeu Deuxu riwinyre hãbu, hãwyy‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Iurenana tahe hãbu tadibohosỹ‑ribi ròhònymyhỹre tai roimyhỹre hãwyy‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Hãbu inatyhy hãwyy‑wana roimyhỹreu, sohoji tyhylemy radenymyhỹre. Iny inatxi inymy aõkõ rỹimyhỹre, sohoji tyhylemy rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hãbu hãwyy‑wana Deuxu ributunyreu, iny iwitxira wiribi ritòhòrarienyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hetowo‑ki tahe ierydỹỹna ritỹỹraxinyre kia rybe‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesuisi tamyreny rarybere: —Aõtxile hãbuõ tahãwyy ririkeki tahe ijõ‑wana roikeki, kia heka òtadu rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Hãwyy tahãbu ririkeki tahe ijõ hãbu‑wana roikeki, kia heka wedena rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tiiboho tamy didydenyde uladu tamy debò reakemy. Tahe ierydỹỹna riononymy rarybere tamy idyrenyõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesuisi kiamy robireu, rikyaranyre rarybere: —Txiò, kididyke uladu wadee. Uladu wese dori Deuxu Iòlòna rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Inatyhymy ararybekre: —Moõ heka uladuwesemy Deuxu Iòlòna ralòõkeki, kia heka Deuxu Iòlòna‑ò ralòõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tahe Jesuisi rexiranyre uladu manamy taaxiò‑ò rimyre. Tahe tebò iratyytyre ritidimy tamyreny rarybewihikỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tahe Jesuisi rydi raloreu, hãbuõ tamy reare. Tahe hãbu iko‑txi resere tatiowotimy. Rarybere: —Erydỹỹdu wihikỹ, aõwexe ariwinykre biu‑ò hena aritakremy tiiehyymy umywihikỹ‑di ararekremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesuisi tamy rarybere: —Aõherekibo wihikỹmy wadee tarybeta. Hãbu awiõre. Deuxu sohojile tahe awire. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Bede ywina kai teeryte: rubudỹỹõmykemy, tule òta òtaõmykemy, wasiõmykemy, tule ruiõmykemy, iny wii itxenadỹỹõmykemy, adi bityhynykemy, boo tule. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hãbu tamy rarybere: —Erydỹỹdu, kia bede ywina rewinyhyylere, uladuule wiji‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesuisi tamy retehere tuu reòarire tahe rarybere: —Kai sohoji aõmydỹỹnale aki nasiranyde. Kai makre, ibutumy aõna aõna‑di bòhònykre, idi tahe idi biwahinykre iny aõkõ mahãdu‑ò. Kia tahe aõmydỹỹnadikre biu‑txi. Tahe manakre biwaheludunykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kia rybe‑ki heka hãbu rabedewore. Rexitare ibedewomy urile iaõna aõna sõwetyhyreki. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesuisi retehemy iwerura‑di tahe rarybera taerydỹỹna‑ò: —Kia iny iaõna aõna sõwemy rỹireri, tamy Deuxu Iòlòna‑ò ralòke isirare. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ierydỹỹna mahãdu bede ribedeòtiinyrenyre irybe‑ki. Jesuisi ixityre rarybere: —Waexiboho, isiratyhy rare Deuxu Iòlòna‑ò ralòkemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamelo tyyrorenawo‑di ralòkemy isirakeki, kia‑ribi isiratyhyre iny iaõna aõnadikeki ralòke Deuxu Iòlòna‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tiiboho bede ratiinyre sõwemy. Widee rarybere: —Mobo tahe iòraru‑ribi iny ritakre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesuisi iwerora‑di retehere tahe rarybera: —Inatyhymy kõaõboka hãbu‑ò isiratyhyre. Deuxu‑ò tahe ibutumy aõna aõna isiraõre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro rexiranyre rarybere: —Boholake, jiarỹboho ibutumy rerirenyra araheludunykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesuisi rarybere tamy: —Inatyhymy adeereny ararybekre. Moõ waluukeki, rybewihikỹ luukeki, kia heka ririkre: heto, taseriòre, tyby tadi‑wana, tariòre, tabede, ibutumy ririkre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Wijile itarasamy rarekre: 100 sỹmy, 100 seriòre, 100 tybyboho, 100 tadiboho, 100 tariòreboho, 100 tabede. Iny tamy rarybebinanykre tule. Ijõ bede kanakre tahe taumy tỹmyra‑di tiiemy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tahe sõwere juhu ludu ihewomy ròhònykre. Ihewo ludu ijõ iko‑ò ròhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tiiboho rydi raòwònyrenyre Jerusalẽ hãwã‑ò. Jesuisi heka rare ikorenymy. Ierydỹỹna mahãdu bede ribedeòtiinyre. Tiiboho Jesuisi riheludunymy ihewo‑ribi. Tahe Jesuisi reraòmyhỹ idi rare waòinatxi reurò taerydỹỹna mahãdu‑wana. Tii relyyre ixityre aõbo ixidee kỹnyikremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Boholabenyke inyboho roirenyreri Jerusalẽ‑ò. Kowa, jiarỹ Deuxu Riòre Hãbutyhyhykỹ, inyõ riwawahinykre Deuxu aõmysỹdỹỹdu mahãdu wedu‑ò, bede ywina erydỹỹ mahãdu‑ò. Kia warubudỹỹmy riwawahinykre tori‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tiiboho kidiwalahikre. Watyre kanarybexinykre. Òhòte‑di kidiwahãtenykre. Idi tahe kidiwarubunykre inataõ txu‑di. Tahe rubu‑ribi adexixakre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Joaõ, ijõ Txiau, wii Zebedeu riòre, tamy nade. Tahe rarybere: —Erydỹỹdu, kai aõma aõ wadeereny biwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesuisi rarybere: —Aõbohe jiarỹ adeereny ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tahe tamy rarybere: —Kai, aiòlònasỹ‑ò kedehemynykreu, aruruwe‑ribi aronykre, waseriòre ahywewe‑ribi ronykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tahe Jesuisi rarybere: —Kaiboho teeryõlemahãte aõmybo texitòenyteri. Kaiboho aõbohe wabemona‑di biõbenyke idi Jerusalẽ‑ò adiõkremy wahãredi. Kaiboho aõbohe wasebena‑di mohõlebenyke idi jiarỹ anohõkremy wãhãredi. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tiiboho dirawyònyde: —Kohe tulekre. Jesuisi tamyreny rarybere: —Bemona‑di ariõkre kaiboho tule idi biõbenykre. Sebena‑di jiarỹ adohõkremy, kaiboho tule idi mohõbenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tahe mobo wabire ronykre ruruwe‑ribi hywewe‑ribi kia heka jiarỹle ariwahinyõkre. Kia tahe iyrubudỹỹmy rỹireri Deuxule kidiwahinykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tai debòwiò erydỹỹna mahãdu heka Joaõ‑ò, Txiau‑ò tamyreny iky reare. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesuisi tamyreny ryryre tamy kanakemy, tahe rarybere: —Kaiboho teerytenyte toriwedu irurusõwe dire. Iny nihikỹ heka inymy deòdu luure. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jesuisi kiamy rarybere: —Kia wese tahe aworeny‑ki aõkõkre. Kaiboho aõtxile mobo bòityhynyhyykre, ijõ iny deòdumy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mobo juhutyhy rarelekre, deòdumy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Deuxu Riòre Hãbutyhyhykỹ nade teòdu sõwekemy aõkõ tahe ixilemy reòdunykemy. Nade taumy wahidỹỹmy sõwemy iny tarasamy. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Idi tahe roire Ijeriò hãwã‑ò. Jesuisi taerydỹỹna‑wana iny sõwehekỹ‑wana ròhònyrenyra. Tahe rahare Bartimeu ruetàhàkỹ‑ki. Bartimeu tahe Timeu riòre rare. Tii ronyre rywe‑ribi aõna aõnamy rexitòenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tii roholare Jesuisi Nazare ludu kia rare tahe tamy ryryra: —Jesuisi, Davi riòre, wadee maruxetòekre. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sõwemy tamy rarybere: —Rybeõmyke. Tahe aõhe‑wana tii rarybemyhỹre: —Davi riòre wadi mawotòeke. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesuisi riyryre tahe rarybere: —Tamy byryke wadee kodoikemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tahe rexitareu rỹire, wylemy nade Jesuisi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesuisi tamy rarybere: —Aõmybo kai taruteri adee ariwahinykremy. Tahe hãbu ruetàhàkỹ tamy rarybere: —Wawedu, ixityre arobikremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesuisi tamy rarybere: —Makre, atyhydỹỹna kai arateytenyra. Kialehe rare. Aõwesele ixityre tii robire. Tahe Jesuisihemy rare, ryki. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalẽ iòhòmy ritehemynyrenyreu, tahe inatxi taerydỹỹna riteònyra hãwã‑ò. Inatxi hãwã‑ò iòhòmy, Betabaji, Betỹnia‑wana. Kia‑ò Oliveira hãwãlò roire. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jesuisi rarybere: —Kaiboho boikre kowa hãwã‑ò. Kowa‑ò birònykreu jumentinho mahabenykre. Moheka ityre rariaõlemy ratximyhỹre. Bieseke, wadee bididyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Inyõ adeereny rarybekeki: —Aõhekremybo idi atxitenyteri. Tahe tamy marybebenykre: —Wanyrỹ tuu rurureri. Ixityre kaò kidiòkesedỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tahe hãbu roire. Jumentinho ryro hetoijò‑ki ritisanymy rỹimyhỹ. Tai riesere. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Kia hãwã mahãdu rarybere: —Aõherekibo jumentinho kaiboho tetatenyta. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tai tiiboho Jesuisi rybe tamy riwahinyra. Tai hãwã mahãdu jumentinho riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tahe ridyrenyre jumentinho Jesuisi‑ò. Tiiboho tatyyreny ritidirenyre jumentinho tyremy. Tiiboho risỹnyrenyre Jesuisi ityre‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ijõboho tahe horerule ritidire ryromy, ijõ tahe tauwòhi ryromy ritidire ityre rariakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Ihewo ludu, iko ludu rawyhyrarònyreri, tule ryryreri: —Tii heka wowydyna rare. Tii heka Wanyrỹ niwesekemy naderi. Wowydyna rare iny labie Davi Iòlòna. Kai Iòlòna kanakre. Wyhyrarò biu‑txi kodoholakre. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kia wese Jesuisi ralore Jerusalẽ‑ò. Dohodỹỹna heto‑ò ralore, ibutumy retehere, idi tahe ròhònyre txiorotyhyreki. Tahe Betỹnia‑ò roirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ijõ txu biòwamy tahe Betỹnia‑ribi rexitarenyreu tahe tii rama rahure. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Òwòru figueira rademy robirenymy irehe‑ribi. Tahe tamy ritehemynyreu iraty‑ki raharenyõlere, aõmyreki figueira raty bededỹỹnanamy aõkõ bede rỹimyhỹre urenana. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Òwòru figueira‑ò Jesuisi rarybere: —Tiu heka moõ araty ritòõtyhy. Tahe ierydỹỹna roholare. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tahe ritehemynyrenyre Jerusalẽ hãwã‑ò. Tahe Jesuisi dohodỹỹna hetowo‑ò ralore. Tahe kia‑ribi aõna aõna‑di rohonymyhỹre mahãdu, õbradu mahãdu diteònyde. Tahe nieru wibydỹỹdu mahãdu, òwòrubesedỹỹ‑di Jesuisi rehure. Bòtòe dinodu mahãdu rynana‑di Jesuisi rehure. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Inyõ heka ritxyydỹỹnyõlere dohodỹỹna hetowo‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Rierynanymyhỹre tahe tamy rarybere: —Raritidỹỹõlemy aõbo rỹireri: Waheto kõaõboka inatyhymy ibutumy iny witxira witxira dee ixitòedỹỹna hetomy rỹirakre. Waheto tewinytenyte wasidu hetowesele. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bede ywina erydỹỹ mahãdu, Deuxu aõmysỹdỹỹdu wedu mahãdu roholarenyreu, rõhõtinyrenyre: —Timybo inyboho Jesuisi rubudỹỹmy rokiwisỹnykre. Tiiboho ruberumyhỹrenyre iny sõwemy dori bede riòtiinymyhỹ ibedeerydỹỹnareny‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Txioromy dehemynydeu, tiiboho rexitarenymyhỹre hãwãhãkỹ‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Txu ròhòny‑di, rehemynyrenyre òwòru figueira‑ò. Tiiboho robirenyre rarubumy rỹireriò, taru‑wana, tararoti‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro ixi‑txi tõhõti reare tahe rarybere: —Erydỹỹdu, betehe inihe aõma òwòru figueira rarubumy rỹire arybebina‑di tamy tarybetaki. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesuisi dirawyònyde: —Kaiboho Deuxu bityhynymyhỹbeny. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Inyõ rarybekeki kaa bede ratòòhòkỹ‑ki: —Kai myike, adi adehu rỹikre berohokỹ‑ki. Tahe irybe heka kedelekre. Tai inyõ rityhynykeki, tumy heka kedelekre. Tahe uritere iseõdỹỹõmykre urile bityhynykre, irybe heka kedelekre. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iurenana adee ararybekre: —Aõtxile aõ bexitòenykre, kia heka bitakre. Bityhynykeki, inatyhymy bitake. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kaiboho texitòenytenyteri wana aõbo inydee aky reamyhỹre kia biixãwididỹỹnymyhỹke ratximyhỹre, Deuxu dori riixãwididỹỹnyke aòrarureny‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kai iny witxira òraru biixãwididỹỹnyõkeki, boo biu‑ki ratximyhỹre aòraru riixãwididỹỹnyõkre. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tiiboho ixityre doide Jerusalẽ hãwã‑ò. Ririranymyhỹrenyreu dohodỹỹna hetowo‑ki, bede ywina erydỹỹ mahãdu, Deuxu aõmysỹdỹỹdu wedu mahãdu, matuari mahãdu tamy doide. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tiiboho tamy ritỹỹraxirenyre: —Mowe ateòdỹỹdu kia aõna aõnamy tatỹỹnymyhỹte. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesuisi dirawyònyde: —Adeereny tule araỹraxikre. Kaiboho bidiwawyònykeki, tahe jiarỹ akoreny ỹraxina arelyykre, aõrurudibo aõna aõna rewinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tahe Jesuisi ritỹỹraxinyre: —Ratyysebedỹỹna, Joaõ hõrõ, kia heka tiribibo nade, biu‑ribi ada hãbu mahãdu‑ribi. Kia manarybeke. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tiiboho widee rarybera: —Biu‑ribi inyboho raryberenykeki, tai tii rarybekre: —Aõherekibo tahe tii tetyhynytenyõte. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hãbu‑ribi inyboho raryberenykeki, iny aruberumyhỹrenykre. Ibutumy iny rityhynyre Joaõ heka Deuxu rybedu raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tai tahe tiiboho raryberenyre: —Inyboho reeryõrenyre. Tai tahe Jesuisi rarybera: —Hebo, jiarỹ adee arelyyõtyhy modeòdỹỹdubo jiarỹ watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iribi tahe Jesuisi tamyreny ijyy‑di rierynanymyhỹre: —Hãbu uva oworuõ wese ròbròre. Tahe riòtitynyre. Tahe hãloo riare oworuubetya‑ki, ruỹdỹỹnymy. Tahe utò riwinyre. Idi tahe rihuòtere hãbu mahãdu‑ò. Tahe rexitare tasỹ‑ribi ijõ bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tahe bederatysiredemy bededỹỹnana rehemynyreu, iwedu teòdu riteònyre bederaty ritakemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Huòtedu mahãdu teòdu rimyrenyre, rihetenyre tahe riteònyre ixihyykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ixityre oworuwedu teòduõ riteònyre. Kia heka irati rihetenyre ta tamy rawobinarybenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ijõ riteònyre. Kia heka rirubunyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tahe oworuwedu iriòre sohojilere, tahe iluumy raremyhỹ ihewomy tii riteònyre. tahe wedu rarybere: —Wariòrele heka tiiboho rityhynyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kia huòtedu mahãdu widee raryberenyre: —Kia heka wedu aõna aõna tarasadu rare. Rikirubunykre tahe iaõna aõna inydeerenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tahe rimyrenyre idi rirubunyre tahe idi rehurenyre oworu‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesuisi ritỹỹraxinyre: —Aõhebo tahe oworuwedu rotỹỹnykre. Tii kodoikre huòtedu mahãdu hudumy, tai tahe oworu riwahinykre inywitxira‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Ritina‑di aõbo tariaõletenyte kia ryberiti: —Mana‑di hetowidỹỹdu rehura. Kia mana heka hetohàtxi‑ki ritidimy doide. Kia heka Wanyrỹ riwinyre kia iny ruereny dee aõna aõna nihikỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tai ijohonadu mahãdu Jesuisi mynymy ratximyhỹ tii dori rieryre ixidee lau Jesuisi ijyymy relyymyhỹre. Tiiboho ruberurenyre iny sõwehekỹ lau. Tahe rexitarenyre, rexixãwidinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Idi riteònyrenyre Lahi rybe‑di erydỹỹdu mahãdu, Herodi mahãdu‑wana tamy imynamy irybe‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tiiboho rarybere Jesuisi‑ò: —Erydỹỹdu, jiarỹboho araerymy adi watxiwãhãrenyre kai inatyhy hãbu tate. Iny ibutumy adee wiwese wiweselere. Inatyhymy iny‑ò Deuxurymy teerynanymahãte. Tahe tiiboho ritỹỹraxinyrenyre: —Awire aõbo ada ibinare aõbo nieru rawahinymyhỹre bede dinodu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Timybo tahe, rikiòwyny aõbo ada aõkõre aõbo. Jesuisi rierymyhỹre tõhõtinanareny, tahe ritỹỹraxinyra: —Aõherekibo kaiboho tiwaurihitenyteri. Wadee womati nieruõ bidiwy waitxerenamy. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tahe tamy diwydenyde. Tahe tii ixityre ritỹỹraxinyra: —Kawe moõ tyytarasana rare, katahe moõ tyyritina rare. Tiiboho dirawyònyde: —Kiahe bede dinoduhõrõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesuisi rarybere: —Hỹdebo, bede dinoduhõrõ tahe tamy biwahinybeny tule tahe Deuxu aõna aõnahõrõ tamy biwahinybeny. Tiiboho bede riòtiinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduseu mahãdu tamy nade. Kia heka iny rubu‑ribi rexixamy aõkõre‑riki rierynanymyhỹre. Tiiboho ritỹỹraxinyre Jesuisi: ");
INSERT INTO kpjNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Erydỹỹdu, Moisesi raritinyra bede ywina‑di: —Hãbuõ rurukeki, tahãwyy iriòre ijõdiõkeki, tahe kia hãwyy tahãbu seriòre‑wana roike. Iriòredikre taseriòre rubuòwymy roikre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Seriòre debòinatxi reuròmy raremyhỹ. Juhuu ijõ roire hãwyy‑wana. Tahe tii rurure iriòreõlemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tahe ihewo ludu iseriòre wytese‑wana roire. Tii rurure iriòreõlemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ihewoludutyhy tule ibutumy roire wytese‑wana, tahe ituerenyre iriòreõlemy. Iròòbymy tahe hãwyy tule rurure. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ixixanau tahe mohãbubo tuu rarekre. Ibutumy dori wytese‑wana roire. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tai tahe Jesuisi tamyreny rarybere: —Kaki kaiboho teòsamy toite aõma ritina teeryõtenyteki. Tule Deuxururu teeryõtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ixixanau heka moõ roiõtyhy. Ibutumy iny ỹju wese rarekre biu bede‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kaiboho aõbo tatyyritinytenyõta iny rubu‑ribi kedexixakremy. Kia heka raritinymy rỹire Moisesi tyyriti‑ki, òwòrusõmo ijyy‑ki rỹimyhỹ. Iwese Deuxu rarybere Moisesi‑ò: —Jiarỹ heka Abraõ Deuxu rare. Ijai Deuxu rare. Ijaò Deuxu jiarỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jiarỹ heka rubu mahãdu Deuxu aõkõ rare, tahe iru mahãdu Deuxu jiarỹ rare. Kaiboho teòsamy toite. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bede ywina erydỹỹ mahãduõ nade ijohonamy. Tahe tiiboho widee raryberenymy roholareu, Jesuisi tamyreny rirawyònywihikỹreu, tahe tii Jesuisi‑ò ritỹỹraxinyre: —Tibo rybe bede ywina juhuure. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesuisi rirawyònyre: —Ka heka juhu ludu rare: —Boholake Israeli mahãdu, judeu ijoi mahãdu wahe. Wanyrỹ, iny Deuxu sohojile rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kia aDeuxu luuke ibutumy awo‑ribi, aumytyytyby‑ribi, ibutumy aruru‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ka heka ihewo ludu rare: —Kai abireluduluuke iwese ixiluuke wese. Ijõ bede ywina heka ka ratyreõre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tahe Bede ywina erydỹỹ mahãduõ rarybere: —Inatyhymy kai tarybeta. Deuxu heka sohojile ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ibutumy awo‑ribi iluukemy. Ibutumy aruru‑wana iluukemy. Tule ibutumy aeryna‑wana iluukemy. Iwese kai ixiluure wese, abire ludu mahãdu luukemy. Kia heka ibutumy iròduxiweloo ratyre rare. Ibutumy wahidỹỹnaloodỹỹna ratyre rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesuisi rieryre kia hãbu rirawyònywihikỹre tai tamy rarybere: —Kai heka Deuxu Iòlòna‑ribi irehemy aõkõ. Tai tahe ibutumy ilau ruberure tỹỹraxidỹỹki. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesuisi dohodỹỹna heto‑ki rierynanymyhỹreu, rarybere: —Timybo Bede ywina erydỹỹ mahãdu rarybemyhỹre Kristu Davi riòre raremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davi rarybere aõmybo Deuxu Tyytybytyhy tamy narybedemy: —Wanyrỹ rarybere Wanyrỹ‑ò: —Bodony warurunawe‑ribi. Txiòhe rare, aòludu awarawo‑txi aritidikre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tahe Davile Wanyrỹ rininire. Timybo tahe Davi iriòremykre. Tahe iny sõwemy deysana‑di roholarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tii rierynamyhỹreu, rarybera: —Bexiemyhỹbeny bede ywina erydỹỹ mahãdu lau. Tiiboho heka tyyrehe‑di riraluurenyre. Tiiboho heka rybedỹỹluurenyre hãwãhãkỹ riranaki. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Dohodỹỹna heto‑ki juhurynana luurenyre. Tule ta anarỹỹ rỹiwana, juhu rynanadile tamyreny awire. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tiiboho tule wytese urimynydu aõna aõna ritarenyre. Ixitòedỹỹna rehehekỹ rexitòenymyhỹrenyre. Tiiboho heka aõnihikỹmy aõhõkỹmy dỹỹnana riòwynyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesuisi retehemy rỹimyhỹ dohodỹỹna heto nieruhyna ratya‑txi. Tii retehere timybo iny sõwemy tanieru‑di tamy rehumyhỹ. Tahe ityhynihikỹ tamy sõwemy nieru‑di rehure. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tahe nade wytese iaõkõdu mahãduõ tii rare. Tii inatxi nieru sõmo‑di rehure. Tanieru tahe nierukonana rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesuisi ryryre taerydỹỹna‑ò: —Inatyhymy adee araybekre. Kowa heka wytese nieru‑di rehure ibutumy iny witxira ratyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kaa mahãdu ibutumy nieru‑di rehure rauhenyredile. Tahe wytese idi rehure ibutumy tanieru‑di rexihumy taumy‑ribi idi rehure. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Dohodỹỹna heto‑ribi ròhònyreu, ierydỹỹna tamy rarybere: —Erydỹỹdu, beteheke inihe mana nihikỹ‑ò, hetohokỹ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesuisi rirawyònyre rarybere: —Kaiboho betehebenykre heto nihikỹ‑ò. Kia heka mana ijõ wityre‑ki rỹiõtyhy, ibutumy heka kedejuxunykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Oliveira bederatòòhòkỹ‑ki tii ronyreu dohodỹỹna hetoko‑txi, tahe Pedro, Txiau, Joaõ, ibutumy tamy doide rỹỹraximy iny‑ribi irehemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Wakoreny bedelyyke, tiubo kia kỹnyikre. Ibutumy aõna aõna kỹnyikre wana tibo iny bedeerynyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesuisi rexiranyre tamyreny rarybere: —Kaiboho anaitxenanydenyheny lau bexiebenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sõwemy dori roikre wanimy rarybemy rarekre: —Jiarỹ dori Kristu rare. Tahe iny sõwemy anaitxenanykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kaiboho wounarybe‑ò, aõbinarybe‑ò, boholakreu, breburenyõmykre. Kia heka kanakremy ratximyhỹre. Urile bededỹỹnana ikonanamy aõkõhyylemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Uritere inylahinareny, ijõlahinareny‑wana wii kidiaõbinanykre. Tule iòlòna mahãdu ijõ iòlòna mahãdu‑wana wii kidiaõbinanykre. Bede bedesu ijõ hãwã‑ki kanamytatakre. Tahe aõkõre rama kedeakre. Kia heka juhu aõhõkỹmydỹỹnana rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kai bexiekre anamydenyheny lau. Tiiboho anawahinydenykre aòludu wedu‑ò, iòlò‑ò. Tiiboho anahatenydenykre dohodỹỹna hetowo‑ki. Kiabohoko‑txi wadee kaiboho kedelyykre inatyhymy aõna aõna rỹiremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Rybewihikỹ juhuu ibutumy bede hãwã hãwã‑ò kiditỹnydỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tiubo aradyrenykeu, urile nohõtiõmy aõbo kaiboho marybebenykre. Kiautyhyle aõmybo rarybekremy bierykre. Kia tahe marybekre. Kai dori aõkõ tarybemahãte, Deuxu Tyytybytyhy tahe rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Seriòre seriòrele wii kidirubunykre. Tyby heka tariòre kidirubunykre. Uladule tadi, tyby kidirubunykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ibutumy heka iny iy kedeakre wani òraru‑ki. Kia heka ikonana‑ò riijekreu, taumy tarasanakre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aõna aõna binahakỹ kanakreu, ibutumy rahukemy. Tiiboho kanakeu itxinonana‑txi aõkõ rarekemy, kaiboho mahenybenykre bederatòòhòkỹ‑ò, Judeia hãwã hãwã‑ki ratxikeki, mahenybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Inyõ hetotyre‑ki ratxikeki, urile ròteõmy aõna aõna wydysymy. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Inyõ bedero‑ki ratxirekeki, uritere òkeseõmy tyy òrysymy. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kobexe heny hãwyy bòtòmy rỹira, tule hãwyy tariòre ritònymy rỹira. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bexitòenykre kia kanaheny bededỹỹnana sirau. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Aõhõkỹmydỹỹnana kanakre tiu heka tuuõre. Juhule Deuxu bede riwinyreule wiji tuu yrubule bede roimyhỹre. Tiu heka kiamy bede roiõtyhy aõhõkỹmydỹỹnanamy. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Deuxu bede iòhòmy rirawetyyòròkeki, moheka irumy ròhònyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Inyõ adee rarybekeki: —Kaki heka Kristu ratxireri. Kowa‑ki ratxireri. Uritere ityhydỹỹõmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sõwemy Kristu kanakre, urile Kristu inatyhy aõkõ rarekre. Tule Deuxu rybedỹỹdu kanakre. Kia Deuxu rybedỹỹdu inatyhy aõkõ rarekre. Tiiboho heka bedeòby riwinykre tule bede eryna. Deuxu hõrõ riitxenanykemy inatyhymy kõaõboka. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kaiboho warybe biyrubunykre. Adee ibutumy juhuule reòbitinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Idi webòhòna rỹira txuu, aõhõkỹmydỹỹnana itue‑di, txuu heka rurunykre. Ahãdu tule rurunykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Taina heka kedejuxunykre biu‑ribi. Biururu raòweòwenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Iny retehekre Deuxu Riòre dehemynyna‑di. Biurawetyky‑ribi kodobehekre. Kia heka lobixina kanabòtòranykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tahe taỹju kiditeònykre tawedu ijoihõrõ butudỹỹmy. Kidibutunykre ibutu bede bede konana‑ribi, tule ibutu biukonana‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Tahe figueira òwòru‑ribi erydỹỹna bierybenykre. Tahe iruru raixinykreu tahe, txiru ròhònykreu, tai tahe bierybenykre wyra iòhòreri. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tule kia aõna aõnamy bobibenykreu, tii iòhòlereri. Ijòkile wese nyide. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Inatyhymy adee ararybekre, kia wijinabòdu itueõtyhy aõna aõna rỹikre hãrele. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Biu, bede‑wana ituekre, tahe warybe itueõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Moõ heka rieryõtyhy tiubededỹỹnanamybo tii kòdòòsekre. Tule ỹju biutxile rieryõre. Tule iriòre rieryõre. Tule tyby sohojile rieryre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kaiboho bexieke, beteheke. Kai dori teeryõtenyte tiubededỹỹnanamybo kòdòòsekre. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kedehemynykremy dori iwese hãbu tỹimy rarewese tii rexitareu, ririre tadeòdu. Tadeòdulemy tule ridyre itxeredu retehemyhỹkemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tahe betehe inihe teeryõteri dori tiubo kanakre heto wedu, txioromy ada ruwetya aõbo, ada hãnie hãbu ryry‑di aõbo, ada txumy aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Betehe inihe iny araraòõlemy tii rehemynyreri aki rahakre atỹi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aõna aõnamy jiarỹ rarybemyhỹre, rarybera ibutu‑ò: —Biijebeny. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kia‑ribi inatxi txumy riuhenymy ratxireri anarỹỹ kodohònykremy. Kia anarỹỹ wehityhynamy heka iny ratya‑di reare. Tule orotxu anarỹỹ kia ròhònyre. Tule Deuxu aõmysỹdỹỹdu wedu mahãdu tule bede erydỹỹdu mahãdu Jesuisi rimykemy ratxireri idi rirubunykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tiiboho rarybemyhỹrenyre: —Kiahe aõkõre anarỹỹ rỹireriu, iny sõwemy inydeereny kana aõbinanyheny. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesuisi Betỹnia hãwã‑ki ratximyhỹu, Simaõ tyybina heto‑ki ratximyhỹre. Jesuisi òwòru besedỹỹbire‑ki roimyhỹ. Tahe hãwyy aderòna òwynihikỹ‑di lỹnyrena wihikỹ‑di nade. Tai ihyna riwebòhònyra tahe Jesuisi ratityre‑ò ritxiwira. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Inyõreny rexiykaranyke. Tahe widee rarybera: —Aõherekibo aderòna rahura. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Inywitxira tahe iòwynykewi sõwemy nierumy kia‑ò. Kia nieru‑di tahe iny aõkõdu‑ò rawahidỹỹnykre. Tahe tiiboho rexibynyreri hãwyy dee. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tahe Jesuisi rarybere: —Txiòhe rare, uritere ixibydỹỹõmyke. Tii heka aõwihikỹbo wadee riwinyra. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kiamy aõu aõu iny aõkõdu rỹikremy. Aõule heka tamy aõwihikỹ biwinybenyke. Jiarỹ tahe, aki aõu aõu aõkõlekre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tii heka rexikonananymy ròwidỹỹre. Aderòna‑di watyre ritxiwire wabede‑ò jiarỹ raõule. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Inatyhymy adeereny ararybekre. Aõtxile Deuxu Rybewihikỹ iny relyykre. Kia‑ò kahãwyy ijyymy relyykre, ibutumy iny idi rõhõtinykremy aõbo riwinyredi. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tahe Judasi Isariò Deuxu aõmysỹdỹỹdu‑ò rara Jesuisi tamy rawahidỹỹkemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tiiboho tamy roholarenyreu, reysare. Tahe tamy nieru riwahinykemy riurenanyre. Tahe Judasi riijemyhỹre aõu aõu bedewihikỹ tamyreny riwahidỹỹnykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Juhu orotxu anarỹỹtxure budoeni xiweloo rirubuny rahudi tahe Jesuisi erydỹỹna mahãdu tamy rarybere: —Titxibo anarỹỹ rỹsỹnamy biroxikemy atxiteri. Jiarỹboho kowa‑ò aroikre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tahe Jesuisi tamy rarybere: —Kaiboho boikre hãwãhãkỹ‑ò. Tahe hãbu‑wana wii biòbynykre butxi‑di riwyreriò. Tahe tii biheludunybeny. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aõtxile hetoõ‑txi ralòke, kaiboho marybebenyke hetowedu‑ò: —Waerydỹỹdu rarybera: —Titxiwexe anarỹỹ rỹsỹna arirỹsỹkre waerydỹỹna‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tii heka adee kiditeòsinykre hetowowitxiraõ biu‑txi. Ibutumy rexihumy rỹire inydeereny. Kowa rỹsỹna inydeereny biywinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tahe ierydỹỹna rexitare. Roire hãwãhãkỹ‑ò. Tahe ròhònyre iwese Jesuisi relyyre wese. Tahe ibutumy rexihurenyre anarỹỹ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Txiorou Jesuisi nade taerydỹỹna waòinatxi reurò‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tiiboho òworubesedỹỹ riroximahãu, Jesuisi rarybere: —Kaiboho wawana teroxitenyteri sohojiõ biwawahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tahe urihimyò rexiranyre rabedewomy. Tahe widee raryberenyre: —Jiarỹle heka ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tii rirawyònyre: —Kaiboho, waòinatxi reurò mahãdu sohojiõ. Kia mahãduõ orotxu‑di wawana rebenymyhỹ besero‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Inatyhymy Deuxu Riòre Hãbutyhyhykỹ rakre iwese iritina rỹirewesele. Kobexeheny kowa hãbu heka kidiwahinykre. Tamy iny awire kedeaõlede. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tiiboho riroxireriu, Jesuisi orotxu rimyreu, raorore, rexitòenyre, tahe tamyreny riwahinyre. Rarybere: —Ãhãxe, kia heka waumy wese rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tahe vĩĩhynamona rimyre, rexitòenyre, tahe tamyreny riwahinyre. Ibutumy ibute bute iribi tuu riõrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tamyreny rarybere: —Kia wãhãlubu wese rare. Kia hãlubu heka rybe tỹmyra ywidỹỹna hãlubu rare. Kia inyboho kidinohõtijuadenykre. Wahãlubu heka kedejuxunykre iny rabòrònihikỹ dee. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Inatyhymy ararybekre: —Ariõõtyhy heka òtetibederatyrube tỹmyra ihyy tahe tiutxumybo Deuxu Iòlòna‑ki ariõkre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Deuxuwimy rawinyrenyreu, tahe rexitarenyre Oliveira bederatòòhòkỹ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesuisi tamyreny rarybere: —Kaiboho ibutumy wijirumy biwaribenykre. Kia heka iritina rỹire. Itxeredu tahe riròrenykeki, budoeni rahenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tahe rubu‑ribi adexixakreu, arakre akomy Kalileia‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro rarybera Jesuisi‑ò: —Ibutumy ararikeki, arariõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesuisi tamy rarybera: —Inatyhymy ararybekre. Wijirumy hãniehãbu inatxi kydyrykreule, kai iny witxira‑ò biwatxiõnykre inataõ bedemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tahe Pedro rarybera tarurutyhymy: —Aõkõre, aratxiõnyõtyhy, ihãrele tahe awanale arurukre. Ijõ mahãdu tule kia wese rarybera. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tahe roire Kesemani hãwãmy ninadu‑ò. Taerydỹỹna‑ò rarybera: —Biwaraòmy bonykre kakile. Kowa‑ò arexitòenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tii ridyrenyre Pedro, Txiau, Joaõ‑wana. Jesuisi rexiranyre rabedewomy ihyy rexitòenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tahe tamy rarybera: —Watyytyby heka rabedewomy ratxireri rubuhyy‑ò. Kaki bonykre biijemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tahe iko‑txi urihimyò rareu, resere. Rexitòenyre: —Waha, adee arexitòenykre. Adee awikeki, kia òraule tiu waròteõna. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tii rarybere: —Waha, adee ibutumy isiraõre. Kia bemona inyhe waròbi bitake inihe. Tahe wadeewi wadeewi‑ki aõkõ watxireri, tahe adeewi‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tii rehemynyre tai rahare rõrõrenymy roireriò. Rarybere Pedro‑ò: —Simaõ, Tarõteri aõbo. Biijeõtyhy sohoji òramy bededỹỹnana. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Biijebenykre, bexitòenykre, uritere rutaanamy ròteõmykre inatyhymy atyytyby irurudire tahe ade iruruõre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tahe Jesuisi ixityre rare rexitòenyre ixiwesele. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ròòsereu, ijõ‑ki rahare rõrõmy ixiwesele, irurureny rautxienymyhỹ dori. Tiiboho rierykõre idi rirawyònyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tahe ixybyle ròòsere tahe rarybere: —Morõbeny bexielehynybeny. Òra iòhòreri. Kia heka Deuxu Riòre Hãbutyhyhykỹ kanawahidỹỹkre òrarudu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bitỹmynybenyke, rokoireny, walòsedỹỹdu iòhòmy rareri. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tii rarybereriu, aõwesele Judasi nade. Kia heka waòinatxi reurò mahãduõ rare. Tii‑wana doide hãbu mahãdu mayrehe‑di, òhòtemy debòna. Kia heka hãbu mahãdu doide matuari mahãdu‑ribi, Bede ywina erydỹỹ mahãdu‑ribi, Deuxu aõmysỹdỹỹdu wedu‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Lòsedu tamyreny juhuu bede eryna riwahinyre. Kawese heka rarybere: —Kowa heka inyõ‑ò aruwokre, tii heka hãbu rare. Bimybenykre, birarenybenywihikỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judasi rehemynyrenyreu, tahe rarybere: —Wedu, wedu. Tahe tamy ruwore. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Juda ijoi Jesuisi rimyra. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kia ijoiõ mayrehe ritare tahe Deuxu aõmysỹdỹỹdu wedu deòdu nohõti riorore. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tahe Jesuisi dirawyònyde: —Kaiboho mayrehe‑di tiwaòrynyteri wasidu‑wesemy aõmy, òhòte‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Jiarỹ tahe dohodỹỹna heto‑ki watximyhỹ txuõ txuõlemy adeereny araerynanywãhãdenyde. Kowa‑ki heka tiwamyõlemyhỹtenyte. Tahe aõbo iritina‑ki rỹireri, kia heka kỹnyikremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ibutumy ierydỹỹna mahãdu ririrenyre, rihenyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kia heka hãbuõ riheludunymyhỹ tyy tayredile rexityynymy tiiboho ridyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tii tahe tyy ririre tahe rahenyre tadelemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Deuxu aõmysỹdỹỹdu wedu‑ò tiiboho Jesuisi ridyre. Bede ywina erydỹỹ mahãdu, matuari mahãdu‑wana ributunyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro riheludunyre irehetyhytyhymy. Rehemynyre Deuxu aõmysỹdỹỹdu wedu heto‑ò. Tai tahe ixitòteenymy heòtywera‑ò rorukumyhỹ heto itxeredu mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Deuxu aõmysỹdỹỹdu mahãdu wedu, tule dohodỹỹdu mahãdu alobixidu riijemyhỹre aõlemy Jesuisi òludu relyymyhỹre, Kia òraru‑ki rirubunyrenykemy. Rahaõre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sõwemy iny ruimy relyymy rỹimyhỹ. Iruinareny wiribi hitxi hitxilera. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ijõ mahãdu rỹimyhỹre relyyrehãre ruimy rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Inyboho irybe‑ò roholarenymy: Jiarỹ heka dohodỹỹna heto ariixãwididỹỹnykre kia heka hãbu iwidỹỹna rare. Txu inataõ‑di ijõ ariwinykre iwidỹỹnaweseõre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kia heka aõmybo tuu relyyrenyremy irybe wiribi hitxi hitxire. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Deuxu aõmysỹdỹỹdu mahãdu rỹire inysõwetya‑txi. Tii Jesuisi ritỹỹraxinyre: —Kai aõbo biwarawyònykre aõmybo relyyrenyreri adee òludumy. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tii rerawyònyõlere ixyby tahe Deuxu aõmysỹdỹỹdu mahãdu ritỹỹraxinyre: —Kai aõbo Kristu tate, Deuxu wityhy riòre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesuisi rarybera: —Jiarỹ heka. Kaiboho betehebenykre Deuxu Riòre Hãbutyhyhykỹ Deuxu rurunaweribi‑ò ronyreri. Kaiboho tii betehebenykre Deuxu Riòre Hãbutyhyhykỹ biuwetyky‑ribi naderi. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Deuxu aõmysỹdỹỹdu wedu ityy riykara idi rarybera: —Aõherekibo ijõ alobixidumy iny rururenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kaiboho taholatenyta aõbina binalemy rarybereriò aõmybohe kaiboho tahõtinymyhỹtenyte. Ibutumy heka tawo riraòhòrerenyra rubudukremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tahe ijõ ityre rybeximy rarutaara rexiruehetynyre tahe tule rihetenyre. Tahe rarybere: —Mota làhà arahãtenyra. Idi tahe heto itxeredu tule rihetenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro heka ratximyhỹ bedeube‑ki tahe ijadòma dehemynyde, Deuxu aõmysỹdỹỹdu deòdu. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro rexitòteenymyhỹ heòtywera‑ò tahe ijadòma tamy retehere. Tahe rarybera: —Kai tule Jesuisi Nazare ludu‑wana atximahãte. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tahe tii rexitxiõnyre: —Jiarỹ reeryõre aõmybo kai tarybeteri. Tahe Pedro hetowo‑ribi ròhònyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ijadòma ixyby ixyby itxeremy rarybere kowa ijoi‑ò: —Kowa heka tii mahãduõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tahe tii ixityre rexitxiõnyre. Ixybyle kowa ijoiõ Pedro‑ò rarybera: —Inatyhymy kai ijõ mahãduõle tate. Kai dori Kalileia mahãdu tate. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tii inatyhytyhyrybemy rarybera: —Jiarỹ reerykõre hãbumy tarybetenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tahe hãnie hãbu ryryra, inatxi hewoludumy. Ta Jesuisi rybe‑txi Pedro tõhõti reare. Iwese Jesuisi rarybere: —Inatxi hãnie ryrykredi, ihewoludukomy ryrykre, wadee bedexitxiõnykre inataõmy. Pedro tahe iribi rexitareu, rahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Txuu reareu, Deuxu aõmysỹdỹỹdu wedu, matuari mahãdu, Bede ywina erydỹỹ mahãdu ibutumy ributunyre. Tahe Jesuisi ritaataare tahe ridyrenyre Pilato‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato Jesuisi‑ò ritỹỹraxinyre: —Kai aõbo judeu iòlò tate. Tii rirawyònyre: —Kai ka tuu tarybeta. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Deuxu aõmysỹdỹỹdu mahãdu wedu rarybere Jesuisi aõna aõna awimy aõkõ riwinyre. Tahe Jesuisi riwawyònyõhyylere. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato ixybyle rỹỹraxire: —Kai birawyònyõtyhy aõbo. Kai aõbo taholaleteri aõmybo tiiboho autedé‑ò raryberenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tahe Jesuisi rarybeõhyylere tahe Pilato urile bede riòtiinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kia heka juhuu iny deòwarixina rare hãbu ròteduõ ritakemy anarỹỹtxuu. Aõtxile iny tamy rexitòenyke. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ròtenawo‑ki raremyhỹ inyõ Barabamy ninadu‑ki. Tii tahe inywitxira aõbinadu mahãdu‑wana ratximyhỹ. Kiamy inydinodu òraru‑ki aõbina rỹireki, tii iny rirubunyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Iny sõwehekỹky‑ki doide, tahe rexiranyre ixitòedỹỹmy: iny deòwarixina kòdòhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato dirawyònyde: —Adeereny ariòlòdỹỹnykekõ aõbo ka judeu iòlò. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tii rieryre dori Deuxu aõmysỹdỹỹdu mahãdu wedu tamy Jesuisi ridyrenyre iwobinanareny lau. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Deuxu aõmysỹdỹỹdu wedu inysõwe riixitòedỹỹnyre Baraba riòlòdỹỹnykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato ritỹỹraxinyre ixybyle: —Aõhebo tahe idi arotỹỹnykre. Kaiboho tuu teninimyhỹtenyte judeu iòlòmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tiiboho rirajuarenyre: —Bitamadỹỹnyke itxeò nihikỹ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ta Pilato tamyreny ritỹỹraxinyre: —Aõbina taka riwinyre. Aõhe‑wana ixityre rirajuamyhỹrenyre: —Bitamadỹỹnyke itxeònihikỹ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato inydee aõ riwahinykemy rõhõtinyra, tai ta Baraba riòlòdỹỹnyre. Idi tahe Jesuisi riyhytanymy rahudi, riteònyre itxeònihikỹ‑ò riukòrenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldado ridyrenyre heto woube‑ò. Tai tahe ibutumy soldado ributunyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tahe tyysòborehekỹ‑di rityynyrenyre. Tahe ede rataana ritidire ira‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tahe rirybenyrenyre: —Adee nihikỹre judeu iòlò. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tahe rihetenyre bòtòre‑di irati‑ò, tahe ityre rarybexinyre tahe rỹire tatiowotimy rityhynykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tahe tyysòbore iribi ritara, tahe ityyle tamy ritidira. Inatyhymy ridyrenyre itxeònihikỹ‑ò riukòrenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kowa‑di rekoarenyre hãbuõ. Simaõ Sireni inire. Kia heka Alexỹdre, Rufu‑wana tyby rare. Tii nade bedero‑ribi. Tiiboho tahe riitxyydỹỹnyre itxeò‑di retyykemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Riwyrenyre bederahy‑ò Kòkòta ninadu‑ò. Kia heka iwitxira rybe rare. Kia heka rubu ratitybyho wese rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tiiboho vĩĩ riurinyre òwòruburu‑wana. Tahe tii tuu riõõlera. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Itxeònihikỹ‑ò raukòrenymy rahudi tahe ityy wirarea riatyre, tahe ityy‑di rarudeòsanyre tibo iny sohoji sohoji ityy riwykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Biurasò txu Jesuisi itxeò‑ki raukore. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iratya‑ki tahe ritina rỹire: JUDEU IÒLÒ. Kia heka iny tuu rarybemyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tahe tii‑wana inatxi wasidu itxeònihikỹ‑ò riherinanyre, ijõ ruruweribi‑ò, ijõ hyweweribi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tahe rotỹỹnyre aõbo Deuxu ritina‑ki rỹire wese: Tii ratximyhỹ òrarudu mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Iny reareare tara riohowimy rarybere aõbina binamy: —Kobe, kai korihe dohodỹỹna heto biatykemy inataõ txudile tahe ixityre bidiwinykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kaile inyhe bexitakre itxeò‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Iwesehyyle Deuxu aõmysỹdỹỹdu wedu, bede ywina erydỹỹ mahãdu‑wana widee raryberenyre. Jesuisinimy raujõmorenyreri: —Tii iny witxira ritare, tiile tahe rexitaõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristu, judeu Iòlò, bodobeheke itxeò‑ribi jiarỹboho arobirenykremy, tai tahe aratyhynyrenykremy. Tule wasidu tii‑wana raukòrenyre itxeò‑ki Jesuisimy raujõmorenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Txutyeu ibutumy bede rurunyre. Tahe roire txu kaò resemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kiaule tahe Jesuisi rarybeterenyre: —Elòi, Elòi, lema sabatani. Kia heka iwitxira tybe rare. Kia rare: —WaDeuxu waDeuxu, aõherekibo kai tiwarite. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ijoiõ heka tamy roholareu, rarybere: —Tii heka Eliasi‑ò ryryreri. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hãbuõ reare bexi ritỹxinyre vĩĩ juberere‑di idi tahe ritidire tabòtòrejura‑ò. Riwahinyre Jesuisi ritòkemy. Tahe rarybere: —Deinyhe tamy inyhe reketehereny Eliasi kanakremy aõbo inyhe itarasamy. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesuisi ryryre irariemy idi rurure. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dohodỹỹna hetowetyy raykare inatxi weryna tyymy, biu‑ribi, bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldado dinodu Jesuisiko‑txi ratximyhỹre. Tahe rurureu, irubumy robire. Tahe rarybere: —Ka heka inatyhymy Deuxu riòre rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tule hãwyy mahãduõ retehemy rỹimyhỹ irehe‑ribi, tòwysyreny‑ki, Marie Madalena, Marie (Txiause, Jyjese tii rare. Txiau heka Jyje hewoludumy rare.) Salome tule ihỹre ijõ‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kia heka Jesuisi Kalileia raremyhỹu, tiiboho tahe sõwemy iny‑wana doide Jerusalẽ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Txioromyhe dehemynyde. Wirareasanatxu rare. Kia heka sabadotxukokile rare. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jyje Arimatea hãwã ludu dohodỹỹdu nihikỹõ rare. Tule heka tii riraòmy ratximyhỹ Deuxu Iòlòna. Tii ruberuõlemy rare Pilato‑ò Jesuisiumymy ixitòedỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato rabedeòtiidỹỹnanyre Jesuisi rurumy roimyhỹdi tai ryryre soldado dinodu‑ò. Tai Pilato ritỹỹraxinyre, Jesuisi rurumy roimyhỹdi. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Soldado rarybereu Jesuisi rurumy roiremy tahe Pilato riteònyre Jesuisiumy Jyje‑ò iwahidỹỹmy, ");
INSERT INTO kpjNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jyje ritare itxeònihikỹ‑ribi tahe ritỹtenyre tyyurahãkỹ‑di. Idi tahe ritidirenyre mana hãloo wabedewo‑ò. Tahe mananihikỹ‑di riijòtòbònyra. ");
INSERT INTO kpjNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Marie Madalena, ijõ Marie Jyjese reteherenyre titxibo tii ritidirenyreò. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tahe nobiutxu, Marie Madalena, ijõ Marie‑wana ihewoludu Marie, Txiause, Salomese‑wana rare. Tiiboho lỹnyrena riõbranyrenyre. Tahe roire Jesuisibymy idi rekoakremy lỹnyrena‑di. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Juhutxu semana bededỹỹnanau txuu deadeule roire wabede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Widee raryberenyre: —Mowexe mana ritakre ijò‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tahe tuu robirenyre. Mana nihikỹ ritamy rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wabede‑ò rirònyrenyre, robirenyre weryrybòweselemy ronymyhỹ ruruweribi‑ò. Ityy urahakỹmy ronymyhỹ. Tahe tiiboho bede riòtiinyrenyre ruberurenymy. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tii tamyreny rarybera: —Uritere breburenyõmy. Kaiboho aõbo teòrytenyta Jesuisi Nazare ludu. Kia itxeò‑ki rurure. Tii aõkõ kaki ratxireri. Rexixara rubu‑ribi. Betehebeny inihe tai ritidiraò. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Makre. Marybekre ierydỹỹna‑ò tule Pedro‑ò. Tii rakre akorenymy Kalileia‑ò kaiboho tuu lobiximy boikre tuu adeereny raryberemy. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tahe tiiboho rihenyrenyre wylemy wabede‑ribi ruberumy. Tiiboho moõ heka rarybeõhyylerenyre ruberumyhỹrenyki. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Juhutxu semana bededỹỹnau Jesuisi rubu‑ribi rexixare. Idi tahe juhuu àsitereribile rexitỹnynyre Marie Madalena dee. Kia‑ribi heka juhuule ritare debò inatxi reurò tyytybybinamy. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tii rare Jesuisi‑wana raremyhỹ mahãdu‑ò. Tiiboho rabedewomy ratximyhỹreny, rahinymyhỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tamyreny relyyreu iwese Jesuisi tamy rexitỹnynyre wese Jesuisi irulemy ratximyhỹmy tuu robireke, rityhynyõlerenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jesuisi rexixamy rahudi tahe, iwitxiramy rexisỹnymy inatxi erydỹỹna‑ò. Tiiboho heka roimyhỹrenyre bedero‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tahe dòòsede relyyrenyre taijoi‑ò, tahe tule rityhynyõlerenyre. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tahe waòsohoji reurò erydỹỹna‑ò Jesuisi àsitereribile rexitỹnynyre. Tiiboho riroximyhỹrenyò rexitỹnynyre. Tahe Jesuisi tamyreny rarybera: —Aõherekibo kaiboho iny wamy robira mahãdu tetyhynyõteri. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kaiboho boibenyke ibutumy bede bede‑ò Rybewihikỹ bitỹnynykremy. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Inyõ Rybewihikỹ rityhynykeki, idi kidisebenykeki, tii Deuxu ritake. Inyõ rityhynyõkeki, Deuxu ixi‑ribi riteònykre iòraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kia bede eryna ityhydỹỹdu kidiheludunykre. Tiiboho tyytybybina kiditeònykre wani‑ki. Tule heka tiiboho itỹmyra rybe kanarybedenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hemylala rimyrenyreu, aõhe rotỹỹnyõlere tule rubuna monamy riõkeki, rotỹỹnyõlere. Tiiboho tebò ritidirenykre bina mahãdu‑ò tahe riteytenykre. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Idi tahe Jesuisi tarybe rahuredi, Deuxu ridyre biu‑ò. Tahe ronyre Deuxu ruruweribi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tahe tiiboho roire ibutumy bede bedemy tai bede ritỹnynyrenyre. Wanyrỹ riwiòhenanyrenyre tahe bede eryna‑di irybe ixidee rimyrenyre ihelududỹỹdu mahãdu‑ò.");
INSERT INTO kpjNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Wyla, Teòfilo. Adee heka watyyriti ariwahinykre timybo Kristu rotỹỹnyre. Tuu lobixidu mahãdu tuu relyymyhỹre‑ribi, jiarỹ ire ariòbitinytyhykre. Kia heka jiarỹ adee reritinymyhỹre, waiòlò, iwese ibutumy reeryrenyre juhu bededỹỹna‑ribi. Aõma inatyhymy kia rotỹỹnymy rare wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kia wese wahe. Iwese iny adee relyyre wese, jiarỹ adee arelyyre inatyhymy aõbo rotỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Zacaria heka Deuxu xiwe wahidỹydu rare, Abia ijoiõ wahe. Iriòrese Isabeli tahe tule xiwe wahidỹỹdu riokore mahãduõ rare. Kiau heka Herodi judeu bedesỹ iòlòmy raremyhỹ, Araõ riokore mahãduõ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wiwanale heka awirenyre Deuxuru‑ò. Òbitihyy heka ratximyhỹrenyre ibutumy Deuxu bededỹỹnanako‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tiiboho iriòreõhyyre. Ihãwyy Isabeli heka rasenadunyre, uladu herina dori awiõre. Ihãbu tule ramatuarinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Aõutxumy tahe Zacaria raaõmysỹdỹỹnymyhỹre aõma templowo‑ki. Kiatxu heka iròtenatxumy bede rỹimyhỹre templowo‑ò. Tahe iwo‑ki ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Hewydysi lỹnywi ritoonymyhỹ Deuxu kia deàlànamy, iwese riwinymyhỹrewesehyyle. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Iu ahana‑ki tahe sõwemy iny rexitòenymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Iu Zacaria xiwena ruruwe‑ribi loosòna‑ò rỹireu, hewydysi lỹnywi ritoonymyhỹre. Tahe aõwesele ỹjuõ rexitỹnynyre Zacariako‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tii tuu robireu heka rexiraòmy ruberumy reare. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ỹju rarybere: —Brebuõmykre, Zacaria. Deuxu roholare aixitòedỹỹna‑ò. Tai heka adee ijyymy rareri. Ahãwyy Isabeli rariòrenykre. Kai heka Joaõmy bininikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tai kaiboho heka iura heka beysabenyke sõwemy; ijõ iny tule reysakre iòraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tii heka hãbutyhyhykỹmy rarekre Deuxu dee tiu heka vĩĩ riõõtyhy mona hàrihikỹ riõõtyhy. Deuxu Tyytybytyhy. Juaõtykymy ralokre tii reareu. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Sõwemy heka aõma Israeli mahãdu Deuxu rityhynykre iòraru‑ki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tii heka hãbutyhyhykỹmy rarekre Deuxu rybedumy Elia wesemy. Tii heka aõma Deuxu deòdỹỹna juhuu rehemynymy reakre ikòlemy iny ywisidỹỹnakre rehemynykre juhuu, aõma Deuxu Tyytybytyhy dehemynyna riijemy tuu rehemynymy rakre. Tii bede ywina riòbitinykre inyy‑ki. Tyby tariòre‑wana wii riwoxinykremy. Tii heka iny ribedeerynykre aõma òbitimy rỹirakremy. Deuxu luumy rỹirakre aõma ilahireny rỹira wesemy juhuu. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacaria rarybere ỹju‑ò: —Jiarỹ ramatuarinyre timykre heka? Hãwyy tule rasenadunyre ihãrele òsana tukre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ỹju rarybere: —Jiarỹ Gabrieli watxireri, Deuxu deòdutyhy wahe. Tii heka diwateònyde kaò adee rybemy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kai tetyhynyõhyyteri tai kai marybeõkre uladu reakre xiery tahe marybekre. Kaa adee rarybereri dori òbitimy rarybereri warybemynamy ibutumy rỹikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Iny riraòmy rỹimyhỹ Zacaria òlòna, tahe raroorehenymyhỹ. Iroorehena rieryõhyymyhỹreny. Dòhònydeu ta, rybe‑ki rexisiranymy rarybeõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tii rehemynyreu tamy rybeõhykyre rahòra. Idi tebò‑di raramynyre urile rybe riwisỹnymy rarybeõhykymyhỹre aõma timybo aõhebo rotỹỹnyrá heka riòbitinykemy heka rarybeõhyymyhe timyrabo. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tahe taaõmysỹdỹỹna rihudi, taheto‑ò ròòsere ixyby. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Idi tahe Isabeli rabòtònyre iruwyre ahãdumy bede riijere rexiwòmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Isabeli rarybere: —Deuxu awi heka rare, riwatare waixỹruna‑ribi. Kuladu wadeke riwahinyreri. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ijõ ahãdu tahe Deuxu Gabrieli riteònyre Nazare hãwã‑ò Kalileia bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ỹjuõ heka rybe‑di ijadòma‑ò. Kia ijadòma heka wii ritobinymy rỹireri tybyboho iseboho Jyje‑wana roikremy. Jyje heka iòlò Davi kia mahãduõ rare. Ijadòma tahe Marie inire. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ỹju heka kiamy rarybere: —Beysakre Marie! Inynyrỹ heka awana ratxireri. Bedeòbyhykỹ adee kidiwahinykre. Tii arãwowydynyreri. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kia rybe‑di tahe Marie rexiraykynyre. Tii rieryõmy aõmybo rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tahe ỹju tamy rarybere: —Marie, Brebuõmy! Deuxu teteysanyte. Kai awi heka rare. Tii aõwihikỹbo adee kidiwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kai heka mariòrekre, uladu heka Jesuisimy raninikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tii heka hãbu nihikỹ rarekre. Tii Deuxu riòremy raninikre. Deuxu heka tii iòlòmy risỹnykre, iwese Davi alabiehekỹreny ronyre wese, tii ronykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tii heka ibutu Ijaò mahãdu iòlòmy rarekre. Iòlòna heka tiu itueõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tai tahe Marie ỹju‑ò rarybere: —Jikarỹ heka ijadòkòmatyhy watxireri. Timykibohe krabòtònykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tahe ỹju rirawyònyre: —Tyytybytyhy adee kanalokre. Deuxu ruru heka adee kanakre. Tai heka kia uladu Deuxu òbiti riòremy raninikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nohõti lusaõmy anymy‑ribi Isabeli riki bòtòkõmy rareke‑ribi tahe bòtòmy ratxireri. Debò sohoji reurò ahãdumy iahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Deuxu dee heka tiu aõ isiraõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Marie rarybera: —Jikarỹ Wahĩ dekòdu rare. Anomybo tarybeteri ka ibutumy rekyrubunyreri. Wadeke awire. Anowaxina tuukre irybemynamy karotỹkỹnykre. Idi ỹju rikõmy reare. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Idi ta tii heka Isabeli roramy rare. Zacaria sỹmy Judeia bede hãwãlò hãwã bede‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Iu Marie rehemynyreu tahe wii rirybenyrenyre: ");
INSERT INTO kpjNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tiu kia aõbo uladu Isabeli kia‑ki iule rexiwatxinymyhỹ Marie‑ò. Isabeli heka tỹxiykỹle Deuxu Tyytybytyhy‑di ratximyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Riajuamy rare deysana‑di sõwere: —Kai hãwyy ibutu‑ribi deysana rarekre. Auladu tule deysana rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Anoherekibo Wahĩse waroramy naderi. Jikarỹ ano anokõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Adeke rahokujareku, kuladu wawoku‑ki rexilòrelòrenymyhỹ tabedesa‑di. Tai tahe Isabeli rỹỹraximy ratximyhỹre Deuxu Tyytybytyhy‑di. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kai bekysabenyke kia tetyhynyteki. Deuxu rybe dokuri adeke nade. Iwese tiki raryberewesele ibutumy rãikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Marie rarybere: —Jikarỹ wawoku‑ribi Wahĩ rewokuwydynyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Wawokuribityhy wadekysareri Wahĩ watarasadu dokuri rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ihyky tahe tiki tekòdu‑ribi walanokonakona‑ribi tõhõti rosakre. Tahe iny ibutumy hãwyky dekysanamy riwaninikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Deuxu dokuri anomydỹkỹnana wiwihikỹ wadeke riwahinyre. Tii tahe ityhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tikiemy inydeke ruxetòena riwahinymyhỹre iny tamy wowydyna riwahinyrekí. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ixityhy nohõtidu mahãdu tiki rehure. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Bede ikòlò sõwemy tiki rehure. Tule iny ianokõ mahãdu Deuxu riwikòhenanymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Rama risamahãdu deke rỹsỹna tiki riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Irybe tahe tiki rityhynyre anobo tiki inytybyreny deke tiki raryberemy. Tikiboho tahe Deuxu riwikòhenanyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ruxetòena tahe Abraõ deke riwahinyre tule tikiemy iriokore deke riwahinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marie tahe inataõ ahãdu Isabeli‑wana riwyra. Idi tahe tasỹ‑ò ròòsera. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bededỹỹnana Isabeli‑ò rehemynyre. Iriòre reakremy ratxireriu, Iriòre reare. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Isỹ mahãdu heka teysana‑ò roholarenyre, iery mahãdu tule rabedesarenyre tamy Inynyrỹ raruxetòenyredi, Inynyrỹreny ruxetòena tamy riwahinyreki. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tahe debò inataõ txu‑di, uladu notyky resynamy bede rỹire. Zacaria raninykemyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tai tahe ise rarybere: —Anokõre, Joaõmy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Isỹ mahãdu rarybere: —Joaõmy ninadu taheka ijõkõhykyre inysỹreny‑ki. Anoherekibo tuukre? tai tuu raninike wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tuu Zacaria‑ò rỹỹraxireny: —Momybo raninykre? ");
INSERT INTO kpjNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tahe Zacaria tababese riòreõ rimyre. Riritinyra kia: —Joaõ heka inikre. Tahe ijõ mahãdu ibutumy ribedeòtiidỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Iu tahe Zacaria rarybere Deuxu riwowydynyre. Tahe ibutumy isỹ mahãdu heka ruberure. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ibutumy heka tii relyymy raremyhỹ Judeia mahãdu hãwãlò nihikỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ibutumy tamy roholaré heka raryberenyre: —Timybo uladu rarekre? Inynyrỹ idi tarukimy iweribikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tahe Deuxu Tyytybytyhy heka Zacariatykymy ralore. Tahe Deuxu aõmydỹỹnanamyhe relyyre timybo rabededỹỹnananykremy. Tii rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Judeu mahãdu Deuxu awi rare. Tii dori taijoi roramy nade. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Iwiòhedỹỹmy tulemy tarasadu tyhy Tii heka Iòlò Davi mahãduy rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Deuxu Rybedỹỹdu mahãdu kia wesemy tuu raryberenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Inydireny òludu mahãdureny‑ribi riki iny ritarenykre. Iny‑di heka raruxetòerenyra. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tahe iny‑ribi tõhõtireny rosaõhykyra. Tahe rarybekre timybo raryberemy inytybyrenymy. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Tii heka iny ritarenykemy inydireny ratxireri inyòludureny‑ribi. Kia‑ò heka rarybere inylabiereny Abraõ‑ò. Tai heka rikiwiòhenanyrenyke brebuõlemy. Òbitimy iko‑ò rakatxirenyhyykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kai wariòre Deuxu rybedumy mabekre. Kai heka mabekre Deuxuhukỹ rybemy rybedumy. Kai heka bòhònykre Inynyrỹ‑kò iry biywinykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Asỹ mahãdu‑ò marybekre biu‑ò hena kanakremy ihỹre. Deuxu heka tõhõti rosakre iòrarunareny‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Iny Deuxureny dori inydeereny ruxetòedu rare. Tii heka biu‑ò hena ibutu‑ò kidiõkre, tarasana wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kia bede lurumy rỹira mahãdu biuloosònamy robikre. Zacaria rybe tahe rikonananyre. Loosòna ywinary‑ò tahe ritỹnynykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ihewo‑ribi tahe uladu ratybienyre taumy‑di Deuxu tyhydỹỹna‑ki tule. Tii heka bederahy‑ki raremyhỹ. Tiutxumy rexitỹnynykremy judeu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kia mahãdu iòlò Augusto inire. Kia heka ibutumy bede‑ki inyni rityyritinykemy bede riywinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kurina heka Siria bede dinodu rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","4","Jyje heka Nazare hãwã‑ki rasỹnymy raremyhỹ. Tai tahe Kalileia bede‑ribi tiiboho roirenykemy Judeia bede‑ò. Iòlò Davi dori tai reare, Belẽ hãwã‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jyje tahe rare, tii dori Davi ijoimy rareki. Marie bòtòmy tii ridyre tai ihãwyy. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tahe Belẽ hãwã‑ò rehemynyre. Tahe herina roxina heto ihoõre herina tamyreny. Taihe awaru roxina heto‑ò roire. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tai hãwyy ratohouãsenyre. Idi rihetynyre awaru roxina hynaro‑ò ritidikemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Iu tahe budoeni‑di itxeredu mahãdu bedero‑ki ratximyhỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Idi tahe ỹjuõ tamy nade Deuxu‑ribi. Deuxu loosòna tamy ritynyre. Ruberurenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ỹju tamy rarybere: —Brebuõmyrenyke. Rybe wihikỹ‑di adee rehemynyreri. Ibutumy iny reysakre ka rybe‑di. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Atarasadu heka ratohouãnyra Davi hãwã‑ki, abiu‑ò hedu wahe. Tii heka Kristu rare, Inynyrỹreny wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kaiboho heka awaru roxinaõ‑ò inihe bòike itxeremy. Tai heka tohouã roireri tyy‑di rarahananymy. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Iule tahe sõwemy ỹju widotyde Deuxu dee rawiunykremy, kiawese rawiunyrenyre riwowydynyrenymy: ");
INSERT INTO kpjNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Biu‑ki Deuxu loosòna ratxihyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tahe ỹju ròòserenyre biu‑ò. Budoeni‑di itxeredu mahãdu widee raryberenyre. Wylemy Belẽ‑ò ròkòirenykre itxeremy kia aõmydỹỹnanamy Deuxu inydee riteòsinyreriò. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tahe roirenyre idi tahe Marie, Jyje‑txi rekoarenyre. Tuu robirenyre. Tahe broreni dòròtòhòhyna‑ki uladu roire. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tai tahe budoeni‑di itxeredu mahãdu timybo ỹju tamy raryberamy, rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tai tahe ibutumy kia tamy roholaré ribedeòtiinymy rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Marie heka tõhõti itxi reare. Tahe sõwemy raraykywydynanymy ronyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Budoeni‑di itxeredu mahãdu ròòserenyre rawiunyrenymy Deuxu‑ò Deuxumy reàlàre ibutu òraru‑ki. Iwese ỹju raryberewesetyhyle heka ibutumy rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Iribi tahe txu rỹireu tahe rare Jesuisi notyky orokré. Debò inataõ reurotxu rỹireu Jesuisi notyky raorokremy raywire. Tahe rininirenyre Jesuisimy iwese ỹju rarybere myna. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Xiwena rỹikemy bede rỹire Moisesi bede ywidỹỹnamyna. Aõutxumy tahe dehemynyde Marie Jyje‑wana kia idi riwinyrenykemy. Tahe Jyje ridykemy Jerusalẽ‑ò idi ratxireri. Tai uladu‑di roirenyre Deuxu‑ò riteòsinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kiamy heka Inynyrỹ Ritidỹỹna‑ki roire. Weryrykeki, Deuxu dee rawahidỹỹkre. Tii uladudelaa weryrykreki. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Iwese tule bòtòe inatximy rawahidỹỹkre ada bòtòerurà inatxi heka xiwenamy reakre Moisesi bede ywidỹỹna myna. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hãbuõ tai ratximyhỹre Simeaõ inire. Jerusalẽ hãwãdu wahe. Deuxu rityhynymyhỹre hãbuwi rare. Tii Kristu riraòmyhỹre Deuxu deòdỹỹna wahe. Iijoi aõbina bina‑ribi tarasadumy Deuxu Tyytybytyhy heka tai ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Deuxu Tyytyby ihetxiu tamy rarybere: —Kai buruõtyhy Deuxu deòdỹỹnamy bobiõdi. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Iu Jesuisise tyby‑wana rehemynyreu Deuxu Tyytybytyhy heka Simeaõ riteònyre kowa‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeaõ uladu taãxiò‑ki rimyreu. Tahe Deuxu riwowydynyre: ");
INSERT INTO kpjNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","—Kiamy heka Wanyrỹ Iòlò arybe retyhynyre timybo tarybete wahe. Ibutumy dorihe tewinyta. Tahe aõwaxinyhe arurukre. Abiuòhenamy heka rabira. Tii ibutu iny tarasadumy rarekre biu‑ò hena wahidỹỹdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kia heka ibutumy iny‑ò loosòna tewahinyta judeukõdu mahãdu‑ò. Tai judeu mahãdu tahe wowydynamy tii rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tai tahe Jyje Marie‑wana bede riòtiinyre aõmybo rarybereki. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeaõ tahe Deuxu deysanamy tamyreny rarybere: —Deuxu biu‑ò henamy heka kia uladu rare. Sõwemy judeu mahãdu tarasadumy rarekre, tule sõwemy tasỹ ituekre. Kia heka Deuxu deòsina rare. Sõwemy heka Jesuisimy rakyararybenynykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ibutumy iny rayky‑ribi heka ibutumy ritỹnynynykre. Bederyry sõwemy bieryke tai aõhõkỹmy botỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tule Deuxu rybe erydỹỹnaõ rehemynyre. Ana inire. Hãwyy rare. Tii heka Fanueli riòre rare. Asere mahãdusỹõ rare. Tii heka rasenadunymy raremyhỹ. Ijadòmamy raremyhỹu heka roire hãbu‑wana. Debò inatxi reurò beòralemy heka tii‑wana raremyhỹ tahe tii rawytesenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tii 84 beòramy heka bede idi rỹire wytesemy. Tii Deuxu dohodỹỹna heto‑ribi ròhònyõhyymyhỹre. Tii heka rexitòenymyhỹre rumy txumy tabyreõ‑di. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tahe tii rehemynyre Deuxu dohodỹỹna heto‑ò. Deuxumy reàlàre. Idi Jesuisimy imahãdu‑ò rarybere tii tarasadumy rarekremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iu Marie, Jyje‑wana ibutumy bede ywidỹỹnamy ituereu, riòòserenyre tahãwã‑ò Nazare‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jesuisi raumynymyhỹre beòra beòramy. Iruru, ibede eryna sõwemy ijõdire Deuxu dori idi tarukimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pascoa worana bedehesi riòlòdỹỹnyre Jerusalẽ hãwã‑ki. Jesuisi tyby heka iseboho roihyymyhỹrenyre tamy. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tule Jesuisi waòinatxi reurò beòra‑di ridyrenyre tamy. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Worana bedehesi rexihureu kidiòkesedenykremy doide. Tahe Jesuisi naride Jerusalẽkihikỹle. Tiiboho rieryrenyõhyyre naridemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","46","Taijoirenywanale ratxirerilemy idi rõhõtinyrenyra. Txusohojimy heka bede idi rỹidi, rierenyre. Tai rahaõhyyrenyra iijesemy diòkesedenyde Jerusalẽ‑ò ixyby. Inataõ txu‑di tahe tai nahadenyde, Deuxu dohodỹỹna hetowo‑ki wahe. Tii heka bede erydỹỹdu mahãdu‑wana ronyre. Roholamyhỹrenyre irybe‑ò ronymyhỹreny. Tule rỹỹraximyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tii heka ibutumy rirawyònymyhỹre. Tii dori bede ery nihikỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iseboho tahe bede riòtiinyrenyre tai ronyreki wahe. Ise tamy rarybere: —Waritxòre, anoherekibo kai ikykyreny‑ki tanyte. Anoherekibo tuu wadekereny tewinyteri aijesereny‑di watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tahe Jesuisi rirawyònyre: —Waijeserenykõmyke. Waha heto‑ki watxireri, Waha aõmysỹdỹỹnamy reywinyhyy watxireri. Kia aõbo teeryõhyytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tiiboho rieryrenyõhyyre aõmybo Jesuisi rarybereri. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Idi tahe dòòsedenyde Nazare‑ò. Tahe Jesuisi tyby rybe rityhynyhyymy raremyhỹ. Tahe Jesuisise kia ibutumy riyrubunyhyymy raremyhỹ tarayky‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesuisi tahe raumynyre. Bede erytyhymy relere. Ibutumy he iny iluure. Deuxu wowydyna‑di ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberiò heka waiyre beòramy iòlòmy raremyhỹ. Poncio Pilato heka Judeia bede dinodu. Ijõ heka Herodi inire. Inataõ inymy heka bede dinodumy raremy. Herodi heka Kalileia bede dinodu. Iseriòre, Filipi tahe Itureia bede, Traconite bede‑wana dinodu rare. Ijõ iny tahe Lisỹnia inire. Tii Abileni bede dinodu rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi, Kaifa‑wana heka inatxi hãbu roire. Tiiboho wiwana xiwena wahidỹỹdu wedu raremyhỹ. Kia bedeu heka Joaõ rehemynyre bedero‑txi. Tii iny‑ò Deuxu rybe tỹnydỹỹdu rare. Zacaria riòre rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tii kia bede ibutumy rybe ritỹnynyre, Jordaõ beroweramy ibutumy wahe. Kia wesemy rarybere: —Aòraru‑ribi bòhònyke. Maratisebenyke. Tahe Deuxu aòraru riixãwididỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Iwese Isaia ròritidỹỹre wesemy heka wiji rỹire. Inyõ heka ryrymyhỹ bedero‑ki. Kia: —Inynyrỹry bexiywinybenyke. Ryòbitihikỹ biwinybenyke. Hãloo bitỹxinybenyke wimyny biijaranybenyke. Iry iòweòwena ramyhỹre heka, biòbitinybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Iratòratòkeki, wimyna biijaranybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ibutumy iny heka Deuxu biu‑ò henamy robirenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Sõwemy iny nade riratisebenykremy Joaõ‑ò. Tahe tii tamyreny rarybere: —Kaiboho hemylalaweselemy toite. Deuxu ykarana‑ribi bexitabenyke, aõwiwihikỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Uritere kawese ryberenyõmykre: —Abraõ dori iny labiereny rare. Tai tahe ibutumy awityhy rare inydeereny. Jiarỹ dori adeereny ararybekre: —Deuxudeewikeki, Tii kia manadile iny riwinyke. Abraõ dee ijõ riòreõmy kia manadile riwinyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Woma heka òwòruraruti riòròmyhỹre. Kia raratynyõkeki heka, raòròkre. Heòty‑di wòmy ririradỹỹnymyhỹke. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tai tahe iny rỹỹraxire Joaõ‑ò: —Timybohe rakatxirenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tai tahe rarybere: —Inyõ tõre inatximy ijõdikeki, sohoji iny ijõ‑ò riwahinyke. Irỹsỹnadikeki, tule ritxuatxuake ijõkõ mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Iny witxiraõ Joaõ‑ò rehemynyre. Tiiboho nieru tarasadu mahãdu rare bede dinodu‑ò. Tai rỹỹraxirenyre: —Timybo aõhebo rokotỹỹnyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Joaõ rirawyònyre: —Uritere aõnihikỹmy itarasarenyõmykre. Bede ywidỹỹna tyyriti myna ta tuukre. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tai tahe soldado tamy rỹỹraxire: —Inyboho tahe aõhebo rokotỹỹnyrenykre. Joaõ rirawyõnyre: —Inyõ biteranyõtyhy adee nieru kanakemy. Inieru dori ahõrõ aõkõ rare. Beysake, adinodu‑ribi tiwesebo nieru tetamahãte‑di. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tahe kia iny mahãdu raraykynyre Joaõ‑di. Kowa aõbo hãbu Kristu ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tai heka Joaõ rarybere: —Jiarỹ heka bedi araratisebenyreri. Ijõ wahewo‑ribi kanakre tahe woratyre inihikỹ rarekre. Tii heka awityhy rare. Jiarỹ heka raixỹruwãhãre iwataana aritake lau. Tii heka akanaratisebenykre Deuxu Tyytybytyhy‑di. Heòty‑di tule wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iti tebò‑ki ratxireri. Maixõmo ruxity hitxina‑di wahe. Tii heka ritakre. Maixõmo riyrubunykre ihyna‑ò. Iruxityy tahe ritoonykre. Kia heòty heka tiu ruriõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aõ heka Joaõ rarybere. Sõwemy aõna aõnamy iwesele rarekemy. Dohodỹỹna wihikỹ‑di tamyreny rarybera. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bede dinodu Herodi heka taseriòre riòrese‑wana roire. Aõbina binahakỹle riwinyre kia. Tai tahe Joaõ tamy rarybere: —Kia awi aõkõ rare. Ibina heka rare. Sõwemy aõna aõna bina tule tii riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tai Herodi heka Joaõ mynymy riteranyre ròtenawo‑ki roikemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Joaõ ixiwesehyyle rexitỹmyranymy iny riratisebenyre. Tahe tule iny witxirahe‑ki Jesuisi riratisebenyre, Jesuisi rexitòenyreu, biuwetyhy rarayre. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Biuwetyky‑ribi tahe Deuxu Tyytybytyhyle dobehemy nade bòtòerurà wesemy. Biu‑ribi rybeõ‑ò iny roholare: —Kai heka Wariòre tate. Aluure heka jiarỹ wadeysatyhyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesuisi 30 beòramy raremy taaõmysỹdỹỹna tyhy ritelenyreu, iny heka Jyje riòrelemy rõhõtinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Jyje heka Eli riòre rare. Matate, Levi, Maki, Janai, Jyje, ibutumy labiehekỹ Jyje rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ijõ tahe Matatias, Amos, Naum, Esli, Nagai, ");
INSERT INTO kpjNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maate, Matatias, Semei, Jyje, Joda, ");
INSERT INTO kpjNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joana, Resa, Zorobabe, Salatieli, Neri, ");
INSERT INTO kpjNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Meki, Adi, Cosã, Elmadaõ, Er, ");
INSERT INTO kpjNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josue, Eliézer, Jorim, Matate, Levi, ");
INSERT INTO kpjNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeaõ, Juda, Jyje, Jona, Eliaki, ");
INSERT INTO kpjNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea, Mena, Matata, Natã, Davi, ");
INSERT INTO kpjNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ijese, Obede, Boasi, Sala, Nasaõ. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadabe, Adimim, Arini, Esraõ, Peresi, Juda. ");
INSERT INTO kpjNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ijaò, Ijai, Abraõ, Tera, Nakò, ");
INSERT INTO kpjNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serui, Raau, Faleki, Eber, Sala, ");
INSERT INTO kpjNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Aina, Arfaxade, Sem, Noe, Lamei, ");
INSERT INTO kpjNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusalẽ, Enoi, Jarete, Maleleel, Aina, ");
INSERT INTO kpjNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enosi, Sete, Adaõ. Tii tahe Deuxu juhuu riwinyre iriòre wese. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bero Jordaõ‑ribi Deuxu Tyytybytyhy heka Jesuisi diòòsedỹỹnyde Tai heka tule bederò‑ò rexiykynyra. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tahe Satanasi Jesuisi riurihire, 40 txu‑di wahe. Aõ heka rirỹsỹõhyyre Jesuisi kia itxumy txu rỹireu wahe. Idi tahe sõwemy rama risare. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satanasi tamy rarybere: —Kai Deuxu Riòretyhy tate‑wana heka, mana bitxienykre hinamy. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tai Jesuisi dirawyònyde: —Deuxu Rybe tule kiamy rarybere. —Hãbu hewa byre sohojiribile aõkõ irumy rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tai Satanasi heka Jesuisi ridyre heto ratyti tyre. Ibutumy hãwãhãkỹ riteòsinyre bede bede rỹirá. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tahe Jesuisi‑ò rarybere: —Kai biwalàhànanykeki, ibutumy aõna aõna adee ariwahinykre, ibutumy hãwãhãkỹ dinodumy tule wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Wahõrõ heka rare. Inyõ‑ò aõtxile ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Idi tahe Jesuisi dirawyònyde: —Deuxu‑ò sohojile walàhàna biwahinykre. Kiamy Deuxu Rybe rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Idi Satanasi Jesuisi ridyre Jerusalẽ hãwã‑ò. Biu‑txi tahe rỹire, Deuxu dohodỹỹna heto tyre‑ki wahe. Tii narybede, kai Deuxu Riòre tyhy tate wana heka bexiwatxitxinyke inihe karibi hetoratyti‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ỹju riki arayrubunykre wa. Deuxu taỹjuõ bede riywinyre aramykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tule kia rarybemyhỹre Deuxu Rybe. Awa riki manaõ riwotõmonyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tahe Jesuisi dirawyònyde: —Tule Deuxu Rybe rarybere: —Inyõ heka Deuxu uri urihixiõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Rexihure tahe Jesuisi urihixina. Tahe Satanasi heka Jesuisi ririre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Idi tahe Jesuisi ròòsere Kalileia bede‑ó. Deuxu Tyytybytyhy ruru tahe tii‑wana ratximyhỹre. Ibutumy heka kia hãwã‑ki ibededỹỹnana rierymy hỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesuisi heka dohodỹỹna heto‑ki ròbedeerydỹỹmyhỹre. Ibutumy tuu rarybere. Tuu reàlàmy rarybemy rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iribi tahe Jesuisi ròòsere tai raumynyréò, Nazare hãwã‑ò. Sabado txuu tahe dohodỹỹna heto‑ò reamy raremy iwesehyyle. Tii tahe lamamy rỹire tyyriti‑di rariakremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tahe tamy Isaia tyyriti riwahinyreò. Tahe Jesuisi riijemyhỹre rybeõ idi rariakemy. Tai idi rariare: ");
INSERT INTO kpjNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—Wanyrỹ Tyytybytyhy waki ratxireri. Rybe Tỹmyra wihikỹ inyko arotohodỹỹkremy. Iny aõkõ mahãdu‑ò rybe wihikỹ ararybekemy riwatare. Tule iny ròtena‑ki rỹira mahãdu, jiarỹ ariòlòdỹỹnykemy. Kiamy heka tamyreny ararybekre. Tule ruetỹmyra ariwahinykre ruetà mahãdu‑ò. Iny idi rarỹỹnymyhỹre mahãdu‑ribi, aritakre idi risinymyhỹreki. (Aõna aõnamy risỹnyrenymyhỹreki wahe.) ");
INSERT INTO kpjNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tibedeubo Inynyrỹreny taijoi ritakremy ararybekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Idi tasỹ ixyby riwerasenyre. Tahe riwahinyre ixyby kia hãbu riyrubunymyhỹreò. Tii ronyre. Ibutumy kia dohodỹỹna mahãdu idi retehemy rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tahe Jesuisi ritelenymy rarybera: —Wiji idi rariará heka aõbo tamy ibededỹỹnanamy roire. Kia aõbo ritidỹỹna‑ki roireri ihetxiu. Kaimy tahe wiji rarybereri, jiarỹ heka tii rare. Tii adeereny tyyriti rariará wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tai tahe bede riòtiinyrenyre. Kia tahe aõmybo raryberakí. Tahe widee raryberenyre. Kaa heka Jyje riòrele ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tahe Jesuisi ixityre tamyreny rarybere: —Aõu kaiboho wamy tarybetenyteri rybeõmy, myỹ manarybeke: Kai bexideytenyke, hàri, òhotibedu. Kiamy aõbohe wadee manarybebenykemy atxitenyteri: Iwese Kafanaõ bede‑ki tewinyte wese ariwinyrenykemy wadi atxitenyteri, ahãwã‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Adeereny inihe tuu ararybekre. Rybe tỹnydỹỹdu heka õmo rityhynyõtyhy ihãwãreny‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Tahe iwitxiramy ararybekre. Ibedeu kia raremyhỹu, sõwemy heka rama reamy raremyhỹ judeu sỹ mahãdu. Sõwemy wytese mahãdu heka ramamy rurumyhỹre. Biu heka roaõhykyre tai inataõ beòra weeremyhỹ wahe Sareta hãwã heka Sidõ bede‑ki tii rasỹnymyhỹre. Tahe Deuxu bede riywinyre Eliasi rakemy iny sohoji wytese‑ò, rỹsỹna riwahinykelemy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eliseu bedeu heka sõwemy tyybinadu rỹimyhỹ. Sohoji inyle riteytenyre. Naamy heka inire. Tii heka Siria bede luduõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kia dohodỹỹna mahãdu heka ibutumy iu tamy rakyarananyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Rimyrenyre heka Jesuisi. Idi retỹhirenyre hãwãlò ratya‑ò ridyrenyre. Idi rehurenykemy riwisỹnyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tahe Jesuisi inysõwehekỹy‑txi ralore. Idi rahenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iribi tahe Jesuisi rare Kafanaõ‑ò, Kalileia bede‑ò. Sabado txuõ txuõlemy heka Jesuisi iny ribedeerynymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sõwemy heka iny ribedeerynymyhỹre mahãdu tamy awimy rỹira, irybe dori awireki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hãbuõ raremyhỹ dohodỹỹna hetowo‑ki tyytybybinahakỹ‑di tahe taumywo‑ki ratximyhỹ. Tai tahe tii ryryre: ");
INSERT INTO kpjNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesuisi, Nazareludu, aõhebohe ijoi bisỹnykremy atxiteri? Biwahubenykre aõbo? Jiarỹ heka araeryre mobo taté. Kai heka Deuxu deòdu atxiteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tai tahe Jesuisi tamy rarybere tyytybybina iumywo‑ki riyrykemy. Iribi riòlòdỹỹnyre. Tahe idi rehure iutyde‑ò idi iribi ròhònyre. Hãbu aõhe risỹnyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ibutumy heka iny ribedeòtiidỹỹnyre. Iny sohoji sohoji widee rarybere: —Aõrybemy aõwe tii rarybereri? Timybo iny‑ribi tyytybybina riteònyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ibutumy timybo Jesuisi riwinyre, ijyynamy reare. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tahe Jesuisi ròhònyre Simaõ heto‑ò idi rare. Simaõ riòrelahi webinadumy roire rubuna‑di. Tai Jesuisi‑ko tuu relyyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tai Jesuisi ibireweribi‑ò rare. Tahe irubuna iribi riòlòdỹỹnyre. Tahe tii ritamadỹỹnyre. Rỹsỹnaõ tamy riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ibutumy iny tawebinadu mahãdu didydenyde. Ibutumy Jesuisi riteytenyre tibò iratityre rilidimyhỹre. Sõwemy iny tyytybybina‑di rỹireri mahãdu riòlòdỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iu tahe ryrymy reamy rỹimyhỹ: —Kai Deuxu Riòretyhy tate. Tii Jesuisi rierymyhỹ tii Deuxu deòdu raremy, tyytybybina wahe. Tai Jesuisi tamy rarybere rybeõkemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Txu ijiramy Jesuisi rare bedero‑txi ixisohojile. Iny sõwemy riijemyhỹ. Itxi rearenyreu, iatysy deramy rekoamyhỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tai Jesuisi rarybere tamyreny: —Jiarỹ heka Rybewihikỹ Tỹmyra arelyykre iwitxira hãwã Deuxu Òlòna Tỹmyramy arelyykre. Tuu Deuxu diwateònyde. ");
INSERT INTO kpjNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jesuisi ibutumy Judeia mahãdu bede bedemy dohodỹỹna rỹiraki rotohodỹỹmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jesuisi tahe aho ijà‑ki rỹire Kenesare aho ijà‑ki. Iny heka sõwemy Deuxu rybe‑ò roholakemy iu rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tii robire hãwòõ inatximy roinyimyhỹre. Waxidumy mahãdu heka rirahure rià‑di risuhòreri. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Idi tahe rimyre hãwòõ. Simaõ hãwò heka rare. Tii tahe ixi‑di ritaranyre beroro‑ò. Tai tahe tii rexidelenymy relyyre. Kia iny rỹimyhỹ mahãdu heka ribedeerynymy relyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Rexihure rybe‑ribi. Idi tahe Simaõ‑ò rarybere: —Make wa bera‑txi. Rià bitidike. Bimykemy utura. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tahe Simaõ rirawyònyre: —Wanyrỹ, ruu wa wadireny aõkõhykylemy bedewadireny rareri, uturamy ho aõkõ. Tarybete urenana anakre. Aritidikre heka rià. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tahe ritidireu tahe, rià utura sõwemy rimyre, kia rautxienyre. Tule riykamyhỹ rià. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Talawò biòwa mahãdu‑ò ryryre: —Bòdòibedenyke bidiwawiòhenanybenykemy. Inatxi hãwò heka rỹxire. Ritỹxinyre utura‑di. Ihyy berahatxi‑ò ijiramy riwisỹnymyhỹ ilawòreny. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simaõ tuu robire. Tii Jesuisi ratximyhỹre tahe tatiowomy resere Jesuisiko‑txi. Simaõ Pedro rarybere: —Wanyrỹ, aribi kỹny iòhòmy arỹiõtyhy. Jiarỹ heka waòrarudimy rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simaõboho bede riòtiinymy rabedewore aõma utura sõwemy tamyreny riwahinyraki wahe. Tii tuu iximy rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ibutumy tiiboho mahãdu ribedeòtiidỹỹnyrenyre Zebedeu riòre kia Txiau, Joaõ‑wana. Jesuisi rarybere Simaõ‑ò: —Brebuõmyke heka ikonana‑ò heka utura bimyõkre. Wadee dori maaõmysỹdỹỹnykre hãbu wadee bimykremy. Tamyreny biwatỹnynykre. Iwese utura temymyhỹte wese, wadee hãbu wiji bimykre waerydỹỹna mahãdumy rarekremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tahe waxidumy mahãdu ibutumy kaa tawaxi tarià iu ririra Jesuisi riheludunykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ròirenyre rirònyrenyre ibutumy hãwã‑ò. Idi tahe hãbuõ rare ityyjyjyhykyle. Hãbu Jesuisi robireu tahe resere iko‑txi, rexitòenyre: —Wanyrỹ, adeewikeki biwateytenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesuisi tamy tebò ritetemy rarybere: —Kohe, arateytenykre. Tii reytemy reare. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tai Jesuisi rarybere tamy: —Inyõ‑ò tahe ijyyõmykre. Xiwena wahidỹỹdu mahãdu‑ò make. Tai maxiwekre tuu Moisesi bede riywinyre myna. Xiwenaõ heka biwinymy biwahinykre. Moisesi rarybere wese wahe. Iny mahãdu‑ò heka biteòsinykre. Kia riteòsinykre teytetamy. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tahe ihãrele Jesuisi ibutumy rieryre. Sõwemy iny heka wirotyre raholakremy. Ijõ nade aõma iwebinaduna ibina‑ribi riteyteuykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tahe Jesuisi iribireny aõma rexitòenykremy rexitare. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ijõ txuu ròbedeerydỹỹmyhỹu, fariseu mahãdu, bede ywina rybe bede erydỹỹduõ‑wana ronymyhỹreny. Ibutu hãwã hãwã‑ribi dotydenyde wese tahe sõwerenyre, Kalileia bede‑ribi Judeia bede‑ribi, Jerusalẽ hãwã‑ribi. Deuxu deytena Jesuisi‑ki ratximyhỹ. Jesuisi hãwãlò‑ribi dobehede tii‑wana, taerydỹỹna mahãdu‑wana wahe. Tahe sõwemy iny iube‑ki ributunymy ronymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Iny mahãduõ heka hãbu iumymy manadu kididydenykemy ratxireri Jesuisiko‑ò ritidirenykemy. Idi tahe hãbu webinadu wahe Jesuisi‑ò rakemy bede riywinyre. Inatyhyle riatyhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Inysõwereki tahe tamy rehemynyrenyõtyhy. Tai tahe hetoratyti‑ò raòwònyre hãbu webinadu‑di. Iribi tahe diberesedỹỹnyde reroti‑di. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesuisi robire, rieryre aõma rityhynymy ratxirenyreri. Hãbu‑ò Jesuisi rarybere: —Wy, aòraru heka raixãwidỹỹnyra. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tahe fariseu mahãdu he widee raryberenyre: —Mobo kia hãbu ratxireri, timyhe tu kia irybeõna rybe‑di. Deuxu‑ò kia rybe ibinatyhy rare. Deuxu sohojile òraru‑ribi iny riixãwididỹỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tahe Jesuisi rierymyhỹ timybo rexinohõtinymyhỹreny. Tai rarybere: —Aõherekibo kia wesemy texiraykynytenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tibohe irutaõre webinadu‑ò rybe: —Aòraruna reixãwididỹỹnyra ada myimy mariake aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Deuxu Riòre Hãbutyhyhykỹ jiarỹ rare. Tai waruruna wadee Deuxu Riòre òraruna ixãwididỹỹnamy. Katahe bierybenykre inatyhymy aõbo rarybereri: —Myike, abyre biwymy asỹ‑ò ta mahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hãbu tabyre rimymy tahe aõwesele tasỹ‑ò rare. Deuxu riwowydynymy rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sõwemy iny ribedeòtiidỹỹnyrenyre. Riwowydynymy rỹimyhỹ. Tiiboho raryberenyre: —Aõwitxiramy wiji inyboho robirenyra. Tiu juhuu tukõre‑ribi wahe robirenyra. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iribi tahe nieru bede dinodu nieru mynydumy robire, Levi heka inire. Tii heka raaõmysỹdỹỹnymyhỹ titxibo nieru tarasana‑ki. Jesuisi tamy rarybere: —Manakehe wawana. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tahe taaõna ibutumy ririre, idi ihemy rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi tahe taheto‑ki roxinaõ riòlòdỹỹnyre Jesuisi dee. Tamy rehemynyre nieru arisidu mahãdu, tule fariseu mahãdu. Ibutumy iny iarixina mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kia fariseu mahãdu kia bederydỹỹdumy mahãdu tyyritirybedỹỹdu mahãdu kie heka aõbina binahylemy rarybereri Jesuisimy. Jesuisi terydỹỹna mahãdu‑wana kiamy rarybereny: —Aõherekibo kaiboho teroxitenyteri, nieru arixidu‑wana, iòrarudu sõwe mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesuisi rirawyònyre: —Iny awimy ratxireri‑wana, òhotibedumy reaõmyhỹre. Webinadu mahãdule ta tuu reamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Òbiti mahãdu‑ò aõkõ heka jiarỹ anade rybemy. Tiibohole heka ixi‑txi tõhõti reakemy idi watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tahe tiiboho Jesuisi‑ò rarybere: —Joaõ heludu mahãdu roxiõmy txumy rỹire. Tule tiiboho rexitòenyrenyre. Sõwemy rexitòenymyhỹre fariseu mahãdu erydỹỹna tule. Tahe aijoi tahe riroximyhỹrenyre riõmyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Tahe Jesuisi tamy rarybere: —Hãwyymy heridu tỹmyra ijoi ratxikeki heka tiu itobidỹỹnana mahãdu wahe. Kia heka riroximyhỹke. Kia tahe tỹmyra iribireny ratakreu, iijoi mahãdu renarehekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tyky tỹmyraõ tiu tykytyby dòbònamy iny ritidiõtyhy. Timyki dori wii wiòbydỹỹõna. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Vĩĩ tỹmyra heka tiu aõiròdu tyky watxiwe yla tyby‑ò rarareõmyhỹre, tukeki ta kia raykakre idi vĩĩ urile rejujukre. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Vĩĩ tỹmyra heka hyna tỹmyra‑ò rararemyhỹke. ");
INSERT INTO kpjNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Inyõ vĩĩ tybyhykỹ riõkeki, itỹmyra rexitòenyõtyhy. Kiamyki rybe. Vĩĩ tyby dori itỹmyra‑ribi awi rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Judeu elehydỹỹnymyhỹreny txu kia idi rekoarenyre maixõmoho‑di. Ierydỹỹna mahãdu rimyra maixõmo, maixõmo, debò‑di riroxitytxiwimyhỹ riymy idi rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fariseu mahãdu tuu robire. Tamy rỹỹraxire: —Aõherekibo kia wese tewinyteri. Kiamy heka iwidỹỹõmyke bede ywina rybe rarybemyhỹre judeu elehydỹỹnymyhỹrenytxumy. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Jesuisi tamyreny rarybere: —Ihetxiu Davi tamahãdu‑wany rama risareu, Deuxu dohodỹỹna hetowo‑ò rirònyre. Tai Davi xiwena rỹsỹnale taijoi‑wana rirỹsỹre. Xiwena wahidỹỹdule heka irỹsỹdure, inywitxira ta aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesuisi ritỹnynyre tamy: —Hãbutyhyhykỹ jiarỹ rare, Deuxu Riòre wahe. Kiata sabado wedu jiarỹ rare, elehydỹỹnymyhỹrenytxu wedu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ixityre ralore dohodỹỹna mahãdu heto‑ò ròbedeerydỹỹkemy. Hãbuõ tai rare tebò rabinamy. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tahe fariseu mahãdu Jesuisi‑ò retehere. Riteyteynykemy kia hãbu webinadu judeu elehydỹỹnymyhỹrenytxu. Rexiwodohonanyre. Kiatxuu tii riwinyrekeki tahe ribinanyke judeu elehydỹỹnymyhỹrenytxu, riwinykeki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesuisi rierymyhỹre aõmybo tiiboho raraykynyrenyreri. Jesuisi tamy ryryre, —Aõma hãbu debòbina‑ò: —Mynyike ini, ityareny‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tahe fariseu mahãdu‑ò Jesuisi rarybere: —Arỹỹraxikre inihe adeereny, awire adee ka hãbu debò ariteytenyke sabado txuu. Aõbo adeereny awire sabadotxu widỹỹ. Aõwihikỹwidỹỹmy aõbo ada aõbina widỹỹmy. Rubu‑ò wahidỹỹ aõbo ada rubu‑ribi itarasa aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Retehere! Ibutu‑ò idi hãbu‑ò rarybere: —Ebò inihe biditeòsinyke. Tiu hãbu tebò riteòsinyreu tahe, reytere. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Reburerenyre heka. Timybo Jesuisi risỹnyrenykemy rexinohõtinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Idi tahe Jesuisi heka hãwãlòratyy‑ò rare ixitòedỹỹmy Deuxu‑ò. Rureherehemy heka tamy rexitòenymy bede idi rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Txuijaramy tahe ludu mahãdu‑ribi waòinatxi reurò taheludutyhy mahãdu ritare. Tarybemy rybedumy rininirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sohoji ijõ heka, Simaõ inire, Pedromy idi ranire, ijõ tahe Andre rare, iseriòre. Idi Txiau, Joaõ, Filipi, Bartolomeu. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateu, Tome, Tadeu Txiau, (Kia Txiau heka Afeu riòre rare.) Ijõ Simaõ Kana bedeluduõ rare, tasubedeluudure. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juda Txiau riòre, ijõ Juda Isariò tahe Jesuisi tyhedỹỹdu rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Jesuisi dobehede bedero‑ò hãwãlò‑ribi. Tahe sõwemy iny iheludu mahãdu tii‑wana rỹimyhỹ. Judeia bede mahãdu Jerusalẽ hãwã mahãdu. Tule Kalileia bede, Tiro hãwã, Sidõ hãwã mahãdu. Tiiboho wii ributunymy hãwã mahãdu Jesuisi‑ò roholakemy idi reytekemy. Kia tai ròteytedỹỹmyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ibutumy Jesuisi tyky‑ò tamy adereximy risỹnymyhỹre adeytena iribi ròhònymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tamyreny retehere tai ibutumy rierynanyrenyre: —Kaiboho aõkõrenyre‑ki, beysebenyke. Deuxu Òlòna dori ahõrõreny rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Rama arasareri‑wana beysabenyke. Bihydymy dori mabekre. Tule tahinyteri wana beysakre ihewo‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Beysamy butxuenykre, inyõ umy radònykeki tule. Kaiboho dori Deuxu Riòre tetyhynytenyte jiarỹ tiire, Hãbutyhyhykỹ Riòre wahe. Kia mahãdu eramy ijira Riòre rỹikeki beysake. Beysa tyhyki tai. Biu‑ki dori aõwiwihikỹ bitakre. Deuxu rybemy rybedu mahãdu tule rotỹỹnyrenyre iòraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kobe làhàxe kaiboho ityhy mahãdu abedesanareny dorihe rexihura. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kobe làhàxe ahàdyreny mahãdu, aramasanareny dori rehemynyre. Kobe làhàxe abedesareny, ahinanareny dori abrunareny rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kobe làhàxe atyhydỹỹ sõwereny tule dori. Ilabiereny rybemy rybedutyhy aõkõ rityhynyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Warybe‑ò taholatenyteriki inihe ararybekre. Aòludu luumy atxibenyke amykyaradureny‑di, awimy idi mabeke. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ibinamy aõma umy rarybekeki aõbinahakỹ riwinykeki, tamy bexitòenykre Deuxu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aòsỹny‑ribi anahatenykeki iyre‑ribi iwyòdỹỹmy tamy bexirahòreke. Inyõ atyky riwykeki tule tamy arahana biwahinyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Iwese aõtxiu aõna inyõ adee rexitòenykeki, tamy biwahinyke ixyby iribi iwydykõkemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Aõbina inyõ adee riwinykõkemy atximahãte. Iwese tiu kia aõhõkỹmy inyõ isỹdỹỹõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kai aluu mahãdu sohojile iluuõmyke; òrarudu mahãdu dori tuu rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kai aery mahãduòle tawotòemahãte, timyki Deuxu‑ribi aõ atarasaõna. Iny itxỹte iehehe mahãdu dori widee rawotòemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","35","Òrarudu mahãdu heka widee rihuòtemyhỹre. Iribi tahe iwesele ixiby kidiwykemy idi riwisỹnymyhỹ. Kai ta buhuòtemyhỹke idi tehuòtete ixyby iraròsòkõmyke. Tukõkeki ta Deuxu‑ribi aõ atarasaõna. Aòludu luumy atximahãbenyke. Tai Deuxu‑ribi aõwiwihikỹ bitakre. Tai Deuxu wihikỹ riòremy mabekre. Tii dori inywi‑ò inybina‑ò awire. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Awimy kaiboho boibeke, iwese boreny awimy biu‑ki ratximyhỹre wese. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Inyõdee kyarakõmyke tai Deuxu adee rakyarananyheny. Inyõ taòraruna biixãwididỹỹnyõkeki, Deuxu tahe aòraruna riixãwididỹỹnyõkre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ainytyhyke inyõdee imyna Deuxu adee rainytyhynanyhyykre. Deuxu ibutumy aõwi adee riwahinykre. Tiwesebo tòwahite wesemyna idi Deuxu adee ròwahikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Aõmybo ribedeerynyre ijyyõmy relyyre: —Inyõ ruetà heka riwiòhenanyõtyhy iwitxira iny ruetà. Tukeki heka hãloo‑txi wiwana resekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ierysỹdỹỹ iòrysydỹỹdu, kia ratyre aõkõ ratximyhỹ. Kia uladu ratyyritinyre nihikỹmy tahe erysydu tiu taerysydỹỹdu ratyre ratxiõmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Òwòrukre nihikỹ aruety‑ki roire. Aõherekibo aseriòre ruety‑ribi òwòru rỹnysiõ tarasamy tewisỹnyteri. Kia heka itxenadỹỹdu tate. Juhuu òwòrukre aruewo‑ribi bitakre. Idi tahe betehemy iruewo‑ribi aõsõmo bitakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","44","Òwòru wihikỹ tiu bederaty binaõ riwahinyõhyymyhỹre. Tule òwòru binahakỹ bederatywimy raratynyõmyhỹre. Òwòru raerymyhỹre iraty‑ò itxere rỹimyhỹreu, beraty‑ò retehemy awire ada ibinare aõbo beraty‑ò retehemy awire ada ibinare aõbo. Figoraty uvaraty tiu iwitxira òwòru‑ribi raheõmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hãbuwi heka aõwimy rotỹỹnymyhỹre iwo‑ki tuu rỹimyhỹremyna. Tule hãbu bina aõbinamy rotỹỹnymyhỹ iwomy tuu rỹimyhỹremyna aõbina bina. Inyõ dori aõmy raraykymyhỹremyna rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kai rarybere boholaõkeki aõbo biwinykeki. Uritere wanidỹỹõmy. Wanyrỹmy tiwaninimyhỹtenyte tahe warybemynamy atxõhyylemyhỹtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tiwese hãbu warybe riywinyre wese adee ararybekre. Tiu heka ariteòsinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","49","Hãbuõmy akoreny arelyykre. Tii warybe‑ò roholare idi imynany rotỹỹnyre. Tii kiata taheto riwinyre manadelemy ria‑di. Beòra iheto reseõhyyre manatyre‑ki relereki wahe. Ikõmyta warybe‑ò roholakõre, kawese rotỹỹnyre. Taheto uritere sukile riwinyre. Beòrau ta, urile resere. Ikyhynakõreki wahe. Kiamyta rotỹỹnyre warybe tyhydỹỹdu‑ò idi ityhydỹỹdukõ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesuisi tarybe rahu‑di tahe Kafanaõ hãwã‑ò rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tai Roma soldado dinoduõ tai ihỹmyhỹ. Teòduõ tahe binamy irubu iòhòmy roimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Soldado dinodu Jesuisini‑ò roholareu tahe, iòrysymy rarybere. Taita judeu mahãdu kia matuariõ rexitòenyre aõma kididykremy riteytenykremy kia webinadumy roireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tahe Jesuisi nade juhu be kiamy Jesuisi rarybere: —Ka hãbu heka awi biwiòhenanykre heka. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ka hãbu heka waijoi luu nihikỹ rare ihyymy ta dohodỹỹna hetoõ riwinyre waijoi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Tai tahe Jesuisi rare tiiboho‑wana. Tehemyny sỹ iòhòmy rare. Idi tahe ryrowetyakile Jesuisi‑wana wii riòbynyre. Aõma soldado dinodu kia biòwa‑ò wahe. Rarybere he aõma soldado dinodu kiamy rarybereri: —Noõmy heka. Ihãrele teka awimy rareòle heka bedehe mynyke. Awi tate timy heka anaixiranyõtyhy dori raixỹruwỹhỹre alau adee ixitòedỹỹ‑ò aõma dori adee rybe rỹikekile aõweseleke wadeòdu kia reytemy reake. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jiarỹ dori inydee radỹỹdu jiarỹ rare. Aõbo riwinykemy. Kia riwinyre warybemynale kia heka jiarỹ rare. Wadeòdu‑ò rarybewãhãraki heka: —Kia biwinybenyke. Riwinymyhỹrenyre. Kai tule marybeke, beyteke. Tahe aõwese reytemy reake. Robedeòtiidỹỹnyre, kia tuu rarybereki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesuisi ròkesereri kia rarybemyhỹò wahe: —Jiarỹ ka tiu judeu mahãduy‑ki. Hãbuõmy rabiõ watyhydỹỹnamy. Rabireri riwatyhynyreri rabireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Soldado dinodu deòdu ròòkesereri. Ixyby reytereri idi ronyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesuisi rare terydỹỹna mahãdu‑di ijõ hãwã‑ò. Naĩ hãwã‑ò heka rare. Kiemy rahyymy heka rahyyre. Sõwemy iny iheki rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hãwã ijò‑ki rehemynyreu tahe kia ibutumyle rehemynyre. Sõwemy iny rubudu rareò wabede‑ò. Weryrybòõ rurure. Ise, wytese, heka iriòre sohojihyylere. Iny sõwemy heka riheludunyre tahi‑di taibru‑di. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tai Jesuisi tuu robireu, idi rexiwòtenymy kamy rarybere: —Ibrukõmyke! ");
INSERT INTO kpjNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesuisi debò ritidire caixaõ‑ò. Iu idi itxyydu ruhurenyre. Idi tahe rarybere: —Weryrybò, bexixake wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Weryrybò rexixamy reamy ronyre. Idi rarybere. Tai tahe Jesuisi ise‑ò riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ibutumy tasỹ mahãdu ribedeòtiidỹỹdunyre. Tai tahe Deuxu riwowydynymyhỹreny: —Ebe, aõherewe, Rybedu nihikỹ kỹnyhe witxijumy inydeereny rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kia taheka bede bede hãwãmy Jesuisini reare. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Joaõ heludu mahãdu ibutumy tuu relyyre iko. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Inatxinareny Joaõ riteònyre Jesuisi dỹỹraximy kamy wahe: —Kaiwe nodu aõbo tate, ada txiò aõbo ini nodutyhy ariraòrenykre? ");
INSERT INTO kpjNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Idi Jesuisi‑ò ròirenyre tuu itỹỹraxidỹỹmy; —Kai we nodutyhy tate? Ta txio aõbo ini ijõ ariraòrenykre? ");
INSERT INTO kpjNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","(Iu ta Jesuisi yla aõkõ webinadu, binanamy binana mahãdu riteytenyra, tyytybybinamy ykydu mahãdu, iruetà mahãdu sõwemy tule.) ");
INSERT INTO kpjNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Irahu‑di ta Jesuisi rarybere Joaõ ijoi‑ò: —Bòòsebenyke. Ibutumy kamy tabitenyta taholatenyta Joaõko‑ò tuu belyybenyke: —Iny ruetà bina mahãdu retehererimy, Iny rutiàre mahãdu rariarerimy, tyybinamy binana mahãdu reytererimy, iny nohõtity mahãdu roholarerimy. Iny rubu mahãdu heka rubu‑ribi rexixarerimy, urimynodu mahãdu heka Rybewihikỹ Tỹmyra‑ò roholarerimy. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iny bedesa heka rare, warybe tyhydỹỹdu mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Joaõ heludu mahãdu iribi ròhònyreu tahe Jesuisi rarybere Joaõ bededỹỹnanamy: —Aõmybo wahe Joaõ‑di tõhõtinytenyte aõmy tubedi nohõtinyrenyre tamy itxerena bederahy tòitenyteki wahe. Otxirarade wese yhy‑ki idi tahõtinytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aõma hãbu urimynodutyhy aõbo tahõtinytenyteri. Hãbu tyywihikỹdiremy tahe tahõtinytenyte. Iwese iòlò taheto wihikỹ‑ki ratximyhỹre wesemy aõbo tahõtinytenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wadee manarybeke aõbo betehekemy tahõtinytenyteri. Deuxu rybeduõmy aõbo tahõtinytenyte. Inatyhy tii rare. Kia ratyre heka tii rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aõma dori tyyriti‑ki rarybemyhỹre: —Tii heka wakoki kadehemynykemy ratximyhỹre, tamy relyykemy, ryõ riywinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Inatyhy kaa rare. Tie heka ibutu hãbu ratyre ratximyhỹre. Ihãrele tahe inyõ Deuxu Iòlòna‑ki ratxikeki heka iratyre ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tahe nieru butudỹỹdu mahãdu kia‑ò roholare. Tule sõwemy iny kia‑ò roholare. Tiiboho Deuxu bede ywina tyhydỹỹdu mahãdu roire. Tule Joaõ Sebedỹỹna mahãdu roire. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseu mahãdu tahe, bede ywina erydỹỹdu mahãdu tahe Deuxudeewina dera rare. Tai Joaõ‑ò ratisebemy roiõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","—Mowesebo heka wijinabòdu mahãdu wesemy ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Uladu mahãdu wesemy tiiboho ratxireri. Tiiboho ijõ uladu mahãdu‑ò ryrymyhỹre: —Inyboho rawiunyre, tahe kaiboho teseõtyhy. Wobina wiu rawiunyre tahe kaiboho tahinyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Joaõ Sebedỹỹdu renareherenyõmy rỹire, vĩĩ riõõre. Ihãre tahe kaiboho tarybete: —Tii tyytybybina‑di ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Hãbutyhyhykỹ jiarỹ rare, Deuxu Riòre wahe. Jiarỹ reroximyhỹre tule reõmyhỹre. Tai tahe tarybemahãte jiarỹ wabyre nihikỹlemy wamomohõkỹremy. Jiarỹ riki òrarudu liinatyhy heka jiarỹ rare, nieru tarasadu liina wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ihãre tahe aõikõkõlemy heka taraykynymyhỹtenyte ihãre taheka òbitilemy ixi‑di tahõtinymahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseu mahãduõ heka Jesuisi ritobinyre taheto‑ò roximy. Jesuisi tahe rare idi ronyre roximy. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kia hãwã‑ki tahe hãwyyõ rasỹnyre, wydena wahe. Tii heka Fariseu heto‑ki riroxirerimy roholareu, tii tule rare. Tahe hyna òwyhykỹ rimyre. Alabastro aderònahynani rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Hãwyy tahe Jesuisi hewomy ronyre, iòhòmy. Tahe aderòna ritxiwire iwatyre. Tule iwa‑ki ruworuwòmy ratximyhỹ irube‑di iwa risuhòra idi irade‑di rabunyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fariseu kiamy robireu, ixideele rarybera: —Kia hãbu Deuxu rybeduõ aõkõ rare. Tuukeki tii hãwyy rieryke aõhãwyybo tii ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesuisi tahe fariseu‑ò rarybere: —Simaõ, adee ararybekemy watxireri. Simaõ tahe rarybere: —Manarybeke Waerydỹỹdu! ");
INSERT INTO kpjNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tahe Jesuisi rarybere: —Nieru huòteduõ heka inatxi hãbu‑ò nieru riwahinyre. Ijõ 500 rihuòtera, ijõ tahe 50my rihuòtera. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Idi tahe hãbu inatxi nieruõhyymy rỹire òòsemy tanieru tamy. Tai tahe nieru huòtedu riwotòenyrenyre tahe ritusanyre, wiwana iòwy riixãwididỹỹnyre. Tibo huòtedu ilàhànadỹỹdu tyhyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simaõ dirawyònyde: —Kia òsana 500my rihuòtere. Tahe Jesuisi rarybere: —Inatyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesuisi tahe hãwyy, riijemy, tahe Simaõ‑ò rarybere: —Kahãwyy ini bidiijeke. Jiarỹ nadehemynydeu, tii tarube‑di wawa risuhòra. Kai beeõ tadiwyòte. Tii tarube‑di riwawasuhòra. Iu tarade‑di riwawarabunyra. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kai tiwawehityhynanyõte rehemynyrau, tii tahe riwaatyõhyymy ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kai warade‑ki òlỹre tetxiwiõta tii tahe aderòna wawatyre‑ki ritxiwire. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tai tahe adee ararybekre. Tii inatyhymy waluure. Taòraruna ixãwidỹỹna‑ki. Inyõ iòraruna ibutemy raixãwidỹỹnymyhỹreki, tii inatyhymy aõkõ taòraruna ixãwidỹỹdu luure. Ijõ tahe inatyhyhykỹlemy taòraruna ixãwididỹỹdumy reamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tai Jesuisi hãwyy‑ò rarybere: —Aòraruna reixãwididỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tai roxidu mahãdu widee raryberenyre: —Mohãbubo kia rare? Tii òraruna riixãwididỹỹnyrerimy. ");
INSERT INTO kpjNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tahe Jesuisi hãwyy‑ò rarybere: —Atyhydỹỹnamy texitarasadỹỹnyte aòraruna sõwe‑ribi biu‑ò hena tetateri. Mata hỹny. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Rexideleny raremyhỹ ralòralòmy hãwã hãwã ikõkõmy reamy rare kia aõma Deuxu Rybewihikỹ Tỹmyra relyymy rare. Tai ierdỹỹna mahãdu waòinatxi reuròmy idi ròirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tule hãwyyõ tiiboho wana ròirenyre Ijõta Marie Madalena heka rare. Juhuu tahe tyytybybinahakỹ‑di raremyhỹ. Idi debò inatxi reuròmy tyytybybina iribi riòlòdỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ijõta Joana Kusa hãwyy rare. Tii iòlò Herodi heka aõmysỹdỹỹdu heka rare. Tule ijõ hãwyyõ Susana inire. Idi tule ihona hona Jesuisi taijoi‑wana ibutumy tanierureny‑di riwiòhenyrenymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Idi iny sõwemy titxiribibo dirahude kia‑ò. Kia mahãdu‑ò heka Jesuisi ribedeerynyre ijyyõmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Alòbòròna‑di dehudu heka ròhònyre taoworu‑ò. Alòbòròna‑di imahãdu ijõ ryro‑txi resere. Tai heka iny rariamyhỹre alòbòròna tyre‑ki. Nawii tule tuu riroximyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mana rotysu‑txi ijõ rejuxunyreri mana rotysu‑txi suu dori ibututere tai tahe iraruxiõlemy raumynyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ijõ tahe edey‑txi resere. Raumynyreu tahe edemy riòhỹtỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ijõ resere suwi‑txi. Tai ta raumynyre idi sohoji alòbòrònaty‑ribi 100my raratynyre. Jesuisi tamy rarybere: —Kaiboho õhõtirenydikeki heka inatyhymy warybe‑ò boholabenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tai tahe Jesuisi‑ò rỹỹraxinyrenyre: —Aõwe kaa tekewesenanyteri? ");
INSERT INTO kpjNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesuisi rirawyònyre: —Kaiboho heka teerytenyte aõbohe wasimy ijyy rare Deuxu dori adeereny ritỹnynynyre. Kia tahe rare, Deuxu Iòlòna aõmydỹỹnana wahe. Ijõ iny‑ò tahe rarybere ijyy‑di relyyre. Tai robikre tahe, rieryõtyhyke. Roholarenykre tahe rieryõtyhyke, timybo juhuu Deuxu rybemy rybedu mahãdu rarybere wese. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aõmybo kia aõijyybo kia rare wahe. Alòbòròna heka Deuxu Rybewihikỹ wese rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ryro‑txi resere heka ijohonadu wesemy rare. Deuxu ijyy heka resera ede sõwey‑ki. Tii heka Deuxu Rybe‑ò roholamyhỹre mahãdu wese rare. Idi tahe Satanasi heka ritamyhỹre iworeny‑ribi. Tai rityhynyrenykõmy idi biu‑ò rahenyõkremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ijõ tahe manasuõ‑txi resere heka, kia Deuxu Rybe‑ò roholamyhỹre mahãdu wese rare. Rybe‑ò juhuu roholamyhỹre deysana‑di rityhynymyhỹre. Kia manatyre resera heka irarutiõhykre. Iny mahãdu wese heka rare. Idi ikyhynakõreki, iwodelòlòtõmoreki urile tatyhydỹỹna riatymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ijõ tahe edesuyky‑txi resere heka, kia Deuxu rybe‑ò roholamyhỹre, idi iworekena sõwemy, iaõdelòlòtõmomy, idi ityhyna wahe urile riòhòtỹnymyhỹre. Tai ròwiòhenadỹỹõhyymyhỹre Deuxu tyhydỹỹna‑ki. (Kia tahe alòbòrònaõ ede yky‑txi resera tahe iny umy witxira wesemy heka rare. Iny umy tyhyna idi ratxireri heka kia wesemy kia ede‑txi iny reseremy. Aõma kia inytyhyna ratxireri. Tiu heka ityhydỹỹna riòlòdỹỹõtyhy. Kia alòbòròna tahe tai heka rokuõtyhy.) ");
INSERT INTO kpjNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kia ijõ alòbòròna suu witxi‑txi reserá tasỹ iwitxira inywesemy rare. Kia ijohonadu aõma rierymyhỹre. Irayky‑ò ralòmyhỹre. Kia iwotyhywo‑ò òbitimy ratxirerí tahe, òbitilemy aõ riwinymyhỹre. Iwese kia alòbòròna sõwemy ratyy rawahinyre wese tahe tii rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ijõ ijyy tahe kiamy roire. Uritere inyõ loosònaõ rideõmykre butxi rawo‑txi ada herina rawoõ‑txi aõbo. Loosòna bidekre bedewiõ‑ò. Tai tahe ibutumy bede ritoosònanykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aõ heka tai wasimy ratxiõhyymyhỹre. Aõutxumy dori ibutumy erynamy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tahe bexijebenykre ijohona‑ò. Kia sõwemy idi rỹirerimy ihỹre heka sõwemy rimykre. Kia urihimyò iwo‑ki rỹireri heka iribi ritakre. Idi ibutumy rỹireri heka iribi ritakre. Urihimyò iribi iny ritakre. Urihimyò iwo‑ki rỹireri heka hulemy iribi ratakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesuisise, tariòreboho tamy doide. Tii ròbedeerydỹỹmyhỹki isirare tamy dehemysỹ iny sõwe òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tai inyõ Jesuisi‑ò rarybere: —Adihe wa aseriòre boho hewa ahanakile ratxireri umy robikemy ratxirenyreri. Adee rarybekemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tai Jesuisi rarybere: —Waseriòre wa kia Deuxu rybe erydỹỹnaõ rare. Kia tamy roholamynyrele heka rityhynymyhỹrele heka nadi wesele rare. Tii‑wana iwese waseriòre wesele rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Iribi tahe hãworo rorukurenyreu Jesuisi rarybere: —Ròkòireny kanawe‑ribi ijà‑ò. Idi tahe roirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Jesuisi rõrõmy tòru‑ki. Idi tahe yhynihikỹ òbònihikỹ‑wana tamyreny reare. Ruberurenyre tiiboho rỹmyrenyke lau. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tai tahe wylemy riixixanyrenyre: —Erydỹỹdu, Erydỹỹdu rekekoarenykre berahatxi‑ò. Idi Jesuisi donymy deademy tahe yhy dee rarybere: —Biyryke, Biyrykewa. Yhy ruhumy resere. Òbò tule ruhumy ibutumy riyryre, iny rurukre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","—Kaiboho tiwexe ainatyhynareny? Tiiboho rabedeòtidỹỹmy ruberumy widee raryberenyre: —Aõhãbuwe kaa rare. Yhyhykỹ dori òbò dori irybemy reòbyreri. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kanawe‑ribi ijà‑ò rehemynyrenyre Kerase bede‑ò kalileia aho weribi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Hãbuõ heka tamyreny dobehede hãwãhãkỹ‑ribi tamyreny dobehede. Tiiboho riòtyròny hãwãro‑ribi iu ta tyytybybina‑di ratximyhỹre hãbu tiu rexityynyõhyymyhỹre tatyy‑di hyymyhỹre. Kiamy wabedekihyyle ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesuisimy robireu tahe bedetxile resere tairy‑di ryryre: —Aõhebo biwasỹnykre Jesuisi. Kai Deuxutyhy Riòre atxiteri. Uritere aõhõkỹmy wasỹdỹỹõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tahe Jesuisi heka tyytybybina iribi riòlòdỹỹnyre. Sõwemy dori riuwinyre hãbu rimymyta. Riuwinyre idi rihure. Tai heka tii uritiere womati reroti‑di ritaataamy riijemyhỹre. Ihãre tahe ixi‑ribi riòròmyhỹre. Tai bedero‑txi reamyhỹre tyytybybinamy rawonymy. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Idi tahe Jesuisi rỹỹraxire tamy: —Mobo anire? —Sõwemy wanire. Tyytybybina sõwemy dori tuu rexiykynyreki. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tiiboho raryberenyre: —Uritere bedebinahakỹ‑ò wateòdỹỹrenyõmykre. Uritere sỹu‑ò noõma rarekremy hãlootxi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Iu tahe ixỹni juramy riroximyhỹ hãwãlò‑ki. Tai tyytybybina mahãdu Jesuisi‑ò rarybere: —Biwateònyõke. Kowa ixỹnijura‑ò biwateònybenyke aralorenykremy. Tai Jesuisi riròtenyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Iu kia hãbu‑ribi tyytybybina ròhònyrenyreu tahe ixỹniwo‑ò ralòreki wahe. Raòlònyra ijò‑di rejuxunyre taraò wahe. Ibutumy ahoro‑txi rejuxunyre. Ibutumy rururenyre berahatximy. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ixỹni‑di itxeredu mahãdu ibutumy raijiranyra hãwã‑ò tule relyyrenyre tuu iny rasỹnymyhỹre mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tai iny dirahude tamy itxeremy. Idi tahe rare Jesuisi‑ò. Hãbu robimyhỹrenyre tatyky‑di ronymyhỹ ibutumy rexiywinymy Jesuisi‑ribi iòhòmy ronyre. Kia iny mahãdu heka sõwemy ruberure rabedeòtiidỹỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ibutumy relyyre. Kia tyytybybina timybo aõhebo rotỹỹnyremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kia Kadara bede ludu kia mahãdu tahe rexitòenyre Jesuisi‑ò iribi ròhònykremy, ilau ruberurenyreki wahe. Idi tahe Jesuisi ròkòsere ixybyle reare hãworo‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Hãbu tahe rexitòenyre Jesuisi‑wana rakremy, kia tyytybybina‑di iwo‑ki ratximyhỹ wahe. Tamy rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Aõkõre bòkese aheto‑ò. Ibutumy belyyke aõbo adee Deuxu riwinyremy. Tai ta ibutumy hãwã hãwã‑ò relyyre aõhebo Jesuisi risỹnyremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kia iny sõwehekỹ mahãdu heka teysa‑di rimyre ridyremyhỹre riraòhyymy ratximyhỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kia hãbu dohodỹỹdu hetowo erydỹỹdu tahe nade Jesuisi‑ò. Tii heka dohodỹỹnana dinoduõ rare. Ijairu inire Jesuisi‑ò sutxi resere: —Mynake wasỹ Jesuisi ");
INSERT INTO kpjNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jiarỹ wa wariòre sohojile rare waòinatxi reuròmy iwyra. Tii ka rurukremy roireri. Idi ta Jesuisi rare isỹ‑ò. Sõwemy iny Jesuisi riheludunyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hãwyyõ raremyhỹ heka hãwyy webinadu rare iòhò Jesuisi rexisỹny waòinatxi beòramy heka idi ròhònyre hykyky hãlubu ratxireri. Tiu heka inyõ reteytenyõhyymyhỹre luahidỹỹdu, òhotibedu mahãdu he risiranyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tai tahe Jesuisi tykysi‑ò reare. Tai ta aõwesele reytemy reare. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesuisi rarybere: —Mowe watxi reare? Ijõ rarybereri: —Erydỹỹ mahãdu aõkõre, jiarỹboho aõkõre. Pedro rarybere: —Aõheta sõwe iny kaki rỹireri. Timykibo tuu tỹỹrayiteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","—Jiarỹ dori reeryre. Mobo watxi rearaule reytera. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tiihe hãwyy ratxiremyhỹ ramytatamy. Tamy ramytatamy heka tamy rehemynyre. Iòraò rexibedenyre. Ibutumy iko tuu relyyre. Aõherekibo itxi reriramy. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tai tahe Jesuisi tamy rarybere: —Lerỹ, atyhydỹỹna myna teyteta. Ta bexiywinymytahỹny maa! ");
INSERT INTO kpjNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kie raryberemyhỹwanale tasỹ iny witxiraõle dehemynyde. Kia aõma dohodỹỹna wedu heto‑ribi dehemynyde. Ijairu‑ò rarybere: —Ariòre wa rurura. Uritere ta òhotibedu‑ò ijiraõma ixinamy tii rakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesuisi kia‑ò roholareu tahe Ijairu‑ò rarybere: —Urile bityhybenykre. Breburenyõma tii reytekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tii rehemynyre heto‑ò. Jesuisi ralòre iny deramy reare. Tii wana rake lau. Kia uladuse, uladutyby, Pedro, Txiau, Joaõ wana kiale ralòre tamy tiiboho wana. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ibutumy rasỹbinamyhỹ Jesuisi rarybere: —Ibryrenyõmyke hewa rurumy aõbo roire, urile rõrõmy roireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ibutumy rieryrenyreri tiiboho urile tai idi risinyrenyre rurumy roimyhỹki. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesuisi ihãre ta hirari debò‑ki rimyre. Tai tahe idi rarybere: —Hirari, bexixamy, bodonyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ityytyby aõwesele ixityre tamy ralore. Dexixade, donyde. Rỹsỹna hirari‑ò riwahinykemy Jesuisi rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tai tahe tybyboho sõwemy rabedeòtidỹỹrenyre rabedesarenyre. Jesuisi rarybereri: —Urile wamy ijyyrenykõmykre. Aõbo adeereny rewinyramy. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesuisi tahe tawaòinatxi reurò taerydỹỹna mahãdu ributunyre. Taruru tamy riwahinyre tyytybybina iny‑ribi ritakremy. Tule iny webinadu mahãdu riteytenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tule rarybere tamyreny: —Kaiboho belyybenykre Deuxu kia Iòlònamy tule webinadu biteytenybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aõ awanareny wydyrenyõmykre debòna aõkõ, aõna hyna tule aõkõre. Tule rysỹnake aõkõ, nieruke aõkõ. Ainatxityyke aõkõkre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hãwã‑ki hetoõ‑txi malòkeki taile bonykre. Hãwãribihyyle bòhònykreu, kia heto‑ribi bexitakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ibinamy aramyrenykreki, urile bixitakre. Idi òlòna‑ki, awa bitòtynykre ibinamy tai tahatenytaki. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tiiboho ròirenyre hãwã sõmo sõmo‑di Rybewihikỹ Tỹmyramy relyyrenykemy ròirenyre. Tule iny webinadu ibutumy iteyteynyrenyre hãwã hãwã‑di. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Idi tahe iòlò Herodi ibutumy heka aõna aõna rierymy ratximyhỹ. Tai tii bede ryy rieryõhyymy ratximyhỹ aõbo riwinykre. Roholamyhỹre heka iny rybe rybe‑ò. Joaõ heka rexixamy ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ijõ tahe kiamy rarybereri: —Eliasile ratxireri. Ijõ rarybere Deuxu rybemy rybeduõ ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tai tahe Herodi kiamy rarybereri: —Jiarỹ heka Joaõra resymy rewahinyre. Mobo ratxireri iwese Joaõ raremy wese he ratxireri. Moobo ta kiamy raholamy watxireri. Tai Herodi tuu robikemy riwisỹnymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesuisi eryna iko relyymyhỹreny ibutumy aõbo aõhebo rotỹỹnyrenyremy tabededỹỹnana. Jesuisi riòlònyrenyre ijõ hãwã witxira‑ò, Besaida hãwã‑ò wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tai iny sõwemy hekỹ rieryõlemy idi ta rieryreu tahe sõwemy ihemy rare roirehe. Jesuisi he ributumy ikole relyyre. Deuxu Iòlòmy relyymyhỹre. Tai ròteytedỹỹmyhỹ webinadu mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Aõtxu tahe katxioromy Jesuisi eryna mahãdu, waòinatxi reurò mahãdu tamy raryberenyre: —Bede biywinyke ibutumy iny rỹireri hãwãõ‑ò tarỹsỹna õbradỹỹmy. Inyboho dori bedero‑ki ratxirenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tahe Jesuisi rarybere: —Kaibohole rỹsỹna biwahinybenyke. Rirasỹnyrenykemy ierydu mahãdu diwyònydenyde: —Aõheretahaka, iruyre orotxu idi inatxi uturale heka roireri. Aroikemy aõbo wadireny atxiteri rỹsỹna õbradỹỹmy inysõwe‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Txibo 5000 hãbu sõwemy heka rỹimyhỹ. Jesuisi rarybere: —Bihitxinybenyke 50 iny heka iny bisỹnybisỹnybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tii myna ieryna mahãdu rotỹtỹnyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Idi tahe Jesuisi utura inatxi, orotxu iruyre rimyre. Biu‑txi reteheremy rexitòenyre. Deuxu reàlàre tamy rexitòenymy riyreyrenymy riwahiny taerydỹỹna mahãdu‑ò. Riwyrenyre tahe riwahiriwahinyrenymy idi roire. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ibutumy riroxirenyre idi rihydyrenyre. Ihãre ta waòinatxi reuròmy hyna ixyby rỹximy rauhenyre. Idi ierydỹỹna mahãdu ixyby ributunyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jesuisi heka ixisohojile rare ixitòedỹỹmy. Ierydỹỹna mahãdu heka irarò‑ki rỹimyhỹ riijemy rỹimyhỹ. Idi tahe tamy nade tỹỹraximy: —Moboho jiarỹ raremy wamy raryberenyreri? ");
INSERT INTO kpjNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tai narybedenyde: —Ijõ Joaõ Sebedỹỹnamy adireri. Ijõ ta Eliasimy adireri. Ijõ ta juhuu Deuxu rybedu mahãduõmy adireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesuisi tamy rarybere: —Adeereny tahe. Mobo jiarỹ watxireri. Idi Pedro rirawyònyre: —Kai Kristu tate, Deuxu deòdỹỹna wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tahe Jesuisi tamy rarybereri: —Uritere tuu iny‑ò ijyykõkremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jiarỹ Hãbutyhyhykỹ, Deuxu Riòremy, aõhõkỹmy arotỹỹnykre. Judeu wedu mahãdu, xiwena wahidỹỹdu wedu mahãdu, bede ywina erydỹỹdu mahãdu waderamy reakre. Jiarỹ arurukre. Inataõna txu‑di arexixakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Idi ibutu‑ò rarybere: —Wahemy kanake mahãdu urile ixi dee rexiijõnykre. Txuõ txuõlemy taitxeò rimymy kidiwaheludunykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Waòrary‑ki rubudu heka biu‑ò hedukre. Tukõkeki urile ixinany inatyhymy rurukre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Aõmydỹỹnanamy iny ritakeki, tahe taumy riõnonykeki, kia heka aõmy aõkõkre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Inyõ raixỹrukeki warybe lau tule jiarỹ Hãbutyhyhykỹ, Deuxu Riòre wahe, tai ilau araixỹrukre. Deuxuko‑ò ỹjuko‑ò iu adehemynysỹu Deuxu Iòlòna‑ki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Inatyhymy heka adeereny ararybekre. Ijõ kaki rare. Deuxu Iòlònamy robikre tarubukõtyre ");
INSERT INTO kpjNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tahe debò inataõ txuu rỹidi, Pedro, Txiau, Joaõ‑wana Jesuisi ridyre. Tiiboho sohojile bederatòò‑ò roire Deuxu‑ò rexitòenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesuisi rexitòenyreriu tii tamyreny rexiwitxiranyre iu rexitòenyreu ityy heka urile rabòtòranyre. Iurahakỹmy relere. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Tahe tamyreny dexitỹnynyde Eliasi, Moisesi‑wana tahe rarybemyhỹre Jesuisi‑wana. Jesuisi rubunamy Jerusalẽ hãwã‑ki widee rarybemyhỹrenyre, kia Deuxu bedeywidỹỹnana myna. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedroboho rõrõrenyreri. Idi tahe rexixarenyreu, tiiboho Jesuisi loosònamy robirenyre. Eliasi, Moisesi‑wana tiiboho tuu robirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ròireriu, Pedro rarybere Jesuisi‑ò: —Wawedu, awityhymy inyhe inyboho kaki ratxirenyreri tahe rikiwinyrenykre inataõ hetomy, ijõ adee, ijõ Moisesi‑ò, ijõ Eliasi‑ò. Pedro rieryõlemyhỹre aõmybo rarybemyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tai rarybereu Nonoe dobehede iubòròna bede ritòbònyre. Pedro, Txiau, Joaõ‑wana ruberumyhỹrenyremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tahe ròhònymy reare rybeuni iuribi: —Kia heka Wariòre waluu rare. Kaiboho tamy boholabenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tiiboho reteherenyre tahe inyõmy robiõlerenyre Jesuisilemy ta robirenyre. Tahe rybeõmy rỹirenyre. Iu inyõ‑ò aõmy raryberenyõre tuu. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tai tahe ijõ txu ratò‑ribi dehemynydeu iny sõwehekỹmy Jesuisi‑ò ròirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Inyõ rarybere: —Erydỹỹdu, wariòre adee redyreri. Beteheke wariòre sohoji‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tyytybybina rimymyhỹreu tahe riatyre bede‑ò. Idi tahe urile txuu riyiyidỹỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aerydỹỹna‑ò jiarỹ rarybera tyytybybina riteònykremy, tahe tiiboho riixãwidỹỹnyõhyyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesuisi tamyreny rarybere: —Tiwesebededỹỹnanabo wijinabòdu ityhyõlemy rỹira. Tiwesebededỹỹnanabo akyreny‑ki ariijekemy. Wadee uladu bididyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tahe didydenyde Jesuisi‑ò. Tahe tyytybybina urile riitxỹteitxỹtenymy resere. Idi tahe urile bede‑ki rexiraòhòòhòremy sutxi resere. Idi rarybexinymy. Rybexi irywomy ròhònymyhỹ. Jesuisi tahe tyytybybina iribi riòlòdỹỹnyre uladu riteyteyre. Idi uladu tyby‑ò riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ibutumy iny Deuxu aõwidỹỹna‑di bede riòtiinyre. Jesuisi taerydỹỹ mahãdu‑ò rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Boholatyhyki warybe‑ò, Deuxu Riòre Hãbutyhyhykỹ heka rawahidỹỹkre hãbu mahãdubinaõ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tiiboho rierykõlere. Kiamy dori ilaureny riwore. Tahe ruberurenyre tỹỹraxidỹỹki. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ryro‑ki ierydỹỹna mahãdu widee rarybemyhỹre: —Mowexe wiratyre ityhykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesuisireny rexiraykynymyhỹreny rieryre. Idi tahe uladuõ rimymy rarybere. Jesuisi uladuõ wana ronyrenyra. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tahe taerydỹỹna‑ò rarybere: —Moõ uladu ka wese wadee riwiòhenanykeki, riwawiòhenanyre. Moõ riwawiòhenanykeki, tule waha riwiòhenanyre. Mobo deòdumy reakre, tii ibutu ratyrekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Joaõ tamy rarybere: —Erydỹỹdu, jiarỹboho riòlòdỹỹnyrerimy tuu rabirenyra inyõ tyytybybina‑di animy rehureriò. Tahe iny mahãdureny aõkõ rare. Tahe jiarỹboho tamy reijõnyrenyre iny inyijoirenyre aõkõki. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tahe Jesuisi rarybere: —Biijõnybenyõkre. Inyõ inymyrenydòdukõkeki, inyweribireny‑ki tii rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tahe Jesuisi bededỹỹnana iixihidu iòhòmy idi biu‑ò rakreu, tii Jerusalẽ hãwã‑ò rakremy rexiywinyra. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tahe takomy inybute bede riywinyre. Tai itỹhinamy rutòmy Samaria hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tai tahe Jesuisi deramy rekoarenyre Jerusalẽ‑ò ramyhỹreki. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Txiau Joaõ‑wana kia rierymy tahe narybedenyde: —Wanyrỹhỹkỹ, adee wikeki heòty biu‑ribi ityrereny kedesekemy aritxuhorenykre risõrenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tahe Jesuisi irybereny‑ki ibinamy rahare tahe reburemy taò riòòsere iribireny. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Idi ta iwitxira hãwã‑ò roire. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tahe Jesuisi taerydỹỹna mahãdu‑wana roirenyreu, hãbuõ tamy rarybere: —Ihyymy awana arakre titxibo makreu, ahekile arakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tahe Jesuisi tamy rarybere: —Ijòrò heka ihãloo dire. Nawii tỹtỹ dire. Tahe jiarỹ, Deuxu Riòre wahetoõre, Hãbutyhyhykỹ rare hãrele. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tahe ijõ hãbu‑ò rarybere: —Biwaheludunyke. Tahe tii dirawyònyde: —Wanyrỹ, Waha heka rurura. Tai tahe juhuu arituunykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesuisi rarybere: —Txioinihe, rubu mahãdu wii rituunyke. Kai tahe makre Deuxu Iòlònamy belyykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ijõ rarybere: —Wanyrỹ, araheludunykre. Urile juhuu wasỹ mahãdu arawehityhynanykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tai Jesuisi dirawyònyde: —Inyõ ritelenykeki, tahe ixyby òòsemy rexinohõtinykeki, tii waheludu mahãduõmy rareõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jesuisi 72 hãbu heka ritare inatxi inatximy tako‑ò tihãwãhãwãtxibo rakreò bede riywinyre. Kiamy tamyreny rarybere: —Waijyymy rybemy boibenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kiamy heka tamyreny rarybere: —Waaõmysỹdỹỹna heka inihikỹ‑di isirare. Iwese maixõmo iny riòròmyhỹre wese heka waaõmysỹdỹỹna rare. Maixõmo oworu heka inihikỹre, idi aõmysỹdỹỹdu heka ibutere. Tai oworuwedu‑ò aõmysỹdỹỹdumy bexitòenybenyke, Deuxu‑ò wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kiaboho heka budoeni wesemy iyreny‑ki boibeke. Kia‑ribi nohõti losaõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","5","Tai heka bexiijebenykre anierureny wydyõmy. Aõna aõna renyhynykeõ aõkõ awareny wydyõmy iny‑ò ryberenyõmy iny iny‑ò ryberenyõmy, rywetyatyamy abededỹỹna nodỹỹmy. Inyheto‑ò malokreu Deuxu deysanamy birybenybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tii adee awirenykre wana heka teysakre kahetoludu. Tai tahe ixibyle adee Deuxu deysana ròòsekre adee awiõhyykeki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","9","Aõma hãwãõ‑ò malò‑wana uritere deuròsò deòròsòõmy matximahãke. Tai tehemynymy atxiterikile bexiijemahã tetxilemy. Uritere rỹsỹna òta òtaõ aubeò ritidi wana uritere rybeòlòõmy. Birỹsỹmy rybeõlemy. Awiòhedỹỹmy ruruke wana bimymyhỹ aõbo adee riwahinymyhỹre. Iny raaõmysỹdỹỹmyhỹre heka ròtamyhỹre. Kia wese heka biwinymyhỹke. Birỹsỹmahãke aõbo adee riwahinymyhỹke. Binaõ roiwana biteytenymahãbenyke. Kia wesemy tamy marybeke: —Deuxu Iòlòna heka iòhòmy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Hãwãõ‑ò birònykeki, inyõ aradyrenyõkeki, boibenyke hãwãky‑di. Myỹ marybebenyke tamyreny: —Aõbo wawa‑ki hãwã‑ki rỹireri. Wawa aritòtynykre bryby iribi ròhònykremy. Adeereny ariteòsinykre nohõti ijaranamy tamyreny. Nohõti losarenyõmy Deuxu Iòlòna adeereny iòhòmy dehemynyde. Tahe kaiboho teramy tekoatenyte. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aõma ywisidỹỹnatxu heka tiiboho aõhõkỹmy rotỹỹnyrenykre. Jesuisi rarybere: —Tiro hãwã Sidõ hãwã heka awimy aribireny ròhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kobe làhàxe kai Korasĩ hãwã, tule Besaida hãwã. Òhotibe ayreny‑ki rỹire, kia heka Txiru hãwã, Sidõ hãwã tule kire‑wana taõ òta òtareny‑ribi rexiatyrenyre. Tiiboho tykysausuhukỹtyre rexisỹnyre bryby‑di rexierenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","15","Òhotibetxumy heka Deuxu raruxetòenykre Txiru hãwã mahãdu, Sidõ hãwã mahãdu! Kaiboho tahe aõkore. Deuxu araruxetòenyõkre. Kai Kafanaõ hãwã yludu mahãdu aõbo adeereny rotỹỹnykre. Biu‑ò aõbo bòibenykre. Aõkõ heka heòtybina bede‑txi heka boibenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tahe Jesuisi taerydỹỹna mahãdu‑ò ixyby rarybere: —Inyõ aradyrenykre wana tasỹ‑ò. Iwese riwadymyhỹre wesele, aradyrenykre. Moo adeereny roholamyhỹre iyrubu wadee roholamyhỹre. Wana tahe waderalemy reamyhỹre. Waderamy reamyhỹre tahe tule Waha deramy reamyhỹre. Deuxu wateòdỹỹdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tanonanareny‑ribi iribi tahe kia erydỹỹna mahãdu ibutumy dòòsedenyde. Tiiboho heka teysa nihikỹmy dòidenyde. Tybybinanahakỹ heka irybe‑ki ròhònyhỹre irybereny‑ki. Riòlòdỹỹnymyhỹreny wana Jesuisini‑di heka ròhònymyhỹre kiamy Jesuisiko‑ò tuu relyyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tii rarybere tamyreny: —Bexiijebenyke jiarỹ dori Satanasimy biu‑ribi rabire, biudelaa wesemy reseremy tuu rabire. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Inatyhy rare waruruke nyderi rewahinyre. Tai hemylala tyre‑ki mariabenykeki. Tiu inyõ ruruõtyhy itytibòrò nihikỹ arawerenykeki, tiu buruõtyhy. Tule kai aòludu rururatyre arurureny‑di boibekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ihãrele tahe uritere deysarenykõmy atxibenyke ka ruru òraru‑ki tyytybybina deòdỹỹna, ruru wahe. Kaiboho dori anireny raritinymy roimyhỹre biu‑ki kia ta ateysanarenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Iule tahe Jesuisi reysare heka Deuxu Tyytybytyhy iwomy reareu. Kiamy rexitòenyre: —Waha, kai wa biuwedu tate ibutu bede wedu tate. Umy reàlàmy watxireri tamy retòenyre. Wadeysamy watxireri ka aõma dỹỹnana bederaremy nihikỹ iribi tewòmy atxiteriki wahe. Tamy hete iwese iny uladu wesemy rityhynymyhỹre heka. Tai tahe tamy ritỹnynymyhỹre. Kia adeewimy tuu rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jiarỹ heka ibutumy Waha wadee riwahinyre. Inyõ rieryõhyymyhỹre Waha wahe. Waòrarukile tahe iny rierymyhỹre. Mobo Waha rare wahe. Waòrarukile dori rierymyhỹre. Ijõ aritỹnynykemy watxireri. Tai tahe tiki tule riery iruru. Taile rierykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Rexitòenymy rahudi tahe wasimy iwòtemy heka rarybere taerydỹỹna mahãdu‑ò: —Kaiboho heka sõwemy aõwiwihikỹmy tabimyhỹtenyte. Tai kaiboho beysabenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ihetxiu heka Deuxu rybedỹỹdu wana kia aõmysỹnanamy iòlò mahãdu wana. Kaireny aõmydỹỹnanamy robikemy risỹnyre, tahe aõkõhyyre. Wijile heka tuu robireri aòrarureny‑ki. Tule tabitenyteri kaiboho ratximyhỹ inatyhymy aõbo òbitimy Jesuisi ijyy‑ò roholarenykemy tahe aõkõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Moisesi bede ywina rybe‑di rãire Jesuisi lỹỹraxidỹỹmy. Iwese kai ixiluure wese, iny witxira luuke! Tii tahe Jesuisi rihixidỹỹmy rarybere: —Aõhebo arotỹỹnyke biu‑ò arahenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesuisi dirawyònyde: —Timybo kỹnyhe Moisesi bede ywina tyyriti‑ki roimyhỹre? Timybo tuu manarybekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tii tahe diwyònyde timybo tyyriti‑ki roimyhỹre myna: —Deuxu adinodureny, ibutumy awo‑ribi iluuke, ibutumy arayky‑ribi aruruna‑ribi, ayky‑ribi heka iluuke. Tule ibutumy iny ixiwesemy idi atximahãke. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tai tahe Jesuisi tamy rarybere: —Kai inatyhymy tarybeteri tai inatyhymy mahenykre biu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kia hãbu heka rexiòbitinykemy idi ratxireri. Taita rarybere Jesuisi‑ò: —Mobota waeryre? ");
INSERT INTO kpjNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tahe Jesuisi ikò relyyre ijyymy. —Judeu mahãdu hãbu heka ratỹinamyhỹ Jerusalẽ hãwã‑ribi, Ijeriò hãwã‑ò. Iribi tahe kia wasidu mahãdu rimyrenyre. Inieru ibutumy iribi ritarenyre. Ityy hỹre raòhòtere irubudỹỹle rasiranyre ririre. Tahe ruruõki rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Aõma judeu xiwenawahidỹỹduõ heka idi rare. Tahe hãbumy robire. Idi hãbu‑ribi irehemy rexiemy reare. Tahe tỹtxi rerikõle rare raty resere. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hãbuõ rehemynyre tiie‑ki dohodỹỹna wiòhedỹỹduõ rare, Levita wahe. Tule ratyresemy ririre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tahe ijõ nade Samaria bede hãwã luduõ heka rare. Judeu mahãdu heka Samaria mahãdu luukõre. Idi tahe kia judeu mahãdu roimyhỹ. Tahe Samaria mahãdu hãbu sõwemy riruxetòenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Idi tahe tamy rexitỹmynymy tahe iwotõmona rituahinymy ritaataamy iwotõmona. Idi tahe ka hãbu relyymy idi rare. Aõma ijumenta tyre‑ò ritidimy. Idi rare rirarehu tahe heto‑ò ritidikremy ririkremy ridymy heka idi rare. Rumy heka ritòenyre hykyky idi bede nade awimy risỹnykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","37","Rudile heka heto òwy‑di iwedu‑ò heka nieru riwahinyre riòwynyre inatxi womati nieru. Tamy rarybere: —Biwiòhenanyre idi mabekre adòòsekre riròkre. Moma arỹnaderenykre Arỹnadebenykre heka adiòwynykre adòòsekreu wahe. Ka hãbuhe rarybere: —Hãbu bireludu ratxireri. Kia taruxetòenyreri tiòsinyre waha tieka idi hãbubireludu ratxireri. Wimy raòludumyhỹre hãrele taheka riwiòhenanyre. Jesuisi tamy rarybereri. —Iwesele biwinykre iweseka hãbu riwinyra weselemy biwinykre. Kai aõhebo botỹỹtyhy mahake. Iwesele wahe. Jesuisi rỹỹraxire: —Mobo hãbu aõtxino biòwa rare? Mobo ibireludu wahe? Bede ywina erydu tai rirawyònyre: —Iwiòhedỹỹdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesuisi, ijõ mahãdu‑wana ròirenyre. Hãwã‑ò rirònyrenyre. Hãwyyõ rare Marta inire. Tahe ridyre tasỹ‑ò tai ratxirenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tahe Marta heka iseriòre dire. Marie inire. Marie urile ibire‑txi ronyra aõbo tarybeke roholakelemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta heka raelelemy ratxireri. Aõna aõnale rotỹỹnymyhỹle riwinymy taile rare ratximyhỹ. Tai tahe nade Jesuisi‑ò rarybere: —Jikarỹ sohojile wa watxireri waseritxòre riwawikòhenanykõhykyreri. Kai anobohe kòbitimy tai tahateri. Tamy marybeke riwawikòhenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tai tahe Jesuisi he tamy rarybereri: —Marta, Marta, aõherekibo kai taelelemy teamy atxiteri? ");
INSERT INTO kpjNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sohoji aõmydỹỹnale heka awire. Marie awityhy aõmydỹỹnana ixidee rimyre. Kia moo iribi ritaõtyhy. Riwinymyhỹ awityhyreki wahe. Tamy rarybeõtyhyõ wadee roholareri iribi ariòlòdỹỹnyke wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tiutxubo Jesuisi rexitòenymyhỹre, iny rieryõlemyhỹre. Jesuisi rexihudi, ijoi rarybera: —Biwaerynanybenykre iwese texitòenyteri wese, Joaõ tahe taijoi rierynanyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tai rierynanyre. Kai bexitòenykeki, kawese marybekre: —Waha, ani ibutumy tamywimy. Wylemy mynake iny òlòdỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Rỹsỹna txuõ txuõlemy biwahinybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Inyòraruna biixãwidinykre, iny iwitxira‑dori taòraruna ariixãwidinykre. Waatysyrenyõmy òraruna‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesuisi heka taerydỹỹna mahãdu rierynanyre ijyy‑di: —Kai arỹsỹnaõmy bonykeki, abiòwa‑ò make ruetya rexitòedỹỹmy rỹsỹnaõ huòtemy bidiwykemy: —Wy, ahina inataõ wadee bidihuòteke. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Wabiòwa rehemynyreri bedetỹi‑ribi. Aõ heka wawahisidỹỹkõnare. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tii òsana myỹ adee rarybekre: —Wadee ixitòedỹỹõmyke ruetyahakỹmy. Arỹiõtyhy waherina‑ribi rexiyrubunymy heka rãireri. Ibutumy iny heka rõrõmy rỹireri. Uladu, tule iumy rõrõmy rỹireri. Wadee ixitòedỹỹõmyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Rexitòenyhyyhyy tai hyyhyy rỹikeki tai ihãrele rỹike. Abiòwatòenamy aõkõ kỹnyhe rỹike. Texitòenyterikile rỹike. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tai heka adeereny rarybereri. Bexitòenykeki, biwyke. Biijeke aõbo teijeteri, tai tahe mahake. Ijòtòbòna bihetenyke tahe adee riraynymy tahe malòke. Tai tahe adeereny rarybera. Ibutumy rexitòenymahãke, tamy riwahinymahãke. Ibutumy iny riijemahãke, tai rahake. Iny rihetenymahãke riraynyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tai adeereny rarybere: —Ixitòedỹỹki iny aõ rimymyhỹre. Aõitxe‑ki aõtxi ijara rỹimyhỹ. Ijò‑di ròtemy ijara‑ki iny ralòmyhỹre. Ijò‑di ròtemy ijara‑ki, iny ralòmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Uladuõ tyby‑ò uturamy rexitòenykeki aõbo, hemylalaõ tyby tamy riwahinyke irỹsỹnamy? Timyki tuukõna! Kaiboho kiamy aõbo botỹỹnybenykre? Timyki tuukõna! ");
INSERT INTO kpjNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Uladuõ tyby‑ò hãniesimy rexitòenykeki aõbo, itytibòrò tamy riõkre. Timyki tuukõna! ");
INSERT INTO kpjNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kaiboho aõbina binahakỹdile tahõtinymahãtenyté, aõwihikỹ aõbohe ariòrereny‑ò biwahinyke. Boreny aratyre heka bede rieryke, Deuxu wahe. Tamy bexitòenybenykeki, tii Deuxu Tyytybytyhy adeereny riwahinyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ixityre tasỹ hãbuõ raremyhỹ irybeõmy. Jesuisi taile ratximyhỹ tahe tyytybybina riòlòdỹỹnyre iribi. Iu tyytybybina iribi rohonyreu tahe, hãbu rarybere kia rybeõmy ratximyhỹré wahe. Tahe iny sõwehekỹ mahãdu sõwemy idi rabedeòtiimy rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Inyõ tahe, inysõwehekỹ yluduõ tahe kiamy rarybere: —Kia diabo ruru‑di, Belisibu ruru‑di heka iribi riòlòdyỹnyre. Tii tyytybybina mahãdu wedu rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ijõ tamy rarybere: —Jesuisi, araeryrenykre inihe aõ biditeòsinykre wadeereny. Inatyhy aruru biuludu ratximyhỹre. Widỹỹnaõ inihe wadeereny bitỹnynyke kialemy heka rarybemyhỹre urile riurihimy tamy aõ itxerenamy riwinykelemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesuisi tahe rierymyhỹ aõmybo raraykynymyhỹreny. Tai heka tamy tuu rarybere: —Kia iny mahãdu wiribi hitximy raraykywydynykeki, tii tahe rexihuke itueke, sỹ mahãdu tule wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Timybo Satanasiboho bede widee ribinanymyhỹrenyreki, awityhymy roirekre. Jiarỹ araeryrenyreri timybo taraykynytenyteri. Aõma Satanasi ruru‑di tyytybybina ariòlòdỹỹnykemy tarybetenyteri heka reeryreri. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kia riki ariwinykeki, kaiboho tule wawesele tewinytenyte. Timybo? Mobo awiòhedỹỹdureny rare? Satanasi aõbo? Kaiboho boibenyke ixitòedỹỹmy awiohedỹỹdureny‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jiarỹ Deuxu ruru‑di ariòlòdỹỹnykeki, kaiboho bexiijebenyke, Deuxu Iòlòna tahe adeereny iòhòra. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Hãbu deburehekỹ tadebòna‑di taheto riyrubunykeki, rexityhynymy ronyke. Iaõmydỹỹna ibutumy iyrubudỹỹnamy rỹike. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tahe ijõ kedehemynyke iratyre teburetyhy, tahe iaõmydỹỹna ibutumy iribi riwyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Iny wawana aõkõ ratxirerimy ihỹre, tii heka waribi hitximy ratixmyhỹre. Iny wawana aõkõ ratxireri, tii tahe aõtxile ramyhỹre ixideòna. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesuisi ijõ ijyy relyyre: —Iny‑ribi tyytybybina ròhònymyhỹreu, tii heka rake ixitawo‑di rake titxibo. Rubumy rarunymy rake. Bedeõ‑ki rahakeki tahe, rõhõtinyke. Aròòsekre, tikibo rarawãhãòle. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ixyby kòdòòsekeu tahe, isỹ ibutumy, tytymy roike iruxeraõ. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Idi ixityre ijõ rimyke debò inatxi reurò tyytybybinaõ. Idi tahe tamy rasỹnyrenyke. Iratyre tyhy wahe ibina. Iu kia ixisohojimy tyytybybina‑di aõmysỹdỹỹmy raremyhỹu tahe, ihewo‑ribi rimyra tahe iroona‑ribi tahe aõnityhymy releke. Ibinatyhymy tamy rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iribi tahe hãwyyõ ryryre ibutu ijohonamy: —Hãwyky heka aratxurananyre, aratibienyre heka iny bedekòby rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tahe Jesuisi rarybere: —Deuxu Rybe tyhydỹỹdumy iratyre wadee awire. Deuxu deysanamy tamy kanakemy idi watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Idi tahe inysõwetyhymy dehemynyde Jesuisi‑ò. Jesuisi kiamy rarybere: —Iny heka kia mahãdu ibinatyhymy rỹire aõwihikỹle heka riijemy rỹire. Itxerenaõmy robikre ratxireri tahe itxerena Jonasi‑ribi nadelemy tahe robikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonasi heka Ninive hãwã mahãdu‑ò itxerenaõ heka tii rare. Tule jiarỹ heka Deuxu Riòre Hãbutyhyhykỹ rare wijinabòdu mahãdu dee itxerenaõ jiarỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ibòò mahãdu bede konana‑ribi iòlò hãwyy Salomaõ bede eryhykỹ‑ò ijõhonamy irehe‑ribi nade. Wijinabòdu mahãdu taheka naõhyymahãde wadee ijohonamy. Salomaõ ratyre heka jiarỹ watxireri. Ikonana txu tahe ibòò iòlòhãwyy rỹikre rarybekremy. Tii rarybekre: —Anoherekibo Jesuisi deramy teakamahãtenyte wahe. Timykibohe irybe bedekeryna‑kò ijohokuna rỹikõmyhỹreki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninive hãwã mahãdu tule rỹikre rarybekremy iwesele. Jonasi rybe tỹnydỹỹna‑ki rexirãhĩrenyre. Kaki heka Jonasi ratyre hãbuõ ratximyhỹre, jiarỹ wahe. Wadee ijohonadu aõkõ heka toite. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Moheka loosònaõ rideõhyymyhỹre herinarawo‑txi toosò iwasihikỹmy roosòmyhỹkemy. Tiiemy heka biuòhyy rademyhỹre ibutumy bede ratỹnymyhỹkemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Arue umy dori itỹnymy roimyhỹre. Arue awikeki heka ibutumy aumy awikre. Arue ibinakeki tasỹ aumy heka bedelorokile rỹimyhỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Awo toosòmy ratximyhỹre wana, bexiijemahãke. Aumy biemahãke bedeloro‑ki rurunyheny. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bedelorohokỹ aumy‑ki rỹiõmyhỹre wana, tai tahe boosokre ibutumy titxibo bede‑txi mamahãkre wana. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesuisi kiamy rarybereu tahe, fariseu mahãduõ tamy rarybere: —Manake wasỹ‑ki rikiroxikremy. Tai tahe Jesuisi rare, ralore, ronyre roximy. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","39","Jesuisi ronyreu, tebò risuhòõre. Tai tahe idi bede riòtiinyre. Jesuisi rarybere: —Kaiboho fariseu mahãdu, ibutumy heka texisuhòsuhòmahãtenyte. Ebò tesuhòmahãte, aumy ibutumy tesuhòmahãtenyte. Webòròsityyludu wahe. Kaiboho heka isuhukỹlemy toimyhỹte ibutu aõikõkõ‑di isumy roimyhỹre aworeny‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Iu heka òbitimy taraykynytenyõhyymahãtenyte. Deuxu heka iwebrò ludu riwinyre, inatyhy? Tule aworeny, araykyreny wana riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Iny aõkõ mahãdu‑ò maruxetòemyhỹbenyke. Tai tahe byranybenykre heka. Ibutumy awo‑ki, ahana‑ribi tule ryranykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kobe làhàxe kaiboho fariseu mahãdu. Kaiboho Deuxu dee tewahinymahãtenyke uriõno. Debòwiò aõ tetatenywana heka, sohoji tewahinymahãtenyte. Tule aõmydỹỹnareny aoworuroludurenyõ tewyteny wana, tule tewahinymahãtenyte. Kia awire, biwahinymahãbenyke. Urile tahe teerytenyõhyymahãtenyte Deuxu luuna, Deuxu òbitina. Biwahinymahãbenyke heka Deuxu dee aõmydỹỹnaõ. Tii tahe awire. Tule nohõti losarenyõmyke, luuna, òbitina. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kobe làhàxe kaiboho fariseu mahãdu. Dohodỹỹna heto luureny ikoòhòkỹle heka torokomahãtenyte. Kaiboho arybedỹỹnareny‑ki awimy tahamyhỹtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kaiboho kobe làhàxe. Wobrona wesemy toite. Iwese iny rubuhãloo tyremy iny rariamyhỹre wese ierykõnamy, kiawesele toite. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Bede ywina bede erydỹỹduõ heka tai ratximyhỹ. Tii tahe Jesuisi‑ò rarybere: —Erydỹỹdu, kai heka aõbinahakỹlemy wamyreny tarybeteri, kia wese rybe‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Inatyhy rare. My tahe Jesuisi risỹnyre: —Inatyhy dori tule bironybenyke aõhõkỹmydỹỹnana. Iny dori adeereny rarybemyhỹre iny rybe bityhynymyhỹbenykemy tahe ihãrele tetyhynyõhyymahãtenyte. Bede ywina ritidỹỹna tewinymahãtenyte, ihãrele tahe tiu heka tetyhynyõhyymahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kobe làhàxe kaiboho, alahireny, alabiereny wese toite. Iwese tiiboho Deuxu rybedu rirubunyre wese kaiboho toite. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kaiboho rubudỹỹdumy toite. Òbitile tewinymahãtenytelemy ixidee tahõtinymahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Deuxu tahe rarybere umyrenymy wahe: —Tahe jiarỹ aditeònykre heka Deuxu rybedỹỹduõ tule Deuxu deòdỹỹnaõ heka aditeònykre. Imahãduõ birubunybenykre ihona tahe biteònybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kaiboho heka bede òrarumy boibekre kia rubudỹỹ òraru erydumy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abeli hãlubu txiwina tahe xiwena hure rubuna. Idi tule Zacaria hãlubu txiwina wahidỹỹna bire‑ki heka Deuxu hetobire‑ki. Kohe, ihure rubureny òraru‑ki aõhõkỹhỹkỹmy biòwynybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kobe làhàxe, kaiboho bede ywina erydỹỹdu mahãdu, bedeeryna ijò rayna dinoduboho wahe. Kaiboho tahe terònyõmy bede eryny heto‑ò. Tule inywitxiraõ tetòenytenyte iròte lau. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesuisi ròhònyreu, teburemy tiiboho ritỹỹraxinymyhỹre aõna aõnamy. ");
INSERT INTO kpjNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tuu ròtỹỹraxidỹỹmyhỹre timykibo rirutaõnyrenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sõwemy iny tahe ributunyre. Ube tahe rỹximy ratxireri. Tahe juhuu Jesuisi taerydỹỹdu mahãdu‑ò rarybere: —Fariseu mahãdu, saduceu mahãdu urina biebenyke. Tiiboho dori ruidu mahãdu roire. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wasimy wiji adeereny relyyre. Tiu ta ibutumy ijyynamy rỹikre ");
INSERT INTO kpjNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Aõbo wasimy wiji taholate heka ibutumy biurasòmy ratỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Uritere iny lau brebuõmyke. Aumyle tii rirubunykre. Ijõ ibinamy adee aõkõ tii rotỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Iny lau sohojile breburenyõmykre. Deuxu lau ta buberukre. Tii dori atyytyby bede bina‑ò rahuke ixideewikeki. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nawiiõ kaiboho bidymyhỹbenyke iòwy riòre iny heka riwymyhỹrekre. Ibutumy heka Deuxu nawii rieryre sohoji sohojimy. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Deuxu ara erymy heka aõma arati‑ki tiwesebo aradeti rỹimyhỹre rierymyhỹre. Brebuõmyke, aõma Deuxu heka anaerymyhỹre nawii sõmo ratyre heka rierymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kai marybeke: —Jiarỹ Deuxu retyhynyre dori tahe umy arelyyke Deuxu ỹjukomy rarybeke biu‑ki wahe, jiarỹ Deuxu Riòre Hãbutyhyhykỹ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Iny sõwehekỹy‑ki riwatxiõnykeki tule aritxiõnykre jiarỹ Deuxu ỹjuko‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Inyõ Deuxu Riòremy aõbina binamy rarybekeki, irybe‑ribi nohõtilosa rỹikre. Deuxu Tyytybytyhymy tahe inyõ ibinabinamy rarybekreki tahe, aõhõkỹmy rotỹỹnykre irybe òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Aramykeu heka uritere nohõtiõmyke aõmobo marybekremy ywisidỹỹna‑ki. Bede heka ariwahinykre rybedỹỹnanau. Rybeõmyke ikotyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kai ixiwanale aõkõre marybeke. Deuxu Tyytybytyhy arãwiòhenanymyhỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hãbuõ inysõwey‑ki tahe Jesuisi‑ò rarybere: —Wanyrỹ, Waha rurura. Waseriòre tahe ibutumy waha aõna aõna riwyra ixidee sohojile. Tamy marybeke wadee ritxuranykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesuisi tamy rarybere: —Hãbu, kia waaõmydỹỹna aõkõ rare. Timybo ayreny‑ki araywisidỹỹnyke? ");
INSERT INTO kpjNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tahe Jesuisi ibutumy iny‑ò rarybere: —Warybe‑ò bodoholabedenyke. Ixityhyõmy! Arutyhy heka aaõna aõna‑ki aõkõ rare aõna aõna sõwerehãre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tahe Jesuisi ijyymy ròkewesenadỹỹre: —Hãbutyhy riki ioworu nihikỹre. Tahe sõwemy rỹsỹna ributunyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","18","Iheto tahe iyjare ibutumy ributunykemy. Tahe ixidee rarybere: —Aõhebo arotỹỹnykre? Waaõnaheto butumy aritxiwikre. Ijõ iribi inihikỹmy ariwinykre. Tai ibutumy waaõwiwi. tamy aridekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tai tahe ibutumy waõwiwi‑di areysakre. Arexielehynykre, ariroxikre, ariõkre. Waruhyy areysakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Deuxu tahe kia hãbu‑ò rarybekre: —Hãbu itxỹtere. Kai wijirulemy burukre. Tai tahe mobo aõna rimykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesuisi taijyy rihure rexirybenymy. Kia heka aõhebo rotỹỹnyre iny ityhy mahãdu. Tiiboho dori Deuxuòle ityhymy aõkõ ihỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kia heka Jesuisi taerydỹỹna mahãdu‑ò rarybereri. Uritere nohõtiõlemy arỹsỹna tule atyymy, idi matykynykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Aumy heka rỹsỹna ratyre aõnityhy ratximyhỹre. Aumy heka atyky ratyre aõnimy ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nawii‑di betehebenyke. Tiiboho heka ioworuõrenyre. Tarỹsỹna riyrubunyõhyymyhỹrenyre. Deuxu heka nawii riyrubunymyhỹre, irỹsỹna tamy riwahinymyhỹre. Kaiboho tahe nawii ratyretyhy toite Deuxu dee. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sõwetyhymy maraykywydynanykeki aõbo arumy arirarehemy mariake? Aõkõre! ");
INSERT INTO kpjNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kia aõ iyjare tahe Deuxu‑ò. Kia biwinybenyõkeki, aõherekibo ijõ aõna aõna nihikỹ‑di tahõtinymyhỹte? ");
INSERT INTO kpjNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Betehemy inihe noijasa‑di. Aõma tiiboho raaõmysỹdỹỹõhyymyhỹrenyre. Ihãre tahe iruxerarenyre ityy wiwihikỹrenyre wese. Tyy ixidee riwinyõtyhy Deuxu rityyny wihikỹ heka tyy wihikỹ tamy riwahinyreri. Salomaõ heka ityynihikỹ rare. Ihãre tahe ityy heka awityhymy aõkõ noiròsò wese. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Deuxu heka noijasa rityynymyhỹre kia wijilemy idi ihỹre. Biurasòmy tahe ixãwimy reamyhỹre. Tii heka tyy adee kidiwahinykre. Tai tii atyyreny. Tai ta ixinohõtiyredỹỹrenyõmy. Aõherekibo ainatyhyna ibutere? ");
INSERT INTO kpjNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tahe raykyõmy nohõtiõmy titxiribibo arỹsỹna adee kanakredi. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tyhydỹỹdukõdu mahãdu heka tuure. Inytybyreny heka rierymyhỹre aõmybo tarumahãte. Ibutumy heka arerymyhỹre aõmybo teamyhỹte. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tii Deuxu aõmy dỹỹnana sohojidile maraykynykeki heka tii ibutumy adee riwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Brebuõmy ahãbenyke wariòreboho. Deuxu Iòlòna adee kanakemy, Deuxudeewina wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Aaõna aõna‑di bohonybenyke. Iòwy tahe iaõkõdu mahãdu‑ò biwahinyke. Anieruhyna wiwihikỹdile boibeke. Kaki ibutudỹỹlemy heka biu‑ò bibutunyke. Tai heka judòera aõ riròõtyhy tule rararyõtyhy. Tule tai wasidu ralòõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tikibo aõwireny rỹikeki, tai heka araykyreny ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ijõ tahe Jesuisi rarybere: —Kaiboho bexiywinybenyke, ibutumy aõhebo rotỹỹnykremy bexiywinyke. Awereysanareny‑di atyky beximyke. Aloosòna bitoonyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Deòdu mahãdu wesemy boibenyke. Bexiywinybenyke awedu dehemynyna‑ò, tii worana bedehesi‑ribi rehemynyremy wahe. Iu rehemynyreu, teòdu mahãdu heka ijò riraynyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tiiboho riraòrenykeki, deysamy rỹikre. Iwedu dori reximykre ityky wereysana‑di tahe rỹsỹna teòdu mahãdu‑ò riwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tii ruwetyakile rehemynykeki, deòdu mahãdu reysakre. Tiiboho dori rexiraòmy rỹimyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tai heka iny rexiywinymy rỹimyhỹkemy rybe roimyhỹre awedureny kanakreki. Aõma hãbuõ kanakeki heka tiu aõma hãbuõ itxeredumy ronykeki heka, tiu hãbuõ iribi rawasinyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kaiboho tule bexiywinybenyke wadehemynyna txu heka biijemy bonymyhỹbenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tahe Pedro rarybere: —Wanyrỹ, kai wadeerenyle ijyymy telyyte ada ibutumy iny‑ò aõbo telyyte? ");
INSERT INTO kpjNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Tahe Jesuisi riwyònyre: —Aõtxile inyõdee, tibo deòdu taaõmysỹdỹỹna riywinymyhỹre, kia idinodu tai awimy rahamyhỹre tii dori rỹsỹna òbitimy riõriõmyhỹre. Idi tamy aõwiwi riwahinykre taaõna aõna‑di itxeredumy tule risỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tii iwitxiramy rexiraykynykeki tahe, ijõ teòdumy raòhòtemy urile idi risinymy kamy rexirybenymy: —Wawedu dori wiji aõkõ rarerikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tai ierykõna‑di iwedu kedehemynykre. Tuu rierymy iaõmysỹdỹỹna‑ribi ritamy aõhõkỹmy risỹnykre ityhydỹỹdukõdu mahãdu wese. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Deòdu tawedudeewi rierymyhỹre. Tai heka tuu rotỹỹnyõkeki, tii tahe sõwemy aõhõkỹmy rotỹỹnykre, òhòtemy wahe, tamy riywinyõreki. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ijõ deòdu tahe tii iwedudeewimy rieryõkeki, tii tahe aõbinamy riwinykeki, tamy tahe urihimyò òhòte tai rỹikre. Inyõ sõwemy ityhykeki, sõwemy ijõ iny tamy rexitòenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesuisi ijõ rarybere: —Heòty‑di bede ariworonykemy heka jiarỹ anade. Tii òte raworonykremy idi watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Jiarỹ ratisebenaõwesemy aralokre. Arurukre dori. Ele elemy rỹikemy ixi‑di watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kaiboho tahõtinyte wadehemynyna‑di. Ywina adiwydemy wadi tahõtinyte. Aõkõrehe, bede jei jeidỹỹmy anade iribi widee rahitxihitximy rỹikremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Iruyre inysỹ mahãdu heka widee rahitxihitximy rỹikre. Inataõ iny iuhe òludumy rỹikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Hãbu mahãdu heka tyby òludumy rarekre. Hãwyy tule tadi òludumy rarekre. Iriokorese heka tariòrelahi òludumy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ijõmy Jesuisi rarybere: —Iu biuwetyky biura‑ribi ròhònyreu, Kaiboho kia rybemy tarybemahãtenyte biu kòdòakre. Inatyhymy biu ròamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tule tarybemahãte. Yhy ibòò‑ribi rebonyreu, bede ratòteekre. Inatyhymy tuu ratòteemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Itxenadỹỹdu mahãdu! Kaiboho kia terymahãtenyte bede, biu aõmydỹỹna tule iwitxira aõmydỹỹnana teerytenykõlemahãtenyte, bededỹỹnana konana eryna wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ijõ Jesuisi rarybere: —Kaibohole teywinyõmyhỹtenyte, aõòbitinamy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aõòrarumy heka aòludu umy rarybekeki, idi ywisidỹỹna ube‑ò aradykemy ratxireri, tii‑wana widee marybeke idi widi bede biòbitinykemy. Aõkõkeki, tii aradykre ywisidỹỹdu‑ò idi ròtenawo‑ò soldado mahãdu araròtenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tiu heka aòlòkõmy heka mabekre. Ibutumy iòwy biòwynyke xiery bòhònyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tahe inyõ Jesuisi‑ò relyyre: —Pilato rybemynamy Kalileia mahãdu rururenyre Deuxu‑ò raxiwerenyreriò. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kia ta Jesuisi narybede: —Kaiboho timybo irubureny‑di texinohõtinytenyteri. Ijõ wiratyre raòrarunanyrenyreki aõbo? ");
INSERT INTO kpjNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ture aõkõ, kaiboho bexirãhĩõbenykeki tule burubenykre irubureny wese. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Iasỹse ijõ. Iu Silòe hãwã mahãdu tyre heka heto rarie resereu 18 iny sõwe rirubunyrenyre. Arãỹỹraxikre Jerusalẽ hãwã mahãdu ratyre raòrarunanyrenyreki aõbo? Aõbo tahõtinytenyteri? ");
INSERT INTO kpjNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kaiboho bexirãhĩõbenykeki tule burubenykre irubureny wese. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tahe Jesuisi kaa ijyy‑wana rikewesenanyre, Figoratyò wese heka. Tahe Jesuisi kaa ijyymy delyyde: —Hãbu oworu‑ki figoòõ rỹimyhỹre. Tii iraty dilawijunyde tiubo. Tahe iraty‑txi reakõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tahe hãbu taoworu‑di itxeredu‑ò narybede: —Inataõ wyramy relawijunyre tahe aõkõhyyra. Urile ta biòròkre. Iraty ihoõreki, awi aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tahe oworu‑di itxeredu dirawyònyde: —Wawedu, txioini kawyramy idi warukikre, isu ariywinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aõkõhyykreki tahe urile raorokre ijõ wyrau. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Judeu mahãdu elehyna txuu Jesuisi rotohodỹỹmyhỹ judeu mahãdu dohodỹỹna heto‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tai ta hãwyyõ ratximyhỹ. Tii 18 beòra webinadumy ratximyhỹ tyytybybina òraru‑ki. Tii iumy rarabunymy rariamyhỹre. Ixitaradỹỹ risiranymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesuisi tuu robireu, tamy narybede: —Hãwyy, kai heka teytemy tate. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tahe Jesuisi tebòmy rimyre iuleta reytere. Tai tahe hãwyy heka Deuxu riwowydynyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Dohodỹỹna heto wedu tahe ibinamy Jesuisi‑ki rahare, judeu mahãdu elehynatxureki wahe. Takamy inyreny‑ò narybede: —Debò sohoji reurò txumy aõmysỹdỹỹnamy rỹimyhỹre iu heka adeytemy ixi‑di bòdòimyhỹke, judeu mahãdu elehynatxu ta aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tahe Jesuisi dirawyònyde: —Kai, itxenadỹỹdu tate uriteremy iximy rybedu. Kaiboho judeu mahãdu elehynatxu dori abroreni, aawaru heto‑ò toimahãte tuu teesenymahãtenyte, tedymahãtemy idi ibemomodỹỹmy bidybenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kaa heka Abraõ riore riòreõ heka Satanasi 18 beòramy rimyre. Aõherekibo ta iribi retaraki sabadotxu ibinamy tahateri. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tahe Jesuisi òludu mahãdu raixỹrurenyre Jesuisi rybe òraru‑ki. Tahe ixỹ mahãdu awityhymy tai rahamyhỹ iòraru‑ki. Ibutumy reysarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Tii rarybera: —Deuxu Iòlòna wexe aõwesere. Aõ‑ò wexe rikiwesenanyrenykre. Tiwexe ijyy kawesere? Deuxu Iòlòna heka alòbòròna sõmo sõmo wesemy ratximyhỹre. Raumynyreu heka òwòru rariewesele relemyhỹre. Nawiile tuu rỹtỹnymyhỹre kia òwòru‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ixityre tamy rarybere: —Aõ ijyy wese heka Deuxu Iòlòna rare. Aõwexe rikiwesenanyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Paõ ixiòlòdỹỹna wese rare, iuri rare. Hãwyy paõ riwinymyhỹreu, inataõ urihixina‑ki iuribemy riurinymyhỹre. Tai tahe raubỹtỹmyhỹre, rexiòlònymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesuisi tahe Jerusalẽ hãwã‑ò rareu, hãwã hãwãmy rotohodỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iu inyõ ritỹỹraxinyre: —Wanyrỹ, Hedu mahãdu we sõwekre aõbo? ");
INSERT INTO kpjNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jesuisi tamyreny narybede: —Bexityhynybenyke ijòyja‑di birònybenykemy. Sõwemy iny tahe ròtemy reakre tahe ralòõhyykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Hãbuõ kie taheto ijòtòbòna ritòbònyre. Iu kaiboho uritere bydyrydenykre: —Wanyrỹ, aralòrenyke ini. Kiata tii anawyònydenykre: —Tiludubo toite, araeryrenyõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kamy ta bidiwyònydenykre: —Inybohole riroximy roiremyhỹ. Wahãwãreny‑ki tòbedeerydỹỹmyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ixityre anawyònydenykre: —Boibenyke aõbina bina widỹỹdu. Tiludubo toite dori reerykõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Deuxu iòlò‑ki Abraõmy, Ijaimy, Ijaòmy, tule ibutumy Deuxumy rybedu mahãdumy bobibenykreu, kaiboho malòbenyõtyhy. Tai hii, ibru, jumytata rỹikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iny ibutu bede bede‑ribi, Ibòò‑ribi, Iraru‑ribi, Biura‑ribi, Beà‑ribi Deuxu iòlò‑ò hãwãmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kiaremy ta, koludu mahãdu heka ibutuhewomy kedeakre. Ikõmyta, hewoludu mahãdu, koludumy kedeakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iu ta fariseu mahãdu Jesuisi‑ò narybedenyde: —Mahenyke, Herodi dori arubudỹỹmy araijereri. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesuisi dirawyònyde: —Bòòsebenyke kamy ijòrò‑ò marybebenykre: —Jiarỹ tyytybybina iny‑ribi retareri, tule ròteytedỹỹreri wiji biurasòmy. Ijõ txumy ta waaõmysỹdỹỹna arihukre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kiaremy ta kia rewinyreri arihukre. Deuxumy rybedu dori Jerusalẽ hãwã‑ki sohojile rurukre, iwitxira hãwã‑ki ta aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalẽ, Jerusalẽ hãwã, amahãdu heka rirubunyrenyre Deuxu rybedu mahãdu wahe. Iwese hãnie tariòre ributunymyhỹre wese terawo‑ò, kia wesele arayrubunykemy rexinohõtinyre tahe kaiboho terarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aheto‑ribi heka Deuxu rexitakre. Kaheka ararybekre adeereny: —Wamy heka bobiõtyhy ixityre. Tiutxumy kamy bexirybenykre bede‑ò, myỹ: —Deuxunimy nodu awityhy heka rare. Kiaule wamy bobikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabadoõu Jesuisi heka fariseu mahãdu wedu mahãduõ heto‑ò ralore roximy. Tahe iny idi retehemyhỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iu inyõ taruti, tadera‑di taritari‑di tamy dehemynyde. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tahe Jesuisi narybede bede ywina erydỹỹdu‑ò, fariseu mahãdu‑ò: —Sabado txuu deytedỹỹwe awire aõbo, aõkõre aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tiiboho rirawyònyõhyyre. Tahe Jesuisi hãbu riteytenymy bede riywinyre iribi tahe riòlòdỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ixyby narybede Jesuisi: —Txibo kaiboho ariòreõ ada abroreniõ hãloo‑txi resekeki, bitabenyke Sabadotxu hãrele. Aõhe inatyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tiiboho rirawyonyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tahe Jesuisi roxidu mahãdu‑di retehemyhỹre. Tiiboho dori rynana wihikỹ‑txi ronymyhỹreny. Tai kamy tamyreny rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Txibo inyõ bedesanaõ araarikeki. Uritere rynanawi‑ò rỹõmykre. Txibo dori inyõ aratyre ityhy kanake lau. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tukeki bedesa dinodu inyõ aratyre‑ò arynana‑txi ronykemy adee kanarybekre. Tai tahe maixỹrumy rynana bina‑ò bonykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kialemyta inyõ araarikeki, rynana bina‑txi bonykre. Tahe bedesa dinodu adee kanarybekre: —Wy, katxi bodonyke rynanawihikỹ‑ò. Tai tahe kai mabedesakre ibutuko‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tahe ixityhydỹỹdu mahãdu uritere reakre. Kõmyta uriixi dinodu mahãdu rawowydykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tahe Jesuisi bedesa dinodu‑ò rarybere: —Txibo roxina biwahinykeki, uritere asỹ mahãdu, aery mahãdu, ityhy mahãdu aarixiõmykre. Urikõ‑ribi iwese teariteri wese araariheny. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tukõmyta roxi biwahinykeki, uriteremy rỹira mahãdu, iny tiere mahãdu, iny ruetà mahãdu biarikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tai adeysatyhymy mabekre. Tiiboho dori tiu ixiwesemy araariõtyhy. Deuxu tahe aòwydỹỹdukre iu bede awikreu. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ijõ roholare Jesuisi rybe tai tamy rarybere: —Deuxu Iòlòna‑ki, òwòrubese rỹdu mahãdu reysamy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tahe Jesuisi rarybere: —Inyõ roxina nihikỹõ riwinykemy ratxireri. Sõwemy iny ritobinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Rexihumy rỹireu, teòdu mahãdu bede riywinyre iny kididykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sohoji sohoji tahe tarybe tamy riwahinyre. Ijõ taoworu tỹmyra‑ò reteheke. Ijõ kanaõtyhy heka. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ijõ tahe broreni debòitue riõbranyre tai riurihikreki kanaõke. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ijõ tahe hãwyy herinamy rexihumy rỹire tai kanaõke. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Teòdu tahe ròòsera tawedu‑ò tamy relyyre. Tii reburere tahe rarybere: —Wylemy makre ibutury‑di hãwã‑ki. Ibutumy iny witxira witxira bididyke, iaõkõ mahãdu, itiere mahãdu, ruetà mahãdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Iribi tahe teòdu ròòsera rarybere: —Ibutumy rewinyre wawedu, tahe heto rỹxiõmy rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tahe iwedu ixybymy bede riywinyre hãwã‑ribi ibryrary‑ò iny kididykemy: —Aruru‑di bididyke, waheto dori rỹximy rỹirakremy idi watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Juhuu watobidỹỹna mahãdu warỹsỹna riurihiõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Iu sõwemy iny Jesuisi heludumy roire. Tai Jesuisi tamyreny rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Kaiboho aõbo inatyhymy waluu mahãdumy toite. Tuu tarybeta. Tahe boluu, adiluu, ahãwyyluu, ariòreluu, aseriòreluu, ixiluu ratyre waluuõkeki, wamahãdumy aõkõ boibeke. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Inyõ riwaheludunykemy ratxireri, tii juhuu taitxeò riwykre. Kialemy tahe riwaheludunyke inatyhymy. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Inyõ heto rarie riwinykemy ratxikeki, juhuu iòwy‑di rõhõtinykre. Inieru rimykeki tahe riwinyke, aõkõkeki tahe riwinyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tii tuu rõhõtinyõkeki, tii ibutelemy riwinykre tahe inieru ituereu, ibutumy iny idi risinykre: ");
INSERT INTO kpjNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","—Tii taheto rarei ritelenyre tahe rexihuõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Iòlòõ wou riwinykeki, juhuu taaõbinadu mahãdu‑di rariamyhỹre. Idi rõhõtinyre. Ijõ iòlò wawiò mil soldadomy ijõdikeki, tahe tii debòwiò mil ijõdikeki, tahe wou riwinyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Juhuu tahe teòdu riteònyre ijõ iòlò‑ò ireheribile tii‑wana wou ixãwidỹỹmy rarybekemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Akireny tule iweselere. Ibutumy aaõna aõna biriõbenykeki, waheludu mahãduõmy boibeõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Saa heka aõni awi rare. Tatxuberere rexihukeki tahe turibi ixãwike. ");
INSERT INTO kpjNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tai tahe suurina‑ki ahirana silỹna binakõki awiõhõtidirenykeki boholabenyke warybe‑ò. Suò awiõre, tule ahirana bitòbònykemy awiõre. Urile idi behuke. Kaiboho õhõtidirenykeki, boholabenyke! ");
INSERT INTO kpjNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Idi nieru tarasadu mahãdu sõwemy tamy roholamy doide. Tule ijõ iny òrarudu mahãdu rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseu mahãdu, tule bede ywina erydu mahãdu kawesemy rarybere: —Kahãbu ibinare. Tii òrarudu mahãdu‑wana riroximyhỹre, iny iehehe‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Idi Jesuisi rierynanyre ijyy‑di rawesenanyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Kaibohoõ òsana 100 budoeni ijõdire. Sohoji heka iy‑ribi iõre. Kai aõbo makre ijesemy? Kohe, iuhe, 99, birike bedero‑ki tahe biòryhyyke. Aõhe inatyhy? ");
INSERT INTO kpjNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mahakre wana tahe eysamy atxikre. Tahe bidyke iuhe‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Taheto‑ò rehemynyreu, tasỹ mahãdu‑ò tahe ritobinyre: —Wawana ini kỹny bedeysabedenyke. Wabudoeni‑ki rahara, iõreõ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iwesetyhylemy taheka adee reerymahãre iny òrarudu mahãdumy. Iu sohoji iny rexirahĩkeki, biu‑ki deysana sõwemy rỹikre. Iny òbiti 99my tahe urihimyò biu‑ki deysana rỹikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ijõ Jesuisi relyyre: —Hãwyyõ òsỹny womati ura nieru debòwiò dire. Sohoji iõre‑wana, tii riijeke inatyhy? Loosòna ritoonyre, iube riwysynyre, sõwemy riijeke ihyymy tahe tai rahara. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tii itxi reakreu, reysamy rỹira. Iu tasỹ mahãdu ritobinyre: —Wawana inihe bedeysabedenykre. Wanieru‑txi dokuri rahara. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jesuisi tahe ritỹnynyre: —Iwesetyhyle biu‑ki rare. Deuxu ỹju mahãdu reysamy roirenyre, sohoji òrarudu rexirahĩreu. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ixyby tahe Jesuisi narybede: —Hãbuõ iriòre inatxire. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tiutxumyta ihelỹỹna tyby‑ò rarybere: —Waha, ibutumy aõna aõna burukreu wadee rawahikre, wijile bidiwahinykre. Tyby tahe iaõna aõna jura tamy riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Iriòre helỹỹna tahe ibutumy taaõna aõna‑di rare irehe‑ò, iwitxira bedehãwã‑ò. Tai aõbina binale riwinymyhỹre. Ibutumy tanieru tai rahure. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Taaõwiwi rahu‑di ta, tai rama ibede mahãdu rahumyhỹre. Tii uritere reamyhỹ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tahe aõmysỹdỹỹnamy rarunyre. Hãwãduõ tahe taixỹniòwedỹỹdumy bede riywinyre taoworu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tai rama risamy ta ixỹni rỹsỹna rỹsỹmy rexinohõtinyre. Tahe aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kia tahe tõhõti deade. Kamy dexinohõtinyde: —Yla aõkõ waha aõmysỹdỹỹdu mahãdu irỹsỹnadireri iwana jiarỹ kaki rama warubudỹỹmyreri. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ixyby aròòsekre. Kamy Waha‑ò arexirybenymy: —Waha, Deuxuko‑ò ako‑ò rexiitxỹtenyre jiarỹ raòrarunyre wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ariòre wese aõkõmy wadi mabeke, waitxỹte òraru‑ki. Aaõmysỹdỹỹdu mahãdu wese ta ararekre myỹ tii rõhõtiny. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tii tahe tyby heto‑ò rare. Irehemy nadeò, tyby tuu dobide. Idi rexiwobrunymy tamy raijaranyre iwehityhydỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tahe tii narybede: —Waha, Deuxuko‑ò, ako‑ò rexiitxỹtenyre jiarỹ, raòrarunyre wahe. Ariòre wese aõkõmy wadi mabeke, waitxỹte òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Iule ta tyby teòdu mahãdu‑ò rarybere: —Wylemy tyywihikỹ tymyra‑di bityynybenyke. Debòõ tebò‑ò roikre. Waõ‑di rawanykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tasỹse broreni riòre dedi birubunybenyke. Idi rikiroxirenykemy rekeysarenykre dori. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wariòre dori rubu‑ribi wese rexixara. Ikõ‑ribi itxi ijara rỹira. Tahe rawobedesarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Iwana ta iumydela tahetoreny‑ò dehemynymy nade taaõmysỹdỹỹna‑ribi. Tahe wobedesana‑ò roholamy. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tahe deòduõ‑ò narybede: —Aõhereriwe. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Dirawyònyde: —Ahelỹỹna kie ròòsereri aõhe rotỹỹnyõhyylemy. Tai boo broreni rirubunyra. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Iumydela tai reburere ròte deramy reare. Idi tyby tamy nade riròtenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tahe iriòre dirawyònyde: —Aõhe òhòkõ adee raaõmysỹdỹỹnymyhỹre. Ibutumy arybe retyhynymy watximahãre. Ihãreta budoeni wadee tewahinyõhyymyhỹte, waijoi mahãdu‑wana idi arexideysanykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Katahe ariòre urile aõnawiwi rahura wedena mahãdu‑wana. Ròòsemyta kai broreni riòrede tamy terubunyta. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tai tyby dirawyònyde: —Wariòre iny ratximyhỹre kiaremyta ibutumy waaõwiwi heka ahõrõle rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Iny bedesarenymy heka kawese rewinyre, wadee awireki. Ahelỹỹna dori ruruwese‑ribi rexixara. Ikõ‑ribi itxi ijara rỹira. Tahe rawobedesarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesuisi taerydỹỹna mahãdu‑ò relyyre ijyyõ: —Hãbuõ inieru sõwere. Tamy deòduõ ibutumy inieru‑di raaõmysỹdỹỹre ijõ nieru ributunykemy. Ijõtxu tahe inyõ rarybere: —Eòdu riki heka anieru‑di òbitimy aõkõ raaõmysỹdỹỹmyhỹre. Anieru sõwemy rexihumyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tahe didyde ixidee taconta retehekemy. Tamy rarybere: —Inatyhymy aõbo umy iny rarybemyhỹre? Wanierumy tyyriti aretehekemy watxireri. Òbitimy aõkõkeki, waribi arateònyke. Wanieru‑di tiu maaõmysỹdỹỹnyõkre. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tahe teòdu iximy rexiraykynyre: —Wadinodu riwateònyke. Aõhebo arotỹỹnyke? Warurukõre dori tahe aõmysỹdỹỹsira ariwinyõtyhy. Tule ijõ iny‑ribi iixitòedỹỹna riwaixỹrure. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Reeryre tahe, aõhebo arotỹỹnykremy. Aõwiwihikỹ wabiòwa dee ariwinykre. Riwateònykeki tahe wabiòwasỹ‑ò arakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ibutumy nieru huòtedu mahãdu‑wana rarybere, tawedu‑ribi huòtedu wahe. Tamyreny rarybere: —Tiwesebo tewyta wawedu‑ribi? ");
INSERT INTO kpjNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tahe diwyònyde: —Adỹỹ rehuòtera, 100 hynamy wahe. Tai tahe rarybere ijõ: —Iwekre tahe wylemy biritinyke, 50 wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ijõ‑ò tahe rarybere: —Tiwesebo adeve? Diwyònyde: —Trigo rehuòtera, 1000 prato wahe. Tai tamy rarybere: —Kai 800my biritinyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Iribi tahe hãbu ityhy heka teòdumy rarybere: —Tii inatyhy nieru erydu ratxireri. Tahe Jesuisi rarybere: —Kabede wijinabòdu mahãdu heka aõmydỹỹnana erydutyhy rare, ityhydỹỹdu mahãdu ratyre wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Tai tahe adee ararybekre. Kabede mahãdu biòwamy boibeke, anieru‑di. Tahe anieru ituekeki, Deuxu taheto wiwihikỹ‑ò aradykre, biu‑ò heto wiwihikỹ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aõmydỹỹnana aõ aõkõmy kai òbitimy masỹnykeki, tule aõ nihikỹmy kai iweselemy mabeke. Inyõ heka ibutemy wasikeki, tii tule aõ nihikỹmy rawasinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kaiboho heka kabede nieru‑di òbitimy aõkõ atxibenykeki, tule biu‑ki araròsòna bitaõtyhy, aõ wiwihikỹ inatyhy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Iny witxira nieru‑di heka òbitimy boibebenyõkeki, timybo anieru tyhy‑di òbitimy boibeke. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Inyõ iny inatxi deòdumy aõkõ rarekre. Inatxinaõ dori iluukre, ijõ ta iluukõkre. Deuxu dee maaõmysỹdỹỹõtyhy. Tiu nierurahi inatyhymy teamyhỹteki. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseu mahãdu tamy roholareu, urile idi nierurahi risinyrenyre, tiiboho ire nieru ributunymyhỹrenyre bòdỹỹluurenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tahe Jesuisi tamyreny rarybere: —Kaiboho heka òbitimy inyko‑ò ixi‑di atximahãtenyte. Ihãre tahe Deuxu timybo toimahãte rierymyhỹre aõna aõnareny bina. Aõmy hãbu rexinohõtinymyhỹre, aõtxi‑ki Deuxu‑ò awiõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moisesi bede ywina rybe tahe tule Deuxu Rybedu mahãdu awi rare, Joaõ Sebedỹỹdu rehemynyreu tahe ixãwire. Iu tahe Deuxu Iòlòna Rybe wihikỹ tamyra ròhònyre. Kia tahe iny ritohodỹỹnyre. Ibutumy iny kia‑ò ralokremy idi ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Biu, bede rexihuke tahe isiraõre. Deuxu rybe tahe rexihuõtyhy. Kia isiratyhy rare. Ityyriti rybe wedenaõ riõnonyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Hãbuõ tahãwyy‑ribi ixãwikeki, idi iwitxira‑wana roikeki, tii òtadu rare. Hãwyy ixedu‑wana tii roikeki, òtadu rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ityhy mahãduõ riki tyy òwyhykỹwiwi‑di rexityynymyhỹre. Tii idi rexirabedesirananymyhỹre. Awimyhỹre tuu ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tahe urimynodu tyymy binadumy iijò‑ki ixyby ixyby ratximyhỹre. Lazaru inire. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tii ityhy rỹsỹnauhe rirỹsỹkemy raòbirenymyhỹre. Ijòròsa dori ityybinatòmy dirahumyhỹde. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lazaru rurureu, ỹju mahãdu ridyrenyre biu‑ò ilabiereny rora‑ò, Abraõ wahe. Tule ityhy rurure idi rituunyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tahe rubu‑ki rubu mahãdu bedebina‑ribi aõhõkỹmy dỹỹnana ityhy Abraõmy robire irehe‑ò Lazaru tule irora‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tahe ityhy dyryde: —Abraõ, walabie, wadi inihe bedexiwoboronyke. Lazaru ini wadee tebò‑ki beruty‑di kanake wadòròtò elehynamy. Jiarỹ dori raòhỹtỹhỹtỹreri kaheòtywo‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tukõleta, Abraõ narybede: —Dàà aõwiwihikỹ‑di tatemyhỹ‑di bexinohõtinyke. Tukõlemyta Lazaru aõbina binahakỹle rimyre. Tahe kaki aõwimy Lazaru ratxireri. Tukõmyta kai ibymy atxiteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ihãre ta hãloohukỹ inyko‑ki rỹire. Timyki kaludu kia‑ò iòhòreseõna. Tule kia ludu kaò iòhòreseõna. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Hebose, Abraõ walabie, kamy ityhy narybede, Urile Lazaru wasỹ‑ò biteònykekõ aõbo. Waseriòreboho deòwarisidỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Waseriòrereny dori iruyrerenyre urikõ‑ribi kabedebina‑ò kòdòiheny. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tahe Abraõ diwyònyde: —Tiiboho dori Moisesi tyyriti, Deuxu rybedu mahãdu tyyriti dire. Tii tahe tamy roholarenymy rityhynyrenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ityhy narybede: —Aõkõre Abraõ walabie. Kia inyõ tarubu‑ribi rexixamy ròòsekeki xiery ta, taòrarunareny‑ribi rexirahĩrenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tahe Abraõ dirawyònyde ixyby. —Moisesi tyyriti rybe‑ò, Deuxumy rybedu mahãdu rybe‑ò roholaõkeki, tii mobo rexixake tule ityhydỹỹõna. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tahe Jesuisi taerydỹỹna mahãdu‑ò rarybere: —Kiemy inyõ wodohonadỹỹmy aradykre òraruna‑ò besekemy. Kobe làhàxe tii kiawesemy rotỹỹnykreki. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tii dori ibinatyhy rare. Wadee heka kabera‑txi mana‑di rataataamy sỹy‑ò reakenawi rare. Tukõmy uri‑ribi watyhydỹỹdu tỹmyraõ riòrarudỹỹnyheny. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Bexiijebeny ta. Aityhydỹỹdu seriòre rexiòrarunanykeki, tamy marãhĩke. Tii rexirãhĩkeki, iaõna aõna bina‑ribi bexinohõtilosanyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Txu sohojiõmy adee rexibinanykeki, kai tule ibinamy tai mahamy. Tii ixi‑di rexiwotòenymy adee nakeki, tule idi bexiwobrunymy bexinohõtilosanyke iaõna aõna‑di. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesuisi erydỹỹna mahãdu dexitòenydenyde: —Wanyrỹreny, wainatyhynareny ini bisõwedỹỹnyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesuisi dirawyònyde: —Ainatyhynareny heka sunysisõmo wesekeki, kamy bederarade‑ò marybebenyke: —Bexitake inihe idi bera‑txi myike. Tahe tii aratyhynykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Titxibo kaibohoõ eòdudirenykeki aoworu‑di itxeredu ada budoeni‑di itxeredu wahe. Tii taaõmysỹdỹỹna‑ribi kanalokreu, kawesemy aõbo tamy manarybekre? Wy, wylemy rikiroxikre dori. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Timyki kawese tamy arybeõna. Tukõmyta tamy marybeke: —Warỹsỹna biywinyke idi wadee, idi manakre. Ariroxikre dori. Wabyre arihu‑di ta bexiòenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Teòdu deòdumy rearahu‑di aõbo, txiòtòetuukemy tamy rarybere aõbo. Timyki tukõna. Kiemy dori taaõmysỹdỹỹnale riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iu aõmysỹdỹỹnareny bihudi, iwese heka atximahãbenyke kamy bexirybenymyhỹbenyke: Inyboho deòdule roire, aõtyhy aõkõ mynodu, iny aõmysỹdỹỹnarenyle heka inyboho riwinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesuisi Jerusalẽ hãwã‑ò ramyhỹreu, Samaria bede, Kalileia bede wotya‑di rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Iu hãwãõ‑txi raloreu, debo ituemy sõwereny tyymy binamy mahãdu iry‑ò doide, tahe irehemy rexierenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Iribi tamy dyrydenyde: —Jesuisi, Erydỹỹdu, wadireny ini bexiwobrunyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tureny robireu, narybede Jesuisi‑ò: —Xiwena wahidỹỹna mahãdu‑ò ixi‑di itxerenamy bòike. Kia‑ò rariamy roirenyreu, tahe reyterenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Ijõreny Samaria ludu mahãduõ reytemy iximy robireu, Deuxu riwowydydỹỹnymy tamy dòòsede, rawiunymy. Tatiowomy Jesuisiko‑ò resere. Tahe rarybere: —Txiòtòetuuke. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tahe Jesuisi ritỹỹraxinyre: —Debò itue wese, asõwerenyre? Titxibo ta debò inaubiòwaboho roire? ");
INSERT INTO kpjNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aõherekiwe kaa iny witxira sohojile Deuxu wowydydỹỹmy dòòsede, Samaria luduõ wahe? ");
INSERT INTO kpjNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tahe Jesuisi tamy rarybere: —Mynyike, idi makre. Atyhydỹỹna òraru‑ki dori teyteta. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Idi fariseu mahãdu Jesuisi‑ò rỹỹraxirenyre: —Tiubo Deuxu Iòlòna kanakre? Tii diwyònyde: —Timyki Deuxu Iòlòna dehemynysỹnamy inyõ robiõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tule inyõ kiau rarybeõtyhy: —Betehebeny inihe ka‑ò: —Tukõmy aõbo: —Kowaki heka rare? Deuxu Iòlòna dori aworeny‑ki rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tahe taerydỹỹna mahãdu‑ò rarybere: —Tiutxumy heka Deuxu Riòre Hãbutyhyhykỹ txumy bobibenykemy tahe bobibenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tahe ijõ adeereny kanarybekre: —Bedetehebeny inihe kaò ada kowa‑ò. Tahe iitxerenyõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Iwese tiribi tiò biu relaanymyhỹre wese heka Deuxu Riòre Hãbutyhyhykỹ txu kỹnyikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Delemy tahe tii aõhõkỹmy rotỹỹnykre. Wijinabòdu mahãdu teramy reakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noe bededỹỹnana wesemy heka rỹimyhỹkre. Iu beòra rariareu. Tahe Deuxu Riòre Hãbutyhyhykỹ kedehemynykre iu. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ibutumy heka worana bedehesi rỹire. Lisisò tahe rỹire. Hãwyy herina lisina rỹire iu. Iu tahe beòra rariare. Ibutumy ituere. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lòò bededỹỹnana tule iwesere. Tiiboho worana bedehesidile rỹire. Tiiboho rityhynyõtyhy. Urile hetomy riwinymyhỹre, oworumy riwinymyhỹre, aõna‑di rohonymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Iu tahe Lòò ihãwã‑ribi ròhònyreu, Deuxu heòty ityre riteònyre. Biu‑ribi heòty ityre resere enxofre‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Iwesele txu tii heka rarekre heka, Wadehemynyna Deuxu Riòre Hãbutyhyhykỹ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kiau tahe inyõ ihetotyre heka rỹire. Malòkekõ heka ahetowo‑ò aõnamynamy. Inyõ tule oworu‑ki rỹire, taheto‑ò aõkõ ròòseke. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lòò hãwyy‑di mohõtinyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Inyõ taumy riyrubunykeki, tii ruruke. Ijõ tahe wadeewimy rurukeki, tii taumy rayrubukre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Adee rarybere: —Bede rurureu heka inatxi hãbu rõrõreri. Ijõ heka rakre dynamy reakre. Ijõ tahe rarikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Inatxi hãwyy heka rỹsỹna‑di raaõmysỹdỹỹnymy heto‑ki ratxikre. Ijõ heka dynamy reakre, ijõ heka rarikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Inatxi hãbu heka oworu‑ki raaõmysỹdỹỹkre. Ijõ heka rakre dynamy reakre, Ijõ tahe ririkre. ");
INSERT INTO kpjNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ierydỹỹna mahãdu rỹỹraxire. Titxibo rỹikre, Wanyrỹ? Tii rirawyònyre: —Titxibo iumy rubu roire‑wana, rara tai wii ributunyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesuisi heka ròkewesenanyre ribedeerynyreu. Kia wese heka tii ijyymy relyyre. Rexitòenyhyykemy tii ribedeerynyre tule ixitòedỹỹ‑ò ixirarenyõmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Hãwãõ‑ki tahe hãbu matuariõ rare, tii tahe ibinare. Juizimy heka ratximyhỹre ywisidỹỹdu wahe. Tii iny rityhynyõtyhy, Deuxu lau ruberuõmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tule heka hãwyy wyteseõ tai rasỹnymyhỹre. Kia tamy ramyhỹre sõwemy. Tamy rarybera: —Biwawikòhenakykre wahe. Wakòludu tahe riwahureri. Kywisidỹkỹdu kai atxiteri. Anoherekibo tiwawokutòenykõteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Aõòhòkõmy hãbu iaõna aõna òbitidỹỹ deramy reamyhỹre. Tahe Hãbu ixidee rarybehyyra. Inatyhymy jiarỹ inyõ retyhynyõtyhy. Tahe hãwyy wytese sõwemy wadee rarybereki, jiarỹ ariòbitinykre iaõna aõna ibutumy iòludu‑wana. Aõkõkeki tiiemy kidiwarulòlòenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tahe Jesuisi ritỹnynyre: —Juizi bina rybe‑ò kaiboho boholabenyke. My wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Deuxu heka taijoi mahãdu‑ò roholake. Òbitimy iòludu‑di riywisinykre. Taijoi mahãdu dori tamy rexitòenyre. Tii wymy riwiòhenanyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tii inatyhymy taijoi mahãdu riwiòhenanykre. Jiarỹ, Deuxu Riòre Hãbutyhyhykỹ wymy adehemynykreu, watyhydỹỹdu‑txi aõbo areakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tule Jesuisi kia ijyy relyyre, iny ixityhymy ixi‑di ratxityhymy kia ijõ inymy kiale radònymyhỹre. Kia tahe rikewesenanyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Iny inatxi hãbumy heka templo‑ò ròirenyre rexitòenykemy. Ijõ fariseu rare, ijõ tahe nieru arisidu rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseu tahe rỹimy rexitòenykemy ixidee. My wahe: —Deuxu, jiarỹ aõhãbubina aõkõ rare. Tai tahe umy reàlàmy wahãre. Jiarỹ aõwasidu aõkõ, aõòrarudu aõkõ, aõòtadu aõkõ. Iwese kowa nieru arisidu wese aõkõ jiarỹ rare. Txiòtòetuuke tai. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Semana sohoji heka wabyreõ‑di inatxitxumy rewymyhỹre. Tule waaõna aõna ibutumy ijura adee rewahinyre. Debòwiòna‑ribi sohoji rewahinymyhỹre wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nieru arisidu tahe irehemy rỹire. Biu‑ò aõkõ retehere, tahe rexihetenyre rexitòenyrerimy Deuxu‑ò. My wahe: —Deuxu, biwawotòenyke. Jiarỹ òrarudu rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesuisi ijyy ritỹnynyre: —Adee ararybekre. Mobo teysamy taheto‑ò nade? Ixityhydỹỹdu aõbo ada ijõ aõbo. Kohe ijõ tuure, ixityhydỹỹdukõ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tiiboho heka uladu tamy didydenyde. Iu Jesuisi tebò iratityre ritidimy ritxuhore awimy roirekemy. Tahe ierydỹỹna mahãdu tamy idyrenyõkremy raryberenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesuisi rarybere: —Txiò, kididyke uladu wadee. Uladu wese dori Deuxu Iòlòna rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Inatyhymy ararybekre: —Moõ heka uladu wesemy Deuxu Iòlòna rityhynyõkeki kia heka Deuxu Iòlòna‑ò ralòõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Idi tahe iweduõ rarybere: —Erydỹỹdu wihikỹ, aõwexe ariwinykre idi biu‑ò arahenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesuisi tamy rarybere: —Aõbo wa wihikỹmy wadee tarybeta. Hãbuõ tiu awiõre. Deuxu sohojile tahe awira. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Bede ywina tyyriti kai teeryte: —Rubudỹỹõmykemy, tule òta òtaõmykemy, wasiõmykemy, tule ruiõmykemy, iny wii itxenadỹỹõmykemy, adi biywinykemy, boo tule. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hãbu tamy rarybere. —Kia bede ywina rybe retyhynyhyylere, uladudihyyle wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesuisi rarybere: —Kai sohoji aõmydỹỹnale aki nasiranyde. Kai makre, ibutumy aõna aõna‑di bohonykre, idi tahe kia nieru biwahinykre iny aõkõdu mahãdu‑ò. Kia tahe aõmydỹỹnadikre biu‑ki. Tahe manakre biwaheludunykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kia rybe‑ki heka hãbu rabedewore. Rexitare ibedewomy iaõna aõna sõwetyhyreki. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesuisi retehemy ibederyry‑di tahe rarybera taerydỹỹna‑ò: —Kia iny iaõna aõna sõwemy rỹireri, Deuxu Iòlòna‑ò ralòke isirare. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamelo tyyrorenawo‑di ralòkemy isirakeki, kia‑ribi isiratyhyre iny iaõna aõnadikeki ralòke Deuxu Iòlòna‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ijohonadu tahe widee rarybere: —Mobo tai biu‑ò hedukre. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesuisi rarybera: —Inatyhymy kõaõboka hãbu‑ò isiratyhyre. Deuxu‑ò tahe ibutumy aõna aõna isiraõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro rarybere: —Boholake, jiarỹboho ibutumy rerirenyra araheludunykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesuisi rarybere tamy: —Inatyhymy adeereny ararybekre. Moõ waluukeki, rybewihikỹ luukeki, kia heka ririkre: heto, taseriòre, tyby tadi‑wana, tariòre, tabede, ibutumy waòraru‑ki, Deuxu Iòlòna òraru‑ki, ririkre. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ka bedekile ritakre sõwetyhymy ibutumy aõna aõna. Ihãreta biu‑ò rahenykre Deuxu‑wana rasỹnykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesuisi taerydỹỹna mahãdu ridyre inysõwe‑ribi tamyreny rarybekemy: —Boholabenyke waijoi! Jerusalẽ‑ò rokoirenykre. Tai iny riwarubunykre jiarỹ Hãbutyhy rarehãre, Deuxu Riòre rarehãre wahe. Iwese Deuxu Rybemy rybedu mahãdu rarybere wese. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tiiboho riwawahinykre judeukõdu mahãdu‑ò. Tiiboho riwabinabinadỹỹnykre, riwalahikre, watyre rarybexinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Riwahetenykre òhòte‑di, idi riwarubunykre. Ihãre tahe inataõ txu‑di tahe adexixakre rubu‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jesuisi erydỹỹna mahãdu urile bede riòtiinyrenyre. Aõmybo tii rarybere rierytyhyõrenyre. Irybe tamyreny dori ierynatyhykõreri. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iu Ijeriò hãwã‑ribi iòhòmy roirenyreu, inatxi iny ruetàmy heka ronymyhỹ Jesuisi ibire‑di rareu. Tiiboho nierumy rexitòenymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Inysõwe‑ò roholarenyreu tahe, tii rỹỹraxirenyre: —Aõhereriwe. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tahe tamy rarybere: —Jesuisi wa rareri Nazare hãwã ludu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tahe ruetàõ ryryre: —Jesuisi, Davi riokore! Biwatòenyke hewa! Wadi làhà inihe bexiruxetòenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Iny sõwemy tamy rarybere: —Iryõmyke! Ihãre ta tii ryrymyhỹre: —Davi riokore, wadi mawotòeke! ");
INSERT INTO kpjNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesuisi riyryre tahe rarybere: —Tamy byryke wadee kanakemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Jesuisi tamy rarybere: —Aõmybo kai taruteri adee arutỹỹnykremy. Tahe hãbu ruetàhàkỹ tamy rarybere: —Wawedu, ixityre arobikremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesuisi tahe tamy rarybere: —Makre, atyhydỹỹna kai arateytenyra. Kialehe rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aõwesele ixityrele tii robire. Tahe Jesuisihemy rare ryy‑di. Taihe ibutumy iny heka Deuxu riwowydynymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ijeriò hãwã‑ki Jesuisi rehemynyre. Idi rariareri. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tahe hãbuõ tahe Jesuisi riere. Zaqueu inire. Inieru sõwere. Tii nieru tarasadu weduõ rare. Inieru sõwere. Tii heka iyjare tahe Jesuisimy robiõtyhy. Raòwònyre tahe òwòru‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tii Jesuisimy robikemy risỹnymyhỹ, tiu tuu robiõhyymyhỹreki. Iyjare‑ki tahe rexisiranyre. Kiemy dori iny rarie rarie iko‑ki rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tahe ijoiko‑ò rexiraòre tai òwòruõ‑ò raòwònyre Jesuisimy robikemy iribi idi kanakreò. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iu Jesuisi tamy rehemynyreu, biu‑txi retehemy Zaqueu‑ò. Narybede: —Wylemy bedeseke Zaqueu. Wiji dori aheto‑ki bede wadi rỹike. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tahe rabedesamy wymy resere. Awimy Jesuisi rybe‑ki rahare. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tahe inyõ mahãdu iòraru‑ki kamy rexirybenyrenyre: —Aõhewe Jesuisi iheto‑ò rara? Tii iny òbikõmy nodu hãrele wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueu tahe Jesuisi rarybere: —Bodoholake ini, Wanyrỹ. Tahe waaõna aõna iwekre iaõkõdu mahãdu‑ò ariwahinymy ararekre. Tule txibo inyõ‑ribi rowasire inaubiòwa wawasi ratyre tamy ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tai Jesuisi narybede: —Wijityhyle kahãbu sỹmahãdu‑ò henana rehemynyra. Kahãbu tule Abraõ riore riòrele rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Deuxu Riòre Hãbutyhyhykỹ dori iny òrarunamy resere mahãdu òrysymy itarasamy nade. Jiarỹ tiire. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesuisi tamyreny rawesenanyre timybo Deuxu Iòlòna raremy. Jerusalẽ hãwã‑ò iòhòmy ratximyhỹre. Tai tahe Deuxu Iòlòna iòhòmy ratximyhỹremy roholare. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tahe Jesuisi rarybere iny ityhyõ heka: —Inyõ nihikỹ heka rakemy ratximyhỹre ijõ bede‑ò ratỹinykemy. Tai iòlòmy ronykremy rare. Iribi tahe ròòsere. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tii tahe taaõmydỹỹnana ririre teòdu mahãdu‑ki. Teòdu mahãdu debòwiòmy heka womati tỹrỹrỹhỹkỹ nieruõ sohoji sohoji tamyreny riwahinyre. Tamyreny rarybere: —Nieru bitakre, idi bibutunybenykremy adireny watxireri adoosekreu. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tahe kia bede ludu mahãdu iòlò deramy ratximyhỹre tai tahe tamy rybemy iny mahãduõ riteònyre: —Kahãbu aõkõ iny iòlòreny ronykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ihãre tahe iòlòmy ronyre. Idi tahe tanieru wedu mahãdu‑ò rarariòwyre. Tiwesebo teòdu mahãdu nieru ritare rierykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Juhuludu tahe rehemynyre: —Wawedu, betehe inihe ijõ debòwiò anieru ratyre rebutunyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tahe iòlò sõwemy riwowydynyre: —Awityhymyhe taaõmysỹdỹỹta. Kai heka deòdu wihikỹ tate. Kai ibutedile sõwemy tewinyte tahe debòwiò hãwã adee ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ijõ tahe rehemynyre: —Wawedu, betehe iny iruyre anieru tyre rebutunyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tahe iòlò tamy rarybere: —Kai sỹ iruyre hãwãmy dinodu mabekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ijõ deòdu rehemynyre: —Wawedu, ahãxe anieru. Jiarỹ tyky‑di reraserasenymy rerarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Jiarỹ alau raberure. Kai dori hãbu nieru tarasaery heka tate. Aõ taaõmysỹdỹỹteri‑ribi aõkõ heka nieru tetamahãte. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","—Kai heka deòdu awi aõkõ heka tate. Arybe xiery waribi arateònykre. Kai tiwaeryte jiarỹ nieru tarasaery heka watxireri. Aõ raaõmysỹdỹỹre‑ribi aõkõ nieru retamahãre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aõherekibo. Kia nieru yrubuna heto‑ki terikõte. Tai iximyna ratyre ini iribi ratare. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Iòlò teòdu inatxi‑ò rarybere: —Wanieru iribi bitabenyke. Ijõ hãbu sõwemy ròtareò rawahikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ijõ raryberenyre: —Tii heka debòwiò nieru ijõdire. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Adee ararybekre: —Inyõ òbitimy raaõmysỹdỹỹkeki, tii sõwetyhymy ritakre. Tule inyõ òbitimy raaõmysỹdỹỹõkeki, tii ibutumy ròõnodỹỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Iwedu rarybekre: —Waòludu mahãdu tahe wadee bididybedenyke. Wadera mahãdu wahe. Wako‑ki birubunybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tarybe rahudi tahe Jesuisi rare Jerusalẽ hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jerusalẽ iòhòmy ritehemynyrenyreu, tahe inatxi taerydỹỹna bede riywinyra hãwã‑ò roikemy. Inatxi hãwã iòhòmy roire, Betabaji, Betỹnia‑wana. Kia‑ò Oliveira hãwãlò roire. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jesuisi rarybere: —Kaiboho boikre kowa hãwã‑ò. Kowa‑ò birònykreu jumenta riòre mahabenykre. Moheka ityre rariaõlemy ratximyhỹre. Biesemy, wadee bididybedenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Inyõ adeereny rarybekeki: —Aõhekremybo idi atxitenyteri. Tahe tamy marybebenykre: —Wanyrỹ tuu rurureri. Ixityre kaò kidiòkesedỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tahe hãbu roire. Iwese Jesuisi rarybere wese ibutumy rỹire. Jumenta riòre ryro hetoijò‑ki ritisanymy rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tai riesereu, iwedu rarybere: —Aõherekibo teeseteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tai tiiboho Jesuisi rybe myna tamy raryberenyre: —Inynyrỹ tuu rurureri. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tahe ridyrenyre jumenta riòre Jesuisi‑ò. Tiiboho tatyyreny ritidirenyre jumenta riòre tyremy. Tiiboho risỹnyrenyre Jesuisi ityre‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesuisi rehemynyreu, ijõboho tahe tauwòhi ryromy ritidire ityre rariakemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jerusalẽ iòhòmy rehemynyreu, Oliveira hãwãlò‑ribi, ierydỹỹna mahãdu rawyhyrarònyreri, tule ryryreri. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tii heka wowydyna rare. Tii heka Wanyrỹ niwesekemy naderi. Wowydyna rare Deuxu Iòlòna. Kai Iòlòna kanakre. Wyhyrarò biu‑txi kodoholakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ijõ fariseu mahãdu rarybere Jesuisi‑ò: —Marybeke aerydỹỹna mahãdu‑ò tiiboho riyrykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesuisi tamy rirawyònyre: —Tiiboho riyrykeki, manale wowydynamy ryryke. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesuisi Jerusalẽ hãwã‑ò iòhòmy rehemynyreu, rahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tii rarybere: —Kaiboho ywinatyhy teeryõte. Inatyhymy teeryte wana wadee awire, tahe aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ijõ txu kanakre. Ahãwã ibutumy rirurawonykre aõbina mahãdu, aòludu. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ibutumy hãwã ituekre. Iny iwo‑ki tule rurukre. Mana ibutumy kedesekre. Rierykõre dori tiubo jiarỹ ahedỹỹrenymy nanade. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tahe Jesuisi dohodỹỹna hetowo‑ò ralore. Tahe kia‑ribi aõna aõna‑di rohonymyhỹre mahãdu, õbradu mahãdu diteònyde. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Rierynanymyhỹre tahe tamy rarybere: —Raritidỹỹõlemy aõbo rỹireri: —Waheto kõaõboka inatyhymy ixitòedỹỹna hetomy rỹirakre. Idi kaiboho tewinytenyte wasidu hetowesele. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Txu ibutumy Jesuisi dohodỹỹna heto‑ki ròbedeerydỹỹmyhỹ. Xiwe wedu mahãdu, Deuxu aõmysỹdỹỹdu wedu mahãdu roholarenyreu, rõhõtinyrenyre: —Timybo inyboho Jesuisi rubudỹỹmy rikiwisỹnyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tiiboho tahe aõkõhykyre iny sõwemy dori bede riòtiinymyhỹ ibedeerynadỹỹna‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ijõ txu tahe Jesuisi ròbedeerydỹỹmy, Ijyy Tỹmyra Wihikỹ wahe. Ririranymyhỹrenyreu dohodỹỹna hetowo‑ki, bede ywina erydỹỹna mahãdu, Deuxu xiwena wahidỹỹdu mahãdu wedu, tule matuari mahãdu tamy doide. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tiiboho tamy rỹỹraxirenyre: —Mowe ateòdỹỹdure kia aõna aõnamy tatỹỹnymyhỹtemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesuisi dirawyònyde: —Adeereny tule araỹraxikre. Kaiboho bidiwawyònykeki, tahe jiarỹ akoreny ỹraxina ariwyòkre aõrurudibo aõna aõna rewinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Tahe Jesuisi ritỹỹraxinyre: —Mobo Joaõ ratisebedỹỹmy riteranyre? Deuxu aõbo ada iny aõbo? ");
INSERT INTO kpjNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tiiboho widee rarybera: —Deuxu riteranyremy inyboho rakaryberenykeki, tai tii rarybekre: —Aõherekibo tahe tii tetyhynytenyõte. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Inyõ riteranyremy rakaryberenykeki, iny aruberuwỹhỹrenykre. Ibutumy iny dori Joaõ rityhynyre tii Deuxu rybe‑di rybedumy. Ijõ ijoi mahãdu urile inyreny kidihetenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tai tahe tiiboho raryberenyre: —Jiarỹboho reeryõrenyre. Tai tahe Jesuisi rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—Hebo, jiarỹ adeereny iximy ararybeõtyhy modeòdỹỹnamy jiarỹ tuu watxirerimy. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iribi tahe Jesuisi tamyreny ijyy‑di rierynanymyhỹre: —Hãbu uva oworuõ wese ròbròre. Tahe riòtitynyre. Tahe hãloo riare oworu ubetya‑ki, ruỹdỹỹnymy. Tahe utò riwinyre. Idi tahe rityhere hãbu mahãdu‑ò. Tahe rexitare tasỹ‑ribi ijõ bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tahe bederaty siredemy bededỹỹnana rehemynyreu, iwedu teòdu riteònyre bederaty ritakemy. Tahe oworu‑di itxeredu oworu wedu deòdu rimyrenyre, rihetenyrenyre idi riteònyrenyre ixihyylemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ixityre oworu wedu teòduõ riteònyre. Kia heka irati rihetenyre ta tamy rawobinarybenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ijõ riteònyre. Kia heka rirubunyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Iwedu ixi dee rarybere: —Aõhebo arotỹỹnykre. Tahe oworu wedu iriòre sohojilere, wariòre kie kie sohojile ariteònykre. Tai tiiboho rityhynyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kia oworu‑di itxeredu mahãdu widee raryberenyre: —Kia heka wedu aõna aõna tarasadu rare. Rurukre, idi tahe iaõna aõna inydeerenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tahe rimyrenyre idi rirubunyrenyre tahe idi rehurenyre oworu‑ribi. Jesuisi ritỹỹraxinyre: —Aõhebo tahe oworu wedu rotỹỹnykre. Tai Jesuisi ixityre narybede: ");
INSERT INTO kpjNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","—Tii kanakre oworu‑di itxeredu mahãdu hudumy, tai tahe oworu rityhekre iny witxiraõ‑ò. Kia‑ò tiiboho roholareu, tahe raryberenyre. Timyki tukõna. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesuisi idi reny retehemy tahe rarybere: —Ritina‑di aõbo tariaõletenyte kia ryberiti: —Mana‑di hetowidỹỹdu rehura. Kia mana heka hetohàtxi‑ki heridu rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Inyõ kia manatyre resekeki, kia urile raoroorokre. Mana tahe inytyre resekeki, kia urile risyrisynykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bede ywina erydỹỹna mahãdu, tule xiwena wahidỹỹna mahãdu wedu rimykemy riwisỹnyre kiaule. Brebumy ta turenykõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tiiboho hãbubinaõ riòwynyre tamy imynamy irybe‑ki. Tai tahe Dinodu‑ò riwahinykremy aõsirakõmy timykibo irutaõmy rirybewitxiranyrenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tiiboho rarybere Jesuisi‑ò: —Erydỹỹdu, jiarỹboho araerymy adi watximahãrenyre kai inatyhy hãbu tate. Iny ibutumy adee wiwese wiweselere. Inatyhymy iny‑ò Deuxurymy teerynanymahãte. Tahe tiiboho ritỹỹraxirenyre: ");
INSERT INTO kpjNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","—Awire aõbo ada ibinare aõbo nieru rawahinymyhỹre bede dinodu‑ò. Timybo tahe, imposto raòwymy aõbo ada aõkõre aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesuisi rierymyhỹre tõhõtinanareny, tahe ritỹỹraxinyra: —Aõherekibo kaiboho tiwaurihitenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Wadee womati nieruõ bidiwy waitxerenamy. —Kawe moõ tyytarasana rare, katahe moõ tyyritina rare. Tiiboho dirawyònyde: —Kiahe bede dinodu hõrõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesuisi rarybere: —Hỹdebo, bede dinodu hõrõ tahe tamy biwahinybeny, tule tahe Deuxu aõna aõnahõrõ Deuxu‑ò biwahinybeny. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tiiboho aõkõre. Irybe‑ki rimynamy aõkõ. Urile ribedeòtiinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduseu mahãdu tamy nade. Kia heka iny rubu‑ribi rexixamy aõkõre‑riki rierynanymyhỹre. Tiiboho ritỹỹraxinyre Jesuisi: ");
INSERT INTO kpjNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Erydỹỹdu, Moisesi raritinyre bede ywina‑ò, kaimy: —Hãbuõ rurukeki, tahãwyy iriòre ijõdiõkeki, tahe kia hãwyy tahãbu seriòre‑wana roike. Iriòredikre taseriòre rubuòwymy roikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Seriòre debòinatxi reuròmy raremyhỹ. Juhuu ijõ roire hãwyy‑wana. Tahe tii rurure iriòreõlemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tahe ihewoludu iseriòre wytese‑wana roire. Tii rurure iriòreõlemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ihewoludutyhy tule ibutumy roire wytese‑wana, tahe ituerenyre iriòreõlemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Iròòbymy tahe hãwyy tule rurure. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ixixanau tahe mohãbubo tii‑wana rarekre. Ibutumy dori wytese‑wana roire. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesuisi rirawyònyre: —Kabede‑ki hãwyymy iny roimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ixixanabedeu heka moõ roiõtyhy, inyõ dori bede kia riòbynykreu. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ibutumy iny ỹju wese rarekre biu bede‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisesi tatyyriti itỹnyhỹkỹlemy rarybere: —Iny rubu‑ribi kedexixakremy. Tai ta heòty òwòru sõmo riworonymyhỹki ixybylesỹ rarybera: —Deuxu heka Abraõ, Ijai, Ijaò kia Deuxu rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tai Deuxu inyru mahãdu Deuxu dori rare. Iny rubu mahãdu ta aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Inyõ rarybere: —Arawyònakyhyna, Wanyrỹ tate. Bede ywina tabohe teerytyhyte! ");
INSERT INTO kpjNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tai tahe ixyby rỹỹraxiõhyyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesuisi rarybere: —Timybo bede ywina erydỹỹdu mahãdu rarybemyhỹre Kristu Davi riòre raremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davi rarybere aõmybo Deuxu Tyytybytyhy tamy narybedemy iwiuna‑ki: —Wanyrỹ rarybere Wanyrỹ‑ò: —Bodony warurunawe‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Txiòhe inihe, aòludu awarawo‑txi aritidikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tahe Davile tanyrỹmy rininire. Timyki tahe Davi itybymykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tii taerydỹỹna mahãdu rierynamyhỹreu. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Tii rarybera: —Bexiemyhỹbeny bede ywina erydỹỹdu mahãdu lau. Tiiboho heka tyyrehetyhywidihikỹle rexityynymyhỹrenyre. Tiiboho heka ixi rybedỹỹluurenyre hãwã riraki. Dohodỹỹna heto‑ki rynanawi luurenyre. Tule ta anarỹỹ rỹi‑wana, tyhytyrekile rynana tamyreny awire. ");
INSERT INTO kpjNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tiiboho tule wytese aõ aõkõ mahãdu aõna aõna ritamyhỹrenyre. Ixitòedỹỹna rehehekỹ rexitòenymyhỹrenyre. Tiiboho heka aõnihikỹmy aõhõkỹmy dỹỹnanamy rotỹỹnyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesuisi retehemy rỹimyhỹ dohodỹỹna heto nieruhyna‑txi. Tii retehere tibo iny tanieru‑di rehumyhỹdi. Tai inieru sõwe mahãdu nieru sõwemy ritidimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tule tahe nade wytese aõ aõkõ mahãduõ. Tii inatxi nieru sõmo‑di rehure. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tai Jesuisi rarybere: —Kowa heka wytese nieru‑di rehure ibutumy iny witxira ratyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ijõ mahãdu tanieru uhedile rehumyhỹ. Tahe wytese idi rehure ibutumy tanieru‑di rexihumy taumy‑ribi idi rehure. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Dohodỹỹna hetomy ierydỹỹna tamy rarybere: —Erydỹỹdu, beteheke mana wihikỹ ruxera ruxera‑di eryna heto riruxeranyreridi. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jesuisi rirawyònyre: —Kaiboho betehebenykre hetonihikỹ‑ò. Kia heka mana ijõ wityre‑ki rỹiõtyhy, ibutumy heka kedejuxunykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tiiboho ritỹỹraxinyre. Tiubohe ibutumy kidiixixãwididỹỹnykre. Tiiboho ibutumy bede konanadỹỹnamy reakre. Timybohe arieryrenykre, aõma bede ibutumy rexihukre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesuisi tamyreny rarybere: —Kaiboho anaitxenanydenyheny lau bexiebenyke. Sõwemy dori rỹikre wanimy rarybemy rarekre: —Jiarỹ dori Kristu rare. Tahe iny sõwemy itxenadỹỹmy reakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kaiboho wounarybe‑ò, aõbina rybe‑ò, boholakreu, breburenyõmykre. Kia heka kanakremy ratximyhỹre. Urile bededỹỹnana ikonanatyhy aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tii tamyreny rarybere: —Uritere iny lahinareny, ijõ lahinareny widee kanaaõbinanykre. Tule iòlòna mahãdu, ijõ iòlòna mahãdu‑wana widee kanaaõbinanykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bede bedesu ijõ hãwã‑ki kanamytatakre. Tahe aõkõre rama kedeakre. Kia heka juhu aõhõkỹmydỹỹnana rarekre. Aõbrebuna brebuna kỹnyikre. Idi biu‑ki aõwitxira kỹnyikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Tiiboho arawahinyrenykre aòludu wedu‑ò, iòlò‑ò. Kaiboho heka aõhõkỹmy iu botỹỹnybenykre, watyhydỹỹ òraru‑ki. Tiiboho arahatenyrenykre dohodỹỹna hetowo‑ki. Kiabohoko‑txi wadee kaiboho kedelyykre inatyhymy aõna aõna rỹiremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Rybewihikỹmy ibutumy bede bede hãwã hãwã‑ò belyybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tiubo aradyrenykeu, urile nohõtiõmy aõmybo kaiboho marybebenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kiautyhyle aõmybo marybebenykremy bierykre. Kia tahe marybekre. Kai aõkõ dori marybekre, Deuxu Tyytybytyhy tahe rybedukre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Asỹreny dori ròtenawo‑ò araròtenyrenykre. Seriòre seriòrele wii kidirubunykre. Tyby heka tariòre kidirubunykre. Uladule tadi, tyby kidirubunykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ibutumy heka iny iy kedeakre wani òraru‑ki adeereny. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ibedeu araderenytiõ reseõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bexityhymy ta tai ixiery dori biu‑ò mahenybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ijõ tahe Jesuisi rarybere: —Woudu mahãdu Jerusalẽ rirurawonykreu heka bierybenykre aõhuluhudunamy bede rỹirerimy. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Judeia hãwã hãwã‑ki ratxikeki, mahenybenykre bederatòòhòkỹ‑ò. Inyõ Judeia hãwãkikeki, iribi òlò rỹikre. Idi inyõ bederokeki ixyby Jerusalẽ‑ò ròteõmykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kia txuu heka òwynatxumy rare. Ibutumy rybe tyyriti myna heka bede rỹikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kobexe heny hãwyy bòtòmy rỹira, tule hãwyy tariòre ritònymy rỹira. Aõhõkỹmydỹỹnana kanakre tiu heka tuuõre. Debure nihikỹ heka kanake kia iny tyre‑ki. Tiu heka kiamy bede roiõtyhy aõhõkỹmydỹỹnanamy. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sõwemy iny rurukre mayrehe‑di. Iny sõwemy radykre ijõ bede‑ò aõhõkỹmy tai rotỹỹnykremy. Ityhydỹỹdukõdu mahãdu rasỹnykre Jerusalẽ hãwã‑ki iu. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ixityre tahe Jesuisi rarybere: —Idi webòhòna rỹira txuu, aõhõkỹmydỹỹnana itue‑di, txuu heka rurunykre. Ahãdu tule rurunykre, tule taina. Beòbò lau iwodỹỹ lau ibutumy iny ruberukre inihikỹ òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Iu bede bede iny mahãdu aõhebo rotỹỹnymy, tatõhõtibre‑di tiiboho reserenyre sutyre‑ki tai. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Iny retehekre Deuxu Riòre, Hãbutyhyhykỹ dehemynyna‑di. Biurawetyky‑ribi kodobehekre tatyhy‑di. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tahe kia aõmydỹỹnana rỹikreu, ywinamy bòibenykeu, iòhòlereri. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Tai tahe Jesuisi figueiraò‑wana tahe bede ròkewesenanyre: —Figueiraò‑di ini bexinohõtinybenyke. Tii heka tairu‑txi, tanoiròsò ritỹmyranymyhỹreu, tai tahe bierybenykre wyra iòhòreri. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tule kia aõna aõnamy bobibenykreu, tii iòhòlereri. Ijò‑ki iòhòwesele rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Inatyhymy adee ararybekre, kia wijinabòdu itueõtyhy aõna aõna rỹikre hãrele. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Biu, bede‑wana ituekre, tahe warybe itueõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Tahe Jesuisi tarybe rihumy rarybere: —Kaiboho bexiebenyke, betehebenykre ixinohõtidỹỹrenytyhykõmy. Roxina worana bedehesi‑di timybo kaiboho atximyhỹtenytedi. Mona juberere biõbenykemy mohõtinyõke. Kaiboho dori teeryõtenyte tiubedemybo adòòsekre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kiatxu kanakre tahe iwese nawii mynyna wese aõwesele rimykre ibutumy bede iny mahãdu rimykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Biebenyke tahe, Deuxu‑ò bexitòenybenyke. Kia tahe aõhebo rotỹỹnykre‑ribi mahenyke. Bityhynyke Deuxu Riòre, Hãbutyhyhykỹ, jiarỹ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Txuõ txuõlemy tii Dohodỹỹna heto‑ki ribedeerynyre ihãre tahe rumy Oliveira hãwãlò‑ò rara. ");
INSERT INTO kpjNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Rudile tahe sõwemy iny dohodỹỹna heto‑ò rehemynymyhỹre Jesuisi rybe‑ò ijohomy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Iòhòmy ratxireri Pascoa worana bedehesi kodohònykremy. Kia anarỹỹ wehityhynamy heka iny ratya‑di reare. Tule orotxu anarỹỹ kia ròhònyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Deuxu aõmysỹdỹỹdu wedu mahãdu, tule bede erydỹỹdu mahãdu Jesuisi rimykemy ratxireri idi rirubunykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satanasi heka Judasi Isariòwo‑ki ralore, tii Jesuisi erydỹỹnaõ ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Juda Isariò heka Deuxu aõmysỹdỹỹdu‑ò rara Jesuisi riwahinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tiiboho tamy roholarenyreu, reysare. Tahe tamy nieru riwahinykemy riurenanyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tahe Juda riijemyhỹre aõu aõu bedewihikỹ tamyreny riwahinykemy. Wasimy riwahinykemy tii roholare. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Juhu orotxu anarỹỹtxure budoeni xiweloo rirubuny rahudi tahe Jesuisi erydỹỹna mahãdu tamy rarybere: —Titxibo anarỹỹ rỹsỹnamy biroxikemy atxiteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tahe Jesuisi heka Pedro, Joaõ‑wana riteònyre: —Kaiboho boike iny rỹsỹnareny ywidỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tiiboho rỹỹraxire. Titxibo ariywinyrenykre? ");
INSERT INTO kpjNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesuisi tamy rarybere: —Kaiboho boikre hãwãhãkỹ‑ò. Tahe hãbu‑wana wii biòbynykre butxi‑di retyyreriò. Tahe tii biheludunybeny. Titxibo heto‑txi ralokreò, kaiboho tule bironybenymy bitỹỹraxinybenykre heto wedu: ");
INSERT INTO kpjNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","—Wawedureny rarybera: —Titxiwexe anarỹỹ rỹsỹna arirỹsỹkre waerydỹỹna mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tii heka adee kiditeòsinykre hetowoõ‑txi biu‑ki. Ibutumy rexihumy rỹire inydeereny. Tai rỹsỹna inydeereny biywinybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tahe ierydỹỹna rexitare. Roire hãwãhãkỹ‑ò. Tahe rotỹỹnyrenyre Jesuisi rybe myna. Tahe ibutumy rexihurenyre anarỹỹ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kia txu rimyreu tahe Jesuisi nade taerydỹỹna waòinatxi reurò‑wana byremy ronyrenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tii tamyreny rarybere: —Jiarỹ awanareny ariroxikemy watxiwãhãre. Karibi dori warubuna‑ò arakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Inatyhymy ararybekre: —Jiarỹ konanamy ayreny‑ki ariroxikre. Ixyby ta Deuxu Iòlònakile tahe rikiroxirenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tahe vĩĩ mona hyna rimyre, rexitòenyre, tahe tamyreny riwahinyre. Ibutumy ibute bute iribi tuu riõrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Inatyhymy ararybekre: —Tiu ixyby tuu ariõõtyhy Deuxu Iòlòna‑ki kotyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tiiboho riroxireriu, Jesuisi orotxu rimyreu, raorore, rexitòenyre, tahe tamyreny riwahinyre. Rarybere: —Ahãxe, kia heka waumy wese rare. Iu biroxikeu, warubuna‑di mohõtinybenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Biõbenyke! Kaa dori wahãlubu wesemy ratxireri. Tahe tamy riwahinyre riõrenykemy. Tai sõwemy iny ròhònyke biu‑ò hena‑ò ibutumy òraruna ixãwididỹỹmy. Tuu ròhònyra. Kia heka wadeewimy iny Deuxu‑wana ratxiinyhỹre, wahãlubu òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Boholabeny inihe watyhedỹỹdu inykyrenykile ronyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Iwese tyyriti‑ki roire wese heka arurukremy, Deuxu Riòre, Hãbutyhyhykỹ, jiarỹ wahe. Kobe làhàxe watyhedỹỹdu. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tiiboho tahe widee rarybere: —Mobo tahe rare? Mobo Jesuisi riwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Iribi tahe widee raryberenyre, mobo wiratyreremy? ");
INSERT INTO kpjNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tahe Jesuisi tamyreny rarybere: —Kabede iòlò mahãduy‑ki iruru dire. Bede dinodu tahe iny rininire: Iny biòwa. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tahe ayreny‑ki kawese aõkõ ihỹre. Inihikỹtyhy inyõ ratxikeki, tii inyuhe deòdumy ratxikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tibo inytyhy rare? Roxidu mahãdu ada deòdu mahãdu? Roxidu mahãdu, aõhe inatyhy? Jiarỹ tahe ayreny‑ki deòdu wesemy jiarỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kaiboho heka wawanahyy atxitenyte aõhõkỹmy ratỹỹnymyhỹreu. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tai tahe adee ruruna ariwahinykre. Iwese Waha wadee riwahinyre wese, adee ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Waiòlòna‑ki kaiboho wawana biroxibenykre, biõbenykre. Tule rynana wiwihikỹ tyre‑ki rỹdu mahãdumy bonybenyke. Israeli iny mahãdu heka kaiboho biòbitinybenykre, ibutumy judeu mahãdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesuisi ijõ rarybere: —Simaõ, Simaõ, wadee boholatyhyke. Satanasi araurihirenykemy wadee rexitòenyre. Tahe adeereny kanake araurihidỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Dori rexitòenymyhỹre, Simaõ, kai bityhynyhyykemy. Wadee bòdòòsekeu, abiòwa mahãdu biwiòhenanyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tahe Pedro diwyònyde: —Awanahyy arakre, wanyrỹ, arurukre hãre, ròtenawo‑ò arakre hãre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesuisi tamy rarybere: —Pedro, kai biwatxiõnyke, hãnie hãbu ryrykõule biwatxiõnyke inataõmy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesuisi tamyreny rỹỹraxire: —Juhu arateònyrenyreu anieruhynakõmy, asaurenykõmy, awarenyõmy, adeereny aõbo aõ rasiranyre? Tiiboho dirawyòmy: —Aõkõ, aõ rasiranyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tahe Jesuisi narybere: —Wiji tahe txibo inyõ inieruhynadikeki, saudikeki, biwykre. Txibo inyõ imayrehedikõkeki tayhyitxena‑di rohonykre iòwy‑di tahe tii riõbranykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kamy dori Deuxu rybe tyyriti‑ki roire: —Òbitikõmy nodu mahãdu‑wana tii rỹire. Ibutumy timybo tyyriti wamy rarybere heka rỹikre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tamy ierydỹỹna mahãdu rarybere: —Wanyrỹ, kaa inatxi mayrehe rỹire. Tahe Jesuisi rỹire rarybere: —Awire kia. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tahe Oliveira hãwãlò‑ò roirenyre, taerydỹỹna mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tiiboho kowa‑ò rehemynyreu, Jesuisi rarybere: Bexitòenyke! Tai tahe òraruna‑txi beseõke. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tahe iko‑txi urihimyò rareu, taowotimy resemy. Rexitòenyre: ");
INSERT INTO kpjNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Waha, adee arexitòenykre. Adee awikeki, aõhõkỹmy dỹỹnana waribi biixãwidỹỹnyke. Tahe adeewikomykre, wadeewi ta aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ỹjuõ tamy nade biu‑ribi tamy ruru riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sõwemy tahe rexitòenyre, iòsana‑ribi resere bee wahe. Hãlubu wese heka ihỹre resereri bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tii rehemynyre tai rahare rõrõrenymy roireriò. Tiiboho ele risarenyre sõwemy rabedeworenyreki. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tamyreny rarybere: —Aõherekibo tarõtenyteri? Biijebenykre, bexitòenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tii rarybereriu, aõwesele Judasi nade. Tii‑wana doide hãbu mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesuisi rarybere Judasi‑ò: —Judasi, Deuxu Riòre bityhenykre aõbo, jiarỹ hãbutyhyhykỹ wahe? Waòbuò‑di aõbo biwatyhenykre? ");
INSERT INTO kpjNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesuisi erydỹỹna mahãdu tuu robireu, tamy rarybere: —Iny mayrehe‑di araaõbinanyrenykre, Wanyrỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kia ijoiõ mayrehe ritare tahe Deuxu aõmysỹdỹỹdu wedu deòdu nohõti riorore. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tahe Jesuisi rarybere: —Ixãwike. Tahe hãbu nohõti riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tahe Jesuisi dirawyònyde tamyreny, Xiwe wahidỹỹdu mahãdu‑ò, dohodỹỹna heto itxedu wedu‑ò, matuari mahãdu‑ò: —Kaiboho mayrehe‑di, òhòte‑di tiwaòrytenyteri jiarỹ wasiduòrysy wese. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Jiarỹ tahe dohodỹỹna heto‑ki watximyhỹ txuõ txuõlemy adeereny anaerynanymahãdenyde. Kowa‑ki heka tiwamyõlemyhỹtenyte. Kia heka bededỹỹnana rexihure. Bede luru ruru roirerimy. Tahe aõbo iritina‑ki rỹireri, kia heka kỹnyikremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xiwena wahidỹỹdu mahãdu dinodutyhy‑ò wedu‑ò tiiboho Jesuisi ridyrenyre. Pedro riheludunyre ireheriòremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Rehemynyreu tai Pedro ixitòteenymy heòtywera‑ò ronyre heto itxeredu mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pedro ratximyhỹ‑ò tahe deòduõ rehemynyre, ijadòma wahe. Pedro‑di ijadòma retehemy ta rarybere: —Tii tule Jesuisi Nazareludu‑wana ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tahe tii rexitxiõnyre: —Jiarỹ reeryõre aõmyboho kai tarybeteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ixybyle kowa ijoiõ Pedro‑ò rarybera: —Inatyhymy kai ijõ mahãduleõ tate. Tii inatyhytyhyrybemy rarybera: —Jiarỹ reerykõre hãbumy tarybetenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ijõ òrau tahe ijõ rarybere: —Inatyhy rare kai Jesuisi‑wana ahãte, Kalileia mahãduõreki. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tahe Pedro rarybere: —Hãbu, reeryõre aõmybo tarybeteri! Tahe hãnie hãbu robura. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesuisi heka Pedro‑ò retehere. Tahe Jesuisi rybe‑txi Pedro tõhõti reare. Iwese Jesuisi rarybere: —Hãnie inataõmy robukre myna, kai waheludumy bedexitxiõnykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro tahe iribi rexitareu, ixidee iky reamy rahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tahe hãbu mahãdu Jesuisi rihetenymy, rilahirenymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","65","Tiiboho riruehetynymy rihetenymy idi ritỹỹraxinymyhỹre: —Mowe arahãtenyra. Idi tahe sõwemy idi risinymyhỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Rudile tahe judeu wedu mahãdu ributunyre xiwena wahidỹỹna mahãdu‑wana. Jesuisi ridyrenykemy raryberenyre dohodỹỹna mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tamy ritỹỹraxinyre: —Kai aõbo Kristu tate, Deuxu Riòretyhy. Jesuisi rarybera: —Jiarỹ heka kohemy ararybekeki, kaiboho biwatyhynyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Adeereny arỹỹraxikeki, kaiboho biwawyònybenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kaiboho bierybenykre Deuxu Riòre heka jiarỹ rare. Idi Waha rurunaweribi‑ò aronykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ibutumy tahe tamy rarybere: —Kai aõbo Deuxu Riòre tate? Tii rirawyònyre: —Iwese kaiboho tarybetenyteri wese jiarỹ inatyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tahe tiiboho raryberenyre: —Inyõ irybe‑ò ijohoke heka aõkõre, inybohole dori tuu roholarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kia iny ka ibutumy Jesuisi ridyrenyre Pilato‑ò, bede dinodu‑ò wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Idi tahe aõbina binahakỹmy tuu raryberenyre: —Kahãbu heka bede rijeijeinyreri iòlòmy ijoi radònykemy. Iribi iòlò‑ò òwydỹỹ rỹiõmyhỹkemy rarybere. Ihãreta Deuxu Deòdỹỹnamy raremy idi iòlòmy rexininimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tahe Pilato rỹỹraxire Jesuisi‑ò: —Inatyhywe kai Deuxu mahãdu iòlòtyhy tate? Tai tahe Jesuisi riwyònyre: —Kai tuu tarybeteri, Wanyrỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tai tahe Pilato rarybere xiwe wahidỹỹdu mahãdu dinodu‑ò, tule inysõwe mahãdu‑ò: —Timyki kahãbu aõhõkỹmy wasỹdỹỹõna, aõõ bina dori riwinyõlere. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tai ixyby idi risỹnyrenyre: —Kahãbu heka Kalileia bede‑ribi bede rijeijeinymy rareri, idi Judeia bede‑di tule katahe kakile tuu rotỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Taita Pilato rỹỹraxire: —Tii aõbohe Kalileia mahãduõ ratxireri? ");
INSERT INTO kpjNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Tii Kalileia mahãdu rare. Kia Pilato rieryreu, Herodi‑ò riteònykemy rexinohõtinyre. Tii kia dinodureki. Ihãreta Herodi Jerusalẽ hãwã‑ki iu ratximyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodi Jesuisi robireu heka reysare. Jesuisimy robikemy riwisỹnymyhỹre sõwemy. Idi tahe tuu robireke, reòsare. Tai tahe reysare. Ini‑ò roholahyymyhỹre. Tule aõwihikỹ witxira riwinykemy idi riwisỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Idi tahe Herodi sõwemy rỹỹraximyhỹre. Jesuisi tahe rirawyònyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aõbo xiwena wahidỹỹdu mahãdu wedu, tule bede ywina erỹdỹỹdu mahãdu sõwemy aõna aõna binamy tuu raryberenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodi tasoldado‑wana tuu raòhòtemy idi risinymyhỹreny. Tyywihikỹ‑di rirahananyrenyre. Iribi riòkesedỹỹnyre Pilato‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Juhuu heka Herodi Pilato òludumy widi raremyhỹ. Kia txule tahe widee rowoixirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Idi tahe Pilato tahe ibutumy xiwena wahidỹỹdu wedu, tule matuari mahãdu tule ijõ iny mahãdu ributunyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tamyreny rarybere: —Kaiboho heka wadee tedytenyteri bede jei jeiwidỹỹdumy tuu tarybetenyte tebutenyteri heka. Jiarỹ akoreny‑ò retỹỹraxinyre idi aõhe tai ibinamy rahaõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Tule iòlò Herodi tai ibinamy rahaõhyyre. Tai diòkesedỹỹnyde. Tai iurenana ta aõhereki timyki irubuõna. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Urile raòhòtedỹỹkemy bede reywinyre idi ta ixinamy rakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kiemy dori worana bedehesiu, ròtena‑ribi inyõ heka ròhònymyhỹke. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","19","Sõwemy iny heka rirajuare: —Aõkõre uritere ta Baraba biteònyke. Kia hãbu urile ruruke. (Baraba inyrubudỹỹdure. Bede jei jeidỹỹ‑ki heka ròtena‑ò ralore.) ");
INSERT INTO kpjNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tai Pilato Jesuisi òlòdỹỹmy riwisỹnymyhỹ tai ixyby rarybere: —Aõkõre Jesuisile ariteònykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sõwemy iny ixyby ryryre: —Aõkõre, itxeò‑ki bitamadỹỹnyke! ");
INSERT INTO kpjNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tahe Pilato tainatãõnamy narybede: —Aõherewe, aõwe tii ibinamy riwinyre. Aõheka tai ibinaõhyyreri rubu‑ò rawahikemy. Òhòteòle ta arawahinykre idi ariteònykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ihãre ta iny sõwe mahãdu ire rirajuamyhỹrenyre itxeò nihikỹ‑ò rurukemy. Ixieryta iryreny‑ò roholare idi tukremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Iu Pilato heka Jesuisi riwahinyre rubu‑ò tumyna rexitòenymyhỹrenymy. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ijõ hãbuõ ta ròtenawo‑ribi riòlòdỹỹnyre, iixitòedỹỹreny myna wahe. Tii hãbu aleerydu rare, tahe bede jei jeidỹỹdu tule. Iwana ta Jesuisi rawahire irybemynarenymy aõhebo rotỹỹnykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tahe Jesuisi ridyrenyre. Ryki tahe hãbuõ iutedereny‑ò nade, Simaõ inire, Sireni hãwã ludu wahe. Nohõtiõlemy ta ityre itxeò nihikỹ ritidirenyre, iherenymy idi kanakremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sõwemy ihemy nodu sõwe. Iy‑ki hãwyy mahãdu Jesuisi‑di robumyhỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tii tahe tamyreny rexiòkesemy narybede: —Jerusalẽ hãwã ludu hãwyy mahãdu! Ixirahi bobubenyke ariòre rahi tule warahi ta aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tiutxumybo bexirybenybenykre: —Hãwyky bedekòby heka raritxòrenykõre mahãdu rare, tohokuã ritònykõre mahãdu tiku kuladu‑di tarukikõre mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tiutxumybo bexirybenybenykre hãwãlò‑ò: —Watyrereny bedeseke tule hãwãlò riòre‑ò bexirybenybenykre: —Biwawòbenykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wiji kawesemyhỹre hee itukure hãre. Timykrebo tahe hee irubukreu. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ihãre tasỹse iny inatxi hãbu òbitimy nodu aõkõ ridyrenyre Jesuisi‑wana rururenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tahe hãwãlò riòre‑ò ratitybymy ninadu‑ò ritehemynyrenyre. Tahe tii‑wana inatxi wasidu itxeò nihikỹ‑ò rilamadỹỹnyrenyre. Ijõ ruruweribi‑ò ijõ hyweweribi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","—Waha, idireny bexiruxetòenyke rieryõhyyrenyreri dori aõmybo rotodỹỹnyreri. Tai tahe ityy wimy ritxuatxuakremy dado‑di rehumyhỹreny tibo iwydydukremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Iny retehemy rỹimyhỹ taile wahe. Judeu wedu mahãdu tule Jesuisimy rarybere: —Tii iny sõwemy rihedỹỹnyre, kia aõherekibo tii rexitaõreri rubu‑ribi, tii Deuxu deòdỹỹna rarehãre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tule soldado mahãdu rarybere aõbina binahakỹlemy. Diwyde tii aõna ta iny kremy rirahòreny tamy idi reare rijeny: ");
INSERT INTO kpjNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Kai inatyhymy judeu mahãdu iòlòmy atxiteri wana heka kaa bexitakre iribi. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Itxeò ratya‑ki tahe aõma timy roire tyyritidỹỹna. —Kaa Heka judeu Mahãdu Iòlò Rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ijõ heka rarybereri Jesuisibire‑ki roireriõle tamy rarybereri: —Deuxu deòdỹỹna tateki, bexitake tule biwatabenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","—Wy, Deuxu lau taberuõlemahãte aõbo tule dori iny aõhõkỹmy rokotỹỹnykrelemy iny roireri. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Lòwudu tamy rarybereri: —Iny heka rurureri, aõbina binahakỹ iny riwinyre òraru‑ki. Iny rurureri. Kaa hãbu rỹire tiu aõbina riwinyõhykyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jesuisi‑ò rarybere: —Jesuisi, watxi õhõti beakre Iòlòmy bonykreu. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesuisi tamy rarybere: —Wijile heka biu‑ò heka rakakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Txutyemy bede roronyre idi txioro txu rehehekỹ‑ò bede tuu rỹire. Inataõ òramy bede rybynyre, rỹire. Heto‑ki rahanaheridu urile raykare templowo‑ki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tahe Jesuisi rirajuare: —Waha, watyytyby adee rawahinyreri. Iu irybe rexihureu rurure. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldado mahãdu wedu tuu robire kia aõhebo rotỹỹnara tuu rarybere: —Kia inatyhymy hãbu òbitityhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ibutumy iny kia robire Jesuisi rubu‑ò rahinymy ròòsere rexihetenyrenymy tabreti‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ibutumy tii mahãdumy ratximyhỹre iribi ireheriòremy rexiijemyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tii judeu bede mahãduõ rare. Jyjemy inire. Tahe Kristu rubuna‑ki awimy rahaõhỹỹre taijoi mahãdu‑ribi. Tii dori Deuxu Iòlòna riraòmyhỹre. Ihãwã Arimatea inire. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tai ta rare ixitòedỹỹmy Pilato‑ò, Jesuisi umy kidiwahinykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","54","Tai tahe ritare itxeò‑ribi tyy ura nihikỹ‑di tyy‑di ritỹtetỹtenyre. Manawabedewo‑ò ritidire. Tai tiu iny rahãloonaõmyhỹre. Aõma judeu mahãdu elehyna txu wahe ixiywidỹỹnatxumy txu rỹireu heka aõma worana bedehesi txu. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hãwyy mahãdu Kalileia‑ribi Jesuisi‑wana. Tiiboho doide Jyje‑wana Jesuisi hãloo‑ò itxeremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tahe timybo roimyhỹ riòtudunyrenyre. Dòòsedenyde iribi aderòna lỹnyre ywidỹỹmy iumy tỹnyrenamy. Kia rexielehynyrenyre sabado txu bede ywidỹỹna myna‑di. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Juhu txu semana bededỹỹnanau txuu deadeu hãwyy roire wabede‑ò. Tiiboho riwyre lỹnyrena. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","3","Rehemynyrenyreu, mana nihikỹ tahe ijò‑ribi ratamy rỹire. Tahe ralòrenyreu, Jesuisiumy ihoõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wabede‑ò rirònyrenyreu, robirenyre inatxi hãbu. Ityy urahakỹmy ronymyhỹre tai. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tahe tiiboho bede riòtiinyrenyre idi tabrebu‑di suò reserenyre. Ỹjyõ tamyreny rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","—Iny irumy kaiboho teijeteri kaki wabede‑ki aõbo? Tii kaki ratxireri. Tii rexixara rubu‑ribi adeereny rarybere wese Kalileia bede‑ki: ");
INSERT INTO kpjNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","—Inyõ riwawahinykre inybina‑ò Deuxu Riòre Hãbutyhyhykỹ. Itxeòtyre‑ki arỹikre tai arurukre. Inataõ txu‑di tahe rubu‑ribi arexixakre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tahe hãwyy irybe‑di rõhõtinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wabede‑ribi raijaranyrenyre Jesuisi erydỹỹna mahãdu‑ò ijyymy. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kia tiibohore: —Marie Madalena, Joana, Marie Txiause. Ijõ hãwyy tule tii‑wana roirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Iu tamy relyyreu, rityhynyõlerenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro tahe rỹimy reare idi raijaranyre wabede‑ò. Urile tykylemy robire tahe dòòsede, rexiòtiinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Itxuleu ta iny inatxi hãbu Jesuisi tyhydỹỹdu mahãdu tahe roirenyre Emau hãwã‑ò. Jerusalẽ hãwã‑ribi txibo 10 km wese irehere. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ibutumy aõhebo rotỹỹnyramy wiko relyymy ròimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iuleta Jesuisi tamyreny dehemynyde idi tiiboho‑wana roire. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tiiboho tuu robirehãre timykibo rierykõhykyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tahe Jesuisi ròtỹỹraxire: —Aõmywe widee tarybetenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Iijõreny Klopamy nidu narybede: —Kai sohojilewe Jerusalẽ‑ki aõhebo bede rỹira teerykõte. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tii dotỹỹraxide: —Aõherabo ta. Tiiboho tuu relyyre: —Jesuisi Nazare ludu kie. Tii Deuxumy rybedu nihikỹ heka rare, Deuxu‑ò dori ibutu iny‑ò heka rybe‑ki aõni heka aõmywidỹỹ‑ki heka ihỹỹna rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Waxiwenareny wahidỹỹdu wedu tahe wadinodureny itxeò nihikỹ‑ò rurukremy riwahinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tule judeu mahãdu tarasadukresỹna raholarenyre. Ihãreta tukõlemyta inataõ txumy rubu‑ki bede idi rỹira. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bederarasò‑di waijoireny hãwyyõ ihãloo‑ò roire. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tai itxi rekoaõhyyre. Dòòsedenydeki tahe Ỹjumy riki robirenyremy delyydenyde. Tii Jesuisi rubu‑ribi rexixamy tamyreny rarybere riki. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Waijoirenyõ tule ihãloo‑ò roirenyre. Inatyhy rikihe rare. Urileta riki Jesuisimy robiõrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tahe Jesuisi tyhy Klopaboho‑ò narybede: —Aõherewexe Deuxu Rybedu mahãdu rybe awo‑ki teximytenyteri tetyhynykõtenyteriki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kialemy dori Kristu dori aõna aõnamy rotỹỹnykremy tai Deuxu riwowydynykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tahe Jesuisi rexidelenyre aõbo rybe ritina roiremy. Moisesi ryberiti juhuumy ritỹnynynyre. Timybo Deuxu rybe ritidỹỹdu raremy. Tiiemy heka iximyhyyle rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ibutumy tamy relyyhyyre ramyhỹrehyy tahe ritehemyny Emau hãwã‑ò, tai inatxi hãbu rarikreò wahe. Tahe Jesuisi rarybere: —Aõkõ arexinoranykre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tai ta tamy ihãrele rarybemyhỹre: —Txioinihe bodonyke kakile. Aõma bede ratxinyra ratxioronytyhyra. Taile tiiboho‑wana rare ihetoreny‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Rorukurenyre riroxirenykremy. Tahe Jesuisi orotxu rimyre rexitòenyre Deuxu‑ò. Tahe orotxu riororiorore imynareny. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Iu tahe aõwesele rierymy reare Jesuisi. Tai iruereny raraymy rieryrenyre. Tahe aõwesele iõmy iribi reny reare. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tai widee raryberenyre kiamy. Iu tii Ryberitimy inydeereny rydi relyyreu, urile wawo ratooteemy. Kai tahe. Ijõ diwyònyde: —Kohe jiarỹ tulere. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Iribi tahe ritamanyrenyre. Diòòsedenyde ixyby Jerusalẽ hãwã‑ò. Tiu waòsohoji reurò erydỹỹna itxi rekoarenyreu. Tai tiiboho narybedenyde: ");
INSERT INTO kpjNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Inynyrỹrenyhe rexixara. Pedro heka tuu robira: ");
INSERT INTO kpjNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","—Jiarỹboho tulerenyra wawanale ròirenyra rydi. Tule wadeereny orotxu riyreyrenyra. Taile reeryrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Iu kiamy relyymyhỹrele, Jesuisi dehemynymy deade ityareny‑txi. Riryberenyre ibutumy: —Ywina heka akirenyke! ");
INSERT INTO kpjNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ibutumy ruberurenyre ilau. Urile raresỹny tamy raholarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesuisi rarybere: —Aõhebo taberutenyteri. Breburenyõmyke hewa biwatyhynybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jiarỹle ratxireri. Wadebò‑di bedetehebedenyke, wawa‑ò tule. Jiarỹ karare wadee inihe bideribedeny. Jiarỹ uni aõkõ watxireri. Uni dori idedire aõkõ wawese aõkõre bedetehebedeny inihe. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tai tahe tebò wotõ mona, tawa wotõmona, riteòsinyre tamyreny. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ihãrele tahe rityhynyrenyõre, ibedesamy bede riòtiinymyhỹreny. Jesuisi tahe rexitòenyre tamyreny aõ rirỹsỹkemy. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tamy riwahinyrenyre utura wòsi deyreõ. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Rirasỹre ikorenyòle. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Idi tamyreny rarybere: —Aõma wawanale ratximahãre, õhõtireny itxi reara. Aõma wawana atximahãtenyte juhuu. Ibutumy heka adeereny retỹnynymy rarybere aõmybo wamy rybe roimyhỹremy. Ibutumy heka Moisesi rybedu ritidỹỹnaki iritina‑ki roimyhỹre. Wiuna tule wamy riritinyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tai tahe ritỹnynyre òbitimy irakyreny riraynyre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ihetxiu rybe wãhã aõma Deuxu Deòdỹỹna rurukre heka aõhõkỹmy rotỹỹnykremy. Ruru‑ribi inataõ txu‑di rexixakremy bede roire. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kaa rybe wihikỹ ritidỹỹna heka kaa Jerusalẽ bede‑ki robỹtỹkre ihãreta ibutumy iny iny kõkõmy bede bedemy robỹtỹkre. Kiamy heka ibutumy inydee marybebenykre. Iny riwatyhynymy rỹirakre heka ibutumy iòraru‑ribi ariixãwididỹỹnyke. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tule terytenyteri ibutumy aõhebo rotỹỹnykremy. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tahe adee ariwahinykre iwese Deuxu rarybere wesemy heka adee ariwahinykre. Kaki hewa matxibenykre hãwã‑ki. Tahe kanakre heka adee ruruõ biu‑ribi. Iribi tahe bòhònykre karibi. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iribi tahe Jesuisi ridyrenyre Betỹniary‑ò. Tai tahe rilàhànanyrenyre tuu tamy rexitònyrenyre ibutumy tamyreny. Tamy rexitòenyreu heka ilàhànamy tamy rexitòenyre biutxile ire rexidymy ramyhỹre rynanamy ramyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iu rilàhànanymyhỹrenyu, biu‑ò rare. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tamy rexitòenyra aõma làhànamy, wowydynamy rexitòenymyhỹre Deuxu‑ò. Tai riwowydynymyhỹreny. Teysa‑di diòkesedenyde Jerusalẽ‑ò ixyby. ");
INSERT INTO kpjNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tai tahe Deuxu dohodỹỹna heto‑ki ixyby ixyby rowowydynanymyhỹrenyre.");
INSERT INTO kpjNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Ibutu aõna aõnakõu, Jesuisi rarehyymy raremyhỹ. Tii rybehyymy raninira. Tii Deuxu‑wana ihỹre. Ihãre tahe tii Deuxule rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tii ibutuhukỹlemy riwinyre. Tiiõhyykeki tahe, aõ releõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Umytuedeõna wahidỹỹdu tii ihỹre kia‑di iny mahãdu rayky ritoosònymyhỹre ritỹnynymyhỹre wahe. Kia loosòna heka bede luru ludu loosòna rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Bede luru tỹnyna loosòna rare. Loosòna ròtamyhỹre, bede luru tahe ròanodỹỹmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Deuxu teòduõ diteònyde, Joaõ inire. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tii loosònamy rarybekremy nade. Kia rybe‑di roholamyhỹreki, ibutumy iny rityhynyrenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Joaõ loosòna aõkõ rare. Urile tuu rarybekemy nade. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jesuisile loosònatyhy rare. Tii bede‑ò nadeu, ibutumy iny rayky ritoosònyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tii bede‑ki raremyhỹ, bede widỹỹdu rare, ihãre tahe iny rieryõhyyre mobo tii ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tasỹ mahãdu‑ò dehemynyde, judeu mahãdu‑ò wahe. Ihãre tahe ridyõhyyre, rityhynyõhyyre urile teramy reare. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Iu inyõ Jesuisi rityhynymy ridyreu. Deuxu riòreõlemy risỹdỹỹnyre inimy rityhynyreki. Kia‑ò tahe ruru tamy riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kia ityhydỹỹdu tahe Deuxudeewilemy tule iriòreõmy roirekemy. Hãlubu‑ribi aõkõ ratybienyre, urariribike aõkõ, hãbudeewike aõkõ. Deuxudeewilemy iny ihỹmyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Rybe tahe umyõ rimyre, demy rexiijenyre, inyyreny‑ki rasỹnymyhỹre. Tii tỹxihikỹlemy Deuxu loosòna‑di ratximyhỹre, ruxetòena‑di inatyhyna‑di nade. Inyboho tuu robirenyre. Deuxu Riòre delamy ratximyhỹre, sohojihyyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Joaõ Jesuisimy rarybere kia wese: —Kiamy heka adeereny rarybere. Tii wahewomy kanakre heka waratyre awityhyre. Tii dori wako‑ki rarehyymyhỹ waribi juhuutyhy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Inyboho dori sõwemy ruxetòena iribi ritarenyre. Luuna sõwetyhymy tawo‑ribi Jesuisi inydeereny diwahinyde. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Deuxu bede ywina tahe Moisesi òraru‑ki nade inydeereny. Ruxetòenamy tahe inatyhyna Jesuisi Kristu òraru‑ki nade. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Inyõ heka tiu Deuxumy robiõtyhy. Deuxuriòre delale heka itỹnydỹỹdu rare. Tuunatyhy‑di taãxiòti‑ki rimyre. Tiile iny‑ò Deuxu ditỹnynyde. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judeu mahãdu Jerusalẽ‑ribi xiwena wahidỹỹdu mahãduõ diteònyde Joaõ dỹỹraxidỹỹmy. Levita mahãduõ tule diteònyde. Tahe roirenyre ritỹỹraxinykemy mobo tii raremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tahe Joaõ‑ò rỹỹraxirenyre aõhereriwe mobo atxiteri. Joaõ dirawyònyde inatyhymy rexitxiõnyreri: —Jiarỹ Kristu Deuxu deòdỹỹna aõkõ jiarỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tai tahe ixityre tamy rarybere: —Mobo tahe atxiteri, Elia aõbo. Aõkõre, Joaõ rarybere. Tahe Deuxu dee rybedu atxiteri inyboho riraòrenyreriõ wahe? Joaõ rarybere aõkõremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tamy tahe ixityre raryberenyre: —Wakoreny bedelyyke mobo atxiterimy. Tai iny deòdỹỹdu mahãdu‑ò arelyyrenykre. Aõmybo iximy manarybeke? ");
INSERT INTO kpjNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tahe Joaõ rarybere: —Jiarỹ Isaia Deuxumy rybedu wesele adeereny ararybekre. Jiarỹ rybeterenaduõ jiarỹ rare. Jiarỹ bederahy‑ki iny‑ò rarywãhã. Inynyrỹ‑ò ryõ biòbitinyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Fariseu mahãdu‑ribi kia mahãdu roirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tai tamy rarybere: —Kai Kristu aõbo tate? —Aõkõre. Elia aõbo? —Aõkõre. Deuxu dee rybedu aõbo? —Aõkõre. —Aõhereki tahaka iny teratysebenyteri? ");
INSERT INTO kpjNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Joaõ dirawyònyde: —Jiarỹ bedi iny reratysebenyreri. Inyõ tahe ayrenykile ratxireri. Tii tahe teeryõmahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tii wahewo‑ribi kanakre. Jiarỹ raixỹrumy watxireri iwataana ese‑ki, tii waratyrereki. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kia ibutumy aõhebo rotỹỹnyre Betỹnia hãwã bede‑ki. Jordaõ bero kowa weribi ijà‑ki ihỹre. Tai iule Joaõ iny riratysybenymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Txubiòwau tahe Jesuisi Joaõ‑ò kedehemynykemy nade. Tahe rarybere: —Beteheke, kowa Deuxu budoeni naderi. Tii òraru‑ribi iny ritakremynade. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tuu jiarỹ rarybereu, inyõ wahewomy kanakre. Tii waratyre awityhy rare. Tii dori wako‑ki rarehyymyhỹ waribi juhuure. Kia rarybereu tule jiarỹ tuurarybemahã. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Reeryõre heka tii, ihãre tahe anade tii aritỹnykemy judeu mahãdu‑ò. Tai tahe anade iny bedi reratysebenymahãremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tahe Joaõ tamyreny relyyre: —Jiarỹ Deuxu Tyytybytyhymy rabire tamy dobehede‑ò. Bòtòe wesemy ityre‑ò desede. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Deuxu riwateònyre bedi iny ariratysebenykemy. Tahe riwateònyreu tahe wadee rarybere: —Aõmy kai bobikre? Deuxu Tyytybytyhy ronymy resekele inyõtyre‑ò. Tii sohojile tahe Deuxu Tyytybytyhy‑di iny riratysebenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jiarỹ tuu rabire, tai tahe reeryre, tule taheka relyywãhãre, tii inatyhymy Deuxu Riòre raremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Itxubiòwau tahe Joaõ taerydỹỹna inatxiõ‑wana raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tahe Jesuisi nadeò tuu robire. Tahe tamahãdu‑ò rarybere: —Kowa tahe Deuxu Budoeni naderi. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kia rybe‑ò tiiboho roholareu, tahe ròirenyre Jesuisi riheludunyrenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesuisi tahe tuu robire ihemy roirerimy. Tahe tamyreny rarybere: —Aõbo teijetenyteri. Tahe dirawyònyde: —Rabi (kia rybe tahe irybereny‑ki, erydỹỹdu rare), titxibo kai tasỹnymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesuisi rirawyònyre: —Bòdòibedenyke betehebenykemy. Tahe tii‑wana roirenyre, tamy reteherenyre. Tahe txioromy tii‑wana ihỹmyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Joaõ rybe‑ò ijohonaduõ, Jesuisi helududỹỹduõ, Andre rare. Tii Simaõ Pedro seriòre rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andre tahe taseriòre Simaõ aõwesele rioryre. Tahe tamy rarybere: —Mesia‑ki inyboho rahamy ratximyhỹrenyre. (Ka rybe, Mesia, heka. Kristumy rare, Deuxu deòdỹỹna rare.) ");
INSERT INTO kpjNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tahe Andre Jesuisi‑ò Simaõ didyde. Jesuisi Simaõ‑ò retehere urihimyò idi tamy rarybere: —Kai Simaõ tate, Joaõ riòrere. Iribi tahe ani Sefamy rarekre (Kani heka Pedro rare.) ");
INSERT INTO kpjNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Itxubiòwau Jesuisi Kalileia‑ò rakremy ixi‑di rõhõtinyre. Tahe Filipi riijere. Tamy rarybere: —Wahemy manakekõ aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Filipi tahe Besaida hãwã luduõ rare Pedro, Andre‑wana ihãwãluduõle rare.) ");
INSERT INTO kpjNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi tahe Natanaeli witxi reare. Tamy rarybere: —Moisesi bede ywina tyyriti‑ki inyõmy rarybere: —Tule Deuxu dee rybedu tyyriti‑ki rarybere. Taile rahare. Jesuisi ihỹre. Nazare hãwã luduõ rare. Jyje riòre rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tahe Natanaeli ritỹỹraxinyre: —Aõwihikỹ aõkàbo Nazare hãwã‑ribi kadòhònykre. Filipi rirawyònyre: —Manake betehekemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesuisi Natanaelimy robire naderimy tahe tuu rarybere: —Kowa judeu mahãduõ inatyhy rare. Tii hãbu òbiti rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tahe Natanaeli rarybere: —Timykibo tiwaeryteri. Jesuisi rirawyònyre: —Figueira òra‑ki tanyteò, umy rabire. Filipi aòrysymy raõreule, umy rabire. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaeli rimasajuamy rirawyònyre: —Kai Deuxu Riòre tate Inyerydỹỹdu tate. Kai judeu mahãdu Iòlò tate. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jiarỹ adee rarybera: —Figueiraòra‑ki umy rabireki. Kiakile aõbo, tiwatyhynyteri. Iratyre aõna aõna wiwihikỹ adee ariteòsinykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Inatyhytyhymy adee araybekre: —Biuwetyy riranykre. Jiarỹ biuloosòna hãbu jiarỹ rare. Ỹjuboho Deuxu‑ribi wadee doideò kai bobikre. Idi waribi roireò bobikre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Inataõ txu‑di tỹmyra herina txumy reare. Kana hãwã‑ki Kalileia bede‑ki. Jesuisise tai ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesuisi tule ritobinyre tamy rakremy taerydỹỹna mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Lisinaube tya‑ki vĩĩ mona ituere. Tai Jesuisise Jesuisi‑ò rarybere: —Vĩĩ mona ituere, imona kõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesuisi rarybere: —Nadi, aõhebo arotỹỹnykre. Aõka wawidỹỹkõna wabededỹỹnanamy aõkõka bede rỹireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tahe Jesuisise deòdu mahãdu‑ò rarybere: —Anowidỹkỹmy adekereny tiki rarybekeki, ibutumy biwinybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Debòsohoji reurò mana butxi nihikỹ tai rỹimyhỹ judeu mahãdu ibe‑di brebu òraru‑ki aõna aõna risuhòmyhỹre worana bedehesinau. Mana butxi sohoji sohoji 80 urihixina ratyre rimyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesuisi tamyreny rarybere: —Ibutumy bedi bitỹxinybenyke. Tahe ibutumy ijà ratyre ritỹxinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Katahe iribi bitake. Worana bedehesi wedu‑ò biwybenyke imona. Tahe riwyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kia bee heka Jesuisi riwitxiranyre vĩĩ monamy. Tahe iwedu riurihire, rieryõre tiribibo nade. Deòdu tahe rieryre juhuu bee rare. Tahe iwedu rarybere weryrybò heridu‑ò: ");
INSERT INTO kpjNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Katahe awityhyre. Kai ijõ‑ribi iwitxiratyhymy tewinyteri. Ijõ iny heka awityhy iko‑ò ritxiwimyhỹ. Ihewomy tahe awiriòre ritxiwimyhỹre. Kai tahe awityhy ikonana‑ò teyrubunyta. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Katahe aõna aõna wiwihikỹ iny itxerenamy juhu ludu rare. Kana hãwã‑ki Kalileia bede‑ki ihỹre. Tii tarurutere riteòsinymyhỹre taerydỹỹna mahãdu‑ò. Tai ierydỹỹna mahãdu rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Iribi tahe Kafanaõ hãwã‑ò Jesuisi dobehede tadi, taseriòre, taerydỹỹna mahãdu tii‑wana roirenyre. Ijõtxumy tahe tai bede tỹnyna rỹira. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascoa worana bedehesi iòhòmy rỹireu, Jerusalẽ rotuore kia tahe judeu mahãdu worana bedehesina rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tai Jesuisi Deuxu dohodỹỹna hetowo‑ò ralore. Tahe iwo‑ki itxi reare sõwemy aõna aõna‑di rohonyreriò, broreni‑di ijohodu‑txi, budoeni‑di ijohodu‑txi, bòtòe‑di ijohodu‑txi, tule nieru witxira witxira wibydỹỹdu mahãdu‑txi reare tai ronymyhỹki. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesuisi reroti awaru hãtena wesemy riwinyre. Idi tahe dohodỹỹna hetowo‑ribi ibutumy riòlòdỹỹre, budoeni, broreni‑wana, tahe nieru wibydỹỹdu mahãdu oworubesedỹỹ‑di Jesuisi rehure, tai nieru rejuxunyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tahe rare bòtòe‑di ijohodu‑ò. Tamy rarybere: —Biòlòdỹỹnyke wa. Waha heto dori aõ‑di ijohona aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tahe Jesuisi erydỹỹna mahãdu tõhõti‑txi reare aõbo Deuxu Tyyriti‑ki roiretxi: —Waha heto yrubudỹỹna‑ki dori riwasamyhỹre. Ariyrubunykemy dori watxireri, tai riwasareri. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judeu mahãdu Jesuisi‑ò rỹỹraxire: —Aõherekibo kai teòlòdỹỹnyteri. Mobo he arateranyreri tuu biwinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tahe Jesuisi rirawyònyre: —Deuxusỹ‑di behuke tahe inataõ txu‑di aditamadỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tahe judeu mahãdu rarybere: —Ka heto 46 beòra‑di relere, timykibo kai inatãõ txu‑di biwinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesuisi tahe Deuxusỹmy taumylemy rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iribi tahe iu rubu‑ribi iixixana‑txi tõhõtireny reare, kia tuu rarybere‑txi. Tai heka iritina rityhynyre, tule Jesuisi rybe rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jerusalẽ‑ki Jesuisi Pascoa worana bedehesidỹỹna riwyre. Aõna aõna wiwihikỹ inyy‑ki ritxienyre riwinyre. Tai sõwemy iny inityhy rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesuisi tahe urihimyòle iny rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tii dori ibutumy iny rayky rierymyhỹre. Inyõ timy iny raremy tiu tamy aõna relyyõtyhy tii ibutumy aõerydu rareki. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nikodema fariseu mahãduõ rare. Tii judeu mahãdu weduõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tii rudimy Jesuisi roramy rara. Tahe tamy rarybere: —Wanyrỹ, reeryrenyre kai Deuxu‑ribi erydỹỹdu tate. Inyõ Deuxu‑diõkeki tii aõ wiwihikỹ riwinyõtyhy. Iwese aõ wiwihikỹ kai tewinyte wese. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tahe Jesuisi rirawyònyre: —Inatyhytyhymy adee ararybekre: —Inyõ ixityre reakõkeki, tiu Deuxu Òlònasỹmy robiõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodema rỹỹraxire: —Timykibo matuari ixityre reakemy. Timyrabo, ixyby tadiwo‑ò iny ralòkeki aõbo ixyby iny raumynyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tahe Jesuisi rirawyònyre. Inatyhytyhymy rarybere. Inyõ bera‑ribi ratybienyõkeki Deuxu Tyytybytyhy‑ribi ratybienyõkeki, tiu ralòõtyhy Deuxu Òlòna‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Deribi tybie heka dee rare. Deuxu Tyytybytyhy‑ribi tybie tasỹ tyytyby rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Idi wanaòtaõmy aõmybo rarybereridi ixityre ijiranamy. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tiò tiò yhy ribonymyhỹre: —Iwodỹỹ taholate, tahe tiribibo namyhỹde teeryõmahãte tiòhe ramyhỹre teeryõte, kia wesele iny Deuxu Tyytybytyhy‑ribi tybie iny rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tahe Nikodema rỹỹraxire: —Timyrebohe kia ratxike. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesuisi dirawyònyde: —Kai judeu bede erysydỹỹdu tate ihãrele teeryõte aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Inatyhytyhymy adee rarybere aõmybo reeryre, aõmybo rabire. Ihãrele tahe kia tetyhynyõte. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Bede aõmydỹỹnanamy rarybere tahe tetyhynyõte. Timybo bityhynyke biu aõmydỹỹnanamy ararybekeki. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Iny sohojile biu‑ò raòwònyre, Deuxu Riòre Hãbutyhyhykỹ rare. Tiile iribi juhu dobehede. (Tiile isỹre. Taile isỹ roire.) ");
INSERT INTO kpjNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Iwese Moisesi bederahy‑ki womati hemylala ritamadỹỹnyre wese, Kiawesele jiarỹ, Deuxu Riòre Hãbutyhyhykỹ, wadi kidiwatamadỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Tahe inyõ wadi rityhynykeki, umytuedeòna tuu ritamy rỹihyy rakre. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Deuxu Riòre sohojihyyle rare. Deuxu bede ludu mahãdu ibutumy iluutyhyre. Tai tahe tariòre diteònyde iny rityhynykremy. Inyõ tii rityhynyre‑wana, umytueõnahakỹ ritakre. Tii ruruõtyhy rubu bina bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Deuxu taRiòre bede‑ò diteònyde bede iny mahãdu tarasadumy rarekemy. Aõ iny ywisidỹỹna‑ò rirutykemy aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Inyõ rityhynymyhỹreki, tii ywisidỹỹdu idi rehuõtyhy. Iny rityhynyõmyhỹreki tiihe aõhõkỹmy dỹỹnana‑txi riteònykremy Deuxu idi ratximyhỹre, tii dori Jesuisi rityhynyõhyymyhỹre, Deuxu Riòre dela wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ibinatyhymy iny aõmydỹỹnana bede bedemy rỹira, tai bede luru‑ki rira tamy awira. Tuu loosòna nadeu, tamy ibinare. Tai tahe Deuxu riteònykemy idi ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Inyõ aõbinahakỹ rotỹỹnymyhỹre, loosòna dera heka tuu rỹira; loosòna‑ò rehemynyõtyhy, rehemynyre‑wana, iny taaõbina bina rierymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Iny tahe awiwihikỹle rotỹỹnymyhỹre‑wana tii tahe loosòna‑ò rehemynykremy rỹira, taaõmydỹỹnana dori Deuxudeewimy ririmyhỹre, ibutu iny rierykremy ririre. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Iribi tahe Jesuisi taerydỹỹna mahãdu‑wana Judeia bede‑ò ròirenyre. Tai heka bededỹỹnanaõ riwyre. Tiiboho iny ityhydỹỹdu mahãduõ tai riratysebenyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Joaõ iribi iòhòmy ratxireri. Iny riratysebenymyhỹre. Tii Eno hãwã‑ki Salĩ hãwã‑ribi iòhòmy roire. Tai riratysebenyre sõwemy bee tai roimyhỹreki. Sõwemy iny tamy ratysebenymy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Joaõ iu rotenamy ralòõlemy ratximyhỹ.) ");
INSERT INTO kpjNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Judeu mahãduõ, Joaõ erydỹỹna mahãdu‑wana rybetere txiõdỹỹna ròhònyra, bede ywina òbiti aõmydỹỹnanamy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tahe Joaõ erydỹỹna Joaõ‑ò doidenyde rarybekremy: —Waerydỹỹdureny. Kai hãbumy telyymy tatemahã, kia Jordaõ kanawe‑ribi ijà‑ki umy‑wana raremyhỹ, tii ròratysebenyreri. Sõwemy iny tamy wirotyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tahe Joaõ tamy rarybere: —Kia wadee awire aõ aõkõ iny ritamyhỹre, biu‑ribi kanakekile tahe iny aõ ritake. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jiarỹ heka Jesuisi nonanamy ijyymy diwateònyde wahewo‑ribi kanakremy. Jiarỹ tii aõkõ rare. Tii tahe Kristu tyhy rare. Jiarỹ kiamy juhuu rarybewãhãre: —Kia tahe teerytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Inatyhymy tahe hãbumy heridu wesemy Jesuisi rare. Ibutumy iny tuu robikemy tamy wiirotyre. Ibiòwa weselemy jiarỹ rare. Tahe irybe‑ò raholareu, reysamy rarewãhã. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tai wadee awire iny tii rieryreki, waribi tahe nohõti rosakemy idi watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Tii biujuxahakỹ‑ribi nadeki ibutu ratyremy ratximyhỹre. Bede‑ribi jiarỹ anadeki, tahe bede ludu jiarỹ rare, bede aõmydỹỹnanamy rarybewãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tii rarybere aõmybo roholare, robire, tahe ijõ iny rityhynyõhyyre irybe. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Inyõ tahe rityhynykeki, tii tule ijõ‑ò rarybere, Deuxu inatyhy rare wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Deuxu deòdỹỹna heka irybelemy rarybere Deuxu dori Tatyytybytyhy ibutumy tamy diwahinyde. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tyby taRiòre luure, tai tahe ibutu aõmydỹỹnana ywisidỹỹmy tamy diwahinymy diteònyde. ");
INSERT INTO kpjNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Iny Jesuisi rityhynymyhỹreki, umytuedeònahakỹ‑di iny rỹira. Inyõ tamy ratxiõkeki, tiu umytuedeõna robiõtyhy, Deuxu ykarana dori tii‑wana ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","4","Inyõ fariseu mahãdu‑ò rarybere: —Jesuisi Joaõ‑ribi iny sõwemy diratysebenymyhỹde. Sõwemy iny ritamyhỹre ierydỹỹmy. Tahe Jesuisi aõkõ ròratysebedỹỹmyhỹre, ierydỹỹnale tahe riratysebenymyhỹre. Iu Jesuisi kiamy rieryreu tahe, Judeia‑ribi rexitare. Roirenyre Kalileia bede‑ò ritehemynykemy. Roirenyreu tahe Samaria bededihyyle riòhòrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria bede hãwãõ‑ò tahe ritehemynyre. Sika inire. Ijaò riòresu‑ribi iòhòmy ròira, tariòre Jyje‑ò riwahinyre wahe. Ijaò behãloo tai rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Txutyeu tahe Jesuisi elerihynymy ronymyhỹ tatilemy nadeki berysyna werora‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tahe Samaria mahãdu hãwyyõ dobehede beitxemy. Jesuisi tamy rarybere: —Beõ inihe wadee bidiõke. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Jesuisi erydỹỹna mahãdu tahe juhuu roirenyre hãwã‑ò rỹsỹna itxemy. Tai Jesuisi riraòmy ronymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tahe hãwyy rarybere: —Kai judeu mahãdu tate, jikarỹ samaria mahãdu rare. Anoherekibo wadeke texitòenyteri bemomomy. (Judeu mahãdu Samaria mahãdu‑wana wiymy reaõhyymyhỹre. Widi òludu wesemy rare.) ");
INSERT INTO kpjNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tahe Jesuisi rirawyònyre: —Kai heka teeryõhyyteri mobo jiarỹ rare wahe. Tule, Deuxu wahisidỹỹna teeryõte. Tiwaeryteriwana kai bedexitòenyke, tahe bee irumy ihỹre adee ariwahinyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hãwyy rarybere: —Wahĩ, timybo bee irumy ihỹre wadeke kanakre. Kai ahynakõre, hãloko heka behekỹre bee irehere. Timybo bee iru kumy‑wana ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kai anobohe inytyby Ijaò ratyrere. Tiki heka behãloko wedu juhuku rare; idi riwahinyre inydekereny. Iribile iritxiòre riõmyhỹre tiki‑wana, ibroreni riõmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesuisi tahe tarybetyhy‑di rarybere: —Inyõ kahãloobemy riõkeki, ixityre bemomomy ruruke. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jiarỹ bee ariwahinyke. Inyõ tahe kiabemy riõke‑wana, tiu bemy tamy umytuedeõnahakỹ riwahinyhyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tahe hãwyy rarybere: —Wahĩ bee tuedekõdu ikuny tuu kariõke. Tai kakò kanakõtyhy berysymy. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tahe Jesuisi rarybere: —Maa hỹny, ahãbu biòryke, tahe manake. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Hãwyy dirawyònyde: —Anokõre, wahãbukõre. Jesuisi rarybere: —Inatyhymy tarybeteri ahãbuõremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kai heka iruyre ahãbu tate. Wijina tahe ahãbu aõkõ rare atỹhibiòwale wahe. Kia tahe inatyhymy tarybeteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wahĩ, wiji tahe arakeryra, kai Deuxu rybeduõ tate. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wahareny Deuxumy reàlàmyhỹre kahãwãlò‑ki. Amahãdu anokõ, tamy tahe Jerusalẽ Deuxu deàlàna rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tahe Jesuisi rarybere: —Lerỹ, warybe bityhynyke. Kanakre itxu kahãwãlò‑ki aõkõ, Jerusalẽ‑ki aõkõ Waha Deuxu deàlàna rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kaiboho aõmybo teàlàte teeryõtenyte. Jiarỹboho tahe aõmybo reàlàre, reeryrenyre, tarasana dori judeu mahãdu‑ribi nade. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kia bededỹỹnanamy reara. Inyõ Waha Deuxu àlànamy ratximyhỹreki Deuxu Tyytybytyhy‑di, inatyhyna‑di reàlàmyhỹke. Tuu deàlàna mahãdu Deuxu riijemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Deuxu Tyytyby rare: —Tai tahe tudeàlànadu tatyytyby‑ki inatyhyna‑ki tuu reàlàmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kia tahe jikarỹ rekeryre, Mesia kanakre, Deuxu dekòdỹkỹnamy wahe, Kristu inire. Tiki kanakreku wahe, ibutumy inydekereny anona anonamy relykykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesuisi rarybere: —Jiarỹ tahe tiire, umy‑wana wiji rarybereri wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tahe Jesuisi erydỹỹna mahãdu rehemynyre. Hãwyy‑wana rarybereriki tahe ribedeòtiidỹỹnyrenyre. Tahe inyõ tamy rỹỹraxiõhyyre. Aõmybo tamy rỹỹraxire, ada aõherekibo tamy rarybereriki. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Iu tahe hãwyy tabutxi ririre, hãwã‑ò rara. Tahe tahãwã mahãdu‑ò rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Bodoibedenyke wahemy. Betehebenykemy hãbu‑kò. Tiki wakoku relykyre ibutumy anohebo ratỹkỹnymahãremy. Tiki kòsana Kristu ratxireri. Deuxu dekòdỹkỹna rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hãwã‑ribi roirenyre Jesuisi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Iu hãwyy hãwã‑ki rareamyhỹreu, tahe ierydỹỹna Jesuisi‑ò rarybere: —Iny erydỹỹdureny rỹsỹnaõ birỹsỹke. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tahe Jesuisi rarybere: —Warỹsỹnadire wahe. Kaiboho heka kia rỹsỹna teeryõtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tahe widee raryberenyre: —Inyõ kõaõboka tamy rỹsỹnaõ riwyreri. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesuisi rarybere: —Wadeòdỹỹdu deewimy ariwinykemy idi watxireri. Kia tahe warỹsỹnare, iaõmysỹdỹỹna arihukemy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Maixõmo butuna inaubiòwa ahãdu‑di bidiòrarunybenykremy kaiboho tahõtinytenyteri. Tahe aõkõre adeereny ararybekre. Betehebenyke bedero‑ò. Maixõmo redenamy rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kia maixõmo butudỹỹdu iòwy ritake, tahe umytuedeõnahakỹ‑ò iny ributunyre. Tahe wiwanale riwodeysanymyhỹre ibròdỹỹdu ibutudỹỹdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Iwese inyõ rarybere wese, inatyhy rare. Ijõ tahe ibòròdỹỹdu rare. Iwitxira tahe ibutudỹỹna rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jiarỹ kaiboho arateònymahãre. Aõbo tebòrònyõtenyte tahe bibutunyke. Juhuu inyõ raaõmysỹdỹỹre: —Kaiboho tahe iraty temytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tahe hãwyy òraru‑ki sõwemy Samaria hãwã mahãdu rityhynyre. Hãwyy rarybere juhuu: —Tiki wakoku relykyre ibutumy anohebo ratỹkỹnymahãre walananonanamy relykyre. Kia rybe òraru‑ki tahe rityhynyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaria hãwã mahãdu tahe Jesuisi‑ò rexitòenyre tii‑wana roirekemy. Tahe Jesuisi tii‑wana inatxi txumy riwyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sõwemy tahe rityhynyre Jesuisi Rybe òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tahe hãwyy‑ò rarybere. Wiji tahe arybe òraru‑ki aõkõ retyhynyreri. Tamy tyhy‑ò jiarỹle raholare, tahe reeryre tii bede iny tarasadu tyhymy raremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Inatxitxu‑di tahe Samaria‑ribi rare Kalileia bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesuisile dori rarybere: —Deuxu rybeduõ uladumy ijirana bede‑ki iny rityhynyõhyymyhỹ. Tiu tamy wowydynaõ riwahinyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kalileia mahãdu juhuu Jerusalẽ‑ò tule roirenyre, worana bedehesi rỹimyhỹraò. Ibutumy aõbo Jesuisi riwinyra heka tiiboho reteherenyre. Tai Jesuisi tasubede‑ò rehemynyre tiiboho awimy ridyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tahe ixityre Jesuisi rehemynyre Kana hãwã‑ò. Juhuu tai bee riwitxiranyre vĩĩ monamy wahe. Bede dinodu aõmysỹdỹỹdu Kafanaõ‑ki rasỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jesuisi Kana hãwã‑ki ratxirerimy hãbu roholareu, tamy rara. Tariòre dori ibinamy roire taheto‑ki. Jesuisi‑ò hãbu rarybere: —Manakekõ aõbo waheto‑ò wariòre biteytekemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesuisi rirawyònyre: —Kaiboho bede aõmydỹỹnana wiwihikỹ tetehetenyteule tetyhynytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Hãbu heka Jesuisi‑ò rarybere: —Wanyrỹ, wylemy manake wariòre rurukreko‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesuisi rarybere: —Bòòseke, ariòre dori awimy relera. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tahe tii Jesuisi rybe rityhynyra tai ròòsere taheto‑ò rakemy. Ijõ txu tahe ryro‑ki teòdu‑wana witxi reare. Tii rarybere: —Ariòre reytera ahetokile. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hãbu ritỹỹraxinyre tiubo reytera. Tahe relyyre. Kaule, txutyeu reytera. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jesuisi rarybereu, kiaule iriòre reytera. Hãbu rieryre. Tai tahe idi ibutumy hãbu sỹmahãdu Jesuisi rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kia tahe Jesuisi inatxina aõna aõna wiwihikỹ iny itxeranamy riwinyre Kalileia bede‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Iribi tahe judeu mahãdu worana bedehesimy rỹimyhỹ. Tai tahe Jesuisi rare Jerusalẽ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Hãwãy‑ki tahe hãloo ibedỹỹ roimyhỹ budoeni ryijò iòhò‑ki rỹimyhỹ. Beteta inire, hebraika rybe ini rare, judeu rybe wahe. Iruyre iwòtena ube iwerora‑ki rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Sõwemy webinadu ube‑ò wii rotyre, iny ruetà ijõre, iny tiere ijõre, inytibina ijõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tiiboho ỹjuõ riraòmyhỹre. Ỹju beò rerireu tahe raukỹre. Mobo juhu itxi resekeki tahe, tii reytemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hãbuõ 38 beòramy ibinamy roimy raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesuisi tamy retehereu, rieryre tiwesebeòrabo ibinamy roimy rare myhỹ. Tahe tamy rarybere: —Kai aõbohe beytekekõ. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hãbu dirawyònyde: —Aõkõre Wanyrỹ, wawiòhedỹỹduõre. Bee rexiukỹnyrau, ijõ wako‑ò ralòmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesuisi tamy rarybere: —Myikewa, abyre bimyke, mariake. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aõwesele hãbu rỹimy reare, awimy. Tabyre rimyre tahe rariare. Kia txu tahe sabado txu rare. Kia txu tahe judeu aõmysỹdỹỹna txu aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tai tahe judeu mahãduõ tamy rarybere: —Abyre‑di riraõmy, sabado txu dori òbiti aõkõ rareki. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tahe dirawyònyde: —Wadeytedỹỹdu wadee rarybere wabyre arimykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tahe tamy rỹỹraxire: —Mobo adee rarybere abyre bimykemy idi mariakemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tahe hãbu deytedu rieryõre mobo rare. Jesuisi dori dexitade iribi. Sõwemy iny tai rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Deuxu dohodỹỹna heto‑ki Jesuisi idi hãbu‑ki rahara. Tamy rarybere: —Kai teyteta, inatyhy. Tai tahe aòraruna biixãwidinyke, aõbinatyhy aõhe adee rotỹỹnyheny. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hãbu tahe rare. Judeu mahãdu‑ò rarybere, mobo teytedỹỹdu raremy, Jesuisi wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tai tahe judeu mahãdu Jesuisi ibinamy rexidelenymy rarybere, sabado txuu kia riwinyreki. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesuisi tahe rarybere tamyreny: —Waha, Deuxu aõu raaõmysỹdỹỹre, jiarỹ tulere. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tai tahe sõwemy irubudỹỹmy rurumyhỹre. Sabado txu bede ywina‑ribi tii riywinyõre. Tule Jesuisi Deuxu wesemy rexioire, Wahamy dori rarybemyhỹreki. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tai tahe Jesuisi tamyreny rarybere: —Jiarỹ ixi‑di aõkõ aõmydỹỹnanamy ratỹỹnymahãre aõbo Waha riwinymyhỹre, jiarỹ tule rewinywãhãre iweselemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Waha Deuxu dori waluure. Aõbo riwinyre wadee riteòsinyre, tai tahe aõruxerahakỹtyhymybo bobibenykre, idi bede biòtiinybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Waha Deuxu dori rubu‑ribi iny riixixanymyhỹre. Tai tule jiarỹ iny areixixanyke ixideewikeki. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ibutumy iny hitxidỹỹna Waha wadee tuu rarybera, tii dori iny rihitxidỹỹnyõtyhy. Jiarỹle tahe iny ywisidỹỹdumy aròhònykre, tai iwese Deuxu iny riwowydynymyhỹre wesele iny riwawowydynymyhỹkre. Adeereny Deuxu diwateònyde. Tai inyõ riwawowydynyõkeki, tii Deuxu riwowydynyõreri. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Inatyhytyhymy adeereny ararybekre. Inyõ warybe roholakeki, wateòdỹỹdu rityhynykeki, tii wijityhyle umytuedeõna ritake, ywisidỹỹduko‑ò ròhònyõtyhy, rubu ryribi ròhònyre umy irumy ihỹre ryò iny ralòmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Inatyhytyhymy adee arelyykre: —Bededỹỹnana‑ki kòhòra, bede dỹỹnanamy reara. Tahe rubu mahãdu Deuxu Riòre rybe‑ò roholakre. Roholamy rỹikeu tahe irumy rỹike. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tyby dori iumyõnanaõhyyre wese tule iRiòre rare. Umytuedeõna wedu rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","IRiòre heka hitxidỹỹna wedumy relere. Tii dori Deuxu Riòre Hãbutyhyhykỹ tii rare, jiarỹ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bedeòtiidỹỹõmy tahe bededỹỹnanamy he reare. Rubu mahãdu wabedey‑ki warybe‑ò roholakre, tai iribi ròhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ibutumy aõwibo riwinyre mahãdu kedexixakre umytuedeõnahakỹ‑di. Kia ibinamy riwinymyhỹre mahãdu ywisidỹỹdu‑ò rexixakre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jiarỹ ixi‑di aõkõ aõmydỹỹnanamy ratỹỹnywãhãre. Iwese Waha‑ò raholare wese iny ywisidỹỹmy aròhònykre. Waywisidỹỹna heka òbiti rare. Wadee wimy aõkõ dori tuu watxiwãhãre. Waha wadeòdudeewimy tuu watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Iximy ararybekeki, inyõ riwatyhynyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Iwitxira heka tuu rarybereri wamy wahe. Reeryre inatyhy raremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kaiboho inywitxira teteònytenyte. Joaõ ratysebedỹỹdu‑ò rỹỹraxikemy ibutumy kia wamy rarybere inatyhy rare jiarỹ inatyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iny wamy rarybemyhỹre, tahe jiarỹle kia reijeõhyymahãre inyle rieryõre wamy rybe, wahe. Tahe kiamy adee relyywãhãre kaiboho ritamy rỹikemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Joaõ tahe loosòna wesemy raremyhỹ. Tii urihimyò bededỹỹnana ritoosònymy raremyhỹwesemy tahe kaiboho atximahãtenyte. Idi urihimy‑ò teysatenyte iloosòna‑di, idi iribi kaiboho terarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jiarỹ Waha òraru‑ki aõmydỹỹnana wiwihikỹ, rewinymahãre. Kaheka inatyhymy urihixina rare. Joaõ wamy rarybere ratyre heka kaa roire, Deuxu Waha inatyhymy wadeòdu raremy riteòsinyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Waha wadeòdu wamy tule relyyre. Kaiboho irybe‑ò taholaõtenyte tule tii tabiõtenyta. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kaiboho tamy taholaõhyymahãtenyte, tiwatyhynyõteki, jiarỹ dori iteòdỹỹna rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tyyriti‑ò tetehetenyte iwo‑ki dori umytuedeõna‑ki mahakemy tahõtinytenyte. Ritidỹỹnakile wamy relyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ihãrele tahe wadee taõmahãte adeereny umytuedeòna ariwahinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Aõmybo wamy iny rarybemahãkeki, aõ aõkõ rare wadee, jiarỹ dori reeryre Deuxu luuna‑di aõkõ atxitenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Jiarỹ Wahani‑di anade, tahe kaiboho tiwatyhynyõmy wadi ahãte. Inyõ ixideewilemy kanakeki, kaiboho bityhynybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tai heka tetyhynyõmahãtenyte. Widee dori kaiboho tewowydynymahãtenyte, tahe Deuxu‑ribi wowydyna ritakemy terarenyre, sohojihyyre heka Deuxu. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kiamy tahe Waha‑ò arelyyõkre, Moisesi tahe relyykre. Moisesi bede ywina dori, araròsònyreny rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Inatyhymy Moisesi tetyhynymahãte‑wana tule jiarỹ biwatyhynymahãke, wamy dori Moisesi ròratidỹỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Irybe bityhynyõkeki, timybo warybe bityhynyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Iribi tahe Jesuisi Kalileia aho‑ki ixyby reurore, Teberiade ahoniõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tahe sõwemy iny riheludunyre tuu robireki, aõna aõna wiwihikỹ, deytedỹỹna wiwihikỹ robireki. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tahe hãwãlòratyy‑ò Jesuisi raòwònyre taerydỹỹna mahãdu‑wana —rorukurenyre tai. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Judeu mahãdu worana bedehesi rexidelenykemy iòhòre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Tahe Jesuisi retehere inysõwehekỹ‑ò, tamy rehemynyreriò. Tai Filipi‑ò riurihimy rarybere: —Tikibo orotxu tamyreny rikiõbranyke riyrenykemy. Jesuisi rierymyhỹre aõbo riwinykremy ratxireri ihãrele tahe Filipi‑ò kia rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi tahe dirawyònyde: —Inyõ sohoji sohoji orotxu yre sohoji riykeki, 200 prata womati nieru rakahurenyke ihãre rimyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andre Jesuisi erydỹỹna‑ò rare, Simaõ Pedro seriòre rare. Tii tahe Jesuisi‑ò rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Weryryboõ kaki ihỹmyhỹ. Iruyre cevada orotxu idi ratximyhỹ, utura inatxi. Kia tahe aõ aõkõ rare inysõwe‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tahe Jesuisi taerydỹỹna‑ò rarybere: —Tamy marybebenyke ranyrenykemy asityrekile. Tahe rorukurenyre ibutumy. Hãbu 5000 ronyre ijõ inyõ tahe sõwetyhymy rorukure. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesuisi orotxu rimyre. Deuxumy reàlàre, idi tahe tamyreny riwahinyre. Tule utura‑wana wiwesele risỹnymy. Tuu rotỹỹnyre. Ibutumy heka ixideewina rirỹsỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Rihydyrenyreu, Jesuisi rarybere taerydỹỹna mahãdu‑ò: —Bibutunybenyke rauhenyra uritere ixinamy itxiwixirenyõkemy idi watxireri. Uritere idi dehurenyõmy. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tahe ributunyrenyre iuhe waòinatxi reuròmy weriri ritỹxinyre orotxu yrere‑di. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jesuisi aõwiwihikỹ widỹỹnamy robirenyreu kiamy tahe raryberenyre. Tii inatyhymy Deuxu Rybedutyhy rare. Juhuu dori tuu rarybere kabede‑ò kanakemy. Inyboho tii riraòmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Rõhõtinyrenyre: —Jesuisi inyiòlòrenymy rikimyrenykre. Tamy ròkòirenykre. Iu Jesuisi kia rieryreu, ixisohojilemy rexitare ixyby, hãwãlò‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ibedesou aho ijà‑ò ierydỹỹna mahãdu riberenyre riraòkemy. Bede rurunyre tahe Jesuisi rehemynyõhyyre. Tai hãwòõ rimyrenyre idi reuròkemy ijõwe‑ribi ijà‑ò, Kafanaõ hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tahe yhy deborehekỹ tiribi tiribi rebonymyhỹ. Òbò tahe resemyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sohoji urihixina iòhòmy ròireny tahe Jesuisimy robirenyre. Tii betyredile tamyreny nariamy nade. Tiiboho ruberunihikỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesuisi tamyreny rarybere: —Jiarỹle wa rare, breburenyõmyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tai tahe hãworo‑ò Jesuisi ronykemy tiiboho disỹnydenyde. Aõ wesele tahe rehemynyrenyre tiòbo ròirenyraò. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Itxubiòwamy sõwemy iny wii ributunyre aho kanawe‑ribi ijà‑ki. Hãwò sohojile tahe tai roire aho‑ki. Jesuisi erydỹỹna mahãdu roirenyremy rieryrenyre. Tahe Jesuisi aõkõ idi rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tahe hãwòõ dehemynydenyde. Teberiade hãwã‑ribi Jesuisi tai ratximyhỹ iòhò‑ò. Tai juhu Jesuisi rexitòenymy rỹimyhỹ tahe orotxu tamy riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jesuisi iõre tai, ierydỹỹna mahãdu iõre. Kia tahe iny sõwemy robirau, hãwò‑ò rimyrenyre. Iòrysymy roirenyre, Kafanaõ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kanawe‑ribi ijà‑ò rehemynyreu, tii‑wana witxi reare. Tahe tamy rỹỹraxire. Waerydỹỹdureny, tiubo kaò tadehemynyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Aõwiwihikỹ rewinyremy aõkõ tiwaijetenyteri, rỹsỹna adeereny rewahinyrakile, tehydymy terỹsỹtenytakile. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Rỹsỹna tyhy ituemyhỹre kiaòle aõkõ maaõmysỹdỹỹbenyke, tahe iwitxira rỹsỹnaõ‑ò maaõmysỹdỹỹbenyke, kia ituedeõna‑di aõkõ rare. Deuxu Riòre Habutyhyhykỹ dori adee riwahinykre. Kia rỹsỹna umytuedeõnahakỹ wesemy rare. Taile tahe Deuxu Waha riwateònyreri. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tahe Jesuisi‑ò rỹỹraxire: —Timybo iny Deuxudeewimy arotỹỹnyrenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesuisi dirawyònyde: —Kialemy, biwatyhybenyke: —Deuxu dori wateòdỹỹdumy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tahe raryberenyre tamy: —Aõwiwihikỹbo inyko‑ò biitxeredỹỹnyke. Aõhebo botỹỹnykre, iny aratyhynykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Inytybyreny orotxu riyrenyre bederahy‑ki. Kia wese Tyyriti‑ki roire: —Moisesi tamy orotxu riwahinyre biu‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesuisi rirawyònyre: —Inatyhy tyhymy Moisesi aõkõ tamy riwahinyre. Waha dori biu‑ribi orotxu tyhy adee riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Deuxu orotxu tahe irutyhymy inydee riwahinymyhỹre, biu‑ribi diwahinymyhỹde. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tahe raryberenyre: —Wanyrỹ, tiu kia orotxu bidiwahinymahãkre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesuisi iximy rarybere: —Jiarỹ orotxu irutyhymy rare. Inyõ wadee kanakeki, tiu rama risaõtyhy. Inyõ riwatyhynykeki, tiu bee risaõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Adeereny heka rarybere: —Wamy tabitenyte, ihãrele tiwatyhynyõtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ibutumy iny Waha wadee riwahinymyhỹre wadee kanakre. Tiu ixi‑ribi ariteònyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Adobehede dori aõ ixideewimy aõma arotỹỹnykemy aõkõ. Wadeòdỹỹdudeewimy arotỹỹnykemy watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tiu ariõnonyõtyhy wadee diwahinydeò kiaboho ibutumy ikonana txuu rubu‑ribi ariixixanykre. Kia tahe wadeòdỹỹdu deewimy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Inatyhymy Waha deewimy kia rare. Iny iRiòremy robireu, rityhynykeu, umy tuedeõna ritake. Ikonana txuu tahe rubu‑ribi ariixixanykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jesuisi rarybere: —Jiarỹ biu ludu orotxu rare. Tai tahe judeu mahãdu aõbina binahakỹlemy rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kia wese rarybemyhỹre: —Kaa Jesuisile rare. Jyje riòre rare. Tyby he ijoi eryna rare ise tule. Aõherekibo tii rarybereri biu‑rubu nademy. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tahe Jesuisi dirawyònyde: —Tuu wamy ryberenyõmyke ayludurenymy. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wadeòdỹỹdu iny wadee rayky‑ò rarybemyhỹre namyhỹde. Kia wesele iny wadee kedehemynykre, ikonana txuu tiiboho rubu‑ribi ariixixanykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Deuxu rybedu Tyyriti‑ki kia rybe rỹire: —Deuxu ibutumy iny ribedeerydỹỹnykre. Tai tahe Waha‑ribi iny rierymy roholamyhỹre, tii tahe wadee rehemynykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Inyõ Wahamy robiõhyymyhỹre jiarỹle tahe tuu rabimahãre, iribi anadeki. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Inatyhytyhymy adee rarybemahãre. Inyõ riwatyhynykeki, umy tuedeõnahakỹ tiiwanale ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jiarỹ orotxu wesemy jiarỹ rare. Umytuedeõna wahidỹỹdu jiarỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Boreny dori biu‑ribi orotxu riyre bederahy‑ki. Irabihyy ibutumy tiiboho ituerenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Jiarỹ tahe biu ludu orotxu wese rare, inyõ tahe kia orotxu riykeki, tiu ruruõtyhy. Waumy ariwahinykre rubu‑ò ibutumy iny òraruna òwydỹỹmy. Tamyreny umytuedeõna riwahinykre rubu‑ò ibutumy iny òraruna òwydỹỹmy. Tamyreny umytuedeõna riwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judeu mahãdu tahe txiõdỹỹna rybemy widee raryberenyre: —Timybo tadelemy inyboho riòwenyrenykemy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesuisi rirawyònyre: —Inatyhytyhymy adee ararybekre. Kaiboho Deuxu Riòre Hãbutyhyhykỹde biròõbenykeki, umytuedeõna bitabenyõtyhy. Ihãlubu biõbenykeki, umytuedeõna‑di aõkõ atxitenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Inyõ waderòdu wahãlubumy momodu tii umytuedeõna‑di ratxireri. Tii tahe ikonana txuu rubu‑ribi adiixixanykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wade heka juhu irònatyhy rare, wahãlubu tu monatyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Inyõ wade rirokeki, wahãlubu riõkeki, wawana tiuhyy ratxireri. Jiarỹ tule tii‑wana watxihyyreri. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Waha irumy ratxireri. Tii wadeòdỹỹdu rare iòraru‑ki warumy watxireri. Tule waderòdu irumy ratxike waòraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jiarỹ biu ludu orotxu inatyhy jiarỹ rare. Iwese bederahy orotxu heka boreny riyrewesemy aõkõ jiarỹ rare. Ihãrele tahe ituerenyre. Inyõ riwaykeki, rexixahyymy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kia ibutumy Jesuisi rarybere Kafanaõ judeu dohodỹỹna‑ki, rierynanymyhỹreu. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iribi tahe Jesuisi‑ò ijohona mahãdu rarybere: —Kia isira tyhyre iny rieryke. Inyõ heka kia rityhynyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesuisile heka rexierymyhỹre tiiboho tuu rarybemyhỹreki, tahe tamy rỹỹraxire: —Kaa aõbohe arabinadỹỹnyrenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tahe jiarỹ Deuxu Riòre Hãbutyhyhykỹ, ixyby biu‑ò aròòsekeki, timybo marybebenyke, kaiboho wamy bobibenykeki. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Deuxu Tyytybytyhyle umytuedeõna riwahinymyhỹre. Umydetyhy umytuedeõna‑di aõkõ rare. Urile adee rarybemahãre Deuxu Tyytybytyhymy rybena rare, adeereny umytuedeõna rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tahe inyõ ayreny ludu riwatyhynyõreri. Jesuisi tahe juhuu‑ribi rierymyhỹre mobo rityhynyõmyhỹre, tule mobo tatxiõdỹỹdumy rarekremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesuisi raryberehyymy tii‑wana: —Jiarỹ juhuu rarybewãhãre. Inyõ Waha wadee riteònyõkeki tiu wadee kanaõtyhy. Tai heka tuu adee jiarỹ rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kia rybe òraru‑ki sõwemy taerydỹỹna mahãdu ririrenyre. Tahe roirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tahe Jesuisi rỹỹraxire taerydỹỹna waòinatxi reurò mahãdu‑ò. Ka bexe boibenyõkre aõbo biwaribenyõkre aõbohe. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tahe Simaõ Pedro rirawyònyre. Wanyrỹ moobo aròirenykre. Kaile heka umytuedeõna rybe‑di atxiteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Jiarỹboho ka aratyhynymahãrenyre. Araeryrenyre ka, kai Deuxu‑ribi hãbu òbitityhymy atximahãte. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jiarỹ aratarenyre waòinatxi reurò inymy erydỹỹna mahãdumy. Ihãre tahe inyõ ratximyhỹre diaboõ heka tii rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesuisi tahe Judasi Isariòmy rarybereri. Iwò inatxinamy wahe. Simaõ‑Isariò riòre tii rare. Judasi dori Jesuisi riwahinykremy ratxireri iòludu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Judeu mahãdu Jesuisi rubudỹỹmy rurumyhỹre. Tai tahe Judeia bede ludu hãwã‑ò ralòõmyhỹre. Kalileia bede hãwãdile rariamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tahe judeu mahãdu worana bedehesi iòhòmy rỹimyhỹ. Kiani tahe heto riòre worana bedehesi rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tahe Jesuisi seriòreboho tamy rarybere: —Make wa karibi Judeia mahãdu bede‑ò aerydỹỹna mahãdu dori aõwiwihikỹ kai tewinyteò tuu robikemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Aõwiwihikỹmy tewinyteri, tai tahe ixinamy iny tuu ibutumy robikre. Ibutumy iny ixierysymy tahõtinyteri‑wana urile iny lau iwòteõmy aõna aõna wiwihikỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesuisi seriòre mahãdu tule rityhynyõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesuisi tahe dirawyònyde: —Wiji araõkre wabededỹỹnanamy dori tuu reaõmy ratxireri. Kaiboho tahe adohotalemy bòike. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bede ludu mahãdu iny dori aluurenyre, tahe waderamy rekoarenyre. Iòrarunamy dori jiarỹ tamy rarybemahãre, ibinatyhyremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kaiboho boibenyke worana bedehesi‑ò. Jiarỹ tahe wiji araõkre, wabededỹỹnanamy reaõmy doimyhỹde. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kia tahe Jesuisi tamyreny rarybere. Tahe Kalileia‑ribi Jesuisi ròhònyõmy rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tahe iseriòre roirenyre worana bedehesi‑ò. Idi tahe tule tii rare iherenymy itỹnymy aõkõ wahe, wasimy inyõ tuu robiheny. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judeu mahãdu tahe Jesuisi riijemyhỹre worana bedehesi òrake‑ò. Rarybemyhỹre: —Titxibo tahe tii ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jesuisimy rybe ixitxiõdỹỹna ròhònyre inysõwehekỹy‑ki. Inyõ heka awimy tuu rarybemyhỹre. Ijõ tahe ibinamy tuu rarybemyhỹre, tii iny itxenadỹỹdu raremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Inyõ tuu rarybeõhyymyhỹre ibutumy ijohonamy judeu mahãdu lau ruberureki. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Worana bedehesi tya‑ki Jesuisi Deuxu dohodỹỹna heto‑ò ralore ribedeerynykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ribedeerynyreu tahe judeu mahãduõ ijõ‑ò rarybere: —Timykibo he kia ritidỹỹna rierymy tuu rarybemyhỹre. Rierykõ ihãrele iny rierynanymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tahe Jesuisi dirawyònyde: Waerydỹỹna‑di aõkõ rebedeeryre, Deuxu wateòdỹỹdu rybe‑di wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Inyõ Deuxudeewimy ratxikeki, tii rierykre aõerydỹỹnabo òbitimy ratxireri. Tii rieryke Deuxu‑ribi aõbo rarybereri ada ixi‑ribi rarybereri. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iny ixi‑ribi rarybekeki, tiile rexiloosònanyke. Tahe iny iteòdỹỹdumy rarybekeki, tii tahe inatyhy rare. Tii inatyhymy òbiti rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisesi adee bede ywina riwahinyre: —Tahe kaibohoõ tetyhynyõhyymahãtenyte. Tai tahe aõherekibo biwarubunykemy atxitenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tamy inyõ dirawyònyde. Kaita itxỹteteri. Inyõ ka ararubunykemy aõkõ ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jiarỹ inyõ reteytenyre sabado txuu tahe kaiboho wadi bede teòtiinytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Boholake, Moisesi bede ywina arateònyke ariòre ritõtyky aròkemy resynanykemy. (Boboho tahe kia tuu ritelenyre Moisesi aõkõ.) Tahe notyky resyna txu rỹikeki, tuu tewinyte sabado txu hãrele. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kia sabado txu biwinybenykeki Moisesi bede ywina riywinykemy, tahe aõherekibo wadee taykarananyteri hãbu sabado txu reteytenyreki. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Aõ òbitimy aõkõ rare, òbitimy tahõtinyterikile. Òbitinale‑di maraykynybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ijõ Jerusalẽ hãwã ludu mahãduõ rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","—Kia rarybemy rỹirerile, tii irubudỹỹmy rexinohõtinyreri. Beteheke. Butumy ijohonanamy kia rarybemyhỹre. Ihãrele taheka inyõ tamy rarybeõhyymyhỹre. Wedu mahãdu rõhõtinymyhỹre: —Ina aõkàbo Kristumy inatyhymy tii rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Inyboho tahe rierymyhỹre titxiribibo tiò namyhỹde. Kristu Deuxu deòdỹỹna tahe kanakeu, inyõ tahe rieryõtyhy titxiribibo kanake. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesuisi tahe Deuxu dohodỹỹna heto‑ki ribideerynymyhỹreu rarybere: —Kaiboho tiwaerytenyte, titxiribibo anade tule teerytenyte. Tahe wateòdỹỹdu teeryõtenyte. Teròwymy heka jiarỹ anade. Tule tii inatyhytyhymy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Iribi jiarỹ anade Tii riwateònyre, tai jiarỹ tii reeryre. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Inyõ riijemyhỹ riròtenykemy. Tahe rimyõhyyre ruberureki, ibededỹỹnanamy aõkõ bede rỹireki. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Iny sõwehekỹ‑ribi sõwemy iny rityhynyre. Tahe inyõ rarybere: —Kristu Deuxu deòdỹỹna iratyre aõna aõna wiwihikỹ riwinykemy tahõtinyteri. Aõkõre, tii dori inatyhymy Kristu rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseu mahãdu kia‑ò roholareu, tahe wii ributunyre xiwe wahidỹỹdu wedu mahãdu‑wana. Tahe tiiboho soldadu mahãduõ riteònyrenyre Jesuisi rimykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesuisi tahe tamyreny rarybere: —Urihimyò umyreny‑wana watxikre, idi ta aròòsekre wateòdỹỹdu‑ò ixyby. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kiaboho biwaijebenykre, waki mahabenyõtyhy. Titxibo watxireri kia‑ò heka bitehemynyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judeu mahãdu tahe widee rarybere: —Titxiwexe tii rakremy ihỹre, tuu rokobirenyõtyhy tai rakaharenyõtyhy, myỹ rarybemyhỹre wahe: judeukõdu mahãdu bede‑ò aõbo rakremy ixi‑di ratxireri. Tai ribedeerynykemy, judeu mahãdu‑wana rasỹnykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Timybohe rarybere: —Waki mahabenyõtyhy, titxibo watxireri‑ò behemyhyõtyhy, myỹ rarybereri. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ihewotxu worana bedehesi aõnihikỹtyhy rare. Jesuisi iu rexiukỹnyre rarybekemy: —Inyõ bemomy risakeki, wadee kanake, riõke. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Inyõ riwatyhynykeki, Tyyritina‑ki kia wese rybe rỹire: —Iwo‑ribi benihikỹ iru ròhònyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iu Jesuisi kia rarybereu, Deuxu Tyytybytyhy aõmy dỹỹnanamy rarybere. Iny dori rityhynykeki, iwo‑ò Deuxu Tyytybytyhy ralòke. Urile tahe Deuxu Tyytybytyhy riwahinyõmy rỹire. Jesuisi dori ròòseõre biu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tahe roholare mahãdu tahe rarybere: —Ka heka hãbu Deuxu Rybedutyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ijõ tahe rarybere: —Tii Kristu rare. Ijõ tahe rarybere: —Kristu aõkõ Kalileia bede‑ribi dori tii rareri. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tyyritina rybe‑ki roire: —Kristu, Davi sỹ‑mahãdu ribi kanakremy. Belẽ hãwã‑ribi; titxibo Davi rasỹnyre‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tai tahe wiwese wese aõkõ rõhõtinyrenyre Jesuisi‑di. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Inyõ riròtenykemy ixi‑di ratximyhỹ, ihãrele tahe inyõ rimyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tahe soldado mahãdu ròòsemy rare rimyõhyylemy fariseu mahãdu‑ò xiwewahidỹỹdu mahãdu wedu‑ò. Tahe soldado‑ò rỹỹraxirenyre: —Aõherekibo tedyõteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tahe dirawyònyde: —Timybo inyõ kowa hãbu wesemy rarybeõhyyre rybe iwitxira wihikỹmy tii rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tahe fariseu mahãdu rarybere: —Kaiboho aõbo tule araitxenanyrenyra. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Inyboho mahãdu reny‑ribi moõ rityhynyõhyymyhỹre, fariseu mahãdu wahe, wedu mahãdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Inyõ rityhynyre, tahe tiiboho Moisesi bede ywina rieryõre tai Deuxu aõhõkỹmydỹỹnana‑txi idi rehukre. Aõhõkỹmydỹỹnana‑ò ritamadỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodema iyreny‑ki ratximyhỹ. Fariseu mahãduõ tii rare, juhuu Jesuisi raraò rare wahe. Tii heka rarybere imahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Juhuu roholamyhỹre aõhebo rotỹỹnyraò wahe idi tahe ibinakeki riròtenykremy riijemyhỹre. Kia tahe iny bede ywinareny rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Tahe rirawyònyrenyre: —Kai wa tule Kalileia mahãduõ atxiteri. Tyyriti‑ò beteheke timybo rarybereriò: —Kalileia‑ribi rybeduõ ròhònyõtyhy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tahe ibutumy he tasỹ‑ò reareare. Iu tahe Jesuisi rare Oliveira hãwãlò‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Biura‑di tahe dòòsede Deuxu dohodỹỹna heto‑ò ixyby. Sõwemy iny tamy rare; Jesuisi ronyre; ribedeerynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hãwyyõ ratximyhỹ hãbu witxiraõ‑wana wasimy ratximyhỹ. Tahe inywitxiraõ itxireny reare. Tai tahe Deuxu rybe erydỹỹdu mahãdu fariseu mahãdu‑wana hãwyy didyde Jesuisi‑ò. Tahe hãwyy‑ò rarybere rỹikemy iny sõwehekỹy‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tahe raryberenyre Jesuisi‑ò: —Bede erydu: —Kahãwyy tỹwe rare inyõ itxi reara. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Iny bede ywina Moisesi riwawahinyré tahe rarybere mana‑di rurumyhỹkemy. Tahe aõmybo kai mynarybeke. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tiiboho kiamy rarybere Jesuisi riurihire timybo rarybekemy. Tai tahe ibinamy tamy rarybekemy idi ratxireri. Jesuisi tahe suò resera ròritidỹỹkremy tebò‑di suki riritinyra. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tahe ritỹỹraxinyhyy ihỹmyhỹ. Tahe Jesuisi rỹire; rarybere: —Inyõ òrarukõmy ratxirerile, tii mana‑di juhuu tamy rehukre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ixityrele sỹ Jesuisi ròritidỹỹre suò. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kia rybe‑ò roholarenyreu, tahe rexitarenyre sohoji sohojilemy, tarayky dori ribinadỹỹnyrenyra. Matuari mahãdu tahe juhuu rexitare. Ikonanatyhy dori rare, tahe Jesuisi hãwyywanale tai rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesuisi retehere: —Hãwyy sohojilemy robire rỹỹraxire tamy: —Hãwyy, titxibo mana‑di arubudỹỹmy rybedu mahãdu rirahura. Inyõ aõhe arasỹnyõhyyra. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tahe dirawyònyde: —Anokõre, Wahĩ. Tahe Jesuisi rarybere: —Jiarỹ tulere! Mahe, òraruna‑txi tahe ixyby ixeõmy. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ixityre Jesuisi rarybere tamy: —Jiarỹ wabede loosòna rare. Inyõ wahemy kanakeki, bede luru‑ki rariaõtyhy. Tii heka loosòna‑di tarayky‑ki rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tahe fariseu mahãdu tamy rarybere: —Aõkõre, kai wa iximy tarybeteri tai tahe arybe inatyhymy aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesuisi dirawyònyde: —Inatyhymy iximy rarybereri jiarỹ, tahe warybe inatyhy rare, jiarỹ dori reeryre titxiribibo anade, tule tiobo arakre reeryre. Kaiboho tahe kia teeryõtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kaiboho waywisidỹỹmy tadiòlònyte, ihãre tahe òbitimy tiwaywinytenyõte tiwaerytenykõteki. Tahe jiarỹ inyõ reywinyõreri. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Jiarỹ inyõ ariywinykeki, waywisidỹỹna tahe òbiti rare. Jiarỹ dori ixiwanale aõkõ rare. Waha, wadeòdỹỹdu wawana raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Abede ywina‑ki kia rybe riritinymy rỹimyhỹre: —Inatxi hãbumy wiwesehyylemy rarybekeki kia tahe inatyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jiarỹ iximy rarybemahãre tule Waha wadeòdỹỹdu wamy adeereny rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tahe tiiboho Jesuisi‑ò rỹỹraxirenyre: —Titxibo boo ratximyhỹre. Jesuisi rarybere: —Kaiboho tiwaerykõmahãtenyte, Waha tule teeryõmahãtenyte. Kai biwaerybenyõkeki, tule Waha bierybenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kia Jesuisi rarybere Deuxu dohodỹỹna hetowo‑ki, iubeweri yrubudỹỹna ube‑ki. Tahe inyõ rimyõhyyre, ibededỹỹnanamy aõkõ bede rỹireki. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iribi tahe ixityre tamy rarybere: —Jiarỹ he arakre karibi. Kaiboho biwaijebenykre tahe aòrarurenydile burubenykre. Boiõtyhy titxibo arakre‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tai tahe judeu mahãdu widee raryberenyre: —Inatyhymy aõbo tii rexirubunykre. Tii raryberaki: —Titxibo arakremy boiõtyhy, myki tuu idi rõhõtinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tahe Jesuisi rarybere: —Kaiboho kaludu toite; jiarỹ aõkõre, biu ludu rare. Kaiboho bede ludu toite, jiarỹ tahe kabede ludu aõkõ jiarỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tai heka adeereny rarybereri aòrarureny‑di burubenykremy. Inatyhymy jiarỹ tii rare: —Iwese rarybere wesemy. Tahe kia warybe bityhynyõbenykeki, aòrarureny‑di burubenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tahe tiiboho rỹỹraxirenyre Jesuisi‑ò: —Mobo he tate. Jesuisi dirawyònyde: —Timybo adeereny rarybewãhãre, juhuu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jiarỹ sõwemy rỹire aõna aõnamy umyreny ararybeke umyreny ariywinyke ta ararybekre Waha tuu wadee rarybelemy. Tii diwateònyte tii inatyhymy rare. Irybelemy bede iny‑ò ararybekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Rieryõhyyre tamyreny rarybere, tybymy. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kaiboho heka biwatamadỹỹnybenykreu, bierybenybenykre mobo jiarỹ rare. Tule ixi‑ribi aõkõ aõna aõna rewinywãhãre bierybenykre; tule iwese Waha riwaerynanymyhỹre wese, rarybemahãre. Kia tule bierybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wateòdỹỹdu wawana raremyhỹ. Iximy riwariõtyhy, jiarỹ tamy wimy rewinyhyymahãreki. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kiamy tarybe rahudi tahe, sõwemy iny rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Judeu ityhydỹỹdu mahãdu‑ò Jesuisi rarybere: —Kaiboho warybe tyhy‑di mohõtinybenyhyykeki, inatyhymy watyhydỹỹdu waheludumy boibekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Inatyhyna tahe bierybenykre. Kia dori aratarenyke, deòdumy aõkõ boibekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Dirawyònydenyde aõkõre inyboho Abraõ riòkòre roire, tiu heka modeòdumy roirekõmahãre. Timybo tarybeta: —Deòdu‑ribi riwatakemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tahe Jesuisi tamy rarybere inyõ òraru‑di hyy rexiòrarunykeki, tii òraruna deòdu wese hyyle rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Deòdu heka heto wedu ijoihyymy aõkõ rarekre. Iwedu ixinamy rakre. Riòre tahe iijoihyymy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tahe Deuxu Riòre heka ixinamy arateònykeki, tiu òraruna deòdu wesemy ixyby bonybenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraõ riòkòre inatyhymy toite. Kia tahe reeryre. Ihãrele tahe biwarubunybenykemy atxitenyteri warybe dori araykywo‑di aõkõ ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Waha‑wana ranymahãu, aõmybo rabire, wiji tuu rarybereri. Kaiboho tule boo‑ribi tabitenyte tuu tewinytenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Rirawyònyrenyre: —Wahareny heka Abraõ rare. Jesuisi rarybere: —Abraõ riòremy inatyhymy toite‑wana, Abraõ aõmydỹỹnana iwesemy biwinybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Katahe warubudỹỹmy wadi atxitenyteri. Inatyhyna Deuxu‑ribi raholaremy, adeereny rarybemahãre, tai tahe warubudỹỹmy atxitenyteri. Abraõ tahe tiu tahe tuu rotỹỹnyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kaiboho heka borenytyhy wesele tatỹỹnymahãtenyte. Dirawyònyde: —Aõkõre, jiarỹboho waxiriòre aõkõ roire. Deuxuhyyle iny tybyreny rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tahe Jesuisi rerawyònyre: —Deuxu boo inatyhymy rare‑wana inihe kaiboho waluurenyre. Jiarỹ dori Deuxu‑ribi anade. Ixidee wimy aõkõ anade tii diwateònyde. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aõherekibo teerytenyõte warybe. Isiratyhyre aõbo ijohona. Aõkõre, ityhydỹỹ isirare adeereny. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kaiboho Diabo riòre toite tamywimy biwinykemy atxitenyteri. Tii juhuu rubudỹỹdu hyy rare. Tii heka raruireri inatyhywesehekỹle wahe. Tii ruidu rare. Ruiwedu tii rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kaiboho heka tiwatyhynyõhyymahãtenyte inatyhyna dori jiarỹ rarybemahãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Inyõ inihe wamy rarybeõtyhy jiarỹ òrarudu raremy. Adeereny inatyhynamy rarybereri. Aõherekibo tiwatyhynyõteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iny Deuxu‑ribi ratxireri, Deuxu rybe roholamyhỹre. Kaiboho Deuxuhõrõ aõkõ toite. Teòdu aõkõ toite. Taita warybe‑ò taholaõteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jesuisi‑ò tiiboho dirawyònydenyde: —Inatyhymy rarybewãhãrenyre. Kai Samaria mahãdu tate. Kaludu mahãdu aõkõ tate. Kai tyytybybina dire. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesuisi rirawyònyre: —Aõkõre, tyytybybina‑di aõkõ watxireri. Waha tahe rewowydynywãhãre. Kaibohole tiwabinadỹỹnymahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wowydyna ixi‑di aõkõ reijereri. Waha tahe kia aõmydỹỹnanamy riywinykre, tii rierymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Inatyhytyhymy adee ararybekre: —Inyõ warybemy reòbykeki, tiu rubumy tii robiõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tai judeu mahãdu rarybere: —Katahe inatyhymyhe inydeereny aerysydỹỹna rỹira tyytybybina‑di tate wahe. Abraõ tahe rurure; Deuxu rybedu tule. Tahe timybo kai tarybeta: —Inyõ warybemy reòbykeki tiu rubu urihixinamy roiõtyhy tamy. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kai aõbo inytybyreny Abraõ ratyre awikemy aõbo ixi‑di tahõtinymahãte. Abraõ rurure Deuxu rybemy rybenadu amahãdu tule rurure. Mobo raremy he tahõtinymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tahe Jesuisi rirawyònyre: —Jiarỹ ixi‑di wowydyna ariijekeki, tahe wawowydyna aõ aõkõmy rareke. Waha tahe riwawowydynymyhỹke aDeuxumy raremy tu tarybeteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tahe aõkõ teeryõtenyte. Jiarỹ tate reerymahãre. Jiarỹ reeryõmahãremy ararybekeki, tai ruidumy rareki, iwese kaiboho toite wesele wahe. Tahe reerywãhãre, tule irybemy reòbymahãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Boreny Abraõ, wamy dobide, wabededỹỹnana kanakremy tuu dobide, wabededỹỹnana kanakremy tuu dobide tai tahe reysatyhymy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tahe judeu wedu mahãdu rarybere: —Kai 50 beòramy aõkõ atxiteri timyrekibo tarybeta Abraõ tabitemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesuisi dirawyònyde: —Abraõ reaõule, Jiarỹ rarehyymahã. ");
INSERT INTO kpjNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tahe manadile rimymy reserenyre idile rirabunykemy. Jesuisi tahe rexiwòmy iribi ròhònymy rare, dohodỹỹna heto‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesuisi rariamy rareu, tii robimy rare hãbu ruetàmy. Tii iruetàhàkỹmy ratohouãmy herinanyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ierydỹỹna mahãdu rỹỹraxire tamy. Erydỹỹdu, aõherekibo hãbu ratohouãnyra iruetymy, ise tyby iòrarudireki aõbo ada taòrarumy aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tahe Jesuisi rirawyònyre: —Tahe aõkõre tyby ise‑ke aõkõ tiike aõkõ. Deuxu ruru wiji riteòsinykremy tahe tii kiawesemy rohonyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Wateòdỹỹdu aõmydỹỹnanamy arotỹỹnyrenykemy watxiwãhãrenyre. Inyboho rikiwinyrenyke ibededỹỹnanamy rỹikreu, iwese txumy rỹikre wese tahe rumy heka kanakre tai raaõmysỹdỹỹõmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kabede‑ki watxiwãhãreòle tahe jiarỹ bede ludu mahãdu loosònatyhymy jiarỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tarybe rahudi tahe rarybexinyre suò idi tahe subororomy ritxienyre. Idi ta hãbu rueyre‑ò subororo ritidire. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tahe hãbu ruetà‑ò rarybere: —Make wa bexisuhòke Silòe ahobe‑di. Silòemy ninadu heka iny rybe‑ki deòdỹỹna wesemy rare. Hãbu tahe rare, risuhore, dòòsede robimy. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tahe ierydu mahãdu, tuu robire idi itxeredu mahãdu raryberenyre widee: —Kabe hãbu ixitòedỹỹdu rare, nierumy kowa‑ki rexitòenymy ronymyhỹrele rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ijõ rarybere tule rare. Ijõ rarybere: —Aõkõre, iwesele tahe iwitxirari. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Rỹỹraxirenyre tamy: —Timykibo arue reytera. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Rirawyònyre: —Hãbuõ Jesuisi inire. Tii tahe suboro borole riwinyra warue‑ò ritidire. Tahe wadee rarybera: —Make Silòe ahobe‑ò aõ bisuhòke. Tahe rare, resuhore, tai rabimy watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Rỹỹraxirenyre titxibo tahe tii rara. Rirawyònyra: —Reeryõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Kia ruedeytena Jesuisi riwinyre sabado txuu, judeu aõmysỹdỹỹna txu aõkõ. Tahe tiiboho hãbu ridyrenyre fariseu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ixityre hãbu‑ò rỹỹraxirenyre: —Timykibo riteytenyra. Tahe rirawyònyre: —Subororole waruetyre‑ò ritidira, idi resuhòra, iule tahe retehera. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tai tahe fariseu mahãdu‑ò narybede: —Ka hãbu Deuxu‑ribi aõkõ nade. Kakỹny sabadotxu bede ywina riywinyõhyyre. Tahe ijõ imahãduõ rarybere: —Hãbu òraruduõ tiu deytenawiwihikỹõ kia wesemy riwinyõtyhy. Tai tahe wiribi hitximy raraykynyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tahe ixityre hãbu‑ò rỹỹraxire: —Tii arue arue riteytenyra: —Tai tahe timybo tuu marybekre. Hãbu rarybere: —Tii Deuxu rybemy rybeduõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tahe judeu mahãduõ rarybere: —Ise‑wana tybywana widee ararybekekile, arityhynykre. Tai riteònyre tybybohoòrysymy. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Rehemynyreu, tahe tamy rarybere: —Kaa aõbo ariòre rare. Inatyhymy aõbo iruetàmy reare. Timykibo tahe wiji robira. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tahe tybyboho rirawyònyre. Inatyhymy wariòrereny rare. Iruetàlemy ka reare. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Reerykõrenyre timykibo retehera. Irue riraynyre dori, reeryõhyyre. Tamy marybebenyke. Ibeòra dire ka, iximy relyyleke. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Tybyboho ruberumyhỹrenyre judeu mahãdu lau. Judeu mahãdu dori, rarybemyhỹre: —Inyõ Jesuisimy rarybekeki, tii Kristu Deuxu deòdỹỹna raremy rarybekeki, tahe dohodỹỹnawo‑ribi riteònykemy idi rỹira. Tai tahe hãbutybyboho kia wesemy raryberenyre. Tii ibeòra dire: —Tamy marybebenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Juhuu iruetàmy raremyhỹò ixityre ròtedỹỹmy rarybere. Òbiti rybe‑di marybeke. Inydeereny tahe ka dori òrarudu rare. Tai tahe Deuxu biwowydynyke. Tahe tii rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Tii òrarudu rare, reerykõre. Sohoji aõmydỹỹnana reeryre. Juhuu waruetàle heka reeryre, wiji tahe retehereri. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tahe ixityre tamy rỹỹraxire: —Aõbo tii riwinyre. Timybo arue roire. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hãbu rarybere: —Adeereny tuu rarybere tahe taholaõhyytenyta. Aõherekibo ixityre ijohonamy tarybetenyteri. Ierydỹỹnamy boibekemy aõbo atxitenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tuu raryberenyre aõbina binalemy. Kai heka iijoiõ atxiteri. Jiarỹboho Moisesi erydỹỹna jiarỹboho roire. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Deuxu Moisesi‑ò rarybemyhỹre. Kiamy reeryrenyre. Ka hãbumy tahe aõmy raholaõmahãreny, tiludubo rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kia wa riwateytenyra bedeòtiidỹỹna urenana tii rare. Ihãrele tahe kaiboho teeryõmy tuu tarybetenyteri. Wadee kia ajuedena rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Deuxu wa òrarudu ixitòedỹỹna‑ò roholaõtyhy. Kia reeryrenyre. Tahe inyõ Deuxu rityhynykeki tamywimy rỹirakeki, kia‑ò Deuxu roholakre. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Bede rexidelenyreu, inyõ roholatyhy iruetàmy raumynyre heka reytere. Inyõ tiu riwinyõre, wiji tahe diwinyde. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kia hãbu Deuxu‑ribi nokõduõ aõkõkeki tiu aõ riwinyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tahe fariseu mahãdu aõbinahakỹlemy tuu rarybere: —Kai uladumy teateu, òrarudutyhymy tate. Kai aõmybo biwabedeerynybenykremy aõbo wadireny tahõtinyteri. Tahe riteònyre dohodỹỹna heto‑ribi. Ihyymy riteònyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kia‑ò Jesuisi roholareu hãbu riijere tahe rỹỹraxire tuu: —Kai Deuxu Riòre Hãbutyhyhykỹ aõbo tetyhynyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Hãbu rarybere: —Mobo tii rare, Wanyrỹ, arityhynykemy watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Wamy wa tabita, jiarỹleheka watxireri. Adee rarybererile watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tahe rarybere: —Wanyrỹ aratyhynyra he. Tahe hãbu Jesuisi riwowydynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesuisi rarybehyyra: —Jiarỹ anade kabede‑ò iny ruetà aritobixidỹỹnykemy; tule robimyhỹre mahãdu ariruetàdỹỹnykre. Iny òwydỹỹnamy anade. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fariseu iòhòmy iribi rỹimyhỹ roholare irybe‑ò. Tahe tamy rỹỹraxire. Inatyhykõ aõbo ka jiarỹboho tule waruetàrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesuisi rarybere: —Aruetàmy ahãtenyteki, aòraruna‑di aõkõ toite. Tahe tarybetenyte reerywãhã, rabiwãhãre. Tai aòraruhyy‑di toite. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Inatyhytyhymy adeereny ararybekre: —Inyõ budoeni yrubudỹỹna ijòtòbòna‑di, ralòõkeki, tii tahe wasidu ixiwatxidỹỹdumy rare, raòwònymy heka ralòmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ijòtòbòna‑di ròtedu, tii budoeni‑di itxeredutyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Iu ijòtòbòna‑ò rehemynymyhỹreu, ijòtòbòna ludu tamy riraynymyhỹre. Tule budoeni irybe rierymyhỹre. Sohoji sohoji‑ò ininimy tamy ryrymyhỹre, tahe idi ròhònymy ridymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ihõrõ ahana‑ò ridyreu, tii iko‑ò rỹimy idi ramyhỹre. Riheludunymy idi raremyhỹ rierymyhỹreki irybe. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Budoeni ieryõdu riheludunyõtyhy, irybe rieryõreki. Iny ieryõdu‑ribi rahenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesuisi tamy kia bede eryna ijyymy relyyre. Tiiboho tahe rieryõhyyrenyre timybo ibede erydỹỹnamy rororerimy. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tahe Jesuisi ritỹnynyre tamyreny: —Jiarỹ budoeni ijòtòbòna wesemy rãimahãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ibutumy iny wakõule rehemynyre wasidu ixiwatxidỹỹdumy rỹiramyhỹ. Wabudoeni ityhydỹỹdu wesemy rỹirerimy ihỹre. Tiiboho wasidurybe‑ò roholaõhyymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jiarỹ ijòtòbòna wesemy rãiwãhãre. Inyõ wamy ralòkeki, tii heka tarasanaõmy rarekre. Iwese wabudoeni ralòmyhỹre idi ròhònymyhỹre asi wiwihikỹmy riroximyhỹre wesemy, tule ityhydỹỹdu mahãdu rỹirakre, bedeòbyna wiwihikỹ ritakremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Wasidu heka rubudỹỹmy nade, bedehudumy wasimy, jiarỹ tahe anade inyõ umytuedeòna ariwahinykremy, irutyhytyhy wihikỹmy wiji rỹirakremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jiarỹ budoeni‑di itxeredu wihikỹ rare. Ihyy ta waumy ariwahinykre teròwyrenymy. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Inyõ budoeni‑di itxeredumy deòdumy risỹnykeki, tii riwisinanyõtyhy, tii dori budoeni wedu aõkõ rare, deòdule rareki. Tahe iròdu brebunaõ tamy kanakeki tahe rahenyke iribi, tai ijõ rimyke, ihona tahe raòrunyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Deòdu heka rahenyke tii iwedu aõkõ rareki, tii aõmy aõkõ idi rõhõtinymyhỹre, iòwydimy aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Jiarỹ heka itxeredu wihikỹ rare wabudoeni riwaerymyhỹre. Jiarỹ tule tii mahãdu reerywãhãre. Waha riwaeryre, tule tii reeryre. Iwesetyhyle wabudoeni‑wana wii reerynyre. Iòraru‑ki tahe waumy ariwahinykemy idi wãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Jiarỹ wabudoeniõ‑di watxiwãhãre. Aõ kabede‑ki aõkõ. Ibutumy aributunykemy idi watxireri. Tai tahe sohoji ijoihyylemy heka roikre. Ibutu‑di itxeredumy ararekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tai heka Waha waluure, waumy ariwahinykreki wahe. Ihãrele tahe ixyby idi arexiumydỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Inyõ heka ixideewiõkeki riwarubunyõtyhy. Arexiwahinykre tamyreny riwarubunyrenykremy. Ixideewikreu, arexiwahinykre, tule waumy arimymy arexiixixanykre. Waha dori wadee rarybere tii ariwinykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kia rybe òraru‑ki judeu mahãdu rybe rexijeijeinyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sõwemy iny ritxiõnymy rarybere: —Tii tyytybybina‑di ratximyhỹre ada raitxỹtemy aõbo ihỹre. Aõherekibo tamy taholamahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ijõ tahe rarybere: —Aõ tyytybybina‑di aõkõ rarybemyhỹre. Tyytybybina aõbo hãbu ruetà riruedỹỹnyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalẽ hãwã‑ki heka beòrahyy rare. Worana bedehesi hetxina Tỹmyradỹỹna rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Salomaõ Ube‑ki, Deuxu dohodỹỹna heto ubeõ‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jesuisi rariamy ihỹmyhỹ. Tahe judeu mahãdu rirurawonyre itỹỹraxidỹỹmy. Tiwese bededỹỹnanymybo nohõtidihyy bede ariwyrenykre. Kai inatyhymy Kristumy tate‑wana, tahe manarybeke itỹnymy. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesuisi dirawyònyde: —Rarybere wahe, tahe kaiboho tiwatyhynytenyõhyyte. Inatyhymy ierysymy mohõtinybenykeki, waaõmydỹỹnana wiwihikỹ rewinymahãre‑di betehebenyke. Wahani‑di kia rewinymahãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kaiboho tahe tiwatyhynyõlemahãtenyte, wabudoeni wesemy aõkõ toite. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wabudoeni warybe rierymyhỹre, riwaheludunymyhỹre; jiarỹ heka ibutumy wabudoeni reerymahãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Tamy umytuedeõna rewahinywãhãre tiu heka ruruõtyhy. Inyõ waribi ridyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Waha wadee riwahinyre. Tii heka ibuturatyre rare. Inyõ iribi ritaõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jiarỹ Waha‑wana sohojihyyle watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ixityre tahe judeu mahãdu mana‑di rirubunykre idi rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tahe Jesuisi tamyreny rarybere: —Jiarỹ sõwemy bedeòbyna inydee rewinywãhãre Waha ruru‑di. Aõòrarukibo biwarubunybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tahe judeu mahãdu rirawyònyre: —Kai aõmydỹỹnana wiwihikỹle tewinyte. Kia òraru‑ki aõkõ ijoi adi rỹireri mana‑di arubudỹỹmy Deuxumy binatyhymy tarybeteriki. Kai dori hãbu tate, ihãrele Deuxumy texininiteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Jesuisi rarybere: —Abede ywina‑ki ryberiti rỹire. Deuxu Rybe òbitihyymy raritinymy rỹire. Kiamy: —Jiarỹ rarybere: —Kaiboho Deuxu toite. Deuxu Rybe heka inyõ‑ò diteònyde. Kia mahãdu tahe Deuxulemy rininire. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Deuxumy tiiboho rininirenyre‑wana, aõherekibo wadee takyarananyteri jiarỹ tule Deuxu Riòrelemy rexininireki. Waha dori, riwatamy diwateònyde. Timykibo kaiboho tarybetenyteri Deuxumy ibinamy jiarỹ rarybererimy ");
INSERT INTO kpjNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","38","Waha‑ribi bedeòbyna ariwinyõkeki, biwatyhynybenyõtyhy. Tahe ariwinykeki, aõbo rewinyre‑wana bityhynybenyke, biwatyhynybenyõke hãrele. Tai tahe bityhynybenymy boibeke jiarỹ Waha‑wana wãhãre tule Waha wawana ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kabedeu ixityre riijere Jesuisi rimykemy tii rexitamy rexihedỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesuisi ixityre Jordaõ bero kowa weribi‑ò reurore. Joaõ juhuu ròsebedỹỹmyhỹò rare. Taile tahe tii raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tahe sõwemy iny tamy roirenyre. Tamy rarybere: —Inatyhymy Joaõ bedeòby iny itxerenamy riwinyõre. Tahe ibutumy tii Jesuisimy rarybemyhỹre, inatyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Sõwemy heka taile Jesuisimy rityhynymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Lazaru ibinamy roimyhỹ Betỹnia hãwã‑ki. Marie, Marta‑wana iseriòrereny rare. Juhuu Marie Jesuisi‑wana raremyhỹu, tii Jesuisiwa tyre‑ò tarinalỹnyrehekỹõ ritxiwire, idi tahe tarade‑di rirubudỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lazaru ibinamy roimyhỹki tahe tiiboho riteònyre Jesuisi‑ò rarybekremy: —Wahĩ, abiòwa tyhy binanihikỹmy roireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesuisi kiamy roholareu rarybere: —Kabinana hãwã Deuxu wowydynamy tamy nade. Tule riwawowydynykemy jiarỹ dori Deuxu Riòre rare. Kabinina tahe rubuhyymy aõkõ tamy rỹike. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesuisi heka ibutumy iluurenyre, Marta, Marie, Lazaru‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Iu Jesuisi rieryreu Lazaru webinaduna, tahe taile ratximyhỹre, rerihãrele inatxitxumy. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Iribi tahe rarybere taerydỹỹna mahãdu‑ò: —Ròkòirenyke ixyby Judeia bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tahe ierydỹỹna mahãdu tamy rarybere: —Erydỹỹdu aõherekibo ixybynomy tamy tarybeteri judeu mahãdu adi heka riwisỹnymy rỹimyhỹ mana‑di arubudỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesuisi dirawyònyde: —Txu heka waòinatxi òra bededỹỹnanamy rare. Aõhe inatyhy. Inyõ txumy rariakeki, tiu aõ òraru‑ki reseõtyhy loosònamy dori ibutumy robimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bede lurumy rariakeki tahe, aõ òraru‑ki reseke, loosòna dori ihoõreki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tahe ijõmy Jesuisi tamyreny rarybere: —Iny biòwareny rõrõmy roireri. Tamy arakre ariixixanykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tahe imahãdu rarybere: —Wanyrỹ tii rõrõmy roireri‑wana bohe, reytekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesuisi heka rarybemyhỹ Lazaru rubumy roirerimy. Tiiboho tahe rõhõninyrenyre urile rõrõmy roirerimy. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tahe Jesuisi ritỹnynytyhyra tamyreny: —Lazaru rurure. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Jiarỹ wa aòrarureny‑ki wadeysamy watxireri tai watxiõraki. Ka tahe biwatyhynybenykre. Ròkòirenykre tamy. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tome ierydỹỹna mahãduõ rare. Didimomy iniõre. Tamahãduõ rarybere: —Ròkòirenyke, tule tii‑wana rukururenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesuisi rehemynyreu, Lazaru inaubiòwatxumy hãloo iwòdỹỹwo‑ki roimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betỹnia Jerusalẽ hãwã‑ribi sohoji urihixinamy roire. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Judeu mahãduy‑ribi sõwemy doidenyde Marta Marieboho wotòenamy, iseriòrereny rurureki. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta Jesuisi kanakre rieryreu, tahe ròhònyre tii‑wana witxi reakemy. Marie tahe tahetokile ronymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tahe Jesuisi‑ò Marta rarybere: —Wahĩ, kakile atxiberi‑wana waseritxòre rurukõhykyra ikuny. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ihãrele tahe rekeryre ibutumy Deuxu‑kò bexitòenykeki, tiki adeke kidiwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesuisi tahe tamy rarybere: —Aseriòre wa rubu‑ribi kedexixakre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tahe Marta rarybere: —Rekeryre jikarỹ ikokunanatxu‑ku rubu‑ribi rexixakre, ibutumy ixixanatxu‑ku. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesuisi rarybere: —Jiarỹ waixixanadỹỹdu rare, umytuedeõna wahidỹỹdu rare. Inyõ riwatyhynykeki, tii rubu‑ki roire hãrele, kedexixakre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ibutumy irumy roirekeki, tiu rururenyõtyhy, tii dori riwatyhynyreki. Kai aõbohe kia tetyhynyteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tii dirawyònyde: —Kohe, Wahĩ, aratyhynywãhãre. Kai Kristu tate, Deuxu ritxòretyhy. Deuxu tuu rarybereki, bede‑kò kanatekònyde wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tahe Marta ròòsere Marie taseriòre‑ò rarybere: —Inyhĩ rehemynyreri, kai makremy rarybereri. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kiamy roholareu, tahe, wylemy rỹimy reare tamy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesuisi dori hãwã‑ò ralòõlemy raremyhỹ Marta tamy raryberekile raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tii rỹimy ròhònyreu, judeu mahãdu tuu robire. Tahe riheludunyre, wabede‑ò robukremy raresỹny tamy roholare. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Marie rehemynyre Jesuisi‑ò. Tahe tii tuu robireu, resere iko‑ò, tahe rarybere: —Wahĩ, kaki atxiberi‑wana ikuny waseritxòre rurukõhykyra. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesuisi Marta ibru‑di tule judeu mahãduhi‑di retehereu tule tii rabedewonihikỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Iule Jesuisi rỹỹraxire: —Titxiwexe tii tetiditenyte. Tiiboho rirawyònyre: —Wanyrỹ, manake itxeremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesuisi tahe rahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tai tahe judeu mahãduõ rarybere: —Betehebenyke sõwemy heka tii Lazaru luure. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ijõ tahe rarybere: —Tii iny ruetà riteytenyre. Aõherekibo Lazaru irumy ratxireriule riteytenyõra. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesuisi ixyby tawo‑ki bederiòtiinyre. Tahe rariamy rare wabede‑ò Lazaru suiwodỹỹwo‑ò roire. Mana‑di tahe ritxiotòbònyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tahe Jesuisi rarybere: —Mana bitake Marta tahe iseriòre rarybere: —Wahĩ, rarònyreri wahe inakubikòwa txumy dokuri txuu idi rỹira. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Tahe Jesuisi rarybere: —Rarybere taheka, bityhynykeki, Deuxu rurumy bobike. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tahe mana iribi ritarenyre. Jesuisi retehere biu‑ò rexitòenyre: —Umy reàlàmy wahe watxireri kai wadee taholataki. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wadee taholahyy atxiteri mahãte: —Kia reeryre, kata inysõwehekỹ òraru‑ki kiamy rarybera adee, tai tiiboho rityhynyrenykemy wahe, kai tiwateònyteki. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kia rexihureu tahe ryryre: —Lazaru, bodohonyke wa ahana‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kia rurumy roimyhỹ‑ribi tahe dòhònyde. Iwa heka tebò‑wana widee ritỹtenylemy roimyhỹ. Irati tahe tyybese‑di ritỹtenymy ihỹmyhỹ. Jesuisi rarybere: —Biesebenyke wa ixinamy rake. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tahe judeu mahãduy‑ribi, Marie Martaboho roraludu mahãdu, aõbo Jesuisi riwinyremy robireu tahe, rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ijõ tahe fariseu mahãdu‑ò roirenyre tamy relyykemy aõbo Jesuisi riwinyremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Iribi tahe xiwe wahidỹỹdu wedu, fariseu wedu mahãdu‑wana heka ywisidỹỹna mahãdu ributunyre. Dohodỹỹna mahãdu wedu heka imahãduni rare. Tahe inyõ rarybere: —Ka hãbu heka aõwiwihikỹ sõwemy diwinymyhỹde. Aõhebo he rokotỹỹnyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tiihyyle riwinymy rarekeki, heka ibutumy rityhynykre. Idi tahe Roma hãwã mahãdu soldadu kanakre iny riòlòdỹỹnyke inysỹ rahurenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Kaifa imahãduõ rare. Kabeòrau tahe tii ibutu xiwena wahidỹỹdu wedu rare. Tahe tii rarybere: —Kaiboho aõ teeryõhyytenyte. Hãbuõ tahe rurukre ibutu inydee. Tai tahe ibutu iny itueõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kia heka irayky‑ribi aõkõ ròhònyre. Deuxu irayky‑ò ritidire, tii dori xiwena wedu tyhy rare kabeòrau. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kiamy rarybereu, tahe Jesuisi rubunamy rarybereri. Jesuisi dori ibutumy judeu mahãdu dee rurukre. Tamy sohojile aõkõ rurukre. Tahe sohoji mahãduòle rabutukre Deuxu riòre bede bedemy rỹira mahãdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Itxuule tahe Jesuisi rubudỹỹmy rõhõtinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tai tahe ihãwãy‑ki rariaõre, Judeia mahãduy‑ki. Tahe iribi rexitare bederahy‑ò iòhòmy. Hãwãõ‑ò heka rare, Efraĩ heka inire. Taile taery mahãdu‑wana ihỹmyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judeu mahãdu worana bedehesi iòhòmy rỹimyhỹ Pascoa heka inire. Ritelenykõule heka sõwemy roirenyre Jerusalẽ hãwã‑ò, tai rexiywinyrenykemy iwese bede ywina rarybere wese Pascoakomy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Sõwemy iny Jesuisimy robikemy rỹimyhỹ. Tahe Deuxu dohodỹỹna hetowo‑ki widee rarybemyhỹre tahe rarybere: —Kanakre aõbo Jesuisi worana bedehesi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Xiwena wedu fariseu‑wana juhuu inyõ rarybemahãre: —Inyõ Jesuisimy robikeki, tuu wadeereny kanarybekre, tii ramykremy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jesuisi rare Betỹnia hãwã‑ò Pascoa worana bedehesi rỹikrekoki. Debòsohoji txumy rauhenymy rỹimyhỹ tamy. Tai heka Lazaru rasỹnymyhỹre rubu‑ribi rexixare‑ribi wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Martaboho tahe rỹsỹna wiutàdàna riwinyrenyre Jesuisideewina. Lazaru Jesuisi‑wana riroxikremy ronymyhỹ. Tahe Marta tamyreny rỹsỹna riwymyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Marie tahe sõwemy aderòna lỹnyre‑di ratximyhỹ, iòwyhykỹre heka. Tahe tii Jesuisiwatyre ritxiwire idi tahe taradedile risuhore. Heto tahe tỹnyrehekỹlemy roire. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judasi Isariò tule Jesuisi erydỹỹnaõ rare tii tai ratximyhỹ. Tii Jesuisi rityhenykremy tii raremyhỹ ihewo‑ribi. Tii tahe rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Kaa aderòna heka iòwyhykỹ rare. Aõherekibo idi tahonyõte nieru idi bitakemy iny aõkõ mahãdu‑ò nieru biwahinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","(Judasi heka iny aõkõ mahãdu luu aõkõ rare. Erydỹỹna mahãdu nieru rubudỹỹdu tii rare. Kia nieruõ tahe ixideele ritosinymyhỹre. Tai tahe aderòna òwy ixidee ributunykemy idi ratximyhỹ). ");
INSERT INTO kpjNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tahe Jesuisi rarybere: —Ixinamy wawatyre ritxiwike, wahãloo‑ò waherina heka riryrymy tuu ritxiwireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kaiboho heka aõu biwiòhenanymy ahãbenyke iny aõkõ mahãdu awanareny dori rarehyymy rarekre. Jiarỹ tahe kaki aratxihyyke aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Judeu mahãdu Jesuisi rehemynyreriò roholare. Tahe sõwemy iny tamyreny nade itxeremy. Tule Lazaru‑ò itxeremy nade rubu‑ribi rexixareki. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tai tahe xiwewahidỹỹdu mahãdu wedu tule Lazaru rubudỹỹmy rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lazaru òraru‑ki dori sõwemy judeu wedu Jesuisi rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Itxubiòwau tahe Jesuisi nade Jerusalẽ‑ò kia‑ò tahe roholare ibutumy worana bedehesi ludu mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tai tahe roirenyre tii‑wana witxi reakemy horeru riwyre ityre‑di kanakre. Ryryrenyre Jesuisi‑ò: —Waiòlòreny, kai arawowydynyreri, kai bedeòbydỹỹdu tateki! Kai Deuxuni‑di tateri. Kai judeu Iòlòtyhy tate. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesuisi nade jumenta riòre tyre‑ki, tuu dori ihetxina tyyriti‑ki roire wesemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Kiamy wahe roire: —Judeu riòre mahãdu uritere brebuõmy atximahãbeny aiòlòreny dori kanakre jumenta riòre tyre‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Iery mahãdu kia rieryõhyyre juhuu. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iribi tahe tõhõti itxi reare ritidỹỹna hetxina‑ki roiremy, Jesuisi biu‑txi ròòsemy rareu wahe tõhõtireny itxi reare. Tule sõwemy iaõmydỹỹnana rybe hetxina‑ki riritinymy rỹimyhỹre. Kia‑di tahe idi tõhõtireny reare. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Inyõ itxeredu heka Lazaru ixixanamy relyyre. Tai tule iny sõwemy doidenyde. Kia Jesuisi riwinyreò heka roholarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tai tahe fariseu mahãdu widee raryberenyre: —Ibutumy ihemy roirenyre. Timyõre, aõhe heka rikisỹnyrenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Inyõ worana bedehesi‑ki grego rybedu mahãduõ ratximyhỹ. Tii tai Deuxu reàlàkemy ratximyhỹ. Tii Besaida hãwã ludu‑ò Kalileia bede luduõ ratximyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tahe grego rybe mahãdu tamy rarybere: —Wanyrỹ, jiarỹboho, Jesuisimy arobikemy watxirenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipi tahe Andre‑ko relyyre. Ta wiwana roirenyre Jesuisi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesuisi rarybere: —Aõkõra, Wabededỹỹnana iòhòra Deuxu Riòre Hãbutyhyhykỹ rubuna‑ò, wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Inatyhymy adeereny ararybekre: —Jiarỹ alòbòròna rijuxunymyhỹre wesemy aresekre suò, arurukremy. Aruruõkeki ixiwanahyyle ararekre. Arurukre‑wana sõwemy araratynykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Inyõ ixiluukeki heka, ruruke. Kabede‑ki tahe ixiluuõkeki, tii rexiywinymy umytuedeõna‑ò ratxike. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Inyõ wadeòdumy ratximyhỹkeki, tii riwaheludunyke. Tai titxibo aratxikeò tii wawana ratximyhỹke. Inyõ wadeòdumy rareke‑wana, tii Waha riwowydynykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Katahe wabedewonihikỹmy watxireri. Timybo ararybekre, Waha, kia rubu aõmydỹỹnana‑ribi biwatake. My òsana arexitòenykre. Aõkõre, kiaòle heka kabede‑ò anade. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Waha, anityhy‑ò iny riwowydynykemy watxireri. Iule tahe rybeõ‑ò roholarenyre: —Kia rotỹỹnyre ihãre ta ixityre tuu rotỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tahe iny sõwehekỹ kia rybe‑ò roholare. Tahe rarybere: —Biumytxyle rare. Tahe ijõ rarybere. Aõkõre ỹju rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tahe Jesuisi rarybere: —Waòraru‑ki aõkõ kia rybe rỹireri, aõrarureny‑ki, tamy boholabenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Wiji tahe ywisidỹỹna kỹnyikre, bedemy iny rỹira mahãdu‑ò. Kia mahãdu iòlò, Satanasi, kanahitxidỹỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iu jiarỹ itxeò‑ki riwaukokreu, ibutumy iny heka ixidee adiwiutàdànykre riwatyhynykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iu tii kia rarybereu, tarubuna ritỹnynyre timybo rurukre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Iny sõwehekỹ dirawyònyde: —Jiarỹboho raholarenyre bede ywina‑ò. Tii rarybere: —Tiiemy Kristu rarehyymy rarekre. Timybo kai tarybeteri: —Biwaukokremy. Mobo tahe Deuxu Riòre Hãbutyhyhykỹmy tuu tarybeteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tahe Jesuisi dirawyònyde: —Urihimyòle loosòna awana rariamy ratxireri. Idi atxiteriule idi mariake, bede luru atxi kanakelau. Inyõ bede luruki rariakeki, tiobo rake rieryõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Waloosòna atxiteriule, biwatyhynyke waloosònamy, taile waloosòna mahãduõmy boibeke. Kiarybe rahu‑di tahe Jesuisi iribi rexitamy rexiwore. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tii sõwemy bedeòtiidỹỹna ikoreny‑txi riwinyre. Ihãrele tahe sõwemy rityhynyõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kia tahe Isaia tyyriti‑ki roire, tahe iwesele tuu rarybere wese wiji rỹira rotỹỹnyre: —Wanyrỹ, Iny rybe tỹnydỹỹnareny tiiboho rityhynyõhyyre, Deuxu taruru tamy riteòsinyrehãrele rityhynyõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tai rityhynyõhyyre. Isaia, Deuxu rybedu ijõmy ròritidỹỹre: ");
INSERT INTO kpjNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","—Deuxu riruetànyre, irayky riteredỹỹnyre. Tai rieryõhyymy robiõhyymyhỹre. Tiu heka Deuxu rityhynyõhyyre. Tiu riteytenyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaia Jesuisi loosònamy robire. Tai tahe tuu ròritidỹỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ihãrele tahe dohodỹỹna mahãdu wedule sõwemy rityhynyre. Urile fariseu mahãdu òrarukile, ijõ‑ò tuu rarybeõre, dohodỹỹna mahãduy‑ribi riòlòdỹỹnyheny. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tiiboho dori Deuxu wowydyna luurenyõre inywowydynale luurenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","—Iny riwatyhynymyhỹkeki, wadeòdỹỹdule rityhynymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Inyõ wamy robikeki, iule wadeòdỹỹdumy robike. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Jiarỹ loosòna wesemy anade bede‑ò. Tai tahe iny riwatyhynykeki, bede luru ribi ròhònyke. Tai heka anade. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Inyõ warybe‑ò roholake hãrele riywinyõkeki, tahe jiarỹ tii wiji ariywidỹỹnyõke. Jiarỹ dori tarasaduhyylemy anade. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Inyõ riwatyhynyõkeki, warybe‑ò roholaõkeki, ikonana txuu tahe ywisidỹỹna‑ò ralòke, warybe‑ò rityhynyõmyhyreki aõhõkỹmy dỹỹnana‑ò heka kia ralokre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Jiarỹ ixi rayky‑ribi aõkõ rarybemahãre. Wahale rybe wadee riwahinymyhỹre. Kia wesele relyymahãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Deuxu rybe bede ywina‑di diwateònyde umytuedeõna wahidỹỹna kia rare. Kiale heka reeryre. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","3","Pascoa worana bedehesi txumy txuu rỹire. Tahe Jesuisi rexieryre ixyby tyby‑ò ròòsekremy ihỹre, ibededỹỹnana iòhòmy roireki. Tule rexieryre tyby ibutumy tamy riwahinyremy. Tii tyby‑ribi nade tule ixybyle tamy rakemy. Txioro roxinau Jesuisi taerydỹỹna mahãdu‑wana riroximyhỹreny. Judasi Isariò (Simaõ riòre) taile ratximyhỹ. Juhuu diabo tamy rarybere iruule Jesuisi rityhenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jesuisi sõwemy taerydỹỹna mahãdu luure. Tai tahe rỹire, tatyytyre ludu ritare òsuròna rimyre, idi rexiwetyataare. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Hynaro‑ò bee ritxiwire taerydỹỹna mahãduwaa risuhokremy tahe òsuròna‑di tawetya‑ki ihỹmyhỹ‑di iwa rirubudỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tahe Jesuisi rehemynyre Simaõ Pedro‑ò, Pedro rarybere: —Aõkõre kai wawareny suròdòõmyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesuisi rirawyònyre: —Kai heka teeryõte aõherekibo resuhòreri. Ihewo‑ribi tahe bierykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro rarybere: —Aõkõre, wawasuròdòdỹỹõmy. Jesuisi rirawyònyre: —Arisuhòõkeki wawanahyy aõkõ mabeke. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pedro rarybere: —Wawasohojile aõkõ bisuhokre, wadebò warati‑wana tule wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tahe ritỹnynyre Jesuisi; inyõ rõhõre‑wana iwale rasuhòke. Iuhe ibutumy tyralemy rỹimyhỹre. Kaiboho yralemy toite. Sohoji tahe aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesuisi tatyhedỹỹdu rayky rierymyhỹre. Tai tahe rarybera, ibutumy aõkõ tyraremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesuisi iwasuròdò rexihureu, tatyytyre ludu retyynyra roxina‑ò ròòsere. Tamyreny rỹỹraxire: —Kaiboho teerytenyte. Aõhebo jiarỹ kia ratỹỹnyra. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Adeereny aritỹnynykre. Kaiboho tiwaninitenyte anyrỹmy, aõhe inatyhy? Aerydỹỹdumy, inatyhy heka jiarỹ rare tahe òbitimy tarybetenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jiarỹ aerydỹỹdureny anyrỹreny heka awareny resuhore. Tai tahe kaiboho wiwa bisuhòbenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iwese jiarỹ rexideòsinyre wese kaiboho biwinybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Inatyhymy adeereny ararybekre. Deòdu dori tawedu ratyre aõkõ rare. Rybe‑ò ijohonadu dori rybedutyhy ratyre aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kia warybe teerytenyte. Tahe biywinybenykeki bedeòbynatyhy adeereny kanakre. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ibutumy umyreny aõkõ rarybereri jiarỹ araeryrenyre, aratarenyreki, wahe. Rybe tyyriti‑ki roire kiamy: —Kia wawana riroximyhỹrele heka riwatyhenykre. Ele elemy tuu rotỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Wiji rarybereri heka wylemy kia tuu rotỹỹnykre. Tuu rotỹỹnykreule, kaiboho bierybenykre òbitimy raryberé wahe; jiarỹ biwatyhynybenykemy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Inatyhytyhymy ararybekre: —Inyõ adee aditeònykre. Inyõ tii rityhynymy kididykeki, tii riwadymyhỹre. Inyõ kidiwadykeki wadeòdỹỹdu ridymyhỹre, Deuxu rityhynymyhỹre wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tahe Jesuisi rabedewonihikỹmy ronymyhỹ. Tahe rarybera: —Iny sohojiõ ayreny‑ribi riwatyhenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tahe wii riijeriijerenyre. Mokobo rarekremy rõhõtinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jiarỹ, Joaõ Jesuisi weribi ranywỹhỹ, tii dori sõwemy waluure. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tahe Pedro wadee narybewasidi: —Tamy inihe myỹraxike mobo raremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tahe jiarỹ retorunyre: —Wanyrỹ, mowexe ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesuisi rarybere wadee: —Kia orotxu ituudỹỹ tamy ariwahinykrele tiikre. Tahe Jesuisi orotxu yre rituunyre idi tahe Judasi Isariò‑ò riwahinyre. Tii Simaõ riòre rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tahe Judasi riyre. Iribi tahe Satanasi aõwesele tamy ralore. Jesuisi heka Judasi‑ò rarybere: —Aõhebo botỹỹnykre wylemy makre biwinykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tahe riroximy rỹimyhỹ mahãdu rieryõre aõmybo Jesuisi rarybemyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judasi Isariò dori nieru hyna yrubudỹỹdu heka rare. Tai tahe rõhõtinyrenyre Jesuisi worana bedehesi aõna aõna riwykemy riteònyre, ada iny aokõdu mahãdu‑ò nieruõ riwahinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasi orotxu yre riymy rahudi tahe ròhònymy rare bede luru‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judasi ròhònymy rahudi tahe Jesuisi rarybere: —Wiji tahe Deuxu Riòre Hãbutyhyhykỹ loosònamy iny robimyhỹre taraykywo‑ki. Tii heka jiarỹ rare. Deuxu‑ò waòraru‑ki wowydyna riwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Deuxu loosònamy tahe waki iny robikeki, Deuxu riwatoosònyreri aõwesele ibutumy iny tuu robike. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Waluudu mahãdu wariòre wesemy atximahãtenyte, umywanareny urihimyòle ararekre, idi tahe arakre. Tahe biwaijebenyhãrele waki mahabenyõtyhy. Iwese judeu mahãdu‑ò rarybere wesele adeereny ararybekre: —Titxibo arakre‑ò kaiboho boibenyõke. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Bede ywina tỹmyra wese adeereny ariwahinykre kiamy wahe: —Wiluurenykemy wahe: —Iwese jiarỹ aluurenyre wese tule kaiboho wiluurenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wiluurenykeki ibutumy iny rieryrenykre kai waerydỹỹna mahãdumy tate. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tahe Simaõ Pedro ritỹỹraxinyre: —Wanyrỹ, titxibo kai makre. Jesuisi dirawyònyde: —Titxibo arakre‑ò wiji kaiboho boibenyõke, iribi tahe wahemy bodoikre. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tahe Pedro rarybere: —Wanyrỹ aõherekibo araõkre wiji ahemy waumy kie aõraru‑ki ariwahinykemy watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Inatyhymy aõbo aumy biwahinykre waòraru‑ki. Inatyhytyhymy ararybekre: —Hãnie hãbu robukõule kai biwatxiõnykre inataõmy. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kaiboho bedeòtiidỹỹrenyõmyke bedewona‑ki. Kaiboho Deuxu tetyhynytenyte, tai tahe biwatyhynykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wahasỹ‑ki sõwemy sỹỹ rỹimyhỹre kialemyre heka tai. Kaweseõkeki adee inatyhymy rarybemahãre. Jiarỹ tahe arakre sỹỹ adeereny ariwinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ariwinymy arahudi tahe ixybyle aòrysymy adòòsekre. Tahe aradyrenykre titxibo‑txi aratxireriò kaiboho tule matxibenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kaiboho dori teerytenyte titxibo wasỹry roire. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tahe Tome rarybere tamy: —Wanyrỹ, titxibo makreò reerykõrenyre. Tai tahe timykibo asỹry reeryrenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesuisi dirawyònyde: —Jiarỹ wa ryy rare. Deuxu inatyhyna jiarỹ rare. Umytuedeõna wahidỹỹdu jiarỹ rare. Inyõ waòrarukile Waha dee rakre. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kaiboho tiwaerytenyte‑wana tule Waha teerytenyte. Wiji tyhyule Deuxu teerytenyte, tuu tabitenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Idi Filipi rarybere: —Wanyrỹ, boo inydee biteòsinyke, tai tahe awike. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tahe Jesuisi rarybere: —Filipi, sõwemy bededỹỹnana umy‑wana rewyre. Ihãrele tahe tiwaeryõte. Inyõ wadee kanakeki, Wahamy robike. Aõherekibo wadee tarybeta boo wadee biteòsinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Jiarỹ Waha‑ki watxiwãhãre tule Waha waki ihỹre. Kia aõbohe tetyhynyõte rarybewãhãre, kia iximy aõkõ rarybewãhãre. Waha waki ratximyhy tii taõmydỹỹnanamy rotỹỹnyre waumy‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Waha‑ki watxiwãhãre, tule tii waki ihỹre, kia bityhynybenyke. Aõwiwihikỹ rewinywãhãre òraru‑ki biwatyhynybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Inatyhytyhymy adee ararybekre: —Inyõ riwatyhynykeki, wawesele aõwiwihikỹ riwinykre. Tahe watyreleaõ riwinykre. Jiarỹ dori Waha‑ò arakre. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tai wanimy aõmy bexitòenybenykeki, tii tahe ariwinykre. Iny Waha‑ò wowydyna riwahinykemy idi watxireri, iRiòre wahe jiarỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tai aõma wani‑ò bexitòenybenykeki, tii tahe riwinykreadeereny. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Inyõ waluukeki tii wabede ywina riywinytyhyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Waha‑ò arexitòenykre ijõ wiòhedỹỹdu adeereny kiditeònykremy waderòwymy. Tii aõu aõu adeereny hyyle rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tii Deuxu Tyytybytyhy rare. Tii inatyhynamy rieryrenyre, iny bede bede mahãdu wahe. Deuxu Tyytybytyhy ixidee ridykemy. Tuu dori robiõtyhy rieryõtyhy. Kaiboho tahe teerytenyte. Tii dori umywanareny ratximyhỹre, aworeny‑ki ratxikremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Jiarỹ heka ixisohojimy ararisidỹỹnyõtyhy. Jiarỹle adee adoosekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wijile arurumy arakre bede‑ribi. Bede bede mahãdu tiu wamy robiõtyhy. Kaiboho tahe wamy bobilebenykre, jiarỹ dori ixityre rubu‑ribi adexixamy ararekre. Tai tahe tule kaiboho rubu‑ribi bexixamy boibekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kia txuu kaiboho bierybenykre jiarỹ heka Waha‑ki watxiwãhãremy. Kaiboho tasỹ waki ahãtenyte. Jiarỹ tule akireny watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Inyõ wabede ywinareny dikeki tahe, riywinykeki, waluudu rare. Waha tule iluukre. Jiarỹ tule iluutyhyre. Tamy tule arexideòsinykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judasi tamy rarybere: (aõ Isariò aõkõ kỹny, iwitxiraõ.) —Wanyrỹ, aõhekremybo wadeereny bedexideòsinykre tahe bede bede ludu mahãdu‑ò aõkõ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesuisi rarybere: —Inyõ waluukeki, wabede ywina riywinytyhyke. Waha, heka iluutyhykre. Jiarỹboho tamy adoidenykre tamysỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Iny waluuõkeki, warybe tiu rityhynyõtyhy. Aõ warybe‑di aõkõ heka rarybereri. Waha wadee riwahinyredi heka rarybereri. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tai arakrekoki tuu rarybereri adeereny. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tahe Deuxu Tyytybytyhy, awiòhedỹỹdu, tii araerynanykre ibutumy aõna aõnamy. Timybo jiarỹ adeereny raryberemy akananohõtiijaranydenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ywina adeereny adiwahinykre waywina wahe. Iwese bede bede ludu mahãdu riwahinymyhỹre wese aõkõ ariwahinykre. Uritere nohõtiyreõmy brebuõmy. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Rarybere dori arakremy tule adoosekremy. Waha waratyre rare. Tamy he arakre. Kaiboho waluukeki, beysabenykre tamy arakreu. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kaa bede reakoki tuu rarybereri. Tuu reakreu tahe, kaiboho biwatyhynybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sõwemy heka adeereny ararybeõkre, bede dinodu dori tehemynysỹ iòhòmy ihỹre, Satanasi wahe. Tii heka wadee iruruõhyyre, riwateònyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Jiarỹ Waha luure. Rewinywãhãre aõbo Waha ariwinykemy riwateranymyhỹre. Botamanyke: —Ròkòirenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Hãjutò òwòna wese wihikỹ jiarỹ rare. Waha tahe bede rade wysydỹỹdu wese rare. Bede òbebure iratyõkeki iò riòròke. Iratydikeki iòsõmo iribi risihere. Tai tahe sõwetyhymy nihikỹmy raratynyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kaiboho bede rade‑ò wesemy toite. Warybe‑di aòsõmoreny aribireny resihemahãre. Katahe òbitimy toite bederatymy raratynykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","4","Kaiboho biwamymy wadi myikre. Iwese bede radeõ raòròõmyhỹkeki irulemy rỹikre raratynyke. Aõkõkeki ruruke. Kaiboho iwesele toite. Waki beàrenyõbenymyhỹkeki, tiu Deuxudeewimy atxibenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Jiarỹ hãjutò òwòna wese rare. Kaiboho ibede radeò wese toite. Waki beerenybenykeki, jiarỹ aki ararike, tai bederaty wese sõwemy maratynyke. Wahoõkeki tiu aõ biwinybenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Inyõ waki rariõkeki, iwese iny bede rade rubu‑di rahuleke, tii iwesele inyõ rahukre. Juhuu rimyre, idi heòty‑ò rehure, tai roomyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kaiboho waribi boibenyõkeki, warybe õhõti‑ribi rosaõtyhykeki, aõtaxina wadee bexitòenybenykre, tai ibutumy adee ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Iwese bede rade sõwemy raratynymyhỹre wese, kaiboho, aõna aõna wiwihikỹ biwinybenyke Deuxu dee. Kiakeki tahe Deuxu deàlàna sõwemy ritakre. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Iwese Waha waluure wese jiarỹ aluurenyre waluuna‑ribi boibenyõke. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wabede ywina inyõ riywinykeki, tii waluuna‑ribi raõtyhy. Iwese Waha bede ywina reywinymyhỹre wese tahe Waha luuna‑ribi jiarỹ tiu rahònyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Wadeysana awo‑ki ratxikemy jiarỹ adi watxireri. Eysana sõwemy mabekemy adi watxiwãhã. Tai tahe warybe adee rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Wabede ywina heka kaa rare: —Wiluukemy. Iwese jiarỹ aluure wese wiluurenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Inyõ taery dee rurukeki taluunadireki, tii luunatyhy ijõdire. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kaiboho wadeewi biwinybenykewana tai inatyhymy wabiòwa toite. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tahe aõ wadeòdumy aõkõhe araninirenykre. Kaiboho wabiòwa toite jiarỹ dori Waha‑ribi raholare adee tuu relyywãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kaiboho tahe tiwatatenyõhyyte, jiarỹ tahe aratarenyre kaiboho boibenykemy. Sõwemy aõna aõna wiwihikỹ botỹỹnybenyke. Tule kia aõna aõnamy tule roihyykemy. Tai tahe aõmy Waha‑ribi wani‑di bexitòenybenykeki, adee riwahinyhyy rareke. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wiluubenyke: —Kia tahe wabede ywina adeereny adiwahinyde. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Bede ludu iny mahãdu eramy reakeki myỹ uritere nohõtiõmy juhuu dori waderamy waluuõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kai bede ludu iny tate‑wana iny aluuke, tahe aõkõre. Tai tahe iny eramy reamyhỹre. Bede ludu mahãdu ribi jiarỹ aratara. Bede ludu mahãdu aõkõ tate urenana. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Adee heka rarybere aõmybo. Uritere iribi nohõti lusaõmy kia wahe: —Deòdu tawedu ratyre aõkõ rare. Tai wadee aõbina binamy iny rotỹỹnymyhỹre. Adeereny tule aõmy rotỹỹnykremy wahe. Tiiboho warybe riywinyrenykeki, arybe tule tiiboho riywinyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kia tahe adee ratỹỹnymyhỹre wanimy rybe òraru‑ki, tiiboho dori wadeòdỹỹna rieryõreki. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tuu ararybeõre wana inihe tiiboho òrarudiõhyyrenyre. Katahe rarybere tai tahe tiiboho rarybeõtyhy rieryõremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Inyõ waluuõkeki, tule Waha luuõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jiarỹ heka ibutuko‑ò wowydyna iitxerenarenymy rewinyõrewana, tiiboho iòrarudiõhyyre inihe. Tahe rewinymahãre, tuu robimyhỹrenyre, ihãrele tahe waluuõre tule Waha luuõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kiamy heka rotỹỹnyre bede ywina ritidỹỹna‑ki roireki. Tai heka tuu rotỹỹnymyhỹre. Kiamy wahe ritidỹỹna‑ki roire: —Tii heka bede òraru aõkõ rare, ihãrele tahe iluuõrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Deuxu Tyytybytyhy adee ariteònykre. Tii, wiòhedỹỹdu rarekre inatyhynamy rierynanykre. Tahe, tii kedehemynykreu wamy rarybekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tule kaiboho wamy marybebenykre, wawana hyy ahãtenyteki. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Kiamy adee rarybemahãre òraruna‑txi ixeõkemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tiiboho heka anatakre tohodỹỹna hetowo‑ribi. Kobe, bede dỹỹnana iòhòmy kadeakreu inyõ anarubunykeki, kia Deuxudeewimy tuu konohõtinykre. Tii Deuxu wiòhedỹỹdu raremy ixi‑di kõnohõtinykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tiiboho Waha rieryõhyymyhỹrenyre tule riwaeryõmyhỹre. Tai tahe kiamy adeereny rotỹỹnymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Iu adeereny aõmydỹỹnana kedehemynykreu, õhõtireny itxi reake timybo adeereny relyyretxi. Tiu heka tuu rarybeõhyyre, umywanarenyhyy dori wãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Katahe arakre wadeòdỹỹdu‑ò. Kaiboho bỹỹraxibenykekõ aõbo tiobo arakre‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kaiboho heka tabedewomy toite kamy rarybereriki. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ihãrele tahe inatyhymy adeereny ararybekre: —Adeereny awikre arakreki wahe. Jiarỹ araõkeki awiòhedỹỹdu, Deuxu Tyytybytyhy kanaõkre. Arakeki tahe tii aditeònykre adeereny. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Iu kanakreu, tii inydee kiditeòsinykre irayky binadiremy, iòbitina‑di aõkõremy, iòrarunadiremy. Deuxu dori òrarudu riywisidỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Taòraruna ixidee kiditeòsinykre tiiboho riwatyhynyõrenyriki. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tahe ixidee kiditeòsinykre. Jiarỹ iratyre waòbitina direki. Waha‑ò dori arakre, wamy bobibenyõtyhykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Deuxu ixiywisidỹỹna ixidee kiditeòsinykre kabede dinodu dee rarybere tii rexihukremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Jiarỹ heka sõwemy adee ararybekemy watxireri, ibutumy tahe isiramy ixidee boholabenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Txiòhe rare. Deuxu Tyytybytyhy kanakreu, inatyhymy adeereny rarybekre inatyhyna‑di ibutumy. Tarybe‑di tahe rarybeõkre. Deuxu‑ribi aõmybo roholaremy tahe rarybekre. Tule timybo aõna aõna rarekremy kanarybekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tii waaõmydỹỹnana adeereny ritỹnynykre. Tai kidiwatoosònanykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ibutumy Wahahõrõ heka wahõrõ rare. Tai heka tuu adeereny rarybereri waaõmydỹỹnana adeereny kiditỹnynykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Urihimyò riòre heka waõkre, idi tahe ixityre wamy bobibenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tahe ijõ ierydỹỹna mahãduõ widee rarybere: —Timybo tii rarybere: —Urihimyò iõkremy tii rarybereri, tule ixiryre wamy bobibenykremy. Tule Waha‑ò arakre. Timybo heka rieryrenyõhyyre aõmybo rarybera. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","19","Tiiboho Jesuisi‑ò rỹỹraxirenykremy ratxirenyreri. Tahe Jesuisi rierymyhỹre tuu rỹỹraxikre. Tahe Jesuisi tamyreny rỹỹraxire: —Kaimy ixidee tỹỹraxitenyteri. Wananamy waòkesenalemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Inatyhymy adeereny ararybekre: —Iny bede mahãdu urile reysakre, kaiboho tahe araeryrenyra urile mahinybenykre, birajuabenykre, mabedewobenykre. Idi tahe kaiboho beysabenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Iwese hãwyy iijera iòhòreki, rabedewomyhỹre, taaõhõkỹmydỹỹnana‑di rõhõtinymyhỹre. Idi tahe reamyhỹre. Iu tahe tõhõti rosamyhỹre tohouã tỹmyradile reysamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Iwesele kaiboho mabedewobenykre, ixityre wamy bobebenykreu tahe, kaiboho beysabenykre. Inyõ heka deysana aribireny ritaõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kiatxu tahe uritere watỹỹraxidỹỹõmykre inatyhymy adeereny rarybereri. Waha‑ribi aõmy bexitòenybenykeki. Tii adeereny kidiwahinykre wani òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tiu heka aõmy texitòenytenyõmahãte wani‑di. Bexitòenybenyke, tai bitabenykre. Tai tahe kaiboho beysabenykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ibutumy rybewòtemy adeereny rarybewãhãre wahe. Idi tahe tuu adeereny ararybeõkre. Idi tahe itỹnytyhymy Waha aritỹnynykre adeereny. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kiatxu tahe bexitòenybenykre wani‑di jiarỹ ararybeõkre umyreny Waha‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Waha dori aluurenyre, kaiboho waluurenyreki, Deuxu‑ribi anade tetyhynytenyteki. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Waha‑ribi anade, bede‑ò adehemynyde ihãrele bede‑ribi arakremy Waha‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jesuisi ierydỹỹna mahãdu rarybere: —Wiji tahe itỹnytyhymy tarybeteri. Rybewòte‑di aõkõ tarybeteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kai ibutumy teeryte. Inyõ dỹỹraxiõmy adee. Kai inatyhymy Deuxu‑di tanate. Kia jiarỹboho retyhynyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tahe Jesuisi tamy rỹỹraxire. Inatyhymy wijityhyle tetyhynytenyta. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wabededỹỹnanamy heka reara. Kaibohoõ sohoji sohojimy tasỹ tasỹ‑ò rakre. Biwaribenykre ixi sohojilemy arỹikre. Tahe ixi‑wana aõkõ watxikre, Wahawanale arỹikre. ");
INSERT INTO kpjNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kaheka aõna aõnamy adeereny rarybere ywina‑di araykyreny‑ki boibekre. Bede‑ki kaiboho aõhõkỹmy botỹỹnybenykre. Ihãrele beysabenyke, Jiarỹ heka Deuxu òludu mahãdu‑di ròtara. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesuisi rarybemy rahudi tahe retehere biu‑ò rarybere: —Waha, wabededỹỹnanamyhe reara. Ariòre watxiwãhãre. Wowydyna wadee biwahinyke tai tahe adee wowydyna adee ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kai, Waha, ibutumy wadee ruruna tewahinyta iny deòdỹỹnamy. Tai umytuedeõna ariwahinykre biu‑ò hedu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kia heka umytuedeõna rare: —Deuxu inatyhy tate sohojihyy tate. Tii araeryrenykeki tahe eòdỹỹna Jesuisi Kristu rieryrenykeki. Kia umytuedeõna rare tamyreny. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Aõ aõmysỹdỹỹnabo wadee tewahinyte, ibutumy adee rewinyre. Tai heka arawowydynyra kabede‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Iu bede rexidelenyreu umywanahyy rarewãhã. Sõwemy loosòna nihikỹ‑di rawãhãre. Tahe wiji, Waha, kia loosònale ixityre bidiwahinykre umywanahyymy ararekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kai iny mahãduõ wadee tewahinyte bede mahãdu‑ribi. Tamyreny umy rarybemahãre. Juhu tiiboho ahõrõ roire. Idi wadee tewahinyte. Tiiboho arybe riywinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ibutumy waaõmydỹỹna aribi retamahãre. Kia heka wiji tiiboho rieryrenyra ibutumy aribi nade. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Aõrybebo wadee tewahinytamy tamy rarybemahãre. Tiiboho rityhynyrenyre, rieryrenyre aribi jiarỹ anade, kai wateòdỹỹdu tate. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iòraru‑ki adee rexitòenyre. Tiiboho amahãdu roire. Wadee tewahinyte, bede mahãdu‑ò raru‑ki aõkõ adee rexitòenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ibutumy wahõrõ, ahõrõ rare. Tule ahõrõ, wahõrõ rare. Tai heka iny mahãdu riwatoosònanymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Jiarỹ adee arakre tai kaki arareõkre. Tiiboho heka kaki rarirenykre. Tiiboho biyrubunykre, Waha, ani òbiti‑di biyrubunyke, wadee tewahinyteki. Tai tahe iraykyreny wiwesehyymy roirekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tiiboho‑wana rarewãhãu ani òraru‑ki reyrubunymahãre, wadee tewahinyteki. Timy heka reõnonyõhyyre ijõ, sohojile tahe reõnonyre. Juhuu dori Ritidỹỹna roire ijõ sohojiõ ariõnonykremy. Ihyy tahe reõnonyre, Judasi Isariò õnodỹỹduhyymy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ka tahe arakre arora‑ò. Tii heka inyõ rarybemahãre ibutumy wadeysana iworeny‑ò ralòmyhỹkemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Jiarỹ arybe tamyreny rewahinymahãre. Bede mahãdu iny dori terarenyre, tiiboho bede mahãdu iny aõkõ roireki. Iwese jiarỹ bede ludu hãbu aõkõ rare wese. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Bede‑ribi tarasamy aõkõ heka adee rexitòenyreri. Urile ibina bina widỹỹ‑ribi biyrubunykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tiiboho tahe wiji ijõ bede witxira ludu roire, iwese jiarỹ rare wese, wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Arybe‑di tiiboho biòbitinyke, tai ahõrõ mahãdumy rarekre. Arybe dori òbitityhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Iwese bede iny‑ò tadiwateònyte wesemy, Jiarỹ tiiboho reteònyre bede ludu mahãdu‑ò rarybekremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tamyreny xiwena wesemy adee arexiwahinykre. Òbitihyymy ararekre, tai tiiboho òbitihyymy roirekremy inatyhyna‑di. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Aõ tamy sohojile aõkõ heka rexitòenyreri. Ibutumy kia rityhynymy rỹirakre‑ò dori rexitòenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tai tahe ibutumy wiwese wesemy rõhõtinyrenykre. Iwese, Waha, kai waki atxiteri wesemy tule aki watxireri wesemy tiiboho iny‑ki roirekre. Tai bede iny mahãdu rityhynykre ateòdỹỹna watxireri urenana. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kai loosòna wadee tadiwahinyte, tahe tamyreny rewahinyre. Tiiboho sohojihyy weselemy roirekremy, iwese iny sohojihyy rare wesemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jiarỹ taireny wãhãre, kai waki ahãte. Tai tahe inyboho butuhyymy rokoirekre. Wii riòbitinymyhỹrenykre. Tai bede mahãdu rierykre tadiwateònyteki. Tule wamahãdu luu tate urenana Waha, iwese waluure wese. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Waha, titxibo ararekre, tiiboho wawanahyymy roirekre, wamahãdumy wadee tewahinyteki. Tai tiiboho waloosònamy robikre. Kai dori bede ihokõule waluure, tahe loosòna wadee tewahinyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Waha òbiti, bede mahãdu araeryõre Jesuisi tahe araeryre. Wamahãdu tule rieryre tadiwateònyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Jiarỹ tiiboho reerynanyre ani‑di. Ihãre ta arierynanykre. Tai aluuna iwese waki ratxireri wesemy taireny rarekre, tule jiarỹ taireny ararekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesuisi rexitòenymy rahudi tahe roirenyre taerydỹỹna mahãdu‑wana Cedrõ beàwe‑ribi kowa ijà‑ò heka reuròrenyre, tahe bederaty oworuro‑ò rirònyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judasi heka Jesuisi tyhedỹỹdu heka ibede rieryre, Jesuisi dori taerydỹỹna mahãdu‑di tamy rahyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tahe Judasi, soldado mahãduõ tadinodu‑wana ributunyre. Fariseu mahãdu‑ribi xiwena wedu wahidỹỹdu‑ribi Judasi soldado yrubudỹỹdu mahãdu rihitxinyre tule xiwena deòdu mahãduõ rihitxinyre tii‑wana rakremy roirenyre. Tahe tamy ritehemynyrenyre tòbòra heòty‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesuisi rexieryre ibutumy aõmybo tamy kodotỹỹnykre. Tahe iny mahãdu‑ò rexidorunyre. Tahe rỹỹraxire tamy: —Mowe teijetenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tahe dirawyònyde: —Jesuisi Nazare hãwã ludu reijereri. Tahe Jesuisi rarybere: —Jiarỹ wa tiile rare. Tahe Judasi ityhedỹỹdu tii mahãdu wanale nade. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesuisi tamyreny rarybereu, tahe rexilòhòrarienyre iribi, tahe suòle reserenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ixityre Jesuisi tamy rỹỹraxire: —Mowe teijeteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Jesuisi Nazare hãwã ludu, tiiboho dirawyònyde. —Rarybera tahe jiarỹ raremy wahe. Tiwaijeteri‑wana tahe biwadyke urile ixinamy waijoi rirahuke. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kawesemy wahe irybe hitxina wadee tewahinyteõ heka tiu reõnonyõhyywãhãre. Jesuisi, kiamy rarybere tamyreny irybe hitxina wesemy ibutumy tuu rotỹỹnykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tahe Pedro tamaydese ritamy reare tahe xiwena wedu deòdu riwotõmonyre. Malòò heka inire. Pedro Malòò nohõti riorore ruruwe‑ribi ludu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesuisi rarybere Pedro‑ò: —Amaydese birutyke. Jiarỹ Waha deewimy aõhebo arotỹỹnykrekõ aõbo wadi tahõtinyteri. Aõhõkỹmy arotỹỹnyõkemy aõbo wadi tahõtinyteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tahe soldadu, tadinodu‑wana, judeu yrubudỹỹdu‑wana Jesuisi rimyre ritaataamy ridyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kia beòra Kaifa xiwena wedu tyhy rare. Anasi iriòre labie rare. Tai tahe juhuu Ana‑ò ridyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifa tahe juhuu judeu mahãdu‑ò rarybere: —Wiji beòramy hãbuõ iny mahãdu òraru‑ki rurukremy rahõtinyreri. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simaõ Pedro inyõ‑wana rare Jesuisi hewomy. Kia Pedro‑wana rare, kia xiwena wedutyhy eryna rare. Tai tahe ralore òtity ijòrore‑di. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro tahe ahanakile rỹire. Kia Pedro‑wana rare. Rohonyre hetowo‑ribi hetoijò‑di itxeredu‑ò rarybere, tahe Pedro ridyre hetowo‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kia ijadòma, heto ijò‑di itxeredu rarybere Pedro‑ò: —Kai Jesuisi erydỹkỹna mahãdunokõ anobo tate. Tahe Pedro dirawyònyde: —Aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tahe soldado yrubudỹỹdu tai rahetòmy rỹimyhỹ, heto ludu deòdu mahãdu‑wana txutàtà riki. Pedro iyrenykile rỹimyhỹ rahetòmy. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tahe xiwena wedu tahe Jesuisi‑ò rỹỹraxire. Aõhebohe aerydỹỹna mahãdu‑wana tadotỹỹnymahãte. Timybohe tebedeerynymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tahe Jesuisi ritỹnynyre: —Ibutumy inyko relyymahãre iwasimy aõkõ heka relyymahãre. Judeu dohodỹỹna hetokile relyymahãre Deuxu dohodỹỹna heto‑wana. Titxibo judeu mahãdu ributunymyhỹremy relyywãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tai aõherekibo wadeele tỹỹraxiteri. Myỹraxike wadee ijohonadu‑ò. Tiiboho ka rieryrenyre aõmybo rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesuisi kia rarybereu, soldadu itxereduõ rihetenyre. Tahe rarybere: —Tu heka rybeõmyke xiwena wedutyhy‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesuisi dirawyònyde: —Jiarỹ ibinamy aõmybo rarybera‑wana, manarybeke tuu. Aõkõkeki, awimy rarybera‑wana aõherekibo tiwahetenyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anasi tahe Jesuisi ridykemy riteònyre tataanadihyyle Kaifa‑ò, xiwena wedutyhy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kowa tahe Simaõ Pedro ratximyhỹre rahetòmy rỹimyhỹ. Inyõ rỹỹraxire: —Kai aõbo ierydỹỹna mahãduõ tate. Tahe rexitxiõnyre. Jiarỹ ijõ aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Xiwena wedu deòduõ Pedro‑ò rỹỹraxire: —Tii heka Pedro ritõhõtiorore ijoiõ rare. Tahe tamy rarybere: —Umy taheka rabire tii‑wana bederaty oworuro‑ki atximahã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro ixityre rexitxiõnyre. Aõwesele tahe hãnie hãbu robure. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Idi tahe Kaifa heto‑ribi Jesuisi ridyrenyre ywisidỹỹna‑ò bede dinodu heto‑ò rudiulere. Tiiboho rirònyõhyyre brebuna‑di rexisunyrenyheny. Rirònyrenykeki, tahe Pascoa worana bedehesi rỹsỹnaõ rirỹsỹõtyhy. Tiiboho dori rõhõtinyre rirònykeki, brebuna raremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tahe Pilato ròhònyre tamy rarybekremy: —Tahe Jesuisimy tamy rỹỹraxire kia hãbumy terajuatenyteri aõhebohe rotỹỹnyra. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tahe dirawyònyde: —Aõbibina binamy rotỹỹnykõhyyra wana inihe aridyrenyõhyyreri. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tahe Pilato rirawyònyre: —Bidyke abede ywina rybe‑di biywinyke. Tahe judeu mahãdu rarybere: —Wabede ywina rybe warubudỹỹmy rybe aõkõ rare. Inyõ heka arirubunyrenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kia rybe tahe Jesuisi rybe wesemy rare. Tii dori iximy rarybere timybo rurukremy. Tai timybo irybe hitxina wesemy raryberemy ibutumy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ixityre Pilato ralore ywisidỹỹna‑ò Jesuisi‑ò rỹỹraxire: —Kai aõbo judeu mahãdu Iòlò tate. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesuisi ritỹỹraxinyre: —Ỹraxina aõbo ahõrõ rare ada ijõ aõbo wamy kia rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tahe Pilato rarybere: —Jiarỹ wa judeu mahãdu aõkõ wãhãre. Aõbinatyhymy aõbo he tewinyte. Judeu mahãdu wadee tiwadyte. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesuisi dirawyònyde: —Waiòlòna hãwã bede ludu aõkõ rare. Waiòlòna kaki ratxikeki wamahãdu wadee raaõbinanyke. Tai tahe judeu mahãdu‑ò riwawahinykemy aõkõ watxiwãhãre. Tahe aõkõre kabede ludu aõkõ Waiòlòna rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato tahe rarybere: —Kai aõbo inatyhy iòlòmy tate. Tahe Jesuisi dirawyònyde: —Kai ka wamy tarybeta. Kia‑ò uludumy anade. Kia‑ò anade, inatyhynamy arelyykemy. Inyõ inatyhynamy luukeki warybe‑ò roholamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tahe Pilato rỹỹraxire: —Aõbo inatyhyna rare. Ta rybe rahudi tahe judeu mahãdu‑ò rarybekemy rare. Tiu kỹny kahãbu‑ki aõ ibinamy tai rahaõhyyra. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Inyõ ariteònykemy watxireri kaiboho wadi tõhõtinyhyytenyteri ka woranabedehesi‑ki. Tahe judeu Iòlò aõbohe ka ribi ariteònykre ywihyyle. ");
INSERT INTO kpjNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tahe ixityre ibutumy ryryrenyre: —Kia hãbu aõkõre, Baraba biteònyke (Baraba heka hãbu debore wasidu rare.) ");
INSERT INTO kpjNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Idi tahe Pilato Jesuisimy rerotiyhyta‑di raòhòtekremy soldado mahãdu riteranyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldado mahãdu edehekỹ rataanadile ira‑ò ritidire, iumy tahe tylỹrehekỹ‑di rityynyre iòlòtyywesekemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tamy rehemynymyhỹre: —Aõherebo iòlòtyhy wesena, tahe rihetenyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato tahe ixityre ròhònymy iny‑ò rarybekemy: —Ixityresỹ adeereny redyreri. Bierybenyke. Aõ heka tai ibinaõhyymy idi retehewãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tahe Jesuisi ròhònyre ede rataana‑di tylỹrehekỹ‑di. Tahe Pilato tamy rarybere: —Kakỹnyhe tiire. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tahe xiwena wedu mahãdu, yrubudỹỹdu mahãdu tuu robireu, ryryrenyre birubunybenyke, itxeò dee bitamadỹỹnyke. Pilato rarybere: —Kaibohole itxeò‑di bitamadỹỹnybenyke. Jiarỹ tahe tai ibinamy aõki rahaõhyymahãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tahe judeu mahãdu rarybere: —Jiarỹboho kỹny wabede ywina renydire. Rurukemy heka tuu bede ywina roireri, tii dori Deuxu Riòremy rexininimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato kia‑ò roholareu tahe, ruberutyhyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ixityre ralore ywysidỹỹna heto‑ò: —Rarybere Jesuisi‑ò, tiribi wexe tanate. Jesuisi rirawyònyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tahe Pilato rarybere: —Bidiwarawyònyõkre aõbo. Jiarỹ warurudire anarubunyke aõbo ada arateònyke aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesuisi rirawyònyre: —Aruru‑di aõkõ tate. Deuxu kidiwahinykekile tahe biwateònyke ada biwarubunyke. Tai tahe adee wawahidỹỹdu aratyre iòraru dire. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tai tahe Pilato iteòdỹỹmy rurure. Tahe judeu mahãdu tamy ryryre: —Kai biteònykeki tahe, Iòlò Cesar biòwa aõkõ tate. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kiarybe‑ò Pilato roholareu tahe, Jesuisi diòlòdỹỹnyde ahana‑ò. Pilato tahe ywisidỹỹna ryna‑ò rexisỹnyre. Kia ubeni heka Rirana Ijàti inire. Tahe judeu rybe‑ki heka Kabata inire. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pascoa worana bedehesitxu sexta feira rỹire. Txutye iòhòmy tahe bede rỹire. Tahe Pilato rarybere judeu mahãdu‑ò: —Betehebenyke aiòlòreny‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tahe tiiboho ryryrenyre. Bidybenyke! Itxeònihikỹ‑ò birubunybenyke. Pilato tahe tamy rarybere: —Aiòlò aõbo, birubunybeny. Tahe xiwena wedu rirawyònyre: —Iny iòlòreny sohojile wa rare: —Cesar heka inire. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tahe Pilato Jesuisi tamyreny riwahinyre rirubunyrenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tiiboho heka Jesuisi ridyrenyre. Iitxeò tamy riwahinyre idi retyykremy. Tahe Kalvariu‑ò idi ridymy rare. Kalvariu heka Kòkòta inire judeu rybe‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tai itxeò nihikỹ dee ritamadỹỹnyre ijõ hãbu inatxiõ‑wana Jesuisi itxeònihikỹ itya‑ki rỹire. Hãbu wiò wiòmy idi rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato riritinyre ritidỹỹna‑ò Jesuisi tyre‑ò ritidire. Kawesemy ritidỹỹna roire: —JESUISI, NAZARE HÃWÃ LUDU, JUDEU MAHÃDU IÒLÒ. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Hãwã‑ribi ireheriòremy roire. Tai tahe sõwemy judeu mahãdu tuu robire iritidỹỹnamy. Inataõ rybemy witxira riti heka inataõmy roire. Judeu rybe ijõre, latim rybe ijõre, grego rybe ijõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Judeu xiwena wedu mahãdu Pilato‑ò rarybere: —Judeu mahãdu Iòlò rarybere: —Iritidỹỹõmyke wa. Kawesemy biritinyke: —Tii rarybere judeu mahãdu Iòlò raremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tahe Pilato dirawyònyde: —Iwese reritinyre wesemy rarehyykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldado Jesuisi itxeònihikỹ‑ò ritamadỹỹnymy rahudi tahe, ityy ritxuatxuakremy diwyde. Inaubiòwa heka riywinyra. Wirarea riwykremy soldado mahãdu idi rỹireri. Iyhyitxena tahe iretydyna‑di aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tahe ijõ widee rarybere: —Iyreyredỹỹrenyõmyke wa urile ta idi rikihurenykre mobo ritakremy. Kia ryberiti‑ki tuhyy roire: —Watyy ritxuatxuare ijõ yre wimy riywinyrenyre. Tule wayhyitxena tyre‑ki rehurenyre mobo ritakremy. Tahe iwese Tyyriti rarybere wese, soldadu mahãdu ibutumy aõhebo risỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Inaubiòwa hãwyy retehemy rỹimyhỹ Jesuisi itxeònihikỹ iòhòmy. Jesuisise taseriòre‑wana, Marie Madalena ijõre, Klopa hãwyy ijõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesuisi tadimy robireu, Joaõ, taerydỹỹna luunadu bire‑ki, tahe rarybere: —Nadi beteheke wa kowa ariòre rare. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tahe Joaõ‑ò rarybere: —Kaa adi rare. Ierydỹỹna Joaõ tahe ridyre taheto‑ò tai rasỹnykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesuisi tahe rieryre ibutumy rexihuramy tahe rarybere: —Ariõkemy watxireri. Kaimy heka rarybere aõbo Ritidỹỹna‑ki roire riwinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tai tahe vĩĩ mona silỹnyhỹkỹ‑ki raharenyre. Tahe Jesuisi‑ò iwereheni wese‑ò rituunymy idi riteònyre iry‑ò teòdimy. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesuisi tuu riõre idi tahe rarybere: —Ibutumy Waha aõmysỹdỹỹna rexihumy roire. Tahe ròtiòròmy resere iule ta rurure. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kia sabadotxu heka worana bedehesitxu nihikỹõ rare, brebuna rare. Tai tahe hãbu rubu itxeò‑ki ririkõkemy tuu rarybemyhỹre. Tai Pilato‑ò judeu mahãdu rexitòenyre hãbuti riòròmy riteònykemy, itxeò‑ribi ritakemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tahe soldado mahãdu hãbuti wiòle riorore. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesuisi tahe rurumy roireki iti riòròõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Soldadoõ tahe Jesuisi‑ki rojyre iweki tahe hãlubule rohonyre bewana. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kia tuu rabire tahe òbitimy tuu jiarỹ rarybere, Joaõ wahe. Waritidỹỹna inatyhy raremy, reeryre. Kaiboho bityhynybenykemy, adireny watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kaheka ibutumy iritina hetxina tuu rarybere heka ibutumy tuu rotỹỹre. Kia wesemy roire: —Iti riòròõkre, sohoji aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ijõ iritinaõ kawesemy roire: —Rirorenykre tõnori‑di idi reteherenykre tamy. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jyje heka Arimatea hãwã luduõ rare. Idi tahe tii Pilato‑ò rexitòenyre Jesuisi umymy rituunykremy. Tii heka Jesuisi heluduõ rare. Judeu mahãdu lau ruberumyhỹ tai Pilato‑ò rare wasimy. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pilato tahe awiremy rarybere. Tahe Jesuisi umy riwyre. Nikodema tule rare Jyje‑wana. Tii juhule rumy Jesuisi‑wana widee raryberele rare. Tii òwòrutyby òwòruòbru‑wana aderòna wesemy diwyde sõwemy, 45 urihixinamy riutxienanyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tahe Jesuisi umy tyky jurarehe‑wana ritỹtenyre aderòna wanahyyle. Kawesemy dori judeu mahãdu iny rituunymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Itxeòalamana‑ribi bederaty oworu iòhòmy roire. Ityi‑ki tahe wabede tamyra roire. Mana hãloo rỹire tai heka moo rawabedenyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tai tahe rawabedenyre iòhòreki, tule judeu worana bedehesina txumy roireki. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Semana juhu ludu txu Marie Madalena rehemynyre wabede‑ò, rudile wahe. Mana ijòtòbòna iraylemy rỹiremy idi retehere. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tahe raijaranyre Simaõ Pedro‑ò, ijõ Jesuisi luunaduõ wahe, Joaõ‑ò, jiarỹle wahe. Tahe wadeereny rarybere: —Wahĩ tahe hãlokowoku‑ribi ritakarenyra. Titxibo ritidira, rekerykõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro tahe ròhònyre, Joaõ‑wana wabede‑ò roire. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wiwana raijaranyre tahe jiarỹ Pedro ratyre raijaranyre tamy. Jiarỹle heka juhu tamy rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tahe rawebesere iwo‑ò itxeremy. Irahanalemy rabire. Ta ralòõhyyre tamy. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Idi Pedro rehemynyre ralore tamy. Tule irahanamy robire. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesuisi rati rasirahana rihitxinymy roire ixiwanale. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tahe jiarỹ juhu rehemynyre tahe Pedro hewomy ralore. Tuu robire, retyhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tiiboho dori ritina rieryrenyre ihãre tahe rierytyhykõlerenyre. Jesuisi rubu‑ribi rexiixixanykemy ritina roire. Tii tahe rierytyhykõlerenyre. Tahe wiji rieryrenyra. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tahe ixyby raòkeserenyre inyhetoreny‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Marie tahe robumy wabede‑ribi iòhòmy rỹire. Rawebesere tahe wabedewo‑ò itxeremy. Inatxi ỹjumy robire iwo‑ki itykyuramy roimyhỹ. Ijõ heka rỹmy ronymyhỹ Jesuisi ratiherina tyre‑ki. Ijõ tahe iwaherina‑ki ronymyhỹ. Jesuisi umy tahe iõre. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tahe ỹju Marie‑ò rỹỹraxire: —Hãwyy, aõherekibo tabureri. Rirawyònyre: —Wahĩ kumy dokuri riwymy ramyhỹre. Rekerykõre titxibo ritidira. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iu rarybereu tahe tahewoòle roosere. Jesuisimy robire rỹimyhỹò. Tii heka rieryõhyymyhỹ tii Jesuisi raremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tahe Jesuisi rỹỹraxire: —Hãwyy aõmybo tabuteri, mobo teijeteri. Bederaty oworu ywidỹỹdu raremy heka tii rõhõtinyre: —Tahe dirawyònyde: —Wahĩ, kai anobo karibi tetakata‑wana wakoku tuu belykyke. Tahe jikarỹ karikorykremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tahe Jesuisi tamy ryryre: —Marie! Marie rokesemy reare riijemy: —Wahĩ, erydỹkỹdu! (Tii hebraika rybe tuu rarybere: —Raboni, wahe.) ");
INSERT INTO kpjNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesuisi rarybere tamy: —Waroorehedỹỹõmyke wa. Waha‑ò dori raõlemy wãhãre tahe arakre. Kai tyhydỹỹdu seriòre‑ò makre tamy rybemy. Jesuisi rarybere kawesemy: —Arakre inytybyreny‑ò, iny Deuxureny‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Idi tahe rarybere erydỹỹna mahãdu‑ò Wanyrỹmy rabira. Marie Madalena relyyre timybo raryberamy. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Semana juhu ludu txuu, txioromy heka Jesuisi erydỹỹna mahãdu wii ributunymy rỹimyhỹ hetowoõ‑ki. Ibutumy ijò ritòbòtòbònyra judeu mahãdu lau brebumy. Jesuisi tahe nade iyreny‑ò rexitỹnynyre. Rarybere: —Ywina araykywo‑ki atxikemy idi watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kia rarybereu tahe tebò rurena riteòsinyre, tawerurena tule riteòsinyre tamy. Iule tahe reysarenyre Jesuisimy robireki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ixyby tamy Jesuisi rarybere: —Ywina araykywo‑ki rarekemy idi watxireri. Iwese Waha diwateònyde wese tule arateònykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iu tahe ribunymy rarybere: —Deuxu Tyytybytyhy tetateri. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Inyòrarunaõ biixãwididỹỹnykeki tule kia òraruna ariixãwidinyke. Tule aõkõkeki, ijõ òraruna biixãwididỹỹnyõkeki, kia tule ariixãwididỹỹnyõke. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tome (Inatxina iniõre) tii waòinatxi reurò mahãduõ rare, tahe tairenyõre heka Jesuisi nadeu. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jesuisi erydỹỹnaõ rarybere: —Wanyrỹmy rabirenyra. Tahe Tome tamyreny rarybere: —Retyhynyõre kỹnyhe. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Semana sohoji bededỹỹnanamy idi rỹire, ixyby wii ributunyre Jesuisi erydỹỹna mahãdu. Iu tahe Tome tii mahãdu‑wana ratximyhỹ. Ijò ritòbòtòbònymy rỹimyhỹ. Tahe Jesuisi nade iyreny‑ò. Tamyreny rarybere: —Ywina‑di araykywo‑ki atxikemy idi watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tahe Jesuisi Tome‑ò rarybere: —Betehe inihe wadebòrurena‑ò ebò inihe tamy biditidike. Tule wawerurena‑ò ebò biditidikre. Itxiõdỹỹõmyke wa, bityhynyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tome tai dirawyònyde: —Wanyrỹ, waDeuxu. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Tahe Jesuisi rarybere: —Tome, kai aõbo biwatyhynykre wamy tabiterikile. Sõwemy deysana inyõ kanakemy wãhãre tiiboho dori wamy robiõre hãrele riwatyhynyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesuisi heka sõwemy aõwiwihikỹbo riwinyre. Ierydỹỹna mahãdu heka kia aõmybo robire. Kia aõmydỹỹnana heka ihoõre kaki iritina‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kaa ritidỹỹna reritinyre Jesuisi Kristumy rare. Deuxu deòdỹỹna rare. Kia bityhynybenykemy wahe, Deuxu Riòre wahe tetyhynyteri‑wana tahe umytuedeõna bitakre, ini òraru‑ki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Iribi tahe Jesuisi rexitỹnynyre Tiberiade ahohokỹ ijà‑ki. Kia wesemyre heka. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ibutumy heka juhu rỹimyhỹ: —Simaõ Pedro, Tome Didimo iniõre, Natanaeli. Tii Kana hãwã ludu rare, Kalileia bede‑ki. Zebedeu riòreboho ijõre, inatxi Jesuisi ierydỹỹnaõ ijõre. Rarekie. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tahe Simaõ Pedro rarybere tamyreny: —Rià teredỹỹmy arakre. Imahãdu rarybere: —Jiarỹboho aroirenykre ahemy. Tahe roirenyre hãwò‑di. Aõhomy aõkõ ruu idireny nade. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tahe bede ratỹnyrau heki Jesuisi ỹnyrakile ratximyhỹ. Ierydỹỹna mahãdu tahe rieryõhyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesuisi ryryre tamyreny rỹỹraxire: —Ijoi moõ rokoreny. Utura aõbo temytenyta? Rirawyònyre: —Aõkõre wa. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kaiboho biterebenyke rurunawe‑ribi taita bimybenykre. Tahe riterenyre sõwemy rautxienyre irià heka ritusinyõhyymyhỹrenyre utura sõwereki. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kia ierydỹỹnaõ Jesuisi luunaduõ rare jiarỹ, Joaõ wahe. Jiarỹ tahe Pedro‑ò rarybere: —Inynyrỹle wa rare. Pedro Jesuisi raramy roholareu, tatyky tawetyamy ritaamy tamy resere, tade hekỹlemy rareki. Tahe resere bera‑txi tamy rakremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ijoi mahãdu rià‑di narurunymy nade utura sõwereki. Tahe 100 urihixinamy ỹnyra‑ribi ratximyhỹreny. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ỹnyra‑ò rejuxunyreu tahe, robirenyre heòtymy obiurawo‑ki. Orotxu tule tai rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesuisi tamy rarybere: —Uturaõ bidiwybedenyke wiji temytenytaõ. Simaõ Pedro hãwororibile rià‑di rarurunyre. Sõwemy heka tai utura nihikỹ rỹimyhỹ, 153 wahe. Ihãre tahe rià raòròõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tahe Jesuisi rarybere: —Manake hewa biroxibenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ibutumy ierydỹỹna mahãdu rieryre tii inynyrỹreny raremy. Tai tahe inyõ rỹỹraxiõhyyre: —Mobo tii raremy. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tahe Jesuisi orotxu rimyre. Tamy riwahinyre. Ixiyrubule utura tamy riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kia tahe ihewotyhymy Jesuisi rexideòsinyre taerydỹỹna mahãdu‑ò, rubu‑ribi dexixade hewomy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Riroximy rahudi tahe Jesuisi Pedro‑ò rỹỹraxire: —Simaõ, Joaõ riòre, kahãbu mahãdu waluure. Kai tahe iratyre aõbo waluure. Tii rirawyònyre: —Kai tiwaeryte, aluure. Tahe Jesuisi rarybere: —Wabudoeni riòre bidiòwenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ixityre rỹỹraxire: —Simaõ, Joaõ riòre, kai aõbo waluure. Tahe Pedro rirawyònyre: —Kohe, Wanyrỹ aluure jiarỹ, tiwaeryta. Tahe Jesuisi rarybere: —Bidyke wabudoeni biòwenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ihewotyhymy tahe Jesuisi rỹỹraxire: —Simaõ, Joaõ riòre, kai aõbo waluure. Iu tahe Pedro rabedewomy ronyre, ixityremy rỹỹraxireki. Tahe dirawyònyde: —Wanyrỹ, ibutumy teeryte aõna aõna. Aluure heka, tiwaeryta. Tahe Jesuisi rarybere: Wabudoeni biòwenyke. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Inatyhymy adee ararybekre. Iu ijoi morõkõmy tatemahãu, ixiwanale texityynymahãte ixidee wimy titxibo tamahãte. Iu tahe mamatuarinykre inywitxira aratyynykre, Ebò biteòsinykre iny arataataanykre tahe inyõ aradykre titxibo noderamy beakreò. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kiamy heka Jesuisi rarybere ritỹnynykremy timybo Pedro rubu‑ò rỹikremy. Tai Deuxu riwowydynykre. Idi tahe Jesuisi rarybere: —Biwaheludunyke wa. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tahe Pedro retehere Joaõ Jesuisi hemy rareriò, Joaõ Jesuisi luumy raremyhỹ. Joaõ ihetxiu Jesuisi‑ò iòhòmy rỹỹraxire jiarỹ wahe: —Mobo iwahisidỹỹdukremy, ihewo ludu roxina rỹireu. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tahe Pedro Joaõmy robireu, rỹỹraxire Jesuisi‑ò Joaõmy. Aõbo he tamy rotỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tahe Jesuisi rirawyònyre: —Tii rurukõlemy adòòsekemy idi watxikeki, timybo tahõtinyte. Adee tahe biwaheludunykekile awike. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ierydỹỹna mahãdu rarybemy raremyhỹ: —Kiamy wahe Joaõ rurukõlemy Jesuisi rarybere. Tahe kiamy aõkõ Jesuisi rarybere. Jesuisi juhuu rarybere: —Tii rurukõòle adoosekre‑wana, timybo tahõtinytenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jiarỹ tahe kia aõmydỹỹnanamy relyymahãre, Joaõ wahe, reritinymahãre. Inatyhymy kia tuu rare, jiarỹ tuu relyymahãre. ");
INSERT INTO kpjNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Sõwemy aõmydỹỹnanamy tahe Jesuisi riwinyre. Inyõ ibutumy riritinykeki, iritina heka bede ritỹxinykre tyyriti sõwekre‑wana.");
INSERT INTO kpjNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Juhuu adee ratyyritinyreu, Teòfilo, relyyre ibutumy Jesuisi aõbo riwinyré, aõmybo bede rierynanyrémy. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Deuxu Tyytybytyhy bede erydỹỹnamy taerydỹỹna woludu mahãdu rierynanyre. Tahe taerydỹỹna mahãdu‑ò bede ywina riwahinyre. Iribi tahe Jesuisi ròòsere biu‑ò. Kia ibutumy juhuu adee relyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Iribi itxeònihikỹ‑ki rurureu, taerydỹỹna woludu mahãdu‑ò rexitỹnynyre hãbu irudilemy. Tamyreny rexideòsinyre sõwetxu‑di rulemy ratximyhỹmy. Inatyhy wa warybetyhy rare, tamyreny rarybere. Rexitỹnynyreu, tamyreny rierynanyre Deuxu Iòlònamy. Txuõ txuõlemy iny inatxiwaitue txumy rierynanymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tiiboho‑wana riroximy raremyhỹu, Jesuisi tamyreny rarybere: —Uritere Jerusalẽ‑ribi ixitarasarenyõmy. Urile Deuxu Tyytybytyhy awo‑ò kanakre xiery, Jerusalẽ‑ribi boibenyke. Deuxu rarybere Tatyytybytyhy kiditeònykremy. Tule juhuu Jesuisi kia rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Deuxu Tyytybytyhy aworeny‑ò kanalokre. Kia ratisebenaõ wesele rare, Deuxu Tyytybytyhy ratisebena. Iwese Joaõ juhuu bero‑ki iny risebenyre wese, kia rare. Kia‑txu tahe, iòhòmy roire. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tahe, juhuu ibutumy wirotyrenyreu, Jesuisi dee rỹỹraxirenyre: —Wanyrỹ, kai aõbo wiji iny Iòlòreny bediwahinyleke inywedureny wesemy ixyby ronykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tahe Jesuisi dirawyònyde: —Waha‑ki ywisidỹỹnatxu doimyhỹde. Tiile rierymyhỹre. Kai aõkõhyykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tahe Deuxu Tyytybytyhy aworeny‑ò kanalokreu, rurunatyhy arayky‑ò bitabenyke. Kia tahe warubu‑ribi waixixanamy belyykre ibutumy Jerusalẽ hãwã mahãdu‑ò, Judeia hãwã bede mahãdu‑ò, Samaria hãwã bede mahãdu‑ò, iribi tahe ibutumy bedekonana bede iny‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tarybe rahudi tahe Jesuisi ixihyy rexidymy raòwònyre biu‑txi. Iõre biuwetyky‑txi. Tiiboho rarirenyre bede‑ribi idi reteherenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Idi retehemyhỹ iòtududỹỹtyhymy. Inatxi hãbumy ityy uramy aõwesele rỹimy reamyhỹre hãbu mahãduko‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tahe tiiboho raryberenyre: —Hãbu, Kalileia bede mahãdu, itxereõmahãbenyke. Jesuisi ka ramyramyhỹre biu‑ò, Deuxu sỹ‑ò. Iwese rarawesele ka ixyby kòdòòsekre. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jesuisi erydỹỹna mahãdu ratximyhỹrenyre Oliveira òwòruraty hãwãlò‑ki. Tahe dòòsedenyde Jerusalẽ hãwã‑ò. Jerusalẽ rehe iribi doide sohoji urihixina rehemy rimyõlemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tahe wii rotyrenyre rorukure ixitòedỹỹmy hetoratyawo‑ki. Kahekani‑di rirana rarekre tai rỹimyhỹrenyre: Pedro, Joaõ, Txiau, Andre, Filipi, Tome, Bartolomeu, Mateu, ijõ Txiau (tii Afeu riòre rare), Simaõ Zelòte, Judasi (ijõ Txiau iwitxira, kia riòre rare). ");
INSERT INTO kpjNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ijõ iny tule tai ronymyhỹ, Jesuisise, hãwyy ijõ ronymyhỹ, Jesuisi seriòre mahãdu tule rorukumyhỹrenyre. Ibutumy rexitòenymyhỹrenyre wiwese wiweselemy rõhõtinymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Ijõ txubiòwamy 120 inymy wii ributunyre ixybyle. Tahe Pedro rỹire kiamy tamyreny rarybere: —Waityhydỹỹdu seriòre mahãdu, iwese Judasi aõhebo rotỹỹnyre wesemy Davi tyyritinamy roimyhỹre. Kiamy wahe: —Jesuisi taòluduboho‑ò ròhònyreu, Judasi tiiboho riwiòhenanyre. Iwese ka tyyritina‑ki roire wesele, inatyhymy ibutumy rotỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasi inybohoõmy raremyhỹ. Tii nieruõ ritare Jesuisi òludu‑ribi tamyreny ridyreki. Tahe kia nieru‑di subutebedeõ riwyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Tahe idi Judasi rexibòtòtaara. Idi tahe tasubute bedero‑txi taratytihikỹle‑ribi resere. Tahe iumy ruare iwona rejuxunyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Iribi ijyy heka ibutumy Jerusalẽ mahãdu‑ò tuu ijyy rỹire. Tahe kia subutebede rininirenyre hãlubu bederomy. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Iòlò Davi kia wese riritinyre tawiunatyyriti‑ki: —Ixinamy iheto rỹike, inyõ taisỹõmy. Ijõ: —Inywitxiraõ teròwymy tai rarekre iaõmysỹdỹỹna rimykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Inyõ tahe teròwymy iaõmysỹdỹỹna rimykremy. Tule rikimyrenyke Jesuisi ixixanamy ijyyduõ inywanahyy rybe ritỹnynykemy. Inyõ Jesuisi sebedỹỹna‑di itxereduõ rikimyrenykre, inyõ tuu robire Jesuisi nonanamy tule rikimyrenyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tahe inatxi hãbumy ritarenyre: Jyje (Basaba inire) Justu iniòrysyna rare, ijõ hãbu tahe Matxia rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Iribi tahe rexitòenyre: —Kiamy heka Deuxu dee raryberenyre: Kai Wanynyrỹreny, ibutumy inyrayky teeryte, Deuxu. Biteòsinyke tibo rikitarenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Tii ritỹxinykre ixihyymy ratximyhỹre mahãdu. Judasi deròwymy rarekemy, Judasi dori iny‑ribi ròhònyre taòrarunaòwydỹỹnamy rare aõhõkỹmy rotỹỹnykemy. Tahe rare tiobo rareò. ");
INSERT INTO kpjNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Wyhy raheto lisina wesemy idi rehure. Kiamy heka riwinyre tibo ròtakemy. Matxia tahe iribi ròtare. Tii tahe ralore waòsohoji reurò erydỹỹnaky‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostemy ninadu lisina kia txumy txuu rỹireu, ibutumy iny rorukurenyre tarynanakile. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aõwesele biu‑ribi wodỹỹõ nade yhynihikỹwesele ibutumy heto‑ò ralore tai rorukumyhỹrenyrewo‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Heòty helỹỹresi wesemy nade. Iny sohoji sohoji tyre resere. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ibutumy iny tykymy heka Deuxu Tyytybytyhy ralòmy rỹire. Ta raryberenyre iwitxira rybemy. Deuxu Tyytybytyhy tamy rybe riwahinyre wese tahe raryberenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Deuxu dee òbitimy hãbu mahãdu noduõ rasỹnymy raremyhỹ Jerusalẽ hãwã‑ki. Judeu mahãduõ ihỹre. Ibutumy bede bede hãwã hãwã‑ribi nade. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kia‑ò roholareu, wii ributunyre ijohonamy. Tahe rexieryõhykyre aõmybo rõhõtinyrè tahe widi bede riòtiinyre iny sohoji sohoji tarybe tarybeòlemy roholareki. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Urile bede riòtiinytyhyrenyre. Tahe raryberenyre deysana‑di: —Betehebeny iny, kowa rybedu Kalileia bede ludu mahãdu ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Timykibo iny ryberenymy rarybereri. Iny sohoji sohoji tarybeòle raholareri. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Kaheka inyboho bede bede ludu roire: Partia mahãdu, Media mahãdu, Elaõ mahãdu, tule ka bede ludu mahãdu: Mesopotamia, Judeia, Kapadosia, Ponto, Asia, Frigia, Panfilia, Egito, Libia Sireni‑wana iòhòre, Roma hãwã luduõ tule kaki ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Timybo inyrybereny witxira witxira‑ò iny roholarenyreri. Deuxu rybemy rarybereri ibutumy inyryberenymy. Ibutumy inyboho: Judeu, Judeuerydỹỹna ityhydỹỹdu, tule Kreta mahãdu, Arabia mahãdu, Deuxu aõmydỹỹnana wihikỹ‑ò raholarenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tahe bede riòtiinyrenyre. Rieryõrenyre aõbo rare. Tahe widee rỹỹraxirenyre iny sohoji sohoji‑ò aõbo raremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ijõ tahe tawobinarybe rarybere: —Tiiboho rururenyreri, itxỹtemonamy riõreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tahe Pedro rỹire waòsohoji erydỹỹna‑di, tahe tii rexidelenyre rarybekemy: —Boholake inihe, ibutumy kaiboho, Judeia mahãdu, Jerusalẽ sỹludu‑wana —kia bierybenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Inyõ rarybereri itxỹtemonamy riõrerimy. Tahe inatyhymy aõkõ rare. Txuu rati rariarerile heka rudiletyhyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Joel juhuu Deuxu rybeduõ rare. Tii narybede wijitxumy. Tahe iwese tii rarybere wesele, wiji ratximyhỹre. Tii rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","—Kiamy Deuxu rarybere: —Ikonanatxuu watyytybytyhyhykỹ aditeònykre ibutumy inydee. Ariòrereny, hãwyy hãbu‑wana, warybe rierynanykre. Weryrybò tahe matuari‑wana rarasinytyhykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ibutumy wadeòdu‑ò, lerỹ, hãbu, ibutuwo‑ò Deuxu Tyytybytyhy kanalokre. Tuu raryberenykre, ritỹnynyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Aõ tỹmyra ariteòsinykre biu‑ki, bede‑ki. Hãlubu, heòty, worona‑wana ròhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Txuu heka ilybyhykỹlemy relekre. Ahãdu isòhòkỹlemy relekre. Iribi tahe Inynyrỹtxu‑ò rehemynykre. Kia txu awimy roikre. Inynyrỹ kòdòhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kia bedeu, inyõ Inynyrỹnimy rexitòenykeki, tii jiarỹ aritakre iòraru‑ribi. Kia Deuxu rybe rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Judeu mahãdu, Israeli mahãdu, boholabenyke warybe‑ò: Deuxu sõwemy aõna aõna witxira witxira‑di, bedeòby‑di riwahinyre. Inatyhymy Jesuisi Nazare hãwã ludu mahãduõ riteòsinyre. Inatyhymy rare. Kaiboho heka teerytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kaiboho Jesuisi temyteu, Deuxu juhuu rimykremy rierymyhỹre. Rexierymy rõhõtinyre kawesemy bede roimy rarekre. Kaiboho Jesuisi terubunytenyte. Kaiboho itxeò nihikỹ‑ki tetamadỹỹnytenyte hãbubina debòreny‑di. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tahe Deuxu ritare rubu‑ribi riixixadỹỹnyre. Wabede Deuxu ribòhònyre. Iribi Jesuisi riòlòdỹỹnyre. Rubu heto tii rimyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davi juhuu rarybere iwese Jesuisi rarybekremy: —Wanyrỹ wawana ratxireri, brebu‑di watxiõkre. Tii riwawiòhenanymyhỹre. Tai wawo deysana‑di ritỹxinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Wadòròtò wowydyna tamy rewahinymyhỹre. Reeryre ibutumy rubuhetowo‑ki awityhymy wãhãré, iribi dori aròhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kai watyytyby teriõte rubuheto‑ki. Jiarỹ ariòre òbitityhy rare, tai waumyde rasunyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kai tiwaeryte ibutumy umytỹmyra aõmydỹỹnana awana aratxikreu, deysana‑di tỹximy biwasỹnykre. Kia ibutumy Jesuisi rarybekremy Davi rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pedro ijõ rarybemyhỹre: —Tahe kiamy heka mohõtinybenyke, Waseriòreboho. Davi heka aõ iximy aõkõ rarybereri. Tii tahe hãloowo‑ò roire. Itityby heka kakile iny‑wana ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tahe Davi Inynyrỹ deròwymy rybeduõ raremyhỹ. Deuxu inatyhyna rybe‑di Davi‑ò narybede. Kia tahe: Iriòre riòreõ bede dinodumy kodonykremy taiòlò ryna‑ki. Kia iòlò Davi rieryre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davi tahe Kristu ixixanamy juhuu narybede. Kristu umy dori rubu‑ki rariõhyyre. Iumyde rarònyõre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jesuisi Kristu, Deuxu riixixanyre. Ibutumy inyboho tuu robirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jesuisi ronymyhỹre Deuxu rurunawe‑ribi. Iwese rarybere wese Deuxu Tatyytybytyhy tamy diteònyde. Tii adee diwyde. Kiamy tahe wiji tabitenyteri, taholatenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davi raòwònyõre biu‑ò. Tahe kiamy rarybere: Deuxu rarybere Inynyrỹ‑ò: —Bodonyke katxi warurunawe‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Aòludu awarawo‑ki arisỹnykre. Aòludu‑di arehukre. Kiamy tahe Deuxu Jesuisi‑ò rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Boholake judeu mahãdu. Kaa inatyhy hyy rare. Itxeònihikỹ‑ki Jesuisi terubunytenyte. Deuxu tahe Jesuisi ritidire ibutu‑ò wedumy, ibutu‑ò Kristumy, aõma, Deuxu deòdỹỹna. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tahe Pedro rybe‑ki urile rõhõtinyrenyre. Tai tahe Pedro‑ò ijõ erydỹỹna‑ò rỹỹraxirenyre: —Waseriòreboho, aõhebo rokotỹỹnyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tahe Pedro dirawyònyde: —Bòòsebenyke aòrarureny‑ribi ixyby Deuxu‑ò. Idi tahe Jesuisini‑di maratysebekemy aòraru ritakemy. Tai bimykre Deuxu Tyytybytyhy wahidỹỹna wesemy awo‑ki rarekremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kristu juhuu rarybere: —Ibutumy heka Deuxu Tyytybytyhy bimybenykre, ariòre rimykre, iny hãwã witxira ludu rimyke. Ibutumy Deuxu dee wimy tahe rimykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro relyymy raremyhỹ. Tamyreny rarybere tarasamy roikemy: —Iny bina binahakỹ‑ribi bexitabenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kia rityhynyré heka tahe ratisebedumy roiremyhỹ. Ralore kiatxuu 3000 iny iòhòmy Jesuisi tyhydỹỹdu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tahe Jesuisi erydỹỹna mahãdu rierynanymyhỹre, wii ributunymy roiremyhỹ, paõ rioroororenyre wideereny: rexitòenymy roiremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iny sohoji sohoji bede riòtiinymy rabrebumy hitxinymyhỹre. Jesuisi erydỹỹna mahãdu bedeòby sõwemy riwinymyhỹre. Aõna aõna wiwihikỹmy riwinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ibutumy rityhynymyhỹre mahãdu, sõwemy wii riwiutyre. Ibutumy aõna aõna wimy riywinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Taaõmydỹỹna, tasu‑wana idi rohonyre. Wimy tahe ritxuatxuare. Ibutumy ityhydỹỹdu iaõkõ mahãdu dee riwahiriwahinyre. Inyõ aõna aõna rauhenykeki, tamy riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Deuxu dohodỹỹna heto‑ki txuõ txuõlemy wii ributunyre. Tahe tota hetomy paõ riyreriyrenyre. Riroxirenyre ibutumy teysarenymy wii wese rõhõtinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tuu reàlàrenyre Deuxumy. Ibutumy iny hãwãhãkỹ mahãdu awimy tai raharenyre. Deuxu rimyre txuõ txuõ lemy ralore mahãdu kia ritakemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pedro, Joaõ‑wana rare Deuxu dohodỹỹna heto‑ò rexitòenykemy, inataõ òra bedeu. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Deuxu dohodỹỹna heto ijò inyõ rininire, ijò ruxerahakỹ. Txuõ txuõlemy hãbu tibina ridyhyyhyymy iny tamy reamyhỹre. Tamy iny ralòmyhỹkeò tamy nierumy rexitòenykemy. Tii tuu hyy uladumy reareu ihyy itibinare. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedroboho rirònyrenyreu, hãbu tibina tuureny robire. Nierumy tahe tamyreny rexitòenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro juhu tamy retehere idi rarybere: —Bedeteheke wadireny. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tai hãbu retehemy ronyre, nieruõ iribi riwykemy rõhõtinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro rarybere: —Aõ ijõkõre, womati tỹrỹrỹhỹkỹ ijõkõ, pratakõ. Tahe aõbo idi watxirerile ta adee ariwahinykre. Jesuisi Nazare hãwãludunimy adee ararybekremy idi mariakremy. Kia deytena adee ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro, hãbu debò rimymy ritamadỹỹnyre. Aõwesele iruru iti‑ò ralore. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Hãbu rexiwatxinymy tahe, ririradỹỹnyre. Ihyy ralore dohodỹỹna heto‑ò. Deuxu dee deysamy rexiwatxinymy ralore. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ibutumy iny idi retehere rariarerimy, Deuxumy reàlàrerimy. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Inyõ rarybere: —Tii ijò ruxerahakỹ‑ki nierumy rexitòenymyhỹremy, inyboho tii reeryrenyre. Tai tahe idi bede riòtiinyreri timykibo aõna aõnamy rotỹỹnyramy. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Hãbu ta Pedro, Joaõboho werora‑ki xiery. Idi tahe ibutumy ributunyre Salomaõ heto ijò ahanawo‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro kia robireu tahe, tamy rarybere: —Judeu mahãdu, wadireny itxereõmy, bedeòtiidỹỹõmy. Jiarỹboho inyruru‑di aõkõ ka hãbu reteytenyrenyra, Deuxu rurudile wahe. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraõ, Ijai, Ijaò kiaboho Deuxu heka hãbu riteytenyra. Tybyreny Deuxu kia heka riwinyra. Deuxu, Kristunimy riwowydynyre, rubu‑ribi riixixanyraki. Kaiboho tahe Jesuisi Kristu tedytenyte Pilato‑ò. Pilato tii riteònykemy ratxireriu, kaiboho tamy rarybere: —Aõkõre, tii deòdỹỹõmy. Ijõ biteònyke. Tai tahe rubudỹỹduõ riteònyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesuisi òraru widỹỹdu aõkõ rarehyymy raremyhỹ, ityhydỹỹdu ihỹre, òbiti widỹỹdu ihỹre. Kaiboho tii tetxiõnytenyte, tewahinytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Umytuedeõna wahidỹỹdu tii rare. Kaiboho tahe terubunyte. Deuxu tahe tii riixixanyre rubu‑ribi. Inyboho ierydu, iitxeredu ratximyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Rityhynyrekile hãbu tibina reytemyhỹre. Kia hãbu teerytenyte. Jesuisini tyhyna kia riwinyre. Hãbu ibuturu‑ò reytera, tai òbitimy raramy ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Jiarỹ reeryre kaiboho teeryõte aõbo tewinytemy. Tule adinodu rierykõlemy kia riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tahe Deuxu tarybe riwahinyre ihetxiu rybedu mahãdu‑ò kia wahe tii rarybere Jesuisi rurukremy. Idi tahe irybe uludumy Jesuisi rurure. Iwese Deuxu rarybere wesemy heka irybe uludumy ròhònyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kaiboho ixi‑txi õhõti reakemy Deuxu‑ò biòòsekemy. Tai tahe aòraru aribi tii ritakre. Inynyrỹ adeereny kiditeònyke aõwihikỹmy Deuxu‑ribi, biu‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Jesuisi Kristu wijityhyle kanaõkre. Aõna aõna juhu rỹimy rareke rexihudi, tahe kanakre. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tii biukile rarekre wiji. Ijõ bede tỹmyra wihikỹkre iòhòmy rahudi tahe kanakre. Kia bededỹỹnanau tahe rarybere ihetxiu rybedu mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tahe Moisesi ijõmy rarybere: —Deuxu rybeduõ kedelekre asỹ, aijoi‑ribi tii rarekre. Iwese Deuxu riwatare wese rybeduõmy ararekremy, iwesele tii Inynyrỹ kiditakre. Tamy boholabenykre irybe aõmybo kanarybekremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kia, Deuxu rybedu rybe‑ò inyõ roholakõkre‑wana, Deuxu tii kanahukre. Kia Moisesi rybe rare, Pedro rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Deuxu rybedu sõwemy kia bededỹỹnanamy rarybere. Samueli juhuu rarybere. Idi sõwemy ijõ kiamy rarybere. Ihyymy ta wiji kabededỹỹnana roimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kaiboho Deuxu ihetxiu rybedu roire atximahãtenyteri Deuxu juhuu rarybere Abraõ‑ò. Ariòre‑ribi iny sõwemy ruaruakre. Kia ibutumy ariòre hãwã hãwã‑ki rasỹnykre. Kia iny‑ribi inyõ ròhònykre ibutumy iny wiòhedỹỹdumy rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Deuxu tariòre Jesuisi adeereny riteònyre aòraru‑ribi arahitxinykemy, arawiòhenanykemy. Kia tahe Pedro tamyreny rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedroboho tamyreny rarybereu, tamyreny rehemynyre Deuxu heto dohodỹỹna mahãduõ, ijõ tahe kia heto itxeredu dinoduõ, ijõ, saduseu mahãduõ. Inataõ ijoi tamy rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedro, Joaõ‑wana iny‑ò relyymy raremyhỹ: —Inyõ Jesuisimy rityhynykeki, tii tule rubu‑ribi riixixanykre. Jesuisi dori riixixanyre. Tahe Jesuisi ixixanamy tiiboho relyymyhỹreki, kia hãbu mahãdu riykaranyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Taita rimyre, Pedro, Joaõ‑wana. Ròtena‑ò ridyre. Wijile tahe tamy ixidee roholaõrenyra, txiorotyhyreki. Biurasou tahe roholakremy riòlòdỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Iny sõwemy Deuxu rybe‑ò kia txuu roholare. 5000 hãbumy, ijõ iny tule. Tiiboho Pedroboho‑ò roholare. Tahe sõwemy rityhynyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Itxu biòwamy tahe Jerusalẽ‑ò rehemynyre dinodu mahãdu, matuari mahãdu, judeu bede ywina erydỹỹna mahãdu. Kia ijoi mahãdu ibutumy rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anasi tule rehemynyre. Deuxu‑ò xiwena wahidỹỹdu mahãdu wedu tii ratximyhỹre. Tule Kaifa ijõ, Joaõ ijõ, Alexỹdre ijõre. Anasi sỹ mahãdu tule ijõre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tahe dinodu mahãduõ Pedroboho ritamadỹỹnyre ibutu kia mahãdu koò. Tahe ritỹỹraxinyre: —Aõrurudibo iny teteytedỹỹnymahãte. Monidibo kia tewinytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ta Pedro tykymy heka Deuxu Tyytybytyhy ralore. Idi tamyreny rarybere: —Iny dinodu mahãdu, matuari mahãdu, adeereny ararybekre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Hãbu tibina aõmydỹỹnanamy tiwatỹỹraxinyte‑wana, adeereny kiamy arirawyònykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Jesuisi Kristu Nazare hãwã luduni‑di kia rybe ruru‑di rewinyrenyre. Kia tahe bierybenyke. Kaiboho dorikỹhe Jesuisi itxeò nihikỹ‑ò teukotenyte. Deuxu tahe riixixanyre rubu‑ribi. Tai tahe ka hãbu reytemy rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesuisi manaõ wesemy ratxireri. Kia‑di rehure heto widỹỹduõ. Wiji tahe heto idile rỹimyhỹre. Kaiboho Jesuisi‑di tehute heto widỹỹdu mana‑di rehure wese. Wiji tahe Jesuisi Deuxu heto dinodu rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tamy inyõ rityhynyõkeki, òraru‑ribi ritaõtyhy. Ijõni aõkõ iny rityhynyke, Jesuisi nile iny rityhynymy rỹikrele, òraru‑ribi ritamy rỹirakre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pedro, Joaõ‑wana brebuõ‑di kia rybe ritỹnynyre. Tai iny bede riòtiinyrenyre, tiiboho dori tyyriti erydu aõkõ roire. Urile Jesuisi‑wana roiremyhỹ, kiale iny rieryrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Hãbumy inyboho robirenyra juhuu itibinamy. Tai tahe inyõ aõbinamy tamyreny rybedu aõkõ rare, hãbu tibina riteytenyrenyraki. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tahe ibutumy iny dohodỹỹna heto wo‑ribi riteònyre. Tahe wimy rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—Aõhebo rokotỹỹnyrenykre kia hãbu‑di. Inatyhymy tiiboho aõwiwihikỹ riwinyrenyre. Kia rikitxiõnyrenyõtyhy. Ibutumy Jerusalẽ hãwã mahãdu kia rieryre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tai kiamy rokotỹỹnykre. Tamy rakarybekre tiu Jesuisimy ixyby rybeõmykremy. Tai Jesuisimy rybe‑di rikiixãwãdidỹỹnykemy. Inyõ‑ò kiamy rarybeõtyhy. Kiawese raryberenyre rybe ywidỹỹdu mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Idi tahe rarariòwyre Pedro Joaõ‑wana tamyreny rarybere: —Jesuisi nimy rybeõmy, bibedeerynyõtyhy irybemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tahe Pedro, Joaõ‑wana tamyreny dirawyònyde: —Aõbo awityhyre. Inyboho arybe arityhynykre aõbo ada Deuxu rybe aõbo arityhynykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Aõbo jiarỹboho rabirenyré, raholarenyré, kialemy araryberenykre. Inyõ riwarybebinanyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Idi ta ixityre tamyreny raryberenyre, rybedỹỹõkemy. Tahe riteònyrenyre. Tamy aõwidỹỹõmy rỹimyhỹ hãwã mahãdu dee ruberurenyreki. Hãwã mahãdu dori Deuxu reàlàmyhỹre hãbu riteytenyraki. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kia hãbu dori 40 beòra ratyremy tabeòra‑di ratximyhỹre riteytenyrau. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedroboho rexitamy roirenyreu, ityhydỹỹdu seriòre òrysymy roirenyre. Tahe tiiboho tamyreny relyyrenyre iwese dohodỹỹna heto wedu matuari mahãdu‑wana tamy rarybere wesemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tahe wiwese wesele rõhõtinyreri wese, Deuxu‑ò rexitòenyrenyre: —Kai, Waha, inyIòlòreny atximahãte. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kai, ibutuwidỹỹdu tarybete: Davi, inytybyreny‑di tarybete Atyytybytyhy tamy ritỹnynyre, iwese tii rarybekemy. Davi eòdumy raremyhỹ. Irybe tyyriti‑ki roimyhỹre kiamy: —Judeukõdu mahãdu raykarananyreri. Kia awimy aõkõ ihỹre. Waijoi aõ òbitinadibo aõkõ rõhõtinyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Dinodu mahãdu wiributunyre Deuxuòludumy rỹikremy. Tule Kristu, kia Deuxu deòdỹỹna òludumy rỹikremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Arybe‑ki, Waha, kia ritidỹỹna roire. Tule Waha, inatyhy rare. Ka hãwã‑ki, Herodi, Poncio Pilato, Judeu mahãdu, Judeukõdu mahãdu, kia ibutumy ributunyre ariòre Jesuisi òludu rỹirakremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tiiboho riwinyre iwese kai tarybete wese, Waha, kia aõmydỹỹnanamy rỹirakremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kai, Waha, teeryte iwese tiiboho raryberemy, aõma, rybeõmykemy. Tahe eòdu biwiòhenanykre arybe‑di ihãrele rarybekemy brebuõ‑di. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Biwiòhenanykre, Waha, eòdu mahãdu, webinadu mahãdu riteytenykemy. Tule aõna aõna wiwihikỹ riwinykremy, Jesuisi, Ariòreni òraru‑ki kia riwinykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tahe ixitòedỹỹna rexihureu, heto ramytatamy. Deuxu Tyytybytyhy ibutumy iny tykymy ralore. Tai tahe Deuxu rybe rarybemyhỹre. Brebumy aõkõ tiiboho relyymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ityhydỹỹdu mahãdu iaõna aõna‑di wii riwiòhenanyre. Inyõ rarybeõhyyra: —Kaa wahõrõ sohojile rare. Ibutu aõna aõna ibutu hõrõmy rỹimy raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Deuxu Jesuisi erydỹỹna mahãdu riwiòhenanytyhyre irybemy relyyrenyreu, kia Jesuisi rubu‑ribi ixixana rybemy. Deuxu teysana tamy riwahinyre tule iny sõwemy iluurenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Tai tahe ityhydỹỹdu mahãdu aõna aõnamy rasiranyõhyyra. Ityhydỹỹduõ ityhymy rỹirakeki, taheto, tasubede rohonyre tahe nieru Jesuisi erydỹỹna mahãdu‑ò diwyde. Idi tahe tii ritxuatxuamy riwahinyre ibutu‑ò timybo iny sohoji sohoji tuu rurumy rỹiramy. ");
INSERT INTO kpjNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Jyje tule kiawesele riwinyre. Tasubedeõ‑di rohonyreu, idi iòwy nieru diwyde Jesuisi erydỹỹna mahãdu‑ò. Jesuisi erydỹỹna mahãdu Jyje rininire, Banabemy. Kiani inyrybe‑ò riwiurònanyre, rybe‑di wiòhedỹỹdu kiani rare. Tii Levi mahãduõ rare, Xibri bedebutesỹdu tii raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Idi tahe tule ijõ hãbu, Anania ninadu, tahãwyy Safira‑wana tasubederenyõ‑di rohonyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Iòwy tahe txuralemy diwyde Jesuisi erydỹỹna mahãdu‑ò tasubede òwyreny ibutumy risỹnyrenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tahe Pedro tamy rarybere: —Aõherekibo Satanasi‑ò taholamy araykywo‑ki atxiteri Deuxu Tyytybytyhy‑ò taruiteri. Aõherekibo iòwyjura‑di atxiteri. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Juhuu asubede tahonyõteu, ahõrõ rare. Aõhe, inatyhy? Inyõ adee rarybeõre idi bohonykemy. Idi tahonyteu, tahe, nieru ahõrõ rare, aõhe inatyhy. Aõherekibo aõbinahãkỹmy tahõtinyteri. Hãbu‑ò aõkõ heka taruiteri Deuxu dee. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kia‑ò Anania roholareu, rurulemy resere. Tai ibutumy iny ruberutyhyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Weryrybò tahe iumy rihetynyre. Tahe ritamadỹỹnymy riwyre rihãloonykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Inataõ òra bededỹỹnanamy reare tahe Safira, Anania hãwyy rehemynyre. Aõ heka rieryõhyyre tahãbu rubuna rieryõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro tamy rỹỹraxire: —Tiwesemybo asu teòwynyta —ahãbu rarybere wesele aõbo. Tahe tii dirawyònyde: —Kohe, iwesele rakòwònyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ixityre Pedro rarybere: —Aõherekibo ahãbu‑wana kai taruiteri. Tii teurihite aõbo riwinykeò. Beteheke, weryrybò ahãbu loodỹỹ‑ribi rehemynyreri. Tule tii aradykre rubumy. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tule tii aõwesele rurulemy resere. Weryrybò mahãdu ralore. Tai riwyre ritoonykre tahãbu biremy roikremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tai tahe ibutumy ityhydỹỹdu mahãdu ruberure. Ibutumy kia‑ò roholareu, tule ruberumyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jesuisi erydỹỹna mahãdu sõwemy wowydyna aõmydỹỹnana riwinyrenyre. Tule deytenawiwihikỹtyhy sõwemy riwinyrenyre. Ityhydỹỹdu mahãdu wii ributunymyhỹre Deuxu dohodỹỹna heto ube‑ò. Salomaõ ubetyhy inire. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kaa hãwã mahãdu dori sõwemy ruberumyhỹre Jesuisi erydỹỹna mahãdu‑ò wiutàdà lau. Tamy rabutuõhyyre ijohonamy. Ihãrele tahe ijõ rityhynymyhỹre, ityhydỹỹdu mahãdumy ralokemy. Aõbinatyhymy heka inyõ ityhydỹỹdu mahãdu dee raryberenyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ityhydỹỹdu mahãdu rasõwerenymyhỹre. Hãbu, hãwyy tule ralòmyhỹre Inynyrỹtyhy‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Webinadu mahãdu iny ridymyhỹre ryò, hãwã hãwã‑ribi. Tai Pedro nonana‑ki riraòmy roimyhỹ byretyre‑ki, herina tyre‑ki. Pedro ubòrò webinadu‑txi reakemy tai riteytenykemy rexinohõtinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ibutumy Jerusalẽ‑ribi iòhòmy rỹira mahãdu nade webinadu‑di, tule iny tyytybybina‑di didyde. Tai tahe ibutumy reytere. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Xiwenawidỹỹdu wedu mahãdu, Jesuisi erydỹỹna mahãdu‑ò rexinaanymyhỹre. Tule kiawedu eryna mahãdu riwiòhenanyre. Saduseu imahãdu ni rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","20","Tai tahe xiwe wedu mahãdu, Jesuisi erydỹỹna mahãdu rimyrenyre idi rehurenyre hãwã ròtenawo‑ki. Rumy tahe Inynyrỹ ỹjuõ riraynyre ijò, tahe ridyre ahana‑ò. Tamyreny rarybere: —Boibenyke Deuxu àlàna heto‑ò. Bexideòsinybenyke iny sõwehekỹ‑ò. Tamyreny bitỹnynybenyke timybo Jesuisi umytỹmyra inydee riwahinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iwese ỹju rarybere wese, txuu ratỹnyreu, dohodỹỹna heto‑ò ralomyhỹre. Tai rierynarenymyhỹre. Tahe xiwena mahãdu wedu dehemynyde, tii‑wana ratximyhỹ‑wana. Israeli nohõti juradỹỹdu mahãdu ributudỹỹnyre. Ibutumy judeu mahãdu, matuari mahãdu bedeerytyhy mahãduõ rare. Tahe soldado itxeredu‑ò riteònyre ròtena‑ò iòrysyrenymy. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Tahe roirenyre. Ròtena‑ki tai rahaõre. Ròòsere tamy relyyre: —Ròtena‑ò rehemynyra. Txiòtòbòhòkỹlemy rỹire. Tahe reraynyreu, aõho aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dohodỹỹna wedu xiwena wedu‑wana kia roholareu, tiiboho rexieryrenyõhyyre aõbo riwinyrenykemy, aõhebo rotỹỹnyrenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Iwesemy rõhõtinyrerikõnalemy, inyõ dehemynyde. Tai rarybere: —Ròtena‑ki tetidite mahãduõ, dohodỹỹna heto‑ki ratxireri. Iny kowa ritohonyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tai tahe soldado dinodu, soldado itxeredu‑wana riòryre ta didydenyde ywilemy. Tamy heka aõhe risỹnyõhyyre mana huna‑di tamyreny kedehukemy heka soldado rõhõtinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Tahe dehemynyde ritamadỹỹnyre inysõwe weduko‑txi. Tahe wedutyhy rybe ritelenyre: —Jiarỹboho heka juhu adeereny rarybere uritere Jesuisi nimy bede erydỹỹrenykõmykremy. Ihãrele tahe tuu tebedeerynytenyta ibutumy Jerusalẽ hãwã iny‑ò. Ibutu‑ò aeryna‑di tariate. Wamy tarybetenyteri jiarỹboho Jesuisi rerubunyrenyramy. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tahe Pedro taijoi‑wana rarybere: —Iwese Deuxu wadeereny rarybere wese, arityhynyrenykre. Hãbuõ iwitxiramy wadeereny rarybekeki, tiu arityhynyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kaiboho inatyhymy Jesuisi terubunytenyte. Òwòru nihikỹ itxeò‑ò tetamadỹỹnytenyte. Inytyby Deuxu tahe rubu‑ribi riixixadỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Deuxu tarurunawe‑ribi debò‑di biu‑ò ritamadỹỹnyre ibutu iòlòmy rarekemy, ibutu tarasadumy rarekemy. Tai ibutu Israeli ijoi mahãdu‑ò òraru bedewona ixãwina riwahinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Inyboho heka kia aõmydỹỹnamy robimyhỹrenyre, tai heka reerymahãrenyre inatyhy raremy. Inyõ Deuxu rityhykeki, tii Tatyytybytyhy tamy kidiwahinyke. Tii tule kia aõmydỹỹnamy rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Xiwena wahidỹỹdu mahãdu wedu tamy roholarenyreu, rakyarananyrenyre, irubudỹỹmy idi ratximyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tahe fariseu mahãduõ lamamy rỹire. Õnosõna erydỹỹduõ tii ihỹre. Ibutumy iny tii riijemyhỹre rityhynymyhỹreki. Kamalie heka inire. Tahe tii rarybere: —Jesuisi erydỹỹna mahãdu‑di biòlònyke urihimyò ahana‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Idi tahe taijoi‑ò rarybere: —Hãbu, Israeli mahãdu, bexiijebenyke kia hãbu‑ò, aõhebo botỹỹnybenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kaiboho dori õhõtireny beabenyke Teudani‑txi. Juhuu dori dinoduõmy tii raremyhỹ. Tii ixiòlòdỹỹnihikỹmy iximy rarybere. Sõwemy heka iny tii‑wana raremyhỹ tahe 400 hãbumy ihemy rare. Inyõ tahe rirubunyre rityhynymyhỹre mahãdu tahe iribi raubỹtỹre. Tahe aõ heka rimyõhyyre, ibutumy iõre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Iwitxirau ijõ‑txi õhõtireny rearenyke. Judasi inire. Tii Kalileia mahãduõ rare. Iu bede dinodu iny‑di rariareu tahe, tii rexiòlòdỹỹnyre. Sõwemy iny riheludunyre. Tii tule rurure. Taityhydỹỹdu mahãdu tule raubỹtỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Tule wahe kahãbu mahãdu rare ixinamy biteònyke. Hãbu kia aõmydỹỹnana dinodukeki, aõmy aõkõ relekre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Deuxu tahe idinodukeki, tiu heka idi behuõtyhy. Deuxu òludu wesemy heka kai tesumahãte. Tai tahe Kamalie rybe‑ò ibutumy rityhynyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Didyde he Jesuisi erydỹỹna. Rihetenyre. Idi tamyreny rarybere: —Rybeõmyke Jesuisi nimy. Tahe ixinamy riteònyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tiiboho iribi rexitarenyreu, reysatyhymy ratximyhỹ, Jesuisini òraru‑ki dorikỹhe tiiboho aõhõkỹmy rotỹỹnyrenyraki. ");
INSERT INTO kpjNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Txuõ txuõlemy Rybewihikỹ ritỹnynymyhỹrenyre dohodỹỹna hetomy dori, heto hetomy tiiboho rarybehyymy rỹimyhỹre: —Jesuisi inatyhymy Kristu rare, Deuxu deòdỹỹnamy nade. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tahe ityhydỹỹdu rasõwetyhynymy rỹiramyhỹ. Iu ityhydỹỹdu wytese mahãdu‑ò rỹsỹna riwahinymyhỹreu, grego rybedu rexinaanymyhỹre rỹsỹna wahidỹỹdu mahãdu dee. Judeu mahãdu wytese sõwemy rỹsỹna ritamyhỹrenyre waratyrereny. Kia wesemy heka judeukõdu mahãdu rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jesuisi erydỹỹna waò inatxi reurò mahãdu, ibutumy ityhydỹỹdu didydenyde kia aõmydỹỹnana‑ò roholakemy. Tahe raryberenyre: —Deuxu rybe erydỹỹ rikiixãwidinyrenykeki, wytese rỹsỹna ariwahinyrenykemy, kia heka òbiti aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tai tahe kaiboho hãbu mahãduõ bitabenyke ayreny‑ribi debò inatxi reurò hãbumy bitabenyke. Hãbu tyhydỹỹnale, Deuxu Tyytybytyhy‑di tỹximy rỹiralemy, iny bedeeryhykỹle, kiaweselemy hãbu bitake. Tiiboho dori aõna aõna ywisidỹỹdumy roirekre, kiawesemy iaõmysỹdỹỹnarenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tai jiarỹboho arexitòenywãhãrenykemy watxiwãhãrenyre. Deuxu rybemy arierynanymahãrenyke. Kiawese Jesuisi erydỹỹna mahãdu rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ibutumy heka tuu raryberé, tamyreny awire. Tai tahe hãbu mahãdu ritarenyre. Estevaõ ijõre, tii Deuxu Tyytybytyhy‑di tỹximy rỹira, tatyhyna‑ki tỹximy rỹira. Filipi ijõre, Prokoro ijõre, Nikanu ijõre, Timaõ ijõre, Parmena ijõre, Niolau ijõre, Niolau tahe Atxiòkia mahãdu juhuu rare. Judeu bede erydỹỹna tyhydỹỹdu juhuu tii rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ityhydỹỹdu mahãdu tiiboho didydenyde Jesuisi erydỹỹna mahãdu‑ò. Deuxu‑ò rexitòenyrenyre tahe Jesuisi erydỹỹna ityre tebò ritidirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Deuxu rybe heka ibutu ijohonanamy rỹire. Ityhydỹỹdu mahãdu‑ò sõwetyhymy tamy ralòmyhỹre Jerusalẽ hãwã‑ki. Xiwena widỹỹdu tule sõwemy Jesuisi rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estevaõ heka Deuxu luuna sõwemy ratximyhỹre. Sõwemy Deuxu ruru‑di ratximyhỹre. Deuxu urihixina nihikỹmy inyko‑ò riwinymy raremyhỹ. Aõdeytenawiwihikỹ wesemy tule riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kowa hãwã‑ki tahe judeu dohodỹỹna heto iwitxira rỹimyhỹre. Libertu mahãdumy rexininire taijoi. Imahãduõ Sireneu ludu rare, ijõ Alexỹdria hãwã luduõ rare. Tiiboho doidenyde Estevaõ‑wana rybe ritxiõnykemy. Silisia bede luduõ‑ribi, Afia bede luduõ‑ribi tii‑wana doidenyde. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Estevaõ rarybere bedeerynihikỹ‑di. Kia mahãdu tahe irybe weseõre. Estevaõ dori, Deuxu Tyytybytyhy‑di ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tai tahe hãbuõ‑ò raryberenyre: —Kaiboho heka Estevaõ dee maruibenykre. Jiarỹboho dori araòwynyrenykre. Kawesemy maruibenykre, my: —Jiarỹboho Estevaõ rybe‑ò raholamy rãiwãhãrenyre. Tii Deuxumy aõbinahakỹlemy rarybemyhỹre, Moisesimy tule. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kia‑ki heka Estevaõ dee iny raykarananyre, judeu matuari mahãdu tule tamy raykarananyre. Ibutumy Estevaõ òrysymy roirenyre tahe rimyrenyre, ridyrenyre rybe ywisidỹỹna‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","14","Tahe ruidu mahãdu didydenyde. Tahe tiiboho raryberenyre, my: —Ka hãbu heka Deuxu dohodỹỹna hetomy ibinamy narybede. Tii rarybere Jesuisi Nazare ludu iny dohodỹỹna heto kidibòhònykre. Jesuisi iny aõmydỹỹnana kidiwitxiranykre, ibutumy Moisesi inydeereny rierynanyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ibutumy iny ywisidỹỹna mahãdu Estevaõ‑ò retehere. Iòsana, ỹju òsỹnỹwesehekỹlemy tamy rõhõtinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tahe xiwe wedu Estevaõ‑ò rỹỹraxire: —Kia aõbohe inatyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Estevaõ tahe dirawyònyde. Wanyrỹboho, Wahaboho, Ijyymy adeereny arelyykre. Warybe‑ò boholabenyke. Mesopotamia bede‑ki Deuxu biu‑ribi rexitỹnynyre Abraõ‑ò, inytybyreny‑ò, Harã hãwã‑ki rasỹnyõreu. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Tamy Deuxu rarybere: —Abede‑ribi boibenykre. Alahi riòkòre mahãduy‑ribi makre. Manakre ijõ bede‑ò adee dori asỹbede ariurihikre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Iribi tahe Abraõ Kadeu mahãdu bede‑ribi roirenyre Harã hãwã‑ò tai rasỹnykemy. Iribi tahe tyby rurureu, Deuxu kaò didyde ka bede‑ò titxibo kaiboho wiji tasỹnymahãtemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Abraõ‑ò sỹõ riwahinyõre timy urihimyòõhyy. Tahe idi tamy riwahinykemy, iriòre‑ò riwahinykemy Deuxu tamy rarybere. Abraõ iriòreõre, ihãrele Deuxu tusỹmy tamy rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tule Deuxu tamy rarybere: —Ariòkòre ijõ bede‑ki rasỹnykre 400 beòramy. Kowa ariòkòre heka deòdu wesemy raaõmysỹdỹỹkre. Iwedu mahãdu heka ibinamy idi rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jiarỹ tahe iny ariòwynykre, Deuxu rarybere, ibinamy widi rỹira mahãdu. Iribi ka bede‑ò kòdòhònykre wamy kaki reàlàmyhỹkemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Idi urihixinaõ Abraõ‑ò Deuxu riwahinyre, tõhõti itxi reakemy. Uladu notyyresyna aõmydỹỹnana tamy riwahinyre. Idi tahe Ijai reareu, Abraõ Ijai notyy riorore debò inataõ reurò txu‑di. Iribi tahe Ijai tariòre Ijaò ritõtykyorore. Iribi tahe Ijaò tariòre notyky riorore. Tiiboho waò inatximy riòrenaduõ roire. Inatyhymy tiiboho inytybyreny rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Idi waòsohoji inytybyreny mahãdu Jyje dee rexiwobinanymyhỹre. Idi rohonyre Egito‑ò ramyhỹre mahãdu‑ò. Tahe Deuxu tii‑wana raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Iaõhõkỹmy dỹỹnana‑ribi Deuxu ritamyhỹre. Egito iòlò, Faraòmy ninadu rare. Deuxu heka Jyje luumy Faraò risỹnyre. Faraò rue‑ò heka Jyje bedeerydỹỹna sõwemy ratximyhỹre. Faraò ibutu dinodumy Jyje risỹnyre. Tule Iòlòheto‑di itxeredu tyhymy Jyje ronyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ramamy rubu nihikỹ dehemynyde ibutusu‑ò, Egito‑ki, Kanaã bede‑ki. Sõwemy iny aõhõkỹmy rotỹỹnyre. Inytybyreny rỹsỹnaõ‑ki rahaõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egito maixõmo rỹimyhỹreò, Ijaò roholare. Tahe inytybyreny riteònyre iòrysymy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Idi tahe ixityre iòrysymy riteònyreu, Jyje tamyreny rexideòsinyre. Tai tahe Faraò Jyje sỹmahãdu rieryre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tahe tyby‑ò Jyje tarybe riwahinyre tamy sỹmy kanakemy ibutu imahãdureny‑wana. Tiiboho 75 inymy rimyre ibutumy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tai tahe Egito bede‑ò Ijaòboho roirenyre. Iribi tahe Ijaò rurure. Idi tahe ibutumy inytybyreny rurure. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tahe iumyreny diwyde ritoonyre wabede‑ò, Sikeni hãwã‑ò. Abraõ kia wabede juhuu riwyre nieru‑di, Emo riòre‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Deuxusỹ‑õ wahidỹỹna juhuu rarybere Abraõ‑ò. Ibededỹỹnana iòhòre Deuxu tamy riwahinykemy. Inyboho Egito‑ki rasõwemyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ikonanau tahe iòlò iwitxiramy ròhònyre Egito bede iòlòmy. Tii Jyje rieryõre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tii iny ijoi riitxenanymyhỹre. Tii heka ibinatyhyre inytybyreny‑ò. Uladu‑di heto‑ribi rehukemy riteònyre. Tai iny riòrereny ituerenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","21","Iu tahe Moisesi reare. Tii uladu ruxeratyhyre. Tii tahetotyhykile raumynyre inataõ ahãdumy idi rỹire. Heto‑ribi dòhònydeu, Faraò riòre rimyre itibiedỹỹmy tariòre wesemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ibutumy Egito bedeerydỹỹnana tamy rierynanyre. Tii heka rexiòlònyre rybedunihikỹmy aõmydỹỹna widỹỹdu nihikỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moisesi iny inatxiwa itue beòra‑di rỹireu, tamahãdu, Israeli mahãdu roramy nade. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","25","Egito mahãduõ Israeli mahãduõ rihetenyreu, Moisesi tuu robire. Tahe Moisesi tii rirubunyre, Israeli mahãduõ riwiòhenanykemy, Egito mahãduõ rexiòwynymy. Deuxu Moisesi debò‑di iny ritakre. Kiamy tahe Moisesi mahãdu rierykremy Moisesi rõhõtinyre. Tahe aõkõre rieryõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ijõ txu biòwamy tahe Israeli hãbu inatximy wiwana ròrenymyhỹ. Moisesi ronyre iyreny‑txi riixãwididỹỹnykemy. Rarybere: —Kaiboho seriòre toite, aõherekibo wii tehetenytenyteri. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kia òhòtedu Moisesi ritorunyre rarybere: —Mobo he wawedurenymy arasỹnyra, awaywisidỹỹdu renymy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kai biwarubunykekõ aõbo, iwese kau Egito mahãduõ terubunyte wesemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kiarybe‑ò roholareu, Moisesi rahenyre Midiã bede‑ò rasỹnykemy. Idi tahe inatxi Moisesi riòremy kowa reare. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Iny inatxiwaituemy beòra‑di bededỹỹnana riwyre. Tahe Sinai hãwãlò bederahy‑ki raremyhỹu, ỹjuõ tamy rexitỹnynyre bede rade tòbòhòkỹy‑ki tamy roomyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisesi kiamy dobideu, bede riòtiinyre. Tamy itxeremy rehemynyre. Tahe Deuxu rybe‑ò roholare. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Jiarỹ boreny Deuxu watxireri, Abraõ Deuxu, Ijai Deuxu, Ijaò Deuxu. Tahe Moisesi ruberutyhyre, timy heka tamy reteheõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tahe Deuxu tamy rarybere: —Awa bitake, suu awarawo ludu dori, brebuna rare. Jiarỹ heka Deuxu watxireriki, biwatyhynyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Wiji tahe waijoimy rabireri Egito‑ki. Tiiboho aõhõkỹmy rotỹỹnyrenyre. Ibru‑ò raholareri, iohitxi‑ò raholareri. Jiarỹ heka aditadenykre iribi. Manake, Egito‑ò arateònykre. Kia heka Deuxu rarybere Moisesi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ka Moisesi heka Israeli mahãdu juhuu teramy reare. Tamy rarybere juhuu mobo wawedurenymy arasỹnyra, waywisidỹỹdurenymy. Tiile heka Deuxu riteònyre idinodumy rarekemy, tarasadumy rarekemy. Bederade tòbòhòkỹ ỹju, heòtywoludu, iwiòhedỹỹdure. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tahe Moisesi Egito‑ribi iny ritamyhỹre. Egito bede‑ki bedeeryna aõna aõna wiwihikỹ‑wana. Iwese ahohokỹbesò‑ki tule bederahy‑ki iny inatxiwaitue beòramy aõmydỹỹnana wiwihikỹ riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Kaa Moisesi heka rarybere Israeli mahãdu‑ò: —Ayreny‑ribi, amahãdu‑ribi rybedu nihikỹmy Deuxu kiditamadỹỹnykre iwese riwatamadỹỹnyre wese. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kaa Moisesi taijoi‑di wii ributunyreu, bederahy‑ki ihỹmyhỹ inytybyreny‑wana heka ratximyhỹ. Ỹju‑wana tii ratximyhỹ Sinai hãwãlò‑ki iu tamy rarybere. Deuxu rybe tyhy iru‑di ratximyhỹ. Tahe rybe bede ywina heka Moisesi‑ò Deuxu riwahinyre inydeereny kidiwahinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Tahe inytybyreny ityhydỹỹ deramy rare. Reòbyõrenyre. Ixybyle Egito‑ò ròòsekemy rõhõtinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tahe iny Araõ‑ò rarybere: —Ritxoo deuxuõ inydeereny biwinyke inykorenymy rakemy. Moisesi, Egito‑ribi iny ritarenyre, tahe titxibo ihỹre reeryrenyõre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kiatxu tahe broreni riòreõ riwinyre. Tahe xiwemy ritoonyrenyre iko‑ò, ritxooko‑ò. Rexideysanyrenyre aõbo tebò‑di riwinyrenyreki. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tai tahe Deuxu rexitare iribi, taina rityhynykemy. Iwese rybeduõ iu tyyriti‑ki riritinyre wese: —Israeli mahãdu, kaiboho xiwena tetoonytenyte, iròdu xiwena tetoonytenyta. Wadee aõkõ tahe kia tetoonytenyta 40 beòramy bederahy‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kaiboho tewytenyta ritxooheto riòre. Mòlòki inire, aritxoo deuxuni. Tule Renifa taina ijõ aritxoonire. Kia tewinytenyte, tetyhynytenyte wahe. Tai tahe arateònyrenykre Babilonia weribihikỹ‑ò wahe. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Inytybyreny heka Deuxu rybe bede ywina tyky heto riwinymyhỹre bederahy‑ki. Iwese Moisesi‑ò Deuxu riteònyre wesemy kia riwinymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Iribi tahe inytybyreny tatyby‑ribi tyky heto ritare, tii‑wana riwymyhỹre kabede‑ò, Josue tadinodu‑wana. Iu Deuxu iko‑ribi riteònyre, ibutumy tai sỹ mahãdu tii‑wana riwymyhỹre, ihyy tahe Davi reare. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Deuxu heka sõwemy Davi luure. Davi heka rexitòenyre Ijaò Deuxu dee heto riwinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tahe tii aõkõ riwinyre, Salomaõ iwidỹỹdure. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","49","Deuxu biukisỹdu tahe hãbu widỹỹna heto‑ki rasỹnyõmyhỹre. Iwese Deuxu rybeduõ rarybere wese: —Biu tahe warynana rare, bede tahe wawa elehyna rare. Timybo inyõ wadee heto riwinyke, Inynyrỹ rarybere. Iwo‑ki tahe waelehyna arihynyõkre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Deuxu rarybere: —Ibutumy aõna aõna jiarỹ rewinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tahe Estevaõ rakonananyre he tamyreny rybena heka ròhònyre: —Kaiboho araykytererenyre. Deuxu Tyytybytyhy rybe‑ò taholaõhyymahãtenyte. Iwese iny tybyreny riwinyrenyre wesemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ibutumy Deuxu rybedu mahãdu‑ò ibinamy iny tybyreny riwinymyhỹrenyre. Tiu ihetxiu Deuxu òbiti hãbu kanakeò, tiiboho raryberenyreu, rirubunyre irybedu. Kaiboho tahe Deuxu òbiti hãbu‑di ijõ‑ò tewahinytenyte, terubunytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Deuxu bede ywina ỹju mahãduõ adeereny diwahinydenyde, kia bede ywina kaiboho tetatenyte, tahe tetyhynyõhyymahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tahe kiamy Estevaõ rarybereu, tiiboho heka rebure nihikỹre. Urile txyde‑ki ruruamyhỹre tamy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Estevaõ tahe Deuxu Tyytybytyhy‑di iwoki ratximyhỹre. Tahe biu‑ò retehere: Deuxu loosònamy robire. Jesuisimy robire lamamy rỹire Deuxu rurunawe‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tahe Estevaõ rarybere: —Jiarỹ wa rabireri biu juxahakỹmy. Jesuisimy rabireri Deuxu deòdỹỹna. Lamamy heka rare Deuxu rurunawe‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tahe ryrymyhỹre, tõhõti ritòbònymyhỹrenyre, raijeranyre tamy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ridyre hãwãy‑ribi, mana‑di tahe tamy rehumyhỹre, rirubunyrenyre. Erydỹỹna ijyydu tahe taderamy ririrenyre Saluko‑txi tamy riyrubunykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Iu mana‑di rehureu, Estevaõ rexitòenyre: —Wanyrỹ, Jesuisi, watyytyby kai bimyleke awana ararekremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tahe tatiowotimy resere, ryryre: —Wanyrỹ, kia òraruna iòwydỹỹomyke. Idi tahe rurure. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Salu tahe kia òbitimy raremyhỹ rõhõtinyre, Estevaõ rurureu. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Iribi tahe ityhydỹỹdu mahãdu aõhõkỹmy rotỹỹnymyhỹre. Judeia wedu mahãdu dori, iòludumy rỹimyhỹre. Tai tahe ityhydỹỹdu sohoji sohoji Jerusalẽ hãwã‑ribi ròhònyre. Urile Jesuisi erydỹỹna mahãdu sohojile rỹire. Judeia bede hãwã mynamyna robỹtỹre, Samaria bede‑ò tule. Tahe hãbu ityhydỹỹduõ Estevaõ umy riwyrenyre rihãloonykremy. Tahe rahinymyhỹrenyre, rirajuamyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Salu tahe ityhydỹỹdu mahãdu hudumy. Wii risỹnymyhỹre. Ihetorenywo‑ò ralòmyhỹre tahe ridymyhỹre hãwyy, hãbu, ròtenawo‑ò riròtenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Iu tahe ityhydỹỹdu mahãdu ijõ bede‑ò roire mahãdu Deuxu rybemy relyymyhỹre ibutu hãwã‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipi ijõ raremyhỹ. Tii Samaria hãwã‑ò rehemynyre. Tahe Kristumy tamyreny relyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Iny sõwemy rityhynyrenyre aõmybo Filipi rarybemyhỹremy. Tahe deytedỹỹna wiwihikỹmy iny robimyhỹrenyre, tyytybybina deòdỹỹnamy tule robirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tahe riteònyreu, tyytybybina iny‑ribi ròhònyre, rirajuamyhỹre. Tule iny webinadu raraserasemy roimyhỹre, tule inytiere‑wana. Tahe ibutumy riteytenymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tai tahe ka hãwã‑ki deysana nihikỹ rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Samaria hãwã‑ki tahe hãbuõ raremyhỹ. Simaõ inire. Tii wodohonana widỹỹdu ihỹre. Iny riitxenanymyhỹre. Tahe riòtiinyrenyre. Tii iximy rarybemyhỹre moõ wiwihikỹmy raremyhỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ibutumy iny tii rityhynyrenyre, hãbu wedu mahãdu tule, hãbu aõtxile mahãdu tule. Tiiboho raryberenyre: —Simaõ Deuxu ruruna rare. Ruruna nihikỹ inire. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tiu bedeu aõkõ iny riitxenanymy raremyhỹ, riòtiinyrenyre. Tai tahe rityhynymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Iu tahe Filipi Jesuisi Kristunimy, Deuxu òlònamy tamy relyymyhỹre. Tai tahe rityhynymyhỹre, raratysebemyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Iribi tahe Simaõ itxenadỹỹdu tule Jesuisimy reòbyre, raratysebenyre. Tahe Filipi‑wana ihyy ròirenyre bede òtiidỹỹna‑di retehemyhỹre aõbo Filipi riwinyremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria hãwã mahãdu tahe Deuxu rityhynyre. Kia‑ò Jesuisi erydỹỹna mahãdu roholare Jerusalẽ‑ki. Tai tahe Pedro Joaõ‑wana riteònyrenyre kowa‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Rehemynyrenyreu, Deuxu‑ò rexitòenyrenyre Deuxu Tyytybytyhy tamy kanakemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Inyõ dori Deuxu Tyytybytyhy‑di rỹiõmyhỹ. Urile Jesuisi Inynyrỹni‑di raratisebedỹỹmy rỹiramyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tahe Pedro Juaõ‑wana tebòreny ityrereny ritidire. Tahe Deuxu Tyytybytyhy tamy nade. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kiamy Simaõ robire, aõma, debòtidina‑di Deuxu Tyytybytyhy nade. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Tai tahe tamy rexitòenyre: —Ka heka wanieru rare. Bidiwahinyke kia ruruna. Tahe inyõ tyre wadebò aritidikeki, tamy Deuxu Tyytybytyhy kanakemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tahe Pedro tamy dirawyònyde: —Aõkõre, anieru rakemy watxireri awanale rububede‑ò. Deuxu ruruna dori anieru‑di biwykemy mohõtinyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kia heka aõmysỹdỹỹnakõre wayreny‑ki. Arayky, awo, òbitimy aõkõ ratximyhỹre Deuxu dee. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mabedewomy atximahãke aòraruna‑ki, aõbo tahõtinyte. Bexitòenyke Inynyrỹ‑ò tii òsana aòraruna‑ribi araixãwididỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kai dori texiwaritinymahãte. Aòraruna adi nararotinymyhỹde. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tahe Simaõ tamy rarybere: —Wadee bexitòenybenyke Inynyrỹ‑ò, kia aõkõ waki kỹnyikemy, aõmybo tarybetenyteki aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Iribi tahe, Pedro Juaõ‑wana Inynyrỹ rybemy rarybemyhỹrenyre, relyymyhỹrenyre tai. Sõwemy Samaria bede hãwã hãwã‑ki Rybewihikỹ relyymyhỹre, Jerusalẽ‑ò ròòserenyreu. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Filipi Samaria hãwã‑ki raremyhỹ. Tahe Inynyrỹ ỹjuõ tamy rarybere: —Bexiywinyke, make ibòò‑ò. Kasa hãwã ryhykỹ bimyke. Jerusalẽ‑ribi ryy rare, bederahy‑ki rare. Tahe Filipi rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Tahe inyõ‑wana wibymy reare. Tii Etiopia bede luduõ rare. Etiopia bede iòlò hãwyyõ rare. Kanasi inire. Inieru‑di itxeredu kahãbu rare. Tii enuku rare. Tii ròòsereri Jerusalẽ‑ribi. Kowa Deuxu reàlàmy rare, tahe tasỹ‑ò ròòsere iawarutewedile. Isaia Deuxu rybedu tyyriti‑di rariamy tii ronymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Deuxu Tyytybytyhy Filipi‑ò rarybere: —Make, awarutewe‑ò, mariake ibire‑di. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tahe Filipi tamy raijaranyra. Roholare tyyriti‑di rariareriò. Tahe Filipi rỹỹraxire: —Kai aõbo teeryte aõbo rare, aõdibo tariateri. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tahe dirawyònyde: —Aõkõre, inyõ dori wadee ritỹnynyõre. Timybo arierykremy. Manaòwònyke wabire‑ò bodonyke. Tahe Filipi raòwònyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tii kia‑di rariareri tyyriti‑ki: —Iwese iny budoeni rubudỹỹdu‑ò riwyre wese, tii iwesele ridyrenyre. Budoeni‑ribi iny isira riororeu, rirajuaõlere. Iwesetyhyle Tii rarybeõlere. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Iehehenamy tamy raryberenyre wese hãbu ehehe wesena, òbitimy aõkõ idi riywinyrenyre. Inyõ rarybeõtyhy iriòkòremy, iumy dori bede‑ribi ituera. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tahe tii Filipi‑ò rarybere: —Wadee manarybeke momybo rybedỹỹdu rarybereri, iximy aõbo ada ijõmy aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tahe Filipi kia Tyyritidile rexidelenymy relyyre. Jesuisimy Rybewihikỹ Tỹmyramy tamy relyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Rydi rariamyhỹre idi rehemynyrenyre beõ‑ò. Tahe tii Filipi‑ò rarybere: —Kowa bera rare. Biwaratisebenykekõ aõbo, adee awikeki. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","38","Tahe Filipi dirawyònyde: —Awire wadee. Inatyhymy arayky‑ki tetyhynyte‑wana, aratisebenykre. Tahe rarybere: —Retyhynyre, inatyhymy Jesuisi Kristu Deuxu Riòre raremy. Tahe tewe irira riixãwidinykemy riteònyre. Tahe itewe‑ribi ròhònyra, bera‑ò riberenyre. Tahe riratisebenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bera‑ribi rotuoreu, Filipi aõwesele iõmy reare. Inynyrỹ Deuxu Tyytybytyhy ridyre. Hãbu ixyby Filipimy robiõhyyre. Tahe tary‑di rariamy rare. Teysanatyhy‑di tỹximy rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Idi tahe Filipi rexieryreu, Asoto hãwã‑ki rehemynymy raremyhỹ. Iribi tahe Rybewihikỹ‑di relyyre ibutumy hãwã hãwã‑ki. Ikonana tahe Sesaria hãwã‑ò rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Salu rarybemy raremyhỹ, Inynyrỹ Jesuisi ityhydỹỹdu mahãdu rubudỹỹmy. Tii rarybemy raremyhỹ Deuxu dohodỹỹna heto wedu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Tamy rexitòenyre: —Arybe tyyriti ariwykremy watxireri Damasu hãwã dohodỹỹna heto wedu‑ò. Tai tahe kowa‑ki ityhydỹỹduõ‑txi areakeki, aõtxile hãbu hãwyy aõbo, aridykemy Jerusalẽ hãwã‑ò, ariròtenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tahe iòhòmy Salu rare Damasu hãwã iròte iòhò‑di, idi tahe loosònahakỹ Salu tyre resere. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tahe bede‑txi resere, tahe rybeõ roholare: —Salu, Salu, aõherekibo aõna aõnamy ibinamy wadee tatỹỹnymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tahe tamy rarybere: —Mowexe, Wanyrỹ atxiteri. Tahe rirawyònyre. —Jiarỹ Jesuisi watxireri, aõna aõnabina binamy wadee tadotỹỹnymahãte wahe. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Myike, mariamy tahe hãwãhãkỹ‑ò malokre. Taita inyõ adee rarybekre aõhebo botỹỹnykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tahe Salu ijoi riòryre rybeõhyy rỹimyhỹ. Rybe‑ò roholare, tahe tuu robiõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Salu suribi rỹireu, iruetà wesele heka ratximyhỹ. Tahe hãbu tii‑wana ihỹmyhỹ heka iaxiò‑ki idi rimymy idi rare Damasu hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tahe hãwãhãkỹ‑ki txu inataõ txu idi rỹire aõmy robiõhyyre, riroxiõhyyre, bemy riõõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasu hãwã‑ki ityhydỹỹdu wihikỹ rasỹnyre. Anania inire. Wanyrỹ Jesuisi tamy rarybere rasi weselemy: —Anania. Tahe rirawyònyre: —Aõbo rare, Wanyrỹ, kakile watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tahe Jesuisi riteònymy rarybere: —Myike, make òbitiry‑ò, Judasisỹ heto‑ò. Tai bitỹỹraxinyke titxibo Salu ratxirerimy. Tarso hãwãludu tule rininire. Tii wiji wadee rexitòenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Tii umy robireri tarasi‑ki. Kai tehemynyteri wese, irue‑ò ebò bitidikemy, biteytenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania Jesuisi‑ò rirawyònyra: —Wanyrỹ, sõwemy kia hãbumy rybe‑ò raholara. Aõbina binamy ityhydỹỹdu‑ò risỹnymy raremyhỹ Jerusalẽ‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Deuxu dohodỹỹna heto wedu tyyriti diwyde kaki ityhydỹỹdu rutysỹny rirutekemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tahe Inynyrỹ tamy rarybere: —Aõwaxina tamy makre, Jiarỹ dori, kia retara wadee aõmysỹdỹỹdu nihikỹmy rarekemy, judeukõdu mahãduko, iòlòrenyko, tule Israeli mahãduko wanimy rarybekre, aõma, warybetỹmyra wihikỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tamy aritỹnynykre tiwesebo aõhõkỹmy rotỹỹnykre wanimy rybeòraru‑ki. Kia ibutumy Jesuisi rarybere Anania‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Idi ta Anania rare tamy Judasi heto‑ki. Ralòmy rahudi, tahe, tebò ityre ritidira. Tahe rarybera: —Salu, waseriòre, Inynyrỹ adee riwateònyra. Tiile, Jesuisile heka ryro‑ki adee rexitỹnynyre. Tiile heka riwateònyra arue ritxuakemy, tule Deuxu Tyytybytyhy atykmy ralòkemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tahe aõwesele irue‑ribi rejujura aõ yjy wesele. Tahe ixityre robira. Idi rỹimy rahudi tahe, Anania riratysebenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Idi riroximy rahudi tahe, inatyhymy raruruterenyre. Tahe Damasu hãwã‑ki tiwese txubo idi rỹire kia erydỹỹna mahãduy‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Idi dohodỹỹna heto‑ki rybe ritỹnynyre. Rarybere: —Jesuisi heka Deuxu Riòrele rare. Kiawesele rybe‑di ritynynymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tahe uri ijohonadu mahãdu urile bede riòtiinymy rỹimyhỹ. Tahe inyõ rarybere: —Kia aõ heka ityhydỹỹdu rubudỹỹdule ratxireri, Jerusalẽ‑ki. Kiale heka kaò nade ityhydỹỹdu ritaataamy ridykemy dohodỹỹna heto wedu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Salu tahe ire riixiòlòdỹỹnymyhỹhyyre. Judeu Damasu hãwã ludu rieryõhyymyhỹ aõmybo rarybemy. Tii rarybere: —Jesuisi Kristule rare, Deuxu deòdỹỹna rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tiwesetxubo txu idi rỹidi tahe judeu mahãdu rarybere irubudỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tahe Salu rierymy rỹimyhỹ tahe inonana‑ò rexiywinymy rỹimyhỹ. Rumy tahe, txumy hãwã ijò‑ki rirubunykemy retehemy rỹimyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tahe ijõ erydỹỹna mahãdu weriri nihikỹ riwinyre. Rumy tahe Salu riòlòdỹỹnyre òtity nihikỹ kanaweribi‑ò, hãwã ahanaube‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Salu Jerusalẽ‑ò rehemynyreu, ityhydỹỹduky‑ò ralòkemy ratxireri, tahe urile ilau ruberumy rỹimyhỹ. Erydỹỹna mahãdu rõhõtinyre: —Tii ityhydỹỹdu inatyhy aõkõ ratximyhỹremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Banabe tahe rityhynymy ridyre Jesuisi erydỹỹna mahãdu‑ò. Tahe relyyre iwese Jesuisi Salu‑ò ryki rexitỹnynyremy tamy raryberemy. Tule relyyre iwese Jesuisinimy Salu rybe ritỹnydỹỹnymyhỹremy, Damasu hãwã‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tahe taihyy Salu ratximyhỹre. Tiò tiòle reamy ratximyhỹre rybe ritỹnydỹỹnyrerimy ihỹre, ruberumy aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Salu rarybera grego rybe heka erydỹỹna mahãduõ‑ò. Widee rarybehyymyhỹrenyre. Idi tahe kia mahãdu Salu rubudỹỹmy roromyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ityhydỹỹdu seriòre kia rieryreu, tahe Salu ridyrenyre Sesaria hãwã‑ò. Iribi tahe Tarso hãwã‑ò riteònyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Idi tahe ywina reare ityhydỹỹdu mahãduy‑ki. Ibutumy hãwã bedemy, Judeia, Kalileia, Samaria, ityhydỹỹdu mahãdu iruruteremy relere. Ibutumy Inynyrỹ dee òbitina‑ki rariamyhỹre, rityhynymyhỹre. Deuxu Tyytybytyhy teysatyhymy tamy riwahinyre. Sõwemy tahe ralore iheki ityhydỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ibutumy hãwã hãwãmy Pedro rariamyhỹre. Tule robehere Lida hãwã‑ò ijõ ityhydỹỹdu mahãdusỹ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tai Eniamy ninadu‑txi Pedro reare heka rare. Iumy heka imyremyrehekỹ heka rare. Debò inataõ reurò beòramy heka herina‑ki bede idi rỹire ");
INSERT INTO kpjNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro rarybere tamy: —Enia, Jesuisi Kristu arateytenykre. Myike, aherina biyrubunyke. Aõwesele hãbu rỹira. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ibutumy Lida hãwã mahãdu Sarona hãwã mahãdu tuu robire, tai Inynyrỹ rityhynyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jòpe hãwã‑ki hãwyy ityhydỹỹdu rasỹnyre. Tabita inire. Kiani riwiurònyre, watxi wese heka rare. Kia heka aõwiwihikỹ widỹỹdu heka rare. Aõna aõna sõwemy iny‑ò riwahinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ijõtxu heka webinadumy resere, ihyy ta, rurure. Risuhòmy rahudi tahe, ritidire hetowo ratyaluduwo‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Laida hãwã iòhòmy rỹire, Jòpe hãwã‑ribi, Ityhydỹỹdu roholare Pedro Lida hãwã‑ki ratximyhỹreò, tahe hãbu inatxi diteònyde Pedro òrysymy. Uritere eleõkõmy kanakemy tii‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro tahe tii‑wana rare. Rehemynyrenyreu, tahe ridyre hetoratya ludu wo‑ò. Ibutumy wytese mahãdu robumy rỹimyhỹre, rubuweroramy. Tahety, tatyyboho ritxeredỹỹnymy tamy riwinyreò. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tahe Pedro rarybere ibutumy rexitakemy. Tahe rexitòenyre taowotimy resemy. Tahe rexiòkesere rubu‑ò rarybekemy: —Tabita, myike. Tahe irue raraynyre tahe Pedromy robire, tahe ronyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro tebò tamy riwainyre tahe rỹire. Tahe wytese‑ò, ityhydỹỹdu‑ò ryryre. Tamy riteòsinyre hãwyy irulemy roirerimy ihỹremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jòpe hãwã mahãdu ibutumy kia rieryre. Sõwemy iny tahe Inynyrỹ rybe rityhynyre., ");
INSERT INTO kpjNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Txu sõwemy Pedro Jòpe hãwã‑ki ihỹmyhỹ Simaõmy ninadu heto‑ki. Simaõ heka iròduty wysydỹỹdu rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Italia soldado mahãdu dinodumy raremyhỹ. Oreniliu inire. Sesaria‑ki rasỹnyre. Tii òbitimy nodu rare, isỹ mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tii uriwahidỹỹna diwahinyde tule sõwemy rexitòenyre Deuxu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Aõutxu inataõ òra bedeu iòhòmy, rasina wesemy Deuxu ỹjumy tii robira, tamy rehemynyreri. Tahe tamy ryryre: ");
INSERT INTO kpjNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","—Oreniliu, rimasajuare‑ribi riwawyònyre: —Aõherekibo, Wanyrỹ. Tahe ỹju rarybere Oreniliu‑ò: —Aexitòedỹỹnamy Deuxu rierymyhỹre. Tule ijõ‑ò awahisina Deuxu rierymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Biteònyke eòdubohoõ Jòpe hãwã‑ò Simaõ Pedro òrysymy. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tii Simaõ iròdutyky iyxidỹỹdusỹ‑ki ihỹre, bera ijà iòhò‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ỹju rybedu rexitareu, teòdu inatxi‑ò ryryre. Tule tasoldado mahãduy‑ribi inyõwihikỹ rihitxinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kia ibutu‑ò relyymy rahudi tahe riteònyre Jòpe hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ijõtxu txutyetxuu, tiiboho hãwã‑ò iòhòmy ròire. Kiaule Pedro raòwònymy rỹimyhỹ hetotyre‑ò rexitòenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Rama risamy ratximyhỹ tahe riroxikemy ixi‑di ihỹmyhỹ. Rỹsỹna riraòmy rỹimyhỹ. Idi rasi wesemy rõhõtinymy rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tahe robire: biuwetyy ruamyhỹre wese tuu robire. Rià wesemy aõna tamy dobehede. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Rià wo‑ki ibutumy iròdu, nawii, hemylala, aõbo dòkõnakõnale. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Rybeõ‑ò roholare: —Myike, Pedro, birubunyke, biroxike. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro rirawyònyra: —Aõkõre, Wanyrỹ. Kia dòkõna reròkõhyywãhãre, isuisure dori. Ixityre tamy rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","—Aõbo Deuxu risuhore wese isuisumy rybeõmyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ixityre narybede. Iu tahe aõwesele ridyre biu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tahe Pedro kia aõbo raredi heka rõhõtinyreu, Oreniliu‑ribi hãbu mahãdu rehemynyre. Simaõ heto riijemyhỹ tahe ijòhòkỹkile rahare. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tahe ryryrenyre: —Simaõ Pedro aõbo kakile ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro, tatxuu rasina‑di rõhõtinyreu. Deuxu Tyytybytyhy tamy narybede: ");
INSERT INTO kpjNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","—Myike tahe, bobeheke. Inataõ hãbu dori araijereri. Tii‑wana makre adee dori aditeònyde. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tai Pedro robehere. Tamy rarybere: —Jiarỹ aòrysydu rare. Aõherekibo tòitenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tahe rirawyònyre: —Oreniliu hãbu òbiti rare. Tii Deuxu dee ijohonaduõ rare. Ibutumy judeu bede mahãdu awiremy tuu rarybemyhỹre. Ỹjuõ tamy rarybere aòrysymy kiditeònykremy, adee roholakremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tahe Pedro tamyreny rarybere: —Kakile inyboho rõkõrõrenykre. Ihewoludu txu, rỹidi tahe Pedro tiiboho‑wana ròirenyra. Ijõ ityhydỹỹdu seriòre tule roirenyra. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ijõ hewo ludu txu Sesaria‑ò rehemynyrenyre. Oreniliu tii riraòmyhỹre. Taijoi mahãdu tabiòwawoludu mahãdu‑wana ributunymy rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro rehemynymy raloreu, Oreniliu ròhònyra heto‑ribi tahe tatiowotimy iko‑txi resere riwowydynykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tahe Pedro ritamadỹỹnyre. Rarybere: —Mynyike wahe. Jiarỹ hãbule watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tahe rarybemy ralòmyhỹ, sõwemy wii ributunyreriò itxi reare. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ta Pedro tamyreny rarybere: —Judeu mahãdu iny witxira mahãdu‑wana wibutudỹỹõmy, iòhòmy wiribi riraõmy. Kia teerytenyte. Deuxu dori riwaerynadỹỹnyre kia wese arõhõtinykre. Iny wiwese wiwesele raremy arõhõtinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tahe tai waòrysymy teteònyteu, aõtaximy anademy wanohõti rỹire. Tai tahe adeereny arỹỹraxikre. Aõherekibo waòrysymy aõtaxina teteònyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ta Oreniliu rirawyònyre: —Inaubiòwa txumy txu rỹire tahe hãbu tyky tỹrỹrỹhỹkỹ‑di wako‑txi rexitỹnynyra. Iule wesemy tahe waheto‑ki rexitòenywãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Tahe wadee rarybera: —Oreniliu aexitòedỹỹna‑ò Deuxu roholara, ijõ‑ò awahisina rieryra. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Biteònyke Jòpe hãwã‑ò Simaõ Pedro òrysymy. Simaõ, iròdutyky iyxidỹỹdusỹ‑ki ihỹre bera ijà iòhò‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aõwesele tahe, aòrysymy reteònyre. Awimy tahe tateriki rahara. Inyboho kakile ributunymy ihỹrenyre, aroholakemy ibutumy Deuxu‑ribi aõmybo manarybekemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tahe Pedro rarybere: —Deuxu dee iny ibutumy wiwese wiwesele rare. Kia reeryre. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ibutumy bede bede hãwã ludu Deuxu rityhynykeki, aõbo tamy òbiti riwinykeki, tii Deuxu ixidee rimyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kia rybe tahe Deuxu riwahinyre judeu mahãdu‑ò. Rybewihikỹywina kia diwyde inydeereny bedeerynamy. Kia Jesuisi Kristumy rarybere ibutunyrỹna kia rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Joaõ ijõ ratyysebenamy rarybere, idi tahe kia rybe hãletedỹỹmy rexidelenyre Kalileia‑ki. Tahe ibutu judeu mahãdu bedemy rarybere. Kia kaiboho teerytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Iwese Deuxu Tyytybytyhy, taruru‑wana Jesuisi Nazare ludu tyre‑ki ditxiwide wesemy relyymyhỹre. Iwese Jesuisi reamy raremyhỹ wesemy aõwihikỹ riwinymyhỹremy, tule iny Diabo rururawo‑ki ratxirerimy ihỹre Jesuisi iribi riteònyre, ta reteytenymyhỹre. Deuxu dori Jesuisi‑wana ihỹre. Ibutumy kia teerytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tahe ibutumy judeu mahãdu hãwã‑ki riwinymyhỹre, idi itxeredumy inyboho roiremyhỹre. Ihãre tahe tii Jesuisi rirubunyrenyre, òwòru itxeò nihikỹ‑ki ritòhãletenymy ritamadỹỹnyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Inataõ txu‑di tahe Deuxu rubu‑ribi riixixanyre, tahe tii riteòsinyre inyõ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tatarasanaõòle Deuxu Jesuisi ritỹnydỹỹnyre. Kia heka inyboho roire tii‑wana riroxirenyreki, riõrenyreki, iixixana hewomy. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Deuxu rarybere: —Jesuisi hitxidỹỹdu iny wiribi ywisijuradỹỹdu rareke, iru mahãdu dee, rubu mahãdu dee. Kiamy heka Deuxu iny‑ò ritỹnytedỹỹmy, ta inyboho rokoirekemy diwahinyde. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ibutumy iny Jesuisinimy tamy rityhynykeki, iòraru‑ribi iny riixãwididỹỹnyke. Kia ibutumy ihetxiu rybedu mahãdu rỹimy rarybemy raremyhỹre. Kia heka Pedro tamyreny rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro rarybemy raremyhỹu, Deuxu Tyytybytyhy ibutu rybe‑ò ijohonadu tyre‑ki resemy ralore. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pedro‑wana rare mahãdu, judeu mahãdu òbiti, tahe riòtiinyre judeukõdu mahãdu‑ki Deuxu Tyytybytyhy ralòmy rareki. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Raholare dori rybe witxira‑di raryberenyreò, tiiboho Deuxumy heka reàlàmyhỹre. Tahe Pedro tamyreny rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Inyõ rarybeõkre, iratysebedỹỹõmykemy, tiiboho dori Deuxu Tyytybytyhy‑di ratxirenyre inyweserenyle. ");
INSERT INTO kpjNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tahe Jesuisi Kristu nimy iratysebenykemy riteònyre. Tahe rexitòenyrenyre Pedro idi iyreny‑ki ijõ txumy ramyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Judeukõdu mahãdu Deuxu rybe roholamy rityhynymyhỹre. Kia‑ò tahe Jesuisi erydỹỹna mahãdu roholare kiamy ityhydỹỹdu seriòre mahãdu tule roholare. Judeia bede ludu ratximyhỹ mahãdu ibutumy kia rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pedro ixityre Jerusalẽ‑ò rehemynyreu, tahe judeu ityhydỹỹdu mahãdu tuu tamy narybede. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Kia heka, Pedro, judeukõdu mahãdu‑wana wiwo‑ki atxiteri, tii‑wana teroxiteri. Tai tahe ibinamy raharenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Iribi tahe Pedro ikoreny relyyre ibutumy taaõna aõnamy. Kia wesemy Pedro rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Jòpe hãwã‑ki watxiwãhã. Tahe rabire rasinawesemy rià nihikỹ biu‑ribi robehere‑ò. Iwese inyõ iòhòti inaubiòwa‑ki rimymyhỹre wesemy wadee robehemy roimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tahe aõbo heka iwo‑ki ratximyhỹdi, retehenihikỹmy rãiwãhã iròdu deborehekỹ wesemy ratximyhỹ iwo‑ki. Abòròrò wesemy tai ratximyhỹ, iròdu wese, nawii wese tai ratximyhỹ, inyboho rirỹsỹõmyhỹre wesemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Iribi raholare rybeõ‑ò: —Myike, Pedro, birubunyke hewa aõtxile birubunyke tibo biròkemy. Aõkõrewa Wanyrỹ, tiu heka reròõwãhãre. Judeu mahãdu bede ywina heka tiu iny kia riròõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","9","Tahe ixityre rybeõ tamy rarybere: —Marybeõke kia ibinamy. Aõbo Deuxu awimy rarybere, kia wiji tahe ibinamy aõkõ rare. Deuxu dee awikeki, kia awi rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Inataõ heka tuu rotỹỹnyre. Iribi tahe kia rià, ibutu‑wana iõre biuribihyy heka iõre. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Iribi tahe hãbu inataõ dehemynymy deade tai watxiwãhã‑ò. Tii diwaòryde riwadykremy Sesaria hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tahe Deuxu Tyytybytyhy wadee rarybere tii‑wana arakremy. Nohõtiõmy heka aõbo judeukõdu mahãdu raremy. Tii‑wana makre ele elemy. Tahe kia debò sohoji reurò seriòremy wahemy rare. Tahe retehemynyrenyre waòrysymy riteònyrenyre heto‑ò tahe ralòrenyre Oreniliu heto‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Iribi tahe Oreniliu rarybere iwese ỹju ihetowo‑ki tamy rexitỹnynyremy rarybereri: —Oreniliu, inyõ biteònyke Simaõ Pedro òrỹsymy Jòpe hãwã‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tii rybe tỹmyraõmy adeereny kanarybekre. Tai tahe ibutumy asỹ ijoi‑wana aòraru‑ribi kanatakre. Kia Oreniliu inydee rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Iribi tahe jiarỹ Rybewihikỹmy rexidelenymy rarybere tamy. Pedro rarybere. Urile tahe roholare, tahe aõwesele Deuxu Tyytybytyhy ityrereny resere iwo‑ò ralòkemy iwese watyrereny resere wesele juhuu. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tahe Jesuisi rybe wanohõti itxi reare tiubo raryberemy: —Joaõ heka inatyhymy bedi iny ratisebenyre, kaiboho tahe Deuxu Tyytybytyhy‑di akanasebedỹỹdenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Judeukõdu mahãdu Inynyrỹ Jesuisi Kristu rityhynymyhỹre. Tai Deuxu tamy diwahinyde iwese wadeereny juhu riwahinyre wesetyhyle. Deuxu Tyytybytyhy uriõno wesele tamyreny diwahinyde. Mobo jiarỹ raremy wahe tuu Deuxu dee aõmy ararybekemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Iribi Pedro rybe‑ò roholareu tahe timyhe tamy irybekõna. Tule Deuxu riwowydynyrenyre: —Inatyhy wa rare Deuxu heka judeukõdu mahãdu‑ò heka umytuedeõna riwahinyre. Inyõ rityhynykeki, ixirahĩkeki, tarasana rimyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Iu tahe Estevaõ rurureu, ityhydỹỹdu aõhõkỹmy rotỹỹnyreu tahe, ityhydỹỹdu mahãdu Jerusalẽ‑ribi ròhònyre. Tii heka relyymyhỹre Rybewihikỹmy judeu mahãduòle kỹny wahe, iwitxira witxira‑ò aõkõre. Tahe ibutu bede‑ò ritelenymy ròirenyre. Senisia‑ki relyyre. Xibri bedebute‑ki tule relyyre, Atxiòkia hãwã‑ki tule relyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ijõ ityhydỹỹdu mahãdu Jesuisi Rybewihikỹ tỹmyra rarybere. Tiiboho Xibri bedebute‑ribi ròhònyre, Sireni‑ribi ijõ rybedu ròhònyre Atxiòkia‑ò. Tiiboho relyyre judeukõdu mahãdu‑ò tule. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Deuxu riwiòhenanyre sõwemy iny rityhynyre, Jesuisi ryò ralòrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalẽ ityhydỹỹdu mahãdu kiamy roholare. Tai tahe Banabe riteònyrenyre Atxiòkia‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Banabe rehemynyreu tahe, tuu robire aõbo Deuxu kowa riwinyrerimy. Tai tahe reysare. Tahe ityhydỹỹdu tỹmyra‑ò dohodỹỹmy, riwiòhenanykremy: —Iòhòtyhymy Deuxu‑ribi atximahãbenyke, aworibityhy Deuxu bityhynybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabe heka hãbu wihikỹ rare. Tỹxihikỹlemy Deuxu Tyytybytyhy‑di ratximyhỹre. Ibutumy ratximyhỹre tyhydỹỹna‑di. Sõwemy iny rexiròtenyre Inynyrỹ mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Idi tahe Banabe rare Tarso hãwã‑ò Salu ijesemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tai rahareu tahe, didymyhe dòòsemy nade Atxiòkia‑ò. Sohoji beòramy idi bede rierenyre. Sõwemy iny ribedeerynymyhỹrenyre. Atxiòkia hãwã‑ki ityhydỹỹdu mahãdumy raninira Kristu wese mahãdumy. Kiani tamyreny riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Aõutxu tahe dehemynyde Deuxu rybedu mahãduõ Jerusalẽ‑ribi Atxiòkia‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ijõ Abusi inire. Iribi tahe tii rarybere Deuxu Tyytybytyhy rybemy. Ramamy rubu nihikỹ kanakremy raxireri, ibutu suò. Laujiu iòlòmy raremyhỹu, kiamy rotỹỹmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tai tahe ityhydỹỹdu mahãdu he nieru riwahinykremy rỹire Judeia bede sỹdu ityhydỹỹdu riwiòhenanykremy. Tahe nieru riwahinyre tiwesebo idi ratximyhỹre wesemy tamy riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tahe nieru riteònyre, moma‑wana Banabe Salu‑wana Jerusalẽ dohodỹỹna heto matuari mahãdu‑ò riwyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kia bededỹỹnanamy heka Herodi judeu iòlòmy raremyhỹ. Iribi tahe rexidelenymy riwinyre heka ityhydỹỹdu mahãdu kia òludumy risỹnykre myhỹ. Tii riteònyre aõna aõnamy risỹnykemy ityhydỹỹdu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tii mayrehe‑di rubudỹỹmy riteònyre Joaõ seriòre wahe, Txiau wahe. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Tai tahe judeu wedu mahãdu heka tamy wihikỹlemy tuu rotỹỹnyre. Herodi rierymy raremyhỹ idi Pedro rimyre. Tahe worana bedehesi rỹire. Paõ taurina ihoõ inire. Kia ibutumy rotỹỹnyre kia bedehesi rỹireu. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tahe Pedro riròtenyre, ròtenawomy wirutyre. Aõmamy soldado mahãdu inaubiòwamy iitxeredumy rỹimyhỹre. Pascoa kia worana bedehesi konana txu rexihumy rỹireu tahe, judeu mahãdu‑ò riwahinykre. Kia Herodi rexinohõtidỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ròtenawo‑ki tahe Pedro ratximyhỹre. Ityhydỹỹdu mahãdu tahe Deuxu‑ò rexitòenyhyymyhỹre Pedro tòenamy. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Txubiòwamy tahe itxu riywinyrenyre iny sõwehekỹ‑ò Pedro riwahinykemy. Kiamy Herodi rõhõtinyre. Ruu tahe Pedro rõrõmy roimyhỹ. Inatxi soldado heka idile ratximyhỹre. Pedro womati reroti inatxi‑di ratisamy roimyhỹre. Ijõ soldado rotena ijò‑ki ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Inynyrỹ ỹju heka Pedro weribi rihetenyre riixixanykemy. Loosòna itỹnyhỹkỹlemy ròtena ritoosònyre. Tamy rarybere: —Wylemy wa rexiukỹnyke. Tahe aõwesele Pedro axiò‑ribi womati rerotihikỹ rejuxunyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tahe ỹju tamy rarybere: —Awamy birutyke, bexityynyke. Kiamy riwinyra. Ijõ arahana birutyke tahe biwaheludunyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Iribi ròhònyra he tai rõrõreri‑ribi wahe. Kia ibutumy heka rasi weselemy Pedro rõhõtinyre rieryõre inatyhy aõbo ada rasi aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Juhu heka ikoludu soldado mahãdumy reare idi ihewoludumy reare iribi rehemynymy rỹire ahana ijòtyhy‑ò. Womatilere heka iijòtòbònare. Ixiwanale heka rarayre ijòtòbòna. Iribi tahe roirenyre hãwãry‑di ririranyrenyre. Idi tahe ỹjuhe iõre iribi. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tahe Pedro rõhõtinyre, rieryre heka aõhebo rotỹỹnyraò. Wanyrỹ ỹju riteònyre riwatara Herodi‑ribi judeu mahãdu‑ribi. Katahe wadee aõhe rotỹỹnyrenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Rõhõtinymy rỹire juhuu urihimyò idi tahe rare Marie heto‑ò. Joaõ Markuse heka tii rare. Tai ityhydỹỹdu mahãdu rỹimyhỹ tahe rexitòenyreriò Pedro tamy rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tahe ijò he rihetenyre. Ijòtàbòna‑ò nade mobo raremy rierykemy ijadòma deòdu. Rode inire. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tahe Pedro rybe rieryra. Reysamy raijaranyre iwo‑ò. Pedro tahe ralòõlemy rỹire. Tahe relyyre Pedro heto ijò‑ki rỹimyhỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tiiboho raryberenyre: —Kai tabinamy atxiteri. Ixityre rarybere: —Aõkõre tii taile naderi. Tahe raryberenyre: —Pedro aõkõ rare, taỹjulemy tahe rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tahe Pedro riheterihetenymy rỹimyhỹre. Idi riraynyrenyre. Pedromy robirenyrau, bede riòtiinyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedro tahe tamyreny tebò reara roholarenykemy. Tahe tamyreny relyyre timybo Inynyrỹ ròtena‑ribi rexiòlòdỹỹnyramy. Tule tamy riteònyre: —Kiamy belyyke Txiau‑ò tule inyseriòre‑ò. Tahe rexitare, rare ijõsỹ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Txuu ratỹnyreu, soldado mahãdu ierysymy wii risỹnyre timybo Pedro aõhebo rotỹỹnyramy. Tahe jei jei aõnire. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodi iijesemy riteònyre tai moõ tai rahaõhyylera. Tai soldado itxeredu sohoji sohoji dỹỹraximy riteònyra. Idi irubudỹỹmy riteònyra. Iribi tahe Herodi Judeia bede‑ribi ròhònyra. Sesaria hãwã‑ò bededỹỹnanaõ riwyra. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tiro hãwã mahãdu Sidoma beà hãwã mahãdu‑wana Herodi derarenyre. Tahe tiiboho ributunyrenyre tamy ròirenykemy rybe‑di. Iòlò heto‑di itxeredu Blastu inire. Tahe iny mahãdu Blastu ròtarenyre iwe‑ribi mahãdureny. Tahe ròirenyre Herodi‑ò tamy rexitòenyrenyre, tamy ykaraõmykemy. Tarỹsỹna dori diwyde iòlò bede‑ribi, Herodi bede‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodi tahe itxu riywinyre. Kia txuu tahe ròhònyre tamy. Rexityynyre taiòlòtyyrehe‑di tahe tarynana tyre‑ò ronyre, tamy Rybewihikỹmy rarybere. Tai tahe iny rirajuare: —Katahe hãbu aõkõ rarybereri, Deuxu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","23","Aõwesele Deuxu ỹju heka Herodi rirubunyre, tii Deuxutyhymy reàlàõreki. Woudò rubudỹỹnamy rurure. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Deuxu rybe tahe ibutumy roholare. Sõwemy iny tahe rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabe Salu‑wana nieru riwahinymy rahudi tahe, diòòsede Jerusalẽ‑ribi Atxiòkia‑ò. Joaõ Marku tii‑wana ridyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Atxiòkia dohodỹỹna heto mahãdu‑ki rybe tỹnydỹỹdu mahãduõ, bede erydỹỹdu mahãduõ rỹimyhỹre. Kaheka inireny rare: Banabe, Simaõ, iniraròsòna Nike rare. Lusiu ijõre, tii Sireni hãwã ludu rare. Manaĩ ijõre, tii Herodisỹ‑ki ratibienyre, Salu ijõre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ibutumy tahe Inynyrỹmy reàlàre, riroxiõhyy heka bede riemyhỹ. Tahe Deuxu Tyytybytyhy tamyreny rarybere: —Jiarỹ waaõmysỹdỹỹna dire Banabe‑ò, Salu‑ò. Kaiboho heka biteònybenykre kia riwinykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tahe roxiõhyymy bede riemy, rexitòenyrenyre. Tebòreny iratytyre ritidirenymy, idi riteònyrenyre tabede tỹina‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Deuxu Tyytybytyhy tahe tiiboho riteònyrenyre. Selusia hãwã‑ò tamy riberenyrenyre. Tahe hãwòõ rimyrenyre Xibri bedebute‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tahe rehemynyrenyre Salamina hãwã‑ò. Tai judeu dohodỹỹna heto‑ki Deuxu rybemy raryberenyre. Tule Juaõ Marku rare tii‑wana wiòhedỹỹdu wese heka rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tahe ibutumy bedebutemy rekoarenyre. Ritehemynyrenyre hãwãõ‑ò Pafumy ninadu‑ò. Tai tahe judeu mahãdu witxi deade, Bajesuisi heka inire. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tii Deuxu rybeduõmy raremyhỹmy iximy rarybere tahe aõkõre, raruire, riitxenanyre. Tii bedebute hãwã dinodu‑wana rare. Kadinoduni tahe Sergio‑Paulo inire. Tii hãbu bedeery nihikỹ rare. Tii Deuxu rybe‑ò roholakemy ratxireri. Tahe didyde Salu, Banabe‑wana tamy roholakemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bajesuisi, Elimasi ijõ ini rare. Tahe tii bedebute dinodu‑ò rarybere uritere Salu rybe‑ò, Banabe rybe‑ò ijohonakõmykemy. Wanyrỹ tyhydỹỹkõmykemy dori tuu risỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Salu tahe, Paulo ijõ ini rare. Deuxu Tyytybytyhy heka itykymy ralòmy rỹimyhỹre. Tahe Paulo retehere Elimasi‑ò tamy rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","—Kai Satanasi riòre tate. Kai heka ibutu itxenadỹỹ‑di tỹxihikỹlemy ahãte. Kai heka awihikỹ òludu tate. Tiubo heka bexihukre Inynyrỹ‑ribi iny riixãwididỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Deuxu heka wiji araòwynykre, aõhõkỹmy arasỹnykre, aruetàmy bonykre. Txu bobiõkre bede biwyke. Iule tahe aõwesele bede torohokỹlemy reare. Robiõhyymy reare. Urile riemy ratximyhỹre, iny riwiòhenanykemy, ryy tamy ritỹnynykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tahe kia bedebute dinodu tuu robire aõhebo rotỹỹnyramy, tai bede riòtiinymy ronymyhỹ tahe tii Inynyrỹ rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Iribi tahe Paulo ròhònyra taijoi‑wana Pafu hãwã‑ribi. Rakremy riberenyra hãwã nihikỹ‑ki Panfilia bede‑ò, Peke hãwã‑ò. Juaõ Marku iribireny rexitara, dòòsede Jerusalẽ‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tahe Paulo Banabe‑wana roirenyre. Peke‑ribi riòlònyre tahe rekoarenyre Atxiòkia‑ò. Kaa iwitxira Atxiòkia hãwã rare, Pisidia bede‑ki ratxireri. Tahe rirònyrenyre judeu mahãdu dohodỹỹna heto‑ò. Sabado txu rỹire. Ronymyhỹre ijohonamy. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kia hãbu mahãdu heka Moisesi bede ywina tyyriti‑di, Deuxu rybemy rybedu mahãdu tyyriti‑di rariamyhỹre. Tahe dohodỹỹna heto wedu Pauloboho‑ò raryberenykemy rarybere: —Waseriòre, arybemy idi atxiteri‑wana marybeke aõwaxiny bitỹnyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tahe Paulo rỹire lamamy. Iwese rybedỹỹmy ròteòsidỹỹmyhỹre wese rỹire. Tahe rexidelenyre: —Hãbu, Israeli mahãdu, tule ibutumy Deuxu rityhynymy rỹira mahãdu, bodoholabedenyke kaa ijyy‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israeli mahãdu Egito‑ki rasỹnyreu, taDeuxu iribi ritare, moma, inytybyreny Deuxu, Israeli mahãdu tybyreny wahe. Deuxu rasõwedỹỹnyre. Iribi tahe Deuxu Egito‑ribi ritarenyre tebò ruruteretyhy‑di. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tiiboho bederahy‑ki 40 beòramy bede riereu, Deuxu taaõbina bina riòludunyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kanaã bede‑ki debò inatxi reuròmy ixỹju ixỹju mahãdumy rahure. Idi tamyreny riwahinyre bede, isỹhyymy rarekemy. Idi tahe rybe ywisidỹỹdu mahãdu tamy riwahinyre. 450 beòra rahureu, tahe Samueli Deuxu rybeduõmy raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Idi tahe rybe ywisidỹỹdu mahãdu tamy riwahinyre. Tahe 450 beòra rahureu, Samueli Deuxu rybeduõmy raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Iribi iny Deuxu‑ò rexitòenyre iòlòmy tamy kadiwahinykemy. Tahe Deuxu Salu tamy riwahinyre, iòlòmy. Salu tahe Kixi riòre rare. Benjami mahãdu rare. Tahe 40 beòramy iòlòmy ronyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Salu iribi ritareu, tahe Davi, Deuxu ritamadỹỹnyre iòlòmy. Deuxu Davimy rarybere: —Davi Ijese riòre rare. Jiarỹ iluure. Tii ibutu wadee wimy riwinykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tahe Davi riòkòre‑ribi Jesuisi ròhònyre, Israeli tarasadumy rarekemy. Iwese juhuu Deuxu rarybere wese. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesuisi naõdeu, Juaõ ritỹnynyre Israeli mahãdu‑ò iòrarureny ririkemy idi raratisebenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Juaõ rybe tỹnydỹỹna kõnanau, tamyreny rarebere: —Jiarỹ wa iwese tahõtinytenyteri wese aõkõ jiarỹ rare. Kaiboho tiwaraòõhyymahãtenyte. Betehebenyke, tii, wahewomy kanakre. Jiarỹ aõ aõkõ rare, iwatisana arieseõtyhy iwa ritakemy, tii dori waratyre wihikỹreki. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Waseriòreboho, Abraõ riòre riòremy ibutumy inyboho roire, tule Deuxu reàlàmy rỹira mahãdu kaki ratximyhỹ. Deuxu inydeereny biu‑ò hedu rybe diwahinyde. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalẽ mahãdu, iwedureny‑wana raeryõhyyre tii tarasadu rare. Ibutumy sabado txu rybedu tyyriti‑di rariamyhỹre tohodỹỹna heto‑ki, tahe aõbo rare rieryõhyyre. Jesuisi rubudỹỹmy raryberenyreu, iwese rybeduõ rarybere wese, tiiboho rotỹỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Tiiboho aõbina bina‑ki tai rahaõhyyra, ihãrele irubudỹỹmy rexitòenyre Pilato‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Iwese ibutumy Jesuisimy riritinymy roireri wese, ibutumy tuu ròhònyre. Tahe itxeò nihikỹ tyre‑ribi ritarenyre. Tahe mana hãloo rawo‑ò ritidirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tahe Deuxu rubu‑ribi riixixadỹỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tii‑wana iny mahãduõ roirenyre juhuu Kalileia‑ribi Jerusalẽ‑ò. Rexixamy rahudi tahe, tii mahãdule tuu robihyymy txuu widireny rỹire. Kia mahãdule inysõwey‑ki relyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Deuxu juhuu rarybere inytybyreny‑ò aõhebo rotỹỹnykremy. Inydeereny tahe tii riwinyre Jesuisi riixixanyreki. Kia Rybewihikỹmy adeereny relyymahãrenyre. Iwese inatxi wiuna ritidỹỹna‑ki roire wese: —Kai waRiòre tate. Wiji tahe bomy watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kiamy heka Deuxu rarybere Jesuisimy: —Rubu‑ribi ariixixanykemy, tiu rasunymyhỹre bede‑ò ròòseõtyhy. Iwese Davi‑ò jiarỹ rarybere wesemy ibutumy adee bede ariywinykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Deuxu ijõ wiuna Ritidỹỹna‑ki tule rarybere. Iwese Jesuisile rarybere wese, kiamy roire: —Eòdutyhy umy rasỹnyõtyhy kai dori waumysudỹỹ‑ò teijemahãte. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Iu Davi Deuxu dee taijoi riwiòhenanymy rahudi tahe, rurure. Tybyreny‑ò tii rara. Iumy tahe rasunyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jesuisi umy tahe rasunyõre Deuxu dori rubu‑ribi riixixadỹỹnyreki. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Jesuisi bityhynybenykeki, aòraru riixãwidinyke. Kiamy Moisesi bede ywina ihoõhyyre adeereny. Kia bierybenyke waseriòreboho, tiile, Jesuisi, adeereny relyywãhãrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Bexiijebenyke, kiamy adeereny rotỹỹnyke lau iwese rybedu ritina‑ki roire wese: ");
INSERT INTO kpjNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","—Kaiboho inatyhy derare. Betehebenyke, burubenyke, bede biòtiinybenyke, aõbo jiarỹ rewinyreriò. Inyõ adeereny ritỹnynyke ihãrele. Tiu heka bityhynybenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tahe Paulo irybe rexihura. Iribi ròhònyre Banabe‑wana. Rexitòenyrenyre ijõ sabado biòwau tarybetybydile ixybyle relyykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Iny ritobinymy rahudi, judeu mahãduõ, judeu bede erydỹỹna ityhydỹỹdu mahãduõ tule Banabe Paulo‑wana riheludunyre. Tahe tamyreny raryberenyre: —Deuxu ruxetòena‑ki idi mariahyymyhỹkemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ijõ sabado rehemynyreu, ibutu iny hãwã‑ribi doimyhỹdenyde Deuxu rybe‑ò ijohonamy. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Judeu mahãdu tahe inysõwemy robireu, tiiboho rexiwaritinymyhỹrenyre. Tiiboho raryberenyre aõbinahãkỹlemy Deuxuru‑ò. Paulo riki inatyhymy aõkõ tii rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paulo Banabe‑wana ihãrele brebuõlemy raryberenyre: —Juhuu adeereny Deuxu rybe dobehede. Tahe kaiboho tetyhynyõtenyte, tai judeukõdu mahãdu‑ò aroirenykre. Kaiboho Deuxu rybe terarenyreki, ixi sohojile tahe tetaõte adeereny aõ aõkõreki. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kia Inynyrỹ bede ywina wadeereny riwahinyre: —Kai loosòna wesemy atxikre judeukõdu mahãdu‑ò. Kai tarasanary ritỹnynykre ibutu inyko‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Judeukõdu mahãdu kia‑ò roholareu, tahe reysarenyre. Deuxu rybe riwowydynyrenyre tai. Tahe rityhynyre, timybo Deuxu juhuu ritare wesele tamyreny umytuedeõna riwahinyremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Inynyrỹ rybemy kia bede‑ki ibutumy relyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tahe judeu mahãdu rarybere hãwyywihikỹ ityhy‑ò, tule hãwã wedu‑ò. Tai tahe Paulo Banabe‑ò òludu sõwemy resere. Tahe isubede‑ribi riteònyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Paulo Banabe‑wana tawa‑ribi bryby riòhòwirenyre tamyreny tiiboho ibinareki. Tahe Ionio hãwã‑ò roirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Atxiòkia ityhydỹỹdu mahãdu tahe reysamy rỹimyhỹre. Deuxu Tyytybytyhy‑di tỹximy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ionio hãwã‑ò Paulo Banabe‑wana rare. Judeu mahãdu dohodỹỹna heto‑ò. Tahe rybe ritỹnyrenyre, tarurumy he relyyrenyre. Sõwemy judeu mahãdu, judeukõdu mahãdu‑wana rityhynyrenyre ijyy. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tahe ijõ judeu mahãduõ rityhynyõre. Ijyy deramy reamyhỹre, tule ijõ‑ò tule rarybere ityhynyõkemy. Tahe Paulomy, Banabemy aõ òta òtalemy rarybemyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ihãrele tahe Paulo Banabe‑wana bede nihikỹ riwyrenyre tai. Tamy rybe ritỹnyhyy roiremyhỹ ibrebuõlemy. Inynyrỹ taruxetòena rybetyhydỹỹnamy riwiòhenanyre tiiboho bedeòbyna widỹỹdu renyreki. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Hãwã mahãdu ritxuare. Ijõ heka judeu wedu mahãdu rityhynymyhỹre, ijõ tahe Paulo Banabeboho rityhynymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Judeukõdu mahãdu, judeu mahãdu, tawedureny‑wana widee rarybere Paulo Banabe‑wana riòkòròrenykemy tamy mana‑di rehurenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Tahe tiiboho rexieryrenyre tahe rihenyrenyre. Tahe ròirenyre Listra hãwã‑ò, Debi hãwã‑ò, kia Laonia hãwã hãwã‑ò rare. Tule rariarenyre kowa bedewo‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Tahe kowa tiiemy ritỹnyhyy roiremyhỹ Rybe tỹmyra wihikỹ‑di. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra hãwã‑ki heka hãbuõ‑txi rekoarenyre, itierere heka. Taihyy heka ronymyhỹre. Tuuhyy heka ratohouãmy ijarananyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tii tahe Paulo rybe‑ò roholare. Paulo tamy retehere. Kia tahe Paulo rieryre hãbu teytetyhynadire Paulo riteytenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tai tahe tamy rarybere tarybe riterenymy: —Mynyike, òbitimy. Ta hãbu rexiwatxinyre, rariare. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ijohona mahãdumy robireu, aõbo Paulo riwinyremy tahe rirajuare tarybe‑di, Laonia rybe‑di: —Ka hãbu mahãdu heka deuxu wesemy idi rexinohõtidỹỹnymyhỹre. Inydeereny deuxu wesemy dobehede. Iumyreny tahe hãbu wesemy rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabe heka, Jupitemy tadeuxurenyniõmy rininire. Paulo tahe ijõnimy, Meuriumy rininirenyre irybe sõwetyhyreki, tii rybedureki. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jupite xiwena wydydu horeru bederade‑di dehemynyde. Tohodỹỹna heto hãwã ahana ube‑ki rỹire. Broreni xiwe wesena tamyreny hãwã mahãdu riworonykemy, riwahinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kiamy roholareu, Paulo Banabe‑wana tatykyreny riykaranyre idi rihurenyre. Tahe ralòmy reare inysõwey‑txi rarybekemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Tamy ryryre: —Aõhebo tatỹỹnytenyteri. Jiarỹboho hãbulemy watxirenyreri. Kialemy adeereny rarybewãhãre, Deuxu rybetỹmyra wihikỹ. Adeuxureny‑di nohõtirenyõmy. Bedewidỹỹdu ta mohõtinybenyke. Tii dori benihikỹ riwinyre, ibutumy biu‑ki riwinyre, tahe Deuxutyhy‑di mohõtinybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ihetxiu Deuxu ibutumy bede bedemy sỹdu ririre ixidee wimy aõna aõnamy rotỹỹnykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Urile tahe tamy rexideòsinyre tamy biu riwahinyre taoworumy raratynykemy. Tai tahe kaiboho arỹsỹna dire, Deuxu debò‑ribi, awo‑ki eysanadire. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ihãrele iny tamy xiwe wesena tamy riwahinykemy ratxireri. Paulo tamyreny rarybere: —Aõkõ, inydeereny bidiwahinyõke. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Iribi tahe judeu mahãdu‑ò Atxiòkia‑ribi, Ionio‑ribi tamyreny raryberenyre Paulo rubudỹỹmy. Hãwã òtityube‑ò Paulo ridyrenyre. Mana‑di tamy rehumyhỹ. Tahe rubu wesemy ririrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Idi tahe ityhydỹỹduõ tamy wirotyre. Paulo tahe suribi rỹire tahe tii‑wana nalòde hãwã‑ò. Ijõtxu biòwamy tahe Banabe‑wana Paulo rexitare ijõ hãwã‑ò, Debi hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ka hãwã‑ki tahe Paulo rybe tỹmyra wihikỹ ritỹnynyre. Sõwemy tai rityhynyreu, Pauloboho ròòserenyre Listra hãwã‑ò, Ionio hãwã‑ò, Atxiòkia‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ibutumy hãwã‑ki Pauloboho ityhydỹỹdu mahãdu riwiòhenanyrenyre, tiiboho rityhynyhyymy ratximyhỹkemy. Tamyreny rarybere: —Kaiboho aõhõkỹmy botỹỹnybenyke, ihãrele malòkemy titxibo Deuxu Iòlò ratximyhỹre‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ibutu ityhydỹỹdu mahãduy ribi ritamy rỹimyhỹ rarekremy, idinodumy. Matuari mahãdu‑ribi tii ritare. Iu ritareu tahe, rexitòenyre Deuxu‑ò tule byreõhyy txuõ riwyrenyre. Inynyrỹ‑ò rexitòenyre: —Kia ibutumy aratyhynyreri, tai tahe biywinymy ahãke. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","25","Pisidia bede‑ki rekoamyhỹrenyre Panfilia bede‑ò. Kowa‑ò Rybewihikỹ tỹmyramy relyymy rahudi Peke‑ki, Atalia hãwã‑ò dobehede. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tai hãwò nihikỹ welòdi‑di rimyrenyre. Tahe Atxiòkia‑ò rorore. Kowa‑ribi juhuule rybe tỹmyra wihikỹ ijyy‑di dòhònyde. Kowa juhuu rexitòenyre tamyreny Deuxu ruxetòena‑wana rarekemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Atxiòkia‑ò rehemynyreu, Paulo, ibutumy ityhydỹỹdu mahãdu ditotynyde. Tai heka tamyreny rarybere iwese Deuxu riwiòhenanyre wese ibutumy iaõmydỹỹnana‑di. Iwese judeukõdu mahãdu rityhynykemy. Deuxu tamy ityhyna ijòtòbòna riraynyre wese. ");
INSERT INTO kpjNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Idi bededỹỹnana riwynihikỹre ityhydỹỹdu mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Hãbuõ Judeia mahãduõ ditehemynydenyde ta teòsamy ribedeerynyrenyre. Kawese ribedeerynyre: —Moisesi Tyyriti bede ywina, notykyresynamy, rityhynyõkeki, iny rataõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Iribi tahe Paulo Banabe‑wana tamyreny rarybehyy rare. Tai tahe inyõ tamy rarybere Jerusalẽ matuari mahãdu‑ò roirenykemy aõmydỹỹnana rexiòbitinyrenykemy. Iny witxira‑ò Jesuisi erydỹỹna mahãdu‑ò rarybekemy heka tamy, Pauloboho iteòdỹỹmy rarybere. Tahe ijõ hãbu mahãduõ tule tiiboho‑wana riteònyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Dỹỹraximy heka tamy ròirenyre, aõ aõmydỹỹnabo ratxirerímy wahe. Sõwemy dohodỹỹna mahãdu ihemy roirenyre urihimyò, tai tahe ririrenyre. Tahe Senisia bede bedemy, Samaria bede bedemy riòhòrerenyre. Relyyre judeukõdu mahãdu tule ityhydỹỹdu mahãdu‑ki rỹirerimy. Tai ibutumy ityhydỹỹdu mahãdu reysare. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tahe ritehemynyrenyre Jerusalẽ‑ò. Wihe ritotynyrenyre ityhydỹỹdu dinodu‑wana, tule matuari mahãdu‑wana, Jesuisi erydỹỹdu mahãdu‑wana. Tiiboho relyyrenyre aõmybo Deuxu rotỹỹnyre iyreny‑ki, timybo riwiòhenanyré. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tahe hãbu mahãduõ tai raremyhỹ heka. Juhuu heka fariseu mahãdumy ihỹre, idi tahe ityhydỹỹdumy ralore. Imahãdu‑ribi ijõ rỹire ribedeerynykremy. Tahe rarybere: —Inydeereny kia wese rare. Judeukõdu tyhydỹỹdu ibutumy notyyresyna‑di ròhònyke. Tule ibutumy Moisesi bede ywina ibutumy rityhynykemy. Kawesemy tamy ribedeerynyre òbitimy aõkõ watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Idi tahe Jesuisi erydỹỹna, matuari mahãdu‑wana wii ributunyre rybe òbitidỹỹmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Rybe sõwemy rahude tahe, Pedro rỹire tamyreny rarybekemy: —Waseriòreboho, Deuxu juhu riwatare Rybewihikỹ rybedumy judeukõdu mahãdu‑ò tuu aritỹnynykremy, tiiboho tule rityhynyrenykremy. Tai rarewãhã. Kaiboho kia ibutumy teerytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Iwese inydeereny riwahinyre wese, Deuxu Tyytybytyhy tamyreny tule riwahinyre. Judeukõdu mahãduõ tule ixidee rimykemy. Kia wese tuu riteòsinyre inydeereny. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Deuxu wiribi lahitximy aõkõ iny riwinyrenyre. Wiwesehyyle ihỹre. Tiiboho inywesele ihỹrenyre. Tiiboho rityhynyrenyreu, heka irayky rityranyrenykemy ritarenyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kia wese Deuxu teurihitenyteri. Kia bede ywina itxyynautxiehekỹ wesere ityhydỹỹdu mahãdu tyre‑ki tetiditenyteri. Inytybyreny tiu retyyõre tule inyboho idi retyyõre. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Inynyrỹ, ruxetòenale‑di iny ritamyhỹre. Tule judeukõdu mahãdu kia weselere ritamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tahe aõmy rarybeõhyyrenyre. Ibutumy he Paulo Banabeboho rarybereò, roholarenyre. Tiiboho heka relyyrenyre tule bedeòby wihikỹ aõna aõna‑wana Deuxu riwinyremy tadebò‑di wahe. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","14","Iribi tahe rexihurenyreu tasỹ, Txiau rỹire rarybekremy: —Waseriòreboho, bodoholabedenykre inihe warybe‑ò: —Pedro kỹny adeereny rarybere, timybo Deuxu judeukõdu mahãdu roramy rare iny mahãduõ ixidee ritakremy tanityhy‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kiawesemy he tule ihetxiu Deuxu rybemy rybedu mahãdu riritinyre, kamy wahe: ");
INSERT INTO kpjNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","—Wanyrỹ heka rarybera: —Adòòsekre, ixyby ariywinymy aritamadỹỹnykre aõdohodỹỹna heto Davi juhuu riwinyre. Idi tahe resere. Ixyby ariwinykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Tai tahe judeukõdu mahãdu‑ribi iuhe riwaòrykre wamy rityhynykemy. Wanyrỹ, Deuxu, kiamy heka tiiboho rarybekre, ibutumy jiarỹ retarenyreki. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kawesemy Wanyrỹ tuhyy rarybemy raremyhỹ, tule wiji ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Tai heka kiawidỹỹõmy rakatximyhỹrenykre. Tamyreny rybeõmy rakatximyhỹrenyke. Judeukõdu mahãdu Deuxumy rityhynyrenyreu, iny bede ywina reny tyhydỹỹmy tamyreny rybeõmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kialemy heka tamyreny rakaryberenykre: Suritxoo xiwe‑ribi iròdude ròrenyõmy. Tule òta òta òraruna widỹỹõmy, iròdu hãlubu‑di ròrenyõmy, ihãlubu rejuxunyõmyhỹre‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kiamy heka rakatximyhỹrenyke. Moisesi bede ywina‑di dori ibutu hãwã‑ki judeu dohodỹỹna heto‑ki rariamy raremyhỹ. Sabadotxu ihyymy aõkõ kia ritỹnynymy raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tahe kiamy heka rahõtinyrenyre, Jesuisi erydỹỹna mahãdu, ibutumy dohodỹỹna mahãdu‑wana, hãbuõ ayreny‑ribi rikitakre. Tai Atxiòkia‑ò riteònyrenykemy Paulo Banabe‑wana. Tahe Judasi ritarenyre tule iniòrysyna Basaba rare. Ijõ tasỹ Sila inire. Ka hãbuboho ityhydỹỹdu mahãdu awimy tai raharenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Katyyriti tiiboho‑wana rakre. Kawesemy tyyriti rare: —Jiarỹboho, erydỹỹna, matuari, seriòre mahãdu adeereny rybe wehityhyna rewahinyreri. Ibutumy judeukõdu mahãdu ityhydỹỹdu‑ò ka tyyriti rakre Atxiòkia hãwã‑ò, Siria bede‑ò, Silisia bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Inyõ rare wayreny‑ribi adeereny notykyresymy rybemy. Tai tahe araykyreny riwerydỹỹnyre. Jiarỹboho reteònyrenyõhyyre. Kia reerymy watxirenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Tahe wiwesele rahõtinyrenyre riki, hãbubohoõ Paulo Banabe inyluudu‑wana reteònyrenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Kia hãbu Paulo Banabe‑wana hãwã binahakỹ‑ò roimyhỹrenyre Jesuisi Kristu Inynyrỹni‑di. Ixi‑txi rõhõtinyõlere, brebumy. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Judasi‑wana tule adee raryberenykre kia aõmydỹỹnanamy, katyyriti rewahinyrenyre wese. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kawese inyboho rõhõtinymyhỹre, Deuxu Tyytybytyhy dori inyrayky rewiòhenanyre. Kia bede ywinalemy adeereny rarybereri biywinybenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Uritere, suritxoo xiwe‑ribi iròdude ròrenyõmy iròdu, ihãlubu‑di ròrenyõmy, ihãlubu rejuxunyõmyhỹre‑wana. Tule òta òtana òraruna widỹỹõmy. Ka bede ywina biywinybenykeki, awimy boibeke. Deuxu deysana tahe adeereny kanakemy watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tahe hãbuõ iny inaubiòwamy Atxiòkia hãwã‑ò ròirenyre. Tahe Atxiòkia tyhydỹỹdu mahãdu ributunyre. Iu tahe tamyreny tyyriti riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tahe idi rariarenyreu, ritỹnynymy tamyreny. Ribedeerynyrenyre. Tai tahe reysarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judasi Silaboho tule Deuxu dee rybeduwihikỹ roire. Sõwemy dohodỹỹna‑ki seriòre mahãdu‑wana rohonymyhỹre. Tai tahe rirurudỹỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Aõutxumy raroorehenyre, tahe seriòre mahãdu tamyreny rarybere: —Bòibenyke he ateòdỹỹdu mahãdu‑ò. Biòkeseke wowina‑di Jerusalẽ hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Tahe Sila rõhõtinyre rarikremy Atxiòkia‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Tahe Paulo Banabe‑wana naride Atxiòkiakile. Inynyrỹ rybemy rierynanyrenyreri, ritỹnynyrenyreri, ijõ seriòreõ‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Aõutxumy tahe Paulo rarybere Banabe‑ò: —Ròkòòsekre kỹnyhe, ibutumy hãwã hãwã‑di tai juhuu Inynyrỹ rybemy ritỹnynymahãreò wahe, rikiwehityhynanykremy timybo ityhydỹỹdu mahãdu nyimyhỹde‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Tahe Banabe Joaõ‑Marku ridykemy tamy reare. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Paulo heka Joaõ‑Marku ridyõkemy ratxireri, Panfilia hãwã‑ki dori iribireny ròhònyreki, riwiòhenanyõreki. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Marku ridykemy wiwese wesemy aõkõ rõhõtinyrenyre teratyhylemy ratximyhỹ. Tai tahe wiribi rexihitxinyrenyre, Banabe Paulo‑ribi. Banabe Marku ridyra Xibri bedebute‑ò, hãwò‑di ròira. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulo tahe Sila ridyra. Seriòre mahãdu tahe Pauloboho riixitòedỹỹnyre, Inynyrỹ ruxetòena tamyreny kanakemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tahe Siria bede werawo‑di, Silisia bede werawo‑di, ririranyre dohodỹỹna mahãdu riwiòhenanykemy, rirurudỹỹnymyhỹkemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pauloboho tahe Debi hãwã‑ò rehemynyre. Ihyy tahe Listra hãwã‑ò rare. Tai tahe Tximòtxi‑wana witxi rekoare. Tximòtxise judea tyhydỹỹduõ rare. Tyby tahe grego mahãduõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra, Ionio ityhydỹỹdu seriòre Tximòtxi luure. Tximòtximy widee rarybere: —Tii iny hãbu tyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Tahe Paulo Tximòtxi‑wana rakemy rexiywinymy raremyhỹ. Tahe rexitarenykre kotyreu, Paulo, Tximòtxi notykyresymy riteònyre, kowa judeu mahãdu òraru‑ki wahe. Tyby dorihe ibutumy iny rieryre tii grego mahãdu raremy. Notykyresykõmy rake tahe judeu mahãdu dee kia ibinare. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Iribi tahe ròirenyre hãwã hãwã‑di, ityhydỹỹdu seriòre mahãdu ribedeerydỹỹnykemy, timybo Jerusalẽ mahãdu rõhõtinymyhỹremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tai tahe ibutumy dohodỹỹna heto mahãdu tii rirurudỹỹnymyhỹre ityhydỹỹna‑di. Tule ijò rityhynymyhỹre txuõ txuõlemy ralokemy ityhydỹỹduõmy rarekemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pauloboho Asia bede‑ò ròirenyõre rybe ritỹnynykemy, Deuxu Tyytybytyhy ritirỹreki. Tahe Frigia‑Alatxia bedemy rekoamyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia bede‑ò rehemynyreu, Bitinia bede‑ò ròirenykemy riwisỹnyrenyre. Tahe Jesuisi Tyytyby tamy riteònyõhyyre, ritirỹmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tahe Misia bedemy rekoare, tahe Troaji hãwã‑ò robehere. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tahe Paulo hãbuõ wesemy robire rasina weselemy. Hãbu, Macedonia bede ludu lamamy rỹimyhỹò, tuu robire. Tahe hãbu ryrymyhỹ tamy: —Manake Macedonia‑ò, biwawiòhenanykemy. Kia Paulo rasi‑ki tuu robire wese. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Tahe tarasi rahureu, tamyhe wylemy aroikemy watxiwãhãrenyre. Jiarỹ, Luka, Paulo‑wana. Deuxu dori inydeereny rarybereri Macedonia‑ò ròkòirenykremy, Rybewehikỹ rikiubỹtỹnyrenykemy. Kialemy rõkõhõtinyrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tahe Troaji hãwã‑ribi ròhònyre hãwò yhywydynalaworo‑ki. Samotrasia hãwã‑ò imynahyy riòhòrere. Ijõ txu tahe Niapoli hãwã‑ò riòhòreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Iribi tahe Filiposi hãwã‑ò roirenyre. Juhuludu hãwã rare Macedonia bede‑ki. Roma hãwã mahãduõ tule tai rasỹnymyhỹre. Tai txuõ rewyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabadotxu tahe hãwã‑ribi reòlònyrenyre bero ijà‑ò. Rahõtinyrenyre tai ixitòedỹỹna‑ò rỹimyhỹremy. Tai tahe hãwyyõ rexibutunymy rỹimyhỹ. Tahe rorokorenyre tamyreny raryberenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Hãwyyõ Lidia inire, inyrybe‑ò tahe roholatyhymyhỹre. Tii Txiatira hãwã luduõ rare. Tii tylỹre ijohodure, tule Deuxu tyhydỹỹdure. Inynyrỹ irayky riywinyre Paulo rybe rityhynykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Tahe ibutumy isỹmahãdu‑wana riratysebenyre. Tai tahe tamy Lidia rarybere: —Inaanokàbo ityhydỹkỹdumy watxiwãhãre‑wana, wahetoku‑kò manakre. Tai tahe iheto‑ò ròirenyre irybe‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Aõutxumy tahe riberenyre ixitòedỹỹna‑ò. Itxi rekoarenyre ijadòmaõ‑txi, deòdu rare. Iwo‑ki tyytybybina ralòmy rỹire. Tai ijadòma relyyre inyko aõhebo iny‑ò rotỹỹnykremy. Tai sõwemy nieru ritare tawedu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tahe waherenymy dyrymy nade: —Deuxu ibuturatyre rare. Iteòdỹkỹna mahãdu kia mahãdu rare. Tikiboho rarybemyhỹre timybo iny taòraru‑ribi ratakemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tuheka rarybehyy raremyhỹ. Aõutxumy tahe Paulo tai rexirare, tamy ròòsemy reare. Rarybere tyytybybina tai ratxireríò: —Jesuisi Kristu nimy iribi arateònykre. Bexitakre. Tahe aõwesele iribi ròhònymy reare. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Iwedu tahe rieryre nieru idi ritaõkre ta rimyrenyre Paulo Sila‑wana. Retỹhimy rare ywisidỹỹdu‑ò, hãwã elehyna ube‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tahe ijadòma wedu rarybere ywisidỹỹdu mahãdu‑ò: —Kaa judeu mahãdu iny hãwãreny dibinadỹỹnymyhỹde. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Tiiboho iny ribedeerynymyhỹre aõ iny bede ywinareny‑di aõkõ. Inyboho Roma hãwã mahãdu rare. Tai kia‑ki aõhe arotỹỹnyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tai tahe sõwemy iny Paulo Sila radònyre. Ywisidỹỹdu mahãdu tahe ityy ibòrò‑ribi ritxuahakỹre idi tahe rityhenymy tuu raòhòtere. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tuu raòhòtere, tuu raòhòtere, idi tahe ròtenawo‑ò idi rehurenyre. Ròtena‑di itxeredu‑ò rarybere: —Kaa rahenykre‑wana, kaile budurukre. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tai rirutere iraru‑txi rarutxi‑ò iwa ritidire òwòru iwodỹỹwomy raratyheny. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ruetya tahe Paulo Sila‑wana rexitòenymy roimyhỹ Deuxu dee. Ijõ ròtenawoludu mahãdu roholamy rỹimyhỹ tai. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Aõwese bede ramytatare. Ròtena ijòtòbòna rirayre hãbu mynyna iribi rejuxunyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tai tahe itxeredu ijò iraymy idi retehereu, rexirubunykemy tamaydese ritare. Ròtena woludu mahãdu rahenyramy tii rexinohõtinyra. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Paulo tahe tamy ryryre: —Ixirubudỹỹõmyke, kakile watxirenyreri, ibutuhukỹlemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Itxeredu ryryre loosòna kidiwykemy tahe ralore ramytatamy brebumy. Paulobohoko‑ò resere tatiòhomy. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tahe itxeredu diòlòdỹỹnyde irarutxira‑ribi, tamyreny rarybere: —Wanyrỹboho timybohe aratamy arỹike. Aõhebohe arotỹỹnyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tahe rirawyònyre: —Inynyrỹ Jesuisi bityhynykrekile, tarasanamy myikre, asỹ mahãdu‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tahe tamy Deuxu Rybe‑di ritỹnydỹỹre ibutumy isỹ mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Iruule tahe riwisinanyrenyra ibrò wotõmona risuhòra. Idi tahe itxeredu raratysebenyre tasỹ mahãdu‑wana ibutumy. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Iribi tahe itxeredu ridyrenyre taheto‑ò riroxikemy tahe ibutumy reysanihikỹrenyre, Deuxu rityhynyrenyraki. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Txu deadeu tahe ywisidỹỹna dinodu ijõ ywisidỹỹna mahãdu riteònyre, ròtena‑ribi Pauloboho riteònykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Itxeredu tahe Pauloboho‑ò rarybere: —Ywisidỹỹna mahãdu arateònykremy riwateònyreri. Bòibenyhe, wowina‑di, biòlònybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Paulo tahe rirawyònyre: —Aõkõre, araõtyhy. Jiarỹboho Roma hãwãhãkỹ mahãdu kaa watxirenyreri. Tii riwayhytanyrenyra idi ròtenawo‑ki riwasỹnyrenyra. Ywisidỹỹdu mahãdu wii rotykõhyyre riwaròtenyrenyra. Wasimy ka tiu ariòlònyõtyhy. Tiiboho kodoikreule tahe ariòlònykre. Tii he riwaòlòdỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tahe ywisidỹỹna mahãdu tawedu‑ò rarybere. Tahe tiiboho ruberurenyre Pauloboho Roma hãwã mahãdu roireki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tai tahe dòidenyde tamyreny, aõwaxina riòlònykremy. Tahe làhàmy tamy rexitòenyre. Tutyhy‑ki aõkõ làhà ararutara. Tai riteònyrenyreu, hãwã‑ribi rexitarenykemy tamy rexitòenyra. ");
INSERT INTO kpjNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Rexitarenyreu, Pauloboho tahe Lidia heto‑ò ròòsere. Ibutumy ityhydỹỹdu tahe wii ritotynyre, wii riwiòhenanykemy. Idi tahe riòlònyre kia hãwã‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","2","Tiiboho rekoarenyre Afipoli hãwãmy, Apòlonia hãwãmy tahe rehemynyre Tesalonia hãwã‑ò. Judeu dohodỹỹna hetoõ tai rỹimyhỹreò. Paulo, iwese aõu riwinymyhỹre wesele rare tamy. Ralore rybe‑di rarybekemy. Inataõ sabadomy tai riraynyre tyyriti ritidỹỹna tamy ritỹnynykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Rybe hitxina rurukremy tuu relyyre. Tahe Paulo tamyreny ritỹnynyre iwese Kristu durudemy idi dexiixixanyde rubu‑ribi. Kia iny rityhynyra Jesuisi inatyhymy Deuxu deòdỹỹna raré. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tahe ijohonadu mahãduõ rityhynyre. Tule ijõ judeukõdu mahãdu rityhynyre. Tule ijõ hãwyy wihikỹ mahãduõ rityhynyre sõwemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tahe judeu mahãdu dinodu tuu ròhãrumyhỹre. Tiiboho tahe hãbu binahakỹ mahãduõ wii rotyre aõbina ritelenykremy. Tahe ròirenyre Ijasõ heto‑ò Pauloboho rimyrenykremy, ywisidỹỹna‑ò idi retỹhikremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Tai tahe rahaõhyyre tai. Tahe Ijasõ ritarenyre ijõ ityhydỹỹduõ‑wana. Tahe ridyrenyre ywisidỹỹna‑ò. Tahe raryberenyre ywisedỹỹdu mahãdu‑ò: —Paulo, Silamy urile bede diòtanymyhỹdenyde, aõna aõna binahakỹlemy rotỹỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ijasõ tahe ritirỹmyhỹre taheto‑ki. Tiiboho iny òludu roire. Iny iòlòreny rityhynyõtyhy. Jesuisi ka iòlòrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","9","Ibutumy iny idi rõhõtinyre, tule ywisidỹỹna mahãdu rexitòenyre nieru ririkemy. Tai xiery tahe ròhònyke. Tai tahe ririrenyre nieruõ. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kiaru tahe ityhydỹỹduõ Pauloboho riwiòhenanymy iribi riòlònykemy Bereia hãwã‑ò. Tahe rehemyhỹreu, dohodỹỹna‑ò ròirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Kia hãwã‑ki judeu mahãdu iny awi rare, Tesalonia hãwã mahãdu wese aõkõre. Teysamy tamy roholarenyra. Idi heka rariara Tyyriti‑di, òbitimy Paulo rybe aõbo roirerimy rierykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tahe sõwemy judeu iny rityhynyre. Judeukõdu mahãduy‑ribi sõwemy rityhynyrenyre, hãwyy wihikỹ, hãbu‑wana tule rityhynyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Bereia hãwã‑ki Paulo Deuxu rybe ritỹnynymy raremy. Judeia mahãdu dinodu Tesalonia hãwã‑ki roholareu, tahe doidenyde. Iny sõwe‑ò raryberenyre: —Pauloboho bibinadỹỹnyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tahe ityhydỹỹdu seriòre mahãdu aõwesele Paulo riteònyrenyre ahohokỹry‑di. Sila, Tximòtxi taile rarire. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Hãbuõ rare Paulo‑wana Atena hãwã‑ò. Iribi tahe dòòsede hãbuõ. Paulo tamy tarybe riwahinyra Tximòtxi Sila‑ò, wylemy kanakremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo Atena hãwã‑ki riraòreu, tahe robire suritxoole rityhynymyhỹreò. Tai tahe tii rabedewore. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Idi tahe Paulo ralore dohodỹỹna mahãdu heto‑ò judeu dee rarybekemy, tule judeukõdu ityhydỹỹdu dee rarybekemy. Tahe rarybemyhỹre txuõ txuõlemy. Tule hãwã ube‑ki rarybemyhỹre hãwã‑di reamyhỹre mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Aõutxumy tahe Epikuriu mahãdu Paulo‑txi nade. Estòiku mahãdu ijõre. Tiiboho, aõbo rybe rare kia erydu roire. Tiiboho he Paulo raujõmorenyre: —Aõmy aõkõ, kiarybedu rarybereri. Ijõ tahe rarybere: —Tii Deuxu tỹmyramy rarybereri. Paulo dori juhuu Jesuisi ixixanamy relyymy raremyhỹ. Tai kiamy raryberenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Paulo tahe ridyrenyre. Tai iny roholamy rỹimyhỹreò ridyrenyre: —Rybe tỹmyramy telyymahãtemy inihe bedelyyke wakoreny. Tamy kia rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Aõkõre inihe aõna aõnamy tarybemy atxiteri, aõwitxira witxiramy. Tai aroholarenykemy watxirenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atena hãwã mahãdu, tule iwitxira bede luduõ tai rasỹnymyhỹre, aõ tỹmyraõòle roholarenykemy ratxirenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tahe Paulo rỹire rybenatya‑ki. Rexiòrarunymy rarybere: —Atena hãwã mahãdu, kaiboho Deuxu rybe hyky tahõtinymahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Jiarỹ hãwãymy rariamy watxireriu, sõwemy xiwena‑di retehera. Ijõ‑di kiamy retehera iritina‑di: Kaa Deuxu heka inyõ rieryõhyymyhỹre. Ka Deuxumy kỹny heka akoreny arelyykre, teerymahãtenyte‑di aõkõ tuu teàlàmahãtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ka Deuxu ibutumy bede riwinyre. Ibutumy tuu rỹira tii riwinyre. Tii heka biuwetyy wedu rare, su wedu rare. Aõ hãbu widỹỹna heto‑ki aõkõ tii rasỹnymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tiu heka tii aõmy reaõtyhy hãbu aõ tamy riwahinyõtyhy. Tule tahe inydee ibutumy aõna aõna riwahinymyhỹre, ele wesena, umy, ibutumy inydee riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Hãbu sohojiõ‑ribi ibutumy iny ròhònyre iriòre riòremy bede witxira witxiramy rasỹnymy rỹirakemy. Urile wiribi rihitxihitxinyre. Tiu tamy riteòsinyre, tikibo rasỹnymy rỹirakremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ibutumy Deuxu raijemyhỹkemy, raerykemy. Tii dori irehemy aõkõ ihỹre iny‑ribi. Iny sohoji sohojiõ‑ribi iòhòmy ratximyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Deuxu òraru‑ki inyboho ibutumy irumy ratximyhỹrenyre, ririranymyhỹre, ihoõkeki tahe aõ rikiwinyrenyõtyhy. Atyyriti widỹỹduõ kiamy rarybere: —Inyboho heka Deuxu riòre. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Inyboho Deuxu riòre rareki, urile nohõtiõmy womati tỹrỹrỹỹ ritxoo wesemy, womatiura wesemy, manaritxoo wesemy Deuxu‑di nohõtiõmahãbeny. Hãbu rayky‑ribi, hãbu debò Deuxu releremy nohõtiõmahãbeny. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ihetxiu tii Deuxu rieryõhyyrenyre. Tai tahe iòrarunareny aõnihikỹmy aõkõ Deuxu dee ihỹre. Wiji bededỹỹnana tahe, ibutumy taòraru‑txi ixi‑txi nohõti ijaranamy, tai tahe rabedewomyhỹkemy. Kia tahe ibutu iny‑ò rarybereri, iny taòraru ririkemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Deuxu Jesuisi riixixanyre rubu‑ribi. Tai tahe ibutumy tii rityhynyrenykemy ihỹre. Aõtxumy tahe ibutumy iny ywisidỹỹdumy kanakremy ijỹre. Òbitina‑di Jesuisi iny ritxuarenykre kia wiribi hitxi hitxina txuu. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Paulo Jesuisi ixixanamy rarybereu, inyõ tuu rirajuare. Ijõ tahe rarybere Paulo‑ò: —Ijõ txuu arybe ini aroholatyhykemy watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Idi tahe Paulo rare iribireny. ");
INSERT INTO kpjNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ijõ iny tahe Jesuisi rityhynyre, Paulo‑ò tahe rixibutunyre. Ijõ Dionisiu inire, Areòpolo heto ube‑ki tii iny mahãduõ roholamyhỹre. Ijõ, hãwyyõ rityhynyre, Damari inire, tule ijõ mahãduõ rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Paulo tahe Atena hãwã‑ribi ròhònyre Oritxi hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kia‑ki tahe judeu mahãduõ‑wana witxi reare. Ini heka Akila inire. Tii Ponto hãwã‑ki raumynyre. Urihimyòle Italia bede‑ribi dehemynyde. Prisila ihãwyynire. Iòlò Laujiu Roma hãwã‑ribi ibutumy judeu mahãdu diteònyde. Tai heka nade kaweribi‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulo iaõmysỹdỹỹna rierymyhỹre, tyyheto widỹỹ. Tai tahe tiiboho‑wana raijoinymyhỹre wiwana raaõmysỹdỹỹrenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabado txuõ txuõlemy tamy reamyhỹre judeu mahãdu dohodỹỹna heto‑ò. Tahe ritohonymyhỹre, judeu mahãdu judeukõdu mahãdu tule. Tamy rarybere tii Rybewihikỹ òbitimy rierykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila tahe Macedonia bedewe‑ribi rehemynyre, Tximòtxi‑wana. Paulo tai rybe ritỹnynymyhỹhyy raremyhỹ. Aõu Paulo rarybere: —Inatyhymy Jesuisi Deuxu deòdỹỹna rare, Kristu rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Katahe judeu mahãdu tamy raykarananymy raremyhỹ. Aõbinahakỹlemy Jesuisimy rarybere. Tahe Paulo tatyy riohowire iixãwidinykemy riteòsinykemy. Tahe tamyreny rarybere: —Jiarỹ aõkõ bede òrarure. Kai aòraruna‑di burukre‑wana, ahãlubureny waki aõkõ rare, adeereny dori Deuxu rybemy rarybere. Tahe judeukõdu mahãdu‑ò sohojile tuu arelyykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Iribi tahe inyõ heto‑ò Paulo rare. Txisiu Justu inire. Tii judeukõdu mahãduõ rare, tahe Deuxu rityhynymyhỹre. Judeu dohodỹỹna heto bire‑ki iheto rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispu judeu dohodỹỹna heto weduni rare. Tii tasỹreny ibutumy Inynyrỹ rityhynymyhỹre. Tule sõwemy Oritxi hãwã mahãdu rityhynymyhỹre. Paulo riratysebedỹỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Paulo tahe rumy rõrõmy roire. Tai tahe rasina wesemy robire. Inynyrỹ tamy narybede: —Brebuõmy, Paulo. Marybeke aõmybo rybemy adee rewahinyré. Rybe tỹnydỹỹ lau brebuõmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Jiarỹ adi watxiwãhãre urenana. Inyõ adee aõhe rotỹỹnyõtyhy. Sõwemy iny rỹire kaki watyhydỹỹdu. Kia Jesuisi tamy rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Tai he Paulo bede riijere sohoji beòra weeremy tai bede riere. Ribedeerynymyhỹre Deuxu rybemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Roma dinodu tỹmyraõ ronyre Grecia bede‑ki. Ini heka Kalio inire. Dinodumy ronyrau tahe, judeu mahãdu wii dotyde. Wii ritobinyre Paulo dee aõbinabinahãkỹ riwinykremy. Tahe tiiboho Paulo rimyrenyre idi kanakremy ywisidỹỹdu dinodu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Kiamy raryberenyre: —Paulo, Deuxu deàlànamy iny dibedeerynymyhỹde. Tai bede ywina rityhynyõhyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Tahe Paulo ixideele rarybekemy ratxireri, tahe Kalio judeu mahãdu‑ò rarybere: —Kia rubudỹỹdu ada aõ ibinatyhymy ratxikeki, tai idi arohonykre, ariywisidỹỹnanyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Tahe aõkõre, urile abede ywina rybedile rarybemyhỹre, tai ywisidỹỹnamy idi araõkre. Kaibohole biywisidỹỹnanybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Tahe Kalio ibutumy diteònyde ywisidỹỹna hetoube‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tai tahe judeu mahãdu dohodỹỹna heto wedu rimyrenyre. Sòteni inire. Tule raòhòterenyre ywisidỹỹna heto ube‑ki. Kalio tahe kia òhòtena‑ò aõhe rotỹỹnyõhyylere. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Oritxi hãwã‑ki Paulo rare myhỹre sõwemy he tai txu riwyre. Idi tahe seriòre mahãdu‑ò rarybere: —Arakre. Tahe hãwòõ‑di he rare, reuròkemy Siria bede‑ò. Tahe Prisila Akila‑wana tii‑wana ròirenyre. Paulo Deuxu‑ò rarybere aõmybo rotỹỹnykremy. Idi tahe rexihumy kia rỹire. Tai tahe tarade risyre nohõti ijerana wesemy. Sekrea hãwã‑ki tarade risyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tahe ritehemynyre Efesu bede‑ò. Prisila Akila‑wana ririre. Iribi tahe rare tyyriti ritỹnynyremy judeu mahãdu dohodỹỹna heto‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Tii mahãdu tahe Paulo rexitòenyre tai aõutxumy tai ratxunykemy. Tahe rarikõkemy ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Karibi ròhònyreu, tamy rarybere: —Deuxudeewikeki, ixyby adòòsekre. Efesu‑ribi ròhònyreu, yhydynalawòõ rimyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ritehemynyre Cesaria bede‑ò. Iribi resereu, Jerusalẽ hãwã‑ò rare. Tahe rarybere riwehityhynanyre dohodỹỹna mahãdu. Iribi tahe Atxiòkia hãwã‑ò rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tai bededỹỹnana riijere idi tahe rara. Rariamy rare hãwã hãwã‑di, Alatxia bede‑di, Frigia bede‑di. Ibutu hãwã‑ki ityhydỹỹdu rotohodỹỹnymyhỹre, riwiòhenanymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Iu tahe inyõ judeu mahãduõ dehemynyde Alexỹdria hãwã‑ribi. Apòlo inire. Tii ribedeeryny wihikỹmyhỹre tyyriti, tarybe‑di rotohonymyhỹre, Deuxu rybe rieryreki. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Inyõ Apòlo rierynanyre timybo Inynyrỹ Jesuisi aõmydỹỹnana raremy. Tai Jesuisimy ribedeerynymy raremyhỹ, deysanatyhy‑di rarybemyhỹre. Tii tahe Joaõ ratysebenale rieryre. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apòlo rexidelenymy relyyre judeu mahãdu dohodỹỹna heto‑ki. Prisila Akila‑wana tai roholamy ronymyhỹre. Idi tahe tiiboho Apòlo ridyrenyre ibutumy Jesuisi aõmydỹỹnanamy tamy ritỹnykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Iribi tahe Apòlo ratỹinykemy rexiwonyre Grecia bedey‑ki. Ityhydỹỹdu seriòre tamy rybe riwahinyre, Grecia ludu seriòre mahãdu‑ò, aõma, riryludunykemy, rehemynykeu. Tahe rehemynyreu, sõwemy riwiòhenanyre kia tyhydỹỹdu seriòre, Deuxu ruxetòena ityhydỹỹdu mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tii dori judeu mahãdu raykyrybe itxỹte riwitxiradỹỹnyre iny sõwe hekỹy‑ki. Rybetyyriti ritina‑di riurihimy rarybere iwese Kristu Jesuisi raremyhỹ wese, Deuxu deòdỹỹna wahe. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apòlo, Oritxi hãwã‑ki rareu, Paulo rabedetỹinyre kabedey‑ki idi rehemynyre Efesu hãwã‑ò. Kowa ityhydỹỹdu mahãduõ‑ki he rahare. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Tamy Paulo ritỹỹraxinyre: —Tetyhynyteu, Deuxu Tyytybytyhy ixidee aõbo temytenyte. Tahe rirawyònyre: —Aõkõre he, aõmybo tarybeteri. Deuxu Tyytybytyhy reeryõrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulo rỹỹraxire: —Taratysebetenyteu, mobohe tetyhynytenyte. Tahe rirawyònyrenyre ixityre: —Retyhynyrenyre ibutumy Joaõ Sebedỹỹdu riwabedeerynyremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo tahe tamyreny ritỹnynyre: —Joaõ sebedỹỹna urihimyõ iwitxi rare. Tii kiawese rybe ritỹnynyre: iny taòraru‑txi tõhõti reakemy. Tahe Jesuisi Juaõ hewo‑ribi kanakreu, tii tahe inatyhymy kanatyhydỹỹkre. Paulo kia tamyreny rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kia‑ò roholareu tahe, raratysebenyre Inynyrỹ Jesuisi nimy. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulo iratytyre tebò ritidire, tai Deuxu Tyytybytyhy tamyreny ralore. Tahe Deuxu rybemy raryberenyre, tule iwitxira rybemy raryberenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Waòinatxi reurò hãbumy rỹiramy. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Inataõ ahãdumy Paulo reamy raremyhỹ judeu dohodỹỹna heto‑ò. Tiiemy rarybehyymyhỹre, riòbitinymyhỹre, Deuxu Iòlònamy ritỹnynymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Paulo‑ò ijohonaduõ rityhynyõhyymyhỹre, teramy reamyhỹre. Deuxu aõmydỹỹnanamy ibinamy rarybemyhỹrenyre iny sõwey‑ki. Tai tahe Paulo rexihitxinyre judeu dohodỹỹna heto‑ribi. Txirano kia tyyriti rybena heto‑ò txuõ txuõlemy ralòmyhỹre taerydỹỹna‑wana. Tahe rabedeerynymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Tahe bede riere inatxi beòramy. Tai tahe ibutumy iny Asia bede ludu mahãdu Inynyrỹ rybe‑ò roholamyhỹre, judeu mahãdu, tule judeukõdu mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Deuxu aõna aõna wiwihikỹ riwinyre Paulo debò rihuòtere. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Paulo tykyyre riwyrenyre webinadutyre ritidirenykremy. Tyky òsuròna wesemy ijõmy riwyre. Tai tahe webinadu riteytenymyhỹre. Tule tyytybybinahakỹ iny‑ki raremyhỹu, aõwesele iribireny ròhònymy reare tykyyre òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ijõ judeu mahãduõ ratỹinyre hãwã hãwã‑di inyõ ribi tyytybybina ritakemy. Tiiboho tyytybybina riteònykemy idi ratxireri. Tai tahe Inynyrỹ Jesuisini‑di riteònyre. Kia wesemy rarybere: —Paulo, Jesuisi rybe ritỹnynymyhỹre, tai Jesuisini òraru‑ki iribi bòhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Debòinatxi seriòre kia riwinyre. Sewa tybynire, judeu xiwena widỹỹdu kia wedu tii rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Tahe Jesuisi ni‑di tyytybybina‑ò rarybereu, tyytybybinaõ dirawyònyde: —Jesuisi reeryre, Paulo reeryre, tahe mobo atxiteri. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tahe hãbu tyytybybina‑di ratxirerí, ityrehekỹle dexiwatxinyde, rihetenyre, ibutumy riwotõmonyre ityky ritare tai hetowo‑ribi hãbu mahãdu tadehekỹlemy rahenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ibutumy Efesu hãwã mahãdu kia rieryrenyre, judeu mahãdu, judeukõdu mahãdu. Tahe ibutumy ruberure, Jesuisi ni nityhydỹỹhỹkỹmy ini raremyhỹki. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Sõwemy ityhydỹỹdu taòrarureny riixitòedỹỹnymyhỹre, dohodỹỹna mahãduy‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ijõ ityhydỹỹdu juhuu tyytybybina rierymyhỹrenyre, tiiboho tahe tatyyriti diwyde itxenadỹỹmy rybetyyriti, òwòruwidỹỹ kia tyyriti. Tahe iny retehemyhỹreruki kia tyyriti sõwemy ritoonyre. Idi ibutu tyyriti juhuu òwy wese inyõ riritinyre. Iòwy tahe 50 mil womati ura nieru juhuu iòwyre. Ihãrele tahe idi rahure. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ibutumy kia bede mahãdu Deuxu rybe‑di rõhõtinihikỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Idi tahe Paulo tarayky‑ki rõhõtinyre: —Judeukõdu mahãdu bede‑ò arakremy ixi‑di watxiwãhãre. Juhuu Jerusalẽ‑ò arakre Macedonia bede‑di Akaia bede‑di arariamy arakre. Adòòsekreu, tahe Roma hãwã‑ò arakre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tai tahe tawiòhedỹỹdu Tximòtxi, Erasto‑wana Macedonia bede‑ò riteònyre. Tai Paulo Asia bede‑ki naride. Bededỹỹnanaõ riwyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kia bededỹỹnanau aõbina nihikỹ rỹikemy riwisỹnyre Deuxury òbitina òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Dimitiu heka womati tỹrỹrỹ ura ritxoo widỹỹdu rare. Hãwyy ritxoo ihãwãreny deuxu rare. Diana inire. Nieru sõwemy ritamy raremy idi riwinymyhỹreki. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dimitiu ributunyre ibutumy womati ritxoo widỹỹdu, tamahãdu‑wana. Tamyreny rarybere: —Wanyrỹboho adeereny ararybekre. Inyboho nieru ritamyhỹrenyre kaa aõmysỹdỹỹ‑ki. Kia tahe teerytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Paulo rarybemyhỹre kaa inywidỹỹnareny deuxu aõkõ rare. Tai tahe sõwemy iny tamy nariade irybe‑di. Efesu hãwã sohojile‑ki aõkõ, ibutumy Asia bede‑ki irybe rityhynymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Iny aõmysỹdỹỹna òsana riixãwididỹỹnykre, ideuxu dohodỹỹna heto‑wana, iny deuxu reny riixãwididỹỹnykre. Diana inyluure. Kaki sohojile aõkõ inyluure, ibutumy Asia bede‑ki, tule bede bede ludu iluu inihikỹmy awireki. Paulo heka kia ibutumy rahukre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kia roholareu tahe, raykarananyrenyre. Ryryrenyre: —Diana awi rare inydeereny. Tii Efesu hãwã deuxu rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Rirajuamy rỹimyhỹ hãwã‑ki. Hãwã mahãdu, Kaio Aristarku‑wana rimyrenyre tahe ridyrenyre butunaube‑ò. Tiiboho Paulo tỹimahãdu rare, Macedonia hãwã mahãdu rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Tahe Paulo ralòkemy rexiwonyre tatỹi mahãduhe‑ki, iny sõwey‑ki tahe taerydỹỹna ijoi ritirỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Tule ijõ bededinoduõ, Paulo wiòhedỹỹmy ratxireri. Tai tarybereny Paulo‑ò riwahinyre ibutunaube‑ò raõkemy, brebunamy roireriki. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tiilemy ijõ rarybemyhỹre. Ijõ iwitxiramy rirajuamyhỹre. Urile wimy rauriurire. Aõherekibo ibutumy rỹirerí, iny rieryõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Alexỹdre iny sõwey‑ribi rimyrenyre tahe, idi retỹhire, ritamadỹỹnyre iny rudera‑ò. Alexỹdre debò riteòsinyre tamahãdumy rarybekemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Iny sõwemy idi retehereu, judeu mahãduõ raremy rieryreu tahe rirajuatyhyre. Tahe inatxi òramy rirajuahyy rỹimyhỹ: —Diana awi rare. Tii heka Efesu deuxu rare. Kiamy ryryrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Idi tahe hãwã weduõ riixãwididỹỹnyre. Tahe rarybere: —Hãbu, Efesu hãwã mahãdu. Ka hãwã Diana hãwã rare. Kaki tohodỹỹna heto reyrubuwãhãrenyre. Kaki biu‑ribi mana ritxoo desede. Ibutumy kia reeryrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kia inatyhy rare. Tai tahe rikiyrymy rokorokorenykre. Aõwesele aõwidỹỹõmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kaa hãbu tedytenyteri. Aõhe rotỹỹnyõreri. Aõ‑di rawasinyõhyyreri dohodỹỹna heto‑ribi. Aõbinahakỹ iny hãwyy deuxumy raryberenyõhyyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Dimitiu tamahãdu‑wana aõbo tai reny ibinamy ihỹrenykeki, ywisidỹỹdu‑ò idi rakre. Tiiboho heka wii ributunymy rỹireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ijõ rybe tahe atxibenykeki, ijohonadu mahãdu adibutunykre arybe‑ò aroholarenykemy. Iwese inyboho rotỹỹnymyhỹre wese arieryrenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Roma hãwã dinodu òsana aõmybo inymyreny kanarybekre. Wiji inyboho aõhebo rotỹỹnyrenyrerimy. Aõ kỹnyhe iò‑ki ka wiji jei jei rỹireri wahe. Roma hãwã dinodu tarybe kidiwahinykre‑wana wahe, timyhe warybeõna. ");
INSERT INTO kpjNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Tahe riixãwididỹỹnyre. Ròòsere ibutumy. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kia jei jei rybe rexihureu, Paulo tahe taerydỹỹna mahãdu‑ò tarybe riteònyre tiiboho kanakemy. Tahe rakrekou tyremy tamyreny Deuxu rybe‑di rotohonyrenyre Deuxudeewimy rierykemy. Idi tahe ritobinyrenyre. Rare heka Macedonia bede‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ibutumy titxibo rexitomonymyhỹ ritohodỹỹnymyhỹre ityhydỹỹdu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tahe Akaia bede‑ki heka bede riijere inataõ ahãdu. Tahe rexiywinymyhỹre ratximyhỹ Siria bede‑ò rakremy hãwò‑di ridymyhỹredi heka rakremy rexiywinyre. Idi tahe judeu mahãduõ irubudỹỹmy rarybemy nyimyhỹ. Inyõ Paulo rierydỹỹmy, tai ta Macedonia bede‑di ròòsere Siria bede‑ò rakemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Hãbuõ ramyhỹre tii‑wana Jerusalẽ‑ò, ta kamahãdu Asia bedeòle he roirenyre. Sopatu ijõnire, tii heka Bereia hãwã mahãdu rare, Biru heka Sopatu tybyni rare. Aristarku ijõre, adelahelỹỹna ijõni rare, tiiboho Tesalonia hãwã mahãdu rare. Ijõ Kaio inire, tii Debi hãwã mahãdu rare, Tximòtxi ijõ rare. Tule ijõ Asia bede ludu rare, Txitxiò ijõ, Trofimo ijõre. Rarekie. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kiaboho juhutyhy rexiraòmy roirenyre. Paulo riraòmy Troaji hãwã‑ki. Tule riwaraokre —Luka jiarỹ ka tyyriti widỹỹdure. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Worana bedehesi ituereu tahe, jiarỹ Paulo‑wana roirenyre heka hãwò‑di Filiposi hãwã‑ribi. Iruyre txu rỹidi tahe rehemynyre. Troaji hãwã‑ò. Taita sohoji semanamy rewyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Tahe nobiutxu ityhydỹỹdu mahãdu iny wi ributunyre, Inynyrỹ mona, rỹsỹna‑wana tuu rihitxinymy rirỹsỹkemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Tahe Paulo iu rybe ritỹnynyre itxu biòwamy rexiywinymy rỹimyhỹ tahe rakremy. Urile tahe rarybereri hyky tahe ruetya he wihe ritotynymyhỹrenyre. Hetoranoa‑ki biu‑ki rỹimyhỹre. Kanoõtyhy‑ki rabuturenyre. Tiu Paulo rarybemy rarybemy rexihukõhyyre, biurasòmy rakreki. Tahe sõwemy heka lamparina rỹimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ronymyhỹ, moma inire, Otxiu. Aõma‑ki ronymyhỹ, heto janela tyre‑ki biu‑ki. Ta tõhõti rosare, rõrõmy resere. Iribi reare, biuribihikỹle resere suò. Rurure. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Tahe Paulo robehemy rare tamy. Tatiowotimy resere weryrybò rimykremy iwetya‑ki. Paulo rarybere: —Bedeòtiidỹỹõmyke irulemy roire. Deuxu ixyby iumy tamy riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","12","Weryrybòmy irumy robirenyreu tahe, ibutumy reysarenyre. Tai tahe Inynyrỹ bemona, rỹsỹna‑wana tuu rirỹsỹrenyre biu‑ki wahe. Paulo ixityre rarybere. Txu iòlò iòlòmy rareri‑wana tahe rarybere. Tahe Paulo rare. Tatilemy rare Aso hãwã‑ò. Tii tamy tarybe ririrehe: —Kowa ayhywydyna lawò arimykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tahe jiarỹ, Luka, wamahãdu‑wana roirenyre yhywydynalawò‑di Aso hãwã‑ò Paulo‑wana rekoarenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Rehemynyrenyreu tahe, Paulo ralòmy yhywydyna laworo‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Imytxubiòwa tahe Kio hãwãko‑txi rehemynyre. ijõ txu tahe Samosi hãwã‑ki rehemynyre. Ijõ tahe rehemynyre Mitilene‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo ixitamadỹỹ deramy reare Efesu hãwã‑ò. Raeleelemy ratximyhỹ Jerusalẽ‑ò rehemynykemy, aõma, Pentecoste kia judeu worana bedehesi‑ò raeleelere. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Tahe Miletu hãwã‑ki rehemynyreu, dohodỹỹna matuari mahãdu tamy he rarariòwyre tamy rarybekremy hãwò‑ò kedehemynykemy. Tahe Efesu‑ribi ditehemynydeu, kia tamy rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","19","—Tahe tiiemy Asia bede‑ki Inynyrỹ‑ò raaõmysỹdỹỹhyy watxiwãhãre. Aõmy aõkõ ixidee rahõtinywãhãre. Rahinymahãre, Inynyrỹ dee rybe retỹnynymahãre. Warube resehyy watxiwãhãre. Tai ta brebuna nihĩkỹ waumy‑di rarewãhã. Judeu mahãdu heka sõwemy wamy rarybemy riwarubunykemy. Kia ibutumy aõmydỹỹnana teerytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tiu raberuõhyywãhãre Inynyrỹ nimy rybemy. Ibutumy rarybewãhãre iny sõwey‑ki tule heto hetowomy relyymahãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Judeu mahãdu‑ò retỹnynyre tule judeukõdu mahãdu‑ò taòraru ririkemy Deuxu dee taòraru‑txi tõhõti reakemy rabedewokemy. Tule Jesuisi Kristu rityhynykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","23","Katahe wiji arakre karibi Jerusalẽ hãwã‑ò. Deuxu Tyytybytyhy heka wadee dyrymyhỹde. Aõhebo arotỹỹnykre, reerykõre. Kiale reerywãhãre, aõma, Deuxu Tyytybytyhy wadee rarybemyhỹre ibutu hãwã‑ki, aõma, aõhõkỹmy arotỹỹnykre kowa. Rotenawo‑ki aroikre. Myle reeryre. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Tiiemy tamy raaõmysỹdỹỹmahãre. Kiale wadee Inynyrỹ Jesuisi rewahinyre urenana. Kia ariwinyõkeki, aõ aõkõ heka jiarỹ waumy‑ki. Tii arelyywãhãke inyko‑ò rybe tỹmyra wihikỹ, timybo Deuxu inyluurenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Araerynanywỹhỹrenyre Deuxu Iòlònamy, wamy tahe bobibenyõtyhy ixityre. Kia reerywãhãre. Jiarỹ tule umyreny arobiõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Tahe adeereny aõmybo ararybekre. Ryranymy heka watxiwãhãre ibutu hãlubu‑ribi. Kaiboho aòraru‑di burubenykeki, jiarỹ aõkõ tuure. Inyõ wamy rarybeõtyhy aõma Rybewihikỹ‑di jiarỹ itỹnynyõmahãremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tiiemy rarybehyy rarewãhã ibutumy Deuxu bede ywinamy. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Tai tahe ixi‑di awimy boibekre. Iwese budoeni itxeredu tamy rỹsỹna riwahinyre wese, kaiboho ityhydỹỹdu mahãdu‑ò Deuxu rybe tamyreny biwahinybenykre. Deuxu dohodỹỹna mahãdu tii rare. Jesuisi tahãlubu‑di tii riwyre. Tai tahe ityhydỹỹdu mahãdu wiòhedỹỹdumy kaiboho toite. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Karibi arohonykreu, aitxeredu mahãdu kanakre. K reeryre. Adeereny òbitimy aõkõ rierynanykre. Tiiboho ahola wesemy ratximyhỹrenyre. Iwese budoeni‑ò imynymy ròsemy ramyhỹre wese heka kedehemynykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Inyõ heka aityhydỹỹdu seriòre yribi iwitxira aõna aõnamy kidierynanymyhỹkre. Taijoi kididymyhỹkre tarybe‑ò ijohonamy. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Tahe biijemy boibekre. Inataõ beòramy awana rarewãhã. Kiamy rarybereri, iribi nohõtilosarenyõmy. Txu‑wana, ruwana adireny ròrenywãhãre. Rahinymy heka aòrarureny‑ki watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Tahe ararirenykre Deuxu‑wana ixi‑di he awimy renykre. Tii heka adireny rarekre. Tii tahe nohõtilosarenyõmy, boibekre Deuxu rybe‑di. Tii heka riwiòhenanykre atyhyna raumynykremy. Deuxu riywinyre wahe adee reny aõna aõna wiwihikỹ riwahinykre òbiti mahãdu‑wana kia bitabenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Tiu heka jiarỹ ijò hãbu‑ribi nieru tarasamy rahõtinyõhyymahãre tyy wiwihikỹ tarasamy raruõhyymahãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Tiiemy wadebò‑ribi hyy hyy raaõmysỹdỹỹmy rarewãhã waaõmydỹỹnana òwydỹỹmy. Tule rewiòhenanywãhãre tii‑wana watxiwãhãre mahãdu. Kaiboho teerytenyte kia. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ibutumy rewiòhenanywãhãre iaõkõ mahãdu kia heka tuu tabitenyte kia rewinymahãremy. Teerytenyte timybo Jesuisi rarybere: —Biwahinybenyke, kia dori iny‑ribi ritamyhỹre ratyre awi rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Tahe rybe‑ribi rexihureu, tatiowotimy rotamanyrenyre wiwana rexitòenyrenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Tahe rahinyrenyre, rimyrenyre tamy wòrenyre, aõna rakreki, kia‑ki rexityhenyreri tamyreny. ");
INSERT INTO kpjNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Tiiemy rabedeworenyre tiu tuu robirenyõkremy. Tahe hãworo‑ò tiiboho‑wana roirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Iribi ròhònyreu tahe, òbitihyy rare Kòsi hãwã‑ò. Ijõ txu tahe Rodesi hãwã‑ò ritehemynyre. Iribi tahe Patara hãwã‑ò ritehemynyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tai tahe rahare hãwòõ‑ki, Senisia hãwã‑ò rakremy rexiywinyreri. Roirenyre kia yhywydynalawò‑di tahe rorukurenymy ròirenyre tamy. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Xibri bedebute weribi‑ò reurore, inyhywenawe‑ribi Siria bede weribi‑ò. Tahe ritehemynyre Tiro hãwã‑ki. Tai tahe hãwò‑ribi aõna aõna‑di rekoarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tamy roirenyreu tahe, rỹỹraxirenyre kahãwã ityhydỹỹdu mahãdumy. Tai raharenyre. Sohoji semanamy bede tiiboho‑wana wadireny rỹire. Kiaerydỹỹna mahãdu heka Paulo dee raryberenyre: —Aõma noõmykre Jerusalẽ‑ò. Deuxu Tyytybytyhy tuu tamyreny rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Tahe semana ituereu, diòòsedenyde ixyby hãworo‑ò. Ibutumy diberenydenyde ityhydỹỹdu mahãdu tiiboho‑wana ỹnyra‑ò, hãwyy, uladu, ibutumy. Tahe rexitòenyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ritobinyrenyre tahe, riòòserenyre heto‑ò ixyby. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Idi tahe Tiro hãwã‑ribi rare. Tahe Tolimaida hãwã‑ki ityhydỹỹdu mahãdu rerybewãhãrenyre txu sohojilemy bede reijerenyre tai. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ijõ txu biòwamy tahe roirenyre Cesaria hãwã‑ò. Tahe Filipisỹ‑ki rasỹnyreny Rybewihikỹ‑di tỹnydỹỹdusỹ‑ki wahe. Tii juhuu aõma ityhydỹỹdu mahãdu wiòhedỹỹduõ juhutyhy rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tii heka inaubiòwa iriòre rare. Tahe heridu aõkõ ijadòma mahãdu rare. Ijadòma mahãdu heka Rybewihikỹmy rybeduõle rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tahe aõutxu taile watxiwãhãrenyre. Tahe hãbuõ dehemynyde Judeia bede‑ribi, moma inire Abusi. Tii tule Deuxu rybe‑di rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Idi tahe nade inyrorarenymy. Tahe rimyre tii Paulo wereysana. Tawahe idile rimyre rexitaare tebò‑wana. Idi tahe rarybere: —Deuxu Tyytybytyhy wa kiamy rarybere: —Kia wereysana wedu heka iwese rataataamy rãire wesele heka tule rataataamy rỹikre Jerusalẽ‑ki judeu mahãdu heka kia riwinykre ta riwahinykre judeukõdu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tamy raholarenyreu tahe, raryberenyre Paulo dee raõkremy Jerusalẽ‑ò. Jiarỹboho raryberenyre tamy tule ijõ tule tamy raryberenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Tahe Paulo rarybere: —Hirenyõmyke, tiwabedewodỹỹnytenyteri. Rexiywinymy watxireri Jerusalẽ ròtena‑ò aralòkemy. Tamy sohojile aõkõ kỹny, tule Deuxu dee wikeki tahe arurukre Inynyrỹni òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Timy heka Paulo nohõti rareadỹỹrenyõke tiiemy tanonanamy rara. Tahe rarybemy rahudi kiamy tarybe‑ò resere Deuxudeewilemy rotỹỹnymy ratxike. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","16","Iribi tahe iny aõna aõna rexiywinymy Jerusalẽ‑ò roirenykemy. Ijõ ityhydỹỹduõ Cesaria‑ribi iny‑wana roirenyre. Tahe retehemynyrenyreu, Menasõ heto‑ki rasỹnyrenykemy ityhydỹỹdu riwadyrenyre. Menasõ heka juhutyhy ityhydỹỹdumy ralòmy raremyhỹ. Juhuu tii Xibri bedebute‑ki rasỹnymy raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","18","Jerusalẽ ityhydỹỹdu mahãdu ibutumy awimy riwamyrenyre. Jiarỹ, Luka wahe, Paulo‑wana, ijõ ityhydỹỹdu‑wana. Ijõ txu biòwamy tahe Paulo riwadyrenyre Txiaumy robikremy. Tule ijõ Jerusalẽ dohodỹỹna matuari mahãduõ tai ronyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Wirirybenymy rahudi tahe, Paulo tamy relyyre aõhebo Deuxu tamy rotỹỹnyremy. Timybo judeukõdu mahãdu Deuxu rityhynyremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kiamy roholareu, Deuxumy reàlàrenyre ibrò‑kí. Tai tahe inyõ rarybere: —Paulo, sõwemy judeu mahãdu rityhynyre. Kai teeryte, inyseriòre, ibutumy judeu mahãdu bede ywina riywinymy ratximyhỹhyy. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Inyõ umy rarybere, raroimyhỹre kaki Jerusalẽ‑ki. Judeu ityhydỹỹdu mahãdu‑ò rarybere: —Paulo he Moisesi bede ywina‑ribi nohõtirosakemy tii riteònyre. Paulo rierynanyreri judeu ityhydỹỹdu mahãdu‑ò kia judeukõduy‑ki rasỹnyre mahãdu‑ò. Kia inyõ riki rarybere, Paulo uladunotyky resyna riteòdỹỹõreki riki. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tii kỹnyhe roholarenykre kaò tehemynyterimy. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Tai kiamy rikiwinyrenykre. Inaubiòwa hãbu katxi rare tarade riwysynykremy. Deuxu‑ò tarybetyhy riwahinyrenyre, tai tahe tarade riwysynykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kai tule makre iwesele arade riwysynykre Deuxu dohodỹỹna heto‑ò. Tahe iradereny synaòwymy biòwynykre. Tai tahe ibutumy aluukre judeu mahãdu bede ywina tetyhynymahãteki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Aõ inyboho ka judeukõdu mahãdu. Ka bede ywinaõ rityhynykemy aõkõ tuu iny ratxirenyre. Kaa adeereny tuu rarybewãhãrele rityhynyrenykemy: —Ka aõma rỹsỹna ritxoo rỹsỹnamy iwahidỹỹnalemy irỹsỹõmy, tule iròdude ihãlubu iijeradỹỹõreri, uritere irỹsỹõmy, tule òta òta òraru widỹỹõmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tai tahe Paulo rarybere: —Hỹde, tii ariwinykre. Tahe Paulo rare Deuxu dohodỹỹna heto‑ò kia hãbuõ‑wana. Tahe ibutumy iny rieryre xiwenaõ riwinykre wahe, tamy dori raryberenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Tahe debòinatxi reurò txu‑di riwinykremy. Idi ka debòinatxi reurò txu rexihudi tahe iòhòmy. Tahe Asia bede ludu judeu mahãduõ tuu robira. Tiiboho iny‑ò rarybere Paulo rimykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Sõwemy iny tamy wi rotyre Paulo òludumy. Tiiboho kiamy rirajuarenyre: —Haeli mahãdu, wylemy bodoike. Biwawiòhenanybenyke. Ka hãbu ratxireri iny bede ywinareny òludumy ritỹnynymy rỹimyhỹre. Iny dee narybemyhỹde judeu mahãdu bede ywina rityhynyõkemy, tule iny Deuxu dohodỹỹna hetomy, judeukõdu kawo‑ò didyde tai tuu ribinadỹỹnyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Juhuu tahe ijõmy robire hãbuõmy hãwãhãkỹ‑ki Paulo‑wana ratxirerimy. Trofimo inire. Tii heka Efesu hãwã mahãduõ ityhydỹỹduõ rare, judeukõdu mahãdu aõkõ tii ihỹre. Tahe judeu mahãdu rõhõtinyre Paulo dohodỹỹnahetowo‑ò Trofimo ridyramy. Tahe Paulo ridyõlere. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tahe sõwemy iny rakyarananyre tamy, aõma kia hãwã hãkỹludu mahãdu. Sõwemy iny rarybemy rỹimyhỹ, rajeijeimy rỹimyhỹ. Paulo tahe retỹhirenyre dohodỹỹna hetowo‑ribi, ijòtòbòna riratòbònyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tahe rirubunykemy ritelenyre heka. Tahe soldado dinodu tyhy roholare aõma ibutumy Jerusalẽ hãwã‑ki jei jei‑di rỹireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Tai tahe soldado tawedu diteònyde kia tai jei jei mahãdu rỹireriò. Tahe soldado robirenyrau, riixãwidinyrenyre, Paulo òhòtedỹỹ‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kia soldado wedu tyhy Paulo mynymy riteònyre. Tahe ritaataarenyre womati reroti‑di. Tahe rexitòenyre kia inydee mobo he ratxireri. Aõhebo he tii rotỹỹnyrerimy. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ijõ heka iwitxiramy rarybemyhỹre, ijõ tiilemy rarybere. Tai tahe soldado dinodu bede rieryõhyyra timyrebomy, ibutumy iny rirajuareki. Tahe ridykemy riteònyre. Tahe soldado heto‑ò Paulo‑di roiremyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ryòwòna‑di rotuòrau tahe, hãwã mahãdu aõkõre he reburera. Soldado mahãdu Paulo taaxiò tyre ritidimy idi rara iny rimyheny. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Iny he rirajuamy rarybemyhỹre: —Bidybenyke, birubunybenyke wahe. Myhe soldado mahãdu hewomy rirahumyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Tahe rirònykremy roirau tahe, Paulo soldado dinodu‑ò rarybera: —Adee inihe wanyrỹ, ararybekemy watxireri. Tahe soldado dinodu ritỹỹraxinyre: —Kai aõbo kreku mahãdu rybe teeryte. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kai jiarỹ araeryre. Kai Egito mahãdu dinoduõ tate, ibutudỹỹdu wedu tate. Kai 4000 iny aõbina widỹỹdu tedyte bederahy‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Aõkõre, Paulo dirawyònyde, tii aõkõ watxire. Jiarỹ Roma hãwã mahãdu tyhyre jiarỹ rare. Wahãwã, Tarso hãwã rare, hãwã riòre aõkõ Silisia bede‑ki. Judeu mahãdu tule jiarỹ rare. Kaki iny mahãdu‑ò ararybekemy watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tahe soldado Paulo —ò rarybere: —Tahe marybeke. Tahe lamamy rỹire inydee rarybekemy. Paulo tebò riteòsinyre riijohonadỹỹnykemy. Tai ibutumy iny riyrymy rỹirenyre. Judeu mahãdu rybe‑di tamyreny rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Kawese Paulo tamyreny rarybere: —Waseriòre, waluuboho, wabededỹỹnanamy adee arelyykre. Wamy boholatyhyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Judeu mahãdu rybe‑ò roholareu tahe, riyrytyhymy rorukurenyre. Tii heka rarybere: —Jiarỹ judeu mahãdu jiarỹ rare. Raumynyre Tarso hãwã‑ki. Kia Silisia bede‑ki rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Kaki Jerusalẽ‑ki ratyyritinymy rarewãhã, Kamalie ninadu tyyritina‑ki. Ibutu Judeu mahãdu bede ywina bede reeryre Kamalie‑wana. Ibutumy Moisesi bede ywina‑di riwaerynanymyhỹre. Tii tahe reywinywãhãre, retyhynytyhywỹhỹre. Ibutumy Deuxu bede ywina ariywinykemy ixi‑di rahõtinywãhãre iwese wiji iwidỹỹmy tarutenyteri wesele wahe. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Jiarỹ ka ityhydỹỹdu mahãdu aõhõkỹmy rotỹỹnymyhỹremy reteòwãhãre ihyyle ijõ rubudỹỹmy reteònywãhãre. Hãbu hãwyy‑wana reròtenywãhãre ròtenawo‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Waaõmydỹỹnanamy bierybenykre‑wana, tamy marybeke dohodỹỹna wedu‑ò, matuari mahãdu‑ò. Dohodỹỹna wedu tyyriti rewyre Damasu hãwã dohodỹỹna heto‑ò. Tai tahe tyyriti‑di risỹnyre ibutumy ityhydỹỹdu mahãdu aõhõkỹmy rotỹỹnykemy, tule womati reroti‑di rataataakemy Jerusalẽ‑ò kididykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","7","Iòhòmy txutyemy iijira‑ò, Damasu hãwãry‑ki watxiwãhã. Tahe loosòna itỹnyhỹkỹmy wadee dehemynyde. Bedetxile resere. Tahe rybeõ raholare: —Salu, Salu, aõherekiwexe aõbina binahakỹle wadee tadiwinymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Tahe jiarỹ rarybere. Mowexe wadee rarybereri, Wanyrỹ. Tii rarybere: —Jiarỹ Nazare ludu watxireri, Jesuisi. Kai aõbina binale wadee tadiwinymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Hãbu wawana rỹimyhỹ, aõ rieryõhyyre aõmybo wadee rarybemyhỹre tahe loosònamy he robirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Tai tahe rarybere jiarỹ: —Aõwexe ariwinykre, Wanyrỹ. Rarybere: —Myike wahe, make Damasu hãwã‑ò. Tai tahe inyõ adee kanarybeke aõbo biwinykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Tai tahe rabiõmy rãiwãhã kia loosòna ritỹrỹrỹhỹkỹreki. Tai wabiòwa ryy wadee ritỹnynyre wadebò‑ki riwamymy Damasu‑ò arehemynykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Tai tahe hãbuõ wadee rehemynyre, Ananiamy ninadu. Tii heka Deuxu tyhydỹỹduõ rare, bede ywina rityhynymyhỹre, ibutumy Judeia mahãdu, Damasu hãwã‑ki heka tuure. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Tii tahe wadee rarybere: —Waseriòre, Salu, aruebimyke ixityre bobikemy. Aõwesele tahe rabimy reare. Ananiamy rabire. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Tahe ixityre wadee narybede: —Inytyby Deuxu juhuu aratare, aõbo tamywimy bierykemy. Tule Jesuisimy bobikemy, Deuxu òbiti hãbu. Tule boholakemy aõbo tii adee kanarybekeò. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tai tahe biwykre irybewihikỹ tỹmyra ibutu bede bede iny‑ò. Belyyke timybo taholatemy, tabitemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Tai tahe rooreheõmykre. Wijile makre maratysebekre. Aòraru‑ribi yrahakỹlemy mabekre, Wanyrỹnimy tetyhynyte xiery. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","Idi tahe Jerusalẽ‑ò rehemynyreu wahe, aõutxumy ixitòenymy rarewỹhỹ Deuxu dohodỹỹna heto‑ki. Tai raholarerasina wese‑ki aõma Deuxu wadee rarybererimy: —Wylemy bòhònykre Jerusalẽ‑ribi. Warybemy tamy marybekreu, rityhynyrenyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Tahe Inynyrỹ‑ò rarybere: —Ibutumy hãwã‑ki aityhydỹỹdu mahãdu rehãtenyre, rewotomonyre, reròtedỹỹnyre. Ibutumy kaki kia rierymy roimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Arybe tỹnydỹỹdu rirubunyreu, moma Estevaõ, jiarỹ taile watxiwãhãre. Rewiòhenanywỹhỹ irubudỹỹdu mahãdu tyy reyrubunyre aõma mana‑di rihurenyreu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Tahe Deuxu wadee rarybere: —Bòhònyke wa Jerusalẽ‑ribi. Irehetyhymy arateòkre judeukõdu mahãdu‑ò. Kia Paulo tamyreny rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Tahe kia iny roholamy rỹimyhỹre kia Paulo iximy relyyreò. Tahe raykarananymy ryryre: —Bidyke karibi ahana‑ò, birubunyke. Irumy rareõkre idi watxiwãhãrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Tatyky riohowire, brybysi‑di biu‑txi rehure, ryrymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Soldado dinodu tahe riteònyre iwo‑ò ridyrenykemy awaru òhòtenahãkỹ‑di tuu raòhòtekemy. Soldado dinodu rierykemy ratxireri aõherekibo iny tamy rakyarananyraki wahe. Tii rarybekre òsana tuu raòhòtekeki. Kia soldado dinodu rõhõtinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Tahe Paulo ritaataarenyre. Imy rahudi tahe Paulo rarybere soldado dinodu‑ò: —Jiarỹ Roma hãwã mahãduõ rare. Wamy maòhòtebenyõtyhy, aywisidỹỹna mahãdu wadee roholaõre tebutunyõteki. Kia riwadỹỹkõkemy roimy rare. Abede ywinareny adee rarybere kia widỹỹõmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Tai tahe kia soldado dinodu tadinodu‑ò rare. Tahe tamy rarybere: —Kowa hãbu, Roma hãwã mahãduõ rare. Tai tahe aõbina bina tamy iwidỹỹõmy. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kia roholareu, tii rara Paulo‑ò tamy rỹỹraxikemy: —Inatyhybe Roma hãwã mahãduõ aõbo atxiteri. Paulo tahe narybede: —Kohe, jiarỹ, kia mahãduõ watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Tai tahe soldado dinodu narybede: —Jiarỹ tule watxireri. Nieru sõwe‑di reòwynyre tuu aronykremy. Tahe Paulo rirawyònyre: —Jiarỹ tiu kia watxireri. Waha dori Roma mahãduõ raremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Tai he soldado mahãdu iribi ròhònyre aõwesele tii Roma mahãdu ratxire riki. Soldado dinodu tule ruberure tii dori rataataamy riteònyreki. ");
INSERT INTO kpjNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Txu biòwamy ritare ròtena‑ribi ròhònykemy. Judeu xiwewahidỹỹna dinodu inyõ ributunyre ywisidỹỹdu mahãdu‑wana. Tahe Paulo ridyre tamy. Tii dori rierykremy ratxireri aõherekibo judeu mahãdu Paulo deramy rỹireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo tamyreny retehere, dinodu mahãdu‑ò wahe. Tahe rarybere: —Waseriòreboho, Deuxudile watximy ramahãre. Tiiemy aõbina binamy aõkõ watxireri, tamy iluuna‑di tyhy watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Anania hãbu‑ò rarybere, iòhòmy Paulo‑ribi rỹireriò: —Iry‑ò bihetenybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulo tahe tamy narybede: —Kai wa aõ aõkõ tate. Hetotira ura wese tate, awo arayky isuisure. Waywisidỹỹdu wesemy talòmy atxiteri, tahe wahetedỹỹmy tarybeta. Kia bede ywina rarybera wesemy aõkõ tewisỹnyteri. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Tahe iòhòmy Paulo‑ribi rỹireri, tamy rarybere: —Kia wesemy rybeõmy Deuxu xiwe wahidỹỹdu wedu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Tahe Paulo rarybere: —Aõkõre, reeryõhyyre aõxiwe wedubo ratxirerí. Tyyriti kiamy rarybemyhỹre: Tiu riki wedumy aõmy rybebinamy aõkõke. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Idi tahe Paulo rexierymy resere. Tahe ixidee rõhõtinyre. Ka iny sõweyre fariseu mahãdu heka rare. Iyrejura tasỹ saduseu mahãdu rare. Tai tahe Paulo ryryre: —Waseriòre mahãdu, jiarỹ fariseu mahãduõ rare. Waha, wylabieboho ibutumy fariseu roire. Rubu‑ribi ixixana retyhynywãhãre. Tai tyhy tahe kia‑ò, ywisidỹỹdu‑ò wiji diwadyde. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Imy rahudi tahe fariseu mahãdu saduseu mahãdu‑wana wiribi rihitxinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduseu dori rubu‑ribi ixixana rityhynyõhyymyhỹrenyre, tule ỹju, tyytyby‑wana rityhynyõre. Fariseu mahãdu tahe, kia ibutumy rityhynymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tai tahe sõwemy rajei jeimy rỹimyhỹ. Tahe fariseuõ rarybere Paulo òbitimy ratximyhỹ. Aõ teòsamy tai tuu arobirenyke kỹnyhe aõkõre. Ỹjuõ òsana tamy rarybera ada tyytyby aõbo. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Tai ta tarurutyhymy ryryrenyre. Tai tahe soldado dinodu ruberure aõma Paulo riykaykaketxi roholare. Tai rarybere tamy: —Iribi bitake, idi boibenyke ixyby soldado heto‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Rumy tahe Paulo weribi Inynyrỹ tamy narybede: —Brebuõmy aõ‑di nohõtiõmyke ixi‑di. Iwese kaki Jerusalẽ hãwã‑ki wamy tarybete wesele heka Roma hãwã‑ki wamy marybekre. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Tahe biurasòtxu he judeu mahãduõ wi dotyde Paulo rubudỹỹmy. Iny inatxiwa ituemy hãbu kia wese raryberenyre: Rikiroxirenyõtyhy bemy rikiõrenyõtyhy. Paulo rurukeki xiery ta rikiroxirenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Tahe xiwe wedu mahãdu‑ò tiiboho roirenyre. Judeu matuari mahãdu‑ò tule kia ibutumy relyyrenyre iwese Paulo rubudỹỹmy ratxireri wese. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Tule tamyreny rarybere: —Kaiboho ixityre marybebenyke soldado dinodu‑ò manakremy Paulo‑di ywisidỹỹdu‑ò. Tamy dỹỹraximy idi ratxireri tiiboho rõhõtinykre. Tai tahe ry kana‑ò rearaki tahe ijoi rikirubunykre. Kia judeu mahãdu xiwe wedu‑ò rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Tahe Paulo seriòre woludu, ilana rubudỹỹmy rarybereò roholare. Tahe ralore soldado heto‑ò tahe tuu Pauloko relyykemy. Tahe relyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Kia roholamy rahudi ta Paulo rariòwyre soldado dinodu tamy kanalokremy. Kiamy rarybere: —Ka weryry bidykre adinodutyhy‑ò, aõma, ijyy‑di ratxirerimy tamy relyykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Tahe ridyre soldado dinodu tyhy‑ò tahe rarybere: —Paulo kỹny ka weryry‑di riwateònyreri aõmybo ako relyykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tahe dinodu weryry axiò iyre ribi rimyre, tahe iny‑ribi rirehenyre rarybekemy: —Aõbo wexe wako belyykre, weryry. Tahe relyyre: ");
INSERT INTO kpjNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","—Wylana Paulo ridykremy judeu mahãdu adee rexitòenykremy ratxirenyre. Tiiboho adee raryberenykre: —Rikitỹỹraxinykre ijõ aõmydỹỹnana. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Uritere tamy boholaõkre, weryry rarybere, idyõmykre tamy. Hãwã mahãdu sõwere rexiwòmy rỹikre, iny inatxi wa itue hãbumy, wylana rubudỹỹmy. Tii ruruõkeki, riroxiõtyhy, bemy riõõtyhy. Kiawese ka hãbu mahãdu rarybemy ramyhỹre. Ahana òsana inyõ rỹireri wylana ridykremy adee kedexitòenykremy. Wylana òludu tahe ryijàti‑ki rexiwòmy rỹireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tai soldado dinodutyhy weryry‑ò rarybere: —Uritere inyõ ierysyõmykre wadee tuu telyyteri. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tahe inatxi soldado dinodu rarariòwyre, tahe tamy rarybere soldado dinodu tyhy: —Aõma, 200 soldado widotykre inataõ òra txu dòhòny‑ribi, ijõ 70 soldado awarutyre‑ki, ijõ 200 soldado tõnori‑di. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kia ibutu‑wana Paulo bidybenykre awarutyre‑ki Cesaria hãwã‑ò. Biyrubunymy boibenyke Feli, kia bededinodu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Tahe tyyriti riwinyre kia wese: ");
INSERT INTO kpjNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","—Jiarỹ Laujiu Lucio, warybe reritinyreri. Warybe wehityhyna rewahinyreri Feli‑ò, Wanyrỹtyhy, bede dinodu‑ò rewahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Hãbuõ adee reteònyreri. Tii judeu mahãdu rimyre tahe rirubudỹỹmy riwisỹnyre. Tahe soldado reteònyre ritakremy rubu‑ribi, tii Roma hãwã mahãdumy rareki. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Redyra heka ywisidỹỹna mahãdu‑ò. Aõherekibo rimyrenyremy arierykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Tabede ywina òrarukile teramy tamy reare, kia reerymy rawãhãre. Iny bede ywina òraru‑ki aõ aõkõ tii riwinyre. Tai rurukemy aõkõ idi rewisỹnyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Judeu mahãdu rarybemy ramyhỹre irubudỹỹmy. Kiamy raholareu tahe, adee reteònykemy resere. Tule irubudỹỹmy rõhõtinyra mahãdu adee rarybekemy reteònyre. Tiiboho aõbo raremy rarybekre. My kie warybe rewahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Idi tahe soldado mahãdu Paulo ridyre, iwese idinodu riteònyre wese. Rudile ridyre Atxipatxi hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Tahe biurasòtxumy tahe tatilemy rare mahãdu ròòsere soldado heto‑ò. Ijõ soldado awarutyre ludu Paulo iridyre Sesaria‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Tahe rehemynyre Cesaria hãwã‑ki. Rare he bede dinodu‑ò. Paulo tamy riwahinyre tyyriti‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kia tyyriti‑di tii rariareu tahe, tamy ritỹỹraxinyre: —Tiribibo tate Paulo. Tahe Paulo dirawyònyde: —Jiarỹ, Silisia hãwã mahãdu rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Tahe bede dinodu narybede: —Kaa hãbu mahãdu wii kodotykreu, kedehemynykreu, aroholakre inihe arybe‑ò. Tahe iyrubudỹỹ idi risỹnyre Herodi ywisidỹỹna heto‑ò, Pretòriu ninadu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Iruyre txu reare rexihudi tahe, Anania, xiwena wedu tyhy, judeu mahãdu matuari‑wana rehemynyre, ywisidỹỹna mahãduõ‑wana rehemynyre, moma, Tertuliu inire. Paulomy aõbinabinahãkỹ rybemy rareri bede dinodu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Tahe Paulo didyde. Tertuliu rarybere Paulomy. Awiõmy rybe tahe ròhònyre. Juhuu Feli‑ò rarybere: —Kai Wanyrỹ tyhy, awihyymy heka atximahãte wadeereny. Tiiemy bede ywina inydee tewahinymahãte. Ibutumy iny bede hãwã hãwã‑ki iny tewiòhenanymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tai tahe omy reàlàtyhymy he watxiwãhãre. Urihimyòle adee Paulo aõmydỹỹnanamy ararybekre. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Txioi inihe làhà, boholabeny. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tiiemy jei jeihyy ratximyhỹre Paulo òraru‑ki. Tiiemy judeu mahãdu, my heka rarybehyy ratximyhỹre. Tii Nazare hãwã dohodỹỹna mahãduõ rare, kia weduõ rare. Tii Jesuisi rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Aõkõre, iny Deuxu dohodỹỹna heto ribinadỹỹnyre, brebuna rỹirerimy ihỹre Paulo òraru‑ki. Remyrenyre tahe, ywisidỹỹmy watxiwãhãre iny bede ywinareny rarybere wesemy. Tahe aõkõre, Lisiu soldado dinodu tyhy ritare iny‑ribi wotõmona‑di. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Tahe inydee rarybere: —Boibenykre Feli‑ò. Tii adee roholakre. Kia tahe Lisiu rarybere. Tahe jiarỹ tule rarybere. Boibenyke Paulo dỹỹraximy kia inatyhy aõbo ada aõkõre aõbo. Tertuliu kia ibutumy rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ijõ judeu mahãduõ rarybere: —Kia inatyhy ibutumy inatyhyle ratxireri, aõmybo Tertuliu raryberemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","11","Tahe bede dinodu Paulo‑ò riteòsinyre rỹikemy, rarybekemy. Paulo tahe tamy rarybere: —Wanyrỹ bede dinodu tyhy, sõwe beòra aõmydỹỹnana‑di ywisidỹỹna‑di atximahãte. Jiarỹ kia reeryre. Tai reysawãhãre adee ararybekremy. Waò inatxi reuròtxumy heka Jerusalẽ‑ò adehemynyde. Iny‑ò bitỹỹraxinykeki, wylemy ka bieryke inatyhy raremy. Jiarỹ Deuxu dohodỹỹna heto‑ò rehemynyre Deuxu reàlàkemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Tiu heka jei jei rewinyõhyywãhãre dohodỹỹnaõ‑ki aõkõ, hãwãy‑ki aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Aõmybo wamy rarybemy rỹireri heka, aõ inatyhy aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Sohoji aõmydỹỹnanamy tahe akoreny arelyykre, inatyhy rare. Retyhynywãhãre heka aõbo Jesuisi rierynanymyhỹremy. Tiiboho watyhydỹỹna rininirenyre dohodỹỹna mahãdu iwitxira. Kia hãbu rityhynymyhỹre wesele jiarỹ tule Deuxu inytyby retyhynymyhỹre. Ibutumy bede ywina tyyriti‑ki riritinymy rỹimyhỹremy retyhynywãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Iny, òrarudu mahãdu, ityhydỹỹdu mahãdu kedeixixakremy rubu‑ribi. Kia retyhynywãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Tiu ibutumy òbiti widỹỹmy raruwãhãre. Deuxu‑txi tule ibutu hãbu rue‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Jerusalẽ‑ribi rarewãhãu, tiwese beòra rewyre tahe ixyby dòòsede Jerusalẽ‑ò aõkõ mahãdu wahidỹỹna wesemy ariwahinykremy xiwena wese Deuxu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Deuxu dohodỹỹna heto‑ki watxiwãhã, òbitimy rãire, ibutu bede ywina reywinymy rawãhãre. Tahe waxiwena‑di waòludu wamy robire. Iny sõwemy weroramy watxiwãhã. Rybe jei jei rarybeõhyyre. Tahe Asia bede judeu mahãdu tai rỹimyhỹ. Tiibohole rybe jei jei riwinymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Wamy aõmydỹỹnana rarybekremy ijõdikeki, rokoholakre. Kaki aõkõ ratximyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Aõbo waki teòsamy rahare ywisidỹỹna mahãdu‑ko rãireu, tamy rokoholakre. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Sohoji aõmydỹỹnanalemy rarybere teòsamy. Kiamy rarybere: —Retyhynyre rubu ixyby kedexixakre. Tai ywisidỹỹna mahãduko‑ki watxiwãhã. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feli bede dinodu rierymy ratxireri aõmybo ityhydỹỹdu mahãdu rityhynyre. Tai rarybere judeu mahãdu‑ò: —Lisiu, aõma, soldado dinodu tyhy rehemynyreu, bede rikierydỹỹnanykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Tahe Paulo ròtena heto wese‑ò ratximyhỹreki, riòòsedỹỹnyre. Ta rarybere he soldado dinoduõ‑ò: —Ywimy idi ratximyhỹkemy. Tule rarybere: —Iò ixinamy terina mahãdu iroramy kanakre. Ixinamy uriõnomy tamy kidiwahinykre awityhy roimyhỹkemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Iribi nade Feli tahãwyy‑wana Drusila. Ihãwyy heka judeu mahãduõ rare. Riteònyre Paulo‑ò tamy kanakremy, tamy kanarybekremy. Paulo rarybere tamy: —Jesuisi Kristu kia tyhydỹỹnamy. Tii òbiti‑di iny rõhõtinykemy tule ywisidỹỹna txumy Deuxu kanakremy ritỹnynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Tahe Feli ruberure. Makre, tamy rarybere, aõwaxiny tiubo wabededỹỹnana‑di my kỹnyikreu, ixyby adee ararãriòwykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tule Feli ijõ nieru Paulo‑ribi ritakemy ratxireri, tai rarariòwyre ijõtxu ijõtxu tii‑wana rarybekremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Inatxi beòramy bede idi rỹire. Iwitxira bede dinodu ralore Feli deròwy. Porsiu Festu inire. Feli tahe judeu mahãdu tuure tamyreny aõõ riwinykemy ratxireri tahe Paulo ririre ròtenawo‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Cesaria hãwã‑ki bede dinodu tỹmyraõ ronyre. Festu inire. Inataõ txu‑di tahe iribi ròhònyre Jerusalẽ‑ò rakemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tahe xiwe dinoduõ, judeu mahãdu dinoduõ tamy rarybere Paulo aõmydỹỹnanamy. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Tamy rexitòenyre Paulo‑di wylemy kanakremy. Kiamy heka rexinohõtidỹỹnyre ryrowetya‑ki rirubunyrenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Aõkõre, Paulo ratxirekre Sesaria‑ki, Festu rarybere, jiarỹ tahe aròòsekre ele elemy kowa‑ò. Kaiboho adinodu mahãdu wadi roikre kowa‑ò. Rokoholarenykremy ywisidỹỹna‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tule kaiboho aõrybedikeki, Paulomy, kowa‑ò rarybekremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Iribi tahe debòwiò txu òsỹny txu idi rỹidi tahe ixyby Festu dòòsede Cesaria‑ò. Irootxu tahe Paulo ywisidỹỹna ròhònyre. Tahe Paulo ridykemy riteònyre ywisidỹỹna butuna‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Tahe judeu ywisidỹỹna mahãdu heka sõwemy tuu aõbina binahakỹmy Paulomy rarybemyhỹre, Jerusalẽ‑ribi rehemynyreu. Aõ inatyhymy aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo tahe rexitxiõnyre: —Jiarỹ kỹny kia‑di aõkõ watxiwãhãre. Tii rarybere: —Tiu heka judeu mahãdu bede ywina ratyre aõna aõnamy ratỹỹkõre. Tiu heka Deuxu dohodỹỹna hetomy rewinyõwãhãre, tiu Roma dinodu bede ywina ratyre aõhe ratỹỹnyõwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Idi tahe Festu rỹỹraxire Paulo‑ò: —Kawexe texiywinymy atxiteri Jerusalẽ‑ò makremy. Kowa ywisidỹỹna ariwinykemy adee roholakremy. Kiamy Festu rarybere aõwiwihikỹmy riwinykemy ratxireri judeu mahãdu dee. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Tahe Paulo rirawyònyre: —Aõkõre, arakre he Iòlò tyhyòhòkỹle arehemynykre. Tii wadee roholakre. —Jiarỹ dori ixiywinyhyy tamy arakre. Kai teeryte jiarỹ aõkõ tudỹỹduramy. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Aõma aõbo waki binamy relera‑wana heka arurukre. Aõkõkeki tahe aõbo awihykyle rewinyre‑wana heka timy inihe warubudỹỹõmy. Iòlò tyhyle wadee roholakemy he ixide rahõtinyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festu tawiòhedỹỹdu‑ò rarybere. Idi ta dirawyònyde: —Awire, iòlò tyhy‑ò atxiteri urenana kỹnyhe aõwaxiny makre. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Iribi tahe aõutxumy tahe iòlò Agripa dehemynyde, Benise tariòrese‑wana. Festu roramy rareri. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Tahe tii‑wana rarybemyhỹre aõutxu, Festu‑wana. Idi tahe Paulo aõmydỹỹnanamy iòlò‑ò rarybere: —Ròtenawoluduõ roireri ròtenawo‑ki. Tai he Feli ririre jiarỹ iaõmydỹỹnana arierykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Aõma Jerusalẽ‑ki watxiwãhãu, dohodỹỹna wedu mahãduõ wadee heka rarybere: —Tii arirubunykemy heka wadee rityhenymyhỹre. Judeu mahãdu matuariõ tule kia rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Tahe tamy jiarỹ rarybere: —Aõkõre, aõma Roma mahãdu kia bede ywina dori tuu aõkõ roimyhỹre. Juhu heka rakre ywisidỹỹna‑ò tahe relyykre heka iximy, taòludu mahãduko‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kaò juhu ditehemynydenydeu, tamy rarybere. Ijõ txu he reyrubunyre ywisidỹỹna‑ò roholakremy tahe Paulo ridykemy aditeònyde. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Tahe aõmybo tamy rarybere heka, iwese rahõtinyre wese aõkõ tii riwinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Aõbo ityhynareki heka tuheka rỹire. Inyõ heka tii rarybemyhỹre Jesuisi rurulemy. Tahe Paulo rarybemyhỹre irulemy ihỹre. Tai kỹnyhe rimymy ramyhỹre. Riròtenymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Tai tahe tiiemy rahõtinyre: Timy taheka aõhe arotỹỹnykre ka aõmydỹỹnana‑di. Paulo‑ò retỹỹraxire aõma Jerusalẽ‑ò aõbo rakemy ywisidỹỹna‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Tahe Paulo rarybere: —Iòlòòle rakremy aõbo. Tii wamy roholakeki, teòdu waòrysymy ariraokre. Tai tahe ròtena‑ò ixybyle rerutyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Tahe iòlò Agripa rarybere: —Jiarỹ aroholakre inihe kia hãbumy. Tahe Festu dirawyònyde: —Biurasòmy tamy bodoholakre. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Idi tahe itxu biòwamy dehemynyde, iòlò, Benise‑wana, ywisidỹỹna heto‑ò. Ibutumy he iny ralore, soldado wedu mahãdu, iny ityhymy rỹira mahãdu, ibutumy raloralore. Tai tahe Festu Paulo didyde. Tahe rarybere: ");
INSERT INTO kpjNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","—Iòlò Agripa, ibutumy ka wadee ijohonadu‑wana, ka hãbu heka ibutumy iny he irubudỹỹmy he idi rỹireri, judeu mahãdu kaki tule Jerusalẽ mahãdu. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Jiarỹ rahõtinyreri aõ heka riwinyõhyyre tai rurukre wahe. Tai iòlòtyhy‑ò rakremy heka ratxireri. Ariteònykre nomy dori tii ratxireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Aõbo tamy ariritinykre. Aõ heka waritidỹỹkõnare. Aõ dori riwinykõre. Tai redyreri adee iòlò Agripa. Tamy juhu boholakre. Iribi tahe wadee manarybekre aõbo ariritinykremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Timy kỹny wateòdỹỹkõna uritere òhynaòhòkỹle Iòlòtyhy‑ò ariteònyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tahe Agripa Paulo‑ò rarybere: —Aõwaxiny belyykre aijyymy. Paulo he tebò riukore he rarybekremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Wadeysamy he watxireri, Iòlò Agripa. Jiarỹ dori iximy arelyykre ako. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Tule kai dori ibutu judeu bede ywina teeryte. Ibutu lahi rybe teeryte. Bodoholakre inihe wadee, ywina‑di. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Tiiemy uladule aratyyritinyde aõma judeu òbitina‑di. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Judeu mahãdu kia rieryre. Txu rexidelenyre juhu judeu mahãduy‑ki, idi tahe Jerusalẽ‑ki ratyyritinyre. Jiarỹ fariseu mahãduõ òbiti jiarỹ rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kia rybe òraru‑ki wiji ywisidỹỹna‑ki rãire. Jiarỹ dori retyhynywãhãre aõbo Deuxu inytyby‑ò rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Jiarỹ Deuxu rybe òlòna reraòwãhãre. Tule judeu ijoi riraòmyhỹre, waòinatxi reurò ijoi mahãdu. Tiiboho Deuxumy reàlàmy raremyhỹ, rumy, txumy. Iòlò Agripa, kia raròsòna òraru‑ki judeu mahãdu wadee aõbina binamy rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Rubu‑ribi ixixana jiarỹ retyhynymyhỹre. Araỹraxikre iòlò. Kia aõbohe wadeòsana raremy kaiboho tahõtinytenytere. Deuxu heka ixyby iny kidiòkesedỹỹnykre taumy tuedeòna‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Jiarỹ heka juhuu awimy heka aõbina binahakỹ widỹỹ dee rahõtinyre, Jesuisi Nazare hãwã ludu dee. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Sõwemy ityhydỹỹdu mahãdu reròtenyre ròtenawo‑ò Jerusalẽ‑ki. Dohodỹỹna heto wedu rewawiòhenanyre tyyriti riwahinyreki. Kia irubudỹỹmy wi risỹnyrenyreu, jiarỹ rarybere: —Awire heka birubunybenyke. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Jiarỹ heka ityhydỹỹdu mahãdu aõhõkỹmy rotỹỹnykemy wi resỹnyre bede bede‑ki. Aõbinabinahãkỹlemy ityhydỹỹdu rerybedỹỹnywãhãre. Jiarỹ aõnimy reburemy rawãhãre. Resỹbinanyre tahe tii rahenyre irehetyhytyhy‑ò iwitxira hãwã‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Rare heka Damasu hãwã‑ò ityhydỹỹdu òrysymy. Jiarỹ tyyritidi rare, dohodỹỹna wedu ritina‑di. Tule ibede ywina‑di rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Tahe Damasu iòhòmy rareu, loosònaõ diwatoosònyde, txu loosòna ratyre ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Jiarỹboho rejuxunyrenyre tahe raholare rybeõ‑ò judeu mahãdu rybe‑di rarybereri: —Salu, Salu, aõhereki wexe aõbina binahakỹ tadiwinymahãte wadee wimy aõkõ. Aõbina binahakỹle ixidee tadiwinymyhỹte. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Jiarỹ rarybere: —Mowe, Wanyrỹ tate. Tahe dirawyònyde: —Jiarỹ wa, Jesuisi rare. Wadi aõbina bina tewisỹnyte. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Katahe myikre. Adee rehemynyreri, aratara ixidee, wadeòdumy mabekremy. Warybeduõ mabekre. Ibutumy wamy belyymy mabekre aõhebo adee wiji rotỹỹnyreri. Iribi tasỹ ixityre adee adehemynykre. Tule kia‑di marybekre. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ibutumy asỹ‑wana arayrubunykre. Tai ta judeu mahãdu‑ò arateònykremy watxireri, judeu mahãdu‑ò tule. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Iwese iny ruetà‑di rỹira wese tii ihỹre. Kai tamy bitỹnynykre Deuxu aõmydỹỹnana. Tai biruejuakre, rierykremy. Biòbitinykre tamyreny òrarudu roire aõma ixi‑txi tõhõti reakremy loosòna‑ki rariakremy, Satanasi bedelorohokỹ‑ki aõkõ, kia ryki aõkõ rariakremy. Deuxu uri bede ywina rimymyhỹkre ixidee. Ibutu bede bedemy rỹira waijoimykre. Tyramy taòraru‑ribi rỹira, ritamy rỹira, riwatyhynymy rỹira. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","20","Tai, Iòlò Agripa, iwese warasina‑ki riwateònyre wese, retyhynyhyyre. Juhuu Damasu hãwã‑ki jiarỹ ròhãletere, iribi Jerusalẽ‑ò, tule Judeia bede‑ki, ibutu judeukõdu mahãdu‑ò ròhãletere. Tamy rarybere taòraru ririkemy Deuxu dee kòdòòsekemy. Ixi‑txi tõhõti reakremy inatyhymy aõna aõna wiwihikỹ riwinykemy Deuxu dee. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Tai judeu mahãdu riwamyre Deuxu dohodỹỹna heto‑ki, warubudỹỹmy rõhõtinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Deuxu tahe wawiòhedỹỹdu ratximyhỹre. Tai he rãire wiji ibutu‑ò ararybekemy watxiwãhãre, aõma aõbo Deuxu rybedu mahãdu iwese Moisesi rarybere wese tamyreny rarybewãhãre kia ibutumy kanakremy. Kia sohojilemy rarybewãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Juhutyhy rarybere: —Kristu, rurukremy iribi tahe kedexixakremy rybe loosòna kidiwykremy judeu mahãdu‑ò, tule judeukõdu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Tahe Paulo iximy rarybereu, Festu ryryre: —Paulo, kai wa itxỹtere. Aõnityhymy tatyyritinymahãte. Tai arayky tebinanyta. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Tahe Paulo rirawyònyre: —Aõkõre wa, wanyrỹ Festu, bededinodu tyhy. Jiarỹ itxỹte aõkõre. Inatyhyrybemy rarybewãhãre. Warybe awi heka rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Tule Iòlò Agripa rieryre ibutumy tuu tamy rarybere. Aõ wasina aõkõ rarybere. Iòlò Agripa. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Aõbo Deuxu rybedu mahãdu riritinyre aõbo, kai tetyhynymahãte. Reeryre jiarỹ, kai tetyhynymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tahe Agripa riixãwididỹỹnyre rybe‑ribi: —Kai, aõbo, Paulo, aõwesele ityhydỹỹdumy aronykemy wadi tahõtinyte, wadee tarybeteki. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo rirawyònyre: —Kohe, wadee awire, kai tulekemy. Ibutumy kaki wawesekemy adi rahõtinyre. Kai tule warybe sõwemy aõbo ada aõkõre aõbo Deuxu bityhynybenykemy watxiwãhãre tule waijohonana‑wana. Aõna sohojidile taanamy aõkõ watxireri, wawomati reroti‑di taanamy atxiteri. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Idi tahe bede dinodu, iòlò, Benise, ibutumy he rỹire ròirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Widee reny wiwesele rõhõtinyrenyre. Ka hãbu timyhe rubudỹỹona he ròtena‑ki irutysyõna he, tii dori aõhe rotỹỹnyõtyhy aõna aõnamy. ");
INSERT INTO kpjNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Tahe Agripa Festu‑ò rarybere: —Rikiteònyrenyke idi watxireri, tahe tii inihe iòlòtyhyle rarybekemy ixidi ratxireri. Tai kỹnyhe, txioinihe, aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Tahe rexiywinymy rexihurenyre Italia bede‑ò, Roma hãwã‑ò aroirenykremy hãwò‑di. Tahe ròtenayrubudỹỹduõ tii‑wana rakre, irubudỹỹdu renymy. Julio inire. Tii iòlò yrubudỹỹdu mahãdu dinoduõ rare. Ridyrenyre Paulo ròtena woludu mahãdu‑wana. Jiarỹ, Luka tule ihemy rare. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tahe rerònyre yhywydyna lawò‑ò. Adrỹmitxiludu tahe kia lawò rare. Tule hãbuõ wawana rare. Aristarku inire. Tii Macedonia bede luduõ rare. Tesalonia ihãwã rare. Tahe hãwò rexihynyrenyre adòikemy Asia bede‑ò. Tahe ròirenyre. Ijõtxu biòwa Sidoma beàbeà‑ò rehemynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Paulo taery mahãdu roramy rakemy ratximyhỹre. Tahe Julio Paulo‑di itxeredu ririra. Tai tahe Julio awi heka rare Paulo dee. Julio Paulo riywiywinymy idi ratxirerimy ihỹre. Julio Paulo riteònyre titxibo rakelemy. Paulo ery mahãdu aõna aõna tamy riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","5","Tahe iribi ròhònyrenyre. Xibri bedebute roosibymy ralore yhy dori tiribi tiribi reamyhỹreki. Tahe iribi riòlònyre. Tahe Silisia bede‑ribi riòlònyre, tule Panfilia bede‑ribi ijõ bede‑ò reronyre. Tahe Miha hãwã‑ò ritehemynyre Lisia bede‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tai soldado dinodu hãwò nihikỹ riijemyhỹu, ihe‑ki roikemy, tahe ijõ‑ki rahare Alexỹdria luduõ‑ò. Hãwò tahe rexiywinymyhỹre rakremy Italia bede‑ò. Tahe wadeereny rarybere: —Borukubenyke yhywydyna lawòro‑ò. Tahe ixityre roirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Sõwemy heka txuu wadireny rỹire. Urihimyòle rexihejiwãhãrenyre. Isirare heka Kinidu hãwã‑ò dehemynysỹ. Ihãrele tahe retehemynyre Samona hãwã mynatyhyle raròrenyre. Iribi Kreta bedebute roosibymy ralore yhydori tiribi tiribi reamyhỹreki. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tahe ywimy suò iòlò iòlò adoiwãhãdenyde ihyy tahe retehemynyre Rywihikỹmy ninadu‑ò. Kia heka Laseia hãwã‑ribi iòhòre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Sõwetyhymy txuu wadireny rỹire yhynihikỹ bina òraru‑ki. Inarehe lisina txu‑ribi ròhònyre. Tai tahe bededỹỹnana ibutumy roimyhỹre. Tai brebunamy bede roimyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Paulo tahe tamyreny rarybere: —Wanyrỹboho, ka tỹina isiratyhykre inydeereny. Inynonanareny iòhãrure aõna aõna ibutumy inyribireny ituekre, hãwò rabohokre ada ijõ aõbo rikururenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Tahe soldado dinodu Paulo rybe rityhynyõhyyre. Yhylawò wedu tòruludu‑wana tii rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Yhylawò wedu, tòruludu‑wana iwitxiramy rõhõtinymyhỹre, beòra tai riekõkemy beà dori ibinareki. Ijõ tule tahe roirenykemy ixide ihỹrenyre rehemynykemy Fenisia beà‑ò. Kia heka Kreta bedebute beàõ rare. Biuweribitya‑txi ròròmyhỹre, tai awire kia beà, beòra bede riwykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ijõ rarybere: —Rikoirenyke, yhy dori rebonyreri, tamy rekehemynyrenykemy. Tahe womatisana riukore. Roirenyre yhy‑di. Tahe iòhòmy Kreta bedebute rotỹỹnyra. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Aõwesele heka yhy nihikỹ dehemynyde bedebrò‑ribi. Kia yhy nihikỹ iraro bedebrò ludu inire. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ka yhy nihikỹ taruru‑di riwyre hãwò nihikỹ. Juhu yhynonana weribi‑ò riwisỹnyre. Idi iwo rexieryre ixinamy riwyre yhyòkesena‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tahe rehemyhỹre Lauda bedebute‑ò iroosibymy tahe ralore. Tai hãwò nihikỹwo‑ki hãwòriòre riwyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Idi tahe rõhõtinyre hãwò nihikỹ rabòhòke‑txi roholarenyre, tai tahe ritaarenyre iwetya‑txi. Tahe ruberurenyre, Libiamy ninadu beõlau, tahe welòhòkỹ ritare iribi rexitarenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ijõtxu roirenyre yhynihikỹ tamy realemy iu, tai tahe aõna aõna‑di rehure ibutemy rawetarikemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Tasỹ txuõ idireny reare. Idi rehurenyre aõmybo rekoakõmyhỹrenyredi rawetarityhykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Txu sõwemy rewyrenyre txumy, tainamy ribi renyõhyyre. Yhynihikỹ reamyhỹ. Tai sõwemy ruberumy rỹimyhỹ rubu lau. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Sõwemy heka bededỹỹnana riwyre roxiõhyy. Tahe Paulo iyreny‑ki rỹire, tahe tamyreny rarybere: —Wanyrỹboho, warybe‑ò taholaõhyytenyte Kreta‑ribi ròhònyrenyreu. Aratohonyrenyre iribi inyboho kodoikõkemy. Boholabenybe‑wana ta inihe aõna itueõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ihãrele tahe deysana‑di adeereny ararybekre. Inyõ ruruõtyhy, hãwò nihikỹ sohojile rabohokre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Jiarỹ dori Deuxu deòdu rare. Kaurumy dori Deuxu ỹju wadee nade. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Tahe rarybere: —Paulo, brebuõmy. Kai iòlòko‑ò makre. Deuxu dori ruxetòena kidiwahinykre. Tiu heka aruburenyõna aijoi‑wana. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Tahe wanyrỹboho, brebuõmyreny. Jiarỹ dori Deuxu retyhynyre, iwese wadee rarybere wese, rarekre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Urile tahe inyboho kiditehemynydenykre bedebuteõ‑ò. Kia tahe Paulo rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Waòinaubiòwa rumy beronihikỹ tya‑ki bede riijemy roiremyhỹ. Adria beronihikỹ‑ki roirenyreu, tahe rutya‑txi hãwò nihikỹ aõna hydỹỹdu su iòhòmy roholarenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Tahe beõ urihixina‑di riurihire, wawiò dera urihixinamy beõ riurihire. Idi iko‑txi ixityre riurihire tai waiyre dera urihixinamy rimyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Tahe rahõtinyrenyre manale tai roimyhỹremy. Tai tahe manatisana‑di inaubiòwa lòru ludu‑ribi rehurenyre. Iribi rexitòenyre wylemy txuu kanatỹnykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Hãwò aõna hydỹỹdu mahãdu hãwò riòre riwesere bera‑ò. Idi risỹnyre ijõ manatisana ritidikremy hãwò jura‑ribi. Urile tahe rahenykremy rõhõtinyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paulo tahe rierymyhỹ tahe soldado wedu‑ò rarybere: —Soldado mahãdu tule roholare: ");
INSERT INTO kpjNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","—Hãwò aõnahydỹỹdu mahãdu hãwò nihikỹkỹro‑ki rariõrenykeki, kaiboho atuerenyke. Tai tahe soldado hãwò riòre reroti riàrore tahe resere bera‑txi rahenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Txuu iòhòmy natỹnyde, tahe Paulo tamy rarybere: —Wiji waò inaubiòwa txumy kaiboho teraòtenyte tabyretenyõhyy. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ijõ birỹsỹbenyke, arurureny rexiòlònykemy, kaibohoõ dori burubenyõtyhy. Aradeti sohojiõ tiu iõõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Rarybemy rahudi tahe, paõ sohoji Paulo rimyre. Ibutura‑ò Deuxumy reàlàre. Idi tahe paõ riorore, riyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ijõ reny reysarenyre, taita tule riyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tahe 276 iny hãworo‑ki roirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Tahe ibutumy iwo rihyrenyre tahe maixõmo wesena‑di rehurenyre hãwò nihikỹ rawetarinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Bede ratỹnyreu, inyõ rieryõhyyre titxiribibo nade. Tuu robirenyre iworywo‑ki ỹnyra tai roimyhỹremy tahe inyõ rieryõlemyhỹre. Widee raryberenyre: —Rikirònyrenyke hãwò‑di iwo‑txi. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","41","Tahe manatisana riukòrenyre tahe welò riderenyra hãwojura‑ò iraròsòna riesere. Tahe ritelenyre ralòkemy. Urile esetere tiò tiòle hãwò ridymyhỹ beõ òhòkỹle idi rehure rorokõòhòkỹle, rimyre taile òbò hãwòlòru ribohonyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Soldado mahãdu rõhõtinyre ròtena mahãdu rahenyketxi. Tai rirubunykemy rõhõtinyre bede‑ò robunyke lau. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Soldado wedu tahe Paulo ritòenyre rubu lau, tai tahe riteònyre rirubunyõhyyre: —Tibo alobueryre, juhuu suò rakemy, soldado wedu kia rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Tibo alobueryõke tahe òwòru àre hãwò‑ribi rimymy idi rakre. Kiamy heka ibutumy retehemynyre su‑ò, inyõ ruruõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tai tahe taisỹdu mahãdu‑txi rekoare. Tii bedebutenimy inydee relyyre. Malta heka inire. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Biu riwasebenyrenyre yhyjutyty riwasarenyre. Tai tahe tiiboho heòty riworonyrenyre wahetònarenymy. Tiiboho riwawisinanyrenyre awimy wadireny roiremyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo hee ributunyre heòtyworonamy. Idi rehureu, hemylala he wo‑ribi heòty lau ròhònyre, tai ruruare Paulo debò‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Tusỹdu mahãdu tuu robire tahe rarybere: —Ka hãbu rubudỹỹdu òsỹny rare. Tii heka ruruõre bera‑ò, ka tahe kidiòwynykre inyõ òsỹny rirubunyreki wahe, rurukre heka. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Paulo tahe hemylala tebò‑ribi riatyre heòtyru‑txi. Ta aõhõkỹmy rotỹỹnyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Tahe imahãdu idi retehemy rỹimyhỹ tarubulemy resekeò, ada tebò ratarinybohokeò aõbo. Sõwemy riraòre, aõhebo rotỹỹnyke, tahe aõkõhyyre. Tai tahe iwitxiramy rõhõtinyrenyre: —Tii deuxuõle òsỹny ratxireri. Tiiboho raryberenyre kia. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","8","Hetoõ tai iòhòmy rỹire, Publio iwedure. Tii heka ityhy rare iwedu rare kabedebute‑ki, tii bedeòtiidỹỹna rare. Tai taheto‑ò riwadyrenyre. Awihyyle wadireny raremyhỹ. Publio tyby tahe rubunamy rurumyhỹ. Busu‑di ratximyhỹ. Tai tahe Paulo iroramy rare. Tebò ityre ritidire, rexitòenyre, tahe riteytenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Tai tahe ibutumy bedebute ludu webinadu Paulo dee wii rotyre. Ibutumy reyterenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Tai tahe uriiõno inydeereny riwahinyre aõna aõna. Sõwemy rỹsỹna hãworo‑ò rahyre inydeereny. Kia hãwò beòra bede kia beà‑ki riwyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Txuòkuro hãwò ni rare. Kia ni ihiju rare. Ideuxu ritxoo inatxi rare. Hãwò Alexỹdria hãwã ludu rare. Tahe rahònyrenyre. Inataõ ahãdumy bede wadireny rỹidi. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sirausa hãwã‑ò retehemynyre. Tai tahe inataõ txumy wadireny rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Iribi tahe Rejio hãwãmy rekoarenyre. Ijõtxu tahe Pozuli‑ò reòlònyre. Inatxi txu‑di retehemynyre yhy ibòò‑ribi debonydeki. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Tai seriòreõ ratximyhỹ. Tiiboho rexitòenyrenyre tii‑wana ratxikemy debòinatxi reurò txumy. Kiamy heka Roma hãwã‑ò roirenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Roma ityhydỹỹdu mahãdu roholare jiarỹboho retehemynyrerimy. Tai tahe doidenyde Apio hãwã ube‑ò. Tule aõ‑di ijohona Heto Inataõ hãwã‑ò doidenyde. Paulo tiiboho robireu, Deuxu reàlàmyhỹ, reysamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Tahe Roma hãwã‑ki Paulo ixideewimy rasỹnyre. Urile soldadoõ aõu aõu tii‑wana ratximyhỹ. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Inataõ txumy bede idi rỹidi, Paulo ributunyre judeu mahãdu dinodu. Wii ributunyreu, tamyreny rarybere: —Wanyrỹboho, waseriòreboho, jiarỹ aõ rewinykõre waijoi Judeu mahãdu dee. Tule lahirybe õnosõna ratyre aõ rewinyõhyyre. Ihãre judeu dinodu riwamyre. Tahe diwahinyde Roma dinodu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Tiiboho heka riwatỹỹraxinyre ibutumy. aõ heka waki ibinamy rahaõhyyre. Tai tahe riwateònyrenykemy ratxirenyreri. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Waijoi tahe Judeu ijoi heka waòludureri. Tai tahe Iòlò‑ò jiarỹ rarybere arakemy. Aõ dori waijoi dee waòraruõre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Tai heka arabutunyrenyre, warybe‑ò boholabenykemy, wadi retehekemy womati reroti‑di riwataataara. Judeu mahãdu raròsòna òraru‑ki kawesemy watxireri. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Tahe judeu dinodu mahãdu rirawyònyre: —Aõkõre, inyõ rehemynyõre Judeia bede‑ribi. Ijyybinamy umy relyyõre. Inyseriòre mahãduõ kaò dehemynyõde. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Aroholarenykemy timybo tahõtinymahãte‑ò. Ityhydỹỹdu mahãdumy dori ibutumy aõbinahakỹlemy rarybereri. Kia judeu mahãdu dinodu raryberenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Tahe riywinyre itxu Paulo rybe‑ò ijohonamy. Idi tahe Paulo heto‑ò sõwemy iny doidenyde tamy roholakemy. Tii Deuxu ijyy ritỹnynyre rudiu rexidelenyre, txioromy rexihure Moisesi Tyyriti ritỹnynyre tule ijõ rybedu Tyyriti‑di ritỹnynyre, iwese Jesuisi Iòlòtyhy kanatxikre wese kabede‑ki. Kia Jesuisi aõmydỹỹnanamy ritỹnynyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ijõ roholare aõmybo Paulo rarybereò, Jesuisi rityhynyrenyre. Ijõ tahe aõkõre, rityhynyõre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ijõ teramy reare. Rỹire, ròhònykremy. Tahe Paulo tamyreny rarybere: —Deuxu Tyytybytyhy booreny dee rarybere Isaia tyyriti‑ki. Awimy rare. Kawese roire: ");
INSERT INTO kpjNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","27","—Makre tamy marybekre: —Boholabenyke, ta tiu aerysyrenyõna. Betehekre arue‑di, ihãre tahe aerysyrenyõna. Iruereny, iraykyreny, tõhõtireny ritòbònymahãrenyre. Tai tiu tiiboho robirenyõtyhy, rieryrenyõtyhy, roholarenyõtyhy. Tai diwatyhynyõhyymyhỹde. Tai heka iòraru‑ribi ariteytenyõkre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Bierymy boibeke Deuxu tarasana judeukõdu mahãdu‑ò rare. Tiiboho dori roholarenykre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paulo tarybe rahudi tahe, judeu mahãdu ròhònyrenymy sõwemy widee rarybemyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Roma hãwã‑ki Paulo rasỹnyre inatxi beòramy tahetohuòtenawo‑ki. Ibutumy heka dỹỹraximy iheto‑ò rehemynyrenyreu, Paulo ridyre tamy rarybekremy. ");
INSERT INTO kpjNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Deuxu Iòlònamy Paulo iruru‑di relyyhyymyhỹre. Inynyrỹ Jesuisi Kristu aõna aõnamy rierynanymyhỹre. Tiu inyõ aõhõkỹmy risỹnyõmyhỹre Paulo rybe xãwikemy.");
INSERT INTO kpjNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paulo jiarỹ rare, tyyritiwidỹỹdure wahe. Jiarỹ heka Jesuisi Kristu deòdu rare. Tii riwatare rybe tỹnydỹỹdumy ararekremy. Deuxu Rybewihikỹ wahidỹỹdumy ararekremy. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Juhuu dori Deuxu rarybere Rybewihikỹ riwahinykemy. Deuxu rybedu mahãdu kia rybe riritinyre, Ritidỹỹnatyhy‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Kiamy heka Deuxu Riòre rybe tyhydỹỹnamy rarybere, Davi riòre riòkòreõ wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Deuxu Jesuisi Kristu rubu‑ribi riixixadỹỹnyreu, tariòremy tahe riteòsinyre rurunatyhy‑di. Jesuisi tahe inatyhymy Inynyrỹ ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Tii ruxetòena inydeereny riwahinyre. Irybe òraru‑ki, jiarỹboho aròirenykemy watxireri. Ityhyna aritỹnynykemy judeukõdu mahãdu‑ò, tai tiiboho rityhynyrenykremy. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Kaiboho tule judeukõdu mahãdu atxitenyteri. Tahe Deuxu ityhydỹỹna mahãdu atxitenyteri, Jesuisi Kristu ijoimy rỹirakemy adeereny rarybereki. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ibutumy adeereny warybe rewahinyre, Kia Deuxu taijoimy remyremy mahãdu wahe. Ruxetòena, ywina‑wana adeereny‑ò kanakemy watxireri, Deuxu inytyby‑ribi tule Jesuisi Kristu iny wedu‑ribi. Tii dori adeereny irybe riwahinyreki. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Umyreny Deuxu‑ò reàlàmahãre, atyhynareny‑ò iny ibutumy roholamyhỹreki. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Deuxu‑ò rexitòenymahãreu, anirenymy rarybehyymy watxiwãhãre. Kia heka Deuxu rieryre, waworibityhy tahe jiarỹ Deuxu deòdumy rare. Iriòre Rybewihikỹ‑di wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Jiarỹ rexitòenyhyy watxiwãhãre arorarenymy arakemy Deuxudeewikeki. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Umyreny arobikemy watxireri, tai adeereny arelyykemy aõmydỹỹ wihikỹõ Deuxu Tyytybytyhy. Tule kaiboho wadee tuu belyybenykre. Tai tahe atyhynareny‑ki ityhymy relekre. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Jiarỹ arawiòhenanykemy watxireri, tule kai biwawiòhenanykemy watxireri. Tai rikexideysanytyhykemy inatyhyna‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Sõwemy heka arahyykemy watxiwãhãre arorarenymy. Iribi nohõti losaõmy tahe wadi rarurunymyhỹre aõbo, riwateònyõhyymyhỹre heka. Jiarỹ Deuxu dee waaõmysỹdỹỹna awikemy watxireri ayreny‑ki. Tai kaiboho ako‑ò boikemy wadee awire, iwese ijõ judeukõdu mahãduko‑ò ararybekremy watxireri wese. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","15","Tuheka ibutu iny‑ò ararybekremy watxireri, hãwã witxira witxira mahãdu‑ò, tule. Iny mahãdu‑ò aõkõre mahãdu‑ò tule. Tuu ariwinykre ibutumy iny‑ò, iny bedeeryrenyõ mahãdu‑ò tule. Adeereny tule Rybewihikỹmy arelyykemy watxireri Roma hãwã ludu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Jiarỹ dori Kristu Rybewihikỹ‑ki araixỹruõtyhy. Irybe dori Deuxu ruru rare. Ibutumy iny rityhynykeki ritakemy ratxikre. Judeu mahãdu‑ò juhuu nade tai tahe iuhe‑ò judeukõdu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Deuxu òbitina ratỹnynymy namyhỹde Rybewihikỹwo‑ribi. Tyhyna‑di ritelenyre tule tyhyna‑di ihỹmyhỹre. Inyõ tyhyna‑di òbitimy rỹikeki, tii ruruõtyhy, idi awimy rareki. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Deuxu yarana biu‑ribi namyhỹde ibutu òraruna hudunamy. Iwidỹỹdu hudunamy. Bina widỹỹdu dori inatyhyna ribinanymyhỹre, raruinymyhỹre Deuxu rybe ribynymyhỹre? ");
INSERT INTO kpjNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Deuxu eryna ibutumy iny‑ò riwahinyre. Deuxule tamy riwahinyre. Tai timybo Deuxu raremy tahe tiiboho rieryhyymyhỹre. Tai Deuxu aõhõkỹmy risỹnymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Juhuhukỹle heka Deuxu aõmydỹỹnanamy iny robimyhỹre idi tii tyhynamy tule rierymyhỹre itỹnyhỹkỹlemy, irurunahyy wahe. Aõu aõu kia ibutumy iny rierymyhỹre, Deuxu widỹỹnamy iny robireki wahe. Tai tiu iny ixitxiõdỹỹna. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Rieryrenyre tii Deuxumy raremy. Tahe rexiwowydynyõhyyre timybo iny Deuxu dee rexiwowydynymyhỹkemy wahe. Tamy àlànatyhy riwahinyõhyymyhỹre. Idi rõhõtinymyhỹrenyre Deuxu irayky rõhõtinymyhỹre wesemy idi rõhõtinymyhỹre. Irayky tahe reòsamy ratximahãre. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Tiibohole bedeerytyhymy ixidi rõhõtinyrenyra. Tahe itxỹtele roire. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Deuxu rubutere rityhynykenawi tahe tiiboho heka ritxoo deuxuõ ireije riwinymyhỹrenyre tatyhydỹỹnamy. Ibinamy heka mywese riwinymyhỹre, nawii wesemy, iròdu wesemy, iròdu bedemy riradu‑wesemy. Rexiòkamy riramy riradu wesemy tahe rityhynymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Deuxu heka òraruna‑ò riwahinyrenyre, itxỹtenareny òraru‑ki. Iny òta òtadu mahãdu heka wiwanale aõòta ixỹruna riwinymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Deuxu inatyhyna dori tiiboho riwiurònyra ruina‑ò. Ritxoo dee rexitòenyrenyre, aõbo Deuxu riwinyre, kia. Deuxule iny reàlàkõmyta ratximyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Deuxutyhy tahe rityhynyõhyyre, Deuxu ibutu widỹỹdu tiu riteàlànymy rakonananyõtyhy. Kia òraru‑ki òtaòtana nade. Hãwyy, hãbu‑wana aõkõ roimyhỹre wideele heka aõhebo rotỹỹnymyhỹre. Kia heka òbiti aõkõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Tule hãbu, hãwyy‑wana aõkõ rõimyhỹre, wiwanale aõhebo rotỹỹnymyhỹre. Òbiti aõkõ heka kia rare. Riwyrenykre kia òraru òwydỹỹna, aõhõkỹmy dỹỹnana wahe. Iny sohoji sohoji taaõbina ixỹruna òraru‑ki ixidee rimykre. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Tõhõti heka Deuxu‑txi reaõhyymyhỹre. Tai tahe timybo ixideewimy riwinyrenykemy roirenyre Deuxu‑ribi. Tahe riwinyrenyre ibutumy aõbina binahakỹle. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Aõimy aõko ratximyhỹre aõbina bina‑di roiremyhỹ: òtaòtana‑di, aõbina binahakỹ‑di, aõikõkõ‑di, rarekemy ixidee ririmyhỹre, teramy heka rỹira. Ihãru‑di rỹira iny rubudỹỹmy dori rõhõtinymyhỹre, rarybehyymy ratxirerimy ihỹre, ruidu nihikỹ ihỹre, ujõmo‑di rỹira. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Aõbinamy inymy rarybemyhỹre, Deuxu derare, ixiluulerenyre, rexityhynymyhỹre, òraru tỹmyra riwinyrenyre, tyby tadi‑wana rityhynyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Irybe sohoji aõkõ heka rare. Iluunaõre, ibinatyhyre, inydee iruxetòeõre. ");
INSERT INTO kpjNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Deuxu rarybere: inyõ kia riwinykeki heka ruruke. Tiiboho kia rieryrenyre. Ihãre tahe aõhebo rotỹỹnyre. Kia sohojile aõkõ. Reysarenymyhỹre iny witxira iherenyki aõhe rutỹỹnykreki. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Tutyhy‑ki aõkõramy rybeõmy. Kai dori tutyhyle òraru tewinymahãõte. Inyõ rybemy ywisidỹỹna ijõmy rarybeke‑wana ixilemy ywisidỹỹna‑ò rexityhenyke. Tii dori kia ibutumy tule riwinymyhỹre ibinamy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Inyõ kia aõbina binahakỹ riwinymyhỹkeki, Deuxu ywisidỹỹna‑ò inatyhynalemy tamy kòdòhònykre. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Kai tuleke —kiamy biwinykeki, Deuxu ywisidỹỹna‑ribi mahenyõtyhy. Kai dori ywisidỹỹdumy texideòsinyte ihãre tahe iòraru wesele tewinymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Deuxu ruxetòena sõwemy adi rexiruxetòenanymyhỹre. Kia‑di bexirãhĩkemy adi ratxireri, tiiemy ywimy aõna aõna bina riemyhỹre ratximyhỹre, awi heka adee rare. Kai aõbohe iribi õhõti rosakre kia heka arabedeòtiidỹỹnymyhỹre. Arabedewodỹỹnymyhỹre iòraru‑ki. Kai aõbohe kia teeryõte? ");
INSERT INTO kpjNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kai arybedỹỹsaeryõre rybe ijohona teeryõte õhõtiõre. Tai tahe Deuxu yarana ixideele tebutunymahãte. Ijõtxu Deuxu yarana txumykreu. Tai Deuxu ywisidỹỹdu òbiti rexitỹnynymy rỹikre. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Iny sohoji sohoji taaõna aõna myna aõmy rotỹỹnykre, aõhebo rotỹỹnymyhỹreki wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Inyõ aõwidỹỹlemy ratximyhỹre. Tiiboho heka Deuxu wowydyna, Deuxu wohyna, Deuxu loosòna widỹỹmy rarutaamyhỹrenyre. Tule iny rarehykykrena‑di rarutaamyhỹrenyre. Imyna Deuxu tamyreny riõkre. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Kia ixidile rõhõtinymyhỹre mahãdu tahe, Deuxu woxibrunale, yaranale ritakre. Tiiboho dori inatyhyna rityhynyõhyymyhỹrenyre, aõ òbitile aõkõ riwinymyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Aõhõkỹmydỹỹnana, bedewona kanakre ibutumy aõbina bina widỹỹdu mahãdu‑ò, judeu mahãdu‑ò juhuu idi judeukõdu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Wowydyna, àlàna, ywina tahe kanakre aõwiwihikỹ widỹỹdu mahãdu‑ò judeu mahãdu‑ò juhu delemy idi judeukõdu mahãdu‑ò. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Deuxu‑ò heka ibutumy iny wiwese rare. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","16","Tii heka aõhõkỹmy risỹnykre ibutumy iny òrarudu mahãdu. Moisesi bede ywina ihoõrehãrele tii rurukre. Judeukõdu mahãdu heka Moisesi bede ywina rybe ijõkõre. Tahe bede ywina iny rierykeki, idile Deuxu iòraruna riywinykre. Inyõ Deuxu bede ywina rybe roholare tahe rityhynyõre, kia tahe Deuxu dee ibinatyhyre. Ibutumy kia iny rurukre, òtỹỹ iraykywokile aõbo ibinare, aõbo òbitire rierymyhỹreki. Deuxu bede ywina wesemy heka iraykywo‑ki ratximyhỹre. Iraykywydyna rexinohõtinymyhỹre ada dexiòbitidỹỹnymyhỹde, Rybe wimy rarybemyhỹre Jesuisi Kristu heka hãbu aõmydỹỹna ritỹnynykre imyna timy rarekremy. Deuxu dori iteradỹỹdure. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kaiboho, judeu mahãdu, texinohõtinytenyta ibutumy awiremy aDeuxureny‑wana. Tii adeereny bede ywina rybe riwahinyreki, tii abiòwatyhy rareki. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Kai heka aõbo Deuxu‑ò awire teeryte. Aõbo ibinare, teeryte. Uladuule ibede ywina rybe teeryte, tai òbitityhyle adeereny awire. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Kai Deuxu‑ò nonana bitỹnynyke iny ruetà mahãdu‑ò dori, kia teerytyhytenyteki. Ixi‑di tahõtinytenyteki. Iwese, kaiboho loosòna wesemy toitemahã ixi‑di tahõtinytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Tule kia ixi‑di tahõtinymahãte. Kai bede erydỹỹdukõdu mahãdu erydỹỹdumy atxiterimy ixidi tahõtinymahãte. Uladu erydỹỹdumy atxiterimy ixi‑di tahõtinymahãte. Kai bede ywina rybe tyyritiõ dire. Kia adee ibutumy inatyhyna rare bedeerydỹỹna. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Kai iny erydỹỹdumy atximahãte. Timyrekibo kai texierynanyõmahãte. Kai wasimy aõkõ tòerydỹỹnanymyhỹte. Timyrekibo tawasinymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Kai hãwyy òta aõkõ tetỹnynymahãte. Timyrekibo kai tuu tatỹỹnymahãte. Suritxoo dee àlàna deramy iximy tarybemahãte. Aõherekibo erydỹỹ‑ribi aõmydỹỹnana tewinymahãte. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Kai bede ywina rybe luumy iximy tarybemahãte. Kai Deuxu‑di texixiwedenymyhỹte. Ihãre tahe bede ywina rybe tetyhynyõte. Kiawese Deuxu texirudỹỹnymyhỹte. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Iwese juhuu riritinyre wese wiji roimyhỹre: —Aòraru‑ki tahe bedemy iny rỹira Deuxumy aõna aõnabinamy rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kai bede ywina rybe bityhynykeki, õtyky resynadike, awire judeu mahãdu dori rare. Tahe bede ywina rybe bityhynyõkeki, õtykyresyna adee aõ aõkõre. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","27","Iwesetyhylemy iny rare tõtyky resynaõ mahãdu. Tiiboho bede ywina rybe rityhynykeki, tõtyky resyna‑di mahãdu wesemy roirekre. Judeukõdu mahãdu heka bede ywina rybe rityhynykeki, kia adee ixỹruna rare. Kaiboho dori Deuxu bede ywina rybe tetyhynyõte õtyky resyna dire hãrele. Bede ywina rybe dire hãrele. ");
INSERT INTO kpjNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","29","Inyõ judeu mahãdu wesemy ihỹre. Ihãre tahe judeu mahãdu inatyhy aõkõ rare. Tõtyky resyna‑di judeu mahãdu inatyhy aõkõ rỹira. Judeu mahãdu inatyhy tawokihyyle kia idi rỹira. Iwesele notyky resynadỹỹna kia rỹira. Inywokihyyle rare. Aõ bede ywina rybekile aõkõ tuu rỹire inyrayky wydynadile kiawesemy inyõ rỹira. Hãbu‑ribi wowydynamy ritaõtyhy. Deuxu ribile ritake. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Tibohe judeu mahãdu deewinare. Notyy resynale tamywina. Kia aõbo ibuturatyre awire judeu mahãdumy rareki? ");
INSERT INTO kpjNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Inatyhy rare, sõwemy, Deuxu dori tamy juhu Ritidỹỹna riwahinyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Inyõ rityhynyõre‑wana kia riwiurònyõhyymyhỹre Deuxu heka òbiti rare. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Inatyhy urenanamy Deuxu raremyhỹ. Iny mahãdu tahe roidumy rỹiramyhỹ. Iwese ritina‑ki roire wese Deuxumy rarybereri: —Kai arybe òbitina‑di atximahãte urenana wahe. Inyõ araurihikeki, kai inatyhyna‑di biòlòdỹỹnykre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Inyboho òbiti aõkõ roire. Kia tahe Deuxu òbitina riteòsinyre. Timykibo Deuxu inydee aõhõkỹmydỹỹnana riwahinykre. Mobo heka kia òbitimy aõkõ rarybekre. Jiarỹ hãbu rayky‑di wese rarybereri. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kia òbiti rare. Kiaweseõkeki timybo Deuxu bede aõhõkỹmy dỹỹnana riwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","8","Kai tarybete: —Jiarỹ raruira. Urile kia Deuxu inatyhyna reteòsinyre. Aõherekibo Deuxu aõhõkỹmy riwasynyre. Kiarybe iwitxira rybewesemy rare: —Ibinamy rakatximyhỹkeki, awihikỹ kia‑ribi ròhònykre. Aõkõre, kiamy rybedu mahãdu aõhõkỹmy dỹỹnana ritamyhỹkre. Kia riki wamy rarybere, ruimy wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Aõhe aõbohe, inyboho aõbo inywitxira‑ribi awityhyrenyre. Aõkõre. Jiarỹ reteòsinymahãre ibutumy judeu mahãdu, judeukõdu mahãdu ibutumy òrarudu roire. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kiamy Tyyriti‑ki roire: —Tiu heka inyõ òbitiõre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Inyõ heka Deuxu rieryõhyymyhỹre. Timy heka riòryõhyymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ibutumy iny rexiõnonymyhỹre Deuxu‑ribi wahe. Aõmy aõkõ tiiboho rexiwinyrenyre. Iny riuheõhyymyhỹre aõbo awiré. Sohoji aõkõ aõhebo rotỹỹnyre aõbo awiré. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ibòtòijò heka rubuwabede iraymy roimyhỹre ròwese rare. Tiiboho iny itxenadỹỹdu rare. Irybe heka hemylalatyhyju wese rare. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Aõbina binahakỹlemy heka inymy rarybemyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Iti heka teyrewe rare hãlubu txiwimy iny rubudỹỹmy tule. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Titxibo ramyhỹre‑wana heka aõbina binanale riwahinymyhỹre, aõhõkỹle ririmyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Tiiboho dori ywimyno rieryõmyhỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Deuxu lau heka ruberuõtyhymyhỹrenyre, Deuxu rityhynyõtyhy. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Bede ywina rybe heka tatyhydỹỹna mahãdu‑ò diõde. Kia tahe inyboho rieryrenyre. Tai heka iny rexitxiõnyõtyhy Deuxu‑ò. Tai heka ibutu dee aõhõkỹmy dỹỹnana‑ò riywinymy rỹikre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Bede ywina rybe‑ribi iny ibutumy rieryre ibinamy ratxireri. Inyõ heka bede ywina rybe heka rityhynyõhyyre. Tai tahe inyõ kia‑di rexitaõtyhy iywina òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Wiji tahe Deuxu òbitina ratỹnynymy ihỹre bede ywina rybe‑ribi lahitximy. Ihetxiu rybedu‑di kia ritỹnynymy ihỹre bede ywina rybe ritina‑di. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Deuxu riòbitidỹỹnyra. Ibutumy Jesuisi Kristu tyhydỹỹdu kanakre. Deuxu dee dori ibutumy bede bede ludu wiweselere. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ibutumy raòrarunymyhỹre. Deuxu òbitina tamy rauhenymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Deuxu taruxetòena‑di ibutumy riòbitidỹỹnyre Jesuisi Kristu tarasadureki. Tii iny‑ribi iòwydimy aõ rexitòenyõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Deuxu Jesuisi‑di rubuna iny òraru riixãwididỹỹnyre iòwy tii riòwynara, iny kamy rityhynykemy. Kawese‑ki Deuxu òbitina ritỹnyryra. Juhuu Deuxu iny òraruna‑ò reteheõmyhỹre aõnityhymy iywisidỹỹna direki. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Tahe wiji inyòraru‑ò retehemyhỹre riixãwididỹỹnykemy. Tai tahe tii òbitire tule Jesuisi Kristu tyhydỹỹdu òbitidỹỹdure. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Mobo Deuxu‑ò rarybekre jiarỹ awiremy? Aõkõre, inyõ rarybeõtyhy. Bede ywina rybe tetyhynyõte. Deuxu iny òbiti widỹỹdure, ibede ywina ywidỹỹ aõkõre. Inatyhynadile awityhymy iny rare. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kiamy tahe raraykynyre iny ityhynadile riòbitidỹỹnyke bede ywina rybe ywidỹỹ aõbo? Aõkõre! ");
INSERT INTO kpjNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Deuxu aõbo, judeu mahãdu Deuxu sohojile rare? Aõkõre, judeukõdu mahãdu‑ò tule Deuxu ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Deuxu sohojile rare. Iny wiwanale riòbitidỹỹnykre judeu mahãdu judeukõdu mahãdu‑wana. Ibutumy ityhyna òraru‑ki riòbitidỹỹnyke. ");
INSERT INTO kpjNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ityhyna aõbo bede ywina rybe riixãwididỹỹnyra? Aõkõre, bede ywina ihãre rỹire. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Timybo ararybekre inytybyreny Abraõmy. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Aõbo riwinyre aõkõ idi rexiòbitidỹỹnyre. Tai tahe rexityhynyke inyko‑ò. Tahe Deuxuko‑ò aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kamy heka Ritidỹỹna‑ki roire: —Abraõ heka Deuxu rityhynyre taile tahe rexiòbitidỹỹnyre. Deuxu dee tii òbitityhy rare tii rityhynyrekile. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Iny aõmysỹdỹỹdu raòwymyhỹke iaõmysỹdỹỹna myna. Urimy aõkõ dori raòwymyhỹre taaõmysỹdỹỹnaòwyle dori ritamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Inyõ rityhynymyhỹkeki, tii òbitina ritamyhỹre Deuxu‑ribi. Deuxu dori òrarudu mahãdu òbitina widỹỹdu rare. Kia uriõno rare. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Davi heka juhuu riritinyre iwese teysatyhymy iny rarekremy wahe. Deuxu dori òbiti mahãdu dee riraykydỹỹnyre òbitimy roirekemy. Tii ixidee aõ riwinyõre. Davi kiawese riritinyre: ");
INSERT INTO kpjNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","—Teysatyhymy iny rỹirakemy Deuxu iòraru riixãwididỹỹnyreu tõhõti‑ribi iòraru rosakeu. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Teysatyhymy iny rỹirakemy iòraru‑txi Inynyrỹ nohõti ijeraõmy ihỹkre. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Deysana aõbo judeu mahãdu sohojile riteysanymyhỹre ida judeukõdu mahãdu tule. Tulere! Inyboho dori rarybere: —Abraõ tyhynale tamy òbitina diwahinymyhỹde. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Tiubo tahe Abraõ òbitina ritare notyky resynako‑ki ada ihewo‑ki aõbo, ikoure. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Juhuu dori rityhynyre idi ta notyky resyna tamy nade kia tyhyna Deuxu‑ò riteòsinyreki. Tai tule òbitina Deuxu tamy riwahinyre. Kia butu tyhydỹỹdu tyby wese rare, Judeukõ mahãdu wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Notyky resynako‑ki òbitina ritare. Tõtyky resyna‑di mahãdu tyby wesemy riki Abraõ ratximyhỹre. Tiile tõtyky resynakõ‑ki Deuxu rityhynytyhymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Deuxu Abraõ‑ò rarybere tii ibutu bede bede wedu wesemy ratximyhỹre iriòre iribi rimykemy. Tahe bede ywina rybe òraru‑ki aõkõ tuu ihỹre, ityhyna òbitina òrarukile wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Bede ywina rybe‑ribi tybie tahe itarasadumy ratxikre, tai tahe inatyhyna aõ aõkõ rare. Aõbo Deuxu rarybere aõmy aõkõ rare. Tahe roirekre. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Bede ywina rybe dori Deuxu aõhõkỹmy dỹỹnana diõde iny ribedeerynykemy. Teysana aõkõ wahe. Bede ywina rybekõki, timyki iny aõ ityhynyõna. Bede ywina rybe ijõõre‑wana òraruna ijõõre. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Tahe inatyhyna‑di sohojile iny aõna aõna wiwihikỹ ritamyhỹke. Tai iruxetòena‑ribi nade. Tahe aõmybo Deuxu rarybere ibutu riòreriòremy tuu rỹikre. Bede ywina rybe mahãdu tule bede ywina rybekõdu mahãdu‑wana wiwana Deuxu rityhynyre. Abraõ riòre wesemy ibutumy tai inyboho roire. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Iwese Ritina‑ki roire wese: —Jiarỹ aratare ibutu inytyby wesemy mabekemy. Ibutumy iny rityhynyre‑wana, iwese Abraõ rityhynyre wese, iwese‑ki Deuxu ritake. Deuxu tahe rubu mahãdu riixixanymyhỹre rubu‑ribi. Tii rarybekeu aõ aõkõ aõwesele tii aõ heka rare. Tii rarybere tule riwinyre. Abraõ heka Deuxu rybe rityhynyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Timy heka rariòrenykemy ixidee rõhõtinyõhyymyhỹre. Deuxu dori tamy rarybere: —Kai heka ariòkòrereny sõwemy atximyhỹkre. Kai hãwã hãwã tybymy mabekre. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abraõ tatyhyna ritxiõnyõhyyre. Timy heka 100 beòramy idi ratximyhỹre, ixãwire uladu‑ribi ramatuarinyreki. Tule ihãwyy Sara iuladu herina‑di kõremy rõhõtinyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Timy heka ritxiõnyõhyyre Deuxu Rybe. Rityhynymyhỹre Deuxu deàlàna riwowydynyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Tii heka rierymyhỹre Deuxu irurudire irybe wesemy aõ rỹikemy. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Tai tahe Deuxu tamy òbitina tamy diwahinyde. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Aõ iòraruki aõkõ kia ryberitina awimy raeryre, tamy sohojile aõkõ dori rarybere. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Iny òraru‑ki tule kia tuu roire. Iny tule inatyhyna‑di òbitina ritakre. Inyboho dori rityhynymyhỹre, Inynyrỹ Jesuisi rubu‑ribi ixixana widỹỹdu Deuxu raremy. ");
INSERT INTO kpjNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jesuisi iòludu‑ò iwahidỹỹmy rara inyòrarureny‑ki tai rurure. Tahe iny òbitina wahidỹỹna‑ò diixixanyde rubu‑ribi. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Jesuisi tyhydỹỹ òraru‑ki Deuxu inyboho rimyrenyre. Idi awimy rokoirekremy tii‑wana, Jesuisi Kristu‑wana wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Deuxu ruxetòenawo‑ki inyboho rotamanymyhỹrenyre. Jesuisi Kristu tyhydỹỹna òraru‑ki tamy rotamanymyhỹre. Deuxu loosòna worojuxanaõ‑di rokoirekre. Tai inyboho reysamy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Inyboho bedewona‑di hyy ihỹrenyre. Ihãrele tahe inyboho teysarenyre. Kia dori iny riwiòhenynymyhỹre raròsòna ijõdikemy ruru inydeereny riwahinykemy. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Inyboho rikiijerenyhyykeki, Deuxudeewimy rikiwinyrenyke. Deuxudeewina rikiwinyrenykeki, raròsòna rikitarenykre. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Iny raròsòna tarasana aõkõkeki, uritere rakabedewoõtyhy, Deuxuluuna dori inywo‑ki ratxireri. Deuxu Tyytybytyhymy inydeereny wahidỹỹna rare. Tii dori inyworeny‑ki Deuxuluuna ritidire. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Iruruõmy inyboho roiremyhỹre awimy riwinykemy. Tai tahe Kristu inydeereny, inyboho ibinare hãre rurure, Deuxudeewireu. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Isirare inyõ hãbu òbiti dee ruruke. Tahe hãbu wiwihikỹ dee òsana iny rurukre, kia heka irutaõre. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Deuxu tahe luunatyhy inydeereny diteònyde. Iny òrarudurenyre hãre, Kristu inykireny rurure. Juhuu heka inyboho òrarudu roire. Ihãrele Deuxu taluuna nihikỹ inydeereny diteòsinyde. Tai heka Kristu inyòrarureny‑ki rurure. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Irubuna òraru‑ki heka Deuxuru‑ò inyboho òbitimy ihỹrenyre. Irubuna tahe kia riwinyreki irumy inonana tahe iratyre rarekre inydeereny wahe. Deuxu ykarana‑ribi Kristu dori iny ritamyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Juhuu Deuxu òludu inyboho roire. Tahe wiji ibiòwamy inyboho roire, iriòre iny òrarureny‑ki rurureki, wahe. Wiji tahe rybe òludu mahãdu‑ribi wiutàdànamy rỹire. Ibutu kia heka Kristu òraru‑ki sohojile ture. Tai iny teysamy roire Deuxu rityhynyreki. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Inyboho heka iwitxira Deuxu‑wana ratximyhỹrenyre. Tai tahe reysamy ratximyhỹre. Inyboho Deuxu biòwamy ratximyhỹrenyre. Jesuisi Kristu Inynyrỹ òraru‑ki heka ture. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Hãbu sohoji òraru‑ki òraruna bede‑ki ralore juhuu, Adaõ òraru‑ki wahe. Taile tahe rubu nade bede‑ki. Idi ibutumy iny raòrarunyre. Adaõ òraruna‑txi resereu, rubu ibutumy iny‑ò resere. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","14","Juhuu Adaõ rurure. Iribi tahe ibutumy iny rurure. Moisesi tule rurure. Tahe bede ywina òraru‑ki aõkõ tiiboho rurure. Bede ywina dori Adaõ rubu hewo‑ò Deuxu riwahinyre Moisesi‑ò. Deuxu heka iny òrarunamy aõkõ rõhõtinyre, tabede ywina dori kiau riwahinyõre. Adaõ heka Deuxu rybe rityhynyõre, tai tahe rurure iwese Deuxu rarybere wese. Tule iòraruna òraru‑ki ibutumy iny raòrarunymyhỹrenyre. Adaõ heka Jesuisi‑ò rakewesenanykre. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Tiiboho wiwanale aõ kabede‑ò aõ diwymyhỹdenyde. Adaõ heka rubu diwyde. Jesuisi heka runa diwyde. Adaõ heka sõwemy iny‑ò rubu riwahinyre. Jesuisi tahe sõwetyhy‑ò Deuxu ruxetòena riwahinyre, tarasana tamyreny riwahinyre. Òraruna sohoji‑di heka Adaõ rubu riwahinyre ibutu iny‑ò. Jesuisi tahe ibutumy iny‑ò biu‑ò hena riwahinykemy ratxireri iòraruna sõwere hãrele. Umytuedeõna wahidỹỹdu tii ratxireri. Kia awityhyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","17","Inatyhymy Adaõ widỹỹna ibinare. Jesuisi widỹỹna heka awityhymy rare inydeereny. Inyboho dori Jesuisi‑wana irumy ratxirenyre aõu aõu kowa bede wihikỹ‑ki, Deuxu òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Aõhõkỹmy dỹỹnana heka Adaõ widỹỹna diwyde ibutumy iny‑ò. Jesuisi tahe òbitina diwyde ibutumy inydeereny. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Adaõ heka Deuxu rybe rityhynyõre. Tai iny sõwemy òraruna‑txi resere. Jesuisi tahe Deuxu rybe rityhynyre. Tai iny sõwemy heka òraruna‑ribi ritare. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Deuxu tabede ywina rybe riwahinyre. Tai tahe iny aõbina rierymyhỹre. Òraruna‑di sõwemy ihỹreki, tai Deuxu ruxetòena sõwetyhymy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Juhuu òraruna ratximyhỹre iny umyreny‑ki. Inydeereny rubule riwahinyrenyre. Wijile tahe Deuxu ruxetòena riwahinyre inyumyreny‑ò, inyraykyreny‑ò. Òbitina inydeereny riwahinyre Deuxuko‑txi. Jesuisi Kristu Inynyrỹ òraru‑ki heka, umytuedeõna inyboho ijõdire. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Timykibo Deuxu inydireny rexiruxetòenykeu watxireri Deuxu ire inydireny raruxetòenykemy ire rexiòrarunanymyhỹre hãrele. Timyki tuuõna. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Aõkõhyyre. Inyboho heka òraruna dee rubumy ihỹrenyre. Timykibo iny ihyymy òraruna‑txi rekeseke? Aõkõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Jesuisi Kristuni‑ki inyboho raratisebenyreu, Tule Jesuisi rubu‑my ratisebe‑ò rururenyre. Kia teerytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Tiu inyboho risebenyre Jesuisi òraru‑ki, tii‑wana inyboho rurure. Tai iru tỹmyra‑di inyboho ihyre. Iwese Deuxu taruru‑di Jesuisi riixixadỹỹnyre wese tule inyboho iru tymyra‑di rokoireke. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Iwese tii rurure wese, inyboho tule rukurenykre òraruna dee. Iwese Kristu rexixadỹỹnyhe wese inyboho tule òraru‑ribi ixãwira tii‑wana rarehyykremy. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Iny umy tyby tule rurure Kristu itxeò‑ki. Tai inyboho heka òraruna deòdumy aõkõ ihỹrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Inyõ rurukreu, tii òraruna‑ribi ixãwimy ihỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Inyboho Kristu‑wana rurukeki, tii Kristu‑wana irumy ratxikre. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kristu rexixare tii ixyby ruruõtyhy. Rubu ixyby tamy reaõtyhy. Kia tahe inyboho rieryrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Jesuisi rurureu, iny òraruna ixãwina rubulemy rurure. Wiji tahe irumy ihỹre Deuxudeehyy. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Tule kai arumy atximahãte Deuxu dee iny aõbina bina‑ò taruteki rubuwesemy arumy tahe Deuxu‑ò. Inynyrỹreny Jesuisi Kristu tyhydỹỹki. Kiawesele mohõtinyke Deuxu dee, Jesuisi Kristu dee wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kaiboho dori Jesuisi Kristu‑wana atximahãtenyte. Òraruna‑txi ixyby besekeõtyhy. Ixideewimy aõkõ rikiwinyrenyke, aõ ibina wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Aumyreny biwahinybenyke Deuxu‑ò iwese iny iru tỹmyra‑di ihỹrenyre. Tai tahe òbitile biwinybenyke, òraruna‑txi beseõtyhy aõ iyja aõkõ. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Òraruna rybe‑ò ijohorenyõmy. Tii dori awedu aõkõ rare. Deuxu ruxetòena‑ò bexiweloromahãbenyke. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Aõbo tahe awityhyre. Ruxetòena òraru‑ki aõbo rekexiòrarunymyhỹke. Aõkõhyyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Òraruna rybe‑ò heka bityhynybenykeki, òraruna deòdumy atxibenyke, rubu iòwy rare wahe. Deuxu rybe‑ò tahe bityhynybenykeki, òbitimy boibenyke. Bexideòdunybenyõtyhyke òraruna bityhynybenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Wowydyna Deuxu‑ò kanakemy watxireri. Juhuu kaiboho òraruna deòdumy ahãtenyte. Tahe wiji inatyhyna erydỹỹna tetyhynytyhytenyte. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Wiji tahe kaiboho òbitina deòdumy atxitenyte. Tahe Deuxu deòdumy wiji toite, tii ixideewimy timybo adirenykre. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Iwese juhuu òrarunawidỹỹna‑ò texiwahinymahãte wese, wiji bexiwahinybenyke Deuxu‑ò, òbitiwidỹỹna‑ò wahe. Òbitimy rarybemahãre, itỹnytyhy kaiboho dori õhõtitymy toite aiximynatyhyrenyõ òraru‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Òraruna deòdumy atxitenyteu, Deuxu tetyhynyõtenyte. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Kia aõmydỹỹnana wiji ixãruna adeereny rare. Aõbo tahe awimy juhuu tewinytenyte. Kia heka rubule riwahinymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Òraruna‑ribi ixinamy atxitenyte. Kaiboho Deuxu‑ò ibutumy texiwahinyte. Tai umytuedeõna tetatenyte. ");
INSERT INTO kpjNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Òraruna òwy heka rubu rare. Inyõ òraruna riwinykeki, tii ruruke, kia òraruna òwy rare. Deuxu wahidỹỹna tahe umytuedeõna rare, Jesuisi Inynyrỹ rurureki wahe. Idi tiile‑wana tukre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Waityhydỹỹdu seriòre, kaiboho bede ywinamy teerytenyte. Tai bieryke aõmybo ararybekre. Inyõ irulemy rariakekile, bede ywina tamy aõ rare. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Arawesenanykre. Hãwyy heka ihãbu‑wana ihyymy ihỹre bede ywina myna. Hãbu rurukeki, tahe ixinamy ihỹre ijõ‑wana roikremy. Hãbu ruruõkeki tahe, ixinamy aõkõ ihỹre, ijõ‑wana roikremy. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Inyõ‑wana roikeki, hãwyy wedenamy raninikre. Ihãbu rurukeki, tii ixinamy rarekre. Ijõ‑wana roike. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Kia wese rare, waseriòreboho, ayreny‑ki. Kaiboho bede ywina dee tarutenyte. Kaiboho dori ityhydỹỹdu mahãdu atximahãtenyte. Kaiboho Deuxu hõrõ mahãdu atximahãtenyte. Rubu‑ribi ixixadu mahãdu atximahãtenyte, Deuxudeewina biwinybenykemy. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Juhuu ixideewile aõ tewinymyhỹtenyte, rubu aõmydỹỹnana wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Wijile tahe bede ywina‑ribi ixinamy inyboho roimyhỹrenyre. Iwese ihetxiu tyyriti bede ywina rityhynymy aõkõ ihỹreny, wiji Deuxu Tyytybytyhy aõmydỹỹnana inyboho rityhynyrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Timybo? Bede ywina aõbo ibinamy rare. Aõkõre. Ihoõkeki tahe òraruna jiarỹ arieryõtyhy. Bede ywina rarybere wasiõmy. Kiale reeryre aõbo wasimy rare, inyõ aõ arimykemy watxireriu, kia òraruna wasiweselemy rare. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Timyki, jiarỹ òraruna waerysyõna bede ywina tuu rarybekõkeki. Bede ywina dori aõbina binamy riwabedeerynyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Jiarỹ juhuu bede ywina reeryõre. Reeryre tahe aõmydỹỹnana binale wadee rarerenyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Deuxu heka bede ywina riwahinyre juhuu. Tamy ruru riwahinyre bede ywina wahe. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Tahe bede ywina òraru‑ki heka òraruna riwahinymy. Tai tahe õnosõna riwarubunyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Kia bede ywina tahe awi rare, òbiti rare. Õnosõna awi rare. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Timybo rare. Òbitina aõbohe riwarubunyre. Aõkõre. Òraruna tiire. Tii tahe ibinatyhy rare. Bede ywina òraru‑ki iny kia òraruna ibinatyhy reeryrenyre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Bede ywina heka Deuxu Tyytybytyhy aõmydỹỹnana rare. Jiarỹ heka inyle rare, òraruna heka wawedu rare. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Aõbo warayky dee ibinarele, kiale rewinywãhãre. Aõbo awimy warayky dee rare, kia rewinyõhyyre. Aõherekibo? Reeryõre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Rexierymyhỹre aõbo rewinymyhỹre. Reeryre kaa bede ywina awi rare. Tai heka rabedewomy watxiwãhãre. Jiarỹ dori bede ywina bede ywina riti reerymy watxiwãhãre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Retxiõnymy watxiwãhãre. Waruruõhyy heka watxiwãhãre. Aõwi ariwinykeò. Òraru heka iòhòmy waribi ratximyhỹre waruru ratyre ratximyhỹre waribi. Tai heka òraru rewinymahãre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Waumy ehetxina tahe ibinatyhy rare. Aõbo awi rare heka ariwinykemy rewisỹnywãhãre ta heka rewinyõhyywãhãre. Aõwi rewinyõhyymahãre! ");
INSERT INTO kpjNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Jiarỹ rarurunymahãre heka aõbina ariwinykõkemy. Tahe ihãrele heka rewinymahãre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Reeryrehe aõhebo ratỹỹnymyhỹre. Jiarỹ ixiòrarudỹỹ waòraruna wadi raitxỹteitxỹtenymyhỹre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Deuxudeewimy heka ariwinykemy watxiwãhãre. Tahe araòrarunyhyymahãre. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Waumytỹmyra rarurunytyhymahãre Deuxudeewi widỹỹna ariwinyke. Awityhy rare wadee. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ijõ tahe waumywo‑ki, waraykywo‑ki, ratximyhỹre, waumyehetxina waki ratximyhỹre. Wadi rarurunymyhỹre riwamymy ratximyhỹre. Aõbina widỹỹmy heka wadi rimymy ratximyhỹre. Reòludunyõhyymyhỹre waraykymy heka rahaỹnanymyhỹre. Aõwesele heka tuu rahaỹnanymyhỹre, riòludunyõmyhỹreki wahe. Raraykynymahãre warayky‑ki, Deuxudeewimy watxikemy. Tule tahe reerymahãre òraruna deòduõ jiarỹ rare wahe. Waumytỹmyra tahe wadee rarybemyhỹre òbitimy aõmydỹỹnana ariwinykemy. Waumyehetxina tahe kialemy wadee rarybemyhỹre —òraru ariwinykelemy. ");
INSERT INTO kpjNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","25","Tai heka urile warayky raleileinymyhỹ. Mobo riwatake waumyehetxina bina bina aõmydỹỹnana‑ribi? Deuxudeewina‑ki, Jesuisi Kristu Inynyrỹ heka iximynamy riwatakre. Tii riwateònymy wadi rarekre. Wowydyna tamy ariwahinykre. ");
INSERT INTO kpjNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Tai heka Jesuisi Kristu tyhydỹỹdu mahãdu rubutyhy‑ò heka raõtyhy. Deuxu heka tii ritarenyke tii‑wana rarehyyke. ");
INSERT INTO kpjNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Deuxu‑ò Tyytybytyhy dori warurutymyra‑di riwarurudỹỹnytyhyre. Rubu‑ribi dori Jesuisi Kristu riwatare ixinamy ararekemy. ");
INSERT INTO kpjNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Inyboho heka Deuxu Bede Ywina rieryrenyre, Moisesi tyyritina wahe. Tii heka iny òraruna‑ribi iny ixinamy ririradỹỹnymyhỹre. Jesuisi Kristule, aõbo, òraruna ruru rahumyhỹre. Aõma rakahurenyõtyhy heka iny rururenydi aõma òraruna ixitawo‑di. Rikityhynyrenyõtyhy heka aõma ixitawo‑di aõbo bede ywina Tahe Deuxu tariòre diteònyde iny umyrenywesemy wahe. Tiu heka iòrarunaõhyyre. Tai heka rexiwahinyre iny òrarureny‑ki. ");
INSERT INTO kpjNT_vpl VALUES ("RM8_4","075_8_4","R