/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class SearchingCanvas
extends Canvas
implements CommandListener,
Runnable {
    private static final int EXTRA_DISPLAY_CHARS = 10;
    private static final int MAX_RESULTS = 200;
    private GoBible goBible;
    private boolean stop;
    private int currentChapter;
    private int currentBook;
    private int searchFromBookIndex;
    private int searchToBookIndex;
    private String searchString;

    public SearchingCanvas(GoBible goBible, int fromBookIndex, int toBookIndex, String searchString) {
        this.goBible = goBible;
        goBible.searchResults.removeAllElements();
        goBible.lastSearchIndex = 0;
        this.searchFromBookIndex = fromBookIndex;
        this.searchToBookIndex = toBookIndex;
        this.searchString = searchString;
        this.addCommand(new Command(GoBible.getString("UI-Stop"), 6, 0));
        this.setCommandListener(this);
        this.currentBook = fromBookIndex;
        this.currentChapter = 0;
        new Thread(this).start();
    }

    public void commandAction(Command command, Displayable display) {
        switch (command.getCommandType()) {
            case 6: {
                this.stop = true;
                this.goBible.display.setCurrent((Displayable)new SearchResultsList(this.goBible, this.goBible.searchResults));
            }
        }
    }

    public void run() {
        char[] searchData = this.searchString.toLowerCase().toCharArray();
        int endBook = this.searchToBookIndex;
        int numberOfBooks = this.goBible.bibleSource.getNumberOfBooks();
        int numberFound = 0;
        for (int bookIndex = this.currentBook; bookIndex != endBook + 1 && !this.stop && numberFound < 200; ++bookIndex) {
            if (bookIndex >= numberOfBooks) {
                bookIndex = 0;
            }
            this.currentBook = bookIndex;
            this.currentChapter = 0;
            this.repaint();
            int endChapter = this.goBible.bibleSource.getNumberOfChapters(this.currentBook) - 1;
            while (this.currentChapter <= endChapter && !this.stop && numberFound < 200) {
                try {
                    char[] verseData = this.goBible.bibleSource.getChapter(this.currentBook, this.currentChapter);
                    int[] verseIndex = this.goBible.bibleSource.getChapterIndex(this.currentBook, this.currentChapter);
                    int numberOfVerses = this.goBible.bibleSource.getNumberOfVerses(this.currentBook, this.currentChapter);
                    int index = 0;
                    int end = this.goBible.bibleSource.getVerseDataSize();
                    for (int currentVerse = 0; currentVerse < numberOfVerses && index >= 0 && !this.stop && numberFound < 200; ++currentVerse) {
                        int afterIndex;
                        boolean containedInVerse;
                        int verseStart = verseIndex[currentVerse << 1];
                        int verseEnd = verseIndex[(currentVerse << 1) + 1];
                        if (index < verseStart || index == 0) {
                            index = SearchingCanvas.find(verseData, verseStart, end, searchData);
                        }
                        if (index < 0) continue;
                        boolean bl = containedInVerse = index >= verseStart && index + searchData.length - 1 < verseEnd;
                        if ((!this.goBible.searchCanSpanMultipleVerses || index >= verseEnd) && (this.goBible.searchCanSpanMultipleVerses || !containedInVerse)) continue;
                        int extraCharsBefore = index - verseStart - 10;
                        int extraCharsAfter = verseEnd - (index + searchData.length + 10);
                        int beforeIndex = extraCharsBefore >= 0 ? index - 10 : verseStart;
                        int n = afterIndex = extraCharsAfter >= 0 ? index + searchData.length + 10 : verseEnd;
                        if (extraCharsAfter < 0 && beforeIndex > verseStart) {
                            int n2 = beforeIndex = (beforeIndex += extraCharsAfter) < verseStart ? verseStart : beforeIndex;
                        }
                        if (extraCharsBefore < 0 && afterIndex < verseEnd) {
                            int n3 = afterIndex = (afterIndex -= extraCharsBefore) > verseEnd ? verseEnd : afterIndex;
                        }
                        if (SearchingCanvas.isLetter(verseData[beforeIndex])) {
                            while (beforeIndex > verseStart && SearchingCanvas.isLetter(verseData[beforeIndex - 1])) {
                                --beforeIndex;
                            }
                        }
                        if (SearchingCanvas.isLetter(verseData[afterIndex - 1])) {
                            while (afterIndex < verseEnd && SearchingCanvas.isLetter(verseData[afterIndex])) {
                                ++afterIndex;
                            }
                        }
                        this.goBible.searchResults.addElement(new Object[]{new Integer(this.currentBook << 16 | this.currentChapter << 8 | currentVerse), new String(verseData, beforeIndex, afterIndex - beforeIndex).replace('\u0001', ' ')});
                        ++numberFound;
                        this.repaint();
                        this.serviceRepaints();
                        index = SearchingCanvas.find(verseData, index + 1, end, searchData);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++this.currentChapter;
            }
        }
        if (this.goBible.searchResults.size() > 0) {
            this.goBible.display.setCurrent((Displayable)new SearchResultsList(this.goBible, this.goBible.searchResults));
        } else {
            this.goBible.bibleCanvas.enterLoadingMode();
            this.goBible.display.setCurrent((Displayable)this.goBible.bibleCanvas);
            this.goBible.bibleCanvas.repaint();
            this.goBible.loadCurrentChapter();
            this.goBible.showMainScreen();
        }
    }

    private static final boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static final int find(char[] data, int offset, int end, char[] searchData) {
        int result = -1;
        int searchStringLength = searchData.length;
        int totalEnd = end - searchStringLength;
        int lowerDiff = 32;
        for (int i = offset; i <= totalEnd && result == -1; ++i) {
            if (data[i] == '\u0001') continue;
            char currentChar = data[i];
            if (currentChar >= 'A' && currentChar <= 'Z') {
                currentChar = (char)(currentChar + lowerDiff);
            }
            if (currentChar != searchData[0]) continue;
            boolean matches = true;
            for (int j = 1; j < searchStringLength && matches; ++j) {
                if (data[i + j] == '\u0001') continue;
                currentChar = data[i + j];
                if (currentChar >= 'A' && currentChar <= 'Z') {
                    currentChar = (char)(currentChar + lowerDiff);
                }
                if (currentChar == searchData[j]) continue;
                matches = false;
            }
            if (!matches) continue;
            result = i;
        }
        return result;
    }

    public void paint(Graphics g) {
        int width = this.getWidth();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, width, this.getHeight());
        Font font = Font.getFont((int)0, (int)1, (int)0);
        g.setFont(font);
        g.setColor(0);
        int halfWidth = width >> 1;
        g.drawString(GoBible.getString("UI-Searching") + ":", halfWidth, 20, 17);
        String bookName = this.goBible.bibleSource.getBookName(this.currentBook);
        int bookNameWidth = font.stringWidth(bookName);
        int totalWidth = font.stringWidth(bookName);
        int startX = width - totalWidth >> 1;
        BibleCanvas.drawString(g, bookName, startX, 40, 20);
        g.drawString(GoBible.getString("UI-Found") + " " + this.goBible.searchResults.size(), halfWidth, 60, 17);
        g.drawString(GoBible.getString("UI-Please-Wait") + "...", halfWidth, 80, 17);
    }
}

