/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;

public class PrefsForm
extends Form
implements CommandListener,
ItemCommandListener {
    private GoBible goBible;
    private ChoiceGroup fontSizeChoice;
    private ChoiceGroup fontStyleChoice;
    private ChoiceGroup fullScreenChoice;
    private ChoiceGroup themeChoice;
    private ChoiceGroup reverseColoursChoice;
    private ChoiceGroup reverseCharactersChoice;
    private ColourItem[] themeItems = new ColourItem[]{new ColourItem(0, GoBible.getString("UI-Theme-Paper"), GoBible.THEME_TEXT_COLOUR[0], GoBible.THEME_BACK_COLOUR[0]), new ColourItem(1, GoBible.getString("UI-Theme-Computer"), GoBible.THEME_TEXT_COLOUR[1], GoBible.THEME_BACK_COLOUR[1]), new ColourItem(2, GoBible.getString("UI-Theme-Floral"), GoBible.THEME_TEXT_COLOUR[2], GoBible.THEME_BACK_COLOUR[2]), new ColourItem(3, GoBible.getString("UI-Theme-Natural"), GoBible.THEME_TEXT_COLOUR[3], GoBible.THEME_BACK_COLOUR[3]), new ColourItem(4, GoBible.getString("UI-Theme-Blue"), GoBible.THEME_TEXT_COLOUR[4], GoBible.THEME_BACK_COLOUR[4]), new ColourItem(5, GoBible.getString("UI-Theme-Sunshine"), GoBible.THEME_TEXT_COLOUR[5], GoBible.THEME_BACK_COLOUR[5])};
    private ColourItem themeItem;
    private Command saveCommand = new Command(GoBible.getString("UI-Save"), 4, 0);
    private Command cancelCommand = new Command(GoBible.getString("UI-Cancel"), 3, 0);
    private Command selectCommand = new Command(GoBible.getString("UI-Select"), 8, 0);
    Form themeForm;

    public PrefsForm(GoBible goBible) {
        super(GoBible.getString("UI-Preferences"));
        this.goBible = goBible;
        this.append((Item)new StringItem(GoBible.getString("UI-Theme") + ":", null));
        ColourItem storedThemeItem = this.themeItems[goBible.theme];
        this.themeItem = new ColourItem(storedThemeItem.id, storedThemeItem.text, storedThemeItem.textColour, storedThemeItem.backColour);
        this.themeItem.addCommand(new Command(GoBible.getString("UI-Change"), 8, 0));
        this.themeItem.setItemCommandListener(this);
        this.append((Item)this.themeItem);
        for (int i = 0; i < this.themeItems.length; ++i) {
            this.themeItems[i].addCommand(this.selectCommand);
            this.themeItems[i].setItemCommandListener(this);
        }
        this.fontSizeChoice = new ChoiceGroup(GoBible.getString("UI-Font-Size") + ":", 1, new String[]{GoBible.getString("UI-Small"), GoBible.getString("UI-Medium"), GoBible.getString("UI-Large")}, null);
        this.fontSizeChoice.setFont(0, Font.getFont((int)0, (int)0, (int)8));
        this.fontSizeChoice.setFont(1, Font.getFont((int)0, (int)0, (int)0));
        this.fontSizeChoice.setFont(2, Font.getFont((int)0, (int)0, (int)16));
        this.fontSizeChoice.setSelectedIndex(goBible.fontSize, true);
        this.append((Item)this.fontSizeChoice);
        this.fontStyleChoice = new ChoiceGroup(GoBible.getString("UI-Font-Style") + ":", 1, new String[]{GoBible.getString("UI-Plain"), GoBible.getString("UI-Bold")}, null);
        this.fontStyleChoice.setFont(0, Font.getFont((int)0, (int)0, (int)0));
        this.fontStyleChoice.setFont(1, Font.getFont((int)0, (int)1, (int)0));
        this.fontStyleChoice.setSelectedIndex(goBible.fontStyle, true);
        this.append((Item)this.fontStyleChoice);
        this.fullScreenChoice = new ChoiceGroup(GoBible.getString("UI-Full-Screen") + ":", 1, new String[]{GoBible.getString("UI-On"), GoBible.getString("UI-Off")}, null);
        this.fullScreenChoice.setSelectedIndex(goBible.fullScreen ? 0 : 1, true);
        this.append((Item)this.fullScreenChoice);
        this.reverseColoursChoice = new ChoiceGroup(GoBible.getString("UI-Reverse-Colours") + ":", 1, new String[]{GoBible.getString("UI-On"), GoBible.getString("UI-Off")}, null);
        this.reverseColoursChoice.setSelectedIndex(goBible.reverseColours ? 0 : 1, true);
        this.append((Item)this.reverseColoursChoice);
        this.reverseCharactersChoice = new ChoiceGroup(GoBible.getString("UI-Reverse-Characters") + ":", 1, new String[]{GoBible.getString("UI-On"), GoBible.getString("UI-Off")}, null);
        BibleCanvas cfr_ignored_0 = goBible.bibleCanvas;
        this.reverseCharactersChoice.setSelectedIndex(BibleCanvas.reverseCharacters ? 0 : 1, true);
        this.append((Item)this.reverseCharactersChoice);
        this.addCommand(this.saveCommand);
        this.addCommand(this.cancelCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable display) {
        if (display == this) {
            switch (command.getCommandType()) {
                case 4: {
                    this.goBible.fontSize = this.fontSizeChoice.getSelectedIndex();
                    this.goBible.fontStyle = this.fontStyleChoice.getSelectedIndex();
                    this.goBible.fullScreen = this.fullScreenChoice.getSelectedIndex() == 0;
                    this.goBible.theme = this.themeItem.id;
                    this.goBible.reverseColours = this.reverseColoursChoice.getSelectedIndex() == 0;
                    BibleCanvas cfr_ignored_0 = this.goBible.bibleCanvas;
                    BibleCanvas.reverseCharacters = this.reverseCharactersChoice.getSelectedIndex() == 0;
                    this.goBible.showMainScreen();
                    break;
                }
                case 2: 
                case 3: {
                    this.goBible.showMainScreen();
                }
            }
        } else if (display == this.themeForm) {
            switch (command.getCommandType()) {
                case 2: 
                case 3: {
                    this.goBible.display.setCurrent((Displayable)this);
                }
            }
        }
    }

    public void commandAction(Command command, Item item) {
        if (item == this.themeItem) {
            this.displayThemeForm();
        } else if (item instanceof ColourItem) {
            ColourItem newThemeItem = (ColourItem)item;
            this.themeItem.id = newThemeItem.id;
            this.themeItem.setText(newThemeItem.text);
            this.themeItem.textColour = newThemeItem.textColour;
            this.themeItem.backColour = newThemeItem.backColour;
            this.themeItem.notifyStateChanged();
            this.goBible.display.setCurrent((Displayable)this);
        }
    }

    private void displayThemeForm() {
        if (this.themeForm == null) {
            this.themeForm = new Form(GoBible.getString("UI-Themes"), (Item[])this.themeItems);
            this.themeForm.addCommand(this.cancelCommand);
            this.themeForm.setCommandListener((CommandListener)this);
        }
        this.goBible.display.setCurrent((Displayable)this.themeForm);
    }
}

