/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public class MultiFileBibleSource
extends BibleSource {
    private GoBible goBible;
    private int currentBookIndex = -1;
    private int currentChapterIndex = -1;
    private int numberOfBooks;
    private String[] bookNames;
    private String[] shortBookNames;
    private int[] startChapters;
    private int[] numberOfChapters;
    private int[][] numberOfVerses;
    private int[][] bookIndex;
    private char[] verseData;
    private byte[] verseBytes;
    private int verseDataSize;

    public MultiFileBibleSource(GoBible goBible) throws IOException {
        this.goBible = goBible;
        DataInputStream input = new DataInputStream(goBible.getClass().getResourceAsStream("Bible Data/Index"));
        this.numberOfBooks = input.read();
        this.bookNames = new String[this.numberOfBooks];
        this.shortBookNames = new String[this.numberOfBooks];
        this.startChapters = new int[this.numberOfBooks];
        this.numberOfChapters = new int[this.numberOfBooks];
        this.numberOfVerses = new int[this.numberOfBooks][];
        for (int bookIndex = 0; bookIndex < this.numberOfBooks; ++bookIndex) {
            int numberOfChapters;
            this.bookNames[bookIndex] = input.readUTF();
            this.shortBookNames[bookIndex] = input.readUTF();
            this.startChapters[bookIndex] = input.read();
            this.numberOfChapters[bookIndex] = numberOfChapters = input.read();
            this.numberOfVerses[bookIndex] = new int[numberOfChapters];
            for (int chapterIndex = 0; chapterIndex < numberOfChapters; ++chapterIndex) {
                this.numberOfVerses[bookIndex][chapterIndex] = input.read();
            }
        }
        input.close();
    }

    public char[] getChapter(int bookIndex, int chapterIndex) throws IOException {
        this.loadChapter(bookIndex, chapterIndex);
        return this.verseData;
    }

    public int[] getChapterIndex(int bookIndex, int chapterIndex) throws IOException {
        this.loadChapter(bookIndex, chapterIndex);
        return this.bookIndex[chapterIndex];
    }

    private void loadChapter(int bookIndex, int chapterIndex) throws IOException {
        if (this.currentBookIndex != bookIndex || this.currentChapterIndex != chapterIndex) {
            if (this.goBible.display.getCurrent() == this.goBible.bibleCanvas) {
                this.goBible.bibleCanvas.enterLoadingMode();
            }
            if (this.currentBookIndex != bookIndex) {
                this.loadBookIndex(bookIndex);
            }
            DataInputStream input = new DataInputStream(this.goBible.getClass().getResourceAsStream("Bible Data/" + this.shortBookNames[bookIndex] + "/" + this.shortBookNames[bookIndex] + " " + (chapterIndex + this.startChapters[bookIndex])));
            this.currentChapterIndex = chapterIndex;
            this.verseData = input.readUTF().toCharArray();
            this.verseDataSize = this.verseData.length;
        }
    }

    private void loadBookIndex(int bookIndex) throws IOException {
        int numberOfChapters = this.numberOfChapters[bookIndex];
        this.bookIndex = new int[numberOfChapters][];
        this.currentBookIndex = bookIndex;
        DataInputStream input = new DataInputStream(this.goBible.getClass().getResourceAsStream("Bible Data/" + this.shortBookNames[bookIndex] + "/Index"));
        for (int chapter = 0; chapter < numberOfChapters; ++chapter) {
            int numberOfVerses = 2 * this.numberOfVerses[bookIndex][chapter];
            int[] chapterIndex = new int[numberOfVerses];
            this.bookIndex[chapter] = chapterIndex;
            int offset = 0;
            int verse = 0;
            while (verse < numberOfVerses) {
                chapterIndex[verse++] = offset;
                chapterIndex[verse++] = offset += input.readUnsignedShort();
            }
        }
        input.close();
    }

    public String[] getBookNames() {
        return this.bookNames;
    }

    public String getBookName(int bookIndex) {
        return this.bookNames[bookIndex];
    }

    public int getNumberOfBooks() {
        return this.numberOfBooks;
    }

    public int getStartChapter(int bookIndex) {
        return this.startChapters[bookIndex];
    }

    public int getNumberOfChapters(int bookIndex) {
        return this.numberOfChapters[bookIndex];
    }

    public int getNumberOfVerses(int bookIndex, int chapterIndex) {
        return this.numberOfVerses[bookIndex][chapterIndex];
    }

    public int getVerseDataSize() {
        return this.verseDataSize;
    }
}

