/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class HistoryList
extends List
implements CommandListener {
    private GoBible goBible;

    public HistoryList(GoBible goBible) {
        super(GoBible.getString("UI-History"), 3);
        this.setFitPolicy(1);
        this.goBible = goBible;
        int i = goBible.historyStartIndex;
        do {
            if (goBible.historyExcerpts[i] != null && !goBible.historyExcerpts[i].equals("")) {
                int bookIndex = goBible.historyVerseIndices[i * 3] & 0xFF;
                int chapterIndex = goBible.historyVerseIndices[i * 3 + 1] & 0xFF;
                int verseIndex = goBible.historyVerseIndices[i * 3 + 2] & 0xFF;
                this.append(goBible.bibleSource.getBookName(bookIndex) + " " + goBible.bibleSource.getReferenceString(bookIndex, chapterIndex, verseIndex) + " \"" + goBible.historyExcerpts[i] + "\"", null);
            }
            if (++i < 20) continue;
            i = 0;
        } while (i != goBible.historyStartIndex);
        this.addCommand(new Command(GoBible.getString("UI-Back"), 3, 0));
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable display) {
        if (command == List.SELECT_COMMAND) {
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex != -1) {
                if ((selectedIndex += this.goBible.historyStartIndex) >= 20) {
                    selectedIndex -= 20;
                }
                this.goBible.currentBookIndex = this.goBible.historyVerseIndices[selectedIndex * 3] & 0xFF;
                this.goBible.currentChapterIndex = this.goBible.historyVerseIndices[selectedIndex * 3 + 1] & 0xFF;
                this.goBible.currentVerseIndex = this.goBible.historyVerseIndices[selectedIndex * 3 + 2] & 0xFF;
                this.goBible.bibleCanvas.enterLoadingMode();
                this.goBible.display.setCurrent((Displayable)this.goBible.bibleCanvas);
                this.goBible.loadCurrentChapter();
                this.goBible.bibleCanvas.update();
            }
        } else {
            switch (command.getCommandType()) {
                case 3: 
                case 4: {
                    this.goBible.bibleCanvas.enterLoadingMode();
                    this.goBible.display.setCurrent((Displayable)this.goBible.bibleCanvas);
                    this.goBible.bibleCanvas.repaint();
                    this.goBible.loadCurrentChapter();
                    this.goBible.showMainScreen();
                }
            }
        }
    }
}

