/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class BookmarksList
extends List
implements CommandListener {
    private GoBible goBible;
    private Command viewCommand = new Command(GoBible.getString("UI-View"), 8, 0);
    private Command backCommand = new Command(GoBible.getString("UI-Back"), 3, 0);
    private Command cancelCommand = new Command(GoBible.getString("UI-Cancel"), 3, 0);
    private Command deleteBookmarkCommand = new Command(GoBible.getString("UI-Delete-Bookmark"), 1, 0);
    private Command deleteAllBookmarksCommand = new Command(GoBible.getString("UI-Delete") + " " + GoBible.getString("UI-All"), 1, 0);
    private Command deleteCommand = new Command(GoBible.getString("UI-Delete"), 1, 0);
    private Command deleteAllCommand = new Command(GoBible.getString("UI-Delete") + " " + GoBible.getString("UI-All"), 1, 0);
    private Alert deleteAlert;
    private int indexToDelete;

    public BookmarksList(GoBible goBible) {
        super(GoBible.getString("UI-Bookmarks"), 3);
        this.setFitPolicy(1);
        this.goBible = goBible;
        Enumeration e = goBible.bookmarks.elements();
        while (e.hasMoreElements()) {
            BookmarkEntry bookmark = (BookmarkEntry)e.nextElement();
            this.append(goBible.bibleSource.getBookName(bookmark.bookIndex) + " " + goBible.bibleSource.getReferenceString(bookmark.bookIndex, bookmark.chapterIndex, bookmark.verseIndex) + " \"" + bookmark.excerpt + "\"", null);
        }
        if (!goBible.bookmarks.isEmpty()) {
            this.setSelectCommand(this.viewCommand);
            this.addCommand(this.deleteBookmarkCommand);
            if (goBible.bookmarks.size() > 1) {
                this.addCommand(this.deleteAllBookmarksCommand);
            }
        }
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable display) {
        if (display == this) {
            if (command == this.viewCommand) {
                int selectedIndex = this.getSelectedIndex();
                if (selectedIndex != -1) {
                    BookmarkEntry bookmark = (BookmarkEntry)this.goBible.bookmarks.elementAt(selectedIndex);
                    this.goBible.currentBookIndex = bookmark.bookIndex & 0xFF;
                    this.goBible.currentChapterIndex = bookmark.chapterIndex & 0xFF;
                    this.goBible.currentVerseIndex = bookmark.verseIndex & 0xFF;
                    this.goBible.bibleCanvas.enterLoadingMode();
                    this.goBible.display.setCurrent((Displayable)this.goBible.bibleCanvas);
                    this.goBible.loadCurrentChapter();
                    this.goBible.bibleCanvas.update();
                }
            } else if (command == this.deleteBookmarkCommand) {
                this.indexToDelete = this.getSelectedIndex();
                if (this.indexToDelete != -1) {
                    this.deleteAlert = new Alert(GoBible.getString("UI-Delete-Bookmark"), GoBible.getString("UI-Delete-Bookmark-Alert"), null, AlertType.CONFIRMATION);
                    this.deleteAlert.addCommand(this.cancelCommand);
                    this.deleteAlert.addCommand(this.deleteCommand);
                    this.deleteAlert.setCommandListener((CommandListener)this);
                    this.goBible.display.setCurrent(this.deleteAlert, (Displayable)this);
                }
            } else if (command == this.deleteAllBookmarksCommand) {
                this.deleteAlert = new Alert(GoBible.getString("UI-Delete-Bookmark") + " - " + GoBible.getString("UI-All"), null, null, AlertType.CONFIRMATION);
                this.deleteAlert.addCommand(this.cancelCommand);
                this.deleteAlert.addCommand(this.deleteAllCommand);
                this.deleteAlert.setCommandListener((CommandListener)this);
                this.goBible.display.setCurrent(this.deleteAlert, (Displayable)this);
            } else {
                switch (command.getCommandType()) {
                    case 2: 
                    case 3: 
                    case 4: {
                        this.goBible.bibleCanvas.enterLoadingMode();
                        this.goBible.display.setCurrent((Displayable)this.goBible.bibleCanvas);
                        this.goBible.bibleCanvas.repaint();
                        this.goBible.loadCurrentChapter();
                        this.goBible.showMainScreen();
                    }
                }
            }
        } else if (display == this.deleteAlert) {
            boolean shouldReturn = false;
            if (command == this.deleteCommand) {
                this.delete(this.indexToDelete);
                this.goBible.bookmarks.removeElementAt(this.indexToDelete);
                if (this.goBible.bookmarks.isEmpty()) {
                    shouldReturn = true;
                }
                if (this.goBible.bookmarks.size() == 1) {
                    this.removeCommand(this.deleteAllBookmarksCommand);
                }
            } else if (command == this.deleteAllCommand) {
                this.deleteAll();
                this.goBible.bookmarks.removeAllElements();
                shouldReturn = true;
            }
            if (shouldReturn) {
                this.goBible.bibleCanvas.enterLoadingMode();
                this.goBible.display.setCurrent((Displayable)this.goBible.bibleCanvas);
                this.goBible.bibleCanvas.repaint();
                this.goBible.loadCurrentChapter();
                this.goBible.showMainScreen();
                return;
            }
            this.goBible.display.setCurrent((Displayable)this);
        }
    }
}

