﻿USE sofia;
DROP TABLE IF EXISTS sofia.kpf_vpl;
CREATE TABLE kpf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kpf_vpl WRITE;
INSERT INTO kpf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","A daŋgonŋâ daŋgonŋâ muyagem gane Yesu Kristo, zâk Abaram sot Dawidi, zekât kiun muyageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaramgâren gâbâ Isaka âsageip. Isakagâren gâbâ Yakobo muyageip. Yakobogâren gâbâ Yuda sot âtâ murâpŋâ âsagiwe. ");
INSERT INTO kpf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudagâren gâbâ Perese sot Sera âsagiwet. Zekât mamzik kutŋâ Tama. Peresegâren gâbâ Hesoroŋ muyageip. Hesoroŋgâren gâbâ Ram âsageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramgâren gâbâ Aminadaba âsageip. Aminadabagâren gâbâ Nasoŋ muyageip. Nasoŋgâren gâbâ Salomoŋ âsageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salomoŋgâren gâbâ Boasi âsageip. Boasigât mamŋâ kutŋâ Rahaba. Boasigâren gâbâ Obede muyageip. Obedegât mamŋâ kutŋâ Ruti. Obedegâren gâbâ Yese âsageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesegâren gâbâ a kutâ Dawidi muyageip. A kutâ Dawidigâren gâbâ Salomo muyageip. Dawidi zâk Uriagât ambân zo mei Salomo âsageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomogâren gâbâ Rehabeam muyageip. Rehabeamgâren gâbâ Abia âsageip. Abiagâren gâbâ Asa âsageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asagâren gâbâ Yosapata muyageip. Yosapatagâren gâbâ Yoram muyageip. Yoramgâren gâbâ Usia muyageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiagâren gâbâ Yotam âsageip. Yotamgâren gâbâ Ahasi muyageip. Ahasigâren gâbâ Hisikia âsageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hisikiagâren gâbâ Manase muyageip. Manasegâren gâbâ Amon âsageip. Amongâren gâbâ Yosia muyageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiagâren gâbâ Yekonia sot âtâ murâpŋâ âsagiwe. Kâsaziŋâ Yuda a gâsum diiziŋgâm Babilonia hânân âine âsagiwe. ");
INSERT INTO kpf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Oi zoren Yekoniagâren gâbâ Salatie muyageip. Salatiegâren gâbâ Serubabe muyageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabegâren gâbâ Abidu muyageip. Abidugâren gâbâ Eliakim âsageip. Eliakimgâren gâbâ Aso muyageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asogâren gâbâ Sadoko âsageip. Sadokogâren gâbâ Akim muyageip. Akimgâren gâbâ Eliudu muyageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudugâren gâbâ Eleasa muyageip. Eleasagâren gâbâ Mataŋ muyageip. Mataŋgâren gâbâ Yakobo muyageip. ");
INSERT INTO kpf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobogâren gâbâ Yosepe âsageip. Zâk Mariagât apŋâ oip. Mariagâren gâbâ Yesu âsageip. Zâkkât kutŋâ Kristo sâmen. Kutŋâ zorat topŋâ itâ. Zâk bâliŋan gâbâ mâkâniŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Âsaâsagiŋ zo itâ âsagiwe. Abaramgâren gâbâ âsagem gane Dawidi âsageip, teŋgâziŋâ kiin kimembut uap. Oi Dawidigâren gâbâ muyagem gane Yuda a Babilonia hânân âiwe, zo teŋgâziŋâ kiin kimembut uap. Oi narâk zoren gâbâ âsagem gane Kristo muyageip, zo yatigâk kiin kimembut uap. ");
INSERT INTO kpf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kristo muyageip, zorat topŋâ itâ. Mamŋâ Maria Yosepegât siŋgi sâne ândeip. Siŋgi sânetâ tirik tirik ândiwet. Ândeitâ Tirik Kaapumŋâ Maria sot pâlâtâŋ oi kâmboŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maria zâk kâmboŋâ oi ko Yosepeŋâ nâŋgip. Oi zorat topŋâ mân nâŋgipkât nâŋgi mân dâp oip. Yosepe a târârakŋâ ândeipkât umŋan itâ nâŋgip, “Nâ diŋâ a ambân mâteziŋan sa aŋun opapkât tigâk birâbat.” ");
INSERT INTO kpf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yatâ upat sâm nâŋgâm ândei Kembugât sumbem a ŋâiŋâ umanân muyagem itâ sâm dukuip, “Yosepe, Dawidigât kiunŋâ, ambingâ mimbam um zagât mân upan. Tirik Kaapumŋâ zâk sot pâlâtâŋ oipkât kâmboŋ op katep mimbap. ");
INSERT INTO kpf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nanŋâ mimbap. Mei ko zâkkât kutŋâ Yesu sâban. Zâkŋâ a ambân gakârâpŋâ bâliŋaŋgât tâgân gâbâ olaŋziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kut ŋâi ŋâi muyageip, zo Propete a ŋâiŋâ Kembugât sâtkât den itâ sâip, zo bonŋâ oip, ");
INSERT INTO kpf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nâŋgânek. Ambân sigan ŋâiŋâ kâmboŋâ op nanŋâ mimbap. Zâkkât kutŋâ Imanue sâbi (Niiŋ denân ko Anutuŋâ nen sot ândiap).” ");
INSERT INTO kpf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosepe zâk umanân gâbâ zaatŋâ sumbem aŋâ den dukuip, zo lum Maria diim mirâŋan zari ândiwet. ");
INSERT INTO kpf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ka ap ambin ândiândiŋ, zo yatâ mân ândiwet. Yatâ op ândeitâ kâtep muyagei Yosepeŋâ kutŋâ Yesu sâip. ");
INSERT INTO kpf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yudaia hânân Herode a kutâ ândeip, narâk zoren Yesu zâk Betelem kamânân Yudaia hânân âsageip. Oi narâk zoren mirâsiŋ takâtakâŋan gâbâ nâŋgânâŋgâ a, zen Yerusalem kamânân gawe. ");
INSERT INTO kpf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Gamŋâ sâm mâsikâziŋgâm sâwe, “Katep mâik âsagiap, zâk Yuda a zeŋgât a kutâ upap, zâk ikâ taap? Nen ândi hânniŋan gâbâ sâŋgelakŋâ ekŋâ mâpâsinam gen.” ");
INSERT INTO kpf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yatâ sânetâ Herode sot Yerusalem kamân mâirâp, zen aksik nâŋgâm pârâkparâwe. ");
INSERT INTO kpf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodeŋâ den zo nâŋgâm Anutugât tirik namâ galem a patâ sot Kembugât gurumin den zorat galem a sot a sâtŋâ minduziŋgâm itâ sâm mâsikâziŋgip. “Kristo zâk ikâ muyagibapkât sâsâŋ?” ");
INSERT INTO kpf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mâsikâziŋgi itâ sâm dukuwe, “Betelem kamânân, Yudaia hânân. Zorat Propete ŋâiŋâ itâ sâm kulemgoip, ");
INSERT INTO kpf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O Betelem, kamân mâik Yudaia hânân, gâ Yudaia zeŋgât kamân gigiŋâ buŋâ. Gâgâren a kutâ patâ muyagem Isirae a ambân gakârâpnâ kembu otziŋgâbap.’” ");
INSERT INTO kpf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Den zo sâne nâŋgâm Herodeŋâ nâŋgânâŋgâ a diiziŋgâm ziiŋik âim mulunâk mâsikâziŋgip. Sâŋgelak muyageip, zorat narâkŋâ mâsikâziŋgi dukuwe. ");
INSERT INTO kpf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Dukune nâŋgâm zen Betelem kamân âibigât sâŋgonzâŋgom sâip, “Zen âimŋâ kârum katep muyagemŋâ ga dâtnobi. Oi nâŋgoot yatik âi mâpâsibat.” ");
INSERT INTO kpf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","A kutâŋâ den yatâ sâi zen âiwe. Oi sâŋgelak hânziŋan gâbâ igâwe, zorâŋ kândom otziŋgâm âimŋâ katep zeip, zorat mirâ kwâkŋan âi tâip. ");
INSERT INTO kpf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Oi zen sâŋgelak zo ekŋâ sâtâre patâ urâwe. ");
INSERT INTO kpf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Oi mirin bagim katep sot mamŋâ Maria zikit umzik topŋan gei mâpâsiwe. Mâpâsemŋâ irâziŋan gâbâ kut ŋâi ŋâi âlipŋâ mem pindâwe. Kât âlipŋâ goide sot too wârânŋâ âlip, sâŋgânŋâ patâ, zo pindâwe. ");
INSERT INTO kpf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Oi Kembuŋâ umanân kwâkâziŋgi zen Herodegâren mân âi muyagem mâtâp ŋâin gâbâ hânziŋan âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nâŋgânâŋgâ a, zen âburem kamânziŋan âine ko Kembugât sumbem a ŋâiŋâ Yosepe umanân itâ dukuip, “Gâ zaat katep sot mamŋâ diizikâna Aigita hânân âi tap nâgât dengât mambât ândibi. Nâŋgâ. A kutâ Herode, zâk katep kârumŋâ muyagem kumbat sap.” ");
INSERT INTO kpf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sâi Yosepeŋâ zaatŋâ katep sot mamŋâ diiziki ŋâtigânâk tik âim Aigita hânân âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Oi zen zoren ândinetâ a kutâ Herode moip. Propete ŋâiŋâ zorat Kembugât sâtkât itâ sâip, zo bon oip, “Nannâ Aigita hânân gâbâ konsa gâip.” ");
INSERT INTO kpf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nâŋgânâŋgâ a, zen Herode kâitkum âinetâ nâŋgâm kuk imbaŋâ oip. Yatâ op kâwali a sâŋgonzâŋgoi Betelem kamân sot kamân mâik mâik tap arip, zoren âim katep kendonziŋ zagât, zo zâŋgom naŋgâwe. Nâŋgânâŋgâ a zen sâŋgelak âsageip, zorat narâk sâwe, zorat dâp sâi katep zâŋgom naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Oi Propete Yesaiaŋâ mârumŋan den sâip zo narâk zoren bon oip, ");
INSERT INTO kpf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama kamânân den kwamit patâ muyagiap. Âigirâp patâ uap. Mamârâpziŋ zen murarâpziŋaŋgât umbâla op âigirâp op zem tatne hiriŋsâbigât sâm osiziŋge. Wangât, murarâpziŋ buŋ op naŋge, zorat.” ");
INSERT INTO kpf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herode moi Kembugât sumbem a ŋâiŋâ Yosepe Aigita hânân umanân itâ sâm dukuip, ");
INSERT INTO kpf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Gâ zaat. Katep sot mamŋâ diizikâna Isirae hânân âburem âinek. Katep kunat sâwe, a zo muwe.” ");
INSERT INTO kpf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yatâ sâi Yosepeŋâ katep sot mamŋâ diiziki Isirae hânân âburem âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Âburemŋâ Yosepeŋâ den ŋâi itâ nâŋgip, “Akelau zâk ibâŋâ Herode, zâkkât gebâkŋan Yudaia hângât a kutâ op ândiap.” Den zo nâŋgâm zo ândibam keŋgât oip. Oi umanân den nâŋgâmŋâ Galilaia hânân arip. ");
INSERT INTO kpf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Zoren kamân ŋâi kutŋâ Nasarete zeip, zoren âi ândeip. Oi Propete zeŋgât den itâ ziap, zo bon oip, “Zâk Nasarete kamânân gokŋâ sâbi.” ");
INSERT INTO kpf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ândim zâim ko Yohaneŋâ Yuda a zeŋgâren muyagem gâip. Gamŋâ Yudaia zeŋgât mirâ âtâŋan, a mân ândiândiŋan, zoren âi ândim den siŋgi itâ sâm dâzâŋgom ândeip, ");
INSERT INTO kpf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Anutu um topŋan ândinatkât narâk mâte uap, zorat zen umziŋ melâŋnek.” ");
INSERT INTO kpf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanegât Propete Yesaiaŋâ mârumŋan den itâ sâm kulemguip, zo bon oip, “Mirâ kamân âtâŋan a ŋâiŋâ âsagem den patâ itâ sâm muyagem ândiap, ‘Kembugât mâtâp kârâm kubiknek. Oi kârâm kwârakune kelâluŋâ oik.’” ");
INSERT INTO kpf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane zâk a kanpitâ ândeipkât sâk pâke âlipŋâ mân mem ândeip sot nalem âlip mân nem ândeip. Hâmbâ kamele sâmotŋandâ tuuwe, zo mem ândeip. Oi kâmbatŋan inzut ŋâi lap ândeip. Nalemŋâ ko kumbon sot bâŋsat, zo nem ândeip. ");
INSERT INTO kpf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Oi Yerusalem kamânân gâbâ sot Yodaŋ too nâmbut nâmbut, zeŋgâren gâbâ a gâbâreyaŋgâm zâkkâren âimarâwe. ");
INSERT INTO kpf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Zâkkâren âimŋâ bâliŋâziŋâ sapsune Yodaŋ toin saŋgonziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Oi Parisaio a sot Sadukaio a doŋbepŋâ too saŋgonam gane ziŋgitŋâ itâ mâsikâziŋgip, “O mulumgât kiurâp, zen bâliŋâziŋaŋgât hâuŋâ mâte otziŋgâbâmap, zo ŋâiŋâ dâzâŋgoi bâliŋâziŋ birâbi? ");
INSERT INTO kpf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Zen umziŋ melâŋâ orot mâmeziŋâ kubik ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Zen umziŋan itâ mân nâŋgâbi, ‘Nen Abaramgât kiurâp, zorat kârâpŋoot mân otniŋgâbap.’ Nâ dâzâŋgua nâŋgânek. Anutuŋâ sâbâ sâm sâi kât zirâŋâ Abaramgât kiurâpŋâ op âsagibi. ");
INSERT INTO kpf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Zorat sa nâŋgânek. Nak ŋâi bonŋâ âlipŋâ mân upap, zo ko mariŋandâ kârâm kârâp oi simbap. Nâŋga zo mârum nak topŋan pâi ziap. ");
INSERT INTO kpf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Zen umziŋâ melâŋne toin saŋgonziŋgâman. Ka ŋâi bet gam taap, zâk imbaŋâ patâ zemŋâŋgap. Nâ yatâ zorâŋ irâŋâ sikumŋâ goribat, zorâgoot ko mân dâp upap. Zâkŋâ Tirik Kaapum sot kârâp saŋgonziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Zâk gâbâgâbâriŋoot gamŋâ nalem gwapgwapŋâ gâbârem mindubap. Nalem bonŋâ mirâŋan pâmbap. Ka gwapgwapŋâ, zo ko gâbârem kârâbân pâi simbap. Oi kârâp zo mân bâpsâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Narâk zoren Yesu zâk Galilaia hânân gâbâ Yodaŋ toin âimŋâ Yohaneŋâ too saŋgonŋaŋgâbapkât dukuip. ");
INSERT INTO kpf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Dukui ko Yohaneŋâ nâŋgi mân dâp oi itâ dukuip, “Wangât nâgâren ga sat? Gâŋâ nâ saŋgonina dâp opap.” ");
INSERT INTO kpf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sâi Yesuŋâ den itâ mâburem dukuip, “Nâŋgâm kwâkâ mân ot. Net Anutugât sâtŋâ lugitâ dâp upap.” Yatâ sâi Yohaneŋâ diŋâ lum saŋgonŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Too saŋgonŋaŋgi Yesu zâk toin gâbâ kopgam egi sumbem pâroŋsâi Anutugât Kaapumŋâ nii kembâ yatâ opŋâ gem gam kwâkŋan pâip. ");
INSERT INTO kpf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Oi zorenâk sumbemân gâbâ den ŋâi itâ muyageip, “Zi nannâ âlipŋâ. Umnâ zâkkâren kinmap. Ekŋâ umnâ âlip opmap.” ");
INSERT INTO kpf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kaapumŋâ Yesu okŋaŋgi mirâ kamân âtâŋan arip. Sataŋŋâ mâsikâŋaŋgâbapkât okŋaŋgi arip. ");
INSERT INTO kpf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Oi zoren Yesu zâk ŋâtik sot sirâm 40 umŋan nâlem buŋ ândeip. ");
INSERT INTO kpf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Oi sarâ mariŋandâ zâkkâren gamŋâ itâ sâm dukuip, “Gâ Anutugât nanŋâ ândiat oi ko sânandâ kât zirâŋ nalem oi ne.” ");
INSERT INTO kpf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sâi Yesuŋâ itâ sâm dukuip, “Den kulem ŋâi itâ ziap, ‘Aŋâ nalemâk nem mân ândinat. Nalem nem sot den Anutugâren gâbâ gâmap, zo nâŋgâm ândim kwâtâtinat.’” ");
INSERT INTO kpf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yatâ sâi Sataŋŋâ diim âim kamân patin takâm tirik namâ pum kwâkŋan pâip. ");
INSERT INTO kpf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Pamŋâ itâ dukuip, “Gâ Anutugât nanŋâ ândiat oi ko zibâ pâtan gei. Oi den kulem ŋâi itâ ziap, zo nâŋgâ, ‘Zâkŋâ sumbem arâp zeŋgât bitziŋan gâbanbap. Ziŋâ bitziŋandâ mingim geine kâtŋâ mân gobap.’” ");
INSERT INTO kpf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yatâ sâi Yesuŋâ itâ sâip, “Oi den kulem ŋâi itâ ziap, ‘Kembu Anutugâ zâizâiŋ mân okŋaŋgâban.’” ");
INSERT INTO kpf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sâi Sataŋŋâ bak kârep patâ ŋâin diim zâi kin hân dâp a kâmut kâmutŋâ sot sikum kut ŋâi ŋâi âkŋâleŋoot, zo tirâpkoip. ");
INSERT INTO kpf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tirâpkum itâ sâip, “Gâ nâgât umnâ topŋan gei pindiŋsâm mâpâseninandâ hân sot kut ŋâi ŋâi, zi aksik gâ gibat.” ");
INSERT INTO kpf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sâi Yesuŋâ den mâburem itâ dukuip, “Sataŋ, gâ birânim âi. Den kulem ŋâi itâ ziap, ‘Kembu Anutugâ kânok mâpâsiban. Oi zâk kânok kore okŋaŋgâban.’” ");
INSERT INTO kpf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yatâ sâi Sataŋŋâ birâŋaŋgâm ari sumbem a zen gam on galem okŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yohane tâk namin panetâ Yesuŋâ zorat siŋgi, zo nâŋgâm Galilaia hânân arip. ");
INSERT INTO kpf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Oi Nasarete kamânân ândeip, zo birâm Kapenaum kamân âi ândeip. Kamân zo saru sâtŋan Sebuloŋ sot Naptali, zeŋgât hânân tâip. ");
INSERT INTO kpf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yatâ oi Propete Yesaia zâkkât den ŋâi itâ ziap, zo bon oip, ");
INSERT INTO kpf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebuloŋ sot Naptali hân saru sâtŋan Yodaŋ too nâmbutken ziap, Galilaia hân torenŋan, zoren hân ŋâin gokŋâ zen ândime. ");
INSERT INTO kpf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","A zo ŋâtâtigân ândiwe, zen kârâp âsakŋâ patâ ikse. Mumuŋaŋgât siŋgi op ŋâtâtigân ândiwe, zen âsakŋâ muyageziŋgap.” ");
INSERT INTO kpf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Narâk zoren Yesuŋâ topkwapŋâ siŋgi âlip dâzâŋgom a itâ dâzâŋgom ândeip, “Anutugât um topŋan ândinatkât narâkŋâ mâte uapkât umziŋ melâŋnek.” ");
INSERT INTO kpf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Oi sirâm ŋâin Yesuŋâ Galilaia saru sâtŋan âim gam tap a zagât, âtâ mun zikirip. Ŋâi Simoŋ, kutŋâ ŋâi Petero. Ŋâi ko munŋâ Andrea. Zet saruyân zuugât irâ pam kirâwet. Zet iŋangât nep tuum ândiwet. ");
INSERT INTO kpf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesuŋâ zikitŋâ dâzâkom sâip, “Zet ga nâgât a op molinigit. Oi zet iŋangât nep tuum ândiabot, zo yatik a zeŋgâren nep tuum ândibabot.” ");
INSERT INTO kpf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sâi zorenâk irâzikŋâ birâm molim âiwet. ");
INSERT INTO kpf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Oi Yesuŋâ mâik ŋâi âimŋâ a âtâ mun zagât muyagezikip. Yakobo sot munŋâ Yohane, zet Zebedaiogât nanzatŋâ. Zet ibâzikŋoot waŋgâyân tap irâziŋâ kubik tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yesuŋâ dâzâkoi zorenâk waŋgâ sot ibâzikŋâ birâŋaŋgâm molim âiwet. ");
INSERT INTO kpf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuŋâ Galilaia hânân kamân toren toren âim gam mâpâmâpâse namin zâim den siŋgi âlip dâzâŋgom ândeip. Oi a ambân sisi mâsekziŋoot kubikziŋgâm ândeip. ");
INSERT INTO kpf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yatâ op ândei siŋgiŋâ Siria hânân laŋ kârâm ari nâŋgâm a ambân sisi mâsek sot wâkeziŋoot sot kin bitziŋâ mumuŋâ zâkkâren diiziŋgâm gane kubikziŋgâm naŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Oi Galilaia hânân gâbâ sot kamân bâzagât Yodaŋ too nâmbutken tâibân gâbâ sot Yerusalem kamânân gâbâ sot Yudaia hânân gâbâ sot Yodaŋ too nâmbutken gâbâ, a ambân kâmut patâŋâ mindumŋâ moliwe. ");
INSERT INTO kpf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesuŋâ a ambân kâmut patâ ziŋgitŋâ bâkŋan zâi tâi arâpŋâ zen um topŋan âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Âinetâ siŋgi âlip itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“A nâmbutŋâ umziŋaŋgât nâŋgâne gigiŋ opmap, zeŋgât nâŋga sâtâreŋoot uap. Zo ziŋâ sumbemân Anutu um topŋan ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","A nâmbutŋâ isem umbâlâ op ândime, zeŋgât nâŋga sâtâreŋoot uap. Zen zo umâlep kwatziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","A nâmbutŋâ zâizâiŋâ mân op ândime, zeŋgât nâŋga sâtâreŋoot uap. A zo ziŋâ hân patâ zi galem upi. ");
INSERT INTO kpf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","A nâmbutŋâ ândiândi târârakkât otziŋgi ândime, zeŋgât nâŋga sâtâreŋoot uap. Zen gâtâm bonŋâ muyagibi. ");
INSERT INTO kpf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","A nâmbutŋâ zen um lâklâk op a toren tânzâŋgome, zeŋgât nâŋga sâtâreŋoot uap. Zen zo Anutuŋâ zo yatik otziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","A nâmbutŋâ umziŋ salek ândime, zeŋgât nâŋga sâtâreŋoot uap. Zen zo Anutu ek ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","A nâmbutŋâ lumbeŋaŋgât nep tuum ândime, zeŋgât nâŋga sâtâreŋoot uap. Zen zo Anutugât murarâpŋâ sâbi. ");
INSERT INTO kpf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","A nâmbutŋâ târârakziŋaŋgât op kâmbamân sot tâk namin âibi, zeŋgât nâŋga sâtâreŋoot uap. Zen zo sumbemân Anutu um topŋan ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","A nâmbutŋâ nâgât opŋâ a ziŋâ den bâliŋ top topŋâ dâzâŋgom zâŋgom molimoli otziŋgâme, zeŋgât nâŋga sâtâreŋoot uap. ");
INSERT INTO kpf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Zen sumbemân sâŋgân patâ mimbi, zorat umâlep patâ op sâtâre upi. Wangât, Propete a mârumŋan yatik zâŋgom moliziŋgâwe, zorat.” ");
INSERT INTO kpf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Zen a zeŋgât sii op ândibi. Ka siigât naamŋâ buŋ oi ko dap oindâ naamŋâ dum upap? Zo buŋâ. Sii bâliŋâ zo yatâ mo yatâ orotŋâ, zo mân ziap. Sii zo yen hânân lokine giari a ambân ziŋâ lâŋbi. ");
INSERT INTO kpf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Oi zen a zeŋgât kârâp âsakŋâ op ândibi. Kamân ŋâi bak kârep ŋâin tâi wan mo wanŋâ mân kwâtepkubap. ");
INSERT INTO kpf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Zen kârâp sâumŋâ âmaŋân mân kwârakume. Buŋâ. Zo tâtatŋan pane tâpmap. Oi mirâ kâligen zime, zo âsageziŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Zen zo yatâ a zeŋgât âsakŋâ op ândibi. Oi a zen ândiândiziŋâ ikne âlip oi sumbem Ibâziŋâ sâm âlip kwâkŋaŋgâbi.” ");
INSERT INTO kpf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","18","“‘Mosegât gurumin den sot Propete zeŋgât den kumbam geip,’ nâgât yatâ sâme? Nâ mân kumbam gewan. Nâ zo lubatkât gewan. Den zo bon op kut ŋâi ŋâi muyagem naŋgâbap. Nâ perâkŋak dâzâŋgobâ. Mosegât gurumin den murukŋâ ŋâi mân buŋ upap. Gurumin den zo tâi hân sumbem, zet buŋ upabot. ");
INSERT INTO kpf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Oi a ŋâi, zâk gurumin den murukŋâ ŋâi mân lumŋâ a toren yatik upigât dâzâŋgobap, zo ko sumbemân a ândibi, zeŋgât ombeŋan a gigiŋ op ândibap. Oi ŋâiŋâ ko den zo lum a nâmbut zo yatik upigât sâbap, zo ko sumbemân a ândibi, zeŋgât patâziŋ op ândibap. ");
INSERT INTO kpf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Zorat dâzâŋgua nâŋgânek. Zen gurumin den galem a sot Parisaio a, zen ândiândiziŋ âlip mân ândim walâziŋgâm sumbemgât siŋgi mân upi.” ");
INSERT INTO kpf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Sâkurâpziŋ zen den itâ dâzâŋgowe, ‘Gâ kâmbam mân kumban. Ŋâi zâk kâmbam kumbap, denân pambi.’ ");
INSERT INTO kpf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ka nâŋâ itâ dâzâŋgobâ. Ŋâi zâk bukuŋâ um kuk nâŋgâŋaŋgâbap, zâk den nepŋaŋgât siŋgi upap. Ŋâi zâk bukuŋâ den bâliŋâ dukubap, zo ko a sâtŋâ zeŋgât minduminduyân pambi. Ŋâi zâk bukuŋâ den kârok bâliŋâ dukubap, zo ko sim kârâpkât siŋgi upap. ");
INSERT INTO kpf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Zorat ko gâ kut ŋâi ŋâi Kembugât siŋgi pâmbam itâ nâŋgâban, ‘Bukunet kâsâp osetnikŋan ziap.’ ");
INSERT INTO kpf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Zo yatâ nâŋgâm kut ŋâi zo birâm âi bukugoot den sâm kusik tuumŋâ âburem kut ŋâi zo Kembugât siŋgi pâmban. ");
INSERT INTO kpf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Gâ a ŋâi sot kâsâp op dinzikŋâ zo kek kubikpabot. Top likuliku a zâkkâren mân âim kâsagoot den sâm kubikpabot. Yatâ mân otna kâsagandâ den zo top likuliku agâren sâi nâŋgâm kâwali a gakârâpŋâ sâi gâ gâsugim tâk namin gâbanbi. ");
INSERT INTO kpf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nâ perâkŋak dâgobâ. Gâ zoren tapŋâ yen mân giban. Kâsagaŋgât tosa mâkâm naŋgâm gem gâban. ");
INSERT INTO kpf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Sâkurâpziŋâ itâ dâzâŋgowe, ‘Ap ambin, zet mân birâyaŋgâbabot.’ ");
INSERT INTO kpf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ka nâŋâ ko itâ dâzâŋgobâ. A ŋâiŋâ ambân ŋâi ek âkŋâleŋaŋgâbap, zo ko zâk zik ambin zo umŋandâ birâŋaŋgâbap. Zâk tosa mimbap. ");
INSERT INTO kpf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Zorat siŋgâ ŋâiŋâ bâliŋan gâbanbâ sâi sum lâmuŋ birâban. Hâlâlu ândim simân geibatkât laŋ siŋgâ toren sum lâmuŋban. ");
INSERT INTO kpf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bikâ bongenŋâ bâliŋan gâbanbâ sâi kârâm mânâŋgât pâmban. Sâk hâlâlu ândim sim kârâpkât siŋgi opatkât laŋ bikâ kârâm mânâŋgât pâmban. ");
INSERT INTO kpf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Den sâŋgiŋâ itâ ziap, ‘Ŋâi zâk ambinŋâ birâbam ekap pindâm molibap.’ ");
INSERT INTO kpf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ka nâŋâ ko itâ dâzâŋguan. A ŋâi ambin birâbap, zo ko zâk târotârozik mânâŋgât tosa patâ mimbap. Ka ambân zo a ŋâi sot ândeip oi ko tosa zo apŋaŋgât mân upap. Oi ŋâi zâk ambân birâbirâŋ zo mimbap, zo ko zâk tosa patâ mimbap. ");
INSERT INTO kpf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Zen nâŋge. Sâkurâpziŋâ itâ dâzâŋgowe, ‘Gâ Anutu mâteŋan den ŋâi sarâ mân sâban. Kembu mâteŋan den ŋâi sâmŋâ lunandâ bonŋâ upap.’ ");
INSERT INTO kpf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Naŋâ ko itâ dâzâŋguan. Anutu mâteŋan den sâsâŋâ, zo itâgât birâm naŋgâbi. Sumbem, zo Anutugât tâtat mâme uap. ");
INSERT INTO kpf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Hânân kwap sâme, zo itâgât op birâbi. Hân, zo Anutugât kombâŋŋâ. Oi Yerusalem kamânân kwap sâsâŋâ, zo itâgât op birâbi. Yerusalem kamân, zo Kembu patâgât kamân. ");
INSERT INTO kpf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Oi kâukziŋan kwap sâsâŋ, zo birâbi. Zen kâukziŋ sâmotŋâ kâu ŋâi dukune sumun upap? Mo sumun ŋâi dukune kâu upap? Yatâ buŋâ. ");
INSERT INTO kpf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Zorat dinziŋâ bonŋan sâne bonŋâ upap. Buŋâ sâne buŋâ upap. Den târokwap sâme, zo Sataŋgâren gâbâ gâmap.” ");
INSERT INTO kpf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Den ŋâi itâ sâsâŋâ, zo nâŋge, ‘Ŋâiŋâ siŋgâ sum lâmuŋi gâŋgoot siŋâ sum lâmuŋban. Ŋâiŋâ sâtkâ kwâki gâŋgoot sâtŋâ hâuŋâ kom kwâkâban.’ ");
INSERT INTO kpf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nâŋâ ko itâ dâzâŋguan. Zâŋgonâ sâne sâkziŋâ mân aŋgân kârâbi. Gât ko a ŋâiŋâ pâlomgâ toren koi toren ŋâi pindâna kumbap. ");
INSERT INTO kpf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Oi ŋâiŋâ gâ sot kâsa op hâmbâgâ kwâkŋan mei umŋan yatik pindâban. ");
INSERT INTO kpf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Oi a ŋâiŋâ gâ irâŋâ mem pâŋkânogân âi pâmbangât sâi gâŋâ târokwap kârebân âi pam gâban. ");
INSERT INTO kpf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Oi a ŋâiŋâ kut ŋâi ŋâi nibangât sâi pindâban. Oi yen mem ândim gibat sâi nâŋgâŋaŋgâban.” ");
INSERT INTO kpf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Den ŋâi itâ sâsâŋâ, zo nâŋgâme, ‘Gâ bukugâ buku okŋaŋgâban, ka kâsagâ kâsa miŋaŋgâban.’ ");
INSERT INTO kpf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ka nâŋâ ko itâ dâzâŋgobâ. Kâsarâpziŋ buku otziŋgâbi. Oi a zâŋgom moliziŋgâme, zeŋgât op ninâu sâbi. ");
INSERT INTO kpf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Zen zo yatâ op ândim sumbem Ibâziŋaŋgât nan bârarâp bonŋâ op ândibi. Zâkŋâ yatik sâi maaŋandâ a orot mâmeziŋ bâliŋâ sot âlipŋâ aksik âsageziŋgâmap. Oi yatik sâi mapŋâ a orot mâmeziŋ bâliŋâ sot âlipŋâ aksik ziŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Zen buku otziŋgâme, zorik buku otziŋgâbi, zo ko Anutuŋâ sâŋgânŋâ wan ziŋgâbap? Bâliŋ mâme a, zen yatâ op ândime, zo ka. ");
INSERT INTO kpf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Zen torerâpziŋâ zorik mâŋganziŋgâbi, zorat sâŋgânŋâ wan ziŋgâbap? Um kâtik a, zen yatâ upme. ");
INSERT INTO kpf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Zorat zen ko walâm sumbem Ibâziŋandâ târârak ândimap, zo yatik op ândibi.” ");
INSERT INTO kpf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Zen siŋgi âlip lumŋâ kut ŋâi ŋâi âlipŋâ upme, zo ziŋgitne âlip upapkât a mâteyân mân mem ândibi. A mâteyân yatâ op ândine Anutuŋâ sâŋgânŋâ mân ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Zorat gâ a âlip otziŋgâm a nâmbutŋandâ gek nâŋgâbigât lâmun mân waatpan. A sarâŋâ, zen mâpâmâpâse namin sot kamân sombemân a ziŋâ sâm âlip kwatziŋgâbigât yatâ upme. Nâ perâkŋak dâzâŋgobâ. Zen sâŋgânziŋâ mârum mine âkip. ");
INSERT INTO kpf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bukugâ ŋâi kut ŋâi pindâbam tik pindâm bukugâ ŋâi mân dukuban. ");
INSERT INTO kpf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yatâ upan, zo ko orot mâmegâ tik zimbap. Yatâ otna Ibâgandâ kut ŋâi ŋâi tik ek nâŋgâmŋâ hâuŋâ sâŋgânŋâ gibap.” ");
INSERT INTO kpf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Zen ninâu sânam a sarâŋâ, zen yatâ mân upi. Zen mâpâmâpâse namin sot a minduminduyân ninâu sânam bâbâlaŋ upme, zo ko aŋâ ziŋgitpigât yatâ upme. Nâ perâkŋak dâzâŋgobâ. Yatâ ziŋgitne ko zorâŋak sâŋgânziŋâ opmap. ");
INSERT INTO kpf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gâ ko ninâu sâbâ sâm mirâgan zâi hâŋgi dooŋgumŋâ Ibâgâ tik ândimap, zâkkâren ninâu sâban. Oi Ibâgâ tigâk kut ŋâi ŋâi ek nâŋgâmapŋâ bonŋâ muyagem gibap. ");
INSERT INTO kpf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Oi zen ninâu lâuyâk mân sâbi. Ninâu sâmŋâ târokwap mân sâm âine kârep patâ upap. Um kâtik a, zen ninâu yatâ sâme. A zo ziŋâ den doŋbep sâm arindâ nâŋgâniŋgâbap sâme. ");
INSERT INTO kpf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gât ko zen a zo zen yatâ mân upi. Zen ninâu mân sâne Ibâziŋâ zâk kut ŋâi ŋâi um nâŋgânâŋgâziŋan ziap, zo kek ek nâŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Oi zen itâ sâm ninâu sâbi, ‘Ibâniŋâ sumbemân taat, gâgât kutkâ hâlâlu zimbap. ");
INSERT INTO kpf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gâ gamŋâ um dâp hân dâp kembu otniŋgâban. Sumbemân gâgâren sât lulu ziap, zo yatik hânân neŋgâren zimbapkât otniŋgap. ");
INSERT INTO kpf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gâ sirâm ziren nalem dâpniŋan niŋgâban. ");
INSERT INTO kpf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nen a zeŋgât tosa biren zo yatik tosaniŋâ birâban. ");
INSERT INTO kpf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Top mâsimâsikâyân mân nâmbanban. Bâliŋâ mariŋaŋgât bikŋan gâbâ mâkâniŋgâban.’ ");
INSERT INTO kpf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Zen a zeŋgât tosa birânetâ Anutuŋâ yatik tosaziŋ birâbap. ");
INSERT INTO kpf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ka zen a zeŋgât tosa mem ândinetâ Anutuŋâ zeŋgât tosa yatik mem ândibap.” ");
INSERT INTO kpf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Zen nalem birâm kendon ândim si sâŋgânziŋ kuk sen sen mân upi. A sarâŋâ, zen yatâ upme. A nâmbutŋâ, zen nâlem birâm kendon ândiândiziŋâ ziŋgitpigât yatâ upme. Nâ perâkŋak dâzâŋgobâ. Zen zorat sâŋgânŋâ mârum mine âkap. ");
INSERT INTO kpf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Gâŋâ ko nalem birâm kâukâ kendâm si sâŋgângâ too saŋgonŋâ ândiban. ");
INSERT INTO kpf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yatâ otna a ziŋâ nalem birâm ândiândigâ mân ek nâŋgâbi. Sumbem Ibâgâ tik ândimap, zâk zikŋik nâŋgâbap. Oi zâk tik ândim kut ŋâi ŋâi ek nâŋgâmapŋâ sâŋgânŋâ gibap.” ");
INSERT INTO kpf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Zen hângât sikum kut ŋâi ŋâi doŋbep mân mindubi. Hângât kut ŋâi ŋâi kabâtŋâ niniŋâ sot alâalâgiŋ sot aŋâ kâmbu mime, zorat nâŋgânetâ mân zâibap. ");
INSERT INTO kpf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Zen sumbemân kut ŋâi ŋâi mindum ândibi. Sumbemgât kut ŋâi ŋâi, zo kabâtŋâ mân niniŋâ sot mân alâalâgiŋ sot aŋâ kâmbu mân orotŋâ, zorat nâŋgâne zâibap. ");
INSERT INTO kpf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kut ŋâi ŋâiziŋ zemabân, zoren yatik umziŋ pane zemap. ");
INSERT INTO kpf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Siŋgâ so sâkkaŋgât âsakŋâ. Siŋgâ âlip tâi sâkkâ âsakŋâ ek ândiban. ");
INSERT INTO kpf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ka siŋgâ bâliŋ oi ko sâkkâ ŋâtâtik upap. Zorat sa nâŋgânek. Umgaŋgât âsakŋâ ŋâtâtiksâbap, zo ko opoŋ ŋâtâtik patâ muyagei kwakmak op ândiban. ");
INSERT INTO kpf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","A kânokŋâ a kutâ zagât, zekât kore âlip mân upap. Zâkŋâ ŋâi buku okŋaŋgâm ŋâigât âkon upap. Oi zâk ŋâi sot pâlâtâŋ op ŋâi kândâtkubap. Zen yatik Anutugât nep sot kât sikum âkŋâlegât nep, zo dap yatâ mâtâkâziŋgâm mem ândibi?” ");
INSERT INTO kpf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Zorat torenŋâ ŋâi zi dâzâŋgua nâŋgânek. Zen ândiândiziŋaŋgât nâŋgâm itâ mân sâbi, ‘Wan wan mem nem ândinat?’ Mo sâkziŋaŋgât nâŋgâm itâ mân sâbi, ‘Wan mo wan lap ândinat?’ Kut ŋâi ŋâi zorat mân nâŋgâm kwâkâ upi. Zorat zen sânek. Ândiândiziŋandâ bonŋâ mo nalemŋâ bonŋâ? Sâkziŋandâ bonŋâ mo sâk pâkeŋâ bonŋâ? ");
INSERT INTO kpf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Zen nii ziŋgitnek. Nii zen nep mân kârâm kâmitme. Zen nalem mân mindune tâpmap. Oi sumbem Ibâziŋandâ nalem muyagem ziŋgâmap. Oi dap dap? Zen nii zeŋgât ombeziŋan? Buŋâ. ");
INSERT INTO kpf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Oi zen nâŋgânâŋgâziŋ kâtikŋâ ziap oi ko sânetâ sâkziŋ kâtigei narâkŋâ pâŋkânok târokwap ândibi? ");
INSERT INTO kpf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yatâ orotŋâ mân ziabân wangât sâk pâkegât doŋbep nâŋgâme? Zen pâliŋpâliŋ neule hibukŋan zemap, zorat topŋâ nâŋgâbi. Zâk sâk pâke mân tuumap. ");
INSERT INTO kpf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Zorat sa nâŋgânek. A kuta Salomo mârumŋan ândeip, zâk sikum patâ sot neule âlip zemŋaŋgip. Ka Salomo zâk sâkŋâ neuleŋootŋâ neule âlipŋâ yatâ zo mân mem ândeip. ");
INSERT INTO kpf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Oi hibuk bâloŋâ zo irak muyagem mukan âkâm gemap. Anutuŋâ sâi neule âlipŋâ zo muyagemap. Oi zen dap nâŋge? Anutuŋâ sâk pâke âlip mân muyagem ziŋgâbap? Zen nâŋgâm pâlâtâŋziŋ lotŋâ. ");
INSERT INTO kpf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Zorat zen nâŋgâ kwâkâ op itâ mân sâbi, ‘Nen wan wan nem ândinat. Nen wan wan mem lap ândinat?’ ");
INSERT INTO kpf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Um kâtik a, zen um nâŋgânâŋgâziŋ zoren pane zemap. Zen ko yatâ mân upi. Ibâziŋandâ wan wangât kwakse, zo nâŋgâm naŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Zen sumbem Ibâziŋaŋgât um topŋan ândiândiŋ sot zâkkât mâtâp târârak ândiândiŋ, um nâŋgânâŋgâziŋ zoren pane zimbap. Zo yatâ utne sâkkât kut ŋâi ŋâi ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Zen mukangât nâŋgâ kwâkâ mân upi. Nâŋgâ kwâkâ zo mukangât siŋgi. Sirâm ŋâigât kâbâ yâmbât, zo sirâm zorat siŋgi upap.” ");
INSERT INTO kpf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Zen a hâuŋâ den mân sâm siŋziŋan gibi, zo ko Anutugoot zen yatigâk mân sinziŋan gibap. ");
INSERT INTO kpf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Zen a hâuŋâ den sâm kwâkâziŋgâbi, zorat dâp yatigâk Anutuŋâ zen sâm kwâkâziŋgâbap. Zen a kut ŋâi ŋâi otziŋgâbi, zorat dâp yatik Anutuŋâ mâburem ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Gâ wangât bukugaŋgât siŋan gwapgwap zo ekŋâ gikâ siŋgan nak sâmbaŋâ zo mân ek nâŋgat? ");
INSERT INTO kpf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nak sâmbaŋâ gikâ siŋgan zei dabângen bukugâ itâ dukuna dâp upap? ‘Gâ nâŋgâna siŋgan gwapgwap ziap zo, mem pambâ.’ ");
INSERT INTO kpf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sarâ a gâ. Kândom gikâ siŋgan nak sâmbaŋâ zo mem pamŋâ gwapgwap bukugaŋgât siŋan zei mem pâna dâp upap. ");
INSERT INTO kpf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Gâ a nâmbutŋâ Anutu kândâtkume, zen siŋgi âlipkât kut ŋâi ŋâi âlipŋâ, zo mân ziŋgâban. Zen wâu bâu yatâ opŋâ kut ŋâi ŋâi âlipŋâ zo birâm âburem gibegât.” ");
INSERT INTO kpf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ninâu sâm ândim kut ŋâi zo mimbi. Kârum ândim bonŋâ muyagibi. Hâŋgiyân kom ândine mirâ mâriŋandâ mem pâmbap. ");
INSERT INTO kpf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ŋâi zâk ninâu sâm ândim kut ŋâi memap. Ŋâi zâk kârumapŋâ bonŋâ muyagemap. Ŋâi zâk mâtâbân kom ândei mariŋandâ mâtâp mem pâmbap. ");
INSERT INTO kpf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Zeŋgâren gâbâ ŋâiŋâ nanŋâ nalemgât sâi kâsaget pindâbap? ");
INSERT INTO kpf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mo zeŋgâren gâbâ ŋâiŋâ nanŋâ iŋangât sâi guk mo mulum pindâbap? ");
INSERT INTO kpf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Buŋâ. Zen a bâliŋandâ murarâpziŋâ kut ŋâi ŋâi âlipŋâ yatâ otziŋgâme. Oi Ibâziŋ sumbemân walâwalâŋandâ kut ŋâi ŋâi âlipŋâ ziŋgâbap. Zen zâkkâren ninâu sâne kut ŋâi ŋâi âlipŋâ walâm ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Zen a ziŋâ kut ŋâi ŋâi otziŋgâbigât otziŋgâmap, zorat dâp otziŋgâbi. Zorâŋâ Mosegât gurumin den sot Propete zeŋgât den zo minduap.” ");
INSERT INTO kpf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Zen mâtâp pâlâtâŋan sumbemân bagibi. Tâmbetagoagoŋaŋgât hâŋgi, zo patâ uap. Oi zorat mâtâpŋâ zo ŋilip patâ. Zoren a ambân doŋbepŋâ bagim âime. ");
INSERT INTO kpf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ândiândi kamângât mâtâp, zo pâlâtâŋ. Zoren a ambân bituktâŋâ âime.” ");
INSERT INTO kpf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Propete sarâŋâ, zen holi tobatziŋâ râma yatâ ka umziŋâ wâu kâtikŋâ kâwaliziŋoot. Zo nâŋgâm galem ândibi. Zen zeŋgât orot mâmeziŋaŋgât sen kwapŋâ topziŋâ nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bolep sâŋgerân bonŋâ oi nime? Mo zâlâliyân sam bonŋâ oi nime? ");
INSERT INTO kpf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Zo buŋâ. Nak âlipŋan bonŋâ âlipŋâ âsagemap, ka nak bâliŋan bonŋâ âlipŋâ mân âsagemap. ");
INSERT INTO kpf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nak âlipŋan bonŋâ bâliŋâ mân muyagemap. Nak bâliŋan bonŋâ âlipŋâ mân âsagemap. ");
INSERT INTO kpf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Zorat nak ŋâi zâk bonŋâ âlipŋâ mân oi kârâm kârâbân umbi. ");
INSERT INTO kpf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nâ zorat op san. A zeŋgât orot mâmeziŋ ekŋâ topziŋ nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kembuniŋâ, Kembuniŋâ nonsâme, ka zeŋgâren gâbâ nâmbutŋandâ sumbemân mân zâibi. Ibânâ sumbemân, zâkkât den lume, zen ziiŋik sumbemân bagibi. ");
INSERT INTO kpf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Narâk zoren a doŋbep patâŋâ ziŋâ itâ sâm dâtnobi, ‘Kembunâ, Kembunâ, gâgât kutkâ sâm a ambân siŋgi âlip dâzâŋgowen. Gâgât kutkâ sâm wâke moliziŋgâwen. Gâgât kutkâ sâm nep patâ tuuwen.’ ");
INSERT INTO kpf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yatâ sâne nâ itâ sâm dâzâŋgobat, ‘Nâ zeŋgât kutziŋâ mân nâŋgan. Bâliŋ mâme a, zen birânim âinek.’” ");
INSERT INTO kpf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“A ŋâiŋâ dinnâ zi nâŋgâm lubap, zâk a nâŋgânâŋgâŋoot upap. Zâk a ŋâiŋâ bâkŋan mirâŋâ kâtikŋâ tuugip yatâ. ");
INSERT INTO kpf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mirâŋâ tuugi tâi map pibâ patâ gam kom osei mirâ zo kâtigem kirip. Lâm kârep esâm tandâ pâi giari sârakoip, zorat kâtigem kirip. ");
INSERT INTO kpf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Oi a ŋâi dinnâ zi nâŋgâm birâbap, zâk a kwakmak zi yatâ. A kwakmak ŋâiŋâ mirâŋâ too sâtŋan tuugip. ");
INSERT INTO kpf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mirâŋâ tuugi tâi map patâ too uurupŋoot takâm koi giligâlaksâm naŋgip.” ");
INSERT INTO kpf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuŋâ den zo sâm naŋgi a ambân kâmut patâ zen den sâip, zorat nâŋgâne imbaŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Oi itâ sâwe, “Zâk Kembugât gurumin den zorat galem a, zen walâziŋgâm sap.” Yesu zâk imbaŋâŋootŋâ den siŋgi âlip dâzâŋgoip, zorat yatâ sâwe. ");
INSERT INTO kpf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuŋâ bâkŋan gâbâ gem gâi a ambân kâmut patâ molim âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Oi a ŋâi, sâk bâlâ a, zorâŋ um topŋan âim gei pindiŋsâm itâ sâm dukuip, “Kembu, gâ imbaŋâgâ ziap, zorat kubiknibâ sâm âlip kubikniban.” ");
INSERT INTO kpf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yatâ sâi Yesuŋâ bikŋandâ weemŋâ sâip, “Nâŋgâgigangât sâkkâ âlip oik.” Sâi zorenâk useŋâ sogei sâkŋâ âlip oip. ");
INSERT INTO kpf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu zâk yatâ okŋaŋgâm sâip, “Gâ zirat siŋgi a ambân mân dâzâŋgoban. Gâ âi tirik namâ galem a sâkkâ tirâpkuna ikpap. Oi Moseŋâ den sâip, zo lum nii mo zuu ŋâi Kembugât siŋgi sâm pâmban. Sâkkâ âlip uap, zo a ambân ek nâŋgabigât yatâ otnan.” ");
INSERT INTO kpf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Oi Yesu zâk Kapenaum kamânân zari kâwali a galem a ŋâiŋâ zâkkâren gam itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Kembu, kore anâ sâknam yâmbât okŋaŋgi kiŋ bik bâliŋ oi mirin zem taap.” ");
INSERT INTO kpf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yatâ sâi Yesuŋâ itâ sâm dukuip, “Nâ gam kubikŋaŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yatâ dukui kâwali aŋâ den itâ mâburem dukuip, “Nâ wandâ yatâ, zorat op mirânan mân gâban. Gâ ziren tapŋâ yen denâk sâna ari kore anâ âlip upap. ");
INSERT INTO kpf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nâ a kutâ zeŋgât kore a ândim sâtziŋ luman. Oi nâgât ombenan nâgât kore a ândie. Oi zeŋgâren gâbâ ŋâi âinan sa âibap. Ŋâi gânan sa gâbap. Kore anâ ŋâi nep zo tuu sa tuubap.” ");
INSERT INTO kpf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yatâ sâi Yesuŋâ den zo ŋâŋgi imbaŋâ oip. A molim âiwe, zo itâ dâzâŋgom sâip, “Nâ perâkŋak dâzâŋgobâ. Isirae a zeŋgâren nâŋgâm pâlâtâŋziŋâ itâ mân ekman. ");
INSERT INTO kpf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Zorat itâ dâzâŋgobâ. Hân toren toren gâbâ a doŋbep mindum Anutugât um topŋan Abaram sot Isaka sot Yakobo, zen sot tap sii nalem nimbi. ");
INSERT INTO kpf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Oi Isirae a nâmbutŋâ mârum sumbemgât siŋgi sâm ziŋgâziŋgâŋâ, zen ko âkŋan ŋâtâtigân âimŋâ umbâlâ opŋâ isem ândibi.” ");
INSERT INTO kpf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesuŋâ yatâ sâmŋâ kâwali a patâ itâ sâm dukuip, “Gâ âi. Nâŋgâm pâlâtâŋgaŋgât bonŋâ muyagegibap.” Yatâ sâi zorenâk kore a âlip oip. ");
INSERT INTO kpf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuŋâ Peterogât mirin zâim Petero sibunŋâ mâsek kârâpŋoot op zei egip. ");
INSERT INTO kpf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ekŋâ bikŋan weegi mâsekŋâ buŋ oip. Oi ambân zo zaatŋâ nalem om Yesu pindip. ");
INSERT INTO kpf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Oi mirâ ŋâtiksâisâi a ambân wâkeziŋoot doŋbep diiziŋgâm gawe. Diiziŋgâm gane Yesuŋâ den sâm wâkeziŋâ moliziŋgip. Oi a ambân sisi mâsekziŋoot zo kubikziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yatâ oi Propete Yesaiaŋâ den itâ kulemgoip, zo bonŋâ oip, “Zâk lotŋâniŋ betniŋan mem mâsekniŋ âkoip.” ");
INSERT INTO kpf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","A ambân doŋbepŋâ Yesugâren gam haamgum kine Yesuŋâ ziŋgitŋâ arâpŋâ saru nâmbutken âibigât dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Âinam utne Kembugât gurumin den zorat galem a ŋâiŋâ Yesugâren gam itâ sâm dukuip, “Patâ, gâ zoren mo zoren âibâ sâna moligibat.” ");
INSERT INTO kpf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sâi ko Yesuŋâ itâ mâburem dukuip, “Wâu ulin, zen deŋziŋan ândime. Nii zuu, zen hâŋgootziŋan ândime. A bonŋâ, nâ ko isen korem zo buŋâ ândiman.” ");
INSERT INTO kpf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesugât arâpŋâ, zeŋgâren gâbâ ŋâiŋâ itâ sâm dukuip, “Kembu, nâŋgânina âi ibânâ hangum gâbat.” ");
INSERT INTO kpf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sâi Yesuŋâ itâ sâm dukuip, “Gâ birâm molinina mumuŋâ ziiŋak hanagonek.” ");
INSERT INTO kpf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yatâ sâm waŋgâyân zari arâp zâine âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Âim tatne saruyân pibâ patâ gâi saru bâlim kirip. Oi saruŋâ waŋgâ umŋan giarip. Yesu zâk uman zem tâip. ");
INSERT INTO kpf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Zem tâi arâpŋâ zen âi mâŋgim dukuwe, “Kembu, betniŋan me. Saruyân geinamen.” ");
INSERT INTO kpf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Sâne itâ sâm dâzâŋgoip, “Nâŋgâm pâlâtâŋziŋ lotŋâ, zen wangât umziŋ keŋgât uap?” Yatâ sâm oksâm zaat pibâ sot saru den dâzâkoi hiriŋsâm ziwet. ");
INSERT INTO kpf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Arâpŋâ zen zo ekŋâ imbaŋâziŋ buŋ oi itâ sâwe, “Sâi pibâ sot saru sot kut ŋâi ŋâi, zen sâtŋâ lume. Zâk a dap yatâ?” ");
INSERT INTO kpf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Oi saru nâmbutken âim Gadara a zeŋgât hânân âi takip. Taki a zagât, zet wâkezikŋoot gam Yesu muyagiwet. Zet a mumuŋâ zeŋgât kwagân gâbâ gawet. Zet kwagân ândim kâwali mem ândeitâ a zen zekât keŋgât op gootzikŋan mân âimarâwe. ");
INSERT INTO kpf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Zet den yu kambaŋ sâm itâ sâwet, “Yesu Anutugât nanŋâ, wan otniŋgâbam neŋgâren gaat? Gâ narâk mân mâte oi sâknam patâ niŋgâbam gaat?” ");
INSERT INTO kpf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Oi kârebân bâu kâmut patâ, zen gendâk nem ândiwe. ");
INSERT INTO kpf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Zorat wâke ziŋâ Yesu itâ dukuwe, “Moliniŋgâbâ sâm sâŋgonnâŋgona bâu umziŋan geinâ.” ");
INSERT INTO kpf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sâne ko itâ sâm dâzâŋgoip, “Ba âinek.” Yatâ sâi a umzikŋan gâbâ gam bâu umziŋan geiwe. Baginetâ bâu zen aksik patâ bâkŋan gâbâ tembatŋan koŋkoŋ geim deŋgânân gei mom naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Oi bâu galem a, ziŋâ kamânân zâim bâu zeŋgât siŋgi sot a zagât zekât den siŋgi, zo dâzâŋgom naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Den siŋgi zo dâzâŋgone a ambân aksik patâ, zen Yesu iknam kamânân gâbâ geiwe. Gei ekŋâ Yesuŋâ birâziŋgâm âibapkât dukuwe. ");
INSERT INTO kpf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yatâ utne Yesu zâk waŋgâyân zâim zikŋâ kamânân âbureip. ");
INSERT INTO kpf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Gâi a kiŋ bik mumuŋâ ŋâi helâŋ aam pam mem gawe. Oi Yesuŋâ nâŋgâm pâlâtâŋziŋaŋgât topŋâ ekŋâ a zo itâ sâm dukuip, “Nannâ, mân keŋgât ot. Tosagâ mârum biran.” ");
INSERT INTO kpf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yatâ sâi Kembugât gurumin dengât galem a nâmbutŋâ, zen den zo nâŋgâm umziŋan itâ nâŋgâwe. “Zâk Anutu hutkum sap. Zâk Anutu yatâ op sap.” ");
INSERT INTO kpf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yatâ nâŋgâne Yesuŋâ umziŋan ekŋâ itâ sâm dâzâŋgoip, “Wangât umziŋan nâŋgânâŋgâ bâliŋâ nâŋgânige? ");
INSERT INTO kpf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Zen dap nâŋge? Nep ikâ zorâŋ bâbâlaŋ? Tosa birâbirâŋ mo sâk kubikkubik? ");
INSERT INTO kpf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","A bonŋâ, nâ hânân ândim tosa gulipkubatkât imbaŋâ zemnigap. Zorat topŋâ ikpigât yatâ sâm dukuan.” Yatâ sâmŋâ a kiŋ bik bâliŋ itâ sâm dukuip, “Gâ zaat isen koremgâ mem kamângan âi.” ");
INSERT INTO kpf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","8","Sâi a zo zaatŋâ kamânŋan arip. Oi a ambân kâmut patâ, zen ekŋâ kâwaliziŋ buŋ oi Anutuŋâ imbaŋâ zo a bikŋan pâipkât mâpâsem sâm âlip kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu zâk zobâ âim kât mimiŋ a nâ muyagenigip, kutnâ Mataio. Nâ kât mimiŋ namânan ta nekŋâ itâ dâtnogip. “Gâ nâ sot pâlâtâŋ op molini.” Yatâ sâm dâtnogi zaatŋâ moliwan. ");
INSERT INTO kpf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Oi nâ Yesu mirânan nalem nimbapkât diim zaria kât mimiŋ a sot bâliŋ mâme a doŋbep gamŋâ Yesu sot arâpŋâ nen sot nalem ârândâŋ niwen. ");
INSERT INTO kpf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Yatâ oindâ Parisaio a nâmbutŋâ, zen niŋgitŋâ Yesugât arâpŋâ mâsikâniŋgâwe, “Patâziŋâ zâk wangât kât mimiŋ a sot bâliŋ mâme a, zen sot tap nalem niap?” ");
INSERT INTO kpf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sâne Yesuŋâ den zo nâŋgâmŋâ dâzâŋgoip, “Sisi mâsek kubikkubik a, zâk a sâkziŋ âlip, zeŋgâren nep mân tuumap. Mâsekziŋoot, zeŋgârenâk nep tuumap. ");
INSERT INTO kpf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Zen ko Anutugât den ziap, zorat topŋâ nâŋgâbi. Den zo itâ, ‘Zuu bâu kom om nibigât mân sâwan. Um lâklâk op a buku otziŋgâbigât otnimap.’ A ziiŋaŋgât nen âlipŋâ sâme, nâ zeŋgât buŋâ. Nâ bâliŋ mâme a diiziŋga nâgâren gabigât sâm gem gâwan.” ");
INSERT INTO kpf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Narâk zoren Yohanegât arâpŋâ, zen Yesugâren gam itâ sâm mâsikâwe, “Nen sot Parisaio a narâk nâmbutŋan nalem birâm kendon ândimen. Ka gâgât arâpkâ ko wangât nalem mân birâm ândime?” ");
INSERT INTO kpf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yatâ sâne Yesuŋâ itâ sâm dâzâŋgoip, “A kutâ, zâk a ambân gakârâpŋoot ândei dabân umbâlâ op nalem birâm ândibi? Gâtâm a kutâ betziŋan mine, nârâk zoren umbâlâ op nalem birâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nen hâmbâ sâŋgiŋan, zo hâmbâ uŋakŋâ mân pam gârimen. Hâmbâ uŋakŋandâ sâŋgiŋâ diigi oloŋbapkât yatâ mân upmen. ");
INSERT INTO kpf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Zen waiŋ too uŋakŋâ hâkop sâŋgiŋan mân gune geimap. Yatâ upi, zo ko waiŋ too uŋakŋandâ hâkop sâŋgiŋâ kunziri hâkop sot waiŋ ârândâŋ buŋ upabot. Waiŋ too uŋakŋandâ hâkop uŋakŋan gune giari âlip opmabot.” ");
INSERT INTO kpf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuŋâ yatâ sâm dâzâŋgom kiri mâpâmâpâse namâ galem a ŋâi gam um topŋan pindiŋsâm dukuip, “Bâratnâ irabot zi muap. Diigiga âi sâkŋan weenandâ âlip op zaatpap.” ");
INSERT INTO kpf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yatâ dukum ari Yesu zâk zaat sâi arâpŋâ zâk sot Yairo molim âiwen. ");
INSERT INTO kpf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mâtâbân arindâ ambân ŋâi gâip. Ambân zo gilâm gem ândei kendon patâ kiin zagât oip. Ambân zorâŋ kândâtŋan gamŋâ Yesugât hâmbâ murukŋan weegip. ");
INSERT INTO kpf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ambân zo umŋandâ itâ nâŋgip, “Hâmbâŋik weemŋâ âlipnâ upat.” ");
INSERT INTO kpf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesuŋâ puriksâm ambân zo ekŋâ sâip, “Bâratnâ, gâ mân keŋgât ot. Nâŋgâm pâlâtâŋ kwatnigat, zorat op âlip uat.” Yesuŋâ yatâ sâi zorenâk ambân zo âlip oip. ");
INSERT INTO kpf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Oi Yesu zâk âimŋâ galem agât mirin zâimŋâ girâp kwamit nâŋgip. A ambân doŋbep patâ, zen girâp isem tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesuŋâ nâŋgâm itâ sâm dâzâŋgoip, “Zen zaat geim naŋgânek. Ambân zâk mân muap. Zâk yen uman zem taap.” Yatâ sâm dâzâŋgoi girâŋŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sâi a ambân kâmut patâ zo geim naŋgâne kâmbarâŋâ zeibân âim bikŋan gâsui mumuŋan gâbâ zaarip. ");
INSERT INTO kpf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Oi zorat den siŋgi hân zoren denân denân âragum naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Oi Yesu zâk kamân zo birâm ari a sinzik bâpsâsâŋ zagât, zet molimŋâ den kâtik sâm den sâwet, “Gâ Dawidigât kiunŋâ, nekât umgâ bâliŋ oik.” ");
INSERT INTO kpf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Oi âimŋâ mirin zari a zagât zet zâkkâren zaritâ mâsikâzikâm sâip, “Sinzikŋâ kubikpatkât imbaŋâ zemnigap, zo nâŋgabot?” Oi zet sâwet, “Oŋ, Kembu, net nâŋgâgiget.” ");
INSERT INTO kpf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yatâ sâitâ sinzikŋan weemŋâ sâip, “Nâŋgâm pâlâtâŋzikŋaŋgât bonŋâ muyagezikik.” ");
INSERT INTO kpf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Sâi zorenâk sinzikŋâ ânâŋgârip. Oi Yesuŋâ mân sâbabotkât den kâtikŋâ itâ sâm dâzâkoip, “Zet zirat siŋgi a ambân mân dâzâŋgobabot.” ");
INSERT INTO kpf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Oi a zagât, zet den zo nâŋgâmŋâ âim laŋ dâzâŋgom naŋgitâ siŋgi zo hân dâp laŋ kârâm arip. ");
INSERT INTO kpf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Oi zet aritâ zorenâk a ŋâi wâkeŋoot Yesugâren diim gawe. Zâk wâkeŋâ okŋaŋgi kopa oip. ");
INSERT INTO kpf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesuŋâ wâke zo molei a zo den sâip. A ambân kâmut zoren tarâwe, zen zo ikne imbaŋâ oi sâwe, “Isirae neŋgâren mârum kut ŋâi itâ zo mân âsagei igâwen.” ");
INSERT INTO kpf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Parisaio a ziŋâ ko Yesugât itâ sâwe, “Wâke zeŋgât patâziŋandâ imbaŋâ pindâm mam okŋaŋgi wâke moliziŋgâmap.” ");
INSERT INTO kpf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Oi Yesu zâk yatâ opŋâ kamân patâ sot mâik aksik ândim naŋgip. Oi mâpâmâpâse namâ dâp zâim Kembu um topŋan ândiândiŋaŋgât den dâzâŋgom a ambân sisi mâsekziŋoot kubikziŋgâm ândeip. ");
INSERT INTO kpf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesuŋâ a ambân kâmut patâ zo ziŋgitŋâ umŋâ nâŋgip. Zâkŋâ ziŋgiri râma galem aŋâ buŋâ yatâ gulipmalip ândine ziŋgirip. ");
INSERT INTO kpf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Oi zorat arâpŋâ den sumbuŋâ ŋâi itâ sâm dâtnâŋgoip, “Kâlamân bonŋâ doŋbep ziap, ka nep a ko bituktâ. ");
INSERT INTO kpf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Zorat nep mariŋâ zâkkâren ninâu sâne nep a muyagem sâŋgonzâŋgoi nebân bagim kâlamân bonŋâ mem ândibi.” ");
INSERT INTO kpf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuŋâ arâpŋâ kiin zagât nâŋgonsâi gâindâ wâke moliziŋgânatkât sot sisi mâsek kubikziŋgânatkât imbaŋâ niŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposolo kiin zagât, neŋgât kutniŋâ itâ. Kândom Simoŋ kutŋâ ŋâi Petero, munŋâ Andrea, Zebedaiogât nanzatŋâ Yakobo sot munŋâ Yohane. ");
INSERT INTO kpf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipo sot Batolomaio, Toma sot kât mimiŋ a nâ, kutnâ Mataio, Yakobo Alipaiogât nanŋâ sot Tadaio. ");
INSERT INTO kpf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoŋ Zelote sot Yuda, Karioto kamânân gok. Yuda zâk ândim Yesu tirâpzâŋgoi gâsuwe. ");
INSERT INTO kpf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesuŋâ arâp kiin zagât, nen sâŋgonnâŋgom sâip, “Zen hân ŋâin mân âibi. Samaria zeŋgât kamânân mân zâibi. ");
INSERT INTO kpf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isirae a kâmurân gâbâ râma yatâ gulipmalip ândiândiŋ, zo zeŋgârenâk âibi. ");
INSERT INTO kpf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Âim siŋgi âlip itâ sâm dâzâŋgom ândibi, ‘Anutugât um topŋan ândinatkât narâk mâte uap.’ ");
INSERT INTO kpf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sisi mâsek kubikziŋgâbi. Mumuŋâ mâŋgiziŋgâbi. Sâk bâlâ kubikziŋgâne âlip upi. Wâkeziŋoot moliziŋgâbi. Oi Anutuŋâ kut ŋâi ŋâi sâŋgân buŋ ziŋgip, yatigâk zeŋgoot a otziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kât patâ mo mâik mân mem âibi. ");
INSERT INTO kpf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mâtâpkât irâ mân mem âibi. Hâmbâ zâgât mân mem âibi. Kipâke buŋ, sot tân mân mem âibi. Bet bâsaŋâk âibi. Nep a zen nalem mot sâŋgân buŋâ ziŋgâne dâp upap. ");
INSERT INTO kpf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kamân patâ mo mâigân takâm mirin tâtat mâme upi, zorat topziŋâ sâm mâsikâziŋgâbi. A ŋâigât ek nâŋgâne âlip oi zâkkât mirin zâim tâtat mâme op tap ko kamân zo birâm âibi. ");
INSERT INTO kpf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mirâziŋan zâim itâ sâm dâzâŋgobi. ‘Um lumbeŋâ zeŋgâren zimbap.’ ");
INSERT INTO kpf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Oi mirâ mariŋandâ ândei dâp oi dinziŋâ zâkkâren bonŋâ upap. Ka mirâ mariŋandâ ândei mân dâp oi lumbeŋâ dinziŋaŋgât bonŋâ âburem ziiŋan gâbap. ");
INSERT INTO kpf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Oi mirâ kamân ŋâin birâziŋgâm dinziŋaŋgât âkonziŋgi kinziŋan gwapgwap lâŋne gei birâziŋgâm âibi. ");
INSERT INTO kpf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nâ perâkŋak dâzâŋgobâ. Den kubikkubik narâkŋan Anutuŋâ Sodom sot Gomora kamân mâirâp, zen hâuŋâ mem gei kwap otziŋgâbap. Ka kamân zorat a, zo ko hâuŋâ mem zâi kwap otziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nâŋgânek. Râma wâu hulin zeŋgât oserân mân sâŋgonzâŋgozâŋgoŋ, zo nâŋâ ko zen sâŋgonzâŋguan. Zorat zen a sarâ buŋâ, nâŋgânâŋgâziŋoot târârak ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Zen a ziŋ tâmbetzâŋgobegât gasâziŋ kârâm ândibi. A zen den sâsâŋ namin diiziŋgâm âibi. Mâpâmâpâse namâziŋan zâmbamŋâ lapitziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Oi zorigâk buŋâ. Zen nâgât a ândie, zorat opŋâ a kutâ zeŋgâren diiziŋgâm âine den nep tuubi. Oi zen zeŋgât mâteziŋan kinŋâ a kutâ sot hân ŋâin gokŋâ nâgât topnâ sapsum ziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Zen a kutâgâren zâmbane den dap sânâ sâm mân nâŋgâm kwâkâ upi. Narâk zoren den sâbi, zo Kaapumŋâ ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yatâ otziŋgi den sâne zo zeŋgât den mân upap. Ibâziŋaŋgât Kaapum umziŋan pâmbap, zâkkât den upap. ");
INSERT INTO kpf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Narâk zoren âtâŋâ ŋâiŋâ munŋâ sâi kumbi. Oi ibâ ŋâiŋâ sâi nanŋâ kumbi. Oi nan bârat, zen ibâ mam kâsa otziŋgâm sâne zâŋgobi. ");
INSERT INTO kpf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kutsiŋginaŋgât op a doŋbepŋâ zeŋgât um kâlak nâŋgâziŋgâbi. Oi ŋâi zâk den siŋgi âlip mem kâtigem kinbap, zâk narâk âki sumbem kamânân bagibap. ");
INSERT INTO kpf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Zen kamân ŋâin ândinetâ zâŋgom moliziŋgânetâ kâmân ŋâin âibi. Nâ perâkŋak dâzâŋgobâ. Isirae kamân dâp tap ariap, zo âine mân âki a bonŋâ nâ takâbat.” ");
INSERT INTO kpf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ekap namin katepŋâ a kwâkâm pindâmap, zâk mân walâmap. Kore aŋâ a patâŋâ mân walâmap. ");
INSERT INTO kpf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ekap namin katepŋâ patâŋaŋgât holi zorik mei dâp upap. Kore âŋâ patâŋaŋgât holi zorik mei dâp upap. Bâliŋ mâme a, ziŋ nâgât Bezebulu sâwe. Sâm bâliŋ kwatniwe yatik mâte pirik mem zâi kwap otziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Zorat sa nâŋgânek. A zo zeŋgât op mân keŋgât upi. Kut ŋâi ŋâi tik ziap, zo zemŋâ mân zimbap. Kut ŋâi ŋâi kwârakukuŋ, zo zemŋâ mân zimbap. Zo aksik mâbâlakŋem naŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nâ ŋâtigân den tik dâzâŋgoman, zo a kâmut zeŋgât mâteziŋan sapsubi. Den halop dâzâŋgowan, zo sombemân kin dâzâŋgobi. ");
INSERT INTO kpf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Sâkziŋik zâŋgobi, zeŋgât mân keŋgât upi. Zen um dâpziŋ mân tâmbetkubi. Ŋâigât keŋgât upi. Sâkkâ sot um dâpkâ ârândâŋ sim kârâbân gâbanbapkât imbaŋâ zemŋâŋgap, Anutu, zâkkât keŋgât op ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nii sâmbâlâle, zâk sâŋgânŋâ patâ buŋâ. Kât kuriŋâ mâik kânok pam zagât mimban. Oi Ibâziŋandâ mân nâŋgi ko dap op sâmbâlâle ŋâi gei kumbap? ");
INSERT INTO kpf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Anutu zâk a zeŋgât kâukziŋ sâmotŋâ zorat teŋgâŋâ nâŋgâm naŋgâmap. Zorat zen keŋgâtziŋ buŋ ândibi. Zen sâmbâlâle yatâ buŋâ. Zen a. Anutu zâk zeŋgât umŋâ patâ kinmap.” ");
INSERT INTO kpf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ŋâi zâk a ambân zeŋgât mâteziŋan sâm âlip kwatnibap, zâk yatigâk nâŋâ sumbem Ibânaŋgât mâteŋan sâm âlip kwâkŋaŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ŋâi zâk a ambân zeŋgât mâteziŋan kwâimbânigi zâk nâŋâ yatigâk sumbem Ibânaŋgât mâteŋan kwâimbâŋaŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Zen nâgât itâ mân sâbi, ‘Zâk lumbe muyagibapkât geip.’ Nâ lumbeŋâ buŋâ, kâmbam âbâŋgubapkât gewan. Nâ kâsâpzâŋgobatkât gem gâwan. Zen dinnaŋgât op kâsâpagom ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Zorat nanŋâ sot ibâŋâ, zet kâsâpagobabot. Bâratŋâ sot mamŋâ, zet kâsâpagobabot. Iranŋâ sot sibunŋâ, zet kâsâpagobabot. ");
INSERT INTO kpf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","A ŋâi zâkkât kiŋ topŋan gâbâ kâsa okŋaŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Oi ŋâi zâk umŋâ ibâ mamzik zet sot pâlâtâŋ op nâ sot bituk pâlâtâŋ upap, zâk zo nâgât siŋgi mân op ândibap. Ŋâi zâk umŋâ murarâp zen sot pâlâtâŋ op nâ sot bituk pâlâtâŋ upap, zâk yatik nâgât siŋgi mân ândibap. ");
INSERT INTO kpf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Oi ŋâi zâk zikŋâ poru nakŋâ mân lum nâgât mâtâp lâŋbap, zâk zo yatik nâgât siŋgi mân upap. ");
INSERT INTO kpf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ŋâi zâk ândiândiŋâ aŋgân kâri gulipkuŋaŋgâbap. Oi ŋâi zâk nâgât opŋâ hânân ândiândiŋâ birâm ândiândiŋ âlipŋâ muyagibap.” ");
INSERT INTO kpf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“A ŋâiŋâ zen galem otziŋgâbap, zâk zo yatik kore otnibapŋâ sâŋgonnogip yatik okŋaŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ŋâi zâk Propete a ŋâi on galem okŋaŋgâbap, zâk Propetegât dâp yatik sâŋgân mimbap. Ŋâi zâk a târârakŋâ galem okŋaŋgâbap, zâk a târârakŋaŋgât dâp sâŋgân mimbap. ");
INSERT INTO kpf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nâ perâkŋak dâzâŋgobâ. Ŋâiŋâ a gigiŋâ zeŋgâren gâbâ nâgât siŋgi ândiap, zo too pateŋ aam pindâbap, zo ko sâŋgânŋâ buŋ mân zimbap.” ");
INSERT INTO kpf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuŋâ arâpŋâ kiin zagât den dâtnâŋgom naŋgâm kamân ŋâin siŋgi âlip dâzâŋgobam arip. ");
INSERT INTO kpf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohane tâk namin tap Kristoŋâ nep tuugip, zorat siŋgi nâŋgâm arâp den mâsikâbigât sâŋgonzâŋgoi Yesugâren âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Yesugâren âimŋâ itâ sâm mâsikâwe, “Mârumŋan Propete a, ziŋâ a ŋâi gâbapkât sâwe, zo gâ mo ŋâigât mambât ândinat?” ");
INSERT INTO kpf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Zen âburem âimŋâ kut ŋâi ŋâi ek nâŋge, zorat siŋgi Yohane dukubi. ");
INSERT INTO kpf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Sen ŋâtâtikŋâ sinziŋ ânâŋgâtsap. Kinziŋ bâliŋâ mâtâp lâŋ âim ge. Sâk bâlâ a sâkziŋ âlip uap. Kindapziŋ bâpsâsâŋ, zo den nâŋge. Mumuŋandâ zaatse. A ambân kanpitâ, zen lâunan gâbâ den siŋgi âlip nâŋge. ");
INSERT INTO kpf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ŋâi zâk nâgât nâŋgi mân âkon upap, zâkkât nâŋga sâtâreŋoot uap.” ");
INSERT INTO kpf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Oi Yohanegât arâp, zen âburem âine Yesuŋâ a ambân zâk sot ândiwe Yohanegât topŋâ itâ sâm dâzâŋgoip, “Zen mirâ kamân âtâŋan, a mân ândiândiŋan wan iknam âiwe? Gerâ ŋâi pibâŋâ koi âim gam kiri iknam âiwe? ");
INSERT INTO kpf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mo a ŋâi hâmbâ neuleŋoot iknam âiwe? Zen nâŋge. A hâmbâziŋ neuleŋoot, zen a kutâ zeŋgât mirin tapme. ");
INSERT INTO kpf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mo zen Propete ŋâi iknam âiwe? Zorat nâ dâzâŋgua nâŋgânek. Zen a igâwe, zo Propete nâmbutŋâ zeŋgât dâp buŋâ. Zâk tobat ŋâi. Nâmbutŋâ zo walâziŋgap. ");
INSERT INTO kpf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","A zorat den kulem ŋâi itâ ziap, ‘Nâŋgâ. Nâgât kore a ŋâi sâŋgongua kândom otgibap. Zâkŋâ mâtâpkâ kârâm kubikpap.’ ");
INSERT INTO kpf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nâ perâkŋak dâzâŋgobâ. Ambân zeŋgâren gâbâ âsagiwe, nâmbutŋâ zeŋgâren gâbâ ŋâiŋâ Yohane mân wâlap. Ka a gigiŋâ ŋâiŋâ Anutu um topŋan ândibapŋâ, zâk walâbap. ");
INSERT INTO kpf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yohane too saŋgon nep topkwâip, narâk zoren gâbâ a ambân doŋbep, zen sumbemgât siŋgi upigât kâtigiwe. Oi a kâwaliziŋootŋâ sumbem kamân zo baginam kâtigie. ");
INSERT INTO kpf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Propete a sot Mose, zen zorat den kânŋan sâm kulemgum gane Yohanegâren âkip. ");
INSERT INTO kpf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Den zi umziŋâ gâsui nâŋgânâ sâm, nâŋgânek. Elia gâbapkât sâwe, zorat bonŋâ Yohane gâip. ");
INSERT INTO kpf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ŋâi zâk kindapŋootŋâ den zi nâŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","A kâmut zi, waniŋ zen sot dâpkwap sâbâ? Zen katep yatâ. Katep ziŋâ ek birâ, nâŋgâm birâ upme. A ambân kâmut zi zo yatâ. Katep, zen kamân sombemân tap bukurâpziŋ itâ sâm dâzâŋgome, ");
INSERT INTO kpf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kep meindâ wangât mân kue? Nen umbâlâ kep meindâ wangât mân isie?’ ");
INSERT INTO kpf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohane zâk nepŋâ topkwap too kâtik sot nalem birâm ândei ekŋâ sâwe, ‘Zâk wâkeŋoot ândiap.’ ");
INSERT INTO kpf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A bonŋâ nâŋâ gamŋâ nalem sot too nia nekŋâ itâ sâme, ‘Iknek. A zi kât mimiŋ a sot bâliŋ mâme a, zeŋgât buku. Waiŋ sot nalem nem mân birâmap.’ Ka sa nâŋgânek. Anutugât nâŋgânâŋgâ bon asâgem topŋâ mem kâkŋan kwâpmap.” ");
INSERT INTO kpf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Narâk zoren Yesuŋâ kamân nâmbutken nep tuugi ekŋâ umziŋ mân melâŋâwegât den topkwap sâm topziŋ itâ sâm muyageip, ");
INSERT INTO kpf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Yei, Koraziŋ mâirâp, Yei, Besaida mâirâp, zeŋgâren nep patâ kulem top top muyageip. Kulem yatâ zo Tiro sot Sidoŋ kamânân muyagei sâi zen mârumŋan isem umbâlâ opŋâ umziŋ melâŋbe. ");
INSERT INTO kpf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Zorat dâzâŋgua nâŋgânek. Tiro Sidoŋ kamân mâirâp, zen den kubikkubik narâkŋan hâuŋâ diim gei otziŋgâbap. Zen ko hâuŋâ mem zâi pam otziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapenaum mâirâp, zen dap upi? Sumbemân zâibi? Buŋâ. Zen sim kârâbân kâbakŋeziŋgâbap. Zeŋgâren kulem top top muyageip. Kulem zo Sodom sot Gomora kamânân muyagei sâi kamân zo mân buŋ op narâk ziren tok tâpap. ");
INSERT INTO kpf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Zorat dâzâŋgua nâŋgânek. Den kubikkubik narâkŋan Sodom kamân mâirâp, zen hâuŋâ mem gei kwap otziŋgâbap. Zen ko hâuŋâ mem zâi kwap otziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Narâk zoren Yesuŋâ Kembugâren den itâ sâip, “Ibâ, hân sot sumbem mariŋâ, gâ âlip opmat. A ziiŋâ nâŋgânâŋgâziŋaŋgât nâŋgâne zâizâiŋ opmap, zo diŋgâ tik kwatziŋgâmat. Ka a umziŋan gigiŋâ upme, zen ko diŋgâ sâm muyageziŋgâmat. Oi nâ zorat sâm âlip kwatgigan. ");
INSERT INTO kpf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kembu, gâ yatâ muyagem âibapkât nâŋgâna âlip oip.” ");
INSERT INTO kpf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ninâu yatâ sâmŋâ arâpŋâ nen itâ sâm dâtnâŋgoip, “Ibânâ, zâk kut ŋâi ŋâi nâgât siŋgi sâm bitnan pam naŋgip. Umnan den sot nâŋgânâŋgâ ziap, zo mân nâŋge. Ibânâ zâk zikŋik nâŋgap. Oi Ibânaŋgât umŋan den sot nâŋgânâŋgâ ziap, zo mân nâŋge. Nâ ninik nâŋgan. Oi nâŋâ a nâmbutŋâ Ibânaŋgât topŋâ sâm muyageziŋga âlip nâŋgâm kwâkâbi.” ");
INSERT INTO kpf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kut ŋâi ŋâi yâmbâtŋâ tuum kâbâ yâmbât sot sâknam nâŋgâm ândime, zen aksik nâgâren gane gâsuziŋga um sâkziŋâ sânduksâbap. ");
INSERT INTO kpf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nâ umnandâ mulun op gigiŋâ op ândimangât nâgâren gane nep ârândâŋ tuum ândinat. Oi um dâpziŋandâ lumbeŋâ muyagem ândibap. ");
INSERT INTO kpf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nâ sot kin nep tuutuuŋ, zo bâbâlaŋ. Nâgât nep, zo bâbâlaŋ.” ");
INSERT INTO kpf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Narâk zoren Yesuŋâ kândom otniŋgi kendonân kâlamân obândiwen. Âimŋâ arâp nen tepniŋaŋgât opŋâ segoŋ keet namuŋ niwen. ");
INSERT INTO kpf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Yatâ oindâ Parisaio a, ziŋ zo ekŋâ Yesu dukum sâwe, “Ek. Arâpkâ ziŋ kut zo ue, zo kendonân mân orotŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sâneta itâ sâm dâzâŋgoip, “Dawidi sot arâpŋâ, zen tepkât opŋâ urâwe, zo sâlâpkum nâŋgâme mo buŋâ? ");
INSERT INTO kpf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Zâk Kembu Anutugât namâ zo zâim nalem hâlâlu sâsâŋâ, zo mei niwe. Nalem zo zâk sot arâpŋâ niwe. Zo mân orotŋâ. Namâ galem ziiŋik nimbigât sâsâŋ. ");
INSERT INTO kpf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Anutugât gurumin den ekabân den itâ sâlâpkum nâŋgâme? Tirik namâ galem a, zen Yuda zeŋgât kendonân tirik namin âim nep tuum gurumin den zo kume, zorat tosaŋâ mân opmap. ");
INSERT INTO kpf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Zen Kembugât namâ zo hâlâlu sâme, Ka nâŋâ ko dâzâŋgua nâŋgânek. Nâ mâteziŋan kinzan, nâ walâwalâŋ. Namâ zo gigiŋâ. ");
INSERT INTO kpf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Anutugât den kulem ŋâi itâ ziap, ‘Bâu zuu kom om nibigât mân sâwan. Um lâklâk op a buku otziŋgâbigât otnigap.’ Zen den zirat topŋâ nâŋgâm sâi a tosaziŋ buŋâ den laŋ ŋâi mân dâzâŋgobe. ");
INSERT INTO kpf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","A bonŋâ, nâ kendongât mariŋâ op ândian.” ");
INSERT INTO kpf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yatâ sâmŋâ zobâ âim mâpâmâpâse namin zarip. ");
INSERT INTO kpf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Zoren a ŋâi tâip. Zâk bikŋâ humutŋik. Oi a ziŋâ Yesu mâsikâm sâwe, “A kendonân kubikziŋgâziŋgâŋ, zo orotŋâ mo mân orot?” ");
INSERT INTO kpf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sâne Yesuŋâ lâuziŋan mem itâ sâm mâsikâziŋgip, “Zeŋgâren gâbâ a ŋâiŋâ râmaŋâ kânok lâmân giari ko kendongât op birâbap? Yatâ mân upap. ");
INSERT INTO kpf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Râma zâk yenŋâ. A zen ko bonŋâ, zorat kendonân âlip orotŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yatâ sâmŋâ a zo itâ sâm dukuip, “Bikâ tâŋtâŋ pa.” Sâi bikŋâ tâŋtâŋ pâi âlip op toren yatâ oip. ");
INSERT INTO kpf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yatâ oi Parisaio a, zen zo ekŋâ âimŋâ zâk dap yatâ kunat sâm den âraguwe. ");
INSERT INTO kpf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuŋâ den zo nâŋgâm kamân zo birâm ŋâin arip. A doŋbep patâŋâ molinetâ kubikziŋgâm naŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Zen zâkkât topŋâ zo a ambân mân dâzâŋgobigât den sâm kâtigeip. ");
INSERT INTO kpf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yatâ oi Propete Yesaiaŋâ mârumŋan Anutugât den kulemgoip, zo bonŋâ oip. Den zo itâ, ");
INSERT INTO kpf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Zen nannâ iknek. Nâ zâk gâsum sâlâpkuan. Zâk nannâ âlipŋâ. Zâkkât umnâ kinmap. Nâ Kaapumnâ pinda bekŋan mei hân toren toren a zeŋgâren den kubikkubikŋâ sâm haŋpâmbap. ");
INSERT INTO kpf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Zâk den sârek mân sâbap. Kamân sombemân mân kwamitagoi nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gerâ âbâbâŋgum, zo mân kârâm mânâŋgât pâmbap. Oi kârâp tirâp mân biri bâpsâbap. Yatâ op nep tuum ândim den târârak sâm kubikmubik oi târârak op kâtigem zimbap. ");
INSERT INTO kpf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yatâ oi a ambân hân toren toren, zen zâkkât kutsiŋgiŋan târokwapi.” ");
INSERT INTO kpf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nârâk zoren wâkeŋâ a ŋâi okŋaŋgi kopa op siŋ bâpsâsâŋ op ândei Yesugâren diim âiwe. Âine Yesuŋâ a zo kubigi siŋâ ânâŋgâri ekŋâ den sâip. ");
INSERT INTO kpf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A ambân kâmut kirâwe, zen zo ekŋâ imbaŋâziŋ buŋ oi itâ sâwe, “Dawidigât kiun gâbapkât sâsâŋâ, zo zi mot ŋâi.” ");
INSERT INTO kpf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Sâne Parisaio a, ziŋâ den zo nâŋgâm itâ sâwe, “Zo sarâ. Wâke zeŋgât a kutâ kutŋâ Bezebulu, zâkŋâ mam okŋaŋgi wâke moliziŋgâmap.” ");
INSERT INTO kpf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Zen yatâ sâne Yesuŋâ umziŋan ekŋâ itâ dâzâŋgom sâip, “Hân ŋâigât a, zen kâsa utnetâ hânziŋ zo kwamen zimbap. Oi kamân ŋâigât a mo mirâ ŋâigât a, zen kâsa utne mirâ kamânziŋ buŋ upap. ");
INSERT INTO kpf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satâŋ sot arâpŋâ, zen kâsa utnetâ nepziŋâ dap yatâ kâtigem zimbap? ");
INSERT INTO kpf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Zen nâgât itâ sâme, ‘Bezebuluŋâ mam okŋaŋgi wâke moliziŋgâmap.’ Oi zeŋgât narâpziŋâ ŋâiŋâ mam otziŋgi wâke moliziŋgâme? Sarâziŋaŋgât topŋâ zo narâpziŋandâ muyagibi. ");
INSERT INTO kpf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nâ ko Anutugât Kaapumŋâ mam otnigi wâke moliziŋgâman. Anutugât um topŋan ândiândigât narâkŋâ mâte otziŋgi mân nâŋge. ");
INSERT INTO kpf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","A ŋâi, zâk mirâŋan kâwali op tâi dap yatâ a ŋâiŋâ zâim sikum bekŋan mimbap? Yatâ buŋâ. Kâwali a zo komŋâ kiŋ bik saam pamŋâ sikumŋâ âlip bekŋan mimbap.” (Yesuŋâ den zo Sataŋgât op sâip.) ");
INSERT INTO kpf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yatâ sâmŋâ itâ sâip. “Ŋâi zâk buku mân otnibapŋâ, zâk kâsa otnibap. Ŋâi zâk nepnâ mân galem upapŋâ, kândaŋbap. ");
INSERT INTO kpf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Zorat dâzâŋgua nâŋgânek. Bâliŋâ top top sot den sumunŋâ top top, zorat tosa birâbirâŋ ziap. Ka ŋâi zâk Tirik Kaapum sâm bâliŋ kwâpap, zâkkât tosa birâbirâŋ mân ziap. ");
INSERT INTO kpf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ŋâi zâk a bonŋâ nâ sâm bâliŋ kwatnibap, zâkkât tosa âlip gulipkubap. Ka ŋâi zâk Tirik Kaapum sâm bâliŋ kwâpap, zo ko tosaŋâ hânân sot Sumbemân mân gulipkubap. ");
INSERT INTO kpf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Zen nak ŋâigât âlipŋâ sâm bonŋaŋgât yatik âlipŋâ sâbi. Mo nak ŋâigât bâliŋâ sâm bonŋaŋgât yatigâk bâliŋâ sâbi. Nak zo bonŋandâ nak topŋâ sâm muyagemap. ");
INSERT INTO kpf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Zen mulumgât kiurâp. Bâliŋandâ wan den âlipŋâ sâbi. Umziŋan kut ŋâi ŋâi zemap, zo yatik lâuziŋan kopgâmap. ");
INSERT INTO kpf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A târârakŋândâ umŋan gâbâ den âlipŋâ kopgâmap. A ŋâi nâŋgânâŋgâ bâliŋâ, zâkkât umŋan gâbâ den bâliŋâ kopgâmap. ");
INSERT INTO kpf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nâ dâzâŋgua nâŋgânek, Den kubikkubik narâkŋan den sarâ top top, zorat hâuŋâ Anutuŋâ ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Den sâmat, zorâŋ topkâ sâm muyagei gâsu gobap. Mo den sâmat, zorâŋ topkâ muyagei birâgibap.” ");
INSERT INTO kpf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yatâ sâm dâzâŋgoi Kembugât gurumin den zorat galem a sot Parisaio a nâmbutŋâ, zen itâ mâburem dukuwe, “Patâ, top lâkulâku kulem ŋâi tuuna âsagei iknâ.” ");
INSERT INTO kpf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sânetâ itâ sâm dâzâŋgoip, “A kâmut zi orot mâmeziŋâ bâliŋâ sot Kembugât den birâbirâŋ. A yatâ zorâŋ top lâkulâku kulemgât sâme. Zen kulem ŋâi mârâtŋâ buŋâ. Propete Yonagâren muyageip, zo yatâ muyagei ikpi. ");
INSERT INTO kpf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona zâk sirâm karâmbut saru zuu patâgât umŋan gei zeip. Zo yatigâk a bonŋâ, nâ sirâm karâmbut hân umŋan zimbat. ");
INSERT INTO kpf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Zorat ko den kubikkubik narâkŋan Niniwe kamân mâirâp, zen gam a kâmut zi zeŋgât topziŋ sâne hâuŋâ yâmbâtŋâ patâ mimbi. Wangât, Niniwe kamân mâirâp, zen Yonaŋâ den girem dâzâŋgoi nâŋgâm umziŋâ melâŋâwe, zorat. Na sa nâŋgânek. Nâ zi kinzan, nâ Yona wâlan. ");
INSERT INTO kpf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Oi ambân kutâ hân torengen gâbâ Salomogâren gâip, zâk yatik den kubikkubik narâkŋan kâmut zi zeŋgât tosaziŋ sapsubap. Wangât, ambân zorâŋâ hân kârebân gâbâ gam Salomogâren den nâŋgânâŋgâ bonŋâ mimbam gâip, zorat. Oi nâ zi kinzan, nâ Salomo wâlan. Zen wangât op nâgât den birâme?” ");
INSERT INTO kpf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Wâkeŋâ a umân gâbâ takâm gam hân a mân ândiândiŋan âi ândim tâtat mâmeŋâ kârubap. ");
INSERT INTO kpf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kârumŋâ sâbap, ‘Nâ mirânâ birâm gâwan, zoren âibâ.’ Sâmŋâ âburem âi ikpap. Egi mariŋâ buŋâ, saŋgon kubikkubikŋâ. ");
INSERT INTO kpf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yatâ ekŋâ âim wâke bukurâpŋâ nâmburân zagât, zikŋâ dâp buŋâ, bâliŋ kâtikŋâ, zo sâi ga mirâ zorenâk tâtat mâme upi. Oi a zo mârum bâliŋâ ândeipŋâ bet bâliŋ op kwâtâtibap. Bâliŋ mâme a kâmut zi, zeŋgâren yatik muyagibap.” ");
INSERT INTO kpf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu zâk den yatâ sâm dâzâŋgom kiri kândâtziŋan Yesugât mam murâpŋâ, zen gam den dukunam mambât kirâwe. ");
INSERT INTO kpf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mambât kinetâ a ŋâiŋâ Yesu itâ sâm dukuip, “Nâŋgâ. Mamgâ murâpkâ, zen den dâgonam kândâtniŋan ga kinze.” ");
INSERT INTO kpf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sâi Yesuŋâ itâ sâm dukuip, “Mam murâpnâ waniŋ ziŋâ?” ");
INSERT INTO kpf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yatâ sâmŋâ arâp kirâwe, zeŋgâren bikŋâ pamŋâ itâ sâm dâzâŋgoip, “Ziŋgitnek. Mamnâ murâpnâ zi te. ");
INSERT INTO kpf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sumbem Ibânaŋgât sâtŋâ nâŋgâm lume, zen ko nâgât mamârâpnâ mun garâpnâ ue.” ");
INSERT INTO kpf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sirâm zoren Yesuŋâ mirin gâbâ gem saru sâtŋan âi tâip. ");
INSERT INTO kpf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Âi tâi a ambân kâmut patâ zâkkâren mindune ziŋgit waŋgâ ŋâin zarip. Oi zâk waŋgâyân tâi a ambân doŋbep patâ, zen sagân kirâwe. ");
INSERT INTO kpf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Zen sagân kinetâ den sumbuŋâ top top sâm dâzâŋgoip. Ŋâi ko itâ sâip, “Nâŋgânek. A ŋâiŋâ keet maandiŋbam nebân arip. ");
INSERT INTO kpf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Âi maandiŋi keet nâmbutŋâ mâtâbân gei zei nii ziŋâ ga niwe. ");
INSERT INTO kpf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oi keet nâmbutŋâ hân siŋitŋan gei zeip. Zoren hân mâiktârâ kwâkŋanâk, zorat kek takip. ");
INSERT INTO kpf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ândâŋâ kârep mân giari maaŋâ egi hâlâlâŋsâm moip. ");
INSERT INTO kpf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Keetŋâ nâmbutŋâ hibuk osetŋan gei zeip. Gei zemŋâ kâmŋâ taki hibukŋâ kwârakoipkât moip. ");
INSERT INTO kpf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Keet nâmbutŋâ ko hân âlipŋan gei zem bonŋâ doŋbep âsageip. Topŋâ ŋâigât keetŋâ 1 handeret. Topŋâ ŋâigât keetŋâ 60. Topŋâ ŋâigât 30. Bonziŋâ yatâ âsageip. ");
INSERT INTO kpf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Zorat ŋâi zâk kindapŋootŋâ den zi nâŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Den yatâ sâm dâzâŋgoi arâpŋâ nen um topŋan gam mâsikâm sâwen, “Gâ wangât den sumbuŋâ dâzâŋgomat?” ");
INSERT INTO kpf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sâindâ zâkŋâ itâ dâtnâŋgoip, “Anutu um topŋan bagibagiŋâ, zorat den sumbuŋâ ziiŋâ nâŋgâm kwâtâtibigât sâsâŋ. A nâmbutŋâ, zen buŋâ. ");
INSERT INTO kpf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ŋâi zâk den nâŋgânâŋgâŋâ, zo mem ândei Anutuŋâ târokwap pindâbap. Oi nâŋgânâŋgâ patâ upap. Ka ŋâi zâk den nâŋgânâŋgâ pindip, zo mân mem ândei bekŋan mimbap. Oi yen ândibap. ");
INSERT INTO kpf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","A nâmbutŋâ, zen sinziŋâ ekŋâ mân ek kwâtâtibi. Oi kindapziŋandâ den nâŋgâm mân nâŋgâm kwâtâtibi. Zorat op den sumbuŋâ dâzâŋgoman. ");
INSERT INTO kpf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Oi mârumŋan Propete Yesaiaŋâ kânŋan den sâip, den zo bonŋâ uap. Den zo itâ, ‘Kindapziŋandâ den nâŋgânâŋgâ, zo nâŋgâbi. Ka umziŋandâ ko mân nâŋgâm kwâtâtibi. Sinziŋandâ igikŋâ, zo ikpi. Ka zorat topŋâ, zo mân ek kwâtâtibi. ");
INSERT INTO kpf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","A ambân kâmut zi, zen um kâtik. Kindapziŋ bâpsâsâŋ. Sinziŋandâ mân ek kwâtâtibi. Umziŋandâ mân nâŋgâm kwâtâtibi. Umziŋ mân melâŋne ko nâ dap yatâ kubikziŋgâbat?’ ");
INSERT INTO kpf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Zen ko sinziŋâ âlip ikme. Kindapziŋ âlip nâŋgâme. ");
INSERT INTO kpf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Zorat zeŋgât nâŋga âlip uap. Nâ perâkŋak dâzâŋgobâ. Mârumŋan Propete sot a târârakŋâ doŋbep, zen kut ŋâi ŋâi zen ek nâŋgâme, zo ek nâŋgânam osimŋâ mân ek nâŋgâwe.” ");
INSERT INTO kpf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Oi zi keet maamaadiŋ den, zorat topŋâ dâzâŋgua nâŋgânek. ");
INSERT INTO kpf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Keetŋâ mâtâbân gei zeip, zorat dâp a nâmbutŋâ ândime. Zen siŋgi âlip naŋgâne umziŋan mân giari bâliŋâ mariŋandâ gamŋâ zo bekŋan memap. ");
INSERT INTO kpf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Keetŋâ hân siŋitŋan gei zeip, zorat dâp a nâmbutŋandâ ândime. Zen siŋgi âlip nâŋgâm âkŋâlem ândime. ");
INSERT INTO kpf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Umziŋan ko ândâŋâ mân gâsuipkât narâk pâŋkânok mem ândine sâknam mo zâŋgom tâk namin pâpan, zo âsagei kektâ lorem birâme. ");
INSERT INTO kpf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Keetŋâ hibuk kwâkŋan gei zeip, a nâmbutŋâ zen yatâ ândime. Zen siŋgi âlip zo nâŋgâmŋâ sâkkât kut ŋâi sot kât sikumgât âkŋâle op ândine umziŋan bon mân âsagei bonŋâ buŋ op gukupitŋâ upap. ");
INSERT INTO kpf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Keetŋâ hân âlipŋân gei zeip, zo a nâmbutŋâ zo yatâ ândime. Zen den siŋgi âlip nâŋgâm umziŋan gei mem ândime. Oi ŋâigâren bonŋâ 1 handeret, ŋâigâren 60, ŋâigâren 30. Bonŋâ yatâ âsagemap.” ");
INSERT INTO kpf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuŋâ den sumbuŋâ ŋâi itâ sâm dâzâŋgoip, “Sumbemgât den siŋgi âlip, zorat mâtâp zi itâ. A ŋâiŋâ nepŋan âi keet maandeŋip, zoren dâpkwap sâbâ. ");
INSERT INTO kpf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Keetŋâ maandiŋâ ari a uman zine narâk zoren kâsaŋâ gam hibuk keetŋâ maandiŋâ arip. ");
INSERT INTO kpf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Oi keet zo takâm bon upâ sâi hibuk ârândâŋ takâwe. ");
INSERT INTO kpf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Oi kore a, zen zo ekŋâ nep mariŋâ dukum sâwe, ‘Patâniŋâ, gâ nepkan keet âlipŋâ maandeŋin. Oi Hibuk zo waniŋ gâbâ tâkap?’ ");
INSERT INTO kpf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mâsikâne sâip, ‘Kâsa ŋâiŋâ maandeŋi âsageip.’ Yatâ sâi mâsikâwe, ‘Nen âi sâmbum panâ?’ ");
INSERT INTO kpf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Sâne itâ dâzâŋgoip, ‘Buŋâ. Zen hibuk sâmbum kâmŋâ zo sâmbubegât birâbi. ");
INSERT INTO kpf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Zo yenâk zimbabot. Oi bonŋâ mimiŋ narâk oi nep a itâ sâm dâzâŋgobat, “Kândom zen hibuk zo sâmbum buraŋ saam kârâbân umbi. Bet ko bonŋâ âlipŋâ mine mirânan zâibap.” ’” ");
INSERT INTO kpf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Den sumbuŋâ ŋâi itâ sâm dâzâŋgoip, “Sumbemgât den siŋgi âlip, zorat mâtâp, zo wakum keetŋâ yatâ. A ŋâiŋâ keetŋâ zo nepŋan pâip. ");
INSERT INTO kpf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Keetŋâ zo mâiktârâ. Keetŋâ nâmbutŋâ zeŋgât ombeziŋan. Zo kâmŋâ takâm zâim walâziŋgâm nak patâ opmap. Oi nii zen gam bâranŋan pam tapme.” ");
INSERT INTO kpf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Oi den sumbuŋâ ŋâi itâ sâm dâzâŋgoip, “Sumbemgât den siŋgi âlip, zorat mâtâp, zo sii daŋgât naamŋâ yatâ. Ambân ŋâiŋâ nalemân sii daŋgât zâtki giari nalem aksik naam op naŋgip.” ");
INSERT INTO kpf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuŋâ den dâzâŋgoip, zo sumbuŋik dâzâŋgoip. Den muyap mân sâm muyagem dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yatâ oi Propete a ŋâiŋâ den sâip, zo bonŋâ oip. Den zo itâ, “Lâunan den sumbuŋâ top top muyagei sâbat. Hân muyageibân gâbâ den tik zeip, zo sâm muyagibat.” ");
INSERT INTO kpf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuŋâ a ambân zâmbari âine mirin zarip. Zâi tâi arâpŋâ nen zâimŋâ dukum sâwen, “Kâlamân hibuk muyageip, den sumbuŋâ zorat topŋâ sâna nâŋgânâ.” ");
INSERT INTO kpf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Dukoindâ itâ sâm dâtnâŋgoip, “A keet âlipŋâ pâip, zo a bonŋâ nâŋâ pârâwan. ");
INSERT INTO kpf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nep, zo han patâ zi. Keet âlipŋâ, zo sumbemgât siŋgi a ambân kâmut. ");
INSERT INTO kpf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Hibuk, zo bâliŋâ mariŋâ, zâkkât kâmut. Kâsa zâk nebân hibuk keetŋâ maandiŋip, zâk Sataŋ. Bon mimiŋ narâkŋâ, zo hâuŋâ mimiŋ narâkŋâ. Nep tuutuuŋ a, zen sumbem a. ");
INSERT INTO kpf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hibuk sâmbum kârâbân uwe, zo yatigâk hâuŋâ mimiŋ narâkŋan âsagibap. ");
INSERT INTO kpf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","A bonŋâ, nâŋâ kâwali arâpnâ sâŋgonzâŋgua a ambân zeŋgâren gâbâ bâliŋ mâme a ambân sot gurumin den kukuŋâ a ambân, zo gâbâreziŋgâm kârâp tâmbâŋan zâmbane geibi. Zen zoren umbâlâ op isem ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A târârak zen ko Ibâziŋaŋgât um topŋan âsakŋoot maa yatâ âsagem ândibi. Ŋâi zâk kindapŋootŋâ den zi nâŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Sumbemgât den siŋgi âlip mâtâp, zo itâ. Kune kinsa ŋâi hibukŋan tik zei a ŋâi zoren âi muyageip. Muyagemŋâ umâlep patâ nâŋgâm kwârakum âi kut ŋâi ŋâi tâkŋaŋgip, zo pam kât mem naŋgâm hân zo kwâlip.” ");
INSERT INTO kpf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Sumbemgât siŋgi âlip mâtâp, zo itâ. A ŋâi kunegât kârum ândeip. ");
INSERT INTO kpf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kârum ândim kune ŋâi tipŋan kurum, zo muyageip. Muyagemŋâ kut ŋâi ŋâi gakâŋâ, zo a zo pindi kune zo zâkkât oip.” ");
INSERT INTO kpf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Sumbemgât siŋgi âlip, zorat mâtâp, zo iŋangât irâ yatâ. A zen irâ zo saruyân pane giari zuu topŋâ topŋâ piksâwe. ");
INSERT INTO kpf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Piksâne sâmbune âkŋan zarip. Oi iŋan niniŋâ, zo waŋgâyân parâwe. Mân niniŋâ ko birâm pane saruyân giarip. ");
INSERT INTO kpf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Narâk patâ mâte oi ko zo yatâ muyagibap. Narâk zoren sumbem a, ziŋâ a hânŋâ hânŋâ kâsâpzâŋgomŋâ bâliŋ mâme a minziŋgâm kârâp patin zâmbane geibi. Zoren umbâlâ op isem ândibi.” ");
INSERT INTO kpf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yatâ sâmŋâ mâsikâniŋgip, “Zen zo aksik nâŋgâm naŋge mo buŋâ?” Sâi niŋâ sâwen, “Nen nâŋgâm naŋgen.” ");
INSERT INTO kpf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sâindâ dâtnâŋgoip, “Zen dinnâ nâŋgâm kwâtâtemŋâ siŋgi âlipŋaŋgât mâtâp nâŋgâm kwâkâbi. Zen mirâgât mariŋâ yatâ opŋâ kabâŋan gâbâ kut ŋâi ŋâi âlip sâŋgiŋâ sot uŋakŋâ lândim pambi.” ");
INSERT INTO kpf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu zâk den sumbuŋâ top topŋâ zo sâm naŋgâm mirâ kamân zo birâm arip. ");
INSERT INTO kpf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Âi kamânŋan Nasarete, zoren âi takâm mâpâmâpâse namin zâim den siŋgi âlip sâm dâzâŋgoi a zen nâŋgâm imbaŋâziŋ buŋ oi sâwe, “Zâk nâŋgânâŋgâ zot imbaŋâ zo waniŋ gâbâ muyageip. ");
INSERT INTO kpf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nen topŋâ nâŋgen. Zâk mirâ tuutuuŋ a nanŋâ. Mamŋâ Maria. Murâpŋâ kutziŋâ Yakobo, Yose, Simoŋ sot Yuda. ");
INSERT INTO kpf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Garâpŋâ nen sot ârândâŋ ândien. Zâk kut ŋâi ŋâi zi ikâ zoren muyageip?” ");
INSERT INTO kpf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Zen yatâ nâŋgâm kwakŋâ zâkkât nâŋgâne geip. Oi Yesuŋâ sâm dâzâŋgoip, “Propete a ŋâi zâk kutsiŋgiŋâ hân torengen laŋ kârâm ari kamârâpŋâ sot torerâpŋâ, zen zâkkât nâŋgâne gei birâŋaŋgâme.” ");
INSERT INTO kpf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A zen umziŋ aŋgân kârâwegât Yesuŋâ kamân zoren kulem top top doŋbep mân tuugip. ");
INSERT INTO kpf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nârâk zoren a kutâ Herode, zâk Yesugât siŋgi nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Siŋgi zo nâŋgâmŋâ a sâtŋâ gakârâpŋâ itâ sâm dâzâŋgoip, “Nâ itâ nâŋgan. Yohane too saŋgonziŋgip, zâk mumuŋan gâbâ zaat kâwaliŋoot ândiap.” ");
INSERT INTO kpf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Den zo yen mân sâip. Mârumŋan Herode zâk munŋâ Pilipogât ambân bekŋan meip, kutŋâ Herodia. Ambân zâkkât opŋâ sâi Yohane kiŋ bik saam tâk namin pane zeip. ");
INSERT INTO kpf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Wangât, Yohaneŋâ den itâ dukuip, zorat, “Gâ ambân zo mein, zo mân orotŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Oi Herodeŋâ Yohane kumbam nâŋgip. Ka a ambân ziŋâ Yohanegât nâŋgâne Propete op ândeip, zorat keŋgât op birip. ");
INSERT INTO kpf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Oi Herode âsaâsagiŋ narâk oi omo nâne patâ utnam utne Herodiagât bâratŋâ, zâk Herode sot a sâtŋâ tarâwe, zeŋgât mâteyân kep ândei Herode ek âkŋâlem itâ sâm dukuip, ");
INSERT INTO kpf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","“Nâ den zi sâm kâtigian. Gâ wan mo wangât sâna gibat.” ");
INSERT INTO kpf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Oi ambân zâk mamŋandâ den dukui itâ sâip, “Yohane too saŋgon nep tuugip, zâkkât gânduŋ kom mânâŋgâtŋâ kâukŋâ hâkobân pam mem ga ni.” ");
INSERT INTO kpf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","11","Yatâ sâi a kutâ zâk nâŋgâm pârâkpâip. Nâŋgi mân dâp oip. Ka zâk a sâtŋâ zeŋgât mâteziŋan sâm kâtigeip, zorat op zo bon upapkât nep a sâŋgonzâŋgoi Yohane tâk namin tâi gânduŋâ kârâm mânâŋgât kâukŋâ hâkobân pam mem ga Herodia bâratŋâ pindâwe. Ambân zo memŋâ mamŋâ pindip. ");
INSERT INTO kpf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohane kune moi arâpŋâ zen gamŋâ kâmbarâŋâ mem hangumŋâ âi Yesu den siŋgi dukuwe. ");
INSERT INTO kpf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuŋâ den siŋgi zo nâŋgâm waŋgâyân zâim hân a mân ândiândiŋan, zoren ândibam arip. Ari a ambân doŋbep patâ kamân ŋâin ŋâin gâbâ, zen siŋgiŋâ nâŋgâm saru sâtŋan âim muyagiwe. ");
INSERT INTO kpf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesuŋâ waŋgâyân gâbâ gemŋâ a ambân kâmut zo ziŋgitŋâ umŋâ nâŋgâmŋâ a ambân sisi mâsekziŋoot, zo kubikziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yatâ op ândei mirâ oi Yesugât arâpŋâ niŋâ dukum sâwen, “Zi a mân ândiândiŋan ândeindâ mirâ ŋâtiksâbâmap. Gât ko a ambân zâmbana kamânân âim nalem muyagibi.” ");
INSERT INTO kpf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sâindâ Yesuŋâ itâ sâm dâtnâŋgoip, “Wangât âibigât se? Ziŋâ nalem ziŋgânek.” ");
INSERT INTO kpf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yatâ sâm dâtnâŋgoi sâwen, “Nen zi nalem bâtnâmbut sot saru zuu zagât mem ândien. Nen nalem nâmbutŋâ buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Sâindâ Yesuŋâ itâ sâm dâtnâŋgoip, “Nalem zo nâgâren mem ganek.” ");
INSERT INTO kpf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yatâ sâmŋâ a dâzâŋgoi hibuk luatŋâ tap âiwe. Yesuŋâ nalem bâtnâmbut sot saru zuu zagât, zo mem sumbemân egi zari sâiwap sâmŋâ namuŋ arâpŋâ niŋgi niŋâ kâsâpkum a ziŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","A pisuk nem âkon urâwe. Oi buputŋâ zeip, zo meindâ irâ kiin zagât piksâip. ");
INSERT INTO kpf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A nalem niwe, zo teŋgâziŋâ 5 tausen yatâ. Ambâ murarâpziŋâ mân sâlâpzâŋgowen. ");
INSERT INTO kpf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yatâ opŋâ Yesuŋâ arâpŋâ sâi waŋgâyân zâi saru nâmbutken âinam âiwen. Yesu zâk a ambân zâmbari âibigât zoren tâip. ");
INSERT INTO kpf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Oi a ambân zâmbari âinetâ zâk zikŋik ninâu sâbam bâkŋan zarip. Yatâ op ândei ŋâtiksâi zâk zikŋik zoren ândeip. ");
INSERT INTO kpf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Waŋgâŋâ âim saru tânâmŋan takip. Oi pibâ patâ zâk âiwenân gâbâ gam saru kunziri waŋgâ mem kâbakŋei âinam osiwen. ");
INSERT INTO kpf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mirâ haŋsâsâgât Yesuŋâ saru kwâkŋan lâŋ lâŋ ga muyageniŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Zâk zo yatâ gâi arâp niŋâ ekŋâ keŋgâtniŋâ op wâke gaap sâm den kâtik kambâŋâwen. ");
INSERT INTO kpf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yatâ oindâ den itâ sâm dâtnâŋgoip, “Umziŋ diim geik. Zi ninak gaan. Mân keŋgât utnek.” ");
INSERT INTO kpf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sâi Peteroŋâ sâtŋan mem itâ sâip, “Kembu, ninak gaan sâna too kwakŋik lâŋ gabâ.” ");
INSERT INTO kpf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sâi Yesuŋâ sâip, “Ga.” Sâi Peteroŋâ waŋgâyân gâbâ geim saru kwâkŋan Yesugâren arip. ");
INSERT INTO kpf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Peteroŋâ âim tâi pibâ patâ ŋâi gâi keŋgât op geibam op Yesu konsâm sâip, “Kembu, gâ gâsuni.” ");
INSERT INTO kpf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sâi zorenâk Yesuŋâ gâsum sâip, “Gâ wangât nâŋgâm pâlâtâŋgâ lotŋâ oi um zagât uat?” ");
INSERT INTO kpf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yatâ sâm gâsui waŋgâ kâligen kopgâitâ pibâ hiriŋsâip. ");
INSERT INTO kpf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Oi a waŋgâyân tarâwen, nen Yesu um topŋan âi pindiŋsâm sâwen, “Gâ perâkŋak Anutugât nanŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Oi saru nâmbutken âimŋâ Genesarete hânân takâwen. ");
INSERT INTO kpf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Zoren a zen Yesu ekŋâ den pane kamân ŋâin ŋâin ari a ambân sisi mâsekziŋoot diiziŋgâm zâkkâren gawe. ");
INSERT INTO kpf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Oi zen Yesu itâ dukuwe, “Nâŋgâna hâmbâgâ murukŋan gâsum mâsekziŋ buŋ upap.” Yatâ urâwe, zorâŋâ sâkziŋâ âlip op naŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Narâk zoren Yerusalem kamânân gâbâ Parisaio a sot Kembugât gurumin den galem a, zen Yesugâren gam mâsikâm sâwe, ");
INSERT INTO kpf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Arâpkâ, zen wangât sâkurâpniŋ zeŋgât den kom bitziŋâ mân too saŋgon nalem mem nime?” ");
INSERT INTO kpf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yatâ sâm mâsikâne Yesuŋâ itâ sâip, “Zen ko wangât ziiŋâ sâkurâpziŋaŋgât den lum Anutugât den kume? ");
INSERT INTO kpf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anutugât den itâ ziap, ‘Gâ ibâ mam sâtzik lum hurat kwatzikâban. Oi ŋâi zâk ibâ mam den bâliŋâ dâzâkobap, zâk mân ândibap. Zâk kune mumbap.’ ");
INSERT INTO kpf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Zen ko itâ sâme, ‘Ŋâi zâk ibâ mam itâ dâzâkobap, “Kut ŋâi zikâbam, zo Anutugât siŋgi sâm paan.” Zâk zo yatâ opŋâ on galem mân otzikâbap.’ ");
INSERT INTO kpf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Zen yatâ opŋâ Anutugât den birâne giari sâkurâpziŋaŋgât den zorik lum ândime. ");
INSERT INTO kpf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sarâ a, zen. Zeŋgât op Propete Yesaiaŋâ Anutugât den itâ sâm kulemgoip, ");
INSERT INTO kpf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘A kâmut zi lâuziŋandik mâpâsenime. Umziŋandâ ko birânime. ");
INSERT INTO kpf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Oi den bonŋagât hâuŋâ a ziiŋ den sâm kwâkâyaŋgâme. Zen lâuziŋandik mâpâsenime. Nâ zorat nâŋga yen opmap.’” ");
INSERT INTO kpf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu zâk zo yatâ sâm dâzâŋgom a ambân sâi gane itâ dâzâŋgom sâip, “Nâ den dâzâŋgua nâŋgâm kwâtâtinek. ");
INSERT INTO kpf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kut ŋâi ŋâi nine geimap, zo mân sumunkomap. Ka lâuziŋan gâbâ kopgâmap, zorâŋâ sumunkomap.” ");
INSERT INTO kpf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yatâ sâi arâpŋâ niŋâ zâkkâren âim mâsikâm sâwen, “Den yatâ zo sâna Parisaio a zen nâŋgâm bâliŋ kwatgige, zo nâŋgat?” ");
INSERT INTO kpf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Sâindâ sâip, “Nebân kut ŋâi zo sumbem Ibânandâ mân kâmerip, zo sâmbum naŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Zen yen birâziŋgânek. Parisaio zen siŋziŋ ŋâtâtikŋâ. Zeŋgât mâtâp kândom a sen bâpsâsâŋ zagât diiaŋgâm âibabot, zo ko mâtâp tâpâkum ârândâŋ lâmân geibabot.” ");
INSERT INTO kpf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sâi Peteroŋâ itâ sâm dukuip, “Den sumbuŋâ dâzâŋguat, zorat topŋâ sâna nâŋgânâ.” ");
INSERT INTO kpf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sâi Yesuŋâ dâtnâŋgoip, “Zen tok um nâŋgânâŋgâziŋ mân pâroŋsâi ândie, mo dap? ");
INSERT INTO kpf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Topŋâ itâ mân nâŋge? Aŋâ kut ŋâi ŋâi nine tep kâmboziŋan giari mem kubigi mâtâpŋan geimap. ");
INSERT INTO kpf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ka umziŋan gâbâ den bâliŋ top top lâuziŋan takâmap, zorâŋâ ko umziŋ sumunkomap. ");
INSERT INTO kpf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","A umân gâbâ kut ŋâi ŋâi kop gâmap, zo itâ. Nâŋgânâŋgâ bâliŋâ, âkŋâle nep, kâmbam ku, kâmbu konda, den sarâ, ambân mem birâbirâŋ sot den sumunŋâ. ");
INSERT INTO kpf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kut ŋâi ŋâi yatâ, zorâŋ sumunkomap. Oi bet mân saŋgon kut ŋâi ŋâi nine, zorâŋâ mân sumunkomap. ");
INSERT INTO kpf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Oi Yesu zâk kamân zo birâm Tiro sot Sidoŋ kamân zagât, zo zeŋgâren arip. ");
INSERT INTO kpf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Zeŋgâren ândei Kanaan hânân gokŋâ ambân ŋâi gam Yesu konsâm sâip, “Kembu gâ Dawidigât kiunŋâ, nâgât umgâ bâliŋ oik. Bâratnâ, zâk wâkeŋâ mâte pirik okŋaŋgâmap.” ");
INSERT INTO kpf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yatâ sâi Yesuŋâ nâŋgâm den hâuŋâ mân dukuip. Yatâ oi arâpŋâ nen zâkkâren gam dukum sâwen, “Ambân zo molina arik. Zâk kândâtniŋan den sâm gaap.” ");
INSERT INTO kpf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sâindâ dâtnâŋgoip, “Nâ Isirae kâmut râma yatâ gulip op ândime, zo zeŋgârâk sâŋgonnogi gem gâwan.” ");
INSERT INTO kpf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sâi ambân zorâŋ um topŋan âi siminŋâ liim pindiŋsâm sâip, “Kembu, gâ laŋ betnan me.” ");
INSERT INTO kpf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yatâ sâi ko itâ sâm dukuip, “Katep zeŋgât nalem betziŋan mem wâu ziŋgâziŋgâŋ, zo mân dâp upap. Nâ Isirae a kâmut, zeŋgât gem gâwan.” ");
INSERT INTO kpf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Sâi ambân zo itâ sâip, “Kembu zo âlip sat. Oi marirâpziŋandâ nalem nem tatne gwapgwap gei wau zen laŋ nime.” ");
INSERT INTO kpf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yatâ sâi Yesuŋâ dukum sâip, “O ambân nâŋgâm pâlâtâŋgâ patâ, sat zorat dâp muyagegigik.” Sâi zorenâk bâratŋâ âlip oip. ");
INSERT INTO kpf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu zâk hân zobâ âburem gam Galilaia saru sâtŋan âim bâkŋâ ŋâin zâi tâip. ");
INSERT INTO kpf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Zâi tâi a ambân kâmut patâ zâkkâren mindum gawe. Zen sâkziŋâ gigiŋâ, sinziŋ bâpsâsâŋ, kin bitziŋ bâliŋâ, kopa sot sisi mâsekziŋoot diiziŋgâm Yesugât um topŋan zâmbane kubikziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yatâ oi kopa, zen dinziŋâ sâwe. Kin bitziŋ bâliŋ, zen mâtâbân âim gawe. Sâkziŋ gigiŋândâ âlip urâwe. Sinziŋ bâpsâsâŋandâ sinziŋ igâwe. Oi a ambân kâmut, ziŋâ zo ekŋâ nâŋgâne imbaŋâ oi itâ sâwe, “Nen Isirae a kâmut neŋgât Anutu mâpâsinâ.” ");
INSERT INTO kpf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuŋâ arâpŋâ sâi gâindâ itâ sâm dâtnâŋgoip, “Nâ a zeŋgât umnâ nâŋgan. Zen nâ sot ândine sirâm karâmbut oi tepkât mue. Oi nalem buŋâ sâŋgonzâŋgoindâ âi mâtâbân tâmbetagobegât umnâ girem uap.” ");
INSERT INTO kpf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Sâi arâpŋâ niŋ itâ sâwen, “Nen hân a mân ândiândiŋan ândim nalem ikâ gâbâ mem a kâmut zi ziŋgindâ nine dâp upap?” ");
INSERT INTO kpf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yatâ sâindâ Yesuŋâ mâsikâniŋgâm sâip, “Zeŋgâren nalem dabutâ ziap?” Sâi niŋâ sâwen, “Nalem nâmburân zagât sot saru zuu zagât mo karâmbut ziap.” ");
INSERT INTO kpf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Oi Yesuŋâ nâŋgâm sâi a ambân zen mindum hânân ge tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yatâ utnetâ Yesu zâk nalem nâmburân zagât sot saru zuu, zo mem sâiwap sâm namuŋ arâp niŋgi kâsâpkum a ambân ziŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nen ziŋgindâ a ambân aksik nem âkon urâwe. Oi buputŋâ tap arip, zo sânduindâ irâ nâmburân zagât piksâip. ");
INSERT INTO kpf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nalem niwe, a zo 4 tausen yatâ. Ambâ murarâpziŋ mân sâlâpzâŋgowen. ");
INSERT INTO kpf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuŋâ a ambân zâmbari âine zikŋâ waŋgâyân zâim Magadaŋ hânân âi takip. ");
INSERT INTO kpf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisaio a sot Sadukaio a, zen Yesugâren gam mâsikâm sâwe, “Gâ sâna top lâkulâku kulem ŋâi âsagei iknâ.” ");
INSERT INTO kpf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sâne dâzâŋgom sâip, “Mirâ ŋâtiksâbâ sâi sumbem kuriŋkoi sâme, ‘Muka maa upap.’ ");
INSERT INTO kpf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mo haŋsâi sasa mem dooŋgubap, zo ko map gâbap sâme. Sarâ a, zen. Sumbemgât tobatŋâ ekŋâ nâŋgâme. Ka nâgât topnâ ko mân nâŋgâm kwâtâtime. ");
INSERT INTO kpf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A ambân ândi mâmanziŋ bâliŋâ, zen kulem tobat ŋâi iknat sâme. Zen kulem ŋâi uŋakŋâ buŋâ. Yonaŋâ Niniwe a umziŋ melâŋbigât kulem yatâ oip. Narâk ziren Yona kulem oip zo yatâ nâŋâ muyagia ikpi.” ");
INSERT INTO kpf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Oi arâpŋâ nen nalemgât nelâmnâŋgoi Yesu sot saru nâmbutken arindâ Yesuŋâ itâ sâm dâtnâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","“Zen Parisaio sot Sadukaio a zeŋgât sii daŋgât nalemziŋan mân pam om nimbi.” ");
INSERT INTO kpf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yatâ sâm dâtnâŋgoi nen kwakŋâ itâ sâm ârâguwen, “Nalem zei birâm gen, zorat dâtnâŋguap.” ");
INSERT INTO kpf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yatâ sâindâ Yesugât kindapŋan giari nâŋgâm itâ sâm dâtnâŋgoip, “O nâŋgâm pâlâtâŋziŋ lotŋâ. Zen wangât nalem birâm ge, zorat âragum te? ");
INSERT INTO kpf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kut zo orâwan, zo mârum nelâmzâŋgoi mân nâŋge? Nâ nalem bâtnâmbut zorâŋâ a 5 tausen ziŋga nem âkon utne buputŋâ sândune irâ dabutâ piksâip? ");
INSERT INTO kpf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nalem nâmburan zagât, zorâŋ a 4 tausen ziŋga nem âkon utne buputŋâ sândune irâ dabutâ gei piksâip? ");
INSERT INTO kpf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nâ nalemgât mân dâzâŋguan. Zo wangât mân nâŋgâm kwâtâtie? Parisaio a sot Sadukaio a, zeŋgât sii daŋgât nalemziŋan mân pam nimbi.” ");
INSERT INTO kpf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Arâpŋâ nen den yatâ nâŋgâm kwâtâtem sâwen, “Zâk sii daŋgât pam niniŋaŋgât sap, zo Parisaio sot Sadukaio den sâsâziŋaŋgât op sap.” ");
INSERT INTO kpf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kaisarea kamân a kutâ Pilipoŋâ sâi tuuwe. Yesu zâk âi zo mâte upam arâp dâtnâŋgom sâip, “A ambân, zen a bonŋâ nâgât ŋâi sâme?” ");
INSERT INTO kpf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sâi niŋâ dukum sâwen, “Nâmbutŋandâ Yohane too saŋgon nep tuugip sâme. Nâmbutŋandâ Elia sâme. Nâmbutŋandâ Yeremia mo Propete a ŋâi sâme. Gâgât yatâ sâme.” ");
INSERT INTO kpf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yatâ sâm dukoindâ mâsikâniŋgip, “Ka ziiŋâ ko nâgât ŋâi sâme?” ");
INSERT INTO kpf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Mâsikâniŋgi Simoŋ Peteroŋâ sâip, “Gâ Anutu ândiândiŋ mariŋaŋgât nanŋâ. Bâliŋan gâbâ mâkâniŋgâban. Gâ Kristo.” ");
INSERT INTO kpf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sâi Yesuŋâ itâ sâm dukuip, “Simoŋ, Yonagât nanŋâ, gâgât nâŋga sâtâreŋoot uap. Nâŋgânâŋgâ zo agâren gâbâ mân muyagegigap. Zo sumbem Ibânandâ sâm muyagem gigip. ");
INSERT INTO kpf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Zorat dâgoga nâŋgâ. Gâgât kutkâ Petero (niiŋ denân ko Kât). Oi nâŋâ kât zorat kwâkŋan a ambân kâmut gakârâpnâ zâmbansa simgât imbaŋâŋandâ mân walâziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Oi nâ sumbem mâtâp konkonŋâ gibat. Oi hânân saasaaŋâ nep tuuna sumbemân bonŋoot upap. Oi hânân olaŋolaŋŋâ nep tuuna sumbemân bonŋoot upap.” ");
INSERT INTO kpf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yatâ sâmŋâ arâpŋâ den kâtikŋâ dâtnâŋgom sâip, “Nâ Kristo ândian, zorat den a ambân mân dâzâŋgobi.” ");
INSERT INTO kpf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Narâk zoren Yesuŋâ topkwap kut ŋâi ŋâi gâtâm âsagibap, zorat arâp sâm muyagem niŋgip. Oi Yesuŋâ Yerusalem kamânân zari galem a sot tirik namâ galem a sot Kembugât gurumin den zorat galem a, ziŋâ kut ŋâi ŋâi sumunŋâ okŋaŋgâm kune mom sirâm karâmbut zem zaatpap, zorat diŋâ dâtnâŋgom naŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dâtnâŋgoi Petero zikŋik diim âimŋâ kwâkâŋaŋgâm sâip, “Kembu, Anutuŋâ galem otgigi kut ŋâi yatâ zo mân âsagegibap.” ");
INSERT INTO kpf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sâi puriksâm Petero itâ sâm dukuip, “Sataŋ, gâ siriksâm âi. Gâ mâtâp dooŋgubâmat. Den sat, zo Anutugâren gâbâ buŋâ. Zo a den.” ");
INSERT INTO kpf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Narâk zorenâk Yesuŋâ târokwapŋâ arâp itâ sâm dâtnâŋgoip, “Zen nâ molininâ sâm um sâkziŋaŋgât den birâm poru nakziŋ lum nâgât mâtâp, zo lâŋbi. ");
INSERT INTO kpf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Zen ândiândiziŋ aŋgân kârane zo ko gulipzâŋgobap. Ka zen nâgât op ândiândiziŋ birâne muyageziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Zen hângât kut ŋâi ŋâi, zorik mem ândine ândiândiziŋâ buŋ oi wan âlipŋâ muyageziŋgâbap? Zen dap yatâ ândiândiziŋ suup mei târokwap ziŋgâbap? ");
INSERT INTO kpf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nâŋgânek. A bonŋâ, nâ Ibânaŋgât neule âsakŋoot âsagem sumbem arâpnâ diiziŋgâm gem gam a aksik patâ ândi mâmanziŋaŋgât dâp hâuŋâ ziŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nâ perâkŋak dâzâŋgobâ. A zi kinzeyân gâbâ nâmbutŋandâ mân munetâ a bonŋâ nâ gem kembu patâ op tâka nikpi.” ");
INSERT INTO kpf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yesu zâk sirâm nâmburân kânok ândim Petero sot Yakobo sot munŋâ Yohane, zen ziiŋik diiziŋgi bâkŋan zâiwe. ");
INSERT INTO kpf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Oi zoren Yesu zâk mâteziŋan kinŋâ tobat ŋâi oip. Oi si sâŋgânŋâ maa yatâ âsageip. Hâmbâŋâ kâukom âsakŋâ yatâ âsagem naŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Oi Mose sot Elia, zet zorenâk âsagem kin Yesu sot den den urâwe. ");
INSERT INTO kpf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yatâ utnetâ Peteroŋâ Yesu itâ sâm dukuip, “Kembu, mat ŋâi ziren ândien. Zorat nâŋgâna ziren silep karâmbut tuuga, gâgât ŋâi, Mosegât ŋâi, Eliagât ŋâi.” ");
INSERT INTO kpf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yatâ sâm kiri sasaŋâ âsakŋoot gem kwâtepzâŋgoip. Oi sasa kâligen gâbâ den ŋâi itâ gâip, “Zi nannâ âlipŋâ. Umnandâ gâsumap. Zen diŋâ nâŋgâm biraŋbi.” ");
INSERT INTO kpf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Oi arâpŋâ zen den zo nâŋgâm sâŋgânziŋ hânân gei tutukum keŋgât op sânâm sânsân urâwe. ");
INSERT INTO kpf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yatâ utne Yesuŋâ zeŋgâren âim weeziŋgâm sâip, “Zen zaatŋâ keŋgât buŋ ândinek.” ");
INSERT INTO kpf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yatâ sâi sinziŋâ lum za ikne Yesu zikŋik kiri igâwe. ");
INSERT INTO kpf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Oi bâkŋan gâbâ gem tap Yesuŋâ den itâ sâm dâzâŋgoip, “Kut ŋâi sen mârât ikse, zorat den siŋgi a ambân mân dâzâŋgom ândine a bonŋâ nâ mumuŋan gâbâ zaatpat.” ");
INSERT INTO kpf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yatâ sâm dâzâŋgoi arâpŋâ zen mâsikâm sâwe, “Elia zâk Kristo kândom okŋaŋgâm gâbap. Kembugât gurumin den galem a zen wangât yatâ sâme?” ");
INSERT INTO kpf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Sâm mâsikâne itâ sâm dâzâŋgoip, “Elia zâk kândom gam kut ŋâi ŋâi kubikpapkât sâwe, zo bonŋâ. ");
INSERT INTO kpf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Oi zorat dâzâŋgua nâŋgânek. Elia zâk mârum gam ândei mân ek nâŋgâm kut ŋâi laŋ okŋaŋgâwe. Oi a bonŋâ, nâ yatigâk nom sâknam nibi.” ");
INSERT INTO kpf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yatâ sâi arâpŋâ ziŋâ itâ nâŋgâwe. Eliagât sap, zo Yohane too saŋgon nep tuugip, zâkkât op sap. ");
INSERT INTO kpf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Oi bâkŋan gâbâ gem gam a kâmut zeŋgâren ganetâ a ŋâi Yesugâren gam pindiŋsâm sâip, ");
INSERT INTO kpf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Kembu, gâ nannaŋgât umgâ bâliŋ oik. Zâk mom gwâlâ op kârâbân sot toin geimap. ");
INSERT INTO kpf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Oi arâpkâ zeŋgâren mem ga kubiknam osie.” ");
INSERT INTO kpf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sâi Yesuŋâ itâ sâip, “O a kâmut, zen nâŋgâm pâlâtâŋziŋ buŋ. Den kwâkâ a. Nâ zen sot âsâbâŋ ândim âkom diiziŋgâmâmbat?” Yatâ sâmŋâ katep mem ganek sâip. ");
INSERT INTO kpf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Oi yatâ utnetâ Yesuŋâ wâke den dukui pam ari zorenâk katep âlip oip. ");
INSERT INTO kpf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bet arâp nen Yesugâren gam tik sâm mâsikâwen, “Nen wangât wâke molinam osien?” ");
INSERT INTO kpf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Sâindâ dâtnâŋgoip, “Nâŋgâm pâlâtâŋziŋâ lolotŋâ, zorat yatâ ue. Nâ perâkŋak dâzâŋgua nâŋgânek. Nâŋgâm pâlâtâŋ bonŋâ, mâiktârâ ŋâi, mundo keetŋâ yatâ zemziŋgi bakŋâ ândiren zi dukunetâ âbâŋgum ândirengen âibap. Zen wan mo wangât mân kwakpi. ");
INSERT INTO kpf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Wâke zo yatâ, zo wan wanŋâ buŋâ, nalem birâm ninâu sot ândimŋâ âlip moliziŋgâbi.” ");
INSERT INTO kpf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesugât arâp, nen Galilaia hânân Yesugâren minduindâ itâ sâm dâtnâŋgoip, “A bonŋâ, nâ a bitziŋan zâibat. ");
INSERT INTO kpf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Zaria none momŋâ sirâm karâmbut zem zaatpat.” Den yatâ sâi arâpŋâ nen den zo nâŋgindâ makŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Oi Kapenaum kamânân takindâ tirik namâgât kât memarâwe, a zo ziŋâ Peterogâren gam mâsikâm sâwe, “Patâziŋandâ tirik namâgât kât kânok pâmap mo buŋâ?” ");
INSERT INTO kpf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Sâne Peteroŋâ sâip, “Ee, pâmap.” Yatâ sâmŋâ mirin zâim den mân dukui Yesu zikŋak mâsikâm sâip, “Simoŋ, gâ dap nâŋgat? Hângât a kutâ, zen waniŋ zeŋgâren kât mime? Narâpziŋâ zeŋgâren mo a nâmbutŋâ zeŋgâren?” ");
INSERT INTO kpf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mâsiki a nâmbutŋâ zeŋgâren mime sâi Yesuŋâ itâ sâm dukuip, “Âlip sat. Zorat a kutâ narâpziŋ, zen yen ândibi. Niiŋâ yatik Anutu kutâgât narâp ândien. ");
INSERT INTO kpf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Oi niiŋaŋgât nâŋgâne bâliŋ opapkât saruyân geim kela tâgân saam pânandâ giari saru zuu kândom zibap, zo sâmbuna kopgâi lâuŋâ kwâsatŋâ kât ŋâi muyagiban. Zo niikŋâ siŋgi kom ziŋgâban.” ");
INSERT INTO kpf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Narâk zoren arâpŋâ nen Yesugâren âim itâ sâm mâsikâwen, “Anutu um topŋan, zo ŋâiŋâ patâ op ândibap?” ");
INSERT INTO kpf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yatâ sâindâ Yesuŋâ katep mâik ŋâi sâi gâi osetniŋan pam itâ sâm dâtnâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Nâ perâkŋak dâzâŋgobâ. Zen umziŋ diim gem katep zeŋgât holi yatâ mân ândibi, zo ko sumbem kamânân mân zâibi. ");
INSERT INTO kpf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ŋâi zâk katep zi yatâ op ândibap, zâk zo ko sumbemân patâ op ândibap. ");
INSERT INTO kpf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Oi ŋâi zâk nâgât op katep zi itâ galem okŋaŋgâbap, zâk nâ kore otnibap.” ");
INSERT INTO kpf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ŋâi zâk katep gakârâpnâ zeŋgâren gâbâ kânoktâ sâi bâliŋ upap, zâk mârumŋan kât patâ ŋâi gânduŋan saam saruyân pane giari sâi zo bâbâlaŋ opap. ");
INSERT INTO kpf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yei, bâliŋaŋgât nep tuutuuŋ, zo yâmbâtŋâ. Bâliŋaŋgât nep tuutuuŋ muyagibap. Zo dap op yen zimbap. Ka a ŋâi bâliŋaŋgât nep tuubap, Yei, Anutuŋâ dap dap okŋaŋgâbap? ");
INSERT INTO kpf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Zorat bikandâ mo kiŋgandâ bâliŋ upâ sâi mânâŋgât pâmban. Ândiândi kâtikŋan zâibâ sâm zâibam kwakŋâ birâm ândiban. Kiŋgâ bikâ hâlâluyâk ândim kârâp kâtikŋan geibatkât yatâ upan. ");
INSERT INTO kpf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mo siŋgandâ bâliŋâ ŋâi ek nâŋgâbâ sâi ketârapkum pâmban. Ândiândi kâtikŋan âiban, zorat op siŋgâ bâpsâi ândiban. Sen hâlâlu ândim kârâbân geibatkât yatâ upan.” ");
INSERT INTO kpf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Umziŋ girem oi mulun ândim katep gakârâpnâ, zeŋgât nâŋgâne gigiŋâ mân upap. Nâ zorat dâzâŋgua nâŋgânek. Sumbemân katep zeŋgât galem a ândie. Zen sumbem Ibânaŋgât mâteŋan ândime. ");
INSERT INTO kpf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","A bonŋâ, nâ a ambân tâmbetagoagoŋan gâbâ kubikziŋgâbam gem gâwan. ");
INSERT INTO kpf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Zen dap dap nâŋge? A ŋâi râma gakârâp 1 handeret ândibi, oi zeŋgât osetziŋan gâbâ kânok buŋ oi birâbap? Mo 99 zo zâmbamŋâ kânok barin buŋ upap, zo âi kârum muyagibap? ");
INSERT INTO kpf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nâ perâkŋak dâzâŋgobâ. Zâk âi kârumŋâ muyagemŋâ 99 zeŋgât buŋâ, buŋ upap, zorat op umâlep patâ nâŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Zo yatâ zeŋgâren gâbâ katep ŋâi tâmbetagoi sumbem Ibâziŋandâ nâŋgi mân dâp upap.” ");
INSERT INTO kpf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Bukugâ ŋâiŋâ gâgât tosa muyagei gâ tik âi dukuban. Zâkŋâ diŋgâ nâŋgi âlip oi buku upabot. ");
INSERT INTO kpf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ka diŋgâ biri ko a kânok mo zagât sâna gâ sot âinetâ a zâk sot dinziŋ kubikne âlip upap. ");
INSERT INTO kpf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Oi a zorâŋâ dinziŋâ zo biri Kembugât a kâmut zeŋgât bitziŋan pane dinziŋâ kwâki nâŋgâŋaŋgâne a um kâtik mo orot mâme bâliŋ a yatâ upap. ");
INSERT INTO kpf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nâ perâkŋak dâzâŋgobâ. Zen hânân saasaa nep tuune sumbemân zo yatik bonŋâ upap. Mo zen hânân olaŋolaŋ nep tuune sumbemân yatik bonŋâ upap. ");
INSERT INTO kpf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Oi dum dâzâŋgua nâŋgânek. Zeŋgâren gâbâ a bituktâ, zagât mo karâmbut yatâ, ziŋ umziŋ mâtakâm wan mo wangât ninâu sânetâ sumbem Ibâziŋandâ muyagem ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","A bituktâ, zagât mo karâmbut yatâ, zen nâgât op mindune nâ osetziŋan tâpat.” ");
INSERT INTO kpf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yesuŋâ den yatâ sâi Peteroŋâ zâkkâren âim mâsikâm sâip, “Kembu, bukunâ ŋâiŋâ bâliŋ otnigi tosaŋâ sâp dabutâ birâbat? Nâmburân zagât oi bira dâp upap?” ");
INSERT INTO kpf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Sâm mâsiki Yesuŋâ sâip, “Nâmburân zagât oi birâbangât sat. Nâ yatâ buŋâ, 70 oi birâbangât san. Oi yatigâk buŋâ, walâm doŋbep patâ oi birâban. ");
INSERT INTO kpf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Zorat siŋgi âlipkât mâtâp, zo a kutâ ŋâiŋâ oip, zoren dâpkwap sâbâ. A kutâ zo arâpŋâ tosaŋâ namuŋ pindâbigât sâi gawe. ");
INSERT INTO kpf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Oi ŋâi diim gawe, zâkkâren tosa patâ ŋâi zeip. Kât 10 tausen yatâ. ");
INSERT INTO kpf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Oi a zo kât buŋ oi a kutâ zâk a zo zikŋâ sot ambin murarâpŋâ sot kut ŋâi ŋâi a ziŋ sâŋgân mine zâkkât upapkât sâip. ");
INSERT INTO kpf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","A kutâŋâ yatâ sâi kore aŋâ um topŋan gei itâ sâm dukuip, ‘A kembunâ, gâ birânina kât zo mulunâk muyagem gibat.’ ");
INSERT INTO kpf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yatâ sâi a kutâŋâ umŋâ nâŋgâm tosaŋâ birip. ");
INSERT INTO kpf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Yatâ oi kore a zo mirin gâbâ gem bukuŋâ ŋâi muyageip. Zâkkâren tosa mâik ŋâi kât 1 handeret yatâ tâip. Zâk muyagem gânduŋan gâsum kârâpŋoot sâip, ‘Tosa zo kek melâŋ ni.’ ");
INSERT INTO kpf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Oi a zo bukuŋaŋgât um topŋan geim itâ sâip, ‘Gâ birânandâ mulunâk tap kât zo muyagem gibat.’ ");
INSERT INTO kpf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yatâ sâi diŋâ mân nâŋgâm itâ sâm bukuŋâ zo tâk namin pâip, ‘Tosa zo kwâkâm naŋgâna âki birâgibat.’ ");
INSERT INTO kpf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Oi kore a bukurâpŋâ, zen zo ekŋâ umziŋ bâliŋ oi âi a kutâziŋâ siŋgi dukuwe. ");
INSERT INTO kpf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Oi a kutâ, zâkŋâ nâŋgâm kore a zo sâi gâi itâ sâm dukuip, ‘Kore a bâliŋ kâtik kâtikŋâ, gâ. ");
INSERT INTO kpf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nâ gâgât umnâ nâŋgâm tosagâ biran. Oi nâŋâ tosagâ biran, zo yatik bukugaŋgât tosaŋâ birâbat?’ ");
INSERT INTO kpf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yatâ sâmŋâ kuk op kâwali a bitziŋan pam sâip, ‘Tâk namin pane ândim zâim nâgât tosa patâ, zo kwâkâm naŋgi birâne gibap.’ ");
INSERT INTO kpf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Zen zo yatik um bâbâlaŋâk a bukuziŋâ, zâkkât tosa mân birâne sumbem Ibânandâ zo yatâ yâmbâtŋâ otziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu zâk den top top zo sâm naŋgâm Galilaia hân birâm Yudaia hân Yodaŋ too nâmbutken arip. ");
INSERT INTO kpf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ari a ambân kâmut patâ molim âiwe. Oi hân zoren ândim sisi mâsek a kubikziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Oi Parisaio a, zen mâsikânam ga itâ sâm mâsikâwe, “Kembugât den kâtik, zo dap ziap? A ŋâi, zâk ambinŋâ wan mo wangât op biri dâp upap?” ");
INSERT INTO kpf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mâsikâne sâip, “Kembugât ekabân den ziap, zo sâlâpkume mo buŋâ? Zâkŋâ mârumŋan a sot ambân muyagezikip. ");
INSERT INTO kpf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Muyagezikâmŋâ itâ sâip, ‘Zorat ko a ŋâiŋâ ibâ mam birâzikâm ambinŋaŋgâren pâlâtâŋ oi zet um sâk kânok op ândibabot.’ ");
INSERT INTO kpf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Oi zet zagât buŋâ, kânok op ândibabot. Zorat sa nâŋgânek. Anutuŋâ mâpotzikipkât a zen mân kâsâpzâkobi.” ");
INSERT INTO kpf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yatâ sâm dâzâŋgoi zen itâ sâwe, “Mose zâk den itâ sâip, ‘A ŋâi ambân birâbam ekap kulemgum pindâm birâbap.’ Zo wangât yatâ sâip?” ");
INSERT INTO kpf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Mose zâk um kâtikziŋaŋgât op yatâ sâip. Mârum topkwâkkwatŋan yatâ mân zeip. ");
INSERT INTO kpf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Zorat nâ dâzâŋgua nâŋgânek. A ŋâi, zâk ambân birâm ŋâi mimbap, zâk târotârozik mânâŋgât tosa patâ mimbap. Ka mârum ambânŋâ a ŋâi sot ândeip oi ko tosa zo agât mân upap.” ");
INSERT INTO kpf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yatâ sâi arâpŋâ nen dukum sâwen, “Ap ambin, zekât topzikŋâ yatâ oi aŋâ ambân mân mem yen ândibâ sâm âlip ândibap.” ");
INSERT INTO kpf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sâindâ ko Yesuŋâ itâ sâm dâtnâŋgoip, “Den zi a aksik zeŋgât buŋâ. Zorat imbaŋâ zemziŋgap, zen mem umziŋan gibi. ");
INSERT INTO kpf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","A nâmbutŋâ, zen mam kâmbo kâligen gâbâ ambân buŋâ ândibigât gukupitŋik âsagiwe. A nâmbutŋâ, zen aŋâ katep mân mimbigât otziŋgâwe. Oi a nâmbutŋâ, zen siŋgi âlip nepkât op ambân mân mime. Ŋâi zâk zorat imbaŋâ zemŋâŋgap oi den zi nâŋgâm umŋan gibap.” ");
INSERT INTO kpf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Oi a ambân zen murarâpziŋ Yesugâren diiziŋgâm âim Yesuŋâ bikŋandâ kâukziŋan gâsum ninâu sâbapkât dukuwe. Oi arâpŋâ nen keŋgât minziŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yatâ oindâ Yesuŋâ itâ sâip, “Birânetâ katep zen nâgâren ganek. Mân pâke panek. ");
INSERT INTO kpf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Katep yatâ zo, zen sumbemgât siŋgi sâsâŋ.” Yatâ sâmŋâ bikŋandâ kâukziŋan pamŋâ hân zo birâm ŋâin arip. ");
INSERT INTO kpf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Oi a ŋâiŋâ Yesugâren gam mâsikâm sâip, “Nâ wan nep âlipŋâ tuumŋâ ândiândi kâtikŋaŋgât siŋgi upat?” ");
INSERT INTO kpf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sâi Yesuŋâ itâ sâm dukuip, “Gâ wangât nâgâren gam âlip orotŋaŋgât mâsikânigat? Âlipŋâ mariŋâ Anutu kânok. Gâ ândiândi kâtikŋaŋgât siŋgi upâ sâm Kembugât gurumin den zo lum ândiban.” ");
INSERT INTO kpf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Sâi a zorâŋâ wan gurumin dengât sat sâm mâsikip. Sâi Yesuŋâ itâ sâip, “Gâ kâmbamŋâ a mân kumban. Ap ambin, zet mân birâyaŋgâbabot. Gâ kâmbu mân upan. ");
INSERT INTO kpf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gâ bukugaŋgât sarân sâsâŋ mân sâban. Gâ ibâ mamgâ sâtzik lum hurat kwatzikâban. Oi gikaŋgât otgimap, zo yatik a torenŋâ zeŋgât otgibap.” ");
INSERT INTO kpf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sâi a sigan zorâŋâ itâ sâm dukuip, “Den sat, zo âlip op gâwan. Oi ŋâi dap dap târokwap upat?” ");
INSERT INTO kpf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yatâ sâi Yesuŋâ itâ sâm dukuip, “Gâ tosanâ buŋ upap sâm kut ŋâi ŋâi tatgigap, zo pam kât memŋâ a kanpitâ ziŋgâban. Ziŋgâmŋâ ga moliniban. Gâ yatâ opŋâ sumbemân sikumgoot upan.” ");
INSERT INTO kpf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yatâ sâi a zo nâŋgâm umŋandâ bâliŋ oi arip. Zâk sikum a op ândeip, zorat op umbâlâ op arip. ");
INSERT INTO kpf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ari Yesuŋâ arâpŋâ itâ sâm dâtnâŋgoip, “Nâ perâkŋak dâzâŋgobâ. A sikum patâŋootŋâ sumbem kamânân baginam kwakpi. ");
INSERT INTO kpf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nâ zorarâk dâzâŋgobâ. Bâu patâ kameleŋâ kuup mâtâpŋan bagibagiŋ, zo yâmbâtŋâ yatâ. Ka a kât sikum patâŋâ sumbem kamânân bagibagiŋ, zo yâmbâtŋâ walâwalâŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Arâpŋâ nen den zo nâŋgâmŋâ kwakmak op sâwen, “Zo yatâ zorâŋ dap yatâ sumbemân baginat?” ");
INSERT INTO kpf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sâindâ Yesuŋâ niŋgitŋâ sâip, “Aŋâ kut ŋâi ŋâi utnam kwakme, zo Anutuŋâ mâtâpŋâ âlip muyagemap. Zâk mân kwakmap.” ");
INSERT INTO kpf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yatâ sâm dâtnâŋgoi Peteroŋâ itâ sâm mâsikip, “Nâŋgat. Nen kut ŋâi ŋâiniŋâ aksik birâm gâ moligigen. Oi zorat hâuŋâ wan muyageniŋgâbap?” ");
INSERT INTO kpf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yatâ sâm mâsiki Yesuŋâ sâip, “Nâ perâkŋak dâzâŋgobâ. Gâtâm den kubikkubik narâkŋan a bonŋâ, nâ kembu tâtatnan ta nâ moliniwe, zen yatik a kembu tâtat kiin zagât, zoren tapŋâ Isirae a kâmut kiin zagât, zeŋgât den sâm kwâkâbi. ");
INSERT INTO kpf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Oi ŋâi zâk nâgât opŋâ âtâ mun, mam ponâ, ibâ mam, nan bârat, mirâ kamân mo hân birâbap, zâk hâuŋâ doŋbep mimbap sot ândiândi kâtik ândibap. ");
INSERT INTO kpf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Oi a kândom, zeŋgâren gâbâ doŋbepŋâ bet upi. A bet, zeŋgâren gâbâ doŋbepŋâ kândom upi.” ");
INSERT INTO kpf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Sumbemgât mâtâp, zorat siŋgi, zo waiŋ nep mariŋâ ŋâiŋâ nep a gâsuziŋgâbam arip, zoren dâpkwapâ. Mirâ haŋsâi nep mariŋâ zâk nep a muyageziŋgâbat sâm arip. ");
INSERT INTO kpf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Oi a nâmbutŋâ gâsuziŋgâm sirâm kânokkât bâtnâmbut sâi nâŋgâne dâp oi nepŋan sâŋgonzâŋgoi âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mirâsiŋ takâm tânâmŋan zari dum âi a nâmbutŋâ kamân sombemân muyageziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ziŋgitŋâ itâ sâm dâzâŋgoip, ‘Waiŋ nep ziap. Âi tuune sâŋgânŋâ ziŋgâbat.’ Yatâ sâi nâŋgâm waiŋ nepŋan âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Oi mirâ bâkŋan opŋâ, mirâ torengen oi âim dum gâsuziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Oi ŋâtiksâisâi dum âim a nâmbutŋâ muyageziŋgâm itâ sâm mâsikâziŋgip. ‘Zen wangât sirâm patâ yen ândinetâ mirâ ŋâtiksâbam uap?’ ");
INSERT INTO kpf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mâsikâziŋgi zen itâ sâwe, ‘Nen nep ŋâi mân sâm niŋge.’ Sâne dâzâŋgom sâŋgonzâŋgom sâip, ‘Waiŋ nepŋâ ziap. Zo âi tuunek.’ ");
INSERT INTO kpf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nep mariŋandâ yatâ oi ŋâtiksâi nep galem a dukum sâip, ‘Gâ nep a diiziŋgâna gane kât ziŋgâban. Oi bet ge, zeŋgâren topkwap ziŋgâm âim ziŋgâm naŋgâban.’ ");
INSERT INTO kpf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Oi bet gawe, zo sâi gawe. Gane bâtnâmbut bâtnâmbut ziŋgâm naŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ziŋgi kândom gawe, zo ekŋâ sâŋgân mem zâi pam niŋgâbâmap sâne galem a bâtnâmburâk ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kât yatâ memŋâ nep mariŋâ den bâliŋ dukum kuk okŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Oi itâ sâwe, ‘Bet ge, zen nep bituk tuuge. Nen ko sirâm patâ nebân sâknam patâ nâŋgâm kirindâ ŋâtiksap. Oi wangât bet a zeŋgât dâp yatik niŋgat?’ ");
INSERT INTO kpf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yatâ sâne nep mariŋandâ zeŋgâren gâbâ ŋâi itâ dukuip, ‘Buku, nâ mân mem bâliŋ otgigan. Kât bâtnâmbut sa nâŋgâna âlip uap, zo ka. ");
INSERT INTO kpf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Zorat kâtkâ mem âi. Nâ bet ge, zen sot kât dâbâk ziŋgâbatkât nâŋga âlip uap. ");
INSERT INTO kpf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ninâ kut ŋâi ŋâi, zorâŋ yatâ upâ sâm âlip upat. Nâ âlip uan, zorat umgâ bâliap?’ ");
INSERT INTO kpf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Zo yatik a betŋâ kândom upi. A kândomŋâ bet upi.” ");
INSERT INTO kpf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Oi Yesuŋâ Yerusalem kamânân zâibam arâpŋâ kiin zagât diiniŋgi niiŋik âiwen. Mâtâbân âim itâ sâm dâtnâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Zen den nâŋgânek. Nen Yerusalem kamânân zâinamen. Zoren a bonŋâ, nâ tirik namâ galem a sot Kembugât gurumin den zorat galem a, zeŋgât bitziŋan zariandâ mumbatkât sâbi. ");
INSERT INTO kpf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Zen um kâtik zeŋgât bitziŋan nâbane ziŋâ nom sinnan gemŋâ poru nagân none mumbat. Mom sirâm karâmbut zem zaatpat.” ");
INSERT INTO kpf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Narâk zoren Zebedaio ambinŋandâ nanzatŋâ diizikâm Yesugât um topŋan âi simin liim pindiŋsâm dukuip. ");
INSERT INTO kpf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Oi Yesuŋâ mâsikâm sâip, “Gâ wangât otgigap?” Sâi ambân zorâŋâ sâip, “Gâ a kutâ tâtarân tâtna nanzatnâ, zikŋâ gâgât âsangâ toren toren tâpabot.” ");
INSERT INTO kpf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Sâi Yesuŋâ itâ sâm dukuip, “Zen den topŋâ mân nâŋgâm itâ se. Nâ too kâlakŋâ nimbat, zo zet âlip nimbabot?” Sâi zikŋâ itâ sâwet, “Net âlip nindat.” ");
INSERT INTO kpf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sâitâ dâzâkom sâip, “Too kâlakŋâ nimbat, zo âlip nimbabot. Ka âsannan tâtatŋâ, zorat den nâgâren mân ziap. Ibânandâ sâm ziŋgip, a zorâŋâ tâtat zoren tapi.” ");
INSERT INTO kpf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Oi arâp bâzagât, nen den zo nâŋgâm kuk otzikâwen. ");
INSERT INTO kpf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Oi Yesuŋâ sâi gâindâ itâ sâm dâtnâŋgoip, “Hân a kutâ, zen kembu otziŋgâm kore aziŋ gâsuziŋgâme. Oi a zâizâiŋ, zen a gigiŋ walâziŋgâm a kutâ upme. Zo nâŋgâme. ");
INSERT INTO kpf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Zen ko yatâ mân upi. Zeŋgâren gâbâ a ŋâiŋâ a kutâ upâ sâm a gigiŋâ yatâ op ândibap. ");
INSERT INTO kpf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ŋâi zâk a sâtŋâ upâ sâm kore otziŋgâm ândibap. ");
INSERT INTO kpf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","A bonŋâ, nâ zo yatik ziŋâ kore otnibigât buŋâ. Ninak a doŋbep zeŋgât kore opŋâ suupziŋ mimbatkât gewan.” ");
INSERT INTO kpf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu sot arâpŋâ, nen Yeriko kamân birâm arindâ a doŋbepŋâ moliniŋgâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Oi a zagât sinzikŋâ bâpsâsâŋ mâtâbân tapŋâ Yesu gam ariap sâne nâŋgâm den kâtikŋâ den sâm sâwet, “Kembu, gâ Dawidigât kiunŋâ, nekât umgâ bâliŋ oik.” ");
INSERT INTO kpf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Den doŋbep sâitâ a ziŋâ kwerâzikŋâ sâwe. Hiriŋsâm tâpabotkât sâwe. Oi zet nâŋgâm tâtâlim sâwet, “Kembu, Dawidigât kiunŋâ, nekât umgâ bâliŋ oik.” ");
INSERT INTO kpf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu zâk mâtâbân kin sâi gâitâ mâsikâzikip, “Dap otzikâbatkât sabot?” ");
INSERT INTO kpf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Sâi itâ sâwet, “Kembu, sinnikŋâ mânâŋgâtna iktâ.” ");
INSERT INTO kpf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sâitâ Yesuŋâ umŋâ nâŋgâmŋâ sinzikŋan weegi zet sinzikŋâ igâwet. Oi Yesu molim ba âiwet. ");
INSERT INTO kpf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Oi nen Yerusalem kamânân takânam urâwen. Oi Betepage kamân Oliwa bakŋâ topŋan tâip, zoren takâmŋâ Yesuŋâ arâpŋâ neŋgâren gâbâ a zagât sâŋgonzâkoip. ");
INSERT INTO kpf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Zâk itâ sâip, “Zet kamân ândiren âimŋâ doŋgi mamŋâ sot sigan tâgân saane kinzabot, zo zikitŋâ olaŋ diizikâm gâbabot. ");
INSERT INTO kpf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Zet yatâ oitâ ŋâiŋâ zikitsâi sâbabot, ‘Kembuniŋaŋgâren nep ŋâi muyagei zirat sap.’ Yatâ sâitâ ziki diim gâbabot.” ");
INSERT INTO kpf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Zo yen buŋâ. Propete ŋâiŋâ den sâip, zo bonŋâ oip. Zâk den itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zen Yerusalem kamân, Sioŋ mâirâp dâzâŋgonek, ‘Iknek. A kutâziŋâ gigiŋâ op zeŋgâren gaap. Zâk doŋgi sigan kwâkŋan tap gaap. Sikum lamap, zorat kwâkŋan tâi gabot.’” ");
INSERT INTO kpf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","7","Oi a zagât zo Yesugât den lum âiwet. Âimŋâ doŋgi mam murarâ diizikâm gâitâ hâmbâniŋ kwâkŋan pâindâ Yesuŋâ zâi tâip. ");
INSERT INTO kpf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Oi a kâmut patâ, zeŋgâren gâbâ doŋbepŋâ hâmbâziŋ kwâkâm mâtâbân parâwe. Oi a nâmbutŋandâ gâlaŋgât sot lâkom ilumŋâ mânâŋgât pam diim âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Oi a kâmut patâ, zen mem oset kwâkŋaŋgâm itâ sâm pam diim âiwe, “Oe, Dawidigât kiunŋâ gam niŋgap. Kembugât sâtkât gaatkât sâm âlip kwatginâ. Oe, sumbem mâriŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yerusalem kamânân zari kamân mâirâpziŋâ umziŋâ zari sâwe, “A zi ŋâiŋâ gâi ue?” ");
INSERT INTO kpf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Sâne a ambân kâmut gâwe, zorâŋ itâ sâm dâzâŋgowe, “Propete Yesu, zâk Galilaia gokŋâ, Nasarete kamânân gâbâ gaap.” ");
INSERT INTO kpf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuŋâ tirik namin zari kut ŋâi ŋâi aŋgâgwaŋgâ op ziwe, zo moliziŋgi âiwe. A nâmbutŋâ, zen Roma zeŋgât kât sot Yuda zeŋgât kât, zo hâukwap aŋgâgwaŋgâ op kirâwe. Kât tâtatŋâ sot kembâ mâirap zeŋgât tâtat, zo kom kâbakŋem dâzâŋgom sâip, ");
INSERT INTO kpf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“Kembugât den kulem ŋâi itâ ziap, ‘Namânâ zi ninâu namâ upap.’ Zen ko utnetâ kâmbu a zeŋgât kât ki silep yatâ uap.” ");
INSERT INTO kpf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Oi zoren ândei a sinziŋ bâpsâsâŋ sot kinziŋ bâliŋâ, zen zâkkâren âine kubikziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yatâ oi tirik namâ galem a patâ sot Kembugât gurumin den galem a, zen kulem zo igâwe. Oi katep zen tirik namin zâi den kâtikŋâ sâm sâwe, “Oe, Dawidigât kiunŋâ, gâ gam niŋgat.” Yatâ sâne Parisaio sot gurumin den galem a, zen nâŋgâm bâliŋ kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Oi Yesu itâ dukum sâwe, “Den sâm te, zo nâŋgat?” Sâne sâip, “Ee, nâŋgan. Oi Kembugât ekabân den ŋâi ziap, zo sâlâpkume mo buŋâ? Den zo itâ, ‘Katep sot namân gokŋâ, zeŋgât um mem bâbâlâŋ kwatna lâuziŋan gâbâ gâgât sâtâre muyagiap.’” ");
INSERT INTO kpf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yatâ dâzâŋgom birâziŋgâm Yerusalem kamânân gâbâ geim Betania kamânân zari ŋâtiksâi zeip. ");
INSERT INTO kpf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Haŋgârâk Yesuŋâ kamân patin puriksâm tepŋaŋgât oip. ");
INSERT INTO kpf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Oi mâtâbân âim wakum nak ŋâi ekŋâ topŋan âi keetŋâ kârui buŋ oi ilumŋik kiri egip. Ekŋâ nak itâ sâm dukuip, “Gâgâren bongâ mânâk âsagibap.” Yatâ sâi zorenâk ilumŋâ mom hâlâlâŋsâm kirip. ");
INSERT INTO kpf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Oi arâpŋâ nen zo ekŋâ imbaŋâniŋ buŋ oi sâlâpniŋan zim kirâwen. Oi itâ sâwen, “Nak zi dap opŋâ kek hâlâlâŋsap?” ");
INSERT INTO kpf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yatâ sâindâ Yesuŋâ sâip, “Nâ perâkŋak dâzâŋgobâ. Zen um zagât mân opŋâ nâŋgâm pâlâtâŋziŋâ bonŋâ op ândibi. Yatâ op ândine sâi nagân kulem âsagiap, zorik buŋâ. Zen bakŋâ ândi dukubi, ‘Bakŋâ, gâ pâuksâm saruin gei.’ Yatâ sâne dinziŋâ lubap. ");
INSERT INTO kpf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Oi nâŋgâm pâlâtâŋziŋ bonŋoot ândim wan mo wangât ninâu sâne muyageziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Oi Yesuŋâ âimŋâ tirik namin zâim den siŋgi âlip dâzâŋgom tâi tirik namâ galem a patâ sot a sâtŋâ, zen zâkkâren gam itâ sâm mâsikâwe, “Gâ ziren kut ŋâi ŋâi opmat, zo ŋâigât sâtkât opmat? Ŋâiŋâ dâgogi opmat?” ");
INSERT INTO kpf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sâne Yesuŋâ itâ mâburem dâzâŋgom sâip, “Nâ den kânok mâsikâziŋga dâtnone nâŋgoot yatik ŋâigât sâtkât kut ŋâi ŋâi opman, zorat dâzâŋgobat. ");
INSERT INTO kpf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohane too saŋgon nep tuugip, zo ŋâigât sâtkât nep tuugip? Anutugât sâtkât mo agât sâtkât?” Yatâ sâm mâsikâziŋgi zen ziŋik den dap sânâ sâm um zagât op itâ âraguwe, “Nen Anutugât sâtkât sâindâ sâbap, ‘Wangât diŋâ mân luwe?’” ");
INSERT INTO kpf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Agât sâtkât tuugip yatâ sânam a zeŋgât keŋgât urâwe. Wangât, a zen aksik patâ Yohanegât Propete sâme, zorat. ");
INSERT INTO kpf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Zen yatâ sâm Yesu itâ sâm dukuwe, “Nen mân nâŋgen.” Sâne Yesuŋâ itâ mâburem dâzâŋgom sâip, “Den zo dâtnoge sâi ko nâŋgoot ŋâigât sâtkât opman, zo dâzâŋgobam. Ka zen mân dâtnoge, zorat nâŋgoot mân dâzâŋgobat.” ");
INSERT INTO kpf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Den ŋâi dâzâŋgua nâŋgânek. A ŋâigât nanzatŋâ zagât ândiwet. Oi ibâŋandâ nanŋâ ŋâi itâ sâm dukuip, ‘Nannâ, gâ irak âi waiŋ nep tuuban.’ ");
INSERT INTO kpf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Dukui sâip, ‘Âlip âi tuubat.’ Yatâ sâmŋâ âi gulip op ândeip. ");
INSERT INTO kpf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Oi ibâŋandâ nanŋâ ŋâi yatik dukum sâŋgonguip. Sâi, ŋâiŋâ âi tuubap, yatâ sâmŋâ bet umŋâ nâŋgâm laŋ âi tuugip.” ");
INSERT INTO kpf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yatâ sâmŋâ Yesuŋâ mâsikâziŋgip, “Zen sânek. Ŋâi katepŋâ ibâŋaŋgât den lugip?” Sâi ziŋâ dukum sâwe, “Den bet dukuip, zorâŋâ.” Yatâ sâne Yesuŋâ sâip, “Nâ perâkŋak dâzâŋgobâ. Kât mimiŋ a sot laŋ mâme ambân, zen Anutugât um topŋan bagine zen ko kândâtŋâ upi. ");
INSERT INTO kpf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohane takâmŋâ târârak ândiândigât mâtâp tirâpzâŋgoi zen birâŋaŋgâne bâliŋ mâme a sot laŋ mâme ambân, zen zâkkât den nâŋgâm kwâtâtiwe. Yatâ utne zen ziŋgitŋâ umziŋ mân âbureip.” ");
INSERT INTO kpf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Nâ den sumbuŋâ ŋâi sa nâŋgânek. A kutâ ŋâiŋâ hân ŋâin waiŋ nep kârâm kâmit dâmân paset tuugip. Tuumŋâ tâk keetŋâ mândâlibapkât âmaŋ patâ tuum galem a zeŋgât mirâ tuugip. Tuum naŋgâm galem a bitziŋan pam hân ŋâin âi ândeip. ");
INSERT INTO kpf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Zoren ândei bonŋâ mimiŋ narâk oi kore arâpŋâ bonŋâ nâmbutŋâ mimbigât sâŋgonzâŋgoi galem a zeŋgâren gawe. ");
INSERT INTO kpf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Gane galem a ziŋâ a zo gâsuziŋgâm ŋâi kom kâbakŋiwe. Oi ŋâi gâsum kune moip. Oi ŋâi kâtŋâ kuwe. ");
INSERT INTO kpf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yatâ utne nep mariŋandâ nâŋgâm a doŋbep sâŋgonzâŋgoi âine yatik otziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Oi bet zikŋâ nanŋâ, zo itâ sâm sâŋgongoip, ‘Nannâ ari ekŋâ hurat kwâkŋaŋgâbi.’ ");
INSERT INTO kpf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Oi galem a, zen nanŋâ zo ekŋâ itâ sâm âraguwe, ‘Zâkŋâ gâtâm nep zi mariŋâ upap, zorat nen komŋâ nep zi mâriŋâ oindâ neŋgât upap.’ ");
INSERT INTO kpf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yatâ sâmŋâ nebân gâbâ kom geim kune moip. ");
INSERT INTO kpf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nep mariŋandâ gamŋâ galem a dap otziŋgâbap?” ");
INSERT INTO kpf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yesuŋâ yatâ sâi a ziŋâ itâ dukuwe, “Kut ŋâi ŋâi sumunŋâ okŋaŋgâwegât zâkoot yatik otziŋgâbap. Oi nepŋan galem a âlipŋâ zâmbari zen narâk dâp nalem bonŋâ pindâm ândibi.” ");
INSERT INTO kpf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yatâ sâne Yesuŋâ itâ târokwap dâzâŋgoip, “Kembugât ekabân den itâ ziap, zo sâlâpkum nâŋgâme? ‘Mirâ tuutuuŋ a, zen kunkun ŋâi ekŋâ âkon op birâwe. Kembuŋâ kunkun zo mem namin kwânâŋgi kinzap. Kembuŋâ sâi yatâ âsageip. Niŋâ egindâ mârâtŋâ ŋâi uap.’ ");
INSERT INTO kpf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nâ zorat dâzâŋgua nâŋgânek. Anutu um topŋan ândiândiŋâ, zo zen betziŋan mem a kâmut uŋakŋâ ziŋgâbap. Oi ziŋâ bonŋâ muyagibi. ");
INSERT INTO kpf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(‘A ŋâi zâk kunkun zorâŋ kom sâkŋâ tâmbetkubap. Oi kunkun zorâŋâ a ŋâi kwâkŋan kumbap, zo ko kom kwândâlibap.’”) ");
INSERT INTO kpf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Den sumbuŋâ yatâ sâi tirik namâ galem a sot Parisaio a, zen nâŋgâm sâwe, “Zo neŋgât op sap.” ");
INSERT INTO kpf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yatâ nâŋgâm gâsum kunat sâm nâŋgâm, a zen Yesugât Propete sâmarâwe, zo nâŋgâm keŋgât op birâwe. ");
INSERT INTO kpf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu zâk den sumbuŋâ ŋâi târokwap itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Siŋgi âlipkât mâtâp, zo itâ. A kutâ ŋâiŋâ sii nalem oip, zoren dâpkwap sâbâ. A kutâ, zâk nanŋâ ambân pindâbam sii nalem mei gâip. ");
INSERT INTO kpf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yatâ opŋâ kore arâpŋâ sâŋgonzâŋgoi zen zop kânŋan sâsâŋâ, zo diiziŋgânam âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Âi sâne mân nâŋgâne kore a dum sâŋgonzâŋgom sâip, ‘Zen âimŋâ a zop sâsâŋâ, zo dâzâŋgonek, “Zen nâŋgânek. Patâniŋâ itâ sap, ‘Nâ sii nalem mia gaap sot bâu makau sa gaam ue. Oi kut ŋâi ŋâi mem târâkbârâk uen, zorat zen ganetâ a ambân mâpotzikâm nem sâtâre utnat.’” ’ ");
INSERT INTO kpf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","A zen âim yatâ dâzâŋgone den zo nâŋgâne yenŋâ oi a ŋâi zâk nepŋan arip. Ŋâi zâk hibukŋan arip. ");
INSERT INTO kpf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A nâmbutŋandâ ko kore a kâsa otziŋgâm zâŋgone muwe. ");
INSERT INTO kpf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yatâ utne a kutâŋâ nâŋgi bâlei kuk yâmbâtŋâ op kâwali a gakâŋâ sâi âimŋâ a zâŋgomŋâ kamânziŋâ kârâp une seip. ");
INSERT INTO kpf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Oi a kutâ, zâk kore a itâ sâm dâzâŋgoip, ‘Sii nalem zo mârum kubiksen. Oi a zeŋgât zop sâsâŋ, zo âkonziŋgi bire. ");
INSERT INTO kpf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Zorat zen mâtâp kâukŋan âim a muyageziŋgâm zen aksik diiziŋgâm gabi.’ ");
INSERT INTO kpf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Sâi arâpŋâ zen mâtâp kâukŋan âi tap a âlipŋâ sot a bâliŋâ, zo aksik diiziŋgâne gam mirâ piksâm tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tatnetâ a kutâŋâ ziŋgitpam zâimŋâ a ŋâi kendongât hâmbâ âlipŋâ mân pam tâi egip. ");
INSERT INTO kpf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ekŋâ itâ sâm dukuip, ‘Arâ, gâ dap op hâmbâ buŋ ga taat?’ Sâi a zo suluk mem tâip. ");
INSERT INTO kpf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Oi a kutâŋâ arâpŋâ dâzâŋgom sâip, Zen kiŋ bikŋâ saam âkŋan ŋâtâtigân kâbakŋine giarik. Zoren gemŋâ umbâlâ op isem zimbap.’ ");
INSERT INTO kpf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kembuŋâ a ambân zop dâzâŋgomap, zo doŋbep. Ka mem sâlâpzâŋgomap, zo bituktâ.” ");
INSERT INTO kpf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yesuŋâ yatâ sâm dâzâŋgoi Parisaio a, zen denŋâ dap sâm saanat sâm den sâm kubigâwe. ");
INSERT INTO kpf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yatâ opŋâ arâpziŋâ sot Herodegât a nâmbutŋâ sâŋgonzâŋgone zen Yesugâren âim itâ sâwe, “Patâ, nen gâgât topkâ nâŋgâmen. Den sarâ mân sâm, den bonŋik sâmat. Oi Anutugât mâtâp, zorat a zâizâiŋ gigiŋ pisuk târârak dâtnâŋgomat. A patâ mân walâziŋgâm den mân sâmat. ");
INSERT INTO kpf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Zorat mâsikâgindâ dâtnâŋgo. Roma a kutâ patâ Sisa kât pindânat, zo orotŋâ mo mân orotŋâ?” ");
INSERT INTO kpf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yatâ sâne Yesuŋâ sarâziŋaŋgât topŋâ nâŋgâm itâ sâm dâzâŋgoip, “Sarâ a zen. Zen wangât denŋâ saanige? ");
INSERT INTO kpf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Zen kât pame, zo tirâpnone ikpâ.” Sâi kât ŋâi mem tirâpkuwe. ");
INSERT INTO kpf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesuŋâ mâsikâziŋgâm sâip, “Zo ŋâigât holi tobat sot kutŋâ ziap?” ");
INSERT INTO kpf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sâi ziŋâ sâwe, “Zi a kutâ Sisagât.” Sâne itâ sâip, “Sisagât siŋgi, zo Sisa pindâbi. Ka Anutugât siŋgi, zo Anutu pindâbi.” ");
INSERT INTO kpf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yatâ sâm dâzâŋgoi zen nâŋgâne imbaŋâ oi birâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sirâm zoren Sadukaio a, zen Yesugâren gawe. A zo momŋâ zaatzaat, zo mân ziap sâmarâwe. Zen Yesu den mâsikâm itâ sâwe, ");
INSERT INTO kpf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Patâ, Mose zâk den itâ sâm kulemgoip, ‘A ŋâiŋâ ambân mem kiun buŋ ândim moi munŋandâ malâ zo mimbap. Oi âtâŋaŋgât siŋgi katep muyagibap.’ ");
INSERT INTO kpf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oi neŋgâren âtâ mun nâmburân zagât ândiwe. Oi âtâziŋ kunŋâ ambân memŋâ kiun buŋ ândim moi munŋandâ malâ zorik meip. ");
INSERT INTO kpf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Zâk yatigâk kiun buŋ ândim moi munŋandâ malâ zorik meip. Yatâ opŋâ âtâ mun nâmburân zagât, zo ambân kânok zorik mem mom naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bet ambân malâziŋâ, zo moip. ");
INSERT INTO kpf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Oi zen aksik patâ ambân zorigâk miwe, zorat mumuŋan gâbâ zaatzaat narâkŋan ambân zo ŋâigât upap?” ");
INSERT INTO kpf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Zen Kembugât den sot Kembugât imbaŋâ kârum den sâm gulipkume. ");
INSERT INTO kpf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Zaatzaat narâkŋan a ambân, zen mân miaŋgâm ândibi. Sumbem a yatâ op ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Oi zen zaatzaatŋaŋgât sâme, zorat dâzâŋgobâ. Anutuŋâ den itâ sâm dâzâŋgoip, zo zen sâlâpkum nâŋgâme mo buŋâ? Den zo itâ, ");
INSERT INTO kpf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nâ Abaram sot Isaka sot Yakobo, zeŋgât Anutu.’ Nâ zorât sa nâŋgânek. Zâk mom buŋ urâwe, zeŋgât Anutu buŋâ. Gwâlâ ândie, zeŋgât Anutu. Zorat Abaram sot Isaka sot Yakobo, zen mân buŋ urâwe. Anutu sot gwâlâ ândie.” ");
INSERT INTO kpf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yesuŋâ den yatâ sâi a ambân kâmut patâ, zen siŋgi âlip sâip, zorat nâŋgâne imbaŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesugât denŋâ Sadukaio a walâziŋgip, zo Parisaio a zen nâŋgâmŋâ mindue. ");
INSERT INTO kpf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Zeŋgâren gâbâ bukuziŋâ ŋâi Kembugât gurumin den nâŋgânâŋgâ a, zâk dukune zâk Yesu mâsikâmŋâ sâip, ");
INSERT INTO kpf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Patâ, Kembugât den gurumin ikâ zorâŋ kâukŋâ patâ uap?” ");
INSERT INTO kpf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sâi Yesuŋâ itâ sâm dukuip, “‘Gâ um dâpkâ sot nâŋgânâŋgâgâ, zo hâlâluyâk Kembu Anutugâ pindâna zimbap.’ ");
INSERT INTO kpf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Gurumin den zorâŋ patâ uap. ");
INSERT INTO kpf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Oi torenŋâ ŋâi itâ ziap. Zo itâ, ‘Gâ gikâŋgât otgimap, zo yatik a toren zeŋgât otgibap.’ ");
INSERT INTO kpf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Gurumin den zo, zet Mose sot Propete zeŋgât den topŋâ uabot.” ");
INSERT INTO kpf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisaio a, zen mindum tatne Yesuŋâ itâ sâm mâsikâziŋgip, ");
INSERT INTO kpf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Zen Kristogât dap dap nâŋgâme? Zâk ŋâigât kiun?” Sâi ziŋâ sâwe. “Zâk Dawidigât kiunŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Dap op Kaapumŋâ Dawidi nâŋgânâŋgâ mâtâp pindi Kristogât kembunâ sâip? ");
INSERT INTO kpf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Zo itâ sâip, ‘Kembuŋâ nâgât kembu itâ sâm dukuip, “Gâ âsannâ bongen tâtna kâsarâpkâ minduziŋga kiŋgaŋgât kombâŋ upi.” ’ ");
INSERT INTO kpf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dawidi zâk Kristogât kembunâ sâip, zorâŋ dap op kiunŋâ uap?” ");
INSERT INTO kpf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yatâ sâm mâsikâziŋgi den hâuŋâ sânam kwagâwe. Narâk zoren gâbâ a zen dum mâsikânam keŋgât op birâwe. ");
INSERT INTO kpf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Narâk zoren Yesuŋâ arâpŋâ sot a nâmbutŋâ itâ sâm dâtnâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Kembugât gurumin den zorat galem a sot Parisaio a, zen Mosegât gebâkŋan tapme. ");
INSERT INTO kpf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Zorat den dâzâŋgome, zo lum ândibi. Ka zeŋgât ândiândiziŋan mân ândibi. Wangât, zen den sâme, zo mân lum ândime, zorat. ");
INSERT INTO kpf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Zen kut ŋâi ŋâi yâmbâtŋâ, zo saam a ambân kwâkziŋan pam ziiŋâ bet bâsaŋ ândime. ");
INSERT INTO kpf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kut ŋâi ŋâi upme, zo aŋâ ziŋgit nâŋgâbigât upme. Zen ninâu kârep sâme. Zen Mosegât den lum Kembugât den ekabân kulemgum mâteziŋan sot bâranziŋan saam ninâu sâme. Oi hâmbâziŋan neule top topŋâ mem ândime. ");
INSERT INTO kpf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Oi mâpâmâpâse namin sot sii nalem minduminduyân a sâtŋâ tâtarân tâtnat sâme. ");
INSERT INTO kpf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Oi sombemân a ambân sâm âlip kwâtniŋgâbigât ândime. Oi kutniŋâ patâ nâŋgonsâbigât kindap kwap ândime. ");
INSERT INTO kpf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Zeŋgât ko a ambân ziŋâ patâ sâne mân dâp upap. Patâziŋâ, zâk kânok. Zen patâ buŋâ. Zen aksik ombeŋan. ");
INSERT INTO kpf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Oi hânân zi a ŋâigât Ibâniŋâ mân sâbi. Ibâziŋâ sumbemân ândiap, zâk kânok. ");
INSERT INTO kpf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Oi zen a ŋâigât a kembu patâ mân sâbi. A kembuziŋâ Kristo, nâ kânok. ");
INSERT INTO kpf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Zeŋgâren gâbâ a ŋâi patâ upapŋâ, zâk a nâmbutŋâ zeŋgât kore op ândibap. ");
INSERT INTO kpf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ŋâi zâk zikŋaŋgât nâŋgi zari diim gibap. Ka ŋâi zâk zikŋaŋgât nâŋgi gibap, zo diim zâibap.” ");
INSERT INTO kpf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Yei, Kembugât gurumin den zorat galem a sot Parisaio a, zen sarâ a. A ambân, zen sumbemân zâinam utne zen mâtâp laŋ dooŋgume. Ziiŋâ mân zâim zâk ziŋâ baginâ sâne keŋgât minziŋgâme. ");
INSERT INTO kpf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yei, Kembugât gurumin den zorat galem a sot Parisaio, zen sarâ a. Zen malâ mandu zeŋgâren ninâu kârep sâm mirâ motziŋâ laŋ mime. Zorat Anutuŋâ hâuŋâ yâmbâtŋâ otziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Yei, Kembugât gurumin den zorat galem a sot Parisio, zen sarâ a. Zen a kânok zeŋgât a upapkât saru sot hân walâm âime. Oi a yatâ zorâŋ zeŋgâren târokwap ândim simgât siŋgi upap. A zorat bâliŋandâ wâlâziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yei, a sâtŋâ sinziŋ bâpsâsâŋ. Zen itâ sâme, ‘Tirik namin kwap den sâm kâtigime, zo tabâŋâ. Tirik namin neule mot taap, zoren kwap den sâm kâtigime, zorâŋ kâtigem bon upap.’ ");
INSERT INTO kpf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Zen a sinziŋ bâpâsâŋ sot nâŋgânâŋgâziŋ buŋâ. Tirik namâ, zo tirik taap. Neuleŋâ, zo yatik tirigâk uap. Zorat ko ikâ zorâŋâ bonŋâ uap? Namâ mo neuleŋâ? ");
INSERT INTO kpf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Oi ŋâi itâ sâme, ‘Kembugât siŋgi nalem pâpanŋâ, zoren kwap den sâm kâtigime, zo tabâŋâ. Nalem mot pame, zoren kwap den sâm kâtigime, zo bonŋâ.’ ");
INSERT INTO kpf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","A sinziŋ ŋâtâtik, zen. Nalem pâpanŋâ, zo hâlâlu taapkât nalem kwâkŋan pame, zo tirik uap. Zorat ikâ zorâŋâ bonŋâ uap? Nalem pâpanŋâ mo nalemŋâ? ");
INSERT INTO kpf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Zorat ŋâi zâk nalem pâpanŋan mândâm sâm kâtigei nalem pâpanŋâ sot kut ŋâi ŋâi kwâkŋan taap, zo ârândâŋ dâbâk upabot. ");
INSERT INTO kpf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Oi ŋâi zâk tirik namin kwap sâm kâtigei namâ zikŋâ sot umŋan ândiap, zet ârândâŋ dâbâk upabot. ");
INSERT INTO kpf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ŋâi zâk sumbemân kwap sâm kâtigei Anutugât tâtatŋâ sot tâtat zorat mariŋoot dâbâk upabot. ");
INSERT INTO kpf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yei, Kembugât gurumin den zorat galem a sot Parisaio, sarâ a, zen. Zen daŋgât sot kâŋgan sot zomap, kut ŋâi ŋâi zo bâzagârân gâbâ kânok Kembugât siŋgi sâm pame. Oi zorat toren bonŋâ, gurumin den luluŋ sot a buku otziŋgâziŋgâŋ sot nâŋgâm pâlâtâŋ sot târârak ândiândiŋ, zo birâne gei komap. Zo toren toren luzikâne dâp upap. ");
INSERT INTO kpf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","A sâtŋâ sinziŋâ ŋâtâtik sâsâŋâ, zen kabât mâik mâik, zo ikme. Ka bâu mo kut ŋâi ŋâi patâ, zo mân ikme. ");
INSERT INTO kpf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Yei, Kembugât gurumin den zorat galem a sot Parisaio, zen sarâ a. Hâkop sâkŋik too saŋgon kubik tuume. Oi umŋan ko kâmbu sot sâkziŋaŋgât âkŋâle bâliŋâ, zo piksâm ziap. ");
INSERT INTO kpf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","O Parisaio a, zen sinziŋ ŋâtâtik. Hâkop umŋan bâliŋâ ziap, zo saŋgonne âlip oi sâkŋan âlip upap. ");
INSERT INTO kpf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Yei, Kembugât gurumin den zorat galem a sot Parisaio, sarâ a, zen. Zen a mumuŋâ zeŋgât kwagân ziap yatâ. Kwakŋâ zo kwâkŋan kâsâget pane neuleŋoot zemap. Umŋan ko a siŋit sot guk maŋguleŋ ziap. ");
INSERT INTO kpf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Zen yatik sâkziŋandâ a mâteziŋan târârak ândime. Umziŋan ko sarâ sot gurumin den kukuŋâ piksâm ziap. ");
INSERT INTO kpf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yei, Kembugât gurumin den zorat galem a sot Parisaio a, sarâ a zen. Zen Propete a kwagân pitâme. Zen a târârakŋâ zeŋgât kwagân neule pam ândime. ");
INSERT INTO kpf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Zen itâ sâme, ‘Sâkurâpniŋâ ândiwe, narâk zoren ândim sâi ko betziŋan mem Propete mân zâŋgobem.’ ");
INSERT INTO kpf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Zen yatâ sâm Propete zâŋgowe, zeŋgât kiun ândime. Zeŋgât topziŋâ sâm muyagime. ");
INSERT INTO kpf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sâkurâpziŋ zen tosa kwâkŋan kwâkŋan pam gawe. Zen yatik târokwapkwap utnetâ tosaziŋ dâbâk upap. ");
INSERT INTO kpf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mulumgât kiurâp zen. Tosagât hâuŋâ kârâbân geigeiŋ narâk oi waniŋ âi tik pambi? ");
INSERT INTO kpf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Zorat sa nâŋgânek. Nâ ninak zeŋgâren Propete sot nâŋgânâŋgâ a sot Kembugât gurumin den zorat galem a nâmbutŋâ sâŋgonzâŋgua zeŋgâren gane nâmbutŋâ zen zâŋgom sâknam ziŋgâbi. Oi nâmbutŋâ poru nagân zâŋgobi. Oi nâmbutŋâ mâpâmâpâse namâziŋan lapitziŋgâne kamân ŋâin ŋâin âine moliziŋgâm âim zâŋgobi. ");
INSERT INTO kpf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yatâ utnetâ a târârak gilâmziŋ hânân geip, zorat hâuŋâ zeŋgâren muyageziŋgâbap. Mârumŋan Abegâren gâbâ kâmbam topkwap târokwâi târokwâi kom gam Berekia nanŋâ Sakaria, zâk tirik namin komŋâ kâmbam zo kune âkip. ");
INSERT INTO kpf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nâ perâkŋak dâzâŋgobâ. Kâmbam zorat tosa a kâmut zi ziiŋâ hâuŋâ mimbi.” ");
INSERT INTO kpf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Yerusalem mâirâp, wangât Propete a kâmbamŋâ zâŋgome? A sâŋgonzâŋgua zeŋgâren âine kâtŋâ zâŋgone mume. Kurukŋâ gwamarâpŋâ gâbâreziŋgâm lâmbamzâŋgomap, zo yatik nâŋâ umnâ topŋan a ambân minduziŋgâbat sa kwâkâme. ");
INSERT INTO kpf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dâzâŋgua nâŋgânek. Nâ birâziŋga mandu yatâ op ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Zen dum zagât mân nek ândimŋâ itâ sâm nikpi, ‘Kembugât sâtkât gaap, zâk sâm âlip kwâkŋaŋgânâ.’” ");
INSERT INTO kpf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu zâk tirik namin gâbâ gem ari arâpŋâ nen zâkkâren âimŋâ namâ tuutuuŋâ ek nâŋgâbapkât dukuwen. ");
INSERT INTO kpf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Oi den itâ mâburem dâtnâŋgoip, “Namâ zi tâi ek mâpâsime, zorat nâ perâkŋak dâzâŋgobâ. Kâsaziŋâ gam kândaŋne giligâlaksâm buŋ op naŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Oi Oliwia bâkŋan zâi tâi arâpŋâ niiŋik um topŋan âimŋâ mâsikâm sâwen, “Sat, zo wan narâkŋan âsagibap? Oi gikâ gâban narâkŋâ sot hân âkâbapkât narâkŋâ oi wan wesâk ŋâi âsagibap?” ");
INSERT INTO kpf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yatâ sâindâ Yesu itâ sâm dâtnâŋgoip, “Um gulip kwatziŋgâbegât gasâziŋ kârâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","A doŋbepŋâ gam itâ sabi, ‘Nâ Kristo. Bâliŋan gâbâ mâkâziŋgâbapkât sâsâŋ, zo nâ.’ Yatâ sâmŋâ a ambân doŋbep patâ um gulip kwatziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Zen kâmbam goorân mo kârebân âsagei nâŋgâmŋâ mân keŋgât upi. Kâmbam zo yatâ muyagibapkât sâsâŋ. Oi yatâ muyagem zei narâk kek mân âkâbap. ");
INSERT INTO kpf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hânŋâ hânŋâ a kâmut mâik sot patâ, zen kâsa op agom âibi. Oi hânŋâ hânŋâ pu patâ sot wâriŋ mem zimbap. ");
INSERT INTO kpf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kut ŋâi ŋâi zo sâknam patâ zorat topkwâkwatŋâ. Zo yatâ nâŋgâm ândibi.” ");
INSERT INTO kpf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Narâk zoren sâknam kwatziŋgâm zâŋgone mumbi. Zen nagât opŋâ hânŋâ hânŋâ a, zen um kâlak otziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kut ŋâi ŋâi yatâ zo âsagei a doŋbepŋâ siŋgi âlip birâm kâsa oraŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Oi propete a sarâŋâ asâgemŋâ a doŋbep um gulip kwatziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gurumin den kukuŋâ, zorâŋ laŋ kâri a doŋbepŋâ buku orotŋâ, zo birâbi. ");
INSERT INTO kpf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ŋâi zâk den siŋgi âlip mem kâtigem ândei narâkŋâ âki sumbem kamânân bagibap. ");
INSERT INTO kpf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Oi Anutu um topŋan ândiândigât siŋgi âlip, zorâŋ laŋ kârâm hânŋâ hânŋâ âim a topziŋâ sâm muyagei hângât narâkŋâ âkâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Gâtâm tâmbet tâmbet kâukŋâ tirik nâmin kwânâŋgâne kinbap. (Den zo mulunâk sâlâpkum nâŋgâbi.) Zo yatâ âsagibapkât Propete Danieŋâ mârum kânŋan sâm kulemguip. ");
INSERT INTO kpf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Zo yatâ âsagei ekŋâ Yudaia hânân ândibiŋâ barâ kâtikŋan sârârâk kârâm âibi. ");
INSERT INTO kpf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ŋâi zâk mirâ sombemân ândibapŋâ sikumŋâ mimbam mirin mân zâibap. ");
INSERT INTO kpf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Oi a ŋâi nebân tâpapŋâ âburem hâmbâŋâ mimbapkât kamânân mân gâbap. ");
INSERT INTO kpf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Yei, ambân kâmborâ sot katep namân gok, zen dap upi? ");
INSERT INTO kpf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Zen Kembugâren ninâu sâne nâŋgi âiâiziŋâ, zo map narâkŋan mo kendonân mân muyagibap. ");
INSERT INTO kpf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Narâk zoren sâknam patâ muyageziŋgâbap. Zorat dâp hân muyageibân gâbâ mân muyageip. Oi dum mân muyagibap. ");
INSERT INTO kpf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kembuŋâ sâknam narâkŋâ zo mân mânângâri sâi a aksik buŋ upe. Kâmut gakârâpŋaŋgât opŋâ Kembuŋâ narâk zo mânâŋgâtpap.” ");
INSERT INTO kpf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“A ziŋâ Kristo ziren âsagiap mo ândiren âsagiap sâne mân nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","A sarâŋâ âsagem nâ Kristo sâbi. Propete a sarâŋâ, zen âsâgem kut ŋâi ŋâi sen mârât tuunetâ a um gulip kwatziŋgâbi. Oi Anutuŋâ gâsum sâlâpzâŋgoip, zo um gulip kwatziŋgânam osibi. ");
INSERT INTO kpf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nâ kânŋan dâzâŋguan, zorat ko muyageziŋgi mân kwakpi. ");
INSERT INTO kpf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kristo barâ kâtikŋan âsagei iksen sânetâ mân âibi. Oi Kristo mirâ zoren mo zoren âsagiap sâne mân nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hânpânŋâ âsagem hân toren torenŋan aksik âsagem kwâkâmap, zo yatâ a bonŋâ, nâ âsagibat. ");
INSERT INTO kpf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bâu mo zuu kârokŋâ ŋâi zei zoren nii keŋ, ziŋâ ninam mindume.” ");
INSERT INTO kpf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Sâknam narâkŋâ âki mirâsiŋ sumunkoi kâin âsakŋâ buŋ upap. Oi sâŋgelak, zen sumbemân gâbâ âkâm gibi. Oi Anutuŋâ sumbem mâŋgei olayaŋgâm imbaŋâ buŋâ upap. ");
INSERT INTO kpf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Narâk zoren a bonŋâ, nâgât kulem sumbemân âsagei a hânŋâ hânŋâ umbâlâ op isem zine a bonŋâ, nâ sumbem unumunum kwâkŋan kâwali mem âsakŋânoot tâka nikpi. ");
INSERT INTO kpf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Oi lâmun kwamit patâ âsagei sumbem a gakânâ sâŋgonzâŋgua hân toren toren gâbâ kâmut gakârâpnâ minduziŋgâbi.” ");
INSERT INTO kpf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Dâgap nak ziap, zorat topŋâ nâŋgâbi. Iinŋâ burutuksâi maa narâk upâmap sâme. ");
INSERT INTO kpf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Zen yatigâk kut ŋâi ŋâi zo âsagei itâ nâŋgâbi. ‘Zâk mâte otniŋgâbâmap. Zâk mâtâbân ga kinzap.’ ");
INSERT INTO kpf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nâ perâkŋak dâzâŋgobâ. A kâmut zi mân mune kut ŋâi ŋâi âsagibap. ");
INSERT INTO kpf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sumbem sot hân buŋ upabot. Ka nâgât den ko mân buŋ upap. ");
INSERT INTO kpf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kut ŋâi ŋâi muyagibap, zorat sirâm narâkŋâ a ŋâiŋâ mân nâŋgap. Sumbem a, zen mân nâŋge. Oi nanŋâ, nâ mân nâŋgan. Ibânâ, zâk zikŋik nâŋgap. ");
INSERT INTO kpf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noa ândeip, narâk zoren kut ŋâi urâwe, zo yatik a bonŋâ, nâgât takâtakâŋ narâknan yatik upi. ");
INSERT INTO kpf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Uurupŋâ mân gâi sii nalem nem ândiwe. A ambân aŋgâgwaŋgâ op miaŋgâwe. Gulip op ândine Noaŋâ waŋgâyân zarip ");
INSERT INTO kpf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Oi zen gulip op ândine too uurupŋâ gwâkâziŋgip. A bonŋâ, nâgât takâtakâŋ narâknan zo yatâ upi. ");
INSERT INTO kpf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Narâk zoren a zagât nebân kiritâ, ŋâi gâsum, ŋâi birâbat. ");
INSERT INTO kpf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ambân zagât zet nalem sobem tâitâ, ŋâi gâsum, ŋâi birâbat. ");
INSERT INTO kpf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kembuziŋâ, nâ narâk zoren mo zoren takâbat, zorat mân nâŋgegât umziŋandâ galem oraŋgâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Zen topŋâ itâ nâŋgânek. Kamân ŋâigât a, zen kâsa ŋâtik zoren takâbi, narâk yatâ nâŋgâm um wâgân ândim kamânziŋ galem upi. ");
INSERT INTO kpf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Oi a bonŋâ nâgât narâknâ mân nâŋgâne gâbat, zorat zen um wâgân ândibi.” Yatâ sâmŋâ zorat den sumbuŋâ ŋâi itâ sâm dâtnâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“A patâ ŋâiŋâ kore a gakârâpŋâ zeŋgât galem a ŋâi pam itâ sâm dukubap, ‘Nâ âi ândia galem otziŋgâm ândim narâkŋan nalem dâpziŋanâk ziŋgâm ândiban.’ A zo ândiândiŋâ dap yatâ ândei galem a nâŋgânâŋgâŋoot sot sât luluŋoot sâsâŋâ? ");
INSERT INTO kpf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Galem a, zâk patâŋâ nep diŋ sâm pindip, zo dâŋâk lum ândei patâŋâ gâbabân galem a yatâ zorat nâŋgi âlip upap. ");
INSERT INTO kpf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A kutâŋâ galem a zo patâ pam zâkkât kut ŋâi ŋâi aksik galem op ândibapkât sâbap. ");
INSERT INTO kpf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ka a ŋâiŋâ galem a bâliŋ ândim umŋandâ itâ nâŋgâbap, ‘Patânâ, zâk kârebân âimŋâ kek mân gâbap.’ ");
INSERT INTO kpf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yatâ nâŋgâm kore a ambân zâŋgom mem ŋâi ŋâi otziŋgâm too tewarân âi laŋ ândim um gulip op ândibap. ");
INSERT INTO kpf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Oi a kutâŋâ gâbap, zorât narâkŋâ mân nâŋgâm ândei zâk gâbap. ");
INSERT INTO kpf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Gâmŋâ tâkŋâ imbaŋâ lapitŋâ sarâ a zeŋgât oserân pâi ândibap. Zoren umbâlâ op isem ândibi.” ");
INSERT INTO kpf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Siŋgi âlipkât mâtâp, zo ambân sigan bâzâgât zeŋgâren dâpkwap sâbâ. Zen a kutâ mâtâbân âi muyaginam kârâpziŋ mem âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ambân sigân bâtnâmbut, zen nâŋgânâŋgâziŋ buŋ. Bâtnâmbut, zen nâŋgânâŋgâziŋoot. ");
INSERT INTO kpf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ambân nâŋgânâŋgâziŋ buŋ, zen kârâp siŋitŋik mem âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ambân nâŋgânâŋgâziŋoot, zen kârâp sot âsakŋaŋgât tooŋâ ârândâŋ mem âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Oi a kutâ, zâk mulun ândei zen mambât tap uman ziwe. ");
INSERT INTO kpf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Zinetâ ŋâtik tânâmŋâ oi den ŋâi itâ âsageip, ‘Hai, a kutâ gaap. Zen zaat zâkkâren âinek.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Oi ambân sigan, zen nâŋgâm zaat âsakŋâziŋâ kubigâwe. ");
INSERT INTO kpf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Oi ambân nâŋgânâŋgâziŋ buŋâ, zen nâŋgânâŋgâziŋoot itâ sâm dâzâŋgowe, ‘Nen kârâpniŋâ bâpsâbâmap, zorat zen too ŋâi gum niŋgânek.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sânetâ ambân nâŋgânâŋgâziŋoot, zen itâ sâm dâzâŋgowe, ‘Buŋâ. Zeŋgât dâp buŋâ. Nen dâpniŋan mem gen. Zen âi aŋgâgwaŋgâ namin kwâlânek.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Oi zen âsakŋaŋgât too kwâlânam âinetâ a kutâ gam ambân nâŋgânâŋgâziŋoot, zorik diiziŋgi âiwe. Oi kamânân âim mirin zâimŋâ hâŋgi dooŋgum sii nalem nem tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tatnetâ ambân nâŋgânâŋgâziŋ buŋ, zen gamŋâ den sâm sâwe, ‘Patâniŋâ, mâtâp mem pa.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sâne dâzâŋgoip, ‘Nâ perâkŋak dâzâŋgobâ. Nâ zeŋgât topziŋ mân nâŋgâman.’” Den sumbuŋâ zo sâmŋâ itâ sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Zen narâk mân nâŋgegât umziŋ galem oraŋgâm ândibi.” ");
INSERT INTO kpf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“A kutâ ŋâi oip, zo yatâ gâtâm âsagibap. A kutâ ŋâiŋâ kamân kârebân âibamŋâ kore aŋâ minduziŋgâm kâtŋâ galem upigât kâsâpkum ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A ŋâi kât ekap bâtnâmbut pindip. Ŋâi zagât. Ŋâi kânok. Zo nepkât imbaŋâ zem ziŋgip, zorat dâp ziŋgip. Kât ziŋgâmŋâ kamân kârebân âi ândeip. ");
INSERT INTO kpf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ari a kât ekap bâtnâmbut meip, zorâŋ nep pindi târokwap ekap bâtnâmbut âsageip. ");
INSERT INTO kpf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Oi bukuŋâ ekap zagât meip, zâkŋâ yatik oi târokwap zagât âsageip. ");
INSERT INTO kpf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ka a ekap kânok meip, zo ko hân umŋan esâm kwârakui zeip. ");
INSERT INTO kpf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Oi a kutâziŋâ narâk kârep ândim puriksâm gâip. Puriksâmŋâ kore a kât ziŋgip, zorat op minduziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Oi a kât ekap bâtnâmbut pindip, zâkŋâ nepŋâ tuugi târokwap ekap bâtnâmbut âsageip, zo tirâpkumŋâ sâip, ‘Patanâ, gâ ekap bâtnâmbut nigin, zo nep pindandâ ekap bâtnâmbut târokwap âsagiap.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sâi patâŋandâ itâ sâm dukuip, ‘Gâ kore a âlipŋâ, sât lulugoot. Kut ŋâi yenŋaŋgât galem âlip oingât nâŋâ kut ŋâi bonŋaŋgât galem gâbanbat. Zorat ko patâgâ, nâgât umnâ topŋan bagim sâtâre op ândiban.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yatâ sâi a kât ekap zagât pindip, zo gam sâip, ‘Patânâ, gâ kât ekap zagât nigin. Zorat nepŋâ tuugandâ ekap zagât târokwap muyageip.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sâi patâŋandâ itâ sâm dukuip, ‘Gâ kore a âlipŋâ, sât lulugoot. Gâ kut ŋâi yenŋaŋgât galem âlip oingât nâŋâ kut ŋâi bonŋaŋgât galem gâbanbat. Zorat gâ patâgâ, nâgât umnâ topŋan bagim sâtâre op ândiban.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Sâi bet a ekap kânok pindip, zâk gamŋâ sâip, ‘Patâ, nâ topkâ itâ nâŋgâman. Gâ a bâliŋâ. Gâ nep mân kârâm kâmitmat. Nalem muyagem nibi sâmat. A nâmbutŋâ zeŋgât kâlamân nalem nibigât sâmat. ");
INSERT INTO kpf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nâ zorat keŋgâtnaŋgât op kâtkâ hân kendâm hangua ziap. Oi zi mâburem gibâman.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Yatâ sâi patâŋâ den itâ sâm dukuip, ‘Gâ kore a bâliŋâ, konam. Lâugan gâbâ den mâburem dâgobâ. Nâgât itâ nâŋgâmat. Nâ nep mân kârâm kâmit yen tap nalem muyagenibi sâman. A zeŋgât nebân nalem meman. ");
INSERT INTO kpf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nâgât yatâ nâŋgâm kâtnâ aŋgâgwaŋgâ zeŋgâren pâna kâtnâ nep tuugi âsagei ga membam. ");
INSERT INTO kpf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Zorat zen kât ekap bekŋan mem bâzagât mem ândiap, zo pindânek. ");
INSERT INTO kpf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ŋâi zâk kut ŋâi pindâpindâŋ, zo mem galem op ândei târokwap pindâpindâŋ. Oi gom sambe muyageŋaŋgâbap. Ka ŋâi zâk kut ŋâi pindâpindâŋ, zo mân mem ândei bekŋan mei yen ândibap. ");
INSERT INTO kpf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kore a konam, zo ko gâsum ŋâtâtigân zo pane geibap. Zoren umbâlâ op isem zimbap.’” ");
INSERT INTO kpf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Gâtâm a bonŋâ, nâ sumbem âsakŋânoot sot sumbem a zeŋgât oserân gamŋâ tâtatnâ âlipŋâ, zoren zâi tâpat. ");
INSERT INTO kpf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Oi a ambân hânŋâ hânŋâ, zo minduziŋga nâgât mâtenan mindubi. Mindunetâ râma galem a râma noniŋ kâsâpzâŋgomap, zo yatik upat. ");
INSERT INTO kpf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Oi râma noniŋ kâsâpzâŋgom râma bongen zâmbam noniŋ yaŋgâgen zâmbanbat. ");
INSERT INTO kpf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yatâ op a kutâziŋâ, nâ bongen zo itâ sâm dâzâŋgobat, ‘Zen Ibânandâ mâsop minziŋgip. Zen gam Kembugât um topŋan bagim ândibi. Zo mârumŋan hân muyageibân gâbâ zeŋgât siŋgi sâip. ");
INSERT INTO kpf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Zen itâ otniwe, zorat. Tepnaŋgât ua nalem niwe. Toogât mua too niwe. Nâ lomba yatâ ândiandâ zen galem otniwe. ");
INSERT INTO kpf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nâ sâk bârak ândia zen hâmbâ mot mem niwe. Nâ mâsek zia zen galem otniwe. Nâ tâk namin ta zen ga nigâwe.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yatâ sa a târârak ziŋâ den itâ mâburem dâtnobi, ‘Kembu, gâ wan narâkŋan nalemgât otgigi nalem ŋâi giwen? Wan narâkŋan toogât otgigi nen too giwen? ");
INSERT INTO kpf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Gâ wan narâkŋan lombâ yatâ ândina nen galem otgiwen? Gâ wan narâkŋan hâmbâgât kwakna hâmbâ ŋâi giwen? ");
INSERT INTO kpf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Gâ wan narâkŋan mâsek mo tâk namin tâtna ga gigâwen?’ ");
INSERT INTO kpf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yatâ sânetâ a kutâziŋâ, nâ itâ sâm dâzâŋgobat, ‘Kâmurâpnâ zeŋgâren gâbâ a gigiŋâ ŋâi galem okŋaŋgâwe, zo nâ otniwe uap.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Yatâ sâm a yaŋgâgen, zo itâ sâm dâzâŋgobat, ‘Sâit miaŋgâwe, zen kârâp kâtikŋan gei ândibi. Kârâp zo Satâŋ sot sumbem arâpŋâ zeŋgât siŋgi oip. Zoren gei ândibi. ");
INSERT INTO kpf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Zen itâ otniwe, zorat. Nâ tepnaŋgât ua nalem mân niwe. Nâ toogât nâŋga too mân niwe. ");
INSERT INTO kpf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nâ lomba ândia mân galem otniwe. Hâmbâgât kâruandâ mân niwe. Mâsegân sot tâk namin ta mân ga nigâwe.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yatâ sâm dâzâŋgua ko yaŋgâgen ziŋ itâ sâbi, ‘Kembu, gâ wan narâkŋan nalem too buŋâ sot hâmbâ mirâ kamân buŋâ ândina gek mân nâŋgânâŋgâ urâwen? Mo ikâ zoren mâsek mo tâk namin tâtna gekŋâ mân galem otgiwen?’ ");
INSERT INTO kpf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yatâ sâne itâ dâzâŋgobat, ‘Nâ perâkŋak dâzâŋgobâ. Arâpnâ zeŋgâren gâbâ gigiŋâ ŋâi ek mân galem okŋaŋgâwe, zo nâ otniwe uap.’ ");
INSERT INTO kpf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Oi a yaŋgâgen zen âi sâknam tâmbâŋâ nâŋgâm ândibi. A ambân târârakŋâ, zen ko ândiândi kâtikŋan bagim ândibi.” ");
INSERT INTO kpf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu zâk den so aksik sâm naŋgâm arâpŋâ itâ sâm dâtnâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nâŋge. Sirâm zagât tap Pasowa kendon upap. Oi narâk zoren a bonŋâ, nâ kâsa zeŋgât bitziŋan zaria poru nagân none mumbat.” Yesuŋâ den yatâ sâip ");
INSERT INTO kpf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Narâk zoren tirik namâ galem a patâ sot a sâtŋâ, zen tirik namâ galem a patâ Kaipa, zâkkât namin zâim minduwe. ");
INSERT INTO kpf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Zen Yesu tik gâsum kunam den sâm kâtâŋ urâwe. ");
INSERT INTO kpf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Oi itâ sâwe, “Kendonân kâmbam laŋ âsagebapkât kegâk gâsunat.” ");
INSERT INTO kpf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu zâk Betania kamânân âim Simoŋ, sâk bâlâ a, zâkkât mirin zâim nalem neip. ");
INSERT INTO kpf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nalem nem tâi ambân ŋâiŋâ too wârân âlip beloŋoot, sâŋgân patâ, zo mem gam too wârânŋoot zo kâukŋan lokei giari saŋgorip. ");
INSERT INTO kpf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yatâ oi arâpŋâ nen ekŋâ sâwen, “Too sâŋgân zâizâiŋ zi wangât tâmbetkuap? ");
INSERT INTO kpf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Too zo pam kât patâ mem a kanpitâ ziŋgip sâi ko dâp opap.” ");
INSERT INTO kpf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yatâ sâindâ Yesuŋâ nâŋgâmŋâ itâ sâm dâtnâŋgoip, “Zen wangât ambân den okŋaŋge? Zâkŋâ otnigi âlip uap. ");
INSERT INTO kpf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A ambân kanpitâ, zen narâk dâp zen sot ândibi. Nâ ko zen sot narâk kârep mân ândibat. ");
INSERT INTO kpf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nâ mua hanobi, zorat dâp sâknâ saŋgori âlip uap. ");
INSERT INTO kpf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nâ perâkŋak dâzâŋgobâ. Kembugât den siŋgi âlip zi hânŋâ hânŋâ sâm âim ambân zirâŋâ uap, zorat siŋgi ârândâŋ sâne laŋ kârâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Oi arâpŋâ kiin zagât neŋgâren gâbâ a ŋâi kutŋâ Yuda, Karioto kamânân gokŋâ, zâkŋâ tirik namâ galem a patâ, zeŋgâren arip. ");
INSERT INTO kpf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Âimŋâ itâ sâm dâzâŋgoip, “Nâ tirâpzâŋgobat, zorat kât dabutâ nibi?” Mâsikâziŋgi ziŋâ kât ekap 30 yatâ sâlâpkum pindâwe. ");
INSERT INTO kpf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yudaŋâ zo memŋâ Yesu tirâpzâŋgoi gâsubigât ek kârum ek molim ândeip. ");
INSERT INTO kpf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pasowa kendon narâk topkwâtnam arâpŋâ nen Yesu mâsikâm sâwen, “Nen itârâŋ mirâ ikâ zoren Pasowa nalem unat?” ");
INSERT INTO kpf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Sâindâ itâ sâip, “Zen kamânân âimŋâ a ŋâi muyagem itâ sâm dukunek, ‘Patâniŋâ gâgât sap, “Narâkŋâ mâte uap, zorat nâ sot arâpnâ, nen gâgât mirin gam Pasowa nalem ninat.” ’” ");
INSERT INTO kpf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Oi arâpŋâ nen Yesuŋâ den sâip, zo lumŋâ Pasowa kendongât nalem uwen. ");
INSERT INTO kpf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mirâ ŋâtiksâi Yesu sot arâpŋâ kiin zagât, nen mirâ zoren zâimŋâ Pasowa nalem niwen. ");
INSERT INTO kpf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nem tapŋâ Yesuŋâ itâ sâm dâtnâŋgoip, “Zeŋgâren gâbâ ŋâiŋâ nâ kâsa a tirâpzâŋgoi gâsânobi.” ");
INSERT INTO kpf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yatâ sâi arâpŋâ nen umniŋ bâlei ŋâigoot zikŋik zikŋik mâsikâyaŋgâm sâwen, “Kembu, nâgât sat?” ");
INSERT INTO kpf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sâindâ zâkŋâ sâip, “A zo nâ sot ârândâŋ niet, zâkŋâ yatâ otnibap. ");
INSERT INTO kpf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A bonŋâ, nâ Kembugât ekabân den kulem ziap, zo yatik upat. Ka a bonŋâ, nâ tirâpzâŋgoi gâsunibi, yei, zâk hâuŋâ yâmbâtŋâ mimbap. A zo mam kâmboŋ kâligen gâbâ mân âsageip sâi bâbâlaŋ opap.” ");
INSERT INTO kpf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yatâ sâi Yudaŋâ mâsikâm sâip, “Patâ, nâgât sat?” Sâi dukuip, “Gâ sat, zo.” ");
INSERT INTO kpf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nalem nem tâindâ Yesuŋâ nalem ŋâi mem sâiwap sâm namuŋ arâp itâ sâm niŋgip, “Mem ninek. Zi sunumnâ.” ");
INSERT INTO kpf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yatâ sâmŋâ waiŋ hâkop mem sâiwap sâmŋâ itâ sâm niŋgip, “Zen aksik ninek. ");
INSERT INTO kpf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Zi târotâroniŋaŋgât gilâmnâ. Zo a ambân doŋbep patâ, zeŋgât tosaziŋ buŋ upapkât hânân gibap. ");
INSERT INTO kpf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Oi dâzâŋgua nâŋgânek. Waiŋ too itârâŋ nia âkap. Oi dum zagâtŋan mân nemŋâ Ibânaŋgât um topŋan zâim zen sot ârândâŋ waiŋ mârâtŋâ ŋâi ninat.” ");
INSERT INTO kpf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Oi Kembugât mâpâmâpâse kep ŋâi mem kamânân gâbâ âimŋâ Oliwa bâkŋan zâiwen. ");
INSERT INTO kpf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mâtâbân âimŋâ Yesuŋâ itâ sâm dâtnâŋgoip, “Ŋâtik ziren a ziŋ gâsuninetâ zen nâŋgâm pâlâtâŋziŋ lolot, zorat op âksik birânim âibi. Kembugât den kulem ŋâi ziap, zo bon upap. Den zo itâ, ‘Nâ râma galem a kua râma zen siŋsururuŋ op âim naŋgâbi.’ ");
INSERT INTO kpf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nâ sa nâŋgânek. Nâ mumuŋan gâbâ zaatŋâ Gâlilaia âi kândom otziŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Sâi Peteroŋâ itâ sâm dukuip, “A nâmbutŋâ, ziŋ birâgibi. Nâ ko mân birâgibat. Buŋ kâtikŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yatâ sâi Yesuŋâ itâ sâm dukuip, “Nâ perâkŋak dâgobâ. Gâ ŋâtik ziren kwâimbâninandâ sâp karâmbut oi kurukŋâ diŋ sâbap.” ");
INSERT INTO kpf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Yatâ sâi Peteroŋâ itâ sâip, “Gâ gomŋâ nâ nonâ sâne mân kwâimbâgibat.” Sâi arâpŋâ nâmbutŋâ, nen den yatik sâwen. ");
INSERT INTO kpf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nen âimŋâ nak kalâm ŋâi kutŋâ Gezemane, zoren takâm Yesuŋâ arâpŋâ itâ sâm dâtnâŋgoip, “Zen ziren tatne nâ ândi âi ninâu sâbâ.” ");
INSERT INTO kpf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yatâ sâmŋâ Petero sot Zebedaiogât nanzatŋâ diiziŋgi âiwe. Âimŋâ Yesuŋâ umŋâ yâmbârei ken bet kakit oip. ");
INSERT INTO kpf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yatâ op dâzâŋgom sâip, “Umnâ yâmbârei mumuŋâ otnigap. Zen nâ sot tap um wâgân ândinek.” ");
INSERT INTO kpf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yatâ sâmŋâ mâik ŋâi âim si sâŋgân hânân ge tutukum itâ sâm ninâu sâip, “Ibânâ, nâŋgânim sâknam kâmut zi betnan mena buŋ oik. Oi nâgât den buŋâ, gâgât den, zo kâtigibap.” ");
INSERT INTO kpf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yatâ ninâu sâmŋâ puriksâm arâp karâmbut ziŋgiri uman zem tatne Petero itâ sâm dukuip, “Zen nâ sot gwâlâ mâik ŋâi ândibigât dâp buŋâ? ");
INSERT INTO kpf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Zen mâsimâsikâyân loribegât um gwâlâ ândim ninâu sânek. Umŋâ bâbâlaŋ opmap. Sâkŋâ ko yâmbâremap.” ");
INSERT INTO kpf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Dum âimŋâ den itâ sâm ninâu sâip, “Ibânâ, sâknam zi betnan mimbangât nâŋgâna mân dâp oi laŋ gâgât den, zo kâtigibap.” ");
INSERT INTO kpf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yatâ ninâu sâmŋâ âburem arâp karâmbut, zen sinziŋâ uman oi zinetâ ga muyageziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Zâmbamŋâ âi ninâu sâi sâp karâmbut oip. Den mârum sâip zo yatik ninâu sâip. ");
INSERT INTO kpf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ninâu sâm naŋgâm arâp zeŋgâren puriksâm itâ sâm dâzâŋgoip, “Zen uman tok zem te? Zi mârum narâk uap. A bonŋâ, nâ bâliŋ mâme a zeŋgât bitziŋan zâibâman. ");
INSERT INTO kpf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Zaatne âinâ. Iknek. A sâi gâsunim nobi, zo mâte otniŋgap.” ");
INSERT INTO kpf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Den yatâ sâm kiri arâp kiin zagât, neŋgâren gâbâ a ŋâi, kutŋâ Yuda, zâkŋâ a kâmut kândom otziŋgi gawe. A kâmut zo tirik namâ galem a patâ sot a sâtŋâ, ziŋâ sâŋgonzâŋgone kâmbam sot sâu patâziŋâ mem gawe. ");
INSERT INTO kpf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Oi Yudaŋâ den kânŋan itâ sâm dâzâŋgoip, “Nâ lum mâŋgansa zi sâm gâsubi.” ");
INSERT INTO kpf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Oi gamŋâ zorenâk Yesugâren âim O patânâ sâm lum mâŋgarip. ");
INSERT INTO kpf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yatâ oi Yesuŋâ den ŋâi itâ sâm dukuip, “Buku, nep tuubam gaat, zo tuum naŋgânan.” Yatâ sâi a kâmut, zen Yesugâren ga gâsum saawe. ");
INSERT INTO kpf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Oi Yesu sot ândiwen, neŋgâren gâbâ ŋâiŋâ sâuŋâ sâmbum tirik namâ galem a patâgât kore a ŋâi kindapŋâ kârâm kwâkip. ");
INSERT INTO kpf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yatâ oi Yesuŋâ itâ sâm dukuip, “Sâugâ mirâŋan hanguna giarik. Ŋâi zâk sâuŋâ zâŋgoi hâuŋâ kumbi. ");
INSERT INTO kpf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nâgât dap nâŋgat? Nâ Ibânaŋgâren ninâu sa sâi ko sumbem kâwali a kâmut kiin zagât, zo kegâk sâi gem galem otnibe. ");
INSERT INTO kpf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Oi zen gem ga galem otnine Kembugât ekabân den ziap, zo dabân bon opap?” ");
INSERT INTO kpf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yatâ sâmŋâ a kâmut gâsunam gawe, zo itâ sâm mâsikâziŋgip, “Nâgât dap nâŋge? Zen nâgât nâŋgâne kâmbam ku oi kâmbam sot sâuziŋâ mem ga gâsânoge? Zorat sa nâŋgânek. Nâ sirâmŋâ sirâmŋâ tirik namin zen Kembugât den siŋgi dâzâŋgoman. Oi zen zoren mân gâsânowe. ");
INSERT INTO kpf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Oi zi Propete zeŋgât den kâtigibapkât âsagiap.” Oi Yesugât arâpŋâ, nen aksik Yesu birâŋaŋgâm siŋsururuŋ âiwen. ");
INSERT INTO kpf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kâwali a zen Yesu gâsum tirik namâ galem a patâ Kaipa, zâkkâren diim âiwe. Zâkkât namin Kembugât gurumin den zorat galem a sot a sâtŋâ mindum tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Zen Yesu diim âinetâ Petero zâk kândâtziŋan bet moliziŋgâm arip, Âi takâmŋâ tirik namâ galem a patâgât dâmân kâligen bagimŋâ kore a zeŋgât oserân itâ nâŋgâm kwâkâm getâip, “Yesugât den dap sâbi? Zorat ziren tap nâŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Oi tirik namâ galem a patâ sot a sâtŋâ, zen aksik tapŋâ Yesugât den sâkŋanâk sâm kunatkât den sâm kâruwe. ");
INSERT INTO kpf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Oi a doŋbep den sarâ doŋbep sâm bonŋâ mân muyagiwe. Oi bet a zâgât gawet. ");
INSERT INTO kpf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Zet gamŋâ itâ sâwet, “A zirâŋâ itâ sâip, ‘Nâ Kembugât tirik namâ kândaŋâ sirâm karâmbut umŋanâk dum tuubat.’” ");
INSERT INTO kpf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yatâ sâitâ tirik namâ galem a patâ, zâk zaatŋâ Yesu itâ sâm mâsikip, “Gâgât den se, zorat den hâuŋâ sâban mo mân sâban?” ");
INSERT INTO kpf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sâi Yesuŋâ den mân sâm kirip. Yatâ kiri tirik namâ galem a patâ, zâkŋâ itâ sâm dukuip, “Anutu, ândiândi mariŋâ, zâkkât mâteŋan mâsikâgiga sâm kâtigenan. Gâ Kristo, Anutugât nanŋâ mo a ŋâi?” ");
INSERT INTO kpf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yatâ sâi Yesuŋâ itâ sâm dukuip, “Zo sat, zo. Oi ŋâi dâzâŋgua nâŋgânek. Gâtâm a bonŋâ, nâ imbaŋâ mariŋâ, zâkkât âsanŋâ bongen tap sumbem unumunum kwâkŋan gem ga nikpi.” ");
INSERT INTO kpf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yatâ sâi tirik namâ galem a patâ den zo nâŋgi bâliŋ oi hâmbâŋâ mem moloŋ arâpŋâ itâ sâm dâzâŋgoip, “Zâk Anutu yatâ op sap. Wangât den zagât sâm kârunat. Den sap, zo aksik nâŋge. ");
INSERT INTO kpf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Den zo nâŋgâm dap dap nâŋge?” Mâsikâziŋgi ziŋâ itâ sâwe, “Zâk mumuŋaŋgât siŋgi uap.” ");
INSERT INTO kpf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yatâ sâmŋâ tâpziŋandâ Yesu si sâŋgânŋan tâpkumŋâ bitziŋandâ kom kâbakŋiwe. Oi a nâmbutŋandâ bitziŋ tipŋandâ pâlomŋan kunzirâwe. ");
INSERT INTO kpf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Oi itâ sâm dukuwe, “Kristo, gâ Propete ândiat oi ko sânan. A gogap, zo kutŋâ ŋâi?” ");
INSERT INTO kpf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yatâ op tatne Petero zâk namâ sombemân tâip. Tâi kore ambân ŋâiŋâ zâkkâren âim sâip, “Gâ ko Galilaia a, zâk sot ândimat.” ");
INSERT INTO kpf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yatâ sâi Peteroŋâ a tarâwe, zeŋgât mâteziŋan kwâimbâm sâip, “Gâ den sat, zo nâ nâŋgâm kwaksan.” ");
INSERT INTO kpf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Yatâ sâmŋâ geibâ sâi kore ambân ŋâiŋâ ekŋâ a itâ sâm dâzâŋgoip, “A zi Yesu Nasarete gokŋâ, zâk sot ândimap.” ");
INSERT INTO kpf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yatâ sâi Peteroŋâ kwâimbâm den sâm kâtigeip. Oi sâip, “Nâ a zo mân ekman.” ");
INSERT INTO kpf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yatâ sâm mâik ŋâi kinŋâ a ziŋâ Peterogâren âim sâwe, “Gâ perâkŋak zeŋgât kâmurân gokŋâ. Nen diŋgâ holiŋâ nâŋgen.” ");
INSERT INTO kpf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sânetâ dum Anutu mâteŋan sâm kâtigem den laŋ sâm itâ sâm dâzâŋgoip, “Nâ a zo mânâk ekman.” Sâi zorenâk kurukŋâ diŋ sâip. ");
INSERT INTO kpf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Oi Yesuŋâ den mârum sâip, zo Peteroŋâ nâŋgip, “Gâ sâp karâmbut kwâimbânina kurukŋâ diŋ sâbap.” Den zo nâŋgâm umbâlâ op âkŋan âim girâp patâ iseip. ");
INSERT INTO kpf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Haŋsâi tirik namâ galem a patâ sot a sâtŋâ, zen mindum Yesu koindâ mumbapkât den sâwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Oi sâne Yesu bikŋâ saamŋâ diim âim Roma a kutâ Pilato, zâkkâren parâwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mumbapkât sâm kâtigine Yuda, zâk zo ekŋâ wangât yatâ uan sâm umŋâ bâlei kât pindâwe, zo mem âim tirik namâ galem a patâ sot a sâtŋâ mâburem ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Oi itâ sâm dâzâŋgoip, “Nâ laŋ opŋâ a târârakŋâ zi bitziŋan paan.” Yatâ sâi ziŋâ sâwe, “Wangât neŋgâren ga sat? Zo gikak.” ");
INSERT INTO kpf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yatâ sâm kât zo birânetâ mem tirik namin lum pam âi sip miaŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tirik namâ galem a patâ, zen kât zo memŋâ sâwe, “Kât zi kâmbamgât sâŋgân, zorat tirik namin pâindâ mân dâp upap.” ");
INSERT INTO kpf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Oi kât zo mem dap utnat sâm âragum hân ŋâi kwâlâwe. Hân zo âmaŋ tuutuuŋ agât hân sâmarâwe. Hân zo kamân ŋâin gâbâ ga ândiândiŋ, zo mune zoren hanzâŋgobigât sâŋgân miwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Oi narâk zoren hân zorat kutŋâ ŋâi kâmbam hân sâne kâtigeip. ");
INSERT INTO kpf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Oi Propete Yeremia zâkkât den kânŋan sâip, zo bon oip. Den zo itâ, “Isirae a zen a sâŋgânŋaŋgât kât sâwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","A sâŋgânŋaŋgât kât ekap 30, zorâŋ âmaŋ tuutuuŋ agât hân, zo sâŋgân miwe. Kembuŋâ dâtnogip, yatik urâwe.” ");
INSERT INTO kpf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Zen Yesu diim âine a kutâ Pilato, zâkkât mâteŋan kiri itâ sâm mâsikip, “Topkaŋgât dâtno. Gâ Yuda zeŋgât a kutâ?” Sâi Yesuŋâ sâip, “Sat, zo.” ");
INSERT INTO kpf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Oi tirik namâ galem a patâ sot a sâtŋâ, ziŋâ den sâkŋanâk sâm kine den hâuŋâ mân sâip. ");
INSERT INTO kpf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yatâ oi Pilatoŋâ dukum sâip, “Gâgât den doŋbep sânetâ wangât den hâuŋâ mân sat?” ");
INSERT INTO kpf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Oi Yesuŋâ den hâuŋâ ŋâi mân dukui a kutâŋâ nâŋgi imbâŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pasowa kendon narâk dâp a kutâ zâk Yuda a tâk namin tâpmarâwe, zeŋgâren gâbâ ŋâi olaŋ ziŋgâmâip. ");
INSERT INTO kpf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Oi narâk zoren kâmbam ku a bâliŋâ ŋâi tâk namin zeip, kutŋâ Baraba. ");
INSERT INTO kpf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Oi a mindumŋâ kinetâ Pilatoŋâ mâsikâziŋgâm sâip, “Ŋâi olaŋbatkât nâŋge? Baraba mo Yesu kutŋâ ŋâi Kristo sâme?” ");
INSERT INTO kpf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yuda a sâtŋâ, zen Yesugât um kâlak nâŋgâŋaŋgâm zâkkâren parâwe, zorat nâŋgâmŋâ sâip. ");
INSERT INTO kpf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","A kutâ, zâk den sâm kubikkubik tâtarân tâi ambinŋandâ zâkkâren den itâ pâi gâip, “Gâ a târârak zo, zâkkât den mân mâsâsuatpan. Nâ itârâŋ umanân nâŋgâm zâkkât op sâknam doŋbep nâŋgan.” ");
INSERT INTO kpf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Oi tirik namâ galem a patâ sot a sâtŋâ, zen a umziŋan gem sâwe, “Zen sâne Baraba olaŋŋâ ko Yesu ko koi mumbap.” ");
INSERT INTO kpf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Oi a kutâ zorâŋ dum mâsikâziŋgâm sâip, “Ŋâi mo ŋâi olaŋbatkât se?” Sâi ziŋâ sâwe, “Baraba.” ");
INSERT INTO kpf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sânetâ itâ sâm mâsikâziŋgip, “Yesu, kutŋâ ŋâi Kristo sâme, zâk dap okŋaŋgâbat?” Sâi zen lâu mâtâkâm aksik sâwe, “Zâk poru nagân moik.” ");
INSERT INTO kpf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Sâne a kutâŋâ dum mâsikâm sâip, “Wan tosagât?” Yatâ sâi den kâtik sâm sâwe, “Zâk poru nagân moik.” ");
INSERT INTO kpf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yatâ utnetâ Pilatoŋâ sâi den mânâk nâŋgâm den doŋbep sâne sâi too pindânetâ mâteziŋan bikŋâ too saŋgonŋâ sâip, “A târârak zirat tosa nâgâren zimbap, zo zeŋgât siŋgi uap.” ");
INSERT INTO kpf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sâi a ambân kâmut, zen itâ sâwe, “Tosa zo nen sot kiurâpniŋ neŋgâren zimbap.” ");
INSERT INTO kpf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yatâ sâne a kutâŋâ Baraba olaŋ ziŋgip. Yesu ko sâi inzut kuupŋoot, zorâŋ lapitne poruyân kumbigât kâwali a bitziŋan pâip. ");
INSERT INTO kpf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Oi a kutâgât kâwali a, zen Yesu namin gâbâ diim gem kâwali a zeŋgât namâ sombemân âim sânetâ kâwali a ziŋâ aksik minduwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mindumŋâ Yesugât hâmbâ mâkâm kâwali a zeŋgât hâmbâ kuriŋâ giŋaŋgâne giarip. ");
INSERT INTO kpf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Oi tâk sâtmam goŋkom kâukŋan pane giarip. Oi bikŋan tân ŋâi pindâne bikŋâ bongen mem kirip. Yatâ opŋâ kâwali a zen zâkkâren gam simin liim itâ sâwe, “Oe, Yuda zeŋgât a kutâ.” ");
INSERT INTO kpf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Oi tâpziŋâ tâpkum tân bekŋan mem kâukŋan kuwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yatâ kom eksâmŋâ kâwali a zeŋgât hâmbâ, zo mâkâm zikŋâ hâmbâ du giŋaŋgâne giari poru nagân kunam diim âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Diim âim mâtâbân a ŋâi muyagiwe, kutŋâ Simoŋ, Kirene kamânân gokŋâ. Zâk okŋaŋgâne Yesugât poru nak bekŋan mem lugi âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Âimŋâ hân ŋâi kutŋâ Goligata (niiŋ denân ko kâuk siŋit), zoren takâwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Zoren takâmŋâ waiŋ too sot um gulip too mâpot pindânâ sâne nem ekŋâ birip. ");
INSERT INTO kpf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yatâ oi poru nagân kuwe. Kune kiri hâmbâŋaŋgât wenzu pam igâwe. Ikne muyageip dâp miwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yatâ opŋâ galem tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Oi kâukŋâ kwâkŋan poru nagân topŋâ itâ kulemgune zeip, “Zi Yesu, Yuda zeŋgât a kutâ.” ");
INSERT INTO kpf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Oi kâmbam ku a zâgât poru nagân zâkom, ŋâi toren, ŋâi toren kwânâŋgâzikâwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Oi a ambân zoren âim gawe, zen sâm siŋan gem den top topŋâ dukum kâuk birâm sâwe, ");
INSERT INTO kpf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Bâi, gâ tirik namâ kândaŋ sirâm karâmbut tuum naŋgâbat sâin. Bâi, gikâ sâkkâ sâna poru nagân gâbâ âkâm geik. Oi gâ Anutu nanŋâ ândiat oi poru nagân gâbâ pâtan ge.” ");
INSERT INTO kpf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Oi tirik namâ galem a patâ sot Kembugât gurumin den zorat galem a sot a sâtŋâ, zen yatik dukum sâwe, ");
INSERT INTO kpf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“A nâmbutŋâ tâmbetagonam utnetâ tânzâŋgomap. Zikŋaŋgât ko kwaksap. Zâk Isirae a neŋgât a kutâ ândiap oi ko poru nagân gâbâ âkâm gâi zâkkât diŋâ nâŋgânat. ");
INSERT INTO kpf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Zâk nâ Anutugât nanŋâ sâm, nâŋgâm pâlâtâŋâ Anutugâren pâi zeip, zorat Anutuŋâ zâkkât nâŋgap oi ko poru nagân gâbâ kwâki geik.” ");
INSERT INTO kpf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Oi kâmbam ku a zâkowe, zet yatik den mot dukuwet. ");
INSERT INTO kpf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yatâ okŋaŋgâne mirâ bâkŋan zoren ŋâtâtik muyagem zei mirâ oi âkip. ");
INSERT INTO kpf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mirâ oi Yesuŋâ den kâtikŋâ den sâm sâip, “Eli, Eli lama sabatini (niiŋ denân ko, Anutunâ, Anutunâ, wangât birânigat)?” ");
INSERT INTO kpf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Oi kirâwe, zeŋgâren gâbâ a nâmbutŋâ ziŋâ sâwe, “Zâk Elia konsap.” ");
INSERT INTO kpf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","A ŋâiŋâ nâŋgâm sârârâk kârâm âim sarugât kâmon mem ga winiga too kâlakŋoot sum kapiŋkum pindip. ");
INSERT INTO kpf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Oi a nâmbutŋâ itâ sâm dukuwe, “Nen tap iknâ. Elia perâkŋak ga mâkâbap mo buŋâ?” ");
INSERT INTO kpf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Oi Yesu zâk dum den kâtikŋâ den sâi Kaapumŋâ takâm arip. ");
INSERT INTO kpf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Moi tirik namin sâŋgum patâ, zo uren gâbâ oloŋ gei kwâkip. Oi wâriŋ mei kât âbâŋgum naŋgip. ");
INSERT INTO kpf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Oi a zeŋgât kwak, zo pâroŋsâi Kembugât siŋgi a ândim muwe, zo zeŋgâren gâbâ nâmbutŋandâ zaarawe. ");
INSERT INTO kpf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Oi Yesu zâk kândom op zaari zen kwagân gâbâ zaatŋâ kamân kâukŋan zo âim a doŋbep muyageziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Oi kâwali a galem sot arâpŋâ kirâwe, zen wâriŋ sot kut ŋâi ŋâi zo ekŋâ imbaŋâziŋ buŋ oi sâwe, “Perâkŋak a zirâŋ Anutugât nanŋâ ândeip.” ");
INSERT INTO kpf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yesu kuwe, narâk zoren ambân doŋbep kârebân kin kut ŋâi ŋâi zo ek naŋgâwe. Ambân zo, zen Yesu molim kore okŋaŋgâm Galilaia hânân gâbâ gawe. ");
INSERT INTO kpf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maria, Madala kamânân gokŋâ sot Maria, Yakobo sot Yose zekât mamzikŋâ. Oi ambân ŋâi Zebedaio nanzatŋâ, zekât mamzikŋâ. Zen ârândâŋ tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mirâ ŋâtiksâisâi Arimataia kâmânân gokŋâ sikum a ŋâi Yesugât a op ândeip, kutŋâ Yosepe, zâk gâip. ");
INSERT INTO kpf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Gamŋâ Pilatogâren âim Yesugât kâmbarâŋâ zorat dukum sâi Pilatoŋâ kâwali a sâm dâzâŋgoi pindâwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosepeŋâ kâmbarâŋâ zo memŋâ sâŋgum kâu uŋakŋandâ kâpim lum arip. ");
INSERT INTO kpf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Lum âim kât mâtâpŋâ zik siŋgi ŋâi tuugip, zoren pamŋâ kât patâ ŋâi kâbakŋei âi mâtâp dooŋgoi arip. ");
INSERT INTO kpf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Oi kwak naŋgâmŋan Maria, Madala kamânân gok sot Maria ŋâi, zet zo tap igâwet. ");
INSERT INTO kpf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kendongât kut ŋâi ŋâi kubikkubik narâk, zo âki ko haŋsâi tirik namâ galem a patâ sot Parisaio a, zen Pilatogâren âiwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Âimŋâ sâwe, “Patâniŋâ, nen den ŋâi nâŋgen, zo dâgonâ. Sarâ a zâk wâgân ândeibân itâ sâip, ‘Momŋâ sirâm karâmbut zem tap zaatpat.’ ");
INSERT INTO kpf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Zorat arâpŋâ ziŋâ âi kâmbarâŋâ mem âimŋâ mumuŋan gâbâ zaatsap sarâ sâbegât kâwali a sâŋgonzâŋgona kwagân âi galem kinetâ sirâm karâmbut âkâbap. Mârum den sarâ zeip, zorat den sarâ kwâkŋan zari lâmbatpapkât girem op dâgogen.” ");
INSERT INTO kpf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Sâne Pilatoŋâ itâ sâm dâzâŋgoip, “Kâwali a ziŋgan. Diiziŋgâm kwagân âim ziiŋak dap mo dap nâŋge, zo yatâ dooŋgune tâpap. Yatâ sâi kâwali a zen sot âimŋâ kwagân zo winzip pam galem tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","(-) ");
INSERT INTO kpf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yuda zeŋgât kendon âki haŋsâsâgât Maria, Madala kamânân gokŋâ sot Maria bukuŋâ, zet kwagân iktam âiwet. ");
INSERT INTO kpf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aritâ wâriŋ patâ mei Kembugât sumbem a ŋâiŋâ sumbemân gâbâ gem kât patâ mem kâbakŋei ari kât kwâkŋan tâip. ");
INSERT INTO kpf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tobatŋâ âsakŋoot hânpân yatâ. Hâmbâŋâ kâu timan. ");
INSERT INTO kpf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kâwali a, zen zo ekŋâ sânâmziŋ sâmbui keŋgât op hânân gei zem ândiwe. ");
INSERT INTO kpf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Oi ambân zagât zo, zet âi takitâ aŋâ itâ dâzâkom sâip, “Zet keŋgât mân oit. Nâ nâŋgan. Zet poru nagân kuwe, zo iktam gabot. ");
INSERT INTO kpf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Oi zâk zi mân taap. Zâk mârum sâm dâzâŋgoip, zo yatâ op mumuŋan gâbâ zaatsap. ");
INSERT INTO kpf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Zet kek âi arâpŋâ dâzâŋgobabot, ‘Yesu zâk mumuŋan gâbâ zaatsap. Galilaia hânân âi kândom otziŋgâbap. Zen zoren âi ikpi.’” ");
INSERT INTO kpf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Sâi zet kek kwak zo birâm keŋgât sot sâtâre op arâp den siŋgi dâzâŋgoram sârârâk kârâm âiwet. ");
INSERT INTO kpf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aritâ Yesuŋâ mâtâbân muyagezikâm itâ sâm dâzâkoip, “Umzik âlip oit.” Yatâ sâi zet um topŋan âi pindiŋsâm mâpâsem kiŋan gâsuwet. ");
INSERT INTO kpf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Oi Yesuŋâ itâ sâm dâzâkoip, “Zen mân keŋgât oit. Zet âi arâpnâ dâzâŋgoitâ Galilaia hânân âi nikpi.” ");
INSERT INTO kpf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ambân zagât, zet aritâ kwagân galem kirâwe, zeŋgâren gâbâ nâmbutŋâ zen âim kamân patin takâmŋâ tirik namâ galem patâ kut ŋâi âsageip, zorat siŋgi dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Oi tirik namâ galem a patâ sot a sâtŋâ, zen mindum kâwali a zen kât doŋbep ziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ziŋgâm itâ sâwe, “Zen itâ sâbi. Nen ŋâtigân uman zeindâ arâpŋâ ziŋ gam kâmbarâŋâ mie. ");
INSERT INTO kpf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Den zo Roma a kutâŋâ nâŋgâbapkât keŋgât mân upi. Âlip niŋâ dukunat.” ");
INSERT INTO kpf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yatâ sâm dâzâŋgone kâwali a zen den lum kât zo mem âiwe. Den sarâ zo Yuda a zeŋgâren zeipŋak tok ziap. ");
INSERT INTO kpf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesugât arâp kiin kânok, nen Galilaia hânân bakŋâ ŋâin Yesuŋâ den kânŋan dâtnâŋgoipkât zoren zâiwen. ");
INSERT INTO kpf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Zâimŋâ zikŋâ ekŋâ pindiŋsâm mâpâsiwen. Nâmbutŋandâ ko um zagât urâwe. ");
INSERT INTO kpf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Oi Yesuŋâ gootniŋan gam itâ sâm dâtnâŋgoip, “Anutuŋâ imbaŋâ top top aksik sumbemgât sot hângât nâ nigip. ");
INSERT INTO kpf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Zorat ko zen hânŋâ hânŋâ, a kâmutŋâ kâmutŋâ, zeŋgâren âim nep tuune dinnâ lum nâgât a ambân upi. Oi Ibâ sot nanŋâ, nâ sot Tirik Kaapum, neŋgât korân târokwap too saŋgon ziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Den dâzaŋgom ândiwan, zo aksik lubigât dâzâŋgom ândibi. Oi ŋâi dâzâŋgua nâŋgânek. Nâ sirâmŋâ sirâmŋâ, âsâbâŋ zen sot ândia hângât narâkŋâ âkâbap.” Zo yatik. ");
INSERT INTO kpf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Kristo, zâk Anutugât nanŋâ, zâkkât den siŋgi âlipŋâ, zo topkwapŋâ. ");
INSERT INTO kpf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","A sâŋgiŋâ Propete Yesaiaŋâ mârum ŋâi Anutugâren gâbâ den itâ nâŋgâm kulemguip, “Nâŋgâ. Nâgât kore a ŋâi sâŋgongua gâ kândom otgibap. Zâkŋâ mâtâpkâ kârâm kubikpap. ");
INSERT INTO kpf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Barâ kâtik, mirâ âtâŋan ândim den itâ sâbap, ‘Kembugât mâtâp kârâm pitâne gânduŋ oik.’” ");
INSERT INTO kpf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Den zorat bonŋâ ko Yohaneŋâ âsagem barâ kâtik mirâ kamân âtâŋan ândim den itâ sâm dâzâŋgomâip, “Umziŋâ melâŋne too saŋgonziŋga Anutuŋâ tosaziŋ birâbap.” ");
INSERT INTO kpf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yatâ sâm dâzâŋgoi ko Yerusalem kamân mâirâp sot Yudaia hânân a ambân ândiwe, zen gâbâreyaŋgâm zâkkâren âiwe. Zen bâliŋâziŋâ sapsune Yohaneŋâ Yodaŋ toin saŋgonziŋgâmâip. ");
INSERT INTO kpf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohane zâk a kanpitâ ândeipkât sâk pâke âlipŋâ mân mem ândeip sot nalem âlip mân nem ândeip. Yohanegât hâmbâ zo bâu kamele sâmotŋandâ tuune pam ândeip. Ka pâŋan ko inzut ŋâi bâu sâkŋâ tuutuuŋâ, zo lap ândeip. Kumbon sot bâŋsat, zo nem ândeip. Ândim itâ zo sâm dâzâŋgom ândeip, ");
INSERT INTO kpf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","“Betnan a ŋâi gam taap. Zâk kâwaliŋâ ŋâi yatâ zemŋâŋgap. Nâ yatâ zorâŋ irâ sikumŋâ goribat, zorâgoot ko mân dâp upap. ");
INSERT INTO kpf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nâ tooyâk saŋgonziŋgan. Ka zâkŋâ ko Kaapum bonŋâ saŋgonziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Narâk zoren Yesuŋâ Nasarete kamânân gâbâ Galilaia hân birâm Yodaŋ toin Yohanengâren takip. Âi taki ko Yonaneŋâ Yodaŋ toin saŋgonŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu zâk toin gâbâ kopga egi sumbem pâroŋsâi Anutugât Kaapum zâk nii kembâ yatâ opŋâ Yesu kwâkŋan gem pâip. ");
INSERT INTO kpf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Oi sumbemân gâbâ den ŋâi itâ âsagem gâip, “Nannâ, gâ umnandâ gâsugim biraŋmap. Oi gekŋâ umnâ âlip opmap.” ");
INSERT INTO kpf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Op ko narâk zorenâk Kaapumŋâ Yesu okŋaŋgi barâ kâtik, mirâ kamân âtâŋan arip. ");
INSERT INTO kpf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Zoren Sataŋŋâ mâsikâm ândei hilâm 40 âkip. Yesuŋâ zuu osetziân ândeip. Ândei ko Anutugât sumbem a ziŋâ on galemŋâ okŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohane tâk namin pane tâi ko Yesu zâk Galilaia hânân gamŋâ Anutugât den siŋgi âlipŋâ itâ dâzâŋgom ândeip, ");
INSERT INTO kpf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Anutugât um topŋan ândiândigât narâkŋâ mâte uap, gât ko umziŋâ melâŋ Anutugât den siŋgi âlipŋâ zirat nâŋgâne bon upap.” ");
INSERT INTO kpf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesuŋâ Galilaia saru sâtŋan âim tap ko Simoŋ sot munŋâ zikirip. Zet iŋangât nep tuum ândiwet. Zikiri iŋangât irâ pam kirâwet. ");
INSERT INTO kpf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesuŋâ zâkonsâm itâ sâip, “Zet ga nâ târokwatnigit. Nâŋâ den âlip kwâkâm zika ândim ko zet iŋangât nep tuum ândiabot, yatigâk a zeŋgâren tuum ândibabot.” ");
INSERT INTO kpf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yatâ sâi irâzikŋâ birâmŋâ Yesu molim ba âiwet. ");
INSERT INTO kpf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesuŋâ mâik ŋâi âim ko Zebedaio nanzatŋâ Yakobo sot Yohane zikirip. Zet waŋgâyân tapŋâ iŋan mâme irâzikŋâ kubik tarâwet. ");
INSERT INTO kpf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesuŋâ zâkonsâi nâŋgâm ibâzikŋâ sot nep a waŋgâyânâk tatne zâmbamŋâ gem Yesu molim ba âiwet. ");
INSERT INTO kpf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Op ko zen Kapenaum kamânân âiwe. Yuda zeŋgât kendon mâik zorat narâkŋâ oi Yesu zâk mâpâmâpâse namin zâim siŋgi âlipŋâ sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Den dâzâŋgoi Yesugât nâŋgâne imbaŋâ oip. Yesu zâk siŋgi âlip den dâzâŋgoip, zo Anutugât gurumin den zorat galem a ziŋ sâmarâwe, yatâ mân sâip. Zo walâm yatâ dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Narâk zorenâk mâpâmâpâse namin a wâkeŋoot ŋâi tâip. ");
INSERT INTO kpf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Zâkŋâ den yu kambâŋâ sâm itâ sâip, “Yesu Nasarete gokŋâ, gâ dap otniŋgâbam gaat? Gâ tâmbetnâŋgobam gaat? Gâgât topkâ nâŋgen. ");
INSERT INTO kpf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Gâ Anutugât tirik a.” Sâi Yesuŋâ den yatâ mân sâbapkât dukum sâip, “Gâ hiriŋsâm ayân gâbâ takâm ba âi.” ");
INSERT INTO kpf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yatâ sâi wâke zorâŋ a zo okŋaŋgi kâkâksâm zei wâke zo yu kambâŋ sâm ko takâm ba arip. ");
INSERT INTO kpf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A ambân zen zo ekŋâ imbaŋâziŋ buŋ oi âragwâragu opŋâ sâwe, “A zi dap dap yatâ? Topŋâ ŋâi. Den uŋakŋâ sap. ");
INSERT INTO kpf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Zâk a kâwaliŋâ patâ wâke sorâk den dâzâŋgoi sâtŋâ lume.” Yatâ sâm siŋgiŋâ âragunetâ Galilaia hânân a ambân aksik nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu sot Yakobo sot Yohane, zen mâpâmâpâse namin gâbâ gemŋâ Simoŋ sot Andrea, zekât mirin zâiwe. ");
INSERT INTO kpf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simoŋ sibunŋâ, zâk mirin mâsek kârâpŋoot op zeip. ");
INSERT INTO kpf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu zâk mirin zari dukuwe. Dukune zâkkâren âi bikŋan gâsum mem zaarip. Oi sâkŋâ sânduksâip. Sânduksâi ko nalem om ziŋgi niwe. ");
INSERT INTO kpf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ŋâtiksâisâi kamân mâirâp zen a wâkeziŋoot sot sisi mâsekziŋoot a ambân gâbâreziŋgâm Yesugâren gawe. ");
INSERT INTO kpf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A ambân aksik mirâ sâŋgânŋan ga mindum tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesuŋâ a ambân doŋbep mâsek top top kubikziŋgip. Oi wâkeziŋoot wâke zo moliziŋgi âiwe. Wâke zen Yesugât topŋâ nâŋgâwe. Oi zo sâm muyagibegât dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesugât arâpŋâ uman zem tatnetâ ŋâtigân Yesuŋâ zaatŋâ zâmbam hân ŋâi a mân ândiândiŋan ba arip. ");
INSERT INTO kpf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Âim ko ninâu sâm ândeip. Haŋsâi Simoŋ sot bukurâpŋâ, zen Yesu kârum âim muyagemŋâ sâwe, ");
INSERT INTO kpf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","“A ambân zen aksik kârugige.” Sânetâ Yesuŋâ itâ sâip, “Kamân ginŋan ginŋan âinâ. ");
INSERT INTO kpf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Zoren den siŋgi âlipŋâ dâzâŋgobarâk. Oi nep zo tuubat sâm gem gâwan.” ");
INSERT INTO kpf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yatâ sâmŋâ Galilaia hânân kamân dâp âim gam mâpâmâpâse namâziŋan zâim siŋgi âlip den dâzâŋgomŋâ wâkeziŋoot moliziŋgâm ândeip. ");
INSERT INTO kpf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sâk bâlâ a ŋâi Yesugâren âimŋâ um topŋan simin liim pindiŋsâm sâip, “Gâ imbaŋâgâ ziap, zorat gâ kubiknibâ sâm âlip kubikniban.” Yatâ sâi Yesuŋâ umŋâ nâŋgâm ko sâkŋan gâsum sâip, ");
INSERT INTO kpf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","“Nâ nâŋgâgigan. Bâi sâkkâ âlip oik.” Yatâ sâi ko useŋâ sogei âlip oip. ");
INSERT INTO kpf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","43","Oi Yesuŋâ zorat siŋgi zo a ambân torenŋâ mân dâzâŋgobapkât sâm kâtigem sâŋgongoip. ");
INSERT INTO kpf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Itâ dukuip, “Gâ nâŋgâ. Zorat den siŋgi a ambân laŋ mân dâzâŋgoban. Mârum ŋâi Moseŋâ den ŋâi sâip, zo luban. Gâ tirik namâ galem agâren âi sâkkâ tirâpkuna egi ko nii mo zuu ŋâi mem ko Anutugât siŋgi sâm a sâtŋâ zo pindânan. Usegâ sogiap, zo a ambân ek nâŋgâbigât yatâ otnan.” ");
INSERT INTO kpf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sâi ko a zo zâk âim ko Yesugât diŋâ kwâkâm a ambân pisuk âi dâzâŋgoip. Zorat opŋâ a ambân ziŋâ Yesugâren mindum gabegât Yesu zâk kamân patin mân âim gâip. Birâm hibuk mâtâp âim gam ândeip. Yatâ ândei ko a ambân kamân naŋgâm naŋgâm tarâwe, zeŋak zâkkâren âimarâwe. ");
INSERT INTO kpf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesu zâk mâik ŋâi ândim ko Kapenaum kamânân âbureip. ");
INSERT INTO kpf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Âburem mirin zâi tâi ko kamân mâirâp zen nâŋgâmŋâ zâkkâren mindum mirâ piksâmŋâ mirâ sâŋgânŋan mindumŋâ mirâ mâtâpŋâ dooŋguwe. ");
INSERT INTO kpf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yesu zâk mirin den dâzâŋgom tâi a kimembut bukuziŋâ ŋâi kin bik mumuŋâ, zo lum gawe. ");
INSERT INTO kpf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Oi a ambân nâmbutŋâ zen sot gawe. A kâmut patâŋâ mirâ mâtâp dooŋgune ko lum mirâ kwâkŋan zâim ogep kwâsat temŋoorâk pane Yesugât kiŋ topŋan geip. ");
INSERT INTO kpf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pane gei zei ko Yesuŋâ nâŋgâm pâlâtâŋziŋaŋgât bonŋâ zo ekŋâ a zo itâ dukuip “Nannâ, tosagâ biran.” ");
INSERT INTO kpf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yatâ sâi ko Anutugât gurumin den zorat galem a tarâwe, ziŋâ itâ nâŋgâwe, ");
INSERT INTO kpf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“A zi wan den sap? Zâk Anutu mem ge kwap sap. Op ko Anutu zâizâiŋ okŋâŋgap. Anutu, zâk kânokŋâ tosaniŋâ birâmap.” Yatâ nâŋgâm tatnetâ Yesuŋâ umziŋan nâŋgâm itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","“Zen umziŋan wangât den zo yatâ nâŋge? Zen dap nâŋge? Nep ikâ zorâŋâ bâbâlaŋ? Tosa birâbirâŋ mo sâk kubikkubik?” ");
INSERT INTO kpf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yatâ sâmŋâ Yesuŋâ itâ sâip, “A bonŋâ nâ hânân ândim a ambân zeŋgât tosaziŋ birâbatkât imbaŋâ zemnigap, zorat topŋâ ikpigât den zo dukuan.” ");
INSERT INTO kpf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Yatâ dâzâŋgomŋâ puriksâm a kiŋ bik mumuŋ zo itâ dukuip, “Gâ zaat isen koremgâ zo mem ko ba kamângan âi.” ");
INSERT INTO kpf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yatâ sâi zaatŋâ mâteziŋanâk isenŋâ zo mem ko ba arip. A ambân zen ekŋâ kâwaliziŋâ buŋ oi Anutu mâpâsem sâwe, “Kulem zi itârâŋ âsagei iksen, zi sen pup iksen.” ");
INSERT INTO kpf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu zâk yatâ op ko dum Galilaia saru sâtŋan giarip. Zoren a ambân mindum ganetâ den siŋgi âlip sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dâzâŋgom âim ko Alipaiogât nanŋâ Lewi egi kât mimiŋâ namin tâi itâ sâm dukuip, “Gâ nâ sot pâlâtâŋ op molini.” ");
INSERT INTO kpf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sâi zâk zaatŋâ bekŋan sâip. Lewiŋâ sâi Yesu mirin zâi tâi Lewi bukurâpŋâ kât mâme a sot bâliŋ mâme a tatnetâ Yesu sot arâpŋâ zen sot nalem niwe. Kât mâme a zen kât memŋâ nâmbutŋâ kâmbu memarâwe. A zo yatâ zo doŋbepŋâ Yesu molim zâk sot ândim pâlâtâŋ kwarâwe. ");
INSERT INTO kpf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Parisaio a kâmurân gâbâ Anutugât gurumin den zorat galem a nâmbutŋâ, zen iknetâ Yesu zâk kât mimiŋ a sot bâliŋ mâme a osetziŋan tap nalem neip. Parisaio a zen ekŋâ Yesu arâpŋâ itâ sâm mâsikâziŋgâwe, “Wangât patâziŋâ zâk bâliŋ mâme a zen sot tap nalem niap?” ");
INSERT INTO kpf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sâne Yesuŋâ nâŋgâm itâ sâm dâzâŋgoip, “Sisi mâsek kubikkubik a, zen a sâkziŋâ wâgân zeŋgâren nep mân tuume. A mâsekziŋoot zeŋgârenâk tuume. A ziiŋaŋgât nen âlipŋâ sâme, nâ zeŋgât mân gem gâwan. Nâ bâliŋ mâme a diiziŋga nâgâren gabigât sâm gem gâwan.” ");
INSERT INTO kpf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Narâk zoren Yohane arâpŋâ sot Parisaio a, zen nalem birâm kendon ândiwe. A nâmbutŋâ ziŋâ Yesugâren âim itâ sâm mâsikâwe, “Yohanegât arâpŋâ sot Parisaio zeŋgât arâpziŋâ, zen nalem birâm ândime. Arâpkâ zen ko wangât nalem mân birâm nemŋik ândie?” ");
INSERT INTO kpf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yatâ sâm mâsikâne Yesuŋâ itâ sâm dâzâŋgoip, “A kutâ, zâk arâpŋoot ândei dap yatâ nalem birâm ândibi? A kutâziŋoot ândim yatâ mân upi. ");
INSERT INTO kpf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gâtâm a kutâ betziŋan mine kârubi, narâk zoren umbâlâ op nalem birâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nen hâmbâ sâŋgiŋâ oloŋoloŋan zo uŋakŋâ mân pam gârimen. Wangât, uŋâkŋandâ sâŋgiŋâ zo diigi oloŋi mâtâp patâ opap sâmŋâ mân upmen. ");
INSERT INTO kpf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wâiŋ too kâtik uŋakŋâ hâkop sâŋgiŋan mân gune geimap. Yatâ upi, zo ko waiŋ too kâtikŋâ zorâŋ hâkop kunziri hâkop sot waiŋ ârândâŋ buŋ upabot. Waiŋ uŋakŋandâ hâkop uŋakŋan giari dâpŋâ upap.” ");
INSERT INTO kpf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yuda zeŋgât kendon narâk ŋâin Yesu sot arâpŋâ kâlamân obândiwe. Âim ko arâpŋâ zen segoŋ burotŋâ namuŋ niwe. ");
INSERT INTO kpf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yatâ utne Parisaio a ziŋâ Yesu itâ sâm dukuwe, “Ziŋgitnan. Zen kendonân mân orotŋâ ue.” ");
INSERT INTO kpf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Sânetâ Yesuŋâ itâ sâm dâzâŋgoip, “Dawidi sot arâpŋâ, zen nalemgât mom ko urâwe. Zen den zo sâlâpkum nâŋgâme mo buŋâ? Abita tirik namâ galem a ândeip, narâk zoren Dawidiŋâ Anutugât tirik namin zâim Anutugât siŋgi nalem parâwe, zo mem nem ko arâpŋâ ziŋgi niwe. Zen mân orotŋâ urâwe. Tirik namâ galem a, zen ziiŋik nalem zo nimbigât sâsâŋ.” ");
INSERT INTO kpf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yatâ sâmŋâ itâ dâzâŋgoip, “Kendon zo agât op âsageip. ");
INSERT INTO kpf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ka aŋâ kendongât mân op âsagiwen. Oi a bonŋâ, nâ kendongât sot kut ŋâi ŋâigât mariŋâ ândian.” ");
INSERT INTO kpf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","A ŋâi bikŋâ humutŋik mâpâmâpâse namin zâi tâi Yesu zâk zoren zarip. ");
INSERT INTO kpf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","A nâmbutŋâ ek tatnetâ kubikŋaŋgi ko denân pânam tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesuŋâ a bikŋâ humutŋik zo itâ dukuip, ");
INSERT INTO kpf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","“Gâ zaatŋâ a ambân mâteziŋan ga kin.” Sâi zari Yesuŋâ a ambân itâ mâsikâziŋgip, “Mâsikâziŋga sânek. Kendonân nep ikâ zorâŋ âlip tuutuuŋ? A kubikziŋgâziŋgâŋ mo a tâmbetzâŋgozâŋgoŋ?” ");
INSERT INTO kpf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","6","Yatâ sâi zen den hâuŋâ mân sâwe. Mân sânetâ purikgurik op kin ziŋgitŋâ um kâtikziŋaŋgât op umŋâ bâleip. A zo itâ dukuip, “Bikâ tâŋtâŋ pa.” Sâi a bikŋâ pâi âlip oip. Yatâ oi ekŋâ Parisaio a, zen âimŋâ Herode arâpŋâ zen sot zorenâk zâk dap yatâ kunat sâm den âraguwe. ");
INSERT INTO kpf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu sot arâpŋâ saru sâtŋan âine a ambân kâmut patâ Galilaia hânân gâbâ sot Yudaia hânân gâbâ sot Yerusalem kamânân gâbâ sot Idumaio hânân gâbâ sot Yodaŋ too nâmbut zeŋgâren gâbâ sot Tiro Sidoŋ zeŋgâren gâbâ, a kâmut patâ zo, ziŋâ Yesugât den siŋgi nâŋgâmŋâ ga Yesugâren minduwe. ");
INSERT INTO kpf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesuŋâ ziŋgitŋâ arâpŋâ itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","“Waŋgâ ŋâi ga gootniŋan tâik.” A kâmut zorâŋ lâŋ kwândâlenibegât sâm waŋgâgât sâip. A doŋbep kubikziŋgâmâip, zorat op a mâsekziŋootŋâ gootŋan âinam agom kâbakŋeyaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ka a wâkeziŋoot zorâŋ ko hânân gei pindiŋsâm zem kambâŋ sâm sâwe, “Gâ Anutugât nanŋâ op ândiat.” ");
INSERT INTO kpf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yatâ sânetâ Yesuŋâ zikŋâ topŋâ zo a ambân laŋ mân dâzâŋgobigât sâm kâtigeip. ");
INSERT INTO kpf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu zâk bakŋâ ŋâin zâim a umŋandâ nâŋgâm sâlâpzâŋgoip, zo zâŋgonsâi zâkkâren gawe. ");
INSERT INTO kpf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ganetâ a kiin zagât zâk sot ândibigât sâip. A kiin zagât zo itâ sâm dâzâŋgoip, “Zen âimŋâ a ambân den siŋgi âlipŋâ dâzâŋgobi.” ");
INSERT INTO kpf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yatâ sâm ko wâke molibigât imbâŋâ ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A kiin zagât zo, zeŋgât kutziŋâ itâ, Simoŋ, Yesuŋâ kutŋâ ŋâi Petero sâm pindip. ");
INSERT INTO kpf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedaiogât nanzatŋâ Yakobo sot munŋâ Yohane, zekât kutzikŋâ Boanegesi sâip (niiŋ denân ko, dinzikŋâ kundunduŋ yatâ opmap). ");
INSERT INTO kpf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrea, Pilipo, Batolomaio, Mataio, Toma, Alipaiogât nanŋâ Yakobo sot Tadaio sot a ŋâi Simoŋ Zelote sot Yuda Karioto kamânân gokŋâ. ");
INSERT INTO kpf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yuda zâk ândim Yesu tirâpzâŋgoi kâsa ziŋ gâsuwe. ");
INSERT INTO kpf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu sot arâpŋâ mirin zâimŋâ nalem om ninat sânetâ a ambân kâmut patâ mindune ko nalem mân niwe. ");
INSERT INTO kpf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesugât torerâpŋâ ziŋ itâ sâm gâsunam âiwe. A nâmbutŋandâ Yesugât umŋâ gulip uap sâwe. ");
INSERT INTO kpf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Anutugât gurumin den zorat galem a nâmbutŋâ, zen Yerusalem kamânân gâbâ gam itâ sâwe, “Wâke zeŋgât patâziŋâ Bezebuluŋâ umŋan gei kin, zorâŋ imbaŋâ pindi wâke moliziŋgâmap.” ");
INSERT INTO kpf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sânetâ Yesuŋâ zâŋgonsâi zâkkâren âine den sumbuŋâ itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Sataŋ zâk âlip zikŋak moliaŋgâbap mo? Hân ŋâigât a zen ziiŋak agom kâsâpagone hânziŋâ kwamen zimbap. ");
INSERT INTO kpf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","A ŋâi sot warâpŋâ, zen sârek op kâsa utne kâsâp âsagibap. ");
INSERT INTO kpf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sataŋŋâ arâpŋâ zâŋgom moliziŋgi sâi ko zâkkât nep kamânŋâ zorâgoot gulip opap.” ");
INSERT INTO kpf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yesuŋâ yatâ sâmŋâ Sataŋgât den sumbuŋâ ŋâi itâ sâm dâzâŋgoip, “Mirâ mariŋâ, zâk kâwali op mirin tâi ŋâiŋâ zâim sikum kut ŋâi ŋâi laŋ mimbap? Zo mân orot. A zorâŋâ kâwali a zo kom kiŋ bik saam pam ko sikumŋâ âlip bekŋan mimbap.” ");
INSERT INTO kpf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Op ko Anutugât gurumin den zorat galem a, zen Yesu umŋan wâke ândiap sâwe, zorat itâ sâm dâzâŋgoip, “Nâ perâkŋak dâzâŋgobâ. Den bâliŋ top top zorat tosa birâbirâŋ, zo ziap. Ka a ŋâi zâk Tirik Kaapum mem gei kwâkŋaŋgâm den bâliŋâ sâbap, zorat tosa ko mân birâbirâŋâ. Zo ko narâk dâp tap zâibap.” ");
INSERT INTO kpf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Den yatâ dâzâŋgom tâi Yesugât mamŋâ murâpŋâ sombemân ga kin gibapkât den pane zarip. Oi Yesuŋâ a ambân osetziŋan tâi dukuwe, ");
INSERT INTO kpf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","“Mamgâ sot mun gatkâ ga kin gem gânan se.” ");
INSERT INTO kpf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sâne a ambân tarâwe, zo ziŋgitŋâ itâ sâm dâzâŋgoip, “Nâgât mamnâ sot murâpnâ, zo waniŋ ziŋâ? ");
INSERT INTO kpf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nâgât mamnâ mun garâpnâ zi te. ");
INSERT INTO kpf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Anutugât sâtŋâ nâŋgâm lume, zen nâgât mamnâ mun garâpnâ ue.” ");
INSERT INTO kpf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesuŋâ saru sâtŋan geim den siŋgi âlipŋâ dum dâzâŋgoip. A ambân doŋbep patâ mindune birâm waŋgâyân zâi tâip. A ambân zen sagân tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesu zikŋâ waŋgâ kwâkŋan tapŋâ den siŋgi âlipŋâ sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Den sumbuŋâ top top dâzâŋgoip. Ŋâi itâ sâm dâzâŋgoip, “Nâ sa nâŋgânek. ");
INSERT INTO kpf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A ŋâi keet maandiŋbam nebân arip. Âi maandeŋi ko keetŋâ nâmbutŋâ mâtâbân gei zeip. ");
INSERT INTO kpf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Zei nii ziŋâ ga nem naŋgâwe. Keet nâmbutŋâ ko hân siŋitŋan gei zeip. Kât kwâkŋan zeipkât kek takip. ");
INSERT INTO kpf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Zo mirâsiŋ takâm maa irikirik pâi moip. Ândâŋâ kât kwâkŋan zeipkât maa egi hâlâlâŋsâm moip. ");
INSERT INTO kpf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Keet nâmbutŋâ hibuk osetŋan gei zeip. Oi kâmŋâ taki hibukŋâ kwârakuipkât bonŋâ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Keetŋâ nâmbutŋâ ko hân kelâkŋoorân gei zei bonŋâ takâmŋâ bonŋâ imbaŋâ oip. Topŋâ ŋâigât 30 oi, ŋâigât 60 oi, ŋâigât 1 handeret. Bonziŋâ yatâ âsagiwe.” ");
INSERT INTO kpf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Den yatâ sâmŋâ itâ sâip, “A ŋâi kindapŋootŋâ ko den zi nâŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","A ambân doŋbep patâ âim naŋgâne a nâmbutŋâ sot Yesu arâpŋâ zen ziiŋik tapŋâ den sumbuŋaŋgât topŋâ mâsikâwe. ");
INSERT INTO kpf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mâsikâne sâip, “Anutugât um topŋan bagibagiŋaŋgât den sumbuŋâ, zo zen nâŋgâm kwâkâbigât sâsâŋ. Ka a nâmbutŋâ ko topŋâ mân nâŋgâbigât den sumbuŋâ dâzâŋgoman. A sâŋgiŋâ Yesaiaŋâ den ŋâi itâ sâm kulemguip, ");
INSERT INTO kpf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Umziŋ mân âburei ko tosaziŋ zemziŋgâbapkât zen siŋziŋandâ igikŋâ ko ikpi, ka mân nâŋgâm kwâkâbi. Kindapziŋandâ nâŋgâbi, ka mân nâŋgâm kwâtâtibi.’ ");
INSERT INTO kpf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Zen ko den sumbuŋâ san, zorat topŋâ mân nâŋge? Den sumbuŋâ nâmbutŋâ sa dap dap yatâ nâŋgâm kwâkâbi? Den sumbuŋâ san, zo topŋâ itâ. ");
INSERT INTO kpf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Keetŋâ maandeŋip, zo ko den siŋgi âlipŋâ yatâ. ");
INSERT INTO kpf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","16","Keetŋâ mâtâbân gei zeip, a nâmbutŋâ yatâ ândime. Zen den siŋgi nâŋgâne Sataŋŋâ ga betziŋan mem âimap. ");
INSERT INTO kpf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Keetŋâ hân siŋitŋan gei zeip, zo ko a nâmbutŋâ zo yatâ ândime. Zen den siŋgi âlipŋâ nâŋgâm âkŋâlem ândine ko umziŋan mân gâsui ko narâkŋâ pâŋkânok mem ândibi. Siŋgi âlipkât kâmbam gâi ko loremŋâ kektâ birâbi. ");
INSERT INTO kpf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Keetŋâ nâmbutŋâ hibuk osetŋan gei zeip, zo ko a nâmbutŋâ yatâ ândim den âlipŋâ nâŋgâm sâkziŋaŋgât keŋgât donŋbep op ândime. ");
INSERT INTO kpf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Hângât sikum zorat âkŋâle sot bâliŋâ top top, zo umziŋan geim siŋgi âlipŋâ zo koi bonŋâ buŋ opmap. ");
INSERT INTO kpf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Keetŋâ nâmbutŋâ hân kelâkŋan ge zeip, zorat dâp a nâmbutŋâ zen den âlipŋâ mem ândim bonŋâ muyagime. Nâmbutŋandâ 30, nâmbutŋandâ 60, nâmbutŋandâ 1 handeret. Bonŋâ yatâ muyagime.” ");
INSERT INTO kpf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Den ŋâi itâ târokwap sâip, “Zen kârâp sâum mirin zâim âmaŋân mân pam kwârakume. Kârâp sâum tâtatŋâ gobetŋan mân pame. Buŋâ. Tâtatŋan panetâ tapŋâ ko âsakŋâ âsagibap. ");
INSERT INTO kpf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kut ŋâi ŋâi hânân tik ziap, zo zemŋâ tik mân zimbap. Zo âsagem kagibap. ");
INSERT INTO kpf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","A ŋâi, zâk kindapŋootŋâ den zi nâŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Zen den nâŋge, zo nâŋgâm kwâtâtibi. A ŋâi, zâk den nâŋgâm kwâtâtei Anutuŋâ nâŋgânâŋgâ âlipŋâ târokwap pindâbap. ");
INSERT INTO kpf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A ŋâi nâŋgânâŋgâŋoot, zo Anutuŋâ târokwap pindâbap. Ka a ŋâi zâk den mân nâŋgâm kwâtâtei ko Anutuŋâ birâm bekŋan mimbap.” ");
INSERT INTO kpf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuŋâ den ŋâi itâ sâip, “Anutugât siŋgi âlip zorat mâtâp, zo itâ. ");
INSERT INTO kpf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","A ŋâiŋâ nebân keet maandeŋmap. A zo ŋâtik hilâm ândim zari keet zo kâmŋâ takâm zâimap. ");
INSERT INTO kpf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A zo topŋâ mân ek nâŋgi ko hânŋâ too sot nalem pindi ko kâmŋâ takâm zâimap. ");
INSERT INTO kpf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Zâim ilum opŋâ bonŋâ opmap. Oi zobâ bon sâlâpagoi sândum memap.” ");
INSERT INTO kpf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuŋâ den ŋâi târokwap itâ sâip, “Anutugât siŋgi âlip zorat mâtâp zo ko wanân dâpkwap sâbâ? ");
INSERT INTO kpf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anutugât siŋgi âlipkât mâtâp, zo nak keetŋâ yatâ. Keet zo wakum keetŋâ yatâ. Keet zo nak nâmbutŋâ ombeŋan. Keet zo mâiktâra. ");
INSERT INTO kpf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Oi hânân kendindâ hibuk walâziŋgâm nakŋâ patâ lâmbatmap. Bâranŋan nii ga pam sândukŋan tapme.” ");
INSERT INTO kpf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu zâk den sumbuŋâ top top sâm, den âlipŋâ sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nâŋgânâŋgâziŋaŋgât dâp dâzâŋgoip. Oi sâm muyagem mân dâzâŋgoip. A ambân âim naŋgâne ko Yesu sot arâpŋâ ziiŋik tap sâm muyagem dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hilâm zorenâk ŋâtiksâisâi Yesuŋâ waŋgâyân tap ko arâpŋâ itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","“Saru torengen âinâ.” Yatâ sâi zorâŋak waŋgâyân zâim a ambân kâmut zâmbam âiwe. Âinetâ waŋgâ nâmbutŋâ zen molimoli âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Âinetâ pibâ patâ koi saru âbâŋgum waŋgâ kâligen giarip. ");
INSERT INTO kpf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Waŋgâ kâligen gei piksâbam oi Yesu zikŋâ waŋgâ murukŋan koremŋâ kâuk kombâŋ pam uman zem tâip. Zem tâi ko arâpŋâ zen mâŋgim dukum sâwe, “Kembuniŋâ, nen saruyân geinamen. Gâ neŋgât mân nâŋgâm zem taat?” ");
INSERT INTO kpf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yatâ sâm mâŋgine zaat pibâ sot saru itâ sâm dâzâkoip, “Hiriŋsâm zeit.” ");
INSERT INTO kpf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sâi hiriŋsâm ziwet. Oi arâpŋâ itâ mâsikâziŋgip, “Zen wangât keŋgât ue? Zen dap yatâ mân nâŋgâm pâlâtâŋ kwatnime?” ");
INSERT INTO kpf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sâi zen keŋgât yâmbât op âragum sâwe, “Pibâ sot saru sot kut ŋâi ŋâi, zen diŋâ lume. A zi zâk dap yatâ?” ");
INSERT INTO kpf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Zen waŋgâyân zâim ko ba saru nâmbutken âiwe. Âim ko Gerasene hânân takâwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Takâm hân kârâkŋan zâine ko a ŋâi wâkeŋoot, zâk mumuŋâ zeŋgât kwagân gâbâ gâip. ");
INSERT INTO kpf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A munetâ kât mâtâpŋan zâmbanmarâwe. Oi a zo zâk zoren zânzeku op ândei ko a ziŋ gâsum tâk kâtikŋandâ kin bikŋâ saane ko tâk tiriktâruk ba âimâip. ");
INSERT INTO kpf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aŋâ mân gâsum saabe yatâ. A zo kâwali imbaŋâ mem ândeip. Ŋâtik sot hilâm dâp a zeŋgât kwagân sot mirâ kamân âtâŋan zânzeku op ândeip. ");
INSERT INTO kpf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Den sâm kambâŋ sot kât memŋâ zikŋâ agoyaŋgâmâip. ");
INSERT INTO kpf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","A zorâŋâ Yesu kârebân gâi ekŋâ sârârâk kârâm ga pindiŋsâip. ");
INSERT INTO kpf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Gâi ko Yesuŋâ itâ sâip, “Wâke, gâ a umŋan gâbâ takâm ba âinan.” Yatâ sâi ko a wâkeŋoot, zâk den itâ sâm kambâŋip, “Yesu Anutu patâgât nanŋâ, gâ dap otnibam gaat? Anutugât mâteŋan dâgobâ. Gâ sâknam mân niban.” ");
INSERT INTO kpf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sâi ko Yesuŋâ wâke mâsikip, “Gâ kutkâ ŋâi?” Mâsiki sâip, “Nen kutniŋ kâmut. Nen ko doŋbepŋâ ândien.” ");
INSERT INTO kpf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yatâ sâm Yesugâren itâ sâip, “Mânâk moliniŋgâna hân ŋâin âinat.” ");
INSERT INTO kpf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Oi hân zoren bâu kâmut patâ parâŋan gendâk nem ândiwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wâke zen Yesuŋâ sâi ayân gâbâ takâm âi bâu umziŋan geibigât dukuwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Oi Yesuŋâ nâŋgâziŋgi ko wâke zen a umŋan gâbâ takâm bâu umziŋan geinetâ bâu aksik zen sârârâk kârâm âi simân geim saruyân geim mom naŋgâwe. Bâu bituk buŋâ, 2 tausen yatâ muwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bâu galem a, zen zo ekŋâ sârârâk kârâm âimŋâ mâtâbân a ambân dâzâŋgom âiwe. Ziiŋ kamânziŋan âim den siŋgi zo yatik dâzâŋgowe. A ambân ziŋ siŋgi zo nâŋgâmŋâ iknam âim minduwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Zen Yesugâren âim igâwe. A wâkeŋoot ândeipŋâ Yesu kiŋ topŋan petŋâ lapŋâ nâŋgânâŋgâŋoot op a lumbeŋâ op tâip. Yatâ tâi ekŋâ ko a gawe, zo ziŋâ keŋgâtziŋaŋgât urâwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ka a nâmbut, a zo ek nâŋgâweŋâ ko agât den siŋgi sot bâu zeŋgât siŋgi dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Den zo nâŋgâmŋâ ko Yesuŋâ zen sot mân ândibapkât sâm dukuwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesuŋâ waŋgâyân zâibam oi a wâkeŋoot ândeipŋâ Yesu sot âibat sâm kâtigeip. ");
INSERT INTO kpf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sâi ko Yesuŋâ kwâkâŋaŋgâm itâ sâip, “Gâ âburem kamângan âim a torerâpkâ zen sot ândiban. Oi Kembuŋâ âlipŋan kwatgigap, zorat siŋgi torerâpkâ dâzâŋgoban.” ");
INSERT INTO kpf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Sâi a zo âim Yesuŋâ kubikŋaŋgip, zorat siŋgi kamân bâzagât tarâwe, zoren ândim a ambân dâzâŋgoi nâŋgâm imbaŋâziŋ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesuŋâ waŋgâyân zâimŋâ saru nâmbutken âim ko sagân gei kiri a ambân ekŋâ ga minduwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mindunetâ mâpâmâpâse namâ galem a ŋâi, kutŋâ Yairo, zâkŋâ gam Yesugât kiŋ topŋan geim pindiŋsâm itâ sâm kâtigeip, ");
INSERT INTO kpf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Bâratnâ mumbam uap, gât ko âi bikŋan gâsuna âlip op zaat ândibap.” ");
INSERT INTO kpf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yatâ sâm dukui Yesu zâk sot arip. A ambân doŋbep, ziŋâ mem oset kwâkŋaŋgâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ambân ŋâi osetziŋan ândeip, zâk gilâm gem ândeip. Yatâ op ândei kendon patâ kiin zagât yatâ âkip. ");
INSERT INTO kpf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Oi kubikkubik a ziŋ nep tuum osimŋâ mân kubigâwe. Kubikŋaŋgânâ sâne zorâŋak patâ oip. Sângânŋâ kwâlâziŋgâm gâi kât sot sikum motŋâ buŋ op naŋgip. ");
INSERT INTO kpf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ambân zorâŋâ Yesugât den siŋgi nâŋgâm ko a ambân osetziŋan gâbâ Yesu kândâtŋan gam hâmbâŋan weegip. Ambân zo zâk itâ nâŋgâm ko oip. ");
INSERT INTO kpf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Hâmbâŋâ weebat, zo ko âlipnâ upat sâip. ");
INSERT INTO kpf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Weem zorâŋak gilâm kârâksâi sâkŋâ âlip oi nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Oi Yesu zâk imbâŋâ ŋâi gei nâŋgip. Nâŋgâm puriksâm mâsikâziŋgâm sâip, ");
INSERT INTO kpf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","“Ŋâiŋâ hâmbânan weegap?” Sâi arâpŋâ zen dukuwe, ");
INSERT INTO kpf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","“Wangât sat? A ambân doŋbep patâ haamgoge, zo ka.” Sânetâ Yesu zâk ambân weegip, zo ek kâruip. ");
INSERT INTO kpf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Oi ambân zo mâsek âlip oi nâŋgip, zorat umŋâ sâtâŋgui sânam sâmbui Yesugât kiŋ topŋan gei pindiŋsâmŋâ topŋâ sâm muyageip. ");
INSERT INTO kpf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sâm muyagei Yesuŋâ itâ sâm dukuip, “Gâ nâŋgâm pâlâtâŋ kwâtnimat, zorat op âlipkâ uat. Âlip op ko umgâ diim gei ândiban.” ");
INSERT INTO kpf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuŋâ ambân zo yatâ dukum kiri a nâmbutŋâ mâpâmâpâse namâ galem a mirin gâbâ gam sâwe, ");
INSERT INTO kpf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","“Bâratkâ muap, zorat patâ mirâgan mân diim zâiban.” Yatâ sâne Yesu zâk den zo nâŋgâm mâpâmâpâse namâ galem a itâ dukuip, ");
INSERT INTO kpf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","“Mân keŋgât ot. Gâ nâgât nâŋgâm pâlâtâŋ kwatnina bâratkâ âlip upap.” Yatâ sâmŋâ a ambân kâmut zo mân gabigât sâm zâmbam arip. Petero sot Yakobo sot zâkkât munŋâ Yohane, zeŋagâk sâi ârândâŋ âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Âi takâne mirin a ambân zen âigirâp patâ op tatne ziŋgirip. ");
INSERT INTO kpf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ziŋgit ko mirin zâimŋâ a ambân itâ dâzâŋgoip, “Wangât isem te? Ambân zi mân muap. Zâk yen uman zem taap.” ");
INSERT INTO kpf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sâi nâŋgâm girâŋŋaŋgâwe. Oi sâi geim naŋgâne ambân katepkât ibâ mam sot arâpŋâ karâmbut sâi ambân katep zeibân bagiwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesuŋâ ambân zo bikŋan gâsumŋâ ziiŋ denân sâip, “Talita kumi (niiŋ denân ko, Ambân dâgoga zaat).” ");
INSERT INTO kpf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sâi zorenâk ambân zo zaat âim gâip. Ambân katep zo kendonŋâ kiin zagât yatâ. Yatâ oi ekŋâ imbaŋâziŋ buŋ oi sâlâpziŋan zim kirâwe. ");
INSERT INTO kpf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesuŋâ siŋgi zorat a ambân laŋ mân dâzâŋgobi sâm kâtigeip. Oi ambân zo nalem pindâne nimbapkât sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu zâk mirâ kamân zo birâm kamânŋan ari arâpŋâ molim âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Âi ândei Yuda zeŋgât kendon narâkŋâ oi mâpâmâpâse namin zâi siŋgi âlipŋâ sâm dâzâŋgoi a doŋbep ziŋ den siŋgi âlipŋâ nâŋgâm imbaŋâziŋ buŋ oi itâ sâwe, “Den siŋgi âlipŋâ zi ŋâiŋâ kwâkâm pindap? Ŋâiŋâ nâŋgânâŋgâ patâ zi pindap? Kut ŋâi ŋâi tuutuuŋâ, zo topŋâ dap yatâ? ");
INSERT INTO kpf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Zâk mirâ tuutuuŋâ a. Zo Mariagât nanŋâ. Zâkkât murâpŋâ Yakobo, Yose, Yuda, sot Simoŋ, zeŋgât âtâziŋâ zo. Ka garâpŋâ osetniŋan ândie.” Yatâ sâm zâkkât nâŋgâne gigiŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Oi Yesuŋâ itâ sâm dâzâŋgoip, “Propete ŋâi zâk kutsiŋgiŋâ kamân dâp laŋ kârâm ari kamârâp sot torerâpŋâ, ziiŋ ko nâŋgâne yenŋâ opmap.” ");
INSERT INTO kpf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yatâ ândiwegât Yesuŋâ zeŋgâren nep patâ tuubam kwagip. Zâk a mâsekziŋoot kânok kânok weeziŋgi âlip urâwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A ambân doŋbep patâ umziŋandâ aŋgân kârâwegât nâŋgi yâmbât oip. Oi kamân torenŋâ ginŋen, zeŋgâren âi den siŋgi âlipŋâ dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesuŋâ sâi arâpŋâ gane ko zagât zagât âi den siŋgi âlipŋâ sâbigât sâŋgonzâŋgoip. Wâke moliziŋgâbigât imbaŋâ ziŋgâm itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“Zen tânziŋik mem âibi. Zen mâtâpkât nalem sot kât sot irâ mân mem âibi. ");
INSERT INTO kpf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ki pâke zo ko mem ândibi. Hâmbâ ko umŋan sâkŋan buŋâ, kânogâk mem âibi.” ");
INSERT INTO kpf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yatâ sâmŋâ dâzâŋgoip, “Kamân ŋâi âimŋâ mirâ zâibi, zorenâk tâtat mâme opŋâ gem kamân ŋâin âibi. ");
INSERT INTO kpf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kamân ŋâi takâne a ambân ziŋâ mân buku otziŋgâmŋâ dinziŋâ birâne kândâtzâŋgom ko kinziŋan gwapgwap lâŋ gâbârine gei topziŋâ nâŋgâbi. Zen yatâ opŋâ kamân zo birâm âibi.” ");
INSERT INTO kpf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yatâ sâi zen âimŋâ a ambân umziŋ melâŋbigât den sâm dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wâke doŋbep moliziŋgâwe. A mâsekziŋoot doŋbep kelâk saŋgonziŋgâm kubikziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesugât den siŋgi laŋ kârâm a kutâ Herodegâren ari nâŋgip. A nâmbutŋâ ziŋâ Yesugât itâ sâwe, “Yohaneŋâ too saŋgonziŋgip, zâkŋâ mumuŋan gâbâ zaat kâwaliŋoot ândiap.” ");
INSERT INTO kpf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","A nâmbutŋandâ Yesugât itâ sâwe, “Zâk Elia zaat ândiap.” Sâne nâmbutŋandâ itâ sâwe, “Zâk Propete ŋâi, Propete sâŋgiŋâ yatâ.” ");
INSERT INTO kpf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodeŋâ den zo nâŋgâm sâip, “Buŋâ. Yohane sa gânduŋ kârâm mânâŋgârâwe, zâkŋâ zaat ândiap.” ");
INSERT INTO kpf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herode zâk mârumŋan kâwali a sâŋgonzâŋgoi Yohane gâsum tâk namin parâwe. Mârum ombeŋan Herodeŋâ munŋâ Pilipo zâkkât ambinŋâ Herodia bekŋan meip. Ambân zâkkât opŋâ Yohaneŋâ Herode itâ dukuip. ");
INSERT INTO kpf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","“Gâ mungaŋgât ambân mein, zo mân dap uap.” ");
INSERT INTO kpf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yatâ sâi ko Herodegât ambinŋâ Herodia, zâk Yohanegât um kâlak nâŋgâm ândeip. Yohane kumbat sâm mâtâp kârum ândeip. ");
INSERT INTO kpf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodeŋâ ko Yohane a târârak sot âlipŋâ sâmŋâ hurat kwâkŋaŋgâm galem ândeip. Herodeŋâ Yohanegât den nâŋgâm um zagât oip. Oi laŋ diŋâ zo nâŋgâm âkŋâleip. ");
INSERT INTO kpf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Oi Herodiaŋâ Yohane kumbap sâm matâp itâ muyageip. Herodegât âsaâsagiŋ narâkŋâ mâte oi sii nalem om a sâtŋâ sot kâwali a patâ sot Galilaia hânân gâbâ a zâizâiŋâ minduziŋgâm nalem ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mindunetâ ko Herodia bâratŋâ, zâk mâteziŋan zâi kep ândeip. Kep ândei Herode sot arâpŋâ ziŋ ekŋâ âkŋâliwe. Herodeŋâ ambân itâ sâm dukuip, “Gâ wan mo wangât otgigap? Sâna gibâ.” ");
INSERT INTO kpf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yatâ sâm a patâ mâteziŋan sâm kâtigeip, “Wan mo wangât otgigi âlip sâna gibat. Hânnaŋgât sâna âlipŋâ mânâŋgât toren gibat.” ");
INSERT INTO kpf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ambân zo âkŋan âi mamŋâ mâsikâm sâip, “Nâ wan wangât sâbâ?” Sâi mamŋandâ dukuip, “Yohane too saŋgonziŋgip, zâkkât gânduŋâ mânâŋgât kâukŋâ niban.” ");
INSERT INTO kpf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sâi ambân zo sârârâk kârâm âim a kutâgâren itâ sâip, “Yohane too saŋgonziŋgip, zâkkât gânduŋ mânâŋgât kâukŋâ hâkop patin pam ni.” ");
INSERT INTO kpf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodeŋâ den zo nâŋgâm pârâkpam umŋâ bâleip. Zâk a sâtŋâ zeŋgât mâteziŋan sâm kâtigeip, zorat op zo bon upapkât sâi diŋâ nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Kegâk kâwali a ŋâi Yohanegât kâukŋâ mem gâbapkât sâŋgonguip. Kâwali a zo tâk namin âim Yohane gânduŋ mânâŋgât kâukŋâ hâkop patin pam mem ga ambân zo pindip. Ambân zorâŋ memŋâ mamŋaŋgâren mem arip. ");
INSERT INTO kpf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Oi Yohane arâpŋandâ siŋgi zo nâŋgâm âi kâmbarâŋâ mem hanguwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposolo zen âburem ga Yesugâren mindum ko kut ŋâi ŋâi urâwe, zorat den siŋgi dukum naŋgâwe. Den siŋgi âlipŋâ sâwe, zorat dukuwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Narâk zoren doŋbep patâ târotâroyâk mindum âim gawe. Âim ganetâ zen dap op nalem nimbe. Zorat Yesuŋâ arâpŋâ itâ sâm dâzâŋgoip, “Zen ganetâ a mân ândiândiŋan âi ândeindâ sâkniŋ sânduksâik.” ");
INSERT INTO kpf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Oi zen ziiŋik waŋgâyân zâim a mân ândiândiŋan ba âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ka a ambân kâmut ziŋgitnetâ âine kamânŋâ kamânŋâ mindum sârârâk kârâm âim ziŋon âim takâwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Oi Yesuŋâ waŋgâyân gâbâ gem gamŋâ a ambân kâmut patâ ziŋgiri râma galem a buŋâ, yatâ ândiwe. Yesuŋâ zo yatâ ziŋgitŋâ umŋâ nâŋgip. Yatâ ziŋgitŋâ zorâŋak den siŋgi âlipŋâ doŋbep dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Mirâsiŋ geibâ sâi arâpŋâ ziŋâ Yesugâren âim sâwe, “Zi mân ândiândiŋan ândeindâ ŋâtiksapkât a ambân zâmbana kamân tap ariabân âim nalem sâŋgân mem nimbi.” ");
INSERT INTO kpf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sânetâ itâ sâm dâzâŋgoip, “Wangât âibigât se? Ziŋâ nalem ŋâi ziŋgânek.” Sâi itâ dukuwe, “Nen âim kât 2 handeret yatâ zorâŋ nalem kwâlâm ga ziŋgânatkât sat?” ");
INSERT INTO kpf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sâne itâ sâm mâsikâziŋgip, “Zeŋgâren nalem dabutâ ziap, zo âi iknek.” Sâi zen âi ekŋâ dukuwe, “Nalem bâtnâmbut sot saru zuuŋâ zagât.” ");
INSERT INTO kpf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sânetâ Yesuŋâ sâi a zen hibuk kwâkŋan kâmutŋâ kâmutŋâ ge tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Teŋgâ ŋâi 1 handeret, teŋgâ ŋâi 50, yatâ tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tatnetâ Yesuŋâ nalem bâtnâmbut sot saru zuu zagât mem siŋâ sumbemân ek sâiwap sâm sonpam ziŋgip. Nalem zo mamuŋ arâp ziŋgi ziŋâ kâsâpkum a ziŋgâwe. Saru zuuŋâ kâsâpkum ziŋgi yatik urâwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Oi zen aksik nem âkon urâwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nalem sot zuu buputŋâ tâip, zo mine irâ kiin zagât piksâip. ");
INSERT INTO kpf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A nalem niwe, zo ko 5 tausen yatâ. ");
INSERT INTO kpf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Oi Yesuŋâ sâi arâpŋâ waŋgâyân zâim ândiren Besaida kamânângen âiwe. Yesu zik ko a ambân zâmbanbam tâip. ");
INSERT INTO kpf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesuŋâ kândâtziŋ kelikŋâ ninâu sâbam bâkŋan zarip. ");
INSERT INTO kpf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ŋâtiksâi waŋgâ saru tânâmŋan âim tâi Yesu zikŋik saru sâtŋan tâip. ");
INSERT INTO kpf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Oi pibâ sâŋgânziŋan gâbâ gâi âinam osim biraŋâwe. Oi Yesuŋâ ziŋgitŋâ haŋsâsâgât ŋâtikŋâ saru kwâkŋan lâŋ lâŋ zeŋgâren âim walâziŋgâbam oip. ");
INSERT INTO kpf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yesuŋâ saru kwâkŋan ari ek wâke gaap sâm keŋgât urâwe. ");
INSERT INTO kpf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Zen aksik ekŋâ keŋgât patâ urâwe. Yatâ utne den itâ sâm dâzâŋgoip, “Zen umziŋ diim geik. Ninak gaan. Zen mân keŋgât utnek.” ");
INSERT INTO kpf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yatâ sâm waŋgâyân zari pibâ hiriŋsâip. Hiriŋsâi a zen imbaŋziŋ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nalem ziŋgip, zorat topŋâ mân nâŋgâwe. Nâŋgânâŋgâziŋ mân pâroŋsâip, zorat. ");
INSERT INTO kpf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Saru nâmbutken âim Genesarete hânân takâm waŋgâ saawe. ");
INSERT INTO kpf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","55","Waŋgâyân gâbâ gine zorâŋak a ambân ziŋ Yesu ekŋâ kamân dâp âimŋâ a mâsekziŋoot helâŋ aam minziŋgâm Yesugâren gawe. ");
INSERT INTO kpf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesuŋâ kamân patin sot mâik mâigân ari ko a ambân mâsekziŋoot sombemân zâmbane âi hâmbâ murukŋan gâsum âlipziŋ upigât Yesu dukune nâŋgip. Dukune nâŋgi hâmbâŋan gâsum âlipziŋ urâwe. ");
INSERT INTO kpf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisaio sot Yerusalem kamânân gâbâ Kembugât gurumin den zorat galem a, zen Yesugâren ga minduwe. ");
INSERT INTO kpf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Oi Yesu arâpŋâ osetziŋan gâbâ nâmbutŋandâ Parisaio a zeŋgât den mân luwe. Zen bitziŋ mân saŋgon nalem nine ziŋgirâwe. ");
INSERT INTO kpf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisaio sot Yuda a aksik patâ, zen bitziŋ saŋgon nalem nemarâwe. Sâkurâpziŋ zeŋgât den lum yatâ opmarâwe. ");
INSERT INTO kpf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Zen mindumindu sombemân gâbâ gam too sâŋgonŋâ nalem nemarâwe. Oi zorik buŋâ. Âmaŋ sot hâkop saŋgonsaŋgon sot kut ŋâi ŋâi nâmbutŋaŋgât sâkurâpziŋaŋgât den, zo lum ândiwe. ");
INSERT INTO kpf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Zorat Parisaio sot Kembugât gurumin den zorat galem a, zen Yesu mâsikâm sâwe, “Arâpkâ wangât sâkurâpniŋ zeŋgât den kom bitziŋ mân saŋgon nalem nime?” ");
INSERT INTO kpf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sânetâ itâ sâm dâzâŋgoip, “Sarâ a zen. Zeŋgât op Propete Yesaiaŋâ Anutugât den itâ sâm kulemgoip, ‘A kâmut zi lâuziŋandik mâpâsenime. Umziŋandâ ko birânime. ");
INSERT INTO kpf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Oi den bonŋaŋgât hâuŋâ a ziiŋ den sâm kwâkâm aŋgâme. Zen lâuziŋandik mâpâsenime, nâ zorat nâŋga yen opmap.’ ");
INSERT INTO kpf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Zen Anutugât gurumin den zo birâne gei a denâk lum ândime. ");
INSERT INTO kpf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Zen ziŋâ nâŋgânâŋgâyân gâbâ den zo mem ko Kembugât gurumin den zo birâm mâtâp ŋâin âime. ");
INSERT INTO kpf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mose zâk Anutugât gurumin den itâ sâm dâzâŋgoip, ‘Gâ ibâ mamgâ sâtzik lum hurat kwatzikâban. Ŋâi zâk ibâ mamŋâ sâm bâliŋan kwatzikâbap, zo kune mumbap.’ ");
INSERT INTO kpf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Zen ko itâ sâme, ‘A ŋâi zâk ibâ mamŋâ itâ dâzâkobap. Kut zo zo zikâbam, zo Anutugât siŋgi sâm paan.’ ");
INSERT INTO kpf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yatâ dâzâkoi zen diŋâ mem kâtikŋan pam mam ibâŋ kore otzikâbâ sâi mâtâp pâke kwâkŋaŋgâme. ");
INSERT INTO kpf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yatâ op Anutugât den komŋâ sâkurâpziŋaŋgât den lum game. Oi zorik buŋâ kut ŋâi ŋâi nâmbutŋâ yatik upme.” ");
INSERT INTO kpf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuŋâ yatâ sâm a ambân dum minduziŋgâm itâ sâm dâzâŋgoip, “Nâ den dâzâŋgua zen aksik nâŋgâm kwâkânek. ");
INSERT INTO kpf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kut ŋâi ŋâi nine tep kâmboziŋan geimap, zorâŋ mân sumunkomap. Ka umziŋan gâbâ kopgâmap, zorâŋâ ko sumonkomap. ");
INSERT INTO kpf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","A kindapŋoot zorâŋ den zi nâŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yatâ sâmŋâ birâziŋgâm mirin zari arâpŋâ ziŋâ den sumbuŋâ topŋaŋgât mâsikâwe. ");
INSERT INTO kpf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mâsikânetâ sâip, “Zen yatik um nâŋgânâŋgâziŋâ buŋ ândime? Topŋâ itâ mân nâŋgâme? Kut ŋâi ŋâi tep kâmboziŋan geimap, zorâŋ dabân sumunkomap? ");
INSERT INTO kpf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Zorâŋ umziŋan mân âimap. Zo yen tep kâmboziŋan giari mem kubigi mâtâpŋan geimap.” Yesu zâk yatâ sâm nalemgât den sâm nâmbâsâpkoip. ");
INSERT INTO kpf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Oi den ŋâi itâ sâip, “Umziŋan gâbâ kopgâmap, zorâŋâ ko sumunkomap. ");
INSERT INTO kpf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","A umân gâbâ den itâ kopgamap. Nâŋgânâŋgâ bâliŋâ, âkŋâle nep, kâmbu. ");
INSERT INTO kpf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Kâmbam ku, ambân mem birâbirâŋ, sarâ, zâizâiŋâ, um kâtik, den bâliŋâ sot bâliŋâ top topŋâ. ");
INSERT INTO kpf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bâliŋâ sâlâpkuan, zorâŋâ a umziŋan gâbâ kopgâi sumunkomap.” ");
INSERT INTO kpf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu zâk kamân zo birâm âim Tiro Sidoŋ kamân zagât zo zeŋgâren takip. Takâm mirâ ŋâin zâim tik tap nâŋgâbat sâip. Oi dap yatâ tik tâpap? ");
INSERT INTO kpf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Taki zorenâk ambân ŋâi zâk siŋgi nâŋgip. Zâkkât bâratŋâ wâkeŋâ zâk sot ândeipkât ga Yesugât um topŋan pindiŋsâip. ");
INSERT INTO kpf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ambân zo Grik ambân Siro-Poinika gokŋâ. Zâk bâratŋaŋgât umŋan wâke zo molibapkât dukuip. ");
INSERT INTO kpf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Dukui Yesuŋâ itâ sâip, “Katep zeŋgât nalem wâu ziŋgindâ mân dâp upap. Katep zen nalem ninetâ ko buputŋâ zo mem wâu ziŋgânat.” ");
INSERT INTO kpf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Sâi ambânŋâ den itâ mâburem pindip, “Kembu, zo nâŋgan. Ka katep ziŋâ nalem nine gwapgwapŋâ gei wâu zen laŋdâ nime.” ");
INSERT INTO kpf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Oi Yesugoot itâ sâm dukuip, “Den zo yatâ sat, zorat op ko nâŋgâgigan. Âi eknan. Wâkeŋâ bâratkâ birâŋâŋgap.” ");
INSERT INTO kpf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Sâi ambân zo âimŋâ mirâŋan zâim egip. Wâkeŋâ bâratŋâ pam ari nâŋzam tâip. ");
INSERT INTO kpf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu zâk Tiro kamânân gâbâ puriksâm Sidoŋ kamân walâmŋâ kamân bâzagât zeŋgâren takâmŋâ Galilaia saruyân takip. ");
INSERT INTO kpf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A nâmbutŋâ, ziŋâ a ŋâi kopa, kindap bâpsâsâŋ diim gam Yesuŋâ weebapkât dukuwe. ");
INSERT INTO kpf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dukune nâŋgâm a zo diimŋâ ginŋan pâi zikŋik kiri Yesu zâk bikŋandâ kindapŋan weemŋâ bikŋan tâpkum nâmbâlamŋan weegip. ");
INSERT INTO kpf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yatâ opŋâ sumbemân egi zaari yaak memŋâ ziŋ denân sâip, “Epata (niiŋ denân ko, pâroŋsâ).” ");
INSERT INTO kpf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yatâ sâi a kindapŋâ pâroŋsâi nâmbâlam âburei den âlip sâip. ");
INSERT INTO kpf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Oi Yesu zâk den siŋgi zo mân sapsubigât dâzâŋgoip. Yatâ sâi zen ko kâtigem sâne laŋ kârâm arip. ");
INSERT INTO kpf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Zen âiwap pamŋâ itâ sâwe, “Kut ŋâi ŋâi tuugi âlip opmap. Kindapziŋ bâpâsâŋ kubikziŋgâmap. A dinziŋ buŋ den muyagem ziŋgâmap.” ");
INSERT INTO kpf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Narâk zoren a ambân kâmut patâ Yesugâren mindum nalem buŋ ândine Yesuŋâ arâpŋâ minduziŋgâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“A ambân kâmut zi sirâm karâmbut nen sot ândimŋâ tepziŋaŋgât mue, zorat umnâ nâŋgan. ");
INSERT INTO kpf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Zen nalem buŋâ sâŋgonzâŋgoindâ sâi mâtâbân âim nalemgât tâmbetagobe. Nâmbutŋâ zen kamân kârebân gâbâ gawe, zorat.” ");
INSERT INTO kpf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yatâ sâi arâpŋâ ziŋ itâ sâm dukuwe, “A mân ândiândiŋan ândiengât dap yatâ nalem muyagem ziŋgânat?” ");
INSERT INTO kpf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sâne itâ mâsikâziŋgip, “Zeŋgâren nalem dabutâ ziap?” Sâi ziŋâ sâwe, “Nâmburân zagât ziap.” ");
INSERT INTO kpf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dukune sâi a ambân mindumŋâ hânân ge tarâwe. Ge tatne Yesuŋâ nalem nâmburân zagât zo memŋâ sâiwap sâm sonpam namuŋ ziŋgip. Arâpŋâ ziŋgi mem kâsâpkum a ambân ziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Oi Yesu arâpŋâ zen saru zuuŋâ mâik bitugâk zagât mo karâmbut yatâ zo Yesu pindâne mem sâiwap sâm a ambân ziŋgâbigât arâpŋâ dâzâŋgomŋâ ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","A ambân kâmut, zen nalem nem âkon urâwe. Yesu arâpŋâ zen nalem buputŋâ tap arip, zo mindune irâ nâmburân zagât zoren gei piksâip. ");
INSERT INTO kpf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A ambân niwe, zo 4 tausen yatâ. Nine ko Yesuŋâ sâŋgonzâŋgom zâmbâri ba âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yesuŋâ a ambân sâŋgonzâŋgoi âine sâp kânok zikŋâ sot arâpŋâ waŋgâyân zâim Dalimanuta hânân âi takâwe. ");
INSERT INTO kpf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Zoren ândinetâ Parisaio a, zen Yesugâren gam zâk sot âraguwe. Ziŋâ itâ dukuwe, “Sumbemân gâbâ imbaŋâ ŋâi gei sen mârât kulem ŋâi kona iknâ” Zo mâsikâm topŋâ iknam sâwe. ");
INSERT INTO kpf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yatâ sâne Yesuŋâ yaak op mâsikâziŋgâm sâip, “Narâk ziren a zen wangât op top likuliku kulem âsagibapkât se? Perâkŋak dâzâŋgobâ. A zo zen kut zo mânâk tirâpzâŋgobat.” ");
INSERT INTO kpf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yatâ sâmŋâ birâziŋgâm arâpŋâ diiziŋgi waŋgâyân zâim saru nâmbutken âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Arâpŋâ zen nalemgât nelâmzâŋgoi âiwe. Nalem kânogâk waŋgâyân tâip. ");
INSERT INTO kpf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Oi Yesuŋâ arâpŋâ girem den itâ dâzâŋgoip, “Zen Parisaio sot Herode zeŋgât sii daŋgâtŋâ nalemziŋan mân pam om nimbi.” ");
INSERT INTO kpf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yesuŋâ yatâ sâm dâzâŋgoi ko kwakŋâ âragum sawe, “Nalemgât nelâmnâŋgoi birâm gen, zorat sap?” ");
INSERT INTO kpf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Den yatâ sâm tatne Yesugât kindapŋan giari nâŋgâm itâ sâm dâzâŋgoip, “Nalemgât nelâmzâŋgoip, zorat wangât âragum te? Zen den zorat topŋâ mân nâŋge? Umziŋâ mân pâroŋsap? ");
INSERT INTO kpf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Zen sinziŋandâ mân ikme? Kindapziŋandâ den mân nâŋgâme? Kut zo orâwan, zo mârum nelâmzâŋgoi mân nâŋge? ");
INSERT INTO kpf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nâ nalem bâtnâmbut kâsâpkum a 5 tausen ziŋgâwan. Oi buputŋâ zo sândune irâ dabutâ giarip? Mâsikâziŋgi sâwe, “Kiin zagât.” ");
INSERT INTO kpf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sâne sâip, “Nalem nâmburân zagât kâsâpkum a ambân 4 tausen ziŋgindâ buputŋâ sândune irâ dabutâ piksâip?” Mâsikâziŋgi dukum sâwe, “Nâmburân zagât.” ");
INSERT INTO kpf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Sâne dâzâŋgoip, “Wangât umziŋ tok mân pâroŋsap?” ");
INSERT INTO kpf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu sot arâpŋâ, zen âi Besaida kamânân takâne a sen ŋâtâtik ŋâi Yesugâren diim gam bikŋandâ weebapkât dukuwe. ");
INSERT INTO kpf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dukunetâ Yesuŋâ a siŋ bâpâsâŋ zo bikŋan gâsumŋâ kamân ginŋan âim siŋan tâpkum bikŋandâ kâukŋan pam itâ dukuip, “Gâ kut ŋâi ŋâi, zo eksat mo buŋâ?” ");
INSERT INTO kpf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yatâ mâsiki ekŋâ sâip, “Nâ a ziŋgitsandâ nakkât tobat yatâ op âim gam kinze.” ");
INSERT INTO kpf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dum zagâtŋâ Yesuŋâ siŋan weegi a zo siŋâ ânâŋgâri kârebân sot pâŋkânogân, zo ek kwâtâteip. ");
INSERT INTO kpf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Oi Yesuŋâ sâŋgongum sâip, “Gâ kamân patin mân zâim tigâk mirâgan zâi.” ");
INSERT INTO kpf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu sot arâpŋâ, zen Kaisarea kamân patâ a kutâ Pilipoŋâ sâi tuuwe, zorat kamân mâik mâik, zeŋgâren âiwe. Mâtâbân âim Yesuŋâ arâpŋâ mâsikâziŋgâm sâip, “A zen nâgât ŋâi sâme?” ");
INSERT INTO kpf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mâsikâziŋgi itâ sâm dukuwe, “Yohane too zaŋgonziŋgip sâme. Nâmbutŋandâ ko Elia sâme. Nâmbutŋâ zen Propete ŋâi sâme. Gâgât yatâ sâme.” ");
INSERT INTO kpf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sânetâ ko mâsikâziŋgip, “Ka ziiŋâ ko nâgât ŋâi sâme?” Sâi Peteroŋâ itâ dukuip, “Bâliŋan gâbâ mâkâniŋgâban. Gâ Kristo.” ");
INSERT INTO kpf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yatâ sâi ko a nâmbutŋâ laŋ mân dâzâŋgobigât sâm kâtigeip. ");
INSERT INTO kpf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Narâk zoren topkwapŋâ den itâ sâm muyageziŋgip, “A bonŋâ, nâ gâtâm sâknam nâŋgâbat. A patâ sot tirik namâ galem a patâ sot Anutugât gurumin den zorat galem a, ziŋâ gâsânom none momŋâ sirâm karâmbut tapŋâ zaatpat.” ");
INSERT INTO kpf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Den zo sâm kâkŋan pam dâzâŋgoip. Dâzâŋgoi ko Peteroŋâ diim kwâkâŋaŋgâm dukuip. ");
INSERT INTO kpf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Dukui Yesuŋâ puriksâm arâp ziŋgitŋâ Petero kwâkâŋaŋgâm sâip, “Sataŋ, gâ siriksâ. Gâ den sat, zo Anutugât den buŋâ. Zo a den.” ");
INSERT INTO kpf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesuŋâ sâi a ambân kâmut tarâwe, zen sot arâpŋâ gane itâ sâm dâzâŋgoip, “Zen nâ molininâ sâm um sâkziŋaŋgât den birâm poru nakziŋ lumŋâ nâgat mâtâp, zo lâŋbi. ");
INSERT INTO kpf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Zen ândiândiziŋ aŋgân kârâbi, zo ko gulipzâŋgobap. Zen nâgât opŋâ sot den siŋgi âlipkât op ândiândiziŋ birâbi, zo ko ândiândi bonŋâ muyagibi. ");
INSERT INTO kpf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Zen hângât kut kiŋ kiŋ mem ândiândiziŋ buŋ oi wan wan âlipŋâ zemziŋgâbap? ");
INSERT INTO kpf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Zen dap yatâ ândiândiziŋ suup mei târokwap ziŋgâbap? ");
INSERT INTO kpf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Zeŋgâren gâbâ ŋâi zâk a ambân ândi mâmanziŋ bâliŋâ zi, zeŋgât oserân ândim kwâimbânibap mo dinaŋgât nâŋgi aŋunŋoot upap, zâkkât a bonŋâ, nâŋâ Ibânaŋgât sumbem âsakŋâ sot kâwali a zen sot gamŋâ a zo yatik kwâimbâŋaŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuŋâ itâ sâm dâzâŋgoip, “Nâ perâkŋak dâzâŋgobâ. A kinze zi, nâmbutŋâ zen mân mune Anutu um topŋan ândiândiŋaŋgât narâk oi zorâŋâ imbaŋâŋoot âsagei ikpi.” ");
INSERT INTO kpf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yesu zâk sirâm nâmburân kânok ândim Petero sot Yakobo sot Yohane diiziŋgi bak kârebân zâiwe. Zen ziiŋik zoren tatne Yesugât holi tobatŋâ ŋâi âsageip. ");
INSERT INTO kpf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yesugât hâmbâŋâ zo kâu timan timan. Aŋâ mân tuutuuŋâ yatâ oip. ");
INSERT INTO kpf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Oi Mose sot Elia zorenâk muyagem gam Yesu sot den den urâwet. ");
INSERT INTO kpf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Oi Peteroŋâ Yesu den itâ sâm dukuip, “Patâniŋâ, mat ŋâi zi ândien. Zorat silep karâmbut tuunâ. Gâgât ŋâi, Mosegât ŋâi, Eliagât ŋâi.” ");
INSERT INTO kpf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yesu arâpŋâ zen keŋgât op sânâmziŋ sâmbui Peteroŋâ laŋ sâip. ");
INSERT INTO kpf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yatâ utnetâ sasa ŋâi gei kwâtepzâŋgoip. Sasa kâligen gâbâ den ŋâi itâ âsageip, “Zi nannâ. Umnâ zâkkâren kinzap. Ziŋâ diŋâ nâŋgâm biraŋbi.” ");
INSERT INTO kpf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Arâpŋâ zen den yatâ nâŋgâm zorâŋak ek kârune buŋ oi Yesu zikŋik kiri igâwe. ");
INSERT INTO kpf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bâkŋan gâbâ gem gam tatne Yesuŋâ arâpŋâ itâ sâm dâzâŋgoip, “Zen wan wan ikse, zo a ambân mân dâzâŋgone a bonŋâ, nâ mumuŋan gâbâ zaatpat.” ");
INSERT INTO kpf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yatâ sâm dâzâŋgoi arâpŋâ zen den zo nâŋgâm kwakŋâ itâ âraguwe, “Mumuŋan gâbâ zaatzaat sap, zorat top dap yatâ.?” Oi kut ŋâi igâwe, zorat siŋgi a ambân mân dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Zen Yesu itâ mâsikâm sâwe, “Kembugât gurumin den zorat galem a, zen wângât itâ sâme? Eliaŋâ Kristo kândom okŋaŋgâm takâbap.” ");
INSERT INTO kpf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yatâ sâm mâsikâne sâip, “Elia perâkŋak kândom gam kut ŋâi ŋâi ek kubikpapkât sâsâŋâ. Oi bet ko a bonŋâ nâ sâknam patâ nim kâbakŋenibi. Nâgât op Kembugât ekabân dapkât op yatâ kulemguwe? ");
INSERT INTO kpf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Eliagât itâ dâzâŋgobâ. Elia mârum ga ândei kut ŋâi ŋâi zo laŋ okŋaŋgâwe. Anutugât ekabân den kulemguwe, zo yatik okŋaŋgâwe.” ");
INSERT INTO kpf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu sot arâpŋâ karâmbut bâkŋan gâbâ gem arâpŋâ nâmbutŋâ zeŋgâren gam igâwe. A ambân doŋbep patâ haamzâŋgom kine Kembugât gurumin a zen Yesugât arâpŋâ sot âragum tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A ambân aksik, zen Yesu ekŋâ pârâkpam zâkkâren sârârâk kârâm âim sâtâre okŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesuŋâ mâsikâziŋgip, “Zen wan den sâm ârague?” ");
INSERT INTO kpf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sâi a zeŋgât oserân gâbâ a ŋâiŋâ itâ dukuip, “Patâ, wâke kopaŋâ nannaŋgât umŋan gei tâi gâgâren diim gaan. ");
INSERT INTO kpf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wâkeŋâ narâk dâp katep zo sâknam kwâkŋaŋgâm mem kâbakgwâbakŋe okŋaŋgi lepâuŋâ gei sâtŋâ zim kâtiŋsâi kiŋ bikŋâ kâtigem kinmap. Oi gâgât arâpkâ ziŋâ molibigât sa ko molinâ sâm kwakŋâ bire.” ");
INSERT INTO kpf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sâi Yesuŋâ arâp dâzâŋgoip, “Zen nâŋgâm pâlâtâŋziŋ buŋâ. Nâ narâk dabutâ zen sot tap âkom diiziŋgâm ândimâmbat? Katep zo nâgâren diim ganek.” ");
INSERT INTO kpf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sâi katep zâkkâren diim gane wâkeŋâ Yesu ekŋâ katep mem ŋâi ŋâi okŋaŋgi hânân gei kom purik op zei lepâuŋâ gem zeip. ");
INSERT INTO kpf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesuŋâ katepkât ibâŋâ mâsikâm sâip, “Narâk dabutin oip?” Sâi ko ibâŋandâ sâip, “Katepŋan gâbâ muyageip. ");
INSERT INTO kpf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wâkeŋâ katep tâmbetkubat sâm kârâp sot tooyân mem kâbakŋei geimap. Gâ imbaŋâgâ zemgigap oi ko nekât umgâ bâliŋ oi betnikŋan me.” ");
INSERT INTO kpf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yatâ sâm mâpâsei Yesuŋâ itâ dukuip, “Imbaŋaŋgât satkât sa nâŋgâ. Ŋâi zâk nâŋgâm pâlâtâŋ kwatnim ândibapŋâ kut ŋâi ŋâi sâi âlip âsageŋaŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yesu zâk yatâ sâm dukui zorâŋak katepkât ibâŋandâ sâip, “Nâ nâŋgâm pâlâtâŋ kwatgigan. Gâ gikak nâŋgâm pâlâtâŋnâ lotŋâ, zo mem kâtikŋan pa.” ");
INSERT INTO kpf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Oi a ambân doŋbep mindum ga kine Yesuŋâ ziŋgitŋâ wâke molim sâip, “Wâke kopa gâ dâgoga takâm âi. Oi dum mân puriksâm ga geiban.” ");
INSERT INTO kpf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yesuŋâ yatâ sâi wâkeŋâ den kâtik sâm katep lâŋ kâbakŋem ari katep hânân gei mumbam op zeip. A ambân zen zo ekŋâ katep muap sâwe. ");
INSERT INTO kpf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yatâ sânetâ Yesuŋâ katep bikŋan gâsum mem zaari kirip. ");
INSERT INTO kpf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu zâk mirin zari arâpŋâ zen mâsikâm sâwe, “Nen dapkât op wâke molim osien?” ");
INSERT INTO kpf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Sâne dâzâŋgoip, “Wâke yatâ zo ko ninâuŋâ ko âlipŋâ molimoliŋâ. Ka kut zo nâmbutŋandâ ko buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Oi hân zo birâm ba Galilaia hân walâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","A ambân, ziŋâ nâŋgâbegât tigâk âiwe. Âimŋâ Yesuŋâ arâpŋâ itâ sâm dâzâŋgom ândeip, “A bonŋâ, nâ a bitziŋan zaria gâsunim none momŋâ sirâm karâmbut tap ko zaatpat.” ");
INSERT INTO kpf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yatâ sâm dâzâŋgoi den zo nâŋgâm topŋaŋgât mâsikânam kwakŋâ birâwe. ");
INSERT INTO kpf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Oi Kapenaum kamân takâm mirâ ŋâin zâim Yesuŋâ arâpŋâ mâsikâziŋgâm sâip, “Mâtâbân gam wan den sâm ârague?” ");
INSERT INTO kpf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mâsikâziŋgi zen kwak tarâwe. Wangât, zen mâtâbân gam osetniŋan gâbâ ŋâiŋâ a sâtŋâ upap sâm âraguwe, zorat op kwak tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu zâk ge tapŋâ arâp kiin zagât minduziŋgâm itâ dâzâŋgom sâip, “Osetziŋan gâbâ a ŋâi a sâtŋâ upat sâm zeŋgât ombeziŋan ândim kore otziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yatâ sâmŋâ katep mâik ŋâi diim osetziŋan pam itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ŋâi zâk nâgât nâŋgâm katep mâik itâ zo galem okŋaŋgâbap, zo ko nâgât yatik kore otnibap. Kore otnibap, zo ko nâyâk buŋâ, sâŋgonnogip, zâk kore ârândâŋ okŋaŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohaneŋâ Yesu itâ dukuip, “Patâ, a ŋâi zâk gâgât kutkâ sâm wâke molei iksen. Oi zâk nen sot mân ândeipkât kwâkâŋaŋgen.” ");
INSERT INTO kpf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sâi Yesuŋâ itâ sâm dâzâŋgoip, “Mân kwâkâŋaŋgâbi. Ŋâi zâk nâgât korân nep ŋâi imbâŋâŋoot tuubap, zâkŋâ dap yatâ sâm bâliŋan kwatnibap? ");
INSERT INTO kpf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nepniŋ mân kârâm kândaŋbapŋâ buku op betniŋan mimbap. ");
INSERT INTO kpf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nâ perâkŋak dâzâŋgobâ. Ŋâi zâk zen nâgât siŋgi op ândie, zorat too aam ziŋgâbap, zo ko sâŋgân buŋ mân upap. Biken mimbap. ");
INSERT INTO kpf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ŋâi zâk katep mâik ŋâi nâ nâŋgâm pâlâtâŋ kwatnimap, zo dukui bâliŋ upap, zo ko a zo zâk tosâ yâmbâtŋâ mimbap. A yatâ zo zâk mârum kât sumun patâ gânduŋân saam saruyân pane giari sâi ko âlip opap. ");
INSERT INTO kpf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Bikandâ mâtâp bâliŋan diigim âibâ sâi bikâ mânâŋgât pâmban. Gâ bikâ hâlâlu ândim sim kârâbân geibatkât laŋ bikâ kârâm mânâŋgât ândim ândiândi kâtikŋan âiban. ");
INSERT INTO kpf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Sim kârâbân nane ziŋâ sunumziŋ nemâmbap sot kârâp zâk mân bâpsâbap. ");
INSERT INTO kpf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kiŋgandâ mâtâp bâliŋan diigim âibâ sâi kârâm mânâŋgât birâban. Gâ kiŋgâ hâlâlu ândim simân geibatkât laŋ kiŋgâ kârâm mânâŋgât pâmban. ");
INSERT INTO kpf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Simân nane ziŋ mân mumbap sot kârâp mân bâpsâbap. ");
INSERT INTO kpf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Siŋgandâ mâtâp bâliŋan diigim âibâ sâi sum lâmuŋban. Gâ siŋgâ âlip ândimŋâ simân geibatkât laŋ sen bâp ândim Anutu um topŋân bagiban. ");
INSERT INTO kpf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Sim kârâbân nane sot kârâp mân buŋ upabot. ");
INSERT INTO kpf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Zen sii mem nalem kwâkŋan pame, zo yatigâk Anutu zâk kârâp saŋgonziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sii zâk naamŋâ. Ka sii naamŋâ buŋ oi dap utne dum naamŋoot upap. Zen sii yatâ naamziŋoot ândibi. Zen um lumbeŋâ op ândibi.” ");
INSERT INTO kpf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu zâk zobâ zaat ba Yudaia hân walâm Yodaŋ too nâmbut âi takip. Taki a ambân kâmut patâŋâ minduwe. Oi op ândeip yatigâk den siŋgi âlip sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Oi Parisaio a nâmbutŋâ, zen Yesu denŋâ saanat sâm gam mâsikâm sâwe, “Kembugât den kâtik zo, dap ziap? Ambân birâbirâŋ, zo âlip orot mo mân orot?” ");
INSERT INTO kpf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mâsikâm sâne hâuŋâ itâ mâburem dâzâŋgoip, “Mose zâk zorat den dap dap sapsum ziŋgip?” ");
INSERT INTO kpf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yatâ sâi ziŋâ sâwe, “A ŋâi ambân birâbâ sâm ekap kulemgum pindâm molibap. Mose zâk yatâ sâip.” ");
INSERT INTO kpf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sâne Yesuŋâ itâ sâip, “Mose zâk um kâtikziŋaŋgât opŋâ gurumin den zo sâm kulemguip. ");
INSERT INTO kpf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ka topkwapŋâ Anutuŋâ a ambân muyagezikâmŋâ itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","‘Zorat ko a ŋâiŋâ ibâ mam birâzikâm ambinŋoorâk ândei zet um sâk kânok op ândibot.’ Den yatâ ziapkât zet zagât buŋâ. Kânok op ândiabot. ");
INSERT INTO kpf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Zorat sa nâŋgânek. Anutuŋâ mâpotzikip, zo aŋâ mân kâsâpzâkobi.” ");
INSERT INTO kpf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesuŋâ yatâ sâi ko zâk sot arâpŋâ, zen mirin zâine ko arâpŋâ zen zorarâk dum mâsikâwe. ");
INSERT INTO kpf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mâsikâne itâ dâzâŋgoip, “A ŋâiŋâ ambinŋâ birâmŋâ ŋâi mimbap, zâk târotârozikŋâ mânâŋgât tosâ patâ mimbap. ");
INSERT INTO kpf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ambân ŋâiŋâ apŋâ birâm a ŋâi mimbap, zâk yatik târotârozikŋâ mânâŋgât tosâ patâ mimbap.” ");
INSERT INTO kpf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A ambân, zen katep gakâziŋâ Yesugâren minziŋgâm gam Yesu bikŋandâ kâukziŋan gâsubapkât sâne Yesu arâpŋâ, ziŋ keŋgât minziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yatâ utnetâ Yesuŋâ ziŋgitŋâ umŋâ bâliŋ oi arâpŋâ itâ sâm dâzâŋgoip, “Zen birâne katep zen nâgâren ganek. Mâtâp mân dooŋgunek. A ambân katep zi itâ, zo zen Anutugât um topŋangât siŋgi sâsâŋâ. ");
INSERT INTO kpf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ŋâi zâk katep yatâ mân ândibap, zâk Anutugât kiŋ topŋan mân bagibap.” ");
INSERT INTO kpf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yatâ sâmŋâ minduziŋgi gane bikŋandâ kâukziŋan pam Anutuŋâ galem otziŋgâbapkât sâip. ");
INSERT INTO kpf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu zâk âibam oi a ŋâi sârârâk kârâm âi Yesugâren takâm um topŋan gei pindiŋsâm sâip, “Patâ âlipŋâ, nâ dap dap op ândiândi kâtikŋaŋgât siŋgi upat?” ");
INSERT INTO kpf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sâi Yesuŋâ itâ sâm dukuip, “Gâ wangât nâgât âlipŋâ sat? Âlip mariŋâ Anutu kânok. ");
INSERT INTO kpf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gurumin den zo nâŋgâmat. Zo itâ, ‘Kâmbam mân kumban. Ap ambin mân birâyaŋgâbabot. Gâ kâmbu mân upan. Bukugaŋgât sârân sâsâŋ mân sâban. Oi a ambân zeŋgât kut ŋâi ŋâi, zorat sarâ sâm mân mimban. Ibâ mamgâ sâtzik lum hurat kwatzikâban.’” ");
INSERT INTO kpf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Sâi a zorâŋâ itâ dukuip, “Gurumin den zo pisuk katepnan gâbâ lum gâwan. Ŋâi mân bira ziap.” ");
INSERT INTO kpf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sâi Yesuŋâ ekŋâ umŋâ zâkkâren tâi itâ dukuip, “Kânok birâna ziap, zo upan. Gâ âim sikumgâ mem a ziŋgâna kwâlâne kât zo mem a kanpitâ ziŋgâban. Kât zo ziŋgâmŋâ birâm ga nâ sot ândiban. Gâ yatâ opŋâ sumbemân sikumgoot upan.” ");
INSERT INTO kpf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesuŋâ yatâ sâm dukui a zo umŋâ bâliŋ oi nâŋgi yâmbârei arip. Zâk sikumŋâ patâ, zorat yatâ oip. ");
INSERT INTO kpf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ari ko Yesuŋâ puriksâm arâpŋâ ziŋgitŋâ itâ sâm dâzâŋgoip, “A sikumziŋ patâ, zen Anutugât um topŋan baginam kwakpi.” ");
INSERT INTO kpf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yesuŋâ yatâ sâi arâpŋâ zen pârâkpam imbaŋâziŋ buŋ oi dum dâzâŋgoip, “Katep gakânâ, Anutugât um topŋan bagibagiŋ, zo yâmbâtŋâ. ");
INSERT INTO kpf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bâu patâ kameleŋâ kuup mâtâpŋan bagibap, zo yâmbâtŋâ. Ka a sikum patâŋâ Anutugât um topŋan bagibagiŋ, zo yâmbâtŋâ walâwalâŋ.” ");
INSERT INTO kpf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yatâ sâi ko arâp ziŋâ imbaŋâziŋ buŋ oi sâwe, “Zo yatâ zorâŋ dap yatâ Anutugât um topŋan baginat?” ");
INSERT INTO kpf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Sâne Yesuŋâ ziŋgitŋâ sâip, Aŋâ kut ŋâi ŋâi utnam kwakme, zo Anutuŋâ mâtâp âlip muyagemap. Zâk mân kwakmap.” ");
INSERT INTO kpf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peteroŋâ den zo nâŋgâm Yesu itâ sâm dukuip, “Nâŋgat. Nen kut ŋâi ŋâiniŋâ kândâtkom gâ moligiwen.” ");
INSERT INTO kpf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Sâi Yesuŋâ sâip, “Nâ perâkŋak dâzâŋgobâ. Zeŋgâren gâbâ ŋâi zâk nâgât opŋâ mirâ kamân mo âtâ mun, mam ponâ, ibâ mam, murarâ mo hânŋâ birâbap, zâk kut ŋâi ŋâi doŋbep mimbap. Hânân zi mirâ sot âtâ mun gat, mam murarâp sot hân, zo sâknam kwâkŋan mimbap. Gâtâm narâk patin zâk ândiândi tâmbâŋâ mem ândibap.” Yesuŋâ zo sâmŋâ mâtakâm sâip, ");
INSERT INTO kpf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“Ka kândom a zeŋgâren gâbâ doŋbep ziŋâ bet upi. Bet a zeŋgâren gâbâ doŋbepŋâ kândom upi.” ");
INSERT INTO kpf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zen Yerusalem kamânân âinam zâim tarâwe. Yesuŋâ kândom ari arâpŋâ imbaŋâziŋ buŋ oi âine a nâmbutŋâ moliziŋgâweŋâ keŋgât urâwe. Oi Yesuŋâ arâpŋâ kiin zagât zo minduziŋgi tatne kut ŋâi ŋâi âsagibap, zorat den sâm muyageziŋgâm itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Nâŋge. Nen Yerusalem kamânân zâinamen. Oi zoren a bonŋâ nâ mumbatkât sâm Roma a kutâ zâkkâren nâbanbi. ");
INSERT INTO kpf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","A kutâ arâpziŋâ den top top dâtnom ko sinnan tâpkum inzut mem lapitnim none mubat. Oi sirâm karâmbut tap zaatpat.” ");
INSERT INTO kpf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Oi Zebedaiogât nanzatŋâ Yakobo sot Yohane, zet Yesugâren âimŋâ sâwet, “Net kut ŋâi ŋâigât sâitâ zo âlip nâŋgânikâban?” ");
INSERT INTO kpf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sâitâ mâsikâzikip, “Wan wan otzikâbâ sa ko sabot?” ");
INSERT INTO kpf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sâi zet itâ dukuwet, “Gâ nâŋgâna imbaŋâgaŋgât âsakŋâ muyagei âsangâ toren toren tâtat.” ");
INSERT INTO kpf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Sâitâ Yesuŋâ dâzâkoip, “Zet topŋaŋgât kârum yatâ sabot? Nâ too kâlakŋâ nimbat, zo âlip zet nimbabot? Oi too saŋgonibi, zo zet yâtik saŋgonzikâbi?” ");
INSERT INTO kpf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sâi zet sâwet, “Âlip utat.” Sâitâ Yesuŋâ dâzâkoip, “Too nimbat, zo zet nimbabot. Too saŋgonibi, zo yatik saŋgonzikâbi. ");
INSERT INTO kpf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ka âsannan tâtatŋâ, zorat den sâsâŋ, zo nâgâren mân ziap. Zorat siŋgi kwatziŋgâziŋgâŋâ, zo zen zoren tapi.” ");
INSERT INTO kpf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yatâ oitâ arâp nâmbutŋâ zen den zo nâŋgâm Yakobo sot Yohane kuk otzikâwe. ");
INSERT INTO kpf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Oi Yesuŋâ minduziŋgâmŋâ itâ sâm dâzâŋgoip, “Nâŋge, Hân a kutâ, zen zâizâiŋ op kore a gâsâzâŋgom ândime. Oi hânân a patâ, zen a kutâ otziŋgâme. ");
INSERT INTO kpf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Zeŋgâren ko yatâ mân âsagibap. Zengâren gâbâ a ŋâi a sâtŋâ upâ sâm bukurâp zeŋgât kore a op ândibap. ");
INSERT INTO kpf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Oi zeŋgâren gâbâ a ŋâi a kutâ upat sâm bukurâp zeŋgât kore mâman ândibap. ");
INSERT INTO kpf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yatigâk a bonŋâ, nâ ziŋâ kore otnibigât mân gewan. Ninak zeŋgât kore opŋâ a doŋbep zeŋgât suupziŋ memŋâ ândiândinâ buŋ upapkât gewan.” ");
INSERT INTO kpf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu sot arâpŋâ, zen Yeriko kamânân âi takâwe. Âi kamân zo walâm kamân ginŋan âine a siŋ bâpsâsâŋ ŋâi mâtâp ginŋan tâip, kutŋâ Batimaio, Timaiogât nanŋâ. A ambân, zen Yesu Nasarete gokŋâ, zâk gam ariap sâwe. ");
INSERT INTO kpf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sâne nâŋgâm den sâm sâip, “Yesu, gâ Dawidigât kiunŋâ, nâgât umgâ bâleik.” ");
INSERT INTO kpf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Den yatâ sâm tâi a nâmbutŋandâ hiriŋsâm tat sâm dukuwe. Dukune dinziŋâ birâm kambâŋâ sâip, “Yesu gâ Dawidigât kiunŋâ, nâgât umgâ bâleik.” ");
INSERT INTO kpf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yatâ sâi Yesuŋâ nâŋgâm mâtâbân kinŋâ sâip, “Sâne gâik.” Sâi a ziŋâ sen ŋâtâtik zo konsâm sâwe, “Umgâ bâbâlaŋ oi zaat ga. Patâŋâ goonsap.” ");
INSERT INTO kpf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Oi sen ŋâtâtikŋâ den zo nâŋgâm hâmbâŋâ birâm pam oksâm zaatŋâ ba Yesugâren arip. ");
INSERT INTO kpf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Âi taki Yesuŋâ itâ sâm mâsikip, “Dap otgibatkât sat?” Sâi a sen ŋâtâtikŋâ sâip, “Patânâ, sinnâ âlip upapkât otnigap.” ");
INSERT INTO kpf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sâi Yesuŋâ itâ dukuip, “Gâ âinan. Nâŋgâm pâlâtâŋ kwatnigat, zorat âlipkâ uat.” Sâi zorenâk siŋâ ekŋâ Yesu molim arip. ");
INSERT INTO kpf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu sot arâpŋâ, zen âimŋâ Yerusalem kamân mâte opŋâ Oliwa bâkŋan takâwe. Bakŋâ topŋan kamân zagât Betepage sot Betania tarâwet. Zoren takâm Yesuŋâ a zagât sâŋgonzâkom sâip, ");
INSERT INTO kpf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Kamân ândi, zoren arit. Âi takâmŋâ doŋgi sigan ŋâi tâgân kinzap, zo muyageit. Doŋgi zo a kwâkŋan mân tâtatŋâ, zo irakŋâ. Zo muyagem olaŋ diim gâit. ");
INSERT INTO kpf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Olaŋitâ a ŋâiŋâ wangât olaŋsabot sâm mâsikâziki itâ sâbabot, ‘Kembuniŋaŋgâren nep muyagiap. Oi kek pâi âburem gâbap.’” ");
INSERT INTO kpf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yatâ sâm dâzâkoi a zagât zet âim mirâ ŋâi sâŋgânŋan doŋgi sigan ŋâi saane kiri olaŋâwet. ");
INSERT INTO kpf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Olaŋitâ a nâmbutŋandâ zikit mâsikâzikâm sâwe, “Wangât olaŋsabot?” ");
INSERT INTO kpf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sâne Yesuŋâ den sâip, zo dâzâŋgoitâ nâŋgâne âkip. ");
INSERT INTO kpf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Doŋgi zo Yesugâren diim aritâ arâpŋâ ziŋâ hâmbâziŋâ doŋgi kwâkŋan pane Yesuŋâ kwâkŋan zâi tap arip. ");
INSERT INTO kpf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","A doŋbep patâ ziŋâ hâmbâ motziŋ mâtâbân lâŋgat âiwe. Oi nâmbutŋandâ gâlaŋgât sot lâkom ilumŋâ mânâŋgâtŋâ mâtâbân pam âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A ambân kâmut patâ, ziŋâ Yesu mem oset kwâkŋaŋgâwe. Ziŋâ itâ sâm pam diiwe, “Oe, Kembugât sâtkât gam niŋgap, zâk sâm âlipŋan kwâkŋaŋganâ. ");
INSERT INTO kpf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Sâkuniŋâ Dawidiŋâ kembu otziŋgâm galem otziŋgip, zo yatâ otniŋgâbap. Zorat sâtâre utnâ. Oe, Anutu u sumbemân.” ");
INSERT INTO kpf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yatâ op âine Yesuŋâ Yerusalem kamân takâm Anutugât tirik namin zarip. Zâimŋâ kut ŋâi ŋâi ek naŋgi mirâsiŋ geibam oi gem arâpŋâ diiziŋgi Betania kamânân âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Haŋsâi Betania kamânân gâbâ gemŋâ Yesu tepŋaŋgât oip. ");
INSERT INTO kpf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Oi kârebân siŋandâ egi wakum nak ŋâi kiri egip. Ekŋâ bonŋâ kinzap sâm âi kâruip. Bonŋâ orot narâk buŋâ, zorat ilumŋik kirip. ");
INSERT INTO kpf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yatâ ekŋâ nak zo itâ dukuip, “Gâgâren gâbâ bonŋâ niniŋâ zo a ŋâiŋâ mânâk nimbap.” Den yatâ sâi arâpŋâ nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Zen Yerusalem kamânân zâiwe. Oi Yesuŋâ tirik namin zâim a kut ŋâi ŋâi aŋgâgwaŋgâ op kine moliziŋgip. A nâmbutŋâ, zen Roma zeŋgât kât sot Yuda zeŋgât kât, zo hâukwap aŋgâgwaŋgâ op kirâwe. Kât pâpanŋâ zo kom giligâlak mem kembâ aŋgâgwaŋgâ urâwe, zeŋgât tâtatŋâ zo kom kâbakŋei gei zeip. ");
INSERT INTO kpf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Oi tirik namin kut ŋâi ŋâi mân mem âim gabigât sâip. ");
INSERT INTO kpf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Itâ sâm dâzâŋgoip, “Anutugât den kulem ŋâi itâ ziap, ‘Namânâ zi a eluŋ zeŋgât ninâu namâ upap.’ Ziŋâ ko utne kâmbu a zeŋgât kât ki yatâ uap.” ");
INSERT INTO kpf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","A ambân zen Yesugât diŋâ nâŋgâne imbaŋâ oip, zorat Parisaio sot Kembugât gurumin den sâsâ a kândâtzâŋgowe. Yatâ utne a sâtŋâ ziŋ Yesu dap op koindâ moik sâm kimuŋâ miwe. ");
INSERT INTO kpf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ŋâtiksâi Yesu sot arâpŋâ, zen kamân patâ zo birâm ba âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mirâ haŋsâi wakum nak kiribân âi igâwe. Nak zo mom kirip. ");
INSERT INTO kpf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peteroŋâ ekŋâ Yesu den sâip, zo nâŋgâm itâ dukuip, “Patâ, eknan. Wakum nak den dukuin, zo mom kinzap.” Sâi Yesuŋâ itâ dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","“Nâ perâkŋak dâzâŋgobâ. Zen Anutu nâŋgâm pâlâtâŋ kwâkŋaŋgâm ândibi. Zen um zagât mân opŋâ nâŋgâm pâlâtaŋziŋ bonŋâ op ândibi. Zen yatâ op ândim bakŋâ ândi dukubi, ");
INSERT INTO kpf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","‘Bakŋâ, gâ âbâŋgum saruin gei.’ Yatâ sâne dinziŋâ lubap. ");
INSERT INTO kpf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Zorat ko itâ sa nâŋgânek. Zen wan mo wangât nâŋgâm ninâu sâm, zo mârum mien sâm nâŋgâne âlip muyageziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Zen ninâu sânâ sâm a zeŋgât tosa mem ândie oi ko birâbi. Yatâ utne ko Ibâziŋâ sumbemân ândiap, zâkŋâ yatik tosaziŋâ birâbap. ");
INSERT INTO kpf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Zen a zeŋgât tosaziŋâ mân birâne ko sumbem Ibâziŋaŋgoot zeŋgât tosâziŋâ mân birbap.” ");
INSERT INTO kpf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu sot arâpŋâ, zen dum Yerusalem kamânân gawe. Puriksâm gamŋâ Yesuŋâ tirik namâ umŋan âim gam kiri ko a sâtŋâ sot Kembugât gurumin den zorat galem a sot patârâpziŋâ, zen Yesugâren gam mâsikâm itâ sâwe, ");
INSERT INTO kpf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Gâ ziren kut ŋâi ŋâi opmat, zo ŋâigât sâtkât opmat?” ");
INSERT INTO kpf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sânetâ itâ mâburem dâzâŋgoip, “Nâ den kânok mâsikâziŋga dâtnone ko nâŋgoot ŋâigât sâtkât opman, zo dâzâŋgobat. ");
INSERT INTO kpf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohane too saŋgon nep tuugip, zo ŋâigât sâtkât nep tuugip. Anutugât sâtkât mo agât sâtkât? Zen sâne nâŋgâbâ. ");
INSERT INTO kpf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mâsikâziŋgi zen dap sânâ sâm kwakŋâ ziiŋik itâ sâm âraguwe, “Nen Anutugât sâtkât sâindâ sâbap, ‘Wangât diŋâ mân luuwe?’ ");
INSERT INTO kpf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Agât sâtkât nep tuugip, yatâ sâindâ sâi ko a ziŋ nâŋgobe.” Wangât, zen a ambân zeŋgât keŋgât urâwe, zorat. A ambân zen aksik Yohanegât nâŋgâne Propete oip. ");
INSERT INTO kpf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Zorat ko ziŋâ Yesu itâ sâm dukuwe, “Nen mân nâŋgen.” Sâne Yesuŋâ itâ dâzâŋgoip, “Den zo dâtnoge sâi ko nâŋgoot ŋâigât sâtkât opman, zo dâzâŋgobam. Ka zen mân se, zorat nâ mân dâzâŋgobat.” ");
INSERT INTO kpf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuŋâ topkwapŋâ den sumbuŋâ ŋâi itâ sâm dâzâŋgoip, “A ŋâiŋâ waiŋ tâk nep kârâm kâmirip. Kârâm kâmit dâmân pâit tuugip. Tuumŋâ tâk keetŋâ mândâlibapkât âmaŋ patâ tuum galem a zeŋgât mirâ tuumŋâ nep zo bitziŋan pam hân ŋâin arip. ");
INSERT INTO kpf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Âi ândei bonŋâ orotŋâ narâk oi kore a ŋâi sâŋgongoi bonŋâ nâmbutŋâ mimbapkât arip. ");
INSERT INTO kpf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","A zo âi taki galem a ziŋâ gâsum kom moline bet bâsaŋ âburem arip. ");
INSERT INTO kpf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ari ko kâlam mariŋâ zâk kore a ŋâi sâŋgongoi ari galem a ziŋâ kâukŋâ kunzit mem ŋâi ŋâi okŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kâlam mariŋâ dum kore a ŋâi sâŋgongoi ari kuwe. Kunetâ mariŋandâ yatigâk a doŋbep sâŋgonzâŋgoi âinetâ galem a ziŋ kâmbam mamuŋ zâŋgowe. Oi nâmbutŋâ sâbâ sâbâ zâŋgowe. Ka nâmbutŋâ ko sâseŋgât zâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Zâŋgonetâ nanŋâ kânok ândeip, zo zikŋâ nanŋâ. Umŋâ zâkkâren kirip. Zâk bet itâ sâm sâŋgonguip, ‘Galem a ziŋ hurat kwâkŋaŋgâm mân kumbi.’ ");
INSERT INTO kpf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Sâm sâŋgongoi ari galem a zen nanŋâ ekŋâ âragum sâwe, ‘A zirâŋâ gâtâm kâlam mariŋâ upap, zorat koindâ kâlam zi niiŋâ upap.’ ");
INSERT INTO kpf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yatâ sâm gâsum kune moi kâmbarâŋâ kâlam âkŋan pane zeip. ");
INSERT INTO kpf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Oi kâlam mariŋâ zâk dap upap? Zâk gamŋâ galem a zâŋgom tâmbet otziŋgâm kâlamân galem a uŋakŋâ zâmbanbap. ");
INSERT INTO kpf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kembugât ekabân den ŋâi itâ ziap, zo sâlâpkum nâŋgâme? ‘Mirâ tuutuuŋ a, zen kunkun ŋâi ek âkon op birâwe. Kembuŋâ kunkun zorâŋâ mem namin kwânâŋgip. ");
INSERT INTO kpf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kembuŋâ sâi yatâ âsageip. Niŋâ egindâ mârâtŋâ ŋâi uap.’” ");
INSERT INTO kpf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesuŋâ den yatâ sâm dâzâŋgoi ko patâziŋâ gâsum tâk namin pânat sâm nâŋgâmŋâ a ambân zeŋgât keŋgât urâwe. A patâ, zen itâ nâŋgâm kwâkâwe. Den zo nengât sap sâwe. Oi gâsunam kwakŋâ birâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yuda a sâtŋâ, zen Parisaio a sot Herode arâp nâmbutŋâ Yesugât diŋâ saabigât sâŋgonzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sâŋgonzâŋgone Yesugâren gam itâ sâm dukuwe, “Patâ, nen gâgât topkâ nâŋgâmen. Gâ den sarâ mân sâm bonŋigâk sâmat. Gâ den ŋâi mân sâna gâŋgoŋemap. Gâ a zâizâiŋ gigiŋ aksik Anutugât mâtâp âlip dâtnâŋgom kubikmat. Den ŋâi sâindâ nâŋgâ. Roma a kutâ patâ Sisa kât pindânat, zo orotŋâ mo mân orotŋâ? ");
INSERT INTO kpf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kât pindâpindâŋ mo mân pindâpindâŋ, zorat dâtnâŋgo.” Yatâ sâne Yesuŋâ sarâziŋaŋgât topŋâ ek nâŋgâm dâzâŋgoip, “Zen wangât denŋâ saanige? Kât ŋâi mem nine ikpâ.” ");
INSERT INTO kpf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Sâi ko kât ŋâi mem pindânetâ mâsikâziŋgâm sâip, “Holi tobat zo ŋâigât?” Sâi ziŋâ sâwe, “A kutâ Sisagât.” ");
INSERT INTO kpf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sâne itâ sâm dâzâŋgoip, “Sisagât siŋgi, zo Sisa pindâbi. Ka Anutugât siŋgi, zo Anutu pindâbi.” Yatâ sâm dâzâŋgoi zen diŋâ mâpâsiwe. ");
INSERT INTO kpf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukaio a nâmbutŋâ Yesugâren gawe. A zo ziŋâ mom zaatzaat zo mân ziap sâmarâwe. Ziŋâ gam sâwe. ");
INSERT INTO kpf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Patâ, Moseŋâ itâ sâm kulemguip, “A ŋâi, zâk ambân memŋâ katep mân muyagem moi ko munŋandâ malâŋâ mem âtâŋaŋgât siŋgi katep mimbap.” ");
INSERT INTO kpf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oi zorat sâindâ nâŋgâ. Âtâ mun nâmburân zagât ândiwe. Oi âtâziŋâ kunŋâ ambân memŋâ murarâŋâ buŋ ândim moip. ");
INSERT INTO kpf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Moi ko munŋandâ malâŋâ zo mem yatigâk murarâ buŋ ândim moip. ");
INSERT INTO kpf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Moi munŋâ ŋâiŋâ malâ zorigâk mem moip. Yatigâk âtâ mun zo nâmburân zagât zen ambân zorigâk mem murarâziŋ buŋ mom naŋgâwe. Oi bet malâziŋâ zo moip. ");
INSERT INTO kpf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Oi a nâmburân zagât zen aksik patâ ambân zo miwe, zorat gâtâm narâk patin zaatnetâ ambân zâk ŋâigât upap?” ");
INSERT INTO kpf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Zen den nâŋgâm gulipkume. Anutugât den sot Anutugât imbaŋâ mân nâŋgâme. ");
INSERT INTO kpf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gâtâm mumuŋan gâbâ zaatŋâ a ambân dum mân miaŋgâbi. Zen sumbem a yatâ op ândibi. ");
INSERT INTO kpf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Momŋâ zaatzaatŋaŋgât sâme, zorat dâzâŋgobâ. Mosegât ekabân den siŋgi zi sâlâpkume mo buŋâ? Mose zâk nagân kârâp bâlam ekŋâ ari Anutuŋâ den itâ sâm dukuip, ‘Nâ Abaram, Isaka sot Yakobo, zeŋgât Anutu.’ ");
INSERT INTO kpf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Zorat sa nâŋgânek Anutu zâk a buŋ urâwe, zeŋgât Anutu buŋâ. Gwâlâ ândie, zeŋgât Anutu. Zorat Abaram, Isaka sot Yakobo, zen mân buŋ urâwe. Anutu sot gwâlâ ândie. Zen ko den nâŋgâm gulipkume.” ");
INSERT INTO kpf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yesu sot Sadukaio a den âragune ko Kembugât gurumin den galem a ŋâiŋâ Yesugât den zo nâŋgi âlip oi itâ sâm mâsikip, “Kembugât gurumin den ikâ zorâŋâ ko kâukŋâ uap?” ");
INSERT INTO kpf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yatâ sâm mâsiki Yesuŋâ sâip, “Kembugât gurumin den patâ itâ ziap, ‘Isirae a ambân, zen nâŋgânek. Anutu Kembuniŋâ kembu kânok. ");
INSERT INTO kpf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Zorat um dâpkâ sot nâŋgânâŋgâgâ sot imbaŋâgâ, zo Kembu Anutu zo hâlâluyâk pindâna zimbap.’ ");
INSERT INTO kpf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Den zorat torenŋâ itâ ziap, ‘Gâ gikaŋgât otgimap, yatigâk a torenŋâ zeŋgât otgibap.’ Anutugât gurumin den zagât zi patâ uabot. Gurumin den ŋâi mân ziap.” ");
INSERT INTO kpf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yatâ sâi Kembugât gurumin den galem aŋâ den zorik mâburem Yesu dukuip, “Patâ, gâ den zo sâna nâŋga âlip uap. Anutu, zâk kembu kânok. Oi ŋâi mân taap. ");
INSERT INTO kpf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Oi zâk kânok nâŋgânâŋgâ sot imbaŋâ hâlâlu pindânat. Oi gikaŋgât otgimap, yatik a toren zeŋgât otgibap. Den zagât zirâŋâ kut zo zorâŋ Kembu pindâpindâŋ zo wâlap.” ");
INSERT INTO kpf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","A zo yatâ sâi Yesuŋâ nâŋgi âlip oi itâ sâm dukuip, “Gâ Anutugât um topŋan gaat.” Sâi narâk zoren gâbâ Yesu den mâsikânam nâŋgâne yâmbârei keŋgât op birâwe. ");
INSERT INTO kpf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu zâk tirik namin zâim a den siŋgi âlip dâzâŋgom itâ sâm mâsikâziŋgip, “Kembugât gurumin den zorat galem a, zen itâ sâme, ‘Kristo, zâk Dawidigât kiunŋâ.’ ");
INSERT INTO kpf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dapkat sâme? Tirik Kaapumŋâ Dawidi nâŋgânâŋgâ pindi itâ sâip, ‘Kembuŋâ nâgât kembu itâ sâm dukuip, “Gâ âsannâ bongen ge tâtna kâsarâpkâ minduziŋga kiŋgaŋgât kombâŋ upi.” ’ ");
INSERT INTO kpf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawidiŋâ Kristogât kembunâ sâipŋâ dap op Kristo zâk Dawidigât kiunŋâ uap?” Yesu zâk den yatâ sâm dâzâŋgoi a kâmut patâ zen nâŋgâm âkŋâle urâwe. ");
INSERT INTO kpf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuŋâ den yatâ sâmŋâ den ŋâi itâ târokwap dâzâŋgom sâip, “Zen Kembugât gurumin a zeŋgât holi yatâ mân upi. Zen hâmbâ kârep mem ândim kamân sombemân âim a muyageziŋgâne sâm âlip kwatziŋgâbigât umziŋ kinmap. ");
INSERT INTO kpf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Oi zen mâpâmâpâse namin sot sii nalem minduminduyân a sâtŋâ tâtarân tâtnat sâm nâŋgâme. ");
INSERT INTO kpf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","A yatâ zorâŋ ambân malâ zeŋgât mirâ kut ŋâi ŋâi laŋ betziŋan mime. Zen sarâ sâm ninâu kârep sâm tosaziŋ kwârakume. A zo zen gâtâm tosaziŋaŋgât hauŋâ yâmbâtŋâ mimbi.” ");
INSERT INTO kpf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu zâk tirik namin tap ek tâi a ziŋâ ga Kembugât siŋgi kât pane giarip. Oi ko sikum a doŋbep zen ga kât imbaŋâ pane giarip. ");
INSERT INTO kpf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Oi ambân malâ kanpitâ ŋâiŋâ gam kât kuriŋâ mâik zagât pâi giarip. ");
INSERT INTO kpf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu zâk zo ekŋâ arâpŋâ minduziŋgâm itâ sâm dâzâŋgoip, “Nâ perâkŋak dâzâŋgobâ. Ambân malâ kanpitâ zâk kât paap, zirâŋâ a torenŋâ walâziŋgap. ");
INSERT INTO kpf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","A nâmbutŋâ zen kât patâ tâi torenŋik pe. Ka ambân kanpitâ, zâk zemŋaŋgip, zo aksik paap. Yenâk ândiap.” ");
INSERT INTO kpf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu zâk tirik namin gâbâ gem tâi arâpŋâ zeŋgâren gâbâ a ŋâiŋâ itâ dukuip, “Patâ, eknan. Namâ tuutuuŋâ zo kât neuleŋâ âlipŋâ hikpârâkŋootŋâ tuuwe.” ");
INSERT INTO kpf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sâi Yesuŋâ itâ sâm dukuip, “Namâ patâ tâi eksat? Gâtâm kâsaziŋ gam kom kândaŋne giligâlaksâm naŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bet Yesu sot arâpŋâ, zen Oliwa bâkŋan zâi tap too nâmbutken tirik namâ zo ikne ândi tâip. Zoren tapŋâ Petero sot Yakobo, Yohane sot Andrea, ziŋâ Yesu mâsikâm sâwe, ");
INSERT INTO kpf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Dâtnâŋgo. Kut ŋâi sat, zo narâk ikâ zoren âsagibap? Narâk zo mâte oi wesâk dap dap yatâ muyagibap?” ");
INSERT INTO kpf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesuŋâ itâ topkwap dâzâŋgoip, “Um gulip kwâtziŋgâbegât galem oraŋgâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","A doŋbep muyagem gam sâbi, ‘Nâ Kristo. A bâliŋan gâbâ mâkâziŋgâbapkât sâsâŋ, zo nâ.’ Yatâ sâm a doŋbep mem um gulip kwatziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Oi zen kâmbam goorân mo kârebân âsagei nâŋgâm umziŋ mân keŋgât upap. Kâmbam zo yatâ âsagibapkât sâsâŋâ. Yatâ muyagem zei narâk kek mân âkâbap. ");
INSERT INTO kpf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Hânŋâ hânŋâ a kâmutŋâ kamutŋâ, zen kâsa opŋâ agom âibi. Oi hân ŋâin ŋâin wâriŋ mimbap. Oi pu patâ âsageziŋgâbap. Kut ŋâi ŋâi âsagibap, zo sâknam topkwâkwatŋâ. ");
INSERT INTO kpf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ka zen ko galem oraŋgâm ândibi. Zen denân zâmbanbi sot mâpâmâpâse namin lapitziŋgâbi. Oi zorik buŋâ a patâ sot a kutâ zeŋgâren diiziŋgâm âine mâteziŋan kinŋâ nâgât topnâ sapsum ziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Oi narâk kândom den siŋgi âlip hân dâp a zeŋgâren âibapkât sâsâŋâ. Bet ko hângât narâkŋâ âkâbap. ");
INSERT INTO kpf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Oi a kutâ zeŋgâren diiziŋgâm âine den dap sânat sâm mân naŋgâm kwâkâ upi. Narâk zoren Tirik Kaapumŋâ umziŋan den pâmbap, zorik sâbi. Yatâ opŋâ den sânetâ zeŋgât den mân upap. Zo Kaapumgât den upap. ");
INSERT INTO kpf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Oi a ziŋ itâ zo upi. Âtâŋâ ŋâiŋâ sâi munŋâ gâsum kumbi. Ibâ ŋâiŋâ sâi nanŋâ gâsum kumbi. Murarâpziŋ zen ibâ mam kâsa minziŋgâm sâne zâŋgobi. ");
INSERT INTO kpf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Zen nâgât kut siŋginaŋgât op a ambân ziŋâ um kâlak nâŋgâziŋgâbi. Ka ŋâi zâk singi âlip mem kâtigem ândei narâk âki ko sumbem kamânân bagibap. ");
INSERT INTO kpf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Gâtâm tâmbet tâmbet kâukŋâ mân kinbap sâsâŋan, zoren kinbap. (Den zo mulunâk sâlâpkum nâŋgâbi.) Yatâ âsagei ekŋâ Yudaia hânân ândibiŋâ barâ kâtikŋan sârârâk kârâm âibi. ");
INSERT INTO kpf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ŋâi zâk sombemân tâpapŋâ sikum mimbam mirâ umŋan mân zâibap. ");
INSERT INTO kpf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ŋâi zâk nebân mo hibukŋan ândibapŋâ hâmbâ mimbam kamânân man âibap. ");
INSERT INTO kpf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Yei, ambân kâmborâ sot katep namân gokŋâ, narâk zoren zen dap upi? ");
INSERT INTO kpf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Zen Kembugâren ninâu sâne nâŋgi âiâiziŋâ zo map narâkŋan mân muyagibap. ");
INSERT INTO kpf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Narâk zoren sâknam patâ âsagibap. Zo yatik Anutuŋâ a muyageibân gâbâ mân âsageip. Oi dum mân muyagibap. ");
INSERT INTO kpf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Oi Kembu zâk narâk zo mân mânâŋgâri sâi a ambân aksik buŋ upe. Ka Kembuŋâ a ambârâpŋâ zeŋgât op ko narâk mem pâŋkânok pâmbap. ");
INSERT INTO kpf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","A ziŋâ Kristo ziren âsagiap, ândiren âsagiap, den yatâ sânetâ mân nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Narâk zoren a sarâŋâ âsagem nâ Kristo sâbi. Oi Propete sarâŋâ âsagem kulem sen mârât muyaginetâ a um gulip kwatziŋgabi. Anutuŋâ gâsum sâlâpzâŋgoip, zo um gulip kwatziŋgânam osibi. ");
INSERT INTO kpf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kut ŋâi ŋâi zo mân âsagei kânŋan dâzâŋguangât umziŋ galem op ândibi. ");
INSERT INTO kpf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Sâknam patâ narâkŋâ zo âki mirâsiŋ sumunkumbap. Oi kâin âsakŋâ buŋ upap. ");
INSERT INTO kpf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sâŋgelak âkâm hânân gibi. Oi Anutuŋâ sumbem mâŋgei olayaŋgâm imbaŋâ buŋ upap. ");
INSERT INTO kpf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Oi a bonŋâ, nâ âsakŋâ imbaŋânoot unumunum kwâkŋan ga nikpi. ");
INSERT INTO kpf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Oi sumbem a sâŋgonzâŋgua zen a ambân kâmut gakânâ hân ginŋâ toren toren gâbâreziŋgânetâ mindubi. ");
INSERT INTO kpf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nak dâgap zorat top nâŋgâbi. Zâk iinŋâ burutuksâi maa narâk upâmap sâme. ");
INSERT INTO kpf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Oi yatigâk zen den dâzâŋguan, kut ŋâi ŋâi zo muyagem naŋgi itâ nâŋgâbi, ‘A bonŋâ mâte otniŋgâbâmap. Zâk mâtâbân ga kinzap.’ ");
INSERT INTO kpf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nâ perâkŋak dâzâŋgobâ. A ambân ziren ândie, zen ândinetâ kut ŋâi ŋâi zo âsagem kwâkâbap. ");
INSERT INTO kpf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sumbem sot hân, zet buŋ upabot. Nâgât den ko mân buŋ upap. ");
INSERT INTO kpf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","A bonŋâ nâ gâbat, zorat narâkŋâ zen mân nâŋge. Sumbem a zen yatigâk mân nâŋge. Ninaŋgoot mân nâŋgan. Ibânâ Anutu, zâk zikŋik nâŋgap. ");
INSERT INTO kpf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Zen narâk mân nâŋgegât galem oraŋgâm ninâu sâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","A ŋâiŋâ mirâ sot nepŋâ birâm kamân kârebân âibam kore a gakâŋâ nep sâm mânâŋgât ziŋgâbap. Kut ŋâi ŋâi galem upigât dâzâŋgobap. Kore a ŋâiŋâ mirâ mâtâbân tapŋâ mirâ mariŋâ gâbapkât galem ek tâpapkât dukubap. ");
INSERT INTO kpf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Zeŋgoot yatik galem oraŋgâm ândibi. Mirâ mariŋâ, zâk ŋâtiksâi mo ŋâtik tânâmŋan mo haŋsâsâgât, mo haŋgât gâbap, zo mân nâŋge, gât ko san, zo op ândibi. ");
INSERT INTO kpf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","37","Zen uman zine ga muyageziŋgâbatkât zen sot buku toren itâ dâzâŋguan. Um wâgânâk ândibi.” ");
INSERT INTO kpf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yuda zeŋgât kendon patâ Pasowa sot sii nalem om niniŋâ narâkŋâ sirâm zagât ombeŋan oi tirik namâ galem a zeŋgât patârâpziŋâ sot Kembugât gurumin a, zen Yesu tik gâsum kunam den sâm kâtâŋ urâwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Oi itâ sâwe, “Kendonân kâmbam laŋ muyagebapkât kegâk gâsunat.” ");
INSERT INTO kpf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betania kamânân sâk bâlâ a ŋâi ândeip, kutŋâ Simoŋ. Oi Yesuŋâ zâkkât mirin zâi tâip. Zoren nalem nem tâi ambân ŋâiŋâ too hitomŋoot âlipŋâ, zo sâŋgânŋâ patâ beloŋoot mem zâim karâpŋâ kunzit Yesu kâukŋan lokei giarip. ");
INSERT INTO kpf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yatâ oi nâmbutŋâ tarâwe, ziŋâ itâ nâŋgâm um kâlak nâŋgâwe, “Wangât tâmbetkuap? ");
INSERT INTO kpf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Zo sâŋgân patâ. Too hitomŋoot zorâŋâ sâŋgân mem a kanpitâ ziŋgi dâp opap.” Yatâ sâmŋâ ambân zo den kârâpŋoot okŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sâne Yesuŋâ nâŋgâm itâ sâm dâzâŋgoip, “Zen ambân den mân dukunek. Zen wangât sâm siŋan giname? Ambân zorâŋâ âlip otnigap. ");
INSERT INTO kpf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A ambân kanpitâ, zen narâk dâp zen sot ândine galem ot ziŋgânâ sâm âlip otziŋgâbi. Nâ ko zeŋgâren narâk kârep mân ândibat. ");
INSERT INTO kpf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ambân zâk orotŋâ dâp otnigap. Nâ mua hannobi, zorat sâknâ saŋgonsap. ");
INSERT INTO kpf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nâ perâkŋak dâzâŋgobâ. Den siŋgi âlip hânŋâ hânŋâ sâne laŋ kârâm âibap, zo yatik ambân zi saŋgonigap, zorat den siŋgi sâne laŋ kârâm âibap.” ");
INSERT INTO kpf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yesugât arâp kiin zagât zeŋgât oserân gâbâ Yuda Karioto kamânân gokŋâ zâkŋâ tirik namâ galem a patâ zeŋgâren âim Yesu gâsubigât sapsum ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yatâ sâi nâŋgâm umziŋâ âlip oi kât pindânam sâwe. Oi sâne nâŋgâm Yesu tigâk tirâpzâŋgobapkât ek molim ândeip. ");
INSERT INTO kpf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yuda zeŋgât kendon patâ narâkŋâ oi râma gwamŋâ kom om sii nalem om nemarâwe. Zorat narâk oi arâpŋâ ziŋ Yesu mâsikâm sâwe, “Sii nalem zo mirâ ikâ unat?” ");
INSERT INTO kpf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yatâ sânetâ Yesuŋâ a zagât itâ sâm sâŋgonzâkoip, “Zet kamânân âim a ŋâi too âmaŋ lum âim tâi ekŋâ molibabot. ");
INSERT INTO kpf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mirin zari zâi mirâ mariŋ itâ dukuit, ‘Patâ zâk gâgât itâ sap, “Nâ sot arâpnâ mirâ umŋâ ikâ zoren sii nalem ninat?” ’ ");
INSERT INTO kpf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yatâ sâm dukuitâ mirâ um patâ ŋâi kiaŋ tâtatŋâ kubikkubikŋâ tirâpzâkoi zoren sii nalem umbabot.” ");
INSERT INTO kpf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Oi a zagât zet den zo lum kamânân âim Yesuŋâ sâip dâp muyagem sii nalem uwet. ");
INSERT INTO kpf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ŋâtiksâi Yesu sot arâp kiin zagât, zen mirâ zoren zâiwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Oi nalem nem tatne Yesuŋâ itâ sâm dâzaŋgoip, “Nâ perâkŋak dâzâŋgobâ. Zeŋgâren gâbâ ŋâiŋâ kâsa dâzâŋgoi ga gâsunim nobi. A zo nâ sot nalem nem taap.” ");
INSERT INTO kpf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sâi arâp ziŋ umziŋâ bâliŋ oi zikŋik zikŋik mâsikâm sâwe, “Gâ nâgât sâbat? Nâgât sâbat?” ");
INSERT INTO kpf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yatâ sâne dâzâŋgoip, “A zeŋgâren gâbâ ŋâiŋâ nâ sot nalem ârândâŋ niet, zâkkât san. ");
INSERT INTO kpf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A bonŋâ nâgât Anutugât ekabân den ziap, zo yatâ upâman. Ŋâiŋâ sâi a bonŋâ gâsunim nobi, Yei, a zo hâuŋâ ko tosa yâmbâtŋâ mimbap. A zo mam kâmboŋan gâbâ mân âsâgei sâi bâbâlaŋ opap.” ");
INSERT INTO kpf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nalem nem tatne Yesuŋâ nalem ŋâi mem sâiwap sâm namuŋ arâpŋâ itâ sâm ziŋgip, “Zi sunumnâ. Mem ninek.” ");
INSERT INTO kpf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yatâ sâm waiŋ hâkop mem sâiwap sâm ziŋgi aksik niwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nine itâ sâm dâzâŋgoip, “Gilâmnâ zi a doŋbep zeŋgât opŋâ hânân gibap. Zorat ko târotâroniŋ op kâtigibap. ");
INSERT INTO kpf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nâ perâkŋak dâzâŋgobâ. Nâ waiŋ too itârâŋ nia âkap. Oi dum zagâtŋan mân nemŋâ Ibânaŋgât um topŋan zâim waiŋ too mârâtŋâ ŋâi nimbat.” ");
INSERT INTO kpf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mâpâmâpâse kepŋâ ŋâi mem ko Oliwa bâkŋan zâiwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zâine Yesuŋâ itâ sâm dâzâŋgoip, “Itârâŋ zen aksik nâŋgâm pâlâtâŋziŋ lorei birânibi. Kembugât ekabân den kulem ŋâi itâ ziap, ‘Nâ râma galem a kua râma zen sibiŋsâbaŋ op âibi.’ ");
INSERT INTO kpf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Oi sa nâŋgânek. Nâ mumuŋan gâbâ zaatŋâ ko Galilaia hânân âi kândom otziŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yatâ sâi Peteroŋâ itâ dukuip, “Zen aksik patâ nâŋgâm pâlâtâŋziŋ lorei birâgibi. Ka nâ ko yatâ mân otgibat.” ");
INSERT INTO kpf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sâi ko Yesuŋâ itâ sâm dukuip, “Nâ perâkŋak dâgobâ. Itârâŋ ŋâtigân kuruk aŋâ sâp zagât mân diŋsâi gâ sâp karâmbut kwâimbâniban.” ");
INSERT INTO kpf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yatâ sâi Peteroŋâ kâuk birâŋaŋgâm sâip, “Gâ gomŋâ na nonâ sâne mân kwâimbâgibat.” Sâi arâpŋâ nâmbutŋandâ den yatik sâwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Oi Gezemane hânân âi takâm Yesuŋâ arâpŋâ itâ sâm dâzâŋgoip, “Zen zi tatne nâ ândi âi ninâu sâbâ.” ");
INSERT INTO kpf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yatâ sâmŋâ Petero, Yohane sot Yakobo diiziŋgi âine Yesu umŋâ yâmbârei ken bet kakit oip. ");
INSERT INTO kpf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yatâ okŋaŋgi dâzâŋgom sâip, “Umnâ yâmbârei mumuŋâ otnigap. Zen ziren nâ sot tap um wâgân ândinek.” ");
INSERT INTO kpf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yatâ sâm torengen âim si sâŋgânŋâ hânân gei tutukum sâknam kâmut zo mân muyagibapkât ninâu sâip. ");
INSERT INTO kpf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Oi itâ sâip, “O Ibânâ, gâ kut ŋâi ŋâi tuubam mân kwakmat, gât ko sâna sâknam kâmut zi buŋ upap. Oi nâgât den buŋâ, gâgât den kâtigibap.” ");
INSERT INTO kpf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ninâu sâm âburem âi uman zine ziŋgit Petero itâ sâm dukuip, “Gâ uman ziat? Gâ mâiktârâ ŋâi wâgân mân ândiban? ");
INSERT INTO kpf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Zen mâsimâsikâyân loribegât um wâgân tap ninâu sânek. Umŋâ bâbâlaŋ. Sâkŋâ ko yâmbâriap.” ");
INSERT INTO kpf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yatâ dâzâŋgom âi ninâu sâip. Den mârum ninâu sâip, zo yatik du ninâu sâip. ");
INSERT INTO kpf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ninâu sâm âburem umanâk zine ga ziŋgirip. Umanân gâbâ sen birâbirâ op zaatŋâ dap yatâ dukube. ");
INSERT INTO kpf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Oi dum âi ninâu sâm âburei sâp kârâmbut oi dâzâŋgoip, “Zen umanâk zem te? Mârum narâk mâte uap. A bonŋâ, nâ bâliŋ mâme a zeŋgât bitziŋan âibâman. ");
INSERT INTO kpf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bâi, zaatne âinâ. A sâi gâsumnim nobi, zo mâte otniŋgap.” ");
INSERT INTO kpf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesuŋâ yatâ dâzâŋgom kiri zorenâk arâp zeŋgât kâmurân gok Yuda karioto kamânân gokŋâ, zâkŋâ kâsa diiziŋgi a kâmut patâ gawe. Tirik namâ galem a sâtŋâ sot Kembugât gurumin den zorat galem a sot patârâpziŋ, zen a kâmut zo sâŋgonzâŋgone kâmbam sot sâu patâ mem gawe. ");
INSERT INTO kpf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudaŋâ kânŋan itâ sâm dâzâŋgoip, “Lum mâŋgansa ek ko zo gâsum diim âibi.” ");
INSERT INTO kpf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda zâk ga takâm Yesugâren âim o patânâ sâm lum mâŋgarip. ");
INSERT INTO kpf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","47","Oi Yesu arâpŋâ zeŋgâren gâbâ ŋâiŋâ sâuŋâ sâmbum a sâtŋaŋgât kore a ŋâi kindap kârâm kwâkip. ");
INSERT INTO kpf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Oi Yesuŋâ itâ sâm mâsikâziŋgip, “Zen nâgât dap nâŋge? Zen nâgât nâŋgâne kâmbam ku oi sâu kâmbamziŋoot ga gâsânoge? ");
INSERT INTO kpf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nâ zorat sa nâŋgânek. Nâ sirâmŋâ sirâmŋâ tirik namin a den siŋgi âlipŋâ dâzâŋgoman. Oi zoren mân gâsânowe. Oi laŋ otnine Kembugât ekabân nâgât den kulem ziap, zo kâtigibap.” ");
INSERT INTO kpf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sâi arâpŋâ zen aksik birâŋaŋgâm siŋsururuŋ âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","A sigan ŋâi sâŋgum kâu lapŋâ Yesu sot gâi gâsuwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Gâsunetâ sâŋgum kwâkâm pam sâk bârak arip. ");
INSERT INTO kpf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","A kâmut, ziŋ Yesu gâsum diim patâziŋaŋgât mirin âiwe. Zâkkât mirin tirik namâ galem a patâ sot Kembugât gurumin den zorat galem a zen mindum tarâwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Âine Petero zâk kândâtziŋan bet moliziŋgâm âim a patâziŋaŋgât poŋ kâligen bageip. Bagimŋâ galem a osetziŋan tap kârâp nâŋgâm tâip. ");
INSERT INTO kpf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tirik namâ galem a patâ sot a patâziŋâ aksik mindum Yesugât den sâkŋanâk sâm, kâmbamân pânam den sâm kârum tarâwe. Oi bonŋâ mân muyagiwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A doŋbepŋâ Yesugât den sarâ ŋâi ŋâi sâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sânetâ a nâmbutŋâ ziŋâ den sarâ itâ sâwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Itâ sâi nâŋgâwen, ‘Na tirik namâ zi kândaŋâ bitnandâ mân tuubat, yen dinnandâ sa sirâm karâmbut umŋan âsagibap.’” ");
INSERT INTO kpf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ka dinziŋâ zo kânok buŋâ. Den ŋâi ŋâi sâwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yatâ utne tirik namâ galem a zeŋgât a patâŋâ zaat kinŋâ Yesu mâsikâm sâip, “Den se, zorat hâuŋâ sâban mo mân sâban? A zi ziŋâ gâgât den se, zo nâŋgâna dap uap?” ");
INSERT INTO kpf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sâi Yesuŋâ lâuŋan mân mem diŋ buŋ kirip. Oi du a patâŋâ mâsikâm sâip, “Gâ Kristo, Anutu sâm âlip kwâkŋaŋgâmen, zâkkât nanŋâ mo ŋâi?” ");
INSERT INTO kpf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sâi ko Yesuŋâ sâip, “Sat, zo yatâ. Oi ŋâi sa nâŋgânek. Gâtâm a bonŋâ, nâ imbâŋâ mariŋâ zâkkât âsanŋâ bongen tapŋâ sumbemgât unumunum kwâkŋan ga nikpi.” ");
INSERT INTO kpf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yatâ sâi tirik namâ galem a zeŋgât patâziŋâ, zâk diŋâ nâŋgi kâlak oi hâmbâŋâ mem mooloŋ arâpŋâ itâ sâm dâzâŋgoip, “Den dum mân sânat. ");
INSERT INTO kpf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Zâk Anutu hutkum sap. Ziŋâ dap sâbi?” Yatâ mâsikâziŋgi zen aksik sâwe, “Mumuŋaŋgât siŋgi uap.” ");
INSERT INTO kpf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yatâ sâmŋâ a nâmbutŋâ Yesu siŋan tâpkuwe. Oi nâmbutŋandâ si sâŋgânŋâ kwâtepkum bitziŋandâ kom sâwe, “Ŋâiŋâ gogap? Gâ Propete ândiat, zorat ko sâm muyage.” Yatâ sânetâ galem a zen bitziŋandâ si sâŋgânŋan kuwe. ");
INSERT INTO kpf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Oi Petero zâk sombemân tâi tirik namâ galem a patâgât kore ambân ŋâi gâip. ");
INSERT INTO kpf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Gâi ko Petero kârâp nâŋgâm tâi ekŋâ dukuip, “Gâ Nasarete gokŋâ Yesu sot ândimat.” ");
INSERT INTO kpf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sâi ko Peteroŋâ kwâimbâm sâip, “Gâ den zo dap sat? Sâna kwaksan.” Sâmŋâ âkŋan ari kurukŋâ diŋsâip. ");
INSERT INTO kpf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ari kore ambân zâk dum ekŋâ a kirâwe, zo itâ dâzâŋgoip, “A zi zâk zeŋgât kâmurân gokŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Sâi Peteroŋâ kwâimbâm biraŋip. Mâik ŋâi tap ko a tarâwe, ziŋâ dukum sâwe, “Perâkŋak gâ zeŋgât kâmurân gokŋâ. Gâ Galilaia gokŋâ.” ");
INSERT INTO kpf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sâne Peteroŋâ kwâimbâm Anutu mâteŋan sâm kâtigem sâip, “A kutŋâ se, zo nâ mânâk ekman.” ");
INSERT INTO kpf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sâi zorenâk kuruk diŋsâi sâp zagât oip. Oi Yesuŋâ mârum den itâ dukuip, “Kurukŋâ sâp zagât mân diŋsâi gâ kwâimbânina sâp karâmbut upap.” Peteroŋâ den zo nâŋgâm umŋâ bâlei isem bâliŋ oip. ");
INSERT INTO kpf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Haŋsâi tirik namâ galem a patâ sot a patârâpziŋâ sot Kembugât gurumin den zorat galem a sot galem a nâmbutŋâ, zen mindumŋâ Yesugât den sâwe. Den sânetâ a nâmbutŋâ zen Yesu gâsum bikŋan saam diim âi Roma a kutâ Pilatogâren âi parâwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Panetâ kiri Pilatoŋâ Yesu mâsikâm sâip, “Topkaŋgât dâtno. ");
INSERT INTO kpf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Gâ Yuda zeŋgât a kutâ?” Mâsiki Yesuŋâ sâip, “Sat, zo yatâ.” Sâi ko tirik namâ galem a patâ ziŋâ Yesu den doŋbep sâm siŋan giwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yatâ utnetâ Pilatoŋâ Yesu mâsikâm sâip, “Nâŋgat? Zen gâgât den yâmbâtŋâ sânetâ gâ den hâuŋâ sâban mo mân sâban?” ");
INSERT INTO kpf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sâi Yesuŋâ den hâuŋâ mân sâm den nâŋ kiri Pilatoŋâ nâŋgâm kwâkâm tâip. ");
INSERT INTO kpf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yuda zeŋgât kendon patâ narâk dâp a tâk namin tatne zeŋgâren gâbâ kânok olaŋi arip. ");
INSERT INTO kpf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A nâmbutŋâ zen Roma a kutâgât âkonziŋgi kâmbam kom a nâmbutŋâ zâŋgone tâk namin zâmbarâwe. Oi osetziŋan a ŋâi kutŋâ Baraba. ");
INSERT INTO kpf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Oi a ambân kâmut, zen a kutâgâren ga mindum kendon dâp sâne opmâip, yatâ upapkât dukuwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dukune Pilatoŋâ mâsikâziŋgâm sâip, “Yuda zeŋgât a kutâ olaŋsa ari nâŋgâne dâp upap?” ");
INSERT INTO kpf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tirik namâ galem a patâ, zen Yesugât um kâlak nâŋgâŋaŋgâm zâkkâren parâwe, zo nâŋgâm mâsikâziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sâi ko tirik namâ galem a zen a ambân kâmut zo itâ dâzâŋgowe, “Zen sâne Baraba olaŋbap.” Yatâ sâne dinziŋâ luwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Oi Pilatoŋâ dum mâsikâziŋgip, “Yatâ se, zorat ko Yuda zeŋgât a kutâ sâme, zo dap okŋaŋgâbatkât se?” ");
INSERT INTO kpf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mâsikâziŋgi aksik patâ itâ sâwe, “Zâk poru nagân kune moik.” ");
INSERT INTO kpf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Sâne Pilatoŋâ sâip, “Wan tosagât?” Sâi zen aksik patâ lâuziŋ mâtakâm den kâtik sâwe, “Zâk poru nagân kune moik.” ");
INSERT INTO kpf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Yatâ sâne Pilatoŋâ umziŋâ âkâbapkât Baraba olaŋ ziŋgip. Ka Yesu ko sâi inzutŋâ lapitŋâ poru nagân kune mumbapkât kâwali a bitziŋan pâip. ");
INSERT INTO kpf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Oi kâwali a zen Yesu mirin gâbâ diim ga kâwali a zeŋgât namâ sâŋgânŋan dâmân kâligen bagiwe. Bagim sâne kâwali a aksik mindum gawe. ");
INSERT INTO kpf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Oi kâwali a zeŋgât hâmbâ kuriŋ ŋâi giŋaŋgâne giarip. Oi tâk sâtmam goŋkom Yesu kâukŋan pane giarip. ");
INSERT INTO kpf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yatâ opŋâ pam diim sâwe, “Oe, Yuda zeŋgât a kutâ.” ");
INSERT INTO kpf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Den yatâ dukum kâukŋan kom zâkkâren tâpkuwe. Siminziŋ liim kwap sarâ sarâ mâpâsiwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yatâ kom siŋan gem kâwali hâmbâ kwâkâm zikŋâ hâmbâ giŋaŋgâne giari poru nagân kunam diim âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Âi mâtâbân a ŋâi muyagiwe, kutŋâ Simoŋ, Kirene gokŋâ. Alesande sot Rupu, zekât ibâ. Zâkŋâ kamân mâigân gâbâ gâi kâwali a ziŋ muyagem sâne Yesugât poru nak lugi âiwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Diim âim hân ŋâi kutŋâ Goligata (niiŋ denân ko, kâuk siŋit), zoren takâwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Zoren takâm waiŋ too kâtik sot um gulip too mâpot pindânâ sâne birip. ");
INSERT INTO kpf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Oi poru nagân kuwe. Kune kiri kâwali a zen hâmbâŋâ minam wenzu pane muyageip dâp mem naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mirâ haŋsâi mirâsiŋ dâp nâmburân kimembut oi ko kuwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kune kiri kâukŋan poru nagân den itâ kulemguwe, “Zâk Yuda zeŋgât a kutâ.” ");
INSERT INTO kpf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oi kâmbam ku a zagât zâkom, ŋâi toren ŋâi toren zâkone kirâwet. ( ");
INSERT INTO kpf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kembugât ekabân den itâ ziap, zo bonŋâ oip. Den zo itâ, “Zâk bâliŋ mâme a oserân pamŋâ sâwe, ‘A zi zen bâliŋ mâme a.’”) ");
INSERT INTO kpf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","A ambân mâtâbân âim gam mem ge kwâkwat den dukum sâwe, “Tirik namâŋ kândaŋâ sirâm karâmburâk tuum naŋgâbat sâin, zorat poru nagân gâbâ âkâm ge.” ");
INSERT INTO kpf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tirik namâ galem a patâ sot Kembugât gurumin a, zen Yesugât sâm, mem ge kwâkwat den itâ sâwe, “A ambân nâmbutŋâ tâmbetagonam utnetâ tânzâŋgomâip. Zikŋaŋgât ko kwaksap. ");
INSERT INTO kpf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Zâk Kristo, Isirae a neŋgât a kutâ ândiap oi ko poru nagân gâbâ âkâm gâi ekŋâ diŋâ nâŋgâm, nâŋgâm pâlâtâŋ kwâkŋaŋgânat.” A zagât poru nagân zâkowe, zekoot yatik sâm bâliŋ kwâkŋaŋgâwet. ");
INSERT INTO kpf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mirâ bâkŋan oi ŋâtâtik muyagem hân dâp op zei mirâ oi âkip. ");
INSERT INTO kpf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mirâ oi Yesuŋâ den sâm kambâŋ sâip, “Eloi, Eloi, lama sabatini (niiŋ denân ko, Anutunâ, Anutunâ, wangât birânigat)?” ");
INSERT INTO kpf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yatâ sâi a ambân kirâwe, nâmbutŋâ ziŋâ nâŋgâm sâwe, “Zi nâŋgânek. Elia konsap.” ");
INSERT INTO kpf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yatâ sâm a ŋâi sârârâk kârâm âim sarugât kâmon mem sum kapiŋkum ga winigâ too kâlakŋoot Yesu lâuŋan pamŋâ bukurâp itâ sâm dâzâŋgoip, “Nen tap iknâ. Eliaŋâ perâkŋak ga mâkâbap mo buŋâ?” ");
INSERT INTO kpf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Oi Yesu zâk doŋbep kambâŋ moip. ");
INSERT INTO kpf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Moi ko tirik namin sâŋgum patâ kinmâip, zo oloŋ gei kwâkip. ");
INSERT INTO kpf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Oi kâwali a zeŋgât galem a, zâk mâte kin egi moi sâip, “A zi zâk perâkŋak Anutugât nanŋâ ândeip.” ");
INSERT INTO kpf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ambân nâmbutŋâ kârebân kin ek nâŋgâwe. Zeŋgât oserân Maria Madala kamân gokŋâ sot Maria Yakobo zâk sigan sot Yose, zekât mamzikŋâ sot ambân ŋâi, kutŋâ Salome. Zen ârândâŋ kirâwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ambân zen mârum Yesu Galilaia hânân molim kore okŋaŋgâm ândiwe. Oi zenâk buŋâ. Ambân nâmbut ârândâŋ Yesu molim Yerusalem kamânân gam ândiwe. Zen aksik ek kirâwe. ");
INSERT INTO kpf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Mirâsiŋ geibâ sâi Yuda zeŋgât kendongât kut ŋâi ŋâi kubikkubik narâk oip. ");
INSERT INTO kpf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Narâk zoren Yosepe Arimataia kamânân gokŋâ, zâk gâip. Zâk a sâtŋâ zeŋgât kâmurân ândeipŋâ Anutugât um topŋan ândiândigât umŋâ patâ kirip. Zâkŋâ keŋgât buŋ Pilatogâren âim Yesugât kâmbarâŋaŋgât ninan sâm dukuip. ");
INSERT INTO kpf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Dukui ko Pilatoŋâ mârum muap mo taap sâmŋâ kâwali a zeŋgât galem a zo sâi gâi mâsikip, “Mârum muap mo taap?” ");
INSERT INTO kpf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Oi kâwali a galem zâkŋâ sâip, “Mârum muap.” Yatâ sâi Pilato zo nâŋgâm Yosepeŋâ mem hangubapkât sâip ");
INSERT INTO kpf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sâi Yosepeŋâ sâŋgum kâu ŋâi kwâlâm âim Yesu kâmbarâŋâ poru nagân gâbâ kwâkâm sâŋgumŋâ kâpeip. Kâpim mem âim kât mâtâpŋâ uŋakŋan pâip. Kât mâtâp zo a ŋâiŋâ kârâm kubigip. Pamŋâ kât patâ ŋâi mem kâbakŋei âi kwârakuip. ");
INSERT INTO kpf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Madala kamânân gokŋâ sot Maria Yosegât mamŋâ, zet ârândâŋ egitâ hanguip. ");
INSERT INTO kpf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yuda zeŋgât kendon âki ko Maria Madala kamânân gokŋâ sot Maria Yakobogât mamŋâ sot Salome, zen Yesugât kâmbarâŋ saŋgonam too sot kelâk wârân âlipŋâ, zo sâŋgân miwe. ");
INSERT INTO kpf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yuda zeŋgât kendon âki ko mirâ haŋsâsâgât ambân karâmbut zo, zen zaatŋâ Yesugât kwagân âine mirâsiŋ takip. ");
INSERT INTO kpf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Oi zen itâ âraguwe, “Ŋâiŋâ kât patâ zo mem pâi ko kât mâtâpŋan baginat?” ");
INSERT INTO kpf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yatâ sâmŋâ kwagân takâm igâwe. Kât patâ ŋâi zo kâbakŋine zeip. ");
INSERT INTO kpf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kât mâtâp zo pâroŋsâm kiri ekŋâ bagimŋâ bongen a ŋâi hâmbâŋâ kâu tâi ekŋâ pârâkpam imbaŋâziŋ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Oi a zorâŋâ itâ sâm dâzâŋgoip, “Mân keŋgât utnek. Zen Yesu Nasarete gokŋâ poru nagân kuwe, zo iknam ge. Zâk zi mân ziap. Zâk zaatsap. Gebâkŋik zi iknek. ");
INSERT INTO kpf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Zen âimŋâ Petero sot arâpŋâ nâmbutŋâ itâ sâm dâzâŋgonek. ‘Zâk Galilaia hânân âi kândom otziŋgâbap. Zen zoren âi ikpi.’” ");
INSERT INTO kpf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sâi ambân zen sânâmziŋ sâmbui keŋgât opŋâ kwagân gâbâ gamŋâ sârârâk kârâm âiwe. Oi umziŋ keŋgât oi siŋgi zo a mân dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yuda zeŋgât kendon âki haŋsâsâgât Yesu zâk zaatŋâ Maria Madala kamânân gokŋâ muyageŋaŋgip. Mârumŋan wâke nâmburân zagât ambân zorat umŋan gei ândine Yesuŋâ moliziŋgip. ");
INSERT INTO kpf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yesuŋâ âsageŋaŋgi arâpŋâ ziŋ isem umbâlâ op zine ambân zo âi siŋgi dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Arâpŋâ zen Yesu zaatŋâ ambân muyageŋaŋgip, den zo nâŋgâmŋâ nâŋgâne bon buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Oi azatŋâ kamân ŋâin âiram aritâ muyagezikâm zâkkât holi tobat ŋâi oi igâwet. ");
INSERT INTO kpf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Muyageziki zet âburem âi arâp nâmbutŋâ dâzâŋgoitâ nâŋgâne bon buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Zorâŋ bet arâp kiin kânok zen mindumŋâ nalem nem tatne muyageziŋgip. Muyageziŋgâmŋâ itâ sâm dâzâŋgoip, “Zaarâwan, zorat den siŋgi dâzâŋgone zen wangât umziŋ kâtik oi den zo nâŋgâne bon buŋ oip?” ");
INSERT INTO kpf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yatâ sâmŋâ itâ sâip, “Zen hân dâp âim a ambân ândie, zo zen siŋgi âlipŋâ dâzâŋgobi. ");
INSERT INTO kpf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","A ŋâiŋâ nâŋgâm pâlâtâŋ kwatnigi too saŋgonŋaŋgâne zâk sumbemgât siŋgi upap. Ka nâŋgâm pâlâtâŋ mân upap, zo ko sim kârâpkât siŋgi upap. ");
INSERT INTO kpf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nâŋgâm pâlâtâŋ kwatnim ândibi, zo imbaŋâ ziŋga nâgât kutnâ sâm nep itâ tuubi. Wâke molibi sot den gându uŋakŋâ ŋâi sâbi. ");
INSERT INTO kpf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Zen mulum kâtik bitziŋandâ gâsuziŋgâne mân tâmbetzâŋgobi. Oi zen too ŋâi a ku, zo nine mân tâmbetzâŋgobap. Sisi mâsek zeŋgât kâukziŋan bitziŋandâ gâsune âlip upi.” ");
INSERT INTO kpf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kembu Yesu zâk den yatâ sâm dâzâŋgoi ko Anutuŋâ mem sumbemân zarip. Zoren Anutugât âsanŋâ bongen tap ândiap. ");
INSERT INTO kpf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Oi arâpŋâ zen ko âimŋâ kamân dâp siŋgi âlipŋâ sâm âiwe. A ambân zen siŋgi âlip den nâŋgâne bon upapkât Kembuŋâ mam otziŋgâm imbaŋâ ziŋgi sen mârât top top tuunetâ mem kâtikŋan pâip. Zo yatik. ");
INSERT INTO kpf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","A doŋbep, zen kut ŋâi ŋâi bonŋâ osetniŋan âsageip, zorat den siŋgi kulemguwe. ");
INSERT INTO kpf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yesugât arâpŋâ, zen zâk sot tapŋâ kut ŋâi ŋâi zo ek naŋgâmŋâ dâzâŋgone kulemguwe. ");
INSERT INTO kpf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Oi nâŋgoot yatik topŋan gâbik kut ŋâi ŋâi muyagem gâip, zo mulunâk sâm pitiŋkum nâŋgâm naŋgâm, Teopilo a patânâ, gâgât den siŋgi zo kulemgubâman. ");
INSERT INTO kpf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Oi zo sâlâpkum itâ nâŋgâm kwâtâtiban. Den siŋgi otgiwe, zo bonŋâ. ");
INSERT INTO kpf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodeŋâ Yuda hânân a kutâ ândeip, narâk zoren Anutugât tirik namâ galem a ŋâi ândeip, kutŋâ Sakaria. Zâk Abia zâkkât kâmurân gokŋâ. Ambinŋâ Elisabete zâk Aaroŋgât kiurâpŋâ zeŋgâren gokŋâ. ");
INSERT INTO kpf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zet Anutu mâteŋan târârak ândiwet. Anutugât gurumin den aksik lum târârakŋâ ândiwet. ");
INSERT INTO kpf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabete zâk kâpin ândeipkât murarâ buŋ ândim a ambân sombâ urâwet. ");
INSERT INTO kpf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Oi hilâm dâp tirik namâ galem a ŋâi tirik namin bagimŋâ nalem wârânŋoot kârâbân oi sei kâbak hitom âlipŋâ zâimâip. Oi Sakaria ândei ko zâkkât a kâmut zo zen tirik namâ galem upigât narâkŋâ mâte oi tirik namin baginam wenzu pane muyageip dâp namin zâimarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sakaria zâk tirik namin zâi om tâi a ambân doŋbep zen âkŋan tap Kembugâren ninâu sâm tarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kembugât sumbem a ŋâiŋâ zâkkâren âsageip. Sumbem a zo nalem kâbak uuŋâ kândâtŋan bongen âsagem kirip. ");
INSERT INTO kpf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Âsagem kiri Sakaria ekŋâ pârâkpam keŋgât oip. ");
INSERT INTO kpf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yatâ oi ko sumbem a zorâŋâ itâ sâm dukuip, “Sakaria, gâ mân keŋgât ot. Kembuŋâ ninâugâ nâŋgipkât ambingâ Elisabete kâmboŋâ op nangâ mimbap. Zâkkât kutŋâ Yohane sâban. ");
INSERT INTO kpf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Umgâ sâtâre upan. Âsagei a ambân doŋbepŋâ umâlep nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Zâk Anutu mâteŋan patâ opŋâ ândibap. Oi zâk mamŋaŋgât kâmbo kâligen zei Tirik Kaapumŋâ topkwap umŋan piksâbap. Zâk waiŋ sot too kâtikŋâ mânâk nimbap. ");
INSERT INTO kpf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Zâkŋâ den dâzâŋgoi Isirae a doŋbep zen umziŋ melâŋ Kembugât a upi. ");
INSERT INTO kpf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Zâkŋâ Propete Elia yatâ Kaapum sot imbaŋâŋoot op Kembu kore okŋaŋgâbap. A patâ zeŋgât umziŋâ melâŋi katep zeŋgâren âi gâsubap. Oi a um kâtik zen umziŋ melâŋi târârak zeŋgât holi yatâ op ândibi. Zo yatik Kembugât siŋgi a ambân kubikziŋgi ândibi.” ");
INSERT INTO kpf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sumbem aŋâ yatâ sâi Sakaria itâ mâburem dukuip, “Nâ sot ambinâ, net a ambân sombâ, zorat dap op gâgât den nâŋga bonŋâ upap?” ");
INSERT INTO kpf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sâi sumben aŋâ itâ sâm dukuip, “Nâŋgâ. Nâ kutnâ Gabirie. Nâ Anutu mâteŋan kinman. Zâkŋâ sâŋgonnogi gem ga siŋgi den âlipŋâ zi dâgogan. ");
INSERT INTO kpf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Zorat nâŋgâ. Dinnâ nâŋgâna mân bon uapkât zorat hâuŋâ kopa op diŋgâ buŋ op ândina den dâgogan, zo bonŋâ muyagibap.” ");
INSERT INTO kpf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sakaria zâk tirik namin narâk kârep tâi a ambân zen âkŋan mambât tapŋâ nâŋgâm kwâkâm tarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yatâ utne Sakaria zâk gemŋâ den dâzâŋgobam kwagip. Kwagi ekŋâ itâ nâŋgâwe, “Zâk tirik namin sen mârât eksap.” Yatâ nâŋgâne Sakariaŋâ bikŋandik dâp otziŋgip. Oi diŋâ buŋ op ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yatâ op ândim gâi nep tuutuuŋ narâkŋâ âki kamânân puriksâm arip. ");
INSERT INTO kpf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Oi bet ambinŋâ kâmboŋâ oip. Oi kâin bâtnâmbut tik ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Oi itâ sâip, “Kembu zâk sâi narâk ziren a ambân mâteziŋan aŋunnâ buŋ upap.” ");
INSERT INTO kpf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kâin bâtnâmbut âki Kembuŋâ sumbem a Gabirie sâŋgongoi Galilaia hânân, Nasarete kamânân arip. ");
INSERT INTO kpf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Zoren ambân sigan ŋâi ândeip, kutŋâ Maria. Maria zâkkât a siŋgi zo Dawidigât kiunŋâ Yosepe. Zâkkât siŋgi sâne ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Oi sumbem a zo Mariagâren muyagem itâ sâm dukuip, “Kembuŋâ umâlip otgibap. Gâ zorat sâtâre ot. Kembuŋâ gâ sot ândiap.” ");
INSERT INTO kpf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Sumbem aŋâ yatâ sâm dukui nâŋgi kwakmak oip. Umŋan itâ nâŋgip, “Den zo topŋâ dapkât sap?” ");
INSERT INTO kpf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yatâ nâŋgi sumbem aŋâ itâ sâm dukuip, “Maria, gâ mân keŋgât ot. Anutuŋâ gegi âlip uat. ");
INSERT INTO kpf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nâŋgâ. Gâ kâmbogâ op nangâ mimban. Zâkkât kutŋâ Yesu sâban. ");
INSERT INTO kpf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Zâkŋâ patâ oi sumbem mariŋaŋgât nanŋâ sâbi. Kembu Anutuŋâ sâkunŋâ Dawidi, zâkkât gebâkŋan pâmbap. ");
INSERT INTO kpf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Oi Isiraegât kiurâp, zeŋgât a kutâ op ândibap. Op ko zâk narâk buŋâ ândim zâibap.” ");
INSERT INTO kpf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Sâi Mariaŋâ itâ sâm dukuip, “Nâ a buŋâ ândianân den sat, zo dap op âsagibap?” ");
INSERT INTO kpf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yatâ sâi sumbem aŋâ den itâ mâburem pindip, “Tirik Kaapumŋâ gâ sot gei tâpap. Oi sumbem mariŋaŋgât imbaŋandâ mamŋâ tatgibap. Zorat nangâ zo Anutugât nanŋâ sâbi. ");
INSERT INTO kpf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Oi ŋâi dâgoga nâŋgâ. Bukugâ Elisabete, zâk ambân sombâŋâ nanŋâ mimbap. Elisabeteŋâ kâmboŋâ tâi kâin nâmburân kânok âkip. Zâk kâpin ambânŋâ yatâ uap. ");
INSERT INTO kpf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anutu zâk kut ŋâi ŋâi tuubam mân kwakmap.” ");
INSERT INTO kpf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yatâ sâi ko Mariaŋâ itâ sâm dukuip, “Nâ Kembugât kore ambân. Zorat ko den sat, zo âlip otnibap.” Yatâ sâi sumbem aŋâ birâŋaŋgâm arip. ");
INSERT INTO kpf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maria zâk mâik ŋâi ândim zaatŋâ Yuda zeŋgât barin kamân ŋâi tâip, zoren arip. ");
INSERT INTO kpf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Âi takâm Sakariagât mirin zâim Elisabete sâm sâtâre okŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Yatâ mâŋgari nâŋgi umŋan katep seroŋkoip. Oi Tirik Kaapumŋâ Elisabete umŋan piksâi den kâtikŋâ sâm itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","“Bukunâ, Anutuŋâ mâsop mingibap. Ambân nâmbut zeŋgât mâsop yatâ buŋâ. Walâm mingibap. Oi kâmbogâ kâligen muyagem ziap, zâk yatik mâsop miŋaŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Opoŋ, Gâ kembunaŋgât mamŋandâ nâgâren gaat. ");
INSERT INTO kpf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gâ mâŋgannina kâmbonan katep sâtâre op âim gâi nâŋgan. ");
INSERT INTO kpf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gâ Kembugât den nâŋgâna bon oip, zorat gâgât nâŋga sâtâreŋoot uap.” ");
INSERT INTO kpf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Oi Mariaŋâ itâ sâip, “Nâ umnandâ Kembu sâm âlip kwâkŋaŋgan. ");
INSERT INTO kpf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Um dâpnandâ Anutu kubikkubiknâ sâm sâtâre okŋaŋgan. ");
INSERT INTO kpf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nâ zâkkât kore ambân gigiŋâ ua ko nâ mem zâi kwatnigap. Zorat a ambân zen sâm bâbâlaŋ kwatnibi. ");
INSERT INTO kpf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kembu zâk kâwaliŋootŋâ nâgâren kulem mârâtŋoot kuap. Kutsiŋgiŋâ hâlâluyâk ziap. ");
INSERT INTO kpf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Hurat kwâkŋaŋgâme, zen um lumbeŋaŋgât opŋâ kisâŋgoit, sâkurâpniŋ zeŋgâren gâbâ on galem otziŋgâm gâip. ");
INSERT INTO kpf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Imbaŋâŋaŋgât opŋâ a umziŋaŋgât zâizâiŋâ op ândime, zo zâŋgom kâbakŋei siŋsururuŋ âime. ");
INSERT INTO kpf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A kutâ zen ko kâbakŋeziŋgi ginetâ a gigiŋâ minziŋgâm zâi zâmbanmap. ");
INSERT INTO kpf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A ambân kâbâ kanpitâ, zo kâbâ kwatziŋgâmap. Oi sikumziŋ patâ, a zo kâbakŋeziŋgi bet bâsaŋ âime. ");
INSERT INTO kpf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Oi Isirae kore a ambân gakâŋâ um lumbeŋaŋgât op tânzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Sâkuniŋâ Abaram sot kiurâpŋâ ândibi, zen um lumbeŋaŋgât den dâzâŋgoip. Zorat yatâ otniŋgip.” ");
INSERT INTO kpf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Oi Maria zâk kâin karâmbut Elisabete sot ândim kamânŋan âburem arip. ");
INSERT INTO kpf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabete zâk katep mimiŋ narâk oi nanŋâ meip. ");
INSERT INTO kpf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Katep âsagei ko kamârâpŋâ sot torerâpŋâ, zen Kembu umâlepŋaŋgât bonŋâ zâkkâren muyageipkât umâlip nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Katep âsagei sirâm nâmburân zagât tapŋâ karâmbuŋan a ambân zen mindumŋâ katep kwabâ kwâkŋaŋgâwe. Oi ibâŋâ Sakariagât kutŋâ pindânam sâwe. ");
INSERT INTO kpf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Sâne mamŋandâ kwâkâziŋgâm sâip, “Buŋâ. Kutŋâ Yohane sânat.” ");
INSERT INTO kpf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Sâi itâ dukuwe, “Torerâp zeŋgâren kot yatâ zo mân ziap.” ");
INSERT INTO kpf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sâm kwâkâyaŋgâm Sakaria zâk nanŋaŋgât kutŋâ sâbapkât betŋâ dâp okŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Okŋaŋgâne ekap nibigât bikŋandâ dâp tuugi pindâne zitâ kulemguip, “Kutŋâ Yohane.” Yatâ kulemgui zen ekŋâ pârâk parâwe. ");
INSERT INTO kpf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Oi zorâŋak nâmbâlamŋâ puriksâi den sâm Anutu mâpâseip. ");
INSERT INTO kpf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Oi ko kamân toren toren a ambân tap âiwe, zo den zo nâŋgâne imbaŋâ oip. Oi Yuda zeŋgât barin ândiwe, zo zen siŋgi âragum naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Oi zen den zo nâŋgâm itâ sâwe, “Katep zo lâmbatŋâ dap upap?” Sâne Kembuŋâ katep zo galem oi ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ibâŋâ Sakaria zâkkât umŋan Tirik Kaapum piksâi mâpâmâpâse den itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Isirae a ambân nen Kembuniŋâ Anutu mâpâsinâ. Zâkŋâ arâpŋâ nen niŋgitŋâ tâbaniŋ miap. ");
INSERT INTO kpf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Oi kore aŋâ Dawidi, zâkkât kiurâpŋâ neŋgâren gâbâ a ŋâi bâliŋan gâbâ mâkâniŋgâbapkât sâi âsagiap. A zo zaat betniŋan mimbap. ");
INSERT INTO kpf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mârumŋan sâi Propete gakârâp den kânŋan sâwe, zorat dâp yatâ âsagiap. ");
INSERT INTO kpf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Zâkŋâ kâsa otniŋgâme, zeŋgât bitziŋan gâbâ betniŋan mimbap. Um kâlak otniŋgâme, zeŋgât bitziŋan gâbâ gâbâreniŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sâkurâpniŋâ zen sot um lumbegât târotâro oip, zo nâŋgâmŋik otniŋgâbapkât sâip. ");
INSERT INTO kpf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kâsarâpniŋâ zeŋgâren gâbâ mâkâniŋgâbapkât sâkuniŋâ Abaram sâm kâtigeŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Yatâ otniŋgi sâkniŋ sânduksâi um hâlâlu, um salek ândim ninâu sâm ândim munat. ");
INSERT INTO kpf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Oi katep, gâ sumbem mariŋaŋgât Propete a op ândiban. Oi Kembu kândom okŋaŋgâm mâtâp kârâm kubikpan. ");
INSERT INTO kpf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Oi Kembugât a ambân kâmut kubikkubik den dâzâŋgona nâŋgâm unziŋ melâŋne Kembu zâk tosaziŋ gulipkubap. ");
INSERT INTO kpf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anutu zâk umŋâ patâ neŋgâren ziapkât sâi ŋâtâtigân gâbâ haŋsâbap. ");
INSERT INTO kpf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mârum ŋâtâtigân ândim munam urâwen. Irak ko âsakŋâ niŋgâbap. Âsakŋâ âsagei lumbeŋaŋgât mâtâp ekŋâ lâŋnat.” ");
INSERT INTO kpf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Oi katep zâk um sâkŋâ lâmbarip. Oi mirâ kamân âtâŋan ândei nep narâk mâte oi Isirae a ambân zeŋgâren âsageip. ");
INSERT INTO kpf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Narâk zoren Roma zeŋgât a kutâ Augusto zâkkât den itâ zeip, “A ambân hân dâp kutziŋ kulemgum sâlâpkubi.” Nep zo mârumŋan mân tuuwe. ");
INSERT INTO kpf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kwirinio zâk Siria hânân a kutâ op ândei nep zo topkwarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A ambân ândiwe aksik kutziŋâ kulmegunam utne kamân topziŋan âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosepe zâk Dawidigât kiun, zorat Galilaia hânân Nasarete kamân birâm Yudaia hânân Dawidigât kamân Betelem, zoren zarip. ");
INSERT INTO kpf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Oi ambân siŋgiŋâ Maria, zâk zot kutzikŋâ kulemgubâ sâi kâmboŋoot diigi âiwet. ");
INSERT INTO kpf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Âi takitâ Maria katep mimiŋ narâkŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Narâk oi kândom nanŋâ memŋâ sâŋgumŋâ kâpimŋâ bâu patâ makaugât waŋgâyân pâi gei zeip. A ambân zen zâk lomba mirâ piksâwegât kiaŋ kârumŋâ makaugât waŋgâyân pâitâ gei zeip, ");
INSERT INTO kpf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Oi ŋâtik zoren kamân naŋgâmŋan a nâmbutŋâ râma galem tarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Galem tatnetâ Kembugât sumbem a ŋâiŋâ zeŋgâren âsagei Kembugât âsakŋandâ âsageziŋgi keŋgât doŋbep urâwe. ");
INSERT INTO kpf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Oi sumbem a zorâŋ itâ sâm dâzâŋgoip, “Zen mân keŋgât utnek. Nâŋgânek. Nâ zeŋgât den siŋgi âlip mem gaan. A ambân zen zo nâŋgâmŋâ sâtâre upi. ");
INSERT INTO kpf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Itârâŋ sirâm ziren kubikkubik mariŋâ, Kembu Kristo, Dawidigât kamânân âsageziŋgap. ");
INSERT INTO kpf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Oi sâm mânâŋgât ziŋga nâŋgânek. Zen katep mâik ŋâi sâŋgumŋâ kâpimŋâ makau zeŋgât nalem niniŋ waŋgâyân ziap, zo âi ikpi.” ");
INSERT INTO kpf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Den yatâ sâi zorenâk sumbem a kâmut patâ bukuziŋaŋgâren gemŋâ Anutu itâ sâm mâpâsiwe, ");
INSERT INTO kpf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anutu u sumbemân sâm âlip kwâkŋaŋgânâ. Zâkŋâ hânân a buku otziŋgap, zeŋgâren um lumbe muyagibap.” ");
INSERT INTO kpf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sumbem a, zen âburem zâine galem a zen itâ sâm âraguwe, “Nen Betelem kamânân zâim Kembuŋâ den sap, zorat bonŋâ iknâ.” ");
INSERT INTO kpf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yatâ sâm kek zâimŋâ Maria sot Yosepe muyagezikâm katep mâik makau waŋgâyân zei igâwe. ");
INSERT INTO kpf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Oi âimŋâ a ambân sumbem aŋâ den sâip, zo dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Oi galem a zeŋgât den nâŋgâwe, zo nâŋgâne imbâŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariaŋâ ko den zo nâŋgâm kwâtâtem ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Râma galem a, zen âburem âim sumbem agât den sot Yesu katep igâwe, zorat Anutugâren sâiwap sâm mâpâsiwe. ");
INSERT INTO kpf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yesu katep âsagem zei sirâm nâmburân karâmbut oi kwabâ kom kutŋâ Yesu sâwe. Mârum Maria mân kâmboŋ oi ko kot zo sumbem a ŋâiŋâ sapsum dukuip. ");
INSERT INTO kpf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mosegât den zeip, zo luwe. Mariaŋâ kendon ândimŋâ Yosepe sot Yesu katep mem Yerusalem kamânân zâim mamŋâ sot nanŋâ, zet Mosegât den lum sâkzik salek upapkât Anutugâren lâmbaŋ uwet. ");
INSERT INTO kpf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Zorat Kembugât ekabân gurumin den ŋâi itâ ziap, ");
INSERT INTO kpf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","“Kândom narâpziŋâ âsagine Kembugât siŋgi sâbi. Sâmŋâ kembâ patâ zagât mo mâik zagât, zo mem Kembugât siŋgi sâm kom umbi.” Oi zet Kembugât gurumin den zo wâratkum urâwet. ");
INSERT INTO kpf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oi Yerusalem kamânân a ŋâi ândeip, kutŋâ Simeoŋ. Zâk a târârak ândim Isirae a zeŋgâren lumbeŋâ muyagibapkât mambât ândeip. Oi Tirik Kaapumŋâ umŋan gei piksâm den itâ sâm muyagem pindip, ");
INSERT INTO kpf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","“Gâ mân mona Kembu Kristo muyagei ikpan.” ");
INSERT INTO kpf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Oi Tirik Kaapumŋâ okŋaŋgi tirik namin zarip. Zari Maria sot Yosepe, zet Mosegât den lum Yesu katep mem zâiwet. ");
INSERT INTO kpf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Mem zaritâ Simeoŋâ katep zo lumŋâ Anutu itâ sâm mâpâseip, ");
INSERT INTO kpf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Kembu, den sâin, zorat bonŋâ âsagiap. Zorat umnâ âlip oi mumbat. ");
INSERT INTO kpf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sinnandâ kubikkubik a zi eksan. ");
INSERT INTO kpf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kubikkubik a zi hân dâp aŋâ ambânŋâ ziŋâ ikpigât muyagiat. ");
INSERT INTO kpf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Zâkŋâ kwakmak a ambân kamân ŋâin ŋâin ândie, zen âsakŋâ ziŋgâbap. Isirae a neŋgât kutsiŋginiŋâ lum zaatpap.” ");
INSERT INTO kpf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesu katepkât yatâ sâi ibâ mamŋâ zikŋâ nâŋgitâ imbaŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Oi Simeoŋâ Anutu âlip otziŋgâbapkât sâm Maria itâ sâm dukuip, “Katep zirâŋâ Isirae a nâmbutŋâ zâmbari gine nâmbutŋâ ko lum zaatziŋgâbap. Yatâ oi a nâmbutŋandâ sâm bâliŋ kwâkŋaŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Zo yatâ âsagei a doŋbep nâŋgânâŋgâziŋaŋgât topŋâ muyagibap. Oi gâ ko sâknam kâlakŋâ nâŋgâban.” Simeoŋâ Maria den yatâ zo sâm dukuip. ");
INSERT INTO kpf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Oi ambân ŋâi ândeip, kutŋâ Hana, Panuegât bâratŋâ. Aseregât kiurâp zeŋgâren gokŋâ. Katepŋan gâbâ a mem zâk sot ândei kendon nâmburân zagât âki moip. ");
INSERT INTO kpf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Malâ ândim zari kendonŋâ 84 oi sombâ oip. Ambân zo Propete ambân. Zâk tirik namin âsâbâŋ ândimŋâ nalem birâm Anutugâren ninâu nep tuum ândimâip. ");
INSERT INTO kpf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ambân zorâŋâ narâk zoren tirik namin zâim katep ekŋâ Anutu sâm âlip kwâkŋaŋgip. Yerusalem kamânân Kristo muyagibapkât mambât ândiwe, zen Yesu katepkât siŋgi dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Maria sot Yosepe zet Kembugât gurumin den sâsâŋâ, zo op naŋgâm Galilaia hânân, Nasarete kamânân puriksâm âiwet. ");
INSERT INTO kpf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Zoren ândeitâ Anutuŋâ kâtep galem okŋanŋgi lâmbatŋâ kâtigem nâŋgânâŋgâŋâ patâ oip. ");
INSERT INTO kpf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Maria sot Yosepe zet kendon patâ dâp Yerusalem kamânân zâimarâwet. Yuda zeŋgât kendon patâgât zâimarâwet. ");
INSERT INTO kpf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Oi Yesu katep kendonŋâ kiin zagât oi kendongât zâizâiŋ narâk mâte oi diigitâ ârândâŋ zâiwe. ");
INSERT INTO kpf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Zâi ândine kendon âki Maria Yosepe, zet Yesu katep mân nâŋgâm Yerusalem kamânân pâitâ ândei zikŋâ puriksâwet. ");
INSERT INTO kpf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Puriksâm a oserân mârum ariap sâm âi mâtâbân buku torerâpzik zeŋgâren kârum ândeitâ ŋâtiksâip. ");
INSERT INTO kpf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Zeŋgâren mân muyagemŋâ âburem Yerusalem kamânân kârum âiwet. Kârum ândeitâ sirâm zagât âkip. ");
INSERT INTO kpf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Âki ko sirâm karâmbuŋan tirik namin tâi muyagiwet. Zâk zoren Kembugât gurumin den zorat galem a, zeŋgât oserân tap dinziŋâ nâŋgâm topŋaŋgât mâsikâziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Oi a tarâwe, zen aksik nâŋgânâŋgâŋaŋgât sot diŋaŋgât nâŋgâmŋâ imbaŋâziŋ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Zeŋgât oserân tâi ibâ mamŋâ zet ekŋâ pârâk parâwet. Oi mamŋandâ itâ sâm dukuip, “Katep, gâ wangât yatâ otnikat? Oi ibâgoot, net umbâlâ op kârugim ândiet.” ");
INSERT INTO kpf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sâi Yesuŋâ itâ sâm dâzâkoip, “Zet wangât kârunim ândiabot? Nâ Ibânaŋgât nebân ândibatkât sâm nigip. Zet zo dap yatâ mân nâŋgabot?” ");
INSERT INTO kpf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yatâ sâi den zo nâŋgâm kwagâwet. ");
INSERT INTO kpf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Oi ibâ mamŋoot Nasarete kamânân âburem arip. Zoren sâtzik lum kore otzikâm ândeip. Mamŋâ mârum zâkkât diŋâ nâŋgip, zorat nâŋgâmŋik ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu zâk nâŋgânâŋgâ sot sâkŋâ ârândâŋ lâmbat ândei Anutu sot a, zen ek nâŋgâne âlip oip. ");
INSERT INTO kpf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberia Sisa zâk kendonŋâ kiin bâtnâmbut Roma a kutâ op ândei Yohaneŋâ nepŋâ topkwâip. Narâk zoren Pontio Pilatoŋâ Yuda hânân a kutâ ândeip. Herodeŋâ Galilaia hânân a kutâ op ândeip. Zâkkât munŋâ Pilipo, zâk Ituraia sot Trakaniti hânân a kutâ op ândeip. Lisania zâk Abilene hânân a kutâ ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Narâk zoren Hanasi sot Kaipa, zet tirik namâ galem a zeŋgât patâziŋâ op ândiwet. A zo a kutâ sot a sâtŋâ ândiwe. Narâk zorenâk Sakariagât nanŋâ Yohane mirâ kamân âtâŋan ândei Anutuŋâ nep diŋ sâm pindip. ");
INSERT INTO kpf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nep diŋâ sâm pindi Yodaŋ too nâmbut nâmbut âim gam ândim a ambân umziŋ melâŋne too saŋgonziŋgi tosaziŋâ buŋ upapkât dâzâŋgom ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Propete Yesaiŋâ mârum ekabân den ŋâi itâ sâm kulemgui ziap, zorat bonŋâ muyageip. Den zo itâ, “Mirâ kamân âtâŋan a ŋâiŋâ âsagem den patâ itâ sâm muyagem ândiap, ‘Kembugât mâtâp kârâne târârak oik. ");
INSERT INTO kpf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sin dâwe, zo kârâm kwârakune gânduŋ oik. Bak patâ sot mâik kârâm kubikne kelâluŋ oik. Mâtâp gâŋgonâ, zo târârak op naŋgâbap. Bakŋâ sinŋâ kâpunŋâ kârâm kubiknek. ");
INSERT INTO kpf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Oi a ambân aksik Anutugât kubikkubikŋâ, zo ikpi.’” ");
INSERT INTO kpf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Oi a ambân kâmut patâ Yohanegâren âi too saŋgonziŋgâbapkât sâne dâzâŋgom sâip, “Mulumgât kiurâp zen. Bâliŋâziŋaŋgât hâuŋâ takâziŋgâbam uap, zo ŋâiŋâ dâzâŋgoi bâliŋâziŋâ birâbi?” ");
INSERT INTO kpf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Zen umziŋ melâŋ orot mâme âlipŋâ utnek. Oi umziŋan itâ mân nâŋgâbi, “Nen Abaramgât kiurâp, zorat kârâpŋoot mân otniŋgâbap.” Nâ dâzâŋgua nâŋgânek. Anutu zâk sâbâ sâm sâi kât zirâŋ âlip Abaramgât kiurâp upi. ");
INSERT INTO kpf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Zorat sa nâŋgânek Nak ŋâi bonŋâ âlipŋâ mân upap, zo ko mariŋandâ kârâm kârâbân umbamap. Nâŋga zo mârum nak topŋan pâi taap.” ");
INSERT INTO kpf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yatâ sâm dâzâŋgoi a ziŋ mâsikâm sâwe, “Nen dap utnat?” Sâne dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“A ŋâi hâmbâ zâgât mem ândim a ŋâi hâmbâ buŋ ândei ŋâi pindâbap. A ŋâi nalemgât yatâ upap.” ");
INSERT INTO kpf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Oi kât mimiŋâ a, zen yatik gamŋâ too saŋgonziŋgâbapkât mâsikâm sâwe, “Patâ, nen dap utnat?” ");
INSERT INTO kpf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sâne dâzâŋgoip, “A kutâŋâ sâip, yatik mimbi. Walâmŋâ mân mimbi.” ");
INSERT INTO kpf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Oi kâwali a zen yatik gam sâwe, “Nen dap utnat?” Sâne dâzâŋgoip, “Zen a laŋ mân zâŋgom sâkziŋanâk sâm kut ŋâi ŋâiziŋâ mân mimbi. Patâziŋandâ kâtziŋâ ziŋgâbap, zorik nâŋgâne âkâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A ambân zen Yohanegât um zagât opŋâ umziŋan itâ sâwe, “Zâk Kristo mot ŋâi.” ");
INSERT INTO kpf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Sâne Yohaneŋâ itâ sâm dâzâŋgoip, “Nâ tooyâk saŋgonziŋgan. Ka kândâtnan ŋâi gam taap. Zâk kâwali ŋâi zemŋâŋgap. Zâk patâ. Nâ yatâ zorâŋ irâ sikumŋâ laŋaŋga mân dap upap. Zâkŋâ gamŋâ Tirik Kaapum sot kârâp saŋgonziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Zâk sombem gâbâgâbâriŋoot gamŋâ nalem gwapgwapŋâ gâbârem mindubap. Oi nalem bonŋâ kubikŋâ mirâ umŋan pâi tâpap. Iisâk ko gâbârem kârâbân pâi simbap. Oi kârâp zo mân bâpsâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohaneŋâ girem den zo sot den nâmbutŋâ dâzâŋgom ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Den yatâ dâzâŋgom ândimŋâ a kutâ Herode kwâkâŋaŋgâm dukuip. Wangât, zâk munŋaŋgât ambân Herodia bekŋan meip sot bâliŋâ nâmbutŋâ oip, zorat op ko yatâ dukuip. ");
INSERT INTO kpf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Zorat kwâkŋan Herodeŋâ bâliŋâ târokwap Yohane tâk namin pâip. ");
INSERT INTO kpf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yohane tâk namin mân tâip, narâk zoren a doŋbep patâ Yohanegâren gane too saŋgonziŋgi ko Yesu zâk yatigâk ari saŋgonŋaŋgip. Saŋgori kin ninâu sâm tâi sumbem pâroŋsâi Tirik Kaapumŋâ tobatŋâ nii kembâ yatâ op zâkkâren gem gam kwâkŋan pâip. ");
INSERT INTO kpf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Oi sumbemân gâbâ den ŋâi itâ âsagem gâip, “Nannâ, gâ umnandâ gâsugim biraŋmap. Gekŋâ umnâ âlip opmap.” ");
INSERT INTO kpf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu zâk kendon 30 upâ sâi nepŋâ topkwâip. Oi a ziŋâ zâkkât nâŋgâne Yosepegât nanŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Yesugât âseŋâ Eli, zâk Matatagâren gâbâ âsageip. Matata zâk Lewigât kiun. Lewi zâk Melikigât kiun. Zâk Yanaigât kiun. Zâk Yosepegât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zâk Matatiagât kiun. Zâk Amongât kiun. Zâk Nahumgât kiun. Zâk Esiligât kiun. Zâk Nagaigât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Zâk Maatagât kiun. Zâk Matatiagât kiun. Zâk Simeiŋgât kiun. Zâk Yosegât kiun. Zâk Yudagât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zâk Yoanaŋgât kiun. Zâk Resagât kiun. Zâk Serubabegât kiun. Zâk Salatiegât kiun. Zâk Nerigât kiun. Zâk Melikigât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Zâk Adigât kiun. Zâk Kosamgât kiun. Zâk Elimadamgât kiun. Zâk Eregât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Zâk Yosuagât kiun. Zâk Eliesegât kiun. Zâk Yorimgât kiun. Zâk Matatagât kiun. Zâk Lewigât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Zâk Simeoŋgât kiun. Zâk Yudagât kiun. Zâk Yosepegât kiun. Zâk Yonamgât kiun. Zâk Eliakimgât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Zâk Meliagât kiun. Zâk Menagât kiun. Zâk Matatagât kiun. Zâk Nataŋgât kiun. Zâk Dawidigât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Zâk Yesegât kiun. Zâk Obedegât kiun. Zâk Boasigât kiun. Zâk Salagât kiun. Zâk Nasoŋgât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Zâk Aminadabagât kiun. Zâk Adamiŋgât kiun. Zâk Aranigât kiun. Zâk Hezoroŋgât kiun. Zâk Peresegât kiun. Zâk Yudagât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zâk Yakobogât kiun. Zâk Isakagât kiun. Zâk Abaramgât kiun. Zâk Teragât kiun. Zâk Nahogât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Zâk Serukkât kiun. Zâk Reugât kiun. Zâk Pelekkât kiun. Zâk Ebergât kiun. Zâk Selagât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Zâk Kenaŋgât kiun. Zâk Apaksatkât kiun. Zâk Semgât kiun. Zâk Noagât kiun. Zâk Lamekkât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Zâk Metuselagât kiun. Zâk Henokkât kiun. Zâk Yeretkât kiun. Zâk Malaleligât kiun. Zâk Kenaŋgât kiun. ");
INSERT INTO kpf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Zâk Enosigât kiun. Zâk Setkât kiun. Zâk Adamgât kiun. Adam, zâk Anutugâren gokŋâ. ");
INSERT INTO kpf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tirik Kaapumŋâ Yesu umŋan piksâm okŋaŋgi Yodaŋ too birâm barin mirâ kamân âtâŋan âi ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Oi zoren ŋâtik sot sirâm 40 ândei Sataŋŋâ mâsikâm ândeip. Oi narâk zoren nalem buŋ ândimŋâ tepŋaŋgât oip. ");
INSERT INTO kpf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tepŋaŋgât oi Sataŋŋâ itâ sâm dukuip, “Gâ Anutugât nanŋâ ândiat oi ko kât zirâŋ sâna nalem oi ne.” ");
INSERT INTO kpf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yatâ sâi ko Yesuŋâ itâ sâm dukuip, “Kembugât ekabân den ŋâi itâ ziap, ‘Aŋâ nalemâk nem mân ândinat.’” ");
INSERT INTO kpf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sâi ko Sataŋŋâ bak kârep ŋâin diim zâim hân dâp a kâmut kâmutŋâ sot sikum kut ŋâi ŋâi âkŋâleŋoot, zo tirâpkoip. ");
INSERT INTO kpf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Oi itâ sâm dukuip, “Imbaŋâ sot kutsiŋgiziŋ patâ zemziŋgâm ariap, zo gâ gibat. Zo nâgât bitnan pâipkât ŋâi mo ŋâi pindâbâ sâm âlip pindâbat. ");
INSERT INTO kpf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Zorat gâ umnâ topŋan ga pindiŋsâna gâgât op naŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sâi Yesuŋâ itâ sâm dukuip, “Den kulem ŋâi itâ ziap, ‘Gâ Kembu Anutugâ kânok mâpâsiban. Zâk kânok kore okŋaŋgâban.’” ");
INSERT INTO kpf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sâi Sataŋŋâ Yerusalem kamânân tirik namâŋ pum kwâkŋan pâi kiri itâ sâm dukuip, “Gâ Anutugât nanŋâ ândiat oi ko zibâ pâtan gei. ");
INSERT INTO kpf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Den kulem ŋâi itâ zo ziap, zo naŋgâ, ‘Anutu zâkŋâ sumbem arâp zeŋgât bitziŋan gâbanbap. ");
INSERT INTO kpf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ziŋâ bitziŋandâ mingim geine kâtŋâ mân gobap.’” ");
INSERT INTO kpf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sâi Yesuŋâ itâ sâm dukuip, “Den ŋâi itâ ziap, ‘Kembu Anutugâ zâizâiŋ mân okŋaŋgâban.’” ");
INSERT INTO kpf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sataŋŋâ den top topŋâ sâm mâsikamŋâ birâm narâk ŋâigât mambât ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tirik Kaapumŋâ Yesu mam okŋaŋgi Galilaia hânân âbureip. Âburei den siŋgiŋâ kamân dâp nâŋgâm naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Oi kamân dâp mâpâmâpâse namin zâimŋâ siŋgi âlip dâzâŋgomâip. Dâzâŋgoi a ambân ziŋâ sâm bâbâlaŋ kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ândim âimŋâ kamânŋâ Nasarete, zoren âi yatik kendon ŋâin mâpâmâpâse namin zarip. Zâk kendon dâp yatâ opmâip. Namâ kâligen zâim den sâlâpkum ziŋgâbam zaarip. ");
INSERT INTO kpf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Zaari ko Propete Yesaia, zâkkât ekap pindâwe. Pindâne mâbâlakŋem den itâ zeip, zo muyageip. ");
INSERT INTO kpf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kembugât Kaapumŋâ nâgâren ga tap nep itâ sâm nigip, ‘A gigiŋâ siŋgi âlip dâzâŋgoban. Tâk namin zâmbarâwe, zo olaŋziŋgâban. Sinziŋ bâpsâsâŋ sinziŋ mem kubikziŋgâban. A kâbakŋeziŋgâwe, zo luziŋgâban. ");
INSERT INTO kpf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kembu betniŋan mimbapkât narâkŋâ mâte uap, zorat dâzâŋgoban.” ");
INSERT INTO kpf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Den yatâ sâlâpkumŋâ Yesuŋâ ekap namuŋ ekap galem a pindâm ge tâip. Tâi ko a mâpâmâpâse namin tarâwe, zen aksik patâ zâkkâren sen kwap Yesu igâwe. ");
INSERT INTO kpf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Oi den itâ topkwap dâzâŋgoip, “Kembugât den sâlâpkua nâŋge, zo itârâŋ bonŋâ âsagiap.” ");
INSERT INTO kpf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sâi zen diŋâ nâŋgâne kelâkŋoot oi imbaŋâziŋ buŋ oip. Oi ko itâ sâwe, “A zi Yosepegât nanŋâ, zo ka.” ");
INSERT INTO kpf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Sâne itâ sâip, “Zen nâgât den sumbuŋâ kom itâ sâbi, ‘Gâ sisi mâsek kubikkubik a ândiat oi ko gikâ sâkkâ kubikpan. Kapenaum kâmânân a ambân kubikziŋgâna siŋgigâ nâŋgâwen. Zo yatik kamângan tuuna iknâ.’” ");
INSERT INTO kpf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yatâ sâmŋâ sâip, “Nâ perâkŋak dâzâŋgobâ. Propete ŋâi zik kamânŋan nep tuugi nâŋgâne yenŋâ opmap. ");
INSERT INTO kpf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Oi perâkŋak dâzâŋgobâ. Propete Elia ândei maa patâ kendon patâ karâmbut sot kâin nâmburân kânok yatik kiri pu patâ âsagem hân dâp op zeip. Oi narâk zoren Isirae hânân ambân malâ doŋbep ândiwe. ");
INSERT INTO kpf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ka Anutuŋâ Elia sâŋgongoi Sareta kamân Sidoŋ hânân ambân malâ ŋâi ândeip, zâkkâren arip. ");
INSERT INTO kpf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Oi Propete Elisa ândeip, narâk zoren Isirae hânân sâk bâlâ a doŋbep ândiwe. Oi zeŋgâren gâbâ ŋâiŋâ mân âlip oi Naemaŋ, Siria hânân gok, zâk kânok âlip oip. ");
INSERT INTO kpf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","29","Yatâ sâm dâzâŋgoi a ambân mâpâmâpâse namin tarâwe, zen kuk opŋâ Yesu gâsum diim kamân kândâtŋan âim bakŋâ sim ŋâi kiribân pânam urâwe. ");
INSERT INTO kpf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pânam utnetâ zâkŋâ puriksâm osetziŋan gâbâ arip. ");
INSERT INTO kpf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Galilaia hânân kamân ŋâi tâip, kutŋâ Kapenaum. Yesu zâk zoren âi takâm kendonân den sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Den dâzâŋgoi a ambân zen diŋâ nâŋgâmŋâ itâ nâŋgâwe, “Zâk siŋgi âlip mariŋâ yatâ den imbaŋâŋoot sâm dâtnâŋguap.” Yatâ nâŋgâm imbaŋâziŋ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Oi mâpâmâpâse namin a wâkeŋoot ŋâi tâip. Wâkeŋâ Yesu ekŋâ den yu kambâŋ sâm sâip, ");
INSERT INTO kpf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yei, Yesu Nasarete gokŋâ, wan otniŋgâbam gaat? Gâ tâmbetnâŋgobam gaat? Nâ topkâ nâŋgan. Gâ Anutugât tirik a.” ");
INSERT INTO kpf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yatâ sâi Yesuŋâ den okŋaŋgâm sâip, “Gâ hiriŋsâmŋâ ayân gâbâ takâm âi.” Yatâ sâi wâkeŋâ a laŋ kâbakŋei a ambân mâteziŋan gei zei arip. Oi a zo mân tâmbetkoip. ");
INSERT INTO kpf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Oi a zen ekŋâ imbâŋâziŋ buŋ oi âragwâragu op sâwe, “Den zi dap dap? Zâk imbaŋâ patâŋâ wâke den dâzâŋgoi takâm âime.” ");
INSERT INTO kpf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Oi siŋgiŋâ kamân dâp laŋ kârâm arip. ");
INSERT INTO kpf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu zâk zaat mâpâmâpâse namin gâbâ gemŋâ Simoŋgât mirin zarip. Zoren Simoŋ sibunŋâ mâsek okŋaŋgi sâkŋâ kârâp op zeip. Oi zâkkât opŋâ Yesu dukuwe. ");
INSERT INTO kpf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Oi Yesuŋâ gootŋan âi kinŋâ mâsek den dukui birâŋaŋgip. Oi ambân zo zorenâk zaat nalem om ziŋgâziŋgâ oip. ");
INSERT INTO kpf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mirâsiŋ giari a ambân ziŋâ bukurâpziŋ sisi mâsek, zo Yesugâren diiziŋgâm gane bikŋâ kâukziŋan pam mâsek mem sândukŋan kwatziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Oi a ambân doŋbep wâkeziŋâ moliziŋgip. Wâke zen a zeŋgâren gâbâ gam den kambâŋâ sâm itâ sâwe, “Gâ Anutugât nanŋâ.” Yatâ sânam utne mân sâbigât dâzâŋgoip. Zen topŋâ nâŋgâne Kristo oip. Zo sapsubegât sâip. ");
INSERT INTO kpf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mirâ haŋsâi mirin gâbâ gemŋâ a mân ândiândiŋan, zoren arip. Oi a ambân zen kârum âim muyagem zen sot ândibapkât aŋgân kârâne itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","“Kamân toren toren zie, zoren âi Anutugât um topŋan ândiândigât den siŋgi âlipŋâ dâzâŋgobat. Nâ nep zo tuubatkât saŋgonnogi gewan.” ");
INSERT INTO kpf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yatâ sâm Yuda zeŋgât mâpâmâpâse namâ tap arip dâp den siŋgi âlip dâzâŋgom ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Narâk ŋâin Yesu Genesarete saru sâtŋan âi kiri a ambân Anutugât den nâŋgânam ga minduŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Minduŋaŋgâne kiri waŋgâ zagât saru sâtŋan tâitâ egip. Waŋgâ mâirâp, zen waŋgâyân gâbâ gem irâ too saŋgon kirâwe. ");
INSERT INTO kpf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesuŋâ waŋgâ zo egip. Ŋâi Simoŋgât siŋgi, zorâŋ zâim dukui waŋgâ zo mâik ŋâi aline ari zoren kin siŋgi âlip sâm dâzâŋgoip. Oi a ambân zen sagân tapŋâ nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Dâzâŋgomŋâ Simoŋ itâ sâm dukuip, “Saruyân âimŋâ zuu sâmbubigât irâ pane giarik.” ");
INSERT INTO kpf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sâi Simoŋâ itâ sâm dukuip, “Patâ, nen ŋâtik nep tuum ândim zuu ŋâi mân mien. Laŋ gâgât sâtkâ lum âi irâ dum pâmbat.” ");
INSERT INTO kpf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Oi irâ pane giari zuu doŋbep piksâne sâmbum osine irâ ânâŋgâtpam oip. ");
INSERT INTO kpf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sâmbum osimŋâ bukurâpziŋ waŋgâ ŋâin tarâwe, zeŋgât kwâbâlap tuune gam betziŋan miwe. Zo sândune waŋgâ zagât piksâm saruyân geibam oip. ");
INSERT INTO kpf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoŋ Petero, zâk zo ekŋâ keŋgât op Yesugât um topŋan âi pindiŋsâm sâip, “Kembu, nâ bâliŋ mâme a, zorat gâ birânim âi.” ");
INSERT INTO kpf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Zuu imbaŋâ zo ekŋâ imbaŋâŋâ buŋ oi ko yatâ sâip. ");
INSERT INTO kpf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Oi bukuzatŋâ Zebedaiogât nanzatŋâ Yakobo sot Yohane sot a nambutŋâ, zen yatik imbaŋâziŋ buŋ oip. Oi Yesuŋâ Simoŋ itâ sâm dukuip, “Gâ mân keŋgât ot. Gâ saru zuugât nep tuum ândein, yatigâk ayân nep tuum ândiban.” ");
INSERT INTO kpf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yatâ sâi zeŋgât waŋgâ sagân sâmbune zari kut ŋâi ŋâi zo birâm Yesu molim âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu zâk kamân ŋâin âi ândei sâk bâlâ a ŋâiŋâ ekŋâ ga kiŋ topŋan pindiŋsâm zem itâ sâm mâpâseip, “Kembu, gâ imbaŋâgâ ziap, zorat gâ kubiknibâ sâm âlip kubikniban.” ");
INSERT INTO kpf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sâi Yesuŋâ bikŋandâ sâkŋan weemŋâ sâip, “Nâ nâŋgâgigan. Bâi, sâkkâ âlip oik.” Sâi zorenâk sâkŋâ âlip op useŋâ sogeip. ");
INSERT INTO kpf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Oi Yesuŋâ den itâ sâm dukuip, “Gâ âlip uat, zorat den siŋgi a ambân mân dâzâŋgom âim sâkkâ tirik namâ galem a tirâpkuna ikpap. Oi âlip uat, zorat Mosegât den zo lum nii mo zuu ŋâi mem ko Kembugât siŋgi sâm tirik namâ galem a pindânan. Usegâ sogiap, zo a ambân ek nâŋgâbigât yatâ otnan.” ");
INSERT INTO kpf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Oi a âlip oip, zorat den siŋgi kamân dâp ari a zen nâŋgâm Yesugât diŋâ nâŋgâbigât sot kubikziŋgâbapkât zâkkâren mindum gawe. ");
INSERT INTO kpf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ka Yesu ko barâ katikŋâ mirâ kamân âtâŋan âim ninâu sâm ândimâip. ");
INSERT INTO kpf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sirâm ŋâin Yesuŋâ a den siŋgi âlip dâzâŋgom tâi Galilaia hânân gâbâ, Yuda hânân gâbâ sot Yerusalem kamânân gâbâ Parisaio a sot Kembugât gurumin den zorat galem a, zen ga a osetziŋan tarâwe. Tatne Kembugât imbaŋandâ Yesu mam okŋaŋgi a kubikziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","A nâmbutŋandâ a kiŋ bik mumuŋâ helâŋ aam pam mem gawe. Oi mirâ kâligen baginam utnetâ a doŋbep mindum tatne kwagâwe. ");
INSERT INTO kpf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yatâ opŋâ mirâ kwâkŋan zâim ogep kwâsat pane a zo helâŋoot pane Yesugât sâŋgânŋan geip. ");
INSERT INTO kpf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yatâ utnetâ Yesuŋâ nâŋgâm pâlâtâŋziŋaŋgât topŋâ ekŋâ a zo itâ sâm dukuip, “Arâ tosagâ biran.” ");
INSERT INTO kpf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sâi Kembugât gurumin den zorat galem a sot Parisaio, zen den zo nâŋgâm itâ nâŋgâwe, “A zi dap yatâ? Zâk Anutu hutkum sap. Tosa birâbirâŋ, zo Anutu zik kânok.” ");
INSERT INTO kpf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yatâ nâŋgâne Yesuŋâ umziŋan den zo nâŋgâm itâ sâm dâzâŋgoip, “Umziŋan wangât den yatâ zo nâŋge? ");
INSERT INTO kpf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Zen dap nâŋge? Nep ikâ zorâŋ bâbâlâŋ? Tosa birâbirâŋ mo sâk kubikkubik? ");
INSERT INTO kpf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","A bonŋâ nâ hânân ândim tosa birâbatkât imbaŋâ zemnigap, zorat topŋâ ikpigât den zo dukuan.” Yatâ sâmŋâ a kiŋ bik mumuŋâ itâ sâm dukuip, “Nâ dâgoga zaat isen koremgâ mem kamângan âi.” ");
INSERT INTO kpf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yatâ sâi zorenâk mâteziŋan zaatŋâ isenŋâ mem âim Anutu mâpâseip. ");
INSERT INTO kpf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Oi a zen zo ekŋâ nâŋgâne imbaŋâ oi Anutu mâpâsem keŋgât op sâwe, “Itârâŋ sen pup muyagei iksen.” ");
INSERT INTO kpf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Oi Yesu mirin gâbâ gemŋâ arip. Âimŋâ kât mimiŋ a ŋâi, kutŋâ Lewi, kât pâpan mirâŋan tâi ekŋâ itâ sâm dukuip, “Gâ nâ sot pâlâtâŋ op molini.” ");
INSERT INTO kpf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sâi Lewi zâk zaatŋâ kut ŋâi ŋâiŋâ birâm Yesu molim arip. ");
INSERT INTO kpf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewiŋâ mirâŋan Yesugât sii nalem om kât mimiŋ a doŋbep sot a nâmbutŋâ sâi ârândâŋ ga niwe. ");
INSERT INTO kpf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisaio a sot Kembugât gurumin den zorat galem a, zen gamŋâ nâŋgâne mân dâp oi Yesugât arâpŋâ itâ sâm mâsikâziŋgâwe, “Zen wangât kât mimiŋ a sot bâliŋ mâme a, zen sot nalem nie?” ");
INSERT INTO kpf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sâne Yesuŋâ nâŋgâm itâ sâm dâzâŋgoip, “Sisi mâsek kubikkubik a zen a sâk gwâlâ zeŋgâren nep mân tuume. A mâsekziŋoot zeŋgâren âimŋâ nep tuume. ");
INSERT INTO kpf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","A ziiŋaŋgât sâme, ‘Nen âlipŋâ.’ Nâ zeŋgât buŋâ. Bâliŋ mâme a diiziŋga umziŋâ melâŋbigât gem gâwan.” ");
INSERT INTO kpf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yesuŋâ den yatâ sâi zen itâ sâm dukuwe, “Yohane arâpŋâ, zen nalem birâm ninâu sâm ândime. Parisaio zeŋgoot yatik upme. Ka gâgât arâpkâ, zen ko nalem too laŋ nime.” ");
INSERT INTO kpf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yatâ sânetâ itâ sâm dâzâŋgoip, “A kutâŋâ arâpŋoot ândei zen nalem mân birâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ândimŋâ a kutâ betziŋan mine kârubi, narâk zoren ko umbâlâ op nalem birâm ândibi.” ");
INSERT INTO kpf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yatâ sâmŋâ den sumbuŋâ torenŋâ itâ sâm dâzâŋgoip, “Ŋâiŋâ hâmbâ uŋakŋan gâbâ mânâŋgât hâmbâ sâŋgiŋan gâribap? Ŋâi zo yatâ op sâi hâmbâ uŋakŋâ zo tâmbetkubap. Oi hâmbâ irakŋandâ sâŋgiŋan ari tobat ŋâi opap. ");
INSERT INTO kpf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Oi waiŋ too uŋakŋâ hâkop sâŋgiŋan mân gune geimap. Yatâ upi, zo ko waiŋ too uŋakŋâ zorâŋâ hâkop sâŋgiŋâ kunziri waiŋ sot hâkop ârândâŋ buŋ upabot. ");
INSERT INTO kpf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Zorat waiŋ too uŋakŋâ hâkop uŋakŋan giari dâp upap. ");
INSERT INTO kpf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Oi ŋâi zâk waiŋ sâŋgiŋâ nemŋâ umŋâ oip, zâk uŋakŋâ nem birâbap. Oi zâk itâ sâbap, ‘Sâŋgiŋâ nia naam uap.’” ");
INSERT INTO kpf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kendon ŋâin Yesu sot arâpŋâ, zen kâlamân obândiwe. Âimŋâ arâp zen segoŋ bonŋâ kânok kânok kwâkâm niwe. ");
INSERT INTO kpf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yatâ utne Parisaio a ziŋâ ziŋgitŋâ sâwe, “Zen wangât kendonân mân orotŋâ ue?” ");
INSERT INTO kpf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Dawidi sot arâpŋâ nalemgât mom urâwe, zo sâlâpkume mo buŋâ? ");
INSERT INTO kpf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dawidi zâk Kembugât namâ zoren zâimŋâ Anutugât nalem hâlâlu sâsâŋ, zo mem nemŋâ arâp ziŋgi niwe. Zo mân orotŋâ. Nalem zo tirik namâ galem a ziiŋik nimbigât sâsâŋ. A nâmbutŋâ mân nimbigât sâsâŋ. Dawidi sot arâpŋâ zen nalem zo laŋ niwe.” ");
INSERT INTO kpf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yatâ sâmŋâ sâip, “A bonŋâ nâ kendongât mariŋâ ândian.” ");
INSERT INTO kpf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Oi kendon ŋâin Yesuŋâ mâpâmâpâse namin zâim den siŋgi âlip dâzâŋgoip. Oi zoren a ŋâi tâip, zâk bikŋâ bongen humutŋik. ");
INSERT INTO kpf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Oi Kembugât gurumin den zorat galem a sot Parisaio, zen kendonân a ŋâi kubigi ekŋâ denân pânat sâm ek tarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Oi Yesuŋâ nâŋgâŋaŋgâziŋan ek a bik humutŋik itâ sâm dukuip, “Zaat mâteyâk kin.” Sâi zaat kirip. ");
INSERT INTO kpf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Oi Yesuŋâ a itâ sâm dâzâŋgoip, “Nâ mâsikâziŋga sânek. Kendonân nep ikâ zorâŋ âlip tuutuuŋ? A kubikziŋgâziŋgâŋ mo a tâmbetzâŋgozâŋgoŋ?” ");
INSERT INTO kpf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yatâ sâm purikgurik op kin ziŋgitŋâ a zo itâ sâm dukuip, “Bikâ târârak pa.” Sâi a zo yatâ oi bikŋâ âlip oip. ");
INSERT INTO kpf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Oi zen zo ek nâŋgâm kuk opŋâ dap mo dap okŋaŋgânâ sâm âraguwe. ");
INSERT INTO kpf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Narâk zoren Yesu ninâu sâbam bâkŋan zarip. Ŋâtik Anutu ninâu dukum tâi haŋsâip. ");
INSERT INTO kpf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Haŋsâi arâp minduziŋgâm zeŋgât oserân gâbâ a kiin zagât gâsum sâlâpzâŋgoip. Oi kutziŋâ Aposolo sâip. ");
INSERT INTO kpf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kutziŋâ itâ, Simoŋ, kutŋâ ŋâi Petero pindip. Zâk sot munŋâ Andrea, Yakobo, Yohane, Pilipo, Batolomaio. ");
INSERT INTO kpf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataio, Toma, Yakobo Alipaiogât nanŋâ sot Simoŋ Zelote. ");
INSERT INTO kpf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Oi Yuda Yakobogât nanŋâ sot Yuda Karioto kamânân gok. Yuda zâk ândim Yesu tirâpzâŋgoi gâsuwe. ");
INSERT INTO kpf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuŋâ a zo diiziŋgâm gem hân gânduŋan ga kin Yesugât a ambârâpŋâ doŋbep sot Yuda hânân gâbâ sot Yerusalem kamânân gâbâ sot Tiro Sidoŋ saru sâtŋan zeŋgâren gâbâ a ambân doŋbep, zen takâm diŋâ nâŋgâbigât sot mâsekziŋ kubikziŋgâbapkât zâkkâren minduwe. ");
INSERT INTO kpf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Oi wâkeziŋoot zo kubikziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yesugât imbaŋâŋandâ zeŋgâren ari kubikziŋgip, zorat a ambân aksik sâkŋan gâsunam urâwe. ");
INSERT INTO kpf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesuŋâ arâpŋâ ziŋgit itâ sâip, “Kanpitâ ândime, zeŋgât nâŋga sâtâreŋoot uap. Zen Anutugât kiŋ topŋan ândibigât siŋgi ue. ");
INSERT INTO kpf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Narâk itârâŋ tepkât op ândime, zeŋgât nâŋga sâtâreŋoot uap. Zo zen gâtâm nalem nem âkon upi. Narâk ziren isem weŋ ândime, zeŋgât nâŋga sâtâreŋoot uap. Zen gâtâm sâtâre op girâŋ ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","A ziŋâ zen a bonŋâ nâgât op um kâlak otziŋgâm kâbakŋeziŋgâm sâm bâliŋan kwatziŋgâbi, zorat zeŋgât nâŋga sâtâreŋoot uap. ");
INSERT INTO kpf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yatâ otziŋgâne narâk zoren umâlep op sâtâreyân kep kumbi. Wangât, gâtâm sumbemân sâŋgân patâ mimbi, zorat. A mârumŋan ândiwe, zen yatik Propete sâm bâliŋ kwatziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ka narâk ziren sikumziŋ patâ ândime, yei, zen wanŋâ mem sândukŋan kwatziŋgâbap? ");
INSERT INTO kpf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Narâk itârâŋ sii nalem gom sambe ândime, yei, zen gâtâm tepkât op ândibi. Narâk ziren umâlibân girâŋ ândime, yei, zen gâtâm âigirâp muyagem ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","A ambân zen aksik sâm âlipŋan kwatziŋgâme, yei, zen dap upi? A mârum ândiwe, zen propete sarâŋâ yatik sâm âlip kwatziŋgâm ândiwe.” ");
INSERT INTO kpf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Dinnâ nâŋgâm te, zen dâzâŋgobâ. Zen kâsarâpziŋ buku otziŋgâbi. Um kâlak otziŋgâme, zo ziŋâ âlip otziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sâm bâliŋan kwatziŋgâme, zo ziŋâ sâm âlipŋan kwatziŋgâbi. Bâliŋ otgime, zeŋgât op ninâu sâban. ");
INSERT INTO kpf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","A ŋâi pâlomgâ kunziri toren pindâban. Ŋâiŋâ hâmbâgâ kwâkŋan mei kâligen mân aŋgân kârâban. ");
INSERT INTO kpf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Oi a ŋâiŋâ wan mo wangât sâi pindâban. Ŋâiŋâ kut ŋâi zo bekan mei mâburem nibangât mân sâban. ");
INSERT INTO kpf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","A torenŋâ ziŋ âlip otgibigât nâŋgâmat, yatigâk gâŋgoot a torenŋâ otziŋgâban. ");
INSERT INTO kpf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Zen a toren umziŋâ gâsâzâŋgone zeŋgoot umziŋâ gâsuziŋgâmap. Zen yatâ upi, zo ko Anutuŋâ sâŋgânŋâ mân ziŋgâbap. Bâliŋ mâme a, ziŋ yatâ upme, zo ka. ");
INSERT INTO kpf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Zen buku otziŋgâme, zorik otziŋgâbi, zo ko Anutuŋâ sâŋgânŋâ mân ziŋgâbap. Bâliŋ mâme a zen yatâ upme, zo ka. ");
INSERT INTO kpf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kut ŋâi ŋâi a ziŋgâm zorat hâuŋâ sâne ziŋgâbi, zorat Anutuŋâ hâuŋâ mân ziŋgâbap. Bâliŋ mâme a zen bukurâpziŋâ itâ sâm otziŋgâme. ‘Gâtâm gâŋgoot hâuŋâ mâburem niban.’ ");
INSERT INTO kpf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Zen ko walâm itâ upi. Zen kâsarâpziŋ umziŋandâ gâsâzâŋgom buku otziŋgâbi. Kut ŋâi ŋâi ziŋgâm zorat hâuŋâ mân mimbi. Yatâ utnetâ Anutuŋâ sâŋgânŋâ patâ ziŋgâbap. Ziŋgi ko zen Kembugât nan bârat op ândibi. Kembuŋâ a gulipŋâ sot bâliŋ mâme a, zo âlip otziŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sumbem Ibâziŋandâ um lâklâk ândiap, yatigâk zeŋgoot hânân um lâklâk ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","A torenŋâ zeŋgât top likuliku mân utne Anutugoot zeŋgât topziŋâ mân likubap. Gâ a torenŋâ mem ge kwâkwat mân otziŋgâna ko Anutugoot gâ mem ge kwâkkwat mân otgibap. Zen a zeŋgât tosa birânetâ Anutuŋâ zeŋgât tosa yatik birâbap. ");
INSERT INTO kpf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Zen a kut ŋâi ŋâi ziŋgâne Anutuŋâ yatigâk kut ŋâi ŋâi doŋbep patâ ziŋgâbap. Oi zorat dâp buŋâ, walâm ziŋgâbap. Zen a otziŋgâne Anutuŋâ zo yatik zen otziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Den sumbuŋâ ŋâi itâ târokwap dâzâŋgoip, “A sen ŋâtâtik ŋâiŋâ a bukuŋâ sen ŋâtâtik mâtâp tirâpkubap? Buŋâ. Zet mâtâbân âim ârândâŋ simân geibabot. ");
INSERT INTO kpf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ekap namin katep ŋâiŋâ kwâkâm pindâmap, zo mân walâbap. Ka katep zâk nâŋgâm nâŋgâm ândim kwâkâm pindâm ândibap, zâkkât holi yatâ upap. ");
INSERT INTO kpf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Gâ wangât bukugaŋgât siŋan gwapgwap zo ek gikâ siŋgan nak sâmbaŋâ mân ek nâŋgat? ");
INSERT INTO kpf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nak sâmbaŋâ siŋgan zei dabângen bukugâ itâ dukuna dâp upap, ‘Buku, nâŋgâna siŋgan gwapgwap ziap, zo mem pambâ.’ Gâ sarâ a. Gikâ siŋgan nak sâmbaŋâ ziap, zo mem pam ko bukugaŋgât siŋan gwapgwap mem pâna dâp upap.” ");
INSERT INTO kpf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nak âlipŋan bonŋâ bâliŋâ mân muyagemap. Nak bâliŋan bonŋâ âlipŋâ mân muyagemap. ");
INSERT INTO kpf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nakkât bonŋandâ sapsumap. Sâŋgerân bolep bonŋâ âsagei minat mo? Zâlâliyân sam bonŋâ muyagei mimbi mo? ");
INSERT INTO kpf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A âlipŋandâ umŋan gâbâ den âlipŋâ sâmap. A bâliŋandâ umŋan gâbâ den bâliŋâ sâmap. A umŋan kut ŋâi ŋâi ziap, zo yatik lâuŋan gâbâ kopgâmap.” ");
INSERT INTO kpf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Zen wangât lâuziŋandik Kembuniŋâ, Kembuniŋâ sâmŋâ den dâzâŋgoman, zo mân lume? ");
INSERT INTO kpf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nâgâren gam dinnâ nâŋgâm lume, zen mirâ tuutuuŋ a ŋâi, zâkkâren dâpkwap sa nâŋgânek. ");
INSERT INTO kpf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","A zorâŋ mirâ tuubam tandâ kârep esi giari kât muyagem kwânâŋgâm sâratkui kirip. Oi mirâ tuum naŋgi kiri map narâk oi pibâ patâ koi mirâ zo kâtikŋâ tuugipkât kom osei kirip. ");
INSERT INTO kpf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ka a dinnâ nâŋgâm birâme, zen a ŋâi mirâ lolot tuugip, zo yatâ. A zo mirâ tuubam tandâ sarâ sarâ esi giari ko mirâ tuugip. Oi map narâkŋâ oi pibâ patâ gamŋâ mem sânsân tuugi kom giligâlak meip.” ");
INSERT INTO kpf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu zâk a ambân den dâzâŋgomŋâ Kapenaum kamânân bageip. ");
INSERT INTO kpf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Zoren kâwali a patâziŋâ zâkkât kore a mâsek op mumbam op zeip. Kâwali a patâ, zâk kore a zorat eluŋ okŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Zorat Yesugât den siŋgi nâŋgâm Yuda a patâ ziŋâ Yesu diine ga mâsek a kubikŋaŋgâbapkât sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yuda a patâ Yesugâren gamŋâ itâ sâm dukuwe, “Kâwali a patâ, zâk ândiândi târârak ândimapkât diŋâ nâŋgâban. ");
INSERT INTO kpf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Zâk umŋâ Yuda neŋgâren kinmap. Mâpâmâpâse namâniŋâ muyagibapkât zâkŋak kâtigem kât pâi muyageip.” ");
INSERT INTO kpf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yatâ sâne Yesuŋâ zen sot arip. Âimŋâ mirâ mâte upâ sâi kâwali a zo bukurâpŋâ sâŋgonzâŋgoi Yesugâren gam itâ sâm dukuwe, “Kâwali aŋâ itâ sap, ‘Gâ nâgâren mân gâban. Nâ wandâ yatâ, zorat op mirânan mân gâban. ");
INSERT INTO kpf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ninaŋgât nâŋga mân dâp oi gâgâren gâbam kwaksan, gât ko gâ zorenâk tap ko denâk sâna kore anâ âlip upap. ");
INSERT INTO kpf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nâ a kutâ zeŋgât kore a ândim sâtziŋ luman. Oi ombenan kore arâpnâ ândie. Oi zeŋgâren gâbâ ŋâi âi sa âibap. Ŋâi ga sa gâbap. Oi kore anâ yatâ tuuban sa tuubap.’” ");
INSERT INTO kpf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesuŋâ den zo nâŋgi imbaŋâ oi a ambân kâmut kirâwe, zeŋgâren puriksâm itâ sâm dâzâŋgoip, “Nâ dâzâŋgua nâŋgânek. Isirae a zeŋgâren nâŋgâm pâlâtâŋ itâ ŋâi mân muyageman.” ");
INSERT INTO kpf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yatâ sâi ko kâwali a bukurâpŋâ zen âburem âim mirin zâim igâwe. Iknetâ kore a zo âlip oip. ");
INSERT INTO kpf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mâik ŋâi ândim Yesuŋâ kamân ŋâi kutŋâ Naiŋ, zoren ari arâpŋâ sot a ambân kâmut patâ molim âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kamânân baginam utnetâ a mumuŋâ ŋâi lum gawe. Ambân malâ ŋâigât nanŋâ kânok, zâk moip. Zâk hangunam kamânân gâbâ a ambân doŋbep gem gawe. ");
INSERT INTO kpf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Oi Kembuŋâ ambân malâ zo ekŋâ umŋâ nâŋgâmŋâ sâip, “Mân ise.” ");
INSERT INTO kpf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yatâ sâmŋâ âi omboŋan gâsui mem kine itâ sâip, “Katep, dâgoga zaat.” ");
INSERT INTO kpf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yatâ dukui mumuŋandâ zaatŋâ den den oip. Oi Yesuŋâ mamŋâ pindip. ");
INSERT INTO kpf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Oi a ambân, ziŋâ zo ekŋâ keŋgât op Anutu mâpâsem itâ sâwe, “Propete patâ osetniŋan âsagem ândiap.” Oi nâmbutŋandâ itâ sâwe, “Anutu, zâk a ambân gakârâp galemniŋ opmap.” ");
INSERT INTO kpf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Oi zorat den siŋgiŋâ Yuda hânân sot kamân toren toren dâp op arip. ");
INSERT INTO kpf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohane zâk tâk namin tâi arâpŋâ zen Yesugât den siŋgi zo âi dukuwe. ");
INSERT INTO kpf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Den zo nâŋgâm azatŋâ zagât Kembu itâ sâm mâsikâbabotkât sâŋgonzâkoip, “Mârumŋan Propete a ziŋâ a ŋâi gâbapkât sâwe, zo gâ mo ŋâi gâbapkât ek ândinat?” ");
INSERT INTO kpf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sâŋgonzâkoi Yesugâren âim itâ sâwet, “Yohane too saŋgonziŋgip, zâk itâ sâm sâŋgonnâkuap, ‘A gâbapkât sâsâŋâ, gâ mo ŋâigât mambât ândinat?’” ");
INSERT INTO kpf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Narâk zorenâk Yesu zâk a sisi mâsekziŋoot sot sinziŋ bâpsâsâŋ a doŋbep kubikziŋgip. A wâkeziŋoot zo wâke moliziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Oi Yohanegât azatŋâ itâ sâm dâzâkoip, “Zet âimŋâ kut ŋâi ŋâi ek nâŋgabot, zorat den siŋgi Yohane dukuit. Sinziŋ bâpsâsâŋ, zen ikme. Kinziŋ bâliŋâ, zen obândime. Um sâk bâlâ, zen âlipziŋ upme. Kindapziŋ bâpsâsâŋ, zen den nâŋgâme. Mumuŋâ, zen zaatme. A ambân kanpitâ, ziŋâ den siŋgi âlipŋâ nâŋgâme. ");
INSERT INTO kpf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ŋâi zâk nâgât nâŋgi mân âkon opmap, zâkkât nâŋga sâtâreŋoot upap.” ");
INSERT INTO kpf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","25","Oi Yohanegât azatŋâ zet aritâ Yesuŋâ a amban ândiwe, zo Yohanegât topŋâ itâ sâm dazaŋgoip, “Zen barâ kâtikŋâ mirâ kamân âtâŋan wan iknam âiwe? Zen gerâ ŋâi pibâŋâ kom kâbakŋei iknam âiwe? Mo a ŋâi hâmbâŋâ neuleŋoot iknam âiwe? Nâŋge. A hâmbâ neuleŋoot mem ândime, zen a kutâ namin tâtat mâme âlip tapme. ");
INSERT INTO kpf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mo Propete ŋâi iknam âiwe. Zorat nâ dâzâŋgua nâŋgânek. A igâwe, zo Propete nâmbutŋâ zen yatâ buŋâ. Zâk Propete a nâmbutŋâ walâziŋgap. ");
INSERT INTO kpf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Zâkkât den kulem ŋâi itâ ziap, ‘Nâŋgâ. Nâgât kore a ŋâi sâŋgongua kândom otgibap. Zâkŋâ mâtâpkâ kârâm kubikpap.’ ");
INSERT INTO kpf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nâ perâkŋak dâzâŋgua nâŋgânek. Ambânân gâbâ âsagiwe, zeŋgâren gâbâ a ŋâiŋâ Yohane mân walip. Ka Anutugât kiŋ topŋan a ândibi, narâk zoren a gigiŋâ ândibi, ziŋâ ko walâbi.” ");
INSERT INTO kpf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","A ambân aksik sot kât mimiŋ a, zen ârândâŋ Yohanegât den nâŋgâmŋâ Anutugât den nâŋgâne bon oi Yohaneŋâ too saŋgonziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Parisaio a sot Kembugât gurumin den zorat galem a, zen ko Yohanegât too birâm Anutugât den kândâtkune zeŋgâren bon buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesuŋâ itâ sâip, “A narâk ziren ândie, zen ikâ zo zeŋgâren dâpkwap sâbâ? Zen dap yatâ? ");
INSERT INTO kpf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Zen katep yatâ ek birâ, nâŋgâm birâ upme. Kâtep zen kamân sombemân tapŋâ bukurâpziŋâ itâ sâm dâzâŋgome, ‘Nen kep meindâ zen wangât mân kue? Nen umbâlâ kep mem iseindâ wangât mân isie?’ ");
INSERT INTO kpf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohane too saŋgonziŋgip, zâk waiŋ sot nalem mân nem ândei ekŋâ sâwe, ‘Zâk wâkeŋoot ândiap.’ ");
INSERT INTO kpf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ka a bonŋâ, nâŋâ gamŋâ nalem sot waiŋ nem ândia nekŋâ sâme, ‘Zâk kât mimiŋ a sot bâliŋ mâme a zeŋgât buku. Nalem sot waiŋ nem mân birâmap.’ ");
INSERT INTO kpf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ka sa nâŋgânek. Anutugât nâŋgânâŋgâ ko a ambârâpŋâ ziŋâ topŋâ nâŋgâm lum zaatne bonŋâ âsagemap.” ");
INSERT INTO kpf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisaio a ŋâiŋâ Yesu diim mirâŋan zari nalem niniŋâ tâtarân tâip. ");
INSERT INTO kpf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Oi kamân zorat ambân laŋ mâman ambân ŋâi, zâk Yesu Parisaiogât mirin zari siŋgiŋâ nâŋgâmŋâ too hitom âlip ŋâi beloŋoot mem zarip. ");
INSERT INTO kpf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Oi Yesugât kândâtŋan kin isei siŋâ tooŋandâ Yesugât kiŋan giari kâuk sâmotŋandâ saŋgori âron oip. Kiŋan mâŋganŋâ too wârânŋâ âlip, zo saŋgonŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ambân zo yatâ oi Parisaio a Yesu diigip, zâkŋâ ekŋâ umŋandâ itâ sâip, “Ambân zirat orot mâme bâliŋâ. Yesu zâk Propete ândim sâi ko ambân zirat topŋâ ek nâŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yatâ nâŋgi ko Yesuŋâ itâ sâm dukuip, “Simoŋ, den ŋâi dâgoga nâŋgâ.” Dukui sâip, “Patâ, sâna nâŋgâbâ.” ");
INSERT INTO kpf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Oi Yesuŋâ itâ sâm dukuip, “Sikum a ŋâi a zagât kât tosa zikip. A ŋâi kât 5 handeret pindip. A ŋâi ko kât 50 pindip. ");
INSERT INTO kpf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Oi hâuŋâ pindârat sâm kâtzikŋâ buŋâ, zorat ko tosazik birip. Oi zekâren gâbâ ŋâiŋâ sikum patâ a zorat umŋandâ gâsum biraŋbap? Gâ ŋâigât sat?” ");
INSERT INTO kpf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mâsiki Simoŋâ itâ sâip, “Kât doŋbep pindip zâkkât san.” Sâi Yesuŋâ itâ sâip, “Gâ âlip sat.” ");
INSERT INTO kpf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yatâ sâm ambângâren puriksâm Simoŋ itâ sâm dukuip, “Ambân zi eksat? Mirâgan kopga ki saŋgon too ŋâi mân gum paat. Ambân zâkŋâ ko kinnâ siŋ tooŋandâ giari saŋgonnim kâuk sâmotŋandâ saŋgori âron uap. ");
INSERT INTO kpf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gâ mân mâŋgannigat. Ka ambân zâkŋâ ko kinnan narâk kârep mângannim taap. ");
INSERT INTO kpf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gâ kâuknan kelâk mân saŋgonnigat. Ka ambân zorâŋâ ko kinnan too hitom âlip saŋgonsap. ");
INSERT INTO kpf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Zorat dâgobâ. Ambân zâk umŋâ gâsunim yatâ otnigapkât topŋâ itâ nâŋgâ. Zâk tosaŋâ patâ ândeip, zo biran. Ŋâi zâk tosaŋâ mâik ŋâi birâbirâŋâ, zâk âkŋâlem mâik ŋâi tâkŋaŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yatâ sâmŋâ ambân itâ sâm dukuip, “Tosagâ biran.” ");
INSERT INTO kpf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yatâ sâi a nalem ârândâŋ nem tarâwe, ziŋ umziŋandâ itâ nâŋgâwe, “Zâk a dap dap yatâ, gât ko tosa birâbirâŋaŋgât sap?” ");
INSERT INTO kpf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Oi Yesuŋâ ambân zo itâ sâm dukuip, “Nâŋgâm pâlâtâŋ kwatnigat, zorat âlip uat. Umgâ diim gei âi ândi.” ");
INSERT INTO kpf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Narâk zorat kwâkŋan Yesuŋâ kamân patâ sot kamân mâik, zeŋgâren obândim Anutu um topŋan ândiândigât den siŋgi âlipŋâ dâzâŋgom ândeip. Arâp kiin zagât, zen molim âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Oi ambân nâmbutŋâ mârum wâkeziŋoot sot mâsekziŋoot zo kubikziŋgip, zen molim âiwe. Zeŋgâren gâbâ ambân ŋâi kutŋâ Maria, Madala kamânân gok. Zâkkât wâke nâmburân zagât moliziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Oi ambân ŋâi kutŋâ Yoana. Herodegât galem a Kusa, zâkkât ambinŋâ. Zet sot ŋâi kutŋâ Susana sot ambân nâmbutŋâ doŋbep, zen kât sikumziŋâ zemziŋgip, zo zâk sot arâpŋâ ziŋgâne nalem kwâlâm nem ândimarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kamân kamânŋâ a ambân Yesugâren mindunetâ den sumbuŋâ ŋâi itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“A ŋâi keet pâmbam nebân arip. Âimŋâ keet maandeŋi nâmbutŋâ mâtâbân gei zei a ziŋ lâŋ kunzirâwe. Oi nii ziŋ ga nem naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Keet nâmbutŋâ hân siŋitŋan gei zeip. Oi hân tooŋâ buŋaŋgât kâmŋâ takâm moip. ");
INSERT INTO kpf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Keet nâmbutŋâ hibuk osetŋan gei zeip. Oi kâmŋâ takâm kopgâi hibuŋâ takâm langi moip. ");
INSERT INTO kpf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Keetŋâ nâmbutŋâ hân kelâkŋan gei kâmŋâ takâm zâim bonŋâ imbaŋâ âsageip. Topŋâ ŋâigât keetŋâ 1 handeret. Topŋâ nâigât keetŋâ 1 handeret. Bonziŋâ yatâ muyageip.” Den zo sâm kwâkâm den kâtikŋâ sâip, “Ŋâi zâk kindapŋootŋâ den zi nâŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Arâpŋâ den sumbuŋâ zorat topŋâ mâsikâne itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","“Anutu um topŋan bagibagiŋâ, zorat den sumbuŋâ zo ziŋâ nâŋgâm kwâtâtibigât sâsâŋ. Ka a nâmbutŋâ zen topŋâ mân nâŋgâbigât den sumbuŋâ dâzâŋgoman. Zorat ko, ‘Senŋâ igikŋâ, zo ikpi, ka mân ek kwâtâtibi. Kindapziŋandâ den naŋgâm mân nâŋgâm kwâtâtibi.’ ");
INSERT INTO kpf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Den sumbuŋâ san, zo topŋâ itâ. Anutugât denŋâ keet yatâ uap. ");
INSERT INTO kpf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Keetŋâ mâtâbân gei zeip, a nâmbutŋâ zo yatâ ândime. Den siŋgi âlip, zo nâŋgâne Sataŋŋâ ga nâŋgâm pâlâtâŋ kwâkŋaŋgâm sumbemgât siŋgi upegât betziŋan memap. ");
INSERT INTO kpf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Keetŋâ hân siŋitŋan gei zeip, a nâmbutŋâ zo yatik ândime. Zen den siŋgi âlip nâŋgâm âkŋâlem ândibi. Oi ko umziŋan ândâŋâ mân gâsuapkât narâk pâŋkânok mem ândine mâsimâsikâ gâbabân birâbi. ");
INSERT INTO kpf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Keetŋâ nâmbutŋâ hibukŋan gei zeip, a nâmbutŋâ zo yatik ândime. Den siŋgi âlipŋâ, zo nâŋgâbi. Oi sâkkât kut ŋâi ŋâi zorat nâŋgâne zâizâiŋâ oi kât sot sikumgât sambe muyageziŋgi den siŋgi âlipŋâ, zo bonŋâ mân opmap. ");
INSERT INTO kpf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Keetŋâ nâmbutŋâ hân kelâkŋan gei zeip, a nâmbutŋâ zo yatik ândime. Zen den siŋgi âlipŋâ nâŋgâm umziŋ kubik mem ândim kâtigem bonŋâ muyagime.” ");
INSERT INTO kpf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Zen kârâp sâumŋâ âmaŋ umŋan pam kwârakume mo tâtatŋâ gobetŋan pâme? Zo buŋâ. Âsakŋâ zo kiaŋ tâtatŋâ kwâkŋan pane mirâ umŋan âsakŋâ âsagei a kopga mirâ umŋan âlip ikpi. ");
INSERT INTO kpf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kut ŋâi ŋâi tik ziap, zo zem mân zimbap. Zo gâtâm âsagem naŋgâbap. Kut ŋâi ŋâi kwârakwârakuŋ ziap, zo zem mân zimbap. Zo mâbâlakŋibap. Zo mâbâlakŋem kagibap. ");
INSERT INTO kpf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","A ŋâi, zâk den nâŋgâm kwâtâtibap, Anutuŋâ zâk nâŋgânâŋgâ âlip târokwap pindâbap. Ka a ŋâi mân nâŋgâm kwâtâtei bekŋan mem naŋgâbap. Zorat den siŋgi zi kindap kwap nâŋgâm biraŋbi.” ");
INSERT INTO kpf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Narâk ŋâin a ambân kâmut patâ Yesu haamgum kine Yesugât mamŋâ sot murâpŋâ, zen gam Yesugâren âinam a ambân zeŋgâren kwakŋâ âkŋan kirâwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yata utnetâ a ŋâiŋâ ziŋgitŋâ Yesu itâ sâm dukuip, “Mamgâ murâpkâ giknam âmbi ga sombemân kinze.” ");
INSERT INTO kpf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sâi Yesuŋâ a ambân itâ sâm dâzâŋgoip, “Mamnâ murâpnâ, zorat sa nâŋgânek. Anutugât den nâŋgâm lume, zen nâgât mamnâ murâpnâ.” ");
INSERT INTO kpf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Hilâm ŋâin Yesu sot arâpŋâ waŋgâyân zâiwe. Yesuŋâ waŋgâyân zâim itâ sâm dâzâŋgoip, “Nen saru nâmbutken âinâ.” Sâi nâŋgâne âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Âimŋâ Yesu umangât okŋaŋgi ge zeip. Uman zem tâi pibâ patâ koi saru bâliŋ op tooŋâ waŋgâ kâligen giari saruyân geinam urâwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Oi Yesu mâŋgim itâ sâm dukuwe, “Patâ, nen saruyân geinamen.” Sânetâ zaatŋâ saru sot pibâ den dâzâkoi hiriŋsâm ziwet. ");
INSERT INTO kpf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Oi keŋgât op imbaŋâziŋ buŋ oi sâwe, “Opoŋ, pibâ sot saru sot kut ŋâi ŋâi den dâzâŋgoi diŋâ lume. Zâk a dap yatâ?” ");
INSERT INTO kpf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galilaia hân birâm saru nâmbutken âim Gerasene a zeŋgâren takâwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Zoren âimŋâ kârâkŋan zari a ŋâi zâkkâren gâip. A zorat umŋan wâke doŋbep ândine narâk kârep sâk bârak ândeip. Oi mirin mân zemâip. A zeŋgât kwak kât kiyân zânzeku op ândimâip. ");
INSERT INTO kpf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","A zo Yesu ekŋâ den kâtik sâm hânân gei Yesu kiŋ topŋan zem den itâ sâip, “Yesu, Anutu sumbem mariŋaŋgât nanŋâ, gâ wan otnibam gaat? Narâk mân mâte uapkât sâknam patâ mân niban.” ");
INSERT INTO kpf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesuŋâ wâke itâ sâm dukuip, “Wâke, gâ ayân gâbâ takâm âi.” Zorat op ko sâip. Wâkeŋâ narâk dâp a zo mem âbabibi kwâkŋaŋgi a ziŋ gâsum tâk kâtikŋâ kiŋ bikŋâ saam galem op ândiwe. Oi wâkeŋâ okŋaŋgi tâk tiriktâruk mem barâ kâtikŋan âi ândimâip. ");
INSERT INTO kpf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Oi Yesuŋâ mâsikâm sâip, “Gâ kutkâ ŋâi?” Mâsiki sâip, “Nâgât kutnâ kâmut patâ.” Wangât, wâke doŋbep zen a umŋan ândiwe, zorat. ");
INSERT INTO kpf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Hân zoren bâu kâmut patâ zen bâkŋan gendâk nem ândiwe. Wâke zen moliziŋgi simân geibegât wâke zen bâu umziŋan geibigât Yesu dukuwe. Dukune nâŋgâziŋgi wâke zen ayân gâbâ takâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wâke zen a umŋan gabâ takâm bâu umziŋan geine bâu kâmut patâ zo sârârâk kârâm simân geim saru deŋgânân gei mom naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bâu galem a zen zo ekŋâ sârârâk kârâm kamânân sot nebân a ambân ândiwe, zorat den siŋgi dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dâzâŋgone a ambân zen a wâkeŋoot ândeip, zo iknam gawe. A wâkeŋoot ândeipŋâ hâmbâŋoot sot nâŋgânâŋgâŋoot Yesu kiŋ topŋan tâip. Oi ekŋâ keŋgât op kirâwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kinetâ a ek nâŋgâweŋâ a wâkeŋoot ândeipŋâ âlip oip, zorat den siŋgi dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Oi Gerasene hânân kamân dâp a ambân, zen keŋgât op Yesu zâk kamânziŋâ zo birâm âibapkât dukune waŋgâyân âburem zarip. ");
INSERT INTO kpf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A wâkeŋoot ândeip, zâkŋâ Yesu sot âibapkât sâi Yesuŋâ itâ sâm kwâkâŋaŋgip, ");
INSERT INTO kpf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Gâ kamângan âimŋâ torerâpkâ Anutuŋâ kubikgigap, zorat siŋgi dâzâŋgom ândiban.” Sâi a zo puriksâm Yesuŋâ kubikŋaŋgip, zorat siŋgi kamânŋan a ambân dâzâŋgom naŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","A zen Yesugât mambât ândine gâi ekŋâ sâtâre urâwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Oi mâpâmâpâse namâ galem a ŋâi kutŋâ Yairo, zâk gamŋâ Yesugât kiŋ topŋan ge tap itâ sâm dukuip, “Gâ mirânan gâban.” ");
INSERT INTO kpf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Zâkkât bâratŋâ kânok, kendonŋâ kiin zagât, zâk mumbam op zeipkât Yesu dukuip. Oi Yesuŋâ nâŋgâm ari a ambân doŋbep mem oset kwâkŋaŋgâne âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Osetziŋan âmbân ŋâi ândeip. Ambân zâk gilâm gem ândei kendon patâ kiin zagât oip. Oi kubikkubik a ziŋâ kubik osiwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ambân zorâŋâ Yesu kândâtŋan âim hâmbâ murukŋan weegip. Weegi zorâŋak gilâmŋâ kârâksâip. ");
INSERT INTO kpf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Oi Yesuŋâ mâsikâziŋgâm sâip, “Ŋâiŋâ weenigap?” Sâi a ambân kwâimbâne Peteroŋâ itâ sâip, “Patâ, a ambân ziŋâ mem oset kwatgim weegige, zo ka.” ");
INSERT INTO kpf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesuŋâ itâ sâip, “Ŋâiŋâ weenigi imbaŋânâ ari nâŋgan.” ");
INSERT INTO kpf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ambân zorâŋâ topnâ muyagiap sâm ken bet sânsân opŋâ Yesugât kiŋ topŋan gei pindiŋsâm tap mâsekŋaŋgât den sot hâmbâ murukŋan gâsum âlip oip, zorat den siŋgi sâm muyagei nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sâi Yesuŋâ itâ sâm dukuip, “Bâratnâ, nâŋgâm pâlâtâŋ kwatnigat, zorat op âlip uat. Umgâ diim gei âi.” ");
INSERT INTO kpf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu yatâ sâm kiri mâpâmâpâse namâ galem a, zâkkât mirin gâbâ a ŋâi ga itâ sâip, “Bâratkâ muap, gât ko sâna patâŋâ mân gâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesuŋâ den zo nâŋgâm galem a itâ sâm dukuip, “Mân keŋgât ot. Nâŋgâm pâlâtâŋ kwâtnina bâratkâ âlip upap.” ");
INSERT INTO kpf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yatâ sâmŋâ mirin takâmŋâ nâmbutŋâ sâi kinetâ ko Petero sot Yohane sot Yakobo sot katep ibâ mamŋâ, zeŋak zâk sot zâiwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Oi a ambân âigirâp patâ doŋbep isem zem tatne itâ sâm dâzâŋgoip, “Mân isenek. Ambân katep zâk yen uman zem taap.” ");
INSERT INTO kpf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sâi zen moip zo nâŋgâm kâtigem girâŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Oi Yesuŋâ ambân katep zo bikŋan gâsum konsâm sâip, “Ambân, gâ zaat.” ");
INSERT INTO kpf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sâi zorâŋak dâpŋâ puriksâi zaarip. Zaari nalem pindâne nimbapkât den dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ibâ mamŋâ, zikŋâ ek nâŋgâm imbaŋâzikŋâ buŋ oip. Yesuŋâ zorat siŋgi a ambân mân dâzâŋgobigât dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu zâk arâpŋâ sâi gane wâke moliziŋgâbigât sot mâsek kubikziŋgâbigât imbâŋâ ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Oi a ambân Anutugât um topŋaŋgât den dâzâŋgom mâsekziŋoot kubikziŋgâbigât sâŋgonzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Den itâ sâm sâŋgonzâŋgoip, “Zen mâtâpkât tân sot irâ, nalem, kât mân mem âibi. Hâmbâ umŋan sâkŋan buŋâ. Kânogâk mem âibi. ");
INSERT INTO kpf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kamân ŋâin âimŋâ mirâ tapi, zorenâk tâtat mâme op gem âibi. ");
INSERT INTO kpf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kamân ŋâin âine ziŋgit mân nâŋgâne kinziŋan gwapgwap lâŋ gâbârine gei topziŋâ ek nâŋgâbi. Zen yatâ opŋâ kamân zo birâm âibi.” ");
INSERT INTO kpf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yatâ sâm dâzâŋgoi zen âiwe. Kamân toren toren âim a ambân den siŋgi âlip dâzâŋgom a ambân sisi mâsekziŋoot kubikziŋgâm ândiwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","A kutâ Herode, zâk Yesuŋâ kut ŋâi ŋâi oip, zorat den siŋgi nâŋgâm kwagip. Wangât, a nâmbutŋandâ itâ sâwe, zorat, “Yohane, zâk mumuŋan gâbâ zaatŋâ ândim kut ŋâi ŋâi zo uap.” ");
INSERT INTO kpf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nâmbutŋandâ Elia zaat ândiap sâwe. Ka nâmbutŋandâ sâwe, “Zâk Propete sâŋgiŋâ ŋâiŋâ zaatŋâ ândiap.” ");
INSERT INTO kpf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Sânetâ Herodeŋâ itâ sâip, “Nâŋâ sandâ Yohane gânduŋâ mânâŋgârâwe, zo ko zi ŋâiŋâ oi siŋgiŋâ nâŋgâman?” Yatâ sâm Yesu ikpatkât nâŋgâm ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposolo zen âburem gam nep tuuwe, zorat Yesu dukum naŋgâwe. Den siŋgi zo dukunetâ Yesuŋâ diiziŋgâm Besaida zeŋgât hânân ziiŋik ândibigât âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Âine a ambân zen siŋgi nâŋgâm moliziŋgâm âiwe. Oi Yesugâren takâne buku otziŋgi ândiwe. Ândinetâ Anutu um topŋaŋgât den dâzâŋgom a sisi mâsekziŋoot zo kubikziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yatâ op ândinetâ mirâsiŋ geibâ sâi arâpŋâ kiin zagât, zen Yesugâren âim itâ sâm dukuwe, “Ziren mân ândiândiŋan ândiengât a zâmbanna kamân toren toren âim mirâ sot nalem muyaginek.” ");
INSERT INTO kpf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yatâ sânetâ ko itâ sâm dâzâŋgoip, “Wangât âibigât se? Ziiŋak nalem ziŋgânek.” Sâi itâ dukuwe, “Nalem bâtnâmbut sot saru zuuŋâ zagât yatiktâ ziap, zorat dap utnâ. Nen kamânân âimŋâ a kâmut zi zeŋgât nalem sâŋgân minat?” ");
INSERT INTO kpf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A doŋbep, 5 tausen yatâ ândiwegât den yatâ sâwe. Sânetâ itâ sâip, “A dâzâŋgone teŋgâ ŋâi 50, teŋgâ ŋâi 50, yatâ ge tatnek.” ");
INSERT INTO kpf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","16","Sâi zen yatâ sâne tatne nalem bâtnâmbut sot saru zuu zagât, zo memŋâ sumbemân ekŋâ sâiwap sâm sonpam namuŋâ arâp ziŋgi ziŋâ kâsâpkum a ziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Oi zen aksik patâ nem âkon urâwe. Oi buputŋâ zeip, zo sândune irâ kiin zagât piksâip. ");
INSERT INTO kpf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Narâk ŋâin Yesu zâk ninâu nep tuum tâi arâpŋâ zâkkâren âiwe. Oi Yesuŋâ mâsikâziŋgip, “A ambân ziŋâ nâgât ŋâi sâme?” ");
INSERT INTO kpf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mâsikâziŋgi itâ sâm dukuwe, “Nâmbutŋâ ziŋâ Yohane too saŋgonziŋgip sâme. Nâmbutŋâ ziŋâ Elia sâme. Oi nâmbutŋâ ziŋâ Propete sâŋgiŋâ ŋâi zaat ândiap sâme. Gâgât yatâ sâme.” ");
INSERT INTO kpf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sâne mâsikâziŋgâm sâip, “Ka zen ko nâgât ŋâi sâme?” Sâi Peteroŋâ sâip, “Gâ Anutugâren gokŋâ. Bâliŋan gâbâ mâkâniŋgâban. Gâ Kristo.” ");
INSERT INTO kpf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yatâ sâi a ambân zikŋâ topŋâ mân dâzâŋgobigât sâm kâtigeip. ");
INSERT INTO kpf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Oi itâ târokwap dâzâŋgoip, “A bonŋâ, nâ sâknam patâ nâŋgâbat. Yuda zeŋgât a patâ sot a sâtŋâ sot Kembugât gurumin den zorat galem a zen kâbakŋenine Roma a kutâgâren aria none momŋâ sirâm karâmbut tap zaatpat.” ");
INSERT INTO kpf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesu zâk a ambân aksik itâ dâzâŋgoip, “Zen nâ molininâ sâm um sâkziŋaŋgât den kândâtkum sirâmŋâ sirâmŋâ poru nakziŋâ lum nâgât mâtâp lâŋbi. ");
INSERT INTO kpf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Zen ândiândiziŋ aŋgân kârâbi, zo ko gulipzâŋgobap. Ka zen nâgât op ândiândiziŋ birâbi, zo ko muyageziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Zen hângât kut ŋâi ŋâi aksik mem ândine ândiândiziŋ koi moi wan wan bonŋâ zemziŋgâbap? ");
INSERT INTO kpf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Zeŋgâren gâbâ ŋâi zâk kwâimbânibap mo dinnaŋgât nâŋgi aŋunŋoot upap, zo ko a bonŋâ, nâŋâ gâtâm Ibânâ sot sumbem a zeŋgât âsakŋâ sot a bonŋâ nâgât âsaknoot gamŋâ a yatâ zo kwâimbâziŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nâ perâkŋak sa nâŋgânek. A zi kinze, zeŋgât oserân gabâ nâmbutŋâ mân mune Anutu um topŋan ândiândiŋaŋgât narâk mâte oi ikpi.” ");
INSERT INTO kpf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu den zo sâm naŋgi sirâm nâmburân kârâmbut âki ninâu sâbam Petero sot Yohane sot Yakobo diiziŋgi bâkŋan zâiwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Zâi ninâu sâm tâi holi tobatŋâ ŋâi âsageip. Oi hâmbâŋâ kâukom kwâtâteip. ");
INSERT INTO kpf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","A zâgât Yesu sot muyageitâ den sâm kirâwe, kutzikŋâ Mose sot Elia. ");
INSERT INTO kpf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Zet sumbem âsakzikŋoot gam Yesu Yerusalem kamânân zâim ândim sot sumbemân zâibap, zorat den sâwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Oi Petero sot bukuzatŋâ zen umangât otziŋgi zemŋâ zaat igâwe. Yesu âsakŋâŋoot sot a zagât zâk sot kiritâ ziŋgirâwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Oi a zagât zo âiram oitâ Peteroŋâ Yesu itâ sâm dukuip, “Patâ, mat ŋâi ziren ândien. Silep karâmbut tuunâ. Gâgât ŋâi, Mosegât ŋâi, Eliagât ŋâi.” Zo mân nâŋgâm laŋ yatâ sâip. ");
INSERT INTO kpf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sâi sasa ŋâi ge kwâtepzâŋgoip. Kwâtepzâŋgoi arâp zen keŋgât op kirâwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Oi sasa kâligen gâbâ den zitâ muyageip, “Zi nannâ mem sâlâpkuwan. Zen diŋâ nâŋgâm kwâtâtibi.” ");
INSERT INTO kpf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Den zo nâŋgâmŋâ iknetâ Yesu zikŋik kiri igâwe. Oi arâpŋâ zen zo igâwe, narâk zoren a mân dâzâŋgom ziiŋik nâŋgâm ândiwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Haŋsâi bâkŋan gâbâ gine a ambân kâmut patâ kândiaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Zeŋgâren gâbâ a ŋâiŋâ Yesu konsâm den kâtik itâ sâm dukuip, “Patâ, gâ dinnâ nâŋgâm nannâ eknan. Nâ nannâ kânok. ");
INSERT INTO kpf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nâŋgâ. Wâke ŋâiŋâ okŋaŋgi den kambâŋ sâmap. Oi diim mem ŋâi ŋâi okŋaŋgi lepâuŋâ gemap. Oi wâke zorâŋâ mân birâŋaŋgâm kom mem ŋâi ŋâi okŋaŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Oi arâpkâ molibigât dâzâŋgua zen molinâ sâm kwakŋâ bire.” ");
INSERT INTO kpf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sâi Yesuŋâ itâ sâm dâzâŋgoip, “O, a kâmut nâŋgâm pâlâtâŋziŋ buŋ, narâk dabutâ zen sot ândim âkom diiziŋgâm ândibat?” ");
INSERT INTO kpf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sâmŋâ a zo itâ sâm dukuip, “Nângâ diim ga.” Sâi Yesugâren diim âim tatne wâkeŋâ okŋaŋgi hânân gei um gulip op zeip. Oi Yesuŋâ wâke den dukui ari katep zo âlip oi ibâŋâ pindip. ");
INSERT INTO kpf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Oi a ambân zen Anutugât imbaŋâ zo ekŋâ âiwap parâwe. Oi a ziŋâ Yesu kut ŋâi oip, zorat âiwap pam zine Yesu sot arâp ziiŋik tap itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Den zi dâzâŋgua nâŋgânek. A bonŋâ nâ a zeŋgât bitziŋan zâibat.” ");
INSERT INTO kpf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yatâ sâm dâzâŋgoi arâp zen den zo nâŋgâm topŋâ mân nâŋgâwe. Den zorat topŋâ nâŋgâbegât pâkekoip. Oi Yesu mâsikânam nâŋgâm kwakŋâ birâwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesugât arâpŋâ zeŋgât osetziŋan a ŋâiŋâ a sâtŋâ ândibap, zorat sâm âraguwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Âragune Yesuŋâ nâŋgânâŋgâziŋâ ek nâŋgâm katep mâik ŋâi diim ga gootŋan pâi tâi itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Ŋâiŋâ katep mâik itâ zo galem okŋaŋgâbap, zo ko nâ kore otnibap. Kore otnibap, zorâŋâ sâŋgonnogip, zo yatik kore okŋaŋgâbap. Oi zeŋgâren gâbâ a ŋâi gigiŋa op ândibap, zo ko Anutuŋâ zâkkât a patâ sâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sâi Yohaneŋâ itâ dukuip, “Patâ, nen a ŋâiŋâ gâgât kot sâm wâke molei iksen. Oi zâk nen sot mân ândeipkât kwâkâŋaŋgen.” ");
INSERT INTO kpf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Sâi Yesuŋâ sâip, “Mân kwâkâŋaŋgâbi. Nepziŋâ mân kândaŋbapŋâ ko buku op betziŋan mimbap.” ");
INSERT INTO kpf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesu sumbemân puriksâbam narâk mâte oi Yerusalem kamân âibam kâtigem arip. ");
INSERT INTO kpf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Âibamŋâ arâpŋâ nâmbutŋâ sâŋgonzâŋgoi kândom âiwe. Kândom âimŋâ Samaria a zeŋgât kamân ŋâin takâmŋâ Yesugât mirâ ŋâin muyagibigât dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yesu zâk Yerusalem kamân âibap, yatâ nâŋgâm mirâ aŋgân kârâwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mirâ aŋgân kârâne Yakobo sot Yohane, zet zo nâŋgâm Yesu mâsikâm sâwet, “Kembu gâ nâŋgâna sâitâ sumbemân gâbâ kârâp gei ziŋgesibap.” ");
INSERT INTO kpf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yatâ sâitâ Yesuŋâ puriksâm kwâkâzikip. ");
INSERT INTO kpf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Oi kamân zo birâm kamân ŋâin âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Oi âine a ŋâiŋâ muyageziŋgâm Yesu itâ sâm dukuip, “Gâ zoren mo zoren âibâ sâna moligibat.” ");
INSERT INTO kpf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sâi Yesuŋâ itâ sâm dukuip, “Wâu ulin, zen deŋziŋan ândime. Nii zuu, zen hâŋgotziŋan zime. Ka a bonŋâ, nâ ko isen korem zo buŋ ândiman.” ");
INSERT INTO kpf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Oi Yesuŋâ a ŋâi muyagem itâ sâm dukuip, “Gâ ga molini.” Sâi a zorâŋ itâ sâm dukuip, “Kembu, nâŋgâna âi ibânâ hangum gâbat.” ");
INSERT INTO kpf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sâi Yesuŋâ itâ sâm dukuip, “Birânandâ mumuŋandâ ziiŋak hanagonek. Gâ ko âimŋâ Anutu um topŋan ândiândiŋ, zorat den sâna laŋ kârâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A ŋâiŋâ ko Yesu itâ sâm dukuip, “Kembu, nâ moligibatkât otnigap. Gâ nâŋgâna puriksâm âim torerâpnâ kândâtziŋ kelikŋâ gâbat.” ");
INSERT INTO kpf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sâi Yesuŋâ itâ dukuip, “A ŋâi kamân ŋâi âibamŋâ mâtâbân âim um zagât op puriksâm kândâtŋan ikpap, a yatâ zorâŋ Anutu um topŋan bagibagiŋ, zorat dâp buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Narâk zorat kwâkŋan Yesuŋâ arâp 70 gâsum sâlâpzâŋgom nep diŋ sâm ziŋgip. Oi zikŋâ kamân zo âibat sâip, zoren a zagât zagât sângonzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Oi itâ sâm dâzâŋgoip, “Kâlamân kut ŋai ŋâi bonŋâ doŋbep, ka nep tuutuuŋ a bituk. Zorat zen nep mariŋaŋgât sâne nep a muyageziŋgi nepŋan âibi. Nebân âim bonŋâ kwâkâm mimbi. ");
INSERT INTO kpf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Zen âim itâ nâŋgâbi. Râma gwamŋâ zen wâu ulin zeŋgât oserân mân sâŋgonzâŋgua âibe. Yata zo laŋ zen sâŋgonzâŋguan. ");
INSERT INTO kpf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Zen irâ kipâke sot kât mân mem âibi. Oi mâtâbân âim a muyageiziŋgâm zen sot kin den mân upi. ");
INSERT INTO kpf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mirâ ŋâin zâinam mâirâp itâ sâm dâzâŋgobi, “Mirâ umŋan lumbeŋâ zimbap.” ");
INSERT INTO kpf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Sânetâ mirâ zoren a ŋâi lumbeŋaŋgât siŋgi ândei lumbeŋâ dinziŋaŋgât bonŋâ zâkkâren muyagem zimbap. Buŋ oi ko lumbeŋâ dinziŋâ, zorat bonŋâ ziiŋan âburibap. ");
INSERT INTO kpf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mirâ zâibi, zoren tâtat mâme utne nalem ziŋgâne nimbi. Nep a zen nep sâŋgânŋâ minetâ dâp upap. Mirâ laŋ mân zâibi. ");
INSERT INTO kpf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kamân ŋâin âinetâ buku otziŋgâm nalem ziŋgâne nimbi. ");
INSERT INTO kpf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Zoren a ambân sisi mâsekziŋoot kubikziŋgâm kamân mâirâp itâ sâm dâzâŋgobi, ‘Anutu um topŋan ândiândiŋ mâte otziŋgap.’ ");
INSERT INTO kpf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ka kamân ŋâin takâne ziŋgit mân nâŋgânâŋgâ utne kamân sombemân kin itâ sâm dâzâŋgobi. ");
INSERT INTO kpf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kinniŋan zeŋgât gwapgwap taap, zo lâŋ gâbâreindâ zemziŋgâbap. Zorat topŋâ itâ nâŋgânek. Anutu um topŋan tâtatŋâ mâte otziŋgi bire.’ ");
INSERT INTO kpf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Zorat sa nâŋgânek. Gâtâm den kubikkubik narâkŋan Sodom kamân mâirâp, zen hâuŋâ mem gei kwap otziŋgâbap. Ka kamân zorat mâirâp, zen hâuŋâ mem zâi kwap otziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yei, Koraziŋ kamân mâirâp, zen sâknam yâmbât nâŋgâbi. Yei, Besaida kamân mâirap, nep patâ zeŋgâren muyagewan, zo yatâ Tiro Sidoŋ zeŋgâren muyagei sâi ko mârum âigirâp patâ op umziŋ melâŋbe. ");
INSERT INTO kpf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Zorat ko den kubikkubik narâkŋan Tiro Sidoŋ a ambân, zen hâuŋâ mem gei kwap otziŋgâbap. Ka Koraziŋ sot Besaida kamân mâirâp, zen ko hâuŋâ mem zâi kwap otziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Oi Kapenaum kamân mâirâp, zen dap upi? Zen sumbemân zâibi? Buŋâ. Zen simân geibi.” ");
INSERT INTO kpf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yâtâ sâmŋâ Yesuŋâ arâpŋâ itâ sâm dâzâŋgoip, “Ŋâi zâk zeŋgât den nâŋgâbapŋâ nâgât den nâŋgâbap. Ka ŋâi zâk birâziŋgâbapŋâ yatik birânibap. Oi ŋâi zâk nâ kândâtnom birânibapŋâ sâŋgonnogipŋâ yatik kândâtkom birâŋaŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yesugât arâp 70, zen âburem gam sâtâre op Yesu den siŋgi okŋaŋgâwe. Itâ sâm dukuwe, “Gâgât korân sâindâ wâke sot kut ŋâi ŋâi, ziŋâ dinniŋâ lume.” ");
INSERT INTO kpf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yatâ sânetâ itâ sâm dâzâŋgoip, “Sataŋ zâk sumbemân gâbâ hânpân yatâ gei koi egâwan. ");
INSERT INTO kpf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nâŋge. Zen mulum sot yaŋgi sot Sataŋgât kut ŋâi ŋâi gakârâpŋâ, zo lâŋne mân tâmbetzâŋgobapkât imbaŋâ ziŋgâwan. ");
INSERT INTO kpf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Oi wâkeŋâ sâtziŋ lume, zorat zen mân sâtâre upi. Ka kutziŋâ sumbemân kulemgui ziap, zorat sâtâre upi.” ");
INSERT INTO kpf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Narâk zoren Tirik Kaapumŋâ Yesu okŋaŋgi sâtâre op den itâ sâip, “Ibânâ, sumbem sot hân mariŋâ, mâpâsegigan. Gâ a nâŋgânâŋgâziŋaŋgât nâŋgâne patâ opmap, a yatâ zo ko diŋgâ mem tik kwatziŋgâmat. Ka a umziŋaŋgât nâŋgânetâ katep opmap, zo ko diŋgâ sapsum ziŋgâmat. Oi nâ zorat mâpâsegigan. Gâ yatâ muyagem âibap sâm kâtigein.” ");
INSERT INTO kpf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yatâ sâmŋâ itâ sâm dâzâŋgoip, “Ibânandâ kut ŋâi ŋâi zo aksik nâgât bitnan pâip. A zen nanŋâ topnâ mân nâŋgâm kwâtâtime. Ibânâ, zâk zikŋik nek topnâ nâŋgâmap. Oi yatik a zen Ibânaŋgât topŋâ mân nâŋgâm kwâtâtime. Nanŋâ ninak nâŋgâm kwâtâtiman. Oi nanŋâ nâŋâ a nâmbutŋâ Ibanâ tirâpzâŋgua âlip nâŋgâbi.” ");
INSERT INTO kpf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yatâ sâmŋâ Yesuŋâ arâpŋâ zeŋgâren puriksâm itâ sâm dâzâŋgoip, “Zen kut ŋâi ŋâi sen pup tuuga ikse, zorat umâlip nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nâ dâzâŋgua nâŋgânek. Propete a sâŋgiŋâ sot a kutâ doŋbep, zen kut ŋâi ŋâi ikse, zo ek nâŋgânam osiwe. Den siŋgi âlip zo nâŋgânam urâwe. Oi mân nâŋgâwe.” ");
INSERT INTO kpf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kembugât gurumin den zorat galem a ŋâiŋâ Yesu itâ mâsikip, “Patânâ, dap op ândiândi tâmbâŋaŋgât siŋgi upat?” ");
INSERT INTO kpf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sâi Yesuŋâ den hâuŋâ itâ mâsikip, “Kembugât gurumin denân dap yatâ zei sâlâpkum nâŋgâmat?” ");
INSERT INTO kpf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mâsiki sâip, “Gâ um dâpkâ sot imbaŋâgâ sot nâŋgânâŋgâgâ, zo Kembugâ Anutu hâlâluyâk pindâna zimbap. Oi gikaŋgât otgimap, yatigâk a torenŋâ zeŋgât otgibap. Den yatâ zo ziap.” ");
INSERT INTO kpf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sâi Yesuŋâ dukuip, “Den âlip sat. Zorik lum ândiândi tâmbâŋaŋgât siŋgi upan.” ");
INSERT INTO kpf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","A zo a ambân mâteziŋan zâizâiŋ upam opŋâ Yesu itâ mâsikip, “Oi ŋâigât yatâ buku okŋaŋgâbat?” ");
INSERT INTO kpf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sâi Yesuŋâ den siŋgi ŋâi itâ okŋaŋgip, “A ŋâiŋâ Yerusalem kamânân gâbâ Yeriko kamânân geibam mâtâbân arip. Ari ko a kâtik, kâmbu a, zen muyagem komŋâ hâmbâŋâ sot kut ŋâi ŋâi gakâŋâ bekŋan mem birâŋaŋgâne mâtâbân mumbam op zeip. ");
INSERT INTO kpf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Zei tirik namâ galem a ŋâiŋâ mâtâbân âi ekŋâ walâm arip. ");
INSERT INTO kpf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Zâk ari ko tirik namâ galem zeŋgât kore a ŋâi, Lewigât kâmut zeŋgâren gokŋâ, zâkŋâ yatik mâtâbân âim ek walâm arip. ");
INSERT INTO kpf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Oi Samaria hânân gokŋâ, a ŋâi mâtâbân âi ekŋâ umŋâ nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Oi ekŋâ zâkkâren âim useŋâ kelâk sâŋgon, waiŋ too saŋgon kâpeip. Oi doŋgi kwâkŋan pamŋâ diim âi lomba namin pamŋâ galem oip. ");
INSERT INTO kpf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Haŋsâi âibamŋâ lomba namâ galem a kât pindâm itâ sâip, ‘Gâ a zi galem okŋaŋgâban. Kât gigan, zorat nâŋgâna mân dâp oi âburem gâbarân kât gibat.’” ");
INSERT INTO kpf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesuŋâ den siŋgi yatâ sâm sâip, “A karâmbut zo zeŋgâren gâbâ ŋâi nâŋgâna a kuwe, zo buku okŋaŋgip?” ");
INSERT INTO kpf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mâsiki sâip, “Galem okŋaŋgip, a zorâŋ.” Sâi Yesuŋâ itâ dukuip, “Gâ âim yatâ op ândiban.” ");
INSERT INTO kpf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu sot arâpŋâ, zen âim kamân ŋâin takâne ambân ŋâi kutŋâ Mata, zâkŋâ sâi Yesu mirin zarip. ");
INSERT INTO kpf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Oi Matagât gatŋâ ŋâi ândeip, kutŋâ Maria. Zâkŋâ Kembugât kiŋ topŋan ge tâi den siŋgi âlip sâi nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Matâ zâk nalem om kinŋâ itâ nâŋgip, “Nep patâ zei gatnâ mân betnan miap.” Yatâ nâŋgâm Yesugâren âimŋâ sâip, “Kembu, gatnandâ birânigi ninak kore uan. Gâ dukuna ga betnan meik.” ");
INSERT INTO kpf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sâi Yesuŋâ itâ dukuip, “Mata, Mata, gâ kut ŋâi ŋâigât nâŋgâm kwâkâm kinzat. Nâŋgâ. Kut ŋâi ŋâi bâbâlaŋ upan, zorâŋâ dâpŋan. Maria zâk den siŋgi âlip nâŋgâm taap. Zâk mân sa birâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","(-) ");
INSERT INTO kpf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesu zâk hân ŋâin âim ninâu sâm tâi arâpŋâ zeŋgâren gâbâ a ŋâiŋâ itâ sâip, “Kembu, Yohaneŋâ arâp ninâu kwâkâm ziŋgip, zo yatik kwâkâm niŋgâ.” ");
INSERT INTO kpf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sâi Yesuŋâ itâ sâm dâzâŋgoip, “Zen ninau sânam itâ sâbi, ‘Ibâ, gâgât kutkâ hâlâlu zimbap. Gâ gamŋâ hân dâp um dap kembu otniŋgâm ândimâmban. ");
INSERT INTO kpf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Sirâm dâp nalem dâpniŋan niŋgâban. ");
INSERT INTO kpf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tosaniŋ birâban. Neŋgoot yatik a zeŋgât tosaziŋ birâmen, zorat. Top mâsimâsikâyân mân nâmbanban.’” ");
INSERT INTO kpf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yatâ sâmŋâ itâ târokwap dâzâŋgom sâip, “Zeŋgâren gâbâ ŋâiŋâ ŋâtik tânâmŋan a bukuŋâ konsâm dukubap, ‘Bukunâ, gâ nalem karâmbut ni. ");
INSERT INTO kpf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Bukunâ ŋâiŋâ nâgâren gâi nalem pindâbam kâruan.’ ");
INSERT INTO kpf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yatâ sâi mirâ mariŋâ, zâk mirinâk tap sâbap, ‘Gâ wangât uman gwâlâ kwâtnigat? Mirâ mâtâp dooŋgudooŋguŋ sot katep uman zie. Zorat ko nâ mân zaat nalem gibat.’” ");
INSERT INTO kpf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yesu zâk yatâ sâmŋâ sâip, “Nâ sa nâŋgânek. Mirâ mariŋâ, zâk bukuŋâ sâi mân nâŋgâm uman zimbap, zo ko sâi âim âim ko zaatŋâ kut ŋâi ŋâi sap, zo mem pindâbap. ");
INSERT INTO kpf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Zorat nâŋâ torenŋâ ŋâi dâzâŋgua nâŋgânek. Zen Kembugâren ninâu sâne ma ko kut ŋâi ŋâi ziŋgâbap. Zen kut ŋâi ŋâi kârum ma ko muyagibi. Zen mirâ hângiyân kom kine ko mariŋâ mirâ mâtâp mem pâmbap. ");
INSERT INTO kpf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ŋâi zâk ninâu sâi ma ko bonŋâ pindâbap. Ŋâi zâk kârum manâ manâ ko bonŋâ muyagibap. Ŋâi zâk mirâ hâŋgiyân kom kiri ko mariŋâ mâtâp mem pâmbap. ");
INSERT INTO kpf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Zeŋgâren gâbâ a ŋâiŋâ nanŋâ saru zuugât sâi mulum pindâbap? ");
INSERT INTO kpf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mo kuruk keetŋaŋgât sâi yaŋgi pindâbap? Zo buŋâ. Zen a ambân bâliŋâziŋoot yatâ zorâŋ murarâpziŋ kut ŋâi ŋâi âlipŋâ ziŋgâme. ");
INSERT INTO kpf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ibâziŋâ sumbemân walâwalâŋandâ zen Tirik Kaapumgât sânetâ walâm ziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","A ŋâi wâkeŋâ okŋaŋgi kopa oip. Oi Yesuŋâ wâke molei a zo den âlip sâip. Yatâ oi a ambân ziŋ ekŋâ nâŋgâne imbaŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ka a nâmbutŋâ, zen zâkkât itâ sâwe, “Wâke zeŋgât a kutâ Bezebulu, zâkŋâ imbaŋâ pindi wâke moliziŋgâmap.” ");
INSERT INTO kpf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Sâne nâmbutŋâ ziŋâ Yesu top likuliku kulem ŋâi tuubapkât nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Oi zâkŋâ umziŋan ekŋâ dâzâŋgoip, “Hân ŋâin zoren kâmbam muyagem kamân dâp kâsa utne kamân zo kwamen zimbap. Mirâ ŋâin a âmbân ândie, zen kâsa op kâsâpagone mirâziŋ kwamen zimbap. ");
INSERT INTO kpf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sataŋ sot arâpŋâ agonetâ nepziŋ dap op kâtigem zimbap? Zen nâgât itâ sâme, ‘Bezebuluŋâ mam okŋaŋgi wâke moliziŋgâmap.’ Zorat san. ");
INSERT INTO kpf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Zen nâgât itâ sâme, ‘Bezebuluŋâ mam okŋaŋgi wâke moliziŋgâmap.’ Zorat mâsikâziŋga sânek. Narâpziŋâ zen ko ŋâiŋâ imbaŋâ ziŋgi wâke moliziŋgâme? Narâpziŋâ zen sarâziŋaŋgât topŋâ sâm muyagime. ");
INSERT INTO kpf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nâŋâ ko Anutugât imbaŋandâ wâke moliziŋgâman. Zorat ko Anutugât um topŋan ândiândigât narâk, zo mâte otziŋgi mân nâŋge. ");
INSERT INTO kpf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","A kâwaliŋootŋâ timbâ kâmbamŋâ mem mirâ kamânŋâ galem op ândei hâlâluyâk zimbap. ");
INSERT INTO kpf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Oi a kâwaliŋâ patâŋâ gamŋâ zâkŋak kâtigem kom sikum kut ŋâi ŋâi bekŋan memŋâ kâsâpkubap. ");
INSERT INTO kpf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ŋâi zâk nâ buku mân otnibapŋâ kâsa otnibap. Ŋâi zâk nepnâ on galem mân upapŋâ kândaŋbap. ");
INSERT INTO kpf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Wâkeŋâ ayân gâbâ takâm hân a mân ândiândiŋan âim tâtatŋâ kârubap. Kârum mân muyagemŋâ sâbap, ‘Mirânâ birâm gâwan, zorenâk âburem dum âibâ.’ ");
INSERT INTO kpf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yatâ sâm âburem âi ikpap. A umŋâ saŋgon kubikkubikŋâ zimbap. ");
INSERT INTO kpf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Zo zei ekŋâ a bukurâpŋâ nâmburân zagât, zikŋâ dâp yâtâ buŋâ, bâliŋ kâtikŋâ, zo diiziŋgi ga a umŋanâk zo tâtat mâme upi. Oi a zâk mârum bâliŋâ ândeipŋâ bet bâliŋ op kwâtâtibap.” ");
INSERT INTO kpf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Den yatâ sâm kiri a oserân gâbâ ambân ŋâiŋâ den kâtikŋâ den sâm sâip, “Ambân ŋâi mingimŋâ nam gigip, zâkkât nâŋga sâtâreŋoot uap.” ");
INSERT INTO kpf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sâi Yesuŋâ nâŋgâm itâ sâip, “Ee. Ka nâŋâ sa nâŋgânek. A ambân Anutugât den nâŋgâm lume, zeŋgât nâŋga sâtâreŋoot uap.” ");
INSERT INTO kpf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","A ambân doŋbep, zen zâkkâren mindunetâ topkwap den itâ sâm dâzâŋgoip, “A ambân narâk ziren ândie, zo nâŋgânâŋgâziŋ bâliŋâ oi top lâkulâkugât kulem iknam kâuk birâme. Oi zen kulem ŋâi buŋâ. Propete Yona, zâk Niniwe zeŋgâren kulem oip, zo yatâ âsagei ikpi. ");
INSERT INTO kpf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mârumŋan Yona zâk Niniwe a zen bâliŋâziŋ kândâtkom Anutu mâte okŋaŋgâbigât girem den dâzâŋgoip. A ambân narâk ziren ândie, zen yatâ upigât den dâzâŋgoman. Nâ zeŋgât kulem ŋâi op ândian. ");
INSERT INTO kpf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Hân torengen mârumŋan ambân kutâ ŋâi ândeip. Den kubikkubik narâkŋan ambân kutâ zorâŋ zaatŋâ a kâmut narâk ziren ândie, zeŋgât bâliŋâziŋâ sapsugi hâuŋâ mimbi. Zo yen buŋâ. Ambân zo Salomogâren gâbâ nâŋgânâŋgâ âlipŋâ mimbat sâm hân torengen gâbâ gâip. Oi narâk ziren a ŋâi nâ ândian. Nâ Salomo wâlan. Ziŋ wangât op nâgât den birâme. ");
INSERT INTO kpf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niniwe kamân mâirâpŋâ, zen zo yatigâk den kubikkubik narâkŋan zen zaatŋâ a kâmut zi zeŋgât bâliŋâziŋâ sapsune hâuŋâ mimbi. Wangât, Niniwe kamân mâirâp, zen Yonagât den nâŋgâm umziŋ melâŋâwe, zorat. Oi narâk ziren a ŋâi nâ ândian, zirâŋ Yona wâlan. ");
INSERT INTO kpf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Zen kârâp sâum mân tik pame. Âmaŋ kâligen mân pam kwârakume. Zo buŋâ. Âsakŋâ zo tâtatŋâ kwâkŋan pane mirâ umŋan âsakŋâ âsagei a zen zâim ikpi. ");
INSERT INTO kpf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Siŋgâ zo sâkkaŋgât âsakŋâ. Siŋgâ âlipŋâ tâi ko sâkkâ zâk âsakŋan tâpap. Ka siŋgâ nâtâtik kâri ko sâkkâ ŋâtâtik muyagibap. ");
INSERT INTO kpf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Zorat ko zen galem oraŋgâm ândibi. Umziŋan ŋâtâtik muyagebapkât yatâ op ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Zen um sâk ŋâtâtik buŋâ. Âsakŋik op naŋgâbabân hâlâluyâk âsagem naŋgâbap. Kârâp âsakŋandâ âsagemap yatâ.” ");
INSERT INTO kpf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Den zo sâm naŋgâm ândei Parisaio a ŋâiŋâ nalem nimbapkât sâi mirin zâim nalem niniŋan tâip. ");
INSERT INTO kpf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yesu zâk bikŋâ mân saŋgon zâi tâipkât Parisaio a zâk nâŋgi mân dâp oip. ");
INSERT INTO kpf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Oi zorat Kembuŋâ itâ dukuip, “Parisaio a zen hâkop sâkŋik saŋgonme. Umziŋan ko on kâmbu sot bâliŋâ piksâm ziap. ");
INSERT INTO kpf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Zen a nâŋgânâŋgâziŋ buŋ. Dap nâŋge? Anutu zâk kut ŋâi ŋâi zorat sâkŋâ muyageipŋâ umŋâ mân muyageip? ");
INSERT INTO kpf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Zorat zen a kanpitâ zeŋgât umziŋ patâ zei kut ŋâi ŋâi âlipŋâ, zo mem ziŋgâm umziŋâ salekkubap. ");
INSERT INTO kpf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yei, Parisaio, zen daŋgât sot kâŋgan, zomap, kut ŋâi ŋâi zo bâzagârân gâbâ kânok Kembugât siŋgi sâm pame. Zorat torenŋâ den târârakŋâ sot Anutugât umziŋ patâ nâŋgânâŋgâ, zo birâme. Ŋâi lumŋâ ŋâi lubi. Zo yatâ upi. ");
INSERT INTO kpf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yei, Parisaio, zen mâpâmâpâse namin a sâtŋâ tapmeyân mâte tâtnat sâme. A ambân sombemân sâm âlip kwatniŋgâbigât umziŋ patâ kinmap. ");
INSERT INTO kpf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yei, Parisaio, zen a hanzâŋgowe kwak yatâ hibuk op zei a zen mân ek kwâkŋan âim game. Zen zo yatâ. Umziŋan bâliŋâ kârokŋâ ziap. Oi a ambân ziŋâ sâkziŋâ ikne âlip opmap.” ");
INSERT INTO kpf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesu zâk den yatâ sâi Kembugât gurumin a ŋâiŋâ sâtŋan mem itâ sâip, “Patâ, gâ den yatâ sânandâ Kembugât gurumin a neŋgât den sâm bâliŋ kwatniŋgat uap.” ");
INSERT INTO kpf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yatâ sâi. Yesuŋâ hâuŋâ itâ mâburem dukuip, “Yei, Kembugât gurumin den zorat galem a, zen kut ŋâi ŋâi yâmbâtŋâ a kwâkziŋan pam ziŋ bet bâsaŋ ândime. ");
INSERT INTO kpf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yei, Sâkurâpziŋ zen Propete zâŋgowe, zeŋgât kwagân kât kâsaget mindune kiri neule mot tuume. ");
INSERT INTO kpf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yatâ op sâkurâpziŋ zeŋgât nâŋgâne âlip oi ziŋâ zâŋgowe, zo zeŋgât kwagân neule mot tuume. ");
INSERT INTO kpf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Zorat Anutugât nâŋgânâŋgâyân den ŋâi itâ muyageip, ‘Nâ zeŋgâren Propete sot Aposolo sâŋgonzâŋgua gine nâmbutŋâ zâŋgom moliziŋgâm a nâmbutŋâ zâŋgone mumbi.’ ");
INSERT INTO kpf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Oi zorat mârumŋan a muyamuyagiŋ narâkŋan topkwap Propete zâŋgone gilâmziŋ geip, zorat tosa zo narâk zi ândie, zeŋgâren mâkâbap. ");
INSERT INTO kpf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kâmbam zo mârumŋan Abegâren gâbâ târokoi gam Sakaria, zâk tirik namin Kembugât siŋgi nalem uuŋâ zo naŋgâmŋan kuwe. Nâ perâkŋak sa nâŋgânek. Kâmbam zorat tosa a kâmut zi zeŋgâren mâkâbap. ");
INSERT INTO kpf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kembugât gurumin a zen nâŋgânâŋgâ âlipkât mâtâp dooŋguwe. Mâtâp dooŋgumŋâ naŋgo mem pâpan mem âiwe. Ziiŋak naŋgoyân mân bagiwe. Oi a ambân baginam utne mâtâp pâke kwarâwe.” ");
INSERT INTO kpf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Den yatâ sâm ari Kembugât gurumin den zorat galem a sot Parisaio a, zen topkwap ândei ândim yatâ op den sâi kâitkum mâsikâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Oi lâuŋan gâbâ den ŋâi nâŋgâne bâliŋâ oi denân pânatkât ek galem op ândiwe. ");
INSERT INTO kpf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Oi a ambân doŋbep patâ Yesugâren mindum pâlâtâŋ kin kiyân lâŋ lâŋ urâwe. Yatâ op kine topkwap arâp den itâ sâm dâzâŋgoip, “Zen Parisaio zeŋgât arik bâliŋ zeŋgâren âsagebapkât kârum ândibi. Sarâziŋaŋgât op san. ");
INSERT INTO kpf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kut ŋâi ŋâi tik ziap, zo mân tik zimbap. Zo ŋâran mâbâlakŋibap. Oi kut ŋâi ŋâi tik pâpanŋâ, zo ŋâran kagibap. ");
INSERT INTO kpf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ŋâtigân den tik sâme, zo gâtâm maayân âsagibap. Mirâ umŋan halop den sâme, zo gâtâm sombem kabâŋan sâm muyagibi.” ");
INSERT INTO kpf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Bukurâpnâ, nâ itâ dâzâŋgobâ. A sâkziŋik zâŋgobi, zeŋgât mân keŋgât upi. Zen um dâpziŋ mân tâmbetkubi. ");
INSERT INTO kpf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ŋâigât keŋgât upi, zorat dâzâŋgua nâŋgânek. Zâk gomŋâ kâbakŋei simân geibangât imbaŋâ zemŋâŋgap, Anutu, zâkkât keŋgât op ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nii sâmbâlâle, zo sâŋgân patâ buŋâ. Kât kuriŋâ mâiktârâ zagât pam bâtnâmbut mimban. Oi Anutu zâk zen pisuk patâ ziŋgit naŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Zâkŋâ a zeŋgât kâukziŋ sâmotŋâ aksik teŋgâziŋ ek nâŋgâm naŋgâmap, zorat keŋgât buŋ ândibi. Zen sâmbâlâle yatâ buŋâ. Zen a. Anutu zâk umŋandâ gâsuziŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Oi ŋâi dâzâŋgua nâŋgânek. Ŋâi zâk a ambân mâteziŋan sâm âlip kwatnimap, zo ko a bonŋâ, nâ yatigâk Anutugât sumbem arâpŋâ zeŋgât mâteziŋan sâm âlip kwâkŋaŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Oi ŋâi zâk a ambân mâteziŋan kwâimbânibap, zo ko a bonŋâ, nâŋgoot yatigâk sumbem a mâteziŋan kwâimbâŋaŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ŋâi zâk a bonŋâ nâ sâm bâliŋ kwatnibap, zakkât bâliŋâ zo âlip birâbirâŋâ. Ka ŋâi zâk Tirik Kaapum sâm bâliŋ kwâkŋaŋgâbap, zâkkât tosa zo Anutuŋâ mân birâbap. ");
INSERT INTO kpf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Gâtâm mâpâmâpâse namâziŋan mo a kutâ zeŋgâren diiziŋgâm âine den toren dap sânat sâm nâŋgâ kwâkâ mân upi. ");
INSERT INTO kpf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Narâk zoren den sâbi, zo Tirik Kaapumŋâ sapsum ziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","A osetziŋan gâbâ a ŋâiŋâ Yesu itâ sâm dukuip, “Patâ, âtânâ zâk ibânaŋgât bet boi zikŋik mem ândiap, zorat gâ dukunandâ kâsâpkum torenŋâ nâ nibap.” ");
INSERT INTO kpf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sâi Yesuŋâ itâ dukuip, “Ŋâiŋâ nâ a sâtŋâ mo a kutâ nâbaripkât nâgâren ga sat?” ");
INSERT INTO kpf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yatâ sâm den itâ târokwâip, “A nâmbutŋâ kut ŋâi ŋâi patâ zemziŋgap, zo ko ândiândi bonŋâ mân ziŋgâbap. Yatâ opŋâ umziŋ galem op ândibi. Zen kât sikumgât âkŋâle mân op ândibi.” ");
INSERT INTO kpf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yatâ sâmŋâ den sumbuŋâ ŋâi itâ dâzâŋgoip, “Sikum a ŋâigât kâlamŋan gom sambe patâ zemŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Oi umŋandâ itâ nâŋgip, ‘Nâ dap upat? Kut ŋâi ŋâi doŋbep patâ zemnigap, zorat mirâŋâ mân kinzap.’ ");
INSERT INTO kpf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yatâ nâŋgâm sâip, ‘Itâ upat. Nâ nalem silep kândaŋ ŋilip patâ tuumŋâ zoren âi pa tâpap. ");
INSERT INTO kpf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Gomsambe zemnigapkât mulunâk tâi narâk kârep om nem zâibat. Zorat sâtâre kwâkŋan ândibat.’ ");
INSERT INTO kpf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Yata sâi Anutuŋâ itâ sâm dukuip, ‘O, a nâŋgânâŋgâgâ buŋâ, ŋâtik ziren ândiândigâ bekan mimbat. Kut ŋâi ŋâi minduin, zo ŋâigât upap?’ ");
INSERT INTO kpf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Zorat sa nâŋgânek. Ŋâi zâk yatik Anutugât mân nâŋgânâŋgâ op zikŋâ siŋgi sikum kut ŋâi ŋâi mindui tâkŋaŋgâbap, zo ko Anutuŋâ zo yatik okŋaŋgâbap. Anutuŋâ a yatâ zo egi kanpitâ upap.” ");
INSERT INTO kpf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesuŋâ arâpŋâ itâ dâzâŋgom sâip, “Zorat op dâzâŋgobâ. Itâ mân sâbi, ‘Nen wan wan nem ândinat?’ Mo sâkziŋaŋgât itâ mân sâbi, ‘Nen wan wan mem ândinat?’ ");
INSERT INTO kpf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nalemŋâ bon buŋâ. Ândiândiŋâ bonŋâ. Sâk pâkeŋâ bonŋâ buŋâ. Sâkziŋandâ bonŋâ. ");
INSERT INTO kpf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Zen nii ziŋgit nâŋgâbi. Zen nep mân kârâm kâmitme. Zen nalem mân mindune tâpmap. Oi laŋ Anutuŋâ nalem muyagem ziŋgâmap. Zen ko nii yatâ buŋâ. Zen a. Anutu, zâk umŋandâ gâsuziŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Zen ândiândiziŋaŋgât nâŋgâm kwâkâm ko âlip ândine âi topŋan subap? ");
INSERT INTO kpf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Zen kut ŋâi mâik, zo âlip mân galem upme, zorâŋâ wâŋgât kut ŋâi ŋâi torenŋaŋgât nâŋgâm kwâkâ upme? ");
INSERT INTO kpf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Zen pâliŋpâliŋgât neuleŋâ âsagemap, zo ek nâŋgânek. Zâk hâmbâ nep mân tuumap. Oi sa nâŋgânek. A kutâ Salomo, zâk sikum patâ sot neule âlip zemŋaŋgip. Ka zâk hâmbâ neuleŋoot zo yatâ mân mem ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Oi neule âlip, zo hibukŋan itârâŋ muyagei muka sâmbum pane kârâbân simbap. Anutuŋâ sâi neule âlipŋâ muyagemap. Oi zeŋgât sâk pâke mot mân muyagem ziŋgâbap sâme? Nâŋgâm pâlâtâŋziŋ buŋâ, zen. Kembuŋâ ko âlip galem otziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Oi zen itâ mân nâŋgâbi, ‘Nen wan wan nem ândinat?’ Nalemgât nâŋgâ kwâkâ mân op ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Um kâtik a ambân hân dâp, zen um nâŋgânâŋgâziŋ zoren pane zemap. Zen ko yatâ mân upi. Ibâziŋandâ wan wangât kwakse, zo ek nâŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Anutu um topŋan ândibi, zorat umziŋ pane zimbap. Yatâ utneta sâkkât kut ŋâi ŋâi aksik ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Râma gakânâ, zen keŋgât mân op ândibi. Ibâziŋâ zâk um topŋaŋgât siŋgi kwaziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Zen kut ŋâi ŋâi zemziŋgap, zo a ambân kanpitâ ziŋgâbi. Yatâ opŋâ sumbemân sikum bonŋâ, zinziŋâ, zo mimbi. Zoren kâmbu a ziŋ mân mimbi. Zoren wâsâsâŋ ziŋ mân tâmbetkubi. ");
INSERT INTO kpf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kut ŋâi ŋâiziŋâ zemabân, zoren yatik umziŋ pane zemap.” ");
INSERT INTO kpf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Zen petziŋ lapŋâ kârâpziŋ sâune sei mambât ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kore a zen a kutâziŋandâ hân kârebân gâbâ âburem gam hâŋgiyân koi mâtâp mem pambigât mambât ândibi. Zen yatâ op ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","A kutâ, zâk âburem gâi kore arâpŋâ um gwâlâ ândine muyageziŋgâm zeŋgât nâŋgi sâtâreŋoot upap. Nâ perâkŋâk dâzâŋgobâ. Zâk nepkât pet lapŋâ nalem tap niniŋan zâmbari nalem nimbigât kore otziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","A kutâ, zâk ŋâtik tânâmŋan mo haŋsâsâgât purikâsm gâi um wâgân ândine muyageziŋgâbap, zo ko âlip upap. ");
INSERT INTO kpf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Zen itâ nâŋgânek. Kamân ŋâigât a zen kâsa ŋâtik ziren takâbi, narâk zo yatâ nâŋgâm um wâgânâk ândim kamânziŋ galem upi. ");
INSERT INTO kpf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Oi a bonŋâ nâ puriksâbatkât narâkŋâ mân nâŋgâm ândie. Narâknâ mân nâŋgâm tâtne gâbat, zorat mambâtnim um wâgân ândibi.” ");
INSERT INTO kpf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yesu zâk den yatâ sâi Peteroŋâ itâ sâm mâsikip, “Kembu, gâ den alotŋâ zi niiŋik mo ârândâŋ niŋaŋgât sat?” ");
INSERT INTO kpf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mâsiki Kembuŋâ den sumbuŋâ ŋâi itâ sâip, “A kutâ ŋâi zâk kore a gakârâpŋâ zeŋgât galem a ŋâi pam itâ dukubap, ‘Nâ âi ândia galem otziŋgâm ândim narâkŋan nalem dâpziŋanâk ziŋgâm ândiban.’ Oi zâk dap ândei galem a nâŋgânâŋgâŋoot sot sât luluŋoot sâsâŋâ? ");
INSERT INTO kpf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Galem a zâk nep sâm pindâpindâŋ, zo dâŋâk galem oi patâŋandâ gâbap, galem a yatâ zorat nâŋgi âlip upap. ");
INSERT INTO kpf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nâ bonŋâ sa nâŋgânek. A kutâ zâkŋâ galem a zo patâ pam kut ŋâi ŋâi galem upapkât sâm pindâbap. ");
INSERT INTO kpf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Oi galem aŋâ umŋan itâ nâŋgâbap, ‘Patânâ, zâk kârebân âimŋâ kek mân gâbap.’ Yatâ nâŋgâm kore a ambân zâŋgom mem ŋâi ŋâi otziŋgâbap. Otziŋgâmŋâ nalem om nem too kâtik nem um gulip op ândibap. ");
INSERT INTO kpf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","A kutâŋâ gâbapkât mân nâŋgâm gulipmalip ândibap oi a kutâ zo gam kom kâbakŋei bâliŋ mâme osetziŋan âi ândibap. ");
INSERT INTO kpf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kore a ŋâi zâk patâŋaŋgât den nâŋgâm diŋâ kwâkâbap, patâŋâ zâk tâkŋâ lapitpap. Oi hâuŋâ mem zâi kwap pindâbap. ");
INSERT INTO kpf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Oi ŋâi zâk patâŋaŋgât den mân nâŋgâm den kwâkâbap, zo zâk tâkŋâ lapitpap. Zo hâuŋâ mem gei kwap pindâbâp. A ŋâi zâk kut ŋâi ŋâi yâmbâtŋâ pindâpindâŋ, zo boŋâ yâmbâtŋik muyagei dâp upap. Oi ŋâi zâk nep patâ sâm pindipŋâ nep patâ zo tuugi dâp upap.” ");
INSERT INTO kpf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nâ hânân kârâp ua sem kut ŋâi ŋâi bâliŋâ sem pitiŋkubapkât gem gâwan. ");
INSERT INTO kpf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Too saŋgon niibi, zorat nâŋgâm ândim umnâ yâmbâriap. ");
INSERT INTO kpf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Zen nâgât itâ mân sâbi, ‘Zâk lumbeŋ muyagibapkât geip,’ Yatâ buŋâ. Nâ kâmbam âbâŋgubapkât gewan. Nâ kâsâpzâŋgobatkât gem gâwan. Zen dinnaŋgât op kâsâpagom ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Oi itârâŋ topkwap itâ muyagibap. Mirâ ŋâigât a ambân bâtnâmbut, zen âbâŋgum toren zagât toren karâmbut upi. ");
INSERT INTO kpf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nanŋâ ibaŋâ, zet kâsâpagobabot. Oi mam bârat, zet kâsâpagobabot. Iran sibun, zet kâsâpagobabot.” ");
INSERT INTO kpf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yatâ sâmŋâ a ambân aksik itâ sâm dâzâŋgoip, “Mirâ sumunkoi zen itâ sâme, ‘Map gâbamap.’ Sâne map gâmap. ");
INSERT INTO kpf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mirâ pitâyaŋgâm zei ekŋâ sâme, ‘Maa upâmap.’ Sâne yatâ opmap. ");
INSERT INTO kpf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sarâ a ambân, zen sumbemgât tobatŋâ ekŋâ nâŋgâme. Ka zen nâgât topnâ mân nâŋgâm kwâtâtime. ");
INSERT INTO kpf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Zen wangât mâtâp târârak sot gâŋgoŋâ, zo mân kâsâpkum ek nâŋgâme? ");
INSERT INTO kpf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gâ buku ŋâi sot kâsâp op dinzikŋâ zo kek kubikpabot. Yatâ mân otna kâsagandâ diŋgâ top likuliku agâren sâi zâkŋâ nâŋgâm kâwali arâpŋâ sâi gâsum diigim tâk namin gâbanbi. ");
INSERT INTO kpf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nâ perâkŋak dâgobâ. Gâ yen mân gâban. Gâ zoren tap ko kâsagâ kât pindâna âkiyâk gâban.” ");
INSERT INTO kpf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Narâk zoren a nâmbutŋâ ziŋâ Yesu den siŋgi itâ dukuwe, “Galilaia a nâmbutŋâ, zen Anutugât siŋgi sâm makau kom unam utnetâ Pilatoŋâ sâi kâwali arâpŋâ ziŋâ zâŋgom naŋgâwe. Zâŋgone a gilâm sot makau gilâm, zo ârândâŋ mâpotne giarip.” ");
INSERT INTO kpf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Den siŋgi yatâ dukune itâ mâsikâziŋgip, “Zen dap nâŋge? Zeŋgât tosaŋâ Galilaia a nâmbutŋâ zeŋgât tosa walip, zorat tosagât op tâmbetzâŋgoip? ");
INSERT INTO kpf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yatâ buŋâ. A nâmbutŋâ zen tosaziŋoorâk ândie. Zen umziŋ mân melâŋbiyân yatigâk tâmbetagobi. ");
INSERT INTO kpf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yerusalem kamânân a kiin nâmburân karâmbut Siloam mirâ kârep patâŋâ kwâratzâŋgoip. A kiin nâmburân kârâmbut zo tosaziŋandâ Yerusalem kamân mâirâp nâmbutŋâ walâziŋgip? ");
INSERT INTO kpf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yatâ buŋâ. Nâmbutŋâ zeŋgât tosa ziap. Dâzâŋgua nâŋgânek. Zen umziŋ mân melâŋbiyân yatigâk tâmbetagom kwâkâbi.” ");
INSERT INTO kpf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Den zo sâm naŋgâm Yesuŋâ den sumbuŋâ itâ sâip, “A ŋâiŋâ nepŋan nak koset ŋâi kâmiri lâmbarip. Oi mariŋâ zâk bonŋaŋgât âi kârumâip. ");
INSERT INTO kpf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yatâ opŋâ nep galem a itâ dukum sâip, ‘Nâŋgâ. Nâ nak zirat bonŋâ kârum ândia kendon patâ karâmbut âkap. Nak zo bonŋâ mân opmap, zorat ko kârâban. Wangât hângât kelâkŋâ yen mimbap?’ ");
INSERT INTO kpf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yatâ sâi ko galem aŋâ itâ dukuip, ‘Patâ, gâ birâna kendon kânok zi kirik. Oi nâŋâ topŋan hân kârâm pa pambâ. ");
INSERT INTO kpf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yatâ ua narâk ŋâin bonŋâ âsagibap mo buŋâ, zo iktat. Oi bon mân oi ek sâna kârâm pândat.’” ");
INSERT INTO kpf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Narâk ŋâin Yesuŋâ mâpâmâpâse namin zâim den siŋgi âlip dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Oi mâpâmâpâse namin zo ambân ŋâi tâip. Kendon patâ kiin nâmburân karâmbut umŋan wâkeŋâ okŋaŋgi ândeip. Wâkeŋâ okŋaŋgi kândâtŋâ pindiŋsâm ândeip. Dap op winziksâm ândibap? ");
INSERT INTO kpf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuŋâ ambân zo ekŋâ itâ dukuip, “Ambân gâ winziksânangât san.” ");
INSERT INTO kpf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yatâ sâmŋâ bikŋandâ kâukŋan pâi kândât winziksâi Anutu mâpâseip. ");
INSERT INTO kpf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesuŋâ kendonân ambân zo kubigipkât mâpâmâpâse namâ galem aŋâ nâŋgi bâlei kuk op sâip, “Nep mâme hilâm nâmburân kânok ziap. Zoren gane kubikziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yatâ sâi Yesuŋâ itâ mâburem dukuip, “Sarâ a zen. Kendonân doŋgi sot makâu gakârâpziŋ too nimbigât diiziŋgâm âime. ");
INSERT INTO kpf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ambân zi Abaramgât kiun. Sataŋŋâ saagi kendon kiin nâmburân karâmbut yatâ op ândeip. Oi nâŋâ kendonân kubiksan, zo nâŋgâne mân dâp uap?” ");
INSERT INTO kpf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yatâ sâi ko kâsa okŋaŋgâweŋâ aŋun urâwe. A ambân kâmut, zen ko kulem zorat umâlep patâ urâwe. ");
INSERT INTO kpf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu zâk den itâ târokwap dâzâŋgoip, “Antugât siŋgi âlip zorat mâtâp, zo wanân dâpkwap sâbâ? ");
INSERT INTO kpf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Zo wakum keetŋâ yatâ. A ŋâiŋâ nepŋan âi kendi kâmŋâ takâm nak oip. Oi nii ziŋâ gamŋâ bâranŋan pam tapme.” ");
INSERT INTO kpf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Oi itâ târokwap sâip, “Siŋgi âlipkât mâtâp, zo wanân dâpkwapâ? ");
INSERT INTO kpf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Zâk sii daŋgât yatâ. Ambân ŋâiŋâ sii daŋgât nalemân pam oi sei nalem naam doŋbep op naŋgip.” ");
INSERT INTO kpf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu zâk Yerusalem kamânân âibam âim kamân patâ sot kamân mâik mâigân siŋgi âlip dâzâŋgom arip. ");
INSERT INTO kpf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ari a ŋâiŋâ mâsikâm sâip, “Kembu, a bituktâ ziŋâ sumbemân zâibi, mo dap?” ");
INSERT INTO kpf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Oi Yesuŋâ den ŋâi itâ dâzâŋgoip, “Mâtâp gâbâkŋan bagibigât kâtigibi. Nâ dâzâŋgua nâŋgânek. A ambân doŋbep patâ, ziŋâ mâtâp gâbâkŋan baginam osibi. ");
INSERT INTO kpf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mirâ mariŋâ, nâ zaat hâŋgi dooŋgua hâŋgiyân kom itâ sâbi, ‘Kembu, mâtâp mem pânan.’ Sâne itâ dâzâŋgobat, ‘Nâ zen mân nâŋgâziŋgan. Zen waniŋ gok?’ ");
INSERT INTO kpf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mâsikâziŋga zen hâuŋâ itâ sâm dâtnobi, ‘Nen gâ sot ândim too nalem niwen. Oi kamâniŋaŋgât sombemân den siŋgi âlip sâna nâŋgâwen.’ ");
INSERT INTO kpf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Yatâ sâne itâ dâzâŋgobat, ‘Dâzâŋguan zo, zen waniŋ gok? Nâ mân nâŋgâziŋgan. Bâliŋ mâme a, zen birâninek.’ ");
INSERT INTO kpf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Oi Abaram, Isaka, Yakobo sot Propete nâmbuŋâ Anutugât um topŋan ândinetâ ziŋgitpi. Ka zen ko âkŋan ândimŋâ umbâlâ op isem ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Oi hân mirâsiŋ takâtakâŋan sot geigeiŋan sot hân toren toren, zobâ a ambân takâm Anutugât um topŋan bagimŋâ sii nalem patâ nem sâtâre op zimbi. ");
INSERT INTO kpf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nâŋgânek. A bet, zeŋgâren gâbâ nâmbutŋandâ kândom upi. A kândom, zeŋgâren gâbâ nâmbutŋandâ bet upi.” ");
INSERT INTO kpf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Narâk zoren Parisaio a nâmbutŋâ ziŋ Yesugâren gam itâ sâm dukuwe, “Herodeŋâ gobat sapkât hân zi birâm âi.” ");
INSERT INTO kpf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sânetâ dâzâŋgoip, “Zen âburem âim wâu ulin zo nâgât itâ sâm dukubi, ‘Nâŋgâ. Nâ irâk sot muka wâke moliziŋgâbat sot mâsek kubikziŋgâbat. Haŋsâi mâra nep tuuga âkâbap.’ ");
INSERT INTO kpf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Itârâŋ, muka sot mâra mâtâp âibatkât sâsâŋâ. Yerusalem kamânânâk Propete zâŋgome. Nâ zoren zaria nobi. Mân zaria sâi ko dap yatâ nobe?” ");
INSERT INTO kpf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yatâ sâm sâip, “O Yerusalem kamân marirâp, zen Propete zâŋgome. Anutuŋâ kore a sâŋgonzâŋgoi zeŋgâren gâne kâtŋâ mem zâŋgome. Kurukŋâ gwamârâp gâbâreziŋgâm abâtŋandâ lâmbamzâŋgomap, yatigâk nâŋâ a ambân kâmut kinnâ topŋan gâbâreziŋgâbâ sa birânime. ");
INSERT INTO kpf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nâŋgânek. Mirâ kamânziŋâ nâŋâ birâbat. Nâ sa nâŋgânek. Zen dum mân nek ândim itâ sâm nikpi, Kembugât sâtkât gaap, zâk sâm âlip kwâkŋaŋgânâ.” ");
INSERT INTO kpf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yuda zeŋgât kendon ŋâin Parisaio a zeŋgât a sâtŋâ ŋâiŋâ Yesu nalemgât diigi mirâŋan zarip. Oi a nâmbutŋâ zen zâk sot nalem ninam diŋaŋgât dap sâbap sâm ek tarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Oi a ŋâi kiŋ bik lâmbatlâmbat zoren zâi tâip. ");
INSERT INTO kpf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Oi Yesuŋâ ekŋâ Kembugât gurumin den zorat galem a sot Parisaio a mâsikâziŋgâm sâip. “Zen sânek. Kendonân a kubikkubikŋâ, zo orotŋâ mo mân orotŋâ?” ");
INSERT INTO kpf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yatâ sâi hiriŋsâm kine Yesuŋâ a zo bikŋandâ gâsum kubikŋaŋgâm sâŋgongui arip. ");
INSERT INTO kpf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ari ko itâ dâzâŋgoip, “Zeŋgâren gâbâ a ŋâigât nanŋâ mo makau kendonân lamân giari birâne tâpap mo sâmbune kopgâbap?” ");
INSERT INTO kpf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yatâ dâzâŋgoi den torenŋâ dukunam kwakŋâ birâwe. ");
INSERT INTO kpf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","A nalem ninam diiziŋgi mirin zâiwe. Mirin zâim kiaŋ mâteyâk âi tatne Yesuŋâ ziŋgitŋâ itâ dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Gâ a ŋâiŋâ sii nalem om sâi gamŋâ kiaŋ mâteyâk mân tâpan. Gâ kiaŋ mâteyâk âi tâtnandâ a pâtâ ŋâi gâbap. ");
INSERT INTO kpf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Gâi sii nalem mariŋâ itâ dâgobap. ‘Zo zâkkât tâtat. Gâ âmbi âi.’ Dâgogi a yenŋâ zeŋgât kiaŋ kândâtŋan âi tap aŋun upan. ");
INSERT INTO kpf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ŋâiŋâ sâi gamŋâ a gigiŋâ zeŋgât kiaŋân tâpan. Tâtna sii nalem mariŋandâ gekŋâ itâ dâgobap, ‘Buku, gâ zâi kiaŋ mâteyâk tâtnan.’ Yatâ dâgogi a mâteziŋan umâlep patâ nâŋgâban. ");
INSERT INTO kpf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ŋâi zâk umŋâ mem ge kwap ândibap, zâk ko mem zaatzaatŋâ. Ka ŋâi zâk sâk mâme op ândibap, zo ko mem ge kwâkwatŋâ.” ");
INSERT INTO kpf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yatâ sâmŋâ a diigip, zo itâ târokwap dukuip, “Gâ si nalem umbam buku, âtâ mun, torerâpkâ, kamârâpkâ mân diiziŋgâban. Wangât, zeŋgoot yatik narâk ŋâin diigim hâuŋâ mâkâne âkâbap, zorat. ");
INSERT INTO kpf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Itâ upan. Sii nalem ona sei a gigiŋâ sot kiŋ bitziŋ bâliŋ sot sen ŋâtâtik, a ambân yatâ zo diiziŋgâban. ");
INSERT INTO kpf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yatâ otna zeŋgoot hauŋâ mân mâkâne tosâziŋâ yen zei a târârakŋâ zaatpi, narâk zoren Anutuŋâ hâuŋâ gibap.” ");
INSERT INTO kpf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sâi nalem ârândâŋ nem tarâwe, zeŋgâren gâbâ a ŋâiŋâ itâ sâip, “Ŋâi zâk Anutugât um topŋan nalem nimbap, zâkkât nâŋga sâtâreŋoot uap.” ");
INSERT INTO kpf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sâi Yesuŋâ den siŋgi ŋâi itâ dukuip, “A patâ ŋâi sii nalem oip. ");
INSERT INTO kpf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sii nalem uuŋâ narâk mâte oi kore a ŋâi sâŋgongoi âi a zen zop kânŋan sâsâŋâ, zo itâ dâzâŋgoip, ‘Nalem mârum om kâtâŋ tuugen. Ganek.’ ");
INSERT INTO kpf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sâm dâzâŋgoi zen kut ŋâi ŋâiyân tâbi sâm birâm tarâwe. Oi ŋâi zâk sâip, ‘Nâ hân ŋâi kwâlâwan, zo ikpam âibâman. Zorat gâ patâgâ dukuna nâŋgi mân bâliŋ upap.’ ");
INSERT INTO kpf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ŋâi zâk sâip, ‘Nâ makau bâzagât sâŋgân mewan, zo âi ziŋgitpâman. Zorat patâgâ dukuna nâŋgi mân bâliŋ upap.’ ");
INSERT INTO kpf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ŋâi zâk sâip, ‘Nâ ambân mewangât mân gâbat.’ ");
INSERT INTO kpf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yatâ sâne kore a âburem âi patâŋâ dukui nâŋgâm kuk op itâ dukum sâŋgonguip, ‘Gâ kamânân mâtâp patin sot mâik mâigân âim a ambân zo yatâ zo diiziŋgâna ganek.’ ");
INSERT INTO kpf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sâi kore a zâk yatâ opŋâ patâŋâ dukum sâip, ‘Patâ, gâ den sat, zo lugan. Oi mirâ zo mân pikse.’ Dukui patâŋâ itâ dukuip, ");
INSERT INTO kpf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","‘Gâ dum âi kamân âkŋan mâtâbân hibukŋan âi gâsum diiziŋgâna ga mirânan piksâbi. ");
INSERT INTO kpf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nâ itâ dâzâŋgua nâŋgânek. A kândom zop dâzâŋgowan, zen mânâk nimbi.’” ");
INSERT INTO kpf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","A ambân kâmut patâ Yesu molim âine puriksâm itâ dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ŋâi zâk nâgâren ga ândibâ sâm ibâ mamŋâ sot ambin murarâŋâ sot âtâ munŋâ ponâŋâ sot ândiândiŋâ, zen mân birâziŋgâbam upap, zâk nâgât a mân op ândibap. ");
INSERT INTO kpf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ŋâi zâk zikŋâ poru nakŋâ mân lum nâgât mâtâp lâŋbap, zâk nâgât a mân op ândibap. ");
INSERT INTO kpf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Zeŋgâren gâbâ a ŋâi mirâ tuubamŋâ sâŋgânŋâ sâlâpkum kubik tuubap mo mân tuubap, zorat topŋâ ek nâŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Oi yatâ mân opŋâ kegâk mirâŋâ tandâ pâi giari kâtŋâ kârum birâbap. Biri ko a ambân ziŋâ ekŋâ girâŋŋaŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Zen itâ sâbi, ‘A zi âsak op mirâ patâ tuubam op tandâ kwânâŋgâm biri kinzap.’ ");
INSERT INTO kpf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A kutâ ŋâiŋâ a kutâ ŋâi kumbamŋâ kegâk mân âibap. Zâk itâ nâŋgâm kwâkâbap, ‘Nen a bituk ândienŋâ ândi a doŋbep ândie. Zen âlip zâŋgonat mo buŋâ?’ ");
INSERT INTO kpf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ziŋaŋgât nâŋgi gigiŋ oi kâsa kârebân tatne kâwali a nâmbutŋâ sâŋgonzâŋgoi zen âi lumbeŋaŋgât den sâne lumbeŋ op ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Oi yatik zeŋgâren gâbâ ŋâiŋâ kut ŋâi ŋâiŋâ zo mân birâmŋâ dabân nâgât a op ândibap? Zâk nâgât mân upap.” ");
INSERT INTO kpf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yatâ sâmŋâ den sumbuŋâ ŋâi itâ sâip, “Sii zo naamŋâ. Ka siigât naamŋâ buŋ oi ko dap oindâ naamŋâ dum upap? Zo buŋâ. ");
INSERT INTO kpf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sii bâliŋâ zo yatâ mo yatâ orotŋâ, zo mân ziap. Zo yen lum pâindâ âibap. A ŋâi zâk kindapŋootŋâ den zi nâŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kât mimiŋâ a sot bâliŋ mâme a, zen Yesugâren den siŋgi âlip nâŋgânam mindumarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Oi Parisaio a sot Kembugât gurumin den zorat galem a, zen zorat nâŋgâne bâliŋ oi Yesugât itâ sâwe, “A zâk bâliŋ mâme a zen sot tap nalem nemap. Man orotŋâ zo opmap.” ");
INSERT INTO kpf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yatâ sâne Yesuŋâ den sumbuŋâ ŋâi itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Zeŋgâren gâbâ a ŋâigât râma 1 handeret ândibi. Oi zeŋgâren gâbâ kânoktâ âi buŋ oi birâbap? Zo yatâ buŋâ. Kâmut patâ 99 zo birâziŋgâm buŋ upap, zo kârubap. ");
INSERT INTO kpf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kârum ma muyagem umâlip op âkom âibap. ");
INSERT INTO kpf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Âim bukurâp sot kamârâp dâzâŋgom sâbap, ‘Sâtâre utnâ. Râmanâ buŋ oip, zo muyagian.’ ");
INSERT INTO kpf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nâ dâzâŋgua nâŋgânek. Zo yatigâk a 99 zen târârakŋâ ândine sumbemân sâtâre patâ muyagibap. Ka bâliŋ mâme a kânokŋâ umŋâ melâŋi zâkkât op sumbemân sâtâre patâ walâm yâmbâtŋik muyagibap.” ");
INSERT INTO kpf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yatâ sâmŋâ den ŋâi itâ târokwap sâip, “Dap nâŋge? Ambân ŋâiŋâ kât bâzagât mem ândibap. Mem ândei kât kânok gei buŋ oi birâbap? Buŋâ. Zâk kârâp sâumŋâ mirâ pitâm kârum ma muyagibap. ");
INSERT INTO kpf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kârum muyagemŋâ ambân bukurâpŋâ, kamârâpŋâ zâŋgonsâi gane itâ dâzâŋgobap, ‘Kâtnâ buŋ oip, zo muyagian, gât ko sâtâre utnâ.’ ");
INSERT INTO kpf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Zorat sa nâŋgânek. Zo yatik bâliŋ mâme a mo ambân kânok umŋâ melâŋi Anutugât sumbem arâp zen sâtâre upme.” ");
INSERT INTO kpf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesuŋâ den siŋgi ŋâi itâ sâm dâzâŋgoip, “A ŋâi nanzatŋâ zagât ândiwet. ");
INSERT INTO kpf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nan kwakŋandâ ibâŋâ itâ dukuip, ‘Ibâ, gâ kât sot sikum nâgât siŋgi sâin, zo mem ni.’ Yatâ sâi kât sot sikum kâsâpkumŋâ munŋâ pindâm âtâŋaŋgât siŋgi pâi tâip. ");
INSERT INTO kpf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Oi bet katep zâk sirâm bituktâ ândim sikum sot kât zo aksik mem ba hân kârebân arip. Zoren âi laŋ ândim bâliŋ top top opŋâ kât sot sikum zo zoren ziŋgâm naŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kât sot sikum zo buŋ oi ândim hân zoren pu patâ muyageip. Oi a zo dap upâ sâm kwagip. ");
INSERT INTO kpf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hân mariŋâ ŋâi zâkkâren ari sâi hibukŋan âi bâu galem ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A zen nalem aŋgân kârâŋaŋgâne yen tap tepŋaŋgât opŋâ bâu zeŋgât nalem nimbam oip. ");
INSERT INTO kpf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yatâ opŋâ nâŋgânâŋgâŋâ pâroŋsâi itâ nâŋgip, ‘Ibânaŋgât nep a kâmut, zen nalem nem âkon op ândine nanŋâ nâ zi tepkât mumbâman. ");
INSERT INTO kpf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","19","Zorat nâ kamânan âim ibânaŋgâren takâm itâ sâm dukubat, Ibânâ nâ bâliŋ mâme a. Tosanandâ sumbemân sot gâgâren ziap, gât ko nâgât nangâ mân sâna ândibat. Yen sâna gâgât nep a op ândibat.’ ");
INSERT INTO kpf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yatâ sâm ibâŋaŋgâren arip. Ari ibâŋandâ kârebân gâbâ ekŋâ umŋâ nâŋgâm sârârâk kârâm âi lum mâŋgarip. ");
INSERT INTO kpf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mâŋgari itâ dukuip, ‘Ibânâ nâ bâliŋâ mia tosanandâ sumbemân sot gâgâren ziap, gât ko nâgât nangâ dum mân sâna ândibat.’ ");
INSERT INTO kpf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yatâ sâi ibâŋandâ kore a itâ dâzâŋgom sâŋgonzâŋgoip, ‘Kek âi hâmbâ âlipŋâ sot donet sot kipâke mem ga pindânek. ");
INSERT INTO kpf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Oi makau gwamŋâ patâ diim gam kom une nem sâtâre utnat. ");
INSERT INTO kpf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nannâ zâk moibân gâbâ zaatsap. Zâk buŋ oibân gâbâ muyagem gaap.’ Yatâ sâi sâtâre topkwap urâwe. ");
INSERT INTO kpf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Oi nan kunŋâ zâk nebân ândiepŋâ puriksâmŋâ kamân naŋgâmŋan ga kin kep kwamit nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Zâkŋâ sâi kore a ŋâi gâi mâsikâmŋâ sâip, ‘Kep zo top dapkât?’ ");
INSERT INTO kpf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Oi zâkŋâ sâip, ‘Mungâ gaap. Gaapkât ibâgandâ sâi makau gwam patâ kom uen.’ ");
INSERT INTO kpf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yatâ dukui nan kunŋâ zâk kuk opŋâ kamânân man bageip. Ibâŋandâ nâŋgâm kamân ginŋan geim um lumbeŋ den dukuip. ");
INSERT INTO kpf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yatâ dukui mân nâŋgânâŋgâ op kin itâ dukuip, ‘Nâŋgat. Nâ kendon patâ doŋbep kore otgim ândim sâtkâ luman. Yatâ ândia gâ noniŋ gwamŋâ mân nina nâ sot bukurâpnâ nen kom om nem sâtâre urâwen. ");
INSERT INTO kpf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ka bet katepkâ, zâk laŋ ambân zen sot ândim kât sikumgâ tâmbetkum gulipkum naŋgip. Zâk yatâ zorâŋ âburem gâi sânandâ makau gwam patâ kom nie.’ ");
INSERT INTO kpf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Sâi ibâŋandâ itâ dukuip, ‘Nannâ, gâ narâk dâp nâ sot ândim gâmatŋâ kut ŋâi ŋâi nâgâren ziap, zo gâgât siŋgi op naŋgap. ");
INSERT INTO kpf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ka mungâ ko moipŋâ zaatsap. Oi zâk buŋ oipŋâ dum muyagiap, zorat ko sâtâre oindâ dâp upap.’” ");
INSERT INTO kpf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuŋâ arâpŋâ den siŋgi ŋâi itâ sâm dâzâŋgoip, “Sikum a patâ ŋâigât kât sikum galem a ŋâi ândeip. A zorat itâ sâne patâŋâ nâŋgip, ‘Galem a, zâk mem gulipkuap.’ ");
INSERT INTO kpf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yatâ sâne sâi gâi dukuip, ‘Nâ gâgât den sâne nâŋgan. Gâ yatâ zorâŋâ dum zagâtŋâ mân galem ândiban. Ekapkâ mem gâna kât sikumgât topŋâ ikpâ.’ ");
INSERT INTO kpf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Sâi galem a zo umŋan itâ sâip, ‘Galem a nep zo betnan mei dap upat? Nâ imbaŋâ buŋâ. Nep kârâm kâmitpatkât âkon uan. Nâ kanpitâ ândibatkât âkon uan. (Wangât, Yuda zeŋgâren a kanpitâ zen ândim oletziŋgâmarâwe, zorat op sâip.) ");
INSERT INTO kpf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Irabot nâŋgan. Patânâ molinigi a patânaŋgât sikum tosa miwe, zeŋgâren âi buku ua sâne zeŋgât mirin ândibat.’ ");
INSERT INTO kpf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yatâ sâm patâŋaŋgât tosa miwe, kânok kânok zâŋgonsâi gawe. Oi zâkŋâ a ŋâi mâsikâm sâip, ‘Patânaŋgât tosa gâgâren dabutâ ziap?’ ");
INSERT INTO kpf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mâsiki zâkŋâ sâip, ‘Kelâk âmaŋân pâpanŋâ 1 handeret.’ Sâi itâ sâm dukuip, ‘Ekap zi mem 50 kulemgu.’ ");
INSERT INTO kpf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","A yatâ sâmŋâ a ŋâi mâsikip, ‘Patânaŋgât tosa gâgâren dabutâ ziap?’ Sâi itâ sâip, ‘Sibit keetŋâ 1 handeret.’ Sâi itâ dukuip, ‘Ekap zi mem 80 kulemgu.’ ");
INSERT INTO kpf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yatâ oi patâŋâ nâŋgâmŋâ galem a bâliŋâ zorat nâŋgânâŋgâ, zo nâŋgi imbaŋâ oi sâm âlip kwâkŋaŋgip.” Yesuŋâ yatâ sâmŋâ târokwap itâ sâm dâzâŋgoip, “Um kâtik a, zen kut ŋâi ŋâi utnam nâŋgânâŋgâziŋ patâ zei upme. Sumbemgât siŋgi a, zen yatâ zo mân zemziŋgap. ");
INSERT INTO kpf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Zorat dâzâŋgua nâŋgânek. Zen zo yatik hângât kât sikum bâliŋâ zi a zen ziŋgâne buku otziŋgâbi. Yatâ utne gâtâm hângât sikum buŋ oi narâk patin, zen âlip sumbem kamânân ândibigât sâsâŋâ. Oi sumbem kamânân ândiândiŋ âlip ândibi.” ");
INSERT INTO kpf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","A ŋâi zâk kut ŋâi ŋâi yenŋâ dâŋbâŋ galem upap, zâkŋâ kut ŋâi ŋâi bonŋâ patâ zo âlip galem upap. Ŋâi zâk kut ŋâi ŋâi yenŋâ mem gulipkubap. Zâkŋâ yatik bonŋa mem gulipkubap. ");
INSERT INTO kpf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Zen hângât kât sikum dâŋ mân galem upi, zo ko dap yatâ kut ŋâi ŋâi bonŋâ ziŋgâbap? ");
INSERT INTO kpf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","A zeŋgât kut ŋâi ŋâi giwe, zo dâŋ mân galem otna gikâ siŋgi zo dap yatâ gibap? ");
INSERT INTO kpf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kore a ŋâiŋâ a patâ zagât zekât kore âlip mân upap. Zâk ŋâigât umŋâ kiri ŋâi ekŋâ âkon upap. Zen yatigâk Anutugât nep sot sikumgât nep, zo dap yatâ mâtakâzikâm mem ândibi?” ");
INSERT INTO kpf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesuŋâ den zo sâi Parisaio a zen kât sikumgât âkŋâle zeipkât diŋâ kândâtkom girâŋâwe. ");
INSERT INTO kpf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Utne itâ dâzâŋgoip, “Zen a zeŋgât mâteziŋan nen a târârakŋâ sâme. Ka Anutuŋâ ko umziŋaŋgât topŋâ ekmap. A ziŋâ kut ŋâi ikne âlip opmap, zo ko Anutuŋâ egi bâliŋ opmap. ");
INSERT INTO kpf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kembugât gurumin den sot Propete zeŋgât den zem gam Yohanegâren gâip. Zorat kwâkŋan Anutu um topŋan ândiândiŋ, zorat den siŋgi âlip, zo âsagem laŋ kârâm ariap. A ambân den siŋgi zo nâŋgâm baginam kâtigime. ");
INSERT INTO kpf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Hân sot sumbem, zet buŋ utâ sâm buŋ upabot. Ka Kembugât gurumin den zo mân buŋ upap. ");
INSERT INTO kpf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","A ŋâi, zâk ambin birâm ŋâi mimbap, zâk târotârozik mânâŋgât tosa patâ mimbap. A ŋâi, zâk ambân birâbirâŋ zo mimbap, zâk yatigâk tosa patâ mimbap.” ");
INSERT INTO kpf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Sikum a patâ ŋâi ândeip. Zâk hâmbâŋâ neule âlip sâŋgân zâizâiŋ zo mem ândeip. Oi sirâmŋâ sirâmŋâ sii nalem âlipŋâ zo nem sâtâre op ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Oi a kanpitâ ŋâi ândeip, kutŋâ Lasaro. Zâkkât sâkŋâ zo useyâk. Zâkŋâ patâgât mirâ mâtâp bagibagiŋan zemâip. ");
INSERT INTO kpf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Zâk a patâgât mirin gâbâ nalem buputŋâ gâi nimbapkât nâŋgâm ândeip. Sâknam nâŋgâm zem tâi wâu ziŋâ gam useŋâ nâmbâlapkumarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","A kanpitâ zo yatâ op ândimŋâ moip. Oi Anutugât sumbem a, ziŋâ ge diim zâi Abaramgât um topŋan pane ândeip. Bet sikum a zo moi hanguwe. ");
INSERT INTO kpf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Zâk simân gei sâknam patâ nâŋgâm ândim siŋâ pâi zari Lasaro zâk Abaram um topŋan tâi egip. ");
INSERT INTO kpf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ekŋâ konsâm sâip, ‘O Abaram sâkunâ, nekŋâ umgâ bâliŋ oi Lasaro sâŋgonguna sâlâpŋandâ tooin pam sâmbum gem nâmbâlamnan pâi sânduksâik. Na ziren kârâbân sâknam patâ nâŋgâm ândian.’ ");
INSERT INTO kpf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Sâi Abaramŋâ itâ dukuip, ‘Katepnâ, nâŋgâ. Gâ hânân âkŋâle kwâkŋan ândein, zo mârum âkip. Oi Lazaro zâk umbâlâ ândeip, zo mârum âkip. Zâk zorat umâlebân ândiap. Ka gâ ko sâknam kwâkŋan ândiat. ");
INSERT INTO kpf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Osetniŋan sim patâ kinzap, gât ko zibâ zeŋgâren dap op gibi? Oi zeŋgâren gâbâ zi dap op kopgabi?’ ");
INSERT INTO kpf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Sikum a patâ, zâk itâ sâip, ‘Ibânâ, ŋâi dâgoga nâŋgâni. ");
INSERT INTO kpf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ândi nâgât kamânân murâpnâ bâtnâmbut ândie. Zen sâknam kamân ziren gabegât Lasaro sângonguna âim girem den dâzâŋgobap.’ ");
INSERT INTO kpf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Sâi Abaramŋâ sâip, ‘Buŋâ. Mose sot Propete, zeŋgât den girem ziap, zo nâŋgâbi.’ ");
INSERT INTO kpf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sâi ko sâip, ‘Ibânâ Abaram, yatâ buŋâ. Zeŋgât den nâŋgâm umziŋ mân melâŋbi. Ka a ŋâiŋâ mumuŋan gâbâ zaat sâi ko umziŋ melâŋbe.’ ");
INSERT INTO kpf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Sâi itâ sâm dukuip, ‘Zen Mose sot Propete zeŋgât den birâmeyân mumuŋan gâbâ ŋâiŋâ zaat ai dâzâŋgoi yatik birâbi.’” ");
INSERT INTO kpf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuŋâ arâpŋâ den itâ sâm dâzâŋgoip, “Bâliŋaŋgât nep tuutuuŋ, zo muyagibap. Dap yen zimbap? Ka a ŋâi zâk bâliŋaŋgât nepŋâ tuubap, yei, zâk dap upap? ");
INSERT INTO kpf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ŋâi zâk a gigiŋâ ŋâi okŋaŋgi bâliŋâ upap, zo ko tosa yâmbât mimbap. Mârumŋan kât sumun yâmbât patâ gânduŋan saamŋâ saruyâm giari sâi ko zo bâbâlaŋ opap. Zen galem oraŋgâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Bukugâ ŋâi bâliŋâ oi kubikŋaŋgâban. Otna umŋâ melâŋi tosaŋâ birâban. ");
INSERT INTO kpf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Oi sirâm kânogân tosa nâmburân zagât muyagem sâp nâmburân zagât gam sapsuubap, ‘Buku yatâ otgim umnâ bâliŋ uap,’ Zâk yatâ sâi tosaŋâ birâban.” ");
INSERT INTO kpf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposolo zen Kembu itâ sâm dukuwe, “Gâ nâŋgâm pâlâtâŋniŋâ târokwap niŋgâban.” ");
INSERT INTO kpf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sâne Kembuŋâ itâ dâzâŋgoip, “Nâŋgâm pâlâtâŋziŋ bonŋâ mâiktârâ, mundo keetŋâ yatâ, zemziŋgi wakum nak ândi, zo sâmbuyaŋgâm saruyân gei kinbapkât dukune sâtziŋ lubap.” ");
INSERT INTO kpf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yatâ sâmŋâ itâ sâip, “Zeŋgâren gâbâ a ŋâi, zâkkât kore aŋâ nep tuum ândim mo râma galem ândim ŋâtiksâisâi gâi itâ dukubap? ‘Gâ mirin zâi tâtna nalem om gibâ.’ ");
INSERT INTO kpf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yatâ buŋâ. Itâ dukubap, ‘Gâ sâŋgum kâu lapŋâ nalemnâ om pâna nia gikâ bet om nimban.’ ");
INSERT INTO kpf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nep a zo nep sâm pindip, zo tuugi nâŋgi âkip. Dabân sâm âlip kwâkŋaŋgâbap? ");
INSERT INTO kpf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Zeŋgât topziŋ yatâ ziap. Zen Anutuŋâ nep sâm ziŋgip, zo op naŋgâm itâ sâbi. ‘Nen kore a kwakmak. Nep sâm niŋgip, zorigâk tuumen.’” ");
INSERT INTO kpf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesuŋâ Yerusalem kamânân âibam Galilaia sot Samaria osetzikŋan arip. ");
INSERT INTO kpf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kamân ŋâin zari sâk bâlâ a bâzagât ziŋâ ekŋâ âkŋanâk kin den sâm itâ sâwe, ");
INSERT INTO kpf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“O patâ Yesu, neŋgât umgâ bâliŋ oik.” ");
INSERT INTO kpf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sâne ziŋgitŋâ itâ dâzâŋgoip, “Zen âim sâkziŋâ tirik namâ galem a tirâpzâŋgone ikpi.” Sâi zen âim tatne useziŋ sogei sâkziŋ âlip oip. ");
INSERT INTO kpf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Oi zeŋgâren gâbâ a kânokŋâ useŋâ sogei ekŋâ puriksâm gâip. Puriksâm den kâtik sâm Anutu mâpâseip. ");
INSERT INTO kpf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Zâkŋâ Yesu kiŋ topŋan gei zem tap sâiwap sâip. A zo Samaria hânân gokŋâ. ");
INSERT INTO kpf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesuŋâ itâ sâip, “A bâzagât kubikziŋgan. Nâmbutŋâ a nâmburân kimembut âlip ue, zo ikâ? ");
INSERT INTO kpf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Zeŋgâren gâbâ a ŋâi âburem gam Anutugâren sâiwap mân se? Birâm âine gâ kamân ŋâin gokŋandâ gikik gaat?” ");
INSERT INTO kpf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yatâ sâm Samaria a zo itâ dukuip, “Gâ nâŋgâm pâlâtâŋgaŋgât âlip uat, gât ko zaat âi.” ");
INSERT INTO kpf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Parisaio a, zen Yesu mâsikâm sâwe, “Anutu um topŋan tâtatŋâ, narâk ikâ zoren muyagibap?” Sâne itâ sâm dâzâŋgoip, “Anutugât um topŋan tâtatŋâ, zo senŋâ mân igikŋâ, gât ko itâ mân sâbi, ‘Ziren âsagiap mo ândiren âsagiap.’ Nâŋgânek. Anutu um topŋan tâtatŋâ, zo osetziŋan âsagem ziap.” ");
INSERT INTO kpf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesuŋâ arâpŋâ itâ dâzâŋgoip, “Gâtâm narâk ŋâin, zoren a bonŋâ âsagibatkât narâkŋâ iknam upi. Zo mân ikpi. ");
INSERT INTO kpf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Narâk zoren a nâmbutŋandâ sâbi, ‘O, ziren neŋgâren âsagiap. Hân ândiren zeŋgâren âsagiap.’ Yatâ sânetâ mân âibi. Oi nâŋgâne mân bon upap. ");
INSERT INTO kpf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Hânpân zâk hân muruk toren toren âsagem naŋgâmap, zo yatik a bonŋâ nâgât narâknan âsagei a aksik nikpi. ");
INSERT INTO kpf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kândom ko a narâk ziren ândie, zen a bonŋâ nâ kândâtnone sâknam patâ nâŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noa ândeip, narâk zoren kut ŋâi ŋâi urâwe, zo yatik a bonŋâ nâgât narâk zo mâte oi yatâ upi. ");
INSERT INTO kpf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa ândeip, narâk zoren a zen sii nalem sot too kâtik nem seroŋ kwap ândiwe. Ambân aŋgâgwaŋgâ urâwe. Yatâ op mân nâŋgâm ândine Noa sot narâpŋâ zen waŋgâyân zâine too uurup takâm gwâkâziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Loti ândeip, narâk zoren yatik urâwe. Nalem sot too kâtik nem seroŋ kwap ândiwe. Kut ŋâi ŋâi aŋgâgwaŋgâ urâwe. Nep kârâm kâmit mirâ nep tuuwe. ");
INSERT INTO kpf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yatâ op ândine Lotiŋâ Sodom kamân birâm ari narâk zoren sumbemân gâbâ kârâp sot kât kârâpŋâ sot sumbem tipŋâ gem gâi kamân zoren a ambân buŋ op nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","A bonŋâ nâŋâ âsagibat, narâk zoren a yatik upi. ");
INSERT INTO kpf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Narâk zoren a ŋâi sombemân tâpapŋâ sikum mimbapkât mirin mân zâibap. Ŋâi zâk nebân ândibapŋâ zâk kamânân mân âburibap. ");
INSERT INTO kpf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Zen Loti âmbinŋaŋgât den siŋgi nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ŋâi zâk ândiândiŋâ aŋgân kâri gulipagobap. Ŋâi zâk ândiândiŋâ biri muyageŋaŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nâ dâzâŋgua nâŋgânek. Ŋâtik zoren a zagât, zet mirâ ŋâin uman zeitâ ŋâi mem, ŋâi birâbat. ");
INSERT INTO kpf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ambân zagât, zet nalem sobem tâitâ ŋâi gâsum, ŋâi birâbat. ");
INSERT INTO kpf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(A zagât nebân kiritâ ŋâi mem, ŋâi birâbat.)” ");
INSERT INTO kpf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesu zâk den zo sâm naŋgi arâpŋâ ziŋâ mâsikâm sâwe, “Kembu, ikâ zoren âsagibap?” Sâne itâ dâzâŋgoip, “Bâu mo zuu kârokŋâ ŋâi zei zoren nii keŋ ziŋâ ninam mindume.” ");
INSERT INTO kpf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesugât a, zen umziŋ mân âkon op narâk dâp ninâu sâm ândibigât Yesuŋâ den siŋgi itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Kamân ŋâin top likuliku a ŋâi ândeip. Zâk Anutu sot a mân hurat kwâtziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Oi kamân zorenâk ambân malâ ŋâi ândeip. Zâk narâk dâp a sâtŋaŋgâren âim itâ dukumâip, ‘Gâ betnan mem kâsanâ nekât den kubikpan.’ ");
INSERT INTO kpf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","A sâtŋâ zâk malâ zâkkât den birâmâip. Ândimŋâ umŋandâ itâ sâip, ‘Nâ Anutu mo a hurat mân kwâtziŋgâman. ");
INSERT INTO kpf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ka malâ zâk narâk dâp sâm gâmapkât bekŋan mimbâ. Bekŋan mân mia sâi ko âsâbâŋ nâgâren gâi sâknâ âkon opap.’” ");
INSERT INTO kpf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kembu zâk den zo sâm nangâm sâip, “A sâtŋâ bâliŋandâ den sâip, zo nâŋgâm kwâtâtibi. ");
INSERT INTO kpf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Anutugât a ambân gakârâpŋâ, zen ŋâtik sirâm dâp konsâm ninâu sâme, zo mâkâziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Zâk mân ândei kârep oi kegâk betziŋan mimbap. A bonŋâ nâŋâ gâtâm âburem gam hânân a ambân nâŋgâm pâlâtâŋziŋoot muyageziŋgâbat mo buŋâ? Zorat umziŋ galem op ândibi.” ");
INSERT INTO kpf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","A nâmbutŋâ, zen ândiândiziŋaŋgât nâŋgâne târârak oi a toren zeŋgât nâŋgâne mân dâp opmap. A yatâ zo, zeŋgât den sumbuŋâ ŋâi itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“A zagât, zet Anutu mâpâsiram tirik namin zâiwet. Ŋâi zâk Parisaio, ŋâi ko kât mimiŋ a ŋâi. ");
INSERT INTO kpf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisaio a zâk kin zikŋaŋgât nâŋgi zari ninâu itâ sâip, ‘O Anutu, a nâmbutŋâ zen kâmbam kume. Kâmbu upme. Bâliŋâ top top upme. Nâ zen yatâ buŋâ. Kât mimiŋâ a ândiren zi itâ buŋâ. Oi nâ zorat sâiwap dâgogan. ");
INSERT INTO kpf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sirâm nâmburân zagât zorat umŋan sirâm zagât nalem birâm zorat kendon ândiman. Oi kut ŋâi ŋâi memŋâ bâzagârân gâbâ kânok zo gâgât siŋgi sâm pâman.’ Yatâ sâm ninâu sâip. ");
INSERT INTO kpf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kât mimiŋ aŋâ ko tutukuŋan kin aŋun op pindiŋsâm kin itâ sâm ninâu sâip, ‘O Anutu, nâ bâliŋ mâme a. Nâ a bâliŋâ zorat gâ mân birâniban.’ Zâk yatâ sâm ninâu sâip.” ");
INSERT INTO kpf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesuŋâ yatâ sâmŋâ itâ sâip, “Nâŋgânek. Kât mimiŋ a zâk Anutuŋâ tosaŋâ biri mirâŋan arip. Ka Parisaio zâk tosaŋâ zemŋaŋgip. Ŋâi zâk zikŋaŋgât ŋâŋgi zari Anutuŋâ kâbakŋeŋaŋgâbap. Ŋâi zâk zikŋaŋgât nâŋgi gigiŋ oi Anutuŋâ mem zaatŋaŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ambân ziŋ murarâpziŋ diiziŋgâm Yesugâren âim bikŋâ gâsuziŋgâbapkât sâne arâpŋandâ ziŋgitŋâ keŋgât minziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yatâ utne Yesuŋâ arâpŋâ zâŋgonsâi gane itâ dâzâŋgoip, “Zen birâne katep mâik zen nâgâren ganek. Mân pâke kwatnek. Zi yatâ zo, zen Anutu um topŋangât siŋgi kwatziŋgâziŋgâŋ. ");
INSERT INTO kpf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A ambân ziŋ umziŋ diim gei katep yatâ upi, zen Anutu um topŋan ândiândigât siŋgi upi. Ka ŋâi zâk katep yatâ mân upap, zâk mân bagibap.” ");
INSERT INTO kpf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Oi sikum a ŋâiŋâ Yesu mâsikâm sâip, “Patâ âlipŋâ, nâ dap op ândiândi tâmbâŋaŋgât siŋgi upat?” ");
INSERT INTO kpf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sâi Yesuŋâ sâip, “Nâgât âlipŋâ wangât nonsat? Âlip mariŋâ Anutu kânok. ");
INSERT INTO kpf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Oi gâ Kembugât gurumin den nâŋgâmat. Zo itâ. Ap ambin, zet mân birâyaŋgâbabot. Gâ kâmbam mân kumban. Gâ kâmbu mân upan. Gâ bukugaŋgât sârân sâsâŋ mân sâban. Ibâ mamgâ hurat kwatzikâm sâtzik luban.” ");
INSERT INTO kpf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Sâi sikum a zâk itâ sâip, “Zo katepnan gâbik topkwap op gâwan. Ŋâi mân bira ziap.” ");
INSERT INTO kpf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sâi Yesuŋâ den zo nâŋgâm itâ sâm dukuip, “Kânok birâna ziap, zo upan. Gâ kut ŋâi ŋâi tatgigap, zo aksik pam kât mem a kanpitâ ziŋgâban. Yatâ op sumbemân sikumgoot upan. Oi ga nâ sot pâlâtâŋ op moliniban.” ");
INSERT INTO kpf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yatâ dukui a zo sikum patâ zemŋaŋgipkât umŋâ bâliŋ oip. ");
INSERT INTO kpf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yatâ oi Yesuŋâ ekŋâ itâ sâip, “A kât sikum patâŋâ Anutu um topŋan bâginam kwakpi. ");
INSERT INTO kpf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bâu patâ kamele, zâk kuup mâtâpŋan bagibap, zo yâmbâtŋâ. Ka a sikumŋootŋâ Anutugât um topŋan bagibagiŋ, zo yâmbâtŋâ walâwalâŋ.” ");
INSERT INTO kpf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sâi nâŋgâm kirâwe, zen itâ sâm mâsikâwe, “Zo yatâ zorâŋ dap yatâ sumbemân baginat?” ");
INSERT INTO kpf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Aŋâ kut ŋâi ŋâi utnam kwakme, zo Anutuŋâ mâtâpŋâ âlip muyagemap.” ");
INSERT INTO kpf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Sâi Peteroŋâ itâ dukuip, “Nen kut ŋâi ŋâiniŋâ aksik kândâtkom gâ moligiwen.” ");
INSERT INTO kpf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Sâi Yesuŋâ itâ dâzâŋgoip, “Nâ perâkŋak dâzâŋgobâ. Zeŋgâren gâbâ ŋâi zâk Anutu um topŋan ândiândiŋaŋgât opŋâ kamânŋâ mo ambâ murarâpŋâ mo âtâ murâpŋâ, mo ibâ mamzatŋâ kândâtzaŋgobap, zo ko narâk ziren hâuŋâ doŋbep mimbap. Oi narâk patin ândiândi tâmbâŋâ mimbap.” ");
INSERT INTO kpf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu zâk arâpŋâ sâi gane itâ sâm dâzâŋgoip, “Nâŋge. Nen Yerusalem kamânân zâinamen. Oi Propete a, zen a bonŋâ nâgât den kulemguwe, zorat bonŋâ âsagibap. ");
INSERT INTO kpf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nâ um kâtik a zeŋgât bitziŋan zaria den sâm sinnan gem sâm bâliŋ kwatnim sâknan tâpkubi. ");
INSERT INTO kpf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Oi inzutŋâ lapitnim none mumbat. Mom sirâm karâmbut tapŋâ mumuŋan gâbâ zaatpat.” ");
INSERT INTO kpf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesuŋâ yatâ sâm dâzâŋgoi zen kwagâwe. Den zo topŋâ mân nâŋgâm, nâŋgâne kwakmak oip. ");
INSERT INTO kpf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu zâk âim Yeriko kamân mâte oip. Oi matâp ginŋan a sen ŋâtâtik ŋâi nalem sot kât, zorat oletziŋgâm tâip. ");
INSERT INTO kpf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","A kâmut patâ zen mâtâp zoren âine kinziŋ kwamit nâŋgâm mâsikâziŋgi sâwe, ");
INSERT INTO kpf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Yesu, Nasarete gokŋâ gaap.” ");
INSERT INTO kpf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Sâne nâŋgâmŋâ den kâtikŋâ sâm sâip, “Yesu, gâ Dawidigât kiun, nâgât umgâ bâliŋ oik.” ");
INSERT INTO kpf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yatâ sâi a kândom âiwe, ziŋâ den hiriŋsâm tâpapkât dukuwe. Oi zâkŋâ den zo nâŋgâm tâtâlim den kâtikŋâ den sâip, “Gâ Dawidigât kuinŋâ, nâgât umgâ bâliŋ oik.” ");
INSERT INTO kpf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sâi Yesuŋâ nâŋgâm mâtâbân kinŋâ sâip, “Zen nâgâren diim ganek.” Sâi sâne sen ŋâtâtikŋâ zâkkâren gâi mâsikâm sâip, ");
INSERT INTO kpf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nâ dap otgibatkât sat?” Sâi sen ŋâtâtikŋâ sâip, “Nâ sinnâ âlip upapkât nâŋgan.” ");
INSERT INTO kpf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sâi Yesuŋâ itâ dukuip, “Siŋgâ mânâŋgârik. Nâŋgâm pâlâtâŋ kwatnigat, zorat âlipkâ uat.” ");
INSERT INTO kpf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sâi zorenâk siŋâ egip. Oi Yesu molim âimŋâ ekŋâ Anutu mâpâseip. A ambân ziŋâ zo ekŋâ Anutu mâpâsiwe. ");
INSERT INTO kpf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu zâk Yeriko kamân bagim âim tâip. ");
INSERT INTO kpf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kamân zoren a ŋâi ândeip, kutŋâ Sakaio. Zâk kât mimiŋ a zeŋgât a sâtŋâ. Oi sikum mot doŋbep zemŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A zorâŋ Yesu ikpamŋâ okŋaŋgip. Oi zâk a pâŋkânok, gât ko a ambân mindune osetziŋan kin Yesu ikpam kwagip. ");
INSERT INTO kpf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yatâ op sârârâk kârâm âi a walâziŋgâm Yesu ikpam wakum nak kwâkŋan zâi tâip. Yesu zâk mâtâp zorik gam âibam oip. ");
INSERT INTO kpf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Oi Yesu zâk nak zorat topŋan âi siŋâ pâi zari ekŋâ itâ dukuip, “Sakaio, gâ kek gem ga. Nâ itârâŋ gâgât mirin ga tâpat.” ");
INSERT INTO kpf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sâi yatigâk gem gam umâlip opŋâ Yesu diim mirâŋan arip. ");
INSERT INTO kpf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Oi a zen zo ekŋâ nâŋgâm bâliŋ kwap sâwe, “Zâk wangât bâliŋ mâme a zirat mirin zâi taap? Zâk mân orotŋâ uap.” ");
INSERT INTO kpf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Oi Sakaioŋâ kin Kembu itâ dukuip, “Kembu nâŋgâ. Kât sikumnâ kâsâpkum torenŋâ a kanpitâ ziŋgâbat. Oi a nâmbutŋâ kât walâm betziŋan mewan, zo yatik nâŋâ hâuŋâ mem zâi pam walâm ziŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sâi ko Yesuŋâ arâpŋâ itâ sâm dâzâŋgoip, “A zi Abaramgât kiunŋâ. Zâk sot ambin murarâŋâ, zen itârâŋ sumbemgât siŋgi ue. ");
INSERT INTO kpf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","A bonŋâ nâ a tâmbetagoagoŋan gâbâ kubikziŋgâbam gem gâwan. Kubikziŋga sumbemgât siŋgi upi.” ");
INSERT INTO kpf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu sot arâpŋâ, zen âim Yerusalem kamân goot goot utne a ambân Yesu moliwe, ziŋ itâ sâwe. “Anutu um topŋan ândiândigât narâkŋâ mâte uap.” ");
INSERT INTO kpf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Sâne zorat Yesuŋâ den sumbuŋâ itâ sâm dâzâŋgoip, “A patâ ŋâiŋâ hân kârebân âim kot patâ mem kamânân âburibat sâm ba arip. ");
INSERT INTO kpf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Âibam kore arâp bâzagât minduziŋgâm kât ekap kânok kânok ziŋgip. Ziŋgâm itâ dâzâŋgoip, ‘Zen kât ekap zi mem nep tuunetâ laŋ kâri gâbat.’ ");
INSERT INTO kpf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dâzâŋgom ari kamân zorat mâirâpŋâ, zen zâkkât âkonziŋgipkât kore a sâŋongune âimŋâ a kutâ patâgâren âim itâ dukuwe, ‘Mân kembu otniŋgâbapkât nâŋgen.’ ");
INSERT INTO kpf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","A patâ zo ari ko a kutâ zâk laŋ hân galem sâm pindi âbureip. Âburem gamŋâ kore a kât ziŋgip, zo gabi sâi mindum gawe. Ganetâ itâ mâsikâziŋgip, ‘Kât ziŋgâwan, zo mem nepŋâ tune dabutâ âsagiap?’ ");
INSERT INTO kpf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sâi a ŋâiŋâ gamŋâ sâip, ‘Patâ, kât ekap kânok nigin, zorâŋ târokwap bâzagât âsagiap.’ ");
INSERT INTO kpf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Sâi patâŋâ itâ dukuip, ‘Gâ âlip uat. Gâ kore a âlipŋâ, gât ko kamân bâzagât zeŋgât galem a op ândiban.’ ");
INSERT INTO kpf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yatâ sâi kore a ŋâiŋâ gam sâip, ‘Patâ, kât ekap nigin, zo mem nepŋâ tuuga bâtnâmbut âsagiap.’ ");
INSERT INTO kpf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Sâi itâ dukuip, ‘Âlipŋâ. Gâ kamân bâtnâmbut zeŋgât galem a op ândiban.’ ");
INSERT INTO kpf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Sâi kore a ŋâiŋâ gamŋâ sâip. ‘Kât ekap nigin, zo hâmbâŋâ kâpim pa ziap. ");
INSERT INTO kpf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nâ gâgât topkâ itâ nâŋgan. Gâ a bâliŋâ. Gâ kut ŋâi ŋâi mân tuum a nâmbutŋâ ziŋ tuune muyagei mimbatkât sâmat. Gâ gikak nep mân kârâm kâmitmat. Nâmbutŋandâ tuune bon mimbatkât sâmat. Zorat gâgât keŋgât op kâtkâ dâŋâk pa taap.’ ");
INSERT INTO kpf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sâi patâŋâ itâ sâm dukuip, ‘Kore a bâliŋâ gâ. Gikak den sat, zo mâburem dâgobâ. Gâ nâgât itâ nâŋgâmat. Nâ a bâliŋâ. Ninak kut ŋâi ŋâi mân muyagem meman. Oi ninak nep mân kârâm kâmitŋâ nâmbutŋandâ kârâm kâmitne bon oi nimbatkât sâman. ");
INSERT INTO kpf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Gâ topnâ yatâ nâŋgâm kât giwan, zo kât a ziŋgâna nepŋâ tuune âburem ga târokwap membam.’ ");
INSERT INTO kpf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Sâmŋâ a kirâwe, zo itâ dâzâŋgoip, ‘Zen kât ekap pindâwan, zo bekŋan mem bâzagât mem ândiap, zâk pindânek.’ ");
INSERT INTO kpf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Oi ziŋâ sâwe, ‘Zâk bâzagât mem ândiap, zo ka.’ ");
INSERT INTO kpf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Sâne sâip, ‘Nâ dâzâŋgua nâŋgânek. Ŋâi zâk kut ŋâi pinda mem ândei târokwâkŋaŋgâbat. Oi ŋâi zâk kut ŋâi pinda mân mem ândei, zo bekŋan mia yen ândibap. ");
INSERT INTO kpf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kâ kâsarâpnâ zi mân galemnâŋgobap sâwe, zo minziŋgâm gamŋâ mâtenanâk zâŋgom naŋgânek.’” ");
INSERT INTO kpf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu zâk den sâm kwâkâm Yerusalem kamân zâibam zarip. Oi kândom otziŋgâm zarip. ");
INSERT INTO kpf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Âimŋâ Oliwa bâkŋan âim Betepage sot Betania kamân mâte otziŋgip. Oi arâp zeŋgâren gâbâ a zagât sâŋgonzâkom itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kamân nâmbutken, zoren arit. Âimŋâ doŋgi sigan tâgân saane kinzap, zo muyagibabot. Zo aŋâ kwâkŋan mân tâtatŋâ, zo uŋakŋâ. Oi zo olaŋ diim gâit. ");
INSERT INTO kpf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Olaŋitâ a ŋâiŋâ wangât miabot sâi itâ dukubabot, ‘Kembuniŋaŋgâren nep muyagei zirat sap.’” ");
INSERT INTO kpf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sâi azatŋâ zet sâip dâp âi muyâgiwet. ");
INSERT INTO kpf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Doŋgi olaŋ kiritâ mâirâpŋandâ mâsikâzikâwe, “Wangât olaŋsâbot?” ");
INSERT INTO kpf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Sâne zikŋâ sâwet, “Kembuŋâ nep muyagei zirat sap.” ");
INSERT INTO kpf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yatâ sâm Yesugâren diim aritâ hâmbâziŋ doŋgi kwâkan pamŋâ Yesu aline doŋgi kwâkŋan zâi tâip. ");
INSERT INTO kpf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Zâim ari hâmbâziŋ mâtâbân lâŋgat âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oliwa bâkŋan gâbâ giari a ambân kâmut gakâŋâ, zen kulem top top tuugi igâwe, zorat sâtâre op kep mem Anutu sâm âlip kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Oi itâ sâwe, “Oe, a kutâniŋâ zâk Kembugât sâtkât gaap. Zâk sâm âlip kwâkŋaŋgâm sânâ. Oe, u sumbemân Anutu sâm âlip kwâkŋaŋgânat. Sumbemân lumbeŋâ zimbap.” ");
INSERT INTO kpf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sâm âine Parisaio a nâmbutŋandâ a osetziŋan kin itâ dukuwe, “Patâ, arâpkâ sâna birânek.” ");
INSERT INTO kpf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sâne sâip, “Nâ dâzâŋgua nâŋgânek. Zen hiriŋsâne sâi ko kât ziŋ den sâm mâpâsenibe.” ");
INSERT INTO kpf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu zâk âimŋâ Yerusalem kamân mâteyâk ek kin umbâla op iseip. ");
INSERT INTO kpf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Isemŋâ Yerusalem mâirâp zeŋgât itâ sâip, “Lumbeŋâ ândim sâi ek nâŋgâbe? Sinziŋ bâpsâsâŋ, gât ko mân ek nâŋge. ");
INSERT INTO kpf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gâtâm narâk ŋâin kâsaziŋâ gamŋâ kamânziŋ dooŋgum ândine kwakpi. ");
INSERT INTO kpf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mirâ kamânziŋ kom kindiŋkândaŋ tuum ziŋâ sot murarâpziŋâ zâŋgom mem ŋâi ŋâi otziŋgâne mirâ kamân kwamen zimbap. Wangât, Kembuziŋâ nâ zeŋgâren ga mân nek nâŋgâwe, zorat kut ŋâi ŋâi zo muyageziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Den zo sâm naŋgâm tirik namin zarip. Zari kut ŋâi ŋâi aŋgâgwaŋgâ op kine itâ sâm moliziŋgip, ");
INSERT INTO kpf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Namâ zirat Kembugât den kulem ŋâi ziap, ‘Namânâ zi ninau namâ upap.’ Ka zen ko utnetâ kâmbu a zeŋgât kât ki yatâ uap.” ");
INSERT INTO kpf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sirâmŋâ sirâmŋâ Yesuŋâ tirik namin zâim den siŋgi âlip dâzâŋgom ândeip. Oi tirik namâ gâlem a sot pâtârâpziŋâ, zen kune buŋ upapkât den sâm kâtâŋ urâwe. ");
INSERT INTO kpf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yatâ sâne a ambân yenŋâ, zen aksik Yesugât diŋâ nâŋgâne imbaŋâ opmâip, zorat patârâpziŋâ zeŋgâren kwagâwe. ");
INSERT INTO kpf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Narâk ŋâin Yesuŋâ tirik namin a den siŋgi âlip dâzâŋgom kiri tirik namâ galem a patâ sot Kembugât gurumin a sot galem a, zen itâ dukuwe, ");
INSERT INTO kpf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Gâ dâtnâŋgo. Ŋâigât sâtkât kut ŋâi ŋâi zo opmat? Ŋâiŋâ yatâ upan sâm gigipkât opmat?” ");
INSERT INTO kpf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sâne Yesuŋâ dâzâŋgoip, “Nâŋgoot den ŋâi mâsikâziŋga dâtnonek. ");
INSERT INTO kpf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohane too saŋgon nep tuugip, zo ŋâigât sâtkât tuugip? Anutugât sâtkât mo agât sâtkât?” ");
INSERT INTO kpf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yatâ sâi zen ziiŋak itâ âraguwe, “Nen Anutugât sâtkât tuugip sâindâ sâbap, ‘Zen wangât diŋâ mân luwe?’ ");
INSERT INTO kpf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mo agât sâtkât tuugip sâindâ a ziŋâ kâtŋâ nâŋgobi. Zen Yohanegât nâŋgâne propete bonŋâ opmâip, zorat.” ");
INSERT INTO kpf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Zorat opŋâ Yesu itâ dukuwe, “Nen Yohanegât topŋâ mân nâŋgen.” ");
INSERT INTO kpf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sâne itâ dâzâŋgoip, “Zo sâne sâi ko nâŋgoot ŋâigât satkât opman, zo dâzâŋgobam. Ka zen mân se, zorat mân dâzâŋgobat.” ");
INSERT INTO kpf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesuŋâ a ambân den sumbuŋâ ŋâi itâ sâm dâzâŋgoip, “A ŋâiŋâ waiŋ tâk nep kârâm kâmirip. Kâmitŋâ galem a zâmban hân kârebân âi ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Oi bonŋâ mimiŋ narâkŋâ mâte oi kore a ŋâi bonŋâ nâmbut mimbapkât sâŋgongui arip. Âi taki galem a ziŋâ kom molinetâ bet bâsaŋ gâip. ");
INSERT INTO kpf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Âburei mariŋandâ dum kore a ŋâi sâŋgongui arip. Sâŋgongui ari yatigâk kom moline bet bâsaŋ âbureip. ");
INSERT INTO kpf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Oi mariŋandâ dum kore a ŋâi sâŋgongui arip. Ari yatigâk kom eksâne âbureip. ");
INSERT INTO kpf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yatâ utnetâ waiŋ kâlam mariŋandâ sâip, ‘Zi dap upat?’ Mariŋaŋgât nanŋâ ŋâi ândeip, zo zikŋâ nanŋâ kânok. Oi umŋâ zâkkâren kinmâip. Mariŋandâ itâ sâip, ‘Nâ itâ upat. Nâ nannâ zi sâŋgongua ari ek âlip hurat kwâkŋaŋgâbi.’ ");
INSERT INTO kpf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Oi galem a zen nanŋâ ekŋâ âragwâragu op sâwe, ‘Zâkŋâ zi gâtâm kâlam mariŋâ upap, zorat ko koindâ kâlam zi neŋgât siŋgi upap.’ ");
INSERT INTO kpf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yatâ sâmŋâ mem kâbakŋem âi kune moip. Yatâ utne kâlam mariŋâ zâk dap yatâ otziŋgâbap? ");
INSERT INTO kpf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nâŋge. Zâkŋâ ga galem a zâŋgoi mune kâlamŋan galem a uŋakŋâ zâmbanbap.” Yesuŋâ yatâ sâi a ambân zen nâŋgâm itâ sâwe, “Opoŋ, zo neŋgâren zo yatâ mân âsagibap.” ");
INSERT INTO kpf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sâne Yesuŋâ ziŋgitŋâ sâip, “Kembugât ekabân den kulem ŋâi itâ ziap, zo topŋâ dapkât? ‘Mirâ tuutuuŋ a, zen kunkun ŋâi ekŋâ âkon op birâwe. Kembuŋâ kunkun zorâŋâ mem namin kwânâŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","A ŋâi zâk kunkun zorâŋ komŋâ sâkŋâ tâmbetkubap. Oi kunkun zorâŋ a ŋâi kwâkŋan kumbap, zo ko kom kwândâlibap.’” ");
INSERT INTO kpf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yatâ sâi Kembugât gurumin den zorat galem a sot tirik namâ galem a patâ, zen sirâm zorenâk gâsunam urâwe. Oi a ambân zeŋgât keŋgât op birâwe. Zen itâ nâŋgâwe, “Yesuŋâ den sumbuŋâ sâip, zo neŋgât op sâip.” ");
INSERT INTO kpf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A patâ, zen Yesu gâsum kumbigât a sâŋgonzâŋgone tik ek molim ândiwe. A zo ziŋâ târârak holi yatâ ândim Yesu denŋâ sâkŋanâk sâm diim a kutâgâren âi pânam urâwe. ");
INSERT INTO kpf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Den sâm mâsikâ okŋaŋgâm sâwe, “Patâ, nen gâgât topkâ nâŋgâmen. Gâ den târârak dâtnâŋgomat. Oi patâ walâziŋgâm den mân sâmat. Oi Anutugât mâtâp ziap, zo bonŋanâk sâm kusikŋan pâmat. ");
INSERT INTO kpf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Zorat sâna nâŋgânâ. Roma a kutâ patâ Sisa kât pindânat, zo orotŋâ mo mân orotŋâ?” ");
INSERT INTO kpf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sâne Yesuŋâ sarâziŋaŋgât topŋâ nâŋgâm sâip, ");
INSERT INTO kpf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Zen kât ŋâi mem tirâpnone ikpâ. Zoren ŋâigât holi tobat ziap?” Sâi ziŋâ sâwe, “Roma a kutâ Sisagât holi tobat.” ");
INSERT INTO kpf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yatâ sâne dâzâŋgom sâip, “Sisagât siŋgi, zo Sisa pindâbi. Anutugât siŋgi, zo Anutu pindâbi.” ");
INSERT INTO kpf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yatâ sâi zen diŋâ zo saanam a ambân mâteziŋan kwagâwe. Zorat den hâuŋâ mân sâm diŋâ mâpâsiwe. ");
INSERT INTO kpf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Zen âine Sadukaio a nâmbutŋâ zen Yesugâren gawe. A zo ziŋâ momŋâ zaatzaat, zo mân ziap sâmarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","A zo ziŋ gam Yesu itâ sâm mâsikâwe, “Patâ, Mose zâk den itâ sâm kulemguip, ‘A ŋâiŋâ ambân memŋâ katepŋâ mân âsagei ândim moi munŋandâ malâ zo mei âtâŋaŋgât siŋgi katep muyagibap.’ ");
INSERT INTO kpf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oi zorat sâindâ nâŋgâ. Âtâ mun nâmburân zagât ândiwe. Oi âtâziŋ ambân mem kiun buŋ ândim moip. ");
INSERT INTO kpf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Moi munŋandâ malâ zo mem yatik kiun buŋ ândim moip. ");
INSERT INTO kpf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Moi munŋâ ŋâiŋâ yatik malâ zo meip. Yatik yatik âtâ mun nâmburân zagât, zen ambân kânok zo mem kiurâpziŋ buŋ mom nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Munetâ bet ambân malâziŋ zo moip. ");
INSERT INTO kpf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Oi a nâmburân zagât zen ambân kânok zo miwegât mumuŋan gâbâ zaatzaat narâkŋan ambân zo ŋâigât ambân upap?” ");
INSERT INTO kpf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Hanân zi a ambân miyaŋgâme. ");
INSERT INTO kpf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Narâk patin ko Anutuŋâ nâŋgâziŋgi dâp oi ândiândi kâtikkât zaatpi, a ambân zen dum mân miaŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Zen mumuŋan gâbâ zaatŋâ dum mân mumbi. Zen Anutugât nan bârarâp op Anutugât sumbem arâp yatâ op ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mumuŋan gâbâ zaatpi, zo Moseŋâ kârâp nak topŋan âsagei egibân den zo sâm muyageip. Zâk Kembugât den itâ sâm kulemguip, ‘Zâk Abaram sot Isaka sot Yakobo zeŋgât Anutu.’ Nâ zorat sa nâŋgânek. ");
INSERT INTO kpf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anutu zâk mom buŋ urâwe, zeŋgât Anutu buŋâ. Zâk wâgân ândie, zeŋgât Anutu. Anutuŋâ zeŋgât nâŋgi aksik patâ wâgân ândie.” ");
INSERT INTO kpf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yesu zâk yatâ sâm dâzâŋgoi Kembugât gurumin den zorat galem a nâmbutŋandâ sâwe, “Patâ gâ den sâna âlip uap.” ");
INSERT INTO kpf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yatâ sâi ko narâk zoren gâbâ zen dum mâsikânam keŋgât op birâwe. ");
INSERT INTO kpf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesuŋâ itâ sâm mâsikâziŋgip, “Kristo, zâk Dawidigât kiun sâme, zo dapkât? ");
INSERT INTO kpf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawidi zikŋak Psalm ekabân den ŋâi itâ sâm kulemguip, ‘Kembu zâk nâgât kembu itâ sâm dukuip. ");
INSERT INTO kpf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","“Nâgât âsannâ bongen tâtna kâsarâpkâ minduziŋga kiŋgaŋgât kombâŋ upi.” ’ ");
INSERT INTO kpf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawidiŋâ Kristogât kembunâ sâip, zorâŋ dap op kiunŋâ uap?” ");
INSERT INTO kpf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Oi a ambân mâteziŋan arâpŋâ itâ sâm dâzâŋgoip, “Kembugât gurumin a yatâ mân ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Zen hâmbâ kârep mem ândine a ziŋ sombemân muyageziŋgâm sâm âlip kwatziŋgâbigât umziŋ kinmap. Oi mâpâmâpâse namin sot nalem niniŋ namin a sâtŋâ tâtarân tâtnat sâme. ");
INSERT INTO kpf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","A yatâ zorâŋ ambân malâ zeŋgât mirâ kut ŋâi ŋâi laŋ mime. Oi a ambân mâteziŋan ninâu kârep sâm tosaziŋ kwârakume. A zo zen gâtâm tosaziŋaŋgât hâuŋâ yambâtŋâ mimbi.” ");
INSERT INTO kpf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesuŋâ siŋâ pâi ari egi sikum a ziŋâ Kembugât siŋgi kât pane giari egip. ");
INSERT INTO kpf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Oi ambân malâ kanpitâ ŋâi, zorâŋ gam kât kuriŋâ zagât pai giari egip. ");
INSERT INTO kpf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yatâ oi Yesuŋâ ekŋâ sâip, “Nâ perâkŋak dâzâŋgobâ. Ambân malâ kanpitâ, zâk kât paap, zorâŋâ walâziŋgap. ");
INSERT INTO kpf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sikum a zen mamŋâ âmbi zei ko nâmbutŋik pe. Oi ambân kanpitâ, zâk kâtŋâ pam naŋgâm yenâk ândiap.” ");
INSERT INTO kpf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","A nâmbutŋâ zen tirik namâgât den itâ sâwe, “Kât neuleŋoot âlipŋâ tuune hikpârâkŋoot kirip.” Zo ek sâm kine Yesuŋâ dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Narâk ŋâin kâsaziŋâ gam namâ neuleŋoot zi kândaŋne giligâlâksâm buŋ op naŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Oi ziŋâ sâwe, “Patâ, sat, zo narâk ikâ zoren muyagibap? Narâk zo mâte oi wesâk dap dap yatâ muyagibap?” ");
INSERT INTO kpf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sâne Yesuŋâ itâ sâip, “Um gulip kwatziŋgâbegât gasâziŋ kârâm ândibi. A doŋbepŋâ gam itâ sâbi, ‘Nâ Kristo. Bâliŋan gâbâ mâkâziŋgâbapkât sâsâŋ, zo nâ.’ Nâmbutŋâ itâ sâbi, ‘Narâkŋâ mârum mâte uap.’ Yatâ sâne a yatâ zo zeŋgât den nâŋgâne bonŋâ buŋ upap. ");
INSERT INTO kpf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Oi kâmbamgât den siŋgi nâŋgâm mân keŋgât upi. Kut ŋâi ŋâi yatâ zo âsagibapkât sâsâŋ. Oi yatâ muyagem zei narâk kek mân âkâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yatâ sâm sâip, “Hânŋâ hânŋâ, kâmutŋâ kâmutŋâ, zen kâsa op zimbi. ");
INSERT INTO kpf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Wâriŋ patâ mimbap. Pu sot mâsek patâ muyageziŋgâbap. Oi sumbemân wesâk imbâŋâ muyagibap.” ");
INSERT INTO kpf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Yatâ mân âsagei zen gâsuziŋgâm zâŋgom moliziŋgâbi. Oi gâsâzâŋgom mâpâmâpâse namin sot tâk namin zâmbânbi. Oi a kutâ sot a galem, zeŋgâren diiziŋgâm âibi. Zo nâgât kot mem ândiegât yatâ otziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Oi narâk zoren nâgât topnâ, zo sapsum ziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","A zeŋgât mâteziŋan kin den dap sânat sâm mân nâŋgâm kwâkâ upi. ");
INSERT INTO kpf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ninak den nâŋgânâŋgâ âlipŋâ ziŋga kâsarâpziŋâ zen dinziŋâ nâŋgâmŋâ mân kumbi. ");
INSERT INTO kpf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Oi zorik buŋâ. Ibâ mam, âtâ mun, torerâp sot bukurâpziŋâ, ziŋâ sâne gâsuziŋgâm zâŋgobi. Oi zeŋgâren gâbâ a nâmbutŋâ mumbi. ");
INSERT INTO kpf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","A doŋbep zen kutsiŋginaŋgât opŋâ um kâlak otziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yatâ otziŋgâne nâŋâ galem otziŋga kâukziŋ sâmot ŋâi mân buŋ upap. ");
INSERT INTO kpf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Zen kâtigem âim ândiândiziŋ muyagibi.” ");
INSERT INTO kpf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Kâsarâpziŋ zen gam Yerusalem kamân haamgune sâbi, ‘Kamâniŋ patâ kândaŋne kwamen zimbapkât narâkŋâ mâte uap.’ ");
INSERT INTO kpf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Oi Yudaia hânân ândibiŋâ zen sârârâk kârâm ba barâ kâtikŋan âibi. A ambân Yerusalem kamânân ândibiŋâ yatigâk sârârâk kârâm âibi. A ambân kamân âkŋan ândibiŋâ Yerusalem kamânân mân zâibi. ");
INSERT INTO kpf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Narâk zoren tosaziŋâ hâuŋâ mâkâbapkât narâk muyagibap. Oi Kembugât den ekabân ziap, zo bonŋâ muyagibap. ");
INSERT INTO kpf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yei, ambân kâmborâ sot katep namân gokŋâ, zen dap upi? A kâmut zi zeŋgâren tosagât hâuŋâ Kembuŋâ sâknam patâ ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Oi kâsa ziŋâ a ambân nâmbutŋâ kâmbamŋâ zâŋgom nâmbutŋâ diiziŋgâm hân toren toren âine zeŋgât kore a ambân op ândibi. Oi hân ŋâin gâbâ um kâtik, ziŋ gam Yerusalem kamân kiom patâ tuum ândine narâkziŋ âkâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Bet mirâsiŋ sot kâin sâŋgelak sen pupŋâ muyagibap. Muyagei a ambân kâmutŋâ kâmutŋâ, zen kwakmak upi. Oi saru âbâŋgum kwatmit patâ muyagei nâŋgâne kwakmak oi keŋgât upi. ");
INSERT INTO kpf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Oi Anutuŋâ sumbem mâŋgei olayaŋgâm imbaŋâ buŋ upap. Oi a ambân, ziŋ kut ŋâi ŋâi muyagibap, zorat nâŋgâm kwâkâmŋâ keŋgât opŋâ munam op kinbi. ");
INSERT INTO kpf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Oi a bonŋâ nâ unumunum kwâkŋan imbaŋâ âsakŋânoot ga nikpi. ");
INSERT INTO kpf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kut ŋâi ŋâi zo âsagei kâkpam ekŋâ itâ sâbi, ‘Gâsuniŋgâbapkât narâk mâte uap.’” ");
INSERT INTO kpf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesuŋâ yatâ sâm den sumbuŋâ ŋâi itâ târokwap dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","“Zen dâgap nak ekŋâ topŋâ itâ sâme, ‘Ilum burutuksâi maa narâk upâmap.’ ");
INSERT INTO kpf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yatik kut ŋâi ŋâi san, zo muyagei ekŋâ sâbi, ‘Anutu um topŋan ândiândiŋ, zorat narâk mâte uap.’ ");
INSERT INTO kpf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nâ perâkŋak dâzâŋgobâ. A kâmut zi ândie, zen mân mune kut ŋâi ŋâi san, zo muyagibap. ");
INSERT INTO kpf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Hân sot sumbem buŋ upabot. Nâgât den zo ko mân buŋ upap.” ");
INSERT INTO kpf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Sii nalem nem kut ŋâi ŋâi yenŋaŋgât nâŋgâm ândine um nâŋgânâŋgâziŋ buŋ oi narâk patâgât mân naŋgâm ândine muyagei pârâkpam lâu taktak upegât gasâziŋ kârâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Narâk patâ zo hân dâp a aksik dâpziŋ oi muyagibap. ");
INSERT INTO kpf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Zorat zen um wâgân ândim ninâu sâm ândine Kembuŋâ imbâŋâ ziŋgi kut ŋâi ŋâi âsagibapkât sâsâŋâ, zo âsagei ândine a bonŋâ nâ takâm ga mâtenan kâtigem kinbi.” Yatâ sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu zâk sirâmân tirik namin den siŋgi âlip dâzâŋgom ândeip. Oi mirâ ŋâtiksâi birâziŋgâm Oliwa bâkŋan zâi zemâip. ");
INSERT INTO kpf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mirâ haŋsâi a ambân aksik zâkkât den nâŋgânam tirik namin zâiwe. ");
INSERT INTO kpf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yuda zeŋgât kendon patâ kutŋâ Pasowa, narâkŋâ mâte oip. ");
INSERT INTO kpf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tirik nama galem a patâ sot Kembugât gurumin den zorat galem a, zen a ambân zeŋgât keŋgât op, dap op Yesu koindâ mumbap sâm mâtâp kâruwe. ");
INSERT INTO kpf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yatâ op ândine Sataŋŋâ Yesugât a ŋâi kutŋâ Yuda, Karioto kamânân gokŋâ, zâkkât umŋan giarip. ");
INSERT INTO kpf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Giari tirik namâ galem a patâ sot kâwâli a zeŋgât galem a patâ zeŋgâren âim tirâpzâŋgoi gâsubigât dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Oi zen nâŋgâm umziŋ âlip oi sâŋgânŋâ kât pindâbigât sâwe. ");
INSERT INTO kpf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sâne dinziŋâ lum sâm kâtigem Yesu tigâk tirâpzâŋgobam ek kârum ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kendonân nalem niniŋâ narâk oip. Narâk zoren râma gwamŋâ kom gaam omarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Oi Yesuŋâ Petero sot Yohane itâ sâm sâŋgonzâkoip, “Zet âim Pasowa kendongât nalem om kâtâŋ tuubabot.” ");
INSERT INTO kpf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Sâi zikŋâ itâ sâm mâsikâwet, “Mirâ ikâ zoren undat?” ");
INSERT INTO kpf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sâitâ itâ sâm dâzâkoip, “Nâŋgit. Zet kamânân zâim a ŋâi egitâ too âmaŋoot muyagem mem mirin zari molim zâibabot. ");
INSERT INTO kpf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Zâim mirâ mariŋâ itâ dukubabot, ‘Patâŋâ gâgât itâ sap, “Mirâ umŋâ ikâ zoren nâ sot arâpnâ Pasowa nalem ninat?” ’ ");
INSERT INTO kpf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Sâitâ zâkŋâ mirâ umŋâ patâ ŋâi kiaŋ tâtatŋâ kubikkubikŋâ, zo tirâpzâkoi zoren nalem om kâtâŋ tuubabot.” ");
INSERT INTO kpf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Zet âim Yesuŋâ sâip dâp muyagiwet. Oi zoren Pasowa nalem om kâtâŋ tuuwet. ");
INSERT INTO kpf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nalem niniŋ narâkŋâ oi ko Yesu sot arâpŋâ zen nalem ninam zâiwe. ");
INSERT INTO kpf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Zâine Yesuŋâ itâ sâip, “Sâknam narâk mâte oi nalem zi zen sot nimbatkât otnigap. ");
INSERT INTO kpf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nâ sa nâŋgânek. Pasowa nalem dum mân nem ândia Anutu um topŋan zorat bonŋâ, zo âsagibap.” ");
INSERT INTO kpf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yatâ sâmŋâ waiŋ hâkop mem sâiwap sâm itâ sâip, “Zi mem nem aŋgânek. ");
INSERT INTO kpf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nâ dâzâŋgobâ. Waiŋ too dum mân nem ândia Anutugât um topŋan ândiândiŋ, zo muyagibap.” ");
INSERT INTO kpf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Den yatâ sâmŋâ nalem ŋâi memŋâ sâiwap sâm mamuŋ itâ sâm ziŋgip, “Zi sunumnâ. Zo zeŋgât siŋgi san. Nâgât nâŋgâm itâ nem ândibi.” ");
INSERT INTO kpf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nalem nine waiŋ too hâkop mem ziŋgâm sâip, “Hâkop ziren târotâroniŋ irakŋaŋgât gilâmnâ taap. Gilâmnâ zo, zeŋgât op hânân gibap. ");
INSERT INTO kpf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Oi nâŋgânek. A kâsarâpnâ zeŋgât berân nâbanbap, zâkŋâ nâ sot tâtarân nalem ârândâŋ mem nem tet. ");
INSERT INTO kpf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A bonŋâ, nâ mâtâp sâm niniŋ, zorik âibat. Ka a ŋâi tirâpzâŋgoi gâsunibi, yei, zâk hâuŋâ yâmbâtŋâ mimbap.” ");
INSERT INTO kpf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yatâ sâi arâpŋâ zen kâmutziŋan gâbâ ŋâiŋâ yatâ upap sâm mâsikâyaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesu arâpŋâ, zen osetniŋan gâbâ ŋâiŋâ patâniŋâ upap sâm den sârek âraguwe. ");
INSERT INTO kpf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Utne Yesuŋâ itâ sâm dâzâŋgoip, “Hân a kutâ, zen kore a gâsâzâŋgome. A zâizâiŋ, zen a yenŋandâ sâm âlip kwatziŋgâme. ");
INSERT INTO kpf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ka zeŋgâren yatâ mân âsagibap. Zeŋgâren a patâŋâ mâikkât holi yatâ upap. Oi a sâtŋandâ kore a yatâ op ândibap. ");
INSERT INTO kpf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Zen sânek. Ikâ zorâŋ zâizâiŋâ? Nalem yen tap niniŋâ, zorâŋ zâizâiŋ mo nalem uuŋâ, zorâŋ zâizâiŋ? Yen tap nimbap, zo zâizâiŋâ nâŋgâme. Nâŋâ ko zeŋgât oserân kore a yatâ op ândian. ");
INSERT INTO kpf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nâ hânân sâknam nâŋgâm ândia nâ sot tap ek ândie. ");
INSERT INTO kpf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Oi Ibânandâ imbaŋâ nigi a ambân zeŋgât patâziŋ op ândibat. Zen zo yatik a ambân zeŋgât a sâtŋâ op ândibigât sâm ziŋgan. ");
INSERT INTO kpf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Zorat nâŋâ sa zen nâ sot nalem nem sâtâre op a kembu tâtarân tap Isirae a kâmut kiin zâgât, zeŋgât den sâm kwâkâbi.” ");
INSERT INTO kpf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesuŋâ itâ sâip, “Simoŋ, Simoŋ, a zen kopi mândâlem kubikŋâ sâkŋâ birâme, zo yatik gâ Sataŋgât bikŋan zâibangât sap. ");
INSERT INTO kpf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Oi nâŋâ ko nâŋgâm pâlâtâŋgâ lorem buŋ opapkât ninâu san, gât ko âburemŋâ bukurâpkâ tânzâŋgoban.” ");
INSERT INTO kpf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Sâi Peteroŋâ itâ dukuip, “Kembu gâ tâk namin mo gone mumban, zo âlip nâ yatik otnibi.” ");
INSERT INTO kpf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Oi Yesuŋâ sâip, “Petero, nâ dâgoga nâŋgâ. Kurukŋâ diŋ mân sâi sâp karâmbut kwâimbâniban.” ");
INSERT INTO kpf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yatâ sâm sâip, “Nâŋâ sâŋgonzâŋgua kât sot irâ, ki pâke buŋ âim zorat kâruwe?” Oi ziŋâ sâwe, “Yatâ buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Sâne itâ târokwap dâzâŋgoip, “Narâk ziren ko a ŋâi zâk kât zemŋâŋgap oi mem âibap. Ŋâi zâk irâ kat zemŋâŋgap oi gorem âibap. Ŋâi zâk kâmbamgât sâu patâ buŋ oi hâmbâŋâ kwâkâm ziŋgi sâu ŋâi pindâne mem âibap. ");
INSERT INTO kpf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nâ sa nâŋgânek. Propete ziŋ nâgât den kânŋan itâ kulemguwe, ‘Zâk bâliŋ mâme a zeŋgât oserân pam itâ sâwe, ‘A zi, zen bâliŋ mâme a.’ Den zo bon upap. Oi nâgât den sâsâŋ, zo aksik patâ bon op naŋgâbapkât narâk mâte uap.” ");
INSERT INTO kpf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sâi arâpŋâ ziŋâ dukuwe, “Kembu eknan. Kâmbamgât sâu patâ zagât mien.” Sâne sâip, “Âlipŋâ.” ");
INSERT INTO kpf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu zâk ŋâtik dâp opmâip, yatâ op Oliwa bâkŋan zari arâpŋâ zen molim âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Zoren takâm Yesuŋâ arâpŋâ itâ dâzâŋgoip, “Zen mâsimâsikâyân loribegât ninâu sânek.” ");
INSERT INTO kpf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yatâ sâm kât lum pâindâ âimap, yatâ âim simin liim kwap itâ sâm ninâu sâip, ");
INSERT INTO kpf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ibânâ, nâŋgânim sâknam kâmut zi betnan mena buŋ oik. Oi nâgât den buŋâ, gâgât den, zo kâtigibap.” ");
INSERT INTO kpf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yatâ sâi sumbemân gâbâ sumbem a ŋâiŋâ gem gam imbaŋâ pindâm mem kâtikŋan kwâkŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Umŋan sâknam doŋbep patâ oi kâtigem ninâu sâip. Oi obakoi, obak zorâŋ hânân gei gilâm yatâ oip. ");
INSERT INTO kpf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ninâu sâmŋâ zaatŋâ arâpŋâ zeŋgâren âim ziŋgirip. Zen umbâlâŋâ mem lotŋan kwatziŋgi uman ziwe. ");
INSERT INTO kpf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Zine Yesuŋâ ziŋgit sâip, “Zen wangât uman zie? Zen mâsimâsikâyân loribegât zaatŋâ ninâu sânek.” ");
INSERT INTO kpf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yatâ sâm kiri a kâmut patâ gawe. Oi arâpŋâ zeŋgât bukuziŋâ, kutŋâ Yuda, zâkŋâ kândom otziŋgi Yesugâren gawe. Yuda zâk lum mâŋganbapkât Yesugâren gâip. ");
INSERT INTO kpf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Gâi Yesuŋâ itâ sâm dukuip, “Yuda, Gâ wangât a bonŋâ nâ lum mâŋganim sâna gâsuninam ue?” ");
INSERT INTO kpf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Oi Yesugât a gakâŋâ, zen kut ŋâi ŋâi muyagibâ sâi ekŋâ sâwe, “Kembu sâna nâŋgâm nen zâŋgonâ?” ");
INSERT INTO kpf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yatâ sâmŋâ zeŋgâren gâbâ ŋâiŋâ tirik namâ galem a patâgât kore a ŋâi kindapŋâ kârâm kwâkip. ");
INSERT INTO kpf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Oi Yesu zo ekŋâ sâip, “Zen birânek.” Yatâ sâm a zo kindapŋâ mem târokwâip. ");
INSERT INTO kpf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tirik nama galem a sot kâwâli a sot a kâukŋâ, zen gâsunam gane itâ sâm mâsikâziŋgip, “Zen nâgât dap nâŋge? Nâgât nâŋgâne kâmbam ku a oi liŋgip kâlâuziŋoot mem ga gâsânoge? ");
INSERT INTO kpf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nâ zorat sa nâŋgânek. Nâ sirâmŋâ sirâmŋâ tirik namin zen sot ândiman. Oi zoren mân gâsânowe. Ka zi zeŋgât narâk uap sot ŋâtâtik mariŋaŋgât narâk uap.” ");
INSERT INTO kpf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","A ziŋ Yesu gâsum diim âim tirik namâ galem a patâgâren diim zâiwe. Oi zâkkât mirin Peteroŋâ bet moliziŋgâm arip. ");
INSERT INTO kpf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Oi kâwali a zen dâmân kâligen âim kârâp om nâŋgâm tatne Petero zâk bagim osetziŋan tâip. ");
INSERT INTO kpf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tâi ko kore ambân ŋâiŋâ ga ekŋâ sâip, “A zi zâk sot ândimap.” ");
INSERT INTO kpf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sâi Peteroŋâ kwâimbâm sâip, “Ambân, nâ zâk mân ekman.” ");
INSERT INTO kpf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yatâ sâm mâik ŋâi tâi a ŋâiŋâ ekŋâ sâip, “Gâ zâkkât kâmurân gokŋâ.” Sâi Peteroŋâ sâip, “Gâ sat, zo nâ buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mâik ŋâi tâi a ŋâiŋâ ga ekŋâ sâm kâtigem sâip, “Perâkŋak, a zi zâk sot ândimap. Zâk Galilaia gokŋâ.” ");
INSERT INTO kpf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sâi Peteroŋâ sâip, “A, gâ den sâna kwaksan.” Yatâ sâi narâk zorenâk kurukŋâ diŋ sâip. ");
INSERT INTO kpf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Oi Kembuŋâ puriksâm Petero egi Petero zâk Kembuŋâ den mârum sâip zo nâŋgip, “Kuruk diŋ mân sâi sâp karâmbut kwâimbâniban.” ");
INSERT INTO kpf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Den zo nâŋgâm umŋâ bâliŋ oi âkŋan âi girâp patâ iseip. ");
INSERT INTO kpf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesu galem op kirâwe, zen Yesu den sâm siŋan gem dukum kuwe. ");
INSERT INTO kpf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Si sâŋgân kwâtepkum komŋâ itâ sâwe, “Gâ Propete ândiat oi ko a ŋâiŋâ gogap, zo kutŋâ sâna nâŋgânâ.” ");
INSERT INTO kpf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Oi den bâliŋâ nâmbutŋâ dukuwe. ");
INSERT INTO kpf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yatâ op kine mirâ haŋsâi a patâ sot tirik namâ galem a patâ sot Kembugât gurumin den zorat galem a, zen aksik mindum sâne Yesu diim zâine den itâ dukum sâwe, ");
INSERT INTO kpf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Dâtnâŋgo. Gâ Kristo ândiat oi ko sapsum niŋgâ.” Sâne itâ dâzâŋgoip, “Nâ topnâ sâm muyagia sâi ko mân nâŋgâbe. ");
INSERT INTO kpf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nâ mâsikâziŋga sâi ko den torenŋâ mân dâtnobe. ");
INSERT INTO kpf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Laŋ sa nâŋgânek. Narâk zi a bonŋâ nâ Anutu imbaŋâ mariŋâ, zâkkât âsan bongen tâpatkât narâk mâte uap.” ");
INSERT INTO kpf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Sâi nâŋgâm a aksik patâ itâ mâsikâm sâwe, “Gâ Anutugât nanŋâ?” Sâne zâkŋâ sâip, “Zo se, zo.” ");
INSERT INTO kpf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Sâi itâ sâwe, “Wangât dum den nep tuunat? Zikŋâ lâuŋan gâbâ gâi nâŋgen.” ");
INSERT INTO kpf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Oi a zen aksik patâ zaat Yesu diim Pilatogâren âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Zâkkât mâteŋan kin itâ sâm siŋan giwe, “A zirat topŋâ itâ ziap. Zâk a doŋbep um gulip kwatziŋgâmap. Oi Roma a kutâ Sisagât kât mân pindâbigât dâzâŋgoip. Oi zikŋaŋgât itâ sâmap, ‘Nâ Kristo, a kembu.’” ");
INSERT INTO kpf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sâne Pilatoŋâ Yesu mâsikâm sâip, “Topkaŋgât dâtno. Gâ Yuda zeŋgât a kutâ?” Sâi Yesuŋâ sâip, “Sat, zo.” ");
INSERT INTO kpf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sâi Pilatoŋâ tirik namâ galem a sot a gam kirâwe, zen itâ dâzâŋgom sâip, “Nâ a zirat tosaŋâ kâruan.” ");
INSERT INTO kpf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Oi zen kâtigem sâwe, “Zâk perâkak a ambân den mân orotŋâ dâzâŋgoi hânniŋâ dâp op laŋ kârip. Zâk Galilaia hânân topkwap op gam Yudaia hânân gam ziren yatik opmap.” ");
INSERT INTO kpf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Yatâ sânetâ Pilatoŋâ mâsikâziŋgâm sâip, “Zo Galilaia gokŋâ?” ");
INSERT INTO kpf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Zâk ziŋ yatâ sâne Pilatoŋâ nâŋgâm Yesu zâk Herodegât nebân gokŋâ sâm sâŋgongui Herodegâren diim âiwe. Herode zâk Yerusalem kamânân ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herode zâk Yesu ekŋâ umŋâ âlip oip. Herode zâk Yesugât siŋgi nâŋgâm ikpam op ândeip. Oi kut ŋâi tuugi ikpatkât nâŋgâm ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Oi zâkŋâ Yesu den topŋâ topŋâ sâm mâsikip. Mâsiki ma hâuŋâ mân mâburem dukuip. ");
INSERT INTO kpf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Oi tirik namâ galem a sot Kembugât gurumin den zorat galem a, zen kâtigem den sâm siŋan gem kirâwe. ");
INSERT INTO kpf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herode sot kâwali arâpŋâ, zen Yesu siŋan gem den gân okŋaŋgâwe. Oi Herodeŋâ sâi Yesu a kembugât hâmbâ ŋâi giŋaŋgâne giari âburem diim Pilatogâren âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Oi sirâm zoren Herode sot Pilato, zet buku urâwet. Mârum ko kâsa kâsa op ândiwet. ");
INSERT INTO kpf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatoŋâ tirik namâ galem a patâ sot a kâukŋâ sot a yenŋâ sâi gawe. ");
INSERT INTO kpf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Gane itâ sâm dâzâŋgoip, “Zen itâ sâm a zi nâgâren diim ge, ‘Zâk a umziŋan gemap.’ Oi nâŋâ zeŋgât mâteziŋan topŋaŋgât kârua buŋ uap. ");
INSERT INTO kpf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herode zâk yatik mâsiki buŋ oi sâŋgongoi diim ge. Nâŋge. Tosaŋandâ mumbapkât siŋgi mân uap. ");
INSERT INTO kpf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Zorat sa kâwali a ziŋâ tâkŋâ lapitne olaŋbat.” ");
INSERT INTO kpf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato zâk Yuda zeŋgât kendon dâp tâk namin tatne zeŋgâren gâbâ kânok kânok olaŋ ziŋgâmâip. ");
INSERT INTO kpf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sâi a kâmut ziŋ den kâtik sâm sâwe, “Zâk buŋ oik. Baraba ko olaŋ niŋgâ.” ");
INSERT INTO kpf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba zâk sot a nâmbutŋâ, zen a kutâgât âkonziŋgi kamân pâtin kâmbam kom a nâmbutŋâ zâŋgone mune tâk namin zâmbarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Oi Pilatoŋâ Yesu olaŋbamŋâ dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Dâzâŋgoi zen den yu kambâŋ sâm sâwe, “Poru nagân moik. Poru nagân moik.” ");
INSERT INTO kpf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sâne Pilatoŋâ kwâkâziŋgi sâp karâmbut oi sâip. “Wan tosagât? Nâŋâ nâŋga tosaŋandâ mumbapkât siŋgi mân uapkât sandâ tâkŋak lapitŋâ birâne âibap.” ");
INSERT INTO kpf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sâi zen kâtigem den kâtik sâm ziwe, “Poru nagân moik.” Sâm gulipmalip utne Pilatoŋâ dinziŋâ lugip. ");
INSERT INTO kpf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Den sâwe, zo bon upapkât Pilatoŋâ sâm kwâkip. ");
INSERT INTO kpf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Oi dinziŋâ lum kâmbam ku a tâk namin tâip, a zo olaŋ ziŋgip. Ka Yesu ko mumbapkât sâm kwâkâm kâwali a zeŋgât bitziŋan pâip. ");
INSERT INTO kpf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yesu diim mâtâbân âim a ŋâi muyagiwe, kutŋâ Simoŋ, Kirene hânân gokŋâ. Zâk nebân gâbâ gâi gâsumŋâ Yesugât poru nak kwambeŋan pane lum Yesugât kândâtŋan arip. ");
INSERT INTO kpf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A ambân doŋbep patâ molim âiwe. Ambân nâmbutŋâ, zen umbâlâ op isem weŋâ molim âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yatâ utne Yesuŋâ puriksâm itâ sâm dâzâŋgoip, “Yerusalem ambân, zen nâgât mân isenek. Ziiŋâ sot murarâpziŋâ, zeŋgât isenek. ");
INSERT INTO kpf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nâŋgânek. Gâtâm, narâk ŋâin itâ sâbi, ‘Ambân zen kâpin ândiwe sot ambân murarâpziŋ buŋ sot ambân sigan, zeŋgât nângindâ âlip upap.’ ");
INSERT INTO kpf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Narâk zoren bakŋâ zeŋgât itâ sâbi, ‘Zen âbâŋgum ge kwâratnâŋgonek.’ Oi bakŋâ mâik zo yatik, ‘Ge kwâratnâŋgonek.’ ");
INSERT INTO kpf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kut ŋâi itâ zo nak wâgân okŋaŋge. Nak aronŋâ, zo dap okŋaŋgâbi?” ");
INSERT INTO kpf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Oi bâliŋ mâme a zagât diizikâm zâk sot zâkonam âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Oi âimŋâ hân ŋâi kutŋâ kâuk siŋit, zoren takâm Yesu poru nagân kuwe. Kâmbam ku a zagât, zo ârândâŋ zâkowe. Yesu zâk tânâmŋan, bâliŋ mâme a zet toren toren kwânâŋgâziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Utne Yesuŋâ ninâu itâ sâip, “Ibânâ, a zi ziŋâ kut ŋâi ŋâi ue, zi topŋâ mân nâŋgegât tosâziŋ birâ.” Sâi kâwali a zen hâmbâŋaŋgât opŋâ wenzu pâne âsageip dâp miwe. ");
INSERT INTO kpf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A doŋbep patâ, zen Yesu ek kirâwe. Oi patâziŋâ ko mem ge kwâkwat den dukum siŋan gem kirâwe. Itâ sâwe, “A nâmbutŋâ tâmbetagonam utne tânzâŋgoip. Zikŋaŋgât ko kwaksap. Zâk Anutugât Kristo sot Anutuŋâ gâsum sâlâpkuip oi ko gem gâik.” ");
INSERT INTO kpf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kâwali a zen yatigâk dukuwe. Zen winiga too kâlakŋâ pindâm sâwe, ");
INSERT INTO kpf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Gâ Yuda zeŋgât a kuta op ândiat oi ko poru nâgân gâbâ âkâm ge.” ");
INSERT INTO kpf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yesugât poru nagân den ŋâi itâ kulemguwe, “Zi Yuda zeŋgât a kutâ.” ");
INSERT INTO kpf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bâliŋ mâme a ŋâi poru nagân kin betziŋan mem Yesu dukum sâip, “Gâ yatâ zo Kristo? Gikâ sâkkâ mâkâna gei nekât sâknikŋâ mâkâ.” ");
INSERT INTO kpf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yatâ sâi bâliŋ mâme a nebutŋandâ dukum sâip, “Net kâmbamgât siŋgi ârândâŋ uenŋâ Anutugât keŋgât mân op sat? ");
INSERT INTO kpf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Net tosanikŋaŋgât dâp otnike. Ka a zi ko bâliŋâ mân oip.” ");
INSERT INTO kpf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yatâ sâmŋâ Yesu dukuip, “Yesu, gâ kembu imbaŋâgoot ândim, gâ nâgât nâŋgâban.” ");
INSERT INTO kpf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Sâi Yesuŋâ itâ sâm dukuip, “Nâ perâkŋak sa nâŋgâ. Itârâŋ gâ nâ sot sumbem kamân âlipŋan, Paradisi, zoren ândiban.” ");
INSERT INTO kpf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Oi mirâ bâkŋan oi mirâ sumunkom zei ŋâtâtik muyagem hân dâp oi mirâ oi âkip. ");
INSERT INTO kpf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Oi tirik namin sâŋgum patâ ŋâi kirip, zo tânâmŋan oloŋ gei kwâkip. ");
INSERT INTO kpf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Oi Yesu den kâtik den sâm sâip, “Ibânâ, bikan um dâpnâ paan.” Yatâ sâm moip. ");
INSERT INTO kpf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Oi kâwali a galem, zo ek nâŋgâm Anutu sâm âlip kwâkŋaŋgâm sâip, “A zi perâkŋak tosaŋâ buŋâ. Hâlâlu a.” ");
INSERT INTO kpf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A ambân zo mindum kirâwe, zen ekŋâ umbâla opŋâ âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesu zikŋâ a ambârâp sot Galilaia hânân gâbâ ambân molim gâwe, zen âkŋan kin igâwe. ");
INSERT INTO kpf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","A ŋâi ândeip, kutŋâ Yosepe. Kamânŋâ Yudaia hânân tâip, kutŋâ Arimataia. Zâk Yuda a sâtŋâ zeŋgât kâmurân gokŋâ. Oi a zo a târârakŋâ. ");
INSERT INTO kpf_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","A sâtŋâ zen Yesu kunam sâne nâŋgi mân dâp oip. Zâkŋâ Anutu um topŋan ândiândiŋ, zo âsagibapkât nâŋgâm ândeip. ");
INSERT INTO kpf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A zorâŋ Pilatogâren âimŋâ Yesugât kâmbarâŋaŋgât dukuip. ");
INSERT INTO kpf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Oi Pilatoŋâ nâŋgâŋaŋgi Yesugât kâmbarâŋ mâkâmŋâ sâŋgum kâuŋâ kâpimŋâ kât mâtâpŋan pâi zeip. Kât mâtâp zo aŋâ kendâm kubigâwe. Zo uŋakŋâ. Zoren mârum a mân zâmbarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yuda zeŋgât kendongât kubikkubik narâkŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Oi ambân nâmbutŋâ Yesu sot Galilaia hânân gâbâ gawe, zen Yosepe molim ikne Yesu kâmbarâŋâ kwagân ga pâip. ");
INSERT INTO kpf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Oi kut ŋâi ŋâi zo ek nâŋgâm kamânân âburem too sot kelâk wârân âlipŋâ mem kubigâwe. Oi Yuda zeŋgât kendonân Mosegât gurumin den lum kendon tarâwe. ");
INSERT INTO kpf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kendon âki ko mirâ haŋsâbâ sâi ambân zen kelâk sot too hitom âlip, zo mem Yesugât kwagân âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Âi takâm igâwe. Kât patâ zâk kâbakŋine mâtâp pâroŋsâm kirip. ");
INSERT INTO kpf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Oi kâligen bagim Kembu Yesugât kâmbarâŋ kârum mân muyagiwe. ");
INSERT INTO kpf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kârumŋâ imbaŋâziŋ buŋ oi keŋgât op kin a zagât, hâmbâzikŋâ âsakŋâ tobat ŋâi yatâ, zet ambân âiwe, zeŋgât umziŋ topŋan kirâwet. ");
INSERT INTO kpf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Oi ambân zen keŋgâtziŋaŋgât op pindiŋsâm kine a zagât zorâŋ itâ dâzâŋgowet, “Zen wangât wâgân ândiap, zâkkât mumuŋâ zeŋgâren kârue? ");
INSERT INTO kpf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Zâk ziren mân ziap. Zâk zaatsap. Mârum Galilaia hânân ândim den itâ dâzâŋgoip, zo nâŋgânek, ");
INSERT INTO kpf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘A bonŋâ nâ bâliŋ mâme zeŋgât bitziŋan zaria none momŋâ sirâm karâmbut tap zaatpat.’” ");
INSERT INTO kpf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yatâ sâitâ ambân zen den zo nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Zen kwâgân gâbâ âburem kamânân gam arâpŋâ sot a ambân nâmbutŋâ den siŋgi zo dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ambân kwagân âiwe, kutziŋâ Maria, Madala kamânân gok sot Yoana sot Maria, Yakobogât mamŋâ. Zen aksik Aposolo den siŋgi zo dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aposolo zen den so nâŋgâne bon buŋ oi mân nâŋgâm kwâtâtiwe. ");
INSERT INTO kpf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ka Petero zâk zaatŋâ sârârâk kârâm kwagân arip. Âimŋâ pindiŋsâm egip. Egi sâŋgum kwamenâk zei egip. Oi kut ŋâi ŋâi âsageip, zorat nâŋgâ kwâkâ opŋâ kamânân âbureip. ");
INSERT INTO kpf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sirâm zorenâk Yesugât a ambârâp zeŋgâren gâbâ a zagât, zet Emausi kamânân âiram âiwet. Kamân zo kârep buŋâ, goot goot. ");
INSERT INTO kpf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","A zagât zet mâtâbân âim kut ŋâi ŋâi âsageip, zorat den sâm âiwet. ");
INSERT INTO kpf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sâm âim tâitâ Yesuŋâ âim muyageziki ârândâŋ âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Zet sinzik mân ânâŋgâripkât mân ek nâŋgâwet. ");
INSERT INTO kpf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yatâ oitâ mâsikâzikâm sâip, “Zet wan den âragum gam tabot?” Sâi zet si sâŋgânzikŋâ umbâlâ tobat op kirâwet. ");
INSERT INTO kpf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Oi zekâren gâbâ a ŋâi kutŋâ Keleopa, zâkŋâ sâip, “Yerusalem kamân mâirâp, zen aksik den siŋgi nâŋge. Gâ kânokŋâ kamân ŋâin gok, gât ko mân nâŋgâm ândiat?” ");
INSERT INTO kpf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Sâitâ mâsikâzikâm sâip, “Wan wan âsageip?” Sâi zet sâwet, “Yesu Nasarete gokŋâ, zâkkât siŋgi. Zâk Anutu mâteŋan Propete patâ ândimŋâ nep patâ tuum den imbaŋâŋoot dâtnâŋgomâip. Yatâ op ândei a ambân, nen zâkkât nâŋgindâ imbaŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ka tirik nama galem a patâ sot a patâ, zen mumbapkât sâm kwâkâm a kutâgâren pane sâi poruyân kuwe. ");
INSERT INTO kpf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nen ko zâkkât itâ nâŋgâm ândiwen. Zâkŋâ Isirae a bâliŋan gâbâ olaŋniŋgâbap. Sâm nâŋgâm ândeindâ kune moi sirâm karâmbut âkap. ");
INSERT INTO kpf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Oi itârâŋ neŋgâren gâbâ ambân nâmbutŋâ den dâtnâŋgone um kuŋkuŋ uen. Zen haŋgât kwagân âim kâmbarâŋâ mân muyagem gam itâ se, ");
INSERT INTO kpf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","‘Sumbemgât kâwali a zagât, zet muyageniŋgâm Yesu zaatsap sâm dâtnâŋguabot.’ ");
INSERT INTO kpf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Oi den zo nâŋgâm neŋgâren gâbâ a nâmbutŋâ, zen ambân ziŋ se, yatik âim muyagie. Oi zikŋâ ko mân ikse.” ");
INSERT INTO kpf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yatâ sâm dukuitâ Yesuŋâ dâzâkoip, “Propete zen den sâm kulemguwe, zo zen wangât um kâtik ândim mân nâŋgâm kwâtâtiwe? ");
INSERT INTO kpf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Propete zen Kristo sâknam nâŋgâmŋâ sumbem âsakŋan bâgibapkât sâm kulemguwe. Anutuŋâ nâŋgip, yatik âsageip.” ");
INSERT INTO kpf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yatâ sâmŋâ Mose sot Propete, zen zâkkâren kwap kulemguwe, zorat topŋâ sâm muyagem zikip. ");
INSERT INTO kpf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Oi âim Emausi kamânân takâwe. Takâne Yesu zâk âibam oip. ");
INSERT INTO kpf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","A zagât zo aŋgân kârâŋaŋgâwet. Oi itâ sâwet, “Mirâ mârum ŋâtiksap. Net sot tâpan.” Sâitâ zet sot ândibapkât nâŋgâziki mirin zâiwe. ");
INSERT INTO kpf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nalem ninam ge tapŋâ nalem mem sâiwap sâm mamuŋ zikip. ");
INSERT INTO kpf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yatâ oi sinzikŋâ ânâŋgâri ek nâŋgâwet. Ek nâŋgitâ zobâ buŋ op arip. ");
INSERT INTO kpf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Oi zet itâ âragum sâwet, “Mâtâbân den dâtnâkom siŋgi âlipkât topŋâ dâtnâkoi umnik âbâŋguap.” ");
INSERT INTO kpf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yatâ sâmŋâ zaat Yerusalem kamânân âburem âiwet. Âimŋâ arâpŋâ sot bukurâpziŋâ mindum tatne muyageziŋgâwet. ");
INSERT INTO kpf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Muyageziŋgitâ itâ sâm dâzâkowe, “Kembu zâk perâkŋak zaatŋâ Simoŋ muyageŋaŋgip.” ");
INSERT INTO kpf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Oi zet yatigâk mâtâbân Kembuŋâ muyagezikâm mirin nalem ziki igâwet, zorat den siŋgi dâzâŋgowet. ");
INSERT INTO kpf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Arâp zen zorat den siŋgi sâm tatne Yesu zâk osetziŋan muyagem kinŋâ itâ sâm dâzâŋgoip, “Umziŋ diim gei ândinek.” ");
INSERT INTO kpf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Zen ekŋâ pârâkpam keŋgât op sâwe, “Wâkeŋâ muyagem gaap.” ");
INSERT INTO kpf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Sâne dâzâŋgoip, “Zen wangât keŋgât op um zagât ue? ");
INSERT INTO kpf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kin bitnâ iknek. zi ninak kinzan. Nâ sâknâ sunumnoot. Gâsunim iknek. Wâke zen yatâ zo buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Den yatâ sâm gutŋâ kiŋ bikŋan zo tirâpzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Oi sâtâre op diŋâ mân nâŋgâm pârâkpam tatne mâsikâziŋgâm sâip, “Nalem ŋâi zeŋgâren taap?” ");
INSERT INTO kpf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sâi saru zuuŋâ ŋâi oot sisiŋâ pindâwe. ");
INSERT INTO kpf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Pindâne mem mâteziŋan kin neip. ");
INSERT INTO kpf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Oi itâ sâm dâzâŋgoip, “Nâ zen sot ândim itâ dâzâŋgom ândiwan. Mosegât den sot Propete zeŋgât ekabân sot Psalm ekabân nâgât den kulemguwe, zo bonŋâ op naŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Oi Kembugât ekabân den ziap, zo sapsum ziŋgi nâŋgâm umziŋ pâroŋsâip. ");
INSERT INTO kpf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Oi itâ sâm dâzâŋgoip, “Kristo nâgât itâ kulemguwe. Nâ sâknam nâŋgâm momŋâ sirâm karâmbut tap zaatpat. ");
INSERT INTO kpf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Zorat ko kutsiŋginâ a hân dâp zeŋgâren ari umziŋ melâŋne Kembuŋâ tosaziŋ birâbap. Nep zo Yerusalem kamânân topkwap tuubi. ");
INSERT INTO kpf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Zen kut ŋâi ŋâi âsageip, zorat siŋgi a ambân dâzâŋgom ândibi. ");
INSERT INTO kpf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Oi nâŋgânek. Ibânandâ kut ŋâi zo zeŋgât siŋgi sâm kâtigeip, zo sâŋgongua gibap. Zorat zen kamân zi mân birâm mambât ândine ubâ imbaŋâ sâŋgongua zeŋgâren gibap.” (Zo Tirik Kaapum gibapkât sâip.) ");
INSERT INTO kpf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Oi kamânân gâbâ diiziŋgâm âi Betania kamân gootŋan âim bikŋâ pam mâsop minziŋgip. ");
INSERT INTO kpf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mâsop minziŋgâm zâmbam sumbemân zarip. ");
INSERT INTO kpf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Oi zen sâtâre op Yerusalem kamânân âburem âiwe. ");
INSERT INTO kpf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Âburem sirâm dâp tirik namin zâim Anutu mâpâsem sâm âlip kwâkŋaŋgâwe. Zo yatik. ");
INSERT INTO kpf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hân mân muyageibân sât zâk ândeip. Sât zâk Anutu sorâk ândeip. Oi zâk Anutuyâk op ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Topkwâkwatŋâ zo zâk Anutu sot ândim gâip. ");
INSERT INTO kpf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sât zo Anutuŋâ sâi kut ŋâi ŋâi aksik muyageziŋgip. Kut ŋâi ŋâi, zo zâk buŋâ mân muyageip. ");
INSERT INTO kpf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sât zâk ândiândigât mariŋâ ândeip. Ândiândi zorâŋ a zeŋgât âsakŋâ op âsageziŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ŋâtâtikŋâ âsakŋâ kwârakubam osim gâip. ");
INSERT INTO kpf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anutuŋâ kore a ŋâi muyagei ândeip, kutŋâ Yohane. ");
INSERT INTO kpf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","A zâkŋâ âsakŋaŋgât den sâm muyagei a aksik âsakŋâ mariŋâ nâŋgâm pâlâtâŋ kwâkŋaŋgâbigât Anutuŋâ sâŋgongoip. ");
INSERT INTO kpf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A zo, zâk âsakŋâ mariŋâ buŋâ. Zâk yen âsakŋâ mariŋaŋgât den sâm muyageziŋgâbam âsageip. ");
INSERT INTO kpf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Âsakŋandâ narâk zoren muyagem ândeip. Oi zâkŋâ a kamân dâp âsageziŋgâmap. Zâk âsakŋâ bonŋâ uap. ");
INSERT INTO kpf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Anutugât sât zâk hânân muyageip, zâkŋak mârum Anutugât sâtkât sâm hân muyageip. Oi gem gam muyagei hân a ziŋâ ekŋâ topŋâ mân nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Zikŋâ hânân gem gâi a ambân gakârâpŋâ buku mân okŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ka nâmbutŋandâ buku okŋaŋgâwe, zen Anutugât nan bârarâp upigât imbaŋâ ziŋgip. Nâmbutŋâ zen zâkkât kutŋâ nâŋgâm, nâŋgâm pâlâtâŋ kwâkŋaŋgâme, zen zo yatâ otziŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Anutugât nan bârarâp zo, zen a sep gilâmân gâbâ mân âsagime mo a dengât mân âsagime. Zen Anutuŋâ sâi âsagime. ");
INSERT INTO kpf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Sât zâk a opŋâ âsagem osetniŋan ândeip. Âsagei nen neule âsakŋâ igâwen. Âsakŋâ zo egindâ Anutu Ibâgât nanŋâ kânok, zâkkât âsakŋâ oip. Zâkŋâ tânzâŋgozâŋgoŋ sot den bonŋâ, zo mem gem gâip. ");
INSERT INTO kpf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zâkkât topŋâ Yohaneŋâ sâm muyagem itâ dâzâŋgoip, “Nâ zâkkât itâ dâzâŋgowan. Bet âsagiap, zâk kândom ândeip. Nâ mân ândia ândim gâip, zorat zâk patâ op walânim ândiap.” ");
INSERT INTO kpf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Zâkŋâ tânnâŋgom âim ândimap. ");
INSERT INTO kpf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moseŋâ girem den Anutugâren gâbâ mem niŋgip. Yesu Kristo, zâk ko tânnâŋgonâŋgo sot den bonŋâ mem niŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","A niŋâ Anutu mânâk igâwen. Ka nanŋâ zâk Anutuyâk op ândeipŋâ Ibâŋaŋgât âsan topŋan tâpmapŋâ den siŋgiŋâ mem ge sâm muyageniŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yerusalem kamânân gâbâ Yuda a ziŋâ tirik namâ galem a sot tirik namâ kore a nâmbutŋâ sâŋgonzâŋgone Yohanegâren gam, gâ wan a ŋâi, sâm mâsikâm sânetâ topŋâ dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Zâk topŋâ mân kwâimbâm itâ sapsum dâzâŋgoip, “A bâliŋan gâbâ mâkâziŋgâbapkât mârum sâsâŋ, nâ zâk buŋâ. Nâ Kristo buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sâi ziŋâ mâsikâm sâwe, “Gâ Propete Elia?” Sânetâ sâip, “Nâ zâk buŋâ.” Sâi sâwe, “Gâ Propete gâbapkât sâwe, zo?” Sâne dâzâŋgoip, “Buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Oi ziŋâ sâwe, “Gâ wan a ŋâi? Sâŋgonnâŋgone gen, zo zeŋgâren âi dap sâm dâzâŋgonat? Gikaŋgât dap sâmat?” ");
INSERT INTO kpf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sâne dâzâŋgom sâip, “Propete Yesaiaŋâ mârumŋan den sâm kulemgoip, zo nâgâren bonŋâ uap. Den zo itâ, ‘Barâ kâtik, mirâ kamân âtâŋan a ŋâiŋâ âsagem den patâ itâ sâm muyagem ândiap, “Kembugât mâtâp kârâm kubiknek.” ’” ");
INSERT INTO kpf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sâi Parisaio a ziŋ sâŋgonzâŋgone gawe, zen Yohane itâ mâsikâm sâwe, ");
INSERT INTO kpf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Gâ Kristo buŋâ, Elia buŋâ, Propete zo buŋâ oi wangât too saŋgonziŋgâmat?” ");
INSERT INTO kpf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Sâne Yohaneŋâ itâ sâm dâzâŋgoip, “Nâ tooyâk saŋgonziŋgâman. Ka osetziŋan a ŋâi muyagem ândiap, zo mân ek nâŋge. ");
INSERT INTO kpf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Zâk kândâtnan gam taap. Zâk kâwali ŋâi zemŋâŋgap. Nâ yatâ zorâŋ irâ sikumŋâ gorem aria mân dâp upap.” ");
INSERT INTO kpf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kut ŋâi ŋâi zo Betania kamânân Yodaŋ too nâmbutken muyageip. Zoren Yohaneŋâ too saŋgonziŋgâm ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Haŋsâi Yesu gâi Yohaneŋâ ekŋâ a itâ sâm dâzâŋgoip, “Iknek. Râma gwamŋâ Anutugâren gâbâ gok, zâk hân dâp a zeŋgât tosaziŋ zâkkât kwâkŋan zâibap. ");
INSERT INTO kpf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Zâkkât op itâ dâzâŋgowan. Bet âsagiap, zâk kândom ândeip. Nâ mân ândiwanân zâk ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Zorat zâk patâ op walânim ândiap. Mârum nâ zâkkât topŋâ mân nâŋgâwan. Isirae a den siŋgiŋâ dâzâŋgua nâŋgâbigât gamŋâ too saŋgonziŋgâm ândiwan.” ");
INSERT INTO kpf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohane zâk yatâ sâm sâip, “Nâ Kaapumŋâ nii kembâ yatâ opŋâ zâkkât kwâkŋan ge tâi egâwan. ");
INSERT INTO kpf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nâ mârum mân ek nâŋga sâŋgonnogip, Anutu, zâkŋâ itâ sâm dâtnogip, ‘Kaapumŋâ a kwâkŋan ge pâmbap, zâkŋâ Tirik Kaapum saŋgonziŋgâbap.’ ");
INSERT INTO kpf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yatâ âsagei ekŋâ itâ dâzâŋguan. Zi Anutugât nanŋâ.” ");
INSERT INTO kpf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mirâ haŋsâi Yohane sot azatŋâ, zen zorenâk âi kirâwe. ");
INSERT INTO kpf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kinetâ Yesuŋâ zoren gâi Yohaneŋâ ekŋâ azatŋâ itâ dâzâkom sâip, “Egit. Ândiren zi râma gwamŋâ, Anutugâren gâbâ gok.” ");
INSERT INTO kpf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Sâi zet den zo nâŋgâm Yesu kândâtŋan molim âiwet. ");
INSERT INTO kpf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Aritâ Yesuŋâ puriksâm zikitŋâ sâip, “Zet wan kârum gabot?” Yatâ sâi zikŋâ ziiŋ denân sâwet, “Raboni (niiŋ denân ko, Patâ), gâ mirâ ikâ zoren ândiat?” ");
INSERT INTO kpf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Sâitâ dâzâkoip, “Ga egit.” Sâi zet zâk sot âi ândiwet. Mirâsiŋ geibâ sâi zet zâk sot âi ândeitâ ŋâtiksâip. ");
INSERT INTO kpf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","A zagât gawet, zekâren gâbâ a ŋâi kutŋâ Andrea, Simoŋ Peterogât munŋâ. Zâkŋâ zorenâk âim âtâŋâ muyagem itâ sâm dukuip, “Net a bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, Kristo, zâk muyagiet.” ");
INSERT INTO kpf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yatâ sâmŋâ Yesugâren diigi âiwet. Oi Yesuŋâ ekŋâ itâ sâip, “Gâ Simoŋ Yohanegât nanŋâ. Kutkâ Kepa san (niiŋ denân ko, kât kâtikŋâ).” ");
INSERT INTO kpf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mirâ haŋsâi Yesu zâk Galilaia hânân âibam Pilipo muyagemŋâ itâ sâm dukuip, “Gâ târokwatnim molini.” ");
INSERT INTO kpf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipo zâk Besaida kamânân gok. Andrea sot Petero, zet zo gokŋik. ");
INSERT INTO kpf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipoŋâ Natanae muyagem itâ sâm dukuip, “A zirat Moseŋâ gurumin den ekabân kulemgoip. Mârum Propete a zen yatik kulemguwe. A zâk muyagien, zâk Yesu, Yosepegât nanŋâ, Nasarete kamânân gokŋâ.” ");
INSERT INTO kpf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Sâi Natanaeŋâ itâ mâbureip, “Nasarete kamânân dap yatâ a patâ âsagibap?” Sâi Pilipoŋâ itâ sâm dukuip, “Ga eknan.” ");
INSERT INTO kpf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yatâ sâi Natanaeŋâ Yesugâren ari ekŋâ sâip, “A zi Isirae a bonŋâ. Umŋan sarâ mân ziap.” ");
INSERT INTO kpf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yatâ sâi Natanaeŋâ mâsikâm sâip, “Dap yatâ opŋâ topnâ nâŋgat?” Sâi Yesuŋâ sâip, “Pilipoŋâ mân diigigi wakum nak topŋan kina geksan.” ");
INSERT INTO kpf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Sâi Natanaeŋâ itâ sâm dukuip, “Patâ, gâ perâkŋak Anutugât nanŋâ. Gâ Isirae neŋgât a kutâ patâ.” ");
INSERT INTO kpf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Oi Yesuŋâ itâ sâm dukuip, “Gâ wakum nak topŋan taat, nâŋâ zo dâgoga nâŋgâm ko nâŋgâm pâlâtâŋ otnigat? Ek nâŋgat, zo yenŋâ. Kut ŋâi ŋâi patâ ek nâŋgâm zâiban.” ");
INSERT INTO kpf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yatâ sâmŋâ sâip, “Nâ perâkŋak dâgobâ. Sumbem pâroŋsâi Anutugât sumbem a, zen a bonŋâ nâgâren zâim gine ziŋgitpi.” ");
INSERT INTO kpf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sirâm zagât âki Kana kamânân, Galilaia hânân a ambân zagât mâpotzikânam sii nalem mine gâip. ");
INSERT INTO kpf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesugât mamŋâ Maria, zâk zoren âi taki ko Yesu sot arâpŋâ, nen zop sâsâŋan âiwen. ");
INSERT INTO kpf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Zoren mindum nalem sot waiŋ nem tâindâ waiŋ buŋ oip. Buŋ oi Yesu mamŋandâ dukum sâip, “Waiŋziŋâ buŋ uap.” Sâi Yesuŋâ itâ sâm dukuip, ");
INSERT INTO kpf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“O ambân, gâŋâ nâ mân dâtnoban. Ninak nâŋgâbat dâp upat. Nâgât narâk, zo gâtâm mâte upap.” ");
INSERT INTO kpf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yatâ sâi mamŋandâ kore a ambân itâ sâm dâzâŋgoip, “Den sâbap, zo lum kwâtâtibi.” ");
INSERT INTO kpf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Oi mirâ zoren âmaŋ kârep patâ nâmburân kânok tâip. Yuda a zen âsâbâŋ kin bitziŋ too saŋgonŋâ nalem nemarâwe. Oi mirâ dâp âmaŋ yatâ kin ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Oi Yesuŋâ kore a ambân itâ sâm dâzâŋgoip, “Too aam ga âmaŋân lokine giarik.” Sâi zen yatâ utne âmaŋ nâmburân kânok zo too piksâm naŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yatâ utne ko itâ sâm dâzâŋgoip, “Itârâŋ zen torenŋâ aam nalem galem agâren âinek.” ");
INSERT INTO kpf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yatâ sâi zen aam galem agâren âine tooŋâ waiŋ oi nalem galem aŋâ nemŋâ waiŋ zo waniŋ gâbâ mie sâm kwagip. (Kore a zen too âmaŋân aam lokine giarip, zeŋak waiŋgât topŋâ nâŋgâwe.) Nalem galem aŋâ a ambân meip, zo konsâi gâip. ");
INSERT INTO kpf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Gâi itâ sâm dukuip, “Kândom wâiŋ naamŋâ ziŋgâne bet umziŋ gulip upâ sâi waiŋ naam buŋâ, zo ziŋgâmen. Gâ ko purikgurik opŋâ waiŋ naamŋâ kwarakuna zei bet muyagiat. Zo âlip uat.” ");
INSERT INTO kpf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu zâk yatâ op Kana kamânân, Galilaia hânân sen mârât nep topkwapŋâ tuugip. Oi imbaŋâŋaŋgât topŋâ, zo mem kâkŋan pâip. Oi arâpŋâ nen zo ekŋâ nâŋgâm pâlâtâŋ kwâkŋaŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Oi Yesu zâk Kana kamânân gâbâ Kapenaum kamânân ari mam murâpŋâ sot arâpŋâ molim âiwen. Sirâm nâmbutŋâ nen zoren ândiwen. ");
INSERT INTO kpf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yuda zeŋgât kendon patâ kutŋâ Pasowa, zo mâte upâ sâi Yesuŋâ Yerusalem kamânân zarip. ");
INSERT INTO kpf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yerusalem kamânân âi takâm tirik namin zari a doŋbep zen râma, makau sot kembâ aŋgâgwaŋgâ utne a nâmbutŋâ zen Roma zeŋgât kât sot Yuda zeŋgât kât, zo hâukwap aŋgâgwaŋgâ op kirâwe. ");
INSERT INTO kpf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yatâ utnetâ Yesuŋâ ziŋgitŋâ tâkŋâ mem a sot râma makau zâŋgom moliziŋgi âine kât nep tuuwe, zeŋgât kât mem lokim tâtatŋâ kom kâbakŋei giarip. ");
INSERT INTO kpf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Oi kembâ mem kirâwe, zen itâ sâm dâzâŋgoip, “Zen Ibânaŋgât namin kut ŋâi laŋ utne aŋgâgwaŋgâ namâ uap. Kut ŋâi ŋâiziŋ mem âinek.” ");
INSERT INTO kpf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesuŋâ yatâ oi arâpŋâ nen Kembugât ekabân den kulem ziap, zo nâŋgâwen. Den zo itâ, “Gâgât namâgât opŋâ umnâ kârâp siap.” ");
INSERT INTO kpf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Oi Yuda a ziŋâ itâ sâm mâsikâm sâwe, “Gâ yatâ uatŋâ top likuliku kulem ŋâi tuuna iknâ.” ");
INSERT INTO kpf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Zen tirik namâ zi kândaŋne nâŋâ sirâm karâmbut umŋan tuum naŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yatâ sâm dâzâŋgoi sâwe, “Patârâpniŋâ, zen tirik namâ zi kendon 46 tuum ândine âkip. Oi gâŋâ sirâm karâmbut umŋan tuum naŋgâbat sâm sat?” ");
INSERT INTO kpf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ka Yesu zâk sâkŋaŋgât op namin dâpkwap sâip. ");
INSERT INTO kpf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yesu ândim moi Anutuŋâ mâŋgei zari arâpŋâ nen den zo nâŋgâwen. Oi namâgât sâip, zo sot Kembugât ekabân zâkkât den nâmbutŋâ ziap, zorat nâŋgindâ bonŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu zâk kendonân Yerusalem kamânân top likuliku kulem nâmbutŋâ tuugi a ambân pisuk, ziŋâ ekŋâ zâkkât nâŋgâne bonŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesu zâk a zeŋgât topziŋ ek nâŋgâmap, zorat op ko a zeŋgâren mân arip. ");
INSERT INTO kpf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Zâkŋâ a ŋâigât topŋâ ek nâŋgâbam a ŋâigâren mân mâsikâm nâŋgip. Zâk zikŋak umziŋan ek nâŋgâm naŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisaio a ŋâi ândeip, kutŋâ Nikodemo. Zâk Yuda a zeŋgât a patâ, zeŋgât buku op ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","A zorâŋ ŋâtigân Yesugâren gam itâ sâm dukuip, “Patâ, nen gâgât topkâ nâŋgen. Gâ a patâ, Anutugâren gâbâ gâin. Gâ sen mârât kulem top top tuumat, zorat itâ nâŋgan. Anutuŋâ gâ sot mân ândei sâi ko mân tuubat.” ");
INSERT INTO kpf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Sâi Yesuŋâ mâburem dukuip, “Nâ perâkŋak dâgobâ. Ŋâi zâk âsaâsagiŋ uŋakŋâ mân âsagem ândibap, zo ko Anutugât um topŋan mân bagibap.” ");
INSERT INTO kpf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Sâi Nikodemoŋâ pârâkpam itâ sâm mâsikip, “A ŋâi mârum patâ opŋâ dap op âsaâsagiŋ uŋakŋâ âsagibap? Zâk mam kâmboŋan âburei dum zagâtŋâ mimbapkât sat?” ");
INSERT INTO kpf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Sâi Yesuŋâ itâ sâm dukuip, “Nâ perâkŋak dâgoba. Ŋâi zâk Kaapum sot too umŋan mân âsagibapŋâ Anutugât um topŋan mân bagibap. ");
INSERT INTO kpf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Agât kâmboyân âsaâsagiŋ, zâk ayâk. Ka a ŋâi, zâk Kaapumŋâ umŋan muyamuyagiŋ, zâk Kaapumgâren gokŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Zen âsaâsage uŋakŋâ âsagibigât sa nâŋgâna mân kwakmak upap. ");
INSERT INTO kpf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pibâ zâk laŋ komap. Oi kwamitŋâ nâŋgâme. Ikâ gâbâ gâmap, oi ikâ âi âkâmap, zo zen mân nâŋgâme. Oi ŋâi zâk Kaapumgâren muyageip, zâkkât topŋâ yatâ.” ");
INSERT INTO kpf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Sâi Nikodemoŋâ mâburem itâ sâm dukuip, “Zo dap op yatâ orotŋâ?” ");
INSERT INTO kpf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sâi Yesuŋâ itâ sâm dukuip. “Gâ Isirae a zeŋgât a sâtŋandâ kwaksat? ");
INSERT INTO kpf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nâ perâkŋak dâgobâ. Nen kut ŋâi ŋâi ek nâŋgâmen, zo dâzâŋgomen. Oi zen ko dinniŋâ birâme. ");
INSERT INTO kpf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nâ hânân Anutuŋâ nep tuumap, zorat topŋâ dâzâŋgua mân nâŋgâme. Oi sumbemân nep tuumap, zorat topŋâ dâzâŋgua dap dabân nâŋgâne âkâbap? ");
INSERT INTO kpf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","A zeŋgâren gâbâ ŋâiŋâ sumbemân mân zarip. Ka a bonŋâ nâ sumbemân gâbâ gem gâwan. Nâ kânok sumbemân gâbâ gem gâwan. ");
INSERT INTO kpf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mârum mirâ kamân kâtikŋan Moseŋâ mulum dâp tuum nagân mândip. Zo yatik narâk zi a bonŋâ, nâ nagân nom kwânâŋgânibigât sâsâŋ. ");
INSERT INTO kpf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Oi a zen nâŋgâm pâlâtâŋ kwatnibiŋâ ândiândi kâtik muyagibi. ");
INSERT INTO kpf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anutu zâk a zeŋgât umŋâ doŋbep gâsui nanŋâ kânok, nâ sâŋgonnogi gâwan. Oi zen nâ nâŋgâm pâlâtâŋ kwatnimŋâ mân tâmbetagobi. Zen nâ nângâm pâlâtâŋ kwatnim ândiândi kâtik muyagibigât sâŋgonnogi gewan. ");
INSERT INTO kpf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nanŋâ nâ a zeŋgât tosaziŋaŋgât sâm kwâkâbatkât buŋâ. A tânzâŋgobatkât Anutuŋâ sâŋgonnogi gem gâwan. ");
INSERT INTO kpf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Oi ŋâi zâk nâŋgâm pâlâtâŋ kwatnibapŋâ zâkkât tosagât hâuŋâ mân mimbap. Ka ŋâi zâk nanŋâ nâ mân nâŋgâm pâlâtâŋ kwatnibapŋâ tosa hâuŋaŋgât siŋgi op zimbap. Wangât, zâk Anutu nanŋâ kânok, nâgât mân nâŋgâm pâlâtâŋ kwatnigip, zorat. ");
INSERT INTO kpf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hâuŋaŋgât topŋâ itâ ziap. Âsakŋâ nâŋâ hânân ga a ziŋ ŋâtâtikkât nâŋgâne bonŋâ oi âsakŋâ nâ kândâtnowe. Orot mâmeziŋ bâliŋâ zeip, zorat yatâ urâwe. ");
INSERT INTO kpf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ŋâi zâk bâliŋâ opmapŋâ âsakŋâ kândâtkomap. Bâliŋandâ âsakŋan muyagei ikpegât âsakŋan mân gâmap. ");
INSERT INTO kpf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ŋâi zâk den bonŋâ lubapŋâ âsakŋâ mâte upap. Oi kut ŋâi ŋâi opmap, zo Anutugât sâtkât opmap, zorat topŋâ muyagibap.” ");
INSERT INTO kpf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesu sot arâpŋâ, nen Yerusalem kamân birâmŋâ Yudaia hân torenŋan âi ândiwen. Zoren Yesu sot arâpŋâ niŋâ a ambân too saŋgonziŋgâm ândiwen. ");
INSERT INTO kpf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohane ko zâk hân ŋâi kutŋâ Aenon, Salim kamân naŋgâmŋan zoren a too saŋgonziŋgâm ândeip. Zoren too doŋbep zeipkât a zen zoren mindum gane saŋgonziŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Narâk zoren Yohane tâk namin mân parâwe. ");
INSERT INTO kpf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yuda a ŋâi sot Yohanegât arâp, zen bitziŋ too saŋgonsaŋgon zorat topŋâ sâm âraguwe. ");
INSERT INTO kpf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Oi ziŋâ Yohanegâren gam itâ sâm dukuwe, “Patâ, gâ Yodaŋ too nâmbutken ândina a ŋâi muyagei topŋâ dâtnâŋgoin. Zâk narâk ziren ga a too saŋgonziŋgi a doŋbepŋâ zâkkâren arie.” ");
INSERT INTO kpf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Sâne Yohaneŋâ itâ sâm dâzâŋgoip, “Anutuŋâ a ŋâi kâwali mân pindi zikŋak dabân yatâ mimbap? ");
INSERT INTO kpf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nâ itâ sâm dâzâŋgowan, zo dap op kwâimbâbi. A bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, nâ zâk buŋâ. Nâ Kristo buŋâ. Nâ kândom okŋaŋgâm gaan. ");
INSERT INTO kpf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ambân siŋgi sâm pindâwe, zâkŋâ ambân mariŋâ. Oi ambân mem âkŋâle patâ oi bukuŋandâ nâŋgâm bekŋan mem umâlep patâ upap. Nâ yatâ op umâlep nâŋgâbatkât narâkŋâ zo mâte uap. ");
INSERT INTO kpf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Zâkkât ko zâizâiŋ. Nâgât ko diim gibap.” ");
INSERT INTO kpf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ubâ geipŋâ walâniŋgâmap. Hânân gokŋandâ hângât siŋgi uen. Nen hângât kut ŋâi ŋâi zorat den sâmen. Ka zâk ko sumbemân gâbâ geipŋâ walâniŋgâm naŋgap. ");
INSERT INTO kpf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kut ŋâi ŋâi ek nâŋgip, zorat siŋgi sâmap. Oi a zen zâkkât diŋâ birâme. ");
INSERT INTO kpf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ka a nâmbutŋâ ziŋ diŋâ nâŋgâme, zen itâ nâŋgâbi, “Anutuŋâ sâi kâtikkâtigiŋ ândiap, zâk diŋâ zo tângumap.” ");
INSERT INTO kpf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anutuŋâ a sâŋgonguip, zâk Anutugât denâk sâmap. Oi a yatâ zo ko Anutuŋâ Kaapumŋâ imbaŋâ pindâmap. ");
INSERT INTO kpf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Anutu Ibâŋandâ nanŋaŋgât umŋâ gâsui zâkkât bikŋan kut ŋâi ŋâi zo aksik pam naŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ŋâi zâk nanŋâ nâŋgâm pâlâtâŋ kwâkŋaŋgâm ândiap, zâk narâk ziren ândiândi kâtik mârum muyagiap. Oi ŋâi zâk nanŋâ kândâtkom diŋâ birâm ândibapŋâ ândiândi kâtik mân muyagibap. Buŋâ. Anutuŋâ kuk okŋaŋgi tap zâibap. ");
INSERT INTO kpf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisaio a, zen Yesugât itâ nâŋgâwe, “Zâkŋâ a gâsâzâŋgom too saŋgonziŋgap, zo Yohanegât kâmut walâziŋge.” ");
INSERT INTO kpf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Den zo yen sâwe. Yesu zikŋak a too mân saŋgonziŋgip. Zâk yen sâi arâpŋâ niŋâ too saŋgonziŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Oi Kembuŋâ den zo nâŋgâm Yudaia hân birâm Galilaia hânân arip. ");
INSERT INTO kpf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria hân mâtâp arip. ");
INSERT INTO kpf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Âimŋâ Samaria hânân kamân ŋâi kutŋâ Sika, zoren takip. Kamân zorat naŋgâmŋan hân ŋâi zeip. Mârumŋan Yakoboŋâ hân zo nanŋâ Yosepe pindip. ");
INSERT INTO kpf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Too lâm ŋâi zoren zeip, kutŋâ Yakobogât too lâm. Oi Yesu zâk mâtâp kârep âimŋâ loreip. Oi mirâ bâkŋan oi zoren takâm lâm ginŋan ge tap nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Yesu arâpŋâ, nen nalem sâŋgân minam kamânân ârindâ Yesu zâk zikŋik tâi Samaria ambân ŋâiŋâ too aabam gâip. Gâi Yesuŋâ itâ sâm dukuip, “Too ŋâi aam nina nimbâ.” ");
INSERT INTO kpf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Dukui ambân zorâŋ sâip, “Gâ Yuda aŋâ, wangât Samaria ambân nâgâren toogât sat? Zo mân orotŋâ.” Zo Yuda sot Samaria a buku buku mân op ândiwegât ambân zorâŋ den yatâ sâip. ");
INSERT INTO kpf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sâi Yesuŋâ itâ sâm dukuip, “Gâ Anutugâren gâbâ kut ŋâi gâbap, zo sot nâgât topnâ mân nâŋgat. Nâŋgâm sâi ko nâgâren oletnina too takâtakâŋ gibam.” ");
INSERT INTO kpf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sâi ambân zorâŋ itâ sâm dukuip, “Too lâm zi kârep. Gâ too aaŋ âmaŋ buŋgât too takâtakâŋ ikâ gâbâ aaban? ");
INSERT INTO kpf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Sâkuniŋâ Yakoboŋâ too lâmniŋâ zi esip. Oi zâk sot narâpŋâ sot râma makau gakârâpŋâ, zen too zirik nem ândiwe. Gâ Yakobo walâm too takâtakâŋ muyagibam sat?” ");
INSERT INTO kpf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Sâi Yesuŋâ itâ sâm dukuip, “Too zi sâumŋâ nem zagât nem ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nâgât too ko nemŋâ umgâ sânduksâbap. Ŋâi zâk too zo nimbapŋâ toogât mân nâŋgâm ândibap. Nâŋâ too zo a ŋâi pinda umŋan too takâtakâŋ muyagem zei a zo ândiândiŋ kâtikŋâ ândibap.” ");
INSERT INTO kpf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sâi ambânŋâ diŋaŋgât topŋâ mân nâŋgâm kwâkâmŋâ itâ sâip, “Patâ, gâ too zo nina nem toogât zagât mân nâŋgâbat. Oi ziren âsâbâŋ toogât gâman, zo birâbat.” ");
INSERT INTO kpf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yatâ sâi Yesuŋâ itâ sâm dukuip, “Âi apkâ sâna kândiaŋgâm gâit.” ");
INSERT INTO kpf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Sâi ambânŋâ sâip, “Nâ apnâ buŋâ.” Sâi Yesuŋâ itâ sâm dukuip, “Gâ apkâ buŋâ, zo âlip sat. ");
INSERT INTO kpf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gâ a bâtnâmbut mem birâziŋgin. Oi irabot miat, zo apkâ buŋâ. Zorat gâ den perâkŋak sat.” ");
INSERT INTO kpf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Sâi ambânŋâ itâ sâip, “Patânâ, gâ nâgât topnâ dap yatin nâŋgat? Nâ irabot zi nâŋgan. Gâ Propete a ŋâi ândiat. ");
INSERT INTO kpf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Zorat sâna nâŋgâbâ. Sâkurâpniŋâ, zen bakŋâ ziren Anutu mâpâsem ândiwe. Ka Yuda a zen ko Yerusalem kamânân Anutu mâpâsem ândinat sâm sâme.” ");
INSERT INTO kpf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Oi Yesuŋâ ambân itâ sâm dukuip, “Ambân, gâ dâgoga nâŋgâ. Narâk ŋâi mâte upâmap. Narâk zoren bakŋa ziren mo Yerusalem kamânân zorenâk buŋâ. Zoren mo zoren âlipŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria a, zen topŋâ mân nâŋgâm mâpâsime. Yuda a, nen ko topŋâ nâŋgâm mâpâsimen. Oi Anutuŋâ kubikkubikniŋâ, zo Yuda a neŋgâren pâip. ");
INSERT INTO kpf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Narâk ŋâi mâte upap. Oi zi mârum mâte uap. Zoren kâmut gakârâpŋâ bonŋâ, zen Kaapum sot op umziŋandâ Anutu mâpâsibi. Ibâ zâk a yatâ zo mâpâseŋaŋgâbigât nâŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anutu zâk Kaapum mân igikŋâ. Zorat zâk mâpâsime, zen Kaapum sot opŋâ mâpâsime. Yatâ upi, zo ko mâpâmâpâse bonŋâ.” ");
INSERT INTO kpf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sâi ambânŋâ itâ sâm dukuip, “Nâ nâŋgan. A bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, zâk gâbap. A zo muyagemŋâ kut ŋâi ŋâi zorat sâm muyagem niŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Sâi Yesuŋâ itâ sâm dukuip, “A zo, nâ.” ");
INSERT INTO kpf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yatâ sâm tâi arâpŋâ nen gawen. Gam ambân sot den âraguwet, zorat nâŋgâm imbaŋâniŋ buŋ oip. Wangât ambân sot den uat sâm mâsikânam nâŋgindâ yâmbârei birâwen. ");
INSERT INTO kpf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Oi ambân zâk too âmaŋ birâm sârârâk kârâm âim kamânân âim a ambân itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Zen gam a ŋâi zi iknek. Nâ kut ŋâi ŋâi orâwan, zo aksik sâm muyagem naŋgap. A bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, zo zi motŋâi.” ");
INSERT INTO kpf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Oi kamânân gâbâ â ambân pisuk, zen Yesugâren gawe. ");
INSERT INTO kpf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Gam tatne Yesu arâpŋâ niŋ itâ sâm dukuwen, “Patâ, nalem ne.” ");
INSERT INTO kpf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sâindâ itâ sâm dâtnâŋgoip, “Nalem tobat ŋâi zemnigap, zo mân nâŋge.” ");
INSERT INTO kpf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Zo yatâ sâi arâpŋâ niŋ itâ âraguwen, “Nalem zo ŋâiŋâ mem ga pindap?” ");
INSERT INTO kpf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sâindâ Yesuŋâ itâ sâm dâtnâŋgoip, “Saŋgonogip, zâkkât den lum nepŋâ tuuman, zorâŋ nalemnâ uap. ");
INSERT INTO kpf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Zen itâ nâŋgâme, ‘Kâin kimembut âki kâlamân nalem bonŋâ muyagibap.’ Ka nâŋâ dâzâŋgua nâŋgânek. Zen zaat kâlam zi iknek. Bon muyamuyagiŋ narâk mâte uap. (A ambân kamânân gâbâ gam tarâwe, zeŋgât op sâip.) ");
INSERT INTO kpf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ŋâi zâk nalem bonŋâ mem mindubapŋâ, zorat sâŋgân mibap. Oi bonŋâ zo ândiândi kâtikkât siŋgi upap. Oi nep kârâm kâmerip sot bon mem zarip, zet ârândâŋ sâtâre upabot. ");
INSERT INTO kpf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Oi den ŋâi Kembugât ekabân ziap, zo kâtigibap. Den zo itâ, ‘Ŋâiŋâ nep kârâm kâmitmap. Ŋâiŋâ ko bonŋâ mei zâibap.’ ");
INSERT INTO kpf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nâŋâ zen mân kârâm kâmirâweyân bonŋâ mimbigât sâm ziŋgâwan. Mârum a nâmbutŋâ nep zo tuum ândinetâ bonŋâ muyagei zen yen galem op bonŋâ mem ândie.” ");
INSERT INTO kpf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria ambân zo zâk kamârâp itâ sâm dâzâŋgoip, “A zi kut ŋâi ŋâi orâwan, zorat topnâ pisuk sâm muyagiap.” Den zorat a ambân doŋbepŋâ Yesu nâŋgâm pâlâtâŋ kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yesuŋâ arâpŋâ nen den dâtnâŋgom tâi a ambân ziŋ kamânân gâbâ gam Yesugâren takâm zen sot ândibapkât dukuwe. Sânetâ ko sirâm zagât zen sot ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yesuŋâ siŋgi âlip dâzâŋgoi doŋbep patâŋâ nâŋgâmŋâ, nâŋgâm pâlâtâŋ kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Oi zen ambân zo itâ sâm dukuwe, “Kândom gâgât dengât op nâŋgâm pâlâtâŋ kwâkŋaŋgen. Irak ko niiŋak diŋâ nâŋgâm itâ nâŋgâm kwâtâtien. Zâk perâkŋak a hân dâp neŋgât kubikkubik a op ândiap.” ");
INSERT INTO kpf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu zâk sirâm zagât ândimŋâ Galilaia hânân arip. ");
INSERT INTO kpf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu zâk zikŋak itâ sâip, “Propete a ŋâigât kutsiŋgiŋâ kamân toren toren laŋ kârâm âimap. Kamârâpŋâ ziŋâ ko zâkkât nâŋgâne yenŋâ opmap.” ");
INSERT INTO kpf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesuŋâ Galilaia hânân taki Galilaia a ziŋâ buku okŋaŋgâwe. Zen mârumŋan Yerusalem kamânân âine kendon patin nepŋâ tuugi igâwe, zorat yatâ okŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kana kamânân Galilaia hânân mârum sâi tooŋâ waiŋ oip, zoren dum âi takip. Kapenaum kamânân a sâtŋâ ŋâi ândeip, zâkkât nanŋâ mâsek op zeip. ");
INSERT INTO kpf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yesu zâk Yudaia hânân gâbâ âburem Galilaia hânân gaap sâne a sâtŋâ zorâŋâ nâŋgâm Kana kamânân âimŋâ Yesu muyagem nanŋâ mumbam op zeip, zo kubikŋaŋgâbapkât dukuip. ");
INSERT INTO kpf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Oi Yesuŋâ itâ sâm dukuip, “Nâ sen pup kulem mân tuuga dap op dinnaŋgât nâŋgâne bon upap?” ");
INSERT INTO kpf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Oi a sâtŋâ zorâŋ itâ sâip, “Patâ, nannâ mombapkât kek gâban.” ");
INSERT INTO kpf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sâi Yesuŋâ itâ sâm dukuip, “Gâ yen âi. Nangâ ko âlip uap.” Yatâ sâi a zo Yesugât den nâŋgi bon oi arip. ");
INSERT INTO kpf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Zâk mâtâbân ari kore a ziŋ gam sâwe, “Nangâ mârum âlip op taap.” ");
INSERT INTO kpf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Sâne âlip oip, zorat narâkŋaŋgât mâsikâziŋgi sâwe, “Muka mirâ bâkŋan, zoren sâkŋâ sânduksâip.” ");
INSERT INTO kpf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yatâ sâne a sâtŋâ zâk topŋâ itâ nâŋgip, “Narâk zoren Yesuŋâ sâŋgonnom sâip, ‘Nangâ âlip uap.’” Oi zikŋâ sot a ambân kâmut gakârâpŋâ, zen Yesu nâŋgâm pâlâtâŋ kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu zâk Yudaia hânân gâbâ Galilaia hânân âburem âi sen mârât nep tuugi sâp zagât oip. ");
INSERT INTO kpf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yuda zeŋgât kendon patâ ŋâi mâte oi Yesu zâk Yerusalem kamânân zarip. ");
INSERT INTO kpf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Oi Yerusalem kamânân poŋ kâtikŋâ kirip, zoren mâtâp ŋâi kirip, zorat kutŋâ râma zeŋgât mâtâp. Mâtâp zorat naŋgâmŋan too deŋgân ŋâi zeip, kutŋâ Betesida. Zorat sâtŋan mirâ bâtnâmbut tâip. ");
INSERT INTO kpf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Mirâ zoren a mâsekziŋoot sot sen ŋâtâtik sot kin bitziŋ bâliŋâ sot sâkziŋ gigiŋâ, zen zem ândiwe. (Kembugât sumbem a ŋâiŋâ narâk ŋâin ŋâin gem ga toin geim golaŋkoip. Yatâ oi mâsek a ŋâi kândom toin giarip, zâk mâsek okŋaŋgip, zo buŋ oip.) Zorat zen too kwamit oi nâŋgânat sâm mambâtmarâwe. ");
INSERT INTO kpf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Oi zoren a ŋâi zeip. Zâk kiŋ bikŋâ bâliŋ oi zem tâi kendonŋâ 38 âkip. ");
INSERT INTO kpf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu zâk a zo ekŋâ narâk kârep ziap sâm mâsikâm sâip, “Gâ sâkkâ âlip upapkât otgigap?” ");
INSERT INTO kpf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Sâi ko sâip, “Patâ, ŋâiŋâ ândim too kwamitsâi toin diinim gei nâbanbap? Oi ninak geibâ sa a ŋâiŋâ walânim kek geimap.” ");
INSERT INTO kpf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sâi Yesuŋâ itâ sâm dukuip, “Gâ zaat isen koremgâ lum âi.” ");
INSERT INTO kpf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sâi zorenâk sâkŋâ âlip oi zaatŋâ isen koremŋâ mem arip. Sirâm zoren Yuda a zeŋgât kendon narâk oi Yesuŋâ a zo kubigip. ");
INSERT INTO kpf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Zorat Yuda a nâmbutŋâ ziŋ a âlip oip, zo itâ dukuwe, “Itârâŋ kendonân isen koremgâ lum ariat, zo mân orotŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sânetâ itâ sâm dâzâŋgoip, “Kubiknigapŋâ itâ dâtnogap, ‘Gâ isen koremgâ mem âi.’” ");
INSERT INTO kpf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Sâi mâsikâm sâwe, “Isen koremgâ mem âi sâm dâgogap, zâk kutŋâ ŋâi?” ");
INSERT INTO kpf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sâne kubikŋaŋgip, zorat kwagip. Oi Yesu zâk a kâmut kirâwe, zeŋgât oserân gâbâ tik arip. ");
INSERT INTO kpf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bet Yesuŋâ a zo tirik namin muyagem girem den itâ dukuip, “Gâ sâkkâ âlip uap. Oi kut ŋâi ŋâi yâmbâtŋâ muyagegibapkât bâliŋâ dum zagâtŋâ mân upan.” ");
INSERT INTO kpf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sâi a zo Yesu ek nâŋgâm âi Yuda a sâtŋâ itâ sâm dâzâŋgoip, “A kubiknigap, kutŋâ Yesu.” ");
INSERT INTO kpf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesu zâk kendonân nep yatâ tuugipkât Yuda a sâtŋâ, ziŋ kâsa miŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yatâ utne Yesuŋâ itâ sâm dâzâŋgoip, “Ibânâ Anutu, zâk nep tok tuum ândim gâmap. Oi nâ yatik nep tuum taan.” ");
INSERT INTO kpf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu zâk kendonân a kubigip sot Anutugât ibânâ sâip, zorat Yuda a sâtŋâ ziŋ nâŋgâne bâliŋ oi Anutu hutkum sap sâm kunam sâm kâtigiwe. ");
INSERT INTO kpf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu zâk itâ sâm dâzâŋgoip, “Nâ perâkŋak dâzâŋgua nâŋgânek. Nanŋâ nâ ninâ umgât nep mân tuuman. Ibânâ zâk nep tuugi ekŋâ yatik tuuman. Ibânâ zâk tuumap, zo yatik nanŋâ nâŋâ tuuman. ");
INSERT INTO kpf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ibâ zâk nanŋâ nâ nek umŋâ nâgâren kinmapkât nep tuumap, zo yatik tirâpnomap. Oi nep zi ikse, zorik buŋâ. Nep zâizâiŋâ tirâpnogi zen ekŋâ nâŋgâne imbaŋâ upap. ");
INSERT INTO kpf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Zo itâ. Ibâ zâk a mumuŋâ mâŋgiziŋgi zaat ândime. Nanŋâ naŋâ yatik a mumuŋâ ŋâi mâŋgibâ sâm mâŋgibat. ");
INSERT INTO kpf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ibâ zâk nanŋâ nâ a zeŋgât topziŋ sâm kâkŋan kwatziŋgâbatkât nep zo sâm nigip. ");
INSERT INTO kpf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Zen Ibâ hurat kwâkŋaŋgâme, zo yatik nanŋâ nâ hurat kwatnibigât yatâ oip. Ŋâi zâk nanŋâ nâ mân hurat kwatnibapŋâ Ibânâ sâŋgonnogip, zâk mân hurat kwâkŋaŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nâ perâkŋak dâzâŋgua nâŋgânek. Ŋâi zâk dinnâ nâŋgâbapŋâ sâŋgonnogip, zâk nâŋgâm pâlâtâŋ kwâkŋaŋgâbap. Oi a zo ândiândiŋ kâtikŋâ mem ândiap. Zâk mumuŋâ kândâtkum ândiândiŋ kâtikŋâ muyagiap. Zâk tosaŋaŋgât hâuŋâ mân mimbap. ");
INSERT INTO kpf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nâ perâkŋak dâzâŋgua nâŋgânek. Narâk zi mâte uap, zoren a sâkziŋ wâgân umziŋ mumuŋ ândie, zen Anutu nanŋâ ninâ den nâŋgâm umziŋ kubikaŋgi ândiândi kâtik mâte op ândibi. Oi yatigâk narâk ŋâi mâte upabân a mumuŋâ zo, ziŋâ Anutu nanŋâ nâgât dinnâ nâŋgâm zaat ândiândi kâtik ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ibâ zâk ândiândi mariŋâ ândiapkât nanŋâ nâ ândiândi mariŋâ op ândibatkât sâm nigip. ");
INSERT INTO kpf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Oi nâ a bonŋâ ândiangât a tosaziŋ hâuŋaŋgât den sâm kwâkâbatkât sâm nigip. ");
INSERT INTO kpf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Zen den zo nâŋgâne mân kwakmak upap. Narâk ŋâi mâte upap, narâk zoren a mumuŋâ hanzâŋgone zie, zen nânŋâ nâgât den nâŋgâmŋâ gwâlâ op zaat naŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ândiândi âlip ândiweŋâ dinnâ nâŋgâm zaatŋâ ândiândi kâtik mem ândim zâimambi. A nâmbutŋâ ândiândi bâliŋ ândiweŋâ zaatŋâ tosaziŋaŋgât hâuŋâ mimbi. ");
INSERT INTO kpf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nâ ninâ umgât nep yatâ zo âlip mân tuubat. Ibânaŋgât sâtkât hâuŋaŋgât den sâm kwâkâman. Zo yatâ op hâuŋaŋgât nep tuuga dâp upap. Zo ninâ den buŋâ, sâŋgonnogip, zâkkât den.” ");
INSERT INTO kpf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ninak topnâ sâm muyagia mân dâp upap. ");
INSERT INTO kpf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Topnâ a ŋâiŋâ sâm muyagemap. Oi nâ nâŋgan, topnâ sâm muyagei bonŋâ uap. ");
INSERT INTO kpf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Zen Yohanegâren sâm mâsikâne nâgât den bonŋâ sâm muyageip. ");
INSERT INTO kpf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Oi aŋâ topnâ sâm muyagibigât mân sâman. Zen topnâ nâŋgâm ândiândigât mâtâp lâŋbigât sâman. ");
INSERT INTO kpf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane zâk kârâp âsakŋâ patâ op âsageziŋgip. Zen zâkkât âsakŋâ zo ek âkŋâlem mâik ŋâi ândiwe. ");
INSERT INTO kpf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nâgât topnâ sâm muyagemap, zo Yohane yatâ buŋâ. Zo tobat ŋâi. Nepnâ tuuman, zorâŋ topnâ sâm muyagemap. Ibânandâ nep sâm nigip, zo tuumŋâ bonŋâ muyageman. Yatâ op ândia topnâ muyagemap. ");
INSERT INTO kpf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ibânâ sâŋgonnogip, zâk zikŋâ topnâ sâm muyageip. Zen ko den lâuŋan gâbâ gâi mân nâŋgâwe. Zen holi tobatŋâ mân igâwe. ");
INSERT INTO kpf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Zen nâgât den nâŋgâm mân nâŋgâm pâlâtâŋ kwatnige, zorat topŋâ itâ. Zen sâŋgonnogip, zâkkât diŋâ umziŋan mân pane zemap. ");
INSERT INTO kpf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Zen Kembugât ekabân itâ nâŋgâm sâlâpkume, ‘Andiândi kâtikkât mâtâp zoren zei kârum muyaginâ.’ Oi zorâŋ nâgât topnâ sâm muyagemap. ");
INSERT INTO kpf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Oi zen den zo sâlâpkumŋâ nâgâren gam ândiândi kâtik muyagime? Buŋâ. Nâgâren mân game. ");
INSERT INTO kpf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nâ aŋâ sâm âlip kwatnibigât mân sâman. ");
INSERT INTO kpf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Zeŋgât topziŋ zitâ nâŋgan. Umziŋ Anutugâren mân kinmap. ");
INSERT INTO kpf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nâ Ibânaŋgât sâtkât zeŋgâren gewan. Ga ko zen buku mân otniwe. Gâtâm a ŋâiŋâ zikŋâ umgât gâi zâk buku okŋaŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Zen ziiŋak sâm âlip kwaraŋgâm ândime. Kembuniŋ kânok, zâkŋâ sâm âlip kwatziŋgâbapkât mân nâŋgâme. Oi dabân nâŋgâm pâlâtâŋ kwatnibi? ");
INSERT INTO kpf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Zen nâgât itâ mân sâbi, ‘Zâk Ibâgâren neŋgât sâm bâlip kwâpap.’ Yatâ buŋâ. Zen Mosegâren pâlâtâŋ upme. Ka Moseŋâ zen sâm bâliŋ kwatziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wangât, Moseŋâ den kulemguip, zo nâgât op kulemguip, zorat. Zen zâkkât den nâŋgâm sâi nâgât den nâŋgâbe. ");
INSERT INTO kpf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ka zen Mosegât den birâmŋâ nâgât den dabân nâŋgâbe?” ");
INSERT INTO kpf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesuŋâ den yatâ sâm naŋgâmŋâ Galilaia saru kutŋâ ŋâi Tiberia, zo walâm nâmbutken arip. ");
INSERT INTO kpf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ari a ambân doŋbepŋâ a sisi mâsek kubikziŋgi igâwegât molim âiwe. ");
INSERT INTO kpf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu zâk arâpŋâ nen diiniŋgi barin zâi tarâwen. ");
INSERT INTO kpf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Narâk zoren Yuda zeŋgât kendon patâ kutŋâ Pasowa, zo mâte oip. ");
INSERT INTO kpf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","A ambân doŋbep patâ gane Yesuŋâ ziŋgitŋâ Pilipo mâsikâm sâip, “Nalem ikâ gâbâ sâŋgân mem a ambân doŋbep patâ ziŋgindâ dâpziŋ upap?” ");
INSERT INTO kpf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu zâk zo yatâ zo upat sâm nâŋgi zei yen mâsikip. ");
INSERT INTO kpf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Oi Pilipoŋâ itâ sâm dukuip, “Kât 2 handeret yatâ zorâŋ kwâlâm ziŋgindâ mân dâpziŋ upap.” ");
INSERT INTO kpf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sâi arâpŋâ neŋgâren gâbâ a ŋâi kutŋâ Andrea, Simoŋ Peterogât munŋâ, zâkŋâ itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Katep ŋâi ziren ândiap. Zâkŋâ nalem bâtnâmbut sot saru zuu zagât tâkŋaŋgap. Oi a ambân doŋbep patâ zirâŋâ ziŋgindâ dâpziŋâ mân upap.” ");
INSERT INTO kpf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Sâi Yesuŋâ sâip, “A ambân dâzâŋgone mindum ge tatnek.” Oi zoren hibuk hân laŋgaat zeip, zorat kwâkŋan a teŋgâziŋ 5 tausen yatâ zorâŋ ge tarâwe. ");
INSERT INTO kpf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesuŋâ nalem zo memŋâ sâiwap sâm a tarâwe, zo kâsâpkum ziŋgip. Oi saru zuu zo yatik kâsâpkum ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nalem nem âkon opŋâ Yesuŋâ arâpŋâ itâ sâm dâtnâŋgoip, “Buputŋâ zen bâliŋ opapkât sândunek.” ");
INSERT INTO kpf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Oi nen nalem bâtnâmbut zorat buputŋâ sânduindâ irâ kiin zagât piksâip. ");
INSERT INTO kpf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","A amban zen sen mârât mân igikŋâ, zo ekŋâ sâwe, “Propete patâ a neŋgâren âsagibapkât sâsâŋ, zo perâkŋak a zi.” ");
INSERT INTO kpf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Oi zen Yesu haamgumŋâ bitziŋandâ gâsum a kutâ kwânâŋgânam utne ziŋgit nâŋgâm birâziŋgâm zikŋik barin zarip. ");
INSERT INTO kpf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mirâ ŋâtiksâisâi arâpŋâ nen saru sâtŋan geiwen. ");
INSERT INTO kpf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Geimŋâ Kapenaum kamânân âinam waŋgâyân zâiwen. Oi mirâ ŋâtiksâi ko ârindâ Yesu zâk zikŋik zoren tâip. ");
INSERT INTO kpf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Oi pibâ kâtikŋâ koi saru âbâŋgoi âiwen. ");
INSERT INTO kpf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Oi nen sak birâm kom aleindâ ari saru tânâmŋan ârindâ Yesu zâk saru kwâkŋan lâŋ lâŋ âim waŋgâ gootŋan gâi ekŋâ pârâkpam keŋgât urâwen. ");
INSERT INTO kpf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yatâ oindâ Yesuŋâ nâŋgonsâm sâip, “Ninak gaan. Mân keŋgât utnek.” ");
INSERT INTO kpf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yesu waŋgâyân kopgâbapkât sâtâre urâwen. Kopgâi zorenâk hân âinam sâwenân, zo âi takâwen. ");
INSERT INTO kpf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","A kâmut patâ, zen saru nâmbutken zine haŋsâip. Haŋsâi itâ sâwe, “Muka ŋâtiksâi waŋgâ kânok tâi iksen. Zoren arâpŋâ Yesu pam ziiŋik arie.” ");
INSERT INTO kpf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Zo yatâ nâŋgâm tatne Tiberia hânân gâbâ waŋgâ nâmbutŋâ Kembuŋâ nalem ziŋgip, zoren takâwe. ");
INSERT INTO kpf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Takâne a ambân zen Yesu sot arâpŋâ kâruziŋgâm waŋgâyân zâim Kapenaum kamânân âi kâruziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Zen saru nâmbutken âim kârum muyagemŋâ itâ sâm dukuwe, “Patâ, gâ dâuŋan zi gâin?” ");
INSERT INTO kpf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mâsikâne itâ sâm dâzâŋgoip, “Nâ perâkŋak sa nâŋgânek. Nâ top liku kulem tuuga ikme, zorat buŋâ. Nalem ziŋga nem âkon urâwe, zorat molinige. ");
INSERT INTO kpf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nalem nemŋâ ândim mumbi, zorat umziŋ mân pane zimbap. Nalem nem ândiândi kâtik ândibi, zorat umziŋ pane zimbap. A bonŋâ, nâ Anutu Ibânandâ nalem zo ziŋgâbatkât gâsum sâlâpnogip. Nâ ândiândi kâtikkât nalem, zo ziŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Sâi zen itâ mâburem dukuwe, “Sânan. Anutuŋâ wan nep tuum ândinatkât nâŋgâmap?” ");
INSERT INTO kpf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “A sâŋgonnogip, nâ nâŋgâm pâlâtâŋ kwatnibi, zo Anutugât nep.” ");
INSERT INTO kpf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Sâi den itâ sâm dukuwe, “Gâ top likuliku kulem ŋâi tuuna ekŋâ nâŋgâm pâlâtâŋ kwatginat. Wan nep ŋâi tuuban? ");
INSERT INTO kpf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sâkurâpniŋ, zen Mose sot mirâ kamân kâtikŋan ândim nalem kutŋâ Mana, zo nem ândiwe. Oi zorat den kulem ŋâi itâ ziap, ‘Sumbemân gâbâ nalem ziŋgi nem ândiwe.’” ");
INSERT INTO kpf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Oi Yesuŋâ itâ sâm dâzâŋgoip, “Perâkŋak sa nâŋgânek. Sumbemân gâbâ nalem bonŋâ, zo Moseŋâ mân muyagem ziŋgip. Ka Ibânandâ sumbemân gâbâ nalem bonŋâ ziŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nâ sumbemân gâbâ gem hân a ândiândi muyagem ziŋgâman. Nâ Anutugâren gâbâ nalem bonŋâ uan.” ");
INSERT INTO kpf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sâi itâ sâm dukuwe, “Kembu, gâ narâk dâp nalem zo niŋgâmâmban.” ");
INSERT INTO kpf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sâne itâ sâm dâzâŋgoip, “Ândiândigât nalem ko nâ. Ŋâi zâk nâgâren ga pâlâtâŋ upap, zâk nalemgât mân mumbap. Oi ŋâi zâk nâ nâŋgâm pâlâtâŋ kwatnibap, zo ko toogât mân nâŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nâ itâ dâzâŋguan. Zen nâ nekŋâ mân nâŋgâm pâlâtâŋ kwatnime. ");
INSERT INTO kpf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ka Ibânandâ nâgât siŋgi sâip, a ambân zo zen ko nâgâren gam naŋgâbi. Oi a ambân ziŋ nâgâren gane mân moliziŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sumbemân gâbâ gewan, zo ninâ den lubatkât buŋâ. Sâŋgonnogip, zâkkât den lubatkât gewan. ");
INSERT INTO kpf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ibânandâ a ambân nâgâren zâmbanmap, a zo zen tâmbetagobegât galemziŋ uandâ hângât narâk âkâbabân zoren hâlâluyâk mâŋgiziŋga zaatpi. Sâŋgonnogip, zâkkât den zo yatâ ziap. ");
INSERT INTO kpf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nanŋâ nâ nekŋâ nâŋgâm pâlâtâŋ kwatnibi, zo ko ândiândi kâtik ândibi. Ibânaŋgât den zo yatâ ziap. Oi nâŋâ narâk patin mâŋgiziŋga zaatpi.” ");
INSERT INTO kpf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesu zâk sumbemân gâbâ nalem bonŋâ, zo nâ sâipkât Yuda a sâtŋâ, ziŋâ nâŋgâm bâliŋ kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Oi itâ sâwe, “A zi zâk wangât itâ sap, ‘Nâ sumbemân gâbâ gewan.’ Topŋâ nâŋgâmen. Zâk Yesu, Yosepegât nanŋâ.” ");
INSERT INTO kpf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Sâne Yesuŋâ itâ dâzâŋgom sâip, “Zen mân nâŋgâne bâliŋ oik. ");
INSERT INTO kpf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","A ŋâi zik umgât nâgâren gâgaŋ, zo mân taap. Ibâ sâŋgonnogipŋâ sâi âlip nâgâren gâbap. Oi nâ a itâ zo narâk patin mumuŋan gâbâ mâŋgibat. ");
INSERT INTO kpf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Propete zeŋgât ekabân den itâ ziap, ‘Anutu zikŋak a siŋgi âlip dâzâŋgoi nâŋgâbi.’ Ŋâi zâk Ibânandâ siŋgi âlip dukui nâŋgâbap, zâk nâgâren gam târokwatnibap. ");
INSERT INTO kpf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","A zen Ibâ mân igâwe. Anutugâren gâbâ gem gâwan, nâ ninak Ibâ egâwan. ");
INSERT INTO kpf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nâ perâkŋak dâzâŋgua nâŋgânek. Ŋâi zâk nâŋgâm pâlâtâŋ kwatnimapŋâ ândiândi kâtik miap. ");
INSERT INTO kpf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ândiândi kâtikkât nalem nâ. ");
INSERT INTO kpf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Sâkurâpziŋâ, zen mirâ kamân kâtikŋan nalem kutŋâ Mana, zo nem ândimŋâ mom naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ka sumbemân gâbâ nalem nemŋâ mân mumuŋâ, zo ko nâgâren ziap. ");
INSERT INTO kpf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nâ sumbemân gâbâ ândiândigât nalem mem gewan. Nalem zo nâ. Zorat ŋâi zâk nâgâren gâbâ nalem zo nem ândiândi kâtikŋaŋgât siŋgi upi. Sâknandâ nalem uap. Zo a ziŋâ ândiândi muyagibigât ziŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yuda a sâtŋâ ziiŋak itâ âragumŋâ sâwe, “A zirâŋâ dap op sunumŋâ niŋgi ninatkât sap?” ");
INSERT INTO kpf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Nâ perâkŋak dâzâŋguan. Zen a bonŋâ nâgât sunum sot gilâm mân nimbi, zo ko umziŋan ândiândi mân muyagibap. ");
INSERT INTO kpf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ŋâi zâk nâgât sunumnâ sot gilâmnâ nimbapŋâ ândiândi kâtik mimbap. Oi narâk patin mumuŋan gâbâ mâgia zaatpap. ");
INSERT INTO kpf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nâgât sunumnâ, zo nalem bonŋâ. Nâgât gilâmnâ, zo too bonŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ŋâi zâk nâgât sunum sot gilâm nimbapŋâ, zâk nâ sot pâlâtâŋ op ândibap. Oi nâ zâk sot pâlâtâŋ op ândibat. ");
INSERT INTO kpf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ândiândi mariŋâ, Anutu Ibâ, zâkŋâ sâŋgonnogi gewangât Ibânaŋgât op ândiman. Oi ŋâi zâk nâ ninibapŋâ nâgât op ândiândiŋ muyagem ândibap. Umŋandâ nâ sot pâlâtâŋ upapŋâ sumbemgât siŋgi upap. ");
INSERT INTO kpf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sumbemân gâbâ nalem, zorat topŋâ itâ ziap. Sâkurâpziŋ Mana nalem niwe, zo yatâ buŋâ. Zen nemŋâ ândim muwe. Kâ nâgâren gâbâ nalem zo nimbap, zâk ândim zâimâmbap.” ");
INSERT INTO kpf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu zâk Kapenaum kamânân mâpâmâpâse namin ândim den zo dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesugât a ambârâpŋâ, neŋgâren gâbâ doŋbepŋâ den zo nâŋgâm sâwe, “Den zi nâŋgindâ yâmbâtŋâ uap. Den zirat topŋâ dap yatâ nâŋgânat?” ");
INSERT INTO kpf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Oi sâm âkon utne Yesuŋâ umziŋan ek nâŋgâm itâ sâm dâzâŋgoip, “Den zi nâŋgâne bâliŋ uap? ");
INSERT INTO kpf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A bonŋâ nâ âburem ândiwanân zaria nâŋgâne dap upap? ");
INSERT INTO kpf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sâkkât sunum zorâŋ ândiândi muyagemap, zo mân ziap. Ândiândi muyagemap, zo Kaapumgât nep. Den dâzâŋguan, zo Kaapum sot ândiândigât den. ");
INSERT INTO kpf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Oi zeŋgâren gâbâ a nâmbutŋandâ mân nâŋgâm pâlâtâŋ kwatnime.” A Yesugât den birâbi, zo kânŋan nâŋgip. Oi a Yesu tirâpzâŋgoi gâsum kumbi, zo yatik kânŋan nâŋgip. Zorat den yatâ dâtnâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Oi den ŋâi itâ târokwap sâip, “Zorat itâ dâzâŋguan. Ibânandâ a ŋâi imbaŋâ mân pindi ko dap op nâgâren gam nâ sot pâlâtâŋ upap? Yatâ zo mân taap.” ");
INSERT INTO kpf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Narâk zoren a ambân kâmut gakârâpŋâ, neŋgâren gâbâ doŋbepŋâ zâk sot ândiândiŋaŋgât âkon op birâŋaŋgâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yatâ utne Yesuŋâ arâp kiin zagât itâ sâm mâsikâniŋgip. “Zen yatik nâbam âinam se?” ");
INSERT INTO kpf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sâi Simoŋ Peteroŋâ itâ sâm dukuip, “Kembu, nen gâ birâgim ŋâigâren âinat? Gâ kânokŋâ ândiândi kâtikkât den mem ândiat. ");
INSERT INTO kpf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nen gâ nâŋgâm pâlâtâŋ kwatgimŋâ itâ nâŋgâmen. Gâ tirik a. Anutugâren gâbâ gâin.” ");
INSERT INTO kpf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yatâ sâi Yesuŋâ itâ sâm dâtnâŋgoip, “Nâ a kiin zagât, zen gâsum sâlâpzâŋgowan. Oi dap yatâ zeŋgâren gâbâ a ŋâiŋâ Sataŋgât a uap?” ");
INSERT INTO kpf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Zâk Yuda, Simoŋgât nanŋâ, Karioto kamânân gok, zâkkât nâŋgâm sâip. Yuda zâk arâp kiin zagât neŋgât kâmurân gokŋâ. Oi zâkŋâ ândim Yesu tirâpzâŋgoi kâsarâpŋâ ziŋ gâsum kuwe. ");
INSERT INTO kpf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kwâkŋan Yerusalem kamânân Yuda a sâtŋâ ziŋâ Yesu kunam den sâne Yesuŋâ zorat siŋgi nâŋgâm Yudaia hân birâm Galilaia hânân âim gam ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yatâ oi Yuda zeŋgât hâmbâ silep kendon mâte oip. ");
INSERT INTO kpf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesu murâpŋâ, ziŋ itâ dukuwe, “Gâ hân zi birâm Yudaia hânân âimŋâ kulem top top tuumat, zo ândi âi tuuna kâmut gakârâpkâ ziŋ ikpi. ");
INSERT INTO kpf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","A ŋâi, zâk patâ upâ sâm nepŋâ tik mân tuumap. A mâteziŋan tuumap. Gâ nep zo yatâ tuubat sâmatkât âi a kâmurân nep tuuna ikpi.” ");
INSERT INTO kpf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Murâpŋâ zen mân nâŋgâm pâlâtâŋ kwâkŋaŋgâm yatâ sâwe. ");
INSERT INTO kpf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Narâk ziren zo mo zo utnâ sâm âlip upi. Ka nâgât narâk ko gâtâm mâte upap. ");
INSERT INTO kpf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","A ziŋâ zen um kâlak mân nâŋgâziŋgâbi. Nâ ko ândi mâmanziŋ bâliŋâ, zo sapsuga um kâlak nâŋgânige. ");
INSERT INTO kpf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Zen ziiŋik kendonân zâinek. Narâknâ mân mâte uap. Narâk ziren mân zâibat.” ");
INSERT INTO kpf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yatâ sâmŋâ Galilaia hânân ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu murâpŋâ, zen kândom âinetâ bet zâk zikŋik Galilaia hân birâm Yerusalem kamânân tigâk zarip. ");
INSERT INTO kpf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Oi kendon narâk oi Yuda a zen Yesu kârumŋâ mâsikâyaŋgâm sâwe, “Zâk ikâ taap?” ");
INSERT INTO kpf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A yenŋandâ zâkkât den halop doŋbep sâwe. Oi nâmbutŋandâ itâ sawe, “Zâk a âlipŋâ.” Sâne nâmbutŋandâ kwâkâm sâwe, “Buŋâ. Zâk a um gulip kwatziŋgâmap.” ");
INSERT INTO kpf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Oi Yuda a sâtŋâ zeŋgât keŋgât op Yesugât siŋgi den muyap mân sâwe. ");
INSERT INTO kpf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kendon tânâmŋan Yesu zâk tirik namin zâimŋâ a Kembugât den sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Den yatâ sâi Yuda a zen imbaŋâziŋ buŋ oi itâ sâwe, “Zâk ekap namin mân zaripŋâ den topŋâ zi ikâ gâbâ nâŋgâm sap?” ");
INSERT INTO kpf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yatâ sânetâ Yesuŋâ itâ dâzâŋgom sâip, “Nâ den dâzâŋgoman, zo ninan gâbâ buŋâ. Sâŋgonnogip, zâkkât den. ");
INSERT INTO kpf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Den Anutugâren gâbâ mo ninan gâbâ, zo Anutu sâtŋâ lubapŋâ den zirât topŋâ nâŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ŋâi zâk zik umgât sâbap, zâk sâkŋâ mem zâizâiŋ upap. Ka ŋâi zâk nep mariŋaŋgât sâtâre muyagibapkât nep tuubap, zâkkât itâ nâŋgâbi, ‘Zâk sarâ buŋâ. Den bonŋâ sâmap.’ Oi nâ zo yatâ sâman. ");
INSERT INTO kpf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moseŋâ gurmin den sâm muyagem ziŋgip. Oi zen gurumin den zo mân lum kwâtâtime. Yatâ opŋâ zen wangât nâgât denân kwap sâm nonam se.” ");
INSERT INTO kpf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Sâi a zen itâ sâwe, “A ikâ zorâŋ gobigât se? Gâgât itâ nâŋgen. Gâ wâkegoot ândim um gulip op sat.” ");
INSERT INTO kpf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Sâne Yesuŋâ dâzâŋgom sâip. “Nâ nep kânok tuuga, zo ek pârâkpam kwakmak ue. ");
INSERT INTO kpf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sa nâŋgânek. Moseŋâ narâpziŋ kwabâ kwatziŋgâbigât sâm ziŋgip. (Oi zo Moseŋâ mân topkwâip. Sâkurâpniŋandâ mârum ŋâi topkwarâwe.) Oi nep zo tuutuuŋâ mâte oi kendonân tuume. ");
INSERT INTO kpf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mosegât gurumin den, zo birânetâ bon buŋ opapkât kendonân narâpziŋ kwabâ kwatziŋgâme. Nâ ko kendonân a kiŋ bik mumuŋ sâkŋâ kubiksa âlip uap, zorat wangât kuk otnige? ");
INSERT INTO kpf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Zen den sâkŋik mân sânek. Nâŋgâm sâlâpkum ko bonŋâ sâbi.” ");
INSERT INTO kpf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusalem kamân mâirâp nâmbutŋandâ itâ sâwe, “A kunam sâme, zo zirâ mo? ");
INSERT INTO kpf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Zâk a ambân mâteziŋan zi den muyap sâi patârâpniŋandâ mân sâm kwâkâme. Zen topŋâ nâŋgâne a bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, zo mo dap? ");
INSERT INTO kpf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Buŋâ motŋâi. A zirat muyamuyagiŋaŋgât topŋâ nâŋgen. Ka ŋâi gâbâpkât sâsâŋ, zo âsagei zâkkât topŋâ mân nâŋgânat.” ");
INSERT INTO kpf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yatâ sâne Yesuŋâ tirik namin kin den patâ itâ sâm dâzâŋgoip, “Ikâ gâbâ gâwan, zo âlip nâŋgen sâme. Ka nâ ninâ umgât mân gewan. Bonŋâ mariŋâ, Anutu, zâkŋâ sâŋgonnogi gem gâwan. Oi zen zâk mân ek nâŋgâme. ");
INSERT INTO kpf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nâ ko zâkŋâ sâŋgonnogi zik um topŋan gâbâ gewan, gât ko nâŋâ zâkkât topŋâ nâŋgâm kwâtâtian.” ");
INSERT INTO kpf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yesu zâk den yatâ sâi tâk namin pânam sâwe. Oi kukuŋaŋgât narâkŋâ, zo mân mâte oipkât yâmbârem birâwe. ");
INSERT INTO kpf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Oi a yenŋâ zeŋgâren gâbâ doŋbepŋâ Yesu nâŋgâm pâlâtâŋ kwarâwe. Oi itâ sâwe, “A patâ gâbapkât sâsâŋ, zâk a zirâŋ kulem tuumap, zo walâm tuubap? Buŋâ. A zi aksik tuum naŋgâmap.” ");
INSERT INTO kpf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","A zen den yatâ zo tik sâne Parisaio zen nâŋgamŋâ tirik namâ galem a sot âragumŋâ kâwali a zen Yesu gâsum tâk namin pambigât sâŋgonzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesuŋâ itâ dâzâŋgom sâip, “Nâ narâk pâŋkânok zen sot ândimŋâ sâŋgonnogip, zâkkâren zâibat. ");
INSERT INTO kpf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Oi zen kârunim mân muyagenibi. Âi ândibarân dap op gabi?” ");
INSERT INTO kpf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yatâ sâi Yuda a zen itâ sâm âraguwe, “A zirâŋ ikâ ari kârunatkât sap. Yuda a bukurâpniŋ Grik a hân toren toren zen sot ândie, zeŋgâren âibam sap? Mo zâk Grik a zeŋgâren âim den dâzâŋgobam sap? ");
INSERT INTO kpf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Kârunim âim mân muyagenibi. Âibarân zen mân gabi.’ Den zo wangât sap?” ");
INSERT INTO kpf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yuda zeŋgât kendon sirâm boiŋâ mindumindu patâ utne Yesuŋâ zaat kin den patâ dâzâŋgom sâip, “Ŋâi zâk toogât nâŋgâmŋâ nâgâren ga nimbap. ");
INSERT INTO kpf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Oi ŋâi zâk nâ nâŋgâm pâlâtâŋ kwatnibap, zâkkât umŋan too sinŋâ takâm zimbap. Kembugât ekabân den yatâ kulemgune ziap.” ");
INSERT INTO kpf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu nâŋgâm pâlâtâŋ kwâkŋaŋgâwen, nen Kaapumgât siŋgi kwatniŋgâm yatâ sâip. Yesu zâk narâk zoren Kaapumŋâ mân niŋgip. Wangât, zâk sumbem âsakŋâ umŋan mân âburem zârip, zorat mân niŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","A nâmbutŋâ zen den zo nâŋgâm Yesugât itâ sâwe, “Perâkŋak, zâk Propete gâbapkât mârum sâsâŋ.” ");
INSERT INTO kpf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nâmbutŋandâ itâ sâwe, “A bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, Kristo, zi zâk.” Nâmbutŋandâ ko kwâkâm sâwe, “A patâ zo, zâk dap op Galilaia hânân muyagibap? ");
INSERT INTO kpf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kembugât ekabân den ŋâi itâ ziap. Kristo zâk a kutâ Dawidigât kamân, Betelem, zoren âsagibap.” ");
INSERT INTO kpf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","A zen Yesugât yatâ sâm kâsâpagowe. ");
INSERT INTO kpf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Oi nâmbutŋandâ tâk namin pânat sâm yâmbârem birâwe. ");
INSERT INTO kpf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kâwali a zen tirik namâ galem a sot Parisaio zeŋgâren âburinetâ itâ sâwe, “Zen wangât Yesu mân gâsum diim ge?” ");
INSERT INTO kpf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sâne kâwali a ziŋâ sâwe, “Zâk den sâmap, zo yatâ a ŋâiŋâ mân sâmap.” ");
INSERT INTO kpf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sâne Parisaio a ziŋ itâ sâm dâzâŋgowe, “Zen a yenŋâ yatik um gulip kwatziŋgap? ");
INSERT INTO kpf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","A sâtŋâ sot Parisaio a, neŋgâren gâbâ ŋâi zâk sot pâlâtâŋ uap? ");
INSERT INTO kpf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Zo buŋâ. A yenŋâ, zen ko Kembugât gurumin den mân nâŋgâme, zen simgât siŋgi.” ");
INSERT INTO kpf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Yatâ sânetâ bukuziŋâ ŋâi kutŋâ Nikodemo, mârum Yesugâren arip, zâkŋâ itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“A ŋâiŋâ zikŋâ topŋâ mân sâi dap yatâ hâuŋaŋgât den sâm kwâkânat? Nen yatâ mân utnatkât gurumin den ekabân den ŋâi ziap.” ");
INSERT INTO kpf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Yatâ sâi ko bukurâpŋandâ Nikodemo den kârâpŋoot itâ sâm dukuwe, “Gâ a zo yatik Galilaia hânân gokŋâ? Kembugât ekabân sâlâpkum itâ nâŋgâban, ‘Galilaia hânân Propete ŋâi mân âsagibap.’” ");
INSERT INTO kpf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Oi zen kâsâpagom mirâziŋan âim naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesuŋâ Oliwa bâkŋan zâi zeip. ");
INSERT INTO kpf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mirâ haŋsâi zobâ âburem tirik namin zari a ambân doŋbepŋâ zâkkâren minduwe. Yesuŋâ ge tapŋâ Kembugât den sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Oi Kembugât gurumin den zorat galem a sot Parisaio a, zen mâtâp ambân ŋâi a sot ândei muyagem diim Yesugâren gam pam haamgum kin sâwe, ");
INSERT INTO kpf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Patâ, ambân zi a laŋ zen sot ândei muyagem gâsum diim gen. ");
INSERT INTO kpf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Oi Mose zâk ambân itâ zo kâtŋâ zâŋgone mumbigât sâm gurumin den ekabân kulemgum niŋgip. Oi gâŋâ ambân zâkkât dap nâŋgat?” ");
INSERT INTO kpf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Zo yatâ mâsikâne den dap mo dap sâi nâŋgâm denân pânam sâwe. Sâne Yesu zâk pindiŋsâm bikŋandâ hânân kulemgum tâip. ");
INSERT INTO kpf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kulemgum tâi mâsikâm zagât zagât utnetâ zaatŋâ itâ sâm dâzâŋgoip, “Zeŋgâren gâbâ a ŋâi tosaŋâ buŋâ, zâkŋâ kâtŋâ topkwap koi ko kumbi.” ");
INSERT INTO kpf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yatâ sâm du pindiŋsâm hânân kulemgum tâip. ");
INSERT INTO kpf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","A gawe, zen den zo nâŋgâm patâziŋâ kândom ari kânok kânok ari ari âim naŋgâwe. Ambân zâk zikŋik Yesugât mâteŋan kiri Yesu zâk oksâm zaat mâsikâm sâip. ");
INSERT INTO kpf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","“Ambân, a zen ikâ arie? Ŋâiŋâ hâuŋaŋgât den sâm siŋgan giap?” ");
INSERT INTO kpf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Sâi ambânŋâ sâip, “Kembu, buŋâ.” Sâi itâ sâm dukuip, “Nâ yatigâk, nâ gâ mân sâm siŋgan gian. Zorat gâ âi ândim bâliŋâ du zagât mân upan.” ");
INSERT INTO kpf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesuŋâ a den dum dâzâŋgoip. Itâ sâm dâzâŋgoip, “Hân dâp a zeŋgât kârâp âsakŋâ op ândian. Oi ŋâi zâk nâ molinibapŋâ, zâk ŋâtâtigân mân ândibap. Zâk ândiândi âsakŋâ tâkŋaŋgi ândibap.” ");
INSERT INTO kpf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sâi Parisaio a ziŋâ itâ sâm dukuwe, “Gâ gikak topkâ sâm muyagiat, zorat nâŋgindâ bon mân uap.” ");
INSERT INTO kpf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sâne Yesuŋâ sâip, “Ninak topnâ sapsuga bon buŋ mân opmap. Wangât, Nâ ikâ gâbâ gâwan sot ikâ âi ândibat, zorat topŋâ nâŋgâm den sâman. Zen ko zo mo zorat ârândâŋ kwakme. ");
INSERT INTO kpf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Zen sâkŋik ekŋâ umŋan bonŋâ zo mân ikme. Oi zen laŋ sâme. Nâŋâ ko zeŋgât topziŋ mân sâman. ");
INSERT INTO kpf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Oi zeŋgât topziŋ sâbat, zo ko bonŋâ upap. Nep zo ninik mân tuubat. Ibâ sâŋgonnogip, zâkŋâ betnan mei nep zo tuubat. ");
INSERT INTO kpf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Zeŋgât gurumin den ekabân den ŋâi itâ ziap, ‘A zagât, zikŋâ a ŋâigât topŋâ sâitâ nâŋgâne bon upap.’ ");
INSERT INTO kpf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nâ ninâ topnâ sâm muyagia Ibânâ sâŋgonnogip, zâkoot yatik sâm muyagemap.” ");
INSERT INTO kpf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yesu zâk den yatâ sâi mâsikâm sâwe, “Ibâgâ ikâ?” Sânetâ itâ sâm dâzâŋgoip, “Zen nâgât topnâ mân nâŋgâme. Zen nâgât topnâ nâŋgâm sâi ko Ibânaŋgât topŋâ yatik nâŋgâbe.” ");
INSERT INTO kpf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuŋâ den zo tirik namâ umŋâ ŋâi kât pâpanŋan, zoren kin den dâzâŋgoip. Oi zâk mumbapkât narâkŋâ mân mâte oipkât dabân gâsum tâk namin kek pambe? ");
INSERT INTO kpf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu zâk den târokwapŋâ itâ sâm dâzâŋgoip, “Nâ zâmbam aria zen kârunimŋâ tosaziŋoot ândim mumbi. Nâ âibat, zoren zen dap op gabi?” ");
INSERT INTO kpf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Zo yatâ sâi ko Yuda a ziŋâ sâwe, “Nâ âi ândia zen mân gabi, den zo wangât sap? Zâk zikŋâ agoyaŋgâm mumbapkât sap?” ");
INSERT INTO kpf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sânetâ Yesuŋâ itâ sâm dâzâŋgoip, “Zen âmbiren gokŋâ. Nâ ko uren gokŋâ. Zen hân ziren gokŋâ. Nâ ko hân zi gokŋâ buŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nâ zorat opŋâ dâzâŋguan, Zen tosaziŋoot ândim mumbi. Nâ ândim gâwanŋâ ândim zâibat. Zen zo mân nâŋgâm simbitkubi, zo ko tosaziŋ zemziŋgi mumbi.” ");
INSERT INTO kpf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sâi ziŋâ mâsikâm sâwe, “Bâi, gâ wan a ŋâi?” Sâne Yesuŋâ dâzâŋgom sâip. “Topnâ dâzâŋgom gâwan, zo bonŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nâ zeŋgât tosa sot hâuŋaŋgât den doŋbep mem ândian. Sâŋgonnogipŋâ den bonŋâ sâmap. Oi nâ den zâkkâren nâŋgâwan, zorigâk a ambân dâzâŋgoman.” ");
INSERT INTO kpf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Den zo Ibâŋaŋgât op sâm dâzâŋgoi zen mân nâŋgâm kwâtâtiwe. ");
INSERT INTO kpf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sâmŋâ Yesuŋâ târokwap itâ dâzâŋgom sâip. “Zen a bonŋâ nâ nagân mândânibi, narâk zoren topnâ nâŋgâm biraŋbi. Oi ninâ umgât kut ŋâi ŋâi mân opman. Ibânandâ den sâm dâtnogip, zorik sâman, zo nâŋgâm kwâtâtibi. ");
INSERT INTO kpf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Oi sâŋgonnogip, zâk nâ sot ândiap. Nâ kut ŋâi ŋâi opman, zo egi âlip opmap, zo ko zâk mân birânimap.” ");
INSERT INTO kpf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu zâk den yatâ sâi a doŋbepŋâ nâŋgâmŋâ, nâŋgâm pâlâtâŋ kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesuŋâ Yuda a nâŋgâm pâlâtâŋ kwâkŋaŋgâwe, zen itâ sâm dâzâŋgoip, “Zen nâgât den lum ândim arâpnâ bonŋâ upi. ");
INSERT INTO kpf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Opŋâ nâgât den bonŋâ, zo nâŋgâne mâkâziŋgi dumunziŋ buŋâ, hâlâluyâk ândibi.” ");
INSERT INTO kpf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yesuŋâ yatâ sâi zen itâ mâburem dukuwe, “Nen Abaramgât kiurâp. Nen a zeŋgât kore mân op ândiwen, zorat wangât sat? ‘Dumun buŋ ândibi.’” ");
INSERT INTO kpf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Nâ perâkŋak dâzâŋguan. Ŋâi zâk bâliŋ opmap, zâk bâliŋaŋgât kore a upap. ");
INSERT INTO kpf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kore a, ziŋâ patâziŋaŋgât mirin tâtat mâme mân upi. Narâpŋâ ko Ibâgât mirinâk ândim zâimambi. ");
INSERT INTO kpf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Zorat nâ nanŋandâ olaŋziŋga, zen perâkŋak dumum buŋ ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Zen Abaramgât kiurâp, zo nâŋgan. Oi zen nâgât denŋâ umziŋan mân giari nonam se. ");
INSERT INTO kpf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nâ Ibânaŋgâren kut ŋâi ŋâi ek ândiwan, zorat sâman. Zen ko ibâziŋaŋgâren kut ŋâi ŋâi nâŋgâwe, zo upme.” ");
INSERT INTO kpf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Sâi itâ sâm dukuwe, “Nen sâkuniŋ Abaram.” Sâne Yesuŋâ dâzâŋgoip, “Zen Abaramgât kiun ândim sâi zâkkât orot mâme yatâ upe. ");
INSERT INTO kpf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Anutugâren gâbâ den bonŋâ nâŋgâwan, zo dâzâŋgoman. Oi ziŋâ nonam se. Kut zo yatâ zo Abaramŋâ mân oip. Zen Abaramgât narâpŋâ buŋâ. Ibâziŋâ, zâk ŋâi. ");
INSERT INTO kpf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Zen ibâziŋaŋgât orot mâme upme.” Yatâ sâi ziŋâ sâwe, “Nen a laŋân gâbâ mân âsagiwen. Ibâniŋ Anutu kânok.” ");
INSERT INTO kpf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sâne Yesuŋâ sâip, “Ibâziŋ Anutu sâi ko nâ buku otnibe. Nâ Anutugâren gâbâ gewan. Ninâ umgât mân gewan. Zâkŋâ sâŋgonnogi gewan. ");
INSERT INTO kpf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Zen dap op ândine dinnandâ umziŋan mân geimap? Nâ den sa zen kindapziŋ aŋgân kârâme, zorat ko yatâ upme. ");
INSERT INTO kpf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Zen ibâziŋ Sataŋ. Zâkkât den lubigât umziŋ kinmap. Zâk mârum ŋâi a tâmbetagoagoŋ nep tuum ândim gaap. Zâk den bonŋâ kândâtkoipkât umŋan den bonŋâ ŋâi mân ziap. Zâk sarâ a sot sarâ mariŋâ. Zorat zâkkât orot mâmeŋâ zo sarâ opmap. Zen zo yatik umziŋan den bonŋâ mân gei ziap. ");
INSERT INTO kpf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Zorat nâ den bonŋâ dâzâŋgua dinnâ birâme. ");
INSERT INTO kpf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Zeŋgâren gâbâ a ŋâi nâgât tosa âlip sâbap? Buŋâ. Nâ den bonŋâ sâman. Zen wangât nâgât dinnâ birâme? ");
INSERT INTO kpf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ŋâi zâk Anutugât siŋgi upapŋâ diŋâ nâŋgâbap. Zen Anutugât siŋgi mân ândimeŋâ diŋâ birâme.” ");
INSERT INTO kpf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sâi Yuda a sâtŋâ, ziŋ kuk op itâ sâm bâliŋ kwâkŋaŋgâwe, “Nen gâgât dap sânat? Gâ neŋgât kâmurân gok buŋa. Gâ Samaria a. Wâkeŋâ umgan giari ândiat. ");
INSERT INTO kpf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Gâgât topkâ yatâ sâindâ dâp upap.” Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Nâ wâkeŋâ mân otnimap. Nâ Ibânâ sâm bâbâlaŋ kwâkŋaŋgâman. Zen ko nâ mem ge kwatnige. ");
INSERT INTO kpf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nâ kutsiŋginaŋgât opŋâ mân dâzâŋgowan. Kutsiŋginaŋgât den dâzâŋgobap, zo ŋâi ândiap. Zâkŋâ nâgât kutsiŋgi, zo mem zâi pâmbap. ");
INSERT INTO kpf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nâ perâkŋak dâzâŋgua nâŋgânek. Ŋâi zâk nâgât den mem ândiap, zo mân mumbap.” ");
INSERT INTO kpf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yatâ sâi Yuda a ziŋâ itâ sâwe, “Wâkeŋâ otgimap, zo perâkŋak. Abaram moip. Oi Propete zen yatigâk muwe. Oi gâ itâ sat, ‘Ŋâi zâk nâgât den mem ândibapŋâ mân mumbap.’ ");
INSERT INTO kpf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Sâkuniŋâ Abaram, zâk patâ moip. Oi gâ zâk walâbam sat? Oi Propete a, zen yatâ muwe. Gâ wangât sâkkâ mem zâi paat?” ");
INSERT INTO kpf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Ninak sâknâ mem zâi pa sâi ko bon buŋ opap. Ibânâ ândiap, zâkkât Anutuniŋ sâme, zâkŋâ kutsiŋginâ mem zâi pâmap. ");
INSERT INTO kpf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Zen zâkkât topŋâ mân nâŋge. Nâŋâ ko zâkkât topŋâ nâŋgâm kwâtâtian. Nâ mân ek nâŋgan sa sâi ko a sarâ zen yatâ opap. Nâ zâk nâŋgâŋâŋgan. Oi zâkkât diŋâ mem ândiman. ");
INSERT INTO kpf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Sâkunziŋâ Abaram, zâk nâgât narâk mâte oi ikpapkât sâtâre op ândeip. Zorâŋâ ândim muyagia sâtâre pâtâ oip.” ");
INSERT INTO kpf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yatâ sâi Yuda a ziŋ sâwe, “Gâ kendongâ 50 mân ândeinŋâ Abaram egâwan sat?” ");
INSERT INTO kpf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Nâ perâkŋak dâzâŋgobâ. Nâ Abaram mân âsagei ândiwanŋâ ândim gaan.” ");
INSERT INTO kpf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yatâ sâi Anutu hutkum sap sâm kâtŋâ mem kunâ sâne Yesuŋâ tikpam tirik namin gâbâ geip. ");
INSERT INTO kpf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu zâk mâtâbân âim sen ŋâtâtik a ŋâi muyageip. A zo mam kâmboŋan gâbâ âsagem sen ŋâtâtik op ândim gâip. ");
INSERT INTO kpf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yesuŋâ a zo muyagei arâpŋâ niŋ Yesu mâsikâm sâwen, “Patâ, ŋâigât tosagât yatâ muyageip? Zikŋâ mo ibâ mam zekât?” ");
INSERT INTO kpf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Sâindâ Yesuŋâ itâ sâm dâtnâŋgoip, “Yatâ buŋâ. Zikŋâ mo ibâ mam zekât tosagât buŋâ. Anutu imbaŋâŋaŋgât topŋâ zâkkâren muyagibapkât yatâ âsageip. ");
INSERT INTO kpf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sirâmân nep tuumen. Kâ ŋâtiksâi ko nep mân tuumen. Narâk zi sirâm yatâ oi sâŋgonnogip, zâkkât nep âlip tuum ândinat. Kwâkŋan ŋâtâtik muyagei nep zo dap dap yatâ tuubi? ");
INSERT INTO kpf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nâ hânân ândibat dâp hân a zeŋgât âsakŋâ op ândibat.” ");
INSERT INTO kpf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu zâk yatâ sâmŋâ hânân tâpkum hân baŋet mem golaŋkum sen ŋâtâtik zo siŋan saŋgorip. ");
INSERT INTO kpf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Itâ sâm saŋgorip, “Gâ Siloam too deŋgânân âi too saŋgonnan.” (Siloam zo Yuda denân. Niiŋ denân ko sâŋgongoip sâmen.) ");
INSERT INTO kpf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yatâ opŋâ kamârâpŋâ ziŋâ a zo ekŋâ mâsikâyaŋgâm sâwe, “Nalemgât oletniŋgâmap, zi zâk mo ŋâi?” ");
INSERT INTO kpf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sâne nâmbutŋandâ sâwe, “Zi zâk.” Oi nâmbutŋândâ sâwe, “Zâk buŋâ. Zâkkât tobat yatâ a ŋâi.” Yatâ sâne zikŋak sâip, “Nâ ko zi.” ");
INSERT INTO kpf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Sâi mâsikâm sâwe, “Dap op siŋgâ âlip uap?” ");
INSERT INTO kpf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Sâne itâ sâm dâzâŋgoip, “A ŋâi kutŋâ Yesu, zâkŋâ hânân tâpkum hân baŋet mem golaŋkum sinnan saŋgonŋâ itâ sâm dâtnogip, ‘Gâ Siloam deŋgânân âi too sâŋgon.’ Oi nâ âi too saŋgonsa sinnâ âlip oi eksan.” ");
INSERT INTO kpf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yatâ sâi mâsikâm sâwe, “A zo ikâ ândiap?” Sâne zâkŋâ sâip, “Nâ mân ek nâŋgan.” ");
INSERT INTO kpf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","A sen ŋâtâtik op ândimŋâ âlip oip, zo diim Parisaio a zeŋgâren âiwe. ");
INSERT INTO kpf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Oi Yesuŋâ baŋet golaŋkum siŋâ saŋgorip, zo Yuda zeŋgât kendonân oip. ");
INSERT INTO kpf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Zorat Parisaio a, ziŋâ a zo mâsikâm sâwe, “Gâ dap op siŋgâ âlip uap?” Sâne itâ sâm dâzâŋgoip, “Zâk baŋet mem sinnan saŋgori nâ âi too saŋgonsa sinnâ âlip uap.” ");
INSERT INTO kpf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisaio zeŋgâren gâbâ nâmbutŋandâ itâ sâwe, “A zo Anutugâren gokŋâ buŋâ. Zâk Kembugât gurumin den kom mâtâp wâlap. Zâk kendonân nep tuugap.” Sâne nâmbutŋandâ sâwe, “Zâk bâliŋ mâme a ândim sâi nep itâ zo mân tuubap.” Parisaio a, ziŋ yatâ sâm âragum kâsâpagowe. ");
INSERT INTO kpf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Oi a siŋ bâpsâsâŋ kubigip, zo mâsikâm sâwe, “Siŋgâ kubiksap, zorat gâ dap nâŋgat?” Sâne zâkŋâ sâip, “Zâk Propete.” ");
INSERT INTO kpf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sâi Yuda a zen a zo sen ŋâtâtik ândimŋâ âlip oip, zorat nâŋgâne bonŋâ mân oi sâne ibâ mamŋâ, zet gawet. ");
INSERT INTO kpf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Gâitâ mâsikâzikâm sâwe, “Nanzikŋâ sen ŋâtâtik muyageip, zi mo? Zâk dap op siŋâ âlip uap?” ");
INSERT INTO kpf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Sâne ibâ mamŋâ, zik itâ sâwet, “Zâk nannikŋâ, zo nâŋget. Sen ŋâtâtik âsageip, zo nâŋget. ");
INSERT INTO kpf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ka dap opŋâ siŋâ âlip uap, zo mân nâŋget. Ŋâiŋâ kubiksap, zo mân nâŋget. Zâk katep buŋâ. Mârum lâmbarip, zorat ziiŋak mâsikâne topŋâ dâzâŋgoik.” ");
INSERT INTO kpf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ibâ mamŋâ, zet Yuda a sâtŋâ zeŋgât keŋgât opŋâ yatâ sâwet. Yuda a zeŋgât a sâtŋâ, ziŋ den itâ sâm ândiwe, “Ŋâi zâk Yesugât itâ sâbap, ‘A bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, zâk zo. Zâk Kristo.’ A yatâ zo mâpâmâpâse namin mân zâibapkât pâke pânat. A yatâ zo kâbakŋeŋaŋgindâ neŋgât kâmurân mân tâpap.” ");
INSERT INTO kpf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Zorat opŋâ ibâ mamŋâ zet keŋgât op itâ sâwet, “Zâk katep buŋâ. Zâk mârum lâmbarip, zorat ziŋâ mâsikâne topŋâ sâik.” ");
INSERT INTO kpf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","A sen ŋâtâtik op ândeipŋâ âlip oip, zo dum diim gamŋâ itâ dukuwe, “Anutu mâteŋan kin sarâ mân sâban. Nen a zorat topŋâ nâŋgen. Zâk bâliŋ mâme a.” ");
INSERT INTO kpf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yatâ sânetâ ko a zorâŋ itâ sâm dâzâŋgoip, “A zo bâliŋâ mo âlipŋâ, zo mân nâŋgan. Sen ŋâtâtik ândiwanŋâ sinnâ âlip uap, zo nâŋgan.” ");
INSERT INTO kpf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Sâi dum mâsikâwe, “Dap otgigap? Dap op siŋgâ mânâŋgâtsap?” ");
INSERT INTO kpf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Sâne a zorâŋâ itâ sâm dâzâŋgoip, “Nâ mârum dâzâŋguan. Zen wangât kisaŋâ dâzâŋgobatkât se? Zen zâkkât a utnam se?” ");
INSERT INTO kpf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yatâ sâi ziŋâ siŋan gem dukuwe, “Gâ zâkkât a. Nen ko Mosegât arâpŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mose zâk Anutuŋâ den dukuip, zo nâŋgen. Ka a zi ikâ mo ikâ gâbâ âsagem gâip, zo mân nâŋgen.” ");
INSERT INTO kpf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sâne a zorâŋ den itâ mâburem dâzâŋgoip, “A zi sinnâ mânâŋgâtsap, zâkkât topŋâ kârune nâŋga imbaŋâ uap. ");
INSERT INTO kpf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nen itâ nâŋgâmen, ‘Anutuŋâ bâliŋ mâme a mân betziŋan memap. Ŋâi zâk hurat kwâkŋaŋgâm diŋâ lugi bekŋan mimbap.’ ");
INSERT INTO kpf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mârum hân âsageibân gâbâ a ŋâi zâk mam kâmboŋan gâbâ sen ŋâtâtikŋâ âsagem kubikkubikŋâ mân âsagei nâŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Oi a zo Anutugâren gâbâ mân gâip sâi nep itâ zo dap yatâ tuubap?” ");
INSERT INTO kpf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Sâi den kârâpŋoot itâ sâm dukuwe, “Gâ bâliŋ mâme sot laŋ mâman a zeŋgâren gâbâ âsageinŋâ dap yatâ nen den topŋâ dâtnâŋguat?” Yatâ sâm kom kâbakŋine ârip. ");
INSERT INTO kpf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","A zo kâbakŋine ari Yesuŋâ nâŋgip. Oi a zo muyageŋaŋgâm itâ sâm mâsikip, “Gâ a bonŋâ nâŋgâm pâlâtâŋ kwâkŋaŋgat mo?” ");
INSERT INTO kpf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Sâi a zorâŋâ sâip, “Patâ, sat, zo a ŋâi? Zo tirâpnona ekŋâ nâŋgâm pâlâtâŋ kwâkŋaŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Sâi Yesuŋâ itâ sâm dukuip, “Gâ eksat. Den dâgogan, zo nâ.” ");
INSERT INTO kpf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sâi a zorâŋâ sâip, “Kembu, nâ nâŋgâm pâlâtâŋ kwatgigan.” Yatâ sâmŋâ um topŋan pindiŋsâm mâpâseip. ");
INSERT INTO kpf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Oi Yesuŋâ sâip, “Nâ topziŋ sâm muyagibatkât hânân gewan. Zorat a ziiŋaŋgât nâŋgâne gigiŋâ oi sinniŋ ŋâtâtik sâme, zen sinziŋ ânâŋgât âsakŋan bâgim ândibigât gem gâwan. Oi a ziiŋaŋgât nâŋgâne zâizâiŋ oi sinniŋ âlipŋik sâme, zen ŋâtâtigân bagim ândibigât gem gâwan.” ");
INSERT INTO kpf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yatâ sâi Parisaio a ârândâŋ kirâwe, zen nâŋgâmŋâ sâwe, “Nen sen ŋâtâtik nâŋgonsat?” ");
INSERT INTO kpf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Sâne Yesuŋâ sâip, “Zen sen ŋâtâtik ândim sâi tosaziŋ buŋ ândibe. Ka ziiŋak sâme, ‘Nen sinniŋ âlipŋâ.’ Zorat tosaziŋ zemziŋgap.” ");
INSERT INTO kpf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuŋâ den sumbuŋâ ŋâi itâ sâip, “Nâ perâkŋak dâzâŋgua nâŋgânek. Ŋâi zâk râma zeŋgât poŋ durubit zo birâm ŋâin gâbâ loŋgiŋ bagibap, zâk kâmbu a op kut ŋâi ŋâi laŋ memap. ");
INSERT INTO kpf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ŋâi zâk poŋ durubirân gâbik bagibap, zâk ko râma zeŋgât galem a. ");
INSERT INTO kpf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Zâk gâi mâtâp galem a ekŋâ mâtâp mem pâmbap. Oi râma ziŋâ diŋâ tobat nâŋgâbi. Oi râma galem a zo râma kutziŋan zâŋgonsâm poŋan gâbâ diiziŋgâm âibap. ");
INSERT INTO kpf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Râma gakârâpŋâ diiziŋgâm gei kândom ari molim âibi. Diŋ tobatŋâ nâŋgâmegât molim âibi. ");
INSERT INTO kpf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ka a ŋâi gâi diŋ tobatŋâ mân nâŋgâmŋâ mân molibi. Buŋâ. Zen keŋgât op birâm âibi.” ");
INSERT INTO kpf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuŋâ den sumbuŋâ yatâ sâi Yuda a ziŋ den zorat topŋâ mân nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yatâ utne Yesuŋâ dum dâzâŋgom sâip, “Perâkŋak dâzâŋgua nâŋgânek. Râma zeŋgât zâizâiŋaŋgât mâtâp, zo nâ. ");
INSERT INTO kpf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nâ mân âsagia âsagiwe, zo kâmbu a. Zen kut ŋâi ŋâi laŋ mime. Zen ganetâ râma zen zeŋgât den mân nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mâtâp nâ. Ŋâi zâk nâgâren gam bagibap, zâk mân tâmbetagobap. Zâk bagimgagim nalem muyagem nem ândibap. ");
INSERT INTO kpf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kâmbu a zen ga râma kâmbu mem zâŋgom tâmbetzâŋgobigât game. Nâ ko râma ziŋ ândim ândiândi âlip muyagem ândim kwâtâtibigât gâwan. ");
INSERT INTO kpf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nâ râma galem a âlipŋâ. Galem a zâk galem otziŋgâm ândim râma gakâŋâ tâmbetagobegât ândiândiŋâ birâbap. ");
INSERT INTO kpf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Râma galem a bâliŋâ, mariŋâ buŋâ, kât nep tuutuuŋaŋgât aŋâ dâŋ galemziŋ mân opmapŋâ wâu kâtikŋâ gâi zâmbam âibap. Oi wâu kâtikŋâ gamŋâ râma ziŋgâm molziŋgi siŋsururuŋ upi. ");
INSERT INTO kpf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A zo râma galem a bâliŋâ. Zâk râma zeŋgât girem mân upap. A zo kât mimbapkât nep tuumap. ");
INSERT INTO kpf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nâ ko râma galem a âlipŋâ ândiman. Ibâ sot nâ âŋak nâŋgâm ândimet. ");
INSERT INTO kpf_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Zorat dâp op nâ kâmurâpnâ zen sot âŋak ândimen. Zorat na râma zeŋgât opŋâ ândiândinâ birâbat. ");
INSERT INTO kpf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Oi râma kâmut ŋâin ŋâin ândie. Zen poŋ zi gokŋâ buŋâ. Oi ninak ârândâŋ diiziŋgâm ga dinnâ nâŋgâbi. Oi râma zen kâmut kânok sot galem a kânok yatâ muyagibap. ");
INSERT INTO kpf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Râma zeŋgât op ândiândinâ birâbat, zorat Ibânandâ umŋandâ gâsunimap. Nâ ândiândinâ birâmŋâ dum mimbat. ");
INSERT INTO kpf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ândiândinâ zo a ziŋ nonam dinnâ sâne mân birâbat. Buŋâ. Ninak nâŋgâm birâbat. Ninak birâbat sot mimbatkât imbaŋâ zemnigap. Yatâ upatkât op Ibânandâ sâm nigip.” ");
INSERT INTO kpf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu zâk yatâ sâip, zorat Yuda a zen nâŋgâm den sâm kâsâpagowe. ");
INSERT INTO kpf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Oi a doŋbepŋâ itâ sâwe, “Wâkeŋâ okŋaŋgi um gulip uap. Den sâi wangât nâŋge?” ");
INSERT INTO kpf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nâmbutŋandâ itâ sâwe, “A wâkeŋootŋâ ândim sâi den itâ mân sâbap. Mo wâke ŋâiŋâ a sen ŋâtâtik zen âlip kubikziŋgâbap?” ");
INSERT INTO kpf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yuda a ziŋ tirik namâŋ mârum mâsop miwe, zorat kendon narâkŋâ mâte oip. ");
INSERT INTO kpf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Map pateŋ narâkŋan mâte oip. Oi Yesu zâk tirik namin âim mindumindugât um patâ ŋâi kutŋâ Salomo, zoren âim gam kirip. ");
INSERT INTO kpf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Oi Yuda a ziŋ ekŋâ mindum haamgum kin itâ sâm dukuwe, “Gâ wangât topkâ kwâimbâna um zagât upmen? A bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, gâ a zo ândiat oi ko sâm muyagem dâtnâŋgo.” ");
INSERT INTO kpf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Nâ mârum sâm dâzâŋgua mân nâŋgâwe. Ibânaŋgât sâtkât nep tuuman, zorâŋ topnâ sâm muyagemap. ");
INSERT INTO kpf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ka zen nâgât râma mân op ândiegât dinnâ mân nâŋgâme. ");
INSERT INTO kpf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Râma gakânâ ândie, zen ziŋgit holiziŋ nâŋgâman. Oi ziŋâ dinnâ nâŋgâme. Dinnâ holiŋâ nâŋgâm mâtâbân molinime. ");
INSERT INTO kpf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Oi ândiândi kâtik muyagem ziŋga mân tâmbetagom ândim zâibi. Oi nâgât bitnan gâbâ a ŋâiŋâ mâkâmâkâŋ, zo mân taap. ");
INSERT INTO kpf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ibânandâ nâgâren zâmbarip, zâk a sot kut ŋâi ŋâi aksik walâziŋgâm ândiap. Oi ŋâiŋâ Ibânaŋgât bikŋan gâbâ mân mâkâbap. ");
INSERT INTO kpf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nâ sot Ibâ, net orot mâmenikŋâ kânogâk ziap.” ");
INSERT INTO kpf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yatâ sâi Yuda a ziŋ kât dum mem kunam urâwe. ");
INSERT INTO kpf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yatâ utnetâ Yesuŋâ itâ sâm dâzâŋgoip, “Nep âlipŋâ top topŋâ Ibânâ mam otnigi tuuga igâwe. Oi ikâ zorat op kâtŋâ nonam se?” ");
INSERT INTO kpf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Sâi Yuda a, ziŋâ sâtŋan mem itâ dukuwe, “Nep âlip tuumat, zorat buŋâ. Gâ ayâk ândiatŋâ Anutu hutkum gikaŋgât nâ Anutu sat. Zorat op gonam sen.” ");
INSERT INTO kpf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yatâ sâne Yesuŋâ itâ sâm dâzâŋgoip, “Kembugât gurumin den ekabân Kembugât den ŋâi itâ ziap. Zo sâlâpkum nâŋgâme mo buŋâ? Den zo itâ, ‘Nâŋâ sâwan, Zen Anutu yatâ.’ ");
INSERT INTO kpf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","(Oi Kembugât den kulem gulipkum ŋâi sâsâŋ, zo mân taap.) Anutugâren gâbâ den zeŋgâren gâip. Zeŋgât op zen Anutu yatâ sâip. ");
INSERT INTO kpf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Zorat zen wangât itâ se, ‘Gâ Anutu hutkum sat.’ Anutuŋâ gâsum sâlâpnom sâŋgonnogi gewan. Zorat op nâ Anutugât nanŋâ sa wangât zen den se? ");
INSERT INTO kpf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nep tuuman, zo iknetâ Ibânaŋgât dâp mân opmap oi ko birânim nâgât den zorat nâŋgâne bon buŋ oik. ");
INSERT INTO kpf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mo iknetâ Ibânaŋgât dâp uap, zo ko dinnaŋgât buŋâ, nepnaŋgât opŋâ itâ nâŋgâbi. Ibânandâ nâ sot tâpmap. Oi nâ zâkkâren gâbâ gewan, zorat topŋâ nâŋgâbi.” ");
INSERT INTO kpf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesuŋâ den yatâ sâi ko tâk namin pânam dum sâne birâziŋgâm arip. ");
INSERT INTO kpf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Birâziŋgâmŋâ Yodaŋ too nâmbutken Yohaneŋâ mârumŋan too saŋgonziŋgâm ândeip, zoren âi ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Zoren âi ândei a doŋbep patâ ziŋ Yesugâren ga mindum itâ sâwe, “Yohane zâk sen mârât top top, zo mân tuugip. Ka gâgât den sâip, zo bon op naŋgap.” Oi zoren a ambân doŋbepŋâ Yesu nâŋgâm pâlâtâŋ kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","(-) ");
INSERT INTO kpf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania kamânân a ŋâi ândeip, kutŋâ Lasaro. Zâk sot ponâzatŋâ Maria sot Mata, zen kamân zo gokŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariaŋâ mârum Kembu too wârânŋâ âlipŋâ zorâŋ saŋgon ko kâuk sâmotŋandâ kiŋâ sâŋgori âronŋâ oip. Zâkkât munŋâ Lasaro, zâk mâsek op zeip. ");
INSERT INTO kpf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mâsek op zei ponâzatŋâ zet Yesugâren den itâ sâm pâitâ arip, “Kembu, gâ nâŋgâ. Umgandâ gâsumap, a zo mâsek op ziap.” ");
INSERT INTO kpf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Den zo pâitâ ari Yesuŋâ nâŋgâmŋâ itâ sâip, “Mâsek zorat bonŋâ mumbapkât buŋâ. Anutu sâm âlip kwâkŋaŋgâbigât âsagiap. Anutu nanŋâ nâgât imbaŋâ âsagei ekŋâ hurat kwatnibi.” ");
INSERT INTO kpf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mata sot gatŋâ sot Lasaro, zeŋgât Yesuŋâ umŋâ tâip. ");
INSERT INTO kpf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Oi mâsekât siŋgi nâŋgâmŋâ sirâm zagât kamân zoren ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sirâm zagât ândimŋâ arâpŋâ itâ sâm dâtnâŋgoip, “Gane Yudaia hânân âburem âinâ.” ");
INSERT INTO kpf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Sâi arâpŋandâ itâ sâwen, “Patâ, mârum Yuda a ziŋ kâtŋâ gonam urâwe. Wangât dum zoren âinatkât sat?” ");
INSERT INTO kpf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Sâindâ Yesuŋâ dâtnâŋgom sâip, “Mirâ haŋsâm zei kek mân ŋâtâtiksâbap. Nepnâ hânân tuum kwâkâbatkât narâkŋâ mân mâte uap. Ŋâi zâk sirâmân mâtâbân ari kut ŋâi ŋâi zimbap, zorâŋ mân kom subap. Zâk âsakŋan kut ŋâi ŋâi ek nâŋgâm âibap. ");
INSERT INTO kpf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ŋâi zâk ŋâtigân mâtâbân âim âsakŋâ kârum âi kom subap.” ");
INSERT INTO kpf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yatâ sâmŋâ den itâ târokwap dâtnâŋgoip, “Bukuniŋ Lasaro, zâk uman ziap. Nâ âi mâŋgibat.” ");
INSERT INTO kpf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yatâ sâi ko arâpŋâ niŋ itâ sâwen, “Uman zemŋâ âlip upap.” ");
INSERT INTO kpf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu zâk mumuŋaŋgât den sumbuŋâ sâi nen umangât nâŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Zorat Yesuŋâ sâm kusikŋan kwap dâtnâŋgoip, “Lasaro muap. ");
INSERT INTO kpf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nâ zoren mân âi ândia muap, zorat zeŋgât umnâ âlip uap. Zen nâŋgâm pâlâtâŋ kwatnim kwâtâtibigât yatâ âsagiap. Bâi, zi zâkkâren âinâ.” ");
INSERT INTO kpf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Sâi ko Yesugât arâp neŋgâren gâbâ a ŋâi Toma, zâk booboo a konsâmarâwen, zâkŋâ bukurâpŋâ itâ sâm dâtnâŋgoip, “Nen zâk sot ârândâŋ arindâ a sâtŋâ ziŋ nâŋgonetâ munat.” ");
INSERT INTO kpf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lasaro moi kât mâtâpŋan pane sirâm kimembut zei Yesu âi takip. ");
INSERT INTO kpf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania kamân zo Yerusalem kamân naŋgâmŋan tâip. ");
INSERT INTO kpf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Zobâ Yuda a doŋbep Mata Maria munzikŋâ moip, zorat sâŋgân ninam Betania kamânân âi tarâwe. ");
INSERT INTO kpf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Oi Yesu gaap sâne Mata zâk nâŋgâm ari Maria ko mân nâŋgâm mirin tâi Mataŋâ mâtâbân âi Yesu muyageip. ");
INSERT INTO kpf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Muyagemŋâ itâ sâm dukuip, “Kembu, gâ ziren ândina sâi ko munnâ mân mombap. ");
INSERT INTO kpf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Oi irabot zi gâgât nâŋgan. Gâ wan mo wangât Anutugâren ninâu sâna nâŋgâgibap.” ");
INSERT INTO kpf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Sâi Yesuŋâ itâ sâm dukuip, “Mungâ mumuŋan gâbâ zaatpap.” ");
INSERT INTO kpf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Sâi Mataŋâ itâ dukum sâip, “Narâk patâ, zaatzaat narak, zoren zaatpap, zo ko nâŋgan.” ");
INSERT INTO kpf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Sâi Yesuŋâ dukuip, “Zaatzaat sot ândiândi mariŋâ, nâ. Zorat ŋâiŋâ nâŋgâm pâlâtâŋ kwatnibap, zâk momŋâ zaat ândiândiŋ kâtik ândim zâibap. ");
INSERT INTO kpf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Oi ŋâi zâk wâgân ândim nâŋgâm pâlâtâŋ kwatnibap, zâk mumu kâtik mân mom ândiândi kâtik ândim zâibap. Gâ den zo nâŋgâna bon uap?” ");
INSERT INTO kpf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Sâi Mataŋâ sâip, “Zo nâŋgan. Oi gâgât itâ nâŋgan. A bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, zo gâ. Anutugât nanŋâ hânân gibapkât sâsâŋâ, zo gâ. Zorat umnandâ nâŋgâm pâlâtâŋ kwatgigan.” ");
INSERT INTO kpf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Den Yatâ sâm birâm âi gatŋâ Maria muyagem den halobân itâ sâm dukuip, “Patânikŋâ gaap. Oi gâgât sap.” ");
INSERT INTO kpf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sâi Mariaŋâ nâŋgâmŋâ kârâpŋoorâk zaat Yesugâren arip. ");
INSERT INTO kpf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu zâk kamânân mân takâm Mata muyageip, zoren kirip. ");
INSERT INTO kpf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mariaŋâ kek zaatŋâ ari Yuda a ambân zâk sot tap um diim gigi den dukum tarâwe, zen kwagân âibam ariap sâm molim âiwe. ");
INSERT INTO kpf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria zâk âim Yesu ekŋâ kiŋ topŋan ge pindiŋsâm itâ sâm dukuip, “Kembunâ, gâ ziren ândina sâi ko munnâ mân mombap.” ");
INSERT INTO kpf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yatâ sâm isei Yuda a ambân molim âiwe, zen bekŋan mem isewe. Isene Yesuŋâ ziŋgitŋâ umŋâ bâliŋ oip. ");
INSERT INTO kpf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yesu zâk mâsikâziŋgâm sâip, “Ikâ zoren hanguwe?” Sâi ziŋâ sâwe, “Kembu, gâ zi ga eknan.” ");
INSERT INTO kpf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Sâne Yesu zâk iseip. ");
INSERT INTO kpf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Oi Yuda a ziŋâ ekŋâ sâwe, “Iknek, zâkŋâ umŋandâ gâsum biraŋmap.” ");
INSERT INTO kpf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nâmbutŋandâ itâ sâwe, “A sen ŋâtâtik siŋâ mânâŋgâripŋâ a zi âlip kubigi mân mombap?” ");
INSERT INTO kpf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesuŋâ umŋâ bâliŋ oi kwagân âi takip. A zo kât mâtâpŋan pane zei kât pâtâ mem mâtâpŋan pam dooŋguwe. ");
INSERT INTO kpf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Zorat Yesuŋâ itâ sâip, “Kât mem kâbakŋinek.” Sâi a mumuŋâ zorat ponâŋâ, Mataŋâ itâ sâm dukuip, “Kembu, sirâm kimembut ziap, zorat mârum kârok uap.” ");
INSERT INTO kpf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Sâi Yesuŋâ itâ dukuip, “Den dâgogan, zo mân nâŋgat? Gâ nâŋgâm pâlâtâŋ kwatninandâ Anutu imbaŋâŋaŋgât topŋâ muyagei ikpan.” ");
INSERT INTO kpf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yatâ sâi ko kât mem kâbakŋine ari Yesuŋâ siŋâ sumbemân ekŋâ itâ sâip, “Ibânâ, gâ ninâunâ nâŋgat, zorat sâiwap san. ");
INSERT INTO kpf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Gâ narâk dâp ninâunâ nâŋgâmat, zo nâŋgan. Nâ a zi kinze, zen topnâ nâŋgâbigât itâ san. Gâŋâ sâŋgonnona gewangât umziŋandâ nâŋgâm pâlâtâŋ kwatnibigât den yatâ dâgogan.” ");
INSERT INTO kpf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yatâ sâmŋâ den kâtik sâm konsâip, “Lasaro, gâ gem ga.” ");
INSERT INTO kpf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Sâi mumuŋandâ zaat gâip. Oi mârum kiŋ bikŋâ sâŋgum kâpiwe. Si sâŋgânŋâ kâpiwe, zorat Yesuŋâ dâzâŋgoip, “Sâŋgum olaŋ birânek.” ");
INSERT INTO kpf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yuda a ambân Maria sot gawe, zeŋgâren gâbâ doŋbepŋâ Yesu kut ŋâi ŋâi oip, zo ekŋâ nâŋgâm pâlâtâŋ kwarâwe. ");
INSERT INTO kpf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nâmbutŋandâ ko Parisaio zeŋgâren âim Yesuŋâ kut ŋâi ŋâi oip, zorat den siŋgi sâm dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Oi tirik namâ galem a patâ sot Parisaio, zen den so nâŋgâm sâne a sâtŋâ mindune itâ dâzâŋgom sâwe, “A zi kulem top top tuugapkât dap utnat? ");
INSERT INTO kpf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nen ek mân nâŋgânâŋgâ utnat, zo ko a pisuk patâ ziŋ zâkkâren âimŋâ neŋgât a kutâ sâne Roma a ziŋ kuk opŋâ gam nâŋgone mom naŋgindâ tirik namâ zi kândaŋbe.” ");
INSERT INTO kpf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yatâ sâne zeŋgât buku ŋâi kutŋâ Kaipa, narâk zoren tirik namâ galem a patâ ândeip, zâkŋâ itâ sâip, “Zen um nâŋgânâŋgâziŋ buŋ ândie. ");
INSERT INTO kpf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Zen itâ mân nâŋge. A kâmut nen mom naŋgâbemgât neŋgât hâuniŋâ a kânokŋâ moi âlip upap.” ");
INSERT INTO kpf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Den zo zik umgât mân sâip. Kendon patâ zorat umŋan zâk tirik namâ galem a patâ zeŋgât patâziŋâ ândeipkât Anutuŋâ sâi kânŋan den zo sâip. (Yesu zâk perâkŋak Yuda a kâmut, zeŋgât op mumbapkât sâm pindâpindâŋ. ");
INSERT INTO kpf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Oi Yuda a zeŋgârâk buŋâ, Anutugât nan bârarâp hân dâp ândie, zen aksik minduziŋgi kâmut kânok ândibigât sâm pindâpindâŋ.) ");
INSERT INTO kpf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","A patâŋâ Yesugât op yatâ sâipkât narâk zoren gâbâ a sâtŋâ zen Yesu kunam den sâm mâtâp kârum ândim gawe. ");
INSERT INTO kpf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Zorat Yesu zâk mulukŋem tik ândeip. Zâk mirâ kamân kâtik naŋgâmŋan kamân ŋâi tâip, kutŋâ Epraim, zoren arâpŋâ diiniŋgi âi ândiwen. ");
INSERT INTO kpf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Oi Yuda zeŋgât kendon patâ kutŋâ Pasowa, zo mâte oi kamân mâik mâigân gâbâ a doŋbep patâ, zen Yerusalem kamânân zâiwe. Zen Pasowa kendongât um sâkziŋ kubiknam zâiwe. ");
INSERT INTO kpf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Mârum tirik namâ galem a sot Parisaio a, ziŋ den itâ sâm dâzâŋgowe, “Ŋâiŋâ Yesugât tâtat mâmeŋâ ek nâŋgâmŋâ ga dâtnâŋgoik. Dâtnâŋgoi gâsum tâk namin pânat.” Yatâ sâwegât kendon patâ mâte oi Yesu kârumŋâ tirik namin zâi kin itâ mâsikâyaŋgâm sâwe, “Zen dap nâŋge? Yesu zâk kendonân gâbap mo buŋâ?” ");
INSERT INTO kpf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasowa kendon ombeŋan sirâm namburân kânok zei Yesuŋâ Betania kamânân arip. Kamân zoren mârum Lasaro mumuŋan gâbâ mâŋgei zaarip. ");
INSERT INTO kpf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Oi zoren Yesu sii nalem om pindâne Mataŋâ tokim pâi Lasaro ârândâŋ tap niwe. ");
INSERT INTO kpf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tatnetâ Mariaŋâ kwâip belo ŋâi too wârânŋâ âlipŋâ, sâŋgân zâizâiŋ, zo mem Yesu kiŋan sâŋgonŋâ kâuk sâmotŋandâ âron meip. Oi mirâ zo itom âlipŋâ gam zeip. ");
INSERT INTO kpf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Oi arâpŋâ neŋgât buku ŋâi Yuda, Karioto kamânân gok (Zâk narâk ŋâin Yesu tirâpzâŋgoi gâsum kuwe.), zâkŋâ itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Too wârân âlip, zorâŋâ sâŋgân kât 3 handeret yatâ mem a kanpitâ ziŋgi dâp opap.” ");
INSERT INTO kpf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Zâk a kanpitâ zeŋgât mân nâŋgâm sâip. Zâkŋâ mindum kât pâpanŋaŋgât irâ, zo zâkŋâ galem op ândeip. Kât panetâ tik kâmbu memâip, zorat op sâip. ");
INSERT INTO kpf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Sâi Yesuŋâ itâ sâm dâtnâŋgoip, “Birânek. Ambân zo den mân dukunek. Too hitom âlip, zo sâknâ saŋgori mua hanobi, zorat opŋâ kânŋan saŋgonnigap. Zâk âlip uap. ");
INSERT INTO kpf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","A kanpitâ, zen âsâbâŋ zen sot ândibi. Nâ ko zen sot narâk karep mân ândibat.” ");
INSERT INTO kpf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yesu zâk Betania kamânân ândei Yuda a doŋbep zâkkât siŋgi nâŋgâm zoren âiwe. Zen Yesuyâk iknam mân âiwe. Lasaro mumuŋan gâbâ mâŋgeip, zâk ârândâŋ iknam âiwe. ");
INSERT INTO kpf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Yuda a doŋbepŋâ Lasarogât den siŋgi nâŋgâmŋâ Yesu nâŋgâm pâlâtâŋ kwâkŋaŋgâwe. Yatâ urâwegât tirik namâ galem a patâ, ziŋ Lasaro Yesu sot ârândâŋ zâkonam den nep tuuwe. ");
INSERT INTO kpf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mirâ haŋsâi a doŋbepŋâ kendongât Yerusalem kamânân zâiwe. Zen Yesu gam taap sâne siŋgi nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Den yatâ nâŋgâm sâtâre op gâmalem sot gâlaŋgât iinŋâ namuŋ mem mâtâbân muyaginam âiwe. Âi muyagem pam diim itâ sâwe, “Oe, Kembugât sâtkât gam niŋgat. Nen sâm âlip kwatgigen. Gâ Isirae nengât a kutâ.” ");
INSERT INTO kpf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu zâk doŋgi sigan muyagem kwâkŋan zâi tâi arip. Zorat Kembugât ekabân den ŋâi itâ ziap, zorat dâp oip. Den zo itâ, ");
INSERT INTO kpf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yerusalem kamân, Sioŋ mâirâp, zen mân keŋgât utnek. Iknek. A kutâ patâziŋ gaap. Zâk doŋgi sigan zorat kwâkŋan gaap.” ");
INSERT INTO kpf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Narâk zoren arâpŋâ nen den zorat topŋâ mân nâŋgâwen. Yesu momŋâ zaat sumbemân zarip, zoren itâ nâŋgâwen, “Zo zâkkât op kulemguwe. Oi zâkŋâ zo yatik oip.” ");
INSERT INTO kpf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mârum Yesu zâk Lasaro konsâi kwagân gâbâ gâi igâwe, zen den siŋgi zo a nâmbutŋâ dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Oi sen mârât zorat siŋgi nâŋgâweŋâ a doŋbepŋâ gâmalem sot gâlaŋgât iinŋâ namuŋ mâtâbân âi muyagiwe. ");
INSERT INTO kpf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Oi Parisaio a, ziŋâ ziŋgitŋâ bukurâpziŋ mindum târâwe itâ sâm dâzâŋgowe, “Nâŋgânek. Zen den nep tuune a doŋbep patâ zâkkârâk op naŋge. Oi zâkŋak walâniŋgi kwaksen.” ");
INSERT INTO kpf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","A kendongât Yerusalem kamânân gawe, zeŋgât oserân Grik a nâmbutŋâ ârândâŋ ândim Anutu mâte okŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Zen Pilipo, Besaida kamân Galilaia hânân gokŋâ, zâkkâren âi itâ sâm dukuwe, “Patâniŋâ, Nen Yesu iknatkât otniŋgap.” ");
INSERT INTO kpf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Sâne Pilipoŋâ nâŋgâm Andrea dukui ârândâŋ Yesugâren âi den zo sâm dukuwet. ");
INSERT INTO kpf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Dukoitâ Yesuŋâ itâ sâip, “A bonŋâ, nâ sumbem âsakŋânâ muyagibatkât narâk mâte uap. ");
INSERT INTO kpf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Perâkŋak dâzâŋgua nâŋgânek. Segoŋ keetŋâ, zâk hânân gei yen mân zimbap. Hânân gei momŋâ bonŋâ doŋbep muyagibap. Ka keetŋâ hânân mân giari sâi bon buŋ opap. Hânân giari bonŋâ doŋbep muyagibap. ");
INSERT INTO kpf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ŋâi zâk hânân ândiândiŋâ buku okŋaŋgi gulip okŋaŋgâbap. Ŋâi zâk hânân ândiândiŋâ kâsa okŋaŋgâbap, zâk ândiândi kâtik muyagibap. ");
INSERT INTO kpf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ŋâi zâk nâgât kore ândibâ sâm nâŋâ mâtâp ândiwan, zorat dâp ândim molinibap. Yatâ op ândibapŋâ nâgâren gam nâ sot ândibap. Ŋâi zâk kore otnibap, zâk Ibânandâ sâi a patâ op ândibap.” ");
INSERT INTO kpf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Itârâŋ umnâ yâmbâriap. Oi dap sâbat? Itâ sâbat? Ibâ narâk ziren sâknam âsagenibap, zo sâna mân âsagibap. Yatâ mân sâbat. Wangât, narâk ziren sâknam itâ zo âsagenibapkât gewan, zorat. ");
INSERT INTO kpf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Zorat Ibânâ gâ sâna kutsiŋgigaŋgât kutkâ neule âsakŋoot âsagibap.” Yesuŋâ yatâ sâi ko sumbemân gâbâ den ŋâi itâ geip, ");
INSERT INTO kpf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","“Neule âsakŋâ sa muyageip, zo dum sa muyagibap.” Oi a kâmut patâ kirâwe, ziŋâ itâ sâwe, “Zi sumbem kârap.” Oi nâmbutŋanda itâ sâwe, “Sumbem a ŋâiŋâ den dukuap.” ");
INSERT INTO kpf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Den zo ninaŋgât buŋâ. Zeŋgât op muyagiap. ");
INSERT INTO kpf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Narâk ziren hângât a kutâ Sataŋ kâbakŋiŋiŋ. Oi a ambân tosaziŋaŋgât hâuŋâ mimbigât sâm kwâkâkwâkâŋ. ");
INSERT INTO kpf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nâ nagân nom mem zaat kwânâŋgânine ko hân dâp a diiziŋga nâgâren gabi.” ");
INSERT INTO kpf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Zo mumuŋaŋgât dap yatâ mumbap, zorat den sumbuŋâ zo sâip. ");
INSERT INTO kpf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Sâi a kâmut kirâwe, zen itâ dukuwe, “Nen gurumin den sâlâpkum itâ nâŋgâmen. A bâliŋan gâbâ mâkâniŋgâbapkât sâsâŋ, zâk âsagemŋâ mân mom ândim zâimâmbap. Oi gâŋâ itâ sat, ‘A bonŋâ nagân nom mem kwânâŋgânibi.’ A bonŋâ, zâk dap yatâ?” ");
INSERT INTO kpf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Sâne Yesuŋâ itâ mâburem dâzâŋgoip, “Kârâp âsakŋandâ narâk pâŋkânok osetziŋan âsageziŋgâm ândibap. Oi zen ŋâtâtikŋâ kâpizâŋgobapkât kârâp âsakŋâ zemziŋgi zâk mâte okŋaŋgâm ândibi. A ŋâi ŋâtâtigân âibap, zâk dap op mâtâpŋâ ikpap? ");
INSERT INTO kpf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Zorat âsakŋâ zemziŋgi nâŋgâm pâlâtâŋ kwâkŋaŋgâne kâmut gakârâpŋâ upi.” Yesu zâk den yatâ sâmŋâ tik âi ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu zâk a ambân mâteziŋan sen mârât kulem top top tuugi ekŋâ mân nâŋgâm pâlâtâŋ kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Zo Propete Yesaiagât den kâtigibapkât yatâ urâwe. Zâk mârumŋan den itâ sâm kulemgoip, “Kembugât den siŋgi sâindâ mân nâŋgâme. Zorat Kembugât imbaŋâ, zo dap op zeŋgâren muyagibap?” ");
INSERT INTO kpf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Oi Yesugât den mân nâŋgâwe, zorat Propete Yesaiaŋâ Kembugât den ŋâi itâ sâm kulemguip, ");
INSERT INTO kpf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Zâk otziŋgi sinziŋ ŋâtâtiksâi umziŋ kâtigeip. Zo zen sinziŋandâ ek nâŋgâbegât. Oi umziŋandâ nâŋgâm kwâtâtibegât. Oi umziŋ melâŋne kubikziŋgâbamgât.” ");
INSERT INTO kpf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaiaŋâ Yesugât sumbem âsakŋâ, zo ekŋâ zâkkât yatâ sâip. ");
INSERT INTO kpf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","A sâtŋâ zeŋgâren gâbâ doŋbepŋâ Yesugâren nâŋgâm pâlâtâŋ kwâkŋaŋgâwe. Oi zo sapsune Parisaio ziŋ nâŋgâbegât kwâimbâwe. Mâpâmâpâse namin zâine kâbakŋeziŋgâbegât yatâ urâwe. ");
INSERT INTO kpf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Zen a ziŋâ sâm âlip kwatziŋgâbigât yatâ urâwe. Anutuŋâ sâm âlip kwatziŋgâbap, zorat nâŋgâne yenŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesuŋâ den kâtikŋâ sâm itâ sâip, “Ŋâi zâk nâ nâŋgâm pâlâtâŋ kwatnibap, zo nâyâk buŋâ. Sâŋgonnogip, zâk ârândâŋ nâŋgâm pâlâtâŋ kwâkŋaŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Oi ŋâi zâk nâ nikpap, zo yatik sâŋgonnogip, zo ikpap. ");
INSERT INTO kpf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nâ kârâp âsakŋandâ hânân gewan, zorat ŋâi zâk nâ nâŋgâm pâlâtâŋ kwatnibapŋâ ŋâtâtigân mân ândim zobâ gâbap. ");
INSERT INTO kpf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ŋâi zâk dinnâ biri nâŋâ hâuŋaŋgât mân sâbat. Nâ a zeŋgât tosagât hâuŋâ ziŋgâbatkât buŋâ. Nâ kubikziŋgâm tânzâŋgobatkât gewan. ");
INSERT INTO kpf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ŋâi zâk kândâtnom dinnâ biri ŋâiŋâ tosaŋaŋgât den sâm kwâkâbap. Den sâman zo, zâkŋâ narâk patin tosaŋaŋgât topŋâ sapsubap. ");
INSERT INTO kpf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nâ den zo ninâ umgât mân sâman. Ibâ sâŋgonnogip, zâkŋâ sapsumnigi sâman. ");
INSERT INTO kpf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Oi nâ nâŋgan. Ibânaŋgât diŋâ lum ândiândi kâtikŋâ muyagibi. Den sâman, zo Ibânandâ sâip dâp sâman.” ");
INSERT INTO kpf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasowa kendon narâk mâte oi Yesuŋâ zikŋaŋgât itâ nâŋgip, “Hân birâm Ibânaŋgâren zâibatkât narâk mate uap.” Yatâ nâŋgâm hânân arâpŋâ umŋandâ gâsuniŋgâm ândeipŋâ yatâ otniŋgâm ari ma ko narâkŋâ âkip. ");
INSERT INTO kpf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Oi ŋâtiksâisâi nalem ninam minduindâ Sataŋŋâ mârum Yuda, Simoŋgât nanŋâ, Karioto kâmânân gokŋâ, zâkkât umŋan den itâ pâip, “Yesu a sâtŋâ tirâpzâŋgona ekŋâ gâsubi.” ");
INSERT INTO kpf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu zâk itâ nâŋgip, “Ibânâ, zâk kâwali âksik patâ nigip. Oi nâ Anutugâren gâbâ gewan. Oi nâ âburem Anutugâren zâibat.” ");
INSERT INTO kpf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yatâ nâŋgâm nalem nem tarâwenân gâbâ zaat hâmbâ kwâkâm pam sâŋgum mem lâip. ");
INSERT INTO kpf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Oi too aam âmaŋân lokei giari topkwap kore a yatâ op arâp kinniŋ saŋgorip. Oi sâŋgumŋâ saŋgori âronŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yatâ otniŋgâm Simoŋ Peterogâren ari itâ sâm dukuip, “Kembunâ, gâ gikak kinnâ saŋgonbam uat?” ");
INSERT INTO kpf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Sâi Yesuŋâ itâ sâm dukuip, “Nâ uan zi topŋâ mân nâŋgat. Gâtâm ko nâŋgâban.” ");
INSERT INTO kpf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Sâi Peteroŋâ itâ sâm dukuip, “Kinnâ mânâk saŋgonban.” Sâi Yesuŋâ itâ sâm dukuip, “Nâ mân saŋgongiga gâ dabân nâgât siŋgi a upan?” Yesuŋâ um saŋgonsaŋgon, zorat op den zo sâip. ");
INSERT INTO kpf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Peteroŋâ den zorat topŋâ mân nâŋgâm itâ sâm dukuip, “Kinnigâk mân saŋgonban. Sâknâ aksik saŋgonban.” ");
INSERT INTO kpf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Sâi Yesuŋâ itâ sâm dukuip, “Ŋâi zâk too saŋgonŋâ mâtâbân obândim ko kiŋik saŋgori salekkubap. Oi zen yatik salek ue. Ka osetziŋan gokŋâ ŋâi, zâk zeŋgât dâp mân ândiap.” ");
INSERT INTO kpf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","A sâtŋâ zeŋgâren âi tirâpzâŋgoi gâsubi, zorat op nâŋgâm itâ sâip, “Osetziŋan gokŋâ ŋâi zâk zeŋgât dâp mân ândiap.” ");
INSERT INTO kpf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kinniŋâ too saŋgonŋâ hâmbâ mem gwagori giari ge tap itâ sâm dâtnâŋgoip, “Nâ kinziŋ saŋgonsan, zorat topŋâ sa nâŋgânek. ");
INSERT INTO kpf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Zen nâgât Patâ sot Kembu sâme. Zo âlip sâme. Nâ yatâ ândian. ");
INSERT INTO kpf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nâ Kembuziŋ op ândim kinziŋ saŋgonsan. Ziiŋak yatik kinziŋ saŋgonsaŋgon op kore oraŋgâm ândine âlipŋâ upap. ");
INSERT INTO kpf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tirâpzâŋguan, zo yatik op ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nâ perâkŋak dâzâŋgua nâŋgânek. Kore aŋâ patâŋâ walâm ândiândiŋ, zo mân taap. Yatigâk nâgât kore anâ, zâk nâ mân walânibap. ");
INSERT INTO kpf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Zen den zi nâŋgâm yatingen ândine zeŋgât nâŋga sâtâreŋoot upap. ");
INSERT INTO kpf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nâ zeŋgât pisuk patâ mân san. A nâgât ligaap zorarâk san. Nâ ikâ zo gâsum sâlâpzâŋgowan, zo nâŋgan. Kembugât ekabân den ŋâi ziap, zo bon upap. Den zi itâ, ‘Ŋâi zâk nâ sot nâlem nimbap, zâkŋâ tikootŋandâ nobap.’ ");
INSERT INTO kpf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Zo mân muyagei kânŋan dâzâŋguan. Oi bet muyagei Kembuŋâ kândom dâtnâŋgoip sâm nâgât topnâ nâŋgâm kwâtâtibi. ");
INSERT INTO kpf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nâ perâkŋak dâzâŋgua nâŋgânek. Nâ a nep sâm pinda tuum ândei ŋâiŋâ a zo dâŋ galem op ândibapŋâ zâk yatik kore otnibap. Kore otnibapŋâ sâŋgonnogip, Anutu, zâk yatik kore okŋaŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuŋâ den yatâ sâmŋâ um bâliŋ oi itâ sâm muyageip, “Nâ perâkŋak sa nâŋgânek. Zeŋgâren gâbâ a ŋâiŋâ sâi gâsânobi.” ");
INSERT INTO kpf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yesuŋâ den yatâ sâi arâpŋâ niŋ ŋâigât sap sâm niŋâ senân senân âŋagâwen. ");
INSERT INTO kpf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","24","Oi nâŋâ Yesugât um topŋan târâwan. Nâ Yesuŋâ umŋâ gâsunimâip, nâgâren Simoŋ Peteroŋâ bikŋandâ dâp op sâip, “Mâsikâna dâgogik. Ŋâigât sap?” ");
INSERT INTO kpf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Peteroŋâ yatâ oi nâŋâ Yesu gootŋan âimŋâ sâwan, “Kembu, gâ nâigât sat?” ");
INSERT INTO kpf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Sa Yesuŋâ sâip, “Nalem mem sirogân pam pinda nimbap, a zorat san.” Yatâ sâmŋâ nalem memŋâ sirogân pam Yuda, Simoŋ nanŋâ, Karioto kamânân gok, zo pindi neip. ");
INSERT INTO kpf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nei ko Sataŋŋâ umŋan giarip. Oi Yesuŋâ Yuda itâ sâm dukuip, “Kut ŋâi upam nâŋgat, zo kek upan.” ");
INSERT INTO kpf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Den yatâ dukui arâp nâmbutŋâ, nen den zorat topŋâ mân nâŋgindâ âkip. ");
INSERT INTO kpf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Oi itâ nâŋgâwen, “Zâk kât minduminduŋ galem ândiapkât yatâ sap. Zâk kendongât nalem kwâlâbapkât sap mo a kanpitâ kât ziŋgâbapkât sap.” ");
INSERT INTO kpf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Oi Yudaŋâ nalem zo nemŋâ zaat âkŋan ŋâtâtigânak arip. ");
INSERT INTO kpf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudaŋâ ari Yesuŋâ arâpŋâ nâmbutŋâ nen itâ sâm dâtnâŋgoip, “A bonŋâ nâgât neule âsakŋâ âsagiap. Oi nâgât opŋâ Anutugât neule âsakŋâ ârândâŋ âsagiap. ");
INSERT INTO kpf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","A bonŋâ, nâ Anutugât neule âsakŋâ muyagiangât Anutu zâk zikŋak a bonŋâ nâgât neule âsakŋâ muyagibap. Narâk mân kârep oi kek muyagibap. ");
INSERT INTO kpf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Katep gakârâpnâ, nâ narâk pâŋkânok zen sot ândibat. Oi bet kârunibi. Oi Yuda a dâzâŋgowan, yatik zen dâzâŋgobâ. Nâ âibat, zoren âlip mân gabi. ");
INSERT INTO kpf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Oi zi gurumin den uŋakŋâ dâzâŋgobâ. Ziiŋak buku oraŋgâm ândibi. Nâŋâ buku otziŋgâm gâwan, zo yatik oraŋgâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Zen yatâ op ândine a ziŋâ ziŋgitŋâ itâ nâŋgâbi, ‘Zen buku oraŋgâm ândiegât topziŋâ itâ nâŋgen. Zen Yesugât kâmut gakârâpŋâ.’” ");
INSERT INTO kpf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yesu zâk den yatâ sâi ko Peteroŋâ mâsikâm sâip, “Kembu, gâ ikâ âiban?” Sâi Yesuŋâ sâip, “Nâ âibarân, zo narâk ziren mân gâban. Gâtâm ko gâban.” ");
INSERT INTO kpf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Sâi Peteroŋâ itâ sâm dukuip, “Nâ wangât itârâŋ mân gâbat? Nâ gâgât op ândiândinâ bira buŋ upap.” Sâi Yesuŋâ itâ sâm dukuip. Gâ nâgât opŋâ ândiândigâ birâna buŋ upapkât sat, zorat nâ perâkŋak dâgobâ. Gâ ŋâtik ziren kwâimbâninandâ sâp karâmbut oi kuruk aŋâ diŋsâbap.” ");
INSERT INTO kpf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","(-) ");
INSERT INTO kpf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Oi Yesuŋâ itâ sâm dâtnâŋgoip, “Zen nâŋgâm kwâkâ sot umbâlâ mân upi. Anutu nâŋgâm pâlâtâŋ kwâkŋaŋgâm, nâ yatik nâŋgâm pâlâtâŋ kwatnibi. ");
INSERT INTO kpf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ibânaŋgât kamânân mirâ doŋbep taap. Yatâ zo mân zei sâi ko dâzâŋgobam. ");
INSERT INTO kpf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nâ âim mirâ kiaŋziŋ kubikŋâ âburem ga diiziŋga nâ sot âi ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Âibatkât mâtâp, zo nâŋge.” ");
INSERT INTO kpf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Sâi Tomaŋâ itâ sâm dukuip, “Gâ ikâ zoren âiban? Zo nen mân nâŋgen. Zorat dap op mâtâp zo ek nâŋgânat?” ");
INSERT INTO kpf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Sâi Yesuŋâ itâ sâm dukuip, “Ibâgâren âiâiŋ mâtâp, zo nâ. Nâ walânim Ibâgâren âiâiŋ, zo mân taap. Den bonŋâ sot ândiândi mariŋâ, nâ. ");
INSERT INTO kpf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Zen nâ nikpi, zo ko Ibânâ ikpi. Narâk ziren ko Ibânâ ekŋâ topŋâ nâŋge.” ");
INSERT INTO kpf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yatâ sâi arâpŋâ neŋgâren gokŋâ, a ŋâi kutŋâ Pilipo, zâkŋâ itâ sâm dukuip, “Kembu, Ibâgâ tirâpnâŋgona ekŋâ nâŋgindâ âkâbap.” ");
INSERT INTO kpf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yatâ sâi ko Yesuŋâ itâ sâm dukuip, “Pilipo, nâ narâk kârep zen sot ândiman, zoren nâ mân nekmat? Ŋâi zâk nekmapŋâ Ibâ ekmap. ");
INSERT INTO kpf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Zorat wangât itâ sat?, ‘Gâ Ibâgâ tirâpnâŋgona iknâ.’ Ibâ sot net pâlâtâŋ op kânok uet, zo nâŋgat? Den dâzâŋgoman, zo ninâ umgât mân dâzâŋgoman. Ibânandâ nâgât umnan ândim diŋâ sâmap sot nepŋâ tuumap. ");
INSERT INTO kpf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ibâ sot net pâlâtâŋ op kânok. Den zo nâŋgâne bon upap. Den zo lâunandâ sa nâŋgâne mân dâp uap oi ko nep tuuman, zo iknetâ bon oi nâ nâŋgâm pâlâtâŋ kwatnibi.” ");
INSERT INTO kpf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Nâ perâkŋak sa nâŋgânek. Ŋâi zâk nâŋgâm pâlâtâŋ kwatnibapŋâ nâ nep tuuman, zo yatik tuubap. Oi zorik buŋâ, walâm tuubap. Wangât, nâ Ibânaŋgâren zâim zo Kaapumnâ sâŋgongua zeŋgâren gem ga lâmbamzâŋgobap, zorat. ");
INSERT INTO kpf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Zen nâgât korân sâm ninâu sâm ândine nâŋgâziŋgâbat. Zo yatâ ua ko nanŋâ nâgât opŋâ Ibâ sâm âlip kwâkŋaŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Zen nâgât korân sâm wan mo wangât ninâu sâne ziŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Umziŋandâ nâ gâsunimap oi ko sâtnâ lum ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Oi nâŋâ Ibâgâren ninâu sa ŋâi sâŋgongoi gem mam otziŋgâbap. Zâk narâk dâp zen sot tâtat mâme opmâmbap. Zo Kaapumgât op san. ");
INSERT INTO kpf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kaapum, zâk den bonŋaŋgât mariŋâ. Den siŋgi âlipŋâ birâme, zo ko zen Kaapum sot mân upi. Zen mân ikme sot topŋâ mân nâŋgâme. Zen ko âlip ikme. Zâk zen sot ândiap. Oi umziŋan ândimâmbap. ");
INSERT INTO kpf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nâ zâmbam âi ândia mandu yatâ mân ândibi. Nâ zeŋgâren âburem gâbat. ");
INSERT INTO kpf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Narâk pâŋkânok ziap. Zo âki a siŋgi âlipŋâ birâme, zen mân nikpi. Zen ko nikpi. Nâ ândiândi kâtik ândian. Zen nâgât op yatik ândiândi kâtik ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Narâk zoren nâ sot Ibânâ pâlâtâŋ uet, zo nâŋgâbi. Oi nâ zen sot pâlâtâŋ uen. Nâgât yatâ nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ŋâi zâk umŋandâ gâsunibap, zâk dinnâ lum ândibap. Oi umŋandâ gâsunibap, zo ko Ibânandâ buku okŋaŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesu zâk yatâ sâi Yuda, Karioto kamânân gok buŋâ, Yuda ŋâiŋâ mâsikâm sâip, “Kembu, gâ wangât op topkâ neŋgâren sapsum um kâtik a zeŋgâren mân sapsubam sat?” ");
INSERT INTO kpf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Sâi Yesuŋâ den itâ mâburem dukuip, “A ŋâiŋâ umŋandâ gâsânobapŋâ dinnâ lum ândibap oi ko Ibânandâ umŋandâ gâsubap. Oi Ibâ net zâkkâren gam tâtat mâme utat. ");
INSERT INTO kpf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ŋâi zâk dinnâ mân lubap, zâk umŋandâ mân gâsunibap. Oi den sâman, zo ninan gâbâ buŋâ. Zo Ibâ sâŋgonnogip, zâkkât den.” ");
INSERT INTO kpf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yesu zâk yatâ sâmŋâ itâ sâip, “Nâ zen sot ândim den zo dâzâŋgoman. ");
INSERT INTO kpf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Gâtâm Tirik Kaapum gamŋâ mam otziŋgâm kut ŋâi ŋâi zorat topŋâ sapsumziŋgâm ândibap. Oi den nâŋâ dâzâŋgowan, zo dum dâzâŋgobap. Ibânâ nâgât sâtkât op Tirik Kaapum sâŋgongoi gem mam otziŋgâm ândibap. ");
INSERT INTO kpf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nâgât bet sâwât, zo um lumbenâ ziŋgan. Um kâtik a zeŋgât lumbeŋâ, zo buŋâ. Ninâ zo ziŋgan. Zorat nâŋgâ kwâkâ sot keŋgât, zo mân upi. ");
INSERT INTO kpf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nâ itâ dâzâŋgua nâŋgâwe. Nâ âimŋâ du zeŋgâren âburem gâbat. Zen umziŋ nâgâren sâŋgongune sâi ko nâ Ibâgâren zâibat, zo nâŋgâm umâlep upe. Ibâ zâk nâgât patâ ândiapkât yatâ upe. Nâgât imbaŋânandâ Ibâgât imbaŋâ ombeŋan, zorat. ");
INSERT INTO kpf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Oi zo mân âsagei kânŋan dâzâŋguan, zorat kut ŋâi ŋâi zo âsagei ko nâŋgâm pâlâtâŋziŋ kâtigibap. ");
INSERT INTO kpf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nâ zi den kârep mân târokwap dâzâŋgobat. Hângât a kutâ Sataŋ, zâk tâmbetnobam gâbapkât narâk mâte uap. Ka zâk tâmbetnobapkât imbaŋâ mân tâkŋaŋgap. ");
INSERT INTO kpf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nâ umnandâ Ibâ gâsuman, zorat op ko Ibânandâ nep diŋ sâm nigip, zo wâratkum ândiândinâ birâbat. Nâ umnandâ Ibâ gâsuman, zo a ziŋâ nâŋgâm simbitkubigât yatâ upat. Bâi, zen zaatne âinâ.” ");
INSERT INTO kpf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nâ waiŋ nak topŋâ âlipŋâ. Ibânandâ ko waiŋ nep mariŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nâgâren gâbâ bâranŋâ ŋâi mân bon oi mânâŋgât pâmbap. Bâranŋâ ŋâi bon oi kubikŋaŋgâm bonŋâ patâ upapkât galem upap. ");
INSERT INTO kpf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Zen siŋgi âlipŋâ dâzâŋgowan, zorâŋ kubikziŋgi salek op ândie. ");
INSERT INTO kpf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Zen nâ sot pâlâtâŋ utne nâ zen sot pâlâtâŋ op ândibat. Waiŋ bâranŋandâ topŋoot mân târoyagom zikŋigâk bonŋâ mân upap. Zen yatik nâ sot mân pâlâtâŋ opŋâ bonziŋ mân upi. ");
INSERT INTO kpf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Waiŋ nak topŋâ nâ. Zen ko bâranŋâ. Ŋâi zâk nâ sot pâlâtâŋ oi nâ zâk sot pâlâtâŋ ua bonŋâ doŋbep patâ upap. Ka zen birânim kut ŋâi utnam kwakpi. ");
INSERT INTO kpf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","A zen nâ sot pâlâtâŋ op mân ândine birâziŋgâbat. Oi waiŋ bâranŋâ mânâŋgât pane moi mindumŋâ kârâbân une semap, zo yatâ otziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Zen ko nâ sot pâlâtâŋ op dinnâ mem ândimŋâ wan mo wangât sâne muyagem ziŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Zen bonziŋâ patâ op nâgât arâp bonŋâ op ândine a ziŋ ziŋgitne âlip oi Ibânâ sâm âlip kwâkŋaŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ibânandâ umŋandâ gâsânomap, zo yatik umnandâ zen gâsuziŋgap. Zen nâgât den, zo nâŋgâm ândine umnandâ gâsuziŋgi ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nâ Ibânaŋgât den luga umŋandâ gâsânogi ândiman. Zen yatigâk nâgât den lune umnandâ gâsuziŋgi ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nâgât sâtâre, zorâŋ zeŋgâren doŋbep âsagem zimbapkât den zi dâzâŋguan. Zen sâtâre kwâkŋan ândibigât san. ");
INSERT INTO kpf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nâgât den kâtik itâ dâzâŋgoman. Nâŋâ umnandâ gâsâzâŋgomap, yatik ziiŋak umziŋandâ gâsâyagom ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ŋâi zâk bukurâpŋâ tâmbetagobegât ândiândiŋ biri buŋ upap, a zo bukurâpŋâ umŋandâ gâsâzâŋgom biraŋmap. A neŋgât orot mâme, zorâŋ zâkkât buku orot âlip zo mân walâbap. ");
INSERT INTO kpf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nep diŋ sâm ziŋgan, zo tuune ziŋgitsa buku bonŋâ upi. ");
INSERT INTO kpf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nâ narâk ziren topkwapŋâ kore a mân sâm zâŋgonsâbat. Zen nâgât bukurâpnâ ue. Kore aŋâ patâŋaŋgât umŋan den zemap, zo mân nâŋgâmap. Nâŋâ kut ŋâi ŋâi Ibânaŋgâren nâŋgâwan, zo pisuk patâ sapsum ziŋgâwangât zeŋgât nâŋga bukurâpnâ ue. ");
INSERT INTO kpf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ziŋâ nâ mân gâsum sâlâpnowe. Nâŋâ zen gâsum sâlâpzâŋgowan. Oi âi nâgât orot mâmenâ, zo mem ândim ziren sot sumbemân bonŋâ muyagibigât sâm ziŋgâwan. Oi ziŋâ bonziŋâ muyagine narâk dâp zemâmbap. Yatâ op nâgât kot sâm Ibâgâren wan mo wangât op ninâu sâne ziŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nâgât den kâtik zi dum dâzâŋgobâ. Umziŋandâ gâsâyagom ândibi.” ");
INSERT INTO kpf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu zâk itâ dâtnâŋgom sâip, “Um kâtik a ziŋ kâsa otziŋgânetâ ko itâ nâŋgâbi, ‘Kembu yatik kâsa okŋaŋgâwe.’ ");
INSERT INTO kpf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Zen hângât siŋgi ândine sâi buku otziŋgâbe. Nâ zeŋgât oserân gâbâ gâsum sâlâpzâŋgua kândâtzâŋgowegât kâsa otziŋgâme. ");
INSERT INTO kpf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nâ den itâ dâzâŋgowan, zo nâŋgâbi, ‘Kore aŋâ patâŋâ walâm ândiândiŋ, zo mân taap.’ A ziŋ kâsa otniwe, zo yatik zen kâsa otziŋgâbi. Zen nâgât den nâŋgâwe sâi yatik zeŋgât den nâŋgâbe. ");
INSERT INTO kpf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Sâŋgonnogip, Anutu, zâk mân ek nâŋgâmegât nâgât op yatâ otziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nâ um kâtik zeŋgâren mân gemŋâ den dâzâŋgowan sâi ko tosaziŋ buŋ ândibe. Ka nâ gem ga dâzâŋgua tosaziŋâ zo dap yatâ sâm kwârakubi? ");
INSERT INTO kpf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ŋâi zâk kâsa otnibapŋâ Ibânâ yatik kâsa okŋaŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nâ osetziŋan nep patâ tuuwan, a ziŋ mân tuume yatâ. Zo mân tuuga sâi tosaziŋ buŋ ândibe. Kâ nâ gem ga ko nekŋâ nâ sot Ibânâ laŋ kâsa otnikâme. ");
INSERT INTO kpf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yatâ utnetâ Kembugât ekabân den ziap, zo nâgâren bon uap. Den zo itâ. ‘Nâ bâliŋâ mân ua ko laŋ kâsa otnige.’ ");
INSERT INTO kpf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nâ Ibâgâren âburem âimŋâ, mam otziŋgâbap, Kaapum, den bonŋâ mariŋâ, zâk sâŋgongua gem gam topnâ sâm muyageziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Zen nâ nep topkwarâwanân gâbâ nâ sot ândim gawe, zorat zo yatik topnâ sap sum ândibi.” ");
INSERT INTO kpf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Zen nebân kin loribegât yatâ sâm dâzâŋguan. ");
INSERT INTO kpf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Zen mâpâmâpâse namin aŋgân kârâziŋgâbi. Perâkŋak, narâk ŋâi mâte upap, zoren a ziŋ nen Anutugât nep tuunâ sâm zâŋgone mumbi. ");
INSERT INTO kpf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Zen Ibânâ sot nâ, nekât topnik mân nâŋgegât yatâ upi. ");
INSERT INTO kpf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nâ den kânŋan dâzâŋguan, zorat bonŋâ muyagei itâ sâbi, ‘Kembuŋâ mârum dâtnâŋgoip, zo muyagiap.’ Nâ mârum zen sot tâpat sâm mân dâzâŋgowan. Nârâk zi ko dâzâŋguan. ");
INSERT INTO kpf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Itârâŋ sâŋgonnogip, Anutu, zâkkâren âibâ sa zeŋgâren gâbâ a ŋâiŋâ mân mâsikânigap, ‘Gâ ikâ âiban?’ ");
INSERT INTO kpf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Âibam ua narâkŋâ dâzâŋguan, zorat umziŋ bâliŋ uap.” ");
INSERT INTO kpf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Nâ perâkŋak sa nâŋgânek. Âburem zâibat, zo zeŋgâren bonŋâ muyagibapkât zâibat. Nâ mân zaria sâi Tirik Kaapum mân gem ga mam otziŋgâbap. Ka nâ zâim sâŋgongua gem gâbap. ");
INSERT INTO kpf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Zâk gem ga a zeŋgât bâliŋâziŋâ sot târârak ândiândiŋ sot hâuŋâ mimbi, zorat sapsum ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tosaziŋaŋgât topŋâ itâ nâŋgâbi. Zen nâ mân nâŋgâm pâlâtâŋ kwatnime. ");
INSERT INTO kpf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Târârak orotŋaŋgât itâ nâŋgâbi. Nâ Ibâgâren âburem zaria mân nikpi. ");
INSERT INTO kpf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Hâuŋaŋgât den sâsâŋ, zorat itâ nâŋgâbi. Hân zirat a kutâ Sataŋ, zâk tosaŋaŋgât hâuŋâ mimbapkât mârum sâm kwâkâm pindap.” ");
INSERT INTO kpf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Yesu zâk yatâ sâmŋâ itâ sâm dâtnâŋgoip, “Den doŋbep ziap. Narâk ziren zo dâzâŋgua dap op nâŋgâm naŋgâbi? ");
INSERT INTO kpf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kaapum, den bonŋâ mariŋâ, zâk gem gam den bonŋâ dâzâŋgobap. Zik umgât den zo mân sâbap. Den nâgâren gâbâ nâŋgâbap, zo yatik sapsum ziŋgâbap. Oi kut ŋâi ŋâi gâtâm âsagibap, zo sapsum ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Den zo ninan gâbâ mem sâm muyagem ziŋgi kutsiŋginâ lum zaatpi. ");
INSERT INTO kpf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ibâgâren den bonŋâ ziap, zorat mariŋâ nâ. Zorat op itâ san, Nâgâren gâbâ den mem muyagem ziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Narâk pâŋkânok ziap, zo âki aria kârunibi. Oi zorat kwâkŋan narâk pâŋkânok ziap. Zo âki ga nikpi.” ");
INSERT INTO kpf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yesu zâk yatâ sâi arâpŋâ nâmbutŋâ nen kwakmak op itâ âraguwen, “Den itâ sâp, ‘Narâk pâŋkânok ziap, zo âki aria mân nikpi. Oi zorat kwâkŋan narâk pâŋkânok ziap, zo âki ga nikpi.’ Oi den ŋâi itâ sap, ‘Ibâgâren zâibat.’” ");
INSERT INTO kpf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yatâ sâmŋâ sâwen, “Narâk pâŋkânok zo, zo wangât sap? Nen kwaksen.” ");
INSERT INTO kpf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Mâsikânam oindâ Yesuŋâ niŋgit umniŋan ek nâŋgâm itâ sâm dâtnâŋgoip, “Nâ itâ dâzâŋguan. Narâk pâŋkânok ziap, zo âki aria mân nikpi. Oi zorat kwâkŋan narâk pâŋkânok ziap, zo âki ga nikpi. Zen den zorat âragum te? ");
INSERT INTO kpf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nâ perâkŋak dâzâŋgobâ. Um kâtik, ziŋ none mua ko arâpnâ âigirâp isem umbâlâ utne a um kâtik, ziŋ sâtâre upi. Zen ko umbâlâ op ândibi. Ka umbâlâ upi, zorat hâuŋâ sâtâre upi. ");
INSERT INTO kpf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ambân ŋâi zâk katep mimbam sâknam patâ nâŋgâbap, zorâŋ katep âsagei sâknam buŋ oi sâknamgât nelâmkoi katepkât sâtâre upap. ");
INSERT INTO kpf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Zen yatigâk narâk ziren umbâlâ op ândibi. Ândine mumuŋan gâbâ zaat ziŋgitsa ko umâlep upi. A zen umâlep zo mân kune buŋ upap. ");
INSERT INTO kpf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nâ perâkŋak dâzâŋgobâ. Nâ mumuŋan gâbâ zaatsa zen kut ŋâi ŋâigât mân kwakŋâ mâsikânibi. Wangât, zen wan mo wangât Ibâgâren sâne kutnaŋgât op muyagem ziŋgâbap, zorat. ");
INSERT INTO kpf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ândim gawe, zoren kut ŋâi ŋâigât nâgât korân mân ninâu sâwe. Narâk zi ko sâtâre kwâkŋan ândibigât wan mo wangât ninâu sâne Ibânâ zâk muyagem ziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Den sâm gâwan, zo sumbuŋik dâzâŋgowan. Narâk ŋâi mâte upabân den sumbuŋâ mân dâzâŋgobat. Ibâgât topŋâ, zo muyabâk dâzâŋgobat. ");
INSERT INTO kpf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Narâk zoren ziiŋak kutnâ mem ândim ninâu sâne Ibâ zâk âlip nâŋgâziŋgâbap. Nâ wangât kut ŋâi ziŋgâbapkât dukubat. Ibâ zâk ninâuziŋâ wâratkum âlip ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nâ Ibâgâren gâbâ gewan, zo nâŋgâm umziŋâ gâsânomapkât Ibâ zâk yatik umŋandâ gâsâzâŋgomap. ");
INSERT INTO kpf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nâ Ibâgâren gâbâ hânân gewan. Oi hân zi birâm Ibâgâren âburem zâibâman.” ");
INSERT INTO kpf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesu zâk yatâ sâi arâpŋandâ itâ sâm dukuwen, “Zi den sumbuŋâ mân sâm, muyap dâtnâŋguat. ");
INSERT INTO kpf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Zorat itâ nâŋgen. A ziŋâ mân mâsikâgine gâ gikak kut ŋâi ŋâi zo nâŋgâm naŋgâmat. Gâ Anutugâren gâbâ gâin, zo nâgâm kwâtâtien.” ");
INSERT INTO kpf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Sâindâ Yesuŋâ itâ sâm dâtnâŋgoip, “Zen irabot zi nâŋgâm kwâtâtie? ");
INSERT INTO kpf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Narâk ŋâi ziap, zo mâte oi nâ birânim siŋsururuŋ op mirâziŋan âibi. Oi nâbane ninik mân ândibat. Ibâ, zâk nâ sot ândimap. ");
INSERT INTO kpf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nâgât um lumbe zeŋgâren zimbapkât yatâ dâzâŋguan. Zen hânân sâknam kwâkŋan ândibi. Ka nâŋâ tâmbetzâŋgobegât imbaŋâ zo kuan. Zorat umâlep op ândinek.” ");
INSERT INTO kpf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu zâk den zo sâmŋâ siŋâ sumbemân ekŋâ itâ sâip, “Ibâ, âburibatkât narâkŋâ mâte uap. Gâ nangâ, nâgât neule âsaknâ sâna âsagibap. Nâŋgoot yatik gâgât neule âsakŋâ sa âsagibap. ");
INSERT INTO kpf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gâ nangâ nâ hân dâp a zeŋgât mariziŋ nâbarin. A nâgâren zâmbarin, ândiândi kâtik muyagem ziŋgâbatkât sâm nigin. ");
INSERT INTO kpf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Oi ândiândi kâtik zorat topŋâ itâ ziap. Gâ Anutu bonŋâ kânok sot sâŋgonnogin, Yesu Kristo, net a ziŋâ nikit net sot pâlâtâŋ utne ândiândi kâtik muyagem ziŋgârat. ");
INSERT INTO kpf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nâ hânân ândim nep sâm nigin, zo tuum kwâkandâ neule âsakkâ muyagiap. ");
INSERT INTO kpf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Ibâna, hân mân muyageinân gâ sot sumbemân neule âsakŋânoot ândiwan, zo yatik narâk ziren mâburem nina mem ândibat.” ");
INSERT INTO kpf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Hânân a doŋbep zeŋgâren gâbâ nâgât siŋgi sâm gâsum sâlâpzâŋgoin, zo siŋgi dengâ sapsum ziŋgâwan. Zo gâgât siŋgi ândinetâ nâgât siŋgi sâin. Oi zen gâgât den nâŋgâm mem ândie. ");
INSERT INTO kpf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kut ŋâi ŋâi zemnigip, zo gâgâren gokŋik. Zo zen nâŋge. ");
INSERT INTO kpf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Den nigin, zo ziŋga nâŋgâm umziŋan gei ziap. Oi nâ gâgâren gâbâ gewan, zo nâŋgâm kwâtâtie. Gikak nep diŋ sâm nigin, zo nâŋge. ");
INSERT INTO kpf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nâ zeŋgât op gâgâren ninâu san. A um kâtik zeŋgât op mân san. A nigin zo, zeŋgât op ninâu san. Zen gâgât siŋgi ue. ");
INSERT INTO kpf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","A ambân nâgât siŋgiŋâ gâgât siŋgi. Gâgât siŋgi zorâŋ nâgât siŋgi. Oi umziŋan nâgât âsakŋâ muyagem ziap. ");
INSERT INTO kpf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nâ hânân ândiândinâ ândia âkap. Zen ko hânân zi târokwap ândinetâ nâ gâgâren gâbâman. Ibâ hâlâlu, kutkâ nigin, zorat kutsiŋgigaŋgât imbaŋandâ pâit saaziŋgâna hâlâlu ândibi. Oi zen um kânok op ândibi. Net um kânok ândimet yatik zen um kânok ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","A nigin, zen sot ândim kutsiŋgigaŋgât imbaŋandâ lâmbamzâŋgua ândiwe. Nep diŋ zo sâm nigip. Oi dâŋ galem otziŋga mân tâmbetagowe. Gâgât den kulem bon upapkât simgât siŋgi, zâk kânok tâmbetagoip. ");
INSERT INTO kpf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Zi gâgâren gâbam hânân den yatâ dâgoga nâgât sâtâre, zo zeŋgâren ari sâtâre kwâkŋan ândibi. ");
INSERT INTO kpf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Gâgât den zo ziŋga mem ândine hângât siŋgi a, ziŋâ kâsa otziŋgâwe. Nâ hângât siŋgi mân ândiman. Arâpnâ zen yatâ hângât siŋgi mân ândimegât yatâ otziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Arâpnâ hânân gâbâ diiziŋgâm zâibangât mân san. Bâliŋâ mariŋandâ tâmbetzâŋgobapkât san. Gâŋâ galemziŋ upangât san. ");
INSERT INTO kpf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nâ hângât siŋgi buŋâ. Zen yatigâk hângât siŋgi buŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gâgât den bonŋâ umziŋan pâna âsagei târârak op ândibi. Gâgât denŋâ, den bonŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Gâŋâ sâŋgonnona hânân gem nep tuuwan, zo yatik sâŋgonzâŋgua zen um kâtik zeŋgâren nep tuubi. ");
INSERT INTO kpf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Zen umziŋâ gâgâren pambigât zo yatik nâŋâ umnâ gâgâren paan.” ");
INSERT INTO kpf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“A zi kinze, zeŋgârâk mân ninâu san. Den siŋgi âlip sâne nâŋgâm pâlâtâŋ kwatnibi, zeŋgât sot ârândâŋ ninâu sân. ");
INSERT INTO kpf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Zen um kânok op ândibigât dâgogan. Ibâ, gâ nâgât umgâ kinmap. Nâŋâ umnâ gâgâren kinmap. Zo yatik ziŋâ nekâren umziŋâ kinbap. Oi umziŋandâ gâsâyagom ândibi. Yatâ utnetâ ko um kâtik a zen gâ sâŋgonnona gewan, zo nâŋgâm kwâtâtibi. ");
INSERT INTO kpf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Net um kânok ândimet, zo yatik um kânok op ândibi. Zo yatâ ândibigât neule âsakŋâgâ nigin, zo ziŋgâwan. ");
INSERT INTO kpf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nâ umnandâ gâsâzâŋgua gâ yatik umgândâ gâsânona umziŋ kânok op kwâkâbap. Zen yatâ ândine um kâtik zen gâŋâ sâŋgonona gewan, zo nâŋgâm biraŋbi. Oi umgandâ nâ kâpinom yatik zen kâpizâŋgomat, zo nâŋgâm biraŋbi. ");
INSERT INTO kpf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ibâ, A nigin, zo biken nâ sot ândibigât dâgogan. Oi zen biken nâ sot ândim neule âsakŋânâ ikpigât dâgogan. Neule âsaknâ zo umâlepkaŋgât op hân mân muyageinân nigin. ");
INSERT INTO kpf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Ibâ, târârak mariŋâ, um kâtik a zen topkâ mân nâŋgâwe. Nâ ko topkâ nâŋgâman. Oi kâmut gakârâpnâ, zen gâŋâ sâŋgonnona gewan, zo nâŋgâme. ");
INSERT INTO kpf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nâ gâgât den siŋgi sâm muyagem ziŋgâwan. Oi sâm muyagem ziŋgâm zâibat. Oi umgâ gâsânomap, zo yatik umgandâ zen gâsâzâŋgoi nâ yatik umnandâ gâsuziŋgi ândibat.” ");
INSERT INTO kpf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu zâk den zo sâm naŋgâm arâpŋâ diiniŋgi Yerusalem kamânân gâbâ gemŋâ Kidoroŋ too nirem hân ŋâi nak kâlam ŋâi zeip, zoren zâiwen. ");
INSERT INTO kpf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesu sot arâpŋâ, nen zoren âsâbâŋ mindumarâwengât Yuda zâk kâlam zo ekmâip. ");
INSERT INTO kpf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Zoren ândeindâ Yudaŋâ tirik namâ kâwali a sot a sâtŋâ nâmbutŋâ diiziŋgi gawe. Kembugât namâ galem a pâtâ sot Parisaio a, ziŋ sâŋgonzâŋgone gawe. ");
INSERT INTO kpf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Oi Yesu zâk kut ŋâi ŋâi okŋaŋgâbi, zo nâŋgâm arâpŋâ nâmbamŋâ âi mâsikâziŋgip, “Zen ŋâi kârum ge?” ");
INSERT INTO kpf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Sâi ziŋâ sâwe, “Yesu, Nasarete kamânân gokŋâ.” Sâne itâ sâm dâzâŋgoip, “Nâ zi.” Oi Yuda zâk kâwali a zen sot kirip. ");
INSERT INTO kpf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesuŋâ sâip, “Nâ zi.” Sâm dâzâŋgoi kândât kândât âim ge kom ziwe. ");
INSERT INTO kpf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yatâ utne du zagâtŋâ mâsikâziŋgip, “Zen ŋâi kârum ge?” Sâi ziŋâ sâwe, “Yesu, Nasarete kamânân gokŋâ.” ");
INSERT INTO kpf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Sâne Yesuŋâ itâ sâm dâzâŋgoip, “Nâ mârum dâzâŋguan. Nâ ko zi. Nâ kârunim ge oi ko arâpnâ zi birâziŋgâne âibi.” ");
INSERT INTO kpf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yatâ oi mârum den itâ sâip, zo bon oip, “A nigin, zen galem otziŋga mân tâmbetagowe.” ");
INSERT INTO kpf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Oi Simoŋ Peteroŋâ sâu mem ândeip, zo inzurân gâbâ sâmbum tirik namâ galem a, zâkkât kore a kindap bongen kârâm kwâkip. Kore a zorat kutŋâ Maiko. ");
INSERT INTO kpf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yatâ oi Yesuŋâ Petero itâ sâm dukuip, “Sâugâ inzurân pâna giarik. Dapkât uat? Dap nâŋgat? Sâknam Ibânandâ nâgât siŋgi sâip, zo birâbat?” ");
INSERT INTO kpf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Oi kâwali a sâtŋâ sot Yuda zeŋgât a sâtŋâ, zen Yesu gâsum bikŋâ saawe. ");
INSERT INTO kpf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Saamŋâ Hanasigât mirin diim zâiwe. Narâk zoren a ŋâi kutŋâ Kaipa, zâk Kembugât tirik namâ galem a zeŋgât patâziŋâ op ândeip. Kaipa zâk Hanasigât bâratŋâ meip. ");
INSERT INTO kpf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kâipa zâk mârum Yuda a sâtŋâ itâ sâm dâzâŋgoip, “A kâmut nen tâmbetagobemgât a kânokŋâ neŋgât hâuniŋâ moi âlip upap.” ");
INSERT INTO kpf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yesu diim âine Simoŋ Petero sot bukuŋâ ŋâi, zet bet moliziŋgâm âiwet. Oi bukuŋâ zâk tirik namâ galem a patâ ek nâŋgâmâip. Zorat Yesu molim âim ârândâŋ dâmân kâligen bagiwe. ");
INSERT INTO kpf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petero zâk ko pâit âkŋan mâtâbân kirip. Oi Bukuŋâ zâk tirik namâ galem a pâtâ ek nâŋgi ândeipkât mâtâp galem ambân dukoi mâtâp mem pâi Peteroŋâ pâit umŋan bageip. ");
INSERT INTO kpf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mâtâp galem ambân, zorâŋ Petero ekŋâ itâ sâm dukuip, “A ândiren zirat arâpŋâ zeŋgât kâmurân gokŋâ, gâ.” Sâi Peteroŋâ sâip, “Nâ buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sâi kore a sot kâwali a, zen pateŋ op kârâp om nâŋgâm kinetâ Petero zâk yatik osetziŋan kârâp nâŋgâm kirip. ");
INSERT INTO kpf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tirik namâ galem a patâŋâ Yesu diŋâ sâip sot arâpŋâ gâsuziŋgip, zorat sâm mâsikip. ");
INSERT INTO kpf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Mâsiki Yesuŋâ den itâ melâŋ dukuip, “Nâ den muyap sâman. Tirik namin sot mâpâmâpâse namin Yuda a ziŋ mindune dâzâŋgoman. Nâ tik mân sâman. ");
INSERT INTO kpf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Zorat gâ wangât nâ mâsikânigat? Den dâzâŋgua nâŋgâme, zo mâsikâziŋgâna dinnâ zo dâgone nâŋgâ.” ");
INSERT INTO kpf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yatâ sâi kâwali a kirâwe, zeŋgâren gâbâ a ŋâi Yesugât pâlomŋan komŋâ itâ sâip, “Gâ tirik namâ galem a patâ wangât den yatâ zo dukuat?” ");
INSERT INTO kpf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Sâi Yesuŋâ itâ sâip, “Den gâŋgoŋâ san oi ko zorat topŋâ sâna nâŋgâbâ. Nâ den târârak sa wangât nogat?” ");
INSERT INTO kpf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yesugât bikŋâ saane kiri Hanasiŋâ sâi tirik namâ galem a patâ Kaipa, zâkkâren diim âiwe. ");
INSERT INTO kpf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Oi Simoŋ Petero, zâk kârâp nâŋgâm kiri mâsikâm sâwe, “Arâpŋâ zeŋgâren gokŋâ ŋâi, gâ?” Sâne kwâimbâm sâip, “Nâ buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sâi tirik namâ galem a patâgât kore a ŋâi Peteroŋâ kindapŋâ kârâm kwâkip, zâkkât torenŋandâ itâ sâip, “Gâ kâlamân zâk sot ândina geksan.” ");
INSERT INTO kpf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Yatâ sâi Peteroŋâ dum kwâimbi zorenâk kurukŋâ diŋsâip. ");
INSERT INTO kpf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yuda zeŋgât hânân a kutâ ŋâi ândeip, kutŋâ Pilato. Zâk Roma zeŋgât kâmurân gokŋâ. Haŋgât ŋâtikŋâ Yesu zâk Kaipagât mirin gâbâ diim gem a kutâgâren âiwe. Pasowa kendongât sâkziŋ kubikkubik narâk oip, zorat itâ nâŋgâwe, “Hân ŋâin gokŋâ, zorat ko zâkkât namin zâinat, zo ko Anutuŋâ niŋgiri mân dâp upap.” Yatâ sâmŋâ a kutâgât namin mân zâiwe. ");
INSERT INTO kpf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sombemân kine a kutâ Pilatoŋâ mirâ gwenduin âi kin mâsikâziŋgip, “A zi wan tosagât diim ge?” ");
INSERT INTO kpf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Sâi ziŋâ sâwe, “A zi bâliŋ mâme mân ândei sâi gâgâren mân diim gabem” ");
INSERT INTO kpf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Sâne Pilatoŋâ itâ sâm dâzâŋgoip, “Wangât nâgâren diim ge? Ziiŋâ gurumin den ziap. Zo wâratkum ziiŋak sâm kwâkânek.” Sâi Yuda a sâtŋâ, ziŋ itâ sâwe, “Nen mumuŋan zâmbanzâmbanŋaŋgât mâtâp dooŋguwe. ");
INSERT INTO kpf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Sâna poru nagân kumbigât nâŋgen.” (A poru nagân zaŋgonzâŋgoŋ, zo Roma a zo ziiŋâ opmarâwe.) Yatâ sânetâ Yesu zikŋak poru nagân kune mumbapkât den mârum sâip, zo kâtigeip. ");
INSERT INTO kpf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatoŋâ namâ kâligen âim konsâi Yesu ari sâm mâsikip, “Gâ perâkŋak Yuda a zeŋgât a kutâ?” ");
INSERT INTO kpf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Sâi Yesuŋâ itâ sâm dukuip, Den zo gikâ umgât sat mo a nâmbutŋandâ dâgone sat?” ");
INSERT INTO kpf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Sâi Pilatoŋâ itâ sâm dukuip, “Nâgât dap dap nâŋgat? Nâ Yuda a? Gikâ kâmut sot patârâpkâ, zen nâgâren gâbanse. Gâ wan tosa oin?” ");
INSERT INTO kpf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yatâ sâi Yesuŋâ itâ sâm dukuip, “Nâ a kutâ ândiândi, zo ândian. Oi ko holinâ ŋâi yatâ ândian. Nâ hân a kutâ zen yatâ ândia sâi arâpnâ ziŋ kâmbam mem galem otnine Yuda a ziŋ mân gâsunim gabe. Nâ a kutâ holinâ ŋâi yatâ ândian.” ");
INSERT INTO kpf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sâi Pilatoŋâ sâm mâsikip, “Gâ gikaŋgât nâ a kutâ ândian sat?” Sâi Yesuŋâ sâip, “Sat, zo. Nâ a kutâ op hânân ge den bonŋâ sâm muyagibatkât âsagiwan. Ŋâi zâk dinnâ nâŋgâm lubap, zo ko den bonŋaŋgât buku upap.” ");
INSERT INTO kpf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Sâi Pilatoŋâ sâip, “Den bonŋâ, zo dap dap?” Yatâ sâmŋâ gwenduyân âi kin Yuda a itâ sâm dâzâŋgoip, “Nâ a zirât tosaŋâ kâruan. ");
INSERT INTO kpf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Zeŋgât orot mâme mâtâpŋâ ŋâi ziap. Zen Pasowa kendonân sânetâ a tâk namin ândine zeŋgâren gâbâ ŋâi olaŋ ziŋgâman. Oi zi nâŋgâne dâp oi Yuda a kutâziŋâ olaŋ ziŋga ândibap.” ");
INSERT INTO kpf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yatâ sâi Yuda a zen zâk den sâm kambâŋâ sâwe, “Zâk buŋâ. Baraba olaŋ niŋgâban.” Baraba zâk kâmbu kambâm a tâk namin pane ândeip. ");
INSERT INTO kpf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilatoŋâ Yesu diim namin zâimŋâ sâi kâwali a ziŋâ Yesu inzut kuupŋootŋâ lapirâwe. ");
INSERT INTO kpf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Zen lapitŋâ itâ sâwe. “Gâ nâ a kutâ sâmat, zorat a kutâgât pindok sot hâmbâ zi hutgonamen.” Yatâ sâmŋâ tâk sâtmam goŋkom kâukŋan pane giarip. Oi hâmbâ kuriŋâ, a kutâgât hâmbâ giŋaŋgâne giarip. ");
INSERT INTO kpf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Yatâ opŋâ um topŋan âi kin siŋan gem sâwe, “Oe, Yuda zeŋgât a kutâ.” Yatâ sâm bitziŋandâ si sâŋgânŋan kuwe. ");
INSERT INTO kpf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Oi Pilatoŋâ Yuda a zeŋgâren dum âi itâ sâm dâzâŋgoip, “Zen iknek. Nâ zeŋgâren diim gandâ ziiŋak topŋâ nâŋgânek. Nâ tosaŋâ kâruan.” ");
INSERT INTO kpf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Oi Yesu zâk kâukŋâ kâpiwe sot hâmbâ kuriŋâ, zo sot gem ga kiri Pilatoŋâ tirâpzâŋgom sâip, “A zi iknek.” ");
INSERT INTO kpf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sâi tirik namâ galem a patâ sot a sâtŋâ, zen ekŋâ den kambâŋ sâm sawe, “Zâk poru nagân kunek.” Sâne Pilatoŋâ sâip, “Nâ tosaŋâ kâruangât ziiŋak mem poru nagân kunek.” ");
INSERT INTO kpf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Sâi Yuda a ziŋ itâ sâwe, “Zikŋaŋgât nâ Anutugât nanŋâ sâmap. Zâk Anutu hutkum sâmap. A yatâ zo mumbigât gurumin dinniŋan ziapkât mumbap.” ");
INSERT INTO kpf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Yuda a sâtŋâ, ziŋâ Yesu zâk zikŋaŋgât nâ Anutugât nanŋâ sâmap sânetâ Pilatoŋâ zo nâŋgâm keŋgâtŋaŋgât oip. ");
INSERT INTO kpf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Oi Yesu diim mirâ kâligen âim mâsikâm sâip, “Gâ ikâ gâbâ âsagein?” Sâi Yesuŋâ den hâuŋâ mân sâip. ");
INSERT INTO kpf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yatâ oi Pilatoŋâ itâ sâm dukuip, “Gâ den mân dâtnobam uat? Nâŋâ sa ândiban. Nâŋâ sa poru nagân mumban. Zorat imbaŋâ niwe, zo nâŋgat?” ");
INSERT INTO kpf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Sâi Yesuŋâ itâ sâm dukuip, “Gâ yen sâi nâgât den mân sâbat. Nâgât den sâbangât Anutuŋâ ubâ imbaŋâ gigipkât sat. Oi zorat nâbanse, a zorat tosaziŋ gâgât zo walâwalâŋ.” ");
INSERT INTO kpf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sâi Pilatoŋâ den zo nâŋgâm Yesu olaŋbat sâm mâtâp kâruip. Kârui Yuda a ziŋ den sâm kambâŋ sâwe, “Gâ a zo olaŋâ a kutâ patâniŋâ Româ kamânân ândiap, kutŋâ Sisa, zâkkât buku mân op ândiban. Wangât, a zi zâk zikŋaŋgât nâ a kutâ sâmap. Zâk Sisa kâsa okŋaŋgâmap, zorat.” ");
INSERT INTO kpf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Yatâ sâne Pilatoŋâ den zo nâŋgâm sâi Yesu diim gine den sâm kwâkâkwâkâŋ tâtatŋan tâip. Oi tâtatŋâ zorat Yuda a ziŋâ ziiŋ denân Gabata sâmarâwe. (Niiŋ denân ko a patâ zeŋgât kiaŋ kâtŋâ tuutuuŋ.) ");
INSERT INTO kpf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Oi Yuda zeŋgât kendon patâ kutŋâ Pasowa, zo mâte oi kut ŋâi ŋâi kubikkubik narâk oi mirâ bâkŋan oi Pilatoŋâ tapŋâ Yuda a itâ sâm dâzâŋgoip, “Iknek. Zi a kutâziŋâ, zo ka.” ");
INSERT INTO kpf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sâi zen den sâm hoŋsâwe, “Zâk buŋ oik. Zâk buŋ oik. Poru nagân kunek.” Sâne Pilatoŋâ mâsikâm sâip, “A kutâziŋâ sa poru nagân kumbigât se?” Sâi Tirik namâ galem a patâ ziŋâ den itâ dukuwe, “Neŋgât a kutâ ŋâi buŋâ, Sisa kânok.” ");
INSERT INTO kpf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Sâne Pilatoŋâ nâŋgâziŋgâm Yesu poru nagân kumbigât ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kâwali a, zen Yesu gâsum poru nak pindâne lugi hân ŋâi kutŋâ kâuk siŋit (Yuda zeŋgât denân Goligata), zoren âiwe. ");
INSERT INTO kpf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Zoren diim âim poru nagân kuwe. Oi bâliŋ mâme a zâgât, ŋâi toren, ŋâi toren poru nagân zâkom kwânâŋgâzikâm Yesu osetzikŋan kwânâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatoŋâ sâi Yesugât kâuk kwâkŋan nagân den itâ kulemguwe, “Yesu Nasarete kamânân gokŋâ, Yuda zeŋgât a kutâ.” ");
INSERT INTO kpf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Den zo Yuda denân, Roma denân sot Grik denân kulemguwe. Yesu kuwe, hân zo kamân gootŋan zeipkât a ambân doŋbepŋâ âim gam den zo sâlâpkuwe. ");
INSERT INTO kpf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yuda zeŋgât tirik namâ galem a patâ, ziŋ Pilato itâ sâm dukuwe, “Yuda zeŋgât a kutâ mân kulemgu. Itâ kulemgu. Zikŋak itâ sâip, ‘Nâ Yuda zeŋgât a kutâ.’” ");
INSERT INTO kpf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Yatâ sâne Pilatoŋâ sâip, “Sâ kulemgue, zo yatik zeik.” ");
INSERT INTO kpf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kâwali a kimembut, ziŋ Yesu poru nagân komŋâ sâk pâke umŋaŋgât sâkŋaŋgât, zo mem kâsâpkum aŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Hâmbâ umŋan zorat itâ sawe, “Zo mânâŋgârindâ bâliŋ opap.” Yatâ sâm wenzu pam ikne muyageip dâp miwe. Yatâ utnetâ Kembugât ekabân den kulemguwe, zo bon oip. Den zo itâ, “Hâmbânâ kwâkŋan kâsâpkum miwe. Hâmbâ umŋan ko zorat wenzu pam ikne muyagei miwe.” Kâwali a zen yatâ urâwe. ");
INSERT INTO kpf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesugât poru topŋan ambân kirâwe, zo kutziŋâ itâ. Mamŋâ sot mamŋaŋgât gatŋâ. Maria, Kelopagât ambinŋâ sot Maria, Madala kamânân gokŋâ. ");
INSERT INTO kpf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu mamŋâ sot aŋâ nâ umŋandâ gâsunimap, net nikiri kiritâ mamŋâ itâ sâm dukuip, “Nangâ zi eknan.” ");
INSERT INTO kpf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yatâ sâmŋâ nâ itâ dâtnogip, “Mamgâ zi eknan.” Yatâ sâipkât narâk zorenâk Yesu mamŋâ diiga nâgât mirin topkwap tâtat mâme oip. Oi yatâ ândim gâip. ");
INSERT INTO kpf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesuŋâ nepnâ âkap nâŋgâm Kembugât ekabân den ziap, zo bon upapkât den itâ sâip, “Toogât otnigap.” ");
INSERT INTO kpf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Oi hâkop ŋâi umŋan winiga too kâlakŋâ zeip. Zoren âi saru kâmon zoren pam sâmbum kikerân sum kapiŋkum lâuŋan pane neip. ");
INSERT INTO kpf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu zâk too zo nemŋâ itâ sâip. “Mârum âkap.” Yatâ sâmŋâ kâuk pindiŋsâi kaapumŋâ taki moip. ");
INSERT INTO kpf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yuda zeŋgât kendon patâgât kubikkubik narâk oi itâ nâŋgâwe, “A zen kendonân poru nagân kinetâ mân dâp upap.” (Kendon zo Yuda zeŋgât kendon patâ.) Yatâ nâŋgâm Pilatogâren âi dukuwe, Kâwali a zen a poru nagân kirâwe, zeŋgât sooziŋ siŋit kom namuŋne mumbigât sot kâmbarâŋziŋâ mâkâm hanzâŋgobigât Yuda a nâŋgâziŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Oi kâwali a zen bâliŋ mâme a zagât zo soozik siŋit kom namuŋâwe. ");
INSERT INTO kpf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yatâ opŋâ Yesugâren ga igâwe. Zâk mârum moip. Yatâ ekŋâ sooŋâ siŋit mân kom namuŋâwe. ");
INSERT INTO kpf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kâwali a ŋâiŋâ Yesu parâmŋan kâlâuŋâ sum kwâpârâŋgi gilâm sot too gem gâip. ");
INSERT INTO kpf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nâ zo egâwangât perâkŋak san. Nâ nâŋgan, den zo bonŋâ. Zorat zen nâŋgâne bon upap. ");
INSERT INTO kpf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kembugât ekabân mârum itâ kulemguwe, zo bon upapkât urâwe. Den zo itâ, “Zen siŋitŋâ mân kom namuŋbi.” ");
INSERT INTO kpf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Oi Kembugât ekabân den ŋâi itâ ziap, “Zen sum pâroŋ parâwe, zâkkâren sen kwap ikpi.” ");
INSERT INTO kpf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kwâkŋan Yosepe, Arimataia kamânân gokŋâ, zâkŋâ Pilatogâren âimŋâ Yesugât kâmbarâŋ mâkâbapkât sâip. Sâi Pilatoŋâ nâŋgâŋaŋgi âi kâmbarâŋ mem ârip. (Mârum Yosepe zâk Yesugât a ândeip. Ka zâk Yuda a sâtŋâ zeŋgât keŋgât op zo muyap mân sâm ândeip.) ");
INSERT INTO kpf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Oi a ŋâi mârum ŋâtigân Yesugâren gâip, kutŋâ Nikodemo, zâk kelâk hitom âlip top ŋâi zagât mâporâwe, irâ patâ kât mimiŋ yâmbâtŋâ, zo yatâ zo mem âim Yosepe bekŋan meip. ");
INSERT INTO kpf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bekŋan mei Yesugât kâmbarâŋ saŋgonŋâ sâŋgum kâu sot kelâk hitom âlipŋâ, zorâŋ kâpiwet. Yuda a ziŋ yatâ opmarâwe. ");
INSERT INTO kpf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Oi Yesu kuwe, hân zorat ginŋan nak kâlam ŋâi zeip. Zoren kât mâtâp kwâpârâŋgâne zeip. Zoren a ŋâi mârum mân zâmbarâwe. Narâk zoren Yuda zeŋgât kendon patâ mâte oipkât Yesugât kâmbarâŋ zo pâŋkânogân zo parâwet. ");
INSERT INTO kpf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","(-) ");
INSERT INTO kpf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yuda zeŋgât kendon âki haŋgât ŋâtikŋâ Maria, Madala kamânân gokŋâ, zâk Yesugât kwagân arip. Âi takâm egi kât patâ mâtâp mârum dooŋguwet, zo kâbakŋine zeip. ");
INSERT INTO kpf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yatâ ekŋâ sârârâk kârâm âim Simoŋ Petero sot Yohane, nâ Yesuŋâ umŋandâ gâsunimap, net muyagenikâm dâtnâkom sâip, “Kembugât kâmbarâŋ, zo kwagân gâbâ mem arie. Oi ikâ âi pe, zo nen mân nâŋgen.” ");
INSERT INTO kpf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yatâ sâi Petero sot bukuŋâ nâ, net mirin gâbâ gemŋâ kwagân âiwet. ");
INSERT INTO kpf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mâtâbân sârârâk kârâm âim nâŋâ Petero walâm kek âim kândon takâwan. ");
INSERT INTO kpf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Âi takâm kât mâtâpŋan mân bagim yen pindiŋsâm eksa sâŋgumâk zei egâwan. ");
INSERT INTO kpf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoŋ Petero, zâk bet gamŋâ kât mâtâpŋan bagim sâŋgumâk zei egip. ");
INSERT INTO kpf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Sâŋgum ŋâi Yesugât kâukŋâ kâpiwet, zo zei egip. Sâŋgum zo sâŋgum nâmbut zen sot mân zeip. Zikŋik kâpiyagom zeip. ");
INSERT INTO kpf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yatâ zei kândom kwagân âi takâwan, nâŋâ bagimŋâ yatik ek, zaatsap zo bonŋâ sâm zo nâŋgâwan. ");
INSERT INTO kpf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ombeŋan ândiwenân Yesu mumuŋan gâbâ zaatpapkât Kembugât ekaban den ziap, zo mân nâŋgâm kwâtâtiwen. ");
INSERT INTO kpf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yatâ ekŋâ a zagât net kamânân âburem âiwet. ");
INSERT INTO kpf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria zâk kwak sâtŋan kin iseip. Isem tap ko pindiŋsâmŋâ kwagân egip. ");
INSERT INTO kpf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Egi sumbem a zagât hâmbâzik kâukâu Yesu mârum zeibân zo tâitâ zikirip. Ŋâi zâk kâukŋâ zeibân, ŋâi kiŋâ zeibân tarâwet. ");
INSERT INTO kpf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Oi zikŋâ sâwet, “Ambân, gâ wangât isem taat?” Sâitâ zâkŋâ sâip, “Kembunaŋgât kâmbarâŋ mem ŋâin âine kâruan.” ");
INSERT INTO kpf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Yatâ sâm puriksâm Yesu zikŋâ egip. Egip, zo Yesu holiŋâ mân ek nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Oi Yesuŋâ mâsikâm sâip, “Ambân, gâ wangât isiat? Ŋâi kârum taat?” Oi Mariaŋâ a zo kâlam mariŋandâ kinzap nâŋgâm itâ sâm dukuip, “Patânâ, gâ kâmbarâŋâ mem ŋâin âi paat oi ko sâna nâŋgâm âi mimbat,” ");
INSERT INTO kpf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sâi Yesuŋâ sâip, “Maria.” Sâi puriksâm Yuda denân Raboni sâip (niiŋ denân ko, Patânâ). ");
INSERT INTO kpf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesuŋâ itâ sâm dukuip, “Irabot Ibâgâren zâibâman. Ibâgâren mân zariangât gâ mân gâsum aŋgân kârâniban. Gâ âi bukurâpnâ itâ sâm dâzâŋgo, ‘Nâgât Ibâ, zeŋgât Ibâ, nâgât Anutu, zeŋgât Anutu, zâkkâren zâibâman.’” ");
INSERT INTO kpf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria, Madala kamânân gokŋâ, zâk âburem kamânân âimŋâ arâpŋâ itâ sâm dâtnâŋgoip, “Nâ Kembu eksan.” Yatâ sâmŋâ Yesuŋâ den sâip, zo arâpŋâ dâtnâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sirâm zoren ŋâtiksâi arâpŋâ nen Yuda a sâtŋâ zeŋgât keŋgât op mirin mindum mân gabigât mirâ mâtâp dooŋgumŋâ tarâwen. Tâindâ Yesu zâk osetniŋan âsagem kin itâ sâm dâtnâŋgoip, “Um lumbe zeŋgâren zimbap.” ");
INSERT INTO kpf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yatâ sâmŋâ bikŋâ toren toren sot parâmŋâ, zo tirâpnâŋgoip. Oi arâpŋâ nen Kembu ekŋâ umniŋ âlip oip. ");
INSERT INTO kpf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesuŋâ dum zagâtŋâ dâtnâŋgoip, “Um lumbe zeŋgâren zimbap. Ibânandâ sâŋgonnogip, yatik nâŋgoot zen sâŋgonzâŋguan.” ");
INSERT INTO kpf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yatâ sâmŋâ waatniŋgâm sâip, “Tirik Kaapum minek. ");
INSERT INTO kpf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Zen a zeŋgât tosaziŋ birânetâ buŋ upap. Ka tosaziŋ zimbapkât sâne zemziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesu arâp kiin zagât, neŋgâren gokŋâ ŋâi kutŋâ Toma (Zâk booboo a konsâwen.) zâk ŋâin âi ândei Yesugât arâpŋâ, nen minduindâ muyageniŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Oi bet a bukurâpŋâ nen siŋgi zo Toma itâ sâm dukuwen, “Nen Kembu iksen.” Yatâ sâindâ Tomaŋâ itâ sâm dâtnâŋgoip, “Ninak sinnandâ ekŋâ bikŋan gutŋâ sâlâpnandâ pamŋâ parâmŋan gâsum dinziŋâ nâŋga bon upap.” ");
INSERT INTO kpf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yatâ sâi ko bet ândim nâŋgâ kânok zoren Yesu arâpŋâ, nen Toma sot ârândâŋ mindum mirâ mâtâp dooŋgumŋâ tarâwen. Tâindâ Yesuŋâ osetniŋan muyagem kin itâ sâm dâtnâŋgoip, “Um lumbe zeŋgâren zimbap.” ");
INSERT INTO kpf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yatâ dâtnâŋgomŋâ Toma itâ dukuip, “Toma, sâlâpkâ ziren pânan. Bitnâ gâsum ek. Bikâ pam parâmnan weenan. Oi gâ um zagât mân op nâŋgâm pâlâtâŋ kwatni.” ");
INSERT INTO kpf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Sâi Tomaŋâ sâip, “Gâ Kembunâ sot Anutunâ.” ");
INSERT INTO kpf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Sâi Yesuŋâ dukuip, “Gâ neksatkât nâŋgâm pâlâtâŋ kwatnigat? A zen mân nekŋâ nâŋgâm pâlâtâŋ kwatnime, zeŋgât nâŋga sâtâreŋoot uap. ");
INSERT INTO kpf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuŋâ arâpŋâ nen sot tap kulem top top tuugip, torenŋâ zo ekap ziren mân kulemguwan. ");
INSERT INTO kpf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Den kulemguwan, zo itâgât kulemguwan. Zen sâlâpkum nâŋgâm Yesu zâk a bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, Anutugât nanŋâ. Den zo nâŋgâne bon upap. Oi zikŋâ nâŋgâm pâlâtâŋ kwâkŋaŋgâm kutsiŋgiŋaŋgât opŋâ ândiândi kâtik mimbi. ");
INSERT INTO kpf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ândim Yesuŋâ arâp neŋgâren dum muyageniŋgip. Tiberia saruyân itâ muyageniŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoŋ Petero, Toma (booboo a), Natanae, Kana kamân Galilaia hânân gokŋâ, Zebedaiogât nanzatŋâ Yakobo sot munŋâ nâ sot arâpŋâ nâmbutŋâ zeŋgâren gâbâ a zagât. A yatâ zo mindum ândiwen. ");
INSERT INTO kpf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ândeindâ Simoŋ Peteroŋâ itâ sâm dâtnâŋgoip, “Nâ saru zuu mimbam âibâman.” Sâi niŋâ sâwen. “Nen ârândâŋ.” Sâmŋâ âi waŋgâyân zâim ŋâtik zoren zuugât nep tuum ândim mân muyagiwen. ");
INSERT INTO kpf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sâruyân ândeindâ mirâ haŋsâbam oi Yesuŋâ sagân ga kirip. Kiri Yesu tobatŋâ mân ek nâŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Oi Yesuŋâ mâsikâniŋgâm sâip, “Katep, zen zuu ŋâi mie?” Sâi niŋâ sâwen, “Buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Sâindâ itâ sâm dâtnâŋgoip, “Irâ zo bongen pane giari saru zuu doŋbep sândubi.” Sâi irâ pâindâ giari saru zuu doŋbep patâ gam geine sâmbum osiwen. ");
INSERT INTO kpf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesu umŋandâ gâsunimap, nâŋâ Petero itâ dukuwan, “Zo Kembu.” Sa Petero zâk Kembu kutŋâ nâŋgâm nepkât sâŋgumâk lap ândeipkât hâmbâŋâ mem hurâgum saruyân pâtan arip. ");
INSERT INTO kpf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nen kârebân mân ândiwen. Sak gootŋan ândiwen. Arâpŋâ nâmbutŋâ, nen waŋgâyâk sâtŋan âinam zuu sot irâ, zo diigindâ tâi âiwen. ");
INSERT INTO kpf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Sagân zâimŋâ kut ŋâi ŋâi itâ muyagiwen. Kârâp sisiŋan saru zuu sot nalem sem zeip. ");
INSERT INTO kpf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Âi takindâ Yesuŋâ itâ sâm dâtnâŋgoip, “Zuu mie, zo torenŋâ mem ganek.” ");
INSERT INTO kpf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sâi Simoŋ Petero, zâk waŋgâyân zâim zuu irâ zo sâmbui sagân gâip. Oi irin zo zuu patâ patâ doŋbep 153 yatâ, zo ziwe. Oi irâ zo mân âmbârâŋgip, zorat nâŋgindâ metŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuŋâ itâ sâip, “Zen ga nalem ninek.” Sâi arâpŋâ nen dap yatâ mâsikâbem, “Gâ ŋâi.” Nen Kembu zo nâŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Oi Yesuŋâ neŋgâren gamŋâ nalem sot zuu kâsâpkum niŋgip. ");
INSERT INTO kpf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Zo Yesu mumuŋan gâbâ zaatŋâ muyageniŋgi sâp karâmbut oip. ");
INSERT INTO kpf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Haŋgât nalem neindâ ko Yesuŋâ Simoŋ Petero itâ sâm mâsikip, “Simoŋ, Yohanegât nanŋâ, Bukurâpkâ zi, zen umziŋandâ gâsânome. Gâŋâ walâziŋgâm umgandâ gâsânomat?” Sâi Peteroŋ sâip, “Kembu, Nâ gâgât otnimap, zo nâŋgat.” Sâi Yesuŋâ dukuip, “Gâ râma gwamŋâ gakârâpnâ galem otziŋgâban.” ");
INSERT INTO kpf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yatâ sâm dum mâsikip, “Simoŋ, Yohanegât nanŋâ, gâ perâkŋak umgandâ gâsânomat?” Sâi Peteroŋâ sâip, “Kembu, nâ gâgât otnimap, zo nâŋgat.” Sâi Yesuŋâ dukuip, “Râma gakârâpnâ zeŋgât galem otziŋgâm ândiban.” ");
INSERT INTO kpf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yatâ sâm dum mâsikip, “Simoŋ, Yohanegât nanŋâ, gâ perâkŋak nâgât otgimap?” Yesuŋâ sâp karâmbut den yatâ sâi ko Petero umŋâ bâlei sâip, “Kembu, gâ kut ŋâi ŋâi zo nâŋgâm nâŋgâmat. Oi nâ gâgât otnimap, zo nâŋgat.” Sâi Yesuŋâ sâip, “Gâ râma gakârâpnâ galem otziŋgâm ândiban. ");
INSERT INTO kpf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nâ perâkŋak dâgobâ. Gâ sigan ândim zoren mo zoren âibam otgigi âimâin. Oi bet ko gâ sombâ opŋâ bikâ pâna kâsarâpkâ ziŋ saagim gobi.” ");
INSERT INTO kpf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesuŋâ zo yatâ sâm Petero mumbapkât den dukuip. Mumbap, zoren a ziŋâ ekŋâ Anutu sâm âlip kwâkŋaŋgâbigât nâŋgâm sâip.) Den yatâ sâm dukuip, “Gâ molini.” ");
INSERT INTO kpf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Oi Petero zâk puriksâm a Yesu umŋandâ gâsunimap, nâ kândâtŋan ga negip. Mârum Yesu mân mom arâpŋâ nen sot nalem neip, narâk zoren nâ Yesu gootŋan âi itâ mâsikâwan, “Kembu, ŋâiŋâ sâi gâsâgobi?” ");
INSERT INTO kpf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Oi nâ bet ga Peteroŋâ nekŋâ Yesu nâgât mâsikâm sâip, “Kembu, a zirâŋ dap upap?” ");
INSERT INTO kpf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Mâsiki Yesuŋâ itâ sâm dukuip, “Zâk ândei nâ puriksâbat mo zâk ândim mumbap, zorat gâ zâkkât wangât sat? Gâ yen ga molini.” ");
INSERT INTO kpf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yatâ sâi ko arâpŋâ sot bukurâpziŋ Yohane nâgât itâ sâm gulipkuwe, “A zo mân mumbap.” Ka Yesu zâk nâgât yatâ mân sâip. Zâkŋâ itâ sâip, “Zâkŋâ ândei âburibat mo ândim mumbap, zorat gâ wangât zâkkât sat?” ");
INSERT INTO kpf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A zorâŋ kut ŋâi ŋâi zo ek nâŋgâm sâm muyagem ekap zi kulemgoip. Zâk kwembiŋ den kulemgoip. Oi nen zâkkât itâ nâŋgâmen, “Diŋâ zo bonŋâ.” ");
INSERT INTO kpf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuŋâ kut ŋâi ŋâi doŋbep oip, zo ekabân mân kulemguwen. Zo ekabân kulemgum naŋgindâ sâi hân zi piksâi a ziŋ mân sâlâpkum nâŋgâbe. Zo yatik. ");
INSERT INTO kpf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Teopilo, nâ mârum den kulemgum giwan, zo Yesu nep tuugip sot siŋgi âlip sâip, zorat den siŋgi otgiwan. ");
INSERT INTO kpf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Zâkŋâ nepŋâ topkwap tuum âim sumbemân zâibapkât narâkŋâ mâte oi Tirik Kaapumŋâ okŋaŋgi Aposolo mârum gâsum sâlâpzâŋgoipŋâ nep diŋ sâm ziŋgip. Den zo dâzâŋgom naŋgi Anutuŋâ diim sumbemân zarip. Zorat den siŋgi mârum kulemguwan. ");
INSERT INTO kpf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Zâk sâknam nâŋgâm mom zem zaatŋâ arâpŋâ zen sot sirâm 40, zorat umŋan âsageziŋgâm ândeip. Zen nâŋgâm pâlâtâŋ kwâkŋaŋgâbigât âsageziŋgâm ândeip. Anutu um topŋan ândiândiŋaŋgât den dâzâŋgom ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Oi zen sot tapŋâ den itâ sâm dâzâŋgoip, “Zen Yerusalem kamân mân birâbi. Ibânandâ kut ŋâi ziŋgâbap, zorat mambât ândibi. Zorat den itâ sâm dâzângowan. ");
INSERT INTO kpf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohane zâk too saŋgonziŋgip. Ka narâk mân kârep oi nâŋâ Tirik Kaapum saŋgonziŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yatâ sâi mindum ândiwe, zen itâ sâm mâsikâwe, “Kembu, gâ narâk ziren kâsarâpniŋâ moliziŋgâna Isirae niiŋak dum a kutâ op ândinat?” ");
INSERT INTO kpf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Sâne itâ sâm dâzâŋgoip, “Ibâ, zâk ziŋâ narâkŋâ nâŋgâbigât mân sâip. Ibâ, zâk kâwali imbaŋâŋaŋgât opŋâ narâk zo pâip. Ziŋâ zo mân nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Zâkŋâ Tirik Kaapum sâŋgongoi zeŋgâren gem gam imbaŋâ ziŋgi zen nâgât den siŋgi sâsâŋ a upi. Yatâ opŋâ Yerusalem kamânân sot Yudaia hânân sot Samaria hânân sot hân kârebân aksik, nâgât den siŋgi zeŋgâren sâne laŋ kârâm âibap.” ");
INSERT INTO kpf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Den yatâ sâi iknetâ sumbemân zarip. Zari unumunumŋâ ga dooŋgoi mem zari mân igâwe. ");
INSERT INTO kpf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Oi sumbemân zari arâpŋâ zen tok ek kine a zagât hâmbâzik kâukâu, zet zeŋgâren âsagem kirâwet. ");
INSERT INTO kpf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Oi itâ sâm dâzâŋgowet, “Galilaia gokŋâ, zen wangât sumbemân ek kinze? Anutuŋâ Yesu mem sumbemân zariap. Yesu zariap, zo yatik âburem gibap.” ");
INSERT INTO kpf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aposolo zen Oliwa bâkŋan gâbâ gem âburem Yerusalem kamânân âiwe. Bakŋâ zo Yerusalem kamân gootŋan taap. ");
INSERT INTO kpf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kamânân âimŋâ mirâ tâpmarâwe, zoren zâiwe. A kutziŋâ itâ, Petero, Yohane, Yakobo, Andrea, Pilipo, Toma, Batolomaio, Mataio, Yakobo Alipaiogât nanŋâ, Simoŋ Zelote sot Yuda Yakobogât nanŋâ. ");
INSERT INTO kpf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","A zo aksik um kânok op ninâu sâm ândiwe. Yatâ utne Yesu mamŋâ Maria sot ambân nâmbutŋâ sot Yesu murâpŋâ, zen aksik betziŋan mem ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Narâk zoren Yesu a ambân kâmurâpŋâ ândiwe, 120 yatâ, zorâŋ mindum tarâwe. Oi Peteroŋâ zaat den itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Bukurâp, Yudaŋâ kâsa diiziŋgi Yesu gâsuwe. Zorat mârumŋan Tirik Kaapumŋâ Dawidigât umŋan den pâi den zo sâm Kembugât ekabân kulemgoip. Zo dap op yen zembap? ");
INSERT INTO kpf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda zâk niiŋan gokŋâ. Nen sot nep ârândâŋ meip. ");
INSERT INTO kpf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Oi a zorâŋ kâmbamgât sâŋgânŋâ mem hân ŋâi kwâlip. Zoren âi hânân gei kom kâmboŋ kunziri zem tip gem naŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Den siŋgi zo Yerusalem a ambân ziŋ aksik nâŋgâm hân zorat kutŋâ Akedama sâwe (niiŋ denân ko kâmbam hân). ");
INSERT INTO kpf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Psalm ekabân den itâ kulemgune ziap, ‘Zâkkât mirâ kamân kwamen zimbap. Zoren a ŋâi mân ândibap.’ Oi den ŋâi itâ ziap, ‘Zo a ŋâiŋâ gebâkŋan kinbap.’ ");
INSERT INTO kpf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Oi a nâmbutŋâ nen sot ândimŋâ Kembu Yesuŋâ nep tuugip, zo ek naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Oi Yohanenŋâ too saŋgonŋaŋgi nepŋâ topkwâip, narâk zoren zâkkâren târokwap ândeindâ ândim sumbemân zarip. Oi a zo zeŋgâren gâbâ a ŋâi, zâk betniŋan mei Yesu mom zaarip, zorat den siŋgi sâindâ laŋ kârâbap.” ");
INSERT INTO kpf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Peteroŋâ yatâ sâi a zagât muyagezikâwe. Ŋâi kutŋâ Yosepe Basaba sâmarâwe, kutŋâ ŋâi Yusito. Oi a ŋâi ko kutŋâ Matia. ");
INSERT INTO kpf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Muyagezikâm itâ sâm ninâu sâwe, “O Kembu, a zeŋgât umziŋâ ek nâŋgâmat. A zagât zi, zekâren gâbâ ŋâi gâsum sâlâpkuat, zo tirâpnâŋgona iknâ. ");
INSERT INTO kpf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yudaŋâ Aposolo nepŋâ kwâkâm mâtâp bâliŋan arip, zorat ŋâiŋâ zâkkât gebâkŋan ândibap.” ");
INSERT INTO kpf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ninâu yatâ sâmŋâ wenzu pane Matiagât âsagei Aposolo kiin kânok târokwatziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yuda zeŋgât kendon ŋâi kutŋâ Pentekos narâk oi Yesugât a ambârâpŋâ zen mirâ kânogân mindum tarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tatne sumbemân gâbâ kwamit ŋâi pibâ patâ kwamit yatâ kwamiragom geip. Gemŋâ mirâ tarâwe, zoren zâi piksâip. ");
INSERT INTO kpf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Zen tap iknetâ kârâp bâlam yatâ âsagem âbâŋgum kâukziŋan ge tap arip. ");
INSERT INTO kpf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Oi Tirik Kaapumŋâ umziŋan gei piksâm imbaŋâ ziŋgi den gându ŋâi ŋâi sâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Narâk zoren Yerusalem kamânân a hân dâp ga ândiwe. A zo, zen Anutu mâpâsemarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Oi a doŋbep patâ zen kwamit zo nâŋgâm mindune Aposolo zen dinziŋâ dâp sâne nâŋgâm kwakmak op kirâwe. ");
INSERT INTO kpf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Oi imbaŋâziŋ buŋ oi itâ sâwe, “A den se, zen aksik Galilaia a. ");
INSERT INTO kpf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Dap op den yatâ sâne nâŋgindâ dinniŋâ yatâ uap? ");
INSERT INTO kpf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nen zi Mende a, Pata a, Elam a, Mesopotamia hânân gok, Yudaia hânân gok, Kapadosia hânân gok, Ponto hânân gok, Asia hânân gok. ");
INSERT INTO kpf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pirigia hânân gok, Pampilia hânân gok, Aigita hânân gok, Libia hânân Kirene zeŋgât kamân goot goot, zoren gok. Nâmbutŋâ nen Roma kamânân gok. ");
INSERT INTO kpf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Oi nen Isirae sot kamân ŋâin gâbâ Anutu mâpâsimen. Nâmbutŋâ nen Keret a sot Arabia a. Nen yatâ zorâŋ ândimŋâ dinniŋâ dâp Anutu kut ŋâi ŋâi âlipŋâ oip, zorat siŋgi sâne nâŋgen.” ");
INSERT INTO kpf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","A zen yatâ sâm imbaŋâziŋ buŋ oi kwakmak op kin âragum sâwe, “Zi topŋâ dap yatâ?” ");
INSERT INTO kpf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Oi a nâmbutŋandâ mem ge kwâkwat den itâ sâwe, “A zi too kâtik nem um gulip op se.” ");
INSERT INTO kpf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petero zâk bukurâpŋâ kiin kânok, zen sot kin den kâtikŋâ itâ sâm dâzâŋgoip, “Yerusalem kamân mâirâp sot Yuda a nâmbutŋâ, zen aksik nâ den sa kindap kwap nâŋgânek. ");
INSERT INTO kpf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","A zi kinze, zeŋgât itâ se, ‘Too kâtik nemŋâ um gulip ue.’ Yatâ buŋâ. Mirâ mân kâtigei nen dap op too kâtik nimbem. ");
INSERT INTO kpf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Zorat Propete Yoeleŋâ den ŋâi itâ sâm kulemgoip. Den zo bonŋâ muyagiap, ");
INSERT INTO kpf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Anutuŋâ itâ sap, “Gâtâm hângât narâk âkâbâ sâi nâ Kaapumnâ a ambân aksik ziŋgâbat. Ziŋga ko nan bârarâpziŋâ zen Propete ziŋâ den sâme, zo yatâ sâbi. A sigan, ziŋâ kut ŋâi ŋâi sen mârât ikpi. A ambân sombâ, ziŋâ uman bonŋâ nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Narâk zoren kore a ambân gakânâ Kaapum ziŋga Propete a yatâ op den sâbi. ");
INSERT INTO kpf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Oi nâ sa sumbemân sen pup kulem muyagibap. Ombeŋan hânân top lâkulâku kulem muyagibap. Gilâm sot kârâp sot kâbak, zorâŋ hân kwârakubap. ");
INSERT INTO kpf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mirâsiŋ sumunkumbap. Kâin siŋâ kuriŋkom gilâm yatâ upap. Oi Kembugât narâk mâte upap. Kembugât narâk âlipŋâ âsakŋoot muyagibap. ");
INSERT INTO kpf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Oi narâk zoren ŋâi zâk Kembu konsâbap, zâk bâliŋan gâbâ mâkâbap.” ’” ");
INSERT INTO kpf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Yatâ sâmŋâ Peteroŋâ itâ sâip, “Isirae a, nâ dâzâŋgua nâŋgânek. Anutuŋâ Yesu Nasarete kamânân gokŋâ mam okŋaŋgi osetniŋan ândim nep patâ sot sen mârât kulem tuugip. Zâk Anutugâren gâbâ gâip. Nep tuugip, zorâŋâ topŋâ sâm muyagei igâwe. ");
INSERT INTO kpf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mârum Anutuŋâ zâkkât nâŋgi zeipkât mâtâp zo sâm pindip, zo yatik zen kut ŋâi ŋâi okŋaŋgâm Kembugât gurumin den kukuŋ a ziŋgâne âi poru nagân kune moip. ");
INSERT INTO kpf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ka Anutuŋâ mumuŋaŋgât tâk olaŋ diim sumbemân zarip. Mumuŋandâ dap yatâ aŋgân kârâbap? ");
INSERT INTO kpf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Zorat Dawidiŋâ zâkkât den kânŋan sâm itâ kulemguip, ‘Nâ Kembu mâteyâk ek ândiwan. Zâkŋâ âsâbâŋ bitnâ bongen tâi mân loribat. ");
INSERT INTO kpf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Zorat ko umnâ âlip oi nâmbâlamnandâ sâm sâtâre okŋaŋgâman. Sâknandâ mom zaatpapkât mambât ândibat. ");
INSERT INTO kpf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Anutuŋâ, Gâ mân birâniban, zorat ko mumuŋâ zeŋgâren mân âi ândibat. Gâ tirik agâ mân birâniban, zorat ko momŋâ mân alâgibat. ");
INSERT INTO kpf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gâ ândiândiŋ mâtâp tirâpnogin. Mâtegan ândia otninandâ sâtâre kwâkŋan ândibat.’” ");
INSERT INTO kpf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Peteroŋâ yatâ sâmŋâ itâ sâip, “O bukurâpnâ, nâ sâkuniŋâ Dawidi, zâkkât den sapsum ziŋgâbâ. Zâk moi hanguwe. Oi kwakŋâ ek nâŋgâm ândime. ");
INSERT INTO kpf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Zâk Propete a ândim itâ nâŋgip, ‘Anutu zâk kiurâpnâ zeŋgâren gâbâ ŋâi gâsum sâlâpkoi nâgât a kutâ tâtarân tâpapkât sâm kâtigeip.’ ");
INSERT INTO kpf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Zo nâŋgâm Kristo zaatzaatŋaŋgât itâ sâip, ‘Zâk mumuŋâ zeŋgâren ândibapkât Anutuŋâ mân birâbap. Momŋâ sâkŋâ mân alâgibap.’ ");
INSERT INTO kpf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Oi Anutuŋâ Yesu mâŋgei zaari sinniŋandâ igâwen. ");
INSERT INTO kpf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Oi Anutuŋâ Yesu âsanŋâ bongen a kutâ kwânâŋgi tâi Tirik Kaapum siŋgi kwatniŋgip. Yesuŋâ zo mem niŋgi kwamit nâŋgâm ikse. ");
INSERT INTO kpf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawidiŋâ sumbemân mân zarip op ko laŋ den itâ sâip, ‘Kembuŋâ nâgât kembu itâ sâm dukuip, “Nâgât âsannan tâtnan. ");
INSERT INTO kpf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Tâtna kâsarâpkâ minduziŋga kiŋgaŋgât kombâŋ upi.” ’ ");
INSERT INTO kpf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Isirae a aksik patâ itâ nâŋgâbi. Yesu poru nagân kuwe, zâk Anutuŋâ Kembu sot a bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, Kristo, kwânâŋgi ândiap.” ");
INSERT INTO kpf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Peteroŋâ den yatâ sâm dâzâŋgoi nâŋgâm umziŋ bâliŋ oi Petero sot bukurâpŋâ itâ sâm mâsikâziŋgâwe, “Bukurâpniŋ, nen dap oindâ dâp upap?” ");
INSERT INTO kpf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Sâne Peteroŋâ itâ sâm dâzâŋgoip, “Umziŋ melâŋne Yesu Kristogât korân too saŋgonziŋgindâ tosaziŋ buŋ upap. Yatâ utne Anutuŋâ Tirik Kaapum ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ziiŋâ sot kiurâpziŋâ sot kârebân ândie, Kembu Anutuŋâ diiziŋgâbap dâp, Tirik Kaapum zeŋgât siŋgi sâsâŋ, zo ziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petero zâk den yatâ sâm den târokwap den girem itâ sâm dâzâŋgoip, “Zen bâliŋ mâme a osetziŋan gâbâ gane Anutuŋâ gâsuziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Sâi sirâm zoren a ambân 3 tausen yatâ, ziŋâ Peterogât den nâŋgâm umziŋâ gâsui too saŋgonziŋgâne Yesugât kâmut, zeŋgâren târokwarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Oi Aposolo, zen siŋgi âlip dâzâŋgone nâŋgâm ândiwe. Oi umziŋâ gâsâyagom ninâu sot nalemgât âsâbâŋ mindumarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Oi Aposolo ziŋ Yerusalem kamânân sen mârât kulem top top tuumarâwe. Oi a ambân, zen aksik keŋgât op naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yesu nâŋgâm pâlâtâŋ kwâkŋaŋgâwe, zen kut ŋâi ŋâiziŋâ kânogâk zeip. ");
INSERT INTO kpf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Oi hân sot sikumziŋ pane sâŋgân mem a gigiŋâ kâsâpkum ziŋgâmarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Zen sirâmŋâ sirâmŋâ um kânok op tirik namin zâi mindumarâwe. Oi mirâziŋan nalem ârândâŋ nemarâwe. Oi nalem zo sâtâreyân nemarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Oi Anutu sâm âlip kwâkŋaŋgâwe. Yatâ utne a ambân, zen ziŋgit umâlep urâwe. Oi Kembu zâk sirâmŋâ sirâmŋâ a ambân Yesugât kâmurân târokwatziŋgâmâip. ");
INSERT INTO kpf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sirâm ŋâin mirâ oi, ninâu sâsâŋ narâk oi Petero sot Yohane, zet tirik namin zâiwet. ");
INSERT INTO kpf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Oi a ŋâi mam kâmboŋ kâligen gâbâ kiŋ bâliŋâ âsageip, zâk lum gawe. A zo bukurâpŋâ sirâmŋâ sirâmŋâ lum tirik namâ mâtâp âlipŋâ, hikpârâkŋoot, zoren pane kât sikumgât oletziŋgâmâip. ");
INSERT INTO kpf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Oi Petero sot Yohane zet tirik namin zâiram oitâ zikitŋâ oletzikip. ");
INSERT INTO kpf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Oletziki zet ek kin Peteroŋâ itâ sâm dukuip, “Gâ net nikit.” ");
INSERT INTO kpf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Peteroŋâ sâi kât niram sabot sâm sen kwap zikirip. ");
INSERT INTO kpf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Yatâ oi Peteroŋâ itâ sâm dukuip, “Kât sikum mân zemnigap. Kut zi kânok zemnigap, zo gibâman. Yesu Kristo, Nasarete gokŋâ, zâkkât sâtkât dâgoga zaat âim ga.” ");
INSERT INTO kpf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yatâ sâm bikŋâ bongen gâsum zaarip. Yatâ oi zorâŋak kiŋ bâliŋ zo winziksâi zaat kirip. ");
INSERT INTO kpf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Zaat âim gam kin ko zet sot ârândâŋ tirik namin zâiwe. A kiŋ bâliŋ zo pâtan âim gam Anutu sâm âlip kwâkŋaŋgip ");
INSERT INTO kpf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Anutu sâm âlip kwâkŋaŋgi a aksik zen ek nâŋgâwe, zen itâ sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","“A zo tirik namâ mâtâp âlipŋâ, hikpârâkŋoot, zoren tap oletziŋgâmap.” Oi a zo kubikŋaŋgip, zorat ekŋâ imbaŋâziŋ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Oi Petero, Yohane zekâren târokwatziki a aksik patâ tirik namâ umŋâ ŋâi kutŋâ Salomo, zoren zekâren mindumŋâ sâlâpziŋan zim kirâwe. ");
INSERT INTO kpf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Zen mindum kine Peteroŋâ ziŋgitŋâ den itâ sâm dâzâŋgoip, “Isirae a, zen wangât a zirat opŋâ nikit kinze? Zi niikŋâ imbaŋan mân kubikset. Zen dap nâŋge? Târâraknikŋaŋgât Anutuŋâ kubiksap? ");
INSERT INTO kpf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yatâ buŋâ. Abaram, Isaka, Yakobo sot sâkurâpniŋ, zeŋgât Anutu, zâkŋâ kore aŋâ Yesu sumbemân a kutâ kwânâŋgi ândiap. Oi zen Yesu gâsum a sâtŋâ ziŋgâne Pilatogâren diim âine olaŋbat sâip. ");
INSERT INTO kpf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Olaŋbat sâi zen kândâtkuwe. Tirik sot târârak a zo kândâtkum kâmbam a ŋâi olaŋbapkât sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ândiândiŋ mariŋâ kuwe. Kune moi Anutuŋâ mâŋgei zaari igâwen. ");
INSERT INTO kpf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Oi kiŋ bâliŋ a ikme zi Yesu kutŋâ konsâitâ a zi kubikŋaŋgi sâkŋâ âlip oi ikse. Yesugâren nâŋgâm pâlâtâŋ oitâ âlip op zaatsap. ");
INSERT INTO kpf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Bukurâpnâ, nâ nâŋgan. Zen sot patârâpziŋâ, zen Yesu topŋâ mân nâŋgâm kuwe. ");
INSERT INTO kpf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yatâ utnetâ Kristo sâknam nâŋgâm moip, zorat Anutuŋâ mârumŋan Propete a zeŋgât lâuyân den pâi sâm kulemguwe. Anutuŋâ sâi den kulemguwe, zorat bonŋâ âsageip. ");
INSERT INTO kpf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Oi zen umziŋâ melâŋ ândiândi sâŋgiŋâ kândâtkune tosaziŋ birâbap. Oi Kembuŋâ umziŋ mem sândukŋan kwatziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kembu Yesu Kristo ziŋgâbap. Zâk zeŋgât siŋgi sâm gâsum sâlâpkoip. ");
INSERT INTO kpf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Zâkŋâ sumbemân ândei kut ŋâi ŋâi âsagem naŋgâbapkât narâk mâte upap. Zorat Anutuŋâ mârumŋan den Propete gakârâpŋâ lâuziŋan pâi sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mose zâk den itâ sâip, ‘Kembu Anutuŋâ bukurâpziŋ zeŋgâren gâbâ Propete ŋâi, nâ yatâ, muyagem den dâzâŋgoi nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Oi ŋâi zâk zâkkât den kwâkâbap, zo Anutuŋâ kom naŋgâbap. A zo Anutu a gakârâp zeŋgât oserân mân ândibap.’ ");
INSERT INTO kpf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Oi Samue sot Propete a nâmbutŋâ ândim gawe, zen kut ŋâi aksik narâk ziren âsagiap, zorat den sâm kulemguwe. ");
INSERT INTO kpf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Zen ko Propete a ândiwe, zeŋgât kiurâp. Sâkurâpziŋ zen sot Anutuŋâ târotâro oip. Zen târotâro zorat umŋan ândie. Anutuŋâ târotâro zo Abaram itâ dukum muyageip, ‘Nâ kiurâpkâ mâsop minziŋgâbat. Mâsop zorâŋ hânŋâ hânŋâ a dâpziŋ upap.’ ");
INSERT INTO kpf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Anutuŋâ kore aŋâ Yesu sâŋgongoi gem muyageip. Zen orot mâme bâliŋâziŋâ birâbigât gem gâip. Zâkŋâ diiziŋgi bâliŋâziŋâ birânetâ mâsop minziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petero sot Yohane, zet a den dâzâŋgom kiritâ tirik namâ galem a sot tirik namâ kâwali a sâtŋâ sot Sadukaio a, zen ârândâŋ zekâren gawe. ");
INSERT INTO kpf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Zet a siŋgi âlip dâzâŋgowet. Yesu zâk mumuŋan gâbâ zari a ambân aksik yatâ zaatpi, zorat den sâitâ a sâtŋâ zen nâŋgâne bâliŋ oip. ");
INSERT INTO kpf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","A sâtŋâ zen gâsuzikâm mirâ mârum ŋâtiksâipkât tâk namin zâpane zeitâ haŋsâip. ");
INSERT INTO kpf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Oi Peteroŋâ siŋgi âlip sâi nâŋgâwe, zeŋgâren gâbâ doŋbep ziŋâ zo nâŋgâne bon oi Yesugât kâmurân târokwatne a aksik teŋgâziŋâ a 5 tausen yatâ urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Haŋsâi a sâtŋâ sot a patâ sot Kembugât gurumin den zorat galem a, zen Yerusalem kamânân minduwe. ");
INSERT INTO kpf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tirik namâ galem a patâ Hanasi sot Kaipa, Yohane, Alesande sot a ambârâpziŋâ zen sot minduwe. ");
INSERT INTO kpf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mindum sâne Petero sot Yohane diizikâm osetziŋan âi zâpane kirâwet. Kiritâ itâ mâsikâzikâwe, “Ŋâiŋâ imbaŋâ ziki kulem zi tuugabot? Ŋâigât sâtkât uabot?” ");
INSERT INTO kpf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Oi Petero zâk kiri Tirik Kaapumŋâ umŋan piksâi itâ sâm dâzâŋgoip, “Galem a sot a ambân zeŋgât patârâpziŋâ, nâ sa nâŋgânek. ");
INSERT INTO kpf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Net kiŋ bâliŋ a bekŋan miet, zorat mâsikânike? A zi dap op âlip uap sâm, zorat op mâsikânike? ");
INSERT INTO kpf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mâsikânike, gât ko sapsuga zen sot Isirae a aksik zen nâŋgânek. Zen Yesu Kristo, Nasarete kamânân gokŋâ poru nagân kune moi Anutuŋâ mumuŋan gâbâ mâŋgei zaat ândiap. Zâkkât imbaŋâŋaŋgât opŋâ a zi âlip op mâteziŋan kinzap. ");
INSERT INTO kpf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu zâk mirâ kunkun ŋâi yatâ uap. Zorat Kembugât ekabân den ŋâi itâ ziap, ‘Mirâ tuutuuŋ a zen kunkun ŋâi ekŋâ âkon op birâwe. Kembuŋâ kunkun zorâŋâ mem namin kwânâŋgi kunkun patâ kâtikŋâ op kinzap.’ ");
INSERT INTO kpf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kubikkubik zo zâk zikŋik kubikniŋgâbap. A ŋâigât korân sâm orotŋâ, zo hânân mân ziap.” ");
INSERT INTO kpf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Oi Petero sot Yohane, zet a mâteziŋan kin mân keŋgât op den sâm kiritâ a ziŋ zekât itâ nâŋgâwe, “Zet ekap namin mân zâiwet.” Zo nâŋgâm imbaŋâziŋ buŋ oip. Oi zet mârum Yesu sot ândiwet, zo zikit nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Oi kiŋ bâliŋ kubigâwet, zorâŋ zet sot kiri ekŋâ zorat den sâm mâburinam kwagâwe. ");
INSERT INTO kpf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Den kârum sâne âkŋan gei kiritâ ziiŋak den itâ sâm âraguwe, ");
INSERT INTO kpf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nen a zâgât zi dap otzikânâ. Zet sen mârât kulem ŋâi muyageitâ Yerusalem kamânân a ambân aksik zen siŋgizik nâŋge. Zo mân sâm kwârakunat. ");
INSERT INTO kpf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Oi den zo kamân dâp laŋ kâri nâŋgâbegât sâm keŋgât otzikindâ a ambân den mân dâzâŋgobabot.” ");
INSERT INTO kpf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yatâ sâm sâne zaritâ itâ sâm dâzâkowe, “Zet Yesugât kot sâm a ambân mân dâzâŋgobabot.” ");
INSERT INTO kpf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Yatâ sâne Petero sot Yohane zet den itâ melâŋ dâzâŋgowet, “Ziiŋak nâŋgâm iknek. Zeŋgât den lum Anutugât den birânat, zorat Anutuŋâ nâŋgi dap upap? ");
INSERT INTO kpf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kut ŋâi ŋâi ek nâŋgâwen, den zo mân tik pânat.” ");
INSERT INTO kpf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yatâ sâitâ sâm keŋgât den dâzâkom zâpane âiwet. Kamânân a ambân zen sen mârât kulem zo ek nâŋgâm Anutu sâm âlip kwâkŋaŋgâwegât a sâtŋâ ziŋ zeŋgâren kwakŋâ Petero sot Yohane kut zo laŋ mân otzikâwe. ");
INSERT INTO kpf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","A kubigâwet, zo kendonŋâ 40 yatâ ândim gâi kubigâwet. ");
INSERT INTO kpf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petero sot Yohane minduminduyân gâbâ gem bukurâpzik zeŋgâren âim tirik namâ galem a patâ sot a ambân zeŋgât a patâ, ziŋâ den dâzâkowe, zo aksik dâzâŋgom naŋgâwet. ");
INSERT INTO kpf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Yatâ sâitâ a ambân den zo nâŋgâm umziŋ mindum Anutugâren den itâ sâwe, “Kembu, gâ hân sumbem mariŋâ. Gâ sumbem sot hân, saru sot kut ŋâi ŋâiziŋoot muyageziŋgin. ");
INSERT INTO kpf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sâna Tirik Kaapumgâ zâkŋâ sâkuniŋ kore agâ Dawidi, zâkkât umŋan den pâi itâ sâip, ‘Um kâtik zen wangât den sârek op kwamitague? A zen wangât den bon buŋ se? ");
INSERT INTO kpf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Hânŋâ hânŋâ a kutâ ga kinze. A patâ mindum kinze. Kembu sot a bâliŋan gâbâ mâkâziŋgâbâpkât sâsâŋ, Kristo, kâsa otzikânam ga kinze.’” ");
INSERT INTO kpf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Yatâ sâmŋâ itâ sâwe, “Perâkŋak kamân ziren tirik kore agâ kwânâŋgin. Herode sot Pilato sot um kâtik a sot Isirae a sâtŋâ, zen zâk kâsa okŋaŋgânam minduwe. ");
INSERT INTO kpf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mârum gikak nâŋgâm yatâ upi sâin, zo yatik urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Oi Kembu, zi ko sâm keŋgât dinziŋâ ek nâŋgâm kore arâpkâ imbaŋâ niŋgâna keŋgât buŋ gâgât den sâm ândinat. ");
INSERT INTO kpf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nen Yesugât korân sâindâ ko sisi mâsek a kubikziŋgâm sâna kulem top top muyagibap.” ");
INSERT INTO kpf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yesugât kâmut, zen yatâ ninâu sâm tatne ko mirâ mindum tarâwe, zo sânsânsâip. Oi Tirik Kaapumŋâ umziŋan piksâi keŋgât buŋ, lâu bâbâlaŋâk a ambân Anutugât den dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yesugât kâmut zen um kânok op ândim kut ŋâi ŋâi zemziŋgip, zorat nâgât, gâgât mân sâwe. Kânogâk zemziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Oi Aposolo zen Kembu Yesu mumuŋan gâbâ zaarip, zorat den siŋgi imbaŋâŋoot dâzâŋgom ândiwe. Anutuŋâ imbaŋâ ziŋgâm tânzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Zengât oserân gâbâ ŋâi sii nalemgât kârukâru mân urâwe. A hânziŋoot sot mirâziŋoot, zen zo pam kât memŋâ Aposolo zeŋgâren parâwe. ");
INSERT INTO kpf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Oi Aposolo ziŋâ kât zo mem kâsâpkum a ambân kwakmarâwe, zo ziŋgâm ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Oi a ŋâi ândeip, kutŋâ Yosepe. Aposolo ziŋâ kutŋâ ŋâi Banaba sâwe (niiŋ denân ko bet mâme a). Zâk Lewigât kiun, Kipiro hânân gokŋâ. ");
INSERT INTO kpf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","A zorâŋâ hânŋâ pâi mine kât aksik mem Aposolo zeŋgâren pâip. ");
INSERT INTO kpf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","A ŋâi ândeip, kutŋâ Anania. Zâkkât ambinŋâ Sapira, zâk sot sâm nâŋgâm hânzikŋâ pâitâ mem sâŋgân zikâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananiaŋâ sâŋgân mem torenŋâ tik pam torenŋigâk Aposolo zeŋgâren pam, zi aksik sâip. ");
INSERT INTO kpf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pâi Peteroŋâ itâ sâm dukuip, “Anania, gâ wangât Sataŋŋâ umgan giari Tirik Kaapum kâitkum hângât sâŋgânŋâ torenŋâ tik paat? ");
INSERT INTO kpf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Hângât sâŋgân mân mena zemgibap. Mo kât mem gikâ mimbâ sâm âlip membat. Gâ wangât umgandâ kâitgogi yatâ uat? Gâ a mân kâitkuat. Anutu kâitkuat.” ");
INSERT INTO kpf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Yatâ sâi Anania zâk den nâŋgâm kin zorâŋak hânân gei zem moip. Oi zâkkât siŋgi nâŋgâwe, zen keŋgât urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","A sigân, zen kâmbarâŋâ mem kâpim lum âi hanguwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Narâk mân kârep oi ambinŋâ zâk siŋgi mân nâŋgâm gâip. ");
INSERT INTO kpf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Gâi Peteroŋâ itâ sâm mâsikip, “Hângât sâŋgânŋâ kât itik miwet?” Sâi zâkŋâ sâip, “Zo yatik miwet.” ");
INSERT INTO kpf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Sâi Peteroŋâ itâ sâm dukuip, “Zet wangât den saamŋâ Kembugât Kaapum kâitkuabot? Nâŋgâ. Apkâ hangue, zen mâtâbân ga kinze. Zen yatigâk gâ mingim âi hangobi.” ");
INSERT INTO kpf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Yatâ sâi zorenâk kiŋ topŋan gei zem moip. A sigan ziŋâ mirin gam muyagem lum âi apŋâ naŋgâmŋan hanguwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Oi Yesugât kâmut sot a ambân nâmbutŋâ zen siŋgi zo nâŋgâm keŋgât doŋbep urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolo zen a zeŋgâren sen mârât kulem top topŋâ tuum ândiwe. Oi Yesugât kâmut zen tirik namâ umŋâ ŋâi kutŋâ Salomo, zoren um kânok opŋâ mindumarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mindunetâ a nâmbutŋâ hurat kwatziŋgâm târokwatziŋgânam keŋgât op birâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ka a ambân kâmut kâmutŋâ, zen Kembu nâŋgâm pâlâtâŋ kwâkŋaŋgâm Yesugât kâmut zeŋgâren târokwatziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","A ambân zen bukurâpziŋâ sisi mâsekziŋoot helâŋân pam luziŋgâm âi mâtâbân itâ sâm zâmbarâwe, “Peteroŋâ mâtâbân âim gâi sândokŋandâ zeŋgâren ari âlip upi.” ");
INSERT INTO kpf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Oi Yerusalem kamân naŋgâm naŋgâm a ambân ândiwe, zen gam minduwe. A ambân mâsekziŋoot sot wâkeziŋoot diiziŋgâm gane âlip op naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Oi kut ŋâi yatâ âsagei tirik namâ galem a patâ sot arâpŋâ sot Sadukaio a, zen um kâlak nâŋgâm Aposolo gâsuziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Gâsuziŋgâm tâk namâ patin zâmbarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Zâmbane zinetâ ŋâtigân Kembugât sumbem a ŋâiŋâ ga hâŋgi mem pam diiziŋgâm gem itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Zen tirik namin zâim a ambân ândiândi uŋakŋaŋgât den dâzâŋgom kinbi.” ");
INSERT INTO kpf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yatâ sâm dâzâŋgoi nâŋgâm haŋgât tirik namin zâim a ambân siŋgi âlip dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Oi tirik namâ galem a patâ sot arâpŋâ, zen Isirae a sâtŋâ aksik minduziŋgâne gawe. Oi a nâmbutŋâ sâŋgonzâŋgom tâk namin âi Aposolo diiziŋgâm gabi sâwe. A zo tak namin âi a kâruziŋgâmŋâ mân muyageziŋgâm âburem gam sâwe, ");
INSERT INTO kpf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nen âimŋâ namâ hâŋgi kâtikŋâ kiri iksen. Oi galem a zen hâŋgiyân kinze. Oi hângi mem pam bagim a kâruziŋgindâ buŋ ue.” ");
INSERT INTO kpf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Den yatâ sânetâ tirik namâ kâwali a sot tirik namâ galem a patâ, zen den zo nâŋgâne kwakmak oip. ");
INSERT INTO kpf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Utnetâ a ŋâiŋâ ga sâip, “Nâŋgânek. A tâk namin zâmbanse, zen tirik namin a den dâzâŋgom kinze.” ");
INSERT INTO kpf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Sâi Tirik namâ kâwali a patâ sot arâpŋâ zen Aposolo gâsuziŋgânam âiwe. A ziŋâ kuk op kâtŋâ zâŋgobegât keŋgât op mulunâk diiziŋgâm gawe. ");
INSERT INTO kpf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Minduminduyân diiziŋgâm zâmbane kinetâ tirik namâ galem a patâŋâ itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Mârum den kâtikŋâ dâzâŋgowen. A zorat korân a ambân den mân dâzâŋgobi. Oi yatâ sâindâ Yerusalem kamânân laŋ kârip. A kuwe, zorat tosa neŋgâren pânam sâme.” ");
INSERT INTO kpf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Sâi Petero sot Aposolo nâmbutŋâ, zen den itâ mâburem dukuwe, “A den lum Anutugât den birânat, zo ko mân dâp upap. ");
INSERT INTO kpf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Zen Yesu poru nagân kune moip. Oi sâkurâpniŋ zeŋgât Anutu, zâkŋâ mâŋgei zaarip. ");
INSERT INTO kpf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Zaari Anutuŋâ âsan topŋan bongen pam a sâtŋâ patâ sot kubikkubikniŋâ kwânâŋgip. Oi Isirae a ambân, zen umziŋ melâŋne tosaziŋ gulipkubapkât sâmap. ");
INSERT INTO kpf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kut ŋâi ŋâi zo igâwen. Oi zorat siŋgi den nen sot Tirik Kaapum, niŋâ sâmen. Tirik Kaapum Anutuŋâ sât lulu gakârâp ziŋgâmap.” ");
INSERT INTO kpf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Den yatâ sâm dâzâŋgoi kuk opŋâ Aposolo zâŋgonam urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Oi minduminduyân Parisaio a ŋâi tâip, kutŋâ Gamalie. Zâk gurumin dengât kubikkubik a oi a ambân ziŋ hurat kwâkŋaŋgâwe. Zâkŋâ oksâm kin Aposolo sâi diiziŋgâm geiwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Oi bukurâpŋâ itâ sâm dâzâŋgoip, “Isirae a, zen a zi kut ŋâi nâŋgâmŋik otziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mârum a ŋâi kutŋâ Teuda, zâkŋâ nâ a kutâziŋâ sâi a 4 handeret yatâ zâkkât a urâwe. Oi zikŋâ kâmbam zigi arâp ziŋâ sinsururuŋ urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Oi bet a sâlâpzâŋgozâŋgoŋ narâkŋan Galilaia gokŋâ, a ŋâi kutŋâ Yuda, zâkŋâ a kutâ kunat sâi a nâmbutŋâ arâpŋâ urâwe. Ka a zo moi ko arâpŋâ zen siŋsururuŋ urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Zorat den dâzâŋgua nâŋgânek. Zen a zi birâziŋgâne ândinek. Zen den sot nep zo ziiŋ umziŋaŋgât upme oi ko bon buŋ upap. ");
INSERT INTO kpf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ka Anutugâren gâbâ oi ko mân buŋ upap. Oi zen Anutu kâsa miŋaŋgâbegât.” ");
INSERT INTO kpf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Zo yatâ sâm dâzâŋgoi nâŋgâne dâp oi sâne Aposolo mirin zâine tâkŋâ lapitziŋgâwe. Zâŋgomŋâ Yesugât kot mân dâzâŋgobigât sâm sâŋgonzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Sâŋgonzâŋgone sâtâre op âiwe. Yesugât a, zen Yesugât op lapitziŋgâwe, zorat minduminduyân gâbâ gem sâtâre op âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Oi sirâmŋâ sirâmŋâ tirik namin sot a mirin Yesu Kristogât siŋgi âlip mân birâm dâzâŋgom ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Narâk zoren Yesugât kâmut doŋbep muyagem târokwatziŋgâwe. Oi nalem kâsâpkum Yuda a ambân nâmbut Grik den sâmarâwe, zeŋgât oserân ambân malâ nâmbutŋâ zen nalem mân niŋgâwe sânetâ a Grik den sâmarâwe, zen nâŋgâne mân dâp oip. Oi a Yuda den sâmarâwe, zen sot den sârek sâm âraguwe. ");
INSERT INTO kpf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yatâ utne Aposolo kiin zagât zen Yesugât arâpŋâ kâmut minduziŋgâm itâ sâm dâzâŋgowe, “Nen Anutugât den sâsâŋ nep zo birâm nalem nep tuugindâ mân dâp upap. ");
INSERT INTO kpf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Zorat a bukurâpniŋ osetziŋan gâbâ zen a nâmburân zagât, a nâŋgânâŋgâziŋoot sot Kaapumŋâ umziŋan piksâsâŋ zo ziŋgitne âlip oi gâsum sâlâpzâŋgonat. Nep zi ziŋgindâ tuum ândibi. ");
INSERT INTO kpf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nen ko ninâu sot den siŋgi sâsâŋ, zorat nebâk tuum ândinat.” ");
INSERT INTO kpf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Zen den yatâ sâne zen aksik nâŋgâne dâp oi a itâ gâsum sâlâpzâŋgowe. Setepano, zâk nâŋgâm pâlâtâŋoot sot umŋan Tirik Kaapum piksâm zeip. Oi Pilipo, Porokoro, Nikano, Timoŋ, Pamena sot Nikolau, Antiokia kamânân gok. Zâk hân ŋâin gokŋandâ Yuda zeŋgâren târokwâip. ");
INSERT INTO kpf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","A zo diiziŋgâne Aposolo zeŋgâren âi kine bitziŋâ kâukziŋan pam ninâu sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Oi Anutugât denŋâ laŋ kârâm ari Yerusalem kamânân Yesugât kâmut zen târokwâi târokwâi op âiwe. Oi tirik namâ galem a zeŋgâren gâbâ doŋbepŋâ den siŋgi âlip nâŋgâm luwe. ");
INSERT INTO kpf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Anutuŋâ Setepano tângum imbaŋâ pindi a zeŋgâren sen mârât kulem top top tuum arip. ");
INSERT INTO kpf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Oi a nâmbutŋâ zen zâk sot den âraguwe. A zo zen mâpâmâpâse namâ ŋâi kutŋâ Libertene, zoren mindumarâwe. A zen Kirene a, Alesandiria a, Kilikia a, Asia a. A yatâ zorâŋ Setepano sot den âraguwe. ");
INSERT INTO kpf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tirik Kaapumŋâ Setepano den nâŋgânâŋgâ âlip pindi den âlipŋâ sâi den hâuŋâ mâburinam kwagâwe. ");
INSERT INTO kpf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kwakŋâ a nâmbutŋâ tigâk itâ sâm dâzâŋgowe, “Setepanogât itâ sâbi. ‘A zâk Mose sot Anutu sâm bâliŋ kwatziki nâŋgâwen’” ");
INSERT INTO kpf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sâne yatâ utnetâ a yenŋâ sot a sâtŋâ sot Kembugât gurumin den zorat galem a, zen den zo nâŋgâmŋâ kuk opŋâ Setepano kom gâsum a sâtŋâ mindumindu patin diim âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Oi Setepanogât den sarâ sâbigât a muyageziŋgâne Setepanogât den sarâ sâm itâ sâwe, “A zi zâk tirik namâ sot Kembugât gurumin den sâm bâliŋ kwâpmap. ");
INSERT INTO kpf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Zâk itâ sâi nâŋgâwen, ‘Yesu, Nasarete kamân gokŋâ, zâkŋâ tirik namâ zi kom kândaŋâ gurumin den Moseŋâ sâip, zo kândaŋbap.’” Yatâ sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Oi minduminduyân târâwe zo, zen Setepano iknetâ si sâŋgânŋâ sumben a yatâ oip. ");
INSERT INTO kpf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tirik namâ galem a patâ, zâkŋâ Setepano mâsikâm sâip, “Den se, zo bonŋâ?” ");
INSERT INTO kpf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sâi Setepanoŋâ itâ sâip, “Bukurâpnâ sot ibârâpnâ, den sa nâŋgânek. Sâkuniŋâ Abaram, zâk Haran kamânân mân âim Mesopotamia hânân ândei âsakŋâ mariŋâ, Anutuŋâ zâkkâren âsagem itâ sâm dukuip, ");
INSERT INTO kpf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Gâ hân topkâ sot torerâpkâ birâziŋgâm nâŋâ hân ŋâi tirâpgobat, zoren âi ândiban.’ ");
INSERT INTO kpf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abaram zâk den zo nâŋgâm Kaidai hânŋâ birâm Haran kamânân âi ândeip. Zoren ândei ibâŋâ moi Anutuŋâ diim gâi Yuda hânân zi ga ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Anutuŋâ diim ga hân ŋâi mân pindi galem oip. Buŋâ hân murukŋâ ŋâi mân pindip. Ka hân zo zâk sot kiurâp zeŋgât siŋgiyâk sâm pâip. Zâk kiun buŋ ândeip, zo ko Anutuŋâ laŋ yatâ sâip. ");
INSERT INTO kpf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Oi Anutuŋâ den itâ sâip, ‘Kiurâpziŋ zen hân ŋâin kendon 4 handeret umŋan kore a op ândibi. Zoren hân mâirâpŋâ zen sâknam ziŋgâne ândibi. ");
INSERT INTO kpf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kiurâpziŋâ zen kore op ândine nâ hân mâirâp hâuŋâ ziŋga kiurâpziŋ zen zâmbam hân ziren ga nâ mâpâsenim ândibi.’ ");
INSERT INTO kpf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Oi Anutuŋâ Abaram târotâro pindi kwabâ kwaraŋgip. Oi nanŋâ Isaka âsagem sirâm nâmburân zagât tapŋâ karâmbuŋan kwabâ kwâkŋaŋgip. Isakaŋâ Yakabo yatik kwabâ kwâkŋaŋgip. Yakobo zâk narâpŋâ kiin zagât yatik otziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Oi sâkurâpniŋâ zen munziŋâ Yosepe, zâkkât um kâlak nâŋgâm kât minam Aigitâ a ziŋgâwe. Aigitâ a zen Aigita hânân diim âine Anutuŋâ zâk sot ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Anutuŋâ Yosepe sâknam kâbâ yâmbât kwâkŋan gâbâ mâkâm Aigita a kutâ Parao, zâkkât mâteŋan nâŋgânâŋgâ âlipŋâ pindâm tângoi Paraoŋâ a ambân gakârâpŋâ aksik galem otziŋgâbapkât gâsum sâlâpkoip. ");
INSERT INTO kpf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Gâsum sâlâpkoi ândei pu patâ muyagem Aigitâ hânân sot Kanaan hânân dâp op zeip. Oi sâkurâpniŋ nalemgât kârukâru op ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Oi a nâmbutŋandâ Aigitâ hânân nalem ziap sâne Yakobo zâk nâŋgâm narâp sâŋgonzâŋgoi âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Oi du zagâtŋan âine Yosepe zâk topŋâ âtârâpŋâ sapsum ziŋgip. Oi a kutâ Parao, zâk Yosepe torerâp gawe, zorat siŋgi nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Oi Yosepeŋâ sâi ibâŋâ Yakobo sot torerâpŋâ aksik, a ambân teŋgâziŋ 75 yatâ, zen Aigita hânân âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakobo zâk Aigitâ hânân âi ândim moip. Oi narâpŋâ zen zoren mom naŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Munetâ kâmbarâŋziŋâ Sikem hânân minziŋgâm âi hanzâŋgowe. Hân zo Abaramŋâ mârumŋan Sikem kamânân Hemo kiurâp, zeŋgâren kwâlip. Zoren hanzâŋgowe.” ");
INSERT INTO kpf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Oi Anutuŋâ Abaram kânŋan den siŋgi dukuip, zo âsagibapkât narâkŋâ mâte oi Aigita hânân Isirae a ambân doŋbep âsagem laŋ kârâm ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yatâ op ândine Aigita a kutâ ŋâi âsageip. Zâk Yosepegât siŋgi mân nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Oi a kutâ zorâŋâ sâkurâpniŋ kâitzâŋgom sâknam kwatziŋgip. Oi katep mâik gakârâpziŋâ, zen mumbigât sâi âkŋan zâmbane zem muwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Narâk zoren Mose âsageip. Katep zo Anutuŋâ egi holi tobat âlipŋâ oip. Ibâ mam zet mirin tik mem ândine kâin karâmbut âkip. ");
INSERT INTO kpf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Oi âkŋan pane ândei Parao bâratŋandâ muyagemŋâ mem nannâ sâm galem oi lâmbarip. ");
INSERT INTO kpf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Parao arâp zen Aigitâ zeŋgât nâŋgânâŋgâ kwâkâm pindâne nâŋgâm kâtigem kut ŋâi ŋâi zorat topŋâ sâi nâŋgâne imbaŋâ oip. Oi nep top topŋâ tuubam mân kwagip. ");
INSERT INTO kpf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ândei kendon patâ 40 oi Isirae a bukurâp ziŋgitpam arip. ");
INSERT INTO kpf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Âi egi Aigita a ŋâiŋâ Isirae a ŋâi kom tâi ekŋâ bukuŋâ bekŋan mem Aigita a zo koi moip. ");
INSERT INTO kpf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Oi itâ nâŋgip, ‘Bukurâpnâ nâgât itâ nâŋgâbi. Nâ bukurâpnâ Paraogât bikŋan gâbâ mâkâziŋgâbatkât Anutuŋâ sâm nigip.’ Ka bukurâpŋâ zen mân nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Sirâm ŋâin Moseŋâ âi egi Isirae a zagât agom tâitâ muyagezikâm kwâkâzikâm itâ sâm dâzâkoip, ‘A zagât, zet buku bukuŋâ. Wangât kâsa uabot?’ ");
INSERT INTO kpf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Sâi a kâmbam topkwap bukuŋâ koip, zorâŋâ Mose mem kâbakŋem itâ sâm dukuip, ‘Ŋâiŋâ gâ neŋgât a sâtŋâ mo den kubikkubik a gâbarip? ");
INSERT INTO kpf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Muka Aigita a ŋâi koin, zo yatik nâ nobam sat?’ ");
INSERT INTO kpf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Oi Mose zâk den zo nâŋgâm keŋgât opŋâ sârârâk kârâm âi Midiaŋ hânân âi hân mâirâp zen sot ândeip. Zoren ambân mem nanzatŋâ minzikip. ");
INSERT INTO kpf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Oi kendon 40 âki ko mirâ kamân âtâŋâ, a mân ândiândiŋan, bakŋâ Sinai zorat topŋan ândei sumbem a ŋâiŋâ nak topŋan kârâp bâlamân âsageŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moseŋâ zo ekŋâ wanŋâ yatâ uap sâm ikpam ari Kembugât diŋâ itâ âsageip. ");
INSERT INTO kpf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nâ sâkurâpkâ zeŋgât Anutu. Abaram, Isaka sot Yakobo, zeŋgât Anutu.’ Sâi Mose zâk sânâm sâmbui pindiŋsâm kirip. Zo ikpam keŋgâtŋaŋgât doŋbep oip. ");
INSERT INTO kpf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yatâ op kiri Anutuŋâ itâ sâm dukuip, ‘Hân lâŋsat, zo tirik hân. Zorat opŋâ ko kipâkegâ kwâkâm pânan. ");
INSERT INTO kpf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Arâpnâ Aigitâ hânân sâknam patâ kwatziŋgâne isem umbâlâ utne nâŋgâm betziŋan mimbam gian, gât ko gâ sâŋgongoga Aigita hânân âiban.’ ");
INSERT INTO kpf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Sumbem aŋâ Mose yatâ dukuip. Isirae a zen mârum Mose birâŋaŋgâm itâ dukuwe, ‘Ŋâiŋâ gâ a sâtŋâ mo den kubikkubik a gâbarip?’ Ka Anutuŋâ a zo a kutâ sot betziŋan mimiŋ a upapkât sâm sâŋgongoip. Sumbem a ŋâiŋâ kârâbân muyagem nep zo sâm pindip. ");
INSERT INTO kpf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Oi sâŋgongoi âi Aigitâ hânân gâbâ diiziŋgâm gâip. Zâk Aigitâ hânân sot saru kuriŋan sot mirâ kamân kâtikŋan sen mârat kulem top top tuum ândei kendon 40 âkip. ");
INSERT INTO kpf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Oi Moseŋâ Isirae a itâ sâm dâzâŋgoip, ‘Anutu zâk bukurâpziŋâ zeŋgât oserân gâbâ Propete ŋâi, nâ yatâ, muyagem ziŋgâbap.’ ");
INSERT INTO kpf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yatâ sâip. Oi zâkŋagâk mirâ kamân kâtikŋan sâkurâpniŋ zen sot ândei Sinai bâkŋan sumbem a ŋâiŋâ den zinziŋ kâtikŋâ Anutugât lâuŋan gâbâ mem pindip. Mose sot sâkurâpniŋ zen Anutugâren gâbâ ândiândigât den nâŋgâmŋâ den zo mem niŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Oi sâkurâpniŋ zen Mosegât diŋâ kâbakŋem birâm Âigita hânân âburinam umziŋ patâ kirip. ");
INSERT INTO kpf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Zen Aaroŋ itâ sâm dukuwe, ‘Gâ lopio sobim niŋgâna, zorâŋ kândom otniŋgâne âinat. Mose zâk Aigitâ hânân gâbâ diiniŋgâm gâip, zâk âi buŋ oip mo dap?’ ");
INSERT INTO kpf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yatâ sâm makau dâpŋâ lopio sobim zâkkât siŋgi sâm nalem om sâm âlip kwâkŋaŋgâwe. Bitziŋandâ tuuwe, zorat sâtâre opŋâ zâkkât siŋgi sâm sii nalem uwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yatâ utne Anutuŋâ birâziŋgi umziŋ gulip oi kâin sâŋgelak mâpâseziŋgâwe. Oi zorat Propete zeŋgât ekabân den itâ ziap, ‘O Isirae mâirâp, zen kendon patâ 40 mirâ kamân âtâŋâ, hân mân ândiândiŋan ândim nâgât siŋgi zuu mo nalem kom om nemarâwe? Buŋâ. ");
INSERT INTO kpf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Zen Moloko lopiogât hâmbâ silep lum âim ândiwe. Oi lopio Repaŋgât sâŋgelak dâp mem ândiwe. Lopio zo mâpâsinam sobiwe, gât ko Babiloŋ kamân kândâtŋan zâmbanbat.’” ");
INSERT INTO kpf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Setepanoŋâ Propetegât den sâmŋâ itâ sâip, “Mirâ kamân âtâŋâ, hân mân ândiândiŋan sâkurâpniŋâ zeŋgâren Anutugât hâmbâ silep tatziŋgip. Silep zo Anutuŋâ Mose dâpŋâ tirâpkoi yatik tuugip. ");
INSERT INTO kpf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Sâkurâpniŋ zen silep zo mem gane Yosuaŋâ diiziŋgi hân ziren ga takâwe. Anutuŋâ hân mâirâpŋâ zo moliziŋgi âine sâkurâpniŋ zen hân zi mem hâmbâ silep ziren kwânâŋgâne kiri ândine Dawidi âsageip. ");
INSERT INTO kpf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Anutuŋâ Dawidigât nâŋgi âlip oi Dawidiŋâ Isiraegât Anutu, zâkkât namâ tuubapkât ninâu sâip. ");
INSERT INTO kpf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Oi zikŋak buŋâ. Salomoŋâ Anutugât namâ tuugip. ");
INSERT INTO kpf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ka u sumbemân patâ, zâk a betŋâ tuutuuŋan, zoren tâtat mâme mân opmap. Zorat Propete ŋâi zâk den itâ sâm kulemguip, ");
INSERT INTO kpf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Anutuŋâ itâ sâip, ‘Sumbem zo tâtatnâ. Zoren tap a ambân zeŋgât kembu op galem otziŋgâman. Hân ko kinnâ lâŋ tâtatnâ. Zorat dap yatâ namânâ tuune dâp upap? Nâ ikâ zoren tâtat mâme upat? ");
INSERT INTO kpf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nâ bitnandâ hân sot kut ŋâi ŋâi, zo muyagewan.’” ");
INSERT INTO kpf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sâmŋâ Setepanoŋâ a kâmut zo itâ sâm dâzâŋgoip, “Zen ko umziŋ kâtik. Um nâŋgânâŋgâziŋ mân pâroŋsap. Sâkurâpziŋ opmarâwe, zo yatik op Tirik Kaapumgât diŋâ kwâkâme. ");
INSERT INTO kpf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sâkurâpziŋâ zen Propete aksik sâknam kwatziŋgâwe. Perâkŋak, Propete zen târârak mariŋâ muyagibapkât den kânŋan sâwe, zo aksik zâŋgowe. Oi târârak mariŋâ zâk âsagem ândim gâi zen ekŋâ neŋgât a kutâ buŋâ sâmŋâ kuwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mârum sumbemgât aŋâ gurumin den Anutugâren gâbâ mem ziŋgip, ka zen den zo birâm, mân luwe.” ");
INSERT INTO kpf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Setepanoŋâ yatâ sâm dâzâŋgoi nâŋgâm kuk op kunam urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tirik Kaapumŋâ Setepano umŋan piksâi sumbemân egi Anutugât âsakŋâ sot Yesu Anutugât âsanŋâ bongen kiri ekŋâ itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Sumbem pâroŋsâi a bonŋâ zâk Anutugât bik bongen kiri eksan.” ");
INSERT INTO kpf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Yatâ sâi zen den kwamit patâ sâmŋâ kindapziŋ dooŋgum zâkkâren mindum âim mem kâbakŋem geim kamân âkŋan geim kâtŋâ kuwe. Oi a mâteŋâ, zen hâmbâziŋ kwâkâm a sigan ŋâi kutŋâ Saulo, zâkkât kiŋ topŋan parâwe. ");
INSERT INTO kpf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Oi Setepano kâtŋâ kune Kembu itâ konsâm sâip, “O Kembu Yesu, gâ um dâpnâ me.” ");
INSERT INTO kpf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yatâ sâm siminŋâ liim kwap sâip, “Kembu, gâ a noge zi, zeŋgât tosâ birâ.” Yatâ sâm moip. ");
INSERT INTO kpf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kune Sauloŋâ nâŋgi âlip oip. Narâk zoren Yuda a ziŋ Yerusalem kamânân Yesugât kâmut kâsa otziŋgâwe. Otziŋgânetâ siŋsururuŋ op Yudaia sot Samaria hânân âim naŋgâwe. Aposolo ziiŋik Yerusalem kamânân ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Oi a târârak nâmbutŋâ zen Setepano hangum âigirâp urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sauloŋâ ko Yesugât kâmut kâsa otziŋgâm mirâŋâ mirâŋâ zâim a sot ambân gâsum diiziŋgâm tâk namin zâmbarip. ");
INSERT INTO kpf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yesugât kâmut siŋsururuŋ op âiwe zo, zen kamân dâp ândim den siŋgi âlip dâzâŋgom ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Oi Pilipo zâkŋâ Samaria zeŋgât kamân ŋâi gamŋâ Kristogât siŋgi âlip sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","A doŋbep zen mindum diŋâ nâŋgâm âkŋâliwe. Oi sen mârât kulem top top tuugi igâwe. ");
INSERT INTO kpf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Zâkŋâ wâke doŋbep moliziŋgip. Wâke zen a umŋan gâbâ den kâtik sâm gem âiwe. Oi kin bitziŋ mumuŋâ zo doŋbep kubikziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Oi zorat kamân zoren sâtâre patâ urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kamân zoren a ŋâi ândeip, kutŋâ Simoŋ. Zâkŋâ zikŋaŋgât nâŋgi zâizâiŋ oi kware suŋa tuugi Samaria a zen ekŋâ imbaŋâziŋ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Oi a zâizâiŋ, gigiŋ zen zâkkât nâŋgâne zâizâiŋ oi itâ sâwe, “A zi Anutugât kâwali murukŋâ ŋâi zâkkâren ziap.” ");
INSERT INTO kpf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Oi kwareŋandâ um gulip kwatziŋgipkât narâk kârep zâkkâren mindum ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ândinetâ Pilipoŋâ ga Anutugât um topŋan ândiândiŋâ sot Yesu Kristogât den siŋgi âlip sâm dâzâŋgoi a ambân zen zorat nâŋgâne bon oi Pilipoŋâ too saŋgonziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Yatâ utne Simoŋ yatik siŋgi âlip nâŋgi bon oi too saŋgone Pilipogât um topŋan ândeip. Oi Pilipoŋâ sen mârât kulem top top tuugi egi imbaŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria hânân a ambân zen Anutugât den nâŋgâm mem umziŋan gine, zorat siŋgi Yerusalem kamânân ari Aposolo zen nâŋgâwe. Nâŋgâm Petero sot Yohane sâŋgonzâkone zeŋgâren âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Âi takâm a ambân zen Tirik Kaapum mimbigât ninâu sâwet. ");
INSERT INTO kpf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ombeŋan Tirik Kaapumŋâ zeŋgâren mân gâip. Zen Yesugât korânâk sâm yen too saŋgorâwe. ");
INSERT INTO kpf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Petero sot Yohane zet bitzikŋâ kâukziŋan pâitâ zen Tirik Kaapum sot urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aposolo zagât zet bitzikŋâ a ambân kâukziŋan pâitâ Tirik Kaapum sot utne Simoŋâ ekŋâ kât mem itâ sâm dâzâkoip, ");
INSERT INTO kpf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Zet imbaŋâ zo yatik nâ nigitâ bitnâ a kâukziŋan pa Tirik Kaapum mimbi.” ");
INSERT INTO kpf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Sâi Peteroŋâ itâ sâm dukuip, “Ga Anutuŋâ imbâŋâ yen ziŋgâziŋgâŋ zo kwâlâbam sat, zorat kâtkâ sot gikâ ârândâŋ sim kârâbân gei tâmbetagobabot. ");
INSERT INTO kpf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Anutuŋâ um sarâgâ eksapkât zirâŋâ gâgât siŋgi mân uap. ");
INSERT INTO kpf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Gâ nâŋgânâŋgâgâ bâliŋâ zo birâm umgâ melâŋ ninâu sâban. Kembuŋâ tosagâ birâbapkât ninâu sâban. ");
INSERT INTO kpf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gâ bâliŋaŋgât kâlakŋâ umgan piksâm ziap. Bâliŋandâ saagigap.” ");
INSERT INTO kpf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sâi Simoŋâ itâ sâip, “Zikŋak nâgât opŋâ Kembugâren ninâu sâitâ den sat, zo bonŋâ mân muyagenibap.” ");
INSERT INTO kpf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petero sot Yohane zet Kembugât den dâzâŋgom naŋgâm Yerusalem kamânân âiram âburiwet. Âburem Samaria hânân kamânŋâ kamânŋâ den siŋgi âlip dâzâŋgom âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kembugât sumbem a ŋâiŋâ Pilipogâren muyagem itâ sâm dukuip, “Gâ zaat âi. Yerusalem kamânân gâbâ Gasa kamânân geime, mâtâp zoren âi.” (Mâtâp zo hân a mân ândiândiŋan ziap.) ");
INSERT INTO kpf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Yatâ sâm dukui Pilipoŋâ zaatŋâ arip. Mâtâbân âi a ŋâi egip. Aitiopai hânân ambân kutâ ŋâi ândeip, kutŋâ Kandake, zâkkât a sâtŋâ ŋâi. Zâk kât sikum galem a. Zâkŋâ Anutu mâpâsibam Yerusalem kamânân âimŋâ puriksâm gâip. Zâk a lalaŋâ kwâkŋan tap ari egip. Egi âim tap Propete Yesaiagât ekabân den zeip, zo sâlâpkum tâip. ");
INSERT INTO kpf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yatâ oi Kaapumŋâ Pilipo itâ sâm dukuip “Gâ zâkkâren âinan.” ");
INSERT INTO kpf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Sâi Pilipoŋâ zâkkâren sârârâk kârâm ari a sâtŋâ zâk Propete Yesaiagât den sâlâpkoi nâŋgâm itâ sâm mâsikip, “Den sâlâpkuat, zorat topŋâ nâŋgat?” ");
INSERT INTO kpf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Sâi zâkŋâ sâip, “Ŋâi mân dâtnone ninak dap yatâ nâŋgâbat?” Yatâ sâmŋâ sâi Pilipoŋâ zâi zâk sot tâip. ");
INSERT INTO kpf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Den sâlâpkoip, zo itâ, “Zâk râma yatâ oi diim âi kunam urâwe. Aŋâ râma gwamŋâ gâsum sâmot mânâŋgâri diŋ buŋ tâpmap, zo yatâ diŋ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Zâkkât nâŋgâne gigiŋâ oi den nebân pamŋâ den sâkŋanâk sâwe. Hânân ândiândiŋâ buŋ oip. Oi kiurâpŋâ dap yatâ sâlâpzâŋgom naŋgâbe.” ");
INSERT INTO kpf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Oi a sâtŋâ zâk Pilipo itâ sâm mâsikip, “Gâ sâna nâŋgâbâ. Propete zâk ŋâigât yatâ sap? Zikŋaŋgât sap mo a ŋâigât sap?” ");
INSERT INTO kpf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Sâi Pilipo zâk Propetegât den zobâ topkwapŋâ Yesugât den siŋgi âlip sâm dukuip. ");
INSERT INTO kpf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Yatâ op âim tooyân takâwet. Oi a sâtŋandâ itâ sâip, “Too ziap. Zi âlip sa saŋgonniban?” ");
INSERT INTO kpf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Sâi Piliponŋâ sâip, “Gâ den san, zo nâŋgâna bon oi âlip saŋgongibat.” Sâi den itâ mâburem dukuip, “Itâ nâŋgan. Yesu Kristo, zâk Anutugât nanŋâ. Zâk nâŋgâm pâlâtâŋ kwâkŋaŋgan.” ");
INSERT INTO kpf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yatâ sâmŋâ kore a dukui biosi saagi a sâtŋâ sot Pilipo ârândâŋ toin geiwet. Geim Pilipoŋâ saŋgonŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Oi toin gâbâ kopgâitâ Kembugât Kaapumŋâ Pilipo mem ari a sâtŋâ zâk dum mân ekŋâ sâtâre op mâtâbân arip. ");
INSERT INTO kpf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipo, zâkŋâ ko Asido kamânân taki igâwe. Oi zâk kamânŋâ kamânŋâ den siŋgi âlip dâzâŋgom Kaisarea kamânân arip. ");
INSERT INTO kpf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo zâk Kembugât a ambârâpŋâ kâsa otziŋgâm zâŋgobatkât umŋâ kârâp oip. Oi âi tirik namâ galem a patâgâren sâip. ");
INSERT INTO kpf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Âi sâi Damasiko kamânân Yuda a zeŋgât mâpâmâpâse namâ galem a, zeŋgât ekap kulemgum pindip. Pindi âim Damasiko kamânân a ambân zen Yesugât mâtâbân nep tuum ândiwe, zo gâsuziŋgâm saaziŋgâmŋâ diiziŋgâm Yerusalem kamânân gâbam arip. ");
INSERT INTO kpf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Zâk âimŋâ Damasiko kamân mâte oi sumbemân gâbâ âsakŋandâ gem gâm zâkkâren âsagem naŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Âsagei hânân gei kom den ŋâi itâ nâŋgip, “Saulo, Saulo, gâ wangât nom ândimat?” ");
INSERT INTO kpf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sâi Sauloŋâ mâsikâm sâip, “Kembu, gâ ŋâi?” Sâi zâkŋâ sâip, “Gâ nom ândimat. Nâ Yesu. ");
INSERT INTO kpf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Gâ zaat kamânân âina nep tuuban, zorat a ŋâiŋâ diŋâ dâgobap.” ");
INSERT INTO kpf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Oi a zâk sot âiwe, zen dinziŋ buŋ oi kirâwe. Zen den zo ko nâŋgâwe. Ka a ko mân igâwe. ");
INSERT INTO kpf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Oi Saulo zâk zaatŋâ siŋâ ikpâ sâm egi ŋâtâtik oip. Yatâ oi bukurâpŋâ zen bikŋan gâsum Damasiko kamânân zâiwe. ");
INSERT INTO kpf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oi sirâm karâmbut umŋan siŋâ ŋâtâtik kâri tap too nalem mân neip. ");
INSERT INTO kpf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasiko kamânân Yesugât kâmurân gok a ŋâi ândeip, kutŋâ Anania. Oi Kembuŋâ umanân muyagem konsâip, “Anania.” Sâi Ananiaŋâ sâip, “Kembu, nâ zi.” ");
INSERT INTO kpf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Sâi Kembuŋâ itâ sâm dukuip, “Gâ kamân mâtâp kutŋâ târârak, zoren âim a ŋâi kutŋâ Yuda, zâkkât mirâŋan zâim zoren a ŋâi kutŋâ Saulo, Taso kamânân gok, zâk muyagiban. Zâk zoren ninâu sâm ziap. ");
INSERT INTO kpf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Oi uman ŋâi itâ eksap. A ŋâi kutŋâ Anania, zâkŋâ zâkkâren gamŋâ siŋâ ânâŋgâtpapkât bikŋâ kâukŋan paap.” ");
INSERT INTO kpf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kembu zâk den yatâ sâi Anania zâk itâ sâip. “Kembu, nâ a zorat a doŋbepŋâ sâne nâŋgâman. Zâk arâpkâ Yerusalem kamânân doŋbep tâmbetzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Oi ziren yatigâk kutkâ gonsâmen zo, nen yatik gâsum saaniŋgâbapkât tirik namâ galem a patâŋâ ekap kulemgum pindâwe.” ");
INSERT INTO kpf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Sâi Kembuŋâ itâ sâm dukuip, “Gâ laŋ âi. A zo gâsum sâlâpkuan. Zâkŋâ a kâmut ŋâin ŋâin sot a kutâziŋâ sot Isirae a zeŋgâren nâgât den siŋgi dâzâŋgom ândibap. ");
INSERT INTO kpf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yatâ oi kutsiŋginaŋgât opŋâ sâknam nâŋgâbap, zorat tirâpkubat.” ");
INSERT INTO kpf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Oi Anania zâk âim mirin zâim bikŋâ Saulo kâukŋan pamŋâ sâip, “Saulo bukunâ, Kembu Yesuŋâ mâtâbân muyagegigip, zâkŋâ sâŋgonnogi gaan. Gâ siŋgâ ânâŋgâri Tirik Kaapumŋâ umgan piksâbapkât sap.” ");
INSERT INTO kpf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Yatâ sâi zorenâk siŋan gâbâ sâkŋâ senâŋâ yatâ gem gei siŋâ âlip egip. Yatâ okŋaŋgi zaari aritâ too saŋgonŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Yatâ oi Sauloŋâ nalem nemŋâ kâtigeip. ");
INSERT INTO kpf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saulo zâk Yesugât kâmut Damasiko kamânân ândiwe, zen sot mâik ŋâi ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Oi narâk zoren Yuda zeŋgât mâpâmâpâse namin zâim Yesugât siŋgi sâm muyagem itâ sâm dâzâŋgoip, “Yesu, zâk Anutugât nanŋâ.” Yatâ sâm dâzâŋgoi nâŋgâwe, zen aksik imbaŋâziŋ buŋ oi itâ sâwe, “Yerusalem kamânân Yesugât kutŋâ zo konsâne laŋ kâri a zo tâmbetzâŋgom ândeip. Ziren yatigâk gam saam diiziŋgâm tirik namâ galem a patâ zeŋgâren âibapkât gâip. Zorâŋ dap op purikgurik uap?” ");
INSERT INTO kpf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Oi Saulo zâk kâtigem sâip. “Yesu, zâk a bâliŋan gâbâ mâkâziŋgâbapkât mârum sâsâŋ, Kristo.” Yatâ sâm zorat den topŋâ sâm muyagem dâzâŋgoip. Oi Damasiko kâmânân Yuda a ândiwe, zen diŋâ zo nâŋgâm kwakmak urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Yatâ oi ândimŋâ Yuda a zen Saulo kunam sâm kâtâŋ urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Diŋâ sâne Sauloŋâ den zo nâŋgâm ândei Yuda a zen hilâm ŋâtik kamân mâtâp galem op kunam op ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Yatâ utne Yesugât kâmut ziŋâ ŋâtigân Saulo mem âim kamângât paŋ kâtikŋâ saasaaŋâ, zoren irin gem mem pane âkŋan gem arip. ");
INSERT INTO kpf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Âimŋâ Yerusalem kamânân takâmŋâ Yesugât arâp zeŋgâren târokwâpatkât sâi zen zâkkât keŋgât urâwe. Zâk Yesugât a oip, zorat nâŋgâne bon mân oip. ");
INSERT INTO kpf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Oi Banabaŋâ Paulo buku okŋaŋgâm Aposolo zeŋgâren diim arip. Zeŋgâren âimŋâ Kembuŋâ Saulo mâtâbân muyageŋaŋgâm den dukuip sot Damasiko kamânân Sauloŋâ Yesugât den siŋgi sâm muyageip, zorat den siŋgi sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Zorat kwâkŋan Saulo zâk Yerusalem kamânân zen sot tâtat mâme oip. ");
INSERT INTO kpf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Oi Saulo zâk Kembugât korân lâŋ kâtigem a zen sot Yesugât topŋâ sâm âraguwe. Oi Yuda a Grik den sâmarâwe, zen sot den âragum den sârek âraguwe. Oi a zo ziŋâ kâsa okŋaŋgâm kunam urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Oi Saulogât bukurâpŋâ zen den zo nâŋgâm diim Kâisarea kamânân âi pane Taso kamânân arip. ");
INSERT INTO kpf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Oi Yesugât kâmut Yudaia hânân Galilaia hânân sot Samaria hânân ândiwe, zeŋgâren lumbeŋâ zeip. Lumbeŋâ ândim, kâtigem ândim zâimŋâ Kembu hurât kwâkŋaŋgâm uruŋsâm ândiwe. Oi Tirik Kaapumŋâ mam otziŋgi kâmut doŋbep urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petero zâk kamânŋâ kamânŋâ âim gam Yesugât kâmut Lida kamânân ândiwe, zeŋgâren takip. ");
INSERT INTO kpf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Zoren a ŋâi egip, kutŋâ Ainea. A zo kiŋ bik mumuŋâ oi zem ândei kendon patâ nâmburân karâmbut oip. ");
INSERT INTO kpf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peteroŋâ itâ sâm dukuip, “Ainea, Yesu Kristoŋâ kubikgigap. Zaatŋâ isengâ gikak kubik.” ");
INSERT INTO kpf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Sâi zorenâk oksâm zaarip. Yatâ oi Lida sot Saroŋ kamân mâirâp zo igâwe, zen umziŋ melâŋ Kembugât a urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yope kamânân Yesugât kâmurân ambân ŋâi ândeip, kutŋâ Tabita. Grik denân ko kutŋâ Doka sâmarâwe. Ambân zo a ambân betziŋan mem kut ŋâi ŋâi âlipŋâ op ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Narâk zoren ambân zo mâsek opŋâ moip. Moi ko kâmbarâŋâ too saŋgon mem mirâ umŋâ ŋâin zâi pane zeip. ");
INSERT INTO kpf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida kamân sot Yope kamân, zo goot goot tarâwet. Oi narâk zoren Petero zâk Lida kamânân ândei zorat Yesugât kâmut Yopa kamânân ândiwe, zen den siŋgi nâŋgâm a zagât sâŋgonzâkone Peterogâren âi itâ sâm dukuwet, “Gâ diigigitâ neŋgât kamânân kek âinâ.” ");
INSERT INTO kpf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Sâitâ Peteroŋâ zen sot ârândâŋ âiwe. Âi Yope kamânân takâm mirâ kâmbarâŋ zeibân diim zâiwet. Zoren ambân malâ zen haamgum isem tap Tabita gwâlâ ândim hâmbâ mot gârim ziŋgip, zo Petero tirâpkuwe. ");
INSERT INTO kpf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peteroŋâ sâi ambân zo aksik geine simin liim kwap ninâu sâip. Ninâu sâm naŋgâm kâmbarâŋ mâte okŋaŋgâm itâ sâip. “Tabita, gâ zaat.” Sâi siŋ kârum Petero ekŋâ zaat tâip. ");
INSERT INTO kpf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peteroŋâ bikŋan gâsui zaat kirip. Zaat kiri Peteroŋâ sâi ambân malâ sot Yesugât kâmut zen ga igâwe. ");
INSERT INTO kpf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Oi zorat siŋgi Yope kamânân laŋ kârâm ari doŋbepŋâ Kembugât a ambân urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Oi Petero zâk a ŋâi kutŋâ Simoŋ, zâk bâu sâkziŋ lâkum tuumap, zâkkât mirin tâtat mâme op ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisarea kamânân Roma kâwali a kâmut zen ândiwe. A kâmut zo zeŋgât kutziŋâ Italia sâmarâwe. A ŋâi kutŋâ Konelio, zâkŋâ kâwali a kâmut zo zeŋgât a sâtŋâ ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Zâk sot a ambârâpŋâ, zen Anutu hurât kwâkŋaŋgâm mâpâseŋaŋgâm ândiwe. Zâkŋâ a ambân kanpitâ kât nalem ziŋgâmâip sot Anutugâren ninâu sâm ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Konelio zâk yatâ opŋâ sirâm ŋâin mirâ oi uman ŋâi itâ egip. Anutugât sumbem a ŋâiŋâ zâkkâren gam itâ sâm dukuip, “Konelio.” ");
INSERT INTO kpf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konsâi tâpâk ekŋâ keŋgâtŋaŋgât op sâip, “Kembu, dapkât sat?” Sâi ko sâip, “Ninâugâ sot orot mâmegâ Anutuŋâ egi âlip oip. ");
INSERT INTO kpf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Zorat Yope kamânân kore a sâŋgonzâŋgona âi a ŋâi kutŋâ Simoŋ, kutŋâ ŋâi Petero, zâk diim gabi. ");
INSERT INTO kpf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Zâk sot tâip zo bâu sâkziŋ lâkum tuumap, kutŋâ Simoŋ. Zâkkât mirâ saru sâtŋan taap. Oi Petero zâk zorenâk ândiap.” ");
INSERT INTO kpf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Sumbem aŋâ den yatâ dukum ari zorenâk kore a zagât sot kâwali a ŋâi sâŋgonzâŋgoip. Kâwali a zo Anutu mâpâsemâip. ");
INSERT INTO kpf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Den siŋgi zo dâzâŋgomŋâ Yope kamânân sâŋgonzâŋgoi âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","A zen âim mâtâbân ziwe. Haŋsâi zaat kamân goot goot utne mirâ bâkŋan oi Peteroŋâ ninâu sâbam mirin zarip. ");
INSERT INTO kpf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Zâi ninâu sâmŋâ tepŋaŋgât oi nalem une sei zâk uman zem, uman ŋâi itâ egip. ");
INSERT INTO kpf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Sumbem mâtâp pâroŋsâi sumbemân gâbâ isen patâ ŋâi muruk toren toren kimembut zoren saam pane geip. ");
INSERT INTO kpf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Umŋan zuu, mulum mot, nii top top sot kut ŋâi ŋâi ziwe. ");
INSERT INTO kpf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Oi den ŋâi itâ Peterogâren geip, “Petero, gâ kom gaam ne.” ");
INSERT INTO kpf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Yatâ sâi Peteroŋâ sâip, “Kembu, nâ mân upat. Nii zuu bâliŋâ mo mân niniŋâ, zo mân neman.” ");
INSERT INTO kpf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sâi ko den dum âsageip, “Anutuŋâ kut ŋâi ŋâi âlipŋâ sâm paap, zo bâliŋâ mân sâban.” ");
INSERT INTO kpf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kut ŋâi zo sâp karâmbut muyagei dum buraŋŋoot sâmbune sumbemân zarip. ");
INSERT INTO kpf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Oi Petero uman egip, zorat nâŋgâm kwâkâm tâi Konelio arâp zen gamŋâ Simoŋgât mirâŋâ kârum âim muyagem mirâ sombemân kirâwe. ");
INSERT INTO kpf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kinŋâ mâsikâm sâwe, “Simoŋ, kutŋâ ŋâi Petero, zâk mirâ ziren tap?” ");
INSERT INTO kpf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Yatâ sâne Petero zâk uman egip, zorat nâŋgâm kwâkâm tâi Kaapumŋâ itâ sâm dukuip, “A karâmbut gamŋâ gâ kârugige, gât ko gâ geimŋâ zen sot âibam keŋgât mân upan. ");
INSERT INTO kpf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","A zo nâŋâ sâŋgonzâŋgua ge.” ");
INSERT INTO kpf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Oi Peteroŋâ den zo nâŋgâmŋâ zeŋgâren geimŋâ sâip, “Wangât nâgâren ge?” ");
INSERT INTO kpf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Sâi a ziŋâ dukuwe, “Kâwali galem a patâ Konelio, zâk Anutu hurat kwap târârak ândimap. Yuda a zen zâkkât nâŋgâne a âlipŋâ opmap. Sumbem kore a ŋâiŋâ zâkkâren âsagem gâ mirâŋan diigim arindâ diŋgâ nâŋgâbapkât sâip,” ");
INSERT INTO kpf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Yatâ sâne Peteroŋâ nâŋgâm sâi mirin zâine nalem ziŋgip. Haŋsâi zâk sot Yope kamânân gokŋâ a nâmbutŋâ zen sot âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Zen mâtâbân âi zem Kaisarea kamânân takâwe. Konelio, zâk a ambârâpŋâ sot bukurâpŋâ minduziŋgi mambâtziŋgâm tatne gawe. ");
INSERT INTO kpf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Gamŋâ Petero zâkkât mirin zari Konelio zâk kiŋ topŋan gei zem mâpâseip. ");
INSERT INTO kpf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Zei Peteroŋâ mem zaatŋâ itâ sâm dukuip, “Zaat. Nâ a, gâ yatâ.” ");
INSERT INTO kpf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Yatâ sâm mirâ umŋan âim a ambân kâmut patâ muyageziŋgâm itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","“Zen Yuda a neŋgât topniŋâ nâŋgâme. Nen a kamân ŋâin gokŋâ zen sot buku opŋâ tâtat mâme mân upmen. Gurumin denân den ŋâiŋâ mâtâp zo dooŋgoi ziap. Nâ ko Anutuŋâ ziŋgiri mân dâp opmap mân sâbatkât Anutuŋâ umanân nii zuu bâliŋâ sot mân niniŋâ buraŋŋoot saam pâi gei tirâpnogip. ");
INSERT INTO kpf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Zorat a ziŋâ nâgâren ga dâtnone nâ mân kwaksan. Oi zi diiniwe, zorat sâne nâŋgânâ.” ");
INSERT INTO kpf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Yatâ sâi Konelioŋâ itâ sâm dukuip, “Sirâm kimembut ombeŋan mirâ oi nâ mirin tap ninâu sâm ta a ŋâi hâmbâŋâ âsakŋâŋoot nâgâren muyagem itâ sâm dâtnogip, ");
INSERT INTO kpf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Konelio, Anutuŋâ ninâugâ sot orot mâmegâ nâŋgi âlip uap. ");
INSERT INTO kpf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Zorat gâ Yope kamânân a sâŋgonzâŋgona âi Simoŋ, kutŋâ ŋâi Petero, zâk diim gabi. A ŋâi bâu sâkziŋ lâkum tuumap, kutŋâ Simoŋ, zâkkât mirin tâtat mâme uap. Mirâŋâ saru sâtŋan taap.’ ");
INSERT INTO kpf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Oi nâ zorat a sâŋgonzâŋgua gâgâren âiwe. Gâ nâgât den lum gaatkât umnâ âlip uap. Oi Anutuŋâ den dâgogip, zo sâna nâŋgânatkât Anutugât mâteŋan mindum ten.” ");
INSERT INTO kpf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petero zâk topkwapŋâ itâ sâm dâzâŋgoip, “Itârâŋ nâ itâ ek nâŋgan. Anutu zâk a kâmut ŋâi buku otziŋgâm a kâmut ŋâin kândâtzâŋgom mân opmap. ");
INSERT INTO kpf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","A kâmutŋâ kâmutŋâ zeŋgâren gâbâ nâmbutŋandâ hurâtkwapŋâ târârak ândine, zeŋgât nâŋgi âlip opmap. ");
INSERT INTO kpf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Anutu zâk Isirae a den niŋgip, zo itâ. Yesu Kristo, zâk a neŋgât Kembu. Anutuŋâ zâk sâŋgongoi gem lumbeŋaŋgât den dâtnâŋgoip, zo nâŋge. ");
INSERT INTO kpf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yohane zâk too saŋgonziŋgâbapkât den dâzâŋgoip, narâk zoren Yesugât den siŋgi âlip zo Galilaia hânân topkwâi Yudaia hânân arip. ");
INSERT INTO kpf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Oi Yesu, Nasarete kamânân gokŋâ zo ko Anutuŋâ imbaŋâ sot Tirik Kaapum pindi hân muruk toren toren âim sisi mâsek a âlip kwatziŋgip. Oi a ambân Sataŋŋâ saaziŋgip, zo aksik olaŋziŋgip. Anutuŋâ tâŋgoi nep zo tuugip. ");
INSERT INTO kpf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Oi Yuda a neŋgât hânân sot Yerusalem kamânân kut ŋâi ŋâi tuum arip, zo ek nâŋgâwen. Oi a sâtŋâ ziŋ gâsum poru nagân kune moip. ");
INSERT INTO kpf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Mom zei sirâm karâmbut oi Anutuŋâ kwagân gâbâ mâŋgeip. Mâŋgei neŋgâren âsageniŋgip. Zorat mârumŋan Anutu zâk siŋgi kwatniŋgip. A nâmbutŋâ zeŋgâren mân âsagei igâwe. Zâk mumuŋan gâbâ âsagei nalem sot too ârândâŋ niwen. ");
INSERT INTO kpf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Oi Anutuŋâ Yesu a mumuŋâ sot gwâlâ neŋgât den sâm kwâkâkwâkâŋ a kwânâŋgip. Oi nen den zo a ambân dâzâŋgonatkât nep diŋ sâm niŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Oi a ziŋ nâŋgâm pâlâtâŋ kwâkŋaŋgâbi zo, zeŋgât tosa gulipkubap. Den zo Propete ziŋ sapsum naŋgâwe.” ");
INSERT INTO kpf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petero zâk den yatâ sâm kiri nâŋgâm tarâwe aksik zeŋgâren Tirik Kaapum gem gâip. ");
INSERT INTO kpf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Oi Yuda a Yesugât kâmurân gâbâ Petero sot âiwe, zen Anutuŋâ a hân ŋâin gokŋâ Tirik Kaapum ziŋgip, zo ekŋâ imbaŋâziŋ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","A hân ŋâin gokŋâ, zen den gându uŋakŋâ sâm Anutu sâm âlip kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Oi Peteroŋâ itâ sâip, “Nen Tirik Kaapum sot urâwen, yatigâk Tirik Kaapum âsageziŋgap. Zorat too saŋgonsaŋgon zo a ziŋ aŋgân kârâne mân dâp upap.” ");
INSERT INTO kpf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Yatâ sâi ziŋâ Yesu Kristogât korân sâm too saŋgonziŋgâwe. Too saŋgonziŋgâne Petero mân âibapkât sânetâ hilâm nâmbut zen sot tâip. ");
INSERT INTO kpf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposolo nâmbutŋâ sot Yesugât kâmut Yudaia hânân ândiwe, zen kamân ŋâin gokŋandâ Anutugât den nâŋgâm luwe, zorat siŋgi nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Oi Petero zâk Yerusalem kamânân zari Yuda a nâmbutŋâ Mosegât gurumin den zorik zimbapkât kâtigiwe, a zo ziŋâ Petero oip, zorat nâŋgâne mân dâp oip. ");
INSERT INTO kpf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Oi Petero itâ sâm dukuwe, “Gâ wangât Mosegât gurumin den kom a mân kwabâ kwâraŋgâwe, zen sot den op nalem nein?” ");
INSERT INTO kpf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Oi Peteroŋâ kut ŋâi ŋâi âsageip, zorat topŋan gâbâ itâ sâm dâzâŋgom naŋgip, ");
INSERT INTO kpf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nâ Yope kamânân ninâu sâm ândim uman itâ egâwan. Isen patâ ŋâi muruk toren toren kimembut saam sumbemân gâbâ pane gem umnâ topŋan zeip. ");
INSERT INTO kpf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Gem gâi umŋan itâ egâwan. Zuu top top, kamângât sot ulin, mulum mot sot nii umŋan ziwe. ");
INSERT INTO kpf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Oi nâgâren den ŋâi itâ gâip, ‘Petero, gâ zaat kom gaam ne.’ ");
INSERT INTO kpf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Oi nâŋâ sâwan, ‘Kembu, yatâ buŋâ. Zuu bâliŋâ mo mân niniŋâ mân nemân.’ ");
INSERT INTO kpf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Yatâ sa sumbemân gâbâ den zagâtŋâ itâ muyageip, ‘Anutuŋâ kut ŋâi ŋâi zo âlipŋâ sap, zo gâŋâ ekŋâ bâliŋâ mân sâban.’ ");
INSERT INTO kpf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Yatâ muyagei sâp karâmbut oi isenŋoot sumbemân zarip. ");
INSERT INTO kpf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kut ŋâi ŋâi zo zari Kaisarea kamânân gâbâ a karâmbut nâ mirâ ândiwanân, zoren gawe. A karâmbut zo patâziŋâ zâk sâŋgonzâŋgoi gawe. ");
INSERT INTO kpf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Gane Kaapumŋâ itâ sâm dâtnogip, ‘Gâ zen sot âibam keŋgât mân upan.’ Oi âibâ sa Yesugât kâmurân gâbâ a nâmburân kânok nâ sot âiwen. Âi takâm kâwali a sâtŋâ, zâkkât mirin zâiwen. ");
INSERT INTO kpf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Zarindâ den siŋgi itâ sâm dâtnâŋgoip, ‘Nâgât mirin sumbem a ŋâiŋâ muyagem kin itâ sâm dâtnogip, “Gâ Yope kamânân kore a sâŋgonzâŋgona âi Simoŋ, kutŋâ ŋâi Petero diim gabi. ");
INSERT INTO kpf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Zâkŋâ gamŋâ gâ sot a ambârâpkâ, zen Kembugât siŋgi upigât den dâzâŋgobap.” ’ ");
INSERT INTO kpf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Oi nâ siŋgi âlipŋâ dâzâŋgua mârum Tirik Kaapum neŋgâren geip, zo yatik zeŋgâren geip. ");
INSERT INTO kpf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Oi nâ zo ekŋâ Yesuŋâ den dâtnâŋgoip, zo nâŋgâwan. Den zo itâ, ‘Yohaneŋâ too saŋgonziŋgip. Nâŋâ ko Tirik Kaapum saŋgonziŋgâbat.’ ");
INSERT INTO kpf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Oi nen Kembuniŋâ Yesu Kristo nâŋgâm pâlâtâŋ kwâindâ Kaapumŋâ niŋgip, zo yatik zen utne ziŋgip. Oi ko nâ dap yatâ Anutu kwâkâŋaŋgâbam?” ");
INSERT INTO kpf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Yatâ sâm dâzâŋgoi nâŋgâmŋâ umziŋ diim gei Anutu sâm âlip kwâkŋaŋgâm itâ sâwe, “Opoŋ, Anutuŋâ a kamân ŋâin gok umziŋ melâŋi ândiândiŋ kâtikkât siŋgi upigât kwatziŋgip.” ");
INSERT INTO kpf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Setepano komŋâ Yesugât kâmut zâŋgonetâ siŋsururuŋ op kamân toren toren âiwe. Nâmbutŋandâ Poinike, Kipiro sot Antiokia kamânân âiwe. Âi ândim kamân zoren Yuda a ândiwe, zorik siŋgi âlip dâzâŋgom ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Oi Kipiro sot Kirene kamânân gok ândiwe, zen Antiokia kamânân âimŋâ hân ŋâin gok Kembu Yesugât den siŋgi dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Oi Kembuŋâ imbaŋâ ziŋgi a ambân doŋbep patâ zen den siŋgi âlipŋâ nâŋgâm umziŋ melâŋ Kembu nâŋgâm pâlâtâŋ kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Zorat den siŋgi Yerusalem kamânân ari Yesugât kâmut zen Banaba sâŋgongune Antiokia kamânân arip. ");
INSERT INTO kpf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Âi takâmŋâ Kembuŋâ kubikziŋgip, zo ekŋâ umŋâ âlip oip. Oi Kembugâren pâlâtâŋ op kâtigem kinbigât den dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba zâk a âlipŋâ sot nâŋgâm pâlâtâŋoot. Tirik Kaapumŋâ umŋan piksâm zeip. Oi kamân zoren a ambân doŋbep zen Kembugât a urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Oi Banaba zâk Saulo muyagibam Taso kamânân arip. ");
INSERT INTO kpf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Âi muyagem diigi Antiokia kamânân âiwet. Zoren kendon patâ ŋâigât umŋan zoren Yesugât kâmut zeŋgât minduminduyân a doŋbep Yesugât den siŋgi dâzâŋgom ândiwet. Antiokia kamânân Yesugât kâmut a zo zeŋgât kutziŋâ Kristo a sâm muyagiwe. ");
INSERT INTO kpf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Narâk zoren Propete nâmbutŋâ zen Yerusalem kamânân gâbâ Antiokia kamânân âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Oi zeŋgâren gâbâ a ŋâi kutŋâ Agabo. Zâk Kaapumŋâ okŋaŋgi hân dâp pu patâ muyagibap, zorat den kânŋan sâip. (Roma zeŋgât a kutâ Klaudio ândei pu zo âsageip.) ");
INSERT INTO kpf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Oi Yesugât kâmut zen den so nâŋgâm kât zemziŋgip dâp mindumŋâ Yudaia hânân bukurâpziŋ ândiwe, zeŋgâren pane âibapkât sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Oi kât muyagiwe, zo Banaba sot Saulo zikâne mem Yerusalem kamânân âi Yesugât kâmut, zeŋgât galem a ziŋgâwet. ");
INSERT INTO kpf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Narâk zoren a kutâ Herodeŋâ Yesugât kâmut a nâmbut zâŋgom tâk namin zâmbarip. ");
INSERT INTO kpf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Oi zâkŋâ sâi arâpŋâ Yohanegât âtâŋâ Yakobo gâsum sâuŋâ kârâne moip. ");
INSERT INTO kpf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","4","Yatâ oi Yuda a zen ekŋâ umziŋ âlip oi Herodeŋâ zo ekŋâ sâi arâpŋâ zen Petero gâsune Yuda zeŋgât kendon ŋâi kutŋâ Pasowa mâte oi tâk namin pane kâwali a kiin nâmburân kânok, zen galem upigât sâm ziŋgip. Herodeŋâ itâ nâŋgip, “Pasowa kendon âki Petero diim ga a mâteziŋan sa kumbi.” ");
INSERT INTO kpf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Oi Petero zâk tâk namin tâi Yesugât kâmut zen âsâbâŋ zâkkât op Anutugâren ninâu sâmarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Oi Herode zâk Petero mukan a ambân tirâpzâŋgom kumbatkât sâip, ŋâtik zoren kâwali a zagât zikŋâ Petero tâk kâtikŋâ zagât saam galem op mem ziwet. Oi kâwali a nâmbutŋâ, zen namâ mâtâbân galem kirâwe. ");
INSERT INTO kpf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Oi Kembugât sumbem a ŋâi namâ kâligen muyagem kiri âsakŋandâ namâ umŋan âsagei sumbem aŋâ Petero gâŋgemunŋan gâsum mângimŋâ sâip, “Kek zaat.” Sâi tâk kâtik Petero bikŋan tâip, zo siksâm geip. ");
INSERT INTO kpf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Oi sumbem aŋâ itâ sâm dukuip, “Inzutkâ lapŋâ kipâkegâ mem pâna giarik.” Yatâ oi sumbem aŋâ du zagâtŋâ sâm dukuip, “Hâmbâgâ pâna giari molini.” ");
INSERT INTO kpf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Sâi Peteroŋâ molim âimŋâ itâ nâŋgip, “Zi uman eksan.” Sumbem aŋâ oip, zo nâŋgi yenŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Oi zet mâtâp zagât walâm mâtâp patin takitâ hâŋgi zo zikŋak mem pam kirip. Oi geim mâtâbân mâik ŋâi âimŋâ sumbem a zorâŋ pamŋâ buŋ op arip. ");
INSERT INTO kpf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Oi Petero zâk nâŋgânâŋgâŋâ pâroŋsâi itâ sâip, “Zi nâŋgan. Kembu zâk sumbem a sâŋgongoi Herode sot Yuda a, zeŋgât bitziŋan gâbâ mâkânigap.” ");
INSERT INTO kpf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Yatâ nâŋgâm âim Yohane Mareko, zâkkât mamŋâ Maria, zâkkât mirin takip. Zoren a ambân doŋbepŋâ mindum ninâu sâm tarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Oi Peteroŋâ mirâ hâŋgiyân âi kom kiri kore ambân ŋâi kutŋâ Rode, zâk ŋâiŋâ kwap sâmŋâ gâip. ");
INSERT INTO kpf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Gamŋâ Peterogât diŋ tobat nâŋgâm sâtâre op hâŋgi mân mem pam âburem mirâ kâligen âimŋâ Petero ga kinzap sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Yatâ sâm dâzâŋgoi nâŋgâm sâwe, “Gâ umgâ gulip uap.” Zâkŋâ ko kâtigem sâip, “Zâk perâkŋak ga kinzap.” Sâi zen sâwe, “Zo zâkkât sumbem aŋandâ ga kinzap.” ");
INSERT INTO kpf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Oi Petero zâk kom kiri mâtâp mem pam zikŋâ ekŋâ imbaŋâziŋ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Oi zen den birâbigât bikŋandâ dâp oi den birâne Kembuŋâ tâk namin gâbâ olaŋ diim gâip, zorat den siŋgi dâzâŋgoip. Dâzâŋgomŋâ sâip, “Yakobo sot buku nâmbut nâgât den siŋgi dâzâŋgonek.” Ya sâm dâzâŋgomŋâ zâmbam mulukŋem ŋâin tik arip. ");
INSERT INTO kpf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Haŋsâi kâwali a zen Petero kârumŋâ dap op buŋ uap sâmŋâ kwagâwe. ");
INSERT INTO kpf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Oi Herodeŋâ kârum muyagibigât sâi kârumŋâ mân muyagine kâwali a zen Petero galem urâwe, zo zâŋgone mumbigât sâip. Oi Yudaia hân birâm Kaisarea kamânân âi ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herode zâk narâk zoren Tiro Sidoŋ kamân zagât zeŋgât kâsa otziŋgip. Oi kamân zorat mâirâpŋâ zen mindum den sâm kubiknam Herodegât a sâtŋâ ŋâi kutŋâ Bilasto den dukune buku otziŋgip. Zen Herodegât hânân nalem memarâwe, zo buŋ opapkât lumbeŋâ den dukuwe. ");
INSERT INTO kpf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Oi Herode zâk den mâburem dâzâŋgobapkât narâk mâte oi Herode zâk hâmbâ neule âlipŋâ pam a kutâgât tâtatŋan tap a ambân den dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Den dâzâŋgoi a aksik den kwamit patâ sâm itâ sâwe, “Den zo a den buŋâ. A zo Kembu patâ.” ");
INSERT INTO kpf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herode zâk den zo nâŋgâm mân kwâkâziŋgipkât Kembugât sumbem a ŋâiŋâ zorenâk koip. Oi nane ziŋâ umŋan bagim zine moip. ");
INSERT INTO kpf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Anutugât denŋâ ko lâmbatŋâ laŋ kârâm sambâlem zeip. ");
INSERT INTO kpf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Oi Banaba sot Saulo zet Yesugât kâmut Antiokia kamânân ândiwe, ziŋâ nep diŋ sâm zikâwe, zo Yerusalem kamânân tuum naŋgâm Antiokia kamânân âburiram Yohane Mareko diigitâ ârândâŋ âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokia kamânân Yesugât kâmut, zeŋgâren Propete nâmbutŋâ ândiwe. Kutziŋâ itâ Banaba sot Simoŋ (Zak a sumun konsâmarâwe.), Lukio Kirene kamânân gokŋâ sot a ŋâi kutŋâ Manaeŋ. Zâk a kutâ Herode tâlaŋâ. Zet ârândâŋ ândim lâmbarâwet. Oi ŋâi Saulo. ");
INSERT INTO kpf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Oi sirâm ŋâin zen mindum Anutu mâpâsinam nalem birâm mâpâsem ândine Tirik Kaapumŋâ den itâ sâm dâzâŋgoip, “Zen Banaba sot Saulo nep diŋ sâm zikâwan, zo tuubabotkât sâŋgonzâkonek.” ");
INSERT INTO kpf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Sâi nalem birâm ninâu sâmŋâ bitziŋâ kâukzikŋan pam sâŋgonzâkone âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tirik Kaapumŋâ yatâ opŋâ sâŋgonzâkoi zet âi Seleukia kamân saru sâtŋan âi takâwet. Zo takâm waŋgâyân zâim âi Kipiro hân saru tânâmŋan âi takâwet. ");
INSERT INTO kpf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Oi zoren kamân patâ kutŋâ Salami, zoren âi takâm Yuda a zeŋgât mâpâmâpâse namin zâi Anutugât den siŋgi âlip sâm dâzâŋgowet. Yohane Mareko zâk zet sot âim betzikŋan mem ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Oi hân torengen gâbâ gamŋâ Papo kamânân takâwe. Zo gam Yuda a ŋâi, kware a sot propete sarâŋâ ândeip, kutŋâ Bara-Yesu, zâk muyagiwe. ");
INSERT INTO kpf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","A zâk galem a ŋâi kutŋâ Seregio Paulo zâk sot pâlâtâŋ op ândeip. Oi Seregio Paulo zâk a nâŋgânâŋgâŋoot. Zâk Anutugât den nâŋgâbapkât Paulo sot Banaba diiziki mirâŋan zâiwet. ");
INSERT INTO kpf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Diiziki kware a Elima (Kot zo kware a zorat sâmarâwe.), zâkŋâ Saulo sot Banaba kâsa otzikip. Galem a zâk siŋgi âlipŋâ mân nâŋgâbapkât sâip. ");
INSERT INTO kpf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Yatâ oi Saulo, kutŋâ ŋâi Paulo sâmarâwe, zâkkât umŋan Tirik Kaapum piksâi Elima itâ sâm dukuip, ");
INSERT INTO kpf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Sataŋgât nanŋâ, gâ. Gâ kut ŋâi ŋâi târârak, zorat kâsaŋâ. Umgan sarâ sot bâliŋâ piksâm ziap. Gâ Anutugât mâtâp târârak zo dooŋgumat. Zo narâk ikâ zoren birâban? ");
INSERT INTO kpf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Zorat Kembu imbaŋâŋaŋgât kulem ikpan. Gâ siŋgâ ŋâtâtik kâri narâk ziren âsakŋâ mân ek ândiban.” Yatâ sâi zorenâk siŋâ ŋâtâtik kâri gâsum birâbirâ op a ŋâi bikŋan gâsum diibapkât sâip. ");
INSERT INTO kpf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Âsagei galem a zo ekŋâ Kembugât siŋgi âlip, zorat nâŋgi imbaŋâ oi nâŋgâm pâlâtâŋ kwâip. ");
INSERT INTO kpf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo sot arâpŋâ zen Papo kamân birâm waŋgâyân zâimŋâ âim Pampilia hânân, Perege kamânân takâwe. Zoren Yohane Mareko zâpam Yerusalem kamânân âbureip. ");
INSERT INTO kpf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Oi zen ko Perege kamânân gâbâ âimŋâ Pisidia hânân Antiokia kamân ŋâin, zo takâwe. Zoren ândim Yuda zeŋgât kendon oi mâpâmâpâse namin zâi tarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Oi mâpâmâpâse namâ galem a zen gurumin den sot Propete a zeŋgât ekabân den sâlâpkumŋâ itâ dâzâŋgowe, “A bukuzatniŋâ zekâren den ŋâi ziap oi ko sâitâ nâŋgânâ.” ");
INSERT INTO kpf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Sâne Paulo zâk zaatŋâ hiriŋsâbigât bikŋandâ dâp opŋâ itâ sâm dâzâŋgoip, “Isirae a sot a nâmbutŋâ Anutu mâpâsime, zen aksik den dâzâŋgua nâŋgânek. ");
INSERT INTO kpf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isirae neŋgât Anutu, zâk sâkurâpniŋâ gâsum sâlâpzâŋgone Aigitâ hânân âi ândim kâmut patâ urâwe. Anutugât imbaŋâŋandâ zobâ diiziŋgâm gâip. ");
INSERT INTO kpf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Oi zen hân a mân ândiândiŋan diiziŋgâm ândei kendon patâ 40 âkip. Narâk zoren zâkkât den kwâkâne mân birâziŋgâmâip. ");
INSERT INTO kpf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Oi Kanaan hânân a kâmut nâmburân zagât zâŋgomŋâ hân zo sâkurâpniŋ ziŋgi zen hân zo kâsâpkum mem ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ândine kendon patâ 450 yatâ âkip. Oi Kanaan hânân ândinetâ den kubikkubik a muyageziŋgi ândine Propete Samue âsageip. ");
INSERT INTO kpf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Narâk zoren a kutâgât sâne Anutuŋâ Benyamin kiurâp zeŋgâren gâbâ Kisi nanŋâ Saulu ziŋgip. Zâkŋâ a kutâ op galem zâŋgoi kendon patâ 40 yatâ ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Oi Anutuŋâ zâk kâbakŋei zâkkât gebâkŋan Dawidi a kutâ kwânâŋgip. Oi zâkkât den itâ sâip, ‘Nâ Yesegât nanŋâ Dawidi muyagian. Zâk eksa a âlipŋâ uap. Nep diŋ sâm pindâbat, zo tuum naŋgâbap.’ ");
INSERT INTO kpf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Oi Dawidigât kiurâpŋâ zeŋgâren gâbâ Isirae a neŋgât kubikkubik a muyagibapkât sâip. Zo bon upapkât Anutuŋâ sâi Yesu âsageip. ");
INSERT INTO kpf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesuŋâ nep topkwap mân tuugi Yohaneŋâ Isirae a ambân umziŋ melânŋe too sâŋgonziŋgâbapkât dâzâŋgom ândeip. Zo yatâ a ambân kubikziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Oi Yohane zâk nep zo tuum naŋgâm itâ sâip, ‘Nâgât itâ sâme. A gâbapkât sâme, zo nâ. Nâ a zo buŋâ. Zikŋâ bet gam taap. Zâk patâ oi nâŋâ zâkkât irâ sikum goribat zo ko mân dâp upap.’ ");
INSERT INTO kpf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","A bukurâpnâ, Abaramgât kiurâp zen sot a nâmbutŋâ Anutu mâpâsime, nâŋâ den sa nâŋgânek. Kubikubik den zi neŋgât op geip, ziap. ");
INSERT INTO kpf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yerusalem mâirâp sot a sâtŋâ ziŋâ Yesu ekŋâ topŋâ mân nâŋgâm mumbapkât sâwe. Zen yatâ utnetâ Propete a zeŋgât den kânŋan sâsâŋ kendon dâp sâlâpkume, den zo kâtigeip. ");
INSERT INTO kpf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Zen Yesu tosaŋaŋgât kârum mân muyagem laŋ sâne Pilatoŋâ koi moip. ");
INSERT INTO kpf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Oi Kembugât ekabân den zeip, zo op naŋgâm poru nagân gâbâ mâkâm kât mâtâpŋan âi parâwe. ");
INSERT INTO kpf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ka Anutuŋâ mumuŋan gâbâ mâŋgei zaarip. ");
INSERT INTO kpf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Oi zâk sot Galilaia hânân gâbâ Yerusalem kamânân ârândâŋ âiwe, zeŋgâren sirâm nâmbutŋan muyageziŋgâm ândeip. Muyagei igâwe, zen ko zâkkât siŋgi sâsâŋ a opŋâ a ambân dâzâŋgom ândie. ");
INSERT INTO kpf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nen umâlep den dâzâŋgonam gen. Anutuŋâ sâkurâpniŋâ kut ŋâi ŋâi siŋgi dâzâŋgoip, zorat bonŋâ âsagiap. ");
INSERT INTO kpf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Anutuŋâ Yesu mângei neŋgâren bonŋâ muyagiap. Zorat umâlep den dâzâŋgonam gen. Psalm daŋgon zagât, zoren den itâ kulemguwe, ‘Gâ nâgât nannâ. Irak gasum sâlâpgogan.’ ");
INSERT INTO kpf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yesu mumuŋan gâbâ mâŋgei zaarip. Oi Yesu zâk mân mom alâgibap, zorat Anutuŋâ den itâ sâip, ‘Nâ Dawidigât siŋgi sâwan, zorat bonŋâ zinziŋ kâtik, zo ziŋgâbat.’ ");
INSERT INTO kpf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Oi Psalm ekabân den ŋâi itâ ziap, ‘Gâ tirik agâ mân birânina mom alâgibat.’ ");
INSERT INTO kpf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dawidigât nâŋgâme. Zâk Anutuŋâ nep diŋ sâm pindip, zo arâp zeŋgâren tuum âim moip. Moi sâkurâp zeŋgât kwagân hângune alâgeip. ");
INSERT INTO kpf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ka Dawidigât kiunŋâ Yesu, zâk ko mân alâgeip. Anutuŋâ mumuŋan gâbâ mâŋgei zaarip.” ");
INSERT INTO kpf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Yatâ sâmŋâ Pauloŋâ itâ sâm dâzâŋgoip, “A bukurâpnâ, dâzâŋgua nâŋgânek. Bâliŋâ guligulipkuŋ, zo a zorâŋ muyageipkât zorat den mâte otziŋgap. ");
INSERT INTO kpf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mosegât gurumin den, zo bâliŋâziŋ gulipkubam oseip. Yesugâren nâŋgâm pâlâtâŋ kwatne bâliŋâziŋâ zo gulipkubap. ");
INSERT INTO kpf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Propete zeŋgâren den itâ zo kâtigibapkât itâ dâzâŋguan, ");
INSERT INTO kpf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘A zen den nâŋgâm kwâkâkwâkâŋâ zeŋgâren nep top ŋâi tuubat. Ziŋâ zorat nâŋgâne bon buŋ upap. Zen kut ŋâi zo ekŋâ kwakŋâ mumbi.’” ");
INSERT INTO kpf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Oi Pâulo sot Banaba zet mâpâmâpâse namin gâbâ geitâ kendon ŋâin yatik dâzâŋgobabotkât sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Oi minduminduyân gâbâ gem Yuda a doŋbep sot kamân ŋâin gâbâ Anutu mâpâsemarâwe, zen aksik Paulo Banaba zet sot âim den utne Paulo sot Banaba zet zen Anutugât lumbeŋan ândibigât dâzâŋgowet. ");
INSERT INTO kpf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Bet kendon ŋâin mâte oi kamân zorat mâirâp a topŋâ topŋâ zen aksik minduyaŋgâm Anutugât den nâŋgânam gawe. ");
INSERT INTO kpf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mindum gane Yuda a ziŋâ ziŋgitŋâ nâŋgâm bâliŋ kwatziŋgâm Paulogât den mem gei kwarâwe. Oi sâm bâliŋ kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Yatâ utnetâ Paulo sot Banaba zet den keŋgât buŋâ itâ sâm dâzâŋgowet, “Yuda a zen Anutugât den kândom dâzâŋgonatkât sâsâŋ. Ka Yuda a zen kândâtkomŋâ ândiândigât siŋgi mân utnatkât se, gât ko zâmbamŋâ hân ŋâin gok zen siŋgi âlip dâzâŋgonat. ");
INSERT INTO kpf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kembu zâk zorat itâ sâm dâtŋângoip, ‘Zen hân toren toren a zeŋgât âsakŋâ zâmbarâwan. Oi a zen Anutugât mâtâp ekŋâ zoren âi ândibi.’” ");
INSERT INTO kpf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Yatâ sâitâ hân ŋâin gokŋâ zen den zo nâŋgâm umziŋ âlip oi Kembugât den sâm bâbâlaŋ kwârâwe. Oi ândiândi kâtikkât siŋgi urâwe, zen den zo nâŋgâne bon oip. ");
INSERT INTO kpf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Oi hân zoren Kembugât den laŋ kârâm arip. ");
INSERT INTO kpf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yuda a ziŋâ kamân zorat a sâtŋâ sot ambân sikumziŋoot zen Anutu mâpâsemarâwe, zo den dâzâŋgone um kâlak op Paulo sot Banaba kâsa otzikâm molizikâne âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Âiram kinzikŋan gwapgwap tuugitâ gei kândâtzâŋgom Ikonioŋ kamânân âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aritâ Yesugât kâmut kamân birâwet, zo zen umziŋan Tirik Kaapum piksâm zei sâtâre kwâkŋan ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Oi Ikonioŋ kamânân takâm yatigâk Yuda a zeŋgât mâpâmâpâse namin zâimŋâ siŋgi âlipŋâ imbaŋâŋoot sâm dâzâŋgowet. Dâzâŋgoitâ Yuda a sot hân ŋâin gok doŋbepŋâ Yesugât kâmut urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yuda a nâmbutŋâ zen ko siŋgi âlip zo kândâtkom a hân ŋâin gokŋâ den dâzâŋgonetâ Kristogât kâmut kâsa otziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Zet zoren narâk kârep ândim Kembugâren nâŋgâm pâlâtâŋ kwap siŋgi âlip keŋgât buŋ sâm ândiwet. Kembuŋâ imbaŋâ ziki sen mârât kulem top top tuum ândiwet. ");
INSERT INTO kpf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kamân zorat a zen kâsâpagom nâmbutŋâ zen Yuda zeŋgât a utne nâmbutŋâ zen Aposolo zekât a urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Oi Yuda a sot hân ŋâin gokŋâ zen Aposolo kâtŋâ zâkonat sâm mindum gawe. ");
INSERT INTO kpf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Gâne nâŋgâm kamân zo birâm Likaonia hânân âiwet. Oi zoren Listera sot Derebe kamânân sot kamân mâik mâik tap arip, zoren âi den siŋgi âlip dâzâŋgom ândiwet. ");
INSERT INTO kpf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listera kamânân a ŋâi tâip. Zâk kiŋ toren toren mom zeip. Zâk mam kâmboŋan gâbâ zo yatâ muyagem mân lâŋ âim gâmâip. ");
INSERT INTO kpf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Zâk zo zem tâi Pauloŋâ den siŋgi âlip sâi ek tâi Pauloŋâ ekŋâ itâ nâŋgip, “A zo sâkŋâ âlip upapkât nâŋgâm pâlâtâŋ âlip zemŋâŋgap.” ");
INSERT INTO kpf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Yatâ nâŋgâm den kâtik itâ sâm dukuip, “Gâ kiŋgandâ lâŋ zaat kin.” Sâi a zo pirindiŋ zaat âim gâip. ");
INSERT INTO kpf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Oi a kâmut patâ zen Pauloŋâ sen mârât kulem tuugip, zo ekŋâ Likaonia denân itâ sâwe, “Bem zagât zet a osetniŋan ga ândiabot.” ");
INSERT INTO kpf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Oi Banaba zâk bem ŋâi kutŋâ Dia, zâkkât kutŋâ pindâwe. Oi Paulo zâk den sâsâŋ a oipkât bem ŋâigât kutŋâ Hemesi pindâwe. ");
INSERT INTO kpf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kamân zoren Diagât namâ ŋâi kirip. Namâ zorat galem aŋâ, zâkŋâ sâi makau sot neule mem gam kamân mâtâbân namâ tâibân a ziŋâ aksik a zagât, zekât siŋgi makau kom unam urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Oi Aposolo Paulo sot Banaba zet zo nâŋgâm pârâkpam hâmbâzik mem giŋbololoŋ mem a osetziŋan âim den kwamit patâ itâ sâwet, ");
INSERT INTO kpf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“O a ambân, zen dap ue? Net a yenŋâ, zen yatâ. Net den siŋgi âlipŋâ dâzâŋgoram get. Zen Bem lopio sot kut ŋâi ŋâi bon buŋ zo kândâtzâŋgom Anutu, ândiândi mariŋâ, zâkkât den nâŋgâbigât sâmet. Zâkŋâ hân sot sumbem sot saru sot kut ŋâi ŋâi top topŋâ muyageziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","17","Oi ândim gawe, narâk zoren a zen nâŋgâziŋgi umziŋaŋgât ândiândi mâtâp muyagem ândiwe. Oi ziŋgit mân kubikziŋgip. Topŋâ nâŋgâbigât buku otziŋgâm sâi map sot maaŋâ sambe muyageziŋgi nem seroŋkwap ândiwe.” ");
INSERT INTO kpf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","A zagât zo den zo yatâ sâmŋâ kwâkâziŋgâm den imbaŋâ sâitâ zekât siŋgi nalem unat sâm urâwe, zo birâwe. ");
INSERT INTO kpf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Zo ândeitâ Antiokia kamânân gâbâ sot Ikonioŋ kamânân gâbâ Yuda a nâmbutŋâ, zen gam Listera kamân mâirâp zen sot den sâm saam Paulo kâtŋâ kuwe. Kune mom zei muap sâm diim kamân ginŋan gei parâwe. ");
INSERT INTO kpf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Oi zoren zei Yesugât kâmut zen gam haamgum kine Pauloŋâ zaat kamânân arip. Haŋsâi Paulo sot Banaba zet Derebe kamânân âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Oi kamân zoren den siŋgi âlip sâitâ a ambân doŋbep patâ zen nâŋgâm Yesugât kâmut urâwe. Yatâ op mâtâp âiwet, zorik puriksâm Listera, Ikonioŋ sot Antiokia kamânân âburem gawet. ");
INSERT INTO kpf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Antiokia kamânân gamŋâ Yesugât kâmut nâŋgâm kâtigibigât den dâzâŋgomŋâ itâ sâwet, “Nen sâknam kwâkŋan ândim Anutu um topŋan ândiândiŋ, zoren takânat.” ");
INSERT INTO kpf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Oi Yesugât kâmut dâp galem a mem sâlâpzâŋgom nalem birâmŋâ zeŋgât opŋâ Kembugâren ninâu sâwe. Galem a zen Kembugâren nâŋgâm pâlâtâŋ kwâkŋaŋgâwe. Oi Aposolo zet Kembu zâkkâren zâmbarâwet. ");
INSERT INTO kpf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Oi Pisidia hân walâm âim Pampilia hânân takâwet. ");
INSERT INTO kpf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Zoren takâm Perege kamânân den siŋgi âlip dâzâŋgomŋâ Atalia kamânân geiwet. ");
INSERT INTO kpf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Zoren gei waŋgâyân zâim âim Antiokia kamânân âiwet. Kamân zoren mârumŋan Yesugât kâmut zen Anutugât um lumbeŋan zâpan nep diŋ sâm zikâne nep topkwap tuum âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Zoren takâmŋâ a ambân minduziŋgâm Anutuŋâ galem otzikâm hân ŋâin gokŋâ mâtâp mem ziŋgi nâŋgâm pâlâtâŋziŋoot urâwe, zorat den ziŋgi sâm dâzâŋgowet. ");
INSERT INTO kpf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Narâk kârep zo Yesugât kâmut zen sot ândiwet. ");
INSERT INTO kpf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ândine Yudaia hânân gâbâ a nâmbutŋâ Antiokia kamânân gam Yesugât kâmut itâ sâm dâzâŋgom ândiwe, “Zen Mosegât gurumin den mân lum kwabâ mân kwaraŋgâbi zo ko Kembugât siŋgi mân upi.” ");
INSERT INTO kpf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Yatâ sânetâ Paulo sot Banaba zen sot den kwâkâyaŋgâwe. Yatâ op den itâ sâwe, “Paulo sot Banaba sot Yesugât kâmut zeŋgâren gâbâ a nâmbutŋâ ziŋâ Aposolo sot Yesugât kâmut zeŋgât galem a Yerusalem kamânân ândiwe, zeŋgâren den zo mem âibi.” ");
INSERT INTO kpf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Yatâ sânetâ Yesugât kâmut ziŋâ Paulo sot Banaba sot a nâmbut sâŋgonzâŋgone âiwe. Âimŋâ Poinike sot Samaria hânân kamânŋâ kamânŋâ a hân ŋâin gokŋâ ziŋ Anutugât a urâwe, zorat den siŋgi dâzâŋgom âiwe. Dâzâŋgone Yesugât kâmut zen nâŋgâm umâlep patâ urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Yerusalem kamânân takâne Aposolo sot Yesugât kâmut sot zeŋgât galem a, zen sâm sâtâre otziŋgâwe. Anutuŋâ tânzâkoi nep tuugitâ bon oip, zorat den siŋgi dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Den siŋgi zo dâzâŋgone Yesugât kâmurân a nâmbutŋâ Parisaio zeŋgât kâmurân gâbâ zen itâ sâwe, “Kamân ŋâin gokŋâ zen kwabâ kwaraŋgâbi. Oi zen Mosegât gurumin den lubigât sâm dâzâŋgobi. Zen zo yatâ mân utne Yesugât kâmurân ândine mân dâp upap.” ");
INSERT INTO kpf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Aposolo sot Yesugât kâmut zeŋgât a sâtŋâ, zen den zo sânam minduwe. ");
INSERT INTO kpf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Mindumŋâ den âragune ko Peteroŋâ zaatŋâ itâ sâm dâzâŋgoip, “A bukurâpnâ, a hân ŋâin gok siŋgi âlip dâzâŋgowan, zo Anutuŋâ mârumŋan nâ gâsum sâlâpnogi dâzâŋgua nâŋgâm Yesugât kâmut urâwe, zo nâŋge. ");
INSERT INTO kpf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Oi Anutu zâk a umziŋ ekmap, zâkŋâ Yuda nen Tirik Kaapum niŋgip, yatikgâk a hân ŋâin gokŋâ ziŋgi igâwen. ");
INSERT INTO kpf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Zen zâk nâŋgâm pâlâtâŋ kwatne umziŋ saŋgon kubik, nen otniŋgip, zo yatik otziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Zen wangât Anutu walânam ue? Kut ŋâi ŋâi yâmbâtŋâ zo nen sot sâkurâpniŋâ lum osiwen. Zo yatigâk hân ŋâin gok Yesugât kâmut zeŋgât kwâkziŋan pânat sâm se? ");
INSERT INTO kpf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Yatâ buŋâ. Nen itâ nâŋgen. Yuda a sot hân ŋâin gokŋâ Kembu Yesu um lâklâkŋaŋgât op zâkkât siŋgi uen.” ");
INSERT INTO kpf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Yatâ sâi a kâmut mindum tarâwe, zen aksik den zo nâŋgâm den buŋ tarâwe. Tatne Banaba sot Paulo zet Anutuŋâ nepzikŋâ galem op hân ŋâin zeŋgâren kulem top top tuugip, zorat den siŋgi otziŋgâwet. ");
INSERT INTO kpf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Zet dâzâŋgom naŋgitâ Yakoboŋâ den itâ sâm dâzâŋgoip, “A bukurâp, den sa nâŋgânek. ");
INSERT INTO kpf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Mârumŋan Anutuŋâ hân ŋâin gok zeŋgâren gâbâ kâmut ŋâi zâkkât siŋgi upigât diiziŋgip. Zorat siŋgi Simoŋâ sâi nâŋgen. ");
INSERT INTO kpf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Zorat Propete zeŋgât ekabân Kembugât den ŋâi itâ ziap, ");
INSERT INTO kpf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Nâŋâ gâtâm âburem Dawidigât silep bâliap, zo kubikpat. ");
INSERT INTO kpf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Siŋitŋâ sândum kubik tuubat. Oi a ambân zen Kembu noonsâm kârunim mâte otnibi. Hân ŋâin gokŋâ zen nâgât siŋgi sâwan, zen yatik upi. ");
INSERT INTO kpf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kembu zâk den yatik sâip. Zo mârumŋan sâm muyageip.’ ");
INSERT INTO kpf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Oi zorat nâŋâ itâ san. Niŋâ hân ŋâin gokŋâ zen Anutugât a upi, zen kut ŋâi ŋâi yâmbâtŋâ mân ziŋgânat. ");
INSERT INTO kpf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ka zen nalem bem mo lopiogât siŋgi kwatne zo mân nimbi. Ap ambin zet mân birâyaŋgâbabot. Zuu bâu gilâm sot sunum gilâmŋoot zo mân nimbi. Kut ŋâi ŋâi zo birâbigât ekap kulemgum ziŋgânat. ");
INSERT INTO kpf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mosegât gurumin den zo mârumŋan gâbâ sâkurâpniŋandâ topkwap kamân dâp mâpâmâpâse namin sâlâpkum nâŋgâm ândimen sot zâkkât den zo kamân dâpniŋ sâm gawen. Zorat nen gurumin den zorat mân sânat.” ");
INSERT INTO kpf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Oi Aposolo sot a sâtŋâ sot Yesugât a kâmut, zen zorat nâŋgâne dâp oi zeŋgâren gâbâ a zagât muyagezikâwe. Ŋâi kutŋâ Yuda, kutŋâ ŋâi Basaba sot a ŋâi kutŋâ Sila. Zet Yesugât kâmurân a sâtŋâ urâwet. Zet Paulo sot Banaba zet sot ârândâŋ Antiokia kamânân âibigât sâŋgonzâkowe. ");
INSERT INTO kpf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Oi ekap ŋâi itâ kulemgum zikâne mem âiwet. “O bukurâpniŋâ, bukurâpziŋâ Aposolo sot galem a, nen ekap zi kulemgum pen. Oi hân ŋâin gok Antiokia kamânân sot Siria sot Kilikia hânân ândie, zeŋgât sâtâre opŋâ ekap zi pen. ");
INSERT INTO kpf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nen mân nâŋgindâ ziren gabâ a nâmbutŋâ zeŋgâren gam den ŋâi dâzâŋgone kwakmak urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Yatâ utnetâ nen nâŋgâm umniŋ kânok oi a zagât mem sâlâpzâkoindâ bukuzatniŋâ Paulo sot Banaba zet sot zeŋgâren ge. ");
INSERT INTO kpf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Paulo sot Banaba zet Kembu Yesu Kristo, zâkkât opŋâ ândiândizikŋâ buŋ upapkât mân keŋgât op nebân âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Oi zagât Yuda sot Sila sâŋgonzâkoindâ ekabân den ziap, zo lâuzikŋan gâbâ nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tirik Kaapum sot nen nâŋgâm kut ŋâi ŋâi yâmbâtŋan mân târokwâtnat. Zo yatâ zo ko ziŋgânam sen, zo itâ. ");
INSERT INTO kpf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Zen nalem bem lopigât siŋgi sâne zo mân nimbi. Gilâm sot zuu gilâmziŋoot mân nimbi. Ap ambin zet mân birâyaŋgâbabot. Zen den zo lum âlip ândibi. Zo yatik. Kelikmelik ândibi.” ");
INSERT INTO kpf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Oi a ambân kâmut, zen a zo sâŋgonzâŋgone Âiwe. Âim Antiokia kamânân takâm Yesugât kâmut minduziŋgâm ekap zo ziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ziŋgâne mem sâlâpkum nâŋgâm umziŋ âlip oip. ");
INSERT INTO kpf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Oi Yuda sot Sila zet Propete ândiwetŋâ den doŋbep sâm dâzâŋgoitâ a ambân umziŋ âlip oi Kembugât den luluyân kâtigiwe. ");
INSERT INTO kpf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Oi narâk ŋâi zet zen sot ândimŋâ âiram oitâ bukurâpzik zen um lumbe den dâzâkom sâŋgonzâkone âburiwet. ");
INSERT INTO kpf_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sila zâk zen sot ândibat sâip. ");
INSERT INTO kpf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo sot Banaba zet Antiokia kamânân târokwap ândiwet. Zet sot a doŋbep zen Kembugât den a ambân dâzâŋgom ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ândim Pauloŋâ Banaba itâ sâm dukuip, “Net kamânŋâ kamânŋâ âim Kembugât den dâzâŋgowet, zoren âim bukurâpniŋâ dap yatâ ândie, zo âi ziŋgit nâŋgârat.” ");
INSERT INTO kpf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Yatâ sâi Banaba zâk Yohane Mareko diiŋaŋgitâ ârândâŋ âibigât sâip. ");
INSERT INTO kpf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Mareko zâk mârum zet sot âim Pampilia hânân zâpamŋâ âbureipkât Pauloŋâ zâk sot âibam nâŋgi mân dâp oip. ");
INSERT INTO kpf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Oi Paulo sot Banaba zet den sârek op kâsâpagom Banaba zâk Mareko diim waŋgâyân zâim Kipiro hânân âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pauloŋâ ko Sila gâsui Yesugât a kâmut ziŋâ Kembuŋâ galemzik upap sâm zâpane âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Âimŋâ Siria sot Kilikia hânân kamânŋâ kamânŋâ Yesugât kâmut sâm kâtikŋan kwatziŋgâwet. ");
INSERT INTO kpf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo sot Sila zet âimŋâ Derebe sot Listera kamânân takâwet. Oi Listera kamânân Yesugât kâmurân a ŋâi ândeip, kutŋâ Timoteo. Mamŋâ Yuda ambân, Yesugât kâmurân gok. Ibâŋâ Grik a. ");
INSERT INTO kpf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Yesugât kâmut Listera sot Ikonioŋ kamânân ândiwe, zen Timoteogât nâŋgâne âlipŋâ oi Paulo dukuwe. ");
INSERT INTO kpf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Dukunetâ Pauloŋâ zâk sot ândibapkât dukuip. Oi hân zoren Yuda a ândiwe, zen katep zorat ibâŋâ Grik a zo nâŋgâwe. Pauloŋâ zeŋgât opŋâ Mosegât gurumin den lum kwabâ kwâkŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Oi Yesugât kâmut kamânŋâ kamânŋâ ândiwe, zen den Aposolo ziŋ sâm ekabân kulemguwe, zo lubigât dâzâŋgom âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Yatâ op tuunetâ Yesugât kâmut kamânŋâ kamânŋâ, zeŋgâren nep tuum âine nâŋgâm pâlâtâŋziŋ kâtigeip. Oi sirâm dâp a ambân Yesugât kâmurân târokwatziŋgâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Oi Asia hânân siŋgi âlip sâm âinâ sânetâ Tirik Kaapumŋâ pâkekoi Pirigia sot Galatia hân walâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Âimŋâ Misia hân ginŋan takâm Bitinia hânân âinâ sâne Yesugât Kaapumŋâ mân âibigât sâip. ");
INSERT INTO kpf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Oi Misia hân murukŋan âim Taroa kamânân takâwe. Kamân zo saru sâtŋan tâip. ");
INSERT INTO kpf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Zoren takâm ŋâtigân Pauloŋâ uman ŋâi itâ egip. Mâkedonia a ŋâi muyagem itâ sâm dukuip, “Zen Makedonia hânân gam tânnâŋgobi.” ");
INSERT INTO kpf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pauloŋâ uman zo egi itâ sâwen, “Anutu zâk Makedonia hânân âi den siŋgi âlip dâzâŋgonatkât sap.” Yatâ sâm âinam urâwen. (Taroa kamânân Luka, nâŋâ Paulo sot Sila sot Timoteo târokwatziŋgâwan.) ");
INSERT INTO kpf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Oi waŋgâyân zâim Taroa kamân birâm Samorake hân saru tânâmŋan takâwen. ");
INSERT INTO kpf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Haŋsâi waŋgâyân âimŋâ Neopoli kamânân takâm waŋgâyân gâbâ gem Pilipi kamânân âiwen. Kamân zo Makedonia hân zoren kamân patâ ŋâi. Roma a ziŋâ kamân mariŋâ op ândiwe. Kamân zoren sirâm nâmbutŋâ ândiwen. ");
INSERT INTO kpf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ândeindâ Yuda a zeŋgât kendon oi kamân âkŋan too ŋâi zeip. Zoren itâ sâm geiwen, “Ziren Yuda a ziŋâ ninâu sâme, zorat kabâ ŋâi ziap mo buŋâ? Gei iknâ.” Yatâ sâm geimŋâ ambân mindum tatne muyageziŋgâm ge tapŋâ den siŋgi âlip dâzâŋgowen. ");
INSERT INTO kpf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Zeŋgât osetziŋan ambân ŋâiŋâ Anutu mâpâsem ândeip, kutŋâ Lidia. Ambân zo Tiatira kamânân gokŋâ. Zâkŋâ sâŋgum neuleŋoot pâi kwâlâmarâwe. Ambân zo Kembuŋâ okŋaŋgi umŋâ pâroŋsâi Paulogât den nâŋgâm kwâtâteip. ");
INSERT INTO kpf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Oi zikŋâ sot a ambârâpŋâ too saŋgonziŋgindâ itâ sâm dâtnâŋgoip, “Zen nikne nâŋgâm pâlâtâŋnoot uangât nâgât mirin zâi tâtat mâme upi.” Yatâ sâm kâtigem diiniŋgi zâiwen. ");
INSERT INTO kpf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Narâk zoren ninâu sânam giarindâ kore ambân ŋâi muyageniŋgip. Ambân zo wâkeŋoot ândimŋâ a kwâkŋan ândim zâibi, zorat topŋâ nâŋgâm dâzâŋgoi mâirâpŋâ kât sikum ziŋgâmarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ambân zorâŋâ muyageniŋgâm nen sot Paulo moliniŋgâm den itâ sâip, “A zi ziŋâ Anutu u patâgât kore a ândim Kembugât mâtâp, zorat dâzâŋgom ândie.” ");
INSERT INTO kpf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Den zorik sirâmŋâ sirâmŋâ sâm zari Paulo den zo nâŋgâm âkonzigi âburem wâke itâ sâm dukuip, “Nâ Yesu Kristogât sâtkât dâgoga ambân umŋan gâbâ takâm âi.” Yatâ sâi takâm arip. ");
INSERT INTO kpf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Oi ambân zo patârâpŋâ zen kât sikum memarâwe, zorat mâtâp dooŋgoip, zo nâŋgâm Paulo sot Sila gâsuzikâwe. Oi diizikâm kamân sombemân Roma a sâtŋâ mâteziŋan zâparâwe. ");
INSERT INTO kpf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Zâpanŋâ Roma a sâtŋâ itâ sâm dâzâŋgowe, “Zet Yuda aŋâ neŋgât kamânân gam den sâitâ bâliŋâ uap. ");
INSERT INTO kpf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Zet mân orotŋâ upi sâm ândiabot. Roma a neŋgâren yatâ zo mân upmen, zo uabot.” ");
INSERT INTO kpf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Oi a kâmut patâ kirâwe, zen um kâlak nâŋgâzikâne a sâtŋâ ziŋâ sâne kâwali a ziŋâ hâmbâzik kwâkâm lapitzikâwe. ");
INSERT INTO kpf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Doŋbep lapitzikâm tâk namin zâpamŋâ galem a zâk hângi dooŋgum dâŋ galem otzikâbapkat dukuwe. ");
INSERT INTO kpf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Dukune tâk namâ tânâmŋan umŋâ ŋâin, zoren zâpam kinzikŋâ nagân saaziki ziwet. ");
INSERT INTO kpf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ŋâtik tânâmŋan Paulo sot Sila zet Anutu mâpâsem kep mem tarâwet. Yatâ oitâ a tâk namin tarâwe, zen kwamit nâŋgâm tarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Oi wâriŋ patâ mem namâ zo mem sânsân pâi mâtâp aksik pâroŋsâip. Oi tâk namin tarâwe, zeŋgât bitziŋan tâk olaiyaŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Oi tâk namâ galem a, zâk umanân gâbâ nâŋgâm zaat egi mâtâp pâroŋsâm kiri tâk namâ a âim naŋge sâm petŋan zemba sâmbum sâkŋâ tâmbetkubam oip. ");
INSERT INTO kpf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Yatâ upâ sâi Pauloŋâ den kambâŋ sâm sâip, “Sâkkâ mân tâmbetku. Nen aksik zi hâlâluyâk ten.” ");
INSERT INTO kpf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Sâi galem a zâkŋâ âsakŋaŋgât sâi pindâne namâ kâligen zâim sânâm sâmbui Saulo sot Sila kinzik topŋan ge zeip. ");
INSERT INTO kpf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Zemŋâ namâ umŋan gâbâ diizikâmŋâ mâsikâzikâm sâip, “Patâzatnâ, Nâ dap op Kembugât a upat?” ");
INSERT INTO kpf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Oi zet itâ sâm dukuwet, “Gâ Kembu Yesu Kristo nâŋgâm pâlâtâŋ kwap Kembugât siŋgi upan. A ambârâpkâ zen yâtik.” ");
INSERT INTO kpf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Yatâ sâm zâk sot a ambârâp Anutugât den dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ŋâtik zorenâk galem aŋâ diizikâm mârum kâmbamŋâ zâkone use oip, zo saŋgonzikâwe. Oi zikŋâ sot a ambârâpŋâ too saŋgonziŋgâwet. ");
INSERT INTO kpf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Oi zet mirâŋan diizikâm zâim nalem zikip. Oi zâk sot a ambârâp Anutugâren nâŋgâm pâlâtâŋ kwarâwe, zorat umziŋ âlip oip. ");
INSERT INTO kpf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Haŋsâi a sâtŋâ zen kâwali a sâŋgonzâŋgoi âim tâk namâ galem a itâ dukuwe, “A zagât zo olaŋzikâna arit.” ");
INSERT INTO kpf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Oi galem a zorâŋ nâŋgâm Paulo itâ sâm dukuip, “Nâ olaŋzika âibabotkât a sâtŋâ den pane gaap. Zorat zet gemŋâ âim um lumbeŋan ândibabot.” ");
INSERT INTO kpf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Sâi Pauloŋâ kâwali a itâ sâm dâzâŋgoip, “Net Roma a bonŋâ op ândiet. Den nebân mân nâpanŋâ laŋ a mâteziŋan kâmbamŋâ lapitnikâm tâk namin nâparâwe. Oi net tik âiratkât se? Zo yatâ buŋâ. Ziiŋâ a ambân mâteziŋan diinikâm âi nâpâne âirat.” ");
INSERT INTO kpf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Paulo zâk den yatâ sâi kâwali a ziŋâ âburem âi a sâtŋâ dâzâŋgone zen a zagât zo Roma a bonŋâ op ândiwet, zo nâŋgâm pârâkparâwe. ");
INSERT INTO kpf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Pârâkpam zekâren gamŋâ um lumbe den dâzâkom tâk namin gâbâ diizikâm gei kamânziŋ birâm âibabotkât dâzâkowe. ");
INSERT INTO kpf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Oi zet tâk namin gâbâ gem Lidiagât mirin zâim Yesugât kâmut ziŋgit Kembugâren kâtigem ândibigât dâzâŋgomŋâ âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo sot Sila zet Ampipoli sot Apolonia kamân walâm Tesalonike kamânân takâwet. Zoren Yuda zeŋgât mâpâmâpâse namâ ŋâi tâip. ");
INSERT INTO kpf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Oi Paulo zâk op ândeip, yatâ op Yuda zeŋgât kendonân mâpâmâpâse namin zâimŋâ zen sot den siŋgi âlip âraguwe. Nep mâme karâmbut yatâ op ândeip. Zâk Kembugât den ekabân den topŋâ dâzâŋgom itâ sâip. ");
INSERT INTO kpf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“Kristo zâk sâknam nâŋgâm mom zaatpapkât den Kembugât ekabân ziap. Oi Yesu kutŋâ dâzâŋgoman, zâk a bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ. Zâk Kristo.” ");
INSERT INTO kpf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yatâ sâm dâzâŋgoi zeŋgâren gâbâ nâmbutŋâ zen den zo nâŋgâne bon oi Paulo sot Sila zekâren târokwarâwe. Osetziŋan Grik a doŋbep ziŋâ Kembugât den siŋgi mârumŋan nâŋgâm Anutu mâpâsem ândiwe sot ambân zâizâiŋâ nâmbutŋâ zen târokwatziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","A ambân doŋbepŋâ utnetâ Yuda a zen nâŋgâm um kâlak nâŋgâziŋgâm zen den kwamit patâ sâm Yasoŋgât mirin Paulo sot Sila tarâweyân âi minduwe. Mindumŋâ a zagât gâsuzikâm mindumindu patin zâpanam sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Paulo sot Sila mân muyagezikâmŋâ Yasoŋ sot Yesugât kâmut zeŋgâren gâbâ a nâmbutŋâ gâsuziŋgâm a sâtŋâ zeŋgâren diiziŋgâm âiwe. Âimŋâ itâ sâwe, “A zen hânŋâ hânŋâ ândim den bâliŋ dâzâŋgom a um gulip kwatziŋgâme, a zorâŋâ neŋgâren ge. ");
INSERT INTO kpf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Gane Yasoŋâ sâi mirâŋan tâtat mâme urâwe. Zen Roma a kutâgât den kom a kutâ uŋakŋâ muyagiap, kutŋâ Yesu sâme.” ");
INSERT INTO kpf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Yuda a ziŋâ den yatâ sâne kamân a sot a sâtŋâ zen Yasoŋ sot bukurâpŋâ kâsa otziŋgâm den kwamit patâ sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","A sâtŋâ zen Yasoŋ sot bukurâpŋâ tâk namin mân zâibigât sâm sâŋgân mine zâmbane âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ŋâtiksâi Yesugât kâmut zen keŋgât op Paulo sot Sila sâŋgonzâkone Berea kamânân âiwet. Zoren takâm Yuda zeŋgât mâpâmâpâse namin zâi den siŋgi âlip dâzâŋgowet. ");
INSERT INTO kpf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Kamân zoren Yuda a zen a âlipŋâ. Zen Tesalonike a yatâ buŋâ, gât ko den siŋgi âlipŋâ nâŋgâm âkŋâliwe. Dinzikŋâ zo bonŋâ mo sarâ sâm sirâm dâp Kembugât den ekabân sâlâpkum nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Oi zeŋgâren gâbâ doŋbepŋâ Yesugât kâmut urâwe. Oi Grik a ambân patâ nâmbutŋâ, ziŋâ zeŋgâren târokwârâwe. ");
INSERT INTO kpf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pauloŋâ Berea kamânân Anutugât den sâi siŋgi Tesalonike kamânân ari Yuda a ziŋ nâŋgâwe. Nâŋgâm Berea kamânân âim kâsa otzikâbigât a ambân dâzâŋgowe. ");
INSERT INTO kpf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Yatâ utne Yesugât kâmut zen zo nâŋgâm zorenâk Paulo sot a nâmbutŋâ sâŋgonzâŋgone saru sâtŋan geiwe. Ka Sila sot Timoteo zet kamân zoren ândiwet. ");
INSERT INTO kpf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Oi a zen Paulo diim âi Ateŋ kamânân pane itâ sâm dâzâŋgoip, “Zen âi sâne Sila sot Timoteo zet kek gâbabot.” Sâi a zen âburem âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo zâk Ateŋ kamânân Sila sot Timoteo, zekât mambât ândim eŋ lopio doŋbep tatne ziŋgit umŋâ kârâp oip. ");
INSERT INTO kpf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Oi Yuda a zeŋgât mâpâmâpâse namin zâim Yuda a sot Grik a nâmbutŋâ zen Anutu mâpâsemarâwe, zen sot âraguwe. Oi sirâmŋâ sirâmŋâ kamân sombemân a muyageziŋgâm siŋgi âlip dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kamân zoren a nâŋgânâŋgâziŋ patâ, Epikue a kâmut sot Stoike a kâmut, zeŋgâren gâbâ a nâmbutŋâ zen Paulo sot den âraguwe. Oi nâmbutŋandâ Paulogât itâ sâwe, “A zi nâŋgânâŋgâŋâ buŋ den laŋ sap. Zâk wan wan den sâm taap?” Nâmbutŋandâ itâ sâwe, “Zâk lopio uŋakŋaŋgât den sap.” Paulo zâk Yesugât den sot mom zaatzaatŋaŋgât den sâi zen yatâ sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Yatâ sâm mindumindu sombemân diim zâimŋâ sâwe, “Den uŋakŋâ sat, zo nâŋgânatkât sen. Den mârâtŋâ, zorat topŋâ sapsuna nâŋgânâ.” ");
INSERT INTO kpf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ateŋ kamân mâirâp sot kamân ŋâin gokŋâ zen sot ândiwe, zen den uŋakŋâ nâŋgânam den âragum ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo zâk Areo den sâsâŋ sombemân kin a itâ sâm dâzâŋgoip, “Ateŋ mâirâp, nâ topziŋ ek nâŋgan. Zen lopio doŋbep sobim bimbi kwatziŋgâme. ");
INSERT INTO kpf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nâ kamânziŋan âim gam lopioziŋâ ekŋâ lopiogât nalem pâpanŋan den itâ zei sâlâpkuwan, ‘Nalem pâpanŋâ zi bem lopio ŋâigât siŋgi, kutŋâ mân nâŋgen.’ Mân nâŋgâm mâpâsime, zorat topŋâ dâzâŋgobâ. ");
INSERT INTO kpf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Anutu zâk hân muyagem kwâkŋan kut ŋâi ŋâi pâip. Zâk hân sot sumbem zorat mariŋâ. Zo namâ a betŋâ tuutuuŋ, zoren tâtat mâme mân opmap. ");
INSERT INTO kpf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","A zeŋgât kut ŋâi ŋâi tuume, kut zo mân kârumap. Zâkŋak a ândiândiniŋâ sot Kaapum sot kut ŋâi ŋâi zo niŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","A hânân ândien zo sâi a kânokâren gâbâ muyagem laŋ kârâm hânân a kâmutŋâ kâmutŋâ muyagem laŋ kârâm âiwen. Oi muyagem âinat, narâk sot daŋgon zo zâkŋak sâm niŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nen umniŋandâ Anutu kârum âim muyaginatkât yatâ oip. Zâk kârebân buŋâ, gootniŋan a hutnâŋgon ândiap. Den ŋâi itâ ziap, ");
INSERT INTO kpf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Nen zâkkât ândiândiŋ umŋan ândim kut ŋâi ŋâi upmen.’ Zeŋgâren gâbâ a nâmbutŋandâ zitâ sâwe, ‘Nen zâkkâren gâbâ âsagiwen.’ ");
INSERT INTO kpf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Anutugât nâŋgindâ lopio yatâ mân upap. Lopio kât âlipŋâ a bitziŋandâ sobime. Oi nen Anutugâren gâbâ muyagiwenŋâ nâŋgindâ Anutu zâk lopio yatâ mân upap. ");
INSERT INTO kpf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mârumŋan kwakmak ândiwen. Anutuŋâ niŋgitŋâ birâm ândeip, zorat narâk âkip. Irak ko a aksik umniŋ melâŋnatkât sap. ");
INSERT INTO kpf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Zâk narâk pâip, zo ziap. Zoren hânŋâ hânŋâ topniŋâ sâm muyagemŋâ hâuŋâ niŋgâbap. Oi a ŋâi, zâk nep zo tuubapkât gâsum kwânâŋgip. Oi hân a aksik zâkkât nâŋgindâ bon upapkât mumuŋan gâbâ mâŋgei zaat ândiap.” ");
INSERT INTO kpf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Paulo zâk mumuŋan gâbâ zaatzaat, zorat den sâi nâmbutŋâ ziŋ mem gei kwâkwat den sâwe. Oi nâmbutŋâ ziŋâ sâwe, “Den zo narâk ŋâin ko sâna nâŋgânat.” ");
INSERT INTO kpf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Yatâ utnetâ Pauloŋâ zâmbam arip. ");
INSERT INTO kpf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","A nâmbutŋandâ Paulogâren pâlâtâŋ op Yesugât siŋgi urâwe. Oi zeŋgât osetziŋan kamân zorat a sâtŋâ zeŋgât kâmurân gok kutŋâ Dionisio. Oi ambân ŋâi kutŋâ Damari sot nâmbutŋâ ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pauloŋâ Ateŋ kamân birâm Korinti kamânân arip. ");
INSERT INTO kpf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Zoren Yuda a ŋâi muyageip, kutŋâ Akwila. Zâk Ponto hânân gokŋâ. Oi ambinŋâ Pirisila zâk sot Italia hânân ândeitâ Roma a kutâ Kalaudio, zâkŋâ Roma kamânân Yuda a ambân tarâwe, zo moliziŋgip. Oi zet zo birâm Korinti kamânân âiwet. ");
INSERT INTO kpf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulo zâk zekât mirin zâri tâtat mâme urâwe. Wangât, zet nep ârândâŋ tuumarâwet, zorat zekâren zari tarâwe. Zeŋgât nep ko hâmbâ silep tuumarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Yuda zeŋgât kendon dâp Paulo zâk mâpâmâpâse namin zâim Yuda a sot Grik a siŋgi âlip dâzâŋgoi nâmbutŋâ zen Yesugât kâmut urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Oi Sila sot Timoteo zet Makedonia hânân gâbâ gâitâ Paulo siŋgi âlip nep zorarâk nâŋgâm ândeip. Zâkŋâ Yuda a itâ sâm kâtigem dâzâŋgoip, “A bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, Kristo, zâk Yesu.” ");
INSERT INTO kpf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Yatâ sâi Yuda a zen diŋâ birâm kâsa okŋaŋgâne zâkŋâ hâmbâŋan gwapgwap koi gei itâ sâm dâzâŋgoip, “Tâmbetagobi, tosa zo nâgât buŋâ. Ziiŋâ upap. Zorat nâ kândâtzâŋgom hân ŋâin gok zeŋgâren âibat.” ");
INSERT INTO kpf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Yatâ sâm a ŋâi kutŋâ Titeo Yusito, zâk Grik aŋâ Yuda a zen sot ândim Anutu hurat kwâkŋaŋgâm ândeip, zâkkât mirâ zo Yuda zeŋgât mâpâmâpâse namâ ginŋan kirip. Pauloŋâ zâkkât mirin âi tâtat mâme oip. ");
INSERT INTO kpf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Mâpâmâpâse galem a kutŋâ Kirispo, zâk sot a ambârâpŋâ zen aksik siŋgi âlip nâŋgâm Kembugâren nâŋgâm pâlâtâŋ kwâkŋaŋgâwe. Oi Korinti a zeŋgâren gâbâ doŋbepŋâ siŋgi âlip nâŋgâm Yesugât kâmut utne too saŋgonziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pauloŋâ ŋâtik ŋâin uman egi Kembuŋâ itâ sâm dukuip, “Gâ mân keŋgât otnan. Siŋgi âlip sâm mân birâban. Sâmŋik ândiban. ");
INSERT INTO kpf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nâ galem otgiga aŋâ mân gobi. Kamân ziren nâgât siŋgi a doŋbep ândie.” ");
INSERT INTO kpf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Yatâ sâm dukui Pauloŋâ kamân zorat a Anutugât den dâzâŋgom ândei kâin kiin nâmburân karâmbut âkip. ");
INSERT INTO kpf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Oi Galioŋ zâk Grik hânân a sâtŋâ patâ op ândei Yuda a zen um kânok opŋâ Paulo kâsa okŋaŋgâm gâsum diim a sâtŋaŋgâren âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Diim âim Paulogât itâ sâm dukuwe, “A zi zâk Anutugât gurumin den komŋâ mâtâp uŋakŋan âim Anutu mâpâsibigât sâmap.” ");
INSERT INTO kpf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Yatâ sâne Pauloŋâ den hâuŋâ sâbam oi Galioŋâ Yuda a itâ sâm dâzâŋgoip, “O Yuda a, a zi bâliŋ op tosa patâ muyagei sâi dinziŋâ nâŋgâbam. ");
INSERT INTO kpf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Zen sâkurâpziŋâ zeŋgât den kâtik sot den nâmbutŋâ âragum diim ge, zorat nâ mân kubikpat. Ziiŋak kubikpi. Zo nâgât nep buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yatâ sâm moliziŋgi gem âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Oi a zen aksik patâ mâpâmâpâse galem a kutŋâ Sostene gâsum lumŋâ a sâtŋaŋgât mâteŋan kom mem ŋâi ŋâi utne ziŋgitŋâ mân nâŋgânâŋgâ oip. ");
INSERT INTO kpf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo zâk Korinti kamânân ândim zâim Yesugât kâmut kândâtziŋ kelik Siria hânân âibam arip. Pirisila sot Akwila zet zâk sot ârândâŋ âiwe. Kenkereai kamânân takâm kâukŋâ mânâŋgârip. Zorat mârumŋan Anutu mâteŋan den sâm kâtigem kâukŋâ mân mânâgât ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Zobâ waŋgâyân zâim Epeso kamânân takâm kâsâpagowe. Oi Pauloŋâ mâpâmâpâse namin zâim Yuda a zen sot den siŋgi âlip âraguwe. ");
INSERT INTO kpf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Oi zen sot ândibapkât sâne itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","“Anutuŋâ sâi nâ du zeŋgâren âburem gâbat.” Yatâ sâm kelikmelik otziŋgâm waŋgâyân zâim Epeso kamân birâm arip. ");
INSERT INTO kpf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Âimŋâ Kaisarea kamânân takip. Zoren takâm Yesugât kâmut kândâtziŋ kelik den dâzâŋgom Antiokia kamânân âburem arip. ");
INSERT INTO kpf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Paulo zâk Antiokia kamânân mâik ŋâi ândim zâmbamŋâ siŋgi âlip nebân du arip. Oi Galata sot Pirigia hânân kamânŋâ kamânŋâ Yesugât kâmut ândiwe, zo sâm kâtikŋan kwatziŋgâm arip. ");
INSERT INTO kpf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Oi Epeso kamânân Yuda a ŋâi gâip, kutŋâ Apolo. Zâk Alesandiria kamânân gok. A zo nâŋgânâŋgâŋâ patâ. Zâk Kembugât den ekabân sâlâpkum nâŋgâm naŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","A zo Kembugât topŋâ zo dukune nâŋgâm naŋgip. Too saŋgon nep ko Yohanegârâk nâŋgipŋâ Yesugât siŋgi imbaŋâŋoot dâzâŋgom ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Zâk Yuda a zeŋgât mâpâmâpâse namin zâim siŋgi den keŋgât buŋ, lâu bâbâlaŋ sâm dâzâŋgoip. Zoren siŋgi âlip sâi Pirisila sot Akwila zet nâŋgâm buku okŋaŋgâm diim âi Anutugât den nâmbutŋâ dukum naŋgâwet. ");
INSERT INTO kpf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Oi Apolo zâk Grik hânân âibâ sâi Yesugât kâmut zen ekap ŋâi kulemgum Yesugât kâmut Grik hânân ândiwe, zeŋgât pindâne mem arip. Ekap zoren den itâ zeip, “Zen a zi buku okŋaŋgâbi.” Den yatâ kulemgum pindâne arip. Âimŋâ Korinti kamânân takâm Anutuŋâ tângoi Yesugât kâmut itâ betziŋan meip. ");
INSERT INTO kpf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kembugât den ekabân gâbâ Yuda a den dâzâŋgom sâip, “A bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, Kristo, zâk Yesu.” Zâkŋâ minduminduyân den yatâ sâm Yuda zeŋgât den zo mem ge kwatziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo zâk Korinti kamânân ândei Pauloŋâ hân mâtâp âim Epeso kamânân takâm Yohanegât arâp nâmbut muyageziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Oi mâsikâziŋgâm sâip, “Zen Kembugât den siŋgi âlip nâŋgâm, nâŋgâm pâlâtâŋ kwapŋâ Tirik Kaapum sot urâwe mo buŋâ?” Sâi ziŋâ sâwe, “Buŋâ. Tirik Kaapum ândiap, zorat siŋgi mân nâŋgâwen.” ");
INSERT INTO kpf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Sâne itâ sâm mâsikâziŋgip, “Zen ŋâigât korân too saŋgonziŋgâwe?” Sâi itâ sâm dukuwe, “Nen Yohanegât too saŋgonniŋgâwe.” ");
INSERT INTO kpf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Sâne Pauloŋâ itâ sâm dâzâŋgoip, “Yohane zâk a umziŋ melâŋbigât too saŋgonziŋgâm itâ sâm dâzâŋgoip, ‘A ŋâi bet gâbap, zen zâk nâŋgâm pâlâtâŋ kwâkŋaŋgâbi.’ Den zo Yesugât op sâip.” ");
INSERT INTO kpf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","A zen den so nâŋgâne Kembu Yesugât korân too saŋgonziŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Too saŋgonziŋgâne Pauloŋâ bikŋâ kâukziŋan pâi Tirik Kaapum zeŋgâren gei Kembugât den gându uŋakŋan sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","A yatâ urâwe, zen kiin zagât yatâŋâ urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo zâk Yuda a zeŋgât mâpâmâpâse namin âsâbâŋ zâimŋâ keŋgât buŋ siŋgi âlip dâzâŋgom ândei kâin karâmbut âkip. Anutugât um topŋan ândiândiŋaŋgât den sâm bâbâlaŋ kwap dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Oi a nâmbutŋâ zen um kâtik opŋâ Yesugât den kândâtkom a ambân mâteziŋan den bâliŋâ sânetâ Pauloŋâ birâziŋgip. Oi Yesugât kâmut, zenâk diiziŋgâm sirâmŋâ sirâmŋâ a ŋâi kutŋâ Tirano, zâkkât mirin minduziŋgâm zen sot âraguwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Kendon patâ zagât umŋan zo yatâ op ândei Yuda a sot Grik a Asia hânân ândiwe, zen aksik Kembugât topŋâ nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Oi Anutuŋâ Paulo mam okŋaŋgi sen mârât kulem ŋâi ŋâi tuugip. ");
INSERT INTO kpf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Zorat a zen Paulogât hâmbâ mot mem ândeip, zo mem mâsekziŋoot zeŋgâren mem âine gâsune sâkziŋ âlip urâwe. Yatâ utne wâkeŋâ a umziŋan gâbâ takâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Oi Yuda a nâmbutŋâ sâgân sâmbu opŋâ hânŋâ hânŋâ âim gam ândim zâizâiŋ op Kembu Yesugât kot zo sâm wâke moliziŋgânat sâm wâkeziŋoot itâ sâm dâzâŋgowe, “Yesu kutsiŋgiŋâ Pauloŋâ sâmap, zâkkât korân sa âiban.” ");
INSERT INTO kpf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yuda zeŋgât tirik namâ galem a patâ ŋâi kutŋâ Sikewa, zâkkât narâpŋâ nâmburân zagât, zen Paulo ekŋâ yatâ urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Yatâ op sâne wâkeŋâ den itâ sâm dâzâŋgoip, “Yesu sot Paulo zo nâŋgâzikan. Zen ko waniŋ gokŋâ?” ");
INSERT INTO kpf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wâkeŋâ yatâ sâi a wâkeŋoot zo kâwali imbaŋâ mem zâŋgom mem kâbakgwâbakŋe otziŋgâm hâmbâziŋ mem giŋbololoŋ mei sâk bârak sot gilâmziŋoot mirin gâbâ pâtan âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Zorat den siŋgi Epeso kamânân Yuda a sot Grik a zen zo nâŋgâm keŋgât urâwe. Oi Kembu Yesugât kutŋâ sâm âlip kwâkŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Oi Yesugât kâmut, zeŋgâren gâbâ doŋbep patâŋâ gam mârumŋan gâbâ kware suŋa op gâwe, zorat den siŋgi sâm kâkŋan parâwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Kware suŋagât ekap mem ândiwe, zo mem a mâteziŋan kârâp une seip. Oi ekap zorat sâŋgânŋâ sâlâpkum mâpotne kât ekap 4 tausen yatâ oip. ");
INSERT INTO kpf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","A ziŋâ yatâ utnetâ Kembugât denŋâ imbaŋâ mem kâtigemŋâ laŋ kârâm arip. ");
INSERT INTO kpf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Paulo zâk nep zo tuum naŋgi Kaapumŋâ okŋaŋgi Makedonia sot Grik hân âi walâzikâm Yerusalem kamânân âibatkât sâip. Oi itâ sâip, “Nâ Yerusalem kamânân âim âburem Roma kamânân âibat.” ");
INSERT INTO kpf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Oi âibam berân mâme nep a zagât Timoteo sot Erasto sâŋgonzâkoi Makedonia hânân kândom op âiwet. Zâk zikŋik zoren mâik ŋâi ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Narâk zoren Epeso kamânân um kâtik a zen siŋgi âlipkât den kwamit patâ urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Zoren kâtŋâ lopio tuutuuŋâ a ŋâi ândeip, kutŋâ Demeterio. A zorâŋâ Atemis lopio namâ dâpŋâ mâik mâik kâtŋâ tuugi a ziŋâ sâŋgân mine zâk sot nep arâpŋâ kât doŋbep muyagiwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Oi Demeterioŋâ nep a gakârâpŋâ minduziŋgâm itâ sâm dâzâŋgoip, “A, zen nâŋge. Nepniŋâ zorâŋâ kât sikum muyageniŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Oi a ŋâi ga ândiap, kutŋâ Paulo. Zen zâkkât topŋâ nâŋge. Zâkŋâ Epeso kamânân gok sot Asia hânân kamân dâp a doŋbep um gulip kwatziŋgâm itâ sâm dâzâŋgomap, ‘A betŋâ lopio tuutuuŋâ, zo bon buŋâ.’ ");
INSERT INTO kpf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Zâk yatâ oi a ambân zen nepniŋaŋgât nâŋgâne gigiŋâ upap. Bemniŋâ Atemis zâkkât kutŋâ gigiŋ oi namâŋâ zi gâugâu gâsubap. Oi Asia hânân sot hân nâmbutŋâ a aksik patâ zen zâk mâpâsime, zo dap op buŋ upap?” ");
INSERT INTO kpf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demeterioŋâ den yatâ sâm dâzâŋgoi nâŋgâm umziŋan kuk op den yu kambâŋ sâm itâ sâwe, “Atemis Epeso kamânân gok, zâk kutŋâ patâ.” ");
INSERT INTO kpf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Yatâ sâm den kwamit patâ utne kamân mâirâp zen aksik den kwamit patâ opŋâ mindumindu sombemân âiwe. Oi Makedonia a zagât Paulo sot âiwet, kutzikŋâ Gaio sot Aristako, zet gâsuzikâm diizikâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Oi Pauloŋâ siŋgi nâŋgâm zaat sombemân âibam oi Yesugât kâmut ziŋâ aŋgân kârâŋaŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Oi kamân zorat a sâtŋâ nâmbutŋâ Paulo buku okŋaŋgâm ândiwe, zen Paulo sombemân mân âibapkât den pane arip. ");
INSERT INTO kpf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mindumindu kabâŋan a ambân nâmbutŋandâ den ŋâi sâne nâmbutŋaŋgoot ŋâi sâne den gulip oi doŋbep ziŋâ den topŋâ mân nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","A zen yatâ op kine Yuda a zen, zeŋgât bukuziŋâ kutŋâ Alesande mem aline a osetziŋan kin den dâzâŋgobam op den mân sâbigât bikŋandâ dâp tuugip. ");
INSERT INTO kpf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Yatâ oi a zen a ândopŋâ, Yuda gokŋâ ek nâŋgâmŋâ zen aksik patâ den yu kambâŋâ itâ sâwe, “Atemis Epeso kamânân gok, zâk kutŋâ patâ.” Zen narâk kârep den zo sâm kirâwe. ");
INSERT INTO kpf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Yatâ utne den galem a gamŋâ sâi hiriŋsâne itâ sâm dâzâŋgoip, “Epeso mâirâpŋâ, kamân zirat Atemis patâniŋaŋgât namâ sot lopio sumbemân gâbâ gem geip, zorat galem a ândien. Zo a ambân zen aksik nâŋge. ");
INSERT INTO kpf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Gât ko zen umziŋ diim gei kut ŋâi ŋâi laŋ mân upi. ");
INSERT INTO kpf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","A sâkziŋanâk se, zen lopioniŋaŋgât namin âim kut ŋâi ŋâi mân tâmbetkuwe. Zen Atemis mân sâm bâliŋ kwâkŋaŋge. ");
INSERT INTO kpf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Oi Demeterio sot nep a gakâŋâ, zen a ŋâigât tosa muyagibi, oi ko den sapsusuŋ narâkŋan a sâtŋâ zeŋgâren sâne kubikpi. ");
INSERT INTO kpf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Zeŋgâren den ŋâi ziap, oi ko a sâtŋâ zeŋgât minduminduyân mem âibi. ");
INSERT INTO kpf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Zen itârâŋ den laŋ sânetâ kâmbam muyagibam uap. Zorat a kutâŋâ neŋgât nâŋgi mân dâp oi kubikniŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Den galem a zorâŋâ den yatâ sâm dâzâŋgoi kâsâpagom âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Den kwamit patâ buŋ oi Pauloŋâ Yesugât kâmut diiziŋgâm den dâzâŋgomŋâ kândâtziŋ kelikŋâ Makedonia hânân arip. ");
INSERT INTO kpf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Hân zoren âim Yesugât kâmut kâtigibigât den doŋbep dâzâŋgomŋâ walâziŋgâm Grik hânân arip. ");
INSERT INTO kpf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Zoren kâin karâmbut ândim saruyân geim waŋgâyân zâim Siria hânân âibâ sâi Yuda a ziŋâ kunam sipkune waŋgâ birâm Makedonia hân mâtâp arip. ");
INSERT INTO kpf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Oi a itâ zorâŋ zâk sot âiwe. Berea kamânân gok Sopate, zâk Piroregât nanŋâ. Tesalonike kamânân gok Aristako sot Sekundo sot Derebe kamânân gok Gaio sot Timoteo sot Asia hânân gok Tikiko sot Toropimo. ");
INSERT INTO kpf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","A yatâ zorâŋ kândom âi Taroa kamânân mambâtniŋgâm ândiwe. (Pilipi kamânân nâ Luka Paulo kândiaŋgâm betniŋan sâne âiwen.) ");
INSERT INTO kpf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Oi Yuda zeŋgât nalem niniŋaŋgât kendon patâ kutŋâ Pasowa, zo âki Pilipi kamânân gâbâ waŋgâyân zâim âim tâindâ sirâm bâtnâmbut oi Taroa kamânân takâwen. Zoren sirâm nâmburân zagât ândiwen. ");
INSERT INTO kpf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sirâm nâmburân kânokgât kendonân nen nalem ninam minduwen. Paulo zâk haŋsâi âibat sâm den dâzâŋgom kiri ma ŋâtik tânâmŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mirâ umŋâ tarâwen, zoren kârâp âsakŋâ doŋbep seip. ");
INSERT INTO kpf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Oi katep ŋâi kutŋâ Eutiko, zâk Pauloŋâ den sâi nâŋgâm tap mâtâp mâigân gâbâ uman nelâmkoi zem hânân gei koi zei mem zaatne moip. Oi mirâ zo kârep patâ. Um karâmbut kwâkŋan topŋan. Zoren kwâkŋan gâbâ gei koip. ");
INSERT INTO kpf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pauloŋâ geimŋâ katep zo kwârakum lumŋâ itâ sâm dâzâŋgoip, “Âigirâp mân utnek. Zâk umŋâ mâŋgim ziap. Mân muap.” ");
INSERT INTO kpf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Yatâ sâmŋâ mirâ umŋan zâim nalem kâsâpkum nemŋâ zen sot âragum tatne haŋsâip. Haŋsâi zâmbam arip. ");
INSERT INTO kpf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A zen katep zo diim mirâziŋan zâim umziŋ âlip oip. ");
INSERT INTO kpf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nâmbutŋâ nen Pauloŋâ sâi waŋgâyân zâim Aso kamânân kândom âiwen. Paulo zâk hân mâtâp âim Aso kamânân waŋgâyân zâibam oip. ");
INSERT INTO kpf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Oi ko Aso kamânân âim muyageniŋgâm waŋgâyân zâi niŋgiri ârândâŋ âiwen. Âimŋâ Mitilene kamânân takâwen. ");
INSERT INTO kpf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Zobâ sirâm ŋâin âim Kio hân walâwen. Zobâ sirâm ŋâin Samo kamânân takâwen. Zobâ sirâm ŋâin Milete kamânân âi takâwen. ");
INSERT INTO kpf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo zâk Yerusalem kamânân kek âibat sâm Epeso kamânân mân âim Milete kamânân arip. Asia hânân ândei Yuda zeŋgât kendon Pentekos, zorat narâk walâbapkât op Yerusalem kamânân kek âibatkât sâip. ");
INSERT INTO kpf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Milete kamânân gamŋâ Pauloŋâ a sâŋgonzâŋgoi Epeso kamânân âim Yesugât kâmut zeŋgât galem a diiziŋgâne gawe. ");
INSERT INTO kpf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Gane Pauloŋâ itâ sâm dâzâŋgoip, “Nâ Asia hânân gam zeŋgâren nep tuum gâwan. Zo topŋan gâbâ nâŋgâm naŋge. ");
INSERT INTO kpf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nâ a ginŋandâ Kembugât kore op ândiwan. Oi Yuda zen kâsa otninetâ sâknam kwâkŋan ândim isem ândiwan. ");
INSERT INTO kpf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Oi den dâzâŋgobatkât ŋâi mân ziap. Zen âlip upigât den siŋgi âlipŋâ sombemân sot mirin aksik dâzâŋgowan. ");
INSERT INTO kpf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Oi Yuda a sot Grik a, zen umziŋ melâŋâ Anutu mâteŋan Kembuniŋâ Yesu Kristo nâŋgâm pâlâtâŋ kwâkŋaŋgâbigât dâzâŋgowan. ");
INSERT INTO kpf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Irak ko Kaapumŋâ umnan saam diinigi Yerusalem kamânân âibâman. Zoren aria kut ŋâi ŋâi otnibi, zo mân nâŋgan. ");
INSERT INTO kpf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ka Tirik Kaapumŋâ itâ tirâpnogap. Zoren aria tâk namin nâbane tap sâknam nâŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nâ ândiândinaŋgât nâŋgâm keŋgât mân uan. Nâ ândiândinâ mân aŋgân kârâbat. Kembu Yesuŋâ nep diŋ sâm nigip, zorik tuum âibatkât nâŋgan. Anutu um lumbeŋaŋgât den siŋgi sa laŋ kârâbapkât nep diŋ sâm nigip. ");
INSERT INTO kpf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Oi ŋâi sa nâŋgânek. Nâ Anutu um topŋan ândiândigât den siŋgi dâzâŋgom osetziŋan ândia nikme, zo dum zagâtŋâ sâŋgânâ mân nikpi. ");
INSERT INTO kpf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Itârâŋ dâzâŋgua nâŋgânek. Zeŋgâren gâbâ ŋâi tâmbetagobap, zorat tosa nâgâren mân zimbap. ");
INSERT INTO kpf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Wangât, nâ Anutugât den siŋgi âlip zo aksik dâzâŋgowan. Ŋâi mân birâwan, zorat tosa nâgâren mân ziap. ");
INSERT INTO kpf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Zen ziiŋak galem oraŋgâm kâmut gakâziŋâ galemziŋ upi. Tirik Kaapumŋâ zo zeŋgât galem a sâm zâmbarip. Kembugât kâmut zo Yesu zâkŋâ gilâmŋandâ kwâlâziŋgip, zen galem otziŋgâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nâ itâ nâŋgan. Nâ birâziŋgâm aria a nâmbutŋâ zen wâu ulin yatâ tâmbetzâŋgonam gabi. ");
INSERT INTO kpf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Oi osetziŋan gâbâ a nâmbutŋâ muyagemŋâ zen a nâmbutŋâ zeŋgât a upigât den bâliŋ sâm um gulip kwatziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Zorat zen galem oraŋgâm ândibi. Kendon patâ karâmbut zorat umŋan sirâm ŋâtik zo girem den dâzâŋgom isem gâwan. Zen zorat nâŋgâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Oi nâ Anutugâren zâmbansan. Zen Anutugât lumbeŋâ den zo nâŋgâm ândibi. Yatâ utne Anutuŋâ tânzâŋgoi bonŋâ muyagibi. Yatâ opŋâ a ambân mem kubikziŋgip, zen sot opŋâ bonŋâ muyagibi. ");
INSERT INTO kpf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nâ a ŋâigâren kât sikum mot mân mimbatkât sâwan. ");
INSERT INTO kpf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ninâ sot arâpnâ neŋgât bitnandâ tuuga muyagei mem nem ândiwen, zo âlip nâŋge. ");
INSERT INTO kpf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nâ mâtâpŋâ dâzâŋgom naŋgâwan. Zen nep kâtigem tuune kât mot muyagei a ambân kanpitâ zo ziŋgâbigât mân kwakpi. Mâtâp zo tirâpzâŋgowan. Oi yatik opŋâ zen Kembu Yesu den itâ sâip, zo nâŋgâm ândibi. Den zo itâ, ‘Kut ŋâi ŋâi mimiŋ, zo âlipŋâ. Ka kut ŋâi ŋâi ziŋgâziŋgâŋ, zorâŋ umâlep zâizâiŋ.’” ");
INSERT INTO kpf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo zâk den yatâ sâm dâzâŋgom simin liim zen sot ninâu sâip. Ninâu sâi isemŋâ lum kândât kelikŋâ pane arip. ");
INSERT INTO kpf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Oi itâ sâm dâzâŋgoip, “Zen dum zagâtŋâ sâŋgânâ mân nikpi.” Yatâ sâi umziŋ bâliŋ oi zo yatâ lum kândâtŋâ kelikŋâ diim waŋgâyân âi parâwe. ");
INSERT INTO kpf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Oi nen zâmbamŋâ tâŋtâŋ âimŋâ hân ŋâi kutŋâ Koo, zoren takâwen. Mirâ haŋsâi Rodo hânân âim zobâ Patara kamânân âi takâwen. ");
INSERT INTO kpf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kamân zoren waŋgâ ŋâi Poinike hânân âibam op tâi zoren zâiwen. ");
INSERT INTO kpf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Zobâ âimŋâ Kipiro hân egindâ yaŋgâgen tâi ek walâm âiwen. Âi Siria hânân âim Tiro kamânân takâwen. Zoren waŋgâŋâ sikum pam tâip. ");
INSERT INTO kpf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Pam tâi nen kamânân zâi Yesugât kâmut muyageziŋgâm sirâm nâmburân zagât tarâwen. Oi Tirik Kaapumŋâ otziŋgi Pauloŋâ Yerusalem kamânân mân âibapkât sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Zoren ândeindâ waŋgâ âiâiŋ narâk oi a ambân sot katep zen aksik diiniŋgâm kamân âkŋan sagân geiwen. Geimŋâ simin liim ninâu sâwen. ");
INSERT INTO kpf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ninâu sâmŋâ âbânaŋgâm zen kamânân zâine nen waŋgâyân zâiwen. ");
INSERT INTO kpf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Oi Tiro kamânân gâbâ Tolemaio kamânân takindâ waŋgâyân âiâiŋâ zo âkip. Yesugât kâmut ŋâtik kânok zen sot ziwen. ");
INSERT INTO kpf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Haŋsâi kamân zo birâm Kaisarea kamânân âi takâm Pilipogât mirin zâiwen. Pilipo zâk mârum a nâmburân zagât nalem kâsâpkum ziŋgâmarâwe, zeŋgât kâmurân gok. Zâkkât mirin zâiwen. ");
INSERT INTO kpf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Zâkkât bârarâp kimembut sigan ândiwe. Zen Propete yatâ op Kembugât den sâmarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Oi sirâm nâmbutŋâ zoren tâindâ Yuda hânân gâbâ Propete ŋâi kutŋâ Agabo, zâk neŋgâren gâip. ");
INSERT INTO kpf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Gamŋâ Paulogât inzutŋâ memŋâ zikŋâ kiŋ bik saamŋâ itâ sâip, “Tirik Kaapumŋâ itâ sap, ‘Inzut zi mariŋâ zâk Yerusalem kamânân zari Yuda a ziŋâ itâ okŋaŋgâm kamân ŋâin gok zeŋgât bitziŋan pambi.’” ");
INSERT INTO kpf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Den yatâ sâi nen sot kamân mâirâp nen aksik Paulo Yerusalem kamânân mân zâibapkât sâwen. ");
INSERT INTO kpf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Dukuindâ itâ sâip, “Zen wangât isem umbâlâ otnige? Nâ Kembu Yesugât op mumbatkât mân keŋgât uan.” ");
INSERT INTO kpf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Den dukuindâ mân nâŋgâm kâtigei birâm itâ sâwen, “Kembugât den kâtigibap.” ");
INSERT INTO kpf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Narâk zo âki Yerusalem kamânân zâinatkât kubikaŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Oi Kaisarea kamânân gâbâ Yesugât kâmut zeŋgâren a nâmbutŋâ ziŋâ diiniŋgâm Ŋasoŋ zâkkât mirin nâmbarâwe. Ŋasoŋ zâk mârumŋan Kembugât a oip. Zâk Kipiro gokŋâ. ");
INSERT INTO kpf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Oi zobâ âi Yerusalem kamânân takindâ Yesugât kâmut nâmbutŋâ ziŋâ sâtâre op buku otniŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Haŋsâi Paulo sot nen ârândâŋ Yakobogâren âiwen. Zâi tâindâ Yesugât kâmut galem a zen gawe. ");
INSERT INTO kpf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Gane Pauloŋâ bitziŋ kom Anutuŋâ mam okŋaŋgi kamân ŋâin gok zeŋgâren nep tuugip, zorat den siŋgi dâzâŋgom naŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pauloŋâ den siŋgi dâzâŋgom naŋgi nâŋgâm Anutu sâm âlip kwâkŋaŋgâmŋâ itâ sâm dukuwe, “Bukuniŋâ Paulo, nâŋgat. Yuda a doŋbep patâ Yesugât kâmut op ândie. Zen aksik Mosegât gurumin den lum kâtigie. ");
INSERT INTO kpf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Gâgât den itâ gâi nâŋgâme, ‘Yuda a hân ŋâin âi ândie, zen Mosegât den birâbigât dâzâŋgomap. Zen murarâpziŋâ mân kwabâ kwatziŋgâbigât dâzâŋgomap. Sâkurâpniŋaŋgât gurumin den, zo mân lubigât sâmap.’ ");
INSERT INTO kpf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Kamân ziren Yuda aŋâ gâgât yatâ nâŋgâme, gât ko dap utnat? Gâ Yerusalem kamânân gaat, zorat siŋgi nâŋgâm naŋgâbi. Nâŋgâmŋâ mindubi. ");
INSERT INTO kpf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Gât ko nen den ŋâi dâgogindâ zo upan. Neŋgâren a kimembut ândie. Zen Anutu mâteŋan den sâm kâtigem kâukziŋ mân mânâŋgât ândime. ");
INSERT INTO kpf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Oi gâ zeŋgâren târokwatgigindâ sii nalem kwâlâna om kâukziŋ mânâŋgâtpi. Gâ yatâ otna a ambân zen gek itâ nâŋgâbi, ‘Zâkkât den nâŋgâwen, zo bon buŋâ. Zâk gurumin den lum ândimap.’ ");
INSERT INTO kpf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Hân ŋâin gokŋâ ziŋ Yesugât kâmut urâwe, zeŋgât den itâ sâwen, ‘Zen nalem bem lopiogât siŋgi sâne mân nimbi. Zuu gilâm sot zuu gilâmziŋoot mân nibi. Ap ambin, zet mân birâyaŋgâbabot.’ Zo yatâ sâm kâtigiwen.” ");
INSERT INTO kpf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Yatâ sâne Paulo zâk dinziŋâ nâŋgâm a kimembut zeŋgâren târokwâip. Haŋsâi too saŋgonŋâ tirik namin zâiwe. Sâkziŋ kubikaŋgâm Anutugât siŋgi nalem pânam utnetâ Pauloŋâ tirik namâ galem a zorat dukuip. ");
INSERT INTO kpf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nep mâme ŋâi âkââkâŋan Pauloŋâ tirik namin zâi tâi Asia hânân gâbâ Yuda a nâmbutŋâ ziŋâ zâk ekŋâ a aksik kâsa okŋaŋgânat sâm gâsuwe. ");
INSERT INTO kpf_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Gâsumŋâ den kâtikŋâ sâm sâwe, “O Isirae a, ga betniŋan minek. A zirâŋ hânŋâ hânŋâ ândim Yuda a kâsa otniŋgâmŋâ Mosegât den sot tirik namâ zorat mem gei kwâkwat den sâm dâzâŋgomap. Oi tirik namâniŋan Grik a diiziŋgi zâine mân dâp uap.” ");
INSERT INTO kpf_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Paulo zâk Epeso kamânân gokŋâ Toropimo, Yuda a buŋ, zâk sot kamânân âim gâitâ ekŋâ zorat sarâ itâ sâwe, “Pauloŋâ tirik namin diim zâim geip.” ");
INSERT INTO kpf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","31","Paulo zâk yatâ oip sâne kamân mâirâp ziŋ aksik umziŋ bâliŋ oi zaatŋâ mindum gawe. Oi a nâmbutŋandâ Paulo gâsum diimŋâ tirik namin gâbâ âkŋan giwe. Diim gine mâtâp dooŋguwe. Paulo gâsumŋâ kune mumbapkât utne siŋgi zo Roma kâwali a galem zâkkâren ari itâ nâŋgip, “Yerusalem a zen aksik kâsa gâsâyague.” ");
INSERT INTO kpf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Den yatâ nâŋgâmŋâ zorâŋak kâwali a galem patâŋâ arâpŋâ sâtŋâ sot yen gâsuziŋgi sârârâk kârâm âiwe. Oi Yuda a zen Paulo kom tatne kâwali a galem patâ sot kâwali a, zen gane ziŋgit birâwe. ");
INSERT INTO kpf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Oi kâwali a galem patâŋâ ga Paulo bitziŋan gâbâ betziŋan mem sâi tâk kâtikŋandâ saawe. Oi Paulogât topŋâ sot kut ŋâi ŋâi oip, zorat mâsikâziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Mâsikâziŋgi a ambân zen den ŋâi sâne nâmbutŋandâ den laŋ gulip sâwe. Yatâ sâne den zo top mân nâŋgâm sâi kâwali a ziŋ gâsu diim namâziŋan âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Oi Paulo tiregân gâi a doŋbep patâ ziŋâ mindum mâtâp dooŋguwe. Dooŋgune kâwali a ziŋâ Paulo gâsum bitziŋâ kwâkŋanâk mem namin zâiwe. ");
INSERT INTO kpf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","A aksik patâ moliziŋgâm gam den yu kambâŋ sâm itâ sâwe, “A zo kune buŋ oik.” ");
INSERT INTO kpf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Paulo diim namin baginâ sâne Pauloŋâ kâwali a galem dukum sâip, “Nâŋgânina den ŋâi dâgobâ.” Sâi kâwali a galemŋâ sâip, “Gâ dap op Grik denân sat? ");
INSERT INTO kpf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mârumâk Aigita a ŋâiŋâ a kutâ kunat sâmŋâ a 4 tausen diiziŋgi hân a mân ândiândiŋan âiwe. Gâ a zo mo ŋâi?” ");
INSERT INTO kpf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Yatâ sâm mâsiki Pauloŋâ itâ sâip, “Nâ Yuda a. Kilikia hânân Taso kamân patâ, zo gokŋâ. Gâ nâŋgânina den ŋâi dâzâŋgobâ.” ");
INSERT INTO kpf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Oi nâŋgâŋaŋgi Paulo zâk tiregân kin a den hiriŋsâbigât bikŋandâ dâp oi zen hiriŋsâne Yuda ziiŋ denân itâ sâm dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Bukurâpnâ sot patârâpnâ, nâ den sa nâŋgânek.” ");
INSERT INTO kpf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Paulo zâk yatâ sâm Yuda a ziiŋâ denân dâzâŋgoi hiriŋsâm den mân sâm tarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Oi târokwap dâzâŋgoip, “Nâ Yuda a. Kilikia hânân Taso kamânân muyagewan. Oi kamân ziren ga ekap namin ândim lâmbarâwan. A patâ Gamalie, zâkkât um topŋan ândia sâkurâpniŋaŋgât gurumin den zo kwâkâm nigi nâŋgâwan. Oi zen itârâŋ ue, zo yatik nâ Anutugât gurumin den kâtigem lum ândiwan. ");
INSERT INTO kpf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Oi Yesugât kâmut zi buŋ upi sâm nâ kâsa otziŋgâm a sot ambân aksik saaziŋgâm tâk namin zâmbam ândiwan. ");
INSERT INTO kpf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Tirik namâ galem a patâ sot a sâtŋâ, zen nâgât topnâ âlip nâŋge. Zen bukurâpniŋ Damasiko kamânân ândime, zeŋgât ekap kulemgum nine itâ sâm âiwan, ‘Ândi a ambân Yesu nâŋgâm pâlâtâŋ kwapme, zen gâsuziŋgâm diiziŋgâm Yerusalem kamânân ga hâuŋâ sâknam ziŋgâbi.’ ");
INSERT INTO kpf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Yatâ sâm mâtâbân âim mirâ bâkŋan oi Damasiko mâte ua sumbemân gâbâ kârâp âsakŋâ patâ nâgâren âsageip. ");
INSERT INTO kpf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Âsagei hânân gei zemŋâ den itâ muyagei nâŋgâwan, ‘Saulo, Saulo, gâ wangât nom ândimat? ");
INSERT INTO kpf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Oi nâŋâ sâwan, ‘Kembu, gâ ŋâi?’ Sa itâ dâtnogip, ‘Gâ nom ândimat. Nâ Yesu Nasarete gokŋâ.’ ");
INSERT INTO kpf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","A nâ sot ândiwe, zen kârâp âsakŋik igâwe. Den ko mân nâŋgâm kwâtâtiwe. ");
INSERT INTO kpf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Oi nâŋâ sâwan, ‘Kembu, Nâ dap upatkât sat?’ Sa Kembuŋâ itâ sâm dâtnogip, ‘Zaat Damasiko kamânân âiban. Zoren âina a ŋâiŋâ nep tuubangât dâgobap.’ ");
INSERT INTO kpf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Oi kârâp âsakŋâ patâgât sinnâ bâpsâipkât eksandâ ŋâtâtiksâi bukurâpnâ zen bitnan gâsunine Damasiko kamânân âiwen. ");
INSERT INTO kpf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Kamân zoren a ŋâi ândeip, kutŋâ Anania. Zâkŋâ gurumin den lum ândeip. Yuda a zoren ândiwe, zen zâkkât nâŋgâne a âlipŋâ oip. ");
INSERT INTO kpf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","A zorâŋ nâgâren ga itâ sâm dâtnogip. ‘Bukunâ Saulo, gâ siŋgâ ânâŋgârik.’ Sâi zorenâk sinnâ ânâŋgâri egâwan. ");
INSERT INTO kpf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Oi den itâ sâm dâtnogip, ‘Sâkurâpniŋaŋgât Anutu, zâk mârum zâkkât nepŋâ tuubangât gâsum sâlâpgogip. Gâ Anutugât kore mâman a târârak Yesu ikpangât sot diŋâ nâŋgâbangât sâip. ");
INSERT INTO kpf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Gâ kut ŋâi egin sot zâkkât siŋgi den, zo a ambân aksik dâzâŋgoban. ");
INSERT INTO kpf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Oi zi wangât mambât yen ândiat? Gâ zaat Yesu bimbi kwâkŋaŋgâna too sâŋgongiga Yesuŋâ tosagâ gulipkubap.’ ");
INSERT INTO kpf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Yatâ opŋâ mâik ŋâi tap nâŋgâm ko Yerusalem kamânân âburem gam tirik namin zâim ninâu sâm umanân Yesu egâwan. ");
INSERT INTO kpf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Eksa itâ dâtnogip, ‘Kamân zirat a, zen gâgât lâuyân gâbâ nâgât den siŋgi nâŋgâm birâbi. Zorat gâ kek Yerusalem kâmân birâm âi.’ ");
INSERT INTO kpf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Sâi nâ den hâuŋâ itâ dukuwan, ‘Kembu, nâ arâpkâ mâpâmâpâse namin muyageziŋgâm gâsuziŋgâm zâŋgom tâk namin zâmbam ândiwan. Oi zo kamân zirat mariŋâ âlip nâŋge. ");
INSERT INTO kpf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Oi gâgât den sâsâŋ a Setepano kunam hâmbâziŋ kwâkâm kinnâ topŋan pamŋâ kune nâŋga âlip oip. Oi nâ zeŋgât hâmbâ galem orâwan. Oi zo kamân zirat a ambân nâŋgâm naŋgegât gâgât siŋgi âlip dâzâŋgobat.’ ");
INSERT INTO kpf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Yatâ sa Kembuŋâ itâ dâtnogip, ‘Gâ zaat kubikaŋgâna hân ŋâin gok zeŋgâren sâŋgongoga âiban.’” ");
INSERT INTO kpf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","A zen kindap kwap Pauloŋâ hân ŋâin gokŋâ ziŋâ Anutugât siŋgi upigât sâi nâŋgâne mân dâp oi den yu kambâŋ sâm itâ sâwe, “A zo kune moik. A yatâ zo zâk ândei mân dâp upap.” ");
INSERT INTO kpf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","A ziŋâ zo yatâ sâm yu kambâŋ hâmbâziŋ kwâkâm suundum sot mâpot pane zâim geip. ");
INSERT INTO kpf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kâwali a galem patâŋâ sâi arâpŋâ Paulo diim namâ kâligen zâiwe. Oi zoren a zen wangât den doŋbep se sâmŋâ zorat topŋâ sâm muyagei nâŋgânat sâm tâkŋâ lapitpigât sâm ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Oi zen tâkŋâ lapitnamŋâ inzutŋâ saane ko Pauloŋâ a sâtŋâziŋâ itâ sâm mâsikip, “Zen dâp yatâ Roma a diŋâ mân nâŋgâmŋâ tâkŋâ lapitne dâp upap?” ");
INSERT INTO kpf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yatâ sâi a sâtŋâziŋandâ patâgâren âi dukum sâip, “Dap utnat? A zi Roma a bonŋâ.” ");
INSERT INTO kpf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Sâi kâwali a zeŋgât galem a patâ, zâkŋâ Paulogâren âi mâsikâm sâip, “Gâ sâ. Gâ perâkŋak Roma a?” Sâi Pauloŋâ sâip, “Zo perâkŋak.” ");
INSERT INTO kpf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Sâi Galem a patâŋâ itâ sâip, “Nâ a yenŋandâ kât doŋbep pamŋâ Roma a orâwan.” Sâi ko Pauloŋâ sâip, “Nâ âsaâsaginâ Roma a.” ");
INSERT INTO kpf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Yatâ sâi Paulo lapitnam urâwe, zo birâwe. Oi kâwali a zeŋgât galem a patâ, zâk den zo nâŋgâm wangât yatâ uan sâm pârâkpam keŋgât oip. ");
INSERT INTO kpf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Haŋsâi kâwali a zeŋgât galem a patâ, zâkŋâ Yuda a wangât sâm Paulo nâŋgâm bâliŋ kwâkŋaŋge sâm zorat topŋâ nâŋgâbat sâm tirik namâ galem a patâ sot a sâtŋâ sâi aksik mindunetâ Paulo tâkŋâ olaŋ diim gâi minduminduyân pâip. ");
INSERT INTO kpf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo zâk a sâtŋâ sen tâpâk ziŋgit itâ sâm dâzâŋgoip, “A bukurâpnâ, Anutugât mâteŋan târârak ândim gâwan. Aŋunnaŋgât mân opman.” ");
INSERT INTO kpf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Yatâ sâi ko tirik namâ galem a patâ Anania, zâkŋâ a ziŋâ lâuŋan kumbigât sâip. ");
INSERT INTO kpf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Sâi Pauloŋâ itâ sâm dukuip, “Sâkkâ ko tobat âlipŋâ. Umgâ ko bâliŋâ. Gâ Anutuŋâ gobap. Gâ Mosegât gurumin den lum nâgâren den kubikkubik tuubam sat. Ka Mosegât gurumin den kom nobigât dâzâŋguat.” ");
INSERT INTO kpf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Yatâ sâi a kirâwe, zen Paulo itâ sâm dukuwe, “Gâ wangât Anutugât tirik namâ galem a patâ zo sâm bâliŋ kwâkŋâŋgat?” ");
INSERT INTO kpf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Sâne Pauloŋâ itâ dâzâŋgoip, “Bukurâp, zâk a patâ ândiap, zo mân nâŋgâm den zo san. Kembugât ekabân den ŋâi itâ kulemguwe, ‘Gâ a ambân zeŋgât galem a mân sâm bâliŋ kwâkŋaŋgâban.’ Nâ den zo nâŋgâman.” ");
INSERT INTO kpf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Oi a sâtŋâ kâmut tarâwe, zen nâmbutŋâ Sadukaio a ândiwe. Nâmbutŋâ ko Parisaio a ândiwe. Paulo zâk zo ek nâŋgâm den mem zâi pam itâ sâm dâzâŋgoip, “A bukurâpnâ, nâ Parisaio a. Sâkurâpnâ zen Parisaio a ândiwe. Parisaio a nen momŋâ zaatnat sâmen. Momŋâ zaatzaatŋâ, den zo luman, gât ko denân nâbanse.” ");
INSERT INTO kpf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Den yatâ sâi Parisaio a sot Sadukaio a, zen den sâm kwâkâyaŋgâne kâsâp muyageip. ");
INSERT INTO kpf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadukaio a zen mumuŋan gâbâ zaatzaat sot sumbem a sot um dâp zo mân ziap sâmarâwe. Ka Parisaio a zen kut ŋâi ŋâi zorat nâŋgâne bon opmap. ");
INSERT INTO kpf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Oi zorat minduminduziŋan den sârek patâ âraguwe. Yatâ opŋâ Parisaio a zeŋgât kâmurân gâbâ Kembugât gurumin den galem a nâmbutŋâ zen zaatŋâ den kârâpŋoot itâ sâwe, “Nen a zi egindâ tosaŋâ buŋ uap. Sumbem a mo a tabâŋâ ziŋâ den dukuwe oi ko dap sânat?” ");
INSERT INTO kpf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Oi den kârâpŋoot âragunetâ kâwali a galem a patâ zâk Paulo kumbegât keŋgât op sâi arâpŋâ kâmut ziŋâ geim Paulo osetziŋan gâbâ gâsum diim namâziŋan zâiwe. ");
INSERT INTO kpf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ŋâtik zoren Kembuŋâ muyagem Paulo gootŋan kin itâ sâip, “Gâ mân keŋgât ot. Ziren Yerusalem kamânân nâgât den siŋgi sâm muyagiat, zo yatik Roma kamânân sâm muyagiban.” ");
INSERT INTO kpf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Haŋsâi Yuda a nâmbutŋandâ den itâ sâm saawe, “Nen nalem birâm yenâk ândinat. Paulo kom ko nem ândinat.” Yatâ sâm Anutu mâteŋan den zo sâm kâtigiwe. ");
INSERT INTO kpf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","A teŋgâziŋ 40 yatâ zorâŋ den zo sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","A zo zeŋgâren gâbâ nâmbutŋandâ tirik namâ galem a patâgâren âim itâ sâwe, “Nen nalem birâm ândimŋâ Paulo kom nalem ninatkât sâm kâtigien. ");
INSERT INTO kpf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Zorat gâ sot a sâtŋâ zen kâwali a patâgâren den itâ pane âibap, ‘Gâ Paulo sâŋgonguna gâi zâkkât diŋâ sâm kubiknat.’ Oi dinziŋâ nâŋgâm Paulo sâŋgongoi mâtâbân gâi kunat.” ");
INSERT INTO kpf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","17","Oi Paulogât biitŋandâ kâmbamgât den zo nâŋgip. Nâŋgâmŋâ kâwali a zeŋgât namin bagim aniŋâ dukuip. Dukui ko Pauloŋâ kâwali a zeŋgât a sâtŋâ ŋâi konsâm itâ dukuip, “Gâ kâtep zi kâwali a patâgâren diim âina den ŋâi dukubap.” ");
INSERT INTO kpf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Sâi a zorâŋ katep zo diim patâŋaŋgâren âim itâ dukuip, “A tâk namin taap, kutŋâ Paulo, zâkŋâ noonsâm dâtnogi katep zi diim gaan. Katep zirâŋ den ŋâi dâgobap.” ");
INSERT INTO kpf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Yatâ sâm dukui kâwali a galem patâŋâ katep bikŋan gâsum diim ginŋan âim mâsikâm sâip, “Den dap dâtnoban?” ");
INSERT INTO kpf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mâsiki katepŋâ itâ sâm dukuip, “Yuda a zen gâgâren den pane gâbapkât den saage. Mukan Paulo minduminduziŋan diim âine topŋâ sâm muyagibapkât dâgobi. ");
INSERT INTO kpf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Dâgone dinziŋâ mân nâŋgâban. A 40 yatâ zorâŋ Paulo kunam se. Zen nalem birâm ândim Paulo kom nalem ninatkât se. Oi zen Paulo kunam mâtâbân mambât te.” ");
INSERT INTO kpf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Katep zorâŋ den yatâ sâi kâwali a galemŋâ den itâ sâm sâŋgongoip, “Gâ den dâtnogat, zo a ŋâi mânâk dâzâŋgoban.” ");
INSERT INTO kpf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Oi kâwali a galem a patâŋâ kâwali a sâtŋâ zagât diizikâm itâ sâm dâzâkoip, “Zet sâitâ kâwali a ki mâtâp âiâiŋâ 2 handeret sot kâwali a bâu biosi kwâkŋan âiâiŋâ 70 sot liŋgip kâlâu a 2 handeret zorâŋâ kubikaŋgâm ŋâtikkât narâk nâmburân kimembut, narâk zoren Kaisarea kamânân âibi. ");
INSERT INTO kpf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Oi Paulogât bâu biosi ŋâi kwâkŋan tâpapkât kubikpi. Oi mulunâk galem okŋaŋgâm Roma a kutâ Pelikigâren diim âibi.” ");
INSERT INTO kpf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Oi Kâwali a galem a patâŋâ Pelikigât ekap ŋâi itâ kulemgoip, ");
INSERT INTO kpf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Klaudio Lisia, nâŋâ a kutâ âlipŋânâ Peliki, gâgât ekap zi kulemguan. ");
INSERT INTO kpf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Kâwali a ziŋ a ŋâi diim ge. Zo Yuda a ziŋ kune mumbam oi a zo Roma a nâŋgâmŋâ sa kâwali anâ sot âimŋâ bitziŋan gâbâ mâkâwen. ");
INSERT INTO kpf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Oi denân parâwe, zorat topŋâ nâŋgâbat sâm a sâtŋâ minduminduyân diim âiwan. ");
INSERT INTO kpf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Diim âim ziiŋaŋgât gurumin den sâne itâ nâŋgâwan. Kut ŋâi ŋâi oip, zorâŋ kâmbam mo tâk namin tâtat, zorat dâp mân uap. ");
INSERT INTO kpf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Oi a nâmbutŋâ ziŋâ Paulo sipkum kunam utne gâgâren sâŋgogua gaap. Oi den sâkŋanâk sâme, zen sâŋgonzâŋgua gâgâren gam diŋâ dâgobi.” Ekap yatâ zo kulemgum kâwali arâpŋâ ziŋgâm mem âibigât sâip. ");
INSERT INTO kpf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Oi Kâwali a zen patâgât den lumŋâ ŋâtigân Paulo diim âim Antipatri kamânân takâwe. ");
INSERT INTO kpf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Haŋsâi kâwali a nâmbutŋâ kamânziŋan puriksâne kâwali a biosi kwâkŋan tâtat ziiŋik diim âim Kaisarea kamânân takâwe. ");
INSERT INTO kpf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Takâm a kutâ ekap pindâm Paulo yatik bikŋan parâwe. ");
INSERT INTO kpf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","A kutâŋâ ekap zo sâlâpkum Paulogât hân topŋaŋgât mâsikip. Zâk Kilikia hânân gokŋâ nâŋgâm itâ sâip, ");
INSERT INTO kpf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“A denân gâbanse, zen gane narâk zoren den kubiknat.” Yatâ sâm kâwali a zeŋgât bitziŋan pâi diim Herodegât den kubikkubik namin pam galem urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Sirâm bâtnâmbut âki tirik namâ galem a patâ Anania, zâk sot galem a nâmbutŋâ sot a ŋâi kutŋâ Teatulo, zen Kaisarea kamânân geim Paulogât den sânam Roma a kutâgâren âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Âine a kutaŋâ sâi Paulo diim gane Teatuloŋâ Paulo tosaŋâŋaŋgât den itâ sâm muyageip, “A kutâ âlipŋâ Peliki, gâ âlip galem otniŋgâna lumbeŋ ândimen. Oi Yuda a kâmut nen zi betniŋan mena ândiândi âlip ândien. ");
INSERT INTO kpf_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Gâ kâmân dâp âlip galem otniŋgâmat, zorat nâŋgindâ âlip opmap. ");
INSERT INTO kpf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Oi den sa kârep opapkât nâŋgânina den pâŋkânok dâgobâ. ");
INSERT INTO kpf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","A zirat nâŋgindâ bâliŋ opmap. Yuda a hânŋâ hânŋâ den dâzâŋgom um gulip kwatziŋgâmap. A zo Nasarete gokŋâ sarâ agât arâpŋâ, zeŋgât a sâtŋâ ândiap. ");
INSERT INTO kpf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Zâkŋâ tirik namin âim mem bâliŋ kwapâ sâi gâsuwen. ");
INSERT INTO kpf_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Niiŋâ gurumin den lum kubiknam oindâ Kawali a galemŋâ Lisia, zâk sot arâpŋâ ga diim âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Oi denân parâwen, nen gâgâren gânatkât sâip. Oi nen den dâgogen, zorat gikak mâsikâm topŋâ nâŋgâban.” ");
INSERT INTO kpf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Den yatâ sâi Yuda a ziŋâ bekŋan mem zorik sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Oi Pelikiŋâ bikŋâ dâp oi Pauloŋâ itâ sâip. “Gâ Yuda neŋgât hân ziren a kutâ op narâk kârep ândim gâin, zorat umâlibân den sâbat. ");
INSERT INTO kpf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nâ Yerusalem kamânân Anutu mâpâsibam op zâim ândia sirâm kiin zagât uap. Den zorat um zagât op a zi mâsikâziŋgâna dâgonek. ");
INSERT INTO kpf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nâ tirik namin mo mâpâmâpâse namin mo sombemân a ambân zen sot sârek den mân âragoindâ niŋgirâwe. ");
INSERT INTO kpf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Oi a zirâŋâ den se, zorât bonŋâ mân tirâpgobi. ");
INSERT INTO kpf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Oi ŋâi dâgoga nâŋgâ. Mâtâp uŋakŋâ birâme, zorik ândim sâkurâpnâ zeŋgât Anutu mâpâseman. Ka Mosegât gurumin den sot Propete zeŋgât den kulemguwe, zorat nâŋga bonŋâ opmap. ");
INSERT INTO kpf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Oi gâtâm Anutuŋâ a orot mâmeziŋ bâliŋâ sot âlipŋâ, nen mumuŋan gâbâ mâŋginiŋgi zaatnat, zo nâŋgâm ândime. Zo yatik nâ nâŋgâm ândiman. ");
INSERT INTO kpf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Yatâ opŋâ galem oraŋgâm ândim Anutu sot a zeŋgât mâteziŋan aŋun mân op ândiman. ");
INSERT INTO kpf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Yatâ op hân kârebân ândim bukurâpnaŋgât kât mem Yerusalem kamânân gâwan. ");
INSERT INTO kpf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kât zo mem gam tirik namin zâim kubikaŋgâm ta muyageniwe. Zoren a kâmurân mo kwamit patâ, zoren mân tarâwan. ");
INSERT INTO kpf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Asia hânân gâbâ Yuda a nâmbutŋâ zen tarâwe. Oi a zo ziŋâ nâgât tosa nâŋge oi ko gâgât mâtegan ga sâm muyaginek. ");
INSERT INTO kpf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Mo a sâtŋâ mindumunduyân nâŋâ den sa tosa ŋâi muyagiwe oi ko a zi ziŋâ gâgât mâtegan sapsunek. ");
INSERT INTO kpf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nâ a minduminduyân den kânok sâwan. Zo nâŋgâne mân dâp oip. Zo ko den kâtik sâm itâ sâwan. Mom zaatzaatŋâ den zo sâman, zorat nâmbutŋandâ denân nâbanetâ kinzan.” ");
INSERT INTO kpf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pauloŋâ den yatâ sâi ko Roma a kutâ Peliki, zâk Paulogât den zo mân sâm kwâkâm biri zeip. Wangât, zâk mâtâp uŋakŋâ zorat den siŋgi nâŋgip, zorat itâ dâzâŋgoip, “Kâwali a galem a Lisiaŋâ Yerusalem kamânân gâbâ gâi ko zeŋgât den sâm kwâkâbat.” ");
INSERT INTO kpf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Yatâ sâmŋâ kâwali a sâtŋâ itâ sâm dukuip, “Gâ sâne arâpkâ zen Paulo galem op kâsa mân okŋaŋgâbi. Bukurâpŋâ, zen kut ŋâi ŋâi mem ga pindânam utne mâtâp mân dooŋgubi.” ");
INSERT INTO kpf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Sirâm nâmbutŋâ zo tapŋâ Peliki zâk ambinŋâ, Yuda gokŋâ, kutŋâ Durusila, zâk sot tapŋâ Paulo sâi gâm Kristo Yesu nâŋgâm pâlâtâŋ kwâkwatŋaŋgât dâzâkoip. ");
INSERT INTO kpf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Oi Pauloŋâ târârak ândiândiŋ sot âkŋâlegât kendon ândiândiŋ sot hâuŋâ mimiŋaŋgât narâkŋâ, zorat den sâi Pelikiŋâ keŋgât opŋâ Paulo itâ sâm dukuip, “Âlip âi ândina neŋgât kabâ ŋâi muyagei ko sa gâban.” ");
INSERT INTO kpf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","A kutâ zo Paulo kât nibap sâm narâk dâp sâi gâi zâk sot den den op ândeip. ");
INSERT INTO kpf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Oi kendon zagât âki a kutâ ŋâi kutŋâ Porikio Pesto, zâk Peliki hâukwâip. Oi Peliki zâk Yuda a ambân umziŋ âlip upapkât Paulo tâk naminâk birâŋaŋgâm arip. ");
INSERT INTO kpf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pestoŋâ nep zo mem sirâm karâmbut tap Kaisarea kamânân gâbâ Yerusalem kamânân zarip. ");
INSERT INTO kpf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Zai taki tirik namâ galem a sot Yuda a zâizâiŋ, zen zâkkâren gamŋâ Paulogât den dukuwe. ");
INSERT INTO kpf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Zâk nâŋgâziŋgâm sâi Paulo Yerusalem zâibapkât sâwe. (Oi zen ziiŋak mâtâbân Paulo tik tap kunat sâm, sâm kâtâŋ urâwe.) ");
INSERT INTO kpf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Sânetâ Pestoŋâ itâ sâm dâzâŋgoip, “Paulo zâk Kaisarea kamânân tâk namin taap. Oi zoren âburem geibâman. ");
INSERT INTO kpf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Paulogât tosa sânam zeŋgâren gâbâ a sâtŋâ, ziŋâ nâ sot ârândâŋ geimŋâ sâbi.” ");
INSERT INTO kpf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Yatâ sâmŋâ sirâm nâmburân karâmbut mo bâzagât yatâ zo Yerusalem kamânân tap ko Kaisarea kamânân giarip. Zoren taki mirâ haŋsâi den sâsâŋ namin zâimŋâ sâi Paulo diim zâiwe. ");
INSERT INTO kpf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pauloŋâ zari Yuda a Yerusalem kamânân gâbâ gawe, zen haamgumŋâ tosaŋaŋgât opŋâ den doŋbep sâm kirâwe. Den sâwe, zorat bonŋâ ŋâi mân muyageip. ");
INSERT INTO kpf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Sâne Pauloŋâ dinziŋâ mem gem itâ sâip, “Yuda a zeŋgât gurumin den sot tirik namâ sot Roma a kutâ patâ, zen mân sâm bâliŋ kwatziŋgâman.” ");
INSERT INTO kpf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Sâi Pestoŋâ Yuda a umziŋ âlip upapkât Paulo mâsikâm sâip, “Gâ dap nâŋgat? Gâ diigim Yerusalem kamânân zâim zoren diŋgâ sâm kwâkâbâ?” ");
INSERT INTO kpf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Sâi Pauloŋâ itâ sâm dukuip, “Buŋâ. Nâgât den ziren sâm kwâkâban. Roma a kutâ patâ Sisagât namâ zi. Gâ gikâk nâgât topnâ nâŋgat. Nâ Yuda a mân bâliŋ otziŋgâwan. ");
INSERT INTO kpf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nâ tosa patâ muyagem sâi ko nobâ sâna sâknâ mân aŋgân kârâbam. Zen nâgât sâknanâk se, gât ko zeŋgât bitziŋan mân nâbanban. Zorat Roma a kutâ patâ Sisa dinnâ sâm kwâkâbapkât san.” ");
INSERT INTO kpf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Yatâ sâi Pesto sot arâpŋâ zen mindum den âragumŋâ Pestoŋâ Paulo itâ sâm dukuip, “A kutâ patâgât sat, zorat a kutâ patâgâren âiban.” ");
INSERT INTO kpf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","14","Sirâm nâmbutŋâ âki a kutâ Agripa sot ponâŋâ Beanike zet Kaisarea kamânân geim Pesto buku okŋaŋgâm sirâm nâmbutŋâ zâk sot tâtat mâme oitâ Pestoŋâ Paulogât den siŋgi a kutâ itâ sâm dukuip, “Pelikiŋâ tâk namâŋan a ŋâi pam ari zi taap. ");
INSERT INTO kpf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Oi nâ Yerusalem kamânân zariandâ Yuda a zeŋgât tirik namâ galem a sot a zâizâiŋ zen nâgâren mindumŋâ a zo kua mumbapkât sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Oi nâ den torenŋâ itâ sâm dâzâŋgowan, ‘Roma a nen dengârâk op a kâmbamân mân zâmbanmen. Oi nen itâ upmen. A toren toren minduziŋgindâ torengoot sâi torengoot sâi yatâ sâme.’ ");
INSERT INTO kpf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Yatâ dâzâŋgua zen gane haŋsâi den namin zâim Paulo sot Yuda a minduziŋgâwan. ");
INSERT INTO kpf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","19","Oi Yuda a ziŋâ zâkkât bâliŋâ ŋâi sâbi sa ko zen Yuda a ziiŋaŋgât gurumin den, zorat âragwâragu urâwe. Oi a mumuŋâ ŋâi Yesu, zâkkât den mem ândiwe. A zorat Pauloŋâ itâ sâmap, ‘Zâk zaat ândiap.’ ");
INSERT INTO kpf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nâ den zorat kwakŋâ Paulo Yerusalem kamânân zari diŋâ sâm kwâkâbatkât dukuwan. ");
INSERT INTO kpf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Dukua Paulo zâk Roma a kutâ patâŋâ diŋâ kwâkâbapkât sâip. Oi Roma a kutâgâren âibapkât tâk namin mambât ândiap.” ");
INSERT INTO kpf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Pestoŋâ yatâ sâm dukui Agripaŋâ sâip, “Nâ a zorat diŋâ naŋgâbatkât otnigap.” Sâi Pestoŋâ itâ sâip, “Âlip. Mukan diŋâ nâŋgâban.” ");
INSERT INTO kpf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Mirâ haŋsâi Agripa sot Beanike zet a kutâ neulezikŋoot den namin zâiwet. Oi kâwali a patâ sot kamân zorat a zâizâiŋ, zen molizikâne ârândâŋ zâiwe. Zâinetâ Pestoŋâ sâi Paulo diim zâiwe. ");
INSERT INTO kpf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Diim zâine Pestoŋâ den itâ sâip, “A kutâ Agripa sot a nen sot zi te, zen dâzâŋgua nâŋgânek. A kinzap, zirat opŋâ Yuda a pisuk Yerusalem kamânân sot ziren, zen zâkkât tosagât den sâm den kwamit patâ itâ sâwe, ‘Zâkŋâ ândei mân dâp upap.’ ");
INSERT INTO kpf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Zen yatâ sâwe. Nâ ko tosaŋâ kârua kâmbamgât siŋgi mân uap. Oi Roma a kutâ patâgât sâipkât zâkkâren sâŋgongua âibap. ");
INSERT INTO kpf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Oi zâkkât tosa mân muyagemŋâ a kutâ patâgât ekap kulemgubâ sâm kwaksan. Zorat a zi, zeŋgâren sot a kutâ Agripa, gâgât mâtegan ga kinzap. Oi zâkkât topŋâ sâi nâŋgindâ diŋâ ekabân kulemguandâ âibap. ");
INSERT INTO kpf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nâ tâk namâ a ŋâi tosaŋaŋgât den mân kulemgum yenâk Roma kamânân sâŋgongua ari mân dâp upap.” ");
INSERT INTO kpf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripaŋâ Paulo itâ sâm dukuip, “Gikak topkâ sâna nâŋgânâ.” Sâi Pauloŋâ bikŋâ pamŋâ den itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Yuda a ziŋâ denân nâbanse, zorat torenŋâ a kutâ Agripa mâtegan sâbatkât umnâ âlip uap. ");
INSERT INTO kpf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Gâŋâ Yuda a neŋgât orot mâmeniŋâ sot kut ŋâi ŋâi upmen, zo topŋâ nâŋgâm naŋgat. Nâŋgânina den siŋgi kârep patâ sa mân âkon upan. ");
INSERT INTO kpf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Nâ katepnan gâbâ Yerusalem kamânân bukurâpnâ osetziŋan ândia orot mâmenâ zo ek nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Zen nâgât topnâ ek naŋgâweŋâ mân se. Nâ Parisaio a zeŋgât oserân ândim lâmbarâwan. Sâkurâpniŋ zeŋgât gurumin den zo lum ândim kâtigewan. ");
INSERT INTO kpf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nâ tâk namin zeman, zo ŋâigât buŋâ. Anutuŋâ âse sâkurâpniŋâ zeŋgât den ŋâi sâm kâtigeip. Den zo itâ. Nen ândim momŋâ zaatnat. ");
INSERT INTO kpf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Den zo bonŋâ upapkât Isirae a kâmut kiin zagât, zen ŋâtik sirâm sâm ândime. Nâ den zorat op nâŋgâm ândia Yuda a ziŋâ denân nâbarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Anutuŋâ a mumuŋâ mâŋgiziŋgâmap. Zen wangât zo nâŋgâne mân orotŋâ yatâ uap? ");
INSERT INTO kpf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Nâ mârumŋan itâ nâŋgâm ândiwan. Yesu, Nasarete gokŋâ sot arâpŋâ kâsa otziŋgâm sa buŋ upigât nepnâ tuum ândiwan. ");
INSERT INTO kpf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yerusalem kamânân nep zo tuum ândim Yesugât a doŋbep tâk namin zâmbam ândiwan. Tirik namâ galem a patâ, ziŋâ kâmbam sot tâk namin zâmbanbatkât nep diŋ sâm nine ândiwan. A zâŋgonatkât den sâne den zo tângum sâmarâwan. ");
INSERT INTO kpf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Yuda a zeŋgât mâpâmâpâse namâ dâp a ambân Yesugât kutŋâ sâm bâliŋan kwapigât zâŋgom sâknam ziŋgâm gâwan. Oi nâ um kâlak otziŋgâm hân ŋâin ŋâin âi zâŋgom sâknam ziŋgâm gâwan. ");
INSERT INTO kpf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Yatâ ua tirik namâ galem a patâ ziŋâ nep zo nine Damasiko kamânân âiwan. ");
INSERT INTO kpf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mâtâbân aria mirâ bâkŋan oi sumbemân gâbâ kârâp âsakŋâ âsagem gem nâ sot bukurâpnâ âsageniŋgip. O a kutânâ, mirâsiŋ zerâmap, zo tobat ŋâi. Zi âsakŋâ patâ, mirâsiŋ zo walip. ");
INSERT INTO kpf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Yatâ muyagei nen hânân gei zeindâ Yuda denân den ŋâi itâ nâŋgâwan, ‘O Saulo, Saulo, gâ wangât nom ândiat? A ŋâiŋâ wâuŋâ dumunân pam diim âibam oi hârâŋsâm tâpap zo ko sâknam nâŋgâbap. Zo yatâ sâknam nâŋgâm ândiat.’ ");
INSERT INTO kpf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Oi nâŋâ itâ sâwan, ‘Kembu, gâ ŋâi?’ Sa itâ dâtnogip, ‘Nom ândimat. Nâ Yesu. ");
INSERT INTO kpf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Gâ zaat kinan. Nâ kore anâ gâsum sâlâpgobam muyagegigan. Kut ŋâi ŋâi eksat sot kut ŋâi ŋâi gâtâm tirâpgobat, zorat siŋgi a ambân dâzâŋgom ândiban. ");
INSERT INTO kpf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nâ Yuda a zeŋgât bitziŋan sot hân ŋâi a zeŋgât bitziŋan gâbâ mâkâgim ândibat. ");
INSERT INTO kpf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nâ sâŋgongoga zeŋgâren âi siŋgi âlipŋaŋgât nep tuuna umziŋ âburibap. Zen ŋâtâtik ek birâm âsakŋan bagibi. Sataŋŋâ zaaziŋgi ândie, zo birâŋaŋgâm Anutugât a upi. Oi tosaziŋ gulipkoi nâŋgâm pâlâtâŋ kwatniwe, zeŋgât kâmurân bagim sumbemgât siŋgi upi.’ Zâk yatâ sâm dâtnogip. ");
INSERT INTO kpf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","A kutânâ Agripa, nâ sumbemân gâbâ den nâŋgâwan, zo lum ândiwan. ");
INSERT INTO kpf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Zo ko kândom Damasiko kamânân dâzâŋgowan. Oi kamân zo birâm Yerusalem kamânân âim dâzâŋgowan. Zobâ Yudaia kamânŋâ kamânŋâ âi dâzâŋgowan. Oi hân ŋâin gokŋâ, zeŋgâren âi nep tuuga umziŋ melâŋâ Anutu sot pâlâtâŋ op târârak ândibigât dâzâŋgowan. ");
INSERT INTO kpf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yatâ op ândiwan, zorat Yuda a ziŋâ tirik namin gâsunim mumbatkât nowe. ");
INSERT INTO kpf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Oi Anutu zâk betnan mei siŋgi âlip sâwanŋâ sâm ândiman. Oi a zâizâiŋâ sot gigiŋâ zo dâp kânok dâzâŋgom ândiman. Mârumŋan Mose sot Propete ziŋâ bet a ŋâi muyagibapkât kânŋan sâwe, zorik sâm ândian. ");
INSERT INTO kpf_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Den zo itâ. Kristo zâk sâknam nâŋgâm mumbapkât sâsâŋâ. Oi mumuŋâ zeŋgâren gâbâ kândom op zaatŋâ zâkkât den zo Yuda sot hân ŋâin gok, zeŋgât âsakŋâ upap. Oi nâ den zo sâman.” ");
INSERT INTO kpf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pauloŋâ yatâ dâzâŋgom tâi Pestoŋâ den kambâŋâ sâip, “Paulo, umgâ gulip oi den laŋ sat? Ekap doŋbep sâlâpkum ândina umgâ gulip oip.” ");
INSERT INTO kpf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Sâi Pauloŋâ itâ sâm dukuip, “A kutâ âlipŋânâ, nâ umnâ mân gulip oi san. Nâ den san, zo bonŋâ sot târârakŋâ. ");
INSERT INTO kpf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Den san, zorat topŋâ a kutaŋâ âlip nâŋgap. Oi zâkkâren aksik dukum nâŋgan. Kut ŋâi ŋâi zo tik mân muyageip, zorat a kutâ mân kwaksap. ");
INSERT INTO kpf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","A kutâ Agripâ, gâ Propete zeŋgât den nâŋgâna bon uap? Gâ nâŋgâm kwâtâtiat. Zo nâŋgan.” ");
INSERT INTO kpf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Yatâ sâi Agripaŋâ Paulo itâ sâm dukuip, “Gâ sâna mân kârep oi Kristo a opam.” ");
INSERT INTO kpf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Sâi Pauloŋâ itâ sâip, “Gâ sot a nâmbutŋâ zi tap den zi sa nâŋge, zen Kembuŋâ betziŋan mei nâ yatâ upigât san. Ka nâ tâk namin saanine ândian, zorat mân san. Den siŋgi âlipkât op san.” ");
INSERT INTO kpf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Yatâ sâi a kutâŋâ Agripa sot Pesto sot Beanike sot a nâmbutŋâ, zen zaat namin gâbâ gem âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Âi kinŋâ âragum sâwe, “A zi kâmbam mo tâk namâgât siŋgi mân oip.” ");
INSERT INTO kpf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Sâne Agripaŋâ Pesto itâ dukuip, “A zi zâk Roma a kutâ patâ Sisaŋâ diŋâ kwâkâbapkât mân sâip sâi ko gâ olaŋna âi yen ândibap.” ");
INSERT INTO kpf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Italia hânân âinatkât sâne Roma kâwali a sâtŋâ kutŋâ Yulio, zâkŋâ Paulo sot tâk namâ a nâmbutŋâ diiziŋgi waŋgâyân zâiwe. (Luka nâ zen sot âiwen.) ");
INSERT INTO kpf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Waŋgâ zo Adramiteŋai kamânân gâbâ gâip. Zo Asia hân murukŋan kamân tap arip, zoren âibapkât sâsâŋ. Waŋgâ zoren zâim Makedonia a ŋâi kutŋâ Aristako, Tesalonike kamânân gok, zâk sot âiwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Mirâ haŋsâi Sidoŋ kamânân takâm Yulioŋâ Paulo buku okŋaŋgâm nâŋgâŋaŋgi kamânân âimŋâ bukurâpŋoot nalem niwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Oi zobâ arindâ pibâŋâ gam mem kâbakŋei Kipiro hânân âim hân kândâtŋan âiwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Oi Kilikia sot Pampilia zeŋgât saru mâtâp âimŋâ Mila kamânân, Likia hânân takâwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Zoren waŋgâ ŋâi tâip. Zo Alesandiria kamânân gâbâ gâip. Zorâŋâ Italia hânân âibam oi Kâwali aŋâ sâi zoren zâiwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Zâimŋâ mulun âim Kirido kamân gootŋan takâwen. Oi Pibâŋâ mem kâbakŋeniŋgi kamân zo birâm Keret hânângen âiwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Salimone kamân goot goot âim nep patâ tuum âimŋâ Lasea kamân gootŋan saru bikŋâ ŋâi tâip, zoren takâwen. Kutŋâ waŋgâ tâtat âlip. ");
INSERT INTO kpf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Saruyân narâk kârep arindâ Yuda zeŋgât kendon narâkŋâ âki pibâ narâkŋâ mâte oip. Zorat Pauloŋâ girem den dâzâŋgom sâip. ");
INSERT INTO kpf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Bukurâp, zi dum âinatkât nâŋga âlip âinatkât dâp mân uap. Nen âinarân irâ sikumâk buŋâ, nen ârândâŋ waŋgâ bâliŋ oi sâruyân tâmbetagobemgât umnâ gwârâ uap.” ");
INSERT INTO kpf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Yatâ sâi kâwali a sâtŋâ Yulioŋâ Paulogât den birâm waŋgâ mariŋâ sot galem a, zekât dinzik lugip. Oi saru bikŋâ zoren map pibâ gâi waŋgâŋâ tâpapkât dâp mân oip. ");
INSERT INTO kpf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","A doŋbepŋâ zorat Keret hânân saru bikŋâ ŋâi kutŋâ Poinike, zoren âi tâindâ pibâ narâk âki âinatkât sâwe. Saru bikŋâ zoren pibâ patâ mân komap. ");
INSERT INTO kpf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Oi pibâ bâbâlaŋ mirâ toren gâbâ gâi umziŋ âlip oi kela sâmbune kopgâi Keret hân naŋgâm âiwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","15","Âim tâindâ pibâ patâ yuaraŋâ ga mem kâbakŋei hân zo birâm mâtâp tâpkoi osim birâwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Yatâ opŋâ hân ŋâi kutŋâ Kaunda, zorat naŋgâmŋan ârindâ bamin zo saruyân geibam oip. ");
INSERT INTO kpf_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Oi nep patâ tuum sâmbuindâ kopgâip. Oi waŋgâ âbâŋgubapkât tâk doŋbep kâpim saawen. Oi saruyân kât ŋâi kirip, kutŋâ Sirita, zoren âibemgât pibâgât isen diigindâ gei pibâŋâ kom kâbakŋei mâtâp gulip âiwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Pibâ imbaŋâ kom zeipkât haŋsâi sikum mem pane saruyân giarip. ");
INSERT INTO kpf_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Sirâm karâmbuŋan waŋgâgât kut ŋâi ŋâi mem pane saruyân giarip. ");
INSERT INTO kpf_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Sirâm nâmbutŋan pibâ doŋbepŋâ koi mirâsiŋ sot sâŋgelak mân muyagei ekŋâ umniŋ keŋgât oi tâmbetagonamen sâm nâŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Oi a zen nalem birâm narâk kârep yen ândine Pauloŋâ osetziŋan kin itâ sâm dâzâŋgoip, “Bukurâp, zen nâgât den nâŋgâwe sâi ko Keret hânân ândibem. Oi sikum kut ŋâi ŋâi tâmbetkuwen, zo mân muyagebap. ");
INSERT INTO kpf_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Zen mân keŋgât utnek. Aŋâ mân buŋ utnat. Waŋgâ ko tâmbetagobap. ");
INSERT INTO kpf_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ŋâtigân Marinâ kutŋâ konsâm mâpâseman, Anutu, zâkŋâ sumbem kore aŋâ sâŋgongui gem ga nâgâren muyagem itâ sâm dâtnogap, ");
INSERT INTO kpf_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Paulo, gâ keŋgât mân ot. Gâ Roma a kutâ patâgât mâteŋan takâ kinban. Oi itâ nâŋgâ. Anutuŋâ gâ galem otgigi gâ sot a waŋgâyân te, zo mân tâmbetagobi.’ ");
INSERT INTO kpf_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Zorat bukurâp, zen umziŋ âlip oik. Nâ Anutugât um zagât mân opman. Nâ itâ nâŋgan, ‘Den dâtnogap, zo bon upap.’ ");
INSERT INTO kpf_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Waŋgâŋâ hân ŋâin âi komŋâ âbâŋgubap.” ");
INSERT INTO kpf_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Adria saruyân laŋ gulip ândim tâindâ ma sirâm kiin kimembut oi ŋâtik tânâmŋan waŋgâ galem a ziŋâ hân gootŋan gen sâm nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Yatâ nâŋgâmŋâ tâk dâp pane saruyân giari kârepŋâ a kânok yatâ oip. Oi mâik ŋâi âim du pane giari kârepŋâ kiin bâtnâmbut yatâ oip. ");
INSERT INTO kpf_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Oi kât kwâkŋan zâibap sâm keŋgât op waŋgâ tipŋan kela patâ kimembut saam pane giari mirâ haŋsâbapkât mambât tarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Tapŋâ waŋgâ galem a zen keŋgât op waŋgâ birâm âinam bamin mem pane saruyân giari den sarâ itâ sâwe, “Nen waŋgâ sâŋgânŋan kela yâmbât saanamen.” ");
INSERT INTO kpf_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Yatâ utnam utne Pauloŋâ kâwali a sâtŋâ sot arâpŋâ itâ sâm dâzâŋgoip, “Waŋgâ galem a zen âine nen saruyân geim naŋgânat.” ");
INSERT INTO kpf_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Dâzâŋgoi kâwali a zen bamingât tâkŋâ mânâŋgâtne saruyân giari birâwe. ");
INSERT INTO kpf_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Mirâ haŋsâbapkât mambât tapŋâ Pauloŋâ a aksik nalem ninatkât itâ sâm dâtnâŋgoip, “Zen umziŋ keŋgât oi nalem mân nem ândine sirâm kiin kimembut âkap. ");
INSERT INTO kpf_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Gât ko nalem nimbigât sa mân kwâkâbi. Nalem nem ko kârâkŋan zâi ândibi. Sâkziŋ mân tâmbetagobi. Zen hâlâuyâk op ândibi.” ");
INSERT INTO kpf_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Yatâ sâi egindâ nalem ŋâi memŋâ Anutugâren sâiwap sâm namuŋ neip. ");
INSERT INTO kpf_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Nei ekŋâ umniŋ bâbâlaŋ oi nen aksik nalem niwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","A waŋgâyân tarâwen ko teŋgâniŋ 276 yatâ zorâŋ tarâwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nen nalem nem âkon opŋâ waŋgâ kâligen gâbâ nalem mem pâindâ saruyân giari waŋgâ bâbâlaŋ op kopgâip ");
INSERT INTO kpf_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Mirâ haŋsâi hân ŋâi ekŋâ kwagâwen. Waniŋ gien sâwen. Oi saru bikŋâ ŋâi kâtŋâ buŋ ekŋâ zorat sâtŋan zâinat sâm urâwen. ");
INSERT INTO kpf_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Galem a ziŋâ kelagât tâkŋâ mânâŋgâtne saruyân giari tâk olaŋâ pibâgât isen ŋâi saane zarip. ");
INSERT INTO kpf_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Waŋgâ âimŋâ hân murukŋan zâim waŋgâgât sâŋgânŋandâ hânân sum kâtigei saruŋâ waŋgâ tipŋan kom namuŋip. ");
INSERT INTO kpf_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Waŋgâ âbâŋgoi kâwali a ziŋâ tâk nâma a zen âibegât zâŋgonam sâwe. ");
INSERT INTO kpf_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Patâziŋandâ Paulogât op kwâkâziŋgip. Oi sâi nâmbutŋandâ saru lâbâŋgum âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ka nâmbutŋâ omboŋ sot nak sâmbaŋâ kwâkŋan âiwe. Zo yatâ opŋâ nen aksik saru sâtŋan takâm zâiwen. ");
INSERT INTO kpf_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nen hâlâuyâk sagân zâimŋâ tâunan zo kutŋâ Melite sâne nâŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Hân mâirâp ziŋâ buku otniŋgâm map pateŋ op zei kârâp sândum une sei nâŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pauloŋâ kârâp tâmbânŋoot zo mem pâi sei kârâp zorat umŋan gâbâ mulum kâtik kopgam Paulo sâlâpŋan zim kâtigem kirip. ");
INSERT INTO kpf_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Oi kamân mâirâp zen zo ekŋâ âragum sâwe, “A zi kâmbam a. Saruyân mân buŋ op kopgap, zorat hâuŋâ muyageŋâŋgap.” ");
INSERT INTO kpf_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pauloŋâ ko mulum zo kwititapkoi kârâbân geim Paulo mân tâmbetkoip. ");
INSERT INTO kpf_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Yatâ oi hân mâirâp zen bikŋâ lâmbatpap mo kek mumbap sâm mambât ek tarâwe. Narâk kârep ek tatne buŋ oi itâ nâŋgâwe, “A zi ko bem lopio.” ");
INSERT INTO kpf_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kamân ândiwen, zorat naŋgâmŋan a kutâziŋ tâip, kutŋâ Popilio. Zâkkât mirâ kamân zo zeip. Oi a zorâŋ on galem otniŋgi zâkkât mirin sirâm karâmbut ândiwen. ");
INSERT INTO kpf_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Zoren ândeindâ Popilio ibâŋâ mâsek op sâk kârâp taki umân bâba oip. Oi Pauloŋâ nâŋgâm mirin zâim bikŋâ kâukŋan pam ninâu sâm kubikŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Yatâ oi hân zorat mâirâp zen a ambân mâsekziŋoot zen siŋgi nâŋgâm ganetâ kubikziŋgâmâip. ");
INSERT INTO kpf_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Oi zorat hâuŋâ a zen umâlip op galem otniŋgâne âinam oindâ mâtâpkât kut ŋâi ŋâi betniŋan miwe. ");
INSERT INTO kpf_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Hân zoren ândeindâ kâin karâmbut âki waŋgâ ŋâin zâiwen. Waŋgâ zo Alesandiria kamânân gok. Sâŋgânŋan lopio booboo zagât sobine kirâwet. Nen ândiwen, zoren waŋgâ zoren tâi map pibâ narâk âki zâiwen. ");
INSERT INTO kpf_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Âim Siraku kamânân takâm sirâm karâmbut tarâwen. ");
INSERT INTO kpf_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Zo birâm haamgum Regioŋ kamânân takâwen. Sirâm ŋâin mirâ toren gâbâ pibâ ga kâbakŋeniŋgi ŋâtik sirâm zagât âimŋâ Puteoli kamânân takâwen. ");
INSERT INTO kpf_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Zoren takâm waŋgâyân gâbâ gem gam Yesugât kâmut muyageziŋgâm sirâm nâmburân zagât zen sot ândiwen. Oi zobâ Roma kamânân âiwen. ");
INSERT INTO kpf_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Yesugât kâmut Roma kamânân ândiwe, zen neŋgât siŋgi nâŋgâm Apio kamânân âine kândiaŋgâwen. Oi nâmbutŋâ mirâ karâmbut, zoren kândiaŋgâwen. Oi Pauloŋâ ziŋgitŋâ umâlep nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Roma kamânân takâm a sâtŋandâ sâi Paulo tâk namin mân parâwe. Kâwali a ŋâiŋâ Paulo diim âi mirin pam galem oip. A nâmbutŋâ ko tâk namin zâmbarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Zoren ândei sirâm karâmbut âki Pauloŋâ sâi Yuda a sâtŋâ zen gane itâ sâm dâzâŋgoip, “Bukurâpnâ, Nâ Yuda a bukurâpniŋâ kwerâziŋ mân sâwan. Sâkurâpniŋ zeŋgât den mân kowan. Oi zen laŋ Roma a zeŋgât bitziŋan nâbane Yerusalem kamânân tâk namin nâbarâwe. ");
INSERT INTO kpf_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Roma a ziŋâ topnâ sâmŋâ nobigât tosanâ kârum birâninam urâwe. ");
INSERT INTO kpf_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ka Yuda a zen mân birânibigât kâtigine Roma a kutâ patâŋâ dinnâ sâm kwâkâbapkât sâwan. Nâ Yuda a bukurâpnâ zeŋgât um kâlak mân nâŋgâwan. ");
INSERT INTO kpf_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Oi nâ zorat ziŋgitŋâ zen sot den utnatkât sa ge. Isirae a nen momŋâ zaatzaat den zo nâŋgâm ândimen. Den zorat tâkŋâ saanine ga ândian.” ");
INSERT INTO kpf_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Yatâ sâm dâzâŋgoi sâwe, “Ândiren Yuda hân topniŋan ândie, zen gâgât den ŋâi mân kulemgum niŋge. Zoren gâbâ a ŋâi mân gam sâm bâliŋ kwatgigi nâŋgâwen. ");
INSERT INTO kpf_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Zorat den mem ândiat, zo gikak sâna nâŋgânatkât sen. Oi mâtâp uŋakŋâ zorat itâ nâŋgâmen. Hân dâp a ambân, ziŋâ sâm bâliŋ kwâtziŋgâwe.” ");
INSERT INTO kpf_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Yatâ sâm narâk ŋâi parâwe. Zo mâte oi Yuda a aksik Paulogât mirin mindune Anutugât um topŋan ândiândiŋaŋgât den haŋgât topkwap dâzâŋgom tâi ŋâtiksâip. Oi Mosegât gurumin den sot Propete zeŋgât den kulemguwe, zo Yesugâren bonŋâ âsageip. Zorat den dâzâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Oi a nâmbutŋâ zen diŋâ nâŋgâwe. Oi nâmbutŋandâ diŋâ birâwe. ");
INSERT INTO kpf_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Oi den sâm kâsâpagone Pauloŋâ itâ sâm dâzâŋgoip. “Tirik Kaapumŋâ Propete Yesaia den dukui sâkurâpniŋ den itâ sâm dâzâŋgoip, ");
INSERT INTO kpf_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Gâ âi a kâmut zi itâ dâzâŋgonan, “Kindapziŋandâ den nâŋgânâŋgâŋ, zo nâŋgâbi. Ka umziŋandâ ko mân nâŋgam kwâtâtibi. Sinziŋandâ igikŋâ, zo ikpi. Ka zorat topŋâ zo mân ek kwâtâtibi. ");
INSERT INTO kpf_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","A ambân kâmut zen zi um kâtik. Kindapziŋ bâpsâsâŋâ. Sinziŋandâ mân ek kwâtâtibi. Umziŋandâ mân nâŋgâm kwâtâtibi. Oi umziŋ mân melâŋne ko nâ dap yatâ kubikziŋgâbat.” ’ ");
INSERT INTO kpf_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Zorat nâ dâzâŋgua nâŋgânek. Anutuŋâ kubikkubik mâtâp muyageip, zo a hân ŋâin gok zeŋgât siŋgi uap. Zen nâŋgâm âkŋâlibi.” ");
INSERT INTO kpf_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Yatâ sâm dâzâŋgoi Yuda zen ziiŋak den sâm mâsikâyaŋgâm âiwe. ");
INSERT INTO kpf_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Oi Pauloŋâ Roma kamânân mirâ ŋâi kwâlâm zoren kendon patâ zagât ândei a ziŋâ zâkkâren âim ândiwe. ");
INSERT INTO kpf_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Âinetâ Anutugât um topŋan ândiândigât den dâzâŋgom Kembu Yesu Kristo, zâkkât topŋâ keŋgât buŋ dâzâŋgom ândeip. Zo yatik. ");
INSERT INTO kpf_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paulo nâ, Yesu Kristoŋâ kore a gâsunim Aposolo sâm nim Anutugât siŋgi âlip den sa laŋ kârâbapkât gâsum sâlâpnogip. ");
INSERT INTO kpf_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Den siŋgi zo muyagibapkât Anutuŋâ sâm kâtigemŋâ mârumŋan Propete a sâm muyagemziŋgi Kembugât ekabân kulemguwe. ");
INSERT INTO kpf_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Kulemgune nanŋâ Yesugâren âi sugip. Nanŋâ Yesu, zâk a kutâ Dawidigât kiurâp zeŋgâren gâbâ muyageip. ");
INSERT INTO kpf_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Yesu zâk Anutugât nanŋâ op um salek sot hâlâlu oi Anutuŋâ nanŋaŋgât topŋâ imbaŋâŋoot itâ muyageip. Mumuŋan gâbâ mâŋgei zaarip. Mâŋgei zaatŋâ kembu patâniŋâ ândiap. ");
INSERT INTO kpf_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Yesu Kristo, zâk kembuniŋandâ tânnomŋâ aposolo nep sâm nigip. Oi hân dâp a siŋgi âlip dâzâŋgua nâŋgâm lum Kembu Yesugât kâmut upigât nâŋgâm sâip. ");
INSERT INTO kpf_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Oi a nâmbutŋâ zen ziiŋik buŋâ. Zen sot ârândâŋ Roma a ziŋ Yesu Kristogât arâp upigât diiziŋgip. Zorat nep zo zeŋgâren yatâ tuubatkât sâm nigip. Roma kamânân ândie, zen Anutugât siŋgi op ândibigât sot um târârak ândibigât gâsuziŋgip. ");
INSERT INTO kpf_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Anutu umŋandâ gâsuziŋgi ândie, zeŋgât ekap zi kulemguan. Ibâniŋ Anutu sot Kembu Yesu Kristo, zekâren gâbâ tânzâŋgozâŋgoŋ sot um lumbe, zo zeŋgâren zimbap. ");
INSERT INTO kpf_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Roma a zen Kembugâren nâŋgâm pâlâtâŋ kwâkŋaŋgâm ândime, zorat siŋgi hân dâp ari nâŋgâne âlip opmapkât zeŋgât op sâiwap sâman. Yesu Kristoŋâ tânzâŋgoipkât sâiwap sa Anutugâren zâimap. ");
INSERT INTO kpf_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nanŋaŋgât siŋgi âlip sâm umnandâ Anutu kore okŋaŋga topŋâ nâŋgâmap, zâkkât mâteŋan den zi sa nâŋgânek. Nâ ninâu sâman dâp zeŋgât op sâman. ");
INSERT INTO kpf_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","11","Nâ zen ziŋgitpatkât otnimap. Zo yatâ zei ândim gâwan. Narâk zi ko kut ŋâi ŋâiŋâ saanigi tâpman. Anutuŋâ nâŋgi dâp oi mâtâp muyagem nigi zeŋgâren gâbatkât dukuman. Nâ gamŋâ tânzâŋgua Kaapumŋâ imbaŋâ ŋâi ziŋgi kâtigem ândibigât sâman. ");
INSERT INTO kpf_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nâ itâ sâbâ. Zeŋgâren ga nâŋgâm pâlâtâŋgât bonŋâ tirâpagom tânagonat. ");
INSERT INTO kpf_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Oi bukurâpnâ, topnâ kârubegât itâ dâzâŋgobâ. Nâ a kâmut nâmbutŋâ zeŋgâren opman, zo yatik Roma zeŋgâren gamŋâ nep tuum bonŋâ muyagibatkât sâman. Oi gabâ sandâ kut ŋâi ŋâi nâmbutŋandâ saanigi tâpman. ");
INSERT INTO kpf_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nâŋâ saru a sot barâ a, a nâŋgânâŋgâziŋoot sot kwakmak ârândâŋ siŋgi âlip dâzâŋgobatkât sâm nigip. ");
INSERT INTO kpf_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Zorat Roma kamânân a zen siŋgi âlip dâzâŋgobatkât umnandâ bâbâlaŋ opmap. ");
INSERT INTO kpf_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nâ siŋgi âlipkât nâŋga aŋunŋoot mân opmap. Wangât, zo Anutugât imbaŋâŋoot, zorat. Siŋgi âlip zo nâŋgâm Kembugâren nâŋgâm pâlâtâŋ kwapi dâp tânzâŋgom bâliŋan gâbâ mâkâziŋgâbap. Yuda a sot hân ŋâin gok zen ârândâŋ. ");
INSERT INTO kpf_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Siŋgi âlibân Anutugât mâteŋan târârakŋâ utnatkât mâtâp ziap. Zâkŋâ nâŋgâm pâlâtâŋziŋoot zo mâtâp zoren diiziŋgâbap. Oi zorat Kembugât ekabân den kulem ŋâi itâ ziap, “Nâŋgâm pâlâtâŋ kwâkŋaŋgâm tosaziŋ buŋ urâwe zo, ziŋâ ândiândi mimbi.” ");
INSERT INTO kpf_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","A Kembu kândâtkom bâliŋ upme, zen bâliŋ utne zorâŋâ den bonŋaŋgât mâtâp zo dooŋgumap. Bâliŋ mâme a ziŋ yatâ upmegât Anutu kukŋaŋgât bonŋâ sumbemân gâbâ zeŋgâren muyagem zemap. ");
INSERT INTO kpf_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Anutuŋâ hâuŋâ ziŋgâmap, zorat topŋâ itâ. Anutugât topŋâ zo muyap zei nâŋgâme. Anutu zikŋak topŋâ muyagem ziŋgâmap. Hân muyageibân gâbâ a ziŋ Anutugât topŋâ itâ ek nâŋgâm gawe. Anutu zâk aŋâ mân igikŋâ. ");
INSERT INTO kpf_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Oi zâk imbaŋâŋoot kembu patâ op ândiap. Hân muyagem kut ŋâi ŋâi top top muyagem pâip, zorâŋ topŋâ muyagei âlip ek nâŋgâme. Zorat a zen Anutu kândâtkomŋâ bâliŋ utne hâuŋâ ziŋgi ko dap op den hâuŋâ sâbi? ");
INSERT INTO kpf_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","A zen Anutu ândiap nâŋgâm, mân ândiap tobat oi hurat mân kwâkŋaŋgâwe. Oi mân sâm âlip kwâkŋaŋgâwe. Oi zen nâŋgânâŋgâziŋan bâliŋâ top top muyagem um kâtik utne ŋâtâtikŋâ kâpizâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Oi a ziŋ nen nâŋgânâŋgâniŋoot ândien sâweŋâ kwakmak op ândiwe. ");
INSERT INTO kpf_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Yatâ otziŋgi zen Anutu ândiândiŋ kâtik, âsakŋâ mariŋâ, zâk mân hurat kwâkŋaŋgâm a sot nii, zuu, mulum, kut ŋâi ŋâi buŋ orotŋâ zorat lopio sobem hurat kwatziŋgâwe. Zen yatâ urâwe. Oi narâk ziren zo yatik op ândie. ");
INSERT INTO kpf_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","A zen yatâ utne Anutuŋâ ziŋgit birâziŋgi umŋâ sâkkât âkŋâle top top nâŋgâm bâliŋâ op um sâkziŋ mem bâliŋ kwap piuriyâunzabân bagiwe. ");
INSERT INTO kpf_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Zen Anutugât topŋâ nâŋgâm kândâtokom sarâ mâte okŋaŋgâwe. Oi mariziŋâ birâm kut ŋâi ŋâi muyageip, zo hurat kwâkŋaŋgâm kore okŋaŋgâwe. Nen ko itâ nâŋgen. Kut ŋâi ŋâi muyageziŋgip zorat Anutu, zâk sâm âlip kwâkŋaŋgâm ândeindâ dâp upap. Perâkŋak. ");
INSERT INTO kpf_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","A zen Anutu kândâtkuwegât birâziŋgi âkŋâle bâliŋâ muyageziŋgip. Oi ambân zen Anutuŋâ ap ambin ândiândi mâtâp sâip zo birâm ambân torenŋâ ândiândi bâliŋan bagiwe. ");
INSERT INTO kpf_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Oi a zen yatigâk ap ambin ândiândiŋ birâmŋâ umziŋan âkŋâle bâliŋaŋgât kârâpŋâ sei a torenŋâ sot bâliŋ top top muyagiwe. Oi bâliŋâziŋaŋgât hâuŋâ um sâkziŋ tâmbetagowe. ");
INSERT INTO kpf_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Zen Anutugât topŋâ nâŋgâm mân hurat kwâkŋaŋgânam utne zâkŋâ birâziŋgi umziŋ gulip oip. ");
INSERT INTO kpf_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","30","Oi kut ŋâi ŋâi bâliŋâ top topŋâ doŋbep urâwe. Bâliŋâ sot laŋ orotŋâ, ziiŋâ umziŋan siksâuk oi sikumgât âkŋâle, kâmbam, kâsa, sarâ, um kâlak, zo yatâ op ândiwe. A umân pâpan, sarân sâsâ, Anutu kâsa okŋaŋgâme, zâizâiŋ, sâk mâme, bâliŋaŋgât mâtâp muyagime. Ibâ mam zeŋgât den kwâkâme. ");
INSERT INTO kpf_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Um nâŋgânâŋgâziŋ buŋ ândime. Um lâklâk buŋ ândime. A lumbeŋâ buŋâ, buku orot buŋâ ândime. ");
INSERT INTO kpf_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Kut ŋâi ŋâi yatâ opŋâ tâmbetagobi. Anutugât den yatâ ziap, zo nâŋgâm tâtâlim laŋ upme. Oi zorik buŋâ. A nâmbutŋâ utnetâ tânzâŋgome. Zen yatâ urâwe. Oi narâk ziren yatik op ândie. ");
INSERT INTO kpf_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Zorat a, gâ dap op topkâ sapsuban? A nâmbutŋandâ tosa muyagine hâuŋaŋgât den sâm gikâ sâm muyagemat. A nâŋgâm bâliŋ kwatziŋgâmat, zo yatigâk gâ opmat. ");
INSERT INTO kpf_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Oi Anutuŋâ a yatâ upme, zen hâuŋâ ziŋgi dâp uap. Zo yatâ nâŋgâmen. ");
INSERT INTO kpf_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","A, gâ nâmbutŋâ zeŋgât tosa sâm muyagem yatik opmat. Gâ dap nâŋgat? Nâ Anutuŋâ hâuŋâ mân nibap, yatâ sâm opmat? ");
INSERT INTO kpf_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Kembuŋâ lumbeŋâ patâ otgimŋâ hâuŋaŋgât den kek mân sâi gâ wangât zorat nâŋgâna yenŋâ opmap. Gâ umgâ melâŋbangât Anutuŋâ lumbeŋâ otgimap, zo âkon opmat? ");
INSERT INTO kpf_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Gâ umgâ kâtikŋâ. Umgâ mân melâŋna tosagâ kârâp yatâ kwâkŋan kwâkŋan pam zari kârâp simbap narâkŋan, narâk patin, Anutuŋâ sâi simbap. Narâk zoren Anutu kukŋaŋgât bonŋâ âsagegibap. ");
INSERT INTO kpf_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Anutuŋâ a orot mâmeniŋaŋgât dâp hâuŋâ niŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","A nâmbutŋâ kut ŋâi ŋâi âlipŋâ tuume, zen sumbemân neule âsakŋâ sot ândiândi kâtik muyaginam kâtigime. Zen hurat kwatziŋgâm ândiândi kâtik ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","A nâmbutŋâ zinŋâ op, zâizâiŋ opŋâ den bonŋâ kwâkâm kut ŋâi bâliŋâ mem ândime, zeŋgâren Anutu kukŋaŋgât bonŋâ muyageziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Bâliŋ mâme a Yuda a sot hân ŋâin gok, zen aksik sâknam yâmbât muyageziŋgâbap. Yuda a kândom muyageziŋgâbap. Bet ko hân ŋâin gokŋâ muyageziŋgâbap. Wangât, Yuda zen Kembugât den kândom nâŋgâwe, zorat. Hân ŋâin gok zen bet nâŋgâwe. ");
INSERT INTO kpf_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Târârak ândibi, zen aksik Yuda a sot hân ŋâin gok zen neule âsakŋâ sot lumbeŋâ muyageziŋgâbap. Yuda a zen kândom. Hân ŋâin gok zen bet. Yuda a sot hân ŋâin gok zen âlipŋâ sot bâliŋâ utne hâuŋâ dâbâk otziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kembuŋâ hâtubâtu mân otniŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","A Mosegât gurumin den mân nâŋgâm bâliŋ upme, zen aksik gurumin den mân nâŋgâm tâmbetagobi. A gurumin den nâŋgâm ândim bâliŋ upme, zen aksik Anutuŋâ gurumin dengât dâp hâuŋaŋgât den sâbap. ");
INSERT INTO kpf_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","A gurumin den kindapŋâ yen nâŋgâme, zen Anutuŋâ ziŋgiri târârak mân upme. Ka a nâŋgâmŋâ lum kwâtâtime, zeŋgât târârakŋâ sâm ziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Hân ŋâin gokŋâ Mosegât gurumin den mân nâŋgâwe, zen umziŋaŋgât gurumin den lum Mosegât gurumin den mân nâŋgâweŋâ gurumin denziŋoot upme. ");
INSERT INTO kpf_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Yatâ utnetâ gurumin den umziŋan pâip, zorat top muyagemap. Gurumin den umziŋan pâip, zorâŋâ um nâŋgânâŋgâziŋâ purikgurik op tosaziŋaŋgât den sâm kwâkâziŋgâmap mo lumbeŋâ den âlip sâmap. ");
INSERT INTO kpf_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Zo narâk patâgât siŋgi yatâ opmap. Narâk zoren Anutuŋâ sâi Yesu Kristoŋâ umniŋan kut ŋâi ŋâi ziap, zorat topŋâ sâm muyagibap. Nâ siŋgi âlipkât den sâm muyagem yatik sâman. Oi Yesu Kristo, zâk sâman dâp yâtik topziŋ sâm muyagibap. ");
INSERT INTO kpf_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Gâ gikaŋgât nâ Yuda a sâm Mosegât a op ândina gurumin denŋâ koremgâ oi pam zemat. Oi itâ sâm sâk mâme opmat, “Nâ Anutugât târotâroyân ândian. Oi Anutugât den nâŋgâman. ");
INSERT INTO kpf_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Oi gurumin den kwâkâm niwe, zo nâŋgâm kwâtâtiman.” Gikaŋgât yatâ nâŋgâm zâizâiŋ opmat. Zi upan, zo mân upan, zo nâŋgâm sâlâpkumat. ");
INSERT INTO kpf_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Oi gikaŋgât itâ sâmat, “Nâ sen bâp âlipŋaŋgât mâtâbân diiziŋgâbat. Oi ŋâtâtigân ândie, zen âlip âsakŋâ ziŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Oi kwakmak a zo âlip kubikziŋgâbat. Oi katep umâlep den sâm kwâkâm ziŋgâbat. Wangât, nâ den kâtik sot den bonŋâ zorat topŋâ nâŋgâman, zorat.” ");
INSERT INTO kpf_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Gâ gikaŋgât yatâ nâŋgâm ândimatkât den ŋâi mâsikâgibâ. Gâ a nâmbutŋâ kwâkâm ziŋgâmatŋâ gikâ umgâ mân kubikmat, zo wangât yatâ opmat? Gâ a nâmbutŋâ kâmbu mân upi sâm dâzâŋgomŋâ gikâ kâmbu opmat. Kâmbu zo wangât opmat? ");
INSERT INTO kpf_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ap ambin mân birâyaŋgâbabot dâzâŋgom gikâ ambingâ yatik birâmat, zo ka. Gâ Yuda a opŋâ itâ nâŋgâmat, “Nen lopio gootŋan arindâ Anutuŋâ niŋgiri mân dâp upap.” Yatâ nâŋgâm a nâmbut zen lopio mân hurat kwapigât sâm dâzâŋgom gikâ lopio namin gâbâ kut ŋâi ŋâi kâmbu memat, zo ka. ");
INSERT INTO kpf_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Gâ Anutugât gurumin den nâŋgâm zâizâiŋ opmatŋâ den kâtik kona a nâmbutŋâ ziŋâ gekŋâ Anutu sâm bâliŋ kwapme, zo ka. ");
INSERT INTO kpf_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Zorat ko Kembugât ekabân zeŋgât den ŋâi itâ kulemguwe. “Zen bâliŋ utne hân ŋâin gokŋâ zen ziŋgitŋâ yatik Anutu sâm bâliŋ kwâkŋaŋgâme.” ");
INSERT INTO kpf_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Gâ sâkkan Anutugât den kâtik lum kwabâ kwatgiwe oi ko den kâtik zo luna bon upap. Den kâtik zo kona kwabâ kwatgiwe, zo yenŋâ uap. ");
INSERT INTO kpf_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Oi zorat torenŋâ ziap. A hân ŋâin gok ŋâi kwabâ mân kwâkŋaŋgâwe, zâk den kâtikŋâ lugi kwabâ kwâkŋaŋgâwe, zo yatâ âlip upap. ");
INSERT INTO kpf_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Oi kwabâ mân kwâkŋaŋgâne ândimŋâ den kâtikkât nep tuubapŋâ nepŋâ zâkkât topŋâ sapsubap. Oi Yuda a den kâtikŋâ nâŋgâmŋâ mân lume, zeŋgât topziŋ yatik sapsubap. ");
INSERT INTO kpf_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ŋâi zâk kwabâ kwâkŋaŋgâne gurumin den mân lumap, zâkkât dap dap sânat? Zâk Yuda a bonŋâ? Buŋâ. ");
INSERT INTO kpf_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Sâgân den kâtikkât tobat mem ândiândiŋ, zo bonŋâ buŋâ. A ŋâi umŋandâ bâliŋâ birâm Kembugât siŋgi ândimap, zâkkât Yuda a bonŋâ sânat. Umân Kaapumŋâ nep tuumap, zo bonŋâ. A yatâ zorat a ziŋâ buŋâ, Anutuŋâ nâŋgi âlip oi sâm âlip kwâkŋaŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Yuda a nen hân ŋâin gok zen sot dâbâk upmen mo? Kwabâ kwatniŋgâwe, zo yenŋâ? ");
INSERT INTO kpf_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Yatâ buŋâ. Yuda a, nen Anutuŋâ diŋâ niŋgip. Nen Anutuŋâ siŋgi den top top dâtnâŋgoi zorat mariŋ urâwen. ");
INSERT INTO kpf_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Oi dap yatâ? Yuda a nâmbutŋâ zen Anutugât den nâŋgâm kândâtkume, zorat itâ sânat? “Lolotziŋandâ Anutuŋâ sâi kâtigemap, zo koi gibap?” ");
INSERT INTO kpf_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Buŋ kâtikŋâ. Anutu zâk sâi kâtigemap. Ka a nen dinniŋâ sarâ sot bon buŋ sâmen. Neŋgât yatâ sâsâŋ. Zorat Kembugât ekabân den kulem ŋâi itâ ziap, “Kembu, gâ sâm kubikna a ziŋ nâŋgâne âlip upap. Gâ sâm kwâkâna a zen diŋgâ mân kwâkâbi.” ");
INSERT INTO kpf_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Bâliŋ oindâ Anutuŋâ târârakŋaŋgât topŋâ sâm muyagemapkât dap sânat? Itâ sânat? “Top yatâ ziapkât Anutuŋâ zobâ hâuŋâ niŋgi mân dâp upap.” Yatâ buŋâ. ");
INSERT INTO kpf_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Zo agât den. Anutuŋâ târârak mariŋâ ândiap, zorat Anutuŋâ a bâliŋâniŋaŋgât hâuŋâ niŋgi dâp upap. ");
INSERT INTO kpf_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Oi den toren ko den sarânandâ Anutugât den bonŋâ tângoi kutsiŋgiŋaŋgât wangât nâ bâliŋ mâme a sâm hâuŋâ nibap?” ");
INSERT INTO kpf_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Oi wangât itâ mân sâmen? “Nen bâliŋ oindâ Anutuŋâ bonŋâ muyagibap.” A nâmbutŋâ ziŋ neŋgât yatâ sâme. Sâm sâtniŋan sâme. Den bâliŋâ yatâ zo sâm mâtâp zo lâŋme zo, zen ko hâuŋâ ziŋgi dâp upap. ");
INSERT INTO kpf_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Yuda a nen a nâmbutŋâ walâziŋgâm tobat ŋâi ândien mo? Yatâ buŋâ. Yuda a sot hân ŋâin gok nen aksik bâliŋaŋgât kore upmen. ");
INSERT INTO kpf_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Zorat Kembugât ekabân den kulem ŋâi itâ ziap, “A zeŋgâren gâbâ ŋâi târârakŋâ mân ândiap. ");
INSERT INTO kpf_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ŋâiŋâ itâ mân sâmap, ‘Nâ Anutugât topŋâ nâŋgâbâ.’ ");
INSERT INTO kpf_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","A zen pisuk Kembugât mâtâp birâm bâliŋan âiwe. Zeŋgâren gâbâ ŋâiŋâ âlip mân opmap. ");
INSERT INTO kpf_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Gânduziŋan gâbâ kuk kalâm âsagem takâmap. Nâmbâlamziŋâ puriksâi sarâ den kopgâmap. Lâuziŋâ mulum kâtikŋâ yatâ. ");
INSERT INTO kpf_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Lâuziŋan den bâliŋâ sot um kâlak den piksâm ziap. ");
INSERT INTO kpf_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Kâmbamgât bâbâlaŋ op âime. ");
INSERT INTO kpf_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","A tâmbetzâŋgom âim tâmbetagome. ");
INSERT INTO kpf_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Lumbeŋaŋgât mâtâp zorat kwakme. ");
INSERT INTO kpf_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Zen Anutugât keŋgât mân op ândime.” ");
INSERT INTO kpf_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","20","Den zo gurumin den ekabân ziap. Oi nen itâ nâŋgâmen. Gurumin den zo a ambân aksik neŋgât op sâi umŋan ândien. Nen dap op gurumin den lum ândim Anutu mâteŋan târârak utnat? Gurumin den, zorâŋ tosaniŋ sâm muyagemap. Zo a aksik neŋgât topniŋ sâm muyagei dap op hâuŋâ sânat? A aksik neŋgât tosaniŋ Anutugâren ziap. ");
INSERT INTO kpf_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Mosegât gurumin denŋâ mân tânnâŋgomap. Ka narâk ziren gurumin den yen zei Anutugât mâteŋan tosa buŋ utnatkât Anutuŋâ mâtâp muyageip. Mâtâp zo gurumin den sot Propete zeŋgât ekabân siŋgiŋâ kânŋan sâm kulemguwe. ");
INSERT INTO kpf_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Yesu Kristo nâŋgâm pâlâtâŋ kwâkŋaŋgindâ tosaniŋ buŋ oi ândiândiŋâ mâtâp zo neŋgât siŋgi uap. Zo a topŋâ topŋâ neŋgât matâp kânok. Mâtâp ŋâi mân ziap. ");
INSERT INTO kpf_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Nen aksik patâ bâliŋ urâwengât Anutuŋâ niŋgiri mân dâp oip. Anutugât âsakŋâ neuleŋan takânatkât mân uen. ");
INSERT INTO kpf_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ka Yesu Kristo zâk sâŋgânniŋ mem suupniŋ meipkât Anutuŋâ sâŋgân buŋ tânnâŋgom hâlâlu minniŋgip. ");
INSERT INTO kpf_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Zâkŋâ nanŋâ sâŋgongoi gem gâi a ambân mâteziŋan kune moi gilâmŋandâ bâliŋâniŋ saŋgorip. Oi zen zâkkâren nâŋgâm pâlâtâŋ kwâkŋaŋgâm ândibiŋâ tosaziŋ buŋ ândibi. Bâliŋâ op gawe, zorat tosaziŋ Anutuŋâ umâlipŋaŋgât pâi zeipkât Yesu mumuŋan bagei Anutugât mâteŋan tosaniŋ buŋ orotŋaŋgât mâtâp muyageip. ");
INSERT INTO kpf_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Yesu nâŋgâm pâlâtâŋ kwâkŋaŋgâme, zen tosaziŋ buŋ upme. Zorat topŋâ narâk ziren muyagibapkât Anutuŋâ yatâ oip. Anutu, zâk hâlâlu mariŋâ ândiap. Oi zorat topŋâ zo muyap pâi ziap. ");
INSERT INTO kpf_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Oi âlip zâizâiŋ utnat? Buŋâ. Zâizâiŋâ zo kândaŋip. Wangât kândaŋgip? Nen orot mâme âlip op ândim tosa buŋ uen? Buŋ kâtikŋâ. Nen yen nâŋgâm pâlâtâŋ kwâkŋaŋgindâ tosâniŋ buŋ kwatniŋgip, zorat. ");
INSERT INTO kpf_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Nen itâ nâŋgen. A nen gurumin den luluniŋaŋgât buŋâ. Nâŋgâm pâlâtâŋgât op tosaniŋ buŋ upmen. ");
INSERT INTO kpf_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Zen dap nâŋge? Anutu zâk Yuda a neŋgât Anutuyâk? Buŋâ, Zâk hânŋâ hânŋâ neŋgât Anutu. ");
INSERT INTO kpf_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Zâk Anutuniŋ kânok ândiapkât Yuda a sot hân ŋâin gokŋâ ârândâŋ nâŋgâm pâlâtâŋgât op tosaniŋ buŋ minniŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Oi yatâ sâm nâŋgâm pâlâtâŋgât op gurumin den kândaŋmen? Buŋâ. Gurumin den zo tângumen. ");
INSERT INTO kpf_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Gurumin den zorat nâŋgâm sâkunniŋ Abaram, zâkkât dap sânat? ");
INSERT INTO kpf_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Zikŋâ orot mâmeŋaŋgât op tosaŋâ buŋ oip? Zo yatâ oip sâi Anutugât mâteŋan sâkŋâ mem zâi pâmbap. ");
INSERT INTO kpf_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ka Kembugât den ŋâi itâ ziap, “Abaramŋâ Anutu nâŋgâm pâlâtâŋ kwâkŋaŋgip, zorat opŋâ Anutuŋâ zâkkât nâŋgi tosaŋâ buŋ oip.” ");
INSERT INTO kpf_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Zorat itâ sa nâŋgânek. Ŋâi zâk nep tuum sâŋgân mei, zorâŋ yen pindâpindâŋ zo yatâ buŋâ. Nepkât sâŋgân uap. ");
INSERT INTO kpf_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Oi ŋâi ko ândiândi târârakŋaŋgât nep mân tuumŋâ bâliŋ mâme zeŋgât tosa birâmap, Anutu, zâkkâren nâŋgâm pâlâtâŋ kwâpap zo ko Anutuŋâ nâŋgâm pâlâtâŋaŋgât op nâŋgi tosaŋâ buŋ upap. ");
INSERT INTO kpf_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Marumŋan a kutâ Dawidi, zâk yatik Anutuŋâ a ŋâi orot mâme âlip nep mân tuugi tosaŋâ birâbap, zâk sâm âlip kwâkŋaŋgâm itâ kulemgoip, ");
INSERT INTO kpf_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Kembuŋâ tosaziŋ birip sot bâliŋâziŋ gulipkoip, zen sâtâre upi. ");
INSERT INTO kpf_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","A ŋâi zâk Kembuŋâ zâkkât nâŋgi tosaŋâ buŋ opmap, zâk sâtâreŋoot upap.” ");
INSERT INTO kpf_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Sâtâre den zi kwabâ kwatniŋgâwe, Yuda a neŋgârâk? Mo a hân ŋâin ŋâin gokŋâ zeŋgât sot ârândâŋ uap? Kembugât ekabân Abaramgât den ŋâi ziap. Zo sâlâpkum nâŋgâmen. Zâk Anutuŋâ nâŋgâm pâlâtâŋŋaŋgât op tosaŋâ birip. ");
INSERT INTO kpf_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Narâk ikâ zoren tosaŋâ buŋ miŋaŋgip? Kwabâ kwatne ândeibân mo yen ândeibân tosaŋâ buŋ miŋaŋgip? Zo yen ândeip, narâk zoren tosaŋâ buŋ miŋaŋgip. ");
INSERT INTO kpf_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Zâk kwabâ mân kwâkŋaŋgâne ândim Anutu nâŋgâm pâlâtâŋ kwâkŋaŋgi tosaŋâ birip. Nâŋgâm pâlâtâŋgât undip zo bet sâkŋan pindip. Abaram zâk yatâ opŋâ kwabâ mân kwâtziŋgâne ândim Anutu nâŋgâm pâlâtâŋ kwâkŋaŋgâne tosaziŋ buŋ oip, zeŋgât kâukŋâziŋ op ândeip. ");
INSERT INTO kpf_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Oi kwabâ kwâtniŋgâne ândim nâŋgâm pâlâtâŋ kwâkŋaŋgâm ândiwen, neŋgât kâukŋâ oip. Zâk nâŋgâm pâlâtâŋgât mâtâp lâŋip. Mâtâp zorik kiunŋâ kiunŋâ Abaram zâk kâukniŋâ sâindâ dâp upap. ");
INSERT INTO kpf_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Anutuŋâ Abaram sot kiurâpŋâ hân patâ siŋgi kwâtziŋgip, zo gurumin den luluŋaŋgât buŋâ. Nâŋgâm pâlâtâŋaŋgât op tosaŋâ birâm yatik oip. ");
INSERT INTO kpf_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Oi siŋgi kwatziŋgip, zo gurumin den lume, zeŋgât oi sâi nâŋgâm pâlâtâŋgât mâtâp sot Anutuŋâ Abaram den dukuip, zo bon buŋ opap. ");
INSERT INTO kpf_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Gurumin den buŋâ oi sâi ko tosagât hâuŋaŋgât den mân muyagebap. Gurumin denŋâ tosagât hâuŋaŋgât den muyagemap. Zorat a gurumin den luluŋaŋgât mâtâbân lâŋ ândimŋâ tosaziŋ buŋ mân upi. Buŋâ. Kembu kukŋaŋgât bonŋâ zeŋgâren muyagibap. ");
INSERT INTO kpf_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Anutuŋâ sâm kâtigem kut ŋâi ŋâi siŋgi kwatniŋgip, zo nâŋgâm pâlâtâŋniŋaŋgât op muyagibap. Zo bon buŋ mân upap. Zinziŋ kâtik zem zâimâmbap. Wangât, zo umâlipŋaŋgât op tânzâŋgozâŋgoŋ, zo pindi Abaramgât kiurâp neŋgâren bon oip. Gurumin den lume, zenâk buŋâ. Abaramŋâ nâŋgâm pâlâtâŋgât mâtâp lâŋmen, nen aksik Abaramŋâ Anutugât mâteŋan sâkunniŋâ uap. ");
INSERT INTO kpf_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Anutuŋâ Abaram den ŋâi dukumŋâ sâm kâtigeip. Den zo Kembugât ekabân kulemguwe. Zo itâ ziap, “Nâŋâ gâ a kâmutŋâ kâmutŋâ zeŋgât ibâziŋ upangât sâm giwan.” Abaram zâk den zo nâŋgâm Anutu nâŋgâm pâlâtâŋ kwâkŋaŋgâm itâ nâŋgip, “Anutu zâk mumuŋan gâbâ mâŋginiŋgâbâ sâm mâŋginiŋgâbap. Oi kut ŋâi ŋâi mân ziap, zo sâi muyagibap.” Abaram zâk yatâ nâŋgip. ");
INSERT INTO kpf_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abaram zâk a kâmut doŋbep zeŋgât ibâ upap. Den zo nâŋgâm itâ mân sâip, “Nâ sombâ op kiunnâ buŋ ândiangât dap yatâ kiurâpnâ âsagibi?” Buŋâ. Yatâ mân sâip. Kembugât den zorat bonŋâ âsagibapkât mambât ândeip. Den itâ sâm dukuipkât, “Kiurâpkâ doŋbep patâ yatâ muyagibi.” ");
INSERT INTO kpf_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Oi zâk kendonŋâ 1 handeret oip. Sâkŋâ patkip oi Sera zâk kâpin ândim sâkŋâ âron oip, zo ekŋâ nâŋgâm pâlâtâŋŋaŋgât um zagât mân oip. ");
INSERT INTO kpf_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Anutuŋâ siŋgi den dukuip, zo nâŋgi mân bon buŋ oip. Nâŋgâm pâlâtâŋgât kâtigem Anutugât nâŋgi zari sâtâre okŋaŋgip. Zâk itâ nâŋgâm ândeip. ");
INSERT INTO kpf_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","“Anutuŋâ kut ŋâi muyagibapkât sâip, zorat bonŋâ âlip muyagibap.” ");
INSERT INTO kpf_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Abaram zâk nâŋgâm pâlâtâŋ zemŋaŋgipkât Anutuŋâ nâŋgi tosaŋâ buŋ oip. ");
INSERT INTO kpf_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Anutuŋâ nâŋgi tosaŋâ buŋ oip, den zo Abaram zikŋaŋgârâk mân kulemgoip. Neŋgât ârândâŋ kulemgoip. ");
INSERT INTO kpf_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Kembuniŋâ Yesu mumuŋan gâbâ mâŋgeip, Anutu, zâk nâŋgâm pâlâtâŋ kwâkŋaŋgindâ neŋgât yatik nâŋgi tosaniŋ buŋ utnat. ");
INSERT INTO kpf_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Anutuŋâ sâi Yesu kune tosaniŋaŋgât op moip. Oi tosaniŋ buŋ upapkât mumuŋan gâbâ zaarip. ");
INSERT INTO kpf_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Yesu Kristoŋâ suupniŋ mem moipkât nen nâŋgâm pâlâtâŋgât op tosaniŋ buŋ urâwengât Yesu Kristogâren pâlâtâŋ op Anutu sot lumbeŋ op ândimen. ");
INSERT INTO kpf_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Yesuŋak mâtâp mem niŋgipkât Anutuŋâ tânnâŋgoi ândien. Oi gâtâm zâk sot ândeindâ Anutugât imbaŋaŋgât âsakŋâ âsagei mem ândinat, zorat nâŋgâm ândim sâtâre upmen. ");
INSERT INTO kpf_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Oi zorik buŋâ. Sâknam ândiândiniŋaŋgât sâtâre upmen. Oi itâ nâŋgâmen. Sâknamân ândimŋâ umniŋ mân loribap. ");
INSERT INTO kpf_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Oi yatâ ândeindâ Anutuŋâ niŋgiri âlip upap. Nen nâŋgâm pâlâtâŋ sot ândim Anutuŋâ kut ŋâi ŋâi neŋgât siŋgi sâip, zorat nâŋgâm um bâbâlaŋ op mambât ândinat. ");
INSERT INTO kpf_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Nen zo yatâ ândimŋâ bonŋâ minat. Anutuŋâ Tirik Kaapumŋâ umniŋan pâip. Kaapum zâk den itâ sâm muyageniŋgâmap, “Anutugât umŋandâ doŋbep gâsuniŋgâm tânnâŋgomap.” ");
INSERT INTO kpf_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Mârum nen imbaŋâ buŋ ândiwengât târârak mân ândiwen. Oi narâkŋâ mâte oi Kristo zâk bâliŋ mâme a neŋgât op moip. ");
INSERT INTO kpf_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Nen itâ nâŋgâmen. A târârak ŋâigât hâuŋâ op mumuŋâ, zo a neŋgâren mân taap. A âlipŋâ ŋâigât op mumuŋâ, zo ko muyagibap mo dap? ");
INSERT INTO kpf_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Nen bâliŋ op ândeindâ Anutu nen umŋandâ doŋbep gâsuniŋgip. Anutuŋâ umâlipŋaŋgât opŋâ Kristo sâŋgongoi gem hâuniŋâ moip. ");
INSERT INTO kpf_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Zâk neŋgât op moipkât itâ nâŋgâm kwâtâtimen, “Tosaniŋ buŋ urâwen. Anutu kukŋaŋgât bonŋâ muyamuyagiŋ narâkŋan Anutuŋâ tosaniŋaŋgât hâuŋâ mân niŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","A nen mârum Anutu kâsa okŋaŋgâm ândiwen. Oi nârâk zoren nanŋandâ neŋgât op moip. Oi zorik buŋâ. Neŋgât op moipkât diiniŋgi nen Anutu sot buku urâwen. Oi zorik buŋâ. Zâkŋâ walâm otniŋgâbap. Zâk sot buku op ândeindâ nanŋandâ ândim bâliŋan bagibemgât tânnâŋgobap. ");
INSERT INTO kpf_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Oi zorik buŋâ. Kembuniŋâ Yesu Kristo, zâkŋâ lumbeŋâ muyagem Anutu sot târokwatniŋgi buku buku ândien. Zorat nen Anutu sâm âlip kwâkŋaŋgâmen. ");
INSERT INTO kpf_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Zorat itâ nâŋgânâ. A kânok Adam, zâkkât opŋâ bâliŋâ hânân muyageip. Oi bâliŋaŋgât op mumuŋâ muyageip. Oi a aksik zeŋgâren zarip. Wangât, a aksik zen bâliŋ urâwe, zorat zeŋgâren arip. ");
INSERT INTO kpf_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Mârum Mosegât gurumin den mân muyagei bâliŋandâ kândom muyagem zeip. Oi narâk zoren Mosegât gurumin den mân muyageipkât bâliŋâ yen zem gâip. Anutuŋâ tosaziŋ mân sâlâpkoip. ");
INSERT INTO kpf_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ka bet gurumin denŋâ muyagei a ziŋ tosaziŋ ek nâŋgâwe. Adam zâk bâliŋ oi mumuŋandâ topkwap a ândim gawe, zen a kutâ otziŋgâm ândim gâi Mose muyageip. Adamgât tobat mân urâwe, zeŋgâren laŋ ârip. Adam zâk mumuŋaŋgât kâukŋâ oipŋâ bet ŋâi ândiândigât kâukŋâ muyagibapkât sâsâŋ, Yesu, zâkkât dâp oip. Ka topzik ŋâi ŋâi. ");
INSERT INTO kpf_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Anutu umâlipŋaŋgât tânzâŋgozâŋgoŋ, zorâŋ den ku zorat dâp buŋâ. Zorâŋ wâlap. A aksik patâŋâ Adamgât den kuŋaŋgât opŋâ mom naŋgâwe. Oi Anutugât tânzâŋgozâŋgoŋ, zo a kânok Yesu Kristogât tânzâŋgozâŋgoŋaŋgât op Adamgât den ku walâmŋâ a doŋbep tânnâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Kembugâren gâbâ tânzâŋgozâŋgoŋ sot toren Adam den kuŋaŋgât bonŋâ, zet topzik ŋâi ŋâi. A kânokkât tosaŋâ simgât sâm kwâkâkwâkâŋ muyageip. Ka Kembugâren gâbâ tânzâŋgozâŋgoŋandâ tosa doŋbep birâm tosaniŋ buŋ muyageip. ");
INSERT INTO kpf_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","A kânok Adam den kuŋaŋgât op mumuŋâ muyagemŋâ imbaŋâ mem a kutâ otziŋgip. Ka Kembugâren gâbâ tânzâŋgozâŋgoŋandâ walâm tâtalek oi a doŋbep nen tosaniŋ buŋ orot, zo mem umniŋan mem gimenŋâ a kânok Yesu Kristo, zâkkât opŋâ ândiândiyân a kutâ op ândinat. ");
INSERT INTO kpf_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Zorat itâ. Mârum a kânok Adam, zâkŋâ bâliŋ oi a aksik simgât siŋgi urâwen. Oi bet zo yatik a kânokŋâ târârak ândei Yesugât siŋgi a nen doŋbep tosaniŋ buŋ oi ândiândi muyagiwen. ");
INSERT INTO kpf_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Akânok Adam, zâkŋâ bâliŋ oi a doŋbep niŋâ bâliŋ mâme a ambân urâwen. Zo yatik a kânok Kristo, zâk sât lulu ândeipkât a doŋbep nen Anutugât mâteŋan târârak op kinat. ");
INSERT INTO kpf_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Adamŋâ bâliŋ oi bâliŋâ hânân muyageip. Bâliŋâ gwâlânteŋsâbapkât sot bâliŋaŋgât topŋâ muyagibapkât Mosegât gurumin den muyageip. Oi bâliŋâ muyagem zari Anutugât siŋgi tânzâŋgozâŋgoŋandâ walâm zarip. ");
INSERT INTO kpf_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Den san, zo itâ. Bâliŋandâ mumuŋâ muyageip. Muyagemŋâ a ambân a kutâ otziŋgâm ândim gâip, zo yatik tânzâŋgozâŋgoŋandâ a kutâ op tosa buŋ minniŋgâm ândiândi kâtigân nâmbanbap. Kembuniŋâ Yesu Kristo neŋgât op moipkât yatâ muyagibap. ");
INSERT INTO kpf_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Bâliŋâ hânân muyagei Kembugâren gâbâ tânzâŋgozâŋgoŋandâ walâm tâtalek oip, zorat dap sânat? “Anutugât tânzâŋgozâŋgoŋandâ laŋ kârâbapkât bâliŋ doŋbep op ândinat.” ");
INSERT INTO kpf_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Yatâ sânat? Kutsiŋgiŋâ laŋ kârâbapkât yatâ utnat? ");
INSERT INTO kpf_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Yatâ buŋâ. Kristo sot muwen. Too saŋgonniŋgâwe, narâk zoren Yesu Kristogâren târokwarâwen. Nen Yesugât mumuŋan târokwarâwen. Zo nâŋgâme mo? Zo yatâ oi dap op bâliŋan târokwap ândinat? ");
INSERT INTO kpf_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Zo yatâ nen too saŋgonniŋgâne Kristo sot ârândâŋ mom hanagowen yatâ uap. Oi Kristogât ibâ, Anutu, zâk imbaŋandâ Kristo mumuŋan gâbâ mâŋgei zaarip, ândiap. Nen yatik wâgân op ândiândi uŋakŋâ ŋâi muyageniŋgi ândinat. ");
INSERT INTO kpf_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Nen mumuŋaŋgât tobat op târokwarâwengât zaatzaatŋaŋgât, zo yatik op târokwâtnat. ");
INSERT INTO kpf_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Niiŋaŋgât itâ nâŋgâmen. Um sâŋgiŋâ Yesu sot ârândâŋ poru nagân kuwe. Zo um sâkniŋan bâliŋaŋgât imbaŋâ koi gibapkât sot bâliŋaŋgât kore mân op ândinatkât. ");
INSERT INTO kpf_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ŋâi zâk moi bâliŋaŋgât tâkŋâ olaŋbap. Oi nen yatik Kristogât mumuŋan târokwarâwengât bâliŋaŋgât tâkŋâ mân saaniŋgi ândinat. ");
INSERT INTO kpf_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Itâ nâŋgâmen. Kristo sot muwenŋâ hânân sot sumbemân zâk sot ândinat. ");
INSERT INTO kpf_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kristogât itâ nâŋgâmen. Anutuŋâ zâk mumuŋan gâbâ mem zaaripkât dum zagâtŋâ mân mumbap. Mumuŋandâ Kristogât a kutâ dum zagâtŋâ mân upap. ");
INSERT INTO kpf_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Yesu moip, zâk bâliŋâniŋaŋgât op sâp kânok moi âkip. Oi Anutuŋâ Yesu mumuŋan gâbâ mâŋgei zaatŋâ Anutugât kutsiŋgi laŋ kârâbapkât nep tuum ândiap. ");
INSERT INTO kpf_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Oi zeŋgât yatik. Ziiŋaŋgât nâŋgânetâ bâliŋâziŋaŋgât zâk sot muwe yatâ uap. Oi Yesu Kristo, zâk sot pâlâtâŋ op zaat Anutugât arâp ândie. Yatâ nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Bâliŋandâ sâkziŋan a kutâ upâ sâi mân nâŋgâbi. Oi sâkziŋandâ âkŋâle bâliŋaŋgât aleziŋgi zo yatik mân nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Oi um sâkziŋâ zo bâliŋaŋgât kore opapkât um sâkkât kendon ândibi. Zen mumuŋan gâbâ mâŋgiziŋgipkât um sâkziŋâ Anutugâren pane zimbap. Târârak ândibigât yatâ upi. ");
INSERT INTO kpf_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Zen Mosegât gurumin dengât mâtâbân mân ândie. Buŋâ. Gurumin denŋâ mân tânzâŋgomap. Yesu Kristogât op Anutugât tânzâŋgozâŋgoŋ mâtâbân ândime. Zorat op ko bâliŋandâ a kutâ mân otziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Oi zi dap orot? Anutugât tânzâŋgozâŋgoŋan bageindâ gurumin dengât pâkeŋâ siriksâipkât bâliŋ utnat? Yatâ buŋâ. ");
INSERT INTO kpf_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Zen itâ nâŋge mo? A kutâ um sâkziŋâ zâkkâren pam kore okŋaŋgâbiŋâ, zâkkât kore a op nepŋâ tuubi. Bâliŋandâ a kutâziŋ oi zâkkât kore a op ândim mom tâmbetagobi. Mo Kembu zâk a kutâziŋ oi sât luluŋ op, zâkkât kore a op ândim âlip upi. ");
INSERT INTO kpf_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Zen bâliŋaŋgât kore op ândiwe, zo âkip. Oi zi siŋgi âlip kwâkâm ziŋgâwe dâp umziŋ nâŋgâmŋâ lume, zorat Anutu sâm âlip kwapi. ");
INSERT INTO kpf_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Zen bâliŋan gâbâ mâkâziŋgâm olaŋziŋgi târârak ândiândiŋaŋgât kore a op ândie. ");
INSERT INTO kpf_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Um nâŋgânâŋgâziŋ lotŋaŋgât ayân kut ŋâi ziap, zoren dâpkwap den zi dâzâŋguan. Zen mârumŋan um sâkziŋâ pane âkŋâle bâliŋâ sot bâliŋâ zorat kore oi laŋ ândiwe. Oi narâk ziren um sâkziŋ Kembugâren pane ândiândi târârakkât kore oi um hâlâlu op ândibi. ");
INSERT INTO kpf_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Zen bâliŋaŋgât kore op ândiwe, narâk zoren târârakkât kore mân ândiwe. ");
INSERT INTO kpf_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Oi narâk zoren wan bonŋâ muyagiwe? Kut ŋâi ŋâi urâwe, zorat narâk ziren nâŋgâne aŋunŋoot opmap. Oi itâ nâŋgâmen. A kut ŋâi ŋâi yatâ zo upme, zen zorat sâŋgân mem mom tâmbetagobi. ");
INSERT INTO kpf_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Zen ko Kembuŋâ bâliŋaŋgât dumun olaŋi Anutugât kore a op ândie. Oi bonŋâ, um hâlâlu mie. Oi bet ândiândi kâtik muyagibi. ");
INSERT INTO kpf_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Bâliŋaŋgât kore upme, zen bâliŋaŋgât hâuŋâ tâmbetagoagoŋ zo mimbi. Ka Anutu um âlipŋaŋgât ziŋgâziŋgâŋ zo ândiândi kâtik. Oi nen Kembuniŋâ Yesu Kristo, zâkkâren târokwap ko ândiândi kâtik zo miwen. ");
INSERT INTO kpf_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Bukurâpnâ, Mosegât gurumin den nâŋgâme, zeŋgât op san. Zen itâ nâŋgâme? “Gurumin den luluŋâ zo mumuŋan âkâmap.” ");
INSERT INTO kpf_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Zorat ambân ŋâi apŋâ wâgân ândei birâbirâŋ, zo mân taap. Gurumin denân den ŋâi yatâ ziap. Apŋâ moi ko ap ambin zekât sâm zikâzikâŋ, zo âkâbap. ");
INSERT INTO kpf_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Ambân ŋâi, zâk apŋâ wâgân ândei birâm ŋâi sot ândei laŋ mâman ambân sâbi. Ka ap ambin ândeitâ apŋâ moi ko gurumin denŋâ saazikip, zo ânâŋgâtpap. Oi ambân zo a ŋâi mimbap, zo ko laŋ mâman yatâ mân upap. ");
INSERT INTO kpf_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Bukurâp, zeŋgât topziŋâ yatigâk ziap. Kristo zâk moip. Oi zen mumuŋan târokwap mune gurumin dengât tâkŋâ ânâŋgârip. Oi mumuŋan gâbâ kândom zaarip, zâkkât siŋgi urâwe. Nen Anutu kore okŋaŋgâm ândim kwâtâtinatkât yatâ muyageip. ");
INSERT INTO kpf_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ândiândi sâŋgiŋâ ândiwen, narâk zoren gurumin denŋâ bâliŋaŋgât âkŋâlegât kârâp waari sâkniŋan nep tuugip. Yatâ otniŋgi tâmbetagoagoŋaŋgât mâtâbân ândiwen. ");
INSERT INTO kpf_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Zi ko Yesu sot moindâ gurumin sâŋgiŋaŋgât tâkŋâ zo ânâŋgârip. Oi gurumin dengât mâtâp sâŋgiŋâ mân lâŋ, Kaapumgât mâtâp uŋakŋâ lâŋ Anutu kore okŋaŋgâmen. ");
INSERT INTO kpf_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Oi zi dap sânat? Mosegât gurumin den zo bâliŋâ? Zo buŋâ. Gurumin den buŋâ sâi ko nâ bâliŋaŋgât topŋâ mân nâŋgâbam. Gurumin denân den ŋâi itâ sapsum niŋgâmap, “A ŋâigât kut ŋâi ŋâi laŋ mimbat sâm mân ek âkŋâliban.” ");
INSERT INTO kpf_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Bâliŋandâ tâmbetnobam gurumin denân mâtâp itâ muyageip. Umnâ kâitkui a nâmbutŋâ zeŋgât kut ŋâi ŋâi laŋ mimbat sâm ek âkŋâlem ândiwan. Den kâtik zo mân zei sâi bâliŋâ yen zembap. ");
INSERT INTO kpf_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Nâ mârumŋan gurumin den mân nâŋgâwan, narâk zoren tosanaŋgât topŋâ mân nâŋgâm laŋ ândia bâliŋandâ mân nogip. Ka bet gurumin den muyagenigi bâliŋandâ umnan laŋ kâri topŋâ itâ nâŋgâwan, “Um mumuŋ yatâ op ândian.” ");
INSERT INTO kpf_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Gurumin denŋâ otnigi ândim zâibatkât sâsâŋ, zorâŋak mâburei kâmbamnâ oip. ");
INSERT INTO kpf_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Bâliŋandâ gurumin denân mâtâp muyagemŋâ kâitnogi gurumin denŋâ nogi mowan. ");
INSERT INTO kpf_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Oi zo itâ. Gurumin den zo âlipŋâ sot tosaŋâ buŋâ. Mâbâŋgum ŋâi ŋâi sâwe, zo tosa buŋ sot târârak âlipŋâ. ");
INSERT INTO kpf_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Gurumin den âlipŋandâ nogi mowan? Yatâ buŋâ. Bâliŋandâ nogip. Bâliŋandâ gurumin denân mâtâp muyagem nogi mowan. Bâliŋaŋgât topŋâ muyagibapkât bâliŋandâ nogi mowan. Bâliŋaŋgât nâŋgindâ sumunŋâ uap. Nen bâliŋaŋgât topŋâ yatâ nâŋgânatkât gurumin denŋâ sâi mowan. ");
INSERT INTO kpf_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nen itâ nâŋgâmen. Gurumin den zo Anutugâren gokŋâ. Nâ ko hânân gokŋâ. Bâliŋandâ sâŋgânnâ mei zâkkât kore op ândian. ");
INSERT INTO kpf_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Orot mâmenaŋgât nâŋga kwakmak opmap. Nâ kut ŋâi upam, zo birâm mân opman. Oi kut ŋâi âkon opman, zo opman. ");
INSERT INTO kpf_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Gurumin denân pâke den ziap, zorat nâŋga âlip opmap. Kut ŋâi âkon opman, zo opŋâ gurumin den âlipŋâ zorat topŋâ muyageman. ");
INSERT INTO kpf_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Yatâ opman, zo ninâ umgât buŋâ. Bâliŋandâ um sâknan zem kâitnogi opman. ");
INSERT INTO kpf_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Nâ topnâ itâ nâŋgan. Sâk sunumnaŋgât umŋan âlipŋandâ mirâ kamân mân meip. Kut ŋâi âlipŋaŋgât zo sâman. Ka bonŋâ mân muyageman. ");
INSERT INTO kpf_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Kut ŋâi âlipŋâ upat sâmŋâ mân opman. Nâ kut ŋâi bâliŋâ zo mân upat sâm zorâŋak opman. ");
INSERT INTO kpf_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Nâ bâliŋâ mân upat sâm zorâŋak opman. Zo itâgât. Zo ninak buŋâ. Bâliŋandâ um sâknan mirâ kamân meipkât yatâ opman. ");
INSERT INTO kpf_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Den san, zo itâ. Nâgâren itâ muyagemap. Kut ŋâi âlip upâ sa bâliŋandâ mâte otnimap. ");
INSERT INTO kpf_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Nâ umnandâ Anutugât den nâŋgâm âkŋâleman. ");
INSERT INTO kpf_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Oi sâknan ko bâliŋandâ ziap, zo um nâŋgânâŋgânâ den ziap, zâk sot kâsa opmabot. Bâliŋandâ um sâknan ziap, zorâŋâ kâtigem saanigi zâkkât tâk namâŋaŋgât a opman. Bâliŋandâ tâmbetnobam sâknanâk ândimap. ");
INSERT INTO kpf_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Yei, a umbumamburuk. Ŋâiŋâ tânnâŋgom um sâknan bâliŋaŋgât imbaŋâ koi gibap? ");
INSERT INTO kpf_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Anutugât sâtkât Yesu Kristoŋâ tânnobap. Zorat Anutu sâm âlip kwâkŋaŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Ka Yesu Kristo sot pâlâtâŋ op ândimen, neŋgâren bâliŋaŋgât hâuŋâ sâm kwâkâkwâkâŋ mân muyagibap. ");
INSERT INTO kpf_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Nen Yesu Kristo sot pâlâtâŋ oindâ Kaapumŋâ ândiândi muyagem niŋgâmap. Kaapum zâkŋâ bâliŋan sot mumuŋan gâbâ mâkâniŋgip. ");
INSERT INTO kpf_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mârum um sâŋgiŋniŋandâ gurumin den zorat imbaŋâ mem gei neŋgâren kubikkubik nep tuum oseip. Zorat Anutuŋâ itâ op um sâŋgiŋniŋaŋgât imbaŋâ koi geip. Nanŋâ sâŋgongoi bâliŋ mâme neŋgât sâk yatâ opŋâ neŋgât bâliŋaŋgât suup meip. ");
INSERT INTO kpf_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Gurumin den lum târârak ândiândiŋ, zorat Kembuŋâ nâŋgi âlip opmap. Oi um sâŋgiŋaŋgât mâtâp buŋ, Tirik Kaapumgât mâtâp lâŋmen, nen Kaapumgât imbaŋan den siŋgi âlip zo lum ândinatkât Kristoŋâ um sâŋgiŋaŋgât imbaŋâ koi geip. ");
INSERT INTO kpf_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","A ândiândi sâŋgiŋaŋgât mâtâp lâŋme, zen um nâŋgânâŋgâziŋ hângât kut ŋâi ŋâi zoren pane zemap. Kaapumgât mâtâp lâŋme, zen ko um nâŋgânâŋgâziŋ Kaapumgâren pane zemap. ");
INSERT INTO kpf_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Um sâŋgiŋaŋgât nâŋgâm ândime, zen tâmbetagobi. Ka Kaapumgât nâŋgâm ândimen, nen ândiândi sot lumbeŋâ muyaginat. ");
INSERT INTO kpf_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Um sâŋgiŋâ nâŋgânâŋgâŋ, zorâŋ Anutu kâsa okŋaŋgâmap. Oi Anutugât gurumin den komap. Zo dap op lubap? ");
INSERT INTO kpf_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Oi um sâŋgiŋ ândime, Kembuŋâ zeŋgât orot mâmeziŋâ zorat nâŋgi mân dâp opmap. ");
INSERT INTO kpf_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Zen ko Anutugât Kaapumŋâ umziŋan ziap, zo ko mâtâp sâŋgiŋan buŋâ, Kaapum sot ândim mâtâp uŋakŋan uruŋsâm ândime. Zen Kaapumgât mâtâbân ândime. Oi zen Kaapumgât a ambân sâsâŋ. Ŋâi zâk Kristogât Kaapumŋâ zâkkât umŋan mân zimbap oi ko Kristogât siŋgi mân upap. ");
INSERT INTO kpf_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Zen ko mârum umziŋandâ bâliŋaŋgât mumuŋ yatâ op ândiwe. Ka Kristo sot pâlâtâŋ utne um dâpziŋâ tosa buŋ minziŋgipkât ândiândi kâtik muyagem ândie. Kristogât Kaapum umziŋan ândiap. ");
INSERT INTO kpf_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Zen dap nâŋge? Tirik Kaapumŋâ umziŋan tâtât mâme opmap mo buŋâ? Tirik Kaapumŋâ umziŋan tâtat mâme opmap oi ko Anutuŋâ Yesu mumuŋan gâbâ mâŋgeip, zo yatik Kaapumŋâ um dâpziŋ mumuŋan gâbâ mâŋgiziŋgâm ândiândi ziŋgâm ândibap. ");
INSERT INTO kpf_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Bukurâpnâ, Nen um sâŋgiŋaŋgât kore a mân utnat. Um sâŋgiŋandâ wan niŋgâmapkât hâuŋâ mâkâm zâkkât mâtâbân âinat? ");
INSERT INTO kpf_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Zen um sâŋgiŋaŋgât mâtâp ândibi zo ko tâmbetagobi. Ka Kaapumgât imbaŋâyân sâkkât den kumbi, zo ko ândim ândiândi âlip ândibi. ");
INSERT INTO kpf_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Anutugât Kaapumŋâ âkom diiniŋgi ândimen, nen Anutugât nan bârarâp ândien. ");
INSERT INTO kpf_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Anutuŋâ Kaapum niŋgip, zo kore arâp op keŋgât utnatkât buŋâ. Nen Anutugât nan bârarâp op ândinatkât niŋgip. Kaapumŋâ um bâbâlaŋ kwatniŋgi Anutu itâ sâm konsâm mâpâsimen, “Aboŋ.” (Yuda denan Abba sâme. Niiŋ denân ko Aboŋ sâmen.) Nen umniŋandâ itâ nâŋgâm kwâtâtimen, “Nen Anutugât nan bârarâp op ândien.” ");
INSERT INTO kpf_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Yatâ nâŋgindâ Kaapumŋâ umniŋan tâtat mâme op den zo yatik sâm muyageniŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Oi itâ nâŋgâmen, “Zâkkât nan bârarâp ândienŋâ Anutugât kut ŋâi ŋâi galem utnat. Nen Kristo sot ârândâŋ galem utnat. Hânân ziren zâkŋâ sâknam nâŋgip, zo yatik sâknam kwâkŋan ândinat oi ko zâk sot âsak âlipŋan bagim ândinat.” ");
INSERT INTO kpf_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Sumbemân Anutugâren gâbâ kut ŋâi ŋâi âsakŋâ neuleŋoot walâwalâŋ muyageniŋgâbap. Oi narâk ziren sâknam sot umbâlâ ândien, zo dâpkua mân dâp upap. Sâknam zirat nâŋga yenŋâ yatâ uap. Wangât, sumbemân kut ŋâi âsakŋâ neuleŋoot doŋbep muyaginat, zorat. ");
INSERT INTO kpf_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Anutuŋâ gâsuniŋgâm nan bârarâp sâm âsakŋâ neuleniŋ muyagibapkât a sot kut ŋâi ŋâi Anutuŋâ muyageniŋgip, nen zorat mambât ândien. ");
INSERT INTO kpf_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kut ŋâi ŋâi yenŋâ hânân ziap, zo gukupitŋâ yen zimbapkât sâm ziŋgip. Ziiŋâ umgât buŋâ. Anutuŋâ yatâ sâi muyageip. Ka zo zinziŋ kâtik zimbigât mân sâm ziŋgip. ");
INSERT INTO kpf_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Zorat kut ŋâi ŋâi yenŋâ hânân zen mumuŋaŋgât dumun zo olaŋ Anutugât nan bârarâp nen sot târokwap neule âsakŋâ mimbi. ");
INSERT INTO kpf_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Nen nâŋgâmen. Kut ŋâi ŋâi zo zen mârumŋan gâbâ narâk zo mâte upapkât mambât ândim sâknam nâŋgâm ândim gawe. ");
INSERT INTO kpf_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Oi zenâk buŋâ, nen ârândâŋ yatik mambât ândim sâknam nâŋgâm ândimen. Anutugât nan bârarâp nen um sâkniŋ kubikŋâ minniŋgâbapkât mambât ândimen. Nen sumbemân gâbâ Kaapumŋâ niŋgip. Kândom Kaapumŋâ niŋgip. Bet ko kut ŋâi ŋâi niŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Nen Anutuŋâ um sâkniŋ kubikŋâ minniŋgâbapkât um bâbâlaŋ op mambât ândinatkât diiniŋgip. Bonŋâ muyagei sâi zorat mân mambâtpem. ");
INSERT INTO kpf_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Bonŋâ muyagiap oi ko dap yatâ zorat mambât ândinat? Bonŋâ mân muyagei ikmengât umŋâ nâŋgâm mambât ândimen. ");
INSERT INTO kpf_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Kaapum zâk lolotniŋaŋgât op betniŋan memap. Nen yatâ mo yatâgât ninâu sâindâ dâp upap, zo mân nâŋgâmengât Kaapumŋâ betniŋan mem, yaak mem, aŋâ mân sâsâŋâ, den zo yatâ neŋgât op Anutugâren sapsumap. ");
INSERT INTO kpf_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Anutugât Kaapumŋâ neŋgâren nep zo yatâ tuubapkât op sâm pindip. Oi Kaapumŋâ Anutugât umŋan den ziap, zo nâŋgâm Anutuŋâ tânnâŋgobapkât den dukumap. Oi Anutu zâk um igikŋâ Kaapumgât umŋan den ziap, zo nâŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Nen itâ nâŋgâmen. Wan mo wanŋâ muyageniŋgâmap, zo Anutuŋâ kubigi tânnâŋgomap. A umniŋandâ Anutu gâsum ândimen, neŋgâren yatâ otniŋgâmap. Nen zâkŋâ diiniŋgâbam nâŋgi zeipkât diiniŋgip, neŋgâren yatâ otniŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","A mârum diiniŋgâbam nâŋgip, nen nanŋaŋgât tobat utnatkât sâip. Oi a doŋbepŋâ nanŋaŋgât murâp op ândeindâ Yesuŋâ âtâniŋ upap. Oi nen zâkkât tobat op ândinatkât sâip. ");
INSERT INTO kpf_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Anutuŋâ a kânŋan nâŋgâniŋgip dâp, nen diiniŋgâm tosaniŋ buŋ minniŋgip. Tosaniŋ buŋ minniŋgip dâp, nen âsakŋâ neule zo nen niŋgip. ");
INSERT INTO kpf_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Den zorat topŋâ dap dap ziap? Anutuŋâ buku otniŋgâm galem otniŋgâm ândei kâsaniŋandâ dap op tâmbetnâŋgobap? ");
INSERT INTO kpf_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Anutuŋâ nanŋâ mân aŋgân kârip. Neŋgât op sâŋgongoi gem moip. Zorat dap naŋge? Yatâ oipŋâ kut ŋâi ŋâi torenŋâ niŋgâbap mo mân niŋgâbap? Niŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Anutuŋâ buku otniŋgâm tânnâŋgoip, zorat a ikâ zorâŋ Anutugât a ambân gâkârâpŋâ denân nâmbanbap? Anutu zikŋak tosaniŋ buŋ minniŋgip, zorat a ikâ zorâŋ nen tosaniŋaŋgât hâuŋâ minatkât sâbap. ");
INSERT INTO kpf_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Yesu Kristoŋâ neŋgât op moip. Oi moibâk buŋâ. Zâk mumuŋan gâbâ zaat Anutu âsan bongen zâi tap neŋgât op Anutu den dukumap. ");
INSERT INTO kpf_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kut ŋâi ikâ zorâŋ Kristogât bikŋan gâbâ mâkâniŋgâbap? Sâknam mo umbâlâ, kâmbam mo pu mo kanpitâ? Kut ŋâi yatâ zo dap op Kristogât bikŋan gâbâ mâkâniŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kembugât ekabân den ŋâi itâ ziap, zorat dâp otniŋgâme. Den zo itâ, “Kembu, gâgât op sirâmŋâ sirâmŋâ nâŋgome. Râma kom gaame, zeŋgât tobat yatâ otniŋgâme.” ");
INSERT INTO kpf_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Oi kut ŋâi yatâ zorâŋ mân mem lot kwatniŋgâbap. Buŋâ. Yesuŋâ umŋandâ gâsânâŋgomapkât imbaŋâ niŋgi zâkkâren kâtigem ândim walâmen. ");
INSERT INTO kpf_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Zorat nâ itâ nâŋgan. Mumuŋâ mo ândiândiŋâ, sumbem a mo bâliŋaŋgât a kâukŋâ, narâk ziren ziap mo bet muyagibap, zorâŋ mo kut ŋâi ŋâi imbaŋoot, zorâŋ Yesu Kristo zâkkât bikŋan gâbâ mânâk mâkâniŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Anutu umŋandâ gâsuniŋgapkât kut ŋâi ubâ gâip mo âmbibâ kopgâipŋâ, kut ŋâi zorâŋ mo zorâŋ Kembuniŋâ Yesu Kristo, zâkkât bikŋan gâbâ mân mâkâniŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Nâ Kristogât a op sarâ mân sâm den bonŋâ sa nâŋgânek. Kaapumŋâ umnan den ziap, zorat nâŋgi bon uap. ");
INSERT INTO kpf_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Yuda a torerâpnâ zeŋgât op umbâlâ op sâknam nâŋgâm ândiman. ");
INSERT INTO kpf_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Yuda a bukurâpnâ, sâk torerâpnâ, zen Kembugât siŋgi upigât opŋâ ninak Kristogât dâmân kâligen gâbâ gigiŋaŋgât nâŋga âlip bâbâlaŋ opap. ");
INSERT INTO kpf_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Zen itâ sâme, “Nen Isirae. Anutuŋâ narâpŋâ gâsuniŋgip. Oi imbaŋâ âsakŋâ tirâpnâŋgoip. Anutuŋâ nen sot târotâro op gurumin den sapsum niŋgip. Oi mâte okŋaŋgânatkât mâtâp tirâpnâŋgoip. Oi kut ŋâi niŋgâbap, zorat siŋgi den kânŋan kesap pâroŋ den dâtnâŋgoip. ");
INSERT INTO kpf_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Nen Abaram, Isaka sot Yakobo, zeŋgât kiurâpziŋâ.” Yuda a bukurâpnâ zen ziiŋaŋgât yatâ nâŋgâm sâme. Oi nen nâŋgen. A bâliŋan gâbâ mâkâniŋgâbapkât mârum sâsâŋ, Kristo, zâk a sâk mem muyageip. Zo Yuda a zeŋgât kâmurân muyageip. Zorat a sot kut ŋâi ŋâi neŋgât Kembu, Anutu, zâk sâm âlip kwâkŋaŋgindâ ândim zâimâmbap. Zo perâkŋak. ");
INSERT INTO kpf_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Isirae a nâmbutŋâ Kembugât mâtâp walâm um kâtik ândinetâ ziŋgit nâŋgi Anutugât den zo loreip mân sânat. Isiraegâren gâbâ muyagiwe, zeŋgâren gâbâ nâmbutŋâ zeŋgât Isirae a bonŋâ mân sâsâŋ. ");
INSERT INTO kpf_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Oi yatigâk Abaramgât kiurâp torenŋâ zen kiurâp bonŋâ mân urâwe. Oi zorat Kembugât ekabân den ŋâi itâ ziap, “Isakagât kiurâp zeŋak Abaramgât siŋgi upi.” ");
INSERT INTO kpf_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Den zorat topŋâ itâ ziap. Sâkŋâ Abaramgâren gâbâ muyagiwe, zen aksik patâŋâ Anutugât nan bârarâp urâwe? Buŋâ. Siŋgi den umŋan muyagiwe, zeŋak Abaramgât kiurâp bonŋâ sâsâŋ. ");
INSERT INTO kpf_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kembuŋâ siŋgi den Abaram itâ sâm dukuip, “Kendon ŋâi âki âburem ga ambingâ Sera zâkŋâ nanŋâ mimbap.” ");
INSERT INTO kpf_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Oi zorik buŋâ, Rebekagâren yatik muyageip. Rebekaŋâ sâkunniŋâ Isaka, zâk sot ândim katep zagât kâmbokoip. ");
INSERT INTO kpf_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Oi katep zagât mân muyagem âlip mo bâliŋâ zo mân oitâ Anutuŋâ zekât op mamzikŋâ itâ sâm dukuip, “Âtâŋandâ munŋaŋgât kore a op ândibap.” Zo ko Anutugât den kâtigibapkât nâŋgâm zikŋak mem kâsâpzâkom den zo sâip. ");
INSERT INTO kpf_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Katep zagât zet orot mâmezikŋâ ekŋâ mân sâip. Kânŋan nâŋgâzikâm yatâ sâip. Zorat den ŋâi Kembugât ekabân itâ ziap, “Na Yakobogât otnigap. Ka Esau ko âkonnigap.” ");
INSERT INTO kpf_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Anutuŋâ ŋâi kâsa okŋaŋgâm ŋâi buku okŋaŋgip, zorat dap sânat? ");
INSERT INTO kpf_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","“Zo bâliŋâ.” Yatâ sânat? Buŋ kâtikŋâ. Zâkŋâ den ŋâi Mose itâ sâm dukuip, “A ŋâi birâŋaŋgâbâ sâm âlip birâŋaŋgâbat. Ka a ŋâi tângubâ sâm âlip tângubat. Lumbe okŋaŋgâbâ sâm âlip okŋaŋgâbat.” ");
INSERT INTO kpf_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Zorat a umgât mo a orot mâmegât mân sâsâŋ. Anutu um lâklâkŋaŋgât tânzâŋgozâŋgoŋ sânat. ");
INSERT INTO kpf_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Anutuŋâ a kutâ Parao den dukuip, zo Kembugât ekabân itâ kulemguwe, “Nâ gâgâren imbaŋânâ sâm muyagia kutsiŋginâ hân dâp âibapkât sâm kwânâŋgâgiwan.” ");
INSERT INTO kpf_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Oi zorat Anutugât itâ nâŋgânat, “Zâk a ŋâi tângubâ sâm tângubap. A ŋâi um kâtik oik sâi kâtigibap.” ");
INSERT INTO kpf_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Nâ yatâ sa itâ sâm mâsikâniban? “Yatâ op ko Anutu zâk wangât a neŋgât nâŋgi bâliŋ uap. Anutuŋâ den ŋâi sâi aŋâ kwâkâbapkât dâp buŋâ.” ");
INSERT INTO kpf_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Den yatâ zo sânandâ itâ mâsikâgibat, “Gâ wangandâ Anutu den dukuban. Âmaŋâ dap op âmaŋ tuutuuŋ a itâ dukubap, ‘Gâ wangât yatâ zo muyagenigin.’” ");
INSERT INTO kpf_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Âmaŋ tuutuuŋ a, zâk deŋgop mem toren a zeŋgât âmaŋ tuubap. Oi torenŋâ mem wâu, bâu zeŋgât tuugi nâŋgindâ bâliŋ upap? ");
INSERT INTO kpf_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Oi Anutu zâk âmaŋ kukŋaŋgât bonŋâ zorat siŋgi, zo bet kunzit birâbapkât nâŋgi ziap. Âmaŋ zo zeŋgâren kâmbam muyagem kukŋaŋgât bonŋâ sot imbaŋâŋâ muyagei a ambân ikpigât tuubap. Nen zorat dap sânat? ");
INSERT INTO kpf_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Oi âmaŋ nâmbutŋâ tânzâŋgobapkât siŋgi, zen kubikziŋgâm sumbemân âsak neuleŋan teŋgâ kwatziŋgâbapkât kânŋan nâŋgi ziap. Âmaŋ zo zeŋgâren neule âlipŋâ gom sâmbe ziŋgâbapkât diiziŋgâm ândiap. ");
INSERT INTO kpf_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Yuda ayâk buŋâ. Hân ŋâin gokŋâ ârândâŋ âmaŋ um lâklâkŋaŋgât op zâkkât siŋgi utnatkât diiniŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Zorat Propete Hoseagât ekabân diŋâ itâ ziap, “Kembuŋâ itâ sap, ‘A kâmut mariziŋ mân orâwan, zen nâgât siŋgi sâbat. Oi umnandâ mân gâsâzâŋgowan, zo umnandâ gâsâzâŋgobat. ");
INSERT INTO kpf_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Oi a zeŋgât nâgât arâpnâ buŋâ dâzâŋgowan, zeŋgât itâ sâbi, ‘Zen Anutu ândiândiŋaŋgât nan bârarâp op ândie.’” ");
INSERT INTO kpf_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Oi Propete Yesaiaŋâ den kâtik sâm Isirae a zeŋgât itâ sâip, “Isiraegât kiurâp zen saruyân sak ziap, zo yatâ doŋbep muyagibi. Ka zeŋgâren gâbâ bituktâŋâ Kembugât siŋgi upi.” ");
INSERT INTO kpf_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Kembugât itâ nâŋgâmen. Kembu zâk a zeŋgât sâm kwâkâmŋâ kegâk hâuŋâ ziŋgâm naŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Zorat Propete Yesaiaŋâ den ŋâi itâ sâip, “Sumbem kâwali a zeŋgât Kembu, zâk mân nâŋgâniŋgi sâi ko kiurâpniŋ buŋ upe. Mirâ kamânziŋ zo Sodom sot Gomora zeŋgât tobat yatâ upe.” (Anutuŋâ kamân zagât zo zikiri bâliŋ oitâ sâi kârâpŋâ zikesem naŋgip.) ");
INSERT INTO kpf_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Oi zi dap sânat? Zitâ sânat. Hân ŋâin gokŋâ, ziŋ târârak mân ândimŋâ tosaniŋ buŋ utnâ sâm tosaziŋ buŋ urâwe. Kembugâren nâŋgâm pâlâtâŋ kwâkŋaŋgâm tosaziŋ buŋ urâwe. ");
INSERT INTO kpf_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Yuda a zen ko Mosegât gurumin den lum târârak utnat sâweŋâ gurumin den zo lum osiwe. ");
INSERT INTO kpf_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Zen târârak mân urâwe, zo itâgât. Zen nâŋgâm pâlâtâŋziŋ buŋâ. Zen yen ândim mâmanziŋaŋgât târârak utnatkât sâwe. Oi mâtâbân kât zeip, zoren kinziŋ luakŋime. ");
INSERT INTO kpf_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Kembugât ekabân diŋâ zitâ kulemgune ziap, “Nâŋgâ. Nâ Sioŋ bâkŋan, Yerusalem kamânân zeŋgâren kât ŋâi paan. Zoren kinziŋ luakŋibi. Oi kât kâtik ŋâi paan. Zoren a doŋbep patâŋâ zâŋgobap. Ka ŋâi zâk nâŋgâm pâlâtâŋ kwatnibapŋâ mân kwakpap.” ");
INSERT INTO kpf_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Bukurâpnâ, Yuda a bukurâpnâ âlip upigât umnandâ otnigi zeŋgât op Anutugâren ninâu sâman. ");
INSERT INTO kpf_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Zen Anutu kore okŋaŋgânam um bâbâlaŋ ândime. Zo ziŋgitmanŋâ san. Ka zen mâtâp mân ek nâŋgâm upme. ");
INSERT INTO kpf_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Zen Anutugâren gâbâ târârak orotŋâ mâtâp ziap, zo kwakmegât ziiŋak târârak utnatkât nepŋâ tuume. Anutugât mâteŋan tosa buŋ orotŋaŋgât mâtâp, zo mân ek nâŋgâm Kristo kândâtkuwe. ");
INSERT INTO kpf_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Nen ko itâ nâŋgen. Aŋâ nâŋgâm pâlâtâŋgât opŋâ tosaniŋ buŋ muyaginatkât Kristoŋâ gurumin dengât mâtâp dooŋgoip. ");
INSERT INTO kpf_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Moseŋâ gurumin denân den ŋâi itâ kulemgoip, “A zen gurumin den lum naŋgâm târârak op ândiândi muyagibi.” ");
INSERT INTO kpf_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Nâŋgâm pâlâtâŋgât tosa buŋ orotŋaŋgât den ko itâ ziap, “Gâ umgandâ itâ mân sâban, ‘Ŋâiŋâ sumbemân zâimŋâ Kristo diim gibap? ");
INSERT INTO kpf_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Mo ŋâiŋâ âmbi geimŋâ Kristo mumuŋâ zeŋgâren gâbâ diim kopgâbap.’ ");
INSERT INTO kpf_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Yatâ buŋâ.” Kembugât ekabân den ŋâi itâ ziap, “Den zo kârebân mân ziap. Lâugan sot nâŋgânâŋgâgan ziap.” (Zo nâŋgâm pâlâtâŋgât den kwâkâm ziŋgâmen, zorat sâsâŋ.) ");
INSERT INTO kpf_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Yesu, zâk Kembuŋâ. Den zo lâugan zimbap oi Anutuŋâ Yesu mumuŋan gâbâ mâŋgeip, zorat umgandâ nâŋgi bon opmap oi ko âlip op sumbemgât siŋgi upan. ");
INSERT INTO kpf_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Nen itâ nâŋgâmen, “Umŋâ Yesu nâŋgâm pâlâtâŋ kwap tosaniŋ buŋ utnat. Oi lâuniŋandâ Yesu Kembuniŋâ sâmŋâ sumbemgât siŋgi utnat.” ");
INSERT INTO kpf_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Zorat Kembugât ekabân den ŋâi itâ kulemguwe, “Ŋâi zâk Kembu ŋâŋgâm pâlâtâŋ kwâkŋaŋgâbapŋâ kwakmak mân upap.” ");
INSERT INTO kpf_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Âlip nâŋgen. Yuda a sot hân ŋâin gok nen kânok uen. Kembu, zâk kânok kembu otniŋgâm ândimap. Kembu zâk hâtubâtu mân otniŋgâmap. Oi zâk konsâmen dâp, nen umgât gom sambe zo niŋgâmap. ");
INSERT INTO kpf_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Zorat Kembugât ekabân itâ sâsâŋ, “Kembu konsâm ândibi, zen Kembuŋâ bâliŋan gâbâ mâkâziŋgâbap.” ");
INSERT INTO kpf_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ka a zen ko zâk mân nâŋgâm pâlâtâŋ kwâkŋaŋgâmŋâ dap yatâ konsâm ândibi? Oi a zen topŋâ mân nâŋgâmŋâ dap op nâŋgâm pâlâtâŋ kwâkŋaŋgâbi? A ŋâiŋâ Anutugât siŋgi den mân dâzâŋgoi ko dap topŋâ nâŋgâbi? ");
INSERT INTO kpf_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Oi Anutuŋâ a mân sâŋgonzâŋgoi dap op âi siŋgi dâzâŋgobi. Zorat Kembugât ekabân den kulem ŋâi itâ ziap, “Siŋgi âlip sâsâŋ a, zeŋgât kinziŋ kwamitŋâ nâŋgâm ko nâŋgâne âlip upap.” ");
INSERT INTO kpf_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Siŋgi âlip zo Yuda a nâmbutŋandâ nâŋgâm mân luwe. Zorat Propete Yesaiaŋâ itâ sâip, “Kembu, siŋgi den sâindâ mân nâŋgâme.” ");
INSERT INTO kpf_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Zorat op itâ nâŋgâbi. Nâŋgâm pâlâtâŋ, zo den siŋgi sâsâŋaŋgât bonŋâ. Oi den siŋgi âragumen, zo Kristogât siŋgi âlip den. ");
INSERT INTO kpf_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Itâ sâm mâsikâziŋgan. Zen siŋgi âlip den zo nâŋgâwe mo buŋâ? Zen nâŋgâwe. Den ŋâi itâ ziap, “Kembugât denŋâ hân dâp âim naŋgip. Oi diŋandâ hân muruk toren toren âim naŋgip.” ");
INSERT INTO kpf_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Dum mâsikâziŋgâm san. Isirae a zen dâŋ nâŋgâm kwâtâtiwe mo buŋâ? Kândom Moseŋâ den ŋâi itâ kulemgoi nâŋgâwe, “Kembuŋâ itâ sap, ‘A yenŋâ, hân ŋâin gokŋâ kâmut ŋâi diiziŋga Isirae zen nâŋgâne bâliŋ oi um kâlak otziŋgâbi. A kwakmak kâmut zo diiziŋga zen ek kuk upi.’” ");
INSERT INTO kpf_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Bet Propete Yesaiaŋâ keŋgât buŋ den yâmbât itâ sâip, “Kembuŋâ itâ sap, ‘Mân kârunim ândiweŋâ muyaginiwe. Topnâ mân sâm kârum ândiwe, zen mâte otziŋgâwan.’” ");
INSERT INTO kpf_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Ka Isirae a zeŋgât Kembuŋâ den ŋâi itâ sâi kulemguwe, “Nâ a kâmut zâizâiŋ sot den kukuŋ zi, zen hârâŋsâm narâk kârep ândinetâ nâgâren gabigât kwâbâlap tuum ândiwan.” ");
INSERT INTO kpf_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Oi zi den ŋâi mâsikâziŋgan. Anutuŋâ Isirae arâpŋâ birâziŋgip? Buŋâ. Yatâ mân oip. Nâ Isirae a, Abaramgât kiun, Benyamingât kâmurân gokŋâ. ");
INSERT INTO kpf_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","3","Anutuŋâ kânŋan nâŋgâniŋgip, nen mân birâniŋgip. Zen Propete Eliagât den siŋgi ŋâi Kembugât ekabân ziap, zo sâlâpkume mo buŋâ? Propete Elia, zâk Isirae a zeŋgât tosaziŋaŋgât den sâm Anutu itâ sâm dukuip, “Kembu, zen Propete arâpkâ zâŋgom naŋge. Gâgât siŋgi sâm nalem pâpanŋâ zo kom kândaŋâwe. Oi zi nâ ninik ândia nonam se.” ");
INSERT INTO kpf_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Propete Eliaŋâ yatâ sâi Anutuŋâ den dap mâburem pindip? Zo itâ, “Nâ a 7 tausen yatâ aŋgân kârâziŋga lopio kutŋâ Baali, zâkkâren mân âi pindiŋsâwe.” ");
INSERT INTO kpf_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Oi narâk zi yatigâk Anutuŋâ um lâklâkŋaŋgât opŋâ Isirae zeŋgâren gâbâ a bituktâ mem sâlâpzâŋgoi arâpŋâ op ândie. ");
INSERT INTO kpf_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Zen orot mâmeziŋaŋgât buŋâ. Zikŋâ um lâklâkŋaŋgât op gâsuziŋgâm tânzâŋgoip. Yatâ mân oi sâi tânzâŋgozâŋgoŋaŋgât bonŋâ mân âsagebap. ");
INSERT INTO kpf_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Oi dap dap? Isirae a kut ŋâi zo muyaginat sâwe, zo mân muyagiwe. Anutu zikŋak nâŋgâm gâsum sâlâpzâŋgoip, zeŋak kut zo muyagiwe. A nâmbutŋâ umziŋ kâtigeip. ");
INSERT INTO kpf_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Zorat op Kembugât ekabân itâ kulemgune ziap, “Anutu zâk umziŋ mem gulipkoip. Sinziŋ kwâtepkuip. Kindapziŋ mem dooŋgoip. Yatâ otziŋgi ândiweŋak ândim ge.” ");
INSERT INTO kpf_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","A kutâ Dawidiŋâ itâ sâm kulemgoip, “Zen Kembugât den sâtŋak lum sii nalem nime, ka umziŋandâ Kembu kândâtkume. Zorat op ko zen sii nalem ninetâ kâsaziŋ ganetâ parâtâk pambi. Hânân gei zâŋgoi hâuŋâ takâziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Gâ sinziŋâ kwâtepkuna kwakpi. Oi kândâtziŋ mem namuŋna kâriŋgoŋ ândibi.” ");
INSERT INTO kpf_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Oi den ŋâi mâsikâziŋgan. Isirae a zen kârân kinziŋ luakŋem hânân gei tâmbetagowe? Yatâ buŋâ. Zen kubikkubik kândâtkune a hân ŋâin gokŋâ zeŋgât siŋgi oip. Oi hân ŋâin gokŋâ zen nâŋgâne Isirae a ziŋâ ziŋgit umbâlâ upi. ");
INSERT INTO kpf_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Isirae a zen Kembugât den kândâtkune a hân ŋâin gokŋâ zen nâŋgâm lum âlip urâwe. Yatâ utne Isirae a kâmut zen bet umziŋ melâŋ Kembu sot pâlâtâŋ utne bonŋâ doŋbep walâwalâŋ muyageziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Hân ŋâi gokŋâ zen den zi dâzâŋgua nâŋgânek. Nâ hân ŋâin gokŋâ zeŋgât Aposolo ândimanŋâ nepnâ tuum kwâtâteman. ");
INSERT INTO kpf_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Oi nâ yatâ op ândim Isirae a torerâpnâ aleziŋga nâmbutŋandâ umziŋ melâŋ âlip upi. Hân ŋâin gok zen siŋgi âlipkât bonŋâ muyagine Isirae a nâmbutŋâ ziŋ ek nâŋgâm zo yatik minâ sâm umziŋ melâŋbi. ");
INSERT INTO kpf_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Anutuŋâ Isirae a birâziŋgi hân ŋâin gokŋâ zen Anutu sot buku ue. Oi bet Anutuŋâ Isirae a dum gâsuziŋgi ko mumuŋan gâbâ zaatzaatŋâ yatâ upi. ");
INSERT INTO kpf_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Kândom Kembugât siŋgi pâpanŋâ oi ko du ombeŋan âsagine zo yatik zâkkât siŋgiyak pâpanŋâ. Oi nak topŋandâ hâlâlu zei nak bâranŋâ sot bonŋâ zet yatik hâlâlu zimbabot. ");
INSERT INTO kpf_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Oi Anutuŋâ kamân Oliwa nagân bâranŋâ nâmbutŋâ mânâŋgât birâm zorat gebâgân ulinŋâ barin gâbâ gâ târokwatgigip. Oi Oliwa ândâŋâ kelâk tooŋandâ tângogip. ");
INSERT INTO kpf_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Gâ bâranŋâ sâŋgiŋâ zeŋgât nâŋgâna gigiŋ oi sâkkâ mân mem zâiban. Yatâ opapkât itâ nâŋgâ. Gâŋâ ândâŋâ mân tângum nalem pindâmat. Zâkŋâ tângom nalem gimap. ");
INSERT INTO kpf_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Nâ yatâ dâgoga zorat toren itâ sâban? “Anutuŋâ nâ târokwatnibapkât bâran sâŋgiŋâ mânâŋgâtziŋgâm birâziŋgip.” ");
INSERT INTO kpf_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Den zo bonŋâ. Zo siŋgi âlip birâm ândiwegât mânâŋgât birâziŋgip. Gâ ko nâŋgâm pâlâtâŋgaŋgât op zâk zeŋgât kinkin gebâgân kinzat. Zorat gâ sâkkâ mân mem zâim diim gem ândiban. ");
INSERT INTO kpf_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Anutuŋâ Oliwa bâranŋâ sâŋgiŋâ zâizâiŋâ, zo mânâŋgât birip. Oi zo yatik gâ zâizâiŋ op ândina mânâŋgât birâgibap. ");
INSERT INTO kpf_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Zorat gâ Anutu um lâklâkŋaŋgât op tângogip sot um kâtik urâwe, zen hâuŋâ ziŋgip. Zorat mân nelâmgobap. Um kârâpŋaŋgât bonŋâ, zo siŋgi âlip kândâtkuwe, zeŋgâren muyagemap. Oi um lâklâkŋaŋgât bonŋâ gâgâren muyagiap. Oi gâ zâk sot pâlâtâŋ op ândina bonŋâ âlip zemgibap. Yatâ mân upan zo ko mânâŋgâtŋâ birâgibap. ");
INSERT INTO kpf_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Oi bâranŋâ sâŋgiŋâ zen um kâtikziŋâ birâne Anutuŋâ dum zagâtŋâ târokwatziŋgâbâ sâm âlip upap. ");
INSERT INTO kpf_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Oi barin gâbâ Oliwa nak bâranŋâ kamângât Oliwa nagân târokwâkwatŋâ, zo mân orotŋâ. Ka Kembuŋâ barin gâbâ Oliwa bâranŋâ mingimŋâ kamângât Oliwa nagân târokwatgigip. Kamân Oliwa zikŋâ bâranŋâ mânâŋgârip, zo târokwatziŋgâbâ sâm mân kwakpap. Zo kegâk târokwatziŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Bukurâpnâ, zen kwakŋâ ziiŋâ nâŋgânâŋgâyân siŋgi âlibân bagim nâŋgâm gulipkubegât den tikŋâ zi sapsum ziŋgâbâ. Isirae a nâmbutŋâ zen um kâtik op ândine hân ŋâin gokŋâ zen siŋgi âlipkât bagine teŋgâziŋ mârumŋan sâip, zo dâpŋan op naŋgâbap. ");
INSERT INTO kpf_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Bagine Isirae a kâmut bagim âlip op naŋgâbi. Kembugât ekabân diŋâ itâ kulemgune ziap. “Sioŋ bâkŋan, Yerusalem kamânân gâbâ kubikkubikniŋâ muyagem Isiraegât kiurâp zeŋgâren bâliŋâ ziap, zo gâbarei âibap. ");
INSERT INTO kpf_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Yatâ oi nâ bâliŋâziŋ saŋgonŋâ zen sot târotâro upat.” ");
INSERT INTO kpf_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Hân ŋâin gokŋâ, zen siŋgi âlibân bâgibigât Yuda a ziŋ narâk ziren Anutugât kâsa yatâ op ândie. Ka Anutuŋâ Yuda a sâkurâpziŋ mem sâlâpzâŋgoipkât Anutugât umŋandâ zeŋgâren patâ oi ândie. ");
INSERT INTO kpf_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Anutu zâk buku orotŋaŋgât den sot diiziŋgâziŋgâŋaŋgât sâi den zo mân loribap. ");
INSERT INTO kpf_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Hân ŋâin gok, zen mârumŋan um kâtik op ândiwe. Bet, nârâk zi Isirae a zen um kâtik utne ko hân ŋâin gokŋâ zen Anutuŋâ tânzâŋguap. ");
INSERT INTO kpf_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Zo yatik Yuda a zen um kâtik op ândimŋâ birânetâ ko Anutuŋâ tânzâŋgobap. ");
INSERT INTO kpf_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Anutu zâk a aksik patâ bet tânzâŋgobapkât op nâŋgâmŋâ nâŋgâziŋgi bâliŋandâ saaziŋgi den ku a op ândie. ");
INSERT INTO kpf_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Opoŋ, Anutu zâk siŋgi âlipkât gom sambe tâtalek zemŋâŋgap. Zâkkât nâŋgânâŋgâŋ, zo dap yatâ nâŋgâm kwâtâtinat? Zâkŋâ walâniŋgâm nâŋgap. Den sâm kwâkâmap, zorat dap yatâ nâŋgâm kwâtâtinat? Nep tuutuuŋaŋgât mâtâp, zo dap yatâ nâŋgâm naŋgânat? ");
INSERT INTO kpf_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Kembugât ekabân den ŋâi itâ ziap, “Kembugât umŋan den ziap, zo a neŋgâren gâbâ ŋâiŋâ mân nâŋgâm kwâtâtimap. Zâkŋâ den ŋâi sâi ko dap op bekŋan mem sânat? ");
INSERT INTO kpf_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Ŋâiŋâ Kembuŋâ kut ŋâi pindip, zorat tosaŋâ zei ma ko mâkâbap?” ");
INSERT INTO kpf_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Zâkŋâ a sot kut ŋâi ŋâi aksik patâ muygeniŋgip. Zâkŋâ imbaŋâ niŋgi ândimen. Oi zâkkât siŋgi op ândimen. Zâk mariniŋâ sot kembu patâniŋâ ândiap. Zorat Anutu sâm âlip kwâkŋaŋgindâ târokwâi zem zâimâmbap. Zo perâkŋak. ");
INSERT INTO kpf_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Bukurâpnâ, Anutuŋâ umâlipŋaŋgât op tânnâŋgoipkât kindap pâroŋ den dâzâŋgua nâŋgânek. Mârumŋan sii nalem mo zuu bâu Kembugât siŋgi sâm om pâmarâwe, zo yatik zen um sâkziŋ Anutugâren panetâ zei egi âlip ŋâi upap. Yatâ utnetâ dâp upap. Zen yatâ op Anutu kore bonŋâ okŋaŋgâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Oi ândi mâmanziŋandâ um kâtik zeŋgât tobat yatâ mân upap. Zen um nâŋgânâŋgâziŋ Anutugâren pane zei kubikziŋgi tobat ŋâi upi. Zen yatâ utne Anutu diŋaŋgât dâp mâtâp âlipŋâ sot târârakŋâ zo ek nâŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kembuŋâ tânnogipkât nâ den sa zen aksik nâŋgânek. Gâ Kembugât siŋgi ândiat. Ka gâ gikaŋgât nâŋgâna zâizâiŋ mân upap. Anutuŋâ nepkât imbaŋâ gigip, zorarâk nâŋgâm tuum ândiban. ");
INSERT INTO kpf_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Itâ nâŋgâmen. Sâk bonniŋâ kânok. Ka kore orotŋâ doŋbepŋâ nep top topŋâ tuume. ");
INSERT INTO kpf_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Oi torenŋâ Kristogât kâmurân yatigâk târokwâindâ bonniŋâ kânok uap. Kristo zâk kâukniŋâ uap. Oi nen kiŋ bik op ândim tânagomen. ");
INSERT INTO kpf_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Siŋgi âlipkât imbaŋâ top topŋâ niŋgip, zo tânnâŋgom niŋgip dâp zem ariap. Oi zo wâratkum nepŋâ tuunat. Zorat a ŋâi, zâk Kembugât den sâm muyagibapkât imbaŋâ zemŋâŋgap oi ko nâŋgâm pâlâtâŋâ tâkŋaŋgap dâp Kembugât den sâbap. ");
INSERT INTO kpf_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ŋâi zâk kore orotŋaŋgât nep tuubapkât imbaŋâ zemŋâŋgap oi ko nep zo tuum ândibap. Oi ŋâi zâk den kwâkâm ziŋgâ nep tuubapkât imbaŋâ zemŋâŋgap oi ko zo yatik tuubap. ");
INSERT INTO kpf_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Um bâbâlaŋ kwatziŋgâziŋgâŋ den sâmap, zâk zorat imbaŋâ zemŋaŋgâbabân sâbap. Ŋâi zâk kât sikum ziŋgâziŋgâŋaŋgât imbaŋâ zemŋâŋgap, zâk umŋâ diim gem umâlip op tuubap. Ŋâi zâk a sâtŋâ ândibapkât sâm pindâpindâŋ, zâk zo kâtigem tuum ândibap. Ŋâi zâk tânzâŋgobapkât imbaŋâ zemŋâŋgap, zâk umbâbâlaŋâk upap. ");
INSERT INTO kpf_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Buku orot zo sâkŋandik mân upi. Umŋâ gâsâyagom upi. Orot mâme bâliŋâ, zorat âkon op ândibi. Oi orot mâme âlipŋâ, zorik upi. ");
INSERT INTO kpf_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Zen buku bonŋâ op ândibi. Oi tânagonam walâgilâ op kâtigibi. Bukurâpgaŋgât nâŋgâna mân gigiŋ upap. ");
INSERT INTO kpf_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Zo um bâbâ lolot buŋâ. Kâtigem ândibi. Kaapumgât op umziŋâ zaatpap. Yatâ op um bâbâlaŋ op Kembu kore okŋaŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Kembuŋâ sumbemgât siŋgi kwatziŋgip, zorat sâtâre op ândibi. Sâknam muyageziŋgi zorat sâm âkon mân upi. Um bâbâlaŋ op âsâbâŋ ninâu sâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Kembugât kâmurân gokŋâ nâmbutŋâ zen kut ŋâi ŋâi kârum ândine betziŋan mimbi. A lombaŋâ zeŋgâren gane kiaŋ kubik zâmbanbi. ");
INSERT INTO kpf_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Kâsaziŋ sâm bâliŋ kwatziŋgâne zeŋgoot mâsop den sâm dâzâŋgobi. Lâuziŋan gâbâ sâit den buŋâ, mâsop denâk gibap. ");
INSERT INTO kpf_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","A nâmbutŋandâ sâtâre utne zen yatik târokwatziŋgâm upi. Umbâlâ op isene zen yatik târokwatziŋgâm isebi. ");
INSERT INTO kpf_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Umziŋ mâpotne kânogâk zei ândibi. Ziiŋaŋgât nâŋgane zâizâiŋ mân upap. Nâŋgânâŋgâziŋaŋgât nâŋgâne zâizâiŋ mân upap. Oi zen a gigiŋâ buku otziŋgâbi. ");
INSERT INTO kpf_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Ŋâi zâk kut bâliŋ otgigi hâuŋâ mân okŋaŋgâban. A ziŋ mân orotŋâ otziŋgâne buku otziŋgâbi. Zen yatâ op ândim a ziŋ zeŋgât nâŋgâne âlip ŋâi upapkât nâŋgâmŋik upi, ");
INSERT INTO kpf_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Zen a pisuk patâ zen sot lumbeŋâ op ândibigât kâtigibi. A ziŋ kâsa otziŋgâne lumbeŋâ den sâm dâzâŋgobi. ");
INSERT INTO kpf_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Bukurâpnâ, a ziŋ kut ŋâi mân orotŋâ otziŋgâne hâuŋâ mân otziŋgâbi. Hâukâu mân upi. Tosa zo Kembugât kukŋaŋgât siŋgi pane zimbap. Zorat Kembugât ekabân den ŋâi itâ ziap, “Kembuŋâ itâ sap, ‘Tosa mâkâmâkâŋ, zo nâgât nep. Hâuŋâ ziŋgâziŋgâŋ, zo ninak ziŋgâbat.’ Kembu zâk yatâ sap.” ");
INSERT INTO kpf_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Zen ko itâ upi. Kâsagâ nalemgât moi nalem pindâban. Toogât nâŋgi too pindâban. Gâ yatâ otnandâ kârâp kâukŋâ kwâkŋan pâna simbap yatâ upap. ");
INSERT INTO kpf_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Bâliŋandâ mân mem gei kwatgibap. Buŋâ. Gâ âlip op bâliŋâ mem gei kwâpan. ");
INSERT INTO kpf_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","A aksik patâ, zen hân a kutâ sot a sâtŋâ zeŋgât den lum ândibi. A kutâ nep, zo Anutugâren gokŋâ. Hân a kuta sot a sâtŋâ zen Anutugât sâtkât ândie. ");
INSERT INTO kpf_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Zorat ŋâi zâk a kutâ zeŋgât den birâm Anutugât den yatik birâbap. Oi den birâbi, zen yatik hâuŋâ mimbi. ");
INSERT INTO kpf_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Orot mâmeziŋ âlipŋâ zen a kutâ zeŋgât keŋgât mân upme. Bâliŋâ upme, zen ko a kutâ zeŋgât keŋgât upme. Zorat gâ keŋgât buŋ ândibâ sâm ândi mâmangâ kubikŋâ âlipŋâ op ândiban. Gâ yatâ otna a kutâŋâ gâgât nâŋgâgigi âlip upap. ");
INSERT INTO kpf_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Hân a kutâ, zen Anutugât kore a. Ziŋâ gâlem otginetâ âlip ândibangât sâm ziŋgip. Zen kâmbam hâuŋâ laŋ mân gâ gobi. A kutâ zen Anutugât kore a. Bâliŋ mâme zeŋgâren nep tuum hâuŋâ ziŋgâbi. Zorat gâ bâliŋ upan zo ko keŋgât upan. ");
INSERT INTO kpf_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","A kutâ zeŋgât dinziŋâ lum kwâtâtibi. Zo Anutu zâkkât keŋgârâk buŋâ. A kutâ dinziŋ luluŋaŋgât nâŋgindâ mâtâp âlip ŋâi opmap. Zorat op ko mâtâp zo lâŋ ândinat. ");
INSERT INTO kpf_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Anutuŋâ galem a sot a kutâ nep sâm ziŋgip, zen nep zo tumegât op kât zeŋgâren pame. ");
INSERT INTO kpf_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Zen kut ŋâi ŋâi sâsâŋ dâp otziŋgâbi. Kât sikumgât sâsâŋ, zo kât ziŋgâbi. Kore otziŋgâbigât sâsâŋ, zen kore otziŋgâbi. Hurat kwatziŋgâbigât sâsâŋ, zen hurat kwatziŋgâbi. Dinziŋ lubigât sâsâŋ, zen dinziŋâ lubi. ");
INSERT INTO kpf_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Kut ŋâi yenŋaŋgât tosa mâkâne âkâbap. Buku oraŋgâm ândibigât sâm ziŋgip, zorat buku orot zo mân birâne geibap. Ŋâi zâk a toren buku otziŋgâm ândimap, zâk gurumin den lum ândimap sâsâŋ. ");
INSERT INTO kpf_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Gurumin denân den itâ ziap, “Ap ambin zet mân birâyaŋgâm âbânaŋgâbabot. Gâ kâmbam mân kumban. Gâ kâmbu mân upan. A ŋâigât kut ŋâi laŋ mân mimban.” Zo sot den kâtik nâmbutŋâ mâpotŋâ kâukŋâ itâ sâsâŋ, “Gikaŋgât otgimap, zo yatik a torenŋâ zeŋgât otgibap.” ");
INSERT INTO kpf_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Buku op ândibapŋâ a ŋâi bâliŋâ mân oŋaŋgâbap. Zorat ŋâi zâk buku otziŋgâm ândibapŋâ gurumin den lum naŋgâbap sâsâŋ. ");
INSERT INTO kpf_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Zen narâk zirat topŋâ nâŋgâm ândie. Umanân gâbâ zaatpigât narâk mâte uap. Mârum siŋgi âlip topkwap nâŋgâwen, narâk zoren sumbemân zâinatkât narâk kârep zeip. Zi ko narâk pâŋkânok uap. ");
INSERT INTO kpf_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Mârum haŋsâbâmap, zorat ŋâtâtikkât orot mâme bâliŋâ zo birâm âsakŋaŋgât hâmbâ âmbum kâsaniŋ Sataŋ, zâkkât kâmut zen sot agom kinat. ");
INSERT INTO kpf_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Sirâmgât siŋgi op ŋâtâtikkât orot mâme bâliŋâ zo birâm târârak ândinat. Too kâtik nem umgulip orot sot laŋ ândiândiŋ sot um kâlak sot kuk sârek zo mân upi. ");
INSERT INTO kpf_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Kembu Yesu Kristo, zâk sot pâlâtâŋ op ândibi. Oi um sâkziŋan âkŋâle bâliŋâ muyagem bâliŋan diiziŋgâbâ sâi mân nâŋgâm kândâtkubi. ");
INSERT INTO kpf_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Siŋgi âlibân bâbâ lolot ândime, zen buku otziŋgâbi. Den topŋaŋgât sânetâ zen sot den sârek mân âragum um kânok ândibi. ");
INSERT INTO kpf_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","A nâmbutŋâ ziŋâ nâŋgâ kwâkâ buŋâ nalem top top nime. Oi a nâmbutŋandâ nalem nâmbutŋâ mân nime. Zen zuu bâu sunum mân nime. ");
INSERT INTO kpf_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Ŋâi zâk nalem top top nemapŋâ bukuŋâ nalem toren mân nemap, zâkkât nâŋgi gigiŋâ mân upap. Oi ŋâi zâk nalem nâmbutŋâ mân nemapŋâ bukuŋâ nalem top top nemap, zâkkât nâŋgi mân bâliŋ upap. Wangât, zen Anutugât ayâk, zorat. ");
INSERT INTO kpf_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Zorat itâ sa nâŋgânek. Gâ wangandâ a ŋâigât kore a den dukunandâ dâp upap? Kore a zâk kâtigibap mo loribap, zo patâŋaŋgât mâteŋan upap. Oi zâk mân loribap. Patâŋâ Anutu, zâkŋâ tângoi kâtigem kinbap. ");
INSERT INTO kpf_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Oi sirâmgât zo yatik a nâmbutŋandâ itâ nâŋgâme, “Sirâm kânok, zo Kembugât siŋgi.” Yatâ nâŋgâm kendon tapme. A nâmbutŋâ, ziŋ ko sirâmgât itâ sâme, “Sirâm zo tirik buŋâ. Sirâm aksik zen dâbâk.” Zorat nâ itâ sa nâŋgânek. Sirâm ŋâiŋâ mo ŋâiŋâ, yatâ mo yatâ upâ sâm, nâŋgâm kâtigem ândiban. Ka bukugoot den sârek mân âragubabot. ");
INSERT INTO kpf_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ŋâi zâk sirâm kânokkât nâŋgi zâizâiŋ oi kendon tâpmap, zo Kembugât op opmap. Oi a ŋâi zâk nalem top top nemap, zo Kembugât op nemap. Zâk Anutugâren sâiwap sâmŋâ nemap. Oi a ŋâi zâk nalem toren mân nemap, zâk Kembugât op opmap. Zâk Kembugâren sâiwap sâm dukumap. ");
INSERT INTO kpf_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Âlip nâŋgen. Neŋgâren gâbâ ŋâiŋâ dap yatâ Kembu sot bukurâp, zeŋgât mân nâŋgânâŋgâ op zikŋaŋgârâk nâŋgâm ândibap? Oi dap op zikŋaŋgârâk nâŋgâm mumbap? Nen Anutugât siŋgi op ândimen sot mumen. ");
INSERT INTO kpf_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Ândiândi, zo Kembugât op ândimen. Mumu, zo Kembugât op mumen. Zorat ândinat mo munat, zo Kembugât siŋgi op utnat. ");
INSERT INTO kpf_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Zorat op Kristoŋâ mumuŋâ sot gwâlâ ârândâŋ kembu otniŋgâbapkât momŋâ mumuŋan gâbâ zaarip. ");
INSERT INTO kpf_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Kristo zâk Kembu patâniŋ ândiap. Zorat den ŋâi mâsikâziŋga dâtnonek, “Gâ wangandâ bukugaŋgât den sâm kwâkâban? Mo gâ wangandâ bukugaŋgât nâŋgâna gigiŋ upap?” Nen aksik patâ Kembugât mâteŋan kirindâ neŋgât den sâm kwâkâbap. ");
INSERT INTO kpf_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Kembugât ekabân den ŋâi itâ kulemgune ziap, “Kembuŋâ itâ sap, ‘Nâ ândim kwâtâtemangât a aksik patâ kinnâ topŋan gam siminiziŋ lim kwap pindiŋsânibi. Oi aksik patâ zen lâuziŋandâ sâm âlip kwatnibi.’” ");
INSERT INTO kpf_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Zorat nen nâŋgen. Ŋâran nen aksik patâŋâ Anutugâren pindiŋsâm topniŋ sânatkât sâm niŋgip. ");
INSERT INTO kpf_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Zorat op ko nen buku zeŋgât den hâuŋâ mân sâm kwâkânat. Buŋâ. Nen itâ utnat. Nen buku nâmbutŋâ umgulip kwatziŋgindâ Kembugât mâtâp walâbegât op nâŋgâmŋik ândinat. ");
INSERT INTO kpf_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Nâ Kembu Yesu sot pâlâtâŋ op ândimanŋâ itâ nâŋgâm kwâtâtian. Nalem ŋâi mo ŋâi neindâ sumun upap, zo mân ziap. Ka ŋâi zâk nalem laŋ nem sumunkubat sâm laŋ nimbap, zâk perâkŋak um sumun upap. ");
INSERT INTO kpf_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Oi itâ nâŋgan. Gâ nalem ŋâi nena bukugandâ gekŋâ nâŋgi mân dâp upap zo ko bukugoot buku mân op ândiban. Buŋâ. Gâ yatâ op bukugâ tâmbetkuban yatâ upap. Bukugâ âlip upapkât Kristoŋâ zâkkât op moip. Gâ zorat nâŋgâm bukugâ nalemgât op mân tâmbetkuban. ");
INSERT INTO kpf_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Zen kut ŋâi orotŋaŋgât nâŋgâne âlip oi zo op ândibi. Ka a nâmbutŋandâ sâm bâliŋ kwatziŋgâbegât galem oraŋgâm ândibi. ");
INSERT INTO kpf_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Anutugât um topŋan ândiândiŋ, zo dap yatâ? Zo sii nalem nemŋik ândiândiŋ? Buŋâ. Um hâlâlu sot um lumbeŋâ sot Tirik Kaapumgâren gâbâ gâi sâtâre op ândiândiŋ, zorâŋâ bonŋâ. ");
INSERT INTO kpf_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","A zen yatâ zo ândim Kristo kore okŋaŋgânetâ Anutuŋâ ziŋgiri âlip upap. Oi a ziŋâ zeŋgât nâŋgâne dâp upap. ");
INSERT INTO kpf_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Oi zorat nen um kânok op tânagom ândinatkât kâtiginat. ");
INSERT INTO kpf_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Gâ nalemgât opŋâ Anutugât nep mân tâmbetkuban. Sii nalem aksik zo âlipŋik. Ka ŋâi zâk nemŋâ nâmbut tâmbetzâŋgobapkât nep tuubap, yatâ nâŋgâm nei bâliŋ upap. ");
INSERT INTO kpf_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Gâ bukugâ kâsa okŋaŋgâbatkât zâkkât op nalem, waiŋ too mo wan wan zo birâna dâp upap. ");
INSERT INTO kpf_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Gâ kut yatâ zo orotŋaŋgât um salek ziap, zo Anutu mâteŋan mem ândina gikanâk zimbap. Zorat ŋâi zâk nalem nemap mo kut ŋâi ŋâi opmap, zorat um zâgât mân upap. Sâtâreŋoot upap. ");
INSERT INTO kpf_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ŋâi zâk um zâgât op nalem nei bâliŋ upap. Zâk nâŋgâ kwâkâ op laŋ nei bâliŋ upap. Wangât, zâk nâŋgâm pâlâtâŋ kwâkŋan mân uap, zorat. Kut ŋâi zo mo zo nâŋgâm pâlâtâŋ kwâkŋan mân oindâ tosaŋoot upap. ");
INSERT INTO kpf_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Kâtigem kin bâbâ lolot zo âkom diiziŋgânat. Oi nen niiŋaŋgârâk nâŋgânâŋgâyân mân ândinat. ");
INSERT INTO kpf_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Nen bukurâpniŋ zeŋgât nâŋgâm ândim âlip upi sot siŋgi âlibân kâtigibigât betziŋan minat. ");
INSERT INTO kpf_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kristo zâk yatik zikŋaŋgât nâŋgânâŋgâ mân ândeip. Zorat Kembugât ekabân den kulem ŋâi itâ ziap, “Kembu, gâ sâm bâliŋ kwatgiwe. Zeŋgât sâm bâliŋâ zo nâgâren zariap.” ");
INSERT INTO kpf_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Mârumŋan den sâm Kembugât ekabân kulemguwe, zo nen siŋgi âlip top nâŋgânatkât urâwe. Den zorâŋ mem kâtikŋan kwatniŋgi kut ŋâi siŋgi kwatniŋgip, zorat um bâbâlaŋ op nâŋgânâŋgâ ândinatkât kulemguwe. ");
INSERT INTO kpf_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Zeŋgât op Kembugâren itâ sâm ninâu sâman, “Mem kâtikŋan kwatniŋgâmap, um bâbâlaŋ orotŋaŋgât mariŋâ, zâkŋâ diiziŋgi Yesu Kristogât op um kânok op ândibi. ");
INSERT INTO kpf_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Oi umziŋ sot lâuziŋ mindui Kembuniŋâ Yesu Kristo, zâkkât Ibâŋâ Anutu mâpâsem sâm âlip kwâkŋaŋgâbi.” Zen yatâ upigât Kembugâren ninâu sâman. ");
INSERT INTO kpf_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Zorat op Anutu sâm âlip kwâkŋaŋgâbigât Kristoŋâ umŋandâ gâsuziŋgip. Oi zen yatigâk umŋâ gâsâyagom ândibi. ");
INSERT INTO kpf_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Nâ itâgât dâzâŋguan. Anutuŋâ sâkurâpniŋâ kut ŋâi ŋâi ziŋgâbapkât siŋgi den dâzâŋgoip, zo bon upapkât Kristo zâk Yuda a neŋgât kore a op ândeip. ");
INSERT INTO kpf_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Oi Anutuŋâ hân ŋâin gok zen tânzâŋgoi sâm âlip kwâkŋaŋgâbigât yatâ oip. Zorat Kembugât ekabân den kulem ŋâi itâ ziap, “O Kembu, nâ hân ŋâin gok zeŋgâren sâm âlip kwatgim kep mimbat.” ");
INSERT INTO kpf_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Oi den ŋâi itâ ziap, “Hân ŋâin gokŋâ, zen Anutugât kâmut zen sot sâtâre upi.” ");
INSERT INTO kpf_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Oi den ŋâi itâ ziap, “Hân ŋâin gok, zen aksik Kembu sâm âlip kwâkŋaŋgâbi. A hânŋâ hânŋâ, zen zâk sâm âlip kwâkŋaŋgâbi.” ");
INSERT INTO kpf_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Oi Propete Yesaiaŋâ den ŋâi itâ kulemgoip, “Nak tâtopŋan kâmŋâ, Yesegât kiun, zo takâm, zâk a hânŋâ hânŋâ zeŋgât kembu patâ op kembu otziŋgâbap. Oi hân ŋâin gokŋâ zen zâkkâren nâŋgâm pâlâtâŋ kwâkŋaŋgâbi.” ");
INSERT INTO kpf_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Nâ zeŋgât op ninau sâm itâ sâman. “Nâŋgâm pâlâtâŋgât mariŋâ, Anutu, zâkŋâ diiziŋgi nâŋgâm pâlâtâŋ kwâkŋaŋgâm lummbeŋâ op sâtâre kwâkŋan ândibi. Yatâ op ândine Tirik Kaapumŋâ imbaŋâ ziŋgi bet muyagibap, zorat nâŋgâm um bâbâlaŋ op ândibi.” Zeŋgât nâŋgâm yatâ ninâu sâman. ");
INSERT INTO kpf_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Bukurâpnâ, zeŋgât nâŋga âlip uap. Zen âlip ândim siŋgi âlipkât topŋâ nâŋgâme. Oi siŋgi âlip ziiŋak âragunâ sâm mân kwakpi. ");
INSERT INTO kpf_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Oi nâ Anutuŋâ nep sâm nigipkât den nâmbutŋâ keŋgât buŋ dâzâŋgom kulemgum ziŋgan. Zen siŋgi âlip nelâmzâŋgobapkât kulemgum ziŋgan. ");
INSERT INTO kpf_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Yesu Kristo, zâkŋâ nâ um kâtik siŋgi âlip dâzâŋgobatkât kore a nâbarip. Kembugât tirik namâ gâlem a ziŋ Kembu kore okŋaŋgâme. Oi nâ zo yatik Kembu kore okŋaŋgâm siŋgi âlip a um kâtik dâzâŋgoman. Nâ Anutugât siŋgi âlip nep tuuga Tirik Kaapumŋâ um hâlâlu kwatziŋgi Kembugât siŋgi op ândibi. ");
INSERT INTO kpf_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Nâ Yesu Kristo sot pâlâtâŋ op Anutu kore okŋaŋgâm nep zo tuuman, zorat nâŋgâm sâtâre opman. ");
INSERT INTO kpf_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Nep zo ninak mân tuubam yatâ. Yesu Kristoŋâ mam otnigi a hân ŋâin gokŋâ zen siŋgi âlip nâŋgâm lubigât lâunandâ sot bitnandâ nep tuuwan. Yesu Kristoŋâ mân mam otnigi nep tuuwan sâi ko dap yatâ sâm sâtâre sâbam? ");
INSERT INTO kpf_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Nâ Tirik Kaapumgâren gâbâ imbaŋâ mem Yerusalem kamânân gâbâ topkwap kulem sot sen mârât tuum âim Kristogât siŋgi âlip pisuk, zo a hân dâp dâzâŋgom aria Ilurikoŋ hânân âi âkip. ");
INSERT INTO kpf_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Oi a nâmbut ziŋ tuuweyân tuubamgât Kristogât kut siŋgi mân arip, zoren uŋakŋan âibatkât otnigip. ");
INSERT INTO kpf_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Kembugât ekabân den kulem ŋâi itâ ziap, zorat dâp opman, “Kembugât den siŋgiŋâ mân dâzâŋgowe, zen zo nâŋgâbi. Oi siŋgiŋâ mân nâŋgâwe, zen topŋâ nâŋgâbi.” ");
INSERT INTO kpf_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Nâ yatâgât Roma kamânân gokŋâ zeŋgâren gâbam narâk dâp kwakman. ");
INSERT INTO kpf_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ândim gâwan, zo zeŋgâren gâbat sâm umnandâ nâŋgâm ândiwan. Zi ko hân torengen zi nep tuuman, zo âkap. ");
INSERT INTO kpf_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Zorat Sipen hânân âibam zeŋgâren gâbatkât nâŋgan. Ga zen sot tâtat mâme op ko umâlip op a nâmbutŋandâ zeŋgâren gâbâ betnan sâne Sipen hânân âinat. ");
INSERT INTO kpf_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Kândom nârâk ziren ko Anutugât siŋgi a kât betziŋan mimbam Yerusalem kamânân âibâman. ");
INSERT INTO kpf_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Makedonia sot Grik hânân Kembugât kâmut ziŋ Yerusalem kamânân Kembugât siŋgi a nâmbutŋâ kanpitâ ândie, zen kât betziŋan minam sâm kâtigiwe. ");
INSERT INTO kpf_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Zen um bâlâlaŋ op kât mindunetâ dâp oip. Wangât, hân ŋâin gokŋâ zen Yuda a zeŋgâren gâbâ siŋgi âlip miwe, zorat tosa zeŋgâren ziap. Oi tosa zo mâkâbigât sâkkât kut ŋâi ŋâi ziŋgâne dâp upap. ");
INSERT INTO kpf_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Den zo bon oi ninak mem âim Yerusalem kamânân ziŋgâmŋâ âburem Roma kamân mâirâp zeŋgâren gâbat. Zeŋgâren ga tapŋâ Sipen hânân âibat. ");
INSERT INTO kpf_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Nâ it nâŋgan. Nâ zeŋgâren gâbam bet bâsaŋ mân gâbat. Kristogâren gâbâ mâsop den yâmbâtŋâ mem ga ziŋgâbat. ");
INSERT INTO kpf_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Bukurâpnâ, nâ Kembuniŋâ Yesu Kristo, zâkkât op sot Kaapumŋâ buku orotŋaŋgât den umniŋan pâmapkât kindap pâroŋ den dâzâŋgobâ. Zen nâgât op Anutugâren doŋbep ninâu sâbi. ");
INSERT INTO kpf_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Betnan mine Yudaia hânân Yuda a bitziŋan gâbâ mâkânibap. Oi Yerusalem kamânân Kembugât siŋgi a kut zo ziŋga umâlep upi. ");
INSERT INTO kpf_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Zorâŋâ bet Anutuŋâ nâŋgi umâlibân zeŋgâren gam zen sot tap umnâ sânduksâbap. ");
INSERT INTO kpf_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Um lumbe mariŋâ, Anutu, zâk aksik patâ zen sot ândibap. Zo perâkŋak. ");
INSERT INT