﻿USE sofia;
DROP TABLE IF EXISTS sofia.kos_vpl;
CREATE TABLE kos_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kos_vpl WRITE;
INSERT INTO kos_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ke mutawauk, ke God El orala kusrao, faclu, ac ma nukewa, ");
INSERT INTO kos_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","faclu wangin lumah ac wangin koano. Lohsr matoltol afunla acn loal uh, ac Ngun lun God apisya fin kof uh. ");
INSERT INTO kos_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Na God El fahk, “Lela in oasr kalem” — ac kalem uh sikyak. ");
INSERT INTO kos_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","God El insewowo ke ma El liye. Na El sraclik kalem liki lohsr uh, ");
INSERT INTO kos_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ac El pangon kalem uh “Len,” ac lohsr uh “Fong.” Ke safla eku sac na lotutang sikme — pa ingan len se emeet. ");
INSERT INTO kos_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ac God El fahk, “Lela in oasr sie lisrlisr inmasrlon kof uh, in sraclik kof uh liki kof uh.” ");
INSERT INTO kos_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ouinge God El orala lisrlisr se ac sraclik kof ma oan ye lisrlisr sac liki kof ma oan lucng liki lisrlisr sac. Na orekla oana. ");
INSERT INTO kos_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","God El pangon lisrlisr sac “Yen engyeng uh.” Ke safla eku sac na lotutang sikme — pa ingan len se akluo. ");
INSERT INTO kos_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Na God El fahk, “Lela kof ye acn engyeng uh in tukeni nu ke sie acn, tuh acn pao uh fah sikyak” — na orekla oana. ");
INSERT INTO kos_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","El pangon acn pao uh “Faclu,” ac kof ma toeni nu sie uh El pangon “Meoa.” Ac God El liye ma El orala tuh na wo. ");
INSERT INTO kos_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Na El fahk, “Lela faclu in akkapye kain in mah nukewa ac kain in sak nukewa — na sikyak oana. ");
INSERT INTO kos_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ouinge faclu akkapyauk kain in sak nukewa, ac God El liye ma El orala tuh na wo. ");
INSERT INTO kos_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ke safla eku sac na lotutang sikme — pa ingan len se aktolu. ");
INSERT INTO kos_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Na God El fahk, “Lela mwe kalem uh in sikyak yen engyeng uh in sraclik len liki fong, ac in akkalemye pacl in mutawauk lun len, yac, ac pacl in akfulat, ");
INSERT INTO kos_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ac elos fah kalem inkusrao me ac tolak fin faclu” — ac ouinge orekla oana. ");
INSERT INTO kos_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ouinge God El orala kalem luo ma yohk uh: faht in leumi len, ac malem in leumi fong; El oayapa orala itu uh. ");
INSERT INTO kos_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","El oakiya kalem inge inkusrao in tolak fin faclu, ");
INSERT INTO kos_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","in karingin len ac fong, ac in sraclik kalem liki lohsr. Ac God El liye ma El orala tuh na wo. ");
INSERT INTO kos_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ke safla eku sac na lotutang sikme — pa ingan len se akakosr. ");
INSERT INTO kos_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Na God El fahk, “Lela inkof uh in nwanala ke kain in ma moul puspis, ac lela yen engyeng uh in sessesla ke won.” ");
INSERT INTO kos_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ouinge God El orala ma moul lulap in meoa uh, kain in ma moul nukewa ma muta inkof uh, ac kain in won nukewa. Ac God El liye ma El orala tuh na wo. ");
INSERT INTO kos_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","El akinsewowoyalos nukewa ac fahk nu sin ma moul ma muta inkof uh elos in isus ac nwakla meoa, ac El fahk nu sin won in kapak ac puseni. ");
INSERT INTO kos_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ke safla eku sac na lotutang sikme — pa ingan len se aklimekosr. ");
INSERT INTO kos_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Na God El fahk, “Lela faclu in oswe kain in ma orakrak nukewa; ma muna ac ma lemnak, yohk ac srik” — na orekla oana. ");
INSERT INTO kos_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ouinge God El oralosla nukewa, ac El liye ma El orala tuh na wo. ");
INSERT INTO kos_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Na God El fahk, “Inge kut ac fah oru mwet uh: elos ac oana kut ac lumahlos ac oana lumasr. Ac fah oasr ku yorolos fin ik, won, ac ma orakrak nukewa, ma muna ac ma lemnak, ma yohk ac srik.” ");
INSERT INTO kos_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ouinge God El orala mwet uh, ac oralosla oana lumahl. El oralosla mukul ac mutan, ");
INSERT INTO kos_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ac akinsewowoyalos, ac fahk, “Kowos in isus fahko in pus, tuh fwilin tulik nutuwos fah fahsrelik nu fin faclu nufon ac leumi ma inge. Nga filikowosi in karingin ma moul nukewa inkof uh, won yen engyeng uh, ac ma orakrak nukewa ma moul fin faclu.” ");
INSERT INTO kos_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Na God El fahk, “Nga akoela kain in mahsrik nukewa ac kain in fokinsak nukewa kowos in mongo kac, ");
INSERT INTO kos_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","a nu sin ma orakrak nukewa ac nu sin won nukewa nga akoela mah ac sra sak nu selos” — na orekla oana. ");
INSERT INTO kos_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God El liye ma nukewa ma El orala tuh na wo. Ke safla eku sac na lotutang sikme — pa ingan len se akonkosr. ");
INSERT INTO kos_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ouinge faclu ac kusrao ac ma nukewa loac aksafyeyukla. ");
INSERT INTO kos_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ke len se akitkosr, God El aksafyela ma El oru ac mongla liki orekma lal. ");
INSERT INTO kos_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","El akinsewowoye len se akitkosr, ac srela tuh in sie len mutal, mweyen El aksafyela ma nukewa El oru ac tui ke orekma lal. ");
INSERT INTO kos_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Pa ingan luman orekla lun kusrao ac faclu ac ma nukewa loac. Ke LEUM GOD EL kusrao ac faclu, ");
INSERT INTO kos_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","wangin sak fin faclu ac wangin mah srunak, mweyen El soenna supwama af, ac wangin mwet in imai acn uh. ");
INSERT INTO kos_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tusruktu kof uh otyak liki ye fohk uh ac aksroksrokye infohk uh. ");
INSERT INTO kos_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Na LEUM GOD El eis kutu fohk liki infohk uh ac lumahla mwet se kac. El mongyang nu infwen mwet sac ke momong in moul, ac mwet sac moul. ");
INSERT INTO kos_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Na LEUM GOD El orala ima se in Eden, layen kutulap, ac filiya mwet se El orala inge we. ");
INSERT INTO kos_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","El oru tuh kain in sak kato nukewa in kap we ac oswe fokinsak na wowo. Ac infulwen ima uh, oasr pac sak soko tu we ma ac sang moul nu sin mwet uh, ac oayapa oasr sak soko ma ac sang etauk ke ma wo ac ma koluk. ");
INSERT INTO kos_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Infacl srisrik soko soror in Eden ac aksroksrokye ima sac, ac ke alukela acn Eden sengelik nu ke infacl akosr. ");
INSERT INTO kos_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Infacl soko meet ah pa Pishon, su soror rauni acn Havilah. ");
INSERT INTO kos_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Gold na pwaye ac oayapa ono keng ma sesa, ac eot saok koneyukyak we.) ");
INSERT INTO kos_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Infacl soko aklukwa pa Gihon, su soror rauni acn Cush. ");
INSERT INTO kos_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Infacl soko aktolkwe pa Tigris, su soror ut kutulap in Assyria, ac infacl soko akakosr pa Euphrates. ");
INSERT INTO kos_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Na LEUM GOD El filiya mwet sac in ima Eden tuh elan yukwi ac karingin. ");
INSERT INTO kos_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","El fahk nu sel, “Kom ku in mongo ke fokinsak ke kutena sak in ima se inge, ");
INSERT INTO kos_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","sayen sak soko ma asang etauk ke ma wo ac ke ma koluk. Kom fah tia kang fokin sak soko ingan. Kom fin kang, kom ac misa ke len sacnna.” ");
INSERT INTO kos_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Na LEUM GOD El fahk, “Tia wo mukul se inge in mukena muta. Nga ac oru sie mwet in welulang in kasrel.” ");
INSERT INTO kos_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ouinge el eis kutu fohk liki infohk uh, ac lumahla kain in kosro nukewa ac kain won nukewa. Na El usalosla nu yurin mwet sac elan sang inelos. Ouinge itukyang inen ma inge nukewa. ");
INSERT INTO kos_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ke ma inge mwet sac sang inen won nukewa ac kosro nukewa, tusruktu wanginna inmasrlolos fal in welulang in kasrel. ");
INSERT INTO kos_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Na LEUM GOD El oru mwet sac in motul folosuwosla, ac pacl se el motul inge El eisla soko sri in pap kacl ac sifil folokoneni ikwal. ");
INSERT INTO kos_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","El orala mutan se liki sri in pap soko ah, ac usalu nu yurin mukul sac. ");
INSERT INTO kos_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Na mukul sac fahk, “Tufahna pa inge sie su oana nga — Srel itukla liki srik, ac ikwal liki ikok. Ac pangpang el ‘mutan,’ mweyen itukla el liki sie mukul.” ");
INSERT INTO kos_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Pa ingan sripa se oru sie mukul el som liki papa tumal ac nina kial, ac fulyang nu sin mutan kial, ac eltal ma sefannala. ");
INSERT INTO kos_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mukul sac ac mutan sac kewana koflufol, tusruktu eltal tiana mwekin. ");
INSERT INTO kos_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Na serpent pa kutasrik oemeet ke ma orakrak nukewa ma LEUM GOD El orala. El siyuk sin mutan sac, “Ku pwayena God El fahk mu kom in tiana kang kutena fokinsak in ima se inge?” ");
INSERT INTO kos_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ac mutan sac fahk, “Kut ku in kang kutena fokinsak in ima se inge ");
INSERT INTO kos_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","sayen sak soko ma tu infulwen ima uh. God El fahk nu sesr mu kut in tiana kang fokin sak soko ah, ac kut in tia pacna pusral. Kut fin oru, kut ac misa.” ");
INSERT INTO kos_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Na serpent el fahk, “Tia pwaye. Kom ac tia misa. ");
INSERT INTO kos_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","God El fahk angan mweyen El etu lah pacl se na komtal kangla an, komtal ac oana God in etu lah mea wo ac mea koluk.” ");
INSERT INTO kos_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mutan sac liye lah sak soko ah arulana kato, ac fahko kac uh luman ac arulana wo ke mongo, ac el sifilpa nunku lah ac fuka woiya in lalmwetmet. Ke ma inge el eis kutu fahko kac ac kangla. Na el sang kutu nu sin mukul tumal, ac el kangla pac. ");
INSERT INTO kos_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tukunna eltal kangla ah, na itukyang nu seltal etauk, ac eltal akilenak lah eltal koflufol. Ouinge eltal etolla sra ke sak fig ac sang afunultal uh. ");
INSERT INTO kos_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","In eku sac, eltal lohng ke LEUM GOD El forfor in ima sac, ac eltal wikla lukel inmasrlon sak uh. ");
INSERT INTO kos_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ac LEUM GOD El pangon mukul sac ac fahk, “Kom aya?” ");
INSERT INTO kos_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ac mukul sac fahk, “Nga lohng kom inima uh, a nga sangeng ac wikla liki kom, mweyen nga koflufol.” ");
INSERT INTO kos_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","God El siyuk, “Su fahk nu sum mu kom koflufol an? Ya kom kang fokinsak soko ma nga tuh fahk mu komtal in tia kang ah?” ");
INSERT INTO kos_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mukul sac fahk, “Mutan se kom filiya yuruk inge tuh se nu sik fokinsak soko ah, ac nga kangla.” ");
INSERT INTO kos_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","LEUM GOD El siyuk sin mutan sac, “Efu ku kom oru angan?” Mutan sac topuk ac fahk, “Serpent soko ah kiapweyula, oru nga kangla.” ");
INSERT INTO kos_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Na LEUM GOD El fahk nu sin serpent soko ah, “Ke sripen kom orala ma se inge, ac fah kalyeiyuk kom. Kom mukena sin ma orakrak nukewa ac fah eis selnga se inge: Ingela kom fah orak ke siom, ac kom ac fah mongo kutkut in moul lom nufon. ");
INSERT INTO kos_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nga fah oru tuh kom ac mutan se inge in arulana akwasui. Tulik natul ac tulik nutum ac fah alokoaloki pacl nukewa. Fahko lal ac fah futungya sifom, ac kom ac fah ngalisya kapin nien tulik natul.” ");
INSERT INTO kos_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ac El fahk nu sin mutan sac, “Nga ac fah akyokye mwe elya lom ke pitutu lom, ac akyokye ngal lom ke kom ac isus. Finne ouinge, a ac fah srakna oasr kena lom nu sin mukul tomom, ac el ac fah leum fom.” ");
INSERT INTO kos_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ac El fahk nu sin mukul sac, “Kom tuh wela pusren mutan kiom, ac kangla fokinsak su nga wili nu sum in tia kang. Ke sripen ma kom oru inge, fohk uh ac fah selngawiyuki. Kom fah orekma upa in moul lom nufon in oru tuh fohk uh in ku in asot mwe mongo fal nu sum. ");
INSERT INTO kos_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Fohk uh ac fah oswe mah wangin sripa ac mah oasr otoh, ac kom fah kang sak ma kap wel inimae. ");
INSERT INTO kos_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kom fah fio in kemkatu lom in akwoyela fohk uh tuh in ku in oswe kutena mwe mongo, nwe ke na kom folokla nu ke fohk su kom orekla kac. Kom tuh orekla ke fohk uh, ac kom ac fah sifilpa ekla nu ke fohk.” ");
INSERT INTO kos_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam el sang inen mutan kial Eve, mweyen el nina kien mwet moul nukewa. ");
INSERT INTO kos_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ac LEUM GOD El orek nuknuk lal Adam ac mutan kial ke kulun kosro, ac El nokmultalang. ");
INSERT INTO kos_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Na LEUM GOD El fahk, “Inge mwet se inge el ekla oana sie sesr, ac oasr etauk lal ke ma wo ac ke ma koluk.” Enenu in tia filfilla nu sel in eis fahko ke sak su sang moul, tuh elan kang ac moul nwe tok. ");
INSERT INTO kos_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ouinge LEUM GOD El supwalla liki Ima Eden ac oru elan pikin fohk uh su el orekla kac. ");
INSERT INTO kos_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Na ke layen kutulap in ima sac, El likiya cherub luo ac sie cutlass firir su pitukot pitukme nu yen nukewa. Ma inge ma in taran tuh kutena mwet in tia tuku apkuran nu ke sak in sang moul. ");
INSERT INTO kos_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Na Adam el ona yurin mutan kial, ac mutan sac pitutuyak. El oswela wen se ac fahk, “LEUM GOD El kasreyu ac se wen se nutik.” Ouinge el sang inel Cain. ");
INSERT INTO kos_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Tok el oswela pac wen se, Abel. Abel el mwet liyaung sheep, a Cain el mwet ima se. ");
INSERT INTO kos_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","In kutu pacl tok, Cain el use kutu fokin ima lal, ac sang tuh in mwe kisa nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Na Abel el use sheep fusr soko ma osweyukla oemeet sin soko sheep natul. El uniya ac sang ip ma wo emeet kac in mwe kisa. LEUM GOD El insewowo sel Abel ac ke mwe kisa lal, ");
INSERT INTO kos_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","a El tia insewowo sel Cain ac mwe kisa lal. Cain el arulana foloyak, ac ngetnget toasr ke kasrkusrak lal. ");
INSERT INTO kos_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Na LEUM GOD El fahk nu sel Cain, “Efu ku kom kasrkusrak? Efu kom srasrol? ");
INSERT INTO kos_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kom funu oru ma wo, kom lukun israsr na. A ke koluk ma kom oru an, na ma koluk uh tawi kom na in sruokkomi. El kena leumi kom, tusruktu kom enenu in kutangulla.” ");
INSERT INTO kos_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Na Cain el fahk nu sel Abel, tamulel lal, “Fahsru kital som nu inima uh.” Ke pacl se eltal sun inima uh, na Cain el forang nu sel Abel ac unilya. ");
INSERT INTO kos_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","LEUM GOD El siyuk sel Cain, “El aya Abel, tamulel lom?” El topuk, “Nga nikin. Mea, nga mwet in liyaung tamulel luk uh?” ");
INSERT INTO kos_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Na LEUM GOD El fahk, “Efu ku kom oru ma na koluk se inge? Srahn tamulel lom pa wowoyak nu sik infohk uh me, oana sie pusra ma sukok foloksak. ");
INSERT INTO kos_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Inge kom oan ye sie selnga ac kom fah tia ku in sifilpa imai fohk uh. Fohk uh numwani srahn tamulel lom, oana sie oalu su mangelik soano in numla srahl ke pacl se kom unilya ah. ");
INSERT INTO kos_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kom fin srike in yok sacn, infohk uh ac fah tia oswe kutena ma. Ac fah wangin acn sum, ac kom fah forfor pukafukwel fin faclu.” ");
INSERT INTO kos_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ac Cain el fahk nu sin LEUM GOD, “Kalya se inge arulana upala nu sik. ");
INSERT INTO kos_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Kom lisyula liki acn uh in som loesla liki ye motom. Nga fah sie mwet wangin acn se, takusrkusr fin faclu, ac kutena mwet fin koneyuyak ac uniyuwi.” ");
INSERT INTO kos_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tusruktu LEUM GOD El fahk, “Mo. Mwet se fin unikomi, moul lun mwet itkosr fah itukla in aolkomla.” Ke ma inge LEUM GOD El filiya sie akul facl Cain in akesmakinye kutena mwet su sonol in tia unilya. ");
INSERT INTO kos_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ac Cain el som liki ye mutun LEUM GOD ac muta in acn se pangpang “Nod,” su oan kutulap in acn Eden. ");
INSERT INTO kos_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Oasr wen se natul Cain ac mutan kial, ac eltal sang inel Enoch. Na Cain el musaela siti se ac sang inen wen se natul ah nu kac. ");
INSERT INTO kos_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Oasr wen se natul Enoch, inel pa Irad, su papa tumal Mehujael. Ac wen se natul Mehujael pa Methushael, su papa tumal Lamech. ");
INSERT INTO kos_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Oasr mutan luo kial Lamech, eltal pa Adah ac Zillah. ");
INSERT INTO kos_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah el oswella Jabal, su papa matu tumun mwet tohf kosro ac muta in lohm nuknuk. ");
INSERT INTO kos_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Tamulel se lal Jabal pa Jubal, ac el papa tumun mwet orek on nukewa su srital ke mwe on harp ac flute. ");
INSERT INTO kos_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah el oswella Tubal Cain, sie mwet su oru kain in kufwen sroasr nukewa ke osra bronze ac iron. Tamtael se lal Tubal Cain pa Naamah. ");
INSERT INTO kos_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamech el fahk nu sin mutan luo kial, “Adah ac Zillah, porongeyu: Nga uniya mwet fusr se mweyen el tuh puokyuwi. ");
INSERT INTO kos_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Moul lun mwet itkosr fin itukla in aol misa lal Cain, Na mwet itngoul itkosr ac fah itukla moul la, mwet se fin uniyuwi.” ");
INSERT INTO kos_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam ac mutan kial oswela sie pac wen. Na mutan sac fahk, “God El sifilpa ase wen se nutik in aolulla Abel, su Cain el uniya.” Ke ma inge el sang inel Seth. ");
INSERT INTO kos_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Oasr pac wen se natul Seth, ac el sang inel Enosh. In pacl sac me pa mwet uh mutawauk in orekmakin ine mutal lun LEUM GOD ke alu lalos. ");
INSERT INTO kos_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Pa inge takin fwilin tulik natul Adam. (Ke God El tuh orala mwet uh, El oralosla in lumahl. ");
INSERT INTO kos_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","El oralosla mukul ac mutan, ac akinsewowoyalos, ac sang inelos “Mwet.”) ");
INSERT INTO kos_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ke Adam el yac siofok tolngoul matwal, el oswela wen se oana el, ac el sang inel Seth. ");
INSERT INTO kos_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Tukun pacl sac, Adam el sifilpa moul yac oalfoko. Oasr pac tulik mukul ac tulik mutan saya natul, ");
INSERT INTO kos_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ac el misa ke el yac eufoko tolngoul. ");
INSERT INTO kos_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ke Seth el yac siofok limekosr, oasr wen se natul pangpang Enosh, ");
INSERT INTO kos_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ac toko el moul pac ke yac oalfoko itkosr. Oasr pac tulik saya natul, ");
INSERT INTO kos_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ac el misa ke el yac eufoko singoul luo. ");
INSERT INTO kos_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ke Enosh el yac eungoul, oasr wen se natul pangpang Kenan, ");
INSERT INTO kos_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","na toko el moul pac yac oalfoko singoul limekosr. Oasr pac tulik saya natul, ");
INSERT INTO kos_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ac el misa ke el yac eufoko limekosr. ");
INSERT INTO kos_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ke Kenan el yac itngoul, oasr wen se natul pangpang Mahalalel, ");
INSERT INTO kos_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","na toko el moul pac yac oalfoko angngaul. Oasr pac tulik saya natul, ");
INSERT INTO kos_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ac el misa ke el yac eufoko singoul. ");
INSERT INTO kos_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ke Mahalalel el yac onngoul limekosr, oasr wen se natul pangpang Jared, ");
INSERT INTO kos_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","na toko el moul pac yac oalfoko tolngoul. Oasr pac tulik saya natul, ");
INSERT INTO kos_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ac el misa ke el yac oalfoko eungoul limekosr. ");
INSERT INTO kos_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ke Jared el yac siofok onngoul luo, oasr wen se natul pangpang Enoch, ");
INSERT INTO kos_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","na toko el moul pac yac oalfoko. Oasr pac tulik saya natul, ");
INSERT INTO kos_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ac el misa ke el yac eufoko onngoul luo. ");
INSERT INTO kos_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ke Enoch el yac onngoul limekosr, oasr wen se natul pangpang Methuselah. ");
INSERT INTO kos_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Tukun pacl sac, Enoch el moul in sie sin sie yurin God ke yac tolfoko, ac oasr pac tulik saya natul. ");
INSERT INTO kos_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","El moul sun yac tolfoko onngoul limekosr. ");
INSERT INTO kos_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","El moul in sie sin sie yurin God, na el wanginla mweyen God El usalla. ");
INSERT INTO kos_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ke Methuselah el yac siofok oalngoul itkosr, oasr wen se natul pangpang Lamech, ");
INSERT INTO kos_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","na toko el moul pac yac itfoko oalngoul luo. Oasr pac tulik saya natul ");
INSERT INTO kos_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ac el misa ke el yac eufoko onngoul eu. ");
INSERT INTO kos_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ke Lamech el yac siofok oalngoul luo, oasr wen se natul, ");
INSERT INTO kos_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ac el sang inel Noah. Ac Lamech el fahk, “Tulik se inge ac fah use nu sesr mongla liki orekma upa nukewa lasr, liki fohk se na ma LEUM GOD El tuh filiya sie selnga nu kac.” ");
INSERT INTO kos_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Na toko Lamech el moul pac yac lumfoko eungoul limekosr. Oasr pac tulik saya natul ");
INSERT INTO kos_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ac el misa ke el yac itfoko itngoul itkosr. ");
INSERT INTO kos_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Tukun Noah el yac lumfoko matwal, oasr wen tolu natul pangpang Shem, Ham, ac Japheth. ");
INSERT INTO kos_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ke mwet uh fahsrelik nu yen nukewa faclu, ac oasr tulik mutan osweyukla, ");
INSERT INTO kos_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","kutu sin mwet lucng liyauk lah tulik mutan inge oasku, ouinge elos payukyak selos su elos lungse. ");
INSERT INTO kos_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Na LEUM GOD El fahk, “Nga fah tia fuhlela mwet uh in moul nwe tok — elos mano na sukawil. Ingela elos ac fah tia moul loes liki yac siofok longoul.” ");
INSERT INTO kos_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","In len ingo, aok finne kutu pacl toko, oasr mwet na lulap pisa fin faclu pangpang Nephilim, su ma nutin mutan faclu nu sin mukul lucng. Elos mwet na pwengpeng ac pulaik in pacl so. ");
INSERT INTO kos_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ke LEUM GOD El liye lupan koluk lun mwet nukewa fin faclu, ac lupan nunak koluk lalos ke pacl nukewa, ");
INSERT INTO kos_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","El arulana auli lah el oralosla ac fuhlelosi fin faclu. Yohk oela lal, ");
INSERT INTO kos_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","na El fahk, “Nga fah sukela mwet nukewa nga orala inge, wi ma orakrak ac won nukewa, mweyen yohk toasr luk lah nga oralosla.” ");
INSERT INTO kos_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tusruktu LEUM GOD El insewowo sel Noah. ");
INSERT INTO kos_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Pa inge sramsram kacl Noah ac fwilin tulik natul. Noah el moul in sie sin sie yurin God, ac el mukena moul suwohs ac wangin mwatal inmasrlon mwet nukewa in fwil lal. ");
INSERT INTO kos_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Oasr wen tolu natul Noah, inelos pa Shem, Ham, ac Japheth. ");
INSERT INTO kos_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tusruktu mwet nukewa sayal Noah arulana koluk ye mutun God, na lokoalok ac moul sesuwos apunla faclu. ");
INSERT INTO kos_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God El liye lah faclu arulana kolukla, mweyen moul lun mwet nukewa arulana koluk. ");
INSERT INTO kos_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","God El fahk nu sel Noah, “Nga wotela tari ngan kunausla mwet nukewa. Nga ac sukelosla nufon, mweyen faclu sessesla ke orekma koluk lalos. ");
INSERT INTO kos_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Musaela soko oak ah okom ke sak na wowo. Orala kutu fukil an loac, ac sroalela acn loac ac acn lik ke tar. ");
INSERT INTO kos_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Oru in fit angfoko lumngaul lusa, fit itngoul limekosr sralapa, ac fit angngaul limekosr fulata. ");
INSERT INTO kos_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Sunya oak uh, ac likiya sie masrol ma inch singoul oalkosr inmasrlon susu sacn ac sisken oak uh. Musai tuh in oasr twek tolu ac orala sie srungul an ke siska uh. ");
INSERT INTO kos_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nga ac supwama sie sronot ah nu faclu in kunausla ma nukewa ma oasr moul la. Ma nukewa fin faclu ac fah misa, ");
INSERT INTO kos_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","tusruktu nga ac orala sie wuleang inmasrlok kom. Utyak nu in oak uh wi mutan kiom, wen nutum, ac mutan kialos. ");
INSERT INTO kos_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Kom fah use kais lukwa ke kain in ma orakrak nukewa nu in oak uh, mukul se mutan se, in wi kom moulla. ");
INSERT INTO kos_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Nu ke ip lun won uh, in fal nu ke kain in won, ac nu ke kosro uh, in fal nu ke kain in kosro, ke ma orakrak nukewa in fohk uh, in fal nu ke kain in lumah — kais luo ke kain nukewa fah utyak nu yurum tuh elos fah moul. ");
INSERT INTO kos_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Us kain in mwe mongo nukewa in wi kom, ma ac fal nu sum ac nu selos.” ");
INSERT INTO kos_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noah el oru ma nukewa ma God El sapkin. ");
INSERT INTO kos_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","LEUM GOD El fahk nu sel Noah, “Utyak nu in oak uh wi sou lom nufon. Nga liye tuh kom mukena in faclu nufon pa oru ma suwohs. ");
INSERT INTO kos_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Us kais itkosr sianyan ke kain in kosro ma nasnas in wi kom, tusruktu kais lukwa na ke kain kosro saya ma tia nasnas. ");
INSERT INTO kos_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Oayapa us kais itkosr sianyan ke kain in won. Oru ouinge tuh kain in kosro ac won nukewa fah moul ac sifilpa isus fin faclu. ");
INSERT INTO kos_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Tukun len itkosr nga ac supwama af ma ac kahk ke len angngaul ac fong angngaul, in tuh kunausla ma nukewa ma oasr moul la ma nga orala.” ");
INSERT INTO kos_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ac Noah el orala ma nukewa ma LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noah el yac onfoko ke sronoti faclu. ");
INSERT INTO kos_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","El, mutan kial, wen natul ac mutan kialos sroang nu in oak uh in kaingla liki sronot uh. ");
INSERT INTO kos_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Mukul se ac mutan se ke kain kosro ac won nukewa, finne ma nasnas ku ma tia nasnas, ");
INSERT INTO kos_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","welul Noah utyak nu in oak uh, oana ke God El sapkin. ");
INSERT INTO kos_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Tukun len itkosr na sronot ah tuku. ");
INSERT INTO kos_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ke Noah el yac onfoko matwal, in len se aksingoul itkosr ke malem se akluo, unon in kof nukewa ke kof lulap ye faclu fokelik ac kof uh asrma, ac ikakelik inkusrao pac, ");
INSERT INTO kos_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ac af uh kahk nu fin faclu ke len angngal ac fong angngaul. ");
INSERT INTO kos_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ke len sacna, Noah ac mutan kial sroang nu in oak uh, wi wen tolu natultal, Shem, Ham, ac Japheth, ac mutan kialtal. ");
INSERT INTO kos_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Kain in kosro muna ac lemnak, yohk ac srik nukewa, ac kain in won nukewa welulos utyak nu in oak uh. ");
INSERT INTO kos_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Mukul se ac mutan se ke kain in ma moul nukewa welul Noah utyak nu in oak uh, ");
INSERT INTO kos_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","oana ke God El sap. Na LEUM GOD El kaleang srungul in oak uh. ");
INSERT INTO kos_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Sronot uh yokyokelik ke len angngaul, ac kof uh lapak nwe pahtkakunak oak uh. ");
INSERT INTO kos_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Kof uh loali, na oak ah pahtpat fin kof uh. ");
INSERT INTO kos_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Lapak nwe eol ma fulat oemeet uh afla pac. ");
INSERT INTO kos_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Sronot uh kiluk na nu lucng nwe ke na sun fit longoul limekosr lucng liki mangon eol fulat faclu. ");
INSERT INTO kos_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ma oasr moul la nukewa fin faclu misa — won nukewa, kosro nukewa, ac mwet nukewa. ");
INSERT INTO kos_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ma nukewa ma oasr momong la fin faclu misa. ");
INSERT INTO kos_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","LEUM GOD El kunausla ma moul nukewa faclu — mwet, kosro, ac won. Pwayena ma lula pa Noah, sou lal, ac ma nukewa su welul in oak uh. ");
INSERT INTO kos_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Kof uh tiana kiluk nu ten, nwe ke sun len aksiofok lumngaul. ");
INSERT INTO kos_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","God El tia mulkunulla Noah ac kosro nukewa ma welul in oak uh. El oru tuh sie eng in tuhyak, ac kof uh mutawauk in folok nu ten. ");
INSERT INTO kos_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Unon in kof ye faclu oayapa acn inkusrao kauli. Af uh tui, ");
INSERT INTO kos_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ac kof uh kakasrisrik folok nu ten ke len siofok lumngaul. ");
INSERT INTO kos_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ke len aksingoul itkosr in malem akitkosr, oak soko ah mwesia fin mangon soko sin eol in acn Ararat. ");
INSERT INTO kos_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Kof uh srakna folok nu ten, ac ke len se oemeet in malem aksingoul, mangon eol uh sikyak. ");
INSERT INTO kos_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Tukun len angngaul Noah el ikasla winto se ");
INSERT INTO kos_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ac supwala won raven se. Won sac tiana foloko, a el sohksokna raun nwe ke na mwesla na pwaye. ");
INSERT INTO kos_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ke won sac tiana foloko, Noah el supwala pac wuleoa se in liye lah sronot uh mwesla ku tia, ");
INSERT INTO kos_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","a ke sripen kof uh srakna afunla acn uh, wuleoa sac tiana konauk acn elan tuhwi we. Na el foloko nu ke oak uh, ac Noah el asroela paol ac oralma nu in oak uh. ");
INSERT INTO kos_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","El tupan len itkosr na el sifilpa supwala wuleoa sac. ");
INSERT INTO kos_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Wuleoa sac foloko ke ekela, ngalisya sra olive na sasu se. Ke ma inge Noah el etu lah mwesla tari. ");
INSERT INTO kos_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ac el sifilpa soano ke len itkosr, na sifilpa supwala wuleoa sac. Pacl se inge el tiana foloko. ");
INSERT INTO kos_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ke Noah el yac onfoko sie matwal, in len se oemeet in malem se meet, mwesla na pwaye sronot uh. Noah el ikasak ma sunyen oak uh, ngetot ngetma ac liye lah acn uh mutawauk in paola. ");
INSERT INTO kos_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ke len se aklongoul itkosr in malem se akluo, faclu paola na pwaye. ");
INSERT INTO kos_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","God El fahk nu sel Noah, ");
INSERT INTO kos_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Oatui liki oak an wi mutan kiom, wen nutum, ac mutan kialos. ");
INSERT INTO kos_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Us won ac kosro nukewa in wi kom tufoki liki oak uh, tuh elos fah ku in isus fahko ac fahsrelik fin faclu nufon.” ");
INSERT INTO kos_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ouinge Noah el illa liki oak uh, wi mutan kial, wen tolu natul ac mutan kialos. ");
INSERT INTO kos_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Kosro ac won nukewa oatula liki oak uh, fahsr in u fal nu ke kain in kosro ac won. ");
INSERT INTO kos_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah el musaela loang se nu sin LEUM GOD. El eis kais soko ke kain kosro ac won nasnas, ac fonna esukak tuh in mwe kisa fin loang uh. ");
INSERT INTO kos_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Foulin ma kisakinyuk inge akinsewowoye LEUM GOD, ac El fahk nu sel sifacna, “Nga fah tia sifil selngawi faclu ke sripen ma mwet uh oru. Nga etu lah nunak lalos nuna koluk na oe ke elos fusr ah me. Nga ac tia sifilpa kunausla ma moul nukewa, oana ke nga oru inge. ");
INSERT INTO kos_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ke lusenna pacl ma faclu se inge oasr uh, ac fah oasr na pacl in taknelik ac pacl in kosrani, pacl in ohu ac pacl in fusrfusr, fol ac mihsrisr, len ac fong.” ");
INSERT INTO kos_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","God El akinsewowoyal Noah ac wen tolu natul, ac fahk, “Kowos isusi, tuh fwilin tulik nutuwos fah puseni ac nwakla faclu nufon. ");
INSERT INTO kos_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Kosro ac won ac ik nukewa ac fah moul in sangeng suwos. Ma inge nukewa ac fah oan ye ku lowos. ");
INSERT INTO kos_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Inge kowos ku in kang ma inge, oapana fokin ma kapak inima uh. Nga sot ma inge nukewa nu suwos kowos in mongo kac. ");
INSERT INTO kos_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ma se na ma kowos fah tia kang uh pa ikwa ma srakna oasr srah kac, mweyen moul uh oasr ke srah uh. ");
INSERT INTO kos_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kutena mwet su eisla moul lun sie pac mwet, ac fah anwuki el. Kutena kosro ma eisla moul lun sie mwet, kalya nu sel pa misa. ");
INSERT INTO kos_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Mwet uh orekla in luman God, ke ma inge kutena mwet su akmuseya sie mwet fah anwuki pac sin mwet. ");
INSERT INTO kos_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Enenu in pukanten tulik nutuwos, tuh fwilin tulik nutuwos fah apunla fin faclu.” ");
INSERT INTO kos_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","God El fahk nu sel Noah ac wen tolu natul, ");
INSERT INTO kos_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Inge nga oru sie wulela inmasrlosr, ac oayapa yurin fwilin tulik nutuwos, ");
INSERT INTO kos_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ac yurin won nukewa ac kosro nukewa — ma nukewa ma wi kowos tufoki liki oak uh. ");
INSERT INTO kos_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ke kas inge nga ac oru wulela luk yuruwos: nga wulela mu wangin sie pacl nga ac sifilpa kunausla ma su oasr moul la ke sronot. Faclu ac fah tia sifilpa kunausyukla ke sronot. ");
INSERT INTO kos_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Pa inge mwe akpwaye nu ke wuleang kawil se su nga oru yuruwos ac yurin ma moul nukewa inge, ");
INSERT INTO kos_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","nga filiya lelakem luk in pukunyeng uh. Ac fah mwe akul ke wuleang se inmasrlok ac faclu nufon nwe tok. ");
INSERT INTO kos_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kutena pacl ma nga afinya kusrao ke pukunyeng ac lelakem uh sikyak, ");
INSERT INTO kos_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nga fah esam wuleang luk nu suwos ac nu sin kosro nukewa, lah sronot ac fah tia sifil kunausla ma nukewa ma oasr moul la. ");
INSERT INTO kos_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Pacl se lelakem uh sikyak in pukunyeng uh, nga ac fah liye ac esam wuleang kawil inmasrlok ac ma moul nukewa faclu. ");
INSERT INTO kos_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Pa ingan akil lun wulela su nga oru nu sin ma oasr moul la nukewa.” ");
INSERT INTO kos_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Wen tolu natul Noah su tufoki liki oak uh pa Shem, Ham, ac Japheth. (Ham pa papa tumal Canaan.) ");
INSERT INTO kos_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Wen tolu natul Noah inge pa papa tumun mwet faclu nufon. ");
INSERT INTO kos_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah, su tuh sie mwet ima, pa mwet se oemeet ma tuh yukwiya ima in grape uh. ");
INSERT INTO kos_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Tukun el numla kutu wain uh, el sruhila, sarukla nuknuk lal, ac oan koflufolla in lohm nuknuk sel. ");
INSERT INTO kos_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ke Ham, papa tumal Canaan, el liyauk lah papa tumal el koflufolla oan, el illa ac fahkang nu sin tamulel luo wiel. ");
INSERT INTO kos_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Na Shem ac Japheth eis nuknuk loeloes se ac filiya finpisaltal. Eltal kohloli nu in lohm nuknuk sac ac afinya papa tumaltal. Mutaltal ngetla lukel tuh eltal in tia liye koflufol lal. ");
INSERT INTO kos_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ke sruhi lal Noah uh sarla lukel ac el etauk ke ma wen se ma fusr natul el oru nu sel, ");
INSERT INTO kos_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","el fahk, “Sie selnga nu facl Canaan! El ac fah sie mwet kohs nu sin tamulel lal. ");
INSERT INTO kos_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Kaksakin LEUM GOD, God lal Shem! Canaan el ac fah mwet kohs lal Shem. ");
INSERT INTO kos_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","God Elan akyokyelik acn lal Japheth! Lela fwilin tulik natul in puseni ac muta yurin mwet lal Shem. Canaan el ac fah mwet kohs lal Japheth.” ");
INSERT INTO kos_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Tukun sronot sac, Noah el moul yac tolfoko lumngaul, ");
INSERT INTO kos_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ac misa ke el yac eufoko lumngaul matwal. ");
INSERT INTO kos_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Pa inge fwilin tulik natul Shem, Ham, ac Japheth, wen tolu natul Noah. Oasr wen nutin mukul tolu inge tukun sronot ah. ");
INSERT INTO kos_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Wen natul Japheth pa Gomer, Magog, Madai, Javan, Tubal, Meshech, ac Tiras — elos inge pa papa tumun mwet su us inelos. ");
INSERT INTO kos_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Fwilin tulik natul Gomer pa mwet in Ashkenaz, Riphath, ac Togarmah. ");
INSERT INTO kos_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Fwilin tulik natul Javan pa mwet in acn Elishah, Tarshish, Cyprus, ac Rhodes. ");
INSERT INTO kos_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Elos pa papa tumun mwet ma muta wekof uh ac fin tuka. Elos inge nukewa mwet in fwil natul Japheth, su muta in kais sie sruf in kais sie acn, ac kais sie u oasr kas la sifacna. ");
INSERT INTO kos_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Wen natul Ham pa Cush, Egypt, Lybia, ac Canaan — elos pa papa tumun mwet ma us inelos. ");
INSERT INTO kos_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Fwilin tulik natul Cush pa mwet Seba, Havilah, Sabtah, Raamah, ac Sabteca. Fwilin tulik natul Raamah pa mwet Sheba ac Dedan. ");
INSERT INTO kos_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Oasr wen se natul Cush pangpang Nimrod, ac el pa mwet se emeet pwengpeng ke mweun ac kutangla mutunfacl saya. ");
INSERT INTO kos_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ke kasru lun LEUM GOD, el sie mwet sruh kosro pwengpeng, pa oru mwet uh ac fahk, “LEUM GOD Elan oru tuh kom in sie mwet sruh kosro pwengpeng oana Nimrod!” ");
INSERT INTO kos_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Meet, tokosrai lal uh sisani acn Babylon, Erech, ac Accad — acn tolu inge kewa oan Babylonia. ");
INSERT INTO kos_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimrod el som we lac nu Assyria ac musaela siti Nineveh, Rehoboth Ir, Calah, ");
INSERT INTO kos_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ac Resen, su oan inmasrlon Nineveh ac siti pwengpeng Calah. ");
INSERT INTO kos_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Fwilin tulik natul Egypt pa mwet Lydia, Anam, Lehab, Naphtuh, ");
INSERT INTO kos_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrus, Casluh, ac Crete, su mwet Philistia tuku kac. ");
INSERT INTO kos_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Wen luo natul Canaan — Sidon, su matu, ac Heth — pa papa tumun mwet ma us inelos. ");
INSERT INTO kos_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Canaan el oayapa papa tumun mwet Jebus, mwet Amor, mwet Girgash, ");
INSERT INTO kos_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","mwet Hiv, mwet Ark, mwet Sinit, ");
INSERT INTO kos_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","mwet Arvad, mwet Zemar, ac mwet Hamath. Kais sie sruf lun mwet Canaan inge fahsrelik ouinge: ");
INSERT INTO kos_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","masrol lalos mutawauk Sidon oatui nu eir in Gerar apkuran nu Gaza, ac srola nu kutulap in Sodom, Gomorrah, Admah, ac Zeboim, apkuranyang nu Lasha. ");
INSERT INTO kos_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Pa inge fwilin tulik natul Ham, su muta in kais sie sruf lalos in kais sie acn selos, ac kais sie u oasr kas la sifacna. ");
INSERT INTO kos_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem, tamulel matu lal Japheth, pa papa tumun mwet Hebrew nukewa. ");
INSERT INTO kos_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wen natul Shem — Elam, Asshur, Arpachshad, Lud, ac Aram — elos pa papa tumun mwet ma us inelos. ");
INSERT INTO kos_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Fwilin tulik natul Aram pa mwet Uz, mwet Hul, mwet Gether, ac mwet Meshek. ");
INSERT INTO kos_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpachshad pa papa tumal Shelah, su papa tumal Eber. ");
INSERT INTO kos_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Oasr wen luo natul Eber. Sie pa Peleg, mweyen in pacl lal ah mwet fin faclu tuh kitakatelik, ac tamulel se lal ah pa Joktan. ");
INSERT INTO kos_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Fwilin tulik natul Joktan pa mwet Almodad, mwet Sheleph, mwet Hazarmaveth, mwet Jerah, ");
INSERT INTO kos_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","mwet Hadoram, mwet Uzal, mwet Diklah, ");
INSERT INTO kos_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","mwet Obal, mwet Abimael, mwet Sheba, ");
INSERT INTO kos_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","mwet Ophir, mwet Havilah, ac mwet Jobab. Elos inge nukewa pa fwil natul Joktan. ");
INSERT INTO kos_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Acn elos muta we uh mutawauk na Mesha, fahla nwe Sephar, acn inging layen nu kutulap. ");
INSERT INTO kos_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Pa inge fwilin tulik natul Shem, su muta in kais sie sruf lalos in kais sie acn selos, ac kais sie u oasr kas la sifacna. ");
INSERT INTO kos_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Mwet inge nukewa pa fwilin tulik natul Noah, mutunfacl nu ke mutunfacl, fal nu ke takin sou lalos kais sie. Tukun sronot sac, mutunfacl nukewa fin faclu tuku ke wen tolu natul Noah inge. ");
INSERT INTO kos_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ke mutawauk ah, kain kas sefanna lun mwet faclu nufon, ac mwet uh orekmakin pusra sefanna. ");
INSERT INTO kos_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ke elos forfor layen kutulap, elos sun sie acn tupasrpasr in acn Babylonia ac oakwuki we. ");
INSERT INTO kos_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Elos fahk nu sin sie sin sie, “Fahsru, kut in orek brick ac omunla in ku.” Ouinge elos orek brick mwe musa, ac sang tar folsani nu sie. ");
INSERT INTO kos_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Na elos fahk, “Inge kut ac musaela sie siti ac sie tower ma ac sun acn inkusrao, inesr in mau ku in pwengpeng, ac kut in tia musalelik nu fin faclu nufon.” ");
INSERT INTO kos_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Na LEUM GOD El oatula ac liye siti sac ac tower se ma mwet uh musai, ");
INSERT INTO kos_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ac El fahk, “Ingena, mwet inge ma sefanna ac elos sramsram ke kas sefanna. Tufahna pa inge mutaweyen ma elos ac mau oru uh. Ac tia paht na elos ac ku in oru kutena ma su elos ac lungse oru! ");
INSERT INTO kos_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Fahsru, kut oatula ac akfohsyauk kas lalos, elos in tia kalem ke kas lun sie sin sie.” ");
INSERT INTO kos_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ouinge LEUM GOD El akfahsryeloselik nu fin faclu nufon, ac elos tila musai siti sac. ");
INSERT INTO kos_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Siti sac pangpang Babylon, mweyen LEUM GOD El akfohsyauk kas lun mwet nukewa we, ac akfahsryeloselik nukewa liki acn we nu fin faclu nufon. ");
INSERT INTO kos_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Pa inge fwilin tulik natul Shem. Yac luo tukun sronot ah, ke Shem el yac siofok matwal, oasr wen se natul, pangpang Arpachshad. ");
INSERT INTO kos_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Tukun pacl sac el sifilpa moul ke yac lumfoko, ac oasr pac tulik saya natul. ");
INSERT INTO kos_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ke Arpachshad el yac tolngoul limekosr, oasr wen se natul pangpang Shelah. ");
INSERT INTO kos_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Tukun pacl sac el moul ke yac angfoko tolu, ac oasr pac tulik saya natul. ");
INSERT INTO kos_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ke Shelah el yac tolngoul, oasr wen se natul pangpang Eber. ");
INSERT INTO kos_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Tukun pacl sac el moul yac angfoko tolu, ac oasr pac tulik saya natul. ");
INSERT INTO kos_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ke Eber el yac tolngoul akosr, oasr wen se natul pangpang Peleg. ");
INSERT INTO kos_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Tukun pacl sac el moul yac angfoko tolngoul, ac oasr pac tulik saya natul. ");
INSERT INTO kos_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ke Peleg el yac tolngoul, oasr wen se natul pangpang Reu. ");
INSERT INTO kos_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Tukun pacl sac el moul yac luofoko eu, ac oasr pac tulik saya natul. ");
INSERT INTO kos_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ke Reu el yac tolngoul luo, oasr wen se natul pangpang Serug. ");
INSERT INTO kos_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Tukun pacl sac el moul yac luofoko itkosr, ac oasr pac tulik saya natul. ");
INSERT INTO kos_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ke Serug el yac tolngoul, oasr wen se natul pangpang Nahor. ");
INSERT INTO kos_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Tukun pacl sac el moul yac luofoko, ac oasr pac tulik saya natul. ");
INSERT INTO kos_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ke Nahor el yac longoul eu, oasr wen se natul pangpang Terah. ");
INSERT INTO kos_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tukun pacl sac el moul yac siofok singoul eu, ac oasr pac tulik saya natul. ");
INSERT INTO kos_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tukun Terah el yac itngoul, el oswella Abram, Nahor ac Haran. ");
INSERT INTO kos_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Pa inge fwilin tulik natul Terah, su papa tumal Abram, Nahor, ac Haran. Haran pa papa tumal Lot, ");
INSERT INTO kos_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ac Haran el misa yen sel in acn Ur in Babylonia, ke papa tumal ah srakna moul. ");
INSERT INTO kos_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram el payukyak sel Sarai, ac Nahor el payukyak sel Milcah, acn natul Haran, su oayapa papa tumal Iscah. ");
INSERT INTO kos_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai el tia ku in orek tulik. ");
INSERT INTO kos_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah el eisal Abram wen natul, ac Lot, wen natul Haran ma lel Abram, ac Sarai acn talupal, su mutan kial Abram, ac elos welul som liki siti Ur in Babylonia nu in facl Canaan. Elos som nwe sun acn Haran ac oakwuki we. ");
INSERT INTO kos_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah el misa we ke el yac luofoko limekosr matwal. ");
INSERT INTO kos_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","LEUM GOD El fahk nu sel Abram, “Tuyak fahla liki facl sum, mwet inkul sin papa tomom, ac sou nukewa lom saya, ac som nu ke sie acn ma nga ac fah akkalemye nu sum. ");
INSERT INTO kos_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nga ac fah sot fwilin tulik puspis nutum, ac elos ac fah mau sie mutunfacl lulap. Nga ac akinsewowoye kom ac oru inem in pwengpeng. Ouinge kom ac fah sie mwe insewowo. ");
INSERT INTO kos_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nga fah akinsewowoyalos su akinsewowoye kom, Tusruk nga ac selngawelos su selngawi kom. Ac nga fah akinsewowoye mutanfahl nukewa keim.” ");
INSERT INTO kos_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ke Abram el yac itngoul limekosr, el mukuila liki acn Haran, oana ke LEUM GOD El fahk elan oru. Ac Lot el welul som. ");
INSERT INTO kos_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram el eisal Sarai mutan kial, Lot wen nutin tamulel lal, ac mwe kasrup nukewa, wi mwet kulansap nukewa su elos tuh eis ke elos muta Haran, ac mukuiyak som nu in facl Canaan. Ke elos sun acn Canaan, ");
INSERT INTO kos_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram el fufahsryesr in acn we nwe ke el sun sak oal Moreh, sie acn mutal in siti Shechem. (In pacl sac mwet Canaan srakna muta fin facl sac.) ");
INSERT INTO kos_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","LEUM GOD El sikyang nu sel Abram ac fahk nu sel, “Pa inge facl se ma nga ac sang nu sin fwilin tulik nutum.” Na Abram el etoak loang se nu sin LEUM GOD, su tuh sikyang nu sel we, ");
INSERT INTO kos_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Tukun pacl sac, el mukuiyak nu eir, nu infulan eol kutulap in siti Bethel, ac tulokunak lohm nuknuk sel inmasrlon Bethel layen roto, ac Ai layen kutulap. El oayapa etoak loang se we ac alu nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Na el sifilpa fahsr sun acn puspis ke el fahsr in som nu tafunyen eir in acn Canaan. ");
INSERT INTO kos_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tusruktu oasr sracl lulap se in acn Canaan su arulana upa, oru Abram el sifil pacna fahsr nu eir nwe ke na el sun acn Egypt, ac muta in aktuktuk we. ");
INSERT INTO kos_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ke el akola in tupalla masrol nu Egypt, el fahk nu sel Sarai, mutan kial, “Kom mutan na oasku se. ");
INSERT INTO kos_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Mwet Egypt ah fin liye kom, elos ac luma mu ma kiuk pa kom, na elos ac uniyuwi ac eiskomla. ");
INSERT INTO kos_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Fahk nu selos mu ma wiuk pa kom, elos in mau tia uniyuwi, a oru wo nu sik.” ");
INSERT INTO kos_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ke el utyak nu in acn Egypt, mwet Egypt elos liye lah mutan se kial ah arulana oasku. ");
INSERT INTO kos_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kutu sin mwet fulat inkul sin tokosra liyalak ac fahkang nu sel tokosra katoiyen mutan sac, pwanang utukla el nu inkul fulat sin tokosra. ");
INSERT INTO kos_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ke sripal Sarai, tokosra el oru na wo nu sel Abram, ac kital u in sheep, nani, cow, donkey, camel, ac mwet kohs mukul ac mutan. ");
INSERT INTO kos_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tusruktu ke sripen tokosra el eisalla Sarai, LEUM GOD El supwama mas keok nu facl tokosra ac nu fin mwet inkul fulat sel. ");
INSERT INTO kos_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Na tokosra el sapla solalma Abram ac siyuk sel, “Mea kom oru nu sik uh? Efu ku kom tia fahk nu sik lah mutan se inge ma kiom? ");
INSERT INTO kos_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Efu ku kom fahk mu ma wiom pa el, oru nga usalla kiuk? Pa ingan mutan kiom ah. Usal ac tiok likiyu!” ");
INSERT INTO kos_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Tokosra el sap mwet lal ah in usalla Abram ac supwalla liki facl sac, wi mutan kial ac ma lal nukewa. ");
INSERT INTO kos_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram el som liki acn Egypt nu epang, nu tafunyen eir in acn Canaan, wi mutan kial ac ma nukewa lal, ac Lot el welul pac som. ");
INSERT INTO kos_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram el arulana kasrup ke sheep, nani, cow, ac oayapa silver ac gold. ");
INSERT INTO kos_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Na el som liki acn we ac fahsr tui in kais sie acn ke el fahsr in som nu Bethel. El sun acn se inmasrlon Bethel ac Ai, acn se ma el tuh aktuktuk we ");
INSERT INTO kos_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ac etoak loang se we meet. Na el alu nu sin LEUM GOD we. ");
INSERT INTO kos_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Oasr pac sheep, nani, ac cow natul Lot, oayapa oasr sou ac mwet kulansap lal sifacna. ");
INSERT INTO kos_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ke ma inge acn in mongo lun kosro uh sufalla eltal in tukeni orekmakin, mweyen arulana pukanten kosro natultal. ");
INSERT INTO kos_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ouinge oasr amei inmasrlon mwet liyaung kosro natul Abram ac mwet liyaung kosro natul Lot. (In pacl sac, mwet Canaan ac mwet Periz srakna muta fin facl sac.) ");
INSERT INTO kos_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Na Abram el fahk nu sel Lot. “Lela nga kom in tia akukuin, oayapa mwet lom ac mwet luk in tia alein, mweyen kut sou se na. ");
INSERT INTO kos_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Yolyak facl se oan ye mutasr inge. Ke ma inge, lela kut in fahsrelik. Sulela acn ma kom lungse an, ac nga fah som nu yen lula an.” ");
INSERT INTO kos_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot el ngetot ngetma ac liye lah Infalfal Jordan nufon, fahla na nwe Zoar, arulana yohk kof we, oana ima lun LEUM GOD ku oana facl Egypt. (Pacl se inge ma meet liki LEUM GOD El kunausla siti Sodom ac Gomorrah.) ");
INSERT INTO kos_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ouinge Lot el sulela Infalfal Jordan nufon lal, ac mukuiyak som nu layen kutulap. Pa ingan luman fahsrelik lal Abram ac Lot. ");
INSERT INTO kos_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram el mutana in acn Canaan, ac Lot el som oakwuki inmasrlon siti infalfal uh, ac tulokunak iwen aktuktuk sel fototo na nu Sodom, ");
INSERT INTO kos_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","yen su mwet we uh koluk ac orekma koluk lain LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Tukun Lot el som, LEUM GOD El fahk nu sel Abram, “Ngetla yen se kom tu we ingan, ac liye akwoye acn nukewa — epang, eir, kutulap ac roto. ");
INSERT INTO kos_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Acn nukewa ma kom liye ingan, nga ac sot nu sum ac nu sin fwilin tulik nutum, na ac fah ma na lom nwe tok. ");
INSERT INTO kos_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nga ac fah sot tulik na pukanten nutum, su wangin mwet ac fah ku in oakla. Ac fah fisrasr in oaoala puk fin faclu liki tulik nutum! ");
INSERT INTO kos_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Inge fahsr sasla facl se inge nufon, mweyen nga ac sot lom.” ");
INSERT INTO kos_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ke ma inge Abram el srakla iwen aktuktuk lal ac oakiya apkuran nu ke sak oal sunal Mamre in acn Hebron, ac el etoak loang se we nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Tokosra akosr, Amraphel lun Babylonia, Arioch lun Ellasar, Chedorlaomer lun Elam, ac Tidal lun Goiim, ");
INSERT INTO kos_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","elos som in mweun lain tokosra limekosr saya: Bera lun Sodom, Birsha lun Gomorrah, Shinab lun Admah, Shemeber lun Zeboiim, ac tokosra lun Bela (ku Zoar). ");
INSERT INTO kos_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tokosra limekosr inge toeni orala u se, ac fahsreni nu Infalfal Siddim, su pa Meoa Misa in pacl inge. ");
INSERT INTO kos_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Elos tuh muta ye nununku lal Chedorlaomer ke yac singoul luo, tusruktu in yac se aksingoul tolu elos tuyak lainul. ");
INSERT INTO kos_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","In yac aksingoul akosr Chedorlaomer ac tokosra tolu wial tuku wi un mwet mweun lalos ac kutangla mwet Rephaim in acn Ashtaroth Karnaim, oayapa mwet Zuzim in acn Ham, mwet Emim in acn tupasrpasr lun Kiriathaim, ");
INSERT INTO kos_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ac mwet Hor infulan eol Edom, ukwalos na nwe Elparan sisken acn mwesis. ");
INSERT INTO kos_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Na elos forla ac foloko nu Kadesh (in pacl so pangpang Enmishpat.) Elos eisla acn nukewa lun mwet Amalek, ac kutangla mwet Amor su muta Hazazon Tamar. ");
INSERT INTO kos_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Na Tokosra lun Sodom, Gomorrah, Admah, Zeboiim, ac Bela elos mokuiyak wi un mwet mweun lalos in mweun Infalfal Siddim ");
INSERT INTO kos_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","lain tokosra lun Elam, Goiim, Babylonia, ac Ellasar — tokosra limekosr lain tokosra akosr. ");
INSERT INTO kos_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Infalfal sac sessesla ke lufin tar, ac ke tokosra lun Sodom ac Gomorrah srike in kaingla liki mweun uh, elos putatyang nu in luf inge, a tokosra tolu saya uh kaingla nu fineol ah. ");
INSERT INTO kos_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tokosra akosr ah usla ma nukewa in acn Sodom ac Gomorrah, wi mwe mongo we, ac som. ");
INSERT INTO kos_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lot, wen nutin ma lel Abram, el muta Sodom in pacl sac, ac elos usalla ac ma lal nukewa. ");
INSERT INTO kos_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tusruktu oasr mwet se kaingla ac fahkak ma sikyak inge nukewa nu sel Abram, mwet Hebrew se su muta fototo nu ke sak oal sunal Mamre, mwet Amor. Mamre ac tamulel luo wial, Eshcol ac Aner, elos welul Abram lac ke pacl in mweun. ");
INSERT INTO kos_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ke Abram el lohng lah sruhu wen nutin mwet lel, el pangoneni mukul nukewa ke nien aktuktuk lal su etu mweun — mukul tolfoko singoul oalkosr nufon — ac ukwe na tokosra akosr ah nwe Dan. ");
INSERT INTO kos_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ke elos sun acn we, el kitalik mwet lal ah nu ke u, ac sroang nu sin mwet lokoalok lalos ke fong, ac kutangulosla. El ukwalos na nwe Hobah, epang in Damascus, ");
INSERT INTO kos_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ac folokonma ma wap nukewa ma elos tuh usla. El oayapa folokunulma Lot, wen nutin ma lel, wi ma lal nukewa, weang mutan ac mwet kapir pac saya. ");
INSERT INTO kos_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ke Abram el foloko tukun el kutangulla Chedorlaomer ac tokosra ma welul, tokosra lun acn Sodom el illa in sonol Infalfal Shaveh (pangpang pac Infalfal lun Tokosra). ");
INSERT INTO kos_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ac Melchizedek, su tokosra lun acn Salem ac el oayapa sie mwet tol lun God Fulatlana, el use bread ac wain nu yorol Abram, ");
INSERT INTO kos_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ac akinsewowoyal ac fahk, “Lela God Fulatlana, su orala kusrao ac faclu, in akinsewowoyal Abram! ");
INSERT INTO kos_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Lela in kaksakinyuk God Fulatlana, su asot kutangla nu sum fin mwet lokoalok lom!” Ac Abram el sang nu sel Melchizedek sie tafu singoul in ma wap nukewa ma el folokonma. ");
INSERT INTO kos_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tokosra lun Sodom el fahk nu sel Abram, “Sruokya ma wap an lom, tusruktu folokonma nufon mwet luk an.” ");
INSERT INTO kos_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Na Abram el fahk, “Nga orala fulahk luk ye mutun LEUM GOD, El su Fulatlana, su orala kusrao ac faclu, ");
INSERT INTO kos_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","lah nga ac fah tiana sruokya kutena ma lom, finne turet soko ku soko mwe lohl fahluk, kom in mau tia ku in fahk mu, ‘Nga pa oru Abram el kasrup.’ ");
INSERT INTO kos_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nga fah tiana eis kutena ma, sayen ma mwet luk inge orekmakin tari uh. Tusruktu lela elos su wiyu inge (Aner, Eshcol, ac Mamre) in eis ip lalos.” ");
INSERT INTO kos_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Tukun ma inge, oasr aruruma se Abram el liye, ac el lohng pusren LEUM GOD fahk nu sel, “Abram, nimet sangeng. Nga ac fah lisring kom liki mwe sensen, ac sot nu sum sie mwe usru lulap.” ");
INSERT INTO kos_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Tusruktu Abram el topuk ac fahk, “LEUM GOD Fulatlana, mwe mea nu sik mwe usru sacn, ke wangin tulik nutik uh? Mwet sefanna ac usrui ma luk uh, pa Eliezer, mwet Damascus. ");
INSERT INTO kos_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Wangin tulik kom ase nutik, a siena sin mwet kulansap luk fah usrui ma luk.” ");
INSERT INTO kos_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Na el lohng LEUM GOD El sifilpa kaskas nu sel ac fahk, “Mwet kulansap se inge, Eliezer, el fah tia usrui ma lom, a wen se nutum sifacna ac fah mwet usru lom.” ");
INSERT INTO kos_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","LEUM GOD El pwanulla nu likinuma ac fahk, “Ngetak nu inkusrao ac srike in oakla itu ingo. Fwilin tulik nutum ac fah pus oana itu uh.” ");
INSERT INTO kos_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram el filiya lulalfongi lal in LEUM GOD, ac ke sripa se inge LEUM GOD El oakulla sie mwet suwoswos. ");
INSERT INTO kos_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Na LEUM GOD El fahk nu sel, “Nga LEUM GOD, su pwenkomme liki acn Ur in facl Babylonia, in asot nu sum acn se inge tuh in ma lom. ");
INSERT INTO kos_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tusruk Abram el siyuk, “LEUM GOD Fulatlana, ac fuka eteya sik lah ac ma luk?” ");
INSERT INTO kos_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","El topuk ac fahk, “Use soko cow mutan, soko nani mutan, ac soko sheep mukul, kais soko seltal in yac tolu matwa, wi sie wule ac sie wuleoa.” ");
INSERT INTO kos_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram el use ma inge nu yurin God. El uniya, na fulungya kosro ah nu ke ip luo ac takunla ke tak lukwa, ip luo ke kais sie kain kosro oan tulani nu sie, a el tia fulungya wule ah. ");
INSERT INTO kos_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Won lulap vulture uh tuhwi nu fin ikwen kosro ac won uh, tusruktu Abram el luselosla. ");
INSERT INTO kos_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ke faht uh fahsr in tili, Abram el motulla folosuwosla, na sangeng ac tuninfong tuyang nu sel. ");
INSERT INTO kos_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Na LEUM GOD El fahk nu sel, “Fwilin tulik nutum ac fah mwetsac in sie facl su tia facl selos. Elos ac fah mwet kohs we, na ac fah arulana orek elos koluk ke lusen yac angfoko. ");
INSERT INTO kos_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tusruktu nga ac fah kalyei mutunfacl se ma ac akkohsyelos, na ke elos ac mukuiyak liki facl sac elos ac us mwe kasrup puspis welulos. ");
INSERT INTO kos_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","A funu kom, kom ac muta nwe ke na kom matuoh, na kom fah misa in misla, ac pukpuki. ");
INSERT INTO kos_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","A ac fah sun fwilin tulik akakosr nutum meet liki elos foloko nu in acn se inge, mweyen nga ac tia lusla mwet Amor nwe ke na arulana yokelik ma koluk lalos ac fal in kalyeiyuk elos.” ");
INSERT INTO kos_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ke faht ah tili, ac lohsrla acn uh, sie tup in e fofosr ac soko srokom in e sikyak ke kitin pacl ah, ac fahla inmasrlon takin ikwen kosro uh. ");
INSERT INTO kos_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Na in pacl sacna, LEUM GOD El orala wulela se inmasrlol ac Abram, fahkang, “Nga wulela mu nga ac sot facl se inge nufon nu sin fwilin tulik nutum, mutawauk ke masrol lun Egypt nwe ke Infacl Euphrates, ");
INSERT INTO kos_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","weang acn lun mwet Ken, mwet Keniz, mwet Kadmon, ");
INSERT INTO kos_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","mwet Hit, mwet Periz, mwet Rephaim, ");
INSERT INTO kos_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","mwet Amor, mwet Canaan, mwet Girgash, ac mwet Jebus.” ");
INSERT INTO kos_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, mutan kial Abram, el tiana isus tulik nu sel Abram. Tusruktu oasr mutan kulansap lal, mutan fusr Egypt se pangpang Hagar. ");
INSERT INTO kos_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ouinge Sarai el fahk nu sel Abram, “LEUM GOD El tia lela in oasr tulik nutik. Kom ku tia tari ona yurin mutan kulansap luk? Sahp el ac ku in aolyula oswela sie tulik ah.” Abram el insese nu ke ma Sarai el fahk nu sel. ");
INSERT INTO kos_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ke ma inge Sarai el eisalang Hagar nu sel Abram tuh elan mutan kulansap kial. (Ma se inge sikyak tukun Abram el muta yac singoul in acn Canaan.) ");
INSERT INTO kos_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram el ona yorol Hagar, ac el pitutuyak. Ke Hagar el etauk lah el pitutu, el inse fulatak ac kwaselak Sarai. ");
INSERT INTO kos_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai el fahk nu sel Abram, “Kom pa pwanang Hagar el srungayu uh. Nga tuh sifacna eisalot nu sum, tuh tukunna el konauk lah el pitutu ah, el nuna kwaseyu na. Lela LEUM GOD Elan aksuwosye lah su kac pwaye se uh — kom ku nga!” ");
INSERT INTO kos_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram el topuk ac fahk, “Lungse na lom. Kom na pa nununkal an. Oru na ma kom lungse oru nu sel an.” Ouinge Sarai el oru arulana upa nu sel Hagar, pwanang Hagar el kaingla. ");
INSERT INTO kos_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Lipufan lun LEUM GOD el sonol Hagar sisken sie unon in kof yen mwesis inkanek nu Shur ");
INSERT INTO kos_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ac fahk, “Hagar, mutan kulansap lal Sarai, kom tuku oya me, ac kom ac som nu ya?” Ac Hagar el fahk, “Nga kaingla liki mutan kacto luk.” ");
INSERT INTO kos_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Na lipufan sac fahk, “Folokla nu yorol ac kulansap na nu sel.” ");
INSERT INTO kos_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Na lipufan sac sifilpa fahk, “Nga ac fah arulana akpusye fwilin tulik nutum, ac wangin sie mwet ac ku in oakalosla. ");
INSERT INTO kos_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Kom ac fah oswela wen se, ac kom fah sang inel Ishmael, mweyen LEUM GOD El lipsrala pusren tung ac asor lom. ");
INSERT INTO kos_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tusruktu wen nutum el ac fah moul oana donkey lemnak soko. El ac fah lain mwet nukewa, ac mwet nukewa ac fah lainul. El ac fah muta srengla liki sou lal nukewa. ");
INSERT INTO kos_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar el siyuk sel sifacna, “Ku pwayena lah ngan liye God ac moul na in srumun kac?” Ouinge el pangon LEUM GOD su sramsram nu sel “Sie God Su Liye.” ");
INSERT INTO kos_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Pa inge sripa se oru mwet uh pangon lufin kof se inmasrlon Kadesh ac Bered, “Lufin Kof Lun El Su Moul Ac Liyeyu.” ");
INSERT INTO kos_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagar el oswela wen se nu sel Abram, ac Abram el sang inel Ishmael. ");
INSERT INTO kos_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram el yac oalngoul onkosr ke pacl sac. ");
INSERT INTO kos_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ke Abram el yac eungoul eu, LEUM GOD El sikyang nu sel ac fahk, “Nga God Kulana. Akosyu ac oru ma suwohs pacl nukewa. ");
INSERT INTO kos_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nga ac fah oru sie wuleang inmasrlok kom, ac sot fwilin tulik puspis nutum.” ");
INSERT INTO kos_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram el faksufi, ac God El fahk, ");
INSERT INTO kos_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nga oru wuleang se inge inmasrlok ac kom: Nga wuleot mu kom ac fah papa tumun mutunfacl puspis. ");
INSERT INTO kos_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ac fah tia sifil pangpang kom Abram, a Abraham, mweyen nga ac oru kom in papa tumun mutunfacl puspis. ");
INSERT INTO kos_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nga ac fah sot tulik puspis nutum, ac kutu selos ac fah tokosra. Fwilin tulik nutum ac fah arulana pukanten, pwanang elos ac fah orala mutunfacl puspis. ");
INSERT INTO kos_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nga fah karinganang wuleang luk nu sum ac nu sin fwilin tulik nutum in pacl fahsru uh, tuh in sie wuleang nwe tok. Nga fah God lom ac God lun fwil nutum. ");
INSERT INTO kos_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nga fah sot nu sum ac nu sin fwilin tulik nutum fahl se inge su kom mwetsac nu fac in pacl inge. Facl Canaan nufon fah ma lun fwil nutum nwe tok, ac nga ac fah God lalos.” ");
INSERT INTO kos_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","God El fahk nu sel Abraham, “Kom, ac fwilin tulik nutum nwe tok, enenu in wiyu pac insese in liyaung wuleang se inge. ");
INSERT INTO kos_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Kom ac fwil nutum nukewa enenu in insese pac in kosrala mukul nukewa inmasrlowos. ");
INSERT INTO kos_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kowos fah kosrala kulun ma mukul lowos, na ac fah pa ingan akul lun wuleang se inmasrlok ac kom inge. ");
INSERT INTO kos_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","In fwil nukewa nutum, mukul nukewa inmasrlon mwet lom ac fah kosreyukla ke el sun len oalkosr matwa, wi pac mwet kohs su isusla in lohm sum, oayapa elos su kom molela sin mwetsac su tia ma nutum. ");
INSERT INTO kos_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Kais sie mukul enenu in kosreyukla, ac ma se inge ac fah sie akul ke monuwos in akkalemye lah wuleang se inmasrlok ac kom inge ma na nwe tok. ");
INSERT INTO kos_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kutena mukul su tia kosrkosrla ac fah wotla liki inmasrlon mwet luk, mweyen el kunausla wuleang luk.” ");
INSERT INTO kos_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God El fahk nu sel Abraham, “Kom fah tia sifil pangon mutan kiom Sarai. Ingela inel ac fah pangpang Sarah. ");
INSERT INTO kos_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nga ac fah akinsewowoyal, ac nga fah oru tuh elan oswe sie wen nutum. Nga fah akinsewowoyal, ac el fah nina kien mutunfacl puspis. Ac fah oasr tokosra inmasrlon fwilin tulik natul.” ");
INSERT INTO kos_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham el faksufi, tusruktu el mutawauk in israsr ke el nunku, “Mea, sie mukul ac ku in oasr tulik natul ke el yac siofok matu? Ya Sarah el ku in orek tulik ke el yac eungoul?” ");
INSERT INTO kos_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ac el siyuk sin God, “Efu ku kom tia tari sang na Ishmael elan mwet usru luk?” ");
INSERT INTO kos_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tuh God El fahk, “Mo. Sarah mutan kiom el ac oswela wen se nutum ac kom fah sang inel Isaac. Nga fah sruokyana wuleang luk yorol ac yurin fwilin tulik natul nwe tok — sie wuleang su wangin saflaiya. ");
INSERT INTO kos_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Nga lohng siyuk lom kacl Ishmael, ke ma inge nga fah akinsewowoyal ac sang tulik puspis natul ac fwil puspis. El ac fah papa tumun fisrak singoul luo, ac nga fah oru sie mutunfacl lulap ke fwil natul. ");
INSERT INTO kos_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tusruktu nga fah liyaung wuleang luk yorol Isaac, wen nutum su Sarah el ac fah oswela ke pacl se pacna inge in yac fahsru.” ");
INSERT INTO kos_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ke God El sramsram tari nu sel Abraham, na El som lukel. ");
INSERT INTO kos_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","In len sac pacna, Abraham el akos God ac kosralla Ishmael ac mukul nukewa in lohm sel, wi pac mwet kohs ma isusyang nu in paol, oayapa elos su el molela ke mani. ");
INSERT INTO kos_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham el yac eungoul eu ke el kosrkosrla, ");
INSERT INTO kos_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ac Ishmael wen natul el yac singoul tolu. ");
INSERT INTO kos_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Eltal kewa kosrkosrla ke len sefanna, ");
INSERT INTO kos_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","wi mwet kulansap nukewa lal Abraham. ");
INSERT INTO kos_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Na LEUM GOD El sikyang nu sel Abraham ke insak oal sunal Mamre. Ke Abraham el muta ke mutunoa in lohm nuknuk sel, ke pacl na fol ke len uh, ");
INSERT INTO kos_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","el ngetak ac liye mwet tolu tu insac. Pacl se na el liyalosyak, el yula in osun nu selos. El faksufi ");
INSERT INTO kos_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ac fahk, “Mwet kacto, nunak munas nimet fahsr aliki lohm sik uh ac tia tui. Nga inge in kulansupwekowos. ");
INSERT INTO kos_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Lela ngan use kutu kof in ohlla niowos. Kowos ku in monglawin ye lulin sak soko inge. ");
INSERT INTO kos_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nga fah use pac kutu mwe mongo in akkeye kowos, na kowos fah sifilpa fahsr. Kowos arulana akmwetyeyu ke kowos tuku nu lohm sik uh. Ke ma inge, fuhlema nga in kulansup nu suwos.” Ac eltal fahk nu sel, “Tarilana. Kut ac wi ma kom fahk an.” ");
INSERT INTO kos_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham el sulaklak na som nu in lohm nuknuk uh ac fahk nu sel Sarah, “Aksaye, eis sie pak in flao wowo an, kasla, ac sang orauk kutu cake ah.” ");
INSERT INTO kos_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Na el sifilpa yula nu yen un kosro uh muta we, ac sulela cow fusr na fisrasr ikwa ac factfat soko, ac sang nu sin mwet kulansap se, su sulaklak na akoela. ");
INSERT INTO kos_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ac el us kutu butter, milk, ac ikwen kosro, ac filiya mwe mongo inge ye mutun mwet tolu ah. Na el tupan enenu lalos ke elos mongo ye sak soko ah. ");
INSERT INTO kos_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Na elos siyuk sel, “El aya Sarah, mutan kiom?” Ac el fahk, “El a na lohm ah.” ");
INSERT INTO kos_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Na sie selos fahk, “Malem eu tukun misenge nga ac foloko, na ac fah oasr wen se natul Sarah, mutan kiom.” Sarah el tu tokol ke mutunoa in lohm nuknuk uh, ac porongo. ");
INSERT INTO kos_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham ac Sarah arulana matuoh, ac tui musen mutan lal Sarah. ");
INSERT INTO kos_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ouinge Sarah el israsrla ac nunku in el sifacna, “Inge ke nga matuoh ac wanginla kuiyuk, ya nga ac srakna pwar in oan yurin mukul tumuk? Saya, el arulana matuoh pac.” ");
INSERT INTO kos_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Na LEUM GOD El siyuk sel Abraham, “Efu Sarah el ku israsr ac fahk, ‘Ya pwaye ku in oasr tulik se nutik ke nga arulana matuoh?’ ");
INSERT INTO kos_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ya oasr ma LEUM GOD El kofla nu kac? Oana ke nga fahk tari, tukun malem eu nga fah foloko, na ac fah oasr wen se natul Sarah.” ");
INSERT INTO kos_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ke sripen Sarah el sangeng, el lafwekin ac fahk, “Nga tiana israsr.” El topuk, “Pwaye, kom israsr.” ");
INSERT INTO kos_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Na mwet ah tuyak in som, ac Abraham el welulos in wilkas nu selos. Na elos som nu ke acn se ma elos ac ku in ngeti ac liye acn Sodom. ");
INSERT INTO kos_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ac LEUM GOD El fahk insial sifacna, “Nga fah tia okanla nu sel Abraham ma nga akola in oru. ");
INSERT INTO kos_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Fwilin tulik natul ac fah orala sie mutunfacl lulap ac ku, ac nga fah akinsewowoye mutunfacl nukewa kacl. ");
INSERT INTO kos_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nga sulella ke sripen nga enenu elan ku in sapsap nu sin wen natul ac fwil nukewa tokol tuh elos in akosyu ac in oru ma pwaye ac suwohs. Elos fin akosyu, nga fah oru ma nukewa ma nga wulela tari kac nu sel.” ");
INSERT INTO kos_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Na LEUM GOD El fahk nu sel Abraham, “Oasr tukak na koluk lain acn Sodom ac Gomorrah, ac ma koluk lalos arulana yohk. ");
INSERT INTO kos_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nga enenu in oatula ac konauk lah ma tukakinyuk elos kac inge pwaye ku sutuu.” ");
INSERT INTO kos_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Na mwet luo ah tuyak som tulanya acn Sodom, tusruktu LEUM GOD El srakna oasr yorol Abraham. ");
INSERT INTO kos_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham el kalukyang nu yurin LEUM GOD ac siyuk, “Ya pwayena kom ac kunausla mwet wangin mwata wi na mwet koluk uh? ");
INSERT INTO kos_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Fin oasr mwet wangin mwata lumngaul in siti uh, ya kom ac kunausla siti nufon sac? Ya kom ac tia lela in oanna ke sripen mwet lumngaul uh? ");
INSERT INTO kos_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kalem lah kom tia ku in uniya mwet wangin mwata wi mwet koluk. Ac tia ku in angan! Kom koflana oru ma sacn. Kom fin oru angan, na mwet suwohs uh ac fah kalyeiyuk oapana mwet koluk uh. Tiana ku in angan. El su nununku faclu nufon enenu na in orekma in suwohs.” ");
INSERT INTO kos_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","LEUM GOD El fahk, “Nga fin konauk mwet suwoswos lumngaul in Sodom, nga fah tia kunausla siti nufon sac ke sripalos.” ");
INSERT INTO kos_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham el sifilpa fahk, “LEUM GOD, nunak munas, tuleyula ke kuinsrim luk in kaskas nu sum. Mwet na lusrongten se pa nga uh, ac nga kupansuwol in fahk kutena ma. ");
INSERT INTO kos_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Fin mwet suwoswos na angngaul limekosr, ac tia lumngaul, ya kom ac srakna kunausla siti nufon sac mweyen mwet limekosr pueni?” LEUM GOD El fahk, “Nga fah tia kunausla siti sac nga fin konauk mwet suwoswos angngaul limekosr. ");
INSERT INTO kos_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ac Abraham el sifilpa fahk, “Ac fin mwet angngaul na?” LEUM GOD El topuk, “Nga ac tia pac kunausla fin oasr mwet angngaul.” ");
INSERT INTO kos_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham el fahk, “LEUM GOD, nunak munas nikmet kasrkusrak, a nga srakna ke sifilpa kaskas. Fin mwet na tolngoul? El fahk, “Nga ac tia pac kunausla nga fin konauk mwet tolngoul.” ");
INSERT INTO kos_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham el fahk, “O Leum, nunak munas ke nga siayuk in kusen siyuk nu sum uh. Ac fin pa mwet na longoul koneyukyak we?” El fahk, “Nga ac tia pac kunausla siti sac, nga fin konauk longoul.” ");
INSERT INTO kos_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham el fahk, “O Leum, nunak munas nikmet kasrkusrak, ma na safla se pa nge. Ac fin mwet na singoul koneyukyak?” Ac El fahk, “Nga fah tia pac kunausla fin oasr mwet singoul.” ");
INSERT INTO kos_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Tukun el kaskas nu sel Abraham tari, LEUM GOD El som, ac Abraham el folokla nu acn sel. ");
INSERT INTO kos_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ke lipufan luo ah tuku nu Sodom in eku sac, Lot el muta ke mutunpot in siti uh. Ke pacl se na el liyaltalak, el tuyak in paingultal. El pasrla ye mutaltal ");
INSERT INTO kos_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ac fahk, “Mwet kacto, nunak munas fahsru wiyu nu lohm ah. Komtal ku in ohlla niomtal ac mongla yorosr ofong. Lututang komtal fah sa tukakek ac fahsr nu yen komtal ac som nu we.” Tusruktu eltal topuk ac fahk, “Tari, kut ac mongla na pe inkanek uh ofong.” ");
INSERT INTO kos_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","El kwafeltal nwe ke na eltal tari welul som nu lohm sel. Lot el elyai mwet kulansap lal in munanla kutu flao ac akoo sie mongo na yuyu nu sin mwet fahsr inge. Ke akoeyukla tari, na elos mongoi. ");
INSERT INTO kos_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Meet liki mwet fahsr luo inge motulla, mukul in acn Sodom nukewa tuku raunela lohm sac — kewana mwet fusr ac mwet matu. ");
INSERT INTO kos_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Elos pangyak nu sel Lot ac siyuk, “Pia mukul luo ma tuku in mongla yurum ofong uh? Usaltalu nu yorosr! Kut ke ona yoroltal.” ");
INSERT INTO kos_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot el illa nu likinuma, ac kaleang srungul ah. ");
INSERT INTO kos_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","El fahk nu selos, “Nunak munas, nga kwafe suwos, nimet oru kain ouiya koluk se inge! ");
INSERT INTO kos_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Liye, oasr acn luo nutik su soenna etu mwet. Lela ngan usaltalu nu yuruwos, ac kowos ku in oru kutena ma kowos lungse oru nu seltal. Tusruktu nimet kowos oru kutena ma nu sin mukul luo inge. Eltal mwet fahsr nu in lohm sik, ac nga enenu in liyaltalang.” ");
INSERT INTO kos_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Na elos fahk, “Tiok liki kut! Kom mwetsac se! Su kom an in fahk nu sesr ma kut in oru? Tiok! Kom fin tia som, kut ac oru in upa nu sum lukeltal.” Elos sinukunulla Lot ac kilukyang in kunausla srungul ah. ");
INSERT INTO kos_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tusruktu mukul luo ah saplakla ololak Lot nu in lohm ah, ac kaleang srungul ah. ");
INSERT INTO kos_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Na eltal konela mutun mwet nukewa likinuma, oru elos in tia ku in konauk mutunoa uh. ");
INSERT INTO kos_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mukul luo ac fahk nu sel Lot, “Fin oasr kutena mwet lom saya yenu — wen, ku acn, ku wen talupom, ku kutena mwet lom su muta in siti uh — usalosla liki acn se inge, ");
INSERT INTO kos_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","mweyen kut ac kunausla siti se inge. LEUM GOD El lohng tukak na koluk lain mwet in acn se inge, oru El supwekutme in kunausla acn Sodom.” ");
INSERT INTO kos_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Na Lot el som nu yurin mukul luo ma acn natul ah akola in payuk se, ac fahk, “Tal sulaklak som liki acn se inge. LEUM GOD El ac kunausla acn uh.” Tusruktu eltal nunku mu el aksruksruk. ");
INSERT INTO kos_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Toang na in lotu se tok ah, lipufan luo ah srike in elyaelak Lot. Eltal fahk, “Aksaye! Eis mutan kiom ac acn luo nutum an ac som, tuh kowos in tia misa ke siti uh ac kunausyukla.” ");
INSERT INTO kos_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot el wetokla, tusruktu LEUM GOD El pakomutal. Ke ma inge mwet luo ah sruokya paol Lot ac mutan kial ac acn luo natul, ac kololosla nu likin siti uh. ");
INSERT INTO kos_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Na sie sin lipufan ah fahk, “Kasrusr, suk moul lomtal! Nikmet tapulla ac nikmet tui infalfal uh. Kaing nu fin inging uh, tuh kowos in tia misa.” ");
INSERT INTO kos_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","A Lot el fahk, “Mo, nunak munas, tari tia angan. ");
INSERT INTO kos_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Yohk tari ma kom oru wo nu sik, ac lungkulang lom molela moul luk. Tusruktu inging uh arulana loesla nu inge. Mwe ongoiya ma ac sikyak inge ac ukweyuwi ac uniyuwi meet liki nga ku in sun acn we. ");
INSERT INTO kos_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kom liye siti srisrik se ingo? Fototo na. Lela nga in som nu we. Finne acn na srisrik se, nga ac ku in moulla we.” ");
INSERT INTO kos_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","El topuk, “Kwal aok, nga insese. Nga ac tia kunausla siti srisrik sacn. ");
INSERT INTO kos_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Sulaklak! Kasrusr! Nga tia ku in oru kutena ma nwe ke na kom sun acn we.” Ke sripen Lot el pangon srik siti sac, pwanang pangpang acn we Zoar. ");
INSERT INTO kos_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Faht ah takak ke pacl se Lot el sun acn Zoar. ");
INSERT INTO kos_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","In kitin pacl ah na LEUM GOD El ukuiya sulfur firir oana af uh nu fin acn Sodom ac Gomorrah ");
INSERT INTO kos_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ac kunausla acn we, oayapa infalfal uh nufon, wi mwet nukewa we ac ma nukewa ma kapak fin acn we. ");
INSERT INTO kos_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Tusruktu mutan kial Lot ah tapulla, ac el ekla nu ke sru in sohl soko. ");
INSERT INTO kos_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Toang na ke lotu toko ah, Abraham el sulaklak na som nu yen se el tuh tu ye mutun LEUM GOD we. ");
INSERT INTO kos_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","El ngeta nu fin acn Sodom ac Gomorrah, ac nu infalfal sac nufon, ac liye kulasr fosryak liki acn we, oana fofosr ke sie funyu lulap. ");
INSERT INTO kos_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tusruktu ke God El kunausla siti nukewa infalfal sac yen Lot el muta we, El nunku kacl Abraham, ac lela tuh Lot elan painmoulla. ");
INSERT INTO kos_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ac ke sripen Lot el tuh sangeng in muta in acn Zoar, el ac acn luo natul utyak nu fin inging uh ac muta in luf se we. ");
INSERT INTO kos_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mutan se ma matu seltal el fahk nu sin tamtael lal, “Papa tumasr el munaslana, a wangin mukul fin faclu nufon in payuk sesr kut in ku in orek tulik. ");
INSERT INTO kos_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tari, kut kitalya papa elan sruhila, na kut ona yorol ac orek tulik kacl.” ");
INSERT INTO kos_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","In fong sac eltal kitalya ke wain, ac acn matu sac ona yorol. Tusruktu Lot el tiana etu mweyen el arulana sruhila. ");
INSERT INTO kos_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Len tok ah, acn matu sac fahk nu sin tamtael lal, “Nga motulla yorol fong. Ofong kut sifilpa orala elan sruhila, na kom ona yorol. Na ac fah oasr fokin papa tumasr uh yorosr kewa.” ");
INSERT INTO kos_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ouinge in fong sac eltal sifilpa orala el sruhila, ac tamtael fusr sac ona yorol. Lot el tia pacna etu, mweyen el arulana sruhila. ");
INSERT INTO kos_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Eltal oru ouinge, na acn luo natul Lot kewana pututuyak sin papa tumaltal ah. ");
INSERT INTO kos_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Oasr wen se nutin tamtael matu sac, ac el sang inel Moab. El pa papa tumun mwet Moab nwe misenge. ");
INSERT INTO kos_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Tamtael fusr sac oasr pac wen se natul, su el sang inel Benammi. El pa papa tumun mwet Ammon nwe misenge. ");
INSERT INTO kos_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham el som liki acn Mamre nu ke sie ipin acn eir in Canaan, ac muta inmasrlon acn Kadesh ac Shur. Tok, ke el muta in acn Gerar, ");
INSERT INTO kos_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","el fahk mu Sarah, mutan kial, el ma loul. Ke ma inge Tokosra Abimelech lun acn Gerar el sap utuku Sarah nu yorol. ");
INSERT INTO kos_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Sie fong ah, God El sikyang nu sel Abimelech in sie mweme ac fahk, “Kom ac misa, mweyen kom eisla mutan se inge. El payuk tari.” ");
INSERT INTO kos_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Tusruktu Abimelech el soenna kalukyang nu yurin mutan sac, na el fahk, “Leum God, wangin mwetik! Ya kom ac kunausyula ac mwet luk? ");
INSERT INTO kos_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham el sifacna fahk mu tamtael se lal pa mutan sac, ac Sarah el fahk oapana. Nga oru ma inge ke nunak nasnas, ac wangin kih luk.” ");
INSERT INTO kos_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","God El topkol in mweme sac, “Aok, nga etu lah kom oru ke nunak na nasnas lom. Ouinge nga tuh karingin kom liki in orekma koluk lainyu, ac tia lela kom in kalukyang nu yorol. ");
INSERT INTO kos_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tusruktu inge, kom folokonang mutan sac nu sin mukul tumal. El mwet palu se, ac el ac fah pre keim tuh kom in tia misa. A kom fin tia folokunulang, nga fahk kom in etu lah kom ac misa — kom ac mwet lom nukewa.” ");
INSERT INTO kos_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Toang na in lotu tok ah, Abimelech el pangoneni mwet fulat lal nukewa ac fahkang nu selos ma sikyak uh, ac elos arulana tuninfongla ke sangeng. ");
INSERT INTO kos_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Na Abimelech el solalma Abraham ac siyuk sel, “Mea kom oru nu sesr uh? Mea koluk nga orala nu sum pwanang kom use mwe lokoalok se inge nu fuk ac nu fin tokosrai luk? Tiana wo kutena mwet in oru lumah se ma kom oru nu sik inge. ");
INSERT INTO kos_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Efu ku kom oru ouinge?” ");
INSERT INTO kos_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham el topuk, “Nga tuh tiana nunku mu ac oasr mwet yenu su etu in sunakin God, pwanang nga tuh sangeng mu elos ac uniyuwi ac eisla mutan kiuk uh. ");
INSERT INTO kos_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Pwayena lah el ma wiuk. Acn se nutin papa tumuk ah pa el, tusruktu tia nutin nina kiuk ah, ac nga payukyak sel. ");
INSERT INTO kos_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ouinge ke God El supweyula liki papa tumuk ah nu in facl saya inge, nga tuh fahk nu sel Sarah, ‘Kom ku in akkalemye inse pwaye lom nu sik ke kom fahk nu sin mwet nukewa lah nga tamulel lom.’” ");
INSERT INTO kos_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Na Abimelech el folokunulang Sarah nu sel Abraham, ac in pacl sac pacna el sang sheep ac cow natul, ac mwet kulansap lal. ");
INSERT INTO kos_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","El fahk nu sel Abraham, “Facl se inge nufon ma luk. Mutana yen kom lungse muta we.” ");
INSERT INTO kos_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","El fahk nu sel Sarah, “Nga asang nu sin tamulel lom sie tausin ipin silver in akpwayei nu sin mwet lom nukewa lah kom suwosna. Elos nukewa fah etu lah wangin tafongla lom.” ");
INSERT INTO kos_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Na Abraham el pre nu sin God, ac God El akkeyalla Abimelech ac oayapa mutan kial ac mutan kulansap lal nukewa, tuh elos in ku in isus, ");
INSERT INTO kos_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","mweyen LEUM GOD El tuh kaliya wet lun mutan nukewa in lohm sel Abimelech ke sripal Sarah, mutan kial Abraham. ");
INSERT INTO kos_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","LEUM GOD El akinsewowoyal Sarah oana ke El tuh wulela, ");
INSERT INTO kos_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ac el pitutuyak ac oswela wen se nu sel Abraham ke el matuoh. Tulik mukul sac osweyukla ke pacl se na God El tuh fahk mu el ac isusla. ");
INSERT INTO kos_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham el sang inel Isaac, ");
INSERT INTO kos_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ac ke Isaac el len oalkosr matwal, Abraham el kosralla, oana ke God El sapkin. ");
INSERT INTO kos_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham el yac siofok ke Isaac el isusla. ");
INSERT INTO kos_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah el fahk, “God El oru tuh nga in engan ac israsr. Mwet nukewa su lohng lah nga isusla fah wiyu israsr.” ");
INSERT INTO kos_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Na el sifilpa fahk, “Ku su mu nga ac sun katiti tulik, ac tafweang nu sel Abraham? A nga osweang nu sel sie wen ke el arulana matu.” ");
INSERT INTO kos_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Tulik sac matula, ac ke len se el liktitla, Abraham el oru sie kufwa na lulap. ");
INSERT INTO kos_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sie len ah, Ishmael, su Hagar mutan Egypt sac osweang nu sel Abraham, el welul Isaac wen natul Sarah, srital. ");
INSERT INTO kos_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sarah el liyaltal ac fahk nu sel Abraham, “Lusak mutan kulansap se inge ac wen se natul ah. Wen se nutin mutan se inge fah tiana eis kutena ip ke mwe kasrup lom, su Isaac wen nutik el ac fah usrui.” ");
INSERT INTO kos_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ma se inge arulana akfohsyalak Abraham, mweyen ma pac natul pa Ishmael. ");
INSERT INTO kos_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tusruktu God El fahk nu sel Abraham, “Nik kom elya ke tulik sac ac Hagar, mutan kulansap lom. Oru oana ma Sarah el fahk nu sum an, mweyen Isaac pa ac sot fwilin tulik nutum ma nga wuleot nu sum. ");
INSERT INTO kos_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Nga fah oayapa sang tulik puspis nutin wen nutin mutan kulansap sac, tuh elos in fah orala sie mutunfacl lulap. Ma pac nutum pa el.” ");
INSERT INTO kos_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Toangna in lotu se tok ah, Abraham el tukakek ac eis kutu mwe mongo ac pak kulun kosro se sessesla ke kof, ac filiya finpisal Hagar, na el supwalla ac tulik sac. Hagar el som forfor acn turangang uten Beersheba. ");
INSERT INTO kos_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ke kof nimaltal ah lisr nufon, Hagar el filiya tulik sac ye sak soko ");
INSERT INTO kos_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ac som muta srengla sahp ac yact siofok ma liki tulik sac. El nunku in el, “Nga tia ku in muta ngetang liye tulik se nutik inge ke ac misa uh.” Ke el muta insac, el mutawauk in tung. ");
INSERT INTO kos_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","God El lohng ke tulik sac tung, ac lipufan se lun God kaskas nu sel Hagar inkusrao me ac fahk, “Hagar, mea kom sis an? Nikmet sangeng. God El lohng tung lun tulik sac. ");
INSERT INTO kos_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tuyak, fahla sraklalak, ac akwoyalla. Nga ac oru sie mutunfacl lulap ke fwilin tulik natul.” ");
INSERT INTO kos_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Na God El ikasla mutal Hagar, ac el liyauk lufin kof se. El som ac nwakla pak sac ke kof, ac sang kiteya tulik sac. ");
INSERT INTO kos_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","God El wi tulik mukul sac ke el matula. El muta in acn turangang uten acn Paran, ac el sie mwet sruh kosro na pisrla. ");
INSERT INTO kos_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Nina kial ah konauk mutan Egypt se kial Ismael. ");
INSERT INTO kos_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","In pacl sac, Abimelech el welul Phicol, mwet kol fulat lun un mwet mweun lal, som ac fahk nu sel Abraham, “God El wi kom in ma nukewa kom oru. ");
INSERT INTO kos_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ke ma inge, orala sie wulela na ku an ye mutun God, lah kom ac tia kiapweyula, ku tulik nutik, ku fwilin tulik nutik tok ah. Pacl nukewa nga inse pwayena nu sum, ke ma inge wulema nu sik lah kom ac oayapa inse pwaye nu sik ac nu sin facl se su kom muta we inge.” ");
INSERT INTO kos_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Na Abraham el fahk, “Nga wuleot ouingan.” ");
INSERT INTO kos_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abraham el tukakin nu sel Abimelech ke lufin kof se ma mwet kulansap lal Abimelech elos tuh sruokya. ");
INSERT INTO kos_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelech el fahk, “Nga tia etu lah su oru an. Kom tiana fahk nu sik, ac nga tufahna lohng pa inge.” ");
INSERT INTO kos_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Na Abraham el sang kutu sheep ac cow nu sel Abimelech, ac eltal orala sie wulela ku inmasrloltal. ");
INSERT INTO kos_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham el srela sheep fusr mutan itkosr liki un sheep natul, ");
INSERT INTO kos_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ac Abimelech el siyuk sel, “Mea se kom oru ingan?” ");
INSERT INTO kos_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham el topuk, “Eis sheep fusr itkosr inge. Ke kom eis ma inge kom akpwayei lah nga pa mwet se ma pukanak luf se inge.” ");
INSERT INTO kos_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ouinge acn sac pangpang Beersheba, mweyen acn sac pa eltal orala wulela se inmasrloltal inge we uh. ");
INSERT INTO kos_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tukun eltal orala wulela se inmasrloltal in acn Beersheba, Abimelech ac Phicol folokla nu Philistia. ");
INSERT INTO kos_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Na Abraham el yukwiya sak tamarisk soko in acn Beersheba, ac alu nu sin LEUM GOD, God Su Moul Ma Pahtpat. ");
INSERT INTO kos_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham el muta Philistia ke pacl na loeloes se. ");
INSERT INTO kos_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","In kutu pacl tok, God El srikal Abraham. El pangnol, “Abraham!” Ac Abraham el topuk, “Nga inge.” ");
INSERT INTO kos_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","God El fahk, “Eisal Isaac, wen sefanna nutum su kom arulana kuloi, ac som nwe in facl Moriah. Ke kom ac sun acn we, na kom fah kisakunulma in mwe kisa firir nu sik fin soko eol su nga ac akkalemye nu sum.” ");
INSERT INTO kos_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Toangna in lotu tok ah, Abraham el telak etong mwe orek kisa, ac sang nu fin donkey natul ah. Na el eisal Isaac ac mwet kulansap luo welul, ac elos som nu yen se ma God El fahk mu elan som nu we ah. ");
INSERT INTO kos_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ke len se aktolu ah, Abraham el liyauk acn sac, ohkokme emeeto. ");
INSERT INTO kos_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Na el fahk nu sin mwet kulansap luo ah, “Muta inse wi donkey uh. Nga, ac tulik se nutik inge, ac som nu meet ah in alu, ac kut ac fah foloko.” ");
INSERT INTO kos_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham el sang Isaac elan us etong nu ke kisa uh, ac el us mitmit se ac mulut firir mwe tanak e uh. Ac ke eltal tukeni fahsr, ");
INSERT INTO kos_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac el kasla ac fahk, “Papa!” Ac el topuk, “Mea?” Isaac el siyuk, “Efu ku oasr etong ac mulut kut us, a pia sheep fusr mwe kisa an?” ");
INSERT INTO kos_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ac Abraham el fahk, “God El ac fah ase.” Na eltal tukenina fahsr. ");
INSERT INTO kos_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ke eltal tuku nu ke acn se ma God El fahk nu sel kac, Abraham el etoak loang se ac takunla etong ah fac. El kapriya wen se natul ah, ac likilya fin etong ma oan fin loang ah. ");
INSERT INTO kos_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Na el srukak mitmit sac in unilya. ");
INSERT INTO kos_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tusruktu lipufan lun LEUM GOD el pang nu sel inkusrao me, “Abraham, Abraham!” Ac el topuk, “Nga pa inge.” ");
INSERT INTO kos_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Na lipufan sac fahk, “Nimet kom kahlya tulik sacn ku oru kutena ma nu sel. Inge nga etu lah kom akfulatye God ac akos ma El sapkin, mweyen kom tia sruokya wen sefanna nutum an lukel.” ");
INSERT INTO kos_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham el ngetnget nwe liyauk sheep mukul soko, sremla koacl ke sripin sak se. El som sruokya ac kisakin tuh in sie mwe kisa firir in aolla wen natul. ");
INSERT INTO kos_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham el sang inen acn sac, “LEUM GOD El Ase.” Fahsru nwe misenge, mwet uh srakna fahk ouinge, “Fineol sin LEUM GOD, El fah ase.” ");
INSERT INTO kos_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Lipufan lun LEUM GOD el pang nu sel Abraham inkusrao me pacl se akluo ");
INSERT INTO kos_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ac fahk, “LEUM GOD El fahk ouinge: ‘Nga orala sie wuleang ke Inek sifacna lah nga fah arulana akinsewowoye kom. Ke sripen kom tuh oru ma se inge, ac tia seko wen sefanna nutum, ");
INSERT INTO kos_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","nga wuleot nu sum lah nga ac fah akpusye fita nutum in pukanten oana itu inkusrao ku puk wekof uh. Fwilin tulik nutum ac fah kutangla mwet lokoalok lalos. ");
INSERT INTO kos_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Mutanfahl nukewa ac fah siyuk sik in akinsewowoyalos oana ke nga akinsewowoye fita lom. Ma inge nukewa ma na ke sripen kom tuh akos ma nga sapkin.’” ");
INSERT INTO kos_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraham el folokla nu yurin mwet kulansap lal, ac elos tukeni som nu Beersheba, yen Abraham el muta we. ");
INSERT INTO kos_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","In kutu pacl tok, Abraham el lohngak lah Milcah el oswela tulik oalkosr nu sel Nahor, tamulel lal Abraham: ");
INSERT INTO kos_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz wounse, Buz tamulel lal, Kemuel papa tumal Aram, ");
INSERT INTO kos_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Chesed, Hazo, Pildash, Jidlaph, ac Bethuel ");
INSERT INTO kos_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","papa tumal Rebecca. Milcah el oswela wen oalkosr inge nu sel Nahor, tamulel lal Abraham. ");
INSERT INTO kos_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Reumah, mutan kulansap kial Nahor, el oswella Tebah, Gaham, Tahash, ac Maacah. ");
INSERT INTO kos_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah el moul sun yac siofok longoul itkosr matwal. ");
INSERT INTO kos_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","El misa Hebron in acn Canaan, ac Abraham el asor yokna kacl. ");
INSERT INTO kos_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","El tuyak liki acn se ma monin mutan kial oan we, ac som nu yurin mwet Hit, ac fahk, ");
INSERT INTO kos_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nga mwetsac se muta inmasrlowos inge. Kukakunma sie ipin acn an nu sik, ngan pikinya mutan kiuk uh we.” ");
INSERT INTO kos_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Elos topuk, ");
INSERT INTO kos_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Mwet kacto, porongekut. Kut oek mu kom mwet kol fulat ac pwengpeng se. Kom ku in pikinya mutan kiom an ke kulyuk se ma wo emeet lasr uh. Kut nukewa arulana engan in asot sie kulyuk an nu sum, tuh kom fah pikinya mutan kiom an kac.” ");
INSERT INTO kos_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Na Abraham el pasrla ye mutalos ");
INSERT INTO kos_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ac fahk, “Kowos fin insese in lela nga in pikinya mutan kiuk uh inge, nunak munas siyuk sel Ephron, wen natul Zohar, ");
INSERT INTO kos_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","elan kukakunma luf se Machpelah, su oanna ke sisken acn lal. Siyuk elan kukakunma nu sik ke molo na pwaye an ye motowos, ac nga fah molela luk mwe kulyuk.” ");
INSERT INTO kos_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","In pacl sac, Ephron el wi mwet Hit wial muta ke acn in meeting se ke mutunpot nu in siti uh. Ac el topuk ye mutun mwet nukewa su muta in acn sac, ");
INSERT INTO kos_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Mwet kacto, porongeyu. Nga fah sot nu sum ipin acn sac nufon wi pac luf se ma oan we ah. Nga ac sot lom ye mutun mwet luk inge, tuh kom fah ku in pikinya mutan kiom an we.” ");
INSERT INTO kos_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Tusruktu Abraham el pasrla ye mutun mwet Hit uh ");
INSERT INTO kos_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ac fahk nu sel Ephron tuh mwet nukewa in ku in lohng, “Nga siyuk kom in nunak munas lohngwin ma nga ac fahk uh. Nga ac moli ipin acn nufon sac. Sruokya molo uh, tuh nga fah ku in pikinya mutan kiuk uh we.” ");
INSERT INTO kos_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron el topuk, ");
INSERT INTO kos_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mwet kacto, lupan molin acn uh ipin silver angfoko na — lupa se ingan ma na pilasr siktal. Pikinya na mutan kiom an we.” ");
INSERT INTO kos_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham el insese nu kac, ac srikeya lupa se ma Ephron el fahk ye mutun mwet ah — ipin silver angfoko, fal nu ke srikasrak ma orekmakinyuk sin mwet kuka. ");
INSERT INTO kos_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Pa oru acn sel Ephron in Machpelah, su oan kutulap in Mamre, tuh lal Abraham lac ah. Ma Ephron el kitaung uh pa acn ah, luf sac, ac sak nukewa fin acn sac, utyak na nwe ke masrol lal ah. ");
INSERT INTO kos_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Eteyuk sin mwet Hit nukewa su wi muta in pacl sac lah ma lac lal Abraham pa acn sac. ");
INSERT INTO kos_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Tukun ma inge, Abraham el piknilya Sarah, mutan kial, in luf se Machpelah in acn Canaan. ");
INSERT INTO kos_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ouinge ipin acn se su tuh ma lun mwet Hit ah meet, ac luf se ma oan we, ma lac lal Abraham mwe kulyuk. ");
INSERT INTO kos_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","In pacl se inge Abraham el arulana matuoh, tuh LEUM GOD El akinsewowoyal in ma nukewa el oru. ");
INSERT INTO kos_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","El fahk nu sin mwet kulansap se ma matu oemeet lal, su karingin ma lal nukewa, “Filiya poum inmasrlon epuk ac orala sie wulela nu sik. ");
INSERT INTO kos_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nga lungse kom in wulela Inen LEUM GOD, su God lun kusrao ac faclu, lah kom fah tia sulela sie mutan Canaan kien wen nutik uh. ");
INSERT INTO kos_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Enenu na kom in folokla nu in facl su nga matula we, ac eis sie mutan inmasrlon mwet luk tuh in mutan kial Isaac, wen nutik.” ");
INSERT INTO kos_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","A mwet kulansap sac siyuk, “Ac mutan sac fin tia lungse fahsr liki acn sel in wiyu tuku nu in acn Canaan? Ya nga ac supwala wen nutum in folokla nwe yen kom tuku we me an?” ");
INSERT INTO kos_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham el topuk, “Liyaung na kom in tia folokunla wen nutik uh nu we! ");
INSERT INTO kos_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","LEUM GOD lun kusrao El usyume liki acn sin papa tumuk ac liki sou luk, ac El orala wulela na ku se lal nu sik mu El ac sang acn se inge nu sin fwilin tulik nutik. El fah supwala lipufan lal meet liki kom, tuh kom fah ku in konauk sie mutan kien wen nutik uh we. ");
INSERT INTO kos_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mutan sac fin tia lungse wi kom tuku, na kom sukosok liki wulela se inge. Tusruktu ac fah wangin kutena sripa ac pwanang kom in folokunla wen nutik uh nu we.” ");
INSERT INTO kos_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ouinge mwet kulansap sac el filiya paol inmasrlon epal Abraham, leum lal, ac wulela in oru oana ma Abraham el fahk nu sel. ");
INSERT INTO kos_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ac mwet kulansap sac el us kain in mwe lung puspis fin singoul sin camel nutin leum lal, ac som nu ke siti se yen Nahor el muta we epang in acn Mesopotamia. ");
INSERT INTO kos_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ke el sun acn we, el orala camel uh in muta nu ten sisken lufin kof se likin siti sac. In pacl se inge ekela, pacl mutan uh in tuku ut kof. ");
INSERT INTO kos_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Mwet kulansap sac pre ac fahk, “O LEUM GOD, God lal Abraham leum luk, akwoye ouiyuk misenge, ac akpwayei wuleang lom nu sel Abraham, leum luk. ");
INSERT INTO kos_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nga a inge, sisken lufin kof se yen mutan fusr in siti uh ac tuku ut kof we. ");
INSERT INTO kos_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Nga fah fahk nu sin sie selos, ‘Nunak munas sruhkya sufa in kof nimom an nu ten, ac lela ngan nimya.’ El fin fahk, ‘Nimya, ac nga fah oayapa ut kof nimen camel nutum uh,’ lela tuh in pa inge mutan se ma kom sulela kial Isaac, mwet kulansap lom. Ma se inge fin sikyak, na nga ac fah etu lah kom akpwayei wulela lom nu sin leum luk.” ");
INSERT INTO kos_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Meet liki safla pre lal, Rebecca el sikla, us sufa in ut kof soko finpisal. El acn natul Bethuel, su wen natul Nahor ac Milcah. Nahor el tamulel lal Abraham. ");
INSERT INTO kos_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","El mutan fusr na kato se su soenna etu mwet. El tufokla nu ke lufin kof sac, nwakla sufa lal, ac foloko. ");
INSERT INTO kos_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Mwet kulansap sac kasrusr nu yorol ac fahk, “Nunak munas, ase ngan nimya kof in sufa nimom an.” ");
INSERT INTO kos_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mutan fusr sac fahk, “Mwet kacto, nimya.” Ac el sulaklak na sruhkya sufa lal nu ten liki finpisal, ac sruokya ke mwet kulansap sac nim. ");
INSERT INTO kos_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ke el nim tari, mutan sac fahk, “Kolya ngan utiya pac kof nimen camel nutum inge, ac sang eltal in nim na ke kuiyaltal.” ");
INSERT INTO kos_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Mutan sac el kina okoala sufa in kof sac nu in mwe nim kof lun kosro uh, ac kasrusr nu ke lufin kof ah in sifilpa ut kof, nwe ke na el kiteya nufonna camel nutin mukul sac. ");
INSERT INTO kos_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mukul sac tia kas, a el tuni na mutan fusr sac in liye lah LEUM GOD El akwoye ouiyen fahsr lal. ");
INSERT INTO kos_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ke camel ah nim kof tari, na mwet kulansap sac srukak ring gold na yohk molo se ac sang nu ke infwen mutan fusr sac, ac sang pac lohlpo gold luo nu ke paol. ");
INSERT INTO kos_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ac el fahk, “Nunak munas fahk nu sik lah su papa tomom uh. Ya mwesas lohm sel ah nu sik ac mwet luk inge in mongla we ofong?” ");
INSERT INTO kos_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Na mutan sac fahk, “Papa tumuk pa Bethuel, wen natul Nahor ac Milcah. ");
INSERT INTO kos_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Pukanten mah pao ac mongo nun kosro lohm ah, ac mwesas pac lohm ah kowos in mongla we.” ");
INSERT INTO kos_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Na mwet kulansap sac sikukmutunte ac alu nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","El fahk, “Kaksakin LEUM GOD, God lal Abraham, leum luk, su oaru in akpwayei wuleang lal nu sin leum luk. LEUM GOD El aksuwoswosye fahsr luk nu yurin sou lun leum luk.” ");
INSERT INTO kos_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mutan fusr sac kasrusr nu lohm sin nina kial, ac srumun ma inge nukewa nu sel. ");
INSERT INTO kos_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Oasr tamulel se lal Rebecca pangpang Laban, ac el kasrusr som nu ke lufin kof sac, nu yen mwet kulansap lal Abraham el muta we. ");
INSERT INTO kos_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Laban el tuh liye ring nu infwac se ac lohlpo ke poun tamtael lal, ac lohng pac ke mutan sac fahkak ma mwet kulansap sac fahk nu sel. El som nu yurin mwet kulansap lal Abraham, su tu sisken camel natul pe lufin kof sac, ");
INSERT INTO kos_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ac fahk, “Fahsru wiyu nu lohm ah. Kom sie mwet su LEUM GOD El akinsewowoye. Efu kom ku tu na inge? Oasr acn akola nu sum lohm ah, ac oasr pac acn nu sin camel nutum an.” ");
INSERT INTO kos_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ouinge mukul sac som nu lohm sac, ac Laban el tella ma fin camel ah, ac sang mah pao ac mongo nalos. Na el use kof nu yurin mwet kulansap lal Abraham ac mwet lal, in ohlla nialos. ");
INSERT INTO kos_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ke mongo uh utuku, mukul sac fahk, “Nga koflana eis mwe kasru inge nwe ke na nga fahkak sripen tuku luk uh.” Laban el fahk, “Srumun ma kom ac fahk an.” ");
INSERT INTO kos_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Na el fahk, “Nga mwet kulansap lal Abraham. ");
INSERT INTO kos_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","LEUM GOD El arulana akinsewowoye leum luk, oru el arulana kasrup. El sang nu sel un kosro puspis ke sheep, nani, cow, camel ac donkey, oayapa silver, gold, ac mwet kulansap mukul ac mutan. ");
INSERT INTO kos_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sarah, mutan kien leum luk, el oswela wen se nu sel ke el arulana matu, ac leum luk el sang ma lal nukewa nu sin wen sac tuh in ma lal. ");
INSERT INTO kos_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Leum luk el sap nga orala sie wuleang na ku se in akos ma el sapkin. El fahk, ‘Nimet sulela mutan kien wen nutik inmasrlon mutan in acn Canaan. ");
INSERT INTO kos_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","A som nu yurin mwet lun papa tumuk ac sou luk, ac sulela sie mutan ah kial we.’ ");
INSERT INTO kos_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ac nga siyuk sin leum luk, ‘Ac mutan sac fin tia lungse wiyu tuku?’ ");
INSERT INTO kos_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","El topukyu ac fahk, ‘LEUM GOD su nga akos pacl nukewa, El ac fah supu lipufan lal in wi kom, ac sot wo ouiya nu sum. Kom fah eis sie mutan ah kien wen nutik inmasrlon mwet luk ac sou lun papa tumuk. ");
INSERT INTO kos_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ma sefanna ac ku in aksukosokye kom liki wuleang se lom inge pa kom fin som nu yurin sou luk tuh elos tia lohng siyuk lom.’ ");
INSERT INTO kos_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ke nga tuku sun lufin kof sac misenge, nga pre ac fahk, ‘LEUM GOD lal Abraham leum luk, nunak munas ase wo ouiya nu ke ma nga fahsr kac uh. ");
INSERT INTO kos_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nga pa inge ke lufin kof uh. Ke pacl se sie mutan fusr ac tuku in ut kof uh, na nga ac siyuk sel elan ase kof ngan nimya liki sufa lal. ");
INSERT INTO kos_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","El fin etaten ac kiteyu kof, ac oayapa siyuk elan use kof nimen camel nutik uh, lela in el pa mutan se kom sulela tuh in mutan kien wen nutin leum luk!’ ");
INSERT INTO kos_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Meet liki nga aksafyela pre lun insiuk, Rebecca el sikla us sufa in ut kof soko finpisal, ac oatui nu ke lufin kof sac in ut kof. Nga fahk nu sel, ‘Nunak munas, se ngan nimya.’ ");
INSERT INTO kos_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","El kina eisya sufa sac liki finpisal ac fahk, ‘Nimya, ac nga ac fah sang pac kof nimen camel nutum uh.’ Ouinge nga nimya, ac el kiteya pac camel ah. ");
INSERT INTO kos_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Nga siyuk sel, ‘Su papa tomom uh?’ Ac el topuk, ‘Papa tumuk pa Bethuel, wen natul Nahor ac Milcah.’ Na nga sang ring se nu ke fwacl ac lohlpo luo nu ke paol. ");
INSERT INTO kos_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nga sikukmutunte ac alu nu sin LEUM GOD. Nga kaksakin LEUM GOD lal Abraham leum luk, su kolyume na nwe yurin sou lun leum luk, yen su nga konauk mutan fusr se natulos tuh in ma kien wen nutin leum luk. ");
INSERT INTO kos_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Inge, komtal fin akola in oru ip lomtal nu sin leum luk ac insese nu ke siyuk lal uh, na komtal nunak munas fahk nu sik. Ac fin tia, fahk pac, tuh nga in sulela lah mea nga ac oru.” ");
INSERT INTO kos_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Na Laban ac Bethuel topuk ac fahk, “Ke sripen ma inge ma sin LEUM GOD me uh, wanginna ma kut ac fahk. ");
INSERT INTO kos_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebecca el a inge. Usal ac som. Lela tuh elan mutan kien wen nutin leum lom, in oana ke LEUM GOD El fahk.” ");
INSERT INTO kos_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Pacl se mwet kulansap lal Abraham el lohng ma inge, el faksufi ac alu nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Na el tella nuknuk ac silver ac mwe yun gold, ac sang nu sel Rebecca. El oayapa sang mwe kite yohk molo nu sin tamulel lal ac nu sin nina kial. ");
INSERT INTO kos_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Na mwet kulansap lal Abraham ac mwet welul elos mongoi ac motulla we ke fong sac. Ke elos tukakek ke lotu se tok ah, mwet kulansap sac fahk, “Nunak munas, filikutla in folokla nu yurin leum luk.” ");
INSERT INTO kos_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tusruktu tamulel lal Rebecca ac nina kial eltal fahk, “Mea, Rebecca el tia ku in mutawin len singoul ma yorosr, na el fah wi kom som?” ");
INSERT INTO kos_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","A el fahk, “Nikmet ikol kut in sifilpa muta. LEUM GOD El akwoye fahsr se luk inge. Fuhlela nga in tari folokla nu yurin mwet kacto luk.” ");
INSERT INTO kos_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ac elos fahk, “Pangnolma Rebecca, kut in lohng lah mea el ac fahk.” ");
INSERT INTO kos_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ouinge elos pangnolma Rebecca ac siyuk, “Kom lungse wi mwet se inge som?” Ac el fahk, “Aok.” ");
INSERT INTO kos_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ke ma inge elos fuhlella Rebecca ac mutan kulansap se ma liyalang ke pacl el tulik ah yak, in wi mwet kulansap lal Abraham ac mwet lal ah som. ");
INSERT INTO kos_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ac elos akinsewowoyal Rebecca ac fahk, “Lela tuh kom, tamtael wiasr, in nina kien million! Ac fwilin tulik nutum in kutangla siti lun mwet lokoalok lalos!” ");
INSERT INTO kos_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Na Rebecca ac mutan fusr kulansap lal elos akola ac sroang nu fin camel uh in wi mwet kulansap lal Abraham. Na elos nukewa mukuiyak som. ");
INSERT INTO kos_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaac el tuku nu in acn turangang se ke “Lufin Kof Lun El Su Moul Ac Liyeyu,” ac el muta layen eir ke sie ipin acn Canaan. ");
INSERT INTO kos_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ke tufahna ekela el illa ac fufahsryesr in polo acn sac, ac liyauk kutu camel fahfahsru. ");
INSERT INTO kos_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ke Rebecca el liyalak Isaac, el fani liki camel el muta fac ");
INSERT INTO kos_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ac siyuk sin mwet kulansap lal Abraham, “Su mwet se fahsru nu yorosr ingo?” Na mwet kulansap sac topuk, “Pa ingo leum se luk uh.” Ouinge Rebecca el srukak nuknuk in afyuf lal ac sunya mutal. ");
INSERT INTO kos_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Mwet kulansap sac srumunang nu sel Isaac ma nukewa el tuh oru. ");
INSERT INTO kos_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Na Isaac el usalak Rebecca nu in lohm nuknuk se ma Sarah nina kial ah tuh muta we, ac el payukyak sel. Lungse lal Isaac nu sel Rebecca akwoyela asor lal ke wanginla lun nina kial. ");
INSERT INTO kos_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham el payukyak sin sie pac mutan, inel pa Keturah. ");
INSERT INTO kos_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Keturah el oswela nu sel Abraham: Zimran, Jokshan, Medan, Midian, Ishbak, ac Shuah. ");
INSERT INTO kos_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan pa papa tumal Sheba ac Dedan, ac fwilin tulik natul Dedan pa mwet Asshurim, mwet Letushim ac mwet Leummim. ");
INSERT INTO kos_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Wen natul Midian pa Ephah, Epher, Hanoch, Abida, ac Eldaah. Elos inge nukewa ma tuku kacl Keturah. ");
INSERT INTO kos_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham el filiya ma nukewa lal nu sel Isaac, ");
INSERT INTO kos_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","tusruktu ke el srakna moul, el sang pac mwe kite nu sin wen natul ma mutan kulansap kial elos oswela nu sel. Na el supwala wen natul inge nu in sie facl layen nu kutulap, tuh elos in muta loes lukel Isaac wen natul. ");
INSERT INTO kos_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Pa inge lusen moul lal Abraham: yac siofok itngoul limekosr. ");
INSERT INTO kos_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham el sisla mong safla lal ac misa ke el arulana matuoh. ");
INSERT INTO kos_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaac ac Ishmael, wen luo natul, eltal piknilya in Luf Machpelah in acn mwesas kutulap in Mamre, su tuh ma lal Ephron wen natul Zohar, mwet Hit. ");
INSERT INTO kos_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Pa inge ipin acn se ma Abraham el tuh molela sin mwet Hit ah. Abraham ac Sarah, mutan kial, eltal kewa pukpuki we. ");
INSERT INTO kos_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Tukun Abraham el misa, God El akinsewowoyal Isaac wen natul, su muta fototo nu ke acn se pangpang “Lufin Kof Lun El Su Moul Ac Liyeyu.” ");
INSERT INTO kos_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Pa inge wen natul Ishmael, su Hagar, mutan kulansap Egypt lal Sarah, el tuh oswela nu sel Abraham. ");
INSERT INTO kos_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Takla inelos fal nu ke matwalos: Nebaioth, Kedar, Adbeel, Mibsam, ");
INSERT INTO kos_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO kos_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish, ac Kedemah. ");
INSERT INTO kos_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Elos pa papa tumun sruf singoul luo, ac inelos itukyang nu ke inen acn elos muta we ac nien aktuktuk lalos. ");
INSERT INTO kos_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael el tuh yac siofok tolngoul itkosr ke el misa. ");
INSERT INTO kos_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Fwilin tulik natul Ishmael muta inmasrlon Havilah ac Shur, layen kutulap in acn Egypt, ke inkanek nu Assyria. Elos muta srengla liki tulik natul Abraham saya. ");
INSERT INTO kos_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Pa inge sramsram kacl Isaac wen natul Abraham. ");
INSERT INTO kos_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac el yac angngaul ke el payukyak sel Rebecca, acn natul Bethuel (sie mwet Aram ke acn Mesopotamia), ac el ma lohl Laban. ");
INSERT INTO kos_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ke sripen wangin tulik natul Rebecca, Isaac el pre nu sin LEUM GOD kacl. LEUM GOD El topuk pre lal, ac Rebecca el pitutuyak. ");
INSERT INTO kos_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Fak se pa insial, ac meet liki eltal isusla eltal amei na insien nina kialtal. Rebecca el fahk, “Efu ku sikyak ange nu sik?” Ouinge el som siyuk sin LEUM GOD kac. ");
INSERT INTO kos_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","LEUM GOD El fahk nu sel, “Mutunfacl luo oasr in kom. Kom ac oswela mutunfacl akwasui luo. Sie ac fah ku liki ma se ngia. El su matu ac fah kulansupu el su fusr.” ");
INSERT INTO kos_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ke sun pacl in isus lal ah, el oswela fak mukul se. ");
INSERT INTO kos_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Tulik se meet ah srusra manol, ac kolol arulana unacna oana sie nuknuk manan, ke ma inge itukyang inel Esau. ");
INSERT INTO kos_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Tulik se akluo el isusla tuh na el sruokna kapinnial Esau. Ouinge itukyang inel Jacob. Isaac el yac onngoul ke eltal isusla. ");
INSERT INTO kos_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Tulik mukul luo ah matula, ac Esau el mwet na etu sruh kosro se, ac el lungsena muta inimae, a Jacob el sukas ac el mutana in lohm uh. ");
INSERT INTO kos_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac el kuloel Esau, mweyen el lungse kang kosro inima ma Esau el muta sruok uh, a Rebecca el kuloel Jacob. ");
INSERT INTO kos_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Sie len ah ke Jacob el orek sup nal, Esau el foloko liki sruh kosro lal. El masrinsralla ");
INSERT INTO kos_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ac el fahk nu sel Jacob, “Nga ngulla na pwaye. Se nak kutu mongo srusra kom oru ingan.” (Pa ingan sripa se oru pangpang inel Edom.) ");
INSERT INTO kos_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob el topkol ac fahk, “Nga ac kite kom kom fin ase nu sik wal lun wounse lom.” ");
INSERT INTO kos_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau el fahk, “Kwal aok. Nga akura misa — mwe mea wal sac nu sik?” ");
INSERT INTO kos_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ac Jacob el fahk, “Fulahk nu sik lah kom ac se nu sik wal lom an.” Esau el fulahk ac kitala wal lal nu sel Jacob. ");
INSERT INTO kos_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Na Jacob el sang kutu bread ac kutu sup uh nal. El mongoi tari na el tuyak som. Pa na ingan luman pilesreyen wal se lal Esau ah sel. ");
INSERT INTO kos_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Tuh oasr pac sie sracl in facl sac sayen sracl se meet in pacl lal Abraham. Ke ma inge Isaac el mukuiyak som nu in acn Gerar, nu yorol Abimelech, tokosra lun mwet Philistia. ");
INSERT INTO kos_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","LEUM GOD El sikyang nu sel Isaac ac fahk nu sel, “Nimet kom som nu Egypt. Mutana in facl se inge, ke acn se nga ac fahk nu sum in muta we. ");
INSERT INTO kos_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Muta inge, ac nga ac fah wi kom ac akinsewowoye kom. Nga ac sot facl se inge nufon nu sum ac nu sin fwilin tulik nutum. Nga ac akpwayeye wulela se nga tuh orala nu sel Abraham, papa tomom. ");
INSERT INTO kos_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nga ac arulana akpusye fwilin tulik nutum ac elos ac fah oana pusiyen itu inkusrao, ac nga ac sang nu selos facl se inge nufon. Mutunfacl nukewa ac fah siyuk sik nga in akinsewowoyalos oana ke nga akinsewowoye fwil nutum. ");
INSERT INTO kos_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nga fah akinsewowoye kom, mweyen Abraham el tuh akosyu ac liyaung ma sap nukewa ac ma oakwuk nukewa su nga sapkin.” ");
INSERT INTO kos_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ouinge Isaac el mutana Gerar. ");
INSERT INTO kos_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ke mukul in acn we elos tuh siyuk ke mutan kial, el fahk nu selos mu ma loul pa Rebecca. El tiana fahkak lah mutan kial pa el, mweyen el sensen mukul we ac unilya ac eisalla Rebecca, mweyen el arulana oasku. ");
INSERT INTO kos_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Na ke Isaac el muta we paht kutu, Tokosra Abimelech el ngeti liki winto lal, ac liyalak Isaac ke el sritalel Rebecca. ");
INSERT INTO kos_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelech el sapla solalma Isaac ac fahk nu sel, “Ma kiom pa mutan sac! Efu ku kom fahk mu ma loum?” Na Isaac el fahk “Nga sensen mu nga ac fin fahk mu ma kiuk pa el, na ac anwuki nga.” ");
INSERT INTO kos_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Na Abimelech el fahk, “Mea se kom oru nu sesr inge? Sie sin mukul luk inge funu ona yurin mutan kiom an, lukun kom pa pwanma mwatasr.” ");
INSERT INTO kos_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Na Abimelech el akesmakye mwet nukewa, “Kutena mwet su oru koluk nu sin mwet se inge, ku mutan kial uh, ac fah anwuki.” ");
INSERT INTO kos_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac el oru ima se lal in facl sac, ac in yac sac el kosrani pacl siofok yohk liki lupan ma el taknelik, mweyen LEUM GOD El akinsewowoyal. ");
INSERT INTO kos_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","El kapkapak na in ma nukewa, oru el sie mwet arulana kasrup. ");
INSERT INTO kos_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Mweyen oasr un kosro puspis natul ke sheep ac cow ac mwet kulansap puspis lal, mwet Philistia elos sokyak sel. ");
INSERT INTO kos_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Lufin kof nukewa ma mwet kulansap lal Abraham, papa tumal, tuh pukanak ke el srakna moul, mwet Philistia elos nwakla ke fohk. ");
INSERT INTO kos_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Na Abimelech el fahk nu sel Isaac, “Fahla liki facl sesr uh. Kom arulana ku liki kut lac.” ");
INSERT INTO kos_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ouinge Isaac el som ac oakiya nien aktuktuk lal Infalfal Gerar, ac muta we. ");
INSERT INTO kos_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","El sifilpa pukanak lufin kof ma Abraham, papa tumal, el tuh pukanak in pacl lal, su mwet Philistia elos tuh taunya tukun Abraham el misa. Isaac el sang pacna inen lufin kof inge ke ine ma papa tumal ah tuh sang nu kac. ");
INSERT INTO kos_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Mwet kulansap lal Isaac ah pikin lufin kof se infalfal sac nwe sun unon in kof se. ");
INSERT INTO kos_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mwet liyaung kosro in acn Gerar elos alein nu sin mwet liyaung kosro lal Isaac, ac fahk, “Lufin kof se inge ma lasr.” Ouinge Isaac el sang inen luf sac “Alein.” ");
INSERT INTO kos_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Mwet kulansap lal Isaac elos sifilpa pukanak sie lufin kof, ac oasr pac alein kac. Ke ma inge el sang inen luf se inge, “Akwasui.” ");
INSERT INTO kos_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","El som liki acn sac ac sifilpa pukanak sie luf uh. Wangin alein nu sel ke luf se inge, ouinge el pangon luf sac, “Sukosok.” Ac el fahk, “Inge LEUM GOD El ase nu sesr sukosok in muta fin acn se inge, ac kut ac fah kapkapak fin acn se inge.” ");
INSERT INTO kos_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isaac el tuyak ac som nu Beersheba. ");
INSERT INTO kos_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","In fong sac LEUM GOD El sikyang nu sel ac fahk, “Nga God lal Abraham, papa tomom. Nik kom sangeng. Nga ac wi kom ac nga fah akinsewowoye kom ac sot fwilin tulik puspis nutum, ke sripen wuleang luk nu sel Abraham, mwet kulansap luk.” ");
INSERT INTO kos_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaac el etoak loang se we ac alu nu sin LEUM GOD. Na el tulokunak nien aktuktuk lal we, ac mwet kulansap lal elos sifilpla pukanak lufin kof se. ");
INSERT INTO kos_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelech el tuku Gerar me, usal Ahuzzath mwet kasru fulat lal, ac Phicol leum lun un mwet mweun lal welul, in tuh sonol Isaac. ");
INSERT INTO kos_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ke ma inge Isaac el siyuk, “Efu ku komtal tuku liyeyu? Komtal tuh srungayula ac lisyula liki facl sumtal ah.” ");
INSERT INTO kos_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Abimelech el topuk ac fahk, “Inge kut etu lah LEUM GOD El wi kom, ac kut nunku mu ac wona in oasr sie wulela na ku inmasrlosr. Kut lungse kom in wulela ");
INSERT INTO kos_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","lah kom ac tia aklokoalokye kut oapana ke kut tuh tiana aklokoalokye kom ah. Kut tuh kulang na nu sum ac supwekomla in misla. Inge kalem na sesr lah LEUM GOD El akinsewowoye kom.” ");
INSERT INTO kos_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaac el akoela kufwa se nu selos, ac elos tukeni mongoi. ");
INSERT INTO kos_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Toangna in lotu tok ah, eltal tukakek ac akkeyala wulela inmasrloltal. Na Isaac el wilkas nu selos, ac elos fahsrelik kawuk na wowo. ");
INSERT INTO kos_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ke len sacna mwet kulansap lal Isaac elos tuku ac fahkang nu sel ke lufin kof se ma elos pukanak. Elos fahk, “Kut konauk kof.” ");
INSERT INTO kos_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","El sang inen lufin kof sac “Wuleang Ku.” Pa ingan sripa se oru pangpang siti sac Beersheba. ");
INSERT INTO kos_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ke Esau el yac angngaul, el payukyak sin mutan Hit luo: Judith acn natul Beeri, ac Basemath acn natul Elon. ");
INSERT INTO kos_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Mutan luo inge arulana aktoasryal Isaac ac Rebecca. ");
INSERT INTO kos_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","In pacl se inge Isaac el matuoh ac mutawauk in sulonginla. El sapla solalma Esau, wen se ma matu natul, ac fahk nu sel, “Wen nutik!” Esau el topuk, “Nga inge.” ");
INSERT INTO kos_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaac el fahk, “Kom liye lah nga matuoh ac apkuran in misa. ");
INSERT INTO kos_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Us mwe pisr nutum an ac sruokma soko kosro inima an nak. ");
INSERT INTO kos_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Orauk kain in mongo yuyu se ma nga lungsena kang ah, ac use nu yuruk. Nga ac mongo tari, na nga fah akinsewowoyekomla meet liki nga misa.” ");
INSERT INTO kos_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ke pacl se Isaac el kaskas nu sel Esau inge, Rebecca el lohng na. Ouinge ke Esau el illa som in sruh kosro, ");
INSERT INTO kos_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebecca el fahk nu sel Jacob, “Nga lohng lah ingena papa tomom fahk nu sel Esau ange: ");
INSERT INTO kos_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Use soko kosro inima an ac akmolyela nak. Tukun nga ac mongo tari, na nga ac akinsewowoye kom ye mutun LEUM GOD meet liki nga misa.’” ");
INSERT INTO kos_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Rebecca el tafwela ac fahk, “Wen nutik, porongo akwoye ac oru ma nga fahk uh. ");
INSERT INTO kos_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Fahla nu ke un kosro uh, ac srela lukwa nani fusr na fact an. Use ngan tuh akmolyela ac orala kain mongo se ma papa tomom el arulana lungse yohk ah. ");
INSERT INTO kos_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kom ku in usla nu yorol elan kang, elan mau akinsewowoyekomla meet liki el misa.” ");
INSERT INTO kos_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tusruktu Jacob el fahk nu sin nina kial, “Kom etu na lah manol Esau unacna, a monuk fwel. ");
INSERT INTO kos_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Papa el ac tuh kahl monuk ac konauk lah nga kiapwel. Ac fin ange, ac tia akinsewowoyeyuk nga, a el ac selngaiyuwi.” ");
INSERT INTO kos_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nina kial ah fahk, “Wen nutik, lela kutena selnga nu sum an in oan fuk. Oru na ma nga fahk uh. Fahla use nani an.” ");
INSERT INTO kos_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ouinge el som sruokya nani uh, ac use nu yurin nina kial, ac el orala kain mongo se ma papa sac arulana lungse ah. ");
INSERT INTO kos_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Na Rebecca el srukak nuknuk se ma wo emeet lal Esau su oan yorol in lohm uh, ac sang nokmulang Jacob. ");
INSERT INTO kos_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","El sang kulun nani uh nu fin paol Jacob, oayapa nu fin acn ma tia unacna ke kawal. ");
INSERT INTO kos_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Na el sang mwe mongo yuyu sac, ac bread ma el munanla nu sel. ");
INSERT INTO kos_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Na Jacob el som nu yurin papa tumal ah, ac fahk, “Papa!” El topuk, “Nga inge. Su kac sumtal ingan?” ");
INSERT INTO kos_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob el fahk, “Nga Esau, wen matu nutum. Ma kom sap ngan orala nom ah pa inge. Tukakek mongoi, kom in tari akinsewowoyeyula.” ");
INSERT INTO kos_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac el fahk nu sin wen natul, “Ku kom oru fuka tuh kom arulana sa konauk?” Jacob el fahk, LEUM GOD lom El kasreyu konauk.” ");
INSERT INTO kos_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac el fahk nu sel Jacob, “Kaluku ngan kahlkomi. Pwayena lah kom pa Esau?” ");
INSERT INTO kos_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob el kalukyang nu yurin papa tumal ah, na Isaac el kahlilya ac fahk, “Pusrem oana pusracl Jacob, a poum paol Esau.” ");
INSERT INTO kos_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","El tiana akilenul Jacob, mweyen paol oana paol Esau. El akola elan akinsewowoyal, ");
INSERT INTO kos_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","na el sifilpa siyuk, “Ku pwayena kom pa Esau?” Ac el topuk, “Aok, pwaye.” ");
INSERT INTO kos_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaac el fahk, “Kolma mongo an nu yuruk ngan kang. Nga ac mongo tari, na nga fah akinsewowoyekomla.” Jacob el kolang nu yorol, ac el oayapa sang wain nimal. ");
INSERT INTO kos_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Na papa tumal ah fahk nu sel, “Kaluku, wen nutik, ac ngokya mutuk.” ");
INSERT INTO kos_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ac ke el kalukyang in ngok mutal, Isaac el ngokak nuknuk lal, ouinge el akinsewowoyalla. Ac el fahk, “Foulin wen nutik uh loslos oana foulin ima ma LEUM GOD El akinsewowoye. ");
INSERT INTO kos_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","God Elan asot nu sum aunfong inkusrao me, ac akkasrupye fohkon acn in ima lom! Ac lela Elan akpusye wheat ac wain lom! ");
INSERT INTO kos_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Mutunfacl puspis in kulansap nu sum, ac mwet uh in faksufi ye motom. Lela kom in leum fin sou lom nukewa, ac fwilin tulik nutin nina kiom in akfulatye kom. Lela elos su selngawi kom in selngawiyuk, ac elos su akinsewowoye kom in akinsewowoyeyuk.” ");
INSERT INTO kos_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaac el akinsewowoyela Jacob tari, na Jacob el tuyak som. Tia paht na Esau, tamulel lal, el foloko liki sruh kosro lal. ");
INSERT INTO kos_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","El oayapa akmolyela mwe mongo na yuyu ac usla nu yurin papa tumal. Ac el fahk, “Papa, tukakek kang kutu ikwen kosro nga us tuku nom inge, kom in tari akinsewowoyeyula.” ");
INSERT INTO kos_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ac Isaac el siyuk, “Ku su kom an?” Ac Esau el fahk, “Nga Esau, wounse mukul nutum.” ");
INSERT INTO kos_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Manol Isaac nufon rarrarak, ac el siyuk, “Fin angan, ac su sruhk uniya kosro soko use nak ah? Nga mongo tufahna tari na pa kom utyak. Nga sang nufon mwe insewowo luk nu sel, ac inge ac ma na lal nwe tok.” ");
INSERT INTO kos_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ke Esau el lohng ma inge, el liksreni tung ac wowoyak, ac fahk, “Papa, akinsewowoyeyu pac!” ");
INSERT INTO kos_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaac el fahk, “Tamulel lom el tuku ac kiapweyula. El eisla tari mwe insewowo lom.” ");
INSERT INTO kos_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau el fahk, “Pacl luola el aklalfonyeyu. Fal in pangpang inel Jacob. El eisla wal lun wounse luk, ac inge el eisla pac mwe insewowo luk. Ya wangin na pwaye mwe insewowo lula kom filiya luk?” ");
INSERT INTO kos_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac el topuk, “Nga orala tari elan leum fom, ac tuh mwet wial nukewa fah mwet kulansap lal. Nga sang nu sel wheat ac wain. Inge, wen nutik, wangin ma nga ku in oru nu sum!” ");
INSERT INTO kos_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau el sifil pacna kwafe nu sin papa tumal ah, ac fahk, “Ya mwe insewowo sefanna lom, papa? Akinsewowoyeyu pac!” Na el sifilpa tung. ");
INSERT INTO kos_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Na Isaac el fahk nu sel, “Wangin aunfong nu sum inkusrao me, Wangin acn wo ke ima uh lom. ");
INSERT INTO kos_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Cutlass nutum pa ac sot enenu lom, Ac kom fah kulansupu tamulel lom. Tusruktu kom fin tuyak lainul, Kom ac fah pisrla liki ye nununku lal.” ");
INSERT INTO kos_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau el arulana srungalla Jacob, mweyen papa tumal ah tuh sang mwe insewowo ah nu sel. Ac el nunku sel sifacna, “Akuranna sun pacl in eoksra ke misa lal papa. Fin safla, na nga ac unilya Jacob.” ");
INSERT INTO kos_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Tusruktu ke Rebecca el lohng ke akoo lal Esau ah, el sapla solalma Jacob ac fahk nu sel, “Esau tamulel lom, el akoo in foloksak nu sum ac unikomi. ");
INSERT INTO kos_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Wen nutik, inge kom oru ma nga fahk uh. Fahla ingena nwe yorol Laban tamulel luk in acn Haran, ");
INSERT INTO kos_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ac muta yorol nwe ke na kasrkusrak lun tamulel lom ohula ");
INSERT INTO kos_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ac el mulkunla ma kom oru nu sel inge. Tok nga ac fah supwaot sie mwet in folokinkomme. Mwe mea wen luo nutik in tukenina wanginla ke len sefanna?” ");
INSERT INTO kos_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebecca el fahk nu sel Isaac, “Nga keokla sin mutan Hit kial Esau inge. Jacob el fin payukyak pac sin sie mutan Hit, ac mansis pacna ngan tari misa.” ");
INSERT INTO kos_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac el solalma Jacob, paingul ac fahk nu sel, “Nimet kom payuk sin mutan Canaan inge. ");
INSERT INTO kos_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","A kom som nu Mesopotamia, nu yen sel Bethuel, papa matu tomom, ac payukyak sin sie mutan we ah, siena sin acn natul Laban, su ma lin nina kiom. ");
INSERT INTO kos_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","God Kulana Elan akinsewowoye payuk lom, ac sot in pus tulik nutum, tuh kom fah papa tumun mutunfacl puspis! ");
INSERT INTO kos_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Lela Elan akinsewowoye kom ac fwilin tulik nutum oana ke El tuh akinsewowoyal Abraham, tuh facl se su kom muta we inge, su God El sang lal Abraham, in fah ma lom!” ");
INSERT INTO kos_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaac el supwalla Jacob nu Mesopotamia, nu yorol Laban, wen natul Bethuel mwet Aram, su ma lel Rebecca, nina kial Jacob ac Esau. ");
INSERT INTO kos_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau el lohngak lah Isaac el akinsewowoyal Jacob ac supwalla nu Mesopotamia in sokak sie mutan kial we. El oayapa lohng lah ke Isaac el akinsewowoyal Jacob el sapkin nu sel elan tia payuk sin mutan Canaan. ");
INSERT INTO kos_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","El lohngak pac lah Jacob el akos na papa tumal ac nina kial, ac som nu Mesopotamia. ");
INSERT INTO kos_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ouinge Esau el akilen lah Isaac, papa tumal, el tia lungse elan payuk nu sin mutan Canaan. ");
INSERT INTO kos_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ke ma inge Esau el som nu yorol Ishmael, wen natul Abraham, ac payukyak sel Mahalath, sie acn natul Ishmael, su ma loul Nebaioth. ");
INSERT INTO kos_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob el fahsr liki acn Beersheba in som nu Haran. ");
INSERT INTO kos_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ke faht uh tili el sun sie acn mutal ac aktuktuk we. Ke el ona in motul, el eloangak eot se. ");
INSERT INTO kos_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","El mweme mu el liye nien fan se tuyak faclu yak sun acn inkusrao, ac lipufan uh fani ac fanyak fac. ");
INSERT INTO kos_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ac LEUM GOD El tu siskal ac fahk, “Nga LEUM GOD lal Abraham ac Isaac. Nga fah sot nu sum, ac fwilin tulik nutum, acn se ma kom oan we inge. ");
INSERT INTO kos_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Elos ac fah mau arulana pukanten oana puk fin faclu. Elos ac fah akyokye facl selos nu kutulap, roto, epang ac eir. Ac nga fah akinsewowoye mutunfacl nukewa keim ac fwilin tulik nutum. ");
INSERT INTO kos_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Esam, nga ac fah wi kom ac langoekom yen nukewa kom som nu we, ac nga ac fah folokinkomme nu fin acn se inge. Nga ac tiana fahsr liki kom nwe ke na nga orala ma nukewa nga wuleot nu sum.” ");
INSERT INTO kos_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob el asmakla ac fahk, “Pwaye na pwaye, LEUM GOD El oasr in acn se inge a nga tiana etu!” ");
INSERT INTO kos_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","El sangeng ac fahk, “Acn na oal se pa inge! Tia ana acn, a ma sin God. Ku pacna in pa inge mutunpot nu in kusrao.” ");
INSERT INTO kos_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jacob el toangna tukakek ke lotu tok ah, eis eot se ma el ilung ah, ac tulokunak tuh in sie mwe esmakin. Na el ukuiya oil in olive nu fac, in kisakunang nu sin God. ");
INSERT INTO kos_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","El sang inen acn sac Bethel. (Siti srisrik sac pangpang Luz meet.) ");
INSERT INTO kos_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Na Jacob el orala wulela se nu sin LEUM GOD, ac fahk ouinge: “Kom fin wiyu ac karinginyu in fahsr se luk inge, ac kasreyu ke mwe mongo ac nuknuk, ");
INSERT INTO kos_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ac nga fin moul folokla sun acn sin papa tumuk, na kom fah God luk. ");
INSERT INTO kos_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Eot in esmakin se su nga oakiya inge ac fah acn in alu nu sum, ac nga fah asot nu sum sie tafu singoul ke ma nukewa ma kom ase nu sik.” ");
INSERT INTO kos_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob el fahsr liki acn sac ac som tulanya facl sin mwet layen nu kutulap. ");
INSERT INTO kos_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","El fahsr nwe liyauk lufin kof se inimae ac u tolu ke sheep oan mongla siska. Mwet uh elos kite sheep natulos ke kof in luf se inge. Oasr eot tupasrpasr lulap se sang afin luf sac. ");
INSERT INTO kos_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Pacl se ma un sheep nukewa ac fahsreni uh, mwet karingin sheep inge ac epusla eot sac ac kiteya sheep natulos. Na toko elos fah sifil oakeang eot sac in afinya. ");
INSERT INTO kos_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob el siyuk sin mwet liyaung sheep uh, “Kowos mwet ya?” Elos fahk, “Kut mwet Haran.” ");
INSERT INTO kos_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","El siyuk selos, “Ku kowos etal Laban, su ac ma natul Nahor?” Ac elos fahk, “Aok, kut etal.” ");
INSERT INTO kos_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Na el siyuk, “Ac el fuka?” Elos topuk, “El ku na. Ngetot liye, tulik mutan se natul pa pwen un sheep natul fahsru ingo. El pa Rachel.” ");
INSERT INTO kos_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jacob el fahk, “Liye, srakna infulwen len, soenna pacl in utukeni sheep uh. Kowos ku tia kiteya ke kof ac folokunulosla nu inima elos in mongo we?” ");
INSERT INTO kos_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Elos fahk, “Kut tia wi oru angan. Ac soaneyuk nwe ke na un sheep nukewa faseni, ac eot se inge ipisyukla, na kut fah sang kof nimalos.” ");
INSERT INTO kos_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ke Jacob el srakna kaskas nu selos, Rachel el tuku wi un sheep nutin papa tumal ah. ");
INSERT INTO kos_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ke Jacob el liyalak Rachel, el som nu ke lufin kof uh ac epusla eot sac, na sang kof nimen sheep natul Laban, su ma loun nina kial. ");
INSERT INTO kos_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Na Jacob el ngok mutal Rachel, ac tung ke sripen engan lal. ");
INSERT INTO kos_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","El fahkang nu sel, “Nga wen natul Rebecca, sou lun papa tomom.” Na Rachel el yula ac fahkang nu sin papa tumal ah. ");
INSERT INTO kos_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ac ke papa sac lohng pweng kacl Jacob, mukul se nutin ma loul, el kasrusr som in sonol. El sruokilya ac ngok mutal, na el usalla nu in lohm sel. Ke Jacob el srumunang nu sel Laban ma nukewa ma sikyak nu sel ah, ");
INSERT INTO kos_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban el fahk, “Pwaye na pwaye lah kut srah sefanna.” Na Jacob el muta yorol malem se. ");
INSERT INTO kos_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban el fahk nu sel Jacob, “Kut finne sou, kom fah tia orekma nu sik ke wangin molo. Nga ac akfalye nu sum fuka?” ");
INSERT INTO kos_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Oasr acn luo natul Laban — inen ma se ma matu ah pa Leah, ac ma se ma srik ah pa Rachel. ");
INSERT INTO kos_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Wo mutal Leah, tusruktu Rachel el arulana oasku ac wo pac lumahl. ");
INSERT INTO kos_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob el arulana lungse Rachel, ac el fahk, “Nga ac orekma nu sum yac itkosr, kom fin usalu Rachel kiuk.” ");
INSERT INTO kos_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban el topuk, “Nga ac lungse eisalot nu sum liki na in eisalang nu sin kutena mwet saya. Tari, mutana yuruk.” ");
INSERT INTO kos_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jacob el orekma yac itkosr elan mau ku in eisal Rachel, ac ke sripen el lungse el yohk, yac itkosr sac oana in pacl na fototo se nu sel. ");
INSERT INTO kos_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Na Jacob el fahk nu sel Laban, “Sun tari lusen pacl sac. Fuhlela nga in payukyak sin acn nutum.” ");
INSERT INTO kos_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ouinge Laban el oru kufwen marut se ac suli mwet nukewa. ");
INSERT INTO kos_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tusruktu in fong sac, el tia usal Rachel, a el eisalang Leah nu sel Jacob, ac Jacob el ona yorol. ( ");
INSERT INTO kos_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban el eisalang Zilpah, mutan kulansap lal, nu sel Leah, acn natul, tuh elan mutan kulansap lal.) ");
INSERT INTO kos_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Jacob el tiana etu nwe ke lotutang tok ah lah Leah pa oan yorol ah. El som nu yorol Laban ac fahk, “Efu kom ku oru ange nu sik? Nga orekma kacl Rachel, na efu kom ku kiapweyula?” ");
INSERT INTO kos_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban el fahk, “Ouiya lasr uh, kut tia ku in sang el su srik in payukyak meet liki el su matu. ");
INSERT INTO kos_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tupan in safla wik in akfulat lun marut uh, na nga fah eisalot Rachel nu sum, kom fin sifilpa orekma luk ke yac itkosr.” ");
INSERT INTO kos_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob el insese nu kac, ac ke safla wik in akfulat ke marut uh, Laban el eisalang Rachel, acn natul, tuh elan mutan pac kial. ( ");
INSERT INTO kos_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban el eisalang Bilhah, mutan kulansap lal, nu sel Rachel, acn natul, tuh elan mutan kulansap lal.) ");
INSERT INTO kos_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacob el ona yorol Rachel pac, ac el lungse Rachel yohk lukel Leah. Ouinge el sifilpa orekma nu sel Laban ke yac itkosr pac. ");
INSERT INTO kos_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ke LEUM GOD El liye lah srik lungse lal Jacob nu sel Leah lukel Rachel, El oru tuh in oasr tulik natul Leah, a funu Rachel, wangin tulik natul. ");
INSERT INTO kos_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah el pitutuyak ac oswela wen se. El fahk, “LEUM GOD El liye keok luk, ac inge mukul tumuk uh ac fah lungsela nga.” Ouinge el sang inen tulik sac Reuben. ");
INSERT INTO kos_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","El sifilpa pitutuyak ac oswela pac wen se. El fahk, “LEUM GOD El ase pac wen se inge nutik, mweyen El lohng lah srungayuk na nga.” Ke ma inge el sang inen tulik sac Simeon. ");
INSERT INTO kos_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","El sifilpa pitutuyak ac oswela pac wen se. Na el fahk, “Inge mukul tumuk uh ac arulana kupasrme nu sik liki na meet ah, mweyen nga osweang wen tolu nu sel.” Ke ma inge el sang inen wen sac Levi. ");
INSERT INTO kos_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Toko el sifilpa pitutuyak ac oswela wen se. Ac el fahk, “Inge nga fah kaksakin LEUM GOD.” Ouinge el sang inen wen sac Judah. Na wotyak isus lal uh. ");
INSERT INTO kos_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Tusruktu wanginna tulik Rachel el osweang nu sel Jacob, oru el mutawauk in lemtai tamtael lal, ac fahk nu sel Jacob, “Orala kutu tulik ah nutik. Kom fin tia, nga ac misa.” ");
INSERT INTO kos_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob el kasrkusrak sel Rachel ac fahk, “Tia nga pa God — El na pa oru kom in tia orek tulik uh.” ");
INSERT INTO kos_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rachel el fahk, “Bilhah, mutan kulansap luk, el a inge. Ona yorol tuh elan ku in orala sie tulik ah nutik. Fin ouinge ku in oaoala mu nina se pa nga.” ");
INSERT INTO kos_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ouinge el eisalang Bilhah nu sin mukul tumal, ac el ona yorol. ");
INSERT INTO kos_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah el pitutuyak ac oswela wen se nu sel Jacob. ");
INSERT INTO kos_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel el fahk, “God El oru nununku lal ac ase enenu luk. El lohng kwafe luk ac ase wen se nutik.” Ouinge el sang inen tulik sac Dan. ");
INSERT INTO kos_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhah el sifilpa pitutuyak ac oswela wen se akluo nu sel Jacob. ");
INSERT INTO kos_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel el fahk, “Nga alein yokna nu sin tamtael luk, tusruktu inge nga kutangla.” Ke ma inge el sang inen tulik sac Naphtali. ");
INSERT INTO kos_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ke Leah el akilenak lah tui orek tulik lal, el eisalang Zilpah, mutan kulansap lal, nu sel Jacob, tuh in oana mutan se kial. ");
INSERT INTO kos_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Na Zilpah el oswela wen se nu sel Jacob. ");
INSERT INTO kos_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah el fahk, “Wola ouiyuk.” Ouinge el sang inen tulik sac Gad. ");
INSERT INTO kos_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpah el sifilpa osweang wen se nu sel Jacob, ");
INSERT INTO kos_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","na Leah el fahk, “Arulana yohk engan luk! Inge mutan uh ac pangonyu engan.” Ouinge el sang inen tulik sac Asher. ");
INSERT INTO kos_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ke pacl in kosrani wheat, Reuben el som nu inima uh tuh konauk kutu mandrake, na el us tuku nu yorol Leah, nina kial. Ac Rachel el fahk nu sel Leah, “Nunak munas, se nak kutu mandrake ma tulik nutum an us tuku an.” ");
INSERT INTO kos_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leah el topuk, “Mea tia fal tari ke kom eisla mukul tumuk ah? A inge kom srike in eisla mandrake lun wen nutik uh.” Na Rachel el fahk, “Kom fin ase mandrake lun wen nutum an, na kom ku in ona yorol Jacob ofong.” ");
INSERT INTO kos_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ke Jacob el foloko liki inima uh ke ekela, Leah el illa in osun nu sel ac fahk, “Kom ac motul yuruk ofong, mweyen nga molikomla tari ke mandrake lun wen nutik.” Ke ma inge Jacob el motulla yorol Leah ke fong sac. ");
INSERT INTO kos_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God El topuk pre lal Leah, ac el sifilpa pitutuyak ac osweang nu sel Jacob wen se aklimekosr. ");
INSERT INTO kos_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah el fahk, “God El ase nu sik sie ma lacne, mweyen nga sang mutan kulansap luk nu sin mukul tumuk.” Ouinge el sang inen wen se natul inge Issachar. ");
INSERT INTO kos_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah el sifilpa pitutuyak ac oswela wen se akonkosr nu sel Jacob. ");
INSERT INTO kos_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ac el fahk, “God El ase nu sik sie mwe kite na wowo. Inge mukul tumuk uh ac eisyu, mweyen nga osweang nu sel wen onkosr.” Ke ma inge el sang inel Zebulun. ");
INSERT INTO kos_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Toko el oswela tulik mutan se, ac sang inel Dinah. ");
INSERT INTO kos_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Na God El esamulak Rachel. El topuk pre lal ac oru elan ku in isus. ");
INSERT INTO kos_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","El pitutuyak ac oswela wen se. Na el fahk, “God El eisla mwekin luk ac ase wen se nutik.” ");
INSERT INTO kos_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","“Finsrak LEUM GOD Elan ku in sifilpa ase sie wen ah nutik.” Ouinge el sang inen tulik sac Joseph. ");
INSERT INTO kos_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Tukun isusla lal Joseph, Jacob el fahk nu sel Laban, “Filiyula nga in folokla nu yen sik. ");
INSERT INTO kos_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ase mutan kiuk ac tulik nutik su nga kulansap nu sum kac, ac nga fah som. Kom arulana etu woiyen orekma luk ke nga kulansap nu sum.” ");
INSERT INTO kos_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban el fahk nu sel, “Ngan fahkwin ma se: Nga konauk ke susfa lah LEUM GOD El akinsewowoyeyu ke sripom. ");
INSERT INTO kos_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Fahkma sie lupan mol an nu ke orekma lom, ac nga fah moli kom kac, kom in mau mutana yuruk.” ");
INSERT INTO kos_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ac Jacob el fahk, “Kom etu na ouiyen orekma luk nu sum, ac lupan puseni lun un kosro nutum ke pacl nga karingin ah. ");
INSERT INTO kos_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Meet liki nga tuku ah, supus kosro nutum, ac inge arulana pukanteni. Ac LEUM GOD El akinsewowoye kom in acn nukewa nga kulansupwekom we. Inge pacl fal nu sik in suk ma ac wo nu sik ac sou luk.” ");
INSERT INTO kos_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Na Laban el sifil pacna siyuk, “Lupa su kom lungse ngan moli kom kac uh?” Ac Jacob el topuk, “Nga tia lungse kutena kain in moul, tuh nga ac srakna karingin un kosro nutum kom fin insese nu ke nunak se luk inge: ");
INSERT INTO kos_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Fuhlela nga in som ac fahsr inmasrlon un kosro nutum nukewa misenge, ac srela sheep fusr sroalsroal nukewa, ac nani fusr ma tuhntun nukewa. Ac pa na ingan molin orekma luk uh. ");
INSERT INTO kos_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ke pacl fahsru ac fisrasr nu sum in konauk lah nga pwaye in kulansap luk uh ku tia. Ke pacl kom ac tuku in liye molin orekma luk uh, fin oasr nani ma tia tuhntun ku sheep ma tia sroalsroal yuruk, kom ac etu na lah ma pusrla.” ");
INSERT INTO kos_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban el fahk, “Wona. Kut ac oru oana ma kom fahk an.” ");
INSERT INTO kos_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tusruktu, ke len sac pacna Laban el usla nani mukul ma tuhntun ac ma mutan nukewa ma oasr tuhn fasrfasr kac. El oayapa usla sheep sroalsroal nukewa, ac el sang wen natul in liyaung ma inge. ");
INSERT INTO kos_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Na el som lukel Jacob wi kosro ma el eisla uh, ac fahsr ke lusa se ma el ac ku in fahsr ke len tolu. Jacob el mutana karingin ma lula ke un kosro natul Laban. ");
INSERT INTO kos_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob el eis kutu lesak moul ke sak poplar, sak almond, ac sak plane, ac kolosla kutu kolo ah liki, tuh lesak uh fah oasr koa fasrfasr oan kac. ");
INSERT INTO kos_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","El kaskiya lesak inge ye mutun un kosro uh ke acn in nim kof lalos. El filiya lesak inge we, mweyen kosro inge ac tutu we ke pacl elos tuku in nim kof uh. ");
INSERT INTO kos_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ouinge ke nani uh ac forang nu ke lesak inge ke elos afanuki, fahkolos ac tuhntun. ");
INSERT INTO kos_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob el taran na sheep uh in srisrila liki nani uh, ac oru tuh elos in tu ngetang nu yurin kosro tuhntun ac kosro sroalsroal ke u in kosro natul Laban uh. Ke el oru ouinge uh, el akpusye un kosro natul sifacna, ac srela liki ma natul Laban. ");
INSERT INTO kos_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ke kosro ma ku ikwa uh ac afanuki uh, Jacob el ac filiya lesak uh ye mutalos ke acn in nim kof lalos, kosro inge in mau tutu in masrlon lesak inge. ");
INSERT INTO kos_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tusruktu el tiana filiya lesak ye mutun kosro ma munas ikwa uh. Ouinge sikyak tuh na kosro munas nukewa ma natul Laban, ac ma ku ikwa nukewa ma natul Jacob. ");
INSERT INTO kos_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ke ouinge uh, Jacob el arulana kasrupi. Pukanteni u in kosro natul, mwet kulansap lal, oayapa camel ac donkey. ");
INSERT INTO kos_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob el lohngak lah wen natul Laban elos fahk mu, “Jacob el eisla ma nukewa lun papa tumasr uh. Kasrup lal uh ma na ke ma lun papa tumasr uh.” ");
INSERT INTO kos_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob el akilenak pac lah Laban el tia sifilpa kulang oana meet ah. ");
INSERT INTO kos_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Na LEUM GOD El fahk nu sel, “Folokla nu yen sin papa tomom ac nu yurin sou lom. Nga ac fah wi kom.” ");
INSERT INTO kos_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ke ma inge Jacob el sapla nu sel Rachel ac Leah, eltal in tuku osun nu sel yen ma un kosro natul uh muta we. ");
INSERT INTO kos_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","El fahk nu seltal, “Nga liye tuh papa tomomtal ah tiana sifil kulang nu sik oana meet ah. Tusruktu, God lun papa tumuk El nuna wiyu na. ");
INSERT INTO kos_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Komtal kewa etu na lah nga orekma nu sin papa tomomtal ah ke kuiyuk nufon. ");
INSERT INTO kos_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Nwe ouinge, a el kutasrik na nu sik ac ekulla molin orekma luk uh pacl singoul. Tusruktu God El tiana lela elan oru kutena mwe ongoiya nu sik. ");
INSERT INTO kos_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Pacl nukewa Laban el fin fahk, ‘Nani tuhntun ingan pa ac moli orekma lom,’ na kosro nukewa ac oswe natu tuhntun. Ac el fin fahk, ‘Nani kwarmok uh pa ac moli orekma lom,’ na u in kosro nukewa ac oswe natu kwarmok. ");
INSERT INTO kos_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","God El eisla u in kosro liki papa tomomtal ac use nutik.” ");
INSERT INTO kos_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Ke pacl in orek fahko lun un kosro uh nga tuh mwemei ac liye lah nani mukul ma orek fahko uh ma na kwarmok ac tuhntun. ");
INSERT INTO kos_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Na lipufan lun God el kaskas nu sik in mweme sac ac fahk, ‘Jacob!’ Ac nga fahk, ‘Nga.’ ");
INSERT INTO kos_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ac el fahk, ‘Liye, nani mukul nukewa ma orek fahko inge ma kwarmok ac tuhntun. Nga oru in ouinge mweyen nga liye ma nukewa ma Laban el oru nu sum. ");
INSERT INTO kos_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nga pa God se su tuh sikwot nu sum in acn Bethel, yen se ma kom tuh ukuiya oil in olive nu fin eot se ac kisakin tuh in sie mwe esmakin, ac kom tuh orala sie wuleang nu sik we. Akola kom in folokla nu in facl se ma kom isusla we.’” ");
INSERT INTO kos_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel ac Leah topkol Jacob ac fahk, “Wangin ma lula kut ac usrui sin papa tumasr. ");
INSERT INTO kos_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","El orekut oana mwetsac uh. El kukakinkutla, ac inge el sisla nufon mani ma moulyang nu sel kacsr ah. ");
INSERT INTO kos_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mwe kasrup nukewa ma God El eisla liki papa tumasr ah inge, ma lasr ac tulik natusr. Oru na ma God El fahk kom in oru an.” ");
INSERT INTO kos_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ouinge Jacob el tuyak, ac srakang tulik natul ac mutan kial nu fin camel uh, ");
INSERT INTO kos_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ac pwanla kosro natul nukewa, ac ma lal nukewa ma el eis ke orekma lal, ac kosro natul ma el eis in acn Mesopotamia, na el mukuiyak in som nu yorol Isaac, papa tumal, in facl Canaan. ");
INSERT INTO kos_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban el som in kalla sheep natul, ac ke pacl se el wangin inge, Rachel el usla ma sruloala srisrik ma oan in lohm sin papa tumal ah. ");
INSERT INTO kos_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob el sulallal nu sel Laban ac tia akkalemye nu sel lah el ac som lukel. ");
INSERT INTO kos_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","El us ma nukewa lal ac sulaklak na mukuiyak som. El tupalla Infacl Euphrates ac tulanya infulan eol in acn Gilead. ");
INSERT INTO kos_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Len tolu toko, fwackyang nu sel Laban lah Jacob el kaingla. ");
INSERT INTO kos_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban el us mwet lal welul ac ukwal Jacob ke len itkosr, nwe ke el sonol infulan eol in Gilead. ");
INSERT INTO kos_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","God El sikyang nu sel Laban in sie mweme ke fong sac ac fahk nu sel, “Taran na kom in tia fahk kutena kas in aksangeng nu sel Jacob.” ");
INSERT INTO kos_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban el ukwal Jacob nwe sonol infulan eol in Gilead, yen Jacob el aktuktuk we. Laban ac mwet lal elos oayapa aktuktuk we. ");
INSERT INTO kos_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban el fahk nu sel Jacob, “Efu ku kom sulallal nu sik ac usla acn nutik ingan in oana luman mutan ma sruhu ke mweun? ");
INSERT INTO kos_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Efu kom ku kutasrik nu sik ac mahsrikme na tia fahk? Kom funu fahk, nga lukun filikomla ke engan lulap, ac on alullul wi pusren mwe srital ac harp. ");
INSERT INTO kos_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kom tia pacna lela nga in wilkas nu sin acn nutik, ku ngokya mutun tulik natultal inge. Ouiya na koluk se pa kom oru ingan! ");
INSERT INTO kos_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Oasr ku luk in kai kom, tusruktu God lun papa tomom El kaskas nu sik fong, ac fahk mu ngan taran na nga in tia fahk kutena kas in aksangeng nu sum. ");
INSERT INTO kos_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nga etu lah kom tuyak tuku mweyen kom kena tari folok nu yen sum, a efu kom ku usla ma sruloala srisrik ma oan in lohm sik ah?” ");
INSERT INTO kos_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob el topuk, “Nga tuh sangeng, mweyen nga nunku mu kom ac eisla acn nutum inge likiyu. ");
INSERT INTO kos_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tusruktu kom fin konauk lah god lom an oasr sin siena sin mwet inge, mwet sacn ac fah anwuki. Inge, ye mutun mwet lasr kewa, fahsru suk. Fin oasr kutena ma lom kom konauk yorosr, kom us.” Jacob el tiana etu lah Rachel el pisrala god lal Laban. ");
INSERT INTO kos_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban el som ac iluhs lohm nuknuk sel Jacob. Toko el som nu in lohm nuknuk sel Leah, ac lohm nuknuk sin mutan kulansap luo, tusruktu el tiana konauk god lal ah. Na el som nu in lohm nuknuk sel Rachel. ");
INSERT INTO kos_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel pa srukak ma sruloala ma oan in lohm nuknuk sel Laban, ac sang nu luin pak se ma ac oan fin camel uh, ac muta fac. Laban el iluhs lohm nuknuk sac nufon, tusruk el tiana konauk ma sruloala uh. ");
INSERT INTO kos_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachel el fahk nu sin papa tumal, “Nimet kom kasrkusrak sik, papa. Nga tia ku in tuyak, mweyen ingena nga mas mutan.” Laban el sukna ma sruloala lal ah tuh el tiana konauk. ");
INSERT INTO kos_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Na Jacob el kasrkusrakak ac siyuk sel Laban, “Mea nga oru koluk? Ma sap su nga kunausla ku kom ukweyume nwe inse? ");
INSERT INTO kos_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Inge ke kom iluhsya ma luk nukewa uh, mea kom konauk mu ma lom oasr yorosr? Srakma filiya inse inge, mwet lasr uh kewa in tukeni ngetani liye, ac fahk lah su pwaye se. ");
INSERT INTO kos_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nga muta yurum yac longoulla inge, ac sheep nutum ac nani nutum uh tia tui in isus fahko, ac nga tiana kangla sokofanna sheep mukul ke u in kosro nutum uh. ");
INSERT INTO kos_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Pacl nukewa ma kosro lemnak uh uniya soko inmasrlon sheep nutum uh, nga tia us tuku nu ye motom kom in liye, a nga sifacna aolla ke sheep nutik. Kom sap ngan akfalye kutena ma su pusrla ke len ku ke fong. ");
INSERT INTO kos_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Pacl puspis nga keok ke fulen len ac ohu in fong. Nga tia ku in motul. ");
INSERT INTO kos_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Pwana ingan ma nga pulakin ke lusen yac longoul nga muta yurum. Nga orekma yac singoul akosr in eis acn luo nutum, ac yac onkosr nu ke un kosro nutik inge. Ne ouinge, a kom ikil molin orekma luk pacl singoul. ");
INSERT INTO kos_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","God lal Abraham ac God lal Isaac, papa tumuk, funu tia wiyu, kom lukun supweyula pisinpo. Tusruktu God El liyena elya luk ac orekma ma nga orala, ac El kai kom kac fong.” ");
INSERT INTO kos_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban el topkol Jacob ac fahk, “Mutan luo inge ma nutik. Ma pac nutik pa tulik natultal inge, ac un kosro inge ma pac nutik. Ma nukewa kom liye inge ma luk. Tusruktu ke wangin ma nga ku in oru in folokonma acn luo nutik ac tulik natultal inge, ");
INSERT INTO kos_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","nga akola in oru sie wuleang inmasrlok kom. Lela kut in orala sie ma in akesmakinye kut ke wuleang se inge. ");
INSERT INTO kos_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ouinge Jacob el eis eot lulap se ac tulokunak tuh in sie mwe esmakin. ");
INSERT INTO kos_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","El fahk nu sin mwet lal in orani kutu eot ac elosak. Na elos mongoi sisken yol in eot sac. ");
INSERT INTO kos_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban el sang inen yol in eot se inge Jegar Sahadutha, a Jacob el pangon Galeed. ");
INSERT INTO kos_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban el fahk nu sel Jacob, “Yol in eot se inge ac fah mwe akesmakinye kut kewa.” Pa pwanang inen acn sac pangpang Galeed. ");
INSERT INTO kos_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban el oayapa fahk, “Lela LEUM GOD Elan tawikuti ke kut fahsrelik sie sin sie.” Ke ma inge itukyang pac inen acn sac Mizpah. ");
INSERT INTO kos_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laban el sifilpa fahk, “Kom fin oru koluk acn nutik inge, ku payuk pac sin mutan saya, nga finne tia liye, kom esam lah God El tawikuti na. ");
INSERT INTO kos_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Pa inge eot ma nga elosak ac eot lulap se mwe esmakin inmasrlok kom. ");
INSERT INTO kos_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Yol se inge ac eot in esmakin se inge kewa ma in akesmakinye kut. Nga fah tia aliki yol se inge in mweuni kom ac kom fah tia pac alukela ku aliki eot in esmakin se inge in mweuniyu. ");
INSERT INTO kos_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","God lal Abraham ac God lal Nahor fah aksuwosye inmasrlosr.” Na Jacob el wulela na ku Inen God su Isaac, papa tumal, el alu nu se, lah el fah liyaung na wuleang se inge. ");
INSERT INTO kos_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","El uniya kosro soko, ac sang in mwe kisa fin eol uh, ac el pangoneni mwet lal elos in mongo. Tukun elos mongo tari, elos mongla fin eol uh ke fong sac. ");
INSERT INTO kos_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Toangna in lotu tok ah, Laban el wilkas nu sin acn luo natul ac ngok mutaltal ac tulik natulos, na folokla nu yen sel. ");
INSERT INTO kos_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ke Jacob el som liki acn sac, oasr kutu lipufan lun God sonol. ");
INSERT INTO kos_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ke el liyalosyak el fahk, “Acn in aktuktuk se lun God pa inge.” Ke ma inge el sang inen acn sac Mahanaim. ");
INSERT INTO kos_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob el supwala kutu mwet utuk kas lal in som meet lukel nu yorol Esau, tamulel lal in facl Edom. ");
INSERT INTO kos_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","El sap elos in fahk nu sel Esau ouinge: “Nga Jacob, mwet kulansap lom, tukakinyu nu sum, Esau, mwet kacto luk, lah nga tuh som muta yorol Laban, ac nga tuh ikolla pacl in folok luk nwe ke pacl se inge. ");
INSERT INTO kos_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Oasr cow, donkey, sheep, ac nani nutik, oayapa mwet kulansap luk mukul ac mutan. Nga supwaot kas luk nu sum, mwet kacto luk, ac finsrak mu in oasr kulang lom nu sik.” ");
INSERT INTO kos_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ke mwet utuk kas inge foloko nu yorol Jacob elos fahk, “Kut tuh som nu yorol Esau tamulel lom, ac el mukuiyak tari in tuku osun nu sum. Oasr mwet angfoko lal welul.” ");
INSERT INTO kos_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacob el sangeng ac fosrnga. El kitalik mwet ma welul ah nu ke u luo, oayapa sheep, nani, cow, ac camel natul uh. ");
INSERT INTO kos_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","El nunku sel mu, “Esau el fin tuku ac mweuni u se meet ah, na u se saya ac ku in kaingla.” ");
INSERT INTO kos_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Na Jacob el pre, “O God lal Abraham papa matu tumuk, ac God lal Isaac papa tumuk, porongeyu! LEUM GOD, kom tuh fahk nu sik mu nga in folokla nu yen sik ac nu yurin mwet luk, ac kom ac fah akwoye ma nukewa nu sik. ");
INSERT INTO kos_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Nga kupansuwol nu ke lupan kulang nukewa ac oaru lom su kom akkalemye nu sik, mwet kulansap lom. Ke nga som ah, nga fahsr alukela Infacl Jordan, wangin ma nga us sayen sikal soko, a inge nga foloko wi u luo inge. ");
INSERT INTO kos_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nga pre nu sum, ac siyuk kom in moliyula lukel Esau, tamulel luk. Nga sangeng ac sensen mu el ac tuku mweuni kut ac sikikutla nufon, nwe ke mutan ac tulik inge. ");
INSERT INTO kos_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Esam lah kom tuh wulema mu kom ac oru ma nukewa in fahsr wo nu sik, ac ase fwilin tulik puspis nutik su wangin mwet ac ku in oakla, mweyen elos ac pukanten oana puk wekof uh.” ");
INSERT INTO kos_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ouinge, el motulla we ke fong sac, ac el srela mwe lung nu sel Esau, ma lel, liki ma el us welul ah: ");
INSERT INTO kos_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","nani mutan luofoko ac nani mukul longoul, sheep mutan luofoko ac ma mukul longoul, ");
INSERT INTO kos_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","camel litop tolngoul ac natu natulos, cow mutan angngaul ac ma mukul singoul, donkey mutan longoul ac ma mukul singoul. ");
INSERT INTO kos_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","El kitalik kosro inge nu ke u, ac filiya kais sie mwet kulansap lal in karingin kais sie un kosro. El fahk nu selos, “Fahsrot fahsr meet likiyu, ac oru in oasr masrol ke un kosro nukewa.” ");
INSERT INTO kos_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","El sap nu sin mwet kulansap se ma fahsr oemeet, ac fahk, “Esau, ma lik, el fin sun kom ac siyuk, ‘Su mwet kacto lom uh? Kom ac som nu ya? Ac nutin su kosro ma kom pwen inge?’ ");
INSERT INTO kos_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","kom fah topuk, ‘Ma natul Jacob, mwet kulansap lom. El supu nu yorol Esau, leum lal, tuh in sie mwe kite nu sel. Jacob el a fahsru tokosr uh.’” ");
INSERT INTO kos_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","El fahk oana inge nu sin el su akluo, aktolu, ac nu selos nukewa saya ma karingin kais sie u in kosro uh. “Pa inge ma kowos ac fahk nu sel Esau ke pacl se kowos ac sonol. ");
INSERT INTO kos_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kowos enenu in fahk, ‘Aok, Jacob mwet kulansap lom el a na tokosr uh.’ Jacob el nunku sel sifacna mu, “Nga ac aklungyal ke mwe kite inge, ac ke pacl se nga ac osun nu sel uh, sahp el ac nunak munas nu sik.” ");
INSERT INTO kos_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","El supwala mwe kite ingan meet lukel, ac el motulla ke nien aktuktuk lal ke fong sac. ");
INSERT INTO kos_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","In fong sacna, Jacob el tukakek, eis mutan luo kial, mutan kulansap luo kial, ac tulik singoul sie natul, ac fahsr tupalla Infacl Jabbok. ");
INSERT INTO kos_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Tukun el supwalosla tupalla infacl ah, el oayapa supwala ma nukewa lal, ");
INSERT INTO kos_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","a el mukena muta. Na mwet se tuku apurak nu sel nwe ke na apkuran in lenelik. ");
INSERT INTO kos_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ke mwet sac liye lah el ac kofla kutangulla, el liksreni tukya fonohl Jacob ac tusrilelik kupasr in fonohl. ");
INSERT INTO kos_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Na mwet sac fahk, “Filiyula ngan som. Akuranna lenelik.” Ac Jacob el fahk, “Nga ac tia filikomla nwe ke na kom akinsewowoyeyula.” ");
INSERT INTO kos_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Na mwet sac siyuk sel, “Su inem an?” Ac el fahk, “Jacob.” ");
INSERT INTO kos_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Na mwet sac sifilpa fahk, “Inem ac fah tia sifilpa pangpang Jacob. Kom amei yurin God ac yurin mwet, ac kom kutangla. Ke ma inge inem ac fah pangpang Israel.” ");
INSERT INTO kos_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob el fahk, “Ac kom, su inem an?” Ac mwet sac fahk, “Efu ku kom ke etu inek?” Na el akinsewowoyalla Jacob. ");
INSERT INTO kos_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob el fahk, “Nga liye na pwaye God ke mutuk, ac nga srakna moul.” Ouinge el sang inen acn sac Peniel. ");
INSERT INTO kos_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Faht ah takak ke Jacob el som liki acn Peniel, ac el fahsr osak mweyen ngal fonohl. ");
INSERT INTO kos_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Fwilin tulik natul Israel uh tia kang ikwa ma oan fin kupasr ke fonoh nwe misenge, mweyen acn se inge pa tukyuki kacl Jacob ah. ");
INSERT INTO kos_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob el liye lah Esau el tuku wi mwet angfoko lal, ke ma inge el kitalik tulik natul ah inmasrlol Leah, Rachel, ac mutan kulansap luo kial. ");
INSERT INTO kos_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","El likiya mutan kulansap kial ac tulik natultal ah meet, na Leah ac tulik natul ah, na fah Rachel ac Joseph oetok. ");
INSERT INTO kos_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jacob el fahsryak meet lukelos, ac faksufi nwe infohk uh pacl itkosr ke el fahsryang nu ye mutun tamulel lal. ");
INSERT INTO kos_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","A Esau el kasrusr nu yorol, kaosulma ac ngok mutal. Ac eltal tukeni tung. ");
INSERT INTO kos_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ke Esau el ngetla ac liye mutan ac tulik uh, el siyuk, “Su mwet wi kom inge?” Ac Jacob el topuk, “Mwet kacto luk, tulik inge ma God El kulang ac ase nu sin mwet kulansap lom.” ");
INSERT INTO kos_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Na mutan kulansap kial uh tuku wi tulik natultal, ac faksufi nwe infohk uh. ");
INSERT INTO kos_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Toko Leah ac tulik natul tuku ac faksufi pac, na Joseph ac Rachel fahsryak oetok ac faksufi. ");
INSERT INTO kos_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ac Esau el siyuk, “Ma ya sruhk u se nga fahsru sun ah? Mea kalmac?” Ac Jacob el fahk, “Ma in akfisrasrye nunak lom.” ");
INSERT INTO kos_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tusruktu Esau el fahk, “Ma lik, fal ma oasr yuruk uh. Tari, sruokyana ma lom an.” ");
INSERT INTO kos_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob el fahk, “Mo, fin pwaye lah kom eisyu, nunak munas eis mwe kite luk inge. Nu sik, ke nga liye motom uh, oana ngan liye mutun God, ke kom arulana kulang nu sik uh. ");
INSERT INTO kos_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nunak munas, eis mwe kite ma nga us nu yurum inge. God El arulana kulang nu sik ac ase mwe enenu luk nukewa.” Jacob el sikalani na in kwafe nwe ke na Esau el eis. ");
INSERT INTO kos_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau el fahk, “Akola kut in som. Nga ac fahsr meet.” ");
INSERT INTO kos_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob el topuk ac fahk, “Kom etu lah tulik inge munas, ac nga ac nunku pac ke sheep ac cow wi natu natulos uh. Fin upala pahtokyalos finne len se, u nufon se inge ac misa. ");
INSERT INTO kos_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nunak munas, fahsr meet likiyu, ac nga ac fahsrna tukum, wi kuiyen fahsr lun un kosro ac tulik inge, nwe ke nga sun kom in acn Edom.” ");
INSERT INTO kos_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau el fahk, “Fin angan, nga filiya kutu mwet luk inge in wi kom.” Tusruktu Jacob el fahk, “Tari mansis, kulo. Fin wo sum, nimet elya kac.” ");
INSERT INTO kos_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ouinge Esau el mukuiyak ke len sac in folok nu Edom. ");
INSERT INTO kos_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ac Jacob el som nu Sukkoth, musaela lohm se sel we, ac orala lac lohm nu sin kosro natul. Pa pwanang pangpang acn sac Sukkoth. ");
INSERT INTO kos_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ke Jacob el foloko liki acn Mesopotamia el sun siti Shechem in acn Canaan. Wona ouiyal, ac el tulokunak nien aktuktuk lal in sie acn oan apkuran nu ke siti sac. ");
INSERT INTO kos_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","El molela ipin acn sac sin fwilin tulik natul Hamor, papa tumal Shechem, ke ipin silver siofok. ");
INSERT INTO kos_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","El etoak loang se we, ac sang inen loang sac “El,” su God lun Israel. ");
INSERT INTO kos_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Sie len ah Dinah, acn natul Jacob ac Leah, el som in mutwata yurin kutu mutan Canaan. ");
INSERT INTO kos_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Oasr wen se natul Hamor, mwet Hiv su leumi facl sac. Inen wen se natul pa Shechem. Ke Shechem el liyalak Dinah, el sruinkuilya ac usalla akkolukyal. ");
INSERT INTO kos_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Tusruktu ke Shechem el liye lah mutan sac arulana oasku, el lungseyak el, ac el srike in oru mutan sac in lungse pac el. ");
INSERT INTO kos_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ac el fahk nu sin papa tumal, “Nga ke kom in use mutan se inge kiuk.” ");
INSERT INTO kos_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacob el lohngak lah acn se natul ah akkolukyeyukla, tusruktu ke sripen wen natul ah kewa som oasr inimae yurin kosro natul, el tiana oru kutena ma nwe ke na elos foloko. ");
INSERT INTO kos_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor, papa tumal Shechem, el som in pwapa nu sel Jacob, ");
INSERT INTO kos_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ke pacl se na ma wen natul Jacob elos foloko liki inimae. Ke wen natul Jacob inge lohngak ke ouiya koluk sac, elos lut ac arulana kasrkusrak lah Shechem el orala ouiya sac, ac aklusrongtenye mwet Israel ke el sruinkui ac akkolukye acn natul Jacob. ");
INSERT INTO kos_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Na Hamor el fahk nu sel Jacob, “Shechem, wen nutik, el lungseyak acn se nutum ingan. Nunak munas eisalang kial.” ");
INSERT INTO kos_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ac el sifilpa fahk, “Wona kut in orala sie pwapa ah, ac insese tuh in oasr apayuki inmasrlon mwet lasr ac mwet lowos. ");
INSERT INTO kos_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Na kowos fah ku in wi kut na muta in facl sesr uh, ac muta yen na kowos lungse muta we. Kowos fah sukosok in moli ac in kuka yorosr, ac in oasr pac acn lowos sifacna inge.” ");
INSERT INTO kos_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Na Shechem el fahk nu sin papa tumal Dinah ac mwet lel, “Kowos fin oru enenu se luk inge, na nga ac fah sot kutena ma kowos lungse. ");
INSERT INTO kos_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Fahkma nu sik lah mwe kite fuka kowos lungse, ac sang pac in yohk molin mutan se inge ke lupa na kowos lungse. Nga ac sot kutena ma kowos siyuk kac, kowos fin fuhlela nga in payuk sel.” ");
INSERT INTO kos_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Wen natul Jacob arulana toasr lah Shechem el akkolukyalla Dinah, tamtael lalos, ouinge elos kikiap in topkol Shechem ac Hamor, papa tumal. ");
INSERT INTO kos_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Elos fahk, “Kut koflana fuhlela ma lousr in payuk sin mwet ma tia kosrala. Ma se ingan ac akmwekinye kut. ");
INSERT INTO kos_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Kut ac ku in insesela fin twe mukul nukewa lowos kosrkosrla oana kut. ");
INSERT INTO kos_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ac kut ac fah oayapa insese in apayuki. Kut ac fah oakwuki muta inmasrlowos ac in ma sefannala nu suwos. ");
INSERT INTO kos_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tusruktu kowos fin tia insese nu ke ma kut fahk uh ac kosrkosrla, na kut ac eis ma lousr uh ac som.” ");
INSERT INTO kos_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kas inge wo sel Hamor ac Shechem, wen natul, ");
INSERT INTO kos_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ac mukul fusr sac sulaklak na in oru ma elos fahk uh, mweyen el arulana lungse acn natul Jacob. El pa mukul se ma oa emeet in sou lun papa tumal. ");
INSERT INTO kos_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor ac Shechem, wen natul, eltal som nu ke acn in tukeni ke mutunpot in siti uh ac sramsram nu sin mwet wialtal in acn sac. ");
INSERT INTO kos_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Eltal fahk, “Mwet inge elos kulang na. Lela nu selos in wi kut na muta fin acn uh, ac in sukosok in forfor. Acn sesr uh yohk, fal pac nu selos. Lela kut in payuk sin mutan natulos ac sang pac elos in payuk sin mutan natusr uh. ");
INSERT INTO kos_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Tusruktu elos ac insese in muta inmasrlosr, ac ma sefannala nu sesr, mukul nukewa lasr uh fin twe kosrkosrla oana elos. ");
INSERT INTO kos_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ya kosro natulos nukewa ac ma lalos nukewa saya ac tia ma lac lasr? Ke ma inge lela kut in insesela mu elos in muta inmasrlosr.” ");
INSERT INTO kos_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Mwet nukewa ke siti sac insese nu ke pwapa lal Hamor ac Shechem, ouinge mukul nukewa we kosrkosrla. ");
INSERT INTO kos_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tukun len tolu, ke mukul uh srakna maskin kosrkosrla lalos, luo sin wen natul Jacob, Simeon ac Levi tamulel lal Dinah, eltal us cutlass natultal, mahsrikla nu in siti uh, ac uniya mukul nukewa we, ");
INSERT INTO kos_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","welulang Hamor ac Shechem, wen natul. Na etal eisal Dinah liki lohm sel Shechem ac som. ");
INSERT INTO kos_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Tukun anwukla mwet uh, wen saya natul Jacob elos utyak nu in siti sac, ac usla ma nukewa we in foloksak ke akmwekinyeyukla tamtael se lalos. ");
INSERT INTO kos_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Elos usla un kosro, cow, donkey, ac ma nukewa saya, in siti sac ac inimae. ");
INSERT INTO kos_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Elos eis ma saok nukewa, sruokya mutan ac tulik nukewa, ac usla ma nukewa in lohm sin mwet we ah. ");
INSERT INTO kos_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jacob el fahk nu sel Simeon ac Levi, “Komtal ac pwanma ongoiya nu sik. Inge mwet Canaan, mwet Periz, ac mwet nukewa saya in acn se inge ac fah srungayula. Tia pus mwet luk, a elos nukewa fin toeni ac mweuniyu, sou nufon se lasr inge ac sikiyukla!” ");
INSERT INTO kos_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tusruktu elos topuk ac fahk, “Kut tia ku in lela ma lousr in orek oana sie mutan kosro.” ");
INSERT INTO kos_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","God El fahk nu sel Jacob, “Som nu Bethel ingena ac muta we. Musaela sie loang ah luk we, nga God se su tuh sikwot nu sum pacl se kom tuh kaing lukel Esau, tamulel lom.” ");
INSERT INTO kos_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ouinge Jacob el fahk nu sin sou lal ac mwet nukewa ma welul, “Sisla god saya ma oan yuruwos an. Aknasnasyekowosla, ac nokomang nuknuk nasnas tuh kowos in nasnas ye mutun God. ");
INSERT INTO kos_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kut ac som liki acn se inge nu Bethel, yen su nga ac fah musaela sie loang nu sin God se su tuh kasreyu in pacl in ongoiya nu sik, ac su nuna wiyu na yen nukewa nga fahsr nu we.” ");
INSERT INTO kos_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ouinge elos sang nu sel Jacob god sac nukewa ma oasr yorolos, ac oayapa yaring ma elos orekmakin. El pikinya ma inge ye sak oak soko apkuran nu Shechem. ");
INSERT INTO kos_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ke Jacob ac wen natul nukewa mukuiyak in som, mwet nukewa su muta in siti srisrik ma apkuran elos arulana sangeng, ac tiana ukwalos. ");
INSERT INTO kos_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob el tuku wi mwet lal nukewa nu Luz, su pangpang Bethel in pacl inge, in acn Canaan. ");
INSERT INTO kos_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","El etoak loang se we ac sang Inen God lun Bethel nu kac, mweyen God El tuh sifacna sikyang nu sel we ke pacl se el tuh kaingkin tamulel lal ah. ");
INSERT INTO kos_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deborah, mutan tutaf lal Rebecca, el misa ac pukpuki ye sak oak soko layen eir in acn Bethel. Ouinge acn sac pangpang “Sak Oak in Tung.” ");
INSERT INTO kos_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ke pacl se Jacob el foloko liki acn Mesopotamia, God El sifilpa sikyang nu sel ac akinsewowoyal. ");
INSERT INTO kos_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","God El fahk nu sel, “Inem pa Jacob, tusruktu ingela inem ac fah pangpang Israel.” Ouinge God El sang inel Israel. ");
INSERT INTO kos_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ac God El fahk nu sel, “Nga God Kulana. Lela tuh in oasr tulik puspis nutum. Mutunfacl puspis ac fah tuku ke fwilin tulik nutum, ac kom ac fah papa tumun tokosra puspis. ");
INSERT INTO kos_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nga ac sot nu sum acn ma nga tuh sang nu sel Abraham ac nu sel Isaac, ac nga fah oayapa sang nu sin fwilin tulik nutum tok.” ");
INSERT INTO kos_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Na God El som lukel. ");
INSERT INTO kos_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob el tulokunak eot in esmakin se in acn se ma God El kaskas nu sel we inge, ac akmutalyela ke el ukuiya wain ac oil in olive nu fac. ");
INSERT INTO kos_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ac el sang inen acn sac Bethel. ");
INSERT INTO kos_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Jacob ac sou lal som liki acn Bethel, ac ke elos srakna loes liki acn Ephrath, na sun pacl in isus lal Rachel, ac arulana upa nu sel in isus. ");
INSERT INTO kos_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ke pacl se ma upala na pwaye ngal in isus lal, mutan akisus lal el akkeyal ac fahk, “Rachel, akkeye kom. Tulik mukul se pac pa inge.” ");
INSERT INTO kos_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tusruktu Rachel el munaslana in misa, ac ke el apkuran in fuhlakinla mong safla lal, el sang inen tulik se natul uh Benoni, a papa tumun tulik sac sang inel Benjamin. ");
INSERT INTO kos_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ke Rachel el misa, pukpuki el sisken inkanek nu Ephrath, su pangpang Bethlehem in pacl inge. ");
INSERT INTO kos_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob el tulokunak eot in esmakin se we, ac srakna akilenya kulyuk lal Rachel nwe misenge. ");
INSERT INTO kos_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Jacob el sifilpa mukuiyak fahsr nu meet, ac ke el alukela tower Eder el tulokunak iwen aktuktuk lal we. ");
INSERT INTO kos_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ke Jacob el muta in acn sac, Reuben el ona yorol Bilhah, sie sin mutan kulansap kien papa tumal. Ke Jacob el lohngak el arulana foloyak. Oasr wen singoul luo natul Jacob. ");
INSERT INTO kos_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Wen natul Leah pa Reuben (wen se omeet natul Jacob), Simeon, Levi, Judah, Issachar, ac Zebulun. ");
INSERT INTO kos_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Wen natul Rachel pa Joseph ac Benjamin. ");
INSERT INTO kos_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Wen natul Bilhah, mutan kulansap lal Rachel, pa Dan ac Naphtali. ");
INSERT INTO kos_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Wen natul Zilpah, mutan kulansap lal Leah, pa Gad ac Asher. Mukul natul Jacob inge nukewa isusla Mesopotamia. ");
INSERT INTO kos_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob el som nu yorol Isaac, papa tumal, in acn Mamre, apkuran nu Hebron, yen Abraham ac Isaac tuh muta we. ");
INSERT INTO kos_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac el moul nwe ke el sun yac siofok oalngoul, ");
INSERT INTO kos_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ac el misa ke el arulana matuoh. Ac Esau ac Jacob, wen luo natul, eltal piknilya. ");
INSERT INTO kos_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Pa inge fwilin tulik natul Esau, su oayapa pangpang Edom. ");
INSERT INTO kos_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau el payuk sin mutan Canaan inge: Adah, acn natul Elon mwet Hit; Oholibamah, acn natul Anah wen natul Zibeon mwet Hiv; ");
INSERT INTO kos_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ac Basemath, acn natul Ishmael ac tamtael lal Nebaioth. ");
INSERT INTO kos_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah el oswella Eliphaz. Basemath el oswella Reuel. ");
INSERT INTO kos_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamah el oswella Jeush, Jalam, ac Korah. Mukul inge nukewa isusyang nu sel Esau in acn Canaan. ");
INSERT INTO kos_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Na Esau el us mutan kial, wen natul, acn natul, ac mwet nukewa in lohm sel, wi kosro nukewa natul ac ma lal nukewa ma el eis in acn Canaan, ac som lukel Jacob, tamulel lal, nu ke sie pac acn. ");
INSERT INTO kos_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","El som mweyen acn ma el ac Jacob tukeni orekmakin sufalla nu ke enenu laltal. Arulana puseni kosro natultal kewa, pwanang eltal tia ku in tukeni muta. ");
INSERT INTO kos_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ouinge Esau el som ac muta infulan eol in acn Edom. ");
INSERT INTO kos_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Pa inge fwilin tulik natul Esau, papa tumun mwet Edom. ");
INSERT INTO kos_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Inen wen natul Esau pa inge: Eliphaz wen natul Adah, mutan kial Esau. Reuel wen natul Basemath, sie pac mutan kial Esau. ");
INSERT INTO kos_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wen natul Eliphaz pa Teman, Omar, Zepho, Gatam ac Kenaz. ");
INSERT INTO kos_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","(Timna el mutan kulansap se kial Eliphaz, wen natul Esau, ac el oswella Amalek nu sel Eliphaz.) Elos inge wen natul Adah, mutan se meet kial Esau. ");
INSERT INTO kos_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ac wen natul Reuel pa Nahath, Zerah, Shammah, ac Mizzah. Elos inge wen natul Basemath, mutan se akluo kial Esau. ");
INSERT INTO kos_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholibamah, acn natul Anah wen natul Zibeon, el oswela wen tolu nu sel Esau, inelos pa Jeush, Jalam, ac Korah. ");
INSERT INTO kos_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Pa inge sou lulap ma tuku ke fwilin tulik natul Esau. Eliphaz, wen se omeet natul Esau, pa sifen sou lulap inge: Teman, Omar, Zepho, Kenaz, ");
INSERT INTO kos_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam, ac Amalek. Elos inge nukewa ma natul Adah, mutan se meet kial Esau. ");
INSERT INTO kos_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Reuel, wen natul Esau, pa sifen sou lulap inge: Nahath, Zerah, Shammah, ac Mizzah. Elos inge kewa ma natul Basemath, mutan se akluo kial Esau. ");
INSERT INTO kos_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Sou lulap inge ma tuku kacl Oholibamah, mutan se aktolu kial Esau, su acn natul Anah: Jeush, Jalam, ac Korah. ");
INSERT INTO kos_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Sou lulap inge nukewa tuku ke fwilin tulik natul Esau. ");
INSERT INTO kos_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Pa inge mukul natul Seir mwet Hor, su mwet na pwaye lun acn Edom: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO kos_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, ac Dishan. Elos pa sou lulap lun mwet Hor, su wen natul Seir in acn Edom. ");
INSERT INTO kos_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan pa sifen sou lulap lal Hori ac Heman. (Oasr pac tamtael se lal Lotan pangpang Timna.) ");
INSERT INTO kos_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobal pa sifen sou lulap lal Alvan, Manahath, Ebal, Shepho, ac Onam. ");
INSERT INTO kos_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Oasr wen luo natul Zibeon, inelos pa Aiah ac Anah. (Pa inge Anah se ma konauk unon in kof fol se in acn mwesis ke pacl se el liyaung donkey natul Zibeon, papa tumal.) ");
INSERT INTO kos_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Oasr mukul se natul Anah, inel pa Dishon, ac mutan se natul pa Oholibamah. ");
INSERT INTO kos_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ac wen natul Dishon pa Hemdan, Eshban, Ithran, ac Cheran. ");
INSERT INTO kos_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer pa papa tumun sou lulap lun Bilhan, Zaavan, ac Akan. ");
INSERT INTO kos_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan pa papa tumun sou lulap lun Uz ac Aran. ");
INSERT INTO kos_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Pa inge inen sou lulap lun mwet Hor: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO kos_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer, ac Dishan. Pa inge kais sie sou lulap lun mwet Hor in facl Seir. ");
INSERT INTO kos_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Pa inge tokosra ma leumi acn Edom, meet liki mutawauk in oasr tokosra lun mwet Israel: ");
INSERT INTO kos_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, wen natul Beor, el leum fin acn Edom. Inen siti sel pa Dinhabah. ");
INSERT INTO kos_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela el misa, ac Jobab, wen natul Zerah mwet Bozrah, el aolulla in tokosra. ");
INSERT INTO kos_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab el misa, ac Husham, su muta in acn sin mwet Teman, el aolulla in tokosra. ");
INSERT INTO kos_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham el misa, ac Hadad wen natul Bedad, su tuh kutangla mwet Midia in acn Moab, el aolulla in tokosra. Inen siti sel pa Avith. ");
INSERT INTO kos_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad el misa, ac Samlah, sie mwet Masrekah, el aolulla in tokosra. ");
INSERT INTO kos_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah el misa, ac Shaul mwet Rehoboth, sie siti sisken Infacl Euphrates, el aolulla in tokosra. ");
INSERT INTO kos_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shaul el misa, ac Baal Hanan, wen natul Achbor, el aolulla in tokosra. ");
INSERT INTO kos_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal Hanan wen natul Achbor el misa, ac Hadar el aolulla in tokosra. Inen siti sel pa Pau, ac inen mutan kial uh pa Mehetabel, acn natul Matred, su acn natul Mezahab. ");
INSERT INTO kos_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Pa inge inen sifen sou lulap lal Esau, ke sou lalos ac inen acn selos: Timna, Alvah, Jetheth, ");
INSERT INTO kos_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamah, Elah, Pinon, ");
INSERT INTO kos_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO kos_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, ac Iram. Pa inge sou lulap lal Edom. Edom pa Esau, su papa tumun Edom, fal nu ke oakwuk lalos in acn selos. ");
INSERT INTO kos_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob el mutana in acn Canaan, yen papa tumal tuh muta we, ");
INSERT INTO kos_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ac pa inge sramsram ke sou lal Jacob. Joseph el sie mwet fusr yac na singoul itkosr, ac el wi mwet lel liyaung sheep ac nani uh. Mwet lel inge ma natul Bilhah ac Zilpah, mutan kulansap luo kien papa tumaltal ah. Joseph el tukakin nu sin papa tumal ma koluk mwet wial inge oru. ");
INSERT INTO kos_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jacob el lungse Joseph yohk liki mwet lel nukewa, mweyen el isusyang nu sel ke el arulana matu. Jacob el orala sie nuknuk na oa lal ma loes pao. ");
INSERT INTO kos_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ke tamulel lal liye lah papa tumalos el kuloel Joseph yohk lukelos nukewa, elos arulana kwasel Joseph, pwanang elos tia ku in kaskas kulang nu sel. ");
INSERT INTO kos_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Sie pacl ah Joseph el oru mweme se, ac ke el srumunang nu sin tamulel lal, elos srungal yohk liki meet ah. ");
INSERT INTO kos_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","El fahk, “Lohng mweme se nga oru inge. ");
INSERT INTO kos_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Kut nukewa muta inima ah, ac kapri kahp in wheat. Na kahp se luk ah tuyak suwosak nu lucng, a kahp lowos ah raunela kahp se luk ah, ac pasrla nu kac.” ");
INSERT INTO kos_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Na tamulel wial ah siyuk sel, “Ya kom nunku mu kom ac tokosra ac leum facsr?” Ke ma inge yokelik srunga lalos nu sel liki meet, ke sripen mweme se lal ah, oayapa ke ma el fahk kaclos. ");
INSERT INTO kos_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Tok Joseph el sifilpa oru sie mweme ac fahk nu sin mwet lel, “Nga oru pac mweme se ac nga liye mu faht ah, malem ah, ac itu singoul sie pasrla nu sik.” ");
INSERT INTO kos_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","El fahkang pac mweme sac nu sin papa tumal, ac papa tumal ah mulat nu sel ac fahk, “Mweme fuka se ingan? Ya kom nunku mu nga, ac nina kiom ac tamulel lom, in tuku epasr nu sum?” ");
INSERT INTO kos_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tamulel lal Joseph ah kewa elos sok sel, tusruktu papa tumal ah nunku na ma inge nukewa. ");
INSERT INTO kos_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Sie len ah ke tamulel lal Joseph elos som tari nu Shechem in liyaung un kosro nutin papa tumalos, ");
INSERT INTO kos_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Jacob el fahk nu sel Joseph, “Nga lungse kom in som nu Shechem, yen tamulel lom elos liyaung kosro uh we.” Ac Joseph el topuk, “Kwal nga ac som.” ");
INSERT INTO kos_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Papa tumal el fahk nu sel, “Fahsrot liye lah tulik wiom an fuka, ac kosro natusr ah fuka, na foloko fahk nu sik.” Ouinge papa tumal ah supwalla, el som liki Infalfal Hebron. Joseph el sun acn Shechem ");
INSERT INTO kos_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ac forfor uten acn uh, na mwet se liyalak ac siyuk sel, “Mea kom suk an?” ");
INSERT INTO kos_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ac el fahk, “Nga suk tamulel luk ma muta liyaung un kosro natulos uh. Kom ku in fahk nu sik lah eltal oasr ya?” ");
INSERT INTO kos_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ac mwet sac fahk, “Eltal som tari. Nga lohng ke eltal fahk mu eltal ac som nu Dothan.” Ke ma inge Joseph el som tokoltal ac konaltalak Dothan. ");
INSERT INTO kos_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Elos ngetla liyalak ke el fahsr srakna loes nu yorolos, ac meet liki el sonolos elos orek pwapa sulal ac wotela mu elos ac unilya. ");
INSERT INTO kos_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Elos fahk nu sin sie sin sie, “Mukul mweme ah pa fahsru ingo. ");
INSERT INTO kos_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Akola kut in unilya, ac siselang nu in sie luf inge. Kut fah tuh fahk mu kosro sulallal ah unilya. Kut in liye lah mweme lal ah ac fuka.” ");
INSERT INTO kos_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Reuben el lohng pwapa lalos, ac srike in molella Joseph. El fahk, “Tari kut tia unilya. ");
INSERT INTO kos_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kut siselang na nu in sie luf inge, ac tia oru kutena ma nu sel.” El fahk ouinge mweyen el akoo elan molella ac folokunulla nu yurin papa tumal ah. ");
INSERT INTO kos_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ke Joseph el tuku sonolos, elos seya nuknuk oa se lal ma loes pao ah, ");
INSERT INTO kos_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","na elos usalla ac siselang nu in luf se wangin kof loac. ");
INSERT INTO kos_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ke elos mongo, elos ngetla liyauk un mwet Ishmael se su tuku Gilead me in som nu Egypt. Camel natulos us pak pukanten ma sessesla ke mwe akyuye mongo ac ono keng. ");
INSERT INTO kos_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judah el fahk nu sin mwet wial, “Wo fuka se kut ac eis kut fin uniya tamulel se lasr, na tari wikin ma kut oru? ");
INSERT INTO kos_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kut kukakunulla nu sin mwet Ishmael inge. Fin ange, na kut ac tia enenu in unilya. Saya na, ma wiasr pa el ac kut srah sefanna.” Tamulel lal elos insese nu kac, ");
INSERT INTO kos_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ac ke kutu mwet kuka Midian elos fahsryak, na mwet wial Joseph elos amakunulak liki luf sac, ac kukakunulang su sin mwet Ishmael inge ke ipin silver longoul. Na elos usal som nu Egypt. ");
INSERT INTO kos_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ke Reuben el foloko nu ke luf sac ac liyauk lah Joseph el wangin we, el seya nuknuk lal ke asor. ");
INSERT INTO kos_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","El folokla nu yurin mwet wial ac fahk, “Tulik sac wanginla in luf sac! Mea nga ac oru uh?” ");
INSERT INTO kos_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Na elos uniya nani soko ac twenya nuknuk lal Joseph ah ke srahn nani soko ah. ");
INSERT INTO kos_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Elos usla nuknuk sac nu yurin papa tumalos, ac fahk, “Kut konauk nuknuk se inge. Ya ma lun wen se nutum ah?” ");
INSERT INTO kos_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","El akilenak ac fahk, “Aok, ma lal! Kalem lah kosro sulallal ah unilya. Joseph, wen nutik, el seseyuki!” ");
INSERT INTO kos_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jacob el seya nuknuk lal ke asor, ac nokomang nuknuk yohk eoa. El eoksra ke wen natul ah paht na. ");
INSERT INTO kos_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wen natul nukewa ac acn natul nukewa elos fahsreni nu yorol in srike in akfisrasrye asor lal, tuh el tia ku in kutongya asor lal, ac el fahk, “Nga ac asor na ke tulik se inge nwe ke na nga misa.” Ouinge el asor na kacl Joseph, kulo natul. ");
INSERT INTO kos_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","In pacl sac pacna, mwet Midian elos kukakunulla Joseph in acn Egypt nu sel Potiphar, sie sin mwet fulat lun tokosra lun facl Egypt. El pac pa sifen mwet topang su taran inkul lun tokosra. ");
INSERT INTO kos_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ke pacl sac pacna Judah el som liki mwet wial, ac muta yurin mwet se pangpang Hirah, su ma in siti srisrik Adullam. ");
INSERT INTO kos_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ke el muta we el sun tulik mutan Canaan se, su ma natul Shua. Na el payukyak sel, ");
INSERT INTO kos_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ac mutan sac osweang wen se nu sel, ac Judah el sang inen tulik sac Er. ");
INSERT INTO kos_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Mutan sac sifilpa pitutuyak ac oswela pac wen se, ac sang inel Onan. ");
INSERT INTO kos_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Na el sifilpa oswela wen se, ac sang inel Shelah. Judah el muta Achzib ke mutan sac oswella Shelah. ");
INSERT INTO kos_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judah el konauk mutan se pangpang Tamar kial Er, wen se omeet natul. ");
INSERT INTO kos_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Elah lal Er arulana koluk ac aktoasrye LEUM GOD, ke ma inge LEUM GOD El unilya. ");
INSERT INTO kos_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Na Judah el fahk nu sel Onan, tamulel lal Er, “Fahla ona yurin katinmas kien tamulel lom, ac akfalye ma kunom nu sel, tuh in oasr fita nutin ma lim.” ");
INSERT INTO kos_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tusruktu Onan el etu lah tulik el ac orala uh ac tia oaoa mu ma natul, ouinge pacl nukewa el ac ona yurin katinmas sac, el ac okoalla nu saya, tuh in wangin tulik nutin tamulel lal. ");
INSERT INTO kos_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ma el oru inge aktoasrye LEUM GOD, ac LEUM GOD El unilya pac. ");
INSERT INTO kos_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Na Judah el fahk nu sel Tamar, acn talupal, “Folokla ac muta yurin papa tomom, ac mutangan katinmas na nwe ke na Shelah, wen nutik, el matula.” El fahk ouinge mweyen el sensen ac anwuki pac Shelah oana tamulel luo lal ah. Ke ma inge Tamar el folokla nu yen sel ah. ");
INSERT INTO kos_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Tok kutu, na mutan kial Judah ah misa. Ke safla eoksra lal, el ac Hirah, kawuk lal in acn Adullam, som nu Timnah, yen ma kalkul sheep natul uh we. ");
INSERT INTO kos_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Mwet se fahkang nu sel Tamar lah papa tumun mukul tumal ah el som nu Timnah in kal sheep natul we. ");
INSERT INTO kos_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ouinge Tamar el ayaolla liki nuknuk in katinmas lal ma el muta nukum, afinya mutal ke mwe lisrlisr, ac pituki muta ke acn in utyak nu Enaim, sie siti srisrik sisken inkanek nu Timnah. In etu lal uh, Shelah, wen se ma fusr oemeet natul Judah, el matula tari in pacl se inge, a tiana itukyang Tamar elan payukyak sel. ");
INSERT INTO kos_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ke Judah el liyalak, el nunku mu sie mutan kosro su eis molin kosro lal pa el, mweyen el afinya mutal. ");
INSERT INTO kos_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","El fahla nwe yorol sisken inkanek ah, ac fahk, “Kwal, lupa su molum?” (Judah el tiana etu lah mutan sac ma talupal.) Tamar el fahk, “Mea kom ac se?” ");
INSERT INTO kos_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ac Judah el topuk, “Nga ac supwama soko nani fusr ah liki un kosro nutik.” Na Tamar el fahk, “Kwal, se sie mwe akpwaye an in oan yuruk nwe ke na kom supwama nani an.” ");
INSERT INTO kos_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ac Judah el siyuk, “Mea nga ac sot in mwe akpwaye wulela luk?” Ac mutan sac fahk, “Sil se lom ingan wi ah nu kac an, oayapa sikal soko lom ma kom us ingan.” Judah el sang ma inge kewa nu sel, na el ona yorol ac Tamar el pitutuyak sel. ");
INSERT INTO kos_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamar el folokla nu lohm sel, eisla mwe lisrlisr ke mutal, ac sifilpa nokomwang nuknuk in katinmas lal. ");
INSERT INTO kos_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah el supwalla Hirah, kawuk lal, in usla nani uh ac folokonma mwe akpwaye ma el tuh sang nu sin mutan sac. Tusruktu Hirah el tuh tia ku in konalak. ");
INSERT INTO kos_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","El siyuk sin kutu mukul Enaim, “Pia mutan kosro se ma tuh muta pe inkanek uh ah?” Ac elos topuk, “Wanginna mutan kosro yenu.” ");
INSERT INTO kos_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hirah el folokla nu yorol Judah ac fahk, “Nga tia ku in konalak. Mukul in acn sac fahk mu soenna oasr mutan kosro in acn sac.” ");
INSERT INTO kos_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judah el fahk, “Tari elan eis lal ma yorol an. Kut tia lungse mwet in isrun kut. Nga srike ngan moli nu sel, tuh pa kom tia konalak an.” ");
INSERT INTO kos_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ac malem tolu ma tok, mwet se fahk nu sel Judah, “Tamar, acn talupom, el orekma oana mutan kosro se, ac inge el pitutu.” Ac Judah el sap, “Usalla, esukulak elan misa!” ");
INSERT INTO kos_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ke elos amakunulla Tamar, el sap elos in fahkang kas inge nu sin papa talupal: “Nga pitutuyak sin mwet se la ma inge. Srike liye lah lun su — sil se inge wi ah soko nu kac uh, ac sikal soko.” ");
INSERT INTO kos_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah el akilenak ma inge ac fahk, “Pwaye sel, wangin mwatal. Nga tafongla ke ma kunuk nu sel. Pwayeiya uh, nga ac eisalang Shelah tumal.” Ac Judah el tiana sifilpa oan yorol. ");
INSERT INTO kos_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ke sun pacl in isus lal, koneyukyak lah el ac oswe fak se. ");
INSERT INTO kos_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ke pacl se el oswe tulik inge, sie seltal isongla paol nu saya, na mutan akisus sac sruokya, ac kapriya turet srusra soko kac, ac fahk, “El uh pa isusla meet uh.” ");
INSERT INTO kos_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tusruktu tulik sac folokonak paol, ac ma se ngia tuh isusla meet lukel. Na mutan akisus sac fahk, “Ya pa nge luman illa lom uh? Kom sifacna fokolma inkanek lom.” Ouinge itukyang inen tulik sac Perez. ");
INSERT INTO kos_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Na tulik se wial ah isusla, ac turet srusra soko ah oanna ke paol, na itukyang inel Zerah. ");
INSERT INTO kos_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Mwet Ishmael elos usalla Joseph nu Egypt ac kukakunulla nu sel Potiphar, sie sin mwet fulat lal tokosra, su sifen mwet topang su taran inkul sin tokosra. ");
INSERT INTO kos_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","LEUM GOD El welul Joseph ac oru tuh ma nukewa el oru fahla wona ouiya. El muta yurin mwet kacto lal, sie mwet Egypt, ");
INSERT INTO kos_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","su liye tuh na LEUM GOD El welul Joseph, ac LEUM GOD El oru in wo ouiyal Joseph in ma nukewa el oru. ");
INSERT INTO kos_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potiphar el insewowo sel ac oru tuh elan mwet tutafpo lal. Ouinge el likilya elan leum fin lohm sel ac ma nukewa lal. ");
INSERT INTO kos_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Tukun pacl sac lac, LEUM GOD El akinsewowoye sou lun mwet Egypt sac ac ma nukewa in lohm sel ac in ima lal, ke sripal Joseph. ");
INSERT INTO kos_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potiphar el fuhleang ma nukewa lal nu ye karinginyuk lal Joseph, ac el tia elya ke kutena ma sayen in sulela ma nal sifacna. Joseph el arulana oasku ac wo lumahl, ");
INSERT INTO kos_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ac tok kutu, mutan kien leum sac el mutawauk in lungseyak Joseph ac siyuk elan som oan yorol. ");
INSERT INTO kos_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Joseph el srangesr, ac el fahk nu sin mutan sac, “Nge, wangin elya lun leum luk ke kutena ma in lohm sel, mweyen el lulalfongiyu. El se ngan karingin ma nukewa lal. ");
INSERT INTO kos_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Oasr ku luk in lohm se inge oana el, ac wangin kutena ma el sruok nu sik sayom. Fuka tuh ngan oru kain elahwet ingan ac orekma koluk lain God?” ");
INSERT INTO kos_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Mutan sac el ne kwafe nu sel Joseph pingana len elan oan yorol, a Joseph el tiana som welul oan. ");
INSERT INTO kos_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tusruktu sie len ah, ke Joseph el som in oru orekma lal in lohm sac, wangin mwet kulansap saya oasr we. ");
INSERT INTO kos_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Mutan sac sruokya nuknuk lal Joseph, ac fahk, “Fahsru oan yuruk.” A Joseph el kaingla nu likin lohm sac, sisla na nuknuk lal ah yurin mutan sac. ");
INSERT INTO kos_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ke mutan sac el liye lah Joseph el sisla nuknuk lal ah ac kaingla nu lik ah, ");
INSERT INTO kos_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","el pang nu sin mwet kulansap lal lohm sac, ac fahk, “Ngetma liye ma se nge! Mwet Hebrew se ma mukul tumuk ah use nu lohm uh el aklusrongtenye kut. El utyak nu infukil sik ah, ac srike in sruinkuiyu, tuh nga liksrenina wowoyak ke kuiyuk. ");
INSERT INTO kos_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ke el lohng lah nga wowoyak, na el kaing nu likinuma, sisla nuknuk se lal inge siskuk.” ");
INSERT INTO kos_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mutan sac sruokya na nuknuk sac nwe ke na leum se lal Joseph ah tuku. ");
INSERT INTO kos_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Na el srumunang pac sramsram sac nu sel. El fahk, “Mwet kohs Hebrew sac, ma kom use nu inge ah, el utyak nu infukil sik uh ac nunku elan sruinkuiyu. ");
INSERT INTO kos_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tusruktu nga wowoyak, na el kaingla nu likinuma, sisla nuknuk lal ah siskuk.” ");
INSERT INTO kos_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ke leum se lal Joseph el lohng ma mutan kial ac fahk inge, el foloyak, ");
INSERT INTO kos_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ac sap sruhu Joseph ac sisiyang el nu in presin, yen mwet kapir lun tokosra kapir we. Na el mutana we. ");
INSERT INTO kos_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tusruktu LEUM GOD El welul Joseph ac akinsewowoyal, pwanang mwet liyaung presin el kulang nu sel. ");
INSERT INTO kos_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","El likilya Joseph elan sifen mwet kapir nukewa, ac sang elan fosrngakin ma nukewa ma orek in presin. ");
INSERT INTO kos_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mwet liyaung presin el tia fosrngakin kutena ma su oan ye karinginyuk lal Joseph, mweyen LEUM GOD El welul Joseph ac oru in wo ouiyal ke ma nukewa el oru. ");
INSERT INTO kos_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kutu pacl tok, sifen mwet okwok wain ac sifen mwet manman flao lun tokosra Egypt eltal aktoasryal tokosra. ");
INSERT INTO kos_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Tokosra el kasrkusrakak sin mwet kol luo inge ");
INSERT INTO kos_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ac fuhleltal uh in presin, in lohm sin captain lun mwet liyaung mwet kapir, yen se pacna ma Joseph el kapir we. ");
INSERT INTO kos_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Eltal muta in kapir ke pacl na loeloes se, ac captain sac srisrngilya Joseph tuh elan kulansupwaltal. ");
INSERT INTO kos_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Sie fong ah, mwet okwok wain sac ac sifen mwet manman flao sac tukeni mweme in presin, ac mweme laltal tia oana sie kalmac. ");
INSERT INTO kos_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ke Joseph el tuku nu yoroltal ke lotu tok ah, el liye lah toasr ngetnget laltal. ");
INSERT INTO kos_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","El siyuk seltal, “Efu ku komtal luman toasr misenge?” ");
INSERT INTO kos_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Eltal topuk, “Kais sie sesr mweme, ac wangin sie mwet ku in aketeya lah mea kalmen mweme inge.” Joseph el fahk, “God mukena pa ku in fahk nu sin mwet kalmen mweme uh. Fahkma nu sik mweme lomtal ingan.” ");
INSERT INTO kos_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ouinge mwet okwok wain sac fahk, “In mweme luk ah, oasr oa in grape soko ye mutuk, ");
INSERT INTO kos_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ac lah tolu kac. Na ke pacl se na sra kac uh srunak ah, ros kac farngelik, ac fahko kac uh mwesrla. ");
INSERT INTO kos_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ac nga sruok cup lun tokosra, na nga eis grape uh ac fuleya nu in cup sac ac sang nu sel.” ");
INSERT INTO kos_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph el fahk, “Pa inge kalmen mweme sacn: lah tolu an pa len tolu. ");
INSERT INTO kos_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tukun len tolu tokosra el ac tulekomla, nunak munas nu sum, ac folokonot orekma se lom meet ah. Kom ac fah sifilpa sang cup nimal, oana ke kom oru meet ke kom tuh liyaung wain nimal. ");
INSERT INTO kos_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tusruktu nga siyuk kom in esamyu ke pacl ma nukewa fahsr wo nu sum, ac nunak munas esam in sramsramkinyu nu sin tokosra, elan tuleyula liki kapir luk. ");
INSERT INTO kos_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Pwayeiya ah, pisreyukla nga liki facl sin mwet Hebrew, ac finne inge in acn Egypt, wanginna ma nga orala in pwanang ngan kapiri.” ");
INSERT INTO kos_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ke sifen mwet manman flao sac liye lah aketeyuki mweme lun mwet okwok wain sac tuh wo, na el fahk nu sel Joseph, “Oasr pac mweme se luk. Nga mweme mu nga us fotoh in bread tolu fin sifuk. ");
INSERT INTO kos_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","In fotoh se oelucng ah, kain in flao manman puspis nun tokosra oan loac, ac won uh tuku kang.” ");
INSERT INTO kos_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph el topuk, “Pa inge kalmac: fotoh tolu an pa len tolu. ");
INSERT INTO kos_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tukun len tolu tokosra el ac tulekomla, ac sang in pakpukla sifom! Na el ac srupusrak monum fin soko sak, ac won uh fah kang ikom.” ");
INSERT INTO kos_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Len tolu tok pa len in isusla lun tokosra, na el oru kufwa se nu sin mwet kacto lal nukewa. El ikasla mwet okwok wain lal ac sifen mwet manman flao lal liki presin, ac usaltalu nu ye mutun mwet kacto lal. ");
INSERT INTO kos_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","El folokonang orekma lun mwet okwok wain lal oana meet ah, ");
INSERT INTO kos_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","a el uniya sifa se lun mwet manman flao lal. Ma inge sikyak oana ma Joseph el tuh fahk. ");
INSERT INTO kos_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tusruktu mwet okwok wain el tiana esamulak Joseph. El mulkunulla na pwaye. ");
INSERT INTO kos_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Tukun yac luo, tokosra lun Egypt el mweme mu el tu sisken Infacl Nile, ");
INSERT INTO kos_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ac cow na fact ac wo lumah itkosr utyak liki infacl uh ac mutawauk in mongo mah. ");
INSERT INTO kos_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Na toko cow itkosr utyak pac, su sripisr ac koluk lumah. Elos tuku ac tu sisken cow ngia pe infacl ah, ");
INSERT INTO kos_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ac cow sripisr ah kangla cow ma fact ah. Na tokosra el asmakla. ");
INSERT INTO kos_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","El sifilpa motulla ac liye sie pac mweme. Ung in wheat itkosr yohk pisa ac wo lumah, fokla ke sropoh sefanna. ");
INSERT INTO kos_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Na ung itkosr saya srunak pac, masrinwasr ac mihsasa sroa ke sripen engyen ma tuku yen mwesis me. ");
INSERT INTO kos_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ac ung masrinwasr itkosr ah kangla ung ma yohk pisa ac wo lumah ah. Na tokosra el ngutalik ac akilenak lah el mweme. ");
INSERT INTO kos_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","In lotu tok ah el inse toasr ac fosrnga. Na el sapla solani mwet orek mwenmen ac mwet lalmwetmet nukewa in facl Egypt, ac fahk nu selos mweme lal ah. Tusruktu wangin sie ku in aketeya nu sel kalmac. ");
INSERT INTO kos_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Na mwet okwok wain sac fahk nu sel tokosra, “Nga ac fahkak misenge lah ma na koluk se nga orala. ");
INSERT INTO kos_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kom tuh kasrkusrak sik oayapa sin sifa lun mwet manman flao, ac filikuti in presin, in lohm sin captain lun mwet liyaung mwet kapir. ");
INSERT INTO kos_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Sie fong ah kut kewa tuh mweme, ac tia oana sie kalmen mweme lasr uh. ");
INSERT INTO kos_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Oasr mwet fusr Hebrew se tuh wi kut muta we, su mwet kohs lun leum lun mwet topang inkul sin tokosra. Kut akkalemye mweme lasr uh nu sel, ac el fahkma nu sesr kalmac. ");
INSERT INTO kos_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ma nukewa tuh sikyak oana ke el fahk nu sesr ah. Kom folokinyuyang nu ke orekma luk, a kom srupusrak mwet manman flao sac.” ");
INSERT INTO kos_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tokosra el sapla solal Joseph, ac utuku el liki presin in kitin pacl ah na. Tukun el resala ac ayaolla, na el tuku nu ye mutal tokosra. ");
INSERT INTO kos_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Na tokosra el fahk nu sel, “Nga tuh oru mweme se, a wangin sie mwet ku in aketeya. Nga lohng mu kom ku in fahkak kalmen mweme uh.” ");
INSERT INTO kos_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph el topuk, “Leum fulat luk, nga tia ku — tusruktu God El ac ase sie kalmac na wowo.” ");
INSERT INTO kos_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Tokosra el fahk, “Nga mweme mu nga tu pe Infacl Nile, ");
INSERT INTO kos_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","na cow na fact ac wo lumah itkosr utyak liki infacl uh ac mutawauk in kang mah. ");
INSERT INTO kos_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Na cow itkosr saya utyak pac, a elos sripisr ac koluk lumah. Nga soenna wi liye cow purngus ouinge in kutena acn in Egypt. ");
INSERT INTO kos_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Cow sripisr inge kangla cow ma fact ah, ");
INSERT INTO kos_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","tusruktu tia ku in akilenyuk, mweyen elos srakna purngus oana meet ah. Na nga ngutalik. ");
INSERT INTO kos_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Nga oayapa mweme mu nga liye ung in wheat itkosr yohk pisa ac wo lumah, fokla ke sropoh sefanna. ");
INSERT INTO kos_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Na ung itkosr saya srunak pac, masrinwasr ac mihsasa sroa ke sripen engyen ma tuku yen mwesis me. ");
INSERT INTO kos_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Na ma masrinwasr inge kangla ma wo lumah. Nga tuh fahkak mweme inge nu sin mwet mwenmen, tusruktu wangin sie selos ku in aketeya nu sik kalmac.” ");
INSERT INTO kos_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph el fahk nu sel tokosra, “Mweme luo ingan kalmac uh oana sie. God El fahkot nu sin Tokosra ma God El ac oru. ");
INSERT INTO kos_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Cow fact itkosr an pa yac itkosr, ac ung in wheat wo lumah itkosr an yac itkosr pac — eltal kalmac sefanna. ");
INSERT INTO kos_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Cow sripisr itkosr ma tuku tok, ac ung in wheat masrinwasr itkosr ma mihsasa sroa ke engyen yen mwesis uh, pa yac in sracl itkosr. ");
INSERT INTO kos_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Oana ke nga fahk nu sin Tokosra, God El akkalemyeot ma El ac fah oru. ");
INSERT INTO kos_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ac fah oasr yac itkosr ma acn nukewa in facl Egypt ac fah mut ac pukanten mongo. ");
INSERT INTO kos_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Tukun pacl sac, yac in sracl itkosr ac fah tuku, na ac fah tia esamyuk yac wowo inge, mweyen sracl lulap sac ac akkolukyela facl se inge nufon. ");
INSERT INTO kos_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Pacl in mut lulap sac ac fah tiana esamyuk, mweyen sracl se ma ac sikyak toko uh ac arulana upa. ");
INSERT INTO kos_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kalmen kalweniyuk mweme inge pa wotla tari sin God lah ma inge ac fah sikyak ke pacl na fototo. ");
INSERT INTO kos_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Ke ma inge Tokosra enenu in sulala sie mwet na lalmwetmet ac pah in nunak, ac sang elan liyaung facl se inge nufon. ");
INSERT INTO kos_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Enenu Tokosra in srisrngiya pac kutu mwet kol in eisani sie tafu limekosr ke ma mwet uh kosrani ke yac in mut itkosr ah. ");
INSERT INTO kos_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Sapkin nu selos in orani mongo nukewa ke yac wo ac mut ekasr fahsru inge, ac sang ku nu selos in orani wheat nu in nien filma in siti uh, ac karinganang. ");
INSERT INTO kos_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Mwe mongo ingan ac fah sie mwe tweng nu sin acn se inge ke yac in sracl itkosr ma ac tuku nu fin acn Egypt. Ma inge fin orek, mwet uh ac tia masrinsral.” ");
INSERT INTO kos_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Tokosra ac mwet kacto lal elos akkeyala lemlem se inge, ");
INSERT INTO kos_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ac tokosra el fahk nu selos, “Kut ac tia ku in konauk sie mwet su ac wo lukel Joseph — sie mwet su ngun lun God oasr yoro.” ");
INSERT INTO kos_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Na tokosra el fahk nu sel Joseph, “God El akkalemye ma inge nukewa nu sum. Ke ma inge, kalem lah oasr lalmwetmet ac liyaten yurum liki kutena mwet saya. ");
INSERT INTO kos_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Nga fah filikomi in liyaung facl sik uh, ac mwet nukewa luk ac fah akos sap lom. Wangin sie ac fah fulat liki kom sayuk. ");
INSERT INTO kos_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Inge nga srisrngikomi in governor fin facl Egypt nufon.” ");
INSERT INTO kos_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Tokosra el fwacla ring se ma sroalla sil fulat lal kac liki kufinpaol, ac sang nu ke kufinpaol Joseph. El filiya pac sie nuknuk linen na wowo nu facl, ac sang ah gold soko nu ke kwawal. ");
INSERT INTO kos_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","El sang nu sel chariot lun leum se akluo elan kasrusr fac, ac mwet soan lun tokosra elos kasrusr meet lukel, wowo ac fahk, “Sakunla! Sakunla!” Ouinge Joseph el srisrngiyuki governor fin acn Egypt nufon. ");
INSERT INTO kos_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Tokosra el fahk nu sel, “Nga pa tokosra uh, ac wangin sie mwet in acn Egypt nufon ac fah oru kutena ma kom fin tia lela.” ");
INSERT INTO kos_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Tokosra el sang ine Egypt se lal Joseph, na pangpang el Zaphenath‐paneah, ac el eisalang Asenath, acn natul Potiphera mwet tol lun acn On, kial. Ouinge Joseph el wela oaleum fin acn Egypt. ");
INSERT INTO kos_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph el yac tolngoul ke el mutawauk kulansap lal nu sin Tokosra lun acn Egypt. Ac el illa liki ye mutal tokosra, ac fufahsryesr rauni acn Egypt nufon ke orekma kunal. ");
INSERT INTO kos_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ke lusen yac in mut itkosr ah, acn we kosrani mwe mongo puspis, ");
INSERT INTO kos_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","su Joseph el eisani ac karingin in siti uh. In kais sie siti el eisani mwe mongo nukewa ma orekeni ke ima in acn we. ");
INSERT INTO kos_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Arulana pus wheat ma orekeni uh, pwanang Joseph el tila pauni — ma inge pukanten oana puk wekof uh. ");
INSERT INTO kos_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Meet liki yac in sracl uh tuku, Asenath el oswela wen luo nu sel Joseph. ");
INSERT INTO kos_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph el fahk, “God El oru nga mulkunla keok nukewa luk, ac sou lun papa tumuk nukewa.” Ke ma inge el sang inen wen se meet ah Manasseh. ");
INSERT INTO kos_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","El oayapa fahk, “God El ase tulik nutik in acn nga ongoiya we.” Ouinge el sang inen wen se akluo ah Ephraim. ");
INSERT INTO kos_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Yac in mut itkosr fin acn Egypt ah safla, ");
INSERT INTO kos_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ac yac in sracl itkosr ah mutawauk, oana ke Joseph el tuh fahk. Facl nukewa saya pulakin sracl lulap sac, a pukanten mwe mongo in acn Egypt. ");
INSERT INTO kos_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Pacl mwet Egypt elos ac mutawauk in masrinsral, na elos ac pang ac siyukyuk mongo sin tokosra. Na tokosra el ac sap elos in som nu yorol Joseph, ac oru oana ma el fahk. ");
INSERT INTO kos_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Sracl sac upala nwe apunla facl sac nufon, ouinge Joseph el ikasla iwen fil mongo nukewa ac kukakin wheat uh nu sin mwet Egypt. ");
INSERT INTO kos_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mwet uh tuku liki yen nukewa faclu nu Egypt in moul wheat sel Joseph, ke sripen sracl sac arulana upala yen nukewa. ");
INSERT INTO kos_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ke Jacob el lohngak lah oasr wheat in acn Egypt, el fahk nu sin wen natul, “Komtal ku mutana ngetnget? ");
INSERT INTO kos_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nga lohng mu oasr wheat in acn Egypt. Tal fahla nu we ac molema kutu nasr, kut in tia masrinsral nwe misa.” ");
INSERT INTO kos_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ouinge tamulel singoul lal Joseph ah som nu Egypt in moul wheat, ");
INSERT INTO kos_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","tusruktu Jacob el tia lela Benjamin, tamulel fusr se lal Joseph, elan welulos, mweyen el sensen ac oasr ma sikyak nu sel. ");
INSERT INTO kos_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Tulik mukul natul Jacob elos wi pac mwet puspis saya som in moul wheat, mweyen sracl sac sun pac acn Canaan. ");
INSERT INTO kos_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ke Joseph pa governor lun acn Egypt ah, el kukakin wheat uh nu sin mwet yen nukewa fin faclu. Ouinge tamulel lal Joseph elos tuku ac faksufi ye mutal. ");
INSERT INTO kos_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ke Joseph el liyeak tamulel lal inge, el akilenulos, tusruktu el oru oana elan tia etalos. El kouyak ac siyuk selos, “Komtal tuku ya me?” Elos fahk, “Kut tuku Canaan me in moul mongo.” ");
INSERT INTO kos_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph el ne akilen mwet wial inge, a elos tiana akilenul. ");
INSERT INTO kos_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","El esamak mweme ma el tuh oru ah, ac fahk nu seltal, “Komtal mwet kalngeyuk sulallal. Komtal tuku in konauk lah mea facl sesr uh munas kac uh.” ");
INSERT INTO kos_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ac elos topuk, “Leum lasr, tia ouingan. Kut tuku oana mwet kulansap lom, in moul mongo. ");
INSERT INTO kos_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kut inge nukewa tamulel, ac kut tia mwet kalngeyuk. Kut mwet na suwohs.” ");
INSERT INTO kos_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Joseph el fahk nu selos, “Mo! Komtal tuku in suk ac konauk lah mea kut munas kac.” ");
INSERT INTO kos_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Na elos fahk, “Leum lasr, kut tuh tamulel singoul luo nufon, ac kut wen nutin papa sefanna in acn Canaan. Sie tamulel inge misa, ac ma se ma fusr oemeet uh oasr na yurin papa tumasr ah.” ");
INSERT INTO kos_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph el topuk, “Oana nga fahk tari ah, komtal mwet kalngeyuk sulallal. ");
INSERT INTO kos_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Pa inge ma nga ac oru in konauk lah pwaye ma komtal fahk uh: Nga fulahk ke inen tokosra, lah komtal ac fah tiana som liki acn inge nwe ke na tamulel se ma fusr emeet lomtal an tuku nu yenu. ");
INSERT INTO kos_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Sie sumtal enenu in som usalu. Mwet lula an ac fah mutana in presin nwe ke na akpwayeyuk kas lomtal an. Fin tia ouinge, na oana ke tokosra el moul, komtal mwet sulallal.” ");
INSERT INTO kos_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ke el fahk ouinge tari, el fuhlelosi in presin ke len tolu. ");
INSERT INTO kos_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ke len se aktolu ah, Joseph el fahk nu selos, “Nga mwet etu sangeng sin God se, ac sripa sefanna pa nga ac ku in tia unikomtal uh kac. ");
INSERT INTO kos_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","In akpwayei lah komtal pwayena, sie sumtal ac fah mutana in presin, yen ma komtal muta we ah. Mwet lula an ku in folokla, us wheat ma komtal molela ah, nu yurin sou lomtal ma muta masrinsral soanekomtal an. ");
INSERT INTO kos_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Na komtal enenu na in tuh foloko use tamulel se ma fusr oemeet lomtal an nu yuruk. Ma se inge ac fah akpwayei lah ma komtal fahk an ma pwaye, na nga fah tia sap in anwuki komtal.” Elos insese nu kac ");
INSERT INTO kos_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ac fahk nu sin sie sin sie, “Pwayena lah inge kut eis mwatan ma kut tuh oru nu sin tamulel se lasr ah. Kut tuh liye fosrnga lulap lal ke el kwafe kut in kasrel, a kut tia lohngol ah. Ma ingan pa pwanang kut sun ongoiya inge.” ");
INSERT INTO kos_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ac Reuben el fahk, “Nga na fahk mu komtal in tia oru kutena ma nu sin tulik sac, a komtal tiana lohngyu. Ac inge kut eis mwatan misa lal ah.” ");
INSERT INTO kos_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Joseph el kalem ke ma elos kaskaskin, tusruktu elos tia etu lah el etu mweyen oasr mwet se tafu kas lalos nu sel. ");
INSERT INTO kos_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Joseph el som lukelos ac mutawauk in tung. Ke el ku in sifil kaskas el foloko, srella Simeon, ac sap kapiri el ye mutalos. ");
INSERT INTO kos_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Joseph el sapkin in nwanala pak lun tamulel lal ah ke wheat, ac in folokinyukyang mani lun kais sie nu in pak lal sifacna, ac in itukyang pac mongo ma elos in kang ke elos ac folok nu yen selos. Ma inge orekla oana ke el fahk ah. ");
INSERT INTO kos_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Tamulel ekasr ah nwakani donkey natulos ke wheat ma elos molela ah, na elos mukuiyak som. ");
INSERT INTO kos_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ke elos sun acn se elos ac mongla we ke fong sac, sie selos ikasla pak lal ah in kiteya donkey natul uh, tuh konauk lah mani lal ah oan oelucng in pak lal ah. ");
INSERT INTO kos_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ac el wola ac fahk nu sin tulik wial ah kewa, “Mani luk ah folokinyukme nu sik — pa oan in pak luk uh inge!” Insialos putat na oelucngi ke sangeng, ac elos rarrar ke elos asiyuki sie sin sie ac fahk, “Mea God El oru nu sesr inge?” ");
INSERT INTO kos_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ke elos tuku nu yorol Jacob, papa tumalos in acn Canaan, elos fahkang nu sel ma nukewa ma sikyak nu selos, ac fahk, ");
INSERT INTO kos_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Governor lun acn Egypt el tuh kaskas arulana kou nu sesr, ac fahk mu kut mwet kalngeyuk sulallal lain facl sel. ");
INSERT INTO kos_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ac kut tuh topkol ac fahk, ‘Kut tia mwet sulallal. Kut mwet na suwohs. ");
INSERT INTO kos_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kut tuh tamulel singoul luo nufon nutin papa sefanna, ac sie sin tamulel inge misa, ac ma se ma fusr oemeet uh el srakna oasr Canaan yurin papa tumasr ah.’ ");
INSERT INTO kos_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ac mwet sac fahk, ‘Pa inge ma se nga ac oru in konauk lah komtal mwet suwohs uh: sie sumtal ac mutana inge, ac ma lula an ac fah us wheat uh ac som nu yen sumtal nu yurin sou lomtal ma masrinsral. ");
INSERT INTO kos_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Tal tuh use tamulel se ma srik oemeet lomtal an nu yuruk, na nga fah etu lah komtal mwet suwohs ac tia mwet sulallal. Nga fah folokunulot tamulel se lomtal inge nu sumtal, ac komtal fah ku in muta inge, moul ac kuka.’” ");
INSERT INTO kos_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Na ke elos okoala pak lalos, elos nukewa konauk lah mani lalos ah oanna in pak lalos. Ac ke elos liye mani uh, elos arulana sangengla, ac Jacob, papa tumalos, el wi pac sangeng. ");
INSERT INTO kos_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob el fahk nu selos, “Ya kowos lungse oru tulik nutik uh kewa in wanginla? Joseph el wanginla, Simeon el wanginla, ac inge komtal ke usalla pac Benjamin. Nga pa ac keokkin ma inge uh!” ");
INSERT INTO kos_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Reuben el fahk nu sin papa tumal, “Nga fin tia folokunulma Benjamin nu yurum, kom ku in uniya wen luo nutik uh. Fuhlelma nu sik ngan karinganal, ac nga fah folokunulma.” ");
INSERT INTO kos_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tusruktu Jacob el fahk, “Wen nutik el ac tia wi komtal som. Tamulel lal el misa, ac el mukena lula. Ac ku pac in oasr ma sikyak nu sel inkanek uh. Nga matuoh inge, ac mwe asor komtal oru nu sik inge ku na in uniyuwi.” ");
INSERT INTO kos_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Sracl in acn Canaan yokyokelik, ");
INSERT INTO kos_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ac ke sou lal Jacob kangla nufon wheat ma utuku Egypt me ah, Jacob el fahk nu sin tulik mukul natul, “Tal sifilpa folokla ac molema pac kutu mongo ah nasr.” ");
INSERT INTO kos_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ac Judah el fahk nu sel, “Mwet sac fahkma kalem na nu sesr lah kut tia ku in sifilpa utyak nu ye mutal tamulel se lasr inge fin tia wi kut. ");
INSERT INTO kos_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kom fin lela tamulel se lasr inge in wi kut, na kut ac som moul mongo. ");
INSERT INTO kos_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","A kom fin tia lela, na kut tia som, mweyen mwet sac fahkma nu sesr mu ac fah tiana filfilla kut in utyak ye mutal ma lesr fin tia wi kut.” ");
INSERT INTO kos_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jacob el fahk, “Efu ku komtal fahkang nu sin mwet sac lah oasr pac tamulel se lomtal, oru arulana upa nu sik?” ");
INSERT INTO kos_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Elos fahk, “Mwet sac sikalani na in siyuk kacsr ac ke sou lasr uh. El fahk, ‘Ku papa tomomtal an srakna moul? Ku oasr pac tamulel lomtal saya?’ Kut enenu na in topuk kusen siyuk lal inge. Kut ac etu fuka lah el ac sap kut in us tamulel se lasr inge wi kut?” ");
INSERT INTO kos_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judah el fahk nu sin papa tumal, “Fuhlelma elan wiyu, ac kut ac fah mukuiyak ingena. Na ac fah wangin sesr misa ke masrinsral. ");
INSERT INTO kos_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nga ac wulewot ke moul luk sifacna, lah ma kunuk in fosrngakunul ac karinganul tuh in wangin ma el sis nwe ke na nga folokunulma nu yurum. Fin tia ouinge, lela mwata in oan fuk nwe tok. ");
INSERT INTO kos_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kut funu tia kolokin nwe inge, kut lukun som folok pacl luo lac tari.” ");
INSERT INTO kos_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ac Jacob el fahk nu selos, “Kwal, fin pa na ‘ngan ma ac orek uh, tal us kutu fokinsak ma wo emeet ke acn sesr uh in pak lomtal an, mwe lung nu sel governor: kutu ono keng, kutu honey, mwe akyu mongo, fiten pistachio ac almond. ");
INSERT INTO kos_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Utuk mani pac in yohk liki meet ah, mweyen komtal enenu in folokunla mani ma oan in pak lomtal ah. Sahp tafongla se pa ma sac. ");
INSERT INTO kos_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Us tamulel se lomtal inge, sulaklak fahsrot. ");
INSERT INTO kos_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Lela God Kulana Elan oru in oasr pakomuta lun mwet sac nu sumtal, elan ma folokunulot Benjamin ac tamulel se ngia nu sumtal. Ac funu nga, tulik nutik uh fin nuna ma ac tuhlac likiyu, na ac fuka oreya.” ");
INSERT INTO kos_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ouinge tamulel inge eis mwe lung ac mani pacl luo yohk liki meet ah, ac mukuiyak nu Egypt, ac Benjamin el welulos. Ke elos sun acn we, elos utyak na nwe ye mutal Joseph. ");
INSERT INTO kos_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ke Joseph el liyalak Benjamin lah el welulos, el fahk nu sin mwet kulansap se su taran ma nukewa lohm sel ah, “Usla mwet inge nu lohm ah. Elos ac wiyu mongo ke infulwen len uh. Tuh uniya soko kosro ah, ac akoela.” ");
INSERT INTO kos_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mwet kulansap sac oru oana ke sapkin nu sel. El pwanla tamulel inge nu lohm sel Joseph. ");
INSERT INTO kos_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ke utukla elos nu lohm sac, elos sangeng ac nunku in elos sifacna, “Utuku kut nu inse inge ke sripen mani ma tuh oan in pak lasr ke fahsr se lasr meet ah. Elos ac forma uni kut, eisla donkey natusr uh, ac oru kut in mwet kohs lun leum sac.” ");
INSERT INTO kos_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ouinge ke elos sun acn in utyak nu in lohm ah, elos fahk nu sin mwet kulansap sac, ");
INSERT INTO kos_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Leum se, nunak munas porongekut. Kut tuh tuku pac nu inge meet in moul mongo. ");
INSERT INTO kos_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ke kut folok nu yen sesr, ac tui inkanek lasr in mongla ke fongeni, kut konauk mani lasr ah nufon, oanna oelucng in pak lun kais sie sesr. Pa kut folokonma inge. ");
INSERT INTO kos_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kut oayapa utuk mani saya in tuh sifil moli kutu mongo ah. Kut tiana etu lah su tuh folokonang mani ah nu in pak lasr ah.” ");
INSERT INTO kos_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mwet kulansap sac fahk, “Nimet elya kac. Nimet sangeng. Sahp God lowos, God lun papa tomowos, pa filiya mani an in pak lowos ah. Nga sruokya tari molin ma kowos eis meet ah.” Na el usalu Simeon nu yorolos. ");
INSERT INTO kos_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mwet kulansap sac usak tamulel ekasr ah nu in lohm ah. El sang kof nu selos in ohlla nialos, ac el kiteya donkey natulos. ");
INSERT INTO kos_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Elos akoela mwe lung lalos ah, in sang nu sel Joseph ke el ac tuku ke infulwen len ah, mweyen fwackyang tari nu selos lah elos ac welul mongo. ");
INSERT INTO kos_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ke Joseph el sun lohm ah, elos us mwe lung lalos uh nu sel, ac pasrla nwe infohk uh ye mutal. ");
INSERT INTO kos_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","El siyuk selos lah elos fuka, na el sifil fahk, “Komtal tuh fahk nu sik ke matuoh lun papa tomomtal ah. El fuka? El srakna moul ac ku na?” ");
INSERT INTO kos_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Elos fahk, “Papa tumasr, mwet kulansap lom, el srakna moul ac el ku na.” Na elos muta liplipi ac pasrla nwe ten ye mutal. ");
INSERT INTO kos_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ke Joseph el liyalak Benjamin, ma lel, el fahk, “Ya pa inge tamulel se ma fusr emeet lomtal, ma komtal srumun nu sik ah? Ma nutik, God Elan akinsewowoye kom.” ");
INSERT INTO kos_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Na Joseph el kina tuyak ac som lukelos, mweyen el arulana asroela tulik wial inge, ac apkuran elan tungyak. Ouinge el som nu infukil sel ac tung we. ");
INSERT INTO kos_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tukun el twanla mutal el ilme ac liksreni kutong nunak lal, ac sapkin in tari yuyui mongo uh. ");
INSERT INTO kos_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Kitakat Joseph ke sie tepu uh, ac tamulel lal ah ke sie pacna tepu. Mwet Egypt ma welulos mongo uh srengla liki mwet inge ac mongo ke sie pacna tepu, ke sripen elos filiya in nunak lalos mu mwet Hebrew uh kupansuwol in welulos mongo. ");
INSERT INTO kos_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Tamulel inge muta ke tepu se, forang nu yorol Joseph, tuh na eltal muta tak in na matwa, matu nwe ke fusr. Ke elos akilen ouiyen mutangalos, elos tukeni angetani ac arulana fwefela. ");
INSERT INTO kos_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Mwe mongo uh kitakat nu selos liki tepu lal Joseph, ac kitakat Benjamin pacl limekosr yohk liki mwet wial ah nukewa. Ouinge elos welul Joseph mongo ac nim, nwe ke na elos arulana sruhila. ");
INSERT INTO kos_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Joseph el sapkin nu sin mwet kulansap se su taran ma nukewa in lohm sel ah, ac fahk, “Nwakla pak lun mwet inge ke mwe mongo nwe ke na arulana sessesla, ac likiya mani lun kais sie oelucng in pak lal an. ");
INSERT INTO kos_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Filiya cup silver se luk ah oelucng in pak lun tamulel fusr sac, wi mani in wheat lal an.” Ac mwet sac orala oana ke fwackyang nu sel. ");
INSERT INTO kos_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Toangna in lotu tok ah supweyukla tamulel ekasr ah wi donkey natulos. ");
INSERT INTO kos_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ke elos som ac srakna fototo nu ke siti uh, na Joseph el fahk nu sin mwet kulansap se lal ah, “Sulaklak fahsrot tukun mwet ekasr ah. Kom fin sonoltal, kom siyuk seltal, ‘Efu ku komtal oru ma koluk sang moli ma wo? ");
INSERT INTO kos_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Efu ku komtal pisrala cup silver se lun mwet kacto se luk ah? Cup se ingan ma el nimnim kac ac orekmakin nu ke susfa lal ah. Ma na koluk se pa komtal orala inge?’” ");
INSERT INTO kos_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ke mwet kulansap sac sonolos, el fahkang kas inge nu selos. ");
INSERT INTO kos_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Elos topkol ac fahk, “Leum se, mea kom fahk ingan? Kut tia etu lah mea kom fahk an. Kut fulahk lah wanginna kain ouiya ingan kut oru. ");
INSERT INTO kos_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kom etu na lah kut folokonma mani ma kut tuh konauk in pak lasr ah oe Canaan me nu sum. Na efu ku kut in pisre silver ku gold liki in lohm sin mwet kacto lom? ");
INSERT INTO kos_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Leum se, fin koneyukyak ma ingan sin sie sesr, lela in anwuki mwet sac, ac kut saya uh ac fah mwet kohs lom.” ");
INSERT INTO kos_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ac mwet sac fahk, “Nga insese nu kac, tusruktu mwet se na ma srukak cup sac ac fah mwet kohs luk, ac kowos su saya an sukosok in som.” ");
INSERT INTO kos_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ouinge elos sulaklak na sruhkya pak lalos uh, ac kais sie selos ikasla pak lal. ");
INSERT INTO kos_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Mwet kulansap se lal Joseph ah iluhsya pak lalos inge, mutawauk ke el su matu nu ke el su fusr, ac cup sac koneoyukyak in pak lal Benjamin. ");
INSERT INTO kos_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tamulel ekasr ah seseya nuknuk lalos ke asor, srakang pak lalos nu fin donkey natulos, ac folokla nu in siti ah. ");
INSERT INTO kos_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ke Judah ac mwet lel elos tuku nu lom sel Joseph, Joseph el srakna oasr we. Elos pasrla ye mutal nwe infohk uh, ");
INSERT INTO kos_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ac Joseph el fahk, “Mea komtal oru angan an? Ya komtal nikin lah kain mwet se nga uh ku in konauk ma komtal oru uh ke susfa?” ");
INSERT INTO kos_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Na Judah el fahk, “Leum se, mea kut ku in fahk nu sum? Kas fuka kut ac fahk in aksuwosye kut? Kut ac tulekutla fuka? God El akkalemyela ma koluk lasr. Kut nukewa inge ac fah mwet kohs lom, ac tia el na su koneyukyak cup sac yoro.” ");
INSERT INTO kos_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Joseph el fahk, “Mo na mo! Nga tia ku in oru angan! Mwet se na ma cup sac oan yoro an pa ac mwet kohs luk uh. Ac komtal saya an ku in folokla nu yurin papa tomomtal in misla.” ");
INSERT INTO kos_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Judah el kalukyang nu yorol Joseph ac fahk, “Leum luk, nunak munas, lela nu sik in fahk nunak luk. Nimet kasrkusrak sik. Kom oapana tokosra. ");
INSERT INTO kos_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Leum luk, kom tuh kusen siyuk nu sesr meet ac fahk, ‘Ku oasr papa tomomtal, ku tamulel lomtal saya?’ ");
INSERT INTO kos_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ac kut topuk ac fahk, ‘Aok, oasr papa tumasr su arulana matuoh, ac tamulel fusr se su isusyang nu sel ke el matu. Tamulel lun tulik fusr se inge misa, ac tulik se inge mukena srakna moul sin tulik nutin nina kial. Papa tumal ah arulana nunkal yohk.’ ");
INSERT INTO kos_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Leum luk, kom tuh fahk nu sesr mu kut in usalu nu inge kom in tuh liyal. ");
INSERT INTO kos_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ac kut topuk mu tulik sac tia ku in som liki ye mutun papa tumal ah. El fin som lukel, papa sac ku na in misa. ");
INSERT INTO kos_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Na kom tuh fahk, ‘Komtal tia ku in sifilpa utyak nu ye mutuk tamulel fusr se lomtal an fin tia wi komtal.’ ");
INSERT INTO kos_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Ke kut tuh folokla nu yurin papa tumasr ah, kut fahkang nu sel ma kom fahk ah. ");
INSERT INTO kos_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Na el fahk mu kut in sifilpa foloko moli kutu mongo. ");
INSERT INTO kos_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ac kut topkol ac fahk, ‘Kut tia ku in som, mweyen kut ac tuh kofla utyak nu ye mutun mwet sac tamulel fusr se lasr inge fin tia wi kut. El fin twe wi kut, kut fah ku in som.’ ");
INSERT INTO kos_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Na papa tumasr ah fahk, ‘Komtal etu na lah Rachel, mutan kiuk, el tuh oswela wen luo na nu sik. ");
INSERT INTO kos_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Sie seltal som likiyu tari. Sahp el eiyuki sin kosro sulallal, mweyen nga soenna sifil liyalak tukun el som ah nwe inge. ");
INSERT INTO kos_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Na komtal fin usalla pac el uh ac oasr kutu ma sikyak nu sel, na asor ma komtal orala nu sik uh ac ku na in uniyuwi, ke nga matuoh inge.’ ");
INSERT INTO kos_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Ke ma inge, leum luk, nga fin folokla nu yurin papa tumuk, mwet kulansap lom, ac tulik se inge tia wi kut, na in oana ke moul lal uh arulana fulyang nu sin tulik se inge uh, ");
INSERT INTO kos_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","el fin liye lah tulik sac tia wi kut, el ac misa. Ac kut, mwet kulansap lom inge, pa ac oru tuh papa tumasr su matuoh in pacl inge elan misa ke asor lal. ");
INSERT INTO kos_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Saya pacna, nga tuh wuleang ke moul luk nu sin papa tumuk ke tulik se inge. Nga tuh fahk nu sel mu nga fin tia folokunla tulik se inge nu yorol, na mwata uh ac fah oan fuk in moul luk nufon. ");
INSERT INTO kos_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ke ma inge, leum luk, nunak munas, lela nu sik in muta aol tulik se inge mwet kohs lom. Fuhlella elan wi tamulel lal inge som. ");
INSERT INTO kos_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nga ac folokla fuka nu yurin papa tumuk, tulik mukul se inge fin tia wiyu? Nga tia ku in ngetang liye ongoiya se inge fin sonol papa.” ");
INSERT INTO kos_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph el tia ku in sifil kutong nunak lal ye mutun mwet kulansap lal, oru el sapkin nu selos nukewa in som liki infukil sac. Wangin mwet saya welul Joseph ke el fahkulak nu sin tulik wial. ");
INSERT INTO kos_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","El wola ke sie pusren tung lulap, oru mwet Egypt elos lohng, ac pweng kac uh som sun inkul sel tokosra. ");
INSERT INTO kos_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph el fahk nu sin tamulel lal, “Nga pa Joseph. Ku papa el srakna moul?” Ac ke tamulal lal elos lohng, elos arulana sangeng, oru elos kofla topkol. ");
INSERT INTO kos_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Na Joseph el fahk nu selos, “Nunak munas, kaluku.” Elos kalukyang nu yorol ac el fahk, “Nga Joseph, tamulel se lomtal ma komtal kukakunla nu Egypt ah. ");
INSERT INTO kos_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nimet komtal oela ku likiya mu oasr koluk lomtal ke sripen komtal tuh kukakinyula nu yenu. God pa supweyume meet liki komtal, ngan tuh molela moul lun mwet uh. ");
INSERT INTO kos_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Sracl se inge tufahna yac akluola fin acn uh, ac yac limekosr lula ma ac fah wangin taknelik ku kosrani. ");
INSERT INTO kos_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God El supweyume meet liki komtal in tuh molikomtalla ke lumah na usrnguk se inge, ac in tuh liye lah komtal, ac fwilin tulik nutumtal, in painmoulla. ");
INSERT INTO kos_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ouinge tia komtal pa supweyume nu inge, a God. El oru tuh in nga pa fulat oemeet sin mwet fulat lal tokosra. Nga pa liyaung mutunfacl se lal inge nufon. Nga leumi Egypt nufon. ");
INSERT INTO kos_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Komtal sulaklak folokla nu yorol papa, ac fahk nu sel lah Joseph, wen natul, el fahk ouinge: ‘God El oru tuh nga in leumi acn Egypt nufon. Sulaklak fahsru nu yuruk. ");
INSERT INTO kos_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kom ku in tuh muta in acn Goshen, yen kom ac apkuran nu yuruk — kom, tulik nutum, tulik nutin nutum, sheep nutum, nani nutum, cow nutum, ac ma nukewa lom saya. ");
INSERT INTO kos_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kom fin muta Goshen, nga ku in karingin kom. Srakna oasr yac in sracl limekosr lula, ac nga tia lungse kom, sou lom, ac kosro nutum in masrinsral.’” ");
INSERT INTO kos_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Joseph el tafwelana ac fahk, “Inge komtal nukewa, ac kom pac Benjamin, ku in liye lah pwayena nga pa Joseph. ");
INSERT INTO kos_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Fahk nu sel papa lah arulana yohk ku luk fin acn Egypt, ac srumun nu sel ma nukewa ma komtal liye uh. Na komtal sulaklak usalu nu yenu.” ");
INSERT INTO kos_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","El kaosulma Benjamin, ma lel, in paol, ac mutawauk in tung. Benjamin el oayapa sruokilya ac tung. ");
INSERT INTO kos_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Joseph el tung na ac sruok kais sie sin mwet lel ac ngok mutalos. Tukun ma inge, na tamulel lal fah mutawauk in sramsram nu sel. ");
INSERT INTO kos_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ke pweng se inge sun lohm sin tokosra lah tamulel lal Joseph tuku, na tokosra ac mwet pwapa lal elos insewowo kac. ");
INSERT INTO kos_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Tokosra el fahk nu sel Joseph, “Fahk nu sin mwet wiom an elos in nwakla pak lalos ac sang nu fin kosro natulos ac folokla nu in facl Canaan. ");
INSERT INTO kos_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Sap elos in tuh use papa tumalos ac sou lalos ac foloko nu yenu. Nga ac fah sang nu selos acn ma wo emeet in acn Egypt, ac elos ac fah eis fokin acn uh yohk liki enenu lalos. ");
INSERT INTO kos_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Fahk pac nu selos elos in us kutu wagon liki acn Egypt in tuh wanma mutan kialos, tulik srisrik natulos, ac use pac papa tumalos. ");
INSERT INTO kos_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Elos in tia seko ma elos ac kofla us tuku an. Ma wo emeet in acn Egypt nufon ac fah ma lalos.” ");
INSERT INTO kos_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Wen natul Jacob elos oru oana ke fwack nu selos. Joseph el sang wagon nu selos, oana ke tokosra el sapkin, ac mwe mongo nalos nu ke fahsr lalos. ");
INSERT INTO kos_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","El oayapa sang kais sie nuknuk in ayaol nu sin kais sie selos, a nu sel Benjamin el sang ac ipin silver tolfoko ac nuknuk in ayaol limekosr. ");
INSERT INTO kos_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","El supwala donkey singoul nu sin papa tumal ah sessesla ke ma wolana in acn Egypt, ac donkey singoul pac sessesla ke wheat, bread, ac kutu pac mwe mongo saya nu ke fahsr lalos. ");
INSERT INTO kos_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Na el supwala tamulel lal ah som, ac ke elos mukuiyak el fahk nu selos, “Nimet komtal fahsr akukuin.” ");
INSERT INTO kos_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Elos som liki acn Egypt ac folokla nu Canaan, nu yorol Jacob, papa tumalos. ");
INSERT INTO kos_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ac elos fahk nu sel Jacob, “Joseph el srakna moul. El pa leumi acn Egypt nufon!” Ac ke Jacob el lohng el arulana lut ac lofongla, ac tia ku in lulalfongi. ");
INSERT INTO kos_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tusruktu ke elos fahkang nu sel ma nukewa ma Joseph el fahk nu selos ah, ac ke el liye wagon ma Joseph el supwama in tuh usalla nu Egypt uh, el asmakla liki lut lulap lal, ac fahk, ");
INSERT INTO kos_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","“Joseph wen nutik el srakna moul! Pa na ‘ngan ma nga ke lohng uh! Enenu na ngan som liyal meet liki nga misa.” ");
INSERT INTO kos_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jacob el apweni ma lal nukewa ac som nu Beersheba, ac orek kisa we nu sin God lal Isaac, papa tumal. ");
INSERT INTO kos_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","God El kaskas nu sel in sie aruruma ke fong sac ac pangnol, “Jacob, Jacob!” El topuk, “Nga pa inge.” ");
INSERT INTO kos_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ac God El fahk, “Nga pa God, God lun papa tomom. Nik kom sangeng in som nu Egypt. Nga fah oru tuh fwilin tulik nutum in sie matunfacl lulap in acn we. ");
INSERT INTO kos_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nga ac wi kom som nu Egypt, ac nga fah folokonma fwilin tulik nutum nu in facl se inge. Joseph el ac fah oasr yurum ke pacl se kom ac misa.” ");
INSERT INTO kos_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jacob el mukuila liki acn Beersheba. Wen natul ah srakulang Jacob, tulik srisrik natulos, ac mutan kialos fin wagon ma tokosra Egypt el supwama. ");
INSERT INTO kos_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Elos us un kosro natulos ac ma lalos nukewa ma elos eisani in acn Canaan, ac som nu Egypt. Jacob el us fwilin tulik natul nukewa welul: ");
INSERT INTO kos_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","wen natul, wen nutin natul, acn natul, ac acn nutin natul nukewa. ");
INSERT INTO kos_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Mwet in sou lal Jacob su welul som nu Egypt pa Reuben, wen se meet natul, ");
INSERT INTO kos_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ac wen natul Reuben nukewa: Hanoch, Pallu, Hezron, ac Carmi. ");
INSERT INTO kos_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon ac wen natul kewa: Jemuel, Jamin, Ohad, Jachin, Zohar, ac Shaul, wen nutin mutan Canaan se. ");
INSERT INTO kos_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi ac wen natul kewa: Gershon, Kohath, ac Merari. ");
INSERT INTO kos_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judah ac wen natul kewa: Shelah, Perez, ac Zerah. (Wen luo saya natul Judah, Er ac Onan, eltal misa Canaan.) Wen natul Perez pa Hezron ac Hamul. ");
INSERT INTO kos_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issachar ac wen natul kewa: Tola, Puah, Jashub, ac Shimron. ");
INSERT INTO kos_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulun ac wen natul kewa: Sered, Elon, ac Jahleel. ");
INSERT INTO kos_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Pa inge nukewa tulik natul Leah ma el oswela nu sel Jacob in acn Mesopotamia, welulang Dinah acn sefanna. Fita natul sel Leah, nufonna mwet tolngoul tolu. ");
INSERT INTO kos_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad ac wen natul kewa: Zephon, Haggi, Shuni, Ezbon, Eri, Arod, ac Areli. ");
INSERT INTO kos_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asher ac wen natul kewa: Imnah, Ishvah, Ishvi, Beriah, ac Sarah, tamtael se lalos. Wen natul Beriah pa Heber ac Malchiel. ");
INSERT INTO kos_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Mwet singoul onkosr inge pa fita natul Jacob sel Zilpah, mutan kulansap se su Laban el sang nu sel Leah, acn natul. ");
INSERT INTO kos_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rachel, mutan kial Jacob, el oswela wen luo na nu sel: Joseph ac Benjamin. ");
INSERT INTO kos_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Oasr wen luo natul Joseph: Manasseh ac Ephraim, su Asenath, acn natul Potiphera mwet tol lun Heliopolis, el osweang nu sel in Egypt. ");
INSERT INTO kos_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Kewana wen natul Benjamin pa Bela, Becher, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppin, ac Ard. ");
INSERT INTO kos_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Mwet singoul akosr inge pa fita natul Jacob sel Rachel. ");
INSERT INTO kos_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan ac Hushin, wen natul. ");
INSERT INTO kos_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naphtali ac wen natul kewa: Jahzeel, Guni, Jezer, ac Shillem. ");
INSERT INTO kos_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Mwet itkosr inge pa fita natul Jacob sel Bilhah, mutan kulansap se su Laban el sang nu sel Rachel, acn natul. ");
INSERT INTO kos_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Pisen tulik na pwaye natul Jacob su som nu Egypt uh oasr ke mwet onngoul onkosr. Tia oaoa mutan kien wen natul uh. ");
INSERT INTO kos_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Wen luo natul Joseph ma isusyang nu sel in Egypt ah fin weang pisa lulap se inge, ac oasr tulik itngoul nufon natul Jacob pa som nu Egypt. ");
INSERT INTO kos_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob el supwalla Judah meet lukel in tuh siyuk Joseph elan osun nu selos in acn Goshen. Ke elos sun acn we, ");
INSERT INTO kos_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph el sroang nu fin chariot natul, ac som nu Goshen in osun nu sin papa tumal. Ke eltal osun, Joseph el kausma papa tumal ah nu yorol, ac tung ke pacl na loes se. ");
INSERT INTO kos_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Jacob el fahk nu sel Joseph, “Inge ke nga liye kom tari ac etu lah kom srakna moul uh, nga mansis na ngan misa.” ");
INSERT INTO kos_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Na Joseph el fahk nu sin mwet lel ac mwet saya nukewa in sou lun papa tumal, “Nga enenu in som ac fahk nu sel tokosra lah mwet wiuk, ac mwet nukewa in sou lun papa tumuk su tuh muta Canaan, elos tuku nu yuruk. ");
INSERT INTO kos_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nga ac fahk nu sel lah komtal mwet liyaung sheep ac karingin un kosro, ac nga ac fahk pac lah komtal us un kosro nutumtal ac ma lomtal nukewa saya. ");
INSERT INTO kos_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ke tokosra el ac pangon komtal nu yorol ac siyuk lah orekma fuka lomtal, ");
INSERT INTO kos_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","aklohya na fahkang nu sel lah komtal mwet karingin kosro in moul lomtal nufon, oana mwet matu lomtal meet ah. Komtal fin fahk ouinge, na el ac lela komtal in muta in acn Goshen.” Joseph el fahk ouinge mweyen mwet liyaung kosro uh ma srungayuk se sin mwet Egypt. ");
INSERT INTO kos_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ke ma inge Joseph el eis limekosr sin mwet lel ac som nu yorol tokosra. El fahk nu sel tokosra, “Papa tumuk ac mwet lik nukewa tuku tari liki acn Canaan, us un kosro natulos ac ma nukewa lalos. Ingena elos muta oasr in acn Goshen.” ");
INSERT INTO kos_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Na toko el tukakunang mwet wial nu sel tokosra. ");
INSERT INTO kos_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ac tokosra el siyuk selos, “Orekma su lomtal?” Ac elos topuk, “Leum lasr, kut mwet shepherd oana mwet matu lasr somla. ");
INSERT INTO kos_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Kut tuku in muta in facl se inge, mweyen sracl se inge arulana upa in acn Canaan, ac wangin mah kosro natusr uh in kang we. Nunak munas, lela nu sesr in muta in acn Goshen.” ");
INSERT INTO kos_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Tokosra el fahk nu sel Joseph, “Inge ke papa tomom ac mwet lim nukewa tuku tari, ");
INSERT INTO kos_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","elos sukosok in muta kutena acn in facl Egypt. Tuh lela elos in oakwuki in acn Goshen, acn ma wo emeet in facl se inge. Ac fin oasr mwet pisrla inmasrlolos, sang in karingin un kosro nutik.” ");
INSERT INTO kos_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Toko Joseph el usalu Jacob, papa tumal, ac tukakunulang nu sel tokosra. Jacob el akinsewowoyal tokosra, ");
INSERT INTO kos_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ac tokosra el siyuk sel, “Kom yac ekasr?” ");
INSERT INTO kos_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob el topuk, “Nga tuh forot forma liki facl nu ke facl ke yac siofok tolngoul. Yac in forfor luk inge tiana pus, tusruktu arulana upa — tia oana yac puspis ma mwet matu luk elos tuh fufahsryesr kac meet ah.” ");
INSERT INTO kos_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jacob el sifilpa akinsewowoyal tokosra na el som liki inkul sin tokosra. ");
INSERT INTO kos_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Na Joseph el oakiya papa tumal ac mwet lel nukewa in Egypt, ac sang acn lalos ke acn ma wo oemeet, yen ma apkuran nu ke siti lun Rameses, oana ke tokosra el sap. ");
INSERT INTO kos_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph el fosrngakin mwe mongo nun papa tumal, mwet lel kewa, ac mwet saya nukewa in sou lun papa tumal, weang pac tulik srisrik nukewa. ");
INSERT INTO kos_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Sracl sac tuh arulana upa, oru wanginla mongo in acn nukewa, na mwet Egypt ac mwet Canaan elos munasla ke masrinsral. ");
INSERT INTO kos_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ke elos moli wheat uh, Joseph el eisani mani nukewa ac usla nu inkul fulat sel tokosra. ");
INSERT INTO kos_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ke lisr mani nukewa in acn Egypt ac Canaan, mwet Egypt elos tuku nu yorol Joseph ac fahk, “Se kutu mongo ah nasr! Nimet lela kut in misa. Kasrekut! Lisr nufon mani lasr uh!” ");
INSERT INTO kos_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ac Joseph el fahk, “Use un kosro nutuwos an. Nga ac sot mwe mongo in sang aol, fin lisr nufon mani an.” ");
INSERT INTO kos_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ke ma inge elos use kosro natulos nu yorol Joseph, ac el sang mwe mongo aolla horse, sheep, nani, cow, ac donkey natulos uh. Ke yac sac el sang mwe mongo aol kain in kosro nukewa. ");
INSERT INTO kos_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Yac toko ah, elos sifilpa foloko nu yorol ac fahk, “Kut ac tia wikin nu sum lah pwaye lisr mani lasr uh, ac inge kosro natusr nukewa ma pac nutum. Wangin ma lula yorosr in sot nu sum sayen manosr ac acn lasr uh. ");
INSERT INTO kos_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nik kom lela kut in misa. Kasrekut! Nimet lela ima lasr uh in sisila. Molikutla ac acn lasr uh ke mwe mongo. Kut ac fah mwet kohs lal tokosra, ac acn lasr uh ac fah ma lal. Se kutu wheat an nasr kut in tia misa, ac kutu fita an nu sesr kut in yukwiya in ima lasr uh. ");
INSERT INTO kos_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Joseph el molela acn nukewa in Egypt lal tokosra. Ke sripen sracl sac arulana upa, mwet Egypt nukewa kukakunla acn lalos, ac facl sac nufon ma lac lal tokosra. ");
INSERT INTO kos_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Joseph el oru tuh mwet yen nukewa in facl Egypt elos in mwet kohs lac lal tokosra. ");
INSERT INTO kos_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Pwayena acn el tia molela pa acn lun mwet tol. Mwet tol elos tia enenu in kukakin acn lalos uh, mweyen oasr kasru lun tokosra nu selos ke mwe mongo pacl nukewa, ac ma inge pa elos moulkin uh. ");
INSERT INTO kos_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joseph el fahk nu sin mwet uh, “Liye, nga molikowosla ac facl suwos nukewa tari tuh in ma lal tokosra. Ac fita pa inge, ma kowos in yoki in ima lowos. ");
INSERT INTO kos_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Fin sun pacl in kosrani, kowos enenu in sang sie tafu limekosr lal tokosra. Ma lula an kowos ku in orekmakin nu ke mwe yok, ac mwe mongo nowos ac sou lowos an.” ");
INSERT INTO kos_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ac elos topuk, “Leum lasr, kut ac fah mwet kohs lal tokosra, mweyen kom oru wo nu sesr ac molikutla.” ");
INSERT INTO kos_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ouinge Joseph el orala tuh in sie ma sap in facl Egypt, tuh sie tafu limekosr ke ma kosrani in ma lun tokosra. Ma sap se inge srakna orekmakinyuk nwe misenge. Acn lun mwet tol mukena tia wi oaoala mu ma lun tokosra. ");
INSERT INTO kos_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Mwet Israel elos muta Egypt in acn Goshen, yen ma elos kasrupi we ac pukanteni tulik natulos. ");
INSERT INTO kos_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob el muta Egypt yac singoul itkosr, nwe ke el sun yac siofok angngaul itkosr. ");
INSERT INTO kos_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ke el apkuran in misa, el solalma Joseph, wen natul, ac fahk nu sel, “Likiya poum inmasrlon epuk ac oru sie wulela na ku an lah kom ac tia pikinyuwi in acn Egypt. ");
INSERT INTO kos_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nga lungse pukpuki yen na papa tumuk elos pukpuki we. Usyula liki acn Egypt ac pikinyuwi yen elos pukpuki we.” Ac Joseph el fahk, “Nga ac oru oana kom fahk an.” ");
INSERT INTO kos_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jacob el fahk, “Fulahk lah kom ac oru ouingan.” Na Joseph el orala fulahk lal, ac Jacob el oanna fin mwe oan kial, ac fahk kulo nu sel Joseph. ");
INSERT INTO kos_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kutu pacl tok, fwackyang nu sel Joseph lah papa tumal ah mas. Ke ma inge el us wen luo natul ah, Manasseh ac Ephraim, ac som in liyal Jacob. ");
INSERT INTO kos_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ke fwackyang nu sel Jacob lah Joseph wen natul el tuku, Jacob el sang kuiyal nufon ac tukakek muta fin mwe oan kial. ");
INSERT INTO kos_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob el fahk nu sel Joseph, “God Kulana El tuh sikme nu sik in acn Luz in Canaan ac akinsewowoyeyu. ");
INSERT INTO kos_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","El fahk nu sik, ‘Nga ac sot tulik puspis nutum, tuh fwil nutum fah orala mutunfacl puspis. Nga fah sang facl se inge nu sin fita nutum tuh in ma lalos nwe tok.’” ");
INSERT INTO kos_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Jacob el tafwelana ac fahk, “Joseph, wen luo nutum ma isusla Egypt meet liki nga tuku nu inge, ac ma nutik. Ephraim ac Manasseh ac fah oaoa in wen nutik oapana Reuben ac Simeon. ");
INSERT INTO kos_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Fin ac oasr pac wen nutum tokoltal, elos ac fah tia oaoa mu ma nutik. Usru lalos uh elos ac fah eis sel Ephraim ac Manasseh. ");
INSERT INTO kos_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nga oru ange ke sripal Rachel, nina kiom. Yohk asor luk ke el misa in acn Canaan apkuran nu Ephrath, ke nga tuh folok liki acn Mesopotamia. Nga puknilya we sisken inkanek nu Ephrath.” (Ephrath pa pangpang Bethlehem in pacl inge.) ");
INSERT INTO kos_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ke Jacob el liye wen luo natul Joseph ah, el siyuk, “Su tulik ingan?” ");
INSERT INTO kos_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ac Joseph el fahk, “Pa inge wen luo nutik ma God El ase nu sik yenu in acn Egypt.” Jacob el fahk, “Usaltalu nu yuruk, nga in akinsewowoyaltalla.” ");
INSERT INTO kos_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Mutawauk in ohkla mutal Jacob ke sripen matuoh lal, ac el tia arulana liye wo. Joseph el kolla tulik luo ah nu yorol, ac el kafiseltalma nu yorol ac ngok mutaltal. ");
INSERT INTO kos_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Jacob el fahk nu sel Joseph, “Nga tiana nunku mu nga ac sifilpa liye kom, a inge God El oru tuh ngan liye pac tulik nutum uh.” ");
INSERT INTO kos_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Na Joseph el srakla tulik luo ah liki finyepal Jacob, ac pasrla nwe infohk uh ye mutal. ");
INSERT INTO kos_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Joseph el fililya Ephraim ke layen lasa lal Jacob, ac Manasseh ke layen layot. ");
INSERT INTO kos_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tusruktu Jacob el eklalik paol, ac filiya lac paol layot lal fin sifal Ephraim, finne el pa fusr seltal, ac lac paol lasa fin sifal Manasseh, su matu. ");
INSERT INTO kos_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Na Jacob el akinsewowoyal Joseph ac fahk, “Lela tuh God, su Abraham ac Isaac papa tumuk tuh kulansap nu se, Elan akinsewowoye tulik luo inge! Lela tuh God, su kolyu nwe misenge, Elan akinsewowoyaltal! ");
INSERT INTO kos_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Lela tuh lipufan se, su moliyula liki ongoiya nukewa, in akinsewowoyaltal. Lela tuh inek ac inel Abraham ac Isaac papa tumuk, in esamyuk ke sripen tulik mukul inge! Lela tuh in pukanten tulik natultal, ac fwilin tulik natulos!” ");
INSERT INTO kos_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Joseph el toasrla ke el liye lah papa tumal ah filiya lac paol layot fin sifal Ephraim. Ouinge el sruokya poun papa tumal in srakla liki fin sifal Ephraim nu fin sifal Manasseh. ");
INSERT INTO kos_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","El fahk nu sin papa tumal ah, “Tia pa ingan, papa. Tulik se ma matu ah pa inge. Likiya lac poum layot fin sifal.” ");
INSERT INTO kos_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Papa tumal ah tia insese kac. El fahk, “Wen nutik, nga etu. Nga etu lah fwilin tulik natul Manasseh ac fah oayapa orala sie mutunfacl lulap. Tusruktu tamulel fusr lal el ac fah yohk lukel, ac fita natul fah orala mutunfacl lulap puspis.” ");
INSERT INTO kos_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ouinge el akinsewowoyaltal ke len sac, ac fahk, “Mwet Israel fah orekmakin inemtal ke elos ac fahk kas in akinsewowoye mwet uh. Elos ac fahk, ‘God Elan akinsewowoye kom oana ke El akinsewowoyal Ephraim ac Manasseh.’” Ke Jacob el oru ouinge uh, el likilya Ephraim meet lukel Manasseh. ");
INSERT INTO kos_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Toko Jacob el fahk nu sel Joseph, “Oana ke kom akilen uh, nga apkuran in misa, tusruktu God El ac fah wi kom ac El ac fah folokinkomla nu ke facl sin papa matu tomom. ");
INSERT INTO kos_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nga sot nu sum acn Shechem — acn se ma wo fohk we uh, su nga tuh eisla sin mwet Amor ke mweun luk. Nga tia sang acn we nu sin tamulel wiom.” ");
INSERT INTO kos_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob el pangoneni wen natul ac fahk, “Kilukeni nu yuruk, ac nga fah fahk nu suwos ma ac sikyak nu suwos ke pacl fahsru uh: ");
INSERT INTO kos_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Fahsreni nu sie, wen natul Jacob, ac porongo. Porongo kas lal Israel, papa tomowos. ");
INSERT INTO kos_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reuben, wounse mukul nutik, kom pa ku luk, Kom pa fahko se emeet ke pacl in fusr luk. Kom pa fwacfa ac watwen sin wen nutik nukewa. ");
INSERT INTO kos_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Kom oana sie sronot fokoko, Tusruktu ac tia kom pa yohk sripa oemeet, Mweyen kom tuh ona yurin mutan kulansap kiuk Ac aktaekyala mwe oan lun papa tomom. ");
INSERT INTO kos_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon ac Levi eltal tamulel. Eltal orekmakin mwe anwuk natultal in orek lokoalok sulallal. ");
INSERT INTO kos_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Nga fah tia welultal in sramsram lukma laltal, Ac tia pac welultal ke pacl in pwapa laltal, Mweyen kasrkusrak laltal som nwe ke sun uniya mwet, Ac eltal aksukapasyela cow mukul oana mwe pwar. ");
INSERT INTO kos_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Lela in selngawiyuk kasrkusrak laltal, mweyen arulana upala, Ac nu fin folo laltal, mweyen arulana sulallal. Nga fah luseloselik fin acn Israel nufon. Nga fah siseloselik nu inmasrlon mwet Israel. ");
INSERT INTO kos_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judah, mwet lim fah kaksakin kom. Poum fah iseya kwawen mwet lokoalok lom. Mwet lim fah pasrla ye motom. ");
INSERT INTO kos_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah el oana soko lion. El uniya ma el sruokya uh, folokla nu in luf sel, Ac asrosrelik ona. Wangin mwet pulaik in lusrongol. ");
INSERT INTO kos_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Scepter lun tokosra ac fah oanna sel Judah, Ac fwilin tulik natul fah leum fin mwet Israel pacl nukewa. Mutanfahl ac fah use mwe takma nu sel, Ac pasrla ye mutal ac aksol. ");
INSERT INTO kos_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","El kapriya donkey fusr natul nu ke soko oa in grape, Nu ke oa in grape soko ma wo emeet. El oul nuknuk lal in wain su srusra oana srah. ");
INSERT INTO kos_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Atronmutal srusrala ke nim wain; Ac wihsel fasrfasrla ke nim milk. ");
INSERT INTO kos_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulon el ac fah muta sisken meoa. Molsron in acn sel ac fah acn in kawuk lun oak lulap, Ac masrol lun acn sel ac fah sun acn Sidon. ");
INSERT INTO kos_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar el tia ekla liki soko donkey fokoko Ma alsrangesr ac oanna inmasrlon mwe utuk lal. ");
INSERT INTO kos_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","A el liye lah acn in mongla uh wona Ac facl sac pwar na, Ouinge el kuruweni fintokol in us mwe utuk toasr uh, Ac kumakinyuk el in orekma oana sie mwet kohs. ");
INSERT INTO kos_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan el ac fah sie mwet kol nu sin mwet lal. Elos ac fah oana sruf saya lun Israel. ");
INSERT INTO kos_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan el ac fah oana soko wet ma oan sisken inkanek uh, Soko wet pwasin pe inkanek srisrik uh, Su sro ac ngalis nien horse uh, Ac oru tuh mwet muta fin horse uh in usrukyukla. ");
INSERT INTO kos_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“LEUM GOD, nga tupan molela lom. ");
INSERT INTO kos_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Un mwet pusrapasr se ac fah anwuk nu sel Gad, Tusruktu el fah forla ac ukwalos. ");
INSERT INTO kos_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Facl sel Asher ac fah oswe fokinsak wowo. Kain mwe mongo ma fal nu sin tokosra ac fah tuku yorol me. ");
INSERT INTO kos_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naphtali el oana soko deer lemnak ma kasrusr sukosok, Su oswe natu fusr na wowo. ");
INSERT INTO kos_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Joseph el oana soko fain na ungung ma kap sisken infacl srisrik uh, Ac oa kac uh fanukya fin pot uh. ");
INSERT INTO kos_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Mwet lokoalok lal ah mweunel upana, Ac ukwal ke mwe pisr ac sukan pisr natulos. ");
INSERT INTO kos_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tusruktu mwe pisr natul uh tiana mukuikui, Ac paol akkeyeyuk ac aksuwosyeyuk Ke ku lun God Kulana lal Jacob, Su Mwet Shepherd ac Mwet Loango lun Israel. ");
INSERT INTO kos_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","God lun papa tomom pa kasrekom, God Kulana pa akinsewowoye kom Ke mwe insewowo ke af lucng me Ac ke kof loal ye faclu, Mwe insewowo ke tulik puspis ac ke un kosro puspis, ");
INSERT INTO kos_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mwe insewowo ke wheat ac ke ros uh, Mwe insewowo ke eol ma oan oemeet me, Ac ke ma wolana su tuku ke eol srisrik su ac oan nwe tok. Lela mwe insewowo inge in oan fin sifal Joseph, Fin mutunsron sie su pisrla inmasrlon mwet wial. ");
INSERT INTO kos_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin el oana wolf sulallal soko El uniya ac okomla ma nal ke lotu ac eku.” ");
INSERT INTO kos_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Sruf singoul luo lun Israel pa inge, ac pa inge kas in wilkas lun papa tumalos ke el sang kas in akinsewowo lal nu selos, fal nu sin kais sie selos. ");
INSERT INTO kos_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Na Jacob el sapkin nu sin wen natul nukewa, “Inge ke nga ac misa ac som weang mwet luk somla, komtal fah pukinyuwi yurin papa tumuk in luf se ma oan ke acn sel Ephron mwet Hit, ");
INSERT INTO kos_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","in acn Machpelah, kutulap in Mamre in acn Canaan. Abraham el tuh molela luf sac ac ipin acn sac sel Ephron tuh in sie acn in kulyuk. ");
INSERT INTO kos_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Acn se inge pa elos piknilya Abraham ac Sarah, mutan kial, we. Acn sac pacna pa elos piknilya Isaac ac Rebecca, mutan kial ah, we, ac pa pac nga piknilya Leah we ah. ");
INSERT INTO kos_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Acn sac ac luf se we ah, ma moulla sin mwet Hit. Pikinyuwi we.” ");
INSERT INTO kos_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ke safla kas in wilwil lal nu sin wen natul nukewa, na el topla ona ac misa. ");
INSERT INTO kos_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Joseph el putatyang nu fin papa tumal ac tung ac ngok mutal. ");
INSERT INTO kos_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Na Joseph el sap mwet ono lal in unwela papa tumal, manol in oan paht. ");
INSERT INTO kos_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Elos orekma kac len angngaul, fal nu ke lusen pacl se eneneyuk tuh mano se in ku in oan paht. Mwet Egypt elos eoksra kacl Jacob ke len itngoul. ");
INSERT INTO kos_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ke safla pacl in eoksra uh, Joseph el fahk nu sin mwet pwapa lal tokosra, “Nunak munas, us kas se inge nu sel tokosra: ");
INSERT INTO kos_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ke papa tumuk el apkuran in misa, el sap nga orala wulela se nu sel lah nga ac piknilya inkulyuk se ma el akoela in acn Canaan. Ke sripa se inge, nga siyuk kom in nunak munas filiyula nga in som pikinya we, na nga fah foloko.’” ");
INSERT INTO kos_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ac tokosra el topuk, “Fahsrot pikinya papa tomom an, oana ke kom tuh wuleang nu sel an.” ");
INSERT INTO kos_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ouinge Joseph el som in pikinya papa tumal. Mwet pwapa lal tokosra nukewa, mwet fulat inkul sel, ac mwet kol nukewa in acn Egypt elos welul Joseph som. ");
INSERT INTO kos_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Sou lal, tamulel lal, ac mwet saya nukewa in sou lun papa tumal elos welul pac som. Tulik srisrik na natulos, wi sheep, nani, ac cow uh pa lula in acn Goshen. ");
INSERT INTO kos_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Mwet kasrusr fin chariot ac mwet kasrusr fin horse elos oayapa welul som — u na lulap se. ");
INSERT INTO kos_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ke elos tuku nu ke acn in kulkul wheat Atad, kutulap in Infacl Jordan, elos wowoyak ke tung ke pacl na loeloes se, ac Joseph el sapkin elos in eoksra len itkosr. ");
INSERT INTO kos_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ke mwet Canaan elos liye mwet ma eoksra in acn Atad inge, elos fahk, “Ku fuka lupan eoksra se mwet Egypt inge oru uh!” Pa inge ma se pwanang pangpang acn sac Abel Mizraim. ");
INSERT INTO kos_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ouinge wen natul Jacob elos oru oana ma el sapkin nu selos. ");
INSERT INTO kos_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Elos usla manol nu Canaan ac piknilya in luf se Machpelah, kutulap in acn Mamre, ke ipin acn se ma Abraham el tuh molela sel Ephron mwet Hit mwe kulyuk. ");
INSERT INTO kos_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Tukun Joseph el pikinya papa tumal, el ac tamulel lal ac mwet nukewa ma welul som in pukmas ah, elos folokla nu Egypt. ");
INSERT INTO kos_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Tukun papa tumalos ah misa, na mwet lel Joseph elos fahk, “Joseph el ac fin toasr sesr ac akoeyuk foloksak ke ma nukewa kut tuh oru koluk nu sel ah, na ac fuka?” ");
INSERT INTO kos_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ouinge elos sapla nu sel Joseph ac fahk, “Meet liki papa tumasr ah misa, ");
INSERT INTO kos_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","el tuh fahk nu sesr kut in siyuk sum ac fahk, ‘Nunak munas nu sin tamulel lom ke ma koluk ma elos tuh orala nu sum ah.’ Inge kut siyuk kom in nunak munas, tulekutla ke ma sufal ma kut, mwet kulansap lun God lun papa tomom, tuh orala nu sum ah.” Joseph el tung ke pacl se el eis kas inge. ");
INSERT INTO kos_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Na tamulel lal elos tuku ac epasrla nwe ten ye mutal ac fahk, “Kut tuku pa inge nu ye motom in mwet kohs lom.” ");
INSERT INTO kos_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tusruktu Joseph el fahk nu selos, “Nikmet kowos sangeng. Nga tia ku in oru acnu mu God pa nga. ");
INSERT INTO kos_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Kowos tuh orek pwapa koluk lainyu, tusruktu God El furokla nu ke sie ouiya wo, ma in molela moul lun mwet puspis su moul misenge ke sripen ma su tuh sikyak. ");
INSERT INTO kos_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Wangin ma kowos ac sangeng kac. Nga ac fah liyekowosyang ac tulik nutuwos an.” Ouinge el sifil akkeyalos ke kas na kulang su mokleak insialos. ");
INSERT INTO kos_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph el mutana in acn Egypt wi sou lun papa tumal. El tuh yac siofok singoul ke pacl se el misa ah. ");
INSERT INTO kos_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","El moul ac liye tulik natul Ephraim, ac tulik nutin natul. El oayapa moul nwe ke na el eisalos tulik natul Machir, wen natul Manasseh, nu in sou uh. ");
INSERT INTO kos_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","El fahk nu sin tamulel lal kewa, “Nga apkuran in misa, tusruktu pwayena God El ac fah liyekowosyang ac pwenkowosla liki facl se inge nu in facl se su El wulela ku na kac nu sel Abraham, Isaac, ac Jacob.” ");
INSERT INTO kos_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Na Joseph el siyuk sin mwet lal in orala sie fulahk. El fahk, “Wulema nu sik lah ke pacl se God El ac pwenkowosla nu in facl sac, kowos ac us srik wi kowos.” ");
INSERT INTO kos_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ouinge Joseph el misa Egypt ke el yac siofok singoul. Elos onoela manol ac filiya in box in mas se. ");
INSERT INTO kos_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Wen natul Jacob su welul som nu Egypt, wi sou lalos pa: ");
INSERT INTO kos_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, Judah, ");
INSERT INTO kos_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, Benjamin, ");
INSERT INTO kos_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naphtali, Gad, ac Asher. ");
INSERT INTO kos_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Pisen mwet inge nukewa su ma in fwil natul Jacob na suwohs, oasr ke mwet itngoul. Joseph, sie sin wen natul Jacob, el oasr tari in acn Egypt. ");
INSERT INTO kos_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ke pulan pacl sac, Joseph ac mwet lel ac mwet in fwil sac nufon misa, ");
INSERT INTO kos_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","tusruktu, fahko lun mwet Israel inge arulana puseni ac kui oru elos oaclik acn nukewa in Egypt. ");
INSERT INTO kos_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Na oasr tokosra sasu se mutawauk in leumi acn Egypt, su tia etal Joseph. ");
INSERT INTO kos_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","El fahk nu sin mwet lal, “Mwet Israel inge arulana puseni ac kui. Nga luman sensen elos ac ku liki kut. ");
INSERT INTO kos_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Fin oasr mweun elos ac mau kupasryang nu sin mwet lokoalok lasr ac lain kut, ac elos ac ku in kaingla liki mutunfacl sesr. Kut enenu in akngusrikya suk sie inkanek in taranulos in tia puseni.” ");
INSERT INTO kos_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ouinge mwet Egypt sang kutu mwet kol lalos sifacna in akupayela orekma lalos. Mwet Israel inge pa musaela siti Pithom ac Rameses — siti lulap inge kalkalyak tuh in acn in karingin mongo ac kufwa nukewa nu sin tokosra. ");
INSERT INTO kos_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Tusruktu finne yokelik mwe keok ma mwet Egypt sang aktoasrye mwet Israel kac, a pisen mwet Israel puseni liki meet ac osralik fin acn uh. Mwet Egypt mutawauk in sangeng sin mwet Israel, ");
INSERT INTO kos_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","oru elos aktoasryela orekma lalos. ");
INSERT INTO kos_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Elos akorekmayalos in orek brick mwe musa, oayapa kain in orekma nukewa inima uh, ac oru arulana upa nu selos. ");
INSERT INTO kos_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Na tokosra Egypt el kaskas nu sin luo sin mutan akisus ma kasru mutan Hebrew. Ineltal pa Shiphrah ac Puah. ");
INSERT INTO kos_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","El fahk nu seltal, “Ke komtal ac akisusye mutan Hebrew uh, fin ac tulik mukul se, na unilya; fin ac tulik mutan se, lela elan moul.” ");
INSERT INTO kos_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Tusruktu mutan akisus inge eltal etu in sangeng sin God, oru eltal tia aksol tokosra, a eltal fuhlela tulik mukul uh in moul. ");
INSERT INTO kos_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ouinge tokosra el sapla nu sin mutan akisus ah, ac siyuk seltal, “Efu komtal ku oru ange? Efu komtal ku fuhlela tulik mukul uh moul?” ");
INSERT INTO kos_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Eltal topuk, “Mutan Hebrew uh tia oana mutan Egypt uh, mweyen isus uh ma fisrasr se selos, oru tulik natulos isusla meet liki na mutan akisus uh sonolos.” ");
INSERT INTO kos_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ouinge God El oru wo nu sin mutan akisus inge, ac mwet uh puselik ac arulana ku. ");
INSERT INTO kos_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ke sripen mutan akisus inge mwet sangeng sin God, oru El sang in oasr pac tulik natultal. ");
INSERT INTO kos_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Na tokosra el sapelik nu sin mwet lal nukewa, “Tulik mukul Hebrew nukewa ma isusla, kowos sisla nu Infacl Nile, a lela tulik mutan uh in moul.” ");
INSERT INTO kos_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ke pacl se inge sie mukul ke sruf lal Levi el payukyak sin sie mutan in sruf sacna, ");
INSERT INTO kos_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ac mutan sac el oswela tulik mukul se. Ke el liye lah tulik na wowo se, el okanulla malem tolu. ");
INSERT INTO kos_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Na ke el tia ku in sifil okanulla, el orala fotoh se ke ah, na el itangla ke mwe fulful in tia wohn. El filiya tulik sac loac ac usla filiya inmasrlon ah sisken infacl uh. ");
INSERT INTO kos_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Tulik mutan se wien tulik sac el tu loes kutu lukel in liye lah mea ac sikyak nu sel. ");
INSERT INTO kos_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Na acn se natul tokosra tufoki in yihyih ke infacl soko ah, ac mutan kulansap lal tuelik sisken infacl ah. Na el liyauk fotoh sac inmasrlon ac ah, ac el sap sie mutan kulansap lal in som use. ");
INSERT INTO kos_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Fisrak sac ikasla ac liyauk tulik mukul srisrik se. Tulik sac tung, na el pakomutal ac fahk, “Tulik srisrik Hebrew se pa nge.” ");
INSERT INTO kos_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Na tulik mutan se wien tulik sac siyuk, “Mea, nga ac tia som konauk sie mutan Hebrew ah in katiti tulik se inge?” ");
INSERT INTO kos_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","El topuk, “Wona.” Ouinge tulik mutan sac som solama nina na kien tulik sac. ");
INSERT INTO kos_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Fisrak sac fahk nu sin nina sac, “Eis tulik se inge ac liyalang, ac nga fah moli nu sum.” Ouinge el us tulik sac ac liyalang. ");
INSERT INTO kos_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Tok, ke tulik sac matula, nina sac el usalla nu yurin acn natul tokosra, su nutella oana ma na natul. El fahk mu, “Nga fah sang inel ‘Moses’ mweyen nga ololak liki inkof uh.” ");
INSERT INTO kos_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ke Moses el matula, el som mutwata yurin mwet lal mwet Hebrew, ac el liye lupan orekma upa ma itukyang elos in oru. El liye pac ke sie mwet Egypt el uni sie mwet Hebrew wial ah. ");
INSERT INTO kos_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Moses el ngetot ngetma in suk lah oasr mwet liyal, na ke wangin, el uniya mwet Egypt sac ac pikinya manol in puk uh. ");
INSERT INTO kos_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Len tok ah, el folokla ac liye ke sie mwet Hebrew uni sie pac. Na Moses el fahk nu sel, “Efu kom ku uni mwet Hebrew wiom?” ");
INSERT INTO kos_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mwet sac topuk ac fahk, “Su oru tuh kom in mwet leum ac mwet nununku facsr? Mea, kom ac uniyuwi oana ke kom uniya mwet Egypt sac?” Ke Moses el akilen lah mwet uh etu tari ma se el orala, na el sangeng. ");
INSERT INTO kos_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ke pacl se tokosra el lohngak, el suk in unilya Moses. Tusruktu Moses el kaingla ac som muta in acn Midian. Sie len ah, ke Moses el muta pe lufin kof se, ");
INSERT INTO kos_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","na acn itkosr natul Jethro, mwet tol lun Midian, tuku in ut kof ac oayapa nwek mwe nim kof nimen sheep ac nani nutin papa tumaltal ah. ");
INSERT INTO kos_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Na oasr kutu mwet liyaung sheep ac nani tuku lusak acn natul Jethro ah. Moses el tuyak ac kasru acn ekasr ah, ac el sang kof nimen kosro nutin papa tumaltal ah. ");
INSERT INTO kos_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ke elos folokla nu yurin papa sac, el siyuk selos, “Komtak ku sa folok misenge?” ");
INSERT INTO kos_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Elos topuk, “Mwet Egypt se kasrekut ke kutu pac mwet liyaung sheep aklokoalokye kut, ac el oayapa ut kof lasr ac kiteya pac kosro natusr ah.” ");
INSERT INTO kos_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","El siyuk seltal, “El aya? Komtal ku tia usalu? Fahla solalma elan wi kut mongo.” ");
INSERT INTO kos_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ouinge Moses el sulela elan mutana we. Na Jethro el esalang Zipporah, acn natul, in mutan kial. ");
INSERT INTO kos_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipporah el oswela wen se, ac Moses el fahk, “Nga mwetsac se nu fin facl se inge, ouinge nga fah sang inel Gershom.” ");
INSERT INTO kos_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Tukun yac pus, tokosra lun acn Egypt el misa, tusruktu mwet Israel srakna yohk akkohs nu selos, ac elos sasaolana ke orekma upa lalos. Elos wowoyak ac suk kasru sin God. ");
INSERT INTO kos_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ac God El lohng pusren sasao lalos ac El esam wuleang lal yorol Abraham, Isaac, ac Jacob. ");
INSERT INTO kos_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","El liye ac etu ouiyen keok lun mwet Israel, ac El kena kasrelos. ");
INSERT INTO kos_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Sie len ke Moses el karingin sheep ac nani natul Jethro, su papa tumun mutan kial ac el mwet tol lun Midian, el pwanla kosro inge alukela yen mwesis ac sun eol mutal Sinai. ");
INSERT INTO kos_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Lipufan se lun LEUM GOD sikyang nu sel we in luman sie e ma tuku liki infulwen sak srisrik soko. Moses el lut ke el liye lah sak soko ah firir a tiana firirla. ");
INSERT INTO kos_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","El nunku sel, “Mea na usrnguk se inge? Efu sak soko inge ku tia firirla? Nga ac kuhfla nu kac ngan liye.” ");
INSERT INTO kos_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ke LEUM GOD El liye lah Moses el kalukyang, El pang nu sel liki infulwen sak soko ah, “Moses! Moses!” El topuk, “Nga pa inge.” ");
INSERT INTO kos_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Na God El fahk, “Tu na insacn. Sarukla fahluk lom an, mweyen kom tu fin fohk mutal. ");
INSERT INTO kos_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Nga pa God lun papa matu tomom — God lal Abraham, Isaac, ac Jacob.” Ouinge Moses el afinya mutal, mweyen el arulana sangeng in ngetang nu sin God. ");
INSERT INTO kos_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Na LEUM GOD El fahk, “Nga liye lupan keok lun mwet luk fin acn Egypt. Nga lohng pusren tung lalos ke elos wowoyak tuh in moliyukla elos liki inpoun mwet su akkohsyelos. Nga kalem ke lupan keok lalos. ");
INSERT INTO kos_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Na pa nga oatume in molelosla liki mwet Egypt ac usalosme liki acn we nu ke sie facl lulap, sie facl mut ac kasrup fohk we, su mwet Canaan, mwet Hit, mwet Amor, mwet Periz, mwet Hiv, ac mwet Jebus muta we inge. ");
INSERT INTO kos_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Pwayena nga lohng pusren tung lun mwet luk, ac nga liye lupan sulallal lun mwet Egypt nu selos. ");
INSERT INTO kos_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Inge nga ac supwekomla nu yurin tokosra lun Egypt tuh kom in ku in kolla mwet luk liki facl sel.” ");
INSERT INTO kos_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Tuh Moses el fahk nu sin God, “Ku su nga uh, tuh nga in som nu yorol tokosra ac usla mwet Israel liki acn Egypt?” ");
INSERT INTO kos_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","God El topuk, “Nga ac fah wi kom, ac pacl se kom use mwet uh liki acn Egypt kowos ac fah alu nu sik fin eol soko inge. Pa inge mwe akpwayei lah nga pa supwekomla.” ");
INSERT INTO kos_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Na Moses el fahk nu sin God, “Ke nga ac som nu yurin mwet Israel ac fahk nu selos, ‘God lun papa tomowos uh pa supweyume nu yuruwos,’ elos ac fah siyuk sik, ‘Su inel an?’ Na mea nga ac fahk nu selos?” ");
INSERT INTO kos_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","God El fahk, “Nga Nuna Nga Ah Na. Kom fah fahk nu selos, ‘El su pangpang NGA, pa supweyume nu yuruwos.’ ");
INSERT INTO kos_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Fahk nu sin mwet Israel lah nga, LEUM GOD lun papa tumalos somla — God lal Abraham, Isaac, ac Jacob — pa supwekom nu yorolos. Pa inge Inek nwe tok, ac fwil nukewa fahsru uh ac fah pangonyu ouinge. ");
INSERT INTO kos_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Som ac orani mwet kol lun Israel nu sie, ac fahk nu selos lah nga, LEUM GOD lun papa matu tumalos — God lal Abraham, Isaac, ac Jacob — pa sikwot nu sum. Fahk nu selos lah nga tuku nu yorolos tari ac nga liye ma mwet Egypt oru nu selos. ");
INSERT INTO kos_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nga sulela tari lah nga ac usalosla liki facl Egypt, yen akkeokyeyuk elos we, ac nga fah usalos nu in sie facl mut ac kasrup fohk we — facl sin mwet Canaan, mwet Hit, mwet Amor, mwet Periz, mwet Hiv, ac mwet Jebus. ");
INSERT INTO kos_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Mwet luk elos ac fah porongo ma kom fahk nu selos. Na kom, ac mwet kol lun mwet Israel, fah som nu yurin tokosra lun Egypt ac fahk nu sel, ‘LEUM GOD lun mwet Hebrew El sikme nu sesr. Inge lela nu sesr kut in fahsr ke len tolu nu yen mwesis in oru mwe kisa lasr nu sin LEUM GOD lasr.’ ");
INSERT INTO kos_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Nga arulana etu lah tokosra lun Egypt fah tia lela kowos in som nwe ke na po ku lun God akkeokyal. ");
INSERT INTO kos_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Tusruktu nga ac orekmakin ku luk in kai Egypt ke mwe aksangeng lulap. Tukun ma inge el ac fah filikowosla. ");
INSERT INTO kos_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Nga fah oru mwet Egypt in akfulatye kowos, tuh pacl mwet luk uh ac som elos fah tia pisinpo. ");
INSERT INTO kos_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Mutan Israel nukewa fah som nu yurin mwet tulan Egypt lalos, oayapa yurin mutan Egypt su muta in lohm selos, ac siyuk nuknuk ac mwe yun gold ac silver selos. Na mwet Israel fah filiya ma inge fin wen ac acn natulos. Ouinge elos ac fah usla mwe kasrup lun mwet Egypt.” ");
INSERT INTO kos_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Na Moses el topuk LEUM GOD ac fahk, “Tusruktu fin pa mwet Israel elos tiana lulalfongiyu ac tia porongo ma nga fahk uh, mea nga ac oru elos fin fahk mu kom tiana sikme nu sik?” ");
INSERT INTO kos_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ouinge LEUM GOD El siyuk sel, “Mea se inpoum an?” El topuk, “Sikal soko.” ");
INSERT INTO kos_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","LEUM GOD El fahk, “Sisya nu infohk an.” Pacl se ke Moses el sisya ah, sikal soko ah ekla nu ke wet soko, ac Moses el kaing liki. ");
INSERT INTO kos_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Na LEUM GOD El fahk nu sel, “Kui, sruokya pulal ac srukak.” Na Moses el asroela paul ac sruokya, na wet soko ah sifilpa ekla sikal soko. ");
INSERT INTO kos_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","LEUM GOD El fahk, “Oru ouinge in akpwayei nu sin mwet Israel lah LEUM GOD lun papa tumalos — God lal Abraham, Isaac, ac Jacob — El sikyak nu sum.” ");
INSERT INTO kos_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","LEUM GOD El sifilpa kaskas nu sel Moses, “Isongya poum nu luin nuknuk lom an.” Moses el akos; ac ke el eisla paol liki nuknuk lal ah, mas lepa oan kac, fasrfasr oana snow. ");
INSERT INTO kos_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Na LEUM GOD El fahk, “Sifilpa isongya poum nu luin nuknuk lom an.” El oru oana, ac ke el eisla, paol kwela ac oana meet ah. ");
INSERT INTO kos_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","LEUM GOD El fahk, “Elos fin tiana porongekom ku lulalfongi mwenmen se meet an, na elos ac fah lulalfongi ke mwenmen se akluo uh. ");
INSERT INTO kos_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Na elos fin tiana lulalfongi ke mwenmen luo inge ac srakna tia lungse lohng pusrem, kom utiya kutu kof infacl Nile ac ukuiya infohk ah. Kof ah ac fah ekla nu ke srah.” ");
INSERT INTO kos_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Tuh Moses el fahk, “O Leum, nunak munas nu sik. Nga nuna mwet supah in kaskas se, ac inge ke kom sramsram nu sik, nga srakna supah in kas. Nga pahtlac in nunkauk ma ngan fahk, ac nga kaskas lohlo.” ");
INSERT INTO kos_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","LEUM GOD El fahk nu sel, “Su orala oalin mwet uh? Su oru mwet se in koflana kaskas ku sulohngkas? Su orala mwet se in liyaten ku in kun? Nga, LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Fahsrot! Nga ac kasrekom in sramsram, ac nga ac fah fahk nu sum ma kom in fahk.” ");
INSERT INTO kos_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Tuh Moses el fahk, “O Leum, nunak munas, supwala siena mwet.” ");
INSERT INTO kos_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Na LEUM GOD El kasrkusrakak sel Moses ac fahk, “Ac Aaron, tamulel Levi se wiom ah? Nga etu lah el mwet pah in kas se. Inge, el ac tuku in osun nu sum, ac el ac arulana engan in liye kom. ");
INSERT INTO kos_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Kom ku in sramsram nu sel ac fahk ma elan fahk. Nga ac kasrekomtal kewa in kaskas, ac nga ac fahk nu sumtal ma komtal in oru. ");
INSERT INTO kos_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","El ac fah mwet sramsram lom ac aol kom in kaskas nu sin mwet uh. Na kom ac fah oana God nu sel in fahkang ma elan fahk. ");
INSERT INTO kos_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Us sikal soko ingan wi kom — kom ac fah orek mwenmen kac.” ");
INSERT INTO kos_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Na Moses el folokla nu yorol Jethro, papa tumun mutan kial, ac fahk nu sel, “Nunak munas, lela nga in folokla nu yurin sou luk in acn Egypt in liye lah elos srakna moul.” Jethro el insese nu kac ac wilkas nu sel. ");
INSERT INTO kos_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ke Moses el srakna muta Midian, LEUM GOD El fahk nu sel, “Folokla nu Egypt tuh elos nukewa su suk in unikomi elos misa.” ");
INSERT INTO kos_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ouinge Moses el us mutan kial ac wen natul, fuhleltal uh fin soko donkey ac mukuiyak nu Egypt. El us sikal soko ma God El fahk nu sel elan us. ");
INSERT INTO kos_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","LEUM GOD El sifilpa fahk nu sel Moses, “Inge ke kom ac folokla nu Egypt uh, aklohya in oru mwenmen nukewa ma nga sot ku nu sum in oru ye mutal tokosra. Tusruktu nga fah akupaye nunkal tokosra, ac el ac fah tia fuhlela mwet uh in som. ");
INSERT INTO kos_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Na kom fah fahk nu sel lah nga, LEUM GOD, fahk mu, ‘Israel pa wen se emeet nutik. ");
INSERT INTO kos_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Nga fahk nu sum in fuhlela wen nutik in som tuh elan ku in alu nu sik, a kom srunga. Inge nga ac uniya wen se oemeet nutum.’” ");
INSERT INTO kos_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ke sie acn in aktuktuk ke inkanek nu Egypt, LEUM GOD El sonol Moses ac oru elan unilya. ");
INSERT INTO kos_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Tuh Zipporah el srukak eot kosroh se, ac supukla kulun ma mukul lun wen natul, ac sang pusralla falkal Moses, ac fahk, “Pwayena kom pa mukul ke srah tumuk.” ");
INSERT INTO kos_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ouinge LEUM GOD El tila unilya Moses. Na mutan sac sifilpa fahk, “Kom mukul tumuk in srah ke sripen kosrala.” ");
INSERT INTO kos_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Na LEUM GOD El fahk nu sel Aaron, “Som nu yen mwesis in osun nu sel Moses.” Ouinge el som ac sonol pe eol mutal. Ac ke el sonol el ngok mutal. ");
INSERT INTO kos_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Na Moses el fahkang nu sel Aaron ma nukewa ma LEUM GOD El tuh fahk ke El supwal elan folok nu Egypt. El oayapa srumun ke mwenmen su LEUM GOD El sapkin elan oru. ");
INSERT INTO kos_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ouinge Moses ac Aaron som nu Egypt ac pangoneni mwet kol lun Israel nukewa nu sie. ");
INSERT INTO kos_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron el srumun nu selos ma nukewa ma LEUM GOD El fahk nu sel Moses, na Moses el oru mwenmen nukewa ye mutalos. ");
INSERT INTO kos_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Elos lulalfongi ma elos liye ac lohng, ac ke elos lohng lah LEUM GOD El tuku nu yorolos ac liye lupan mwe keok orek nu selos, elos faksufi ac alu. ");
INSERT INTO kos_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Na Moses ac Aaron som nu yurin tokosra Egypt ac fahk, “LEUM GOD lun Israel El fahk, ‘Fuhlela mwet luk in som, tuh elos fah ku in oru sie kufwa in akfulatyeyu yen mwesis.’” ");
INSERT INTO kos_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Tokosra el kouyak ac fahk, “Su LEUM GOD? Efu ku ngan lohngol ac fuhlela mwet Israel in som? Nga tia etu ke LEUM GOD, ac nga fah tia lela mwet Israel in som.” ");
INSERT INTO kos_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Moses ac Aaron topkol, “God lun mwet Hebrew El sikme nu sesr. Lela nu sesr kut in fahsr ke len tolu nu yen mwesis in oru mwe kisa lasr nu sin LEUM GOD lasr. Kut fin tia oru, El ac fah unikuti ke mas ku ke mweun.” ");
INSERT INTO kos_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Tokosra el fahk nu sel Moses ac Aaron, “Efu komtal ku nunku in tulokinya orekma lun mwet uh? Mwet kohs ingan in folokla orekma! ");
INSERT INTO kos_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kowos arulana pus liki mwet Egypt uh, a inge kowos lungse mongla, tia orekma!” ");
INSERT INTO kos_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ke len sacna, tokosra el sapkin mwet Egypt su liyaung mwet kohs, ac mwet Israel su mwet kol lalos ");
INSERT INTO kos_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","in tia sifil sang mah pao nu sin mwet Israel in orek brick kac, a elos in sifacna som suk. ");
INSERT INTO kos_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Tusruktu elos in oru na pisen brick ma elos muta oru meet ah — in tia pueni. El fahk, “Srikla orekma itukyang nu selos an, pa sis elos kwafe na sik nga in fuhlelosla in som orek kisa nu sin God lalos uh! ");
INSERT INTO kos_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Sang orekma lalos an in upa liki meet ah, ac oru elos in kafofo, tuh in wangin pacl lalos in muta porongo kas kikiap inge.” ");
INSERT INTO kos_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Mwet liyaung mwet kohs ac mwet Israel su kol orekma lalos elos som ac fahk nu sin mwet Israel, “Tokosra el fahk mu el ac tia sifilpa supu mah pao nu suwos. ");
INSERT INTO kos_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","El mu kowos in sifacna som eis yen na kowos ku in konauk we, tusruk pisen brick kowos ac oru an in pisa se na meet ah.” ");
INSERT INTO kos_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ouinge mwet uh fahsrelik yen nukewa fin acn Egypt sukok mah pao nu ke brick. ");
INSERT INTO kos_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Mwet liyaung mwet kohs elos srike na in kalyaelos in oru na pisen brick sac, oana ke elos tuh orala ke pacl ma itukyang mah pao nu selos. ");
INSERT INTO kos_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Mwet liyaung mwet kohs elos sringil mwet kol orekma lun mwet Israel, su elos srisrngiya in liyaung orekma uh. Elos kouyak ac siyuk, “Efu komtal ku tia oru na pisen brick se ma komtal oru meet ah?” ");
INSERT INTO kos_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Na mwet kol orekma lun mwet Israel elos som nu yorol tokosra ac fahk, “Efu tokosra ku oru ange nu sesr? ");
INSERT INTO kos_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Tia ituku mah pao nu sesr, a srakna sapkinyuk kut in orek brick! Ac inge sringsring kut. Ma koluk inge ma lun mwet lom uh.” ");
INSERT INTO kos_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Tokosra el topuk, “Komtal alsrangesr ac tia lungse orekma, pa pwanang komtal siyuk ngan lela nu sumtal in som ac orek kisa nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Folokla orekma! Wangin mah pao ac itukot nu sumtal, tuh kowos in oru na pisen brick sac.” ");
INSERT INTO kos_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Mwet kol orekma lun mwet Israel akilenak lah ac arulana koluk nu selos, ke fwackyang tari elos in oru na pisen brick se ke len nukewa oana ke elos muta oru meet ah. ");
INSERT INTO kos_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ke elos illa, elos sonol Moses ac Aaron su tu soanelos. ");
INSERT INTO kos_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Na elos fahk nu seltal, “LEUM GOD El liye ma komtal oru nu sesr inge ac El ac fah kai komtal mweyen ke sripomtal tokosra ac mwet fulat lal inge srungakut. Komtal sang in oasr sripe elos in unikuti.” ");
INSERT INTO kos_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Na Moses el sifil kaskas nu sin LEUM GOD ac fahk, “O Leum, efu kom ku oru koluk mwet lom? Efu kom ku supweyume nu inge? ");
INSERT INTO kos_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ke na pacl se nga mutawauk fahsr nu yorol tokosra in kaskas nu sel Inem, el oru arulana koluk nu selos. Ac wanginna ma kom oru in kasrelos!” ");
INSERT INTO kos_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Na LEUM GOD El fahk nu sel Moses, “Inge kom ac fah liye ma nga ac oru nu sel tokosra. Ke po ku luk, nga ac oru elan fuhlela mwet luk uh in som. Aok, nga ac oru elan luselosla liki facl sel uh.” ");
INSERT INTO kos_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","God El kaskas nu sel Moses ac fahk, “Nga pa LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nga tuh sikyang nu sel Abraham, ac Isaac, ac Jacob, oana ke nga God Kulana, tusruktu nga tiana fahkyuyak nu selos ke Ine mutal luk: LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nga oayapa oakiya wuleang luk yorolos in sang nu selos facl Canaan, facl se su elos tuh mutangan mwetsac we. ");
INSERT INTO kos_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Inge nga lohng sasao lun mwet Israel, su mwet Egypt akkohsye, ac nga esam na wuleang luk. ");
INSERT INTO kos_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ouinge fahk nu sin mwet Israel lah nga fahk mu, ‘Nga pa LEUM GOD. Nga fah tulekowosla ac aksukosokyekowos liki moul in kohs lowos yurin mwet Egypt. Nga fah asroela po kulana luk in use kaiyuk upa nu faclos, ac nga fah molikowosla. ");
INSERT INTO kos_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nga fah oru tuh komws in mwet luk sifacna, ac nga fah God lowos. Kowos fah etu lah nga pa LEUM GOD lowos ke pacl se nga ac aksukosokye kowos liki moul in kohs lowos in Egypt. ");
INSERT INTO kos_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nga ac fah us kowos nu in sie facl su nga orek wulela ku kac in sang nu sel Abraham, Isaac, ac Jacob. Ac nga ac sot nu suwos tuh in facl suwos. Nga LEUM GOD.’” ");
INSERT INTO kos_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moses el fahk ma inge nu sin mwet Israel, tusruktu elos tiana porongel, mweyen wanginla finsrak lalos ke sripen upala akkohs orek nu selos. ");
INSERT INTO kos_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Na LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Som ac fahk nu sel tokosra lun Egypt elan fuhlela mwet Israel in som liki facl sel an.” ");
INSERT INTO kos_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Tuh Moses el topuk fahk, “Mwet Israel inge elos tiana lohngyu, na ac fuka tuh tokosra elan lohngyu? Nga mwet na supah in kas se.” ");
INSERT INTO kos_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","LEUM GOD El fahk nu sel Moses ac Aaron, “Fahkang nu sin mwet Israel ac Tokosra Egypt lah nga supwekomtal in kolla mwet Israel liki facl Egypt.” ");
INSERT INTO kos_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Reuben, wen se emeet natul Jacob, oasr wen akosr natul: Hanoch, Pallu, Hezron, ac Carmi. Eltal pa mwet matu mutaweyen sou inge su ekin inelos. ");
INSERT INTO kos_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon, oasr wen onkosr natul: Jemuel, Jamin, Ohad, Jachin, Zohar, ac Shaul, wen nutin mutan Canaan se. Eltal pa mwet matu mutaweyen sou inge su ekin inelos. ");
INSERT INTO kos_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi, oasr wen tolu natul: Gershon, Kohath, ac Merari. Eltal pa mwet matu mutaweyen sou inge su ekin inelos. Levi el moul yac siofok tolngoul itkosr. ");
INSERT INTO kos_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Oasr wen luo natul Gershon: Libni ac Shimei, ac pukanten fwilin tulik natulos. ");
INSERT INTO kos_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Oasr wen akosr natul Kohath: Amram, Izhar, Hebron, ac Uzziel. Kohath el moul yac siofok tolngoul tolu. ");
INSERT INTO kos_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Oasr wen luo natul Merari: Mahli ac Mushi. Pa inge sou nukewa lal Levi ac takinyen fwilin tulik natulos. ");
INSERT INTO kos_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram el payuk sin mutan se wien papa tumal ah, Jochebed, su oswella Aaron ac Moses. Amram el moul yac siofok tolngoul itkosr. ");
INSERT INTO kos_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Wen tolu natul Izhar: Korah, Nepheg, ac Zichri. ");
INSERT INTO kos_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Wen tolu pac natul Uzziel: Mishael, Elzaphan, ac Sithri. ");
INSERT INTO kos_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron el payuk sel Elisheba, acn natul Amminadab ac ma wial Nahshon. El oswella Nadab, Abihu, Eleazar, ac Ithamar. ");
INSERT INTO kos_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Wen tolu natul Korah: Assir, Elkanah, ac Abiasaph. Elos pa mwet matu mutaweyen sou nukewa natul Korah. ");
INSERT INTO kos_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Elezar, wen natul Aaron, el payuk sin sie acn natul Putiel, su oswella Phinehas. Pa inge sifen sou nukewa ke sruf lun Levi. ");
INSERT INTO kos_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aaron ac Moses pa LEUM GOD El fahk nu se, “Kolla sruf nukewa lun Israel liki facl Egypt.” ");
INSERT INTO kos_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Eltal pa mwet ma fahkang nu sin tokosra Egypt in aksukosokyela mwet Israel. ");
INSERT INTO kos_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ke LEUM GOD El kaskas nu sel Moses in acn Egypt, ");
INSERT INTO kos_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","El fahk, “Nga pa LEUM GOD. Fahk nu sin Tokosra Egypt ma nukewa nga fahk nu sum uh.” ");
INSERT INTO kos_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Tuh Moses el topuk, “Kom etu lah nga mwet na supah in kas se. Na ac fuka tuh tokosra elan lohngyu?” ");
INSERT INTO kos_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","LEUM GOD El fahk, “Nga ac oru kom in oana God nu sel tokosra, ac Aaron, tamulel lom, ac fah kaskas nu sel oana mwet palu se lom. ");
INSERT INTO kos_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Fahk nu sel Aaron ma nukewa nga sapkin nu sum uh, ac el ac fah fahk nu sel tokosra elan lela mwet Israel in som liki facl sel uh. ");
INSERT INTO kos_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Tusruktu nga ac akupaye nunkal tokosra, ac finne pus mwe aksangeng nga orala in acn Egypt, ");
INSERT INTO kos_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","el ac fah tiana lohng kom. Na nga fah sang mwe kai na upa nu fin acn Egypt ac kolla mwet in sruf nukewa luk liki facl sac. ");
INSERT INTO kos_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Na mwet Egypt elos tufah etu lah nga pa LEUM GOD, ke pacl se nga ac srukak pouk lainulos, ac kolla mwet Israel liki facl selos.” ");
INSERT INTO kos_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moses ac Aaron oru oana God El sapkin. ");
INSERT INTO kos_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ke pacl se eltal kaskas nu sel tokosra, Moses el yac oalngoul matwal, ac Aaron el yac oalngoul tolu. ");
INSERT INTO kos_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","LEUM GOD El fahk nu sel Moses ac Aaron, ");
INSERT INTO kos_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Tokosra el fin sap komtal in oru sie mwenmen in akpwayeye kas lomtal uh, fahk nu sel Aaron elan srukak sikal lal ac sisya nu infohk uh ye mutal tokosra, na ac fah ekla nu ke wet soko.” ");
INSERT INTO kos_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ouinge Moses ac Aaron som nu yorol tokosra, ac oru oana LEUM GOD El sap. Aaron el sisya sikal lal nu ye mutal tokosra ac mwet fulat lal, ac sikal soko ah ekla nu ke wet soko. ");
INSERT INTO kos_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Na tokosra el pangonma mwet lalmwetmet ac mwet orek inutnut lal, ac elos oru oapana. ");
INSERT INTO kos_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Elos sisya sikal lalos ah, ac sikal lalos uh ekla wet pac. Tusruktu sikal lal Aaron ah okomla sikal lalos ah. ");
INSERT INTO kos_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ne ouinge, nunak lal tokosra srakna upa, ac el tiana lohngol Moses ac Aaron, oana ma LEUM GOD El tuh fahk. ");
INSERT INTO kos_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Na LEUM GOD El fahk nu sel Moses, “Arulana upa nunkal tokosra, ac el tiana lela mwet ah in som. ");
INSERT INTO kos_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ouinge fahla ac sonol lututang ke el ac tufokla nu ke Infacl Nile uh. Us sikal soko ma tuh ekla nu ke wet soko ah, ac soanel pe infacl ah. ");
INSERT INTO kos_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Na kom fahk nu sel tokosra, ‘LEUM GOD lun mwet Hebrew El supweyume in fahkot nu sum kom in fuhlela mwet lal ah in som, tuh elos in ku in alu nu sel in acn mwesis. Tuh pa kom tiana akos. ");
INSERT INTO kos_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Inge, Tokosra, LEUM GOD El fahk mu kom ac fah etu lah su El uh ke ma El ac oru. Liye, nga ac sringilya fin kof uh ke sikal soko inge, na kof uh ac fah ekla nu ke srah. ");
INSERT INTO kos_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ik infacl ah ac fah misa, ac infacl uh ac fah arulana pusrosrak, oru mwet Egypt ac fah tia ku in nim kof kac.’” ");
INSERT INTO kos_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","LEUM GOD El fahk nu sel Moses, “Fahkang nu sel Aaron elan us sikal lal ah ac kolak ac asroela nu fin infacl nukewa, inyoa ac inlulu nukewa in acn Egypt. Kof uh ac fah ekla nu ke srah, na ac fah oasr srah yen nukewa, finne luin tup sak ac mwe neinyuk kof ma orek ke eot.” ");
INSERT INTO kos_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Na Moses ac Aaron oru oana LEUM GOD El sapkakin. Ye mutun tokosra ac mwet fulat lal, Aaron el kolak sikal lal ac sringilya kof infacl ah, ac kof loac ekla nu ke srah. ");
INSERT INTO kos_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ik infacl ah misa, ac foul infacl uh arulana pusrosrak, oru mwet Egypt tiana ku in nim kof kac. Oasr srah yen nukewa in Egypt. ");
INSERT INTO kos_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Na mwet inutnut lal tokosra orala mwenmen lalos ac sikyak oapana, ac nankal tokosra srakna upa. Oana ke LEUM GOD El tuh fahk, tokosra el tiana lohngol Moses ac Aaron. ");
INSERT INTO kos_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","El folokla nu inkul fulat sel, ac tiana lohang nu ke ma sikyak inge. ");
INSERT INTO kos_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Mwet Egypt nukewa pikin pe infacl ah in suk kof in nimnim mweyen elos tia ku in nim kof ke infacl ah. ");
INSERT INTO kos_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Len itkosr somla tukun LEUM GOD El sringilya infacl ah. ");
INSERT INTO kos_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Na LEUM GOD El fahk nu sel Moses, “Utyak nu ye mutal tokosra ac fahk nu sel lah LEUM GOD El fahk mu, ‘Lela mwet luk ah in som, elos in ku in alu nu sik. ");
INSERT INTO kos_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kom fin srunga, nga ac fah kai mutunfacl sum uh, ac sang frog in osralik acn nukewa. ");
INSERT INTO kos_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Infacl Nile ac fah arulana sessesla ke frog, su ac fah sroak liki infacl ah ac utyak nu inkul fulat sum, infukil in motul sum, mwe oan kiom, lohm sin mwet pwapa fulat lom ac mwet lom, oayapa luin nien manman lom ac ahlu in aryar flao. ");
INSERT INTO kos_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Frog inge ac fah sroak nu fom ac nu fin mwet lom, ac nu fin mwet pwapa fulat lom.’” ");
INSERT INTO kos_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","LEUM GOD El fahk nu sel Moses, “Fahk nu sel Aaron elan asroela sikal lal ah nu fin infacl, inyoa, ac inlulu nukewa, ac oru frog uh in sroak ac afunla fin acn Egypt.” ");
INSERT INTO kos_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ouinge Aaron el asroela sikal lal fin kof uh, ac frog uh otyak ac afunla acn uh. ");
INSERT INTO kos_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Tusruk mwet orek inutnut elos orekmakin pac ku lukma lalos ac oru tuh in oasr pac frog utyak nu fin acn uh. ");
INSERT INTO kos_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Tokosra el solalma Moses ac Aaron ac fahk nu seltal, “Pre ac siyuk sin LEUM GOD Elan eisla frog inge liki acn uh, na nga ac fah fuhlela mwet lowos in som, elos in ku in orek kisa nu sin LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses el topuk ac fahk, “Nga arulana engan in pre nu sin LEUM GOD inem. Fahkma pacl nga ac pre keim ac oayapa inen mwet pwapa fulat lom ac mwet lom, tuh frog uh in wanginla liki kom ac liki lohm suwos. Ac fah wangin frog lula sayen ma ke infacl Nile.” ");
INSERT INTO kos_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Tokosra el topuk ac fahk, “Pre lutu.” Moses el fahk, “Nga ac oru oana kom fahk, na kom ac fah etu lah wangin sie god oana LEUM GOD, God lasr. ");
INSERT INTO kos_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ac fah wanginla frog liki kom ac liki inkul sum, ac liki mwet pwapa fulat lom ac mwet lom uh, sayen frog ke infacl Nile mukena.” ");
INSERT INTO kos_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Na Moses ac Aaron som lukel tokosra, ac Moses el pre nu sin LEUM GOD Elan eisla frog ma El tuh use in kael tokosra. ");
INSERT INTO kos_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","LEUM GOD El oru oana Moses el siyuk, ac frog ma oan in lohm, ku likinum, ku in imae misa kewa. ");
INSERT INTO kos_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Mwet Egypt elos elosak frog uh in eol na lulap pukanten, oan nwe fohlelana acn uh. ");
INSERT INTO kos_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ke tokosra el liye lah frog uh misa tari, el sifilpa akupaye nankal ac tia lohngol Moses ac Aaron, oana ke LEUM GOD El tuh fahk meet ah. ");
INSERT INTO kos_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","LEUM GOD El fahk nu sel Moses, “Fahk nu sel Aaron elan puokya infohk uh ke sikal lal ah, na pukun kutkut infohk uh fin acn Egypt nufon ac ekla nu ke won srisrik ngalngul.” ");
INSERT INTO kos_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ouinge Aaron el puokya infohk uh ke sikal lal, ac pukun kutkut infohk uh nufon in acn Egypt ekla nu ke won srisrik ngalngul, su tuhwi fin mwet ac fin kosro nukewa. ");
INSERT INTO kos_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Mwet orek inutnut elos srike in orek mwenmen in use pac won srisrik ngalngul, tuh elos tia ku. Oasr won srisrik ngalngul yen nukewa, ");
INSERT INTO kos_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ac mwet orek inutnut uh fahk nu sel tokosra, “God pa oru ma inge!” Tusruktu upala nankal tokosra, ac el tia lohngol Moses ac Aaron, oana ke LEUM GOD El tuh fahk ah. ");
INSERT INTO kos_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","LEUM GOD El fahk nu sel Moses, “Toangna lutu, fahla sonol tokosra ke el ac som nu infacl ah, ac fahk nu sel mu LEUM GOD El fahk, ‘Fuhlela mwet luk uh in som, elos in ku in alu nu sik. ");
INSERT INTO kos_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kom fin srangesr fuhlelosla, na nga ac kai kom ke nga ac supwaot un loang puspis nu fom ac nu fin mwet fulat lom ac mwet lom nukewa. Lohm sin mwet Egypt ac fah sessesla ke loang, ac fin fohk uh ac fah afla pac ke loang. ");
INSERT INTO kos_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Tusruktu nga ac srela acn Goshen, yen mwet luk muta we, tuh in wangin loang we. Nga oru ouinge tuh kom in etu lah nga, LEUM GOD, nga oasr in facl se inge. ");
INSERT INTO kos_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nga fah oru in kalem lah oasr ekla inmasrlon mwet luk ac mwet lom. Mwe akul usrnguk se inge ac sikyak lutu.’” ");
INSERT INTO kos_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","LEUM GOD El supwala un loang na pukanten nu in lohm sin tokosra ac lohm sin mwet fulat lal. Mutunfacl Egypt nufon musalla ke loang uh. ");
INSERT INTO kos_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Na tokosra el solalma Moses ac Aaron ac fahk, “Som ac oru kisa lowos nu sin God lowos in facl se na inge.” ");
INSERT INTO kos_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moses el topuk, “Ac tia fal in ouinge, mweyen mwet Egypt elos ac srunga ke kut ac kisakin kosro ma mutal selos nu sin LEUM GOD lasr, na ke kut ac kisakin kosro inge yen elos ku in liye, elos ac arulana srunga, pwanang elos ac tungal kut nweke kut misa. ");
INSERT INTO kos_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kut enenu in fahsr len tolu nu yen mwesis in oru kisa nu sin LEUM GOD lasr, oana El sapkin nu sesr.” ");
INSERT INTO kos_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Tokosra el fahk, “Nga ac fuhlela kowos in som kisa nu sin LEUM GOD lowos in acn mwesis, kowos fin tia som loesla. Tal pre keik.” ");
INSERT INTO kos_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses el topuk, “Tukunna nga ac som, nga ac fah pre nu sin LEUM GOD tuh lutu loang puspis inge fah som liki kom, ac liki mwet fulat lom ac mwet lom. Tusruktu, enenu na kom in tia sifil kiapwekut, ku kutong mwet inge in tia som orek kisa nu sin LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moses el illa ac som lukel tokosra, ac pre nu sin LEUM GOD, ");
INSERT INTO kos_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ac LEUM GOD El oru oana siyuk lal Moses. Loang uh som lukel tokosra ac mwet fulat ac mwet lal nukewa. Wangin sie loang lula. ");
INSERT INTO kos_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Na tokosra el sifil pacna akupaye nankal, ac tiana fuhlela mwet uh in som. ");
INSERT INTO kos_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","LEUM GOD El fahk nu sel Moses, “Utyak nu ye mutal tokosra ac fahk nu sel lah LEUM GOD lun mwet Hebrew El fahk, ‘Lela mwet luk in som, tuh elos in ku in alu nu sik. ");
INSERT INTO kos_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Kom fin sifilpa srunga fuhlela elos in som, ");
INSERT INTO kos_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nga ac kai kom, ac supwaot sie mas na upa nu fin kosro nukewa — horse nutum, donkey nutum, camel, cow, sheep ac nani. ");
INSERT INTO kos_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Nga fah sraclik kosro nutin mwet Israel liki kosro nutin mwet Egypt, na ac fah wangin kosro nutin mwet Israel misa. ");
INSERT INTO kos_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nga, LEUM GOD, oakiya tuh lutu nga fah oru ma inge.’” ");
INSERT INTO kos_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Len se toko, LEUM GOD El oru oana El fahk, ac kosro nukewa nutin mwet Egypt ah misa, a tia soko kosro nutin mwet Israel misa. ");
INSERT INTO kos_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Tokosra el sapla siyuk lah mea sikyak, na fwackyang nu sel lah wangin sokofanna kosro nutin mwet Israel misa. Tusruktu upa na nankal ac el tia lela mwet ah in som. ");
INSERT INTO kos_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Na LEUM GOD El fahk nu sel Moses ac Aaron, “Eis kutu apat an inpoumtal liki funyu uh, na Moses elan sisak nu lucng ye mutal tokosra. ");
INSERT INTO kos_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ac fah sokelik oana fofosr lun fohkfok fin acn nukewa lun Egypt, ac yen nukewa ac sikyak faf su ac orala ruf aryur fin mwet ac fin kosro.” ");
INSERT INTO kos_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ouinge eltal eis kutu apat ac tu ye mutal tokosra. Moses el sisak nu lucng, ac apat uh ekla faf su orala ruf aryur ke monin mwet ac kosro uh. ");
INSERT INTO kos_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Mwet orek inutnut uh koflana tuku nu ye mutal Moses, mweyen manolos wi afla ke faf, oana mwet Egypt nukewa ngia. ");
INSERT INTO kos_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Na LEUM GOD El akupaye nankal tokosra, tuh elan tia lungse lohngol Moses ac Aaron, oana ke LEUM GOD El tuh fahk nu sel Moses meet ah. ");
INSERT INTO kos_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Na LEUM GOD El fahk nu sel Moses, “Toangna lutu, kom in som tu ye mutal tokosra ac fahkang nu sel lah LEUM GOD lun mwet Hebrew El fahk, ‘Fuhlela mwet luk in som, tuh elos in ku in alu nu sik. ");
INSERT INTO kos_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Pacl se inge nga ac supwaot mwe ongoiya upa nukewa luk nu fom ac nu fin mwet fulat lom ac mwet lom, tuh kom fah etu lah wangin sie oana nga fin faclu nufon. ");
INSERT INTO kos_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Nga funu srukak pouk in lain kom ac mwet lom ke mas, kowos lukun wanginla na pwaye. ");
INSERT INTO kos_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Tusruktu sripa se sis nga lela kom in moulna, tuh in fahkak ku luk nu sum, ac inek in pwengelik nu fin faclu nufon. ");
INSERT INTO kos_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ne ouinge, kom srakna inse fulat ac tia lungse lela mwet luk uh in som. ");
INSERT INTO kos_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ke pacl se na inge lutu, nga fah oru sie af na matol ac af yohk kosra, su tia liyeyuk oemeet me in acn Egypt. ");
INSERT INTO kos_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Inge sapkin tuh kosro nutum ac ma nukewa saya ma muta in imah uh in utukyak nu in lohm uh. Af yohk kosra ac fah kahki nu fin mwet ac kosro ma mutana in imae ac tia utukyak nu in lohm ah, ac elos nukewa fah misa.’” ");
INSERT INTO kos_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kutu sin mwet fulat lal tokosra elos sangeng ke ma LEUM GOD El fahk inge, oru elos usak mwet kohs lalos ac kosro natulos nu in lohm ah. ");
INSERT INTO kos_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","A kutu mwet uh tia lohang nu ke ma LEUM GOD fahk, ac fuhlelana mwet kohs lalos ac kosro natulos in mutana in imae. ");
INSERT INTO kos_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Na LEUM GOD El fahk nu sel Moses, “Sralak poum nu lucng, ac af yohk kosra fah kahki nu fin mutunfacl Egypt nufon — nu fin mwet, kosro, ac mwe yok in imae nukewa.” ");
INSERT INTO kos_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ouinge Moses el srukak sikal lal ac kolak nu lucng, ac LEUM GOD El supweya pulahl ac af yohk kosra, ac sarom kasri nu in fohk uh. LEUM GOD El supweya ");
INSERT INTO kos_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","af na matol ac yohk kosra, ac oasr sarom yen nukewa. Paka se inge upa liki kutena paka ma sikyak meet in acn Egypt. ");
INSERT INTO kos_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Fin acn Egypt nufon, af upa se inge kunausla ma nukewa ma oan likinum ac in imae, weang mwet ac kosro — kunausla mahsrik nukewa ac koteya sak nukewa. ");
INSERT INTO kos_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Acn Goshen mukena, yen mwet Israel muta we, pa wangin af upa we. ");
INSERT INTO kos_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Tokosra el sapla solalma Moses ac Aaron, ac fahk nu seltal, “Nga sifacna fahkyuyak inge lah oasr ma koluk luk. LEUM GOD pa suwohs, ac nga ac mwet luk uh pa tafongla. ");
INSERT INTO kos_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pre nu sin LEUM GOD, mweyen pulahl ac af yohk kosra inge arulana upala nu sesr! Nga wuleot in filikowosla in som. Kowos tia enenu in sifilpa muta yenu.” ");
INSERT INTO kos_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses el fahk nu sel, “Pacl se na nga illa liki siti uh, nga fah sralak pouk in pre nu sin LEUM GOD. Pulahl ac fah tui, ac ac fah wanginla af upa, tuh kom fah ku in etu lah faclu ma lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Tusruktu nga etu lah kom ac mwet fulat lom srakna tia sangeng sin LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Flax ac barley kunausyukla ke af upa sac, mweyen barley ah mwesrla ac flax ah tufacna fokla. ");
INSERT INTO kos_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Tusruktu wangin wheat musalla, mweyen soenna kapak. ");
INSERT INTO kos_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moses el som lukel tokosra, illa liki siti uh, ac sralak paol nu lucng ac pre nu sin LEUM GOD. Na pulahl wi af yohk kosra ah tui, ac tiana sifilpa af. ");
INSERT INTO kos_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ke tokosra el liye ma sikyak uh, el sifilpa orekma koluk. El ac mwet fulat lal ah sifilpa akupaye nankalos. ");
INSERT INTO kos_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Na in oana ke LEUM GOD El tuh fahk nu sel Moses meet mu tokosra el ac mau tia lela mwet Israel in som, ouinge el tiana lela. ");
INSERT INTO kos_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Na LEUM GOD El fahk nu sel Moses, “Fahla ac utyak nu ye mutal tokosra. Nga oru el ac mwet fulat lal uh in upa nankalos, ngan ku in oru mwenmen inge ye mutalos, ");
INSERT INTO kos_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","oayapa tuh kowos in ku in srumun nu sin tulik nutuwos ac tulik nutin tulik nutuwos ke nga tuh oru mwet Egypt uh in oana mwet lalfon ke mwenmen ma nga oru. Na kowos nukewa fah etu lah nga pa LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ouinge Moses ac Aaron som nu yorol tokosra ac fahk nu sel, “LEUM GOD lun mwet Hebrew El fahk, ‘Ac puta kac pacl kom ac tia akpusiselye kom nu sik? Fuhlela mwet luk in som tuh elos in ku in alu nu sik. ");
INSERT INTO kos_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kom fin srangesr na, nga ac use locust puspis nu fin acn sum lutu. ");
INSERT INTO kos_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ac fah arulana pukanten, oru elos ac afunla fin fohk uh nufon. Elos ac fah kangla ma nukewa ma af upa sac tia kunausla, finne sak ma lula. ");
INSERT INTO kos_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Elos ac nwakla lohm nukewa inkul sum, ac lohm nukewa sin mwet fulat lom ac mwet nukewa lom. Mwet matu lom nukewa tiana liye ma koluk ouinge emeet me.’” Na Moses el illa som. ");
INSERT INTO kos_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Mwet fulat lal tokosra fahk nu sel, “Mwet se inge ac aklokoalokye kut nwe ngac? Tari fuhlela mwet Israel inge in som, elos in ku in alu nu sin LEUM GOD lalos. Ya kom tia liye lah acn Egypt arulana musalla?” ");
INSERT INTO kos_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Na folokinyukme Moses ac Aaron nu yorol tokosra, ac el fahk nu seltal, “Kowos ku in som ac alu nu sin LEUM GOD lowos. Tusruktu su ngac ac som an?” ");
INSERT INTO kos_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses el topuk, “Kut nukewa ac som, tulik ac mwet matu wi pac. Kut ac us wen ac acn natusr, sheep ac nani natusr, ac cow natusr, mweyen kut enenu in oru sie kufwa in akfulatye LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Tokosra el fahk, “Nga fulahk ke LEUM GOD lah nga fah tiana fuhlela kom in us mutan ac tulik nutuwos! Kalem lah kowos akoo in tuyak lain kut. ");
INSERT INTO kos_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Mo, tia ouingan! Mukul mukena ku in som ac alu nu sin LEUM GOD, fin pa ingan ma kowos lungse an.” Ke ma inge, Moses ac Aaron lillilla liki ye mutal tokosra. ");
INSERT INTO kos_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Na LEUM GOD El fahk nu sel Moses, “Sralak poum nu fin acn Egypt in use locust uh. Elos fah tuku kangla ma nukewa ma kapak, ma tia musalla ke af yohk kosra sac.” ");
INSERT INTO kos_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ouinge Moses el kolak sikal lal ah, ac LEUM GOD El oru sie eng in tuhyak kutulap me, in uk acn we ke len ac fong nufon se. Ke lotutang tok ah, eng uh use locust uh. ");
INSERT INTO kos_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Elos rirme afunla fin facl sac nufon. Un locust inge arulana matol liki kutena ma liyeyuk meet me, ku ac fah tia pac liyeyuk tok. ");
INSERT INTO kos_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Elos afunla fin fohk uh nwe ke acn uh sroalsroalla kaclos. Elos kangla ma nukewa ma af yohk kosra sac tia kunausla — fokinsak nukewa ulun sak uh wi pac. Tia ma folfolsra se lula ke sak nukewa fin acn Egypt nufon. ");
INSERT INTO kos_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Na tokosra el sulaklak pangnolma Moses ac Aaron ac fahk, “Nga oru ma koluk lain LEUM GOD lowos ac lain kowos. ");
INSERT INTO kos_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ke ma inge, nunak munas nu sik ke pacl sefanna inge, ac pre nu sin LEUM GOD lowos Elan eisla mwe misa lulap se inge likiyu.” ");
INSERT INTO kos_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moses el som lukel tokosra ac pre nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ac LEUM GOD El ekulla eng uh nu ke sie eng na upa roto me, su orani nufon locust uh ac okla nu in Meoa Srusra. Tia siefanna locust lula in facl Egypt nufon. ");
INSERT INTO kos_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Tusruktu LEUM GOD El akupaye nunkal tokosra, ac el tia fuhlela mwet Israel in som. ");
INSERT INTO kos_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Na LEUM GOD El fahk nu sel Moses, “Sralak poum nu lucng, ac sie lohsr na matoltol fah sunya acn Egypt, sie lohsr ma ku in puleyuk.” ");
INSERT INTO kos_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moses el sralak paol nu lucng, ac sie lohsr matoltol apneni Egypt nufon ke len tolu. ");
INSERT INTO kos_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Mwet Egypt tia ku in liye sie sin sie, ac wangin sie mwet illa liki lohm sel ke pulan pacl sac. A funu mwet Israel, oasr kalem yen elos muta we. ");
INSERT INTO kos_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Tokosra el pangnol Moses ac fahk nu sel, “Kowos ku in som ac alu nu sin LEUM GOD. Mutan ac tulik an ku in wi kowos som. Tusruktu sheep, nani, ac cow nutuwos an ac tia wi.” ");
INSERT INTO kos_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moses el topuk, “Fin ouingan, kom enenu in srukak kosro mwe kisa, ac mwe kisa firir, tuh kut in kisakin nu sin LEUM GOD lasr. ");
INSERT INTO kos_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Mo! Kut ac us na kosro natusr uh wi kut — tia sokofanna ac muta. Kut sifacna pa ac sule kosro ma fal ke pacl kut alu nu sin LEUM GOD lasr. Kut ac tia etu lah kosro fuka kut ac kisakin nu sel nwe ke kut sun acn we.” ");
INSERT INTO kos_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","LEUM GOD El akupaye nunkal tokosra, ac el tiana fuhlelosla in som. ");
INSERT INTO kos_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","El fahk nu sel Moses, “Tiok liki ye mutuk! Taran ngan tia sifilpa liyekomyak. Len se nga ac liye komyak uh, kom ac misa!” ");
INSERT INTO kos_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moses el topuk, “Pwaye sum. Kom ac fah tia sifilpa liyeyu.” ");
INSERT INTO kos_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Na LEUM GOD El fahk nu sel Moses, “Mwe ongoiya sefanna lula nga fah sang nu sel Tokosra Egypt ac mwet lal. Tukun ma sacn el ac filikowosla in som. Aok, el ac sap ku nu suwos nukewa in som liki acn se inge. ");
INSERT INTO kos_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Inge kaskas nu sin mwet Israel ac fahk nu selos nukewa, mukul ac mutan, in ngisre sin mwet tulan lalos ke mwe naweyuk gold ac silver.” ");
INSERT INTO kos_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","LEUM GOD El oru tuh mwet Egypt uh in akfulatye mwet Israel. In nunak lun mwet fulat ac mwet Egypt nukewa, Moses el sie mwet kol na fulat. ");
INSERT INTO kos_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Na Moses el fahk nu sel tokosra, “LEUM GOD El fahk, ‘Ke infulwen fong uh, nga ac fahsr sasla facl Egypt, ");
INSERT INTO kos_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ac wounse mukul nukewa in Egypt fah misa, mutawauk sin wounse natul tokosra, su ac fah tokosra tukum, nwe ke wounse mukul nutin mutan kulansap se su muta ke nien itat wheat. Wounse mukul nutin cow nukewa fah misa pac. ");
INSERT INTO kos_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ac fah oasr tung lulap ngisyak fin acn Egypt nufon, ma tia lohngyuk emeet me, ac ac fah tia pac sifil lohngyuk tok. ");
INSERT INTO kos_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","A wangin sokofanna kosro ngalngul ac woi mwet Israel ku kosro natulos. Na kowos fah etu lah nga, LEUM GOD, pa sraclik mwet Egypt ac mwet Israel.’” ");
INSERT INTO kos_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Moses el aksafyela sramsram lal ke el fahk mu, “Mwet fulat lom nukewa ac fah tuku nu yuruk ac faksufi ye mutuk, ac elos ac fah kwafe sik in us mwet luk nukewa som. Toko, nga fah som.” Na Moses el som lukel tokosra ke kasrkusrak lulap. ");
INSERT INTO kos_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","LEUM GOD El tuh fahk nu sel Moses, “Tokosra el ac tiana lohng kom, tuh nga fah ku in akpusye mwenmen luk in facl Egypt.” ");
INSERT INTO kos_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moses ac Aaron orala mwenmen inge nukewa ye mutal tokosra, tusruktu LEUM GOD El akupaye nankal, elan tia fuhlela mwet Israel in som liki facl sel. ");
INSERT INTO kos_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","LEUM GOD El kaskas nu sel Moses ac Aaron in acn Egypt, ac fahk, ");
INSERT INTO kos_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Malem se inge kowos fah oru tuh in malem se emeet ke yac nu suwos. ");
INSERT INTO kos_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Sang oakwuk inge nu sin mwet Israel nukewa: Ke len aksingoul in malem se inge, kais sie mukul enenu in sulela soko sheep fusr ku soko nani fusr nu sin mwet in lohm sel in mongo kac. ");
INSERT INTO kos_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Fin sou lal uh supusla in kang kosro fon soko, na sou lal ac sou atulani lal ku in tukeni kac, na elan kitalik in fal nu ke pisen mwet uh ke lupa ma elos ac ku in kangla. ");
INSERT INTO kos_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kom ku in sulela soko sheep mukul ku soko nani mukul, tusruktu matwa in yac se, ac in wangin ma koluk ke manol. ");
INSERT INTO kos_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Na ke eku in len aksingoul akosr in malem sac, mwet Israel nukewa fah uniya kosro solla uh. ");
INSERT INTO kos_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Mwet an fah eis kutu srah kac ac sang mosrwela sru lukwa ke mutunoa, ac acn lucng ke mutunoa, ke lohm nukewa ma kosro inge ac fah mongola we. ");
INSERT INTO kos_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","In fong sac ikwa uh ac fah manman, na mwet uh fah kang wi mahsrik mwen ac bread wangin mwe pulol kac. ");
INSERT INTO kos_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Nikmet kang ikwa inge fin takmwek ku poel, a enenu in fonna manmanla, wi na sifa, nia, ac koanonsia. ");
INSERT INTO kos_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kowos fah tia filiya kutena ip kac nu ke lututang. Fin oasr ma lula, kowos fah esukak. ");
INSERT INTO kos_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Kowos in nuknukyang ac fahlukyang akola nu ke fahla, ac sikal lowos in oan inpouwos, na kowos in mongo aksaya. Pa inge Kufwen Alukela se meet in akfulatyeyu, nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Ke fong sac nga fah fahsr sasla fin acn Egypt, ac nga fah uniya wounse mukul nukewa sin mwet ac sin kosro, ac nga fah kai god nukewa lun acn Egypt. Nga pa LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Srah fin mutunoa uh pa ac akilenya lohm ma kowos muta loac. Ke nga ac liye srah, nga fah aliki kowos ac fah tia oru kutena ma upa nu suwos ke nga ac kalyei mwet Egypt. ");
INSERT INTO kos_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Kowos fah akfulatye len se inge tuh in sie len in kufwa mutal, in akesmakinye kowos ke ma nga, LEUM GOD, tuh orala. Kowos, ac fwilin tulik nutuwos nukewa fahsru, in akfulatye len se inge nwe tok.” ");
INSERT INTO kos_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","LEUM GOD El fahk, “Kowos fah tia kang kutena bread ma oasr mwe pulol kac ke len itkosr — kang bread ma wangin mwe pulol kac mukena. Kowos fah sisla mwe pulol nukewa in lohm suwos an ke len se meet, tuh inmasrlon len itkosr inge fin oasr sie mwet kang bread orekla ke mwe pulol, mwet sacn ac fah tia sifilpa oaoa mu mwet luk. ");
INSERT INTO kos_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ke len se meet oayapa len se akitkosr kowos fah tukeni in alu. Wangin orekma in orek ke len luo ingan, sayen in akoeyuk mwe mongo. ");
INSERT INTO kos_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Kowos in karinganang ac oru na Kufwen Bread Tia Akpulol se inge, mweyen pa inge len se nga tuh usla sruf lowos liki Egypt. In pacl nukewa fahsru, kowos fah akfulatye len se inge tuh in sie len in orek kufwa. ");
INSERT INTO kos_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mutawauk ke eku in len aksingoul akosr in malem se meet, nwe ke eku in len aklongoul sie, kowos fah tia mongo kutena bread ma orek ke mwe pulol. ");
INSERT INTO kos_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ac fah wangin mwe pulol in koneyukyak in lohm suwos ke lusen len itkosr. Tuh kutena mwet fin mongo ke ma oasr mwe pulol kac, finne mwetsac se ku sie su isusla fin acn uh, ac fah wutiyukla el liki walil lun mwet Israel. ");
INSERT INTO kos_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Kowos fah tia kang ma oasr mwe pulol kac. In lohm suwos nukewa, kowos fah kang bread wangin mwe pulol kac.” ");
INSERT INTO kos_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Na Moses el solani mwet kol nukewa lun Israel ac fahk nu selos, “Kais sie suwos fah sulela soko sheep fusr ku soko nani fusr ac uniya, tuh sou lowos fah ku in akfulatye Kufwen Alukela. ");
INSERT INTO kos_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Eis sie lahn sak hyssop, isongya nu ke srah ma oan in sie pol, ac sang mosrwela sru ac sak lucng ke mutunoa in lohm suwos. Wangin sie suwos fah illa liki lohm suwos nwe ke lututang. ");
INSERT INTO kos_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ke pacl se LEUM GOD El ac fahsr sasla in acn Egypt in uniya mwet Egypt, El ac fah liye srah ke sru ac acn lucng ke mutunoa suwos, ac tia fuhlela Lipufan lun Misa in utyak nu in lohm suwos in unikowosi. ");
INSERT INTO kos_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Kowos ac tulik nutuwos fah akos ma sapkinyuk inge nwe tok. ");
INSERT INTO kos_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Kowos in oru na kufwa se inge ke pacl se kowos ac ilyak nu in facl se su LEUM GOD El wuleot in asot in suwos. ");
INSERT INTO kos_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ke tulik nutuwos ac siyuk suwos, ‘Mea kalmen ma kowos muta oru ke kufwa se inge?’ ");
INSERT INTO kos_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","kowos fah fahk mu, ‘Pa inge mwe kisa lun Alukela in akfulatye LEUM GOD, mweyen El fahsr alukela lohm nukewa sin mwet Israel in acn Egypt ke El tuh uniya mwet Egypt, a El tia unikuti’” Mwet Israel elos epasr ac alu. ");
INSERT INTO kos_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Na elos som ac oru oana ma LEUM GOD El sapkin nu sel Moses ac Aaron. ");
INSERT INTO kos_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ke infulwen fong LEUM GOD El onela wounse mukul nukewa in acn Egypt, mutawauk na ke wounse nutin tokosra, su ac fah mau tokosra tokol, na nwe ke wounse mukul nutin mwet ma kaul in presin. Ma soko isusla oemeet nutin kosro nukewa wi pac anwuki. ");
INSERT INTO kos_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","In fong sac, tokosra, mwet fulat lal, ac mwet Egypt nukewa ngutalik. Oasr tung lulap ngisyak in acn Egypt nufon, mweyen oasr mwet misa in lohm nukewa. ");
INSERT INTO kos_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","In fong sacna, tokosra el solalma Moses ac Aaron ac fahk nu seltal, “Komtal ac mwet Israel nukewa, fahla liki acn sik uh! Fahsrot ac alu nu sin LEUM GOD, oana ke kowos kwafe an. ");
INSERT INTO kos_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Us sheep, nani, ac cow nutuwos ac som. Oayapa pre tuh in akinsewowoyeyuk nga.” ");
INSERT INTO kos_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Mwet Egypt uh salka mwet uh in sulaklak som liki mutunfacl sac. Elos fahk, “Kowos fin tia som, kut nukewa ac misa.” ");
INSERT INTO kos_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ouinge mwet uh nwakla pan in manman lalos ke flao ma wangin mwe pulol kac, nokmani ke nuknuk, ac lippisauk ac us. ");
INSERT INTO kos_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Mwet Israel oru oana Moses el tuh fahk, ac ngisre sin mwet Egypt ke mwe naweyuk gold ac silver, ac oayapa nuknuk. ");
INSERT INTO kos_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","LEUM GOD El oru tuh mwet Egypt in akfulatye mwet uh ac sang nu selos ma elos siyuk. Ouinge mwet Israel elos us mwe kasrup lun mwet Egypt ac som. ");
INSERT INTO kos_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Mwet Israel mukuiyak ac fahsr liki acn Rameses nu Sukkoth. Ac oasr mukul onfoko tausin ma, sayen mutan ac tulik. ");
INSERT INTO kos_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Oasr pac mwetsac puspis welulos som, wi pac un sheep, nani ac cow puspis. ");
INSERT INTO kos_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Elos umunla bread ke flao aryarak ma elos us tuku Egypt me ma wangin mwe akpulal kac, mweyen lillilla elos liki acn Egypt ke tia suyak, pa oru srikla pacl lalos in akoo ma nalos ku sang mwe pulol nu ke flao. ");
INSERT INTO kos_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Mwet Israel uh tuh muta yac angfoko tolngoul in Egypt. ");
INSERT INTO kos_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ke na len safla ke yac angfoko tolngoul, sruf nukewa ke mwet lun LEUM GOD illa liki facl Egypt. ");
INSERT INTO kos_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Fong sac pa LEUM GOD El tuh tawi ac usalosla liki acn Egypt. Na oru mwet Israel elos srela fong se inge ke yac nukewa tuh elos in tawi ac akfulatye nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","LEUM GOD El fahk nu sel Moses ac Aaron, “Pa inge oakwuk ke Kufwen Alukela: Wangin mwetsac fah kang mwe mongo ke Kufwen Alukela, ");
INSERT INTO kos_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","tusruktu kutena mwet kohs su kowos molela ke mani, ku in mongo kac kowos fin kosralosla meet. ");
INSERT INTO kos_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Wangin mwet fahsr, ku mwet orekma su eis molo, ku in mongo kac. ");
INSERT INTO kos_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Mwe mongo nukewa fah mongola in lohm se na ma akoeyuk we uh. In tia utukla nu likinuma, ac nikmet koteya kutena sri ke kosro inge. ");
INSERT INTO kos_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Mwet Israel nukewa fah akfulatye kufwa se inge. ");
INSERT INTO kos_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Fin oasr sie mwetsac mutala inmasrlowos, ac el lungse wi akfulatye Kufwen Alukela in sunakin LEUM GOD, lela el ac mukul nukewa in lohm sel in kosrala meet. Na el ac fah oana sie mwet isusla in facl Israel, ac el fah ku in wi ipeis ke kufwa uh. Mwet ma tia kosrala tia ku in wi mongo kac. ");
INSERT INTO kos_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ma sap inge ma nu sin mwet nukewa su isusla mwet Israel, ac oayapa nu sin mwetsac su mutala inmasrlowos.” ");
INSERT INTO kos_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ouinge mwet Israel nukewa elos oru oana ma LEUM GOD El sapkin nu sel Moses ac Aaron. ");
INSERT INTO kos_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ke len sac LEUM GOD El pwanla sruf nukewa lun Israel liki facl Egypt. ");
INSERT INTO kos_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Srela wounse mukul nukewa nu sik, tuh wounse mukul nutin mwet Israel ac wounse mukul nutin kosro ac fah ma nutik.” ");
INSERT INTO kos_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moses el fahk nu sin mwet uh, “Esam len se inge — len se ma kowos tuh illa liki facl Egypt, acn se ma kowos tuh mwet kohs we. Pa inge len se ma LEUM GOD El uskowosme ke ku lulap lal. Kowos fah tia mongo bread pulol ke len se inge. ");
INSERT INTO kos_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Kowos ac som liki Egypt ke len se inge ke malem se meet, malem in Abib. ");
INSERT INTO kos_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","LEUM GOD El oru sie wulela ku nu sin mwet matu lowos meet ah mu El ac sot acn sin mwet Canaan, mwet Hit, mwet Amor, mwet Hiv, ac mwet Jebus tuh in acn suwos. Ke El ac uskowosla nu in acn sac, sie facl mut ac kasrup fohk we, kowos fah akfulatye len in kufwa se inge ke malem se meet in yac nukewa. ");
INSERT INTO kos_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ke len itkosr kowos fah mongo bread wangin mwe pulol kac, ac ke len se akitkosr kowos fah orek kufwa in akfulatye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ke len itkosr kowos fah tia mongo bread ma orekla ke mwe pulol. Ac fah wangin mwe pulol ku bread pulol in kutena acn in facl suwos. ");
INSERT INTO kos_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ke mutaweyen len in kufwa uh, kowos in aketeya nu sin wen nutuwos lah kowos oru ma inge nukewa ke sripen ma LEUM GOD El oru nu suwos ke kowos illa liki facl Egypt. ");
INSERT INTO kos_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Len in kufwa se inge ac fah sie mwe esmakin, oana mwe esmakin ma kowos kapriya ke pouwos ku ke motonsruwos. Ac fah akesmakye kowos in kalwenina in fahkak ac luti Ma Sap lun LEUM GOD, mweyen LEUM GOD El uskowosme liki facl Egypt ke ku lulap lal. ");
INSERT INTO kos_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Kowos in oru na kufwa se inge ke pacl srisrsrisri nu kac ke kais sie yac. ");
INSERT INTO kos_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“LEUM GOD El ac uskowosme nu in facl sin mwet Canaan, oana El tuh orek wulela ku kac nu suwos ac mwet matu lowos meet ah. Ke El ac sot facl sacn nu suwos, ");
INSERT INTO kos_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","kowos fah srela wounse mukul nukewa nutuwos nu sin LEUM GOD, oayapa wounse mukul nutin kosro nutuwos ac fah ma lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kais soko wounse mukul nutin donkey nutuwos an kowos ac moli ke soko sheep fusr. Kowos fin tia lungse moli, na koteya kwawal. Kowos enenu na in molela wounse mukul nukewa nutuwos uh. ");
INSERT INTO kos_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","In pacl fahsru uh, ke wen nutuwos ac siyuk suwos, ‘Mea kalmen ma inge?’ kowos fah topkolos mu, ‘LEUM GOD El tuh uskutme ke ku lulap lal liki facl Egypt, acn se ma kut tuh mwet kohs we. ");
INSERT INTO kos_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ke pacl se tokosra lun acn Egypt el akupaye nankal ac tia filikutla in som, LEUM GOD El uniya wounse mukul nukewa nutin mwet Egypt, ac wounse mukul nukewa nutin kosro. Pa pwanang kut kisakin wounse mukul nutin kosro uh nu sin LEUM GOD, a kut molela wounse mukul natusr uh. ");
INSERT INTO kos_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ouiya se inge ac fah sie mwe esmakin, oana sie ma kapiryang nu ke pouwos ku nu ke motonsruwos. Ac fah mwe esmakin ke LEUM GOD El tuh uskutme liki Egypt ke ku lulap lal!’” ");
INSERT INTO kos_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Pacl se ke tokosra lun Egypt el fuhlela mwet uh in som, God El tia usalos ke inkanek soko ma ut weacn uh nu Philistia, finne pa fototo uh. God El fahk mu, “Nga tia lungse mwet uh in ekulla nunak lalos ac folok nu Egypt ke elos liye lah elos ac enenu in mweuni mwet lokoalok lalos.” ");
INSERT INTO kos_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ouinge El kololos ke inkanek na loeloes in acn mwesis ma som nu Meoa Srusra. Ke mwet Israel elos illa liki Egypt elos us kufwen mweun natulos. ");
INSERT INTO kos_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses el us srel Joseph welul, oana ke Joseph el tuh arulana wili nu sin mwet Israel ac fahk, “Pacl se God El ac uskowosla liki facl se inge, kowos fah us srik in wi kowos som.” ");
INSERT INTO kos_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Mwet Israel som liki acn Sukkoth ac tulokunak lohm nuknuk selos in acn Etham, sisken yen mwesis. ");
INSERT INTO kos_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ke len, LEUM GOD El fahsr meet lukelos ke sie sru in pukunyeng in akkalemye nu selos acn elos ac ut we, ac ke fong uh El fahsr meet lukelos ke sie sru in e, in sang kalem nu selos. Ouinge elos ku in fahsr ke fong ac ke len. ");
INSERT INTO kos_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Sru in pukunyeng uh fahsr meet lukelos pacl nukewa ke len, ac sru in e uh ke fong. ");
INSERT INTO kos_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Na LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Fahk nu sin mwet Israel elos in folokla ac tulokunak lohm nuknuk selos fototo nu Pi Hahiroth, su oan inmasrlon Migdol ac Meoa Srusra, ac apkuran nu Baal Zephon. ");
INSERT INTO kos_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Tokosra Egypt el ac nunku mu mwet Israel elos tuhlac putakusa, ac yen mwesis uh sruokolosi elos tia ku in sun acn elos fahsr nu we. ");
INSERT INTO kos_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nga ac sifilpa akupaye nankal tokosra, ac el ac fah ukwe kowos. Kutangla luk nu sel tokosra ac un mwet mweun lal uh fah oru mwet uh in akfulatyeyu. Na mwet Egypt fah etu lah nga pa LEUM GOD.” Mwet Israel elos oru oana ma sapkinyuk nu selos. ");
INSERT INTO kos_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ke fwackyang nu sin tokosra lun Egypt lah mwet uh kaingla, el ac mwet fulat lal aolla nunak lalos ac fahk, “Mea se kut oru ah, ku kut fuhlela mwet Israel in kaingla, ac inge wangin mwet kohs in orekma nu sesr!” ");
INSERT INTO kos_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Tokosra el sap in akoeyukla chariot in mweun okoal, ac un mwet mweun lal in wi pac akola. ");
INSERT INTO kos_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","El mukuiyak ke chariot onfoko ma arulana wo, wi pac chariot nukewa saya, ac oasr captain fin chariot inge nukewa. ");
INSERT INTO kos_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","LEUM GOD El akupaye nunkal tokosra, ac el ukwe mwet Israel su pulaik in fahsr ye koko lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Un mwet mweun lun Egypt, wi horse ac chariot nukewa ac mwet kasrusr fac, elos ukwala mwet Israel ac sonolos yen elos aktuktuk we sisken Meoa Srusra, apkuran nu Pi Hahiroth ac Baal Zephon. ");
INSERT INTO kos_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ke mwet Israel liyauk lah tokosra Egypt ac un mwet mweun lal takla tuku in lainulos, elos tuninfongla ac wowoyak nu sin LEUM GOD tuh Elan kasrelos. ");
INSERT INTO kos_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Elos fahk nu sel Moses, “Ya wangin kulyuk in acn Egypt, pa kom uskutme nu yen mwesis kut in misa we? Efu kom ku oru ouinge nu sesr ac uskutme liki acn Egypt? ");
INSERT INTO kos_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ya kut tuh tia fahk nu sum meet liki kut mukuiyak ah lah ma inge ac mau sikyak? Kut tuh fahk kom in tia nunku kacsr — mansis kut in mwet kohs na nu sin mwet Egypt. Ac wona kut in mwet kohs we liki na in misa inge yen mwesis uh.” ");
INSERT INTO kos_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moses el topuk, “Nikmet sangeng! Tu na ku, ac kowos fah liye ma LEUM GOD El ac fah oru in molikowos misenge. Kowos fah tia sifilpa liye mwet Egypt inge. ");
INSERT INTO kos_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","LEUM GOD El ac aol kowos in mweun, ac wanginna ma kowos ac enenu in oru.” ");
INSERT INTO kos_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","LEUM GOD El fahk nu sel Moses, “Efu kom ku kwafe nu sik nga in kasrekowos? Fahk nu sin mwet uh in fahsr nu meet. ");
INSERT INTO kos_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Kolak sikal lom ac asroela nu fin meoa. Kof uh ac fah fahsrelik, ac mwet Israel fah ku in fahsr sasla in meoa fin acn pao. ");
INSERT INTO kos_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nga fah akupaye nankan mwet Egypt tuh elos in ukwekowoswot, ac Inek ac fah pwengpeng ke kutangla luk facl tokosra ac un mwet mweun lal, wi chariot ac mwet kasrusr fac kewa. ");
INSERT INTO kos_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Pacl se nga ac kutangulosla, mwet Egypt fah etu lah nga pa LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Lipufan lun God, su nuna fahsr meet liki un mwet mweun lun Israel, el somla ac fahsr tokolos. Sru in pukunyeng sac mukuila nu ");
INSERT INTO kos_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","inmasrlon mwet Egypt ac mwet Israel. Pukunyeng sac oru lohsr nu sin mwet Egypt, a sang kalem nu sin mwet Israel, pwanang u lulap luo inge koflana apkuraneni nu sie fong nufon se. ");
INSERT INTO kos_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses el asroela paol nu fin meoa, ac LEUM GOD El oru tuh sie eng upa kutulap me in akfahsryelik kof uh. Eng sac tuh ke fong fon se, ac ekulla meoa uh nu ke acn pao. Kof uh fahsrelik ");
INSERT INTO kos_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ac mwet Israel fahsr sasla meoa fin acn pao, ac kof uh tuyak lac lac, sinkaeak acn elos fahsr we. ");
INSERT INTO kos_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Mwet Egypt ukwalos ac alfokfoklana tokolos nu in meoa uh, wi horse ac chariot nukewa, ac elos su kasrusr fac. ");
INSERT INTO kos_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Meet liki na kusrun len sikyak, LEUM GOD El ngeti liki sru in e ac pukunyeng sac nu fin un mwet mweun lun Egypt, ac oru elos arulana sangeng ac fohsak. ");
INSERT INTO kos_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","El oru tuh wheel in chariot okoalos in fulfuli, pwanang upa na elos in kasrusr. Mwet Egypt fahk, “Kut kaingla! LEUM GOD El mweun ke mwet Israel lain kut.” ");
INSERT INTO kos_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","LEUM GOD El fahk nu sel Moses, “Asroela poum nu fin meoa, na kof uh fah folokeni nu fin mwet Egypt ac chariot okoalos ac mwet su muta fac.” ");
INSERT INTO kos_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ouinge Moses el asroela paol nu fin meoa uh, ac ke lenelik kof uh folokeni in oana meet ah. Mwet Egypt elos srike in kaingla liki kof uh, tuh LEUM GOD El siselosyang nu in meoa uh. ");
INSERT INTO kos_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Kof uh folokeni ac afunla chariot, mwet us horse uh, ac un mwet mweun lun Egypt su ukwe mwet Israel nu in meoa uh. Wangin sie selos moul. ");
INSERT INTO kos_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","A mwet Israel fahsr sasla in meoa fin acn pao, ac kof uh tuyak lac lac sinkaeak acn elos fahsr we. ");
INSERT INTO kos_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","LEUM GOD El molela mwet Israel liki mwet Egypt ke len sac, ac mwet Israel elos liye ke elos alapelik oan misa wekof uh. ");
INSERT INTO kos_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ke mwet Israel liye lah yoklana ku su LEUM GOD El oru in sang kutangla mwet Egypt, elos tu na in oela sin LEUM GOD, ac elos lulalfongi LEUM GOD, ac oayapa Moses mwet kulansap lal. ");
INSERT INTO kos_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Na Moses ac mwet Israel onkakin on soko inge nu sin LEUM GOD: “Nga fah on nu sin LEUM GOD mweyen El kutangla ke sie kutangla wolana; El sisla horse uh ac mwet kasrusr fac nu in meoa. ");
INSERT INTO kos_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Leum God El nien molela na ku luk, El pa moliyula. El God luk, ac nga fah kaksakunul. El God lun papa tumuk, ac nga fah onkakin ku fulat lal. ");
INSERT INTO kos_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","LEUM GOD El oana sie mwet mweun, Inel pa LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“El sisla un mwet mweun lun Egypt ac chariot uh nu in meoa, Captain ma sumat emeet elos walomla in Meoa Srusra. ");
INSERT INTO kos_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Meoa loallana afnulosla; Elos tili nwe kapin meoa uh oana eot uh. ");
INSERT INTO kos_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“LEUM GOD, lac poum layot wolana ac kulana, Lac poum layot foklalik mwet lokoalok in ip srisrik. ");
INSERT INTO kos_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ke kutangla kulana, kom siselosla su lain kom; Ke follana lun kasrkusrak lom, kom esukulosyak oana mah pao. ");
INSERT INTO kos_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Kom uk fin meoa uh ac kof uh ilusyukyak fulat nu lucng; Tuyak suwohs oana sinka se; Acn loallana meoa uh kekela. ");
INSERT INTO kos_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mwet lokoalok el fahk, ‘Nga fah ukwalos ac sruokolosi. Nga fah kitalik mwe kasrup lalos ac eis ma nukewa nga lungse; Nga fah fwacla cutlass nutik uh, ac eisla ma lalos nukewa.’ ");
INSERT INTO kos_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tusruktu ke mong sefanna lom, LEUM GOD, na mwet Egypt uh walomla; Elos tili oana lead in kof pulkulak. ");
INSERT INTO kos_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“O LEUM GOD, su inmasrlon god uh oana kom? Su oana kom in mutal wolana lom? Su ku in oru mwenmen ac orekma kulana oana kom? ");
INSERT INTO kos_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Kom asroela lac poum layot, Ac faclu okomla mwet lokoalok lasr. ");
INSERT INTO kos_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ke sripen lungse kawil lom, kom oaru ac pwanla mwet su kom molela; Ke ku lom, kom pwanulos nu ke facl mutal sum. ");
INSERT INTO kos_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Mutanfahl uh lohng kac, ac elos rarrar ke sangeng; Mwet Philistia elos keok ke tuninfong lalos. ");
INSERT INTO kos_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Mwet kol lun Edom elos wi pac tuninfongla; Mwet kulana lun Moab elos rarrar; Ac wanginla pulaik lun mwet Canaan. ");
INSERT INTO kos_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Tuninfong ac fosrnga putati nu faclos. Ke elos liye po kulana lom, O LEUM GOD, Elos koflana mukuikui, oana eot uh, Nwe ke na mwet lom, su kom molela liki kohs, Elos takla fahsr alukelosla. ");
INSERT INTO kos_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Kom usalosme ac oakelosi fineol sum, Acn se su kom, LEUM GOD, sulela in nien muta lom, Sie acn mutal su kom sifacna musaela. ");
INSERT INTO kos_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","LEUM GOD, kom ac fah tokosra nwe tok ma pahtpat.” ");
INSERT INTO kos_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Mwet Israel fahsr sasla in meoa fin acn pao. Tusruktu pacl se chariot lun Egypt wi horse uh ac mwet kasrusr fac tuh som nu in meoa uh, LEUM GOD El folokoneni kof uh nu faclos ac afnulosla. ");
INSERT INTO kos_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Mutan palu Miriam, su ma wial Aaron, el eis tambourine natul, ac mutan nukewa wi fahsr tokol. Elos srital ke tambourine ac onsrosro. ");
INSERT INTO kos_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam el yuk soko on in topkolos: “Kowos on nu sin LEUM GOD, mweyen El kutangla ke sie kutangla wolana. El sisla horse uh ac mwet kasrusr fac nu in meoa.” ");
INSERT INTO kos_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Na Moses el pwanla mwet Israel liki Meoa Srusra nu yen mwesis Shur. Elos fahsr len tolu yen mwesis, ac tiana konauk kof. ");
INSERT INTO kos_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Na elos tuku nu ke sie acn pangpang Marah, tusruktu kof we arulana mwen, oru elos tia ku in nim, pa sripa se sis acn sac pangpang Marah. ");
INSERT INTO kos_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Mwet uh torkaskas nu sel Moses ac siyuk, “Mea kut ac nim uh?” ");
INSERT INTO kos_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moses el insianaung in pre nu sin LEUM GOD, ac LEUM GOD El akkalemye nu sel sie polosak. Na Moses el sisang nu inkof uh, ac kof uh ekla ku in nimnim. In acn Marah LEUM GOD El sang ma sap nu selos tuh elos in moul kac, ac oayapa El srikalos we. ");
INSERT INTO kos_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","El fahk, “Kowos fin arulana porongeyu, ac oru ma suwohs ye mutuk, ac liyaung ma nga sapkin, ac akos kas luk, na nga fah tia kai kowos ke kutena mas upa oana nga tuh oru nu sin mwet Egypt. Nga LEUM GOD, su akkeye kowos.” ");
INSERT INTO kos_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Toko elos tuku nu Elim, acn se ma oasr unon singoul luo ac sak palm itngoul we. Elos tulokunak iwen aktuktuk selos wekof uh. ");
INSERT INTO kos_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Na un mwet Israel nukewa mukuiyak liki acn Elim, ac ke len aksingoul limekosr in malem se akluo tukun elos illa liki Egypt, elos tuku nu ke yen mwesis Sin, su oan inmasrlon Elim ac Sinai. ");
INSERT INTO kos_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ingo yen mwesis elos nukewa torkaskas nu sel Moses ac Aaron ");
INSERT INTO kos_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ac fahk nu seltal, “LEUM GOD El funu unikuti na Egypt lukun wona. Kut lukun mutana mongo ikwa ac bread nwe ke na kut kihpi. A komtal uskutme nu in acn mwesis se inge ac oru kut in misa ke masrinsral.” ");
INSERT INTO kos_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","LEUM GOD El fahk nu sel Moses, “Inge nga ac oru mwe mongo in kahkma inkusrao me nu suwos nukewa. Len nukewa mwet uh ac fah tufoki ac sifani ma fal nu ke len se. In ouiya se inge nga fah srikalos in liye lah elos ac oru oana ma nga sapkin. ");
INSERT INTO kos_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ke len se akonkosr elos in use sunun len luo ac akmolyela.” ");
INSERT INTO kos_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ouinge Moses ac Aaron fahk nu sin mwet Israel nukewa, “Oyeku kowos fah etu lah LEUM GOD pa uskowosme liki Egypt. ");
INSERT INTO kos_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Lututang kowos ac liye kalem wolana su fahkak lah LEUM GOD El oasr yorosr. El lohng torkaskas lowos lainul — aok lainul ac tia lain kut, mweyen kut oru na ma El sapkin nu sesr uh.” ");
INSERT INTO kos_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Na Moses el fahk, “LEUM GOD pa ac sot ikwa nowos ke eku, ac lupan bread ma kowos enenu ke lotutang, tuh El lohng tari lupan torkaskas lowos lainul. Pacl kowos torkaskas lain kut uh, pwayeiya uh kowos torkaskas lain LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moses el fahk nu sel Aaron, “Fahk nu sin sruf nukewa lun mwet Israel elos in tuku ac tu ye mutun LEUM GOD, tuh El lohng tari torkaskas lalos.” ");
INSERT INTO kos_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ke Aaron el kaskas nu sin sruf nukewa, elos ngetla nu yen mwesis, ac in kitin pacl ah na kalem wolana lun LEUM GOD sarmelik in pukunyeng se. ");
INSERT INTO kos_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Na LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nga lohng tari torkaskas lun mwet Israel. Fahk nu selos lah ke eku nukewa ac fah oasr ikwa nalos, ac ke lotutang nukewa elos ac fah eis lupan bread ma elos enenu. Na elos ac fah etu lah nga, LEUM GOD, pa God lalos.” ");
INSERT INTO kos_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ke ekela sie u lulap ke won quail sohkma lucng me, ac afunla acn nukewa ke nien aktuktuk uh, ac ke lotutang aunfong uh nwakla acn mwet uh muta we. ");
INSERT INTO kos_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ac ke aunfong uh wanginla, oasr ma na minini ac fisrasrsrasr se oan infohk uh yen mwesis uh. Arulana fisrasr in mokutkuti. ");
INSERT INTO kos_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ke mwet Israel elos liyauk, elos tiana etu lah mea se, ac elos asiyuki sie sin sie, “Mea se inge?” Moses el fahk nu selos, “Pa inge mwe mongo ma LEUM GOD El sot kowos in mongo kac. ");
INSERT INTO kos_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","LEUM GOD El sapkin tuh kais sie suwos in sifani lupan na ma el enenu — quart luo nu sin kais sie mwet ke sou se.” ");
INSERT INTO kos_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Mwet Israel elos oru ouinge — kutu sifani yohk, ac kutu srik. ");
INSERT INTO kos_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ke elos srikeya, mwet ma sifani yohk uh tia alukela ma fal, ac mwet ma sifani srik tia pac srik liki ma fal. Kais sie selos sifani fal na nu ke lupan enenu lalos. ");
INSERT INTO kos_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moses el fahk nu selos, “Wangin sie mwet fah karingin kutu ma inge nu ke len se tok ah.” ");
INSERT INTO kos_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","A kutu sin mwet uh tia lohngol Moses ac likiya kutu nu ke len tok ah. Ke lotutang tok ah, ma inge sessesla ke ulac ac pusrosrak, na Moses el kasrkusrak selos. ");
INSERT INTO kos_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Lotutang nukewa kais sie mwet sifauk fal nu ke lupa el enenu; ac ke faht uh foli ma lula fin fohk uh kofelik. ");
INSERT INTO kos_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ke len se akonkosr elos sifani mwe mongo pacl luo yohk liki len saya uh — quart akosr nu sin kais sie mwet. Mwet kol ke sruf nukewa lun mwet Israel elos tuku ac srumun ma inge nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","na el fahk nu selos, “LEUM GOD El sapkin tuh lutu sie len in mongla mutal, sriyukla in akfulatyal. Omunla ma kowos lungse umin, ac poeleak ma kowos ke poeli. Kutena ma lula fah orekeni in oan nu lutu.” ");
INSERT INTO kos_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ouinge elos orani ma lula nu ke len tok ah, in oana ma Moses el sapkin, na tiana pusrosrak ku ulauk. ");
INSERT INTO kos_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moses el fahk, “Kang ma inge misenge mweyen misenge len Sabbath, sie len sriyukla nu sin LEUM GOD, ac kowos ac tia konauk kutena mwe mongo likin acn in aktuktuk uh. ");
INSERT INTO kos_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Kowos enenu in sifani mwe mongo ke len onkosr, tusruktu len se akitkosr len in mongla se, na ac fah wangin mongo sifeyukeni ke len sac.” ");
INSERT INTO kos_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ke len se akitkosr kutu sin mwet uh illa in suk mwe mongo, a wangin ma elos konauk. ");
INSERT INTO kos_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Na LEUM GOD El fahk nu sel Moses, “Putaka pacl kowos mwet uh ac srangesr in akos ma nga sapkin uh? ");
INSERT INTO kos_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Esam lah nga, LEUM GOD, sot sie len in mongla nu suwos, ac ke sripa se inge ke len akonkosr nukewa nga fah sot mwe mongo ma fal nu ke len luo. Mwet nukewa in mutana yen el muta we ke len se akitkosr ac tia som liki lohm sel.” ");
INSERT INTO kos_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ouinge mwet uh tia orekma ke len se akitkosr. ");
INSERT INTO kos_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Mwet Israel elos pangon mwe mongo sac manna. Mwe mongo sac oana fita fasrfasr na srisrik se, ac emah uh oana eman flao minini orekla ke honey. ");
INSERT INTO kos_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses el fahk, “LEUM GOD El sapkin tuh kut in karinganang kutu manna inge tuh fwilin tulik natusr in ku in liye mwe mongo ma El sang kite kut yen mwesis ke El uskutme liki acn Egypt.” ");
INSERT INTO kos_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moses el fahk nu sel Aaron, “Eis sie sufa, ac sang luo quart in manna nu loac, na filiya ye mutun LEUM GOD in karinginyukyang nu sin fwil natusr tok uh.” ");
INSERT INTO kos_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Oana ma LEUM GOD El sapkin nu sel Moses, ouinge Aaron el filiya sufa sac mutun Tuptup in Wuleang, tuh in ku in karinginyukyang. ");
INSERT INTO kos_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Mwet Israel elos mongo manna ke yac angngaul, nwe ke elos sun sisken facl Canaan, acn elos oakwuki we. ( ");
INSERT INTO kos_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Mwe srikasrak flao in pacl meet pangpang “omer,” na omer se oana quart luo.) ");
INSERT INTO kos_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Sruf nukewa lun mwet Israel som liki yen mwesis Sin, ac mukuiyak liki sie acn nu ke sie pac acn oana LEUM GOD El sapkin nu selos. Elos tulokunak lohm nuknuk selos Rephidim, tusruk wangin kof in nimnim we. ");
INSERT INTO kos_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Elos torkaskas nu sel Moses ac fahk, “Se kof nimasr.” Moses el topuk, “Efu kowos ku torkaskas nu sik? Efu kowos ku srike LEUM GOD?” ");
INSERT INTO kos_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","A mwet uh arulana malu ac sikalani na in torkaskas nu sel Moses. Elos fahk, “Mea, kom uskutme liki acn Egypt in tuh unikuti, ac tulik natusr ac kosro natusr, ke malu?” ");
INSERT INTO kos_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moses el kwafeang in pre nu sin LEUM GOD ac fahk, “Mea nga ac ku in oru nu sin mwet inge? Elos akola in tungalyu pa inge.” ");
INSERT INTO kos_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","LEUM GOD El fahk nu sel Moses, “Eis kutu sin mwet kol lun Israel wi kom, ac fahla meet liki mwet uh. Us sikal soko ma kom tuh sang sringilya Infacl Nile ah. ");
INSERT INTO kos_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ke kom fah sun sie eot pe eol Sinai, nga fah tu fac ye motom. Puokya eot sac, ac kof uh ac sororma liki, tuh mwet uh in nim kac.” Moses el oru ouinge ye mutun mwet kol lun Israel. ");
INSERT INTO kos_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ac Moses el sang inen acn sac Massah, mweyen mwet Israel elos tuh torkaskas. Acn sac pacna el sang ine Meribah, mweyen mwet uh elos tuh srike LEUM GOD ke elos fahk, “Ya LEUM GOD El wi kut, ku tia?” ");
INSERT INTO kos_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Mwet Amalek tuku ac mweun nu sin mwet Israel in acn Rephidim. ");
INSERT INTO kos_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moses el fahk nu sel Joshua, “Sulela kutu mwet in som ac mweuni mwet Amalek lutu. Nga fah tu fin inging uh ac sruokya sikal soko ma God El sap nga in us uh.” ");
INSERT INTO kos_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Joshua el oru oana Moses el sapkin nu sel, ac illa in mweun lain mwet Amalek, ke Moses, Aaron, ac Hur fanyak nu fin mangon inging uh. ");
INSERT INTO kos_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Lusenna pacl Moses el kolak paol nu lucng, na mwet Israel ah ku, a ke el eisya paol nu ten, na mwet Amalek ah ku. ");
INSERT INTO kos_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Pacl se paol Moses mutawauk in ulla, Aaron ac Hur use sie eot elan muta fac, ac eltal tu siskal lac lac, ac kolak paol kewa nu lucng. Eltal kolak paol nwe ke faht ah tili. ");
INSERT INTO kos_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ouinge Joshua el arulana kutangla mwet Amalek. ");
INSERT INTO kos_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Na LEUM GOD El fahk nu sel Moses, “Simusla luman kutangla se inge tuh in ku in esamyuk. Fahk nu sel Joshua lah nga ac arulana kunausla mwet Amalek uh.” ");
INSERT INTO kos_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moses el etoak loang se ac sang ine, “LEUM GOD El Flag Luk.” ");
INSERT INTO kos_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","El fahk, “Kolak flag lun LEUM GOD nu lucng! LEUM GOD El ac fah mweuni mwet Amalek uh nwe tok!” ");
INSERT INTO kos_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jethro, papa tumun mutan kial Moses ac el mwet tol lun Midian, el tuh lohng ke ma nukewa ma God El oru kacl Moses ac ke mwet lal mwet Israel ke LEUM GOD El kololosla liki acn Egypt. ");
INSERT INTO kos_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ouinge Jethro el tuku nu yorol Moses, ac usalu Zipporah, mutan kial Moses su Moses el tuh folokunulla, ");
INSERT INTO kos_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","oayapa Gershom ac Eliezer, wen luo natul Zipporah. (Moses el tuh fahk, “Nga sie mwetsac in sie pacna facl,” pa oru el sang inen sie wen natul ah Gershom. ");
INSERT INTO kos_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","El tuh oayapa fahk, “God lun papa tumuk El kasreyu moliyula ngan tia anwuki sin tokosra Egypt,” pa oru el sang inen tulik se ngia Eliezer.) ");
INSERT INTO kos_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jethro el tuku, us mutan kial Moses ac wen luo natul nu yen mwesis, yen Moses el mutangan aktuktuk we ke eol mutal. ");
INSERT INTO kos_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","El supwala kas nu sel Moses lah elos ac tuku, ");
INSERT INTO kos_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ouinge Moses el illa som in osun nu sel, pasr ye mutal ac ngok mutal. Eltal siyuk sin sie sin sie lah moul laltal fuka, na eltal utyak nu in lohm nuknuk sel Moses. ");
INSERT INTO kos_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses el fahkang nu sel Jethro ma nukewa ma LEUM GOD El tuh oru nu sin tokosra ac nu sin mwet Egypt in pwanang moliyukla mwet Israel. El oayapa fahk nu sel ke ma upa nukewa ma sikyak nu selos inkanek lalos, ac fuka LEUM GOD El molelosla. ");
INSERT INTO kos_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ke Jethro el lohng tari ma inge nukewa, el engan ");
INSERT INTO kos_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ac fahk, “Kaksakin LEUM GOD, su molikowosla liki mwet Egypt ac tokosra lalos! Kaksakin LEUM GOD, su molela mwet lal liki moul in mwet kohs! ");
INSERT INTO kos_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Inge nga etu lah LEUM GOD El fulat liki god nukewa, mweyen El molela mwet Israel ke pacl mwet Egypt uh oru koluk nu selos ke sripen angyang lun insialos.” ");
INSERT INTO kos_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Na Jethro el use soko kosro in fonna kisakinyuk in mwe kisa firir, wi pac mwe kisa saya in kisakinyuk nu sin LEUM GOD. Ac Aaron ac mwet kol lun Israel nukewa welul som mongo ke mwe mongo mutal inge ye mutun God. ");
INSERT INTO kos_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ke len tok ah Moses el kafofo ke aksuwosye amei inmasrlon mwet uh, su tu ye mutal ke lotutang nwe ke fongeni. ");
INSERT INTO kos_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ke Jethro el liye ma nukewa Moses el oru nu sin mwet uh, el siyuk, “Meawin kom oru nu sin mwet uh inge? Efu ku kom mukena oru ma inge, ke mwet uh tu inge lotutang nwe ke fongeni soano pacl lalos yurum?” ");
INSERT INTO kos_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moses el topuk, “Mweyen mwet uh tuku nu yuruk in siyuk ke ma lungse lun God. ");
INSERT INTO kos_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Pacl se mwet luo ac ameila, eltal ac tuku nu yuruk, ac nga ac wotela lah su seltal pwaye, ac nga aketeya ma sap ac oakwuk lun God nu seltal.” ");
INSERT INTO kos_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Na Jethro el fahk, “Tia pa ingan ma kom ac oru. ");
INSERT INTO kos_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Kom sifacna akmunasyekomla ac oayapa mwet lom inge. Orekma se inge arulana toasr nu sum in mukena oru. ");
INSERT INTO kos_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Inge, porongo kas in kasru luk nu sum, ac God El ac fah wi kom. Fal kom in aol mwet uh ye mutun God, ac sang mwe elya lalos nu sel. ");
INSERT INTO kos_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kom enenu in lotelos ma sap lun God, ac aketeya nu selos lah elos ac moul fuka, ac mea fal elos in oru. ");
INSERT INTO kos_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tusruktu, kom enenu in sulela kutu mwet ma fal ac pah in nunak tuh elos in mwet kol lun mwet uh — mwet kol nu fin tausin, fin foko, fin lumngaul ac fin singoul. Mwet inge elos in mwet sangeng sin God, su ku in lulalfongiyuk ac tia wela eyeinse lun mwet. ");
INSERT INTO kos_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Lela elos in kulansap oana mwet nununku nu sin mwet ma elos leum fac uh ke pacl nukewa. Elos fah use ma upa nukewa nu yurum, tusruktu elos ku in sifacna wotela elya srisrik nukewa uh. Fin ouinge, ac fisrasr nu sum ke elos kasrekom in sruhk orekma toasr kunom inge. ");
INSERT INTO kos_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Kom fin oru ouinge, oana ma God El sapkin, kom ac fah tia totola, ac mwet inge nukewa ac ku in folok nu acn selos ke inse misla mweyen elya lalos uh akwoyeyukla.” ");
INSERT INTO kos_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses el insese nu ke kas in kasru lal Jethro ");
INSERT INTO kos_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ac el sulela mwet ma fal ac pah in nunak sin mwet Israel nukewa tuh elos in mwet kol fin tausin, foko, lumngaul, ac singoul. ");
INSERT INTO kos_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","In pacl sac fahla, mwet inge elos oru orekma lun mwet nununku nu sin mwet Israel. Ma yohk ac upa elos us nu yorol Moses, ac elos sifacna wotela amei srisrik. ");
INSERT INTO kos_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Na Moses el wilkas nu sel Jethro, ac Jethro el folokla nu yen sel ah. ");
INSERT INTO kos_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ke len se meet in malem se aktolu tukun mwet Israel som liki facl Egypt, elos tuku nu yen mwesis Sinai. ");
INSERT INTO kos_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Elos som liki Rephidim, ac utyak nu yen mwesis Sinai, ac tulokunak lohm nuknuk selos sisken Fineol Sinai. ");
INSERT INTO kos_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ac Moses el fanyak nu fineol uh in osun nu sin God. LEUM GOD El pang nu sel fineol uh me, ac fahk nu sel tuh elan fahk nu sin mwet Israel, fwilin tulik natul Jacob: ");
INSERT INTO kos_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Kowos liye ma nga, LEUM GOD, tuh oru nu sin mwet Egypt, ac ke nga tuh srukkowosyak oana sie won eagle el ac tapukak ma fusr natul fin posohksok lal, ac nga uskowosme nu yuruk. ");
INSERT INTO kos_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Kowos fin akosyu ac liyaung wulela luk, kowos ac fah mwet luk sifacna. Faclu nufon ma luk, tuh kowos fah mwet solla luk. ");
INSERT INTO kos_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Kowos sie mutunfacl sriyukla nu sik mukena, ac kowos fah kulansupweyu oana mwet tol. Moses, kom in fahk ma inge nu sin mwet Israel.” ");
INSERT INTO kos_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ouinge Moses el tufokla ac pangoneni mwet kol lun mwet uh nu sie, ac fahk nu selos ma nukewa ma LEUM GOD El sapkin nu sel. ");
INSERT INTO kos_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Na mwet nukewa tukeni topuk, “Kut fah oru ma nukewa ma LEUM GOD El fahk,” ac Moses el fahkak ma inge nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","LEUM GOD El fahk nu sel Moses, “Nga fah tuku nu yurum ke sie pukunyeng matoltol, tuh mwet uh fah ku in lohng ke nga kaskas nu sum, ac elos fah lulalfongi kom ingela nu tok.” Moses el fahk nu sin LEUM GOD top lun mwet uh, ");
INSERT INTO kos_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ac LEUM GOD El fahk nu sel, “Fahla nu yurin mwet uh ac fahk tuh elos in akmutalyalos sifacna misenge ac lutu. Elos enenu in ohlla nuknuk lalos ");
INSERT INTO kos_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ac in akola nu ke len se aktolu. Ke len sac nga fah oatui nu Fineol Sinai, acn se ma mwet nukewa ku in liyeyu we. ");
INSERT INTO kos_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Akilenya sie masrol rauneak eol uh tuh mwet uh in tia alukela, ac fahk nu selos in tia fanyak nu fineol uh, ku tuku fototo nu kac. Kutena mwet fin longya eol uh, el ac fah anwuki. ");
INSERT INTO kos_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ac fah tatngal el ku pisrkiyuk el, ac in wangin poun mwet kahlilya. Ac orek ouinge nu sin kewana, mwet ac kosro — elos enenu na in anwuki. Tusruktu pacl se ukuk uh kas, na mwet uh ku in kalukyang nu ke eol uh.” ");
INSERT INTO kos_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Na Moses el oatume liki fineol uh, ac fahk nu sin mwet uh elos in akmutalyalos ac akola nu ke alu. Ke ma inge elos ohlla nuknuk lalos, ");
INSERT INTO kos_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ac Moses el fahk nu selos, “Kowos in akola nu ke len se aktolu, ac kowos in tia oan yurin mutan ke len tolu inge.” ");
INSERT INTO kos_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ke lotutang in len se aktolu, oasr pulahl ac sarom, ac sie pukunyeng matoltol sikyak fineol uh, ac pusren mwe ukuk na yohk pusra lohngyuk. Mwet nukewa in nien aktuktuk uh elos rarrar ke sangeng. ");
INSERT INTO kos_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Na Moses el pwanulosla liki nien aktuktuk selos in osun nu sin God, ac elos tu pe eol uh. ");
INSERT INTO kos_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Fineol Sinai nufon nukla ke kulasr, mweyen LEUM GOD El oatui nu fac ke e. Kulasr kac fosryak oana kulasr ke funyu lulap, ac eol soko ah nufon arulana kusrusryak. ");
INSERT INTO kos_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Pusren mwe ukuk uh yokyokelik na. Moses el kaskas, ac God El topkol ke pulahl. ");
INSERT INTO kos_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","LEUM GOD El oatume nu fin mangon Fineol Sinai, ac pangnol Moses nu fin mangon eol uh. Moses el fanyak som ");
INSERT INTO kos_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ac LEUM GOD El fahk nu sel, “Oatula ac sensenkakin mwet uh in tia alukela masrol sac in tuku liyeyu. Elos fin oru, pus selos ac misa. ");
INSERT INTO kos_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Finne mwet tol su tuku apkuran nu yuruk, elos enenu in akmutalyalos sifacna, mweyen elos fin tia, nga fah kaelos.” ");
INSERT INTO kos_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moses el fahk nu sin LEUM GOD, “Mwet uh tia ku in fanyak, mweyen kom sapkin nu sesr in akilen mutal lun eol uh, ac filiya sie masrol ah rauneak.” ");
INSERT INTO kos_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","LEUM GOD El topuk, “Oatula ac usalu Aaron elan wi kom folok. Tusruktu mwet tol ac mwet uh fah tiana alukela masrol sac in fanyak nu yuruk. Elos fin oru, nga fah kaelos.” ");
INSERT INTO kos_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ouinge Moses el oatula nu yurin mwet uh ac fahkang ma LEUM GOD El tuh fahk nu sel. ");
INSERT INTO kos_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Na God El kaskas, ac pa inge kas nukewa El tuh fahk: ");
INSERT INTO kos_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Nga LEUM GOD, su kowos alu nu se, su uskowosme liki facl Egypt, acn se ma kowos tuh mwet kohs we. ");
INSERT INTO kos_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Nik kom eis siena god sayuk. ");
INSERT INTO kos_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Nik kom oru nu sum kutena ma sruloala, ku kutena luman ma oan in kusrao lucng, ku ma oan in faclu ten, ku ma oan in kof ye faclu. ");
INSERT INTO kos_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Nik kom sifacna epasr nu selos, ku orekma nu selos; tuh nga LEUM GOD lom, sie God lemta; lahi ma koluk lun papa tuma nu fin tulik natu, nu ke fwil se aktolu ac akakosr selos su srungayu. ");
INSERT INTO kos_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","A oru kulang nu sin siu selos su lungse nga ac liyaung ma sap luk. ");
INSERT INTO kos_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Nik kom aklusrongtenye Inen LEUM GOD lom, tuh LEUM GOD El tia mu wangin mwatan el su aklusrongtenye Inel. ");
INSERT INTO kos_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Esamya len Sabbath, in akmutalye. ");
INSERT INTO kos_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Len onkosr kom in orekma, ac oru orekma lom nukewa. ");
INSERT INTO kos_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","A len se akitkosr Sabbath lun LEUM GOD lom. Nik kom oru kutena orekma — kom, ku wen nutum, ku acn nutum, ku mwet mukul kulansap lom, ku mwet mutan kulansap lom, ku kosro nutum, ku mwetsac lom su muta in kalkal lom. ");
INSERT INTO kos_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Tuh in len onkosr LEUM GOD El orala kusrao, ac faclu, ac meoa, ac ma nukewa loac, a mongla len se akitkosr, tuh ouinge LEUM GOD El akinsewowoye len Sabbath, ac akmutalye. ");
INSERT INTO kos_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Sunakin papa tomom ac nina kiom, tuh len lom in pus fin facl se su LEUM GOD lom El sot nu sum. ");
INSERT INTO kos_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Nik kom akmas. ");
INSERT INTO kos_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Nik kom kosro. ");
INSERT INTO kos_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Nik kom pisrapasr. ");
INSERT INTO kos_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Nik kom kaskas kikiap lain mwet tulan lom. ");
INSERT INTO kos_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Nik kom rapkui lohm sin mwet tulan lom. Nik kom rapkui mutan kien mwet tulan lom, ku mwet mukul kulansap lal, ku mwet mutan kulansap lal, ku cow natul, ku ass natul, ku kutena ma lun mwet tulan lom.” ");
INSERT INTO kos_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ke mwet uh elos lohng pulahl ac pusren mwe ukuk, ac liye sarom, ac ke eol uh fosryak, elos rarrar ke sangeng, ac tu yen loessula. ");
INSERT INTO kos_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Elos fahk nu sel Moses, “Kom fin kaskas nu sesr, kut ac porongo; tusruktu God Elan tia kaskas nu sesr, sahp kut ac misa.” ");
INSERT INTO kos_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ac Moses El fahk nu selos, “Nimet sangeng. God El tuku na in tuh srike kowos, ac oru in yokelik akfulat lowos nu sel, pwanang kowos in tia orekma koluk.” ");
INSERT INTO kos_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Tusruktu mwet uh srakna tu loessula, ac Moses mukena kalukyang nu ke pukunyeng lohsr matoltol uh, yen God El oasr we. ");
INSERT INTO kos_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","LEUM GOD El sapkin nu sel Moses in fahk nu sin mwet Israel, “Kowos liye ke nga, LEUM GOD, kaskas nu suwos inkusrao me. ");
INSERT INTO kos_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Nimet oru kutena kain god ke silver ku gold tuh kowos in alu nu kac in oana ke kowos alu nu sik. ");
INSERT INTO kos_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Oru sie loang ke fohkon acn uh nu sik, ac kisakin sheep ac cow nutuwos fac tuh in mwe kisa firir ac in mwe kisa in akinsewowo. In acn nukewa ma nga srela nu suwos in alu nu sik we, nga ac fah tuku nu yuruwos ac akinsewowoye kowos. ");
INSERT INTO kos_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kowos fin oru sie loang eot nu sik, nimet sang eot tufahlla oru, mweyen ke kowos orekmakin chisel in taflela eot uh, kowos akkolukyela. ");
INSERT INTO kos_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Nimet musai nu sik sie loang ma oasr nien fan nu kac. Kowos fin oru, kowos ac sifacna fahkak koflufol lowos ke kowos ac fan kac. ");
INSERT INTO kos_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Sang oakwuk inge nu sin mwet Israel: ");
INSERT INTO kos_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Kom fin moli sie mukul Hebrew in sie mwet kohs lom, el ac orekma nu sum ke yac onkosr. Ke yac se akitkosr, kom fah aksukosokyalla ac el tia enenu in moli kutena ma nu sum. ");
INSERT INTO kos_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","El fin tia mwet payuk se ke el mutawauk in kulansap nu sum, el fah tia eis mutan kial welul ke pacl se el ac som. Tusruktu el fin payuk tari ke pacl se el mutawauk in kulansupwekom, el ku in us mutan kial welul. ");
INSERT INTO kos_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Mwet kacto lal fin sang sie mutan kial ac mutan sac el oswela wen ku acn, na mutan sac ac tulik natul eltal ma na lun mwet kacto lal, na mukul sac fah mukena som. ");
INSERT INTO kos_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Tusruktu mwet kohs sac fin akkalemye lah el lungse mwet kacto lal ac mutan kial ac tulik natul, ac el tia lungse in sukosokla ");
INSERT INTO kos_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","na mwet kacto lal uh fah usal som nu ke nien alu nu sin God. El ac fah oru tuh mwet kohs sac in tu ke srungul uh ku ke sukan srungul uh, ac putala sie pat ah ke insracl. Na mukul sac fah mwet kohs lal ke lusenna moul lal. ");
INSERT INTO kos_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Sie mukul fin kukakin acn natul tuh elan sie mutan kohs, mutan sac fah tia ku in aksukosokyeyuk oana mukul kohs uh. ");
INSERT INTO kos_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","El fin kukakinyukla nu sin sie mukul su nunku mu el ac payuk sel, a tok el tia insewowo sel, na mukul sac el fah sifilpa kukakunulang nu sin papa tumal. El tia ku in kukakunulla nu sin mwetsac, mweyen mwet kacto sac el tuh tia akfalye wulela lal. ");
INSERT INTO kos_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Sie mukul fin moli sie mutan kohs in sang nu sin wen natul, el enenu in oru nu sel oana sie acn natul. ");
INSERT INTO kos_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Mukul se fin eis sie mutan tuh in mutan akluo kial, el tia enenu in aksrikyela ma el sang nu sin mutan se meet kial ke mwe mongo, nuknuk, ac suwohs lun payuk lal. ");
INSERT INTO kos_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Mukul sac el fin tia akfalye ma tolu inge nu sin mutan se meet ah, el enenu in fuhlella elan sukosokla, ac tia eis kutena mwe moul. ");
INSERT INTO kos_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Kutena mwet su puokya sie mwet ac unilya, el ac fah anwuki. ");
INSERT INTO kos_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Tusruktu fin ma ongla ouiya se, ac tia ma el oru in unilya se, el ku in kaingla nu yen se su nga fah fahkak nu sum, ac el fah ku in muta in misla we. ");
INSERT INTO kos_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Tusruktu mwet se fin foloyak ac uniya sie pac mwet ke el oru na in oaya, na in anwuki el, el finne kaing nwe ke loang luk in molella. ");
INSERT INTO kos_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Kutena mwet su puokya papa tumal ku nina kial fah anwuki. ");
INSERT INTO kos_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Kutena mwet su pisrala sie mwet, finne in kukakunulla ku in sruokilya tuh elan mwet kohs se lal, el ac fah anwuki. ");
INSERT INTO kos_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Kutena mwet su selngawi papa tumal ku nina kial, el ac fah anwuki. ");
INSERT INTO kos_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Fin oasr sie alein ac sie mwet ah srukak eot se tukya mwet se ngia ku fiskilya, ac mwet sac tiana misa a el oanna maskin, ");
INSERT INTO kos_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","na ac wangin mwatan mwet se ma oru ah. Tok ke mwet mas sac tukakek ac fahsr likinuma ke sikal lal, na mwet se ma puokilya ah enenu in moli ke pacl el sisla in mas lal, ac liyalang nwe ke el kwela. ");
INSERT INTO kos_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Sie mwet kacto fin srukak sak soko ac uni mwet kohs lal, mukul ku mutan, ac mwet kohs sac misa na in sac, enenu na in oasr kai nu sin mwet kacto sac. ");
INSERT INTO kos_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Tusruktu mwet kohs sac fin tia misa ke len se ku luo, mwet kacto sac tia enenu in kaiyuk, mweyen mwet kohs sac el oaoa in sie kufwen mwe orekma lun mwet kacto sac. ");
INSERT INTO kos_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Fin oasr mwet anwuk twe sun sie mutan pitutu, oru tulik natul putatla tusruk wangin pac acn musalla ke mutan sac, mwet se ma pwanang ma sikyak nu sel fah moli lupa se na ma mukul tumal el pakiya, fin akkeyeyukla sin mwet nununku. ");
INSERT INTO kos_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Tuh mutan sac fin oasr pac acn musalla kacl, kaiyuk nu kac uh pa moul molin moul, ");
INSERT INTO kos_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","atronmuta molin atronmuta, wihs molin wihs, po molin po, nia molin nia, ");
INSERT INTO kos_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","folla molin folla, kinet molin kinet, futun molin futun. ");
INSERT INTO kos_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Sie mwet kacto fin fiskiya atronmutun mukul ku mutan kohs lal ac pusisla, mwet kacto sac fah aksukosokyela mwet kohs sac in sang moli atronmutal. ");
INSERT INTO kos_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Sie mwet kacto fin fuskela soko wihsen mwet kol lal, mwet kacto sac fah aksukosokye mwet kohs sac in sang moli wihs soko ah. ");
INSERT INTO kos_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Soko cow mukul fin fakisya sie mwet in misa, cow soko enenu in tatngal nwe ke misa, ac ikwal ac tia mongo, ac mwet se natu ah fah tia kaiyuk. ");
INSERT INTO kos_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Tusruk cow mukul soko ah fin pahlana in fakfuk mwet, ac fwackyang nu sin mwet se natu ah a el tiana kalilya in kalkal — na cow soko ah fin fakisya mwet se in misa, el ac fah tungalyuk nwe ke el misa, ac mwet se natu fah anwuki pac. ");
INSERT INTO kos_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Tusruktu, fin wotyang nu sin mwet se natu ah sie lupan mani elan moli in molela moul lal, na el enenu in molela nufonna lupa sac. ");
INSERT INTO kos_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Cow mukul soko uh fin uniya tulik mukul se ku tulik mutan se, ma sap sacna pa ac orekmakinyuk nu kac. ");
INSERT INTO kos_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Cow mukul soko ah fin uniya sie mwet kohs, mukul ku mutan, mwet se natu cow soko ah fah moli nu sin mwet se la mwet kohs sac ke ipin silver tolngoul, ac cow soko ah fah tatngal nwe ke misa. ");
INSERT INTO kos_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Mwet se fin eisla afyuf ke sie luf, ku el fin pikin sie luf ac tia afinya, ac soko cow mukul ku soko donkey putatyang nu loac, ");
INSERT INTO kos_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","el enenu in moli kosro soko ah. El ac fah moli nu sin mwet se natu, ac kosro misa soko ah fah ma lal. ");
INSERT INTO kos_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Fin cow mukul soko nutin mwet se uniya cow mukul soko nutin siena mwet, mukul luo ac fah kukakunla cow soko ma moul ah, ac kitalik mani sac. Eltal fah kitalik pac ikwen cow mukul misa soko ah. ");
INSERT INTO kos_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Tusruktu fin eteyuk lah cow mukul soko inge lungsena anwuk, ac mwet se natu ah tiana kalsalak, el enenu in sang soko cow mukul ma moul in akfalye nu sin mwet se natu cow soko ma misa ah. ");
INSERT INTO kos_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Mwet se fin pisrala soko cow ku soko sheep, ac uniya ku kukakunla, el enenu elan moli cow soko ah ke cow limekosr, ku sheep soko ke sheep akosr. ");
INSERT INTO kos_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Mwet pisrapasr sac el enenu na in akfalye ma el pisrala. Fin wangin yorol, na enenu in kukakinyukla el oana sie mwet kohs, in molela ma el pisrala ah. ");
INSERT INTO kos_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Fin cow soko ku donkey soko ku sheep soko koneyukyak srakna oan yorol tia misa, na el enenu elan moli ma soko ah ke ma lukwa. ");
INSERT INTO kos_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Sie mwet pisrapasr fin sruhu ac anwuki ke el kunauselik sie acn in utyak nu in lohm ke fong, na wangin mwatan mwet se ma unilya ah. El fin anwuki ke len, na ac fah oasr mwatan mwet se ma unilya uh ke akmas. ");
INSERT INTO kos_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Sie mwet fin fuhlela kosro natul in mongo mah ke ima in wheat ku ima in grape lal, ac elos alukela som kangla fokin ima lun sie pacna mwet, mwet se natu kosro ah el enenu in akfalye ma musalla ke fokin ima lal sifacna. ");
INSERT INTO kos_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Sie mwet fin akosak sie e in ima lal, ac e sac sun mah ngeng kulakelik nu in ima lun siena mwet, ac esukak wheat ma kapak ku ma pakpukla ac ilusyukyak, mwet se ma akosak e sac ac fah moli ma nukewa ma musalla. ");
INSERT INTO kos_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Sie mwet fin liyaung mani ku kutu ma saok pac lun siena mwet, ac ma inge pisrapasrla liki lohm sel, mwet se ma pisrala ah fin koneyukyak, el enenu in akfalye ma el pisrala pacl luo. ");
INSERT INTO kos_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Tusruktu mwet se ma pisrala ah fin tiana koneyukyak, mwet se ma liyaung ma saok uh in utuku nu ke nien alu, ac el enenu in fahkak ye mutun God lah tia el pa pisrala ma lun mwet se ngia. ");
INSERT INTO kos_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Fin oasr sie ma tuhlac, ac mwet luo ameila kac fahk mu ma lal pa ma sac, finne ke cow soko, donkey soko, sheep soko, nuknuk, ku kutepacna ma, mwet luo ingan ac tufah utukla nu ke nien alu. Mwet se ma God El akkalemye lah el pa kikiap uh, fah moli pacl luo nu sin mwet se ngia. ");
INSERT INTO kos_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Mwet se fin liyaung donkey nutin siena mwet, ku cow, ku sheep, ku kutepacna kosro, ac kosro soko ah misa ku kineta ku pisrapasrla a wanginna mwet liye, ");
INSERT INTO kos_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","mwet se ma liyaung ac fah som nu ke nien alu, ac fahkak ye mutun God lah el tia pisrala kosro nutin mwet sac. Fin pwaye kosro soko ah tiana pisrapasrla, mwet se natu ac fah falkin kas lun mwet se ngia, na mwet se ngia tia enenu in moli nu sel. ");
INSERT INTO kos_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Tusruktu kosro soko ah fin pisrapasrla, mwet se liyaung ah enenu in moli nu sin mwet se natu ah. ");
INSERT INTO kos_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kosro soko ah fin anwuki sin kosro lemnak, mwet se ma liyaung ah in use monin kosro soko ma anwuki ah in mwe akpwaye. El tia enenu in moli ma kosro lemnak uh uniya uh. ");
INSERT INTO kos_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Mwet se fin ngisrala kosro soko nutin siena mwet, ac kosro soko ah kineta ku misa ke mwet se natu ah el wangin, mwet se ma ngisrala ah enenu in moli. ");
INSERT INTO kos_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Tusruktu ma ingan fin sikyak ke mwet se natu ah oasr uh, na mwet se ma ngisrala ah tia enenu in moli. Fin oasr molin orekmakinyen kosro soko ah, molo se ingan pa ac akfalye uh. ");
INSERT INTO kos_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Sie mukul fin furokla nunak lun sie mutan fusr su soenna etu mwet ac soenna siyukyukla, ac el oan yorol, na mukul sac el enenu in moli nu sin sou lun mutan sac, na payukyak sel. ");
INSERT INTO kos_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Tusruktu papa tumun mutan fusr sac fin tiana insese elan payukyak sel, na mukul sac enenu na in moli nu sin papa sac lupa ma fal ke payukyak nu sin sie mutan su soenna etu mwet. ");
INSERT INTO kos_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Uniya kutena mutan su orek inutnut. ");
INSERT INTO kos_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Uniya kutena mukul su oan yurin soko kosro. ");
INSERT INTO kos_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“In anwuki kutena mwet su orek kisa nu sin kutena god sayuk, LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Nimet oru koluk ku akkeokye sie mwetsac. Esam lah kowos tuh mwetsac in facl Egypt. ");
INSERT INTO kos_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Nimet oru koluk nu sin kutena katinmas ku tulik mukaimtal. ");
INSERT INTO kos_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kowos fin oru, nga LEUM GOD fah porongalos ke elos pang nu sik nga in kasrelos, ");
INSERT INTO kos_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ac nga ac kasrkusrak ac unikowosi ke mweun. Mutan kiowos fah katinmasla, ac tulik nutuwos ac fah wanginla papa tuma. ");
INSERT INTO kos_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Fin oasr mwet luk su sukasrup ngisre kom mani, nimet oru oana mwet ngia oru ac sap elan folokin mani lom wi kap kac. ");
INSERT INTO kos_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kom fin eisla nuknuk lik lun mwet se ma ngusr mani sum in mwe akpwaye lah el ac folokin mani lom an, kom enenu in folokunang nu sel meet liki faht uh tili, ");
INSERT INTO kos_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","mweyen pwayena ma ac sang akfusrfusryal ke fong uh. Mea, oasr pac ma el ac afinilya kac? Ke pacl el ac pang nu sik in kasrel, nga ac porognal mweyen nga pakoten. ");
INSERT INTO kos_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Nik kom kaskas koluk lain God, ac nik kom selngawi sie mwet kol lun mwet lom. ");
INSERT INTO kos_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Ase nu sik mwe sang lowos ke wheat, wain, ac oil in olive ke pacl fal. “Ase nu sik wounse mukul nutuwos. ");
INSERT INTO kos_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ase nu sik wounse ke cow ac sheep nutuwos. Fuhlela tuh wounse mukul ke kosro uh in mutana yurin nina kia ke len itkosr, ac ke len se akoalkosr kisakunma nu sik. ");
INSERT INTO kos_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Kowos mwet luk, ouinge kowos fah tia kang ikwa ke kutena kosro ma kosro lemnak uh uniya, a kowos in sang nun kosro ngalngul. ");
INSERT INTO kos_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Nik kom akyokyelik sramsram tia pwaye, ac nik kom kinauk ma sutuu sang kasru sie mwet oasr mwata. ");
INSERT INTO kos_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Nik kom oru ma sutuu finne pusiyen mwet uh oru, ku welulos kifasla ma suwohs ke pacl in nununku. ");
INSERT INTO kos_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ke kom nununku sie mwet sukasrup, nimet akfisrasrye nununku lom nu sel ke sripen sukasrup lal. ");
INSERT INTO kos_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Kom fin sun cow soko ku donkey soko ma kaingla nutin mwet lokoalok lom, folokunla nu yorol. ");
INSERT INTO kos_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Donkey natul fin ikori ye ma toasr oan facl, nikmet fahlana, a kom in kasrel tulokonak donkey natul nwe ke el sifilpa tuyak. ");
INSERT INTO kos_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Nimet ikol nununku suwohs nu sin sie mwet sukasrup. ");
INSERT INTO kos_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Nik kom oru tukak tia pwaye, ac nik kom eisang sie mwet suwoswos nu ke misa, mweyen nga ac fah lusla kutena mwet su oru kain koluk ouinge. ");
INSERT INTO kos_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Nik kom eis molin eyeinse, tuh molin eyeinse uh akkunye mutun mwet nu ke ma suwohs, ac akkihyela nununku suwohs nu selos su wangin mwata. ");
INSERT INTO kos_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Nik kom oru koluk nu sin sie mwetsac. Kom pula pac tari moul in mwetsac uh, mweyen kom tuh sie mwetsac in facl Egypt meet. ");
INSERT INTO kos_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Yac onkosr kom in yoki acn sum ac eisani fahko kac. ");
INSERT INTO kos_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","A ke yac se akitkosr lela acn sum in mongla — kom fah tia yoki ac tia pac kosrani. Lela mwet sukasrup uh in kang kutena ma kap we, ac kosro inima uh in kang ma lula. Oru oapana ke ima in grape lowos ac sak olive sunowos. ");
INSERT INTO kos_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Kom in orekma len onkosr ke wik se, tusruk nimet oru kutena orekma ke len akitkosr, tuh mwet kohs lowos ac mwetsac su orekma nu suwos, ac finne kosro nutuwos, in ku in mongla. ");
INSERT INTO kos_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Porongo ma nukewa ma nga, LEUM GOD, fahk tari nu sum. Nik kom pre nu sin god saya. Finne inelos, kom in tia pac fahk. ");
INSERT INTO kos_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Kowos in tukeni ac oru kufwa lulap tolu ke yac se in akfulatyeyu. ");
INSERT INTO kos_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","In malem Abib, malem se ma kowos illa liki Egypt, kowos in akfulatye Kufwen Bread Tia Akpulol ke ouiya ma nga sapkin tari nu suwos. Nimet kang kutena bread orekla ke mwe pulol inmasrlon len itkosr lun kufwa se inge. Nimet tuku in alu nu sik ke wangin mwe sang inpouwos. ");
INSERT INTO kos_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Akfulatye Kufwen Kosrani ke kowos mutawauk in kosrani wheat sunowos. “Akfulatye Kufwen Iwen Aktuktuk ke saflaiyen pacl in kosrani, ke kowos telani fokin ima in grape ac fokinsak olive sunowos. ");
INSERT INTO kos_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","In yac nukewa ke pacl in akfulatye kufwa lulap tolu inge, mukul Israel nukewa in tuku alu nu sik, LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Nik kom sang bread ma orek ke mwe pulol ke kom kisakin soko kosro nu sik. Kiris ke kosro kisakinyuk nu sik ke pacl in kufwa inge, fah tia oan nu ke lotutang tok ah. ");
INSERT INTO kos_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ke kais sie yac, kom fah use nu in lohm sin LEUM GOD lom, fahko ma wo emeet ke kosrani se meet lom. “Nik kom poeli soko sheep fusr, ku nani fusr, ke sronin titi lun nina kia. ");
INSERT INTO kos_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Nga ac supwala sie lipufan in fahsr meet liki kowos, in karingin kowos ke fufahsryesr lowos, ac in uskowosla nu ke acn se su nga akoela. ");
INSERT INTO kos_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Lohang nu sel ac aksol. Nimet lainul, mweyen nga pa supwalot, ac kowos fin lainul el ac fah tia nunak munas nu suwos kac. ");
INSERT INTO kos_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Tusruktu kowos fin aksol ac oru ma nukewa nga sapkin, nga fah mweun lain mwet lokoalok lowos nukewa. ");
INSERT INTO kos_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Lipufan luk ac fah fahsr meet liki kowos ac us kowos nu in facl sin mwet Amor, mwet Hit, mwet Periz, mwet Canaan, mwet Hiv, ac mwet Jebus, ac nga fah kunauselosla. ");
INSERT INTO kos_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Nik kowos epasr nu sin god lalos ku alu nu selos, ac nik kowos etai ouiyen alu lalos. Kunauselik god lalos ac fukulya loang eot mutal lalos. ");
INSERT INTO kos_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Kowos fin alu nu sik, LEUM GOD lowos, nga ac fah akinsewowoye kowos ke mwe mongo ac kof ac eisla mas nukewa lowos liki kowos. ");
INSERT INTO kos_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ac fah wangin tulik putatla nutin mutan pitutu, ac ac fah wangin pac mutan talap in facl suwos. Nga ac fah akloesye moul lowos. ");
INSERT INTO kos_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Nga fah aksangengalos su lain kowos, ac mwet su kowos mweuni nga fah akfohsyalosyak. Nga fah oru mwet lokoalok lowos nukewa in forla ac kaing liki kowos. ");
INSERT INTO kos_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nga fah oru tuh mwet lokoalok lowos — su mwet Hiv, mwet Canaan, ac mwet Hit — in fosrngalana, ac nga fah ukwalosyak ke kowos fahsr in utyak nu in facl selos. ");
INSERT INTO kos_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nga ac fah tia luselosla ke pulan yac se, mweyen nga fin oru ouinge, na acn uh ac mwesisla, ac kosro lemnak uh ac arulana pusla, na kowos tia ku in lain. ");
INSERT INTO kos_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nga fah kais kutu lusla mwet lokoalok lowos, nwe ke kowos faseni in ku in eisla acn selos. ");
INSERT INTO kos_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Nga fah oru masrol lun acn suwos in mutawauk ke Meoa Srusra fahla nwe ke Meoa Mediteranean, ac oayapa yen mwesis lac nwe ke Infacl Euphrates. Nga fah sot mwet in facl sac nu inpouwos, ac kowos fah luselosla ke pacl kowos utyak nu we. ");
INSERT INTO kos_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Nik kowos oru kutena oakwuk ku yorolos, ku yurin god lalos. ");
INSERT INTO kos_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Nik kowos lela mwet ingan in muta in facl suwos. Kowos fin lela, elos ac oru kowos in orekma koluk lainyu. Kowos fin alu nu sin god lalos, ac fah oana sie sruhf nu suwos.” ");
INSERT INTO kos_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Na LEUM GOD El fahk nu sel Moses, “Kom ac Aaron, Nadab, Abihu, ac itngoul sin mwet kol lun Israel, fanyak fineol uh nu yuruk, ac ke kowos srakna fahsr loes, kowos in pasrla ac alu. ");
INSERT INTO kos_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moses, kom mukena in tuku apkuran nu yuruk, ac mwet wi kom ingan in tia tuku apkuran nu yuruk. Ac mwet Israel nukewa saya in tiana fanyak nu fineol uh.” ");
INSERT INTO kos_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses el som ac fahkang nu sin mwet uh ma sap nukewa lun LEUM GOD ac kas lal nukewa, ac mwet nukewa tukeni topuk, “Kut ac fah oru ma nukewa ma LEUM GOD El fahk.” ");
INSERT INTO kos_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moses el simusla ma sap nukewa lun LEUM GOD. Toangna in lotu tok ah, el etoak sie loang pe eol uh ac tulokunak eot singoul luo, kais sie nu ke sruf singoul luo lun Israel. ");
INSERT INTO kos_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Na el supwala kutu mukul fusr, ac elos esukak mwe kisa firir nu sin LEUM GOD, ac kisakunla kutu cow tuh in mwe kisa in akinsewowo. ");
INSERT INTO kos_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses el eisla tafu srahn cow ac sang nu in kutu pesin; ac tafu el sang osralik loang uh. ");
INSERT INTO kos_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Na el eis ma simusla ke wuleang lun LEUM GOD, ac riti nu sin mwet uh ke pusra lulap. Elos fahk, “Kut fah akos LEUM GOD ac oru ma nukewa ma El sapkin.” ");
INSERT INTO kos_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Na Moses el eis srah in pesin uh ac osrela mwet uh kac. El fahk, “Pa inge srah su akkeyala wuleang su LEUM GOD El orala yuruwos ke El sot ma sap inge nukewa.” ");
INSERT INTO kos_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moses, Aaron, Nadab, Abihu ac mwet kol itngoul lun mwet Israel, elos fanyak nu fineol uh ");
INSERT INTO kos_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ac elos liye God lun Israel. Ye nial oasr sie ma fwel ac tupasrpasr su oana in orekla ke eot sapphire, arulana kalem ac folfol oana acn inkusrao. ");
INSERT INTO kos_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Mwet kol inge ne liye God, a wangin ma upa El oru nu selos. Elos tukeni mongo ac nim. ");
INSERT INTO kos_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","LEUM GOD El fahk nu sel Moses, “Fanyak nu fineol uh nu yuruk, ac pacl se kom muta inge, nga ac sot luo eot tupasrpasr, su ma sap nukewa simla fac. Nga simusla ma inge tuh in mwe luti nu sin mwet uh.” ");
INSERT INTO kos_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moses ac Joshua, mwet kasru lal, eltal akola, ac Moses el mutawauk in fanyak nu fineol mutal. ");
INSERT INTO kos_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Moses el fahk nu sin mwet kol uh, “Soanekut ke acn in aktuktuk uh nwe ke kut foloko. Aaron ac Hur ac muta yuruwos. Kutena mwet su oasr alein yoro, ku in som nu yoroltal in aksuwosyela.” ");
INSERT INTO kos_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Na Moses el fanyak nu Fineol Sinai, ac pukunyeng se afunla. ");
INSERT INTO kos_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Kalem wolana lun LEUM GOD oan Fineol Sinai, ac pukunyeng sac afunla fineol uh ke len onkosr. Ke len se akitkosr LEUM GOD El pang nu sel Moses liki pukunyeng sac. ");
INSERT INTO kos_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ke kalem wolana lun LEUM GOD sikyak in pacl sac, oana sie e firirelik fin mangon eol uh ke mwet Israel elos liye. ");
INSERT INTO kos_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moses el fanyak ke eol uh nu yen pukunyeng sac oan we. Na el muta ingo len angngaul ac fong angngaul. ");
INSERT INTO kos_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Fahk nu sin mwet Israel elos in orek mwe sang nu sik. Eis ma nukewa ma mwet uh insewowo in sang. ");
INSERT INTO kos_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Mwe sang inge ku in gold, silver, ac osra bronze; ");
INSERT INTO kos_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","linen srik eoa; unen sheep ma tuhn folfol, sroninmutuk, ac srusra; nuknuk orekla ke unen nani; ");
INSERT INTO kos_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kulun sheep mukul ngosla srusra; kulun kosro fisrasrsrasr; sak acacia; ");
INSERT INTO kos_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","oil nu ke lam; mwe keng nu ke oil in akmusra ac nu ke mwe kisa keng; ");
INSERT INTO kos_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","eot onyx ac eot saok pac saya, in sang nawela nuknuk lun Mwet Tol Fulat su pangpang ephod, oayapa nuknuk mwe loeyuk iniwa se. ");
INSERT INTO kos_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Mwet uh fah oru sie Lohm Nuknuk Mutal nu sik, tuh nga in ku in muta inmasrlolos. ");
INSERT INTO kos_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Orala lohm sac, wi koanon lohm an, in fal nu ke lemlem su nga ac fah akkalemye nu sum. ");
INSERT INTO kos_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Orala sie tuptup ke sak acacia, inch angngaul limekosr lusa, inch longoul itkosr sralap ac longoul itkosr fulata. ");
INSERT INTO kos_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Nokomla acn loac ac lik ke gold nasnas, ac kom fah orala sie patun ke gold rauneak. ");
INSERT INTO kos_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Orala akosr ring in tou ke gold, ac oakiya nu ke nia akosr kac, ring luo ke kais sie siska lac lac. ");
INSERT INTO kos_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Orala srenenu lukwa ke sak acacia ac nokomla ke gold ");
INSERT INTO kos_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ac isongang nu ke ring ma oan sisken Tuptup an. ");
INSERT INTO kos_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Srenenu inge fah oanna in ring uh, ac in tiana itukla liki. ");
INSERT INTO kos_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Na filiya in Tuptup uh eot tupasrpasr luo ma nga ac sot nu sum, su ma sap uh simla oan fac. ");
INSERT INTO kos_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Orala sie mwe afyuf ke gold nasnas, inch angngaul limekosr lusa ac longoul itkosr sralap. ");
INSERT INTO kos_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Orala luo cherub ke gold tuktuki, ");
INSERT INTO kos_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","sie in oan tafu ac ma se ngia oan tafu. Cherub inge in orekla ipin na mwe afyuf sac ");
INSERT INTO kos_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ac in ngetani nu sie fac, ac posohksok laltal in elakelik ac afinya mwe afyuf sac. ");
INSERT INTO kos_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Filiya eot tupasrpasr luo uh in Tuptup uh, ac sang mwe afyuf sac nu fac. ");
INSERT INTO kos_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Nga ac fah osun nu sum ke acn se inmasrlon cherub luo ah ma muta lucng liki mwe afyuf sac, na liki acn se ingan nga ac fah sot nu sum ma sap nukewa luk nu sin mwet Israel. ");
INSERT INTO kos_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Orala sie tepu ke sak acacia, inch tolngoul onkosr lusa, inch singoul oalkosr sralap ac inch longoul itkosr fulata. ");
INSERT INTO kos_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Nokomla ke gold nasnas ac sang sie patun gold rauneak. ");
INSERT INTO kos_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Kuhlasak fac ah ke sie patun inch tolu fulata, ac sie mwe naweyuk gold in oan fin patun sac. ");
INSERT INTO kos_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Orala akosr ring in tou ke gold, ac oakeang nu ke sruwasrik akosr, yen ma nia uh oan we. ");
INSERT INTO kos_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ring ma srumasriyen srenenu ke tepu uh in oakwuki apkuran nu ke patun se fin tepu uh. ");
INSERT INTO kos_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Srenenu nu kac in orek ke sak acacia, ac nokomla ke gold. ");
INSERT INTO kos_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Orala plate, cup, sufa, ac pol in orekmakinyuk ke pacl in kisa wain. Ma inge nukewa in orekla ke gold nasnas. ");
INSERT INTO kos_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Tepu sac fah filiyuki mutun Tuptup in Wuleang, ac bread mutal ma kisakinyuk nu sik fah oan fin tepu uh pacl nukewa. ");
INSERT INTO kos_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Orala sie nien lam ke gold nasnas, in oana luman sak soko. Orala srupo an ac kapu an ke gold tuktuki. Ipin gold se na ma sang orala srupo ah in pa sang orala ros motul ac ros fareng, mwe naweyuk nu kac. ");
INSERT INTO kos_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Orala lah onkosr kac — tolu ke la, tolu ke la. ");
INSERT INTO kos_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kais sie lah onkosr inge fah oasr ros in yun tolu kac, ma oana ros almond. Oru kutu in ros motul ac kutu ros fareng. ");
INSERT INTO kos_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Srupo ke nien lam uh in oasr ros in yun akosr kac ma oana luman ros almond, kutu in ros motul ac kutu in ros fareng. ");
INSERT INTO kos_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Enenu in oasr sie ros motul ke yen kais luo lah inge kupasreni nu ke srupo soko ah. ");
INSERT INTO kos_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Nien lam uh, wi ros motul mwe naweyuk, ac lah kac ah — nufonna in orek ke ipin gold nasnas sefanna ma tuktuki. ");
INSERT INTO kos_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Orala lam itkosr nu ke nien lam uh, ac oakiya in tolak acn meet. ");
INSERT INTO kos_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Oru mwe kosrkosr wik ac ahlu nu kac ke gold nasnas. ");
INSERT INTO kos_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Paun itngoul limekosr ke gold nasnas pa in sang orala nien lam uh wi kufwa inge nukewa. ");
INSERT INTO kos_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Karinganang in orala fal nu ke lemlem su nga fahkak nu sum fineol uh. ");
INSERT INTO kos_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Orala acn loac ke Lohm Nuknuk Mutal, nien muta luk, ke ipin nuknuk linen srik eoa singoul, otwot ke unen sheep ma ngosla folfol, sroninmutuk ac srusra. Yunela ke mwe akul in luman cherub uh. ");
INSERT INTO kos_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Kais sie ipin nuknuk inge in oana sie lupa — yact singoul akosr lusa ac yact luo sralap. ");
INSERT INTO kos_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Twani ip limekosr nu sie, ac oru oapana nu ke ip limekosr ngia. ");
INSERT INTO kos_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Orala mwe sremsrem ke nuknuk folfol, sang nu ke ipin nuknuk se ma oan e siska ke kais sie nuknuk in lisrlisr inge. ");
INSERT INTO kos_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Sang mwe sremsrem lumngaul nu ke ip se meet ke nuknuk in lisrlisr se meet. Sifilpa sang mwe sremsrem lumngaul oapana inge nu ke ip se safla ke nuknuk in lisrlisr se akluo. ");
INSERT INTO kos_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Orala mwe sruh lumngaul ke gold in sang kapsreni nuknuk in lisrlisr luo inge nu sie. ");
INSERT INTO kos_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Orala sie mwe susu in sunya ke ipin nuknuk singoul sie orekla ke unen nani, in sang afinya Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Orala nufonna in lupa sefanna, yact singoul limekosr lusa ac yact luo sralapa. ");
INSERT INTO kos_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Twani ip limekosr nu sie, oayapa twani ip onkosr lula nu sie. Lumwani ip se akonkosr ah in oan ke mutun Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Sang lumngaul mwe sremsrem nu ke siska se ke ip se ma oan safla ke lisrlisr se meet ah, ac lumngaul pac ke sisken ip fon se ngia. ");
INSERT INTO kos_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Orala lumngaul mwe sruh ke bronze, ac sang nu ke mwe sremsrem kac uh, in orani nuknuk in lisrlisr luo an nu sie. ");
INSERT INTO kos_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Sripisrya tafun ip se ma lula ke acn tok ke Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Tafun yact ma yolyak ke kais sie siska inge ac fah sripsripyak in atla afinya sisken Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Orala luo pac afyuf an, sie ke kulun sheep mukul ngosla srusra, ac ma se ngia ke kulun kosro fisrasrsrasr, tuh in mwe afyuf lik ah. ");
INSERT INTO kos_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Orala frem nu ke Lohm Nuknuk sac ke sak acacia. ");
INSERT INTO kos_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kais sie frem in oasr fit singoul limekosr lusa, ac longoul itkosr inch sralap, ");
INSERT INTO kos_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ac in oasr acn kihlyak luo ke kais sie frem tuh frem uh in kupasreni nu sie. Frem nukewa in oasr kihl luo kac. ");
INSERT INTO kos_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Orala frem longoul nu layen eir, ");
INSERT INTO kos_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ac angngaul kapin frem ma orekla ke silver in oan ye frem inge; kapin frem luo nu ke frem se. ");
INSERT INTO kos_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Orala frem longoul nu layen epang ke Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ac angngaul kapin frem, kais luo ye frem se. ");
INSERT INTO kos_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Orala frem onkosr nu ke layen tok ke Lohm Nuknuk Mutal, layen nu roto, ");
INSERT INTO kos_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ac frem luo nu ke insruwasrik uh. ");
INSERT INTO kos_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Frem nu insruwasrik inge in kupasreni tafunyen ten ac sruokeni tenyak na nwe lucng. Frem luo ma orala insruwasrik luo ah enenu na in orek ouinge. ");
INSERT INTO kos_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ke ma inge ac oasr frem oalkosr wi kapin frem silver singoul onkosr, kais luo ye kais sie frem. ");
INSERT INTO kos_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Orala singoul limekosr sukan brace ke sak acacia — ma limekosr nu ke frem ke lac Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ac limekosr nu ke frem ke layen ngia, ac limekosr nu ke frem siska nu roto, ke acn tok ke lohm uh. ");
INSERT INTO kos_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Soko sukan brace ma ac oan infulwen frem uh, in oan ke sie siska fahla nwe ke siska se ngia. ");
INSERT INTO kos_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Afunla frem uh ke gold, ac oakeang ring gold lulap nu kac in sruok sukan brace uh, ma ac nukumyukla pac ke gold. ");
INSERT INTO kos_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tulokunak Lohm Nuknuk Mutal fal nu ke lemlem ma nga fahkot nu sum fineol uh. ");
INSERT INTO kos_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Orala sie mwe lisrlisr ke ipin nuknuk linen srik eoa, otwot ke unen sheep ma ngosla folfol, sroninmutuk ac srusra. Yuni ac akilenya ke luman cherub uh. ");
INSERT INTO kos_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Srupusrak ke sru in acacia akosr ma nukumyukla ke gold ac oakwukyang mwe sruh nu kac, ac oakiya ke kapin sru silver akosr. ");
INSERT INTO kos_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Likiya mwe lisrlisr se inge ye tak in mwe sruh ke ma sang afin Lohm Nuknuk Mutal uh. Tuptup in Wuleang, su eot tupasrpasr luo oan loac, kom fah filiya tukun lisrlisr uh. Lisrlisr se inge fah sraclik Acn Mutal liki Acn Mutal Na Mutal. ");
INSERT INTO kos_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Sang mwe afyuf nu fin Tuptup in Wuleang, su oan in Acn Mutal Na Mutal. ");
INSERT INTO kos_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Likin Acn Mutal Na Mutal kom fah likiya tepu sac in oan layen epang in Lohm Nuknuk uh, ac likiya nien lam uh in oan layen eir. ");
INSERT INTO kos_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Nu ke acn in utyak lun Lohm Nuknuk Mutal, oru sie lisrlisr ke nuknuk linen srik eoa wi turet ke unen sheep ma folfol, sroninmutuk ac srusra, ac yunela ke naweyuk lun akul. ");
INSERT INTO kos_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Nu ke mwe lisrlisr se inge orala sru limekosr ke sak acacia nukla ke gold, ac oakeang mwe sruh gold nu kac. Orala kapin sru limekosr nu ke sru inge. ");
INSERT INTO kos_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Orala sie loang ke sak acacia. Oru in maspang, fit itkosr tafu lusa, ac fit itkosr tafu sralap, ac in tufah fit akosr tafu fulata. ");
INSERT INTO kos_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Orala koac in tuyak fin sruwasrik akosr ah. Koac inge in orekla ke sak se na ma sang orala loang uh, ac ma inge nukewa in nukumyukla ke osra bronze. ");
INSERT INTO kos_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Orala pan mwe nein apat mosroal, ac orala saful, pesin, fork, ac pan in neinyuk mulut firir. Kufwa inge nukewa in orekla ke bronze. ");
INSERT INTO kos_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Orala sie mwe liklik ke bronze, ac sang akosr ring in utuk, ma orekla pac ke bronze, ac oakiya ke sruwasrik akosr ah. ");
INSERT INTO kos_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Filiya mwe liklik sac in oan loac tafunyen ten ke loang uh. ");
INSERT INTO kos_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Orala srenenu ke sak acacia, ac nokomla ke bronze, ");
INSERT INTO kos_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ac isongang nu in ring siska lac lac ke loang uh ke pacl ac utuk uh. ");
INSERT INTO kos_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Orala loang uh ke ipinsak, ac acn loac in oalal, fal nu ke lemlem nga akkalemye nu sum fineol uh. ");
INSERT INTO kos_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Nu ke Lohm Nuknuk Mutal sik, orala sie kalkal in lisrlisr ke nuknuk linen srik eoa. Mwe lisrlisr nu ke layen nu eir in tufah yact lumngaul lusa, ");
INSERT INTO kos_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","sikulyukyak ke sru bronze longoul, ma tuyak luin kapin sru bronze longoul, wi mwe sruh ac osra orekla ke silver. ");
INSERT INTO kos_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Oru oapana nu ke layen epang ke kalkal uh. ");
INSERT INTO kos_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Layen nu roto in oasr mwe lisrlisr yact longoul limekosr lusa, wi sru singoul ac kapin sru singoul. ");
INSERT INTO kos_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Layen nu kutulap, su nien utyak uh oan we, kalkal we in oayapa yact longoul limekosr lusa. ");
INSERT INTO kos_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Mwe lisrlisr ke la sisken nien utyak uh in tufah yact itkosr tafu, wi sru tolkwe ac kapin sru tolu. ");
INSERT INTO kos_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ac layen ngia in oapana, yact itkosr tafu ke lisrlisr, wi sru tolkwe ac kapin sru tolu. ");
INSERT INTO kos_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Nu ke acn in utyak an sifacna, in tufah sie lisrlisr yact singoul lusa orekla ke linen srik eoa, otwotla ke unen sheep ngosla folfol, sroninmutuk ac srusra, ac in naweyukla ke mwe akul. In tufah sripsripyak ke sru akosr luin kapin sru akosr. ");
INSERT INTO kos_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Sru nukewa ke kalkal uh in fah kupasreni ke osra silver, ac mwe sruh kac fah orekla ke silver, ac kapin sru nu kac orekla ke bronze. ");
INSERT INTO kos_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kalkal uh fah yact lumngaul lusa, ac yact longoul limekosr sralapa, ac yact luo tafu fulata. Mwe lisrlisr in tufah orek ke linen srik eoa, ac kapin sru uh in orek ke bronze. ");
INSERT INTO kos_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Kufwen mwe orekma nukewa ma orekmakinyuk nu ke Lohm Nuknuk Mutal, ac kwi nukewa nu ke Lohm Nuknuk ac nu ke kalkal ma rauneak, in tufah orekla ke bronze. ");
INSERT INTO kos_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Sapkin nu sin mwet Israel in use nu yurum oil in olive wo ma aknasnasyeyukla tari, tuh lam uh in ku in firir ke fong nukewa. ");
INSERT INTO kos_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaron ac wen natul pa in akoela lam uh in Lohm Nuknuk sik likin mwe lisrlisr su oan mutun Tuptup in Wuleang. Lam uh in firir ye mutuk ke eku nwe ke lotutang. Ma sap se inge ac tufah karinginyuk nwe tok sin mwet Israel ac fwilin tulik natulos. ");
INSERT INTO kos_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Solalma Aaron, tamulel lom, ac wen natul — Nadab, Abihu, Eleazar ac Ithamar. Srelosla liki mwet Israel uh tuh elos in kulansupweyu ke orekma lun mwet tol. ");
INSERT INTO kos_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Orala nuknuk in mwet tol lal Aaron, tamulel lom, ma in sang akkalemye mutal ac wolana lun orekma lun mwet tol. ");
INSERT INTO kos_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Pangoneni mwet pah in orekma nukewa su nga sang etauk nu se, ac fahk nu selos in orala nuknuk lal Aaron, tuh elan sriyukla nu sik nu ke kunokon lun sie mwet tol. ");
INSERT INTO kos_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Fahk nu selos in orala sie mwe loeyuk iniwa, sie nuknuk lun mwet tol pangpang ephod, sie nuknuk loeloes, sie nuknuk loac yunla ke mwe akul, sie nuknuk in lohl insuf, ac sie mwe lohl infulwa. Elos in orala nuknuk in mwet tol inge lal Aaron, tamulel lom, ac wen natul, tuh elos in kulansupweyu ke kunokon lun mwet tol. ");
INSERT INTO kos_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Mwet usrnguk in orekma inge fah orekmakin unen sheep ngosla folfol, sroninmutuk ac srusra, turet gold, ac linen srik eoa. ");
INSERT INTO kos_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Elos in orala nuknuk ephod sac ke unen sheep ma tuhn folfol, sroninmutuk ac srusra, turet gold, ac linen srik eoa, naweyuk ke mwe akul. ");
INSERT INTO kos_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Sang luo mwe sruh nu finpisa in sruokani siska luo an. ");
INSERT INTO kos_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Sie mwe lohl infulwa ma naweyukla arulana wo orekla pacna ke mwe yun inge in tufah itukyang nu ke ephod sac in orala lumah sefanna. ");
INSERT INTO kos_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Eis luo eot onyx ac kihlisya inen wen singoul luo natul Jacob fac, ");
INSERT INTO kos_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","fal nu ke takin matwalos — ine onkosr fin sie eot an, ac onkosr fin sie. ");
INSERT INTO kos_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Sang sie mwet pisrla ke kihlisyen mwe naweyuk in oru kihl ke inen wen natul Jacob fin eot luo an, ac sang nu ke frem ma orekla ke gold. ");
INSERT INTO kos_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Filiya ke mwe sruh finpisa ke nuknuk ephod sac in mwe esmakinyen sruf singoul luo lun Israel. In ouiya se inge Aaron el ac fah us inelos finpisal, tuh nga, LEUM GOD, fah esam mwet luk pacl nukewa. ");
INSERT INTO kos_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Orala luo pac frem gold ");
INSERT INTO kos_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ac lukwa sein ke gold nasnas, pirakla oana luman fu, ac kapsreni nu ke frem luo ah. ");
INSERT INTO kos_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Orala sie mwe loeyuk iniwa lun Mwet Tol Fulat, elan ku in orekmakin in akilen ma lungse lun God. In orekla pacna ke kain mwe naweyuk ma sang oru nuknuk ephod lun mwet tol, ac in luman mwe akul sac pacna. ");
INSERT INTO kos_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Lumwani pacl se in maspangla — inch eu lusa ac inch eu sralap. ");
INSERT INTO kos_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Filiya tah akosr ke eot saok fac: ke tah soko oemeet sang sie eot ruby, sie eot topaz, ac sie eot garnet. ");
INSERT INTO kos_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Tah soko aklukwa ah, sie eot emerald, sie eot sapphire, ac sie eot diamond. ");
INSERT INTO kos_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ke tah soko aktolkwe, sie eot turquoise, sie eot agate, ac sie eot amethyst. ");
INSERT INTO kos_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ac tah soko akakosr ah, sie eot beryl, sie eot onyx, ac sie eot jasper. Eot inge nukewa in filiyuki ke frem gold. ");
INSERT INTO kos_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Eot singoul luo inge in kihlyak inen kais sie wen natul Jacob fac, in fahkak sruf singoul luo lun Israel. ");
INSERT INTO kos_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Orala sein ke gold nasnas, pirakela in oana luman fu israpla, tuh in oan ke mwe loeyuk iniwa sac. ");
INSERT INTO kos_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Orala luo ring gold ac sang nu ke sruwasrik luo lucng ke mwe loeyuk iniwa sac, ");
INSERT INTO kos_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ac srupusrang sein gold lukwa ah nu ke ring luo ah. ");
INSERT INTO kos_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Kapriya mutun sein lukwa ah nu ke frem luo uh, ac in lumah se inge kom fah kapsreni nu ke layen meet ke mwe sruh finpisa ma oan ke nuknuk ephod sac. ");
INSERT INTO kos_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Na orala luo ring gold an ac sang nu ke sruwasrik luo ten ke mwe loeyuk iniwa sac, in oan layen loac sisken nuknuk ephod uh. ");
INSERT INTO kos_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Orala pac luo ring gold ac sang nu ke layen ten ke acn meet ke mwe sruh luo nu ke finpisa ke nuknuk ephod sac, in oan apkuran ac lucng kutu liki acn se mwe lohl infulwa sac kupasryang nu ke ephod uh. ");
INSERT INTO kos_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Kapriya ring ke mwe loeyuk iniwa, nu ke ring ke ephod uh ke soko ah folfol, tuh mwe loeyuk iniwa sac fah oan lucng liki mwe lohl infulwa uh, tuh in tia putatla liki ephod uh. ");
INSERT INTO kos_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Ke pacl Aaron el ac utyak nu in Acn Mutal, el fah nokomang mwe loeyuk iniwa se inge su kihlyak ke inen sruf lun Israel, tuh nga, LEUM GOD, fah esam mwet luk pacl nukewa. ");
INSERT INTO kos_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Filiya Urim ac Thummim ke mwe loeyuk iniwa sac, tuh in oan iniwal Aaron ke pacl el utyak nu ye mutuk. Pacl nukewa el enenu in nukum mwe loeyuk iniwa se inge, tuh elan ku in kalem ke ma lungse luk nu sin mwet Israel. ");
INSERT INTO kos_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Nuknuk loeloes se ma oan ye ephod, in orekla nufonna ke unen sheep ngosla folfol. ");
INSERT INTO kos_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","In oasr kwawa se kac nu ke insifa, ac kwawa se inge in pwiyukla ke sie pac nuknuk tuh in tia mihsalik. ");
INSERT INTO kos_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Nu ke pikinnia kom fah sang unen sheep tuhn folfol, sroninmutuk, ac srusra ma orekla oana luman fokinsak pomegranate, wi tapweng srisrik gold in oan inmasrlo, rauneak nufon pikinnien nuknuk sac — ");
INSERT INTO kos_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","tapweng gold se, pomegranate se, tapweng gold se, pomegranate se, atupali rauneak pikinnien nuknuk loeloes sac. ");
INSERT INTO kos_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron elan nukum nuknuk loeloes se inge ke pacl el oru kulansap lun mwet tol. Pacl el utyak ku illa liki ye mutuk in Acn Mutal, pusren tapweng inge ac lohngyuk, na el ac fah tia anwuki. ");
INSERT INTO kos_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Orala sie mwe yun ke gold nasnas, ac kihlisya kas inge fac: ‘Kisakinyukyang Nu Sin LEUM GOD.’ ");
INSERT INTO kos_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Sang soko ah folfol kapriya nu ke acn meet ke nuknuk in lohl insuf. ");
INSERT INTO kos_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aaron elan sunya motonsrol, tuh mwet Israel fin tafongla ke elos orek kisa nu sik, mwatalos ac fah oan facl Aaron, ac nga, LEUM GOD, fah eis mwe kisa lalos nukewa. ");
INSERT INTO kos_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Otwela sie nuknuk loac lal Aaron ac sie mwe lohl insuf ke linen srik eoa, oayapa sie mwe lohl infulwa yuniyukla ke mwe akul. ");
INSERT INTO kos_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Orala nuknuk loac, mwe lohl infulwa, ac mwe lohl insuf lun wen natul Aaron, in fahkak fulat ac wolana lalos. ");
INSERT INTO kos_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Nokmulang Aaron, tamulel lom, ac wen natul ke nuknuk inge. Na akmusraelosla ac akmutalyalos ke kom mosrwelosla ke oil in olive, tuh elos fah ku in kulansupweyu ke orekma lun mwet tol. ");
INSERT INTO kos_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Orek loeyuk linen lalos, ke infulwalosi nu finyepalos, tuh elos fah tia koflufol. ");
INSERT INTO kos_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron ac wen natul fah nukum ma inge pacl nukewa ke elos ac ilyak nu ye mutuk nu in Lohm Nuknuk Mutal, ku ke pacl elos kalukyang nu ke loang uh in oru kulansap lun mwet tol in Acn Mutal, tuh elos in tia anwuki ke sripen liyeyuk koflufol lalos. Oakwuk se inge ma nu sel Aaron ac fwilin tulik natul nwe tok. ");
INSERT INTO kos_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Pa inge ma kom ac oru nu sel Aaron ac wen natul in srelosla ac akmutalyalos nu ke orekma lun mwet tol in kulansupweyu. Eis soko cow mukul fusr ac lukwa sheep mukul ma wanginna ma koluk ke manolos. ");
INSERT INTO kos_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Orekmakin flao na wowo, tusruktu tia orekmakin mwe pulol, na orala kutu bread orek ke oil in olive, ac kutu in wangin oil kac, ac kutu in luman flao minini akmusra ke oil. ");
INSERT INTO kos_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Sang nu in sie fotoh ac use nu ye mutuk ke pacl se kom kisakin cow soko ah ac sheep lukwa ah. ");
INSERT INTO kos_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Usalu Aaron ac wen natul nu ke nien utyak nu ke Lohm Nuknuk Mutal sik, ac twetekunulosla. ");
INSERT INTO kos_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Na nokmulang Aaron ke nuknuk in mwet tol — nuknuk loac, nuknuk loeloes ma oan ye ephod, ephod sac, mwe loeyuk iniwa sac, ac mwe lohl infulwa. ");
INSERT INTO kos_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Sunilya ke mwe lohl suf ac kapriya akul mutal ma kihlyak kas inge fac, ‘Kisakinyukyang Nu Sin LEUM GOD.’ ");
INSERT INTO kos_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Na eis oil in akmusra ac ukuiya nu fin sifal ac akmusraella. ");
INSERT INTO kos_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Use wen natul ac nokmultalang ke nuknuk loac, ");
INSERT INTO kos_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","losya mwe lohl infulwalos, ac kapriya mwe lohl fin sifalos. Pa ingan ouiya kom ac oru in akmusrael Aaron ac wen natul. Eltal, ac fwilin tulik natulos, pa ac kulansupweyu ke orekma lun mwet tol nwe tok. ");
INSERT INTO kos_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Use cow mukul soko uh nu mutun Lohm Nuknuk Mutal sik, ac fahk nu sel Aaron ac wen natul in filiya paolos ke sifa ah. ");
INSERT INTO kos_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Uniya cow soko uh we, ye mutuk ke nien utyak nu in Lohm Nuknuk Mutal sik. ");
INSERT INTO kos_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Twenya kufinpoum ke srahn cow soko ah ac sang mosrwela koac akosr fin ngoasron loang uh. Na okoala srah lula an nu ke kapin loang uh. ");
INSERT INTO kos_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Toko, eis kiris nukewa ma nokomla kainfohko, ac acn wo oemeet ke esa, ac kidney luo wi kiris kac, ac furreak fin loang uh tuh in sie mwe kisa nu sik. ");
INSERT INTO kos_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","A kom in usla ikwen cow soko ah, wi kolo ac kainfohko nu likin nien aktuktuk uh ac esukak. Mwe kisa se inge ma in eisla ma koluk lun mwet tol uh. ");
INSERT INTO kos_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Eis soko sin sheep mukul lukwa uh ac fahk nu sel Aaron ac wen natul in filiya paolos fin sifa uh. ");
INSERT INTO kos_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Uniya, ac eisla srah kac ac sang fwela siska akosr ke loang uh kewa. ");
INSERT INTO kos_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Sipikya sheep soko ah, ac ohlla koanonsia ac nia an, na filiya ma inge fin sifa ac ip nukewa saya. ");
INSERT INTO kos_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Esukak sheep mukul fon soko uh fin loang uh tuh in sie mwe kisa firir. Nga insewowo ke foulin mwe kisa se inge. ");
INSERT INTO kos_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Eis sheep mukul soko aklukwa ah, ac fahk nu sel Aaron ac wen natul in filiya paolos ke sifa ah. ");
INSERT INTO kos_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Uniya, ac eis kutu srah kac ac sang mosrwela acn fisrasrsrasr ke lac srac layot kacl Aaron ac wen natul, oayapa fin kuf lulap soko ke lac paolos layot ac kuf lulap soko ke lac nialos layot. Srah lula an kom fah sang fwela siska akosr ke loang uh. ");
INSERT INTO kos_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Na kom fah eis kutu srah ke loang uh ac kurrauk ke oil in akmusra, ac usrukya facl Aaron ac nuknuk lal, oayapa usrukya fin wen natul ac nuknuk lalos. Ouinge Aaron ac wen natul ac nuknuk lalos fah akmutalyeyuk nu sik. ");
INSERT INTO kos_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Ke sripen sheep mukul soko inge ma orekmakinyuk ke pacl in akmusra, ouinge kom fah supukla kiris kac wi pula kiris, kiris nokomla koanonsia, acn wo oemeet ke esa, kidney luo wi kiris kac, ac la epa layot. ");
INSERT INTO kos_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Liki fotoh in bread ma utuku nu ye mutuk, eisla soko lof ke bread ma orek ke oil in olive, soko ma wangin oil kac, ac sie cake minini. ");
INSERT INTO kos_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Sang bread inge wi ikwen sheep mukul soko ah nu in paol Aaron ac wen natul, na eltal in kolak nu lucng in akkalemye lah ma inge kisakinyukla nu sik. ");
INSERT INTO kos_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Toko eisla ma inge selos ac filiya fin sheep soko ma kisakinyuk meet ah, ac esukak fin loang uh, tuh in sie pac mwe kisa firir. Nga insewowo ke foulin mwe kisa inge. ");
INSERT INTO kos_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Eis iniwen sheep mukul soko aklukwa ah, ac kolak nu lucng in akkalemye lah kom kisakin nu sik. Ip se inge ac fah ma nom. ");
INSERT INTO kos_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Kom fah srela ip luo ke sheep soko ma orekmakinyuk ke pacl sie mwet el akmusrala nu ke kunokon lun mwet tol. Ip luo inge pa iniwa ac la epa, su kom fah kolak nu lucng ke kom kisakin nu sik. Iniwa sac ma nu sel Aaron, ac la epa sac ma nu sin wen natul. ");
INSERT INTO kos_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ke pacl mwet uh ac oru mwe kisa in akinsewowo, iniwa ac epan sheep soko ma kisakinyuk uh ac fah ma lun mwet tol. Oakwuk se inge ac fah oanna nwe tok. Ma inge mwe sang lalos nu sik, LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Nuknuk in mwet tol lal Aaron ac tufah tutafla nu sin wen natul tukun el misa, tuh elos in nukum ke pacl alu in akmusra. ");
INSERT INTO kos_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Wen se natul Aaron su aolul nu ke mwet tol ac su utyak nu in Lohm Nuknuk Mutal sik in kulansap in Acn Mutal, elan nukum nuknuk inge ke len itkosr. ");
INSERT INTO kos_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Eis ikwen sheep mukul soko ma orekmakinyuk nu ke akmusra lal Aaron ac wen natul, ac poeli in sie acn mutal. ");
INSERT INTO kos_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron ac wen natul in kang ikwa inge wi bread lula in fotoh uh ke nien utyak nu ke Lohm Nuknuk Mutal sik. ");
INSERT INTO kos_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Elos fah kang ma orekmakinyuk ke alu in siyuk nunak munas ke pacl akmusra lalos uh. Mwet tol mukena fah ku in kang mwe mongo inge, mweyen ma mutal. ");
INSERT INTO kos_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kutu ikwa ac kutu bread fin tia mongola nwe lotutang, in firriyukyak ac tia mongo, mweyen ma mutal. ");
INSERT INTO kos_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Oru alu in akmusra kacl Aaron ac wen natul ke len itkosr, oana ke nga sapkin nu sum. ");
INSERT INTO kos_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kais sie len kom enenu in sang soko cow mukul tuh in sie mwe kisa in ela ma koluk. Ma inge ac aknasnasye loang uh. Na mosrwela loang uh ke oil in olive in akmutalye. ");
INSERT INTO kos_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Oru ouinge ke lusen len itkosr. Na loang uh fah arulana mutal, ac kutena mwet, ku kutena ma su pusralla, ac fah ongoiya ke ku lun mutallana la. ");
INSERT INTO kos_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Pa inge ma kom ac kisakin fin loang uh ke len nukewa nwe tok: sheep fusr lukwa ma yac se matwa. ");
INSERT INTO kos_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Kisakin soko sheep inge ke lotutang, ac ma soko ngia ke eku. ");
INSERT INTO kos_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ke sheep fusr soko meet ah, sang luo paun in flao srik kosra arukak ke sie quart in oil in olive nasnas. Ukuiya sie quart ke wain tuh in sie mwe sang. ");
INSERT INTO kos_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Kisakin sheep soko aklukwa ah ke ekela, ac sang lupa se pachna ke flao, oil in olive, ac wain, oana ke lotutang. Foulin mwe kisa firir inge akinsewowoyeyu. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Kom, ac fwilin tulik nukewa nutum ke pacl fahsru, ac fah oru mwe kisa firir inge ye mutuk ke nien utyak nu in Lohm Nuknuk Mutal sik. Pa inge acn nga ac fah osun nu sin mwet luk, ac kaskas nu sum. ");
INSERT INTO kos_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Nga fah sun mwet Israel we, ac kalem wolana luk ac fah akmutalye acn sac. ");
INSERT INTO kos_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Nga fah oru Lohm Nuknuk ac loang uh in mutal, ac nga fah srella Aaron ac wen natul tuh elos in kulansapweyu ke orekma lun mwet tol. ");
INSERT INTO kos_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Nga fah muta inmasrlon mwet Israel, ac nga ac fah God lalos. ");
INSERT INTO kos_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Elos fah etu lah nga pa LEUM GOD lalos, su usalosme liki facl Egypt tuh nga fah ku in muta inmasrlolos. Nga pa LEUM GOD lalos. ");
INSERT INTO kos_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Orala sie loang ke sak acacia, in mwe kisakin mwe keng. ");
INSERT INTO kos_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Oru in maspang, inch singoul oalkosr lusa ac singoul oalkosr sralap, ac in tufah inch tolngoul onkosr fulata. Koac ke sruwasrik akosr in orekla ke ipin sak na kac an. ");
INSERT INTO kos_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Afinya acn fac, siska akosr ah, ac koac kac ke gold nasnas, ac sang patun gold soko rauneak. ");
INSERT INTO kos_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Orala luo ring gold an nu kac mwe utuk, oakeang nu ye patun ke siska luo an, tuh in sruok srenenu lukwa ma ac sang sruhk. ");
INSERT INTO kos_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Oru srenenu ingan ke sak acacia, ac nokomla ke gold. ");
INSERT INTO kos_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Filiya loang se inge likin lisrlisr ma sripsrip mutun Tuptup in Wuleang. Pa inge acn se ma nga ac osun nu sum we. ");
INSERT INTO kos_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Lotutang nukewa, ke pacl Aaron el ac tuku akoela lam uh, el ac fah esukak mwe keng fac. ");
INSERT INTO kos_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","El ac fah oru oapana ke pacl el akosak lam ke ekela. Mwe kisa keng se inge in orek na nwe tok. ");
INSERT INTO kos_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Nik kom kisakin kutena mwe keng ma tia mutal, ku kutena kosro, ku kutena mwe kisa ke wheat fin loang se inge, ac nikmet okoala kutena mwe kisa wain nu fac. ");
INSERT INTO kos_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Pacl se in yac nukewa Aaron elan oru alu in aknasnasye loang uh ke el eis srahn kosro soko ma kisakinyuk nu ke eela ma koluk, ac sang mosrwela koac akosr uh. Ma se inge in orek ke yac nukewa ke pacl nukewa fahsru uh. Loang se inge in tufah arulana mutal, sriyukla nu sik, LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Ke pacl kom oru sie oaoa lulap ke pisen mwet Israel uh, kais sie mukul in akfalye nu sik sie lupa in moli moul lal, tuh in wangin ongoiya sikyak nu sel ke pacl oaoa lulap se inge ac orek uh. ");
INSERT INTO kos_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Mwet nukewa ma wi oaoala ke oaoa lulap se inge enenu in moli lupa fal se ke mani, pauniya fal nu ke ma oakwuki. Mani se elos moli inge ac fah sie mwe sang nu sik. ");
INSERT INTO kos_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Mukul nukewa ma sun yac longoul matwa, ku matu liki, pa ac moli lupa se inge nu sik. ");
INSERT INTO kos_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Mwet kasrup in tia moli yohk liki, ku mwet sukasrup in tia moli srik liki, ke elos moli lupa se inge nu ke moul lalos. ");
INSERT INTO kos_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Eisani mani inge sin mwet Israel, ac orekmakin in sang akwoye Lohm Nuknuk Mutal sik. Tax se inge ac fah sang akfalye molin moul lalos, ac nga fah esam in karingnalosyang.” ");
INSERT INTO kos_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Orala sie pesin bronze, ac mwe loang nu kac in orekla pac ke bronze. Likiya inmasrlon Lohm Nuknuk Mutal ac loang uh, ac okoaung kof nu loac. ");
INSERT INTO kos_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron ac wen natul in orekmakin kof inge in oul paolos ac nialos ");
INSERT INTO kos_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","meet liki elos utyak nu in Lohm Nuknuk Mutal, ku ke elos ac kalukyang nu ke loang uh in kisakin mwe kisa firir. Na elos ac fah tia anwuki. ");
INSERT INTO kos_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Elos enenu in ohlla paolos ac nialos tuh elos in tia misa. Oakwuk se inge ma nu selos ac nu sin fwilin tulik natulos nwe tok.” ");
INSERT INTO kos_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Eis kutu mwe akkeng su arulana wo — paun singoul luo ke sronin myrrh, paun onkosr ke cinnemon ma keng fohlo, paun onkosr ke mah keng, ");
INSERT INTO kos_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ac paun singoul luo ke cassia (ma inge nukewa in pauni fal nu ke srikasrak oakwuki). Sang nu kac sie gallon in oil in olive, ");
INSERT INTO kos_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ac orala sie oil in akmusra mutal, kurrauk oana ono keng. ");
INSERT INTO kos_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Kom fah mosrwela Lohm Nuknuk Mutal sik kac, oayapa Tuptup in Wuleang, ");
INSERT INTO kos_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","tepu ac kufwa nukewa nu kac, nien lam ac kufwa nu kac, loang in esukak mwe keng, ");
INSERT INTO kos_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","loang in esukak mwe kisa wi pac kufwa nukewa nu kac, ac pesin in winwin sac wi mwe loangeya. ");
INSERT INTO kos_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Kisaela ma inge in lumah se inge, na ac fah arulana mutal, ac kutena mwet, ku kutena ma su pusralla ac fah ongoiya ke ku lun mutallana la. ");
INSERT INTO kos_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Na mosrwella Aaron ac wen natul, ac akmutalyalos in kulansupweyu ke orekma lun mwet tol. ");
INSERT INTO kos_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Fahkang nu sin mwet Israel lah oil in akmusra mutal se inge ac fah orekmakinyuk ke pacl akmusraiyuk mwet tol ke pacl nukewa, ingela nwe tok. ");
INSERT INTO kos_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ac fah tia ukuiyuk nu fin kutena mwet sayen mwet tol, ac kowos fah tia orekmakin srikasrak inge in oru mwe akmusra lowos. Ma inge mutal, ac kowos fah sunakin fal nu ke mutaliya. ");
INSERT INTO kos_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Kutena mwet su orek oil in akmusra oana srikasrak se inge, ku okoaung nu fin kutena mwet sayen mwet tol, elos ac fah tia sifil oaoa in mwet luk.” ");
INSERT INTO kos_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","LEUM GOD El fahk nu sel Moses, “Eis lupa sefanna ke kais sie mwe keng inge: stacte, onycha, galbanum, ac franku nasnas. ");
INSERT INTO kos_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Kurrauk ma inge nu sie in orala sie ono keng. Sang sohl nu kac in oru in nasnas ac mutal. ");
INSERT INTO kos_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Tuktukya kutu in mokutkuti, us nu in Lohm Nuknuk Mutal sik, ac sang osrela mutun Tuptup in Wuleang. Kowos nukewa in akfulatye mwe keng se inge oana sie ma arulana mutal. ");
INSERT INTO kos_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Nik kom orekmakin srikasrak se inge in oru kutena mwe keng nu sum sifacna. Ma inge arulana mutal mweyen ma kisakinyukme nu sik. ");
INSERT INTO kos_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Kutena mwet fin orek mwe keng ouinge nu sel sifacna, el ac fah tia sifilpa oaoa in mwet luk.” ");
INSERT INTO kos_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Nga sulella Bezalel, wen natul Uri ac nutin natul Hur, ke sruf lun Judah, ");
INSERT INTO kos_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ac nga nwakulla ke ngunik. Nga sang nu sel etauk, lalmwetmet, ac usrnguk ke kain in orekma in sroasr nukewa — ");
INSERT INTO kos_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","el pah in lemlem, ac usrnguk in orala ma inge ke gold, silver ac bronze. ");
INSERT INTO kos_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","El mwet na etu tufahl eot saok in oan in mwe naweyuk, el etu kihl sak, ac oayapa kain in sroasr usrnguk nukewa. ");
INSERT INTO kos_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Nga sulella pac Oholiab wen natul Ahisamach ke sruf lun Dan, in welul orekma. Nga sang ku lulap nu sin mwet usrnguk in orekma nukewa saya, tuh elos in ku in oru ma nukewa nga sap in orekla inge: ");
INSERT INTO kos_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Lohm Nuknuk Mutal sik, Tuptup in Wuleang ac mwe afyuf nu kac, ac kufwa nukewa nu ke Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tepu ac kufwa nu kac, nien lam gold nasnas ac kufwa nukewa nu kac, loang in furreak mwe keng, ");
INSERT INTO kos_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","loang nu ke mwe kisa ac kufwa nukewa nu kac, pesin in winwin ac mwe loang nu kac, ");
INSERT INTO kos_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","nuknuk wolana lun mwet tol ma nu sel Aaron ac wen natul, tuh elos in nukum ke pacl elos oru orekma lun mwet tol, ");
INSERT INTO kos_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","oil in akmusra, ac mwe keng nu ke Acn Mutal. Ke elos oru ma inge nukewa, elos enenu in oru oana ke nga sapkin nu sum.” ");
INSERT INTO kos_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","LEUM GOD El fahk nu sel Moses ");
INSERT INTO kos_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","in fahk nu sin mwet Israel, “Liyaung Sabbath, len in mongla luk, mweyen mwe akul se inmasrlok ac kowos nu ke fwil nukewa fahsru uh, in fahkak lah nga, LEUM GOD, sulekowosla kowos in mwet luk. ");
INSERT INTO kos_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Kowos fah liyaung len in mongla se inge mweyen sie len mutal. Kutena mwet su tia liyaung ac orekma na ke len sac, ac fah anwuki. ");
INSERT INTO kos_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Oasr len onkosr kowos ku in oru orekma lowos, a len se akitkosr sie len in mongla mutal nu sik. Kutena mwet su oru kutena orekma ke len sac ac fah anwuki. ");
INSERT INTO kos_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ke ma inge mwet Israel in karinganang len se inge in akfulatye, tuh akilenyen sie wuleang nwe tok. ");
INSERT INTO kos_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Akul se inge fah oan inmasrlok ac mwet Israel ma pahtpat, lah nga, LEUM GOD, orala kusrao ac faclu ke len onkosr, ac ke len se akitkosr nga tui liki orekma, ac mongla.” ");
INSERT INTO kos_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ke God El aksafyela sramsram lal nu sel Moses Fineol Sinai, El sang eot tupasrpasr luo nu sel ma God El sifacna simusla ma sap fac. ");
INSERT INTO kos_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ke mwet uh liye lah Moses el pahtlac in oatui liki fineol uh, elos toeni nu yorol Aaron ac fahk nu sel, “Kut tia etu lah mea sikyak nu sin mwet se Moses uh, su pwenkutme liki acn Egypt. Ke ouinge, orala sie god an nu sesr in kol kut.” ");
INSERT INTO kos_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron el fahk nu selos, “Eisla yaring gold ma mutan kiowos, wen nutuwos, ac acn nutuwos elos yaringkin an, ac use nu sik.” ");
INSERT INTO kos_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ouinge mwet nukewa eisla yaring gold lalos ac usla nu yorol Aaron. ");
INSERT INTO kos_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","El munanak yaring inge nwe ke kofelik, na el okoala gold uh nu in sie form ma lumahla soko cow fusr mukul. Na mwet uh fahk, “Israel, pa inge god lasr, su pwenkutme liki acn Egypt!” ");
INSERT INTO kos_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Na Aaron el musaela sie loang ye mutun cow mukul gold soko uh, ac fahkak “Lutu ac fah orek sie kufwa in akfulatye LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Toangna ke lotutang se toko ah, elos usani kosro mwe kisa firir, ac kutu in mwe kisa in akinsewowo. Mwet uh mutani, ac elos nimnim ac oru ouiya na kupatol. ");
INSERT INTO kos_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","LEUM GOD El fahk nu sel Moses, “Aksaye tufoki, tuh mwet lom su kom kolma liki Egypt elos orala sie ma na koluk. ");
INSERT INTO kos_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Elos kuhfla liki ouiyen moul ma nga sapkin nu selos. Elos orala cow mukul soko ke gold ac alu nu kac ac orek kisa nu kac. Elos fahk mu pa inge god lalos su pwanulosme liki Egypt. ");
INSERT INTO kos_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Nga etu lupan likkeke lun mwet inge. ");
INSERT INTO kos_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Inge, nik kom srike in ikolyu. Nga kasrkusrak selos, ac nga ac kunauselosla. Na nga fah oru tuh kom ac fwil nutum in sie mutunfacl lulap.” ");
INSERT INTO kos_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Tusruktu Moses el kwafe sin LEUM GOD lal ac fahk, “LEUM GOD, efu ku kom in arulana kasrkusrak sin mwet lom, su kom molelosla liki facl Egypt ke po kulana ac ku lulap lom? ");
INSERT INTO kos_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Efu ku kom oru mwet Egypt in ku in fahk mu ke kom pwanla mwet lom liki acn Egypt kom nuna akoo na in onelosi fineol uh ac kunauselosla nwe ke elos nukewa wanginla? Tulokinya kasrkusrak lom an. Aolla nunak lom ac nimet use mwe ongoiya inge nu fin mwet lom. ");
INSERT INTO kos_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Esam mwet kulansap lom: Abraham, Isaac ac Jacob. Esam pac wulela ku lom nu selos lah kom ac oru tuh fwilin tulik natulos in pus oana itu inkusrao, ac kom fah sang nu selos acn nukewa su kom wuleang kac tuh in ma selos nwe tok.” ");
INSERT INTO kos_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ke ma inge LEUM GOD El aolla nunak lal, ac tiana sang mwe ongoiya nu fin mwet lal oana El tuh akoo in oru. ");
INSERT INTO kos_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Na Moses el forla ac oatui liki fineol uh, ac el us eot tupasrpasr luo ma simla ma sap fac lac lac. ");
INSERT INTO kos_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","God sifacna El orala eot tupasrpasr luo uh ac kihlisya ma sap uh fac. ");
INSERT INTO kos_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Joshua el lohng pusren wowo lun mwet uh ac el fahk nu sel Moses, “Nga lohng pusren mweun ke nien aktuktuk uh.” ");
INSERT INTO kos_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moses el fahk, “Tia pusren sasa in kutangla pa ingan, ku pusren tung ke kutangyukla elos, a pusren on.” ");
INSERT INTO kos_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ke Moses el tuku apkuranyang nu nien aktuktuk uh el liye cow mukul gold soko, ac liye ke mwet uh onsrosro, na el foloyak. El tolya eot tupasrpasr luo uh nu pe eol uh, na eot luo ah fokelik. ");
INSERT INTO kos_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","El sruokya cow gold soko elos orala, sang nu ke e ah nwe ke kofelik, na el itungya nwe ke mokutkuti oana powder, ac kurrauk ke kof, na el sang mwet Israel in nim. ");
INSERT INTO kos_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","El fahk nu sel Aaron, “Mea mwet inge oru nu sum pwanang kom lela nu selos in oru ma na koluk se inge?” ");
INSERT INTO kos_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron el topuk, “Nimet kasrkusrak sik. Kom etu kuinsrim lun mwet inge nu ke ma koluk. ");
INSERT INTO kos_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Elos fahk nu sik, ‘Kut tia etu lah mea sikyak nu sin mwet se Moses uh, su pwenkutme liki acn Egypt. Ke ouinge, orala sie god an nu sesr in kol kut.’ ");
INSERT INTO kos_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nga siyuk elos in use mwe naweyuk gold lalos nu sik, ac elos su oasr yoro elos eisla ac use nu sik. Nga sisang mwe naweyuk inge nu in e ah, na cow mukul soko inge sikyak!” ");
INSERT INTO kos_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moses el liye lah Aaron el fuhlela mwet uh in sukosokla in oru na lungse lalos ac orekma in mwet lalfon ye mutun mwet lokoalok lalos. ");
INSERT INTO kos_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ouinge Moses el tu ke acn in utyak nu ke nien aktuktuk ac wowoyak fahk, “Su suwos wi layen lun LEUM GOD? Fahsru nu in se inge!” Na mwet Levi nukewa tukeni nu yorol ac raunella, ");
INSERT INTO kos_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ac el fahk nu selos, “LEUM GOD lun Israel El sapkin tuh kowos nukewa in srukak cutlass nutuwos ac filiya pupowos, ac fahsr sasla ke lohm nuknuk nukewa, mutawauk ke nien utyak uh sasla e layeno, ac kais sie suwos in uniya mukul Israel wiowos, mwet kawuk lowos, ac mwet tulan lowos.” ");
INSERT INTO kos_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Mwet Levi elos akos, ac uniya akuran tausin tolu mukul Israel ke len sac. ");
INSERT INTO kos_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moses el fahk nu sin mwet Levi, “Misenge ke kowos uniya wen nutuwos ac tamulel lowos, kowos sifacna akmutalye kowos in fal nu ke orekma lun mwet tol nu sin LEUM GOD, na LEUM GOD El akinsewowoye kowos.” ");
INSERT INTO kos_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Len tok ah Moses el fahk nu sin mwet uh, “Kowos tuh orala ma koluk na yohk se. Tusruktu inge nga ac sifil utyak nu fineol uh nu yurin LEUM GOD. Sahp nga ku in eis nunak munas nu ke ma koluk lowos.” ");
INSERT INTO kos_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Na Moses el folokla nu yurin LEUM GOD ac fahk, “Mwet inge orala ma koluk na yohk se. Elos orala god se ke gold ac alu nu kac. ");
INSERT INTO kos_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Inge nga kwafe sum in nunak munas ke ma koluk lalos. A kom fin tia, na kom eela inek liki book se su kom simis inen mwet lom loac.” ");
INSERT INTO kos_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","LEUM GOD El topuk, “Elos na su orekma koluk lainyu pa nga fah eela inelos liki book nutik. ");
INSERT INTO kos_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Inge fahsrot, kolla mwet uh nu ke acn se nga tuh fahk nu sum kac. Esam lah lipufan luk ac fah pwen kom, tusruktu ke pacl fahsru uh nga fah kalyei mwet inge ke ma koluk lalos.” ");
INSERT INTO kos_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ke ma inge LEUM GOD El supwama sie mas upa nu fin mwet uh, mweyen elos tuh sap Aaron el orala cow mukul gold soko. ");
INSERT INTO kos_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","LEUM GOD El fahk nu sel Moses, “Fahsr liki acn se inge, kom ac mwet su kom use liki Egypt, ac fahsr nu ke facl se su nga wulela in sang nu sel Abraham, Isaac, ac Jacob, ac nu sin fwil natulos. ");
INSERT INTO kos_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nga ac supwaot sie lipufan in pwen kom, ac nga fah lusla mwet Canaan, mwet Amor, mwet Hit, mwet Periz, mwet Hiv, ac mwet Jebus. ");
INSERT INTO kos_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Kom ac som nu in sie facl mut ac kasrup fohk we. Tusruktu nga sifacna ac tia wi kowos, mweyen kowos mwet likkeke, sahp nga ac kunauskowosla inkanek lowos.” ");
INSERT INTO kos_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ke mwet uh lohng kas inge, elos mutawauk in asor ac tung, ac tia sifilpa orekmakin mwe naweyuk. ");
INSERT INTO kos_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Meyen LEUM GOD El tuh sapkin nu sel Moses in fahk nu selos, “Kowos mwet likkeke. Nga fin ac wi kowos, finne ke kitin pacl na, nga ac ku in arulana kunauskowosla. Eisla mwe naweyuk lowos an inge, ac nga fah nunku lah mea nga ac oru nu suwos.” ");
INSERT INTO kos_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ouinge tukun mwet Israel elos fahsr liki Eol Sinai, elos tia sifil orekmakin mwe naweyuk. ");
INSERT INTO kos_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Pacl nukewa mwet Israel elos tulokunak iwen aktuktuk selos uh, Moses el ac usla Lohm Nuknuk Mutal ac tulokunak ke sie acn ma loes kutu liki nien aktuktuk uh. El pangon lohm nuknuk sac Iwen Tukeni Ye Mutun LEUM GOD. Kutena mwet su lungse lolngok yurin LEUM GOD ac illa liki nien aktuktuk ac som nu we. ");
INSERT INTO kos_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Pacl nukewa Moses el illa in som nu ke Lohm Nuknuk sac, mwet uh ac tu ke nien utyak nu ke lohm nuknuk selos ac ngetla liyal Moses nwe ke el utyak nu loac. ");
INSERT INTO kos_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Tukun Moses el utyak, sru in pukunyeng uh ac oatui lucng me ac tu ke nien utyak nu in Lohm Nuknuk uh, ac LEUM GOD El ac kaskas nu sel Moses liki pukunyeng uh me. ");
INSERT INTO kos_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Pacl se na mwet uh liye sru in pukunyeng ke acn in utyak nu in Lohm Nuknuk Mutal, elos ac pasrla. ");
INSERT INTO kos_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","LEUM GOD El ac kaskas nu sel Moses ngetani nu sie, oana ke sie mwet el sramsram nu sin mwet kawuk lal. Toko Moses el ac folokla nu nien aktuktuk uh. Tusruktu Joshua, wen natul Nun, su mwet kasru fusr lal, el mutana in Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moses el fahk nu sin LEUM GOD, “Pwaye lah kom fahk nu sik in kolla mwet inge nu ke facl sac, tusruktu kom tiana fahkma nu sik lah su ac wiyu som. Kom fahk mu kom arulana eteyu ac kom insewowo sik. ");
INSERT INTO kos_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Fin pwaye, nga kwafe sum in fahkma nunak lom, tuh ngan ku in kulansupwekom ac oru na ma ac akinsewowoye kom. Esam pac lah kom sulela mutanfahl se inge tuh elos in mwet lom.” ");
INSERT INTO kos_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","LEUM GOD El fahk, “Nga ac wi kom, ac nga fah sot misla nu sum.” ");
INSERT INTO kos_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moses el sifil fahk, “Kom fin tia wi kut, nimet oru kut in som liki acn se inge. ");
INSERT INTO kos_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Mwet uh ac etu fuka lah kom insewowo sin mwet lom ac insewowo sik kom fin tia wi kut? Oasr lom yorosr uh pa ac akkalemye lah kut sie liki mutunfacl nukewa saya fin faclu.” ");
INSERT INTO kos_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","LEUM GOD El fahk nu sel Moses, “Nga ac oru oana ke kom siyuk, mweyen nga arulana etekom ac nga insewowo sum.” ");
INSERT INTO kos_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Na Moses el fahk, “Nunak munas, lela nga in liye kalem wolana ma akkalemye lah kom oasr yorosr.” ");
INSERT INTO kos_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","LEUM GOD El topuk, “Nga ac oru tuh wolana luk nukewa in fahsr ye motom, ac nga fah fahkak Ine lukma luk yen kom oasr we. Nga pa LEUM GOD, ac nga fah fahkak kulang ac pakoten nu selos su nga sulela in oru nu se. ");
INSERT INTO kos_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Nga ac fah tia lela kom in liye mutuk, mweyen wangin mwet ku in liyeyu ac moul na, ");
INSERT INTO kos_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","tusruktu oasr sie eot inge siskuk ma kom ku in tu fac. ");
INSERT INTO kos_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Pacl se kalem wolana luk sun acn inge, nga fah filikomi ke lufin eot uh ac afinkomi ke pouk nwe ke nga alukela. ");
INSERT INTO kos_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Na nga fah eisla pouk, ac kom fah liye fin tuktuk, a kom fah tia liye mutuk.” ");
INSERT INTO kos_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","LEUM GOD El fahk nu sel Moses, “Taflela luo eot tupasrpasr oana ma meet ah, ac nga fah simusla fac kas ke eot luo ma kom tuh fukulya ah. ");
INSERT INTO kos_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Lututang kom akola ac fanyak nu fin mangon Eol Sinai ac osun nu sik we. ");
INSERT INTO kos_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Wangin mwet in wi kom fanyak. Wangin mwet in liyeyukyak in kutena acn ke eol uh, ac wangin sheep ku cow in mongo pe eol uh.” ");
INSERT INTO kos_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ouinge Moses el taflela eot tupasrpasr luo, ac toangna in lotutang tok ah el us fanyak nu Fineol Sinai, oana ke LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","LEUM GOD El oatui in sie pukunyeng ac welul tu we, ac El fahkak Ine mutal lal, su LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","LEUM GOD El fahla ye mutal Moses ac fahkak, “Nga pa LEUM GOD, God lun kulang ac pakoten, su tia sa in mulat, ac sesseslana ke inse pwaye ac lungse kawil. ");
INSERT INTO kos_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Nga liyaung wulela luk nu sin tausin fwil, ac nga nunak munas nu selos su tafongla ac oru ma sutuu ac ma koluk. Tusruk nga fah tia mulkunla in kai papa ac nina su oru ma koluk, oayapa tulik natulos ac nutin natulos nu ke fwil aktolu ac akakosr.” ");
INSERT INTO kos_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moses el sulaklak faksufi ac alu. ");
INSERT INTO kos_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","El fahk, “LEUM GOD, fin pwaye kom insewowo sik, nga siyuk sum in wi kut som. Mwet inge mwet likkeke, tusruktu nunak munas ke ma sutuu ac ma koluk lasr, ac eis kut tuh kut in mwet lom.” ");
INSERT INTO kos_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","LEUM GOD El fahk nu sel Moses, “Inge nga oakiya sie wuleang inmasrlok ac mwet Israel. Nga fah oru ma usrnguk ye mutalos, su soenna orek kutena acn fin faclu ku inmasrlon kutena mutanfahl. Mwet nukewa fah liye orekma yohk su nga LEUM GOD ku in oru, mweyen nga fah oru mwe lut yohk keiwos. ");
INSERT INTO kos_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Akos ma sap su nga sot nu suwos misenge. Nga ac fah lusak mwet Amor, mwet Canaan, mwet Hit, mwet Periz, mwet Hiv ac mwet Jebus, ke kowos fahsr in utyak nu yen selos. ");
INSERT INTO kos_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Nimet orek wulela yurin mwet in mutunfacl su kowos fahsr nu we, tuh ouiya se inge ac ku in sie sruhf nu suwos. ");
INSERT INTO kos_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","A ma kowos ac oru uh pa kunausya loang lalos, fukulya sru eot mutal lalos, ac pakiya ma akilenyen Asherah, god mutan lalos. ");
INSERT INTO kos_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Nik kom alu nu sin kutena god saya, tuh nga LEUM GOD, sie God lemta. ");
INSERT INTO kos_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Nik kom oru kutena wulela yurin mwet in facl sac, mweyen pacl elos alu nu sin god sutuu lalos ac orek kisa nu selos, elos ac suli kom in welulos, ac kom ac fah sruhfla in kang mwe mongo elos kisakin nu sin god lalos. ");
INSERT INTO kos_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Sahp wen nutum ac mau ku in payukyak sin mutansac, su ac pwanulosla tuh elos in tia inse pwaye nu sik, ac alu nu sin god sutuu lalos. ");
INSERT INTO kos_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Nik kom orek god osra ac alu nu selos. ");
INSERT INTO kos_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Liyaung Kufwen Bread Tia Akpulol. Kom in kang bread wangin mwe pulol kac ke lusen len itkosr in malem Abib, oana nga tuh sapkin nu sum, mweyen malem sacn pa kom illa liki acn Egypt. ");
INSERT INTO kos_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Wounse mukul nukewa nutuwos ac wounsien kosro uh elos ma luk, ");
INSERT INTO kos_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","tusruktu kais soko wounse nutin donkey nutuwos an kowos ac moli ke soko sheep fusr. Kowos fin tia lungse moli, na koteya kwawal. Kowos enenu na in molela wounse mukul nukewa nutuwos uh. “Wangin sie mwet in tuku nu ye mutuk fin wangin mwe sang in paol. ");
INSERT INTO kos_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Oasr len onkosr lom in oru orekma lom, ac nik kom orekma ke len se akitkosr, finne pacl in taknelik ku pacl in kosrani. ");
INSERT INTO kos_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Karinganang Kufwen Kosrani pacl kom ac oru kosrani se meet ke wheat, ac karinganang Kufwen Iwen Aktuktuk ke saflaiyen pacl in kosrani, ke kowos telani fokinsak sunowos. ");
INSERT INTO kos_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Pacl tolu in yac se mukul Israel nukewa in tuku alu nu sik, LEUM GOD lun Israel. ");
INSERT INTO kos_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Tukun nga lusla mutanfahl liki ye motom ac akyokyelik facl sum, wangin mwet fah srike in eisla acn sum ke pacl in kufwa tolu inge. ");
INSERT INTO kos_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Nik kom sang bread orekla ke mwe pulol pacl kom kisakin soko kosro nu sik. Kutena ipin kosro ma anwuki ke Kufwen Alukela fah tia oan nu ke lotutang se tok ah. ");
INSERT INTO kos_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ke kais sie yac, kom fah use nu in lohm sin LEUM GOD lom fahko ma wo emeet ke kosrani se meet lom. “Nik kom poeli soko sheep fusr, ku nani fusr, ke sronin titi lun nina kia.” ");
INSERT INTO kos_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","LEUM GOD El fahk nu sel Moses, “Simusla kas inge, tuh ke kas inge nga oakiya sie wuleang yurum ac yurin mwet Israel.” ");
INSERT INTO kos_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moses el muta yurin LEUM GOD ke len angngaul ac fong angngaul. El tia mongo ac nim kutena ma. El simis fin eot tupasrpasr inge kas ke wuleang — Ma Sap Singoul. ");
INSERT INTO kos_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ke Moses el us Ma Sap Singoul oatui liki Fineol Sinai, mutal saromrom mweyen el sramsram yurin LEUM GOD, a el tiana etu lah saromrom mutal. ");
INSERT INTO kos_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaron ac mwet nukewa ngetang liyal Moses ac liyauk lah mutal saromromla, ac elos sangeng in kulukyang nu yorol. ");
INSERT INTO kos_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","A Moses el pangnolos, ac Aaron ac mwet kol nukewa ke sruf lun Israel elos som nu yorol, ac Moses el kaskas nu selos. ");
INSERT INTO kos_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Toko, mwet Israel nukewa tukeni nu yorol, na Moses el sang nu selos ma sap nukewa ma LEUM GOD El fahk nu sel Fineol Sinai. ");
INSERT INTO kos_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ke Moses ek aksafyela sramsram lal yorolos, el afinya mutal ke sie nuknuk minini. ");
INSERT INTO kos_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Pacl nukewa Moses el ac utyak nu ye mutun LEUM GOD in Lohm Nuknuk Mutal in sramsram nu sel, el ac eisla nuknuk minini sac liki mutal. Ke el ac ilme, el ac fahkak nu sin mwet Israel ma nukewa ma sapkinyuk elan fahk, ");
INSERT INTO kos_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ac elos ac liye lah mutal saromrom. Na el ac sifilpa afinya mutal ke nuknuk minini sac nu ke pacl se el ac sifilpa som in sramsram nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moses el pangoneni mwet ke sruf nukewa lun Israel ac fahk nu selos, “Pa inge ma LEUM GOD El sapkin nu suwos in oru: ");
INSERT INTO kos_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Oasr len onkosr kowos ku in oru orekma lowos, a len se akitkosr sie len in mongla mutal nu suwos, sriyukla nu sik, LEUM GOD. Kutena mwet su oru kutena orekma ke len sacn ac fah anwuki. ");
INSERT INTO kos_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Kowos fah tia ta e ke len Sabbath ke kutena acn kowos muta we.” ");
INSERT INTO kos_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moses el fahk nu sin mwet Israel nukewa, “Pa inge ma LEUM GOD El sapkin: ");
INSERT INTO kos_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Kowos in oru sie sang nu sin LEUM GOD. Mwet nukewa su kena oru ouinge in use sie mwe sang ke gold, silver ku bronze; ");
INSERT INTO kos_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","linen srik eoa, unen sheep ma tuhn folfol, sroninmutuk, ac srusra; nuknuk orekla ke unen nani; ");
INSERT INTO kos_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kulun sheep mukul ngosla srusra; kulun kosro fisrasrsrasr; sak acacia; ");
INSERT INTO kos_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","oil nu ke lam uh; mwe keng nu ke oil in akmusra ac nu ke mwe kisa keng fohlo; ");
INSERT INTO kos_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","eot onyx ac wek saok saya in oakwukyang nu ke ephod lun Mwet Tol Fulat ac nu ke mwe loeyuk iniwa lal. ");
INSERT INTO kos_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Mwet nukewa inmasrlowos su pah in orekma elos in tuku ac orala ma nukewa ma LEUM GOD El sapkin: ");
INSERT INTO kos_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Lohm Nuknuk Mutal, ma in sang sunya fac ac mwe lisrlisr nu lik, mwe sruh ac frem nu kac, sukan brace uh, sru nu kac, ac kapin sru uh; ");
INSERT INTO kos_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Tuptup in Wuleang, srenenu nu kac, mwe afyuf nu kac, ac nuknuk in lisrlisr in lusrungak; ");
INSERT INTO kos_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","tepu ac srenenu kac, ac kufwa nukewa nu kac; bread kisakinyukla nu sin God; ");
INSERT INTO kos_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","nien lam mwe kalem, ac kufwa nu kac; lam uh wi oil nu kac; ");
INSERT INTO kos_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","loang in kisa mwe keng ac srenenu kac; oil in akmusra; mwe kisa keng fohlo; nuknuk in lisrlisr nu ke mutunoa lun Lohm Nuknuk Mutal; ");
INSERT INTO kos_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","loang nu ke mwe kisa firir, wi mwe liklik bronze itukyang nu kac, srenenu ac kufwa nukewa nu kac; pesin in winwin ac ma loangeya; ");
INSERT INTO kos_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","mwe lisrlisr nu ke kalkal nuknuk rauneak, wi sru ac kapin sru nu kac; mwe lisrlisr nu ke acn in utyak nu luin kalkal uh; ");
INSERT INTO kos_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","kwi nu ke Lohm Nuknuk Mutal, ac sucl nu ke Lohm Nuknuk ac kalkal uh; ");
INSERT INTO kos_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ac nuknuk wolana ma mwet tol in nukum pacl elos ac kulansap in Acn Mutal — nuknuk mutal inge ma lal Aaron, mwet tol, ac wen natul nukewa.” ");
INSERT INTO kos_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Na mwet Israel nukewa elos illa som, ");
INSERT INTO kos_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ac elos nukewa su insewowo in oru mwe sang lalos nu sin LEUM GOD elos use in sang oru Lohm Nuknuk Mutal sin God. Elos use kufwa nukewa ma eneneyuk nu ke pacl in alu, oayapa ma ac sang oru nuknuk mutal lun mwet tol. ");
INSERT INTO kos_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Mwet nukewa su lungse, kewana mukul ac mutan, use pin in naweyuk, ring, yaring, ah in walwal, ac kain in mwe yun gold nukewa, ac elos kisakunang nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Elos nukewa su oasr nuknuk linen srik eoa, ku unen sheep ngosla folfol, sroninmutuk, ku srusra; nuknuk ke unen nani, kulun sheep mukul ngosiyukla srusra; ku kulun kosro fisrasrsrasr, elos use. ");
INSERT INTO kos_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Mwet nukewa su ku in srukak silver ku bronze elos use ma inge tuh in mwe sang lalos nu sin LEUM GOD, ac mwet nukewa su oasr sak acacia yoro ma ku in orekmakinyuk nu ke kutena kain in orekma, elos use. ");
INSERT INTO kos_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Mutan pah in israp nukewa elos usani turet ke linen srik eoa, ac turet folfol, sroninmutuk, ac srusra, ma elos orala ke unen sheep. ");
INSERT INTO kos_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Elos oayapa orala turet ke unen nani. ");
INSERT INTO kos_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Mwet kol elos use eot onyx ac kutu pac eot saok in oakwukyang nu ke ephod ac mwe loeyuk iniwa, ");
INSERT INTO kos_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","oayapa mwe keng ac oil nu ke lam uh, nu ke oil in akmusra, ac nu ke mwe kisa keng fohlo. ");
INSERT INTO kos_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Mwet Israel nukewa su insewowo in oru mwe sang lalos, elos use nu sin LEUM GOD nu ke orekma ma El sapkin nu sel Moses in orek. ");
INSERT INTO kos_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moses el fahk nu sin mwet Israel, “LEUM GOD El sulella Bezalel, wen natul Uri ac nutin natul Hur ke sruf lun Judah. ");
INSERT INTO kos_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","God El nwakulla ke ngunal, ac sang nu sel etauk, lalmwetmet, ac usrnguk ke kain in orekma in sroasr nukewa — ");
INSERT INTO kos_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","el pah in lemlem, ac usrnguk in orala ma inge ke gold, silver ac bronze; ");
INSERT INTO kos_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","el mwet na etu tufahl eot saok in oan in mwe naweyuk; el etu kihl sak, ac oayapa kain in sroasr usrnguk nukewa. ");
INSERT INTO kos_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","LEUM GOD El sang nu sel, ac oayapa nu sel Oholiab wen natul Ahisamach ke sruf lun Dan, tuh eltal in ku in luti mwet ngia ke usrnguk in sroasr laltal. ");
INSERT INTO kos_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","El sang nu seltal pah in oru kain orekma nukewa lun mwet sroasr, ac mwet lemlem ke orekma usrnguk, ac mwet otwot ke nuknuk linen srik eoa; unen sheep ma tuhn folfol, sroninmutuk, srusra; ac kutepacna kain in nuknuk saya. Eltal fo in oru kain in orekma nukewa. ");
INSERT INTO kos_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bezalel, Oholiab, ac mwet orekma nukewa saya su LEUM GOD El sang pah ac lalmwetmet nu se, su etu in orala ma nukewa ma eneneyuk in sang musai Lohm Nuknuk Mutal, elos in oru ma nukewa in oana ma LEUM GOD El sapkin.” ");
INSERT INTO kos_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moses el pangnol Bezalel ac Oholiab, wi mwet pah in orekma nukewa saya su LEUM GOD El sang nu se fo in orekma ac su engan in kasru, na Moses el fahk elos in mutawauk orekma. ");
INSERT INTO kos_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Elos eis sel Moses mwe sang nukewa ma mwet Israel elos usani in sang musai Lohm Nuknuk Mutal. Ac mwet Israel elos nuna us na mwe sang lalos ke lotutang nukewa nu yorol Moses. ");
INSERT INTO kos_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Na mwet usrnguk in orekma su oru orekma uh som ");
INSERT INTO kos_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ac fahkang nu sel Moses, “Ma mwet uh use arulana alukela ma eneneyuk nu ke orekma ma LEUM GOD El sapkin in orek.” ");
INSERT INTO kos_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ke ma inge, Moses el supwalik kas nu in nien aktuktuk uh tuh mwet uh in tia sifil orani mwe sang lalos nu ke Lohm Nuknuk Mutal. Ouinge mwet uh tia sifil usani mwe sang. ");
INSERT INTO kos_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ma utukeni tari arulana yolyak in aksafyela orekma nukewa. ");
INSERT INTO kos_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Mukul ma arulana usrnguk inmasrlon mwet orekma uh pa orala Lohm Nuknuk Mutal sin LEUM GOD. Elos orala ke ipin nuknuk linen srik eoa singoul, otwotla ke unen sheep folfol, sroninmutuk, ac srusra, ac akilenyuk ke luman cherub uh. ");
INSERT INTO kos_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Kais sie ip oana sie lupa, yact singoul akosr lusa ac yact luo sralapa. ");
INSERT INTO kos_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Elos twani ip limekosr in orala ip loeloes sefanna, ac oru oapana nu ke ip limekosr ngia. ");
INSERT INTO kos_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Elos orala mwe sremsrem ke nuknuk folfol, ac sang nu ke ipin nuknuk se ma oan e siska ke kais sie nuknuk in lisrlisr. ");
INSERT INTO kos_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Elos orala mwe sremsrem lumngaul nu ke ip se meet ke nuknuk in lisrlisr se meet, oayapa mwe sremsrem lumngaul nu ke ip se safla ke nuknuk in lisrlisr se akluo. Mwe sremsrem inge oan lain sie sin sie. ");
INSERT INTO kos_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Elos orala mwe sruh lumngaul ke gold, in sang orani lisrlisr loeloes luo in ma sefannala. ");
INSERT INTO kos_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Na elos orala ipin nuknuk singoul sie ke unen nani in sang sunya Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Orekla nufon nu ke lupa sefanna, yact singoul limekosr lusa ac yact luo sralap. ");
INSERT INTO kos_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Elos twani polo nuknuk limekosr nu sie, ac pola onkosr ngia tutwani pac nu sie. ");
INSERT INTO kos_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Elos sang mwe sremsrem lumngaul nu ke sisken ip se safla ke sie pola ah, ac lumngaul mwe sremsrem ke sisken pola se ngia. ");
INSERT INTO kos_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Elos orala mwe sruh lumngaul ke bronze in kapsreni pola luo uh, in orala sie mwe afyuf. ");
INSERT INTO kos_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Elos orala mwe afyuf luo pac, sie ke kulun sheep mukul ngosla srusra, ac ma se ngia ke kulun kosro fisrasrsrasr, tuh in mwe afyuf nu lik. ");
INSERT INTO kos_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Elos tulokunak frem ma orekla ke sak acacia nu ke Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kais sie frem fit singoul limekosr fulata ac inch longoul itkosr sralapa. ");
INSERT INTO kos_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Oasr acn kihlyak luo ke kais sie frem tuh frem uh in kupasreni nu sie. Frem nukewa oasr acn kihlyak luo kac. ");
INSERT INTO kos_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Elos orala frem longoul nu layen eir, ");
INSERT INTO kos_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ac angngaul kapin frem ma orekla ke silver in oan ye frem inge — kapin frem luo nu ke frem se. ");
INSERT INTO kos_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Elos orala frem longoul nu layen epang ke Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ac angngaul kapin frem, kais luo ye frem se. ");
INSERT INTO kos_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Elos orala frem onkosr nu ke layen tok ke Lohm Nuknuk Mutal, layen nu roto, ");
INSERT INTO kos_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ac frem luo nu ke sruwasrik uh. ");
INSERT INTO kos_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Frem nu insruwasrik inge kupasreni tafunyen ten ac sruokeni tenyak na nwe lucng. Frem luo ma orala insruwasrik luo ah orekla in lumah se inge. ");
INSERT INTO kos_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ouinge oasr frem oalkosr wi kapin frem silver singoul onkosr — kais luo ye kais sie frem. ");
INSERT INTO kos_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","“Elos orala sukan brace singoul limekosr ke sak acacia — ma limekosr nu ke frem ke la Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ac limekosr nu ke frem ke layen ngia, ac limekosr nu ke frem siska nu roto fintukun lohm uh. ");
INSERT INTO kos_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Sukan brace soko ma oan infulwen frem uh, oan tafun lohm uh nwe ke tafu ngia. ");
INSERT INTO kos_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Elos nokomla frem uh ke gold, ac oakeang ring gold lulap nu kac in sruok sukan brace uh, su nukumyukla pac ke gold. ");
INSERT INTO kos_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","“Elos orala sie mwe lisrlisr ke ipin nuknuk linen srik eoa, otwot ke unen sheep ma folfol, sroninmutuk ac srusra. Elos yunela ac akilenya ke luman cherub uh. ");
INSERT INTO kos_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Elos orala sru akosr ke sak acacia ac nokomla ke gold, ma in sruok mwe lisrlisr uh, ac isongang mwe sruh gold nu ke sru uh. Na elos orala kapin sru akosr ke silver tuh sru uh in oan kac. ");
INSERT INTO kos_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Nu ke acn in utyak nu in Lohm Nuknuk Mutal, elos orala mwe lisrlisr se ke linen srik eoa, orekla ke unen sheep folfol, sroninmutuk ac srusra, ac yunla ke mwe akul. ");
INSERT INTO kos_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Nu ke mwe lisrlisr se inge elos orala sru limekosr ke sak acacia nukla ke gold, ac oakeang mwe sruh gold nu kac. Elos nokomla acn lucng ac osra kac ke gold, ac orala kapin sru limekosr ke bronze nu ke sru inge. ");
INSERT INTO kos_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel el orala Tuptup in Wuleang ke sak acacia, inch angngaul limekosr lusa, inch longoul itkosr sralap, ac inch longoul itkosr fulata. ");
INSERT INTO kos_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","El nokomla acn loac ac lik ke gold nasnas, ac sang patun gold raunela nufon. ");
INSERT INTO kos_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","El orala ring gold in utuk akosr nu kac ac oakeang nu ke nia akosr kac, kais luo ke siska lac lac. ");
INSERT INTO kos_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","El orala srenenu nu kac ke sak acacia, ac nokomla ke gold, ");
INSERT INTO kos_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ac isongang nu in ring ke sisken Tuptup uh. ");
INSERT INTO kos_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","El orala sie mwe afyuf ke gold nasnas, inch angngaul limekosr lusa, ac inch longoul itkosr sralap. ");
INSERT INTO kos_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","El orala cherub luo ke gold tuktuki, ");
INSERT INTO kos_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","sie oan ke tafu ac sie oan ke tafu se ngia. El orala tuh cherub luo ah in ip sefanna nu ke mwe afyuf sac. ");
INSERT INTO kos_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Cherub luo ah ngetani nu sie fin mwe afyuf sac, ac posohksok lalos asrosrelik ac afinya fac ah. ");
INSERT INTO kos_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bezalel el orala tepu sac ke sak acacia, inch tolngoul onkosr lusa, singoul oalkosr sralap, ac longoul itkosr fulata. ");
INSERT INTO kos_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","El nokomla ke gold nasnas ac filiya patun gold rauneak. ");
INSERT INTO kos_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","El kulasak fac ah ke sie patun inch tolu fulata, ac sang sie mwe naweyuk orekla ke gold in oan fin patun sac. ");
INSERT INTO kos_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","El orala ring in utuk akosr ke gold nu kac, ac sang nu ke sruwasrik akosr ah, yen nia akosr ah oakiyuki we. ");
INSERT INTO kos_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ring in sruh srenenu inge itukyang apkuran nu ke patun sac. ");
INSERT INTO kos_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Orekla srenenu nu kac ke sak acacia ac nukla ke gold. ");
INSERT INTO kos_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","El orala ahlu nu fin tepu ke gold nasnas: plate, cup, sufa, ac pol in orekmakinyuk nu ke pacl in kisa wain. ");
INSERT INTO kos_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Bezalel el orala sie nien lam ke gold nasnas, in oana luman sak soko. El orala srupo an ac kahpu an ke gold tuktuki. Ipin gold se na ma el sang orala srupo uh pa sang orala ros motul ac ros fareng, mwe naweyuk nu kac. ");
INSERT INTO kos_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Lah onkosr tula siska — tolu ke la, ac tolu ke la. ");
INSERT INTO kos_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Kais sie lah onkosr inge oasr ros in yun tolu kac ma oana luman ros almond — kutu ros motul ac kutu ros fareng. ");
INSERT INTO kos_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Srupo ke nien lam uh oasr ros in yun akosr kac ma oana luman ros almond — kutu ros motul ac kutu ros fareng. ");
INSERT INTO kos_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Oasr ros motul se oan ye acn ma kais luo lah inge kupasreni we. ");
INSERT INTO kos_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Nien lam uh, wi ros motul mwe naweyuk, ac lah kac ah — nufonna orekla ke ipin gold nasnas sefanna ma tuktuki. ");
INSERT INTO kos_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","El orala lam itkosr nu ke nien lam sac, ac el orala mwe kosrkosr wik ac ahlu nu kac ke gold nasnas. ");
INSERT INTO kos_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","El orekmakin paun itngoul limekosr ke gold nasnas in sang oru nien lam uh ac kufwa nukewa nu kac. ");
INSERT INTO kos_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bezalel el orala loang se ke sak acacia, mwe esukak mwe keng. Maspang acn fac: inch singoul oalkosr lusa, singoul oalkosr sralap, ac tolngoul onkosr fulata. Koac ke sruwasrik akosr ah orekla ke ipin sak na ma sang orala loang uh. ");
INSERT INTO kos_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","El afinya acn fac oayapa siska akosr an kewa, ac koac kac, ke gold nasnas, ac likiya patun gold soko rauneak. ");
INSERT INTO kos_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","El orala ring in tou gold luo, ac sang oan ye patun sac ke siska lac lac, in sruok srenenu lukwa ma orekla in sang sruhk. ");
INSERT INTO kos_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","El orala srenenu inge ke sak acacia ac nokomla ke gold. ");
INSERT INTO kos_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Bezalel el oayapa orala oil in akmusra mutal ac mwe keng nasnas loslos fohlo, karkarak oana ono in akkeng. ");
INSERT INTO kos_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezalel el orala sie loang ke sak acacia, nu ke mwe kisa firir. Maspang acn fac: fit itkosr tafu lusa, itkosr tafu sralap; ac akosr tafu fulata. ");
INSERT INTO kos_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","El orala koac in tuyak fin sruwasrik akosr ah. Koac inge orekla ke sak se na ma sang orala loang uh. El nokomla nufon ke bronze. ");
INSERT INTO kos_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","El orala pac kufwa nukewa nu ke loang uh: pan, saful, pesin, fork, ac pan in neinyuk mulut firir. Kufwa inge nukewa orek ke bronze. ");
INSERT INTO kos_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","El orala mwe liklik se ke bronze ac oakiya ye patun uh lac nwe ke infulwen loang uh. ");
INSERT INTO kos_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","El orala ring in utuk akosr ac sang in oan ke sruwasrik akosr. ");
INSERT INTO kos_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","El orala srenenu ke sak acacia, nokomla ke bronze, ");
INSERT INTO kos_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ac isongang nu in ring ke sisken loang uh lac lac. Loang uh orekla ke ipinsak ac oalal acn loac. ");
INSERT INTO kos_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","El orala sie pesin ac ma loangeya ke bronze saromrom ma mutan su kulansap ke nien utyak nu in Lohm Nuknuk Mutal elos selngunkin. ");
INSERT INTO kos_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Nu ke Lohm Nuknuk Mutal, su nien muta lun LEUM GOD, Bezalel el orala lisrlisr nu ke kalkal uh ke nuknuk linen srik eoa. Mwe lisrlisr nu layen eir, yact lumngaul lusa, ");
INSERT INTO kos_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","tulokinyukyak ke sru bronze longoul ma kasiki nu fin kapin sru bronze longoul, wi mwe sruh ac osra nu kac orekla ke silver. ");
INSERT INTO kos_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Kalkal layen nu epang uh orekla oapana layen nu eir. ");
INSERT INTO kos_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Layen nu roto, oasr mwe lisrlisr yact longoul limekosr lusa, ac oasr sru singoul ac kapin sru singoul, wi me sruh ac osra nu kac orekla ke silver. ");
INSERT INTO kos_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Nu layen kutulap, yen mutunoa oan we, kalkal uh oayapa yact longoul limekosr lusa. ");
INSERT INTO kos_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Mwe lisrlisr nu ke la mutunoa yact itkosr tafu, ac sru tolkwe wi kapin sru tolu nu kac. ");
INSERT INTO kos_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ac oapana nu ke layen ngia: oasr mwe lisrlisr yact itkosr tafu ac sru tolkwe wi kapin sru tolu nu kac. ");
INSERT INTO kos_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Mwe lisrlisr nukewa ke kalkal uh orekla ke linen srik eoa. ");
INSERT INTO kos_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Kapin sru uh orekla ke bronze, na mwe sruh, osra, ac mangon sru uh orek ke silver. Bezalel el kapsreni sru nukewa ke kalkal uh ke osra silver. ");
INSERT INTO kos_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Mwe lisrlisr nu ke acn in utyak ke kalkal uh orekla ke linen srik eoa, otwotla ke unen sheep ma tuhn folfol, sroninmutuk, ac srusra, ac yuniyukla ke mwe akul. Lusa ac fulata oapana mwe lisrlisr ke kalkal uh — yact singoul lusa, ac yact luo tafu fulata. ");
INSERT INTO kos_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Mwe lisrlisr se inge tulokinyukyak ke sru bronze akosr ma kasiki fin kapin sru akosr. Mwe sruh nu kac, ac mangon sru uh, ac osra uh, orekla ke silver. ");
INSERT INTO kos_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Kwi nukewa nu ke Lohm Nuknuk Mutal ac nu ke kalkal ma rauneak ah orekla ke bronze. ");
INSERT INTO kos_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Pa inge pisa ac lupan osra orekmakinyuk nu ke Lohm Nuknuk Mutal sin LEUM GOD, acn se ma eot tupasrpasr luo karinginyuk we su simla Ma Sap Singoul oan fac. Pisen osra inge ma Moses el sap mwet Levi in orala, su orekma ye kolyuk lal Ithamar, wen natul Aaron mwet tol. ");
INSERT INTO kos_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel, wen natul Uri ac nutin natul Hur ke sruf lun Judah, el orala ma nukewa ma LEUM GOD El sapkin in orekla. ");
INSERT INTO kos_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Oholiab, mwet kasru lal su wen natul Ahisamach ke sruf lun Dan, el sie mwet soasr ke kihl, ke lemlem, ac el sie mwet otwot ke nuknuk linen srik eoa, oayapa ke unen sheep ma tuhn folfol, sroninmutuk ac srusra. ");
INSERT INTO kos_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Gold nukewa ma kisakinyukyang nu sin LEUM GOD nu ke Lohm Nuknuk Mutal, toasriya paun luo tausin siofok eungoul limekosr, fal nu ke srikasrak ma oakwuki in pacl sac. ");
INSERT INTO kos_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Silver ma orekeni ke oaoa lulap lun sruf lun Israel nukewa, toasriya paun itkosr tausin lumfoko lumngaul, fal nu ke srikasrak oakwuki. ");
INSERT INTO kos_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Lupan gold ac silver inge nukewa fal nu ke lupan ma mwet nukewa su oaoala ke oaoa lulap sac elos tuh moli: kais sie mwet tuh moli ke lupa se ma oakwuki nu sel ac pauni fal nu ke srikasrak oakwuki. Oasr mukul onfoko tolu tausin lumfoko lumngaul su yac longoulyak pa oaoala ke oaoa lulap sac. ");
INSERT INTO kos_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Paun itkosr tausin lumfoko in silver pa sang orala kapin sru siofok nu ke Lohm Nuknuk Mutal oayapa lisrlisr sac. Kais soko kapin sru orekla ke paun itnoul limekosr. ");
INSERT INTO kos_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ke paun lumngaul lula ke silver ah, Besalel el sang orala osra, mwe sruh ke sru, ac mangon sru ingan. ");
INSERT INTO kos_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Bronze ma kisakinyuk nu sin LEUM GOD orala paun limekosr tausin tolfoko singoul. ");
INSERT INTO kos_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","El sang bronze inge orala kapin sru nu ke nien utyak lun Lohm Nuknuk Mutal sin LEUM GOD, oayapa loang bronze wi mwe liklik bronze nu kac, kufwa nukewa nu ke loang uh, ");
INSERT INTO kos_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","kapin sru nu ke kalkal rauneak ac acn in utyak nu in kalkal uh, ac kwi nukewa nu ke Lohm Nuknuk Mutal ac kalkal se rauneak. ");
INSERT INTO kos_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ke unen sheep ma ngosyuk folfol, sroninmutuk, ac srusra, elos orala nuknuk wolana ma mwet tol in nukum pacl elos ac kulansap in Acn Mutal. Elos orala nuknuk in mwet tol lal Aaron, oana ke LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Elos orala nuknuk ephod ke linen srik eoa, ac unen sheep folfol, sroninmutuk, ac srusra, ac turet gold. ");
INSERT INTO kos_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Elos tuktukya gold uh nwe ke mininila, luseya nu ke koa srisrik ac otwala nu ke linen srik eoa ac nu ke unen sheep folfol, sroninmutuk, ac srusra. ");
INSERT INTO kos_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Elos orala mwe sruh luo nu finpisa ke ephod uh in sang sruokani siska luo ah. ");
INSERT INTO kos_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Mwe lohl infulwa, ma arulana wo otweya ke mwe yun nukewa ma sang orala ephod sac, elos kapsreni nu ke ephod uh tuh in ma sefannala, oana ke LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Akoeyukla eot onyx ac filiyuki in frem gold; ac elos orek kihl usrnguklana kac ke inen wen singoul luo natul Jacob. ");
INSERT INTO kos_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Elos filiya ma inge fin mwe sruh luo ke finpisa lun ephod uh in fahkak sruf singoul luo lun Israel, in oana ke LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Elos orala mwe loeyuk iniwa ke mwe yun pacna ma sang orala ephod uh, ac ke pacna mwe akul ma sang nawela ah. ");
INSERT INTO kos_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Elos lumwani pacl se tuh in maspangla — inch eu lusa ac eu sralap. ");
INSERT INTO kos_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Elos filiya tah akosr ke eot saok fac: tah soko oemeet ah elos sang eot ruby se, topaz se, ac garnet se. ");
INSERT INTO kos_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Tah soko aklukwa ah, elos sang emerald se, sapphire se, ac diamond se. ");
INSERT INTO kos_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Tah soko aktolkwe ah: turquoise se, agate se, ac amethyst se. ");
INSERT INTO kos_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Tah soko akakosr ah: beryl se, onyx se, ac jasper se. Eot inge takinyukla nu luin kais sie frem gold. ");
INSERT INTO kos_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kais sie ke eot singoul luo inge kihlisyukyak inen kais sie wen natul Jacob fac, in fahkak sruf singoul luo lun Israel. ");
INSERT INTO kos_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Nu ke mwe loeyuk sac, orekla sein kac ke gold nasnas, pirakla oana luman fu israpla. ");
INSERT INTO kos_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Elos orala frem gold luo ac ring gold luo, ac oakeang ring luo ah nu ke sruwasrik lucng ke mwe loeyuk iniwa uh. ");
INSERT INTO kos_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Elos srupsrani sein gold lukwa nu ke ring luo ah, ");
INSERT INTO kos_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ac srupsrani muta luo ngia ke sein lukwa ah nu ke frem luo ah, ouinge elos filiya ke mwe sruh luo lun finpisa tuh in oan meet ke ephod uh. ");
INSERT INTO kos_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Elos orala ring gold luo ac sang nu ke sruwasrik luo ten ke mwe loeyuk iniwa sac, in oan layen loac sisken nuknuk ephod uh. ");
INSERT INTO kos_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Elos orala pac ring gold luo ac sang nu ke layen ten ke acn meet ke mwe sruh luo ke finpisa ke ephod uh, in oan apkuran ac lucng kutu liki acn se mwe lohl infulwa sac kupasryang nu ke ephod uh. ");
INSERT INTO kos_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Oana ma LEUM GOD El sapkin nu sel Moses, elos kapriya ring ke mwe loeyuk iniwa nu ke ring ke ephod uh ke soko ah folfol, tuh mwe loeyuk iniwa sac fah oan lucng liki mwe lohl infulwa sac ac tia foroti. ");
INSERT INTO kos_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Nuknuk loeloes se ma oan ye ephod uh orekla ke unen sheep ma tuhn folfol nufon. ");
INSERT INTO kos_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Elos pwela kwawen nuknuk sac ke sie pac nuknuk, in akkeye in tia mihsalik. ");
INSERT INTO kos_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ke pulun nuknuk sac elos sang kutu ma oana fokinsak pomegranate, ma orekla ke mwesrem folfol, sroninmutuk ac srusra, ac linen srik eoa. ");
INSERT INTO kos_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Oayapa elos orala tapweng srisrik ke gold nasnas ac filiya inmasrlon pomegranate, rauneak pulun nuknuk loeloes sac — ");
INSERT INTO kos_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","tapweng se, pomegranate se, tapweng se, pomegranate se, atupali rauneak pulun nuknuk loeloes in alu sac, in oana LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Elos orala nuknuk loac lal Aaron ac wen natul, ");
INSERT INTO kos_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ac mwe lohl insuf ac susu, ac tafun nuknuk linen loac mwe loeyuk, ");
INSERT INTO kos_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ac mwe lohl infulwa ke linen srik eoa ac ke mwesrem folfol, sroninmutuk, ac srusra, yuniyukla ke mwe akul, oana ma LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Elos orala sie mwe yun mutal ke gold nasnas, akilenyen ma kisakinyukla, ac kihlisya kas inge fac: “Kisakinyukyang Nu Sin LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Elos kapriya mwe yun gold sac ke acn meet ke mwe lohl insuf uh ke soko ah folfol, in oana ke LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Orekma nukewa ke Lohm Nuknuk Mutal sin LEUM GOD sun saflaiya. Mwet Israel orala ma nukewa oana ma LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Elos use ma inge nu yorol Moses: Lohm Nuknuk Mutal ac kufwa nukewa nu kac, mwe sruh, frem, sukan brace, sru ac kapin sru; ");
INSERT INTO kos_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","mwe afyuf ke kulun sheep mukul ngosla srusra, mwe afyuf nu lik ke kulun kosro fisrasrsrasr; lisrlisr in sraclik Acn Mutal liki Acn Mutal Na Mutal; ");
INSERT INTO kos_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Tuptup in Wuleang wi eot tupasrpasr ma oan loac, srenenu nu kac, ac mwe afyuf nu kac; ");
INSERT INTO kos_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tepu ac kufwa nukewa kac, wi bread kisakinyuk nu sin God; ");
INSERT INTO kos_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","nien lam orekla ke gold nasnas, lam nu kac, kufwa nukewa nu kac, ac oil nu ke lam uh; ");
INSERT INTO kos_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","loang gold; oil in akmusra; mwe keng; lisrlisr nu ke acn in utyak nu ke Lohm Nuknuk Mutal; ");
INSERT INTO kos_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","loang bronze wi mwe liklik bronze, srenenu nu kac ac kufwa nukewa kac; pesin in winwin ac ma loangeya; ");
INSERT INTO kos_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","lisrlisr nu ke kalkal uh wi sru ac kapin sru uh; oayapa lisrlisr nu ke nien utyak ke kalkal uh ac sucl nu kac; kwi nu ke Lohm Nuknuk Mutal; kufwa nukewa ma ac orekmakinyuk ke Lohm Nuknuk Mutal; ");
INSERT INTO kos_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ac nuknuk wolana ma mwet tol ac nukum in Acn Mutal — nuknuk mutal lal Aaron, mwet tol, ac lun wen natul. ");
INSERT INTO kos_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Mwet Israel elos orala orekma nukewa oana ma LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moses el arulana tuni ma nukewa ac liye lah elos orala oana ke LEUM GOD El tuh sapkin. Ouinge Moses el akinsewowoyalos. ");
INSERT INTO kos_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ke len se omeet in malem se meet, tulokunak Lohm Nuknuk Mutal sik. ");
INSERT INTO kos_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Filiya Tuptup in Wuleang loac, ma neinyen Ma Sap Singoul, ac sripisrya mwe lisrlisr uh in lusrungak. ");
INSERT INTO kos_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Use tepu nu loac ac filiya kufwa nukewa fac. Oayapa use nien lam uh nu loac ac oakiya lam uh fac. ");
INSERT INTO kos_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Filiya loang gold mwe furreak mwe keng mutun Tuptup in Wuleang, ac sripisrya mwe lisrlisr ke nien utyak nu in Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Filiya loang in furreak mwe kisa, in oan meet liki mutun Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Likiya pesin in winwin inmasrlon Lohm Nuknuk Mutal ac loang uh, ac nwakla ke kof. ");
INSERT INTO kos_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Tulokunak kalkal in sang rauneak, ac sripisrya mwe lisrlisr ke acn in utyak nu in kalkal uh. ");
INSERT INTO kos_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Toko kisakin Lohm Nuknuk Mutal ac kufwa nukewa kac ke kom mosrwela ke oil in akmusra mutal, na ma nukewa ac fah mutal. ");
INSERT INTO kos_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Kisakin loang in mwe kisa firir ac kufwa nukewa kac ke kom mosrwela, na ac fah arulana mutal. ");
INSERT INTO kos_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Kisakin pac pesin in winwin ac ma loangeya in lumah sacna. ");
INSERT INTO kos_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Usalu Aaron ac wen natul nu ke acn in utyak lun Lohm Nuknuk Mutal, ac twetekunulosla ke sie yihyih mutal. ");
INSERT INTO kos_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Nokmulang Aaron ke nuknuk lun mwet tol, ac mosrwella in akmutalyal, tuh el fah ku in kulansupweyu in oru orekma lun mwet tol. ");
INSERT INTO kos_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Use wen natul ac nokmulosyang ke nuknuk loeloes loac. ");
INSERT INTO kos_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Na mosrwelosla, in oana ke kom mosrwela papa tumalos, tuh elos in ku in kulansupweyu ke ma kunen mwet tol. Akmusra se inge ac oru tuh elos, ac fwil nukewa natulos, in mwet tol nwe tok.” ");
INSERT INTO kos_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moses el orala ma nukewa oana ke LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ouinge ke len se oemeet in malem se meet ke yac se akluo tukun elos illa liki facl Egypt, tulokinyukyak Lohm Nuknuk Mutal Sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moses el oakiya kapin sru uh, tulokunak frem uh, sang sukan brace nu kac, ac tulokunak sru nu kac. ");
INSERT INTO kos_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","El laknelik mwe afyuf se meet ac sang sunya fin Lohm Nuknuk Mutal, na el sifil sunya ke mwe afyuf se akluo, oana ke LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Na el eis eot tupasrpasr luo ac sang nu in Tuptup in Wuleang. El isongang srenenu nu ke ring ke Tuptup uh, ac sang mwe afyuf uh nu fac. ");
INSERT INTO kos_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Na el usak Tuptup uh nu in Lohm Nuknuk Mutal ac srupusrak mwe lisrlisr in lusrungak Tuptup in Wuleang, oana LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","El likiya tepu uh in Lohm Nuknuk Mutal, layen nu epang likin mwe lisrlisr uh, ");
INSERT INTO kos_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ac eis bread kisakinyuk nu sin LEUM GOD ac takunla fac, oana ke LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","El filiya nien lam uh in Lohm Nuknuk Mutal, layen eir in lohm uh, lainang tepu uh, ");
INSERT INTO kos_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ac el sang lam uh nu ke nien lam uh, ac akosak ye mutun LEUM GOD, oana ke LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","El filiya loang gold in Lohm Nuknuk Mutal, ke mutun lisrlisr uh, ");
INSERT INTO kos_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ac el esukak mwe kisa keng fac, in oana ma LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","El srupusrak mwe lisrlisr ke acn in utyak nu in Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","na el oakiya loang nu ke mwe kisa firir mutun lisrlisr uh. El kisakin mwe kisa firir ac mwe kisa wheat fac, oana LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","El filiya pesin in winwin inmasrlon Lohm Nuknuk Mutal ac loang in kisa, ac nwakla ke kof. ");
INSERT INTO kos_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moses, Aaron, ac wen natul ohlla paolos ac nialos kac ");
INSERT INTO kos_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ke pacl nukewa elos ac ilyak nu in Lohm Nuknuk Mutal, ku kalukyang nu ke loang in kisa, in oana ma LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Moses el tulokunak kalkal uh rauneak Lohm Nuknuk Mutal ac loang uh, ac srupusrak lisrlisr ke acn in utyak nu ke kalkal uh. Ouinge el aksafyela orekma nukewa. ");
INSERT INTO kos_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Na pukunyeng se afinya Lohm Nuknuk Mutal, ac kalem wolana lun LEUM GOD nwakla in lohm uh. ");
INSERT INTO kos_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ke sripa inge, Moses el tia ku in utyak nu in Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Mwet Israel elos ac tuleya lohm nuknuk selos ac mukuila nu ke sie pac acn ke pacl na pukunyeng sac ac touyak liki Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Lusenna pacl pukunyeng sac oanna fin Lohm Nuknuk Mutal, elos ac tia mokle nien aktuktuk lalos. ");
INSERT INTO kos_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ke lusenna pacl mwet Israel elos fufahsryesr, LEUM GOD El oasr yorolos. Elos liye pukunyeng lal oan fin Lohm Nuknuk Mutal ke len, ac elos liye e firirrir in pukunyeng uh ke fong. ");
INSERT INTO kos_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","LEUM GOD El pang nu sel Moses liki Lohm Nuknuk Mutal sin LEUM GOD su nien muta lal, ac sang nu sel oakwuk inge, ");
INSERT INTO kos_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","su ma nu sin mwet Israel ke pacl elos oru kisa lalos. Ke pacl ma sie mwet el kisakin soko kosro natul, ku in cow soko ku sheep soko ku nani soko. ");
INSERT INTO kos_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","El fin ac sang soko sin cow natul in mwe kisa firir, el ac enenu in use soko cow mukul ma wangin ma koluk ke manol. El ac enenu in use nu ke nien utyak ke Lohm Nuknuk Mutal sin LEUM GOD tuh LEUM GOD Elan insewowo sin mwet sac. ");
INSERT INTO kos_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Mwet sac ac enenu in filiya paol fin sifen cow soko ah, na ac fah pangpang sie mwe kisa in eela ma koluk lal. ");
INSERT INTO kos_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","El fah uniya cow mukul soko ah we, ac mwet tol in fwil natul Aaron fah asang srah kac nu sin LEUM GOD, ac fwela siska akosr ke loang se ma oan ke acn in utyak nu in Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Na el fah sukela kulun cow soko ah, ac luseya ikwa uh, ");
INSERT INTO kos_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","na mwet tol elos fah takunla etong fin loang uh ac akosak. ");
INSERT INTO kos_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Elos fah filiya ipin kosro ah fin e uh, wi pac sifa ac kiris kac uh. ");
INSERT INTO kos_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Mwet sac fah ohlla koanonsia ac pukinnien cow uh, na mwet tol se ma oru kisa uh fah esukak ma inge nukewa fin loang uh. Foulin mwe mongo ma kisakinyuk inge mwe insewowo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Mwet se fin kisakin soko sin sheep ku nani natul, ac enenu na in ma mukul soko su wanginna ma koluk ke manol. ");
INSERT INTO kos_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","El fah uniya ke layen epang ke loang sac, ac mwet tol fah fwela siska akosr ke loang sac ke srah. ");
INSERT INTO kos_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Tukun mwet sac luseya kosro soko ah, na mwet tol se ma orekma ke kisa uh fah filiya ip nukewa inge fin e sac, wi sifa ac kiris kac. ");
INSERT INTO kos_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Mwet sac enenu in ohlla koanonsia ac pukinnia kewa ke kof, na mwet tol sac fah sang mwe kisa inge nu sin LEUM GOD, ac esukak ma nukewa fin loang uh. Foulin mwe mongo ma kisakinyuk inge mwe insewowo su sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Mwet se fin ac kisakin sie won tuh in mwe kisa firir, enenu na in wuleoa se ku siena wule. ");
INSERT INTO kos_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Mwet tol fah use nu ke loang uh, furala kwawa ac esukak sifa uh fin loang uh. Srah kac uh ac fah aksororyeyukla nu sisken loang uh. ");
INSERT INTO kos_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","El fah eisla tenguna ac koanonsien won sac, ac sisla nu layen kutulap ke loang uh, nu ke nien fil apat uh. ");
INSERT INTO kos_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","El fah sruokya pao luo ah, ac seya mano sac, tusruktu pao luo ac fah tia ayukla liki mano sac, na el ac esukak nufonna fin loang uh. Foulin mwe mongo ma kisakinyuk inge mwe insewowo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Kutena mwet su orekmakin wheat in kisa nu sin LEUM GOD, el enenu in ilya meet nu ke flao. El enenu in sang oil in olive ac mwe keng nu kac ");
INSERT INTO kos_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ac use nu sin mwet tol in sou lal Aaron. Mwet tol se ma orekma ke kisa uh ac fah lafusak kutu flao uh nu inpaol wi kutu oil ac nufonna mwe keng an, ac esukak fin loang uh tuh in sie mwe akul lah ma nukewa kisakinyukyang nu sin LEUM GOD. Foulin mwe mongo ma kisakinyuk inge mwe insewowo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Luwen mwe kisa wheat inge ac ma nu sin mwet tol. Ma inge arulana mutal, mweyen ma itukla liki mwe mongo ma kisayang nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Fin mwe kisa uh orekla ke flao ma umla ke stove, enenu in tia orekmakinyuk mwe pulol nu kac. Ku in lof matoltol ma orekla ke flao kulamisyak ke oil in olive, ku cake minini akmusrala ke oil in olive. ");
INSERT INTO kos_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Fin mwe kisa uh pa bread manman ke pan in furae, enenu in orek ke flao kulamisyak ke oil in olive, tusruktu in wangin mwe pulol kac. ");
INSERT INTO kos_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Kinkinisya ac okoaung oil nu kac ke kom sang tuh in mwe kisa. ");
INSERT INTO kos_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Fin mwe kisa uh pa bread manman ke pan, enenu in orek ke flao ac oil in olive. ");
INSERT INTO kos_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Use in mwe kisa nu sin LEUM GOD ac sang nu sin mwet tol, su ac fah usla nu ke loang uh. ");
INSERT INTO kos_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Mwet tol ac fah eis sie ip kac tuh in sie mwe akul lah nufonna kisakinyukyang tari nu sin LEUM GOD, na el fah esukak fin loang uh. Foulin mwe mongo kisakinyuk inge mwe insewowo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ma lula ke mwe kisa uh ac ma lun mwet tol. Ma inge arulana mutal, mweyen ma itukla liki mwe mongo ma kisakinyukla nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Mwe kisa wheat nukewa su kom kisakin nu sin LEUM GOD, ac fah tiana orekmakinyuk mwe pulol nu kac. Kom enenu in tiana orekmakin mwe pulol ku honey nu ke mwe mongo ma kisakinyuk nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Mwe kisa ke fahko se meet ke wheat ma kom kosrani ke kais sie yac ac fah utuku nu sin LEUM GOD, tusruktu ac fah tia isisyak fin loang uh. ");
INSERT INTO kos_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Sang sohl nu ke mwe kisa wheat nukewa ma kom kisakin uh, mweyen sohl uh akkalemye wuleang inmasrlom ac God. (Kom enenu in sang sohl nu ke mwe kisa nukewa lom.) ");
INSERT INTO kos_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ke kom us fahko se meet ke wheat ma kom kosrani in mwe kisa nu sin LEUM GOD, kom fah kisai wheat manman fin e, ku wheat ma ilyuki. ");
INSERT INTO kos_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Sang oil in olive ac mwe keng nu kac. ");
INSERT INTO kos_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Mwet tol ac fah esukak mwe keng ah nufon, wi ipin wheat ac oil su oana sie mwe akul, tuh in mwe kisa ke mwe mongo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ke pacl se sie mwet ac kisakin soko cow natul in mwe kisa in akinsewowo, ac enenu in cow mukul soko ku cow mutan soko ma wanginna ma koluk ke manol. ");
INSERT INTO kos_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Mwet sac fah filiya paol fin sifen cow soko ah, ac uniya ke acn in utyak nu in Lohm Nuknuk Mutal, su Nien Muta lun LEUM GOD. Mwet tol in sou lal Aaron ac fah sang srah kac, fwela siska akosr ke loang uh, ");
INSERT INTO kos_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ac sang ip ma takinyukla inge in mwe kisa mongo nu sin LEUM GOD: kiris nukewa ke koanonsia uh, ");
INSERT INTO kos_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","kidney luo ac kiris kac uh, ac ip se ma wo emeet ke esa uh. ");
INSERT INTO kos_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Mwet tol fah esukak ma inge nukewa fin loang uh wi mwe kisa firir uh. Foulin mwe mongo kisakinyuk inge mwe insewowo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Sie mwet fin use soko sheep ku soko nani tuh in mwe kisa in akinsewowo, ac ku in ma mukul soko ku ma mutan soko, tusruktu enenu in wanginna ma koluk ke manol. ");
INSERT INTO kos_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Mwet se fin kisakin soko sheep, ");
INSERT INTO kos_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","el fah filiya paol fin sifen sheep soko ah, ac uniya sisken mutun Lohm Nuknuk Mutal. Mwet tol fah fwela siska akosr ke loang uh ke srah ");
INSERT INTO kos_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ac srela ip inge kewa in mwe kisa mongo nu sin LEUM GOD: kiris, ac acn kiris ke pulun sheep soko ah nufon su ac fah laslasla apkuran nu ke sri in fintokol, oayapa kiris nukewa ma nokomla koanonsial, ");
INSERT INTO kos_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","kidney luo ac kiris kac, ac acn ma wo emeet ke esa uh. ");
INSERT INTO kos_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Mwet tol se ma orek kisa uh ac fah esukak ma inge nukewa fin loang uh in mwe kisa mongo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Mwet se fin kisakin soko nani ");
INSERT INTO kos_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","el fah filiya paol fin sifen nani soko ah, ac uniya sisken mutun Lohm Nuknuk Mutal. Mwet tol ac fah fwela siska akosr ke loang uh ke srah ");
INSERT INTO kos_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ac sang ip inge kewa in mwe kisa mongo nu sin LEUM GOD: kiris nukewa ke koanonsia uh, ");
INSERT INTO kos_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","kidney luo ac kiris kac, ac acn ma wo emeet ke esa uh. ");
INSERT INTO kos_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Mwet tol fah esukak ma inge nukewa fin loang uh in mwe kisa mongo su ac akinsewowoye LEUM GOD. Kiris nukewa ma lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Wangin mwet Israel ac fah kang kutena kiris ku kutena srah. Oakwuk se pa inge, ma in karinginyuk sin mwet Israel nukewa nwe tok in acn nukewa ma elos muta we. ");
INSERT INTO kos_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","elan fahk nu sin mwet Israel lah kutena mwet su orala sie ma koluk ac kunausla kutena ma su LEUM GOD El sapkin ke tia etu lal, el fah enenu in akfalye oakwuk inge. ");
INSERT INTO kos_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Fin sie Mwet Tol Fulat pa orala ma koluk sac pwanang mwet uh wi eis mwata kac, el fah sang soko cow mukul fusr ma wanginna ma koluk ke mano, ac kisakin nu sin LEUM GOD ke sripen koluk lal. ");
INSERT INTO kos_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","El ac fah use cow soko ah nu ke acn in utyak nu in Lohm Nuknuk Mutal, filiya paol fin sifa uh, ac uniya ye mutun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Na Mwet Tol Fulat el fah eis kutu srahn cow soko ah, ac usak nu in Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","El fah isongya kufinpaol nu in srah sac, ac usrukya sisken nuknuk in lisrlisr mutal pacl itkosr. ");
INSERT INTO kos_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Na el fah sang kutu srah uh mosrwela koac ke sruwasrik in loang lun mwe keng in Lohm Nuknuk Mutal. El fah ukuiya srah lula nu pe loang se ma orekmakinyuk nu ke mwe kisa firir, su oan ke acn in utyak nu in Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","El ac fah eisla kiris nukewa ke cow mukul soko ah, kiris ke koanonsia uh, ");
INSERT INTO kos_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","kidney luo ac kiris kac, ac acn ma wo emeet ke esa uh. ");
INSERT INTO kos_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Mwet tol fah eis kiris inge ac esukak fin loang ma orekmakinyuk nu ke mwe kisa firir, oana ke el oru kiris itukla liki kosro in kisa ma anwuki nu ke mwe kisa in akinsewowo. ");
INSERT INTO kos_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Tusruktu el enenu in eis kolo ah, ikwa nukewa, sifa, nia, koanonsia uh weang pacna kainfohko uh, ");
INSERT INTO kos_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ac usla ma inge nukewa nu likin nien aktuktuk, nu ke sie acn aknasnasyeyukla, yen apat uh okwok we, ac el fah esukak fin etong uh. ");
INSERT INTO kos_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Fin mwet Israel nufon pa orala ma koluk ac kunausla sie sin ma sap lun LEUM GOD ke tia etu lalos, ");
INSERT INTO kos_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","na pacl se na ma eteyukyak ma koluk se elos orala uh, mwet in acn sac nufon ac fah use soko cow mukul fusr in mwe kisa ke ma koluk. Elos ac fah use nu ke Lohm Nuknuk Mutal, su nien muta lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ac mwet kol lun acn sac fah filiya paolos fin sifen cow soko ah, ac uniya insac. ");
INSERT INTO kos_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Mwet Tol Fulat el fah usak kutu srahn cow soko ah nu in Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","isongya kufinpaol nu kac, ac usrukya kutu nu sisken nuknuk in lisrlisr pacl itkosr. ");
INSERT INTO kos_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","El fah sang kutu srah uh mosrwela koac ke sruwasrik in loang lun mwe keng in Lohm Nuknuk Mutal, ac ukuiya srah lula nu pe loang se ma orekmakinyuk nu ke mwe kisa firir, su oan ke acn in utyak nu in Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Na el fah eis kiris ah nufon ac esukak fin loang uh. ");
INSERT INTO kos_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","El fah oru cow soko inge oana ke el oru nu ke cow in kisa nu ke ma koluk. In ouiya se inge el oru kisa nu ke ma koluk lun mwet uh, na ma koluk lalos fah nunak munas nu selos. ");
INSERT INTO kos_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Na el fah usla cow mukul soko ah nu likin nien aktuktuk uh ac esukak, oana ke el esukak cow in kisa nu ke ma koluk lal sifacna. Pa inge kisa in sisla ma koluk lun mwet in acn sac nufon. ");
INSERT INTO kos_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Fin mwet kol se pa orekma koluk ac kunausla sie sin ma sap lun LEUM GOD ke el tia etu, ");
INSERT INTO kos_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","na pacl se na ma fwackyang nu sel ma koluk sac, el ac fah use soko nani mukul ma wanginna ma koluk ke mano, in mwe kisa lal. ");
INSERT INTO kos_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","El fah filiya paol fin sifa uh, ac uniya ke layen epang in loang uh, yen kosro in kisa firir uh anwuki we. Kisa in eisla ma koluk se pa inge. ");
INSERT INTO kos_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Mwet tol el fah isongya kufinpaol ke srah in kosro soko ah, ac mosrwela koac ke sruwasrik ke loang uh, ac okoala srah lula uh nu pe loang uh. ");
INSERT INTO kos_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Na el fah esukak kiris nukewa kac fin loang uh, oana ke el esukak kiris ke mwe kisa in akinsewowo. In ouiya se inge mwet tol el fah oru mwe kisa nu ke ma koluk lun mwet kol sac, na ma koluk lal fah nunak munas nu sel. ");
INSERT INTO kos_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Fin siena sin mwet uh pa orala sie ma koluk ac kunausla sie sin ma sap lun LEUM GOD ke tia etu lal, ");
INSERT INTO kos_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","na tukunna ma koluk sac akkalemyeyuk nu sel, el fah use in mwe kisa lal soko nani mutan ma wanginna ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","El fah filiya paol fin sifen nani soko ah, ac uniya ke layen epang in loang sac, yen ma kosro nu ke mwe kisa firir uh anwuki we. ");
INSERT INTO kos_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Mwet tol el fah isongya kufinpaol in srahn kosro soko ah, ac mosrwela koac ke sruwasrik in loang uh, ac okoala ma lula uh nu pe loang uh. ");
INSERT INTO kos_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Na el fah eis kiris nukewa kac, oana ke kiris nukewa itukla liki kosro ma anwuki nu ke mwe kisa in akinsewowo, ac el fah esukak fin laong uh tuh in sie foul mwe akinsewowoye LEUM GOD. In ouiya se inge mwet tol el fah oru mwe kisa nu ke ma koluk lun mwet sac, ac ma koluk lal fah nunak munas nu sel. ");
INSERT INTO kos_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Sie mwet fin use soko sheep tuh in mwe kisa nu ke ma koluk, enenu na in soko sheep mutan ma wanginna ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","El fah filiya paol fin sifa ah, ac uniya ke layen nu epang sisken loang uh, yen ma kosro nu ke mwe kisa firir uh anwuki we. ");
INSERT INTO kos_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Mwet tol el fah isongya kufinpaol in srahn kosro soko ah, ac mosrwela koac ke sruwasrik in loang uh, ac okoala srah lula uh nu pe loang uh. ");
INSERT INTO kos_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Na el fah eisla kiris nukewa kac, oana ke kiris uh itukla liki sheep ma anwuki nu ke kisa in akinsewowo, ac el fah esukak fin loang uh wi mwe kisa mongo nu sin LEUM GOD. In lumah se inge mwet tol el fah oru mwe kisa nu ke ma koluk lun mwet sac, ac ma koluk lal fah nunak munas nu sel. ");
INSERT INTO kos_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Kisa nu ke ma koluk enenu in orek ke sripa inge. Sie mwet fin solsol in orek loh ke pacl in nununku a el tia fahkak nufon ma el liye ku lohng, ac fah oasr mwatal ac el fah eis kaiyuk kac. ");
INSERT INTO kos_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Sie mwet fin kahlye ku pusralla kutena ma su tia nasnas ke tia etu lal, yokna nu ke ma orakrak ku kosro ma misa, el ac fohkfokla ac oasr mwatal ke pacl se na el akilenak ma el orala. ");
INSERT INTO kos_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Sie mwet fin kahlye kutena ma tia nasnas ke sie pacna mwet saya ke tia etu lal, el ac eis mwata ke pacl se na el akilenak ma el orala. ");
INSERT INTO kos_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Mwet se fin orala sie fulahk oana ma pilasr, finne nu ke mea se, ac oasr mwatal ke pacl se na el akilenak ma el orala. ");
INSERT INTO kos_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Mwet se fin oasr mwatal ke ouiya inge, el enenu in fahkak ma koluk sac, ");
INSERT INTO kos_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ac in mwe kai nu ke ma koluk lal, el fah use nu sin LEUM GOD soko sheep mutan ku nani mutan tuh in sie mwe sang. Mwet tol el fah oru kisa nu ke ma koluk lun mwet sac. ");
INSERT INTO kos_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Mwet se fin tia ku in srukak soko sheep ku soko nani, el fah use nu sin LEUM GOD luo wuleoa, ku luo na wule, in moli ma koluk lal — sie in mwe kisa ke ma koluk ac ma se ngia nu ke mwe kisa firir. ");
INSERT INTO kos_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","El fah use ma inge nu sin mwet tol, su ac fah kisakin wule se nu ke kisa ke ma koluk meet. El ac fah koteya kwawa ac tia eisla sifa uh liki mano, ");
INSERT INTO kos_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ac osrokang kutu srah kac nu sisken loang uh. Srah lula uh nukewa ac fah okwokla nu pe loang uh. Kisa se inge ma in eisla ma koluk. ");
INSERT INTO kos_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Na el fah sang wule se akluo tuh in sie mwe kisa firir, fal nu ke oakwuk. In ouiya se inge mwet tol el fah oru kisa nu ke ma koluk lun mwet sac, na ma koluk lal fah nunak munas nu sel. ");
INSERT INTO kos_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Mwet se fin tia ku in srukak wuleoa luo ku wule luo, el fah use luo paun in flao tuh in mwe kisa ke ma koluk. El fah tia sang kutena oil in olive ku kutena mwe keng nu kac, mweyen ma inge mwe kisa ke ma koluk, ac tia mwe kisa wheat. ");
INSERT INTO kos_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","El fah use nu sin mwet tol, su ac fah eis sie lafluf inpaol tuh in sie mwe akul lah ma inge kewa kisakinyukyang nu sin LEUM GOD, ac el fah esukak fin loang uh tuh in sie kisa ke mwe mongo. Kisa in eisla ma koluk pa inge. ");
INSERT INTO kos_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","In ouiya se inge mwet tol el fah oru kisa nu ke ma koluk lun mwet sac, ac ma koluk lal fah nunak munas nu sel. Ma lula ke flao uh ma lun mwet tol, in oapana ke mwe kisa wheat. ");
INSERT INTO kos_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","LEUM GOD El sang oakwuk inge nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Mwet se fin oru ma koluk ke tia etu lal ke sripen el tia akfalye ip kunal ke ma mutal su fal elan sang nu sin LEUM GOD, el ac fah use soko sheep mukul ku soko nani mukul su wanginna ma koluk ke mano tuh in mwe kisa ke ma koluk lukma lal nu sin LEUM GOD. Lupan ma el ac moli uh ac fah orek fal nu ke ma oakwuki. ");
INSERT INTO kos_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","El enenu na in akfalyela lupa se ma el pahtle in molela uh, ac laesla ke percent longoul. El fah sang nu sin mwet tol, ac mwet tol fah kisakin sheep soko ku nani soko uh tuh in mwe kisa ke ma koluk lun mwet sac, na ma koluk lal fah nunak munas nu sel. ");
INSERT INTO kos_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Sie mwet fin orekma koluk ac kunausla kutena sin ma sap lun LEUM GOD ke tia etu lal, ac fah oasr mwatal ac el fah eis kaiyuk kac. ");
INSERT INTO kos_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","El enenu na in use nu yurin mwet tol soko sheep mukul ku nani mukul ma wanginna ma koluk ke mano, in akfalye ma koluk lukma lal. Lupan ma el ac moli uh, ac fah orek fal nu ke ma oakwuki. Mwet tol el fah oru mwe kisa nu ke ma koluk lun mwet sac, ac ma koluk lal fah nunak munas nu sel. ");
INSERT INTO kos_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ma se inge sie kisa in akfalyela ma koluk lukma se su el orala lain LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","LEUM GOD El sang oakwuk inge nu sel Moses: ");
INSERT INTO kos_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Sie kisa ac fah orek, mwet se fin orekma koluk lain LEUM GOD ke el srunga in folokin kutena ma su sie mwet Israel wial sang nu sel elan karingin, ku ke el pisrala kutena ma lal, ku kiapwella, ");
INSERT INTO kos_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ku el kaskas kikiap ke sie ma su tuhlac ac fulahk mu el tiana konauk. ");
INSERT INTO kos_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Mwet sac fin oru ma koluk inge ac akilenak tafongla lal, ac folokonma ma el pisrala, ku kikiap kac, ku ma su el karingin lun mwet, ku ma tuhlac su el konauk, ");
INSERT INTO kos_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ku kutena ma su el fulahk kikiap kac, el fah folokonma ma inge nukewa ac laesla ke percent longoul. El fah akfalye ma inge nu sin mwet se la uh, ke len se ma el akilenak tafongla lal. ");
INSERT INTO kos_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","El fah us nu yurin mwet tol soko sheep mukul ku nani mukul su wanginna ma koluk ke mano, tuh in mwe kisa in akfalye ma koluk lukma lal nu sin LEUM GOD. Lupan ma el ac moli uh, ac fah orek fal nu ke ma oakwuki. ");
INSERT INTO kos_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Mwet tol fah orek kisa ke ma koluk lun mwet sac, ac ma koluk lal ac fah nunak munas nu sel. ");
INSERT INTO kos_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","tuh elan fahkang nu sel Aaron ac wen natul ma sap nu ke mwe kisa firir. Sie kisa firir ac fah oanna fin loang uh ke fong fon se, ac e kac ac fah taranyuk in tiana kunla. ");
INSERT INTO kos_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Na in len tok an, mwet tol el fah nukum nuknuk oa loeloes ac turasis fototo loac, su kewana orek ke linen. El fah eisla apat mosroal su oan fin loang uh ac filiya sisken loang uh. ");
INSERT INTO kos_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Na el fah aolla nuknuk lal ac eis apat uh nu likin nien aktuktuk uh, nu ke sie acn aknasnasyeyukla. ");
INSERT INTO kos_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","E ma oan fin loang uh ac fah karinginyuk in firirrir na ac tia filfilla in kunla. Lotutang nukewa mwet tol el fah filiye etong fac, ac oakiya mwe kisa firir nu fac, ac esukak kiris ke mwe kisa in akinsewowo. ");
INSERT INTO kos_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","E fin loang uh ac fah taranyuk in firir pacl nukewa ac tiana filfilla in kunla. ");
INSERT INTO kos_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ma takinyukla inge pa oakwuk nu ke mwe kisa ke wheat: sie mwet tol in sou lal Aaron ac fah oru kisa ke wheat nu sin LEUM GOD, ke mutun loang uh. ");
INSERT INTO kos_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Na el fah lafusak kutu flao ac oil in olive ac mwe keng ma oan fac inpaol, ac esukak fin loang uh tuh in sie mwe akul lah nufonna ma inge kisayang nu sin LEUM GOD. Foulin mwe kisa inge mwe insewowo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ac ma lula uh Aaron ac wen natul fah orek bread kac ma wangin mwe akpulol kac, ac mongo ma inge in sie acn mutal, in kalkal lun Lohm Nuknuk su nien muta lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Mwe pulol ac fah tia orekmakinyuk in munan ma inge. LEUM GOD El sang tuh in pa inge ip lalos ke ma kisakinyuk fin loang uh. Ma inge arulana mutal, oana mwe kisa ke ma koluk, ku mwe kisa in akfalye ma koluk lukma. ");
INSERT INTO kos_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","In pacl nukewa fahsru, mukul ke fwil natul Aaron nukewa fah ku in kang ma inge tuh in ip lalos ke mwe mongo su kisakinyuk nu sin LEUM GOD. Kutena mwet saya su pusralla ma inge fah sun ongoiya ke kuiyen mutal lun ma inge. ");
INSERT INTO kos_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","LEUM GOD El sang oakwuk inge nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","nu ke pacl in akmusra sie mwet in sou lal Aaron nu ke wal lun mwet tol. Len se el akmusrala, el fah sang ma inge tuh in sie mwe kisa nu sin LEUM GOD: luo paun in flao (lupa se na ma kisakinyuk ke len nukewa ke mwe kisa ke wheat) — tafu ke lotutang ac tafu ke eku. ");
INSERT INTO kos_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Enenu in aryarak ke oil ac manman ke pan in furae, na kinkini ac kisakinyuk oana mwe kisa ke wheat, sie foul mwe insewowo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","In pacl nukewa fahsru uh, kisa se inge ac fah orek sin Mwet Tol Fulat nukewa in fwil natul Aaron. Mwe kisa inge ac fah isisyak nufonna, tuh in sie mwe kisa nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Wangin ip ke mwe kisa wheat su kisakinyuk sin mwet tol ac fah mongola. Ma nukewa kac fah isisyak. ");
INSERT INTO kos_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","elan sang nu sel Aaron ac wen natul ma sap inge su ma nu ke mwe kisa ke ma koluk. Kosro in kisa ke ma koluk ac fah anwuki ke layen epang ke sisken loang uh, yen ma kosro nu ke kisa firir uh anwuki we. Kisa na mutal se pa inge. ");
INSERT INTO kos_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Mwet tol ma oru kisa ke kosro inge fah mongo kac in sie acn mutal, in kalkal in Lohm Nuknuk Mutal, su nien muta lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Kutena mwet, ku kutena ma, su pusralla ikwen kosro inge ac fah sun ongoiya ke kuiyen mutal lun ma inge. Kutena nuknuk fin sroksroki ke srahn kosro inge, enenu in owola in sie acn mutal. ");
INSERT INTO kos_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Kutena tup eot ma orekmakinyuk in poeli ikwa inge enenu in fukulyuki, ac fin tup osra pa orekmakinyuk kac, enenu in ililla ac aknasnasyeyukla ke kof. ");
INSERT INTO kos_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Kutena mukul ke sou in mwet tol ku in mongo ke mwe kisa se inge; ma inge arulana mutal. ");
INSERT INTO kos_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Tusruktu fin kutena srah ke ma inge utukyak nu in Lohm Nuknuk Mutal ac orekmakinyuk in acn mutal in eisla ma koluk, ikwen kosro soko ah fah tia mongo — enenu in isisyak. ");
INSERT INTO kos_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Oakwuk inge ma nu ke kisa in akfalye ma koluk lukma, su arulana mutal. ");
INSERT INTO kos_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Kosro nu ke kisa se inge ac fah anwuki layen epang ke loang uh, yen ma mwe kisa nu ke kisa firir uh anwuki we, ac srah kac uh ac fah sang fwela siska akosr ke loang uh kewa. ");
INSERT INTO kos_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Kiris kac uh nukewa ac fah itukla ac kisakinyuk fin loang uh: pula kiris soko ah, kiris ma nokomla koanonsia, ");
INSERT INTO kos_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","kidney ac kiris kac, ac ip ma wo emeet ke esa uh. ");
INSERT INTO kos_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Mwet tol el fah esukak kiris nukewa fin loang uh tuh in sie mwe kisa mongo nu sin LEUM GOD. Kisa in akfalye ma koluk lukma se pa inge. ");
INSERT INTO kos_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Kutena mukul ke sou in mwet tol uh ku in kang ma inge, tusruktu enenu in mongo in sie acn mutal, mweyen ma inge arulana mutal. ");
INSERT INTO kos_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Oasr sie oakwuk ma orekmakinyuk nu ke kisa inge kewa: mwe kisa ke ma koluk ac mwe kisa in akfalye ma koluk lukma. Pa inge: ikwa kac uh ma nun mwet tol se ma orek kisa uh. ");
INSERT INTO kos_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Kolo ke soko kosro ma kisakinyuk nu ke mwe kisa firir uh ma lun mwet tol se ma orekma ke kisa uh. ");
INSERT INTO kos_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Mwe kisa wheat nukewa ma umla in sie stove, ku akmolyeyuk in sie pan, ku manman fin sie mwe manman, ma inge ma nu sin mwet tol se su kisakin nu sin God. ");
INSERT INTO kos_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Tusruktu mwe kisa wheat takmwek nukewa, finne kulamisyak ke oil ku pulamlam na, ac ma nu sin mwet tol natul Aaron nukewa — enenu in kitakatelik oana sie lupa nu selos nukewa. ");
INSERT INTO kos_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Ma oakwuk ten inge ma nu ke kisa in akinsewowo, su itukyang nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Sie mwet fin oru kisa se inge tuh in sie mwe kisa in sang kulo nu sin God, el enenu na in sang, wi kosro ma el ac kisakin, sie kisa ke bread ma wangin mwe pulol kac: finne srukwal in flao matoltol ma orek ke flao karak ke oil in olive, ku cake minini ma akmusrala ke oil in olive, ku cake ma orek ke flao karak ke oil in olive. ");
INSERT INTO kos_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Sayen ma inge, el fah kisakin pac lof in bread ma umla ac oasr mwe pulol kac. ");
INSERT INTO kos_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","El fah asang kais sie ip ke kain in bread inge kewa tuh in sie mwe kite srisrila nu sin LEUM GOD. Ma inge ac ma nu sin mwet tol se ma sang srah in kosro uh fwela loang uh. ");
INSERT INTO kos_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ikwen kosro ma kisakinyuk inge enenu na in mongola ke len se na ma kisaiyuk uh. Wangin sie ip kac ac fah oan nu ke lotu tok uh. ");
INSERT INTO kos_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Sie mwet fin use sie mwe kisa in akinsewowo in tuh akfalye sie wuleang, ku in mwe kisa ke lungse na lal sifacna, ac tia enenu in mongola nufon ke len se kisakinyuk uh — kutena ma lula kac ku in tufah mongola ke len se tok uh. ");
INSERT INTO kos_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Kutena ikwa ma srakna oan nu ke len se aktolu uh, fah enenu in isisyak. ");
INSERT INTO kos_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Kutena ip kac fin mongo ke len se aktolu, God El ac fah tia insewowo ke kisa sac. Ac fah wangin sripen kisa sac nu sin mwet se ma use uh, a ac fah pangpang mu tia nasnas, ac el su mongo kac ac fah oasr mwatal ac el fah eis kaiyuk kac. ");
INSERT INTO kos_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Ikwa sac fin tuh pusralla kutena ma su tia nasnas, fah tia enenu in mongo, a enenu in isisyak. Kutena mwet su aknasnasyeyukla, el ku in mongo ke ikwa sac, ");
INSERT INTO kos_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","tusruktu kutena mwet su tia aknasnasyeyuk fin kang, el fah tia sifil akilenyuk mu el sie sin mwet lun God. ");
INSERT INTO kos_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Oayapa, kutena mwet fin kang ikwa ke mwe kisa se inge tukun el kahlye kutena ma su tia nasnas, finne ma ke mwet se ku kosro soko, el fah tia sifil akilenyuk mu el sie sin mwet lun God. ");
INSERT INTO kos_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","LEUM GOD El sang nu sel Moses oakwuk inge, ");
INSERT INTO kos_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","ma nu sin mwet Israel. Wangin kiris ke cow, sheep ku nani ac fah mongo. ");
INSERT INTO kos_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Kiris ke soko kosro ma sifacna misa ku anwuki sin soko kosro sulallal fah tiana mongo, tusruktu ku in orekmakinyuk nu ke kutu sripa saya. ");
INSERT INTO kos_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Kutena mwet su kang kiris ke kosro ma ac orekmakinyuk nu ke mwe kisa mongo nu sin LEUM GOD ac fah tia sifil akilenyuk mu el sie sin mwet lun God. ");
INSERT INTO kos_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","In kutena acn mwet Israel muta we, elos fah tiana orekmakin srah ke won ku ke kosro nu ke mwe mongo. ");
INSERT INTO kos_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Kutena mwet su kunausla ma sap se inge fah tiana sifilpa akilenyuk mu el sie sin mwet lun God. ");
INSERT INTO kos_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","LEUM GOD El sang nu sel Moses oakwuk inge ");
INSERT INTO kos_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","ma nu sin mwet Israel. Kutena mwet su akoo in oru kisa in akinsewowo, el enenu in use sie ip kac tuh in sie mwe kite srisrila nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","El enenu in sifacna us ma inge in paol, oana sie mwe kisa mongo. El fah us kiris ke kosro soko ah wi iniwa uh ac sang tuh in sie mwe kite srisrila nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Mwet tol fah esukak kiris uh fin loang uh, tusruktu iniwa sac fah ma nu sin mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Lac ne layot ke kosro in kisa uh fah itukyang tuh in sie mwe kite srisrila ");
INSERT INTO kos_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","nu sin mwet tol su oru kisa ke srah ac kiris ke mwe kisa in akinsewowo. ");
INSERT INTO kos_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Iniwen kosro uh pa sie mwe kite srisrila, ac lac ne layot tok pa mwe sang srisrila se ma LEUM GOD El eisla sin mwet Israel ac sang nu sin mwet tol. Pa inge ma mwet Israel elos enenu in sang nu sin mwet tol ke pacl nukewa fahsru uh. ");
INSERT INTO kos_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Pa inge ip se ke mongo su kisakinyuk nu sin LEUM GOD ma tuh itukyang nu sel Aaron ac wen natul ke len se akmusrala elos nu ke mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ke len sac LEUM GOD El sapkin nu sin mwet Israel elos in sang nu selos ip inge ke mwe kisa uh. Oakwuk se inge ma mwet Israel elos enenu in akos ke pacl nukewa fahsru uh. ");
INSERT INTO kos_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ke ma inge, pa inge oakwuk ma orekla nu ke kisa firir, kisa ke wheat, kisa ke ma koluk, kisa in akfalye ma koluk lukma, kisa nu ke akmusra, ac kisa in akinsewowo. ");
INSERT INTO kos_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","LEUM GOD El sang ma sap inge nu sel Moses Fineol Sinai in acn mwesis, ke len se El fahkang nu sin mwet Israel in oru kisa lalos. ");
INSERT INTO kos_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Usalu Aaron ac wen natul kewa nu ke nien utyak nu in Lohm Nuknuk Mutal su nien muta luk, ac use nuknuk lun mwet tol, oil in akmusra, cow mukul fusr soko mwe kisa ke ma koluk, sheep mukul lukwa, ac sie fotoh in bread wangin mwe pulol kac. ");
INSERT INTO kos_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Na kom pangoneni mwet nukewa in acn se inge in fahsreni nu we.” ");
INSERT INTO kos_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moses el oru oana ma LEUM GOD El sapkin, ac ke mwet uh tukeni nu sie, ");
INSERT INTO kos_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","el fahk nu selos, “Ma su nga ac oru inge ma LEUM GOD El sapkin.” ");
INSERT INTO kos_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moses el pwanulak Aaron ac wen natul kewa, ac sap elos in yihla in aknasnasyalosla fal nu ke ouiya lalos. ");
INSERT INTO kos_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","El nokmulang Aaron ke nuknukfon lun mwet tol ac nuknuk oa loeloes se, ac losya infulwal ke sie mwe lohl. El filiya nuknuk lun mwet tol su pangpang ephod nu facl, ac kapreni nu ke infulwal ke sie pel otwot na wowo. ");
INSERT INTO kos_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","El sang mwe loeyuk iniwa nu facl, ac filiya Urim ac Thummim loac. ");
INSERT INTO kos_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","El oakiya sie susu in mwet tol fin sifal, ac sang sie mwe yun gold in oan meet ke susu sac, ma in akilen mutal lun akmusra se inge, oana ma LEUM GOD El sapkin nu sel. ");
INSERT INTO kos_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Na Moses el eis oil in akmusra ac osrokang nu fin Lohm Nuknuk Mutal, nien muta lun LEUM GOD, ac nu fin ma nukewa su oan loac. Ke el oru ouinge el kisakunang ma inge nukewa nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","El eis kutu oil uh ac osrokang nu ke loang sac pacl itkosr wi kufwa nukewa kac, ac nu ke pesin sac ac ma loangeya, tuh elan kisaela ma inge nukewa nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","El ukuiya kutu oil in akmusra nu fin sifal Aaron in akmusraella nu ke mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Tok, Moses el kolma wen natul Aaron inge, ac nokmulosyang ke nuknukfon lun mwet tol, ac losya infulwalos ke mwe lohl, ac sunya insifalos ke susu in mwet tol, oana ke LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Na Moses el use cow mukul fusr mwe kisa ke ma koluk, ac Aaron ac wen natul elos filiya paolos fin sifal. ");
INSERT INTO kos_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moses el uniya ac eis kutu srah, sang kufinpaol nu kac ac sang mosrwela koac ke sruwasrik in loang uh in kisaela, na el okoala srah lula uh nu pe loang uh. Ouinge el kisaela ac aknasnasyela loang uh. ");
INSERT INTO kos_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Moses el eisla kiris nukewa ke koanonsia, ip se ma wo emeet ke esa, ac kidney wi kiris kac, ac esukak ma inge nukewa fin loang uh. ");
INSERT INTO kos_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","El eis ma nukewa lula ke cow soko: kolo, ikwa, ac koanonsia, ac esukak likin nien aktuktuk, oana ke LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Toko, Moses el use sheep mukul soko nu ke mwe kisa firir, ac Aaron ac wen natul elos filiya paolos fin sifal. ");
INSERT INTO kos_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Moses el uniya ac sang srah uh fwela siska akosr ke loang uh kewa. ");
INSERT INTO kos_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ke sipsipi sheep soko ah tari, na Moses el esukak sifa ac kiris ac ip lula kac. ");
INSERT INTO kos_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ac tukun owola koanonsia ac nia uh ke kof, Moses el esukak sheep nufon soko ah fin loang uh, tuh in sie mwe kisa firir, in oana LEUM GOD El sapkin nu sel. Foulin mwe kisa se inge mwe insewowo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ac Moses el use sheep mukul soko aklukwa, su ma nu ke akmusra lun mwet tol, na Aaron ac wen natul elos filiya paolos fin sifal. ");
INSERT INTO kos_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moses el uniya ac eis kutu srah kac ac filiya ke acn fisrasrsrasr ke lac srac layot kacl Aaron, fin kufinpo lulap lac paol layot, ac fin kufinne lulap lac nial layot. ");
INSERT INTO kos_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Na el pwanak wen natul Aaron, ac filiya kutu srah ke acn fisrasrsrasr ke sraclos layot, kutu fin kuf lulap ke lac po layot selos, ac fin kuf lulap ke lac ne layot kaclos. Na Moses el fwela siska akosr ke loang uh kewa ke srah lula uh. ");
INSERT INTO kos_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","El eis kiris uh, pula kiris soko ah, kiris nukewa ma nokomla koanonsia uh, ip se ma wo emeet ke esa uh, kidney ac kiris kac, ac lac ne layot uh. ");
INSERT INTO kos_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Na el eis soko lof in bread liki fotoh in bread tia akpulol ma kisakinyukyang nu sin LEUM GOD, soko lof orekla ke oil, ac sie cake minini, ac el filiya fin kiris ac lac ne layot. ");
INSERT INTO kos_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","El filiya mwe mongo inge nukewa nu inpaol Aaron ac wen natul, ac elos sang tuh in sie mwe kite srisrila na nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Na Moses el eisla mongo inge selos, ac esukak fin loang uh, lucng liki mwe kisa firir, oana sie kisa nu ke akmusra ke mwet tol. Kisa in mwe mongo se pa inge, ac foul kac mwe insewowo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Na Moses el eis iniwa sac ac sang tuh in sie mwe kite srisrila nu sin LEUM GOD. Pa inge ip se itukyang lal Moses ke sheep in akmusra uh. Moses el orala ma nukewa oana ke LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moses el eis kutu oil in akmusra ac kutu srah ma oan fin loang uh ac osrokang nu facl Aaron ac wen natul uh kewa, oayapa nu fin nuknuk lalos. Ouinge el aknasnasyalosla ac nuknuk lalos nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moses el fahk nu sel Aaron ac wen natul, “Us ikwa inge nu ke acn in utyak nu in Lohm Nuknuk Mutal, nien muta lun LEUM GOD, poeleak, ac mongo kac we, wi bread su oan in fotoh in kisa nu ke akmusra, oana LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Esukak kutena ikwa ku bread ma ac lula uh. ");
INSERT INTO kos_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Komtal ac fah tiana illa liki Lohm Nuknuk Mutal sac ke len itkosr, nwe ke na ouiya nukewa ma ac orek ke akmusra lomtal an safla. ");
INSERT INTO kos_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","LEUM GOD El sapkin kut in oru ma kut oru misenge, in eela ma koluk lomtal. ");
INSERT INTO kos_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Komtal enenu in mutana ke sisken mutunoa in Lohm Nuknuk uh ke len itkosr ac fong itkosr, ac oru ma LEUM GOD El sapkin uh. Komtal fin tia, komtal ac fah misa. Pa inge ma LEUM GOD El sapkin nu sik.” ");
INSERT INTO kos_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ke ma inge Aaron ac wen natul eltal oru ma nukewa ma LEUM GOD El sapkin sel Moses. ");
INSERT INTO kos_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Len se tukun aksafyeyukla alu in akmusra, Moses el pangnolma Aaron ac wen natul kewa, ac mwet kol lun mwet Israel nukewa. ");
INSERT INTO kos_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","El fahk nu sel Aaron, “Eis soko cow mukul fusr ac soko sheep mukul ma wanginna ma koluk ke mano, ac kisakunang nu sin LEUM GOD: cow mukul soko an in mwe kisa ke ma koluk, ac sheep mukul soko an in mwe kisa firir. ");
INSERT INTO kos_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Na kom fahkang nu sin mwet Israel in eis soko nani mukul tuh in mwe kisa ke ma koluk, ac soko cow fusr yac se matwa ac soko pac sheep mukul ma yac se matwa, ma wangin ma koluk ke mano, tuh in mwe kisa firir, ");
INSERT INTO kos_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ac soko cow mukul ac soko sheep mukul tuh in mwe kisa in akinsewowo. Elos in kisakin ma inge nu sin LEUM GOD wi kisa in wheat ma karyak ke oil. Elos enenu in oru ma inge mweyen LEUM GOD El ac sikyang nu selos misenge.” ");
INSERT INTO kos_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Elos usani ma nukewa ma Moses el sapkin inge nu ke mutun Lohm Nuknuk Mutal, ac mwet in acn sac nufon fahsreni nu we in alu nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ac Moses el fahk, “LEUM GOD El sapkin kowos in oru ma inge nukewa, tuh wolana lun kalem lal fah sikme nu suwos.” ");
INSERT INTO kos_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Na el fahk nu sel Aaron, “Fahla nu ke loang uh ac oru kisa ke ma koluk ac kisa firir in eela ma koluk lom ac ma koluk lun mwet uh. Oru kisa inge in eela ma koluk lun mwet uh, oana LEUM GOD El sapkin.” ");
INSERT INTO kos_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaron el som nu ke loang uh ac uniya cow mukul fusr soko su ma nu ke kisa in ma koluk lal sifacna. ");
INSERT INTO kos_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Wen natul elos use srah nu yorol, ac el isongya kufinpaol nu loac, ac sang kutu mosrwela koac ke sruwasrik in loang uh, ac okoala srah lula uh nu pe loang uh. ");
INSERT INTO kos_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Na el esukak kiris, ac kidney, ac ip se ma wo emeet ke esa uh fin loang uh, oana ke LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Tusruktu el esukak ikwe ac kolo uh likin nien aktuktuk uh. ");
INSERT INTO kos_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","El uniya kosro soko su ac ma nu ke mwe kisa firir lal sifacna. Wen natul elos use srah uh nu yorol, ac el sang fwela siska akosr ke loang uh kewa. ");
INSERT INTO kos_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Elos sang sifa uh ac ip saya ke kosro soko ah kewa nu sel, na el esukak fin loang uh. ");
INSERT INTO kos_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Na el ohlla koanonsia ac nia uh, ac esukak fin loang uh lucng lik ma nukewa saya nu ke kisa firir uh. ");
INSERT INTO kos_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Toko el oru kisa lun mwet uh. El eis nani soko, su ma ac kisakinyuk nu ke ma koluk lun mwet uh, uniya, ac kisai oana ke el oru ke kisa in ma koluk lal sifacna. ");
INSERT INTO kos_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","El oayapa use kosro nu ke kisa firir, ac kisai oana ke ma oakwuk nu kac. ");
INSERT INTO kos_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","El orala pac mwe kisa ke wheat ac eis sie lafluf in flao inpaol, ac esukak fin loang uh. (Ma inge ma sayen na kisa firir su orek len nukewa.) ");
INSERT INTO kos_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","El uniya cow mukul soko ah, ac sheep mukul soko ah tuh in mwe kisa in akinsewowo lun mwet uh. Wen natul elos use srah uh nu sel, ac el sang fwela siska akosr ke loang uh kewa. ");
INSERT INTO kos_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Aaron el filiya ip kiris ke cow soko oayapa ke sheep mukul soko ");
INSERT INTO kos_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","tuh in oan fin iniwen kosro uh, ac usla nukewa nu fin loang uh. El esukak kiris uh fin loang uh ");
INSERT INTO kos_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ac sang iniwa uh kewa, ac nia leyot uh kewa, tuh in sie mwe sang sriyukla nu sin LEUM GOD inen mwet tol, oana ke Moses el sapkin. ");
INSERT INTO kos_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ke Aaron el aksaflayela kisa inge nukewa, na el kolak paol nu fin mwet uh ac akinsewowoyalosla, na el fani liki acn sac. ");
INSERT INTO kos_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moses ac Aaron ilyak nu in Lohm Nuknuk Mutal, nien muta lun LEUM GOD, ac ke eltal illa, na eltal akinsewowoye mwet uh, ac kalem saromrom lun LEUM GOD sikyang nu fin mwet e nukewa. ");
INSERT INTO kos_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","In kitin pacl ah na LEUM GOD El supwama sie e, esukak mwe kisa firir ac ip ma kiris nukewa su oan fin loang uh. Ke mwet uh liye ma inge elos nukewa sala ac faksufi nwe ke mutalos sun infohk uh. ");
INSERT INTO kos_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab ac Abihu, wen natul Aaron, eltal eis pan in ta e laltal, sang mulut firir nu loac, ac sang pac mwe keng nu kac, na eltal sang nu sin LEUM GOD. Tusruktu e se inge tiana mutal, mweyen LEUM GOD El tiana sapkin eltal in oru. ");
INSERT INTO kos_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","In kitin pacl ah na, LEUM GOD El supwama e, ac esukultalak, na eltal misa na insac ye mutun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Na Moses el fahk nu sel Aaron, “Pa inge kalmen kas lun LEUM GOD ke El fahk mu, ‘Elos nukewa su kulansap nu sik, enenu in sunakin mutal luk. Nga fah akkalemye wolana luk nu sin mwet luk.’” A Aaron el mihslana tia kas. ");
INSERT INTO kos_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Na Moses el pangnolma Mishael ac Elzaphan, wen luo natul Uzziel, sie sin mwet tumal Aaron, ac fahk nu seltal, “Fahsru ac usla monin mwet luo wiomtal inge liki Lohm Nuknuk Mutal, ac fuhleltalu likin nien aktuktuk uh.” ");
INSERT INTO kos_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ouinge eltal tuku, ac sruokya nuknuk lun mano misa luo ah, ac usaltalla nu likin nien aktuktuk uh, oana Moses el sapkin. ");
INSERT INTO kos_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Na Moses el fahk nu sel Aaron ac nu sel Eleazar ac Ithamar, luo pac sin wen natul, “Nimet komtal tui in kawiya insifomtal, ku seya nuknuk lomtal an in akkalemye lah komtal muta in asor. Komtal fin oru ouinge, komtal ac misa, ac LEUM GOD El ac kasrkusrak sin mwet in acn se inge nufon. Tusruktu mwet Israel wiowos nukewa elos ku in tungi mwet inge su misa ke sripen e se su LEUM GOD El supwama. ");
INSERT INTO kos_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Nimet komtal tufoki liki acn in utyak lun Lohm Nuknuk Mutal, tuh komtal fin tufoki komtal ac misa, mweyen akmutalyeyukla komtal tari ke oil in akmusra lun LEUM GOD.” Ouinge eltal kewa oru oana Moses el fahk. ");
INSERT INTO kos_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","LEUM GOD El kaskas nu sel Aaron ac fahk, ");
INSERT INTO kos_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Kom ac wen nutum fah tiana nim wain, ku kutena mwe nim ku, ke pacl ma komtal utyak nu in Lohm Nuknuk Mutal, nien muta luk, mweyen komtal fin oru ouinge komtal fah misa. Ma sap se pa inge, ma in karinginyuk sin fwil nutum nukewa, ");
INSERT INTO kos_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","tuh kom fah ku in akilen inmasrlon ma lun God ac ma su mwet uh orekmakin in pacl nukewa, oayapa inmasrlon ma aknasnasyeyukla ac ma su tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Kowos enenu in luti nu sin mwet Israel ma sap nukewa su nga sang nu sel Moses elan fahk nu suwos.” ");
INSERT INTO kos_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moses el fahk nu sel Aaron ac wen luo natul su lula, Eleazar ac Ithamar, “Eis mwe kisa wheat ma lula ke mwe mongo ma kisakinyuk nu sin LEUM GOD, sang orauk kutu bread ma wangin mwe pulol kac, ac mongo kac sisken loang uh, mweyen kisa se inge arulana mutal. ");
INSERT INTO kos_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mongo kac in sie acn mutal; pa inge ip lom ac wen nutum ke mongo ma kisakinyuk nu sin LEUM GOD. Pa ingan ma LEUM GOD El sapkin nu sik. ");
INSERT INTO kos_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Tusruktu kom ac sou lom ku in kang iniwa se ac nia se ma itukyang tuh in mwe kite srisrila ac mwe sang srisrila nu sin LEUM GOD inen mwet tol. Kom ku in kang ma inge in kutena acn ma aknasnasyeyukla. Mwe sang inge itukot nu sum ac tulik nutum tuh in pa inge ip lomtal liki mwe kisa in akinsewowo sin mwet Israel. ");
INSERT INTO kos_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Elos fah use iniwa sac ac lac nia uh ke pacl se kiris uh kisakinyuk tuh in sie kisa mongo nu sin LEUM GOD. Ip inge ma lom ac tulik nutum mwe tok, oana ke LEUM GOD El sapkin.” ");
INSERT INTO kos_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moses el siyuk nani soko nu ke kisa ke ma koluk, ac konauk lah isisyak tari. Ma se inge pwanang el kasrkusrak sel Eleazar ac Ithamar, ac el fahk, ");
INSERT INTO kos_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Efu komtal ku tia kangla mwe kisa nu ke ma koluk in sie acn mutal? Ma se inge arulana mutal, ac LEUM GOD El sot nu sumtal in tuh sisla ma koluk lun mwet nukewa in acn se inge. ");
INSERT INTO kos_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ke sripen srah sac tuh tia utukyak nu in Lohm Nuknuk Mutal uh, na mu na komtal in kanglana nani soko ah lik ah, oana ke nga sap ah.” ");
INSERT INTO kos_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Na Aaron el fahk, “Ku nga funu kangla mwe kisa nu ke ma koluk misenge, ya LEUM GOD El lukun insewowo kac? Mwet uh oru mwe kisa nu ke ma koluk lalos nu sin LEUM GOD misenge, ac elos use pac mwe kisa firir lalos. Ne ouinge, a ongoiya uh srakna sikyak nu sik.” ");
INSERT INTO kos_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ke Moses el lohng ma inge, el misla kac. ");
INSERT INTO kos_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","LEUM GOD El sang nu sel Moses ac Aaron oakwuk ten inge, ");
INSERT INTO kos_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","su ma nu sin mwet Israel. Kowos ku in kang kutena kain kosro finmes ");
INSERT INTO kos_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ma sengelik falka, su oayapa sifil kontini ma el kangla. ");
INSERT INTO kos_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Tusruktu kowos fah tia kang kosro inge: camel, mweyen el finne sifil kontini ma el kangla, tuh tia sengelik falkal, na pa el tia nasnas nu suwos; ");
INSERT INTO kos_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","oayapa koni, el finne sifil kontini ma el kangla, tuh tia sengelik falkal, na pa el tia nasnas nu suwos; ");
INSERT INTO kos_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","rabbit, el finne sifil kontini ma el kangla, tuh tia sengelik falkal, na pa el tia nasnas nu suwos. ");
INSERT INTO kos_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Nimet kang pig. Finne sengelik falkal, tuh el tia sifil kontini ma el kangla, na pa el tia nasnas nu suwos. ");
INSERT INTO kos_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Nimet kang kain in kosro inge ku pusral mano misa lalos. Elos tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Kowos ku in kang kutena ik ma oasr enga ac unac, ");
INSERT INTO kos_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","tusruktu kutena ma moul ma muta in kof su wangin enga ac unac, fah tiana mongo. ");
INSERT INTO kos_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Kain ma moul ingan nukewa fac tia nasnas nu suwos. Kowos fah tiana kang ma inge ku pusral mano misa lalos. ");
INSERT INTO kos_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Kowos fah tiana kang kutena ma su muta in kof uh ma wangin enga ac unac kac. ");
INSERT INTO kos_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Kain in won inge ac fah mwe srungayuk nu suwos, ac kowos fah tiana kang: eagle, kain vulture nukewa, ");
INSERT INTO kos_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","buzzard, falcon, ");
INSERT INTO kos_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","kain raven nukewa, ");
INSERT INTO kos_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ostrich, seagull, kain hawk nukewa, ");
INSERT INTO kos_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","cormorant, kain owl nukewa, ");
INSERT INTO kos_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","pelican, osprey, ibis, ");
INSERT INTO kos_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","stork, heron, hoopoe, ac fak. ");
INSERT INTO kos_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Won srisrik ma orakrak nukewa ma oasr posohksok kac, ma inge tia nasnas, ");
INSERT INTO kos_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","sayen ma su ku in sro ke nia. ");
INSERT INTO kos_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Kowos ku in kang srisr in eku, kwot srisrik, ac kain locust nukewa. ");
INSERT INTO kos_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Tusruktu ma srisrik nukewa saya ma oasr posohksok kac, ac ku pac in orak uh, fah lumweyuk mu tia nasnas nu suwos. ");
INSERT INTO kos_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ac ma inge ac fah oru kowos in tia nasnas: kutena mwet su pusralla monin ma misa in masrlon ma inge, fah tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ac kutena mwet su us kutena ipin ma misa inge fah ohlla nuknuk lal, tusruk elos ac tiana nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Kosro nukewa ma sengelik falka ku tia sifil kontini ma el kangla, ac fah tia nasnas nu suwos. Mwet nukewa su kahl monin sie sin ma inge fah tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Kosro nukewa ma fahsrkin ye nia ac inpaol, ma inge tia nasnas nu suwos. Kutena mwet su pusral mano misa lun kutena kosro inge fah tia nasnas nwe ke ekela, ");
INSERT INTO kos_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ac mwet se su us mano misa lun ma inge fah ohlla nuknuk lal, tusruk el fah tia nasnas nwe ke ekela. Ma inge tia nasnas nu suwos. ");
INSERT INTO kos_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Pa inge ma tia nasnas nu suwos inmasrlon ma orakrak ac pus suna fin faclu: weasel, kisrik in pot, kain kinoul nukewa, ");
INSERT INTO kos_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","srosrok, crocodile finmes, ac chameleon. ");
INSERT INTO kos_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Kutena mwet su pusralla ma inge ku mano misa lalos, fah tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ac kutena ma su mano misa inge putatla nu fac, ac fah tia nasnas — finne ke sak, ku nuknuk, ku kulun kosro, ku pak, aok kutena ma su orekmakinyuk nu ke kutena sripa. Ac fah enenu in isongyuki nu in kof uh, tusruktu ac fah tia pacna nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ac manolos fin putatyang nu in sie tup orekla ke kle, na ma nukewa ma oan in tup sac fah tia nasnas, ac kowos fah fukulya tup sac. ");
INSERT INTO kos_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Kutena mwe mongo ma fal in mongo, tuh okwoki kof liki kain tup sac nu kac, ac fah tia nasnas, ac kutena ma su ku in nimnim ma oan in kain tup sac, fah tia pac nasnas. ");
INSERT INTO kos_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Kutena ma su mano misa inge putatla nu fac, fah tia nasnas — fin sie nien manman ku sie mwe um ma orekla ke kle, enenu na in fokfoki. ");
INSERT INTO kos_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Tusruktu sie unon in kof ku sie lufin neinyuk kof ac nasnas na. Ma saya nukewa su pusralla mano misa inge fah tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Sie sin ma misa inge fin putatla nu fin fita ma akoeyuk in yoki, fita ingan srakna nasnas. ");
INSERT INTO kos_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Tusruktu fita ingan fin isosu nu in kof, ac sie sin ma tia nasnas ingan putatla nu in kof sac, na fita ingan fah tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Kutena kain kosro ma wo in mongo uh fin misa, na kutena mwet su pusralla fah tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Na kutena mwet fin kang kutena ip ke kosro misa inge, el enenu in ohlla nuknuk lal, tusruktu el ac fah tia nasnas nwe ke ekela. Ac kutena mwet su us mano misa sac, el enenu in ohlla nuknuk lal, tusruktu el ac srakna tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Kowos fah tia kang kutena sin ma srisrik ma forfor fin faclu, ");
INSERT INTO kos_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","finne ma orakrak, ku ma fahsr ke nia akosr, ku ke nia pus liki akosr. ");
INSERT INTO kos_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Nimet sifacna akfohkfokye kowos in kang kutena sin ma inge. ");
INSERT INTO kos_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Nga pa LEUM GOD lowos, ac kowos enenu in liyekowosyang sifacna tuh kowos in mutal, mweyen nga mutal. ");
INSERT INTO kos_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Nga pa LEUM GOD su uskowosme liki Egypt tuh nga fah God lowos. Kowos enenu in mutal, mweyen nga mutal. ");
INSERT INTO kos_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Na pa inge ma sap ke kosro ac won, ac ke ma nukewa ma muta in kof uh, ac ma nukewa ma forfor fin acn uh. ");
INSERT INTO kos_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Kowos fah arulana taran tuh kowos in ku in akilen inmasrlon ma su nasnas ac ma su tia nasnas, inmasrlon kosro ma ac ku in mongo, ac ma su tia mongo. ");
INSERT INTO kos_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","LEUM GOD El sang nu sel Moses oakwuk inge, ");
INSERT INTO kos_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","su ma nu sin mwet Israel. Ke len itkosr tukun sie mutan el oswela sie wen, el tia nasnas, oapana ke el tia nasnas ke pacl in mas mutan lal. ");
INSERT INTO kos_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ke len se akoalkosr, tulik sac fah kosrkosrla. ");
INSERT INTO kos_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Len tolngoul tolu pac toko, na mutan sac fah nasnasla liki fahla lun srahn sial. El fah tia kahlye kutena ma su mutal, ku ilyak nu in Lohm Nuknuk Mutal nwe ke pacl se aknasnas lal uh safla. ");
INSERT INTO kos_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ke len singoul akosr tukun sie mutan el oswela sie tulik mutan, el tia nasnas, oapana ke pacl in mas mutan lal. Tukun len onngoul onkosr pac tok, na el fah nasnas liki fahla lun srahn sial. ");
INSERT INTO kos_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Ke safla pacl in aknasnas lal, finne nu ke tulik mukul se ku nu ke tulik mutan se, mutan sac el fah use nu yurin mwet tol, nu ke acn in utyak lun Lohm Nuknuk Mutal nien muta lun LEUM GOD, soko sheep fusr yac se matwa, tuh in sie mwe kisa firir, ac sie wule ku sie wuleoa nu ke kisa ke ma koluk. ");
INSERT INTO kos_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Mwet tol el ac fah oru kisa lun mutan sac nu sin LEUM GOD, ac oru alu in eisla ma fohkfok lal lukel, na el fah nasnasla. Pa inge ma sie mutan el enenu in oru tukun el oswela sie tulik. ");
INSERT INTO kos_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Mutan sac fin tia ku in srukak soko sheep fusr, el fah use luo wule ku luo wuleoa — sie nu ke kisa firir ac sie nu ke kisa lun ma koluk. Ac mwet tol el fah oru alu in eisla ma fohkfok lal, na mutan sac fah nasnasla. ");
INSERT INTO kos_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","LEUM GOD El sang nu sel Moses ac Aaron oakwuk ten inge. ");
INSERT INTO kos_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Mwet se fin oasr palang se ku faf se ku ruf se ke manol, su ma ac ku in ekla nu ke sie mas yohk, ma ac sensenkinyuk, na ac fah utukla el nu yurin mwet tol in sou lal Aaron. ");
INSERT INTO kos_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Mwet tol sac fah lohang ac liye sring se ke manol uh, na unac kac an fin fasrfasrla ac faf sac aryurla loal liki kolo ma rauneak acn sac, na kalem lah sie mas na sensen pa oan sel uh, ac mwet tol el fah fahkelik ac akkalemye lah mwet sac tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Tusruktu sring se ke manol uh fin fasrfasr a tiana aryurla in loal liki kolo ma rauneak uh, ac unac kac uh tiana fasrfasrla, na mwet tol sac fah srela mwet uh ke len itkosr. ");
INSERT INTO kos_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Mwet tol fah sifilpa liyal ke len se akitkosr, ac el fin liye mu sring se ke manol uh nuna oaya ah na, ac tiana yokelik, na el fah srella ke itkosr pac len uh. ");
INSERT INTO kos_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Mwet tol el fah sifilpa liyal ke len se akitkosr, ac sring se kacl uh fin misa in muta uh, ac tiana yokelik, mwet tol el fah akkalemye lah mwet sac nasnas — sring se na pa ma sac. Mwet sac fah ohlla nuknuk lal, na el nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Tusruktu sring sac fin yokelik tukun mwet tol sac tuh liyal tari ac fahkak mu el nasnas, na mwet sac el enenu in sifilpa foloko nu ye mutun mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Mwet tol el fah sifilpa liyal, ac sring sac fin yokelik, na mwet tol el fah akkalemye lah el tia nasnas — mas na sensen se pa oan sel uh. ");
INSERT INTO kos_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Mwet se fin oasr mas na sensen se ke manol, ac fah utuku el nu yurin mwet tol, ");
INSERT INTO kos_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","su ac fah arulana tuni ac liye. Fin oasr palang se momoul inmuta ke manol, ac orala unac ke manol in fasrfasrla ac oasr sronin uswanen kac, ");
INSERT INTO kos_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","kalem lah oasr sie mas sensen yorol. Na mwet tol el fah fahkak lah mwet sac el tia nasnas. Tia enenu in kauli el, mweyen kalem tari lah el tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Palang sac fin orakelik afinya mwet sac ke insifali nwe ke nial, ");
INSERT INTO kos_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","mwet tol el ac enenu in sifil liyal. El fin konauk tuh pwaye mas sac afunla manol nufon, el fah fahkak lah mwet sac nasnas. Kolo kacl uh nufon fin ekla fasrfasr, na el nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Tusruktu ke pacl se na sie palang ke manol uh aryurla, na el tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Mwet tol el fah sifilpa liyal, ac el fin liye tuh aryurla ma se ke manol, na el ac fahkak lah mwet sac tia nasnas. Kalmen aryurla pa oasr mas sensen yorol, ac mwet sac tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Tusruktu ma se ke manol uh fin mahla ac sifil fasrfasrla, na mwet sac enenu in som nu yurin mwet tol, ");
INSERT INTO kos_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","su ac fah sifil liye. Ma se ke manol fin fasrfasrla, na el nasnas, ac mwet tol el fah fahkulak lah el nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Fin faf se oan ke sie mwet nwe mahla, ");
INSERT INTO kos_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ac tok kutu, pulol fasrfasr se, ku tuhn srusra se sikyak ke inken faf se meet ah, na mwet sac enenu in som nu yurin mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Mwet tol el ac fah liyal, ac fin acn se ma fasrfasrla uh luman loali liki ikwa ma rauneak uh, ac unac kac uh fasrfasrla, na mwet tol el fah fahkulak lah mwet sac el tia nasnas. Kalem lah mas sensen nu ke kolo se pa sikyak in faf sac. ");
INSERT INTO kos_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Tusruktu mwet tol el fin liye, ac konauk lah unac kac tiana fasrfasrla, ac tia pac loali liki kolo siska ah a misa inmuta, mwet tol el fah srella elan mukena muta ke len itkosr. ");
INSERT INTO kos_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Acn ma tuhnla uh fin orakelik, na mwet tol el ac fahkulak lah mwet sac tia nasnas. Mas sensen se pa yorol. ");
INSERT INTO kos_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Tusruktu fin oanna tia ekla ac tia pac yokelik, na kalem lah inken faf sacna pa inge, ac mwet tol el fah fahkak lah mwet sac nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ke kain pacl se ma sie mwet el folla, ac acn ma folla kacl uh fin fasrfasrla ku srusrala inmuta uh, ");
INSERT INTO kos_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","mwet tol el fah liyal. Fin unen acn sac fasrfasrla ac aryurla loal liki kolo siska uh, na kalem lah mas sensen nu ke kolo se pa sikyak ke acn se ma folla, ac mwet tol el fah fahkak lah mwet sac tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Tusruktu unen acn sac fin tiana fasrfasrla ac tia pac aryurla loal liki kolo siska ah, ac inmuta uh misa na, na mwet tol sac fah srella ke len itkosr. ");
INSERT INTO kos_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Mwet tol el fah sifilpa liyal tukun len itkosr, ac fin yokelik ma sac na kalem lah mas sensen nu ke kolo se pa kacl uh, ac mwet tol el fah fahkak lah mwet sac tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Tusruktu acn sac fin tiana ekla, ac tiana yokelik, ac inmuta uh misa na, na kalem mu tia mas sensen se. Mwet tol el fah akkalemye lah mwet sac nasnas, mweyen inken na fol sac pa kacl uh. ");
INSERT INTO kos_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Fin mukul se ku mutan se oasr palang se ke sifal ku kapin oalul, ");
INSERT INTO kos_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","mwet tol el fah liyal ac tuni. Fin palang sac tuh aryurla loal liki kolo siska uh, ac unac ke acn sac luman rangrangla ac pueni, na kalem mu mas sensen nu ke kolo pa sel uh, ac mwet tol el fah akkalemye lah mwet sac tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ke mwet tol sac el fin liyal, tuh na ma se ke manol uh tiana luman loali liki kolo ma rauneak uh, ac srakna wangin unac fokoko kac, na el fah srella liki inmasrlon mwet uh ke len itkosr. ");
INSERT INTO kos_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Mwet tol el fah sifilpa liye ma se ke manol uh ke len se akitkosr, ac fin tiana yokelik ac wangin pacna unac luman rangrang kac, ac tia pacna aryurla loal liki siska uh, ");
INSERT INTO kos_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","na mwet sac fah resaela sifal, sayen acn se ma palang sac oan kac. Mwet tol el fah sifil srella ke len itkosr pac. ");
INSERT INTO kos_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ke len se akitkosr, mwet tol el fah sifilpa liye palang se kacl uh. Fin tuh tiana yokelik ac tia pac luman aryurla loal liki kolo siska uh, na el fah fahkak lah mwet sac nasnas. Mwet sac ac fah ohlla nuknuk lal uh, na el fah nasnasla. ");
INSERT INTO kos_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Tusruktu palang sac fin sifilpa yokelik tukun akkalemyeyuk mu mwet sac nasnas, ");
INSERT INTO kos_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","na mwet tol el fah sifilpa liyal. Palang sac fin yokelik, el tia enenu in suk lah rangrangla unac kac ah. Kalem na lah mwet sac tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Tusruktu fin mwet tol el liye mu palang sac tiana yokelik, ac unac na fokoko kapak kac, na kalem lah palang sac mahla, ac mwet tol el fah fahkak lah mwet sac nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Fin mukul se ku mutan se oasr tuhn fasrfasr sikyak ke manol, ");
INSERT INTO kos_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","na mwet tol el ac enenu in liye ac tuni mwet sac. Tuhn sac fin tuh fasrfasr ef se, na kalem mu tuhn se na ke manol, ac mwet sac nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Aunsifen sie mwet fin putatla, el ac musrasrla, tusruktu el nasnas na. ");
INSERT INTO kos_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Fin tuh putatla aunsuf ke likinsraclyak nu motonsrol, na motonsrol ac turangangla, tusruktu el nasnas na. ");
INSERT INTO kos_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Tusruktu fin oasr ma fasrfasr srusrsrusra fahsryak ke acn turangangla inge, na kalem lah mas na sensen nu ke kolo se pa inge. ");
INSERT INTO kos_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Mwet tol el fah tuni ac liye mwet se inge, ac fin oasr acn ma luman srusrsrusra ac fasrfasr inmuta kac, ");
INSERT INTO kos_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","na mwet tol enenu in fahkak lah mwet sac tia nasnas, ke sripen mas sensen se ma fahsryak ke sifal uh. ");
INSERT INTO kos_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Sie mwet su sun mas ma sensenkinyuk nu ke kolo, el enenu in nukum nuknuk mihsasa, ac fuhlela aunsifal in mirangak, afinya tafunyen ten ke mutal, wowo ac fahk, “Nga tia nasnas! Nga tia nasnas!” ");
INSERT INTO kos_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","El fah fohkfok ac tia nasnas ke lusenna pacl mas sac oan sel, ac el fah srisrila ac muta likin nien aktuktuk uh, sayen acn mwet uh muta we. ");
INSERT INTO kos_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Fin oasr tuhnyohu ke nuknuk, finne ma orekla ke unen sheep ku ke nuknuk minini, ");
INSERT INTO kos_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ku oan ke ipin nuknuk minini, ku ipin nuknuk unen sheep, ku oan fin kulun kosro ku kutena ma orekla ke kulun kosro, ");
INSERT INTO kos_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","fin luman tuhn folfolsra lac ku tuhn srusrayak, na kalem lah tuhnyohu orak se, ac enenu in itukyang nu sin mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Mwet tol el fah lohang nu kac ac srela nu saya ke len itkosr. ");
INSERT INTO kos_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","El fah sifilpa liye ke len se akitkosr, ac tuhnyohu sac fin orakelik, na ma sac tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Mwet tol el fah esukak, mweyen tuhnyohu orak se pa inge, ac enenu na in isisyak. ");
INSERT INTO kos_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Tusruktu, mwet tol el fin liye tuh na tuhnyohu sac tiana yokelik, ");
INSERT INTO kos_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","el fah sap in owola, ac sifil filiyuki ke len itkosr pac. ");
INSERT INTO kos_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Na el fah sifilpa liye, ac tuhnyohu sac fin tiana ekla tuhna, finne tia orakelik, ac srakna tia nasnas. Kowos enenu in esukak ma sac, finne ip ma kulawi uh oan meet ku tok. ");
INSERT INTO kos_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Tusruktu mwet tol sac fin sifil lohang nu kac tuh liyauk lah tuhn sac efla, na el fah sacla ip sac liki nuknuk sac ku kulun kosro sac. ");
INSERT INTO kos_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Na tuhnyohu sac fin sifilpa sikyak, kalem lah sifilpa orakelik, na mwet se la ma sac enenu na in esukak. ");
INSERT INTO kos_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","El fin ohlla nuknuk sac ku kolo sac, na tuhn sac wanginla, el enenu in sifilpa ohlla, na ma sac fah nasnas. ");
INSERT INTO kos_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ac pa inge ma sap nu ke tuhnyohu ma oan fin nuknuk, finne ma orekla ke unen sheep ku linen, ku ipin nuknuk linen ku ipin nuknuk unen sheep, ku kutena ma su orekla ke kulun kosro. Pa inge ma ac akkalemye ma su nasnas ku tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","LEUM GOD El sang nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","oakwuk ten inge nu ke aknasnas lun sie mwet ma kwela liki sie mas sensenkinyuk ke manol. Ke len se ma ac fwackyang mu el nasnasla uh, ac fah utuku el nu yurin mwet tol, ");
INSERT INTO kos_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ac mwet tol fah usalla nu likin nien aktuktuk uh ac tuni manol. Mas lal uh fin wanginla, ");
INSERT INTO kos_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","na mwet tol el fah sap in utuku luo won ma nasnas uh, wi sie ipin sak cedar, sie polo ah srusra, ac sie lah srisrik ke sak hyssop. ");
INSERT INTO kos_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Na mwet tol el fah sap in anwuki sie sin won luo ah luin sie pol eot ma kof in unon nasnas oan loac. ");
INSERT INTO kos_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","El fah eis won se ma moul ah, wi ipin sak cedar sac, polo ah srusra sac, ac sak hyssop sac, ac isongya ma inge kewa nu in srah ke won se ma anwuki ah. ");
INSERT INTO kos_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","El fah aksroksrokye mwet se ma ac aknasnasyeyuk liki mas ke manol pacl itkosr ke srah, na el fah fahkak lah mwet sac nasnasla. El fah fuhlela won se ma moul ah in sohkla. ");
INSERT INTO kos_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Mwet sac fah ohlla nuknuk lal uh, resaela aunsuf kacl uh nufon, ac yihla; na el fah nasnas. El ac ku in ilyak nu ke nien aktuktuk uh, tusruktu el enenu in mutana likin lohm nuknuk sel ke len itkosr. ");
INSERT INTO kos_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ke len se akitkosr el fah sifilpa resaela sifal, altal, inyal, ac unac nukewa ke manol. El fah ohlla nuknuk lal ac yihla, na el fah nasnasla. ");
INSERT INTO kos_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ke len se akoalkosr el fah use lukwa sheep fusr mukul ac soko ma mutan ma yac se matwa su wangin kutena ma koluk ke mano, wi paun limekosr ke flao ma kulamisyak ke oil in olive, ac sie cup ke oil in olive. ");
INSERT INTO kos_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Mwet tol el fah eis mwet sac ac mwe kisa inge nukewa nu ke acn in utyak nu ke Lohm Nuknuk Mutal, nien muta lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Na mwet tol el fah eis soko sin sheep fusr mukul inge, wi cup se ke oil in olive, ac kisakin tuh in sie mwe kisa in akfalye ma koluk lukma. El fah kisakin ma inge tuh in sie mwe sang sriyukla nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","El fah uniya sheep fusr soko ah in acn mutal ma mwe kisa lun ma koluk ac mwe kisa firir uh anwuki we. El enenu in oru ouinge mweyen kisa in akfalye ma koluk lukma uh oapana kisa ke ma koluk, kewana ma lun mwet tol, ac ma inge arulana mutal. ");
INSERT INTO kos_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Mwet tol el fah eis kutu srah ke sheep fusr soko ah, ac sang mosrwela acn fisrasrsrasr ke lac srac layot, fin kuf lulap lac po layot, ac fin kufinne lulap ke lac ne layot lun mwet se su ac fah akkalemyeyuk mu el nasnasla. ");
INSERT INTO kos_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Ac mwet tol el fah eis kutu oil in olive ac okoaung nu in paol lasa, ");
INSERT INTO kos_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","isongya soko kufinpaol layot nu loac, ac usrokya kutu srah inge pacl itkosr ye mutun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","El fah eis kutu oil ma oan inpaol uh ac kutu srahn sheep fusr soko ah, ac mosrwela acn fisrasrsrasr ke lac srac layot, kuflap ke lac po layot, ac kuflap ke lac ne layot lun mwet se su ac fah akkalemyeyuk mu el nasnasla. ");
INSERT INTO kos_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Na el fah sang oil ma lula inpaol uh nu fin sifen mwet sac. Ke el oru ouinge uh, el orala ouiya lun aknasnas. ");
INSERT INTO kos_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Na mwet tol el fah kisakin mwe kisa ke ma koluk, ac oru ouiya nu ke aknasnas. Toko el fah uniya sheep fusr soko nu ke kisa firir, ");
INSERT INTO kos_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ac kisakin wi mwe kisa wheat fin loang uh. In lumah se inge mwet tol el fah oru ouiya lun aknasnas, na mwet sac fah nasnasla. ");
INSERT INTO kos_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Mwet sac fin sukasrup ac tia ku in akfalye ma inge, el fah use sokofanna sheep fusr mukul nu ke aknasnas lal, tuh in mwe kisa ke ma koluk lukma lal, sie mwe kite sriyukla nu sin LEUM GOD. El fah use paun luo na ke flao ma karyak ke oil in olive nu ke mwe kisa wheat, ac sie cup ke oil in olive. ");
INSERT INTO kos_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","El fah oayapa use luo wule ku luo wuleoa, sie nu ke mwe kisa ke ma koluk, ac sie nu ke mwe kisa firir. ");
INSERT INTO kos_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ke len se akoalkosr ke len in aknasnas lal, el fah use ma inge nu yurin mwet tol, nu ke acn in utyak nu ke Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Mwet tol el fah eis sheep fusr soko ah, ac oil in olive uh, ac sang tuh in sie mwe kite srisrila nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","El fah uniya sheep fusr soko ah, eis kutu srah kac uh, ac sang mosrwela acn fisrasrsrasr ke lac srac layot, fin kufinpo lulap ke lac po layot, ac fin kufinne lulap ke lac ne layot ke mwet sac. ");
INSERT INTO kos_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Mwet tol el fah ukuiya kutu oil uh nu inpaol layen lasa, ");
INSERT INTO kos_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ac sang soko kufinpo ke lac paol layot, osrokang kutu oil uh pacl itkosr ye mutun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","El fah sang kutu oil nu fin acn na ma el sang srah uh nu kac: fin acn fisrasrsrasr layen layot ke insren mwet sac, fin kuflap ke la paol layot, ac fin kuflap ke la nial layot. ");
INSERT INTO kos_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Oil ma lula inpaol uh el fah ukuiya fin sifen mwet sac, ac ke el oru ouinge el orala ouiya nu ke aknasnas. ");
INSERT INTO kos_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Na el fah sang sie sin wule uh ku wuleoa uh ");
INSERT INTO kos_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","tuh in mwe kisa ke ma koluk, ac ma se saya uh nu ke mwe kisa firir, wi mwe kisa wheat. In lumah se inge mwet tol el orala ouiya nu ke aknasnas. ");
INSERT INTO kos_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Pa inge ma sap nu ke sie mwet su oasr mas na sensenkinyuk ke mano, su tia ku in srukak mwe kisa ma ac fal nu ke aknasnas lal. ");
INSERT INTO kos_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","LEUM GOD El kaskas nu sel Moses ac Aaron, ac fahk: ");
INSERT INTO kos_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Ke kowos fin mau tuku nu in facl Canaan, su nga ac fah sot tuh in ma lowos, ac nga filiya tuhnyohu nu ke sie lohm in acn suwos uh, ");
INSERT INTO kos_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","na mwet se la lohm sac enenu in tuku nu yurin mwet tol ac fahk nu sel ouinge: ‘Nga liye tuh luman oasr tuhnyohu ke lohm sik uh.’ ");
INSERT INTO kos_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Na mwet tol sac fah sap tuh ma nukewa in lohm sac in titila nu sayen lohm sac meet liki el som ac tuni tuhnyohu kac uh. Fin tia ouinge, na ma nukewa in lohm sac fah fwackyak mu tia nasnas. Na tok mwet tol el fah som nu ke lohm sac, ");
INSERT INTO kos_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ac tuni tuhnyohu kac. Fin oasr acn ma luman tuhn folfolsra ku srusrsrusra kac, ma luman ac kulweya sinka in lohm sac, ");
INSERT INTO kos_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","na el fah illa liki lohm sac ac kaliya ke len itkosr. ");
INSERT INTO kos_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ke len se akitkosr el fah folokla ac sifilpa tuni lah fuka. Tuhnyohu sac fin yokelik, ");
INSERT INTO kos_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","na el fah sap eot ma tuhnyohula inge in itukla ac sisila nu in sie acn tia nasnas likin siti sac. ");
INSERT INTO kos_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Toko, el fah sap sinka loac ke lohm sac nufon in koekoela, ac kutkut kac nukewa in sisila nu in sie acn tia nasnas likin siti sac. ");
INSERT INTO kos_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Na kutu pac eot sasu ac fah orekmakinyuk in aolla eot ma itukla, ac akmusra sasu fah sang afinya acn ma koekoela ke sinka ah. ");
INSERT INTO kos_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Fin tuhnyohu sac sifilpa folokyak in lohm sac tukun ayaolla eot ma kolukla ac koekoela sinka kac ac akmusralla, ");
INSERT INTO kos_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","na mwet tol el enenu in sifilpa som ac liye. Fin tuhnyohu sac tuh yokelik, na lohm sac tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Enenu na in kunanui lohm sac, ac eot kac, sak kac, ac fasr kac nukewa fah utukla nu likin siti uh, nu in sie acn ma tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Kutena mwet su utyak nu in lohm sac ke pacl se kauli uh, ac fah lumweyuk el tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Kutena mwet su ona ku mongo in lohm sac enenu na in ohlla nuknuk lal. ");
INSERT INTO kos_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Ke pacl se ma mwet tol el tuku in liye uh, tuh na tuhnyohu sac tiana sifil folokyak tukun lohm sac akwoyeyukla, na el fah fahkak lah lohm sac nasnas, mweyen tuhnyohu sac wanginla na pwaye. ");
INSERT INTO kos_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","In aknasnasye lohm sac, el fah us luo won, sie ipin sak cedar, sie polo ah srusra, ac sie lesak srisrik ke hyssop. ");
INSERT INTO kos_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","El fah uniya sie sin won luo ah fin sie pol eot ma oasr kof nasnas oan loac. ");
INSERT INTO kos_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Na el fah eis sak cedar sac, lesak hyssop sac, polo ah srusra sac, ac won se ma srakna moul uh, ac isongya ma inge nukewa in srahn won se ma anwuki ac oan in kof nasnas sac, na sang aksroksrokye lohm sac pacl itkosr. ");
INSERT INTO kos_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ke el oru ma inge uh el ac aknasnasyela lohm sac ke srahn won sac, kof nasnas sac, won moul sac, sak cedar sac, lesak hyssop sac, ac polo ah srusra sac. ");
INSERT INTO kos_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Na el fah fuhlela won se ma moul ah in sohkla. Ke el oru ouinge, na el orala ouiya lun aknasnas nu ke lohm sac, na lohm sac fah nasnasla. ");
INSERT INTO kos_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“Pa inge ma sap nu ke mas ma sensenkinyuk nu ke mano: ");
INSERT INTO kos_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ku nu ke tuhnyohu ma oan ke nuknuk ku ke lohm, ");
INSERT INTO kos_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ac nu ke faf, ku acn ma aryurla ke mano, ku ke tuhn koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Ma sap inge pa fahkak inmasrlon ma su tia nasnas ac ma su nasnas.” ");
INSERT INTO kos_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","LEUM GOD El sang nu sel Moses ac Aaron oakwuk inge ");
INSERT INTO kos_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","su ma nu sin mwet Israel. Pacl se ma oasr sroano fahla liki ma lun sie mukul, sroano sac tia nasnas, ");
INSERT INTO kos_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","finne fahlana, ku fonfon uh ac kofla fahla. ");
INSERT INTO kos_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Kutena mwe oan su el muta fac ku oan fac ac tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Kutena mwet su pusralla mwe oan kial, ");
INSERT INTO kos_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ku muta fin kutena ma su mukul sac muta fac, enenu in ohlla nuknuk lal ac yihla, na el srakna tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Kutena mwet su pusralla mukul se ma oasr sroano fahla kacl inge, enenu na in owola nuknuk la uh ac el yihla, tusruktu el ac srakna tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Mwet se ma oasr ma fahsr kac inge fin aniya kutena mwet su nasnas, na mwet se ma aniyuki uh enenu in ohlla nuknuk ma el nukum ac yihla, tusruktu el soenna nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Kutena mwe muta fin horse ku mwe muta saya ma mukul se ma oasr sroano fahsr kac inge el muta fac uh, tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Kutena mwet su pusral ma mukul sac el muta fac inge, el tia nasnas nwe ke ekela. Kutena mwet su us ma mukul sac el muta fac inge, enenu in ohlla nuknuk lal ac yihla, tusruktu el srakna tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Fin mwet se ma oasr sroano fahsr ke mano inge pusralla siena mwet meet liki el ohlla paol uh, na mwet sac enenu in ohlla nuknuk lal ac yihla, na el ac srakna tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Kutena tup eot ma mwet sac pusralla enenu in fukulyuki, ac kutena pol orekla ke sak ma mwet sac kahlye uh, enenu in owola. ");
INSERT INTO kos_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Tukun mukul sac kwela liki ma fahsr kacl uh, el enenu in soano len itkosr, na el fah ohlla nuknuk lal ac yihla in kof in unon nasnas, na el fah nasnasla. ");
INSERT INTO kos_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ke len se akoalkosr el fah us luo wule ku luo wuleoa nu ke acn in utyak nu in Lohm Nuknuk Mutal sin LEUM GOD, ac sang nu sin mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Mwet tol el fah kisai sie tuh in mwe kisa ke ma koluk, ac ma se saya uh nu ke mwe kisa firir. Ke el oru ma inge el oru ouiya in aknasnasyela mwet sac. ");
INSERT INTO kos_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Fin oasr wui fahla ke sie mukul ke el tia etu, el fah ohlla manol nufon, tusruktu el soenna nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Kutena kain nuknuk ku kulun kosro ma wui kacl uh tuh pusralla, enenu in owola, tusruktu ac srakna tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Tukun mukul se ac mutan se tukeni oan, eltal kewa enenu in yihla, tusruktu eltal ac srakna tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Pacl se ke sie mutan el mas mutan, el ac fah tia nasnas ke len itkosr. Kutena mwet su pusralulla el tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Kutena ma su mutan sac el muta fac ku oan fac ke pacl el mas mutan fah tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Kutena mwet su pusralla mwe oan kien mutan sac fah ohlla nuknuk lal ac yihla, tusruktu el ac srakna tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Kutena mwet su pusralla kutena ma su mutan sac muta fac, fah ohlla nuknuk lal ac yihla, tusruktu el ac srakna tia nasnas nwe ke ekela; ");
INSERT INTO kos_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","finne mwe oan kien mutan sac, ku kutena ma mutan sac muta fac, mwet se fin pusralla el fah tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Kutena mukul su ona yorol in pacl in mas mutan lal, fah akfohkfokyeyukla ke sripen fohkfok lun mutan sac, ac mukul sac fah tia nasnas ke len itkosr, ac kutena mwe oan su mukul sac oan fac, fah tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Mutan se fin fahsr srah kacl ke len sayen pacl in mas mutan lal, ku fahsr lun srac kacl fin loes liki lusen pacl fal nu ke mas mutan lal, el ac tia nasnas ke lusenna pacl fahsr srah kacl uh, oapana ke pacl in mas mutan lal uh. ");
INSERT INTO kos_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Kutena mwe oan ma el oan fac, ac kutena ma su el muta fac ke pacl ma el tia nasnas inge, ac fah tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Kutena mukul su pusralla ma inge fah tia nasnas, ac el fah enenu in ohlla nuknuk lal ac yihla, tusruktu el fah srakna tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Tukun pacl se ma tui fahsr lun srah kacl uh, mutan sac fah soano len itkosr, ac tukun pacl sacn el fah nasnas. ");
INSERT INTO kos_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ke len se akoalkosr el fah us luo wule ku luo wuleoa nu yurin mwet tol, nu ke acn in utyak nu in Lohm Nuknuk Mutal sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Mwet tol el fah kisakin sie sin ma inge tuh in mwe kisa ke ma koluk, ac ma se lula uh nu ke kisa firir, ac ke el oru ma inge el oru ouiya lun aknasnasyela nu sin mutan sac. ");
INSERT INTO kos_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","LEUM GOD El fahk nu sel Moses in sensenkakin mwet Israel tuh ke pacl elos tia nasnas uh elos in tiana apkuran nu ke Lohm Nuknuk Mutal nien muta lal, su oan infulwen nien aktuktuk lalos. Elos fin oru ouinge, na elos akfohkfokyela, ac elos fahanwuki. ");
INSERT INTO kos_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Pa inge oakwuk nu sin sie mukul su oasr sroano fahsr kacl, ku wui sororla kacl, ");
INSERT INTO kos_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ku sie mutan in pacl in mas mutan lal, ku nu sin sie mukul su ona yurin sie mutan in pacl mutan sac tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","LEUM GOD El kaskas nu sel Moses tukun pacl se anwuki luo sin wen natul Aaron ke sripen eltal tuh orek kisa nu sin LEUM GOD ke e ma tia mutal. ");
INSERT INTO kos_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","El fahk, “Fahkang nu sel Aaron, tamulel lom, lah in pacl fal mukena pa el ac ku in utyak alukela lisrlisr uh nu in Acn Mutal Na Mutal, mweyen pa ingan acn se ma nga ac sikyak in sie pukunyeng fin kafa in Tuptup in Wuleang uh. El fin tia akos, el ac fah anwuki. ");
INSERT INTO kos_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","El fin use soko cow mukul fusr nu ke kisa ke ma koluk, ac soko sheep mukul nu ke mwe kisa firir, na el fah ku in ilyak nu in Acn Mutal Na Mutal.” ");
INSERT INTO kos_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Na LEUM GOD El sang pac oakwuk ten inge. Meet liki Aaron el ac ilyak nu in Acn Mutal Na Mutal, el enenu in yihla ac nokomang nuknuk lun mwet tol: nuknuk oa loeloes ac turasis fototo loac lal ma orek ke linen, mwe lohl linen, ac susu linen. ");
INSERT INTO kos_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Mwet Israel ac fah sang nu sel Aaron nani mukul lukwa nu ke kisa ke ma koluk, ac soko sheep mukul nu ke mwe kisa firir. ");
INSERT INTO kos_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aaron el fah kisakin soko cow mukul tuh in mwe kisa in eela ma koluk lal sifacna oayapa ma koluk lun mwet in sou lal. ");
INSERT INTO kos_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Na el fah usla nani lukwa ah nu ke acn in utyak nu in Lohm Nuknuk Mutal sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ke el sun acn sac, na el ac oru sie susfa, ac orekmakin luo eot: sie simla “Nu sin LEUM GOD”, ac sie “Nu sel Azazel.” ");
INSERT INTO kos_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaron el fah eis nani soko ma fa ah tuh sukya mu nu sin LEUM GOD, ac kisakin tuh in mwe kisa ke ma koluk. ");
INSERT INTO kos_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ac nani soko ma fa ah tuh sukya mu nu sel Azazel ac fah moul na itukyang nu sin LEUM GOD, ac lisyukla nu yen mwesis nu yorol Azazel in tuh usla ma koluk lun mwet uh. ");
INSERT INTO kos_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ke Aaron el ac kisakin cow mukul soko ah tuh in mwe kisa ke ma koluk lal sifacna ac ma koluk lun sou lal, ");
INSERT INTO kos_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","el fah eis sie pan ma sessesla ke mulut firir ma itukla liki loang uh, wi luo lafluf in ma keng srik kosra in paol, ac usla nu in Acn Mutal Na Mutal. ");
INSERT INTO kos_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Na el fah filiya mwe keng uh nu fin e uh ye mutun LEUM GOD, na kulasr ke mwe keng uh ac fah kosrala kafa ke Tuptup in Wuleang uh tuh elan tia liye pwanang el misa. ");
INSERT INTO kos_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","El fah isongya kufinpaol nu in srah ke cow mukul soko ah, ac sang aksroksrokye fin kafa in Tuptup sac, ac sifilpa sang kutu srah uh aksroksrokye acn meet pac ke Tuptup in Wuleang pacl itkosr. ");
INSERT INTO kos_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Tukun ma inge, el fah uniya nani soko nu ke kisa ke ma koluk lun mwet uh, ac usak srah kac nu in Acn Mutal Na Mutal, ac sang aksroksrokye kafa ah, oayapa mutun Tuptup in Wuleang uh, oana ke el oru ke srahn cow mukul soko ah. ");
INSERT INTO kos_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ke el oru ma inge, el orala ouiya lun aknasnasyela Acn Mutal Na Mutal liki fohkfok lun mwet Israel ac liki ma koluk nukewa lalos. El enenu in oru ma inge nu ke Lohm Nuknuk Mutal, mweyen Lohm Nuknuk uh oanna infulwen nien aktuktuk lun mwet uh, su tia nasnas moul la. ");
INSERT INTO kos_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ke pacl se Aaron el ac ilyak nu in Acn Mutal Na Mutal in oru ouiya lun aknasnas, nwe ke el illa, enenu na in wangin kutena mwet in Lohm Nuknuk Mutal. Ke pacl se el oru ouiya lun aknasnas nu sel sifacna ac nu sin sou lal, oayapa nu sin mwet nukewa in acn sac, ");
INSERT INTO kos_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","el enenu in illa ac som nu ke loang in mwe kisa firir ac aknasnasyela. El enenu in eis kutu srahn cow ac kutu srahn nani ac filiya fin koac nukewa ke sruwasrik in loang uh. ");
INSERT INTO kos_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","El fah sang kufinpaol ac aksroksrokye loang uh pacl itkosr ke srah. Ke el oru ouinge el akmutalyela loang uh ac aknasnasyela liki ma koluk lun mwet Israel. ");
INSERT INTO kos_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Tukun Aaron el aksafyela mukuikui lal in aknasnasyela Acn Mutal Na Mutal, ac acn saya in Lohm Nuknuk Mutal sin LEUM GOD, wi loang uh, na el fah sang nu sin LEUM GOD nani moul soko ma solla nu sel Azazel. ");
INSERT INTO kos_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","El fah filiya paol kewa fin sifen nani soko ah, ac fahkak ma sutuu, ma koluk, ac siakos nukewa lun mwet Israel, ac sang ma inge nukewa nu fin sifen nani soko ah. Na nani soko ac fah lisyukla nu yen mwesis sin sie mwet su srisrngiyuki nu kac. ");
INSERT INTO kos_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Nani soko ah ac fah us ma koluk nukewa lalos welul nu yen mwesis, yen wangin mwet muta we. ");
INSERT INTO kos_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Na Aaron el fah utyak nu in Lohm Nuknuk Mutal, ac sarukla nuknuk lun mwet tol ma el tuh nokomang meet liki el ilyak nu in Acn Mutal Na Mutal, ac filiya we. ");
INSERT INTO kos_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","El enenu in yihla ke sie acn mutal, ac nokomang nuknuk lal sifacna. Toko, el fah illa ac esukak mwe kisa firir in eisla ma koluk lal sifacna ac oayapa ma koluk lun mwet uh. ");
INSERT INTO kos_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","El fah esukak kiris ke kosro soko ah fin loang uh, tuh in mwe kisa ke ma koluk. ");
INSERT INTO kos_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Mwet se ma lusla nani soko ah nu yorol Azazel in acn mwesis, el enenu in ohlla nuknuk lal ac yihla meet liki el foloko nu in nien aktuktuk uh. ");
INSERT INTO kos_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Cow mukul soko ah, ac nani soko ma orekmakinyuk nu ke kisa ke ma koluk, su ma srah kac ah tuh utuku nu in Acn Mutal Na Mutal in eisla ma koluk, fah utukla nu likin nien aktuktuk lun mwet uh ac isisyak. Kolo, ikwa, ac koanonsia uh ac fah isisyak nufon. ");
INSERT INTO kos_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Mwet se ma esukak ma inge el enenu in ohlla nuknuk lal ac yihla meet liki el foloko nu in nien aktuktuk lalos. ");
INSERT INTO kos_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Oakwuk ten inge fah akilenyuk ke pacl nukewa fahsru uh. Ke len aksingoul ke malem se akitkosr, mwet Israel ac mwetsac su muta inmasrlolos fah lalo ac tia oru kutena orekma. ");
INSERT INTO kos_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ke len sac, ouiya lun aknasnasyalos liki ma koluk nukewa lalos ac fah orek, tuh elos fah nasnasla. ");
INSERT INTO kos_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Len sac ac fah sie len na mutal, sie len su elos fah lalo ac tia oru kutena orekma. Oakwuk inge ac fah akilenyuk ke pacl nukewa fahsru uh. ");
INSERT INTO kos_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Mwet Tol Fulat se su akmusrala tari fal nu ke ouiya lalos in tuh aolla papa tumal, pa ac kol alu in aknasnas uh. El fah nokomang nuknuk lun mwet tol ");
INSERT INTO kos_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ac oru ouiya in aknasnasye Acn Mutal Na Mutal, acn saya ke Lohm Nuknuk Mutal sin LEUM GOD, loang uh, mwet tol uh, ac mwet nukewa in acn sac. ");
INSERT INTO kos_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Oakwuk inge ac fah akilenyuk ke pacl nukewa fahsru. Ouiya lun aknasnas inge fah orek pacl se ke yac se, in aknasnasyela mwet Israel liki ma koluk nukewa lalos. Ouinge Moses el oru oakwuk inge oana LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","elan sang nu sel Aaron ac wen natul, ac mwet Israel nukewa, oakwuk ten inge. ");
INSERT INTO kos_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Kutena sin mwet Israel fin uniya soko cow ku soko sheep ku soko nani mwe kisa nu sin LEUM GOD ke acn elos aktuktuk we, ku likin acn in aktuktuk lalos, ");
INSERT INTO kos_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ac tia use nu ke acn in utyak nu ke Lohm Nuknuk Mutal sin LEUM GOD tuh elan uniya we, ac fah oasr mwatal ke akmas. El aksororyela srah, na el ac fah lisyukla liki inmasrlon mwet lun God. ");
INSERT INTO kos_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Kalmen ma sap se inge pa mwet Israel ac fah mutawauk use nu yurin LEUM GOD kosro ma elos muta uniya in acn saya uh. Ingela elos ac fah use nu yurin mwet tol, nu ke acn in utyak nu in Lohm Nuknuk Mutal, ac uniya we tuh in mwe kisa in akinsewowo. ");
INSERT INTO kos_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Mwet tol el fah okoaung srah uh ac fwela siska akosr kewa ke loang se su oan ke acn in utyak nu in Lohm Nuknuk Mutal, ac esukak kiris kac uh in orala sie foul ma ac akinsewowoye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Mwet Israel elos fah tia sifilpa srike in aklalfonye LEUM GOD ke elos uniya kosro uh inimae tuh in mwe kisa nu sin ma sruloala lalos su oana luman nani uh. Mwet Israel fah arulana liyaung oakwuk se inge ke pacl nukewa fahsru uh. ");
INSERT INTO kos_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Kutena mwet Israel, ku mwetsac su wi muta in acn selos, su oru kisa firir ku kutena kain kisa saya ");
INSERT INTO kos_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","nu sin LEUM GOD in kutena acn sayen acn in utyak nu in Lohm Nuknuk Mutal, fah tia sifilpa oekyuk mu el sie sin mwet lun God. ");
INSERT INTO kos_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Kutena mwet Israel, ku kutena mwetsac su muta inmasrlolos, fin kang ikwa ma srakna oasr srah kac, LEUM GOD El ac fah ngetla lukel, ac mwet sac fah tia sifilpa oekyuk mu el sie sin mwet lal. ");
INSERT INTO kos_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Moul lun ma oasr moul la nukewa oasr ke srah, ac pa ingan sripen LEUM GOD El sapkin tuh srah nukewa fah okwokla nu fin loang uh in eisla ma koluk lun mwet uh. Srah, su sang moul, el eisla ma koluk. ");
INSERT INTO kos_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Pa ingan sripen LEUM GOD El fahk mu finne mwet Israel ku mwetsac su muta yorolos, elos in tiana kang ikwa ma srakna oasr srah kac. ");
INSERT INTO kos_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Kutena sin mwet Israel, ku mwetsac su muta inmasrlolos, fin sruokya soko kosro ku sie won ma nasnas ac ku in mongo, el enenu in okoala srah kac nu infohk uh ac pikinya. ");
INSERT INTO kos_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Moul lun ma moul nukewa oasr ke srah kaclos, pa pwanang LEUM GOD El fahkang nu sin mwet Israel mu elos in tiana kang kutena ikwa ma srakna oasr srah kac, ac kutena mwet su kang, fah tia sifilpa oekyuk mu el sie sin mwet lun God. ");
INSERT INTO kos_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Kutena mwet, finne mwet Israel ku mwetsac, su kang ikwen kosro ma sifacna misa, ku ma anwuki sin kosro lemnak, enenu in ohlla nuknuk lal, yihla, ac soano nwe ke ekela, na el fah nasnas. ");
INSERT INTO kos_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","El fin tia oru ouinge, na ac fah oasr mwatal ac el fah eis kaiyuk kac. ");
INSERT INTO kos_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","LEUM GOD El fahk nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","elan fahkang nu sin mwet Israel, “Nga pa LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Nik kowos oru ouiya lun mwet Egypt, yen ma kowos tuh muta we meet, ku ouiya lun mwet in acn Canaan, yen su nga ac us kowos nu we. ");
INSERT INTO kos_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Akos ma sap luk, ac oru ma nga sapkin. Nga pa LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Fahsr tukun oakwuk ac ma sap su nga sot nu suwos. Kowos fin oru ouinge, kowos ac fah moul. Nga pa LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Nikmet orek kosro nu sin kutena mwet in sou lowos. ");
INSERT INTO kos_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Nikmet akmwekinye papa tomom ke kom orek kosro nu sin nina kiom. Kom fah tiana akmwekinye nina kiom sifacna. ");
INSERT INTO kos_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Nikmet akmwekinye papa tomom ke kom orek kosro nu sin kutena sin mutan kial saya. ");
INSERT INTO kos_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Nik kom orek kosro nu sin tamtael lom, ku nu sin acn nutin papa tomom ku nina kiom saya — el finne wi kom matula in lohm sum, ku tia. ");
INSERT INTO kos_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Nikmet orek kosro nu sin acn nutin wen nutum ku acn nutin acn nutum — ma inge ac fah sie mwe akmwekin nu sum. ");
INSERT INTO kos_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Nikmet orek kosro nu sin acn nutin mutan kien papa tomom — el ma pacna wiom. ");
INSERT INTO kos_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Kom fah tiana orek kosro nu sin tamtael lun papa tomom, mweyen el ikwen pacna papa tomom. ");
INSERT INTO kos_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Kom fah tiana orek kosro nu sin tamtael lun nina kiom, mweyen el ikwen pacna nina kiom. ");
INSERT INTO kos_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Nik kom orek kosro nu sin mutan kien tamulel lun papa tomom — el oapana nina se kiom. ");
INSERT INTO kos_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Nik kom orek kosro nu sin mutan kien wen nutum, ");
INSERT INTO kos_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ku nu sin mutan kien tamulel lom. ");
INSERT INTO kos_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Nik kom orek kosro nu sin sie mutan nutin sie mutan su kom orek kosro nu se meet, ku nu sin tulik nutin natu. Sahp elos ac sou lom — ac tuh pwanang kom orek pukasr. ");
INSERT INTO kos_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Nik kom payuk sin tamtael lun mutan kiom, ke lusenna pacl mutan kiom el srakna moul. ");
INSERT INTO kos_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Nik kom orek kosro nu sin kutena mutan su oasr ke musen malem lal, mweyen el tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Nik kom orek kosro nu sin mutan kien siena mwet. Ma se inge ac fah akfohkfokye kom. ");
INSERT INTO kos_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Nikmet sang kutena sin tulik nutum in kisakinyuk nu sin god Molech, mweyen ouiya sacn ac aklusrongtenye Inen LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Wangin sie mukul ac fah oru inkanek in kosro nu sin siepah mukul — God El kwase ouiya sacn. ");
INSERT INTO kos_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Wangin mukul ku mutan ac fah orek kosro nu sin kutena ma orakrak. Kain in elah fohkfok inge ac fah akfohkfokye kom. ");
INSERT INTO kos_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Nik kowos akfohkfokye kowos sifacna ke kain in ouiya inge, tuh pa inge ouiya ma akfohkfokye mwet pegan su muta in acn inge meet liki kowos, su LEUM GOD El ac lusak tuh kowos in ku in utyak nu in acn selos. ");
INSERT INTO kos_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Orekma lalos akfohkfokyela acn uh, ouinge LEUM GOD El kalyei acn uh, ac oru tuh acn uh in wotela mwet su tuh muta we. ");
INSERT INTO kos_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Tusruktu kowos, mwet Israel oayapa mwetsac nukewa su muta inmasrlowos, fah liyaung ma nga sapkin ac oakwuk luk, ac tia oru kutena sin ouiya koluk inge. ");
INSERT INTO kos_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(Mweyen mwet ma tuh muta fin acn se inge meet liki kowos, elos tuh oru ouiya koluk inge, pwanang kolukla acn se inge.) ");
INSERT INTO kos_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Fin ouinge, acn uh ac fah tia siskowosla, oana ke el tuh sisla mwet pegan su muta we meet liki kowos. ");
INSERT INTO kos_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Kowos etu lah kutena mwet su oru kutena sin ouiya koluk inge ac fah tia sifil pangpang sie sin mwet lun God. ");
INSERT INTO kos_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Ac LEUM GOD El fahk, “Akos oakwuk ma nga sot, ac tia fahsr tukun ouiya lun mwet su tuh muta fin acn se inge meet liki kowos, ac nikmet oru kutena sin ma inge in akfohkfokye kowos sifacna. Nga LEUM GOD lowos.” ");
INSERT INTO kos_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","LEUM GOD El fahk nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","elan fahk nu sin mwet Israel nukewa, “Kowos in mutal, tuh nga, LEUM GOD lowos, nga mutal. ");
INSERT INTO kos_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Kais sie suwos fah akfulatye nina kial ac papa tumal, ac el enenu in karinganang len Sabbath oana nga tuh sapkin. Nga LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Nikmet ngetla likiyu ac alu nu sin ma sruloala. Nikmet orala kutena god ke osra ac alu nu kac. Nga pa LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Ke kowos uniya soko kosro nu ke mwe kisa in akinsewowo, kowos karinganang oakwuk ma nga sot nu suwos, ac nga fah insewowo ke mwe kisa lowos. ");
INSERT INTO kos_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ikwa kac fah mongola na ke len se ma anwuki kosro soko ah, ku ke len se toko an. Kutena ikwa ma lula nu ke len se aktolu fah isisyak, ");
INSERT INTO kos_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","mweyen ac tila nasnas. Kutena mwet fin kang ma inge, nga ac fah tia insewowo in eis mwe kisa sac. ");
INSERT INTO kos_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Kutena mwet su mongo kac ac fah oasr mwatal ke el oru ma kisakinyuk nu sik oana ma pilasr, ac el ac fah tia sifil pangpang mu el sie sin mwet luk. ");
INSERT INTO kos_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Ke pacl kom kosrani ima lom, nik kom telani wheat ma oan sisken ima an, ac nik kom folokla ac telani nufon ma lula uh. ");
INSERT INTO kos_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Nik kom folokla nu in ima grape lom in orani grape ma sisila, ku in telak grape ma putatla. Filiya nu sin mwet sukasrup ac nu sin mwetsac. Nga LEUM GOD lom. ");
INSERT INTO kos_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Nikmet pisrapasr, ku kutasrik, ku kikiap. ");
INSERT INTO kos_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Nikmet orek wulela ke Inek kom fin ac tia liyaung wulela lom; ma inge ac aklusrongtenye Inek. Nga pa LEUM GOD lom. ");
INSERT INTO kos_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Nikmet aklalfonye kutena mwet, ku pisre ma lal. Nikmet sruokya molin mwet orekma lom paht liki len se. ");
INSERT INTO kos_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Nikmet selngawi mwet sulohngkas, ku filiya kutena ma ye mutun sie mwet kun in tuh oru elan ikori. Akosyu. Nga LEUM GOD lom. ");
INSERT INTO kos_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Ke pacl in nununku, kom in pwayena ac suwosna ke pacl kom ac wotela mau. Nik kom wiwimwet nu sin mwet sukasrup, ku sangeng sin mwet kasrup. ");
INSERT INTO kos_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Nik kom usalik kas kikiap ke kutena mwet, ac ke pacl sie mwet el nununkeyuk nu ke ma su ac ku in eisla moul lal, fahk ma kom etu kac fin ma ac kasrel. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Nik kom kolla mulat lom lain kutena mwet, a kom in akwoyela ma komtal tia insese kac, tuh kom in tia orala sie ma koluk ke sripal. ");
INSERT INTO kos_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Nik kom orek foloksak nu sin kutena mwet, ku sruokya srunga lom nu sel in oan paht, a kom in lungse mwet tulan lom oana ke kom lungse kom sifacna. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Akos ma sap luk. Nik kom oru kosro nutum in orek fahko nu sin siena kain kosro. Nik kom yoki kain in fita luo in ima se na. Nik kom nukum nuknuk ma otwotla ke kain in turet luo. ");
INSERT INTO kos_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Fin akilenyuk mu sie mutan foko el mutan kulansap kien sie mukul a soenna moliyukla el elan sukosokla, na siena mukul fin orek kosro nu sel, eltal ac fah kaiyuk, tusruk ac tia anwuki eltal mweyen mutan sac el sie mutan kohs. ");
INSERT INTO kos_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mukul sac fah use soko sheep mukul nu ke acn in utyak nu in Lohm Nuknuk Mutal sik tuh in mwe kisa in akfalye ma koluk lukma lal. ");
INSERT INTO kos_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ac mwet tol el fah oru alu in aknasnas ke sheep soko inge in eisla ma koluk lun mukul sac, ac God El fah nunak munas nu sel. ");
INSERT INTO kos_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Ke pacl se kowos utyak nu in acn Canaan ac yukwiya kutena kain sak ma ac isus fahko, filiya in nunak lowos mu fokinsak inge tia nasnas ke yac tolu emeet uh. Ke lusen pacl sacn kowos fah tia kang fokinsak inge. ");
INSERT INTO kos_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ke yac se akakosr, fokinsak nukewa fah kisakinyukla in oana sie mwe kisa in fahkak kulo lowos nu sik, LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Tusruktu ke yac se aklimekosr kowos ku in kang fokinsak uh. Kowos fin oru ma inge nukewa, na sak sunowos uh fah oswe fahko puspis. Nga pa LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Nik kowos kang kutena ikwa ma srakna oasr srah kac. Nik kowos orek susfa. ");
INSERT INTO kos_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Nik kowos koala aunsuf ke likintupowos, ku nawu alut lowos an, ");
INSERT INTO kos_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","ku orek srisring ku sipik monuwos in orek eoksra ke mwet misa. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Nik kowos akmwekinye acn nutuwos ke kowos oru tuh elos in kosro ac eis moul kac in lohm alu saya uh. Kowos fin oru ouinge, kowos ac fah forla nu sin god saya, na facl se inge ac fah sesseslana ke ouiya fohkfok. ");
INSERT INTO kos_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Liyaung len Sabbath, ac sunakin acn ma mwet elos alu nu sik we. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Nik kowos som ac suk kas in kasru sin mwet su sramsram nu sin ngunin mwet misa. Kowos fin oru ma inge, kowos ac fah tia nasnas. Nga LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Akkalemye sunak lowos nu sin mwet matu, ac akfulatyelos. Kowos in akfulatyeyu, ac akos ma sap luk. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Nik kowos oru koluk mwetsac su muta in acn suwos. ");
INSERT INTO kos_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Oru wo nu selos oana ke kom oru nu sin mwet Israel wiom, ac lungse elos oana ke kom lungse kom sifacna. Esam lah meet kowos tuh mwetsac in facl Egypt. Nga LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Nik kowos orek kutasrik nu sin kutena mwet ke kowos orekmakin mwe srikasrak kikiap: ke lusa, ke toasriya, ku ke pisa. ");
INSERT INTO kos_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Orekmakin mwe paun suwohs, lupan toasran in pwaye, ac mwe srikasrak an in suwohs. Nga LEUM GOD, God lowos, ac nga uskowosme liki facl Egypt. ");
INSERT INTO kos_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Akos ma sap nukewa luk ac ma nukewa nga sapkin nu suwos. Nga LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","LEUM GOD El fahk nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","elan fahkang nu sin mwet Israel, “Kutena suwos, ku kutena mwetsac su muta inmasrlowos, su asang tulik natu in kisakinyukla nu sin god Molech, ac fah tatngal el sin mwet in acn se inge nufon nwe ke el misa. ");
INSERT INTO kos_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Kutena mwet su sang sie sin tulik natul nu sel Molech ac oru tuh Lohm Nuknuk Mutal sik in fohkfokla ac aklusrongtenye Ine mutal luk, nga fah lainul, ac tia sifil oekul mu el sie sin mwet luk. ");
INSERT INTO kos_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Tusruktu mwet in acn sac fin pilesru ma mwet sac orala uh ac tia unilya, ");
INSERT INTO kos_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","nga ac fah sifacna forang lainul, ac sou lal nufon, ac mwet nukewa ma welul in tia inse pwaye nu sik a elos alu nu sel Molech. Nga fah tia sifilpa oakalos mu elos mwet luk. ");
INSERT INTO kos_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Fin oasr kutena mwet ma forla ac suk kasru sin mwet su sramsram nu sin ngun fohkfok, nga fah forang lainul ac tia sifilpa oakal mu el sie sin mwet luk. ");
INSERT INTO kos_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Sifacna liyekowosyang tuh kowos in mutal, tuh nga pa LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Akos ma sap luk, mweyen nga LEUM GOD lowos, su akmutalyekowosla.” ");
INSERT INTO kos_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","LEUM GOD El sang pac oakwuk ten inge nu selos. Kutena mwet su selngawi papa tumal ku nina kial fah anwuki. El sifacna pa sang mwatan misa lal. ");
INSERT INTO kos_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Sie mwet fin orek kosro nu sin mutan kien sie pac mwet Israel, kewana mukul se ac mutan se ma orek kosro fah anwuki. ");
INSERT INTO kos_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Sie mukul su orek kosro nu sin sie sin mutan kien papa tumal, el akmwekinye papa tumal, ke ma inge mukul sac ac mutan sac kewa ac fah anwuki. Eltal na pa sifacna oru in anwuki eltal. ");
INSERT INTO kos_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Mukul se fin kosro nu sin mutan kien sie sie wen natul, el ac mutan sac kewa fah anwuki. Eltal oru ouiya na koluk se, ac sifacna pwanang in anwuki eltal. ");
INSERT INTO kos_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Mukul se fin orek inkanek in kosro nu sin sie pac mukul, eltal orala sie ouiya ma arulana srungayuk. Ke ma inge, ac fah anwuki eltal. Eltal sifacna pwanang in anwuki eltal. ");
INSERT INTO kos_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Sie mukul fin payukyak sin sie mutan ac oayapa nina kien mutan sac, eltal kewa fah isisyak in misa, ke sripen lumah na koluk se ma eltal orala uh. Kain ouiya se inge fah tia filfilla in orek inmasrlowos. ");
INSERT INTO kos_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Mukul se fin orek kosro nu sin soko ma orakrak, mukul sac ac ma orakrak soko an fah anwuki. ");
INSERT INTO kos_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Mutan se fin suk inkanek in orek kosro nu sin soko ma orakrak, mutan sac ac kosro soko ah kewa ac fah anwuki. Ma na eltal oru pa misa laltal. ");
INSERT INTO kos_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Mukul se fin payukyak sin tamtael se lal, ku nu sin acn se nutin papa tumal ku nina kial saya, na eltal fah akmwekinyeyuk ye mutun mwet uh, ac lillilla liki acn mwet uh muta we. El orek kosro nu sin ma loul, ouinge ac fah kaiyuk el oana ma fal in orek nu sel. ");
INSERT INTO kos_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Mukul se fin orek kosro nu sin sie mutan ke pacl mutan sac el mas mutan, eltal kewa fah lisyukla liki inmasrlon mwet uh, mweyen eltal kunausla oakwuk ke ma su tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Mukul se fin orek kosro nu sin sie sin mutan wien papa tumal ku mutan wien nina kial, eltal na kewa fah eis kaiyuk ma fal in orek nu seltal ke sripen pukasr laltal uh. ");
INSERT INTO kos_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Mukul se fin orek kosro nu sin mutan kien tamulel lun papa tumal ku nina kial, el akmwekinye tamulel sac. Ke ma inge el ac mutan sac fah eis mwata kac; kewana seltal ac fah wangin tulik natu. ");
INSERT INTO kos_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Mukul se fin eisla mutan kien tamulel lal, eltal kewa ac fah wangin tulik natultal. El orala sie ma na tia nasnas, ac akmwekinyala tamulel lal. ");
INSERT INTO kos_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","LEUM GOD El fahk, “Liyaung ma sap luk ac oakwuk luk nukewa, tuh acn Canaan su nga ac us kowos nu we fah tia siskowosla. ");
INSERT INTO kos_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Nimet oru facsin lun mwet su muta we. Nga ac lusak mwet pegan liki acn we tuh kowos fah ku in utyak nu we. Nga arulana kwase ouiya koluk lalos. ");
INSERT INTO kos_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Tusruktu nga wuleot tari nu suwos ke facl se inge, sie acn mut ac kasrup fohk we, tuh in ma lowos, ac nga fah sot nu suwos. Nga LEUM GOD lowos, ac nga srikowosla tari liki inmasrlon mutunfacl nukewa saya. ");
INSERT INTO kos_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ke ma inge, kowos fah arulana oru in kalem inmasrlon kosro ac won ma nasnas ac ma su tia nasnas. Nimet kowos kang kosro ku won ma nga akkalemye tari mu tia nasnas. Kowos fin kang ma inge, na ac oru kowos tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kowos fah mutal ac fah ma luk mukena, mweyen nga LEUM GOD, ac nga mutal. Nga srikowosla liki mutunfacl saya tuh kowos fah ma luk mukena. ");
INSERT INTO kos_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Kutena mukul ku mutan su sramsram nu sin ngunin mwet misa ac fah tatngal el nwe ke el misa; ac kutena mwet su oru ouinge uh, el sifacna oru elan misa.” ");
INSERT INTO kos_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","LEUM GOD El sapkin nu sel Moses elan fahkang nu sin mwet tol in fwil natul Aaron, ac fahk, “Wangin mwet tol fah sifacna oru elan tia nasnas ke sripen el wi orekma ke mas misa ke pacl sie mwet in sou lal ah misa, ");
INSERT INTO kos_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","sayen nina kial, papa tumal, wen se natul, acn se natul, tamulel se lal, ");
INSERT INTO kos_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ku tamtael lolap se lal su muta in lohm sel. ");
INSERT INTO kos_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","El fah tia akfohkfokyal sifacna ke misa lun mwet su kupasr nu sel ke sripen payuk. ");
INSERT INTO kos_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Wangin mwet tol ac fah resai kutena ip ke sifal, ku kalla sisken alut lal, ku sipik manol in akkalemye lah el asor. ");
INSERT INTO kos_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Enenu elan mutal na ac tia aklusrongtenye Inek. El oru kisa ke mwe mongo nu sik, ke ma inge el enenu in mutal. ");
INSERT INTO kos_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Sie mwet tol fah tiana payuk sin sie mutan kosro su eis molin kosro lal, ku sie mutan su tia virgin, ku sie su mukul tumal sisella. Sie mwet tol el mutal. ");
INSERT INTO kos_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Enenu mwet uh in akilen mu mwet tol el sie mwet mutal, mweyen el oru kisa ke mwe mongo nu sik. Nga pa LEUM GOD. Nga mutal ac nga oru mwet luk in mutal. ");
INSERT INTO kos_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Fin acn nutin sie mwet tol el orek kosro in eis moul kac, el akmwekinye papa tumal, na enenu in isisyak el nwe ke el misa. ");
INSERT INTO kos_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Oil in akmusra okwokyang tari nu fin sifen Mwet Tol Fulat, ac el akmutalyeyuk in nukum nuknuk lun mwet tol. Ke ma inge tia enenu in miraung sifal, ac el tia enenu in seya nuknuk lal in akkalemye lah el asor. ");
INSERT INTO kos_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","El fah tia som nu yen mano misa oan we — finne papa tumal ku nina kial, el fah tia akkolukyal kac. ");
INSERT INTO kos_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Oil in akmusra lun God lal oan facl, ke ma inge el fah tia akfohkfokye Lohm Nuknuk Mutal sik ke el illa liki in som nu ke mas misa. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","El fah payuk sin sie virgin, ");
INSERT INTO kos_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ac tia sie katinmas ku sie mutan su mukul tumal sisella, ku sie mutan kosro su eis molin kosro lal. El fah payukna sin sie virgin in sruf lal sifacna. ");
INSERT INTO kos_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","El fin tia oru ma inge, tulik natul, su fal in mutal, ac fah tia nasnas. Nga LEUM GOD, ac nga srella tari tuh elan Mwet Tol Fulat.” ");
INSERT INTO kos_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","LEUM GOD El sapkin nu sel Moses, ac fahk, ");
INSERT INTO kos_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Fahkang nu sel Aaron, wangin sie mwet inmasrlon sou lom su oasr kutena acn sukapas ke mano fah ase nu sik mwe kisa mongo. Oakwuk se inge ac fah ma nwe tok. ");
INSERT INTO kos_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Wangin sie mwet su sukapas in mano fah orek kisa: tia sie su kun, ku ul, ku musalla mano, ku fihkala; ");
INSERT INTO kos_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","tia sie su ulla pao ku nia; ");
INSERT INTO kos_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","tia sie su foingyak ku sie su srikac; tia sie su maskin muta ku mas ke kolo; ac tia sie eunuch. ");
INSERT INTO kos_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Wangin mwet in fwil natul Aaron, mwet tol, su oasr acn musalla in mano fah oru kisa mwe mongo nu sik. ");
INSERT INTO kos_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Kain mwet se inge ku in kang mwe mongo ma kisakinyuk nu sik, kewana mongo mutal ac mongo arulana mutal, ");
INSERT INTO kos_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","tusruktu ke sripen el sukapas in mano, el fah tia kalukyang nu ke lisrlisr mutal, ku tuku apkuran nu ke loang uh. El fah tiana akkolukye ma mutal inge, mweyen nga LEUM GOD, ac nga oru tuh ma inge in mutal.” ");
INSERT INTO kos_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Pa inge ma Moses el fahk nu sel Aaron, nu sin wen natul Aaron, ac mwet Israel nukewa. ");
INSERT INTO kos_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","elan fahk nu sel Aaron ac wen luo natul, “Kowos fah tia akpusiselye Ine mutal luk, ke ma inge kowos fah aklosye kowos sifacna ke kowos ac orekma ke mwe kisa mutal ma mwet Israel elos kisakin nu sik. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Kutena sin fwil nutuwos fin tia nasnas ac el tuku apkuran nu ke mwe kisa mutal su mwet Israel elos kisakin nu sik, na mwet sacn el tia ku in sifilpa kulansap ke loang uh. Oakwuk se inge ac fah ma nu ke pacl nukewa fahsru. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Wangin sie sin mwet tol in fwil natul Aaron su oasr mas sensenkinyuk ke mano, ku sroano koluk soror kacl, fah kang kutena mwe kisa mutal nwe ke na el nasnasla. Kutena mwet tol el fah tia nasnas el fin kahlye kutena ma su tia nasnas ke sripen el pusralla monin ma misa, ku fin oasr sroano koluk fahsr kacl, ");
INSERT INTO kos_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ku el fin pusralla soko kosro ku sie mwet ma tia nasnas. ");
INSERT INTO kos_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ouinge, kutena mwet tol su tia nasnas el fah mutana in tia nasnas lal nwe ke ekela, ac finne ekela el fah tiana kang kutena mwe kisa mutal nwe ke na el yihla. ");
INSERT INTO kos_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Tukun faht uh tili, na el fah nasnasla ac el ku in kang mwe kisa mutal, su pa ingan mwe mongo nal. ");
INSERT INTO kos_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","El fah tia kang ikwen kutena kosro ma sifacna misa ku anwuki sin kosro lemnak; ma inge ac oru el tia nasnas. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Mwet tol nukewa fah liyaung oakwuk ma nga orala inge. Elos fin tia liyaung, na ac fah oasr mwatalos ac elos ac misa, ke sripen elos seakos oakwuk mutal luk. Nga LEUM GOD, ac nga akmutalyalos. ");
INSERT INTO kos_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Mwet in sou lun mwet tol mukena fah ku in mongo ke mwe kisa mutal; wangin sie mwet saya ku in kang — finne mwet su mutwata walil, ku mwet ma el moli nu se in orekma lal. ");
INSERT INTO kos_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Tusruktu sie mwet foko lun mwet tol, su el molela ke mani lal sifacna, ku su ma isusla in lohm sel, fah ku in mongo ke mwe mongo ma itukyang nun mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Sie acn nutin mwet tol su payuk sin sie mwet su tia mwet tol, fah tia ku in kang kutena mwe kisa mutal. ");
INSERT INTO kos_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Tusruktu sie acn nutin mwet tol ma wangin tulik natu ac el katinmasla, ku su ma mukul tuma uh sisla, ac el foloko in tuh muta inpoun papa tumal in lohm sel, el ku in kang mongo itukyang nun papa tumal ke sripen el sie mwet tol. Mwet na in sou lun mwet tol mukena pa ku in kang ma inge. ");
INSERT INTO kos_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Kutena mwet su tia ma in sou lun mwet tol fin mongo ke mwe kisa mutal ke tia etu lal, el fah moli nu sin mwet tol molin ma el kangla, ac laesla ke percent longoul. ");
INSERT INTO kos_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Mwet tol el fah tia aklusrongtenye mwe kisa mutal, ");
INSERT INTO kos_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ke el lela kutena mwet su tia fal in mongo kac in kang. Ouiya se inge ac fah sang mwata ac kalya nu sin kain mwet se inge. Nga LEUM GOD, ac nga oru kisa inge in mutal.” ");
INSERT INTO kos_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","elan sang nu sel Aaron, wen natul kewa, ac nu sin mwet Israel nukewa oakwuk inge. Pacl se kutena sin mwet Israel, ku mwetsac su muta in facl Israel, oru sie kisa firir, finne ma in akfalye sie wulela, ku ke engan na lal in oru, kosro mwe kisa uh ac fah tia oasr kutena ma koluk ke manol. ");
INSERT INTO kos_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","In oru tuh mwe kisa uh in ohi sin God, enenu in kosro mukul soko su wanginna ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Kom fin kisakin kutena kosro su oasr ma koluk ke mano, LEUM GOD El ac tia insewowo kac. ");
INSERT INTO kos_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Mwet se fin oru sie kisa in akinsewowo nu sin LEUM GOD, finne ma in akfalye sie wulela, ku sie mwe sang ke insewowo na lal, kosro in kisa uh fah tia oasr kutena ma koluk ke mano, in mau wo sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Nimet kisakin nu sin LEUM GOD kutena kosro ma kunla muta, ku sukapasla, ku kanteyuki, ku oasr sronin faf kac, ku aryurla, ku turupweni mano. Nimet kisakin kain kosro ingan fin loang uh nu ke mwe kisa mongo. ");
INSERT INTO kos_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Tusruktu fin mwe kisa ke lungse na lom, kom ku in sang soko kosro ma isusla tuh sufas mano, ku matkang, a tia ma in akfalye sie wulela. ");
INSERT INTO kos_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Nimet sang nu sin LEUM GOD kutena kosro ma atrol itatu, ku mihsalik, ku futunla, ku laslasla. Ma inge tia lela in kisakinyuk in facl suwos. ");
INSERT INTO kos_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Nimet sang kutena kosro ma kowos eis sin mwetsac tuh in mwe kisa in mwe mongo. Kain kosro ingan lumweyuk mu oasr ma koluk ke manol ac God tia insewowo kac. ");
INSERT INTO kos_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Ke pacl se osweyukla soko cow ku soko sheep ku soko nani, kosro fusr soko ah enenu in mutana yurin nina kial ke len itkos, ac ke len se akoalkosr fahla, el fah ku in ituk nu ke mwe kisa firir nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Nimet kisakin soko cow ac cow fusr natul, ku soko sheep ac sheep fusr natul, ku soko nani ac nani fusr natul ke len sefanna. ");
INSERT INTO kos_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Ke pacl kom oru sie kisa in sang kulo nu sin LEUM GOD, oru in fal nu ke oakwuk ma orekla nu kac an, tuh kisa lom in fah mwe insewowo nu sel: ");
INSERT INTO kos_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","kangla ke len sacna, ac tia filiye kutu nu ke len tok an.” ");
INSERT INTO kos_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","LEUM GOD El fahk, “Akos ma nga sapkin. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Nimet aklusrongtenye Ine mutal luk. Mwet Israel nukewa enenu in akilen lah nga mutal. Nga LEUM GOD, ac nga oru kowos in mutal; ");
INSERT INTO kos_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ac nga uskowosme liki acn Egypt tuh nga fah God lowos. Nga LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","LEUM GOD El sang nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","oakwuk ten inge nu ke len in kufwa lulap ke mwet Israel elos fah fahsreni in alu. ");
INSERT INTO kos_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Oasr len onkosr nu suwos in oru orekma lowos, a esam lah len se akitkosr len Sabbath, sie len in mongla. Ke len sacn kowos fah tia orekma, a kowos fahsreni in alu. Sabbath uh ma lun LEUM GOD in kutena acn ma kowos muta we. ");
INSERT INTO kos_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Sulkakinelik len in kufwa inge nu ke pacl ma srisrngiyuki nu kac uh. ");
INSERT INTO kos_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Kufwen Alukela uh ma orek in akfulatye LEUM GOD, mutawauk ke faht uh ac tili ke len se aksingoul akosr in malem se meet. ");
INSERT INTO kos_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ke len se aksingoul limekosr Kufwen Bread Tia Akpulol mutawauk, ac ke lusen len itkosr kowos fah tia kang kutena kain in bread ma oasr mwe pulol kac. ");
INSERT INTO kos_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ke len se oemeet ke len inge kowos fah tukeni nu sie in alu, ac tia oru kutena orekma ma kowos oru ke len saya uh. ");
INSERT INTO kos_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Sang kisa in mwe mongo lowos nu sin LEUM GOD ke len itkosr. Ke len se akitkosr uh kowos fah sifilpa tukeni in alu, tusruktu kowos fah tia oru kutena orekma ma kowos oru len nukewa. ");
INSERT INTO kos_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Kaskas nu sin mwet Israel ac fahk nu selos, ‘Ke kowos utyak nu in facl se su nga ac sot nu suwos, ac kowos kosrani fokin ima uh, kowos fah use kahp in fahko se meet nu sin mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","El fah sang tuh in sie mwe kisa mutal nu sin LEUM GOD, tuh God El fah insewowo keiwos. Mwet tol el fah oru kisa se inge ke len se tukun Sabbath uh. ");
INSERT INTO kos_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ke len se kowos use mwe kisa ke wheat uh, kowos fah oayapa kisakin soko sheep fusr mukul yac se matwa su wanginna acn koluk ke mano, tuh in sie mwe kisa firir. ");
INSERT INTO kos_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Sang pac paun akosr ke flao ma aryarak ke oil in olive in wi, tuh in sie kisa in mwe mongo. Foulin kisa se inge ac fah akinsewowoye LEUM GOD. Kowos sang pac cup akosr ke wain in wi kisa se inge. ");
INSERT INTO kos_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Nimet kowos kang kutena wheat ma tufahna kinkinla uh, finne takmwek, ku manmanla, ku umla nu ke bread, nwe ke na kowos use kisa se inge nu sin God. Oakwuk se inge ac fah akilenyuk sin fwil nutuwos nukewa ke pacl nukewa fahsru uh.’” ");
INSERT INTO kos_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Oakla wik fon itkosr, mutawauk ke len se tukun Sabbath se ma kowos use kahp in wheat in tuh itukyang nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ke len se aklumngaul, len se tukun Sabbath se akitkosr, kowos sifilpa sang nu sin LEUM GOD sie pac kisa sasu ke wheat. ");
INSERT INTO kos_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Kais sie sou fah use lukwa lof in bread ac sang nu sin LEUM GOD tuh in sie mwe kite srisrila. Kais soko lof fah orekla ke paun in flao akosr ma oasr mwe pulol kac, na umla ac itukyang nu sin LEUM GOD tuh in sie kisa ke fahko se meet ke wheat ma kowos kosrani. ");
INSERT INTO kos_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ac kowos fah sang bread inge wi sheep fusr itkosr yac se matwa, soko cow mukul, ac lukwa sheep mukul, ac ma inge nukewa fah wanginna ma koluk ke mano. Ma inge ac itukyang tuh in sie mwe kisa firir nu sin LEUM GOD wi pac sie kisa wheat ac sie kisa wain. Foulin mwe kisa inge fah akinsewowoye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Oayapa kisakin soko nani mukul tuh in sie kisa ke ma koluk, ac lukwa sheep fusr mukul yac se matwa tuh in sie kisa in akinsewowo. ");
INSERT INTO kos_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Mwet tol el fah sang bread wi sheep fusr lukwa tuh in sie mwe kite srisrila nu sin LEUM GOD, su ac ma nu sin mwet tol. Kisa inge kewa ma mutal. ");
INSERT INTO kos_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ke len sac kowos fah tia oru kutena orekma ma kowos oru len nukewa, a kowos in pangoneni mwet uh in alu. Fwil nutuwos nukewa ac fah akfulatye oakwuk se inge ke pacl nukewa fahsru, in kutena acn elos muta we. ");
INSERT INTO kos_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Ke kowos kosrani ima lowos uh, nik kowos sunala wheat ma oan ke sisken ima uh, ac tia pac folokla in kunesla ma lula in ima uh. Filiya ma inge nu sin mwet sukasrup ac mwetsac. LEUM GOD El God lowos. ");
INSERT INTO kos_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Kaskas nu sin mwet Israel ac fahk, ‘Ke len se oemeet in malem se akitkosr kowos fah akfulatye sie len in mongla, sie len in esmakin su sulkakinyuk ke pusren mwe ukuk in pangon mwet uh in fahsreni nu ke alu. ");
INSERT INTO kos_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Sang sie kisa in mwe mongo nu sin LEUM GOD, ac tia oru kutena orekma ma kowos oru len nukewa.’” ");
INSERT INTO kos_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","LEUM GOD El kaskas nu sel Moses ac fahk, ");
INSERT INTO kos_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Len aksingoul in malem se akitkosr pa len in eela ma koluk. Ac fah sie len in tukena mutal lowos in alu. In len sac kowos fah lalo ac tia kang kutena ma, ac kowos in oru sie kisa in mwe mongo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Nimet kowos oru kutena orekma ke len sac, mweyen len in oru ouiya mutal nu ke eela ma koluk. ");
INSERT INTO kos_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Mwet se fin kang kutena ma ke len sac el fah tia sifil akilenyuk mu el sie sin mwet lun God. ");
INSERT INTO kos_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ac mwet se fin oru kutena orekma ke len sac, LEUM GOD El fah sifacna oru mwet sac in misa. ");
INSERT INTO kos_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Oakwuk se inge ma nu sin fwil nutuwos nukewa, in kutena acn ma elos muta we. ");
INSERT INTO kos_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Mutawauk ke pacl se faht uh ac tili ke len se akeu in malem sac, nwe ke faht uh tili ke len aksingoul, kowos akfulatye len se inge tuh in sie len srisrila nu ke mongla, su mwet uh in tiana kang kutena ma.” ");
INSERT INTO kos_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","LEUM GOD El kaskas nu sel Moses ac fahk, ");
INSERT INTO kos_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Fahkang nu sin mwet Israel, ‘Ke len aksingoul limekosr in malem se akitkosr, kowos fah oru Kufwen Iwen Aktuktuk nu sin LEUM GOD ke lusen len itkosr. ");
INSERT INTO kos_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","In len se oemeet ke len inge, kowos fah tukeni in alu, ac tia oru kutena orekma ma kowos oru len nukewa. ");
INSERT INTO kos_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kais sie len ke len itkosr inge kowos fah oru kisa ke mwe mongo. Ke len se akoalkosr, kowos sifilpa tukeni in alu ac oru sie kisa ke mwe mongo. Len in alu se pa inge, ac kowos fah tia oru kutena orekma.’” ( ");
INSERT INTO kos_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Pa inge len in kufwa mutal su kowos fah akfulatye LEUM GOD kac, ac tukeni in alu, ac usani mwe kisa ke mwe mongo, mwe kisa firir, mwe kisa wheat, mwe kisa wain, ac mwe kisa saya, oana ma oakwuk nu suwos ke kais sie len. ");
INSERT INTO kos_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Len in kufwa inge ac orek pacna sayen oakwuk lun len Sabbath uh, ac kisa inge ac weang pacna mwe sang lowos, ac kisa in akfalye wuleang, ac kisa ma orek na ke insewowo lowos sifacna, ma kowos sang nu sin LEUM GOD uh.) ");
INSERT INTO kos_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Tukun kowos kosrani ima lowos uh, kowos akfulatye kufwa se inge ke len itkosr, mutawauk ke len aksingoul limekosr in malem se akitkosr. Ac len se oemeet an ac fah srisrila mu sie len in mongla. ");
INSERT INTO kos_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","In len sacn, kowos eis kutu fokinsak ma wo emeet ke sak in ima lowos an, us kutu lesak palm ac kutu lesak ma ungung insroa, ac mutawauk in oru kufwa in akfulatye LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Oru akfulat lowos an ke len itkosr. Oakwuk se inge ac fah karinginyuk sin fwil nutuwos nukewa nwe tok. ");
INSERT INTO kos_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Mwet Israel nukewa fah mutana in lohm in aktuktuk inge ke len itkosr, ");
INSERT INTO kos_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","tuh fwilin tulik nutuwos fah etu lah LEUM GOD El tuh oru mwet Israel in mutana ke iwen aktuktuk ke El kololosme liki facl Egypt. El pa LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ouinge Moses el sang nu sin mwet Israel oakwuk ma elos in oru nu ke kufwa mutal inge in akfulatye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","LEUM GOD El fahkang nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","elan sang oakwuk ten inge nu sin mwet Israel: “Use oil in olive nasnas ma wo oemeet nu ke lam in Lohm Nuknuk Mutal, tuh kalmen lam uh fah oanna firirrir wo. ");
INSERT INTO kos_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Ke eku nukewa Aaron el fah akosak lam uh ye mutun LEUM GOD, ac liyaung tuh in oanna firir nwe ke lenelik, likin lisrlisr uh ke mutun Tuptup in Wuleang su oan in Acn Mutal Na Mutal. Oakwuk se inge ac fah karinginyuk in pacl nukewa fahsru. ");
INSERT INTO kos_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aaron el ac fah karingin lam uh fin sukan lam su orek ke gold nasnas, ac liyaung tuh in firirrir pacl nukewa ye mutun LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Eis paun longoul akosr ke flao ac munanak singoul lukwa lof in bread. ");
INSERT INTO kos_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Takunla lof inge nu ke tak lukwa, kais onkosr ke tak soko, fin tepu ma akmusrala ke gold nasnas ac oan ye mutun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Sang kutu mwe keng nasnas ke kais soko tak, srulun mwe kisa mongo nu sin LEUM GOD, in eis acn sin bread uh. ");
INSERT INTO kos_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ke len Sabbath nukewa in pacl fahsru uh, bread inge fah filiyuki ye mutun LEUM GOD. Pa inge ma kunen mwet Israel nwe tok. ");
INSERT INTO kos_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Bread inge ma nal Aaron ac fwil natul, ac elos fah mongo kac in sie acn mutal, tuh pa inge sie ip su arulana mutal ke mwe mongo su kisakinyuk nu sin LEUM GOD, ma nun mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Oasr sie mukul su nina kial mwet Israel ac papa tumal mwet Egypt. El som nu yen mwet Israel muta we, na el ac sie mwet Israel uh akukuinla we. ");
INSERT INTO kos_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Na wen se nutin mutan Israel sac kaskas enum ac selngawi Inen LEUM GOD, ac elos usalla nu yorol Moses. Inen nina kial pa Shelomith, su ma natul Dibri, sie mwet in sruf lal Dan. ");
INSERT INTO kos_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Na elos fililya nu in kapir, ac soano tuh LEUM GOD Elan akkalemye nu selos ma in orek nu sel. ");
INSERT INTO kos_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Usla mwet sacn liki nien aktuktuk uh. Mwet nukewa ma lohng selnga lal fah filiya pao fin sifal in orek loh lainul lah oasr mwatal, na mwet in acn sac nufon fah tanglal nwe ke el misa. ");
INSERT INTO kos_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Na kom fahkak nu sin mwet Israel lah kutena mwet su selngawi God, fah eis mwata fal nu ke selnga lal — ");
INSERT INTO kos_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ac fah anwuki el. Kutena sin mwet Israel, ku mwetsac su muta inmasrlon mwet Israel, ma selngawi LEUM GOD ac fah tatngal sin mwet in acn sac nwe ke el misa. ");
INSERT INTO kos_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Kutena mwet su orek akmas, fah anwuki pac el, ");
INSERT INTO kos_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ac kutena mwet su uniya kosro nutin siena mwet, fah enenu elan aolla. Kalmac pa: moul sang moli moul. ");
INSERT INTO kos_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Kutena mwet fin kunausla monin sie mwet, ma na el oru inge ac fah orek pac nu sel. ");
INSERT INTO kos_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","El fin koteya soko sri, soko sri kacl fah koteyuki; el fin tipalla sie atronmuta, sie atronmutal fah tipulyukla; el fin tokla soko wihs, na soko wihsel fah tuktukla. Kutena ma el kunausla ke sie mwet, ac fah folokinyuk pac nu sel. ");
INSERT INTO kos_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Kutena mwet su uniya soko kosro fah aolla, tusruktu kutena mwet su uniya sie mwet fah anwuki. ");
INSERT INTO kos_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ma sap se inge ma nu suwos nukewa, mwet Israel ac mwetsac su muta inmasrlowos, mweyen nga LEUM GOD lowos.” ");
INSERT INTO kos_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Tukun Moses el fahkak ma inge nu sin mwet Israel, elos usla mwet sac nu likin nien aktuktuk uh ac tanglal nwe ke el misa. Ouinge mwet Israel elos oru oana ma LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","LEUM GOD El kaskas nu sel Moses fin eol Sinai ac sap elan ");
INSERT INTO kos_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","sang oakwuk inge nu sin mwet Israel. “Pacl se kowos utyak nu in facl se su LEUM GOD El ac sot nu suwos, kowos fah akfulatye LEUM GOD ke kowos tia yoki facl sac ke yac akitkosr nukewa. ");
INSERT INTO kos_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kowos fah yukwi ima lowos, aknasnasye lah ke grape sunowos, ac kosrani fahko kac ke yac onkosr. ");
INSERT INTO kos_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Tusruktu yac se akitkosr ac fah yac in na mongla se nu ke facl sac, sie yac su kisayang nu sin LEUM GOD. Nimet kowos yukwi ima lowos ku aknasnasye lah in grape sunowos an. ");
INSERT INTO kos_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Kowos fah tia pacna kosrani wheat ma sifacna kapak, ac tia sifani fahko ke grape sunowos ma kowos tia aknasnasye ah. Yac in na mongla se lun acn nukewa in facl sac pa inge. ");
INSERT INTO kos_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Acn uh finne tia imaiyuk ke pulan yac sacn, ac srakna ku in asot mwe mongo nowos ac nun mwet foko lowos, ac mwet kowos moli in orekma lowos, ac mwetsac su muta inmasrlowos, ");
INSERT INTO kos_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","oayapa kosro muna nutuwos, ac kosro lemnak su muta inimae. Ma nukewa ma kap ke facl sac fah ku in mongo. ");
INSERT INTO kos_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Oakla yac itkosr pacl itkosr, pa toeni orala yac angngaul eu. ");
INSERT INTO kos_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Na in len se aksingoul ke malem se akitkosr, su Len in Eela Ma Koluk, kowos supwala sie mwet in ukya sie mwe ukuk ke el fahsr sasla fin acn sac nufon. ");
INSERT INTO kos_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","In ouiya se inge kowos fah srela yac se aklumngaul, ac sulkakin mu ac sie pacl in sukosok nu sin mwet nukewa su muta in fahl sac. Ke yac se inge acn nukewa su tuh kukakinyukla fah folokyang nu sin mwet su la acn inge meet, ku nu sin fwil natul, ac kutena mwet su tuh kukakinyukla in mwet kohs, fah folokla nu yurin sou lal. ");
INSERT INTO kos_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Kowos fah tia yukwi ima lowos, ku telani fahko ma sifacna kapak, ku sifani fahko ke ima in grape lowos ma tia kifwiyukla. ");
INSERT INTO kos_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Yac nufon sac ac fah mutal nu suwos; kowos fah mongo na ke ma sifacna kapak in ima lowos. ");
INSERT INTO kos_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Ke yac se inge acn nukewa ma kukakinyukla fah folokyang nu sin mwet la meet ah. ");
INSERT INTO kos_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ke ma inge, kowos fin kukakin acn lowos nu sin mwet Israel wiowos, ku moul acn selos, nik kowos orek inkanek kutasrik. ");
INSERT INTO kos_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Molin acn sacn ac fah oakwuk fal nu ke pisen yac ma acn sacn ac ku in oswe fahko meet liki Yac in Folokyang se tok ah. ");
INSERT INTO kos_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Fin ac yac pus, molo an enenu in yohk, ac fin yac na pu, na molo an enenu in srik, mweyen ma ac kukakinyukla uh ac wiwi pisa ku lupan fahko ma ac tuku ke acn sac. ");
INSERT INTO kos_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Nimet orek kutasrik nu sin mwet Israel wiowos, a kowos in akos LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Akos ma sap ac ma oakwuk nukewa lun LEUM GOD, tuh kowos fah ku in muta in misla fin facl se inge. ");
INSERT INTO kos_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Facl se inge ac fah isus fahko, ac kowos fah mutana in mut ac wangin fosrnga lowos. ");
INSERT INTO kos_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“Tusruktu, sahp ac oasr mwet fah siyuk lah mea ac mongo ke yac se akitkosr, ke wangin ma ac yoki ac wangin fahko sifeyukyak. ");
INSERT INTO kos_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","LEUM GOD El ac fah akinsewowoye acn uh ke yac se akonkosr, tuh ima lowos fah oswe mwe mongo ma ac fal nu ke yac tolu. ");
INSERT INTO kos_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Ke kowos yukwi ima lowos ke yac se akoalkosr, kowos ac srakna kang mwe mongo ma lula ke ma kowos sifani ke yac se akonkosr ah, su ac fal nu suwos in mongo kac nwe ke kowos kosrani ma kowos yukwi ke yac sacn. ");
INSERT INTO kos_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Acn lowos fah tiana kukakinyukla in tuh lun sie mwet nwe tok, mweyen tia ma lowos — ma lun God, ac kowos oana mwetsac su ma filfilyang in orekmakin acn uh. ");
INSERT INTO kos_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","“Ke pacl se kukakinyukla sie acn uh, enenu in akilenyuk lah oasr suwohs lun mwet se ma la acn sac meet in sifilpa molela. ");
INSERT INTO kos_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Fin sie mwet Israel sukasrupla tuh pwanang elan kukakunla acn lal uh, ac enenu in mwet se ma fototo oemeet nu sel in sou lal pa in molela uh. ");
INSERT INTO kos_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Mwet se ma wangin sou lal in sifil moli acn sac, sahp ac tok oasri ma lal ac el ku in sifacna sifilpa molela. ");
INSERT INTO kos_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Fin ouinge, el enenu in moli nu sin mwet se ma tuh molela acn sac ke sie lupa ma ac fal nu ke lusen pacl lula nu ke Yac in Folokyang se tok uh, mweyen pa inge pacl se acn sac ac nuna folokyang nu sel. ");
INSERT INTO kos_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Tusruktu fin tia fal lupan mani yorol in sifil molela acn sac, na ac oanna ye karinginyuk lun mwet se ma molela sel ah nwe ke sun Yac in Folokyang se tok uh. Ke pacl sacn ac fah folokyang nu sin mwet se la acn sac meet ah. ");
INSERT INTO kos_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Sie mwet fin kukakin lohm sel in sie siti ma kalkalak, oasr suwohs lal in sifilpa molela ke yac fon se tukun len se kukala uh. ");
INSERT INTO kos_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Tusruktu el fin tia sifilpa molela ke yac sac, ac wanginla suwohs lal in sifil moli, na lohm sac ac ma lac sin mwet se ma molela uh, ku fwil natul nwe tok. Na ac fah tia folokyang nu sin mwet se meet ah ke Yac in Folokyang sac. ");
INSERT INTO kos_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Tusruktu lohm ma oan ke inkul ma tia kalkalak uh ac fah orek oana ima uh — mwet se ma la na pwaye meet ah, oasr suwohs lal in sifil molela, ac enenu in folokyang nu sel ke Yac in Folokyang. ");
INSERT INTO kos_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Tusruktu, oasr suwohs lun mwet Levi in sifil molela lohm selos ke siti ma srisrngiyuki elos in muta we, ke kutena pacl. ");
INSERT INTO kos_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Fin sie lohm in siti inge tuh kukakinyukla sin sie mwet Levi ac el tia sifil molela, na ac enenu in folokyang nu sel ke Yac in Folokyang sac, mweyen lohm sin mwet Levi ma oan in siti selos uh ac ma na selos nwe tok. ");
INSERT INTO kos_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Tusruktu acn in ima ma oan raunla siti lun mwet Levi, ac fah tiana kukakinyuk. Acn inge ma na selos nwe tok. ");
INSERT INTO kos_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Sie mwet Israel wiom su muta apkuran nu yurum fin sukasrupla ac tia ku in konauk inkanek in kasru nu sel, kom fah sang kasru nu sel oana ke kom oru nu sin mwet su kom moli in orekma lom, tuh el fah ku in mutana apkuran nu yurum. ");
INSERT INTO kos_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Nik kom eis kutena ma laesla sel, a akos God, ac lela mwet Israel wiom in mutana apkuran nu yurum. ");
INSERT INTO kos_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Nimet kom oru elan moli ma ac laesla lupan mani ma kom kasrel kac, ac nimet orek kapak ke mwe mongo ma kom kukakin nu sel. ");
INSERT INTO kos_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Pa inge ma LEUM GOD lowos El sapkin, El su uskowosme liki facl Egypt in tuh sot facl Canaan lowos, ac in tuh God lowos. ");
INSERT INTO kos_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Sie sin mwet Israel wiom su muta apkuran nu yurum fin sukasrupla ac sifacna kukakunulot nu sum oana sie mwet foko, kom fah tia sang elan oru orekma lun sie mwet kohs. ");
INSERT INTO kos_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","El fah muta yurum oana sie mwet kom moli nu se, ac kulansap nu sum nwe ke sun Yac in Folokyang se tok uh. ");
INSERT INTO kos_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","In pacl sac, el ac tulik natul fah som liki kom, ac folokla nu yurin sou lal ac nu ke acn sin mwet matu lal su somla. ");
INSERT INTO kos_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Mwet Israel elos mwet kohs nu sin LEUM GOD, ac El usalosme liki facl Egypt. Elos fah tia kukakinyuk nu ke mwet kohs. ");
INSERT INTO kos_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Nimet kom oru upa nu selos, a kom in akos God lom. ");
INSERT INTO kos_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Kom fin enenu mwet foko, kom ku in moli sin mutanfahl ma raunikomla. ");
INSERT INTO kos_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Kom ku pac in moli tulik nutin mwetsac su muta inmasrlowos. Tulik inge ma isusla in facl suwos elos ku in ma lowosla, ");
INSERT INTO kos_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ac kom ku in eisalosyang in mwe usru nu sin tulik mukul nutum, su elos ac kulansupu ke lusen moul lalos nufon. A kom fah tiana oru in upa nu sin kutena mwet Israel wiom. ");
INSERT INTO kos_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Fin fahsr nwe sie mwetsac su muta yurum el ekla sie mwet kasrup, ac sie mwet Israel wiom el sukasrupla ac sifacna kukakunulang tuh elan mwet foko nu sin mwetsac sac, ku nu sin sou lun mwetsac sac, ");
INSERT INTO kos_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","srakna oasr suwohs lun mwet Israel sac in sifilpa moliyukla el tukun kukala el uh. Sie sin tamulel lal, ");
INSERT INTO kos_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ku mukul wien papa ku nina kial, ku mwet nutin tamulel ku tamtael lun papa ku nina kial, ku sie pacna su sou fototo lal, ku in sifil molella. Ku el sifacna, fin oasri mani lal ma ac fal in molella, el ku in sifacna molella elan sukosokla. ");
INSERT INTO kos_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","El enenu in aetuila nu sin mwet se ma molella ah, ac eltal fah oakla pisen yac ma el kukakunulla sifacna kac me nu ke Yac in Folokyang se tok uh, ac oaki molin sukosokla lal fal nu ke lupan moul ma orekmakinyuk nu sin mwet ma orekma ac moul nu se. ");
INSERT INTO kos_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","“Fin srakna pus yac lula uh, molin sukosokla lal uh ac fah oekyuk fal nu ke pisen yac lula, na pisa se inge ac fah folokinyuk nu sin mwet se ma molella ah. ");
INSERT INTO kos_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","A fin yac na pu pa lula nu ke Yac in Folokyang se tok uh, el fah akfalye molin sukosokla lal uh fal nu ke molin yac lula inge, ");
INSERT INTO kos_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","oana ke el fin orekma ac moul nu sel ke oakwuk lun molin yac. Leum se ma el orekma nu se uh fah tia oru in upala nu sel. ");
INSERT INTO kos_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","El fin tiana aksukosokyeyukla ke kutena sin ouiya inge, na el, ac tulik natul, fah aksukosokyeyukla ke Yac in Folokyang se tok uh. ");
INSERT INTO kos_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Sie mwet Israel tia ku in orekma in mwet kohs nwe tok, mweyen mwet Israel elos mwet kulansap nu sin LEUM GOD. El usalosme liki facl Egypt. El pa LEUM GOD lalos.” ");
INSERT INTO kos_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","LEUM GOD El fahk, “Nimet kowos orala kutena god lusrongten, ku tulokunak kutena ma sruloala, ku sru eot, ku taflela kutena eot kowos in alu nu kac. Nga LEUM GOD lowos. ");
INSERT INTO kos_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Karinganang len in kufwa mutal nukewa, ac sunakin acn se su mwet uh alu nu sik we. Nga LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Kowos fin moul fal nu ke ma sap luk ac akos ma nga sapkin, ");
INSERT INTO kos_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nga fah supu af nu suwos ke pacl fal, tuh facl suwos fah oswe fahko, ac sak in imae fah isus fahko. ");
INSERT INTO kos_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Sacn sunowos ac fah arulana ungung, oru kowos ac srakna kosrani ke wheat a sun pacl in sifani grape; kowos ac srakna sifani grape a sun pacl in yok wheat. Kowos ac fah mutkin kain mwe mongo nukewa, ac kowos fah mutana in misla fin acn suwos. ");
INSERT INTO kos_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Nga fah sot nu suwos misla in facl suwos, ac kowos fah motul ac tia sangeng sin kutena mwet. Nga fah oru in wanginla kosro sulallal fin acn uh, na ac fah wanginla pac mweun we. ");
INSERT INTO kos_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Kowos ac fah kutangla mwet lokoalok lowos: ");
INSERT INTO kos_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","mwet limekosr na suwos ac ku in kutangla mwet siofok, ac mwet siofok ac ku in kutangla tausin singoul. ");
INSERT INTO kos_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nga fah akinsewowoye kowos ac sot in pukanten tulik nutuwos. Nga fah liyaung na ip kunuk ke wuleang su nga orala nu suwos. ");
INSERT INTO kos_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Kosrani lowos ac fah arulana yohk, pwanang ac fah oasr wheat ke yac nufon se. Aok kowos ac enenu in sisla ma lula ke luwen ma meet ah in sakunla acn nu ke ma sasu uh. ");
INSERT INTO kos_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Nga fah muta inmasrlowos in Lohm Nuknuk Mutal sik, ac nga fah tiana ngetla liki kowos. ");
INSERT INTO kos_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nga fah wi kowos. Nga fah God lowos, ac kowos fah mwet luk. ");
INSERT INTO kos_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Nga LEUM GOD lowos. Nga uskowosme liki facl Egypt tuh kowos in tia sifilpa mwet kohs. Nga kunausla ku se ma toankowosi, ac oru tuh kowos in tia sifil fahsr suwoli.” ");
INSERT INTO kos_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","LEUM GOD El fahk, “Kowos fin tia akos ma nga sapkin, kowos ac fah kalyeiyuk. ");
INSERT INTO kos_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Kowos fin srunga akos ma sap luk ac oakwuk luk, ac kunausla wuleang su nga orala yuruwos, ");
INSERT INTO kos_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","nga fah kalyei kowos. Nga fah use ongoiya inge nu fowos: kain mas su tia ku in akkeyeyukla, ac folla lun monuwos su ac fah akkunye motowos ac oru moul lowos in munaslana. Kowos ac yoki ima lowos, tusruktu ac fah wangin sripa nu suwos mweyen mwet lokoalok lowos ac fah kutangkowosla ac kangla ma kowos yukwiya uh. ");
INSERT INTO kos_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nga fah foroht lain kowos tuh in kutangyukla kowos sin mwet lokoalok lowos, ac elos su srungakowos fah leumi kowos. Ac kowos fah arulana tuninfongla, oru kowos ac kaing finne wangin mwet ukwe kowos. ");
INSERT INTO kos_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Ma upa inge finne sikyak nu suwos a kowos srakna tia akosyu, na nga ac fah akyokyelik kalya luk nu suwos pacl itkosr. ");
INSERT INTO kos_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nga fah koteya nunak fulat lowos an. Ac fah wanginla af, ac facl suwos ac fah paola ac kekela oana osra. ");
INSERT INTO kos_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ac fah wangin sripen orekma upa lowos an, mweyen facl suwos ac fah tia isus fahko, ac sak sunowos ac fah tia fokla. ");
INSERT INTO kos_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Kowos fin srakna lainyu ac tia akosyu, nga fah sifilpa akyokyelik kalya luk nu suwos pacl itkosr. ");
INSERT INTO kos_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nga fah supwaot kutu kosro sulallal nu inmasrlowos, ac elos ac fah uniya tulik nutuwos, kunausla kosro nutuwos, ac oru tuh in mwet ekasriana lula suwos, na inkanek lowos ac fah wangin mwet forfor fac. ");
INSERT INTO kos_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Mwe keok inge nukewa fin orek nu suwos ac kowos srakna tiana porongeyu, a nuna lainyu, ");
INSERT INTO kos_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","na nga ac fah foroht ac akkeokye kowos in upa liki meet ah pacl itkosr. ");
INSERT INTO kos_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nga fah lela in mweuniyuk kowos in tuh kalyei kowos ke kowos kunausla wulela inmasrlosr. Ac kowos fin fahsreni nu in siti suwos in suk moul lowos, nga fah supwaot kutu kain in mas nu inmasrlowos ma tia ku in akkeyeyukla, su ac fah akkwacoye kowos ac oru kowos in filikowosyang nu inpoun mwet lokoalok lowos. ");
INSERT INTO kos_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Nga fah tulokinya mwe mongo liki kowos, tuh mutan singoul in fah tukeni orekmakin stove sefanna in akmolye flao nukewa ma oan yorolos. Elos fah kitalik nu suwos, ac ke kowos ac kangla nufon tari, kowos ac srakna masrinsral. ");
INSERT INTO kos_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Fin ma inge nukewa sikyak tari nu suwos a kowos srakna lainyu ac tia lungse akosyu, ");
INSERT INTO kos_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","na kasrkusrak luk ac fah oru nga in foroht ac sifilpa oru kalya luk nu suwos in upala liki meet ah pacl itkosr. ");
INSERT INTO kos_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Masrinsral lowos ac fah arulana upa, oru kowos ac fah kangla tulik nutuwos sifacna. ");
INSERT INTO kos_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nga fah kunausla acn in alu lowos fin tohktok uh, kunausya loang in kisa mwe keng lowos, ac sisang mano misa lowos nu fin ma sruloala lowos su topla oan infohk uh. Ke nga arulana kwase kowos ");
INSERT INTO kos_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","nga fah kunausla siti lowos in mwesri, kunausla acn in alu lowos, ac tia eis mwe kisa lowos. ");
INSERT INTO kos_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Nga fah kunausla acn suwos in arulana musalsalu, tuh mwet lokoalok lowos su ac utyak nu we ac fah arulana fwefela ke lupan musalla lun acn uh. ");
INSERT INTO kos_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nga fah use mweun nu fowos ac liskowoselik nu in mutunfacl saya. Acn suwos ac fah wanginla mwet fac, ac siti lowos fah arulana musalla. ");
INSERT INTO kos_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Na facl sac ac fah engankin yac akitkosr nukewa, ac mongla ke lusenna pacl wangin mwet muta we, mweyen kowos som muta in facl lun mwet lokoalok lowos. ");
INSERT INTO kos_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ke lusenna pacl ma wangin mwet muta we, facl sac ac fah mongla ac engankin yac akitkosr nukewa su kowos tuh tia akfalye ke kowos muta we uh. ");
INSERT INTO kos_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Nga fah oru tuh kowos su muta in sruoh in arulana tuninfongla, tuh pusren sra sak ma eng uh mokle ac fah oru kowos in sangeng ac kaing. Kowos ac fah kaing oana in ukohk kowos ke mweun, ac kowos fah ikori finne wangin mwet lokoalok apkuran nu yuruwos. ");
INSERT INTO kos_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Kowos ac fah tukulkul ac atoatoai ke wanginna mwet ukwe kowos, ac kowos ac fah tia ku in tuyak lain kutena mwet lokoalok lowos. ");
INSERT INTO kos_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Kowos ac fah mwet sruoh ac misa in mutunfacl saya, ac ukumyukla sin acn lun mwet lokoalok lowos. ");
INSERT INTO kos_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Mwet pu na suwos, su ac painmoulla in facl sin mwet lokoalok lowos, ac fah arulana munasla ke sripen ma koluk lowos sifacna, ac ke ma koluk lun mwet matu lowos meet ah. ");
INSERT INTO kos_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Tusruktu fwilin tulik nutuwos ac fah fahkak ma koluk lalos, ac ma koluk lun mwet matu lalos su tuh arulana likkeke nu sik ac tuyak lainyu, ");
INSERT INTO kos_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","pwanang nga tuh forla lainulos ac eisalosyang nu in sruoh in facl sin mwet lokoalok lalos. Na pa inge, ke fwilin tulik nutuwos uh sifacna akpusiselyalos ac eis tari kaiyuk ke ma koluk ac seakos lalos, ");
INSERT INTO kos_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","nga fah esam wulela luk inmasrlok ac Jacob, inmasrlok ac Isaac, ac inmasrlok ac Abraham, ac nga fah aksasuye wuleang luk in sang facl se inge nu sin mwet luk. ");
INSERT INTO kos_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Tusruktu, meet liki ma inge ac orek, enenu mwet nukewa su muta in facl sac in wanginla, tuh facl sac fah ku in engankin yac in mongla lal, ac mwet uh fah eis kaiyuk ke elos tuh pilesru ma sap luk ac oakwuk luk. ");
INSERT INTO kos_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ac finne ouinge, ke pacl ma elos srakna muta in acn sin mwet lokoalok lalos nga fah tia arulana siselosla ku kunauselosla. Nga fin oru ouinge ac tuh pwanang wuleang luk yorolos uh in tia akpwayeiyuk. Nga pa LEUM GOD lalos. ");
INSERT INTO kos_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Nga ac fah aksasuye wuleang su nga tuh orala yurin mwet matu lalos ke pacl se nga tuh akkalemye nu sin mutunfacl nukewa lupan ku luk, ac use mwet luk liki facl Egypt, in oru tuh nga, LEUM GOD, fah God lalos.” ");
INSERT INTO kos_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ma inge nukewa pa ma sap ac oakwuk su LEUM GOD El tuh sang nu sel Moses Fineol Sinai, tuh in ma nu sin mwet Israel. ");
INSERT INTO kos_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","LEUM GOD El sang nu sel Moses ");
INSERT INTO kos_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","oakwuk ten inge nu sin mwet Israel. Pacl se sie mwet el kitaung sie pacna mwet nu sin LEUM GOD in akfalye sie wuleang ku, mwet se ma kitakatyang uh ku in aksukosokyeyukla fin moulla sie sin lupan mani ten inge ");
INSERT INTO kos_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","fal nu ke srikasrak ma oakwuki. Lupan moul ma sie mukul su matwa oasr ke yac longoul nu ke onngoul, pa ipin silver lumngaul. ");
INSERT INTO kos_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Fin mutan se, lupan ma kom ac moli uh pa ipin silver tolngoul. ");
INSERT INTO kos_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Fin matwen mwet se oasr ke yac limekosr yak nu ke longoul — ipin silver longoul ke mukul, ac singoul ke mutan. ");
INSERT INTO kos_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Fin tulik ma malem seyak nu ke yac limekosr matwa — ipin silver limekosr ke mukul, ac tolu ke mutan. ");
INSERT INTO kos_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","A fin mwet se oasr ke yac onngoul yak nu lucng — ipin silver singoul limekosr ke mukul, ac singoul ke mutan. ");
INSERT INTO kos_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Mwet se ma orala wuleang sac fin arulana sukasrup ac tia ku in moli lupan mani ma oakwuk inge, na ac fah utuku el nu yurin mwet tol, na mwet tol fah orala sie moul fisrasr kutu, fal nu ke kuiyen mwet sac elan ku in moli. ");
INSERT INTO kos_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Fin wuleang sac ma nu ke soko kosro, su ac wo ac fal nu ke mwe kisa nu sin LEUM GOD, na mwe kite se ma orekla nu sin LEUM GOD uh mutal, ");
INSERT INTO kos_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ac mwet se ma orala wuleang sac fah tia aolla nu ke soko na kosro. El fin aolla, na kosro lukwa kewa ac ma lac lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Tusruktu wulela sac fin ma nu ke soko kosro ma tia nasnas, su ac tia wo in kisakinyuk nu sin LEUM GOD, na mwet sac enenu in usla kosro soko ah nu sin mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Na mwet tol sac fah orala sie lupan mol nu kac, fal nu ke woiya ku kolukiyen kosro soko ah, na ac fah pa ingan lupan molin kosro soko ah. ");
INSERT INTO kos_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Mwet sac fin ke sifilpa molela, na el fah moli lupan mol sac ac laesla pac ke percent longoul. ");
INSERT INTO kos_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Mwet se fin kisakin lohm sel nu sin LEUM GOD, mwet tol el ac fah orala sie lupan moul ma ac fal nu ke woiya ku kolukiyen lohm sac, na ac pa ingan lupan molo uh. ");
INSERT INTO kos_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Mwet se ma kisakunla lohm sac fin lungse sifil molela, el enenu in moli moul fon sac ac laesla pac ke percent longoul. ");
INSERT INTO kos_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Mwet se fin kisakin sie ipin acn lal nu sin LEUM GOD, molo uh ac fah oakwuk fal nu ke lupan barley ma ac yoki fin acn sac — ipin silver singoul ke kahp in barley se. ");
INSERT INTO kos_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","El fin ac sa na kisakunla acn sac tukunna Yac in Folokyang sac, na moul na fon ke acn sac ac fah orekmakinyuk. ");
INSERT INTO kos_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","A el fin kisakin acn sac ke kutu pacl tok, na mwet tol el ac fah motkwala sie lupan moul ma ac fal nu ke pisen yac lula nu ke Yac in Folokyang se tok ah, ac aksrikye kutu molo. ");
INSERT INTO kos_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Mwet se ma kisakunla acn sac fin ke sifilpa molela, na el ac enenu in moli moul na fon sac ac laesla ke percent longoul. ");
INSERT INTO kos_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","El fin soenna molela acn sac sin LEUM GOD a el sifilpa kukakin nu sin siena mwet, na ac wangin suwohs lal in sifilpa moli. ");
INSERT INTO kos_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ke Yac in Folokyang se tok ah, ima sac ac fah ma lac lun LEUM GOD nwe tok, na ac fah som nu sin mwet tol. ");
INSERT INTO kos_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Mwet se fin molela ima se ac kisakin nu sin LEUM GOD, ");
INSERT INTO kos_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","na mwet tol el ac fah orala sie lupan moul ma ac fal nu ke pisen yac lula nu ke Yac in Folokyang se tok uh, ac mwet sac enenu in molela ke len sacna; na mani kac uh ac ma lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ke ac sun Yac in Folokyang sac, ima sac ac fah folokyang nu sin mwet se la acn sac meet ah, ku nu sin fwil natul uh. ");
INSERT INTO kos_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Lupan moul nukewa ac fah wi na ma oakwuki tari. ");
INSERT INTO kos_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Wounse nutin ma orakrak nukewa nuna ma lun LEUM GOD, ke ma inge mwet uh tia ku in kisakin ma inge nu sin LEUM GOD in mwe sang ma orek ke insewowo na lalos. Soko cow fusr ku sheep fusr, ku nani fusr, nuna ma lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Tusruktu wounsien soko kosro su tia nasnas ac ku in sifilpa moulla ke moul ma oakwuki tari, wi percent longoul. Fin tia sifilpa moulla, ac ku in kukakinyukla nu sin kutena mwet ke lupan moul ma oakwuki tari uh. ");
INSERT INTO kos_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Wangin sie mwet fah kukakin, ku sifil moli, kutena ma su kisakinyukyang tuh in ma na lun LEUM GOD nwe tok— finne mwet se, ku kosro soko, ku acn se. Ma inge ma na lun LEUM GOD nwe tok. ");
INSERT INTO kos_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Finne mwet se ma kisaiyang tari tuh in ma na lun LEUM GOD nwe tok, fah tia ku in sifil moliyukla; ac enenu in anwuki el. ");
INSERT INTO kos_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Sie tafu singoul in fahko nukewa ke acn uh, finne wheat ku fokinsak, ac ma lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Mwet se fin lungse sifilpa molela kutena sin ma inge, el enenu in moli ke moul ma oakwuki nu kac ac laesla ke percent longoul. ");
INSERT INTO kos_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Kais soko inmasrlon kosro muna singoul nukewa ma lun LEUM GOD. Pacl se ma oekyuk kosro uh, ma soko aksingoul nukewa ac ma nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Mwet se ma natu kosro uh fah tia takunla in tuh kosro ma koluk lumah uh solla, ac el fah tia pac aolelik. El fin sang soko kosro aolla soko pacna kosro, na kosro lukwa ah kewa ac ma lac lun LEUM GOD, na ac fah tia ku in sifilpa moliyuk. ");
INSERT INTO kos_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Pa inge oakwuk ma LEUM GOD El tuh sang nu sel Moses Fineol Sinai, tuh in ma nu sin mwet Israel. ");
INSERT INTO kos_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ke len se oemeet ke malem se akluo in yac se akluo tukun mwet Israel illa liki acn Egypt, LEUM GOD El kaskas nu sel Moses in Lohm Nuknuk Mutal sel yen mwesis Sinai. El fahk, ");
INSERT INTO kos_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Kom ac Aaron in oru sie oaoa lulap ke sruf ac sou nukewa lun mwet Israel. Simusla inen mukul nukewa ");
INSERT INTO kos_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","yac longoulyak matwa, su ku in wi mweun. ");
INSERT INTO kos_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Sie mwet kol ke kais sie sruf in kasrekomtal.” ");
INSERT INTO kos_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","16","Pa inge inen mwet su ac fah kasreyomtal: Sruf Mwet Kol Reuben Elizur wen natul Shedeur Simeon Shelumiel wen natul Zurishaddai Judah Nashon wen natul Amminadab Issachar Nethanel wen natul Zuar Zebulun Eliab wen natul Helon Ephraim Elishama wen natul Ammihud Manasseh Gamaliel wen natul Pedahzur Benjamin Abidan wen natul Gideoni Dan Ahiezer wen natul Ammishaddai Asher Pagiel wen natul Ochran Gad Eliasaph wen natul Deuel Naphtali Ahira wen natul Enan Pa inge mwet ma solla liki inmasrlon mwet uh in oru oaoa se inge. Elos mwet kol ke kais sie sruf lalos. ");
INSERT INTO kos_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mwet singoul luo inge elos kasrel Moses ac Aaron ");
INSERT INTO kos_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","solani mwet uh nu sie ke len se meet in malem se akluo. Elos simusla inen mwet uh ke sruf lalos ac sou lun papa matu tumalos, ke inen mukul nukewa ma yac longoulyak matwa, ");
INSERT INTO kos_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","oana ke LEUM GOD El sapkin nu sel Moses. Ouinge el oakalosla in acn mwesis in Sinai. ");
INSERT INTO kos_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","Simla inen mukul nukewa ma yac longoulyak matwa ma ku in wi mweun, fal nu ke sruf ac sou lalos, mutawauk ke sruf lal Reuben, su matu emeet sin tulik natul Israel. Pa inge takla lun sruf ac pisalos: Sruf Pisalos Reuben 46,500 Simeon 59,300 Gad 45,650 Judah 74,600 Issachar 54,400 Zebulun 57,400 Ephraim 40,500 Manasseh 32,200 Benjamin 35,400 Dan 62,700 Asher 41,500 Naphtali 53,400 Pisa lulap: mukul onfoko tolu tausin ac lumfoko lumngaul. ");
INSERT INTO kos_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Tusruktu, mwet Levi elos tuh tia wi simla inelos in oana sruf saya uh, ");
INSERT INTO kos_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","mweyen LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ke pacl se kom oru oaoa lulap ke inen mukul ma fal in wi mweun, nimet sang sruf lal Levi nu kac. ");
INSERT INTO kos_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","A kom fah sang sruf Levi in fosrngakin Lohm Nuknuk Mutal sik ac kufwa nukewa nu kac. Elos fah us ma inge nukewa, ac elos pa ac kulansap loac. Elos in tulokunak iwen aktuktuk selos rauneak. ");
INSERT INTO kos_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kutena pacl kowos ac mukuila nu ke sie pacna acn, ma kunen mwet Levi in tuleya Lohm Nuknuk Mutal sik, ac sifilpa tulokunak ke nien aktuktuk sasu. Kutena mwet saya su tuku apkuran nu ke Lohm Nuknuk Mutal ac fah anwuki. ");
INSERT INTO kos_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Sruf nukewa sayen sruf lal Levi fah tulokunak lohm nuknuk selos fal nu ke kais sie u lalos, ac in oasr kais sie flag lun kais sie u. ");
INSERT INTO kos_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","A mwet Levi fah tulokunak lohm nuknuk selos rauneak Lohm Nuknuk Mutal sik tuh elos in karingin in wangin sie fah tuku apkuran nu kac ac pwanak kasrkusrak luk uh in putati fin mwet Israel nukewa.” ");
INSERT INTO kos_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ke ma inge mwet Israel elos oru ma nukewa oana ma LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","LEUM GOD El fahkang oakwuk inge nu sel Moses ac Aaron. ");
INSERT INTO kos_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Ke pacl mwet Israel uh aktuktuk uh, kais sie mwet fah muta ye flag lun sruf lal, ac ke mwe akul lun sou lal. Lohm nuknuk nukewa ac fah tulokyak rauneak Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","9","Elos su tulokinya nien aktuktuk selos layen kutulap, yen faht uh takak we, ac fah mwet ye flag lun u lulap lal Judah, ke kais sie u lalos. Mwet kol lun u tolu uh pa takla ten inge: Sruf Mwet Kol Pisalos Judah Nahshon wen natul Amminadab 74,600 Issachar Nethanel wen natul Zuar 54,400 Zebulun Eliab wen natul Helon 57,400 Pisa lulap: mukul siofok oalngoul onkosr tausin ac angfoko. U lulap lal Judah inge pa ac fahsr meet uh. ");
INSERT INTO kos_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","16","Nu layen nu eir, elos su wi muta ye flag lun u lulap lal Reuben fah mutangan aktuktuk in u tolu lalos, ye koko lun mwet kol lalos inge: Sruf Mwet Kol Pisalos Reuben Elizur wen natul Shedur 46,500 Simeon Shelumiel wen natul Zurishaddai 59,300 Gad Eliasaph wen natul Deuel 45,650 Pisa lulap: mukul tausin siofok lumngaul sie ac angfoko lumngaul. U lulap lal Reuben pa ac fahsr akluo uh. ");
INSERT INTO kos_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Na, inmasrlon u lulap luo meet ac u lulap luo tok ah, mwet Levi in fahsr us Lohm Nuknuk Mutal uh. Kais sie u ac fah fahsr fal nu ke takinyen mutangalos. Elos nukewa fah fahsr in u lalos ye flag lalos. ");
INSERT INTO kos_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","24","Nu layen nu roto, elos su wi muta ye flag lun u lulap lal Ephraim fah mutangan aktuktuk in u tolu lalos, ye koko lun mwet kol lalos inge: Sruf Mwet Kol Pisalos Ephraim Elishama wen natul Ammihud 40,500 Manasseh Gamaliel wen natul Pedahzur 32,200 Benjamin Abidan wen natul Gideoni 35,400 Pisa lulap: mukul siofok oalkosr tausin ac siofok. U lulap lal Ephraim pa ac fahsr aktolu uh. ");
INSERT INTO kos_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","31","Nu layen nu epang, elos su wi muta ye flag lun u lulap lal Dan fah mutangan aktuktuk in u tolu lalos, ye koko lun mwet kol lalos inge: Sruf Mwet Kol Pisalos Dan Ahiezer wen natul Ammishaddai 62,700 Asher Pagiel wen natul Ochran 41,500 Naphtali Ahira wen natul Enan 53,400 Pisa lulap: mukul siofok lumngaul itkosr tausin ac onfoko. U lulap lal Dan pa ac fahsr oetok uh. ");
INSERT INTO kos_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Pa inge pisen mwet Israel nukewa ke oaoala tari kais sie u: oasr mwet onfoko tolu tausin lumfoko lumngaul. ");
INSERT INTO kos_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Oana ke LEUM GOD El tuh sapkin nu sel Moses, mwet Levi uh tia wi oaoala lun mwet Israel uh. ");
INSERT INTO kos_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Mwet Israel elos oru ma nukewa oana LEUM GOD El tuh sapkin nu sel Moses. Elos mutangan aktuktuk ye flag lalos, ac ke elos mukuiyak elos fahsr fal nu ke takinyen sou lun papa tumalos. ");
INSERT INTO kos_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Pa inge fwilin tulik natul Aaron ac Moses ke pacl se LEUM GOD El tuh kaskas nu sel Moses Fineol Sinai. ");
INSERT INTO kos_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Oasr wen akosr natul Aaron: Nadab pa matu emeet, na Abihu, Eleazar, ac Ithamar. ");
INSERT INTO kos_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Elos akmusrala ac akmutalyeyukla nu ke orekma lun mwet tol. ");
INSERT INTO kos_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Tusruktu Nadab ac Abihu eltal misa ke sripen eltal tuh orek kisa nu sin LEUM GOD yen mwesis Sinai, ke sie e ma tia mutal. Wangin tulik natultal, ke sripa se inge Eleazar ac Ithamar eltal oru orekma lun mwet tol ke lusen pacl Aaron el moul. ");
INSERT INTO kos_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Kuhlma sruf lal Levi nu meet uh, ac srisrngelosi tuh elos in mwet kulansap lal Aaron mwet tol. ");
INSERT INTO kos_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Elos ac fah oru orekma ma eneneyuk nu ke Lohm Nuknuk Mutal sik, ac kulansupu mwet tol oayapa mwet Israel nukewa. ");
INSERT INTO kos_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Elos ac fah karingin kufwen mwe orekma nukewa ke Lohm Nuknuk Mutal, ac oru orekma ke inen mwet Israel nukewa. ");
INSERT INTO kos_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Pwayena ma kunen mwet Levi pa in kulansupal Aaron ac wen natul. ");
INSERT INTO kos_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Kom fah srisrngilya Aaron ac wen natul in oru orekma lun mwet tol; kutena mwet saya su srike in orekma kac ac fah anwuki.” ");
INSERT INTO kos_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Inge nga eis mwet Levi liki inmasrlon mwet Israel tuh elos in eis acn sin wounse nukewa nutin mwet Israel. Ouinge mwet Levi nukewa elos ma nutik, ");
INSERT INTO kos_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","tuh wounse nukewa ma nutik. Ke nga tuh uniya wounse mukul nukewa nutin mwet Egypt, na nga akmutalye wounse mukul nukewa nutin mwet Israel tuh in ma nutik — kewana mwet ac kosro; elos fah ma nutik. Nga, LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","In acn Mwesis Sinai LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","elan oakla mwet Levi fal nu ke kais sie sifen sou lulap lalos, ac elan simusla inen mukul nukewa ma malem seyak matwa. ");
INSERT INTO kos_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Na Moses el oru oana ma LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Pa inge inen wen tolu natul Levi: Gershon, Kohath, ac Merari. Elos pa matu in sou lulap lalos, su fwilin tulik natulos ekin. ");
INSERT INTO kos_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Oasr wen luo natul Gershon: Libni ac Shimei. ");
INSERT INTO kos_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Oasr wen akosr natul Kohath: Amram, Izhar, Hebron, ac Uzziel. ");
INSERT INTO kos_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Oasr wen luo natul Merari: Mahli ac Mushi. Elos inge pa matu in sou lalos, su fwilin tulik natulos ekin, ac elos nukewa ma ke sruf lun Levi. ");
INSERT INTO kos_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Fwilin tulik natul Libni ac fwilin tulik natul Shimei pa orala sou lulap se pangpang Gershon. ");
INSERT INTO kos_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Pisa lulap ke mukul su malem seyak matwa in sou lulap se inge oasr ke tausin itkosr ac lumfoko. ");
INSERT INTO kos_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Sou lulap se inge pa ac tulokunak lohm nuknuk selos tukun Lohm Nuknuk Mutal, layen roto. ");
INSERT INTO kos_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliasaph wen natul Lael pa mwet kol lun sou lulap se inge. ");
INSERT INTO kos_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ma kunen mwet in sou lulap lal Gershon pa in karinganang Lohm Nuknuk Mutal, mwe afyuf loac, mwe afyuf lik, ac lisrlisr nu ke acn in utyak uh, ");
INSERT INTO kos_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","oayapa mwe lisrlisr ke inkul uh su rauneak Lohm Nuknuk Mutal ac loang uh, ac lisrlisr nu ke nien utyak nu inkul uh. Elos pa ac fosrngakin orekma nukewa ma kupasr nu ke ma inge. ");
INSERT INTO kos_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Fwil in tulik natul Amram, ac fwilin tulik natul Izhar, ac fwilin tulik natul Hebron, ac fwilin tulik natul Uzziel pa orala sou lulap se pangpang Kohath. ");
INSERT INTO kos_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Pisa lulap ke mukul malem seyak matwa in sou lulap se inge oasr ke tausin oalkosr ac onfoko. ");
INSERT INTO kos_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Elos inge pa ac tulokunak lohm nuknuk selos layen eir ke Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ac Elizaphan wen natul Uzziel pa mwet kol lun sou lulap se inge. ");
INSERT INTO kos_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ma kunen mwet in sou lulap lal Kohath in karinganang Tuptup in Wuleang, tepu, sukan lam, loang uh, ahlu nukewa ma mwet tol elos orekmakin in Acn Mutal, ac mwe lisrlisr ke acn in utyak nu ke Acn Mutal Na Mutal. Elos pa ac fosrngakin orekma nukewa ma kupasr nu ke ma inge. ");
INSERT INTO kos_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Sifen mwet Levi nukewa pa Eleazar wen natul Aaron mwet tol. El pa kololos su oru orekma in Acn Mutal. ");
INSERT INTO kos_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Fwilin tulik natul Mahli ac fwilin tulik natul Mushi pa orala sou lulap se pangpang Merari. ");
INSERT INTO kos_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Pisa lulap ke mukul su malem seyak matwa oasr ke tausin onkosr ac luofoko. ");
INSERT INTO kos_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Elos inge pa ac tulokunak lohm nuknuk selos layen epang ke Lohm Nuknuk Mutal, ac Zuriel wen natul Abihail pa mwet kol lun sou lulap se inge. ");
INSERT INTO kos_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ma kunen mwet in sou lulap lal Merari in karinganang frem ke Lohm Nuknuk Mutal, sukan brace uh, sru uh, kapin sru uh, ac kufwen mwe orekma nukewa nu kac. Elos pa ac fosrngakin orekma nukewa ma kupasr nu ke ma inge. ");
INSERT INTO kos_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Oayapa elos pa ac fosrngakin sru uh, kapin sru uh, kwi ac sucl nu ke kalkal lik ah. ");
INSERT INTO kos_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moses, Aaron ac wen natul pa ac tulokunak lohm nuknuk selos mutun Lohm Nuknuk Mutal, layen kutulap. Ma kunalos in oru orekma nukewa in Acn Mutal nu sin mwet Israel. Kutena mwet saya su srike in oru orekma inge ac tufah anwuki. ");
INSERT INTO kos_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Pisa lulap ke mukul Levi nukewa su malem seyak matwa, su Moses el oakla ke kais sie sou lulap, fal nu ke ma LEUM GOD El tuh sapkin, oasr ke tausin longoul luo. ");
INSERT INTO kos_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Na LEUM GOD El fahk nu sel Moses: “Oakla wounse mukul nukewa nutin mwet Israel ma malem seyak matwa, ac simusla inelos. ");
INSERT INTO kos_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Tusruktu, in aol wounse nukewa inge, nga fah eis mwet Levi tuh in ma nutik. Nga LEUM GOD. Ac nga fah eis kosro nutin mwet Levi in aol wounsien kosro nukewa nutin mwet Israel.” ");
INSERT INTO kos_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ouinge Moses el oru oana ma LEUM GOD El sapkin, ac oakla wounse mukul nukewa ");
INSERT INTO kos_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","malem seyak matwa. Pisalos nukewa oasr ke tausin longoul luo ac luofoko itngoul tolu. ");
INSERT INTO kos_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Kom fah eis mwet Levi tuh elos in ma nutik in aol wounsien mwet Israel nukewa, ac eis kosro nukewa nutin mwet Levi in ma nutik, aoliyen wounsien kosro nukewa nutin mwet Israel. Nga LEUM GOD fahk ouinge. ");
INSERT INTO kos_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ke sripen wounsien mwet Israel pus liki mwet Levi ke mwet luofoko itngoul tolu, kom enenu in moli nu sik lupa yolyak sac. ");
INSERT INTO kos_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Molin kais sie selos pa ipin silver limekosr, fal nu srikasrak oakwuki nu kac. ");
INSERT INTO kos_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Kom fah sang mani inge nu sel Aaron ac wen natul.” ");
INSERT INTO kos_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ouinge, Moses el akos ac eisani ");
INSERT INTO kos_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ipin silver tausin sie ac tolfoko onngoul limekosr ");
INSERT INTO kos_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ac sang nu sel Aaron ac wen natul, fal nu ke kas ma LEUM GOD El tuh sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","LEUM GOD El fahk nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","elan oru sie oaoa ke sou lulap lal Kohath in sruf Levi, fal nu ke kais sie sou ac fwilin tulik natulos. ");
INSERT INTO kos_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Elan simusla inen mukul nukewa su oasr ke yac tolngoulyak nu ke lumngaul, su fal in orekma in Lohm Nuknuk Mutal sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Ma kunalos pa in orekma ke ma mutal na mutal. ");
INSERT INTO kos_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","LEUM GOD El sang oakwuk inge nu sel Moses: meet liki pacl in mukuiyak lun mwet Israel nukewa, Aaron ac wen natul ac ilyak nu in Lohm Nuknuk Mutal ac eisya lisrlisr ke mutun Tuptup in Wuleang ac sang afinya Tuptup sac. ");
INSERT INTO kos_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Elos fah sifilpa afinya ke sie kulun kosro fisrasrsrasr, ac laknelik sie nuknuk folfolnem oan fac, ac isongang srenenu nu kac. ");
INSERT INTO kos_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Elos fah laknelik sie nuknuk folfolnem fin tepu lun bread ma kisakinyuk nu sin LEUM GOD, ac filiya ma inge fac: ahlu, pol in nein mwe keng, pol in kisa, ac sufa mwe nein wain in kisa uh. Enenu na in oasr bread fin tepu sac pacl nukewa. ");
INSERT INTO kos_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Elos in laknelik sie nuknuk srusra fin ma inge nukewa, filiya sie kulun kosro fisrasrsrasr in afinya, na isongang srenenu nu kac. ");
INSERT INTO kos_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Elos fah eis sie nuknuk folfolnem ac afinya nien lam wi lam uh, mwe kosrkosr wik ac ahlu nu kac, ac mwe neinyuk oil in olive nukewa. ");
INSERT INTO kos_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Elos fah nokmani ma inge nukewa ke sie kulun kosro fisrasrsrasr, ac likiya fin sie pah in utuk. ");
INSERT INTO kos_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Na toko elos fah laknelik sie nuknuk folfolnem fin loang gold sac, sang sie kulun kosro fisrasrsrasr in afinya, ac isongang srenenu nu kac. ");
INSERT INTO kos_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Elos fah us kufwen mwe orekma nukewa ma orekmakinyuk in Acn Mutal, afinya ke sie nuknuk folfolnem, sang sie kulun kosro fisrasrsrasr in oan fac, ac likiya fin sie pah in utuk. ");
INSERT INTO kos_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Elos fah eisla apat kiris uh liki loang uh, ac laknelik sie nuknuk sroninmutuk oan fac. ");
INSERT INTO kos_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Elos fah filiya fac kufwen mwe orekma nukewa ma orekmakinyuk ke loang uh: pan in neinyuk mulut firir, mwe sruh, saful, ac pesin. Toko elos fah filiya sie ipin kulun kosro fisrasrsrasr afinya, ac isongang srenenu nu kac. ");
INSERT INTO kos_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ke pacl in mukui lun mwet uh, ac Aaron ac wen natul elos apweni tari kufwen mwe orekma mutal inge nukewa, na mwet in sou lal Kohath fah tuku srukak. Tusruktu elos in tiana pusralla ma mutal inge, mweyen elos ac misa. Pa inge ma kunen sou lal Kohath pacl nukewa Lohm Nuknuk Mutal uh mokleyuk uh. ");
INSERT INTO kos_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleazar, wen natul Aaron mwet tol, fah fosrngakin Lohm Nuknuk Mutal, ac oil nu ke lam uh, mwe keng uh, wheat in kisa, oil in akmusra, ac ma nukewa saya in Lohm Nuknuk Mutal ma akmutalyeyukla nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","LEUM GOD El fahk nu sel Moses ac Aaron, ");
INSERT INTO kos_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Nikmet lela tuh sou lal Kohath ");
INSERT INTO kos_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","in misa ke sripen elos tuku apkuran nu ke ma mutal na mutal inge. In karingin tuh ma se inge in tia sikyak, Aaron ac wen natul fah ilyak ac sang ma kunen kais sie mukul, ac fahkang ma elan us. ");
INSERT INTO kos_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Tusruktu mwet Kohath fin ilyak nu in Lohm Nuknuk Mutal ac liye ke mwet tol uh akoo ma mutal inge, finne ke kitin pacl na, elos ac misa.” ");
INSERT INTO kos_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","LEUM GOD El fahk nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","elan oru sie oaoa ke sou lulap lal Gershon in sruf Levi, fal nu ke kais sie sou ac fwilin tulik natulos. ");
INSERT INTO kos_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Elan simusla inen mukul nukewa su oasr ke yac tolngoulyak nu ke lumngaul; su fal in orekma in Lohm Nuknuk Mutal sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Elos fah fosrngakin usyen ma inge: ");
INSERT INTO kos_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Lohm Nuknuk Mutal, nuknuk se ma afinya, wi mwe afyuf se akluo ma orek ke kulun kosro fisrasrsrasr ma oan fac, lisrlisr nu ke nien utyak, ");
INSERT INTO kos_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","mwe lisrlisr ac sucl nu ke kalkal ma rauneak Lohm Nuknuk Mutal ac loang uh, mwe lisrlisr nu ke acn in utyak lun kalkal uh, ac kufwen orekma nukewa nu kac. Elos fah oru orekma nukewa ma eneneyuk nu ke ma inge. ");
INSERT INTO kos_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Moses ac Aaron enenu in liye lah mwet Gershon uh orala orekma nukewa kunalos, ac lah elos us ma nukewa ma Aaron ac wen natul uh kuneya nu selos. ");
INSERT INTO kos_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Pa inge ma kunen mwet in sou lal Gershon in Lohm Nuknuk Mutal. Elos ac fah oru ma inge ye koko lal Ithamar wen natul Aaron mwet tol. ");
INSERT INTO kos_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","LEUM GOD El fahk nu sel Moses elan oru sie oaoa ke sou lulap lal Merari in sruf Levi, fal nu ke kais sie sou ac fwilin tulik natulos. ");
INSERT INTO kos_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Elan simusla inen mukul nukewa su oasr ke yac tolngoulyak nu ke lumngaul su fal in orekma in Lohm Nuknuk Mutal sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Elos ac fah fosrngakin in us frem uh, sukan brace uh, sru uh, ac kapin sru nu ke Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","oayapa sru, kapin sru, kwi ac sucl nu ke kalkal rauneak Lohm Nuknuk Mutal, wi kufwa nukewa ma orekmakinyuk nu kac. Kais sie mukul fah fosrngakin in us ma na itukyang kunal. ");
INSERT INTO kos_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Pa inge ma kunen mwet in sou lal Merari in Lohm Nuknuk Mutal. Elos ac fah oru ma inge ye koko lal Ithamar wen natul Aaron mwet tol. ");
INSERT INTO kos_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Ke ma inge Moses ac Aaron ac mwet kol ke sruf nukewa elos oakla pisen mwet ke sou lulap lal Kohath, fal nu ke kais sie sou ac fwilin tulik natulos. ");
INSERT INTO kos_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Elos simusla inen mukul nukewa su oasr ke yac tolngoulyak nu ke lumngaul su fal in orekma in Lohm Nuknuk Mutal sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Pisa lulap ke sou inge kewa oasr ke tausin luo ac itfoko lumngaul. ");
INSERT INTO kos_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Pa inge pisen mwet ke sou lulap Kohath, elos nukewa su kulansap ke Lohm Nuknuk Mutal, su Moses ac Aaron oakla fal nu ke ma sap lun LEUM GOD nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Pisen mwet ke sou lulap lal Gershon, fal nu ke kais sie sou ac fwilin tulik natulos, ");
INSERT INTO kos_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","mukul nukewa su oasr ke yac tolngoulyak nu ke lumngaul su fal in orekma in Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","pisalos oasr ke tausin luo ac onfoko tolngoul. ");
INSERT INTO kos_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Pa inge pisen mwet ke sou lulap Gershon, elos nukewa su kulansap ke Lohm Nuknuk Mutal, su Moses ac Aaron oakla fal nu ke ma sap lun LEUM GOD nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Pisen mwet ke sou lulap lal Merari, fal nu ke kais sie sou ac fwilin tulik natulos, ");
INSERT INTO kos_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","mukul nukewa su oasr ke yac tolngoulyak nu ke lumngaul su fal in orekma in Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","pisalos oasr ke tausin tolu ac luofoko. ");
INSERT INTO kos_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Pa inge pisen mwet ke sou lulap Merari, su Moses ac Aaron oakla fal nu ke ma sap lun LEUM GOD nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Elos nukewa su oaoala sin mwet Levi, su Moses ac Aaron ac mwet kol lun Israel oakla fal nu ke kais sie sou ac fwilin tulik natulos, ");
INSERT INTO kos_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","mukul nukewa su oasr ke yac tolngoulyak nu ke lumngaul su fal in kulansap oayapa in utuk ma ke Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","pisa lulap lalos oasr ke tausin oalkosr ac lumfoko oalngoul. ");
INSERT INTO kos_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Simla inen kais sie mukul oana LEUM GOD El sapkin nu sel Moses; oayapa simla orekma kunen kais sie ac srisrngiyuki ma kais sie mwet in us, fal nu ke oakwuk lun LEUM GOD nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Sapkin nu sin mwet Israel elos in sisla liki nien aktuktuk uh kutena mwet ma wi musen lepa, oayapa elos su oasr sroano koluk soror ke manolos, ku kutena su fohkfokla ke sripen elos pusral monin ma misa. ");
INSERT INTO kos_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Kom fah lusla mukul ac mutan nukewa ma tia nasnas inge, tuh elos in tia akfohkfokye nien aktuktuk, yen nga muta inmasrlon mwet luk uh we.” ");
INSERT INTO kos_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Mwet Israel elos akos ac siselosla nukewa liki nien aktuktuk uh, oana ma LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","LEUM GOD El sang oakwuk inge nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","tuh mwet Israel in fahsr kac: Pacl se kutena mwet el lafwekin LEUM GOD ke sripen el orala sie ma koluk lain sie pac mwet, ");
INSERT INTO kos_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","el enenu in fahkak ma koluk el orala uh, ac akfalye nufon molin ma koluk sac, ac laesla pac ke sie tafu limekosr nu sin mwet se el orala ma koluk sac nu se uh. ");
INSERT INTO kos_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Tusruktu mwet sac fin misa ac wangin sou fototo lal in ku in moulyang nu se, na ac fah itukyang nu sin LEUM GOD tuh in ma lun mwet tol. Moul se inge ma sayen na sheep mukul soko ma mwet sac el ac srukak in kisakinyuk mwe aknasnasyela ma koluk lal. ");
INSERT INTO kos_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Mwe sang nukewa ma mwet Israel uh sang nu sin LEUM GOD ac fah ma lun mwet tol se su elos sang nu se. ");
INSERT INTO kos_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Kutena mwe sang ma itukyang nu sin sie mwet tol, ac fah ma na lal. ");
INSERT INTO kos_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","in fahkang oakwuk inge nu sin mwet Israel. Sie mukul fin sifacna fweni mu mutan kial aklalfonyal ");
INSERT INTO kos_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ke el orek kosro yurin sie pacna mukul, tusruk mukul tumal el tia etu na pwaye, mweyen sahp mutan kial uh okanla, ac wangin mwet liye in orek loh kac, ");
INSERT INTO kos_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","na mukul sac ku in lemtai mutan kial ke ouiya se inge. Ku mukul tumal ku pac in lemtai mutan kial, mutan sac finne tia orek kosro. ");
INSERT INTO kos_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Ke lumah luo inge kewa, mukul sac fah pwanla mutan kial nu yurin mwet tol, ac use mwe kisa oakwuki nu kac, su paun in flao luo ma orek ke barley, tusruk el fah tia okoaung kutena oil in olive nu fac, ku sang kutena mwe keng nu fac, mweyen mwe kisa se inge ma sin mukul lemta sac, in oru in kalem ma pwaye kac uh. ");
INSERT INTO kos_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Mwet tol uh fah fahk nu sin mutan sac in tuyak ye mutun loang uh. ");
INSERT INTO kos_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Mwet tol el fah ukuiya kutu kof mutal nu in sie pol orek ke kle, ac eis kutu fohkfok su oan fin falful in Lohm Nuknuk Mutal, ac filiya in kof uh tuh in akmwenye kof uh. ");
INSERT INTO kos_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Na el fah tulalik aunsifen mutan sac, ac filiya mwe kisa flao in paol. Mwet tol sac fah sifacna sruokya pol se ma kof mwen sac oan loac, ma in oru sie selnga. ");
INSERT INTO kos_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Toko mwet tol sac fah sap tuh mutan sac in insese nu ke fulahk su ac fwackyak sin mwet tol, su fahk ouinge: “Kom fin tiana orek kosro, kom fah tia ongoiya ke selnga se su kof se inge ac use. ");
INSERT INTO kos_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Tusruktu kom fin tuh orek kosro ");
INSERT INTO kos_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","lela LEUM GOD Elan oru tuh inem in sie mwe selnga inmasrlon mwet lom uh. Lela Elan oru acn in orek tulik lom in tulakeni, ac insiom in mutyak. ");
INSERT INTO kos_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Lela kof se inge in utyak nu insiom ac oru in mutyak, ac nien orek tulik lom in tulakeni.” Na mutan sac fah fahk, “Nga insese; lela LEUM GOD Elan oru oana.” ");
INSERT INTO kos_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Na mwet tol el fah simusla kas in selnga inge ac fweang nu in pol in kof mwen sac. ");
INSERT INTO kos_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Meet liki el ac sang mutan sac in nim kof sac, su ac ku in oru elan waiok upa, ");
INSERT INTO kos_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","mwet tol el ac fah eis flao in kisa liki inpoun mutan sac, ac kolak in kisakin nu sin LEUM GOD, ac filiya fin loang uh. ");
INSERT INTO kos_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Toko el fah lafusak kutu tuh in sie mwe kisa in esmakin, ac furreak fin loang uh. Tukun ma inge nukewa, el fah sang mutan sac in numla kof sac. ");
INSERT INTO kos_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Fin pwaye mutan sac el tuh orek kosro, kof sac ac pwanak ngal upa nu sel; insial ac mutyak, ac nien tulik lal ac tulakeni. Inel ac fah sie mwe selnga in masrlon mwet lal. ");
INSERT INTO kos_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Tusruktu el fin pwayena ac wangin mwatal, ac fah wangin keok nu sel, ac el ac ku in sifil orek tulik. ");
INSERT INTO kos_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Pa inge ma sap nu ke lemta, ke pacl sie mukul el sifacna fweni mu mutan kial uh orek kosro. ");
INSERT INTO kos_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Mutan sac fah enenu in tu ye mutun loang uh, na mwet tol el fah oru ouiya inge nukewa nu sin mutan sac. ");
INSERT INTO kos_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mukul sac ac fah wangin mwatal, a mutan sac fin kosro, el ac fah sifacna us mwatal. ");
INSERT INTO kos_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","elan sang oakwuk inge nu sin mwet Israel: Kutena mukul ku mutan su orala sie wuleang ku in moul oana sie Nazirite ac kisakunulang sifacna nu sin LEUM GOD ");
INSERT INTO kos_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","fah srella liki mwe nim ku ac mwe sruhi. El fah tia nim kutena mwe nim ma orekla ke sronin grape, ku kang grape ku raisin. ");
INSERT INTO kos_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ke lusenna pacl ma el oaoa mu el sie mwet Nazirite, el fah tia kang kutena ma su tuku ke oa in grape, finne ke fita ku ke kulun grape. ");
INSERT INTO kos_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ke lusenna pacl el muta ye wuleang lun Nazirite, el fah tia kalla aunsifal ku resaela alut lal. El kapiri ke wuleang sac ke lusenna pacl el kisakunulang nu sin LEUM GOD, ac el fah fuhlela aunsifal ac alut lal uh in kapna. ");
INSERT INTO kos_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","In len nukewa ma el srella nu sin LEUM GOD, el fah tia apkuran nu ke sie mano misa. ");
INSERT INTO kos_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Finne misa papa tumal ku nina kial, ku tamulel ac tamtael lal, el enenu na elan tia apkuran nu ke manolos ac akfohkfokyal sifacna. Aunsifal pa akkalemye lah el sriyukla nu sin God. ");
INSERT INTO kos_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ke lusen pacl el sie mwet Nazirite el sriyukla ac akmutalyeyuk nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Fin fohkfokla aunsuf ma mutal lun sie Nazirite ke sripen oasr mwet se misa in kitin pacl ah na siskal, el enenu in soano len itkosr, na resaela aunsifal ac alut lal; ac ouinge el fah sifilpa nasnasla. ");
INSERT INTO kos_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ke len se akoalkosr uh, el ac fah use luo wuleoa ku luo na wule nu sin mwet tol ke nien utyak lun Lohm Nuknuk Mutal sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Mwet tol el fah kisakin sie tuh in mwe kisa ke ma koluk, ac sie tuh in mwe kisa firir, in aknasnasyalla ke sripen el pusral mano misa se. Ke len sacna, mwet sac fah sifilpa akmutalye aunsifal, ");
INSERT INTO kos_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ac elan sifilpa kisakunang pacl lal nu sin LEUM GOD, fal nu ke sie mwet Nazirite. Pacl meet ah tia oaoa, mweyen aunsuf mutal lal meet ah fohkfokla. Ac nu ke kisa in akfalye ma koluk lukma, el fah use soko sheep mukul yac sie matwa. ");
INSERT INTO kos_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Pa inge ma oakwuk nu sin sie Nazirite su aksafyela tari wuleang lal. El fah som nu ke acn in utyak lun Lohm Nuknuk Mutal ");
INSERT INTO kos_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ac kisakin tolkwe kosro ma wangin ma koluk ke mano nu sin LEUM GOD; soko sheep mukul yac se matwa nu ke mwe kisa firir, ac soko sheep mutan yac se matwa in mwe kisa ke ma koluk, ac soko ma mukul nu ke mwe kisa in akinsewowo. ");
INSERT INTO kos_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","El fah oayapa sang sie fotoh in bread ma wangin mwe pulol kac: lof matoltol orekla ke flao karyak ke oil in olive, ac cake minini akmusrala ke oil in olive. Ma inge ac weang mwe sang ke flao ac wain. ");
INSERT INTO kos_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Mwet tol fah sang ma inge nukewa nu sin LEUM GOD ac oru mwe kisa ke ma koluk ac mwe kisa firir. ");
INSERT INTO kos_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","El fah kisakin sheep mukul soko ah nu sin LEUM GOD tuh in mwe kisa in akinsewowo, ac kisakin wi fotoh in bread sac; el fah oayapa oru mwe kisa ke mwe mongo ac ke wain. ");
INSERT INTO kos_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Mwet Nazirite sac fah resaela aunsifal ke acn in utyak nu in Lohm Nuknuk Mutal uh, ac sang nu fin e se ma kisa in akinsewowo firriyukyak fac. ");
INSERT INTO kos_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Na ke pacl se poelyak tari ikwa se ke finpisen sheep mukul soko ah, mwet tol sac fah eisla wi lof matoltol soko ac sie cake minini uh liki fotoh sac, ac sang nu inpoun Nazirite sac. ");
INSERT INTO kos_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Toko, mwet tol el ac fah sang ma inge tuh in sie mwe sang sriyukla nu sin LEUM GOD. Ma inge sie mwe sang mutal nu sin mwet tol sac, in weang iniwa ac nien sheep mukul soko ah, su ke oakwuk lun ma sap uh ac ma lun mwet tol sac. Tukun ma inge, mwet Nazirite sac ac ku in nim wain. ");
INSERT INTO kos_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Pa inge ma sap nu sin mwet Nazirite uh. Tusruktu sie Nazirite fin wulela in sang yohk liki ma sap nu sel uh, el fah akfalye in oana ke el wulela uh. ");
INSERT INTO kos_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","tuh elan fahk nu sel Aaron ac wen natul in orekmakin kas inge ke elos akinsewowoye mwet Israel: ");
INSERT INTO kos_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","LEUM GOD Elan akinsewowoyekowos ac karingin kowos. ");
INSERT INTO kos_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","LEUM GOD Elan kulang ac pakoten nu suwos. ");
INSERT INTO kos_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","LEUM GOD Elan ngeti nu fowos ke lungse, ac sot misla nu suwos. ");
INSERT INTO kos_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ac LEUM GOD El fahk, “Elos fin fahkak Inek in mwe akinsewowo nu fin mwet Israel uh, na nga fah akinsewowoyalos.” ");
INSERT INTO kos_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ke len se Moses el tulokunak tari Lohm Nuknuk Mutal sin LEUM GOD, el mosrwela ac kisaela Lohm Nuknuk sac wi kufwen orekma nukewa kac, oayapa loang uh wi kufwen orekma nukewa nu kac. ");
INSERT INTO kos_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Na sifen sou lulap nukewa su mwet kol in sruf lun Israel, nuna mwet na ma fosrngakin oaoa lulap se ke pisen mwet uh, ");
INSERT INTO kos_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","elos use mwe sang lalos inge nu sin LEUM GOD: wagon onkosr ac cow mukul singoul lukwa, wagon soko sin kais luo mwet kol, ac cow soko sin kais sie mwet kol. Tukun elos sang ma inge, ");
INSERT INTO kos_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Eis mwe sang inge in orekmakinyuk nu ke ma ac orek ke Lohm Nuknuk Mutal. Sang nu sin mwet Levi uh fal nu ke orekma ma elos ac oru.” ");
INSERT INTO kos_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ouinge Moses el sang wagon ac cow mukul uh nu sin mwet Levi. ");
INSERT INTO kos_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","El sang lukwa wagon uh ac akosr cow uh nu sin mwet lal Gershon, ");
INSERT INTO kos_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ac wagon akosr ac cow oalkosr nu sin mwet lal Merari. Orekma nukewa lalos orek ye kolyuk lal Ithamar wen natul Aaron. ");
INSERT INTO kos_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Tusruktu wangin wagon ku cow Moses el sang nu sin mwet in sou Kohath, mweyen kufwen orekma mutal ma elos karingin uh enenu na in utuk finpisalos. ");
INSERT INTO kos_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Na mwet kol elos oayapa use mwe kisa lalos in akfulatye kisala lun loang uh. Ke elos akola in sang mwe kite lalos mutun loang uh, ");
INSERT INTO kos_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","LEUM GOD El fahk nu sel Moses, “Fahkang nu selos lah in kais sie len ke lusen len singoul luo, kais sie mwet kol fah srukak mwe kite lal nu ke kisaiyen loang uh.” ");
INSERT INTO kos_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Na elos use mwe kisa lalos uh oana ke takla ten inge: Len Sruf Mwet Kol len se meet Judah Nahshon, wen natul Amminadab Akluo Issachar Nethanel, wen natul Zuar Aktolu Zebulun Eliab, wen natul Helon Akakosr Reuben Elizur, wen natul Shedur Aklimekosr Simeon Shelumiel, wen natul Zurishaddai Akonkosr Gad Eliasaph, wen natul Deuel Akitkosr Ephraim Elishama, wen natul Ammihud Akoalkosr Manasseh Gamaliel, wen natul Pedahzur Akeu Benjamin Abidan, wen natul Gideoni Aksingoul Dan Ahiezer, wen natul Ammishaddai Aksingoul sie Asher Pagiel, wen natul Ochran Aksingoul luo Naphtali Ahira, wen natul Enan Mwe sang ma kais sie selos tuh use inge oana sie: sie pesin silver su toasriya oasr ke ounce lumngaul, ac sie pol silver su toasriya ounce tolngoul, fal nu ke srikasrak ma oakwuki, kewana sessesla ke flao karyak ke oil in olive nu ke mwe kisa wheat; sie ahlu gold su toasriya ounce akosr, sessesla ke mwe keng; cow mukul fusr soko, sheep mukul soko, ac sheep fusr mukul soko yac se matwa, nu ke mwe kisa firir; nani soko nu ke kisa ke ma koluk; cow mukul lukwa, sheep mukul limekosr, nani limekosr, sheep fusr limekosr yac se matwa nu ke kisa in akinsewowo. ");
INSERT INTO kos_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","88","Pa inge pisen mwe kisa ma mwet kol singoul luo ah orani nu ke pacl se ac kisaiyuk loang uh: — pol silver singoul luo ac pesin silver singoul luo, toasriya oasr ke paun onngoul — ahlu gold singoul luo, toasriya ounce angngaul oalkosr, sessesla ke mwe keng — cow mukul singoul lukwa, sheep mukul singoul lukwa, sheep fusr mukul singoul lukwa yac se matwa, wi mwe kisa wheat nu kac tuh in mwe kisa firir — nani mukul singoul lukwa tuh in mwe kisa ke ma koluk — cow mukul longoul akosr, sheep mukul onngoul, nani mukul onngoul, sheep fusr mukul onngoul yac se matwa. Ma inge ma nu ke mwe kisa in akinsewowo ");
INSERT INTO kos_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ke Moses el ilyak nu in Lohm Nuknuk Mutal in kaskas nu sin LEUM GOD, el ac lohng pusren LEUM GOD kaskas nu sel inmasrlon cherub luo ma oan fin mwe afyuf ke Tuptup in Wuleang uh. ");
INSERT INTO kos_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","LEUM GOD El kaskas nu sel Moses ac fahk, ");
INSERT INTO kos_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Fahk nu sel Aaron lah pacl se el filiya lam itkosr fin nien lam uh, elan oakiya tuh in tolak acn meet.” ");
INSERT INTO kos_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaron el oru oana, ac oakiya lam uh tuh kalem kac in tolak mutun nien lam uh. ");
INSERT INTO kos_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Orekla nien lam uh ke gold tuktuki, lucngi na nwe ten, fal nu ke lumah se su LEUM GOD El fahk nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Srela mwet Levi uh liki mwet Israel ngia, ac aknasnasyalosla ");
INSERT INTO kos_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","in ouiya se inge: sroksrokunulosyak ke kof in aknasnas, ac sap elos in resaela manolos nufon, ac ohlla nuknuk lalos uh. Na elos ac fah nasnasla. ");
INSERT INTO kos_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Na elos fah eis soko cow mukul fusr, ac lupan flao karyak ke oil in olive ma eneneyuk nu ke mwe kisa wheat; ac kom fah eis soko pac cow mukul nu ke mwe kisa ke ma koluk. ");
INSERT INTO kos_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Toko kom orani mwet Israel nukewa ac sap mwet Levi in tuyak ye mutun Lohm Nuknuk Mutal, su pa acn nga muta we. ");
INSERT INTO kos_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Na mwet Israel elos fah filiya paolos fin sifen mwet Levi uh, ");
INSERT INTO kos_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ac Aaron el fah kisakunma mwet Levi uh nu sik oana sie mwe sang sriyukla sin mwet Israel uh, tuh elos in oru orekma luk. ");
INSERT INTO kos_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Na mwet Levi fah filiya paolos fin sifen cow mukul lukwa; soko ac fah mwe kisa ke ma koluk, ac ma soko ngia nu ke mwe kisa firir. Ouiya se inge in orek ke alu in aknasnas lun mwet Levi. ");
INSERT INTO kos_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Kisakunma mwet Levi uh oana sie mwe sang sriyukla nu sik, ac sang tuh Aaron ac wen natul in liyalosyang. ");
INSERT INTO kos_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","In lumah se inge kom fah srela mwet Levi uh liki mwet Israel saya, na elos fah ma nutik. ");
INSERT INTO kos_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Tukun kom aknasnasyela ac kisakunla mwet Levi uh, elos ac fah fal in orekma in Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Nga eisalos in aolla wounse mukul nukewa nutin mwet Israel, ac elos ma na nutik. ");
INSERT INTO kos_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ke nga tuh onela wounse nukewa nutin mwet Egypt uh, nga tuh akmutalye wen se ma matu oemeet in kais sie sou in Israel, ac wounsien kosro nukewa, tuh in ma nutik sifacna. ");
INSERT INTO kos_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Inge nga eis mwet Levi in aolla wounse nukewa nutin mwet Israel, ");
INSERT INTO kos_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ac nga sang kunal Aaron ac wen natul elos in liyaung mwet Levi oana sie mwe kite sin mwet Israel, tuh elos fah orekma in Lohm Nuknuk Mutal nu sin mwet Israel, ac in loango mwet Israel liki ongoiya ma ac ku in sonolos elos fin tuku apkuranla nu ke Acn Mutal.” ");
INSERT INTO kos_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ouinge Moses, Aaron ac mwet Israel nukewa kisakunla mwet Levi, oana ke LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Mwet Levi elos aknasnasyalos sifacna ac ohlla nuknuk lalos, ac Aaron el kisakunulos oana sie mwe kite sriyukla nu sin LEUM GOD. El oayapa oru alu in aknasnas nu selos. ");
INSERT INTO kos_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Mwet Israel akfalye ma nukewa ma LEUM GOD El sapkin nu sel Moses elan oru ke mwet Levi. Ouinge mwet Levi elos fal in oru orekma in Lohm Nuknuk Mutal ye koko lal Aaron ac wen natul. ");
INSERT INTO kos_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Kais sie mwet Levi su yac longoul limekosryak matwa, ac fah oru orekma kunal in Lohm Nuknuk Mutal sik, ");
INSERT INTO kos_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","na el ac mongla liki orekma kunal ke el sun yac lumngaul matwa. ");
INSERT INTO kos_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Tukun pacl sacn, el ku in kasru mwet Levi wial in oru orekma kunalos in Lohm Nuknuk Mutal, tusruktu el tia ku in sifacna orekma. Pa inge ma kom ac oakiya nu ke kulansap lun mwet Levi.” ");
INSERT INTO kos_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","LEUM GOD El kaskas nu sel Moses yen Mwesis Sinai ke malem se meet lun yac se akluo tukun mwet Israel elos illa liki facl Egypt. El fahk, ");
INSERT INTO kos_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Lela mwet Israel in liyaung Kufwen Alukela ke pacl pakiyuki nu kac. ");
INSERT INTO kos_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ke eku in len aksingoul akosr ke malem se inge, kowos fah liyaung fal nu ke ma sap ac oakwuk nukewa nu kac.” ");
INSERT INTO kos_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ke ma inge Moses el fahkang nu sin mwet uh elos in akfulatya Kufwen Alukela. ");
INSERT INTO kos_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ouinge ke eku in len aksingoul akosr in malem se meet elos oru akfulat lalos in acn Mwesis Sinai. Mwet uh oru ma nukewa oana ke LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Tusruktu oasr kutu mukul ma tia nasnas ke sripen elos pusralla monin mwet misa se, oru elos tia ku in akfulatye Kufwen Alukela ke len sac. Elos som nu yorol Moses ac Aaron ");
INSERT INTO kos_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ac fahk, “Kut tia nasnas mweyen kut kahlye mano misa se. Tusruktu efu ku in sriyukla kut liki mwet Israel saya in tia wi sang mwe kite lasr nu sin LEUM GOD?” ");
INSERT INTO kos_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moses el topuk, “Soano nga in eis kas in kasru sin LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","LEUM GOD El fahkang nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","elan fahk nu sin mwet Israel, “Pacl se kutena suwos, ku tulik nutuwos uh, tia nasnas ke sripen el pusralla sie mano misa, ku ke fufahsryesr nu yen loessula, a kowos srakna lungse wi akfulatye Kufwen Alukela, ");
INSERT INTO kos_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ac ku in lela nu suwos in akfulatye ke malem se toko, ke eku in len aksingoul akosr in malem se akluo. Kowos fah akfulatye ke bread tia akpulol ac mahsrik mwen. ");
INSERT INTO kos_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Nimet filiya kutena luwen mongo uh nu ke lotu se tok uh, ac tia kotalik kutena sri ke kosro uh. Akfulatye Kufwen Alukela fal nu ke ma sap nukewa nu kac. ");
INSERT INTO kos_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Tusruktu kutena mwet su nasnas na ac tia fufahsryesr nu yen saya, a el tia wi akfulatye Kufwen Alukela, fah tia sifil oaoa mu el mwet luk, mweyen el tia akfalye in use mwe sang lal nu sik ke pacl fal. El fah eis mwatan ma koluk se lal uh. ");
INSERT INTO kos_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Fin oasr mwetsac muta inmasrlowos su lungse wi akfulatye Kufwen Alukela, el enenu in oru oana ma sap ac oakwuk nukewa nu kac. Ma sap se inge ma nu sin mwet nukewa, finne mwetsac ku mwet na in acn sacn.” ");
INSERT INTO kos_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ke len se ma Lohm Nuknuk Mutal uh tulokinyukyak, sie pukunyeng afunla. Mutawauk ke ekela nu ke lotutang toko, pukunyeng sac liyeyuk oana luman e uh. ");
INSERT INTO kos_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Pacl nukewa ouinge: pukunyeng sac afunla ke len, ac e uh liyeyuk ke fong. ");
INSERT INTO kos_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Pacl nukewa pukunyeng sac mukuiyak liki fin Lohm Nuknuk Mutal uh, na mwet Israel elos ac mukuiyak. Ke acn se ma pukunyeng sac ac tuhwi we uh, na mwet Israel elos ac aktuktuk we. ");
INSERT INTO kos_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ke sap lun LEUM GOD mwet Israel elos fahsr, ac ke sap lun LEUM GOD mwet Israel elos tui in aktuktuk. Ke lusenna pacl pukunyeng sac okak fin Lohm Nuknuk Mutal, elos ac oakwuk na in nien aktuktuk selos. ");
INSERT INTO kos_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Pukunyeng sac finne oan paht fin Lohm Nuknuk Mutal, mwet Israel elos ac liyaung na sap lun LEUM GOD, ac tia mukuila. ");
INSERT INTO kos_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kutu pacl uh pukunyeng sac ac oan fin Lohm Nuknuk Mutal ke len na pu, na in oana sap lun LEUM GOD, elos ac mutana okak ke nien aktuktuk uh. Elos ac mukuiyak ku mutana, fal nu ke sap lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Kutu pacl uh pukunyeng sac ac oanna ke ekela nu ke lotutang na mukuiyak; na pacl se pukunyeng sac mukuiyak, mwet uh mukuiyak pac. ");
INSERT INTO kos_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Finne len luo ku malem se ku yac se ku paht liki, lusenna pacl pukunyeng sac oanna fin Lohm Nuknuk Mutal, mwet Israel elos ac mutana yen elos aktuktuk we. Tusruktu ke pacl se pukunyeng sac mukuiyak, na elos ac mukuila pac. ");
INSERT INTO kos_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Elos ac tuleya nien aktuktuk uh ac sifil tulokunak in fal nu ke sap lun LEUM GOD su El sang nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Orala luo mwe ukuk ke silver tuktuki, in orekmakinyuk in pangoneni mwet uh nu sie, ac in sulkakin pacl in tuleya nien aktuktuk uh. ");
INSERT INTO kos_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Pacl se ac loes ukyen mwe ukuk luo an kewa, na sruf nukewa lun Israel fah fahsreni nu yurum ke nien utyak lun Lohm Nuknuk Mutal sik. ");
INSERT INTO kos_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Tusruktu ke pacl siena sin mwe ukuk inge kas, na mwet kol mukena lun sou lulap uh fah tukeni nu yurum. ");
INSERT INTO kos_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Pacl se pusren ukuk uh kasla wotwot uh, sruf ma muta layen kutulap fah mukuiyak in fahsr. ");
INSERT INTO kos_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Pusren ukuk uh fin kasla wotwot pacl se akluo, na sruf layen eir fah mukuiyak. Ouinge, pusren ukuk uh fin pisrpisr ac wotwot, ma in akkalemye pacl in tuleyuki nien aktuktuk uh. ");
INSERT INTO kos_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Tusruktu in pangoneni sruf nukewa nu sie, na ukuk uh ac asla pusra. ");
INSERT INTO kos_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Mwe ukuk inge ac fah ukuk sin wen natul Aaron, mwet tol. Oakwuk inge in karinginyukyang in pacl nukewa fahsru. ");
INSERT INTO kos_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ke pacl kowos ac mweun in lain mwet lokoalok su utyak nu in facl suwos in mweuni kowos, ukya mwe ukuk inge, mwe sensenkakin mwet uh lah ac oasr mweun. Na nga LEUM GOD lowos, fah kasrekowos ac molikowosla liki mwet lokoalok lowos. ");
INSERT INTO kos_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Oayapa ke pacl in aengani lowos — ke Kufwen Malem Sasu ac kutena kufwen akfulat ke alu lowos — kowos fah ukya mwe ukuk pacl se kowos oru mwe kisa firir ac mwe kisa in akinsewowo. Na nga ac fah kasrekowos. Nga LEUM GOD lowos.” ");
INSERT INTO kos_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ke len se aklongoul in malem se akluo in yac se akluo tukun mwet Israel illa liki facl Egypt, pukunyeng se ma oan fin Lohm Nuknuk Mutal sin LEUM GOD mukuiyak, ");
INSERT INTO kos_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","na mwet Israel uh mutawauk fufahsryesr lalos liki yen Mwesis Sinai. Pukunyeng sac tuku ac tui yen mwesis Paran. ");
INSERT INTO kos_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Elos mutawauk in fahsr, fal nu ke ma LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Pacl nukewa ma elos ac mukuiyak, elos ac takla oana ma oakwuk nu selos. Elos su oasr ye flag lun u ke sruf lal Judah pa ac fahsr meet uh, kais sie u nu ke u, ac Nahshon wen natul Amminadab pa leumi u inge kewa. ");
INSERT INTO kos_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethanel wen natul Zuar pa leumi u ke sruf lal Issachar, ");
INSERT INTO kos_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ac Eliab wen natul Helon pa leumi u ke sruf lun Zebulun. ");
INSERT INTO kos_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Na Lohm Nuknuk Mutal fah tuleyuki, ac sou lulap lal Gershon ac Merari pa ac us fahsr meet. ");
INSERT INTO kos_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Toko, elos su oasr ye flag lun u ke sruf lal Reuben pa ac mukuiyak, kais sie u nu ke u, ac Elizur wen natul Shedeur pa leumi u inge kewa. ");
INSERT INTO kos_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumiel wen natul Zurishaddai pa leumi u ke sruf lal Simeon, ");
INSERT INTO kos_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ac Eliasaph wen natul Deuel pa leumi u ke sruf lal Gad. ");
INSERT INTO kos_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Na mwet Levi ke sou lal Kohath elos fah mukuiyak ac us ma mutal. Ke elos ac sun sie pac acn in aktuktuk sasu, Lohm Nuknuk Mutal uh tulokinyukyak tari. ");
INSERT INTO kos_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Toko, elos su oasr ye flag lun u ke sruf lal Ephraim fah mukuiyak, kais sie u nu ke u, ac Elishama wen natul Ammihud pa leumi u inge kewa. ");
INSERT INTO kos_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel wen natul Pedahzur pa leumi u ke sruf lal Manasseh, ");
INSERT INTO kos_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ac Abidan wen natul Gideoni pa leumi u ke sruf lal Benjamin. ");
INSERT INTO kos_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","U ma fahsr etok, su karingin tuh in wangin mwe lokoalok tuku tok ah me, pa u se ye flag lun sruf lal Dan, kais sie u nu ke u, ac Ahiezer wen natul Ammishaddai pa leumi u inge kewa. ");
INSERT INTO kos_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiel wen natul Ochran pa leumi u ke sruf lal Asher, ");
INSERT INTO kos_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ac Ahira wen natul Enan pa leumi u ke sruf lal Naphtali. ");
INSERT INTO kos_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Pa inge takla lun fahsr lun mwet Israel, u nu ke u, ke pacl nukewa elos ac tuleya iwen aktuktuk selos in mukuiyak. ");
INSERT INTO kos_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moses el fahk nu sel Hobab, wen natul Jethro mwet Midian, su matu liki mutan kial su, “Kut akola in som nu in facl se ma LEUM GOD El fahk mu El ac ase sesr. El tuh wulema in akinsewowoye mwet Israel u. Ke ma inge, fahsru wi kut ac kut fah oru tuh kom in wi ipeis ke mwe insewowo inge.” ");
INSERT INTO kos_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobab el topuk ac fahk, “Tari, nga ac tia wi. Nga ac folokla nu yurin mwet luk in facl sik.” ");
INSERT INTO kos_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moses el fahk, “Nunak munas, nik kom som liki kut. Kom etu acn fal kut ku in aktuktuk we in acn mwesis uh, ac kom ku in atol kut nu we. ");
INSERT INTO kos_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kom fin wi kut, kut ac oru tuh kom in wi ipeis ke mwe insewowo nukewa su LEUM GOD El ac ase nu sesr.” ");
INSERT INTO kos_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ke mwet uh fahsr liki eol mutal Sinai, elos fahsr len tolu. Pacl nukewa Tuptup in Wuleang lun LEUM GOD pa fahsr meet lukelos in akkalemye acn elos ac aktuktuk we. ");
INSERT INTO kos_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ke elos ac fahsr liki kais sie acn elos aktuktuk we, pukunyeng lun LEUM GOD oan faclos ke len uh. ");
INSERT INTO kos_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Pacl nukewa ke Tuptup in Wuleang ac mukuiyak uh, Moses el ac fahk, “LEUM GOD, tuyak ac akfahsryelik mwet lokoalok lom, ac oru tuh elos su srungakom in kaingelik!” ");
INSERT INTO kos_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Na pacl nukewa ac tui uh, el ac fahk, “LEUM GOD, foloko nu yurin mwet tausin puspis su sou lun Israel.” ");
INSERT INTO kos_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Mwet uh mutawauk in torkaskas nu sin LEUM GOD ke ma upa ma sikyak nu selos. Ke LEUM GOD El lohng torkaskas lalos, El kasrkusrakak ac supweya e nu fin mwet uh. E sac firir inmasrlolos ac esukak sie siska ke nien aktuktuk uh. ");
INSERT INTO kos_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Mwet uh wowoyak nu sel Moses, na el pre nu sin LEUM GOD, ac e sac kunla. ");
INSERT INTO kos_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ke ma inge acn sac pangpang Taberah, mweyen pa inge acn se e lun LEUM GOD firir inmasrlolos. ");
INSERT INTO kos_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Oasr mwetsac wi mwet Israel in fahsr lalos. Oasr nikaru na yohk lalos ke ikwa, ac finne mwet Israel sifacna elos mutawauk in torkaskas ac fahk, “Ke nasr kutu ikwa ah! ");
INSERT INTO kos_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Esamak ik pukanten kut tuh kang in acn Egypt, ma wangin molo. Esam pac cucumber, watermelon, leek, onion, ac garlic kut kang we ah. ");
INSERT INTO kos_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","A inge kut ngulngul ke wangin na pwaye ma kut in kang sayen manna se inge len nukewa!” ( ");
INSERT INTO kos_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna uh oana luman fita srisrik se, ac tuhna uh rangrang mulala. ");
INSERT INTO kos_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Mwet uh ac illa ac sifani, na ilya, ku tuktukya, ac poeleak ac orek cake kac. Emah uh oana eman flao umla ke oil in olive. ");
INSERT INTO kos_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Ke aunfong uh apunla nien aktuktuk uh ke fong, manna uh putati pac.) ");
INSERT INTO kos_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moses el lohngak torkaskas lun mwet uh ke elos tukeni mutun lohm nuknuk selos uh. El arulana toasrla mweyen LEUM GOD El kasrkusrak selos, ");
INSERT INTO kos_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ac el fahk nu sin LEUM GOD, “Efu kom ku oreyu ouinge? Efu kom ku toasr sik? Efu kom ku filiya in nga pa fosrngakin mwet inge nukewa? ");
INSERT INTO kos_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Mea, nga pa oralosla ku oswela mwet inge uh? Efu kom ku siyuk ngan orekma oana sie mwet to ac kafsalosyak oana tulik srakna titi, ac usalos nwe ke facl se ma kom tuh wulela kac nu sin mwet matu lalos meet ah? ");
INSERT INTO kos_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Nga ac konauk oya ikwa ma ac fal nu sin mwet inge nukewa? Elos sasao na ac siyukyuk ikwa. ");
INSERT INTO kos_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Nga tia ku in sifacna fosrngakin mwet inge nukewa; arulana upala nu sik! ");
INSERT INTO kos_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Fin pa inge ma kom ac oru nu sik, tari uniyuwi tuh nga in tia pula mwe keok kom oru inge.” ");
INSERT INTO kos_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","LEUM GOD El fahk nu sel Moses, “Eisani itngoul mwet kol matu ma ohi sin mwet uh, ac pwanulosme nu yuruk ke Lohm Nuknuk Mutal sik, ac fahk elos in wi kom tu ingo. ");
INSERT INTO kos_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nga fah oatume ac kaskas nu sum we, ac nga fah eis kutu ngun su nga filiya fom ac filiya faclos. Na elos ac fah ku in kasrekom lippise kutu fosrnga lom ke mwet inge, ac kom fah tia mukena in polong. ");
INSERT INTO kos_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Inge fahk nu sin mwet uh, ‘Aknasnasye kowos sifacna nu lutu. Ac fah oasr ikwa nowos. LEUM GOD El lipsre sasao lowos ke kowos mu kowos kena in oasr ikwa nowos, ac ke kowos mu wo nu suwos ke kowos srak muta Egypt. Inge LEUM GOD El fah asot ikwa nowos, ac kowos fah mongo kac. ");
INSERT INTO kos_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ac fah tia nu ke len se na ku luo, ku len limekosr, ku singoul, ku longoul, a kowos fah kang ");
INSERT INTO kos_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ke malem na fon se, nwe ke kowos srungala ngok fohlo, ac maskunak. Ma se inge ac sikyak mweyen kowos ngetla liki LEUM GOD su muta inmasrlowos, ac kowos torkaskas nu sel mu kowos in na tia tuku liki acn Egypt.’” ");
INSERT INTO kos_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moses el fahk nu sin LEUM GOD, “Mwet onfoko tausin pa wiyu inge, ac kom fahk mu kom ac sang ikwa fal nu selos ke malem na fon se? ");
INSERT INTO kos_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Cow ac sheep nukewa fin anwuki, ya ac fal nu selos? Ya ik nukewa in meoa uh fin sruhu, ya ac ku in sang kitalos?” ");
INSERT INTO kos_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","LEUM GOD El topuk, “Ya oasr saflaiyen ku luk uh? Ac tia paht kom ac fah liye lah ma nga fahk uh ac sikyak, ku tia!” ");
INSERT INTO kos_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ke ma inge Moses el illa ac fahk nu sin mwet uh ma LEUM GOD El fahk. El eisani itngoul sin mwet kol ac oakelosi apunla Lohm Nuknuk Mutal uh. ");
INSERT INTO kos_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Na LEUM GOD El oatui in pukunyeng uh ac kaskas nu sel. El eisla kutu sin ngun ma El tuh filiya facl Moses, ac sang nu fin mwet kol itngoul uh. Ke pacl se ngun inge oan faclos, elos mutawauk in sasa oana mwet palu uh, tusruktu ke kitin pacl na. ");
INSERT INTO kos_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Eldad ac Medad, luo sin mwet kol itngoul, eltal mutana in nien aktuktuk uh ac tia wi som nu ke Lohm Nuknuk Mutal. Na ngun sac tuku nu faclos in nien aktuktuk, ac elos wi pac sasa oana mwet palu. ");
INSERT INTO kos_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mwet fusr se kasrusr som fahk nu sel Moses ma Eldad ac Medad oru uh. ");
INSERT INTO kos_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Na Joshua wen natul Nun, su nuna mwet kasru nu sel Moses oe ke el fusr ah me, el fahk nu sel Moses, “Leum luk, sap eltal in tui!” ");
INSERT INTO kos_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Na Moses el topuk, “Ya kom nunku mu ku in oasr ma ac sikyak nu sik ke ma eltal oru uh? Nga kena LEUM GOD Elan sang ngun lal nu sin mwet lal nukewa, ac oru elos nukewa in sasa oana mwet palu!” ");
INSERT INTO kos_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ouinge Moses ac mwet kol itngoul lun Israel elos folokla nu in nien aktuktuk uh. ");
INSERT INTO kos_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Tia paht na LEUM GOD El oru sie eng in tuhyak ac use won quail meoa me. Elos sohk fit tolu fulata fin fohk uh yak, ac putati fin nien aktuktuk uh, oayapa rauneak mael nu ke mael apunla. ");
INSERT INTO kos_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ke len sac nufon, fong fon sac, ac len se toko ah nufon, mwet uh kafofona ke sruh quail. Wangin mwet telani supus liki fotoh lumngaul, na elos oralik yen nukewa ke nien aktuktuk uh in oayuk ke faht. ");
INSERT INTO kos_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ke srak yolyak ikwa nalos, LEUM GOD El kasrkusrakak sin mwet uh, ac oru tuh sie mas upa in sikyak inmasrlolos. ");
INSERT INTO kos_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Elos pikinya mwet oasroasr in mongo ikwa we, na elos pangon acn sac Kibroth Hataavah, oana fahk mu “Kulyuk Lun Mwet Oasroasr In Mongo Ikwa.” ");
INSERT INTO kos_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Mwet uh mukuiyak liki acn sac nu Hazeroth, ac tulokunak nien aktuktuk selos we. ");
INSERT INTO kos_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moses el tuh payukyak sin sie mutan Cush. Miriam ac Aaron kaskas in akkolukyal Moses kac. ");
INSERT INTO kos_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Eltal fahk, “Mea, LEUM GOD El kaskas nu sin mwet uh sel Moses mukena? Ya El tia kaskas pac kacsr?” LEUM GOD El lohng ma eltal fahk. ( ");
INSERT INTO kos_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Moses el mwet na fakpap se, yohk liki kutena mwet fin faclu.) ");
INSERT INTO kos_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","In kitin pacl ah na LEUM GOD El fahk nu sel Moses, Aaron, ac Miriam, “Nga lungse komtal kewa in tuku nu ke Lohm Nuknuk Mutal sik.” Na eltal som, ");
INSERT INTO kos_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ac LEUM GOD El oatui in sie sru in pukunyeng, ac tu ke nien utyak lun Lohm Nuknuk Mutal. El pangnol Aaron ac Miriam, na eltal kalukyang, ");
INSERT INTO kos_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ac LEUM GOD El fahk, “Lohng ma nga ac fahk inge! Ke pacl oasr mwet palu inmasrlowos, nga sifacna fahkyuyak nu selos ke aruruma, ac nga kaskas nu selos in mweme. ");
INSERT INTO kos_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Tusruktu tia ouinge ke nga kaskas nu sel Moses, mwet kulansap luk. Nga srisrngilya elan kol mwet Israel nukewa luk. ");
INSERT INTO kos_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ke ma inge pacl nga kaskas nu sel kut ngetani na sramsram lemtulauk, ac tia ke kas lukma. El liye tari lumuk! Na fuka tuh komtal ku in kaskas lainul Moses, mwet kulansap luk?” ");
INSERT INTO kos_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","LEUM GOD El kasrkusrakak seltal; ouinge ke El som lukeltal ");
INSERT INTO kos_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ac pukunyeng sac sowak liki Lohm Nuknuk Mutal, Miriam el musen lepayak, ac manol fasrfasrla oana snow. Na ke Aaron el ngetang liye lah Miriam el lepa lac, ");
INSERT INTO kos_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","el fahk nu sel Moses, “Leum luk, nunak munas, nimet kalyei kut ke ma koluk lalfon se lasr. ");
INSERT INTO kos_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Nikmet lela Miriam elan oana sie tulik su isusla misa, su tafu ikwal mongola.” ");
INSERT INTO kos_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ke ma inge Moses el wowoyak tung nu sin LEUM GOD ac fahk, “O God, akkeyala mutan se inge!” ");
INSERT INTO kos_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","LEUM GOD El topuk, “Papa tumal funu aniya mutal, na el lukun muta in mwekin lal len itkosr. Ke ma inge lela elan muta likin nien aktuktuk uh len itkosr, na toko ac ku in folokinyukme el.” ");
INSERT INTO kos_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriam el muta likin nien aktuktuk len itkosr, ac mwet uh tiana mukuiyak nwe ke na folokinyukme el. ");
INSERT INTO kos_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Toko elos fahsr liki acn Hazeroth, ac tulokunak nien aktuktuk selos in acn mwesis lun Paran. ");
INSERT INTO kos_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Sulela kais sie mwet kol ke sruf singoul luo ah, ac supwalosla in som kalngeyuk ke luman acn Canaan, su nga ac fah sang nu sin mwet Israel.” ");
INSERT INTO kos_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ke ma inge Moses el oru oana, ac supwala mwet kol liki acn mwesis lun Paran, fal nu ke sap lun LEUM GOD, oana ma takla ten inge: ");
INSERT INTO kos_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","16","Sruf Mwet Kol Reuben Shammua wen natul Zaccur Simeon Shaphat wen natul Hori Judah Caleb wen natul Jephunneh Issachar Igal wen natul Joseph Ephraim Hoshea wen natul Nun Benjamin Palti wen natul Raphu Zebulun Gaddiel wen natul Sodi Manasseh Gaddi wen natul Susi Dan Ammiel wen natul Gemalli Asher Sethur wen natul Michael Naphtali Nahbi wen natul Vophsi Gad Geuel wen natul Machi Pa inge mwet kalngeyuk su Moses el supwala in tuni ouiyen acn sac. El ekulla inel Hoshea wen natul Nun nu ke Joshua. ");
INSERT INTO kos_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Pacl se Moses el supwalos in som, el fahk nu selos, “Utyak ke inkanek nu epang, ac fahla nu layen eir lun acn Canaan, na fanyak nu in acn oasr eol we. ");
INSERT INTO kos_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Som ac liye lah acn we acn fuka se, ac liye lah pus ku pu mwet we. Liye pac lah mwet we elos mwet ku ku munas. ");
INSERT INTO kos_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Kowos in liye lah acn sac wo ku koluk, ac acn mwet uh muta we lah nien na aktuktuk, ku siti ma kuhlusyukyak ke pot ku. ");
INSERT INTO kos_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Liye pac lah fohkon acn we wo, ac pus sak we. Ac ke kowos foloko, kowos in esam in use kutu fokinsak we.” (Pacl se inge grape uh mutawauk in mwesrla.) ");
INSERT INTO kos_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ke ma inge mwet ah utyak nu epang ac tuni acn uh, mutawauk yen mwesis lun Zin, layen eir lac na nwe Rehab, su oan apkuran nu Innek In Utyak Nu Hamath, layen epang. ");
INSERT INTO kos_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Elos utyak meet nu layen eir ac tuku nu Hebron. (Siti se inge musaiyukyak yac itkosr meet liki Zoan in acn Egypt.) In acn Hebron elos liye sou lulap tolu lun Ahiman, Sheshai, ac Talmai, ma ke sou lun mwet na lulap pisa pangpang mwet Anak. ");
INSERT INTO kos_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Elos tuku nu Infahlfal Eshcol, ac pakela lah se su ungin grape na toasr se oan kac. Ke sripen arulana toasr, enenu mwet luo in polongya us ke soko srenenu. Elos oayapa us kutu pomegranate ac fig. ( ");
INSERT INTO kos_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Elos sang inen acn sac Infahlfal Eshcol ke sripen ungin grape se mwet Israel pakela we.) ");
INSERT INTO kos_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Tukun elos forfor ac oru kalngeyuk lalos in acn sac ke len angngaul, na elos folokla ");
INSERT INTO kos_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","nu yorol Moses, Aaron, ac sruf nukewa lun Israel in acn Kadesh ke yen mwesis lun Paran. Elos srumun ma elos liye ac sang nu sin mwet uh fokinsak ma elos us tuku. ");
INSERT INTO kos_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Elos fahk nu sel Moses, “Kut som tuni facl sac ac konauk lah acn na mut ac kasrup fohk we. Pa inge kutu fokinsak we. ");
INSERT INTO kos_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Tusruktu mwet ma muta we mwet na fokoko, ac siti selos uh arulana yohk ac potiyukyak ku. Sayen ma inge, kut tuh liye kutu koht we, ma ke fwilin tulik natul Anak. ");
INSERT INTO kos_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Mwet Amalek elos muta layen eir ke acn we. Mwet Hit, mwet Jebus, ac mwet Amor muta fineol uh, ac mwet Canaan muta sisken Meoa Mediterranean ac sisken Infacl Jordan.” ");
INSERT INTO kos_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Caleb el akmisyela mwet su lainul Moses, ac fahk, “Kut som ingena ac eisla acn we. Kut ku in kutangulosla.” ");
INSERT INTO kos_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","A mwet ma welul Caleb som elos fahk, “Mo, kut tia ku in lainulos, mweyen mwet we uh arulana ku liki kut.” ");
INSERT INTO kos_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ouinge elos srumunelik kas sutuu ke acn se elos kalngeyuk we inmasrlon mwet Israel. Elos fahk mu, “Fokin acn we tia fal in sang kite mwet we. Mwet nukewa kut liye we mwet na loeska, ");
INSERT INTO kos_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ac kut liye pac kutu mwet na lulap pisa we, pangpang Nephilim, su papa matu tumun mwet Anak. Ke kut liyalos kut oana koht srisrik sohksok uh nu selos.” ");
INSERT INTO kos_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Na mwet uh tung fong nufon sac ke sripen nikanla ac fosrnga lalos. ");
INSERT INTO kos_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Elos torkaskas lainul Moses ac Aaron, ac fahk, “Lukun wona kut funu misa na Egypt, ku finne inge yen mwesis uh! ");
INSERT INTO kos_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Efu ku LEUM GOD Elan uskutla nu in acn sac tuh kut in misa ke mweun, ac mutan kiasr ac tulik natusr uh ac muta in sruoh. Mea, ac tia wo kut in folokla nu Egypt?” ");
INSERT INTO kos_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ouinge elos fahk nu sin sie sin sie, “Wona kut in sulela sie mwet kol nu sesr sifacna, ac folokla nu Egypt!” ");
INSERT INTO kos_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Na Moses ac Aaron faksufi ye mutun mwet nukewa. ");
INSERT INTO kos_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ac Joshua wen natul Nun, ac Caleb wen natul Jephunneh, luo sin mwet kalngeyuk uh, eltal seya nuknuk laltal ke sripen asor laltal ");
INSERT INTO kos_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ac fahk nu sin mwet uh, “Facl se su kut kalngeyuk we ah, acn na wowo se. ");
INSERT INTO kos_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","LEUM GOD fin insewowo sesr, El ac uskutla nu we ac ase nu sesr facl na mut ac kasrup fohk we sac. ");
INSERT INTO kos_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Nik kowos lain LEUM GOD, ac nimet sangeng sin mwet we uh. Ac arulana fisrasr kut in kutangulosla. LEUM GOD El wi kut, ac El kutangla tari god su karinganulos. Ke sripa inge nik kowos sangeng.” ");
INSERT INTO kos_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Na u sac nufon nunku elos in tanglaltal nwe ke na eltal misa. Tusruktu in kitin pacl ah na mwet uh liye kalem wolana ma akkalemye sikme lun LEUM GOD oan fin Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","LEUM GOD El fahk nu sel Moses, “Mwet inge ac pilesreyu nwe ngac? Putaka elos ac srangesr lulalfongiyu, nga ne orala mwenmen puspis inmasrlolos? ");
INSERT INTO kos_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nga fah supwama sie mas upa in onelosla, tusruktu nga fah oru kom in papa tumun sie mutunfacl yohk ac ku lukelos!” ");
INSERT INTO kos_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Na Moses el fahk nu sin LEUM GOD, “Kom tuh use mwet inge liki acn Egypt ke ku lom. Pacl se mwet Egypt elos ac lohng ke ma kom oru nu sin mwet lom, ");
INSERT INTO kos_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","elos ac srumun nu sin mwet su muta in facl se inge. Mwet inge lohng tari lah kom, LEUM GOD, kom wi kut, ac kom sikyak ac liyeyuk kalem ke pacl se pukunyeng lom tuhwi facsr. Elos lohng pac lah kom fahsr meet liki kut in sie sru in pukunyeng ke len, ac ke sie sru in e ke fong. ");
INSERT INTO kos_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Inge kom fin onela mwet lom nukewa, na mutanfahl su lohng pweng keim, elos fah fahk lah ");
INSERT INTO kos_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","kom onela mwet lom in acn mwesis ke sripen kom tia ku in usalosla nu in facl se su kom wuleang mu kom ac sang nu selos. ");
INSERT INTO kos_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ouinge, LEUM GOD, nga pre ac siyuk tuh kom in akkalemye ku lom nu sesr, ac oru ma kom wulela kac ke kom fahk mu, ");
INSERT INTO kos_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Nga LEUM GOD, nga tia sa in mulat, ac nga fahkak lungkulang, oaru, ac nunak munas ke ma koluk ac ma sutuu lun mwet uh. Tusruk nga fah tia mulkunla in kai papa ac nina su oru ma koluk, oayapa tulik natulos ac nutin natulos nu ke fwil aktolu ac akakosr.’ ");
INSERT INTO kos_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Inge, LEUM GOD, fal nu ke lungse lulap lom su tiana ekyek, nga kwafe sum, sisla koluk lun mwet inge, oana ke kom nuna nunak munas nu selos oe ke pacl se elos illa liki acn Egypt me!” ");
INSERT INTO kos_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","LEUM GOD El topuk, “Nga fah nunak munas nu selos, oana ke kom siyuk. ");
INSERT INTO kos_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Tusruktu, in oana ke nga moul, ac ku luk ac wolana luk oasr yen nukewa faclu nufon, ");
INSERT INTO kos_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","nga wulela mu wangin sie sin mwet inge ac fah moul in wi utyak nu in facl sac. Elos liye tari kalem wolana luk ac mwenmen ma nga tuh oru in facl Egypt ac yen mwesis. Ne ouinge, elos nuna srikeyu na, ac pusla pacl elos tia akosyu. ");
INSERT INTO kos_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Elos ac fah tiana utyak nu in facl se su nga wulela nu sin mwet matu lalos. Wangin sie selos su pilesreyu fah liye acn we. ");
INSERT INTO kos_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Tusruktu ke sripen nunak lal Caleb, mwet kulansap luk, sie liki na mwet ngia, ac el srakna oru ma lungse luk ke inse pwaye, nga fah usalla nu in facl sac su el tuh wi kalngeyuk we, ac fwilin tulik natul fah eis lalos acn we. ");
INSERT INTO kos_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","In pacl inge mwet Amalek ac mwet Canaan elos muta infahlfal lun acn we, ouinge kowos in forla ac som nu yen mwesis ke inkanek nu Meoa Srusra.” ");
INSERT INTO kos_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","LEUM GOD El fahk nu sel Moses ac Aaron, ");
INSERT INTO kos_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Mwet koluk inge ac torkaskas lainyu nwe ngac? Fal tari lohngyen torkaskas inge sik. ");
INSERT INTO kos_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Sang top luk inge nu selos: “Nga fulahk lah in oana ke nga moul, nga fah oru nu suwos oana ke kowos siyuk. Nga LEUM GOD pa kaskas. ");
INSERT INTO kos_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Kowos fah misa, ac mano misa lowos ac fah afunla yen mwesis uh. Mweyen kowos torkaskas na lainyu, tia sie suwos su yac longoul matwayak fah wi utyak nu in facl sac. ");
INSERT INTO kos_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Nga tuh wulela mu nga ac oru tuh kowos in muta we, tuh pa tia sie suwos ac sun, sayal Caleb ac Joshua. ");
INSERT INTO kos_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Kowos tuh fahk mu tulik nutuwos ac mau mwet sruoh, tusruktu nga ac usalosme nu in facl se su kowos sifacna liskowosla liki, ac facl sac fah ma selos. ");
INSERT INTO kos_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","A funu kowos, kowos fah misa yen mwesis se inge. ");
INSERT INTO kos_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Tulik nutuwos ac fah forfor yen mwesis yac angngaul, ac keok ke sripen ma koluk lowos, nwe ke mwet safla se ke fwil se inge misa. ");
INSERT INTO kos_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Mwatan ma koluk lowos uh ac oru kowos in keok ke yac angngaul — yac se nu ke kais sie len kowos tuh oru kalngeyuk lowos in acn sac. Kowos ac fah arulana pulakunak luman lain luk nu suwos. ");
INSERT INTO kos_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Nga fulahk lah nga ac oru ouinge nu sin mwet koluk nukewa su tukeni nu sie lainyu. Kais sie suwos fah misa yen mwesis se inge. Nga LEUM GOD pa kaskas!” ");
INSERT INTO kos_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Mwet su Moses el tuh supwala in oru kalngeyuk lalos ke facl sac, ke elos foloko elos tuh fahkak kas tia pwaye ke acn sac, pa pwanang mwet Israel nukewa torkaskas lain LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Ke sripa se inge, LEUM GOD El sang sie mas upa ac onela mwet kalngeyuk inge. ");
INSERT INTO kos_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Joshua ac Caleb mukena moul inmasrlon mwet kalngeyuk singoul luo ah. ");
INSERT INTO kos_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ke Moses el fahkang nu sin mwet Israel ma LEUM GOD El fahk nu sel uh, elos tung ac arulana asor. ");
INSERT INTO kos_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Toangna in lotu tok ah elos mukuiyak in utyak ac eisla acn nu fineol uh. Elos fahk, “Inge kut akola in utyak nu fin acn se su LEUM GOD El kaskas nu sesr kac. Pwaye lah kut tuh oru ma koluk.” ");
INSERT INTO kos_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Tusruktu Moses el fahk, “Na efu kowos ku srakna fahsr sayen ma sap lun LEUM GOD? Ma kowos oru inge ac tia ku in wo ouiya! ");
INSERT INTO kos_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Nik kowos som. LEUM GOD El tia wi kowos, ac mwet lokoalok lowos ac fah kutangkowosla. ");
INSERT INTO kos_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ke kowos ac tuyang in lain mwet Amalek ac mwet Canaan uh, kowos ac misa ke mweun. LEUM GOD El ac tia wi kowos, ke sripen kowos tia lungse fahsr tokol.” ");
INSERT INTO kos_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ne ouinge elos kwafeang na in utyak nu fineol uh, finne Tuptup in Wuleang lun LEUM GOD ac Moses srakna muta in nien aktuktuk uh. ");
INSERT INTO kos_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Na mwet Amalek ac mwet Canaan su muta fineol uh elos sroang mweunelos ac kutangulosla, ac ukwalos na nwe ke sun acn Hormah. ");
INSERT INTO kos_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","LEUM GOD El sang nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","oakwuk inge tuh elan fahkang nu sin mwet Israel in oru fin facl se su El ac sang in ma lalos. ");
INSERT INTO kos_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Soko cow mukul, ku soko sheep mukul, ku soko sheep, ku nani, ac ku in kisakinyuk nu sin LEUM GOD oana sie mwe kisa firir, ku oana sie kisa in akpwaye wuleang, ku sie mwe sang ke engan na lun mwet se in oru, ku sie mwe sang ke pacl in kufwa uh. Foulin mwe kisa inge mwe akinsewowoye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Na kutena mwet su use soko sheep ku soko nani in sie mwe kisa firir nu sin LEUM GOD, fah oayapa use sie mwe kisa wheat, ma orek ke luo paun in flao wowo karyak ke akosr cup ke oil in olive, ");
INSERT INTO kos_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","oayapa, akosr cup in wain tuh in okwokyang nu fin loang uh. ");
INSERT INTO kos_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Pacl se ke soko sheep mukul kisaiyukla, paun akosr ke flao karyak ke cup onkosr ke oil in olive in tufah itukyang oana sie kisa wheat, ");
INSERT INTO kos_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","weang cup onkosr ke wain ma ac okwokyang nu fin loang uh. Foulin mwe kisa inge mwe akinsewowoye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Pacl se ke soko cow mukul kisakinyukyang nu sin LEUM GOD tuh in sie mwe kisa firir, ku in sie kisa in akpwayei wuleang, ku in sie kisa in akinsewowo, ");
INSERT INTO kos_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","sie mwe kisa wheat ke paun onkosr ke flao karyak ke cup oalkosr ke oil in olive in tufah itukyang pac in wi, ");
INSERT INTO kos_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","weang cup in wain oalkosr. Foulin mwe kisa se inge mwe akinsewowoye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Pa ingan ma eneneyuk in itukyang wi kais soko cow mukul, sheep mukul, sheep, ku nani. ");
INSERT INTO kos_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ke pacl se ma ac kisakinyuk kosro pus liki ma soko, na ma oakwuki nu kac enenu in lalela fal nu ke pisa ma kisakinyuk. ");
INSERT INTO kos_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Mwet nukewa su isusla mwet Israel fah oru ouinge ke elos ac kisakin ma inge ke e, su fohlo mwe akinsewowoye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Fin oasr mwetsac su muta inmasrlowos, finne ke kitin pacl na ku muta oakwuk, el fin lungse oru sie mwe kisa ke mwe mongo, su fohlo mwe akinsewowoye LEUM GOD, el fah oru oapana ke kowos oru uh. ");
INSERT INTO kos_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Kowos, ac mwetsac su muta inmasrlowos, enenu in orekmakin oakwuk inge ke pacl nukewa fahsru uh. Kowos ac elos oana sie ye mutun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ma sap ac oakwuk nukewa nu suwos ac ma pac nu selos. ");
INSERT INTO kos_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","LEUM GOD El sang nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","oakwuk inge tuh elan fahkang nu sin mwet Israel in oru fin facl se su El ac sang in ma lalos. ");
INSERT INTO kos_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Kutena pacl kowos kang fokin acn uh, srela kutu nu saya tuh in mwe sang nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Pacl kowos manman flao, lof soko oemeet ke bread orek ke wheat sasu in tufah itukyang oana sie mwe sang sriyukla nu sin LEUM GOD. Ma se inge ac tufah orek oana mwe sang sriyukla su kowos oru ke wheat ma aknasnasyeyukla ke nien kulkul wheat. ");
INSERT INTO kos_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ingela nwe tok, mwe sang sriyukla inge in itukyang na nu sin LEUM GOD liki bread kowos munan uh. ");
INSERT INTO kos_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Ac fuka, sie mwet fin kunausla kutu sin ma oakwuk inge su LEUM GOD El sang nu sel Moses, ke tia ma el nunkala elan oru? ");
INSERT INTO kos_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Ku ac fuka fin mau tok, mwet Israel nukewa elos tia akfalye ma nukewa ma LEUM GOD El sapkin nu sel Moses? ");
INSERT INTO kos_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Tafongla ouinge fin orek ke sripen elos nukewa tia kalem kac, na elos fah kisakin soko cow mukul in sie mwe kisa firir, ma fohlo mwe akinsewowoye LEUM GOD, wi mwe kisa wheat ac mwe kisa wain fal nu kac. Sayen ma inge, elos in kisakin pac soko nani mukul tuh in sie mwe kisa ke ma koluk. ");
INSERT INTO kos_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Mwet tol el fah oru alu in aknasnas nu sin mwet Israel nukewa, ac elos fah eis nunak munas, mweyen tafongla lalos uh tia ma srunenyak elos in oru, oayapa mweyen elos use mwe kisa ke ma koluk lalos oana mwe kisa mongo nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Mwet Israel nukewa, oayapa mwetsac su muta inmasrlolos, ac fah eis nunak munas mweyen mwet nukewa oru tafongla sac ke tia etu. ");
INSERT INTO kos_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Sie mwet fin orala sie ma koluk ke el tia nunku in oru, el fah sang soko nani mutan yac sie matwa tuh in sie mwe kisa ke ma koluk. ");
INSERT INTO kos_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Mwet tol el fah oru alu in aknasnas ke loang uh in eela ma koluk lun mwet se inge, na ac fah nunak munas nu sel. ");
INSERT INTO kos_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Oakwuk sefanna in orekmakinyuk nu sin kutena mwet su orala ma koluk ke tia nunku in oru, el fin sie mwet isusla mwet Israel, ku sie mwetsac su muta inmasrlowos. ");
INSERT INTO kos_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Tusruktu kutena mwet su akoo in oru ma koluk ac orala, el finne mwet isusla mwet Israel ku sie mwetsac, oasr mwatal ke sripen el aklusrongtenye LEUM GOD, na ac fah anwuki el ");
INSERT INTO kos_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","mweyen el pilesru kas lun LEUM GOD, ac el kunausla sie sin ma sap lun God ke etu lal. Sripen misa lal, ma el sifacna oru. ");
INSERT INTO kos_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Sie pacl ah, ke mwet Israel srakna muta yen mwesis, koneyukyak mwet se lah el ti etong ke len Sabbath. ");
INSERT INTO kos_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Na utukla el nu yorol Moses ac Aaron, ac nu yurin mwet Israel nukewa, ");
INSERT INTO kos_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ac elos sang sie mwet in liyalang, mweyen tia kalem lah mea fal in orek nu sel. ");
INSERT INTO kos_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Na LEUM GOD El fahk nu sel Moses, “Enenu mwet se inge in anwuki. Mwet Israel nukewa in tanglal likin nien aktuktuk uh nwe ke el misa.” ");
INSERT INTO kos_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ke ma inge mwet Israel nukewa usalla nu likin nien aktuktuk uh, ac tanglal nwe ke na el misa, oana ke LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","in fahk nu sin mwet Israel: “Orala mwe yun ke turet in oan atla ke pulun nuknuk lowos uh, ac sang soko ah folfol an kapriya kais sie mwe yun inge. Kowos fah oru ouinge ke pacl nukewa fahsru. ");
INSERT INTO kos_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mwe yun inge ac fah mwe akesmakinye kowos, tuh kais sie pacl kowos liye uh kowos fah esamak ma sap luk nukewa ac akos; na kowos fah tia forla likiyu ac fahsr tukun lungse ac kena lowos sifacna. ");
INSERT INTO kos_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Mwe yun inge ac fah akesmakinye kowos in liyaung ma sap luk nukewa, ac kowos fah kisakinyukla tuh kowos in mwet luk na pwaye. ");
INSERT INTO kos_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Nga LEUM GOD lowos. Nga pa uskowosme liki acn Egypt tuh nga in God lowos. Nga LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Inge Korah wen natul Izhar ke sou lulap lal Kohath in sruf lal Levi, welul Dathan ac Abiram (wen luo natul Eliab) oayapa On (wen natul Peleth) su mwet ke sruf lal Reuben, elos eis ");
INSERT INTO kos_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","luofoko lumngaul mukul, mwet na eteyuk su solla in mwet kol lun mwet Israel, na elos tuyang nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Elos toeni ye mutal Moses ac Aaron ac fahk nu seltal, “Komtal arulana alukela! Mwet Israel nukewa ma lun LEUM GOD, ac El wi kut nukewa. Na efu komtal ku sifacna oru komtal in fulat liki un mwet lun LEUM GOD?” ");
INSERT INTO kos_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ke Moses el lohng kas inge, el putati nu infohk uh ac pre. ");
INSERT INTO kos_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Na el fahk nu sel Korah ac mwet welul uh, “Lututang LEUM GOD El ac fah akkalemye nu sesr lah su kac mwet lal uh. Mwet se ma mutal su El sulela, pa God El ac fah lela in kalukyang nu yorol nu ke loang uh. ");
INSERT INTO kos_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Korah ac mwet nukewa in u lom uh, pa inge ma kowos in oru: us pan in neinyuk mulut firir, ");
INSERT INTO kos_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ac lutu, filiya e nu loac ac likiya mwe keng nu fac ye mutun LEUM GOD. Na kut ac fah liye lah su kac sesr pa suleyukla sin LEUM GOD. Kowos mwet Levi pa arulana alukela!” ");
INSERT INTO kos_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Na Moses el sifil kaskas nu sel Korah. “Kowos mwet Levi, porongeyu! ");
INSERT INTO kos_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ya kowos nunku mu ma pilasr se suwos tuh LEUM GOD El srikowosla liki mwet Israel nukewa tuh kowos in ku in kalukyang nu yorol in oru ma kunowos in Lohm Nuknuk Mutal sel, ac tuyak ye mutun mwet Israel wiowos in kulansupwalos? ");
INSERT INTO kos_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","El oru tuh kom ac mwet Levi nukewa saya in oru kunokon fulat se inge, a inge kowos srike in eis pac wal lun mwet tol! ");
INSERT INTO kos_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ke kowos torkaskas lainul Aaron, pwayena lah kom ac mwet wi kom uh tunyuna lain LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Na Moses el sapla solal Dathan ac Abiram, a eltal fahk mu, “Kut ac tia fahsrot! ");
INSERT INTO kos_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Mea, tia fal ke kom uskutme liki facl na mut ac kasrup fohk we Egypt, in tuh unikuti inge yen mwesis? Ya kom ac orekma in funmweti kut pac? ");
INSERT INTO kos_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Kalem na lah tiana facl wowo se pa kom uskutme nu we inge, ac wangin pac acn in ima, ku ima in grape, kom se lasr, a inge kom srike in kiapwekut pac. Kut ac tiana fahsrot!” ");
INSERT INTO kos_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moses el kasrkusrakak ac fahk nu sin LEUM GOD, “Nimet kom eis kutena mwe kisa ma mwet inge ac fah use. Wanginna ma nga oru koluk nu selos — finne donkey soko natulos, nga tiana eis.” ");
INSERT INTO kos_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moses el fahk nu sel Korah, “Lutu kom, ac mwet luofoko lumngaul ma wi kom an, in tuku nu ke Lohm Nuknuk Mutal sin LEUM GOD. Aaron el ac wi pac muta we. ");
INSERT INTO kos_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Kais sie suwos fah us pan in neinyuk mulut firir lal, filiya mwe keng fac, na kisakin nu sin LEUM GOD ke loang uh.” ");
INSERT INTO kos_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ouinge mwet nukewa elos us pan in neinyuk mulut lalos, sang mulut firir nu loac ac mwe keng nu fac, ac welul Moses ac Aaron tu ke nien utyak nu ke Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Na Korah el pangoneni mwet Israel nukewa, ac elos tu ngetang nu sel Moses ac Aaron ke nien utyak nu ke Lohm Nuknuk Mutal. In kitin pacl ah, kalem wolana lun LEUM GOD sikyak nu sin mwet nukewa. ");
INSERT INTO kos_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ac LEUM GOD El fahk nu sel Moses ac Aaron, ");
INSERT INTO kos_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Kiluki liki mwet inge, ac nga fah kunauselosla ingena.” ");
INSERT INTO kos_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Tusruktu Moses ac Aaron faksufi ac fahk, “O God, moul lun ma nukewa tuku sum me. Mwet sefanna fin oru ma koluk, ya kom ac kasrkusrak sin mwet nukewa in acn sac?” ");
INSERT INTO kos_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Fahkang nu sin mwet ingan in kalukla liki lohm nuknuk sel Korah, Dathan, ac Abiram.” ");
INSERT INTO kos_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Na Moses, ac mwet kol lun Israel elos tukeni som nu yorol Dathan ac Abiram. ");
INSERT INTO kos_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","El fahk nu sin mwet uh, “Kalukot liki lohm nuknuk sin mwet koluk inge, ac nikmet kahlye kutena ma lalos. Kowos fin tia lohng, kowos ac welulos na sikiyukla ke ma koluk nukewa lalos.” ");
INSERT INTO kos_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ouinge elos kalukla liki lohm nuknuk sel Korah, Dathan, ac Abiram. Dathan ac Abiram ilme ac tu ke mutunoa in lohm nuknuk selos, wi mutan kialos ac tulik natulos. ");
INSERT INTO kos_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moses el fahk nu sin mwet uh, “Pa inge ma ac akkalemye nu suwos lah LEUM GOD pa supweyume in oru ma inge nukewa, ac nga tia oru ke lungse luk sifacna. ");
INSERT INTO kos_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Mwet inge fin misa ke pacl fal la ac tia ke sripen kalyei sin God me, na kalem lah tia LEUM GOD pa supweyume uh. ");
INSERT INTO kos_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Tusruktu LEUM GOD El fin orala sie ouiya na sasu, ac infohk uh mangelik ac okomulosla wi ma lalos nukewa, ac elos moul na tili nu in facl lun mwet misa, na kowos fah etu lah mwet inge pilesru LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","El tufahna fahkla ma inge, na infohk uh srasrelik yal Dathan ac Abiram ");
INSERT INTO kos_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ac okomulosla wi sou lalos, oayapa mwet nukewa ma welul Korah wi ma lalos nukewa. ");
INSERT INTO kos_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ouinge elos moul na tilla nu in facl lun mwet misa, wi ma lalos nukewa. Na infohk uh folokeni nu faclos, ac elos wanginla. ");
INSERT INTO kos_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Mwet Israel nukewa ma oasr we elos kaing ke elos lohng pusren tung lalos. Elos wowoyak ac fahk, “Kaing! Faclu ac ukumkuti pac!” ");
INSERT INTO kos_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Na LEUM GOD El supweya e se ac esukla mwet luofoko lumngaul su kisakin mwe keng uh. ");
INSERT INTO kos_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Na LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Fahk nu sel Eleazar wen natul Aaron mwet tol, elan eisla pan in neinyuk mulut, ma orekla ke bronze, liki mwet firiryak misa uh, ac sisalik mulut liki pan uh nu ke sie pacna acn, mweyen pan inge mutal. ");
INSERT INTO kos_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Pan uh tuh akmutalyeyukla ke pacl se utuku nu ke loang lun LEUM GOD. Ke ma inge eis pan lun mwet inge su anwuki ke sripen koluk lalos, ac tuktukya in mininila, ac orala sie mwe afyuf nu ke loang uh kac. Ma inge ac fah mwe akul nu sin mwet Israel.” ");
INSERT INTO kos_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ouinge Eleazar mwet tol el orani pan uh ac sap tuktuki nwe ke mininila in orala sie mwe afyuf nu ke loang uh. ");
INSERT INTO kos_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Ma se inge mwe sensenkakin mwet Israel lah wangin kutena mwet sayen mwet ke fwilin tulik natul Aaron fah kalukyang nu ke loang uh in akosak mwe keng nu sin LEUM GOD. Mwet se fin tia akos, na ac anwuki el oana Korah ac mwet lal. Ma inge nukewa orekla oana LEUM GOD El sapkin nu sel Eleazar sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Len tok ah mwet Israel nukewa torkaskas lainul Moses ac Aaron ac fahk, “Komtal uniya kutu sin mwet lun LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Tukun mwet uh tukeni in lainul Moses ac Aaron, eltal ngetla nu ke Lohm Nuknuk Mutal ac liye lah pukunyeng sac afunla Lohm Nuknuk Mutal, ac kalem wolana lun LEUM GOD sikyak pac we. ");
INSERT INTO kos_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moses ac Aaron som ac tu mutun Lohm Nuknuk Mutal, ");
INSERT INTO kos_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ac LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Kaluki liki mwet inge, ac nga fah kunauselosla in acn se na elos tu we an!” Eltal tukeni faksufi, ");
INSERT INTO kos_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","na Moses el fahk nu sel Aaron, “Us pan in neinyuk e lom an, sang kutu mulut firir liki loang uh nu loac, ac sang kutu mwe keng nu fin mulut uh, na sulaklak usla nu yurin mwet uh ac oru alu in aknasnas kaclos. Aksaye! Kasrkusrak lun LEUM GOD tayak tari, ac sie mas na upa mutawauk pac tari.” ");
INSERT INTO kos_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaron el akos. El eis pan in e lal ac kasrla nu inmasrlon mwet uh. Ke el liye lah mas keok sac mutawauk tari, el sang mwe keng nu fin mulut uh ac oru alu in aknasnas ke mwet uh. ");
INSERT INTO kos_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ma inge tulokinya mas keok sac, ac el mukena tu inmasrlon mwet moul ac mwet misa. ");
INSERT INTO kos_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Pisen mwet ma misa uh oasr ke mwet singoul akosr tausin itfoko, tia oaoa elos su misa ke pacl in tunyuna lal Korah. ");
INSERT INTO kos_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ke pacl se mas keok sac tui, Aaron el folokla nu yorol Moses nu ke mutunoa lun Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Fahk nu sin mwet Israel elos in sot nu sum singoul lukwa sikal, kais soko sin mwet kol lun kais sie sruf. Simusla inen kais sie mwet ke sikal lal, ");
INSERT INTO kos_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","na simusla inel Aaron ke sikal soko lun sruf Levi. Ac fah oasr sikal soko sin kais sie mwet kol lun sruf. ");
INSERT INTO kos_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Usla sikal inge nu in Lohm Nuknuk Mutal sik, ac filiya mutun Tuptup in Wuleang, yen nga osun nu sum we. ");
INSERT INTO kos_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Na sikal soko lun mwet se su nga sulela uh fah srunak. In ouiya se inge nga fah tulokinya torkaskas lun mwet Israel ma elos oru na lain kom.” ");
INSERT INTO kos_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ke ma inge Moses el kaskas nu sin mwet Israel, ac kais sie mwet kol lalos sang sikal soko nu sel — sikal soko ke kais sie sruf, ma singoul lukwa nufon — ac sikal lal Aaron oan pac kac. ");
INSERT INTO kos_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Na Moses el filiya sikal nukewa in Lohm Nuknuk Mutal ye mutun Tuptup in Wuleang lun LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Len tok ah, ke Moses el utyak nu in Lohm Nuknuk Mutal el liyauk lah sikal lal Aaron, ma aolyen sruf lun Levi, srunak tari. Oasr ros motul, ros fareng ac fokla almond mwesr! ");
INSERT INTO kos_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moses el srukak sikal nukewa ac sang nu sin mwet Israel. Elos liye ma sikyak, ac kais sie mwet kol srukak sikal lal sifacna. ");
INSERT INTO kos_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","LEUM GOD El fahk nu sel Moses, “Folokonla sikal lal Aaron nu ye mutun Tuptup in Wuleang. In karinginyukyang tuh in mwe sensenkakin mwet Israel nukewa su tunyuna, lah elos ac misa elos fin tia tui ke torkaskas lalos.” ");
INSERT INTO kos_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moses el oru oana LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Mwet Israel elos fahk nu sel Moses, “Kut tuhlac na pwaye. Kut nukewa ac wanginla! ");
INSERT INTO kos_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Mwet se fin kalukyang nu ke Lohm Nuknuk Mutal na el ac misa — kalem lah kut nukewa ac misa!” ");
INSERT INTO kos_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","LEUM GOD El fahk nu sel Aaron, “Kom, ac wen nutum ac mwet Levi, fah kaiyuk ke kutena tafongla ma sikyak ke pacl kowos orekma in Lohm Nuknuk Mutal sik; tusruktu kom ac wen nutum mukena pa ac kaiyuk ke kutena tafongla ma orek ke kunokon lun mwet tol. ");
INSERT INTO kos_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Use mwet in sou lom ke sruf lun Levi in wi kom orekma ac kasrekom pacl kom, ac wen nutum, orekma in Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Elos enenu in akfalye ma kunalos nu sum ac oayapa fosrngakin orekma kunalos ke Lohm Nuknuk Mutal uh, tusruktu elos in tia kahl kutena ma akmutalyeyukla in Acn Mutal ku ke loang uh. Elos fin kahlya, komtal kewa fah anwuki. ");
INSERT INTO kos_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Elos in wi kom orekma ac akfalye ma kunalos nukewa in Lohm Nuknuk Mutal, tusruktu wangin mwet su tia fal in wi orekma ke ma inge fah wi kom orekma. ");
INSERT INTO kos_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Kom ac wen nutum mukena fah akfalye orekma ke Acn Mutal ac ke loang uh, tuh kasrkusrak luk fah tia sifilpa tayak lain mwet Israel. ");
INSERT INTO kos_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Nga pa sulela mwet Levi wiowos liki inmasrlon mwet Israel tuh in oana sie mwe kite nu sum. Akmutalyeyukla elos nu sik, tuh elos in ku in oru orekma kunalos in Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Tusruktu kom ac wen nutum mukena fah akfalye kunokon nukewa lun mwet tol su ma nu ke loang uh ac nu ke ma su oan in Acn Mutal Na Mutal. Ma inge ma kunowos, mweyen nga sot nu suwos wal lun mwet tol oana sie mwe kite. Kutena mwet su tia fal in wi orekma ke ma inge su kalukyang apkuran nu ke ma mutal uh ac fah anwuki.” ");
INSERT INTO kos_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","LEUM GOD El fahk nu sel Aaron, “Esam lah nga sot nu sum mwe sang mutal nukewa ma ituku nu sik ac tia isisyak. Nga sot ma inge nu sum ac nu sin fwilin tulik nutum tuh in ip lowos nwe tok. ");
INSERT INTO kos_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Pa inge ip lom ke mwe sang su arulana mutal su tia firriyuk fin loang uh: mwe kisa wheat, mwe kisa ke ma koluk, ac mwe kisa in akfalye ma koluk lukma. Ma nukewa ma ituku nu sik tuh in sie kisa mutal, ma lom ac lun wen nutum. ");
INSERT INTO kos_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Kowos fah kang ma inge in sie acn mutal, ac mukul mukena fah ku in mongo kac. Kowos in eis mu ma inge ma na mutal. ");
INSERT INTO kos_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Sayen ma inge, kutena mwe sang mutal su mwet Israel elos use nu sik ac fah ma lom. Nga sot ma inge nu sum, ac nu sin wen ac acn nutum tuh in ma lowos nwe tok. Mwet nukewa in sou lom su aknasnasyeyukla, elos ku in mongo kac. ");
INSERT INTO kos_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Nga sot nu sum ma su wo emeet ke fahko se meet ma mwet Israel elos use nu sik ke kais sie yac: oil in olive, wain, ac wheat. ");
INSERT INTO kos_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Ma inge nukewa ma lom. Mwet nukewa in sou lom su aknasnasyeyukla ku in mongo kac. ");
INSERT INTO kos_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Ma nukewa in Israel ma kisakinyukme na pwaye nu sik ma lom. ");
INSERT INTO kos_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Wounse ke tulik ac kosro nukewa ma mwet Israel ase nu sik, ma nutum. Tusruktu kom fah eis molin sifil molela ke tulik wounse nukewa, ac oayapa eis molin sifil molela ke wounse ke kosro nukewa ma tia nasnas. ");
INSERT INTO kos_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Tulik uh enenu in sifil moliyukla ke elos sun malem sie matwa, ke lupan moul se ma oasr ke ipin silver limekosr, fal nu ke lupa oakwuki tari. ");
INSERT INTO kos_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Tusruktu wounsien cow, sheep, ac nani uh ac fah tia sifil moliyukla; ma inge ma na luk, ma in kisakinyuk. Fwela loang uh ke srahn ma inge ac esukak kiris kac tuh in sie mwe kisa mongo, sie foul su akinsewowoyeyu. ");
INSERT INTO kos_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ikwa ke ma inge ma nom, oapana iwa ac nia layen layot ke mwe kisa sriyukla. ");
INSERT INTO kos_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Mwe sang mutal nukewa su mwet Israel use nu sik, nga sot nu sum ac nu sin wen ac acn nutum ke pacl nukewa fahsru uh. Sie wuleang na kawil pa nga orala inge nu sum ac nu sin fwilin tulik nutum.” ");
INSERT INTO kos_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","LEUM GOD El fahk nu sel Aaron, “Ac fah wangin acn kom fah usrui, oayapa ac fah wangin ip ke acn lun Israel fah itukot lom. Nga, LEUM GOD, ac fah mwe usru lom ac ip lom.” ");
INSERT INTO kos_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","LEUM GOD El fahk, “Nga sang nu sin mwet Levi sie tafu singoul nukewa ma mwet Israel use nu sik. Ma inge ma in moli orekma lalos ke elos karinganang Lohm Nuknuk Mutal sik. ");
INSERT INTO kos_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Mwet Israel saya fah tia sifilpa kalukyang nu ke Lohm Nuknuk Mutal, mweyen elos fin oru, ma inge ac sang mwatalos in misa. ");
INSERT INTO kos_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Inge fahla, mwet Levi mukena ac fah karingin Lohm Nuknuk Mutal ac oru kunokon nukewa nu kac. Sie oakwuk kawil pa inge, su ac ma pac nu sin fwilin tulik nutuwos. Ac fah wangin acn itukyang nu sin mwet Levi in Israel, ");
INSERT INTO kos_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","mweyen nga sang nu selos sie tafu ngoul ke mwe sang sriyukla ma mwet Israel elos use nu sik. Ma inge nga sang tuh in ma lun mwet Levi. Pa ingan sripa se oru nga fahk nu sin mwet Levi mu ac fah wangin acn itukyang nu selos in Israel.” ");
INSERT INTO kos_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","LEUM GOD El sapkin nu sel Moses ");
INSERT INTO kos_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","in fahk nu sin mwet Levi: “Ke kowos eis sin mwet Israel tafu ngoul lalos ma LEUM GOD El asot nu suwos tuh in ma lowos, kowos fah sang sie tafu singoul kac tuh in sie mwe sang sriyukla nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Mwe sang sriyukla se inge ac fah oaoala mu oana mwe kisa ma mwet ima uh oru ke wheat sasu ac wain sasu. ");
INSERT INTO kos_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","In ouiya se inge kowos wi pac sang mwe sang sriyukla se lun LEUM GOD inge liki sie tafu singoul nukewa su kowos eis sin mwet Israel. Kowos fah sang mwe sang sriyukla inge lun LEUM GOD nu sel Aaron mwet tol. ");
INSERT INTO kos_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Sang ma wo oemeet ke ma kowos eis uh. ");
INSERT INTO kos_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Tukun kowos use ip ma wo oemeet kac, kowos ku in orekmakin ma lula an, oana ke mwet ima uh ac sruokya ma lula tukun el oru mwe sang lal uh. ");
INSERT INTO kos_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Oana sie acn ma kowos, ac sou lowos uh, ku in kang ma lula inge we, mweyen ma inge molin orekma lowos ke kulansap lowos in Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Kowos fin akfalye in sang ma wo emeet kac uh nu sin LEUM GOD, na ac fah wangin mwatuwos kowos fin kang ma lula an. Tusruktu taranna kowos in tia akkupatolye mwe sang mutal lun mwet Israel ke kowos kang kutena sin mwe sang inge meet liki itukyang ip wowo kac uh. Kowos fin oru, kowos ac fah anwuki.” ");
INSERT INTO kos_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","LEUM GOD El sapkin nu sel Moses ac Aaron ");
INSERT INTO kos_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","in fahkak oakwuk se inge nu sin mwet Israel: Use soko cow mutan srusra fohkfok ma wangin ma musalla ke manol ac soenna orekmakinyuk. ");
INSERT INTO kos_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Na komtal in sang nu sel Eleazar mwet tol, tuh in utukla nu likin nien aktuktuk ac anwuki ye mutal. ");
INSERT INTO kos_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Na Eleazar elan isongya kufinpaol nu ke srah uh, ac osrokla pacl itkosr layen nu ke Lohm Nuknuk Mutal. ");
INSERT INTO kos_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Kolo, ikwa, srah, ac koanfohko ke cow soko ah in firriyukyak nufon ye mutun mwet tol. ");
INSERT INTO kos_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Toko mwet tol el fah eis kutu ipin sak cedar, sie lahn hyssop, ac soko fu srusra, ac sisang nu in e sac. ");
INSERT INTO kos_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Tukun ma ingan, elan ohlla nuknuk lal ac ukuiya kof nu facl, na el fah ku in utyak nu in nien aktuktuk; tusruktu el srakna lumweyuk mu el tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Mwet se ma esukak cow soko ah enenu pac in ohlla nuknuk lal ac ukuiya kof nu facl sifacna, tusruktu el oayapa lumweyuk mu el tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Na sie mwet su lumweyuk el nasnas elan orani apat ke cow uh ac likiya in sie acn aknasnasyeyukla likin nien aktuktuk. Apat inge in karinginyuk nu sin sruf nukewa lun Israel tuh elos in orekmakin nu ke akoeyen kof nu ke aknasnas. Ouiya se inge orek in eela ma koluk. ");
INSERT INTO kos_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Mwet se ma orani apat uh enenu in ohlla nuknuk lal, tusruktu el srakna lumweyuk mu el tia nasnas nwe ke ekela. Oakwuk se inge ma na nwe tok, nu sin mwet Israel ac oayapa nu sin mwetsac su muta inmasrlolos. ");
INSERT INTO kos_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Kutena mwet su pusralla monin sie mwet misa, el tia nasnas ke lusen len itkosr. ");
INSERT INTO kos_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","El enenu in sifacna aknasnasyal ke kof in aknasnas ke len se aktolu ac len se akitkosr, na el fah nasnasla. Tusruktu el fin tia aknasnasyal sifacna ke len se aktolu oayapa len se akitkosr, el ac tia nasnas. ");
INSERT INTO kos_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Kutena mwet su pusralla monin sie mwet misa ac tia sifacna aknasnasyalla, fah lumweyuk el srakna tia nasnas, mweyen kof in aknasnas sac tiana ukuiyuki nu facl. El akfohkfokyela Lohm Nuknuk sin LEUM GOD, ac el ac fah tia sifilpa oaoa mu el sie mwet lun God. ");
INSERT INTO kos_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Fin oasr sie mwet misa in sie lohm nuknuk, na kutena mwet su oasr we in pacl sac, oayapa kutena mwet su fah utyak pac nu we fah lumweyuk elos tia nasnas ke len itkosr. ");
INSERT INTO kos_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Sufa nukewa ku tup nukewa in lohm nuknuk sac ma wangin mwe afyuf kac fah tia pac nasnas. ");
INSERT INTO kos_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Mwet se fin muta likinum uh, ac pusralla sie mwet su anwuki, ku sie mwet su misa ke pacl in na misa lal, ku el fin kahlye soko srin mwet, ku kulyuk se, fah lumweyuk el tia nasnas ke lusen len itkosr. ");
INSERT INTO kos_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Pa inge ma ac orek in aknasnasye ma ouinge uh: kutu apat ke cow srusra fohkfok soko ma isisyak mwe eela ma koluk, fah itukla ac filiyuki in sie tup, na kof ma tuku ke unon in itukyang pac nu loac. ");
INSERT INTO kos_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Nu ke ouiya se meet ah: sie mwet su nasnasla elan eis sie lahn hyssop, ac isongya in kof sac, na sang aksroksrokye lohm nuknuk sac, wi ma nukewa oan loac ac mwet ma oasr we. Nu ke ouiya se akluo ah: sie mwet su nasnasla elan eis kof sac ac aksroksrokye mwet se ma pusralla srin mwet, ku mano misa, ku kulyuk. ");
INSERT INTO kos_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Ke len se aktolu ac len se akitkosr, mwet se ma nasnas uh elan sang kof sac aksroksrokye mwet se ma tia nasnas. Ke len se akitkosr an, elan aknasnasyela mwet sac, na tukun mwet sac ohlla nuknuk lal ac ukuiya kof nu facl sifacna, el fah nasnasla ke ekela. ");
INSERT INTO kos_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Kutena mwet su tia nasnas ac tia sifacna aknasnasyalla, fah lumweyuk el srakna tia nasnas, mweyen kof in aknasnas sac tiana ukuiyuki nu facl. El akfohkfokyela Lohm Nuknuk sin LEUM GOD, ac el ac fah tia sifilpa oaoa mu el sie mwet lun God. ");
INSERT INTO kos_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Oakwuk inge ma na nwe tok. Mwet se ma aksroksrokye sie pac mwet ke kof in aknasnas, el enenu in oayapa ohlla nuknuk lal sifacna. Ac kutena mwet su pusral kof sac fah tia nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Sie mwet su tia nasnas fin pusralla kutena ma, na ma se el pusralla uh ekla tia nasnas, ac kutena mwet su pusralla ma sac fah tia pac nasnas nwe ke ekela. ");
INSERT INTO kos_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ke malem se meet, sruf nukewa lun Israel tuku nu yen mwesis Zin ac tulokunak lohm nuknuk selos in acn Kadesh. Na Miriam el misa ac pukpuki we. ");
INSERT INTO kos_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Wangin kof ke acn elos aktuktuk we. Ke ma inge mwet uh tukeni nu yorol Moses ac Aaron ");
INSERT INTO kos_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ac torkaskas fahk, “Kut funu wi mwet Israel wiasr misa na ye mutun Lohm Nuknuk Mutal sin LEUM GOD, lukun wona! ");
INSERT INTO kos_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Efu komtal ku uskutme nu yen mwesis se inge? Mea, tuh kut ac kosro natusr uh in misa we? ");
INSERT INTO kos_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Efu komtal ku uskutme liki acn Egypt nu yen na koluk se inge? Wangin ma ku in kapak fin acn se inge. Wangin wheat, ku fig, ku grape, ku pomegranate — finne kof in nimnim, wangin pac!” ");
INSERT INTO kos_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moses ac Aaron som liki mwet uh ac tu ke acn in utyak lun Lohm Nuknuk Mutal. Eltal faksufi, ac kalem wolana lun LEUM GOD sikyak nu selos. ");
INSERT INTO kos_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Na LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Srukak sikal soko ma oan ke mutun Tuptup in Wuleang, na kom ac Aaron pangoneni un mwet Israel nukewa. Ye mutalos nukewa komtal fah sap nu ke eot se meet oh ingo, na kof uh fah sororma liki eot sac. In lumah se inge kom fah sang kof liki eot sac nimen mwet uh ac oayapa kosro natulos.” ");
INSERT INTO kos_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moses el som ac eis sikal soko ah oana LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Na el ac Aaron pangoneni mwet Israel nukewa nu ke mutun eot sac, ac Moses el fahk, “Porongeyu, kowos mwet tunyuna! Ya kut ac oru tuh kof uh in tuku liki eot se inge nu suwos?” ");
INSERT INTO kos_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moses el kolak sikal soko ah, ac sang sringilya eot sac pacl luo, na kof na lulap se asrma, ac mwet nukewa, wi kosro uh, nim. ");
INSERT INTO kos_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Tusruktu LEUM GOD El sang kas in kai nu sel Moses ac Aaron. El fahk, “Ke sripen srikla lulalfongi lomtal in fahkak kalem ke ku mutal luk ye mutun mwet Israel, komtal ac tia kololos nu in acn se ma nga wuleang in sang lalos.” ");
INSERT INTO kos_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ma inge sikyak Meribah, yen se mwet Israel uh torkaskas lain LEUM GOD we, ac yen se LEUM GOD El akkalemye nu selos lah El mutal. ");
INSERT INTO kos_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moses el supwala mwet utuk kas Kadesh lac nu yurin tokosra lun acn Edom. Elos fahk, “Siyuk se inge ma sin mwet wiom, mwet Israel. Kom etu lupan mwe keok ma sikyak nu sesr uh, ");
INSERT INTO kos_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ke mwet matu lasr tuh som nu Egypt, acn se kut tuh muta we ke yac puspis. Mwet Egypt uh orekut ac mwet matu lasr uh arulana koluk. ");
INSERT INTO kos_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Na kut wowoyak tung nu sin LEUM GOD ac siyuk ke kasru. El lohng tung lasr ac supwama lipufan se, su pwenkutme liki acn Egypt. Inge kut oasr Kadesh, sie acn ma oan sisken masrol nu ke facl sum uh. ");
INSERT INTO kos_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Nunak munas, lela nu sesr in fahsr sasla in acn sum. Kut, ac cow natusr, fah tia kuhfla liki inkanek lulap in utyak nu in ima lom ku ima in grape sunom, ac kut ac fah tia nim kof ke lufin kof lowos uh. Kut ac fahsr na fin inkanek lulap ah, nwe ke kut alukela facl sum uh.” ");
INSERT INTO kos_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Tokosra lun mwet Edom el topuk ac fahk, “Nga tia lelu kowos in fahsr sasla facl sesr uh! Kowos fin srike in oru, kut ac illa mweuni kowos.” ");
INSERT INTO kos_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Na mwet Israel uh fahk, “Kut ac fahsr na ke innek lulap uh, na kut, ku kosro natusr uh, fin nim kutena kof ke facl sum, kut fah moli. Pwayena ma kut enenu pa kut in fahla sasla facl sum uh.” ");
INSERT INTO kos_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Na tokosra sac sifilpa fahk, “Mo! Kut tiana lela!” Na mwet Edom elos illa ke un mwet mweun na lulap ac ku se in mweuni mwet Israel. ");
INSERT INTO kos_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ke sripen mwet Edom uh tia lela mwet Israel in fahla fin acn selos, na mwet Israel forla ac ut ke sokona inkanek. ");
INSERT INTO kos_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Mwet Israel nukewa mukuiyak liki acn Kadesh ac tuku nu Fineol Hor, ");
INSERT INTO kos_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","nu ke masrol lun acn Edom. Ac LEUM GOD El fahk nu sel Moses ac Aaron, ");
INSERT INTO kos_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaron el ac tia wi ilyak nu in facl se su nga wulela in sang nu sin mwet Israel. El ac misa ke sripen komtal tuh lain ma nga sapkin in acn Meribah. ");
INSERT INTO kos_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Eisal Aaron ac Eleazar wen natul, ac utyak nu Fineol Hor. ");
INSERT INTO kos_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Na sarukla nuknuk loeloes lun mwet tol lal Aaron we, ac sang nokmulang Eleazar. Aaron el ac misa ingo.” ");
INSERT INTO kos_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moses el oru oana ke LEUM GOD El sapkin. Eltal fanyak nu Fineol Hor ye mutun mwet Israel nukewa. ");
INSERT INTO kos_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ac Moses el sarukla nuknuk in mwet tol lal Aaron ac sang nokmulang Eleazar. Na Aaron el misa ingo fin mangon eol uh, ac Moses ac Eleazar tufoki liki fineol uh. ");
INSERT INTO kos_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ke mwet Israel elos lohngak lah Aaron el misa, elos nukewa tung ac eoksra kacl ke len tolngoul. ");
INSERT INTO kos_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ke tokosra lun acn Arad, su oan layen eir in acn Canaan, el lohngak lah mwet Israel elos tuku sun acn Atharim, el som mweunelos ac sruokya kutu selos. ");
INSERT INTO kos_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Na mwet Israel elos orala sie wulela na ku nu sin LEUM GOD: “Kom fin lela kut in kutangla mwet inge, kut ac kisakunuloswot nu sum oayapa siti selos, ac kut ac fah kunauselosla.” ");
INSERT INTO kos_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","LEUM GOD El lohngolos ac kasrelos kutangla mwet Canaan. Ouinge mwet Israel arulana sukelosla ac siti selos, ac sang inen acn sac Hormah. ");
INSERT INTO kos_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Mwet Israel som liki Fineol Hor, ac ut ke inkanek ma som nu ke Meoa Srusra, tuh elos in ut na sisken facl sin mwet Edom. Tusruktu ke elos srak fahsr, mwet uh semutengla ");
INSERT INTO kos_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ac kaskas lain God ac Moses. Elos torkaskas ac fahk, “Efu kom ku uskutme liki acn Egypt kut in tuh misa in acn mwesis se inge, yen wanginna mongo ac kof we? Kut tasak ke mwe mongo koluk inge!” ");
INSERT INTO kos_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Na LEUM GOD El supwala serpent pwasin nu inmasrlon mwet uh, ac mwet Israel puspis ngalnguli ac misa. ");
INSERT INTO kos_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ac mwet uh tuku nu yorol Moses ac fahk, “Kut orekma koluk ke kut kaskas lain LEUM GOD ac lain kom. Pre nu sin LEUM GOD Elan usla serpent inge.” Ke ma inge Moses el pre ke mwet uh. ");
INSERT INTO kos_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Na LEUM GOD El fahk nu sel Moses elan orala soko serpent osra, ac likiya mutun soko sak ah, tuh kutena mwet su ngalnguli fin ngetak nu kac, elos fah moul ac tia misa. ");
INSERT INTO kos_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ouinge Moses el orala soko serpent ke bronze ac likiya fin soko sak. Na kutena mwet su ngalnguli, elos ac ngetak nu ke serpent bronze soko ah, ac moul. ");
INSERT INTO kos_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Mwet Israel elos sifil mukuiyak ac tulokunak lohm nuknuk selos in acn Oboth. ");
INSERT INTO kos_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Toko elos som liki acn sac, ac tulokunak nien aktuktuk selos ke mahnum lun Abarim in acn mwesis kutulap in facl Moab. ");
INSERT INTO kos_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Na elos sifilpa mukuiyak liki acn we ac aktuktuk ke infahlfal Zered. ");
INSERT INTO kos_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Elos sifilpa mukuiyak liki acn we ac tuku nu layen epang in Infacl Arnon ac aktuktuk we, ke yen mwesis se su fahla nwe ke facl sin mwet Amor. (Infacl Arnon pa masrol lun facl sin mwet Moab ac mwet Amor.) ");
INSERT INTO kos_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Pa sis Book In Mweun Lun LEUM GOD sramsramkin “...siti srisrik Waheb ke ipin acn lun Suphah, ac infahlfal uh, ac Infacl Arnon, ");
INSERT INTO kos_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ac acn oatu ke infahlfal se ma fahla nwe ke siti srisrik Ar, ac suwosang nwe ke masrol lun acn Moab.” ");
INSERT INTO kos_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Liki acn we elos som na nwe ke sie acn pangpang Lufin Kof, acn se ma LEUM GOD El fahk nu sel Moses, “Usani mwet uh nu sie, ac nga ac fah sang kof nu selos.” ");
INSERT INTO kos_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","In pacl sac mwet Israel uh yuk on soko inge: “Lufin kof uh, unonak; Kut ac fah onkakin kom ke soko on. ");
INSERT INTO kos_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Lufin kof pukpukyak sin leum uh, Ac sin mwet kol lun mwet uh; Pukpukyak ke soko scepter lun tokosra, Oayapa ke sikal lun mwet kol lalos.” Elos mukuiyak liki yen mwesis nu Mattanah, ");
INSERT INTO kos_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ac liki acn we elos som na nwe Nahaliel, ac liki acn Nahaliel me nu Bamoth, ");
INSERT INTO kos_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ac liki acn Bamoth nu infahlfal in acn lun mwet Moab, ye mangon eol Pisgah, su oan ngeta nu fin acn mwesis. ");
INSERT INTO kos_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Na mwet Israel supwala mwet utuk kas nu sel Sihon, tokosra lun mwet Amor, ac fahk: ");
INSERT INTO kos_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Nunak munas, lela nu sesr in fahsr sasla in acn sum. Kut, ac cow natusr, fah tia kuhfla liki inkanek lulap in utyak nu in ima lom ku ima in grape sunom, ac kut ac fah tia nim kof ke lufin kof lowos uh. Kut ac fahsrna fin inkanek lulap ah, nwe ke kut alukela facl sum uh.” ");
INSERT INTO kos_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Tusruktu Tokosra Sihon el tiana fuhlela mwet Israel in fahla fin acn sel. El orani un mwet mweun lal ac illa som nu Jahaz in acn mwesis, ac mweuni mwet Israel. ");
INSERT INTO kos_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Tusruktu mwet Israel elos onela mwet puspis sin mwet lokoalok lalos ke mweun sac, ac sruokya acn selos, mutawauk ke Infacl Arnon nwe ke Infacl Jabbok layen epang, aok nwe ke sun masrol lun mwet Ammon uh, mweyen masrol se ingan musaiyukla arulana ku! ");
INSERT INTO kos_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Na mwet Israel uh kutangla siti nukewa sin mwet Amor, weang Heshbon ac inkul nukewa ma oan apkuran nu we, na elos oakwuki we. ");
INSERT INTO kos_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshbon pa capital siti lal Tokosra Sihon lun mwet Amor, su tuh mweun lain tokosra lun mwet Moab meet, ac eisla acn lal nukewa fahla na nwe Infacl Arnon. ");
INSERT INTO kos_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Pa oru mwet ma yuk pas uh onkakin mu, “Fahsru nu Heshbon, siti sel Tokosra Sihon! Kut kena liye in sifilpa musaiyukyak ac akwoyeyukla. ");
INSERT INTO kos_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Sie pacl ah, in siti se inge Heshbon, Un mwet mweun lal Sihon illa oana sie e. Elos kunausla siti Ar in acn Moab Ac sukela inging sisken infacl Arnon. ");
INSERT INTO kos_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","We nu suwos, mwet Moab! Kowos su alu nu sin Chemosh, kowos arulana musalla! God lowos uh oru tuh mukul we uh in mwet kakaing, Ac mutan we elos mwet sruoh lal Tokosra Sihon lun mwet Amor. ");
INSERT INTO kos_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Tusruktu fwilin tulik natulos kunausyukla, Mutawauk Heshbon lac na nwe Dibon, Liki acn Nashim nwe Nophah, apkuran nu Medeba.” ");
INSERT INTO kos_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Ouinge mwet Israel oakwuki in acn lun mwet Amor, ");
INSERT INTO kos_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ac Moses el supwala kutu mwet kalngeyuk nu ke siti Jazer in konauk lah elos ac mweuni fuka acn we. Mwet Israel elos sruokya siti sac wi inkul nukewa ma oan apkuran nu we, ac lusak mwet Amor su muta we. ");
INSERT INTO kos_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Toko mwet Israel forla ac ut ke inkanek nu Bashan, ac tokosra Og lun Bashan el illa us un mwet mweun lal in mweunelos in acn Edrei. ");
INSERT INTO kos_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","LEUM GOD El fahk nu sel Moses, “Nik kom sangeng sel. Nga ac oru tuh kom in kutanulla, ac mwet lal nukewa ac acn sel. Oru nu sel oana ma kom tuh oru nu sel Sihon, tokosra lun mwet Amor, su leumi acn Heshbon.” ");
INSERT INTO kos_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ouinge mwet Israel elos unilya Tokosra Og, ac wen natul ac mwet lal nukewa — wangin mwet painmoulla — na elos oakwuki in acn sel. ");
INSERT INTO kos_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Mwet Israel mukuiyak som ac tulokunak lohm nuknuk selos yen tupasrpasr in acn Moab, layen kutulap in Infacl Jordan ma tulanang Jericho. ");
INSERT INTO kos_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ke Balak wen natul Zippor, su tokosra lun Moab, el lohng ke ma mwet Israel oru nu sin mwet Amor ac pisen mwet Israel ma oasr we, ");
INSERT INTO kos_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","el, ac mwet lal nukewa, mutawauk in sangeng ac rarrar. ");
INSERT INTO kos_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Mwet Moab fahk nu sin mwet kol lun mwet Midian, “Ac tia paht un mwet se inge ac sukela ma nukewa raunikutyak inge, oana ke soko cow mukul kangla nufon mah ke ima uh.” Ouinge Tokosra Balak ");
INSERT INTO kos_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","el supwala mwet utuk kas in solalma Balaam wen natul Beor, su muta Pethor apkuran nu Infacl Euphrates in acn Amaw. Elos us kas inge sel Balak nu sel Balaam: “Nga ke akkalemye nu sum lah mutunfacl nufon se tuku Egypt me. Mwet inge osralik yen nukewa, ac nunku in eisla acn sik uh. ");
INSERT INTO kos_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Elos ku liki kut, ke ma inge nunak munas fahsru fahkla sie kas in selnga nu faclos keik. Na sahp kut fah ku in kutangulosla ac luselosyak liki acn uh. Nga etu lah ke kom akinsewowoye sie mwet, el insewowo, ac ke kom selngawi sie mwet, el selngawiyuk.” ");
INSERT INTO kos_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ouinge kewana mwet kol lun mwet Moab ac lun mwet Midian elos us mani in moli selnga, ac som nu yorol Balaam, ac fahkang kas lal Balak nu sel. ");
INSERT INTO kos_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam el fahk nu selos, “Mongla yorosr ofong, ac lutu nga fah fahkak nu suwos kutena ma LEUM GOD El fahk nu sik.” Na mwet kol lun mwet Moab elos muta yorol Balaam. ");
INSERT INTO kos_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","God El tuku nu yorol Balaam ac siyuk sel, “Su mwet muta yurum inge?” ");
INSERT INTO kos_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","El topuk, “Tokosra Balak lun mwet Moab el supwalosme in fahk nu sik ");
INSERT INTO kos_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","lah mutunfacl se tuku Egypt me ac oalik fin acn uh nufon. El lungse nga in selngawelos kacl, tuh elan ku in mweunelos ac luselosla.” ");
INSERT INTO kos_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","God El fahk nu sel Balaam, “Nik kom wi mwet inge som. Nga akinsewowoye tari mwet Israel, na pa kom in tia selngawelos.” ");
INSERT INTO kos_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Lotutang tok ah, Balaam el som nu yurin mwet lal Balak ac fahk, “Folokla nu yen suwos. LEUM GOD El tia lela nga in wi kowos som.” ");
INSERT INTO kos_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ouinge elos folokla nu yorol Balak ac fahkang nu sel lah Balaam el srangesr welulos. ");
INSERT INTO kos_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Na Balak el supwala sie u in mwet kol pus liki u se meet ah, ac fulat lukelos. ");
INSERT INTO kos_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Elos som nu yorol Balaam ac fahkang kas lal Balak inge: “Nga kwafe kom in tuku na! Nimet sang kutena ma in ikolkomi. ");
INSERT INTO kos_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Nga ac moli nu sum ke sie lupa na yohk. Ma nukewa kom fahk an nga ac oru. Nunak munas, fahsru ac selngawiya mwet inge keik.” ");
INSERT INTO kos_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Tusruktu Balaam el topkolos ac fahk, “Balak el finne ase luk silver ac gold nukewa in lohm sel, nga enenu na in oru oana ma LEUM GOD luk El sapkin nu sik. Nga tia ku in akyokyela ku aksrikyela sap lal. ");
INSERT INTO kos_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ke ma inge, nunak munas mongla yorosr ofong oana u se meet ah, na nga fah ku in etu lah ac oasr pac ma LEUM GOD El ac fahk nu sik.” ");
INSERT INTO kos_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ke fong sac God El tuku nu yorol Balaam ac fahk, “Mwet inge fin siyuk kom in welulos som, akola kom in welulos. Tusruktu oru na ma nga fahk nu sum uh.” ");
INSERT INTO kos_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ouinge Balaam el tukakek ke lotutang tok ah, akoela donkey natul ah, ac wi mwet kol Moab ah som. ");
INSERT INTO kos_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","God El kasrkusrak lah Balaam el wi som, na ke Balaam el kasrusr lin donkey natul, ac mwet kulansap luo lal atlol, lipufan lun LEUM GOD tuyak kosrala inkanek uh. ");
INSERT INTO kos_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ke donkey soko ah liyauk lipufan se tu we ac sruok cutlass se, el kuhfla liki inkanek uh ac som nu inimae. Balaam el sringil donkey soko ah ac tolokunulma nu inkanek uh. ");
INSERT INTO kos_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Na lipufan sac tui ke soko inkanek oasriksrik inmasrlon ima in grape luo, ac oasr pot fulat siska lac lac. ");
INSERT INTO kos_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ke donkey soko uh liyauk lipufan sac, el kalukyang nu ke sisken soko pot uh ac itungya nial Balaam nu kac. Balaam el sifilpa sringil donkey natul uh. ");
INSERT INTO kos_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Na lipufan sac sifilpa kilukyak nu meet, tui ke sie acn iktok ma wangin na pwaye acn mwet ku in aikil we. ");
INSERT INTO kos_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Na ke donkey soko ah liye lipufan sac, el ona infohk ah. Balaam el foloyak ac sifilpa srunglul ke sak soko sel. ");
INSERT INTO kos_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Na LEUM GOD El sang ku nu sin donkey ah in sramsram, na el fahk nu sel Balaam, “Mea nga oru koluk nu sum? Efu ku kom uniyu pacl tolu lac?” ");
INSERT INTO kos_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam el topuk, “Mweyen kom oru oana ngan arulana lalfon! Funu oasr cutlass sik, nga lukun unikomi na.” ");
INSERT INTO kos_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Donkey el sifilpa fahk, “Ya tia nga na pa donkey soko ma kom nuna kasrusr fac in moul lom nufon? Mea, oasr pacl nga oru ouinge nu sum meet?” El topuk, “Wangin.” ");
INSERT INTO kos_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Na LEUM GOD El oru tuh Balaam elan ku in liyauk lipufan sac ke el tu sruok cutlass natul; ac Balaam el faksufi nu infohk uh. ");
INSERT INTO kos_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Lipufan sac siyuk sel, “Efu ku kom uni donkey nutum ouinge pacl tolu lac? Nga tuku in tuh kosrekomla, mweyen kom tia enenu in orala fahsr se lom inge. ");
INSERT INTO kos_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","A donkey nutum uh liyeyuyak ac kuhfla liki inkanek uh pacl tolu. El funu tia kuhfla, nga lukun unikomi ac molella.” ");
INSERT INTO kos_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam el topuk, “Nga orekma koluk. Nga tiana etu lah kom tu inkanek uh in kosreyula. Tusruktu inge kom fin nunku mu tia wo nga in som, na tari nga ac folokla nu yen sik.” ");
INSERT INTO kos_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","A lipufan sac fahk nu sel, “Wi na mwet inge som, tusruktu kom fah fahk na ma nga ac sap kom in fahk uh.” Ouinge Balaam el wi mwet uh som. ");
INSERT INTO kos_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ke Balak el lohngak lah Balaam el tuku, el som in osun nu sel in acn Ar, sie siti su oan sisken Infacl Arnon ke masrol lun Moab. ");
INSERT INTO kos_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak el fahk nu sel, “Efu kom tia tuku ke nga tuh suli kom meet ah? Ya kom nunku mu nga tia ku in moli wo nu sum?” ");
INSERT INTO kos_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam el topuk, “Liye, nga pa inge. Tusruktu, ku fuka se luk an? Ma na God El sapkin uh pa nga ac fahk uh.” ");
INSERT INTO kos_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ouinge Balaam el welul Balak som nu ke siti srisrik Huzoth, ");
INSERT INTO kos_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","yen Balak el kisakin cow ac sheep we, ac sang kutu ikwen ma inge nu sel Balaam ac mwet kol su welul. ");
INSERT INTO kos_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","In lotu tok ah, Balak el usalak Balaam nu Bamoth Baal, sie acn su Balaam el ac ku in ngetla ac liye kutu sin mwet Israel ah we. ");
INSERT INTO kos_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam el fahk nu sel Balak, “Etoak itkosr loang an luk inse inge, ac use itkosr cow mukul ac itkosr sheep mukul.” ");
INSERT INTO kos_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak el oru oana ma fwack nu sel, na el ac Balaam kisakin cow mukul soko ac sheep mukul soko fin kais sie loang inge. ");
INSERT INTO kos_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Na Balaam el fahk nu sel Balak, “Tu ke kisa firir lom inge soaneyu ngan fahla ac liye lah LEUM GOD El ac osun nu sik ku tia. Nga ac fah fahk nu sum ma nukewa ma El ac akkalemye nu sik.” Ouinge el mukena utyak nu fin inging uh, ");
INSERT INTO kos_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ac God El osun nu sel. Balaam el fahk nu sel, “Nga etoak tari loang itkosr, ac kisakin cow mukul soko ac sheep mukul soko fin kais sie loang.” ");
INSERT INTO kos_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","LEUM GOD El fahkang nu sel Balaam ma elan fahk, ac folokunulla nu yorol Balak. ");
INSERT INTO kos_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ouinge el folokla ac liye lah Balak el srakna tu sisken mwe kisa firir lal wi mwet kol nukewa lun Moab. ");
INSERT INTO kos_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Na Balaam el fahkak kas in palu inge: “Balak, tokosra lun Moab, el usyume Liki acn Syria, liki eol kutulap. El fahk, ‘Fahsru, kaskas keik. Selngawiya mwet Israel.’ ");
INSERT INTO kos_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Nga ac selngawi fuka elos su God El tia selngawi, Ku fahk kas in lusla LEUM GOD El fin tia fahk? ");
INSERT INTO kos_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Nga ku in tu fin eot fulat uh liyalos; Nga ku in tu fin inging uh intoeinulos. Sie mutunfacl su mukena muta pa elos; Elos etu lah akinsewowoyuk elos yohk liki kutena mutunfacl saya. ");
INSERT INTO kos_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Fwilin tulik nutin Israel uh pus oana kutkut uh, Arulana pusla, tia ku in oaoala. Lela len safla luk uh in oana len safla un mwet lun God; Ac lela nga in misa oana sie mwet suwoswos.” ");
INSERT INTO kos_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Na Balak el fahk nu sel Balaam, “Mea se kom oru nu sik inge? Nga uskomme kom in tuh selngawi mwet lokoalok luk, a kom akinsewowoyalos mukena.” ");
INSERT INTO kos_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","El topuk, “Ma na LEUM GOD El sap nga in fahk pa nga ku in fahk uh.” ");
INSERT INTO kos_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Na Balak el fahk nu sel Balaam, “Fahsru wiyu nu ke sie pac acn ma kom ku in liye kutu pac sin mwet Israel uh. Na kom fah selngawelos we keik.” ");
INSERT INTO kos_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","El usal nu ke ima lun Zophim fin mangon Eol Pisgah. El etoak pac loang itkosr we ac kisakin cow mukul soko ac sheep mukul soko fin kais sie loang uh. ");
INSERT INTO kos_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam el fahk nu sel Balak, “Tu sisken mwe kisa firir lom inge soaneyu, ac nga ac som osun nu sin God inse ingo.” ");
INSERT INTO kos_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","LEUM GOD El sonol Balaam, ac fahkang nu sel ma elan fahk, na el folokunulla nu yorol Balak. ");
INSERT INTO kos_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ouinge el folokla ac liye lah Balak el srakna tu sisken mwe kisa firir lal uh, wi mwet kol lun Moab. Balak el siyuk lah mea LEUM GOD El fahk, ");
INSERT INTO kos_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ac Balaam el fahkak kas in palu inge: “Balak, wen natul Zippor, fahsru Ac porongo ma nga ac fahk uh. ");
INSERT INTO kos_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God El tia oana mwet uh in kaskas kikiap, Tia mwet se pa El in ikil nunak lal, Kutena ma El wulela kac El ac orala na; El kaskas, ac ma El fahk uh orekla. ");
INSERT INTO kos_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Fwackme nu sik mu nga in akinsewowoye, Ac God El fin akinsewowoye, nga tia ku in folokunla. ");
INSERT INTO kos_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Nga akilen mu wangin ma ac akkolukye ku aklokoalokye Moul lun mwet Israel ke pacl fahsru. LEUM GOD lalos El welulos; Elos fahkak kalem lah El pa tokosra lalos. ");
INSERT INTO kos_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God El usalosme liki acn Egypt; El mweun kaclos oana soko cow mukul lemnak. ");
INSERT INTO kos_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Wangin susfa ac wangin inutnut Ku in orek lain mutunfacl Israel. Inge mwet uh ac fahk ke Israel, ‘Liyewin ma God El oru!’ ");
INSERT INTO kos_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Mutunfacl Israel el oana soko lion na fokoko; El tia mongla nwe ke el eiya, kangla, Ac numla srah ke ma el uniya uh.” ");
INSERT INTO kos_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Na Balak el fahk nu sel Balaam, “Kom finne srunga selngawi mwet Israel, tuh nimet kom akinsewowoyalos!” ");
INSERT INTO kos_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam el topuk, “Ya nga tuh tia fahkot nu sum lah ma na LEUM GOD El fahk nu sik pa nga ac oru uh?” ");
INSERT INTO kos_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Tokosra Balak el fahk, “Fahsru wiyu, ac nga ac fah uskomla nu ke sie pacna acn. Sahp God El ac lela kom in selngawelos liki acn we nu sik.” ");
INSERT INTO kos_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ouinge el usalak Balaam nu fin mangon Eol Peor, su el ku in ngeta we lac nu fin acn mwesis. ");
INSERT INTO kos_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam el fahk nu sel, “Etoak itkosr loang an nu sik inge, ac use itkosr cow mukul ac itkosr sheep mukul nu yuruk.” ");
INSERT INTO kos_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak el oru oana ke fwack nu sel, ac el kisakin cow mukul soko ac sheep mukul soko fin kais sie loang. ");
INSERT INTO kos_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","In pacl se inge, Balaam el etu tari lah LEUM GOD El lungse elan akinsewowoye mwet Israel, ke ma inge el tia enenu in sukok kasru ke susfa, oana el muta oru meet ah. El ngetla nu yen mwesis ");
INSERT INTO kos_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ac liye mwet Israel lah elos mutangan aktuktuk ke kais sie sruf lalos. Ngun lun God tuku ke ku nu facl, ");
INSERT INTO kos_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","na el fahk kas in palu inge: “Kas inge ma sel Balaam wen natul Beor, Kas lun sie mwet su ku in liye arulana kalem, ");
INSERT INTO kos_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Su ku in lohng ma God El fahk uh. Mutuk ngetnget na ac oana ngan liye Sie aruruma sin God Kulana. ");
INSERT INTO kos_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Lohm nuknuk sin mwet Israel uh arulana kato, ");
INSERT INTO kos_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Oana tak na loeloes ke sak palm, Ku ima puspis ma oan sisken soko infacl, Oana sak aloes ma LEUM GOD El yukwiya, Ku sak cedar sisken kof uh. ");
INSERT INTO kos_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ac fah arulana yohk af nu faclos Ac elos ac yukwiya fita sunalos ke fohk ma aksroksrokyeyuk. Tokosra lalos ac fah fulat lukel Agag, Ac tokosrai lal ac fah fahsrelik nu yen loessula. ");
INSERT INTO kos_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God El usalosme liki acn Egypt; El mweun kaclos oana soko cow mukul lemnak. Elos kontonauk mwet lokoalok lalos, Itungya srelos, ac kotkoteya sukan pisr natulos. ");
INSERT INTO kos_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Mutunfacl se inge oana soko lion kulana; Ke el motul, wangin sie mwet ac pulaik in oaksalak. Kutena mwet su akinsewowoye Israel ac fah akinsewowoyeyuk. Ac kutena mwet su selngawel Israel ac fah selngawiyuk.” ");
INSERT INTO kos_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Tokosra Balak el isani paol ke kasrkusrak ac fahk nu sel Balaam, “Nga tuh pangonkomme kom in selngawi mwet lokoalok luk, a pacl tolula kom akinsewowoyalos ac tiana selngawelos. ");
INSERT INTO kos_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Tari, folokot nu yen sum an! Nga tuh wulela mu nga ac moli yohk nu sum, tuh pa LEUM GOD El kosrala kom in tia eis mwe moul nu sum uh.” ");
INSERT INTO kos_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam el topuk, “Nga tuh fahkang nu sin mwet kom supwama ah mu ");
INSERT INTO kos_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","kom finne ase nufon silver ac gold inkul fulat sum an luk, nga ac tia ku in seakos ma sap lun LEUM GOD nu sik ac sifacna oru kutena ma. Nga ac fahk na ma LEUM GOD El sap ngan fahk mukena.” ");
INSERT INTO kos_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Balaam el fahk nu sel Balak, “Inge nga ac folokla nu yurin mwet luk uh, tusruktu meet liki nga som, nga ac fahkot ma mwet Israel uh ac mau oru nu sin mwet lom ke pacl fahsru uh.” ");
INSERT INTO kos_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Na el fahk kas in palu inge: “Kas inge ma sel Balaam wen natul Beor, Kas lun sie mwet su ku in liye arulana kalem, ");
INSERT INTO kos_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Su ku in lohng ma God El fahk uh Ac eis etauk su tuku sin El su Fulatlana. Mutuk ngetnget na ac nga liye Sie aruruma sin God Kulana. ");
INSERT INTO kos_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ke nga ngetla liye pacl fahsru, Nga liye mutunfacl Israel. Sie tokosra ac fah sikyak in facl sac, oana sie itu, Sie tokosra ku ac fah tuku liki facl Israel. El fah sringilya mwet kol lun acn Moab Ac kunausla mwet Seth nukewa. ");
INSERT INTO kos_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","El fah kutangla mwet lokoalok lal in acn Edom. Ac eisla acn lalos uh tuh in ma lal. Ke pacl se inge, Israel ac nuna kutangla acn puspis saya. ");
INSERT INTO kos_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Mutunfacl Israel fah fotongolosi nu infohk uh Ac sukela mwet nukewa ma srakna moul.” ");
INSERT INTO kos_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Na Balaam el liye mwet Amalek, ac el fahk kas in palu inge: “Amalek pa mutunfacl se ma ku liki nukewa, Tusruktu saflaiyal el fah wanginla ma pahtpat.” ");
INSERT INTO kos_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","In aruruma lal el liye pac mwet Ken, ac el fahk kas in palu inge: “Acn se ma kowos muta we oakwuki arulana ku, Oana sie ahng oan yen fulat fin fulu uh. ");
INSERT INTO kos_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Tusruktu kowos mwet Ken ac fah kunausyukla, Ke mwet Assyria ac fah uskowosla nu in sruoh.” ");
INSERT INTO kos_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Na Balaam el fahk kas in palu inge: “Su mwet ma fahsreni in acn epang inge? ");
INSERT INTO kos_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Mwet mweun ac fah kal tuku Cyprus me; Elos ac kutangla acn Assyria ac acn Eber Tusruktu, elos sifacna ac fah wanginla ma pahtpat.” ");
INSERT INTO kos_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Na Balaam el mukuiyak ac folokla nu yen sel, ac Balak el oayapa som nu yen sel. ");
INSERT INTO kos_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ke mwet Israel elos aktuktuk ke Infahlfal Acacia, kutu sin mukul Israel mutawauk in orek kosro yurin mutan Moab su muta we. ");
INSERT INTO kos_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Mutan inge suli mukul uh nu ke kufwen akfulatye god lun mwet Moab. Mwet Israel elos kang mwe mongo ma kisakinyukla ac wi alu nu ke god se pangpang ");
INSERT INTO kos_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Baal lun Peor. Ouinge LEUM GOD El kasrkusrak selos ");
INSERT INTO kos_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ac fahk nu sel Moses, “Kom in akosyu in lumah se inge: eis mwet kol nukewa lun mwet Israel ac fakselosi yen mwet nukewa ku in liye, na nga fah tila kasrkusrak sin mwet uh.” ");
INSERT INTO kos_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moses el fahk nu sin mwet kol fulat lun sruf uh, “Kais sie suwos in uniya mwet nukewa in sruf lowos ma wela alu nu sin Baal lun Peor.” ");
INSERT INTO kos_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Sie sin mwet Israel uh eis sie sin mutan Midian ac usalak nu in lohm nuknuk sel ye mutal Moses ac mwet Israel nukewa ke pacl se elos muta mwemelil ke nien utyak nu in Lohm Nuknuk Mutal sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ke Phinehas, wen natul Eleazar, wen natul Aaron mwet tol, el liye ma inge, el tuyak ac som liki u sac. El srukak osra in fakfuk soko, ");
INSERT INTO kos_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","na el fahsr tukun mukul sac ac mutan sac nu in lohm nuknuk sac, ac kaskeang nu kacltal kewa. In ouiya se inge mas upa se ma arulana akkolukye Israel uh tui, ");
INSERT INTO kos_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","tusruktu mas se inge uniya tari tausin longoul akosr sin mwet Israel. ");
INSERT INTO kos_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Ke sripen ma se Phinehas el orala uh, nga tila mulat sin mwet Israel. El koflana muteng in liye ke mwet uh alu nu sin kutena god sayuk, na pa ingan sripa se oru nga tia kunauselosla ke kasrkusrak luk uh. ");
INSERT INTO kos_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Ke ma inge kom fahkang nu sel lah nga ac orala sie wuleang inmasrlok el su fah oanna nwe tok. ");
INSERT INTO kos_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","El, ac fwilin tulik natul, ac fah mwet tol nwe tok. Ke sripen el ngalkinyu, pa oru nga nunak munas ke ma koluk lun mwet uh.” ");
INSERT INTO kos_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Inen mukul Israel se su anwuki wi mutan Midian sac pa Zimri wen natul Salu. Zimri el sifen sie sou lulap in sruf lal Simeon. ");
INSERT INTO kos_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Inen mutan sac pa Cozbi, acn natul Zur, su pa leum lun sie u lun sou lulap in acn Midian. ");
INSERT INTO kos_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Na LEUM GOD El sapkin nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Tuyak ac mweuni mwet Midian ac kunauselosla, ");
INSERT INTO kos_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ke sripen ma koluk elos oru nu suwos ke elos tuh kiapwekowosla in acn Peor — ac ke sripal Cozbi, su tuh anwuki ke pacl se mas upa sac sikyak in acn Peor.” ");
INSERT INTO kos_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Tukun mas upa sac, LEUM GOD El fahk nu sel Moses ac Eleazar wen natul Aaron, ");
INSERT INTO kos_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Oru sie oaoa lulap ke pisen mwet uh ke sou nukewa in kais sie sruf lun Israel, ke mukul nukewa yac longoulyak matwa su fal in wi mweun.” ");
INSERT INTO kos_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moses ac Eleazar pangon mukul nukewa in toeni in acn mwesis lun Moab, kutulap in Infacl Jordan, tulanang Jericho. Eltal fahk nu selos, ");
INSERT INTO kos_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Kowos in oakla mukul nukewa ma yac longoulyak,” oana LEUM GOD El sapkin nu sel Moses. Pa inge mwet Israel su tuku liki facl Egypt: ");
INSERT INTO kos_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Sruf lal Reuben pa inge (Reuben pa wounse mukul natul Jacob): sou lulap lal Hanoch, lal Pallu, ");
INSERT INTO kos_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","lal Hezron, ac lal Carmi. ");
INSERT INTO kos_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Pisen mukul ke sou lulap inge kewa oasr ke angngaul tolu tausin itfoko tolngoul. ");
INSERT INTO kos_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Fwilin tulik natul Pallu pa Eliab, ");
INSERT INTO kos_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ac wen natul inge: Nemuel, Dathan, ac Abiram. (Dathan ac Abiram pa tuh solla in mwet kol lun mwet uh. Eltal tuh lainul Moses ac Aaron ke eltal srola wela mwet ke u lal Korah ke pacl se elos tunyuna lain LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Infohk uh mangelik ac okomulosla, ac elos misa welul Korah ac mwet lal ke pacl se e uh onela mwet luofoko lumngaul. Lumah se inge tuh sie mwe akul in sensenkakin mwet Israel nukewa. ");
INSERT INTO kos_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Tusruktu wen natul Korah tiana anwukla.) ");
INSERT INTO kos_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Sruf lal Simeon pa inge: sou lulap lal Nemuel, lal Jamin, lal Jachin, ");
INSERT INTO kos_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","lal Zerah, ac lal Shaul. ");
INSERT INTO kos_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Pisen mukul ke sou lulap inge kewa oasr ke longoul luo tausin luofoko. ");
INSERT INTO kos_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Sruf lal Gad pa inge: sou lulap lal Zephon, lal Haggi, lal Shuni, ");
INSERT INTO kos_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","lal Ozni, lal Eri, ");
INSERT INTO kos_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","lal Arod, ac lal Areli. ");
INSERT INTO kos_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Pisen mukul ke sou lulap inge kewa oasr ke angngaul tausin lumfoko. ");
INSERT INTO kos_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Sruf lal Judah pa inge: (Wen luo natul Judah pa Er ac Onan, tuh eltal misa na in acn Canaan.) ");
INSERT INTO kos_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Sou lulap lal Shelah, lal Perez, ac lal Zerah. ");
INSERT INTO kos_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Fwilin tulik natul Perez pa tulik natul Hezron, ac tulik natul Hamul. ");
INSERT INTO kos_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Pisen mukul ke sou lulap inge kewa oasr ke itngoul onkosr tausin lumfoko. ");
INSERT INTO kos_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Sruf lal Issachar pa inge: sou lulap lal Tola, lal Puah, ");
INSERT INTO kos_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","lal Jashub, ac lal Shimron. ");
INSERT INTO kos_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Pisen mukul ke sou lulap inge kewa oasr ke onngoul akosr tausin tolfoko. ");
INSERT INTO kos_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sruf lal Zebulun pa inge: sou lulap lal Sered, lal Elon, ac lal Jahleel. ");
INSERT INTO kos_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Pisen mukul ke sou lulap inge kewa oasr ke onngoul tausin lumfoko. ");
INSERT INTO kos_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Sruf luo lal Joseph, pa Manasseh ac Ephraim, wen luo natul. ");
INSERT INTO kos_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Sruf lal Manasseh pa inge: Machir wen natul Manasseh pa papa tumal Gilead, ac sou lulap takla inge, takme tokol Gilead, su papa matu tumalos: ");
INSERT INTO kos_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","sou lulap lal Iezer, lal Helek, ");
INSERT INTO kos_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","lal Asriel, lal Shechem, ");
INSERT INTO kos_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","lal Shemida, ac lal Hepher. ");
INSERT INTO kos_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelophehad wen natul Hepher, wangin wen natul, a acn mukena — inelos pa Mahlah, Noah, Hoglah, Milcah, ac Tirzah. ");
INSERT INTO kos_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Pisen mukul ke sou lulap inge kewa oasr ke lumngaul luo tausin ac itfoko. ");
INSERT INTO kos_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Sruf lal Ephraim pa inge: sou lulap lal Shuthelah, lal Becher, ac lal Tahan. ");
INSERT INTO kos_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sou lulap lal Eran mutawauk yorol Shuthelah. ");
INSERT INTO kos_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Pisen mukul ke sou lulap inge kewa oasr ke tolngoul luo tausin ac lumfoko. Sou lulap inge kewa ma tuku kacl Joseph. ");
INSERT INTO kos_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Sruf lal Benjamin pa inge: sou lulap lal Bela, lal Ashbel, lal Ahiram, ");
INSERT INTO kos_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","lal Shephupham, ac lal Hupham. ");
INSERT INTO kos_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Sou lulap lal Ard ac lal Naaman mutawauk kacl Bela. ");
INSERT INTO kos_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Pisen mukul ke sou lulap inge kewa oasr ke angngaul limekosr tausin ac onfoko. ");
INSERT INTO kos_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Sruf lal Dan pa inge: sou lulap lal Shuham. ");
INSERT INTO kos_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Pisen mukul ke sou lulap se inge oasr ke onngoul akosr tausin ac angfoko. ");
INSERT INTO kos_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Sruf lal Asher pa inge: sou lulap lal Imnah, lal Ishvi, ac lal Beriah. ");
INSERT INTO kos_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Sou lulap lal Heber ac lal Malchiel mutawauk kacl Beriah. ");
INSERT INTO kos_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Oasr acn se natul Asher, inel pa Serah. ");
INSERT INTO kos_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Pisen mukul ke sou lulap inge kewa oasr ke lumngaul tolu tausin ac angfoko. ");
INSERT INTO kos_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Sruf lal Naphtali pa inge: sou lulap lal Jahzeel, lal Guni, ");
INSERT INTO kos_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","lal Jezer, ac lal Shillem. ");
INSERT INTO kos_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Pisen mukul ke sou lulap inge kewa oasr ke angngaul limekosr tausin ac angfoko. ");
INSERT INTO kos_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Pisen mukul Israel nukewa toeni orala tausin onfoko sie ac itfoko tolngoul. ");
INSERT INTO kos_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Kitalik acn uh nu sin sruf nukewa, fal nu ke pisen mwet ke kais sie sruf. ");
INSERT INTO kos_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Nu sin sie sruf lulap kom fah sang sie acn yohk tuh in acn selos, ac nu sin sie sruf srisrik kom fah sang sie acn srisrik tuh in acn selos. Sang nu sin sruf nukewa sie acn fal nu ke pisalos. ");
INSERT INTO kos_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Tusruktu acn an ac fah kitakatelik ke fa; fal nu ke inen papa tumun kais sie sruf. ");
INSERT INTO kos_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Sruf lulap ac fah usrui acn lulap, ac sruf srisrik ac fah usrui acn srisrik. ");
INSERT INTO kos_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Sruf lal Levi pa inge: sou lulap lal Gershon, lal Kohath, ac lal Merari. ");
INSERT INTO kos_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Fwilin tulik natulos pa ke sou lal Libni, lal Hebron, lal Mahli, lal Mushi, ac lal Korah. Kohath pa papa tumal Amram, ");
INSERT INTO kos_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","su tuh payukyak sel Jochebed, acn natul Levi. Jochebed el tuh isusla in acn Egypt, ac el osweang nu sel Amram wen luo: Aaron ac Moses, ac acn se, Miriam. ");
INSERT INTO kos_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Oasr wen akosr natul Aaron: inelos pa Nadab, Abihu, Eleazar, ac Ithamar. ");
INSERT INTO kos_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab ac Abihu eltal misa ke sripen eltal tuh orek kisa nu sin LEUM GOD ke sie e tia mutal. ");
INSERT INTO kos_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Pisen mukul in sruf lal Levi su malem seyak matwa, oasr ke tausin longoul tolu. Elos oaoala sayen mwet Israel nukewa, ke sripen wangin acn itukyang lalos ke acn lun Israel. ");
INSERT INTO kos_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Sou lulap inge nukewa simla sel Moses ac Eleazar pacl se elos eis oaoa lulap ke mwet Israel in acn mwesis lun Moab, su oan layen nu kutulap ke Infacl Jordan tulanang Jericho. ");
INSERT INTO kos_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Wangin siefanna mukul lula ke oaoa se meet ma Moses ac Aaron tuh oru yen mwesis Sinai. ");
INSERT INTO kos_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","LEUM GOD El tuh fahk mu elos nukewa ac misa yen mwesis, sayal Caleb wen natul Jephunneh, ac Joshua wen natul Nun. ");
INSERT INTO kos_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Mahlah, Noah, Hoglah, Milcah, ac Tirzah pa acn natul Zelophehad, wen natul Hepher su wen natul Gilead, wen natul Machir, wen natul Manasseh, wen natul Joseph. ");
INSERT INTO kos_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Elos som ac tu ye mutal Moses ac Eleazar mwet tol, oayapa ye mutun mwet kol ac sruf nukewa lun mwet Israel ke acn in utyak nu ke Lohm Nuknuk Mutal sin LEUM GOD ac fahk, ");
INSERT INTO kos_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Papa tumasr el tuh misa yen mwesis, a wangin wen natul. El tia sie sin mwet welul Korah su tunyuna lain LEUM GOD. El misa ke ma koluk lal sifacna. ");
INSERT INTO kos_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Ya mweyen na wangin wen natul papa, pa in wanginla inel liki mwet Israel? Ase ip lasr ke acn lun sou lun papa tumasr.” ");
INSERT INTO kos_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Na Moses el sang mwe siyuk lalos nu sin LEUM GOD ");
INSERT INTO kos_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ac LEUM GOD El fahk nu sel, ");
INSERT INTO kos_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Pwaye ma acn natul Zelophehad inge siyuk uh. Sang ip lalos ke acn lun sou lun papa tumalos. Lela usru lun papa tumalos in itukyang nu selos. ");
INSERT INTO kos_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Fahk nu sin mwet Israel lah kutena mukul su misa ac wangin wen natul, na acn natul fah usrui ma lal. ");
INSERT INTO kos_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Fin wangin acn natul, na tamulel lal fah usrui acn sel. ");
INSERT INTO kos_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Fin wangin pac tamulel lal, tamulel lun papa tumal pa ac eis usru sac. ");
INSERT INTO kos_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Fin wangin tamulel wien papa tumal, na sie mwet in sou sac ma fototo emeet nu sel pa ac eis usru lal oana ma lal sifacna. Mwet Israel uh in karingin oakwuk ku se inge oana ke nga, LEUM GOD, sapkin nu sum.” ");
INSERT INTO kos_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","LEUM GOD El fahk nu sel Moses, “Fanyak nu Fineol Abarim ac ngetla nu fin facl se ma nga ac sang nu sin mwet Israel. ");
INSERT INTO kos_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Tukun kom liye tari, kom ac misa, oana Aaron tamulel lom, ");
INSERT INTO kos_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","mweyen komtal kewa utuk nunak lain ma nga sapkin yen mwesis Zin. Ke pacl se mwet in sruf nukewa elos torkaskas lainyu Meribah, komtal srunga akkalemye ku mutal luk ye mutalos.” (Meribah pa unon in kof se Kadesh in acn mwesis Zin.) ");
INSERT INTO kos_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Na Moses el pre ac fahk, ");
INSERT INTO kos_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“O LEUM GOD, moul lun ma moul nukewa tuku sum me. Nga pre tuh kom in srisrngiya sie mwet su ku in kol mwet inge, ");
INSERT INTO kos_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ac su ku pac in kololos in pacl in mweun, tuh mwet inge nukewa fah tia oana sheep su wangin mwet shepherd la.” ");
INSERT INTO kos_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","LEUM GOD El fahk nu sel Moses, “Eisal Joshua wen natul Nun, ac filiya poum fin sifal, mweyen Ngun lun God oan in el. ");
INSERT INTO kos_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Sap elan tu ye mutal Eleazar mwet tol, oayapa ye mutun mwet Israel nukewa, na kom fah akkalemye nu selos nukewa lah el pa ac aol kom. ");
INSERT INTO kos_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Sang nu sel kutu ku ac wal lom sifacna, tuh sruf nukewa lun mwet Israel fah aksol. ");
INSERT INTO kos_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","El ac fah tupanul Eleazar mwet tol, su ac fah suk lungse luk ke el ac orekmakin Urim ac Thummim. In ouiya se inge, Eleazar el ac fahk nu sel Joshua ac mwet Israel nukewa ma elos ac oru.” ");
INSERT INTO kos_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moses el oru oana ma LEUM GOD El sapkin nu sel. El oru tuh Joshua elan tu ye mutal Eleazar mwet tol ac ye mutun sruf nukewa lun Israel. ");
INSERT INTO kos_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Na Moses el filiya paol fin sifal Joshua, oana ma LEUM GOD El sapkin, ac el fahkak lah Joshua pa ac aolul. ");
INSERT INTO kos_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","elan sapkin nu sin mwet Israel in sang mwe mongo ma fal in kisakinyuk nu sin God ke pacl pakiyuki nu kac, su fohlo uh akinsewowoyal. ");
INSERT INTO kos_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Pa inge mwe mongo ma fal in kisakinyuk nu sin LEUM GOD: kais sie len, kisakin sheep fusr mukul lukwa yac se matwa su wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Kisakin soko sheep fusr inge ke lotutang, ac ma soko ngia ke ekela. ");
INSERT INTO kos_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Ke kais soko sheep inge, sang pac paun in flao luo ma karkarak ke cup akosr ke oil in olive wowo tuh in mwe kisa wheat. ");
INSERT INTO kos_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Pa inge mwe kisa firir ma eneneyuk in orek ke len nukewa, su tuh mutawauk orek Fineol Sinai — sie mwe kisa mongo ma orek ke e, su fohlo uh akinsewowoye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Okoala cup akosr ke wain sisken loang uh tuh in weang sheep fusr soko meet ah. ");
INSERT INTO kos_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ke ekela, kisakin sheep fusr soko aklukwa in lumah se na ma orek ke mwe kisa ke lotutang, wi kisa wheat ac kisa wain nu kac. Kisakin ma inge oana sie mwe kisa mongo orek ke e, su fohlo uh akinsewowoye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Ke len Sabbath, kisakin lukwa sheep fusr mukul yac se matwa su wangin kutena ma koluk ke mano, wi paun in flao akosr karak ke oil in olive tuh in mwe kisa wheat, oayapa mwe kisa ke wain. ");
INSERT INTO kos_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Mwe kisa firir se inge ac orek ke len Sabbath nukewa, in weang pacna mwe kisa lun len nukewa wi mwe kisa wain uh. ");
INSERT INTO kos_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Ke len se emeet ke malem nukewa, kisakin sie mwe kisa firir nu sin LEUM GOD ke cow mukul fusr lukwa, sheep mukul soko, itkosr sheep fusr mukul yac sie matwa, ac kewana in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","In akfalye mwe kisa wheat, sang onkosr paun in flao karyak ke oil in olive in wi kais soko cow mukul, ac paun akosr ke flao in wi sheep mukul soko; ");
INSERT INTO kos_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ac paun luo ke flao in wi kais soko sheep fusr. Mwe kisa firir inge pa sie mwe kisa mongo ma orek ke e, su fohlo uh akinsewowoye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Srikasrak nu ke mwe kisa wain uh pa quart luo in wi kais soko cow mukul, quart se tafu in wi sheep mukul soko, ac quart se in wi kais soko sheep fusr. Pa inge oakwuk nu ke mwe kisa firir ke len se emeet ke malem nukewa in yac se. ");
INSERT INTO kos_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","In weang mwe kisa firir lun kais sie len wi mwe kisa wain uh, kisakin soko nani mukul tuh in sie mwe kisa ke ma koluk. ");
INSERT INTO kos_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Kufwen Alukela uh ma orek in akfulatye LEUM GOD ac fah orek ke len aksingoul akosr ke malem se meet. ");
INSERT INTO kos_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Na ke len aksingoul limekosr in malem sac, sie pac kufwa ac fah orek ke lusen len itkosr. In len inge kewa, ma ac mongo uh pa bread wangin mwe pulol kac. ");
INSERT INTO kos_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Ke len se emeet lun kufwa se inge kowos fah tukeni in alu, ac tia oru kutena orekma. ");
INSERT INTO kos_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Oru sie mwe kisa firir nu sin LEUM GOD, su sie mwe kisa mongo ma orek ke e. Kisakin cow mukul fusr lukwa, sheep mukul soko, ac sheep fusr mukul itkosr, yac sie matwa — nufonna in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Mwe kisa wheat in orek ke flao karkar ke oil in olive: paun onkosr in wi kais soko cow mukul, paun akosr in wi sheep mukul soko, ");
INSERT INTO kos_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ac paun luo in wi kais soko sheep fusr. ");
INSERT INTO kos_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Kisakin pac soko nani mukul in mwe kisa ke ma koluk, ac in ouiya se inge kom fah oru alu in aknasnas ke mwet uh. ");
INSERT INTO kos_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Oru ma inge in weang mwe kisa firir ma orek ke lotutang nukewa. ");
INSERT INTO kos_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","In lumah sacna, ke len itkosr kowos in kisakin mwe kisa mongo ma orek ke e, su fohlo uh akinsewowoye LEUM GOD. Oru ma inge in weang mwe kisa firir ke len nukewa, ac mwe kisa wain. ");
INSERT INTO kos_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Ke len se akitkosr kowos in tukeni alu, ac tia oru kutena orekma. ");
INSERT INTO kos_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Ke len in kisakin fahko se meet lun kosrani, ke kowos sang mwe kisa ke wheat sasu nu sin LEUM GOD, kowos in tukeni in alu, ac tia oru kutena orekma. ");
INSERT INTO kos_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Oru sie mwe kisa firir, su fohlo uh mwe akinsewowoye LEUM GOD: lukwa cow fusr mukul, soko sheep mukul, ac itkosr sheep fusr mukul yac se matwa — kewana in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Akfalye srikasrak ke mwe kisa wheat, ma orek ke flao karyak ke oil in olive: paun onkosr in wi kais soko cow mukul, paun akosr in wi sheep mukul soko ah, ");
INSERT INTO kos_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ac paun luo in wi kais soko sheep fusr. ");
INSERT INTO kos_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Kisakin pac soko nani mukul in mwe kisa ke ma koluk, ac in ouiya se inge kom fah oru alu in aknasnas ke mwet uh. ");
INSERT INTO kos_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Kisakin ma inge oayapa mwe kisa wain, in weang mwe kisa firir lun len nukewa ac mwe kisa wheat. ");
INSERT INTO kos_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Ke len se emeet in malem se akitkosr, kowos fah tukeni in alu, ac tia oru kutena orekma. Ke len sac kowos in uk mwe ukuk uh. ");
INSERT INTO kos_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Kisakin sie mwe kisa firir nu sin LEUM GOD, su fohlo uh mwe akinsewowoyal: soko cow fusr mukul, soko sheep mukul, ac itkosr sheep fusr mukul yac se matwa — kewana in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Akfalye srikasrak ke mwe kisa wheat, ma orek ke flao karyak ke oil in olive: paun onkosr in wi cow mukul soko, paun akosr in wi sheep mukul soko ah, ");
INSERT INTO kos_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ac paun luo in wi kais soko sheep fusr. ");
INSERT INTO kos_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Kisakin pac soko nani mukul in mwe kisa ke ma koluk, ac in ouiya se inge kom fah oru alu in aknasnas ke mwet uh. ");
INSERT INTO kos_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Kisakin ma inge in weang mwe kisa firir lun len se oemeet lun malem, wi mwe kisa wheat nu kac, oayapa mwe kisa firir ke len nukewa wi mwe kisa wheat ac wain nu kac. Foulin mwe kisa mongo inge ma orek ke e uh akinsewowoye LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Ke len se aksingoul in malem akitkosr uh, kowos in tukeni ac alu. Kowos in tia kang kutena mwe mongo, ku oru kutena orekma. ");
INSERT INTO kos_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Kisakin sie mwe kisa firir nu sin LEUM GOD, su fohlo uh mwe akinsewowoyal: soko cow fusr mukul, soko sheep mukul, ac itkosr sheep fusr mukul yac se matwa — kewana in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Akfalye srikasrak ke mwe kisa wheat, ma orek ke flao karyak ke oil in olive: paun onkosr in wi cow mukul soko, paun akosr in wi sheep mukul soko ah, ");
INSERT INTO kos_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ac paun luo in wi kais soko sheep fusr. ");
INSERT INTO kos_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Kisakin pac soko nani mukul in mwe kisa ke ma koluk, in weang pacna nani soko ma kisakinyuk ke alu in aknasnas ke mwet uh, oayapa mwe kisa firir ke len nukewa wi mwe kisa wheat ac wain nu kac. ");
INSERT INTO kos_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Ke len se aksingoul limekosr in malem akitkosr uh, kowos in tukeni ac alu. Oru sie kufwa in akfulatye LEUM GOD ke lusen len itkosr, ac tia oru kutena orekma. ");
INSERT INTO kos_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Ke len se emeet, oru sie mwe kisa mongo ma orek ke e nu sin LEUM GOD, su fohlo uh mwe akinsewowoyal: cow mukul fusr singoul tolkwe, sheep mukul lukwa, ac sheep fusr mukul singoul akosr yac se matwa — kewana ma inge in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Akfalye srikasrak ke mwe kisa wheat, ma orek ke flao karyak ke oil in olive: paun onkosr in wi kais soko cow mukul, paun akosr in wi kais soko sheep mukul, ");
INSERT INTO kos_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ac paun luo in wi kais soko sheep fusr, wi mwe kisa wain ma oakwuk nu kac. ");
INSERT INTO kos_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Kisakin pac soko nani mukul in mwe kisa ke ma koluk. Oru ma inge in weang mwe kisa firir ke len nukewa wi mwe kisa wheat ac mwe kisa wain nu kac. ");
INSERT INTO kos_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Ke len se akluo, kisakin cow fusr mukul singoul lukwa, sheep mukul lukwa, ac sheep fusr mukul singoul akosr, yac se matwa. Ma inge nukewa in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Oru pac mwe kisa ke wheat ac mwe kisa wain ke kais soko cow mukul, sheep mukul, ac sheep fusr, fal nu ke pisalos, oana ma akkalemyeyuk. ");
INSERT INTO kos_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Oayapa soko nani mukul in mwe kisa ke ma koluk, oapana ma orek ke len se meet ah. ");
INSERT INTO kos_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Ke len se aktolu, kisakin cow fusr mukul singoul soko, sheep mukul lukwa, ac sheep fusr mukul singoul akosr yac se matwa. Ma inge nukewa in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Oru pac mwe kisa ke wheat ac mwe kisa wain ke kais soko cow mukul, sheep mukul, ac sheep fusr, fal nu ke pisalos, oana ma akkalemyeyuk. ");
INSERT INTO kos_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Oayapa soko nani mukul in mwe kisa ke ma koluk, oapana ma orek ke len se emeet ah. ");
INSERT INTO kos_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Ke len se akakosr, kisakin cow fusr mukul singoul, sheep mukul lukwa, ac sheep fusr mukul singoul akosr yac se matwa. Ma inge nukewa in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Oru pac mwe kisa ke wheat ac mwe kisa wain ke kais soko cow mukul, sheep mukul, ac sheep fusr, fal nu ke pisalos, oana ma akkalemyeyuk. ");
INSERT INTO kos_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Oayapa soko nani mukul in mwe kisa ke ma koluk, weang pacna kain kisa nukewa ma orek fahfahsru ke len se oemeet ah. ");
INSERT INTO kos_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Ke len se aklimekosr, kisakin cow fusr mukul eu, sheep mukul lukwa, ac sheep fusr mukul singoul akosr yac se matwa. Ma inge nukewa in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Oru pac mwe kisa ke wheat ac mwe kisa wain ke kais soko cow mukul, sheep mukul, ac sheep fusr, fal nu ke pisalos, oana ma akkalemyeyuk. ");
INSERT INTO kos_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Oayapa soko nani mukul in mwe kisa ke ma koluk, weang pacna kain kisa nukewa ma orek fahfahsru ke len se oemeet ah. ");
INSERT INTO kos_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Ke len se akonkosr, kisakin oalkosr cow fusr mukul, sheep mukul lukwa, ac sheep fusr mukul singoul akosr yac se matwa. Ma inge nukewa in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Oru pac mwe kisa ke wheat ac mwe kisa wain ke kais soko cow mukul, sheep mukul, ac sheep fusr, fal nu ke pisalos, oana ma akkalemyeyuk. ");
INSERT INTO kos_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Oayapa soko nani mukul in mwe kisa ke ma koluk, weang pacna kain kisa nukewa ma orek fahfahsru ke len se oemeet ah. ");
INSERT INTO kos_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Ke len se akitkosr, kisakin itkosr cow fusr mukul, sheep mukul lukwa, sheep fusr mukul singoul akosr yac se matwa. Ma inge nukmewa in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Oru pac mwe kisa ke wheat ac mwe kisa wain ke kais soko cow mukul, sheep mukul, ac sheep fusr, fal nu ke pisalos, oana ma akkalemyeyuk. ");
INSERT INTO kos_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Oayapa soko nani mukul in mwe kisa ke ma koluk, weang pacna kain kisa nukewa ma orek fahfahsru ke len se oemeet ah. ");
INSERT INTO kos_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Ke len se akoalkosr, kowos in tukeni ac alu, ac tia oru kutena orekma. ");
INSERT INTO kos_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Oru sie kisa firir tuh in sie mwe kisa mongo orek ke e nu sin LEUM GOD, su fohlo uh mwe akinsewowoyal: soko cow fusr mukul, soko sheep mukul, ac sheep fusr mukul itkosr yac se matwa. Ma inge nukewa in wangin kutena ma koluk ke mano. ");
INSERT INTO kos_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Oru pac mwe kisa ke wheat ac mwe kisa wain ke kais soko cow mukul, sheep mukul, ac sheep fusr, fal nu ke pisalos, oana ma akkalemyeyuk. ");
INSERT INTO kos_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Oayapa soko nani mukul in mwe kisa ke ma koluk, weang pacna kain kisa nukewa ma orek fahfahsru ke len se oemeet ah. ");
INSERT INTO kos_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Pa inge oakwuk nu ke mwe kisa firir, mwe kisa wheat, mwe kisa wain, ac kisa in akinsewowo ma kowos ac oru nu sin LEUM GOD ke pacl in kufwa ma oakwuki nu suwos. Ma inge in weang mwe sang kowos sang in akfalye wuleang uh, ac mwe sang ke engan na lun kais sie mwet in sang. ");
INSERT INTO kos_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Ouinge Moses el fahk nu sin mwet Israel ma nukewa ma LEUM GOD El sapkin nu sel. ");
INSERT INTO kos_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","LEUM GOD El fahk nu sel Moses elan sang oakwuk inge nu sin mwet kol lun sruf lun Israel. ");
INSERT INTO kos_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Ke sie mukul el oru sie wuleang in sang kutena ma nu sin LEUM GOD, ku orek fulahk mu el ac tui liki kutena ma, elan tia kunausla wulela lal, a elan oru ma nukewa ma el fahk mu el ac oru. ");
INSERT INTO kos_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Ke sie mutan fusr su srakna muta in lohm sin papa tumal, el orala sie wuleang in sang sie ma nu sin LEUM GOD, ku wuleang in tui liki sie ma, ");
INSERT INTO kos_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","el enenu in oru ma nukewa ma el wulela kac ku fulahk kac, sayen papa tumal fin srukak kas in lain ke el lohng kac. ");
INSERT INTO kos_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Papa tumal fin tia insese nu ke wuleang lun acn natul ke el lohng kac, na mutan sac tia enenu in akfalye wuleang lal. LEUM GOD El fah nunak munas nu sel, ke sripen papa tumal tia lela elan oru. ");
INSERT INTO kos_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Sie mutan lolap fin orala sie wuleang ke nunak na pwaye lal, ku el finne orala ke el tia nunkala wo, oayapa el fin wuleang in tui liki sie ma, na toko el payukyak, ");
INSERT INTO kos_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","el enenu in orala ma el wulela ku fulahk kac, sayen mukul tumal fin srukak kas in lain ke el lohng kac. ");
INSERT INTO kos_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Mukul tumal fin lohng kac ac tia insese nu ke wulela sac, na mutan sac tia enenu in akfalye. LEUM GOD El ac fah nunak munas nu sin mutan sac. ");
INSERT INTO kos_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Sie katinmas ku sie mutan su mukul tumal el sisella, el enenu in liyaung wuleang nukewa el orala, oayapa ma nukewa ma el wulela mu el ac tui kac. ");
INSERT INTO kos_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Sie mutan payuk fin orala sie wuleang, ku fulahk ke kutena ma in tui kac, ");
INSERT INTO kos_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","na el enenu in oru ma nukewa el wulela kac, mukul tumal fin lohngak ac tia fahk kas in lain nu sel. ");
INSERT INTO kos_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Tusruktu mukul tumal fin lohng ac sap elan tia akfalye, na mutan kial uh fah tia enenu in akfalye wuleang lal. LEUM GOD El ac nunak munas nu sel, mweyen mukul tumal ah kutongilya elan tia akfalye wuleang sac. ");
INSERT INTO kos_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Oasr suwohs lun mukul tumal in akkeye, ku tia akkeye, kutena wuleang ma mutan kial uh orala. ");
INSERT INTO kos_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Tusruktu ke len se tukun el lohng ke wuleang sac, a wangin kas in lain lal nu kac, na mutan sac enenu in orala ma nukewa ma el wulela kac. Mukul tumal el akkeye kas in wulela lun mutan kial ke el tia srukak kas in kutong ke len se el lohng kac. ");
INSERT INTO kos_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Tusruktu el fin lain wuleang inge tukun len se el lohng kac, na el pa ac eis mwata ke sripen wuleang sac tia akfalyeyuk. ");
INSERT INTO kos_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Pa inge ma LEUM GOD El sapkin nu sel Moses ke kas in wuleang ma sie mutan lolap el oru ke el srakna muta in lohm sin papa tumal, ku ma sie mutan payuk el oru ke el muta yurin mukul tumal. ");
INSERT INTO kos_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Folokin nu sin mwet Midian ke ma elos tuh oru nu sin mwet Israel. Toko, na kom fah misa.” ");
INSERT INTO kos_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Ouinge Moses el fahk nu sin mwet uh, “Akola nu ke mweun, tuh kowos fah ku in tuyak lain mwet Midian ac kalyaelos ke sripen ma elos oru nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Kowos in supwala kais sie tausin mwet mweun ke kais sie sruf lun Israel.” ");
INSERT INTO kos_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ouinge sie tausin mwet solla liki kais sie sruf, orala pisa lulap se ke mwet singoul luo tausin su akola nu ke mweun. ");
INSERT INTO kos_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moses el supwalosla nu ke mweun ye koko lal Phinehas, wen natul Eleazar mwet tol, su us kufwa ke lohm nuknuk mutal ac mwe ukuk in sulkakin pacl in mweun. ");
INSERT INTO kos_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Elos mutawauk mweuni mwet Midian oana LEUM GOD El sapkin nu sel Moses, ac onela mukul nukewa, ");
INSERT INTO kos_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","weang tokosra limekosr lun Midian inge: Evi, Rekem, Zur, Hur, ac Reba. Elos oayapa unilya Balaam wen natul Beor. ");
INSERT INTO kos_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Mwet Israel elos sruokya mutan Midian ac tulik natulos, oayapa cow ac un sheep ac nani natulos, ac usla ma lalos nukewa. ");
INSERT INTO kos_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Elos esukak siti nukewa selos, ac nien aktuktuk selos. ");
INSERT INTO kos_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Elos eis ma wap nukewa, wi mwet sruoh ac kosro uh, ");
INSERT INTO kos_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ac use ma inge nu yorol Moses ac Eleazar ac mwet Israel nukewa su muta in nien aktuktuk se in acn mwesis lun Moab, kutulap in Infacl Jordan, tulanang Jericho. ");
INSERT INTO kos_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moses, Eleazar, ac mwet kol nukewa saya lun mwet Israel elos illa liki nien aktuktuk in osun nu sin mwet mweun. ");
INSERT INTO kos_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moses el kasrkusrakak sin mwet kol lun un mwet mweun, captain lun tausin ac captain lun foko, su foloko liki mweun uh. ");
INSERT INTO kos_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","El siyuk selos, “Efu kowos ku lela mutan inge nukewa in moul na? ");
INSERT INTO kos_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Esam lah mutan inge pa tuh ukwe na ma Balaam el fahk nu selos, na in acn Peor elos kolla mwet uh in tia pwaye nu sin LEUM GOD. Pa sis mwe lokoalok upa sac tuh sikyak nu sin mwet lun God. ");
INSERT INTO kos_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Ke ma inge, uniya tulik mukul nukewa, oayapa mutan nukewa su etu mukul tari, ");
INSERT INTO kos_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","tusruktu karinganang nu suwos tulik mutan nukewa ac mutan su soenna etu mukul. ");
INSERT INTO kos_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Inge kowos nukewa su uniya kutena mwet, ku pusralla kutena mano misa, enenu in muta likin nien aktuktuk uh ke len itkosr. Ke len se aktolu ac len se akitkosr, kowos in aknasnasye kowos sifacna ac mutan ma sruhu ke mweun. ");
INSERT INTO kos_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Kowos oayapa enenu in aknasnasye nuknuk lowos nukewa ac ma nukewa ma orekla ke kulun kosro, unen nani, ku ma orekla ke sak.” ");
INSERT INTO kos_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eleazar mwet tol el fahk nu sin mukul nukewa su foloko liki mweun, “Pa inge ma LEUM GOD El sapkin nu sel Moses: ");
INSERT INTO kos_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Gold, silver, bronze, osra, tin, ac lead — ");
INSERT INTO kos_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ma nukewa ma tia motok e, ac fah aknasnasyeyuk in e uh. Tusruktu enenu pac in aknasnasyeyuk ke kof in aknasnas. Ac kutena ma su motok e, ac fah isosyang nu in kof sac. ");
INSERT INTO kos_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ke len se akitkosr kowos fah ohlla nuknuk lowos, na kowos fah nasnasla, ac kowos fah ku in ilyak nu in nien aktuktuk.” ");
INSERT INTO kos_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Kom ac Eleazar, wi mwet kol saya lun mwet Israel, in oakla ma nukewa ma utuku ke mweun, wi mwet sruoh ac un kosro. ");
INSERT INTO kos_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Kitalik ma utukeni nu ke ip luo, na sang tafu lun mwet mweun, ac tafu lun mwet Israel ngia. ");
INSERT INTO kos_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Ke ip lun mwet mweun an, kom fah srela sie liki inmasrlon kais lumfoko nukewa tuh in mwe takma nu sin LEUM GOD— ke mwet sruoh, ac ke un cow, donkey, sheep ac nani. ");
INSERT INTO kos_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Sang ma ingan nu sel Eleazar mwet tol, tuh in sie mwe sang mutal nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Ke ip lun mwet nukewa saya, kom fah srela sie liki kais lumngaul nukewa ke mwet sruoh, ac oru oapana nu ke un cow, donkey, sheep, ac nani. Sang ma inge nu sin mwet Levi su liyaung Lohm Nuknuk Mutal sin LEUM GOD.” ");
INSERT INTO kos_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moses ac Eleazar oru oana ma LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Pisen ma wap nukewa ma un mwet mweun uh sruokya oasr ke onfoko itngoul limekosr tausin sheep ac nani, ");
INSERT INTO kos_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","itngoul luo tausin cow, ");
INSERT INTO kos_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","onngoul sie tausin donkey, ");
INSERT INTO kos_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ac tolngoul luo tausin mutan su tia etu mukul. ");
INSERT INTO kos_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ip lun mwet mweun uh, oasr ke tolfoko tolngoul itkosr tausin lumfoko sheep ac nani, ");
INSERT INTO kos_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ac ip kac ma itukyang nu sin LEUM GOD oasr ke onfoko itngoul limekosr sheep ac nani. ");
INSERT INTO kos_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Pisen cow uh oasr ke tausin tolngoul onkosr, ac ip lun LEUM GOD kac oasr ke itngoul luo. ");
INSERT INTO kos_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Pisen donkey uh oasr ke tolngoul tausin lumfoko, ac ip lun LEUM GOD kac oasr onngoul soko. ");
INSERT INTO kos_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Pisen mutan fusr uh oasr ke tausin singoul onkosr, ac ip lun LEUM GOD kac uh pa mutan tolngoul luo. ");
INSERT INTO kos_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moses el sang nu sel Eleazar takma inge, su sie mwe sang mutal nu sin LEUM GOD, oana ke LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ac ip se lun mwet Israel, ma Moses el srela liki ma lun un mwet mweun uh, ");
INSERT INTO kos_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","oasr tolfoko tolngoul itkosr tausin lumfoko sheep ac nani, ");
INSERT INTO kos_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","tolngoul onkosr tausin cow, ");
INSERT INTO kos_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","tolngoul tausin lumfoko donkey, ");
INSERT INTO kos_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ac singoul onkosr tausin mutan fusr. ");
INSERT INTO kos_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Liki ip lun mwet Israel, Moses el eisla kais sie liki lumngaul nukewa, ke mwet sruoh ac ke kosro uh, ac el sang ma inge nu sin mwet Levi su karingin Lohm Nuknuk Mutal sin LEUM GOD, oana LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Toko mwet kol su karingin un mwet mweun elos som nu yorol Moses ");
INSERT INTO kos_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ac fahk, “Leum se, kut oakla mwet mweun lasr, ac wangin sie selos tuhlac. ");
INSERT INTO kos_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ke ma inge kut use mwe yun gold, mwe lohlpo, sein gold, ring, yaring, ah in walwal, ma kais sie sesr sifani. Kut sang ma inge nu sin LEUM GOD tuh in mwe srui lasr ke El molikutla.” ");
INSERT INTO kos_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moses ac Eleazar eis mwe naweyuk inge nukewa ma orekla ke gold. ");
INSERT INTO kos_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Toasriyen ma inge nukewa ma mwetkol lun mwet mweun orani, alukela paun angfoko. ");
INSERT INTO kos_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Elos su tia oaoa in mwet kol lun mwet mweun elos sruokya na ma wap lalos uh. ");
INSERT INTO kos_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Ouinge Moses ac Eleazar usla gold uh nu in Lohm Nuknuk Mutal, tuh LEUM GOD Elan loango mwet Israel. ");
INSERT INTO kos_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Arulana pus cow nutin sruf lal Reuben ac Gad. Na ke elos liye lah wo acn Jazer ac Gilead nu ke tohf cow ");
INSERT INTO kos_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","elos utyak nu yorol Moses, Eleazar, ac mwet kol saya lun mwet Israel ac fahk, ");
INSERT INTO kos_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Acn Ataroth, Dibon, Jazer, Nimrah, Heshbon, Elealeh, Sibmah, Nebo, ac Beon ");
INSERT INTO kos_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","LEUM GOD El tuh kasrekut eisla. Acn inge wona nu ke tohf kosro, ac arulana pus kosro natusr uh. ");
INSERT INTO kos_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Nunak munas ase acn inge in ma lasr, ac tia sap kut in alukela Infacl Jordan in muta layen roto.” ");
INSERT INTO kos_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Tusruktu Moses el topuk ac fahk, “Ya ma liwos ac som mweun, a kowos ac mutana inge? ");
INSERT INTO kos_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Efu kowos ku srike in akmunasye nunkun mwet Israel tuh elos in tia lungse fahsr aliki Infacl Jordan nu in facl se su LEUM GOD El sang nu selos? ");
INSERT INTO kos_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Pa ingan ma papa tomowos ah tuh oru ke nga supwalosla liki Kadesh Barnea in kalngeyuk nu in acn sac. ");
INSERT INTO kos_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Elos som nwe sun Infahlfal Eshcol ac liye facl sac, tusruktu ke elos foloko, elos akmunasye mwet uh in tia utyak nu in facl se su LEUM GOD El sang nu selos. ");
INSERT INTO kos_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","LEUM GOD El tuh kasrkusrakak ke len sac, ac orala wulela se inge: ");
INSERT INTO kos_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Nga fulahk lah, mweyen elos tia inse pwayena nu sik, wangin sie sin mwet su matwa yac longoulyak su illa liki acn Egypt fah utyak nu in facl se su nga wuleang kac nu sel Abraham, Isaac ac Jacob.’ ");
INSERT INTO kos_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Kas inge ma nu sin mwet nukewa, sayal Caleb wen natul Jephunneh mwet Ken, ac Joshua wen natul Nun. Eltal mukena inse pwayena nu sin LEUM GOD. ");
INSERT INTO kos_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","LEUM GOD El kasrkusrakak sin mwet uh ac oru elos in forfor yen mwesis ke yac angngaul, nwe ke na fwil nufon se ma oru ma koluk ye mutal ah misa. ");
INSERT INTO kos_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Ac inge kowos sie fwil sasu su aolla papa matu tomowos in oru ma koluk, ac akyokye kasrkusrak lun LEUM GOD nu fin Israel. ");
INSERT INTO kos_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Mwet Reuben ac Gad, kowos fin forla lukel inge, El ac sifilpa fahsr liki mwet inge nukewa yen mwesis uh, na mwatan ma koluk ma ac sikyak inge ac fah oan fowos.” ");
INSERT INTO kos_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Na elos kalukyang nu yorol Moses ac fahk, “Kut siyuk tuh kut in etoak kutu kalkal eot nu ke sheep natusr uh, ac musai kutu siti ke pot ku nu sin sou lasr uh. ");
INSERT INTO kos_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Na kut ac fah akola in wi mwet Israel wiasr som nu ke mweun, ac kut fah fahsr meet in kololos nwe ke kut oakelosi fin acn su ac fah ma lalos. In pacl ingan, sou lasr uh fah muta inge in siti kalkalyak ke pot ku, ac tia sensen ke mwet in facl se inge. ");
INSERT INTO kos_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Kut fah tia foloko nu yen sesr nwe ke mwet Israel nukewa elos oakwuki in acn ma itukyang nu selos. ");
INSERT INTO kos_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Kut fah tia eis kutena acn sesr layen roto in Infacl Jordan, mweyen kut eis tari ip lasr inge layen kutulap in Infacl Jordan.” ");
INSERT INTO kos_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moses el topuk, “Fin pwayena ma kowos fahk, na inge ye mutun LEUM GOD, kowos akola in som nu ke mweun. ");
INSERT INTO kos_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Mwet mweun lowos nukewa in fahsr sasla Infacl Jordan, na ye koko lun LEUM GOD elos in mweun lain mwet lokoalok lasr nwe ke LEUM GOD El kutangulosla ");
INSERT INTO kos_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ac eis acn sac. Toko kowos ac ku in foloko, mweyen kowos akfalyela tari ma kunowos nu sin LEUM GOD ac nu sin mwet Israel wiowos. Na LEUM GOD El fah akkalemye lah acn se inge kutulap in Infacl Jordan ma lowos. ");
INSERT INTO kos_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Tusruktu kowos fin tia oru oana ma kowos wulela inge, nga akkalemye nu suwos lah kowos orekma koluk lain LEUM GOD. Kowos in arulana etu lah ac fah kaiyuk kowos ke ma koluk lowos. ");
INSERT INTO kos_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Ke ma inge, musai siti nu sin sou lowos ac kalkal nu ke sheep ac nani nutuwos an, tusruktu kowos in oru na ma kowos wulela kac!” ");
INSERT INTO kos_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Na mukul ke sruf lal Gad ac Reuben elos fahk, “Moses, kut ac oru oana kom sapkin. ");
INSERT INTO kos_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Mutan kiasr, tulik natusr, cow natusr, ac sheep natusr fah mutana inge ke siti in acn Gilead. ");
INSERT INTO kos_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","A kut nukewa ac akola in som nu ke mweun ye kolyuk lun LEUM GOD. Kut ac fahla alukela Infacl Jordan ac mweun, oana ke kom fahk.” ");
INSERT INTO kos_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Ouinge Moses el sang ma sap inge nu sel Eleazar, Joshua, ac mwet kol saya lun mwet Israel: ");
INSERT INTO kos_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Mukul ke sruf lun Gad ac Reuben fin fahsr aliki Infacl Jordan ac akola nu ke mweun ke sap lun LEUM GOD, ac kowos fin eisla acn sac ke sripen kasru lalos, na kowos fah sang nu selos acn Gilead tuh in ma lalos. ");
INSERT INTO kos_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Tusruktu elos fin tia fahla alukela Infacl Jordan ac wi kowos mweun, elos ac fah eis na acn selos inmasrlowos fin acn Canaan.” ");
INSERT INTO kos_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Mukul ke sruf lun Gad ac Reuben elos topuk, “Kut ac oru oana ma LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Ye kolyuk lal, kut fah fahla aliki nu in facl Canaan ac mweun, tuh acn inge kutulap in Infacl Jordan in ma lasr.” ");
INSERT INTO kos_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Ouinge Moses el oakiya acn nukewa ke facl sel Tokosra Sihon lun acn Amor, ac facl sel Tokosra Og lun acn Bashan, weang siti srisrik ac acn nukewa ma raunela, tuh in ma lun sruf lun Gad ac Reuben ac tafu sruf lal Manasseh. ");
INSERT INTO kos_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Sruf lun Gad sifil musaela pot ku in siti Dibon, Ataroth, Aroer, ");
INSERT INTO kos_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth, Shophan, Jazer, Jogbehah, ");
INSERT INTO kos_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth Nimrah, ac Beth Haran. ");
INSERT INTO kos_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Sruf lun Reuben sifil musaela Heshbon, Elealeh, Kiriathaim, ");
INSERT INTO kos_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal Meon (ayaolla inen acn se inge), ac Sibmah. Elos sang ine sasu nu ke siti ma elos sifil musaela. ");
INSERT INTO kos_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Sou lulap lal Machir, wen natul Manasseh, mweun ac eisla acn Gilead, ac elos lusla mwet Amor su muta we. ");
INSERT INTO kos_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Ke ma inge Moses el sang acn Gilead nu sin sou lal Machir, ac elos muta we. ");
INSERT INTO kos_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair, ke sruf lal Manasseh, el mweun ac sruokya kutu siti srisrik we, ac sang ine sasu se inge nu kac: “Siti Srisrik lun Jair.” ");
INSERT INTO kos_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobah el mweun ac sruokya acn Kenath ac siti srisrik raunela, ac sang inel sifacna nu ke acn inge: Nobah. ");
INSERT INTO kos_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ma simla inge fahkak inen acn ma mwet Israel aktuktuk we tukun elos fahsr liki acn Egypt ke sruf lalos ye kolyuk lal Moses ac Aaron. ");
INSERT INTO kos_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moses el simusla inen kais sie acn ma elos tulokunak lohm nuknuk selos we, oana ma LEUM GOD El sapkin. ");
INSERT INTO kos_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Mwet Israel elos som liki Egypt ke len aksingoul limekosr in malem se meet in yac, len se tukun Kufwen Alukela se oemeet. Ye karinginyuk lun LEUM GOD elos illa liki siti Rameses ye mutun mwet Egypt, ");
INSERT INTO kos_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","su pikin wounse mukul natulos ma LEUM GOD El uniya. LEUM GOD El oru ouinge in akkalemye lah El arulana ku liki god lun acn Egypt. ");
INSERT INTO kos_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Mwet Israel som liki acn Rameses ac tulokunak nien aktuktuk lalos Sukkoth. ");
INSERT INTO kos_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Nien aktuktuk lalos akluo pa in acn Etham sisken yen mwesis. ");
INSERT INTO kos_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Liki acn sac elos folokla nu Pi Hahiroth, kutulap in Baal Zephon, ac aktuktuk apkuran nu Migdol. ");
INSERT INTO kos_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Elos mukuila liki Pi Hahiroth ac fahsr sasla in Meoa Srusra nu in acn mwesis lun Shur. Tukun fahsr ke len tolu elos aktuktuk in acn Marah. ");
INSERT INTO kos_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Liki acn we elos som nu Elim ac aktuktuk we, mweyen oasr unon in kof singoul luo ac sak palm itngoul we. ");
INSERT INTO kos_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Elos fahsr liki Elim ac aktuktuk apkuran nu ke Meoa Srusra. ");
INSERT INTO kos_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Acn in aktuktuk se lalos toko pa yen mwesis lun Sin. ");
INSERT INTO kos_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Na toko elos aktuktuk Dophkah, ");
INSERT INTO kos_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ac toko in acn Alush, ");
INSERT INTO kos_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ac toko in acn Rephidim, acn se ma wangin kof elos in nim we. ");
INSERT INTO kos_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Elos mukuiyak liki acn Rephidim ac som aktuktuk in acn mwesis lun Sinai. ");
INSERT INTO kos_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Elos som liki acn we nu in acn Kibroth Hattaavah. ");
INSERT INTO kos_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Tok elos som ac aktuktuk in kais sie acn inge: Hazeroth, ");
INSERT INTO kos_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Rithmah, ");
INSERT INTO kos_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Rimmon Perez, ");
INSERT INTO kos_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Libnah, ");
INSERT INTO kos_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Rissah, ");
INSERT INTO kos_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Kehelathah, ");
INSERT INTO kos_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Eol Shepher, ");
INSERT INTO kos_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Haradah, ");
INSERT INTO kos_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Makheloth, ");
INSERT INTO kos_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Tahath, ");
INSERT INTO kos_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Terah, ");
INSERT INTO kos_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Mithkah, ");
INSERT INTO kos_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Hashmonah, ");
INSERT INTO kos_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Moseroth, ");
INSERT INTO kos_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Bene Jaakan, ");
INSERT INTO kos_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Hor Haggidgad, ");
INSERT INTO kos_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Jotbathah, ");
INSERT INTO kos_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Abronah, ");
INSERT INTO kos_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Ezion Geber, ");
INSERT INTO kos_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","acn mwesis lun Zin (pa ingan acn Kadesh), ");
INSERT INTO kos_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ac Eol Hor, sisken na facl Edom. ");
INSERT INTO kos_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Aaron mwet tol el fanyak nu fin mangon Eol Hor, oana ke LEUM GOD El sapkin nu sel, ac el misa we ke len se oemeet in malem se aklimekosr ke yac akangngaul tukun mwet Israel elos illa liki acn Egypt. ");
INSERT INTO kos_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron el yac siofok longoul tolu ke el misa Fineol Hor. ");
INSERT INTO kos_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Tokosra lun Arad, su oan layen eir in acn Canaan, el lohngak lah mwet Israel apkuranme. ");
INSERT INTO kos_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Mwet Israel elos mukuiyak liki Eol Hor ac aktuktuk Zalmonah. ");
INSERT INTO kos_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Na toko elos aktuktuk ke kais sie acn inge: Punon, ");
INSERT INTO kos_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Oboth, ");
INSERT INTO kos_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","mahnum Abarim in acn Moab, ");
INSERT INTO kos_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Dibon Gad, ");
INSERT INTO kos_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Almon Diblathaim, ");
INSERT INTO kos_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Fineol Abarim, apkuran nu Fineol Nebo, ");
INSERT INTO kos_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ac in acn tupasrpasr Moab su oan layen kutulap in Infacl Jordan tulanang Jericho, ");
INSERT INTO kos_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","inmasrlon Beth Jeshimoth na nwe infahlfal Acacia in acn mwesis lun Moab. ");
INSERT INTO kos_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","In acn mwesis lun Moab sisken Infacl Jordan tulanang acn Jericho, LEUM GOD El kaskas nu sel Moses ac fahk, ");
INSERT INTO kos_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Kaskas nu sin mwet Israel, ac fahk nu selos: Pacl se kowos fahsr alukela Infacl Jordan ac utyak nu in facl Canaan, ");
INSERT INTO kos_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","kowos in lusak mwet nukewa we. Kunausla ma sruloala lalos nukewa — ma orekla ke eot ac ma orekla ke osra — wi acn in alu lalos nukewa. ");
INSERT INTO kos_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Sruokya facl sac ac oakwuki we, mweyen nga sot acn we tuh in ma suwos. ");
INSERT INTO kos_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Kitalik acn we ke fa, nu sin sruf ac sou lowos nukewa. Sang ipin acn ma yohk nu sin sruf ma yohk, ac ipin acn ma srik nu sin sruf ma srik. ");
INSERT INTO kos_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Kowos fin tia lusla mwet nukewa su muta we, na mwet lula uh ac fah arulana aklokoalokye kowos, oana kutkut in atronmotowos, ku oana sak ma oasr otoh kac inpupowos, na tok elos ac foroht lain kowos. ");
INSERT INTO kos_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Kowos fin tia luselosla, na nga ac kunauskowosla oana ke nga akoo in kunauselosla.” ");
INSERT INTO kos_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","LEUM GOD El kaskas nu sel Moses ac fahk, ");
INSERT INTO kos_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Sang oakwuk inge nu sin mwet Israel: Ke kowos ac utyak nu Canaan, facl se ma nga asot nu suwos, pa inge masrol nu ke acn lowos. ");
INSERT INTO kos_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Masrol ke layen eir ac som nwe ke yen mwesis Zin wi na masrol nu Edom. Siska kutulap pa mutawauk e ke layen eir ke Meoa Misa. ");
INSERT INTO kos_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Na ac fah kuhfla nu eir nu ke Innek In Utyak Nu Akrabbim, ac som sasla acn Zin na nwe ke sun eir in acn Kadesh Barnea. Na ac fah kuhfwak nu roto epang nu Hazar Addar ac fahla nwe Azmon, ");
INSERT INTO kos_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","yen se ma ac kuhfla nu infahlfal nu ke masrol lun Egypt, ac safla ke Meoa Mediterranean. ");
INSERT INTO kos_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“Masrol layen nu roto pa Meoa Mediterranean. ");
INSERT INTO kos_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“Masrol layen nu epang uh ac fah suwosme Meoa Mediterranean nwe Fineol Hor ");
INSERT INTO kos_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ac ut we lac ke Innek In Utyak Nu Hamath, na sifil fahla nwe Zedad ");
INSERT INTO kos_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ac nu Ziphron, na fahla safla ke acn Hazar Enan. ");
INSERT INTO kos_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“Masrol layen nu kutulap ac fah mutawauk Hazar Enan fahla nwe Shepham. ");
INSERT INTO kos_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Na ac fah oatui nu eir som nwe Harbel, kutulap in acn Ain, ac suwoslana nu infulan eol kutulap in Lulu Galilee, ");
INSERT INTO kos_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","na fahla eir lac ke Infacl Jordan nwe ke Meoa Misa. “Pa inge masrol akosr lun acn suwos uh.” ");
INSERT INTO kos_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Na Moses el fahk nu sin mwet Israel, “Pa inge facl se su kowos ac eis ke susfa, ma LEUM GOD El sang nu sin sruf eu tafu lun Israel. ");
INSERT INTO kos_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Sruf lal Reuben ac sruf lal Gad ac tafu sruf lal Manasseh eis tari acn selos, kitakatelik fal nu ke lupan sou lalos, ");
INSERT INTO kos_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","layen kutulap in Infacl Jordan, tulanang Jericho.” ");
INSERT INTO kos_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Eleazar mwet to, ac Joshua wen natul Nun, fah kitalik acn uh nu sin mwet uh. ");
INSERT INTO kos_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Eis pac kais sie mwet kol ke kais sie sruf in kasrelos kitalik.” ");
INSERT INTO kos_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","28","Pa inge mwet su LEUM GOD El sulela: Sruf Mwet Kol Judah Caleb, wen natul Jephunneh Simeon Shelumiel, wen natul Ammihud Benjamin Elidad, wen natul Chislon Dan Bukki, wen natul Jogli Manasseh Hanniel, wen natul Ephod Ephraim Kemuel, wen natul Shiphtan Zebulun Elizaphan, wen natul Parnach Issachar Paltiel, wen natul Azzan Asher Ahihud, wen natul Shelomi Naphtali Pedahel, wen natul Ammihud ");
INSERT INTO kos_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Pa inge mwet ma LEUM GOD El srisrngiya in kitalik acn nu sin mwet Israel in facl Canaan. ");
INSERT INTO kos_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","In acn mwesis lun Moab sisken Infacl Jordan tulanang acn Jericho, LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Fahk nu sin mwet Israel lah elos enenu in sang kutu siti in acn ma elos eis lalos nu sin mwet Levi tuh elos in muta we, wi pac acn tupasrpasr ma raunela ac yohk mah we. ");
INSERT INTO kos_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Siti inge ac fah ma lun mwet Levi, ac elos fah muta we. Acn ma yohk mah we inge ac fah nien tohf cow ac kain kosro nukewa natulos. ");
INSERT INTO kos_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Acn in tohf kosro uh ac mutawauk sisken pot lun siti uh fahla yact lumfoko ke siska akosr kewa. ");
INSERT INTO kos_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Na ac orala sie acn maspang ma srikasrak kac uh oasr ke sie tausin yact ke siska kewa, ac siti uh ac oan infulwa. ");
INSERT INTO kos_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Kom fah sang onkosr siti nu sin mwet Levi tuh in siti in molela, tuh sie mwet fin uniya sie pac mwet ke ongla ouiya, elan ku in kaing nu we. In weang siti inge, sang pac angngaul luo siti an nu selos, ");
INSERT INTO kos_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","wi acn tupasrpasr ac yohk mah we ma oan raunela. Siti angngaul oalkosr nufon fah ma lun mwet Levi. ");
INSERT INTO kos_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Pisen siti in acn lun kais sie sruf ma ac itukyang nu sin mwet Levi fah lumweyuk fal nu ke lupan acn lun sruf sac.” ");
INSERT INTO kos_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","LEUM GOD El fahk nu sel Moses, ");
INSERT INTO kos_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","elan fahk nu sin mwet Israel: “Pacl se kowos alukela infacl Jordan nu in acn Canaan, ");
INSERT INTO kos_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","kowos fah srela kutu siti uh in nien molela, ma sie mwet el ac ku in kaing nu we el fin uniya sie mwet ke el tia oru in oaya. ");
INSERT INTO kos_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Ke el muta in acn se inge, el ac tia sangeng sin sou lun mwet misa sac su suk in foloksak. Mwet se fin tukakyak ke akmas, fah tia anwuki meet liki nununkeyuk el ye mutun mwet uh. ");
INSERT INTO kos_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Sulela siti in molela onkosr: ");
INSERT INTO kos_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","tolu siti uh in oan kutulap in Infacl Jordan, ac tolu siti fin acn Canaan. ");
INSERT INTO kos_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Siti onkosr inge ac fah acn in wikla lun mwet Israel, oayapa mwetsac su mutangan aktuktuk yuruwos uh, ku mwetsac su ac muta inmasrlowos nwe tok. Kutena mwet su uniya mwet ke ongla ouiya, ac ku in kaing nu in sie sin siti inge. ");
INSERT INTO kos_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“Tusruktu sie mwet fin sringil sie mwet ke soko polo osra ac mwet sac misa, el mwet akmas. Sie mwet akmas enenu in anwuki. ");
INSERT INTO kos_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Ku kutena mwet su tukya sie mwet ke sie eot inpaol ac mwet sac misa, el mwet akmas. Sie mwet akmas enenu in anwuki. ");
INSERT INTO kos_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ku sie mwet su sringilya siena mwet ke soko mwe anwuk orekla ke sak, ac mwet sac misa, na el sie mwet akmas. Sie mwet akmas enenu in anwuki. ");
INSERT INTO kos_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Ma kunen sou se ma fototo emeet nu sin mwet misa sac, in uniya mwet akmas sac. El fin konalak, elan unilya. ");
INSERT INTO kos_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“Mwet se fin srunga sie mwet ac unilya ke sinukunulla nu ten, ku tungalilya, ");
INSERT INTO kos_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ku fiskilya, oasr mwatal ke akmas, ac el ac fah anwuki. Ma kunen sou se ma fototo emeet nu sin mwet misa sac, in uniya mwet akmas sac. El fin konalak, elan unilya. ");
INSERT INTO kos_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“Tusruktu fin pa mwet se el sinukunla sie mwet nu ten, ku tungalilya na el misa, a mwet se ma oru ah el tia srungal ku oru in oaya. ");
INSERT INTO kos_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","Ku fin pa mwet se el sis eot se tuh uniya mwet se su el tia liye, ac el tia pac mwet lokoalok lal uh, na fuka? ");
INSERT INTO kos_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Ke ac nununkeyuk lumah ouinge uh, na mwet uh in wi layen lun mwet se ma orala misa sac, ac tia wi sou lun mwet misa sac su suk in foloksak. ");
INSERT INTO kos_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Mwet uh in molela mwet se ma akmas liki sou lun mwet misa sac, ac elos fah folokunulla nu in siti in molela se ma el tuh kaingla nu we. El fah muta we nwe ke Mwet Tol Fulat se in pacl sac el misa. ");
INSERT INTO kos_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Mwet se ma akmas ah fin illa liki siti in molela se ma el kaing nu we, ");
INSERT INTO kos_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ac sou lun mwet misa sac fin konalak ac unilya, na foloksak se inge ac tia oaoa in akmas. ");
INSERT INTO kos_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Mwet se ma akmas el enenu in mutana in siti in molela nwe ke na Mwet Tol Fulat sac misa, na toko el fah ku in folokla nu in acn sel sifacna. ");
INSERT INTO kos_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Ma sap inge ma nu suwos ac fwilin tulik nutuwos yen nukewa kowos muta we. ");
INSERT INTO kos_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“Sie mwet fin tukakyak ke akmas, na enenu in oasr mwet loh luo ku pus liki, tuh in ku in koneyukyak lah oasr mwatal, ac fal elan misa. Mwet loh sefanna tiana fal in akpwayeye tukak lun akmas. ");
INSERT INTO kos_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Sie mwet akmas enenu in anwuki. El tia ku in kaingkunla mwe kai se inge el finne sang mani in moli. ");
INSERT INTO kos_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Mwet se fin kaingla nu in sie siti in molela, nikmet lela nu sel elan sang mani molel in folok nu acn sel meet liki Mwet Tol Fulat el misa. ");
INSERT INTO kos_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Kowos fin oru lumah se inge, kowos ac akfohkfokyela facl ma kowos muta we uh, mweyen akmas uh el akfohkfokyela acn. Mwet akmas sac fin tia misa, na wangin pac sie inkanek in aknasnasyela acn se ma sie mwet el anwuki we. ");
INSERT INTO kos_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Nikmet akfohkfokyela facl se ma kowos muta we uh, tuh nga LEUM GOD, ac nga muta inmasrlon mwet Israel.” ");
INSERT INTO kos_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Mwet nukewa su sifen sou ke sou lulap lun Gilead, wen natul Machir ac nutin natul Manasseh wen natul Joseph, elos som nu yorol Moses ac mwet kol saya. ");
INSERT INTO kos_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Elos fahk, “LEUM GOD El sap kom in kitalik facl se inge nu sin mwet Israel ke fa. El oayapa sapkin nu sum in sang acn lun Zelophehad, mwet wiasr, nu sin acn natul. ");
INSERT INTO kos_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Tusruktu, esam lah elos fin payukyak sin mukul in siena sruf, na acn lalos ac fah ma lac lun sruf sac, ac lupa nufon se ituku lasr inge ac srikeni. ");
INSERT INTO kos_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Ke Yac in Folokyang — pacl se ma acn nukewa ma tuh kukakinyukla ac enenu in sifilpa utukeni nu yurin mwet ma la meet ah — na mwe usru lun acn natul Zelophehad ac tuh weang acn lun sruf ma elos payuk nu se nwe tok, na ac fah wanginla liki acn lasr uh.” ");
INSERT INTO kos_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Ke ma inge Moses el fahk nu sin mwet Israel ma LEUM GOD El sapkin inge. El fahk, “Ma mwet in sruf lal Manasseh inge fahk uh pwaye. ");
INSERT INTO kos_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ouinge LEUM GOD El fahk mu acn natul Zelophehad elos sukosok in payuk sin kutena mwet elos lungse, tusruktu inmasrlon na mwet in sruf lalos sifacna. ");
INSERT INTO kos_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Acn sin mwet Israel nukewa ac fah karinginyuk tuh in oanna ke sruf lal. ");
INSERT INTO kos_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Mutan nukewa ma oasr mwe usru lal ke sie sruf lun Israel, enenu na in payuk sin sie mukul in sruf sacn. In ouiya se inge kais sie mwet Israel fah usrui acn lun papa matu tumal. ");
INSERT INTO kos_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Na acn uh ac tia som liki sie sruf nu ke sie pacna sruf. Kais sie sruf ac fah sruokyana acn lal uh.” ");
INSERT INTO kos_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Acn natul Zelophehad elos oru oana ma LEUM GOD El sapkin nu sel Moses. ");
INSERT INTO kos_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Ouinge Mahlah, Tirzah, Hoglah, Milcah, ac Noah, eltal payukyak sin wen nutin tamulel lun papa tumalos. ");
INSERT INTO kos_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Elos payuk sin mwet in sruf lun fwilin tulik natul Manasseh wen natul Joseph, ac acn selos uh oanna in sruf lun papa tumalos. ");
INSERT INTO kos_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Pa inge ma sap ac ma oakwuk ma LEUM GOD El sapkin nu sel Moses, su ma nu sin mwet Israel, in acn mwesis lun Moab sisken infacl Jordan tulanang acn Jericho. ");
INSERT INTO kos_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Pa inge kas lal Moses nu sin mwet Israel ke pacl se elos oasr yen mwesis, kutulap in Infacl Jordan. Elos muta ke Infahlfal lun Jordan tulanang acn Suph, inmasrlon siti Paran ac siti Tophel, Laban, Hazeroth, ac Dizahab. ( ");
INSERT INTO kos_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Mwet uh fahsr ut ke fulan eol Edom ke lusen len singoul sie, Fineol Sinai nu Kadesh Barnea.) ");
INSERT INTO kos_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Ke len se emeet in malem aksingoul sie ke yac akangngaul tukun elos illa liki acn Egypt, Moses el fahkang nu sin mwet uh ma nukewa ma LEUM GOD El sapkin elan fahk nu selos. ");
INSERT INTO kos_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Ma se inge sikyak tukun LEUM GOD El kutangulla Tokosra Sihon lun mwet Amor su leumi siti Heshbon, ac Tokosra Og lun Bashan su leumi siti Ashtaroth ac Edrei. ");
INSERT INTO kos_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Mwet uh srakna muta kutulap in Infacl Jordan in facl sin mwet Moab ke Moses el mutawauk in aketeya ac luti ke ma sap lun God. El fahk, ");
INSERT INTO kos_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Ke kut srakna muta ke Eol Sinai, LEUM GOD lasr El fahk nu sesr, ‘Fal tari muta lowos ke eol soko inge. ");
INSERT INTO kos_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Tuleya lohm nuknuk suwos an ac mukuiyak. Fahsr nu infulan eol lun mwet Amor ac nu ke acn nukewa ma raunela — nu Infahlfal Jordan, nu infulan eol uh ac acn tupasrpasr uh, nu ke acn ma oan layen eir, ac nu ke weacn Meoa Mediterranean. Fahsr nu in facl Canaan ac alukeot pac Eol Lebanon, som na nwe ke Infacl lulap Euphrates. ");
INSERT INTO kos_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Acn inge nukewa pa nga, LEUM GOD, wulela kac in sang nu sin papa matu tomowos: Abraham, Isaac, ac Jacob, ac nu sin fwilin tulik natulos. Fahla ac eis lowos.’” ");
INSERT INTO kos_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Moses el fahk nu sin mwet uh, “Ke kut srakna muta Eol Sinai nga tuh fahk nu suwos, ‘Arulana upala nu sik in kol u lulap se inge. Nga tia ku in mukena oru. ");
INSERT INTO kos_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","LEUM GOD lowos El oru kowos in arulana pus, oana itu inkusrao uh. ");
INSERT INTO kos_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Lela LEUM GOD lun papa matu tomowos Elan akpusye kowos pacl tausin yohk liki inge, ac akinsewowoye kowos, oana ke El tuh wulela kac! ");
INSERT INTO kos_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Tusruktu nga ac mukena aksuwosye alein lowos uh fuka? ");
INSERT INTO kos_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Sulela kutu mwet lalmwetmet, mwet etauk ac mwet pah, liki kais sie sruf lowos, ac nga ac fah oru tuh elos in mwet kol lowos.’ ");
INSERT INTO kos_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Na kowos tuh insese mu wona in orek ouinge. ");
INSERT INTO kos_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Ke ma inge nga eis mwet lalmwetmet ac pah ma kowos tuh sulela in sruf lowos uh, ac nga oru tuh elos in mwet kol lowos. Kutu selos leum fin tausin, kutu leum fin foko, kutu fin lumngaul, ac kutu fin singoul. Nga oayapa srisrngiya kutu mwet pwapa saya in sruf nukewa. ");
INSERT INTO kos_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","“In pacl sac nga tuh fahk nu selos, ‘Porongo alein ma ac sikyak inmasrlon mwet lowos. Oru nununku lowos ke alein inge nukewa in suwohs, finne ma sin mwet lowos sifacna, ku ma sin mwetsac su muta inmasrlowos. ");
INSERT INTO kos_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Nimet wiwi mwet ke wotela lowos an. Kowos in nununku mwet nukewa oana sie ac nimet suk lah su. Nimet tupwek sin kutena mwet, mweyen ma kowos wotela uh ma sin God me. Fin oasr alein upala nu suwos, use nu yuruk ac nga fah wotela.’ ");
INSERT INTO kos_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","In pacl sacn pacna, nga tuh sot nu suwos kas in luti nu ke ma nukewa saya ma kowos in oru. ");
INSERT INTO kos_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“Kut orala ma LEUM GOD El sapkin nu sesr. Kut som liki Eol Sinai ac fahsr sasla yen mwesis na lulap sac su oasr mwe aksangeng puspis we, ke kut ut ke inkanek ke fulan eol lun mwet Amor. Na ke kut sun acn Kadesh Barnea, ");
INSERT INTO kos_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","nga tuh fahk nu suwos, “Kowos sun tari fulan eol sin mwet Amor, su LEUM GOD lasr El ase nu sesr. ");
INSERT INTO kos_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Liye, LEUM GOD lowos El asot facl se inge lowos. Utyak oakikowosi we, oana LEUM GOD lun papa matu tumasr El wulela kac. Nikmet sangeng ku alolo.’ ");
INSERT INTO kos_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“A kowos tuku nu yuruk ac fahk, ‘Wona kut in supwala kutu mukul ah in som meet liki kut in kalngei acn sac, elos in mau fahk nu sesr lah siti fuka ingo, ac pia inkanek fal kut in ut we.’ ");
INSERT INTO kos_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","“Nga insese nu ke nunak sac, na nga sulela mwet singoul luo, kais sie ke kais sie sruf. ");
INSERT INTO kos_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Elos som nu infulan eol uh nwe ke elos sun Infahlfal Eshcol, ac irong acn we nukewa. ");
INSERT INTO kos_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Elos foloko us kutu fokinsak ma elos konauk we, ac fahkak lah facl se su LEUM GOD lasr El ase in sesr ingo arulana wo fohk we. ");
INSERT INTO kos_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“A kowos utuk nunak lain ma LEUM GOD lowos El sapkin, ac kowos srangesr utyak nu in facl sac. ");
INSERT INTO kos_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Kowos torkaskas in lohm nuknuk suwos ac fahk, ‘LEUM GOD El srungakut. El uskutme liki acn Egypt in tuh eiskutyang nu inpoun mwet Amor inge, elos in unikuti. ");
INSERT INTO kos_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Efu ku kut in som nu we? Kut sangeng. Mwet ma kut supwala nu ingo fahk nu sesr lah mwet we elos arulana ku ac loes liki kut, oayapa pot in siti ma elos muta we uh arulana fulat nwe lucng. Elos liye pac mwet na yohk pisa we!’ ");
INSERT INTO kos_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“Tusruktu nga fahk nu suwos, ‘Nimet sangeng sin mwet ingo. ");
INSERT INTO kos_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","“LEUM GOD lowos El ac fah kol kowos, ac El ac fah mweun keiwos, oana ke kowos liye ke El tuh oru in facl Egypt ");
INSERT INTO kos_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ac yen mwesis. Kowos liye na lah fuka El uskowosme ac karingin kowos nwe ke kowos sun acn se inge, oana ke sie papa el kafisak wen natul.’ ");
INSERT INTO kos_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Tusruktu nga ne fahk ouinge, kowos srakna tia lulalfongi LEUM GOD, ");
INSERT INTO kos_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","El ne fahsr meet liki kowos in pacl nukewa in suk acn ma kowos ac aktuktuk we. In akkalemye innek lowos, El fahsr meet liki kowos in sie sru in e ke fong, ac in sie sru in pukunyeng ke len. ");
INSERT INTO kos_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“LEUM GOD El lohng torkaskas lowos ac kasrkusrakak. Ouinge El fulahk mu, ");
INSERT INTO kos_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Wangin sie suwos ke fwil koluk se inge ac fah ilyak nu in facl se ma wo fohk we su nga tuh wulela in sang nu sin papa matu tomowos. ");
INSERT INTO kos_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Caleb, wen natul Jephunneh, mukena ac fah utyak nu we. El srakna inse pwaye nu sik, ac nga fah sang acn ma el kalngeyuk we nu sel, ac nu sin fwilin tulik natul.’ ");
INSERT INTO kos_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Ke sripowos LEUM GOD El oayapa kasrkusrak sik ac fahk, ‘Moses, kom ac fah tia pac ilyak nu in facl sac. ");
INSERT INTO kos_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Joshua, wen natul Nun, mwet kasru lom, pa ac kol mwet Israel in eisla facl sac ac muta we. Na kom in akkeyal.’ ");
INSERT INTO kos_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","“LEUM GOD El fahk nu sesr nukewa, ‘Tulik nutuwos, su srakna srikla in etu inmasrlon ma wo ac ma koluk, elos pa ac utyak nu in facl sac — tulik ma kowos tuh fahk mu ac sruhu sin mwet lokoalok lowos. Nga fah sang facl sac nu selos, ac elos fah eisla ac muta fac. ");
INSERT INTO kos_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","A funu kowos, forla ac folokla nu yen mwesis ke inkanek nu Meoa Srusra.’ ");
INSERT INTO kos_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“Na kowos topuk ac fahk nu sik, ‘Moses, kut orekma koluk lain LEUM GOD. Tusruktu inge kut ac som mweun, in oana ke LEUM GOD lasr El sapkin.’ Na kais sie suwos tuh akola in mweun, ac nunku mu ac fisrasr in utyak eisla fulan eol uh. ");
INSERT INTO kos_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","“Tusruktu LEUM GOD El fahk nu sik, ‘Fahk nu selos elos in tia som mweun, mweyen nga ac tia welulos, ac mwet lokoalok lalos ac kutangulosla!’ ");
INSERT INTO kos_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Nga tuh fahk nu suwos ma LEUM GOD El fahk, a kowos tiana lungse lohng. Kowos utuk nunak lainul, ac ke nunak keke lowos kowos utyak na nu infulan eol uh. ");
INSERT INTO kos_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Na mwet Amor su muta infulan eol uh elos ilme lain kowos oana un loang in eir uh. Elos ukwe kowos na nwe Hormah, ac kutangkowosla infulan eol Edom. ");
INSERT INTO kos_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Na kowos tuh foloko ac wowoyak nu sin LEUM GOD in suk kasru, tusruktu El tiana porongekowos ku lohwot nu suwos. ");
INSERT INTO kos_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","“Ouinge, tukun kut tuh muta Kadesh ke sie pacl na loeloes, ");
INSERT INTO kos_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","kut forla ac folokla nu yen mwesis, ke inkanek nu inalok ke Meoa Srusra, oana LEUM GOD El sapkin, ac kut sisla pacl loeloes in foroht forma infulan eol lun Edom. ");
INSERT INTO kos_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Na LEUM GOD El fahk nu sik mu ");
INSERT INTO kos_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","fal tari pacl kut forfor infulan eol ingo, ac kut enenu in som nu epang. ");
INSERT INTO kos_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","El fahk nu sik ngan sot nu suwos kas inge: ‘Kowos akuranna fahsr sasla infulan eol Edom, facl sin fwilin tulik natul Esau, su mwet liwos. Elos ac fah sangeng suwos, ");
INSERT INTO kos_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","tusruktu nik kowos aklokoalokyalos, mweyen nga fah tia sot kutu srisrik acn lalos nu suwos, finne square foot se. Nga sang tari acn Edom tuh in ma lun mwet ke fwilin tulik natul Esau. ");
INSERT INTO kos_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Kowos ku in moul mongo nowos ac kof nimowos selos.’ ");
INSERT INTO kos_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","“Esam lah LEUM GOD lowos El akinsewowoye kowos in ma nukewa kowos oru. El karingin kowos in forfor lowos yen mwesis lulap se inge. El wi kowos ke yac angngaul inge, ac sot ma nukewa kowos enenu. ");
INSERT INTO kos_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“Na kut mukuiyak ac som liki inkanek ma som liki siti Elath ac Eziongeber nu ke Meoa Misa, na kut kuhfla nu kuta epang in som nu Moab. ");
INSERT INTO kos_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","LEUM GOD El fahk nu sik, ‘Nimet aklokoalokye mwet Moab, su fwilin tulik natul Lot, ac nimet mweun nu selos. Nga sang tari siti Ar nu selos, ac nga ac tia sot nu suwos kutena acn selos.’” ( ");
INSERT INTO kos_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Sie un mwet na yohk pisa pangpang mwet Emim muta in acn Ar meet. Elos mwet na loeska oana mwet Anak, sie pacna un mwet yohk pisa. ");
INSERT INTO kos_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Kutu mwet uh pangon mwet Emim ac mwet Anak ke e se inge: Rephaim. Tusruktu mwet Moab uh pangnolos Emim. ");
INSERT INTO kos_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Mwet Hor elos tuh muta Edom in pacl meet, tusruktu fwilin tulik natul Esau luselosla, kunausla mutunfacl selos, ac oakwuki we, oapana ma mwet Israel elos tuh oru tok ke elos lusla mwet lokoalok lalos liki acn ma LEUM GOD El tuh sang selos.) ");
INSERT INTO kos_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“Na kut alukeot Infacl Zered, oana LEUM GOD El sapkin nu sesr. ");
INSERT INTO kos_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Ma inge sikyak yac tolngoul oalkosr tukun kut tuku liki acn Kadesh Barnea. Mwet mweun nukewa in fwil sac misa nufon, oana ma LEUM GOD El tuh fahk. ");
INSERT INTO kos_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","LEUM GOD El nuna lainulos na nwe ke El kunauselosla nukewa. ");
INSERT INTO kos_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“Tukun elos nukewa misa, ");
INSERT INTO kos_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","LEUM GOD El fahk nu sesr, ");
INSERT INTO kos_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘Misenge kowos ac fahsr sasla acn lun mwet Moab ke inkanek nu Ar. ");
INSERT INTO kos_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Na kowos ac fah apkuran nu ke facl sin mwet Ammon, su fwilin tulik natul Lot. Nikmet aklokoalokyalos ku mweun nu selos, mweyen nga ac tia sot kutena acn lowos ke acn ma nga sang tari nu selos.’” ( ");
INSERT INTO kos_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Facl se inge oayapa eteyuk mu facl sin mwet Rephaim, inen mwet ma tuh muta we meet, a mwet Ammon uh pangnolos Zamzummim. ");
INSERT INTO kos_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Elos arulana loes, oana mwet Anak. Oayapa elos arulana pus, ac sie un mwet na fokoko. Tusruktu LEUM GOD El kunauselosla, tuh mwet Ammon in eisla acn selos ac oakwuki fac. ");
INSERT INTO kos_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","LEUM GOD El tuh oru ouiya se pacna inge nu sin mwet Edom, fwilin tulik natul Esau, su muta infulan eol lun Edom. El kunausla mwet Hor, ac oru tuh mwet Edom in eisla acn selos ac oakwuki we, ac elos srakna muta we nwe inge. ");
INSERT INTO kos_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Acn ma oan weacn Meoa Mediterranean oakwuki tari sin mwet tuku liki tuka Crete. Elos onela mwet Avvim, su mwet na pwaye we, ac eisla acn nukewa lalos, som na nwe siti Gaza in acn eir.) ");
INSERT INTO kos_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Tukun kut fahla sasla Moab, LEUM GOD El fahk nu sesr, ‘Inge, fahsrot alukela Infacl Arnon. Nga ac eisalot Sihon, tokosra lun mwet Amor ke siti Heshbon, nu inpouwos wi pac facl sel. Kowos in mweunel, ac mutawauk in muta fin acn sel. ");
INSERT INTO kos_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Misenge lac, nga ac oru mutanfahl nukewa in sangeng suwos. Mwet nukewa fah rarrar ac sangeng ke elos ac lohng keiwos.’ ");
INSERT INTO kos_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“Na nga supwala kutu mwet utuk kas yen mwesis Kedemoth lac nu yorol Tokosra Sihon lun Heshbon, ke kas in akmisye inmasrlosr inge: ");
INSERT INTO kos_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘Lela nu sesr in fahsr sasla acn sum uh. Kut ac fahsrna ke inkanek lulap uh, ac tiana kuhfla liki. ");
INSERT INTO kos_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Kut ac moli mwe mongo nasr ac kof nimasr. Ma sefanna kut enenu uh pa kut in fahla fin acn sum an, ");
INSERT INTO kos_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","nwe ke kut alukela Infacl Jordan nu in facl se LEUM GOD El ase in lasr. Tulik natul Esau su muta Edom, ac mwet Moab su muta Ar, elos lela kut in alukela facl selos.’ ");
INSERT INTO kos_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Tusruktu Tokosra Sihon el tia lela kut in fahsr sasla fin facl sel. LEUM GOD lowos El akupaye insial in lain kowos, kut in mau ku in kutangulla ac eisla facl sel, su kut srakna muta fac nwe misenge. ");
INSERT INTO kos_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","“Na LEUM GOD El fahk nu sik, ‘Liye, nga oru tuh Tokosra Sihon ac acn sel uh in munas suwos. Sruokya acn sel an ac muta fac.’ ");
INSERT INTO kos_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Tokosra Sihon el tufokme wi mwet lal nukewa in mweuni kut apkuran nu ke siti Jahaz, ");
INSERT INTO kos_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","tusruktu LEUM GOD lasr El eisalosme nu inpaosr, ac kut unilya, wi wen natul ac mwet lal nukewa. ");
INSERT INTO kos_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","In pacl sac pacna, kut sruokya ac kunausla siti nukewa, ac uniya mwet nukewa: mukul, mutan, ac tulik. Wangin mwet moul. ");
INSERT INTO kos_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Kut usla kosro nukewa ac ma saok nukewa in siti lalos. ");
INSERT INTO kos_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","LEUM GOD lasr El kasrekut in sruokya siti nukewa, mutawauk Aroer sisken Infahlfal Arnon, wi siti se ma oan infulwen infahlfal uh, som na nwe Gilead. Wangin siti ma kalkalyak ku, upa nu sesr in eisla. ");
INSERT INTO kos_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Tusruktu kut tia som apkuran nu ke acn lun mwet Ammon, ku nu ke pe Infacl Jabbok, ku nu ke siti infulan eol uh, ku nu ke kutena acn ma LEUM GOD El sap kut in tia som nu we. ");
INSERT INTO kos_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“Toko, kut mukuiyak ac som nu epang ke inkanek nu Bashan, ac Tokosra Og el tufokme wi mwet lal nukewa in mweuni kut apkuran nu ke siti Edrei. ");
INSERT INTO kos_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Tusruktu LEUM GOD El fahk nu sik, ‘Nimet sangeng sel. Nga ac eisalot, mwet lal, ac acn lal nukewa nu inpoum. Oru nu sel oana ke kom oru nu sel Tokosra Sihon lun mwet Amor su leum in Heshbon.’ ");
INSERT INTO kos_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","“Ouinge LEUM GOD El eisalma Tokosra Og nu inpaosr pac, ac kut onelosla nukewa. ");
INSERT INTO kos_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Kut sruokya siti lal nukewa in pacl sac — wangin sie acn lal kut tia eisla. Oasr siti onngoul kut sruokya — acn Argob nufon, su Tokosra Og lun Bashan el leumi. ");
INSERT INTO kos_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Siti inge nukewa orekla ku ke pot fulat, ac ipinsak na lulap pa sang laki srungul ke mutunpot uh, ac oasr pac siti srisrik ma wangin pot kac. ");
INSERT INTO kos_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Kut kunausla siti nukewa ac onela mukul, mutan, ac tulik nukewa, oana ke kut tuh oru nu ke siti lal Tokosra Sihon lun Heshbon. ");
INSERT INTO kos_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Kut usla kosro nukewa ac ma saok nukewa in siti lalos. ");
INSERT INTO kos_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","“In pacl sac, kut eisla sin tokosra luo lun mwet Amor inge, acn nukewa kutulap in Infacl Jordan, mutawauk Infacl Arnon lac nwe ke Eol Hermon. ( ");
INSERT INTO kos_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Mwet Sidon elos pangon Eol Hermon “Eol Sirion” ac mwet Amor elos pangon “Eol Senir.”) ");
INSERT INTO kos_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Kut eisla acn nukewa sel Tokosra Og lun Bashan: siti nukewa yen tupasrpasr uh, wi acn nukewa lun Gilead ac Bashan, som na nwe ke siti Salecah ac Edrei, su oan kutulap.” ( ");
INSERT INTO kos_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Tokosra Og pa safla ke mwet ma pangpang Rephaim. Box in misa lal orekla ke eot, fit onkosr sralap ac apkuran in fit singoul akosr lusa, fal nu ke srikasrak oakwuki in pacl sac. Box sac srakna ku in liyeyuk in siti Rabbah lun mwet Ammon.) ");
INSERT INTO kos_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“Ke kut eisla acn inge, nga sang nu sin sruf lal Reuben ac sruf lal Gad acn nukewa epang in siti Aroer apkuran nu Infacl Arnon, ac kutu ipin acn ke fulan eol lun Gilead, wi siti we. ");
INSERT INTO kos_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Nga sang nu sin tafu sruf lal Manasseh acn lula Gilead ac oayapa acn Bashan nufon, acn ma Tokosra Og el tuh leumi, aok, nufonna acn Argob.” (Eteyuk acn Bashan mu acn sin mwet Rephaim. ");
INSERT INTO kos_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jair, sie mwet in sruf lal Manasseh, el eis acn Argob, nufon — acn inge pa Bashan, som na nwe ke masrol lun Geshur ac Maacah. El sang inel sifacna nu ke acn inge, na srakna pangpang acn we “Siti Srisrik lal Jair.”) ");
INSERT INTO kos_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","“Nga sang Gilead nu sin sou lal Machir in sruf lal Manasseh. ");
INSERT INTO kos_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Ac nu sin sruf lal Reuben ac sruf lal Gad nga sang acn nukewa inmasrlon Gilead lac nu Infacl Arnon. Infulwen infacl soko ah pa masrol lalos nu layen eir, ac masrol layen nu epang pa Infacl Jabbok, su sie ip kac pa masrol lun mwet Ammon. ");
INSERT INTO kos_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Ke layen nu roto, acn selos fahla na nwe Infacl Jordan, layen epang mutawauk meoa Galilee ac putati nwe Meoa Misa nu eir, na fahla nu pe eol Pisgah layen kutulap. ");
INSERT INTO kos_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“In pacl sac pacna, nga sapkin nu selos mu, ‘LEUM GOD lasr El sot facl kutulap in Infacl Jordan tuh in ma lowos. Inge sang kufwen mwe mweun nu sin mwet mweun lowos, ac supwalosla in fahsr sasla Infacl Jordan meet liki sruf lun Israel ngia, in kasrelos eis facl sac lalos. ");
INSERT INTO kos_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Mutan kiowos, tulik nutuwos, ac kosro nutuwos fah tia wi som, a elos in mutana ke siti ma nga sot nu suwos. Nga etu lah pukanten kosro nutuwos. ");
INSERT INTO kos_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Kasru mwet Israel wiowos nwe ke elos eis acn selos ma LEUM GOD El ac sang lalos ke layen roto in Infacl Jordan, nwe ke LEUM GOD El oakelosi in muta in misla, oana ke El oru tari nu suwos inge. Na toko, kowos fah ku in foloko nu yenu, nu ke acn ma nga sot lowos.’ ");
INSERT INTO kos_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","“Na nga fahkang nu sel Joshua: ‘Kom liye tari ma nukewa ma LEUM GOD lom El oru nu sel Tokosra Sihon ac Tokosra Og, ac El ac fah oru oapana nu sin tokosra nukewa ke acn ma kom ac mweuni uh. ");
INSERT INTO kos_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Nimet sangeng selos, tuh LEUM GOD lom El ac fah mweun keim.’ ");
INSERT INTO kos_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“In pacl sac, nga kwafeang in pre ac fahk, ");
INSERT INTO kos_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘O LEUM GOD Fulatlana, nga etu lah kom tufahna mutawauk in akkalemye nu sik lupan ku lom ac fulat lom. Wangin sie god inkusrao ku fin faclu su ku in oru orekma kulana oana ma kom orala! ");
INSERT INTO kos_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","LEUM GOD, lela nu sik in fahsr alukela Infacl Jordan, ac liye facl wo se layeno ingo, oayapa fulan eol kato we ac fineol lun acn Lebanon.’ ");
INSERT INTO kos_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","“Tusruktu ke sripowos, LEUM GOD El mulat sik ac tia lungse porongeyu. A El fahk, ‘Tari! Nimet sifilpa fahk! ");
INSERT INTO kos_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Fanyak nu fin mangon Eol Pisgah ac ngetla nu epang ac nu eir, nu kutulap ac nu roto. Liye akwoya, mweyen kom ac koflana alukela Infacl Jordan. ");
INSERT INTO kos_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Sang kas in kasru nu sel Joshua ac akkeye nunak lal, mweyen el pa ac kol mwet uh in alukela Infacl Jordan ac oakwuki in acn ma kom ngetot liye ingo.’ ");
INSERT INTO kos_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","“Ouinge kut mutana infahlfal se tulanang siti Bethpeor.” ");
INSERT INTO kos_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Na Moses el fahk nu sin mwet uh, “Akos ma sap ac oakwuk nukewa ma nga luti kowos kac, na kowos fah ku in moul ac muta fin facl se su LEUM GOD lun papa tomowos El sot nu suwos. ");
INSERT INTO kos_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Nik kowos laesla kutena ma nu ke ma nga sapkin nu suwos, ac nik kowos eisla kutena ma liki. Akos ma sap nukewa lun LEUM GOD lowos ma nga sot nu suwos. ");
INSERT INTO kos_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Kowos sifacna liye ma LEUM GOD El tuh oru Fineol Peor. El onelosla nukewa su alu nu sel Baal we, ");
INSERT INTO kos_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","a kowos nukewa su inse pwaye nu sin LEUM GOD lowos, kowos srakna moul nwe misenge. ");
INSERT INTO kos_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“Nga tuh luti kowos ma sap nukewa, oana ke LEUM GOD luk El fahk ngan oru. Kowos in akos ma sap inge in facl se su kowos apkuran in mweuni in eisla lowos. ");
INSERT INTO kos_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Ke kowos oaru in liyaung ma sap inge, ac fah akkalemye nu sin mwet in mutunfacl saya lupan lalmwetmet lowos. Ke pacl elos ac lohng ma sap inge, elos ac fahk, ‘Seyal yohk lalmwetmet ac etauk lun mutunfacl lulap se inge!’ ");
INSERT INTO kos_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","“Wangin kutena mutunfacl, finne arulana yohk, oasr god se su apkuran nu selos ke pacl elos enenu, in oana LEUM GOD lasr El apkuran nu sesr. El topuk kut pacl nukewa kut pang nu sel. ");
INSERT INTO kos_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Wangin kutena mutunfacl, finne yohk, oasr ma sap lalos arulana suwohs, oana ma sap nga luti nu suwos misenge. ");
INSERT INTO kos_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Kowos in arulana taran ac karinganang tuh kowos in tia mulkunla ma kowos sifacna liye ke motowos, ke lusen moul lowos nufon. Srumun nu sin tulik nutuwos ac nu sin tulik nutin tulik nutuwos. ");
INSERT INTO kos_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ke len se kowos tuh tu ye mutun LEUM GOD lowos Fineol Sinai, ke El fahk nu sik, ‘Eisani mwet uh nu sie. Nga lungse elos in lohng ma nga ac fahk uh, ouinge elos ac fah ku in lutlut in akosyu ke lusen moul lalos, ac oapaya loteang tulik natulos in akosyu.’ ");
INSERT INTO kos_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","“Srumun nu sin tulik nutuwos ke pacl se kowos tuh som tu pe eol soko ah, su nukla ke kulasr matoltol ac lohsr, ac e uh firir nwe lucng. ");
INSERT INTO kos_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Srumun nu selos lah LEUM GOD El tuh kaskas nu suwos liki e sac, ac kowos lohng pusracl a tiana liyal in kutena lumah. ");
INSERT INTO kos_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","El fwackot nu suwos ma kowos enenu in oru in karinganang wuleang ma El orala inmasrlowos — kowos in akos Ma Sap Singoul, su El simusla fin eot tupasrpasr luo. ");
INSERT INTO kos_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","LEUM GOD El fahk nu sik nga in luti kowos ma sap nukewa su kowos enenu in akos in facl se su kowos apkuran in mweuni, eisla, ac oakwuki we. ");
INSERT INTO kos_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“Pacl se LEUM GOD El tuh kaskas nu suwos liki e sac Fineol Sinai, kowos tiana liyal in kutena lumah. Ouinge kowos in arulana karinganang ");
INSERT INTO kos_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","tuh kowos in tia oru ma koluk ke kowos orala nu suwos sifacna sie ma sruloala in kutena lumah — tia ke luman mukul ku mutan, ");
INSERT INTO kos_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","kosro ku won sohksok, ");
INSERT INTO kos_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ma orakrak ku ik. ");
INSERT INTO kos_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ke kowos ngetak nu inkusrao ac liye faht, malem, ac itu uh, nik kowos tafongla in alu ac orekma nu kac. LEUM GOD lowos El orala ma inge nu sin mwet nukewa faclu. ");
INSERT INTO kos_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","A kowos pa mutanfahl se su El molela liki facl Egypt, su oana sie funyu ma arulana fol mwe manman osra. El uskowosme liki acn we in oru tuh kowos in mwet lal sifacna, oana ke kowos oasr kac misenge. ");
INSERT INTO kos_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Ke sripowos, LEUM GOD El kasrkusrak sik ac orala fulahk lah nga ac fah tia alukela Infacl Jordan in utyak nu in facl se ma wo fohk we, su El asot nu suwos. ");
INSERT INTO kos_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Nga ac misa in acn se inge ac tia wi aliki infacl soko uh, tusruktu kowos apkuran in alukeot ac utyak muta fin acn wowo sac. ");
INSERT INTO kos_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Karinganangna tuh kowos in tia mulkunla wuleang ma LEUM GOD El orala yuruwos. Akos ma El sapkin, ac tia oru kutena kain in ma sruloala nu suwos sifacna, ");
INSERT INTO kos_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","mweyen LEUM GOD lowos El oana sie e firir; El tia lungse in oasr kutena god sayal. ");
INSERT INTO kos_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Tukun yac puspis, ke kowos okaki tari in facl sac ac oasr tulik nutuwos oayapa tulik nutin tulik nutuwos, nimet orekma koluk in orala ma sruloala nu suwos sifacna in kutena kain in lumah. Ma se inge sie ma koluk lulap ye mutun LEUM GOD, ac El ac fah arulana kasrkusrak kac. ");
INSERT INTO kos_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Nga pangon kusrao ac faclu in orek loh lain kowos misenge lah kowos fin seakosyu, kowos ac sa na wanginla liki facl se ma kowos ac alukela Infacl Jordan in eis. Kowos ac tia muta paht we, a kowos fah arulana sikiyukla. ");
INSERT INTO kos_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","LEUM GOD El ac fah akfahsryekowoselik inmasrlon mutunfacl saya, yen mwet na pu suwos ac painmoulla. ");
INSERT INTO kos_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","In acn ingo, kowos ac kulansupu god su orekla ke poun mwet — god sak ac eot, god su tia ku in liye ku lohng, su tia ku in mongo ku ngok ma uh. ");
INSERT INTO kos_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Kowos ac fah suk LEUM GOD lowos we, ac kowos fin sokol ke insiowos nufon, kowos fah konalak. ");
INSERT INTO kos_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Pacl kowos sun mwe ongoiya, ac ma upa ingan sikyak nu suwos, na tok kowos ac fah forla nu sin LEUM GOD ac aksol. ");
INSERT INTO kos_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","El sie God pakoten. El ac fah tia kunauskowosla ku fahsr liki kowos, ac El ac fah tia mulkunla wuleang se su El sifacna orala yurin mwet matu lowos meet ah. ");
INSERT INTO kos_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“Suk ke sramsram matu, ke pacl loeloes somla, meet liki kowos isusla, ke God El tufahna orala mwet faclu. Suk pac fin faclu nufon. Ku nu oasr ma yohk oana inge sikyak meet? Nu oasr mwet lohng kutena ma ouinge? ");
INSERT INTO kos_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Ya nu oasr mwet moul na tukun elos lohng sie god sramsram nu selos liki sie e, oana kowos? ");
INSERT INTO kos_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Ya nu oasr kutena god su srike in som eis sie un mwet liki sie pacna mutunfacl ac oru tuh elos in mwet lal sifacna, oana ke LEUM GOD lowos El oru nu suwos in Egypt? El orekmakin ku lulap ac fulat lal ye motowos. El use mwe lokoalok ac mweun, El orek mwenmen ac usrnguk, ac oru tuh mwe aksangeng puspis in sikyak. ");
INSERT INTO kos_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","LEUM GOD El fahkak ma inge nu suwos, in akpwaye nu suwos lah El mukena pa God, ac wangin pac sie sayal. ");
INSERT INTO kos_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","El oru tuh kowos in lohng pusral inkusrao me, tuh Elan ku in luti kowos; ac fin faclu El oru kowos in liye e firir mutal lal, ac El kaskas nu suwos liki e sac. ");
INSERT INTO kos_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Ke sripen El lungse papa matu tomowos meet ah, El sulekowosla ac El sifacna uskowosme liki Egypt ke ku lulap lal. ");
INSERT INTO kos_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","El lusla mutunfacl lulap ac ku liki kowos meet liki kowos tuku sun acn ingan, tuh Elan ku in uskowosme ac asot facl sac nu suwos — facl se su srakna ma suwos nwe misenge. ");
INSERT INTO kos_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Ke ma inge, misenge kowos in esam ac nimet mulkunla lah LEUM GOD El God lun kusrao ac faclu. Wangin sie god saya. ");
INSERT INTO kos_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Akos ma sap lal nukewa ma nga asot nu suwos misenge, na ma nukewa ac fah wo nu suwos ac nu sin fwilin tulik nutuwos. Ac fah loes pacl lowos in muta fin facl se su LEUM GOD lowos El asot nu suwos in lowos nwe tok.” ");
INSERT INTO kos_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Na Moses el srela tolu siti kutulap in Infacl Jordan ");
INSERT INTO kos_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","tuh sie mwet in ku in kaingla ac moulla we el fin uniya mwet se ke el tia oru in oaya, ac mwet sac el tia mwet lokoalok lal. El ku in kaing nu in sie siti inge, na ac tia anwuki el. ");
INSERT INTO kos_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Siti Bezer, su oan yen mwesis ke yen fulat tupasrpasr, ma nu sin sruf lal Reuben; siti Ramoth in acn Gilead, ma nu sin sruf lal Gad; ac siti Golan in acn Bashan, ma nu sin sruf lal Manasseh. ");
INSERT INTO kos_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Moses el sang ma sap lun God nu sin mwet Israel, wi mwe luti saya. ");
INSERT INTO kos_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Pa inge kas in luti ac ma sap ac ma oakwuk ma Moses el fahk nu sin mwet Israel tukun elos ilme liki Egypt, ");
INSERT INTO kos_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ke elos muta infahlfal kutulap in Infacl Jordan, tulanang Bethpeor. Acn se inge tuh ma lal Tokosra Sihon lun mwet Amor, su leumi Heshbon, a Moses ac mwet Israel elos tuh kutangulla ke elos tuku liki Egypt. ");
INSERT INTO kos_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Elos eisla acn lal ac acn lal Tokosra Og lun Bashan, sie pac tokosra lun mwet Amor su muta kutulap in Infacl Jordan. ");
INSERT INTO kos_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Acn se inge mutawauk ke siti Aroer, ke sisken Infacl Arnon, utyak epang nwe ke Eol Sion, su pangpang pac Fineol Hermon, ");
INSERT INTO kos_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","ac sisani acn nukewa kutulap in Infacl Jordan som eir lac nu ke Meoa Misa, ac nu kutulap nu pe Eol Pisgah. ");
INSERT INTO kos_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Moses el pangoneni mwet Israel nukewa ac fahk nu selos, “Mwet Israel, kowos in porongo ma sap ac oakwuk nukewa ma nga ac sot nu suwos misenge. Kowos in lutlut kac ac arulana akos. ");
INSERT INTO kos_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","LEUM GOD lasr El tuh orala sie wuleang Fineol Sinai, ");
INSERT INTO kos_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","tia inmasrlol ac papa tumasr mukena, a inmasrlol ac kut nukewa su moul misenge. ");
INSERT INTO kos_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","LEUM GOD El tuh kaskas nu suwos ngetani na, liki e fineol soko ah. ");
INSERT INTO kos_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","In pacl sac nga tuh tu inmasrlowos ac LEUM GOD in fahk nu suwos ma El fahk, mweyen kowos sangeng ke e uh, ac srangesr utyak nu fineol uh. “LEUM GOD El fahk, ");
INSERT INTO kos_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Nga pa LEUM GOD lowos, su uskowosme liki facl Egypt, acn se kowos tuh mwet kohs we. ");
INSERT INTO kos_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Nik kom eis siena god sayuk. ");
INSERT INTO kos_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“Nik kom oru nu sum kutena ma sruloala, ku kutena luman ma oan inkusrao lucng, ku ma oan in faclu ten, ku ma oan in kof ye faclu. ");
INSERT INTO kos_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Nik kom sifacna epasr nu selos, ku orekma nu selos; tuh nga LEUM GOD lom, sie God lemta; lahi ma koluk lun papa tuma nu fin tulik natu, nu ke fwil se aktolu ac akakosr selos su srungayu. ");
INSERT INTO kos_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","A nu selos su lungse nga ac liyaung ma sap luk, nga fah fahkak lungse kawil luk nu sin tausin fwil natulos. ");
INSERT INTO kos_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“Nik kom aklusrongtenye Inen LEUM GOD lom, tuh LEUM GOD El tia mu wangin mwatan el su aklusrongtenye Inel. ");
INSERT INTO kos_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“Esamya len Sabbath in akmutalye, oana LEUM GOD lom El sapkin nu sum. ");
INSERT INTO kos_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Len onkosr kom in orekma, ac oru orekma lom nukewa. ");
INSERT INTO kos_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","A len se akitkosr Sabbath lun LEUM GOD lom. Nik kom oru kutena orekma — kom, ku wen nutum, ku acn nutum, ku mwet mukul kulansap lom, ku mwet mutan kulansap lom, ku cow nutum ac donkey nutum, ku kutena kosro nutum, ku mwetsac su muta in kalkal lom. Mwet kulansap lom nukewa enenu in mongla oana kom. ");
INSERT INTO kos_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Esam lah kom tuh mwet kohs in facl Egypt, ac LEUM GOD lom El uskomme ke ku fulat ac po asroela. Ke ma inge LEUM GOD lom El sapkin nu sum in liyaung len Sabbath. ");
INSERT INTO kos_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“Sunakin papa tomom ac nina kiom oana LEUM GOD lom El sapkin nu sum, tuh len lom in pus, ac tuh ac fah wo nu sum in facl se su LEUM GOD lom El asot nu sum. ");
INSERT INTO kos_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“Nik kom akmas. ");
INSERT INTO kos_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“Nik kom kosro. ");
INSERT INTO kos_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“Nik kom pisrapasr. ");
INSERT INTO kos_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“Nik kom kaskas kikiap lain mwet tulan lom. ");
INSERT INTO kos_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“Nik kom rapkui mutan kien mwet tulan lom. Nik kom mwel lohm sin mwet tulan lom, ku ima lal, ku mwet mukul kulansap lal, ku mwet mutan kulansap lal, cow natul, donkey natul, ku kutena ma lun mwet tulan lom. ");
INSERT INTO kos_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“Pa inge ma sap su LEUM GOD El sot nu suwos nukewa ke pacl se kowos tuh tukeni pe eol soko ah. Ke pacl sac El tuh kaskas ke sie pusra kulana liki e sac, ac liki pukunyeng matoltol sac. El sot ma sap inge ac wangin pac ma saya, na El simusla fin eot tupasrpasr luo ac ase nu sik. ");
INSERT INTO kos_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","“Pacl se eol nufon soko ah firirrir, ac kowos lohng pusra sac tuku liki lohsr uh me, mwet kol lowos ac sifen sruf lowos uh tuku nu yuruk ");
INSERT INTO kos_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","ac fahk, ‘LEUM GOD lasr El akkalemye fulat lal ac wolana lal nu sesr ke pacl se kut lohng pusracl kaskas in e uh me! Misenge kut liye lah sie mwet el ku in moul na, God El finne kaskas nu sel. ");
INSERT INTO kos_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Tusruktu efu ku kut in pilesrala moul lasr? E na lulap se ingan ac kunauskutla. Pwayena kut ac misa kut fin lohng ke LEUM GOD El ac sifil kaskas. ");
INSERT INTO kos_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Ya nu oasr sie mwet su painmoul tukun el lohng God moul kaskas in e uh me, oana ke kut tuh lohngol? ");
INSERT INTO kos_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Folokot, Moses, ac lohng ma nukewa ma LEUM GOD lasr El fahk uh. Na kom foloko ac fahk nu sesr ma El fahk nu sum. Kut ac fah porongo ac akos.’ ");
INSERT INTO kos_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“Ke LEUM GOD El lohng ma inge, El fahk nu sik, ‘Nga lohng ma mwet inge fahk uh, ac pwaye selos. ");
INSERT INTO kos_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Saok in ouinge nunak lalos pacl nukewa! Nga kena elos in sunakinyu pacl nukewa ac akos ma sap luk nukewa. Fin ouinge, na ma nukewa ac wo nu selos ac nu sin fwilin tulik natulos nwe tok. ");
INSERT INTO kos_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Fahla ac fahk nu selos in folokla nu in lohm nuknuk selos. ");
INSERT INTO kos_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Tusruktu kom, Moses, muta yuruk inge, ac nga fah sot nu sum ma sap luk ac oakwuk luk nukewa. Luti ma inge nu sin mwet uh, tuh elos fah akos in facl se su nga fah sang nu selos.’ ");
INSERT INTO kos_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","“Mwet Israel, kowos aklohya. Oru ma nukewa ma LEUM GOD lowos El sapkin nu suwos. Nimet seakos kutena ma sap lal. ");
INSERT INTO kos_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Akos ma sap inge nukewa, tuh ma nukewa in wo nu suwos ac kowos fah ku in muta paht fin facl se su kowos ac oakwuki we. ");
INSERT INTO kos_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“Pa inge ma sap nukewa LEUM GOD Iowos El sapkin nu sik in luti kowos kac. Akos ma sap inge fin facl se su kowos akola in utyak ac muta we. ");
INSERT INTO kos_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Ke lusenna moul lowos, kowos ac fwilin tulik nutuwos an in akfulatye LEUM GOD lowos, ac akos ma sap nukewa lal ma nga sot nu suwos, tuh kowos in ku in muta paht fin facl sac. ");
INSERT INTO kos_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Mwet Israel, kowos in lohng ma sap inge, ac akos! Na ma nukewa ac fah wo nu suwos, ac kowos fah ekla sie mutunfacl na ku, ac kowos fah muta in sie facl mut ac kasrup fohk we, in oana ke LEUM GOD lun papa tumasr El tuh wulela kac. ");
INSERT INTO kos_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“Lohng, O Israel! LEUM GOD, God lasr, El God sefanna. ");
INSERT INTO kos_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Kom fah lungse LEUM GOD lom ke insiom kewa, ke ngunum kewa, ac ke ku lom kewa. ");
INSERT INTO kos_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Nimet mulkunla ma sap inge su nga sot nu sum misenge. ");
INSERT INTO kos_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Luti kas inge nu sin tulik nutum. Alken in luti pacl kom oasr in lohm sum, pacl kom fufahsryesr, pacl kom mongla, ac pacl kom orekma. ");
INSERT INTO kos_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Kapriya kas inge ke poum ac ke motonsrum, tuh in mwe akesmakinye kom. ");
INSERT INTO kos_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Simusla kas inge ke kosrusru in mutunoa ke lohm sum, ac ke nien utyak lun kalkal lom. ");
INSERT INTO kos_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“Oana ke LEUM GOD lowos el wuleang nu sin papa matu tomowos — Abraham, Isaac, ac Jacob — El ac fah sot nu suwos sie facl ma siti we uh yohk ac sessesla ke mwe kasrup, su kowos tia musaiak. ");
INSERT INTO kos_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","Lohm we ac fah sessesla ke ma wo, su tia ma kowos likiya loac. Ac fah oasr lufin kof su tia ma kowos pukanak. Ac fah oasr ima in grape ac olive ma kowos tia yukwiya. Na ke pacl se LEUM GOD El ac pwenkowosla nu in facl sac, ac kowos mongo ac kihp, ");
INSERT INTO kos_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","taranna kowos in tia mulkunla LEUM GOD su pwenkowosme liki facl Egypt, yen kowos tuh mwet kohs we. ");
INSERT INTO kos_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Akfulatye LEUM GOD lowos, ac alu nu sel mukena, ac oru wulela lowos ke Inel mukena. ");
INSERT INTO kos_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Nimet alu nu sin kutena god saya, god lun mwet su raunikowosla. ");
INSERT INTO kos_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Kowos fin alu nu sin god ngia, kasrkusrak lun LEUM GOD fah tayak lain kowos oana e uh, na ac fah arulana kunauskowosla, mweyen LEUM GOD lowos su muta inmasrlowos El tia lungse in oasr kutena god sayal. ");
INSERT INTO kos_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","“Nimet srike LEUM GOD lowos, oana ke kowos tuh oru in acn Massah. ");
INSERT INTO kos_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Kowos in arulana oaru in akos ma sap ac oakwuk nukewa ma El sot nu suwos. ");
INSERT INTO kos_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Oru ma suwohs ac wo ye mutun LEUM GOD, ac ma nukewa ac fah wo nu suwos. Kowos ac fah ku in eis facl mut ac wo fohk we su LEUM GOD El tuh wulela kac nu sin papa matu tomowos, ");
INSERT INTO kos_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","ac kowos fah lusak mwet lokoalok lowos, oana El tuh wuleot nu suwos. ");
INSERT INTO kos_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“Ke pacl fahsru uh, tulik nutuwos ac fah siyuk suwos, ‘Efu ku LEUM GOD lasr El tuh sapkin nu sesr in akos ma sap inge nukewa?’ ");
INSERT INTO kos_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Na kowos ac fah fahk nu selos, ‘Kut tuh mwet kohs lun tokosra lun acn Egypt, ac LEUM GOD El molikutla ac aksukosokye kut ke ku lulap lal. ");
INSERT INTO kos_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Kut sifacna liye ke mutasr mwenmen El oru wi mwe aksangeng lulap nu sin mwet Egypt ac nu sin tokosra lalos ac mwet fulat nukewa lal. ");
INSERT INTO kos_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","El aksukosokyekutla liki facl Egypt ac uskutme nu inge, ac ase lasr facl se inge, oana ke El tuh wulela nu sin papa matu tumasr. ");
INSERT INTO kos_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Na LEUM GOD lasr El tuh sapkin nu sesr in akos ma sap inge nukewa, ac in akfulatyal. Kut fin oru ouinge, El ac fah karingin mutunfacl sesr ac oru in kapkapak pacl nukewa. ");
INSERT INTO kos_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Kut fin oaru in akos ma nukewa ma God El sapkin nu sesr, El ac fah insewowo sesr.’ ");
INSERT INTO kos_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“LEUM GOD lowos El fah uskowosla nu in facl se su kowos ac oakwuki we, ac El ac fah lusak mutunfacl puspis liki acn we. Ke kowos ac apkuranyang nu we, El ac fah lusak mutunfacl itkosr su yohk liki kowos ac ku liki kowos: mwet Hit, mwet Girgash, mwet Amor, mwet Canaan, mwet Periz, mwet Hiv, ac mwet Jebus. ");
INSERT INTO kos_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Ke LEUM GOD lowos El ac eisaloswot nu inpouwos ac kowos kutangulosla, kowos in onelosla nukewa. Nik kowos orek kupasr yorolos ku pakomutalos. ");
INSERT INTO kos_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Nik kowos payuk sin kutena selos, ac nik kowos fuhlela wen ac acn nutuwos in payuk sin kutena selos. ");
INSERT INTO kos_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Mweyen elos ac mau furokla tulik nutuwos an liki LEUM GOD in alu nu sin god ngia. Fin sikyak ouiya se inge, LEUM GOD El ac kasrkusrakak suwos ac sikikowosla pacl sefanna. ");
INSERT INTO kos_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Ke ma inge, kowos in kunausya loang lalos, ac fukulya sru eot mutal selos, pakiya ma akilenyen god mutan Asherah, ac esukak ma sruloala lalos. ");
INSERT INTO kos_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Oru ma inge mweyen kowos mutanfahl mutal lun LEUM GOD lowos. Inmasrlon mwet fin faclu nufon, El sulekowosla in mwet saok lal sifacna. ");
INSERT INTO kos_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","“LEUM GOD El tia lungse kowos ac sulekowosla ke sripen kowos pus liki mutunfacl ngia — kowos pa mutunfacl se ma srik oemeet fin faclu. ");
INSERT INTO kos_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Tusruktu LEUM GOD El lungse kowos ac kena in karinganang wulela ma El tuh orala yurin papa matu tomowos, pa sis El tuh molikowosla ke ku lulap lal, ac aksukosokye kowos liki moul in kohs lowos ye poun tokosra lun Egypt. ");
INSERT INTO kos_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Esam lah LEUM GOD lowos El mukena pa God, ac El oaru. El ac fah liyaung wulela lal, ac fahkak lungse kawil lal nu sin tausin fwil selos su lungse El ac akos ma sap lal. ");
INSERT INTO kos_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Tusruktu El ac tia pahtlac in kalyaelos su srungal. ");
INSERT INTO kos_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Ke ma inge, akos ma lutiyuk nu suwos. Akos ma sap ac oakwuk nukewa ma nga asot nu suwos misenge. ");
INSERT INTO kos_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“Kowos fin porongo ma sap inge ac oaru in akos, na LEUM GOD lowos El ac fah karinganang na wulela lal nu suwos, ac fahkak lungse kawil lal nu suwos, oana El tuh wuleang nu sin papa matu tomowos meet ah. ");
INSERT INTO kos_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","El fah lungse kowos ac akinsewowoye kowos, na kowos fah puseni ac oasr tulik puspis nutuwos. El ac akinsewowoye ima lowos in pus wheat, wain, ac oil in olive; ac El ac fah akpusye cow ac sheep nutuwos. El ac fah asot nu suwos mwe insewowo inge nu kewa in facl se ma El tuh wulela nu sin papa matu tomowos mu El ac sot nu suwos. ");
INSERT INTO kos_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Wangin mutunfacl fin faclu ac fah insewowo yohk liki kowos. Wangin suwos, mukul ku mutan ku kosro nutuwos, ac fah talap. ");
INSERT INTO kos_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","LEUM GOD El ac fah kosrala liki kowos kain in mas nukewa, ac kowos fah tia sifil maskin kutena mas upa ma kowos tuh pula in acn Egypt, tusruktu El ac fah sang mas inge nu sin mwet lokoalok lowos. ");
INSERT INTO kos_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Kunausla mutunfacl nukewa su LEUM GOD lowos El asot nu inpouwos, ac nik kowos pakomutalos. Nik kowos alu nu ke god lalos, tuh ma inge oana sie mwe kwasrip nu suwos. ");
INSERT INTO kos_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“Nik kowos sifacna nunku mu mwet inge elos pus liki kowos, ac kowos tia ku in luselosla. ");
INSERT INTO kos_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Nimet sangeng selos. Esam ma LEUM GOD lowos El tuh oru nu sin tokosra lun acn Egypt ac mwet lal nukewa. ");
INSERT INTO kos_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Esam mwe lokoalok yohk ma kowos tuh sifacna liye ke motowos, ac mwenmen ac ma usrnguk ac ku lulap su LEUM GOD lowos El aksukosokyekowosla kac. In ouiya se na ma El tuh kunausla mwet Egypt, El ac kunausla mwet nukewa su kowos sangeng se inge. ");
INSERT INTO kos_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","El ac oayapa akfohsyauk mwet lokoalok lowos, ac El ac fah kunauselosla su kaing in wikwik. ");
INSERT INTO kos_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Ouinge, nimet sangeng sin mwet inge. LEUM GOD lowos El wi kowos. El sie God fulat, su fal mwet uh in sangeng se. ");
INSERT INTO kos_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","El ac fah kais kutu srisrik lihs mutanfahl inge ye motowos. Kowos ac fah tia ku in kunauselosla nukewa pacl sefanna, mweyen kowos fin oru ouinge, kosro lemnak uh ac mau puseni, na ac fah sie mwe sensen lulap nu suwos. ");
INSERT INTO kos_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","LEUM GOD El ac fah asot mwet lokoalok lowos nu inpouwos, ac akfohsyalosyak nwe ke elos kunausyukla. ");
INSERT INTO kos_vpl VALUES ("D