﻿USE sofia;
DROP TABLE IF EXISTS sofia.kor_vpl;
CREATE TABLE kor_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kor_vpl WRITE;
INSERT INTO kor_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","태초에 하나님이 천지를 창조하시니라 ");
INSERT INTO kor_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","땅이 혼돈하고 공허하며 흑암이 깊음 위에 있고 하나님의 신(神)은 수면에 운행하시니라 ");
INSERT INTO kor_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","하나님이 가라사대 빛이 있으라 하시매 빛이 있었고 ");
INSERT INTO kor_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","그 빛이 하나님의 보시기에 좋았더라 하나님이 빛과 어두움을 나누사 ");
INSERT INTO kor_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","빛을 낮이라 칭하시고 어두움을 밤이라 칭하시니라 저녁이 되며 아침이 되니 이는 첫째 날이니라 ");
INSERT INTO kor_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","하나님이 가라사대 물 가운데 궁창이 있어 물과 물로 나뉘게 하리라 ! 하시고 ");
INSERT INTO kor_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","하나님이 궁창을 만드사 궁창 아래의 물과 궁창 위의 물로 나뉘게 하시매 그대로 되니라 ");
INSERT INTO kor_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","하나님이 궁창을 하늘이라 칭하시니라 저녁이 되며 아침이 되니 이는 둘째 날이니라 ");
INSERT INTO kor_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","하나님이 가라사대 천하의 물이 한곳으로 모이고 뭍이 드러나라 ! 하시매 그대로 되니라 ");
INSERT INTO kor_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","하나님이 뭍을 땅이라 칭하시고 모인 물을 바다라 칭하시니라 하나님의 보시기에 좋았더라 ");
INSERT INTO kor_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","하나님이 가라사대 땅은 풀과 씨 맺는 채소와 각기 종류대로 씨 가진 열매 맺는 과목을 내라 하시매 그대로 되어 ");
INSERT INTO kor_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","땅이 풀과 각기 종류대로 씨 맺는 채소와 각기 종류대로 씨 가진 열매 맺는 나무를 내니 하나님의 보시기에 좋았더라 ");
INSERT INTO kor_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","저녁이 되며 아침이 되니 이는 세째 날이니라 ");
INSERT INTO kor_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","하나님이 가라사대 하늘의 궁창에 광명이 있어 주야를 나뉘게 하라 또 그 광명으로 하여 징조와 사시와 일자와 연한이 이루라 ");
INSERT INTO kor_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","또 그 광명이 하늘의 궁창에 있어 땅에 비취라 하시고 (그대로 되니라) ");
INSERT INTO kor_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","하나님이 두 큰 광명을 만드사 큰 광명으로 낮을 주관하게 하시고 작은 광명으로 밤을 주관하게 하시며 또 별들을 만드시고 ");
INSERT INTO kor_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","하나님이 그것들을 하늘의 궁창에 두어 땅에 비취게 하시며 ");
INSERT INTO kor_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","주야를 주관하게 하시며 빛과 어두움을 나뉘게 하시니라 하나님의 보시기에 좋았더라 ");
INSERT INTO kor_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","저녁이 되며 아침이 되니 이는 네째 날이니라 ");
INSERT INTO kor_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","하나님이 가라사대 물들은 생물로 번성케 하라 땅 위 하늘의 궁창에는 새가 날으라 하시고 ");
INSERT INTO kor_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","하나님이 큰 물고기와 물에서 번성하여 움직이는 모든 생물을 그 종류대로, 날개 있는 모든 새를 그 종류대로 창조하시니 하나님의 보시기에 좋았더라 ");
INSERT INTO kor_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","하나님이 그들에게 복을 주어 가라사대 생육하고 번성하여 여러 바다물에 충만하라 새들도 땅에 번성하라 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","저녁이 되며 아침이 되니 이는 다섯째 날이니라 ");
INSERT INTO kor_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","하나님이 가라사대 땅은 생물을 그 종류대로 내되 육축과 기는 것과 땅의 짐승을 종류대로 내라 하시고 (그대로 되니라) ");
INSERT INTO kor_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","하나님이 땅의 짐승을 그 종류대로, 육축을 그 종류대로, 땅에 기는 모든 것을 그 종류대로 만드시니 하나님의 보시기에 좋았더라 ");
INSERT INTO kor_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","하나님이 가라사대 우리의 형상을 따라 우리의 모양대로 우리가 사람을 만들고 그로 바다의 고기와, 공중의 새와, 육축과, 온 땅과, 땅에 기는 모든 것을 다스리게 하자 하시고 ");
INSERT INTO kor_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","하나님이 자기 형상 곧 하나님의 형상대로 사람을 창조하시되 남자와 여자를 창조하시고 ");
INSERT INTO kor_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","하나님이 그들에게 복을 주시며 그들에게 이르시되 생육하고 번성하여 땅에 충만하라, 땅을 정복하라, 바다의 고기와 공중의 새와 땅에 움직이는 모든 생물을 다스리라 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","하나님이 가라사대 내가 온 지면의 씨 맺는 모든 채소와 씨 가진 열매 맺는 모든 나무를 너희에게 주노니 너희 식물이 되리라 ");
INSERT INTO kor_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","또 땅의 모든 짐승과 공중의 모든 새와 생명이 있어 땅에 기는 모든 것에게는 내가 모든 푸른 풀을 식물로 주노라 하시니 그대로 되니라 ");
INSERT INTO kor_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","하나님이 그 지으신 모든 것을 보시니 보시기에 심히 좋았더라 저녁이 되며 아침이 되니 이는 여섯째 날이니라 ");
INSERT INTO kor_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","천지와 만물이 다 이루니라 ");
INSERT INTO kor_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","하나님의 지으시던 일이 일곱째 날이 이를 때에 마치니 그 지으시던 일이 다하므로 일곱째 날에 안식하시니라 ");
INSERT INTO kor_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","하나님이 일곱째 날을 복 주사 거룩하게 하셨으니 이는 하나님이 그 창조하시며 만드시던 모든 일을 마치시고 이 날에 안식하셨음이더라 ");
INSERT INTO kor_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","여호와 하나님이 천지를 창조하신 때에 천지의 창조된 대략이 이러하니라 ");
INSERT INTO kor_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","여호와 하나님이 땅에 비를 내리지 아니하셨고 경작할 사람도 없었으므로 들에는 초목이 아직 없었고 밭에는 채소가 나지 아니하였으며 ");
INSERT INTO kor_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","안개만 땅에서 올라와 온 지면을 적셨더라 ");
INSERT INTO kor_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","여호와 하나님이 흙으로 사람을 지으시고 생기를 그 코에 불어 넣으시니 사람이 생령이 된지라 ");
INSERT INTO kor_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","여호와 하나님이 동방의 에덴에 동산을 창설하시고 그 지으신 사람을 거기 두시고 ");
INSERT INTO kor_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","여호와 하나님이 그 땅에서 보기에 아름답고 먹기에 좋은 나무가 나게 하시니 동산 가운데에는 생명나무와 선악을 알게하는 나무도 있더라 ");
INSERT INTO kor_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","강이 에덴에서 발원하여 동산을 적시고 거기서부터 갈라져 네 근원이 되었으니 ");
INSERT INTO kor_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","첫째의 이름은 비손이라 금이 있는 하윌라 온 땅에 둘렸으며 ");
INSERT INTO kor_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","그 땅의 금은 정금이요 그 곳에는 베델리엄과 호마노도 있으며 ");
INSERT INTO kor_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","둘째 강의 이름은 기혼이라 구스 온 땅에 둘렸고 ");
INSERT INTO kor_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","세째 강의 이름은 힛데겔이라 앗수르 동편으로 흐르며 네째 강은 유브라데더라 ");
INSERT INTO kor_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","여호와 하나님이 그 사람을 이끌어 에덴 동산에 두사 그것을 다스리며 지키게 하시고 ");
INSERT INTO kor_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","여호와 하나님이 그 사람에게 명하여 가라사대 동산 각종 나무의 실과는 네가 임의로 먹되 ");
INSERT INTO kor_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","선악을 알게하는 나무의 실과는 먹지 말라 ! 네가 먹는 날에는 정녕 죽으리라 ! 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","여호와 하나님이 가라사대 사람의 독처하는 것이 좋지 못하니 내가 그를 위하여 돕는 배필을 지으리라 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","여호와 하나님이 흙으로 각종 들짐승과 공중의 각종 새를 지으시고 아담이 어떻게 이름을 짓나 보시려고 그것들을 그에게로 이끌어 이르시니 아담이 각 생물을 일컫는 바가 곧 그 이름이라 ");
INSERT INTO kor_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","아담이 모든 육축과 공중의 새와 들의 모든 짐승에게 이름을 주니라 아담이 돕는 배필이 없으므로 ");
INSERT INTO kor_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","여호와 하나님이 아담을 깊이 잠들게 하시니 잠들매 그가 그 갈빗대 하나를 취하고 살로 대신 채우시고 ");
INSERT INTO kor_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","여호와 하나님이 아담에게서 취하신 그 갈빗대로 여자를 만드시고 그를 아담에게로 이끌어 오시니 ");
INSERT INTO kor_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","아담이 가로되 `이는 내 뼈 중의 뼈요 ! 살 중의 살이라 ! 이것을 남자에게서 취하였은즉 여자라 칭하리라' 하니라 ");
INSERT INTO kor_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","이러므로 남자가 부모를 떠나 그 아내와 연합하여 둘이 한 몸을 이룰지로다 ! ");
INSERT INTO kor_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","아담과 그 아내 두 사람이 벌거벗었으나 부끄러워 아니하니라 ");
INSERT INTO kor_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","여호와 하나님의 지으신 들짐승 중에 뱀이 가장 간교하더라 뱀이 여자에게 물어 가로되 `하나님이 참으로 너희더러 동산 모든 나무의 실과를 먹지 말라 하시더냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","여자가 뱀에게 말하되 `동산 나무의 실과를 우리가 먹을 수 있으나 ");
INSERT INTO kor_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","동산 중앙에 있는 나무의 실과는 하나님의 말씀에 너희는 먹지도 말고 만지지도 말라 너희가 죽을까 하노라 하셨느니라' ");
INSERT INTO kor_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","뱀이 여자에게 이르되 `너희가 결코 죽지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","너희가 그것을 먹는 날에는 너희 눈이 밝아 하나님과 같이 되어 선악을 알 줄을 하나님이 아심이니라' ");
INSERT INTO kor_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","여자가 그 나무를 본즉 먹음직도 하고, 보암직도 하고, 지혜롭게 할 만큼 탐스럽기도 한 나무인지라 여자가 그 실과를 따먹고 자기와 함께 한 남편에게도 주매 그도 먹은지라 ");
INSERT INTO kor_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","이에 그들의 눈이 밝아 자기들의 몸이 벗은 줄을 알고 무화과나무 잎을 엮어 치마를 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","그들이 날이 서늘할 때에 동산에 거니시는 여호와 하나님의 음성을 듣고 아담과 그 아내가 여호와 하나님의 낯을 피하여 동산 나무 사이에 숨은지라 ");
INSERT INTO kor_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","여호와 하나님이 아담을 부르시며 그에게 이르시되 네가 어디 있느냐 ? ");
INSERT INTO kor_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","가로되 `내가 동산에서 하나님의 소리를 듣고 내가 벗었으므로 두려워하여 숨었나이다' ");
INSERT INTO kor_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","가라사대 누가 너의 벗었음을 네게 고하였느냐 ? 내가 너더러 먹지 말라 명한 그 나무 실과를 네가 먹었느냐 ? ");
INSERT INTO kor_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","아담이 가로되 `하나님이 주셔서 나와 함께하게 하신 여자 그가 그 나무 실과를 내게 주므로 내가 먹었나이다' ");
INSERT INTO kor_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","여호와 하나님이 여자에게 이르시되 네가 어찌하여 이렇게 하였느냐 ? 여자가 가로되 `뱀이 나를 꾀므로 내가 먹었나이다' ");
INSERT INTO kor_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","여호와 하나님이 뱀에게 이르시되 네가 이렇게 하였으니 네가 모든 육축과 들의 모든 짐승보다 더욱 저주를 받아 배로 다니고 종신토록 흙을 먹을지니라 ");
INSERT INTO kor_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","내가 너로 여자와 원수가 되게 하고 너의 후손도 여자의 후손과 원수가 되게 하리니 여자의 후손은 네 머리를 상하게 할 것이요 너는 그의 발꿈치를 상하게 할 것이니라 하시고 ");
INSERT INTO kor_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","또 여자에게 이르시되 내가 네게 잉태하는 고통을 크게 더하리니 네가 수고하고 자식을 낳을 것이며 너는 남편을 사모하고 남편은 너를 다스릴 것이니라 하시고 ");
INSERT INTO kor_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","아담에게 이르시되 네가 네 아내의 말을 듣고 내가 너더러 먹지 말라 한 나무 실과를 먹었은즉 땅은 너로 인하여 저주를 받고 너는 종신토록 수고하여야 그 소산을 먹으리라 ");
INSERT INTO kor_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","땅이 네게 가시덤불과 엉겅퀴를 낼 것이라 너의 먹을 것은 밭의 채소인즉 ");
INSERT INTO kor_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","네가 얼굴에 땀이 흘러야 식물을 먹고 필경은 흙으로 돌아가리니 그 속에서 네가 취함을 입었음이라 너는 흙이니 흙으로 돌아 갈 것이니라 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","아담이 그 아내를 하와라 이름하였으니 그는 모든 산 자의 어미가 됨이더라 ");
INSERT INTO kor_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","여호와 하나님이 아담과 그 아내를 위하여 가죽 옷을 지어 입히시니라 ");
INSERT INTO kor_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","여호와 하나님이 가라사대 보라, 이 사람이 선악을 아는 일에 우리 중 하나같이 되었으니 그가 그 손을 들어 생명나무 실과도 먹고 영생할까 하노라 하시고 ");
INSERT INTO kor_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","여호와 하나님이 에덴 동산에서 그 사람을 내어 보내어 그의 근본된 토지를 갈게 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","이같이 하나님이 그 사람을 쫓아 내시고 에덴 동산 동편에 그룹들과 두루 도는 화염검을 두어 생명나무의 길을 지키게 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","아담이 그 아내 하와와 동침하매 하와가 잉태하여 가인을 낳고 이르되 `내가 여호와로 말미암아 득남하였다' 하니라 ");
INSERT INTO kor_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","그가 또 가인의 아우 아벨을 낳았는데 아벨은 양 치는 자이었고, 가인은 농사하는 자이었더라 ");
INSERT INTO kor_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","세월이 지난 후에 가인은 땅의 소산으로 제물을 삼아 여호와께 드렸고 ");
INSERT INTO kor_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","아벨은 자기도 양의 첫 새끼와 그 기름으로 드렸더니 여호와께서 아벨과 그 제물은 열납하셨으나 ");
INSERT INTO kor_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","가인과 그 제물은 열납하지 아니하신지라 가인이 심히 분하여 안색이 변하니 ");
INSERT INTO kor_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","여호와께서 가인에게 이르시되 네가 분하여 함은 어찜이며 안색이 변함은 어찜이뇨 ? ");
INSERT INTO kor_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","네가 선을 행하면 어찌 낯을 들지 못하겠느냐 ? 선을 행치 아니하면 죄가 문에 엎드리느니라 죄의 소원은 네게 있으나 너는 죄를 다스릴지니라 ");
INSERT INTO kor_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","가인이 그 아우 아벨에게 고하니라 그 후 그들이 들에 있을때에 가인이 그 아우 아벨을 쳐 죽이니라 ");
INSERT INTO kor_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","여호와께서 가인에게 이르시되 네 아우 아벨이 어디 있느냐 ? 그가 가로되 `내가 알지 못하나이다 내가 내 아우를 지키는 자이니까 ?' ");
INSERT INTO kor_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","가라사대 네가 무엇을 하였느냐 ? 네 아우의 핏소리가 땅에서부터 내게 호소하느니라 ");
INSERT INTO kor_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","땅이 그 입을 벌려 네 손에서부터 네 아우의 피를 받았은즉 네가 땅에서 저주를 받으리니 ");
INSERT INTO kor_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","네가 밭 갈아도 땅이 다시는 그 효력을 네게 주지 아니할 것이요 너는 땅에서 피하며 유리하는 자가 되리라 ");
INSERT INTO kor_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","가인이 여호와께 고하되 `내 죄벌이 너무 중하여 견딜 수 없나이다 ");
INSERT INTO kor_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","주께서 오늘 이 지면에서 나를 쫓아 내시온즉 내가 주의 낯을 뵈옵지 못하리니 내가 땅에서 피하며 유리하는 자가 될지라 무릇 나를 만나는 자가 나를 죽이겠나이다' ");
INSERT INTO kor_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","여호와께서 그에게 이르시되 그렇지 않다 가인을 죽이는 자는 벌을 칠배나 받으리라 하시고 가인에게 표를 주사 만나는 누구에게든지 죽임을 면케 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","가인이 여호와의 앞을 떠나 나가 에덴 동편 놋 땅에 거하였더니 ");
INSERT INTO kor_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","아내와 동침하니 그가 잉태하여 에녹을 낳은지라 가인이 성을 쌓고 그 아들의 이름으로 성을 이름하여 에녹이라 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","에녹이 이랏을 낳았고, 이랏은 므후야엘을 낳았고, 므후야엘은 므드사엘을 낳았고, 므드사엘은 라멕을 낳았더라 ");
INSERT INTO kor_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","라멕이 두 아내를 취하였으니 하나의 이름은 아다요, 하나의 이름은 씰라며 ");
INSERT INTO kor_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","아다는 야발을 낳았으니 그는 장막에 거하여 육축 치는 자의 조상이 되었고 ");
INSERT INTO kor_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","그 아우의 이름은 유발이니 그는 수금과 퉁소를 잡는 모든 자의 조상이 되었으며 ");
INSERT INTO kor_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","씰라는 두발가인을 낳았으니 그는 동,철로 각양 날카로운 기계를 만드는 자요 두발가인의 누이는 나아마이었더라 ");
INSERT INTO kor_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","라멕이 아내들에게 이르되 `아다와 씰라여 내 소리를 들으라 라멕의 아내들이여 ! 내 말을 들으라 나의 창상을 인하여 내가 사람을 죽였고 나의 상함을 인하여 소년을 죽였도다 ");
INSERT INTO kor_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","가인을 위하여는 벌이 칠배일진대 라멕을 위하여는 벌이 칠십 칠배이리로다' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","아담이 다시 아내와 동침하매 그가 아들을 낳아 그 이름을 셋이라 하였으니 `이는 하나님이 내게 가인의 죽인 아벨 대신에 다른 씨를 주셨다' 함이며 ");
INSERT INTO kor_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","셋도 아들을 낳고 그 이름을 에노스라 하였으며 그 때에 사람들이 비로소 여호와의 이름을 불렀더라 ");
INSERT INTO kor_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","아담 자손의 계보가 이러하니라 하나님이 사람을 창조하실 때에 하나님의 형상대로 지으시되 ");
INSERT INTO kor_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","남자와 여자를 창조하셨고 그들이 창조되던 날에 하나님이 그들에게 복을 주시고 그들의 이름을 사람이라 일컬으셨더라 ");
INSERT INTO kor_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","아담이 일백 삼십세에 자기 모양 곧 자기 형상과 같은 아들을 낳아 이름을 셋이라 하였고 ");
INSERT INTO kor_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","아담이 셋을 낳은 후 팔백년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","그가 구백 삼십세를 향수하고 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","셋은 일백 오세에 에노스를 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","에노스를 낳은 후 팔백 칠년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","그가 구백 십이세를 향수하고 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","에노스는 구십세에 게난을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","게난을 낳은 후 팔백 십 오년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","그가 구백 오세를 향수하고 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","게난은 칠십세에 마할랄렐을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","마할랄렐을 낳은 후 팔백 사십년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","그가 구백 십세를 향수하고 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","마할랄렐은 육십 오세에 야렛을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","야렛을 낳은 후 팔백 삼십년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","그가 팔백 구십 오세를 향수하고 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","야렛은 일백 육십 이세에 에녹을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","에녹을 낳은 후 팔백년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","그가 구백 육십 이세를 향수하고 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","에녹은 육십 오세에 므두셀라를 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","므두셀라를 낳은 후 삼백년을 하나님과 동행하며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","그가 삼백 육십 오세를 향수하였더라 ");
INSERT INTO kor_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","에녹이 하나님과 동행하더니 하나님이 그를 데려 가시므로 세상에 있지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","므두셀라는 일백 팔십 칠세에 라멕을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","라멕을 낳은 후 칠백 팔십 이년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","그는 구백 육십 구세를 향수하고 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","라멕은 일백 팔십 이세에 아들을 낳고 ");
INSERT INTO kor_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","이름을 노아라 하여 가로되 `여호와께서 땅을 저주하시므로 수고로이 일하는 우리를 이 아들이 안위하리라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","라멕이 노아를 낳은 후 오백 구십 오년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","그는 칠백 칠십 칠세를 향수하고 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","노아가 오백세 된 후에 셈과, 함과, 야벳을 낳았더라 ");
INSERT INTO kor_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","사람이 땅 위에 번성하기 시작할 때에 그들에게서 딸들이 나니 ");
INSERT INTO kor_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","하나님의 아들들이 사람의 딸들의 아름다움을 보고 자기들의 좋아하는 모든 자로 아내를 삼는지라 ");
INSERT INTO kor_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","여호와께서 가라사대 나의 신(神)이 영원히 사람과 함께하지 아니하리니 이는 그들이 육체가 됨이라 그러나 그들의 날은 일백 이십년이 되리라 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","당시에 땅에 네피림이 있었고 그 후에도 하나님의 아들들이 사람의 딸들을 취하여 자식을 낳았으니 그들이 용사라 고대에 유명한 사람이었더라 ");
INSERT INTO kor_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","여호와께서 사람의 죄악이 세상에 관영함과 그 마음의 생각의 모든 계획이 항상 악할 뿐임을 보시고 ");
INSERT INTO kor_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","땅위에 사람 지으셨음을 한탄하사 마음에 근심하시고 ");
INSERT INTO kor_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","가라사대 나의 창조한 사람을 내가 지면에서 쓸어 버리되 사람으로부터 육축과 기는 것과 공중의 새까지 그리하리니 이는 내가 그것을 지었음을 한탄함이니라 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","그러나 노아는 여호와께 은혜를 입었더라 ");
INSERT INTO kor_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","노아의 사적은 이러하니라 노아는 의인이요 당세에 완전한 자라 그가 하나님과 동행하였으며 ");
INSERT INTO kor_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","그가 세 아들을 낳았으니 셈과, 함과, 야벳이라 ");
INSERT INTO kor_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","때에 온 땅이 하나님 앞에 패괴하여 강포가 땅에 충만한지라 ");
INSERT INTO kor_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","하나님이 보신즉 땅이 패괴하였으니 이는 땅에서 모든 혈육 있는 자의 행위가 패괴함이었더라 ");
INSERT INTO kor_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","하나님이 노아에게 이르시되 모든 혈육있는 자의 강포가 땅에 가득하므로 그 끝날이 내 앞에 이르렀으니 내가 그들을 땅과 함께 멸하리라 ");
INSERT INTO kor_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","너는 잣나무로 너를 위하여 방주를 짓되 그 안에 간들을 막고 역청으로 그 안팎에 칠하라 ");
INSERT INTO kor_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","그 방주의 제도는 이러하니 장이 삼백 규빗, 광이 오십 규빗, 고가 삼십 규빗이며 ");
INSERT INTO kor_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","거기 창을 내되 위에서부터 한 규빗에 내고 그 문은 옆으로 내고 상 중 하 삼층으로 할지니라 ");
INSERT INTO kor_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","내가 홍수를 땅에 일으켜 무릇 생명의 기식 있는 육체를 천하에서 멸절하리니 땅에 있는 자가 다 죽으리라 ");
INSERT INTO kor_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","그러나 너와는 내가 내 언약을 세우리니 너는 네 아들들과 네 아내와 네 자부들과 함께 그 방주로 들어가고 ");
INSERT INTO kor_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","혈육 있는 모든 생물을 너는 각기 암,수 한쌍씩 방주로 이끌어 들여 너와 함께 생명을 보존케 하되 ");
INSERT INTO kor_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","새가 그 종류대로, 육축이 그 종류대로, 땅에 기는 모든 것이 그 종류대로, 각기 둘씩 네게로 나아오리니 그 생명을 보존케하라 ");
INSERT INTO kor_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","너는 먹을 모든 식물을 네게로 가져다가 저축하라 이것이 너와 그들의 식물이 되리라 ");
INSERT INTO kor_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","노아가 그와 같이 하되 하나님이 자기에게 명하신 대로 다 준행하였더라 ! ");
INSERT INTO kor_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","여호와께서 노아에게 이르시되 너와 네 온 집은 방주로 들어가라 네가 이 세대에 내 앞에서 의로움을 내가 보았음이니라 ! ");
INSERT INTO kor_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","너는 모든 정결한 짐승은 암수 일곱씩 부정한 것은 암수 둘씩을 네게로 취하며 ");
INSERT INTO kor_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","공중의 새도 암수 일곱씩을 취하여 그 씨를 온 지면에 유전케하라 ");
INSERT INTO kor_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","지금부터 칠일이면 내가 사십 주야를 땅에 비를 내려 나의 지은 모든 생물을 지면에서 쓸어 버리리라 ");
INSERT INTO kor_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","노아가 여호와께서 자기에게 명하신 대로 다 준행하였더라 ! ");
INSERT INTO kor_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","홍수가 땅에 있을 때에 노아가 육백세라 ");
INSERT INTO kor_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","노아가 아들들과 아내와 자부들과 함께 홍수를 피하여 방주에 들어갔고 ");
INSERT INTO kor_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","정결한 짐승과 부정한 짐승과 새와 땅에 기는 모든 것이 ");
INSERT INTO kor_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","하나님이 노아에게 명하신 대로 암수 둘씩 노아에게 나아와 방주로 들어갔더니 ");
INSERT INTO kor_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","칠일 후에 홍수가 땅에 덮이니 ");
INSERT INTO kor_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","노아 육백세 되던 해 이월 곧 그 달 십 칠일이라 그날에 큰 깊음의 샘들이 터지며 하늘의 창들이 열려 ");
INSERT INTO kor_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","사십 주야를 비가 땅에 쏟아졌더라 ");
INSERT INTO kor_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","곧 그 날에 노아와 그의 아들 셈, 함, 야벳과 노아의 처와 세 자부가 다 방주로 들어갔고 ");
INSERT INTO kor_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","그들과 모든 들짐승이 그 종류대로, 모든 육축이 그 종류대로, 땅에 기는 모든 것이 그 종류대로, 모든 새 곧 각양의 새가 그 종류대로 ");
INSERT INTO kor_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","무릇 기식이 있는 육체가 둘씩 노아에게 나아와 방주로 들어갔으니 ");
INSERT INTO kor_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","들어간 것들은 모든 것의 암,수라 하나님이 그에게 명하신대로 들어가매 여호와께서 그를 닫아 넣으시니라 ");
INSERT INTO kor_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","홍수가 땅에 사십일을 있었는지라 물이 많아져 방주가 땅에서 올랐고 ");
INSERT INTO kor_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","물이 더 많아져 땅에 창일하매 방주가 물 위에 떠 다녔으며 ");
INSERT INTO kor_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","물이 땅에 더욱 창일하매 천하에 높은 산이 다 덮였더니 ");
INSERT INTO kor_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","물이 불어서 십오 규빗이 오르매 산들이 덮인지라 ");
INSERT INTO kor_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","땅위에 움직이는 생물이 다 죽었으니 곧 새와 육축과 들짐승과 땅에 기는 모든 것과 모든 사람이라 ");
INSERT INTO kor_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","육지에 있어 코로 생물의 기식을 호흡하는 것은 다 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","지면의 모든 생물을 쓸어버리시니 곧 사람과 짐승과 기는 것과 공중의 새까지라 이들은 땅에서 쓸어버림을 당하였으되 홀로 노아와 그와 함께 방주에 있던 자만 남았더라 ");
INSERT INTO kor_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","물이 일백 오십일을 땅에 창일하였더라 ");
INSERT INTO kor_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","하나님이 노아와 그와 함께 방주에 있는 모든 들짐승과 육축을 권념하사 바람으로 땅 위에 불게 하시매 물이 감하였고 ");
INSERT INTO kor_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","깊음의 샘과 하늘의 창이 막히고 하늘에서 비가 그치매 ");
INSERT INTO kor_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","물이 땅에서 물러가고 점점 물러가서 일백 오십일 후에 감하고 ");
INSERT INTO kor_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","칠월 곧 그 달 십칠일에 방주가 아라랏 산에 머물렀으며 ");
INSERT INTO kor_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","물이 점점 감하여 시월 곧 그달 일일에 산들의 봉우리가 보였더라 ");
INSERT INTO kor_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","사십일을 지나서 노아가 그 방주에 지은 창을 열고 ");
INSERT INTO kor_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","까마귀를 내어 놓으매 까마귀가 물이 땅에서 마르기까지 날아 왕래하였더라 ");
INSERT INTO kor_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","그가 또 비둘기를 내어 놓아 지면에 물이 감한 여부를 알고자 하매 ");
INSERT INTO kor_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","온 지면에 물이 있으므로 비둘기가 접족할 곳을 찾지 못하고 방주로 돌아와 그에게로 오는지라 그가 손을 내밀어 방주 속 자기에게로 받아 들이고 ");
INSERT INTO kor_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","또 칠일을 기다려 다시 비둘기를 방주에서 내어 놓으매 ");
INSERT INTO kor_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","저녁때에 비둘기가 그에게로 돌아왔는데 그 입에 감람 새 잎사귀가 있는지라 이에 노아가 땅에 물이 감한 줄 알았으며 ");
INSERT INTO kor_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","또 칠일을 기다려 비둘기를 내어 놓으매 다시는 그에게로 돌아오지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","육백 일년 정월 곧 그 달 일일에 지면에 물이 걷힌지라 노아가 방주 뚜껑을 제치고 본즉 지면에 물이 걷혔더니 ");
INSERT INTO kor_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","이월 이십 칠일에 땅이 말랐더라 ");
INSERT INTO kor_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","하나님이 노아에게 말씀하여 가라사대 ");
INSERT INTO kor_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","너는 네 아내와 네 아들들과 네 자부들로 더불어 방주에서 나오고 ");
INSERT INTO kor_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","너와 함께 한 모든 혈육 있는 생물 곧 새와 육축과 땅에 기는 모든 것을 다 이끌어 내라 이것들이 땅에서 생육하고 땅에서 번성하리라 하시매 ");
INSERT INTO kor_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","노아가 그 아들들과 그 아내와 그 자부들과 함께 나왔고 ");
INSERT INTO kor_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","땅위의 동물 곧 모든 짐승과 모든 기는 것과 모든 새도 그 종류대로 방주에서 나왔더라 ");
INSERT INTO kor_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","노아가 여호와를 위하여 단을 쌓고 모든 정결한 짐승 중에서와 모든 정결한 새 중에서 취하여 번제로 단에 드렸더니 ");
INSERT INTO kor_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","여호와께서 그 향기를 흠향하시고 그 중심에 이르시되 내가 다시는 사람으로 인하여 땅을 저주하지 아니하리니 이는 사람의 마음의 계획하는 바가 어려서부터 악함이라 내가 전에 행한 것 같이 모든 생물을 멸하지 아니하리니 ");
INSERT INTO kor_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","땅이 있을 동안에는 심음과, 거둠과, 추위와, 더위와, 여름과, 겨울과, 낮과, 밤이 쉬지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","하나님이 노아와 그 아들들에게 복을 주시며 그들에게 이르시되 생육하고 번성하여 땅에 충만하라 ! ");
INSERT INTO kor_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","땅의 모든 짐승과 공중의 모든 새와 땅에 기는 모든 것과 바다의 모든 고기가 너희를 두려워하며 너희를 무서워하리니 이들은 너희 손에 붙이웠음이라 ");
INSERT INTO kor_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","무릇 산 동물은 너희의 식물이 될지라 채소같이 내가 이것을 다 너희에게 주노라 ");
INSERT INTO kor_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","그러나 고기를 그 생명 되는 피 채 먹지 말 것이니라 ");
INSERT INTO kor_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","내가 반드시 너희 피 곧 너희 생명의 피를 찾으리니 짐승이면 그 짐승에게서, 사람이나 사람의 형제면 그에게서 그의 생명을 찾으리라 ");
INSERT INTO kor_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","무릇 사람의 피를 흘리면 사람이 그 피를 흘릴 것이니 이는 하나님이 자기 형상대로 사람을 지었음이니라 ");
INSERT INTO kor_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","너희는 생육하고 번성하며 땅에 편만하여 그 중에서 번성하라 하셨더라 ");
INSERT INTO kor_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","하나님이 노아와 그와 함께 한 아들들에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","내가 내 언약을 너희와 너희 후손과 ");
INSERT INTO kor_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","너희와 함께 한 모든 생물 곧 너희와 함께 한 새와 육축과 땅의 모든 생물에게 세우리니 방주에서 나온 모든 것 곧 땅의 모든 짐승에게니라 ");
INSERT INTO kor_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","내가 너희와 언약을 세우리니 다시는 모든 생물을 홍수로 멸하지 아니할 것이라 땅을 침몰할 홍수가 다시 있지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","하나님이 가라사대 내가 나와 너희와 및 너희와 함께 하는 모든 생물 사이에 영세까지 세우는 언약의 증거는 이것이라 ");
INSERT INTO kor_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","내가 내 무지개를 구름 속에 두었나니 이것이 나의 세상과의 언약의 증거니라 ");
INSERT INTO kor_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","내가 구름으로 땅을 덮을 때에 무지개가 구름 속에 나타나면 ");
INSERT INTO kor_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","내가 나와 너희와 및 혈기 있는 모든 생물사이의 내 언약을 기억하리니 다시는 물이 모든 혈기 있는 자를 멸하는 홍수가 되지 아니할지라 ");
INSERT INTO kor_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","무지개가 구름 사이에 있으리니 내가 보고 나 하나님과 땅의 무릇 혈기 있는 모든 생물 사이에 된 영원한 언약을 기억하리라 ");
INSERT INTO kor_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","하나님이 노아에게 또 이르시되 내가 나와 땅에 있는 모든 생물 사이에 세운 언약의 증거가 이것이라 하셨더라 ");
INSERT INTO kor_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","방주에서 나온 노아의 아들들은 셈과, 함과, 야벳이며 함은 가나안의 아비라 ");
INSERT INTO kor_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","노아의 이 세 아들로 좇아 백성이 온 땅에 퍼지니라 ");
INSERT INTO kor_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","노아가 농업을 시작하여 포도나무를 심었더니 ");
INSERT INTO kor_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","포도주를 마시고 취하여 그 장막 안에서 벌거벗은지라 ");
INSERT INTO kor_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","가나안의 아비 함이 그 아비의 하체를 보고 밖으로 나가서 두 형제에게 고하매 ");
INSERT INTO kor_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","셈과 야벳이 옷을 취하여 자기들의 어깨에 메고 뒷걸음쳐 들어가서 아비의 하체에 덮었으며 그들이 얼굴을 돌이키고 그 아비의 하체를 보지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","노아가 술이 깨어 그 작은 아들이 자기에게 행한 일을 알고 ");
INSERT INTO kor_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","이에 가로되 `가나안은 저주를 받아 그 형제의 종들의 종이 되기를 원하노라' ");
INSERT INTO kor_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","또 가로되 `셈의 하나님 여호와를 찬송하리로다 ! 가나안은 셈의 종이 되고 ");
INSERT INTO kor_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","하나님이 야벳을 창대케하사 셈의 장막에 거하게 하시고 가나안은 그의 종이 되게 하시기를 원하노라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","홍수 후에 노아가 삼백 오십년을 지내었고 ");
INSERT INTO kor_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","향년이 구백 오십세에 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","노아의 아들 셈과, 함과, 야벳의 후예는 이러하니라 홍수 후에 그들이 아들들을 낳았으니 ");
INSERT INTO kor_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","야벳의 아들은 고멜과, 마곡과, 마대와, 야완과, 두발과, 메섹과, 디라스요 ");
INSERT INTO kor_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","고멜의 아들은 아스그나스와, 리밧과, 도갈마요 ");
INSERT INTO kor_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","야완의 아들은 엘리사와, 달시스와, 깃딤과, 도다님이라 ");
INSERT INTO kor_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","이들로부터 여러 나라 백성으로 나뉘어서 각기 방언과 종족과 나라대로 바닷가의 땅에 머물렀더라 ");
INSERT INTO kor_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","함의 아들은 구스와, 미스라임과, 붓과, 가나안이요 ");
INSERT INTO kor_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","구스의 아들은 스바와, 하윌라와, 삽다와, 라아마와, 삽드가요, 라아마의 아들은 스바와, 드단이며 ");
INSERT INTO kor_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","구스가 또 니므롯을 낳았으니 그는 세상에 처음 영걸이라 ");
INSERT INTO kor_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","그가 여호와 앞에서 특이한 사냥군이 되었으므로 속담에 이르기를 아무는 여호와 앞에 니므롯 같은 특이한 사냥군이로다 하더라 ");
INSERT INTO kor_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","그의 나라는 시날땅의 바벨과, 에렉과, 악갓과, 갈레에서 시작되었으며 ");
INSERT INTO kor_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","그가 그 땅에서 앗수르로 나아가 니느웨와, 르호보딜과, 갈라와 ");
INSERT INTO kor_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","및 니느웨와 갈라 사이의 레센(이는 큰 성이라)을 건축하였으며 ");
INSERT INTO kor_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","미스라임은 루딤과, 아나밈과, 르하빔과, 납두힘과 ");
INSERT INTO kor_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","바드루심과, 가슬루힘과, 갑도림을 낳았더라 (블레셋이 가슬루힘에게서 나왔더라) ");
INSERT INTO kor_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","가나안은 장자 시돈과, 헷을 낳고 ");
INSERT INTO kor_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","또 여부스 족속과, 아모리 족속과, 기르가스 족속과 ");
INSERT INTO kor_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","히위 족속과, 알가 족속과, 신 족속과 ");
INSERT INTO kor_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","아르왓 족속과, 스말 족속과, 하맛 족속의 조상을 낳았더니 이 후로 가나안 자손의 족속이 흩어져 처하였더라 ");
INSERT INTO kor_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","가나안의 지경은 시돈에서부터 그랄을 지나 가사까지와, 소돔과, 고모라와, 아드마와, 스보임을 지나 라사까지였더라 ");
INSERT INTO kor_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","이들은 함의 자손이라 각기 족속과 방언과 지방과 나라대로이었더라 ");
INSERT INTO kor_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","셈은 에벨 온 자손의 조상이요 야벳의 형이라 그에게도 자녀가 출생하였으니 ");
INSERT INTO kor_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","셈의 아들은 엘람과, 앗수르와, 아르박삿과, 룻과, 아람이요 ");
INSERT INTO kor_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","아람의 아들은 우스와, 훌과, 게델과, 마스며 ");
INSERT INTO kor_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","아르박삿은 셀라를 낳고, 셀라는 에벨을 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","에벨은 두 아들을 낳고, 하나의 이름을 벨렉이라 하였으니 그 때에 세상이 나뉘었음이요 벨렉의 아우의 이름은 욕단이며 ");
INSERT INTO kor_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","욕단은 알모닷과, 셀렙과, 하살마웹과, 예라와 ");
INSERT INTO kor_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","하도람과, 우살과, 디글라와 ");
INSERT INTO kor_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","오발과, 아비마엘과, 스바와 ");
INSERT INTO kor_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","오빌과, 하윌라와, 요밥을 낳았으니 이들은 다 욕단의 아들이며 ");
INSERT INTO kor_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","그들의 거하는 곳은 메사에서부터 스발로 가는 길의 동편 산이었더라 ");
INSERT INTO kor_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","이들은 셈의 자손이라 그 족속과 방언과 지방과 나라대로였더라 ");
INSERT INTO kor_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","이들은 노아 자손의 족속들이요 그 세계와 나라대로라 홍수 후에 이들에게서 땅의 열국 백성이 나뉘었더라 ");
INSERT INTO kor_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","온 땅의 구음이 하나이요 언어가 하나이었더라 ");
INSERT INTO kor_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","이에 그들이 동방으로 옮기다가 시날 평지를 만나 거기 거하고 ");
INSERT INTO kor_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","서로 말하되 `자, 벽돌을 만들어 견고히 굽자' 하고 이에 벽돌로 돌을 대신하며 역청으로 진흙을 대신하고 ");
INSERT INTO kor_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","또 말하되 `자, 성과 대를 쌓아 대 꼭대기를 하늘에 닿게 하여 우리 이름을 내고 온 지면에 흩어짐을 면하자' 하였더니 ");
INSERT INTO kor_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","여호와께서 인생들의 쌓는 성과 대를 보시려고 강림하셨더라 ");
INSERT INTO kor_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","여호와께서 가라사대 이 무리가 한 족속이요, 언어도 하나이므로 이같이 시작하였으니 이후로는 그 경영하는 일을 금지할 수 없으리로다 ");
INSERT INTO kor_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","자, 우리가 내려가서 거기서 그들의 언어를 혼잡케 하여 그들로 서로 알아듣지 못하게 하자 하시고 ");
INSERT INTO kor_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","여호와께서 거기서 그들을 온 지면에 흩으신 고로 그들이 성 쌓기를 그쳤더라 ");
INSERT INTO kor_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","그러므로 그 이름을 바벨이라 하니 이는 여호와께서 거기서 온 땅의 언어를 혼잡케 하셨음이라 여호와께서 거기서 그들을 온 지면에 흩으셨더라 ");
INSERT INTO kor_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","셈의 후예는 이러하니라 셈은 일백세 곧 홍수 후 이년에 아르박삿을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","아르박삿을 낳은 후에 오백년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","아르박삿은 삼십 오세에 셀라를 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","셀라를 낳은 후에 사백 삼년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","셀라는 삼십세에 에벨을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","에벨을 낳은 후에 사백 삼년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","에벨은 삼십 사세에 벨렉을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","벨렉을 낳은 후에 사백 삼십년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","벨렉은 삼십세에 르우를 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","르우를 낳은 후에 이백 구년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","르우는 삼십 이세에 스룩을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","스룩을 낳은 후에 이백 칠년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","스룩은 삼십세에 나홀을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","나홀을 낳은 후에 이백년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","나홀은 이십 구세에 데라를 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","데라를 낳은 후에 일백 십 구년을 지내며 자녀를 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","데라는 칠십세에 아브람과, 나홀과, 하란을 낳았더라 ");
INSERT INTO kor_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","데라의 후예는 이러하니라 데라는 아브람과, 나홀과, 하란을 낳았고 하란은 롯을 낳았으며 ");
INSERT INTO kor_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","하란은 그 아비 데라보다 먼저 본토 갈대아 우르에서 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","아브람과 나홀이 장가 들었으니 아브람의 아내 이름은 사래며 나홀의 아내 이름은 밀가니 하란의 딸이요 하란은 밀가의 아비며 또 이스가의 아비더라 ");
INSERT INTO kor_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","사래는 잉태하지 못하므로 자식이 없었더라 ");
INSERT INTO kor_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","데라가 그 아들 아브람과 하란의 아들 그 손자 롯과 그 자부 아브람의 아내 사래를 데리고 갈대아 우르에서 떠나 가나안 땅으로 가고자 하더니 하란에 이르러 거기 거하였으며 ");
INSERT INTO kor_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","데라는 이백 오세를 향수하고 하란에서 죽었더라 ");
INSERT INTO kor_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","여호와께서 아브람에게 이르시되 너는 너의 본토 친척 아비 집을 떠나 내가 네게 지시할 땅으로 가라 ");
INSERT INTO kor_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","내가 너로 큰 민족을 이루고 네게 복을 주어 네 이름을 창대케 하리니 너는 복의 근원이 될지라 ! ");
INSERT INTO kor_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","너를 축복하는 자에게는 내가 복을 내리고 너를 저주하는 자에게는 내가 저주하리니 땅의 모든 족속이 너를 인하여 복을 얻을 것이니라 하신지라 ");
INSERT INTO kor_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","이에 아브람이 여호와의 말씀을 좇아 갔고 롯도 그와 함께 갔으며 아브람이 하란을 떠날 때에 그 나이 칠십 오세였더라 ");
INSERT INTO kor_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","아브람이 그 아내 사래와 조카 롯과 하란에서 모은 모든 소유와 얻은 사람들을 이끌고 가나안 땅으로 가려고 떠나서 마침내 가나안 땅에 들어 갔더라 ");
INSERT INTO kor_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","아브람이 그 땅을 통과하여 세겜 땅 모레 상수리 나무에 이르니 그 때에 가나안 사람이 그 땅에 거하였더라 ");
INSERT INTO kor_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","여호와께서 아브람에게 나타나 가라사대 내가 이 땅을 네 자손에게 주리라 하신지라 그가 자기에게 나타나신 여호와를 위하여 그 곳에 단을 쌓고 ");
INSERT INTO kor_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","거기서 벧엘 동편 산으로 옮겨 장막을 치니 서는 벧엘이요, 동은 아이라 그가 그 곳에서 여호와를 위하여 단을 쌓고 여호와의 이름을 부르더니 ");
INSERT INTO kor_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","점점 남방으로 옮겨 갔더라 ");
INSERT INTO kor_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","그 땅에 기근이 있으므로 아브람이 애굽에 우거하려 하여 그리로 내려갔으니 이는 그 땅에 기근이 심하였음이라 ");
INSERT INTO kor_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","그가 애굽에 가까이 이를 때에 그 아내 사래더러 말하되 `나 알기에 그대는 아리따운 여인이라 ");
INSERT INTO kor_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","애굽 사람이 그대를 볼 때에 이르기를 이는 그의 아내라 하고 나는 죽이고 그대는 살리리니 ");
INSERT INTO kor_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","원컨대 그대는 나의 누이라 하라 그리하면 내가 그대로 인하여 안전하고 내 목숨이 그대로 인하여 보존하겠노라' 하니라 ");
INSERT INTO kor_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","아브람이 애굽에 이르렀을 때에 애굽 사람들이 그 여인의 심히 아리따움을 보았고 ");
INSERT INTO kor_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","바로의 대신들도 그를 보고 바로 앞에 칭찬하므로 그 여인을 바로의 궁으로 취하여 들인지라 ");
INSERT INTO kor_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","이에 바로가 그를 인하여 아브람을 후대하므로 아브람이 양과, 소와, 노비와, 암수 나귀와, 약대를 얻었더라 ");
INSERT INTO kor_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","여호와께서 아브람의 아내 사래의 연고로 바로와 그 집에 큰 재앙을 내리신지라 ");
INSERT INTO kor_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","바로가 아브람을 불러서 이르되 `네가 어찌하여 나를 이렇게 대접하였느냐 ? 네가 어찌하여 그를 네 아내라고 내게 고하지 아니하였느냐 ? ");
INSERT INTO kor_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","네가 어찌 그를 누이라 하여 나로 그를 취하여 아내를 삼게 하였느냐 ? 네 아내가 여기 있으니 이제 데려 가라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","바로가 사람들에게 그의 일을 명하매 그들이 그 아내와 그 모든 소유를 보내었더라 ");
INSERT INTO kor_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","아브람이 애굽에서 나올새 그와 그 아내와 모든 소유며 롯도 함께 하여 남방으로 올라가니 ");
INSERT INTO kor_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","아브람에게 육축과 은,금이 풍부하였더라 ");
INSERT INTO kor_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","그가 남방에서부터 발행하여 벧엘에 이르며 벧엘과 아이 사이 전에 장막 쳤던 곳에 이르니 ");
INSERT INTO kor_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","그가 처음으로 단을 쌓은 곳이라 그가 거기서 여호와의 이름을 불렀더라 ");
INSERT INTO kor_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","아브람의 일행 롯도 양과 소와 장막이 있으므로 ");
INSERT INTO kor_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","그 땅이 그들의 동거함을 용납지 못하였으니 곧 그들의 소유가 많아서 동거할 수 없었음이라 ");
INSERT INTO kor_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","그러므로 아브람의 가축의 목자와 롯의 가축의 목자가 서로 다투고 또 가나안 사람과 브리스 사람도 그 땅에 거하였는지라 ");
INSERT INTO kor_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","아브람이 롯에게 이르되 `우리는 한 골육이라 나나, 너나, 내 목자나, 네 목자나 서로 다투게 말자 ");
INSERT INTO kor_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","네 앞에 온 땅이 있지 아니하냐 ? 나를 떠나라 네가 좌하면 나는 우하고, 네가 우하면 나는 좌하리라' ");
INSERT INTO kor_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","이에 롯이 눈을 들어 요단들을 바라본즉 소알까지 온 땅에 물이 넉넉하니 여호와께서 소돔과 고모라를 멸하시기 전이었는고로 여호와의 동산같고 애굽 땅과 같았더라 ");
INSERT INTO kor_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","그러므로 롯이 요단 온 들을 택하고 동으로 옮기니 그들이 서로 떠난지라 ");
INSERT INTO kor_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","아브람은 가나안 땅에 거하였고 롯은 평지 성읍들에 머무르며 그 장막을 옮겨 소돔까지 이르렀더라 ");
INSERT INTO kor_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","소돔 사람은 악하여 여호와 앞에 큰 죄인이었더라 ");
INSERT INTO kor_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","롯이 아브람을 떠난 후에 여호와께서 아브람에게 이르시되 너는 눈을 들어 너 있는 곳에서 동서남북을 바라보라 ! ");
INSERT INTO kor_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","보이는 땅을 내가 너와 네 자손에게 주리니 영원히 이르리라 ");
INSERT INTO kor_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","내가 네 자손으로 땅의 티끌 같게 하리니 사람이 땅의 티끌을 능히 셀수 있을진대 네 자손도 세리라 ");
INSERT INTO kor_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","너는 일어나 그 땅을 종과 횡으로 행하여 보라 ! 내가 그것을 네게 주리라 ");
INSERT INTO kor_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","이에 아브람이 장막을 옮겨 헤브론에 있는 마므레 상수리 수풀에 이르러 거하며 거기서 여호와를 위하여 단을 쌓았더라 ");
INSERT INTO kor_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","당시에 시날 왕 아므라벨과, 엘라살 왕 아리옥과, 엘람 왕 그돌라오멜과, 고임 왕 디달이 ");
INSERT INTO kor_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","소돔 왕 베라와, 고모라 왕 비르사와, 아드마 왕 시납과, 수보임 왕 세메벨과, 벨라 곧 소알 왕과 싸우니라 ");
INSERT INTO kor_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","이들이 다 싯딤 골짜기 곧 지금 염해에 모였더라 ");
INSERT INTO kor_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","이들이 십 이년 동안 그돌라오멜을 섬기다가 제 십 삼년에 배반한지라 ");
INSERT INTO kor_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","제 십 사년에 그돌라오멜과 그와 동맹한 왕들이 나와서 아스드롯 가르나임에서 르바 족속을, 함에서 수스 족속을, 사웨기랴다임에서 엠 족속을 치고 ");
INSERT INTO kor_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","호리 족속을 그 산 세일에서 쳐서 광야 근방 엘바란까지 이르렀으며 ");
INSERT INTO kor_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","그들이 돌이켜 엔미스밧 곧 가데스에 이르러 아말렉 족속의 온 땅과 하사손다말에 사는 아모리 족속을 친지라 ");
INSERT INTO kor_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","소돔 왕과, 고모라 왕과, 아드마 왕과, 스보임 왕과, 벨라 곧 소알 왕이 나와서 싯딤 골짜기에서 그들과 접전하였으니 ");
INSERT INTO kor_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","곧 그 다섯 왕이 엘람 왕 그돌라오멜과, 고임 왕 디달과, 시날 왕 아므라벨과, 엘라살 왕 아리옥 네 왕과 교전하였더라 ");
INSERT INTO kor_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","싯딤 골짜기에는 역청 구덩이가 많은지라 소돔 왕과 고모라 왕이 달아날 때에 군사가 거기 빠지고 그 나머지는 산으로 도망하매 ");
INSERT INTO kor_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","네 왕이 소돔과 고모라의 모든 재물과 양식을 빼앗아 가고 ");
INSERT INTO kor_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","소돔에 거하는 아브람의 조카 롯도 사로잡고 그 재물까지 노략하여 갔더라 ");
INSERT INTO kor_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","도망한 자가 와서 히브리 사람 아브람에게 고하니 때에 아브람이 아모리 족속 마므레의 상수리 수풀 근처에 거하였더라 마므레는 에스골의 형제요 또 아넬의 형제라 이들은 아브람과 동맹한 자더라 ");
INSERT INTO kor_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","아브람이 그 조카의 사로 잡혔음을 듣고 집에서 길리고 연습한 자 삼백 십 팔인을 거느리고 단까지 쫓아가서 ");
INSERT INTO kor_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","그 가신을 나누어 밤을 타서 그들을 쳐서 파하고 다메섹 좌편 호바까지 쫓아가서 ");
INSERT INTO kor_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","모든 빼앗겼던 재물과 자기 조카 롯과 그 재물과 또 부녀와 인민을 다 찾아 왔더라 ");
INSERT INTO kor_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","아브람이 그돌라오멜과 그와 함께 한 왕들을 파하고 돌아올때에 소돔 왕이 사웨 골짜기 곧 왕곡에 나와 그를 영접하였고 ");
INSERT INTO kor_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","살렘 왕 멜기세덱이 떡과 포도주를 가지고 나왔으니 그는 지극히 높으신 하나님의 제사장이었더라 ");
INSERT INTO kor_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","그가 아브람에게 축복하여 가로되 `천지의 주재시요, 지극히 높으신 하나님이여 아브람에게 복을 주옵소서 ! ");
INSERT INTO kor_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","너희 대적을 네 손에 붙이신 지극히 높으신 하나님을 찬송할지로다 !' 하매 아브람이 그 얻은 것에서 십분 일을 멜기세덱에게 주었더라 ");
INSERT INTO kor_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","소돔 왕이 아브람에게 이르되 `사람은 내게 보내고 물품은 네가 취하라' ");
INSERT INTO kor_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","아브람이 소돔 왕에게 이르되 `천지의 주재시요 지극히 높으신 하나님 여호와께 내가 손을 들어 맹세하노니 ");
INSERT INTO kor_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","네 말이 내가 아브람으로 치부케 하였다 할까 하여 네게 속한 것은 무론 한 실이나 신들메라도 내가 취하지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","오직 소년들의 먹은 것과 나와 동행한 아넬과 에스골과 마므레의 분깃을 제할지니 그들이 그 분깃을 취할 것이니라' ");
INSERT INTO kor_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","이 후에 여호와의 말씀이 이상 중에 아브람에게 임하여 가라사대 아브람아 두려워 말라! 나는 너의 방패요, 너의 지극히 큰 상급이니라 ");
INSERT INTO kor_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","아브람이 가로되 `주 여호와여 무엇을 내게 주시려나이까 ? 나는 무자하오니 나의 상속자는 이 다메섹 엘리에셀이니이다' ");
INSERT INTO kor_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","아브람이 또 가로되 `주께서 내게 씨를 아니주셨으니 내 집에서 길리운 자가 나의 후사가 될 것이니이다' ");
INSERT INTO kor_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","여호와의 말씀이 그에게 임하여 가라사대 그 사람은 너의 후사가 아니라 네 몸에서 날 자가 네 후사가 되리라 하시고 ");
INSERT INTO kor_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","그를 이끌고 밖으로 나가 가라사대 하늘을 우러러 뭇 별을 셀 수 있나 보라 ! 또 그에게 이르시되 네 자손이 이와 같으리라 ");
INSERT INTO kor_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","아브람이 여호와를 믿으니 여호와께서 이를 그의 의로 여기시고 ");
INSERT INTO kor_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","또 그에게 이르시되 나는 이 땅을 네게 주어 업을 삼게 하려고 너를 갈대아 우르에서 이끌어 낸 여호와로라 ! ");
INSERT INTO kor_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","그가 가로되 `주, 여호와여 ! 내가 이 땅으로 업을 삼을 줄을 무엇로 알리이까 ?' ");
INSERT INTO kor_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","여호와께서 그에게 이르시되 나를 위하여 삼년 된 암소와, 삼년 된 암염소와, 삼년 된 수양과, 산비둘기와, 집비둘기 새끼를 취할지니라 ");
INSERT INTO kor_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","아브람이 그 모든 것을 취하여 그 중간을 쪼개고 그 쪼갠 것을 마주 대하여 놓고 그 새는 쪼개지 아니하였으며 ");
INSERT INTO kor_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","솔개가 그 사체위에 내릴 때에는 아브람이 쫓았더라 ");
INSERT INTO kor_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","해질 때에 아브람이 깊이 잠든 중에 캄캄함이 임하므로 심히 두려워하더니 ");
INSERT INTO kor_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","여호와께서 아브람에게 이르시되 너는 정녕히 알라 네 자손이 이방에서 객이 되어 그들을 섬기겠고 그들은 사백 년 동안 네 자손을 괴롭게 하리니 ");
INSERT INTO kor_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","그 섬기는 나라를 내가 징치할지며 그 후에 네 자손이 큰 재물을 이끌고 나오리라 ");
INSERT INTO kor_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","너는 장수하다가 평안히 조상에게로 돌아가 장사될 것이요 ");
INSERT INTO kor_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","네 자손은 사 대만에 이 땅으로 돌아 오리니 이는 아모리 족속의 죄악이 아직 관영치 아니함이니라 하시더니 ");
INSERT INTO kor_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","해가 져서 어둘 때에 연기 나는 풀무가 보이며 타는 횃불이 쪼갠 고기 사이로 지나더라 ");
INSERT INTO kor_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","그 날에 여호와께서 아브람으로 더불어 언약을 세워 가라사대 내가 이땅을 애굽강에서부터 그 큰 강 유브라데까지 네 자손에게 주노니 ");
INSERT INTO kor_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","곧 겐 족속과, 그니스 족속과, 갓몬 족속과, ");
INSERT INTO kor_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","헷 족속과, 브리스 족속과, 르바 족속과, ");
INSERT INTO kor_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","아모리 족속과, 가나안 족속과, 기르가스 족속과, 여부스 족속의 땅이니라 하셨더라 ");
INSERT INTO kor_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","아브람의 아내 사래는 생산치 못하였고 그에게 한 여종이 있으니 애굽 사람이요 이름은 하갈이라 ");
INSERT INTO kor_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","사래가 아브람에게 이르되 `여호와께서 나의 생산을 허락지 아니하셨으니 원컨대 나의 여종과 동침하라 내가 혹 그로 말미암아 자녀를 얻을까 하노라' 하매 아브람이 사래의 말을 들으니라 ");
INSERT INTO kor_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","아브람의 아내 사래가 그 여종 애굽 사람 하갈을 가져 그 남편 아브람에게 첩으로 준 때는 아브람이 가나안 땅에 거한지 십년 후이었더라 ");
INSERT INTO kor_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","아브람이 하갈과 동침하였더니 하갈이 잉태하매 그가 자기의 잉태함을 깨닫고 그 여주인을 멸시한지라 ");
INSERT INTO kor_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","사래가 아브람에게 이르되 `나의 받는 욕은 당신이 받아야 옳도다 내가 나의 여종을 당신의 품에 두었거늘 그가 자기의 잉태함을 깨닫고 나를 멸시하니 당신과 나 사이에 여호와께서 판단하시기를 원하노라' ");
INSERT INTO kor_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","아브람이 사래에게 이르되 `그대의 여종은 그대의 수중에 있으니 그대의 눈에 좋은대로 그에게 행하라' 하매 사래가 하갈을 학대하였더니 하갈이 사래의 앞에서 도망하였더라 ");
INSERT INTO kor_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","여호와의 사자가 광야의 샘 곁 곧 술 길 샘물 곁에서 그를 만나 ");
INSERT INTO kor_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","가로되 `사래의 여종 하갈아 네가 어디서 왔으며 어디로 가느냐 ?' 그가 가로되 `나는 나의 여주인 사래를 피하여 도망하나이다' ");
INSERT INTO kor_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","여호와의 사자가 그에게 이르되 네 여주인에게로 돌아가서 그 수하에 복종하라 ");
INSERT INTO kor_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","여호와의 사자가 또 그에게 이르되 `내가 네 자손으로 크게 번성하여 그 수가 많아 셀 수 없게 하리라 ");
INSERT INTO kor_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","여호와의 사자가 또 그에게 이르되 네가 잉태하였은즉 아들을 낳으리니 그 이름을 이스마엘이라 하라 이는 여호와께서 네 고통을 들으셨음이니라 ");
INSERT INTO kor_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","그가 사람 중에 들나귀 같이 되리니 그 손이 모든 사람을 치겠고 모든 사람의 손이 그를 칠지며 그가 모든 형제의 동방에서 살리라' 하니라 ");
INSERT INTO kor_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","하갈이 자기에게 이르신 여호와의 이름을 감찰하시는 하나님이라 하였으니 이는 `내가 어떻게 여기서 나를 감찰하시는 하나님을 뵈었는고' 함이라 ");
INSERT INTO kor_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","이러므로 그 샘을 브엘라해로이라 불렀으며 그것이 가데스와 베렛 사이에 있더라 ");
INSERT INTO kor_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","하갈이 아브람의 아들을 낳으매 아브람이 하갈의 낳은 그 아들을 이름하여 이스마엘이라 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","하갈이 아브람에게 이스마엘을 낳을 때에 아브람이 팔십 육세이었더라 ");
INSERT INTO kor_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","아브람의 구십 구세 때에 여호와께서 아브람에게 나타나서 그에게 이르시되 나는 전능한 하나님이라 ! 너는 내 앞에서 행하여 완전하라 ! ");
INSERT INTO kor_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","내가 내 언약을 나와 너 사이에 세워 너로 심히 번성케 하리라 하시니 ");
INSERT INTO kor_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","아브람이 엎드린대 하나님이 또 그에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","내가 너와 내 언약을 세우니 너는 열국의 아비가 될지라 ");
INSERT INTO kor_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","이제 후로는 네 이름을 아브람이라 하지 아니하고 아브라함이라 하리니 이는 내가 너로 열국의 아비가 되게 함이니라 ");
INSERT INTO kor_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","내가 너로 심히 번성케 하리니 나라들이 네게로 좇아 일어나며 열왕이 네게로 좇아나리라 ");
INSERT INTO kor_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","내가 내 언약을 나와 너와 네 대대 후손의 사이에 세워서 영원한 언약을 삼고 너와 네 후손의 하나님이 되리라 ");
INSERT INTO kor_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","내가 너와 네 후손에게 너의 우거하는 이 땅 곧 가나안 일경으로 주어 영원한 기업이 되게 하고 나는 그들의 하나님이 되리라 ");
INSERT INTO kor_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","하나님이 또 아브라함에게 이르시되 그런즉 너는 내 언약을 지키고 네 후손도 대대로 지키라 ! ");
INSERT INTO kor_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","너희 중 남자는 다 할례를 받으라 ! 이것이 나와 너희와 너희 후손사이에 지킬 내 언약이니라 ");
INSERT INTO kor_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","너희는 양피를 베어라 이것이 나와 너희 사이의 언약의 표징이니라 ");
INSERT INTO kor_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","대대로 남자는 집에서 난 자나 혹 너희 자손이 아니요 이방 사람에게서 돈으로 산 자를 무론하고 난지 팔일 만에 할례를 받을 것이라 ");
INSERT INTO kor_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","너희 집에서 난 자든지 너희 돈으로 산 자든지 할례를 받아야 하리니 이에 내 언약이 너희 살에 있어 영원한 언약이 되려니와 ");
INSERT INTO kor_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","할례를 받지 아니한 남자 곧 그 양피를 베지 아니한 자는 백성 중에서 끊어지리니 그가 내 언약을 배반하였음이니라 ");
INSERT INTO kor_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","하나님이 또 아브라함에게 이르시되 네 아내 사래는 이름을 사래라 하지 말고 그 이름을 사라라 하라 ");
INSERT INTO kor_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","내가 그에게 복을 주어 그로 네게 아들을 낳아 주게 하며 내가 그에게 복을 주어 그로 열국의 어미가 되게 하리니 민족의 열왕이 그에게서 나리라 ");
INSERT INTO kor_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","아브라함이 엎드리어 웃으며 심중에 이르되 `백세된 사람이 어찌 자식을 낳을까 ? 사라는 구십세니 어찌 생산하리요' 하고 ");
INSERT INTO kor_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","아브라함이 이에 하나님께 고하되 `이스마엘이나 하나님 앞에 살기를 원하나이다' ");
INSERT INTO kor_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","하나님이 가라사대 아니라 네 아내 사라가 정녕 네게 아들을 낳으리니 너는 그 이름을 이삭이라 하라 내가 그와 내 언약을 세우리리 그의 후손에게 영원한 언약이 되리라 ");
INSERT INTO kor_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","이스마엘에게 이르러는 내가 네 말을 들었나니 내가 그에게 복을 주어 생육이 중다하여 그로 크게 번성케 할지라 그가 열 두 방백을 낳으리니 내가 그로 큰 나라가 되게 하려니와 ");
INSERT INTO kor_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","내 언약은 내가 명년, 이 기한에 사라가 네게 낳을 이삭과 세우리라 ");
INSERT INTO kor_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","하나님이 아브라함과 말씀을 마치시고 그를 떠나 올라가셨더라 ");
INSERT INTO kor_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","이에 아브라함이 하나님이 자기에게 말씀하신 대로 이 날에 그 아들 이스마엘과 집에서 생장한 모든 자와 돈으로 산 모든 자 곧 아브라함의 집 사람 중 모든 남자를 데려다가 그 양피를 베었으니 ");
INSERT INTO kor_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","아브라함이 그 양피를 벤때는 구십 구세이었고 ");
INSERT INTO kor_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","그 아들 이스마엘이 그 양피를 벤 때는 십 삼세이었더라 ");
INSERT INTO kor_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","당일에 아브라함과 그 아들 이스마엘이 할례를 받았고 ");
INSERT INTO kor_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","그 집의 모든 남자 곧 집에서 생장한 자와 돈으로 이방 사람에게서 사온 자가 다 그와 함께 할례를 받았더라 ");
INSERT INTO kor_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","여호와께서 마므레 상수리 수풀 근처에서 아브라함에게 나타나시니라 오정 즈음에 그가 장막 문에 앉았다가 ");
INSERT INTO kor_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","눈을 들어 본즉 사람 셋이 맞은편에 섰는지라 그가 그들을 보자 곧 장막 문에서 달려나가 영접하며 몸을 땅에 굽혀 ");
INSERT INTO kor_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","가로되 `내 주여 ! 내가 주께 은혜를 입었사오면 원컨대 종을 떠나 지나가지 마옵시고 ");
INSERT INTO kor_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","물을 조금 가져오게 하사 당신들의 발을 씻으시고 나무 아래서 쉬소서 ");
INSERT INTO kor_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","내가 떡을 조금 가져오리니 당신들의 마음을 쾌활케 하신 후에 지나가소서 당신들이 종에게 오셨음이니이다' 그들이 가로되 `네 말대로 그리하라' ");
INSERT INTO kor_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","아브라함이 급히 장막에 들어가 사라에게 이르러 이르되 `속히 고운 가루 세 스아를 가져다가 반죽하여 떡을 만들라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","아브라함이 또 짐승 떼에 달려가서 기름지고 좋은 송아지를 취하여 하인에게 주니 그가 급히 요리한지라 ");
INSERT INTO kor_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","아브라함이 뻐터와 우유와 하인이 요리한 송아지를 가져다가 그들의 앞에 진설하고 나무 아래 모셔 서매 그들이 먹으니라 ");
INSERT INTO kor_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","그들이 아브라함에게 이르되 `네 아내 사라가 어디 있느냐 ?' 대답하되 `장막에 있나이다' ");
INSERT INTO kor_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","그가 가라사대 `기한이 이를 때에 내가 정녕 네게로 돌아오리니 네 아내 사라에게 아들이 있으리라' 하시니 사라가 그 뒤 장막 문에서 들었더라 ");
INSERT INTO kor_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","아브라함과 사라가 나이 많아 늙었고 사라의 경수는 끊어졌는지라 ");
INSERT INTO kor_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","사라가 속으로 웃고 이르되 `내가 노쇠하였고 내 주인도 늙었으니 내게 어찌 낙이 있으리요 ?' ");
INSERT INTO kor_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","여호와께서 아브라함에게 이르시되 사라가 왜 웃으며 이르기를 내가 늙었거늘 어떻게 아들을 낳으리요 하느냐 ? ");
INSERT INTO kor_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","여호와께 능치 못한 일이 있겠느냐 ! 기한이 이를 때에 내가 네게로 돌아오리니 사라에게 아들이 있으리라 ");
INSERT INTO kor_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","사라가 두려워서 승인치 아니하여 가로되 `내가 웃지 아니하였나이다' 가라사대 `아니라 네가 웃었느니라' ");
INSERT INTO kor_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","그 사람들이 거기서 일어나서 소돔으로 향하고 아브라함은 그들을 전송하러 함께 나가니라 ");
INSERT INTO kor_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","여호와께서 가라사대 나의 하려는 것을 아브라함에게 숨기겠느냐 ? ");
INSERT INTO kor_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","아브라함은 강대한 나라가 되고 천하 만민은 그를 인하여 복을 받게 될 것이 아니냐 ? ");
INSERT INTO kor_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","내가 그로 그 자식과 권속에게 명하여 여호와의 도를 지켜 의와 공도를 행하게 하려고 그를 택하였나니 이는 나 여호와가 아브라함에게 대하여 말한 일을 이루려 함이니라 ");
INSERT INTO kor_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","여호와께서 또 가라사대 소돔과 고모라에 대한 부르짖음이 크고 그 죄악이 심히 중하니 ");
INSERT INTO kor_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","내가 이제 내려가서 그 모든 행한 것이 과연 내게 들린 부르짖음과 같은지 그렇지 않은지 내가 보고 알려하노라 ");
INSERT INTO kor_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","그 사람들이 거기서 떠나 소돔으로 향하여 가고 아브라함은 여호와 앞에 그대로 섰더니 ");
INSERT INTO kor_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","가까이 나아가 가로되 `주께서 의인을 악인과 함께 멸하시려나이까 ? ");
INSERT INTO kor_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","그 성 중에 의인 오십이 있을지라도 주께서 그 곳을 멸하시고 그 오십 의인을 위하여 용서치 아니하시리이까 ? ");
INSERT INTO kor_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","주께서 이같이 하사 의인을 악인과 함께 죽이심은 불가하오며 의인과 악인을 균등히 하심도 불가하니이다 세상을 심판하시는 이가 공의를 행하실 것이 아니니이까 ?' ");
INSERT INTO kor_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","여호와께서 가라사대 내가 만일 소돔 성 중에서 의인 오십을 찾으면 그들을 위하여 온 지경을 용서하리라 ");
INSERT INTO kor_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","아브라함이 말씀하여 가로되 `티끌과 같은 나라도 감히 주께 고하나이다 ");
INSERT INTO kor_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","오십 의인 중에 오인이 부족할 것이면 그 오인 부족함을 인하여 온 성을 멸하시리이까 ?' 가라사대 내가 거기서 사십 오인을 찾으면 멸하지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","아브라함이 또 고하여 가로되 `거기서 사십인을 찾으시면 어찌 하시려나이까 ?' 가라사대 사십인을 인하여 멸하지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","아브라함이 가로되 `내 주여 노하지 마옵시고 말씀하게 하옵소서 거기서 삼십인을 찾으시면 어찌 하시려나이까 ?' 가라사대 내가 거기서 삼십인을 찾으면 멸하지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","아브라함이 또 가로되 `내가 감히 내 주께 고하나이다 거기서 이십인을 찾으시면 어찌 하시려나이까 ?' 가라사대 내가 이십인을 인하여 멸하지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","아브라함이 또 가로되 `주는 노하지 마옵소서 내가 이번만 더 말씀하리이다 거기서 십인을 찾으시면 어찌 하시려나이까 ?' 가라사대 내가 십인을 인하여도 멸하지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","여호와께서 아브라함과 말씀을 마치시고 즉시 가시니 아브라함도 자기 곳으로 돌아갔더라 ");
INSERT INTO kor_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","날이 저물 때에 그 두 천사가 소돔에 이르니 마침 롯이 소돔 성 문에 앉았다가 그들을 보고 일어나 영접하고 땅에 엎드리어 절하여 ");
INSERT INTO kor_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","가로되 `내 주여 ! 돌이켜 종의 집으로 들어와 발을 씻고 주무시고 일찌기 일어나 갈 길을 가소서' 그들이 가로되 `아니라 우리가 거리에서 경야하리라' ");
INSERT INTO kor_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","롯이 간청하매 그제야 돌이켜서 그 집으로 들어 오는지라 롯이 그들을 위하여 식탁을 베풀고 무교병을 구우니 그들이 먹으니라 ");
INSERT INTO kor_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","그들의 눕기 전에 그 성 사람 곧 소돔 백성들이 무론 노소하고 사방에서 다 모여 그 집을 에워싸고 ");
INSERT INTO kor_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","롯을 부르고 그에게 이르되 `이 저녁에 네게 온 사람이 어디 있느냐 ? 이끌어내라 우리가 그들을 상관하리라' ");
INSERT INTO kor_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","롯이 문 밖의 무리에게로 나가서 뒤로 문을 닫고 ");
INSERT INTO kor_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","이르되 청하노니 `내 형제들아 이런 악을 행치 말라 ");
INSERT INTO kor_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","내게 남자를 가까이 아니한 두 딸이 있노라 청컨대 내가 그들을 너희에게로 이끌어내리니 너희 눈에 좋은대로 그들에게 행하고 이 사람들은 내 집에 들어왔은즉 이 사람들에게는 아무 짓도 하지 말라' ");
INSERT INTO kor_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","그들이 가로되 `너는 물러나라' 또 가로되 `이놈이 들어와서 우거하면서 우리의 법관이 되려 하는도다 이제 우리가 그들보다 너를 더 해하리라' 하고 롯을 밀치며 가까이 나아와서 그 문을 깨치려 하는지라 ");
INSERT INTO kor_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","그 사람들이 손을 내밀어 롯을 집으로 끌어들이고 문을 닫으며 ");
INSERT INTO kor_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","문밖의 무리로 무론 대소하고 그 눈을 어둡게 하니 그들이 문을 찾느라고 곤비하였더라 ");
INSERT INTO kor_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","그 사람들이 롯에게 이르되 `이 외에 네게 속한 자가 또 있느냐 ? 네 사위나 자녀나 성중에 네게 속한 자들을 다 성 밖으로 이끌어내라 ");
INSERT INTO kor_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","그들에 대하여 부르짖음이 여호와 앞에 크므로 여호와께서 우리로 이 곳을 멸하러 보내셨나니 우리가 멸하리라' ");
INSERT INTO kor_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","롯이 나가서 그 딸과 정혼한 사위들에게 고하여 이르되 `여호와께서 이 성을 멸하실터이니 너희는 일어나 이 곳에서 떠나라' 하되 그 사위들이 농담으로 여겼더라 ");
INSERT INTO kor_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","동틀 때에 천사가 롯을 재촉하여 가로되 `일어나 여기 있는 네 아내와 두 딸을 이끌라 이 성의 죄악 중에 함께 멸망할까 하노라' ");
INSERT INTO kor_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","그러나 롯이 지체하매 그 사람들이 롯의 손과, 그 아내의 손과, 두 딸의 손을 잡아 인도하여 성밖에 두니 여호와께서 그에게 인자를 더하심이었더라 ");
INSERT INTO kor_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","그 사람들이 그들을 밖으로 이끌어 낸 후에 이르되 `도망하여 생명을 보존하라 돌아보거나 들에 머무르거나 하지 말고 산으로 도망하여 멸망함을 면하라' ");
INSERT INTO kor_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","롯이 그들에게 이르되 `내 주여 그리 마옵소서 ");
INSERT INTO kor_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","종이 주께 은혜를 얻었고 주께서 큰 인자를 내게 베푸사 내 생명을 구원하시오나 내가 도망하여 산까지 갈 수 없나이다 두렵건대 재앙을 만나 죽을까 하나이다 ");
INSERT INTO kor_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","보소서 저 성은 도망하기 가깝고 작기도 하오니 나로 그 곳에 도망하게 하소서 이는 작은 성이 아니니이까 ? 내 생명이 보존되리이다' ");
INSERT INTO kor_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","그가 그에게 이르되 `내가 이 일에도 네 소원을 들었은즉 너의 말하는 성을 멸하지 아니하리니 ");
INSERT INTO kor_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","그리로 속희 도망하라 네가 거기 이르기까지는 내가 아무 일도 행할 수 없노라 하였더라 그러므로 그 성 이름을 소알이라 불렀 더라 ");
INSERT INTO kor_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","롯이 소알에 들어갈 때에 해가 돋았더라 ");
INSERT INTO kor_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","여호와께서 하늘 곧 여호와에게로서 유황과 불을 비같이 소돔과 고모라에 내리사 ");
INSERT INTO kor_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","그 성들과 온 들과 성에 거하는 모든 백성과 땅에 난것을 다 엎어 멸하셨더라 ");
INSERT INTO kor_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","롯의 아내는 뒤를 돌아본고로 소금 기둥이 되었더라 ");
INSERT INTO kor_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","아브라함이 그 아침에 일찌기 일어나 여호와의 앞에 섰던 곳에 이르러 ");
INSERT INTO kor_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","소돔과 고모라와 그 온 들을 향하여 눈을 들어 연기가 옹기점 연기같이 치밀음을 보았더라 ");
INSERT INTO kor_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","하나님이 들의 성들을 멸하실 때 곧 롯의 거하는 성을 엎으실 때에 아브라함을 생각하사 롯을 그 엎으시는 중에서 내어 보내셨더라 ");
INSERT INTO kor_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","롯이 소알에 거하기를 두려워하여 두 딸과 함께 소알에서 나와 산에 올라 거하되 그 두 딸과 함께 굴에 거하였더니 ");
INSERT INTO kor_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","큰 딸이 작은 딸에게 이르되 `우리 아버지는 늙으셨고 이 땅에는 세상의 도리를 좇아 우리의 배필 될 사람이 없으니 ");
INSERT INTO kor_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","우리가 우리 아버지에게 술을 마시우고 동침하여 우리 아버지로 말미암아 인종을 전하자' 하고 ");
INSERT INTO kor_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","그 밤에 그들이 아비에게 술을 마시우고 큰 딸이 들어가서 그 아비와 동침하니라 그러나 그 아비는 그 딸의 눕고 일어나는 것을 깨닫지 못하였더라 ");
INSERT INTO kor_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","이튿날에 큰 딸이 작은 딸에게 이르되 `어제 밤에는 내가 우리 아버지와 동침하였으니 오늘 밤에도 우리가 아버지에게 술을 마시우고 네가 들어가 동침하고 우리가 아버지로 말미암아 인종을 전하자' 하고 ");
INSERT INTO kor_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","이 밤에도 그들이 아비에게 술을 마시우고 작은 딸이 일어나 아비와 동침하니라 그러나 아비는 그 딸의 눕고 일어나는 것을 깨닫지 못하였더라 ");
INSERT INTO kor_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","롯의 두 딸이 아비로 말미암아 잉태하고 ");
INSERT INTO kor_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","큰 딸은 아들을 낳아 이름을 모압이라 하였으니 오늘날 모압 족속의 조상이요 ");
INSERT INTO kor_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","작은 딸도 아들을 낳아 이름을 벤암미라 하였으니 오늘날 암몬 족속의 조상이었더라 ");
INSERT INTO kor_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","아브라함이 거기서 남방으로 이사하여 가데스와 술 사이 그랄에 우거하며 ");
INSERT INTO kor_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","그 아내 사라를 자기 누이라 하였으므로 그랄 왕 아비멜렉이 보내어 사라를 취하였더니 ");
INSERT INTO kor_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","그 밤에 하나님이 아비멜렉에게 현몽하시고 그에게 이르시되 네가 취한 이 여인을 인하여 네가 죽으리니 그가 남의 아내임이니라 ");
INSERT INTO kor_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","아비멜렉이 그 여인을 가까이 아니한 고로 그가 대답하되 `주여, 주께서 의로운 백성도 멸하시나이까 ? ");
INSERT INTO kor_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","그가 나더러 이는 내 누이라고 하지 아니하였나이까 ? 그 여인도 그는 내 오라비라 하였사오니 나는 온전한 마음과 깨끗한 손으로 이렇게 하였나이다' ");
INSERT INTO kor_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","하나님이 꿈에 또 그에게 이르시되 네가 온전한 마음으로 이렇게 한 줄을 나도 알았으므로 너를 막아 내게 범죄하지 않게 하였나니 여인에게 가까이 못하게 함이 이 까닭이니라 ");
INSERT INTO kor_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","이제 그 사람의 아내를 돌려 보내라 그는 선지자라 그가 너를 위하여 기도하리니 네가 살려니와 네가 돌려 보내지 않으면 너와 네게 속한 자가 다 정녕 죽을 줄 알지니라 ");
INSERT INTO kor_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","아비멜렉이 그 아침에 일찌기 일어나 모든 신복을 불러 그 일을 다 말하여 들리매 그 사람들이 심히 두려워하였더라 ");
INSERT INTO kor_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","아비멜렉이 아브라함을 불러서 그에게 이르되 `네가 어찌하여 우리에게 이리 하느냐 ? 내가 무슨 죄를 네게 범하였관대 네가 나와 내 나라로 큰 죄에 빠질 뻔하게 하였느냐 ? 네가 합당치 않은 일을 네게 행하였도다` 하고 ");
INSERT INTO kor_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","아비멜렉이 또 아브라함에게 이르되 `네가 무슨 의견으로 이렇게 하였느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","아브라함이 가로되 `이곳에서는 하나님을 두려워함이 없으니 내 아내를 인하여 사람이 나를 죽일까 생각하였음이요 ");
INSERT INTO kor_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","또 그는 실로 나의 이복 누이로서 내 처가 되었음이니라 ");
INSERT INTO kor_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","하나님이 나로 내 아비 집을 떠나 두루 다니게 하실 때에 내가 아내에게 말하기를 이후로 우리의 가는 곳마다 그대는 나를 그대의 오라비라 하라 이것이 그대가 내게 베풀 은혜라 하였었노라` ");
INSERT INTO kor_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","아비멜렉이 양과 소와 노비를 취하여 아브라함에게 주고 그 아내 사라도 그에게 돌려보내고 ");
INSERT INTO kor_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","아브라함에게 이르되 `내 땅이 네 앞에 있으니 너 보기에 좋은 대로 거하라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","사라에게 이르되 `내가 은 천개를 네 오라비에게 주어서 그것으로 너와 함께 한 여러 사람 앞에서 네 수치를 풀게 하였노니 네 일이 다 선히 해결되었느니라' ");
INSERT INTO kor_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","아브라함이 하나님께 기도하매 하나님이 아비멜렉과 그 아내와 여종을 치료하사 생산케 하셨으니 ");
INSERT INTO kor_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","여호와께서 이왕에 아브라함의 아내 사라의 연고로 아비멜렉의 집 모든 태를 닫히셨음이더라 ");
INSERT INTO kor_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","여호와께서 그 말씀대로 사라를 권고하셨고 여호와께서 그 말씀대로 사라에게 행하셨으므로 ");
INSERT INTO kor_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","사라가 잉태하고 하나님의 말씀하신 기한에 미쳐 늙은 아브라함에게 아들을 낳으니 ");
INSERT INTO kor_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","아브라함이 그 낳은 아들 곧 사라가 자기에게 낳은 아들을 이름하여 이삭이라 하였고 ");
INSERT INTO kor_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","그 아들 이삭이 난지 팔일만에 그가 하나님의 명대로 할례를 행하였더라 ");
INSERT INTO kor_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","아브라함이 그 아들 이삭을 낳을 때에 백세라 ");
INSERT INTO kor_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","사라가 가로되 `하나님이 나로 웃게 하시니 듣는 자가 다 나와 함께 웃으리로다' ");
INSERT INTO kor_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","또 가로되 `사라가 자식들을 젖 먹이겠다고 누가 아브라함에게 말하였으리요 마는 아브라함 노경에 내가 아들을 낳았도다' 하니라 ");
INSERT INTO kor_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","아이가 자라매 젖을 떼고 이삭의 젖을 떼는 날에 아브라함이 대연을 배설하였더라 ");
INSERT INTO kor_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","사라가 본즉 아브라함의 아들 애굽 여인 하갈의 소생이 이삭을 희롱하는지라 ");
INSERT INTO kor_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","그가 아브라함에게 이르되 `이 여종과 그 아들을 내어 쫓으라 이 종의 아들은 내 아들 이삭과 함께 기업을 얻지 못하리라' 하매 ");
INSERT INTO kor_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","아브라함이 그 아들을 위하여 그 일이 깊이 근심이 되었더니 ");
INSERT INTO kor_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","하나님이 아브라함에게 이르시되 네 아이나 네 여종을 위하여 근심치 말고 사라가 네게 이른 말을 다 들으라 ! 이삭에게서 나는 자라야 네 씨라 칭할 것임이니라 ");
INSERT INTO kor_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","그러나 여종의 아들도 네 씨니 내가 그로 한 민족을 이루게 하리라 하신지라 ");
INSERT INTO kor_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","아브라함이 아침에 일찌기 일어나 떡과 물 한 가죽부대를 취하여 하갈의 어깨에 메워 주고 그 자식을 이끌고 가게 하매 하갈이 나가서 브엘세바 들에서 방황하더니 ");
INSERT INTO kor_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","가죽부대의 물이 다한지라 그 자식을 떨기나무 아래 두며 ");
INSERT INTO kor_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","가로되 `자식의 죽는 것을 참아 보지 못하겠다' 하고 살 한 바탕쯤가서 마주 앉아 바라보며 방성대곡하니 ");
INSERT INTO kor_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","하나님이 그 아이의 소리를 들으시므로 하나님의 사자가 하늘에서부터 하갈을 불러 가라사대 `하갈아, 무슨 일이냐 ? 두려워 말라 ! 하나님이 거기 있는 아이의 소리를 들으셨나니 ");
INSERT INTO kor_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","일어나 아이를 일으켜 네 손으로 붙들라 그로 큰 민족을 이루게 하리라' 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","하나님이 하갈의 눈을 밝히시매 샘물을 보고 가서 가죽부대에 물을 채워다가 그 아이에게 마시웠더라 ");
INSERT INTO kor_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","하나님이 그 아이와 함께 계시매 그가 장성하여 광야에 거하며 활쏘는 자가 되었더니 ");
INSERT INTO kor_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","그가 바란 광야에 거할 때에 그 어미가 그를 위하여 애굽땅 여인을 취하여 아내를 삼게 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","때에 아비멜렉과 그 군대 장관 비골이 아브라함에게 말하여 가로되 네가 무슨 일을 하든지 하나님이 너와 함께 계시도다 ! ");
INSERT INTO kor_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","그런즉 너는 나와 내 아들과 내 손자에게 거짓되이 행치 않기를 이제 여기서 하나님을 가리켜 내게 맹세하라 내가 네게 후대한대로 너도 나와 너의 머무는 이 땅에 행할 것이니라 ");
INSERT INTO kor_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","아브라함이 가로되 `내가 맹세하리라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","아비멜렉의 종들이 아브라함의 우물을 늑탈한 일에 대하여 아브라함이 아비멜렉을 책망하매 ");
INSERT INTO kor_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","아비멜렉이 가로되 `누가 그리하였는지 내가 알지 못하노라 너도 내게 고하지 아니하였고 나도 듣지 못하였더니 오늘이야 들었노라' ");
INSERT INTO kor_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","아브라함이 양과 소를 취하여 아비멜렉에게 주고 두 사람이 서로 언약을 세우니라 ");
INSERT INTO kor_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","아브라함이 일곱 암양 새끼를 따로 놓으니 ");
INSERT INTO kor_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","아비멜렉이 아브라함에게 이르되 `이 일곱 암양 새끼를 따로 놓음은 어찜이뇨 ?' ");
INSERT INTO kor_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","아브라함이 가로되 `너는 내 손에서 이 암양 새끼 일곱을 받아 내가 이 우물 판 증거를 삼으라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","두 사람이 거기서 서로 맹세하였으므로 그 곳을 브엘세바라 이름하였더라 ");
INSERT INTO kor_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","그들이 브엘세바에서 언약을 세우매 아비멜렉과 그 군대 장관 비골은 떠나 블레셋 족속의 땅으로 돌아갔고 ");
INSERT INTO kor_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","아브라함은 브엘세바에 에셀나무를 심고 거기서 영생하시는 하나님 여호와의 이름을 불렀으며 ");
INSERT INTO kor_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","그가 블레셋 족속의 땅에서 여러 날을 지내었더라 ");
INSERT INTO kor_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","그 일 후에 하나님이 아브라함을 시험하시려고 그를 부르시되 아브라함아 하시니 그가 가로되 `내가 여기 있나이다' ");
INSERT INTO kor_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","여호와께서 가라사대 네 아들 네 사랑하는 독자 이삭을 데리고 모리아 땅으로 가서 내가 네게 지시하는 한 산 거기서 그를 번제로 드리라 ");
INSERT INTO kor_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","아브라함이 아침에 일찌기 일어나 나귀에 안장을 지우고 두 사환과 그 아들 이삭을 데리고 번제에 쓸 나무를 쪼개어 가지고 떠나 하나님의 자기에게 지시하시는 곳으로 가더니 ");
INSERT INTO kor_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","제 삼일에 아브라함이 눈을 들어 그곳을 멀리 바라본지라 ");
INSERT INTO kor_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","이에 아브라함이 사환에게 이르되 `너희는 나귀와 함께 여기서 기다리라 내가 아이와 함께 저기 가서 경배하고 너희에게로 돌아오리라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","아브라함이 이에 번제 나무를 취하여 그 아들 이삭에게 지우고 자기는 불과 칼을 손에 들고 두 사람이 동행하더니 ");
INSERT INTO kor_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","이삭이 그 아비 아브라함에게 말하여 가로되 `내 아버지여' 하니 그가 가로되 `내 아들아 내가 여기 있노라' 이삭이 가로되 `불과 나무는 있거니와 번제할 어린 양은 어디 있나이까 ?' ");
INSERT INTO kor_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","아브라함이 가로되 `아들아, 번제할 어린 양은 하나님이 자기를 위하여 친히 준비하시리라' 하고 두 사람이 함께 나아가서 ");
INSERT INTO kor_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","하나님이 그에게 지시하신 곳에 이른지라 이에 아브라함이 그곳에 단을 쌓고 나무를 벌여놓고 그 아들 이삭을 결박하여 단 나무위에 놓고 ");
INSERT INTO kor_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","손을 내밀어 칼을 잡고 그 아들을 잡으려 하더니 ");
INSERT INTO kor_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","여호와의 사자가 하늘에서부터 그를 불러 가라사대 `아브라함아, 아브라함아' 하시는지라 아브라함이 가로되 `내가 여기 있나이다' 하매 ");
INSERT INTO kor_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","사자가 가라사대 `그 아이에게 네 손을 대지 말라 아무 일도 그에게 하지 말라 네가 네 아들 네 독자라도 내게 아끼지 아니하였으니 내가 이제야 네가 하나님을 경외하는 줄을 아노라' ");
INSERT INTO kor_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","아브라함이 눈을 들어 살펴본즉 한 수양이 뒤에 있는데 뿔이 수풀에 걸렸는지라 아브라함이 가서 그 수양을 가져다가 아들을 대신하여 번제로 드렸더라 ");
INSERT INTO kor_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","아브라함이 그 땅 이름을 `여호와 이레' 라 하였으므로 오늘까지 사람들이 이르기를 `여호와의 산에서 준비되리라' 하더라 ");
INSERT INTO kor_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","여호와의 사자가 하늘에서부터 두번째 아브라함을 불러 ");
INSERT INTO kor_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","가라사대 여호와께서 이르시기를 내가 나를 가리켜 맹세하노니 네가 이같이 행하여 네 아들 네 독자를 아끼지 아니하였은즉 ");
INSERT INTO kor_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","내가 네게 큰 복을 주고 네 씨로 크게 성하여 하늘의 별과 같고 바닷가의 모래와 같게 하리니 네 씨가 그 대적의 문을 얻으리라 ");
INSERT INTO kor_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","또 네 씨로 말미암아 천하 만민이 복을 얻으리니 이는 네가 나의 말을 준행하였음이니라 ! 하셨다 하니라 ");
INSERT INTO kor_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","이에 아브라함이 그 사환에게로 돌아와서 함께 떠나 브엘세바에 이르러 거기 거하였더라 ");
INSERT INTO kor_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","이일 후에 혹이 아브라함에게 고하여 이르기를 `밀가가 그대의 동생 나홀에게 자녀를 낳았다' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","그 맏아들은 우스요 우스의 동생은 부스와, 아람의 아비 그므엘과 ");
INSERT INTO kor_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","게셋과, 하소와, 빌다스와, 이들랍과, 브두엘이라 ");
INSERT INTO kor_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","이 여덟 사람은 아브라함의 동생 나홀의 처 밀가의 소생이며 브두엘은 리브가를 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","나홀의 첩 르우마라 하는 자도 데바와, 가함과, 다하스와, 마아가를 낳았더라 ");
INSERT INTO kor_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","사라가 일백 이십 칠세를 살았으니 이것이 곧 사라의 향년이라 ");
INSERT INTO kor_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","사라가 가나안 땅 헤브론 곧 기럇아르바에서 죽으매 아브라함이 들어가서 사라를 위하여 슬퍼하며 애통하다가 ");
INSERT INTO kor_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","그 시체 앞에서 일어나 나가서 헷 족속에게 말하여 가로되 ");
INSERT INTO kor_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","`나는 당신들 중에 나그네요, 우거한 자니 청컨대 당신들 중에서 내게 매장지를 주어 소유를 삼아 나로 내 죽은 자를 내어 장사하게 하시오' ");
INSERT INTO kor_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","헷 족속이 아브라함에게 대답하여 가로되 ");
INSERT INTO kor_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","`내 주여, 들으소서 당신은 우리 중 하나님의 방백이시니 우리 묘실 중에서 좋은 것을 택하여 당신의 죽은 자를 장사하소서 우리 중에서 자기 묘실에 당신의 죽은 자 장사함을 금할 자가 없으리이다' ");
INSERT INTO kor_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","아브라함이 일어나 그 땅 거민 헷 족속을 향하여 몸을 굽히고 ");
INSERT INTO kor_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","그들에게 말하여 가로되 `나로 나의 죽은 자를 내어 장사하게 하는 일이 당신들의 뜻일진대 내 말을 듣고 나를 위하여 소할의 아들 에브론에게 구하여 ");
INSERT INTO kor_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","그로 그 밭머리에 있는 막벨라 굴을 내게 주게 하되 준가를 받고 그 굴을 내게 주어서 당신들 중에 내 소유 매장지가 되게 하기를 원하노라 ");
INSERT INTO kor_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","때에 에브론이 헷 족속 중에 앉았더니 그가 헷 족속 곧 성문에 들어온 모든 자의 듣는데 아브라함에게 대답하여 가로되 ");
INSERT INTO kor_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","`내 주여, 그리 마시고 내 말을 들으소서 내가 그 밭을 당신께 드리되 내가 내 동족 앞에서 당신께 드리고 그 속의 굴도 내가 당신께 드리되 내가 내 동족 앞에서 당신께 드리오니 당신의 죽은 자를 장사하소서' ");
INSERT INTO kor_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","아브라함이 이에 그 땅 백성을 대하여 몸을 굽히고 ");
INSERT INTO kor_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","그 땅 백성의 듣는데 에브론에게 말하여 가로되 `당신이 합당히 여기면 청컨대 내 말을 들으시오 내가 그 밭값을 당신에게 주리니 당신은 내게서 받으시오 내가 나의 죽은 자를 거기 장사하겠노라' ");
INSERT INTO kor_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","에브론이 아브라함에게 대답하여 가로되 ");
INSERT INTO kor_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","`내 주여, 내게 들으소서 땅값은 은 사백 세겔이나 나와 당신 사이에 어찌 교계하리이까 ? 당신의 죽은 자를 장사하소서' ");
INSERT INTO kor_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","아브라함이 에브론의 말을 좇아 에브론이 헷 족속의 듣는데서 말한 대로 상고의 통용하는 은 사백 세겔을 달아 에브론에게 주었더니 ");
INSERT INTO kor_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","마므레 앞 막벨라에 있는 에브론의 밭을 바꾸어 그 속의 굴과 그 사방에 둘린 수목을 다 ");
INSERT INTO kor_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","성문에 들어온 헷 족속 앞에서 아브라함의 소유로 정한지라 ");
INSERT INTO kor_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","그 후에 아브라함이 그 아내 사라를 가나안 땅 마므레 앞 막벨라밭 굴에 장사하였더라 (마므레는 곧 헤브론이라) ");
INSERT INTO kor_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","이와 같이 그 밭과 그 속의 굴을 헷 족속이 아브라함 소유 매장지로 정하였더라 ");
INSERT INTO kor_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","아브라함이 나이 많아 늙었고 여호와께서 그의 범사에 복을 주셨더라 ");
INSERT INTO kor_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","아브라함이 자기 집 모든 소유를 맡은 늙은 종에게 이르되 `청컨대 네 손을 내 환도뼈 밑에 넣으라 ");
INSERT INTO kor_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","내가 너로 하늘의 하나님, 땅의 하나님이신 여호와를 가리켜 맹세하게 하노니 너는 나의 거하는 이 지방 가나안 족속의 딸 중에서 내 아들을 위하여 아내를 택하지 말고 ");
INSERT INTO kor_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","내 고향 내 족속에게로 가서 내 아들 이삭을 위하여 아내를 택하라' ");
INSERT INTO kor_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","종이 가로되 `여자가 나를 좇아 이 땅으로 오고자 아니하거든 내가 주인의 아들을 주인의 나오신 땅으로 인도하여 돌아가리이까 ?' ");
INSERT INTO kor_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","아브라함이 그에게 이르되 `삼가 내 아들을 그리로 데리고 돌아가지 말라 ");
INSERT INTO kor_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","하늘의 하나님 여호와께서 나를 내 아버지의 집과 내 본토에서 떠나게 하시고 내게 말씀하시며 내게 맹세하여 이르시기를 이 땅을 네 씨에게 주리라 하셨으니 그가 그 사자를 네 앞서 보내실지라 네가 거기서 내 아들을 위하여 아내를 택할지니라 ");
INSERT INTO kor_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","만일 여자가 너를 좇아 오고자 아니하면 나의 이 맹세가 너와 상관이 없나니 오직 내 아들을 데리고 그리로 가지 말지니라' ");
INSERT INTO kor_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","종이 이에 주인 아브라함의 환도뼈 아래 손을 넣고 이 일에 대하여 그에게 맹세하였더라 ");
INSERT INTO kor_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","이에 종이 그 주인의 약대 중 열 필을 취하고 떠났는데 곧 그 주인의 모든 좋은 것을 가지고 떠나 메소보다미아로 가서 나홀의 성에 이르러 ");
INSERT INTO kor_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","그 약대를 성 밖 우물 곁에 꿇렸으니 저녁 때라 여인들이 물을 길러 나올 때이었더라 ");
INSERT INTO kor_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","그가 가로되 `우리 주인 아브라함의 하나님 여호와여 ! 원컨대 오늘날 나로 순적히 만나게 하사 나의 주인 아브라함에게 은혜를 베푸시옵소서 ! ");
INSERT INTO kor_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","성 중 사람의 딸들이 물 길러 나오겠사오니 내가 우물 곁에 섰다가 ");
INSERT INTO kor_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","한 소녀에게 이르기를 청컨대 너는 물 항아리를 기울여 나로 마시게 하라 하리니 그의 대답이 마시라 내가 당신의 약대에게도 마시우리라 하면 그는 주께서 주의 종 이삭을 위하여 정하신 자라 이로 인하여 주께서 나의 주인에게 은혜 베푸심을 내가 알겠나이다' ");
INSERT INTO kor_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","말을 마치지 못하여서 리브가가 물 항아리를 어깨에 메고 나오니 그는 아브라함의 동생 나홀의 아내 밀가의 아들 브두엘의 소생이라 ");
INSERT INTO kor_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","그 소녀는 보기에 심히 아리땁고 지금까지 남자가 가까이 하지 아니한 처녀더라 그가 우물에 내려가서 물을 그 물 항아리에 채워 가지고 올라오는지라 ");
INSERT INTO kor_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","종이 마주 달려가서 가로되 `청컨대 네 물 항아리의 물을 내게 조금 마시우라' ");
INSERT INTO kor_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","그가 가로되 `주여, 마시소서' 하며 급히 그 물 항아리를 손에 내려 마시게 하고 ");
INSERT INTO kor_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","마시우기를 다하고 가로되 `당신의 약대도 위하여 물을 길어 그것들로 배불리 마시게 하리이다' 하고 ");
INSERT INTO kor_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","급히 물 항아리의 물을 구유에 붓고 다시 길으려고 우물로 달려가서 모든 약대를 위하여 긷는지라 ");
INSERT INTO kor_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","그 사람이 그를 묵묵히 주목하며 여호와께서 과연 평탄한 길을 주신 여부를 알고자 하더니 ");
INSERT INTO kor_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","약대가 마시기를 다하매 그가 반 세겔중 금고리 한개와, 열 세겔중 금 손목고리 한 쌍을 그에게 주며 ");
INSERT INTO kor_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","가로되 `네가 뉘 딸이냐 ? 청컨대 내게 고하라 네 부친의 집에 우리 유숙할 곳이 있느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","그 여자가 그에게 이르되 `나는 밀가가 나홀에게 낳은 아들 브두엘의 딸이니이다' ");
INSERT INTO kor_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","또 가로되 `우리에게 짚과 보리가 족하며 유숙할 곳도 있나이다' ");
INSERT INTO kor_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","이에 그 사람이 머리를 숙여 여호와께 경배하고 ");
INSERT INTO kor_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","가로되 `나의 주인 아브라함의 하나님 여호와를 찬송하나이다 ! 나의 주인에게 주의 인자와 성실을 끊이지 아니하셨사오며 여호와께서 길에서 나를 인도하사 내 주인의 동생집에 이르게 하셨나이다' 하니라 ");
INSERT INTO kor_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","소녀가 달려가서 이 일을 어미 집에 고하였더니 ");
INSERT INTO kor_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","리브가에게 오라비가 있어 이름은 라반이라 그가 우물로 달려가 그 사람에게 이르니 ");
INSERT INTO kor_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","그가 그 누이의 고리와 그 손의 손목고리를 보고 또 그 누이 리브가가 그 사람이 자기에게 이같이 말하더라 함을 듣고 그 사람에게로 나아감이라 때에 그가 우물가 약대 곁에 섰더라 ");
INSERT INTO kor_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","라반이 가로되 `여호와께 복을 받은 자여 ! 들어오소서 어찌 밖에 섰나이까 ? 내가 방과 약대의 처소를 예비하였나이다' ");
INSERT INTO kor_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","그 사람이 집으로 들어가매 라반이 약대의 짐을 부리고 짚과 보리를 약대에게 주고 그 사람의 발과 그 종자의 발 씻을 물을 주고 ");
INSERT INTO kor_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","그 앞에 식물을 베푸니 그 사람이 가로되 `내가 내 일을 진술하기 전에는 먹지 아니하겠나이다' 라반이 가로되 `말하소서' ");
INSERT INTO kor_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","그가 가로되 `나는 아브라함의 종이니이다 ");
INSERT INTO kor_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","여호와께서 나의 주인에게 크게 복을 주어 창성케 하시되 우양과, 은,금과, 노비와, 약대와, 나귀를 그에게 주셨고 ");
INSERT INTO kor_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","나의 주인의 부인 사라가 노년에 나의 주인에게 아들을 낳으매 주인이 그 모든 소유를 그 아들에게 주었나이다 ");
INSERT INTO kor_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","나의 주인이 나로 맹세하게 하여 가로되 너는 내 아들을 위하여 나 사는 땅 가나안 족속의 딸 중에서 아내를 택하지 말고 ");
INSERT INTO kor_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","내 아비 집 내 족속에게로 가서 내 아들을 위하여 아내를 택하라 하시기로 ");
INSERT INTO kor_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","내가 내 주인에게 말씀하되 혹 여자가 나를 좇지 아니하면 어찌 하리이까 ? 한즉 ");
INSERT INTO kor_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","주인이 내게 이르되 나의 섬기는 여호와께서 그 사자를 너와 함께 보내어 네게 평탄한 길을 주시리니 너는 내 족속 중 내 아비 집에서 내 아들을 위하여 아내를 택할 것이니라 ");
INSERT INTO kor_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","네가 내 족속에게 이를 때에는 네가 내 맹세와 상관이 없으리라 설혹 그들이 네게 주지 아니할지라도 네가 내 맹세와 상관이 없으리라 하시기로 ");
INSERT INTO kor_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","내가 오늘 우물에 이르러 말씀하기를 나의 주인 아브라함의 하나님 여호와여, 만일 나의 행하는 길에 형통함을 주실진대 ");
INSERT INTO kor_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","내가 이 우물 곁에 섰다가 청년 여자가 물을 길러 오거든 내가 그에게 청하기를 너는 물 항아리의 물을 내게 조금 마시우라 하여 ");
INSERT INTO kor_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","그의 대답이 당신은 마시라 내가 또 당신의 약대를 위하여도 길으리라 하면 그 여자는 여호와께서 나의 주인의 아들을 위하여 정하여 주신 자가 되리이다 하며 ");
INSERT INTO kor_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","내가 묵도하기를 마치지 못하여 리브가가 물 항아리를 어깨에 메고 나와서 우물로 내려와 긷기로 내가 그에게 이르기를 청컨대 내게 마시우라 한즉 ");
INSERT INTO kor_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","그가 급히 물 항아리를 어깨에서 내리며 가로되 마시라 내가 당신의 약대에게도 마시우리라 하기로 내가 마시매 그가 또 약대에게도 마시운지라 ");
INSERT INTO kor_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","내가 그에게 묻기를 네가 뉘 딸이뇨? 한즉 가로되 밀가가 나홀에게 낳은 브두엘의 딸이라 하기로 내가 고리를 그 코에 꿰고 손목고리를 그 손에 끼우고 ");
INSERT INTO kor_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","나의 주인 아브라함의 하나님 여호와께서 나를 바른 길로 인도하사 나의 주인의 동생의 딸을 그 아들을 위하여 택하게 하셨으므로 내가 머리를 숙여 그에게 경배하고 찬송하였나이다 ! ");
INSERT INTO kor_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","이제 당신들이 인자와 진실로 나의 주인을 대접하려거든 내게 고하시고 그렇지 않을지라도 내게 고하여 나로 좌우간 행하게 하소서' ");
INSERT INTO kor_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","라반과 브두엘이 대답하여 가로되 `이 일이 여호와께로 말미암았으니 우리는 가부를 말할 수 없노라 ");
INSERT INTO kor_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","리브가가 그대 앞에 있으니 데리고 가서 여호와의 명대로 그로 그대의 주인의 아들의 아내가 되게 하라' ");
INSERT INTO kor_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","아브라함의 종이 그들의 말을 듣고 땅에 엎드리어 여호와께 절하고 ");
INSERT INTO kor_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","은,금 패물과 의복을 꺼내어 리브가에게 주고 그 오라비와 어미에게도 보물을 주니라 ");
INSERT INTO kor_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","이에 그들 곧 종과 종자들이 먹고 마시고 유숙하고 아침에 일어나서 그가 가로되 `나를 보내어 내 주인에게로 돌아가게 하소서' ");
INSERT INTO kor_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","리브가의 오라비와 그 어미가 가로되 `소녀로 며칠을 적어도 열흘을 우리와 함께 있게 하라 그 후에 그가 갈 것이니라' ");
INSERT INTO kor_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","그 사람이 그들에게 이르되 `나를 만류치 마소서 여호와께서 내게 형통한 길을 주셨으니 나를 보내어 내 주인에게로 돌아가게 하소서' ");
INSERT INTO kor_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","그들이 가로되 `우리가 소녀를 불러 그에게 물으리라` 하고 ");
INSERT INTO kor_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","리브가를 불러 그에게 이르되 `네가 이 사람과 함께 가려느냐 ?` 그가 대답하되 `가겠나이다' ");
INSERT INTO kor_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","그들이 그 누이 리브가와 그의 유모와 아브라함의 종과 종자들을 보내며 ");
INSERT INTO kor_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","리브가에게 축복하여 가로되 `우리 누이여, 너는 천만인의 어미가 될지어다 ! 네 씨로 그 원수의 성문을 얻게 할지어다' ");
INSERT INTO kor_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","리브가가 일어나 비자와 함께 약대를 타고 그 사람을 따라가니 종이 리브가를 데리고 가니라 ");
INSERT INTO kor_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","때에 이삭이 브엘 라해로이에서 왔으니 그가 남방에 거하였었음이라 ");
INSERT INTO kor_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","이삭이 저물 때에 들에 나가 묵상하다가 눈을 들어 보매 약대들이 오더라 ");
INSERT INTO kor_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","리브가가 눈을 들어 이삭을 바라보고 약대에서 내려 ");
INSERT INTO kor_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","종에게 말하되 `들에서 배회하다가 우리에게로 마주 오는 자가 누구뇨 ?' 종이 가로되 `이는 내 주인이니이다' 리브가가 면박을 취하여 스스로 가리우더라 ");
INSERT INTO kor_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","종이 그 행한 일을 다 이삭에게 고하매 ");
INSERT INTO kor_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","이삭이 리브가를 인도하여 모친 사라의 장막으로 들이고 그를 취하여 아내를 삼고 사랑하였으니 이삭이 모친 상사 후에 위로를 얻었더라 ");
INSERT INTO kor_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","아브라함이 후처를 취하였으니 그 이름은 그두라라 ");
INSERT INTO kor_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","그가 시므란과, 욕산과, 므단과, 미디안과, 이스박과, 수아을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","욕산과, 스바와, 드단을 낳았으며 드단의 자손은 앗수르 족속과, 르두시 족속과, 르움미 족속이며 ");
INSERT INTO kor_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","미디안의 아들은 에바와, 에벨과, 하녹과, 아비다와, 엘다아니 다 그두라의 자손이었더라 ");
INSERT INTO kor_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","아브라함이 이삭에게 자기 모든 소유를 주었고 ");
INSERT INTO kor_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","자기 서자들에게도 재물을 주어 자기 생전에 그들로 자기 아들 이삭을 떠나 동방 곧 동국으로 가게 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","아브라함의 향년이 일백 칠십 오세라 ");
INSERT INTO kor_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","그가 수가 높고 나이 많아 기운이 진하여 죽어 자기 열조에게로 돌아가매 ");
INSERT INTO kor_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","그 아들 이삭과 이스마엘이 그를 마므레 앞 헷 족속 소할의 아들 에브론의 밭에 있는 막벨라 굴에 장사하였으니 ");
INSERT INTO kor_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","이것은 아브라함이 헷 족속에게서 산 밭이라 아브라함과 그 아내 사라가 거기 장사되니라 ");
INSERT INTO kor_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","아브라함이 죽은 후에 하나님이 그 아들 이삭에게 복을 주셨고 이삭을 브엘 라해로이 근처에 거하였더라 ");
INSERT INTO kor_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","사라의 여종 애굽인 하갈이 아브라함에게 낳은 아들 이스마엘의 후예는 이러하고 ");
INSERT INTO kor_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","이스마엘의 아들들의 이름은 그 이름과 그 세대 대로 이와 같으니라 이스마엘의 장자는 느바욧이요, 그 다음은 게달과, 앗브엘과, 밉삼과, ");
INSERT INTO kor_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","미스마와, 두마와, 맛사와, ");
INSERT INTO kor_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","하닷과, 데마와, 여둘과, 나비스와, 게드마니 ");
INSERT INTO kor_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","이들은 이스마엘의 아들들이요 그 촌과 부락대로 된 이름이며 그 족속대로는 십 이방백이었더라 ");
INSERT INTO kor_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","이스마엘은 향년이 일백 삼십 칠세에 기운이 진하여 죽어 자기 열조에게로 돌아갔고 ");
INSERT INTO kor_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","그 자손들은 하윌라에서부터 앗수르로 통하는 애굽 앞 술까지 이르러 그 모든 형제의 맞은편에 거하였더라 ");
INSERT INTO kor_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","아브라함의 아들 이삭의 후예는 이러하니라 아브라함이 이삭을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","이삭은 사십세에 리브가를 취하여 아내를 삼았으니 리브가는 밧단 아람의 아람 족속 중 브두엘의 딸이요 아람 족속 중 라반의 누이였더라 ");
INSERT INTO kor_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","이삭이 그 아내가 잉태하지 못하므로 그를 위하여 여호와께 간구하매 여호와께서 그 간구를 들으셨으므로 그 아내 리브가가 잉태하였더니 ");
INSERT INTO kor_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","아이들이 그의 태 속에서 서로 싸우는지라 그가 가로되 `이같으면 내가 어찌할꼬 ?' 하고 가서 여호와께 묻자온대 ");
INSERT INTO kor_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","여호와께서 그에게 이르시되 두 국민이 네 태 중에 있구나 두 민족이 네 복 중에서부터 나누이리라 이 족속이, 저 족속보다 강하겠고 큰 자는 어린 자를 섬기리라 하셨더라 ");
INSERT INTO kor_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","그 해산 기한이 찬즉 태에 쌍동이가 있었는데 ");
INSERT INTO kor_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","먼저 나온 자는 붉고 전신이 갖옷 같아서 이름을 에서라 하였고 ");
INSERT INTO kor_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","후에 나온 아우는 손으로 에서의 발꿈치를 잡았으므로 그 이름을 야곱이라 하였으며 리브가가 그들을 낳을 때에 이삭이 육십세이었더라 ");
INSERT INTO kor_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","그 아이들이 장성하매 에서는 익숙한 사냥군인고로 들 사람이 되고 야곱은 종용한 사람인고로 장막에 거하니 ");
INSERT INTO kor_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","이삭은 에서의 사냥한 고기를 좋아하므로 그를 사랑하고 리브가는 야곱을 사랑하였더라 ");
INSERT INTO kor_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","야곱이 죽을 쑤었더니 에서가 들에서부터 돌아와서 심히 곤비하여 ");
INSERT INTO kor_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","야곱에게 이르되 `내가 곤비하니 그 붉은 것을 나로 먹게 하라' 한지라 그러므로 에서의 별명은 에돔이더라 ");
INSERT INTO kor_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","야곱이 가로되 `형의 장자의 명분을 오늘날 내게 팔라' ");
INSERT INTO kor_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","에서가 가로되 `내가 죽게 되었으니 이 장자의 명분이 내게 무엇이 유익하리요' ");
INSERT INTO kor_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","야곱이 가로되 `오늘 내게 맹세하라' 에서가 맹세하고 장자의 명분을 야곱에게 판지라 ");
INSERT INTO kor_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","야곱이 떡과 팥죽을 에서에게 주매 에서가 먹으며 마시고 일어나서 갔으니 에서가 장자의 명분을 경홀히 여김이었더라 ");
INSERT INTO kor_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","아브라함 때에 첫 흉년이 들었더니 그 땅에 또 흉년이 들매 이삭이 그랄로 가서 블레셋 왕 아비멜렉에게 이르렀더니 ");
INSERT INTO kor_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","여호와께서 이삭에게 나타나 가라사대 애굽으로 내려가지 말고 내가 네게 지시하는 땅에 거하라 ");
INSERT INTO kor_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","이 땅에 유하면 내가 너와 함께 있어 네게 주고 내가 이 모든 땅을 너와 네 자손에게 주리라 내가 네 아비 아브라함에게 맹세한 것을 이루어 ");
INSERT INTO kor_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","네 자손을 하늘의 별과 같이 번성케 하며 이 모든 땅을 네 자손에게 주리니 네 자손을 인하여 천하 만민이 복을 받으리라 ");
INSERT INTO kor_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","이는 아브라함이 내 말을 순종하고 내 명령과, 내 계명과, 내 율례와, 내 법도를 지켰음이니라 하시니라 ");
INSERT INTO kor_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","이삭이 그랄에 거하였더니 ");
INSERT INTO kor_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","그 곳 사람들이 그 아내를 물으매 그가 말하기를 그는 나의 누이라 하였으니 리브가는 보기에 아리따우므로 그 곳 백성이 리브가로 인하여 자기를 죽일까 하여 그는 나의 아내라 하기를 두려워 함이었더라 ");
INSERT INTO kor_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","이삭이 거기 오래 거하였더니 이삭이 그 아내 리브가를 껴안은 것을 블레셋 왕 아비멜렉이 창으로 내다본지라 ");
INSERT INTO kor_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","이에 아비멜렉이 이삭을 불러 이르되 `그가 정녕 네 아내여늘 어찌 네 누이라 하였느냐 ?' 이삭이 그에게 대답하되 `내 생각에 그를 인하여 내가 죽게 될까 두려워하였음이로라' ");
INSERT INTO kor_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","아비멜렉이 가로되 `네가 어찌 우리에게 이렇게 행하였느냐 ? 백성 중 하나가 네 아내와 동침하기 쉬웠을뻔 하였은즉 네가 죄를 우리에게 입혔으리라' ");
INSERT INTO kor_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","아비멜렉이 이에 모든 백성에게 명하여 가로되 `이 사람이나 그 아내에게 범하는 자는 죽이리라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","이삭이 그 땅에서 농사하여 그 해에 백배나 얻었고 여호와께서 복을 주시므로 ");
INSERT INTO kor_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","그 사람이 창대하고 왕성하여 마침내 거부가 되어 ");
INSERT INTO kor_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","양과 소가 떼를 이루고 노복이 심히 많으므로 블레셋 사람이 그를 시기하여 ");
INSERT INTO kor_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","그 아비 아브라함 때에 그 아비의 종들이 판 모든 우물을 막고 흙으로 메웠더라 ");
INSERT INTO kor_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","아비멜렉이 이삭에게 이르되 `네가 우리보다 크게 강성한즉 우리를 떠나가라' ");
INSERT INTO kor_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","이삭이 그곳을 떠나 그랄 골짜기에 장막을 치고 거기 우거하며 ");
INSERT INTO kor_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","그 아비 아브라함 때에 팠던 우물들을 다시 팠으니 이는 아브라함 죽은 후에 블레셋 사람이 그 우물들을 메웠음이라 이삭이 그 우물들의 이름을 그 아비의 부르던 이름으로 불렀더라 ");
INSERT INTO kor_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","이삭의 종들이 골짜기에 파서 샘 근원을 얻었더니 ");
INSERT INTO kor_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","그랄 목자들이 이삭의 목자와 다투어 가로되 `이 물은 우리의 것이라' 하매 이삭이 그 다툼을 인하여 그 우물 이름을 에섹이라 하였으며 ");
INSERT INTO kor_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","또 다른 우물을 팠더니 그들이 또 다투는고로 그 이름을 싯나라 하였으며 ");
INSERT INTO kor_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","이삭이 거기서 옮겨 다른 우물을 팠더니 그들이 다투지 아니하였으므로 그 이름을 르호봇이라 하여 가로되 `이제는 여호와께서 우리의 장소를 넓게 하셨으니 이 땅에서 우리가 번성하리로다' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","이삭이 거기서부터 브엘세바로 올라갔더니 ");
INSERT INTO kor_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","그 밤에 여호와께서 그에게 나타나 가라사대 나는 네 아비 아브라함의 하나님이니 두려워 말라! 내 종 아브라함을 위하여 내가 너와 함께 있어 네게 복을 주어 네 자손으로 번성케 하리라 하신지라 ");
INSERT INTO kor_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","이삭이 그 곳에 단을 쌓아 여호와의 이름을 부르고 거기 장막을 쳤더니 그 종들이 거기서도 우물을 팠더라 ");
INSERT INTO kor_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","아비멜렉이 그 친구 아훗삿과 군대장관 비골로 더불어 그랄에서부터 이삭에게로 온지라 ");
INSERT INTO kor_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","이삭이 그들에게 이르되 `너희가 나를 미워하여 나로 너희를 떠나가게 하였거늘 어찌하여 내게 왔느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","그들이 가로되 `여호와께서 너와 함께 계심을 우리가 분명히 보았으므로 우리의 사이 곧 우리와 너의 사이에 맹세를 세워 너와 계약을 맺으리라 말하였노라 ");
INSERT INTO kor_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","너는 우리를 해하지 말라 이는 우리가 너를 범하지 아니하고 선한 일만 네게 행하며 너로 평안히 가게 하였음이니라 이제 너는 여호와께 복을 받은 자니라 !' ");
INSERT INTO kor_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","이삭이 그들을 위하여 잔치를 베풀매 그들이 먹고 마시고 ");
INSERT INTO kor_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","아침에 일찌기 일어나 서로 맹세한 후에 이삭이 그들을 보내매 그들이 평안히 갔더라 ");
INSERT INTO kor_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","그 날에 이삭의 종들이 자기들의 판 우물에 대하여 이삭에게 와서 고하여 가로되 `우리가 물을 얻었나이다' 하매 ");
INSERT INTO kor_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","그가 그 이름을 세바라 한지라 그러므로 그 성읍 이름이 오늘까지 브엘세바더라 ");
INSERT INTO kor_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","에서가 사십세에 헷 족속 브에리의 딸 유딧과, 헷 족속 엘론의 딸 바스맛을 아내로 취하였더니 ");
INSERT INTO kor_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","그들이 이삭과 리브가의 마음의 근심이 되었더라 ");
INSERT INTO kor_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","이삭이 나이 많아 눈이 어두워 잘 보지 못하더니 맏아들 에서를 불러 가로되 `내 아들아' 하매 그가 가로되 `내가 여기 있나이다' 하니 ");
INSERT INTO kor_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","이삭이 가로되 `내가 이제 늙어 어느날 죽을는지 알지 못하노니 ");
INSERT INTO kor_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","그런즉 네 기구 곧 전통과 활을 가지고 들에 가서 나를 위하여 사냥하여 ");
INSERT INTO kor_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","나의 즐기는 별미를 만들어 내게로 가져다가 먹게 하여 나로 죽기 전에 내 마음껏 네게 축복하게 하라' ");
INSERT INTO kor_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","이삭이 그 아들 에서에게 말할때에 리브가가 들었더니 에서가 사냥하여 오려고 들로 나가매 ");
INSERT INTO kor_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","리브가가 그 아들 야곱에게 일러 가로되 `네 부친이 네 형 에서에게 말씀하시는 것을 내가 들으니 이르시기를 ");
INSERT INTO kor_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","나를 위하여 사냥하여 가져다가 별미를 만들어 나로 먹게 하여 죽기 전에 여호와 앞에서 네게 축복하게 하라 하셨으니 ");
INSERT INTO kor_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","그런즉 내 아들아 내 말을 좇아 내가 네게 명하는대로 ");
INSERT INTO kor_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","염소떼에 가서 거기서 염소의 좋은 새끼를 내게로 가져오면 내가 그것으로 네 부친을 위하여 그 즐기시는 별미를 만들리니 ");
INSERT INTO kor_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","네가 그것을 가져 네 부친께 드려서 그로 죽으시기 전에 네게 축복하기 위하여 잡수시게 하라' ");
INSERT INTO kor_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","야곱이 그 모친 리브가에게 이르되 `내 형 에서는 털사람이요, 나는 매끈매끈한 사람인즉 ");
INSERT INTO kor_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","아버지께서 나를 만지실진대 내가 아버지께 속이는 자로 뵈일지라 복은 고사하고 저주를 받을까 하나이다' ");
INSERT INTO kor_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","어미가 그에게 이르되 `내 아들아, 너의 저주는 내게로 돌리리니 내 말만 좇고 가서 가져오라' ");
INSERT INTO kor_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","그가 가서 취하여 어미에게로 가져왔더니 그 어미가 그 아비의 즐기는 별미를 만들었더라 ");
INSERT INTO kor_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","리브가가 집 안 자기 처소에 있는 맏아들 에서의 좋은 의복을 취하여 작은 아들 야곱에게 입히고 ");
INSERT INTO kor_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","또 염소 새끼의 가죽으로 그 손과 목의 매끈매끈한 곳에 꾸미고 ");
INSERT INTO kor_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","그 만든 별미와 떡을 자기 아들 야곱의 손에 주매 ");
INSERT INTO kor_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","야곱이 아버지에게 나아가서 `내 아버지여' 하고 부른대 가로되 `내가 여기 있노라 내 아들아 네가 누구냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","야곱이 아비에게 대답하되 `나는 아버지의 맏아들 에서로소이다 아버지께서 내게 명하신대로 내가 하였사오니 청컨대 일어나 앉아서 내 사냥한 고기를 잡수시고 아버지의 마음껏 내게 축복하소서 !' ");
INSERT INTO kor_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","이삭이 그 아들에게 이르되 `내 아들아, 네가 어떻게 이같이 속히 잡았느냐 ?' 그가 가로되 `아버지의 하나님 여호와께서 나로 순적히 만나게 하셨음이니이다' ");
INSERT INTO kor_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","이삭이 야곱에게 이르되 `내 아들아, 가까이 오라 네가 과연 내 아들 에서인지 아닌지 내가 너를 만지려 하노라' ");
INSERT INTO kor_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","야곱이 그 아비 이삭에게 가까이 가니 이삭이 만지며 가로되 `음성은 야곱의 음성이나, 손은 에서의 손이로다' 하며 ");
INSERT INTO kor_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","그 손이 형 에서의 손과 같이 털이 있으므로 능히 분별치 못하고 축복하였더라 ");
INSERT INTO kor_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","이삭이 가로되 네가 참 내 아들 에서냐 그가 대답하되 그러하니이다 ");
INSERT INTO kor_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","이삭이 가로되 `내게로 가져오라 내 아들의 사냥한 고기를 먹고 내 마음껏 네게 축복하리라 !' 야곱이 그에게로 가져가매 그가 먹고 또 포도주를 가져가매 그가 마시고 ");
INSERT INTO kor_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","그 아비 이삭이 그에게 이르되 `내 아들아, 가까이 와서 내게 입맞추라` ");
INSERT INTO kor_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","그가 가까이 가서 그에게 입맞추니 아비가 그 옷의 향취를 맡고 그에게 축복하여 가로되 `내 아들의 향취는 여호와의 복 주신 밭의 향취로다 ");
INSERT INTO kor_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","하나님은 하늘의 이슬과 땅의 기름짐이며 풍성한 곡식과 포도주로 네게 주시기를 원하노라 ");
INSERT INTO kor_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","만민이 너를 섬기고 열국이 네게 굴복하리니 네가 형제들의 주가 되고 네 어미의 아들들이 네게 굴복하며 네게 저주하는 자는 저주를 받고 네게 축복하는 자는 복을 받기를 원하노라' ");
INSERT INTO kor_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","이삭이 야곱에게 축복하기를 마치매 야곱이 그 아비 이삭 앞에서 나가자 곧 그 형 에서가 사냥하여 돌아온지라 ");
INSERT INTO kor_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","그가 별미를 만들어 아비에게로 가지고 가서 가로되 `아버지여, 일어나서 아들의 사냥한 고기를 잡수시고 마음껏 내게 축복하소서' ");
INSERT INTO kor_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","그 아비 이삭이 그에게 이르되 `너는 누구냐 ?' 그가 대답하되 `나는 아버지의 아들 곧 아버지의 맏아들 에서로소이다` ");
INSERT INTO kor_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","이삭이 심히 크게 떨며 가로되 `그런즉 사냥한 고기를 내게 가져온 자가 누구냐 ? 너 오기 전에 내가 다 먹고 그를 위하여 축복하였은즉 그가 정녕 복을 받을 것이니라 !' ");
INSERT INTO kor_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","에서가 그 아비의 말을 듣고 방성 대곡하며 아비에게 이르되 `내 아버지여, 내게 축복하소서 내게도 그리하소서' ");
INSERT INTO kor_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","이삭이 가로되 `네 아우가 간교하게 와서 네 복을 빼앗았도다' ");
INSERT INTO kor_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","에서가 가로되 `그의 이름을 야곱이라 함이 합당치 아니하니이까 ? 그가 나를 속임이 이것이 두번째니이다 전에는 나의 장자의 명분을 빼앗고 이제는 내 복을 빼앗았나이다' 또 가로되 `아버지께서 나를 위하여 빌 복을 남기지 아니하셨나이까 ?' ");
INSERT INTO kor_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","이삭이 에서에게 대답하여 가로되 `내가 그를 너의 주로 세우고 그 모든 형제를 내가 그에게 종으로 주었으며 곡식과 포도주를 그에게 공급하였으니 내 아들아 ! 내가 네게 무엇을 할 수 있으랴 ?' ");
INSERT INTO kor_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","에서가 아비에게 이르되 `내 아버지여, 아버지의 빌 복이 이 하나뿐이리이까 ? 내 아버지여, 내게 축복하소서 내게도 그리 하소서' 하고 소리를 높여 우니 ");
INSERT INTO kor_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","그 아비 이삭이 그에게 대답하여 가로되 `너의 주소는 땅의 기름짐에서 뜨고 내리는 하늘 이슬에서 뜰 것이며 ");
INSERT INTO kor_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","너는 칼을 믿고 생활하겠고 네 아우를 섬길 것이며 네가 매임을 벗을 때에는 그 멍에를 네 목에서 떨쳐버리리라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","그 아비가 야곱에게 축복한 그 축복을 인하여 에서가 야곱을 미워하여 심중에 이르기를 `아버지를 곡할 때가 가까왔은즉 내가 내 아우 야곱을 죽이리라' 하였더니 ");
INSERT INTO kor_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","맏아들 에서의 이 말이 리브가에게 들리매 이에 보내어 작은 아들 야곱을 불러 그에게 이르되 `네 형 에서가 너를 죽여 그 한을 풀려하나니 ");
INSERT INTO kor_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","내 아들아, 내 말을 좇아 일어나 하란으로 가서 내 오라버니 라반에게 피하여 ");
INSERT INTO kor_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","네 형의 노가 풀리기 까지 몇날 동안 그와 함께 거하라 ");
INSERT INTO kor_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","네 형의 분노가 풀려 네가 자기에게 행한 것을 잊어버리거든 내가 곧 보내어 너를 거기서 불러오리라 어찌 하루에 너희 둘을 잃으랴' ");
INSERT INTO kor_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","리브가가 이삭에게 이르되 `내가 헷 사람의 딸들을 인하여 나의 생명을 싫어하거늘 야곱이 만일 이 땅의 딸들 곧 그들과 같은 헷 사람의 딸들 중에서 아내를 취하면 나의 생명이 내게 무슨 재미가 있으리이까 ");
INSERT INTO kor_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","이삭이 야곱을 불러 그에게 축복하고 또 부탁하여 가로되 `너는 가나안 사람의 딸들 중에서 아내를 취하지 말고 ");
INSERT INTO kor_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","일어나 밧단아람으로 가서 너의 외조부 브두엘 집에 이르러 거기서 너의 외삼촌 라반의 딸 중에서 아내를 취하라 ");
INSERT INTO kor_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","전능하신 하나님이 네게 복을 주어 너로 생육하고 번성케하사 너로 여러 족속을 이루게 하시고 ");
INSERT INTO kor_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","아브라함에게 허락하신 복을 네게 주시되 너와 너와 함께 네 자손에게 주사 너로 하나님이 아브라함에게 주신 땅 곧 너의 우거하는 땅을 유업으로 받게 하시기를 원하노라' ");
INSERT INTO kor_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","이에 이삭이 야곱을 보내었더니 밧단아람으로 가서 라반에게 이르렀으니 라반은 아람 사람 브두엘의 아들이요 야곱과 에서의 어미 리브가의 오라비더라 ");
INSERT INTO kor_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","에서가 본즉 이삭이 야곱에게 축복하고 그를 밧단아람으로 보내어 거기서 아내를 취하게 하였고 또 그에게 축복하고 명하기를 `너는 가나안 사람의 딸들 중에서 아내를 취하지 말라' 하였고 ");
INSERT INTO kor_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","또 야곱이 부모의 명을 좇아 밧단아람으로 갔으며 ");
INSERT INTO kor_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","에서가 또 본즉 가나안 사람의 딸들이 그 아비 이삭을 기쁘게 못하는지라 ");
INSERT INTO kor_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","이에 에서가 이스마엘에게 가서 그 본처들 외에 아브라함의 아들 이스마엘의 딸이요 느바욧의 누이인 마할랏을 아내로 취하였더라 ");
INSERT INTO kor_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","야곱이 브엘세바에서 떠나 하란으로 향하여 가더니 ");
INSERT INTO kor_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","한 곳에 이르러는 해가 진지라 거기서 유숙하려고 그 곳의 한 돌을 취하여 베개하고 거기 누워 자더니 ");
INSERT INTO kor_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","꿈에 본즉 사닥다리가 땅 위에 섰는데 그 꼭대기가 하늘에 닿았고 또 본즉 하나님의 사자가 그 위에서 오르락 내리락하고 ");
INSERT INTO kor_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","또 본즉 여호와께서 그 위에 서서 가라사대 나는 여호와니 너의 조부 아브라함의 하나님이요 이삭의 하나님이라 ! 너 누운 땅을 내가 너와 네 자손에게 주리니 ");
INSERT INTO kor_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","네 자손이 땅의 티끌같이 되어서 동서남북에 편만할지며 땅의 모든 족속이 너와 네 자손을 인하여 복을 얻으리라 ! ");
INSERT INTO kor_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","내가 너와 함께 있어 네가 어디로 가든지 너를 지키며 너를 이끌어 이 땅으로 돌아오게 할지라 내가 네게 허락한 것을 다 이루기까지 너를 떠나지 아니하리라 ! 하신지라 ");
INSERT INTO kor_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","야곱이 잠이 깨어 가로되 `여호와께서 과연 여기 계시거늘 내가 알지 못하였도다' ");
INSERT INTO kor_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","이에 두려워하여 가로되 `두렵도다, 이 곳이여 ! 다른 것이 아니라 이는 하나님의 전이요, 이는 하늘의 문이로다' 하고 ");
INSERT INTO kor_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","야곱이 아침에 일찌기 일어나 베개하였던 돌을 가져 기둥으로 세우고 그 위에 기름을 붓고 ");
INSERT INTO kor_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","그곳 이름을 벧엘이라 하였더라 이 성의 본 이름은 루스더라 ");
INSERT INTO kor_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","야곱이 서원하여 가로되 `하나님이 나와 함께 계시사 내가 가는 이 길에서 나를 지키시고 먹을 양식과 입을 옷을 주사 ");
INSERT INTO kor_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","나로 평안히 아비 집으로 돌아가게 하시오면 여호와께서 나의 하나님이 되실 것이요 ");
INSERT INTO kor_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","내가 기둥으로 세운 이 돌이 하나님의 전이 될 것이요 하나님께서 내게 주신 모든 것에서 십분 일을 내가 반드시 하나님께 드리겠나이다` 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","야곱이 발행하여 동방 사람의 땅에 이르러 ");
INSERT INTO kor_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","본즉 들에 우물이 있고 그 곁에 양 세 떼가 누웠으니 이는 목자들이 그 우물에서 물을 양떼에게 먹임이라 큰 돌로 우물 아구를 덮었다가 ");
INSERT INTO kor_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","모든 떼가 모이면 그들이 우물 아구에서 돌을 옮기고 양에게 물을 먹이고는 여전히 우물 아구 그 자리에 돌을 덮더라 ");
INSERT INTO kor_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","야곱이 그들에게 이르되 `나의 형제여 어디로서뇨 ?' 그들이 가로되 `하란에서로라' ");
INSERT INTO kor_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","야곱이 그들에게 이르되 `너희가 나홀의 손자 라반을 아느냐 ?' 그들이 가로되 `아노라' ");
INSERT INTO kor_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","야곱이 그들에게 이르되 `그가 평안하냐 ?' 가로되 `평안하니라 딸 라헬이 지금 양을 몰고 오느니라' ");
INSERT INTO kor_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","야곱이 가로되 `해가 아직 높은즉 짐승 모일 때가 아니니 양에게 물을 먹이고 가서 뜯기라' ");
INSERT INTO kor_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","그들이 가로되 `우리가 그리하지 못하겠노라 떼가 다 모이고 목자들이 우물 아구에서 돌을 옮겨야 우리가 양에게 물을 먹이느리라' ");
INSERT INTO kor_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","야곱이 그들과 말하는 중에 라헬이 그 아비의 양과 함께 오니 그가 그의 양들을 침이었더라 ");
INSERT INTO kor_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","야곱이 그 외삼촌 라반의 딸 라헬과 그 외삼촌의 양을 보고 나아가서 우물 아구에서 돌을 옮기고 외삼촌 라반의 양떼에게 물을 먹이고 ");
INSERT INTO kor_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","그가 라헬에게 입맞추고 소리내어 울며 ");
INSERT INTO kor_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","그에게 자기가 그의 아비의 생질이요 리브가의 아들됨을 고하였더니 라헬이 달려가서 그 아비에게 고하매 ");
INSERT INTO kor_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","라반이 그 생질 야곱의 소식을 듣고 달려와서 그를 영접하여 안고 입맞추고 자기 집으로 인도하여 들이니 야곱이 자기의 모든 일을 라반에게 고하매 ");
INSERT INTO kor_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","라반이 가로되 `너는 참으로 나의 골육이로다' 하였더라 야곱이 한달을 그와 함께 거하더니 ");
INSERT INTO kor_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","라반이 야곱에게 이르되 `네가 비록 나의 생질이나 어찌 공으로 내 일만 하겠느냐 ? 무엇이 네 보수겠느냐 ? 내게 고하라' ");
INSERT INTO kor_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","라반이 두 딸이 있으니 형의 이름은 레아요 아우의 이름은 라헬이라 ");
INSERT INTO kor_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","레아는 안력이 부족하고 라헬은 곱고 아리따우니 ");
INSERT INTO kor_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","야곱이 라헬을 연애하므로 대답하되 `내가 외삼촌의 작은 딸 라헬을 위하여 외삼촌에게 칠년을 봉사하리이다' ");
INSERT INTO kor_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","라반이 가로되 `그를 네게 주는 것이 타인에게 주는 것보다 나으니 나와 함께 있으라' ");
INSERT INTO kor_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","야곱이 라헬을 위하여 칠년 동안 라반을 봉사하였으나 그를 연애하는 까닭에 칠년을 수일 같이 여겼더라 ");
INSERT INTO kor_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","야곱이 라반에게 이르되 `내 기한이 찼으니 내 아내를 내게 주소서 내가 그에게 들어가겠나이다' ");
INSERT INTO kor_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","라반이 그 곳 사람을 다 모아 잔치하고 ");
INSERT INTO kor_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","저녁에 그 딸 레아를 야곱에게로 데려가매 야곱이 그에게로 들어가니라 ");
INSERT INTO kor_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","라반이 또 그 여종 실바를 그 딸 레아에게 시녀로 주었더라 ");
INSERT INTO kor_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","야곱이 아침에 보니 레아라 라반에게 이르되 `외삼촌이 어찌하여 내게 이같이 행하셨나이까 ? 내가 라헬을 위하여 외삼촌께 봉사하지 아니하였나이까 ? 외삼촌이 나를 속이심은 어찜이니이까 ?' ");
INSERT INTO kor_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","라반이 가로되 `형보다 아우를 먼저 주는 것은 우리 지방에서 하지 아니하는 바이라 ");
INSERT INTO kor_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","이를 위하여 칠일을 채우라 우리가 그도 네게 주리니 네가 그를 위하여 또 칠년을 내게 봉사할지니라' ");
INSERT INTO kor_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","야곱이 그대로 하여 그 칠일을 채우매 라반이 딸 라헬도 그에게 아내로 주고 ");
INSERT INTO kor_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","라반이 또 그 여종 빌하를 그 딸 라헬에게 주어 시녀가 되게 하매 ");
INSERT INTO kor_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","야곱이 또한 라헬에게로 들어갔고 그가 레아보다 라헬을 더 사랑하고 다시 칠년을 라반에게 봉사하였더라 ");
INSERT INTO kor_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","여호와께서 레아에게 총이 없음을 보시고 그의 태를 여셨으나 라헬은 무자하였더라 ");
INSERT INTO kor_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","레아가 잉태하여 아들을 낳고 그 이름을 르우벤이라 하여 가로되 `여호와께서 나의 괴로움을 권고하셨으니 이제는 내 남편이 나를 사랑하리로다' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","그가 다시 잉태하여 아들을 낳고 가로되 `여호와께서 나의 총이 없음을 들으셨으므로 내게 이도 주셨도다' 하고 그 이름을 시므온이라 하였으며 ");
INSERT INTO kor_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","그가 또 잉태하여 아들을 낳고 가로되 `내가 그에게 세 아들을 낳았으니 내 남편이 지금부터 나와 연합하리로다' 하고 그 이름을 레위라 하였으며 ");
INSERT INTO kor_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","그가 또 잉태하여 아들을 낳고 가로되 `내가 이제는 여호와를 찬송하리로다 !' 하고 이로 인하여 그가 그 이름을 유다라 하였고 그의 생산이 멈추었더라 ");
INSERT INTO kor_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","라헬이 자기가 야곱에게 아들을 낳지 못함을 보고 그 형을 투기하여 야곱에게 이르되 `나로 자식을 낳게 하라 그렇지 아니하면 내가 죽겠노라' ");
INSERT INTO kor_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","야곱이 라헬에게 노를 발하여 가로되 `그대로 성태치 못하게 하시는 이는 하나님이시니 내가 하나님을 대신하겠느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","라헬이 가로되 `나의 여종 빌하에게로 들어가라 그가 아들을 낳아 내 무릎에 두리니 그러면 나도 그를 인하여 자식을 얻겠노라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","그 시녀 빌하를 남편에게 첩으로 주매 야곱이 그에게로 들어갔더니 ");
INSERT INTO kor_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","빌하가 잉태하여 야곱에게 아들을 낳은지라 ");
INSERT INTO kor_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","라헬이 가로되 `하나님이 내 억울함을 푸시려고 내 소리를 들으사 내게 아들을 주셨다' 하고 이로 인하여 그 이름을 단이라 하였으며 ");
INSERT INTO kor_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","라헬의 시녀 빌하가 다시 잉태하여 둘째 아들을 야곱에게 낳으매 ");
INSERT INTO kor_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","라헬이 가로되 `내가 형과 크게 경쟁하여 이기었다' 하고 그 이름을 납달리라 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","레아가 자기의 생산이 멈춤을 보고 그 시녀 실바를 취하여 야곱에게 주어 첩을 삼게 하였더니 ");
INSERT INTO kor_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","레아의 시녀 실바가 야곱에게 아들을 낳으매 ");
INSERT INTO kor_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","레아가 가로되 `복되도다' 하고 그 이름을 갓이라 하였으며 ");
INSERT INTO kor_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","레아의 시녀 실바가 둘째 아들을 야곱에게 낳으매 ");
INSERT INTO kor_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","레아가 가로되 `기쁘도다 모든 딸들이 나를 기쁜 자라 하리로다' 하고 그 이름을 아셀이라 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","맥추 때에 르우벤이 나가서 들에서 합환채를 얻어 어미 레아에게 드렸더니 라헬이 레아에게 이르되 `형의 아들의 합환채를 청구하노라' ");
INSERT INTO kor_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","레아가 그에게 이르되 `네가 내 남편을 빼앗은 것이 작은 일이냐 ? 네가 내 아들의 합환채도 빼앗고자 하느냐 ?' 라헬이 가로되 `그러면 형의 아들의 합환채 대신에 오늘밤에 내 남편이 형과 동침하리라' 하리라 ");
INSERT INTO kor_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","저물 때에 야곱이 들에서 돌아오매 레아가 나와서 그를 영접하며 이르되 `내게로 들어오라 내가 내 아들의 합환채로 당신을 샀노라' 그 밤에 야곱이 그와 동침하였더라 ");
INSERT INTO kor_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","하나님이 레아를 들으셨으므로 그가 잉태하여 다섯째 아들을 야곱에게 낳은지라 ");
INSERT INTO kor_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","레아가 가로되 `내가 내 시녀를 남편에게 주었으므로 하나님이 내게 그 값을 주셨다' 하고 그 이름을 잇사갈이라 하였으며 ");
INSERT INTO kor_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","레아가 다시 잉태하여 여섯째 아들을 야곱에게 낳은지라 ");
INSERT INTO kor_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","레아가 가로되 `하나님이 네게 후한 선물을 주시도다 내가 남편에게 여섯 아들을 낳았으니 이제는 그가 나와 함께 거하리라' 하고 그 이름을 스불론이라 하였으며 ");
INSERT INTO kor_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","그 후에 그가 딸을 낳고 그 이름을 디나라 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","하나님이 라헬을 생각하신지라 하나님이 그를 들으시고 그 태를 여신고로 ");
INSERT INTO kor_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","그가 잉태하여 아들을 낳고 가로되 `하나님이 나의 부끄러움을 씻으셨다' 하고 ");
INSERT INTO kor_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","그 이름을 요셉이라 하니 여호와는 다시 다른 아들을 내게 더하시기를 원하노라 함이었더라 ");
INSERT INTO kor_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","라헬이 요셉을 낳은 때에 야곱이 라반에게 이르되 `나를 보내어 내 고향 내 본토로 가게 하시되 ");
INSERT INTO kor_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","내가 외삼촌에게서 일하고 얻은 처자를 내게 주어 나로 가게 하소서 내가 외삼촌께 한 일은 외삼촌이 아시나이다' ");
INSERT INTO kor_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","라반이 그에게 이르되 `여호와께서 너로 인하여 내게 복 주신줄을 내가 깨달았노니 네가 나를 사랑스럽게 여기거든 유하라' ");
INSERT INTO kor_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","또 가로되 `네 품삯을 정하라 내가 그것을 주리라' ");
INSERT INTO kor_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","야곱이 그에게 이르되 `내가 어떻게 외삼촌을 섬겼는지, 어떻게 외삼촌의 짐승을 쳤는지 외삼촌이 아시나이다 ");
INSERT INTO kor_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","내가 오기 전에는 외삼촌의 소유가 적더니 번성하여 떼를 이루었나이다 나의 공력을 따라 여호와께서 외삼촌에게 복을 주셨나이다 그러나 나는 어느 때에나 내 집을 세우리이까 ?' ");
INSERT INTO kor_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","라반이 가로되 내가 무엇으로 네게 주랴 야곱이 가로되 외삼촌께서 아무 것도 내게 주실 것이 아니라 나를 위하여 이 일을 행하시면 내가 다시 외삼촌의 양떼를 먹이고 지키리이다 ");
INSERT INTO kor_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","야곱이 들은즉 라반의 아들들의 말이 `야곱이 우리 아버지의 소유를 다 빼앗고 우리 아버지의 소유로 인하여 이같이 거부가 되었다' 하는지라 ");
INSERT INTO kor_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","야곱이 라반의 안색을 본즉 자기에게 대하여 전과 같지 아니하더라 ");
INSERT INTO kor_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","여호와께서 야곱에게 이르시되 네 조상의 땅, 네 족속에게로 돌아가라 내가 너와 함께 있으리라 하신지라 ");
INSERT INTO kor_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","야곱이 보내어 라헬과 레아를 자기 양떼 있는 들로 불러다가 ");
INSERT INTO kor_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","그들에게 이르되 `내가 그대들의 아버지의 안색을 본즉 내게 대하여 전과 같지 아니하도다 그러할지라도 내 아버지의 하나님은 나와 함께 계셨느니라 ");
INSERT INTO kor_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","그대들도 알거니와 내가 힘을 다하여 그대들의 아버지를 섬겼거늘 ");
INSERT INTO kor_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","그대들의 아버지가 나를 속여 품삯을 열번이나 변역하였느니라 그러나 하나님이 그를 금하사 나를 해치 못하게 하셨으며 ");
INSERT INTO kor_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","그가 이르기를 점 있는 것이 네 삯이 되리라 하면 온 양떼의 낳은 것이 점 있는 것이요 또 얼룩무늬 있는 것이 네 삯이 되리라 하면 온 양떼의 낳은 것이 얼룩무늬 있는 것이니 ");
INSERT INTO kor_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","하나님이 이같이 그대들의 아버지의 짐승을 빼앗아 내게 주셨으니라 ");
INSERT INTO kor_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","그 양떼가 새끼 밸 때에 내가 꿈에 눈을 들어 보니 양떼를 탄 수양은 다 얼룩무늬 있는것, 점 있는 것, 아롱진 것이었더라 ");
INSERT INTO kor_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","꿈에 하나님의 사자가 내게 말씀하시기를 야곱아 ! 하기로 내가 대답하기를 여기 있나이다 ! 하매 ");
INSERT INTO kor_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","가라사대 네 눈을 들어 보라 ! 양떼를 탄 수양은 다 얼룩무늬 있는것, 점 있는 것, 아롱진 것이니라 라반이 네게 행한 모든 것을 내가 보았노라 ");
INSERT INTO kor_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","나는 벧엘 하나님이라 ! 네가 거기서 기둥에 기름을 붓고 거기서 내게 서원하였으니 지금 일어나 이곳을 떠나서 네 출생지로 돌아가라 하셨느니라' ");
INSERT INTO kor_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","라헬과 레아가 그에게 대답하여 가로되 `우리가 우리 아버지 집에서 무슨 분깃이나 유업이나 있으리요 ");
INSERT INTO kor_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","아버지가 우리를 팔고 우리의 돈을 다 먹었으니 아버지가 우리를 외인으로 여기는 것이 아닌가 ");
INSERT INTO kor_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","하나님이 우리 아버지에게서 취하신 재물은 우리와 우리 자식의 것이니 이제 하나님이 당신에게 이르신 일을 다 준행하라' ");
INSERT INTO kor_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","야곱이 일어나 자식들과 아내들을 약대들에게 태우고 ");
INSERT INTO kor_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","그 얻은 바 모든 짐승과 모든 소유물 곧 그가 밧단아람에서 얻은 짐승을 이끌고 가나안 땅에 있는 그 아비 이삭에게로 가려할새 ");
INSERT INTO kor_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","때에 라반이 양털을 깎으러 갔으므로 라헬은 그 아비의 드라빔을 도적질하고 ");
INSERT INTO kor_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","야곱은 그 거취를 아람 사람 라반에게 고하지 않고 가만히 떠났더라 ");
INSERT INTO kor_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","그가 그 모든 소유를 이끌고 강을 건너 길르앗 산을 향하여 도망한지 ");
INSERT INTO kor_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","삼일만에 야곱의 도망한 것이 라반에게 들린지라 ");
INSERT INTO kor_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","라반이 그 형제를 거느리고 칠일 길을 쫓아가 길르앗산에서 그에게 미쳤더니 ");
INSERT INTO kor_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","밤에 하나님이 아람 사람 라반에게 현몽하여 가라사대 너는 삼가 야곱에게 선악간 말하지 말라 하셨더라 ");
INSERT INTO kor_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","라반이 야곱을 쫓아 미치니 야곱이 산에 장막을 쳤는지라 라반이 그 형제로 더불어 길르앗산에 장막을 치고 ");
INSERT INTO kor_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","라반이 야곱에게 이르되 `네가 내게 알리지 아니하고 가만히 내 딸들을 칼로 잡은 자 같이 끌고 갔으니 어찌 이같이 하였느냐 ? ");
INSERT INTO kor_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","내가 즐거움과, 노래와, 북과, 수금으로 너를 보내겠거늘 어찌하여 네가 나를 속이고 가만히 도망하고 내게 고하지 아니하였으며 ");
INSERT INTO kor_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","나로 내 손자들과 딸들에게 입맞추지 못하게 하였느냐 ? 네 소위가 실로 어리석도다 ");
INSERT INTO kor_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","너를 해할만한 능력이 내 손에 있으나 너희 아버지의 하나님이 어제밤에 내게 말씀하시기를 너는 삼가 야곱에게 선악간 말하지 말라 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","이제 네가 네 아비 집을 사모하여 돌아가려는 것은 가하거니와 어찌 내 신(神)을 도적질하였느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","야곱이 라반에게 대답하여 가로되 `내가 말하기를 외삼촌이 외삼촌의 딸들을 내게서 억지로 빼앗으리라 하여 두려워하였음이니이다 ");
INSERT INTO kor_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","외삼촌의 신은 뉘게서 찾든지 그는 살지 못할 것이요 우리 형제들 앞에서 무엇이든지 외삼촌의 것이 발견되거든 외삼촌에게로 하소서' 하니 야곱은 라헬이 그것을 도적질한 줄을 알지 못함이었더라 ");
INSERT INTO kor_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","라반이 야곱의 장막에 들어가고 레아의 장막에 들어가고 두 여종의 장막에 들어갔으나 찾지 못하고 레아의 장막에서 나와 라헬의 장막에 들어가매 ");
INSERT INTO kor_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","라헬이 그 드라빔을 가져 약대 안장 아래 넣고 그 위에 앉은지라 라반이 그 장막에서 찾다가 얻지 못하매 ");
INSERT INTO kor_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","라헬이 그 아비에게 이르되 `마침 경수가 나므로 일어나서 영접할수 없사오니 내 주는 노하지 마소서' 하니라 라반이 그 드라빔을 두루 찾다가 얻지 못한지라 ");
INSERT INTO kor_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","야곱이 노하여 라반을 책망할새 야곱이 라반에게 대척하여 가로되 나의 허물이 무엇이니이까 ? 무슨 죄가 있기에 외삼촌께서 나를 불같이 급히 쫓나이까 ? ");
INSERT INTO kor_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","외삼촌께서 내 물건을 다 뒤져 보셨으니 외삼촌의 가장집물 중에 무엇을 찾았나이까 ? 여기 나의 형제와 외삼촌의 형제 앞에 그것을 두고 우리 두 사이에 판단하게 하소서 ");
INSERT INTO kor_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","내가 이 이십년에 외삼촌과 함께 하였거니와 외삼촌의 암양들이나 암염소들이 낙태하지 아니하였고 또 외삼촌의 양떼의 수양을 내가 먹지 아니하였으며 ");
INSERT INTO kor_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","물려 찢긴 것은 내가 외삼촌에게로 가져가지 아니하고 스스로 그것을 보충하였으며 낮에 도적을 맞았든지, 밤에 도적을 맞았든지, 내가 외삼촌에게 물어 내었으며 ");
INSERT INTO kor_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","내가 이와 같이 낮에는 더위를 무릅쓰고, 밤에는 추위를 당하며, 눈붙일 겨를도 없이 지내었나이다 ");
INSERT INTO kor_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","내가 외삼촌의 집에 거한 이 이십년에 외삼촌의 두 딸을 위하여 십 사년, 외삼촌의 양떼를 위하여 육년을 외삼촌을 봉사하였거니와 외삼촌께서 내 품값을 열번이나 변역하셨으니 ");
INSERT INTO kor_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","우리 아버지의 하나님, 아브라함의 하나님, 곧 이삭의 경외하는 이가 나와 함께 계시지 아니하셨더면 외삼촌께서 이제 나를 공수로 돌려 보내셨으리이다마는 하나님이 나의 고난과 내 손의 수고를 감찰하시고 어제밤에 외삼촌을 책망하셨나이다 ");
INSERT INTO kor_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","라반이 야곱에게 대답하여 가로되 `딸들은 내 딸이요, 자식들은 내 자식이요, 양떼는 나의 양떼요, 네가 보는 것은 다 내 것이라 내가 오늘날 내 딸들과 그 낳은 자식들에게 어찌할 수 있으랴 ? ");
INSERT INTO kor_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","이제 오라 너와 내가 언약을 세워 그것으로 너와 나 사이에 증거를 삼을 것이니라' ");
INSERT INTO kor_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","이에 야곱이 돌을 가져 기둥으로 세우고 ");
INSERT INTO kor_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","또 `그 형제들에게 돌을 모으라` 하니 그들이 돌을 취하여 무더기를 이루매 무리가 거기 무더기 곁에서 먹고 ");
INSERT INTO kor_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","라반은 그것을 여갈사하두다라 칭하였고 야곱은 그것을 갈르엣이라 칭하였으니 ");
INSERT INTO kor_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","라반의 말에 `오늘날 이 무더기가 너와 나 사이에 증거가 된다' 하였으므로 그 이름을 갈르엣이라 칭하였으며 ");
INSERT INTO kor_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","또 미스바라 하였으니 이는 그의 말에 `우리 피차 떠나 있을 때에 여호와께서 너와 나 사이에 감찰하옵소서' 함이라 ");
INSERT INTO kor_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","`네가 내 딸을 박대하거나 내 딸들 외에 다른 아내들을 취하면 사람은 우리와 함께 할 자가 없어도 보라, 하나님이 너와 나 사이에 증거하시느니라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","라반이 또 야곱에게 이르되 `내가 너와 나 사이에 둔 이 무더기를 보라 또 이 기둥을 보라 ");
INSERT INTO kor_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","이 무더기가 증거가 되고 이 기둥이 증거가 되나니 내가 이 무더기를 넘어 네게로 가서 해하지 않을 것이요, 네가 이 무더기, 이 기둥을 넘어 내게로 와서 해하지 않을 것이라 ");
INSERT INTO kor_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","아브라함의 하나님, 나홀의 하나님, 그들의 조상의 하나님은 우리 사이에 판단하옵소서' 하매 야곱이 그 아비 이삭의 경외하는 이를 가리켜 맹세하고 ");
INSERT INTO kor_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","야곱이 또 산에서 제사를 드리고 형제들을 불러 떡을 먹이니 그들이 떡을 먹고 산에서 경야하고 ");
INSERT INTO kor_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","라반이 아침에 일찌기 일어나 손자들과 딸들에게 입맞추며 그들에게 축복하고 떠나 고향으로 돌아갔더라 ");
INSERT INTO kor_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","야곱이 그 길을 진행하더니 하나님의 사자들이 그를 만난지라 ");
INSERT INTO kor_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","야곱이 그들을 볼 때에 이르기를 `이는 하나님의 군대라' 하고 그 땅 이름을 마하나임이라 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","야곱이 세일 땅 에돔 들에 있는 형 에서에게로 사자들을 자기보다 앞서 보내며 ");
INSERT INTO kor_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","그들에게 부탁하여 가로되 `너희는 이같이 내 주 에서에게 고하라 주의 종 야곱이 말하기를 내가 라반에게 붙여서 지금까지 있었사오며 ");
INSERT INTO kor_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","내게 소와, 나귀와, 양떼와, 노비가 있사오므로 사람을 보내어 내 주께 고하고 내 주께 은혜 받기를 원하나이다 하더라 하라' 하였더니 ");
INSERT INTO kor_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","사자들이 야곱에게 돌아와 가로되 `우리가 주인의 형 에서에게 이른즉 그가 사백인을 거느리고 주인을 만나려고 오더이다' ");
INSERT INTO kor_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","야곱이 심히 두렵고 답답하여 자기와 함께 한 종자와 양과, 소와, 약대를 두 떼로 나누고 ");
INSERT INTO kor_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","가로되 `에서가 와서 한 떼를 치면, 남은 한 떼는 피하리라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","야곱이 또 가로되 `나의 조부 아브라함의 하나님, 나의 아버지 이삭의 하나님, 여호와여 ! 주께서 전에 내게 명하시기를 네 고향 네 족속에게로 돌아가라 내가 네게 은혜를 베풀리라 하셨나이다 ");
INSERT INTO kor_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","나는 주께서 주의 종에게 베푸신 모든 은총과 모든 진리를 조금이라도 감당할 수 없사오나 내가 내 지팡이만 가지고 이 요단을 건넜더니 지금은 두 떼나 이루었나이다 ");
INSERT INTO kor_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","내가 주께 간구하오니 내 형의 손에서 에서의 손에서 나를 건져내시옵소서 내가 그를 두려워하옴은 그가 와서 나와 내 처자들을 칠까 겁냄이니이다 ");
INSERT INTO kor_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","주께서 말씀하시기를 내가 정녕 네게 은혜를 베풀어 네 씨로 바다의 셀 수 없는 모래와 같이 많게 하리라 하셨나이다' ");
INSERT INTO kor_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","야곱이 거기서 경야하고 그 소유 중에서 형 에서를 위하여 예물을 택하니 ");
INSERT INTO kor_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","암염소가 이백이요, 수염소가 이십이요, 암양이 이백이요, 수양이 이십이요, ");
INSERT INTO kor_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","젖나는 약대 삼십과 그 새끼요, 암소가 사십이요, 황소가 열이요, 암나귀가 이십이요, 그 새끼나귀가 열이라, ");
INSERT INTO kor_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","그것을 각각 떼로 나눠 종들의 손에 맡기고 그 종들에게 이르되 나보다 앞서 건너가서 각 떼로 상거가 뜨게 하라 하고 ");
INSERT INTO kor_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","그가 또 앞선 자에게 부탁하여 가로되 `내 형 에서가 너를 만나 묻기를 네가 뉘 사람이며 어디로 가느냐 ? 네 앞엣 것은 뉘 것이냐 ? 하거든 ");
INSERT INTO kor_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","대답하기를 주의 종 야곱의 것이요, 자기 주 에서에게로 보내는 예물이오며 야곱도 우리 뒤에 있나이다 하라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","그 둘째와 세째와 각 떼를 따라가는 자에게 부탁하여 가로되 `너희도 에서를 만나거든 곧 이같이 그에게 고하고 ");
INSERT INTO kor_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","또 너희는 말하기를 주의 종 야곱이 우리 뒤에 있다 하라' 하니 이는 야곱의 생각에 `내가 내 앞에 보내는 예물로 형의 감정을 푼 후에 대면하면 형이 혹시 나를 받으리라' 함이었더라 ");
INSERT INTO kor_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","그 예물은 그의 앞서 행하고 그는 무리 가운데서 경야하다가 ");
INSERT INTO kor_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","밤에 일어나 두 아내와 두 여종과 열 한 아들을 인도하여 얍복 나루를 건널새 ");
INSERT INTO kor_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","그들을 인도하여 시내를 건네며 그 소유도 건네고 ");
INSERT INTO kor_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","야곱은 홀로 남았더니 어떤 사람이 날이 새도록 야곱과 씨름하다가 ");
INSERT INTO kor_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","그 사람이 자기가 야곱을 이기지 못함을 보고 야곱의 환도뼈를 치매 야곱의 환도뼈가 그 사람과 씨름할 때에 위골되었더라 ");
INSERT INTO kor_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","그 사람이 가로되 `날이 새려 하니 나로 가게 하라' 야곱이 가로되 `당신이 내게 축복하지 아니하면 가게 하지 아니하겠나이다 !' ");
INSERT INTO kor_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","그 사람이 그에게 이르되 `네 이름이 무엇이냐 ?' 그가 가로되 `야곱이니이다' ");
INSERT INTO kor_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","그 사람이 가로되 `네 이름을 다시는 야곱이라 부를 것이 아니요 이스라엘이라 부를 것이니 이는 네가 하나님과 사람으로 더불어 겨루어 이기었음이니라' ");
INSERT INTO kor_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","야곱이 청하여 가로되 `당신의 이름을 고하소서' 그 사람이 가로되 `어찌 내 이름을 묻느냐 ?' 하고 거기서 야곱에게 축복한지라 ");
INSERT INTO kor_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","그러므로 야곱이 그곳 이름을 브니엘이라 하였으니 그가 이르기를 내가 하나님과 대면하여 보았으나 내 생명이 보전되었다' 함이더라 ");
INSERT INTO kor_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","그가 브니엘을 지날 때에 해가 돋았고 그 환도뼈로 인하여 절었더라 ");
INSERT INTO kor_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","그 사람이 야곱의 환도뼈 큰 힘줄을 친고로 이스라엘 사람들이 지금까지 환도뼈 큰 힘줄을 먹지 아니하더라 ");
INSERT INTO kor_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","야곱이 눈을 들어 보니 에서가 사백인을 거느리고 오는지라 그 자식들을 나누어 레아와 라헬과 두 여종에게 맡기고 ");
INSERT INTO kor_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","여종과 그 자식들은 앞에 두고 레아와 그 자식들은 다음에 두고 라헬과 요셉은 뒤에 두고 ");
INSERT INTO kor_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","자기는 그들 앞에서 나아가되 몸을 일곱번 땅에 굽히며 그 형 에서에게 가까이 하니 ");
INSERT INTO kor_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","에서가 달려와서 그를 맞아서 안고 목을 어긋맞기고 그와 입맞추고 피차 우니라 ");
INSERT INTO kor_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","에서가 눈을 들어 여인과 자식들을 보고 묻되 `너와 함께한 이들은 누구냐 ?' 야곱이 가로되 `하나님이 주의 종에게 은혜로 주신 자식이니이다' ");
INSERT INTO kor_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","때에 여종들이 그 자식으로 더불어 나아와 절하고 ");
INSERT INTO kor_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","레아도 그 자식으로 더불어 나아와 절하고 그 후에 요셉이 라헬로 더불어 나아와 절하니 ");
INSERT INTO kor_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","에서가 또 가로되 `나의 만난 바 이 모든 떼는 무슨 까닭이냐 ?' 야곱이 가로되 `내 주께 은혜를 입으려 함이니이다' ");
INSERT INTO kor_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","에서가 가로되 `내 동생아, 내게 있는 것이 족하니 네 소유는 네게 두라' ");
INSERT INTO kor_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","야곱이 가로되 `그렇지 아니하니이다 형님께 은혜를 얻었사오면 청컨대 내 손에서 이 예물을 받으소서 내가 형님의 얼굴을 뵈온즉 하나님의 얼굴을 본 것 같사오며 형님도 나를 기뻐하심이니이이다 ");
INSERT INTO kor_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","하나님이 내게 은혜를 베푸셨고 나의 소유도 족하오니 청컨대 내가 형님께 드리는 예물을 받으소서' 하고 그에게 강권하매 받으니라 ");
INSERT INTO kor_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","에서가 가로되 `우리가 떠나가자 내가 너의 앞잡이가 되리라' ");
INSERT INTO kor_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","야곱이 그에게 이르되 `내 주도 아시거니와 자식들은 유약하고 내게 있는 양떼와 소가 새끼를 데렸은즉 하루만 과히 몰면 모든 떼가 죽으리니 ");
INSERT INTO kor_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","청컨대 내 주는 종보다 앞서 가소서 나는 앞에 가는 짐승과 자식의 행보대로 천천히 인도하여 세일로 가서 내 주께 나아가리이다' ");
INSERT INTO kor_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","에서가 가로되 `내가 내 종자 수인을 네게 머물리라' 야곱이 가로되 `어찌하여 그리하리이까 ? 나로 내 주께 은혜를 얻게 하소서' 하매 ");
INSERT INTO kor_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","이 날에 에서는 세일로 회정하고 ");
INSERT INTO kor_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","야곱은 숙곳에 이르러 자기를 위하여 집을 짓고 짐승을 위하여 우릿간을 지은고로 그 땅 이름을 숙곳이라 부르더라 ");
INSERT INTO kor_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","야곱이 밧단아람에서부터 평안히 가나안 땅 세겜 성에 이르러 성 앞에 그 장막을 치고 ");
INSERT INTO kor_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","그 장막 친 밭을 세겜의 아비 하몰의 아들들의 손에서 은 일백개로 사고 ");
INSERT INTO kor_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","레아가 야곱에게 낳은 딸 디나가 그 땅 여자를 보러 나갔더니 ");
INSERT INTO kor_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","히위 족속 중 하몰의 아들 그 땅 추장 세겜이 그를 보고 끌어들여 강간하여 욕되게 하고 ");
INSERT INTO kor_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","그 마음이 깊이 야곱의 딸 디나에게 연련하며 그 소녀를 사랑하여 그의 마음을 말로 위로하고 ");
INSERT INTO kor_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","그 아비 하몰에게 청하여 가로되 `이 소녀를 내 아내로 얻게 하여 주소서' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","야곱이 그 딸 디나를 그가 더럽혔다 함을 들었으나 자기 아들들이 들에서 목축하므로 그들의 돌아오기까지 잠잠하였고 ");
INSERT INTO kor_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","세겜의 아비 하몰은 야곱에게 말하러 왔으며 ");
INSERT INTO kor_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","야곱의 아들들은 들에서 이를 듣고 돌아와서 사람 사람이 근심하고 심히 노하였으니 이는 세겜이 야곱의 딸을 강간하여 이스라엘에게 부끄러운 일 곧 행치 못할 일을 행하였음이더라 ");
INSERT INTO kor_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","하몰이 그들에게 이르되 `내 아들 세겜이 마음으로 너희 딸을 연련하여 하니 원컨대 그를 세겜에게 주어 아내를 삼게 하라 ");
INSERT INTO kor_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","너희가 우리와 통혼하여 너희 딸을 우리에게 주며 우리 딸을 너희가 취하고 ");
INSERT INTO kor_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","너희가 우리와 함께 거하되 땅이 너희 앞에 있으니 여기 머물러 매매하며 여기서 기업을 얻으라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","세겜도 디나의 아비와 남형들에게 이르되 `나로 너희에게 은혜를 입게 하라 너희가 내게 청구하는 것은 내가 수응하리니 ");
INSERT INTO kor_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","이 소녀만 내게 주어 아내가 되게 하라 아무리 큰 빙물과 예물을 청구할지라도 너희가 내게 말한대로 수응하리라' ");
INSERT INTO kor_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","야곱의 아들들이 세겜과 그 아비 하몰에게 속여 대답하였으니 이는 세겜이 그 누이 디나를 더럽혔음이라 ");
INSERT INTO kor_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","야곱의 아들들이 그들에게 말하되 `우리는 그리하지 못하겠노라 할례 받지 아니한 사람에게 우리 누이를 줄 수 없노니 이는 우리의 수욕이 됨이니라 ");
INSERT INTO kor_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","그런즉 이같이 하면 너희에게 허락하리라 만일 너희 중 남자가 다 할례를 받고 우리 같이 되면 ");
INSERT INTO kor_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","우리 딸을 너희에게 주며 너희 딸을 우리가 취하며 너희가 함께 거하여 한 민족이 되려니와 ");
INSERT INTO kor_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","너희가 만일 우리를 듣지 아니하고 할례를 받지 아니하면 우리는 곧 우리 딸을 데리고 가리라' ");
INSERT INTO kor_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","그들의 말을 하몰과 그 아들 세겜이 좋게 여기므로 ");
INSERT INTO kor_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","이 소년이 그 일 행하기를 지체치 아니하였으니 그가 야곱의 딸을 사랑함이며 그는 그 아비 집에 가장 존귀함일러라 ");
INSERT INTO kor_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","하몰과 그 아들 세겜이 성문에 이르러 그 고을 사람에게 말하여 가로되 ");
INSERT INTO kor_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","`이 사람들은 우리와 친목하고 이 땅은 넓어 그들을 용납할 만하니 그들로 여기서 거주하며 매매하게 하고 우리가 그들의 딸들을 아내로 취하고 우리 딸들도 그들에게 주자 ");
INSERT INTO kor_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","그러나 우리 중에 모든 남자가 그들의 할례를 받음 같이 할례를 받아야 그 사람들이 우리와 함께 거하여 한 민족 되기를 허락할 것이라 ");
INSERT INTO kor_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","그리하면 그들의 생축과 재산과 그 모든 짐승이 우리의 소유가 되지 않겠느냐 ? 다만 그 말대로 하자 그리하면 그들이 우리와 함께 거하리라' ");
INSERT INTO kor_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","성문으로 출입하는 모든 자가 하몰과 그 아들 세겜의 말을 듣고 성문으로 출입하는 그 모든 남자가 할례를 받으니라 ");
INSERT INTO kor_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","제 삼일에 미쳐 그들이 고통할 때에 야곱의 두 아들 디나의 오라비 시므온과 레위가 각기 칼을 가지고 가서 부지중에 성을 엄습하여 그 모든 남자를 죽이고 ");
INSERT INTO kor_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","칼로 하몰과 그 아들 세겜을 죽이고 디나를 세겜의 집에서 데려오고 ");
INSERT INTO kor_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","야곱의 여러 아들이 그 시체있는 성으로 가서 노략하였으니 이는 그들이 그 누이를 더럽힌 연고라 ");
INSERT INTO kor_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","그들이 양과, 소와, 나귀와, 그 성에 있는 것과, 들에 있는 것과, ");
INSERT INTO kor_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","그 모든 재물을 빼앗으며 그 자녀와 아내들을 사로잡고 집 속의 물건을 다 노략한지라 ");
INSERT INTO kor_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","야곱이 시므온과 레위에게 이르되 너희가 내게 화를 끼쳐 나로 이 땅 사람 곧 가나안 족속과 브리스 족속에게 냄새를 내게 하였도다 나는 수가 적은즉 그들이 모여 나를 치고 나를 죽이리니 그리하면 나와 내 집이 멸망하리라 ");
INSERT INTO kor_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","그들이 가로되 `그가 우리 누이를 창녀같이 대우함이 가하니이까 ");
INSERT INTO kor_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","하나님이 야곱에게 이르시되 일어나 벧엘로 올라가서 거기 거하며 네가 네 형 에서의 낯을 피하여 도망하던 때에 네게 나타났던 하나님께 거기서 단을 쌓으라 ! 하신지라 ");
INSERT INTO kor_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","야곱이 이에 자기 집 사람과 자기와 함께 한 모든 자에게 이르되 `너희 중의 이방 신상을 버리고 자신을 정결케 하고 의복을 바꾸라 ");
INSERT INTO kor_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","우리가 일어나 벧엘로 올라가자 나의 환난날에 내게 응답하시며 나의 가는 길에서 나와 함께 하신 하나님께 내가 거기서 단을 쌓으려 하노라' 하매 ");
INSERT INTO kor_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","그들이 자기 손에 있는 모든 이방 신상과 자기 귀에 있는 고리를 야곱에게 주는지라 야곱이 그것들을 세겜 근처 상수리나무 아래 묻고 ");
INSERT INTO kor_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","그들이 발행하였으나 하나님이 그 사면 고을들로 크게 두려워하게 하신 고로 야곱의 아들들을 추격하는 자가 없었더라 ");
INSERT INTO kor_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","야곱과 그와 함께한 모든 사람이 가나안 땅 루스 곧 벧엘에 이르고 ");
INSERT INTO kor_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","그가 거기서 단을 쌓고 그곳을 엘벧엘이라 불렀으니 이는 그 형의 낯을 피할 때에 하나님이 그에게 거기서 나타나셨음이더라 ");
INSERT INTO kor_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","리브가의 유모 드보라가 죽으매 그를 벧엘 아래 상수리나무 밑에 장사하고 그 나무 이름을 알론바굿이라 불렀더라 ");
INSERT INTO kor_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","야곱이 밧단아람에서 돌아오매 하나님이 다시 야곱에게 나타나서 그에게 복을 주시고 ");
INSERT INTO kor_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","그에게 이르시되 네 이름이 야곱이다마는 네 이름을 다시는 야곱이라 부르지 않겠고 이스라엘이 네 이름이 되리라 하시고 그가 그의 이름을 이스라엘이라 부르시고 ");
INSERT INTO kor_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","그에게 이르시되 나는 전능한 하나님이니라 ! 생육하며 번성하라 ! 국민과 많은 국민이 네게서 나고 왕들이 네 허리에서 나오리라 ");
INSERT INTO kor_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","내가 아브라함과 이삭에게 준 땅을 네게 주고 내가 네 후손에게도 그 땅을 주리라 ! 하시고 ");
INSERT INTO kor_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","하나님이 그와 말씀하시던 곳에서 그를 떠나 올라가시는지라 ");
INSERT INTO kor_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","야곱이 하나님의 자기와 말씀하시던 곳에 기둥 곧 돌 기둥을 세우고 그 위에 전제물을 붓고 또 그 위에 기름을 붓고 ");
INSERT INTO kor_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","하나님이 자기와 말씀하시던 곳의 이름을 벧엘이라 불렀더라 ");
INSERT INTO kor_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","그들이 벧엘에서 발행하여 에브랏에 이르기까지 얼마 길을 격한 곳에서 라헬이 임산하여 심히 신고하더니 ");
INSERT INTO kor_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","그가 난산할 즈음에 산파가 그에게 이르되 `두려워말라 지금 그대가 또 득남하느니라' 하매 ");
INSERT INTO kor_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","그가 죽기에 임하여 그 혼이 떠나려할 때에 아들의 이름은 베노니라 불렀으나 그 아비가 그를 베냐민이라 불렀더라 ");
INSERT INTO kor_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","라헬이 죽으매 에브랏 곧 베들레헴 길에 장사되었고 ");
INSERT INTO kor_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","야곱이 라헬의 묘에 비를 세웠더니 지금까지 라헬의 묘비라 일컫더라 ");
INSERT INTO kor_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","이스라엘이 다시 발행하여 에델 망대를 지나 장막을 쳤더라 ");
INSERT INTO kor_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","이스라엘이 그 땅에 유할 때에 르우벤이 가서 그 서모 빌하와 통간하매 이스라엘이 이를 들었더라 야곱의 아들은 열 둘이라 ");
INSERT INTO kor_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","레아의 소생은 야곱의 장자 르우벤과, 그 다음 시므온과, 레위와, 유다와, 잇사갈과, 스불론이요, ");
INSERT INTO kor_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","라헬의 소생은 요셉과, 베냐민이며, ");
INSERT INTO kor_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","라헬의 여종 빌하의 소생은 단과, 납달리요, ");
INSERT INTO kor_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","레아의 여종 실바의 소생은 갓과, 아셀이니, 이들은 야곱의 아들들이요 밧단아람에서 그에게 낳은 자더라 ");
INSERT INTO kor_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","야곱이 기럇아르바의 마므레로 가서 그 아비 이삭에게 이르렀으니 기럇아르바는 곧 아브라함과 이삭의 우거하던 헤브론이더라 ");
INSERT INTO kor_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","이삭의 나이 일백 팔십세라 ");
INSERT INTO kor_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","이삭이 나이 많고 늙어 기운이 진하매 죽어 자기 열조에게로 돌아가니 그 아들 에서와 야곱이 그를 장사하였더라 ");
INSERT INTO kor_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","에서 곧 에돔의 대략이 이러하니라 ");
INSERT INTO kor_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","에서가 가나안 여인 중 헷 족속 중 엘론의 딸 아다와, 히위 족속중 시브온의 딸 아나의 소생 오홀리바마를 자기 아내로 취하고 ");
INSERT INTO kor_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","또 이스마엘의 딸 느바욧의 누이 바스맛을 취하였더니 ");
INSERT INTO kor_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","아다는 엘리바스를 에서에게 낳았고, 바스맛은 르우엘을 낳았고 ");
INSERT INTO kor_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","오홀리바마는 여우스와, 얄람과, 고라를 낳았으니 이들은 에서의 아들이요 가나안 땅에서 그에게 낳은 자더라 ");
INSERT INTO kor_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","에서가 자기 아내들과, 자기 자녀들과, 자기 집의 모든 사람과, 자기의 가축과, 자기 모든 짐승과, 자기가 가나안 땅에서 얻은 모든 재물을 이끌고 그 동생 야곱을 떠나 타처로 갔으니 ");
INSERT INTO kor_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","두 사람의 소유가 풍부하여 함께 거할 수 없음이러라 그들의 우거한 땅이 그들의 가축으로 인하여 그들을 용납할 수 없었더라 ");
INSERT INTO kor_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","이에 에서 곧 에돔이 세일산에 거하니라 ");
INSERT INTO kor_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","세일산에 거한 에돔 족속의 조상 에서의 대략이 이러하고 ");
INSERT INTO kor_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","그 자손의 이름은 이러하니라 에서의 아내 아다의 아들은 엘리바스요, 에서의 아내 바스맛의 아들은 르우엘이며 ");
INSERT INTO kor_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","엘리바스의 아들들은 데만과, 오말과, 스보와, 가담과, 그나스요, ");
INSERT INTO kor_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","에서의 아들 엘리바스의 첩 딤나는 아말렉을 엘리바스에게 낳았으니 이들은 에서의 아내 아다의 자손이며 ");
INSERT INTO kor_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","르우엘의 아들들은 나핫과, 세라와, 삼마와, 미사니 이들은 에서의 아내 바스맛의 자손이며 ");
INSERT INTO kor_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","시브온의 손녀 아나의 딸 에서의 아내 오홀리바마의 아들들은 이러하니 그가 여우스와, 얄람과, 고라를 에서에게 낳았더라 ");
INSERT INTO kor_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","에서 자손 중 족장은 이러하니라 에서의 장자 엘리바스의 자손에는 데만 족장, 오말 족장, 스보 족장, 그나스 족장과 ");
INSERT INTO kor_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","고라 족장, 가담 족장, 아말렉 족장이니 이들은 에돔 땅에 있는 엘리바스로 말미암아 나온 족장들이요 이들은 아다의 자손이며 ");
INSERT INTO kor_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","에서의 아들 르우엘의 자손에는 나핫 족장, 세라 족장, 삼마 족장, 미사 족장이니 이들은 에돔 땅에 있는 르우엘로 말미암아 나온 족장들이요 이들은 에서의 아내 바스맛의 자손이며 ");
INSERT INTO kor_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","에서의 아내 오홀리바마의 아들들은 여우스 족장, 얄람 족장, 고라 족장이니 이들은 아나의 딸이요 에서의 아내인 오홀리바마로 말미암아 나온 족장들이라 ");
INSERT INTO kor_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","에서 곧 에돔의 자손으로서 족장 된 자들이 이러하였더라 ");
INSERT INTO kor_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","그 땅의 원거인 호리 족속 세일의 자손은 로단과, 소발과, 시브온과, 아나와, ");
INSERT INTO kor_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","디손과, 에셀과, 디산이니 이들은 에돔 땅에 있는 세일의 자손중 호리 족속으로 말미암아 나온 족장들이요 ");
INSERT INTO kor_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","로단의 자녀는 호리와, 헤맘과, 로단의 누이 딤나요 ");
INSERT INTO kor_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","소발의 자녀는 알완과, 마나핫과, 에발과, 스보와, 오남이요 ");
INSERT INTO kor_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","시브온의 자녀는 아야와, 아나며 이 아나는 그 아비 시브온의 나귀를 칠 때에 광야에서 온천을 발견하였고 ");
INSERT INTO kor_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","아나의 자녀는 디손과, 오홀리바마니 오홀리바마는 아나의 딸이며 ");
INSERT INTO kor_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","디손의 자녀는 헴단과, 에스반과, 이드란과, 그란이요 ");
INSERT INTO kor_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","에셀의 자녀는 빌한과, 사아완과, 아간이요 ");
INSERT INTO kor_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","디산의 자녀는 우스와, 아란이니 ");
INSERT INTO kor_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","호리 족속의 족장들은 곧 로단 족장, 소발 족장, 시브온 족장, 아나 족장 ");
INSERT INTO kor_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","디손 족장, 에셀 족장, 디산 족장이라 이들은 그 구역을 따라 세일 땅에 있는 호리 족속으로 말미암아 나온 족장들이었더라 ");
INSERT INTO kor_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","이스라엘 자손을 다스리는 왕이 있기 전에 에돔 땅을 다스리는 왕이 이러하니라 ");
INSERT INTO kor_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","브올의 아들 벨라가 에돔의 왕이 되었으니 그 도성의 이름은 딘하바며 ");
INSERT INTO kor_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","벨라가 죽고 보스라 사람 세라의 아들 요밥이 그를 대신하여 왕이 되고 ");
INSERT INTO kor_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","요밥이 죽고 데만 족속의 땅의 후삼이 그를 대신하여 왕이 되고 ");
INSERT INTO kor_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","후삼이 죽고 브닷의 아들 곧 모압 들에서 미디안 족속을 친 하닷이 그를 대신하여 왕이 되니 그 도성 이름은 아윗이며 ");
INSERT INTO kor_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","하닷이 죽고 마스레가의 삼라가 그를 대신하여 왕이 되고 ");
INSERT INTO kor_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","삼라가 죽고 유브라데 하숫가 르호봇의 사울이 그를 대신하여 왕이 되고 ");
INSERT INTO kor_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","사울이 죽고 악볼의 아들 바알하난이 그를 대신하여 왕이 되고 ");
INSERT INTO kor_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","악볼의 아들 바알하난이 죽고 하달이 그를 대신하여 왕이 되니 그 도성 이름은 바우며 그 처의 이름은 므헤다벨이니 마드렛의 딸이요 메사합의 손녀더라 ");
INSERT INTO kor_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","에서에게서 나온 족장들의 이름은 그 종족과 거처와 이름대로 이러하니 딤나 족장, 알와 족장, 여뎃 족장 ");
INSERT INTO kor_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","오홀리바마 족장, 엘라 족장, 비논 족장 ");
INSERT INTO kor_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","그나스 족장, 데만 족장, 밉살 족장 ");
INSERT INTO kor_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","막디엘 족장, 이람 족장이라 이들은 그 구역과 거처를 따른 에돔 족장들이며 에돔 족속의 조상은 에서더라 ");
INSERT INTO kor_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","야곱이 가나안 땅 곧 그 아비의 우거하던 땅에 거하였으니 ");
INSERT INTO kor_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","야곱의 약전이 이러하니라 요셉이 십 칠세의 소년으로서 그 형제와 함께 양을 칠 때에 그 아비의 첩 빌하와 실바의 아들들로 더불어 함께 하였더니 그가 그들의 과실을 아비에게 고하더라 ");
INSERT INTO kor_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","요셉은 노년에 얻은 아들이므로 이스라엘이 여러 아들보다 그를 깊이 사랑하여 위하여 채색옷을 지었더니 ");
INSERT INTO kor_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","그 형들이 아비가 형제들보다 그를 사랑함을 보고 그를 미워하여 그에게 언사가 불평하였더라 ");
INSERT INTO kor_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","요셉이 꿈을 꾸고 자기 형들에게 고하매 그들이 그를 더욱 미워하였더라 ");
INSERT INTO kor_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","요셉이 그들에게 이르되 `청컨대 나의 꾼 꿈을 들으시오 ");
INSERT INTO kor_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","우리가 밭에서 곡식을 묶더니 내 단은 일어서고 당신들의 단은 내 단을 둘러서서 절하더이다' ");
INSERT INTO kor_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","그 형들이 그에게 이르되 `네가 참으로 우리의 왕이 되겠느냐 ? 참으로 우리를 다스리게 되겠느냐 ?' 하고 그 꿈과 그 말을 인하여 그를 더욱 미워하더니 ");
INSERT INTO kor_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","요셉이 다시 꿈을 꾸고 그 형들에게 고하여 가로되 `내가 또 꿈을 꾼즉 해와 달과 열한 별이 내게 절하더이다' 하니라 ");
INSERT INTO kor_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","그가 그 꿈으로 부형에게 고하매 아비가 그를 꾸짖고 그에게 이르되 `너의 꾼 꿈이 무엇이냐 나와 네 모와 네 형제들이 참으로 가서 땅에 엎드려 네게 절하겠느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","그 형들은 시기하되 그 아비는 그 말을 마음에 두었더라 ");
INSERT INTO kor_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","그 형들이 세겜에 가서 아비의 양떼를 칠 때에 ");
INSERT INTO kor_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","이스라엘이 요셉에게 이르되 `네 형들이 세겜에서 양을 치지 아니하느냐 ? 너를 그들에게로 보내리라' 요셉이 아비에게 대답하되 `내가 그리하겠나이다' ");
INSERT INTO kor_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","이스라엘이 그에게 이르되 `가서 네 형들과 양떼가 다 잘 있는 여부를 보고 돌아와 내게 고하라' 하고 그를 헤브론 골짜기에서 보내매 이에 세겜으로 가니라 ");
INSERT INTO kor_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","어떤 사람이 그를 만난즉 그가 들에서 방황하는지라 그 사람이 그에게 물어 가로되 `네가 무엇을 찾느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","그가 가로되 `내가 나의 형들을 찾으오니 청컨대 그들의 양치는 곳을 내게 가르치소서' ");
INSERT INTO kor_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","그 사람이 가로되 `그들이 여기서 떠났느니라 내가 그들의 말을 들으니 도단으로 가자 하더라' 요셉이 그 형들의 뒤를 따라 가서 도단에서 그들을 만나니라 ");
INSERT INTO kor_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","요셉이 그들에게 가까이 오기 전에 그들이 요셉을 멀리서 보고 죽이기를 꾀하여 ");
INSERT INTO kor_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","서로 이르되 `꿈 꾸는 자가 오는도다 ");
INSERT INTO kor_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","자, 그를 죽여 한 구덩이에 던지고 우리가 말하기를 악한 짐승이 그를 잡아먹었다 하자 그 꿈이 어떻게 되는 것을 우리가 볼 것이니라' 하는지라 ");
INSERT INTO kor_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","르우벤이 듣고 요셉을 그들의 손에서 구원하려 하여 가로되 `우리가 그 생명은 상하지 말자' ");
INSERT INTO kor_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","르우벤이 또 그들에게 이르되 `피를 흘리지 말라 그를 광야 그 구덩이에 던지고 손을 그에게 대지 말라' 하니 이는 그가 요셉을 그들의 손에서 구원하여 그 아비에게로 돌리려 함이었더라 ");
INSERT INTO kor_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","요셉이 형들에게 이르매 그 형들이 요셉의 옷 곧 그 입은 채색옷을 벗기고 ");
INSERT INTO kor_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","그를 잡아 구덩이에 던지니 그 구덩이는 빈 것이라 그 속에 물이 없었더라 ");
INSERT INTO kor_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","그들이 앉아 음식을 먹다가 눈을 들어 본즉 한떼 이스마엘 족속이 길르앗에서 오는데 그 약대들에 향품과, 유향과, 몰약을 싣고 애굽으로 내려가는지라 ");
INSERT INTO kor_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","유다가 자기 형제에게 이르되 `우리가 우리 동생을 죽이고 그의 피를 은익한들 무엇이 유익할까 ? ");
INSERT INTO kor_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","자, 그를 이스마엘 사람에게 팔고 우리 손을 그에게 대지 말자 그는 우리의 동생이요 우리의 골육이니라' 하매 형제들이 청종하였더라 ");
INSERT INTO kor_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","때에 미디안 사람 상고들이 지나는지라 그들이 요셉을 구덩이에서 끌어 올리고 은 이십개에 그를 이스마엘 사람들에게 팔매 그 상고들이 요셉을 데리고 애굽으로 갔더라 ");
INSERT INTO kor_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","르우벤이 돌아와서 구덩이에 이르러 본즉 거기 요셉이 없는지라 옷을 찢고 ");
INSERT INTO kor_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","아우들에게로 와서 가로되 `아이가 없도다 나는 나는 어디로 갈까 ?' ");
INSERT INTO kor_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","그들이 요셉의 옷을 취하고 수염소를 죽여 그 옷을 피에 적시고 ");
INSERT INTO kor_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","그 채색옷을 보내어 그 아비에게로 가져다가 이르기를 `우리가 이것을 얻었으니 아버지의 아들의 옷인가 아닌가 보소서' 하매 ");
INSERT INTO kor_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","아비가 그것을 알아보고 가로되 `내 아들의 옷이라 악한 짐승이 그를 먹었도다 요셉이 정녕 찢겼도다' 하고 ");
INSERT INTO kor_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","자기 옷을 찢고 굵은 베로 허리를 묶고 오래도록 그 아들을 위하여 애통하니 ");
INSERT INTO kor_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","그 모든 자녀가 위로하되 그가 그 위로를 받지 아니하여 가로되 `내가 슬퍼하며 음부에 내려 아들에게로 가리라' 하고 그 아비가 그를 위하여 울었더라 ");
INSERT INTO kor_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","미디안 사람이 애굽에서 바로의 신하 시위대장 보디발에게 요셉을 팔았더라 ");
INSERT INTO kor_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","그 후에 유다가 자기 형제에게서 내려가서 아둘람 사람 히라에게로 나아가니라 ");
INSERT INTO kor_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","유다가 거기서 가나안 사람 수아라 하는 자의 딸을 보고 그를 취하여 동침하니 ");
INSERT INTO kor_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","그가 잉태하여 아들을 낳으매 유다가 그 이름을 엘이라 하니라 ");
INSERT INTO kor_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","그가 다시 잉태하여 아들을 낳고 그 이름을 오난이라 하고 ");
INSERT INTO kor_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","그가 또 다시 아들을 낳고 그 이름을 셀라라 하니라 그가 셀라를 낳을 때에 유다는 거십에 있었더라 ");
INSERT INTO kor_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","유다가 장자 엘을 위하여 아내를 취하니 그 이름은 다말이더라 ");
INSERT INTO kor_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","유다의 장자 엘이 여호와 목전에 악하므로 여호와께서 그를 죽이신지라 ");
INSERT INTO kor_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","유다가 오난에게 이르되 `네 형수에게로 들어가서 남편의 아우의 본분을 행하여 네 형을 취하여 씨가 있게 하라' ");
INSERT INTO kor_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","오난이 그 씨가 자기 것이 되지 않을 줄 알므로 형수에게 들어갔을 때에 형에게 아들을 얻게 아니하려고 땅에 설정하매 ");
INSERT INTO kor_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","그 일이 여호와 목전에 악하므로 여호와께서 그도 죽이시니 ");
INSERT INTO kor_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","유다가 그 며느리 다말에게 이르되 `수절하고 네 아비 집에 있어서 내 아들 셀라가 장성하기를 기다리라' 하니 셀라도 그 형들 같이 죽을까 염려함이라 다말이 가서 그 아비 집에 있으니라 ");
INSERT INTO kor_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","얼마 후에 유다의 아내 수아의 딸이 죽은지라 유다가 위로를 받은 후에 그 친구 아둘람 사람 히라와 함께 딤나로 올라가서 자기 양털 깍는 자에게 이르렀더니 ");
INSERT INTO kor_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","혹이 다말에게 고하되 `네 시부가 자기 양털을 깎으려고 딤나에 올라왔다' 한지라 ");
INSERT INTO kor_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","그가 그 과부의 의복을 벗고 면박으로 얼굴을 가리고 몸을 휩싸고 딤나 길 곁 에나임 문에 앉으니 이는 셀라가 장성함을 보았어도 자기를 그의 아내로 주지 않음을 인함이라 ");
INSERT INTO kor_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","그가 얼굴을 가리웠으므로 유다가 그를 보고 창녀로 여겨 ");
INSERT INTO kor_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","길곁으로 그에게 나아가 가로되 `청컨대 나로 네게 들어가게 하라' 하니 그 자부인줄 알지 못하였음이라 그가 가로되 `당신이 무엇을 주고 내게 들어 오려느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","유다가 가로되 내가 내 떼에서 염소 새끼를 주리라 그가 가로되 당신이 그것을 줄 때까지 약조물을 주겠느냐 ? ");
INSERT INTO kor_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","유다가 가로되 `무슨 약조물을 네게 주랴 ?' 그가 가로되 `당신의 도장과 그 끈과 당신의 손에 있는 지팡이로 하라' 유다가 그것들을 그에게 주고 그에게로 들어갔더니 그가 유다로 말미암아 잉태하였더라 ");
INSERT INTO kor_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","그가 일어나 떠나가서 그 면박을 벗고 과부의 의복을 도로 입으니라 ");
INSERT INTO kor_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","유다가 그 친구 아둘람 사람의 손에 부탁하여 염소 새끼를 보내고 그 여인의 손에서 약조물을 찾으려 하였으나 그가 그 여인을 찾지 못한지라 ");
INSERT INTO kor_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","그가 그 곳 사람에게 물어 가로되 `길 곁 에나임에 있던 창녀가 어디 있느냐 ?` 그들이 가로되 `여기는 창녀가 없느니라' ");
INSERT INTO kor_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","그가 유다에게로 돌아와 가로되 `내가 그를 찾지 못하고 그 곳 사람도 이르기를 여기는 창녀가 없다 하더라` ");
INSERT INTO kor_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","유다가 가로되 `그로 그것을 가지게 두라 우리가 부끄러움을 당할까 하노라 내가 이 염소 새끼를 보내었으나 그대가 그를 찾지 못하였느니라' ");
INSERT INTO kor_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","석달쯤 후에 혹이 유다에게 고하여 가로되 `네 며느리 다말이 행음하였고 그 행음함을 인하여 잉태하였느니라' 유다가 가로되 `그를 끌어 내어 불사르라' ");
INSERT INTO kor_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","여인이 끌려 나갈 때에 보내어 시부에게 이르되 `이 물건 임자로 말미암아 잉태하였나이다 청컨대 보소서, 이 도장과 그 끈과 지팡이가 뉘 것이니이까 ?' 한지라 ");
INSERT INTO kor_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","유다가 그것들을 알아보고 가로되 `그는 나보다 옳도다 내가 그를 내 아들 셀라에게 주지 아니하였음이로다' 하고 다시는 그를 가까이 하지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","임산하여 보니 쌍태라 ");
INSERT INTO kor_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","해산할 때에 손이 나오는지라 산파가 가로되 `이는 먼저 나온자라' 하고 홍사를 가져 그 손에 매었더니 ");
INSERT INTO kor_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","그 손을 도로 들이며 그 형제가 나오는지라 산파가 가로되 `네가 어찌하여 터치고 나오느냐 ?' 한고로 그 이름을 베레스라 불렀고 ");
INSERT INTO kor_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","그 형제 곧 손에 홍사 있는 자가 뒤에 나오니 그 이름을 세라라 불렀더라 ");
INSERT INTO kor_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","요셉이 이끌려 애굽에 내려가매 바로의 신하 시위대장 애굽사람 보디발이 그를 그리로 데려간 이스마엘 사람의 손에서 그를 사니라 ");
INSERT INTO kor_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","여호와께서 요셉과 함께 하시므로 그가 형통한 자가 되어 그 주인 애굽 사람의 집에 있으니 ");
INSERT INTO kor_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","그 주인이 여호와께서 그와 함께하심을 보며 또 여호와께서 그의 범사에 형통케 하심을 보았더라 ");
INSERT INTO kor_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","요셉이 그 주인에게 은혜를 입어 섬기매 그가 요셉으로 가정 총무를 삼고 자기 소유를 다 그 손에 위임하니 ");
INSERT INTO kor_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","그가 요셉에게 자기 집과 그 모든 소유물을 주관하게 한 때부터 여호와께서 요셉을 위하여 그 애굽 사람의 집에 복을 내리시므로 여호와의 복이 그의 집과 밭에 있는 모든 소유에 미친지라 ");
INSERT INTO kor_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","주인이 그 소유를 다 요셉의 손에 위임하고 자기 식료 외에는 간섭하지 아니하였더라 요셉은 용모가 준수하고 아담하였더라 ");
INSERT INTO kor_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","그 후에 그 주인의 처가 요셉에게 눈짓하다가 동침하기를 청하니 ");
INSERT INTO kor_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","요셉이 거절하며 자기 주인의 처에게 이르되 `나의 주인이 가중 제반 소유를 간섭지 아니하고 다 내 손에 위임하였으니 ");
INSERT INTO kor_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","이 집에는 나보다 큰 이가 없으며 주인이 아무 것도 내게 금하지 아니하였어도 금한 것은 당신뿐이니 당신은 자기 아내임이라 그런즉 내가 어찌 이 큰 악을 행하여 하나님께 득죄하리이까 ?' ");
INSERT INTO kor_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","여인이 날마다 요셉에게 청하였으나 요셉이 듣지 아니하여 동침하지 아니할 뿐더러 함께 있지도 아니하니라 ");
INSERT INTO kor_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","그러할 때에 요셉이 시무하러 그 집에 들어갔더니 그 집 사람은 하나도 거기 없었더라 ");
INSERT INTO kor_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","그 여인이 그 옷을 잡고 가로되 `나와 동침하자' 요셉이 자기 옷을 그 손에 버리고 도망하여 나가매 ");
INSERT INTO kor_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","그가 요셉이 그 옷을 자기 손에 버려두고 도망하여 나감을 보고 ");
INSERT INTO kor_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","집 사람들을 불러서 그들에게 이르되 `보라, 주인이 히브리 사람을 우리에게 데려다가 우리를 희롱하게 하도다 그가 나를 겁간코자 내게로 들어오기로 내가 크게 소리 질렀더니 ");
INSERT INTO kor_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","그가 나의 소리질러 부름을 듣고 그 옷을 내게 버려두고 도망하여 나갔느니라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","그 옷을 곁에 두고 자기 주인이 집으로 돌아오기를 기다려 ");
INSERT INTO kor_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","이 말로 그에게 고하여 가로되 `당신이 우리에게 데려온 히브리 종이 나를 희롱코자 내게로 들어 왔기로 ");
INSERT INTO kor_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","내가 소리질러 불렀더니 그가 그 옷을 내게 버려두고 도망하여 나갔나이다' ");
INSERT INTO kor_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","주인이 그 아내가 자기에게 고하기를 `당신의 종이 내게 이같이 행하였다' 하는 말을 듣고 심히 노한지라 ");
INSERT INTO kor_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","이에 요셉의 주인이 그를 잡아 옥에 넣으니 그 옥은 왕의 죄수를 가두는 곳이었더라 요셉이 옥에 갇혔으나 ");
INSERT INTO kor_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","여호와께서 요셉과 함께 하시고 그에게 인자를 더하사 전옥에게 은혜를 받게 하시매 ");
INSERT INTO kor_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","전옥이 옥중 죄수를 다 요셉의 손에 맡기므로 그 제반 사무를 요셉이 처리하고 ");
INSERT INTO kor_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","전옥은 그의 손에 맡긴 것을 무엇이든지 돌아보지 아니하였으니 이는 여호와께서 요셉과 함께 하심이라 여호와께서 그의 범사에 형통케 하셨더라 ");
INSERT INTO kor_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","그 후에 애굽 왕의 술 맡은 자와 떡굽는 자가 그 주 애굽 왕에게 범죄한지라 ");
INSERT INTO kor_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","바로가 그 두 관원장 곧 술 맡은 관원장과 떡 굽는 관원장에게 노하여 ");
INSERT INTO kor_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","그들을 시위대장의 집 안에 있는 옥에 가두니 곧 요셉의 갇힌 곳이라 ");
INSERT INTO kor_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","시위대장이 요셉으로 그들에게 수종하게 하매 요셉이 그들을 섬겼더라 그들이 갇힌지 수일이라 ");
INSERT INTO kor_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","옥에 갇힌 애굽 왕의 술 맡은 자와 떡 굽는 자 두 사람이 하룻밤에 꿈을 꾸니 각기 몽조가 다르더라 ");
INSERT INTO kor_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","아침에 요셉이 들어가 보니 그들에게 근심 빛이 있는지라 ");
INSERT INTO kor_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","요셉이 그 주인의 집에 자기와 함께 갇힌 바로의 관원장에게 묻되 당신들이 오늘 어찌하여 근심 빛이 있나이까 ? ");
INSERT INTO kor_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","그들이 그에게 이르되 `우리가 꿈을 꾸었으나 이를 해석할 자가 없도다' 요셉이 그들에게 이르되 `해석은 하나님께 있지 아니하나이까 ? 청컨대 내게 고하소서' ");
INSERT INTO kor_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","술 맡은 관원장이 그 꿈을 요셉에게 말하여 가로되 `내가 꿈에 보니 내 앞에 포도나무가 있는데 ");
INSERT INTO kor_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","그 나무에 세 가지가 있고 싹이 나서 꽃이 피고 포도송이가 익었고 ");
INSERT INTO kor_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","내 손에 바로의 잔이 있기로 내가 포도를 따서 그 즙을 바로의 잔에 짜서 그 잔을 바로의 손에 드렸노라' ");
INSERT INTO kor_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","요셉이 그에게 이르되 `그 해석이 이러하니 세 가지는 사흘이라 ");
INSERT INTO kor_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","지금부터 사흘 안에 바로가 당신의 머리를 들고 당신의 전직을 회복하리니 당신이 이왕에 술 맡은 자가 되었을 때에 하던것 같이 바로의 잔을 그 손에 받들게 되리이다 ");
INSERT INTO kor_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","당신이 득의하거든 나를 생각하고 내게 은혜를 베풀어서 내 사정을 바로에게 고하여 이 집에서 나를 건져내소서 ");
INSERT INTO kor_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","나는 히브리 땅에서 끌려온 자요 여기서도 옥에 갇힐 일은 행치 아니하였나이다' ");
INSERT INTO kor_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","떡 굽는 관원장이 그 해석이 길함을 보고 요셉에게 이르되 `나도 꿈에 보니 흰 떡 세 광주리가 내 머리에 있고 ");
INSERT INTO kor_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","그 윗광주리에 바로를 위하여 만든 각종 구운 식물이 있는데 새들이 내 머리의 광주리에서 그것을 먹더라' ");
INSERT INTO kor_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","요셉이 대답하여 가로되 `그 해석은 이러하니 세 광주리는 사흘이라 ");
INSERT INTO kor_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","지금부터 사흘 안에 바로가 당신의 머리를 끊고 당신을 나무에 달리니 새들이 당신의 고기를 뜯어 먹으리이다' 하더니 ");
INSERT INTO kor_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","제 삼일은 바로의 탄일이라 바로가 모든 신하를 위하여 잔치할때에 술 맡은 관원장과 떡 굽는 관원장으로 머리를 그 신하 중에 들게 하니라 ");
INSERT INTO kor_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","바로의 술 맡은 관원장은 전직을 회복하매 그가 잔을 바로의 손에 받들어 드렸고 ");
INSERT INTO kor_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","떡 굽는 관원장은 매여 달리니 요셉이 그들에게 해석함과 같이 되었으나 ");
INSERT INTO kor_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","술 맡은 관원장이 요셉을 기억지 않고 잊었더라 ");
INSERT INTO kor_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","만 이년 후에 바로가 꿈을 꾼즉 자기가 하숫가에 섰는데 ");
INSERT INTO kor_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","보니 아름답고 살진 일곱 암소가 하수에서 올라와 갈밭에서 뜯어먹고 ");
INSERT INTO kor_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","그 뒤에 또 흉악하고 파리한 다른 일곱 암소가 하수에서 올라와 그 소와 함께 하숫가에 섰더니 ");
INSERT INTO kor_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","그 흉악하고 파리한 소가 그 아름답고 살진 일곱 소를 먹은지라 바로가 곧 깨었다가 ");
INSERT INTO kor_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","다시 잠이 들어 꿈을 꾸니 한 줄기에 무성하고 충실한 일곱 이삭이 나오고 ");
INSERT INTO kor_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","그 후에 또 세약하고 동풍에 마른 일곱 이삭이 나오더니 ");
INSERT INTO kor_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","그 세약한 일곱 이삭이 무성하고 충실한 일곱 이삭을 삼킨지라 바로가 깬즉 꿈이라 ");
INSERT INTO kor_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","아침에 그 마음이 번민하여 보내어 애굽의 술객과 박사를 모두 불러 그들에게 그 꿈을 고하였으나 그것을 바로에게 해석하는 자가 없었더라 ");
INSERT INTO kor_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","술 맡은 관원장이 바로에게 고하여 가로되 `내가 오늘날 나의 허물을 추억하나이다 ");
INSERT INTO kor_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","바로께서 종들에게 노하사 나와 떡 굽는 관원장을 시위대장의 집에 가두셨을 때에 ");
INSERT INTO kor_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","나와 그가 하룻밤에 꿈을 꾼즉 각기 징조가 있는 꿈이라 ");
INSERT INTO kor_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","그 곳에 시위대장의 종된 히브리 소년이 우리와 함께 있기로 우리가 그에게 고하매 그가 우리의 꿈을 풀되 그 꿈대로 각인에게 해석하더니 ");
INSERT INTO kor_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","그 해석 한대로 되어 나는 복직하고 그는 매여 달렸나이다' ");
INSERT INTO kor_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","이에 바로가 보내어 요셉을 부르매 그들이 급히 그를 옥에서 낸지라 요셉이 곧 수염을 깎고 그 옷을 갈아 입고 바로에게 들어오니 ");
INSERT INTO kor_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","바로가 요셉에게 이르되 `내가 한 꿈을 꾸었으나 그것을 해석하는 자가 없더니 들은즉 너는 꿈을 들으면 능히 푼다더라` ");
INSERT INTO kor_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","요셉이 바로에게 대답하여 가로되 `이는 내게 있는 것이 아니라 하나님이 바로에게 평안한 대답을 하시리이다' ");
INSERT INTO kor_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","바로가 요셉에게 이르되 `내가 꿈에 하숫가에 서서 ");
INSERT INTO kor_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","보니 살지고 아름다운 일곱 암소가 하숫가에 올라와 갈밭에서 뜯어 먹고 ");
INSERT INTO kor_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","그 뒤에 또 약하고 심히 흉악하고 파리한 일곱 암소가 올라오니 그같이 흉악한 것들은 애굽 땅에서 내가 아직 보지 못한 것이라 ");
INSERT INTO kor_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","그 파리하고 흉악한 소가 처음의 일곱 살진 소를 먹었으며 ");
INSERT INTO kor_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","먹었으나 먹은듯하지 아니하여 여전히 흉악하더라 내가 곧 깨었다가 ");
INSERT INTO kor_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","다시 꿈에 보니 한 줄기에 무성하고 충실한 일곱 이삭이 나오고 ");
INSERT INTO kor_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","그 후에 또 세약하고 동풍에 마른 일곱 이삭이 나더니 ");
INSERT INTO kor_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","그 세약한 이삭이 좋은 일곱 이삭을 삼키더라 내가 그 꿈을 술객에게 말하였으나 그것을 내게 보이는 자가 없느니라' ");
INSERT INTO kor_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","요셉이 바로에게 고하되 `바로의 꿈은 하나이라 하나님이 그 하실 일을 바로에게 보이심이니이다 ");
INSERT INTO kor_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","일곱 좋은 암소는 일곱해요, 일곱 좋은 이삭도 일곱해니, 그 꿈은 하나이라 ");
INSERT INTO kor_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","그 후에 올라온 파리하고 흉악한 일곱 소는 칠년이요, 동풍에 말라 속이 빈 일곱 이삭도 일곱해 흉년이니 ");
INSERT INTO kor_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","내가 바로에게 고하기를 하나님이 그 하실 일로 바로에게 보이신다 함이 이것이라 ");
INSERT INTO kor_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","온 애굽 땅에 일곱해 큰 풍년이 있겠고 ");
INSERT INTO kor_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","후에 일곱해 흉년이 들므로 애굽 땅에 있던 풍년을 다 잊어버리게 되고 이 땅이 기근으로 멸망되리니 ");
INSERT INTO kor_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","후에 든 그 흉년이 너무 심하므로 이전 풍년을 이 땅에서 기억하지 못하게 되리이다 ");
INSERT INTO kor_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","바로께서 꿈을 두번 겹쳐 꾸신 것은 하나님이 이 일을 정하셨음이라 속히 행하시리니 ");
INSERT INTO kor_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","이제 바로께서는 명철하고 지혜있는 사람을 택하여 애굽 땅을 치리하게 하시고 ");
INSERT INTO kor_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","바로께서는 또 이같이 행하사 국중에 여러 관리를 두어 그 일곱해 풍년에 애굽 땅의 오분의 일을 거두되 ");
INSERT INTO kor_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","그 관리로 장차 올 풍년의 모든 곡물을 거두고 그 곡물을 바로의 손에 돌려 양식을 위하여 각 성에 적치하게 하소서 ");
INSERT INTO kor_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","이와 같이 그 곡물을 이 땅에 저장하여 애굽 땅에 임할 일곱해 흉년을 예비하시면 땅이 이 흉년을 인하여 멸망치 아니하리이다' ");
INSERT INTO kor_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","바로와 그 모든 신하가 이 일을 좋게 여긴지라 ");
INSERT INTO kor_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","바로가 그 신하들에게 이르되 `이와 같이 하나님의 신이 감동한 사람을 우리가 어찌 얻을 수 있으리요' 하고 ");
INSERT INTO kor_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","요셉에게 이르되 `하나님이 이 모든 것을 네게 보이셨으니 너와 같이 명철하고 지혜있는 자가 없도다 ");
INSERT INTO kor_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","너는 내 집을 치리하라 내 백성이 다 네 명을 복종하리니 나는 너보다 높음이 보좌 뿐이니라' ");
INSERT INTO kor_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","바로가 또 요셉에게 이르되 `내가 너로 애굽 온 땅을 총리하게 하노라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","자기의 인장 반지를 빼어 요셉의 손에 끼우고 그에게 세마포 옷을 입히고 금사슬을 목에 걸고 ");
INSERT INTO kor_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","자기에게 있는 버금 수레에 그를 태우매 무리가 그 앞에서 소리 지르기를 `엎드리라' 하더라 바로가 그로 애굽 전국을 총리하게 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","바로가 요셉에게 이르되 `나는 바로라 애굽 온 땅에서 네 허락없이는 수족을 놀릴 자가 없으리라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","그가 요셉의 이름을 사브낫바네아라 하고 또 온 제사장 보디베라의 딸 아스낫을 그에게 주어 아내를 삼게 하니라 요셉이 나가 애굽 온 땅을 순찰하니라 ");
INSERT INTO kor_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","요셉이 애굽 왕 바로 앞에 설 때에 삼십세라 그가 바로 앞을 떠나 애굽 온 땅을 순찰하니 ");
INSERT INTO kor_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","일곱해 풍년에 토지 소출이 심히 많은지라 ");
INSERT INTO kor_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","요셉이 애굽 땅에 있는 그 칠년 곡물을 거두어 각 성에 저축하되 각 성주위의 밭의 곡물을 그 성중에 저장하매 ");
INSERT INTO kor_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","저장한 곡식이 바다 모래같이 심히 많아 세기를 그쳤으니 그 수가 한이 없음이었더라 ");
INSERT INTO kor_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","흉년이 들기 전에 요셉에게 두 아들을 낳되 곧 온 제사장 보디베라의 딸 아스낫이 그에게 낳은지라 ");
INSERT INTO kor_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","요셉이 그 장자의 이름을 므낫세라 하였으니 `하나님이 나로 나의 모든 고난과 나의 아비의 온 집 일을 잊어버리게 하셨다' 함이요 ");
INSERT INTO kor_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","차자의 이름을 에브라임이라 하였으니 `하나님이 나로 나의 수고한 땅에서 창성하게 하셨다' 함이었더라 ");
INSERT INTO kor_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","애굽 땅에 일곱해 풍년이 그치고 ");
INSERT INTO kor_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","요셉의 말과 같이 일곱해 흉년이 들기 시작하매 각국에는 기근이 있으나 애굽 온 땅에는 식물이 있더니 ");
INSERT INTO kor_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","애굽 온 땅이 주리매 백성이 바로에게 부르짖어 양식을 구하는지라 바로가 애굽 모든 백성에게 이르되 `요셉에게 가서 그가 너희에게 이르는 대로 하라' 하니라 ");
INSERT INTO kor_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","온 지면에 기근이 있으매 요셉이 모든 창고를 열고 애굽 백성에게 팔새 애굽 땅에 기근이 심하며 ");
INSERT INTO kor_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","각국 백성도 양식을 사려고 애굽으로 들어와 요셉에게 이르렀으니 기근이 온 세상에 심함이었더라 ");
INSERT INTO kor_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","때에 야곱이 애굽에 곡식이 있음을 보고 아들들에게 이르되 `너희는 어찌하여 서로 관망만 하느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","야곱이 또 이르되 `내가 들은즉 저 애굽에 곡식이 있다 하니 너희는 그리로 가서 거기서 우리를 위하여 사오라 그리하면 우리가 살고 죽지 아니하리라 !' 하매 ");
INSERT INTO kor_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","요셉의 형 십인이 애굽에서 곡식을 사려고 내려 갔으나 ");
INSERT INTO kor_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","야곱이 요셉의 아우 베냐민을 그 형들과 함께 보내지 아니하였으니 이는 그의 말이 `재난이 그에게 미칠까 두렵다' 함이었더라 ");
INSERT INTO kor_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","이스라엘의 아들들이 양식 사러간 자 중에 있으니 가나안 땅에 기근이 있음이라 ");
INSERT INTO kor_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","때에 요셉이 나라의 총리로서 그 땅 모든 백성에게 팔더니 요셉의 형들이 와서 그 앞에서 땅에 엎드려 절하매 ");
INSERT INTO kor_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","요셉이 보고 형들인 줄 아나 모르는 체 하고 엄한 소리로 그들에 말하여 가로되 `너희가 어디서 왔느냐 ?' 그들이 가로되 `곡물을 사려고 가나안에서 왔나이다' ");
INSERT INTO kor_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","요셉은 그 형들을 아나 그들은 요셉을 알지 못하더라 ");
INSERT INTO kor_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","요셉이 그들에게 대하여 꾼 꿈을 생각하고 그들에게 이르되 `너희는 정탐들이라 이 나라의 틈을 엿보려고 왔느니라' ");
INSERT INTO kor_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","그들이 그에게 이르되 `내 주여, 아니니이다 종들은 곡물을 사러 왔나이다 ");
INSERT INTO kor_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","우리는 다 한 사람의 아들로서 독실한 자니 종들은 정탐이 아니니이다' ");
INSERT INTO kor_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","요셉이 그들에게 이르되 `아니라 너희가 이 나라의 틈을 엿보러 왔느니라' ");
INSERT INTO kor_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","그들이 가로되 `주의 종 우리들은 십 이형제로서 가나안 땅 한 사람의 아들들이라 말째 아들은 오늘 아버지와 함께 있고 또 하나는 없어졌나이다' ");
INSERT INTO kor_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","요셉이 그들에게 이르되 `내가 너희에게 이르기를 너희는 정탐들이라 한 말이 이것이니라 ");
INSERT INTO kor_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","너희는 이같이 하여 너희 진실함을 증명할 것이라 바로의 생명으로 맹세하노니 너희 말째 아우가 여기 오지 아니하면 너희가 여기서 나가지 못하리라 ");
INSERT INTO kor_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","너희 중 하나를 보내어 너희 아우를 데려오게 하고 너희는 갇히어 있으라 내가 너희의 말을 시험하여 너희 중에 진실이 있는지 보리라 바로의 생명으로 맹세하노니 그리하지 아니하면 너희는 과연 정탐이니라' 하고 ");
INSERT INTO kor_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","그들을 다 함께 삼일을 가두었더라 ");
INSERT INTO kor_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","삼일만에 요셉이 그들에게 이르되 `나는 하나님을 경외하노니 너희는 이같이 하여 생명을 보전하라 ");
INSERT INTO kor_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","너희가 독실한 자이면 너희 형제 중 한 사람만 그 옥에 갇히게 하고 너희는 곡식을 가지고 가서 너희 집들의 주림을 구하고 ");
INSERT INTO kor_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","너희 말째 아우를 내게로 데리고 오라 그리하면 너희 말이 진실함이 되고 너희가 죽지 아니하리라' 그들이 그대로 하니라 ");
INSERT INTO kor_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","그들이 서로 말하되 `우리가 아우의 일로 인하여 범죄하였도다 그가 우리에게 애걸할때에 그 마음의 괴로움을 보고도 듣지 아니하였으므로 이 괴로움이 우리에게 임하도다' ");
INSERT INTO kor_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","르우벤이 그들에게 대답하여 가로되 `내가 너희더러 그 아이에게 득죄하지 말라고 하지 아니하였느냐 ? 그래도 너희가 듣지 아니하였느니라 그러므로 그의 피 값을 내게 되었도다' 하니 ");
INSERT INTO kor_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","피차간에 통변을 세웠으므로 그들은 요셉이 그 말을 알아 들은 줄을 알지 못하였더라 ");
INSERT INTO kor_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","요셉이 그들을 떠나 가서 울고 다시 돌아와서 그들과 말하다가 그들 중에서 시므온을 취하여 그들의 목전에서 결박하고 ");
INSERT INTO kor_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","명하여 곡물을 그 그릇에 채우게 하고 각인의 돈은 그 자루에 도로 넣게 하고 또 길 양식을 그들에게 주게 하니 그대로 행하였더라 ");
INSERT INTO kor_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","그들이 곡식을 나귀에 싣고 그 곳을 떠났더니 ");
INSERT INTO kor_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","한 사람이 객점에서 나귀에게 먹이를 주려고 자루를 풀고 본즉 그 돈이 자루 아구에 있는지라 ");
INSERT INTO kor_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","그가 그 형제에게 고하되 `내 돈을 도로 넣었도다 보라, 자루 속에 있도다' 이에 그들이 혼이 나서 떨며 서로 돌아보며 말하되 `하나님이 어찌하여 우리에게 이 일을 행하셨는고' 하고 ");
INSERT INTO kor_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","그들이 가나안 땅에 돌아와 그 아비 야곱에게 이르러 그 만난 일을 자세히 고하여 가로되 ");
INSERT INTO kor_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","`그 땅의 주, 그 사람이 엄히 우리에게 말씀하고 우리를 그 나라 정탐자로 여기기로 ");
INSERT INTO kor_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","우리가 그에게 이르되 우리는 독실한 자요 정탐이 아니니이다 ");
INSERT INTO kor_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","우리는 한 아비의 아들 십 이 형제로서 하나는 없어지고 말째는 오늘 우리 아버지와 함께 가나안 땅에 있나이다 하였더니 ");
INSERT INTO kor_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","그 땅의 주 그 사람이 우리에게 이르되 내가 이같이 하여 너희가 독실한 자임을 알리니 너희 형제 중 하나를 내게 두고 양식을 가지고 가서 너희 집들의 주림을 구하고 ");
INSERT INTO kor_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","너희 말째 아우를 내게로 데려오라 그리하면 너희가 정탐이 아니요 독실한 자임을 내가 알고 너희 형제를 너희에게 돌리리니 너희가 이 나라에서 무역하리라 하더이다' 하고 ");
INSERT INTO kor_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","각기 자루를 쏟고 본즉 각인의 돈뭉치가 그 자루 속에 있는지라 그들과 그 아비가 돈 뭉치를 보고 다 두려워하더니 ");
INSERT INTO kor_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","그 아비 야곱이 그들에게 이르되 `너희가 나로 나의 자식들을 잃게 하도다 요셉도 없어졌고 시므온도 없어졌거늘 베냐민을 또 빼앗아 가고자 하니 이는 다 나를 해롭게 함이로다' ");
INSERT INTO kor_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","르우벤이 아비에게 고하여 가로되 `내가 그를 아버지께로 데리고 오지 아니하거든 나의 두 아들을 죽이소서 그를 내 손에 맡기소서 내가 그를 아버지께로 데리고 돌아오리이다' ");
INSERT INTO kor_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","야곱이 가로되 `내 아들은 너희와 함께 내려가지 못하리니 그의 형은 죽고 그만 남았음이라 만일 너희 행하는 길에서 재난이 그 몸에 미치면 너희가 나의 흰 머리로 슬피 음부로 내려가게 함이 되리라' ");
INSERT INTO kor_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","그 땅에 기근이 심하고 ");
INSERT INTO kor_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","그들이 애굽에서 가져온 곡식을 다 먹으매 그 아비가 그들에게 이르되 `다시 가서 우리를 위하여 양식을 조금 사라' ");
INSERT INTO kor_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","유다가 아비에게 말하여 가로되 `그 사람이 엄히 우리에게 경계하여 가로되 너희 아우가 너희와 함께 하지 아니하면 너희가 내 얼굴을 보지 못하리라 하였으니 ");
INSERT INTO kor_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","아버지께서 우리 아우를 우리와 함께 보내시면 우리가 내려가서 아버지를 위하여 양식을 사려니와 ");
INSERT INTO kor_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","아버지께서 만일 그를 보내지 않으시면 우리는 내려가지 아니하리니 그 사람이 우리에게 말하기를 너희 아우가 너희와 함께하지 아니하면 너희가 내 얼굴을 보지 못하리라 하였음이니이다' ");
INSERT INTO kor_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","이스라엘이 가로되 `너희가 어찌하여 너희에게 오히려 아우가 있다고 그 사람에게 고하여 나를 해롭게 하였느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","그들이 가로되 `그 사람이 우리와 우리의 친족에 대하여 자세히 힐문하여 이르기를 너희 아버지가 그저 살았느냐 ? 너희에게 아우가 있느냐 ? 하기로 그 말을 조조이 그에게 대답한 것이라 그가 너희 아우를 데리고 내려오라 할 줄을 우리가 어찌 알았으리이까 ?' ");
INSERT INTO kor_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","유다가 아비 이스라엘에게 이르되 `저 아이를 나와 함께 보내시면 우리가 곧 가리니 그러면 우리와 아버지와 우리 어린 것들이 다 살고 죽지 아니하리이다 ");
INSERT INTO kor_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","내가 그의 몸을 담보하오리니 아버지께서 내 손에 그를 물으소서 내가 만일 그를 아버지께 데려다가 아버지 앞에 두지 아니하면 내가 영원히 죄를 지리이다 ");
INSERT INTO kor_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","우리가 지체하지 아니하였더면 벌써 두번 갔다 왔으리이다` ");
INSERT INTO kor_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","그들의 아비 이스라엘이 그들에게 이르되 `그러할진대 이렇게 하라 너희는 이 땅의 아름다운 소산을 그릇에 담아가지고 내려가서그 사람에게 예물을 삼을지니 곧 유향 조금과, 꿀 조금과, 향품과, 몰약과, 비자와, 파단행이니라 ");
INSERT INTO kor_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","너희 손에 돈을 배나 가지고 너희 자루 아구에 도로 넣여 온 그 돈을 다시 가지고 가라 혹 차착이 있었을까 두렵도다 ");
INSERT INTO kor_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","네 아우도 데리고 떠나 다시 그 사람에게로 가라 ");
INSERT INTO kor_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","전능하신 하나님께서 그 사람 앞에서 너희에게 은혜를 베푸사 그 사람으로 너희 다른 형제와 베냐민을 돌려보내게 하시기를 원하노라 내가 자식을 잃게 되면 잃으리로다 !' ");
INSERT INTO kor_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","그 사람들이 그 예물을 취하고 갑절 돈을 자기들의 손에 가지고 베냐민을 데리고 애굽에 내려가서 요셉의 앞에 서니라 ");
INSERT INTO kor_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","요셉이 베냐민이 그들과 함께 있음을 보고 청지기에게 이르되 `이 사람들을 집으로 인도해 들이고 짐승을 잡고 준비하라 이 사람들이 오정에 나와 함께 먹을 것이니라' ");
INSERT INTO kor_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","그 사람이 요셉의 명대로 하여 그 사람들을 요셉의 집으로 인도하니 ");
INSERT INTO kor_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","그 사람들이 요셉의 집으로 인도되매 두려워하여 이르되 `전일 우리 자루에 넣여 있던 돈의 일로 우리가 끌려드도다 이는 우리를 잡아 노예를 삼고 우리의 나귀를 빼앗으려 함이로다' 하고 ");
INSERT INTO kor_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","그들이 요셉의 청지기에게 가까이 나아가 그 집 문앞에서 그에게 고하여 ");
INSERT INTO kor_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","가로되 `내 주여, 우리가 전일에 내려와서 양식을 사가지고 ");
INSERT INTO kor_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","객점에 이르러 자루를 풀어본즉 각인의 돈이 본수대로 자루 아구에 있기로 우리가 도로 가져 왔고 ");
INSERT INTO kor_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","양식 살 다른 돈도 우리가 가지고 내려왔나이다 우리의 돈을 우리 자루에 넣은 자는 누구인지 우리가 알지 못하나이다' ");
INSERT INTO kor_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","그가 이르되 `너희는 안심하라 두려워 말라 ! 너희 하나님 너희 아버지의 하나님이 재물을 너희 자루에 넣어 너희에게 주신 것이니라 너희 돈은 내가 이미 받았느니라' 하고 시므온을 그들에게로 이끌어 내고 ");
INSERT INTO kor_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","그들을 요셉의 집으로 인도하고 물을 주어 발을 씻게 하며 그 나귀에게 먹이를 주더라 ");
INSERT INTO kor_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","그들이 여기서 먹겠다 함을 들으므로 예물을 정돈하고 요셉이 오정에 오기를 기다리더니 ");
INSERT INTO kor_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","요셉이 집으로 오매 그들이 그 집으로 들어가서 그 예물을 그에게 드리고 땅에 엎드리어 절하니 ");
INSERT INTO kor_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","요셉이 그들의 안부를 물으며 가로되 `너희 아버지 너희가 말하던 그 노인이 안녕하시냐 ? 지금까지 생존하셨느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","그들이 대답하되 `주의 종 우리 아비가 평안하고 지금까지 생존하였나이다' 하고 머리 숙여 절하더라 ");
INSERT INTO kor_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","요셉이 눈을 들어 자기 어머니의 아들 자기 동생 베냐민을 보고 가로되 너희가 내게 말하던 너희 작은 동생이 이냐 ? 그가 또 가로되 소자여 하나님이 네게 은혜 베푸시기를 원하노라 ");
INSERT INTO kor_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","요셉이 아우를 인하여 마음이 타는듯 하므로 급히 울곳을 찾아 안방으로 들어가서 울고 ");
INSERT INTO kor_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","얼굴을 씻고 나와서 그 정을 억제하고 `음식을 차리라' 하매 ");
INSERT INTO kor_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","그들이 요셉에게 따로 하고 그 형제들에게 따로 하고 배식하는 애굽 사람에게도 따로 하니 애굽 사람은 히브리 사람과 같이 먹으면 부정을 입음이었더라 ");
INSERT INTO kor_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","그들이 요셉의 앞에 앉되 그 장유의 차서대로 앉히운바 되니 그들이 서로 이상히 여겼더라 ");
INSERT INTO kor_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","요셉이 자기 식물로 그들에게 주되 베냐민에게는 다른 사람보다 오배나 주매 그들이 마시며 요셉과 함께 즐거워하였더라 ");
INSERT INTO kor_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","요셉이 그 청지기에 명하여 가로되 `양식을 각인의 자루에 실을 수 있을 만큼 채우고 각인의 돈을 그 자루에 넣고 ");
INSERT INTO kor_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","또 잔 내 곧 은잔을 그 소년의 자루 아구에 넣고 그 양식값 돈도 함께 넣으라' 하매 그가 요셉의 명령대로 하고 ");
INSERT INTO kor_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","개동시에 사람들과 그 나귀를 보내니라 ");
INSERT INTO kor_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","그들이 성에서 나가 멀리 가기 전에 요셉이 청지기에게 이르되 `일어나 그 사람들의 뒤를 따라 미칠 때에 그들에게 이르기를 너희가 어찌하여 악으로 선을 갚느냐 ? ");
INSERT INTO kor_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","이것은 내 주인이 가지고 마시며 늘 점치는데 쓰는것이 아니냐 ? 너희가 이같이 하니 악하도다 하라' ");
INSERT INTO kor_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","청지기가 그들에게 따라 미쳐 그대로 말하니 ");
INSERT INTO kor_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","그들이 그에게 대답하되 `우리 주여, 어찌 이렇게 말씀하시나이까 ? 이런 일은 종들이 결단코 아니하나이다 ");
INSERT INTO kor_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","우리 자루에 있던 돈도 우리가 가나안 땅에서부터 당신에게로 가져왔거늘 우리가 어찌 당신 주인의 집에서 은,금을 도적질 하리이까 ? ");
INSERT INTO kor_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","종들 중 뉘게서 발견되든지 그는 죽을 것이요 우리는 우리 주의 종이 되리이다' ");
INSERT INTO kor_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","그가 가로되 `그러면 너희 말과 같이 하리라 그것이 뉘게서든지 발견되면 그는 우리 종이 될 것이요 너희에게는 책망이 없으리라' ");
INSERT INTO kor_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","그들이 각각 급히 자루를 땅에 내려 놓고 각기 푸니 ");
INSERT INTO kor_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","그가 나이 많은 자에게서부터 시작하여 나이 적은 자에게까지 수탐하매 잔이 베냐민의 자루에서 발견된지라 ");
INSERT INTO kor_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","그들이 옷을 찢고 각기 짐을 나귀에 싣고 성으로 돌아오니라 ");
INSERT INTO kor_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","유다와 그 형제들이 요셉의 집에 이르니 요셉이 오히려 그 곳에 있는지라 그 앞 땅에 엎드리니 ");
INSERT INTO kor_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","요셉이 그들에게 이르되 `너희가 어찌하여 이런 일을 행하였느냐 ? 나 같은 사람이 점 잘 칠 줄을 너희가 알지 못하느냐 ?' ");
INSERT INTO kor_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","유다가 가로되 `우리가 내 주께 무슨 말을 하오리이까 ? 무슨 설명을 하오리이까 ? 어떻게 우리의 정직을 나타내리이까 ? 하나님이 종들의 죄악을 적발하셨으니 우리와 이 잔이 발견된 자가 다 내 주의 종이 되겠나이다' ");
INSERT INTO kor_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","요셉이 가로되 `내가 결코 그리하지 아니하리라 잔이 그 손에서 발견된 자만 나의 종이 되고 너희는 평안히 너희 아버지께로 도로 올라갈 것이니라' ");
INSERT INTO kor_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","유다가 그에게 가까이 가서 가로되 `내 주여, 청컨대 종으로 내 주의 귀에 한 말씀을 고하게 하소서 주의 종에게 노하지 마옵소서 주는 바로와 같으심이니이다 ");
INSERT INTO kor_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","이전에 내 주께서 종들에게 물으시되 너희는 아비가 있느냐 ? 아우가 있느냐 ? 하시기에 ");
INSERT INTO kor_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","우리가 내 주께 고하되 우리에게 아비가 있으니 노인이요 또 그 노년에 얻은 아들 소년이 있으니 그의 형은 죽고 그 어미의 끼친것은 그 뿐이므로 그 아비가 그를 사랑하나이다 하였더니 ");
INSERT INTO kor_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","주께서 또 종들에게 이르시되 그를 내게로 데리고 내려와서 나로 그를 목도하게 하라 하시기로 ");
INSERT INTO kor_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","우리가 내 주께 말씀하기를 그 아이는 아비를 떠나지 못할지니 떠나면 아비가 죽겠나이다 ");
INSERT INTO kor_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","주께서 또 주의 종들에게 말씀하시되 너희 말째 아우가 너희와 함께 내려오지 아니하면 너희가 다시 내 얼굴을 보지 못하리라 하시기로 ");
INSERT INTO kor_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","우리가 주의 종 우리 아비에게로 도로 올라가서 내 주의 말씀을 그에게 고하였나이다 ");
INSERT INTO kor_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","그 후에 우리 아비가 다시 가서 곡물을 조금 사오라 하시기로 ");
INSERT INTO kor_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","우리가 이르되 우리가 내려갈 수 없나이다 우리 말째 아우가 함께 하면 내려가려니와 말째 아우가 우리와 함께함이 아니면 그 사람의 얼굴을 볼 수 없음이니이다 ");
INSERT INTO kor_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","주의 종 우리 아비가 우리에게 이르되 너희도 알거니와 내 아내가 내게 두 아들을 낳았으나 ");
INSERT INTO kor_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","하나는 내게서 나간고로 내가 말하기를 정녕 찢겨 죽었다하고 내가 지금까지 그를 보지 못하거늘 ");
INSERT INTO kor_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","너희가 이도 내게서 취하여 가려한즉 만일 재해가 그 몸에 미치면 나의 흰 머리로 슬피 음부로 내려가게 하리라 하니 ");
INSERT INTO kor_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","아비의 생명과 아이의 생명이 서로 결탁되었거늘 이제 내가 주의 종 우리 아비에게 돌아갈 때에 아이가 우리와 함께 하지 아니하면 ");
INSERT INTO kor_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","아비가 아이의 없음을 보고 죽으리니 이같이 되면 종들이 주의 종 우리 아비의 흰 머리로 슬피 음부로 내려가게 함이니이다 ");
INSERT INTO kor_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","주의 종이 내 아비에게 아이를 담보하기를 내가 이를 아버지께로 데리고 돌아오지 아니하면 영영히 아버지께 죄를 지리이다 하였사오니 ");
INSERT INTO kor_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","청컨대 주의 종으로 아이를 대신하여 있어서 주의 종이 되게 하시고 아이는 형제와 함께 도로 올려 보내소서 ");
INSERT INTO kor_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","내가 어찌 아이와 함께 하지 아니하고 내 아비에게로 올라 갈 수 있으리이까 ? 두렵건대 재해가 내 아비에게 미침을 보리이다' ");
INSERT INTO kor_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","요셉이 시종하는 자들 앞에서 그 정을 억제하지 못하여 소리질러 모든 사람을 자기에게서 물러가라 하고 그 형제에게 자기를 알리니 때에 그와 함께 한 자가 없었더라 ");
INSERT INTO kor_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","요셉이 방성대곡하니 애굽 사람에게 들리며 바로의 궁중에 들리더라 ");
INSERT INTO kor_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","요셉이 그 형들에게 이르되 `나는 요셉이라 내 아버지께서 아직 살아 계시니이까 ?' 형들이 그 앞에서 놀라서 능히 대답하지 못하는지라 ");
INSERT INTO kor_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","요셉이 형들에게 이르되 `내게로 가까이 오소서` 그들이 가까이 가니 가로되 `나는 당신들의 아우 요셉이니 당신들이 애굽에 판 자라 ");
INSERT INTO kor_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","당신들이 나를 이곳에 팔았으므로 근심하지 마소서 한탄하지 마소서 ! 하나님이 생명을 구원하시려고 나를 당신들 앞서 보내셨나이다 ");
INSERT INTO kor_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","이 땅에 이년 동안 흉년이 들었으나 아직 오년은 기경도 못하고 추수도 못할지라 ");
INSERT INTO kor_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","하나님이 큰 구원으로 당신들의 생명을 보존하고 당신들의 후손을 세상에 두시려고 나를 당신들 앞서 보내셨나니 ");
INSERT INTO kor_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","그런즉 나를 이리로 보낸 자는 당신들이 아니요 하나님이시라 하나님이 나로 바로의 아비를 삼으시며 그 온 집의 주를 삼으시며 애굽 온 땅의 치리자를 삼으셨나이다 ");
INSERT INTO kor_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","당신들은 속히 아버지께로 올라가서 고하기를 아버지의 아들 요셉의 말에 하나님이 나를 애굽 전국의 주로 세우셨으니 내게로 지체말고 내려오사 ");
INSERT INTO kor_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","아버지의 아들들과 아버지의 손자들과 아버지의 양과 소와 모든 소유가 고센 땅에 있어서 나와 가깝게 하소서 ");
INSERT INTO kor_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","흉년이 아직 다섯해가 있으니 내가 거기서 아버지를 봉양하리이다 아버지와 아버지의 가속과 아버지의 모든 소속이 결핍할까 하나이다 하더라 하소서 ");
INSERT INTO kor_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","당신들의 눈과 내 아우 베냐민의 눈이 보는바 당신들에게 이 말을 하는 것은 내 입이라 ");
INSERT INTO kor_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","당신들은 나의 애굽에서의 영화와 당신들의 본 모든 것을 다 내 아버지께 고하고 속히 모시고 내려오소서' 하며 ");
INSERT INTO kor_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","자기 아우 베냐민의 목을 안고 우니 베냐민도 요셉의 목을 안고 우니라 ");
INSERT INTO kor_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","요셉이 또 형들과 입맞추며 안고 우니 형들이 그제야 요셉과 말하니라 ");
INSERT INTO kor_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","요셉의 형들이 왔다는 소문이 바로의 궁에 들리매 바로와 그 신복이 기뻐하고 ");
INSERT INTO kor_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","바로는 요셉에게 이르되 `네 형들에게 명하기를 너희는 이렇게 하여 너희 양식을 싣고 가서 가나안 땅에 이르거든 ");
INSERT INTO kor_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","너희 아비와 너희 가속을 이끌고 내게로 오라 내가 너희에게 애굽 땅 아름다운 것을 주리니 너희가 나라의 기름진 것을 먹으리라 ");
INSERT INTO kor_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","이제 명을 받았으니 이렇게 하라 너희는 애굽 땅에서 수레를 가져다가 너희 자녀와 아내를 태우고 너희 아비를 데려오라 ");
INSERT INTO kor_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","또 너희의 기구를 아끼지 말라 온 애굽 땅의 좋은 것이 너희 것임이니라 하라` ");
INSERT INTO kor_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","이스라엘의 아들들이 그대로 할새 요셉이 바로의 명대로 그들에게로 수레를 주고 길 양식을 주며 ");
INSERT INTO kor_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","또 그들에게 다 각기 옷 한벌씩 주되 베냐민에게는 은 삼백과 옷 다섯벌을 주고 ");
INSERT INTO kor_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","그가 또 이와 같이 그 아비에게 보내되 수나귀 열 필에 애굽의 아름다운 물품을 실리고 암나귀 열필에는 아비에게 길에서 공궤할 곡식과 떡과 양식을 실리고 ");
INSERT INTO kor_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","이에 형들을 돌려 보내며 그들에게 이르되 `당신들은 노중에서 다투지 말라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","그들이 애굽에서 올라와 가나안 땅으로 들어가서 아비 야곱에게 이르러 ");
INSERT INTO kor_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","고하여 가로되 `요셉이 지금까지 살아 있어 애굽 땅 총리가 되었더이다' 야곱이 그들을 믿지 아니하므로 기색하더니 ");
INSERT INTO kor_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","그들이 또 요셉이 자기들에게 부탁한 모든 말로 그 아비에게 고하매 그 아비 야곱이 요셉의 자기를 태우려고 보낸 수레를 보고야 기운이 소생한지라 ");
INSERT INTO kor_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","이스라엘이 가로되 `족하도다 내 아들 요셉이 지금까지 살았으니 내가 죽기 전에 가서 그를 보리라' ");
INSERT INTO kor_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","이스라엘이 모든 소유를 이끌고 발행하여 브엘세바에 이르러 그 아비 이삭의 하나님께 희생을 드리니 ");
INSERT INTO kor_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","밤에 하나님이 이상중에 이스라엘에게 나타나시고 불러 가라사대 야곱아 ! 야곱아 ! 하시는지라 야곱이 가로되 `내가 여기 있나이다` 하매 ");
INSERT INTO kor_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","하나님이 가라사대 나는 하나님이라 네 아비의 하나님이니 애굽으로 내려가기를 두려워 말라 내가 거기서 너로 큰 민족을 이루게 하리라 ");
INSERT INTO kor_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","내가 너와 함께 애굽으로 내려가겠고 정녕 너를 인도하여 다시 올라올 것이며 요셉이 그 손으로 네 눈을 감기리라 하셨더라 ");
INSERT INTO kor_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","야곱이 브엘세바에서 발행할새 이스라엘의 아들들이 바로의 태우려고 보낸 수레에 자기들의 아비 야곱과 자기들의 처자들을 태웠고 ");
INSERT INTO kor_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","그 생축과 가나안 땅에서 얻은 재물을 이끌었으며 야곱과 그 자손들이 다 함께 애굽으로 갔더라 ");
INSERT INTO kor_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","이와 같이 야곱이 그 아들들과 손자들과, 딸들과, 손녀들 곧 그 모든 자손을 데리고 애굽으로 갔더라 ");
INSERT INTO kor_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","애굽으로 내려간 이스라엘 가족의 이름이 이러하니 야곱과 그 아들들 곧 야곱의 맏아들 르우벤과 ");
INSERT INTO kor_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","르우벤의 아들 하녹과, 발루와, 헤스론과, 갈미요 ");
INSERT INTO kor_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","시므온의 아들 곧 여무엘과, 야민과, 오핫과, 야긴과, 스할과, 가나안 여인의 소생 사울이요 ");
INSERT INTO kor_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","레위의 아들 곧 게르손과, 그핫과, 므라리요 ");
INSERT INTO kor_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","유다의 아들 곧 엘과, 오난과, 셀라와, 베레스와, 세라니, 엘과 오난은 가나안 땅에서 죽었고 또 베레스의 아들 곧 헤스론과, 하물이요 ");
INSERT INTO kor_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","잇사갈의 아들 곧 돌라와, 부와와, 욥과, 시므론이요 ");
INSERT INTO kor_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","스불론의 아들 곧 세렛과, 엘론과, 얄르엘이니 ");
INSERT INTO kor_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","이들은 레아가 밧단아람에서 야곱에게 낳은 자손들이라 그 딸 디나를 합하여 남자와 여자가 삼십 삼명이며 ");
INSERT INTO kor_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","갓의 아들 곧 시뵨과, 학기와, 수니와, 에스본과, 에리와, 아로디와, 아렐리요 ");
INSERT INTO kor_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","아셀의 아들 곧 임나와, 이스와와, 이스위와, 브리아와 그들의 누이 세라며 또 브리아의 아들 곧 헤벨과, 말기엘이니 ");
INSERT INTO kor_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","이들은 라반이 그 딸 레아에게 준 실바가 야곱에게 낳은 자손들이라 합 십 륙명이요 ");
INSERT INTO kor_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","야곱의 아내 라헬의 아들 곧 요셉과, 베냐민이요 ");
INSERT INTO kor_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","애굽 땅에서 온 제사장 보디베라의 딸 아스낫이 요셉에게 낳은 므낫세와 에브라임이요 ");
INSERT INTO kor_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","베냐민의 아들 곧 벨라와, 베겔과, 아스벨과, 게라와, 나아만과, 에히와, 로스와, 뭅빔과, 훔빔과, 아릇이니 ");
INSERT INTO kor_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","이들은 라헬이 야곱에게 낳은 자손이라 합 십 사명이요 ");
INSERT INTO kor_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","단의 아들 후심이요 ");
INSERT INTO kor_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","납달리의 아들 곧 야스엘과, 구니와, 예셀과, 실렘이라 ");
INSERT INTO kor_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","이들은 라반이 그 딸 라헬에게 준 빌하가 야곱에게 낳은 자손이니 합이 칠명이라 ");
INSERT INTO kor_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","야곱과 함께 애굽에 이른 자는 야곱의 자부 외에 육십 륙명이니 이는 다 야곱의 몸에서 나온 자며 ");
INSERT INTO kor_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","애굽에서 요셉에게 낳은 아들이 두명이니 야곱의 집 사람으로 애굽에 이른 자의 도합이 칠십명이었더라 ");
INSERT INTO kor_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","야곱이 유다를 요셉에게 미리 보내어 자기를 고센으로 인도하게 하고 다 고센 땅에 이르니 ");
INSERT INTO kor_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","요셉이 수레를 갖추고 고센으로 올라가서 아비 이스라엘을 맞으며 그에게 보이고 그 목을 어긋맞겨 안고 얼마동안 울매 ");
INSERT INTO kor_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","이스라엘이 요셉에게 이르되 `네가 지금까지 살아 있고 내가 네 얼굴을 보았으니 지금 죽어도 가하도다' ");
INSERT INTO kor_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","요셉이 그 형들과 아비의 권속에게 이르되 내가 올라가서 바로에게 고하여 이르기를 `가나안 땅에 있던 내 형들과 내 아비의 권속이 내게로 왔는데 ");
INSERT INTO kor_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","그들은 목자라 목축으로 업을 삼으므로 그 양과 소와 모든 소유를 이끌고 왔나이다 하리니 ");
INSERT INTO kor_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","바로가 당신들을 불러서 너희의 업이 무엇이냐 ? 묻거든 ");
INSERT INTO kor_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","당신들은 고하기를 주의 종들은 어렸을 때부터 지금까지 목축하는 자이온데 우리와 우리 선조가 다 그러하니이다 하소서 애굽 사람은 다 목축을 가증히 여기나니 당신들이 고센 땅에 거하게 되리이다` ");
INSERT INTO kor_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","요셉이 바로에게 가서 고하여 가로되 `나의 아비와 형들과 그들의 양과 소와 모든 소유가 가나안 땅에서 와서 고센 땅에 있나이다' 하고 ");
INSERT INTO kor_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","형들 중 오인을 택하여 바로에게 보이니 ");
INSERT INTO kor_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","바로가 요셉의 형들에게 묻되 `너희 생업이 무엇이냐 ? 그들이 바로에게 대답하되 `종들은 목자이온데 우리와 선조가 다 그러하니이다' 하고 ");
INSERT INTO kor_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","그들이 또 바로에게 고하되 `가나안 땅에 기근이 심하여 종들의 떼를 칠 곳이 없기로 종들이 이곳에 우거하러 왔사오니 청컨대 종들로 고센 땅에 거하게 하소서' ");
INSERT INTO kor_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","바로가 요셉에게 일러 가로되 `네 아비와 형들이 네게 왔은즉 ");
INSERT INTO kor_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","애굽 땅이 네 앞에 있으니 땅의 좋은 곳에 네 아비와 형들로 거하게 하되 고센 땅에 그들로 거하게 하고 그들 중에 능한 자가 있는줄 알거든 그들로 나의 짐승을 주관하게 하라' ");
INSERT INTO kor_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","요셉이 자기 아비 야곱을 인도하여 바로 앞에 서게 하니 야곱이 바로에게 축복하매 ");
INSERT INTO kor_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","바로가 야곱에게 묻되 `네 연세가 얼마뇨 ?' ");
INSERT INTO kor_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","야곱이 바로에게 고하되 `내 나그네 길의 세월이 일백 삼십년이니이다 나의 연세가 얼마 못되니 우리 조상의 나그네 길의 세월에 미치지 못하나 험악한 세월을 보내었나이다' 하고 ");
INSERT INTO kor_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","야곱이 바로에게 축복하고 그 앞에서 나오니라 ");
INSERT INTO kor_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","요셉이 바로의 명대로 그 아비와 형들에게 거할 곳을 주되 애굽의 좋은 땅 라암세스를 그들에게 주어 기업을 삼게 하고 ");
INSERT INTO kor_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","또 그 아비와 형들과 아비의 온 집에 그 식구를 따라 식물을 주어 공궤하였더라 ");
INSERT INTO kor_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","기근이 더욱 심하여 사방에 식물이 없고 애굽 땅과 가나안 땅이 기근으로 쇠약하니 ");
INSERT INTO kor_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","요셉이 곡식을 팔아 애굽 땅과 가나안 땅에 있는 돈을 몰수히 거두고 그 돈을 바로의 궁으로 가져오니 ");
INSERT INTO kor_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","애굽 땅과 가나안 땅에 돈이 진한지라 애굽 백성이 다 요셉에게 와서 가로되 `돈이 진하였사오니 우리에게 식물을 주소서 어찌 주 앞에서 죽으리이까 ?' ");
INSERT INTO kor_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","요셉이 가로되 `너희의 짐승을 내라 돈이 진하였은즉 내가 너희의 짐승과 바꾸어 주리라' ");
INSERT INTO kor_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","그들이 그 짐승을 요셉에게 끌어 오는지라 요셉이 그 말과 양떼와 소떼와 나귀를 받고 그들에게 식물을 주되 곧 그 모든 짐승과 바꾸어서 그 해 동안에 식물로 그들을 기르니라 ");
INSERT INTO kor_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","그 해가 다하고 새 해가 되매 무리가 요셉에게 와서 그에게 고하되 우리가 주께 숨기지 아니하나이다 우리의 돈이 다하였고 우리의 짐승떼가 주께로 돌아갔사오니 주께 낼 것이 아무 것도 남지 아니하고 우리의 몸과 전지뿐이라 ");
INSERT INTO kor_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","우리가 어찌 우리의 전지와 함께 주의 목전에 죽으리이까 ? 우리 몸과 우리 토지를 식물로 사소서 우리가 토지와 함께 바로의 종이 되리니 우리에게 종자를 주시면 우리가 살고 죽지 아니하고 전지도 황폐치 아니하리이다' ");
INSERT INTO kor_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","그러므로 요셉이 애굽 전지를 다 사서 바로에게 드리니 애굽 사람이 기근에 몰려서 각기 전지를 팖이라 땅이 바로의 소유가 되니라 ");
INSERT INTO kor_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","요셉이 애굽 이 끝에서 저 끝까지의 백성을 성읍들에 옮겼으나 ");
INSERT INTO kor_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","제사장의 전지는 사지 아니하였으니 제사장은 바로에게서 녹을 받음이라 바로의 주는 녹을 먹으므로 그 전지를 팔지 않음이었더라 ");
INSERT INTO kor_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","요셉이 백성에게 이르되 `오늘날 내가 바로를 위하여 너희 몸과 너희 전지를 샀노라 여기 종자가 있으니 너희는 그 땅에 뿌리라 ");
INSERT INTO kor_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","추수의 오분 일을 바로에게 상납하고 사분은 너희가 취하여 전지의 종자도 삼고 너희의 양식도 삼고 너희 집 사람과 어린 아이의 양식도 삼으라' ");
INSERT INTO kor_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","그들이 가로되 `주께서 우리를 살리셨사오니 우리가 주께 은혜를 입고 바로의 종이 되겠나이다' ");
INSERT INTO kor_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","요셉이 애굽 토지법을 세우매 그 오분 일이 바로에게 상납되나 제사장의 토지는 바로의 소유가 되지 아니하여 오늘까지 이르니라 ");
INSERT INTO kor_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","이스라엘 족속이 애굽 고센 땅에 거하며 거기서 산업을 얻고 생육하며 번성하였더라 ");
INSERT INTO kor_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","야곱이 애굽 땅에 십 칠년을 거하였으니 그의 수가 일백 사십 칠세라 ");
INSERT INTO kor_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","이스라엘의 죽을 기한이 가까우매 그가 그 아들 요셉을 불러 그에게 이르되 `이제 내가 네게 은혜를 입었거든 청하노니 네 손을 내 환도뼈 아래 넣어서 나를 인애와 성심으로 대접하여 애굽에 장사하지 않기를 맹세하고 ");
INSERT INTO kor_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","내가 조상들과 함께 눕거든 너는 나를 애굽에서 메어다가 선영에 장사하라' 요셉이 가로되 `내가 아버지의 말씀대로 행하리이다 !' ");
INSERT INTO kor_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","야곱이 또 가로되 `내게 맹세하라' 맹세하니 이스라엘이 침상 머리에서 경배하니라 ");
INSERT INTO kor_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","이 일 후에 혹이 요셉에게 고하기를 `네 부친이 병들었다' 하므로 그가 곧 두아들 므낫세와 에브라임과 함께 이르니 ");
INSERT INTO kor_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","혹이 야곱에게 고하되 `네 아들 요셉이 네게 왔다' 하매 이스라엘이 힘을 내어 침상에 앉아 ");
INSERT INTO kor_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","요셉에게 이르되 `이전에 가나안 땅 루스에서 전능한 하나님이 내게 나타나 복을 허락하여 ");
INSERT INTO kor_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","내게 이르시되 내가 너로 생육하게 하며 번성하게 하여 네게서 많은 백성이 나게 하고 내가 이 땅을 네 후손에게 주어 영원한 기업이 되게 하리라 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","내가 애굽으로 와서 네게 이르기 전에 애굽에서 네게 낳은 두 아들 에브라임과 므낫세는 내 것이라 르우벤과 시므온처럼 내 것이 될 것이요 ");
INSERT INTO kor_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","이들 후의 네 소생이 네 것이 될 것이며 그 산업은 그 형의 명의하에서 함께 하리라 ");
INSERT INTO kor_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","내게 관하여는 내가 이전에 내가 밧단에서 올 때에 라헬이 나를 따르는 노중 가나안 땅에서 죽었는데 그곳은 에브랏까지 길이 오히려 격한 곳이라 내가 거기서 그를 에브랏 길에 장사 하였느니라' (에브랏은 곧 베들레헴이라) ");
INSERT INTO kor_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","이스라엘이 요셉의 아들들을 보고 가로되 `이들은 누구냐 ?` ");
INSERT INTO kor_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","요셉이 그 아비에게 고하되 `이는 하나님이 여기서 내게 주신 아들들이니이다` 아비가 가로되 `그들을 이끌어 내 앞으로 나아오라 내가 그들에게 축복하리라' ");
INSERT INTO kor_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","이스라엘의 눈이 나이로 인하여 어두워서 보지 못하더라 요셉이 두 아들을 이끌어 아비 앞으로 나아가니 이스라엘이 그들에게 입맞추고 그들을 안고 ");
INSERT INTO kor_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","요셉에게 이르되 `내가 네 얼굴을 보리라고는 뜻하지 못하였더니 하나님이 내게 네 소생까지 보이셨도다' ");
INSERT INTO kor_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","요셉이 아비 무릎 사이에서 두 아들을 물리고 땅에 엎드려 절하고 ");
INSERT INTO kor_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","우수로는 에브라임을 이스라엘의 좌수를 향하게 하고 좌수로는 므낫세를 이스라엘의 우수를 향하게 하고 이끌어 그에게 가까이 나아가매 ");
INSERT INTO kor_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","이스라엘이 우수를 차자 에브라임의 머리에 얹고 좌수를 펴서 므낫세의 머리에 얹으니 므낫세는 장자라도 팔을 어긋맞겨 얹었더라 ");
INSERT INTO kor_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","그가 요셉을 위하여 축복하여 가로되 `내 조부 아브라함과 아버지 이삭의 섬기던 하나님, 나의 남으로부터 지금까지 나를 기르신 하나님, ");
INSERT INTO kor_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","나를 모든 환난에서 건지신 사자께서 이 아이에게 복을 주시오며 이들로 내 이름과 내 조부 아브라함과 아버지 이삭의 이름으로 칭하게 하시오며 이들로 세상에서 번식되게 하시기를 원하나이다' ");
INSERT INTO kor_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","요셉이 그 아비가 우수를 에브라임의 머리에 얹은 것을 보고 기뻐 아니하여 아비의 손을 들어 에브라임의 머리에서 므낫세의 머리로 옮기고자 하여 ");
INSERT INTO kor_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","그 아비에게 이르되 `아버지여, 그리 마옵소서 이는 장자니 우수를 그 머리에 얹으소서' ");
INSERT INTO kor_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","아비가 허락지 아니하여 가로되 `나도 안다 내 아들아 ! 나도 안다 그도 한 족속이 되며 그도 크게 되려니와 그 아우가 그보다 큰 자가 되고 그 자손이 여러 민족을 이루리라` 하고 ");
INSERT INTO kor_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","그 날에 그들에게 축복하여 가로되 `이스라엘 족속이 너로 축복하기를 하나님이 너로 에브라임 같고 므낫세같게 하시리라 하리라' 하여 에브라임을 므낫세보다 앞세웠더라 ");
INSERT INTO kor_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","이스라엘이 요셉에게 또 이르되 `나는 죽으나 하나님이 너희와 함께 계시사 너희를 인도하여 너희 조상의 땅으로 돌아가게 하시려니와 ");
INSERT INTO kor_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","내가 네게 네 형제보다 일부분을 더 주었나니 이는 내가 내 칼과 활로 아모리 족속의 손에서 빼앗은 것이니라' ");
INSERT INTO kor_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","야곱이 그 아들들을 불러 이르되 너희는 모이라 너희의 후일에 당할 일을 내가 너희에게 이르리라 ");
INSERT INTO kor_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","너희는 모여 들으라 야곱의 아들들아 너희 아비 이스라엘에게 들을지어다 ! ");
INSERT INTO kor_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","르우벤아 너는 내 장자요 나의 능력이요 나의 기력의 시작이라 위광이 초등하고 권능이 탁월하도다마는 ");
INSERT INTO kor_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","물의 끓음 같았은즉 너는 탁월치 못하리니 네가 아비의 침상에 올라 더럽혔음이로다 그가 내 침상에 올랐었도다 ");
INSERT INTO kor_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","시므온과 레위는 형제요 그들의 칼은 잔해하는 기계로다 ");
INSERT INTO kor_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","내 혼아, 그들의 모의에 상관하지 말지어다 내 영광아 그들의 집회에 참여하지 말지어다 그들이 그 분노대로 사람을 죽이고 그 혈기대로 소의 발목 힘줄을 끊었음이로다 ");
INSERT INTO kor_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","그 노염이 혹독하니 저주를 받을 것이요 분기가 맹렬하니 저주를 받을 것이라 내가 그들을 야곱중에서 나누며 이스라엘 중에서 흩으리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","유다야, 너는 네 형제의 찬송이 될지라 ! 네 손이 네 원수의 목을 잡을 것이요 네 아비의 아들들이 네 앞에 절하리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","유다는 사자 새끼로다 내 아들아 ! 너는 움킨 것을 찢고 올라 갔도다 그의 엎드리고 웅크림이 수사자 같고 암사자 같으니 누가 그를 범할 수 있으랴 ");
INSERT INTO kor_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","홀이 유다를 떠나지 아니하며 치리자의 지팡이가 그 발 사이에서 떠나지 아니하시기를 실로가 오시기까지 미치리니 그에게 모든 백성이 복종하리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","그의 나귀를 포도나무에 매며 그 암나귀 새끼를 아름다운 포도나무에 맬 것이며 또 그 옷을 포도주에 빨며 그 복장을 포도즙에 빨리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","그 눈은 포도주로 인하여 붉겠고 그 이는 우유로 인하여 희리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","스불론은 해변에 거하리니 그곳은 배 매는 해변이라 그 지경이 시돈까지리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","잇사갈은 양의 우리 사이에 꿇어 앉은 건장한 나귀로다 ");
INSERT INTO kor_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","그는 쉴 곳을 보고 좋게 여기며 토지를 보고 아름답게 여기고 어깨를 내려 짐을 메고 압제 아래서 섬기리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","단은 이스라엘의 한 지파같이 그 백성을 심판하리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","단은 길의 뱀이요 첩경의 독사리로다 말굽을 물어서 그 탄 자로 뒤로 떨어지게 하리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","여호와여 ! 나는 주의 구원을 기다리나이다 ");
INSERT INTO kor_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","갓은 군대의 박격을 받으나 도리어 그 뒤를 추격하리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","아셀에게서 나는 식물은 기름진 것이라 그가 왕의 진수를 공궤하리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","납달리는 놓인 암사슴이라 아름다운 소리를 발하는도다 ");
INSERT INTO kor_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","요셉은 무성한 가지 곧 샘 곁의 무성한 가지라 그 가지가 담을 넘었도다 ");
INSERT INTO kor_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","활쏘는 자가 그를 학대하며 그를 쏘며 그를 군박하였으나 ");
INSERT INTO kor_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","요셉의 활이 도리어 견강하며 그의 팔이 힘이 있으니 야곱의 전능자의 손을 힘입음이라 그로부터 이스라엘의 반석인 목자가 나도다 ");
INSERT INTO kor_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","네 아비의 하나님께로 말미암나니 그가 너를 도우실 것이요 전능자로 말미암나니 그가 네게 복을 주실 것이라 위로 하늘의 복과 아래로 원천의 복과 젖먹이는 복과 태의 복이리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","네 아비의 축복이 내 부여조의 축복보다 나아서 영원한 산이 한 없음같이 이 축복이 요셉의 머리로 돌아오며 그 형제중 뛰어난 자의 정수리로 돌아오리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","베냐민은 물어 뜯는 이리라 아침에는 빼앗은 것을 먹고 저녁에는 움킨 것을 나누리로다 ");
INSERT INTO kor_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","이들은 이스라엘의 십 이 지파라 이와 같이 그 아비가 그들에게 말하고 그들에게 축복하였으되 곧 그들 각인의 분량대로 축복하였더라 ");
INSERT INTO kor_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","그가 그들에게 명하여 가로되 `내가 내 열조에게로 돌아가리니 나를 헷 사람 에브론 밭에 있는 굴에 우리 부여조와 함께 장사하라 ");
INSERT INTO kor_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","이 굴은 가나안 땅 마므레 앞 막벨라 밭에 있는 것이라 아브라함이 헷 사람 에브론에게서 밭과 함께 사서 그 소유 매장지를 삼았으므로 ");
INSERT INTO kor_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","아브라함과 그 아내 사라가 거기 장사되었고 이삭과 그 아내 리브가도 거기 장사되었으며 나도 레아를 그 곳에 장사하였노라 ");
INSERT INTO kor_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","이 밭과 거기 있는 굴은 헷 사람에게서 산 것이니라' ");
INSERT INTO kor_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","야곱이 아들에게 명하기를 마치고 그 발을 침상에 거두고 기운이 진하여 그 열조에게로 돌아갔더라 ");
INSERT INTO kor_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","요셉이 아비 얼굴에 구푸려 울며 입맞추고 ");
INSERT INTO kor_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","그 수종 의사에게 명하여 향 재료로 아비의 몸에 넣게 하매 의사가 이스라엘에게 그대로 하되 ");
INSERT INTO kor_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","사십일이 걸렸으니 향 재료를 넣는 데는 이 날수가 걸림이며 애굽 사람들은 칠십일 동안 그를 위하여 곡하였더라 ");
INSERT INTO kor_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","곡하는 기한이 지나매 요셉이 바로의 궁에 말하여 가로되 `내가 너희에게 은혜를 입었으면 청컨대 바로의 귀에 고하기를 ");
INSERT INTO kor_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","우리 아버지가 나로 맹세하게 하여 이르되 내가 죽거든 가나안 땅에 내가 파서 둔 묘실에 나를 장사하라 하였나니 나로 올라가서 내가 다시 오리이다 하라' 하였더니 ");
INSERT INTO kor_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","바로가 가로되 `그가 네게 시킨 맹세대로 올라가서 네 아비를 장사하라' ");
INSERT INTO kor_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","요셉이 자기 아비를 장사하러 올라가니 바로의 모든 신하와 바로 궁의 장로들과 애굽 땅의 모든 장로와 ");
INSERT INTO kor_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","요셉의 온 집과 그 형제들과 그 아비의 집이 그와 함께 올라가고 그들의 어린 아이들과 양떼와 소떼만 고센 땅에 남겼으며 ");
INSERT INTO kor_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","병거와 기병이 요셉을 따라 올라가니 그 떼가 심히 컸더라 ");
INSERT INTO kor_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","그들이 요단강 건너편 아닷 타작마당에 이르러 거기서 크게 호곡하고 애통하며 요셉이 아비를 위하여 칠일 동안 애곡하였더니 ");
INSERT INTO kor_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","그 땅 거민 가나안 백성들이 아닷 마당의 애통을 보고 가로되 `이는 애굽 사람의 큰 애통이라' 하였으므로 그 땅 이름을 아벨미스라임이라 하였으니 곧 요단강 건너편이더라 ");
INSERT INTO kor_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","야곱의 아들들이 부명을 좇아 행하여 ");
INSERT INTO kor_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","그를 가나안 땅으로 메어다가 마므레 앞 막벨라 밭 굴에 장사하였으니 이는 아브라함이 헷 족속 에브론에게 밭과 함께 사서 소유 매장지를 삼은 곳이더라 ");
INSERT INTO kor_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","요셉이 아비를 장사한 후에 자기 형제와 호상군과 함께 애굽으로 돌아왔더라 ");
INSERT INTO kor_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","요셉의 형제들이 그 아비가 죽었음을 보고 말하되 `요셉이 혹시 우리를 미워하여 우리가 그에게 행한 모든 악을 다 갚지나 아니할까 ?' 하고 ");
INSERT INTO kor_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","요셉에게 말을 전하여 가로되 `당신의 아버지가 돌아가시기 전에 명하여 이르시기를 ");
INSERT INTO kor_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","너희는 이같이 요셉에게 이르라 네 형들이 네게 악을 행하였을지라도 이제 바라건대 그 허물과 죄를 용서하라 하셨다 하라 하셨나니 당신의 아버지의 하나님의 종들의 죄를 이제 용서하소서` 하매 요셉의 그 말을 들을 때에 울었더라 ");
INSERT INTO kor_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","그 형들이 또 친히 와서 요셉의 앞에 엎드려 가로되 `우리는 당신의 종이니이다' ");
INSERT INTO kor_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","요셉이 그들에게 이르되 `두려워 마소서 내가 하나님을 대신하리이까 ? ");
INSERT INTO kor_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","당신들은 나를 해하려 하였으나 하나님은 그것을 선으로 바꾸사 오늘과 같이 만민의 생명을 구원하게 하시려 하셨나니 ");
INSERT INTO kor_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","당신들은 두려워 마소서 내가 당신들과 당신들의 자녀를 기르리이다' 하고 그들을 간곡한 말로 위로하였더라 ");
INSERT INTO kor_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","요셉이 그 아비의 가족과 함께 애굽에 거하여 일백 십세를 살며 ");
INSERT INTO kor_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","에브라임의 자손 삼대를 보았으며 므낫세의 아들 마길의 아들들도 요셉의 슬하에서 양육되었더라 ");
INSERT INTO kor_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","요셉이 그 형제에게 이르되 `나는 죽으나 하나님이 너희를 권고하시고 너희를 이 땅에서 인도하여 내사 아브라함과 이삭과 야곱에게 맹세하신 땅에 이르게 하시리라` 하고 ");
INSERT INTO kor_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","요셉이 또 이스라엘 자손에게 맹세시켜 이르기를 `하나님이 정녕 너희를 권고하시리니 너희는 여기서 내 해골을 메고 올라가겠다 하라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","요셉이 일백십세에 죽으매 그들이 그의 몸에 향 재료를 넣고 애굽에서 입관하였더라 ");
INSERT INTO kor_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","야곱과 함께 각기 권속을 데리고 애굽에 이른 이스라엘 아들들의 이름은 이러하니 ");
INSERT INTO kor_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","르우벤과, 시므온과, 레위와, 유다와 ");
INSERT INTO kor_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","잇사갈과, 스불론과, 베냐민과 ");
INSERT INTO kor_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","단과, 납달리와, 갓과, 아셀이요 ");
INSERT INTO kor_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","이미 애굽에 있는 요셉까지 야곱의 혈속이 모두 칠십인이었더라 ");
INSERT INTO kor_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","요셉과 그의 모든 형제와 그 시대 사람은 다 죽었고 ");
INSERT INTO kor_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","이스라엘 자손은 생육이 중다하고 번식하고 창성하고 심히 강대하여 온 땅에 가득하게 되었더라 ");
INSERT INTO kor_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","요셉을 알지 못하는 새 왕이 일어나서 애굽을 다스리더니 ");
INSERT INTO kor_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","그가 그 신민에게 이르되 `이 백성 이스라엘 자손이 우리보다 많고 강하도다 ");
INSERT INTO kor_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","자, 우리가 그들에게 대하여 지혜롭게 하자 두렵건대 그들이 더 많게 되면 전쟁이 일어날 때에 우리 대적과 합하여 우리와 싸우고 이 땅에서 갈까 하노라' 하고 ");
INSERT INTO kor_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","감독들을 그들 위에 세우고 그들에게 무거운 짐을 지워 괴롭게 하여 그들로 바로를 위하여 국고성 비돔과 라암셋을 건축하게 하니라 ");
INSERT INTO kor_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","그러나 학대를 받을수록 더욱 번식하고 창성하니 애굽 사람이 이스라엘 자손을 인하여 근심하여 ");
INSERT INTO kor_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","이스라엘 자손의 역사를 엄하게 하여 ");
INSERT INTO kor_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","고역으로 그들의 생활을 괴롭게 하니 곧 흙 이기기와 벽돌 굽기와 농사의 여러가지 일이라 그 시키는 역사가 다 엄하였더라 ");
INSERT INTO kor_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","애굽 왕이 히브리 산파 십브라라 하는 자와 부아라 하는 자에게 일러 ");
INSERT INTO kor_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","가로되 `너희는 히브리 여인을 위하여 조산할 때에 살펴서 남자여든 죽이고 여자여든 그는 살게 두라' ");
INSERT INTO kor_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","그러나 산파들이 하나님을 두려워하여 애굽 왕의 명을 어기고 남자를 살린지라 ");
INSERT INTO kor_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","애굽 왕이 산파를 불러서 그들에게 이르되 `너희가 어찌 이같이 하여 남자를 살렸느냐 ?' ");
INSERT INTO kor_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","산파가 바로에게 대답하되 `히브리 여인은 애굽 여인과 같지 아니하고 건장하여 산파가 그들에게 이르기 전에 해산하였더이다' 하매 ");
INSERT INTO kor_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","하나님이 그 산파들에게 은혜를 베푸시니라 백성은 생육이 번성하고 심히 강대하며 ");
INSERT INTO kor_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","산파는 하나님을 경외하였으므로 하나님이 그들의 집을 왕성케 하신지라 ");
INSERT INTO kor_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","그러므로 바로가 그 모든 신민에게 명하여 가로되 `남자가 나거든 너희는 그를 하수에 던지고 여자여든 살리라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","레위 족속 중 한 사람이 가서 레위 여자에게 장가 들었더니 ");
INSERT INTO kor_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","그 여자가 잉태하여 아들을 낳아 그 준수함을 보고 그를 석달을 숨겼더니 ");
INSERT INTO kor_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","더 숨길 수 없이 되매 그를 위하여 갈 상자를 가져다가 역청과 나무 진을 칠하고 아이를 거기 담아 하숫가 갈대 사이에 두고 ");
INSERT INTO kor_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","그 누이가 어떻게 되는 것을 알려고 멀리 섰더니 ");
INSERT INTO kor_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","바로의 딸이 목욕하러 하수로 내려오고 시녀들은 하숫가에 거닐 때에 그가 갈대 사이에 상자를 보고 시녀를 보내어 가져다가 ");
INSERT INTO kor_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","열고 그 아이를 보니 아이가 우는지라 그가 불쌍히 여겨 가로되 `이는 히브리 사람의 아이로다' ");
INSERT INTO kor_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","그 누이가 바로의 딸에게 이르되 `내가 가서 히브리 여인 중에서 유모를 불러다가 당신을 위하여 이 아이를 젖 먹이게 하리이까 ?' ");
INSERT INTO kor_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","바로의 딸이 그에게 이르되 `가라' 그 소녀가 가서 아이의 어미를 불러오니 ");
INSERT INTO kor_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","바로의 딸이 그에게 이르되 `이 아이를 데려다가 나를 위하여 젖을 먹이라 내가 그 삯을 주리라' 여인이 아이를 데려다가 젖을 먹이더니 ");
INSERT INTO kor_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","그 아이가 자라매 바로의 딸에게로 데려가니 그의 아들이 되니라 그가 그 이름을 모세라 하여 가로되 `이는 내가 그를 물에서 건져내었음이라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","모세가 장성한 후에 한번은 자기 형제들에게 나가서 그 고역함을 보더니 어떤 애굽 사람이 어떤 히브리 사람 곧 자기 형제를 치는 것을 본지라 ");
INSERT INTO kor_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","좌우로 살펴 사람이 없음을 보고 그 애굽 사람을 쳐죽여 모래에 감추니라 ");
INSERT INTO kor_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","이튿날 다시 나가니 두 히브리 사람이 서로 싸우는지라 그 그른 자에게 이르되 `네가 어찌하여 동포를 치느냐 ?' 하매 ");
INSERT INTO kor_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","그가 가로되 `누가 너로 우리의 주재와 법관을 삼았느냐 ? 네가 애굽 사람을 죽임같이 나도 죽이려느냐 ?' 모세가 두려워하여 가로되 `일이 탄로되었도다' ");
INSERT INTO kor_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","바로가 이 일을 듣고 모세를 죽이고자 하여 찾은지라 모세가 바로의 낯을 피하여 미디안 땅에 머물며 하루는 우물 곁에 앉았더라 ");
INSERT INTO kor_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","미디안 제사장에게 일곱 딸이 있더니 그들이 와서 물을 길어 구유에 채우고 그 아비의 양무리에게 먹이려 하는데 ");
INSERT INTO kor_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","목자들이 와서 그들을 쫓는지라 모세가 일어나 그들을 도와 그 양무리에게 먹이니라 ");
INSERT INTO kor_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","그들이 그 아비 르우엘에게 이를 때에 아비가 가로되 `너희가 오늘은 어찌하여 이같이 속히 돌아오느냐 ?' ");
INSERT INTO kor_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","그들이 가로되 `한 애굽 사람이 우리를 목자들의 손에서 건져내고 우리를 위하여 물을 길어 양무리에게 먹였나이다' ");
INSERT INTO kor_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","아비가 딸들에게 이르되 `그 사람이 어디 있느냐 ? 너희가 어찌하여 그 사람을 버리고 왔느냐 ? 그를 청하여 음식으로 대접하라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","모세가 그와 동거하기를 기뻐하매 그가 그 딸 십보라를 모세에게 주었더니 ");
INSERT INTO kor_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","그가 아들을 낳으매 모세가 그 이름을 게르솜이라 하여 가로되 `내가 타국에서 객이 되었음이라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","여러 해 후에 애굽 왕은 죽었고 이스라엘 자손은 고역으로 인하여 탄식하며 부르짖으니 그 고역으로 인하여 부르짖는 소리가 하나님께 상달한지라 ");
INSERT INTO kor_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","하나님이 그 고통 소리를 들으시고 아브라함과 이삭과 야곱에게 세운 그 언약을 기억하사 ");
INSERT INTO kor_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","이스라엘 자손을 권념하셨더라 ");
INSERT INTO kor_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","모세가 그 장인 미디안 제사장 이드로의 양무리를 치더니 그 무리를 광야 서편으로 인도하여 하나님의 산 호렙에 이르매 ");
INSERT INTO kor_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","여호와의 사자가 떨기나무 불꽃 가운데서 그에게 나타나시니라 그가 보니 떨기나무에 불이 붙었으나 사라지지 아니하는지라 ");
INSERT INTO kor_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","이에 가로되 `내가 돌이켜 가서 이 큰 광경을 보리라 떨기나무가 어찌하여 타지 아니하는고 ?' 하는 동시에 ");
INSERT INTO kor_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","여호와께서 그가 보려고 돌이켜 오는 것을 보신지라 하나님이 떨기나무 가운데서 그를 불러 가라사대 모세야, 모세야 ! 하시매 그가 가로되 '내가 여기 있나이다' ");
INSERT INTO kor_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","하나님이 가라사대 이리로 가까이 하지 말라 너의 선 곳은 거룩한 땅이니 네 발에서 신을 벗으라 ! ");
INSERT INTO kor_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","또 이르시되 나는 네 조상의 하나님이니 아브라함의 하나님, 이삭의 하나님, 야곱의 하나님이니라 모세가 하나님 뵈옵기를 두려워하여 얼굴을 가리우매 ");
INSERT INTO kor_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","여호와께서 가라사대 내가 애굽에 있는 내 백성의 고통을 정녕히 보고 그들이 그 간역자로 인하여 부르짖음을 듣고 그 우고를 알고 ");
INSERT INTO kor_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","내가 내려와서 그들을 애굽인의 손에서 건져내고 그들을 그 땅에서 인도하여 아름답고 광대한 땅 젖과 꿀이 흐르는 땅 곧 가나안 족속, 헷 족속, 아모리 족속, 브리스 족속, 히위 족속, 여부스 족속의 지방에 이르려 하노라 ");
INSERT INTO kor_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","이제 이스라엘 자손의 부르짖음이 내게 달하고 애굽 사람이 그들을 괴롭게 하는 학대도 내가 보았으니 ");
INSERT INTO kor_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","이제 내가 너를 바로에게 보내어 너로 내 백성 이스라엘 자손을 애굽에서 인도하여 내게 하리라 ");
INSERT INTO kor_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","모세가 하나님께 고하되 `내가 누구관대 바로에게 가며 이스라엘 자손을 애굽에서 인도하여 내리이까 ?' ");
INSERT INTO kor_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","하나님이 가라사대 내가 정녕 너와 함께 있으리라 ! 네가 백성을 애굽에서 인도하여 낸 후에 너희가 이 산에서 하나님을 섬기리니 이것이 내가 너를 보낸 증거니라 ");
INSERT INTO kor_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","모세가 하나님께 고하되 `내가 이스라엘 자손에게 가서 이르기를 너희 조상의 하나님이 나를 너희에게 보내셨다 하면 그들이 내게 묻기를 그의 이름이 무엇이냐 ? 하리니 내가 무엇이라고 그들에게 말하리이까 ?' ");
INSERT INTO kor_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","하나님이 모세에게 이르시되 나는 스스로 있는 자니라 ! 또 이르시되 너는 이스라엘 자손에게 이같이 이르기를 스스로 있는 자가 나를 너희에게 보내셨다 하라 ");
INSERT INTO kor_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","하나님이 또 모세에게 이르시되 너는 이스라엘 자손에게 이같이 이르기를 나를 너희에게 보내신 이는 너희 조상의 하나님 곧 아브라함의 하나님, 이삭의 하나님, 야곱의 하나님 여호와라 하라 이는 나의 영원한 이름이요 대대로 기억할 나의 표호니라 ! ");
INSERT INTO kor_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","너는 가서 이스라엘 장로들을 모으고 그들에게 이르기를 여호와 너희 조상의 하나님 곧 아브라함과 이삭과 야곱의 하나님이 내게 나타나 이르시되 내가 실로 너희를 권고하여 너희가 애굽에서 당한 일을 보았노라 ");
INSERT INTO kor_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","내가 말하였거니와 내가 너희를 애굽의 고난 중에서 인도하여 내어 젖과 꿀이 흐르는 땅 곧 가나안 족속, 헷 족속, 아모리 족속, 브리스 족속, 히위 족속, 여부스 족속의 땅으로 올라가게 하리라 하셨다 하면 ");
INSERT INTO kor_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","그들이 네 말을 들으리니 너는 그들의 장로들과 함께 애굽 왕에게 이르기를 히브리 사람의 하나님 여호와께서 우리에게 임하셨은즉 우리가 우리 하나님 여호와께 희생을 드리려 하오니 사흘길쯤 광야로 가기를 허락하소서 하라 ");
INSERT INTO kor_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","내가 아노니 강한 손으로 치기 전에는 애굽 왕이 너희의 가기를 허락지 아니하다가 ");
INSERT INTO kor_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","내가 내 손을 들어 애굽 중에 여러가지 이적으로 그 나라를 친 후에야 그가 너희를 보내리라 ");
INSERT INTO kor_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","내가 애굽 사람으로 이 백성에게 은혜를 입히게 할지라 너희가 갈 때에 빈 손으로 가지 아니하리니 ");
INSERT INTO kor_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","여인마다 그 이웃 사람과 및 자기 집에 우거하는 자에게 은 패물과 금 패물과 의복을 구하여 너희 자녀를 꾸미라 너희가 애굽 사람의 물품을 취하리라 ");
INSERT INTO kor_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","모세가 대답하여 가로되 `그러나 그들이 나를 믿지 아니하며 내 말을 듣지 아니하고 이르기를 여호와께서 네게 나타나지 아니하셨다 하리이다' ");
INSERT INTO kor_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","여호와께서 그에게 이르시되 네 손에 있는 것이 무엇이냐 ? 그가 가로되 `지팡이니이다' ");
INSERT INTO kor_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","여호와께서 가라사대 그것을 땅에 던지라 ! 곧 땅에 던지니 그것이 뱀이 된지라 모세가 뱀 앞에서 피하매 ");
INSERT INTO kor_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","여호와께서 모세에게 이르시되 네 손을 내밀어 그 꼬리를 잡으라 ! 그가 손을 내밀어 잡으니 그 손에서 지팡이가 된지라 ");
INSERT INTO kor_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","또 가라사대 이는 그들로 그 조상의 하나님 곧 아브라함의 하나님, 이삭의 하나님, 야곱의 하나님 여호와가 네게 나타난 줄을 믿게 함이니라 하시고 ");
INSERT INTO kor_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","여호와께서 또 가라사대 네 손을 품에 넣으라 ! 하시매 손을 품에 넣었다가 내어보니 그 손에 문둥병이 발하여 눈 같이 흰지라 ");
INSERT INTO kor_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","가라사대 네 손을 다시 품에 넣으라 ! 하시매 그가 다시 손을 품에 넣었다가 내어보니 손이 여상하더라 ");
INSERT INTO kor_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","여호와께서 가라사대 그들이 너를 믿지 아니하며 그 처음 이적의 표징을 받지 아니하여도 둘째 이적의 표징은 믿으리라 ");
INSERT INTO kor_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","그들이 이 두 이적을 믿지 아니하며 네 말을 듣지 아니하거든 너는 하수를 조금 취하여다가 육지에 부으라 ! 네가 취한 하수가 육지에서 피가 되리라 ");
INSERT INTO kor_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","모세가 여호와께 고하되 `주여, 나는 본래 말에 능치 못한 자라 주께서 주의 종에게 명하신 후에도 그러하니 나는 입이 뻣뻣하고 혀가 둔한 자니이다' ");
INSERT INTO kor_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","여호와께서 그에게 이르시되 누가 사람의 입을 지었느뇨 ! 누가 벙어리나 귀머거리나 눈 밝은 자나 소경이 되게 하였느뇨 ! 나 여호와가 아니뇨 ? ");
INSERT INTO kor_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","이제 가라 내가 네 입과 함께 있어서 할 말을 가르치리라 ");
INSERT INTO kor_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","모세가 가로되 `주여, 보낼만한 자를 보내소서' ");
INSERT INTO kor_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","여호와께서 모세를 향하여 노를 발하시고 가라사대 레위 사람 네 형 아론이 있지 아니하뇨 ? 그의 말 잘함을 내가 아노라 그가 너를 만나러 나오나니 그가 너를 볼 때에 마음에 기뻐할 것이라 ");
INSERT INTO kor_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","너는 그에게 말하고 그 입에 말을 주라 내가 네 입과 그의 입에 함께 있어서 너의 행할 일을 가르치리라 ");
INSERT INTO kor_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","그가 너를 대신하여 백성에게 말할 것이니 그는 네 입을 대신할 것이요 너는 그에게 하나님 같이 되리라 ");
INSERT INTO kor_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","너는 이 지팡이를 손에 잡고 이것으로 이적을 행할지니라 ");
INSERT INTO kor_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","모세가 장인 이드로에게로 돌아가서 그에게 이르되 `내가 애굽에 있는 내 형제들에게로 돌아가서 그들이 생존하였는지 보려하오니 나로 가게 하소서' 이드로가 그에게 '평안히 가라' 하니라 ");
INSERT INTO kor_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","여호와께서 미디안에서 모세에게 이르시되 애굽으로 돌아가라 네 생명을 찾던 자가 다 죽었느니라 ");
INSERT INTO kor_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","모세가 그 아내와 아들들을 나귀에 태우고 애굽으로 돌아가는데 하나님의 지팡이를 손에 잡았더라 ");
INSERT INTO kor_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","여호와께서 모세에게 이르시되 네가 애굽으로 돌아가거든 내가 네 손에 준 이적을 바로 앞에서 다 행하라 그러나 내가 그의 마음을 강퍅케 한즉 그가 백성을 놓지 아니하리니 ");
INSERT INTO kor_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","너는 바로에게 이르기를 여호와의 말씀에 이스라엘은 내 아들, 내 장자라 ! ");
INSERT INTO kor_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","내가 네게 이르기를 내 아들을 놓아서 나를 섬기게 하라 하여도 네가 놓기를 거절하니 내가 네 아들 네 장자를 죽이리라 하셨다 하라 하시니라 ");
INSERT INTO kor_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","여호와께서 길의 숙소에서 모세를 만나사 그를 죽이려 하시는지라 ");
INSERT INTO kor_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","십보라가 차돌을 취하여 그 아들의 양피를 베어 모세의 발 앞에 던지며 가로되 `당신은 참으로 내게 피 남편이로다' 하니 ");
INSERT INTO kor_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","여호와께서 모세를 놓으시니라 그 때에 십보라가 피 남편이라 함은 할례를 인함이었더라 ");
INSERT INTO kor_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","여호와께서 아론에게 이르시되 광야에 가서 모세를 맞으라 하시매 그가 가서 하나님의 산에서 모세를 만나 그에게 입맞추니 ");
INSERT INTO kor_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","모세가 여호와께서 자기에게 부탁하여 보내신 모든 말씀과 여호와께서 자기에게 명하신 모든 이적을 아론에게 고하니라 ");
INSERT INTO kor_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","모세와 아론이 가서 이스라엘 자손의 모든 장로를 모으고 ");
INSERT INTO kor_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","아론이 여호와께서 모세에게 명하신 모든 말씀을 전하고 백성 앞에서 이적을 행하니 ");
INSERT INTO kor_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","백성이 믿으며 여호와께서 이스라엘 자손을 돌아보시고 그 고난을 감찰하셨다 함을 듣고 머리 숙여 경배하였더라 ");
INSERT INTO kor_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","그 후에 모세와 아론이 가서 바로에게 이르되 `이스라엘 하나님 여호와의 말씀에 내 백성을 보내라 그들이 광야에서 내 앞에 절기를 지킬 것이니라 하셨나이다' ");
INSERT INTO kor_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","바로가 가로되 `여호와가 누구관대 내가 그 말을 듣고 이스라엘을 보내겠느냐 ? 나는 여호와를 알지 못하니 이스라엘도 보내지 아니하리라' ");
INSERT INTO kor_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","그들이 가로되 `히브리인의 하나님이 우리에게 나타나셨은즉 우리가 사흘길쯤 광야에 가서 우리 하나님 여호와께 희생을 드리려 하오니 가기를 허락하소서 여호와께서 온역이나 칼로 우리를 치실까 두려워하나이다' ");
INSERT INTO kor_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","애굽왕이 그들에게 이르되 `모세와 아론아 ! 너희가 어찌하여 백성으로 역사를 쉬게 하느냐 ? 가서 너희의 역사나 하라' ");
INSERT INTO kor_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","또 가로되 `이제 나라에 이 백성이 많거늘 너희가 그들로 역사를 쉬게 하는도다' 하고 ");
INSERT INTO kor_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","바로가 당일에 백성의 간역자들과 패장들에게 명하여 가로되 ");
INSERT INTO kor_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","`너희는 백성에게 다시는 벽돌 소용의 짚을 전과 같이 주지 말고 그들로 가서 스스로 줍게 하라 ");
INSERT INTO kor_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","또 그들의 전에 만든 벽돌 수효대로 그들로 만들게 하고 감하지 말라 그들이 게으르므로 소리질러 이르기를 우리가 가서 우리 하나님께 희생을 드리자 하나니 ");
INSERT INTO kor_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","그 사람들의 고역을 무겁게 함으로 수고롭게 하여 그들로 거짓말을 듣지 않게 하라' ");
INSERT INTO kor_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","간역자들과 패장들이 나아가 백성에게 일러 가로되 `바로의 말씀에 내가 너희에게 짚을 주지 아니하리니 ");
INSERT INTO kor_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","너희는 짚을 얻을 곳으로 가서 주우라 너희 일은 조금도 감하지 아니하리라' 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","백성이 애굽 온 땅에 흩어져 곡초 그루터기를 거두어다가 짚을 대신하니 ");
INSERT INTO kor_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","간역자들이 그들을 독촉하여 가로되 `너희는 짚이 있을 때와 같이 당일 일을 당일에 마치라' 하며 ");
INSERT INTO kor_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","바로의 간역자들이 자기들의 세운바 이스라엘 자손의 패장들을 때리며 가로되 '너희가 어찌하여 어제와 오늘에 만드는 벽돌의 수효를 전과 같이 채우지 아니하였느냐 ?' 하니라 ");
INSERT INTO kor_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","이스라엘 자손의 패장들이 가서 바로에게 호소하여 가로되 `왕은 어찌하여 종들에게 이같이 하시나이까 ? ");
INSERT INTO kor_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","종들에게 짚을 주지 아니하고 그들이 우리더러 벽돌을 만들라 하나이다 종들이 매를 맞으오니 이는 왕의 백성의 허물이니이다' ");
INSERT INTO kor_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","바로가 가로되 `너희가 게으르다, 게으르다 그러므로 너희가 이르기를 우리가 가서 여호와께 희생을 드리자 하는도다 ");
INSERT INTO kor_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","이제 가서 일하라 짚은 너희에게 주지 않을지라도 너희가 벽돌을 여수히 바칠지니라' ");
INSERT INTO kor_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","이스라엘 자손의 패장들이 너희의 매일 만드는 벽돌을 조금도 감하지 못하리라 함을 듣고 화가 몸에 미친 줄 알고 ");
INSERT INTO kor_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","그들이 바로를 떠나 나올 때에 모세와 아론이 길에 선 것을 만나 ");
INSERT INTO kor_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","그들에게 이르되 `너희가 우리로 바로의 눈과 그 신하의 눈에 미운 물건이 되게 하고 그들의 손에 칼을 주어 우리를 죽이게 하는도다 여호와는 너희를 감찰하시고 판단하시기를 원하노라' ");
INSERT INTO kor_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","모세가 여호와께 돌아와서 고하되 `주여, 어찌하여 이 백성으로 학대를 당케 하셨나이까 ? 어찌하여 나를 보내셨나이까 ? ");
INSERT INTO kor_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","내가 바로에게 와서 주의 이름으로 말함으로부터 그가 이 백성을 더 학대하며 주께서도 주의 백성을 구원치 아니하시나이다' ");
INSERT INTO kor_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","여호와께서 모세에게 이르시되 이제 내가 바로에게 하는 일을 네가 보리라 강한 손을 더하므로 바로가 그들을 보내리라 강한 손을 더하므로 바로가 그들을 그 땅에서 쫓아내리라 ");
INSERT INTO kor_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","하나님이 모세에게 말씀하여 가라사대 나는 여호와로라 ! ");
INSERT INTO kor_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","내가 아브라함과 이삭과 야곱에게 전능의 하나님으로 나타났으나 나의 이름을 여호와로는 그들에게 알리지 아니하였고 ");
INSERT INTO kor_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","가나안 땅 곧 그들의 우거하는 땅을 주기로 그들과 언약하였더니 ");
INSERT INTO kor_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","이제 애굽 사람이 종을 삼은 이스라엘 자손의 신음을 듣고 나의 언약을 기억하노라 ");
INSERT INTO kor_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","그러므로 이스라엘 자손에게 말하기를 나는 여호와라 내가 애굽 사람의 무거운 짐 밑에서 너희를 빼어 내며 그 고역에서 너희를 건지며 편 팔과 큰 재앙으로 너희를 구속하여 ");
INSERT INTO kor_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","너희로 내 백성을 삼고 나는 너희 하나님이 되리니 나는 애굽 사람의 무거운 짐 밑에서 너희를 빼어낸 너희 하나님 여호와인줄 너희가 알지라 ");
INSERT INTO kor_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","내가 아브라함과 이삭과 야곱에게 주기로 맹세한 땅으로 너희를 인도하고 그 땅을 너희에게 주어 기업을 삼게 하리라 나는 여호와로라 하셨다 하라 ");
INSERT INTO kor_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","모세가 이와 같이 이스라엘 자손에게 전하나 그들이 마음의 상함과 역사의 혹독함을 인하여 모세를 듣지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","들어가서 애굽왕 바로에게 말하여 이스라엘 자손을 그 땅에서 내어 보내게 하라 ");
INSERT INTO kor_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","모세가 여호와 앞에 고하여 가로되 `이스라엘 자손도 나를 듣지 아니하였거든 바로가 어찌 들으리이까 ? 나는 입이 둔한 자니이다' ");
INSERT INTO kor_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","여호와께서 모세와 아론에게 말씀하사 그들로 이스라엘 자손과 애굽 왕 바로에게 명을 전하고 이스라엘 자손을 애굽 땅에서 인도하여 내게 하시니라 ");
INSERT INTO kor_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","그 조상을 따라 집의 어른은 이러하니라 이스라엘의 장자 르우벤의 아들 하녹과, 발루와, 헤스론과, 갈미니 이들은 르우벤의 족장이요 ");
INSERT INTO kor_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","시므온의 아들 여무엘과, 야민과, 오핫과, 야긴과, 소할과, 가나안 여인의 소생 사울이니 이들은 시므온의 족장이요 ");
INSERT INTO kor_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","레위의 아들들의 이름은 그 연치대로 이러하니 게르손과, 고핫과, 므라리요 레위의 수는 일백 삼십 칠세이었으며 ");
INSERT INTO kor_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","게르손의 아들들은 그 가족대로 립니와, 시므이요 ");
INSERT INTO kor_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","고핫의 아들들은 아므람과, 이스할과, 헤브론과, 웃시엘이요, 고핫의 수는 일백 삼십 삼세이었으며 ");
INSERT INTO kor_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","므라리의 아들은 마흘리와, 무시니 이들은 그 연치대로 레위의 족장이요 ");
INSERT INTO kor_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","아므람이 그 아비의 누이 요게벳을 아내로 취하였고 그가 아론과 모세를 낳았으며 아므람의 수는 일백 삼십 칠세이었으며 ");
INSERT INTO kor_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","이스할의 아들은 고라와, 네벡과, 시그리요 ");
INSERT INTO kor_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","웃시엘의 아들은 미사엘과, 엘사반과, 시드리요 ");
INSERT INTO kor_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","아론이 암미나답의 딸 나손의 누이 엘리세바를 아내로 취하였고 그가 나답과, 아비후와, 엘르아살과, 이다말을 낳았으며 ");
INSERT INTO kor_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","고라의 아들은 앗실과, 엘가나와, 아비아삽이니 이들은 고라 사람의 족장이요 ");
INSERT INTO kor_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","아론의 아들 엘르아살이 부디엘의 딸 중에서 아내를 취하였고 그가 비느하스를 낳았으니 이들은 레위 사람의 조상을 따라 가족의 어른들이라 ");
INSERT INTO kor_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","이스라엘 자손을 그 군대대로 애굽 땅에서 인도하라 하신 여호와의 명을 받은 자는 이 아론과 모세요 ");
INSERT INTO kor_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","애굽 왕 바로에게 이스라엘 자손을 애굽에서 내어 보내라 말한 자도 이 모세와 아론이었더라 ");
INSERT INTO kor_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","여호와께서 애굽 땅에서 모세에게 말씀하시던 날에 ");
INSERT INTO kor_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","여호와께서 모세에게 일러 가라사대 나는 여호와라 내가 네게 이르는 바를 너는 애굽 왕 바로에게 다 고하라 ");
INSERT INTO kor_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","모세가 여호와 앞에서 고하되 `나는 입이 둔한 자이오니 바로가 어찌 나를 들으리이까 ?' ");
INSERT INTO kor_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","여호와께서 모세에게 이르시되 볼지어다 ! 내가 너로 바로에게 신이 되게 하였은즉 네 형 아론은 네 대언자가 되리니 ");
INSERT INTO kor_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","내가 네게 명한 바를 너는 네 형 아론에게 말하고 그는 바로에게 말하여 그로 이스라엘 자손을 그 땅에서 보내게 할지니라 ");
INSERT INTO kor_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","내가 바로의 마음을 강퍅케 하고 나의 표징과 나의 이적을 애굽땅에 많이 행하리라마는 ");
INSERT INTO kor_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","바로가 너희를 듣지 아니할터인즉 내가 내 손을 애굽에 더하여 여러 큰 재앙을 내리고 내 군대 내 백성 이스라엘 자손을 그 땅에서 인도하여 낼지라 ");
INSERT INTO kor_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","내가 내 손을 애굽 위에 펴서 이스라엘 자손을 그 땅에서 인도하여 낼 때에야 애굽 사람이 나를 여호와인 줄 알리라 하시매 ");
INSERT INTO kor_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","모세와 아론이 여호와께서 자기들에게 명하신대로 곧 그대로 행하였더라 ");
INSERT INTO kor_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","그들이 바로에게 말할 때에 모세는 팔십세이었고 아론은 팔십 삼세이었더라 ");
INSERT INTO kor_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","여호와께서 모세와 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","바로가 너희에게 이르기를 너희는 이적을 보이라 하거든 너는 아론에게 명하기를 너의 지팡이를 가져 바로 앞에 던지라 하라 그것이 뱀이 되리라 ");
INSERT INTO kor_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","모세와 아론이 바로에게 가서 여호와의 명하신대로 행하여 아론이 바로와 그 신하 앞에 지팡이를 던졌더니 뱀이 된지라 ");
INSERT INTO kor_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","바로도 박사와 박수를 부르매 그 애굽 술객들도 그 술법으로 그와 같이 행하되 ");
INSERT INTO kor_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","각 사람이 지팡이를 던지매 뱀이 되었으나 아론의 지팡이가 그들의 지팡이를 삼키니라 ");
INSERT INTO kor_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","그러나 바로의 마음이 강퍅하여 그들을 듣지 아니하니 여호와의 말씀과 같더라 ");
INSERT INTO kor_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","여호와께서 모세에게 이르시되 바로의 마음이 완강하여 백성 보내기를 거절하는도다 ");
INSERT INTO kor_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","아침에 너는 바로에게로 가라 그가 물로 나오리니 너는 하숫가에 서서 그를 맞으며 그 뱀 되었던 지팡이를 손에 잡고 ");
INSERT INTO kor_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","그에게 이르기를 히브리 사람의 하나님 여호와께서 나를 왕에게 보내어 이르시되 내 백성을 보내라 그들이 광야에서 나를 섬길 것이니라 하였으나 이제까지 네가 듣지 아니하도다 ");
INSERT INTO kor_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","여호와가 이같이 이르노니 네가 이로 인하여 나를 여호와인줄 알리라 하셨느니라 볼지어다 ! 내가 내 손의 지팡이로 하수를 치면 그것이 피로 변하고 ");
INSERT INTO kor_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","하수의 고기가 죽고 그 물에서는 악취가 나리니 애굽 사람들이 그 물 마시기를 싫어하리라 하라 ");
INSERT INTO kor_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","여호와께서 또 모세에게 이르시되 아론에게 명하기를 네 지팡이를 잡고 네 팔을 애굽의 물들과 하수들과 운하와 못과 모든 호수위에 펴라 하라 그것들이 피가 되리니 애굽 온 땅에와, 나무 그릇에와, 돌 그릇에 모두 피가 있으리라 ");
INSERT INTO kor_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","모세와 아론이 여호와의 명하신대로 행하여 바로와 그 신하의 목전에서 지팡이를 들어 하수를 치니 그 물이 다 피로 변하고 ");
INSERT INTO kor_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","하수의 고기가 죽고 그 물에서는 악취가 나니 애굽 사람들이 하수물을 마시지 못하며 애굽 온 땅에는 피가 있으나 ");
INSERT INTO kor_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","애굽 술객들도 자기 술법으로 그와 같이 행하므로 바로의 마음이 강퍅하여 그들을 듣지 아니하니 여호와의 말씀과 같더라 ");
INSERT INTO kor_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","바로가 돌이켜 궁으로 들어가고 그 일에도 관념하지 아니하였고 ");
INSERT INTO kor_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","애굽 사람들은 하수 물을 마실 수 없으므로 하숫가를 두루 파서 마실 물을 구하였더라 ");
INSERT INTO kor_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","여호와께서 하수를 치신 후 칠일이 지나니라 ");
INSERT INTO kor_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","여호와께서 모세에게 이르시되 너는 바로에게 가서 그에게 이르기를 여호와의 말씀에 내 백성을 보내라 그들이 나를 섬길 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","네가 만일 보내기를 거절하면 내가 개구리로 너의 온 지경을 칠지라 ");
INSERT INTO kor_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","개구리가 하수에서 무수히 생기고 올라와서 네 궁에와, 네 침실에와, 네 침상 위에와, 네 신하의 집에와, 네 백성에게와, 네 화덕에와, 네 떡반죽 그릇에 들어갈지며 ");
INSERT INTO kor_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","개구리가 네게와, 네 백성에게와, 네 모든 신하에게 오르리라 하셨다 하라 ");
INSERT INTO kor_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","여호와께서 모세에게 이르시되 아론에게 명하기를 네 지팡이를 잡고 네 팔을 강들과 운하들과 못 위에 펴서 개구리로 애굽 땅에올라오게 하라 할지니라 ");
INSERT INTO kor_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","아론이 팔을 애굽 물들 위에 펴매 개구리가 올라와서 애굽 땅에 덮이니 ");
INSERT INTO kor_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","술객들도 자기 술법대로 이와 같이 하여 개구리로 애굽 땅에 올라오게 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","바로가 모세와 아론을 불러 이르되 `여호와께 구하여 개구리를 나와 내 백성에게서 떠나게 하라 내가 이 백성을 보내리니 그들이 여호와께 희생을 드릴 것이니라' ");
INSERT INTO kor_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","모세가 바로에게 이르되 `내가 왕과 왕의 신하와 왕의 백성을 위하여 어느 때에 구하여 이 개구리를 왕과 왕궁에서 끊어서 하수에만 있게 하오리이까 ? 내게 보이소서' ");
INSERT INTO kor_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","그가 가로되 `내일이니라' 모세가 가로되 `왕의 말씀대로 하여 왕으로 우리 하나님 여호와와 같은 이가 없는 줄을 알게 하리니 ");
INSERT INTO kor_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","개구리가 왕과, 왕궁과, 왕의 신하와, 왕의 백성을 떠나서 하수에만 있으리이다' 하고 ");
INSERT INTO kor_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","모세와 아론이 바로를 떠나 나가서 바로에게 내리신 개구리에 대하여 모세가 여호와께 간구하매 ");
INSERT INTO kor_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","여호와께서 모세의 말대로 하시니 개구리가 집에서,마당에서,밭에서 나와서 죽은지라 ");
INSERT INTO kor_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","사람들이 모아 무더기로 쌓으니 땅에서 악취가 나더라 ");
INSERT INTO kor_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","그러나 바로가 숨을 통할 수 있음을 볼 때에 그 마음을 완강케 하여 그들을 듣지 아니하였으니 여호와의 말씀과 같더라 ");
INSERT INTO kor_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","여호와께서 모세에게 이르시되 아론에게 명하기를 네 지팡이를 들어 땅의 티끌을 치라 하라 그것이 애굽 온 땅에서 이가 되리라 ");
INSERT INTO kor_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","그들이 그대로 행할쌔 아론이 지팡이를 잡고 손을 들어 땅의 티끌을 치매 애굽 온 땅의 티끌이 다 이가 되어 사람과 생축에게 오르니 ");
INSERT INTO kor_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","술객들이 자기 술법으로 이같이 행하여 이를 내려 하였으나 못하였고 이는 사람과 생축에게 있은지라 ");
INSERT INTO kor_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","술객이 바로에게 고하되 `이는 하나님의 권능이니이다 !' 하나 바로의 마음이 강퍅케 되어 그들을 듣지 아니하였으니 여호와의 말씀과 같더라 ");
INSERT INTO kor_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","여호와께서 모세에게 이르시되 아침에 일찌기 일어나 바로 앞에 서라 그가 물로 나오리니 그에게 이르기를 여호와의 말씀에 내 백성을 보내라 그들이 나를 섬길 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","네가 만일 내 백성을 보내지 아니하면 내가 너와 네 신하와 네 백성을 보내지 아니하면 내가 너와 네 신하와 네 백성과 네 집들에 파리떼를 보내리니 애굽 사람의 집집에 파리 떼가 가득할 것이며 그들의 거하는 땅에도 그러하리라 ");
INSERT INTO kor_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","그 날에 내가 내 백성의 거하는 고센 땅을 구별하여 그 곳에는 파리떼가 없게 하리니 이로 말미암아 나는 세상 중의 여호와인 줄을 네가 알게 될 것이라 ");
INSERT INTO kor_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","내가 내 백성과 네 백성 사이에 구별을 두리니 내일 이 표징이 있으리라 하셨다 하라 하시고 ");
INSERT INTO kor_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","여호와께서 그와 같이 하시니 무수한 파리떼가 바로의 궁에와, 그 신하의 집에와, 애굽 전국에 이르니 파리떼로 인하여 땅이 해를 받더라 ");
INSERT INTO kor_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","바로가 모세와 아론을 불러 이르되 `너희는 가서 이 땅에서 너희 하나님께 희생을 드리라' ");
INSERT INTO kor_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","모세가 가로되 `그리함은 불가하니이다 우리가 우리 하나님 여호와께 희생을 드리는 것은 애굽 사람의 미워하는 바이온즉 우리가 만일 애굽 사람의 목전에서 희생을 드리면 그들이 그것을 미워하여 우리를 돌로 치지 아니하리이까 ? ");
INSERT INTO kor_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","우리가 사흘길쯤 광야로 들어가서 우리 하나님 여호와께 희생을 드리되 우리에게 명하시는대로 하려하나이다' ");
INSERT INTO kor_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","바로가 가로되 `내가 너희를 보내리니 너희가 너희 하나님 여호와께 광야에서 희생을 드릴 것이나 너무 멀리는 가지 말라 그런즉 너희는 나를 위하여 기도하라' ");
INSERT INTO kor_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","모세가 가로되 `내가 왕을 떠나 가서 여호와께 기도하리니 내일이면 파리떼가 바로와 바로의 신하와 바로의 백성을 떠나려니와 바로는 이 백성을 보내어 여호와께 희생을 드리는 일에 다시 거짓을 행치 마소서' 하고 ");
INSERT INTO kor_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","모세가 바로를 떠나 나와서 여호와께 기도하니 ");
INSERT INTO kor_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","여호와께서 모세의 말대로 하사 파리를 바로와 그 신하와 그 백성에게 몰수히 떠나게 하시니라 ");
INSERT INTO kor_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","그러나 바로가 이 때에도 마음을 완강케 하여 백성을 보내지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","여호와께서 모세에게 이르시되 바로에게 들어가서 그에게 이르라 히브리 사람의 하나님 여호와께서 말씀하시기를 내 백성을 보내라 그들이 나를 섬길 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","네가 만일 그들 보내기를 거절하고 억지로 잡아 두면 ");
INSERT INTO kor_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","여호와의 손이 들에 있는 네 생축 곧 말과 나귀와 약대와 우양에게 더하리니 심한 악질이 있을 것이며 ");
INSERT INTO kor_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","여호와가 이스라엘의 생축과 애굽의 생축을 구별하리니 이스라엘 자손에 속한 것은 하나도 죽지 아니하리라 하셨다 하라 하시고 ");
INSERT INTO kor_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","여호와께서 기한을 정하여 가라사대 여호와가 내일 이 땅에서 이 일을 행하리라 하시더니 ");
INSERT INTO kor_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","이튿날에 여호와께서 이 일을 행하시니 애굽의 모든 생축은 죽었으나 이스라엘 자손의 생축은 하나도 죽지 아니한지라 ");
INSERT INTO kor_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","바로가 보내어 본즉 이스라엘의 생축은 하나도 죽지 아니하였더라 그러나 바로의 마음이 완강하여 백성을 보내지 아니하니라 ");
INSERT INTO kor_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","여호와께서 모세와 아론에게 이르시되 너희는 풀무의 재 두 움큼을 가지고 모세가 바로의 목전에서 하늘을 향하여 날리라 ");
INSERT INTO kor_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","그 재가 애굽 온 땅의 티끌이 되어 애굽 온 땅의 사람과 짐승에게 붙어서 독종이 발하리라 ");
INSERT INTO kor_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","그들이 풀무의 재를 가지고 바로 앞에 서서 모세가 하늘을 향하여 날리니 사람과 짐승에게 붙어 독종이 발하고 ");
INSERT INTO kor_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","술객도 독종으로 인하여 모세 앞에 서지 못하니 독종이 술객들로 부터 애굽 모든 사람에게 발하였음이라 ");
INSERT INTO kor_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","그러나 여호와께서 바로의 마음을 강퍅케 하셨으므로 그들을 듣지 아니하였으니 여호와께서 모세에게 말씀하심과 같더라 ");
INSERT INTO kor_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","여호와께서 모세에게 이르시되 아침에 일찌기 일어나 바로 앞에 서서 그에게 이르기를 히브리 사람의 하나님 여호와의 말씀에 내 백성을 보내라 그들이 나를 섬길 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","내가 이번에는 모든 재앙을 네 마음과 네 신하와 네 백성에게 내려 너로 온 천하에 나와 같은 자가 없음을 알게 하리라 ");
INSERT INTO kor_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","내가 손을 펴서 온역으로 너와 네 백성을 쳤더면 네가 세상에서 끊어졌을 것이나 ");
INSERT INTO kor_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","네가 너를 세웠음은 나의 능력을 네게 보이고 내 이름이 온 천하에 전파되게 하려 하였음이니라 ");
INSERT INTO kor_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","네가 여전히 내 백성 앞에 자고하고 그들을 보내지 아니하느냐 ? ");
INSERT INTO kor_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","내일 이맘때면 내가 중한 우박을 내리리니 애굽 개국 이래로 그 같은 것이 있지 않던 것이리라 ");
INSERT INTO kor_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","이제 보내어 네 생축과 네 들에 있는 것을 다 모으라 사람이나 짐승이나 무릇 들에 있어서 집에 돌아오지 않은 자에게는 우박이그 위에 내리리니 그것들이 죽으리라 하셨다 하라 하시니라 ");
INSERT INTO kor_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","바로의 신하 중에 여호와의 말씀을 두려워하는 자들은 그 종들과 생축을 집으로 피하여 들였으나 ");
INSERT INTO kor_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","여호와의 말씀을 마음에 두지 아니하는 자는 그 종들과 생축을 들에 그대로 두었더라 ");
INSERT INTO kor_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","여호와께서 모세에게 이르시되 너는 하늘을 향하여 손을 들어 애굽 전국에 우박이 애굽땅의 사람과 짐승과 밭의 모든 채소에 내리게 하라 ");
INSERT INTO kor_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","모세가 하늘을 향하여 지팡이를 들매 여호와께서 뇌성과 우박을 보내시고 불을 내려 땅에 달리게 하시니라 여호와께서 우박을 애굽 땅에 내리시매 ");
INSERT INTO kor_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","우박의 내림과 불덩이가 우박에 섞여 내림이 심히 맹렬하니 애굽 전국에 그 개국 이래로 그 같은 것이 없던 것이라 ");
INSERT INTO kor_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","우박이 애굽 온 땅에서 사람과 짐승을 무론하고 무릇 밭에 있는 것을 쳤으며 우박이 또 밭의 모든 채소를 치고 들의 모든 나무를 꺽었으되 ");
INSERT INTO kor_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","이스라엘 자손의 거한 고센 땅에는 우박이 없었더라 ");
INSERT INTO kor_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","바로가 사람을 보내어 모세와 아론을 불러 그들에게 이르되 `이번은 내가 범죄하였노라 여호와는 의로우시고 나와 나의 백성은 악하도다 ");
INSERT INTO kor_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","여호와께 구하여 이 뇌성과 우박을 그만 그치게 하라 내가 너희를 보내리니 너희가 다시는 머물지 아니하리라' ");
INSERT INTO kor_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","모세가 그에게 이르되 `내가 성에서 나가자 곧 내 손을 여호와를 향하여 펴리니 그리하면 뇌성이 그치고 우박이 다시 있지 않을지라 세상이 여호와께 속한 줄을 왕이 알리이다 ");
INSERT INTO kor_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","그러나 왕과 왕의 신하들이 여호와 하나님을 아직도 두려워 아니할 줄을 내가 아나이다' ");
INSERT INTO kor_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","때에 보리는 이삭이 나왔고 삼은 꽃이 피었으므로 삼과 보리가 상하였으나 ");
INSERT INTO kor_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","그러나 밀과 나맥은 자라지 아니한고로 상하지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","모세가 바로를 떠나 성에서 나가서 여호와를 향하여 손을 펴매 뇌성과 우박이 그치고 비가 땅에 내리지 아니하니라 ");
INSERT INTO kor_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","바로가 비와 우박과 뇌성의 그친 것을 볼 때에 다시 범죄하여 마음을 완강케 하니 그와 그 신하가 일반이라 ");
INSERT INTO kor_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","바로의 마음이 강퍅하여 이스라엘 자손을 보내지 아니하였으니 여호와께서 모세에게 말씀하심과 같더라 ");
INSERT INTO kor_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","여호와께서 모세에게 이르시되 바로에게로 들어가라 내가 그의 마음과 그 신하들의 마음을 완강케 함은 나의 표징을 그들 중에 보이기 위함이며 ");
INSERT INTO kor_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","너로 내가 애굽에서 행한 일들 곧 내가 그 가운데서 행한 표징을 네 아들과 네 자손의 귀에 전하게 하려 함이라 너희가 나를 여호와인줄 알리라 ");
INSERT INTO kor_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","모세와 아론이 바로에게 들어가서 그에게 이르되 `히브리 사람의 하나님 여호와께서 말씀하시기를 네가 어느 때까지 내 앞에 겸비치 아니하겠느냐 ? 내 백성을 보내라 ! 그들이 나를 섬길 것이라 ");
INSERT INTO kor_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","네가 만일 내 백성 보내기를 거절하면 내일 내가 메뚜기로 네 경내에 들어가게 하리니 ");
INSERT INTO kor_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","메뚜기가 지면을 덮어서 사람이 땅을 볼 수 없을 것이라 메뚜기가 네게 남은 그것 곧 우박을 면하고 남은 것을 먹으며 들에 너를 위하여 자라는 모든 나무를 먹을 것이며 ");
INSERT INTO kor_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","또 네 집들과 네 모든 신하의 집들과 모든 애굽 사람의 집들에 가득하리니 이는 네 아비와 네 조상이 세상에 있어 옴으로 오늘까지 보지 못하였던 것이리라 하셨다' 하고 돌이켜 바로에게서 나오니 ");
INSERT INTO kor_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","바로의 신하들이 그에게 고하되 `어느 때까지 이 사람이 우리의 함정이 되리이까 ? 그 사람들을 보내어 그 하나님 여호와를 섬기게 하소서 ! 왕은 아직도 애굽이 망한 줄을 알지 못하시나이까 ?' 하고 ");
INSERT INTO kor_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","모세와 아론을 바로에게로 다시 데려오니 바로가 그들에게 이르되 가서 너희 하나님 여호와를 섬기라 ! 갈 자는 누구 누구뇨 ? ");
INSERT INTO kor_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","모세가 가로되 `우리가 여호와 앞에 절기를 지킬 것인즉 우리가 남녀 노소와 우양을 데리고 가겠나이다' ");
INSERT INTO kor_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","바로가 그들에게 이르되 `내가 너희와 너희 어린 것들을 보내면 여호와를 너희와 함께하게 함과 일반이니라 삼갈지어다 너희 경영이 악하니라 ");
INSERT INTO kor_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","그는 불가하니 너희 남정만 가서 여호와를 섬기라 이것이 너희의 구하는 바니라' 이에 그들이 바로 앞에서 쫓겨나니라 ");
INSERT INTO kor_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","여호와께서 모세에게 이르시되 네 손을 애굽 땅 위에 들어 메뚜기로 애굽 땅에 올라와서 우박에 상하지 아니한 밭의 모든 채소를 먹게 하라 ");
INSERT INTO kor_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","모세가 애굽 땅 위에 그 지팡이를 들매 여호와께서 동풍을 일으켜 온 낮과 온 밤에 불게 하시니 아침에 미쳐 동풍이 메뚜기를 불어 들인지라 ");
INSERT INTO kor_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","메뚜기가 애굽 온 땅에 이르러 그 사방에 내리매 그 해가 심하니 이런 메뚜기는 전에도 없었고 후에도 없을러라 ");
INSERT INTO kor_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","메뚜기가 온 지면에 덮여 날으매 땅이 어둡게 되었고 메뚜기가 우박에 상하지 아니한 밭의 채소와 나무 열매를 다 먹었으므로 애굽 전경에 나무나 밭의 채소나 푸른 것은 남지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","바로가 모세와 아론을 급히 불러서 이르되 `내가 너희 하나님 여호와와 너희에게 득죄하였으니 ");
INSERT INTO kor_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","청컨대 나의 죄를 이번만 용서하고 너희 하나님 여호와께 구하여 이 죽음만을 내게서 떠나게 하라' ");
INSERT INTO kor_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","그가 바로에게서 나가서 여호와께 구하매 ");
INSERT INTO kor_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","여호와께서 돌이켜 강렬한 서풍이 불게 하사 메뚜기를 홍해에 몰아 넣으시니 애굽 온 지경에 메뚜기가 하나도 남지 아니하니라 ");
INSERT INTO kor_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","그러나 여호와께서 바로의 마음을 강퍅케 하셨으므로 이스라엘 자손을 보내지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","여호와께서 모세에게 이르시되 하늘을 향하여 네 손을 들어서 애굽 땅위에 흑암이 있게 하라 곧 더듬을 만한 흑암이리라 ");
INSERT INTO kor_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","모세가 하늘을 향하여 손을 들매 캄캄한 흑암이 삼일 동안 애굽온 땅에 있어서 ");
INSERT INTO kor_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","그 동안은 사람 사람이 서로 볼 수 없으며 자기 처소에서 일어나는 자가 없으되 이스라엘 자손의 거하는 곳에는 광명이 있었더라 ");
INSERT INTO kor_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","바로가 모세를 불러서 이르되 `너희는 가서 여호와를 섬기되 너희 양과 소는 머물러두고 너희 어린 것은 너희와 함께 갈지니라' ");
INSERT INTO kor_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","모세가 가로되 `왕이라도 우리 하나님 여호와께 드릴 희생과 번제물을 우리에게 주어야 하겠고 ");
INSERT INTO kor_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","우리의 생축도 우리와 함께 가고 한 마리도 남길 수 없으니 이는 우리가 그 중에서 취하여 우리 하나님 여호와를 섬길 것임이며 또 우리가 거기 이르기까지는 어떤 것으로 여호와를 섬기는지 알지 못함이니이다' 하나 ");
INSERT INTO kor_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","여호와께서 바로의 마음을 강퍅케 하셨으므로 그들을 보내기를 즐겨 아니하고 ");
INSERT INTO kor_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","모세에게 이르되 `너는 나를 떠나가고 스스로 삼가 다시 내 얼굴을 보지 말라 내 얼굴을 보는 날에는 죽으리라' ");
INSERT INTO kor_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","모세가 가로되 `왕의 말씀이 옳으니이다 ! 내가 다시는 왕의 얼굴을 보지 아니하리이다 !' ");
INSERT INTO kor_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","여호와께서 모세에게 이르시기를 내가 이제 한 가지 재앙을 바로와 애굽에 내린 후에야 그가 너희를 여기서 보낼지라 그가 너희를 보낼 때에는 여기서 정녕 다 쫓아 내리니 ");
INSERT INTO kor_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","백성에게 말하여 남녀로 각기 이웃들에게 은금 패물을 구하게 하라 하시더니 ");
INSERT INTO kor_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","여호와께서 그 백성으로 애굽 사람의 은혜를 받게 하셨고 또 그 사람 모세는 애굽국에서 바로의 신하와 백성에게 심히 크게 뵈었더라 ");
INSERT INTO kor_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","모세가 바로에게 이르되 `여호와께서 이같이 말씀하시기를 밤중에 내가 애굽 가운데로 들어가리니 ");
INSERT INTO kor_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","애굽 가운데 처음 난 것은 위에 앉은 바로의 장자로부터 맷돌 뒤에 있는 여종의 장자까지와 모든 생축의 처음 난 것이 죽을지라 ");
INSERT INTO kor_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","애굽 전국에 전무후무한 큰 곡성이 있으리라 ");
INSERT INTO kor_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","그러나 이스라엘 자손에게는 사람에게나 짐승에게나 개도 그 혀를 움직이지 않으리니 여호와가 애굽 사람과 이스라엘 사이에 구별하는 줄을 너희가 알리라' 하셨나니 ");
INSERT INTO kor_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","왕이 이 모든 신하가 내게 내려와서 내게 절하며 이르기를 `너와 너를 좇는 온 백성은 나가라 한 후에야 내가 나가리라' 하고 심히 노하여 바로에게서 나오니라 ");
INSERT INTO kor_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","여호와께서 모세에게 이르시기를 바로가 너희를 듣지 아니할찌라 그러므로 내가 애굽 땅에서 나의 기사를 더하리라 하셨고 ");
INSERT INTO kor_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","모세와 아론이 이 모든 기사를 바로 앞에서 행하였으나 여호와께서 바로의 마음을 강퍅케 하셨으므로 그가 이스라엘 자손을 그 나라에서 보내지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","여호와께서 애굽 땅에서 모세와 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","이 달로 너희에게 달의 시작 곧 해의 첫 달이 되게 하고 ");
INSERT INTO kor_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","너희는 이스라엘 회중에게 고하여 이르라 이 달 열흘에 너희 매인이 어린 양을 취할지니 각 가족대로 그 식구를 위하여 어린 양을 취하되 ");
INSERT INTO kor_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","그 어린 양에 대하여 식구가 너무 적으면 그 집의 이웃과 함께 수를 따라서 하나를 취하며 각 사람의 식량을 따라서 너희 어린 양을 계산할 것이며 ");
INSERT INTO kor_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","너희 어린 양은 흠 없고 일년 된 수컷으로 하되 양이나 염소 중에서 취하고 ");
INSERT INTO kor_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","이달 십사일까지 간직하였다가 해질 때에 이스라엘 회중이 그 양을 잡고 ");
INSERT INTO kor_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","양을 먹을 집 문 좌우 설주와 인방에 바르고 ");
INSERT INTO kor_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","그 밤에 그 고기를 불에 구워 무교병과 쓴 나물과 아울러 먹되 ");
INSERT INTO kor_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","날로나 물에 삶아서나 먹지 말고 그 머리와 정강이와 내장을 다 불에 구워 먹고 ");
INSERT INTO kor_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","아침까지 남겨 두지 말며 아침까지 남은 것은 곧 소화하라 ");
INSERT INTO kor_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","너희는 그것을 이렇게 먹을지니 허리에 띠를 띠고 발에 신을 신고 손에 지팡이를 잡고 급히 먹으라 ! 이것이 여호와의 유월절이니라 ! ");
INSERT INTO kor_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","내가 그 밤에 애굽 땅에 두루 다니며 사람과 짐승을 무론하고 애굽 나라 가운데 처음 난 것을 다 치고 애굽의 모든 신에게 벌을 내리리라 나는 여호와로라 ! ");
INSERT INTO kor_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","내가 애굽 땅을 칠 때에 그 피가 너희의 거하는 집에 있어서 너희를 위하여 표적이 될지라 내가 피를 볼때에 너희를 넘어가리니재앙이 너희에게 내려 멸하지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","너희는 이 날을 기념하여 여호와의 절기를 삼아 영원한 규례로 대대에 지킬지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","너희는 칠일동안 무교병을 먹을지니 그 첫날에 누룩을 너희 집에서 제하라 ! 무릇 첫날부터 칠일까지 유교병을 먹는 자는 이스라엘에서 끊쳐지리라 ");
INSERT INTO kor_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","너희에게 첫날에도 성회요 제 칠일에도 성회가 되리니 이 두 날에는 아무 일도 하지 말고 각인의 식물만 너희가 갖출 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","너희는 무교절을 지키라 ! 이 날에 내가 너희 군대를 애굽 땅에서 인도하여 내었음이니라 그러므로 너희가 영원한 규례를 삼아 이 날을 대대로 지킬지라 ! ");
INSERT INTO kor_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","정월에 그 달 십사일 저녁부터 이십 일일 저녁까지 너희는 무교병을 먹을 것이요 ");
INSERT INTO kor_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","칠일 동안은 누룩을 너희 집에 있지 않게 하라 무릇 유교물을 먹는 타국인이든지 본국에서 난 자든지 무론하고 이스라엘 회중에서 끊쳐지리니 ");
INSERT INTO kor_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","너희는 아무 유교물이든지 먹지 말고 너희 모든 유하는 곳에서 무교병을 먹을지니라 ");
INSERT INTO kor_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","모세가 이스라엘 모든 장로를 불러서 그들에게 이르되 `너희는 나가서 너희 가족대로 어린 양을 택하여 유월절 양으로 잡고 ");
INSERT INTO kor_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","너희는 우슬초 묶음을 취하여 그릇에 담은 피에 적시어서 그 피를 문 인방과 좌우 설주에 뿌리고 아침까지 한 사람도 자기 집 문밖에 나가지 말라 ");
INSERT INTO kor_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","여호와께서 애굽 사람을 치러 두루 다니실 때에 문 인방과 좌우설주의 피를 보시면 그 문을 넘으시고 멸하는 자로 너희 집에 들어가서 너희를 치지 못하게 하실 것임이니라 ");
INSERT INTO kor_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","너희는 이 일을 규례로 삼아 너희와 너희 자손이 영원히 지킬 것이니 ");
INSERT INTO kor_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","너희는 여호와께서 허락하신대로 너희에게 주시는 땅에 이를 때에 이 예식을 지킬 것이라 ");
INSERT INTO kor_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","이 후에 너희 자녀가 묻기를 이 예식이 무슨 뜻이냐 ? 하거든 ");
INSERT INTO kor_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","너희는 이르기를 이는 여호와의 유월절 제사라 여호와께서 애굽 사람을 치실 때에 애굽에 있는 이스라엘 자손의 집을 넘으사 우리의 집을 구원하셨느니라 하라' 하매 백성이 머리 숙여 경배하니라 ");
INSERT INTO kor_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","이스라엘 자손이 물러가서 그대로 행하되 여호와께서 모세와 아론에게 명하신 대로 행하니라 ");
INSERT INTO kor_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","밤중에 여호와께서 애굽 땅에서 모든 처음 난 것 곧 위에 앉은 바로의 장자로부터 옥에 갇힌 사람의 장자까지와 생축의 처음난 것을 다 치시매 ");
INSERT INTO kor_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","그 밤에 바로와 그 모든 신하와 모든 애굽 사람이 일어나고 애굽에 큰 호곡이 있었으니 이는 그 나라에 사망치 아니한 집이 하나도 없었음이었더라 ");
INSERT INTO kor_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","밤에 바로가 모세와 아론을 불러서 이르되 `너희와 이스라엘 자손은 일어나 내 백성 가운데서 떠나서 너희의 말대로 가서 여호와를 섬기며 ");
INSERT INTO kor_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","너희의 말대로 너희의 양도 소도 몰아가고 나를 위하여 축복하라' 하며 ");
INSERT INTO kor_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","애굽 사람들은 말하기를 `우리가 다 죽은 자가 되도다' 하고 백성을 재촉하여 그 지경에서 속히 보내려 하므로 ");
INSERT INTO kor_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","백성이 발교되지 못한 반죽 담은 그릇을 옷에 싸서 어깨에 메니라 ");
INSERT INTO kor_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","이스라엘 자손이 모세의 말대로 하여 애굽 사람에게 은금 패물과 의복을 구하매 ");
INSERT INTO kor_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","여호와께서 애굽 사람으로 백성에게 은혜를 입히게 하사 그들의 구하는대로 주게 하시므로 그들이 애굽 사람의 물품을 취하였더라 ");
INSERT INTO kor_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","이스라엘 자손이 라암셋에서 발행하여 숙곳에 이르니 유아 외에 보행하는 장정이 육십만 가량이요 ");
INSERT INTO kor_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","중다한 잡족과 양과 소와 심히 많은 생축이 그들과 함께 하였으며 ");
INSERT INTO kor_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","그들이 가지고 나온 발교되지 못한 반죽으로 무교병을 구웠으니 이는 그들이 애굽에서 쫓겨 남으로 지체할 수 없었음이며 아무 양식도 준비하지 못하였음이었더라 ");
INSERT INTO kor_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","이스라엘 자손이 애굽에 거주한지 사백 삼십년이라 ");
INSERT INTO kor_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","사백 삼십년이 마치는 그 날에 여호와의 군대가 다 애굽 땅에서 나왔은즉 ");
INSERT INTO kor_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","이 밤은 그들을 애굽 땅에서 인도하여 내심을 인하여 여호와 앞에 지킬 것이니 이는 여호와의 밤이라 이스라엘 자손이 다 대대로 지킬 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","여호와께서 모세와 아론에게 이르시되 유월절 규례가 이러하니라 이방 사람은 먹지 못할 것이나 ");
INSERT INTO kor_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","각 사람이 돈으로 산 종은 할례를 받은 후에 먹을 것이며 ");
INSERT INTO kor_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","거류인과 타국 품군은 먹지 못하리라 ");
INSERT INTO kor_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","한 집에서 먹되 그 고기를 조금도 집 밖으로 내지 말고 뼈도 꺾지 말지며 ");
INSERT INTO kor_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","이스라엘 회중이 다 이것을 지킬지니라 ");
INSERT INTO kor_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","너희와 함께 거하는 타국인이 여호와의 유월절을 지키고자 하거든 그 모든 남자는 할례를 받은 후에야 가까이하여 지킬지니 곧 그는 본토인과 같이 될 것이나 할례 받지 못한 자는 먹지 못할 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","본토인에게나 너희 중에 우거한 이방인에게나 이 법이 동일하니라 하셨으므로 ");
INSERT INTO kor_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","온 이스라엘 자손이 이와 같이 행하되 여호와께서 모세와 아론에게 명하신대로 행하였으며 ");
INSERT INTO kor_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","그 같은 날에 여호와께서 이스라엘 자손을 그 군대대로 애굽 땅에서 인도하여 내셨더라 ");
INSERT INTO kor_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","이스라엘 자손 중에 사람이나 짐승이나 무론하고 초태생은 다 거룩히 구별하여 내게 돌리라 이는 내 것이니라 ! 하시니라 ");
INSERT INTO kor_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","모세가 백성에게 이르되 `너희는 애굽에서 곧 종 되었던 집에서 나온 그 날을 기념하여 유교병을 먹지 말라 여호와께서 그 손의 권능으로 너희를 그 곳에서 인도하여 내셨음이니라 ");
INSERT INTO kor_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","아빕월 이 날에 너희가 나왔으니 ");
INSERT INTO kor_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","여호와께서 너를 인도하여 가나안 사람과, 헷 사람과, 아모리 사람과, 히위 사람과, 여부스 사람의 땅 곧 네게 주시려고 네 조상들에게 맹세하신바 젖과 꿀이 흐르는 땅에 이르게 하시거든 너는 이 달에 이 예식을 지켜 ");
INSERT INTO kor_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","칠일 동안 무교병을 먹고 제 칠일에는 여호와께 절기를 지키라 ");
INSERT INTO kor_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","칠일 동안에는 무교병을 먹고 유교병을 너희 곳에 있게 하지 말며 네 지경 안에서 누룩을 네게 보이지도 말게 하며 ");
INSERT INTO kor_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","너는 그 날에 네 아들에게 뵈어 이르기를 이 예식은 내가 애굽에서 나올 때에 여호와께서 나를 위하여 행하신 일을 인함이라 하고 ");
INSERT INTO kor_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","이것으로 네 손의 기호와 네 미간의 표를 삼고 여호와의 율법으로 네 입에 있게 하라 이는 여호와께서 능하신 손으로 너를 애굽에서 인도하여 내셨음이니 ");
INSERT INTO kor_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","연년이 기한에 이르러 이 규례를 지킬지니라 ");
INSERT INTO kor_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","여호와께서 너와 네 조상에게 맹세하신대로 너를 가나안 사람의 땅에 인도하시고 그 땅을 네게 주시거든 ");
INSERT INTO kor_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","너는 무릇 초태생과 네게 있는 생축의 초태생을 다 구별하여 여호와께 돌리라 수컷은 여호와의 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","나귀의 첫새끼는 다 어린 양으로 대속할 것이요 그렇게 아니하려면 그 목을 꺽을 것이며 너의 아들중 모든 장자 된 자는 다 대속할지니라 ");
INSERT INTO kor_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","장래에 네 아들이 네게 묻기를 이것이 어찜이냐 ? 하거든 너는 그에게 이르기를 여호와께서 그 손의 권능으로 우리를 애굽에서 곧 종이 되었던 집에서 인도하여 내실쌔 ");
INSERT INTO kor_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","그 때에 바로가 강퍅하여 우리를 보내지 아니하매 여호와께서 애굽 나라 가운데 처음 낳은 것까지 다 죽이신고로 초태생의 수컷은 다 여호와께 희생으로 드리고 우리 장자는 다 대속하나니 ");
INSERT INTO kor_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","이것으로 네 손의 기호와 네 미간의 표를 삼으라 여호와께서 그 손의 권능으로 우리를 애굽에서 인도하여 내셨음이니라 할지니라' ");
INSERT INTO kor_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","바로가 백성을 보낸 후에 블레셋 사람의 땅의 길은 가까울지라도 하나님이 그들을 그 길로 인도하지 아니하셨으니 이는 하나님이 말씀하시기를 이 백성이 전쟁을 보면 뉘우쳐 애굽으로 돌아갈까 하셨음이라 ");
INSERT INTO kor_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","그러므로 하나님이 홍해의 광야 길로 돌려 백성을 인도하시매 이스라엘 자손이 애굽 땅에서 항오를 지어 나올 때에 ");
INSERT INTO kor_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","모세가 요셉의 해골을 취하였으니 이는 요셉이 이스라엘 자손으로 단단히 맹세케 하여 이르기를 '하나님이 필연 너희를 권고하시리니 너희는 나의 해골을 여기서 가지고 나가라' 하였음이었더라 ");
INSERT INTO kor_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","그들이 숙곳에서 발행하여 광야 끝에 담에 장막을 치니 ");
INSERT INTO kor_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","여호와께서 그들 앞에 행하사 낮에는 구름 기둥으로 그들의 길을 인도하시고 밤에는 불기둥으로 그들에게 비취사 주야로 진행하게 하시니 ");
INSERT INTO kor_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","낮에는 구름 기둥,밤에는 불기둥이 백성 앞에서 떠나지 아니하니라 ");
INSERT INTO kor_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","이스라엘 자손을 명하여 돌쳐서 바다와 믹돌 사이의 비하히롯 앞 곧 바알스본 맞은편 바닷가에 장막을 치게 하라 ");
INSERT INTO kor_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","바로가 이스라엘 자손에 대하여 말하기를 `그들이 그 땅에서 아득하여 광야에 갇힌바 되었다 할지라' ");
INSERT INTO kor_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","내가 바로의 마음을 강퍅케 한즉 바로가 그들의 뒤를 따르리니 내가 그와 그 온 군대를 인하여 영광을 얻어 애굽 사람으로 나를 여호와인 줄 알게 하리라 하시매 무리가 그대로 행하니라 ");
INSERT INTO kor_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","혹이 백성의 도망한 것을 애굽 왕에게 고하매 바로와 그 신하들이 백성에 대하여 마음이 변하여 가로되 '우리가 어찌 이같이 하여 이스라엘을 우리를 섬김에서 놓아 보내었는고 ?' 하고 ");
INSERT INTO kor_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","바로가 곧 그 병거를 갖추고 그 백성을 데리고 갈새 ");
INSERT INTO kor_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","특별 병거 육백승과 애굽의 모든 병거를 발하니 장관들이 다 거느렸더라 ");
INSERT INTO kor_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","여호와께서 애굽 왕 바로의 마음을 강퍅케 하셨으므로 그가 이스라엘 자손의 뒤를 따르니 이스라엘 자손이 담대히 나갔음이라 ");
INSERT INTO kor_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","애굽 사람들과 바로의 말들 병거들과 그 마병과 그 군대가 그들의 뒤를 따라 바알스본 맞은편 비하히롯 곁 해변 그 장막 친 데 미치니라 ");
INSERT INTO kor_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","바로가 가까와 올 때에 이스라엘 자손이 눈을 들어 본즉 애굽 사람들이 자기 뒤에 미친지라 이스라엘 자손이 심히 두려워하여 여호와께 부르짖고 ");
INSERT INTO kor_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","그들이 또 모세에게 이르되 `애굽에 매장지가 없으므로 당신이 우리를 이끌어 내어 이 광야에서 죽게 하느뇨 ? 어찌하여 당신이 우리를 애굽에서 이끌어 내어 이같이 우리에게 하느뇨 ? ");
INSERT INTO kor_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","우리가 애굽에서 당신에게 고한 말이 이것이 아니뇨 ? 이르기를 우리를 버려 두라 우리가 애굽 사람을 섬길 것이라 하지 아니하더뇨 ? 애굽 사람을 섬기는 것이 광야에서 죽는 것보다 낫겠노라' ");
INSERT INTO kor_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","모세가 백성에게 이르되 `너희는 두려워 말고 가만히 서서 여호와께서 오늘날 너희를 위하여 행하시는 구원을 보라 ! 너희가 오늘 본 애굽 사람을 또 다시는 영원히 보지 못하리라 ");
INSERT INTO kor_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","여호와께서 너희를 위하여 싸우시리니 너희는 가만히 있을지니라 !' ");
INSERT INTO kor_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","여호와께서 모세에게 이르시되 너는 어찌하여 내게 부르짖느뇨 이스라엘 자손을 명하여 앞으로 나가게 하고 ");
INSERT INTO kor_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","지팡이를 들고 손을 바다 위로 내밀어 그것으로 갈라지게 하라 이스라엘 자손이 바다 가운데 육지로 행하리라 ");
INSERT INTO kor_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","내가 애굽 사람들의 마음을 강퍅케 할 것인즉 그들이 그 뒤를 따라 들어갈 것이라 내가 바로와 그 모든 군대와 그 병거와 마병을 인하여 영광을 얻으리니 ");
INSERT INTO kor_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","내가 바로와 그 병거와 마병으로 인하여 영광을 얻을 때에야 애굽 사람들이 나를 여호와인 줄 알리라 하시더니 ");
INSERT INTO kor_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","이스라엘 진 앞에 행하던 하나님의 사자가 옮겨 그 뒤로 행하매 구름 기둥도 앞에서 그 뒤로 옮겨 ");
INSERT INTO kor_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","애굽 진과 이스라엘 진 사이에 이르러 서니 저 편은 구름과 흑암이 있고 이 편은 밤이 광명하므로 밤새도록 저 편이 이 편에 가까이 못하였더라 ");
INSERT INTO kor_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","모세가 바다 위로 손을 내어민대 여호와께서 큰 동풍으로 밤새도록 바닷물을 물러가게 하시니 물이 갈라져 바다가 마른 땅이 된지라 ");
INSERT INTO kor_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","이스라엘 자손이 바다 가운데 육지로 행하고 물은 그들의 좌우에 벽이 되니 ");
INSERT INTO kor_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","애굽 사람들과 바로의 말들, 병거들과 그 마병들이 다 그 뒤를 쫓아 바다 가운데로 들어 오는지라 ");
INSERT INTO kor_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","새벽에 여호와께서 불 구름기둥 가운데서 애굽 군대를 보시고 그 군대를 어지럽게 하시며 ");
INSERT INTO kor_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","그 병거 바퀴를 벗겨서 달리기에 극난하게 하시니 애굽 사람들이 가로되 '이스라엘 앞에서 우리가 도망하자 ! 여호와가 그들을 위하여 싸워 애굽 사람들을 치는도다' ");
INSERT INTO kor_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","여호와께서 모세에게 이르시되 네 손을 바다 위로 내어밀어 물이 애굽 사람들과 그 병거들과 마병들 위에 다시 흐르게 하라 하시니 ");
INSERT INTO kor_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","모세가 곧 손을 바다 위로 내어밀매 새벽에 미쳐 바다의 그 세력이 회복된지라 애굽 사람들이 물을 거스려 도망하나 여호와께서 애굽 사람들을 바다 가운데 엎으시니 ");
INSERT INTO kor_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","물이 다시 흘러 병거들과 기병들을 덮되 그들의 뒤를 쫓아 바다에 들어간 바로의 군대를 다 덮고 하나도 남기지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","그러나 이스라엘 자손은 바다 가운데 육지로 행하였고 물이 좌우에 벽이 되었었더라 ");
INSERT INTO kor_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","그 날에 여호와께서 이같이 이스라엘을 애굽 사람의 손에서 구원하시매 이스라엘이 바닷가의 애굽 사람의 시체를 보았더라 ");
INSERT INTO kor_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","이스라엘이 여호와께서 애굽 사람들에게 베푸신 큰 일을 보았으므로 백성이 여호와를 경외하며 여호와와 그 종 모세를 믿었더라 ");
INSERT INTO kor_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","이 때에 모세와 이스라엘 자손이 이 노래로 여호와께 노래하니 일렀으되 내가 여호와를 찬송하리니 그는 높고 영화로우심이요 말과 그 탄 자를 바다에 던지셨음이로다 ");
INSERT INTO kor_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","여호와는 나의 힘이요, 노래시며, 나의 구원이시로다 그는 나의 하나님이시니 내가 그를 찬송할 것이요 내 아비의 하나님이시니 내가 그를 높이리로다 ");
INSERT INTO kor_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","여호와는 용사시니 여호와는 그의 이름이시로다 ");
INSERT INTO kor_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","그가 바로의 병거와 그 군대를 바다에 던지시니 그 택한 장관이 홍해에 잠겼고 ");
INSERT INTO kor_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","큰 물이 그들을 덮으니 그들이 돌처럼 깊음에 내렸도다 ");
INSERT INTO kor_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","여호와여 주의 오른손이 권능으로 영광을 나타내시니이다 여호와여 ! 주의 오른 손이 원수를 부수시니이다 ");
INSERT INTO kor_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","주께서 주의 큰 위엄으로 주를 거스리는 자를 엎으시나이다 주께서 진노를 발하시니 그 진노가 그들을 초개같이 사르니이다 ");
INSERT INTO kor_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","주의 콧김에 물이 쌓이되 파도가 언덕 같이 일어서고 큰 물이 바다 가운데 엉기니이다 ");
INSERT INTO kor_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","대적의 말이 내가 쫓아 미쳐 탈취물을 나누리라 내가 그들로 인하여 내 마음을 채우리라 내가 내 칼을 빼리니 내 손이 그들을 멸하리라 하였으나 ");
INSERT INTO kor_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","주께서 주의 바람을 일으키시매 바다가 그들을 덮으니 그들이 흉용한 물에 납 같이 잠겼나이다 ");
INSERT INTO kor_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","여호와여 ! 신 중에 주와 같은 자 누구니이까 ? 주와 같이 거룩함에 영광스러우며 찬송할만한 위엄이 있으며 기이한 일을 행하는 자 누구니이까 ? ");
INSERT INTO kor_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","주께서 오른손을 드신즉 땅이 그들을 삼켰나이다 ");
INSERT INTO kor_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","주께서 그 구속하신 백성을 은혜로 인도하시되 주의 힘으로 그들을 주의 성결한 처소에 들어가게 하시나이다 ");
INSERT INTO kor_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","열방이 듣고 떨며 블레셋 거민이 두려움에 잡히며 ");
INSERT INTO kor_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","에돔 방백이 놀라고 모압 영웅이 떨림에 잡히며 가나안 거민이 다 낙담하나이다 ");
INSERT INTO kor_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","놀람과 두려움이 그들에게 미치매 주의 팔이 큼을 인하여 그들이 돌같이 고요하였사오되 여호와여 ! 주의 백성이 통과하기까지 곧 주의 사신 백성이 통과하기까지였나이다 ");
INSERT INTO kor_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","주께서 백성을 인도하사 그들을 주의 기업의 산에 심으시리이다 여호와여 ! 이는 주의 처소를 삼으시려고 예비하신 것이라 주여 ! 이것이 주의 손으로 세우신 성소로소이다 ");
INSERT INTO kor_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","여호와의 다스리심이 영원무궁하시도다 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","바로의 말과 병거와 마병이 함께 바다에 들어가매 여호와께서 바닷물로 그들 위에 돌이켜 흐르게 하셨으나 이스라엘 자손은 바다가운데서 육지로 행한지라 ");
INSERT INTO kor_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","아론의 누이 선지자 미리암이 손에 소고를 잡으매 모든 여인도 그를 따라 나오며 소고를 잡고 춤추니 ");
INSERT INTO kor_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","미리암이 그들에게 화답하여 가로되 `너희는 여호와를 찬송하라 ! 그는 높고 영화로우심이요 말과 그 탄 자를 바다에 던지셨음이로다' 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","모세가 홍해에서 이스라엘을 인도하매 그들이 나와서 수르 광야로 들어가서 거기서 사흘길을 행하였으나 물을 얻지 못하고 ");
INSERT INTO kor_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","마라에 이르렀더니 그 곳 물이 써서 마시지 못하겠으므로 그 이름을 마라라 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","백성이 모세를 대하여 원망하여 가로되 `우리가 무엇을 마실까 ?' 하매 ");
INSERT INTO kor_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","모세가 여호와께 부르짖었더니 여호와께서 그에게 한 나무를 지시하시니 그가 물에 던지매 물이 달아졌더라 거기서 여호와께서 그들을 위하여 법도와 율례를 정하시고 그들을 시험하실쌔 ");
INSERT INTO kor_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","가라사대 너희가 너희 하나님 나 여호와의 말을 청종하고 나의 보기에 의를 행하며 내 계명에 귀를 기울이며 내 모든 규례를 지키면 내가 애굽 사람에게 내린 모든 질병의 하나도 너희에게 내리지 아니하리니 나는 너희를 치료하는 여호와임이니라 ! ");
INSERT INTO kor_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","그들이 엘림에 이르니 거기 물샘 열 둘과 종려 칠십주가 있는지라 거기서 그들이 그 물 곁에 장막을 치니라 ");
INSERT INTO kor_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","이스라엘 자손의 온 회중이 엘림에서 떠나 엘림과 시내산 사이 신 광야에 이르니 애굽에서 나온 후 제 이월 십오일이라 ");
INSERT INTO kor_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","이스라엘 온 회중이 그 광야에서 모세와 아론을 원망하여 ");
INSERT INTO kor_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","그들에게 이르되 `우리가 애굽 땅에서 고기 가마 곁에 앉았던 때와 떡을 배불리 먹던 때에 여호와의 손에 죽었더면 좋았을 것을 너희가 이 광야로 우리를 인도하여 내어 이 온 회중으로 주려 죽게 하는도다' ");
INSERT INTO kor_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","때에 여호와께서 모세에게 이르시되 `보라 ! 내가 너희를 위하여 하늘에서 양식을 비 같이 내리리니 백성이 나가서 일용할 것을 날마다 거둘 것이라 이같이 하여 그들이 나의 율법을 준행하나 아니하나 내가 시험하리라 ");
INSERT INTO kor_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","제 육일에는 그들이 그 거둔 것을 예비할지니 날마다 거두던 것의 갑절이 되리라' ");
INSERT INTO kor_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","모세와 아론이 온 이스라엘 자손에게 이르되 `저녁이 되면 너희가 여호와께서 너희를 애굽 땅에서 인도하여 내셨음을 알 것이요 ");
INSERT INTO kor_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","아침에는 너희가 여호와의 영광을 보리니 이는 여호와께서 너희가 자기를 향하여 원망함을 들으셨음이라 우리가 누구관대 너희가 우리를 대하여 원망하느냐 ?' ");
INSERT INTO kor_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","모세가 또 가로되 `여호와께서 저녁에는 너희에게 고기를 주어 먹이시고 아침에는 떡으로 배불리시리니 이는 여호와께서 자기를 향하여 너희의 원망하는 그 말을 들으셨음이니라 우리가 누구냐 ? 너희의 원망은 우리를 향하여 함이 아니요 여호와를 향하여 함이로다' ");
INSERT INTO kor_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","모세가 또 아론에게 이르되 `이스라엘 자손의 온 회중에게 명하기를 여호와께 가까이 나아오라 ! 여호와께서 너희의 원망함을 들으셨느니라 하라' ");
INSERT INTO kor_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","아론이 이스라엘 자손의 온 회중에게 말하매 그들이 광야를 바라보니 여호와의 영광이 구름 속에 나타나더라 ");
INSERT INTO kor_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","내가 이스라엘 자손의 원망함을 들었노라 그들에게 고하여 이르기를 너희가 해 질 때에는 고기를 먹고 아침에는 떡으로 배부르리니 나는 여호와 너희의 하나님인 줄 알리라 하라 하시니라 ");
INSERT INTO kor_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","저녁에는 메추라기가 와서 진에 덮이고 아침에는 이슬이 진 사면에 있더니 ");
INSERT INTO kor_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","그 이슬이 마른 후에 광야 지면에 작고 둥글며 서리 같이 세미한 것이 있는지라 ");
INSERT INTO kor_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","이스라엘 자손이 보고 그것이 무엇인지 알지 못하여 서로 이르되 이것이 무엇이냐 ? 하니 모세가 그들에게 이르되 이는 여호와께서 너희에게 주어 먹게 하신 양식이라 ");
INSERT INTO kor_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","여호와께서 이같이 명하시기를 너희 각 사람의 식량대로 이것을 거둘지니 곧 너희 인수대로 매명에 한 오멜씩 취하되 각 사람이 그 장막에 있는 자들을 위하여 취할지니라 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","이스라엘 자손이 그같이 하였더니 그 거둔 것이 많기도 하고 적기도 하나 ");
INSERT INTO kor_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","오멜로 되어 본즉 많이 거둔 자도 남음이 없고 적게 거둔 자도 부족함이 없이 각기 식량대로 거두었더라 ");
INSERT INTO kor_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","모세가 그들에게 이르기를 `아무든지 아침까지 그것을 남겨 두지말라' 하였으나 ");
INSERT INTO kor_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","그들이 모세의 말을 청종치 아니하고 더러는 아침까지 두었더니 벌레가 생기고 냄새가 난지라 모세가 그들에게 노하니라 ");
INSERT INTO kor_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","무리가 아침마다 각기 식량대로 거두었고 해가 뜨겁게 쪼이면 그것이 스러졌더라 ");
INSERT INTO kor_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","제육일에는 각 사람이 갑절의 식물 곧 하나에 두 오멜씩 거둔지라 회중의 모든 두목이 와서 모세에게 고하매 ");
INSERT INTO kor_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","모세가 그들에게 이르되 `여호와께서 이같이 말씀하셨느니라 내일은 휴식이니 여호와께 거룩한 안식일이라 너희가 구울 것은 굽고 삶을 것은 삶고, 그 나머지는 다 너희를 위하여 아침까지 간수하라' ");
INSERT INTO kor_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","그들이 모세의 명대로 아침까지 간수하였으나 냄새도 나지 아니하고 벌레도 생기지 아니한지라 ");
INSERT INTO kor_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","모세가 가로되 `오늘은 그것을 먹으라 오늘은 여호와께 안식일인즉 오늘은 너희가 그것을 들에서 얻지 못하리라 ");
INSERT INTO kor_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","육일 동안은 너희가 그것을 거두되 제 칠일은 안식일인즉 그날에는 없으리라 !' 하였으나 ");
INSERT INTO kor_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","제 칠일에 백성 중 더러가 거두러 나갔다가 얻지 못하니라 ");
INSERT INTO kor_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","여호와께서 모세에게 이르시되 어느 때까지 너희가 내 계명과 내 율법을 지키지 아니하려느냐 ? ");
INSERT INTO kor_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","볼지어다 ! 여호와가 너희에게 안식일을 줌으로 제 육일에는 이들 양식을 너희에게 주는 것이니 너희는 각기 처소에 있고 제 칠일에는 아무도 그 처소에서 나오지 말지니라 ");
INSERT INTO kor_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","그러므로 백성이 제 칠일에 안식하니라 ");
INSERT INTO kor_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","이스라엘 족속이 그 이름을 만나라 하였으며 깟씨 같고도 희고 맛은 꿀 섞은 과자 같았더라 ");
INSERT INTO kor_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","모세가 가로되 `여호와께서 이같이 명하시기를 이것을 오멜에 채워서 너의 대대 후손을 위하여 간수하라 이는 내가 너희를 애굽 땅에서 인도하여 낼 때에 광야에서 너희에게 먹인 양식을 그들에게 보이기 위함이니라 하셨다' 하고 ");
INSERT INTO kor_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","또 아론에게 이르되 `항아리를 가져다가 그 속에 만나 한 오멜을 담아 여호와 앞에 두어 너희 대대로 간수하라' ");
INSERT INTO kor_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","아론이 여호와께서 모세에게 명하신대로 그것을 증거판 앞에 두어 간수하게 하였고 ");
INSERT INTO kor_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","이스라엘 자손이 사람 사는 땅에 이르기까지 사십년 동안 만나를 먹되 곧 가나안 지경에 이르기까지 그들이 만나를 먹었더라 ");
INSERT INTO kor_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","오멜은 에바 십분의 일이더라 ");
INSERT INTO kor_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","이스라엘 자손의 온 회중이 여호와의 명령대로 신 광야에서 떠나 그 노정대로 행하여 르비딤에 장막을 쳤으나 백성이 마실 물이 없는지라 ");
INSERT INTO kor_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","백성이 모세와 다투어 가로되 `우리에게 물을 주어 마시게 하라' 모세가 그들에게 이르되 '너희가 어찌하여 나와 다투느냐 ? 너희가 어찌하여 여호와를 시험하느냐 ?' ");
INSERT INTO kor_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","거기서 백성이 물에 갈하매 그들이 모세를 대하여 원망하여 가로되 당신이 어찌하여 우리를 애굽에서 인도하여 내어서 우리와 우리 자녀와 우리 생축으로 목말라 죽게 하느냐 ? ");
INSERT INTO kor_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","모세가 여호와께 부르짖어 가로되 `내가 이 백성에게 어떻게 하리이까 ? 그들이 얼마 아니면 내게 돌질하겠나이다' ");
INSERT INTO kor_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","여호와께서 모세에게 이르시되 백성 앞을 지나가서 이스라엘 장로들을 데리고 하수를 치던 네 지팡이를 손에 잡고 가라 ");
INSERT INTO kor_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","내가 거기서 호렙산 반석 위에 너를 대하여 서리니 너는 반석을 치라 ! 그것에서 물이 나리니 백성이 마시리라 모세가 이스라엘 장로들의 목전에서 그대로 행하니라 ");
INSERT INTO kor_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","그가 그곳 이름을 맛사라 또는 므리바라 불렀으니 이는 이스라엘 자손이 다투었음이요 또는 그들이 여호와를 시험하여 이르기를 '여호와께서 우리 중에 계신가 아닌가' 하였음이더라 ");
INSERT INTO kor_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","때에 아말렉이 이르러 이스라엘과 르비딤에서 싸우니라 ");
INSERT INTO kor_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","모세가 여호수아에게 이르되 `우리를 위하여 사람들을 택하여 나가서 아말렉과 싸우라 내일 내가 하나님의 지팡이를 손에 잡고 산꼭대기에 서리라' ");
INSERT INTO kor_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","여호수아가 모세의 말대로 행하여 아말렉과 싸우고 모세와 아론과 훌은 산꼭대기에 올라가서 ");
INSERT INTO kor_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","모세가 손을 들면 이스라엘이 이기고 손을 내리면 아말렉이 이기더니 ");
INSERT INTO kor_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","모세의 팔이 피곤하매 그들이 돌을 가져다가 모세의 아래에 놓아 그로 그 위에 앉게 하고 아론과 훌이 하나는 이편에서 하나는 저편에서 모세의 손을 붙들어 올렸더니 그 손이 해가 지도록 내려 오지 아니한지라 ");
INSERT INTO kor_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","여호수아가 칼날로 아말렉과 그 백성을 쳐서 파하니라 ");
INSERT INTO kor_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","여호와께서 모세에게 이르시되 이것을 책에 기록하여 기념하게 하고 여호수아의 귀에 외워 들리라 내가 아말렉을 도말하여 천하에서 기억함이 없게 하리라 ");
INSERT INTO kor_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","모세가 단을 쌓고 그 이름을 `여호와 닛시'라 하고 ");
INSERT INTO kor_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","가로되 여호와께서 맹세하시기를 여호와가 아말렉으로 더불어 대대로 싸우리라 하셨다 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","모세의 장인 미디안 제사장 이드로가 하나님이 모세에게와 자기 백성 이스라엘에게 하신 일 곧 여호와께서 이스라엘을 애굽에서 인도하여 내신 모든 일을 들으니라 ");
INSERT INTO kor_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","모세의 장인 이드로가 모세가 돌려 보내었던 그의 아내 십보라와 ");
INSERT INTO kor_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","그 두 아들을 데렸으니 그 하나의 이름은 게르솜이라 이는 모세가 이르기를 '내가 이방에서 객이 되었다' 함이요 ");
INSERT INTO kor_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","하나의 이름은 엘리에셀이라 이는 `내 아버지의 하나님이 나를 도우사 바로의 칼에서 구원하셨다' 함이더라 ");
INSERT INTO kor_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","모세의 장인 이드로가 모세의 아들들과 그 아내로 더불어 광야에 들어와 모세에게 이르니 곧 모세가 하나님의 산에 진 친 곳이라 ");
INSERT INTO kor_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","그가 모세에게 전언하되 `그대의 장인 나 이드로가 그대의 아내와 그와 함께한 그 두 아들로 더불어 그대에게 왔노라' ");
INSERT INTO kor_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","모세가 나가서 그 장인을 맞아 절하고 그에게 입맞추고 그들이 서로 문안하고 함께 장막에 들어가서 ");
INSERT INTO kor_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","모세가 여호와께서 이스라엘을 위하여 바로와 애굽 사람에게 행하신 모든 일과 길에서 그들의 당한 모든 고난과 여호와께서 그 들을 구원하신 일을 다 그 장인에게 고하매 ");
INSERT INTO kor_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","이드로가 여호와께서 이스라엘에게 모든 은혜를 베푸사 애굽 사람의 손에서 구원하심을 기뻐하여 ");
INSERT INTO kor_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","가로되 `여호와를 찬송하리로다 ! 너희를 애굽 사람의 손에서와 바로의 손에서 건져내시고 백성을 애굽 사람의 손 밑에서 건지셨도다 ");
INSERT INTO kor_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","이제 내가 알았도다 ! 여호와는 모든 신보다 크시므로 이스라엘에게 교만히 행하는 그들을 이기셨도다' 하고 ");
INSERT INTO kor_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","모세의 장인 이드로가 번제물과 희생을 하나님께 가져오매 아론과 이스라엘 모든 장로가 와서 모세의 장인과 함께 하나님 앞에서 떡을 먹으니라 ");
INSERT INTO kor_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","이튿날에 모세가 백성을 재판하느라고 앉았고 백성은 아침부터 저녁까지 모세의 곁에 섰는지라 ");
INSERT INTO kor_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","모세의 장인이 모세가 백성에게 행하는 모든 일을 보고 가로되 `그대가 이 백성에게 행하는 이 일이 어찜이뇨 ? 어찌하여 그대는 홀로 앉았고 백성은 아침부터 저녁까지 그대의 곁에 섰느뇨 ?' ");
INSERT INTO kor_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","모세가 그 장인에게 대답하되 `백성이 하나님께 물으려고 내게로 옴이라 ");
INSERT INTO kor_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","그들이 일이 있으면 내게로 오나니 내가 그 양편을 판단하여 하나님의 율례와 법도를 알게 하나이다' ");
INSERT INTO kor_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","모세의 장인이 그에게 이르되 `그대의 하는 것이 선하지 못하도다 ");
INSERT INTO kor_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","그대와 그대와 함께한 이 백성이 필연 기력이 쇠하리니 이 일이 그대에게 너무 중함이라 그대가 혼자 할 수 없으리라 ");
INSERT INTO kor_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","이제 내 말을 들으라 ! 내가 그대에게 방침을 가르치리니 하나님이 그대와 함께 계실지로다 ! 그대는 백성을 위하여 하나님 앞에 있어서 소송을 하나님께 베풀며 ");
INSERT INTO kor_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","그들에게 율례와 법도를 가르쳐서 마땅히 갈 길과 할 일을 그들에게 보이고 ");
INSERT INTO kor_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","그대는 또 온 백성 가운데서 재덕이 겸전한 자 곧 하나님을 두려워하며 진실무망하며 불의한 이를 미워하는 자를 빼서 백성 위에 세워 천부장과 백부장과 오십부장과 십부장을 삼아 ");
INSERT INTO kor_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","그들로 때를 따라 백성을 재판하게 하라 무릇 큰 일이면 그대에게 베풀 것이고 무릇 작은 일이면 그들이 스스로 재판할 것이니 그리하면 그들이 그대와 함께 담당할 것인즉 일이 그대에게 쉬우리라 ");
INSERT INTO kor_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","그대가 만일 이 일을 하고 하나님께서도 그대에게 인가하시면 그대가 이 일을 감당하고 이 모든 백성도 자기 곳으로 평안히 가리라' ");
INSERT INTO kor_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","이에 모세가 자기 장인의 말을 듣고 그 모든 말대로 하여 ");
INSERT INTO kor_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","이스라엘 무리 중에서 재덕이 겸전한 자를 빼서 그들로 백성의 두목 곧 천부장과 백부장과 오십부장과 십부장을 삼으매 ");
INSERT INTO kor_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","그들이 때를 따라 백성을 재판하되 어려운 일은 모세에게 베풀고 쉬운 일은 자단하더라 ");
INSERT INTO kor_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","모세가 그 장인을 보내니 그가 자기 고향으로 돌아가니라 ");
INSERT INTO kor_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","이스라엘 자손이 애굽 땅에서 나올 때부터 제 삼월 곧 그 때에 그들이 시내 광야에 이르니라 ");
INSERT INTO kor_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","그들이 르비딤을 떠나 시내 광야에 이르러 그 광야에 장막을 치되 산 앞에 장막을 치니라 ");
INSERT INTO kor_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","모세가 하나님 앞에 올라가니 여호와께서 산에서 그를 불러 가라사대 너는 이같이 야곱 족속에게 이르고 이스라엘 자손에게 고하라 ");
INSERT INTO kor_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","나의 애굽 사람에게 어떻게 행하였음과 내가 어떻게 독수리 날개로 너희를 업어 내게로 인도하였음을 너희가 보았느니라 ");
INSERT INTO kor_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","세계가 다 내게 속하였나니 너희가 내 말을 잘 듣고 내 언약을 지키면 너희는 열국 중에서 내 소유가 되겠고 ");
INSERT INTO kor_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","너희가 내게 대하여 제사장 나라가 되며 거룩한 백성이 되리라 너는 이 말을 이스라엘 자손에게 고할지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","모세가 와서 백성의 장로들을 불러 여호와께서 자기에게 명하신 그 모든 말씀을 그 앞에 진술하니 ");
INSERT INTO kor_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","백성이 일제히 응답하여 가로되 `여호와의 명하신대로 우리가 다 행하리이다 !' 모세가 백성의 말로 여호와께 회보하매 ");
INSERT INTO kor_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","여호와께서 모세에게 이르시되 내가 빽빽한 구름 가운데서 네게 일함은 내가 너와 말하는 것을 백성으로 듣게하며 또한 너를 영원히 믿게 하려함이니라 모세가 백성의 말로 여호와께 고하였으므로 ");
INSERT INTO kor_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","여호와께서 모세에게 이르시되 너는 백성에게로 가서 오늘과 내일 그들을 성결케 하며 그들로 옷을 빨고 ");
INSERT INTO kor_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","예비하여 제 삼일을 기다리게 하라 이는 제 삼일에 나 여호와가 온 백성의 목전에 시내산에 강림할 것임이니 ");
INSERT INTO kor_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","너는 백성을 위하여 사면으로 지경을 정하고 이르기를 너희는 삼가 산에 오르거나 그 지경을 범하지 말지니 산을 범하는 자는 정녕 죽임을 당할 것이라 ");
INSERT INTO kor_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","손을 그에게 댐이 없이 그런 자는 돌에 맞아 죽임을 당하거나 살에 쐬어 죽임을 당하리니 짐승이나 사람을 무론하고 살지 못하리라 나팔을 길게 불거든 산 앞에 이를 것이니라 하라 ");
INSERT INTO kor_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","모세가 산에서 내려 백성에게 이르러 백성으로 성결케 하니 그들이 자기 옷을 빨더라 ");
INSERT INTO kor_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","모세가 백성에게 이르되 `예비하여 제 삼일을 기다리고 여인을 가까이 말라' 하니라 ");
INSERT INTO kor_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","제 삼일 아침에 우뢰와 번개와 빽빽한 구름이 산 위에 있고 나팔소리가 심히 크니 진중 모든 백성이 다 떨더라 ");
INSERT INTO kor_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","모세가 하나님을 맞으려고 백성을 거느리고 진에서 나오매 그들이 산 기슭에 섰더니 ");
INSERT INTO kor_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","시내산에 연기가 자욱하니 여호와께서 불 가운데서 거기 강림하심이라 그 연기가 옹기점 연기 같이 떠오르고 온 산이 크게 진동하며 ");
INSERT INTO kor_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","나팔 소리가 점점 커질 때에 모세가 말한즉 하나님이 음성으로 대답하시더라 ");
INSERT INTO kor_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","여호와께서 시내산 곧 그 산꼭대기에 강림하시고 그리로 모세를 부르시니 모세가 올라 가매 ");
INSERT INTO kor_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","여호와께서 모세에게 이르시되 내려가서 백성을 신칙하라 백성이 돌파하고 나 여호와께로 와서 보려고 하다가 많이 죽을까 하노라 ");
INSERT INTO kor_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","또 여호와께 가까이 하는 제사장들로 그 몸을 성결히 하게 하라 나 여호와가 그들을 돌격할까 하노라 ");
INSERT INTO kor_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","모세가 여호와께 고하되 `주께서 우리에게 명하여 이르시기를 산사면에 지경을 세워 산을 거룩하게 하라 하셨사온즉 백성이 시내산에 오르지 못하리이다' ");
INSERT INTO kor_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","여호와께서 그에게 이르시되 가라 너는 내려가서 아론과 함께 올라오고 제사장들과 백성에게는 돌파하고 나 여호와에게로 올라오지 못하게 하라 내가 그들을 돌격할까 하노라 ");
INSERT INTO kor_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","모세가 백성에게 내려가서 그들에게 고하니라 ");
INSERT INTO kor_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","하나님이 이 모든 말씀으로 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","나는 너를 애굽 땅 종 되었던 집에서 인도하여 낸 너의 하나님 여호와로라 ");
INSERT INTO kor_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","너는 나 외에는 다른 신들을 네게 있게 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","너를 위하여 새긴 우상을 만들지 말고 또 위로 하늘에 있는 것이나 아래로 땅에 있는 것이나 땅 아래 물 속에 있는 것의 아무 형상이든지 만들지 말며 ");
INSERT INTO kor_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","그것들에게 절하지 말며 그것들을 섬기지 말라 ! 나 여호와 너의 하나님은 질투하는 하나님인즉 나를 미워하는 자의 죄를 갚되 아비로부터 아들에게로 삼 사대까지 이르게 하거니와 ");
INSERT INTO kor_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","나를 사랑하고 내 계명을 지키는 자에게는 천대까지 은혜를 베푸느니라 ");
INSERT INTO kor_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","너는 너의 하나님 여호와의 이름을 망령되이 일컫지 말라 ! 나 여호와의 이름을 망령되이 일컫는 자를 죄 없다 하지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","안식일을 기억하여 거룩히 지키라 ! ");
INSERT INTO kor_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","엿새 동안은 힘써 네 모든 일을 행할 것이나 ");
INSERT INTO kor_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","제 칠일은 너의 하나님 여호와의 안식일인즉 너나 네 아들이나 네 육축이나 네 문안에 유하는 객이라도 아무 일도 하지 말라 ");
INSERT INTO kor_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","이는 엿새 동안에 나 여호와가 하늘과 땅과 바다와 그 가운데 모든 것을 만들고 제 칠일에 쉬었음이라 그러므로 나 여호와가 안식일을 복되게 하여 그 날을 거룩하게 하였느니라 ");
INSERT INTO kor_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","네 부모를 공경하라 ! 그리하면 너의 하나님 나 여호와가 네게 준 땅에서 네 생명이 길리라 ");
INSERT INTO kor_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","살인하지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","간음하지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","도적질하지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","네 이웃에 대하여 거짓 증거하지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","네 이웃의 집을 탐내지 말지니라 ! 네 이웃의 아내나, 그의 남종이나, 그의 여종이나, 그의 소나, 그의 나귀나, 무릇 네 이웃의 소유를 탐내지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","뭇 백성이 우뢰와 번개와 나팔소리와 산의 연기를 본지라 그들이 볼 때에 떨며 멀리 서서 ");
INSERT INTO kor_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","모세에게 이르되 `당신이 우리에게 말씀하소서 우리가 들으리이다 하나님이 우리에게 말씀하시지 말게 하소서 우리가 죽을까 하나이다' ");
INSERT INTO kor_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","모세가 백성에게 이르되 `두려워 말라 ! 하나님이 강림하심은 너희를 시험하고 너희로 경외하여 범죄치 않게 하려 하심이니라' ");
INSERT INTO kor_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","백성은 멀리 섰고 모세는 하나님의 계신 암흑으로 가까이 가니라 ");
INSERT INTO kor_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","여호와께서 모세에게 이르시되 너는 이스라엘 자손에게 이같이 이르라 내가 하늘에서부터 너희에게 말하는 것을 너희가 친히 보았으니 ");
INSERT INTO kor_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","너희는 나를 비겨서 은으로 신상이나 금으로 신상을 너희를 위하여 만들지 말고 ");
INSERT INTO kor_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","내게 토단을 쌓고 그 위에 너의 양과 소로 너의 번제와 화목제를 드리라 내가 무릇 내 이름을 기념하게 하는 곳에서 네게 강림하여 복을 주리라 ");
INSERT INTO kor_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","네가 내게 돌로 단을 쌓거든 다듬은 돌로 쌓지 말라 네가 정으로 그것을 쪼면 부정하게 함이니라 ");
INSERT INTO kor_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","너는 층계로 내 단에 오르지 말라 네 하체가 그 위에서 드러날까 함이니라 ");
INSERT INTO kor_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","네가 백성 앞에 세울 율례는 이러하니라 ");
INSERT INTO kor_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","네가 히브리 종을 사면 그가 육년 동안 섬길 것이요 제 칠년에는 값 없이 나가 자유할 것이요 ");
INSERT INTO kor_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","그가 단신으로 왔으면 단신으로 나갈 것이요, 장가 들었으면 그 아내도 그와 함께 나가려니와 ");
INSERT INTO kor_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","상전이 그에게 아내를 줌으로 그 아내가 자녀간 낳았으면 그 아내와 그 자식들은 상전에게 속할 것이요 그는 단신으로 나갈 것이로되 ");
INSERT INTO kor_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","종이 진정으로 말하기를 `내가 상전과 내 처자를 사랑하니 나가서 자유하지 않겠노라' 하면 ");
INSERT INTO kor_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","상전이 그를 데리고 재판장에게로 갈 것이요 또 그를 문이나 문설주 앞으로 데리고 가서 그것에다가 송곳으로 그 귀를 뚫을 것이라 그가 영영히 그 상전을 섬기리라 ");
INSERT INTO kor_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","사람이 그 딸을 여종으로 팔았으면 그는 남종 같이 나오지 못할지며 ");
INSERT INTO kor_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","만일 상전이 그를 기뻐 아니하여 상관치 아니하면 그를 속신케 할것이나 그 여자를 속임이 되었으니 타국인에게 팔지 못할 것이요 ");
INSERT INTO kor_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","만일 그를 자기 아들에게 주기로 하였으면 그를 딸 같이 대접 할것이요 ");
INSERT INTO kor_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","만일 상전이 달리 장가를 들지라도 그의 의복과 음식과 동침하는 것은 끊지 못할 것이요 ");
INSERT INTO kor_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","이 세가지를 시행하지 아니하면 그는 속전을 내지 않고 거저 나가게 할 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","사람을 쳐 죽인 자는 반드시 죽일 것이나 ");
INSERT INTO kor_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","만일 사람이 계획한 일이 아니라 나 하나님이 사람을 그 손에 붙임이면 내가 위하여 한 곳을 정하리니 그 사람이 그리로 도망할 것이며 ");
INSERT INTO kor_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","사람이 그 이웃을 짐짓 모살하였으면 너는 그를 내 단에서라도 잡아내어 죽일지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","자기 아비나 어미를 치는 자는 반드시 죽일지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","사람을 후린 자가 그 사람을 팔았든지 자기 수하에 두었든지 그를 반드시 죽일지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","그 아비나 어미를 저주하는 자는 반드시 죽일지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","사람이 서로 싸우다가 하나가 돌이나 주먹으로 그 적수를 쳤으나 그가 죽지 않고 자리에 누었다가 ");
INSERT INTO kor_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","지팡이를 짚고 기동하면 그를 친 자가 형벌은 면하되 기간 손해를 배상하고 그로 전치되게 할지니라 ");
INSERT INTO kor_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","사람이 매로 그 남종이나 여종을 쳐서 당장에 죽으면 반드시 형벌을 받으려니와 ");
INSERT INTO kor_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","그가 일일이나 이일을 연명하면 형벌을 면하리니 그는 상전의 금전임이니라 ");
INSERT INTO kor_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","사람이 서로 싸우다가 아이 밴 여인을 다쳐 낙태케 하였으나 다른 해가 없으면 그 남편의 청구대로 반드시 벌금을 내되 재판장의 판결을 좇아 낼 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","그러나 다른 해가 있으면 갚되 생명은 생명으로, ");
INSERT INTO kor_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","눈은 눈으로, 이는 이로, 손은 손으로, 발은 발로 ");
INSERT INTO kor_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","데운 것은 데움으로, 상하게 한것은 상함으로, 때린 것은 때림으로 갚을지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","사람이 그 남종의 한 눈이나 여종의 한 눈을 쳐서 상하게 하면 그 눈 대신에 그를 놓을 것이며 ");
INSERT INTO kor_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","그 남종의 한 이나 여종의 한 이를 쳐서 빠뜨리면 그 이 대신에 그를 놓을지니라 ");
INSERT INTO kor_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","소가 남자나 여자를 받아서 죽이면 그 소는 반드시 돌에 맞아 죽을 것이요 그 고기는 먹지 말 것이며 임자는 형벌을 면하려니와 ");
INSERT INTO kor_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","소는 본래 받는 버릇이 있고 그 임자는 그로 인하여 경고를 받았으되 단속하지 아니하므로 남녀 간에 받아 죽이면 그 소는 돌로 쳐 죽일 것이고 임자도 죽일 것이며 ");
INSERT INTO kor_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","만일 그에게 속죄금을 명하면 무릇 그 명한 것을 생명의 속으로 낼 것이요 ");
INSERT INTO kor_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","아들을 받든지 딸을 받든지 이 율례대로 그 임자에게 행할 것이며 ");
INSERT INTO kor_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","소가 만일 남종이나 여종을 받으면 소 임자가 은 삼십 세겔을 그 상전에게 줄 것이요 소는 돌에 맞아 죽을지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","사람이 구덩이를 열어 두거나 구덩이를 파고 덮지 아니함으로 소나 나귀가 거기에 빠지면 ");
INSERT INTO kor_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","그 구덩이 주인이 잘 조처하여 짐승의 임자에게 돈을 줄 것이요 죽은 것은 그의 차지가 될지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","이 사람의 소가 저 사람의 소를 받아 죽이면 산 소를 팔아 그 값을 반분하고 죽은 것도 반분하려니와 ");
INSERT INTO kor_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","그 소가 본래 받는 버릇이 있는 줄을 알고도 그 임자가 단속하지 아니하였으면 그는 소로 소를 갚을 것이요 죽은 것은 그의 차지가 될지니라 ");
INSERT INTO kor_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","사람이 소나 양을 도적질하여 잡거나 팔면 그는 소 하나에 소 다섯으로 갚고 양 하나에 양 넷으로 갚을지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","도적이 뚫고 들어옴을 보고 그를 쳐 죽이면 피 흘린 죄가 없으나 ");
INSERT INTO kor_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","해 돋은 후이면 피 흘린 죄가 있으리라 도적은 반드시 배상할 것이나 배상할 것이 없으면 그 몸을 팔아 그 도적질한 것을 배상할 것이요 ");
INSERT INTO kor_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","도적질한 것이 살아 그 손에 있으면 소나 나귀나 양을 무론하고 갑절을 배상할지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","사람이 밭에서나 포도원에서 먹이다가 그 짐승을 놓아서 남의 밭에서 먹게 하면 자기 밭의 제일 좋은 것과 자기 포도원의 제일 좋은 것으로 배상할지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","불이 나서 가시나무에 미쳐 낟가리나 거두지 못한 곡식이나 전원을 태우면 불 놓은 자가 반드시 배상할지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","사람이 돈이나 물품을 이웃에게 맡겨 지키게 하였다가 그 이웃의 집에서 봉적하였는데 그 도적이 잡히면 갑절을 배상할 것이요 ");
INSERT INTO kor_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","도적이 잡히지 아니하면 그 집 주인이 재판장 앞에 가서 자기가 그 이웃의 물품에 손 댄 여부의 조사를 받을 것이며 ");
INSERT INTO kor_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","어떠한 과실에든지, 소에든지, 나귀에든지, 양에든지, 의복에든지, 또는 아무 잃은 물건에든지, 그것에 대하여 혹이 이르기를 이것이 그것이라 하면 두 편이 재판장 앞에 나아갈 것이요 재판장이 죄 있다고 하는 자가 그 상대편에게 갑절을 배상할지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","사람이 나귀나 소나 양이나 다른 짐승을 이웃에게 맡겨 지키게 하였다가 죽거나 상하거나 몰려가도 본 사람이 없으면 ");
INSERT INTO kor_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","두 사람 사이에 맡은 자가 이웃의 것에 손을 대지 아니하였다고 여호와로 맹세할 것이요 그 임자는 그대로 믿을 것이며 그 사람은 배상하지 아니하려니와 ");
INSERT INTO kor_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","만일 자기에게서 봉적하였으면 그 임자에게 배상할 것이며 ");
INSERT INTO kor_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","만일 찢겼으면 그것을 가져다가 증거할 것이요 그 찢긴 것에 대하여 배상하지 않을지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","만일 이웃에게 빌어온 것이 그 임자가 함께 있지 아니할 때에 상하거나 죽으면 반드시 배상하려니와 ");
INSERT INTO kor_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","그 임자가 그것과 함께 하였으면 배상하지 않을지며 세 낸것도 세를 위하여 왔은즉 배상하지 않을지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","사람이 정혼하지 아니한 처녀를 꾀어 동침하였으면 빙폐를 드려 아내로 삼을 것이요 ");
INSERT INTO kor_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","만일 그 아비가 그로 그에게 주기를 거절하면 그는 처녀에게 빙폐하는 일례로 돈을 낼지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","너는 무당을 살려 두지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","짐승과 행음하는 자는 반드시 죽일지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","여호와 외에 다른 신에게 희생을 드리는 자는 멸할지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","너는 이방 나그네를 압제하지 말며 그들을 학대하지 말라 너희도 애굽 땅에서 나그네이었었음이니라 ");
INSERT INTO kor_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","너는 과부나 고아를 해롭게 하지 말라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","네가 만일 그들을 해롭게 하므로 그들이 내게 부르짖으면 내가 반드시 그 부르짖음을 들을지라 ");
INSERT INTO kor_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","나의 노가 맹렬하므로 내가 칼로 너희를 죽이리니 너희 아내는 과부가 되고 너희 자녀는 고아가 되리라 ");
INSERT INTO kor_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","네가 만일 너와 함께한 나의 백성 중 가난한 자에게 돈을 꾸이거든 너는 그에게 채주같이 하지 말며 변리를 받지 말 것이며 ");
INSERT INTO kor_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","네가 만일 이웃의 옷을 전당잡거든 해가 지기 전에 그에게 돌려보내라 ");
INSERT INTO kor_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","그 몸을 가릴 것이 이뿐이라 이는 그 살의 옷인즉 그가 무엇을 입고 자겠느냐 ? 그가 내게 부르짖으면 내가 들으리니 나는 자비한자임이니라 ");
INSERT INTO kor_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","너는 재판장을 욕하지 말며 백성의 유사를 저주하지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","너는 너의 추수한 것과 너의 짜낸 즙을 드리기에 더디게 말지며 너의 처음 난 아들들을 내게 줄지며 ");
INSERT INTO kor_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","너의 소와 양도 그 일례로 하되 칠일 동안 어미와 함께 있게 하다가 팔일만에 내게 줄지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","너희는 내게 거룩한 사람이 될지니 들에서 짐승에게 찢긴 것의 고기를 먹지 말고 개에게 던질지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","너는 허망한 풍설을 전파하지 말며 악인과 연합하여 무함하는 증인이 되지 말며 ");
INSERT INTO kor_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","다수를 따라 악을 행하지 말며 송사에 다수를 따라 부정당한 증거를 하지 말며 ");
INSERT INTO kor_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","가난한 자의 송사라고 편벽되이 두호하지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","네가 만일 네 원수의 길 잃은 소나 나귀를 만나 거든 반드시 그 사람에게로 돌릴지며 ");
INSERT INTO kor_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","네가 만일 너를 미워하는 자의 나귀가 짐을 싣고 엎드러짐을 보거든 삼가 버려두지 말고 그를 도와 그 짐을 부리울지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","너는 가난한 자의 송사라고 공평치 않게 하지 말며 ");
INSERT INTO kor_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","거짓 일을 멀리하며 무죄한 자와 의로운 자를 죽이지 말라 ! 나는 악인을 의롭다 하지 아니하겠노라 ");
INSERT INTO kor_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","너는 뇌물을 받지 말라 ! 뇌물은 밝은 자의 눈을 어둡게 하고 의로운 자의 말을 굽게 하느니라 ");
INSERT INTO kor_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","너는 이방 나그네를 압제하지 말라 ! 너희가 애굽 땅에서 나그네 되었었은즉 나그네의 정경을 아느니라 ");
INSERT INTO kor_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","너는 육년 동안은 너의 땅에 파종하여 그 소산을 거두고 ");
INSERT INTO kor_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","제 칠년에는 갈지말고 묵여 두어서 네 백성의 가난한 자로 먹게하라 그 남은 것은 들짐승이 먹으리라 너의 포도원과 감람원도 그리할지니라 ");
INSERT INTO kor_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","너는 육일 동안에 네 일을 하고 제 칠일에는 쉬라 네 소와 나귀가 쉴 것이며 네 계집 종의 자식과 나그네가 숨을 돌리리라 ");
INSERT INTO kor_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","내가 네게 이른 모든 일을 삼가 지키고 다른 신들의 이름은 부르지도 말며 네 입에서 들리게도 말지니라 ");
INSERT INTO kor_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","너는 매년 삼차 내게 절기를 지킬지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","너는 무교병의 절기를 지키라 ! 내가 네게 명한대로 아빕월의 정한때에 칠일동안 무교병을 먹을지니 이는 그 달에 네가 애굽에서 나왔음이라 빈 손으로 내게 보이지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","맥추절을 지키라 ! 이는 네가 수고하여 밭에 뿌린 것의 첫 열매를 거둠이니라 수장절을 지키라 ! 이는 네가 수고하여 이룬 것을 연종에 밭에서부터 거두어 저장함이니라 ");
INSERT INTO kor_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","너의 모든 남자는 매년 세번씩 주 여호와께 보일지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","너는 내 희생의 피를 유교병과 함께 드리지 말며 내 절기 희생의 기름을 아침까지 남겨 두지 말지니라 ");
INSERT INTO kor_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","너의 토지에서 처음 익은 열매의 첫것을 가져다가 너의 하나님 여호와의 전에 드릴지니라 너는 염소 새끼를 그 어미의 젖으로 삶지 말지니라 ");
INSERT INTO kor_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","내가 사자를 네 앞서 보내어 길에서 너를 보호하여 너로 내가 예비한 곳에 이르게 하리니 ");
INSERT INTO kor_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","너희는 삼가 그 목소리를 청종하고 그를 노엽게 하지 말라 ! 그가 너희 허물을 사하지 아니할 것은 내 이름이 그에게 있음이니라 ");
INSERT INTO kor_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","네가 그 목소리를 잘 청종하고 나의 모든 말대로 행하면 내가 네 원수에게 원수가 되고 네 대적에게 대적이 될지라 ");
INSERT INTO kor_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","나의 사자가 네 앞서가서 너를 아모리 사람과, 헷 사람과, 브리스 사람과, 가나안 사람과, 히위 사람과, 여부스 사람에게로 인도하고 나는 그들을 끊으리니 ");
INSERT INTO kor_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","너는 그들의 신을 숭배하지 말며 섬기지 말며 그들의 소위를 본받지 말며 그것들을 다 훼파하며 그 주상을 타파하고 ");
INSERT INTO kor_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","너의 하나님 여호와를 섬기라 ! 그리하면 여호와가 너희의 양식과 물에 복을 내리고 너희 중에 병을 제하리니 ");
INSERT INTO kor_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","네 나라에 낙태하는 자가 없고 잉태치 못하는 자가 없을 것이라 내가 너의 날 수를 채우리라 ");
INSERT INTO kor_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","내가 내 위엄을 네 앞서 보내어 너의 이를 곳의 모든 백성을 파하고 너의 모든 원수로 너를 등지게 할 것이며 ");
INSERT INTO kor_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","내가 왕벌을 네 앞에 보내리니 그 벌이 히위 족속과, 가나안 족속과, 헷 족속을 네 앞에서 쫓아내리라 ");
INSERT INTO kor_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","그러나 그 땅이 황무하게 되어 들짐승이 번성하여 너희를 해할까 하여 일년 안에는 그들을 네 앞에서 쫓아내지 아니하고 ");
INSERT INTO kor_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","네가 번성하여 그 땅을 기업으로 얻을 때까지 내가 그들을 네 앞에서 조금씩 쫓아내리라 ");
INSERT INTO kor_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","너의 지경을 홍해에서부터 블레셋 바다까지 광야에서부터 하수까지 정하고 그 땅의 거민을 네 앞에서 쫓아낼지라 ");
INSERT INTO kor_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","너는 그들과 그들의 신과 언약하지 말라 ! ");
INSERT INTO kor_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","그들이 네 땅에 머무르지 못할것은 그들이 너로 내게 범죄케 할까 두려움이라 네가 그 신을 섬기면 그것이 너의 올무가 되리라 ");
INSERT INTO kor_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","또 모세에게 이르시되 너는 아론과 나답과 아비후와 이스라엘 장로 칠십인과 함께 여호와에게로 올라와 멀리서 경배하고 ");
INSERT INTO kor_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","너 모세만 여호와에게 가까이 나아오고 그들은 가까이 나아오지 말며 백성은 너와 함께 올라오지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","모세가 와서 여호와의 모든 말씀과 그 모든 율례를 백성에게 고하매 그들이 한 소리로 응답하여 가로되 '여호와의 명하신 모든 말씀을 우리가 준행하리이다 !' ");
INSERT INTO kor_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","모세가 여호와의 모든 말씀을 기록하고 이른 아침에 일어나 산 아래 단을 쌓고 이스라엘 십 이 지파대로 열 두 기둥을 세우고 ");
INSERT INTO kor_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","이스라엘 자손의 청년들을 보내어 번제와 소로 화목제를 여호와께 드리게 하고 ");
INSERT INTO kor_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","모세가 피를 취하여 반은 양푼에 담고, 반은 단에 뿌리고 ");
INSERT INTO kor_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","언약서를 가져 백성에게 낭독하여 들리매 그들이 가로되 `여호와의 모든 말씀을 우리가 준행하리이다' ");
INSERT INTO kor_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","모세가 그 피를 취하여 백성에게 뿌려 가로되 `이는 여호와께서 이 모든 말씀에 대하여 너희와 세우신 언약의 피니라' ");
INSERT INTO kor_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","모세와 아론과, 나답과, 아비후와 이스라엘 장로 칠십인이 올라가서 ");
INSERT INTO kor_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","이스라엘 하나님을 보니 그 발 아래에는 청옥을 편듯하고 하늘 같이 청명하더라 ");
INSERT INTO kor_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","하나님이 이스라엘의 존귀한 자들에게 손을 대지 아니하셨고 그들은 하나님을 보고 먹고 마셨더라 ");
INSERT INTO kor_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","여호와께서 모세에게 이르시되 너는 산에 올라 내게로 와서 거기 있으라 너로 그들을 가르치려고 내가 율법과 계명을 친히 기록한 돌판을 네게 주리라 ");
INSERT INTO kor_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","모세가 그 종자 여호수아와 함께 일어나 하나님의 산으로 올라가며 ");
INSERT INTO kor_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","장로들에게 이르되 `너희는 여기서 우리가 너희에게로 돌아오기까지 기다리라 아론과 훌이 너희와 함께하리니 무릇 일이 있는 자는 그들에게로 나아갈지니라' 하고 ");
INSERT INTO kor_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","모세가 산에 오르매 구름이 산을 가리며 ");
INSERT INTO kor_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","여호와의 영광이 시내산 위에 머무르고 구름이 육일 동안 산을 가리더니 제 칠일에 여호와께서 구름 가운데 모세를 부르시니라 ");
INSERT INTO kor_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","산 위의 여호와의 영광이 이스라엘 자손의 눈에 맹렬한 불 같이 보였고 ");
INSERT INTO kor_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","모세는 구름 속으로 들어가서 산 위에 올랐으며 사십일 사십야를 산에 있으니라 ");
INSERT INTO kor_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","이스라엘 자손에게 명하여 내게 예물을 가져오라 하고 무릇 즐거운 마음으로 내는 자에게서 내게 드리는 것을 너희는 받을지니라 ");
INSERT INTO kor_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","너희가 그들에게서 받을 예물은 이러하니 금과 은과 놋과 ");
INSERT INTO kor_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","청색, 자색, 홍색실과, 가는 베실과, 염소털과, ");
INSERT INTO kor_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","붉은 물 들인 수양의 가죽과, 해달의 가죽과, 조각목과, ");
INSERT INTO kor_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","등유와 관유에 드는 향품과 분향할 향을 만들 향품과 ");
INSERT INTO kor_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","호마노며 에봇과 흉패에 물릴 보석이니라 ");
INSERT INTO kor_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","내가 그들 중에 거할 성소를 그들을 시켜 나를 위하여 짓되 ");
INSERT INTO kor_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","무릇 내가 네게 보이는대로 장막의 식양과 그 기구의 식양을 따라 지을지니라 ");
INSERT INTO kor_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","그들은 조각목으로 궤를 짓되 장이 이 규빗 반, 광이 일 규빗 반, 고가 일 규빗 반이 되게 하고 ");
INSERT INTO kor_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","너는 정금으로 그것을 싸되 그 안팎을 싸고 윗가로 돌아가며 금테를 두르고 ");
INSERT INTO kor_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","금고리 넷을 부어 만들어 그 네 발에 달되 이편에 두 고리요, 저편에 두 고리며 ");
INSERT INTO kor_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","조각목으로 채를 만들고 금으로 싸고 ");
INSERT INTO kor_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","그 채를 궤 양편 고리에 꿰어서 궤를 메게 하며 ");
INSERT INTO kor_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","채를 궤의 고리에 꿴대로 두고 빼어내지 말지며 ");
INSERT INTO kor_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","내가 네게 줄 증거판을 궤 속에 둘지며 ");
INSERT INTO kor_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","정금으로 속죄소를 만들되 장이 이 규빗 반,광이 일 규빗 반이 되게 하고 ");
INSERT INTO kor_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","금으로 그룹 둘을 속죄소 두 끝에 쳐서 만들되 ");
INSERT INTO kor_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","한 그룹은 이 끝에,한 그룹은 저 끝에 곧 속죄소 두 끝에 속죄소와 한 덩이로 연하게 할지며 ");
INSERT INTO kor_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","그룹들은 그 날개를 높이 펴서 그 날개로 속죄소를 덮으며 그 얼굴을 서로 대하여 속죄소를 향하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","속죄소를 궤 위에 얹고 내가 네게 줄 증거판을 궤 속에 넣으라 ");
INSERT INTO kor_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","거기서 내가 너와 만나고 속죄소 위 곧 증거궤 위에 있는 두 그룹 사이에서 내가 이스라엘 자손을 위하여 네게 명할 모든 일을 네게 이르리라 ");
INSERT INTO kor_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","너는 조각목으로 상을 만들되 장이 이 규빗, 광이 일 규빗, 고가 일 규빗 반이 되게 하고 ");
INSERT INTO kor_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","정금으로 싸고 주위에 금테를 두르고 ");
INSERT INTO kor_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","그 사면에 손바닥 넓이만한 턱을 만들고 그 턱 주위에 금으로 테를 만들고 ");
INSERT INTO kor_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","그것을 위하여 금고리 넷을 만들어 네 발위 네 모퉁이에 달되 ");
INSERT INTO kor_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","턱 곁에 달라 이는 상 멜 채를 꿸 곳이며 ");
INSERT INTO kor_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","또 조각목으로 그 채를 만들고 금으로 싸라 상을 이것으로 멜 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","너는 대접과, 숟가락과, 병과 붓는 잔을 만들되 정금으로 만들지며 ");
INSERT INTO kor_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","상 위에 진설병을 두어 항상 내 앞에 있게 할지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","너는 정금으로 등대를 쳐서 만들되 그 밑판과, 줄기와, 잔과, 꽃받침과, 꽃을 한 덩이로 연하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","가지 여섯을 등대 곁에서 나오게 하되 그 세 가지는 이편으로 나오고 그 세 가지는 저편으로 나오게 하며 ");
INSERT INTO kor_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","이편 가지에 살구 꽃 형상의 잔 셋과 꽃받침과 꽃이 있게 하고 저편 가지에도 살구꽃 형상의 잔 셋과 꽃받침과 꽃이 있게 하여 등대에서 나온 여섯 가지를 같게 할지며 ");
INSERT INTO kor_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","등대 줄기에는 살구꽃 형상의 잔 넷과 꽃받침과 꽃이 있게 하고 ");
INSERT INTO kor_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","등대에서 나온 여섯 가지를 위하여 꽃받침이 있게 하되 두 가지 아래 한 꽃받침이 있어 줄기와 연하게 하며 또 두 가지 아래 한 꽃받침이 있어 줄기와 연하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","그 꽃받침과 가지를 줄기와 연하게 하여 전부를 정금으로 쳐 만들고 ");
INSERT INTO kor_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","등잔 일곱을 만들어 그 위에 두어 앞을 비추게 하며 ");
INSERT INTO kor_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","그 불집게와 불똥 그릇도 정금으로 만들지니 ");
INSERT INTO kor_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","등대와 이 모든 기구를 정금 한 달란트로 만들되 ");
INSERT INTO kor_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","너는 삼가 이 산에서 네게 보인 식양대로 할지니라 ");
INSERT INTO kor_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","너는 성막을 만들되 앙장 열 폭을 가늘게 꼰 베실과, 청색, 자색, 홍색실로 그룹을 공교히 수 놓아 만들지니 ");
INSERT INTO kor_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","매 폭의 장은 이십 팔 규빗,광은 사 규빗으로 각 폭의 장단을 같게 하고 ");
INSERT INTO kor_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","그 앙장 다섯 폭을 서로 연하며, 다른 다섯 폭도 서로 연하고 ");
INSERT INTO kor_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","그 앙장의 연락할 말폭 가에 청색 고를 만들며, 다른 연락할 말폭가에도 그와 같이 하고 ");
INSERT INTO kor_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","앙장 말폭 가에 고 오십을 달며, 다른 앙장 말폭 가에도 고 오십을 달고 그 고들을 서로 대하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","금 갈고리 오십을 만들고, 그 갈고리로 앙장을 연합하여 한 성막을 이룰지며 ");
INSERT INTO kor_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","그 성막을 덮는 막 곧 앙장을 염소털로 만들되 열 한폭을 만들지며 ");
INSERT INTO kor_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","각 폭의 장은 삼십 규빗,광은 사 규빗으로 열 한폭의 장단을 같게 하고 ");
INSERT INTO kor_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","그 앙장 다섯 폭을 서로 연하며, 또 여섯 폭을 서로 연하고, 그 여섯째 폭 절반은 성막 전면에 접어 드리우고 ");
INSERT INTO kor_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","앙장을 연락할 말폭 가에 고 오십을 달며, 다른 연락할 말폭 가에도 고 오십을 달고 ");
INSERT INTO kor_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","놋 갈고리 오십을 만들고, 그 갈고리로 그 고를 꿰어 연합하여 한 막이 되게 하고 ");
INSERT INTO kor_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","그 막 곧 앙장의 나머지 그 반폭은 성막 뒤에 드리우고 ");
INSERT INTO kor_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","막 곧 앙장의 길이의 남은 것은 이편에 한 규빗,저편에 한 규빗씩 성막 좌우 양편에 덮어 드리우고 ");
INSERT INTO kor_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","붉은 물 들인 수양의 가죽으로 막의 덮개를 만들고, 해달의 가죽으로 그 웃덮개를 만들지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","너는 조각목으로 성막을 위하여 널판을 만들어 세우되 ");
INSERT INTO kor_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","각 판의 장은 십 규빗,광은 일 규빗 반으로 하고 ");
INSERT INTO kor_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","각 판에 두 촉씩 내어 서로 연하게 하되 너는 성막 널판을 다 그와 같이 하라 ");
INSERT INTO kor_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","너는 성막을 위하여 널판을 만들되, 남편을 위하여 널판 스물을 만들고 ");
INSERT INTO kor_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","스무 널판 아래 은받침 마흔을 만들지니 이 널판 아래에도 그 두촉을 위하여 두 받침을 만들고 저 널판 아래에도 그 두 촉을 위하여 두 받침을 만들지라 ");
INSERT INTO kor_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","성막 다른 편 곧 그 북편을 위하여도 널판 스물로 하고 ");
INSERT INTO kor_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","은받침 마흔을 이 널판 아래에도 두 받침,저 널판 아래에도 두 받침으로 하며 ");
INSERT INTO kor_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","성막 뒤 곧 그 서편을 위하여는 널판 여섯을 만들고 ");
INSERT INTO kor_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","성막 뒤 두 모퉁이 편을 위하여는 널판 둘을 만들되 ");
INSERT INTO kor_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","아래에서부터 위까지 각기 두겹 두께로 하여 윗고리에 이르게 하고 두 모퉁이 편을 다 그리하며 ");
INSERT INTO kor_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","그 여덟 널판에는 은받침이 열 여섯이니 이 판 아래에도 두 받침이요, 저 판 아래에도 두 받침이니라 ");
INSERT INTO kor_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","너는 조각목으로 띠를 만들지니 성막 이편 널판을 위하여 다섯이요 ");
INSERT INTO kor_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","성막 저편 널판을 위하여 다섯이요, 성막 뒤 곧 서편 널판을 위하여 다섯이요, ");
INSERT INTO kor_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","널판 가운데 있는 중간 띠는 이 끝에서 저 끝에 미치게 하고 ");
INSERT INTO kor_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","그 널판들을 금으로 싸고 그 널판들의 띠를 꿸 금고리를 만들고 그 띠를 금으로 싸라 ");
INSERT INTO kor_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","너는 산에서 보인 식양대로 성막을 세울지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","너는 청색 자색 홍색실과 가늘게 꼰 베실로 짜서 장을 만들고 그 위에 그룹들을 공교히 수 놓아서 ");
INSERT INTO kor_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","금 갈고리로 네 기둥 위에 드리우되 그 네 기둥을 조각목으로 만들고 금으로 싸서 네 은받침 위에 둘지며 ");
INSERT INTO kor_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","그 장을 갈고리 아래 드리운 후에 증거궤를 그 장안에 들여 놓으라 그 장이 너희를 위하여 성소와 지성소를 구별하리라 ");
INSERT INTO kor_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","너는 지성소에 있는 증거궤 위에 속죄소를 두고 ");
INSERT INTO kor_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","그 장 바깥 북편에 상을 놓고 남편에 등대를 놓아 상과 대하게 할지며 ");
INSERT INTO kor_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","청색, 자색, 홍색실과, 가늘게 꼰 베실로 수 놓아 짜서 성막 문을 위하여 장을 만들고 ");
INSERT INTO kor_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","그 문장을 위하여 기둥 다섯을 조각목으로 만들어 금으로 싸고 그 갈고리도 금으로 만들찌며 또 그 기둥을 위하여 받침 다섯을 놋으로 부어 만들지니라 ");
INSERT INTO kor_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","너는 조각목으로 장이 오 규빗, 광이 오 규빗의 단을 만들되 네모 반듯하게 하며 고는 삼 규빗으로 하고 ");
INSERT INTO kor_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","그 네 모퉁이 위에 뿔을 만들되 그 뿔이 그것에 연하게 하고 그 단을 놋으로 쌀지며 ");
INSERT INTO kor_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","재를 담는 통과, 부삽과, 대야와, 고기 갈고리와, 불 옮기는 그릇을 만들되 단의 그릇을 다 놋으로 만들지며 ");
INSERT INTO kor_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","단을 위하여 놋으로 그물을 만들고 그 위 네 모퉁이에 놋고리 넷을 만들고 ");
INSERT INTO kor_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","그물은 단 사면 가장자리 아래 곧 단 절반에 오르게 할지며 ");
INSERT INTO kor_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","또 그 단을 위하여 채를 만들되 조각목으로 만들고 놋으로 쌀지며 ");
INSERT INTO kor_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","단 양편 고리에 그 채를 꿰어 단을 메게 할지며 ");
INSERT INTO kor_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","단은 널판으로 비게 만들되 산에서 네게 보인대로 그들이 만들지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","너는 성막의 뜰을 만들찌니 남을 향하여 뜰 남편에 광이 백 규빗의 세마포장을 쳐서 그 한 편을 당하게 할지니 ");
INSERT INTO kor_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","그 기둥이 스물이며 그 받침 스물은 놋으로 하고 그 기둥의 갈고리와 가름대는 은으로 할찌며 ");
INSERT INTO kor_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","그 북편에도 광이 백 규빗의 포장을 치되 그 기둥이 스물이며 그 기둥의 받침 스물은 놋으로 하고 그 기둥의 갈고리와 가름대는 은으로 할지며 ");
INSERT INTO kor_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","뜰의 옆 곧 서편에 광 오십 규빗의 포장을 치되 그 기둥이 열이요, 받침이 열이며 ");
INSERT INTO kor_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","동을 향하여 뜰 동편의 광도 오십 규빗이 될지며 ");
INSERT INTO kor_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","문 이편을 위하여 포장이 십 오 규빗이며, 그 기둥이 셋이요, 받침이 셋이요 ");
INSERT INTO kor_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","문 저편을 위하여도 포장이 십오 규빗이며, 그 기둥이 셋이요, 받침이 셋이며 ");
INSERT INTO kor_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","뜰 문을 위하여는 청색, 자색, 홍색실과, 가늘게 꼰 베실로 수 놓아 짠 이십 규빗의 장이 있게 할지니 그 기둥이 넷이요, 받침이 넷이며 ");
INSERT INTO kor_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","뜰 사면 모든 기둥의 가름대와 갈고리는 은이요, 그 받침은 놋이며 ");
INSERT INTO kor_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","뜰의 장은 백 규빗이요, 광은 오십 규빗이요, 세마포장의 고는 오규빗이요, 그 받침은 놋이며 ");
INSERT INTO kor_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","성막에서 쓰는 모든 기구와 그 말뚝과 뜰의 포장 말뚝을 다 놋으로 할지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","너는 또 이스라엘 자손에게 명하여 감람으로 찧어낸 순결한 기름을 등불을 위하여 네게로 가져오게 하고 끊이지 말고 등불을 켜되 ");
INSERT INTO kor_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","아론과 그 아들들로 회막한 증거궤 앞 휘장 밖에서 저녁부터 아침까지 항상 여호와 앞에 그 등불을 간검하게 하라 ! 이는 이스라엘 자손의 대대로 영원한 규례니라 ");
INSERT INTO kor_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","너는 이스라엘 자손 중 네 형 아론과 그 아들들 곧 나답과, 아비후와, 엘르아살과, 이다말을 그와 함께 네게로 나아오게 하여 나를 섬기는 제사장 직분을 행하게 하되 ");
INSERT INTO kor_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","네 형 아론을 위하여 거룩한 옷을 지어서 영화롭고 아름답게 할지니 ");
INSERT INTO kor_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","너는 무릇 마음에 지혜 있는자, 곧 내가 지혜로운 영으로 채운 자들에게 말하여 아론의 옷을 지어 그를 거룩하게 하여 내게 제사장 직분을 행하게 하라 ");
INSERT INTO kor_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","그들의 지을 옷은 이러하니 곧 흉패와, 에봇과, 겉옷과, 반포 속옷과, 관과, 띠라 그들이 네 형 아론과 그 아들들을 위하여 거룩한 옷을 지어 아론으로 내게 제사장 직분을 행하게 할지며 ");
INSERT INTO kor_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","그들의 쓸것은 금실과, 청색, 자색, 홍색실과, 가늘게 꼰 베실이니라 ");
INSERT INTO kor_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","그들이 금실과, 청색, 자색, 홍색실과, 가늘게 꼰 베실로 공교히 짜서 에봇을 짓되 ");
INSERT INTO kor_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","그것에 견대 둘을 달아 그 두 끝을 연하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","에봇 위에 매는 띠는 에봇 짜는 법으로 금실과, 청색, 자색, 홍색실과, 가늘게 꼰 베실로 에봇에 공교히 붙여 짤지며 ");
INSERT INTO kor_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","호마노 두개를 취하여 그 위에 이스라엘 아들들의 이름을 새기되 ");
INSERT INTO kor_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","그들의 연치대로 여섯 이름을 한 보석에 나머지 여섯 이름은 다른 보석에 ");
INSERT INTO kor_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","보석을 새기는 자가 인에 새김 같이 너는 이스라엘 아들들의 이름을 그 두 보석에 새겨 금테에 물리고 ");
INSERT INTO kor_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","그 두 보석을 에봇 두 견대에 붙여 이스라엘 아들들의 기념 보석을 삼되 아론이 여호와 앞에서 그들의 이름을 그 두 어깨에 메어서 기념이 되게 할지며 ");
INSERT INTO kor_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","너는 금으로 테를 만들고 ");
INSERT INTO kor_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","정금으로 노끈처럼 두 사슬을 땋고 그 땋은 사슬을 그 테에 달지니라 ");
INSERT INTO kor_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","너는 판결 흉패를 에봇 짜는 법으로 금실과, 청색, 자색, 홍색실과, 가늘게 꼰 베실로 공교히 짜서 만들되 ");
INSERT INTO kor_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","장광이 한뼘씩 두 겹으로 네모 반듯하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","그것에 네 줄로 보석을 물리되 첫 줄은 홍보석, 황옥, 녹주옥이요, ");
INSERT INTO kor_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","둘째 줄은 석류석, 남보석, 홍마노요, ");
INSERT INTO kor_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","세째 줄은 호박, 백마노, 자수정이요, ");
INSERT INTO kor_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","네째 줄은 녹보석, 호마노, 벽옥으로 다 금테에 물릴지니 ");
INSERT INTO kor_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","이 보석들은 이스라엘 아들들의 이름대로 열 둘이라 매 보석에 열두 지파의 한 이름씩 인을 새기는 법으로 새기고 ");
INSERT INTO kor_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","정금으로 노끈처럼 땋은 사슬을 흉패 위에 붙이고 ");
INSERT INTO kor_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","또 금고리 둘을 만들어 흉패 위 곧 흉패 두 끝에 그 두 고리를 달고 ");
INSERT INTO kor_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","땋은 두 금사슬로 흉패 두 끝 두 고리에 꿰어 매고 ");
INSERT INTO kor_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","두 땋은 사슬의 다른 두 끝을 에봇 앞 두 견대의 금테에 매고 ");
INSERT INTO kor_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","또 금고리 둘을 만들어 흉패 아래 양편 가 안쪽 곧 에봇에 닿은 곳에 달고 ");
INSERT INTO kor_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","또 금고리 둘을 만들어 에봇 앞 두 견대 아래 매는 자리 가까운편 곧 공교히 짠 띠 윗편에 달고 ");
INSERT INTO kor_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","청색 끈으로 흉패 고리와 에봇 고리에 꿰어 흉패로 공교히 짠 에봇 띠 위에 붙여 떠나지 않게 하라 ");
INSERT INTO kor_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","아론이 성소에 들어갈 때에는 이스라엘 아들들의 이름을 기록한 이 판결흉패를 가슴에 붙여 여호와 앞에 영원한 기념을 삼을 것이니라 ");
INSERT INTO kor_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","너는 우림과 둠밈을 판결 흉패 안에 넣어 아론으로 여호와 앞에 들어 갈 때에 그 가슴 위에 있게 하라 아론이 여호와 앞에서 이스라엘 자손의 판결을 항상 그 가슴 위에 둘지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","너는 에봇 받침 겉옷을 전부 청색으로 하되 ");
INSERT INTO kor_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","두 어깨 사이에 머리 들어갈 구멍을 내고 그 주위에 갑옷 깃 같이 깃을 짜서 찢어지지 않게 하고 ");
INSERT INTO kor_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","그 옷 가장자리로 돌아가며 청색, 자색, 홍색실로 석류를 수놓고 금방울을 간격하여 달되 ");
INSERT INTO kor_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","그 옷 가장자리로 돌아가며 한 금방울 한 석류, 한 금방울 한 석류가 있게 하라 ");
INSERT INTO kor_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","아론이 입고 여호와를 섬기러 성소에 들어갈 때와 성소에서 나갈때에 그 소리가 들릴 것이라 그리하면 그가 죽지 아니하리라 ! ");
INSERT INTO kor_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","너는 또 정금으로 패를 만들어 인을 새기는 법으로 그 위에 새기되 여호와께 성결이라 하고 ");
INSERT INTO kor_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","그 패를 청색 끈으로 관 위에 매되 곧 전면에 있게 하라 ");
INSERT INTO kor_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","이 패가 아론의 이마에 있어서 그로 이스라엘 자손의 거룩하게 드리는 성물의 죄건을 담당하게 하라 그 패가 아론의 이마에 늘 있으므로 그 성물을 여호와께서 받으시게 되리라 ");
INSERT INTO kor_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","너는 가는 베실로 반포 속옷을 짜고 가는 베실로 관을 만드고 띠를 수 놓아 만들지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","너는 아론의 아들들을 위하여 속옷을 만들며 그들을 위하여 띠를 만들며 그들을 위하여 관을 만들어서 영화롭고 아름답게 하되 ");
INSERT INTO kor_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","너는 그것들로 네 형 아론과 그와 함께한 그 아들들에게 입히고 그들에게 기름을 부어 위임하고 거룩하게 하여 그들로 제사장 직분을 내게 행하게 할지며 ");
INSERT INTO kor_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","또 그들을 위하여 베로 고의를 만들어 허리에서부터 넓적다리까지 이르게 하여 하체를 가리게 하라 ");
INSERT INTO kor_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","아론과 그 아들들이 회막에 들어갈 때에나 제단에 가까이 하여 거룩한 곳에서 섬길 때에 그것들을 입어야 죄를 지어서 죽지 아니하리니 그와 후손의 영원히 지킬 규례니라 ");
INSERT INTO kor_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","너는 그들에게 나를 섬길 제사장 직분을 위임하여 그들로 거룩하게 할 일이 이러하니 곧 젊은 수소 하나와, 흠 없는 수양 둘을 취하고 ");
INSERT INTO kor_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","무교병과, 기름 섞인 무교 과자와, 기름 바른 무교 전병을 모두 고운 밀가루로 만들고 ");
INSERT INTO kor_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","그것들을 한 광주리에 담고 그것을 광주리에 담은 채 그 송아지와 두 양과 함께 가져 오고 ");
INSERT INTO kor_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","너는 아론과 그 아들들을 회막 문으로 데려다가 물로 씻기고 ");
INSERT INTO kor_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","의복을 가져다가 아론에게 속옷과, 에봇 받침 겉옷과, 에봇을 입히고 흉패를 달고 에봇에 공교히 짠 띠를 띠우고 ");
INSERT INTO kor_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","그 머리에 관을 씌우고 그 위에 성패를 더하고 ");
INSERT INTO kor_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","관유를 가져다가 그 머리에 부어 바르고 ");
INSERT INTO kor_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","그 아들들을 데려다가 그들에게 속옷을 입히고 ");
INSERT INTO kor_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","아론과 그 아들들에게 띠를 띠우며 관을 씌워서 제사장의 직분을 그들에게 맡겨 영원한 규례가 되게 하라 너는 이같이 아론과 그 아들들에게 위임하여 거룩하게 할지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","너는 수송아지를 회막 앞으로 끌어 오고 아론과 그 아들들은 그 송아지 머리에 안수할지며 ");
INSERT INTO kor_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","너는 회막문 여호와 앞에서 그 송아지를 잡고 ");
INSERT INTO kor_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","그 피를 네 손가락으로 단 뿔들에 바르고 그 피 전부를 단 밑에 쏟을지며 ");
INSERT INTO kor_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","내장에 덮인 모든 기름과 간 위에 있는 꺼풀과, 두 콩팥과, 그 위의 기름을 취하여 단 위에 불사르고 ");
INSERT INTO kor_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","그 수소의 고기와 가죽과 똥은 진 밖에서 불사르라 ! 이는 속죄제니라 ");
INSERT INTO kor_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","너는 또 수양 하나를 취하고 아론과 그 아들들은 그 수양의 머리위에 안수할지며 ");
INSERT INTO kor_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","너는 그 수양을 잡고 그 피를 취하여 단 위의 주위에 뿌리고 ");
INSERT INTO kor_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","그 수양의 각을 뜨고 그 장부와 다리는 씻어 각 뜬 고기와 그 머리와 함께 두고 ");
INSERT INTO kor_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","그 수양의 전부를 단 위에 불사르라 ! 이는 여호와께 드리는 번제요 이는 향기로운 냄새니 여호와께 드리는 화제니라 ");
INSERT INTO kor_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","너는 다른 수양을 취하고 아론과 그 아들들은 그 수양의 머리 위에 안수할지며 ");
INSERT INTO kor_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","너는 그 수양을 잡고 그 피를 취하여 아론의 오른 귓부리와, 그 아들들의 오른 귓부리에 바르고, 그 오른손 엄지와, 오른발 엄지에 바르고 그 피를 단 주위에 뿌리고 ");
INSERT INTO kor_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","단 위의 피와 관유를 취하여 아론과, 그 옷과, 그 아들들과, 그 아들들의 옷에 뿌리라 그와, 그 옷과, 그 아들들과, 그 아들들의 옷이 거룩하리라 ");
INSERT INTO kor_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","또 너는 그 수양의 기름과 기름진 꼬리와 그 내장에 덮인 기름과 간 위의 꺼풀과 두 콩팥과 그것들 위의 기름과 우편 넓적다리를 취하라 ! 이는 위임식의 수양이며 ");
INSERT INTO kor_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","또 여호와 앞에 있는 무교병 광주리에서 떡 한 덩이와 기름 바른 과자 하나와 전병 하나를 취하고 ");
INSERT INTO kor_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","그 전부를 아론의 손과 그 아들들의 손에 주고 그것을 흔들어 여호와 앞에 요제를 삼을지며 ");
INSERT INTO kor_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","너는 그것을 그들의 손에서 취하여 단 위에서 번제물을 더하여 불사르라 ! 이는 여호와 앞에 향기로운 냄새니 곧 여호와께 드리는 화제니라 ");
INSERT INTO kor_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","너는 위임식 수양의 가슴을 취하여 여호와 앞에 흔들어 요제를 삼으라 ! 이는 너의 분깃이니라 ");
INSERT INTO kor_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","너는 그 흔든 요제물 곧 아론과 그 아들들의 위임식 수양의 가슴과 넓적다리를 거룩하게 하라 ");
INSERT INTO kor_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","이는 이스라엘 자손이 아론과 그 자손에게 돌릴 영원한 분깃이요, 거제물이니 곧 이스라엘 자손이 화목제의 희생 중에서 취한 거제물로서 여호와께 드리는 거제물이니라 ");
INSERT INTO kor_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","아론의 성의는 아론의 후에 그 아들들에게 돌릴지니 그들이 그것을 입고 기름 부음으로 위임을 받을 것이며 ");
INSERT INTO kor_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","그를 이어 제사장이 되는 아들이 회막에 들어가서 성소에서 섬길때에는 칠일 동안 그것을 입을지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","너는 위임식 수양을 취하여 거룩한 곳에서 그 고기를 삶고 ");
INSERT INTO kor_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","아론과 그 아들들이 회막문에서 그 수양의 고기와 광주리에 있는 떡을 먹을찌라 ");
INSERT INTO kor_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","속죄물 곧 그들을 위임하며 그들은 거룩하게 하는데 쓰는것은 그들은 먹되 타인은 먹지 못할지니 이는 성물이 됨이며 ");
INSERT INTO kor_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","위임식 고기나 떡이 아침까지 남았으면 그것을 불에 사를지니 이는 거룩한즉 먹지 못할지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","너는 내가 무릇 네게 명한대로 아론과 그 아들들에게 그같이 하여 칠일동안 위임식을 행하되 ");
INSERT INTO kor_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","매일 수송아지 하나로 속죄하기 위하여 속죄제를 드리며 또 단을 위하여 깨끗케 하고 그것에 기름을 부어 거룩하게 하라 ");
INSERT INTO kor_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","네가 칠일 동안 단을 위하여 속죄하여 거룩하게 하라 ! 그리하면 지극히 거룩한 단이 되리니 무릇 단에 접촉하는 것이 거룩하리라 ");
INSERT INTO kor_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","네가 단 위에 드릴 것은 이러하니라 매일 일년 된 어린 양 두 마리니 ");
INSERT INTO kor_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","한 어린 양은 아침에 드리고, 한 어린 양은 저녁 때에 드릴지며 ");
INSERT INTO kor_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","한 어린 양에 고운 밀가루 에바 십분 일과, 찧은 기름 힌의 사분 일을 더하고 또 전제로 포도주 힌의 사분 일을 더할지며 ");
INSERT INTO kor_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","한 어린 양은 저녁 때에 드리되 아침과 일반으로 소제와 전제를 그것과 함께 드려 향기로운 냄새가 되게 하여 여호와께 화제를 삼을지니 ");
INSERT INTO kor_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","이는 너희가 대대로 여호와 앞 회막문에서 늘 드릴 번제라 내가 거기서 너희와 만나고 네게 말하리라 ");
INSERT INTO kor_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","내가 거기서 이스라엘 자손을 만나리니 내 영광을 인하여 회막이 거룩하게 될지라 ! ");
INSERT INTO kor_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","내가 그 회막과 단을 거룩하게 하며 아론과 그 아들들도 거룩하게 하여 내게 제사장 직분을 행하게 하며 ");
INSERT INTO kor_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","내가 이스라엘 자손 중에 거하여 그들의 하나님이 되리니 ");
INSERT INTO kor_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","그들은 내가 그들의 하나님 여호와로서 그들 중에 거하려고 그들을 애굽 땅에서 인도하여 낸 줄을 알리라 나는 그들의 하나님 여호와니라 ");
INSERT INTO kor_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","너는 분향할 단을 만들지니 곧 조각목으로 만들되 ");
INSERT INTO kor_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","장이 일 규빗,광이 일 규빗으로 네모 반듯하게 하고 고는 이 규빗으로 하며 그 뿔을 그것과 연하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","단 상면과 전후 좌우면과 뿔을 정금으로 싸고 주위에 금테를 두를지며 ");
INSERT INTO kor_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","금테 아래 양편에 금고리 둘을 만들되 곧 그 양편에 만들지니 이는 단을 메는 채를 꿸 곳이며 ");
INSERT INTO kor_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","그 채를 조각목으로 만들고 금으로 싸고 ");
INSERT INTO kor_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","그 단을 증거궤 위 속죄소 맞은편 곧 증거궤 앞에 있는 장 밖에 두라 그 속죄소는 내가 너와 만날 곳이며 ");
INSERT INTO kor_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","아론이 아침마다 그 위에 향기로운 향을 사르되 등불을 정리할 때에 사를지며 ");
INSERT INTO kor_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","또 저녁때 등불을 켤때에 사를지니 이향은 너희가 대대로 여호와앞에 끊지 못할지며 ");
INSERT INTO kor_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","너희는 그 위에 다른 향을 사르지 말며 번제나 소제를 드리지 말며 전제의 술을 붓지 말며 ");
INSERT INTO kor_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","아론이 일년 일차씩 이 향단 뿔을 위하여 속죄하되 속죄제의 피로 일년 일차씩 대대로 속죄할지니라 ! 이 단은 여호와께 지극히 거룩하니라 ");
INSERT INTO kor_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","네가 이스라엘 자손의 수효를 따라 조사할 때에 조사 받은 각 사람은 그 생명의 속전을 여호와께 드릴지니 이는 그 계수할 때에 그들 중에 온역이 없게 하려 함이라 ");
INSERT INTO kor_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","무릇 계수 중에 드는 자마다 성소에 세겔대로 반 세겔을 낼지니 한 세겔은 이 십 게라라 그 반 세겔을 여호와께 드릴지며 ");
INSERT INTO kor_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","무릇 계수 중에 드는 자 곧 이십세 이상 된 자가 여호와께 드리되 ");
INSERT INTO kor_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","너희의 생명을 속하기 위하여 여호와께 드릴 때에 부자라고 반 세겔에서 더 내지 말고, 가난한 자라고 덜 내지 말지며 ");
INSERT INTO kor_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","너는 이스라엘 자손에게서 속전을 취하여 회막의 봉사에 쓰라 이것이 여호와 앞에서 이스라엘 자손의 기념이 되어서 너희의 생명을 속하리라 ");
INSERT INTO kor_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","너는 물두멍을 놋으로 만들어 씻게 하되 그것을 회막과 단 사이에 두고 그 속에 물을 담으라 ");
INSERT INTO kor_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","아론과 그 아들들이 그 두멍에서 수족을 씻되 ");
INSERT INTO kor_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","그들이 회막에 들어갈 때에 물로 씻어 죽기를 면할 것이요 단에 가까이 가서 그 직분을 행하여 화제를 여호와 앞에 사를 때에도 그리할지니라 ");
INSERT INTO kor_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","이와 같이 그들이 그 수족을 씻어 죽기를 면할지니 이는 그와 그 자손이 대대로 영원히 지킬 규례니라 ");
INSERT INTO kor_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","여호와께서 모세에게 또 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","너는 상등 향품을 취하되 액체 몰약 오백 세겔과, 그 반수의 향기로운 육계 이백 오십세겔과, 향기로운 창포 이백 오십세겔과, ");
INSERT INTO kor_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","계피 오백 세겔을 성소의 세겔대로 하고 감람 기름 한 힌을 취하여 ");
INSERT INTO kor_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","그것으로 거룩한 관유를 만들되 향을 제조하는 법대로 향기름을 만들지니 그것이 거룩한 관유가 될지라 ");
INSERT INTO kor_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","너는 그것으로 회막과 증거궤에 바르고 ");
INSERT INTO kor_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","상과 그 모든 기구며 등대와 그 기구며 분향단과 ");
INSERT INTO kor_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","및 번제단과 그 모든 기구와 물두멍과 그 받침에 발라 ");
INSERT INTO kor_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","그것들을 지성물로 구별하라 ! 무릇 이것에 접촉하는 것이 거룩하리라 ");
INSERT INTO kor_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","너는 아론과 그 아들들에게 기름을 발라 그들을 거룩하게 하고 그들로 내게 제사장 직분을 행하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","이스라엘 자손에게 고하여 이르기를 이것은 너희 대대로 내게 거룩한 관유니 ");
INSERT INTO kor_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","사람의 몸에 붓지 말며 이 방법대로 이와 같은 것을 만들지 말라 이는 거룩하니 너희는 거룩히 여기라 ");
INSERT INTO kor_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","무릇 이와 같은 것을 만드는 자나 무릇 이것을 타인에게 붓는 자는 그 백성중에서 끊쳐지리라 하라 ");
INSERT INTO kor_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","여호와께서 모세에게 이르시되 너는 소합향과, 나감향과, 풍자향의 향품을 취하고 그 향품을 유향에 섞되 각기 동일한 중수로 하고 ");
INSERT INTO kor_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","그것으로 향을 만들되 향 만드는 법대로 만들고 그것에 소금을 쳐서 성결하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","그 향 얼마를 곱게 찧어 내가 너와 만날 회막 안 증거궤 앞에 두라 이 향은 너희에게 지극히 거룩하니라 ! ");
INSERT INTO kor_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","네가 만들 향은 여호와를 위하여 거룩한 것이니 그 방법대로 너희를 위하여 만들지 말라 ! ");
INSERT INTO kor_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","무릇 맡으려고 이같은 것을 만드는 자는 그 백성 중에서 끊쳐지리라 ");
INSERT INTO kor_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","내가 유다 지파 훌의 손자요 우리의 아들인 브사렐을 지명하여 부르고 ");
INSERT INTO kor_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","하나님의 신을 그에게 충만하게 하여 지혜와 총명과 지식과 여러가지 재주로 ");
INSERT INTO kor_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","공교한 일을 연구하여 금과 은과 놋으로 만들게 하며 ");
INSERT INTO kor_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","보석을 깍아 물리며 나무를 새겨서 여러가지 일을 하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","내가 또 단 지파 아히사막의 아들 오홀리압을 세워 그와 함께 하게 하며 무릇 지혜로운 마음이 있는 자에게 내가 지혜를 주어 그들로 내가 네게 명한 것을 다 만들게 할지니 ");
INSERT INTO kor_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","곧 회막과, 증거궤와, 그 위의 속죄소와, 회막의 모든 기구와 ");
INSERT INTO kor_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","상과, 그 기구와, 정금 등대와, 그 모든 기구와, 분향단과 ");
INSERT INTO kor_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","번제단과, 그 모든 기구와, 물두멍과, 그 받침과 ");
INSERT INTO kor_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","제사직을 행할 때에 입는 공교히 짠 의복 곧 제사장 아론의 성의와 그 아들들의 옷과 ");
INSERT INTO kor_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","관유와 성소의 향기로운 향이라 무릇 내가 네게 명한대로 그들이 만들지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","너는 이스라엘 자손에게 고하여 이르기를 너희는 나의 안식일을 지키라 ! 이는 나와 너희 사이에 너희 대대의 표징이니 나는 너희를 거룩하게 하는 여호와인 줄 너희로 알게 함이라 ");
INSERT INTO kor_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","너희는 안식일을 지킬지니 이는 너희에게 성일이 됨이라 무릇 그날에 일하는 자는 그 백성 중에서 그 생명이 끊쳐지리라 ");
INSERT INTO kor_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","엿새 동안은 일할 것이나 제 칠일은 큰 안식일이니 여호와께 거룩한 것이라 무릇 안식일에 일하는 자를 반드시 죽일지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","이같이 이스라엘 자손이 안식일을 지켜서 그것으로 대대로 영원한 언약을 삼을 것이니 ");
INSERT INTO kor_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","이는 나와 이스라엘 자손 사이에 영원한 표징이며 나 여호와가 엿새 동안에 천지를 창조하고 제 칠일에 쉬어 평안하였음이니라 하라 ");
INSERT INTO kor_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","여호와께서 시내산 위에서 모세에게 이르시기를 마치신 때에 증거판 둘을 모세에게 주시니 이는 돌판이요 하나님이 친히 쓰신 것이더라 ");
INSERT INTO kor_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","백성이 모세가 산에서 내려옴이 더딤을 보고 모여 아론에게 이르러 가로되 '일어나라 우리를 인도할 신을 우리를 위하여 만들라 이 모세 곧 우리를 애굽 땅에서 인도하여 낸 사람은 어찌 되었는지 알지 못함이라' ");
INSERT INTO kor_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","아론이 그들에게 이르되 `너희 아내와 자녀의 귀의 금고리를 빼어 내게로 가져 오라' ");
INSERT INTO kor_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","모든 백성이 그 귀에서 금고리를 빼어 아론에게로 가져 오매 ");
INSERT INTO kor_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","아론이 그들의 손에서 그 고리를 받아 부어서 각도로 새겨 송아지 형상을 만드니 그들이 말하되 '이스라엘아 ! 이는 너희를 애굽 땅에서 인도하여 낸 너희 신이로다' 하는지라 ");
INSERT INTO kor_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","아론이 보고 그 앞에 단을 쌓고 이에 공포하여 가로되 `내일은 여호와의 절일이니라' 하니 ");
INSERT INTO kor_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","이튿날에 그들이 일찌기 일어나 번제를 드리며 화목제를 드리고 앉아서 먹고 마시며 일어나서 뛰놀더라 ");
INSERT INTO kor_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","여호와께서 모세에게 이르시되 너는 내려가라 네가 애굽 땅에서 인도하여 낸 네 백성이 부패하였도다 ");
INSERT INTO kor_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","그들이 내가 그들에게 명한 길을 속히 떠나 자기를 위하여 송아지를 부어 만들고 그것을 숭배하며 그것에게 희생을 드리며 말하기를 애굽 땅에서 인도하여 낸 너희 신이라 하였도다 ");
INSERT INTO kor_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","여호와께서 또 모세에게 이르시되 내가 이 백성을 보니 목이 곧은 백성이로다 ");
INSERT INTO kor_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","그런즉 나대로 하게 하라 ! 내가 그들에게 진노하여 그들을 진멸하고 너로 큰 나라가 되게 하리라 ");
INSERT INTO kor_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","모세가 그 하나님 여호와께 구하여 가로되 '여호와여 ! 어찌하여 애굽 땅에서 인도하여 내신 주의 백성에게 진노하시나이까 ? ");
INSERT INTO kor_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","어찌하여 애굽 사람으로 이르기를 여호와가 화를 내려 그 백성을 산에서 죽이고 지면에서 진멸하려고 인도하여 내었다 하게 하려 하시나이까 ? 주의 맹렬한 노를 그치시고 뜻을 돌이키사 주의 백성에게 이 화를 내리지 마옵소서 ! ");
INSERT INTO kor_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","주의 종 아브라함과 이삭과 이스라엘을 기억하소서 ! 주께서 주를 가리켜 그들에게 맹세하여 이르시기를 내가 너희 자손을 하늘의 별처럼 많게 하고 나의 허락한 이 온 땅을 너희의 자손에게 주어 영원한 기업이 되게 하리라 하셨나이다' ");
INSERT INTO kor_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","여호와께서 뜻을 돌이키사 말씀하신 화를 그 백성에게 내리지 아니하시니라 ");
INSERT INTO kor_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","모세가 돌이켜 산에서 내려 오는데 증거의 두 판이 그 손에 있고 그 판의 양면 이편 저편에 글자가 있으니 ");
INSERT INTO kor_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","그 판은 하나님이 만드신 것이요, 글자는 하나님이 쓰셔서 판에 새기신 것이더라 ");
INSERT INTO kor_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","여호수아가 백성의 떠듦을 듣고 모세에게 말하되 `진중에서 싸우는 소리가 나나이다' ");
INSERT INTO kor_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","모세가 가로되 `이는 승전가도 아니요, 패하여 부르짖는 소리도 아니라 나의 듣기에는 노래하는 소리로다' 하고 ");
INSERT INTO kor_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","진에 가까이 이르러 송아지와 그 춤 추는 것을 보고 대노하여 손에서 그 판들을 산 아래로 던져 깨뜨리니라 ");
INSERT INTO kor_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","모세가 그들의 만든 송아지를 가져 불살라 부수어 가루를 만들어 물에 뿌려 이스라엘 자손에게 마시우니라 ");
INSERT INTO kor_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","모세가 아론에게 이르되 `이 백성이 네게 어떻게 하였기에 네가 그들로 중죄에 빠지게 하였느뇨 ?' ");
INSERT INTO kor_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","아론이 가로되 `내 주여, 노하지 마소서 이 백성의 악함을 당신이 아나이다 ");
INSERT INTO kor_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","그들이 내게 말하기를 우리를 위하여 우리를 인도할 신을 만들라 이 모세 곧 우리를 애굽 땅에서 인도하여 낸 사람은 어찌 되었는지 알 수 없노라 하기에 ");
INSERT INTO kor_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","내가 그들에게 이르기를 금이 있는 자는 빼어내라 한즉 그들이 그것을 내게로 가져왔기로 내가 불에 던졌더니 이 송아지가 나왔나이다' ");
INSERT INTO kor_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","모세가 본즉 백성이 방자하니 이는 아론이 그들로 방자하게 하여 원수에게 조롱거리가 되게 하였음이라 ");
INSERT INTO kor_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","이에 모세가 진문에 서서 가로되 `누구든지 여호와의 편에 있는 자는 내게로 나아오라 !' 하매 레위 자손이 다 모여 그에게로 오는 지라 ");
INSERT INTO kor_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","모세가 그들에게 이르되 `이스라엘의 하나님 여호와께서 이같이 말씀하시기를 너희는 각각 허리에 칼을 차고 진 이 문에서 저 문까지 왕래하며 각 사람이 그 형제를,각 사람이 그 친구를,각 사람이 그 이웃을 도륙하라 하셨느니라' ");
INSERT INTO kor_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","레위 자손이 모세의 말대로 행하매 이 날에 백성 중에 삼천명 가량이 죽인 바 된지라 ");
INSERT INTO kor_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","모세가 이르되 `각 사람이 그 아들과 그 형제를 쳤으니 오늘날 여호와께 헌신하게 되었느니라 그가 오늘날 너희에게 복을 내리시리라' ");
INSERT INTO kor_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","이튿날 모세가 백성에게 이르되 `너희가 큰 죄를 범하였도다 내가 이제 여호와께로 올라가노니 혹 너희의 죄를 속할까 하노라' 하고 ");
INSERT INTO kor_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","여호와께로 다시 나아가 여짜오되 `슬프도소이다 ! 이 백성이 자기들을 위하여 금신을 만들었사오니 큰 죄를 범하였나이다 ");
INSERT INTO kor_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","그러나 합의하시면 이제 그들의 죄를 사하시옵소서 ! 그렇지 않사오면 원컨대 주의 기록하신 책에서 내 이름을 지워 버려주옵소서 !' ");
INSERT INTO kor_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","여호와께서 모세에게 이르시되 누구든지 내게 범죄하면 그는 내가 내 책에서 지워버리리라 ");
INSERT INTO kor_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","이제 가서 내가 네게 말한 곳으로 백성을 인도하라 내 사자가 네 앞서 가리라 그러나 내가 보응할 날에는 그들의 죄를 보응하리라 ");
INSERT INTO kor_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","여호와께서 백성을 치시니 이는 그들이 아론의 만든바 그 송아지를 만들었음이더라 ");
INSERT INTO kor_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","여호와께서 모세에게 이르시되 너는 네가 애굽 땅에서 인도하여 낸 백성과 함께 여기서 떠나서 내가 아브라함과 이삭과 야곱에게 맹세하기를 네 자손에게 주마 한 그 땅으로 올라가라 ");
INSERT INTO kor_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","내가 사자를 네 앞서 보내어 가나안 사람과, 아모리 사람과, 헷 사람과, 브리스 사람과, 히위 사람과, 여부스 사람을 쫓아내고 ");
INSERT INTO kor_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","너희로 젖과 꿀이 흐르는 땅에 이르게 하려니와 나는 너희와 함께 올라가지 아니하리니 너희는 목이 곧은 백성인즉 내가 중로에서 너희를 진멸할까 염려함이니라 하시니 ");
INSERT INTO kor_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","백성이 이 황송한 말씀을 듣고 슬퍼하여 한 사람도 그 몸을 단장하지 아니하니 ");
INSERT INTO kor_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","여호와께서 모세에게 이르시기를 이스라엘 자손에게 이르라 너희는 목이 곧은 백성인즉 내가 순식간이라도 너희 중에 행하면 너희를 진멸하리니 너희 단장품을 제하라 ! 그리하면 내가 너희에게 어떻게 할 일을 알겠노라 하셨음이라 ");
INSERT INTO kor_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","이스라엘 자손이 호렙 산에서부터 그 단장품을 제하니라 ");
INSERT INTO kor_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","모세가 항상 장막을 취하여 진 밖에 쳐서 진과 멀리 떠나게 하고 회막이라 이름하니 여호와를 앙모하는 자는 다 진 바깥 회막으로 나아가며 ");
INSERT INTO kor_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","모세가 회막으로 나아갈 때에는 백성이 다 일어나 자기 장막문에 서서 모세가 회막에 들어가기까지 바라보며 ");
INSERT INTO kor_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","모세가 회막에 들어갈 때에 구름 기둥이 내려 회막문에 서며 여호와께서 모세와 말씀하시니 ");
INSERT INTO kor_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","모든 백성이 회막문에 구름 기둥이 섰음을 보고 다 일어나 각기 장막문에 서서 경배하며 ");
INSERT INTO kor_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","사람이 그 친구와 이야기함 같이 여호와께서는 모세와 대면하여 말씀하시며 모세는 진으로 돌아오나 그 수종자 눈의 아들 청년 여호수아는 회막을 떠나지 아니하니라 ");
INSERT INTO kor_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","모세가 여호와께 고하되 `보시옵소서 ! 주께서 나더러 이 백성을 인도하여 올라가라 하시면서 나와 함께 보낼 자를 내게 지시하지 아니하시나이다 주께서 전에 말씀하시기를 나는 이름으로도 너를 알고 너도 내 앞에 은총을 입었다 하셨사온즉 ");
INSERT INTO kor_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","내가 참으로 주의 목전에 은총을 입게 하시며 이 족속을 주의 백성으로 여기소서 !' ");
INSERT INTO kor_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","여호와께서 가라사대 내가 친히 가리라 ! 내가 너로 편케 하리라 ! ");
INSERT INTO kor_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","모세가 여호와께 고하되 `주께서 친히 가지 아니하시려거든 우리를 이곳에서 올려 보내지 마옵소서 ");
INSERT INTO kor_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","나와 주의 백성이 주의 목전에 은총 입은 줄을 무엇으로 알리이까 ? 주께서 우리와 함께 행하심으로 나와 주의 백성을 천하 만민 중에 구별하심이 아니니이까 ?' ");
INSERT INTO kor_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","여호와께서 모세에게 이르시되 너의 말하는 이 일도 내가 하리니 너는 내 목전에 은총을 입었고 내가 이름으로도 너를 앎이니라 ");
INSERT INTO kor_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","모세가 가로되 `원컨대 주의 영광을 내게 보이소서 !' ");
INSERT INTO kor_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","여호와께서 가라사대 내가 나의 모든 선한 형상을 네 앞으로 지나게 하고 여호와의 이름을 네 앞에 반포하리라 나는 은혜 줄 자에게 은혜를 주고 긍휼히 여길자에게 긍휼을 베푸느니라 ");
INSERT INTO kor_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","또 가라사대 네가 내 얼굴을 보지 못하리니 나를 보고 살 자가 없음이니라 ");
INSERT INTO kor_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","여호와께서 가라사대 보라 내 곁에 한 곳이 있으니 너는 그 반석 위에 섰으라 ");
INSERT INTO kor_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","내 영광이 지날 때에 내가 너를 반석 틈에 두고 내가 지나도록 내 손으로 너를 덮었다가 ");
INSERT INTO kor_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","손을 거두리니 네가 내 등을 볼 것이요 얼굴은 보지 못하리라 ");
INSERT INTO kor_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","여호와께서 모세에게 이르시되 너는 돌판 둘을 처음 것과 같이 깍아 만들라 네가 깨뜨린바 처음 것과 같이 깎아 만들라 네가 깨뜨린바 처음 판에 있던 말을 내가 그 판에 쓰리니 ");
INSERT INTO kor_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","아침 전에 예비하고 아침에 시내 산에 올라와 산꼭대기에서 내게 보이되 ");
INSERT INTO kor_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","아무도 너와 함께 오르지 말며 온 산에 인적을 금하고 양과 소도 산 앞에서 먹지 못하게 하라 ");
INSERT INTO kor_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","모세가 돌판 둘을 처음 것과 같이 깎아 만들고 아침에 일찌기 일어나 그 두 돌판을 손에 들고 여호와의 명대로 시내산에 올라가니 ");
INSERT INTO kor_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","여호와께서 구름 가운데 강림하사 그와 함께 거기 서서 여호와의 이름을 반포하실쌔 ");
INSERT INTO kor_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","여호와께서 그의 앞으로 지나시며 반포하시되 여호와로라 ! 여호와로라 ! 자비롭고 은혜롭고 노하기를 더디하고 인자와 진실이 많은 하나님이로라 ");
INSERT INTO kor_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","인자를 천대까지 베풀며 악과 과실과 죄를 용서하나 형벌 받을 자는 결단코 면죄하지 않고 아비의 악을 자여손 삼사대까지 보응하리라 ");
INSERT INTO kor_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","모세가 급히 땅에 엎드리어 경배하며 ");
INSERT INTO kor_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","가로되 `주여 ! 내가 주께 은총을 입었거든 원컨대 주는 우리 중에서 행하옵소서 이는 목이 곧은 백성이니이다 우리의 악과 죄를 사하시고 우리로 주의 기업을 삼으소서 !' ");
INSERT INTO kor_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","여호와께서 가라사대 보라 내가 언약을 세우나니 곧 내가 아직 온 땅 아무 국민에게도 행치 아니한 이적을 너희 전체 백성 앞에 행할 것이라 너의 머무는 나라 백성이 다 여호와의 소위를 보리니 내가 너를 위하여 행할 일이 두려운 것임이니라 ");
INSERT INTO kor_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","너는 내가 오늘 네게 명하는 것을 삼가 지키라 보라 ! 내가 네 앞에서 아모리 사람과, 가나안 사람과, 헷 사람과, 브리스 사람과, 히위 사람과, 여부스 사람을 쫓아내리니 ");
INSERT INTO kor_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","너는 스스로 삼가 네가 들어가는 땅의 거민과 언약을 세우지 말라 그들이 너희 중에 올무가 될까 하노라 ");
INSERT INTO kor_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","너희는 도리어 그들의 단들을 헐고 그들의 주상을 깨뜨리고 그들의 아세라 상을 찍을지어다 ! ");
INSERT INTO kor_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","너는 다른 신에게 절하지 말라 ! 여호와는 질투라 이름하는 질투의 하나님임이니라 ! ");
INSERT INTO kor_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","너는 삼가 그 땅의 거민과 언약을 세우지 말지니 이는 그들이 모든 신을 음란히 섬기며 그 신들에게 희생을 드리고 너를 청하면 네가 그 희생을 먹을까 함이며 ");
INSERT INTO kor_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","또 네가 그들의 딸들로 네 아들들의 아내를 삼음으로 그들의 딸들이 그 신들을 음란히 섬기며 네 아들로 그들의 신들을 음란히 섬기게 할까 함이니라 ");
INSERT INTO kor_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","너는 신상들을 부어 만들지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","너는 무교절을 지키되 내가 네게 명한대로 아빕월 그 기한에 칠일 동안 무교병을 먹으라 이는 네가 아빕월에 애굽에서 나왔음이니라 ");
INSERT INTO kor_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","무릇 초태생은 다 내 것이며 무릇 네 가축의 수컷 처음 난 우양도 다 그러하며 ");
INSERT INTO kor_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","나귀의 첫새끼는 어린 양으로 대속할 것이요 그렇게 아니하려면 그 목을 꺾을 것이며 네 아들 중 장자는 다 대속할지며 빈손으로 내 얼굴을 보지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","너는 엿새동안 일하고 제 칠일에는 쉴지니 밭 갈 때에나 거둘 때에도 쉴지며 ");
INSERT INTO kor_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","칠칠절 곧 맥추의 초실절을 지키고 가을에는 수장절을 지키라 ! ");
INSERT INTO kor_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","너희 모든 남자는 매년 세번씩 주 여호와 이스라엘의 하나님 앞에 보일지라 ");
INSERT INTO kor_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","내가 열방을 네 앞에서 쫓아내고 네 지경을 넓히리니 네가 매년 세번씩 여호와 너희 하나님께 보이러 올 때에 아무 사람도 네 땅을 탐내어 엿보지 못하리라 ! ");
INSERT INTO kor_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","너는 내 희생의 피를 유교병과 함께 드리지 말며 유월절 희생을 아침까지 두지 말지며 ");
INSERT INTO kor_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","너의 토지 소산의 처음 익은 것을 가져다가 너의 하나님 여호와의 전에 드릴지며 너는 염소 새끼를 그 어미의 젖으로 삶지 말지니라 ");
INSERT INTO kor_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","여호와께서 모세에게 이르시되 너는 이 말들을 기록하라 내가 이 말들의 뜻대로 너와 이스라엘과 언약을 세웠음이니라 하시니라 ");
INSERT INTO kor_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","모세가 여호와와 함께 사십일 사십야를 거기 있으면서 떡도 먹지 아니하였고 물도 마시지 아니하였으며 여호와께서는 언약의 말씀 곧 십계를 그 판들에 기록하셨더라 ");
INSERT INTO kor_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","모세가 그 증거의 두 판을 자기 손에 들고 시내산에서 내려오니 그 산에서 내려올 때에 모세는 자기가 여호와와 말씀하였음을 인하여 얼굴 꺼풀에 광채가 나나 깨닫지 못하였더라 ");
INSERT INTO kor_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","아론과 온 이스라엘 자손이 모세를 볼 때에 모세의 얼굴 꺼풀에 광채 남을 보고 그에게 가까이 하기를 두려워하더니 ");
INSERT INTO kor_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","모세가 그들을 부르니 아론과 회중의 모든 어른이 모세에게로 오고 모세가 그들과 말하니 ");
INSERT INTO kor_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","그 후에야 온 이스라엘 자손이 가까이 오는지라 모세가 여호와께서 시내산에서 자기에게 이르신 말씀을 다 그들에게 명하고 ");
INSERT INTO kor_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","그들에게 말하기를 마치고 수건으로 자기 얼굴을 가리웠더라 ");
INSERT INTO kor_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","그러나 모세가 여호와 앞에 들어가서 함께 말씀할 때에는 나오기까지 수건을 벗고 있다가 나와서는 그 명하신 일을 이스라엘 자손에게 고하며 ");
INSERT INTO kor_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","이스라엘 자손이 모세의 얼굴의 광채를 보는고로 모세가 여호와께 말씀하러 들어가기까지 다시 수건으로 자기 얼굴을 가리웠더라 ");
INSERT INTO kor_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","모세가 이스라엘의 온 회중을 모으고 그들에게 이르되 `여호와께서 너희에게 명하사 행하게 하신 말씀이 이러하니라 ");
INSERT INTO kor_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","엿새 동안은 일하고 제 칠일은 너희에게 성일이니 여호와께 특별한 안식일이라 무릇 이날에 일하는 자를 죽일지니 ");
INSERT INTO kor_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","안식일에는 너희의 모든 처소에서 불도 피우지 말지니라 !' ");
INSERT INTO kor_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","모세가 이스라엘 자손의 온 회중에게 고하여 가로되 `여호와의 명하신 일이 이러하니라 이르시기를 ");
INSERT INTO kor_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","너희의 소유 중에서 너희는 여호와께 드릴 것을 취하되 무릇 마음에 원하는 자는 그것을 가져다가 여호와께 드릴지니 곧 금과 은과 놋과 ");
INSERT INTO kor_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","청색, 자색, 홍색실과, 가는 베실과, 염소털과 ");
INSERT INTO kor_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","붉은 물 들인 수양의 가죽과, 해달의 가죽과, 조각목과 ");
INSERT INTO kor_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","등유와, 및 관유에 드는 향품과, 분향할 향을 만드는 향품과 ");
INSERT INTO kor_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","호마노며, 에봇과, 흉패에 물릴 보석이니라 ");
INSERT INTO kor_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","무릇 너희 중 마음이 지혜로운 자는 와서 여호와의 명하신 것을 다 만들지니 ");
INSERT INTO kor_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","곧 성막과, 그 막과, 그 덮개와, 그 갈고리와, 그 널판과, 그 띠와, 그 기둥과, 그 받침과, ");
INSERT INTO kor_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","증거궤와, 그 채와, 속죄소와, 그 가리는 장과, ");
INSERT INTO kor_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","상과, 그 채와, 그 모든 기구와, 진설병과, ");
INSERT INTO kor_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","불 켜는 등대와, 그 기구와, 그 등잔과, 등유와, ");
INSERT INTO kor_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","분향단과, 그 채와, 관유와, 분향할 향품과, 성막문의 장과, ");
INSERT INTO kor_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","번제단과, 그 놋 그물과, 그 채와, 그 모든 기구와, 물두멍과, 그 받침과, ");
INSERT INTO kor_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","뜰의 포장과, 그 기둥과, 그 받침과, 뜰문의 장과, ");
INSERT INTO kor_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","장막 말뚝과, 뜰의 포장 말뚝과, 그 줄과, ");
INSERT INTO kor_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","성소에서 섬기기 위하여 공교히 만든 옷 곧 제사 직분을 행할 때에 입는 제사장 아론의 거룩한 옷과 그 아들들의 옷이니라 ");
INSERT INTO kor_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","이스라엘 자손의 온 회중이 모세 앞에서 물러갔더니 ");
INSERT INTO kor_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","무릇 마음이 감동된 자와 무릇 자원하는 자가 와서 성막을 짓기 위하여 그 속에서 쓸 모든 것을 위하여, 거룩한 옷을 위하여 예물을 가져 여호와께 드렸으니 ");
INSERT INTO kor_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","곧 마음에 원하는 남녀가 와서 가슴 핀과, 귀고리와, 가락지와, 목거리와, 여러가지 금품을 가져 왔으되 사람마다 여호와께 금 예물을 드렸으며 ");
INSERT INTO kor_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","무릇 청색, 자색, 홍색실과, 가는 베실과, 염소털과, 붉은 물 들인 수양의 가죽과, 해달의 가죽이 있는 자도 가져 왔으며 ");
INSERT INTO kor_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","무릇 은과 놋으로 예물을 삼는 자는 가져다가 여호와께 드렸으며 무릇 섬기는 일에 소용되는 조각목이 있는 자는 가져 왔으며 ");
INSERT INTO kor_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","마음이 슬기로운 모든 여인은 손수 실을 낳고 그 낳은 청색, 자색, 홍색실과, 가는 베실을 가져 왔으며 ");
INSERT INTO kor_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","마음에 감동을 받아 슬기로운 모든 여인은 염소털로 실을 낳았으며 ");
INSERT INTO kor_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","모든 족장은 호마노와 및 에봇과 흉패에 물릴 보석을 가져 왔으며 ");
INSERT INTO kor_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","등불과, 관유와, 분향할 향에 소용되는 기름과, 향품을 가져 왔으니 ");
INSERT INTO kor_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","마음에 원하는 이스라엘 자손의 남녀마다 여호와께서 모세의 손을 빙자하여 명하신 모든 것을 만들기 위하여 물품을 가져다가 여호와께 즐거이 드림이 이러하였더라 ");
INSERT INTO kor_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","모세가 이스라엘 자손에게 이르되 `볼지어다 여호와께서 유다 지파 훌의 손자요 우리의 아들인 브사렐을 지명하여 부르시고 ");
INSERT INTO kor_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","하나님의 신을 그에게 충만케 하여 지혜와 총명과 지식으로 여러가지 일을 하게 하시되 ");
INSERT INTO kor_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","공교한 일을 연구하여 금과 은과 놋으로 일하게 하시며 ");
INSERT INTO kor_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","보석을 깎아 물리며 나무를 새기는 여러가지 공교한 일을 하게 하셨고 ");
INSERT INTO kor_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","또 그와 단 지파 아히사막의 아들 오홀리압을 감동시키사 가르치게 하시며 ");
INSERT INTO kor_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","지혜로운 마음을 그들에게 충만하게 하사 여러가지 일을 하게 하시되 조각하는 일과, 공교로운 일과, 청색, 자색, 홍색실과, 가는 베실로 수 놓은 일과 짜는 일과 그 외에 여러가지 일을 하게 하시고 공교로운 일을 연구하게 하셨나니 ");
INSERT INTO kor_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","브사렐과 오홀리압과 및 마음이 지혜로운 사람 곧 여호와께서 지혜와 총명을 부으사 성소에 쓸 모든 일을 할 줄 알게 하심을 입은 자들은 여호와의 무릇 명하신 대로 할 것이니라' ");
INSERT INTO kor_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","모세가 브살렐과 오홀리압과 및 마음이 지혜로운 사람 곧 그 마음에 여호와께로 지혜를 얻고 와서 그 일을 하려고 마음에 원하는 모든 자를 부르매 ");
INSERT INTO kor_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","그들이 이스라엘 자손의 성소의 모든 것을 만들기 위하여 가져 온 예물을 모세에게서 받으니라 그러나 백성이 아침마다 자원하는 예물을 연하여 가져오는 고로 ");
INSERT INTO kor_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","성소의 모든 일을 하는 지혜로운 자들이 각기 하는 일을 정지하고 와서 ");
INSERT INTO kor_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","모세에게 고하여 가로되 `백성이 너무 많이 가져 오므로 여호와의 명하신 일에 쓰기에 남음이 있나이다' ");
INSERT INTO kor_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","모세가 명을 내리매 그들이 진중에 공포하여 가로되 `무론 남녀하고 성소에 드릴 예물을 다시 만들지 말라' 하매 백성이 가져오기를 정지하니 ");
INSERT INTO kor_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","있는 재료가 모든 일을 하기에 넉넉하여 남음이 있었더라 ");
INSERT INTO kor_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","일하는 사람 중에 마음이 지혜로운 모든 사람이 열 폭 앙장으로 성막을 지었으니 곧 가늘게 꼰 베실과, 청색, 자색, 홍색실로 그룹들을 무늬 놓아 짜서 지은 것이라 ");
INSERT INTO kor_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","매폭의 장은 이십 팔 규빗,광은 사 규빗으로 각 폭의 장단을 같게 하여 ");
INSERT INTO kor_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","그 다섯 폭을 서로 연하며, 또 그 다섯 폭을 서로 연하고 ");
INSERT INTO kor_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","연락할 말폭 가에 청색 고를 만들며, 다른 연락할 말폭 가에도 고를 만들되 ");
INSERT INTO kor_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","그 연락할 한 폭에 고 오십을 달고, 다른 연락할 한 폭의 가에도 고 오십을 달아, 그 고들이 서로 대하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","금 갈고리 오십을 만들어, 그 갈고리로 두 앙장을 연하여 한 막을 이루었더라 ");
INSERT INTO kor_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","그 성막을 덮는 막 곧 앙장을 염소털로 만들되 십 일폭을 만들었으니 ");
INSERT INTO kor_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","각 폭의 장은 삼십 규빗,광은 사 규빗으로 십 일폭의 장단을 같게 하여 ");
INSERT INTO kor_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","그 앙장 다섯 폭을 서로 연하며, 또 여섯 폭을 서로 연하고 ");
INSERT INTO kor_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","앙장을 연락할 말폭 가에도 고 오십을 달며, 다른 연락할 말폭 가에도 고 오십을 달고 ");
INSERT INTO kor_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","놋 갈고리 오십을 만들어, 그 앙장을 연합하여 한 막이 되게 하고 ");
INSERT INTO kor_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","붉은 물 들인 수양의 가죽으로 막의 덮개를 만들고 해달의 가죽으로 그 웃덮개를 만들었더라 ");
INSERT INTO kor_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","그가 또 조각목으로 성막에 세울 널판들을 만들었으니 ");
INSERT INTO kor_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","각 판의 장은 십 규빗,광은 일 규빗 반이며 ");
INSERT INTO kor_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","각 판에 두 촉이 있어 서로 연하게 하였으니 성막의 모든 판이 그러하며 ");
INSERT INTO kor_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","성막을 위하여 널판을 만들었으되, 남으로는 남편에 널판이 이십이라 ");
INSERT INTO kor_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","그 이십 널판 밑에 은받침 사십을 만들었으되, 곧 이 널판 밑에도 두 받침이 그 두 촉을 받게 하였으며 ");
INSERT INTO kor_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","성막 다른 편 곧 북편을 위하여도 널판 이십을 만들고 ");
INSERT INTO kor_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","또 은받침 사십을 만들었으니 곧 이 판 밑에도 두 받침이요, 저 판 밑에도 두 받침이며 ");
INSERT INTO kor_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","장막 뒤 곧 서편을 위하여는 널판 여섯을 만들었고 ");
INSERT INTO kor_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","장막 뒤 두 모퉁이 편을 위하여는 널판 둘을 만들되 ");
INSERT INTO kor_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","아래서부터 위까지 각기 두 겹 두께로 하여 윗고리에 이르게 하고 두 모퉁이 편을 다 그리하며 ");
INSERT INTO kor_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","그 널판은 여덟이요, 그 받침은 은받침 열 여섯이라, 각 널판 밑에 둘씩이었더라 ");
INSERT INTO kor_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","그가 또 조각목으로 띠를 만들었으니 곧 성막 이편 널판을 위하여 다섯이요 ");
INSERT INTO kor_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","성막 저편 널판을 위하여 다섯이요, 성막 뒤 곧 서편 널판을 위하여 다섯이며 ");
INSERT INTO kor_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","그 중간 띠를 만들되, 널판 중간 이 끝에서 저 끝에 미치게 하였으며 ");
INSERT INTO kor_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","그 널판들을 금으로 싸고 그 널판에 띠를 꿸 금고리를 만들고, 그 띠도 금으로 쌌더라 ");
INSERT INTO kor_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","그가 또 청색, 자색, 홍색실과, 가늘게 꼰 베실로 장을 짜고 그 위에 그룹들을 공교히 수 놓고 ");
INSERT INTO kor_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","조각목으로 네 기둥을 만들어 금으로 쌌으며, 그 갈고리는 금이며 기둥의 네 받침은 은으로 부어 만들었으며 ");
INSERT INTO kor_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","청색, 자색, 홍색실과, 가늘게 꼰 베실로 수 놓아 장막 문을 위하여 장을 만들고 ");
INSERT INTO kor_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","문장의 기둥 다섯과 그 갈고리를 만들고, 기둥머리와 그 가름대를 금으로 쌌으며 그 다섯 받침은 놋이었더라 ");
INSERT INTO kor_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","브사렐이 조각목으로 궤를 만들었으니 장이 이 규빗 반, 광이 일 규빗 반, 고가 일 규빗 반이며 ");
INSERT INTO kor_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","정금으로 안팎을 싸고 윗가로 돌아가며 금테를 만들었으며 ");
INSERT INTO kor_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","금고리 넷을 부어 만들어 네 발에 달았으니 곧 이편에 두 고리요, 저편에 두 고리며 ");
INSERT INTO kor_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","조각목으로 채를 만들어 금으로 싸고 ");
INSERT INTO kor_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","그 채를 궤 양편 고리에 꿰어 궤를 메게 하였으며 ");
INSERT INTO kor_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","정금으로 속죄소를 만들었으니 장이 이 규빗 반, 광이 일 규빗 반이며 ");
INSERT INTO kor_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","금으로 그룹 둘을 속죄소 양편에 쳐서 만들었으되 ");
INSERT INTO kor_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","한 그룹은 이편 끝에, 한 그룹은 저편 끝에 곧 속죄소와 한 덩이로 그 양편에 만들었으니 ");
INSERT INTO kor_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","그룹들이 그 날개를 높이 펴서 그 날개로 속죄소를 덮으며 그 얼굴을 서로 대하여 속죄소를 향하였더라 ");
INSERT INTO kor_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","그가 또 조각목으로 상을 만들었으니 장이 이 규빗, 광이 일 규빗, 고가 일 규빗 반이며 ");
INSERT INTO kor_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","정금으로 싸고 윗가로 돌아가며 금테를 둘렀으며 ");
INSERT INTO kor_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","그 사면에 손바닥 넓이만한 턱을 만들고 그 턱 주위에 금으로 테를 만들었고 ");
INSERT INTO kor_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","상을 위하여 금고리 넷을 부어 만들어 네 발 위 네 모퉁이에 달았으니 ");
INSERT INTO kor_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","그 고리가 턱 곁에 있어서 상을 메는 채를 꿰게 하였으며 ");
INSERT INTO kor_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","또 조각목으로 상 멜 채를 만들어 금으로 쌌으며 ");
INSERT INTO kor_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","상 위의 기구 곧 대접과, 숟가락과, 잔과, 붓는 병을 정금으로 만들었더라 ");
INSERT INTO kor_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","그가 또 정금으로 등대를 만들되 그것을 쳐서 만들었으니 그 밑판과, 줄기와, 잔과, 꽃받침과, 꽃이 그것과 한 덩이로 되었고 ");
INSERT INTO kor_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","여섯 가지가 그 곁에서 나왔으니 곧 등대의 세 가지는 저편으로 나왔고, 등대의 세 가지는 이 편으로 나왔으며 ");
INSERT INTO kor_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","이 편 가지에 살구꽃 형상의 잔 셋과, 꽃받침과, 꽃이 있고 저편 가지에 살구꽃 형상의 잔 셋과, 꽃받침과, 꽃이 있어 등대에서 나온 여섯 가지가 그러하며 ");
INSERT INTO kor_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","등대 줄기에는 살구꽃 형상의 잔 넷과, 꽃받침과, 꽃이 있고 ");
INSERT INTO kor_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","등대에서 나온 여섯 가지를 위하여는 꽃받침이 있게 하였으되 두가지 아래 한 꽃받침이 있어 줄기와 연하였고 또 두 가지 아래 한 꽃받침이 있어 줄기와 연하게 하였으니 ");
INSERT INTO kor_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","이 꽃받침과 가지들을 줄기와 연하여 전부를 정금으로 쳐서 만들었으며 ");
INSERT INTO kor_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","등잔 일곱과, 그 불집게와, 불똥 그릇을 정금으로 만들었으니 ");
INSERT INTO kor_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","등대와 그 모든 기구는 정금 한 달란트로 만들었더라 ");
INSERT INTO kor_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","그가 또 조각목으로 분향할 단을 만들었으니 장이 일 규빗이요, 광이 일 규빗이라 네모 반듯하고 고는 이 규빗이며 그 뿔들이 단과 연하였으며 ");
INSERT INTO kor_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","단 상면과 전후 좌우면과 그 뿔을 정금으로 싸고 주위에 금테를 둘렀고 ");
INSERT INTO kor_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","그 테 아래 양 편에 금고리 둘을 만들었으되 곧 그 양 편에 만들어 단을 메는 채를 꿰게 하였으며 ");
INSERT INTO kor_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","조각목으로 그 채를 만들어 금으로 쌌으며 ");
INSERT INTO kor_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","거룩한 관유와 향품으로 정결한 향을 만들었으되 향을 만드는 법대로 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","그가 또 조각목으로 번제단을 만들었으니 장이 오 규빗이요, 광이 오 규빗이라 네모 반듯하고 고는 삼 규빗이며 ");
INSERT INTO kor_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","그 네 모퉁이 위에 그 뿔을 만들되 그 뿔을 단과 연하게 하고 단을 놋으로 쌌으며 ");
INSERT INTO kor_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","단의 모든 기구 곧 통과, 부삽과, 대야와, 고기 갈고리와, 불 옮기는 그릇을 다 놋으로 만들고 ");
INSERT INTO kor_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","단을 위하여 놋 그물을 만들어 단 사면 가장자리 아래 두되 단 절반에 오르게 하고 ");
INSERT INTO kor_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","그 놋 그물 네 모퉁이에 채를 꿸 고리 넷을 부어 만들었으며 ");
INSERT INTO kor_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","채를 조각목으로 만들어 놋으로 싸고 ");
INSERT INTO kor_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","단 양편 고리에 그 채를 꿰어 메게 하였으며 단은 널판으로 비게 만들었더라 ");
INSERT INTO kor_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","그가 놋으로 물두멍을 만들고 그 받침도 놋으로 하였으니 곧 회막문에서 수종드는 여인들의 거울로 만들었더라 ");
INSERT INTO kor_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","그가 또 뜰을 만들었으니 남으로 뜰의 남편에는 세마포 포장이 백 규빗이라 ");
INSERT INTO kor_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","그 기둥이 스물이며, 그 받침이 스물이니, 놋이요 기둥의 갈고리와 가름대는 은이며 ");
INSERT INTO kor_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","그 북편에도 백 규빗이라, 그 기둥이 스물이며, 그 받침이 스물이니, 놋이요 기둥의 갈고리와 가름대는 은이며 ");
INSERT INTO kor_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","서편에 포장은 오십 규빗이라, 그 기둥이 열이요, 받침이 열이며, 기둥의 갈고리와, 가름대는 은이며 ");
INSERT INTO kor_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","동으로 동편에도 오십 규빗이라 ");
INSERT INTO kor_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","문 이편의 포장이 십 오 규빗이요, 그 기둥이 셋이요, 받침이 셋이며 ");
INSERT INTO kor_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","문 저편도 그와 같으니 뜰문 이편,저편의 포장이 십 오 규빗씩이요, 그 기둥이 셋씩, 받침이 셋씩이라 ");
INSERT INTO kor_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","뜰 사면의 포장은 세마포요 ");
INSERT INTO kor_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","기둥 받침은 놋이요, 기둥의 갈고리와 가름대는 은이요, 기둥머리 싸개는 은이며, 뜰의 모든 기둥에 은 가름대를 꿰었으며 ");
INSERT INTO kor_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","뜰의 문장을 청색, 자색, 홍색실과, 가늘게 꼰 베실로 수 놓아 짰으니 장은 이십 규빗이요, 광 곧 고는 뜰의 포장과 같이 오 규빗이며 ");
INSERT INTO kor_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","그 기둥은 넷인데 그 받침 넷은 놋이요, 그 갈고리는 은이요, 그 머리 싸개와 가름대도 은이며 ");
INSERT INTO kor_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","성막 말뚝과 뜰의 사면 포장 말뚝은 다 놋이더라 ");
INSERT INTO kor_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","성막 곧 증거막을 위하여 레위 사람의 쓴 재료의 물목은 제사장 아론의 아들 이다말이 모세의 명대로 계산하였으며 ");
INSERT INTO kor_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","유다 지파 훌의 손자요 우리의 아들인 브사렐은 여호와께서 모세에게 명하신 모든 것을 만들었고 ");
INSERT INTO kor_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","단 지파 아히사막의 아들 오홀리압은 그와 함께 하였으니 오홀리압은 재능이 있어서 조각하며 또 청색, 자색, 홍색실과, 가는 베실로 수 놓은 자더라 ");
INSERT INTO kor_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","성소 건축 비용으로 드린 금은 성소의 세겔대로 이십 구 달란트와 칠백 삼십 세겔이며 ");
INSERT INTO kor_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","조사를 받은 회중의 드린 은은 성소의 세겔대로 일백 달란트와 일천 칠백 칠십 오 세겔이니 ");
INSERT INTO kor_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","조사를 받은 자가 이십세 이상으로 육십만 삼천 오백 오십명인즉 성소의 세겔대로 매인에게 은 한 베가 곧 반 세겔씩이라 ");
INSERT INTO kor_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","은 일백 달란트로 성소의 판장 받침과 문장 기둥 받침 합 일백을 부어 만들었으니 매 받침에 한 달란트씩 합 일백 달란트요 ");
INSERT INTO kor_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","일천 칠백 칠십오 세겔로 기둥 갈고리를 만들고 기둥머리를 싸고 기둥 가름대를 만들었으며 ");
INSERT INTO kor_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","드린 놋은 칠십 달란트와 이천 사백 세겔이라 ");
INSERT INTO kor_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","이것으로 회막 문기둥 받침과, 놋 단과, 놋그물과, 단의 모든 기구를 만들었으며 ");
INSERT INTO kor_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","뜰 사면의 기둥 받침과 그 문장 기둥 받침이며 성막의 모든 말뚝과 뜰 사면의 모든 말뚝을 만들었더라 ");
INSERT INTO kor_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","그들이 여호와께서 모세에게 명하신대로 청색, 자색, 홍색실로 성소에서 섬기기 위한 정교한 옷을 만들고 또 아론을 위한 거룩한 옷을 만들었더라 ");
INSERT INTO kor_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","그가 또 금실과, 청색, 자색, 홍색실과, 가늘게 꼰 베실로 에봇을 만들었으되 ");
INSERT INTO kor_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","금실을 얇게 쳐서 오려서 실을 만들어 청색, 자색, 홍색실과, 가는 베실에 섞어 공교히 짜고 ");
INSERT INTO kor_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","에봇을 위하여 견대를 만들어 그 두 끝에 달아 서로 연하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","에봇 위에 에봇을 매는 띠를 에봇과 같은 모양으로 금실과, 청색, 자색, 홍색실과, 가늘게 꼰 베실로 에봇에 붙여 짰으니 여호와께서 모세에게 명하신대로 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","그들이 또 호마노를 깎아 금테에 물려 인을 새김 같이 이스라엘의 아들들의 이름을 그것에 새겨 ");
INSERT INTO kor_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","에봇 견대에 달아 이스라엘 자손의 기념 보석을 삼았으니 여호와께서 모세에게 명하신대로 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","그가 또 흉패를 공교히 짜되 에봇과 같은 모양으로 금실과, 청색, 자색, 홍색실과, 가늘게 꼰 베실로 하였으니 ");
INSERT INTO kor_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","그것의 장이 한 뼘, 광이 한 뼘으로 네모 반듯하고 두 겹이며 ");
INSERT INTO kor_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","그것에 네 줄 보석을 물렸으니 곧 홍보석, 황옥, 녹주옥이 첫 줄이요 ");
INSERT INTO kor_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","둘째 줄은 석류석, 남보석, 홍마노요 ");
INSERT INTO kor_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","세째 줄은 호박, 백마노, 자수정이요 ");
INSERT INTO kor_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","네째 줄은 녹보석, 호마노, 벽옥이라 다 금테에 물렸으니 ");
INSERT INTO kor_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","이 보석들은 이스라엘 아들들의 이름 곧 그들의 이름대로 열 둘이라 인을 새김 같이 그 열 두 지파의 각 이름을 새겼으며 ");
INSERT INTO kor_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","그들이 또 정금으로 사슬을 노끈처럼 땋아 흉패에 붙이고 ");
INSERT INTO kor_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","또 금테 둘과 금고리 둘을 만들어 그 두 고리를 흉패 두 끝에 달고 ");
INSERT INTO kor_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","그 두 땋은 금사슬을 흉패 끝 두 고리에 꿰어 매었으며 ");
INSERT INTO kor_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","그 땋은 두 사슬의 다른 두 끝을 에봇 앞 두 견대의 금테에 매고 ");
INSERT INTO kor_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","또 금고리 둘을 만들어 흉패 두 끝에 달았으니 곧 그 에봇에 대한 안쪽 가에 달았으며 ");
INSERT INTO kor_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","또 금고리 둘을 만들어 에봇 앞 두 견대 아래 매는 자리 가까운편 곧 공교히 짠 에봇띠 윗편에 달고 ");
INSERT INTO kor_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","청색 끈으로 흉패 고리와 에봇 고리에 꿰어 흉패로 공교히 짠 에봇 띠 위에 붙여서 에봇을 떠나지 않게 하였으니 여호와께서 모세에게 명하신대로 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","그가 에봇 받침 긴 옷을 전부 청색으로 짜서 만들되 ");
INSERT INTO kor_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","그 옷의 두 어깨 사이에 구멍을 내고 갑옷 깃 같이 그 구멍 주위에 깃을 짜서 찢어지지 않게 하고 ");
INSERT INTO kor_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","청색, 자색, 홍색실과, 가는 베실로 그 옷 가장자리에 석류를 수 놓고 ");
INSERT INTO kor_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","정금으로 방울을 만들어 그 옷 가장자리로 돌아가며 석류 사이 사이에 달되 ");
INSERT INTO kor_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","방울과 석류를 서로 간격하여 공직하는 그 옷 가장자리로 돌아가며 달았으니 여호와께서 모세에게 명하신대로 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","그들이 또 직조한 가는 베로 아론과 그 아들들을 위하여 속옷을 짓고 ");
INSERT INTO kor_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","세마포로 두건을 짓고 세마포로 빛난 관을 만들고 가는 베실로 짜서 세마포 고의들을 만들고 ");
INSERT INTO kor_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","가는 베실과, 청색, 자색, 홍색실로 수 놓아 띠를 만들었으니 여호와께서 모세에게 명하신대로 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","그들이 또 정금으로 거룩한 패를 만들고 인을 새김 같이 그 위에 여호와께 성결이라 새기고 ");
INSERT INTO kor_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","그 패를 청색 끈으로 관 전면에 달았으니 여호와께서 모세에게 명하신 대로 하였더라 ");
INSERT INTO kor_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","이스라엘 자손이 이와 같이 성막 곧 회막의 모든 역사를 준공하여 여호와께서 모세에게 명하신대로 다 행하고 ");
INSERT INTO kor_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","그들이 성막을 모세에게로 가져왔으니 곧 막과, 그 모든 기구와, 그 갈고리들과, 그 널판들과, 그 띠들과, 그 기둥들과, 그 받침들과, ");
INSERT INTO kor_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","붉은 물 들인 수양의 가죽 덮개와, 해달의 가죽 덮개와, 가리우는 장과, ");
INSERT INTO kor_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","증거궤와, 그 채들과, 속죄소와, ");
INSERT INTO kor_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","상과, 그 모든 기구와, 진설병과, ");
INSERT INTO kor_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","정금 등대와, 그 잔 곧 벌여놓은 등잔과, 그 모든 기구와, 등유와, ");
INSERT INTO kor_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","금단과, 관유와, 향기로운 향과, 장막 문장과, ");
INSERT INTO kor_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","놋단과, 그 놋 그물과, 그 채들과, 그 모든 기구와, 물두멍과, 그 받침과, ");
INSERT INTO kor_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","뜰의 포장들과, 그 기둥들과, 그 받침들과, 뜰문의 장과, 그 줄들과, 그 말뚝들과, 회막의 소용 곧 성막의 모든 기구와, ");
INSERT INTO kor_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","성소에서 섬기기 위한 정교한 옷 곧 제사 직분을 행할 때에 입는 제사장 아론의 거룩한 옷과 그 아들들의 옷이라 ");
INSERT INTO kor_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","여호와께서 모세에게 명하신대로 이스라엘 자손이 모든 역사를 필하매 ");
INSERT INTO kor_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","모세가 그 필한 모든 것을 본즉 여호와께서 명하신대로 되었으므로 그들에게 축복하였더라 ");
INSERT INTO kor_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","너는 정월 초일일에 성막 곧 회막을 세우고 ");
INSERT INTO kor_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","또 증거궤를 들여 놓고 또 장으로 그 궤를 가리우고 ");
INSERT INTO kor_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","또 상을 들여 놓고 그 위에 물품을 진설하고 등대를 들여 놓고 불을 켜고 ");
INSERT INTO kor_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","또 금 향단을 증거궤 앞에 두고 성막 문에 장을 달고 ");
INSERT INTO kor_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","또 번제단을 회막의 성막 문 앞에 놓고 ");
INSERT INTO kor_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","또 물두멍을 회막과 단 사이에 놓고 그 속에 물을 담고 ");
INSERT INTO kor_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","또 뜰 주위에 포장을 치고 뜰 문에 장을 달고 ");
INSERT INTO kor_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","또 관유를 취하여 성막과 그 안에 있는 모든 것에 발라 그것과 그 모든 기구를 거룩하게 하라 ! 그것이 거룩하리라 ");
INSERT INTO kor_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","너는 또 번제단과 그 모든 기구에 발라 그 안을 거룩하게 하라 ! 그 단이 지극히 거룩하리라 ");
INSERT INTO kor_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","너는 또 물두멍과 그 받침에 발라 거룩하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","또 아론과 그 아들들을 회막문으로 데려다가 물로 씻기고 ");
INSERT INTO kor_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","아론에게 거룩한 옷을 입히고 그에게 기름을 부어 거룩하게 하여 그로 내게 제사장의 직분을 행하게 하라 ");
INSERT INTO kor_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","너는 또 그 아들들을 데려다가 그들에게 겉옷을 입히고 ");
INSERT INTO kor_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","그 아비에게 기름을 부음 같이 그들에게도 부어서 그들로 내게 제사장 직분을 행하게 하라 그들이 기름 부음을 받았은즉 대대로 영영히 제사장이 되리라 하시매 ");
INSERT INTO kor_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","모세가 그같이 행하되 곧 여호와께서 자기에게 명하신대로 다 행하였더라 ");
INSERT INTO kor_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","제 이년 정월 곧 그 달 초일일에 성막을 세우니라 ");
INSERT INTO kor_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","모세가 성막을 세우되, 그 받침들을 놓고 그 널판들을 세우고, 그 띠를 띠우고 그 기둥들을 세우고, ");
INSERT INTO kor_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","또 성막 위에 막을 펴고 그 위에 덮개를 덮으니 여호와께서 모세에게 명하신 대로 되니라 ");
INSERT INTO kor_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","그가 또 증거판을 궤 속에 넣고 채를 궤에 꿰고 속죄소를 궤 위에 두고 ");
INSERT INTO kor_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","또 그 궤를 성막에 들여 놓고 장을 드리워서 그 증거궤를 가리우니 여호와께서 모세에게 명하신 대로 되니라 ");
INSERT INTO kor_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","그가 또 회막 안 곧 성막 북편으로 장 밖에 상을 놓고 ");
INSERT INTO kor_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","또 여호와 앞 그 상 위에 떡을 진설하니 여호와께서 모세에게 명하신 대로 되니라 ");
INSERT INTO kor_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","그가 또 회막 안 곧 성막 남편에 등대를 놓아 상과 대하게 하고 ");
INSERT INTO kor_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","또 여호와 앞에 등잔에 불을 켜니 여호와께서 모세에게 명하신 대로 되니라 ");
INSERT INTO kor_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","그가 또 금 향단을 회막 안 장 앞에 두고 ");
INSERT INTO kor_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","그 위에 향기로운 향을 사르니 여호와께서 모세에게 명하신 대로 되니라 ");
INSERT INTO kor_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","그가 또 성막문에 장을 달고 ");
INSERT INTO kor_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","또 회막의 성막 문 앞에 번제단을 두고 번제와 소제를 그 위에 드리니 여호와께서 모세에게 명하신 대로 되니라 ");
INSERT INTO kor_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","그가 또 물두멍을 회막과 단 사이에 두고 거기 씻을 물을 담고 ");
INSERT INTO kor_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","자기와 아론과 그 아들들이 거기서 수족을 씻되 ");
INSERT INTO kor_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","그들이 회막에 들어갈 때와 단에 가까이 갈 때에 씻었으니 여호와께서 모세에게 명하신 대로 되니라 ");
INSERT INTO kor_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","그가 또 성막과 단 사면 뜰에 포장을 치고 뜰문의 장을 다니라 모세가 이같이 역사를 필하였더라 ");
INSERT INTO kor_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","그 후에 구름이 회막에 덮이고 여호와의 영광이 성막에 충만하매 ");
INSERT INTO kor_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","모세가 회막에 들어갈 수 없었으니 이는 구름이 회막 위에 덮이고 여호와의 영광이 성막에 충만함이었으며 ");
INSERT INTO kor_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","구름이 성막 위에서 떠오를 때에는 이스라엘 자손이 그 모든 행하는 길에 앞으로 발행하였고 ");
INSERT INTO kor_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","구름이 떠오르지 않을 때에는 떠오르는 날까지 발행하지 아니하였으며 ");
INSERT INTO kor_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","낮에는 여호와의 구름이 성막 위에 있고 밤에는 불이 그 구름 가운데 있음을 이스라엘의 온 족속이 그 모든 행하는 길에서 친히 보았더라 ");
INSERT INTO kor_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","여호와께서 회막에서 모세를 부르시고 그에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","이스라엘 자손에게 고하여 이르라 너희 중에 누구든지 여호와께 예물을 드리려거든 생축 중에서 소나 양으로 예물을 드릴지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","그 예물이 소의 번제이면 흠 없는 수컷으로 회막 문에서 여호와 앞에 열납하시도록 드릴지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","그가 번제물의 머리에 안수할지니 그리하면 열납되어 그를 위하여 속죄가 될 것이라 ");
INSERT INTO kor_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","그는 여호와 앞에서 그 수송아지를 잡을 것이요, 아론의 자손 제사장들은 그 피를 가져다가 회막 문 앞 단 사면에 뿌릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","그는 또 그 번제 희생의 가죽을 벗기고 각을 뜰 것이요, ");
INSERT INTO kor_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","제사장 아론의 자손들은 단 위에 불을 두고 불 위에 나무를 벌여 놓고 ");
INSERT INTO kor_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","아론의 자손 제사장들은 그 뜬 각과 머리와 기름을 단 윗불 위에 있는 나무에 벌여 놓을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","그 내장과 정갱이를 물로 씻을 것이요, 제사장은 그 전부를 단 위에 불살라 번제를 삼을지니 이는 화제라 여호와께 향기로운 냄새니라. ");
INSERT INTO kor_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","만일 그 예물이 떼의 양이나 염소의 번제이면 흠없는 수컷으로 드릴지니 ");
INSERT INTO kor_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","그가 단 북편에서 여호와 앞에서 잡을 것이요,아론의 자손 제사장들은 그 피를 단 사면에 뿌릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","그는 그것의 각을 뜨고 그 머리와 그 기름을 베어 낼 것이요, 제사장은 그것을 다 단 윗불 위에 있는 나무에 벌여 놓을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","그 내장과 정갱이를 물로 씻을 것이요, 제사장은 그 전부를 가져다가 단 위에 불살라 번제를 삼을지니 이는 화제라 여호와께 향기로운 냄새니라. ");
INSERT INTO kor_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","만일 여호와께 드리는 예물이 새의 번제이면 산비둘기나 집비둘기 새끼로 예물을 삼을 것이요, ");
INSERT INTO kor_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","제사장은 그것을 단으로 가져다가 그 머리를 비틀어 끊고 단 위에 불사르고 피는 단 곁에 흘릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","멱통과 그 더러운 것은 제하여 단 동편 재 버리는 곳에 던지고 ");
INSERT INTO kor_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","또 그 날개 자리에서 그 몸을 찢되 아주 찢지 말고 제사장이 그것을 단 윗불 위의 나무 위에 살라 번제를 삼을지니 이는 화제라 여호와께 향기로운 냄새니라 ");
INSERT INTO kor_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","누구든지 소제의 예물을 여호와께 드리려거든 고운 가루로 예물을 삼아 그 위에 기름을 붓고 또 그 위에 유향을 놓아 ");
INSERT INTO kor_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","아론의 자손 제사장들에게로 가져 올 것이요 제사장은 그 고운 기름 가루 한 줌과 그 모든 유향을 취하여 기념물로 단 위에 불 사를지니 이는 화제라 여호와께 향기로운 냄새니라. ");
INSERT INTO kor_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","그 소제물의 남은 것은 아론과 그 자손에게 돌릴지니 이는 여호와의 화제 중에 지극히 거룩한 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","네가 화덕에 구운 것으로 소제의 예물을 드리려거든 고운 가루에 기름을 섞어 만든 무교병이나 기름을 바른 무교병을 드릴 것이요, ");
INSERT INTO kor_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","번철에 부친 것으로 소제의 예물을 드리려거든 고운 가루에 누룩을 넣지 말고 기름을 섞어 ");
INSERT INTO kor_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","조각으로 나누고 그 위에 기름을 부을지니 이는 소제니라 ");
INSERT INTO kor_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","네가 솥에 삶은 것으로 소제를 드리려거든 고운 가루와 기름을 섞어 만들지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","너는 이것들로 만든 소제물을 여호와께로 가져다가 제사장에게 줄 것이요, 제사장은 그것을 단으로 가져다가 ");
INSERT INTO kor_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","그 소제물 중에서 기념할 것을 취하여 단 위에 불사를지니 이는 화제라 여호와께 향기로운 냄새니라. ");
INSERT INTO kor_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","소제물의 남은 것은 아론과 그 자손에게 돌릴찌니 이는 여호와의 화제 중에 지극히 거룩한 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","무릇 너희가 여호와께 드리는 소제물에는 모두 누룩을 넣지 말지니 너희가 누룩이나 꿀을 여호와께 화제로 드려 사르지 못할지니라 ");
INSERT INTO kor_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","처음 익은 것으로는 그것을 여호와께 드릴지나 향기로운 냄새를 위하여는 단에 올리지 말지며 ");
INSERT INTO kor_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","네 모든 소제물에 소금을 치라 ! 네 하나님의 언약의 소금을 네 소제에 빼지 못할지니 네 모든 예물에 소금을 드릴지니라 ");
INSERT INTO kor_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","너는 첫 이삭의 소제를 여호와께 드리거든 첫 이삭을 볶아 찧은 것으로 너의 소제를 삼되 ");
INSERT INTO kor_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","그 위에 기름을 붓고 그 위에 유향을 더할지니 이는 소제니라 ");
INSERT INTO kor_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","제사장은 찧은 곡식 얼마와, 기름의 얼마와, 모든 유향을 기념물로 불사를지니 이는 여호와께 드리는 화제니라 ");
INSERT INTO kor_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","사람이 만일 화목제의 희생을 예물로 드리되 소로 드리려거든 수컷이나 암컷이나 흠 없는 것으로 여호와 앞에 드릴지니 ");
INSERT INTO kor_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","그 예물의 머리에 안수하고 회막 문에서 잡을 것이요, 아론의 자손 제사장들은 그 피를 제단 사면에 뿌릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","그는 또 그 화목제의 희생중에서 여호와께 화제를 드릴지니 곧 내장에 덮인 기름과, 내장에 붙은 모든 기름과, ");
INSERT INTO kor_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","두 콩팥과, 그 위의 기름 곧 허리 근방에 있는 것과, 간에 덮인 꺼풀을 콩팥과 함께 취할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","아론의 자손은 그것을 단 윗불 위에 있는 나무 위 번제물 위에 사를지니 이는 화제라 여호와께 향기로운 냄새니라 ");
INSERT INTO kor_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","만일 여호와께 예물로 드리는 화목제의 희생이 양이면 수컷이나 암컷이나 흠 없는 것으로 드릴지며 ");
INSERT INTO kor_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","만일 예물로 드리는 것이 어린 양이면 그것을 여호와 앞으로 끌어다가 ");
INSERT INTO kor_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","그 예물의 머리에 안수하고 회막 앞에서 잡을 것이요, 아론의 자손은 그 피를 단 사면에 뿌릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","그는 그 화목제의 희생 중에서 여호와께 화제를 드릴지니 그 기름 곧 미려골에서 벤바 기름진 꼬리와, 내장에 덮힌 기름과, 내장에 붙은 모든 기름과, ");
INSERT INTO kor_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","두 콩팥과, 그 위의 기름 곧 허리 근방에 있는 것과, 간에 덮인 꺼풀을 콩팥과 함께 취할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","제사장은 그것을 단 위에 불사를지니 이는 화제로 여호와께 드리는 식물이니라 ");
INSERT INTO kor_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","만일 예물이 염소면 그것을 여호와 앞으로 끌어다가 ");
INSERT INTO kor_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","그 머리에 안수하고 회막 앞에서 잡을 것이요, 아론의 자손은 그 피를 단 사면에 뿌릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","그는 그 중에서 예물을 취하여 여호와께 화제를 드릴지니 곧 내장에 덮인 기름과, 내장에 붙은 모든 기름과, ");
INSERT INTO kor_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","두 콩팥과, 그 위의 기름 곧 허리 근방에 있는 것과, 간에 덮인 꺼풀을 콩팥과 함께 취할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","제사장은 그것을 단 위에 불사를지니 이는 화제로 드리는 식물이요, 향기로운 냄새라 모든 기름은 여호와의 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","너희는 기름과 피를 먹지 말라 ! 이는 너희 모든 처소에서 대대로 영원한 규례니라 ");
INSERT INTO kor_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","이스라엘 자손에게 고하여 이르라 누구든지 여호와의 금령 중 하나라도 그릇 범하였으되 ");
INSERT INTO kor_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","만일 기름 부음을 받은 제사장이 범죄하여 백성으로 죄얼을 입게 하였으면 그 범한 죄를 인하여 흠 없는 수송아지로 속죄 제물을 삼아 여호와께 드릴지니 ");
INSERT INTO kor_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","곧 그 수송아지를 회막문 여호와 앞으로 끌어다가 그 수송아지 머리에 안수하고 그것을 여호와 앞에서 잡을 것이요 ");
INSERT INTO kor_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","기름 부음을 받은 제사장은 그 수송아지의 피를 가지고 회막에 들어가서 ");
INSERT INTO kor_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","그 제사장이 손가락에 그 피를 찍어 여호와 앞 곧 성소 장 앞에 일곱번 뿌릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","제사장은 또 그 피를 여호와 앞 곧 회막 안 향단 뿔에 바르고 그 송아지의 피 전부를 회막문 앞 번제단 밑에 쏟을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","또 그 속죄 제물 된 수송아지의 모든 기름을 취할지니 곧 내장에 덮인 기름과, 내장에 붙은 모든 기름과, ");
INSERT INTO kor_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","두 콩팥과, 그 위의 기름 곧 허리 근방에 있는 것과, 간에 덮인 꺼풀을 콩팥과, 함께 취하되 ");
INSERT INTO kor_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","화목제 희생의 소에게서 취함 같이 할 것이요, 제사장은 그것을 번제단 위에 불사를 것이며 ");
INSERT INTO kor_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","그 수송아지의 가죽과, 그 모든 고기와, 그 머리와, 다리와, 내장과, ");
INSERT INTO kor_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","곧 그 송아지의 전체를 진 바깥 재 버리는 곳인 청결한 곳으로 가져다가 불로 나무 위에 사르되 곧 재 버리는 곳에서 사를지니라 ");
INSERT INTO kor_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","만일 이스라엘 온 회중이 여호와의 금령 중 하나라도 그릇 범하여 허물이 있으나 스스로 깨닫지 못하다가 ");
INSERT INTO kor_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","그 범한 죄를 깨달으면 회중은 수송아지를 속죄제로 드릴지니 그것을 회막 앞으로 끌어다가 ");
INSERT INTO kor_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","회중의 장로들이 여호와 앞에서 그 수송아지 머리에 안수하고 그것을 여호와 앞에서 잡을 것이요 ");
INSERT INTO kor_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","기름 부음을 받은 제사장은 그 수송아지의 피를 가지고 회막에 들어가서 ");
INSERT INTO kor_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","그 제사장이 손가락으로 그 피를 찍어 여호와 앞 장 앞에 일곱번 뿌릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","또 그 피로 회막 안 여호와 앞에 있는 단 뿔에 바르고 그 피 전부는 회막문 앞 번제단 밑에 쏟을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","그 기름은 다 취하여 단 위에 불사르되 ");
INSERT INTO kor_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","그 송아지를 속제죄의 수송아지에게 한 것 같이 할지며 제사장이 그것으로 회중을 위하여 속죄한즉 그들이 사함을 얻으리라 ! ");
INSERT INTO kor_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","그는 그 수송아지를 진 밖으로 가져다가 첫번 수송아지를 사름같이 사를지니 이는 회중의 속죄제니라 ");
INSERT INTO kor_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","만일 족장이 그 하나님 여호와의 금령 중 하나라도 부지중에 범하여 허물이 있었다가 ");
INSERT INTO kor_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","그 범한 죄에 깨우침을 받거든 그는 흠 없는 수염소를 예물로 가져다가 ");
INSERT INTO kor_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","그 수염소의 머리에 안수하고 여호와 앞 번제 희생을 잡는 곳에서 잡을지니 이는 속죄제라 ");
INSERT INTO kor_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","제사장은 그 속죄 희생의 피를 손가락으로 찍어 번제단 뿔에 바르고 그 피는 번제단 밑에 쏟고 ");
INSERT INTO kor_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","그 모든 기름은 화목제 희생의 기름같이 단 위에 불사를지니 이같이 제사장이 그 범한 죄에 대하여 그를 위하여 속죄한즉 그가 사함을 얻으리라 ! ");
INSERT INTO kor_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","만일 평민의 하나가 여호와의 금령 중 하나라도 부지중에 범하여 허물이 있었다가 ");
INSERT INTO kor_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","그 범한 죄에 깨우침을 받거든 그는 흠 없는 암염소를 끌고와서 그 범한 죄를 인하여 그것을 예물로 삼아 ");
INSERT INTO kor_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","그 속죄제 희생의 머리에 안수하고 그 희생을 번제소에서 잡을 것이요 ");
INSERT INTO kor_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","제사장은 손가락으로 그 피를 찍어 번제단 뿔에 바르고 그 피 전부를 단 밑에 쏟고 ");
INSERT INTO kor_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","그 모든 기름을 화목제 희생의 기름을 취한 것 같이 취하여 단 위에 불 살라 여호와께 향기롭게 할지니 제사장이 그를 위하여 속죄 한즉 그가 사함을 얻으리라 ! ");
INSERT INTO kor_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","그가 만일 어린 양을 속죄 제물로 가져 오려거든 흠 없는 암컷을 끌어다가 ");
INSERT INTO kor_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","그 속죄제 희생의 머리에 안수하고 번제 희생을 잡는 곳에서 잡아 속죄제를 삼을 것이요 ");
INSERT INTO kor_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","제사장은 그 속죄제 희생의 피를 손가락으로 찍어 번제단 뿔에 바르고 그 피는 전부를 단 밑에 쏟고 ");
INSERT INTO kor_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","그 모든 기름을 화목제 어린 양의 기름을 취한것 같이 취하여 단 위 여호와의 화제물 위에 불사를지니 이같이 제사장이 그의 범한죄에 대하여 그를 위하여 속죄한즉 그가 사함을 얻으리라 ");
INSERT INTO kor_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","누구든지 증인이 되어 맹세시키는 소리를 듣고도 그 본 일이나 아는 일을 진술치 아니하면 죄가 있나니 그 허물이 그에게로 돌아갈 것이요 ");
INSERT INTO kor_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","누구든지 부정한 들짐승의 사체나, 부정한 가축의 사체나, 부정한 곤충의 사체들, 무릇 부정한 것을 만졌으면 부지중에라 할지라도 그 몸이 더러워져서 허물이 있을 것이요 ");
INSERT INTO kor_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","혹시 부지중에 사람의 부정에 다닥쳤는데 그 사람의 부정이 어떠한 부정이든지 그것을 깨달을 때에는 허물이 있을 것이요 ");
INSERT INTO kor_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","혹 누구든지 무심중에 입으로 맹세를 발하여 악을 하리라 하든지, 선을 하리라 하면 그 사람의 무심중에 맹세를 발하여 말한 것이 어떠한 일이든지 깨닫지 못하다가 그것을 깨달을 때에는 그 중 하나에 허물이 있을 것이니 ");
INSERT INTO kor_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","이 중 하나에 허물이 있을 때에는 아무 일에 범과하였노라 자복하고 ");
INSERT INTO kor_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","그 범과를 인하여 여호와께 속건제를 드리되 양떼의 암컷 어린 양이나 염소를 끌어다가 속죄제를 드릴 것이요 제사장은 그의 허물을 위하여 속죄할지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","만일 힘이 어린 양에 미치지 못하거든 그 범과를 속하기 위하여 산비둘기 둘이나 집비둘기 새끼 둘을 여호와께로 가져 가되 하나는 속죄제물을 삼고, 하나는 번제물을 삼아 ");
INSERT INTO kor_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","제사장에게로 가져 갈 것이요, 제사장은 그 속죄 제물을 먼저 드리되 그 머리를 목에서 비틀어 끊고 몸은 아주 쪼개지 말며 ");
INSERT INTO kor_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","그 속죄 제물의 피를 단 곁에 뿌리고 그 남은 피는 단 밑에 흘릴지니 이는 속죄제요 ");
INSERT INTO kor_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","그 다음 것은 규례대로 번제를 드릴지니 제사장이 그의 범과를 위하여 속한즉 그가 사함을 얻으리라 ! ");
INSERT INTO kor_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","만일 힘이 산비둘기 둘이나 집비둘기 둘에도 미치지 못하거든 그 범과를 인하여 고운 가루 에바 십분 일을 예물로 가져다가 속죄 제물로 드리되 이는 속죄제인즉 그 위에 기름을 붓지 말며 유향을 놓지 말고 ");
INSERT INTO kor_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","그것을 제사장에게로 가져갈 것이요, 제사장은 그것을 기념물로 한 움큼을 취하여 단 위 여호와의 화제물 위에 불사를지니 이는 속죄제라 ");
INSERT INTO kor_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","제사장이 그가 이 중에 하나를 범하여 얻은 허물을 위하여 속한즉 그가 사함을 얻으리라 ! 그 나머지는 소제물같이 제사장에게 돌릴지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","누구든지 여호와의 성물에 대하여 그릇 범과하였거든 여호와께 속건제를 드리되 너의 지정한 가치를 따라 성소의 세겔로 몇 세겔 은에 상당한 흠 없는 수양을 떼 중에서 끌어다가 속건제로 드려서 ");
INSERT INTO kor_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","성물에 대한 범과를 갚되 그것에 오분 일을 더하여 제사장에게 줄 것이요 제사장은 그 속건제의 수양으로 그를 위하여 속한즉 그가 사함을 얻으리라 ! ");
INSERT INTO kor_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","만일 누구든지 여호와의 금령 중 하나를 부지중에 범하여도 허물이라 벌을 당할 것이니 ");
INSERT INTO kor_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","그는 너의 지정한 가치대로 떼 중 흠 없는 수양을 속건 제물로 제사장에게로 가져올 것이요, 제사장은 그의 부지중에 그릇 범한 허물을 위하여 속한즉 그가 사함을 얻으리라 ! ");
INSERT INTO kor_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","이는 속건제니 그가 실로 여호와 앞에 범과함이니라 ");
INSERT INTO kor_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","누구든지 여호와께 신실치 못하여 범죄하되 곧 남의 물건을 맡거나 전당 잡거나 강도질하거나 늑봉하고도 사실을 부인하거나 ");
INSERT INTO kor_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","남의 잃은 물건을 얻고도 사실을 부인하여 거짓 맹세하는 등 사람이 이 모든 일 중에 하나라도 행하여 범죄하면 ");
INSERT INTO kor_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","이는 죄를 범하였고 죄가 있는 자니 그 빼앗은 것이나 늑봉한 것이나 맡은 것이나 얻은 유실물이나 ");
INSERT INTO kor_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","무릇 그 거짓 맹세한 물건을 돌려 보내되 곧 그 본물에 오분 일을 더하여 돌려 보낼 것이니 그 죄가 드러나는 날에 그 임자에게 줄 것이요 ");
INSERT INTO kor_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","그는 또 그 속건제를 여호와께 가져 올지니 곧 너의 지정한 가치대로 떼 중 흠 없는 수양을 속건 제물을 위하여 제사장에게로 끌어 올 것이요 ");
INSERT INTO kor_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","제사장은 여호와 앞에서 그를 위하여 속죄한즉 그는 무슨 허물이든지 사함을 얻으리라 ! ");
INSERT INTO kor_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","아론과 그 자손에게 명하여 이르라 번제의 규례는 이러하니라 번제물은 단 위 석쇠 위에 아침까지 두고 단의 불로 그 위에서 꺼지지 않게 할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","제사장은 세마포 긴 옷을 입고 세마포 고의로 하체를 가리우고 단 위에서 탄 번제의 재를 가져다가 단 곁에 두고 ");
INSERT INTO kor_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","그 옷을 벗고 다른 옷을 입고 그 재를 진 바깥 정결한 곳으로 가져 갈 것이요 ");
INSERT INTO kor_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","단 위에 불은 항상 피워 꺼지지 않게 할지니 제사장은 아침마다 나무를 그 위에 태우고 번제물을 그 위에 벌여놓고 화목제의 기름을 그 위에 사를지며 ");
INSERT INTO kor_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","불은 끊이지 않고 단 위에 피워 꺼지지 않게 할지니라 ");
INSERT INTO kor_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","소제의 규례는 이러하니라 아론의 자손은 그것을 단 앞 여호와 앞에 드리되 ");
INSERT INTO kor_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","그 소제의 고운 기름 가루 한 웅큼과 소제물 위의 유향을 다 취하여 기념물로 단 위에 불살라 여호와 앞에 향기로운 냄새가 되게 하고 ");
INSERT INTO kor_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","그 나머지는 아론과 그 자손이 먹되 누룩을 넣지 말고 거룩한 곳 회막 뜰에서 먹을지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","그것에 누룩을 넣어 굽지 말라 ! 이는 나의 화제 중에서 내가 그들에게 주어 그 소득이 되게 하는 것이라 속죄제와 속건제같이 지극히 거룩한즉 ");
INSERT INTO kor_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","무릇 아론 자손의 남자는 이를 먹을지니 이는 여호와의 화제 중에서 그들의 대대로 영원한 소득이 됨이라 이를 만지는 자마다 거룩하니라 ! ");
INSERT INTO kor_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","아론과 그 자손이 기름 부음을 받는 날에 여호와께 드릴 예물은 이러하니라 고운 가루 에바 십분 일을 항상 드리는 소제물로 삼아 그 절반은 아침에,절반은 저녁에 드리되 ");
INSERT INTO kor_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","그것을 기름으로 반죽하여 번철에 굽고 기름에 적시어다가 썰어 소제로 여호와께 드려 향기로운 냄새가 되게 하라 ");
INSERT INTO kor_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","이 소제는 아론의 자손 중 기름 부음을 받고 그를 이어 제사장 된 자가 드릴 것이요, 영원한 규례로 여호와께 온전히 불사를 것이니 ");
INSERT INTO kor_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","무릇 제사장의 소제물은 온전히 불사르고 먹지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","아론과 그 아들들에게 고하여 이르라 ! 속죄제의 규례는 이러하니라 속죄제 희생은 지극히 거룩하니 여호와 앞 번제 희생을 잡는 곳에서 그 속죄제 희생을 잡을 것이요 ");
INSERT INTO kor_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","죄를 위하여 제사드리는 제사장이 그것을 먹되 곧 회막 뜰 거룩한 곳에서 먹을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","무릇 그 고기에 접촉하는 자는 거룩할 것이며 그 피가 어떤 옷에든지 묻었으면 묻은 그것을 거룩한 곳에서 빨 것이요 ");
INSERT INTO kor_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","그 고기를 토기에 삶았으면 그 그릇을 깨뜨릴 것이요, 유기에 삶았으면 그 그릇을 닦고 물에 씻을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","그 고기는 지극히 거룩하니 제사장의 남자마다 먹을 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","그러나 피를 가지고 회막에 들어가 성소에서 속하게 한 속죄제 희생의 고기는 먹지 못할지니 불사를지니라 ");
INSERT INTO kor_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","속건제의 규례는 이러하니라 이는 지극히 거룩하니 ");
INSERT INTO kor_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","번제 희생을 잡는 곳에서 속건제의 희생을 잡을 것이요 제사장은 그 피를 단 사면에 뿌릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","그 모든 기름을 드리되 곧 그 기름진 꼬리와, 내장에 덮인 기름과, ");
INSERT INTO kor_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","두 콩팥과, 그 위의 기름 곧 허리 근방에 있는 것과, 간에 덮인 꺼풀을 콩팥과 함께 취하고 ");
INSERT INTO kor_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","제사장은 그것을 다 단 위에 불살라 여호와께 화제로 드릴 것이니라 이는 속건제요 ");
INSERT INTO kor_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","지극히 거룩하니 이것을 제사장의 남자마다 먹되 거룩한 곳에서 먹을지며 ");
INSERT INTO kor_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","속건제나 속죄제는 일례니 그 제육은 속하는 제사장에게로 돌아갈 것이요 ");
INSERT INTO kor_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","사람의 번제를 드리는 제사장 곧 그 제사장은 그 드린 번제물의 가죽을 자기가 얻을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","무릇 화덕에 구운 소제물과 솥에나 번철에 만든 소제물은 그 드린 제사장에게로 돌아갈 것이니 ");
INSERT INTO kor_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","무릇 소제물은 기름 섞은 것이나 마른 것이나 아론의 모든 자손이 평균히 분배할 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","여호와께 드릴 화목제 희생의 규례는 이러하니라 ");
INSERT INTO kor_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","만일 그것을 감사하므로 드리거든 기름 섞은 무교병과 기름 바른 무교병과 고운 가루에 기름 섞어 구운 과자를 그 감사 희생과 함께 드리고 ");
INSERT INTO kor_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","또 유교병을 화목제의 감사 희생과 함께 그 예물에 드리되 ");
INSERT INTO kor_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","그 전체의 예물 중에서 하나씩 여호와께 거제로 드리고 그것을 화목제의 피를 뿌린 제사장들에게로 돌릴지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","감사함으로 드리는 화목제 희생의 고기는 드리는 그 날에 먹을 것이요, 조금이라도 이튿날 아침까지 두지 말 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","그러나 그 희생의 예물이 서원이나 자원의 예물이면 그 희생을 드린 날에 먹을 것이요, 그 남은 것은 이튿날에도 먹되 ");
INSERT INTO kor_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","그 희생의 고기가 제 삼일까지 남았으면 불사를지니 ");
INSERT INTO kor_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","만일 그 화목제 희생의 고기를 제 삼일에 조금이라도 먹으면 그 제사는 열납되지 않을 것이라 드린 자에게도 예물답게 못되고 도리어 가증한 것이 될 것이며 그것을 먹는 자는 죄를 당하리라 ");
INSERT INTO kor_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","그 고기가 부정한 물건에 접촉되었으면 먹지 말고 불사를 것이라 그 고기는 깨끗한 자만 먹을 것이니 ");
INSERT INTO kor_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","만일 몸이 부정한 자가 여호와께 속한 화목제 희생의 고기를 먹으면 그 사람은 자기 백성 중에서 끊쳐질 것이요 ");
INSERT INTO kor_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","만일 누구든지 부정한 것 곧 사람의 부정이나 부정한 짐승이나 부정하고 가증한 아무 물건이든지 만지고 여호와께 속한 화목제 희생의 고기를 먹으면 그 사람도 자기 백성 중에서 끊쳐지리라 ! ");
INSERT INTO kor_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","이스라엘 자손에게 고하여 이르라 너희는 소나 양이나 염소의 기름을 먹지 말 것이요 ");
INSERT INTO kor_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","스스로 죽은 것의 기름이나 짐승에게 찢긴 것의 기름은 달리는 쓰려니와 결단코 먹지 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","사람이 여호와께 화제로 드리는 희생의 기름을 먹으면 그 먹는 자는 자기 백성 중에서 끊쳐지리라 ! ");
INSERT INTO kor_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","너희의 사는 모든 곳에서 무슨 피든지 새나 짐승의 피를 먹지 말라 ! ");
INSERT INTO kor_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","무슨 피든지 먹는 사람이 있으면 그 사람은 다 자기 백성 중에서 끊쳐지리라 ! ");
INSERT INTO kor_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","이스라엘 자손에게 고하여 이르라 화목제의 희생을 여호와께 드리려는 자는 그 화목제 희생 중에서 그 예물을 취하여 여호와께 가져오되 ");
INSERT INTO kor_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","여호와의 화제는 그 사람이 자기 손으로 가져올지니 곧 그 제물의 기름과 가슴을 가져올 것이요 제사장은 그 가슴을 여호와 앞에 흔들어 요제를 삼고 ");
INSERT INTO kor_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","그 기름은 단 위에 불사를 것이며 가슴은 아론과 그 자손들에게 돌릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","또 너희는 그 화목제 희생의 우편 뒷다리를 제사장에게 주어 거제를 삼을지니 ");
INSERT INTO kor_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","아론의 자손 중 화목제 희생의 피와 기름을 드리는 자가 그 우편 뒷다리를 자기의 소득으로 삼을 것이라 ");
INSERT INTO kor_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","내가 이스라엘 자손의 화목제 중에서 그 흔든 가슴과 든 뒷다리를 취하여 제사장 아론과 그 자손에게 주었나니 이는 이스라엘 자손에게 받을 영원한 소득이니라 ");
INSERT INTO kor_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","이는 여호와의 화제 중에서 아론에게 돌릴 것과 그 자손에게 돌릴 것이니 그들을 세워 여호와의 제사장의 직분을 행하게 한 날 ");
INSERT INTO kor_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","곧 그들에게 기름 부은 날에 여호와께서 명하사 이스라엘 자손 중에서 그들에게 돌리게 하신 것이라 대대로 영원히 받을 소득이니라 ");
INSERT INTO kor_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","이는 번제와, 소제와, 속죄제와, 속건제와, 위임제와, 화목제의 규례라 ");
INSERT INTO kor_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","여호와께서 시내 광야에서 이스라엘 자손에게 그 예물을 여호와께 드리라 명하신 날에 시내산에서 이같이 모세에게 명하셨더라 ");
INSERT INTO kor_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","너는 아론과, 그 아들들과, 그 의복과, 관유와, 속죄제의 수송아지와 수양 둘과 무교병 한 광주리를 이끌고 ");
INSERT INTO kor_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","온 회중을 회막 문에 모으라 ");
INSERT INTO kor_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","모세가 여호와꼐서 자기에게 명하신 대로 하매 회중이 회막 문에 모인지라 ");
INSERT INTO kor_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","모세가 회중에게 이르되 '여호와께서 행하라고 명하신 것이 이러하니라' 하고 ");
INSERT INTO kor_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","아론과 그 아들들을 데려다가 물로 그들을 씻기고 ");
INSERT INTO kor_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","아론에게 속옷을 입히며 띠를 띠우고 겉옷을 입히며 에봇을 더하고 에봇의 기묘하게 짠 띠를 띠워서 에봇을 몸에 매고 ");
INSERT INTO kor_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","흉패를 붙이고 흉패에 우림과 둠밈을 넣고 ");
INSERT INTO kor_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","그 머리에 관을 씌우고 그 관 위 전면에 금패를 붙이니 곧 거룩한 관이라 여호와께서 모세에게 명하심과 같았더라 ");
INSERT INTO kor_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","모세가 관유를 취하여 장막과 그 안에 있는 모든 것에 발라 거룩하게 하고 ");
INSERT INTO kor_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","또 단에 일곱번 뿌리고 또 그 단과 그 모든 기구와 물두멍과 그 받침에 발라 거룩하게 하고 ");
INSERT INTO kor_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","또 관유로 아론의 머리에 부어 발라 거룩하게 하고 ");
INSERT INTO kor_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","모세가 또 아론의 아들들을 데려다가 그들에게 속옷을 입히고 띠를 띠우며 관을 씌웠으니 여호와께서 모세에게 명하심과 같았더라 ");
INSERT INTO kor_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","모세가 또 속죄제의 수송아지를 끌어오니 아론과 그 아들들이 그 속죄제 수송아지 머리에 안수하매 ");
INSERT INTO kor_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","모세가 잡고 그 피를 취하여 손가락으로 그 피를 단의 네 귀퉁이 뿔에 발라 단을 깨끗하게 하고 그 피는 단 밑에 쏟아 단을 속하여 거룩하게 하고 ");
INSERT INTO kor_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","또 내장에 덮인 모든 기름과, 간 꺼풀과, 두 콩팥과, 그 기름을 취하여 단 위에 불사르고 ");
INSERT INTO kor_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","그 수송아지 곧 그 가죽과 고기와 똥은 진 밖에 불살랐으니 여호와께서 모세에게 명하심과 같았더라 ");
INSERT INTO kor_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","또 번제의 수양을 드릴새 아론과 그 아들들이 그 수양의 머리에 안수하매 ");
INSERT INTO kor_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","모세가 잡아 그 피를 단 주위에 뿌리고 ");
INSERT INTO kor_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","그 수양의 각을 뜨고 그 머리와 각뜬 것과 기름을 불사르고 ");
INSERT INTO kor_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","물로 내장과 정갱이들을 씻고 그 수양의 전부를 단 위에 불사르니 이는 향기로운 냄새를 위하여 드리는 번제로 여호와께 드리는 화제라 여호와께서 모세에게 명하심과 같았더라 ");
INSERT INTO kor_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","또 다른 수양 곧 위임식의 수양을 드릴새 아론과 그 아들들이 그 수양의 머리에 안수하매 ");
INSERT INTO kor_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","모세가 잡고 그 피를 취하여 아론의 오른 귓부리와, 오른손 엄지 가락과, 오른발 엄지가락에 바르고 ");
INSERT INTO kor_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","아론의 아들들을 데려다가 그 오른 귓부리와, 오른손 엄지가락과, 오른발 엄지가락에 그 피를 바르고 또 그 피를 단 주위에 뿌리고 ");
INSERT INTO kor_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","그가 또 그 기름과, 기름진 꼬리와, 내장에 덮인 모든 기름과, 간 꺼풀과, 두 콩팥과, 기름과, 우편 뒷다리를 취하고 ");
INSERT INTO kor_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","여호와 앞 무교병 광주리에서 무교병 한개와 기름 섞은 떡 한개와 전병 한개를 취하여 그 기름 위에와 우편 뒷다리 위에 놓아 ");
INSERT INTO kor_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","그 전부를 아론의 손과 그 아들들의 손에 두어 여호와 앞에 흔들어 요제를 삼게 하고 ");
INSERT INTO kor_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","모세가 그것을 그들의 손에서 취하여 단 윗 번제물 위에 불사르니 이는 향기로운 냄새를 위하여 드리는 위임식 제사로 여호와께 드리는 화제라 ");
INSERT INTO kor_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","이에 모세가 그 가슴을 취하여 여호와 앞에 흔들어 요제를 삼았으니 이는 위임식 수양의 모세의 응식이라 여호와께서 모세에게 명하심과 같았더라 ");
INSERT INTO kor_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","모세가 관유와 단 위의 피를 취하여 아론과 그 옷과 그 아들들과 그 아들들의 옷에 뿌려서 아론과 그 옷과 그 아들들과 그 아들들의 옷을 거룩하게 하고 ");
INSERT INTO kor_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","아론과 그 아들들에게 이르되 `내게 이미 명하시기를 아론과 그 아들들은 먹으라 하셨은즉 너희는 회막 문에서 그 고기를 삶아 위임식 광주리 안의 떡과 아울러 그 곳에서 먹고 ");
INSERT INTO kor_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","고기와 떡의 나머지는 불사를지며 ");
INSERT INTO kor_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","위임식은 칠일 동안 행하나니 위임식이 마치는 날까지 칠일 동안은 회막 문에 나가지 말라 ");
INSERT INTO kor_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","오늘날 행한 것은 여호와께서 너희를 위하여 속하게 하시려고 명하신 것이니 ");
INSERT INTO kor_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","너희는 칠 주야를 회막 문에 거하여 여호와의 부탁을 지키라 ! 그리하면 사망을 면하리라 내가 이같이 명령을 받았느니라' ");
INSERT INTO kor_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","아론과 그 아들들이 여호와께서 모세로 명하신 모든 일을 준행하니라 ");
INSERT INTO kor_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","제 팔일에 모세가 아론과 그 아들들과 이스라엘 장로들을 불러다가 ");
INSERT INTO kor_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","아론에게 이르되 `흠 없는 송아지를 속죄제를 위하여 취하고 흠 없는 수양을 번제를 위하여 취하여 여호와 앞에 드리고 ");
INSERT INTO kor_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","이스라엘 자손에게 고하여 이르기를 너희는 수염소를 속죄제를 위하여 취하고 또 송아지와 어린 양의 일년 되고 흠 없는 것을 번제를 위하여 취하고 ");
INSERT INTO kor_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","또 화목제를 위하여 여호와 앞에 드릴 수소와 수양을 취하고 또 기름 섞은 소제물을 가져오라 하라 오늘 여호와께서 너희에게 나타나실 것임이니라' 하매 ");
INSERT INTO kor_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","그들이 모세의 명한 모든 것을 회막 앞으로 가져 오고 온 회중이 나아와 여호와 앞에 선지라 ");
INSERT INTO kor_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","모세가 가로되 `이는 여호와께서 너희에게 하라고 명하신 것이니 여호와의 영광이 너희에게 나타나리라' ");
INSERT INTO kor_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","그가 또 아론에게 이르되 `너는 단에 나아가 네 속죄제와 네 번제를 드려서 너를 위하여,백성을 위하여 속하고 또 백성의 예물을 드려서 그들을 위하여 속하되 무릇 여호와의 명대로 하라' ");
INSERT INTO kor_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","이에 아론이 단에 나아가 자기를 위한 속죄제 송아지를 잡으매 ");
INSERT INTO kor_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","아론의 아들들이 그 피를 아론에게 받들어 주니 아론이 손가락으로 그 피를 찍어 단 뿔들에 바르고 그 피는 단 밑에 쏟고 ");
INSERT INTO kor_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","그 속죄제 희생의 기름과 콩팥과 간 꺼풀을 단 위에 불사르니 여호와께서 모세에게 명하심과 같았고 ");
INSERT INTO kor_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","그 고기와 가죽은 진 밖에서 불사르니라 ");
INSERT INTO kor_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","아론이 또 번제 희생을 잡으매 아론의 아들들이 그 피를 그에게로 가져오니 그가 그 피를 단 주위에 뿌리고 ");
INSERT INTO kor_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","그들이 또 번제의 희생 곧 그 각과 머리를 그에게로 가져오매 그가 단 위에 불사르고 ");
INSERT INTO kor_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","또 내장과 정갱이는 씻어서 단 윗 번제물 위에 불사르니라 ");
INSERT INTO kor_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","그가 또 백성의 예물을 드리되 곧 백성을 위한 속죄제의 염소를 취하여 잡아 전과 같이 죄를 위하여 드리고 ");
INSERT INTO kor_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","또 번제 희생을 드리되 규례대로 드리고 ");
INSERT INTO kor_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","또 소제를 드리되 그 중에서 한 움큼을 취하여 아침 번제물에 더하여 단 위에 불사르고 ");
INSERT INTO kor_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","또 백성을 위하는 화목제 희생의 수소와 수양을 잡으매 아론의 아들들이 그 피를 그에게로 가져오니 그가 단 주위에 뿌리고 ");
INSERT INTO kor_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","그들이 또 수소와, 수양의 기름과, 기름진 꼬리와, 내장에 덮인 것과, 콩팥과, 간 꺼풀을 아론에게로 가져다가 ");
INSERT INTO kor_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","그 기름을 가슴들 위에 놓으매 아론이 그 기름을 단위에 불사르고 ");
INSERT INTO kor_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","가슴들과 우편 뒷다리를 그가 여호와 앞에 요제로 흔드니 모세의 명한 것과 같았더라 ");
INSERT INTO kor_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","아론이 백성을 향하여 손을 들어 축복함으로 속죄제와 번제와 화목제를 필하고 내려오니라 ");
INSERT INTO kor_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","모세와 아론이 회막에 들어 갔다가 나와서 백성에게 축복하매 여호와의 영광이 온 백성에게 나타나며 ");
INSERT INTO kor_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","불이 여호와 앞에서 나와 단 위의 번제물과 기름을 사른지라 온 백성이 이를 보고 소리지르며 엎드렸더라 ");
INSERT INTO kor_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","아론의 아들 나답과 아비후가 각기 향로를 가져다가 여호와의 명하시지 않은 다른 불을 담아 여호와 앞에 분향하였더니 ");
INSERT INTO kor_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","불이 여호와 앞에서 나와 그들을 삼키매 그들이 여호와 앞에서 죽은지라 ");
INSERT INTO kor_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","모세가 아론에게 이르되 `이는 여호와의 말씀이라 ! 이르시기를 나는 나를 가까이 하는 자 중에 내가 거룩하다 함을 얻겠고 온 백성 앞에 내가 영광을 얻으리라 하셨느니라' 아론이 잠잠하니 ");
INSERT INTO kor_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","모세가 아론의 아자비 웃시엘의 아들 미사엘과 엘사반을 불러 그들에게 이르되 '나아와 너희 형제들을 성소 앞에서 진 밖으로 메어 가라' 하매 ");
INSERT INTO kor_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","그들이 나아와 모세의 명대로 그들을 옷 입은 채 진 밖으로 메어내니 ");
INSERT INTO kor_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","모세가 아론과 그 아들 엘르아살과 이다말에게 이르되 `너희는 머리를 풀거나 옷을 찢지 말아서 너희 죽음을 면하고 여호와의 진노가 온 회중에게 미침을 면케 하라 오직 너희 형제 이스라엘 온 족속이 여호와의 치신 불로 인하여 슬퍼할 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","여호와의 관유가 너희에게 있은즉 너희는 회막 문에 나가지 말아서 죽음을 면할지니라' 그들이 모세의 명대로 하니라 ");
INSERT INTO kor_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","여호와께서 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","너나 네 자손들이 회막에 들어갈 때에는 포도주나 독주를 마시지 말아서 너희 사망을 면하라 ! 이는 너희 대대로 영영한 규례라 ");
INSERT INTO kor_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","그리하여야 너희가 거룩하고 속된 것을 분별하며 부정하고 정한 것을 분별하고 ");
INSERT INTO kor_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","또 여호와가 모세로 명한 모든 규례를 이스라엘 자손에게 가르치리라 ");
INSERT INTO kor_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","모세가 아론과 그 남은 아들 엘르아살에게와 이다말에게 이르되 여호와께 드린 화제중 소제의 남은 것은 지극히 거룩하니 너희는 그것을 취하여 누룩을 넣지 말고 단 곁에서 먹되 ");
INSERT INTO kor_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","이는 여호와의 화제 중 네 응식과 네 아들의 응식인즉 너희는 그것을 거룩한 곳에서 먹으라 ! 내가 명령을 받았느니라 ");
INSERT INTO kor_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","흔든 가슴과 든 뒷다리는 너와 네 자녀가 너와 함께 정결한 곳에서 먹을지니 이는 이스라엘 자손의 화목제 희생 중에서 네 응식과 네 자손의 응식으로 주신 것임이니라 ");
INSERT INTO kor_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","그 든 뒷다리와 흔든 가슴으로 화제의 기름과 함께 가져다가 여호와 앞에 흔들어 요제를 삼을지니 이는 여호와의 명령대로 너와 네 자손의 영원한 응식이니라' ");
INSERT INTO kor_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","모세가 속죄제 드린 염소를 찾은즉 이미 불살랐는지라 그가 아론의 남은 아들 엘르아살과 이다말에게 노하여 가로되 ");
INSERT INTO kor_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","`이 속죄제 희생은 지극히 거룩하거늘 너희가 어찌하여 거룩한 곳에서 먹지 아니하였느뇨 ? 이는 너희로 회중의 죄를 담당하여 그들을 위하여 여호와 앞에 속하게 하려고 너희에게 주신 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","그 피를 성소에 들여오지 아니하였으니 그 제육은 너희가 나의 명한 대로 거룩한 곳에서 먹었어야 할 것이니라' ");
INSERT INTO kor_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","아론이 모세에게 이르되 `오늘 그들이 그 속죄제와 번제를 여호와께 드렸어도 이런 일이 내게 임하였거늘 오늘 내가 속죄 제육을 먹었더면 여호와께서 어찌 선히 여기셨으리요' ");
INSERT INTO kor_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","모세가 그 말을 듣고 좋게 여겼더라 ");
INSERT INTO kor_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","여호와께서 모세와 아론에게 고하여 그들에게 이르시되 ");
INSERT INTO kor_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","이스라엘 자손에게 고하여 이르라 육지 모든 짐승 중 너희의 먹을만한 생물은 이러하니 ");
INSERT INTO kor_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","짐승중 무릇 굽이 갈라져 쪽발이 되고 새김질하는 것은 너희가 먹되 ");
INSERT INTO kor_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","새김질하는 것이나 굽이 갈라진 짐승 중에도 너희가 먹지 못할 것은 이러하니 약대는 새김질은 하되 굽이 갈라지지 아니하였으므로 너희에게 부정하고 ");
INSERT INTO kor_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","사반도 새김질은 하되 굽이 갈라지지 아니하였으므로 너희에게 부정하고 ");
INSERT INTO kor_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","토끼도 새김질은 하되 굽이 갈라지지 아니하였으므로 너희에게 부정하고 ");
INSERT INTO kor_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","돼지는 굽이 갈라져 쪽발이로되 새김질을 못하므로 너희에게 부정하니 ");
INSERT INTO kor_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","너희는 이 고기를 먹지 말고 그 주검도 만지지 말라 이것들은 너희에게 부정하니라 ");
INSERT INTO kor_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","물에 있는 모든 것 중 너희의 먹을 만한 것은 이것이니 무릇 강과 바다와 다른 물에 있는 것 중에 지느러미와 비늘 있는 것은 너희가 먹되 ");
INSERT INTO kor_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","무릇 물에서 동하는 것과, 무릇 물에서 사는 것 곧 무릇 강과, 바다에 있는 것으로서 지느러미와 비늘 없는 것은 너희에게 가증한 것이라 ");
INSERT INTO kor_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","이들은 너희에게 가증한 것이니 너희는 그 고기를 먹지 말고 그 주검을 가증히 여기라 ");
INSERT INTO kor_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","수중 생물에 지느러미와 비늘 없는 것은 너희에게 가증하니라 ");
INSERT INTO kor_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","새 중에 너희가 가증히 여길 것은 이것이라 이것들이 가증한즉 먹지 말지니 곧 독수리와, 솔개와, 어응과, ");
INSERT INTO kor_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","매와, 매 종류와, ");
INSERT INTO kor_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","까마귀 종류와 ");
INSERT INTO kor_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","타조와, 다호마스와, 갈매기와, 새매 종류와, ");
INSERT INTO kor_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","올빼미와, 노자와, 부엉이와, ");
INSERT INTO kor_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","따오기와, 당아와, 올응과, ");
INSERT INTO kor_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","학과, 황새 종류와, 대승과, 박쥐니라 ");
INSERT INTO kor_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","날개가 있고 네 발로기어 다니는 곤충은 너희에게 가증하되 ");
INSERT INTO kor_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","오직 날개가 있고 네 발로 기어다니는 모든 곤충중에 그 발에 뛰는 다리가 있어서 땅에서 뛰는 것은 너희가 먹을지니 ");
INSERT INTO kor_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","곧 그 중에 메뚜기 종류와, 베짱이 종류와, 귀뚜라미 종류와, 팟종이 종류는 너희가 먹으려니와 ");
INSERT INTO kor_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","오직 날개가 있고 기어다니는 곤충은 다 너희에게 가증하니라 ");
INSERT INTO kor_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","이런 유는 너희를 부정케 하나니 누구든지 이것들의 주검을 만지면 저녁까지 부정할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","무릇 그 주검을 옮기는 자는 그 옷을 빨지니 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","무릇 굽이 갈라진 짐승 중에 쪽발이 아닌 것이나 새김질 아니하는 것의 주검은 다 네게 부정하니 만지는 자는 부정할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","네 발로 다니는 모든 짐승 중 발바닥으로 다니는 것은 다 네게 부정하니 그 주검을 만지는 자는 저녁까지 부정할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","그 주검을 옮기는 자는 그 옷을 빨지니 저녁까지 부정하리라 그것들이 네게 부정하니라 ");
INSERT INTO kor_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","땅에 기는 바 기는 것 중에 네게 부정한 것은 이러하니 곧 쪽제비와, 쥐와, 도마뱀 종류와, ");
INSERT INTO kor_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","합개와, 육지 악어와, 수궁과, 사막 도마뱀과, 칠면석척이라 ");
INSERT INTO kor_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","모든 기는 것 중 이것들은 네게 부정하니 무릇 그 주검을 만지는 자는 저녁까지 부정할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","이런 것 중 어떤 것의 주검이 목기에든지, 의복에든지, 가죽에든지, 부대에든지, 무론 무엇에 쓰는 그릇에든지 떨어지면 부정하여지리니 물에 담그라 저녁까지 부정하다가 정할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","그것 중 어떤 것이 어느 질그릇에 떨어지면 그 속에 있는 것이 다 부정하여지나니 너는 그 그릇을 깨뜨리라 ");
INSERT INTO kor_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","먹을 만한 축축한 식물이 거기 담겼으면 부정하여질 것이요, 그 같은 그릇의 마실 만한 마실 것도 부정할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","이런 것의 주검이 물건 위에 떨어지면 그것이 모두 부정하여지리니 화덕이든지, 질탕관이든지 깨뜨려 버리라 ! 이것이 부정하여져서 너희에게 부정한 것이 되리라 ");
INSERT INTO kor_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","샘물이나 방축물 웅덩이는 부정하여지지 아니하되 그 주검에 다닥치는 것만 부정하여 질 것이요 ");
INSERT INTO kor_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","이것들의 주검이 심을 종자에 떨어질지라도 그것이 정하거니와 ");
INSERT INTO kor_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","종자에 물을 더할 때에 그것이 그 위에 떨어지면 너희에게 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","너희의 먹을 만한 짐승이 죽은 때에 그 사체를 만지는 자는 저녁까지 부정할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","그것을 먹는 자는 그 옷을 빨 것이요 저녁까지 부정할 것이며 그 주검을 옮기는 자도 그 옷을 빨것이요 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","땅에 기어 다니는 모든 기는 것은 가증한즉 먹지 못할지니 ");
INSERT INTO kor_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","곧 땅에 기어다니는 모든 기는 것 중에 배로 밀어 다니는 것이나 네 발로 걷는 것이나 여러 발을 가진 것이라 너희가 먹지 말지니 이는 가증함이니라 ");
INSERT INTO kor_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","너희는 기는바 기어다니는 것을 인하여 자기로 가증하게 되게 말며 또한 그것을 인하여 스스로 더럽혀 부정하게 되게 말라 ");
INSERT INTO kor_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","나는 여호와 너희 하나님이라 ! 내가 거룩하니 너희도 몸을 구별하여 거룩하게 하고 땅에 기는바 기어다니는 것으로 인하여 스스로 더럽히지 말라 ");
INSERT INTO kor_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","나는 너희의 하나님이 되려고 너희를 애굽 땅에서 인도하여 낸 여호와라 내가 거룩하니 너희도 거룩할지어다 ! ");
INSERT INTO kor_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","이는 짐승과 새와 물에서 움직이는 모든 생물과 땅에 기는 모든 기어다니는 것에 대한 규례니 ");
INSERT INTO kor_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","부정하고 정한 것과 먹을 생물과 먹지 못할 생물을 분별한 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","이스라엘 자손에게 고하여 이르라 여인이 잉태하여 남자를 낳으면 그는 칠일 동안 부정하리니 곧 경도할 때와 같이 부정할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","제 팔일에는 그 아이의 양피를 벨 것이요 ");
INSERT INTO kor_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","그 여인은 오히려 삼십 삼일을 지나야 산혈이 깨끗하리니 정결케 되는 기한이 차기 전에는 성물을 만지지도 말며 성소에 들어가지도 말 것이며 ");
INSERT INTO kor_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","여자를 낳으면 그는 이 칠일 동안 부정하리니 경도할 때와 같을 것이며 산혈이 깨끗하게 됨은 육십 육일을 지나야 하리라 ");
INSERT INTO kor_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","자녀간 정결케 되는 기한이 차거든 그 여인은 번제를 위하여 일년된 어린 양을 취하고 속죄제를 위하여 집 비둘기 새끼나 산비둘기를 취하여 회막 문 제사장에게로 가져갈 것이요 ");
INSERT INTO kor_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","제사장은 그것을 여호와 앞에 드려서 여인을 위하여 속죄할지니 그리하면 산혈이 깨끗하리라 이는 자녀간 생산한 여인에게 대한 규례니라 ");
INSERT INTO kor_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","그 여인의 힘이 어린 양에 미치지 못하거든 산비둘기 둘이나 집비둘기 새끼 둘을 가져다가 하나는 번제물로,하나는 속죄 제물로 삼을 것이요 제사장은 그를 위하여 속할지니 그가 정결하리라 ");
INSERT INTO kor_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","여호와께서 모세와 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","사람의 피부에 무엇이 돋거나 딱지가 앉거나 색점이 생겨서 그 피부에 문둥병같이 되거든 곧 제사장 아론에게나 그 자손중 한 제사장에게로 데리고 갈 것이요 ");
INSERT INTO kor_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","제사장은 그 피부의 병을 진찰할지니 환처의 털이 희어졌고 환처가 피부보다 우묵하여졌으면 이는 문둥병의 환처라 제사장이 진단하여 그를 부정하다 할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","피부에 색점이 희나 우묵하지 아니하고 그 털이 희지 아니하면 제사장은 그 환자를 칠일동안 금고할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","칠일만에 제사장이 그를 진찰할지니 그의 보기에 그 환처가 변하지 아니하고 병색이 피부에 퍼지지 아니하였으면 제사장이 그를 또 칠일 동안을 금고할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","칠일만에 제사장이 또 진찰할지니 그 환처가 엷어졌고 병색이 피부에 퍼지지 아니하였으면 피부병이라 제사장이 그를 정하다 할 것이요 그는 옷을 빨 것이라 그리하면 정하리라 ");
INSERT INTO kor_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","그러나 정결한 여부를 위하여 제사장에게 보인 후에 병이 피부에 퍼지면 제사장에게 다시 보일 것이요 ");
INSERT INTO kor_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","제사장은 진찰할지니 그 병이 피부에 퍼졌으면 그를 부정하다 진단할 것이라 이는 문둥병임이니라 ");
INSERT INTO kor_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","사람에게 문둥병이 들었거든 그를 제사장에게로 데려갈 것이요 ");
INSERT INTO kor_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","제사장은 진찰할지니 피부에 흰 점이 돋고 털이 희어지고 거기 난육이 생겼으면 ");
INSERT INTO kor_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","이는 그의 피부의 오랜 문둥병이라 제사장이 부정하다 진단할 것이요 그가 이미 부정하였은즉 금고하지는 않을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","제사장의 보기에 문둥병이 그 피부에 크게 발하였으되 그 환자의 머리부터 발까지 퍼졌거든 ");
INSERT INTO kor_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","그가 진찰할 것이요 문둥병이 과연 그 전신에 퍼졌으면 그 환자를 정하다 할지니 다 희어진 자인즉 정하거니와 ");
INSERT INTO kor_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","아무 때든지 그에게 난육이 발생하면 그는 부정한즉 ");
INSERT INTO kor_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","제사장이 난육을 보고 그를 부정하다 진단할지니 그 난육은 부정한 것인즉 이는 문둥병이며 ");
INSERT INTO kor_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","그 난육이 변하여 다시 희어지면 제사장에게로 갈 것이요 ");
INSERT INTO kor_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","제사장은 그를 진찰하여서 그 환처가 희어졌으면 환자를 정하다 할지니 그는 정하니라 ");
INSERT INTO kor_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","피부에 종기가 생겼다가 나았고 ");
INSERT INTO kor_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","그 종처에 흰 점이 돋거나 희고 불그스름한 색점이 생겼으면 제사장에게 보일 것이요 ");
INSERT INTO kor_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","그는 진찰하여 피부보다 얕고 그 털이 희면 그를 부정하다 진단할지니 이는 종기로 된 문둥병의 환처임이니라 ");
INSERT INTO kor_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","그러나 제사장의 보기에 거기 흰 털이 없고 피부보다 얕지 아니하고 빛이 엷으면 제사장은 그를 칠일 동안 금고할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","그 병이 크게 피부에 퍼졌으면 제사장은 그를 부정하다 진단할지니 이는 그 환처임이니라 ");
INSERT INTO kor_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","그러나 그 색점이 여전하고 퍼지지 아니하였으면 이는 종기 흔적이니 제사장은 그를 정하다 진단할지니라 ");
INSERT INTO kor_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","피부를 불에 데었는데 그 덴 곳에 불그스름하고 희거나 순전히 흰 색점이 생기면 ");
INSERT INTO kor_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","제사장은 진찰할지니 그 색점의 털이 희고 그 자리가 피부보다 우묵하면 이는 화상에서 발한 문둥병인즉 제사장은 그를 부정하다 할 것은 문둥병의 환처가 됨이니라 ");
INSERT INTO kor_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","그러나 제사장의 보기에 그 색점에 흰 털이 없으며 그 자리가 피부보다 얕지 아니하고 빛이 엷으면 그는 그를 칠일동안 금고할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","칠일만에 제사장이 그를 진찰할지니 만일 병이 크게 피부에 퍼졌으면 그는 그를 부정하다 진단할 것은 문둥병의 환처임이니라 ");
INSERT INTO kor_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","만일 색점이 여전하여 피부에 퍼지지 아니하고 빛이 엷으면 화상으로 부은 것이니 제사장은 그를 정하다 할 것은 이는 화상의 흔적임이니라 ");
INSERT INTO kor_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","남자나 여자의 머리에나 수염에 환처가 있으면 ");
INSERT INTO kor_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","제사장은 진찰할지니 환처가 피부보다 우묵하고 그 자리에 누르고 가는 털이 있으면 그는 그를 부정하다 할 것은 이는 옴이라 머리에나 수염에 발한 문둥병임이니라 ");
INSERT INTO kor_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","만일 제사장의 보기에 그 옴의 환처가 피부보다 우묵하지 아니하고 그 자리에 검은 털이 없으면 제사장은 그 옴 환자를 칠일 동안 금고할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","칠일만에 제사장은 그 환처를 진찰할지니 그 옴이 퍼지지 아니하고 그 자리에 누른 털이 없고 피부보다 우묵하지 아니하거든 ");
INSERT INTO kor_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","그는 모발을 밀되 환처는 밀지 말 것이요 제사장은 옴 환자를 또 칠일 동안 금고할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","칠일만에 제사장은 그 옴을 또 진찰할지니 그 옴이 피부에 퍼지지 아니하고 피부보다 우묵하지 아니하면 그는 그를 정하다 진단할 것이요 그는 그 옷을 빨지니 정하려니와 ");
INSERT INTO kor_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","깨끗한 후에라도 옴이 크게 피부에 퍼지면 ");
INSERT INTO kor_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","제사장은 그를 진찰할지니 과연 옴이 피부에 퍼졌으면 누른 털을 찾을 것 없이 그는 부정하니라 ");
INSERT INTO kor_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","그러나 제사장의 보기에 옴이 여전하고 그 자리에 검은 털이 났으면 그 옴은 나았고 그 사람은 정하니 제사장은 그를 정하다 진단할지니라 ");
INSERT INTO kor_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","남자나 여자의 피부에 색점 곧 흰 색점이 있으면 ");
INSERT INTO kor_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","제사장은 진찰할지니 그 피부의 색점이 부유스름하면 이는 피부에 발한 어루러기라 그는 정하니라 ");
INSERT INTO kor_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","누구든지 그 머리털이 빠지면 그는 대머리니 정하고 ");
INSERT INTO kor_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","앞머리가 빠져도 그는 이마 대머리니 정하니라 ");
INSERT INTO kor_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","그러나 대머리나 이마 대머리에 희고 불그스름한 색점이 있으면 이는 문둥병이 대머리에나 이마 대머리에 발함이라 ");
INSERT INTO kor_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","제사장은 그를 진찰할지니 그 대머리에나 이마 대머리에 돋은 색점이 희고 불그스름하여 피부에 발한 문둥병과 같으면 ");
INSERT INTO kor_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","이는 문둥 환자라 부정하니 제사장은 그를 부정하다 확실히 진단할 것은 그 환처가 그 머리에 있음이니라 ");
INSERT INTO kor_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","문둥 환자는 옷을 찢고 머리를 풀며 윗 입술을 가리우고 외치기를 부정하다 부정하다 할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","병 있는 날 동안은 늘 부정할 것이라 그가 부정한즉 혼자 살되 진 밖에 살지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","만일 의복에 문둥병 색점이 발하여 털옷에나, 베옷에나 ");
INSERT INTO kor_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","베나, 털의 날에나, 씨에나, 혹 가죽에나, 무릇 가죽으로 만든 것에 있되 ");
INSERT INTO kor_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","그 의복에나, 가죽에나, 그 날에나, 씨에나, 무릇 가죽으로 만든 것에 병색이 푸르거나 붉으면 이는 문둥병의 색점이라 제사장에게 보일 것이요 ");
INSERT INTO kor_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","제사장은 그 색점을 살피고 그것을 칠일 동안 간직하였다가 ");
INSERT INTO kor_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","칠일만에 그 색점을 살필지니 그 색점이 그 의복의 날에나, 씨에나, 가죽에나, 가죽으로 만든 것에 퍼졌으면 이는 악성 문둥병이라 그것이 부정하니 ");
INSERT INTO kor_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","그는 그 색점 있는 의복이나, 털이나, 베의 날이나, 씨나, 무릇 가죽으로 만든 것을 불사를지니 이는 악성 문둥병인즉 그것을 불사를지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","그러나 제사장의 보기에 그 색점이 그 의복의 날에나, 씨에나, 무릇 가죽으로 만든 것에 퍼지지 아니하였으면 ");
INSERT INTO kor_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","제사장은 명하여 그 색점 있는 것을 빨게하고 또 칠일 동안 간직하였다가 ");
INSERT INTO kor_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","그 빤 곳을 볼지니 그 색점의 빛이 변치 아니하고 그 색점이 퍼지지 아니하였으면 부정하니 너는 그것을 불사르라 이는 거죽에 있든지, 속에 있든지, 악성 문둥병이니라 ");
INSERT INTO kor_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","빤 후에 제사장의 보기에 그 색점이 엷으면 그 의복에서나, 가죽에서나, 그 날에서나, 씨에서나, 그 색점을 찢어 버릴 것이요 ");
INSERT INTO kor_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","그 의복의 날에나 씨에나 무릇 가죽으로 만든 것에 색점이 여전히 보이면 복발하는 것이니 너는 그 색점있는 것을 불사를지니라 ");
INSERT INTO kor_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","네가 빤 의복의 날에나, 씨에나, 무릇 가죽으로 만든 것에 그 색점이 벗어졌으면 그것을 다시 빨아야 정하리라 ");
INSERT INTO kor_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","이는 털옷에나, 베옷에나, 그 날에나, 씨에나, 무릇 가죽으로 만든 것에 발한 문둥병 색점의 정하고 부정한 것을 단정하는 규례니라 ");
INSERT INTO kor_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","문둥 환자의 정결케 되는 날의 규례는 이러하니 곧 그 사람을 제사장에게로 데려갈 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","제사장은 진에서 나가서 진찰할지니 그 환자에게 있던 문둥병 환처가 나았으면 ");
INSERT INTO kor_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","제사장은 그를 위하여 명하여 정한 산 새 두마리와, 백향목과, 홍색실과, 우슬초를 가져오게 하고 ");
INSERT INTO kor_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","제사장은 또 명하여 그 새 하나는 흐르는 물 위 질그릇 안에서 잡게 하고 ");
INSERT INTO kor_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","다른 새는 산대로 취하여 백향목과, 홍색실과, 우슬초와 함께 가져다가 흐르는 물 위에서 잡은 새 피를 찍어 ");
INSERT INTO kor_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","문둥병에서 정결함을 받을 자에게 일곱번 뿌려 정하다 하고 그 산 새는 들에 놓을지며 ");
INSERT INTO kor_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","정결함을 받는 자는 그 옷을 빨고 모든 털을 밀고 물로 몸을 씻을 것이라 그리하면 정하리니 그 후에 진에 들어올 것이나 자기 장막 밖에 칠일을 거할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","칠일만에 그 모든 털을 밀되 머리털과 수염과 눈썹을 다 밀고 그 옷을 빨고 몸을 물에 씻을 것이라 그리하면 정하리라 ");
INSERT INTO kor_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","제 팔일에 그는 흠 없는 어린 수양 둘과 일년 된 흠 없는 어린 암양 하나와 또 고운 가루 에바 십분 삼에 기름 섞은 소제물과 기름 한 록을 취할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","정결케 하는 제사장은 정결함을 받을 자와 그 물건들을 회막 문 여호와 앞에 두고 ");
INSERT INTO kor_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","어린 수양 하나를 취하여 기름 한 록과 아울러 속건제로 드리되 여호와 앞에 흔들어 요제를 삼고 ");
INSERT INTO kor_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","그 어린 수양은 거룩한 장소 곧 속죄제와 번제 희생 잡는 곳에서 잡을 것이며 속건 제물은 속죄 제물과 일례로 제사장에게 돌릴지니 이는 지극히 거룩한 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","제사장은 그 속건제 희생의 피를 취하여 정결함을 받을 자의 우편 귓부리와, 우편 손 엄지가락과, 우편 발 엄지가락에 바를 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","제사장은 또 그 한 록의 기름을 취하여 자기 좌편 손바닥에 따르고 ");
INSERT INTO kor_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","우편 손가락으로 좌편 손의 기름을 찍어 그 손가락으로 그것을 여호와 앞에 일곱번 뿌릴 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","손에 남은 기름은 제사장이 정결함을 받는 자의 우편 귓부리와, 우편 손 엄지가락과, 우편 발 엄지가락 곧 속건제 희생의 피 위에 바를 것이며 ");
INSERT INTO kor_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","오히려 그 손에 남은 기름은 제사장이 그 정결함을 받는 자의 머리에 바르고 여호와 앞에서 제사장은 그를 위하여 속죄하고 ");
INSERT INTO kor_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","또 제사장은 속죄제를 드려 그 부정함을 인하여 정결함을 받으려는 자를 위하여 속죄하고 그 후에 번제 희생을 잡을 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","제사장은 그 번제와 소제를 단에 드려 그를 위하여 속죄할 것이라 그리하면 그가 정결하리라 ! ");
INSERT INTO kor_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","그가 가난하여 이에 힘이 미치지 못하면 그는 흔들어 자기를 속할 속건제를 위하여 어린 수양 하나와 소제를 위하여 고운 가루 에바 십분 일에 기름 섞은 것과 기름 한 록을 취하고 ");
INSERT INTO kor_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","그 힘이 미치는 대로 산비둘기 둘이나 집비둘기 새끼 둘을 취하되 하나는 속죄 제물로,하나는 번제물로 삼아 ");
INSERT INTO kor_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","제 팔일에 그 결례를 위하여 그것들을 회막 문 여호와 앞 제사장에게로 가져갈 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","제사장은 속건제 어린 양과 기름 한 록을 취하여 여호와 앞에 흔들어 요제를 삼고 ");
INSERT INTO kor_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","속건제의 어린 양을 잡아서 제사장은 그 속건제 희생의 피를 취하여 정결함을 받을 자의 우편 손 엄지 가락과, 우편 발 엄지가락에 바를 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","제사장은 그 기름을 자기 좌편 손바닥에 따르고 ");
INSERT INTO kor_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","우편 손가락으로 좌편 손의 기름을 조금 찍어 여호와 앞에 일곱번 뿌릴 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","그 손의 기름은 제사장이 정결함을 받을 자의 우편 귓부리와, 우편 손 엄지가락과, 우편 발 엄지가락 곧 속건제 희생의 피를 바른 곳에 바를 것이며 ");
INSERT INTO kor_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","또 그 손에 남은 기름은 제사장이 그 정결함을 받는 자의 머리에 발라 여호와 앞에서 그를 위하여 속죄할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","그는 힘이 미치는 대로 산비둘기 하나나 집비둘기 새끼 하나를 드리되 ");
INSERT INTO kor_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","곧 그 힘이 미치는 것의 하나는 속죄제로, 나는 소제와 함께 번제로 드릴 것이요, 제사장은 정결함을 받을 자를 위하여 여호와 앞에 속죄할지니 ");
INSERT INTO kor_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","문둥병 환자로서 그 결례에 힘이 부족한 자의 규례가 이러하니라 ");
INSERT INTO kor_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","여호와께서 모세와 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","내가 네게 기업으로 주는 가나안 땅에 너희가 이른 때에 내가 너희 기업의 땅에서 어느 집에 문둥병 색점을 발하게 하거든 ");
INSERT INTO kor_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","그 집 주인은 제사장에게 와서 고하기를 무슨 색점이 집에 생겼다 할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","제사장은 그 색점을 보러 가기 전에 그 가장 집물에 부정을 면케하기 위하여 명하여 그 집을 비게 한 후에 들어가서 그 집을 볼지니 ");
INSERT INTO kor_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","그 색점을 볼 때에 그 집 벽에 푸르거나 붉은 무늬의 색점이 있어 벽보다 우묵하면 ");
INSERT INTO kor_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","제사장은 그 집 문으로 나와 그 집을 칠일 동안 폐쇄하였다가 ");
INSERT INTO kor_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","칠일만에 또 와서 살펴볼 것이요 그 색점이 벽에 퍼졌으면 ");
INSERT INTO kor_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","그는 명하여 색점 있는 돌을 빼어 성 밖 부정한 곳에 버리게 하고 ");
INSERT INTO kor_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","또 집안 사면을 긁게 하고 그 긁은 흙을 성 밖 부정한 곳에 쏟아버리게 할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","그들은 다른 돌로 그 돌을 대신하며 다른 흙으로 집에 바를지니라 ");
INSERT INTO kor_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","돌을 빼며 집을 긁고 고쳐 바른 후에 색점이 집에 복발하거든 ");
INSERT INTO kor_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","제사장은 또 와서 살펴볼 것이요 그 색점이 만일 집에 퍼졌으면 악성 문둥병인즉 이는 부정하니 ");
INSERT INTO kor_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","그는 그 집을 헐고 돌과 그 재목과 그 집의 모든 흙을 성 밖 부정한 곳으로 내어갈 것이며 ");
INSERT INTO kor_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","그 집을 폐쇄한 날 동안에 들어가는 자는 저녁까지 부정할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","그 집에서 자는 자는 그 옷을 빨 것이요 그 집에서 먹는 자도 그 옷을 빨 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","그 집을 고쳐 바른 후에 제사장이 들어가 살펴 보아서 색점이 집에 퍼지지 아니하였으면 이는 색점이 나은 것이니 제사장은 그 집을 정하다 하고 ");
INSERT INTO kor_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","그는 그 집을 정결케 하기 위하여 새 두마리와, 백향목과, 홍색실과, 우슬초를 취하고 ");
INSERT INTO kor_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","그 새 하나를 흐르는 물 위 질그릇 안에서 잡고 ");
INSERT INTO kor_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","백향목과, 우슬초와, 홍색실과, 산새를 가져다가 잡은 새의 피와 흐르는 물을 찍어 그 집에 일곱번 뿌릴 것이요 ");
INSERT INTO kor_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","그는 새의 피와, 흐르는 물과, 산새와, 백향목과, 우슬초와, 홍색실로 집을 정결케 하고 ");
INSERT INTO kor_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","그 산새는 성 밖 들에 놓아 그 집을 위하여 속할 것이라 그리하면 정결하리라 ! ");
INSERT INTO kor_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","이는 각종 문둥병 환처에 대한 규례니 곧 옴과 ");
INSERT INTO kor_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","의복과 가옥의 문둥병과 ");
INSERT INTO kor_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","붓는 것과 피부병과 색점의 ");
INSERT INTO kor_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","언제는 부정하고 언제는 정함을 가르치는 것이니 문둥병의 규례가 이러하니라 ");
INSERT INTO kor_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","여호와께서 모세와 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","이스라엘 자손에게 고하여 이르라 누구든지 몸에 유출병이 있으면 그 유출병을 인하여 부정한 자라 ");
INSERT INTO kor_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","그 유출병으로 말미암아 부정함이 이러하니 곧 몸에서 흘러 나오든지 그것이 엉겼든지 부정한즉 ");
INSERT INTO kor_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","유출병 있는 자의 눕는 상은 다 부정하고 그의 앉았던 자리도 다 부정하니 ");
INSERT INTO kor_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","그 침상에 접촉하는 자는 옷을 빨고 물로 몸을 씻을 것이며 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","유출병 있는 자의 앉았던 자리에 앉는 자는 옷을 빨고 물로 몸을 씻을 것이며 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","유출병 있는 자의 몸에 접촉하는 자는 옷을 빨고 물로 몸을 씻을 것이며 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","유출병 있는 자가 정한 자에게 침을 뱉으면 정한 자는 옷을 빨고 물로 몸을 씻을 것이며 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","유출병 있는 자의 탔던 안장은 다 부정하며 ");
INSERT INTO kor_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","그 몸 아래 닿았던 것에 접촉한 자는 다 저녁까지 부정하며 그런 것을 옮기는 자는 옷을 빨고 물로 몸을 씻을 것이며 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","유출병 있는 자가 물로 손을 씻지 아니하고 아무든지 만지면 그 자는 옷을 빨고 물로 몸을 씻을 것이며 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","유출병 있는 자의 만진 질그릇은 깨뜨리고 목기는 다 물로 씻을지니라 ");
INSERT INTO kor_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","유출병 있는 자는 그 유출이 깨끗하여지거든 그 몸이 정결하기 위하여 칠일을 계산하여 옷을 빨고 흐르는 물에 몸을 씻을 것이요 그리하면 정하리니 ");
INSERT INTO kor_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","제 팔일에 산비둘기 둘이나 집비둘기 새끼 둘을 자기를 위하여 취하고 회막 문 여호와 앞으로 가서 제사장에게 줄 것이요 ");
INSERT INTO kor_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","제사장은 그 하나는 속죄제로, 하나는 번제로 드려 그의 유출병을 인하여 여호와 앞에 속죄할지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","설정한 자는 전신을 물로 씻을 것이며 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","무릇 정수가 묻은 옷이나 가죽은 물에 빨 것이며 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","남녀가 동침하여 설정하였거든 둘 다 물로 몸을 씻을 것이며 저까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","어떤 여인이 유출을 하되 그 유출이 피면 칠일 동안 불결하니 무릇 그를 만지는 자는 저녁까지 부정할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","그 불결할 동안에 그의 누웠던 자리는 다 부정하며 그의 앉았던 자리도 다 부정한즉 ");
INSERT INTO kor_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","그 침상을 만지는 자는 다 옷을 빨고 물로 몸을 씻을 것이요 저녁까지 부정할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","그 좌석을 만지는 자도 다 옷을 빨고 물로 몸을 씻을 것이요 저녁까지 부정할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","그의 침상과 무릇 그 좌석에 있는 것을 만지는 자도 저녁까지 부정할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","누구든지 이 여인과 동침하여 그 불결에 전염되면 칠일 동안 부정할 것이라 그의 눕는 상은 무릇 부정하니라 ");
INSERT INTO kor_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","여인의 피의 유출이 그 불결기 외에 있어서 여러 날이 간다든지 그 유출이 불결기를 지나든지 하면 그 부정을 유출하는 날 동안은 무릇 그 불결한 때와 같이 부정한즉 ");
INSERT INTO kor_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","무릇 그 유출이 있는 날 동안에 그의 눕는 침상은 그에게 불결한 때의 침상과 같고 무릇 그의 앉는 자리도 부정함이 불결의 부정 과 같으니 ");
INSERT INTO kor_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","이런 것을 만지는 자는 무릇 부정한즉 옷을 빨고 물로 몸을 씻을 것이며 저녁까지 부정할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","그의 유출이 그치면 칠일을 센 후에야 정하리니 ");
INSERT INTO kor_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","그는 제 팔일에 산비둘기 둘이나 집비둘기 새끼 둘을 자기를 위하여 취하여 회막 문 앞 제사장에게로 가져올 것이요 ");
INSERT INTO kor_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","제사장은 그 하나는 속죄제로, 하나는 번제로 드려 유출로 부정한 여인을 위하여 여호와 앞에 속할지니라 ");
INSERT INTO kor_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","너희는 이와 같이 이스라엘 자손으로 그 부정에서 떠나게하여 그들로 그 가운데 있는 내 장막을 더럽히고 그 부정한 중에서 죽음을 면케 할찌니라 ");
INSERT INTO kor_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","이 규례는 유출병이 있는 자와 설정함으로 부정을 입은 자와 ");
INSERT INTO kor_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","불결을 앓는 여인과 유출병이 있는 남녀와 불결한 여인과 동침한 자에게 관한 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","아론의 두 아들이 여호와 앞에 나아가다가 죽은 후에 여호와께서 모세에게 말씀하시니라 ");
INSERT INTO kor_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","여호와께서 모세에게 이르시되 네 형 아론에게 이르라 성소의 장안 법궤 위 속죄소 앞에 무시로 들어오지 말아서 사망을 면하라 내가 구름 가운데서 속죄소 위에 나타남이니라 ");
INSERT INTO kor_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","아론이 성소에 들어오려면 수송아지로 속죄 제물을 삼고 수양으로 번제물을 삼고 ");
INSERT INTO kor_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","거룩한 세마포 속옷을 입으며 세마포 고의를 살에 입고 세마포 띠를 띠며 세마포 관을 쓸지니 이것들은 거룩한 옷이라 물로 몸을 씻고 입을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","이스라엘 자손의 회중에게서 속죄 제물을 위하여 수염소 둘과 번제물을 위하여 수양 하나를 취할지니라 ");
INSERT INTO kor_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","아론은 자기를 위한 속죄제의 수송아지를 드리되 자기와 권속을 위하여 속죄하고 ");
INSERT INTO kor_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","또 그 두 염소를 취하여 회막 문 여호와 앞에 두고 ");
INSERT INTO kor_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","두 염소를 위하여 제비 뽑되 한 제비는 여호와를 위하고, 한 제비는 아사셀을 위하여 할지며 ");
INSERT INTO kor_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","아론은 여호와를 위하여 제비 뽑은 염소를 속죄제로 드리고 ");
INSERT INTO kor_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","아사셀을 위하여 제비 뽑은 염소는 산 대로 여호와 앞에 두었다가 그것으로 속죄하고 아사셀을 위하여 광야로 보낼지니라 ");
INSERT INTO kor_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","아론은 자기를 위한 속죄제의 수송아지를 드리되 자기와 권속을 위하여 속죄하고 자기를 위한 그 속죄제 수송아지를 잡고 ");
INSERT INTO kor_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","향로를 취하여 여호와 앞 단 위에서 피운 불을 그것에 채우고 또 두손에 곱게 간 향기로운 향을 채워 가지고 장 안에 들어가서 ");
INSERT INTO kor_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","여호와 앞에서 분향하여 향연으로 증거궤 위 속죄소를 가리우게 할지니 그리하면 그가 죽음을 면할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","그는 또 수송아지의 피를 취하여 손가락으로 속죄소 동편에 뿌리고 또 손가락으로 그 피를 속죄소 앞에 일곱번 뿌릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","또 백성을 위한 속죄제 염소를 잡아 그 피를 가지고 장 안에 들어가서 그 수송아지 피로 행함 같이 그 피로 행하여 속죄소 위와 속죄소 앞에 뿌릴지니 ");
INSERT INTO kor_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","곧 이스라엘 자손의 부정과 그 범한 모든 죄를 인하여 지성소를 위하여 속죄하고 또 그들의 부정한 중에 있는 회막을 위하여 그같이 할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","그가 지성소에 속죄하러 들어가서 자기와 그 권속과 이스라엘 온회중을 위하여 속죄하고 나오기까지는 누구든지 회막에 있지 못할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","그는 여호와 앞 단으로 나와서 그것을 위하여 속죄할지니 곧 그 수송아지의 피와 염소의 피를 취하여 단 귀퉁이 뿔들에 바르고 ");
INSERT INTO kor_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","또 손가락으로 그 피를 그 위에 일곱번 뿌려 이스라엘 자손의 부정에서 단을 성결케 할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","그 지성소와 회막과 단을 위하여 속죄하기를 마친 후에 산 염소를 드리되 ");
INSERT INTO kor_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","아론은 두 손으로 산 염소의 머리에 안수하여 이스라엘 자손의 모든 불의와 그 범한 모든 죄를 고하고 그 죄를 염소의 머리에 두어 미리 정한 사람에게 맡겨 광야로 보낼지니 ");
INSERT INTO kor_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","염소가 그들의 모든 불의를 지고 무인지경에 이르거든 그는 그 염소를 광야에 놓을지니라 ");
INSERT INTO kor_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","아론은 회막에 들어가서 지성소에 들어갈 때에 입었던 세마포 옷을 벗어 거기 두고 ");
INSERT INTO kor_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","거룩한 곳에서 물로 몸을 씻고 자기 옷을 입고 나와서 자기의 번제와 백성의 번제를 드려 자기와 백성을 위하여 속죄하고 ");
INSERT INTO kor_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","속죄제 희생의 기름을 단에 불사를 것이요 ");
INSERT INTO kor_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","염소를 아사셀에게 보낸 자는 옷을 빨고 물로 몸을 씻은 후에 진에 들어올 것이며 ");
INSERT INTO kor_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","속죄제 수송아지와 속죄제 염소의 피를 성소로 들여다가 속죄하였은즉 그 가죽과 고기와 똥을 밖으로 내어다가 불사를 것이요 ");
INSERT INTO kor_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","불사른 자는 옷을 빨고 물로 몸을 씻은 후에 진에 들어올지니라 ");
INSERT INTO kor_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","너희는 영원히 이 규례를 지킬지니라 ! 칠월 곧 그 달 십일에 너희는 스스로 괴롭게 하고 아무 일도 하지 말되 본토인이든지 너희 중에 우거하는 객이든지 그리하라 ");
INSERT INTO kor_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","이 날에 너희를 위하여 속죄하여 너희로 정결케 하리니 너희 모든 죄에서 너희가 여호와 앞에 정결하리라 ");
INSERT INTO kor_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","이는 너희에게 큰 안식일인즉 너희는 스스로 괴롭게 할지니 영원히 지킬 규례라 ");
INSERT INTO kor_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","그 기름 부음을 받고 위임되어 그 아비를 대신하여 제사장의 직분을 행하는 제사장은 속죄하되 세마포 옷 곧 성의를 입고 ");
INSERT INTO kor_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","지성소를 위하여 속죄하며 회막과 단을 위하여 속죄하고 또 제사장들과 백성의 회중을 위하여 속죄할지니 ");
INSERT INTO kor_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","이는 너희의 영원히 지킬 규례라 이스라엘 자손의 모든 죄를 위하여 일년 일차 속죄할 것이니라 아론이 여호와께서 모세에게 명하신 대로 행하니라 ");
INSERT INTO kor_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","아론과 그 아들들과 이스라엘 모든 자손에게 고하여 그들에게 이르기를 여호와의 명령이 이러하시다 하라 ");
INSERT INTO kor_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","무릇 이스라엘 집의 누구든지 소나 어린 양이나 염소를 진 안에서 잡든지 진 밖에서 잡든지 ");
INSERT INTO kor_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","먼저 회막문으로 끌어다가 여호와의 장막 앞에서 여호와께 예물로 드리지 아니하는 자는 피흘린 자로 여길 것이라 그가 피를 흘렸은즉 자기 백성 중에서 끊쳐지리라 ! ");
INSERT INTO kor_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","그런즉 이스라엘 자손이 들에서 잡던 희생을 회막 문 여호와께로 끌어다가 제사장에게 주어 화목제로 여호와께 드려야 할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","제사장은 그 피를 회막 문 여호와의 단에 뿌리고 그 기름을 불살라 여호와께 향기로운 냄새가 되게 할 것이라 ");
INSERT INTO kor_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","그들은 전에 음란히 섬기던 수염소에게 다시 제사하지 말 것이니라 이는 그들이 대대로 지킬 영원한 규례니라 ! ");
INSERT INTO kor_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","너는 또 그들에게 이르라 무릇 이스라엘 집 사람이나 혹시 그들중에 우거하는 타국인이 번제나 희생을 드리되 ");
INSERT INTO kor_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","회막 문으로 가져다가 여호와께 드리지 아니하면 그는 백성 중에서 끊쳐지리라 ! ");
INSERT INTO kor_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","무릇 이스라엘 집 사람이나 그들 중에 우거하는 타국인 중에 어떤 피든지 먹는 자가 있으면 내가 그 피 먹는 사람에게 진노하여 그를 백성중에서 끊으리니 ");
INSERT INTO kor_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","육체의 생명은 피에 있음이라 내가 이 피를 너희에게 주어 단에 뿌려 너희의 생명을 위하여 속하게 하였나니 생명이 피에 있으므로 피가 죄를 속하느니라 ");
INSERT INTO kor_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","그러므로 내가 이스라엘 자손에게 말하기를 너희 중에 아무도 피를 먹지 말며 너희 중에 우거하는 타국인이라도 피를 먹지 말라 하였나니 ");
INSERT INTO kor_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","무릇 이스라엘 자손이나 그들 중에 우거하는 타국인이 먹을 만한 짐승이나 새를 사냥하여 잡거든 그 피를 흘리고 흙으로 덮을지니라 ");
INSERT INTO kor_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","모든 생물은 그 피가 생명과 일체라 그러므로 내가 이스라엘 자손에게 이르기를 너희는 어느 육체의 피든지 먹지 말라 하였나니 모든 육체의 생명은 그 피인즉 무릇 피를 먹는 자는 끊쳐지리라 ! ");
INSERT INTO kor_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","무릇 스스로 죽은 것이나 들짐승에게 찢겨 죽은 것을 먹은 자는 본토인이나 타국인이나 물론하고 그 옷을 빨고 물로 몸을 씻을 것이며 저녁까지 부정하고 그 후에 정하려니와 ");
INSERT INTO kor_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","그가 빨지 아니하거나 몸을 물로 씻지 아니하면 죄를 당하리라 ");
INSERT INTO kor_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","너는 이스라엘 자손에게 고하여 이르라 나는 여호와 너희 하나님이라 ! ");
INSERT INTO kor_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","너희는 그 거하던 애굽 땅의 풍속을 좇지 말며 내가 너희를 인도할 가나안 땅의 풍속과 규례도 행하지 말고 ");
INSERT INTO kor_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","너희는 나의 법도를 좇으며 나의 규례를 지켜 그대로 행하라 ! 나는 너희의 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","너희는 나의 규례와 법도를 지키라 ! 사람이 이를 행하면 그로 인하여 살리라 ! 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","너희는 골육지친을 가까이하여 그 하체를 범치 말라 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","네 어미의 하체는 곧 네 아비의 하체니 너는 범치 말라 그는 네 어미인즉 너는 그의 하체를 너는 범치 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","너는 계모의 하체를 범치 말라 이는 네 아비의 하체니라 ");
INSERT INTO kor_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","너는 네 자매 곧 네 아비의 딸이나 네 어미의 딸이나 집에서나 타처에서 출생하였음을 물론하고 그들의 하체를 범치 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","너는 손녀나 외손녀의 하체를 범치 말라 이는 너의 하체니라 ");
INSERT INTO kor_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","네 계모가 네 아비에게 낳은 딸은 네 누이니 너는 그 하체를 범치 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","너는 고모의 하체를 범치 말라 그는 네 아비의 골육지친이니라 ");
INSERT INTO kor_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","너는 이모의 하체를 범치 말라 그는 네 어미의 골육지친이니라 ");
INSERT INTO kor_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","너는 네 아비 형제의 아내를 가까이하여 그 하체를 범치 말라 그는 네 백숙모니라 ");
INSERT INTO kor_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","너는 자부의 하체를 범치 말라 그는 네 아들의 아내니 그 하체를 범치 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","너는 형제의 아내의 하체를 범치 말라 이는 네 형제의 하체니라 ");
INSERT INTO kor_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","너는 여인과 그 여인의 딸의 하체를 아울러 범치 말며 또 그 여인의 손녀나 외손녀를 아울러 취하여 그 하체를 범치 말라 그들은 그의 골육지친이니 이는 악행이니라 ");
INSERT INTO kor_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","너는 아내가 생존할 동안에 그 형제를 취하여 하체를 범하여 그로 투기케 하지 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","너는 여인이 경도로 불결할 동안에 그에게 가까이하여 그 하체를 범치 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","너는 타인의 아내와 통간하여 그로 자기를 더럽히지 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","너는 결단코 자녀를 몰렉에게 주어 불로 통과케 말아서 네 하나님의 이름을 욕되게 하지 말라 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","너는 여자와 교합함 같이 남자와 교합하지 말라 이는 가증한 일이니라 ");
INSERT INTO kor_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","너는 짐승과 교합하여 자기를 더럽히지 말며 여자가 된 자는 짐승 앞에 서서 그것과 교접하지 말라 이는 문란한 일이니라 ");
INSERT INTO kor_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","너희는 이 모든 일로 스스로 더럽히지 말라 내가 너희의 앞에서 쫓아내는 족속들이 이 모든 일로 인하여 더러워졌고 ");
INSERT INTO kor_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","그 땅도 더러워졌으므로 내가 그 악을 인하여 벌하고 그 땅도 스스로 그 거민을 토하여 내느니라 ");
INSERT INTO kor_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","그러므로 너희 곧 너희의 동족이나 혹시 너희 중에 우거하는 타국인이나 나의 규례와 법도를 지키고 이런 가증한 일의 하나도 행하지 말라 ");
INSERT INTO kor_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","너희의 전에 있던 그 땅 거민이 이 모든 가증한 일을 행하였고 그 땅도 더러워졌느니라 ");
INSERT INTO kor_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","너희도 더럽히면 그 땅이 너희 있기 전 거민을 토함같이 너희를 토할까 하노라 ");
INSERT INTO kor_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","무릇 이 가증한 일을 하나라도 행하는 자는 그 백성 중에서 끊쳐지리라 ! ");
INSERT INTO kor_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","그러므로 너희는 내 명령을 지키고 너희 있기 전에 행하던 가증한 풍속을 하나라도 좇음으로 스스로 더럽히지 말라 ! 나는 너희 하나님 여호와니라 ");
INSERT INTO kor_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","너는 이스라엘 자손의 온 회중에게 고하여 이르라 너희는 거룩하라 ! 나 여호와 너희 하나님이 거룩함이니라 ");
INSERT INTO kor_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","너희 각 사람은 부모를 경외하고 나의 안식일을 지키라 ! 나는 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","너희는 헛것을 위하지 말며 너희를 위하여 신상들을 부어 만들지 말라 ! 나는 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","너희는 화목제 희생을 여호와께 드릴 때에 열납되도록 드리고 ");
INSERT INTO kor_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","그 제물은 드리는 날과 이튿날에 먹고 제 삼일까지 남았거든 불사르라 ");
INSERT INTO kor_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","제 삼일에 조금이라도 먹으면 가증한 것이 되어 열납되지 못하고 ");
INSERT INTO kor_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","그것을 먹는 자는 여호와의 성물 더럽힘을 인하여 죄를 당하리니 그가 그 백성 중에서 끊쳐지리라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","너희 땅의 곡물을 벨 때에 너는 밭 모퉁이까지 다 거두지 말고 너의 떨어진 이삭도 줍지 말며 ");
INSERT INTO kor_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","너의 포도원의 열매를 다 따지 말며 너의 포도원에 떨어진 열매도 줍지 말고 가난한 사람과 타국인을 위하여 버려 두라 나는 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","너희는 도적질하지 말며 속이지 말며 서로 거짓말하지 말며 ");
INSERT INTO kor_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","너희는 내 이름으로 거짓 맹세함으로 네 하나님의 이름을 욕되게 하지 말라 ! 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","너는 네 이웃을 압제하지 말며 늑탈하지 말며 품군의 삯을 아침까지 밤새도록 네게 두지 말며 ");
INSERT INTO kor_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","너는 귀먹은 자를 저주하지 말며 소경 앞에 장애물을 놓지 말고 네 하나님을 경외하라 ! 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","너희는 재판할 때에 불의를 행치 말며 가난한 자의 편을 들지 말며 세력있는 자라고 두호하지 말고 공의로 사람을 재판할지며 ");
INSERT INTO kor_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","너는 네 백성 중으로 돌아다니며 사람을 논단하지 말며 네 이웃을 대적하여 죽을 지경에 이르게 하지 말라 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","너는 네 형제를 마음으로 미워하지 말며 이웃을 인하여 죄를 당치 않도록 그를 반드시 책선하라 ");
INSERT INTO kor_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","원수를 갚지 말며 동포를 원망하지 말며 이웃 사랑하기를 네 몸과 같이 하라 ! 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","너희는 내 규례를 지킬지어다 ! 네 육축을 다른 종류와 교합시키지 말며 네 밭에 두 종자를 섞어 뿌리지 말며 두 재료로 직조한 옷을 입지 말지며 ");
INSERT INTO kor_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","무릇 아직 속량도 되지 못하고 해방도 되지 못하고 정혼한 씨종과 사람이 행음하면 두 사람이 형벌은 받으려니와 그들이 죽임을 당치 아니할 것은 그 여인은 아직 해방되지 못하였음이라 ");
INSERT INTO kor_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","그 남자는 그 속건 제물 곧 속건제 수양을 회막 문 여호와께로 끌어올 것이요 ");
INSERT INTO kor_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","제사장은 그의 범한 죄를 위하여 그 속건제의 수양으로 여호와 앞에 속죄할 것이요 그리하면 그의 범한 죄의 사함을 받으리라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","너희가 그 땅에 들어가 각종 과목을 심거든 그 열매는 아직 할례받지 못한 것으로 여기되 곧 삼년 동안 너희는 그것을 할례 받지 못한 것으로 아껴 먹지 말 것이요 ");
INSERT INTO kor_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","제 사년에는 그 모든 과실이 거룩하니 여호와께 드려 찬송할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","제 오년에는 그 열매를 먹을지니 그리하면 너희에게 그 소산이 풍성하리라 나는 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","너희는 무엇이든지 피 채 먹지 말며 복술을 하지 말며 술수를 행치 말며 ");
INSERT INTO kor_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","머리 가를 둥글게 깎지 말며 수염 끝을 손상치 말며 ");
INSERT INTO kor_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","죽은 자를 위하여 너희는 살을 베지 말며 몸에 무늬를 놓지 말라 ! 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","네 딸을 더럽혀 기생이 되게 말라 ! 음풍이 전국에 퍼져 죄악이 가득할까 하노라 ");
INSERT INTO kor_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","내 안식일을 지키고 내 성소를 공경하라 ! 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","너희는 신접한 자와 박수를 믿지 말며 그들을 추종하여 스스로 더럽히지 말라 ! 나는 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","너는 센 머리 앞에 일어서고 노인의 얼굴을 공경하며 네 하나님을 경외하라 ! 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","타국인이 너희 땅에 우거하여 함께 있거든 너희는 그를 학대하지 말고 ");
INSERT INTO kor_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","너희와 함께 있는 타국인을 너희 중에서 낳은 자 같이 여기며 자기같이 사랑하라 ! 너희도 애굽 땅에서 객이 되었더니라 나는 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","너희는 재판에든지 도량형에든지 불의를 행치 말고 ");
INSERT INTO kor_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","공평한 저울과, 공평한 추와, 공평한 에바와, 공평한 힌을 사용하라 ! 나는 너희를 인도하여 애굽 땅에서 나오게 한 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","너희는 나의 모든 규례와 나의 모든 법도를 지켜 행하라 ! 나는 여호와니라 ");
INSERT INTO kor_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","너는 이스라엘 자손에게 또 이르라 무릇 그가 이스라엘 자손이든지 이스라엘에 우거한 타국인이든지 그 자식을 몰렉에게 주거든 반드시 죽이되 그 지방 사람이 돌로 칠 것이요 ");
INSERT INTO kor_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","나도 그 사람에게 진노하여 그를 그 백성 중에서 끊으리니 이는 그가 그 자식을 몰렉에게 주어서 내 성소를 더럽히고 내 성호를 욕되게 하였음이라 ");
INSERT INTO kor_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","그가 그 자식을 몰렉에게 주는 것을 그 지방 사람이 못본체하고 그를 죽이지 아니하면 ");
INSERT INTO kor_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","내가 그 사람과 그 권속에게 진노하여 그와 무릇 그를 본받아 몰렉을 음란히 섬기는 모든 사람을 그 백성 중에서 끊으리라 ! ");
INSERT INTO kor_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","음란하듯 신접한 자와 박수를 추종하는 자에게는 내가 진노하여 그를 그 백성 중에서 끊으리니 ");
INSERT INTO kor_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","너희는 스스로 깨끗케 하여 거룩할지어다 ! 나는 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","너희는 내 규례를 지켜 행하라 ! 나는 너희를 거룩케 하는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","무릇 그 아비나 어미를 저주하는 자는 반드시 죽일지니 그가 그 아비나 어미를 저주하였은즉 그 피가 자기에게로 돌아가리라 ");
INSERT INTO kor_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","누구든지 남의 아내와 간음하는 자 곧 그 이웃의 아내와 간음하는 자는 그 간부와 음부를 반드시 죽일지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","누구든지 그 계모와 동침하는 자는 그 아비의 하체를 범하였은즉 둘다 반드시 죽일지니 그 피가 자기에게로 돌아가리라 ");
INSERT INTO kor_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","누구든지 그 자부와 동침하거든 둘 다 반드시 죽일지니 그들이 가증한 일을 행하였음이라 그 피가 자기에게로 돌아가리라 ");
INSERT INTO kor_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","누구든지 여인과 교합하듯 남자와 교합하면 둘 다 가증한 일을 행함인즉 반드시 죽일지니 그 피가 자기에게로 돌아가리라 ");
INSERT INTO kor_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","누구든지 아내와 그 장모를 아울러 취하면 악행인즉 그와 그들을 함께 불사를지니 이는 너희중에 악행이 없게 하려 함이니라 ");
INSERT INTO kor_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","남자가 짐승과 교합하면 반드시 죽이고 너희는 그 짐승도 죽일 것이며 ");
INSERT INTO kor_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","여자가 짐승에게 가까이하여 교합하거든 너는 여자와 짐승을 죽이되 이들을 반드시 죽일지니 그 피가 자기에게로 돌아가리라 ");
INSERT INTO kor_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","누구든지 그 자매 곧 아비의 딸이나 어미의 딸을 취하여 그 여자의 하체를 보고 여자는 그 남자의 하체를 보면 부끄러운 일이라 그 민족 앞에서 그들이 끊어질지니 그가 그 자매의 하체를 범하였은즉 그 죄를 당하리라 ");
INSERT INTO kor_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","누구든지 경도하는 여인과 동침하여 그의 하체를 범하면 남자는 그 여인의 근원을 드러내었고 여인은 자기의 피 근원을 드러내었음인즉 둘 다 백성 중에서 끊어지리라 ");
INSERT INTO kor_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","너의 이모나 고모의 하체를 범하지 말지니 이는 골육지친의 하체인즉 그들이 그 죄를 당하리라 ");
INSERT INTO kor_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","누구든지 백숙모와 동침하면 그 백숙부의 하체를 범함이니 그들이 그 죄를 당하여 무자히 죽으리라 ");
INSERT INTO kor_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","누구든지 그 형제의 아내를 취하면 더러운 일이라 그가 그 형제의 하체를 범함이니 그들이 무자하리라 ");
INSERT INTO kor_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","너희는 나의 모든 규례와 법도를 지켜 행하라 ! 그리하여야 내가 너희를 인도하여 거하게 하는 땅이 너희를 토하지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","너희는 내가 너희 앞에서 쫓아내는 족속의 풍속을 좇지 말라 ! 그들이 이 모든 일을 행하므로 내가 그들을 가증히 여기노라 ");
INSERT INTO kor_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","내가 전에 너희에게 이르기를 너희가 그들의 땅을 기업으로 얻을 것이라 내가 그 땅 곧 젖과 꿀이 흐르는 땅으로 너희에게 주어 유업을 삼게 하리라 하였노라 나는 너희를 만민 중에서 구별한 너희 하나님 여호와라 ! ");
INSERT INTO kor_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","너희는 짐승의 정하고 부정함과 새의 정하고 부정함을 구별하고 내가 너희를 위하여 부정한 것으로 구별한 짐승이나 새나 땅에 기는 곤충으로 인하여 너희 몸을 더럽히지 말라 ! ");
INSERT INTO kor_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","너희는 내게 거룩할지어다 ! 이는 나 여호와가 거룩하고 내가 또 너희로 나의 소유를 삼으려고 너희를 만민 중에서 구별하였음이니라 ");
INSERT INTO kor_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","남자나 여자가 신접하거나 박수가 되거든 반드시 죽일지니 곧 돌로 그를 치라 그 피가 자기에게로 돌아가리라 ");
INSERT INTO kor_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","여호와께서 모세에게 이르시되 아론의 자손 제사장들에게 고하여 이르라 백성 중의 죽은 자로 인하여 스스로 더럽히지 말려니와 ");
INSERT INTO kor_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","골육지친인 부모나 자녀나 형제나 ");
INSERT INTO kor_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","출가하지 아니한 처녀인 친 자매로 인하여는 몸을 더럽힐 수 있느니라 ");
INSERT INTO kor_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","제사장은 백성의 어른인즉 스스로 더럽혀 욕되게 하지 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","제사장은 머리털을 깎아 대머리 같게 하지 말며 그 수염 양편을 깎지 말며 살을 베지 말고 ");
INSERT INTO kor_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","그 하나님께 대하여 거룩하고 그 하나님의 이름을 욕되게 하지 말 것이며 그들은 여호와의 화제 곧 그 하나님의 식물을 드리는 자인즉 거룩할 것이라 ");
INSERT INTO kor_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","그들은 기생이나 부정한 여인을 취하지 말 것이며 이혼 당한 여인을 취하지 말지니 이는 그가 여호와께 거룩함이니라 ");
INSERT INTO kor_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","너는 그를 거룩하게 하라 ! 그는 네 하나님의 식물을 드림이니라 너는 그를 거룩히 여기라 ! 나 여호와 너희를 거룩하게 하는 자는 거룩함이니라 ");
INSERT INTO kor_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","아무 제사장의 딸이든지 행음하여 스스로 더럽히면 그 아비를 욕되게 함이니 그를 불사를지니라 ");
INSERT INTO kor_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","자기 형제 중 관유로 부음을 받고 위임되어 예복을 입은 대제사장은 그 머리를 풀지 말며 그 옷을 찢지 말며 ");
INSERT INTO kor_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","어떤 시체에든지 가까이 말지니 부모로 인하여도 더러워지게 말며 ");
INSERT INTO kor_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","성소에서 나오지 말며 그 하나님의 성소를 더럽히지 말라 ! 이는 하나님의 위임한 관유가 그 위에 있음이니라 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","그는 처녀를 취하여 아내를 삼을지니 ");
INSERT INTO kor_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","과부나 이혼된 여인이나 더러운 여인이나 기생을 취하지 말고 자기 백성 중 처녀를 취하여 아내를 삼아 ");
INSERT INTO kor_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","그 자손으로 백성 중에서 더럽히지 말지니 나는 그를 거룩하게 하는 여호와임이니라 ");
INSERT INTO kor_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","아론에게 고하여 이르라 무릇 너의 대대 자손 중 육체에 흠이 있는 자는 그 하나님의 식물을 드리려고 가까이 오지 못할 것이라 ");
INSERT INTO kor_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","무릇 흠이 있는 자는 가까이 못할지니 곧 소경이나, 절뚝발이나, 코가 불완전한 자나, 지체가 더한 자나, ");
INSERT INTO kor_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","발 부러진 자나, 손 부러진 자나, ");
INSERT INTO kor_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","곱사등이나, 난장이나, 눈에 백막이 있는 자나, 괴혈병이나, 버짐이 있는 자나, 불알 상한 자나, ");
INSERT INTO kor_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","제사장 아론의 자손 중에 흠이 있는 자는 나아와 여호와의 화제를 드리지 못할지니 그는 흠이 있은즉 나아와 하나님의 식물을 드리지 못하느니라 ");
INSERT INTO kor_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","그는 하나님의 식물의 지성물이든지 성물이든지 먹을 것이나 ");
INSERT INTO kor_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","장 안에 들어가지 못할 것이요 단에 가까이 못할지니 이는 그가 흠이 있음이라 이와 같이 그가 나의 성소를 더럽히지 못할 것은 나는 그들을 거룩하게 하는 여호와임이니라 ! ");
INSERT INTO kor_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","모세가 이대로 아론과 그 아들들과 온 이스라엘 자손에게 고하였더라 ");
INSERT INTO kor_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","아론과 그 아들들에게 고하여 그들로 이스라엘 자손이 내게 드리는 성물에 대하여 스스로 구별하여 내 성호를 욕되게 함이 없게 하라 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","그들에게 이르라 무릇 너의 대대 자손 중에 그 몸이 부정하고도 이스라엘 자손이 구별하여 여호와께 드리는 성물에 가까이하는 자는 내 앞에서 끊어지리라 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","아론의 자손 중 문둥 환자나 유출병이 있는 자는 정하기 전에는 성물을 먹지말 것이요 시체로 부정하게 된 자나 설정한 자나 ");
INSERT INTO kor_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","무릇 사람을 부정하게 하는 벌레에 접촉된 자나 무슨 부정이든지 사람을 더럽힐 만한 자에게 접촉된 자 ");
INSERT INTO kor_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","곧 이런 것에 접촉된 자는 저녁까지 부정하니 몸을 물로 씻지 아니하면 성물을 먹지 못할지며 ");
INSERT INTO kor_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","해 질 때에야 정하리니 그 후에 성물을 먹을 것이라 이는 자기의 응식이 됨이니라 ");
INSERT INTO kor_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","절로 죽은 것이나 들짐승에게 찢긴 것을 먹음으로 자기를 더럽히지 말라 ! 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","그들은 나의 명을 지킬 것이라 그것을 욕되게 하면 그로 인하여 죄를 짓고 그 가운데서 죽을까 하노라 나는 그들을 거룩하게 하는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","외국인은 성물을 먹지 못할 것이며 제사장의 객이나 품군은 다 성물을 먹지 못할 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","그러나 제사장이 돈으로 사람을 샀으면 그 자는 그것을 먹을 것이고 그 집에서 출생한 자도 그러하여 그들이 제사장의 식물을 먹을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","제사장의 딸은 외국인에게 출가하였으면 거제의 성물을 먹지 못하되 ");
INSERT INTO kor_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","그가 과부가 되든지 이혼을 당하든지 자식이 없이 친정에 돌아와서 어릴 때와 같으면 그는 그 아비의 응식을 먹을 것이나 외국인은 먹지 못할 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","사람이 부지중 성물을 먹으면 그 성물에 그 오분 일을 더하여 제사장에게 줄지니라 ");
INSERT INTO kor_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","이스라엘 자손이 여호와께 드리는 성물을 그들은 더럽히지 말지니 ");
INSERT INTO kor_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","그들이 성물을 먹으면 그 죄로 인하여 형벌을 받게 할 것이니라 나는 그들을 거룩하게 하는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","아론과 그 아들들과 이스라엘 온 족속에게 고하여 이르라 이스라엘 자손이나 그 중에 우거하는 자가 서원제나 낙헌제로 번제를 여호와께 예물로 드리려거든 ");
INSERT INTO kor_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","열납되도록 소나 양이나 염소의 흠 없는 수컷으로 드릴지니 ");
INSERT INTO kor_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","무릇 흠 있는 것을 너희는 드리지 말 것은 그것이 열납되지 못할 것임이니라 ");
INSERT INTO kor_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","무릇 서원한 것을 갚으려든지 자의로 예물을 드리려든지 하여 소나 양으로 화목제 희생을 여호와께 드리는 자는 열납되도록 아무 흠이 없는 온전한 것으로 할지니 ");
INSERT INTO kor_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","눈먼 것이나, 상한 것이나, 지체에 베임을 당한 것이나, 종기 있는 것이나, 괴혈병 있는 것이나, 비루먹은 것을 너희는 여호와께 드리지 말며 단 위에 화제로 여호와께 드리지 말라 ");
INSERT INTO kor_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","우양의 지체가 더하거나 덜하거나 한 것은 너희가 낙헌 예물로는 쓰려니와 서원한 것을 갚음으로 드리면 열납되지 못하리라 ");
INSERT INTO kor_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","너희는 불알이 상하였거나, 치었거나, 터졌거나, 베임을 당한 것은 여호와께 드리지 말며 너희 땅에서는 이런 일을 행치도 말지며 ");
INSERT INTO kor_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","너희는 외방인에게서도 이런 것을 받아 너희의 하나님의 식물로 드리지 말라 이는 결점이 있고 흠이 있는 것인즉 너희를 위하여 열납되지 못할 것임이니라 ");
INSERT INTO kor_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","수소나 양이나 염소가 나거든 칠일동안 그 어미와 같이 있게하라 제 팔일 이후로는 여호와께 화제로 예물을 드리면 열납되리라 ");
INSERT INTO kor_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","암소나 암양을 무론하고 어미와 새끼를 동일에 잡지 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","너희가 여호와께 감사 희생을 드리거든 너희가 열납되도록 드릴지며 ");
INSERT INTO kor_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","그 제물은 당일에 먹고 이튿날까지 두지 말라 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","너희는 나의 계명을 지키며 행하라 ! 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","너희는 나의 성호를 욕되게 말라 ! 나는 이스라엘 자손 중에서 거룩하게 함을 받을 것이니라 나는 너희를 거룩하게 하는 여호와요 ");
INSERT INTO kor_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","너희 하나님이 되려고 너희를 애굽 땅에서 인도하여 낸 자니 나는 여호와니라 ");
INSERT INTO kor_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","이스라엘 자손에게 고하여 이르라 너희가 공포하여 성회를 삼을 여호와의 절기는 이러하니라 ");
INSERT INTO kor_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","엿새 동안은 일할 것이요 일곱째 날은 쉴 안식일이니 성회라 너희는 무슨 일이든지 하지 말라 이는 너희 거하는 각처에서 지킬 여호와의 안식일이니라 ");
INSERT INTO kor_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","기한에 미쳐 너희가 공포하여 성회로 삼을 여호와의 절기는 이러하니라 ");
INSERT INTO kor_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","정월 십사일 저녁은 여호와의 유월절이요 ");
INSERT INTO kor_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","이 달 십오일은 여호와의 무교절이니 칠일 동안 너희는 무교병을 먹을 것이요 ");
INSERT INTO kor_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","그 첫날에는 너희가 성회로 모이고 아무 노동도 하지 말지며 ");
INSERT INTO kor_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","너희는 칠일 동안 여호와께 화제를 드릴 것이요 제 칠일에도 성회로 모이고 아무 노동도 하지 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","이스라엘 자손에게 고하여 이르라 너희는 내가 너희에게 주는 땅에 들어가서 너희의 곡물을 거둘 때에 위선 너희의 곡물의 첫 이삭 한 단을 제사장에게로 가져갈 것이요 ");
INSERT INTO kor_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","제사장은 너희를 위하여 그 단을 여호와 앞에 열납되도록 흔들되 안식일 이튿날에 흔들 것이며 ");
INSERT INTO kor_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","너희가 그 단을 흔드는 날에 일년 되고 흠 없는 수양을 번제로 여호와께 드리고 ");
INSERT INTO kor_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","그 소제로는 기름 섞은 고운 가루 에바 십분 이를 여호와께 드려 화제를 삼아 향기로운 냄새가 되게 하고 전제로는 포도주 힌 사분 일을 쓸 것이며 ");
INSERT INTO kor_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","너희는 너희 하나님께 예물을 가져오는 그 날까지 떡이든지 볶은 곡식이든지 생 이삭이든지 먹지 말지니 이는 너희가 그 거하는 각처에서 대대로 지킬 영원한 규례니라 ! ");
INSERT INTO kor_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","안식일 이튿날 곧 너희가 요제로 단을 가져온 날부터 세어서 칠안식일의 수효를 채우고 ");
INSERT INTO kor_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","제 칠 안식일 이튿날까지 합 오십일을 계수하여 새 소제를 여호와께 드리되 ");
INSERT INTO kor_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","너희 처소에서 에바 십분 이로 만든 떡 두개를 가져다가 흔들지니 이는 고운 가루에 누룩을 넣어서 구운 것이요 이는 첫 요제로 여호와께 드리는 것이며 ");
INSERT INTO kor_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","너희는 또 이 떡과 함께 일년 되고 흠 없는 어린 양 일곱과 젊은 수소 하나와 수양 둘을 드리되 이들을 그 소제와 그 전제와 함께 여호와께 드려서 번제를 삼을지니 이는 화제라 여호와께 향기로운 냄새며 ");
INSERT INTO kor_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","또 수염소 하나로 속죄제를 드리며 일년된 어린 수양 둘을 화목제 희생으로 드릴 것이요 ");
INSERT INTO kor_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","제사장은 그 첫이삭의 떡과 함께 그 두 어린 양을 여호와 앞에 흔들어 요제를 삼을 것이요 이것들은 여호와께 드리는 성물인즉 제사장에게 돌릴 것이며 ");
INSERT INTO kor_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","이 날에 너희는 너희 중에 성회를 공포하고 아무 노동도 하지 말지니 이는 너희가 그 거하는 각처에서 대대로 지킬 영원한 규례니라 ! ");
INSERT INTO kor_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","너희 땅의 곡물을 벨 때에 밭 모퉁이까지 다 베지 말며 떨어진 진을 줍지 말고 너는 그것을 가난한 자와 객을 위하여 버려 두라 나는 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","이스라엘 자손에게 고하여 이르라 칠월 곧 그 달 일일로 안식일을 삼을지니 이는 나팔을 불어 기념할 날이요 성회라 ");
INSERT INTO kor_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","아무 노동도 하지 말고 여호와께 화제를 드릴지니라 ");
INSERT INTO kor_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","칠월 십일은 속죄일이니 너희에게 성회라 너희는 스스로 괴롭게하며 여호와께 화제를 드리고 ");
INSERT INTO kor_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","이 날에는 아무 일도 하지 말 것은 너희를 위하여 너희 하나님 여호와 앞에 속죄할 속죄일이 됨이니라 ");
INSERT INTO kor_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","이 날에 스스로 괴롭게 하지 아니하는 자는 그 백성 중에서 끊쳐질 것이라 ");
INSERT INTO kor_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","이 날에 누구든지 아무 일이나 하는 자는 내가 백성 중에서 멸절시키리니 ");
INSERT INTO kor_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","너희는 아무 일이든지 하지 말라 이는 너희가 그 거하는 각처에서 대대로 지킬 영원한 규례니라 ! ");
INSERT INTO kor_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","이는 너희의 쉴 안식일이라 너희는 스스로 괴롭게 하고 이 달 구일 저녁 곧 그 저녁부터 이튿날 저녁까지 안식을 지킬지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","이스라엘 자손에게 고하여 이르라 칠월 십오일은 초막절이니 여호와를 위하여 칠일동안 지킬 것이라 ");
INSERT INTO kor_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","첫 날에는 성회가 있을지니 너희는 아무 노동도 하지 말지며 ");
INSERT INTO kor_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","칠일 동안에 너희는 화제를 여호와께 드릴 것이요 제 팔일에도 너희에게 성회가 될 것이며 화제를 여호와께 드릴지니 이는 거룩한 대회라 너희는 아무 노동도 하지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","이것들은 여호와의 절기라 너희는 공포하여 성회를 삼고 번제와 소제와 희생과 전제를 각각 그 날에 여호와께 화제로 드릴지니 ");
INSERT INTO kor_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","이는 여호와의 안식일 외에, 너희의 헌물 외에, 너희의 모든 서원 예물외에,너희의 모든 낙헌 예물 외에 너희가 여호와께 드리는 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","너희가 토지 소산 거두기를 마치거든 칠월 십오일부터 칠일 동안 여호와의 절기를 지키되 첫날에도 안식하고 제 팔일에도 안식할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","첫날에는 너희가 아름다운 나무 실과와, 종려 가지와, 무성한 가지와, 시내 버들을 취하여 너희 하나님 여호와 앞에서 칠일동안 즐거워할 것이라 ");
INSERT INTO kor_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","너희는 매년에 칠일 동안 여호와께 이 절기를 지킬지니 너희 대대로의 영원한 규례라 ! 너희는 칠월에 이를 지킬지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","너희는 칠일 동안 초막에 거하되 이스라엘에서 난 자는 다 초막에 거할지니 ");
INSERT INTO kor_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","이는 내가 이스라엘 자손을 애굽 땅에서 인도하여 내던 때에 초막에 거하게 한 줄을 너희 대대로 알게 함이니라 나는 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","모세가 여호와의 절기를 이스라엘 자손에게 공포하였더라 ");
INSERT INTO kor_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","이스라엘 자손에게 명하여 감람을 찧어 낸 순결한 기름을 켜기 위하여 네게로 가져오게 하고 끊이지 말고 등잔불을 켤지며 ");
INSERT INTO kor_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","아론은 회막 안 증거궤 장 밖에서 저녁부터 아침까지 여호와 앞에 항상 등잔불을 정리할지니 너희 대대로 지킬 영원한 규례라 ");
INSERT INTO kor_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","그가 여호와 앞에서 순결한 등대 위의 등잔들을 끊이지 않고 정리할지니라 ");
INSERT INTO kor_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","너는 고운 가루를 취하여 떡 열 둘을 굽되 매 덩이를 에바 십분 이로 하여 ");
INSERT INTO kor_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","여호와 앞 순결한 상 위에 두 줄로 한 줄에 여섯씩 진설하고 ");
INSERT INTO kor_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","너는 또 정결한 유향을 그 매 줄 위에 두어 기념물로 여호와께 화제를 삼을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","항상 매 안식일에 이 떡을 여호와 앞에 진설할지니 이는 이스라엘 자손을 위한 것이요 영원한 언약이니라 ");
INSERT INTO kor_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","이 떡은 아론과 그 자손에게 돌리고 그들은 그것을 거룩한 곳에서 먹을지니 이는 여호와의 화제 중 그에게 돌리는 것으로서 지극히 거룩함이니라 이는 영원한 규례니라 ");
INSERT INTO kor_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","이스라엘 여인의 아들이요 그 아비는 애굽 사람된 자가 이스라엘 자손 중에 나가서 한 이스라엘 사람과 진중에서 싸우다가 ");
INSERT INTO kor_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","그 이스라엘 여인의 아들이 여호와의 이름을 훼방하며 저주하므로 무리가 끌고 모세에게로 가니라 그 어미의 이름은 슬로밋이요 단 지파 디브리의 딸이었더라 ");
INSERT INTO kor_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","그들이 그를 가두고 여호와의 명령을 기다리더니 ");
INSERT INTO kor_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","저주한 사람을 진 밖에 끌어 내어 그 말을 들은 모든 자로 그 머리에 안수하게 하고 온 회중이 돌로 그를 칠지니라 ");
INSERT INTO kor_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","너는 이스라엘 자손에게 고하여 이르라 누구든지 자기 하나님을 저주하면 죄를 당할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","여호와의 이름을 훼방하면 그를 반드시 죽일지니 온 회중이 돌로 그를 칠 것이라 외국인이든지 본토인이든지 여호와의 이름을 훼방하면 그를 죽일지니라 ");
INSERT INTO kor_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","사람을 쳐 죽인 자는 반드시 죽일 것이요 ");
INSERT INTO kor_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","짐승을 쳐 죽인 자는 짐승으로 짐승을 갚을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","사람이 만일 그 이웃을 상하였으면 그 행한 대로 그에게 행할 것이니 ");
INSERT INTO kor_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","파상은 파상으로, 눈은 눈으로, 이는 이로 갚을지라 남에게 손상을 입힌대로 그에게 그렇게 할것이며 ");
INSERT INTO kor_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","짐승을 죽인 자는 그것을 물어 줄 것이요 사람을 죽인 자는 죽일지니 ");
INSERT INTO kor_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","외국인에게든지 본토인에게든지 그 법을 동일히 할 것은 나는 너희 하나님 여호와임이니라 ! ");
INSERT INTO kor_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","모세가 이스라엘 자손에게 고하니 그들이 저주한 자를 진 밖에 끌어내어 돌로 쳤더라 이스라엘 자손이 여호와께서 모세에게 명하신 대로 행하였더라 ");
INSERT INTO kor_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","여호와께서 시내산에서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","이스라엘 자손에게 고하여 이르라 너희는 내가 너희에게 주는 땅에 들어간 후에 그 땅으로 여호와 앞에 안식하게 하라 ");
INSERT INTO kor_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","너는 육년 동안 그 밭에 파종하며 육년 동안 그 포도원을 다스려 그 열매를 거둘 것이나 ");
INSERT INTO kor_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","제 칠년에는 땅으로 쉬어 안식하게 할지니 여호와께 대한 안식이라 너는 그 밭에 파종하거나 포도원을 다스리지 말며 ");
INSERT INTO kor_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","너의 곡물의 스스로 난 것을 거두지 말고 다스리지 아니한 포도나무의 맺은 열매를 거두지 말라 이는 땅의 안식년임이니라 ");
INSERT INTO kor_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","안식년의 소출은 너희의 먹을 것이니 너와 네 남종과, 네 여종과, 네 품군과, 너와 함께 거하는 객과, ");
INSERT INTO kor_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","네 육축과 네 땅에 있는 들짐승들이 다 그 소산으로 식물을 삼을지니라 ");
INSERT INTO kor_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","너는 일곱 안식년을 계수할지니 이는 칠년이 일곱번인즉 안식년 일곱번 동안 곧 사십 구년이라 ");
INSERT INTO kor_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","칠월 십일은 속죄일이니 너는 나팔 소리를 내되 전국에서 나팔을 크게 불지며 ");
INSERT INTO kor_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","제 오십년을 거룩하게 하여 전국 거민에게 자유를 공포하라 ! 이 해는 너희에게 희년이니 너희는 각각 그 기업으로 돌아가며 각각 그 가족에게로 돌아갈지며 ");
INSERT INTO kor_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","그 오십년은 너희의 희년이니 너희는 파종하지 말며 스스로 난 것을 거두지 말며 다스리지 아니한 포도를 거두지 말라 ");
INSERT INTO kor_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","이는 희년이니 너희에게 거룩함이니라 너희가 밭의 소산을 먹으리라 ");
INSERT INTO kor_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","이 희년에는 너희가 각기 기업으로 돌아갈지라 ");
INSERT INTO kor_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","네 이웃에게 팔든지 네 이웃의 손에서 사거든 너희는 서로 속이지 말라 ");
INSERT INTO kor_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","희년 후의 연수를 따라서 너는 이웃에게 살 것이요 그도 그 열매를 얻을 연수를 따라서 네게 팔 것인즉 ");
INSERT INTO kor_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","연수가 많으면 너는 그 값을 많게 하고 연수가 적으면 너는 그 값을 적게 할지니 곧 그가 그 열매의 다소를 따라서 네게 팔 것이라 ");
INSERT INTO kor_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","너희는 서로 속이지 말고 너희의 하나님을 경외하라 ! 나는 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","너희는 내 법도를 행하며 내 규례를 지켜 행하라 ! 그리하면 너희가 그 땅에 안전히 거할 것이라 ");
INSERT INTO kor_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","땅은 그 산물을 내리니 너희가 배불리 먹고 거기 안전히 거하리라 ");
INSERT INTO kor_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","혹 너희 말이 우리가 만일 제 칠년에 심지도 못하고 그 산물을 거두지도 못하면 무엇을 먹으리요 하겠으나 ");
INSERT INTO kor_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","내가 명하여 제 육년에 내 복을 너희에게 내려 그 소출이 삼년 쓰기에 족하게 할지라 ");
INSERT INTO kor_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","너희가 제 팔년에는 파종하려니와 묵은 곡식을 먹을 것이며 제 구년 곧 추수하기까지 묵은 곡식을 먹으리라 ");
INSERT INTO kor_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","토지를 영영히 팔지 말 것은 토지는 다 내 것임이라 너희는 나그네요 우거하는 자로서 나와 함께 있느니라 ");
INSERT INTO kor_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","너희 기업의 온 땅에서 그 토지 무르기를 허락할지니 ");
INSERT INTO kor_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","만일 너희 형제가 가난하여 그 기업 얼마를 팔았으면 그 근족이 와서 동족의 판 것을 무를 것이요 ");
INSERT INTO kor_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","만일 그것을 무를 사람이 없고 자기가 부요하게 되어 무를 힘이 있거든 ");
INSERT INTO kor_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","그 판 해를 계수하여 그 남은 값을 산 자에게 주고 그 기업으로 돌아갈 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","그러나 자기가 무를 힘이 없으면 그 판것이 희년이 이르기까지 산자의 손에 있다가 희년에 미쳐 돌아올지니 그가 곧 그 기업으로 돌아갈 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","성벽 있는 성내의 가옥을 팔았으면 판 지 만 일년 안에는 무를 수 있나니 곧 그 기한 안에 무르려니와 ");
INSERT INTO kor_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","주년 내에 무르지 못하면 그 성내 가옥은 산 자의 소유로 확정되어 대대로 영영히 그에게 속하고 희년에라도 돌려 보내지 아니할 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","그러나 성벽이 둘리지 아니한 촌락의 가옥은 나라의 전토 일례로 물러주기도 할 것이요 희년에 돌려 보내기도 할 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","레위 족속의 성읍 곧 그 기업의 성읍의 가옥은 레위 사람이 언제든지 무를 수 있으나 ");
INSERT INTO kor_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","레위 사람이 만일 무르지 아니하면 그 기업된 성읍의 판 가옥은 희년에 돌려 보낼지니 대저 레위 사람의 성읍의 가옥은 이스라엘 자손 중에서 얻을 기업이 됨이니라 ");
INSERT INTO kor_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","그러나 그 성읍의 들의 사면 밭은 그의 영원한 기업이니 팔지 못할지니라 ");
INSERT INTO kor_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","네 동족이 빈한하게 되어 빈 손으로 네 곁에 있거든 너는 그를 도와 객이나 우거하는 자처럼 너와 함께 생활하게 하되 ");
INSERT INTO kor_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","너는 그에게 이식을 취하지 말고 네 하나님을 경외하여 네 형제로 너와 함께 생활하게 할 것인즉 ");
INSERT INTO kor_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","너는 그에게 이식을 위하여 돈을 꾸이지 말고 이익을 위하여 식물을 꾸이지 말라 ");
INSERT INTO kor_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","나는 너희 하나님이 되려고 또는 가나안 땅으로 너희에게 주려고 애굽 땅에서 너희를 인도하여 낸 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","네 동족이 반한하게 되어 네게 몸이 팔리거든 너는 그를 종으로 부리지 말고 ");
INSERT INTO kor_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","품군이나 우거하는 자같이 너와 함께 있게 하여 희년까지 너를 섬기게 하라 ");
INSERT INTO kor_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","그 때에는 그와 그 자녀가 함께 네게서 떠나 그 본족에게로 돌아가서 조상의 기업을 회복하리라 ");
INSERT INTO kor_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","그들은 내가 애굽 땅에서 인도하여 낸바 나의 품군인즉 종으로 팔리지 말 것이라 ");
INSERT INTO kor_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","너는 그를 엄하게 부리지 말고 너의 하나님을 경외하라 ! ");
INSERT INTO kor_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","너의 종은 남녀를 무론하고 너의 사면 이방인 중에서 취할지니 남녀 종은 이런 자 중에서 살 것이며 ");
INSERT INTO kor_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","또 너희 중에 우거한 이방인의 자녀 중에서도 너희가 살 수 있고 또 그들이 너희 중에서 살아서 너희 땅에서 가정을 이룬 그 중에서도 그리할 수 있은즉 그들이 너희 소유가 될찌니 ");
INSERT INTO kor_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","너희는 그들을 너희 후손에게 기업으로 주어 소유가 되게 할 것이라 이방인 중에서는 너희가 영원한 종을 삼으려니와 너희 동족 이스라엘 자손은 너희 피차 엄하게 부리지 말지니라 ");
INSERT INTO kor_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","너희 중에 우거하는 이방인은 부요하게 되고 그 곁에 사는 너희 동족은 빈한하게 됨으로 너희 중에 우거하는 그 이방인에게나 그 족속에게 몸이 팔렸으면 ");
INSERT INTO kor_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","팔린 후에 그를 속량할 수 있나니 그 형제 중 하나가 속하거나 ");
INSERT INTO kor_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","삼촌이나 사촌이 속하거나 그 근족 중 누구든지 속할 것이요 그가 부요하게 되면 스스로 속하되 ");
INSERT INTO kor_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","자기 몸이 팔린 해로부터 희년까지를 그 산 자와 계산하여 그 년수를 따라서 그 몸의 값을 정할 때에 그 사람을 섬긴 날을 그 사람에게 고용된 날로 여길 것이라 ");
INSERT INTO kor_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","만일 남은 해가 많으면 그 연수대로 팔린 값에서 속하는 값을 그 사람에게 도로 주고 ");
INSERT INTO kor_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","만일 희년까지 남은 해가 적으면 그 사람과 계산하여 그 연수대로 속하는 그 값을 그에게 도로 줄지며 ");
INSERT INTO kor_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","주인은 그를 매년의 삯군과 같이 여기고 너의 목전에서 엄하게 부리지 못하리라 ");
INSERT INTO kor_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","그가 이같이 속하지 못하면 희년에 이르러 그와 그 자녀가 자유하리니 ");
INSERT INTO kor_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","이스라엘 자손은 나의 품군이 됨이라 그들은 내가 애굽 땅에서 인도하여 낸 나의 품군이요 나는 너희 하나님 여호와니라 ");
INSERT INTO kor_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","너희는 자기를 위하여 우상을 만들지 말지니 목상이나 주상을 세우지 말며 너희 땅에 조각한 석상을 세우고 그에게 경배하지 말라 나는 너희 하나님 여호와임이니라 ! ");
INSERT INTO kor_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","너희는 나의 안식일을 지키며 나의 성소를 공경하라 ! 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","너희가 나의 규례와 계명을 준행하면 ");
INSERT INTO kor_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","내가 너희 비를 그 시후에 주리니 땅은 그 산물을 내고 밭의 수목은 열매를 맺을지라 ");
INSERT INTO kor_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","너희의 타작은 포도 딸 때까지 미치며 너희의 포도 따는 것은 파종할 때까지 미치리니 너희가 음식을 배불리 먹고 너희 땅에 안전히 거하리라 ");
INSERT INTO kor_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","내가 그 땅에 평화를 줄 것인즉 너희가 누우나 너희를 두렵게 할자가 없을 것이며 내가 사나운 짐승을 그 땅에서 제할 것이요 칼이 너희 땅에 두루 행하지 아니할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","너희가 대적을 쫓으리니 그들이 너희 앞에서 칼에 엎드러질 것이라 ");
INSERT INTO kor_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","너희 다섯이 백을 쫓고, 너희 백이 만을 쫓으리니 너희 대적들이 너희 앞에서 칼에 엎드러질 것이며 ");
INSERT INTO kor_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","내가 너희를 권고하여 나의 너희와 세운 언약을 이행하여 너희로 번성케 하고 너희로 창대케 할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","너희는 오래 두었던 묵은 곡식을 먹다가 새 곡식을 인하여 묵은 곡식을 치우게 될 것이며 ");
INSERT INTO kor_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","내가 내 장막을 너희 중에 세우리니 내 마음이 너희를 싫어하지 아니할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","나는 너희 중에 행하여 너희 하나님이 되고 너희는 나의 백성이 될 것이니라 ");
INSERT INTO kor_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","나는 너희를 애굽 땅에서 인도하여 내어 그 종된 것을 면케 한 너희 하나님 여호와라 ! 내가 너희 멍에 빗장목을 깨뜨리고 너희로 바로 서서 걷게 하였느니라 ");
INSERT INTO kor_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","그러나 너희가 내게 청종치 아니하여 이 모든 명령을 준행치 아니하며 ");
INSERT INTO kor_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","나의 규례를 멸시하며 마음에 나의 법도를 싫어하여 나의 모든 계명을 준행치 아니하며 나의 언약을 배반할진대 ");
INSERT INTO kor_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","내가 이같이 너희에게 행하리니 곧 내가 너희에게 놀라운 재앙을 내려 폐병과 열병으로 눈이 어둡고 생명이 쇠약하게 할것이요 너희의 파종은 헛되리니 너희의 대적이 그것을 먹을 것임이며 ");
INSERT INTO kor_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","내가 너희를 치리니 너희가 너희 대적에게 패할 것이요 너희를 미워하는 자가 너희를 다스릴 것이며 너희는 쫓는 자가 없어도 도망하리라 ");
INSERT INTO kor_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","너희가 그렇게 되어도 내게 청종치 아니하면 너희 죄를 인하여 내가 너희를 칠배나 더 징치할지라 ");
INSERT INTO kor_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","내가 너희의 세력을 인한 교만을 꺾고 너희 하늘로 철과 같게 하며 너희 땅으로 놋과 같게 하리니 ");
INSERT INTO kor_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","너희 수고가 헛될지라 땅은 그 산물을 내지 아니하고 땅의 나무는 그 열매를 맺지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","너희가 나를 거스려 내게 청종치 않을진대 내가 너희 죄대로 너희에게 칠배나 더 재앙을 내릴 것이라 ");
INSERT INTO kor_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","내가 들짐승을 너희 중에 보내리니 그것들이 너희 자녀를 움키고 너희 육축을 멸하며 너희 수효를 감소케 할지라 너희 도로가 황폐하리라 ");
INSERT INTO kor_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","이런 일을 당하여도 너희가 내게로 돌아오지 아니하고 나를 대항할진대 ");
INSERT INTO kor_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","나 곧 나도 너희에게 대항하여 너희 죄를 인하여 너희를 칠배나 더 칠지라 ");
INSERT INTO kor_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","내가 칼을 너희에게로 가져다가 너희의 배약한 원수를 갚을 것이며 너희가 성읍에 모일지라도 너희 중에 염병을 보내고 너희를 대적의 손에 붙일 것이며 ");
INSERT INTO kor_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","내가 너희 의뢰하는 양식을 끊을 때에 열 여인이 한 화덕에서 너희 떡을 구워 저울에 달아 주리니 너희가 먹어도 배부르지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","너희가 이같이 될지라도 내게 청종치 아니하고 내게 대항할진대 ");
INSERT INTO kor_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","내가 진노로 너희에게 대항하되 너희 죄를 인하여 칠배나 더 징책하리니 ");
INSERT INTO kor_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","너희가 아들의 고기를 먹을 것이요 딸의 고기를 먹을 것이며 ");
INSERT INTO kor_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","내가 너희의 산당을 헐며 너희의 태양 주상을 찍어 넘기며 너희 시체를 파상한 우상 위에 던지고 내 마음이 너희를 싫어할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","내가 너희 성읍으로 황폐케 하고 너희 성소들로 황량케 할 것이요 너희의 향기로운 향을 흠향치 아니하고 ");
INSERT INTO kor_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","그 땅을 황무케 하리니 거기 거하는 너희 대적들이 그것을 인하여 놀랄 것이며 ");
INSERT INTO kor_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","내가 너희를 열방 중에 흩을 것이요 내가 칼을 빼어 너희를 따르게 하리니 너희의 땅이 황무하며 너희의 성읍이 황폐하리라 ");
INSERT INTO kor_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","너희가 대적의 땅에 거할 동안에 너희 본토가 황무할 것이므로 땅이 안식을 누릴 것이라 그 때에 땅이 쉬어 안식을 누리리니 ");
INSERT INTO kor_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","너희가 그 땅에 거한 동안 너희 안식시에 쉼을 얻지 못하던 땅이 그 황무할 동안에는 쉬리라 ");
INSERT INTO kor_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","너희 남은 자에게는 그 대적의 땅에서 내가 그들의 마음으로 약하게 하리니 그들은 바람에 불린 잎사귀 소리에도 놀라 도망하기를 칼을 피하여 도망하듯 할 것이요 쫓는 자가 없어도 엎드러질 것이라 ");
INSERT INTO kor_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","그들은 쫓는 자가 없어도 칼 앞에 있음같이 서로 천답하여 넘어지리니 너희가 대적을 당할 힘이 없을 것이요 ");
INSERT INTO kor_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","너희가 열방 중에서 망하리니 너희 대적의 땅이 너희를 삼킬 것이라 ");
INSERT INTO kor_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","너희 남은 자가 너희 대적의 땅에서 자기의 죄로 인하여 쇠잔하며 그 열조의 죄로 인하여 그 열조 같이 쇠잔하리라 ");
INSERT INTO kor_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","그들이 자기 죄와 그 열조의 죄와 및 그들이 나를 거스린 허물을 자복하고 또 자기들이 나를 대항하였으므로 ");
INSERT INTO kor_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","나도 그들을 대항하여 그 대적의 땅으로 끌어 갔음을 깨닫고 그 할례받지 아니한 마음이 낮아져서 그 죄악의 형벌을 순히 받으면 ");
INSERT INTO kor_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","내가 야곱과 맺은 내 언약과 이삭과 맺은 내 언약을 생각하며 아브라함과 맺은 내 언약을 생각하고 그 땅을 권고하리라 ");
INSERT INTO kor_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","그들이 나의 법도를 싫어하며 나의 규례를 멸시하였으므로 그 땅을 떠나서 사람이 없을 때에 땅이 황폐하여 안식을 누릴 것이요 그들은 자기 죄악으로 형벌을 순히 받으리라 ");
INSERT INTO kor_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","그런즉 그들이 대적의 땅에 거할 때에 내가 싫어 버리지 아니하며, 미워하지 아니하며, 아주 멸하지 아니하여 나의 그들과 세운 언약을 폐하지 아니하리니 나는 여호와 그들의 하나님이 됨이라 ");
INSERT INTO kor_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","내가 그들의 하나님이 되기 위하여 열방의 목전에 애굽에서 인도하여 낸 그들의 열조와 맺은 언약을 그들을 위하여 기억하리라 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","이상은 여호와께서 시내산에서 자기와 이스라엘 자손 사이에 모세로 세우신 규례와 법도와 율법이니라 ");
INSERT INTO kor_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","이스라엘 자손에게 고하여 이르라 사람을 여호와께 드리기로 서원하였으면 너는 그 값을 정할지니 ");
INSERT INTO kor_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","너의 정한 값은 이십세로 육십세까지는 남자이면 성소의 세겔대로 은 오십 세겔로 하고 ");
INSERT INTO kor_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","여자이면 그 값을 삼십 세겔로 하며 ");
INSERT INTO kor_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","오세로 이십세까지는 남자이면 그 값을 이십 세겔로 하고 여자이면 십 세겔로 하며 ");
INSERT INTO kor_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","일개월로 오세까지는 남자이면 그 값을 은 오 세겔로 하고 여자이면 그 값을 은 삼 세겔로 하며 ");
INSERT INTO kor_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","육십세 이상은 남자이면 그 값을 십 오 세겔로 하고 여자는 십 세겔로 하라 ");
INSERT INTO kor_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","그러나 서원자가 가난하여 너의 정가를 감당치 못하겠으면 그를 제사장의 앞으로 데리고 갈 것이요 제사장은 그 값을 정하되 그 서원자의 형세대로 값을 정할지니라 ");
INSERT INTO kor_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","사람이 예물로 여호와께 드리는 것이 생축이면 서원물로 여호와께 드릴 때는 다 거룩하니 ");
INSERT INTO kor_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","그것을 변개하여 우열간 바꾸지 못할 것이요 혹 생축으로 생축을 바꾸면 둘 다 거룩할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","부정하여 여호와께 예물로 드리지 못할 생축이면 그 생축을 제사장 앞으로 끌어 갈 것이요 ");
INSERT INTO kor_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","제사장은 그 우열간에 정가할지니 그 값이 제사장의 정한 대로 될것이며 ");
INSERT INTO kor_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","그가 그것을 무르려면 정가에 그 오분 일을 더할지니라 ");
INSERT INTO kor_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","사람이 자기 집을 구별하여 여호와께 드리려면 제사장이 그 우열간에 정가할지니 그 값이 제사장의 정한 대로 될 것이며 ");
INSERT INTO kor_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","그 사람이 자기 집을 무르려면 정가한 돈에 그 오분 일을 더할지니 그리하면 자기 소유가 되리라 ");
INSERT INTO kor_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","사람이 자기 기업된 밭 얼마를 구별하여 여호와께 드리려면 두락수대로 정가하되 보리 한 호멜지기에는 은 오십 세겔로 계산할지며 ");
INSERT INTO kor_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","그가 그 밭을 희년부터 구별하여 드렸으면 그 값을 네가 정한대로 할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","그 밭을 희년 후에 구별하여 드렸으면 제사장이 다음 희년까지 남은 연수를 따라 그 값을 계산하고 정가에서 그 값에 상당하게 감할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","밭을 구별하여 드린 자가 그것을 무르려면 정가한 돈에 그 오분일을 더할지니 그리하면 그것이 자기 소유가 될 것이요 ");
INSERT INTO kor_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","그가 그 밭을 무르지 아니하려거나 타인에게 팔았으면 다시는 무르지 못하고 ");
INSERT INTO kor_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","희년이 되어서 그 밭이 돌아오게 될 때에는 여호와께 바친 성물이 되어 영영히 드린 땅과 같이 제사장의 기업이 될 것이며 ");
INSERT INTO kor_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","사람에게 샀고 자기 기업이 아닌 밭을 여호와께 구별하여 드렸으면 ");
INSERT INTO kor_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","너는 정가하고 제사장은 그를 위하여 희년까지 계산하고 그는 너의 정가한 돈을 그 날에 여호와께 드려 성물을 삼을지며 ");
INSERT INTO kor_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","그 밭은 희년에 판 사람 곧 그 기업의 본주에게로 돌아 갈지니라 ");
INSERT INTO kor_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","너의 모든 정가를 성소의 세겔대로 하되 이십 게라를 한 세겔로 할지니라 ");
INSERT INTO kor_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","오직 생축의 첫새끼는 여호와께 돌릴 첫새끼라 우양을 물론하고 여호와의 것이니 누구든지 그것으로는 구별하여 드리지 못할 것이며 ");
INSERT INTO kor_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","부정한 짐승이면 너의 정가에 그 오분 일을 더하여 속할 것이요 만일 속하지 아니하거든 너의 정가대로 팔지니라 ");
INSERT INTO kor_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","오직 여호와께 아주 바친 그 물건은 사람이든지 생축이든지 기업의 밭이든지 팔지도 못하고 속하지도 못하나니 바친 것은 다 여호와께 지극히 거룩함이며 ");
INSERT INTO kor_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","아주 바친 그 사람은 다시 속하지 못하나니 반드시 죽일지니라 ! ");
INSERT INTO kor_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","땅의 십분 일 곧 땅의 곡식이나 나무의 과실이나 그 십분 일은 여호와의 것이니 여호와께 성물이라 ");
INSERT INTO kor_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","사람이 그 십분 일을 속하려면 그것에 그 오분 일을 더할 것이요 ");
INSERT INTO kor_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","소나 양의 십분 일은 막대기 아래로 통과하는 것의 열째마다 여호와의 거룩한 것이 되리니 ");
INSERT INTO kor_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","그 우열을 교계하거나 바꾸거나 하지 말라 바꾸면 둘 다 거룩하리니 속하지 못하리라 ");
INSERT INTO kor_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","이상은 여호와께서 시내산에서 이스라엘 자손을 위하여 모세에게 명하신 계명이니라 ");
INSERT INTO kor_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","이스라엘 자손이 애굽 땅에서 나온 후 제 이년 이월 일일에 여호와께서 시내 광야 회막에서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","너희는 이스라엘 자손의 모든 회중 각 남자의 수를 그들의 가족과 종족을 따라 그 명수대로 계수할지니 ");
INSERT INTO kor_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","이스라엘 중 이십세 이상으로 싸움에 나갈만한 모든 자를 너와 아론은 그 군대대로 계수하되 ");
INSERT INTO kor_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","매 지파의 각기 종족의 두령 한 사람씩 너희와 함께 하라 ");
INSERT INTO kor_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","너희와 함께 설 사람들의 이름은 이러하니 르우벤에게서는 스데울의 아들 엘리술이요 ");
INSERT INTO kor_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","시므온에게서는 수리삿대의 아들 슬루미엘이요 ");
INSERT INTO kor_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","유다에게서는 암미나답의 아들 나손이요 ");
INSERT INTO kor_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","잇사갈에게서는 수리알의 아들 느다넬이요 ");
INSERT INTO kor_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","스불론에게서는 헬론의 아들 엘리압이요 ");
INSERT INTO kor_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","요셉 자손에게서는 에브라임에 암미훗의 아들 엘리사마와, 므낫세에 브다술의 아들 가말리엘이요 ");
INSERT INTO kor_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","베냐민에게서는 기드오니의 아들 아비단이요 ");
INSERT INTO kor_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","단에게서는 암미삿대의 아들 아히에셀이요 ");
INSERT INTO kor_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","아셀에게서는 오그란의 아들 바기엘이요 ");
INSERT INTO kor_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","갓에게서는 드우엘의 아들 엘리아삽이요 ");
INSERT INTO kor_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","납달리에게서는 에난의 아들 아히라니라 하시니 ");
INSERT INTO kor_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","그들은 회중에서 부름을 받은 자요 그 조상 지파의 족장으로서 이스라엘 천만인의 두령이라 ");
INSERT INTO kor_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","모세와 아론이 지명된 이 사람들을 데리고 ");
INSERT INTO kor_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","이월 일일에 온 회중을 모으니 그들이 각기 가족과 종족을 따라 이십세 이상으로 그 명수를 의지하여 자기 계통을 말하매 ");
INSERT INTO kor_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","여호와께서 모세에게 명하신 대로 그가 시내 광야에서 그들을 계수하였더라 ");
INSERT INTO kor_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","이스라엘의 장자 르우벤의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈만한 각 남자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","르우벤 지파의 계수함을 입은 자가 사만 육천 오백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","시드몬의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈만한 각 남자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","시므온 지파의 계수함을 입은 자가 오만 구천 삼백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","갓의 아들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈 만한 자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","갓 지파의 계수함을 입은 자가 사만 오천 육백 오십명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","유다의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈 만한 자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","유다 지파의 계수함을 입은자가 칠만 사천 육백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","잇사갈의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈 만한 자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","잇사갈 지파의 계수함을 입은자가 오만 사천 사백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","스불론의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈 만한 자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","스불론 지파의 계수함을 입은 자가 오만 칠천 사백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","요셉의 아들 에브라임의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈 만한 자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","에브라임 지파의 계수함을 입은 자가 사만 오백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","므낫세의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈 만한 자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","므낫세 지파의 계수함을 입은 자가 삼만 이천 이백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","베냐민의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈 만한 자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","단의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈 만한 자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","베냐민 지파의 계수함을 입은 자가 삼만 오천 사백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","단의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈 만한 자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","베냐민 지파의 계수함을 입은 자가 삼만 오천 사백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","단 지파의 계수함을 입은 자가 육만 이천 칠백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","아셀의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세이상으로 싸움에 나갈 만한 자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","아셀 지파의 계수함을 입은 자가 사만 일천 오백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","납달리의 아들들에게서 난 자를 그들의 가족과 종족을 따라 이십세 이상으로 싸움에 나갈 만한 자를 그 명수대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","납달리 지파의 계수함을 입은 자가 오만 삼천 사백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","이 계수함을 입은 자는 모세와 아론과 각기 이스라엘 종족을 대표한 족장 십 이인이 계수한 자라 ");
INSERT INTO kor_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","이같이 이스라엘 자손의 그 종족을 따라 이십세 이상으로 싸움에 나갈 만한 자가 이스라엘 중에서 다 계수함을 입었으니 ");
INSERT INTO kor_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","계수함을 입은 자의 총계가 육십만 삼천 오백 오십명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","오직 레위인은 그 조상의 지파대로 그 계수에 들지 아니하였으니 ");
INSERT INTO kor_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","이는 여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","레위 지파만은 너는 계수치 말며 그들을 이스라엘 자손 계수중에 넣지 말고 ");
INSERT INTO kor_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","그들을 증거막과 그 모든 기구와 그 모든 부속품을 관리하게 하라 ");
INSERT INTO kor_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","그들은 그 장막과 그 모든 기구를 운반하며 거기서 봉사하며 장막 사면에 진을 칠지며 ");
INSERT INTO kor_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","장막을 운반할 때에는 레위인이 그것을 걷고 장막을 세울 때에는 레위인이 그것을 세울 것이요 외인이 가까이 오면 죽일지며  (Numbers 1:55) 레위인은 증거막 사면에 진을 쳐서 이스라엘 자손의 회중에게 진노가 임하지 않게 할 것이라 레위인은 증거막에 대한 책임을 지킬지니라 ! 하셨음이라   (Numbers 1:56) 이스라엘 자손이 그대로 행하되 여호와께서 모세에게 명하신 대로 행하였더라  ");
INSERT INTO kor_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","여호와께서 모세와 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","이스라엘 자손은 각각 그 기와 그 종족의 기호 곁에 진을 치되 회막을 사면으로 대하여 치라 ");
INSERT INTO kor_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","동방 해 돋는 편에 진 칠 자는 그 군대대로 유다의 진기에 속한자라 유다 자손의 족장은 암미나답의 아들 나손이요 ");
INSERT INTO kor_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","그 군대는 계수함을 입은 자가 칠만 사천 육백명이며 ");
INSERT INTO kor_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","그 곁에 진 칠 자는 잇사갈 지파라 잇사갈 자손의 족장은 수알의 아들 느다넬이요 ");
INSERT INTO kor_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","그 군대는 계수함을 입은 자 오만 사천 사백명이며 ");
INSERT INTO kor_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","또 스불론 지파라 스불론 자손의 족장은 헬론의 아들 엘리압이요 ");
INSERT INTO kor_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","그 군대는 계수함을 입은 자 오만 칠천 사백명이니 ");
INSERT INTO kor_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","유다 진에 속한 군대의 계수함을 입은 군대의 총계가 십 팔만 육천 사백명이라 그들은 제 일대로 진행할지니라 ");
INSERT INTO kor_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","남편에는 르우벤 군대의 진 기가 있을 것이라 르우벤 자손의 족장은 스데울의 아들 엘리술이요 ");
INSERT INTO kor_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","그 군대는 계수함을 입은 자 사만 육천 오백명이며 ");
INSERT INTO kor_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","그 곁에 진 칠 자는 시므온 지파라 시므온 자손의 족장은 수리삿대의 아들 슬루미엘이요 ");
INSERT INTO kor_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","그 군대는 계수함을 입은 자 오만 구천 삼백명이며 ");
INSERT INTO kor_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","또 갓 지파라 갓 자손의 족장은 르우엘의 아들 엘리아삽이요 ");
INSERT INTO kor_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","그 군대는 계수함을 입은 자 사만 오천 육백 오십명이니 ");
INSERT INTO kor_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","르우벤 진에 속한 계수함을 입은 군대의 총계가 십 오만 일천 사백 오십명이라 그들은 제 이대로 진행할지니라 ");
INSERT INTO kor_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","그 다음에 회막이 레위인의 진과 함께 모든 진의 중앙에 있어 진행하되 그들의 진 친 순서대로 각 사람은 그 위치에서 그 기를 따라 앞으로 행할지니라 ");
INSERT INTO kor_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","서편에는 에브라임의 군대의 진 기가 있을 것이라 에브라임 자손의 족장은 암미훗의 아들 엘리사마요 ");
INSERT INTO kor_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","그 군대는 계수함을 입은 자 사만 오백명이며 ");
INSERT INTO kor_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","그 곁에는 므낫세 지파가 있을 것이라 므낫세 자손의 족장은 브다술의 아들 가말리엘이요 ");
INSERT INTO kor_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","그 군대는 계수함을 입은 자 삼만 이천 이백명이며 ");
INSERT INTO kor_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","또 베냐민 지파라 베냐민 자손의 족장은 기드오니의 아들 아비단이요 ");
INSERT INTO kor_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","그 군대는 계수함을 입은 자 삼만 오천 사백명이니 ");
INSERT INTO kor_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","에브라임 진에 속한 계수함을 입은 군대의 총계가 십만 팔천 일백명이라 그들은 제 삼대로 진행할지니라 ");
INSERT INTO kor_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","북편에는 단 군대의 진 기가 있을 것이라 단 자손의 족장은 암미삿대의 아들 아히에셀이요 ");
INSERT INTO kor_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","그 군대는 계수함을 입은 자 육만 이천 칠백명이며 ");
INSERT INTO kor_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","그 곁에 진 칠 자는 아셀 지파라 아셀 자손의 족장은 오그란의 아들 바기엘이요 ");
INSERT INTO kor_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","그 군대는 계수함을 입은 자 사만 일천 오백명이며 ");
INSERT INTO kor_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","또 납달리 지파라 납달리 자손의 족장은 에난의 아들 아히라요 ");
INSERT INTO kor_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","그 군대는 계수함을 입은 자 오만 삼천 사백명이니 ");
INSERT INTO kor_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","단의 진에 속한 계수함을 입은 군대의 총계가 십 오만 칠천 육백명이라 그들은 기를 따라 후대로 진행할지니라 하시니라 ");
INSERT INTO kor_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","이상은 이스라엘 자손이 그 종족을 따라 계수함을 입은 자니 모든 진의 군대 곧 계수함을 입은 총계가 육십만 삼천 오백 오십명이었으며 ");
INSERT INTO kor_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","레위인은 이스라엘 자손과 함께 계수되지 아니하였으니 여호와께서 모세에게 명하심과 같았느니라 ");
INSERT INTO kor_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","이스라엘 자손이 여호와께서 모세에게 명하신대로 다 준행하여 각기 가족과 종족을 따르며 그 기를 따라 진 치기도 하며 진행하기도 하였더라 ");
INSERT INTO kor_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","여호와께서 시내 산에서 모세와 말씀하실 때에 아론과 모세의 낳은 자가 이러하니라 ");
INSERT INTO kor_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","아론의 아들들의 이름은 장자는 나답이요, 다음은 아비후와, 엘르아살과, 이다말이니 ");
INSERT INTO kor_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","이는 아론의 아들들의 이름이며 그들은 기름을 발리우고 거룩히 구별되어 제사장 직분을 위임받은 제사장들이라 ");
INSERT INTO kor_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","나답과 아비후는 시내 광야에서 다른 불을 여호와 앞에 드리다가 여호와 앞에서 죽었고 무자하였고 엘리아살과, 이다말이 그 아비 아론 앞에서 제사장의 직분을 행하였더라 ");
INSERT INTO kor_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","여호와께서 또 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","레위 지파로 나아와 제사장 아론 앞에 서서 그에게 시종하게 하라 ");
INSERT INTO kor_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","그들이 회막 앞에서 아론의 직무와 온 회중의 직무를 위하여 회막에서 시무하되 ");
INSERT INTO kor_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","곧 회막의 모든 기구를 수직하며 이스라엘 자손의 직무를 위하여 장막에서 시무할지니 ");
INSERT INTO kor_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","너는 레위인을 아론과 그 아들들에게 주라 그들은 이스라엘 자손중에서 아론에게 온전히 돌리운 자니라 ");
INSERT INTO kor_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","너는 아론과 그 아들들을 세워 제사장 직분을 행하게 하라 외인이 가까이 하면 죽임을 당할 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","보라 내가 이스라엘 자손 중에서 레위인을 택하여 이스라엘 자손 중 모든 첫 태에 처음 난 자를 대신케 하였은즉 레위인은 내 것이라 ! ");
INSERT INTO kor_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","처음 난 자는 다 내 것임은 내가 애굽 땅에서 그 처음 난 자를 다 죽이던 날에 이스라엘의 처음 난 자는 사람이나 짐승을 다 거룩히 구별하였음이니 그들은 내 것이 될 것임이니라 ");
INSERT INTO kor_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","여호와께서 시내 광야에서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","레위 자손을 그들의 종족과 가족을 따라 계수하되 일개월 이상의 남자를 다 계수하라 ");
INSERT INTO kor_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","모세가 여호와의 말씀을 좇아 그 명하신 대로 계수하니라 ");
INSERT INTO kor_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","레위의 아들들의 이름은 이러하니 게르손과, 고핫과, 므라리요 ");
INSERT INTO kor_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","게르손의 아들들의 이름은 그 가족대로 이러하니 립니와, 시므이요 ");
INSERT INTO kor_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","고핫의 아들들은 그 가족대로 이러하니 아므람과, 이스할과, 헤브론과, 웃시엘이요 ");
INSERT INTO kor_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","므라리의 아들들은 그 가족대로 말리와, 무시니 이는 그 종족대로된 레위인의 가족들이니라 ");
INSERT INTO kor_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","게르손에게서는 립니 가족과, 시므이 가족이 났으니 이들이 곧 게르손의 가족들이라 ");
INSERT INTO kor_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","계수함을 입은 자의 수효 곧 일개월 이상 남자의 수효 합계가 칠천 오백명이며 ");
INSERT INTO kor_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","게르손 가족들은 장막 뒤 곧 서편에 진을 칠 것이요 ");
INSERT INTO kor_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","라엘의 아들 엘리아삽은 게르손 사람의 종족의 족장이 될것이며 ");
INSERT INTO kor_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","게르손 자손의 회막에 대하여 맡을 것은 성막과, 장막과, 그 덮개와, 회막 문장과, ");
INSERT INTO kor_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","뜰의 휘장과, 및 성막과, 단 사면에 있는 뜰의 문장과, 그 모든 것에 쓰는 줄들이니라 ");
INSERT INTO kor_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","고핫에게서는 아므람 가족과, 이스할 가족과, 헤브론 가족과, 웃시엘 가족이 났으니 이들이 곧 고핫 가족들이라 ");
INSERT INTO kor_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","계수함을 입은 일개월 이상 모든 남자의 수효가 팔천 육백명인데 성소를 맡을 것이며 ");
INSERT INTO kor_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","고핫 자손의 가족들은 성막 남편에 진을 칠 것이요 ");
INSERT INTO kor_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","웃시엘의 아들 엘리사반은 고핫 사람의 가족과, 종족의 족장이 될것이며 ");
INSERT INTO kor_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","그들의 맡을 것은 증거궤와, 상과, 등대와, 단들과, 성소에서 봉사하는데 쓰는 기구들과 휘장과 그것에 쓰는 모든 것이며 ");
INSERT INTO kor_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","제사장 아론의 아들 엘리아살은 레위인의 족장들의 어른이 되고 또 성소를 맡을 자를 통할할 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","므라리에게서는 말리 가족과 무시 가족이 났으니 이들이 곧 므라리 가족들이라 ");
INSERT INTO kor_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","그 계수함을 입은 자 곧 일개월 이상 남자의 수효 총계가 육천 이백명이며 ");
INSERT INTO kor_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","아비하일의 아들 수리엘이 므라리 가족과 종족의 족장이 될 것이요 이 가족은 장막 북편에 진을 칠 것이며 ");
INSERT INTO kor_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","므라리 자손의 맡을 것은 성막의 널판과, 그 띠와, 그 기둥과, 그 받침과, 그 모든 기구와, 그것에 쓰는 모든 것이며, ");
INSERT INTO kor_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","뜰 사면 기둥과, 그 받침과, 그 말뚝과, 그 줄들이니라 ");
INSERT INTO kor_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","장막 앞 동편 곧 회막 앞 해 돋는 편에는 모세와, 아론과, 아론의 아들들이 진을 치고 이스라엘 자손의 직무를 대신하여 성소의 직무를 지킬 것이며 외인이 가까이 하면 죽일지니라 ! ");
INSERT INTO kor_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","모세와 아론이 여호와의 명을 좇아 레위인을 각 가족대로 계수한즉 일개월 이상 남자의 수효가 이만 이천명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","여호와께서 또 모세에게 이르시되 이스라엘 자손의 처음 난 남자를 일개월 이상으로 다 계수하여 그 명수를 기록하라 ");
INSERT INTO kor_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","나는 여호와라 ! 이스라엘 자손 중 모든 처음 난 자의 대신에 레위인을 내게 돌리고 또 이스라엘 자손의 가축 중 모든 처음 난 것의 대신에 레위인의 가축을 내게 돌리라 ");
INSERT INTO kor_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","모세가 여호와께서 자기에게 명하신 대로 이스라엘 자손 중 모든 처음 난 자를 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","일개월 이상으로 계수함을 입은 처음 난 남자의 명수의 총계가 이만 이천 이백 칠십 삼명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","이스라엘 자손 중 모든 처음 난 자의 대신에 레위인을 취하고 또 그들의 가축 대신에 레위인의 가축을 취하라 레위인은 내 것이라 나는 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","이스라엘 자손의 처음 난 자가 레위인보다 이백 칠십 삼인이 더 한즉 속하기 위하여 ");
INSERT INTO kor_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","매명에 오세겔씩 취하되 성소의 세겔대로 취하라 한 세겔은 이십 게라니라 ");
INSERT INTO kor_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","그 더한 자의 속전을 아론과 그 아들들에게 줄 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","모세가 레위인으로 대속한 이외의 사람들에게서 속전을 받았으니 ");
INSERT INTO kor_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","곧 이스라엘 자손의 처음 난 자에게서 받은 돈이 성소의 세겔대로 일천 삼백 육십 오 세겔이라 ");
INSERT INTO kor_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","이 속전을 여호와의 말씀대로 아론과 그 아들들에게 주었으니 여호와께서 모세에게 명하심과 같았느니라 ");
INSERT INTO kor_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","여호와께서 또 모세와 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","레위 자손 중에서 고핫 자손을 그들의 가족과 종족을 따라 총계할지니 ");
INSERT INTO kor_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","곧 삼십세 이상으로 오십세까지 회막의 일을 하기 위하여 그 역사에 참가할 만한 모든 자를 계수하라 ");
INSERT INTO kor_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","고핫 자손의 회막 안 지성물에 대하여 할 일은 이러하니라 ");
INSERT INTO kor_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","행진할 때에 아론과 그 아들들이 들어가서 간 막는 장을 걷어 증거궤를 덮고 ");
INSERT INTO kor_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","그 위에 해달의 가죽으로 덮고 그 위에 순청색 보자기를 덮은후에 그 채를 꿰고 ");
INSERT INTO kor_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","또 진설병의 상에 청색 보자기를 펴고 대접들과, 숟가락들과, 주발들과, 붓는 잔들을 그 위에 두고 또 항상 진설하는 떡을 그 위에 두고 ");
INSERT INTO kor_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","홍색 보자기를 그 위에 펴고 그것을 해달의 가죽 덮개로 덮은후에 그 채를 꿰고 ");
INSERT INTO kor_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","또 청색 보자기를 취하여 등대와, 그 등잔들과, 그 불집게들과, 불똥 그릇들과, 그 쓰는 바 모든 기름 그릇을 덮고 ");
INSERT INTO kor_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","등대와 그 모든 기구를 해달의 가죽 덮개 안에 넣어 메는 틀위에 두고 ");
INSERT INTO kor_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","또 금단 위에 청색 보자기를 펴고 해달의 가죽 덮개로 덮고 그 채를 꿰고 ");
INSERT INTO kor_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","또 성소에서 봉사하는 데 쓰는 모든 기명을 취하여 청색 보자기에 싸서 해달의 가죽 덮개로 덮어 메는 틀 위에 두고 ");
INSERT INTO kor_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","또 단의 재를 버리고 그 단 위에 자색 보자기를 펴고 ");
INSERT INTO kor_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","봉사하는 데 쓰는 모든 기구 곧 불 옮기는 그릇들과, 고기 갈고리들과, 부삽들과, 대야들과, 단의 모든 기구를 두고 해달의 가죽 덮개를 그 위에 덮고 그 채를 꿸 것이며 ");
INSERT INTO kor_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","행진할 때에 아론과 그 아들들이 성소와 성소의 모든 기구 덮기를 필하거든 고핫 자손이 와서 멜 것이니라 그러나 성물은 만지지 말지니 죽을까 하노라 회막 물건 중에서 이것들은 고핫 자손이 멜 것이며 ");
INSERT INTO kor_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","제사장 아론의 아들 엘르아살의 맡을 것은 등유와, 분향할 향품과, 항상 드리는 소제물과, 관유며, 또 장막의 전체와, 그 중에 있는 모든 것과, 성소와, 그 모든 기구니라 ");
INSERT INTO kor_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","여호와께서 또 모세와 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","너희는 고핫 족속의 지파를 레위인 중에서 끊어지게 말지니 ");
INSERT INTO kor_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","그들이 지성물에 접근할 때에 그 생명을 보존하고 죽지 않게 하기 위하여 너희는 이같이 하여 아론과 그 아들들이 들어가서 각 사람에게 그 할 일과 그 멜 것을 지휘할지니라 ");
INSERT INTO kor_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","그들은 잠시라도 들어가서 성소를 보지 말것은 죽을까 함이니라 ");
INSERT INTO kor_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","여호와께서 또 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","게르손 자손도 그 종족과 가족을 따라 총계하되 ");
INSERT INTO kor_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","삼십세 이상으로 오십세까지 회막 봉사에 입참하여 일할 만한 모든 자를 계수하라 ");
INSERT INTO kor_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","게르손 가족의 할 일과 멜 것은 이러하니 ");
INSERT INTO kor_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","곧 그들은 성막의 앙장들과, 회막과, 그 덮개와, 그 위의 해달의 가죽 덮개와, 회막 문장을 메이며 ");
INSERT INTO kor_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","뜰의 휘장과, 및 성막과, 단 사면에 있는 뜰의 문장과, 그 줄들과, 그것에 사용하는 모든 기구를 메이며 이 모든 것을 어떻게 맡아 처리할 것이라 ");
INSERT INTO kor_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","게르손 자손은 그 모든 일 곧 멜 것과 처리할 것에 아론과 그 아들들의 명대로 할 것이니 너희는 그들의 멜 짐을 그들에게 맡길 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","게르손 자손의 가족들이 회막에서 할 일이 이러하며 그들의 직무는 제사장 아론의 아들 이다말이 감독할지니라 ");
INSERT INTO kor_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","너는 므라리 자손도 그 가족과 종족을 따라 계수하되 ");
INSERT INTO kor_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","삼십세 이상으로 오십세까지 회막 봉사에 입참하여 일할 만한 모든 자를 계수하라 ");
INSERT INTO kor_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","그들이 직무를 따라 회막에서 할 모든 일 곧 그 멜 것이 이러하니 곧 장막의 널판들과, 그 띠들과, 그 기둥들과, 그 받침들과, ");
INSERT INTO kor_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","뜰 사면 기둥들과, 그 받침들과, 그 말뚝들과, 그 줄들과, 그 모든 기구들과, 무릇 그것에 쓰는 것이라 너희는 그들의 맡아 멜 모든 기구의 명목을 지정하라 ");
INSERT INTO kor_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","이는 제사장 아론의 아들 이다말의 수하에 있을 므라리 자손의 가족들이 그 모든 사무대로 회막에서 행할 일이니라 ");
INSERT INTO kor_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","모세와 아론과 회중의 족장들이 고핫 자손들을 그 가족과 종족대로 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","삼십세 이상으로 오십세까지 회막 봉사에 입참하여 일할 만한 모든 자 ");
INSERT INTO kor_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","곧 그 가족대로 계수함을 입은 자가 이천 칠백 오십이니 ");
INSERT INTO kor_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","이는 모세와 아론이 여호와께서 모세로 명하신 대로 회막에서 종사하는 고핫인의 모든 가족 중 계수한 자니라 ");
INSERT INTO kor_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","게르손 자손의 그 가족과 종족을 따라 계수함을 입은 자는 ");
INSERT INTO kor_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","삼십세 이상으로 오십세까지 회막 봉사에 입참하여 일할 만한 모든 자라 ");
INSERT INTO kor_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","그 가족과 종족을 따라 계수함을 입은 자가 이천 육백 삼십명이니 ");
INSERT INTO kor_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","이는 모세와 아론이 여호와의 명대로 회막에서 종사하는 게르손 자손의 모든 가족 중 계수한 자니라 ");
INSERT INTO kor_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","므라리 자손의 가족 중 그 가족과 종족을 따라 계수함을 입은 자는 ");
INSERT INTO kor_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","삼십세 이상으로 오십세까지 회막 봉사에 입참하여 일할 만한 모든 자라 ");
INSERT INTO kor_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","그 가족을 따라 계수함을 입은 자가 삼천 이백명이니 ");
INSERT INTO kor_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","이는 모세와 아론이 여호와께서 모세로 명하신 대로 므라리 자손들의 가족 중 계수한 자니라 ");
INSERT INTO kor_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","모세와 아론과 이스라엘 족장들이 레위인을 그 가족과 종족대로 다 계수하니 ");
INSERT INTO kor_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","삼십세 이상으로 오십세까지 회막 봉사와 메는 일에 입참하여 일할 만한 모든 자 ");
INSERT INTO kor_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","곧 그 계수함을 입은 자가 팔천 오백 팔십명이라 ");
INSERT INTO kor_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","그들이 그 할 일과 멜일을 따라 모세에게 계수함을 입었으되 여호와께서 모세에게 명하신 대로 그들이 계수함을 입었더라 ");
INSERT INTO kor_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","이스라엘 자손에게 명하여 모든 문둥병 환자와 유출병이 있는 자와 주검으로 부정케 된 자를 다 진 밖으로 내어 보내되 ");
INSERT INTO kor_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","무론 남녀하고 다 진 밖으로 내어 보내어 그들로 진을 더럽히게 말라 내가 그 진 가운데 거하느니라 하시매 ");
INSERT INTO kor_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","이스라엘 자손이 그같이 행하여 그들을 진 밖으로 내어 보내었으니 곧 여호와께서 모세에게 이르신대로 이스라엘 자손이 행하였더라 ");
INSERT INTO kor_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","여호와께서 또 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","이스라엘 자손에게 이르라 남자나 여자나 사람들이 범하는 죄를 범하여 여호와께 패역하여 그 몸에 죄를 얻거든 ");
INSERT INTO kor_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","그 지은 죄를 자복하고 그 죄 값을 온전히 갚되 오분지 일을 더하여 그가 죄를 얻었던 그 본주에게 돌려 줄 것이요 ");
INSERT INTO kor_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","만일 죄 값을 받을 만한 친족이 없거든 그 죄 값을 여호와께 드려 제사장에게로 돌릴 것이니 이는 그를 위하여 속죄할 수양 외에 돌릴 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","이스라엘 자손의 거제로 제사장에게 가져 오는 모든 성물은 그의 것이 될 것이라 ");
INSERT INTO kor_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","각 사람의 구별한 물건은 그의 것이 되나니 누구든지 제사장에게 주는 것은 그의 것이 되느니라 ");
INSERT INTO kor_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","이스라엘 자손에게 고하여 그들에게 이르라 만일 어떤 사람의 아내가 실행하여 남편에게 범죄하여 ");
INSERT INTO kor_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","타인과 정교를 하였으나 그 남편의 눈에 숨겨 드러나지 아니하였고 그 여자의 더러워진 일에 증인도 없고 그가 잡히지 아니하였어도 ");
INSERT INTO kor_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","그 더러워짐을 인하여 남편이 의심이 생겨서 그 아내를 의심하든지 또는 아내가 더럽히지 아니하였어도 그 남편이 의심이 생겨서그 아내를 의심하거든 ");
INSERT INTO kor_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","그 아내를 데리고 제사장에게로 가서 그를 위하여 보리 가루 에바 십분지 일을 예물로 드리되 그것에 기름도 붓지 말고 유향도 두지 말라 이는 의심의 소제요 생각하게 하는 소제니 곧 죄악을 생각하게 하는 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","제사장은 그 여인으로 가까이 오게 하여 여호와 앞에 세우고 ");
INSERT INTO kor_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","토기에 거룩한 물을 담고 성막 바닥의 티끌을 취하여 물에 넣고 ");
INSERT INTO kor_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","여인을 여호와 앞에 세우고 그 머리를 풀게 하고 생각하게 하는 소제물 곧 의심의 소제물을 그 두 손에 두고 제사장은 저주가 되게 할 쓴 물을 자기 손에 들고 ");
INSERT INTO kor_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","여인에게 맹세시켜 그에게 이르기를 네가 네 남편을 두고 실행하여 사람과 동침하여 더럽힌 일이 없으면 저주가 되게 하는 이 쓴물의 해독을 면하리라 ");
INSERT INTO kor_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","그러나 네가 네 남편을 두고 실행하여 더럽혀서 네 남편 아닌 사람과 동침하였으면 ");
INSERT INTO kor_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","제사장이 그 여인으로 저주의 맹세를 하게 하고 그 여인에게 말할지니라 여호와께서 네 넓적다리로 떨어지고 네 배로 부어서 너로 네 백성 중에 저줏거리, 맹셋거리가 되게 하실지라 ");
INSERT INTO kor_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","이 저주가 되게 하는 이 물이 네 창자에 들어 가서 네 배로 붓게하고 네 넓적다리로 떨어지게 하리라 할 것이요 여인은 아멘, 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","제사장이 저주의 말을 두루마리에 써서 그 글자를 그 쓴 물에 빨아 넣고 ");
INSERT INTO kor_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","여인으로 그 저주가 되게 하는 쓴 물을 마시게 할지니 그 저주가 되게 하는 물이 그 속에 들어가서 쓰리라 ");
INSERT INTO kor_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","제사장이 먼저 그 여인의 손에서 의심의 소제물을 취하여 그 소제물을 여호와 앞에 흔들고 가지고 단으로 가서 ");
INSERT INTO kor_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","그 소제물 중에서 기념으로 한 움큼을 취하여 단 위에 소화하고 그 후에 여인에게 그 물을 마시울지라 ");
INSERT INTO kor_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","그 물을 마시운 후에 만일 여인이 몸을 더럽혀서 그 남편에게 범죄하였으면 그 저주가 되게 하는 물이 그의 속에 들어가서 쓰게 되어 그 배가 부으며 그 넓적다리가 떨어지리니 그 여인이 백성 중에서 저줏거리가 될 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","그러나 여인이 더럽힌 일이 없고 정결하면 해를 받지 않고 잉태하리라 ");
INSERT INTO kor_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","이는 의심의 법이니 아내가 그 남편을 두고 실행하여 더럽힌 때나 ");
INSERT INTO kor_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","또는 그 남편이 의심이 생겨서 그 아내를 의심할 때에 그 여인을 여호와 앞에 두고 제사장이 이 법대로 행할 것이라 ");
INSERT INTO kor_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","남편은 무죄할 것이요 여인은 죄가 있으면 당하리라 ");
INSERT INTO kor_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","이스라엘 자손에게 고하여 그들에게 이르라 남자나 여자가 특별한 서원 곧 나실인의 서원을 하고 자기 몸을 구별하여 여호와께 드리거든 ");
INSERT INTO kor_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","포도주와 독주를 멀리하며 포도주의 초나 독주의 초를 마시지 말며 포도즙도 마시지 말며 생포도나 건포도도 먹지 말지니 ");
INSERT INTO kor_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","자기 몸을 구별하는 모든 날 동안에는 포도나무 소산은 씨나 껍질이라도 먹지말지며 ");
INSERT INTO kor_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","그 서원을 하고 구별하는 모든 날 동안은 삭도를 도무지 그 머리에 대지 말 것이라 자기 몸을 구별하여 여호와께 드리는 날이 차기까지 그는 거룩한즉 그 머리털을 길게 자라게 할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","자기 몸을 구별하여 여호와께 드리는 모든 날 동안은 시체를 가까이 하지 말 것이요 ");
INSERT INTO kor_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","그 부모 형제 자매가 죽은 때에라도 그로 인하여 더럽히지 말것이니 이는 자기 몸을 구별하여 하나님께 드리는 표가 그 머리에 있음이라 ");
INSERT INTO kor_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","자기 몸을 구별하는 모든 날 동안 그는 여호와께 거룩한 자니라 ");
INSERT INTO kor_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","누가 홀연히 그 곁에서 죽어서 스스로 구별한 자의 머리를 더럽히거든 그 몸을 정결케 하는 날에 머리를 밀 것이니 곧 제 칠일에 밀 것이며 ");
INSERT INTO kor_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","제 팔일에 산비둘기 두 마리나 집비둘기 새끼 두 마리를 가지고 회막 문에 와서 제사장에게 줄 것이요 ");
INSERT INTO kor_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","제사장은 그 하나를 속죄제물로, 하나를 번제물로 드려서 그의 시체로 인하여 얻은 죄를 속하고 또 그는 당일에 그의 머리를 성결케 할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","자기 몸을 구별하여 여호와께 드릴 날을 새로 정하고 일년 된 수양을 가져다가 속건제로 드릴지니라 자기 몸을 구별한 때에 그 몸을 더렵혔은즉 지나간 날은 무효니라 ");
INSERT INTO kor_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","나실인의 법은 이러하니라 자기 몸을 구별한 날이 차면 그 사람을 회막 문으로 데리고 갈 것이요 ");
INSERT INTO kor_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","그는 여호와께 예물을 드리되 번제물로 일년 된 흠 없는 수양 하나와 속죄제물로 일년 된 흠 없는 어린 암양 하나와 화목제물로 흠 없는 수양 하나와 ");
INSERT INTO kor_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","무교병 한 광주리와 고운 가루에 기름 섞은 과자들과 기름 바른 무교전병들과 그 소제물과 전제물을 드릴 것이요 ");
INSERT INTO kor_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","제사장은 그것들을 여호와 앞에 가져다가 속죄제와 번제를 드리고 ");
INSERT INTO kor_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","화목제물로 수양에 무교병 한 광주리를 아울러 여호와께 드리고 그 소제와 전제를 드릴 것이요 ");
INSERT INTO kor_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","자기 몸을 구별한 나실인은 회막 문에서 그 머리털을 밀고 그것을 화목제물 밑에 있는 불에 둘지며 ");
INSERT INTO kor_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","자기 몸을 구별한 나실인이 그 머리털을 민 후에 제사장이 삶은 수양의 어깨와 광주리 가운데 무교병 하나와 무교전병 하나를 취하여 나실인의 두 손에 두고 ");
INSERT INTO kor_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","여호와 앞에 요제로 흔들 것이며 그것과 흔든 가슴과 든 넓적다리는 성물이라 다 제사장에게 돌릴 것이니라 그 후에는 나실인이 포도주를 마실 수 있느니라 ");
INSERT INTO kor_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","이는 곧 서원한 나실인이 자기 몸을 구별한 일로 인하여 여호와께 예물을 드림과 행할 법이며 이 외에도 힘이 미치는 대로 하려니와 그 서원 한대로 자기 몸을 구별하는 법을 따라 할 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","아론과 그 아들들에게 고하여 이르기를 너희는 이스라엘 자손을 위하여 이렇게 축복하여 이르되 ");
INSERT INTO kor_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","여호와는 네게 복을 주시고 너를 지키시기를 원하며 ");
INSERT INTO kor_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","여호와는 그 얼굴로 네게 비취사 은혜 베푸시기를 원하며 ");
INSERT INTO kor_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","여호와는 그 얼굴을 네게로 향하여 드사 평강주시기를 원하노라 할지니라 하라 ");
INSERT INTO kor_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","그들은 이같이 내 이름으로 이스라엘 자손에게 축복할지니 내가 그들에게 복을 주리라 ");
INSERT INTO kor_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","모세가 장막 세우기를 필하고 그것에 기름을 발라 거룩히 구별하고 또 그 모든 기구와 단과 그 모든 기구에 기름을 발라 거룩히 구별한 날에 ");
INSERT INTO kor_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","이스라엘 족장들 곧 그들의 종족의 두령들이요 그 지파의 족장으로서 그 계수함을 입은 자의 감독된 자들이 예물을 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","그들의 여호와께 드린 예물은 덮개 있는 수레 여섯과 소 열 둘이니 족장 둘에 수레가 하나씩이요 하나에 소가 하나씩이라 그것들을 장막 앞에 드린지라 ");
INSERT INTO kor_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","그것을 그들에게서 받아 레위인에게 주어 각기 직임대로 회막 봉사에 쓰게 할지니라 ");
INSERT INTO kor_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","모세가 수레와 소를 받아 레위인에게 주었으니 ");
INSERT INTO kor_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","곧 게르손 자손들에게는 그 직임대로 수레 둘과, 소 넷을 주었고 ");
INSERT INTO kor_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","므라리 자손들에게는 그 직임대로 수레 넷과, 소 여덟을 주고 제사장 아론의 아들 이다말로 감독케 하였으나 ");
INSERT INTO kor_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","고핫 자손에게는 주지 아니하였으니 그들의 성소의 직임은 그 어깨로 메는 일을 하는 까닭이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","단에 기름을 바르던 날에 족장들이 단의 봉헌을 위하여 예물을 가져다가 그 예물을 단 앞에 드리니라 ");
INSERT INTO kor_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","여호와께서 모세에게 이르시기를 족장들은 하루 한 사람씩 단의 봉헌 예물을 드릴지니라 하셨더라 ");
INSERT INTO kor_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","제 일일에 예물을 드린 자는 유다 지파 암미나답의 아들 나손이라 ");
INSERT INTO kor_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","그 예물은 성소의 세겔대로 일백 삼십 세겔중 은반 하나와 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","또 십 세겔중 금숟가락 하나라 그것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","또 번제물로 수송아지 하나와, 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","화목제물로 소 둘과, 수양 다섯과, 수염소 다섯과, 일년 된 어린 수양 다섯이라 이는 암미나답의 아들 나손의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","제 이일에는 잇사갈의 족장 수알의 아들 느다넬이 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","그 드린 예물도 성소의 세겔대로 일백 삼십 세겔중 은반 하나와, 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","또 십 세겔중 금숟가락 하나라 그것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","또 번제물로 수송아지 하나와, 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","화목제물로 소 둘과, 수양 다섯과 수염소 다섯과, 일년된 어린 수양 다섯이라 이는 수알의 아들 느다넬의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","제 삼일에는 스불론 자손의 족장 헬론의 아들 엘리압이 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","그 예물도 성소의 세겔대로 일백 삼십 세겔중 은반 하나와 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","또 십 세겔중 금숟가락 하나라 이것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","또 번제물로 수송아지 하나와 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","화목제물로 소 둘과, 수양 다섯과, 수염소 다섯과, 일년 된 어린 수양 다섯이라 이는 헬론의 아들 엘리압의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","제 사일에는 르우벤 자손의 족장 스데울의 아들 엘리술이 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","그 예물도 성소의 세겔대로 일백 삼십 세겔중 은반 하나와 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","또 십세겔중 금숟가락 하나라 이것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","또 번제물로 수송아지 하나와 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","화목제물로 소 둘과, 수양 다섯과, 수염소 다섯과, 일년 된 어린 수양 다섯이라 이는 스데울의 아들 엘리술의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","제 오일에는 시므온 자손의 족장 수리삿대의 아들 슬루미엘이 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","그 예물도 성소의 세겔대로 일백 삼십 세겔중 은반 하나와 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","또 십 세겔중 금숟가락 하나라 이것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","또 번제물로 수송아지 하나와 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","화목제물로 소 둘과, 수양 다섯과, 수염소 다섯과, 일년 된 어린 수양 다섯이라 이는 수리삿대의 아들 슬루미엘의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","제 육일에는 갓 자손의 족장 드우엘의 아들 엘리아삽이 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","그 예물도 성소의 세겔대로 일백 삼십 세겔중 은반 하나와 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","또 십 세겔중 금숟가락 하나라 이것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","또 번제물로 수송아지 하나와, 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","화목제물로 소 둘과, 수양 다섯과, 수염소 다섯과, 일년 된 어린 수양 다섯이라 이는 드우엘의 아들 엘리아삽의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","제 칠일에는 에브라임 자손의 족장 암미훗의 아들 엘리사마가 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","그 예물도 성소의 세겔대로 일백 삼십 세겔중 은반 하나와 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","또 십세겔중 금숟가락 하나라 이것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","또 번제물로 수송아지 하나와, 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","화목제물로 소 둘과, 수양 다섯과, 수염소 다섯과, 일년 된 어린 수양 다섯이라 이는 암미훗의 아들 엘리사마의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","제 팔일에는 므낫세 자손의 족장 브다술의 아들 가말리엘이 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","그 예물도 성소의 세겔대로 일백 삼십 세겔중 은반 하나와 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","또 십세겔중 금숟가락 하나라 이것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","또 번제물로 수송아지 하나와 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","화목제물로 소 둘과, 수양 다섯과, 수염소 다섯과, 일년 된 어린 수양 다섯이라 이는 브다술의 아들 가말리엘의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","제 구일에는 베냐민 자손의 족장 기드오니의 아들 아비단이 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","그 예물도 성소의 세겔대로 일백 삼십 세겔중 은반 하나와 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","또 십세겔중 금숟가락 하나라 이것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","또 번제물로 수송아지 하나와 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","화목제물로 소 둘과, 수양 다섯과, 수염소 다섯과, 일년 된 어린 수양 다섯이라 이는 기드오니의 아들 아비단의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","제 십일에는 단 자손의 족장 암미삿대의 아들 아히에셀이 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","그 예물도 성소의 세겔대로 일백 삼십 세겔중 은반 하나와 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","또 십세겔중 금숟가락 하나라 이것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","또 번제물로 수송아지 하나와, 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","화목제물로 소 둘과, 수양 다섯과, 수염소 다섯과, 일년 된 어린 수양 다섯이라 이는 암미삿대의 아들 아히에셀의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","제 십일일에는 아셀 자손의 족장 오그란의 아들 바기엘이 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","그 예물도 성소의 세겔대로 일백 삼십 세겔중 은반 하나와 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","또 십세겔중 금숟가락 하나라 이것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","또 번제물로 수송아지 하나와, 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","화목제물로 소 둘과, 수양 다섯과, 수염소 다섯과, 일년 된 어린 수양 다섯이라 이는 오그란의 아들 바기엘의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","제 십이일에는 납달리 자손의 족장 에난의 아들 아히라가 드렸으니 ");
INSERT INTO kor_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","그 예물도 성소의 세겔대로 일백 삼십 세겔중 은반 하나와 칠십 세겔중 은바리 하나라 이 두 그릇에는 소제물로 기름 섞은 고운 가루를 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","또 십세겔중 금숟가락 하나라 이것에는 향을 채웠고 ");
INSERT INTO kor_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","또 번제물로 수송아지 하나와, 수양 하나와, 일년 된 어린 수양 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","속죄제물로 수염소 하나이며 ");
INSERT INTO kor_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","화목제물로 소 둘과, 수양 다섯과, 수염소 다섯과, 일년 된 어린 수양 다섯이라 이는 에난의 아들 아히라의 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","이는 곧 단에 기름 바르던 날에 이스라엘 족장들이 드린 바 단의 봉헌 예물이라 은반이 열 둘이요. 은바리가 열 둘이요. 금숟가락이 열둘이니 ");
INSERT INTO kor_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","은반은 각각 일백 삼십 세겔중이요, 은바리는 각각 칠십 세겔중이라 성소의 세겔대로 모든 기명의 은이 도합이 이천 사백 세겔이요, ");
INSERT INTO kor_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","또 향을 채운 금숟가락이 열 둘이니, 성소의 세겔대로 각각 십 세겔중이라 그 숟가락의 금이 도합이 일백 이십 세겔이요 ");
INSERT INTO kor_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","또 번제물로 수송아지가 열 둘이요, 수양이 열 둘이요, 일년 된 어린 수양이 열 둘이요, 그 소제물이며 속죄제물로 수염소가 열 둘이며 ");
INSERT INTO kor_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","화목제물로 수소가 이십 사요, 수양이 육십이요, 수염소가 육십이요, 일년 된 어린 수양이 육십이라, 이는 단에 기름 바른 후에 드린바 단의 봉헌 예물이었더라 ");
INSERT INTO kor_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","모세가 회막에 들어가서 여호와께 말씀하려 할 때에 증거궤 위 속죄소 위의 두 그룹 사이에서 자기에게 말씀하시는 목소리를 들었으니 여호와께서 그에게 말씀하심이었더라 ");
INSERT INTO kor_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","여호와께서 또 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","아론에게 고하여 이르라 등을 켤 때에는 일곱 등잔을 등대 앞으로 비취게 할지니라 하시매 ");
INSERT INTO kor_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","아론이 그리하여 등불을 등대 앞으로 비취도록 켰으니 여호와께서 모세에게 명하심과 같았더라 ");
INSERT INTO kor_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","이 등대의 제도는 이러하니 곧 금을 쳐서 만든 것인데 밑판에서 그 꽃까지 쳐서 만든 것이라 모세가 여호와께서 자기에게 보이신 식양을 따라 이 등대를 만들었더라 ");
INSERT INTO kor_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","이스라엘 자손 중에서 레위인을 취하여 정결케 하라 ");
INSERT INTO kor_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","너는 이같이 하여 그들을 정결케 하되 곧 속죄의 물로 그들에게 뿌리고 그들로 그 전신을 삭도로 밀게 하고 그 의복을 빨게 하여 몸을 정결케 하고 ");
INSERT INTO kor_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","또 그들로 수송아지 하나를 번제물로, 기름 섞은 고운 가루를 그 소제물로 취하게 하고 그 외에 너는 또 수송아지 하나를 속죄물로 취하고 ");
INSERT INTO kor_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","레위인을 회막 앞에 나오게 하고 이스라엘 자손의 온 회중을 모으고 ");
INSERT INTO kor_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","레위인을 여호와 앞에 나오게 하고 이스라엘 자손으로 그들에게 안수케 한 후에 ");
INSERT INTO kor_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","아론이 이스라엘 자손을 위하여 레위인을 요제로 여호와 앞에 드릴지니 이는 그들로 여호와를 봉사케 하기 위함이라 ");
INSERT INTO kor_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","레위인으로 수송아지들의 머리를 안수케 하고 네가 그 하나는 속죄제물로 하나는 번제물로 여호와께 드려 레위인을 속죄하고 ");
INSERT INTO kor_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","레위인을 아론과 그 아들들 앞에 세워 여호와께 요제로 드릴지니라 ");
INSERT INTO kor_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","너는 이같이 이스라엘 자손 중에서 레위인을 구별하라 그리하면 그들이 내게 속할 것이라 ");
INSERT INTO kor_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","네가 그들을 정결케 하여 요제로 드린 후에 그들이 회막에 들어가서 봉사할 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","그들은 이스라엘 자손 중에서 내게 온전히 드린바 된 자라 이스라엘 자손 중 일절 초태생 곧 모든 처음 난 자의 대신으로 내가 그들을 취하였나니 ");
INSERT INTO kor_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","이스라엘 자손 중에 처음 난 것은 사람이든지 짐승이든지 다 내게 속하였음은 내가 애굽 땅에서 그 모든 처음 난 자를 치던 날 에 내가 그들을 내게 구별하였음이라 ");
INSERT INTO kor_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","이러므로 내가 이스라엘 자손 중 모든 처음 난 자의 대신으로 레위인을 취하였느니라 ");
INSERT INTO kor_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","내가 이스라엘 자손 중에서 레위인을 취하여 그들을 아론과 그 아들들에게 선물로 주어서 그들로 회막에서 이스라엘 자손을 대신하여 봉사하게 하며 또 이스라엘 자손을 위하여 속죄하게 하였나니 이는 이스라엘 자손이 성소에 가까이 할 때에 그들 중에 재앙이 없게 하려하였음이니라 ");
INSERT INTO kor_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","모세와 아론과 이스라엘 자손의 온 회중이 여호와께서 레위인에게 대하여 모세에게 명하신 것을 다 좇아 레위인에게 행하였으되 곧 이스라엘 자손이 그와 같이 그들에게 행하였더라 ");
INSERT INTO kor_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","레위인이 이에 죄에서 스스로 깨끗케 하고 그 옷을 빨매 아론이 그들을 여호와 앞에 요제로 드리고 그가 또 그들을 위하여 속죄 하여 정결케 한 ");
INSERT INTO kor_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","후에 레위인이 회막에 들어가서 아론과 그 아들들의 앞에서 봉사하니라 여호와께서 레위인의 일에 대하여 모세에게 명하신 것을 좇아 그와 같이 그들에게 행하였더라 ");
INSERT INTO kor_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","여호와께서 또 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","레위인은 이같이 할지니 곧 이십 오세 이상으로는 회막에 들어와서 봉사하여 일할 것이요 ");
INSERT INTO kor_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","오십세부터는 그 일을 쉬어 봉사하지 아니할 것이나 ");
INSERT INTO kor_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","그 형제와 함께 회막에서 모시는 직무를 지킬 것이요 일하지 아니할 것이라 너는 레위인의 직무에 대하여 이같이 할지니라 ");
INSERT INTO kor_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","애굽 땅에서 나온 다음 해 정월에 여호와께서 시내 광야에서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","이스라엘 자손으로 유월절을 그 정기에 지키게 하라 ");
INSERT INTO kor_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","그 정기 곧 이달 십 사일 해질 때에 너희는 그것을 지키되 그 모든 율례와 그 모든 규례대로 지킬지니라 ! ");
INSERT INTO kor_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","모세가 이스라엘 자손에게 명하여 유월절을 지키라 ! 하매 ");
INSERT INTO kor_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","그들이 정월 십사일 해 질 때에 시내 광야에서 유월절을 지켰으되 이스라엘 자손이 여호와께서 모세에게 명하신 것을 다 좇아 행하였더라 ");
INSERT INTO kor_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","때에 사람의 시체로 인하여 부정케 되어서 유월절을 지킬 수 없는 사람들이 있었는데 그들이 당일에 모세와 아론 앞에 이르러 ");
INSERT INTO kor_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","그에게 이르되 `우리가 사람의 시체로 인하여 부정케 되었거니와 우리를 금지하여 이스라엘 자손과 함께 정기에 여호와께 예물을 드리지 못하게 하심은 어찜이니이까 ?' ");
INSERT INTO kor_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","모세가 그들에게 이르되 `기다리라 여호와께서 너희에게 대하여 어떻게 명하시는지 내가 들으리라' ");
INSERT INTO kor_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","이스라엘 자손에게 일러 고하여 이르라 너희나 너희 후손 중에 시체로 인하여 부정케 되든지 먼 여행 중에 있든지 할지라도 다 여호와 앞에 마땅히 유월절을 지키되 ");
INSERT INTO kor_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","이월 십사일 해 질 때에 그것을 지켜서 어린 양에 무교병과 쓴 나물을 아울러 먹을 것이요 ");
INSERT INTO kor_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","아침까지 그것을 조금도 남겨 두지 말며 그 뼈를 하나도 꺽지 말아서 유월절 모든 율례대로 지킬 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","그러나 사람이 정결도 하고 여행 중에도 있지 아니하면서 유월절을 지키지 아니하는 자는 그 백성중에서 끊쳐지리니 이런 사람은그 정기에 여호와께 예물을 드리지 아니하였은즉 그 죄를 당할지며 ");
INSERT INTO kor_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","만일 타국인이 너희 중에 우거하여 여호와 앞에 유월절을 지키고자 하면 유월절 율례대로 그 규례를 따라서 행할지니 우거한 자에게나 본토인에게나 그 율례는 동일할 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","성막을 세운 날에 구름이 성막 곧 증거막을 덮었고 저녁이 되면 성막 위에 불 모양 같은 것이 나타나서 아침까지 이르렀으되 ");
INSERT INTO kor_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","항상 그러하여 낮에는 구름이 그것을 덮었고 밤에는 불 모양이 있었는데 ");
INSERT INTO kor_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","구름이 성막에서 떠오르는 때에는 이스라엘 자손이 곧 진행하였고 구름이 머무는 곳에 이스라엘 자손이 진을 쳤으니 ");
INSERT INTO kor_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","이스라엘 자손이 여호와의 명을 좇아 진행하였고 여호와의 명을 좇아 진을 쳤으며 구름이 성막 위에 머무는 동안에는 그들이 유진하였고 ");
INSERT INTO kor_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","구름이 장막 위에 머무는 날이 오랠 때에는 이스라엘 자손이 여호와의 명을 지켜 진행치 아니하였으며 ");
INSERT INTO kor_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","혹시 구름이 장막 위에 머무는 날이 적을 때에도 그들이 다만 여호와의 명을 좇아 유진하고 여호와의 명을 좇아 진행하였으며 ");
INSERT INTO kor_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","혹시 구름이 저녁부터 아침까지 있다가 아침에 그 구름이 떠오를때에는 그들이 진행하였고 구름이 밤낮 있다가 떠 오르면 곧 진행하였으며 ");
INSERT INTO kor_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","이틀이든지, 한달이든지, 일년이든지, 구름이 성막 위에 머물러 있을 동안에는 이스라엘 자손이 유진하고 진행치 아니하다가 떠오르면 진행하였으니 ");
INSERT INTO kor_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","곧 그들이 여호와의 명을 좇아 진을 치며 여호와의 명을 좇아 진행하고 또 모세로 전하신 여호와의 명을 따라 여호와의 직임을 지켰더라 ");
INSERT INTO kor_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","은나팔 둘을 만들되 쳐서 만들어서 그것으로 회중을 소집하며 진을 진행케 할 것이라 ");
INSERT INTO kor_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","두 나팔을 불 때에는 온 회중이 회막 문 앞에 모여서 네게로 나아올 것이요 ");
INSERT INTO kor_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","하나만 불 때에는 이스라엘 천부장된 족장들이 모여서 네게로 나아올 것이며 ");
INSERT INTO kor_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","너희가 그것을 울려 불 때에는 동편 진들이 진행할 것이고 ");
INSERT INTO kor_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","제 이차로 울려 불 때에는 남편 진들이 진행할 것이라 무릇 진행하려 할 때에는 나팔 소리를 울려 불 것이며 ");
INSERT INTO kor_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","또 회중을 모을 때에도 나팔을 불 것이나 소리를 울려 불지 말것이며 ");
INSERT INTO kor_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","그 나팔은 아론의 자손인 제사장들이 불지니 이는 너희 대대에 영원한 율례니라 ");
INSERT INTO kor_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","또 너희 땅에서 너희가 자기를 압박하는 대적을 치러 나갈 때에는 나팔을 울려 불지니 그리하면 너희 하나님 여호와가 너희를 기억하고 너희를 너희 대적에게서 구원하리라 ");
INSERT INTO kor_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","또 너희 희락의 날과 너희 정한 절기와 월삭에는 번제물의 위에와 화목제물의 위에 나팔을 불라 그로 말미암아 너희 하나님이 너희를 기억하리라 나는 너희 하나님 여호와니라 ! ");
INSERT INTO kor_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","제 이년 이월 이십일에 구름이 증거막에서 떠오르매 ");
INSERT INTO kor_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","이스라엘 자손이 시내 광야에서 출발하여 자기 길을 행하더니 바란 광야에 구름이 머무니라 ");
INSERT INTO kor_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","이와 같이 그들이 여호와께서 모세로 명하신 것을 좇아 진행하기를 시작하였는데 ");
INSERT INTO kor_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","수두로 유다 자손 진기에 속한 자들이 그 군대대로 진행하였으니 유다 군대는 암미나답의 아들 나손이 영솔하였고 ");
INSERT INTO kor_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","잇사갈 자손 지파의 군대는 수알의 아들 느다넬이 영솔하였고 ");
INSERT INTO kor_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","스불론 자손 지파의 군대는 헬론의 아들 엘리압이 영솔하였더라 ");
INSERT INTO kor_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","이에 성막을 걷으매 게르손 자손과 므라리 자손이 성막을 메고 발행하였으며 ");
INSERT INTO kor_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","다음으로 르우벤 진기에 속한 자들이 그 군대대로 발행하였으니 르우벤의 군대는 스데울의 아들 엘리술이 영솔하였고 ");
INSERT INTO kor_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","시므온 자손 지파의 군대는 수리삿대의 아들 슬루미엘이 영솔하였고 ");
INSERT INTO kor_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","갓 자손 지파의 군대는 드우엘의 아들 엘리아삽이 영솔하였더라 ");
INSERT INTO kor_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","고핫인은 성물을 메고 진행하였고 그들이 이르기 전에 성막을 세웠으며 ");
INSERT INTO kor_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","다음으로 에브라임 자손 진기에 속한 자들이 그 군대대로 진행하였으니 에브라임 군대는 암미훗의 아들 엘리사마가 영솔하였고 ");
INSERT INTO kor_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","므낫세 자손 지파의 군대는 브다술의 아들 가말리엘이 영솔하였고 ");
INSERT INTO kor_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","베냐민 자손 지파의 군대는 기드오니의 아들 아비단이 영솔하였더라 ");
INSERT INTO kor_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","다음으로 단 자손 진기에 속한 자들이 그 군대대로 진행하였으니 이 군대는 모든 진의 후진이었더라 단 군대는 암미삿대의 아들 아히에셀이 영솔하였고 ");
INSERT INTO kor_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","아셀 자손 지파의 군대는 오그란의 아들 바기엘이 영솔하였고 ");
INSERT INTO kor_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","납달리 자손 지파의 군대는 에난의 아들 아히라가 영솔하였더라 ");
INSERT INTO kor_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","모세가 가로되 `청컨대 우리를 떠나지 마소서 당신은 우리가 광야에서 어떻게 진 칠 것을 아나니 우리의 눈이 되리이다 ");
INSERT INTO kor_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","우리와 동행하면 여호와께서 우리에게 복을 내리시는 대로 우리도 당신에게 행하리이다' ");
INSERT INTO kor_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","그들이 여호와의 산에서 떠나 삼일 길을 행할 때에 여호와의 언약궤가 그 삼일 길에 앞서 행하며 그들의 쉴 곳을 찾았고 ");
INSERT INTO kor_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","그들이 여호와의 산에서 떠나 삼일 길을 행할 때에 여호와의 언약궤가 그 삼일 길에 앞서 행하며 그들의 쉴 곳을 찾았고 ");
INSERT INTO kor_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","그들이 행진할때에 낮에는 여호와의 구름이 그 위에 덮였었더라 ");
INSERT INTO kor_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","궤가 떠날 때에는 모세가 가로되 `여호와여 ! 일어나사 주의 대적들을 흩으시고 주를 미워하는 자로 주의 앞에서 도망하게 하소서 !'하였고 ");
INSERT INTO kor_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","궤가 쉴 때에는 가로되 `여호와여 ! 이스라엘 천만인에게로 돌아오소서 !' 하였더라 ");
INSERT INTO kor_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","백성이 여호와의 들으시기에 악한 말로 원망하매 여호와께서 들으시고 진노하사 여호와의 불로 그들 중에 붙어서 진 끝을 사르게 하시매 ");
INSERT INTO kor_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","백성이 모세에게 부르짖으므로 모세가 여호와께 기도하니 불이 꺼졌더라 ");
INSERT INTO kor_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","그곳 이름을 다베라라 칭하였으니 이는 여호와의 불이 그들 중에 붙은 연고였더라 ");
INSERT INTO kor_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","이스라엘 중에 섞어 사는 무리가 탐욕을 품으매 이스라엘 자손도 다시 울며 가로되 '누가 우리에게 고기를 주어 먹게 할꼬 ? ");
INSERT INTO kor_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","우리가 애굽에 있을 때에는 값 없이 생선과 외와 수박과 부추와 파와 마늘들을 먹은 것이 생각나거늘 ");
INSERT INTO kor_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","이제는 우리 정력이 쇠약하되 이 만나 외에는 보이는 것이 아무 것도 없도다' 하니 ");
INSERT INTO kor_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","만나는 깟씨와 같고 모양은 진주와 같은 것이라 ");
INSERT INTO kor_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","백성이 두루 다니며 그것을 거두어 맷돌에 갈기도 하며 절구에 찧기도 하고 가마에 삶기도 하여 과자를 만들었으니 그 맛이 기름 섞은 과자맛 같았더라 ");
INSERT INTO kor_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","밤에 이슬이 진에 내릴 때에 만나도 같이 내렸더라 ");
INSERT INTO kor_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","백성의 온 가족들이 각기 장막 문에서 우는 것을 모세가 들으니라 이러므로 여호와의 진노가 심히 크고 모세도 기뻐하지 아니하여 ");
INSERT INTO kor_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","여호와께 여짜오되 `주께서 어찌하여 종을 괴롭게 하시나이까 ? 어찌하여 나로 주의 목전에 은혜를 입게 아니하시고 이 모든 백성을 내게 맡기사 나로 그 짐을 지게 하시나이까 ? ");
INSERT INTO kor_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","이 모든 백성을 내가 잉태하였나이까 ? 내가 어찌 그들을 생산하였기에 주께서 나더러 양육하는 아비가 젖 먹는 아이를 품듯 그들을 품에 품고 주께서 그들의 열조에게 맹세하신 땅으로 가라 하시나이까 ? ");
INSERT INTO kor_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","이 모든 백성에게 줄 고기를 내가 어디서 얻으리이까 ? 그들이 나를 향하여 울며 가로되 우리에게 고기를 주어 먹게 하라 하온즉 ");
INSERT INTO kor_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","책임이 심히 중하여 나 혼자는 이 모든 백성을 질 수 없나이다 ");
INSERT INTO kor_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","주께서 내게 이같이 행하실진대 구하옵나니 내게 은혜를 베푸사 즉시 나를 죽여 나로 나의 곤고함을 보지 않게 하옵소서' ");
INSERT INTO kor_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","여호와께서 모세에게 이르시되 이스라엘 노인 중 백성의 장로와 유사되는 줄을 네가 아는 자 칠십인을 모아 데리고 회막 내 앞에 이르러 거기서 너와 함께 서게 하라 ");
INSERT INTO kor_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","내가 강림하여 거기서 너와 말하고 네게 임한 신을 그들에게도 임하게 하리니 그들이 너와 함께 백성의 짐을 담당하고 너 혼자 지지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","또 백성에게 이르기를 너희 몸을 거룩히 하여 내일 고기 먹기를 기다리라 너희가 울며 이르기를 누가 우리에게 고기를 주어 먹게할꼬 애굽에 있을 때가 우리에게 재미 있었다 하는 말이 여호와께 들렸으므로 여호와께서 너희에게 고기를 주어 먹게 하실 것이라 ");
INSERT INTO kor_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","하루나 이틀이나 닷새나 열흘이나 이십일만 먹을 뿐 아니라 ");
INSERT INTO kor_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","코에서 넘쳐서 싫어하기까지 일개월간을 먹게 하시리니 이는 너희가 너희 중에 거하시는 여호와를 멸시하고 그 앞에서 울며 이르기를 우리가 어찌하여 애굽에서 나왔던고 함이라 하라 ");
INSERT INTO kor_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","모세가 가로되 `나와 함께 있는 이 백성의 보행자가 육십 만명이온데 주의 말씀이 일개월간 고기를 주어 먹게 하겠다 하시오니 ");
INSERT INTO kor_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","그들을 위하여 양떼와 소떼를 잡은들 족하오며 바다의 모든 고기를 모은들 족하오리이까 ?' ");
INSERT INTO kor_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","여호와께서 모세에게 이르시되 여호와의 손이 짧아졌느냐 ? 네가 이제 내 말이 네게 응하는 여부를 보리라 ");
INSERT INTO kor_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","모세가 나가서 여호와의 말씀을 백성에게 고하고 백성의 장로 칠십인을 모아 장막에 둘러 세우매 ");
INSERT INTO kor_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","여호와께서 구름 가운데 강림하사 모세에게 말씀하시고 그에게 임한 신을 칠십 장로에게도 임하게 하시니 신이 임하신 때에 그들이 예언을 하다가 다시는 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","그 녹명된 자 중 엘닷이라 하는 자와 메닷이라 하는 자 두 사람이 진에 머물고 회막에 나아가지 아니하였으나 그들에게도 신이 임하였으므로 진에서 예언한지라 ");
INSERT INTO kor_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","한 소년이 달려와서 모세에게 고하여 가로되 `엘닷과 메닷이 진 중에서 예언하더이다' 하매 ");
INSERT INTO kor_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","택한 자 중 한 사람 곧 모세를 섬기는 눈의 아들 여호수아가 말하여 가로되 '내 주 모세여 금하소서' ");
INSERT INTO kor_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","모세가 그에게 이르되 `네가 나를 위하여 시기하느냐 ? 여호와께서 그 신을 그 모든 백성에게 주사 다 선지자 되게 하시기를 원하노라' ");
INSERT INTO kor_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","모세와 이스라엘 장로들이 진중으로 돌아왔더라 ");
INSERT INTO kor_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","바람이 여호와에게로서 나와 바다에서부터 메추라기를 몰아 진곁 이편, 저편 곧 진 사방으로 각기 하룻길 되는 지면 위 두 규빗쯤에 내리게 한지라 ");
INSERT INTO kor_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","백성이 일어나 종일 종야와 그 이튿날 종일토록 메추라기를 모으니 적게 모은 자도 십 호멜이라 그들이 자기를 위하여 진 사면에 펴 두었더라 ");
INSERT INTO kor_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","고기가 아직 잇사이에 있어 씹히기 전에 여호와께서 백성에게 대하여 진노하사 심히 큰 재앙으로 치셨으므로 ");
INSERT INTO kor_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","그곳 이름을 기브롯 핫다아와라 칭하였으니 탐욕을 낸 백성을 거기 장사함이었더라 ");
INSERT INTO kor_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","백성이 기브롯 핫다아와에서 진행하여 하세롯에 이르러 거기 거하니라 ");
INSERT INTO kor_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","모세가 구스 여자를 취하였더니 그 구스 여자를 취하였으므로 미리암과 아론이 모세를 비방하니라 ");
INSERT INTO kor_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","그들이 이르되 `여호와께서 모세와만 말씀하셨느냐 ? 우리와도 말씀하지 아니하셨느냐 ?' 하매 여호와께서 이 말을 들으셨더라 ");
INSERT INTO kor_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","이 사람 모세는 온유함이 지면의 모든 사람보다 승하더라 ");
INSERT INTO kor_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","여호와께서 갑자기 모세와 아론과 미리암에게 이르시되 너희 삼인은 회막으로 나아오라 하시니 그 삼인이 나아가매 ");
INSERT INTO kor_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","여호와께서 구름 기둥 가운데로서 강림하사 장막 문에 서시고 아론과 미리암을 부르시는지라 그 두 사람이 나아가매 ");
INSERT INTO kor_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","이르시되 내 말을 들으라 너희 중에 선지자가 있으면 나 여호와가 이상으로 나를 그에게 알리기도 하고 꿈으로 그와 말하기도 하거니와 ");
INSERT INTO kor_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","내 종 모세와는 그렇지 아니하니 그는 나의 온 집에 충성됨이라 ");
INSERT INTO kor_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","그와는 내가 대면하여 명백히 말하고 은밀한 말로 아니하며 그는 또 여호와의 형상을 보겠거늘 너희가 어찌하여 내 종 모세 비방하기를 두려워 아니하느냐 ? ");
INSERT INTO kor_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","여호와께서 그들을 향하여 진노하시고 떠나시매 ");
INSERT INTO kor_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","구름이 장막 위에서 떠나갔고 미리암은 문둥병이 들려 눈과 같더라 아론이 미리암을 본즉 문둥병이 들었는지라 ");
INSERT INTO kor_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","아론이 이에 모세에게 이르되 `슬프다, 내 주여 ! 우리가 우매한 일을 하여 죄를 얻었으나 청컨대 그 허물을 우리에게 돌리지 마소서 ");
INSERT INTO kor_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","그로 살이 반이나 썩고 죽어서 모태에서 나온 자 같이 되게 마옵소서 !' ");
INSERT INTO kor_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","모세가 여호와께 부르짖어 가로되 `하나님이여 ! 원컨대 그를 고쳐 주옵소서 !' ");
INSERT INTO kor_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","여호와께서 모세에게 이르시되 그의 아비가 그의 얼굴에 침을 뱉았을 지라도 그가 칠일간 부끄러워 하지 않겠느냐 ? 그런즉 그를 진 밖에 칠일을 가두고 그 후에 들어오게 할지니라 하시니 ");
INSERT INTO kor_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","이에 미리암이 진 밖에 칠일동안 갇혔고 백성은 그를 다시 들어 오게 하기까지 진행치 아니하다가 ");
INSERT INTO kor_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","그 후에 백성이 하세롯에서 진행하여 바란 광야에 진을 치니라 ");
INSERT INTO kor_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","사람을 보내어 내가 이스라엘 자손에게 주는 가나안 땅을 탐지하게 하되 그 종족의 각 지파 중에서 족장 된 자 한 사람씩 보내라 ");
INSERT INTO kor_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","모세가 여호와의 명을 좇아 바란 광야에서 그들을 보내었으니 그들은 다 이스라엘 자손의 두령된 사람이라 ");
INSERT INTO kor_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","그들의 이름은 이러하니라 르우벤 지파에서는 삭굴의 아들 삼무아요 ");
INSERT INTO kor_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","시므온 지파에서는 호리의 아들 사밧이요 ");
INSERT INTO kor_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","유다 지파에서는 여분네의 아들 갈렙이요 ");
INSERT INTO kor_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","잇사갈 지파에서는 요셉의 아들 이갈이요 ");
INSERT INTO kor_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","에브라임 지파에서는 눈의 아들 호세아요 ");
INSERT INTO kor_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","베냐민 지파에서는 라부의 아들 발디요 ");
INSERT INTO kor_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","스불론 지파에서는 소디의 아들 갓디엘이요 ");
INSERT INTO kor_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","요셉 지파 곧 므낫세 지파에서는 수시의 아들 갓디요 ");
INSERT INTO kor_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","단 지파에서는 그말리의 아들 암미엘이요 ");
INSERT INTO kor_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","아셀 지파에서는 미가엘의 아들 스둘이요 ");
INSERT INTO kor_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","납달리 지파에서는 웝시의 아들 나비요 ");
INSERT INTO kor_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","갓 지파에서는 마기의 아들 그우엘이니 ");
INSERT INTO kor_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","이는 모세가 땅을 탐지하러 보낸 자들의 이름이라 모세가 눈의 아들 호세아를 여호수아라 칭하였더라 ");
INSERT INTO kor_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","모세가 가나안 땅을 탐지하러 그들을 보내며 이르되 `너희는 남방길로 행하여 산지로 올라가서 ");
INSERT INTO kor_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","그 땅의 어떠함을 탐지하라 곧 그 땅 거민의 강약과 다소와 ");
INSERT INTO kor_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","그들의 거하는 땅의 호불호와 거하는 성읍이 진영인지 산성인지와 ");
INSERT INTO kor_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","토지의 후박과 수목의 유무니라 담대하라 또 그 땅 실과를 가져오라' 하니 그 때는 포도가 처음 익을 즈음이었더라 ");
INSERT INTO kor_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","이에 그들이 올라 가서 땅을 탐지하되 신 광야에서부터 하맛 어귀 르홉에 이르렀고 ");
INSERT INTO kor_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","또 남방으로 올라가서 헤브론에 이르렀으니 헤브론은 애굽 소안보다 칠년 전에 세운 곳이라 그 곳에 아낙 자손 아히만과 세새와 달매가 있었더라 ");
INSERT INTO kor_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","또 에스골 골짜기에 이르러 거기서 포도 한 송이 달린 가지를 베어 둘이 막대기에 꿰어 메고 또 석류와 무화과를 취하니라 ");
INSERT INTO kor_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","이스라엘 자손이 거기서 포도송이를 벤 고로 그 곳을 에스골 골짜기라 칭하였더라 ");
INSERT INTO kor_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","사십일 동안에 땅을 탐지하기를 마치고 돌아와 ");
INSERT INTO kor_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","바란 광야 가데스에 이르러 모세와 아론과 이스라엘 자손의 온 회중에게 나아와 그들에게 회보하고 그 땅 실과를 보이고 ");
INSERT INTO kor_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","모세에게 보고하여 가로되 `당신이 우리를 보낸 땅에 간즉 과연 젖과 꿀이 그 땅에 흐르고 이것은 그 땅의 실과니이다 ");
INSERT INTO kor_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","그러나 그 땅 거민은 강하고 성읍은 견고하고 심히 클 뿐 아니라 거기서 아낙 자손을 보았으며 ");
INSERT INTO kor_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","아말렉인은 남방 땅에 거하고 헷인과, 여부스인과, 아모리인은 산지에 거하고 가나안인은 해변과 요단 가에 거하더이다' ");
INSERT INTO kor_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","갈렙이 모세 앞에서 백성을 안돈시켜 가로되 `우리가 곧 올라가서 그 땅을 취하자 능히 이기리라' 하나 ");
INSERT INTO kor_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","그와 함께 올라갔던 사람들은 가로되 `우리는 능히 올라가서 그 백성을 치지 못하리라 그들은 우리보다 강하니라' 하고 ");
INSERT INTO kor_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","이스라엘 자손 앞에서 그 탐지한 땅을 악평하여 가로되 `우리가 두루 다니며 탐지한 땅은 그 거민을 삼키는 땅이요 거기서 본 모든 백성은 신장이 장대한 자들이며 ");
INSERT INTO kor_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","거기서 또 네피림 후손 아낙 자손 대장부들을 보았나니 우리는 스스로 보기에도 메뚜기 같으니 그들의 보기에도 그와 같았을 것이니라' ");
INSERT INTO kor_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","온 회중이 소리를 높여 부르짖으며 밤새도록 백성이 곡하였더라 ");
INSERT INTO kor_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","이스라엘 자손이 다 모세와 아론을 원망하며 온 회중이 그들에게 이르되 `우리가 애굽 땅에서 죽었거나 이 광야에서 죽었더면 좋았을 것을 ");
INSERT INTO kor_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","어찌하여 여호와가 우리를 그 땅으로 인도하여 칼에 망하게 하려하는고 우리 처자가 사로 잡히리니 애굽으로 돌아가는 것이 낫지 아니하랴' ");
INSERT INTO kor_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","이에 서로 말하되 `우리가 한 장관을 세우고 애굽으로 돌아가자' 하매 ");
INSERT INTO kor_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","모세와 아론이 이스라엘 자손의 온 회중 앞에서 엎드린지라 ");
INSERT INTO kor_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","그 땅을 탐지한 자 중 눈의 아들 여호수아와 여분네의 아들 갈렙이 그 옷을 찢고 ");
INSERT INTO kor_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","이스라엘 자손의 온 회중에 일러 가로되 `우리가 두루 다니며 탐지한 땅은 심히 아름다운 땅이라 ");
INSERT INTO kor_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","여호와께서 우리를 기뻐하시면 우리를 그 땅으로 인도하여 들이시고 그 땅을 우리에게 주시리라 이는 과연 젖과 꿀이 흐르는 땅이니라 ");
INSERT INTO kor_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","오직 여호와를 거역하지 말라 ! 또 그 땅 백성을 두려워하지 말라 ! 그들은 우리 밥이라 ! 그들의 보호자는 그들에게서 떠났고 여호와는 우리와 함께 하시느니라 ! 그들을 두려워 말라 !' 하나 ");
INSERT INTO kor_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","온 회중이 그들을 돌로 치려하는 동시에 여호와의 영광이 회막에서 이스라엘 모든 자손에게 나타나시니라 ");
INSERT INTO kor_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","여호와께서 모세에게 이르시되 이 백성이 어느 때까지 나를 멸시하겠느냐 ? 내가 그들 중에 모든 이적을 행한 것도 생각하지 아니하고 어느 때까지 나를 믿지 않겠느냐 ? ");
INSERT INTO kor_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","내가 전염병으로 그들을 쳐서 멸하고 너로 그들보다 크고 강한 나라를 이루게 하리라 ");
INSERT INTO kor_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","모세가 여호와께 여짜오되 `애굽인 중에서 주의 능력으로 이 백성을 인도하여 내셨거늘 그리하시면 그들이 듣고 ");
INSERT INTO kor_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","이 땅 거민에게 고하리이다 주 여호와께서 이 백성 중에 계심을 그들도 들었으니 곧 주 여호와께서 대면하여 보이시며 주의 구름이 그들 위에 섰으며 주께서 낮에는 구름기둥 가운데서 밤에는 불기둥 가운데서 그들 앞에서 행하시는 것이니이다 ");
INSERT INTO kor_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","이제 주께서 이 백성을 한 사람 같이 죽이시면 주의 명성을 들은 열국이 말하여 이르기를 ");
INSERT INTO kor_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","여호와가 이 백성에게 주기로 맹세한 땅에 인도할 능이 없는고로 광야에서 죽였다 하리이다 ");
INSERT INTO kor_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","이제 구하옵나니 이미 말씀하신 대로 주의 큰 권능을 나타내옵소서 이르시기를 ");
INSERT INTO kor_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","여호와는 노하기를 더디하고 인자가 많아 죄악과 과실을 사하나 형벌 받을 자는 결단코 사하지 아니하고 아비의 죄악을 자식에게 갚아 삼사대까지 이르게 하리라 하셨나이다 ");
INSERT INTO kor_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","구하옵나니 주의 인자의 광대하심을 따라 이 백성의 죄악을 사하시되 애굽에서부터 지금까지 이 백성을 사하신것 같이 사하옵소서 !' ");
INSERT INTO kor_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","여호와께서 가라사대 내가 네 말대로 사하노라 ! ");
INSERT INTO kor_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","그러나 진실로 나의 사는 것과 여호와의 영광이 온 세계에 충만할 것으로 맹세하노니 ");
INSERT INTO kor_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","나의 영광과 애굽과 광야에서 행한 나의 이적을 보고도 이같이 열 번이나 나를 시험하고 내 목소리를 청종치 아니한 그 사람들은 ");
INSERT INTO kor_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","내가 그 조상들에게 맹세한 땅을 결단코 보지 못할 것이요 또 나를 멸시하는 사람은 하나라도 그것을 보지 못하리라 ");
INSERT INTO kor_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","오직 ! 내 종 갈렙은 그 마음이 그들과 달라서 나를 온전히 좇았은즉 그의 갔던 땅으로 내가 그를 인도하여 들이리니 그 자손이 그 땅을 차지하리라 ");
INSERT INTO kor_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","아말렉인과 가나안인이 골짜기에 거하나니 너희는 내일 돌이켜 홍해 길로 하여 광야로 들어갈지니라 ");
INSERT INTO kor_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","여호와께서 모세와 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","나를 원망하는 이 악한 회중을 내가 어느 때까지 참으랴 ? 이스라엘 자손이 나를 향하여 원망하는 바 그 원망하는 말을 내가 들었노라 ");
INSERT INTO kor_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","그들에게 이르기를 여호와의 말씀에 나의 삶을 가리켜 맹세하노라 너희 말이 내 귀에 들린 대로 내가 너희에게 행하리니 ");
INSERT INTO kor_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","너희 시체가 이 광야에 엎드러질 것이라 너희 이십세 이상으로 계수함을 받은 자 곧 나를 원망한 자의 전부가 ");
INSERT INTO kor_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","여분네의 아들 갈렙과 눈의 아들 여호수아 외에는 내가 맹세하여 너희로 거하게 하리라 한 땅에 결단코 들어가지 못하리라 ");
INSERT INTO kor_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","너희가 사로 잡히겠다고 말하던 너희의 유아들은 내가 인도하여 들이리니 그들은 너희가 싫어하던 땅을 보려니와 ");
INSERT INTO kor_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","너희 시체는 이 광야에 엎드러질 것이요 ");
INSERT INTO kor_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","너희 자녀들은 너희의 패역한 죄를 지고 너희의 시체가 광야에서 소멸되기까지 사십년을 광야에서 유리하는 자가 되리라 ");
INSERT INTO kor_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","너희가 그 땅을 탐지한 날수 사십일의 하루를 일년으로 환산하여 그 사십년간 너희가 너희의 죄악을 질지니 너희가 나의 싫어 버림을 알리라 하셨다 하라 ");
INSERT INTO kor_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","나 여호와가 말하였거니와 모여 나를 거역하는 이 악한 온 회중에게 내가 단정코 이같이 행하리니 그들이 이 광야에서 소멸되어 거기서 죽으리라 ");
INSERT INTO kor_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","모세의 보냄을 받고 땅을 탐지하고 돌아와서 그 땅을 악평하여 온 회중으로 모세를 원망케 한 사람 ");
INSERT INTO kor_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","곧 그 땅에 대하여 악평한 자들은 여호와 앞에서 재앙으로 죽었고 ");
INSERT INTO kor_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","그 땅을 탐지하러 갔던 사람들 중에 오직 눈의 아들 여호수아와 여분네의 아들 갈렙은 생존하니라 ");
INSERT INTO kor_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","모세가 이 말로 이스라엘 모든 자손에게 고하매 백성이 크게 슬퍼하여 ");
INSERT INTO kor_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","아침에 일찌기 일어나 산꼭대기로 올라가며 가로되 '보소서 우리가 여기 있나이다 우리가 여호와의 허락하신 곳으로 올라 가리니 우리가 범죄하였음이니이다' ");
INSERT INTO kor_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","모세가 가로되 `너희가 어찌하여 이제 여호와의 명령을 범하느냐 ? 이 일이 형통치 못하리라 ");
INSERT INTO kor_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","여호와께서 너희 중에 계시지 아니하니 올라가지 말라 너희 대적앞에서 패할까 하노라 ");
INSERT INTO kor_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","아말렉인과 가나안인이 너희 앞에 있으니 너희가 그 칼에 망하리라 너희가 여호와를 배반하였으니 여호와께서 너희와 함께 하지 아니하시리라' 하나 ");
INSERT INTO kor_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","그들이 그래도 산꼭대기로 올라갔고 여호와의 언약궤와 모세는 진을 떠나지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","아말렉인과 산지에 거하는 가나안인이 내려와 쳐서 파하고 호르마까지 이르렀더라 ");
INSERT INTO kor_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","이스라엘 자손에게 고하여 그들에게 이르라 너희가 내게 주어 거하게 할 땅에 들어가서 ");
INSERT INTO kor_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","여호와께 화제나 번제나 서원을 갚는 제나 낙헌제나 정한 절기제에 소나 양으로 여호와께 향기롭게 드릴 때에는 ");
INSERT INTO kor_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","그 예물을 드리는 자는 고운 가루 에바 십분지 일에 기름 한 힌의 사분지 일을 섞어 여호와께 소제로 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","번제나 다른 제사로 드리는 제물이 어린 양이면 전제로 포도주 한 힌의 사분 일을 예비할 것이요 ");
INSERT INTO kor_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","수양이면 소제로 고운 가루 한 에바 십분지 이에 기름 한 힌의 삼분지 일을 섞어 예비하고 ");
INSERT INTO kor_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","전제로 포도주 한 힌의 삼분지 일을 드려 여호와 앞에 향기롭게 할 것이요 ");
INSERT INTO kor_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","번제로나 서원을 갚는 제로나 화목제로 수송아지를 예비하여 여호와께 드릴 때에는 ");
INSERT INTO kor_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","소제로 고운 가루 한 에바 십분지 삼에 기름 반 힌을 섞어 그 수송아지와 함께 드리고 ");
INSERT INTO kor_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","전제로 포도주 반 힌을 드려 여호와 앞에 향기로운 화제를 삼을지니라 ");
INSERT INTO kor_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","수송아지나 수양이나 어린 수양이나 어린 염소에는 그 마리 수마다 이 위와 같이 행하되 ");
INSERT INTO kor_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","너희 예비하는 수효를 따라 각기 수효에 맞게 하라 ");
INSERT INTO kor_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","무릇 본토 소생이 여호와께 향기로운 화제를 드릴 때에는 이 법대로 할 것이요 ");
INSERT INTO kor_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","너희 중에 우거하는 타국인이나 너희 중에 대대로 있는 자가 누구든지 여호와께 향기로운 화제를 드릴 때에는 너희 하는대로 그도 그리할 것이라 ");
INSERT INTO kor_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","회중 곧 너희나 우거하는 타국인이나 한 율례니 너희의 대대로 영원한 율례라 너희의 어떠한 대로 타국인도 여호와 앞에 그러하리라 ");
INSERT INTO kor_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","너희나 너희 중에 우거하는 타국인이나 한 법도, 한 규례니라 ");
INSERT INTO kor_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","이스라엘 자손에게 고하여 이르라 너희가 나의 인도하는 땅에 들어가거든 ");
INSERT INTO kor_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","그 땅의 양식을 먹을 때에 여호와께 거제를 드리되 ");
INSERT INTO kor_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","너희의 처음 익은 곡식 가루 떡을 거제로 타작 마당의 거제같이 들어 드리라 ");
INSERT INTO kor_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","너희의 처음 익은 곡식 가루 떡을 대대에 여호와께 거제로 드릴지니라 ");
INSERT INTO kor_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","너희가 그릇 범죄하여 여호와가 모세에게 말한 이 모든 명령을 지키지 못하되 ");
INSERT INTO kor_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","곧 여호와가 모세로 너희에게 명한 모든 것을 여호와가 명한 날부터 이후 너희의 대대에 지키지 못하여 ");
INSERT INTO kor_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","회중이 부지중에 그릇 범죄하였거든 온 회중은 수송아지 하나를 여호와께 향기로운 화제로 드리고 규례대로 그 소제와 전제를 드리고 수염소 하나를 속죄제로 드릴 것이라 ");
INSERT INTO kor_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","제사장이 이스라엘 자손의 온 회중을 위하여 속죄하면 그들이 사함을 얻으리니 이는 그릇 범죄함이며 또 그 그릇 범죄함을 인하여 예물 곧 화제와 속죄제를 여호와께 드렸음이라 ");
INSERT INTO kor_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","이스라엘 자손의 온 회중과 그들 중에 우거하는 타국인도 사함을 얻을 것은 온 백성이 그릇 범죄하였음이니라 ");
INSERT INTO kor_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","만일 한 사람이 그릇 범죄하거든 일년 된 암염소로 속죄제를 드릴 것이요 ");
INSERT INTO kor_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","제사장은 그 그릇 범죄한 사람이 그릇하여 여호와 앞에 얻은 죄를 위하여 속죄하여 그 죄를 속할지니 그리하면 사함을 얻으리라 ! ");
INSERT INTO kor_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","이스라엘 자손 중 본토 소생이든지 그들 중에 우거하는 타국인이든지 무릇 그릇 범죄한 자에게 대한 법이 동일하거니와 ");
INSERT INTO kor_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","본토 소생이든지 타국인이든지 무릇 짐짓 무엇을 행하면 여호와를 훼방하는 자니 그 백성 중에서 끊쳐질 것이라 ");
INSERT INTO kor_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","그런 사람은 여호와의 말씀을 멸시하고 그 명령을 파괴하였은즉 그 죄악이 자기에게로 돌아가서 온전히 끊쳐지리라 ");
INSERT INTO kor_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","이스라엘 자손이 광야에 거할 때에 안식일에 어떤 사람이 나무하는 것을 발견한지라 ");
INSERT INTO kor_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","그 나무하는 자를 발견한 자들이 그를 모세와 아론과 온 회중의 앞으로 끌어 왔으나 ");
INSERT INTO kor_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","어떻게 처치할는지 지시하심을 받지 못한 고로 가두었더니 ");
INSERT INTO kor_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","여호와께서 모세에게 이르시되 그 사람을 반드시 죽일지니 온 회중이 진 밖에서 돌로 그를 칠지니라 ");
INSERT INTO kor_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","온 회중이 곧 그를 진 밖으로 끌어내어 돌로 그를 쳐 죽여서 여호와께서 모세에게 명하신 대로 하니라 ");
INSERT INTO kor_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","이스라엘 자손에게 명하여 그들의 대대로 그 옷단 귀에 술을 만들고 청색 끈을 그 귀의 술에 더하라 ");
INSERT INTO kor_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","이 술은 너희로 보고 여호와의 모든 계명을 기억하여 준행하고 너희로 방종(放縱)케 하는 자기의 마음과 눈의 욕심을 좇지 않게 하기 위함이라 ");
INSERT INTO kor_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","그리하면 너희가 나의 모든 계명을 기억하고 준행하여 너희의 하나님 앞에 거룩하리라 ");
INSERT INTO kor_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","나는 너희의 하나님이 되려 하여 너희를 애굽 땅에서 인도하여 낸 여호와 너희 하나님이니라 나는 여호와 너희 하나님이니라 ");
INSERT INTO kor_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","레위의 증손 고핫의 손자 이스할의 아들 고라와, 르우벤 자손 엘리압의 아들 다단과 아비람과 벨렛의 아들 온이 당을 짓고 ");
INSERT INTO kor_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","이스라엘 자손 총회에 택함을 받은 자 곧 회중에 유명한 어떤 족장 이백 오십인과 함께 일어나서 모세를 거스리니라 ");
INSERT INTO kor_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","그들이 모여서 모세와 아론을 거스려 그들에게 이르되 `너희가 분수에 지나도다 회중이 다 각각 거룩하고 여호와께서도 그들 중에 계시거늘 너희가 어찌하여 여호와의 총회 위에 스스로 높이느뇨 ?' ");
INSERT INTO kor_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","모세가 듣고 엎드렸다가 ");
INSERT INTO kor_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","고라와 그 모든 무리에게 말하여 가로되 `아침에 여호와께서 자기에게 속한 자가 누구인지 거룩한 자가 누구인지 보이시고 그 자를 자기에게 가까이 나아오게 하시되 곧 그가 택하신 자를 자기에게 가까이 나아오게 하시리니 ");
INSERT INTO kor_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","이렇게 하라 너 고라와 너의 모든 무리는 향로를 취하고 ");
INSERT INTO kor_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","내일 여호와 앞에서 그 향로에 불을 담고 그 위에 향을 두라 그 때에 여호와의 택하신 자는 거룩하게 되리라 레위 자손들아 ! 너희가 너무 분수에 지나치느니라 !' ");
INSERT INTO kor_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","모세가 또 고라에게 이르되 `너희 레위 자손들아 들으라 ! ");
INSERT INTO kor_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","이스라엘의 하나님이 이스라엘 회중에서 너희를 구별하여 자기에게 가까이 하게 하사 여호와의 성막에서 봉사하게 하시며 회중 앞에 서서 그들을 대신하여 섬기게 하심이 너희에게 작은 일이겠느냐 ? ");
INSERT INTO kor_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","하나님이 너와 네 모든 형제 레위 자손으로 너와 함께 가까이 오게 하신 것이 작은 일이 아니어늘 너희가 오히려 제사장의 직분을 구하느냐 ? ");
INSERT INTO kor_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","이를 위하여 너와 너의 무리가 다 모여서 여호와를 거스리는도다 아론은 어떠한 사람이관대 너희가 그를 원망하느냐 ?' ");
INSERT INTO kor_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","모세가 엘리압의 아들 다단과 아비람을 부르러 보내었더니 그들이 가로되 '우리는 올라가지 않겠노라 ");
INSERT INTO kor_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","네가 우리를 젖과 꿀이 흐르는 땅에서 이끌어 내어 광야에서 죽이려 함이 어찌 작은 일이기에 오히려 스스로 우리 위에 왕이 되려 하느냐 ? ");
INSERT INTO kor_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","이뿐 아니라 네가 우리를 젖과 꿀이 흐르는 땅으로 인도하여 들이지도 아니하고 밭과 포도원도 우리에게 기업으로 주지 아니하니 네가 이 사람들의 눈을 빼려느냐 ? 우리는 올라가지 아니하겠노라' ");
INSERT INTO kor_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","모세가 심히 노하여 여호와께 여짜오되 `주는 그들의 예물을 돌아보지 마옵소서 나는 그들의 한 나귀도 취하지 아니하였고 그들의 한 사람도 해하지 아니하였나이다' 하고 ");
INSERT INTO kor_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","이에 고라에게 이르되 `너와 너의 온 무리는 아론과 함께 내일 여호와 앞으로 나아오되 ");
INSERT INTO kor_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","너희는 각기 향로를 잡고 그 위에 향을 두고 각 사람이 그 향로를 여호와 앞으로 가져오라 향로는 모두 이백 오십이라 너와 아론도 각각 향로를 가지고 올지니라' ");
INSERT INTO kor_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","그들이 각기 향로를 취하여 불을 담고 향을 그 위에 두고 모세와 아론으로 더불어 회막 문에 서니라 ");
INSERT INTO kor_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","고라가 온 회중을 회막 문에 모아 놓고 그 두 사람을 대적하려 하매 여호와의 영광이 온 회중에게 나타나시니라 ");
INSERT INTO kor_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","여호와께서 모세와 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","너희는 이 회중에게서 떠나라 내가 순식간에 그들을 멸하려 하노라 ");
INSERT INTO kor_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","그 두 사람이 엎드려 가로되 `하나님이여 ! 모든 육체의 생명의 하나님이여 ! 한 사람이 범죄하였거늘 온 회중에게 진노하시나이까 ?' ");
INSERT INTO kor_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","회중에게 명하여 이르기를 너희는 고라와 다단과 아비람의 장막 사면에서 떠나라 하라 ");
INSERT INTO kor_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","모세가 일어나 다단과 아비람에게로 가니 이스라엘 장로들이 좇았더라 ");
INSERT INTO kor_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","모세가 회중에게 일러 가로되 '이 악인들의 장막에서 떠나고 그들의 물건은 아무것도 만지지 말라 그들의 모든 죄중에서 너희도 멸망할까 두려워 하노라' 하매 ");
INSERT INTO kor_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","무리가 고라와, 다단과, 아비람의 장막 사면을 떠나고 다단과, 아비람은 그 처자와 유아들과 함께 나와서 자기 장막 문에 선지라 ");
INSERT INTO kor_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","모세가 가로되 `여호와께서 나를 보내사 이 모든 일을 행케 하신 것이요 나의 임의로 함이 아닌 줄을 이 일로 인하여 알리라 ");
INSERT INTO kor_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","곧 이 사람들의 죽음이 모든 사람과 일반이요 그들의 당하는 벌이 모든 사람의 당하는 벌과 일반이면 여호와께서 나를 보내심이 아니어니와 ");
INSERT INTO kor_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","만일 여호와께서 새 일을 행하사 땅으로 입을 열어 이 사람들과 그들의 모든 소속을 삼켜 산 채로 음부에 빠지게 하시면 이 사람들이 과연 여호와를 멸시한 것인 줄을 너희가 알리라' ");
INSERT INTO kor_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","이 모든 말을 마치는 동시에 그들의 밑의 땅이 갈라지니라 ");
INSERT INTO kor_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","땅이 그 입을 열어 그들과 그 가속과 고라에게 속한 모든 사람과 그 물건을 삼키매 ");
INSERT INTO kor_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","그들과 그 모든 소속이 산 채로 음부에 빠지며 땅이 그 위에 합하니 그들이 총회 중에서 망하니라 ");
INSERT INTO kor_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","그 주위에 있는 온 이스라엘이 그들의 부르짖음을 듣고 도망하며 가로되 '땅이 우리도 삼킬까 두렵다' 하였고 ");
INSERT INTO kor_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","여호와께로서 불이 나와서 분향하는 이백 오십인을 소멸하였더라 ");
INSERT INTO kor_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","너는 제사장 아론의 아들 엘르아살을 명하여 붙는 불 가운데서 향로를 취하여다가 그 불을 타처에 쏟으라 그 향로는 거룩함이니라 ");
INSERT INTO kor_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","사람들은 범죄하여 그 생명을 스스로 해하였거니와 그들이 향로를 여호와 앞에 드렸으므로 그 향기가 거룩하게 되었나니 그 향로를 쳐서 제단을 싸는 편철을 만들라 이스라엘 자손에게 표가 되리라 하신지라 ");
INSERT INTO kor_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","제사장 엘르아살이 불탄 자들의 드렸던 놋 향로를 취하여 쳐서 제단을 싸서 ");
INSERT INTO kor_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","이스라엘 자손의 기념물이 되게 하였으니 이는 아론 자손이 아닌 외인은 여호와 앞에 분향하러 가까이 오지 못하게 함이며 또 고라와 그 무리같이 되지 않게 하기 위함이라 여호와께서 모세로 그에게 명하신 대로 하였더라 ");
INSERT INTO kor_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","이튿날 이스라엘 자손의 온 회중이 모세와 아론에게 원망하여 가로되 너희가 여호와의 백성을 죽였도다 하고 ");
INSERT INTO kor_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","회중이 모여 모세와 아론을 칠 때에 회막을 바라본즉 구름이 회막을 덮었고 여호와의 영광이 나타났더라 ");
INSERT INTO kor_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","모세와 아론이 회막 앞에 이르매 ");
INSERT INTO kor_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","너희는 이 회중에게서 떠나라 내가 순식간에 그들을 멸하려 하노라 하시매 그 두 사람이 엎드리니라 ");
INSERT INTO kor_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","이에 모세가 아론에게 이르되 `너는 향로를 취하고 단의 불을 그것에 담고 그 위에 향을 두어 가지고 급히 회중에게로 가서 그들을 위하여 속죄하라 여호와께서 진노하셨으므로 염병이 시작되었음이니라' ");
INSERT INTO kor_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","아론이 모세의 명을 좇아 향로를 가지고 회중에게로 달려간즉 백성 중에 염병이 시작되었는지라 이에 백성을 위하여 속죄하고 ");
INSERT INTO kor_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","죽은 자와 산 자 사이에 섰을 때에 염병이 그치니라 ");
INSERT INTO kor_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","고라의 일로 죽은 자 외에 염병에 죽은 자가 일만 사천 칠백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","염병이 그치매 아론이 회막 문 모세에게로 돌아오니라 ");
INSERT INTO kor_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","너는 이스라엘 자손에게 고하여 그들 중에서 각 종족을 따라 지팡이 하나씩 취하되 곧 그들의 종족대로 그 모든 족장에게서 지팡이 열둘을 취하고 그 사람들의 이름을 각각 그 지팡이에 쓰되 ");
INSERT INTO kor_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","레위의 지팡이에는 아론의 이름을 쓰라 이는 그들의 종족의 각 두령이 지팡이 하나씩 있어야 할 것임이니라 ");
INSERT INTO kor_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","그 지팡이를 회막 안에서 내가 너희와 만나는 곳인 증거궤 앞에 두라 ");
INSERT INTO kor_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","내가 택한 자의 지팡이에는 싹이 나리니 이것으로 이스라엘 자손이 너희를 대하여 원망하는 말을 내 앞에서 그치게 하리라 ");
INSERT INTO kor_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","모세가 이스라엘 자손에게 고하매 그 족장들이 각기 종족대로 지팡이 하나씩 그에게 주었으니 그 지팡이 합이 열둘이라 그 중에 아론의 지팡이가 있었더라 ");
INSERT INTO kor_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","모세가 그 지팡이들을 증거의 장막 안 여호와 앞에 두었더라 ");
INSERT INTO kor_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","이튿날 모세가 증거의 장막 안에 들어가 본즉 레위집을 위하여 낸 아론의 지팡이에 움이 돋고 순이 나고 꽃이 피어서 살구 열매가 열렸더라 ");
INSERT INTO kor_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","모세가 그 지팡이 전부를 여호와 앞에서 이스라엘 모든 자손에게로 취하여 내매 그들이 보고 각각 자기 지팡이를 취하였더라 ");
INSERT INTO kor_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","여호와께서 또 모세에게 이르시되 아론의 지팡이는 증거궤 앞으로 도로 가져다가 거기 간직하여 패역한 자에 대한 표징이 되게 하여 그들로 내게 대한 원망을 그치고 죽지 않게 할지니라 ");
INSERT INTO kor_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","모세가 곧 그같이 하되 여호와께서 자기에게 명하신 대로 하였더라 ");
INSERT INTO kor_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","이스라엘 자손이 모세에게 말하여 가로되 `보소서 ! 우리는 죽게 되었나이다 ! 망하게 되었나이다 ! 다 망하게 되었나이다 ! ");
INSERT INTO kor_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","가까이 나아가는 자 곧 여호와의 성막에 가까이 나아가는 자마다 죽사오니 우리가 다 망하여야 하리이까 ");
INSERT INTO kor_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","여호와께서 아론에게 이르시되 너와 네 아들들과 네 종족은 성소에 대한 죄를 함께 담당할 것이요 너와 네 아들들은 너희가 그 제사장 직분에 대한 죄를 함께 담당할 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","너는 네 형제 레위 지파 곧 네 조상의 지파를 데려다가 너와 합동시켜 너를 섬기게 하고 너와 네 아들들은 증거의 장막앞에 있을 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","레위인은 네 직무와 장막의 모든 직무를 지키려니와 성소의 기구와 단에는 가까이 못하리니 두렵건대 그들과 너희가 죽을까 하노라 ");
INSERT INTO kor_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","레위인은 너와 합동하여 장막의 모든 일과 회막의 직무를 지킬 것이요 외인은 너희에게 가까이 못할 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","이와 같이 너희는 성소의 직무와 단의 직무를 지키라 ! 그리하면 여호와의 진노가 다시는 이스라엘 자손에게 미치지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","보라, 내가 이스라엘 자손 중에서 너희 형제 레위인을 취하여 내게 돌리고 너희에게 선물로 주어 회막의 일을 하게 하였나니 ");
INSERT INTO kor_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","너와 네 아들들은 단과 장 안의 모든 일에 대하여 제사장의 직분을 지켜 섬기라 ! 내가 제사장의 직분을 너희에게 선물로 주었은즉 거기 가까이 하는 외인은 죽이울지니라 ");
INSERT INTO kor_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","여호와께서 또 아론에게 이르시되 보라, 내가 내 거제물 곧 이스라엘 자손의 거룩하게 한 모든 예물을 너로 주관하게 하고 네가 기름부음을 받았음을 인하여 그것을 너와 네 아들들에게 영영한 응식으로 주노라 ");
INSERT INTO kor_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","지성물 중에 불사르지 않은 것은 네 것이라 그들이 내게 드리는 모든 예물의 모든 소제와 속죄제와 속건 제물은 다 지극히 거룩한즉 너와 네 아들들에게 돌리리니 ");
INSERT INTO kor_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","지극히 거룩하게 여김으로 먹으라 이는 네게 성물인즉 남자들이 다 먹을지니라 ");
INSERT INTO kor_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","내게 돌릴 것이 이것이니 곧 이스라엘 자손의 드리는 거제물과 모든 요제물이라 내가 그것을 너와 네 자손에게 영영한 응식으로 주었은즉 네 집의 정결한 자마다 먹을 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","그들이 여호와께 드리는 첫 소산 곧 제일 좋은 기름과, 제일 좋은 포도주와, 곡식을 네게 주었은즉 ");
INSERT INTO kor_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","그들이 여호와께 드리는 그 땅 처음 익은 모든 열매는 네 것이니 네 집에 정결한 자마다 먹을 것이라 ");
INSERT INTO kor_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","이스라엘 중에서 특별히 드린 모든 것은 네 것이 되리라 ! ");
INSERT INTO kor_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","여호와께 드리는 모든 생물의 처음 나는 것은 사람이나 짐승이나 다 네 것이로되 사람의 처음 난 것은 반드시 대속할 것이요 부정한 짐승의 처음 난 것도 대속할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","그 사람을 속할 때에는 난지 일개월 이후에 네가 정한 대로 성소의 세겔을 따라 은 다섯 세겔로 속하라 한 세겔은 이십 게라니라 ");
INSERT INTO kor_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","오직 소의 처음 난 것이나 양의 처음 난 것이나 염소의 처음 난것은 속하지 말지니 그것들은 거룩한즉 그 피는 단에 뿌리고 그 기름은 불살라 여호와께 향기로운 화제로 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","그 고기는 네게 돌릴지니 흔든 가슴과 우편 넓적다리 같이 네게 돌릴 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","이스라엘 자손이 여호와께 거제로 드리는 모든 성물은 내가 영영한 응식으로 너와 네 자녀에게 주노니 이는 여호와 앞에 너와 네 후손에게 변하지 않는 소금 언약이니라 ");
INSERT INTO kor_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","여호와께서 또 아론에게 이르시되 너는 이스라엘 자손의 땅의 기업도 없겠고 그들 중에 아무 분깃도 없을 것이나 나는 이스라엘 자손 중에 네 분깃이요 네 기업이니라 ");
INSERT INTO kor_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","내가 이스라엘의 십일조를 레위 자손에게 기업으로 다 주어서 그들의 하는 일 곧 회막에서 하는 일을 갚나니 ");
INSERT INTO kor_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","이후로는 이스라엘 자손이 회막에 가까이 말 것이라 죄를 당하여 죽을까 하노라 ");
INSERT INTO kor_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","오직 레위인은 회막에서 봉사하며 자기들의 죄를 담당할 것이요 이스라엘 자손 중에는 기업이 없을 것이니 이는 너희의 대대에 영원한 율례라 ");
INSERT INTO kor_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","이스라엘 자손이 여호와께 거제로 드리는 십일조를 레위인에게 기업으로 준 고로 내가 그들에 대하여 말하기를 이스라엘 자손 중에 기업이 없을 것이라 하였노라 ");
INSERT INTO kor_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","너는 레위인에게 고하여 그에게 이르라 내가 이스라엘 자손에게 취하여 너희에게 기업으로 준 십일조를 너희가 그들에게서 취할 때에 그 십일조의 십일조를 거제로 여호와께 드릴 것이라 ");
INSERT INTO kor_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","내가 너희의 거제물을 타작 마당에서 받드는 곡물과 포도즙 틀에서 받드는 즙같이 여기리니 ");
INSERT INTO kor_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","너희는 이스라엘 자손에게서 받는 모든 것의 십일조 중에서 여호와께 거제로 드리고 여호와께 드린 그 거제물은 제사장 아론에게 돌리되 ");
INSERT INTO kor_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","너희의 받은 모든 예물 중에서 너희는 그 아름다운 것 곧 거룩하게 한 부분을 취하여 여호와께 거제로 드릴지니라 ");
INSERT INTO kor_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","이러므로 너는 그들에게 이르라 너희가 그 중에서 아름다운 것을 취하여 드리고 남은 것은 너희 레위인에게는 타작 마당의 소출과 포도즙 틀의 소출같이 되리니 ");
INSERT INTO kor_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","너희와 너희 권속이 어디서든지 이것을 먹을 수 있음은 이는 회막에서 일한 너희의 보수임이니라 ");
INSERT INTO kor_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","너희가 그 중 아름다운 것을 받들어 드린즉 이로 인하여 죄를 지지 아니할 것이라 너희는 이스라엘 자손의 성물을 더럽히지 말라 ! 그리하면 죽지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","여호와께서 모세와 아론에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","여호와의 명하는 법의 율례를 이제 이르노니 이스라엘 자손에게 일러서 온전하여 흠이 없고 아직 멍에 메지 아니한 붉은 암송아지를 네게로 끌어 오게 하고 ");
INSERT INTO kor_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","너는 그것을 제사장 엘르아살에게 줄 것이요 그는 그것을 진 밖으로 끌어 내어서 자기 목전에서 잡게 할것이며 ");
INSERT INTO kor_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","제사장 엘르아살은 손가락에 그 피를 찍고 그 피를 회막 앞을 향하여 일곱번 뿌리고 ");
INSERT INTO kor_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","그 암소를 자기 목전에서 불사르게 하되 그 가죽과 고기와 피와 똥을 불사르게 하고 ");
INSERT INTO kor_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","동시에 제사장은 백향목과, 우슬초와, 홍색실을 취하여 암송아지를 사르는 불 가운데 던질 것이며 ");
INSERT INTO kor_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","제사장은 그 옷을 빨고 물로 몸을 씻은 후에 진에 들어갈 것이라 그는 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","송아지를 불사른 자도 그 옷을 물로 빨고 물로 그 몸을 씻을 것이라 그도 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","이에 정한 자가 암송아지의 재를 거두어 진 밖 정한 곳에 둘지니 이것은 이스라엘 자손 회중을 위하여 간직하였다가 부정을 깨끗케 하는 물을 만드는데 쓸 것이니 곧 속죄제니라 ");
INSERT INTO kor_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","암송아지의 재를 거둔 자도 그 옷을 빨 것이며 저녁까지 부정하리라 이는 이스라엘 자손과 그 중에 우거하는 외인에게 영원한 율례니라 ");
INSERT INTO kor_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","사람의 시체를 만진 자는 칠일을 부정하리니 ");
INSERT INTO kor_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","그는 제 삼일과 제 칠일에 이 잿물로 스스로 정결케 할 것이라 그리하면 정하려니와 제 삼일과 제 칠일에 스스로 정결케 아니하면 그냥 부정하니 ");
INSERT INTO kor_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","누구든지 죽은 사람의 시체를 만지고 스스로 정결케 아니하는 자는 여호와의 성막을 더럽힘이라 그가 이스라엘에서 끊쳐질 것은 정결케 하는 물을 그에게 뿌리지 아니하므로 깨끗케 되지 못하고 그 부정함이 있음이니라 ");
INSERT INTO kor_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","장막에서 사람이 죽을 때의 법은 이러하니 무릇 그 장막에 들어가는 자와 무릇 그 장막에 있는 자가 칠일 동안 부정할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","무릇 뚜껑을 열어 놓고 덮지 아니한 그릇도 부정하니라 ");
INSERT INTO kor_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","누구든지 들에서 칼에 죽이운 자나 시체나 사람의 뼈나 무덤을 만졌으면 칠일동안 부정하리니 ");
INSERT INTO kor_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","그 부정한 자를 위하여 죄를 깨끗하게 하려고 불사른 재를 취하여 흐르는 물과 함께 그릇에 담고 ");
INSERT INTO kor_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","정한 자가 우슬초를 취하여 그 물을 찍어서 장막과 그 모든 기구와 거기 있는 사람들에게 뿌리고 또 뼈나 죽임을 당한 자나 시체나 무덤을 만진 자에게 뿌리되 ");
INSERT INTO kor_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","그 정한 자가 제 삼일과 제 칠일에 그 부정한 자에게 뿌려서 제 칠일에 그를 정결케 할 것이며 그는 자기 옷을 빨고 물로 몸을 씻을 것이라 저녁이면 정하리라 ");
INSERT INTO kor_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","사람이 부정하고도 스스로 정결케 아니하면 여호와의 성소를 더럽힘이니 그러므로 총회 중에서 끊쳐질 것이니라 그는 정결케 하는 물로 뿌리움을 받지 아니하였은즉 부정하니라 ");
INSERT INTO kor_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","이는 그들의 영영한 율례니라 정결케 하는 물을 뿌린 자는 그 옷을 빨 것이며 정결케 하는 물을 만지는 자는 저녁까지 부정할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","부정한 자가 만진 것은 무엇이든지 부정할 것이며 그것을 만지는 자도 저녁까지 부정하리라 ");
INSERT INTO kor_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","정월에 이스라엘 자손 곧 온 회중이 신 광야에 이르러서 백성이 가데스에 거하더니 미리암이 거기서 죽으매 거기 장사하니라 ");
INSERT INTO kor_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","회중이 물이 없으므로 모여서 모세와 아론을 공박하니라 ");
INSERT INTO kor_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","백성이 모세와 다투어 말하여 가로되 `우리 형제들이 여호와 앞에서 죽을 때에 우리도 죽었더면 좋을 뻔 하였도다 ");
INSERT INTO kor_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","너희가 어찌하여 여호와의 총회를 이 광야로 인도하여 올려서 우리와 우리 짐승으로 다 여기서 죽게 하느냐 ? ");
INSERT INTO kor_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","너희가 어찌하여 우리를 애굽에서 나오게 하여 이 악한 곳으로 인도하였느냐 ? 이 곳에는 파종할 곳이 없고, 무화과도 없고, 포도도 없고, 석류도 없고, 마실 물도 없도다' ");
INSERT INTO kor_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","모세와 아론이 총회 앞을 떠나 회막 문에 이르러 엎드리매 여호와의 영광이 그들에게 나타나며 ");
INSERT INTO kor_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","지팡이를 가지고 네 형 아론과 함께 회중을 모으고 그들의 목전에서 너희는 반석에게 명하여 물을 내라 하라 네가 그 반석으로 물을 내게 하여 회중과 그들의 짐승에게 마시울지니라 ");
INSERT INTO kor_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","모세가 그 명대로 여호와의 앞에서 지팡이를 취하니라 ");
INSERT INTO kor_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","모세와 아론이 총회를 그 반석 앞에 모으고 모세가 그들에게 이르되 패역한 너희여 들으라 우리가 너희를 위하여 이 반석에서 물을 내랴 하고 ");
INSERT INTO kor_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","그 손을 들어 그 지팡이로 반석을 두번 치매 물이 많이 솟아 나오므로 회중과 그들의 짐승이 마시니라 ");
INSERT INTO kor_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","여호와께서 모세와 아론에게 이르시되 너희가 나를 믿지 아니하고 이스라엘 자손의 목전에 나의 거룩함을 나타내지 아니한 고로 너희는 이 총회를 내가 그들에게 준 땅으로 인도하여 들이지 못하리라 하시니라 ");
INSERT INTO kor_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","이스라엘 자손이 여호와와 다투었으므로 이를 므리바 물이라 하니라 여호와께서 그들 중에서 그 거룩함을 나타내셨더라 ");
INSERT INTO kor_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","모세가 가데스에서 에돔 왕에게 사자를 보내며 이르되 `당신의 형제 이스라엘의 말에 우리의 당한 모든 고난을 당신도 아시거니와 ");
INSERT INTO kor_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","우리 열조가 애굽으로 내려갔으므로 우리가 애굽에 오래 거하였더니 애굽인이 우리 열조와 우리를 학대하였으므로 ");
INSERT INTO kor_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","우리가 여호와께 부르짖었더니 우리 소리를 들으시고 천사를 보내사 우리를 애굽에서 인도하여 내셨나이다 이제 우리가 당신의 변방 모퉁이 한 성읍 가데스에 있사오니 ");
INSERT INTO kor_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","청컨대 우리로 당신의 땅을 통과하게 하소서 우리가 밭으로나 포도원으로나 통과하지 아니하고 우물물도 공히 마시지 아니하고 우리가 왕의 대로로만 통과하고 당신의 지경에서 나가기까지 좌편으로나 우편으로 치우치지 아니하리이다 한다 하라' 하였더니 ");
INSERT INTO kor_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","에돔 왕이 대답하되 `너는 우리 가운데로 통과하지 못하리라 내가 나가서 칼로 너를 맞을까 염려하라' ");
INSERT INTO kor_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","이스라엘 자손이 이르되 `우리가 대로로 통과하겠고 우리나 우리 짐승이 당신의 물을 마시면 그 값을 줄 것이라 우리가 도보로 통과할 뿐인즉 아무 일도 없으리이다' 하나 ");
INSERT INTO kor_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","그는 가로되 `너는 지나가지 못하리라' 하고 에돔 왕이 많은 백성을 거느리고 나와서 강한 손으로 막으니 ");
INSERT INTO kor_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","에돔 왕이 이같이 이스라엘의 그 경내로 통과함을 용납지 아니하므로 이스라엘이 그들에게서 돌이키니라 ");
INSERT INTO kor_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","이스라엘 자손 곧 온 회중이 가데스에서 진행하여 호르산에 이르렀더니 ");
INSERT INTO kor_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","여호와께서 에돔 땅 변경 호르산에서 모세와 아론에게 말씀하시니라 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","아론은 그 열조에게로 돌아가고 내가 이스라엘 자손에게 준 땅에는 들어가지 못하리니 이는 너희가 므리바 물에서 내 말을 거역한 연고니라 ");
INSERT INTO kor_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","너는 아론과 그 아들 엘르아살을 데리고 호르산에 올라 ");
INSERT INTO kor_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","아론의 옷을 벗겨 그 아들 엘르아살에게 입히라 아론은 거기서 죽어 그 열조에게로 돌아가리라 ");
INSERT INTO kor_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","모세가 여호와의 명을 좇아 그들과 함께 회중의 목전에서 호르산에 오르니라 ");
INSERT INTO kor_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","모세가 아론의 옷을 벗겨 그 아들 엘르아살에게 입히매 아론이 그 산꼭대기에서 죽으니라 모세와 엘르아살이 산에서 내려오니 ");
INSERT INTO kor_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","온 회중 곧 이스라엘 온 족속이 아론의 죽은 것을 보고 위하여 삼십일을 애곡하였더라 ");
INSERT INTO kor_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","남방에 거하는 가나안 사람 곧 아랏의 왕이 이스라엘이 아다림 길로 온다 함을 듣고 이스라엘을 쳐서 그 중 몇 사람을 사로잡은 ");
INSERT INTO kor_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","이스라엘이 여호와께 서원하여 가로되 `주께서 만일 이 백성을 내 손에 붙이시면 내가 그들의 성읍을 다 멸하리이다' ");
INSERT INTO kor_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","여호와께서 이스라엘의 소리를 들으시고 가나안 사람을 붙이시매 그들과 그 성읍을 다 멸하니라 그러므로 그 곳 이름을 호르마라 하였더라 ");
INSERT INTO kor_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","백성이 호르산에서 진행하여 홍해 길로 좇아 에돔 땅을 둘러 행하려 하였다가 길로 인하여 백성의 마음이 상하니라 ");
INSERT INTO kor_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","백성이 하나님과 모세를 향하여 원망하되 `어찌하여 우리를 애굽에서 인도하여 올려서 이 광야에서 죽게 하는고 이 곳에는 식물도 없고, 물도 없도다 우리 마음이 이 박한 식물을 싫어 하노라'하매 ");
INSERT INTO kor_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","여호와께서 불뱀들을 백성 중에 보내어 백성을 물게 하시므로 이스라엘 백성 중에 죽은 자가 많은지라 ");
INSERT INTO kor_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","백성이 모세에게 이르러 가로되 `우리가 여호와와 당신을 향하여 원망하므로 범죄하였사오니 여호와께 기도하여 이 뱀들을 우리에게서 떠나게 하소서 !' 모세가 백성을 위하여 기도하매 ");
INSERT INTO kor_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","여호와께서 모세에게 이르시되 불뱀을 만들어 장대 위에 달라 물린 자마다 그것을 보면 살리라 ! ");
INSERT INTO kor_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","모세가 놋뱀을 만들어 장대 위에 다니 뱀에게 물린 자마다 놋뱀을 쳐다 본즉 살더라 ");
INSERT INTO kor_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","이스라엘 자손이 진행하여 오봇에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","오봇에서 진행하여 모압 앞 해 돋는 편 광야 이예아바림에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","거기서 진행하여 세렛 골짜기에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","거기서 진행하여 아모리인의 지경에서 흘러 나와서 광야에 이른 아르논 건너편에 진쳤으니 아르논은 모압과 아모리 사이에서 모압의 경계가 된 것이라 ");
INSERT INTO kor_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","이러므로 여호와의 전쟁기에 일렀으되 수바의 와헙과 아르논 골짜기와 ");
INSERT INTO kor_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","모든 골짜기의 비탈은 아르 고을을 향하여 기울어지고 모압의 경계에 닿았도다 하였더라 ");
INSERT INTO kor_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","거기서 브엘에 이르니 브엘은 여호와께서 모세에게 명하시기를 백성을 모으라 내가 그들에게 물을 주리라 하시던 우물이라 ");
INSERT INTO kor_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","그 때에 이스라엘이 노래하여 가로되 우물물아 솟아나라 ! 너희는 그것을 노래하라 ");
INSERT INTO kor_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","이 우물은 족장들이 팠고 백성의 귀인들이 홀과 지팡이로 판 것이로다 하였더라 광야에서 맛다나에 이르렀고 ");
INSERT INTO kor_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","맛다나에서 나할리엘에 이르렀고, 나할리엘에서 바못에 이르렀고 ");
INSERT INTO kor_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","바못에서 모압 들에 있는 골짜기에 이르러 광야가 내려다 보이는 비스가산 꼭대기에 이르렀더라 ");
INSERT INTO kor_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","이스라엘이 아모리 왕 시혼에게 사자를 보내어 가로되 ");
INSERT INTO kor_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","`우리로 당신의 땅을 통과하게 하소서 우리가 밭에든지 포도원에든지 들어가지 아니하며 우물물도 공히 마시지 아니하고 우리가 당신의 지경에서 다 나가기까지 왕의 대로로만 통행하리이다'하나 ");
INSERT INTO kor_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","시혼이 자기 지경으로 이스라엘의 통과함을 용납하지 아니하고 그 백성을 다 모아 이스라엘을 치러 광야로 나와서 야하스에 이르러 이스라엘을 치므로 ");
INSERT INTO kor_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","이스라엘이 칼날로 그들을 쳐서 파하고 그 땅을 아르논부터 얍복까지 점령하여 암몬 자손에게까지 미치니 암몬 자손의 경계는 견고하더라 ");
INSERT INTO kor_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","이스라엘이 이같이 그 모든 성읍을 취하고 그 아모리인의 모든 성읍을 취하고 그 아모리인의 모든 성읍 헤스본과 그 모든 촌락에 거하였으니 ");
INSERT INTO kor_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","헤스본은 아모리인의 왕 시혼의 도성이라 시혼이 모압 전왕을 치고 그 모든 땅을 아르논까지 그 손에서 탈취하였었더라 ");
INSERT INTO kor_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","그러므로 시인이 읊어 가로되 너희는 헤스본으로 올지어다 시혼의 성을 세워 견고히 할지어다 ");
INSERT INTO kor_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","헤스본에서 불이 나오며 시혼의 성에서 화염이 나와서 모압의 아르를 삼키며 아르논 높은 곳의 주인을 멸하였도다 ");
INSERT INTO kor_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","모압아 ! 네가 화를 당하였도다 그모스의 백성아 ! 네가 멸망하였도다 그가 그 아들들로 도망케 하였고 그 딸들로 아모리인의 왕 시혼의 포로가 되게 하였도다 ");
INSERT INTO kor_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","우리가 그들을 쏘아서 헤스본을 디본까지 멸하였고 메드바에 가까운 노바까지 황폐케 하였도다 하였더라 ");
INSERT INTO kor_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","이스라엘이 아모리인의 땅에 거하였더니 ");
INSERT INTO kor_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","모세가 또 보내어 야셀을 정탐케 하고 그 촌락들을 취하고 그 곳에 있던 아모리인을 몰아 내었더라 ");
INSERT INTO kor_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","돌이켜 바산 길로 올라가매 바산 왕 옥이 그 백성을 다 거느리고 나와서 그들을 맞아 에드레이에서 싸우려 하는지라 ");
INSERT INTO kor_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","여호와께서 모세에게 이르시되 그를 두려워 말라 ! 내가 그와 그 백성과 그 땅을 네 손에 붙였나니 너는 헤스본에 거하던 아모리인의 왕 시혼에게 행한 것같이 그에게도 행할지니라 ");
INSERT INTO kor_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","이에 그와 그 아들들과 그 백성을 다 쳐서 한 사람도 남기지 아니하고 그 땅을 점령하였더라 ");
INSERT INTO kor_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","이스라엘 자손이 또 진행하여 모압 평지에 진 쳤으니 요단 건너편 곧 여리고 맞은편이더라 ");
INSERT INTO kor_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","십볼의 아들 발락이 이스라엘이 아모리인에게 행한 모든 일을 보았으므로 ");
INSERT INTO kor_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","모압이 심히 두려워하였으니 이스라엘 백성의 많음을 인함이라 모압이 이스라엘 자손의 연고로 번민하여 ");
INSERT INTO kor_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","미디안 장로들에게 이르되 이제 이 무리가 소가 밭의 풀을 뜯어 먹음 같이 우리 사면에 있는 것을 다 뜯어 먹으리로다 하니 때에 십볼의 아들 발락이 모압 왕이었더라 ");
INSERT INTO kor_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","그가 사자를 브올의 아들 발람의 본향 강변 브돌에 보내어 발람을 부르게 하여 가로되 `보라, 한 민족이 애굽에서 나왔는데 그들이 지면에 덮여서 우리 맞은 편에 거하였고 ");
INSERT INTO kor_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","우리보다 강하니 청컨대 와서 나를 위하여 이 백성을 저주하라 내가 혹 쳐서 이기어 이 땅에서 몰아내리라 그대가 복을 비는 자는 복을 받고 저주하는 자는 저주를 받을 줄을 내가 앎이니라' ");
INSERT INTO kor_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","모압 장로들과 미디안 장로들이 손에 복술의 예물을 가지고 떠나 발람에게 이르러 발락의 말로 그에게 고하매 ");
INSERT INTO kor_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","발람이 그들에게 이르되 `이 밤에 여기서 유숙하라 여호와께서 내게 이르시는 대로 너희에게 대답하리라' 모압 귀족들이 발람에게서 유하니라 ");
INSERT INTO kor_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","하나님이 발람에게 임하여 가라사대 너와 함께 한 이 사람들이 누구냐 ? ");
INSERT INTO kor_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","발람이 하나님께 고하되 `모압 왕 십볼의 아들 발락이 내게 보낸 자라 이르기를 ");
INSERT INTO kor_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","보라 애굽에서 나온 민족이 있어 지면에 덮였으니 이제 와서 나를 위하여 그들을 저주하라 내가 혹 그들을 쳐서 몰아 낼 수 있으리라 하나이다' ");
INSERT INTO kor_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","하나님이 발람에게 이르시되 너는 그들과 함께 가지도 말고 그 백성을 저주하지도 말라 그들은 복을 받은 자니라 ! ");
INSERT INTO kor_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","발람이 아침에 일어나서 발락의 귀족들에게 이르되 `너희는 너희 땅으로 돌아가라 내가 너희와 함께 가기를 여호와께서 허락지 아니하시느니라' ");
INSERT INTO kor_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","모압 귀족들이 일어나 발락에게로 가서 고하되 `발람이 우리와 함께 오기를 거절하더이다' ");
INSERT INTO kor_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","발락이 다시 그들보다 더 높은 귀족들을 더 많이 보내매 ");
INSERT INTO kor_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","그들이 발람에게로 나아가서 그에게 이르되 `십볼의 아들 발락의 말씀에 청컨대 아무것에도 거리끼지 말고 내게로 오라 ");
INSERT INTO kor_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","내가 그대를 높여 크게 존귀케 하고 그대가 내게 말하는 것은 무엇이든지 시행하리니 청컨대 와서 나를 위하여 이 백성을 저주하라 하시더이다' ");
INSERT INTO kor_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","발람이 발락의 신하들에게 대답하여 가로되 `발락이 그 집에 은,금을 가득히 채워서 내게 줄지라도 내가 능히 여호와 내 하나님의 말씀을 어기어 덜하거나 더하지 못하겠노라 ");
INSERT INTO kor_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","그런즉 이제 너희도 이 밤에 여기서 유하라 여호와께서 내게 무슨 말씀을 더하실는지 알아 보리라 ");
INSERT INTO kor_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","밤에 하나님이 발람에게 임하여 이르시되 그 사람들이 너를 부르러 왔거든 일어나 함께 가라 그러나 내가 네게 이르는 말만 준행할지니라' ");
INSERT INTO kor_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","발람이 아침에 일어나서 자기 나귀에 안장을 지우고 모압 귀족들과 함께 행하니 ");
INSERT INTO kor_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","그가 행함을 인하여 하나님이 진노하심으로 여호와의 사자가 그를 막으려고 길에 서니라 발람은 자기 나귀를 타고 그 두 종은 그와 함께 있더니 ");
INSERT INTO kor_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","나귀가 여호와의 사자가 칼을 빼어 손에 들고 길에 선 것을 보고 길에서 떠나 밭으로 들어간지라 발람이 나귀를 길로 돌이키려고 채찍질하니 ");
INSERT INTO kor_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","여호와의 사자는 포도원 사이 좁은 길에 섰고 좌우에는 담이 있더라 ");
INSERT INTO kor_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","나귀가 여호와의 사자를 보고 몸을 담에 대고 발람의 발을 그 담에 비비어 상하게 하매 발람이 다시 채찍질하니 ");
INSERT INTO kor_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","여호와의 사자가 더 나아가서 좌우로 피할 데 없는 좁은 곳에 선지라 ");
INSERT INTO kor_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","나귀가 여호와의 사자를 보고 발람의 밑에 엎드리니 발람이 노하여 자기 지팡이로 나귀를 때리는지라 ");
INSERT INTO kor_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","여호와께서 나귀 입을 여시니 발람에게 이르되 `내가 네게 무엇을 하였기에 나를 이같이 세 번을 때리느뇨 ?' ");
INSERT INTO kor_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","발람이 나귀에게 말하되 `네가 나를 거역하는 연고니 내 손에 칼이 있었더면 곧 너를 죽였으리라' ");
INSERT INTO kor_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","나귀가 발람에게 이르되 나는 네가 오늘까지 네 일생에 타는 나귀가 아니냐 내가 언제든지 네게 이같이 하는 행습이 있더냐 가로되 없었느니라 ");
INSERT INTO kor_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","때에 여호와께서 발람의 눈을 밝히시매 여호와의 사자가 손에 칼을 빼어 들고 길에 선 것을 보고 머리를 숙이고 엎드리니 ");
INSERT INTO kor_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","여호와의 사자가 그에게 이르되 `너는 어찌하여 네 나귀를 이같이 세번 때렸느냐 ? 보라, 네 길이 내 앞에 패역하므로 내가 너를 막으려고 나왔더니 ");
INSERT INTO kor_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","나귀가 나를 보고 이같이 세번을 돌이켜 내 앞에서 피하였느니라 나귀가 만일 돌이켜 나를 피하지 아니하였더면 내가 벌써 너를 죽이고 나귀는 살렸으리라' ");
INSERT INTO kor_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","발람이 여호와의 사자에게 말씀하되 `내가 범죄하였나이다 당신이 나를 막으려고 길에 서신 줄을 내가 알지 못하였나이다 당신이 이를 기뻐하지 아니하시면 나는 돌아가겠나이다' ");
INSERT INTO kor_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","여호와의 사자가 발람에게 이르되 `그 사람들과 함께 가라 내가 네게 이르는 말만 말할지니라' 발람이 발락의 귀족들과 함께 가니라 ");
INSERT INTO kor_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","발락이 발람의 온다 함을 듣고 모압 변경의 끝 아르논 가에 있는 성읍까지 가서 그를 영접하고 ");
INSERT INTO kor_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","발락이 발람에게 이르되 `내가 특별히 보내어 그대를 부르지 아니하였느냐 ? 그대가 어찌 내게 오지 아니하였느냐 ? 내가 어찌 그대를 높여 존귀케 하지 못하겠느냐 ?' ");
INSERT INTO kor_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","발람이 발락에게 이르되 `내가 오기는 하였으나 무엇을 임의로 말할 수 있으리이까 ? 하나님이 내 입에 주시는 말씀 그것을 말할 뿐이니이다' ");
INSERT INTO kor_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","발람이 발락과 동행하여 기럇후솟에 이르러서는 ");
INSERT INTO kor_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","발락이 우양을 잡아 발람과 그와 함께 한 귀족을 대접하였더라 ");
INSERT INTO kor_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","아침에 발락이 발람과 함께 하고 그를 인도하여 바알의 산당에 오르매 발람이 거기서 이스라엘 백성의 진 끝까지 보니라 ");
INSERT INTO kor_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","발람이 발락에게 이르되 `나를 위하여 여기 일곱 단을 쌓고 거기 수송아지 일곱과 수양 일곱을 준비하소서'하매 ");
INSERT INTO kor_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","발락이 발람의 말대로 준비한 후에 발락과 발람이 매 단에 수송아지 하나와 수양 하나를 드리니라 ");
INSERT INTO kor_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","발람이 발락에게 이르되 `당신의 번제물 곁에 서소서 나는 저리로 갈지라 여호와께서 혹시 오셔서 나를 만나시리니 그가 내게 지시하시는 것은 다 당신에게 고하리이다'하고 사태난 산에 이른즉 ");
INSERT INTO kor_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","하나님이 발람에게 임하시는지라 발람이 고하되 `내가 일곱단을 베풀고 매단에 수송아지 하나와 수양 하나를 드렸나이다' ");
INSERT INTO kor_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","여호와께서 발람의 입에 말씀을 주어 가라사대 발락에게 돌아가서 이렇게 말할지어다 ");
INSERT INTO kor_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","그가 발락에게 돌아간즉 발락과 모압 모든 귀족이 번제물 곁에 함께 섰더라 ");
INSERT INTO kor_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","발람이 노래를 지어 가로되 발락이 나를 아람에서, 모압 왕이 동편 산에서 데려다가 이르기를 와서 나를 위하여 야곱을 저주하라, 와서 이스라엘을 꾸짖으라 하도다 ");
INSERT INTO kor_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","하나님이 저주치 않으신 자를 내 어찌 저주하며 여호와께서 꾸짖지 않으신 자를 내 어찌 꾸짖을꼬 ");
INSERT INTO kor_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","내가 바위 위에서 그들을 보며 작은 산에서 그들을 바라보니 이 백성은 홀로 처할 것이라 그를 열방 중의 하나로 여기지 않으리로다 ");
INSERT INTO kor_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","야곱의 티끌을 뉘 능히 계산하며 이스라엘 사분지 일을 뉘 능히 계수 할꼬 나는 의인의 죽음같이 죽기를 원하며 나의 종말이 그와 같기를 바라도다 하매 ");
INSERT INTO kor_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","발락이 발람에게 이르되 `그대가 어찌 내게 이같이 행하느냐 ? 나의 원수를 저주하라고 그대를 데려 왔거늘 그대가 온전히 축복하였도다' ");
INSERT INTO kor_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","대답하여 가로되 `여호와께서 내 입에 주신 말씀을 내가 어찌 말하지 아니할 수 있으리이까 ?' ");
INSERT INTO kor_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","발락이 가로되 `나와 함께 그들을 달리 볼 곳으로 가자 거기서는 그들을 다 보지 못하고 그 끝만 보리니 거기서 나를 위하여 그들을 저주하라'하고 ");
INSERT INTO kor_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","소빔 들로 인도하여 비스가 꼭대기에 이르러 일곱 단을 쌓고 매 단에 수송아지 하나와 수양 하나를 드리니 ");
INSERT INTO kor_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","발람이 발락에게 이르되 `내가 저기서 여호와를 만날 동안에 여기 당신의 번제물 곁에 서소서'하니라 ");
INSERT INTO kor_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","여호와께서 발람에게 임하사 그 입에 말씀을 주어 가라사대 발락에게로 돌아가서 이렇게 말할지니라 ");
INSERT INTO kor_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","발람이 와서 본즉 발락이 번제물 곁에 섰고 모압 귀족들이 함께 있더라 발락이 발람에게 이르되 '여호와께서 무슨 말씀을 하시더냐 ?' ");
INSERT INTO kor_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","발람이 노래를 지어 가로되 `발락이여 ! 일어나 들을지어다 십볼의 아들이여 ! 나를 자세히 들으라 ");
INSERT INTO kor_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","하나님은 인생이 아니시니 식언치 않으시고 인자가 아니시니 후회가 없으시도다 어찌 그 말씀하신 바를 행치 않으시며 하신 말씀을 실행치 않으시랴 ");
INSERT INTO kor_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","내가 축복의 명을 받았으니 그가 하신 축복을 내가 돌이킬 수 없도다 ");
INSERT INTO kor_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","여호와는 야곱의 허물을 보지 아니하시며 이스라엘의 패역을 보지 아니하시는도다 여호와 그의 하나님이 그와 함께 계시니 왕을 부르는 소리가 그 중에 있도다 ");
INSERT INTO kor_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","하나님이 그들을 애굽에서 인도하여 내셨으니 그 힘이 들소와 같도다 ");
INSERT INTO kor_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","야곱을 해할 사술이 없고 이스라엘을 해할 복술이 없도다 이 때에 야곱과 이스라엘에 대하여 논할진대 하나님의 행하신 일이 어찌 그리 크뇨 하리로다 ");
INSERT INTO kor_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","백성이 암사자 같이 일어나고 수사자 같이 일어나서 움킨 것을 먹으며 죽인 피를 마시기 전에는 눕지 아니하리로다 하매 ");
INSERT INTO kor_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","발락이 발람에게 이르되 `그들을 저주하지도 말고 축복하지도 말라' ");
INSERT INTO kor_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","발람이 발락에게 대답하여 가로되 `내가 당신에게 고하여 이르기를 여호와께서 말씀하신 것은 내가 그대로 하지 않을 수 없다고 하지 아니하더이까 ?' ");
INSERT INTO kor_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","발락이 발람에게 또 이르되 오라 내가 너를 다른 곳으로 인도하리니 네가 거기서 나를 위하여 그들을 저주하기를 하나님이 혹시 기뻐하시리라 하고 ");
INSERT INTO kor_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","발락이 발람을 인도하여 광야가 내려다 보이는 브올산 꼭대기에 이르니 ");
INSERT INTO kor_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","발람이 발락에게 이르되 `나를 위하여 여기 일곱 단을 쌓고 거기 수송아지 일곱과 수양 일곱을 준비하소서' ");
INSERT INTO kor_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","발락이 발람의 말대로 행하여 매 단에 수송아지 하나와 수양 하나를 드리니라 ");
INSERT INTO kor_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","발람이 자기와 이스라엘을 축복하는 것을 여호와께서 선히 여기심을 보고 전과 같이 사술을 쓰지 아니하고 그 낯을 광야로 향하여 ");
INSERT INTO kor_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","눈을 들어 이스라엘이 그 지파대로 거하는 것을 보는 동시에 하나님의 신이 그 위에 임하신지라 ");
INSERT INTO kor_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","그가 노래를 지어 가로되 브올의 아들 발람이 말하며 눈을 감았던 자가 말하며 ");
INSERT INTO kor_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","하나님의 말씀을 듣는 자, 전능자의 이상을 보는 자, 엎드려서 눈을 뜬 자가 말하기를 ");
INSERT INTO kor_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","야곱이여 ! 네 장막이, 이스라엘이여 ! 네 거처가 어찌 그리 아름다운고 ");
INSERT INTO kor_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","그 벌어짐이 골짜기 같고 강 가의 동산 같으며 여호와의 심으신 침향목들 같고 물가의 백향목들 같도다 ");
INSERT INTO kor_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","그 통에서는 물이 넘치겠고 그 종자는 많은 물가에 있으리로다 그 왕이 아각보다 높으니 그 나라가 진흥하리로다 ");
INSERT INTO kor_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","하나님이 그를 애굽에서 인도하여 내셨으니 그 힘이 들소와 같도다 그 적국을 삼키고 그들의 뼈를 꺽으며 화살로 쏘아 꿰뚫으리로다 ");
INSERT INTO kor_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","꿇어 앉고 누움이 수사자와 같고 암사자와도 같으니 일으킨 자 누구이랴 너를 축복하는 자마다 복을 받을 것이요 너를 저주하는 자마다 저주를 받을지어다 ! ");
INSERT INTO kor_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","발락이 발람에게 노하여 손뼉을 치며 발람에게 말하되 `내가 그대를 부른 것은 내 원수를 저주하라 함이어늘 그대가 이같이 세번 그들을 축복하였도다 ");
INSERT INTO kor_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","그러므로 그대는 이제 그대의 곳으로 달려가라 내가 그대를 높여 심히 존귀케 하기로 뜻하였더니 여호와가 그대를 막아 존귀치 못하게 하셨도다' ");
INSERT INTO kor_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","발람이 발락에게 이르되 `당신이 내게 보낸 사자들에게 내가 고하여 이르지 아니하였나이까 ? ");
INSERT INTO kor_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","가령 발락이 그 집에 은,금을 가득히 채워서 내게 줄지라도 나는 여호와의 말씀을 어기고 선악간 임의로 행하지 못하고 여호와께서 말씀하신 대로 말하리라 하지 아니하였나이까 ? ");
INSERT INTO kor_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","이제 나는 내 백성에게로 돌아가거니와 들으소서 내가 이 백성이 후일에 당신의 백성에게 어떻게 할 것을 당신에게 고하리이다'하고 ");
INSERT INTO kor_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","노래를 지어 가로되 브올의 아들 발람이 말하며 눈을 감았던 자가 말하며 ");
INSERT INTO kor_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","하나님의 말씀을 듣는 자가 말하며 지극히 높으신 자의 지식을 아는 자, 전능자의 이상을 보는 자, 엎드려서 눈을 뜬 자가 말하기를 ");
INSERT INTO kor_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","내가 그를 보아도 이 때의 일이 아니며 내가 그를 바라보아도 가까운 일이 아니로다 한 별이 야곱에게서 나오며 한 홀이 이스라엘에게서 일어나서 모압을 이 편에서, 저 편까지 파하고 또 소동하는 자식들을 다 멸하리로다 ");
INSERT INTO kor_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","그 원수 에돔은 그들의 산업이 되며, 그 원수 세일도 그들의 산업이 되고 그 동시에 이스라엘은 용감히 행동하리로다 ");
INSERT INTO kor_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","주권자가 야곱에게서 나서 남은 자들을 그 성읍에서 멸절하리로다 하고 ");
INSERT INTO kor_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","또 아말렉을 바라보며 노래를 지어 가로되 아말렉은 열국 중 으뜸이나 종말은 멸망에 이르리로다 하고 ");
INSERT INTO kor_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","또 가인 족속을 바라보며 노래를 지어 가로되 너의 거처가 견고하니 네 보금자리는 바위에 있도다 ");
INSERT INTO kor_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","그러나 가인이 쇠미하리니 나중에는 앗수르의 포로가 되리로다 하고 ");
INSERT INTO kor_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","또 노래를 지어 가로되 슬프다 하나님이 이 일을 행하시리니 그 때에 살 자가 누구이랴 ? ");
INSERT INTO kor_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","깃딤 해변에서 배들이 와서 앗수르를 학대하며 에벨을 괴롭게 하리라마는 그도 멸망하리로다 하고 ");
INSERT INTO kor_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","발람이 일어나 자기 곳으로 돌아갔고 발락도 자기 길로 갔더라 ");
INSERT INTO kor_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","이스라엘이 싯딤에 머물러 있더니 그 백성이 모압 여자들과 음행하기를 시작하니라 ");
INSERT INTO kor_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","그 여자들이 그 신들에게 제사할 때에 백성을 청하매 백성이 먹고 그들의 신들에게 절하므로 ");
INSERT INTO kor_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","이스라엘이 바알브올에게 부속된지라 여호와께서 이스라엘에게 진노하시니라 ");
INSERT INTO kor_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","여호와께서 모세에게 이르시되 백성의 두령들을 잡아 태양을 향하여 여호와 앞에 목매어 달라 그리하면 여호와의 진노가 이스라엘을 떠나리라 ");
INSERT INTO kor_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","모세가 이스라엘 사사들에게 이르되 너희는 각기 관할하는 자 중에 바알브올에게 부속한 사람들을 죽이라 하니라 ");
INSERT INTO kor_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","이스라엘 자손의 온 회중이 회막 문에서 울 때에 한 사람이 모세와 온 회중의 목전에 미디안의 한 여인을 데리고 그 형제에게로 온지라 ");
INSERT INTO kor_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","제사장 아론의 손자 엘르아살의 아들 비느하스가 보고 회중의 가운데서 일어나 손에 창을 들고 ");
INSERT INTO kor_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","그 이스라엘 남자를 따라 그의 막에 들어가서 이스라엘 남자와 그 여인의 배를 꿰뚫어서 두 사람을 죽이니 염병이 이스라엘 자손에게서 그쳤더라 ");
INSERT INTO kor_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","그 염병으로 죽은 자가 이만 사천명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","제사장 아론의 손자 엘르아살의 아들 비느하스가 나의 질투심으로 질투하여 이스라엘 자손 중에서 나의 노를 돌이켜서 나의 질투심으로 그들을 진멸하지 않게 하였도다 ");
INSERT INTO kor_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","그러므로 말하라 내가 그에게 나의 평화의 언약을 주리니 ");
INSERT INTO kor_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","그와 그 후손에게 영원한 제사장 직분의 언약이라 그가 그 하나님을 위하여 질투하여 이스라엘 자손을 속죄하였음이니라 ");
INSERT INTO kor_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","죽임을 당한 이스라엘 남자 곧 미디안 여인과 함께 죽임을 당한 자의 이름은 시므리니 살루의 아들이요 시므온인의 종족 중 한 족장이며 ");
INSERT INTO kor_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","죽임을 당한 미디안 여인의 이름은 고스비니 수르의 딸이라 수르는 미디안 백성 한 종족의 두령이었더라 ");
INSERT INTO kor_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","미디안인들을 박해하며 그들을 치라 ");
INSERT INTO kor_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","이는 그들이 궤계로 너희를 박해하되 브올의 일과 미디안 족장의 딸 곧 브올의 일로 염병이 일어난 날에 죽임을 당한 그들의 자매 고스비의 사건으로 너희를 유혹하였음이니라 ");
INSERT INTO kor_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","염병 후에 여호와께서 모세와 제사장 아론의 아들 엘르아살에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","이스라엘 자손의 온 회중의 총수를 그 조상의 집을 따라 조사하되 이스라엘 중에 무릇 이십세 이상으로 능히 싸움에 나갈 만한 자를 계수하라 하시니 ");
INSERT INTO kor_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","모세와 제사장 엘르아살이 여리고 맞은편 요단 가 모압 평지에서 그들에게 고하여 가로되 ");
INSERT INTO kor_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","`여호와께서 애굽 땅에서 나온 모세와 이스라엘 자손에게 명하신대로 너희는 이십세 이상된 자를 계수하라' 하시니 ");
INSERT INTO kor_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","이스라엘의 장자는 르우벤이라 르우벤 자손은 하녹에게서 난 하녹 가족과, 발루에게서 난 발루 가족과 ");
INSERT INTO kor_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","헤스론에게서 난 헤스론 가족과, 갈미에게서 난 갈미 가족이니 ");
INSERT INTO kor_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","이는 르우벤 가족들이라 계수함을 입은 자가 사만 삼천 칠백 삼십명이요 ");
INSERT INTO kor_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","발루의 아들은 엘리압이요 ");
INSERT INTO kor_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","엘리압의 아들은 느무엘과, 다단과, 아비람이라 이 다단과, 아비람은 회중 가운데서 부름을 받은 자러니 고라의 무리에 들어가서 모세와 아론을 거스려 여호와께 패역할 때에 ");
INSERT INTO kor_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","땅이 그 입을 열어서 그 무리와 고라를 삼키매 그들이 죽었고 당시에 불이 이백 오십명을 삼켜 징계가 되게 하였으나 ");
INSERT INTO kor_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","그러나 고라의 아들들은 죽지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","시므온 자손은 그 종족대로 이러하니 느무엘에게서 난 느무엘 가족과, 야민에게서 난 야민 가족과, 야긴에게서 난 야긴 가족과 ");
INSERT INTO kor_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","세라에게서 난 세라 가족과, 사울에게서 난 사울 가족이라 ");
INSERT INTO kor_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","이는 시므온 종족들이니 계수함을 입은 자가 이만 이천 이백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","갓 자손은 그 종족대로 이러하니 스본에게서 난 스본 가족과, 학기에게서 난 학기 가족과, 수니에게서 난 수니 가족과 ");
INSERT INTO kor_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","오스니에게서 난 오스니 가족과, 에리에게서 난 에리 가족과 ");
INSERT INTO kor_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","아롯에게서 난 아롯 가족과, 아렐리에게서 난 아렐리 가족이라 ");
INSERT INTO kor_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","이는 갓 자손의 종족들이니 계수함을 입은 자가 사만 오백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","유다의 아들은 에르와, 오난이라 이 에르와 오난은 가나안 땅에서 죽었고 ");
INSERT INTO kor_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","유다의 자손은 그 종족대로 이러하니 셀라에게서 난 셀라 가족과, 베레스에게서 난 베레스 가족과, 세라에게서 난 세라 가족이며 ");
INSERT INTO kor_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","또 베레스 자손은 이러하니 헤스론에게서 난 헤스론 가족과, 하물에게서 난 하물 가족이라 ");
INSERT INTO kor_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","이는 유다 종족들이니 계수함을 입은 자가 칠만 육천 오백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","잇사갈 자손은 그 종족대로 이러하니 돌라에게서 난 돌라 가족과, 부와에게서 난 부니 가족과 ");
INSERT INTO kor_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","야숩에게서 난 야숩 가족과 시므론에게서 난 시므론 가족이라 ");
INSERT INTO kor_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","이는 잇사갈 종족들이니 계수함을 입은 자가 육만 사천 삼백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","스불론 자손들은 그 종족대로 이러하니 세렛에게서 난 세렛 가족과, 엘론에게서 난 엘론 가족과, 얄르엘에게서 난 얄르엘 가족이라 ");
INSERT INTO kor_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","이는 스불론 종족들이니 계수함을 입은 자가 육만 오백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","요셉의 아들들은 그 종족대로 므낫세와 에브라임이요 ");
INSERT INTO kor_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","므낫세의 자손 중 마길에게서 난 것은 마길 가족이라 마길이 길르앗을 낳았고 길르앗에게서 난 것은 길르앗 가족이라 ");
INSERT INTO kor_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","길르앗 자손은 이러하니 이에셀에게서 난 이에셀 가족과, 헬렉에게서 난 헬렉 가족과 ");
INSERT INTO kor_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","아스리엘에게서 난 아스리엘 가족과, 세겜에게서 난 세겜 가족과 ");
INSERT INTO kor_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","스미다에게서 난 스미다 가족과, 헤벨에게서 난 헤벨 가족이며 ");
INSERT INTO kor_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","헤벨의 아들 슬로브핫은 아들이 없고 딸 뿐이라 그 딸의 이름은 말라와, 노아와, 호글라와, 밀가와, 디르사니 ");
INSERT INTO kor_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","이는 므낫세의 종족들이라 계수함을 입은 자가 오만 이천 칠백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","에브라임 자손은 그 종족대로 이러하니 수델라에게서 난 수델라 가족과, 베겔에게서 난 베겔 가족과, 다한에게서 난 다한 가족이며 ");
INSERT INTO kor_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","수델라 자손은 이러하니 에란에게서 난 에란 가족이라 ");
INSERT INTO kor_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","이는 에브라임 자손의 종족들이니 계수함을 입은 자가 삼만 이천 오백명이라 이상은 그 종족을 따른 요셉 자손이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","베냐민 자손들은 그 종족대로 이러하니 벨라에게서 난 벨라 가족과, 아스벨에게서 난 아스벨 가족과, 아히람에게서 난 아히람 가족과 ");
INSERT INTO kor_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","스부밤에게서 난 스부밤 가족과, 후밤에게서 난 후밤 가족이며 ");
INSERT INTO kor_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","벨라의 아들은 아릇과, 나아만이라 아릇에게서 아릇 가족과, 나아만에게서 나아만 가족이 났으니 ");
INSERT INTO kor_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","이는 그들의 종족을 따른 베냐민 자손이라 계수함을 입은 자가 사만 오천 육백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","단 자손은 그 종족대로 이러하니라 수함에게서 수함 가족이 났으니 이는 그들의 종족을 따른 단 가족들이라 ");
INSERT INTO kor_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","수함 모든 가족의 계수함을 입은 자가 육만 사천 사백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","아셀 자손은 그 종족대로 이러하니 임나에게서 난 임나 가족과, 이스위에게서 난 이스위 가족과, 브리아에게서 난 브리아 가족이며 ");
INSERT INTO kor_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","브리아의 자손 중 헤벨에게서 난 헤벨 가족과, 말기엘에게서 난 말기엘 가족이며 ");
INSERT INTO kor_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","아셀의 딸의 이름은 세라라 ");
INSERT INTO kor_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","이는 아셀 자손의 종족들이니 계수함을 입은 자가 오만 삼천 사백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","납달리 자손은 그 종족대로 이러하니 야셀에게서 난 야셀 가족과, 구니에게서 난 구니 가족과 ");
INSERT INTO kor_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","예셀에게서 난 예셀 가족과, 실렘에게서 난 실렘 가족이라 ");
INSERT INTO kor_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","이는 그 종족을 따른 납달리 가족들이니 계수함을 입은 자가 사만 오천 사백명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","이스라엘 자손의 계수함을 입은 자가 육십만 일천 칠백 삼십명이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","이 계수대로 땅을 나눠 주어 기업을 삼게 하라 ");
INSERT INTO kor_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","수가 많은 자에게는 기업을 많이 줄 것이요 수가 적은 자에게는 기업을 적게 줄 것이니 그들의 계수함을 입은 수대로 각기 기업을 주되 ");
INSERT INTO kor_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","오직 그 땅을 제비뽑아 나누어 그들의 조상 지파의 이름을 따라 얻게 할지니라 ");
INSERT INTO kor_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","그 다소를 물론하고 그 기업을 제비 뽑아 나눌지니라 ");
INSERT INTO kor_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","레위인의 계수함을 입은 자는 그 종족대로 이러하니 게르손에게서 난 게르손 가족과, 고핫에게서 난 고핫 가족과, 므라리에게서 난 므라리 가족이며 ");
INSERT INTO kor_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","레위 종족들은 이러하니 립니 가족과, 헤브론 가족과, 말리 가족과, 무시 가족과, 고라 가족이라, 고핫은 아므람을 낳았으며 ");
INSERT INTO kor_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","아므람의 처의 이름은 요게벳이니 레위의 딸이요 애굽에서 레위에게서 난 자라 그가 아므람에게서 아론과 모세와 그 누이 미리암을 낳았고 ");
INSERT INTO kor_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","아론에게서는 나답과, 아비후와, 엘르아살과, 이다말이 났더니 ");
INSERT INTO kor_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","나답과 아비후는 다른 불을 여호와 앞에 드리다가 죽었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","레위인의 일개월 이상으로 계수함을 입은 모든 남자가 이만 삼천명이었더라 그들은 이스라엘 자손 중 계수에 들지 아니하였으니 이는 이스라엘 자손 중에서 그들에게 준 기업이 없음이었더라 ");
INSERT INTO kor_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","이는 모세와 제사장 엘르아살의 계수한 자라 그들이 여리고 맞은편 요단 가 모압 평지에서 이스라엘 자손을 계수한 중에는 ");
INSERT INTO kor_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","모세와 제사장 아론이 시내 광야에서 계수한 이스라엘 자손은 한사람도 들지 못하였으니 ");
INSERT INTO kor_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","이는 여호와께서 그들에게 대하여 말씀하시기를 그들이 반드시 광야에서 죽으리라 하셨음이라 이러므로 여분네의 아들 갈렙과 눈의 아들 여호수아 외에는 한 사람도 남지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","요셉의 아들 므낫세 가족에 므낫세의 현손, 마길의 증손, 길르앗의 손자 헤벨의 아들 슬로브핫의 딸들이 나아왔으니 그 딸들의 이름은 말라와, 노아와, 호글라와, 밀가와, 디르사라 ");
INSERT INTO kor_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","그들이 회막 문에서 모세와 제사장 엘르아살과 족장들과 온 회중앞에 서서 가로되 ");
INSERT INTO kor_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","`우리 아버지가 광야에서 죽었으나 여호와를 거스려 모인 고라의 무리에 들지 아니하고 자기 죄에 죽었고 아들이 없나이다 ");
INSERT INTO kor_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","어찌하여 아들이 없다고 우리 아버지의 이름이 그 가족 중에서 삭제되리이까 ? 우리 아버지의 형제 중에서 우리에게 기업을 주소서' 하매 ");
INSERT INTO kor_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","모세가 그 사연을 여호와께 품하니라 ");
INSERT INTO kor_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","슬로브핫 딸들의 말이 옳으니 너는 반드시 그들의 아비의 형제 중에서 그들에게 기업을 주어 얻게 하되 그 아비의 기업으로 그들에게 돌릴지니라 ");
INSERT INTO kor_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","너는 이스라엘 자손에게 고하여 이르기를 사람이 죽고 아들이 없거든 그 기업을 그 딸에게 돌릴 것이요 ");
INSERT INTO kor_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","딸도 없거든 그 기업을 그 형제에게 줄 것이요 ");
INSERT INTO kor_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","형제도 없거든 그 기업을 그 아비의 형제에게 줄 것이요 ");
INSERT INTO kor_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","그 아비의 형제도 없거든 그 기업을 가장 가까운 친족에게 주어 얻게 할지니라 하고 나 여호와가 너 모세에게 명한 대로 이스라엘 자손에게 판결의 율례가 되게 할지니라 ");
INSERT INTO kor_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","여호와께서 모세에게 이르시되 너는 이 아바림 산에 올라가서 내가 이스라엘 자손에게 준 땅을 바라보라 ");
INSERT INTO kor_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","본 후에는 네 형 아론의 돌아간 것같이 너도 조상에게로 돌아가리니 ");
INSERT INTO kor_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","이는 신 광야에서 회중이 분쟁할 제 너희가 내 명을 거역하고 그 물 가에서 나의 거룩함을 그들의 목전에 나타내지 아니하였음이니라 이 물은 신 광야 가데스의 므리바 물이니라 ");
INSERT INTO kor_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","모세가 여호와께 여짜와 가로되 ");
INSERT INTO kor_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","`여호와 모든 육체의 생명의 하나님이시여 ! 원컨대 한 사람을 이 회중 위에 세워서 ");
INSERT INTO kor_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","그로 그들 앞에 출입하며 그들을 인도하여 출입하게 하사 여호와의 회중으로 목자없는 양과 같이 되지 않게 하옵소서 !' ");
INSERT INTO kor_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","여호와께서 모세에게 이르시되 눈의 아들 여호수아는 신에 감동된 자니 너는 데려다가 그에게 안수하고 ");
INSERT INTO kor_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","그를 제사장 엘르아살과 온 회중 앞에 세우고 그들의 목전에서 그에게 위탁하여 ");
INSERT INTO kor_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","네 존귀를 그에게 돌려 이스라엘 자손의 온 회중으로 그에게 복종하게 하라 ");
INSERT INTO kor_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","그는 제사장 엘르아살 앞에 설 것이요 엘르아살은 그를 위하여 우림의 판결법으로 여호와 앞에 물을 것이며 그와 온 이스라엘 자손 곧 온 회중은 엘르아살의 말을 좇아 나가며 들어올 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","모세가 여호와께서 자기에게 명하신 대로 하여 여호수아를 데려다가 제사장 엘르아살과 온 회중 앞에 세우고 ");
INSERT INTO kor_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","이스라엘 자손에게 명하여 그들에게 이르라 나의 예물, 나의 식물되는 화제, 나의 향기로운 것은 너희가 그 정한 시기에 삼가 내게 드릴지니라 ");
INSERT INTO kor_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","또 그들에게 이르라 너희가 여호와께 드릴 화제는 이러하니 일년되고 흠 없는 수양을 매일 둘씩 상번제로 드리되 ");
INSERT INTO kor_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","한 어린 양은 아침에 드리고, 한 어린 양은 해 질 때에 드릴 것이요 ");
INSERT INTO kor_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","또 고운 가루 에바 십분지 일에 빻아낸 기름 힌 사분지 일을 섞어서 소제로 드릴 것이니 ");
INSERT INTO kor_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","이는 시내산에서 정한 상번제로서 여호와께 드리는 향기로운 화제며 ");
INSERT INTO kor_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","또 그 전제는 어린 양 하나에 힌 사분지 일을 드리되 거룩한 곳에서 여호와께 독주의 전제를 부어 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","해질 때에는 그 한 어린 양을 드리되 그 소제와 전제를 아침 것같이 여호와께 향기로운 화제로 드릴 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","안식일에는 일년 되고 흠 없는 수양 둘과 고운 가루 에바 십분지 이에 기름 섞은 소제와 그 전제를 드릴 것이니 ");
INSERT INTO kor_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","이는 매 안식일의 번제라 상번제와 그 전제 외에니라 ");
INSERT INTO kor_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","월삭에는 수송아지 둘과 수양 하나와 일년 되고 흠없는 수양 일곱으로 여호와께 번제를 드리되 ");
INSERT INTO kor_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","매 수송아지에는 고운 가루 에바 십분지 삼에, 기름 섞은 소제와 수양 하나에는 고운 가루 에바 십분지 이에 기름 섞은 소제와 ");
INSERT INTO kor_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","매 어린 양에는 고운 가루 에바 십분지 일에, 기름 섞은 소제를 향기로운 번제로 여호와께 화제로 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","그 전제는 수송아지 하나에 포도주 반 힌이요, 수양 하나에 삼분지 일 힌이요 어린 양 하나에 사분지 일 힌이니 이는 일년 중 매 월삭의 번제며 ");
INSERT INTO kor_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","또 상번제와 그 전제 외에 수염소 하나를 속죄제로 여호와께 드릴 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","정월 십사일은 여호와의 유월절이며 ");
INSERT INTO kor_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","또 그달 십오일 부터는 절일이니 칠일동안 무교병을 먹을 것이며 ");
INSERT INTO kor_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","그 첫날에는 성회로 모일 것이요 아무 노동도 하지 말 것이며 ");
INSERT INTO kor_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","수송아지 둘과 수양 하나와 일년 된 수양 일곱을 다 흠없는 것으로 여호와께 화제를 드려 번제가 되게 할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","그 소제로는 고운 가루에 기름을 섞어서 쓰되 수송아지 하나에는 에바 십분지 삼이요 수양 하나에는 에바 십분지 이를 드리고 ");
INSERT INTO kor_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","어린 양 일곱에는 매 어린 양에 에바 십분지 일을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","또 너희를 속하기 위하여 수염소 하나로 속죄제를 드리되 ");
INSERT INTO kor_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","아침의 번제 곧 상번제 외에 그것들을 드릴 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","너희는 이 순서대로 칠일 동안 매일 여호와께 향기로운 화제의 식물을 드리되 상번제와 그 전제 외에 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","제 칠일에는 성회로 모일 것이요 아무 노동도 하지 말 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","칠칠절 처음 익은 열매 드리는 날에 너희가 여호와께 새 소제를 드릴 때에도 성회로 모일 것이요 아무 노동도 하지 말 것이며 ");
INSERT INTO kor_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","수 송아지 둘과 수양 하나와 일년 된 수양 일곱으로 여호와께 향기로운 번제를 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","그 소제로는 고운 가루에 기름을 섞어서 쓰되 매 수송아지에는 에바 십분지 삼이요, 수양 하나에는 에바 십분지 이요 ");
INSERT INTO kor_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","어린 양 일곱에는 매 어린 양에 에바 십분지 일을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","또 너희를 속하기 위하여 수염소 하나를 드리되 ");
INSERT INTO kor_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","너희는 다 흠 없는 것으로 상번제와 그 소제와 전제 외에 그것들을 드릴 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","칠월에 이르러는 그 달 초일일에 성회로 모이고 아무 노동도 하지 말라 이는 너희가 나팔을 불 날이니라 ");
INSERT INTO kor_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","너희는 수송아지 하나와 수양 하나와 일년 되고 흠 없는 수양 일곱을 여호와께 향기로운 번제로 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","그 소제로는 고운 가루에 기름을 섞어서 쓰되 수송아지에는 에바 십분지 삼이요, 수양에는 에바 십분지 이요 ");
INSERT INTO kor_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","어린 양 일곱에는 매 어린 양에 에바 십분지 일을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","또 너희를 속하기 위하여 수염소 하나를 속죄제로 드리되 ");
INSERT INTO kor_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","월삭의 번제와 그 소제와 상번제와 그 소제와 그 전제 외에 그 규례를 따라 향기로운 화제로 여호와께 드릴 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","칠월 십일에는 너희가 성회로 모일 것이요 마음을 괴롭게 하고 아무 노동도 하지 말 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","너희는 수송아지 하나와 수양 하나와 일년 된 수양 일곱을 다 흠없는 것으로 여호와께 향기로운 번제를 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","그 소제로는 고운 가루에 기름을 섞어서 쓰되 수송아지 하나에는 에바 십분지 삼이요, 수양 하나에는 에바 십분지 이요 ");
INSERT INTO kor_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","어린 양 일곱에는 매 어린 양에 에바 십분지 일을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","또 수염소 하나를 속죄제로 드릴 것이니 이는 속죄제와 상번제와 그 소제와 그 전제 외에니라 ");
INSERT INTO kor_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","칠월 십오일에는 너희가 너희 성회로 모일 것이요 아무 노동도 하지 말 것이며 칠일 동안 여호와 앞에 절기를 지킬 것이라 ");
INSERT INTO kor_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","너희 번제로 여호와께 향기로운 화제를 드리되 수 송아지 열셋과 수양 둘과 일년된 수양 열 넷을 다 흠 없는 것으로 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","그 소제로는 고운 가루에 기름을 섞어서 수송아지 열셋에는 각기 에바 십분지 삼이요, 수양 둘에는 각기 에바 십분지 이요 ");
INSERT INTO kor_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","어린 양 열넷에는 각기 에바 십분지 일을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","또 수염소 하나를 속죄제로 드릴지니 상번제와 그 소제와 그 전제 외에니라 ");
INSERT INTO kor_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","둘째 날에는 수송아지 열둘과 수양 둘과 일년 되고 흠 없는 수양 열넷을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","그 소제와 전제는 수송아지와 수양과 어린 양의 수효를 따라서 규례대로 할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","또 수염소 하나를 속죄제로 드릴지니 상번제와 그 소제와 그 전 제 외에니라 ");
INSERT INTO kor_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","세째 날에는 수송아지 열 하나와 수양 둘과 일년 되고 흠없는 수양 열넷을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","그 소제와 전제는 수송아지와 수양과 어린 양의 수효를 따라서 규례대로 할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","또 수염소 하나를 속죄제로 드릴지니 상번제와 그 소제와 그 전제 외에니라 ");
INSERT INTO kor_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","네째 날에는 수송아지 열과 수양 둘과 일년 되고 흠 없는 수양 열넷을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","그 소제와 전제는 수송아지와 수양과 어린 양의 수효를 따라서 규례대로 할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","또 수염소 하나를 속죄제로 드릴지니 상번제와 그 소제와 그 전제 외에니라 ");
INSERT INTO kor_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","다섯째 날에는 수송아지 아홉과 수양 둘과 일년 되고 흠없는 수양 열넷을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","그 소제와 전제는 수송아지와 수양과 어린 양의 수효를 따라서 규례대로 할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","또 수염소 하나를 속죄제로 드릴지니 상번제와 그 소제와 그 전제 외에니라 ");
INSERT INTO kor_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","여섯째 날에는 수송아지 여덟과 수양 둘과 일년 되고 흠없는 수양 열넷을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","그 소제와 전제는 수송아지와 수양과 어린 양의 수효를 따라서 규례대로 할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","또 수염소 하나를 속죄제로 드릴지니 상번제와 그 소제와 그 전제 외에니라 ");
INSERT INTO kor_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","일곱째 날에는 수송아지 일곱과 수양 둘과 일년 되고 흠 없는 수양 열넷을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","그 소제와 전제는 수송아지와 수양과 어린 양의 수효를 따라서 규례대로 할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","또 수염소 하나를 속죄제로 드릴지니 상번제와 그 소제와 그 전제 외에니라 ");
INSERT INTO kor_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","여덟째 날에는 거룩한 대회로 모일 것이요 아무 노동도 하지 말것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","번제로 여호와께 향기로운 화제를 드리되 수송아지 하나와 수양 하나와 일년 되고 흠 없는 수양 일곱을 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","그 소제와 전제는 수송아지와 수양과 어린 양의 수효를 따라서 규례대로 할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","또 수염소 하나를 속죄제로 드릴지니 상번제와 그 소제와 그 전제 외에니라 ");
INSERT INTO kor_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","너희가 이 절기를 당하거든 여호와께 이같이 드릴지니 이는 너희 서원제나 낙헌제외에 번제, 소제, 전제, 화목제를 드릴 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","모세가 여호와께서 자기로 명하신 모든 일을 이스라엘 자손에게 고하니라 ");
INSERT INTO kor_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","모세가 이스라엘 자손 지파의 두령들에게 일러 가로되 여호와의 명령이 이러하니라 ");
INSERT INTO kor_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","사람이 여호와께 서원하였거나 마음을 제어하기로 서약하였거든 파약하지 말고 그 입에서 나온 대로 다 행할 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","또 여자가 만일 어려서 그 아비 집에 있을 때에 여호와께 서원한 일이나 스스로 제어하려 한 일이 있다 하자 ");
INSERT INTO kor_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","그 아비가 그의 서원이나 그 마음을 제어하려는 서약을 듣고도 그에게 아무 말이 없으면 그 모든 서원을 행할 것이요 그 마음을 제어하려는 서약을 지킬 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","그러나 그 아비가 그것을 듣는 날에 허락지 아니하면 그 서원과 마음을 제어하려던 서약이 이루지 못할 것이니 그 아비가 허락지 아니하였은즉 여호와께서 사하시리라 ");
INSERT INTO kor_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","또 혹시 남편을 맞을 때에 서원이나 마음을 제어 하려는 서약을 경솔히 그 입에서 발하였다 하자 ");
INSERT INTO kor_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","그 남편이 그것을 듣고 그 듣는 날에 그에게 아무 말이 없으면 그 서원을 행할 것이요 그 마음을 제어하려는 서약을 지킬 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","그러나 그 남편이 그것을 듣는 날에 허락지 아니하면 그 서원과 마음을 제어하려고 경솔히 입술에서 발한 서약이 무효될 것이니 여호와께서 그 여자를 사하시리라 ");
INSERT INTO kor_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","과부나 이혼당한 여자의 서원이나 무릇 그 마음을 제어하려는 서약은 지킬 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","부녀가 혹시 그 남편의 집에 있어 서원을 하였다든지 마음을 제어하려고 서약하였다 하자 ");
INSERT INTO kor_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","그 남편이 그것을 듣고도 아무 말이 없고 금함이 없으면 그 서원은 무릇 행할 것이요 그 마음을 제어하려는 서약은 무릇 지킬 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","그러나 그 남편이 그것을 듣는 날에 무효케 하면 그 서원과 마음을 제어하려던 일에 대하여 입술에서 낸 것을 무엇이든지 이루지 못하나니 그 남편이 그것을 무효케 하였은즉 여호와께서 그 부녀를 사하시느니라 ");
INSERT INTO kor_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","무릇 서원과 무릇 마음을 괴롭게 하려는 서약은 그 남편이 그것을 지키게도 할 수 있고 무효케도 할 수 있나니 ");
INSERT INTO kor_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","그 남편이 일향 말이 없으면 아내의 서원과 스스로 제어하려는 일을 지키게 하는 것이니 이는 그가 그것을 들을 때에 그 아내에게 아무 말도 아니하였으므로 지키게 됨이니라 ");
INSERT INTO kor_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","그러나 그 남편이 들은 지 얼마 후에 그것을 무효케 하면 그가 아내의 죄를 담당할 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","이는 여호와께서 모세에게 명하신 율례니 남편이 아내에게, 아비가 자기 집에 있는 유년 여자에게 대한 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","이스라엘 자손의 원수를 미디안에게 갚으라 그 후에 네가 네 조상에게로 돌아가리라 ");
INSERT INTO kor_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","모세가 백성에게 일러 가로되 `너희 중에서 사람을 택하여 싸움에 나갈 준비를 시키고 미디안을 치러 보내어서 여호와의 원수를 미디안에게 갚되 ");
INSERT INTO kor_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","이스라엘 모든 지파에 대하여 각 지파에서 일천인씩을 싸움에 보낼지니라' 하매 ");
INSERT INTO kor_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","매 지파에서 일천인씩 이스라엘 천만인 중에서 일만 이천인을 택하여 무장을 시킨지라 ");
INSERT INTO kor_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","모세가 매 지파에 일천인씩 싸움에 보내되 제사장 엘르아살의 아들 비느하스에게 성소의 기구와 신호 나팔을 들려서 그들과 함께 싸움에 보내매 ");
INSERT INTO kor_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","그들이 여호와께서 모세에게 명하신 대로 미디안을 쳐서 그 남자를 다 죽였고 ");
INSERT INTO kor_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","그 죽인 자 외에 미디안의 다섯 왕을 죽였으니 미디안의 왕들은 에위와, 레겜과, 수르와, 후르와, 레바이며 또 브올의 아들 발람을 칼로 죽였더라 ");
INSERT INTO kor_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","이스라엘 자손이 미디안의 부녀들과 그 아이들을 사로잡고 그 가축과 양떼와 재물을 다 탈취하고 ");
INSERT INTO kor_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","그 거처하는 성읍들과 촌락을 다 불사르고 ");
INSERT INTO kor_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","탈취한 것, 노략한 것, 사람과, 짐승을 다 취하니라 ");
INSERT INTO kor_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","그들이 사로잡은 자와 노략한 것과 탈취한 것을 가지고 여리고 맞은편 요단 가 모압 평지의 진에 이르러 모세와 제사장 엘르아살과 이스라엘 자손의 회중에게로 나아오니라 ");
INSERT INTO kor_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","모세와 제사장 엘르아살과 회중의 족장들이 다 진 밖에 나가서 영접하다가 ");
INSERT INTO kor_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","모세가 군대의 장관 곧 싸움에서 돌아온 천부장들과 백부장들에게 노하니라 ");
INSERT INTO kor_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","모세가 그들에게 이르되 너희가 여자들을 다 살려두었느냐 ? ");
INSERT INTO kor_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","보라 이들이 발람의 꾀를 좇아 이스라엘 자손으로 브올의 사건에 여호와 앞에 범죄케 하여 여호와의 회중에 염병이 일어나게 하였느니라 ");
INSERT INTO kor_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","그러므로 아이들 중에 남자는 다 죽이고 남자와 동침하여 사내를 안 여자는 다 죽이고 ");
INSERT INTO kor_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","남자와 동침하지 아니하여 사내를 알지 못하는 여자들은 다 너희를 위하여 살려둘 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","너희는 칠일동안 진 밖에 주둔하라 무릇 살인자나 죽임을 당한 시체를 만진 자나 제 삼일과 제 칠일에 몸을 깨끗케 하고 너희의 포로도 깨끗케 할 것이며 ");
INSERT INTO kor_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","무릇 의복과 무릇 가죽으로 만든 것과 무릇 염소 털로 만든 것과 무릇 나무로 만든 것을 다 깨끗케 할지니라 ");
INSERT INTO kor_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","제사장 엘르아살이 싸움에 나갔던 군인들에게 이르되 `이는 여호와께서 모세에게 명하신 법률이니라 ");
INSERT INTO kor_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","금, 은, 동, 철과 상납과 납의 ");
INSERT INTO kor_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","무릇 불에 견딜 만한 물건은 불을 지나게 하라 그리하면 깨끗하려니와 오히려 정결케 하는 물로 그것을 깨끗케 할 것이며 무릇 불에 견디지 못할 모든 것은 물을 지나게 할 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","너희는 제 칠일에 옷을 빨아서 깨끗케 한 후에 진에 들어 올지니라' ");
INSERT INTO kor_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","너는 제사장 엘르아살과 회중의 족장들을 더불어 이 탈취한 사람과 짐승을 계수하고 ");
INSERT INTO kor_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","그 얻은 물건을 반분하여 그 절반은 싸움에 나갔던 군인들에게 주고 절반은 회중에게 주고 ");
INSERT INTO kor_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","싸움에 나갔던 군인들로는 사람이나 소나 나귀나 양떼의 오백분지 일을 여호와께 드리게 하되 ");
INSERT INTO kor_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","곧 이를 그들의 절반에서 취하여 여호와의 거제로 제사장 엘르아살에게 주고 ");
INSERT INTO kor_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","또 이스라엘 자손의 얻은 절반에서는 사람이나 소나 나귀나 양떼나 각종 짐승을 오십분지 일을 취하여 여호와의 성막을 맡은 레위인에게 주라 ");
INSERT INTO kor_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","모세와 제사장 엘르아살이 여호와께서 모세에게 명하신 대로 하니라 ");
INSERT INTO kor_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","그 탈취물 곧 군인들의 다른 탈취물 외에 양이 육십 칠만 오천이요 ");
INSERT INTO kor_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","소가 칠만 이천이요 ");
INSERT INTO kor_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","나귀가 육만 일천이요 ");
INSERT INTO kor_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","사람은 남자와 동침하지 아니하여서 사내를 알지 못하는 여자가 도합 삼만 이천이니 ");
INSERT INTO kor_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","그 절반 곧 싸움에 나갔던 자들의 소유가 양이 삼십 삼만 칠천 오백이라 ");
INSERT INTO kor_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","여호와께 세로 드린 양이 육백 칠십 오요 ");
INSERT INTO kor_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","소가 삼만 육천이라 그 중에서 여호와께 세로 드린 것이 칠십 이두요 ");
INSERT INTO kor_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","나귀가 삼만 오백이라 그 중에서 여호와께 세로 드린 것이 육십 일이요 ");
INSERT INTO kor_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","사람이 일만 육천이라 그 중에서 여호와께 세로 드린 자가 삼십 이명이니 ");
INSERT INTO kor_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","여호와께 거제의 세로 드린 것을 모세가 제사장 엘르아살에게 주었으니 여호와께서 모세에게 명하심과 같았더라 ");
INSERT INTO kor_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","모세가 싸움에 나갔던 자에게서 나누어 취하여 이스라엘 자손에게 준 절반 ");
INSERT INTO kor_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","곧 회중의 얻은 절반은 양이 삼십 삼만 칠천 오백이요 ");
INSERT INTO kor_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","소가 삼만 육천이요 ");
INSERT INTO kor_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","나귀가 삼만 오백이요 ");
INSERT INTO kor_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","사람이 일만 육천이라 ");
INSERT INTO kor_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","이스라엘 자손의 그 절반에서 모세가 사람이나 짐승의 오십분지 일을 취하여 여호와의 장막을 맡은 레위인에게 주었으니 여호와께서 모세에게 명하심과 같았더라 ");
INSERT INTO kor_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","군대의 장관들 곧 천부장과 백부장들이 모세에게 나아와서 ");
INSERT INTO kor_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","그에게 고하되 `당신의 종들의 영솔한 군인을 계수한즉 우리 중 한 사람도 축나지 아니하였기로 ");
INSERT INTO kor_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","우리 각 사람의 얻은 바 금 패물 곧 발목고리, 손목고리, 인장반지, 귀고리, 팔고리들을 여호와의 예물로 우리의 생명을 위하여 여호와 앞에 속죄하려고 가져왔나이다' ");
INSERT INTO kor_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","모세와 제사장 엘르아살이 그들에게서 그 금으로 만든 모든 패물을 취한즉 ");
INSERT INTO kor_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","천부장과 백부장들이 여호와께 드린 거제의 금의 도합이 일만 육천 칠백 오십 세겔이니 ");
INSERT INTO kor_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","군인들이 각기 자기를 위하여 탈취한 것이라 ");
INSERT INTO kor_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","모세와 제사장 엘르아살이 천부장과 백부장들에게서 금을 취하여 회막에 드려서 여호와 앞에 이스라엘 자손의 기념을 삼았더라 ");
INSERT INTO kor_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","르우벤 자손과 갓 자손은 심히 많은 가축 떼가 있었더라 그들이 야셀 땅과 길르앗 땅을 본즉 그 곳은 가축에 적당한 곳인지라 ");
INSERT INTO kor_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","갓 자손과 르우벤 자손이 와서 모세와 제사장 엘르아살과 회중 족장들에게 말하여 가로되 ");
INSERT INTO kor_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","`아다롯과, 디본과, 야셀과, 니므라와, 헤스본과, 엘르알레와, 스밤과, 느보와, 브온 ");
INSERT INTO kor_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","곧 여호와께서 이스라엘 회중 앞에서 쳐서 멸하신 땅은 가축에 적당한 곳이요 당신의 종들에게는 가축이 있나이다' ");
INSERT INTO kor_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","또 가로되 `우리가 만일 당신에게 은혜를 입었으면 이 땅을 당신의 종들에게 산업으로 주시고 우리로 요단을 건너지 않게 하소서' ");
INSERT INTO kor_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","모세가 갓 자손과 르우벤 자손에게 이르되 `너희 형제들은 싸우러 가거늘 너희는 여기 앉았고자 하느냐 ? ");
INSERT INTO kor_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","너희가 어찌하여 이스라엘 자손으로 낙심케 하여서 여호와께서 그들에게 주신 땅으로 건너갈 수 없게 하려느냐 ? ");
INSERT INTO kor_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","너희 열조도 내가 가데스바네아에서 그 땅을 보라고 보내었을 때에 그리하였었나니 ");
INSERT INTO kor_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","그들이 에스골 골짜기에 올라가서 그 땅을 보고 이스라엘 자손으로 낙심케 하여서 여호와께서 그들에게 주신 땅으로 갈 수 없게 하였었느니라 ");
INSERT INTO kor_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","그때에 여호와께서 진노하사 맹세하여 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","애굽에서 나온 자들의 이십세 이상으로는 한 사람도 내가 아브라함과 이삭과 야곱에게 맹세한 땅을 정녕히 보지 못하리니 이는 그들이 나를 온전히 순종치 아니하였음이니라 ");
INSERT INTO kor_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","다만 그나스 사람 여분네의 아들 갈렙과 눈의 아들 여호수아는 볼 것은 여호와를 온전히 순종하였음이니라 하시고 ");
INSERT INTO kor_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","여호와께서 이스라엘에게 진노하사 그들로 사십년 동안 광야에 유리하게 하심으로 여호와의 목전에 악을 행한 그 세대가 필경은 다 소멸하였느니라 ");
INSERT INTO kor_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","보라, 너희는 너희의 열조를 계대하여 일어난 죄인의 종류로서 이스라엘을 향하신 여호와의 노를 더욱 심하게 하는도다 ");
INSERT INTO kor_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","너희가 만일 돌이켜 여호와를 떠나면 여호와께서 또 이 백성을 광야에 버리시리니 그리하면 너희가 이 모든 백성을 멸망시키리라' ");
INSERT INTO kor_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","그들이 모세에게 가까이 나아와 가로되 `우리가 이 곳에 우리 가축을 위하여 우리를 짓고 우리 유아들을 위하여 성읍을 건축하고 ");
INSERT INTO kor_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","이 땅 거민의 연고로 우리 유아들로 그 견고한 성읍에 거하게 한후에 우리는 무장하고 이스라엘 자손을 그 곳으로 인도하기까지 그들의 앞에 행하고 ");
INSERT INTO kor_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","이스라엘 자손이 각기 기업을 얻기까지 우리 집으로 돌아오지 아니하겠사오며 ");
INSERT INTO kor_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","우리는 요단 이편 곧 동편에서 산업을 얻었사오니 그들과 함께 요단 저편에서는 기업을 얻지 아니하겠나이다' ");
INSERT INTO kor_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","모세가 그들에게 이르되 `너희가 만일 이 일을 행하여 무장하고 여호와 앞에서 가서 싸우되 ");
INSERT INTO kor_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","너희가 다 무장하고 여호와 앞에서 요단을 건너가서 여호와께서 그 원수를 자기 앞에서 쫓아내시고 ");
INSERT INTO kor_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","그 땅으로 여호와 앞에 복종케 하시기까지 싸우면 여호와의 앞에서나 이스라엘의 앞에서나 무죄히 돌아오겠고 이 땅은 여호와 앞에서 너희의 산업이 되리라마는 ");
INSERT INTO kor_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","너희가 만일 그같이 아니하면 여호와께 범죄함이니 너희 죄가 정녕 너희를 찾아낼 줄알라 ");
INSERT INTO kor_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","너희는 유아들을 위하여 성읍을 건축하고 양을 위하여 우리를 지으라 그리하고 너희 입에서 낸 대로 행하라' ");
INSERT INTO kor_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","갓 자손과 르우벤 자손이 모세에게 대답하여 가로되 `우리 주의 명대로 종들이 행할 것이라 ");
INSERT INTO kor_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","우리의 어린 자와 아내와 양떼와 모든 가축은 이곳 길르앗 성읍 들에 두고 ");
INSERT INTO kor_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","우리 주의 말씀대로 종들은 무장하고 여호와 앞에서 다 건너가서 싸우리이다' ");
INSERT INTO kor_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","이에 모세가 그들에게 대하여 제사장 엘르아살과 눈의 아들 여호수아와 이스라엘 자손 지파의 두령들에게 명하니라 ");
INSERT INTO kor_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","모세가 그들에게 이르되 `갓 자손과 르우벤 자손이 만일 각기 무장하고 너희와 함께 요단을 건너가서 여호와 앞에서 싸워서 그 땅이 너희 앞에 항복하기에 이르거든 길르앗 땅을 그들에게 산업으로 줄 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","그러나 그들이 만일 너희와 함께 무장하고 건너지 아니하거든 가나안 땅에서 너희 중에 산업을 줄 것이니라' ");
INSERT INTO kor_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","갓 자손과 르우벤 자손이 대답하여 가로되 `여호와께서 당신의 종들에게 명하신 대로 우리가 행할 것이라 ");
INSERT INTO kor_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","우리가 무장하고 여호와 앞에서 가나안 땅에 건너가서 요단 이편으로 우리의 산업이 되게 하리이다' ");
INSERT INTO kor_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","모세가 갓 자손과 르우벤 자손과 요셉의 아들 므낫세 반 지파에게 아모리인의 왕 시혼의 국토와 바산 왕 옥의 국토를 주되 곧 그 나라와 그 경내 성읍들과 그 성읍들의 사면 땅을 그들에게 주매 ");
INSERT INTO kor_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","갓 자손은 디본과, 아다롯과, 아로엘과 ");
INSERT INTO kor_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","아다롯소반과, 야셀과, 욕브하와 ");
INSERT INTO kor_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","벧니므라와, 벧하란들의 견고한 성읍을 건축하였고 또 양을 위하여 우리를 지었으며 ");
INSERT INTO kor_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","르우벤 자손은 헤스본과, 엘르알레와, 기랴다임과 ");
INSERT INTO kor_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","느보와 바알므온들을 건축하고 그 이름을 고쳤고 또 십마를 건축하고 건축한 성읍들에 새 이름을 주었고 ");
INSERT INTO kor_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","므낫세의 아들 마길의 자손은 가서 길르앗을 쳐서 취하고 거기 있는 아모리인을 쫓아내매 ");
INSERT INTO kor_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","모세가 길르앗을 므낫세의 아들 마길에게 주매 그가 거기 거하였고 ");
INSERT INTO kor_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","므낫세의 아들 야일은 가서 그 촌락들을 취하고 하봇야일이라 칭하였으며 ");
INSERT INTO kor_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","노바는 가서 그낫과 그 향촌을 취하고 자기 이름을 따라서 노바라 칭하였더라 ");
INSERT INTO kor_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","이스라엘 자손이 모세와 아론의 관할하에 그 항오대로 애굽 땅에서 나오던 때의 노정이 이러하니라 ");
INSERT INTO kor_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","모세가 여호와의 명대로 그 노정을 따라 그 진행한 것을 기록하였으니 그 진행한 대로 그 노정은 이러하니라 ");
INSERT INTO kor_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","그들이 정월 십오일에 라암셋에서 발행하였으니 곧 유월절 다음날이라 이스라엘 자손이 애굽 모든 사람의 목전에서 큰 권능으로 나왔으니 ");
INSERT INTO kor_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","애굽인은 여호와께서 그들 중에 치신 그 모든 장자를 장사하는 때라 여호와께서 그들의 신들에게도 벌을 주셨더라 ");
INSERT INTO kor_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","이스라엘 자손이 라암셋에서 발행하여 숙곳에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","숙곳에서 발행하여 광야 끝 에담에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","에담에서 발행하여 바알스본 앞 비하히롯으로 돌아가서 믹돌 앞에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","하히롯 앞에서 발행하여 바다 가운데로 지나 광야에 이르고 에담 광야로 삼일 길쯤 들어가서 마라에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","마라에서 발행하여 엘림에 이르니 엘림에는 샘물 열 둘과 종려 칠십 주가 있으므로 거기 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","엘림에서 발행하여 홍해 가에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","홍해 가에서 발행하여 신 광야에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","신 광야에서 발행하여 ");
INSERT INTO kor_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","돕 가에 진 쳤고 돕가에서 발행하여 알루스에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","알루스에서 발행하여 르비딤에 진 쳤는데 거기는 백성의 마실 물이 없었더라 ");
INSERT INTO kor_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","르비딤에서 발행하여 시내 광야에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","시내 광야에서 발행하여 기브롯핫다아와에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","기브롯핫다아와에서 발행하여 하세롯에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","하세롯에서 발행하여 릿마에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","릿마에서 발행하여 림몬베레스에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","림몬베레스에서 발행하여 립나에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","립나에서 발행하여 릿사에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","릿사에서 발행하여 그헬라다에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","그헬라다에서 발행하여 세벨산에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","세벨산에서 발행하여 하라다에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","하라다에서 발행하여 막헬롯에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","막헬롯에서 발행하여 다핫에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","다핫에서 발행하여 데라에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","데라에서 발행하여 밋가에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","밋가에서 발행하여 하스모나에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","하스모나에서 발행하여 모세롯에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","모세롯에서 발행하여 브네야아간에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","브네야아간에서 발행하여 홀하깃갓에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","홀하깃갓에서 발행하여 욧바다에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","욧바다에서 발행하여 아브로나에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","아브로나에서 발행하여 에시온게벨에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","에시온게벨에서 발행하여 신 광야 곧 가데스에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","가데스에서 발행하여 에돔 국경 호르산에 진 쳤더라 ");
INSERT INTO kor_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","이스라엘 자손이 애굽 땅에서 나온 지 사십년 오월 일일에 제사장 아론이 여호와의 명으로 호르산에 올라가 거기서 죽었으니 ");
INSERT INTO kor_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","아론이 호르산에서 죽던 때에 나이 일백 이십 삼세이었더라 ");
INSERT INTO kor_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","가나안 땅 남방에 거한 가나안 사람 아랏 왕이 이스라엘의 옴을 들었더라 ");
INSERT INTO kor_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","그들이 호르산에서 발행하여 살모나에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","살모나에서 발행하여 부논에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","부논에서 발행하여 오봇에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","오봇에서 발행하여 모압 변경 이예아바림에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","이임에서 발행하여 디본갓에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","디본갓에서 발행하여 알몬디블라다임에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","알몬디블라다임에서 발행하여 느보 앞 아바림 산에 진 쳤고 ");
INSERT INTO kor_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","아바림 산에서 발행하여 여리고 맞은편 요단 가 모압 평지에 진쳤으니 ");
INSERT INTO kor_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","요단 가 모압 평지의 진이 벧여시못에서부터 아벨싯딤에 미쳤었더라 ");
INSERT INTO kor_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","여리고 맞은편 요단 가 모압 평지에서 여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","이스라엘 자손에게 말하여 그들에게 이르라 너희가 요단을 건너 가나안 땅에 들어가거든 ");
INSERT INTO kor_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","그 땅 거민을 너희 앞에서 다 몰아내고 그 새긴 석상과 부어 만든 우상을 다 파멸하며 산당을 다 훼파하고 ");
INSERT INTO kor_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","그 땅을 취하여 거기 거하라 내가 그 땅을 너희 산업으로 너희에게 주었음이라 ");
INSERT INTO kor_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","너희의 가족을 따라서 그 땅을 제비뽑아 나눌 것이니 수가 많으면 많은 기업을 주고 적으면 적은 기업을 주되 각기 제비뽑힌 대로 그 소유가 될 것인즉 너희 열조의 지파를 따라 기업을 얻을 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","너희가 만일 그 땅 거민을 너희 앞에서 몰아내지 아니하면 너희의 남겨둔 자가 너희의 눈에 가시와 너희의 옆구리에 찌르는 것이 되어 너희 거하는 땅에서 너희를 괴롭게 할 것이요 ");
INSERT INTO kor_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","나는 그들에게 행하기로 생각한 것을 너희에게 행하리라 ");
INSERT INTO kor_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","너는 이스라엘 자손에게 명하여 그들에게 이르라 너희가 가나안 땅에 들어가는 때에 그 땅은 너희의 기업이 되리니 곧 가나안 사방 지경이라 ");
INSERT INTO kor_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","너희 남방은 에돔 곁에 접근한 신 광야니 너희 남편 경계는 동편으로 염해 끝에서 시작하여 ");
INSERT INTO kor_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","돌아서 아그람빔 언덕 남편에 이르고 신을 지나 가데스바네아 남방에 이르고 또 하살아달을 지나 아스몬에 이르고 ");
INSERT INTO kor_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","아스몬에서 돌아서 애굽 시내를 지나 바다까지 이르느니라 ");
INSERT INTO kor_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","서편 경계는 대해가 경계가 되나니 이는 너희의 서편 경계니라 ");
INSERT INTO kor_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","북편 경계는 이러하니 대해에서부터 호르산까지 긋고 ");
INSERT INTO kor_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","호르산에서 그어 하맛 어귀에 이르러 스닷에 미치고 ");
INSERT INTO kor_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","그 경계가 또 시브론을 지나 하살에난에 미치나니 이는 너희 북편 경계니라 ");
INSERT INTO kor_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","너희의 동편 경계는 하살에난에서 그어 스밤에 이르고 ");
INSERT INTO kor_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","그 경계가 또 스밤에서 리블라로 내려가서 아인 동편에 이르고 또 내려가서 긴네렛 동편 해변에 미치고 ");
INSERT INTO kor_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","그 경계가 또 요단으로 내려가서 염해에 미치나니 너희 땅의 사방 경계가 이러하니라 ");
INSERT INTO kor_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","모세가 이스라엘 자손에게 명하여 가로되 `이는 너희가 제비뽑아 얻을 땅이라 여호와께서 이것을 아홉 지파와 반 지파에게 주라고 명하셨나니 ");
INSERT INTO kor_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","이는 르우벤 자손의 지파와 갓 자손의 지파가 함께 그들의 종족대로 그 기업을 받았고 므낫세의 반 지파도 기업을 받았음이라 ");
INSERT INTO kor_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","이 두 지파와 반 지파가 여리고 맞은편 요단 건너편 곧 해 돋는 편에서 그 기업을 받았느니라' ");
INSERT INTO kor_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","여호와께서 또 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","너희에게 땅을 기업으로 나눈 자의 이름이 이러하니 제사장 엘르아살과 눈의 아들 여호수아니라 ");
INSERT INTO kor_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","너희가 또 기업의 땅을 나누기 위하여 매 지파에 한 족장씩 택하라 ");
INSERT INTO kor_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","그 사람들의 이름은 이러하니 유다 지파에서는 여분네의 아들 갈렙이요 ");
INSERT INTO kor_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","시므온 지파에서는 암미훗의 아들 스므엘이요 ");
INSERT INTO kor_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","베냐민 지파에서는 기슬론의 아들 엘리닷이요 ");
INSERT INTO kor_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","단 자손의 지파의 족장 요글리의 아들 북기요 ");
INSERT INTO kor_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","요셉 자손 중 므낫세 자손 지파의 족장 에봇의 아들 한니엘이요 ");
INSERT INTO kor_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","에브라임 자손 지파의 족장 십단의 아들 그므엘이요 ");
INSERT INTO kor_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","스블론 자손 지파의 족장 바르삭의 아들 엘리사반이요 ");
INSERT INTO kor_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","잇사갈 자손 지파의 족장 앗산의 아들 발디엘이요 ");
INSERT INTO kor_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","아셀 자손 지파의 족장 슬로미의 아들 아히훗이요 ");
INSERT INTO kor_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","납달리 자손 지파의 족장 암미훗의 아들 브다헬이니라 하셨으니 ");
INSERT INTO kor_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","여호와께서 명하사 가나안 땅에서 이스라엘 자손에게 기업을 나누게 하신 자들이 이러하였더라 ");
INSERT INTO kor_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","여호와께서 여리고 맞은편 요단 가 모압 평지에서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","이스라엘 자손에게 명하여 그들의 얻은 기업에서 레위인에게 거할 성읍들을 주게 하고 너희는 또 그 성읍 사면의 들을 레위인에게 주어서 ");
INSERT INTO kor_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","성읍으로는 그들의 거처가 되게 하고 들로는 그들의 가축과 물산과 짐승들을 둘 곳이 되게 할 것이라 ");
INSERT INTO kor_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","너희가 레위인에게 줄 성읍들의 들은 성벽에서부터 밖으로 사면 이천 규빗이라 ");
INSERT INTO kor_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","성을 중앙에 두고 성 밖 동편으로 이천 규빗, 남편으로 이천 규빗서 편으로 이천 규빗,북편으로 이천 규빗을 측량할지니 이는 그 들의 성읍의 들이며 ");
INSERT INTO kor_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","너희가 레위인에게 줄 성읍은 살인자로 피케 할 도피성으로 여섯 성읍이요, 그 외에 사십 이 성읍이라 ");
INSERT INTO kor_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","너희가 레위인에게 모두 사십 팔 성읍을 주고 그 들도 함께 주되 ");
INSERT INTO kor_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","이스라엘 자손의 산업에서 레위인에게 너희가 성읍을 줄 때에 많이 얻은 자에게서는 많이 취하여 주고 적게 얻은 자에게서는 적게 취하여 줄 것이라 각기 얻은 산업을 따라서 그 성읍들을 레위인에게 줄지니라 ");
INSERT INTO kor_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","여호와께서 또 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","이스라엘 자손에게 말하여 그들에게 이르라 너희가 요단을 건너 가나안 땅에 들어 가거든 ");
INSERT INTO kor_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","너희를 위하여 성읍을 도피성으로 정하여 그릇 살인한 자로 그리로 피하게 하라 ");
INSERT INTO kor_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","이는 너희가 보수할 자에게서 도피하는 성을 삼아 살인자가 회중앞에 서서 판결을 받기까지 죽지 않게 하기 위함이니라 ");
INSERT INTO kor_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","너희가 줄 성읍 중에 여섯으로 도피성이 되게 하되 ");
INSERT INTO kor_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","세 성읍은 요단 이 편에서 주고 세 성읍은 가나안 땅에서 주어 도피성이 되게 하라 ");
INSERT INTO kor_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","이 여섯 성읍은 이스라엘 자손과 타국인과 이스라엘 중에 우거하는 자의 도피성이 되리니 무릇 그릇 살인한 자가 그리로 도피할 수 있으리라 ");
INSERT INTO kor_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","만일 철 연장으로 사람을 쳐죽이면 이는 고살한 자니 그 고살자를 반드시 죽일 것이요 ");
INSERT INTO kor_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","만일 사람을 죽일 만한 돌을 손에 들고 사람을 쳐죽이면 이는 고살한 자니 그 고살자를 반드시 죽일 것이요 ");
INSERT INTO kor_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","만일 사람을 죽일 만한 나무 연장을 손에 들고 사람을 쳐죽이면 이는 고살한 자니 그 고살자를 반드시 죽일 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","피를 보수하는 자가 그 고살자를 친히 죽일 것이니 그를 만나거든 죽일 것이요 ");
INSERT INTO kor_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","만일 미워하는 까닭에 밀쳐 죽이거나 기회를 엿보아 무엇을 던져 죽이거나 ");
INSERT INTO kor_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","원한으로 인하여 손으로 쳐죽이면 그 친 자를 반드시 죽일 것이니 이는 고살하였음이라 피를 보수하는 자가 그 고살자를 만나거든 죽일 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","원한 없이 우연히 사람을 밀치거나 기회를 엿봄이 없이 무엇을 던지거나 ");
INSERT INTO kor_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","보지 못하고 사람을 죽일 만한 돌을 던져서 죽였다 하자 이는 원한도 없고 해하려 한 것도 아닌즉 ");
INSERT INTO kor_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","회중이 친 자와 피를 보수하는 자 간에 이 규례대로 판결하여 ");
INSERT INTO kor_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","피를 보수하는 자의 손에서 살인자를 건져내어 그가 피하였던 도피성으로 돌려 보낼 것이요 그는 거룩한 기름 부음을 받은 대제사장의 죽기까지 거기 거할 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","그러나 살인자가 어느 때든지 그 피하였던 도피성 지경 밖에 나갔다 하자 ");
INSERT INTO kor_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","피를 보수하는 자가 도피성 지경 밖에서 그 살인자를 만나 죽일지라도 위하여 피흘린 죄가 없나니 ");
INSERT INTO kor_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","이는 살인자가 대제사장의 죽기까지 그 도피성에 유하였을 것임이라 대제사장의 죽은 후에는 그 살인자가 자기의 산업의 땅으로 돌아갈 수 있느니라 ");
INSERT INTO kor_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","이는 너희 대대로 거하는 곳에서 판단하는 율례라 ");
INSERT INTO kor_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","무릇 사람을 죽인 자 곧 고살자를 증인들의 말을 따라서 죽일 것이나 한 증인의 증거만 따라서 죽이지 말 것이요 ");
INSERT INTO kor_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","살인죄를 범한 고살자의 생명의 속전을 받지 말고 반드시 죽일 것이며 ");
INSERT INTO kor_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","또 도피성에 피한 자를 대제사장의 죽기 전에는 속전을 받고 그의 땅으로 돌아가 거하게 하지 말 것이니라 ");
INSERT INTO kor_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","너희는 거하는 땅을 더럽히지 말라 피는 땅을 더럽히나니 피 흘림을 받은 땅은 이를 흘리게 한 자의 피가 아니면 속할 수 없느니라 ");
INSERT INTO kor_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","너희는 너희 거하는 땅 곧 나의 거하는 땅을 더럽히지 말라 나 여호와가 이스라엘 자손 중에 거함이니라 ");
INSERT INTO kor_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","요셉 자손의 자손 중 므낫세의 손자 마길의 아들 길르앗 자손 가족의 두령들이 나아와 모세와 이스라엘 자손의 두령된 족장들 앞에 말하여 ");
INSERT INTO kor_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","가로되 `여호와께서 우리 주에게 명하사 이스라엘 자손에게 그 기업의 땅을 제비뽑아 주게 하셨고 여호와께서 또 우리 주에게 명하사 우리 형제 슬로브핫의 기업으로 그 딸들에게 주게 하였은즉 ");
INSERT INTO kor_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","그들이 만일 이스라엘 자손의 다른 지파 남자들에게 시집가면 그들의 기업은 우리 조상의 기업에서 감삭되고 그들의 속할 그 지파의 기업에 첨가되리니 그러면 우리 제비뽑은 기업에서 감삭될 것이요 ");
INSERT INTO kor_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","이스라엘 자손의 희년을 당하여 그 기업이 그가 속한 지파에 첨가될 것이라 그런즉 그들의 기업은 우리 조상 지파의 기업에서 아주 감삭되리이다' ");
INSERT INTO kor_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","모세가 여호와의 말씀으로 이스라엘에게 명하여 가로되 `요셉 자손 지파의 말이 옳도다 ");
INSERT INTO kor_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","슬로브핫의 딸들에게 대한 여호와의 명이 이러하니라 이르시되 슬로브핫의 딸들은 마음대로 시집가려니와 오직 그 조상 지파의 가족에게로만 시집갈지니 ");
INSERT INTO kor_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","그리하면 이스라엘 자손의 기업이 이 지파에서 저 지파로 옮기지 않고 이스라엘 자손이 다 각기 조상 지파의 기업을 지킬 것이니라 하셨나니 ");
INSERT INTO kor_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","이스라엘 자손의 지파 중 무릇 그 기업을 이은 딸들은 자기 조상지파 가족되는 사람에게로 시집갈 것이라 그리하면 이스라엘 자손이 각기 조상의 기업을 보존하게 되어서 ");
INSERT INTO kor_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","그 기업으로 이 지파에서 저 지파로 옮기게 하지 아니하고 이스라엘 자손 지파가 각각 자기 기업을 지키리라' ");
INSERT INTO kor_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","슬로브핫의 딸들이 여호와께서 모세에게 명하신 대로 행하니라 ");
INSERT INTO kor_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","슬로브핫의 딸 말라와 디르사와 호글라와 밀가와 노아가 다 그 아비 형제의 아들들에게로 시집가되 ");
INSERT INTO kor_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","그들이 요셉의 아들 므낫세 자손의 가족에게로 시집 간고로 그 기업이 그 아비 가족의 지파에 여전히 있었더라 ");
INSERT INTO kor_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","이는 여리고 맞은편 요단가 모압 평지에서 여호와께서 모세로 이스라엘 자손에게 명하신 명령과 규례니라 ");
INSERT INTO kor_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","이는 모세가 요단 저편 숩 맞은편의 아라바 광야 곧 바란과, 도벨과, 라반과, 하세롯과, 디사합 사이에서 이스라엘 무리에게 선포한 말씀이니라 ");
INSERT INTO kor_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","호렙산에서 세일산을 지나 가데스 바네아에까지 열 하룻 길이었더라 ");
INSERT INTO kor_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","제 사십년 십일월 그 달 초일일에 모세가 이스라엘 자손에게 여호와께서 그들을 위하여 자기에게 주신 명령을 다 고하였으니 ");
INSERT INTO kor_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","때는 모세가 헤스본에 거하는 아모리 왕 시혼을 쳐 죽이고 에드레이에서 아스다롯에 거하는 바산 왕 옥을 쳐 죽인 후라 ");
INSERT INTO kor_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","모세가 요단 저편 모압 땅에서 이 율법 설명하기를 시작하였더라 일렀으되 ");
INSERT INTO kor_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","우리 하나님 여호와께서 호렙산에서 우리에게 말씀하여 이르시기를 너희가 이 산에서 거한지 오래니 ");
INSERT INTO kor_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","방향을 돌려 진행하여 아모리 족속의 산지로 가고 그 근지 곳곳으로 가고 아라바와 산지와 평지와 남방과 해변과 가나안 족속의 땅과 레바논과 큰 강 유브라데까지 가라 하셨나니 ");
INSERT INTO kor_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","여호와께서 너희의 열조 아브라함과 이삭과 야곱에게 맹세하사 그들과 그 후손에게 주리라 하신 땅이 너희 앞에 있으니 들어가서 얻을지니라 ");
INSERT INTO kor_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","그 때에 내가 너희에게 말하여 이르기를 나는 홀로 너희 짐을 질 수 없도다 ");
INSERT INTO kor_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","너희 하나님 여호와께서 너희를 번성케 하셨으므로 너희가 오늘날 하늘의 별 같이 많거니와 ");
INSERT INTO kor_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","너희 열조의 하나님 여호와께서 너희를 현재보다 천배나 많게 하시며 너희에게 허락하신 것과 같이 너희에게 복 주시기를 원하노라 ! ");
INSERT INTO kor_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","그런즉 나 홀로 어찌 능히 너희의 괴로운 것과 너희의 무거운 짐과 너희의 다툼을 담당할 수 있으랴 ");
INSERT INTO kor_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","너희의 각 지파에서 지혜와 지식이 있는 유명한 자를 택하라 내가 그들을 세워 너희 두령을 삼으리라 한즉 ");
INSERT INTO kor_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","너희가 대답하여 이르기를 당신의 말씀대로 하는 것이 좋다 하기에 ");
INSERT INTO kor_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","내가 너희 지파의 두령으로 지혜가 있는 유명한 자를 취하여 너희의 어른을 삼되 곧 각 지파를 따라 천부장과, 백부장과, 오십부장과, 십부장과, 패장을 삼고 ");
INSERT INTO kor_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","내가 그 때에 너희 재판장들에게 명하여 이르기를 너희가 너희 형제 중에 송사를 들을 때에 양방간에 공정히 판결 할 것이며 그들 중의 타국인에게도 그리할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","재판은 하나님께 속한 것인즉 너희는 재판에 외모를 보지 말고 귀천을 일반으로 듣고 사람의 낯을 두려워 말 것이며 스스로 결단하기 어려운 일이거든 내게로 돌리라 내가 들으리라 하였고 ");
INSERT INTO kor_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","내가 너희의 행할 모든 일을 그 때에 너희에게 다 명하였느니라 ");
INSERT INTO kor_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","우리 하나님 여호와께서 우리에게 명하신 대로 우리가 호렙산에서 발행하여 너희의 본바 크고 두려운 광야를 지나 아모리 족속 산지 길로 가데스 바네아에 이른 때에 ");
INSERT INTO kor_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","내가 너희에게 이르기를 우리 하나님 여호와께서 우리에게 주신 아모리 족속의 산지에 너희가 이르렀나니 ");
INSERT INTO kor_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","너희 하나님 여호와께서 이 땅을 너희 앞에 두셨은즉 너희 열조의 하나님 여호와께서 너희에게 이르신 대로 올라가서 얻으라 두려워 말라 ! 주저하지 말라 ! 한즉 ");
INSERT INTO kor_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","너희가 다 내 앞으로 나아와 말하기를 우리가 사람을 우리 앞서 보내어 우리를 위하여 그 땅을 정탐하고 어느 길로 올라가야 할 것과 어느 성읍으로 들어가야 할 것을 우리에게 회보케 하자 하기에 ");
INSERT INTO kor_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","내가 그 말을 선히 여겨 너희 중에서 매 지파에 한 사람씩 열 둘을 택하매 ");
INSERT INTO kor_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","그들이 앞으로 가서 산지에 올라 에스골 골짜기에 이르러 그 곳을 정탐하고 ");
INSERT INTO kor_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","그 땅의 과실을 손에 가지고 우리에게로 돌아와서 우리에게 회보하여 이르되 우리의 하나님 여호와께서 우리에게 주시는 땅이 좋더라 하였느니라 ");
INSERT INTO kor_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","그러나 너희가 올라 가기를 즐겨 아니하고 너희 하나님 여호와의 명을 거역하여 ");
INSERT INTO kor_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","장막 중에서 원망하여 이르기를 `여호와께서 우리를 미워하시는 고로 아모리 족속의 손에 붙여 멸하시려고 우리를 애굽 땅에서 인도하여 내셨도다 ");
INSERT INTO kor_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","우리가 어디로 갈꼬 ?' 우리의 형제들이 우리로 낙심케 하여 말하기를 `그 백성은 우리보다 장대하며 그 성읍은 크고 성곽은 하늘에 닿았으며 우리가 또 거기서 아낙 자손을 보았노라 하는도다' 하기로 ");
INSERT INTO kor_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","내가 너희에게 말하기를 `그들을 무서워 말라 ! 두려워 하지 말라 ! ");
INSERT INTO kor_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","너희 앞서 행하시는 너희 하나님 여호와께서 애굽에서 너희를 위하여 너희 목전에서 모든 일을 행하신 것 같이 이제도 너희를 위하여 싸우실 것이며 ");
INSERT INTO kor_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","광야에서도 너희가 당하였거니와 사람이 자기 아들을 안음 같이 너희 하나님 여호와께서 너희의 행로 중에 너희를 안으사 이곳까지 이르게 하셨느니라' 하나 ");
INSERT INTO kor_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","이 일에 너희가 너희 하나님 여호와를 믿지 아니하였도다 ");
INSERT INTO kor_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","그는 너희 앞서 행하시며 장막 칠 곳을 찾으시고 밤에는 불로, 낮에는 구름으로 너희의 행할 길을 지시하신 자니라 ");
INSERT INTO kor_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","여호와께서 너희의 말소리를 들으시고 노하사 맹세하여 가라사대 ");
INSERT INTO kor_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","이 악한 세대 사람들 중에는 내가 그들의 열조에게 주기로 맹세 한 좋은 땅을 볼 자가 하나도 없으리라 ");
INSERT INTO kor_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","오직 ! 여분네의 아들 갈렙은 온전히 여호와를 순종하였은즉 그는 그것을 볼것이요 그가 밟은 땅을 내가 그와 그의 자손에게 주리라 하시고 ");
INSERT INTO kor_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","여호와께서 너희의 연고로 내게도 진노하사 가라사대 너도 그리로 들어가지 못하리라 ");
INSERT INTO kor_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","너의 종자 눈의 아들 여호수아는 그리로 들어갈 것이니 너는 그를 담대케 하라 그가 이스라엘에게 그 땅을 기업으로 얻게하리라 ");
INSERT INTO kor_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","또 너희가 사로 잡히리라 하던 너희의 아이들과 당일에 선악을 분변치 못하던 너희 자녀들 그들은 그리로 들어갈 것이라 내가 그 땅을 그들에게 주어 산업이 되게 하리라 ");
INSERT INTO kor_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","너희는 회정하여 홍해 길로 하여 광야로 들어갈지니라 하시매 ");
INSERT INTO kor_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","너희가 대답하여 내게 이르기를 `우리가 여호와께 범죄하였사오니 우리 하나님께서 우리에게 명하신 대로 우리가 올라 가서 싸우리이다' 하고 너희가 각각 병기를 띠고 경솔히 산지로 올라가려 할 때에 ");
INSERT INTO kor_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","여호와께서 내게 이르시되 너는 그들에게 이르기를 너희는 올라가지 말라 싸우지도 말라 내가 너희 중에 있지 아니하니 너희가 대적에게 패할까 하노라 하셨다 하라 하시기로 ");
INSERT INTO kor_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","내가 너희에게 고하였으나 너희가 듣지 아니하고 여호와의 명을 거역하고 천자히 산지로 올라가매 ");
INSERT INTO kor_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","그 산지에 거하는 아모리 족속이 너희를 마주 나와서 벌떼같이 너희를 쫓아 세일산에서 쳐서 호르마까지 미친지라 ");
INSERT INTO kor_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","너희가 돌아와서 여호와 앞에서 통곡하나 여호와께서 너희의 소리를 듣지 아니하시며 너희에게 귀를 기울이지 아니하셨으므로 ");
INSERT INTO kor_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","너희가 가데스에 여러날동안 거하였었나니 곧 너희가 그 곳에 거하던 날 수대로니라 ");
INSERT INTO kor_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","우리가 회정하여 여호와께서 내게 명하신 대로 홍해 길로 광야에 들어가서 여러날 동안 세일 산을 두루 행하더니 ");
INSERT INTO kor_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","여호와께서 내게 고하여 이르시되 ");
INSERT INTO kor_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","너희가 이 산을 두루 행한지 오래니 돌이켜 북으로 나아가라 ");
INSERT INTO kor_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","너는 또 백성에게 명하여 이르기를 너희는 세일에 거하는 너희 동족 에서의 자손의 지경으로 지날진대 그들이 너희를 두려워하리니 너희는 깊이 스스로 삼가고 ");
INSERT INTO kor_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","그들과 다투지 말라 그들의 땅은 한 발자국도 너희에게 주지 아니하리니 이는 내가 세일산을 에서에게 기업으로 주었음이로라 ");
INSERT INTO kor_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","너희는 돈으로 그들에게서 양식을 사서 먹으며 돈으로 그들에게서 물을 사서 마시라 ");
INSERT INTO kor_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","네 하나님 여호와가 너의 하는 모든 일에 네게 복을 주고 네가 이 큰 광야에 두루 행함을 알고 네 하나님 여호와가 이 사십년 동안을 너와 함께 하였으므로 네게 부족함이 없었느니라 하셨다 하라 하시기로 ");
INSERT INTO kor_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","우리가 세일 산에 거하는 우리 동족 에서의 자손을 떠나서 아라바를 지나며 엘랏과 에시온 게벨 곁으로 지나 행하고 돌이켜 모압 광야 길로 진행할 때에 ");
INSERT INTO kor_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","여호와께서 내게 이르시되 모압을 괴롭게 말라 그와 싸우지도 말라 그 땅을 내가 네게 기업으로 주지 아니하리니 이는 내가 롯 자손에게 아르를 기업으로 주었음이로라 ");
INSERT INTO kor_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","옛적에 엠 사람이 거기 거하여 강하고 많고 아낙 족속과 같이 키가 크므로 ");
INSERT INTO kor_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","그들을 아낙 족속과 같이 르바임이라 칭하였으나 모압 사람은 그들을 에밈이라 칭하였으며 ");
INSERT INTO kor_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","호리 사람도 세일에 거하였더니 에서의 자손이 그들을 멸하고 대신하여 그 땅에 거하였으니 이스라엘이 여호와의 주신 기업의 땅에서 행한 것과 일반이었느니라 ");
INSERT INTO kor_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","이제 너희는 일어나서 세렛 시내를 건너가라 하시기로 우리가 세렛 시내를 건넜으니 ");
INSERT INTO kor_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","이제 너희는 일어나서 세렛 시내를 건너가라 하시기로 우리가 세렛 시내를 건넜으니 ");
INSERT INTO kor_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","가데스 바네아에서 떠나 세렛 시내를 건너기까지 삼십 팔년 동안이라 이 때에는 그 시대의 모든 군인들이 여호와께서 그들에게 맹세하신대로 진 중에서 다 멸절되었나니 ");
INSERT INTO kor_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","여호와께서 손으로 그들을 치사 진 중에서 멸하신 고로 필경은 다 멸절되었느니라 ");
INSERT INTO kor_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","모든 군인이 사망하여 백성 중에서 진멸된 후에 ");
INSERT INTO kor_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","여호와께서 내게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","내가 오늘 모압 변경 아르를 지나리니 ");
INSERT INTO kor_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","암몬 족속에게 가까이 이르거든 그들을 괴롭게 말라 그들과 다투지도 말라 암몬 족속의 땅은 내가 네게 기업으로 주지 아니하리니 이는 내가 그것을 롯 자손에게 기업으로 주었음이로라 ");
INSERT INTO kor_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","(이곳도 르바임의 땅이라 하였었나니 전에 르바임이 거기 거하였었음이요 암몬 족속은 그들을 삼숨밈이라 일컬었었으며 ");
INSERT INTO kor_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","그 백성은 강하고 많고 아낙 족속과 같이 키가 크나 여호와께서 암몬 족속 앞에서 그들을 멸하셨으므로 암몬 족속이 대신하여 그 땅에 거하였으니 ");
INSERT INTO kor_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","마치 세일에 거한에서 자손 앞에 호리 사람을 멸하심과 일반이라 그들이 호리 사람을 쫓아 내고 대신하여 오늘까지 거기 거하였으며 ");
INSERT INTO kor_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","또 갑돌에서 나온 갑돌 사람이 가사까지 각 촌에 거하는 아위 사람을 멸하고 그들을 대신하여 거기 거하였었느니라) ");
INSERT INTO kor_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","너희는 일어나 진행하여 아르논 골짜기를 건너라 내가 헤스본 왕 아모리 사람 시혼과 그 땅을 네 손에 붙였은즉 비로소 더불어 싸워서 그 땅을 얻으라 ");
INSERT INTO kor_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","오늘부터 내가 천하 만민으로 너를 무서워하며 너를 두려워하게 하리니 그들이 네 명성을 듣고 떨며 너로 인하여 근심하리라 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","내가 그데못 광야에서 헤스본 왕 시혼에게 사자를 보내어 평화의 말로 이르기를 ");
INSERT INTO kor_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","나를 네 땅으로 통과하게 하라 내가 대로로만 행하고 좌로나 우로나 치우치지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","너는 돈을 받고 양식을 팔아 나로 먹게 하고 돈을 받고 물을 주어 나로 마시게 하라 나는 도보로 지날 뿐인즉 ");
INSERT INTO kor_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","세일에 거하는 에서 자손과 아르에 거하는 모압 사람이 내게 행한 것 같이 하라 그리하면 내가 요단을 건너서 우리 하나님 여호와께서 우리에게 주시는 땅에 이르리라 하나 ");
INSERT INTO kor_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","헤스본 왕 시혼이 우리의 통과하기를 허락지 아니하였으니 이는 너의 하나님 여호와께서 그를 네 손에 붙이시려고 그 성품을 완강케 하셨고 그 마음을 강퍅케 하셨음이라 오늘날과 같으니라 ");
INSERT INTO kor_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","때에 여호와께서 내게 이르시되 내가 비로소 시혼과 그 땅을 네게 붙이노니 너는 이제부터 그 땅을 얻어서 기업으로 삼으라 하시더니 ");
INSERT INTO kor_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","시혼이 그 모든 백성을 거느리고 나와서 우리를 대적하여 야하스에서 싸울 때에 ");
INSERT INTO kor_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","우리 하나님 여호와께서 그를 우리에게 붙이시매 우리가 그와 그 아들들과 그 모든 백성을 쳤고 ");
INSERT INTO kor_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","그 때에 우리가 그 모든 성읍을 취하고 그 각 성읍을 그 남녀와 유아와 함께 하나도 남기지 아니하고 진멸하였고 ");
INSERT INTO kor_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","오직 그 육축과 성읍에서 탈취한 것은 우리의 소유로 삼았으며 ");
INSERT INTO kor_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","우리 하나님 여호와께서 그 모든 땅을 우리에게 붙이심으로 아르논 골짜기 가에 있는 아로엘과 골짜기 가운데 있는 성읍으로부터 길르앗에까지 우리가 모든 높은 성읍을 취하지 못한 것이 하나도 없었으나  (Deuteronomy 2:38) 오직 암몬 족속의 땅 얍복강 가와 산지에 있는 성읍들과 무릇 우리 하나님 여호와께서 우리의 가기를 금하신 곳은 네가 가까이 하지 못하였느니라  ");
INSERT INTO kor_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","우리가 돌이켜 바산으로 올라가매 바산 왕 옥이 그 모든 백성을 거느리고 나와서 우리를 대적하여 에드레이에서 싸우는지라 ");
INSERT INTO kor_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","여호와께서 내게 이르시되 그를 두려워 말라 ! 내가 그와 그 모든 백성과 그 땅을 네 손에 붙였으니 네가 헤스본에 거하던 아모리 족속의 왕 시혼에게 행한 것과 같이 그에게 행할 것이니라 하시고 ");
INSERT INTO kor_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","우리 하나님 여호와께서 바산 왕 옥과 그 모든 백성을 우리 손에 붙이시매 우리가 그들을 쳐서 한 사람도 남기지 아니하였느니라 ");
INSERT INTO kor_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","그 때에 우리가 그들에게서 빼앗지 아니한 성읍이 하나도 없이 다 빼앗았는데 그 성읍이 육십이니 곧 아르곱 온 지방이요 바산에 있는 옥의 나라이라 ");
INSERT INTO kor_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","그 모든 성읍에 높은 성벽이 둘려 있고 문과 빗장이 있어 견고하며 그 외에 성벽 없는 고을이 심히 많았느니라 ");
INSERT INTO kor_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","우리가 헤스본 왕 시혼에게 행한 것과 같이 그 성읍들을 진멸하되 각 성읍의 남녀와 유아를 진멸하였으나 ");
INSERT INTO kor_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","오직 모든 육축과 그 성읍들에서 탈취한 것은 우리의 소유로 삼았으며 ");
INSERT INTO kor_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","그 때에 우리가 요단강 이편 땅을 아르논 골짜기에서부터 헤르몬 산에까지 아모리 족속의 두 왕에게서 취하였으니 ");
INSERT INTO kor_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(헤르몬 산을 시돈 사람은 시룐이라 칭하고 아모리 족속은 스닐이라 칭하였느니라) ");
INSERT INTO kor_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","우리의 취한 것은 평원의 모든 성읍과 길르앗 온 땅과 바산의 온 땅 곧 옥의 나라 바산의 성읍 살르가와 에드레이까지니라 ");
INSERT INTO kor_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(르바임 족속의 남은 자는 바산 왕 옥 뿐이었으며 그의 침상은 철 침상이라 지금 오히려 암몬 족속의 랍바에 있지 아니하냐 ? 그것을 사람의 보통 규빗으로 재면 그 장이 아홉 규빗이요, 광이 네 규빗이니라) ");
INSERT INTO kor_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","그 때에 우리가 이 땅을 얻으매 아르논 골짜기 곁에 아로엘에서부터 길르앗 산지 절반과 그 성읍들을 내가 르우벤 자손과 갓 자손에게 주었고 ");
INSERT INTO kor_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","길르앗의 남은 땅과 옥의 나라이었던 아르곱 온 지방 곧 온 바산으로는 내가 므낫세 반 지파에게 주었노라 (바산을 옛적에는 르바임의 땅이라 칭하더니 ");
INSERT INTO kor_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","므낫세의 아들 야일이 그술 족속과, 마아갓 족속의 경계까지의 아르곱 온 지방을 취하고 자기의 이름으로 이 바산을 하봇야일이라 칭하여 오늘까지 이르느니라) ");
INSERT INTO kor_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","내가 마길에게 길르앗을 주었고 ");
INSERT INTO kor_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","르우벤 자손과, 갓 자손에게는 길르앗에서부터 아르논 골짜기까지 주었으되 그 골짜기의 중앙으로 지경을 정하였으니 곧 암몬 자손의 지경 얍복강까지며 ");
INSERT INTO kor_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","또는 아라바와 요단과 그 가요 긴네렛에서 아라바 바다 곧 염해와 비스가 산록에 이르기까지의 동편 지경이니라 ");
INSERT INTO kor_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","그 때에 내가 이 땅을 받은 너희에게 명하여 이르기를 너희의 하나님 여호와께서 이 땅을 너희에게 주어 기업이 되게 하셨은즉 너희 군인들은 무장하고 너희의 형제 이스라엘 자손의 선봉이 되어 건너가되 ");
INSERT INTO kor_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","너희에게 육축이 많은 줄 내가 아노니 너희의 처자와 육축은 내가 너희에게 준 성읍에 머무르라 ");
INSERT INTO kor_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","여호와께서 너희에게 주신 것 같이 너희 형제에게 안식을 주시리니 그들도 요단 저편에서 너희 하나님 여호와의 주시는 땅을 얻어 기업을 삼기에 이르거든 너희는 각기 내가 준 기업으로 돌아 갈 것이니라 하고 ");
INSERT INTO kor_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","그 때에 내가 여호수아에게 명하여 이르기를 너희 하나님 여호와께서 이 두 왕에게 행하신 모든 일을 네가 목도하였거니와 네가 가는 모든 나라에도 여호와께서 이와 같이 행하시리니 ");
INSERT INTO kor_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","너희는 그들을 두려워하지 말라 ! 너희 하나님 여호와 그가 너희를 위하여 싸우시리라 ! 하였노라 ");
INSERT INTO kor_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","그 때에 내가 여호와께 간구하기를 ");
INSERT INTO kor_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","`주 여호와여 ! 주께서 주의 크심과 주의 권능을 주의 종에게 나타내시기를 시작하였사오니 천지간에 무슨 신이 능히 주의 행하신 일 곧 주의 큰 능력으로 행하신 일같이 행할 수 있으리이까 ? ");
INSERT INTO kor_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","구하옵나니 나로 건너가게 하사 요단 저편에 있는 아름다운 땅 아름다운 산과 레바논을 보게 하옵소서' 하되 ");
INSERT INTO kor_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","여호와께서 너희의 연고로 내게 진노하사 내 말을 듣지 아니하시고 내게 이르시기를 그만해도 족하니 이 일로 다시 내게 말하지 말라 ");
INSERT INTO kor_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","너는 비스가산 꼭대기에 올라가서 눈을 들어 동서 남북을 바라고 네 눈으로 그 땅을 보라 네가 이 요단을 건너지 못할 것임이니라 ");
INSERT INTO kor_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","너는 여호수아에게 명하고 그를 담대케 하며 그를 강경케 하라 그는 이 백성을 거느리고 건너가서 네가 볼 땅을 그들로 기업으로 얻게 하리라 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","그때에 우리가 벨브올 맞은편 골짜기에 거하였었느니라 ");
INSERT INTO kor_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","이스라엘아 ! 이제 내가 너희에게 가르치는 규례와 법도를 듣고 준행하라 ! 그리하면 너희가 살 것이요 너희의 열조의 하나님 여호와께서 너희에게 주시는 땅에 들어가서 그것을 얻게 되리라 ");
INSERT INTO kor_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","내가 너희에게 명하는 말을 너희는 가감하지 말고 내가 너희에게 명하는 너희 하나님 여호와의 명령을 지키라 ! ");
INSERT INTO kor_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","여호와께서 바알브올의 일을 인하여 행하신 바를 너희가 목도하였거니와 바알브올을 좇은 모든 사람을 너의 하나님 여호와께서 너의 중에서 진멸하셨으되 ");
INSERT INTO kor_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","오직 ! 너희의 하나님 여호와께 붙어 떠나지 않은 너희는 오늘까지 다 생존하였느니라 ");
INSERT INTO kor_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","내가 나의 하나님 여호와의 명하신 대로 규례와 법도를 너희에게 가르쳤나니 이는 너희로 들어가서 기업으로 얻을 땅에서 그대로 행하게 하려 함인즉 ");
INSERT INTO kor_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","너희는 지켜 행하라 ! 그리함은 열국 앞에 너희의 지혜요 너희의 지식이라 그들이 이 모든 규례를 듣고 이르기를 이 큰 나라 사람은 과연 지혜와 지식이 있는 백성이로다 하리라 ");
INSERT INTO kor_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","우리 하나님 여호와께서 우리가 그에게 기도할 때마다 우리에게 가까이 하심과 같이 그 신의 가까이 함을 얻은 나라가 어디 있느냐 ? ");
INSERT INTO kor_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","오늘 내가 너희에게 선포하는 이 율법과 같이 그 규례와 법도가 공의로운 큰 나라가 어디 있느냐 ? ");
INSERT INTO kor_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","오직 너는 스스로 삼가며 네 마음을 힘써 지키라 두렵건대 네가 그 목도한 일을 잊어버릴까 하노라 두렵건대 네 생존하는 날 동안에 그 일들이 네 마음 속에서 떠날까 하노라 너는 그 일들을 네 아들들과 네 손자들에게 알게 하라 ");
INSERT INTO kor_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","네가 호렙산에서 네 하나님 여호와 앞에 섰던 날에 여호와께서 내게 이르시기를 나를 위하여 백성을 모으라 내가 그들에게 내 말을 들려서 그들로 세상에 사는 날 동안 나 경외함을 배우게 하며 그 자녀에게 가르치게 하려 하노라 하시매 ");
INSERT INTO kor_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","너희가 가까이 나아와서 산 아래 서니 그 산에 불이 붙어 화염이 충천하고 유암과 구름과 흑암이 덮였는데 ");
INSERT INTO kor_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","여호와께서 화염 중에서 너희에게 말씀하시되 음성 뿐이므로 너희가 그 말소리만 듣고 형상은 보지 못하였느니라 ");
INSERT INTO kor_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","여호와께서 그 언약을 너희에게 반포하시고 너희로 지키라 명하셨으니 곧 십계명이며 두 돌판에 친히 쓰신 것이라 ");
INSERT INTO kor_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","그 때에 여호와께서 내게 명하사 너희에게 규례와 법도를 교훈하게 하셨나니 이는 너희로 건너가서 얻을 땅에서 행하게 하심이니라 ");
INSERT INTO kor_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","여호와께서 호렙산 화염 중에서 너희에게 말씀하시던 날에 너희가 아무 형상도 보지 못하였은즉 너희는 깊이 삼가라 ! ");
INSERT INTO kor_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","두렵건대 스스로 부패하여 자기를 위하여 아무 형상대로든지 우상을 새겨 만들되 남자의 형상이라든지, 여자의 형상이라든지, ");
INSERT INTO kor_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","땅 위에 있는 아무 짐승의 형상이라든지, 하늘에 나는 아무 새의 형상이라든지, ");
INSERT INTO kor_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","땅 위에 기는 아무 곤충의 형상이라든지, 땅 아래 물 속에 있는 아무 어족(魚族)의 형상이라든지 만들까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","땅 위에 기는 아무 곤충의 형상이라든지, 땅 아래 물 속에 있는 아무 어족(魚族)의 형상이라든지 만들까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","또 두렵건대 네가 하늘을 향하여 눈을 들어 일월 성신 하늘 위의 군중 곧 너희 하나님 여호와께서 천하 만민을 위하여 분정하신 것을 보고 미혹하여 그것에 경배하며 섬길까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","여호와께서 너희를 택하시고 너희를 쇠풀무 곧 애굽에서 인도하여 내사 자기 기업의 백성을 삼으신 것이 오늘과 같아도 ");
INSERT INTO kor_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","여호와께서 너희로 인하여 내게 진노하사 나로 요단을 건너지 못하며 네 하나님 여호와께서 네게 기업으로 주신 그 아름다운 땅에 들어가지 못하게 하리라고 맹세하셨은즉 ");
INSERT INTO kor_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","나는 이 땅에서 죽고 요단을 건너지 못하려니와 너희는 건너가서 그 아름다운 땅을 얻으리니 ");
INSERT INTO kor_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","너희는 스스로 삼가서 너희 하나님 여호와께서 너희와 세우신 언약을 잊어버려서 네 하나님 여호와께서 금하신 아무 형상의 우상이든지 조각하지 말라 ");
INSERT INTO kor_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","네 하나님 여호와는 소멸하는 불이시요 ! 질투하는 하나님이시니라 ! ");
INSERT INTO kor_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","네가 그 땅에서 아들을 낳고 손자를 얻으며 오래 살 때에 만일 스스로 부패하여 무슨 형상의 우상이든지 조각하여 네 하나님 여호와 앞에 악을 행함으로 그의 노를 격발하면 ");
INSERT INTO kor_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","내가 오늘날 천지를 불러 증거를 삼노니 너희가 요단을 건너가서 얻는 땅에서 속히 망할 것이라 너희가 거기서 너희 날이 길지 못하고 전멸될 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","여호와께서 너희를 열국 중에 흩으실 것이요 여호와께서 너희를 쫓아 보내실 그 열국 중에 너희의 남은 수가 많지 못할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","너희는 거기서 사람의 손으로 만든바 보지도 못하며 듣지도 못하며 먹지도 못하며 냄새도 맡지 못하는 목석의 신들을 섬기리라 ");
INSERT INTO kor_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","그러나 네가 거기서 네 하나님 여호와를 구하게 되리니 만일 마음을 다하고 성품을 다하여 그를 구하면 만나리라 ! ");
INSERT INTO kor_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","이 모든 일이 네게 임하여 환난을 당하다가 끝날에 네가 네 하나님 여호와께로 돌아와서 그 말씀을 청종하리니 ");
INSERT INTO kor_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","네 하나님 여호와는 자비하신 하나님이심이라 ! 그가 너를 버리지 아니하시며 너를 멸하지 아니하시며 네 열조에게 맹세하신 언약을 잊지 아니하시리라 ");
INSERT INTO kor_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","네가 있기 전 하나님이 사람을 세상에 창조하신 날부터 지금까지 지나간 날을 상고하여 보라 ! 하늘 이 끝에서 저 끝까지 이런 큰 일이 있었느냐 ? 이런 일을 들은 적이 있었느냐 ? ");
INSERT INTO kor_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","어떤 국민이 불 가운데서 말씀하시는 하나님의 음성을 너처럼 듣고 생존하였었느냐 ? ");
INSERT INTO kor_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","어떤 신이 와서 시험과 이적과 기사와 전쟁과 강한 손과 편 팔과 크게 두려운 일로 한 민족을 다른 민족에게서 인도하여 낸 일이 있느냐 ? 이는 다 너희 하나님 여호와께서 애굽에서 너희를 위하여 너희의 목전에서 행하신 일이라 ");
INSERT INTO kor_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","이것을 네게 나타내심은 여호와는 하나님이시요 그 외에는 다른 신이 없음을 네게 알게 하려 하심이니라 ");
INSERT INTO kor_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","여호와께서 너를 교훈하시려고 하늘에서부터 그 음성을 너로 듣게 하시며 땅에서는 그 큰 불을 네게 보이시고 너로 불가운데서 나오는 그 말씀을 듣게 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","여호와께서 네 열조를 사랑 하신고로 그 후손 너를 택하시고 큰 권능으로 친히 인도하여 애굽에서 나오게 하시며 ");
INSERT INTO kor_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","너보다 강대한 열국을 네 앞에서 쫓아내고 너를 그들의 땅으로 인도하여 들여서 그것을 네게 기업으로 주려 하심이 오늘과 같으니라 ");
INSERT INTO kor_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","그런즉 너는 오늘날 상천 하지에 오직 여호와는 하나님이시요 ! 다른 신이 없는 줄을 알아 명심하고 ");
INSERT INTO kor_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","오늘 내가 네게 명하는 여호와의 규례와 명령을 지키라 ! 너와 네 후손이 복을 받아 네 하나님 여호와께서 네게 주시는 땅에서 한 없이 오래 살리라 ");
INSERT INTO kor_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","때에 모세가 요단 이편 해 돋는 편에서 세 성읍을 구별하였으니 ");
INSERT INTO kor_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","이는 과거에 원혐이 없이 부지중에 오살한 자로 그곳으로 도피케 하기 위함이며 그 한 성읍으로 도피한 자로 그 생명을 보존케 하기 위함이라 ");
INSERT INTO kor_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","하나는 광야 평원에 있는 베셀이라 르우벤 지파를 위한 것이요 하나는 길르앗 라못이라 갓 지파를 위한 것이요 하나는 바산 골란이라 므낫세 지파를 위한 것이었더라 ");
INSERT INTO kor_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","모세가 이스라엘 자손에게 선포한 율법이 이러하니라 ");
INSERT INTO kor_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","이스라엘 자손이 애굽에서 나온 후에 증거하신 것과 규례와 법도를 모세가 선포하였으니 ");
INSERT INTO kor_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","요단 동편 벳브올 맞은편 골짜기에서라 이 땅은 헤스본에 거하는 아모리 족속의 왕 시혼에게 속하였더니 모세와 이스라엘 자손이 애굽에서 나온 후에 그를 쳐서 멸하고 ");
INSERT INTO kor_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","그 땅을 기업으로 얻었고 또 바산 왕 옥의 땅을 얻었으니 그 두 사람은 아모리 족속의 왕으로서 요단 이편 해 돋는 편에 거하였었으며 ");
INSERT INTO kor_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","그 얻은 땅은 아르논 골짜기 가의 아로엘에서부터 시온산 곧 헤르몬산까지요  (Deuteronomy 4:50) 요단 이편 곧 그 동편 온 아라바니 비스가 산록 아래 아라바의 바다까지니라  ");
INSERT INTO kor_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","모세가 온 이스라엘을 불러 그들에게 이르되 이스라엘아 ! 오늘 내가 너희 귀에 말하는 규례와 법도를 듣고 그것을 배우며 지켜 행하라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","우리 하나님 여호와께서 호렙산에서 우리와 언약을 세우셨나니 ");
INSERT INTO kor_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","이 언약은 여호와께서 우리 열조와 세우신 것이 아니요 오늘날 여기 살아 있는 우리 곧 우리와 세우신 것이라 ");
INSERT INTO kor_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","여호와께서 산 위 불 가운데서 너희와 대면하여 말씀하시매 ");
INSERT INTO kor_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","그 때에 너희가 불을 두려워하여 산에 오르지 못하므로 내가 여호와와 너희 중간에 서서 여호와의 말씀을 너희에게 전하였노라 여호와께서 가라사대 ");
INSERT INTO kor_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","나는 너를 애굽 땅에서 종 되었던 집에서 인도하여 낸 너희 하나님 여호와로라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","나 외에는 위하는 신들을 네게 있게 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","너는 자기를 위하여 새긴 우상을 만들지 말고 위로 하늘에 있는 것이나, 아래로 땅에 있는 것이나, 땅 밑 물 속에 있는 것의 아무 형상이든지 만들지 말며 ");
INSERT INTO kor_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","그것들에게 절하지 말며 그것들을 섬기지 말라 ! 나 여호와 너의 하나님은 질투하는 하나님인즉 나를 미워하는 자의 죄를 갚되 아비로부터 아들에게로 삼 사대까지 이르게 하거니와 ");
INSERT INTO kor_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","나를 사랑하고 내 계명을 지키는 자에게는 천대까지 은혜를 베푸느니라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","너는 너의 하나님 여호와의 이름을 망령되이 일컫지 말라 ! 나 여호와는 나의 이름을 망령되이 일컫는 자를 죄 없는 줄로 인정치 아니하리라 ");
INSERT INTO kor_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","여호와 너의 하나님이 네게 명한대로 안식일을 지켜 거룩하게 하라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","엿새 동안은 힘써 네 모든 일을 행할 것이나 ");
INSERT INTO kor_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","제 칠일은 너의 하나님 여호와의 안식인즉 너나, 네 아들이나, 네 딸이나, 네 남종이나, 네 여종이나, 네 소나, 네 나귀나, 네 모든 육축이나, 네 문안에 유하는 객이라도 아무 일도 하지 말고 네 남종이나, 네 여종으로 너같이 안식하게 할지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","너는 기억하라 ! 네가 애굽 땅에서 종이 되었더니 너의 하나님 여호와가 강한 손과 편 팔로 너를 거기서 인도하여 내었나니 그러므로 너의 하나님 여호와가 너를 명하여 안식일을 지키라 하느니라 ");
INSERT INTO kor_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","너는 너의 하나님 여호와의 명한대로 네 부모를 공경하라 ! 그리하면 너의 하나님 여호와가 네게 준 땅에서 네가 생명이 길고 복을 누리리라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","살인하지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","간음하지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","도적질 하지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","네 이웃에 대하여 거짓 증거하지도 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","네 이웃의 아내를 탐내지도 말지니라 ! 네 이웃의 집이나, 그의 밭이나, 그의 남종이나, 그의 여종이나, 그의 소나, 그의 나귀나, 무릇 네 이웃의 소유를 탐내지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","여호와께서 이 모든 말씀을 산 위 불 가운데, 구름 가운데, 흑암 가운데서, 큰 음성으로 너희 총회에 이르신 후에 더 말씀하지 아니하시고 그것을 두 돌판에 써서 내게 주셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","산이 불에 타며 캄캄한 가운데서 나오는 그 소리를 너희가 듣고 너희 지파의 두령과 장로들이 내게 나아와 ");
INSERT INTO kor_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","말하되 `우리 하나님 여호와께서 그 영광과 위엄을 우리에게 보이시매 불 가운데서 나오는 음성을 우리가 들었고 하나님이 사람과 말씀하시되 그 사람이 생존하는 것을 오늘날 우리가 보았나이다 ");
INSERT INTO kor_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","이제 우리가 죽을 까닭이 무엇이니이까 ? 이 큰 불이 우리를 삼킬 것이요 우리가 우리 하나님 여호와의 음성을 다시 들으면 죽을 것이라 ");
INSERT INTO kor_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","무릇 육신을 가진 자가 우리처럼 사시는 하나님의 음성이 불 가운데서 발함을 듣고 생존한 자가 누구니이까 ? ");
INSERT INTO kor_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","당신은 가까이 나아가서 우리 하나님 여호와의 하시는 말씀을 다 듣고 우리 하나님 여호와의 당신에게 이르시는 것을 다 우리에게 전하소서 우리가 듣고 행하겠나이다 !' 하였느니라 ");
INSERT INTO kor_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","여호와께서 너희가 내게 말할 때에 너희의 말하는 소리를 들으신지라 여호와께서 내게 이르시되 이 백성이 네게 말하는 그 말소리를 내가 들은즉 그 말이 다 옳도다 ");
INSERT INTO kor_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","다만 그들이 항상 이같은 마음을 품어 나를 경외하며 나의 모든 명령을 지켜서 그들과 그 자손이 영원히 복 받기를 원하노라 ");
INSERT INTO kor_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","가서 그들에게 각기 장막으로 돌아가라 이르고 ");
INSERT INTO kor_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","너는 여기 내 곁에 섰으라 ! 내가 모든 명령과 규례와 법도를 네게 이르리니 너는 그것을 그들에게 가르쳐서 내가 그들에게 기업으로 주는 땅에서 그들로 이를 행하게 하라 하셨나니 ");
INSERT INTO kor_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","그런즉 너희 하나님 여호와께서 너희에게 명령하신 대로 너희는 삼가 행하여 좌로나 우로나 치우치지 말고 ");
INSERT INTO kor_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","너희 하나님 여호와께서 너희에게 명하신 모든 도를 행하라 ! 그리하면 너희가 삶을 얻고 복을 얻어서 너희의 얻은 땅에서 너희의 날이 장구하리라 ");
INSERT INTO kor_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","이는 곧 너희 하나님 여호와께서 너희에게 가르치라 명하신 바 명령과 규례와 법도라 너희가 건너가서 얻을 땅에서 행할 것이니 ");
INSERT INTO kor_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","곧 너와 네 아들과 네 손자로 평생에 네 하나님 여호와를 경외하며 내가 너희에게 명한 그 모든 규례와 명령을 지키게 하기 위한 것이며 또 네 날을 장구케 하기 위한 것이라 ");
INSERT INTO kor_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","이스라엘아 듣고 삼가 그것을 행하라 ! 그리하면 네가 복을 얻고 네 열조의 하나님 여호와께서 네게 허락하심 같이 젖과 꿀이 흐르는 땅에서 너의 수효가 심히 번성하리라 ");
INSERT INTO kor_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","이스라엘아 들으라 ! 우리 하나님 여호와는 오직 하나인 여호와시니 ");
INSERT INTO kor_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","너는 마음을 다하고, 성품을 다하고, 힘을 다하여 네 하나님 여호와를 사랑하라 ! ");
INSERT INTO kor_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","오늘날 내가 네게 명하는 이 말씀을 너는 마음에 새기고 ");
INSERT INTO kor_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","네 자녀에게 부지런히 가르치며 집에 앉았을 때에든지, 길에 행할때에든지, 누웠을 때에든지, 일어날 때에든지, 이 말씀을 강론할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","너는 또 그것을 네 손목에 매어 기호를 삼으며 네 미간에 붙여 표를 삼고 ");
INSERT INTO kor_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","또 네 집 문설주와 바깥 문에 기록할지니라 ");
INSERT INTO kor_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","네 하나님 여호와께서 네 열조 아브라함과 이삭과 야곱을 향하여 네게 주리라 맹세하신 땅으로 너로 들어가게 하시고 네가 건축하지 아니한 크고 아름다운 성읍을 얻게 하시며 ");
INSERT INTO kor_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","네가 채우지 아니한 아름다운 물건이 가득한 집을 얻게 하시며 네가 파지 아니한 우물을 얻게 하시며 네가 심지 아니한 포도원과 감람 나무를 얻게 하사 너로 배불리 먹게 하실 때에 ");
INSERT INTO kor_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","너는 조심하여 너를 애굽 땅 종 되었던 집에서 인도하여 내신 여호와를 잊지 말고 ");
INSERT INTO kor_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","네 하나님 여호와를 경외하며 섬기며 그 이름으로 맹세할 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","너희는 다른 신들 곧 네 사면에 있는 백성의 신들을 좇지 말라 ");
INSERT INTO kor_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","너희 중에 계신 너희 하나님 여호와는 질투하시는 하나님이신즉 너희 하나님 여호와께서 네게 진노하사 너를 지면에서 멸절시키실까 두려워하노라 ");
INSERT INTO kor_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","너희가 맛사에서 시험한 것 같이 너희의 하나님 여호와를 시험하지 말고 ");
INSERT INTO kor_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","너희의 하나님 여호와께서 너희에게 명하신 명령과 증거하신 것과 규례를 삼가 지키며 ");
INSERT INTO kor_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","여호와의 보시기에 정직하고 선량한 일을 행하라 그리하면 네가 복을 얻고 여호와께서 네 열조에게 맹세하사 네 대적을 몰수히 네 앞에서 쫓아내리라 하신 아름다운 땅을 들어가서 얻으리니 여호와의 말씀과 같으리라 ");
INSERT INTO kor_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","(18절과 같음) ");
INSERT INTO kor_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","후일에 네 아들이 네게 묻기를 우리 하나님 여호와의 명하신 증거와 말씀과 규례와 법도가 무슨 뜻이뇨 ? 하거든 ");
INSERT INTO kor_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","너는 네 아들에게 이르기를 우리가 옛적에 애굽에서 바로의 종이 되었더니 여호와께서 권능의 손으로 우리를 애굽에서 인도하여 내셨나니 ");
INSERT INTO kor_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","곧 여호와께서 우리의 목전에서 크고 두려운 이적과 기사를 애굽과 바로와 그 온 집에 베푸시고 ");
INSERT INTO kor_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","우리 열조에게 맹세하신 땅으로 우리에게 주어 들어가게 하시려고 우리를 거기서 인도하여 내시고 ");
INSERT INTO kor_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","여호와께서 우리에게 이 모든 규례를 지키라 명하셨으니 이는 우리로 우리 하나님 여호와를 경외하여 항상 복을 누리게 하기 위하심이며 또 여호와께서 우리로 오늘날과 같이 생활하게 하려 하심이라 ");
INSERT INTO kor_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","우리가 그 명하신대로 이 모든 명령을 우리 하나님 여호와 앞에서 삼가 지키면 그것이 곧 우리의 의로움이니라 ! 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","네 하나님 여호와께서 너를 인도하사 네가 가서 얻을 땅으로 들이시고 네 앞에서 여러 민족 헷 족속과, 기르가스 족속과, 아모리 족속과, 가나안 족속과, 브리스 족속과, 히위 족속과, 여부스 족속 곧 너보다 많고 힘이 있는 일곱 족속을 쫓아내실 때에 ");
INSERT INTO kor_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","네 하나님 여호와께서 그들을 네게 붙여 너로 치게 하시리니 그 때에 너는 그들을 진멸할 것이라 그들과 무슨 언약도 말것이요 그들을 불쌍히 여기지도 말 것이며 ");
INSERT INTO kor_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","또 그들과 혼인하지 말지니 네 딸을 그 아들에게 주지 말 것이요 그 딸로 네 며느리를 삼지 말 것은 ");
INSERT INTO kor_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","그가 네 아들을 유혹하여 그로 여호와를 떠나고 다른 신들을 섬기게 하므로 여호와께서 너희에게 진노하사 갑자기 너희를 멸하실 것임이니라 ");
INSERT INTO kor_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","오직 너희가 그들에게 행할 것은 이러하니 그들의 단을 헐며 주상을 깨뜨리며 아세라 목상을 찍으며 조각한 우상들을 불사를 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","너는 여호와 네 하나님의 성민이라 네 하나님 여호와께서 지상 만민 중에서 너를 자기 기업의 백성으로 택하셨나니 ");
INSERT INTO kor_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","여호와께서 너희를 기뻐하시고 너희를 택하심은 너희가 다른 민족보다 수효가 많은 연고가 아니라 너희는 모든 민족 중에 가장 적으니라 ");
INSERT INTO kor_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","여호와께서 다만 너희를 사랑하심을 인하여 또는 너희 열조에게 하신 맹세를 지키려 하심을 인하여 자기의 권능의 손으로 너희를 인도하여 내시되 너희를 그 종 되었던 집에서 애굽 왕 바로의 손에서 속량하셨나니 ");
INSERT INTO kor_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","그런즉 너는 알라 ! 오직 네 하나님 여호와는 하나님이시요 신실하신 하나님이시라 그를 사랑하고 그 계명을 지키는 자에게는 천대까지 그 언약을 이행하시며 인애를 베푸시되 ");
INSERT INTO kor_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","그를 미워하는 자에게는 당장에 보응하여 멸하시나니 여호와는 자기를 미워하는 자에게 지체하지 아니하시고 당장에 그에게 보응하시느니라 ");
INSERT INTO kor_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","그런즉 너는 오늘날 내가 네게 명하는 명령과 규례와 법도를 지켜 행할지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","너희가 이 모든 법도를 듣고 지켜 행하면 네 하나님 여호와께서 네 열조에게 맹세하신 언약을 지켜 네게 인애를 베푸실 것이라 ");
INSERT INTO kor_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","곧 너를 사랑하시고 복을 주사 너로 번성케 하시되 네게 주리라고 네 열조에게 맹세하신 땅에서 네 소생에게 은혜를 베푸시며 네 토지 소산과 곡식과 포도주와 기름을 풍성케 하시고 네 소와 양을 번식케 하시리니 ");
INSERT INTO kor_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","네가 복을 받음이 만민보다 우승하여 너희 중의 남녀와 너희 짐승의 암수에 생육하지 못함이 없을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","여호와께서 또 모든 질병을 네게서 멀리하사 너희가 아는 바 그 애굽의 악질이 네게 임하지 않게 하시고 너를 미워하는 모든 자에게 임하게 하실 것이라 ");
INSERT INTO kor_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","네 하나님 여호와께서 네게 붙이신 모든 민족을 네 눈이 긍휼히 보지 말고 진멸하고 그 신을 섬기지 말라 그것이 네게 올무가 되리라 ");
INSERT INTO kor_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","네가 혹시 심중에 이르기를 이 민족들이 나보다 많으니 내가 어찌 그를 쫓아 낼 수 있으리요 하리라마는 ");
INSERT INTO kor_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","그들을 두려워 말고 네 하나님 여호와께서 바로와 온 애굽에 행하신 것을 잘 기억하되 ");
INSERT INTO kor_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","네 하나님 여호와께서 너를 인도하여 내실 때에 네가 목도한 큰 시험과 이적과 기사와 강한 손과 편 팔을 기억하라 ! 그와 같이 네 하나님 여호와께서 네가 두려워하는 모든 민족에게 행하실 것이요 ");
INSERT INTO kor_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","네 하나님 여호와께서 또 왕벌을 그들 중에 보내어 그들의 남은 자와 너를 피하여 숨은 자를 멸하시리니 ");
INSERT INTO kor_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","너는 그들을 두려워 말라 ! 너희 하나님 여호와 곧 크고 두려운 하나님이 너희 중에 계심이니라 ");
INSERT INTO kor_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","네 하나님 여호와께서 이 민족들을 네 앞에서 점점 쫓아내시리니 너는 그들을 급히 멸하지 말라 두렵건대 들짐승이 번성하여 너를 해할까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","네 하나님 여호와께서 그들을 네게 붙이시고 그들을 크게 요란케하여 필경은 진멸하시고 ");
INSERT INTO kor_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","너는 그들의 조각한 신상들을 불사르고 그것에 입힌 은이나 금을 탐내지 말며 취하지 말라 두렵건대 네가 그것으로 인하여 올무에 들까 하노니 이는 네 하나님 여호와의 가증히 여기시는 것임이니라 ");
INSERT INTO kor_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","그들의 왕들을 네 손에 붙이시리니 너는 그 이름을 천하에서 제하여 버리라 너를 당할 자가 없이 네가 필경은 그들을 진멸하리라 ");
INSERT INTO kor_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","너는 그들의 조각한 신상들을 불사르고 그것에 입힌 은이나 금을 탐내지 말며 취하지 말라 두렵건대 네가 그것으로 인하여 올무에 들까 하노니 이는 네 하나님 여호와의 가증히 여기시는 것임이니라  (Deuteronomy 7:27) 그들의 왕들을 네 손에 붙이시리니 너는 그 이름을 천하에서 제하여 버리라 너를 당할 자가 없이 네가 필경은 그들을 진멸하리라   (Deuteronomy 7:28) 너는 가증한 것을 네 집에 들이지 말라 너도 그와 같이 진멸당할 것이 될까 하노라 너는 그것을 극히 꺼리며 심히 미워하라 ! 그것은 진멸당할 것임이니라  ");
INSERT INTO kor_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","내가 오늘날 명하는 모든 명령을 너희는 지켜 행하라 ! 그리하면 너희가 살고 번성하고 여호와께서 너희의 열조에게 맹세하신 땅에 들어가서 그것을 얻으리라 ");
INSERT INTO kor_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","네 하나님 여호와께서 이 사십년 동안에 너로 광야의 길을 걷게 하신 것을 기억하라 ! 이는 너를 낮추시며 너를 시험하사 네 마음이 어떠한지 그 명령을 지키는지 아니 지키는지 알려 하심이라 ");
INSERT INTO kor_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","너를 낮추시며 너로 주리게 하시며 또 너도 알지 못하며 네 열조도 알지 못하던 만나를 네게 먹이신 것은 사람이 떡으로만 사는 것이 아니요 여호와의 입에서 나오는 모든 말씀으로 사는 줄을 너로 알게 하려 하심이니라 ");
INSERT INTO kor_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","이 사십년 동안에 네 의복이 해어지지 아니하였고 네 발이 부릍지 아니하였느니라 ");
INSERT INTO kor_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","너는 사람이 그 아들을 징계함 같이 네 하나님 여호와께서 너를 징계하시는 줄 마음에 생각하고 ");
INSERT INTO kor_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","네 하나님 여호와의 명령을 지켜 그 도를 행하며 그를 경외할지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","네 하나님 여호와께서 너를 아름다운 땅에 이르게 하시나니 그곳은 골짜기에든지 산지에든지 시내와 분천과 샘이 흐르고 ");
INSERT INTO kor_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","밀과, 보리의 소산지요, 포도와, 무화과와, 석류와, 감람들의 나무와, 꿀의 소산지라 ");
INSERT INTO kor_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","너의 먹는 식물의 결핍함이 없고 네게 아무 부족함이 없는 땅이며 그 땅의 돌은 철이요 산에서는 동을 캘 것이라 ");
INSERT INTO kor_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","네가 먹어서 배불리고 네 하나님 여호와께서 옥토로 네게 주셨음을 인하여 그를 찬송하리라 ");
INSERT INTO kor_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","내가 오늘날 네게 명하는 여호와의 명령과 법도와 규례를 지키지 아니하고 네 하나님 여호와를 잊어버리게 되지 않도록 삼갈지어다 ! ");
INSERT INTO kor_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","네가 먹어서 배불리고 아름다운 집을 짓고 거하게 되며 ");
INSERT INTO kor_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","또 네 우양이 번성하며 네 은,금이 증식되며 네 소유가 다 풍부하게 될 때에 ");
INSERT INTO kor_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","두렵건대 네 마음이 교만하여 네 하나님 여호와를 잊어버릴까 하노라 여호와는 너를 애굽 땅 종 되었던 집에서 이끌어 내시고 ");
INSERT INTO kor_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","너를 인도하여 그 광대하고 위험한 광야 곧 불뱀과 전갈이 있고 물이 없는 간조한 땅을 지나게 하셨으며 또 너를 위하여 물을 굳은 반석에서 내셨으며 ");
INSERT INTO kor_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","네 열조도 알지 못하던 만나를 광야에서 네게 먹이셨나니 이는 다 너를 낮추시며 너를 시험하사 마침내 네게 복을 주려 하심이었느니라 ");
INSERT INTO kor_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","또 두렵건대 네가 마음에 이르기를 내 능과 내 손의 힘으로 내가 이 재물을 얻었다 할까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","네 하나님 여호와를 기억하라 ! 그가 네게 재물 얻을 능을 주셨음이라 이같이 하심은 네 열조에게 맹세하신 언약을 오늘과 같이 이루려 하심이니라 ");
INSERT INTO kor_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","네가 만일 네 하나님 여호와를 잊어버리고 다른 신들을 좇아 그들을 섬기며 그들에게 절하면 내가 너희에게 증거하노니 너희가 정녕히 멸망할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","여호와께서 너희의 앞에서 멸망시키신 민족들 같이 너희도 멸망하리니 이는 너희가 너희 하나님 여호와의 소리를 청종치 아니함이니라 ");
INSERT INTO kor_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","이스라엘아 들으라 ! 네가 오늘 요단을 건너 너보다 강대한 나라들로 들어가서 그것을 얻으리니 그 성읍들은 크고 성벽은 하늘에 닿았으며 ");
INSERT INTO kor_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","그 백성은 네가 아는 바 장대한 아낙 자손이라 그에게 대한 말을 네가 들었나니 이르기를 누가 아낙 자손을 능히 당하리요 하거니와 ");
INSERT INTO kor_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","오늘날 너는 알라 ! 네 하나님 여호와께서 맹렬한 불과 같이 네 앞에 나아가신즉 여호와께서 그들을 파하사 네 앞에 엎드러지게 하시리니 여호와께서 네게 말씀하신 것 같이 너는 그들을 쫓아내며 속히 그들을 멸할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","네 하나님 여호와께서 그들을 네 앞에서 쫓아내신 후에 네가 심중에 이르기를 나의 의로움을 인하여 여호와께서 나를 이 땅으로 인도하여 들여서 그것을 얻게 하셨다 하지 말라 실상은 이 민족들이 악함을 인하여 여호와께서 그들을 네 앞에서 쫓아내심이니라 ");
INSERT INTO kor_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","네가 가서 그 땅을 얻음은 너의 의로움을 인함도 아니며 네 마음이 정직함을 인함도 아니요 이 민족들의 악함을 인하여 네 하나님 여호와께서 그들을 네 앞에서 쫓아내심이라 여호와께서 이같이 하심은 네 열조 아브라함과 이삭과 야곱에게 하신 맹세를 이루려 하심이니라 ");
INSERT INTO kor_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","그러므로 네가 알 것은 네 하나님 여호와께서 네게 이 아름다운 땅을 기업으로 주신 것이 네 의로움을 인함이 아니니라 너는 목이 곧은 백성이니라 ");
INSERT INTO kor_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","너는 광야에서 네 하나님 여호와를 격노케 하던 일을 잊지 말고 기억하라 네가 애굽 땅에서 나오던 날부터 이곳에 이르기까지 늘 여호와를 거역하였으되 ");
INSERT INTO kor_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","호렙산에서 너희가 여호와를 격노케 하였으므로 여호와께서 진노하사 너희를 멸하려 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","그 때에 내가 돌판들 곧 여호와께서 너희와 세우신 언약의 돌판들을 받으려고 산에 올라가서 사십 주야를 산에 거하며 떡도 먹지 아니하고 물도 마시지 아니하였더니 ");
INSERT INTO kor_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","여호와께서 두 돌판을 네게 주셨나니 그 판의 글은 하나님이 친수로 기록하신 것이요 너희 총회 날에 여호와께서 산상 불 가운데서 너희에게 이르신 모든 말씀이니라 ");
INSERT INTO kor_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","사십 주야가 지난 후에 여호와께서 내게 돌판 곧 언약의 두 돌판을 주시고 ");
INSERT INTO kor_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","내게 이르시되 일어나 여기서 속히 내려가라 네가 애굽에서 인도하여 낸 내 백성이 스스로 부패하여 내가 그들에게 명한 도를 속히 떠나 자기를 위하여 우상을 부어 만들었느니라 ");
INSERT INTO kor_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","여호와께서 또 내게 일러 가라사대 내가 이 백성을 보았노라 보라 ! 이는 목이 곧은 백성이니라 ");
INSERT INTO kor_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","나를 막지 말라 내가 그들을 멸하여 그 이름을 천하에서 도말하고 너로 그들보다 강대한 나라가 되게 하리라 하시기로 ");
INSERT INTO kor_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","내가 돌이켜 산에서 내려 오는데 산에는 불이 붙었고 언약의 두 돌판은 내 손에 있었느니라 ");
INSERT INTO kor_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","내가 본즉 너희가 너희 하나님 여호와께 범죄하여 자기를 위하여 송아지를 부어 만들어서 급속히 여호와의 명하신 도를 떠났기로 ");
INSERT INTO kor_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","내가 그 두 돌판을 내 두 손에서 들어 던져 너희의 목전에서 깨뜨렸었노라 ");
INSERT INTO kor_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","그리고 내가 전과 같이 사십 주야를 여호와 앞에 엎드려서 떡도 먹지 아니하고 물도 마시지 아니하였으니 이는 너희가 여호와의 목전에 악을 행하여 그를 격노케 하여 크게 죄를 얻었음이라 ");
INSERT INTO kor_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","여호와께서 심히 분노하사 너희를 멸하려 하셨으므로 내가 두려워 하였었노라 그러나 여호와께서 그 때에도 내 말을 들으셨고 ");
INSERT INTO kor_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","여호와께서 또 아론에게 진노하사 그를 멸하려 하셨으므로 내가 그 때에도 아론을 위하여 기도하고 ");
INSERT INTO kor_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","너희의 죄 곧 너희의 만든 송아지를 취하여 불살라 찧고 티끌같이 가늘게 갈아 그 가루를 산에서 흘러 내리는 시내에 뿌렸었느니라 ");
INSERT INTO kor_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","너희가 다베라와, 맛사와, 기브롯 핫다아와에서도 여호와를 격노케 하였느니라 ");
INSERT INTO kor_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","여호와께서 너희를 가데스 바네아에서 떠나게 하실 때에 이르시기를 너희는 올라가서 내가 너희에게 준 땅을 얻으라 하시되 너희가 너희 하나님 여호와의 명령을 거역하여 믿지 아니하고 그 말씀을 듣지 아니하였나니 ");
INSERT INTO kor_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","내가 너희를 알던 날부터 옴으로 너희가 항상 여호와를 거역하였느니라 ");
INSERT INTO kor_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","그 때에 여호와께서 너희를 멸하겠다 하셨으므로 내가 여전히 사십 주야를 여호와 앞에 엎드리고 ");
INSERT INTO kor_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","여호와께 간구하여 가로되 `주 여호와여 ! 주께서 큰 위엄으로 속하시고 강한 손으로 애굽에서 인도하여 내신 주의 백성 곧 주의 기업을 멸하지 마옵소서 ");
INSERT INTO kor_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","주의 종 아브라함과 이삭과 야곱을 생각하사 이 백성의 강퍅과 악과 죄를 보지 마옵소서 ");
INSERT INTO kor_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","주께서 우리를 인도하여 내신 그 땅 백성이 말하기를 여호와께서 그들에게 허락하신 땅으로 그들을 인도하여 들일 능력도 없고 그들을 미워도 하사 광야에서 죽이려고 인도하여 내셨다 할까 두려워하나이다 ");
INSERT INTO kor_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","그들은 주의 큰 능력과 펴신 팔로 인도하여 내신 주의 백성 곧 주의 기업이로소이다' 하였었노라 ");
INSERT INTO kor_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","그 때에 여호와께서 내게 이르시기를 너는 처음과 같은 두 돌판을 다듬어 가지고 산에 올라 내게로 나아오고 또 나무궤 하나를 만들라 ");
INSERT INTO kor_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","네가 깨뜨린 처음 판에 쓴 말을 내가 그 판에 쓰리니 너는 그것을 그 궤에 넣으라 하시기로 ");
INSERT INTO kor_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","내가 싯딤나무로 궤를 만들고 처음 것과 같은 돌판 둘을 다듬어 손에 들고 산에 오르매 ");
INSERT INTO kor_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","여호와께서 그 총회 날에 산 위 불 가운데서 너희에게 이르신 십계명을 처음과 같이 그 판에 쓰시고 그것을 내게 주시기로 ");
INSERT INTO kor_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","내가 돌이켜 산에서 내려와서 여호와께서 내게 명하신 대로 그 판을 내가 만든 궤에 넣었더니 지금까지 있느니라 ");
INSERT INTO kor_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","이스라엘 자손이 브에롯 브네야아간에서 발행하여 모세라에 이르러서는 아론이 거기서 죽고 거기 장사되었고 그 아들 엘르아살이 그를 이어 제사장의 직임을 행하였으며 ");
INSERT INTO kor_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","또 거기서 발행하여 굿고다에 이르고 굿고다에서 발행하여 욧바다에 이른즉 그 땅에는 시내가 많았었으며 ");
INSERT INTO kor_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","그 때에 여호와께서 레위 지파를 구별하여 여호와의 언약 궤를 메이며 여호와 앞에 서서 그를 섬기며 또 여호와의 이름으로 축복하게 하셨고 그 일은 오늘날까지 이르느니라 ");
INSERT INTO kor_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","그러므로 레위는 그 형제 중에 분깃이 없으며 기업이 없고 네 하나님 여호와께서 그에게 말씀하심 같이 여호와가 그의 기업이시니라 ");
INSERT INTO kor_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","내가 처음과 같이 사십 주야를 산에서 유하였고 그 때에도 여호와께서 내 말을 들으사 너를 참아 멸하지 아니하시고 ");
INSERT INTO kor_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","여호와께서 내게 이르시되 일어나서 백성 앞서 진행하라 내가 그들에게 주리라고 그 열조에게 맹세한 땅에 그들이 들어가서 그것을 얻으리라 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","이스라엘아 ! 네 하나님 여호와께서 네게 요구하시는 것이 무엇이냐 ? 곧 네 하나님 여호와를 경외하여 그 모든 도를 행하고 그를 사랑하며 마음을 다하고 성품을 다하여 네 하나님 여호와를 섬기고 ");
INSERT INTO kor_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","내가 오늘날 네 행복을 위하여 네게 명하는 여호와의 명령과 규례를 지킬 것이 아니냐 ? ");
INSERT INTO kor_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","하늘과 모든 하늘의 하늘과 땅과 그 위의 만물은 본래 네 하나님 여호와께 속한 것이로되 ");
INSERT INTO kor_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","여호와께서 오직 네 열조를 기뻐하시고 그들을 사랑하사 그 후손 너희를 만민 중에서 택하셨음이 오늘날과 같으니라 ");
INSERT INTO kor_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","그러므로 너희는 마음에 할례를 행하고 다시는 목을 곧게 하지 말라 ");
INSERT INTO kor_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","너희의 하나님 여호와는 신의 신이시요, 주의 주시요, 크고 능하시며 두려우신 하나님이시라 사람을 외모로 보지 아니하시며 뇌물을 받지 아니하시고 ");
INSERT INTO kor_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","고아와 과부를 위하여 신원하시며 나그네를 사랑하사 그에게 식물과 의복을 주시나니 ");
INSERT INTO kor_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","너희는 나그네를 사랑하라 ! 전에 너희도 애굽 땅에서 나그네 되었었음이니라 ");
INSERT INTO kor_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","네 하나님 여호와를 경외하여 그를 섬기며 그에게 친근히 하고 그 이름으로 맹세하라 ");
INSERT INTO kor_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","그는 네 찬송이시요 ! 네 하나님이시라 ! 네가 목도한 바 이같이 크고 두려운 일을 너를 위하여 행하셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","애굽에 내려간 네 열조가 겨우 칠십인이었으나 이제는 네 하나님 여호와께서 너를 하늘의 별같이 많게 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","그런즉 네 하나님 여호와를 사랑하여 그 직임과 법도와 규례와 명령을 항상 지키라 ! ");
INSERT INTO kor_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","너희의 자녀는 알지도 못하고 보지도 못하였으나 너희가 오늘날 기억할 것은 너희 하나님 여호와의 징계와 그 위엄과 그 강한 손과 펴신 팔과 ");
INSERT INTO kor_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","애굽에서 그 왕 바로와 그 전국에 행하신 이적과 기사와 ");
INSERT INTO kor_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","또 여호와께서 애굽 군대와 그 말과 그 병거에 행하신 일 곧 그들이 너희를 따를 때에 홍해 물로 그들을 덮어 멸하사 오늘까지 이른 것과 ");
INSERT INTO kor_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","또 너희가 이곳에 이르기까지 광야에서 너희에게 행하신 일과 ");
INSERT INTO kor_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","르우벤 자손 엘리압의 아들 다답과 아비람에게 하신 일 곧 온 이스라엘의 한가운데서 땅으로 입을 열어서 그들과 그 가족과 그 장막과 그를 따르는 모든 샘물을 삼키게 하신 일이라 ");
INSERT INTO kor_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","너희가 여호와의 행하신 이 모든 큰 일을 목도하였느니라 ");
INSERT INTO kor_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","그러므로 너희는 내가 오늘날 너희에게 명하는 모든 명령을 지키라 ! 그리하면 너희가 강성할 것이요 너희가 건너가서 얻을 땅에 들어가서 그것을 얻을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","또 여호와께서 너희의 열조에게 맹세하사 그와 그 후손에게 주리라고 하신 땅 곧 젖과 꿀이 흐르는 땅에서 너희의 날이 장구하리라 ");
INSERT INTO kor_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","네가 들어가 얻으려 하는 땅은 네가 나온 애굽 땅과 같지 아니하니 거기서는 너희가 파종한 후에 발로 물대기를 채소 밭에 댐과 같이 하였거니와 ");
INSERT INTO kor_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","너희가 건너가서 얻을 땅은 산과 골짜기가 있어서 하늘에서 내리는 비를 흡수하는 땅이요 ");
INSERT INTO kor_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","네 하나님 여호와께서 권고하시는 땅이라 세초부터 세말까지 네 하나님 여호와의 눈이 항상 그 위에 있느니라 ");
INSERT INTO kor_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","내가 오늘날 너희에게 명하는 나의 명령을 너희가 만일 청종하고 너희의 하나님 여호와를 사랑하여 마음을 다하고 성품을 다하여 섬기면 ");
INSERT INTO kor_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","여호와께서 너희 땅에 이른비, 늦은비를 적당한 때에 내리시리니 너희가 곡식과 포도주와 기름을 얻을 것이요 ");
INSERT INTO kor_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","또 육축을 위하여 들에 풀이 나게 하시리니 네가 먹고 배부를 것이라 ");
INSERT INTO kor_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","너희는 스스로 삼가라 두렵건대 마음에 미혹하여 돌이켜 다른 신들을 섬기며 그것에 절하므로 ");
INSERT INTO kor_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","여호와께서 너희에게 진노하사 하늘을 닫아 비를 내리지 아니하여 땅으로 소산을 내지 않게 하시므로 너희가 여호와의 주신 아름다운 땅에서 속히 멸망할까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","이러므로 너희는 나의 이 말을 너희 마음과 뜻에 두고 또 그것으로 너희 손목에 매어 기호를 삼고 너희 미간에 붙여 표를 삼으며 ");
INSERT INTO kor_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","또 그것을 너희의 자녀에게 가르치며 집에 앉았을 때에든지,길에 행할 때에든지, 누웠을 때에든지,일어날 때에든지 이 말씀을 강론하고 ");
INSERT INTO kor_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","또 네 집 문설주와 바깥 문에 기록하라 ");
INSERT INTO kor_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","그리하면 여호와께서 너희 열조에게 주리라고 맹세하신 땅에서 너희의 날과 너희 자녀의 날이 많아서 하늘이 땅을 덮는 날의 장구함 같으리라 ");
INSERT INTO kor_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","너희가 만일 내가 너희에게 명하는 이 모든 명령을 잘 지켜 행하여 너희 하나님 여호와를 사랑하고 그 모든 도를 행하여 그에게 부종하면 ");
INSERT INTO kor_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","여호와께서 그 모든 나라 백성을 너희 앞에서 다 쫓아내실 것이라 너희가 너희보다 강대한 나라들을 얻을 것인즉 ");
INSERT INTO kor_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","너희의 발바닥으로 밟는 곳은 다 너희 소유가 되리니 너희의 경계는 곧 광야에서부터 레바논까지와 유브라데 하수라 하는 하수에서 서해까지라 ");
INSERT INTO kor_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","너희 하나님 여호와께서 너희에게 말씀하신 대로 너희 밟는 모든땅 사람들로 너희를 두려워하고 무서워하게 하시리니 너희를 능히 당할 사람이 없으리라 ");
INSERT INTO kor_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","내가 오늘날 복과 저주를 너희 앞에 두나니 ");
INSERT INTO kor_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","너희가 만일 내가 오늘날 너희에게 명하는 너희 하나님 여호와의 명령을 들으면 복이 될 것이요 ");
INSERT INTO kor_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","너희가 만일 내가 오늘날 너희에게 명하는 도에서 돌이켜 떠나 너희 하나님 여호와의 명령을 듣지 아니하고 본래 알지 못하던 다른 신들을 좇으면 저주를 받으리라 ! ");
INSERT INTO kor_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","네 하나님 여호와께서 네가 가서 얻을 땅으로 너를 인도하여 들이실 때에 너는 그리심산에서 축복을 선포하고 에발산에서 저주를 선포하라 ");
INSERT INTO kor_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","이 두 산은 요단강 저편 곧 해 지는 편으로 가는 길 뒤 길갈 맞은편 모레 상수리나무 곁의 아라바에 거하는 가나안 족속의 땅에 있지 아니하냐 ? ");
INSERT INTO kor_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","너희가 요단을 건너 너희 하나님 여호와께서 너희에게 주시는 땅에 들어가서 얻으려 하나니 반드시 그것을 얻어 거기 거할지라 ");
INSERT INTO kor_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","내가 오늘날 너희 앞에 베푸는 모든 규례와 법도를 너희는 지켜 행할지니라 ");
INSERT INTO kor_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","네 열조의 하나님 여호와께서 네게 주셔서 얻게 하신 땅에서 너희가 평생에 지켜 행할 규례와 법도는 이러하니라 ");
INSERT INTO kor_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","너희가 쫓아 낼 민족들이 그 신들을 섬기는 곳은 높은 산이든지 작은 산이든지 푸른 나무 아래든지 무론하고 그 모든 곳을 너희가 마땅히 파멸하며 ");
INSERT INTO kor_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","그 단을 헐며 주상을 깨뜨리며 아세라 상을 불사르고 또 그 조각한 신상들을 찍어서 그 이름을 그곳에서 멸하라 ");
INSERT INTO kor_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","너희 하나님 여호와에게는 너희가 그처럼 행하지 말고 ");
INSERT INTO kor_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","오직 너희 하나님 여호와께서 자기 이름을 두시려고 너희 모든 지파 중에서 택하신 곳인 그 거하실 곳으로 찾아 나아가서 ");
INSERT INTO kor_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","너희 번제와 너희 희생과 너희의 십일조와 너희 손의 거제와 너희 서원제와 낙헌 예물과 너희 우양의 처음 낳은 것들을 너희는 그리로 가져다가 드리고 ");
INSERT INTO kor_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","거기 곧 너희 하나님 여호와 앞에서 먹고 너희 하나님 여호와께서 너희 손으로 수고한 일에 복 주심을 인하여 너희와 너희 가족이 즐거워할지니라 ");
INSERT INTO kor_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","우리가 오늘날 여기서는 각기 소견대로 하였거니와 너희가 거기서는 하지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","너희가 너희 하나님 여호와의 주시는 안식과 기업에 아직은 이르지 못하였거니와 ");
INSERT INTO kor_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","너희가 요단을 건너 너희 하나님 여호와께서 너희에게 기업으로 주시는 땅에 거하게 될 때 또는 여호와께서 너희로 너희 사방의 모든 대적을 이기게 하시고 너희에게 안식을 주사 너희로 평안히 거하게 하실 때에 ");
INSERT INTO kor_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","너희는 너희 하나님 여호와께서 자기 이름을 두시려고 한 곳을 택하실 그 곳으로 나의 명하는 것을 모두 가지고 갈지니 곧 너희 번제와, 너희 희생과, 너희 십일조와, 너희 손의 거제와, 너희가 여호와께 서원하는 모든 아름다운 서원물을 가져가고 ");
INSERT INTO kor_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","너희와 너희 자녀와 노비와 함께 너희 하나님 여호와 앞에서 즐거워할 것이요 네 성중에 거하는 레위인과도 그리할지니 레위인 은 너희 중에 분깃이나 기업이 없음이니라 ");
INSERT INTO kor_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","너는 삼가서 네게 보이는 아무 곳에서든지 번제를 드리지 말고 ");
INSERT INTO kor_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","오직 너희의 한 지파 중에 여호와의 택하실 그 곳에서 너는 번제를 드리고 또 내가 네게 명하는 모든 것을 거기서 행할지니라 ");
INSERT INTO kor_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","그러나 네 하나님 여호와께서 네게 주신 복을 따라 각 성에서 네 마음에 즐기는 대로 생축을 잡아 그 고기를 먹을 수 있나니 곧 정한 자나 부정한 자를 무론하고 노루나 사슴을 먹음과 같이 먹으려니와 ");
INSERT INTO kor_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","오직 그 피는 먹지 말고 물 같이 땅에 쏟을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","너는 곡식과 포도주와 기름의 십일조와 네 우양의 처음 낳은 것과 너의 서원을 갚는 예물과 너의 낙헌 예물과 네 손의 거제물은 너의 각 성에서 먹지 말고 ");
INSERT INTO kor_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","오직 네 하나님 여호와께서 택하실 곳에서 네 하나님 여호와 앞에서 너는 네 자녀와 노비와 성중에 거하는 레위인과 함께 그것을 먹고 또 네 손으로 수고한 모든 일을 인하여 네 하나님 여호와 앞에서 즐거워하되 ");
INSERT INTO kor_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","너는 삼가서 네 땅에 거하는 동안에 레위인을 저버리지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","네 하나님 여호와께서 네게 허락하신 대로 네 지경을 넓히신 후에 네 마음에 고기를 먹고자 하여 이르기를 내가 고기를 먹으리라 하면 네가 무릇 마음에 좋아하는 대로 고기를 먹을 수 있으리니 ");
INSERT INTO kor_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","만일 네 하나님 여호와께서 자기 이름을 두시려고 택하신 곳이 네게서 멀거든 내가 네게 명한 대로 너는 여호와의 주신 우양을 잡아 너의 각 성에서 네가 무릇 마음에 좋아하는 것을 먹되 ");
INSERT INTO kor_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","정한 자나 부정한 자를 무론하고 노루나 사슴을 먹음같이 먹을 수 있거니와 ");
INSERT INTO kor_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","오직 크게 삼가서 그 피는 먹지 말라 ! 피는 그 생명인즉 네가 그 생명을 고기와 아울러 먹지 못하리니 ");
INSERT INTO kor_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","너는 그것을 먹지 말고 물 같이 땅에 쏟으라 ! ");
INSERT INTO kor_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","너는 피를 먹지 말라 ! 네가 이같이 여호와께서 의롭게 여기시는 일을 행하면 너와 네 후손이 복을 누리리라 ! ");
INSERT INTO kor_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","오직 네 성물과 서원물을 여호와께서 택하신 곳으로 가지고 가라 ");
INSERT INTO kor_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","네가 번제를 드릴 때에는 그 고기와 피를 네 하나님 여호와의 단에 드릴 것이요 다른 제 희생을 드릴 때에는 그 피를 네 하나님 여호와의 단 위에 붓고 그 고기는 먹을지니라 ");
INSERT INTO kor_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","내가 네게 명하는 이 모든 말을 너는 듣고 지키라 ! 네 하나님 여호와의 목전에 선과 의를 행하면 너와 네 후손에게 영원히 복이 있으리라 ! ");
INSERT INTO kor_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","네 하나님 여호와께서 네가 들어가서 쫓아낼 그 민족들을 네 앞에서 멸절하시고 너로 그 땅을 얻어 거기 거하게 하실 때에 ");
INSERT INTO kor_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","너는 스스로 삼가서 네 앞에서 멸망한 그들의 자취를 밟아 올무에 들지 말라 또 그들의 신을 탐구하여 이르기를 이 민족들은 그 신들을 어떻게 위하였는고 나도 그와 같이 하겠다 하지 말라 ");
INSERT INTO kor_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","네 하나님 여호와께는 네가 그와 같이 행하지 못할 것이라 그들은 여호와의 꺼리시며 가증히 여기시는 일을 그 신들에게 행하여 심지어 그 자녀를 불살라 그 신들에게 드렸느니라 ");
INSERT INTO kor_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","내가 너희에게 명하는 이 모든 말을 너희는 지켜 행하고 그것에 가감하지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","너희 중에 선지자나 꿈 꾸는 자가 일어나서 이적과 기사를 네게 보이고 ");
INSERT INTO kor_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","네게 말하기를 네가 본래 알지 못하던 다른 신들을 우리가 좇아 섬기자 하며 이적과 기사가 그 말대로 이룰지라도 ");
INSERT INTO kor_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","너는 그 선지자나 꿈꾸는 자의 말을 청종하지 말라 이는 너희 하나님 여호와께서 너희가 마음을 다하고 성품을 다하여 너희 하나님 여호와를 사랑하는 여부를 알려 하사 너희를 시험하심이니라 ");
INSERT INTO kor_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","너희는 너희 하나님 여호와를 순종하며 그를 경외하며 그 명령을 지키며 그 목소리를 청종하며 그를 섬기며 그에게 부종하고 ");
INSERT INTO kor_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","그 선지자나 꿈 꾸는 자는 죽이라 ! 이는 그가 너희로 너희를 애굽 땅에서 인도하여 내시며 종 되었던 집에서 속량하여 취하신 너희 하나님 여호와를 배반케 하려 하며 너희 하나님 여호와께서 네게 행하라 명하신 도에서 너를 꾀어 내려고 말하였음이라 너는 이같이 하여 너희 중에서 악을 제할지니라 ");
INSERT INTO kor_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","네 동복 형제나 네 자녀나 네 품의 아내나 너와 생명을 함께 하는 친구가 가만히 너를 꾀어 이르기를 너와 네 열조가 알지 못하던 다른 신들 ");
INSERT INTO kor_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","곧 네 사방에 둘러 있는 민족 혹 네게서 가깝든지 네게서 멀든지 땅 이 끝에서 저 끝까지 있는 민족의 신들을 우리가 가서 섬기자 할지라도 ");
INSERT INTO kor_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","너는 그를 좇지 말며 듣지 말며 긍휼히 보지 말며 애석히 여기지 말며 덮어 숨기지 말고 ");
INSERT INTO kor_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","너는 용서없이 그를 죽이되 죽일 때에 네가 먼저 그에게 손을 대고 후에 뭇 백성이 손을 대라 ");
INSERT INTO kor_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","그는 애굽 땅 종 되었던 집에서 너를 인도하여 내신 네 하나님 여호와에게서 너를 꾀어 떠나게 하려한 자니 너는 돌로 쳐 죽이라 ! ");
INSERT INTO kor_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","그리하면 온 이스라엘이 듣고 두려워하여 이같은 악을 다시는 너희 중에서 행하지 못하리라 ");
INSERT INTO kor_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","네 하나님 여호와께서 네게 주어 거하게 하시는 한 성읍에 대하여 네게 소문이 들리기를 ");
INSERT INTO kor_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","너희 중 어떤 잡류가 일어나서 그 성읍 거민을 유혹하여 이르기를 너희가 알지 못하던 다른 신들을 우리가 가서 섬기자 한다 하거든 ");
INSERT INTO kor_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","너는 자세히 묻고 살펴보아서 이런 가증한 일이 참 사실로 너희 중에 있으면 ");
INSERT INTO kor_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","너는 마땅히 그 성읍 거민을 칼날로 죽이고 그 성읍과 그 중에 거하는 모든 것과 그 생축을 칼날로 진멸하고 ");
INSERT INTO kor_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","또 그 속에서 빼앗아 얻은 물건을 다 거리에 모아 놓고 그 성읍과 그 탈취물 전부를 불살라 네 하나님 여호와께 드릴지니 그 성읍은 영영히 무더기가 되어 다시는 건축됨이 없을 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","너는 이 진멸할 물건을 조금도 네 손에 대지 말라 그리하면 여호와께서 그 진노를 그치시고 너를 긍휼히 여기시고 자비를 더하사 너의 열조에게 맹세하심 같이 네 수효를 번성케 하실 것이라 ");
INSERT INTO kor_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","네가 만일 네 하나님 여호와의 말씀을 듣고 오늘날 내가 네게 명하는 그 모든 명령을 지켜 네 하나님 여호와의 목전에 정직을 행하면 이같이 되리라 ");
INSERT INTO kor_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","너희는 너희 하나님 여호와의 자녀니 죽은 자를 위하여 자기 몸을 베지 말며 눈썹 사이 이마 위의 털을 밀지 말라 ");
INSERT INTO kor_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","너는 너의 하나님 여호와의 성민이라 여호와께서 지상 만민 중에서 너를 택하여 자기의 기업의 백성을 삼으셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","너는 가증한 물건은 무엇이든지 먹지 말라 ! ");
INSERT INTO kor_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","너희의 먹을 만한 짐승은 이러하니 곧 소와, 양과, 염소와, ");
INSERT INTO kor_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","사슴과, 노루와, 불그스럼한 사슴과, 산 염소와, 볼기 흰 노루와, 뿔 긴 사슴과, 산양들, ");
INSERT INTO kor_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","무릇 짐승 중에 굽이 갈라져 쪽발도 되고 새김질도 하는 것은 너희가 먹을 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","다만 새김질을 하거나 굽이 갈라진 짐승 중에도 너희가 먹지 못할 것은 이것이니 곧 약대와, 토끼와, 사반 그것들은 새김질을 하나 굽이 갈라지지 아니하였으니 너희에게 부정하고 ");
INSERT INTO kor_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","돼지는 굽은 갈라졌으나 새김질을 못하므로 너희에게 부정하니 너희는 이런 것의 고기를 먹지 말 것이며 그 사체도 만지지 말 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","물에 있는 어족 중에 이런 것은 너희가 먹을 것이니 무릇 지느러미와 비늘 있는 것은 너희가 먹을 것이요 ");
INSERT INTO kor_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","무릇 지느러미와 비늘이 없는 것은 너희가 먹지 말지니 이는 너희에게 부정하니라 ");
INSERT INTO kor_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","무릇 정한 새는 너희가 먹으려니와 ");
INSERT INTO kor_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","이런 것은 너희가 먹지 못할지니 곧 독수리와, 솔개와, 어응과, ");
INSERT INTO kor_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","매와, 새매와, 매의 종류와, ");
INSERT INTO kor_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","까마귀 종류와, ");
INSERT INTO kor_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","타조와, 다호마스와, 갈매기와, 새매 종류와, ");
INSERT INTO kor_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","올빼미와, 부엉이와, 따오기와, ");
INSERT INTO kor_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","당아와, 올응과, 노자와, ");
INSERT INTO kor_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","학과, 황새 종류와, 대승과, 박쥐며, ");
INSERT INTO kor_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","또 무릇 날기도 하고 기어 다니기도 하는 것은 너희에게 부정하니 너희는 먹지 말 것이나 ");
INSERT INTO kor_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","무릇 정한 새는 너희가 먹을지니라 ");
INSERT INTO kor_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","너희는 너희 하나님 여호와의 성민이라 무릇 스스로 죽은 것은 먹지 말 것이니 그것을 성 중에 우거하는 객에게 주어 먹게 하거나 이방인에게 팔아도 가하니라 너는 염소 새끼를 그 어미의 젖에 삶지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","너는 마땅히 매년에 토지 소산의 십일조를 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","네 하나님 여호와 앞 곧 여호와께서 그 이름을 두시려고 택하신 곳에서 네 곡식과 포도주와 기름의 십일조를 먹으며 또 네 우양의 처음 난 것을 먹고 네 하나님 여호와 경외하기를 항상 배울 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","그러나 네 하나님 여호와께서 그 이름을 두시려고 택하신 곳이 네게서 너무 멀고 행로가 어려워서 그 풍부히 주신 것을 가지고 갈 수 없거든 ");
INSERT INTO kor_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","그것을 돈으로 바꾸어 그 돈을 싸서 가지고 네 하나님 여호와의 택하신 곳으로 가서 ");
INSERT INTO kor_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","무릇 네 마음에 좋아하는 것을 그 돈으로 사되 우양이나 포도주나 독주 등 무릇 네 마음에 원하는 것을 구하고 거기 네 하나님 여호와의 앞에서 너와 네 권속이 함께 먹고 즐거워할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","네 성읍에 거하는 레위인은 너희 중에 분깃이나 기업이 없는 자니 또한 저버리지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","매 삼년 끝에 그 해 소산의 십분 일을 다 내어 네 성읍에 저축하여 ");
INSERT INTO kor_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","너희 중에 분깃이나 기업이 없는 레위인과 네 성중에 우거하는 객과 및 고아와 과부들로 와서 먹어 배부르게 하라 그리하면 네 하나님 여호와께서 너의 손으로 하는 범사에 네게 축복을 주시리라 ");
INSERT INTO kor_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","매 칠년 끝에 면제하라 ");
INSERT INTO kor_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","면제의 규례는 이러하니라 무릇 그 이웃에게 꾸어준 채주는 그것을 면제하고 그 이웃에게나 그 형제에게 독촉하지 말지니 이 해는 여호와의 면제년이라 칭함이니라 ");
INSERT INTO kor_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","이방인에게는 네가 독촉하려니와 네 형제에게 꾸인 것은 네 손에서 면제하라 ");
INSERT INTO kor_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","네가 만일 네 하나님 여호와의 말씀만 듣고 내가 오늘날 네게 명하는 그 명령을 다 지켜 행하면 네 하나님 여호와께서 네게 유업으로 주신 땅에서 네가 정녕 복을 받으리니 너희 중에 가난한 자가 없으리라 ");
INSERT INTO kor_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","(4절과 같음) ");
INSERT INTO kor_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","네 하나님 여호와께서 네게 허락하신 대로 네게 복을 주시리니 네가 여러 나라에 꾸어 줄지라도 너는 꾸지 아니하겠고 네가 여러 나라를 치리할지라도 너는 치리함을 받지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","네 하나님 여호와께서 네게 주신 땅 어느 성읍에서든지 가난한 형제가 너와 함께 거하거든 그 가난한 형제에게 네 마음을 강퍅히 하지 말며 네 손을 움켜 쥐지 말고 ");
INSERT INTO kor_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","반드시 네 손을 그에게 펴서 그 요구하는 대로 쓸 것을 넉넉히 꾸어주라 ");
INSERT INTO kor_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","삼가 너는 마음에 악념을 품지 말라 곧 이르기를 제 칠년 면제년이 가까왔다 하고 네 궁핍한 형제에게 악한 눈을 들고 아무 것도 주지 아니하면 그가 너를 여호와께 호소하리니 네가 죄를 얻을 것이라 ");
INSERT INTO kor_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","너는 반드시 그에게 구제할 것이요 구제할 때에는 아끼는 마음을 품지 말 것이니라 이로 인하여 네 하나님 여호와께서 네 범사와 네 손으로 하는바에 네게 복을 주시리라 ! ");
INSERT INTO kor_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","땅에는 언제든지 가난한 자가 그치지 아니하겠는고로 내가 네게 명하여 이르노니 너는 반드시 네 경내 네 형제의 곤란한 자와 궁핍한 자에게 네 손을 펼지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","네 동족 히브리 남자나 히브리 여자가 네게 팔렸다 하자 만일 육년을 너를 섬겼거든 제 칠년에 너는 그를 놓아 자유하게 할 것이요 ");
INSERT INTO kor_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","그를 놓아 자유하게 할 때에는 공수로 가게 하지 말고 ");
INSERT INTO kor_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","네 양 무리 중에서와 타작 마당에서와 포도주 틀에서 그에게 후히 줄지니 곧 네 하나님 여호와께서 네게 복을 주신대로 그에게 줄지니라 ");
INSERT INTO kor_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","너는 애굽 땅 종 되었던 것과 네 하나님 여호와께서 너를 속하셨음을 기억하라 ! 그를 인하여 내가 오늘날 이같이 네게 명하노라 ");
INSERT INTO kor_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","종이 만일 너와 네 집을 사랑하므로 너와 동거하기를 좋게 여겨 네게 향하여 내가 주인을 떠나지 아니하겠노라 하거든 ");
INSERT INTO kor_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","송곳을 취하여 그의 귀를 문에 대고 뚫으라 그리하면 그가 영영히 네 종이 되리라 네 여종에게도 일례로 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","그가 육년 동안에 품군의 삯의 배나 받을 만큼 너를 섬겼은즉 너는 그를 놓아 자유하게 하기를 어렵게 여기지 말라 그리하면 네 하나님 여호와께서 너의 범사에 네게 복을 주시리라 ! ");
INSERT INTO kor_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","너는 우양의 처음 난 수컷은 구별하여 네 하나님 여호와께 드릴 것이니 네 소의 첫 새끼는 부리지 말고 네 양의 첫 새끼의 털은 깍지 말고 ");
INSERT INTO kor_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","너와 네 가족이 매년에 여호와의 택하신 곳 네 하나님 여호와 앞에서 먹을지니라 ");
INSERT INTO kor_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","그러나 그 짐승이 흠이 있어서 절거나 눈이 멀었거나 무슨 흠이 있든지 네 하나님 여호와께 잡아 드리지 못할지니 ");
INSERT INTO kor_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","네 성 중에서 먹되 부정한 자나 정한 자가 다 같이 먹기를 노루와 사슴을 먹음같이 할 것이요 ");
INSERT INTO kor_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","오직 피는 먹지 말고 물 같이 땅에 쏟을 지니라 ");
INSERT INTO kor_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","아빕월을 지켜 네 하나님 여호와의 유월절 예식을 행하라 ! 이는 아빕월에 네 하나님 여호와께서 밤에 너를 애굽에서 인도하여 내셨음이라 ");
INSERT INTO kor_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","여호와께서 그 이름을 두시려고 택하신 곳에서 우양으로 네 하나님 여호와께 유월절 제사를 드리되 ");
INSERT INTO kor_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","유교병을 그것과 아울러 먹지 말고 칠일 동안은 무교병 곧 고난의 떡을 그것과 아울러 먹으라 이는 네가 애굽 땅에서 급속히 나왔음이니 이같이 행하여 너의 평생에 항상 네가 애굽 땅에서 나온 날을 기억할 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","그 칠일 동안에는 네 사경내에 누룩이 보이지 않게 할 것이요 또 네가 첫날 해 질 때에 제사드린 고기를 밤을 지내어 아침까지 두지 말 것이며 ");
INSERT INTO kor_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","유월절 제사를 네 하나님 여호와께서 네게 주신 각 성에서 드리지 말고 ");
INSERT INTO kor_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","오직 네 하나님 여호와께서 그 이름을 두시려고 택하신 곳에서 네가 애굽에서 나오던 시각 곧 초저녁 해 질 때에 드리고 ");
INSERT INTO kor_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","네 하나님 여호와께서 택하신 곳에서 그 고기를 구워먹고 아침에 네 장막으로 돌아갈 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","너는 육일 동안은 무교병을 먹고 제 칠일에 네 하나님 여호와 앞에 성회로 모이고 아무 노동도 하지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","칠주를 계속할지니 곡식에 낫을 대는 첫날부터 칠주를 계수하여 ");
INSERT INTO kor_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","네 하나님 여호와 앞에 칠칠절을 지키되 네 하나님 여호와께서 네게 복을 주신 대로 네 힘을 헤아려 자원하는 예물을 드리고 ");
INSERT INTO kor_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","너와 네 자녀와 노비와 네 성중에 거하는 레위인과 및 너희 중에 있는 객과 고아와 과부가 함께 네 하나님 여호와께서 그 이름을 두시려고 택하신 곳에서 네 하나님 여호와 앞에서 즐거워할지니라 ");
INSERT INTO kor_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","너는 애굽에서 종 되었던 것을 기억하고 이 규례를 지켜 행할지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","너희 타작 마당과 포도주 틀의 소출을 수장한 후에 칠일동안 초막절을 지킬 것이요 ");
INSERT INTO kor_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","절기를 지킬 때에는 너와 네 자녀와 노비와 네 성중에 거하는 레위인과 객과 고아와 과부가 함께 연락하되 ");
INSERT INTO kor_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","네 하나님 여호와께서 택하신 곳에서 너는 칠일 동안 네 하나님 여호와 앞에서 절기를 지키고 네 하나님 여호와께서 네 모든 물산과 네 손을 댄 모든 일에 복 주실 것을 인하여 너는 온전히 즐거워할지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","너의 중 모든 남자는 일년 삼차 곧 무교절과, 칠칠절과, 초막절에 네 하나님 여호와의 택하신 곳에서 여호와께 보이되 공수로 여호와께 보이지 말고 ");
INSERT INTO kor_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","각 사람이 네 하나님 여호와의 주신 복을 따라 그 힘대로 물건을 드릴지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","네 하나님 여호와께서 네게 주시는 각 성에서 네 지파를 따라 재판장과 유사를 둘 것이요 그들은 공의로 백성을 재판할 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","너는 굽게 판단하지 말며 사람을 외모로 보지 말며 또 뇌물을 받지 말라 뇌물은 지혜자의 눈을 어둡게 하고 의인의 말을 굽게 하느니라 ");
INSERT INTO kor_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","너는 마땅히 공의만 좇으라 ! 그리하면 네가 살겠고 네 하나님 여호와께서 네게 주시는 땅을 얻으리라 ");
INSERT INTO kor_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","네 하나님 여호와를 위하여 쌓은 단 곁에 아무 나무로든지 아세라 상을 세우지 말며 ");
INSERT INTO kor_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","자기를 위하여 주상을 세우지 말라 ! 네 하나님 여호와께서 미워하시느니라 ");
INSERT INTO kor_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","무릇 흠이나 악질이 있는 우양은 네 하나님 여호와께 드리지 말지니 이는 네 하나님 여호와께 가증한 것이 됨이니라 ");
INSERT INTO kor_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","네 하나님 여호와께서 네게 주시는 어느 성중에서든지 너의 가운데 혹시 어떤 남자나 여자가 네 하나님 여호와의 목전에 악을 행하여 그 언약을 어기고 ");
INSERT INTO kor_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","가서 다른 신들을 섬겨 그것에게 절하며 내가 명하지 아니한 일월성신에게 절한다 하자 ");
INSERT INTO kor_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","혹이 그 일을 네게 고하므로 네가 듣거든 자세히 사실하여 볼지니 만일 그 일과 말이 확실하여 이스라엘 중에 이런 가증한 일을 행함이 있으면 ");
INSERT INTO kor_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","너는 그 악을 행한 남자나 여자를 네 성문으로 끌어내고 돌로 그 남자나 여자를 쳐 죽이되 ");
INSERT INTO kor_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","죽일 자를 두 사람이나 세 사람의 증거로 죽일 것이요 한 사람의 증거로는 죽이지 말 것이며 ");
INSERT INTO kor_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","이런 자를 죽임에는 증인이 먼저 그에게 손을 댄 후에 뭇 백성이 손을 댈지니라 너는 이와 같이 하여 너의 중에 악을 제할지니라 ");
INSERT INTO kor_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","네 성중에서 송사로 다투는 일이 있으되 서로 피를 흘렸거나 다투었거나 구타하였거나 하여 네가 판결하기 어려운 일이 생기거든 너는 일어나 네 하나님 여호와의 택하실 곳으로 올라가서 ");
INSERT INTO kor_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","레위 사람 제사장과 당시 재판장에게로 나아가서 물으라 그리하면 그들이 어떻게 판결할 것을 네게 가르치리니 ");
INSERT INTO kor_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","여호와께서 택하신 곳에서 그들이 네게 보이는 판결의 뜻대로 네가 행하되 무릇 그들이 네게 가르치는 대로 삼가 행할 것이니 ");
INSERT INTO kor_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","곧 그들이 네게 가르치는 법률의 뜻대로 그들이 네게 고하는 판결대로 행할 것이요 그들이 네게 보이는 판결을 어기어서 좌로나 우로나 치우치지 말 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","사람이 만일 천자히 하고 네 하나님 여호와 앞에 서서 섬기는 제사장이나 재판장을 듣지 아니하거든 그 사람을 죽여 이스라엘 중에서 악을 제하여 버리라 ");
INSERT INTO kor_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","그리하면 온 백성이 듣고 두려워하여 다시는 천자히 행치 아니하리라 ");
INSERT INTO kor_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","네가 네 하나님 여호와께서 네게 주시는 땅에 이르러서 그 땅을 얻어 거할 때에 만일 우리도 우리 주위의 열국 같이 우리 위에 왕을 세우리라는 뜻이 나거든 ");
INSERT INTO kor_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","반드시 네 하나님 여호와의 택하신 자를 네 위에 왕으로 세울 것이며 네 위에 왕을 세우려면 네 형제 중에서 한 사람으로 할 것이요 네 형제 아닌 타국인을 네 위에 세우지 말 것이며 ");
INSERT INTO kor_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","왕 된 자는 말을 많이 두지 말 것이요 말을 많이 얻으려고 그 백성을 애굽으로 돌아가게 말 것이니 이는 여호와께서 너희에게 이르시기를 너희가 이 후에는 그 길로 다시 돌아가지 말 것이라 하셨음이며 ");
INSERT INTO kor_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","아내를 많이 두어서 그 마음이 미혹되게 말것이며 은,금을 자기를 위하여 많이 쌓지 말 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","그가 왕위에 오르거든 레위 사람 제사장 앞에 보관한 이 율법서를 등사하여 ");
INSERT INTO kor_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","평생에 자기 옆에 두고 읽어서 그 하나님 여호와 경외하기를 배우며 이 율법의 모든 말과 이 규례를 지켜 행할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","그리하면 그의 마음이 그 형제 위에 교만하지 아니하고 이 명령에서 떠나 좌로나 우로나 치우치지 아니하리니 이스라엘 중에서 그와 그의 자손의 왕위에 있는 날이 장구하리라 ");
INSERT INTO kor_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","레위 사람 제사장과 레위의 온 지파는 이스라엘 중에 분깃도 없고 기업도 없을지니 그들은 여호와의 화제물과 그 기업을 먹을 것이라 ");
INSERT INTO kor_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","그들이 그 형제 중에 기업이 없을 것은 그들에게 대하여 말씀하심 같이 여호와께서 그들의 기업이 되심이니라 ");
INSERT INTO kor_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","제사장이 백성에게서 받을 응식은 이러하니 곧 그 드리는 제물의 우양을 물론하고 그 앞 넓적다리와 두 볼과 위라 이것을 제사장에게 줄 것이요 ");
INSERT INTO kor_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","또 너의 처음 된 곡식과 포도주와 기름과 너의 처음 깍은 양털을 네가 그에게 줄 것이니 ");
INSERT INTO kor_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","이는 네 하나님 여호와께서 네 모든 지파 중에서 그를 택하여 내시고 그와 그의 자손으로 영영히 여호와의 이름으로 서서 섬기게 하셨음이니라 ");
INSERT INTO kor_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","이스라엘 온 땅 어느 성읍에든지 거하는 레위인이 간절한 소원이 있어 그 거한 곳을 떠나 여호와의 택하신 곳에 이르면 ");
INSERT INTO kor_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","여호와 앞에 선 그 형제 모든 레위인과 일반으로 그 하나님 여호와의 이름으로 섬길 수 있나니 ");
INSERT INTO kor_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","그 사람의 응식은 그들과 같을 것이요 그 상속 산업을 판 돈은 이 외에 그에게 속할 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","네 하나님 여호와께서 네게 주시는 땅에 들어가거든 너는 그 민족들의 가증한 행위를 본받지 말 것이니 ");
INSERT INTO kor_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","그 아들이나 딸을 불 가운데로 지나게 하는 자나 복술자나, 길흉을 말하는 자나, 요술을 하는 자나, 무당이나, ");
INSERT INTO kor_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","진언자나, 신접자나, 박수나, 초혼자를 너의 중에 용납하지 말라 ");
INSERT INTO kor_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","무릇 이런 일을 행하는 자는 여호와께서 가증히 여기시나니 이런 가증한 일로 인하여 네 하나님 여호와께서 그들을 네 앞에서 쫓아 내시느니라 ");
INSERT INTO kor_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","너는 네 하나님 여호와 앞에 완전하라 ! ");
INSERT INTO kor_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","네가 쫓아낼 이 민족들은 길흉을 말하는 자나 복술자의 말을 듣거니와 네게는 네 하나님 여호와께서 이런 일을 용납지 아니하시느니라 ");
INSERT INTO kor_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","네 하나님 여호와께서 너의 중 네 형제 중에서 나와 같은 선지자 하나를 너를 위하여 일으키시리니 너희는 그를 들을지니라 ");
INSERT INTO kor_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","이것이 곧 네가 총회의 날에 호렙산에서 너의 하나님 여호와께 구한 것이라 곧 네가 말하기를 나로 다시는 나의 하나님 여호와의 음성을 듣지 않게 하시고 다시는 이 큰 불을 보지 않게 하소서 두렵건대 내가 죽을까 하나이다 하매 ");
INSERT INTO kor_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","여호와께서 이르시되 그들의 말이 옳도다 ");
INSERT INTO kor_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","내가 그들의 형제 중에 너와 같은 선지자 하나를 그들을 위하여 일으키고 내 말을 그 입에 두리니 내가 그에게 명하는 것을 그가 우리에게 다 고하리라 ");
INSERT INTO kor_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","무릇 그가 내 이름으로 고하는 내 말을 듣지 아니하는 자는 내게 벌을 받을 것이요 ");
INSERT INTO kor_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","내가 고하라고 명하지 아니한 말을 어떤 선지자가 만일 방자히 내 이름으로 고하든지 다른 신들의 이름으로 말하면 그 선지자는 죽임을 당하리라 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","네가 혹시 심중에 이르기를 그 말이 여호와의 이르신 말씀인지 우리가 어떻게 알리요 하리라 ");
INSERT INTO kor_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","만일 선지자가 있어서 여호와의 이름으로 말한 일에 증험도 없고 성취함도 없으면 이는 여호와의 말씀하신 것이 아니요 그 선지자가 방자히 한 말이니 너는 그를 두려워 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","네 하나님 여호와께서 이 열국을 멸절하시고 네 하나님 여호와께서 그 땅을 네게 주시므로 네가 필경 그것을 얻고 그들의 각 성읍과 각 가옥에 거할 때에 ");
INSERT INTO kor_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","네 하나님 여호와께서 네게 기업으로 주신 땅 가운데서 세 성읍을 너를 위하여 구별하고 ");
INSERT INTO kor_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","네 하나님 여호와께서 네게 유업으로 주시는 땅의 전체를 삼구로 분하여 그 도로를 닦고 무릇 살인자를 그 성읍으로 도피케 하라 ");
INSERT INTO kor_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","살인자가 그리로 도피하여 살 만한 경위는 이러하니 곧 누구든지 본래 혐원이 없이 부지중에 그 이웃을 죽인 일, ");
INSERT INTO kor_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","가령 사람이 그 이웃과 함께 벌목하러 삼림에 들어가서 손에 도끼를 들고 벌목하려고 찍을 때에 도끼가 자루에서 빠져 그 이웃을 맞춰 그로 죽게함 같은 것이라 이런 사람은 그 성읍 중 하나로 도피하여 생명을 보존할 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","그 사람이 그에게 본래 혐원이 없으니 죽이기에 합당치 아니하나 두렵건대 보수자의 마음이 뜨거워서 살인자를 따르는데 그 가는 길이 멀면 그를 따라 미쳐서 죽일까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","그러므로 내가 네게 명하기를 세 성읍을 너를 위하여 구별하라 하노라 ");
INSERT INTO kor_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","네 하나님 여호와께서 네 열조에게 맹세하신 대로 네 지경을 넓혀 네 열조에게 주리라고 말씀하신 땅을 다 네게 주실 때 ");
INSERT INTO kor_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","또 네가 나의 오늘날 네게 명하는 이 모든 명령을 지켜 행하여 네 하나님 여호와를 사랑하고 항상 그 길로 행할 때에는 이 셋 외에 세 성읍을 더하여 ");
INSERT INTO kor_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","네 하나님 여호와께서 네게 기업으로 주시는 땅에서 무죄한 피를 흘림이 없게 하라 이같이 하면 그 피가 네게로 돌아가지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","그러나 만일 사람이 그 이웃을 미워하여 엎드려 그를 기다리다가 일어나 쳐서 그 생명을 상하여 죽게 하고 이 한 성읍으로 도피하거든 ");
INSERT INTO kor_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","그 본 성읍 장로들이 사람을 보내어 그를 거기서 잡아다가 보수자의 손에 넘겨 죽이게 할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","네 눈이 그를 긍휼히 보지 말고 무죄한 피 흘린 죄를 이스라엘에서 제하라 ! 그리하면 네게 복이 있으리라 ! ");
INSERT INTO kor_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","네 하나님 여호와께서 네게 주어 얻게 하시는 땅 곧 네 기업된 소유의 땅에서 선인(先人)의 정한 네 이웃의 경계표를 이동하지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","사람이 아무 악이든지 무릇 범한 죄는 한 증인으로만 정할 것이 아니요 두 증인의 입으로나 세 증인의 입으로 그 사건을 확정할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","만일 위증하는 자가 있어 아무 사람이 악을 행하였다 말함이 있으면 ");
INSERT INTO kor_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","그 논쟁하는 양방이 같이 하나님 앞에 나아가 당시 제사장과 재판장 앞에 설 것이요 ");
INSERT INTO kor_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","재판장은 자세히 사실하여 그 증인이 위증인이라 그 형제를 거짓으로 무함한 것이 판명되거든 ");
INSERT INTO kor_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","그가 그 형제에게 행하려고 꾀 한대로 그에게 행하여 너희 중에서 악을 제하라 ! ");
INSERT INTO kor_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","그리하면 그 남은 자들이 듣고 두려워하여 이후부터는 이런 악을 너희 중에서 다시 행하지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","네 눈이 긍휼히 보지 말라 생명은 생명으로, 눈은 눈으로, 이는 이로, 손은 손으로, 발은 발로니라 ");
INSERT INTO kor_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","네가 나가 대적과 싸우려할 때에 말과 병거와 민중이 너보다 많음을 볼지라도 그들을 두려워 말라 ! 애굽 땅에서 너를 인도하여 내신 네 하나님 여호와께서 너와 함께 하시느니라 ! ");
INSERT INTO kor_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","너희가 싸울 곳에 가까이 가거든 제사장은 백성에게 나아가서 고하여 ");
INSERT INTO kor_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","그들에게 이르기를 이스라엘아 들으라 ! 너희가 오늘날 너희의 대적과 싸우려고 나아왔으니 마음에 겁내지 말며 두려워 말며 떨지말며 그들로 인하여 놀라지 말라 ");
INSERT INTO kor_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","너희 하나님 여호와는 너희와 함께 행하시며 너희를 위하여 너희 대적을 치고 너희를 구원하시는 자니라 할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","유사들은 백성에게 고하여 이르기를 새집을 건축하고 낙성식을 행치 못한 자가 있느냐 ? 그는 집으로 돌아갈지니 전사하면 타인이 낙성식을 행할까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","포도원을 만들고 그 과실을 먹지 못한 자가 있느냐 ? 그는 집으로 돌아갈지니 전사하면 타인이 그 과실을 먹을까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","여자와 약혼하고 그를 취하지 못한 자가 있느냐 ? 그는 집으로 돌아갈지니 전사하면 타인이 그를 취할까 하노라 하고 ");
INSERT INTO kor_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","유사들은 오히려 또 백성에게 고하여 이르기를 두려워서 마음에 겁내는 자가 있느냐 ? 그는 집으로 돌아갈지니 그 형제들의 마음도 그의 마음과 같이 떨어질까 하노라 하여 ");
INSERT INTO kor_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","백성에게 이르기를 필한 후에 군대의 장관들을 세워 무리를 거느리게 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","네가 어떤 성읍으로 나아가서 치려할 때에 그 성에 먼저 평화를 선언하라 ! ");
INSERT INTO kor_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","그 성읍이 만일 평화하기로 회답하고 너를 향하여 성문을 열거든 그 온 거민으로 네게 공을 바치고 너를 섬기게 할 것이요 ");
INSERT INTO kor_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","만일 너와 평화하기를 싫어하고 너를 대적하여 싸우려 하거든 너는 그 성읍을 에워쌀 것이며 ");
INSERT INTO kor_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","네 하나님 여호와께서 그 성읍을 네 손에 붙이시거든 너는 칼날로 그 속의 남자를 다 쳐 죽이고 ");
INSERT INTO kor_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","오직 여자들과 유아들과 육축과 무릇 그 성중에서 네가 탈취한 모든 것은 네 것이니 취하라 네가 대적에게서 탈취한 것은 네 하나님 여호와께서 네게 주신 것인즉 너는 그것을 누릴지니라 ");
INSERT INTO kor_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","네가 네게서 멀리 떠난 성읍들 곧 이 민족들에게 속하지 아니한 성읍들에게는 이같이 행하려니와 ");
INSERT INTO kor_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","오직 네 하나님 여호와께서 네게 기업으로 주시는 이 민족들의 성읍에서는 호흡 있는 자를 하나도 살리지 말지니 ");
INSERT INTO kor_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","곧 헷 족속과, 아모리 족속과, 가나안 족속과, 브리스 족속과, 여부스 족속을 네가 진멸하되 네 하나님 여호와께서 네게 명하신 대로 하라 ");
INSERT INTO kor_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","이는 그들이 그 신들에게 행하는 모든 가증한 일로 너희에게 가르쳐 본받게 하여 너희로 너희의 하나님 여호와께 범죄케 할까 함이니라 ");
INSERT INTO kor_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","너희가 어느 성읍을 오래 동안 에워싸고 쳐서 취하려 할 때에도 도끼를 둘러 그 곳의 나무를 작벌하지 말라 이는 너희의 먹을 것이 될 것임이니 찍지 말라 밭의 수목이 사람이냐 ? 너희가 어찌 그것을 에워싸겠느냐 ? ");
INSERT INTO kor_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","오직 과목이 아닌 줄로 아는 수목은 작벌하여 너희와 싸우는 그 성읍을 치는 기구를 만들어 그 성읍을 함락시킬 때까지 쓸지니라 ");
INSERT INTO kor_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","네 하나님 여호와께서 네게 주어 얻게 하시는 땅에서 혹시 피살한 시체가 들에 엎드러진 것을 발견하고 그 쳐 죽인 자가 누구인지 알지 못하거든 ");
INSERT INTO kor_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","너의 장로들과 재판장들이 나가서 그 피살한 곳에서 사면에 있는 각 성읍의 원근을 잴 것이요 ");
INSERT INTO kor_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","그 피살한 곳에서 제일 가까운 성읍 곧 그 성읍의 장로들이 아직 부리우지 아니하고 멍에를 메지 아니한 암송아지를 취하고 ");
INSERT INTO kor_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","성읍의 장로들이 물이 항상 흐르고 갈지도 심지도 못하는 골짜기로 그 송아지를 끌고 가서 그 골짜기에서 그 송아지의 목을 꺾을 것이요 ");
INSERT INTO kor_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","레위 자손 제사장들도 그리로 올지니 그들은 네 하나님 여호와께서 택하사 자기를 섬기게 하시며 또 여호와의 이름으로 축복하게 하신 자라 모든 소송과 모든 투쟁이 그들의 말대로 판결될 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","그 피살된 곳에서 제일 가까운 성읍의 모든 장로들은 그 골짜기에서 목을 꺾은 암송아지 위에 손을 씻으며 ");
INSERT INTO kor_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","말하기를 우리의 손이 이 피를 흘리지 아니하였고 우리의 눈이 이것을 보지도 못하였나이다 ");
INSERT INTO kor_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","여호와여 ! 주께서 속량하신 주의 백성 이스라엘을 사하시고 무죄한 피를 주의 백성 이스라엘 중에 머물러 두지 마옵소서 하면 그 피 흘린 죄가 사함을 받으리니 ");
INSERT INTO kor_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","너는 이와 같이 여호와의 보시기에 정직한 일을 행하여 무죄자의 피 흘린 죄를 너희 중에서 제할지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","네가 나가서 대적과 싸움함을 당하여 네 하나님 여호와께서 그들을 네 손에 붙이시므로 네가 그들을 사로잡은 후에 ");
INSERT INTO kor_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","네가 만일 그 포로 중의 아리따운 여자를 보고 연련하여 아내를 삼고자 하거든 ");
INSERT INTO kor_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","그를 네 집으로 데려갈 것이요 그는 그 머리를 밀고 손톱을 베고 ");
INSERT INTO kor_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","또 포로의 의복을 벗고 네 집에 거하며 그 부모를 위하여 일개월동안 애곡한 후에 네가 그에게로 들어가서 그 남편이 되고 그는 네 아내가 될것이요 ");
INSERT INTO kor_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","그 후에 네가 그를 기뻐하지 아니하거든 그 마음대로 가게 하고 결코 돈을 받고 팔지 말지라 네가 그를 욕보였은즉 종으로 여기지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","어떤 사람이 두 아내를 두었는데 하나는 사랑을 받고 하나는 미움을 받다가 그 사랑을 받는 자와 미움을 받는 자가 둘 다 아들을 낳았다 하자 그 미움을 받는 자의 소생이 장자여든 ");
INSERT INTO kor_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","자기의 소유를 그 아들들에게 기업으로 나누는 날에 그 사랑을 받는 자의 아들로 장자를 삼아 참 장자 곧 미움을 받는 자의 아들보다 앞세우지 말고 ");
INSERT INTO kor_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","반드시 그 미움을 받는 자의 아들을 장자로 인정하여 자기의 소유에서 그에게는 두 몫을 줄 것이니 그는 자기의 기력의 시작이라 장자의 권리가 그에게 있음이니라 ");
INSERT INTO kor_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","사람에게 완악하고 패역한 아들이 있어 그 아비의 말이나 그 어미의 말을 순종치 아니하고 부모가 징책하여도 듣지 아니하거든 ");
INSERT INTO kor_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","부모가 그를 잡아가지고 성문에 이르러 그 성읍 장로들에게 나아가서 ");
INSERT INTO kor_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","그 성읍 장로들에게 말하기를 `우리의 이 자식은 완악하고 패역하여 우리 말을 순종치 아니하고 방탕하며 술에 잠긴 자라' 하거든 ");
INSERT INTO kor_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","그 성읍의 모든 사람들이 그를 돌로 쳐 죽일지니 이같이 네가 너의 중에 악을 제하라 그리하면 온 이스라엘이 듣고 두려워하리라 ");
INSERT INTO kor_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","사람이 만일 죽을 죄를 범하므로 네가 그를 죽여 나무 위에 달거든 ");
INSERT INTO kor_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","그 시체를 나무 위에 밤새도록 두지 말고 당일에 장사하여 네 하나님 여호와께서 네게 기업으로 주시는 땅을 더럽히지 말라 나무에 달린 자는 하나님께 저주를 받았음이니라 ");
INSERT INTO kor_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","네 형제의 우양의 길 잃은 것을 보거든 못 본 체 하지 말고 너는 반드시 끌어다가 네 형제에게 돌릴 것이요 ");
INSERT INTO kor_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","네 형제가 네게서 멀거나 네가 혹 그를 알지 못하거든 그 짐승을 네 집으로 끌고 와서 네 형제가 찾기까지 네게 두었다가 그에게 돌릴지니 ");
INSERT INTO kor_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","나귀라도 그리하고 의복이라도 그리하고 무릇 형제의 잃은 아무것이든지 네가 얻거든 다 그리하고 못 본 체 하지 말 것이며 ");
INSERT INTO kor_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","네 형제의 나귀나 소가 길에 넘어진 것을 보거든 못 본 체 하지말고 너는 반드시 형제를 도와서 그것을 일으킬지니라 ");
INSERT INTO kor_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","여자는 남자의 의복을 입지 말 것이요 남자는 여자의 의복을 입지 말 것이라 이같이 하는 자는 네 하나님 여호와께 가증한 자니라 ");
INSERT INTO kor_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","노중에서 나무에나 땅에 있는 새의 보금자리에 새 새끼나 알이 있고 어미새가 그 새끼나 알을 품은 것을 만나거든 그 어미새와 새끼를 아울러 취하지 말고 ");
INSERT INTO kor_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","어미는 반드시 놓아 줄 것이요 새끼는 취하여도 가하니 그리하면 네가 복을 누리고 장수하리라 ");
INSERT INTO kor_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","네가 새 집을 건축할 때에 지붕에 난간을 만들어 사람으로 떨어지지 않게 하라 그 피 흐른 죄가 네 집에 돌아갈까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","네 포도원에 두 종자를 섞어 뿌리지 말라 ! 그리하면 네가 뿌린 씨의 열매와 포도원의 소산이 다 빼앗김이 될까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","너는 소와 나귀를 겨리하여 갈지 말며 ");
INSERT INTO kor_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","양털과 베실로 섞어 짠 것을 입지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","입는 겉옷 네 귀에 술을 만들지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","비방거리를 만들어 그에게 누명을 씌워 가로되 `내가 이 여자를 취하였더니 그와 동침할 때에 그의 처녀인 표적을 보지 못하였노라' 하면 ");
INSERT INTO kor_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","그 처녀의 부모가 처녀의 처녀인 표를 얻어 가지고 그 성읍문 장로들에게로 가서 ");
INSERT INTO kor_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","처녀의 아비가 장로들에게 말하기를 `내 딸을 이 사람에게 아내로 주었더니 그가 미워하여 ");
INSERT INTO kor_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","비방거리를 만들어 말하기를 내가 네 딸의 처녀인 표적을 보지 못하였노라 하나 보라 ! 내 딸의 처녀인 표적이 이것이라' 하고 그 부모가 그 자리옷을 그 성읍 장로들 앞에 펼 것이요 ");
INSERT INTO kor_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","그 성읍 장로들은 그 사람을 잡아 때리고 ");
INSERT INTO kor_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","이스라엘 처녀에게 누명 씌움을 인하여 그에게서 은 일백 세겔을 벌금으로 받아 여자의 아비에게 주고 그 여자로 그 남자의 평생에 버리지 못할 아내가 되게 하려니와 ");
INSERT INTO kor_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","그 일이 참되어 그 처녀에게 처녀인 표적이 없거든 ");
INSERT INTO kor_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","처녀를 그 아비 집 문에서 끌어내고 그 성읍 사람들이 그를 돌로 쳐 죽일지니 이는 그가 그 아비 집에서 창기의 행동을 하여 이스라엘 중에서 악을 행하였음이라 너는 이와 같이 하여 너의 중에 악을 제할지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","남자가 유부녀와 통간함을 보거든 그 통간한 남자와 그 여자를 둘 다 죽여 이스라엘 중에 악을 제할지니라 ");
INSERT INTO kor_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","처녀인 여자가 남자와 약혼한 후에 어떤 남자가 그를 성읍중에서 만나 통간하면 ");
INSERT INTO kor_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","너희는 그들을 둘 다 성읍 문으로 끌어내고 그들을 돌로 쳐 죽일 것이니 그 처녀는 성읍 중에 있어서도 소리 지르지 아니하였음이요 그 남자는 그 이웃의 아내를 욕보였음이라 너는 이같이 하여 너의 중에 악을 제할지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","만일 남자가 어떤 약혼한 처녀를 들에서 만나서 강간하였거든 그 강간한 남자만 죽일 것이요 ");
INSERT INTO kor_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","처녀에게는 아무 것도 행치 말 것은 처녀에게는 죽일 죄가 없음이라 이 일은 사람이 일어나 그 이웃을 쳐 죽인 것과 일반이라 ");
INSERT INTO kor_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","남자가 처녀를 들에서 만난 까닭에 그 약혼한 처녀가 소리질러도 구원할 자가 없었음이니라 ");
INSERT INTO kor_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","만일 남자가 어떤 약혼하지 아니한 처녀를 만나 그를 붙들고 통간하는 중 그 두 사람이 발견되거든 ");
INSERT INTO kor_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","그 통간한 남자는 그 처녀의 아비에게 은 오십 세겔을 주고 그 처녀로 아내를 삼을 것이라 그가 그 처녀를 욕보였은즉 평생에 그를 버리지 못하리라 ");
INSERT INTO kor_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","사람이 그 아비의 후실을 취하여 아비의 하체를 드러내지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","missing verse ");
INSERT INTO kor_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","신낭이 상한 자나 신을 베인 자는 여호와의 총회에 들어오지 못하리라 ");
INSERT INTO kor_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","사생자는 여호와의 총회에 들어오지 못하리니 십대까지라도 여호와의 총회에 들어오지 못하리라 ");
INSERT INTO kor_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","암몬 사람과 모압 사람은 여호와의 총회에 들어오지 못하리니 그들에게 속한 자는 십대 뿐아니라 영원히 여호와의 총회에 들어오지 못하리라 ");
INSERT INTO kor_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","그들은 너희가 애굽에서 나올 때에 떡과 물로 너희를 길에서 영접하지 아니하고 메소보다미아의 브돌 사람 브올의 아들 발람에게 뇌물을 주어 너희를 저주케 하려 하였으나 ");
INSERT INTO kor_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","네 하나님 여호와께서 너를 사랑하시므로 발람의 말을 듣지 아니하시고 그 저주를 변하여 복이 되게 하셨나니 ");
INSERT INTO kor_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","너의 평생에 그들의 평안과 형통을 영영히 구하지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","너는 에돔 사람을 미워하지 말라 ! 그는 너의 형제니라 애굽 사람을 미워하지 말라 ! 네가 그의 땅에서 객이 되었음이니라 ");
INSERT INTO kor_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","그들의 삼대 후 자손은 여호와의 총회에 들어올 수 있느리라 ");
INSERT INTO kor_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","네가 대적을 치러 출진할 때에 모든 악한 일을 스스로 삼갈지니 ");
INSERT INTO kor_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","너희 중에 누가 밤에 몽설함으로 부정하거든 진 밖으로 나가고 진 안에 들어오지 아니하다가 ");
INSERT INTO kor_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","해질 때에 목욕하고 해진 후에 진에 들어올 것이요 ");
INSERT INTO kor_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","너의 진 밖에 변소를 베풀고 그리로 나가되 ");
INSERT INTO kor_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","너의 기구에 작은 삽을 더하여 밖에 나가서 대변을 통할 때에 그것으로 땅을 팔 것이요 몸을 돌이켜 그 배설물을 덮을지니 ");
INSERT INTO kor_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","이는 네 하나님 여호와께서 너를 구원하시고 적군을 네게 붙이시려고 네 진중에 행하심이라 그러므로 네 진을 거룩히 하라 그리하면 네게서 불합한 것을 보시지 않으므로 너를 떠나지 아니하시리라 ");
INSERT INTO kor_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","종이 그 주인을 피하여 네게로 도망하거든 너는 그 주인에게로 돌리지 말고 ");
INSERT INTO kor_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","그가 너의 성읍 중에서 기뻐하는 곳을 택하는 대로 너와 함께 네 가운데 거하게 하고 그를 압제하지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","이스라엘 여자 중에 창기가 있지 못할 것이요 이스라엘 남자 중에 미동이 있지 못할지니 ");
INSERT INTO kor_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","창기의 번 돈과 개 같은 자의 소득은 아무 서원하는 일로든지 네 하나님 여호와의 전에 가져오지 말라 이 둘은 다 네 하나님 여호와께 가증한 것임이니라 ");
INSERT INTO kor_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","네가 형제에게 꾸이거든 이식을 취하지 말지니 곧 돈의 이식, 식물의 이식, 무릇 이식을 낼 만한 것의 이식을 취하지 말 것이라 ");
INSERT INTO kor_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","타국인에게 네가 꾸이면 이식을 취하여도 가하거니와 너의 형제에게 꾸이거든 이식을 취하지 말라 그리하면 네 하나님 여호와께서 네가 들어가서 얻을 땅에서 네 손으로 하는 범사에 복을 내리시리라 ");
INSERT INTO kor_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","네 하나님 여호와께 서원하거든 갚기를 더디 하지 말라 ! 네 하나님 여호와께서 반드시 그것을 네게 요구하시리니 더디면 네게 죄라 ");
INSERT INTO kor_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","네가 서원치 아니하였으면 무죄하니라마는 ");
INSERT INTO kor_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","네 입에서 낸 것은 그대로 실행하기를 주의하라 무릇 자원한 예물은 네 하나님 여호와께 네가 서원하여 입으로 언약한 대로 행할지니라 ");
INSERT INTO kor_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","네 이웃의 포도원에 들어갈 때에 마음대로 그 포도를 배불리 먹어도 가하니라 그러나 그릇에 담지 말 것이요 ");
INSERT INTO kor_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","네 이웃의 곡식 밭에 들어갈 때에 네가 손으로 그 이삭을 따도 가하니라 그러나 이웃의 곡식 밭에 낫을 대지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","사람이 아내를 취하여 데려온 후에 수치되는 일이 그에게 있음을 발견하고 그를 기뻐하지 아니하거든 이혼 증서를 써서 그 손에 주고 그를 자기 집에서 내어보낼 것이요 ");
INSERT INTO kor_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","그 여자는 그 집에서 나가서 다른 사람의 아내가 되려니와 ");
INSERT INTO kor_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","그 후부도 그를 미워하여 이혼 증서를 써서 그 손에 주고 그를 자기 집에서 내어 보내었거나 혹시 그를 아내로 취한 후부가 죽었다 하자 ");
INSERT INTO kor_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","그 여자가 이미 몸을 더럽혔은즉 그를 내어 보낸 전부가 그를 다시 아내로 취하지 말지니 이 일은 여호와 앞에 가증한 것이라 네 하나님 여호와께서 네게 기업으로 주시는 땅으로 너는 범죄케 하지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","사람이 새로이 아내를 취하였거든 그를 군대로 내어 보내지 말 것이요 무슨 직무든지 그에게 맡기지 말 것이며 그는 일년 동안 집에 한가히 거하여 그 취한 아내를 즐겁게 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","사람이 맷돌의 전부나 그 윗짝만이나 전집하지 말지니 이는 그 생명을 전집함이니라 ");
INSERT INTO kor_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","사람이 자기 형제 곧 이스라엘 자손 중 한 사람을 후려다가 그를 부리거나 판 것이 발견되거든 그 후린 자를 죽일지니 이같이 하여 너의 중에 악을 제할지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","너는 문둥병에 대하여 삼가서 레위 사람 제사장들이 너희에게 가르치는 대로 네가 힘써 다 행하되 곧 네가 그들에게 명한 대로 너희는 주의하여 행하라 ! ");
INSERT INTO kor_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","너희가 애굽에서 나오는 길에서 네 하나님 여호와께서 미리암에게 행하신 일을 기억할지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","무릇 네 이웃에게 꾸어줄 때에 네가 그 집에 들어가서 전집물을 취하지 말고 ");
INSERT INTO kor_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","너는 밖에 섰고 네게 꾸는 자가 전집물을 가지고 나와서 네게 줄것이며 ");
INSERT INTO kor_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","그가 가난한 자여든 너는 그의 전집물을 가지고 자지 말고 ");
INSERT INTO kor_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","해질 때에 전집물을 반드시 그에게 돌릴 것이라 그리하면 그가 그 옷을 입고 자며 너를 위하여 축복하리니 그 일이 네 하나님 여호와 앞에서 네 의로움이 되리라 ");
INSERT INTO kor_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","곤궁하고 빈한한 품군은 너의 형제든지 네 땅 성문안에 우거하는 객이든지 그를 학대하지 말며 ");
INSERT INTO kor_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","그 품삯을 당일에 주고 해진 후까지 끌지 말라 이는 그가 빈궁하므로 마음에 품삯을 사모함이라 두렵건대 그가 너를 여호와께 호소하면 죄가 네게로 돌아갈까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","아비는 그 자식들을 인하여 죽임을 당치 않을 것이요 자식들은 그 아비를 인하여 죽임을 당치 않을 것이라 각 사람은 자기 죄에 죽임을 당할 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","너는 객이나 고아의 송사를 억울하게 말며 과부의 옷을 전집하지말라 ");
INSERT INTO kor_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","너는 애굽에서 종이 되었던 일과 네 하나님 여호와께서 너를 거기서 속량하신 것을 기억하라 ! 이러므로 내가 네게 이 일을 행하라 명하노라 ");
INSERT INTO kor_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","네가 밭에서 곡식을 벨 때에 그 한 뭇을 밭에 잊어버렸거든 다시 가서 취하지 말고 객과 고아와 과부를 위하여 버려두라 그리하면 네 하나님 여호와께서 네 손으로 하는 범사에 복을 내리시리라 ");
INSERT INTO kor_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","네가 네 감람나무를 떤 후에 그 가지를 다시 살피지 말고 그 남은 것은 객과 고아와 과부를 위하여 버려두며 ");
INSERT INTO kor_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","네가 네 포도원의 포도를 딴 후에 그 남은 것을 다시 따지 말고 객과 고아와 과부를 위하여 버려두라 ");
INSERT INTO kor_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","너는 애굽 땅에서 종 되었던 것을 기억하라 ! 이러므로 내가 네게 이 일을 행하라 명하노라 ");
INSERT INTO kor_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","사람과 사람 사이에 시비가 생겨서 재판을 청하거든 재판장은 그들을 재판하여 의인은 의롭다 하고 악인은 정죄할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","악인에게 태형이 합당하거든 재판장은 그를 엎드리게 하고 그 죄의 경중대로 여수이 자기 앞에서 때리게 하라 ");
INSERT INTO kor_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","사십까지는 때리려니와 그것을 넘기지는 못할지니 만일 그것을 넘겨 과다히 때리면 네가 네 형제로 천히 여김을 받게 할까 하노라 ");
INSERT INTO kor_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","곡식 떠는 소의 입에 망을 씌우지 말지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","형제가 동거하는데 그 중 하나가 죽고 아들이 없거든 그 죽은 자의 아내는 나가서 타인에게 시집가지 말 것이요 그 남편의 형제가 그에게로 들어가서 그를 취하여 아내를 삼아 그의 남편의 형제 된 의무를 그에게 다 행할 것이요 ");
INSERT INTO kor_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","그 여인의 낳은 첫 아들로 그 죽은 형제의 후사를 잇게 하여 그 이름을 이스라엘 중에서 끊어지지 않게 할 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","그러나 그 사람이 만일 그 형제의 아내 취하기를 즐겨하지 아니하거든 그 형제의 아내는 그 성문 장로들에게로 나아가서 말하기를 내 남편의 형제가 그 형제의 이름을 이스라엘 중에 잇기를 싫어하여 남편의 형제된 의무를 내게 행치 아니하나이다 할 것이요 ");
INSERT INTO kor_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","그 성읍 장로들은 그를 불러다가 이를 것이며 그가 이미 정한 뜻대로 말하기를 내가 그 여자 취하기를 즐겨 아니하노라 하거든 ");
INSERT INTO kor_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","그 형제의 아내가 장로들 앞에서 그에게 나아가서 그의 발에서 신을 벗기고 그 얼굴에 침을 뱉으며 이르기를 그 형제의 집 세우기를 즐겨 아니하는 자에게는 이같이 할 것이라 할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","이스라엘 중에서 그의 이름을 신 벗기운 자의 집이라 칭할 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","두 사람이 서로 싸울 때에 한 사람의 아내가 그 남편을 그 치는 자의 손에서 구하려 하여 가까이 가서 손을 벌려 그 사람의 음낭을 잡거든 ");
INSERT INTO kor_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","너는 그 여인의 손을 찍어 버릴 것이고 네 눈이 그를 불쌍히 보지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","너는 주머니에 같지 않은 저울추 곧 큰 것과 작은 것을 넣지 말것이며 ");
INSERT INTO kor_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","네 집에 같지 않은 되 곧 큰 것과 작은 것을 두지 말 것이요 ");
INSERT INTO kor_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","오직 십분 공정한 저울추를 두며 십분 공정한 되를 둘 것이라 그리하면 네 하나님 여호와께서 네게 주시는 땅에서 네 날이 장구하리라 ");
INSERT INTO kor_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","무릇 이같이 하는자, 무릇 부정당히 행하는 자는 네 하나님 여호와께 가증하니라 ");
INSERT INTO kor_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","너희가 애굽에서 나오는 길에 아말렉이 네게 행한 일을 기억하라 ! ");
INSERT INTO kor_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","곧 그들이 하나님을 두려워하지 아니하고 너를 길에서 만나 너의 피곤함을 타서 네 뒤에 떨어진 약한 자들을 쳤느니라 ");
INSERT INTO kor_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","그러므로 네 하나님 여호와께서 네게 주어 기업으로 얻게 하시는 땅에서 네 하나님 여호와께서 너로 사면에 있는 모든 대적을 벗어나게 하시고 네게 안식을 주실 때에 너는 아말렉의 이름을 천하에서 도말할지니라 너는 잊지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","네 하나님 여호와께서 네게 기업으로 주사 얻게 하시는 땅에 네가 들어가서 거기 거할 때에 ");
INSERT INTO kor_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","네 하나님 여호와께서 네게 주시는 땅에서 그 토지 모든 소산의 맏물을 거둔 후에 그것을 취하여 광주리에 담고 네 하나님 여호와께서 그 이름을 두시려고 택하신 곳으로 그것을 가지고 가서 ");
INSERT INTO kor_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","당시 제사장에게 나아가서 그에게 이르기를 `내가 오늘날 당신의 하나님 여호와께 고하나이다 내가 여호와께서 우리에게 주리라고 우리 열조에게 맹세하신 땅에 이르렀나이다' 할 것이요 ");
INSERT INTO kor_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","제사장은 네 손에서 그 광주리를 취하여다가 네 하나님 여호와의 단 앞에 놓을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","너는 또 네 하나님 여호와 앞에 아뢰기를 내 조상은 유리하는 아람 사람으로서 소수의 사람을 거느리고 애굽에 내려가서 거기 우거하여 필경은 거기서 크고 강하고 번성한 민족이 되었더니 ");
INSERT INTO kor_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","애굽 사람이 우리를 학대하며 우리를 괴롭게 하며 우리에게 중역을 시키므로 ");
INSERT INTO kor_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","우리가 우리 조상의 하나님 여호와께 부르짖었더니 여호와께서 우리 음성을 들으시고 우리의 고통과 신고와 압제를 하감하시고 ");
INSERT INTO kor_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","여호와께서 강한 손과 편 팔과 큰 위엄과 이적과 기사로 우리를 애굽에서 인도하여 내시고 ");
INSERT INTO kor_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","이 곳으로 인도하사 이 땅 곧 젖과 꿀이 흐르는 땅을 주셨나이다 ");
INSERT INTO kor_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","여호와여 이제 내가 주께서 내게 주신 토지 소산의 맏물을 가져 왔나이다 하고 너는 그것을 네 하나님 여호와 앞에 두고 네 하나님 여호와 앞에 경배할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","네 하나님 여호와께서 너와 네 집에 주신 모든 복을 인하여 너는 레위인과 너의 중에 우거하는 객과 함께 즐거워할지니라 ");
INSERT INTO kor_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","제 삼년 곧 십일조를 드리는 해에 네 모든 소산의 십일조 다 내기를 마친 후에 그것을 레위인과 객과 고아와 과부에게 주어서 네 성문 안에서 먹어 배부르게 하라 ");
INSERT INTO kor_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","그리할 때에 네 하나님 여호와 앞에 고하기를 내가 성물을 내 집에서 내어 레위인과 객과 고아와 과부에게 주기를 주께서 내게 명하신 명령대로 하였사오니 내가 주의 명령을 범치도 아니하였고 잊지도 아니하였나이다 ");
INSERT INTO kor_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","내가 애곡하는 날에 이 성물을 먹지 아니하였고 부정한 몸으로 이를 떼어두지 아니하였고 죽은 자를 위하여 이를 쓰지 아니하였고 내 하나님 여호와의 말씀을 청종하여 주께서 내게 명령하신 대로 다 행하였사오니 ");
INSERT INTO kor_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","원컨대 주의 거룩한 처소 하늘에서 하감하시고 주의 백성 이스라엘에게 복을 주시며 우리 열조에게 맹세하여 우리에게 주신 바 젖과 꿀이 흐르는 땅에 복을 내리소서 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","오늘날 네 하나님 여호와께서 이 규례와 법도를 행하라고 네게 명하시나니 그런즉 너는 마음을 다하고 성품을 다하여 지켜 행하라 ");
INSERT INTO kor_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","네가 오늘날 여호와를 네 하나님으로 인정하고 또 그 도를 행하고 그 규례와 명령과 법도를 지키며 그 소리를 들으리라 확언하였고 ");
INSERT INTO kor_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","여호와께서도 네게 말씀하신 대로 오늘날 너를 자기의 보배로운 백성으로 인정하시고 또 그 모든 명령을 지키게 하리라 확언하셨은즉 ");
INSERT INTO kor_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","여호와께서 너의 칭찬과 명예와 영광으로 그 지으신 모든 민족 위에 뛰어나게 하시고 그 말씀하신 대로 너로 네 하나님 여호와의 성민이 되게 하시리라 ");
INSERT INTO kor_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","모세가 이스라엘 장로들로 더불어 백성에게 명하여 가로되 `내가 오늘날 너희에게 명하는 이 명령을 너희는 다 지킬지니라' ");
INSERT INTO kor_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","너희가 요단을 건너 네 하나님 여호와께서 네게 주시는 땅에 들어가는 날에 큰 돌들을 세우고 석회를 바르라 ");
INSERT INTO kor_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","이미 건넌 후에 이 율법의 모든 말씀을 그 위에 기록하라 그리하면 네 하나님 여호와께서 네게 주시는 땅 곧 젖과 꿀이 흐르는 땅에 네가 들어가기를 네 열조의 하나님 여호와께서 네게 말씀하신 대로 하리니 ");
INSERT INTO kor_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","너희가 요단을 건너거든 내가 오늘날 너희에게 명하는 이 돌들을 에발산에 세우고 그 위에 석회를 바를 것이며 ");
INSERT INTO kor_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","또 거기서 네 하나님 여호와를 위하여 단 곧 돌단을 쌓되 그것에 철기를 대지 말지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","너는 다듬지 않은 돌로 네 하나님 여호와의 단을 쌓고 그 위에 하나님 여호와께 번제를 드릴 것이며 ");
INSERT INTO kor_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","또 화목제를 드리고 거기서 먹으며 네 하나님 여호와 앞에서 즐거워하라 ! ");
INSERT INTO kor_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","너는 이 율법의 모든 말씀을 그 돌들 위에 명백히 기록할지니라 ! ");
INSERT INTO kor_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","모세가 레위 제사장들로 더불어 온 이스라엘에게 고하여 가로되 이스라엘아 잠잠히 들으라 ! 오늘날 네가 네 하나님 여호와의 백성이 되었으니 ");
INSERT INTO kor_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","그런즉 네 하나님 여호와의 말씀을 복종하여 내가 오늘날 네게 명하는 그 명령과 규례를 행할지니라' ");
INSERT INTO kor_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","모세가 당일에 백성에게 명하여 가로되 ");
INSERT INTO kor_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","너희가 요단을 건넌 후에 시므온과 레위와 유다와 잇사갈과 요셉과 베냐민은 백성을 축복하기 위하여 그리심산에 서고 ");
INSERT INTO kor_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","르우벤과 갓과 아셀과 스불론과 단과 납달리는 저주하기 위하여 에발산에 서고 ");
INSERT INTO kor_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","레위 사람은 큰 소리로 이스라엘 모든 사람에게 말하여 이르기를 ");
INSERT INTO kor_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","장색의 손으로 조각하였거나 부어 만든 우상은 여호와께 가증하니 그것을 만들어 은밀히 세우는 자는 저주를 받을 것이라 할 것이요 모든 백성은 응답하여 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","그 부모를 경홀히 여기는 자는 저주를 받을 것이라 할 것이요 모든 백성은 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","그 이웃의 지계표를 옮기는 자는 저주를 받을 것이라 할 것이요 모든 백성은 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","소경으로 길을 잃게 하는 자는 저주를 받을 것이라 할 것이요 모든 백성은 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","객이나 고아나 과부의 송사를 억울케 하는 자는 저주를 받을 것이라 할 것이요 모든 백성은 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","계모와 구합하는 자는 그 아비의 하체를 드러내었으니 저주를 받을 것이라 할 것이요 모든 백성은 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","무릇 짐승과 교합하는 자는 저주를 받을 것이라 할 것이요 모든 백성은 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","그 자매 곧 그 아비의 딸이나 어미의 딸과 구합하는 자는 저주를 받을 것이라 할 것이요 모든 백성은 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","장모와 구합하는 자는 저주를 받을 것이라 할 것이요 모든 백성은 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","그 이웃을 암살하는 자는 저주를 받을 것이라 할 것이요 모든 백성은 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","무죄자를 죽이려고 뇌물을 받는 자는 저주를 받을 것이라 할 것이요 모든 백성은 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","이 율법의 모든 말씀을 실행치 아니하는 자는 저주를 받을 것이라 할 것이요 모든 백성은 아멘 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","네가 네 하나님 여호와의 말씀을 삼가 듣고 내가 오늘날 네게 명하는 그 모든 명령을 지켜 행하면 네 하나님 여호와께서 너를 세계 모든 민족 위에 뛰어나게 하실 것이라 ");
INSERT INTO kor_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","네가 네 하나님 여호와의 말씀을 순종하면 이 모든 복이 네게 임하며 네게 미치리니 ");
INSERT INTO kor_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","성읍에서도 복을 받고, 들에서도 복을 받을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","네 몸의 소생과, 네 토지의 소산과, 네 짐승의 새끼와, 우양의 새끼가 복을 받을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","네 광주리와, 떡반죽 그릇이 복을 받을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","네가 들어와도 복을 받고, 나가도 복을 받을 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","네 대적들이 일어나 너를 치려하면 여호와께서 그들을 네 앞에서 패하게 하시리니 그들이 한 길로 너를 치러 들어왔으나 네 앞에서 일곱 길로 도망하리라 ");
INSERT INTO kor_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","여호와께서 명하사 네 창고와 네 손으로 하는 모든 일에 복을 내리시고 네 하나님 여호와께서 네게 주시는 땅에서 네게 복을 주실 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","네가 네 하나님 여호와의 명령을 지켜 그 길로 행하면 여호와께서 네게 맹세하신 대로 너를 세워 자기의 성민이 되게 하시리니 ");
INSERT INTO kor_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","너를 여호와의 이름으로 일컬음을 세계 만민이 보고 너를 두려워하리라 ");
INSERT INTO kor_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","여호와께서 네게 주리라고 네 열조에게 맹세하신 땅에서 네게 복을 주사 네 몸의 소생과, 육축의 새끼와, 토지의 소산으로 많게 하시며 ");
INSERT INTO kor_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","여호와께서 너를 위하여 하늘의 아름다운 보고를 열으사 네 땅에 때를 따라 비를 내리시고 네 손으로 하는 모든 일에 복을 주시리니 네가 많은 민족에게 꾸어줄지라도 너는 꾸지 아니할 것이요 ");
INSERT INTO kor_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","여호와께서 너로 머리가 되고 꼬리가 되지 않게 하시며 위에만 있고 아래에 있지 않게 하시리니 오직 너는 내가 오늘날 네게 명하는 네 하나님 여호와의 명령을 듣고 지켜 행하며 ");
INSERT INTO kor_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","내가 오늘날 너희에게 명하는 그 말씀을 떠나 좌로나 우로나 치우치지 아니하고 다른 신을 따라 섬기지 아니하면 이와 같으리라 ");
INSERT INTO kor_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","네가 만일 네 하나님 여호와의 말씀을 순종하지 아니하여 내가 오늘날 네게 명하는 그 모든 명령과 규례를 지켜 행하지 아니하면 이 모든 저주가 네게 임하고 네게 미칠 것이니 ");
INSERT INTO kor_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","네가 성읍에서도 저주를 받으며, 들에서도 저주를 받을 것이요 ");
INSERT INTO kor_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","또 네 광주리와, 떡반죽 그릇이 저주를 받을 것이요 ");
INSERT INTO kor_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","네 몸의 소생과, 네 토지의 소산과, 네 우양의 새끼가 저주를 받을것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","네가 들어와도 저주를 받고, 나가도 저주를 받으리라 ");
INSERT INTO kor_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","네가 악을 행하여 그를 잊으므로 네 손으로 하는 모든 일에 여호와께서 저주와 공구와 견책을 내리사 망하여 속히 파멸케 하실 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","여호와께서 네 몸에 염병이 들게 하사 네가 들어가 얻을 땅에서 필경 너를 멸하실 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","여호와께서 폐병과, 열병과, 상한과, 학질과, 한재와, 풍재와, 썩는 재앙으로 너를 치시리니 이 재앙들이 너를 따라서 너를 진멸케 할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","네 머리 위의 하늘은 놋이 되고 네 아래의 땅은 철이 될 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","여호와께서 비 대신에 티끌과 모래를 네 땅에 내리시리니 그것들이 하늘에서 네 위에 내려서 필경 너를 멸하리라 ");
INSERT INTO kor_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","여호와께서 너로 네 대적 앞에 패하게 하시리니 네가 한 길로 그들을 치러 나가서는 그들의 앞에서 일곱 길로 도망할 것이며 네가 또 세계 만국 중에 흩음을 당하고 ");
INSERT INTO kor_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","네 시체가 공중의 모든 새와 땅 짐승들의 밥이 될 것이나 그것들을 쫓아 줄 자가 없을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","여호와께서 애굽의 종기와, 치질과, 괴혈병과, 개창으로 너를 치시리니 네가 치료함을 얻지 못할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","여호와께서 또 너를 미침과, 눈멂과, 경심증으로 치시리니 ");
INSERT INTO kor_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","소경이 어두운데서 더듬는 것과 같이 네가 백주에도 더듬고 네 길이 형통치 못하여 항상 압제와 노략을 당할 뿐이니 너를 구원할 자가 없을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","네가 여자와 약혼하였으나 다른 사람이 그와 같이 잘 것이요 집을 건축하였으나 거기 거하지 못할 것이요 포도원을 심었으나 네가 그 과실을 쓰지 못할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","네 소를 네 목전에서 잡았으나 네가 먹지 못할 것이며 네 나귀를 네 목전에서 빼앗아감을 당하여도 도로 찾지 못할 것이며 네 양을 대적에게 빼앗길 것이나 너를 도와 줄 자가 없을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","네 자녀를 다른 민족에게 빼앗기고 종일 생각하고 알아봄으로 눈이 쇠하여지나 네 손에 능이 없을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","네 토지 소산과 네 수고로 얻은 것을 네가 알지 못하는 민족이 먹겠고 너는 항상 압제와 학대를 받을 뿐이리니 ");
INSERT INTO kor_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","이러므로 네 눈에 보이는 일로 인하여 네가 미치리라 ");
INSERT INTO kor_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","여호와께서 네 무릎과 다리를 쳐서 고치지 못할 심한 종기로 발하게 하여 발바닥으로 정수리까지 이르게 하시리라 ");
INSERT INTO kor_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","여호와께서 너와 네가 세울 네 임금을 너와 네 열조가 알지 못하던 나라로 끌어가시리니 네가 거기서 목석으로 만든 다른 신들을 섬길 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","여호와께서 너를 끌어 가시는 모든 민족 중에서 네가 놀램과, 속담과, 비방거리가 될 것이라 ");
INSERT INTO kor_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","네가 많은 종자를 들에 심을지라도 메뚜기가 먹으므로 거둘 것이 적을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","네가 포도원을 심고 다스릴지라도 벌레가 먹으므로 포도를 따지 못하고 포도주를 마시지 못할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","네 모든 경내에 감람나무가 있을지라도 그 열매가 떨어지므로 그 기름을 네 몸에 바르지 못할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","네가 자녀를 낳을지라도 그들이 포로가 되므로 네게 있지 못할 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","네 모든 나무와 토지 소산은 메뚜기가 먹을 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","너의 중에 우거하는 이방인은 점점 높아져서 네 위에 뛰어나고 너는 점점 낮아질 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","그는 네게 꾸일지라도 너는 그에게 뀌지 못하리니 그는 머리가 되고 너는 꼬리가 될 것이라 ");
INSERT INTO kor_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","네가 네 하나님 여호와의 말씀을 순종치 아니하고 네게 명하신 그 명령과 규례를 지키지 아니하므로 이 모든 저주가 네게 임하고 너를 따르고 네게 미쳐서 필경 너를 멸하리니 ");
INSERT INTO kor_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","이 모든 저주가 너와 네 자손에게 영원히 있어서 표적과 감계가 되리라 ");
INSERT INTO kor_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","네가 모든 것이 풍족하여도 기쁨과 즐거운 마음으로 네 하나님 여호와를 섬기지 아니함을 인하여 ");
INSERT INTO kor_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","네가 주리고 목마르고 헐벗고 모든 것이 핍절한 중에서 여호와께서 보내사 너를 치게 하실 대적을 섬기게 될 것이니 그가 철 멍에를 네 목에 메워서 필경 너를 멸할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","곧 여호와께서 원방에서 땅 끝에서 한 민족을 독수리의 날음 같이 너를 치러 오게 하시리니 이는 네가 그 언어를 알지 못하는 민족이요 ");
INSERT INTO kor_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","그 용모가 흉악한 민족이라 노인을 돌아보지 아니하며 유치를 긍휼히 여기지 아니하며 ");
INSERT INTO kor_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","네 육축의 새끼와 네 토지의 소산을 먹어서 필경은 너를 멸망시키며 또 곡식이나 포도주나 기름이나 소의 새끼나 양의 새끼를 위하여 남기지 아니하고 필경은 너를 멸절시키리라 ");
INSERT INTO kor_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","그들이 전국에서 네 모든 성읍을 에워싸고 네가 의뢰하는 바 높고 견고한 성벽을 다 헐며 네 하나님 여호와께서 네게 주시는 땅의 모든 성읍에서 너를 에워싸리니 ");
INSERT INTO kor_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","네가 대적에게 에워싸이고 맹렬히 쳐서 곤란케 함을 당하므로 네 하나님 여호와께서 네게 주신 자녀 곧 네 몸의 소생의 고기를 먹을 것이라 ");
INSERT INTO kor_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","너희 중에 유순하고 연약한 남자라도 그 형제와 그 품의 아내와 그 남은 자녀를 질시하여 ");
INSERT INTO kor_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","자기의 먹는 그 자녀의 고기를 그 중 누구에게든지 주지 아니하리니 이는 네 대적이 네 모든 성읍을 에워싸고 맹렬히 너를 쳐서 곤란케 하므로 아무 것도 그에게 남음이 없는 연고일 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","또 너희 중에 유순하고 연약한 부녀 곧 유순하고 연약하여 그 발바닥으로 땅을 밟아 보지도 아니하던 자라도 그 품의 남편과 그 자녀를 질시하여 ");
INSERT INTO kor_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","그 다리 사이에서 나온 태와 자기의 낳은 어린 자식을 가만히 먹으리니 이는 네 대적이 네 생명을 에워싸고 맹렬히 쳐서 곤란케 하므로 아무 것도 얻지 못함이리라 ");
INSERT INTO kor_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","네가 만일 이 책에 기록한 이 율법의 모든 말씀을 지켜 행하지 아니하고 네 하나님 여호와라 하는 영화롭고 두려운 이름을 경외하지 아니하면 ");
INSERT INTO kor_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","여호와께서 너의 재앙과 네 자손의 재앙을 극렬하게 하시리니 그 재앙이 크고 오래고 질병이 중하고 오랠 것이라 ");
INSERT INTO kor_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","여호와께서 네가 두려워하던 애굽의 모든 질병을 네게로 가져다가 네 몸에 들어붓게 하실 것이며 ");
INSERT INTO kor_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","또 이 율법 책에 기록지 아니한 모든 질병과 모든 재앙을 너의 멸망하기까지 여호와께서 네게 내리실 것이니 ");
INSERT INTO kor_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","너희가 하늘의 별같이 많았을지라도 네 하나님 여호와의 말씀을 순종치 아니하므로 남는 자가 얼마되지 못할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","이왕에 여호와께서 너희에게 선을 행하시고 너희로 번성케 하시기를 기뻐하시던 것 같이 이제는 여호와께서 너희를 망하게 하시며 멸하시기를 기뻐하시리니 너희가 들어가 얻는 땅에서 뽑힐 것이요 ");
INSERT INTO kor_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","여호와께서 너를 땅 이 끝에서, 저 끝까지 만민 중에 흩으시리니 네가 그 곳에서 너와 네 열조의 알지 못하던 목석 우상을 섬길 것이라 ");
INSERT INTO kor_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","그 열국 중에서 네가 평안함을 얻지 못하며 네 발바닥을 쉴 곳도 얻지 못하고 오직 여호와께서 거기서 너의 마음으로 떨고 눈으로 쇠하고 정신으로 산란케 하시리니 ");
INSERT INTO kor_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","네 생명이 의심나는 곳에 달린 것 같아서 주야로 두려워하며 네 생명을 확신할수 없을 것이라 ");
INSERT INTO kor_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","네 마음의 두려움과 눈의 보는 것으로 인하여 아침에는 이르기를 아하, 저녁이 되었으면 좋겠다 할 것이요 저녁에는 이르기를 아하, 아침이 되었으면 좋겠다 하리라 ");
INSERT INTO kor_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","여호와께서 너를 배에 실으시고 전에 네게 고하여 이르시기를 네가 다시는 그 길을 보지 아니하리라 하시던 그 길로 너를 애굽으로 끌어가실 것이라 거기서 너희가 너희 몸을 대적에게 노비로 팔려하나 너희를 살 자가 없으리라 ");
INSERT INTO kor_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","호렙에서 이스라엘 자손과 세우신 언약 외에 여호와께서 모세에게 명하사 모압 땅에서 또 그들과 세우신 언약의 말씀이 이러하 니라 ");
INSERT INTO kor_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","모세가 온 이스라엘을 소집하고 그들에게 이르되 여호와께서 애굽 땅에서 너희 목전에 바로와 그 모든 신하와 그 온 땅에 행하신 모든 일을 너희가 보았나니 ");
INSERT INTO kor_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","곧 그 큰 시험과 이적과 큰 기사를 네가 목도하였느니라 ");
INSERT INTO kor_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","그러나 깨닫는 마음과 보는 눈과 듣는 귀는 오늘날까지 여호와께서 너희에게 주지 아니하셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","주께서 사십년 동안 너희를 인도하여 광야를 통행케 하셨거니와 너희 몸의 옷이 낡지 아니하였고 너희 발의 신이 해어지지 아니하였으며 ");
INSERT INTO kor_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","너희로 떡도 먹지 못하며 포도주나 독주를 마시지 못하게 하셨음은 주는 너희 하나님 여호와이신 줄을 알게 하려 하심이니라 ");
INSERT INTO kor_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","너희가 이곳에 올 때에 헤스본 왕 시혼과 바산 왕 옥이 우리와 싸우러 나왔으므로 우리가 그들을 치고 ");
INSERT INTO kor_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","그 땅을 취하여 르우벤과 갓과 므낫세 반 지파에게 기업으로 주었나니 ");
INSERT INTO kor_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","그런즉 너희는 이 언약의 말씀을 지켜 행하라 ! 그리하면 너희의 하는 모든 일이 형통하리라 ");
INSERT INTO kor_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","오늘날 너희 곧 너희 두령과 너희 지파와 너희 장로들과 너희 유사와 이스라엘 모든 남자와 ");
INSERT INTO kor_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","너희 유아들과 너희 아내와 및 네 진중에 있는 객과 무릇 너를 위하여 나무를 패는 자로부터 물 긷는 자까지 다 너희 하나님 여호와 앞에 선 것은 ");
INSERT INTO kor_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","너의 하나님 여호와의 언약에 참예하며 또 너의 하나님 여호와께서 오늘날 네게 향하여 하시는 맹세에 참예하여 ");
INSERT INTO kor_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","여호와께서 이왕에 네게 말씀하신 대로 또 네 열조 아브라함과 이삭과 야곱에게 맹세하신 대로 오늘날 너를 세워 자기 백성을 삼으시고 자기는 친히 네 하나님이 되시려 함이니라 ");
INSERT INTO kor_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","내가 이 언약과 맹세를 너희에게만 세우는 것이 아니라 ");
INSERT INTO kor_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","오늘날 우리 하나님 여호와 앞에서 우리와 함께 여기 선 자와 오늘날 우리와 함께 여기 있지 아니한 자에게까지니 ");
INSERT INTO kor_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","(우리가 애굽 땅에 어떻게 거하였었는지 너희가 여러 나라를 어떻게 통과하여 왔었는지 너희가 알며 ");
INSERT INTO kor_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","너희가 또 그들 중에 있는 가증한 것과 목석과 은금의 우상을 보았느니라) ");
INSERT INTO kor_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","너희 중에 남자나 여자나 가족이나 지파나 오늘날 그 마음이 우리 하나님 여호와를 떠나서 그 모든 민족의 신들에게 가서 섬길까 염려하며 독초와 쑥의 뿌리가 너희 중에 생겨서 ");
INSERT INTO kor_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","이 저주의 말을 듣고도 심중에 스스로 위로하여 이르기를 내가 내 마음을 강퍅케 하여 젖은 것과 마른 것을 멸할지라도 평안하리라 할까 염려함이라 ");
INSERT INTO kor_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","여호와는 이런 자를 사하지 않으실 뿐 아니라 여호와의 분노와 질투의 불로 그의 위에 붓게 하시며 또 이 책에 기록된 모든 저주로 그에게 더하실 것이라 여호와께서 필경은 그의 이름을 천하에서 도말하시되 ");
INSERT INTO kor_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","여호와께서 곧 이스라엘 모든 지파 중에서 그를 구별하시고 이 율법 책에 기록된 언약의 모든 저주대로 그에게 화를 더하시리라 ");
INSERT INTO kor_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","너희 뒤에 일어나는 너희 자손과 원방에서 오는 객이 그 땅의 재앙과 여호와께서 그 땅에 유행시키시는 질병을 보며 ");
INSERT INTO kor_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","그 온 땅이 유황이 되며 소금이 되며 또 불에 타서 심지도 못하며 결실함도 없으며 거기 아무 풀도 나지 아니함이 옛적에 여호와께서 진노와 분한으로 훼멸하신 소돔과 고모라와 아드마와 스보임의 무너짐과 같음을 보고 말할 것이요 ");
INSERT INTO kor_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","열방 사람들도 말하기를 여호와께서 어찌하여 이 땅에 이같이 행하셨느뇨 ? 이같이 크고 열렬하게 노하심은 무슨 뜻이뇨 ? 하면 ");
INSERT INTO kor_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","그 때에 사람이 대답하기를 그 무리가 자기의 조상의 하나님 여호와께서 그 조상을 애굽에서 인도하여 내실 때에 더불어 세우신 언약을 버리고 ");
INSERT INTO kor_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","가서 자기들이 알지도 못하고 여호와께서 그들에게 주시지도 아니한 다른 신들을 섬겨 그에게 절한 까닭이라 ");
INSERT INTO kor_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","이러므로 여호와께서 이 땅을 향하여 진노하사 이 책에 기록된 모든 저주대로 재앙을 내리시고 ");
INSERT INTO kor_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","여호와께서 또 진노와 분한과 크게 통한하심으로 그들을 이 땅에서 뽑아내사 다른 나라에 던져 보내심이 오늘날과 같다 하리라 ");
INSERT INTO kor_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","오묘한 일은 우리 하나님 여호와께 속하였거니와 나타난 일은 영구히 우리와 우리 자손에게 속하였나니 이는 우리로 이 율법의 모든 말씀을 행하게 하심이니라 ");
INSERT INTO kor_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","내가 네게 진술한 모든 복과 저주가 네게 임하므로 네가 네 하나님 여호와께 쫓겨간 모든 나라 가운데서 이 일이 마음에서 기억이 나거든 ");
INSERT INTO kor_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","너와 네 자손이 네 하나님 여호와께로 돌아와 내가 오늘날 네게 명한 것을 온전히 따라서 마음을 다하고 성품을 다하여 여호와의 말씀을 순종하면 ");
INSERT INTO kor_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","네 하나님 여호와께서 마음을 돌이키시고 너를 긍휼히 여기사 네 포로를 돌리시되 네 하나님 여호와께서 너를 흩으신 그 모든 백성 중에서 너를 모으시리니 ");
INSERT INTO kor_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","너의 쫓겨간 자들이 하늘 가에 있을지라도 네 하나님 여호와께서 거기서 너를 모으실 것이며 거기서부터 너를 이끄실 것이라 ");
INSERT INTO kor_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","네 하나님 여호와께서 너를 네 열조가 얻은 땅으로 돌아오게 하사 너로 다시 그것을 얻게 하실 것이며 여호와께서 또 네게 선을 행하사 너로 네 열조보다 더 번성케 하실 것이며 ");
INSERT INTO kor_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","네 하나님 여호와께서 네 마음과 네 자손의 마음에 할례를 베푸사 너로 마음을 다하며 성품을 다하여 네 하나님 여호와를 사랑하게 하사 너로 생명을 얻게 하실 것이며 ");
INSERT INTO kor_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","네 하나님 여호와께서 네 대적과 너를 미워하고 핍박하던 자에게 이 모든 저주로 임하게 하시리니 ");
INSERT INTO kor_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","너는 돌아와 다시 여호와의 말씀을 순종하고 내가 오늘날 네게 명한 그 모든 명령을 행할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","네가 네 하나님 여호와의 말씀을 순종하여 이 율법 책에 기록된 그 명령과 규례를 지키고 네 마음을 다하며 성품을 다하여 여호와 네 하나님께 돌아오면 네 하나님 여호와께서 네 손으로 하는 모든 일과 네 몸의 소생과 네 육축의 새끼와 네 토지 소산을 많게 하시고 네게 복을 주시되 곧 여호와께서 네 열조를 기뻐하신 ");
INSERT INTO kor_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","것과 같이 너를 다시 기뻐하사 네게 복을 주시리라 ");
INSERT INTO kor_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","내가 오늘날 네게 명한 이 명령은 네게 어려운 것도 아니요 먼 것도 아니라 ");
INSERT INTO kor_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","하늘에 있는 것이 아니니 네가 이르기를 누가 우리를 위하여 하늘에 올라가서 그 명령을 우리에게로 가지고 와서 우리에게 들려행하게 할꼬 ? 할 것이 아니요 ");
INSERT INTO kor_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","이것이 바다 밖에 있는 것이 아니니 네가 이르기를 누가 우리를 위하여 바다를 건너가서 그 명령을 우리에게로 가지고 와서 우리에게 들려 행하게 할꼬 ? 할 것도 아니라 ");
INSERT INTO kor_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","오직 ! 그 말씀이 네게 심히 가까와서 네 입에 있으며 네 마음에 있은즉 네가 이를 행할 수 있느니라 ");
INSERT INTO kor_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","보라 ! 내가 오늘날 생명과 복과 사망과 화를 네 앞에 두었나니 ");
INSERT INTO kor_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","곧 내가 오늘날 너를 명하여 네 하나님 여호와를 사랑하고 그 모든 길로 행하며 그 명령과 규례와 법도를 지키라 하는 것이라 그리하면 네가 생존하며 번성할 것이요 또 네 하나님 여호와께서 네가 가서 얻을 땅에서 네게 복을 주실 것임이니라 ");
INSERT INTO kor_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","그러나 네가 만일 마음을 돌이켜 듣지 아니하고 유혹을 받아서 다른 신들에게 절하고 그를 섬기면 ");
INSERT INTO kor_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","내가 오늘날 너희에게 선언하노니 너희가 반드시 망할 것이라 너희가 요단을 건너가서 얻을 땅에서 너희의 날이 장구치 못할 것이니라 ");
INSERT INTO kor_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","내가 오늘날 천지를 불러서 너희에게 증거를 삼노라 내가 생명과 사망과 복과 저주를 네 앞에 두었은즉 너와 네 자손이 살기 위하여 생명을 택하고 ");
INSERT INTO kor_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","네 하나님 여호와를 사랑하고 그 말씀을 순종하며 또 그에게 부종하라 그는 네 생명이시요 네 장수시니 여호와께서 네 열조 아브라함과 이삭과 야곱에게 주리라고 맹세하신 땅에 네가 거하리라 ");
INSERT INTO kor_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","모세가 가서 온 이스라엘에게 이 말씀을 베푸니라 ");
INSERT INTO kor_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","곧 그들에게 이르되 내가 오늘날 일백 이십세라 내가 더는 출입하기 능치 못하고 여호와께서도 내게 이르시기를 너는 이 요단을 건너지 못하리라 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","여호와께서 이미 말씀하신 것과 같이 여호수아가 너를 거느리고 건널 것이요 네 하나님 여호와 그가 네 앞서 건너가사 이 민족들을 네 앞에서 멸하시고 너로 그 땅을 얻게 하실 것이며 ");
INSERT INTO kor_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","여호와께서 이미 멸하신 아모리 왕 시혼과 옥과 및 그 땅에 행하신 것과 같이 그들에게도 행하실 것이라 ");
INSERT INTO kor_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","여호와께서 그들을 너희 앞에 붙이시리니 너희는 내가 너희에게 명한 모든 명령대로 그들에게 행할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","너는 마음을 강하게 하고 담대히 하라 그들을 두려워 말라 그들 앞에서 떨지 말라 이는 네 하나님 여호와 그가 너와 함께 행하실 것임이라 반드시 너를 떠나지 아니하시며 버리지 아니하시리라 하고 ");
INSERT INTO kor_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","모세가 여호수아를 불러 온 이스라엘 목전에서 그에게 이르되 너는 마음을 강하게 하고 담대히 하라 ! 너는 이 백성을 거느리고 여호와께서 그들의 열조에게 주리라고 맹세하신 땅에 들어가서 그들로 그 땅을 얻게 하라 ");
INSERT INTO kor_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","여호와 그가 네 앞서 행하시며 너와 함께 하사 너를 떠나지 아니하시며 버리지 아니하시리니 너는 두려워 말라 ! 놀라지 말라 ! ");
INSERT INTO kor_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","모세가 이 율법을 써서 여호와의 언약궤를 메는 레위 자손 제사장들과 이스라엘 모든 장로에게 주고 ");
INSERT INTO kor_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","그들에게 명하여 이르기를 매 칠년 끝 해 곧 정기 면제년의 초막절에 ");
INSERT INTO kor_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","온 이스라엘이 네 하나님 여호와 앞 그 택하신 곳에 모일 때에 이 율법을 낭독하여 온 이스라엘로 듣게 할지니 ");
INSERT INTO kor_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","곧 백성의 남녀와 유치와 네 성안에 우거하는 타국인을 모으고 그들로 듣고 배우고 네 하나님 여호와를 경외하며 이 율법의 모든 말씀을 지켜 행하게 하고 ");
INSERT INTO kor_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","또 너희가 요단을 건너가서 얻을 땅에 거할 동안에 이 말씀을 알지 못하는 그들의 자녀로 듣고 네 하나님 여호와 경외하기를 배우게 할지니라 ");
INSERT INTO kor_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","여호와께서 모세에게 이르시되 너의 죽을 기한이 가까왔으니 여호수아를 불러서 함께 회막으로 나아오라 내가 그에게 명을 내리리라 모세와 여호수아가 나아가서 회막에 서니 ");
INSERT INTO kor_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","여호와께서 구름 기둥 가운데서 장막에 나타나시고 구름 기둥은 장막 문 위에 머물렀더라 ");
INSERT INTO kor_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","여호와께서 모세에게 이르시되 너는 너의 열조와 함께 자려니와 이 백성은 들어가 거할 그 땅에서 일어나서 이방신들을 음란히 좇아 나를 버리며 내가 그들과 세운 언약을 어길 것이라 ");
INSERT INTO kor_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","그 때에 내가 그들에게 진노하여 그들을 버리며 내 얼굴을 숨겨 그들에게 보이지 않게 할 것인즉 그들이 삼킴을 당하여 허다한 재앙과 환난이 그들에게 임할 그 때에 그들이 말하기를 이 재앙 이 우리에게 임함은 우리 하나님이 우리 중에 계시지 않은 까닭이 아니뇨 할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","그들이 돌이켜 다른 신을 좇는 모든 악행을 인하여 내가 그 때에 반드시 내 얼굴을 숨기리라 ");
INSERT INTO kor_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","그러므로 이제 너희는 이 노래를 써서 이스라엘 자손에게 가르쳐서 그 입으로 부르게 하여 이 노래로 나를 위하여 이스라엘 자손에게 증거가 되게 하라 ");
INSERT INTO kor_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","내가 그들의 열조에게 맹세한 바 젖과 꿀이 흐르는 땅으로 그들을 인도하여 들인 후에 그들이 먹어 배부르고 살지면 돌이켜 다른 신들을 섬기며 나를 멸시하여 내 언약을 어기리니 ");
INSERT INTO kor_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","그들이 재앙과 환난을 당할 때에 그들의 자손이 부르기를 잊지 아니한 이 노래가 그들 앞에 증인처럼 되리라 나는 내가 맹세한 땅으로 그들을 인도하여 들이기 전 오늘날에 나는 그들의 상상하는 바를 아노라 ");
INSERT INTO kor_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","모세가 당일에 이 노래를 써서 이스라엘 자손에게 가르쳤더라 ");
INSERT INTO kor_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","여호와께서 또 눈의 아들 여호수아에게 명하여 가라사대 너는 이스라엘 자손을 인도하여 내가 그들에게 맹세한 땅으로 들어가게 하리니 마음을 강하게 하고 담대히 하라 ! 내가 너와 함께 하리라 ! ");
INSERT INTO kor_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","모세가 이 율법의 말씀을 다 책에 써서 마친 후에 ");
INSERT INTO kor_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","여호와의 언약궤를 메는 레위 사람에게 명하여 가로되 ");
INSERT INTO kor_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","`이 율법책을 가져다가 너희 하나님 여호와의 언약궤 곁에 두어 너희에게 증거가 되게 하라 ");
INSERT INTO kor_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","내가 너희의 패역함과 목이 곧은 것을 아나니 오늘날 내가 생존하여 너희와 함께 하여도 너희가 여호와를 거역하였거든 하물며 내가 죽은 후의 일이랴 ");
INSERT INTO kor_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","너희 지파 모든 장로와 유사들을 내 앞에 모으라 내가 이 말씀을 그들의 귀에 들리고 그들에게 천지로 증거를 삼으리라 ");
INSERT INTO kor_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","내가 알거니와 내가 죽은 후에 너희가 스스로 부패하여 내가 너희에게 명한 길을 떠나서 여호와의 목전에 악을 행하여 너희의 손으로 하는 일로 그를 격노케 하므로 너희가 말세에 재앙을 당하리라' 하니라 ");
INSERT INTO kor_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","모세가 이스라엘 총회에게 이 노래의 말씀을 끝까지 읽어 들리니라 ");
INSERT INTO kor_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","하늘이여 귀를 기울이라 내가 말하리라 땅은 내 입의 말을 들을지어다 ");
INSERT INTO kor_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","나의 교훈은 내리는 비요, 나의 말은 맺히는 이슬이요, 연한 풀 위에 가는 비요, 채소 위에 단 비로다 ");
INSERT INTO kor_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","내가 여호와의 이름을 전파하리니 너희는 위엄을 우리 하나님께 돌릴지어다 ! ");
INSERT INTO kor_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","그는 반석이시니 그 공덕이 완전하고 그 모든 길이 공평하며 진실무망하신 하나님이시니 공의로우시고 정직하시도다 ");
INSERT INTO kor_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","그들이 여호와를 향하여 악을 행하니 하나님의 자녀가 아니요 흠이 있는 사곡한 종류로다 ");
INSERT INTO kor_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","우매무지한 백성아 여호와께 이같이 보답하느냐 ? 그는 너를 얻으신 너의 아버지가 아니시냐 ? 너를 지으시고 세우셨도다 ");
INSERT INTO kor_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","옛날을 기억하라 역대의 연대를 생각하라 네 아비에게 물으라 그가 네게 설명할 것이요 네 어른들에게 물으라 그들이 네게 이르리로다 ");
INSERT INTO kor_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","지극히 높으신 자가 열국의 기업을 주실 때 인종을 분정하실 때에 이스라엘 자손의 수효대로 민족들의 경계를 정하셨도다 ");
INSERT INTO kor_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","여호와의 분깃은 자기 백성이라 야곱은 그 택하신 기업이로다 ");
INSERT INTO kor_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","여호와께서 그를 황무지에서, 짐승의 부르짖는 광야에서 만나시고 호위하시며 보호하시며 자기 눈동자같이 지키셨도다 ");
INSERT INTO kor_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","마치 독수리가 그 보금자리를 어지럽게 하며 그 새끼 위에 너풀 거리며 그 날개를 펴서 새끼를 받으며 그 날개 위에 그것을 업는것 같이 ");
INSERT INTO kor_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","여호와께서 홀로 그들을 인도하셨고 함께 한 다른 신이 없었도다 ");
INSERT INTO kor_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","여호와께서 그로 땅의 높은 곳을 타고 다니게 하시며 밭의 소산을 먹게 하시며 반석에서 꿀을,굳은 반석에서 기름을 빨게 하시며 ");
INSERT INTO kor_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","소의 젖 기름과 양의 젖과 어린 양의 기름과 바산 소산의 수양과 염소와 지극히 아름다운 밀을 먹이시며 또 포도즙의 붉은 술을 마시우셨도다 ");
INSERT INTO kor_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","그러한데 여수룬이 살지매 발로 찼도다 네가 살지고 부대하고 윤택하매 자기를 지으신 하나님을 버리며 자기를 구원하신 반석을 경홀히 여겼도다 ");
INSERT INTO kor_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","그들이 다른 신으로 그의 질투를 일으키며 가증한 것으로 그의 진노를 격발하였도다 ");
INSERT INTO kor_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","그들은 하나님께 제사하지 아니하고 마귀에게 하였으니 곧 그들의 알지 못하던 신,근래에 일어난 새 신,너희 열조의 두려워하지 않던 것들이로다 ");
INSERT INTO kor_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","너를 낳은 반석은 네가 상관치 아니하고 너를 내신 하나님은 네가 잊었도다 ");
INSERT INTO kor_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","여호와께서 보시고 미워하셨으니 그 자녀가 그를 격노케한 연고로다 ");
INSERT INTO kor_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","여호와의 말씀에 내가 내 얼굴을 숨겨 그들에게 보이지 않게 하고 그들의 종말의 어떠함을 보리니 그들은 심히 패역한 종류요 무신한 자녀임이로다 ");
INSERT INTO kor_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","그들이 하나님이 아닌 자로 나의 질투를 일으키며 그들의 허무한 것으로 나의 진노를 격발하였으니 나도 백성이 되지 아니한 자로 그들의 시기가 나게 하며 우준한 민족으로 그들의 분노를 격발하리로다 ");
INSERT INTO kor_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","내 분노의 불이 일어나서 음부 깊은 곳까지 사르며 땅의 그 소산을 삼키며 산들의 터도 붙게 하는도다 ");
INSERT INTO kor_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","내가 재앙을 그들의 위에 쌓으며 나의 살을 다하여 그들을 쏘리로다 ");
INSERT INTO kor_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","그들이 주리므로 파리하며 불 같은 더위와 독한 파멸에게 삼키울 것이라 내가 들짐승의 이와 티끌에 기는 것의 독을 그들에게 보내리로다 ");
INSERT INTO kor_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","밖으로는 칼에 방안에서는 놀람에 멸망하리니 청년 남자와 처녀와 젖 먹는 아이와 백발 노인까지리로다 ");
INSERT INTO kor_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","내가 그들을 흩어서 인간에서 그 기억이 끊어지게 하리라 하였다 마는 ");
INSERT INTO kor_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","대적을 격동할까 염려라 원수가 오해하고 말하기를 우리 수단이 높음이요 여호와의 행함이 아니라 할까 염려라 하시도다 ");
INSERT INTO kor_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","그들은 모략이 없는 국민이라 그 중에 지식이 없도다 ");
INSERT INTO kor_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","그들이 지혜가 있어서 이것을 깨닫고 자기의 종말을 생각하였으면 ");
INSERT INTO kor_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","그들의 반석이 그들을 팔지 아니하였고 여호와께서 그들을 내어 주지 아니하셨더면 어찌 한 사람이 천을 쫓으며 두 사람이 만을 도망케 하였을까 ");
INSERT INTO kor_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","대적의 반석이 우리의 반석과 같지 못하니 대적도 스스로 판단하도다 ");
INSERT INTO kor_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","그들의 포도나무는 소돔의 포도나무요 고모라의 밭의 소산이라 그들의 포도는 쓸개포도니 그 송이는 쓰며 ");
INSERT INTO kor_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","그들의 포도주는 뱀의 독이요 독사의 악독이라 ");
INSERT INTO kor_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","이것이 내게 쌓이고 내 곳간에 봉하여 있지 아니한가 ");
INSERT INTO kor_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","보수는 내 것이라 그들의 실족할 그 때에 갚으리로다 그들의 환난의 날이 가까우니 당할 그 일이 속히 임하리로다 ");
INSERT INTO kor_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","여호와께서 자기 백성을 판단하시고 그 종들을 인하여 후회하시리니 곧 그들의 무력함과 갇힌 자나 놓인 자가 없음을 보시는 때에로다 ");
INSERT INTO kor_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","여호와의 말씀에 그들의 신들이 어디 있으며 그들의 피하던 반석이 어디 있느냐 ? ");
INSERT INTO kor_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","그들의 희생의 고기를 먹던 것들, 전제의 술을 마시던 것들로 일어나서 너희를 돕게 하라 너희의 보장이 되게 하라 ");
INSERT INTO kor_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","이제는 나 곧 내가 그인 줄 알라 나와 함께 하는 신이 없도다 내가 죽이기도 하며 살리기도 하며 상하게도 하며 낫게도 하나니 내 손에서 능히 건질 자 없도다 ");
INSERT INTO kor_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","내가 하늘을 향하여 내 손을 들고 말하노라 나의 영원히 삶을 두고 맹세하노니 ");
INSERT INTO kor_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","나의 번쩍이는 칼을 갈며 내 손에 심판을 잡고 나의 대적에게 보수하며 나를 미워하는 자에게 보응할 것이라 ");
INSERT INTO kor_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","나의 화살로 피에 취하게 하고 나의 칼로 그 고기를 삼키게 하리니 곧 피살자와 포로된 자의 피요 대적의 장관의 머리로다 하시도다 ");
INSERT INTO kor_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","너희 열방은 주의 백성과 즐거워 하라 ! 주께서 그 종들의 피를 갚으사 그 대적에게 보수하시고 자기 땅과 백성을 위하여 속죄하시리로다 ");
INSERT INTO kor_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","모세와 눈의 아들 호세아가 와서 이 노래의 모든 말씀을 백성에게 말하여 들리니라 ");
INSERT INTO kor_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","모세가 이 모든 말씀을 온 이스라엘에게 말하기를 마치고 ");
INSERT INTO kor_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","그들에게 이르되 `내가 오늘날 너희에게 증거한 모든 말을 너희 마음에 두고 너희 자녀에게 명하여 이 율법의 모든 말씀을 지켜 행하게 하라 ");
INSERT INTO kor_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","이는 너희에게 허사가 아니라 너희의 생명이니 이 일로 인하여 너희가 요단을 건너 얻을 땅에서 너희의 날이 장구하리라' ");
INSERT INTO kor_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","당일에 여호와께서 모세에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","너는 여리고 맞은편 모압 땅에 있는 아바림산에 올라 느보산에 이르러 내가 이스라엘 자손에게 기업으로 주는 가나안 땅을 바라보라 ");
INSERT INTO kor_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","네 형 아론이 호르산에서 죽어 그 조상에게로 돌아간 것 같이 너도 올라가는 이 산에서 죽어 네 조상에게로 돌아가리니 ");
INSERT INTO kor_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","이는 너희가 신 광야 가데스의 므리바 물 가에서 이스라엘 자손중 내게 범죄하여 나의 거룩함을 이스라엘 자손 중에서 나타내지 아니한 연고라 ");
INSERT INTO kor_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","내가 이스라엘 자손에게 주는 땅을 네가 바라보기는 하려니와 그리로 들어가지는 못하리라 하시니라 ");
INSERT INTO kor_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","하나님의 사람 모세가 죽기 전에 이스라엘 자손을 위하여 축복함이 이러하니라 ");
INSERT INTO kor_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","일렀으되 여호와께서 시내에서 오시고 세일산에서 일어나시고 바란산에서 비취시고 일만 성도 가운데서 강림하셨고 그 오른손에는 불 같은 율법이 있도다 ");
INSERT INTO kor_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","여호와께서 백성을 사랑하시나니 모든 성도가 그 수중에 있으며 주의 발 아래에 앉아서 주의 말씀을 받는도다 ");
INSERT INTO kor_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","모세가 우리에게 율법을 명하였으니 곧 야곱의 총회의 기업이로다 ");
INSERT INTO kor_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","여수룬에 왕이 있었으니 곧 백성의 두령이 모이고 이스라엘 모든 지파가 함께 한 때에로다 ");
INSERT INTO kor_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","르우벤은 살고 죽지 아니하고 그 인수가 적지 않기를 원하도다 ");
INSERT INTO kor_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","유다에 대한 축복은 이러하니라 일렀으되 여호와여 ! 유다의 음성을 들으시고 그 백성에게로 인도하시오며 그 손으로 자기를 위하여 싸우게 하시고 주께서 도우사 그로 그 대적을 치게 하시기를 원하나이다 ");
INSERT INTO kor_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","레위에 대하여는 일렀으되 주의 둠밈과 우림이 주의 경건한 자에게 있도다 주께서 그를 맛사에서 시험하시고 므리바 물 가에서 그와 다투셨도다 ");
INSERT INTO kor_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","그는 그 부모에게 대하여 이르기를 내가 그들을 보지 못하였다 하며 그 형제들을 인정치 아니하며 그 자녀를 알지 아니한 것은 주의 말씀을 준행하고 주의 언약을 지킴을 인함이로다 ");
INSERT INTO kor_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","주의 법도를 야곱에게, 주의 율법을 이스라엘에게 가르치며 주 앞에 분향하고 온전한 번제를 주의 단 위에 드리리로다 ");
INSERT INTO kor_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","여호와여 ! 그 재산을 풍족케 하시고 그 손의 일을 받으소서 ! 그를 대적하여 일어나는 자와 미워하는 자의 허리를 꺽으사 다시 일어나지 못하게 하옵소서 ! ");
INSERT INTO kor_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","베냐민에 대하여는 일렀으되 여호와의 사랑을 입은 자는 그 곁에 안전히 거하리로다 여호와께서 그를 날이 맞도록 보호하시고 그로 자기 어깨 사이에 처하게 하시리로다 ");
INSERT INTO kor_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","요셉에 대하여는 일렀으되 원컨대 그 땅이 여호와께 복을 받아 하늘의 보물인 이슬과 땅 아래 저장한 물과 ");
INSERT INTO kor_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","태양이 결실케 하는 보물과 태음이 자라게 하는 보물과 ");
INSERT INTO kor_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","옛 산의 상품물과 영원한 작은 산의 보물과 ");
INSERT INTO kor_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","땅의 보물과 거기 충만한 것과 가시떨기 나무 가운데 거하시던 자의 은혜로 인하여 복이 요셉의 머리에, 그 형제 중 구별한 자의 정수리에 임할지로다 ");
INSERT INTO kor_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","그는 첫 수송아지 같이 위엄이 있으니 그 뿔이 들소의 뿔 같도다 이것으로 열방을 받아 땅 끝까지 이르리니 곧 에브라임의 만민이요 므낫세의 천천이리로다 ");
INSERT INTO kor_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","스불론에 대하여는 일렀으되 스불론이여 너는 나감을 기뻐하라 잇사갈이여 ! 너는 장막에 있음을 즐거워하라 ! ");
INSERT INTO kor_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","그들이 열국 백성을 불러 산에 이르게 하고 거기서 의로운 제사를 드릴 것이며 바다의 풍부한 것,모래에 감추인 보배를 흡수하리로다 ");
INSERT INTO kor_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","갓에 대하여는 일렀으되 갓을 광대케 하시는 자에게 찬송을 부를지어다 ! 갓이 암사자같이 엎드리고 팔과 정수리를 찢는도다 ");
INSERT INTO kor_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","그가 자기를 위하여 먼저 기업을 택하였으니 곧 법 세운 자의 분깃으로 예비된 것이로다 그가 백성의 두령들과 함께 와서 여호와의 공의와 이스라엘과 세우신 법도를 행하도다 ");
INSERT INTO kor_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","단에 대하여는 일렀으되 단은 바산에서 뛰어 나오는 사자의 새끼로다 ");
INSERT INTO kor_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","납달리에 대하여는 일렀으되 은혜가 족하고 여호와의 복이 가득한 납달리여 ! 너는 서방과 남방을 얻을지로다 ");
INSERT INTO kor_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","아셀에 대하여는 일렀으되 아셀은 다자한 복을 받으며 그 형제에게 기쁨이 되며 그 발이 기름에 잠길지로다 ");
INSERT INTO kor_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","네 문빗장은 철과 놋이 될 것이니 네 사는 날을 따라서 능력이 있으리로다 ");
INSERT INTO kor_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","여수룬이여 ! 하나님 같은 자 없도다 그가 너를 도우시려고 하늘을 타시고 궁창에서 위엄을 나타내시는도다 ");
INSERT INTO kor_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","영원하신 하나님이 너의 처소가 되시니 그 영원하신 팔이 네 아래 있도다 그가 네 앞에서 대적을 쫓으시며 멸하라 하시도다 ");
INSERT INTO kor_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","이스라엘이 안전히 거하며 야곱의 샘은 곡식과 새 포도주의 땅에 홀로 있나니 곧 그의 하늘이 이슬을 내리는 곳에로다 ");
INSERT INTO kor_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","이스라엘이여 ! 너는 행복자로다 ! 여호와의 구원을 너같이 얻은 백성이 누구뇨 그는 너를 돕는 방패시요 너의 영광의 칼이시로다 네 대적이 네게 복종하리니 네가 그들의 높은 곳을 밟으리로다 ");
INSERT INTO kor_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","모세가 모압 평지에서 느보산에 올라 여리고 맞은편 비스가산 꼭대기에 이르매 여호와께서 길르앗 온 땅을 단까지 보이시고 ");
INSERT INTO kor_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","또 온 납달리와 에브라임과 므낫세의 땅과 서해까지의 유다 온 땅과 ");
INSERT INTO kor_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","남방과 종려의 성읍 여리고 골짜기 평지를 소알까지 보이시고 ");
INSERT INTO kor_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","여호와께서 그에게 이르시되 이는 내가 아브라함과 이삭과 야곱에게 맹세하여 그 후손에게 주리라 한 땅이라 내가 네 눈으로 보게 하였거니와 너는 그리로 건너가지 못하리라 하시매 ");
INSERT INTO kor_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","이에 여호와의 종 모세가 여호와의 말씀대로 모압 땅에서 죽어 ");
INSERT INTO kor_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","벧브올 맞은편 모압 땅에 있는 골짜기에 장사되었고 오늘까지 그 묘를 아는 자 없으니라 ");
INSERT INTO kor_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","모세의 죽을 때 나이 일백 이십세나 그 눈이 흐리지 아니하였고 기력이 쇠하지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","이스라엘 자손이 모압 평지에서 애곡하는 기한이 맞도록 모세를 위하여 삼십일을 애곡하니라 ");
INSERT INTO kor_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","모세가 눈의 아들 여호수아에게 안수하였으므로 그에게 지혜의 신이 충만하니 이스라엘 자손이 여호와께서 모세에게 명하신 대로 여호수아의 말을 순종하였더라 ");
INSERT INTO kor_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","그 후에는 이스라엘에 모세와 같은 선지자가 일어나지 못하였나니 모세는 여호와께서 대면하여 아시던 자요 ");
INSERT INTO kor_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","여호와께서 그를 애굽 땅에 보내사 바로와 그 모든 신하와 그 온 땅에 모든 이적과 기사와 ");
INSERT INTO kor_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","모든 큰 권능과 위엄을 행하게 하시매 온 이스라엘 목전에서 그것을 행한 자더라 ");
INSERT INTO kor_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","여호와의 종 모세가 죽은 후에 여호와께서 모세의 시종 눈의 아들 여호수아에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","내 종 모세가 죽었으니 이제 너는 이 모든 백성으로 더불어 일어나 이 요단을 건너 내가 그들 곧 이스라엘 자손에게 주는 땅으로 가라 ");
INSERT INTO kor_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","내가 모세에게 말한 바와 같이 무릇 너희 발바닥으로 밟는 곳을 내가 다 너희에게 주었노니 ");
INSERT INTO kor_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","곧 광야와 이 레바논에서부터 큰 하수 유브라데에 이르는 헷 족속의 온 땅과 또 해 지는 편 대해까지 너희 지경이 되리라 ");
INSERT INTO kor_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","너의 평생에 너를 능히 당할 자 없으리니 내가 모세와 함께 있던 것 같이 너의 함께 있을 것임이라 내가 너를 떠나지 아니하며 버리지 아니하리니 ");
INSERT INTO kor_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","마음을 강하게 하라 ! 담대히 하라 ! 너는 이 백성으로 내가 그 조상에게 맹세하여 주리라 한 땅을 얻게 하리라 ");
INSERT INTO kor_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","오직 너는 마음을 강하게 하고 극히 담대히 하여 나의 종 모세가 네게 명한 율법을 다 지켜 행하고 좌로나 우로나 치우치지 말라 ! 그리하면 어디로 가든지 형통하리니 ");
INSERT INTO kor_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","이 율법책을 네 입에서 떠나지 말게 하며 주야로 그것을 묵상하여 그 가운데 기록한대로 다 지켜 행하라 ! 그리하면 네 길이 평탄하게 될 것이라 네가 형통하리라 ! ");
INSERT INTO kor_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","내가 네게 명한 것이 아니냐 ? 마음을 강하게 하고 담대히 하라 ! 두려워 말며 놀라지 말라 ! 네가 어디로 가든지 네 하나님 여호와가 너와 함께 하느니라 ! 하시니라 ");
INSERT INTO kor_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","이에 여호수아가 백성의 유사들에게 명하여 가로되 ");
INSERT INTO kor_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","`진 중에 두루 다니며 백성에게 명하여 이르기를 양식을 예비하라 삼일 안에 너희가 이 요단을 건너 너희 하나님 여호와께서 너희에게 주사 얻게 하시는 땅을 얻기 위하여 들어갈 것임이니라 하라' ");
INSERT INTO kor_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","여호수아가 또 르우벤 지파와, 갓 지파와 ");
INSERT INTO kor_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","므낫세 반 지파에게 일러 가로되 `여호와의 종 모세가 너희에게 명하여 이르기를 너희 하나님 여호와께서 너희에게 안식을 주시며 이 땅을 너희에게 주시리라 하였나니 너희는 그 말을 기억하라 ");
INSERT INTO kor_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","너희 처자와 가축은 모세가 너희에게 준 요단 이편 땅에 머무르려니와 너희 용사들은 무장하고 너희의 형제보다 앞서 건너가서 그들을 돕고 ");
INSERT INTO kor_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","여호와께서 너희로 안식하게 하신 것 같이 너희 형제도 안식하게 되며 그들도 너희 하나님 여호와께서 주시는 땅을 얻게 되거든 너희는 너희 소유지 곧 여호와의 종 모세가 너희에게 준 요단 이편 해 돋는 편으로 돌아와서 그것을 차지할지니라' ");
INSERT INTO kor_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","그들이 여호수아에게 대답하여 가로되 `당신이 우리에게 명하신 것은 우리가 다 행할 것이요 당신이 우리를 보내시는 곳에는 우리가 가리이다 ");
INSERT INTO kor_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","그들이 여호수아에게 대답하여 가로되 `당신이 우리에게 명하신 것은 우리가 다 행할 것이요 당신이 우리를 보내시는 곳에는 우리가 가리이다 ");
INSERT INTO kor_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","우리는 범사에 모세를 청종한 것 같이 당신을 청종하려니와 오직 당신의 하나님 여호와께서 모세와 함께 계시던 것 같이 당신과 함께 계시기를 원하나이다  (Joshua 1:19) 누구든지 당신의 명령을 거역하며 무릇 당신의 시키는 말씀을 청종치 아니하는 자 그는 죽임을 당하리니 오직 당신은 마음을 강하게 하시며 담대히 하소서'  ");
INSERT INTO kor_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","눈의 아들 여호수아가 싯딤에서 두 사람을 정탐으로 가만히 보내며 그들에게 이르되 가서 그 땅과 여리고를 엿보라 하매 그들이 가서 라합이라 하는 기생의 집에 들어가 거기서 유숙하더니 ");
INSERT INTO kor_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","혹이 여리고 왕에게 고하여 가로되 `보소서 이 밤에 이스라엘 자손 몇 사람이 땅을 탐지하러 이리로 들어 왔나이다' ");
INSERT INTO kor_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","여리고 왕이 라합에게 기별하여 가로되 `네게로 와서 네 집에 들어간 사람들을 끌어내라 그들은 이 온 땅을 탐지하러 왔느니라' ");
INSERT INTO kor_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","그 여인이 그 두 사람을 이미 숨긴지라 가로되 `과연 그 사람들이 내게 왔었으나 그들이 어디로서인지 나는 알지 못하였고 ");
INSERT INTO kor_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","그 사람들이 어두워 성문을 닫을 때쯤 되어 나갔으니 어디로 갔는지 알지 못하되 급히 따라가라 그리하면 그들에게 미치리라' 하였으나 ");
INSERT INTO kor_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","실상은 그가 이미 그들을 이끌고 지붕에 올라가서 그 지붕에 벌여놓은 삼대에 숨겼더라 ");
INSERT INTO kor_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","그 사람들은 요단 길로 나루턱까지 따라갔고 그 따르는 자들이 나가자 곧 성문을 닫았더라 ");
INSERT INTO kor_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","두 사람이 눕기 전에 라합이 지붕에 올라가서 그들에게 이르러 ");
INSERT INTO kor_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","말하되 `여호와께서 이 땅을 너희에게 주신 줄을 내가 아노라 우리가 너희를 심히 두려워하고 이 땅 백성이 다 너희 앞에 간담이 녹나니 ");
INSERT INTO kor_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","이는 너희가 애굽에서 나올 때에 여호와께서 너희 앞에서 홍해 물을 마르게 하신 일과 너희가 요단 저편에 있는 아모리 사람의 두 왕 시혼과 옥에게 행한 일 곧 그들을 전멸시킨 일을 우리가 들었음이라 ");
INSERT INTO kor_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","우리가 듣자 곧 마음이 녹았고 너희의 연고로 사람이 정신을 잃었나니 너희 하나님 여호와는 상천 하지에 하나님이시니라 ! ");
INSERT INTO kor_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","그러므로 청하노니 내가 너희를 선대하였은즉 너희도 내 아버지의 집을 선대하여 나의 부모와 남녀 형제와 무릇 그들에게 있는 모든 자를 살려주어 우리 생명을 죽는데서 건져내기로 이제 여호와로 맹세하고 내게 진실한 표를 내라' ");
INSERT INTO kor_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","(12절과 같음) ");
INSERT INTO kor_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","두 사람이 그에게 이르되 `네가 우리의 이 일을 누설치 아니하면 우리의 생명으로 너희를 대신이라도 할 것이요 여호와께서 우리에게 이 땅을 주실 때에는 인자하고 진실하게 너를 대우하리라' ");
INSERT INTO kor_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","라합이 그들을 창에서 줄로 달아내리우니 그 집이 성벽 위에 있으므로 그가 성벽 위에 거하였음이라 ");
INSERT INTO kor_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","라합이 그들에게 이르되 `두렵건대 따르는 사람들이 너희를 만날까 하노니 너희는 산으로 가서 거기 사흘을 숨었다가 따르는 자들이 돌아간 후에 너희 길을 갈지니라' ");
INSERT INTO kor_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","두 사람이 그에게 이르되 `네가 우리로 서약케 한 이 맹세에 대하여 우리가 허물이 없게 하리니 ");
INSERT INTO kor_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","우리가 이 땅에 들어올 때에 우리를 달아 내리운 창에 이 붉은 줄을 내고 네 부모와 형제와 네 아비의 가족을 다 네 집에 모으라 ");
INSERT INTO kor_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","누구든지 네 집 문을 나서 거리로 가면 그 피가 그의 머리로 돌아갈 것이요 우리는 허물이 없으리라 그러나 누구든지 너와 함께 집에 있는 자에게 누가 손을 대면 그 피는 우리의 머리로 돌아오려니와 ");
INSERT INTO kor_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","네가 우리의 이 일을 누설하면 네가 우리로 서약케 한 맹세에 대하여 우리에게 허물이 없으리라' ");
INSERT INTO kor_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","라합이 가로되 `너희의 말대로 할 것이라' 하고 그들을 보내어 가게 하고 붉은 줄을 창문에 매니라 ");
INSERT INTO kor_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","그들이 가서 산에 이르러 따르는 자가 돌아가도록 사흘을 거기 유하매 따르는 자가 그들을 길에서 두루 찾다가 만나지 못하니라 ");
INSERT INTO kor_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","그 두 사람이 돌이켜 산에서 내려와 강을 건너 눈의 아들 여호수아에게 나아와서 그 당한 모든 일을 고하고 ");
INSERT INTO kor_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","또 여호수아에게 이르되 `진실로 여호와께서 그 온 땅을 우리 손에 붙이셨으므로 그 땅의 모든 거민이 우리 앞에서 간담이 녹더이다 ");
INSERT INTO kor_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","여호수아가 아침에 일찌기 일어나서 이스라엘 사람들로 더불어 싯딤에서 떠나 요단에 이르러서는 건너지 아니하고 거기서 유숙하니라 ");
INSERT INTO kor_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","삼일 후에 유사들이 진중으로 두루 다니며 ");
INSERT INTO kor_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","백성에게 명하여 가로되 `너희는 레위 사람 제사장들이 너희 하나님 여호와의 언약궤 메는 것을 보거든 너희 곳을 떠나 그 뒤를 좇으라 ");
INSERT INTO kor_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","그러나 너희와 그 사이 상거가 이천 규빗쯤 되게 하고 그것에 가까이 하지는 말라 그리하면 너희 행할 길을 알리니 너희가 이전에 이 길을 지나보지 못하였음이니라' ");
INSERT INTO kor_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","여호수아가 또 백성에게 이르되 `너희는 스스로 성결케 하라 ! 여호와께서 내일 너희 가운데 기사를 행하시리라' ");
INSERT INTO kor_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","여호수아가 또 제사장들에게 일러 가로되 `언약궤를 메고 백성 앞서 건너라' 하매 곧 언약궤를 메고 백성 앞서 나아가니라 ");
INSERT INTO kor_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","여호와께서 여호수아에게 이르시되 내가 오늘부터 시작하여 너를 온 이스라엘의 목전에서 크게 하여 내가 모세와 함께 있던 것 같이 너와 함께 있는 것을 그들로 알게 하리라 ");
INSERT INTO kor_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","너는 언약궤를 멘 제사장들에게 명하여 이르기를 너희가 요단 물가에 이르거든 요단에 들어서라 하라 ");
INSERT INTO kor_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","여호수아가 이스라엘 자손에게 이르되 `이리 와서 너희 하나님 여호와의 말씀을 들으라' 하고 ");
INSERT INTO kor_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","또 말하되 `사시는 하나님이 너희 가운데 계시사 가나안 족속과, 헷 족속과, 히위 족속과, 브리스 족속과, 기르가스 족속과, 아모리 족속과, 여부스 족속을 너희 앞에서 정녕히 쫓아내실 줄을 이 일로 너희가 알리라 ");
INSERT INTO kor_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","보라, 온 땅의 주의 언약궤가 너희 앞서 요단으로 들어가나니 ");
INSERT INTO kor_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","이제 이스라엘 지파 중에서 매 지파에 한 사람씩 십 이명을 택하라 ");
INSERT INTO kor_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","온 땅의 주 여호와의 궤를 멘 제사장들의 발바닥이 요단 물을 밟고 멈추면 요단 물 곧 위에서부터 흘러 내리던 물이 끊어지고 쌓여 서리라' ");
INSERT INTO kor_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","백성이 요단을 건너려고 자기들의 장막을 떠날때에 제사장들은 언약궤를 메고 백성 앞에서 행하니라 ");
INSERT INTO kor_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","(요단이 모맥 거두는 시기에는 항상 언덕에 넘치더라) 궤를 멘 자들이 요단에 이르며 궤를 멘 제사장들의 발이 물가에 잠기자 ");
INSERT INTO kor_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","곧 위에서부터 흘러 내리던 물이 그쳐서 심히 멀리 사르단에 가까운 아담 읍 변방에 일어나 쌓이고 아라바의 바다 염해로 향하여 흘러가는 물은 온전히 끊어지매 백성이 여리고 앞으로 바로 건널새 ");
INSERT INTO kor_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","여호와의 언약궤를 멘 제사장들은 요단 가운데 마른 땅에 굳게 섰고 온 이스라엘 백성은 마른 땅으로 행하여 요단을 건너니라 ");
INSERT INTO kor_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","온 백성이 요단 건너기를 마치매 여호와께서 여호수아에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","백성의 매 지파에 한 사람씩 열 두 사람을 택하고 ");
INSERT INTO kor_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","그들에게 명하여 이르기를 요단 가운데 제사장들의 발이 굳게 선 그곳에서 돌 열 둘을 취하고 그것을 가져다가 오늘밤 너희의 유숙할 그 곳에 두라 하라 ");
INSERT INTO kor_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","여호수아가 이스라엘 자손 중에서 매 지파에 한 사람씩 예비한 그 열 두 사람을 불러서 ");
INSERT INTO kor_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","그들에게 이르되 `요단 가운데 너희 하나님 여호와의 궤 앞으로 들어가서 이스라엘 자손들의 지파 수대로 각기 돌 한개씩 취하여 어깨에 메라 ");
INSERT INTO kor_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","이것이 너희 중에 표징이 되리라 후일에 너희 자손이 물어 가로되 이 돌들은 무슨 뜻이뇨 ? 하거든 ");
INSERT INTO kor_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","그들에게 이르기를 요단 물이 여호와의 언약궤 앞에서 끊어졌었나니 곧 언약궤가 요단을 건널 때에 요단 물이 끊어졌으므로 이 돌들이 이스라엘 자손에게 영영한 기념이 되리라' 하라 ");
INSERT INTO kor_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","이스라엘 자손들이 여호수아의 명한 대로 행하되 여호와께서 여호수아에게 이르신 대로 이스라엘 자손들의 지파 수를 따라 요단 가운데서 돌 열 둘을 취하여 자기들의 유숙할 곳으로 가져다가 거기 두었더라 ");
INSERT INTO kor_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","여호수아가 또 요단 가운데 곧 언약궤를 멘 제사장들의 발이 선곳에 돌 열 둘을 세웠더니 오늘까지 거기 있더라 ");
INSERT INTO kor_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","궤를 멘 제사장들이 여호와께서 여호수아에게 명하사 백성에게 이르게 하신 일 곧 모세가 여호수아에게 명한 일이 다 마치기까지 요단 가운데 섰고 백성은 속히 건넜으며 ");
INSERT INTO kor_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","모든 백성이 건너기를 마친 후에 여호와의 궤와 제사장들이 백성의 목전에서 건넜으며 ");
INSERT INTO kor_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","르우벤 자손과 갓 자손과 므낫세 반 지파는 모세가 그들에게 이른 것 같이 무장하고 이스라엘 자손들보다 앞서 건너갔으니 ");
INSERT INTO kor_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","사만명 가량이라 무장하고 여호와 앞에서 건너가서 싸우려고 여리고 평지에 이르니라 ");
INSERT INTO kor_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","그 날에 여호와께서 모든 이스라엘의 목전에서 여호수아를 크게 하시매 그의 생존한 날 동안에 백성이 두려워하기를 모세를 두려워하던 것같이 하였더라 ");
INSERT INTO kor_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","여호와께서 여호수아에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","증거궤를 멘 제사장들을 명하여 요단에서 올라오게 하라 하신지라 ");
INSERT INTO kor_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","여호수아가 제사장들에게 명하여 `요단에서 올라오라' 하매 ");
INSERT INTO kor_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","여호와의 언약궤를 멘 제사장들이 요단 가운데서 나오며 그 발바닥으로 육지를 밟는 동시에 요단 물이 본 곳으로 도로 흘러 여전히 언덕에 넘쳤더라 ");
INSERT INTO kor_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","정월 십일에 백성이 요단에서 올라와서 여리고 동편 지경 길갈에 진 치매 ");
INSERT INTO kor_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","여호수아가 그 요단에서 가져온 열 두 돌을 길갈에 세우고 ");
INSERT INTO kor_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","이스라엘 자손들에게 일러 가로되 `후일에 너희 자손이 그 아비에게 묻기를 이 돌은 무슨 뜻이냐 ? 하거든 ");
INSERT INTO kor_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","너희는 자손에게 알게 하여 이르기를 이스라엘이 마른 땅을 밟고 이 요단을 건넜음이라 ");
INSERT INTO kor_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","너희 하나님 여호와께서 요단 물을 너희 앞에 마르게 하사 너희로 건너게 하신 것이 너희 하나님 여호와께서 우리 앞에 홍해를 말리시고 우리로 건너게 하심과 같았나니 ");
INSERT INTO kor_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","이는 땅의 모든 백성으로 여호와의 손이 능하심을 알게 하며 너희로 너희 하나님 여호와를 영원토록 경외하게 하려 하심이라' 하라 ");
INSERT INTO kor_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","요단 서편의 아모리 사람의 모든 왕과 해변의 가나안 사람의 모든 왕이 여호와께서 요단 물을 이스라엘 자손들 앞에서 말리시고 우리를 건네셨음을 듣고 마음이 녹았고 이스라엘 자손들의 연고로 정신을 잃었더라 ");
INSERT INTO kor_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","그 때에 여호와께서 여호수아에게 이르시되 너는 부싯돌로 칼을 만들어 이스라엘 자손들에게 다시 할례를 행하라 ! 하시매 ");
INSERT INTO kor_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","여호수아가 부싯돌로 칼을 만들어 할례산에서 이스라엘 자손들에게 할례를 행하니라 ");
INSERT INTO kor_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","여호수아가 할례를 시행한 까닭은 이것이니 애굽에서 나온 모든 백성 중 남자 곧 모든 군사는 애굽에서 나온 후 광야 노중에서 죽었는데 ");
INSERT INTO kor_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","그 나온 백성은 다 할례를 받았으나 오직 애굽에서 나온 후 광야 노중에서 난 자는 할례를 받지 못하였음이라 ");
INSERT INTO kor_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","이스라엘 자손들이 여호와의 말씀을 청종치 아니하므로 여호와께서 그들에게 대하여 맹세하사 그들의 열조에게 맹세하여 우리에게 주마 하신 땅 곧 젖과 꿀이 흐르는 땅을 그들로 보지 못하게 하리라 하시매 애굽에서 나온 족속 곧 군사들이 다 멸절하기까지 사십년 동안을 광야에 행하였더니 ");
INSERT INTO kor_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","그들의 대를 잇게 하신 이 자손에게 여호수아가 할례를 행하였으니 길에서는 그들에게 할례를 행치 못하였으므로 할례 없는 자가 되었음이었더라 ");
INSERT INTO kor_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","온 백성에게 할례 행하기를 필하매 백성이 진중 각 처소에 처하여 낫기를 기다릴 때에 ");
INSERT INTO kor_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","여호와께서 여호수아에게 이르시되 내가 오늘날 애굽의 수치를 너희에게서 굴러가게 하였다 하셨으므로 그곳 이름을 오늘까지 길갈이라 하느니라 ");
INSERT INTO kor_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","이스라엘 자손들이 길갈에 진 쳤고 그 달 십 사일 저녁에는 여리고 평지에서 유월절을 지켰고 ");
INSERT INTO kor_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","유월절 이튿날에 그 땅 소산을 먹되 그 날에 무교병과 볶은 곡식을 먹었더니 ");
INSERT INTO kor_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","그 땅 소산을 먹은 다음 날에 만나가 그쳤으니 이스라엘 사람들이 다시는 만나를 얻지 못하였고 그 해에 가나안 땅의 열매를 먹었더라 ");
INSERT INTO kor_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","여호수아가 여리고에 가까왔을 때에 눈을 들어 본즉 한 사람이 칼을 빼어 손에 들고 마주 섰는지라 여호수아가 나아가서 그에게 묻되 '너는 우리를 위하느냐 ? 우리의 대적을 위하느냐 ?' ");
INSERT INTO kor_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","그가 가로되 `아니라 나는 여호와의 군대 장관으로 이제 왔느니라' 여호수아가 땅에 엎드려 절하고 가로되 '나의 주여 ! 종에게 무슨 말씀을 하려 하시나이까 ?' ");
INSERT INTO kor_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","여호와의 군대 장관이 여호수아에게 이르되 `네 발에서 신을 벗으라 ! 네가 선 곳은 거룩하니라' 여호수아가 그대로 행하니라 ");
INSERT INTO kor_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","이스라엘 자손들로 인하여 여리고는 굳게 닫혔고 출입하는 자 없더라 ");
INSERT INTO kor_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","여호와께서 여호수아에게 이르시되 보라, 내가 여리고와 그 왕과 용사들을 네 손에 붙였으니 ");
INSERT INTO kor_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","너희 모든 군사는 성을 둘러 성 주위를 매일 한번씩 돌되 엿새 동안을 그리하라 ");
INSERT INTO kor_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","제사장 일곱은 일곱 양각나팔을 잡고 언약궤 앞에서 행할 것이요 제 칠일에는 성을 일곱번 돌며 제사장들은 나팔을 불 것이며 ");
INSERT INTO kor_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","제사장들이 양각나팔을 길게 울려 불어서 그 나팔 소리가 너희에게 들릴 때에는 백성은 다 큰 소리로 외쳐 부를 것이라 그리하면 그 성벽이 무너져 내리리니 백성은 각기 앞으로 올라갈지니라 하시매 ");
INSERT INTO kor_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","눈의 아들 여호수아가 제사장들을 불러서 그들에게 이르되 너희는 언약궤를 메고 일곱 제사장은 일곱 양각 나팔을 잡고 여호와의 궤 앞에서 행하라 하고 ");
INSERT INTO kor_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","또 백성에게 이르되 나아가서 성을 돌되 무장한 자들이 여호와의 궤 앞에 행할지니라 ");
INSERT INTO kor_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","여호수아가 백성에게 이르기를 마치매 제사장 일곱이 일곱 양각 나팔을 잡고 여호와 앞에서 진행하며 나팔을 불고 여호와의 언약궤는 그 뒤를 따르며 ");
INSERT INTO kor_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","무장한 자들은 나팔 부는 제사장들 앞에서 진행하며 후군은 궤 뒤에 행하고 제사장들은 나팔을 불며 행하더라 ");
INSERT INTO kor_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","여호수아가 백성에게 명하여 가로되 `너희는 외치지 말며 너희 음성을 들레지 말며 너희 입에서 아무 말도 내지 말라 그리하다가 내가 너희에게 명하여 외치라 하는 날에 외칠지니라' 하고 ");
INSERT INTO kor_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","여호와의 궤로 성을 한번 돌게 하니라 무리가 진에 돌아와서 진에서 자니라 ");
INSERT INTO kor_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","여호수아가 아침에 일찌기 일어나니라 제사장들이 여호와의 궤를 메고 ");
INSERT INTO kor_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","일곱 제사장은 일곱 양각 나팔을 잡고 여호와의 궤 앞에서 계속 진행하며 나팔을 불고 무장한 자들은 그 앞에 행하며 후군은 여호와의 궤 뒤에 행하고 제사장들은 나팔을 불며 행하니라 ");
INSERT INTO kor_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","그 제 이일에도 성을 한번 돌고 진에 돌아오니라 엿새 동안을 이같이 행하니라 ");
INSERT INTO kor_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","제 칠일 새벽에 그들이 일찌기 일어나서 여전한 방식으로 성을 일곱번 도니 성을 일곱번 돌기는 그날 뿐이었더라 ");
INSERT INTO kor_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","일곱번째에 제사장들이 나팔을 불 때에 여호수아가 백성에게 이르되 `외치라 ! 여호와께서 너희에게 이 성을 주셨느니라 ! ");
INSERT INTO kor_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","이 성과 그 가운데 모든 물건은 여호와께 바치니 기생 라합과 무릇 그 집에 동거하는 자는 살리라 ! 이는 그가 우리의 보낸 사자를 숨겼음이니라 ");
INSERT INTO kor_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","너희는 바칠 물건을 스스로 삼가라 너희가 그것을 바친 후에 그 바친 어느 것이든지 취하면 이스라엘 진으로 바침이 되어 화를 당케 할까 두려워 하노라 ");
INSERT INTO kor_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","은,금과 동철 기구들은 다 여호와께 구별될 것이니 그것을 여호와의 곳간에 들일지니라' ");
INSERT INTO kor_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","이에 백성은 외치고 제사장들은 나팔을 불매 백성이 나팔 소리를 듣는 동시에 크게 소리질러 외치니 성벽이 무너져 내린지라 백성이 각기 앞으로 나아가 성에 들어가서 그 성을 취하고 ");
INSERT INTO kor_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","성 중에 있는 것을 다 멸하되 남녀 노유와 우양과 나귀를 칼날로 멸하니라 ");
INSERT INTO kor_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","여호수아가 그 땅을 정탐한 두 사람에게 이르되 `그 기생의 집에 들어 가서 너희가 그 여인에게 맹세한 대로 그와 그에게 속한 모든 것을 이끌어내라' 하매 ");
INSERT INTO kor_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","정탐한 소년들이 들어가서 라합과 그 부모와 그 형제와 그에게 속한 모든 것을 이끌어 내고 또 그 친족도 다 이끌어 내어 그들을 이스라엘 진 밖에 두고 ");
INSERT INTO kor_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","무리가 불로 성읍과 그 가운데 있는 모든 것을 사르고 은,금과 동철 기구는 여호와의 집 곳간에 두었더라 ");
INSERT INTO kor_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","여호수아가 기생 라합과 그 아비의 가족과 그에게 속한 모든 것을 살렸으므로 그가 오늘날까지 이스라엘 중에 거하였으니 이는 여호수아가 여리고를 탐지하려고 보낸 사자를 숨겼음이었더라 ");
INSERT INTO kor_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","여호수아가 그 때에 맹세로 무리를 경계하여 가로되 `이 여리고 성을 누구든지 일어나서 건축하는 자는 여호와 앞에서 저주를 받을 것이라 그 기초를 쌓을 때에 장자를 잃을 것이요 문을 세울 때에 계자를 잃으리라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","여호와께서 여호수아와 함께 하시니 여호수아의 명성이 그 온 땅에 퍼지니라 ");
INSERT INTO kor_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","이스라엘 자손들이 바친 물건을 인하여 범죄하였으니 이는 유다 지파 세라의 증손 삽디의 손자 갈미의 아들 아간이 바친 물건을 취하였음이라 여호와께서 이스라엘 자손들에게 진노하시니라 ");
INSERT INTO kor_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","여호수아가 여리고에서 사람을 벧엘 동편 벧아웬 곁에 있는 아이로 보내며 그들에게 일러 가로되 '올라가서 그 땅을 정탐하라' 하매 그 사람들이 올라가서 아이를 정탐하고 ");
INSERT INTO kor_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","여호수아에게로 돌아와서 그에게 이르되 `백성을 다 올라가게 말고 이삼천명만 올라가서 아이를 치게 하소서 그들은 소수니 모든 백성을 그리로 보내어 수고롭게 마소서' 하므로 ");
INSERT INTO kor_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","백성중 삼천명쯤 그리로 올라갔다가 아이 사람 앞에서 도망하니 ");
INSERT INTO kor_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","아이 사람이 그들의 삼십 륙인쯤 죽이고 성문 앞에서부터 스바림까지 쫓아와서 내려가는 비탈에서 쳤으므로 백성의 마음이 녹아 물 같이 된지라 ");
INSERT INTO kor_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","여호수아가 옷을 찢고 이스라엘 장로들과 함께 여호와의 궤 앞에서 땅에 엎드려 머리에 티끌을 무릅쓰고 저물도록 있다가 ");
INSERT INTO kor_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","여호수아가 가로되 `슬프도소이다, 주 여호와여 ! 어찌하여 이 백성을 인도하여 요단을 건너게 하시고 우리를 아모리 사람의 손에 붙여 멸망시키려 하셨나이까 ? 우리가 요단 저 편을 족하게 여겨 거하였더면 좋을 뻔 하였나이다 ");
INSERT INTO kor_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","주여 ! 이스라엘이 그 대적 앞에서 돌아섰으니 내가 무슨 말을 하오리이까 ? ");
INSERT INTO kor_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","가나안 사람과 이 땅 모든 거민이 이를 듣고 우리를 둘러싸고 우리 이름을 세상에서 끊으리니 주의 크신 이름을 위하여 어떻게 하시려나이까 ?' ");
INSERT INTO kor_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","여호와께서 여호수아에게 이르시되 일어나라 ! 어찌하여 이렇게 엎드렸느냐 ? ");
INSERT INTO kor_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","이스라엘이 범죄하여 내가 그들에게 명한 나의 언약을 어기었나니 곧 그들이 바친 물건을 취하고 도적하고 사기하여 자기 기구 가운데 두었느니라 ");
INSERT INTO kor_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","그러므로 이스라엘 자손들이 자기 대적을 능히 당치 못하고 그 앞에서 돌아섰나니 이는 자기도 바친 것이 됨이라 그 바친 것을 너희 중에서 멸하지 아니하면 내가 다시는 너희와 함께 있지 아니하리라 ");
INSERT INTO kor_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","너는 일어나서 백성을 성결케 하여 이르기를 너희는 스스로 성결케 하여 내일을 기다리라 이스라엘의 하나님 여호와의 말씀에 이스라엘아 ! 너의 중에 바친 물건이 있나니 네가 그 바친 물건을 너의 중에서 제하기 전에는 너의 대적을 당치 못하리라 ");
INSERT INTO kor_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","아침에 너희는 너희 지파대로 가까이 나아오라 여호와께 뽑히는 지파는 그 족속대로 가까이 나아올 것이요 여호와께 뽑히는 족속은 그 가족대로 가까이 나아올 것이요 여호와께 뽑히는 가족은 각 남자대로 가까이 나아올 것이며 ");
INSERT INTO kor_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","바친 물건을 가진 자로 뽑힌 자를 불사르되 그와 그 모든 소유를 그리하라 이는 여호와의 언약을 어기고 이스라엘 가운데서 망령 된 일을 행하였음이라 하셨다 하라 ");
INSERT INTO kor_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","이에 여호수아가 아침 일찌기 일어나서 이스라엘을 그 지파대로 가까이 나아오게 하였더니 유다 지파가 뽑혔고 ");
INSERT INTO kor_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","유다 족속을 가까이 나아오게 하였더니 세라 족속이 뽑혔고 세라족속의 각 남자를 가까이 나아오게 하였더니 삽디가 뽑혔고 ");
INSERT INTO kor_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","삽디의 가족 각 남자를 가까이 나아오게 하였더니 유다 지파 세라의 증손이요 삽디의 손자요 갈미의 아들인 아간이 뽑혔더라 ");
INSERT INTO kor_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","여호수아가 아간에게 이르되 `내 아들아 청하노라 이스라엘의 하나님 여호와께 영광을 돌려 그 앞에 자복하고 네 행한 일을 내게 고하라 그 일을 내게 숨기지 말라' ");
INSERT INTO kor_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","아간이 여호수아에게 대답하여 가로되 `참으로 나는 이스라엘 하나님 여호와께 범죄하여 여차 여차히 행하였나이다 ");
INSERT INTO kor_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","내가 노략한 물건 중에 시날산의 아름다운 외투 한벌과 은 이백 세겔과 오십 세겔중의 금덩이 하나를 보고 탐내어 취하였나이다 보소서 ! 이제 그 물건들을 내 장막 가운데 땅 속에 감추었는데 은은 그 밑에 있나이다' ");
INSERT INTO kor_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","이에 여호수아가 사자를 보내매 그의 장막에 달려가 본즉 물건이 그의 장막 안에 감취었는데 은은 그 밑에 있는지라 ");
INSERT INTO kor_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","그들이 그것을 장막 가운데서 취하여 여호수아와 이스라엘 모든 자손에게로 가져오매 그들이 그것을 여호와 앞에 놓으니라 ");
INSERT INTO kor_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","여호수아가 이스라엘 모든 사람으로 더불어 세라의 아들 아간을 잡고 그 은과, 외투와, 금덩이와, 그 아들들과, 딸들과, 소들과, 나귀들과, 양들과, 장막과, 무릇 그에게 속한 모든 것을 이끌고 아골 골짜기로 가서 ");
INSERT INTO kor_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","여호수아가 가로되 `네가 어찌하여 우리를 괴롭게 하였느뇨 ? 여호와께서 오늘날 너를 괴롭게 하시리라'하니 온 이스라엘이 그를 돌로 치고 그것들도 돌로 치고 불사르고 ");
INSERT INTO kor_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","그 위에 돌 무더기를 크게 쌓았더니 오늘날까지 있더라 여호와께서 그 극렬한 분노를 그치시니 그러므로 그곳 이름을 오늘날까지 '아골 골짜기'라 부르더라 ");
INSERT INTO kor_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","여호와께서 여호수아에게 이르시되 두려워 말라 ! 놀라지 말라 ! 군사를 다 거느리고 일어나 아이로 올라가라 보라, 내가 아이 왕과, 그 백성과, 그 성읍과, 그 땅을 다 네 손에 주었노니 ");
INSERT INTO kor_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","너는 여리고와 그 왕에게 행한것 같이 아이와 그 왕에게 행하되오직 거기서 탈취할 물건과 가축은 스스로 취하라 너는 성 뒤에 복병할지니라 ");
INSERT INTO kor_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","이에 여호수아가 일어나서 군사와 함께 아이로 올라가려 하여 용사 삼만명을 뽑아 밤에 보내며 ");
INSERT INTO kor_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","그들에게 명하여 가로되 `너희는 성읍 뒤로 가서 성읍을 향하고 매복하되 그 성읍에 너무 멀리 하지말고 다 스스로 예비하라 ! ");
INSERT INTO kor_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","나와 나를 좇는 모든 백성은 다 성읍으로 가까이 가리니 그들이 처음과 같이 우리에게로 쳐 올라올 것이라 그리할 때에 우리가 그들 앞에서 도망하면 ");
INSERT INTO kor_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","그들이 나와서 우리를 따르며 스스로 이르기를 그들이 처음과 같이 우리 앞에서 도망한다 하고 우리의 유인을 받아 그 성읍에서 멀리 떠날 것이라 우리가 그 앞에서 도망하거든 ");
INSERT INTO kor_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","너희는 매복한 곳에서 일어나서 그 성읍을 점령하라 너희 하나님여호와께서 너희 손에 붙이시리라 ");
INSERT INTO kor_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","너희가 성읍을 취하거든 그것을 불살라 여호와의 말씀대로 행하라 보라, 내가 너희에게 명하였느니라' 하고 ");
INSERT INTO kor_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","그들을 보내매 그들이 복병할 곳으로 가서 아이 서편 벧엘과 아이 사이에 매복하였고 여호수아는 그 밤에 백성 가운데서 잤더라 ");
INSERT INTO kor_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","여호수아가 아침에 일찌기 일어나서 백성을 점고하고 이스라엘 장로들로 더불어 백성 앞서 아이로 올라가매 ");
INSERT INTO kor_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","그를 좇은 군사가 다 올라가서 성읍 앞에 가까이 이르러 아이 북편에 진치니 그와 아이 사이에는 한 골짜기가 있었더라 ");
INSERT INTO kor_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","그가 오천명 가량을 택하여 성읍 서편 벧엘과 아이 사이에 또 매복시키니 ");
INSERT INTO kor_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","이와 같이 성읍 북편에는 온 군대가 있고 성읍 서편에는 복병이 있었더라 여호수아가 그 밤에 골짜기 가운데로 들어가니 ");
INSERT INTO kor_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","아이 왕이 이를 보고 그 성읍 백성과 함께 일찌기 일어나서 급히 나가 아라바 앞에 이르러 정한 때에 이스라엘과 싸우려 하고 성읍 뒤에 복병이 있는 줄은 알지 못하였더라 ");
INSERT INTO kor_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","여호수아와 온 이스라엘이 그들 앞에서 거짓 패하여 광야 길로 도망하매 ");
INSERT INTO kor_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","그 성 모든 백성이 그들을 따르려고 모여서 여호수아를 따르며 유인함을 입어 성을 멀리 떠나니 ");
INSERT INTO kor_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","아이와 벧엘에 이스라엘을 따라가지 아니한 자가 하나도 없으며 성문을 열어 놓고 이스라엘을 따랐더라 ");
INSERT INTO kor_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","여호와께서 여호수아에게 이르시되 네 손에 잡은 단창을 들어 아이를 가리키라 ! 내가 이 성읍을 네 손에 주리라 여호수아가 그 손에 잡은 단창을 들어 성읍을 가리키니 ");
INSERT INTO kor_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","그 손을 드는 순간에 복병이 그 처소에서 급히 일어나 성읍에 달려 들어가서 점령하고 곧 성읍에 불을 놓았더라 ");
INSERT INTO kor_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","아이 사람이 뒤를 돌아본즉 그 성읍에 연기가 하늘에 닿은 것이 보이니 이 길로도 저 길로도 도망할 수 없이 되었고 광야로 도망하던 이스라엘 백성은 그 따르던 자에게로 돌이켰더라 ");
INSERT INTO kor_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","여호수아와 온 이스라엘이 그 복병이 성읍을 점령함과 성읍에 연기가 오름을 보고 다시 돌이켜 아이 사람을 죽이고 ");
INSERT INTO kor_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","복병도 성읍에서 나와 그들을 치매 그들이 이스라엘 중간에 든지라 혹은 이 편에서, 혹은 저 편에서 쳐 죽여서 한 사람도 남거나 도망하지 못하게 하였고 ");
INSERT INTO kor_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","아이 왕을 사로잡아 여호수아 앞으로 끌어 왔더라 ");
INSERT INTO kor_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","이스라엘이 자기를 광야로 따르던 아이 모든 거민을 들에서 죽이되 그들을 다 칼날에 엎드러지게 하여 진멸하기를 마치고 온 이스라엘이 아이로 돌아와서 칼날로 죽이매 ");
INSERT INTO kor_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","그 날에 아이 사람의 전부가 죽었으니 남녀가 일만 이천이라 ");
INSERT INTO kor_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","아이 거민을 진멸하기까지 여호수아가 단창을 잡아 든 손을 거두지 아니하였고 ");
INSERT INTO kor_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","오직 그 성읍의 가축과 노략한 것은 여호와께서 여호수아에게 명하신 대로 이스라엘이 탈취하였더라 ");
INSERT INTO kor_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","이에 여호수아가 아이를 불살라 그것으로 영원한 무더기를 만들었더니 오늘까지 황폐하였으며 ");
INSERT INTO kor_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","그가 또 아이 왕을 저녁 때까지 나무에 달았다가 해 질 때에 명하여 그 시체를 나무에서 내려 그 성문 어귀에 던지고 그 위에 돌로 큰 무더기를 쌓았더니 그것이 오늘까지 있더라 ");
INSERT INTO kor_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","때에 여호수아가 이스라엘의 하나님 여호와를 위하여 에발산에 한 단을 쌓았으니 ");
INSERT INTO kor_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","이는 여호와의 종 모세가 이스라엘 자손에게 명한것과 모세의 율법책에 기록된 대로 철 연장으로 다듬지 아니한 새 돌로 만든 단이라 무리가 여호와께 번제와 화목제를 그 위에 드렸으며 ");
INSERT INTO kor_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","여호수아가 거기서 모세의 기록한 율법을 이스라엘 자손의 목전에서 그 돌에 기록하매 ");
INSERT INTO kor_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","온 이스라엘과 그 장로들과 유사들과 재판장들과 본토인 뿐 아니라 이방인까지 여호와의 언약궤를 멘 레위 사람 제사장들 앞에서 궤의 좌우에 서되 절반은 그리심산 앞에, 절반은 에발산 앞에 섰으니 이는 이왕에 여호와의 종 모세가 이스라엘 백성에게 축복하라고 명한 대로 함이라 ");
INSERT INTO kor_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","그 후에 여호수아가 무릇 율법책에 기록된 대로 축복과 저주하는 율법의 모든 말씀을 낭독하였으니 ");
INSERT INTO kor_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","모세의 명한 것은 여호수아가 이스라엘 온 회중과 여인과 아이와 그들 중에 동거하는 객들 앞에 낭독하지 아니한 말이 하나도 없었더라 ");
INSERT INTO kor_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","요단 서편 산지와 평지와 레바논 앞 대 해변에 있는 헷 사람과, 아모리 사람과, 가나안 사람과, 브리스 사람과, 히위 사람과, 여부스 사람의 모든 왕이 이 일을 듣고 ");
INSERT INTO kor_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","모여서 일심으로 여호수아와 이스라엘로 더불어 싸우려 하더라 ");
INSERT INTO kor_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","기브온 거민들이 여호수아의 여리고와 아이에 행한 일을 듣고 ");
INSERT INTO kor_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","꾀를 내어 사신의 모양을 꾸미되 해어진 전대와 해어지고 찢어져서 기운 가죽 포도주 부대를 나귀에 싣고 ");
INSERT INTO kor_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","그 발에는 낡아 기운 신을 신고 낡은 옷을 입고 다 마르고 곰팡이 난 떡을 예비하고 ");
INSERT INTO kor_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","그들이 길갈 진으로 와서 여호수아에게 이르러 그와 이스라엘 사람들에게 이르되 `우리는 원방에서 왔나이다 이제 우리와 약조하사이다' ");
INSERT INTO kor_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","이스라엘 사람들이 히위 사람들에게 이르되 `너희가 우리 중에 거하는 듯하니 우리가 어떻게 너희와 약조할 수 있으랴' ");
INSERT INTO kor_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","그들이 여호수아에게 이르되 `우리는 당신의 종이니이다' 여호수아가 그들에게 묻되 `너희는 누구며 어디서 왔느뇨 ?' ");
INSERT INTO kor_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","그들이 여호수아에게 대답하되 `종들은 당신의 하나님 여호와의 이름을 인하여 심히 먼 지방에서 왔사오니 이는 우리가 그의 명성과 그가 애굽에서 행하신 모든 일을 들으며 ");
INSERT INTO kor_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","또 그가 요단 동편에 있는 아모리 사람의 두 왕 곧 헤스본 왕 시혼과 아스다롯에 있는 바산 왕 옥에게 행하신 모든 일을 들었음이니이다 ");
INSERT INTO kor_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","그러므로 우리 장로들과 우리 나라의 모든 거민이 우리에게 일러 가로되 너희는 여행할 양식을 손에 가지고 가서 그들을 맞아서 그들에게 이르기를 우리는 당신들의 종이니 청컨대 이제 우리와 약조하사이다 하라 하였나이다 ");
INSERT INTO kor_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","우리의 이 떡은 우리가 당신들에게로 오려고 떠나던 날에 우리들의 집에서 오히려 뜨거운 것을 양식으로 취하였더니 보소서 이제 말랐고 곰팡이 났으며 ");
INSERT INTO kor_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","또 우리가 포도주를 담은 이 가죽 부대도 새 것이더니 찢어지게 되었으며 우리의 이 옷과 신도 여행이 심히 길므로 인하여 낡아졌나이다' 한지라 ");
INSERT INTO kor_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","무리가 그들의 양식을 취하고 어떻게 할 것을 여호와께 묻지 아니하고 ");
INSERT INTO kor_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","여호수아가 곧 그들과 화친하여 그들을 살리리라는 언약을 맺고 회중 족장들이 그들에게 맹세하였더라 ");
INSERT INTO kor_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","그들과 언약을 맺은 후 삼일이 지나서야 그들은 근린에 있어 자기들 중에 거주하는 자라 함을 들으니라 ");
INSERT INTO kor_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","이스라엘 자손이 진행하여 제 삼일에 그들의 여러 성읍에 이르렀으니 그 성읍은 기브온과, 그비라와, 브에롯과, 기럇여아림이라 ");
INSERT INTO kor_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","그러나 회중 족장들이 이스라엘 하나님 여호와로 그들에게 맹세한 고로 이스라엘 자손이 그들을 치지 못한지라 그러므로 회중이 다 족장들을 원망하니 ");
INSERT INTO kor_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","모든 족장이 온 회중에게 이르되 `우리가 이스라엘 하나님 여호와로 그들에게 맹세하였은즉 이제 그들을 건드리지 못하리라 ");
INSERT INTO kor_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","우리가 그들에게 맹세한 맹약을 인하여 진노가 우리에게 임할까 하노니 이렇게 행하여 그들을 살리리라' 하고 ");
INSERT INTO kor_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","무리에게 이르되 그들을 살리라 하니 족장들이 그들에게 이른대로 그들이 온 회중을 위하여 나무 패며 물 긷는 자가 되었더라 ");
INSERT INTO kor_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","여호수아가 그들을 불러다가 일러 가로되 `너희가 우리 가운데 거주하거늘 어찌하여 우리는 너희에게서 심히 멀다 하여 우리를 속였느냐 ? ");
INSERT INTO kor_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","그러므로 너희가 저주를 받나니 너희가 영영히 종이 되어서 다 내 하나님의 집을 위하여 나무 패며 물 긷는 자가 되리라' ");
INSERT INTO kor_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","그들이 여호수아에게 대답하여 가로되 `당신의 하나님 여호와께서 그 종 모세에게 명하사 이 땅을 다 당신들에게 주고 이 땅 모든 거민을 당신들의 앞에서 멸하라 하신 것이 당신의 종에게 분명히 들리므로 당신들을 인하여 우리 생명을 잃을까 심히 두려워 하여 이같이 하였나이다 ");
INSERT INTO kor_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","보소서 ! 이제 우리가 당신의 손에 있으니 당신의 의향에 좋고 옳은대로 우리에게 행하소서' 한지라 ");
INSERT INTO kor_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","여호수아가 곧 그대로 그들에게 행하여 그들을 이스라엘 자손의 손에서 건져서 죽이지 못하게 하니라 ");
INSERT INTO kor_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","그 날에 여호수아가 그들로 여호와의 택하신 곳에서 회중을 위하며 여호와의 단을 위하여 나무 패며 물 긷는 자를 삼았더니 오늘까지 이르니라 ");
INSERT INTO kor_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","여호수아가 아이를 취하여 진멸하되 여리고와 그 왕에게 행한 것같이 아이와 그 왕에게 행한 것과 또 기브온 거민이 이스라엘과 화친하여 그 중에 있다함을 예루살렘 왕 아도니세덱이 듣고 ");
INSERT INTO kor_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","크게 두려워하였으니 이는 기브온은 왕도와 같은 큰 성임이요 아이보다 크고 그 사람들은 다 강함이라 ");
INSERT INTO kor_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","예루살렘 왕 아도니세덱이 헤브론 왕 호함과 야르뭇 왕 비람과 라기스 왕 야비아와 에글론 왕 드빌에게 보내어 가로되 ");
INSERT INTO kor_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","`내게로 올라와 나를 도우라 우리가 기브온을 치자 이는 기브온이 여호수아와 이스라엘 자손으로 더불어 화친하였음이니라' 하매 ");
INSERT INTO kor_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","여호수아가 모든 군사와 용사로 더불어 길갈에서 올라가니라 ");
INSERT INTO kor_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","때에 여호와께서 여호수아에게 이르시되 그들을 두려워 말라 ! 내가 그들을 네 손에 붙였으니 그들의 한 사람도 너를 당할 자 없 으리라 하신지라 ");
INSERT INTO kor_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","여호수아가 길갈에서 밤새도록 올라가서 그들에게 갑자기 이르니 ");
INSERT INTO kor_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","여호와께서 그들을 이스라엘 앞에서 패하게 하시므로 여호수아가 그들을 기브온에서 크게 도륙하고 벧호론에 올라가는 비탈에서 추격하여 아세가와 막게다까지 이르니라 ");
INSERT INTO kor_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","그들이 이스라엘 앞에서 도망하여 벧호론의 비탈에서 내려갈 때에 여호와께서 하늘에서 큰 덩이 우박을 아세가에 이르기까지 내리우시매 그들이 죽었으니 이스라엘 자손의 칼에 죽은 자보다 우박에 죽은 자가 더욱 많았더라 ");
INSERT INTO kor_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","여호와께서 아모리 사람을 이스라엘 자손에게 붙이시던 날에 여호수아가 여호와께 고하되 이스라엘 목전에서 가로되 '태양아 ! 너는 기브온 위에 머무르라 ! 달아 ! 너도 아얄론 골짜기에 그리할지어다 !' 하매 ");
INSERT INTO kor_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","태양이 머물고 달이 그치기를 백성이 그 대적에게 원수를 갚도록 하였느니라 야살의 책에 기록되기를 태양이 중천에 머물러서 거의 종일토록 속히 내려가지 아니하였다 하지 아니하였느냐 ");
INSERT INTO kor_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","여호와께서 사람의 목소리를 들으신 이 같은 날은 전에도 없었고 후에도 없었나니 이는 여호와께서 이스라엘을 위하여 싸우셨음이니라 ");
INSERT INTO kor_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","여호수아가 온 이스라엘로 더불어 길갈 진으로 돌아왔더라 ");
INSERT INTO kor_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","그 다섯 왕이 도망하여 막게다의 굴에 숨었더니 ");
INSERT INTO kor_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","혹이 여호수아에게 고하여 가로되 `막게다의 굴에 그 다섯 왕의 숨은 것을 발견하였나이다' ");
INSERT INTO kor_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","여호수아가 가로되 `굴 어귀에 큰 돌을 굴려 막고 사람을 그 곁에 두어 그들을 지키게 하고 ");
INSERT INTO kor_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","너희는 지체 말고 너희 대적의 뒤를 따라가 그 후군을 쳐서 그들로 자기들의 성읍에 들어가지 못하게 하라 너희 하나님 여호와께서 그들을 너희 손에 붙이셨느니라' 하고 ");
INSERT INTO kor_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","여호수아와 이스라엘 자손이 그들을 크게 도륙하여 거의 진멸시켰고 그 남은 몇 사람은 견고한 성으로 들어가므로 ");
INSERT INTO kor_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","모든 백성이 평안히 막게다 진으로 돌아와 여호수아에게 이르렀으나 혀를 놀려 이스라엘 자손을 대적하는 자가 없었더라 ");
INSERT INTO kor_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","때에 여호수아가 가로되 `굴 어귀를 열고 그 굴에서 그 다섯 왕을 내게로 끌어내라' 하매 ");
INSERT INTO kor_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","그들이 그대로 하여 그 다섯 왕 곧 예루살렘 왕과, 헤브론 왕과, 야르뭇 왕과, 라기스 왕과, 에글론 왕을 굴에서 그에게로 끌어내니라 ");
INSERT INTO kor_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","그 왕들을 여호수아에게로 끌어내매 여호수아가 이스라엘 모든 사람을 부르고 자기와 함께 갔던 군장들에게 이르되 '가까이 와서 이 왕들의 목을 발로 밟으라' 가까이 와서 그들의 목을 밟으매 ");
INSERT INTO kor_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","여호수아가 군장들에게 이르되 `두려워 말며 놀라지 말고 마음을 강하게 하고 담대히 하라 ! 너희가 더불어 싸우는 모든 대적에게 여호와께서 다 이와 같이 하시리라' 하고 ");
INSERT INTO kor_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","그 후에 여호수아가 그 왕들을 쳐 죽여 다섯 나무에 매어 달고 석양까지 나무에 달린대로 두었다가 ");
INSERT INTO kor_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","해 질 때에 여호수아가 명하매 그 시체를 나무에서 내리어 그들의 숨었던 굴에 들여 던지고 굴 어귀를 큰 돌로 막았더니 오늘날까지 있더라 ");
INSERT INTO kor_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","그 날에 여호수아가 막게다를 취하고 칼날로 그 성읍과 왕을 쳐서 그 성읍과 그 중에 있는 모든 사람을 진멸하여 한 사람도 남기지 아니하였으니 막게다 왕에게 행한 것이 여리고 왕에게 행한 것과 일반이었더라 ");
INSERT INTO kor_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","여호수아가 온 이스라엘로 더불어 막게다에서 립나로 나아가서 립나와 싸우매 ");
INSERT INTO kor_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","여호와께서 또 그 성읍과 그 왕을 이스라엘의 손에 붙이신지라 칼날로 그 성읍과 그 중의 모든 사람을 쳐서 멸하여 한 사람도 남기지 아니하였으니 그 왕에게 행한 것이 여리고 왕에게 행한 것과 일반이었더라 ");
INSERT INTO kor_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","여호수아가 또 온 이스라엘로 더불어 립나에서 라기스로 나아가서 대진하고 싸우더니 ");
INSERT INTO kor_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","여호와께서 라기스를 이스라엘의 손에 붙이신지라 이튿날에 그 성읍을 취하고 칼날로 그것과 그 중의 모든 사람을 쳐서 멸하였으니 립나에 행한 것과 일반이었더라 ");
INSERT INTO kor_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","때에 게셀 왕 호람이 라기스를 도우려고 올라오므로 여호수아가 그와 그 백성을 쳐서 한 사람도 남기지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","여호수아가 온 이스라엘로 더불어 라기스에서 에글론으로 나아가서 대진하고 싸워 ");
INSERT INTO kor_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","그 날에 그 성읍을 취하고 칼날로 그것을 쳐서 그 중에 있는 모든 사람을 당일에 진멸하였으니 라기스에 행한 것과 일반이었더라 ");
INSERT INTO kor_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","여호수아가 또 온 이스라엘로 더불어 에글론에서 헤브론으로 올라가서 싸워 ");
INSERT INTO kor_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","그 성읍을 취하고 그것과 그 왕과 그 속한 성읍들과 그 중의 모든 사람을 칼날로 쳐서 하나도 남기지 아니하였으니 그 성읍과 그 중의 모든 사람을 진멸한 것이 에글론에 행한 것과 일반이었더라 ");
INSERT INTO kor_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","여호수아가 온 이스라엘로 더불어 돌아와서 드빌에 이르러 싸워 ");
INSERT INTO kor_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","그 성읍과 그 왕과 그 속한 성읍들을 취하고 칼날로 그 성읍을 쳐서 그 중의 모든 사람을 진멸하고 하나도 남기지 아니하였으니 드빌과 그 왕에게 행한 것이 헤브론에 행한 것과 일반이요 립나와 그 왕에게 행한 것과 일반이었더라 ");
INSERT INTO kor_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","이와 같이 여호수아가 온 땅 곧 산지와 남방과 평지와 경사지와 그 모든 왕을 쳐서 하나도 남기지 아니하고 무릇 호흡이 있는 자는 진멸하였으니 이스라엘의 하나님 여호와의 명하신 것과 같았더라 ");
INSERT INTO kor_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","여호수아가 또 가데스 바네아에서 가사까지와 온 고센 땅을 기브온에 이르기까지 치매 ");
INSERT INTO kor_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","이스라엘의 하나님 여호와께서 이스라엘을 위하여 싸우신고로 여호수아가 이 모든 왕과 그 땅을 단번에 취하니라 ");
INSERT INTO kor_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","여호수아가 온 이스라엘로 더불어 길갈 진으로 돌아왔더라 ");
INSERT INTO kor_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","하솔 왕 야빈이 이 소식을 듣고 마돈왕 요밥과, 시므론 왕과, 악삽 왕과, ");
INSERT INTO kor_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","및 북방 산지와, 긴네롯 남편 아라바와, 평지와, 서방 돌의 높은 곳에 있는 왕들과, ");
INSERT INTO kor_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","동서편 가나안 사람과, 아모리 사람과, 헷 사람과, 브리스 사람과, 산지의 여부스 사람과, 미스바 땅 헤르몬산 아래 히위 사람들에게 사람을 보내매 ");
INSERT INTO kor_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","그들이 그 모든 군대를 거느리고 나왔으니 민중이 많아 해변의 수다한 모래 같고 말과 병거도 심히 많았으며 ");
INSERT INTO kor_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","이 왕들이 모여 나아와서 이스라엘과 싸우려고 메롬 물가에 함께 진 쳤더라 ");
INSERT INTO kor_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","여호와께서 여호수아에게 이르시되 그들을 인하여 두려워 말라 ! 내일 이맘 때에 내가 그들을 이스라엘 앞에 붙여 몰살시키리니 너는 그들의 말 뒷발의 힘줄을 끊고 불로 그 병거를 사르라 ");
INSERT INTO kor_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","이에 여호수아가 모든 군사와 함께 메롬 물가로 가서 졸지에 습격할 때에 ");
INSERT INTO kor_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","여호와께서 그들을 이스라엘의 손에 붙이신 고로 그들을 격파하고 큰 시돈과 미스르봇 마임까지 쫓고 동편에서는 미스바 골짜기까지 쫓아가서 한 사람도 남기지 아니하고 쳐 죽이고 ");
INSERT INTO kor_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","여호수아가 여호와께서 자기에게 명하신 대로 행하여 그들의 말뒷발의 힘줄을 끊고 불로 그 병거를 살랐더라 ");
INSERT INTO kor_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","하솔은 본래 그 모든 나라의 머리였더니 그 때에 여호수아가 돌아와서 하솔을 취하고 그 왕을 칼날로 쳐 죽이고 ");
INSERT INTO kor_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","그 가운데 모든 사람을 칼날로 쳐서 진멸하여 호흡이 있는 자는 하나도 남기지 아니하였고 또 불로 하솔을 살랐으며 ");
INSERT INTO kor_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","여호수아가 그 왕들의 모든 성읍과 그 모든 왕을 취하여 칼날로 쳐서 진멸하여 여호와의 종 모세의 명한 것과 같이 하였으되 ");
INSERT INTO kor_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","여호수아가 하솔만 불살랐고 산 위에 건축된 성읍들은 이스라엘이 불사르지 아니하였으며 ");
INSERT INTO kor_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","이 성읍들의 모든 재물과 가축은 이스라엘 자손들이 탈취하고 모든 사람은 칼날로 쳐서 진멸하여 호흡이 있는 자는 하나도 남기지 아니하였으니 ");
INSERT INTO kor_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","여호와께서 그 종 모세에게 명하신 것을 모세는 여호수아에게 명하였고 여호수아는 그대로 행하여 여호와께서 무릇 모세에게 명하신 것을 하나도 행치 아니한 것이 없었더라 ");
INSERT INTO kor_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","여호수아가 이같이 그 온 땅 곧 산지와 온 남방과 고센 온 땅과 평지와 아라바와 이스라엘의 산지와 그 평지를 취하였으니 ");
INSERT INTO kor_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","곧 세일로 올라가는 할락산에서부터 헤르몬산 아래 레바논 골짜기의 바알갓까지라 그 모든 왕을 잡아 쳐죽였으며 ");
INSERT INTO kor_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","여호수아가 그 모든 왕과 싸운 지는 여러 날이라 ");
INSERT INTO kor_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","기브온 거민 히위 사람 외에는 이스라엘 자손과 화친한 성읍이 하나도 없고 다 이스라엘 자손에게 쳐서 취한 바 되었으니 ");
INSERT INTO kor_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","그들의 마음이 강퍅하여 이스라엘을 대적하여 싸우러 온 것은 여호와께서 그리하게 하신 것이라 그들로 저주받은 자 되게 하여 은혜를 입지 못하게 하시고 여호와께서 모세에게 명하신 대로 진멸하려 하심이었더라 ");
INSERT INTO kor_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","그 때에 여호수아가 가서 산지와 헤브론과 드빌과 아납과 유다 온 산지와 이스라엘의 온 산지에서 아낙 사람을 멸절하고 그가 또 그 성읍들을 진멸하였으므로 ");
INSERT INTO kor_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","이스라엘 자손의 땅 안에는 아낙 사람이 하나도 남음이 없고 가사와 가드와 아스돗에만 약간 남았었더라 ");
INSERT INTO kor_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","이와 같이 여호수아가 여호와께서 모세에게 이르신 말씀대로 그 온 땅을 취하여 이스라엘 지파의 구별을 따라 기업으로 주었더라 그 땅에 전쟁이 그쳤더라 ");
INSERT INTO kor_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","이스라엘 자손이 요단 저편 해 돋는 편 곧 아르논 골짜기에서 헤르몬산까지의 동방 온 아라바를 점령하고 그 땅에서 쳐 죽인 왕들은 이러하니라 ");
INSERT INTO kor_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","헤스본에 거하던 아모리 사람의 왕 시혼이라 그 다스리던 땅은 아르논 골짜기 가에 있는 아로엘에서부터 골짜기 가운데 성읍과 길르앗 절반 곧 암몬 자손의 지경 얍복강까지며 ");
INSERT INTO kor_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","또 동방 아라바 긴네롯 바다까지며 또 동방 아라바의 바다 곧 염해의 벧여시못으로 통한 길까지와 남편으로 비스가 산록까지며 ");
INSERT INTO kor_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","또 르바의 남은 족속으로서 아스다롯과 에브레이에 거하던 바산 왕 옥이라 ");
INSERT INTO kor_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","그 치리하던 땅은 헤르몬산과 살르가와 온 바산과 및 그술 사람과 마아가 사람의 지경까지의 길르앗 절반이니 헤스본 왕 시혼의 지경에 접한 것이라 ");
INSERT INTO kor_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","여호와의 종 모세와 이스라엘 자손이 그들을 치고 여호와의 종 모세가 그 땅을 르우벤 사람과, 갓 사람과, 므낫세 반 지파에게 기업으로 주었더라 ");
INSERT INTO kor_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","여호수아와 이스라엘 자손이 요단 이편 곧 서편 레바논 골짜기의 바알갓에서부터 세일로 올라가는 곳 할락산까지에서 쳐서 멸한 왕들은 이러하니 그 땅을 여호수아가 이스라엘의 구별을 따라 그 지파에게 기업으로 주었으니 ");
INSERT INTO kor_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","곧 산지와, 평지와, 아라바와, 경사지와, 광야와, 남방 곧 헷 사람과, 아모리 사람과, 가나안 사람과, 브리스 사람과, 히위 사람과, 여부스사람의 땅이라) ");
INSERT INTO kor_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","하나는 여리고 왕이요, 하나는 벧엘 곁의 아이 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","하나는 예루살렘 왕이요, 하나는 헤브론 왕이요, 하나는 야르뭇 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","하나는 라기스 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","하나는 에글론 왕이요, 하나는 게셀 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","하나는 드빌 왕이요, 하나는 게델 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","하나는 호르마 왕이요, 하나는 아랏 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","하나는 립나 왕이요, 하나는 아둘람 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","하나는 막게다 왕이요, 하나는 벧엘 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","하나는 답부아 왕이요, 하나는 헤벨 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","하나는 아벡 왕이요, 하나는 랏사론 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","하나는 마돈 왕이요, 하나는 하솔 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","하나는 시므론 므론 왕이요, 하나는 악삽 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","하나는 다아낙 왕이요, 하나는 므깃도 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","하나는 게데스 왕이요, 하나는 갈멜의 욕느암 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","하나는 돌의 높은 곳의 돌 왕이요, 하나는 길갈의 고임 왕이요 ");
INSERT INTO kor_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","하나는 디르사 왕이라 도합 삼십 일 왕이었더라 ");
INSERT INTO kor_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","여호수아가 나이 많아 늙으매 여호와께서 그에게 이르시되 너는 나이 많아 늙었고 얻을 땅의 남은 것은 매우 많도다 ");
INSERT INTO kor_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","이 남은 땅은 이러하니 블레셋 사람의 온 지방과 그술 사람의 전경 ");
INSERT INTO kor_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","곧 애굽 앞 시홀 시내에서부터 가나안 사람에게 속한 북방 에그론 지경까지와 블레셋 사람의 다섯 방백의 땅 곧 가사 사람과, 아스돗 사람과, 아스글론 사람과, 가드 사람과, 에그론 사람과, 또 남방 아위 사람의 땅과, ");
INSERT INTO kor_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","또 가나안 사람의 온 땅과, 시돈 사람에게 속한 므아라와, 아모리 사람의 지경 아벡까지와 ");
INSERT INTO kor_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","또 그발 사람의 땅과 동편 온 레바논 곧 헤르몬 산 아래 바알갓에서부터 하맛에 들어가는 곳까지와 ");
INSERT INTO kor_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","또 레바논에서부터 미스르봇마임까지의 산지 모든 거민 곧 모든 시돈 사람의 땅이라 내가 그들을 이스라엘 자손 앞에서 쫓아 내리니 너는 나의 명한 대로 그 땅을 이스라엘에게 분배하여 기업이 되게 하되 ");
INSERT INTO kor_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","너는 이 땅을 아홉 지파와 므낫세 반 지파에게 나누어 기업이 되게 하라 하셨더라 ");
INSERT INTO kor_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","므낫세 반 지파와 함께 르우벤 사람과 갓 사람은 요단 동편에서 그 기업을 모세에게 받았는데 여호와의 종 모세가 그들에게 준 것은 이러하니 ");
INSERT INTO kor_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","곧 아르논 골짜기 가에 있는 아로엘에서부터 골짜기 가운데 있는 성읍과 디본까지 이르는 메드바 온 평지와 ");
INSERT INTO kor_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","헤스본에 도읍하였던 아모리 사람의 왕 시혼의 모든 성읍 곧 암몬 자손의 지경까지와 ");
INSERT INTO kor_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","길르앗과 및 그술 사람과 마아갓 사람의 지경과 온 헤르몬산과 살르가까지 이른 온 바산 ");
INSERT INTO kor_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","곧 르바의 남은 족속으로서 아스다롯과 에드레이에 도읍하였던 바산 왕 옥의 온 나라라 모세가 이 땅의 사람들을 쳐서 쫓아내었어도 ");
INSERT INTO kor_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","그술 사람과 마아갓 사람은 이스라엘 자손이 쫓아내지 아니하였으므로 그술과 마아갓이 오늘날까지 이스라엘 가운데 거하더라 ");
INSERT INTO kor_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","오직 레위 지파에게는 여호수아가 기업으로 준 것이 없었으니 이는 이스라엘 하나님 여호와께 드리는 화제물이 그 기업이 됨이 그에게 이르신 말씀과 같음이었더라 ");
INSERT INTO kor_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","모세가 르우벤 자손의 지파에게 그 가족을 따라서 주었으니 ");
INSERT INTO kor_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","그 지경은 아르논 골짜기 가에 있는 아로엘에서부터 골짜기 가운데 있는 성읍과 메드바 곁에 있는 온 평지와 ");
INSERT INTO kor_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","헤스본과 그 평지에 있는 모든 성읍 곧 디본과, 바못 바알과, 벧 바알 므온과, ");
INSERT INTO kor_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","야하스와, 그데못과, 메바앗과, ");
INSERT INTO kor_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","기랴다임과, 십마와, 골짜기 가운데 산에 있는 세렛 사할과, ");
INSERT INTO kor_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","벧브올과, 비스가 산록과, 벧여시못과, ");
INSERT INTO kor_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","평지 모든 성읍과, 헤스본에 도읍한 아모리 사람 시혼의 온 나라라 모세가 시혼을 그 땅에 거하는 시혼의 방백 곧 미디안의 귀족 에위와, 레겜과, 술과, 훌과, 레바와 함께 죽였으며 ");
INSERT INTO kor_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","이스라엘 자손이 그들을 도륙하는 중에 브올의 아들 술사 발람도 칼날로 죽였었더라 ");
INSERT INTO kor_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","르우벤 자손의 서편 경계는 요단과 그 강 가라 이상은 르우벤 자손의 기업으로 그 가족대로 받은 성읍과 촌락이니라 ");
INSERT INTO kor_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","모세가 갓 지파 곧 갓 자손에게도 그 가족을 따라서 주었으니 ");
INSERT INTO kor_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","그 지경은 야셀과 길르앗 모든 성읍과 암몬 자손의 땅 절반 곧 랍바 앞의 아로엘까지와 ");
INSERT INTO kor_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","헤스본에서 라맛 미스베와 브도님까지와 마하나임에서 드빌 지경까지와 ");
INSERT INTO kor_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","골짜기에 있는 벧 하람과, 벧니므라와, 숙곳과, 사본 곧 헤스본 왕 시혼의 나라의 남은 땅 요단과 그 강 가에서부터 요단 동편 긴네렛 바다의 끝까지라 ");
INSERT INTO kor_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","이는 갓 자손의 기업으로 그 가족대로 받은 성읍과 촌락이니라 ");
INSERT INTO kor_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","모세가 므낫세 반 지파에게 주었으되 므낫세 자손의 반 지파에게 그 가족대로 주었으니 ");
INSERT INTO kor_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","그 지경은 마하나임에서부터 온 바산 곧 바산 왕 옥의 전국과 바산 경내 야일의 모든 고을 육십 성읍과 ");
INSERT INTO kor_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","길르앗 절반과 바산 왕 옥의 나라 성읍 아스다롯과 에드레이라 이는 므낫세의 아들 마길의 자손에게 돌린 것이니 곧 마길 자손의 절반이 그 가족대로 받으니라 ");
INSERT INTO kor_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","요단 동편 여리고 맞은편 모압 평지에서 모세가 분배한 기업이 이러하여도 ");
INSERT INTO kor_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","오직 레위 지파에게는 모세가 기업을 주지 아니하였으니 이는 그들에게 말씀하심 같이 이스라엘 하나님 여호와께서 그 기업이 되심이었더라 ");
INSERT INTO kor_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","이스라엘 자손이 가나안 땅에서 취한 기업 곧 제사장 엘르아살과 눈의 아들 여호수아와 이스라엘 자손 지파의 족장들이 분배한 것이 아래와 같으니라 ");
INSERT INTO kor_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","여호와께서 모세에게 명하신 대로 그들의 기업을 제비 뽑아 아홉지파와 반 지파에게 주었으니 ");
INSERT INTO kor_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","두 지파와 반 지파의 기업은 모세가 요단 저편에서 주었음이요 레위 자손에게는 그들 가운데서 기업을 주지 아니하였으니 ");
INSERT INTO kor_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","요셉 자손은 므낫세와 에브라임의 두 지파가 되었음이라 이 땅에서 레위 사람에게 아무 분깃도 주지 아니하고 오직 거할 성읍들과 가축과 재물을 둘 들만 줄 뿐으로 ");
INSERT INTO kor_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","이스라엘 자손이 여호와께서 모세에게 명하신 것과 같이 행하여 그 땅을 나누었더라 ");
INSERT INTO kor_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","때에 유다 자손이 길갈에 있는 여호수아에게 나아오고 그니스 사람 여분네의 아들 갈렙이 여호수아에게 말하되 '여호와께서 가데스 바네아에서 나와 당신에게 대하여 하나님의 사람 모세에게 이르신 일을 당신이 아시는 바라 ");
INSERT INTO kor_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","내 나이 사십세에 여호와의 종 모세가 가데스바네아에서 나를 보내어 이 땅을 정탐케 하므로 내 마음에 성실한 대로 그에게 보고하였고 ");
INSERT INTO kor_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","나와 함께 올라갔던 내 형제들은 백성의 간담을 녹게 하였으나 나는 나의 하나님 여호와를 온전히 좇았으므로 ");
INSERT INTO kor_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","그 날에 모세가 맹세하여 가로되 네가 나의 하나님 여호와를 온전히 좇았은즉 네 발로 밟는 땅은 영영히 너와 네 자손의 기업이 되리라 하였나이다 ");
INSERT INTO kor_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","이제 보소서 여호와께서 이 말씀을 모세에게 이르신 때로부터 이스라엘이 광야에 행한 이 사십 오년 동안을 여호와께서 말씀하신대로 나를 생존케 하셨나이다 오늘날 내가 팔십 오세로되 ");
INSERT INTO kor_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","모세가 나를 보내던 날과 같이 오늘날 오히려 강건하니 나의 힘이 그때나 이제나 일반이라 싸움에나 출입에 감당할 수 있사온즉 ");
INSERT INTO kor_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","그 날에 여호와께서 말씀하신 이 산지를 내게 주소서 당신도 그 날에 들으셨거니와 그 곳에는 아낙 사람이 있고 그 성읍들은 크고 견고할지라도 여호와께서 혹시 나와 함께 하시면 내가 필경 여호와의 말씀하신대로 그들을 쫓아내리이다' ");
INSERT INTO kor_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","여호수아가 여분네의 아들 갈렙을 위하여 축복하고 헤브론을 그에게 주어 기업을 삼게 하매 ");
INSERT INTO kor_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","헤브론이 그니스 사람 여분네의 아들 갈렙의 기업이 되어 오늘날까지 이르렀으니 이는 그가 이스라엘의 하나님 여호와를 온전히 좇았음이며 ");
INSERT INTO kor_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","헤브론의 옛 이름은 기럇 아르바라 아르바는 아낙 사람 가운데 가장 큰 사람이었더라 그 땅에 전쟁이 그쳤더라 ");
INSERT INTO kor_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","유다 자손의 지파가 그 가족대로 제비 뽑은 땅의 극남단은 에돔 지경에 이르고 또 남으로 신 광야까지라 ");
INSERT INTO kor_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","그 남편 경계는 염해의 극단 곧 남향한 해만에서부터 ");
INSERT INTO kor_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","아그랍빔 비탈 남편으로 지나 신에 이르고 가데스 바네아 남편으로 올라가서 헤스론을 지나며 앗달도 올라가서 돌이켜 갈가에 이르고 ");
INSERT INTO kor_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","거기서 아스몬에 이르고 애굽 시내에 미치며 바다에 이르러 경계의 끝이 되나니 이것이 너희 남편 경계가 되리라 ");
INSERT INTO kor_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","그 동편 경계는 염해니 요단 끝까지요 그 북편 경계는 요단 끝에 당한 해만에서부터 ");
INSERT INTO kor_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","벧호글라로 올라가서 벧 아라바 북편을 지나 르우벤 자손 보한의 돌에 이르고 ");
INSERT INTO kor_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","또 아골 골짜기에서부터 드빌을 지나 북으로 올라가서 강 남편에 있는 아둠빔 비탈 맞은편 길갈을 향하고 나아가 엔 세메스 물을 지나 엔로겔에 이르며 ");
INSERT INTO kor_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","또 힌놈의 아들의 골짜기로 올라가서 여부스 곧 예루살렘 남편 어깨에 이르며 또 힌놈의 골짜기 앞 서편에 있는 산 꼭대기로 올라가나니 이 곳은 르바임 골짜기 북편 끝이며 ");
INSERT INTO kor_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","또 이 산꼭대기에서부터 넵도아 샘물까지 이르러 에브론산 성읍들에 미치고 또 바알라 곧 기럇 여아림에 미치며 ");
INSERT INTO kor_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","또 바알라에서부터 서편으로 돌이켜 세일산에 이르러 여아림산 곧 그살론 곁 북편에 이르고 또 벧 세메스로 내려가서 딤나로 지나고 ");
INSERT INTO kor_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","또 에그론 북편으로 나아가 식그론에 이르러 바알라산에 미치고 얍느엘에 이르나니 그 끝은 바다며 ");
INSERT INTO kor_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","서편 경계는 대해와 그 해변이니 유다 자손이 그 가족대로 얻은 사면 경계가 이러하니라 ");
INSERT INTO kor_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","여호와께서 여호수아에게 명하신 대로 여호수아가 기럇 아르바 곧 헤브론 성을 유다 자손중에서 분깃으로 여분네의 아들 갈렙에게 주었으니 아르바는 아낙의 아비였더라 ");
INSERT INTO kor_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","갈렙이 거기서 아낙의 소생 곧 그 세 아들 세새와 아히만과 달매를 쫓아내었고 ");
INSERT INTO kor_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","거기서 올라가서 드빌 거민을 쳤는데 드빌의 본 이름은 기럇 세벨이라 ");
INSERT INTO kor_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","갈렙의 아우요 그나스의 아들인 옷니엘이 그것을 취함으로 갈렙이 그 딸 악사를 그에게 아내로 주었더라 ");
INSERT INTO kor_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","악사가 출가할 때에 그에게 청하여 `자기 아비에게 밭을 구하자' 하고 나귀에서 내리매 갈렙이 그에게 묻되 `네가 무엇을 원하느냐 ?' ");
INSERT INTO kor_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","가로되 `내게 복을 주소서 ! 아버지께서 나를 남방 땅으로 보내시오니 샘물도 내게 주소서' 하매 갈렙이 윗 샘과 아랫 샘을 그에게 주었더라 ");
INSERT INTO kor_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","유다 자손의 지파가 그 가족대로 얻은 기업은 이러하니라 ");
INSERT INTO kor_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","유다 자손의 지파의 남으로 에돔 경계에 접근한 성읍들은 갑스엘과, 에델과, 야굴과, ");
INSERT INTO kor_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","기나와, 디모나와, 아다다와, ");
INSERT INTO kor_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","게데스와, 하솔과, 잇난과, ");
INSERT INTO kor_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","십과, 델렘과, 브알롯과, ");
INSERT INTO kor_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","하솔 하닷다와, 그리욧 헤스론 곧 하솔과, ");
INSERT INTO kor_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","아맘과, 세마와, 몰라다와, ");
INSERT INTO kor_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","하살 갓다와, 헤스몬과, 벧 벨렛과, ");
INSERT INTO kor_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","하살 수알과, 브엘세바와, 비스요댜와, ");
INSERT INTO kor_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","바알라와, 이임과, 에셈과, ");
INSERT INTO kor_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","엘돌랏과, 그실과, 홀마와, ");
INSERT INTO kor_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","시글락과, 맛만나와, 산산나와, 르바옷과, ");
INSERT INTO kor_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","실힘과, 아인과, 림몬이니 모두 이십구 성읍이요 또 그 촌락이었으며 ");
INSERT INTO kor_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","평지에는 에스다올과, 소라와, 아스나와, ");
INSERT INTO kor_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","사노아와, 엔간님과, 답부아와, 에남과, ");
INSERT INTO kor_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","야르뭇과, 아둘람과, 소고와, 아세가와, ");
INSERT INTO kor_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","사아라임과, 아디다임과, 그데라와, 그데로다임이니 모두 십 사 성읍이요 또 그 촌락이었으며 ");
INSERT INTO kor_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","스난과, 하다사와, 믹달갓과, ");
INSERT INTO kor_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","딜르안과, 미스베와, 욕드엘과, ");
INSERT INTO kor_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","라기스와, 보스갓과, 에글론과, ");
INSERT INTO kor_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","갑본과, 라맘과, 기들리스와, ");
INSERT INTO kor_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","그데롯과, 벧다곤과, 나아마와, 막게다니 모두 십 육 성읍이요 또 그 촌락이었으며 ");
INSERT INTO kor_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","립나와, 에델과, 아산과, ");
INSERT INTO kor_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","입다와, 아스나와, 느십과, ");
INSERT INTO kor_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","그일라와, 악십과, 마레사니 모두 아홉 성읍이요 또 그 촌락이었으며 ");
INSERT INTO kor_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","에그론과, 그 향리와, 촌락과, ");
INSERT INTO kor_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","에그론에서부터 바다까지 아스돗 곁에 있는 모든 성읍과 그 촌락이었으며 ");
INSERT INTO kor_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","아스돗과, 그 향리와, 촌락과, 가사와, 그 향리와, 촌락이니 애굽 시내와 대해 가에 이르기까지였으며 ");
INSERT INTO kor_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","산지는 사밀과, 얏딜과, 소고와, ");
INSERT INTO kor_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","단나와, 기럇 산나 곧 드빌과, ");
INSERT INTO kor_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","아납과, 에스드모와, 아님과, ");
INSERT INTO kor_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","고센과, 홀론과, 길로니 모두 십 일 성읍이요 또 그 촌락이었으며 ");
INSERT INTO kor_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","아랍과, 두마와, 에산과, ");
INSERT INTO kor_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","야님과, 벧 답부아와, 아베가와, ");
INSERT INTO kor_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","훔다와, 기럇 아르바 곧 헤브론과 시올이니 모두 아홉 성읍이요 또 그 촌락이었으며 ");
INSERT INTO kor_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","마온과, 갈멜과, 십과, 윳다와, ");
INSERT INTO kor_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","이스르엘과, 욕드암과, 사노아와, ");
INSERT INTO kor_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","가인과, 기브아와, 딤나니 모두 열 성읍이요 또 그 촌락이었으며 ");
INSERT INTO kor_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","할훌과, 벧 술과, 그돌과, ");
INSERT INTO kor_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","마아랏과, 벧 아놋과, 엘드곤이니 모두 여섯 성읍이요 또 그 촌락이었으며 ");
INSERT INTO kor_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","기럇 바알 곧 기럇 여아림과, 라빠니 모두 두 성읍이요 또 그 촌락이었으며 ");
INSERT INTO kor_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","광야에는 벧 아라바와, 밋딘과, 스가가와, ");
INSERT INTO kor_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","닙산과, 염성과, 엔 게디니 모두 여섯 성읍이요 또 그 촌락이었더라 ");
INSERT INTO kor_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","예루살렘 거민 여부스 사람을 유다 자손이 쫓아내지 못하였으므로 여부스 사람이 오늘날까지 유다 자손과 함께 예루살렘에 거하니라 ");
INSERT INTO kor_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","요셉 자손이 제비 뽑은 것은 여리고 곁 요단 곧 여리고 물 동편 광야에서부터 나아가 여리고로 말미암아 올라가서 산지를 지나 벧엘에 이르고 ");
INSERT INTO kor_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","벧엘에서부터 루스로 나아가 아렉 사람의 경계로 지나 아다롯에 이르고 ");
INSERT INTO kor_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","서편으로 내려가서 야블렛 사람의 경계에 이르러 아래 벧 호론 곧 게셀에 미치고 그 끝은 바다라 ");
INSERT INTO kor_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","요셉의 자손 므낫세와 에브라임이 그 기업을 얻었더라 ");
INSERT INTO kor_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","에브라임 자손의 그 가족대로 얻은 것의 경계는 이러하니라 그 기업의 경계는 동으로 아다롯 앗달에서 윗 벧 호론에 이르고 ");
INSERT INTO kor_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","또 서편으로 나아가 북편 믹므다에 이르고 동편으로 돌아 다아낫실로에 이르러 야노아 동편을 지나고 ");
INSERT INTO kor_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","야노아에서부터 아다롯과 나아라로 내려가서 여리고에 미치며 요단으로 나아가고 ");
INSERT INTO kor_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","또 답부아에서부터 서편으로 지나서 가나 시내에 미치나니 그 끝은 바다라 에브라임 자손의 지파가 그 가족대로 얻은 기업이 이러하였고 ");
INSERT INTO kor_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","그 외에 므낫세 자손의 기업 중에서 에브라임 자손을 위하여 구별한 모든 성읍과 촌락도 있었더라 ");
INSERT INTO kor_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","그들이 게셀에 거하는 가나안 사람을 쫓아내지 아니하였으므로 가나안 사람이 오늘날까지 에브라임 가운데 거하며 사역하는 종이 되니라 ");
INSERT INTO kor_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","므낫세 지파를 위하여 제비 뽑은 것은 이러하니라 므낫세는 요셉의 장자이었고 므낫세의 장자 마길은 길르앗의 아비라 그는 무사이어서 길르앗과 바산을 얻었으므로 ");
INSERT INTO kor_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","므낫세의 남은 자손을 위하여 그 가족대로 제비를 뽑았는데 그들은 곧 아비에셀의 자손과 헬렉의 자손과 아스리엘의 자손과 세겜의 자손과 헤벨의 자손과 스미다의 자손이니 그들의 가족대로 요셉의 아들 므낫세의 남 자손이며 ");
INSERT INTO kor_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","헤벨의 아들 길르앗의 손자 마길의 증손 므낫세의 현손 슬로브핫은 아들이 없고 딸 뿐이요 그 딸들의 이름은 말라와, 노아와, 호글라와, 밀가와, 디르사라 ");
INSERT INTO kor_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","그들이 제사장 엘르아살과 눈의 아들 여호수아와 방백들 앞에 나아와서 말하기를 여호와께서 모세에게 명하사 우리 형제 중에서 우리에게 기업을 주라 하셨다 하매 여호와의 명령을 따라 그들에게 기업을 그 아비 형제 중에서 주므로 ");
INSERT INTO kor_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","요단 동편 길르앗과 바산 외에 므낫세에게 열 분깃이 돌아갔으니 ");
INSERT INTO kor_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","므낫세의 여손들이 그 남 자손 중에서 기업을 얻은 까닭이었으며 길르앗 땅은 므낫세의 남은 자손에게 속하였더라 ");
INSERT INTO kor_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","므낫세의 경계는 아셀에서부터 세겜 앞 믹므닷에 미치고 우편으로 가서 엔답부아 거민의 땅에 이르나니 ");
INSERT INTO kor_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","답부아 땅은 므낫세에게 속하였으되 므낫세 경계에 있는 답부아읍은 에브라임 자손에게 속하였으며 ");
INSERT INTO kor_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","또 경계가 가나 시내로 내려가서 그 시내 남편에 이르나니 므낫세의 성읍 중에 이 성읍들은 에브라임에게 속하였으며 므낫세의 경계는 그 시내 북편이요 그 끝은 바다며 ");
INSERT INTO kor_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","그 남편은 에브라임에 속하였고 북편은 므낫세에 속하였고 바다가 그 경계가 되었으며 그들의 땅의 북은 아셀에 미쳤고 동은 잇사갈에 미쳤으며 ");
INSERT INTO kor_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","잇사갈과 아셀에도 므낫세의 소유가 있으니 곧 벧 스안과, 그 향리와, 이블르암과, 그 향리와, 돌의 거민과, 그 향리요, 또 엔돌 거민과, 그 향리와, 다아낙 거민과, 그 향리와, 므깃도 거민과, 그 향리들 세 높은 곳이라 ");
INSERT INTO kor_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","그러나 므낫세 자손이 그 성읍들의 거민을 쫓아내지 못하매 가나안 사람이 결심하고 그 땅에 거하였더니 ");
INSERT INTO kor_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","이스라엘 자손이 강성한 후에야 가나안 사람에게 사역을 시켰고 다 쫓아내지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","요셉 자손이 여호수아에게 말하여 가로되 여호와께서 지금까지 내게 복을 주시므로 내가 큰 민족이 되었거늘 당신이 나의 기업을 위하여 한 제비 한 분깃으로만 내게 주심은 어찜이니이까 ? ");
INSERT INTO kor_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","여호수아가 그들에게 이르되 `네가 큰 민족이 되므로 에브라임 산지가 네게 너무 좁을진대 브리스 사람과 르바임 사람의 땅 삼림에 올라가서 스스로 개척하라 !' ");
INSERT INTO kor_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","요셉 자손이 가로되 `그 산지는 우리에게 넉넉지도 못하고 골짜기땅에 거하는 가나안 사람에게는 벧스안과 그 향리에 거하는 자든지 이스르엘 골짜기에 거하는 자든지 다 철병거가 있나이다' ");
INSERT INTO kor_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","여호수아가 다시 요셉의 족속 곧 에브라임과 므낫세에게 일러 가로되 너는 큰 민족이요 큰 권능이 있은즉 한 분깃만 가질 것이 아니라 ");
INSERT INTO kor_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","그 산지도 네 것이 되리니 비록 삼림이라도 네가 개척하라 ! 그 끝까지 네 것이 되리라 가나안 사람이 비록 철병거를 가졌고 강할지라도 네가 능히 그를 쫓아내리라 ");
INSERT INTO kor_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","이스라엘 자손의 온 회중이 실로에 모여서 거기 회막을 세웠으니 그 땅이 이미 그들의 앞에 돌아와 복종하였음이나 ");
INSERT INTO kor_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","이스라엘 자손 중에 그 기업의 분배를 얻지 못한 자가 오히려 일곱 지파라 ");
INSERT INTO kor_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","여호수아가 이스라엘 자손에게 이르되 `너희가 너희 열조의 하나님 여호와께서 너희에게 주신 땅을 취하러 가기를 어느 때까지 지체하겠느냐 ? ");
INSERT INTO kor_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","너희는 매 지파에 삼인씩 선정하라 내가 그들을 보내리니 그들은 일어나서 그 땅에 두루 다니며 그 기업에 상당하게 그려 가지고 내게로 돌아올 것이라 ");
INSERT INTO kor_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","그들이 그 땅을 일곱 부분에 나누되 유다는 남편 자기 경내에 거하고 요셉의 족속은 그 북편 자기 경내에 거한즉 ");
INSERT INTO kor_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","그 남은 땅을 일곱 부분으로 그려서 이곳 내게로 가져올지니 내가 여기서 너희를 위하여 우리 하나님 여호와 앞에서 제비뽑으리라 ");
INSERT INTO kor_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","레위 사람은 너희 중에 분깃이 없나니 여호와의 제사장 직분이 그들의 기업이 됨이며 갓과 르우벤과 므낫세 반 지파는 요단 저 편 동편에서 이미 기업을 받았나니 이는 여호와의 종 모세가 그들에게 준 것이니라' ");
INSERT INTO kor_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","그 사람들이 일어나 떠나니 여호수아가 땅을 그리러 가는 그들에게 명하여 가로되 '가서 그 땅으로 두루 다니며 그려 가지고 내게로 돌아오라 내가 여기 실로에서 여호와 앞에서 너희를 위하여 제비뽑으리라' ");
INSERT INTO kor_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","그 사람들이 가서 그 땅으로 두루 다니며 성읍들을 따라서 일곱 부분으로 책에 그리고 실로 진에 돌아와 여호수아에게 나아오니 ");
INSERT INTO kor_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","여호수아가 그들을 위하여 실로 여호와 앞에서 제비 뽑고 그가 거기서 이스라엘 자손의 분파대로 땅을 분배하였더라 ");
INSERT INTO kor_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","베냐민 자손 지파를 위하여 그 가족대로 제비를 뽑았으니 그 제비뽑은 땅의 경계는 유다 자손과 요셉 자손의 중간이라 ");
INSERT INTO kor_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","그 북방 경계는 요단에서부터 여리고 북편으로 올라가서 서편 산지를 넘어서 또 올라가서 벧아웬 황무지에 이르며 ");
INSERT INTO kor_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","또 그 경계가 거기서부터 루스로 나아가서 루스 남편에 이르나니루스는 곧 벧엘이며 또 그 경계가 아다롯 앗달로 내려가서 아래 벧 호론 남편 산 곁으로 지나고 ");
INSERT INTO kor_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","벧 호론 앞 남편 산에서부터 서방으로 돌아 남편으로 향하여 유다 자손의 성읍 기럇바알 곧 기럇 여아림에 이르러 끝이 되나니 이는 서방 경계며 ");
INSERT INTO kor_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","남방 경계는 기럇 여아림 끝에서부터 서편으로 나아가 넵도아 물 근원에 이르고 ");
INSERT INTO kor_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","르바임 골짜기 북편 힌놈의 아들 골짜기 앞에 있는 산 끝으로 내려가고 또 힌놈의 골짜기로 내려가서 여부스 남편에 이르러 엔 로겔로 내려가고 ");
INSERT INTO kor_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","또 북향하여 엔 세메스로 나아가서 아둠밈 비탈 맞은편 글릴롯으로 나아가서 르우벤 자손 보한의 돌까지 내려 가고 ");
INSERT INTO kor_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","북으로 아라바 맞은편을 지나 아라바로 내려가고 ");
INSERT INTO kor_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","또 북으로 벧 호글라 곁을 지나서 요단 남단에 당한 염해의 북편 해만이 그 경계의 끝이 되나니 이는 남편 경계며 ");
INSERT INTO kor_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","동방 경계는 요단이니 이는 베냐민 자손이 그 가족대로 얻은 기업의 사면 경계이었더라 ");
INSERT INTO kor_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","베냐민 자손의 지파가 그 가족대로 얻은 성읍들은 여리고와, 벧 호글라와, 에멕 그시스와, ");
INSERT INTO kor_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","벧 아라바와, 스마라임과, 벧엘과, ");
INSERT INTO kor_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","아윔과, 바라와, 오브라와, ");
INSERT INTO kor_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","그발 암모니와, 오브니와, 게바니 십 이 성읍이요 또 그 촌락이며 ");
INSERT INTO kor_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","기브온과, 라마와, 브에롯과, ");
INSERT INTO kor_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","미스베와, 그비라와, 모사와, ");
INSERT INTO kor_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","레겜과, 이르브엘과, 다랄라와, ");
INSERT INTO kor_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","셀라와, 엘렙과, 여부스 곧 예루살렘과 기부앗과 기럇이니 십 사 성읍이요 또 그 촌락이라 이는 베냐민 자손이 그 가족대로 얻은 기업이었더라 ");
INSERT INTO kor_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","둘째로 시므온 곧 시므온 자손의 지파를 위하여 그 가족대로 제비를 뽑았으니 그 기업은 유다 자손의 기업 중에서라 ");
INSERT INTO kor_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","그 얻은 기업은 브엘세바 곧 세바와, 몰라다와, ");
INSERT INTO kor_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","하살 수알과, 발라와, 에셈과, ");
INSERT INTO kor_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","엘돌랏과, 브둘과, 호르마와, ");
INSERT INTO kor_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","시글락과, 벧 말가봇과, 하살수사와, ");
INSERT INTO kor_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","벧 르바옷과, 사루헨이니 십 삼 성읍이요 또 그 촌락이며 ");
INSERT INTO kor_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","또 아인과 림몬과, 에델과 아산이니 네 성읍이요 또 그 촌락이며 ");
INSERT INTO kor_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","또 남방 라마 곧 바알랏 브엘까지 이 성들을 둘러 있는 모든 촌락이니 이는 시므온 자손의 지파가 그 가족대로 얻은 기업이라 ");
INSERT INTO kor_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","시므온 자손의 이 기업은 유다 자손의 기업 중에서 취하였으니 이는 유다 자손의 분깃이 자기들에게 너무 많으므로 시므온 자손이 자기의 기업을 그들의 기업 중에서 얻음이었더라 ");
INSERT INTO kor_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","세째로 스불론 자손을 위하여 그 가족대로 제비를 뽑았으니 그 기업의 경계는 사릿에 미치고 ");
INSERT INTO kor_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","서편으로 올라가서 마랄라에 이르러 답베셋에 미치고 욕느암 앞 시내에 미치며 ");
INSERT INTO kor_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","사릿에서부터 동편으로 돌아 해 뜨는 편을 향하고 기슬롯 다볼의 경계에 이르고 다브랏으로 나가서 야비아로 올라가고 ");
INSERT INTO kor_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","또 거기서부터 동편으로 가드 헤벨을 지나 엣 가신에 이르고 네아까지 연한 림몬으로 나아가서 ");
INSERT INTO kor_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","북으로 돌아 한나돈에 이르고 입다엘 골짜기에 이르러 끝이 되며 ");
INSERT INTO kor_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","또 갓닷과, 나할랄과, 시므론과, 이달라와, 베들레헴이니 모두 십 이성읍이요 또 그 촌락이라 ");
INSERT INTO kor_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","스불론 자손이 그 가족대로 얻은 기업은 이 성읍들과 그 촌락이었더라 ");
INSERT INTO kor_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","네째로 잇사갈 곧 잇사갈 자손을 위하여 그 가족대로 제비를 뽑았으니 ");
INSERT INTO kor_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","그 지경 안은 이스르엘과, 그술롯과, 수넴과, ");
INSERT INTO kor_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","하바라임과, 시온과, 아나하랏과, ");
INSERT INTO kor_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","랍빗과, 기시온과, 에베스와, ");
INSERT INTO kor_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","레멧과, 언간님과, 엔핫다와, 벧 바세스며, ");
INSERT INTO kor_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","그 경계는 다볼과 사하수마와 벧 세메스에 미치고 그 끝은 요단이니 모두 십 육 성읍이요 또 그 촌락이라 ");
INSERT INTO kor_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","잇사갈 자손 지파가 그 가족대로 얻은 기업은 이 성읍들과 그 촌락이었더라 ");
INSERT INTO kor_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","다섯째로 아셀 자손의 지파를 위하여 그 가족대로 제비를 뽑았으니 ");
INSERT INTO kor_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","그 지경 안은 헬갓과, 할리와, 베덴과, 악삽과, ");
INSERT INTO kor_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","알람멜렉과, 아맛과, 미살이며 그 경계의 서편은 갈멜에 미치며 시홀 림낫에 미치고 ");
INSERT INTO kor_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","꺾여 해 돋는 편을 향하여 벧 다곤에 이르며 스불론에 달하고 북편으로 입다 엘 골짜기에 미쳐서 벧에멕과 느이엘에 이르고 가불 좌편으로 나가서 ");
INSERT INTO kor_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","에브론과, 르홉과, 함몬과, 가나를 지나 큰 시돈까지 이르고 ");
INSERT INTO kor_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","돌아서 라마와 견고한 성읍 두로에 이르고 돌아서 호사에 이르고 악십 지방 곁 바다가 끝이 되며 ");
INSERT INTO kor_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","또 움마와, 아벡과, 르홉이니 모두 이십 이 성읍과 그 촌락이라 ");
INSERT INTO kor_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","아셀 자손의 지파가 그 가족대로 얻은 기업은 이 성읍들과 그 촌락이었더라 ");
INSERT INTO kor_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","여섯째로 납달리 자손을 위하여 납달리 자손의 가족대로 제비를 뽑았으니 ");
INSERT INTO kor_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","그 경계는 헬렙과 사아난님의 상수리나무에서부터 아다미 네겝과 얍느엘을 지나 락굼까지요 그 끝은 요단이며 ");
INSERT INTO kor_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","서편으로 돌아 아스놋 다볼에 이르고 그 곳에서부터 나가 훅곡에 이르러는 남은 스불론에 접하였고 서는 아셀에 접하였으며 해 돋는 편은 유다에 달한 요단이며 ");
INSERT INTO kor_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","그 견고한 성읍들은 싯딤과, 세르와, 함맛과, 락갓과, 긴네렛과, ");
INSERT INTO kor_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","아다마와, 라마와, 하솔과, ");
INSERT INTO kor_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","게데스와, 에드레이와, 엔 하솔과, ");
INSERT INTO kor_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","이론과, 믹다렐과, 호렘과, 벧 아낫과, 벧 세메스니 모두 십 구 성읍이요 또 그 촌락이라 ");
INSERT INTO kor_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","납달리 자손의 지파가 그 가족대로 얻은 기업은 이 성읍들과 그 촌락이었더라 ");
INSERT INTO kor_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","일곱째로 단 자손의 지파를 위하여 그 가족대로 제비를 뽑았으니 ");
INSERT INTO kor_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","그 기업의 지경은 소라와, 에스다올과, 이르세메스와, ");
INSERT INTO kor_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","사알랍빈과, 아얄론과, 이들라와, ");
INSERT INTO kor_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","엘론과, 딤나와, 에그론과, ");
INSERT INTO kor_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","엘드게와, 깁브돈과, 바알랏과, ");
INSERT INTO kor_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","여훗과, 브네브락과, 가드 림몬과, ");
INSERT INTO kor_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","메얄곤과, 락곤과, 욥바 맞은편 경계까지라 ");
INSERT INTO kor_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","그런데 단 자손의 지경이 더욱 확장되었으니 이는 단 자손이 올라가서 레센을 쳐서 취하여 칼날로 치고 그것을 얻어 거기 거하였음이라 그 조상 단의 이름을 따라서 레센을 단이라 하였더라 ");
INSERT INTO kor_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","단 자손의 지파가 그 가족대로 얻은 기업은 이 성읍들과 그 촌락이었더라 ");
INSERT INTO kor_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","이스라엘 자손이 그 경계를 따라서 기업의 땅 나누기를 마치고 자기들 중에서 눈의 아들 여호수아에게 기업을 주었으되 ");
INSERT INTO kor_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","곧 여호와의 명령대로 여호수아의 구한 성읍 에브라임 산지 딤낫 세라를 주매 여호수아가 그 성읍을 중건하고 거기 거하였었더라 ");
INSERT INTO kor_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","제사장 엘르아살과 눈의 아들 여호수아와 이스라엘 자손 지파의 족장들이 실로에서 회막문 여호와 앞에서 제비 뽑아 나눈 기업이 이러하니라 이에 땅 나누는 일이 마쳤더라 ");
INSERT INTO kor_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","여호와께서 여호수아에게 일러 가라사대 ");
INSERT INTO kor_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","이스라엘 자손에게 고하여 이르라 내가 모세로 너희에게 말한 도피성을 택정하여 ");
INSERT INTO kor_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","부지 중 오살한 자를 그리로 도망하게 하라 이는 너희 중 피의 보수자를 피할 곳이니라 ");
INSERT INTO kor_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","그 성읍들의 하나에 도피하는 자는 그 성읍에 들어가는 문 어귀에 서서 그 성읍 장로들의 귀에 자기의 사고를 고할 것이요 그들은 그를 받아 성읍에 들여 한 곳을 주어 자기들 중에 거하게 하고 ");
INSERT INTO kor_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","피의 보수가 그 뒤를 따라온다 할지라도 그들은 그 살인자를 그의 손에 내어주지 말지니 이는 본래 미워함이 없이 부지 중에 그 이웃을 죽였음이라 ");
INSERT INTO kor_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","그 살인자가 회중의 앞에 서서 재판을 받기까지나 당시 대제사장의 죽기까지 그 성읍에 거하다가 그 후에 그 살인자가 본 성읍 곧 자기가 도망하여 나온 그 성읍의 자기 집으로 돌아갈지니라 ");
INSERT INTO kor_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","무리가 납달리의 산지 갈릴리 게데스와, 에브라임 산지의 세겜과, 유다 산지의 기럇아르바 곧 헤브론을 구별하였고 ");
INSERT INTO kor_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","또 여리고 동 요단 저편 르우벤 지파 중에서 평지 광야의 베셀과 갓 지파 중에서 길르앗라못과 므낫세 지파 중에서 바산 골란을 택하였으니 ");
INSERT INTO kor_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","이는 곧 이스라엘 모든 자손과 그들 중에 우거하는 객을 위하여 선정한 성읍들로서 누구든지 부지 중 살인한 자로 그리로 도망하여 피의 보수자의 손에 죽지 않게 하기 위함이며 그는 회중 앞에 설 때까지 거기 있을 것이니라 ");
INSERT INTO kor_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","때에 레위 사람의 족장들이 제사장 엘르아살과 눈의 아들 여호수아와 이스라엘 자손의 지파 족장들에게 나아와 ");
INSERT INTO kor_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","가나안 땅 실로에서 그들에게 말하여 가로되 '여호와께서 모세로 명하사 우리의 거할 성읍들과 우리의 가축 먹일 그 들을 우리에게 주라 하셨었나이다' 하매 ");
INSERT INTO kor_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","이스라엘 자손이 여호와의 명을 따라 자기의 기업에서 이 아래 성읍들과 그 들을 레위 사람에게 주니라 ");
INSERT INTO kor_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","그핫 가족을 위하여 제비를 뽑았는데 레위 사람 중 제사장 아론의 자손들은 유다 지파와 시므온 지파와 베냐민 지파 중에서 제비 대로 십 삼 성읍을 얻었고 ");
INSERT INTO kor_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","그 남은 그핫 자손들은 에브라임 지파의 가족과 단 지파와 므낫세 반 지파 중에서 제비대로 열 성읍을 얻었으며 ");
INSERT INTO kor_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","게르손 자손들은 잇사갈 지파의 가족들과 아셀 지파와 납달리 지파와 바산에 있는 므낫세 반 지파 중에서 제비대로 십삼 성읍을 얻었더라 ");
INSERT INTO kor_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","므라리 자손들은 그 가족대로 르우벤 지파와 갓 지파와 스불론 지파 중에서 십 이 성읍을 얻었더라 ");
INSERT INTO kor_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","여호와께서 모세로 명하신 대로 이스라엘 자손이 제비뽑아 레위 사람에게 준 성읍들과 그 들이 이러하니라 ");
INSERT INTO kor_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","유다 자손의 지파와 시므온 자손의 지파 중에서는 이 아래 기명한 성읍들을 주었는데 ");
INSERT INTO kor_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","레위 자손 중 그핫 가족들에 속한 아론 자손이 첫째로 제비뽑혔으므로 ");
INSERT INTO kor_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","아낙의 아비 아르바의 성읍 유다 산지 기럇 아르바 곧 헤브론과 그 사면 들을 그들에게 주었고 ");
INSERT INTO kor_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","오직 그 성읍의 밭과 촌락은 여분네의 아들 갈렙에게 주어 소유가 되게 하였더라 ");
INSERT INTO kor_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","제사장 아론 자손에게 준 것은 살인자의 도피성 헤브론과 그 들이요, 또 립나와 그 들과, ");
INSERT INTO kor_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","얏딜과 그 들과, 에스드모아와 그 들과, ");
INSERT INTO kor_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","홀론과 그 들과, 드빌과 그 들과, ");
INSERT INTO kor_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","아인과 그 들과, 윳다와 그 들과, 벧 세메스와 그 들이니 이 두 지파에서 아홉 성읍을 내었고 ");
INSERT INTO kor_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","또 베냐민 지파 중에서는 기브온과 그 들과, 게바와 그 들과, ");
INSERT INTO kor_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","아나돗과 그 들과, 알몬과 그 들 곧 네 성읍을 내었으니 ");
INSERT INTO kor_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","제사장 아론 자손의 성읍이 모두 십 삼 성읍과 그 들이었더라 ");
INSERT INTO kor_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","그 남은 레위 사람 그핫 자손의 가족 곧 그핫 자손에게는 제비 뽑아 에브라임 지파 중에서 그 성읍들을 주었으니 ");
INSERT INTO kor_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","곧 살인자의 도피성 에브라임 산지 세겜과 그 들이요, 또 게셀과 그 들과, ");
INSERT INTO kor_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","깁사임과 그 들과, 벧 호론과 그 들이니 네 성읍이요 ");
INSERT INTO kor_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","또 단 지파 중에서 준 것은 엘드게와 그 들과, 깁브돈과 그 들과, ");
INSERT INTO kor_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","아얄론과 그 들과, 가드 림몬과 그 들이니 네 성읍이요 ");
INSERT INTO kor_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","또 므낫세 반 지파 중에서 준 것은 다아낙과 그 들과, 가드림몬과 그 들이니 두 성읍이라 ");
INSERT INTO kor_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","그핫 자손의 남은 가족의 성읍이 모두 열과 그 들이었더라 ");
INSERT INTO kor_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","레위 가족의 게르손 자손들에게는 므낫세 반 지파 중에서 살인자의 도피성 바산 골란과 그 들을 주었고 또 브에스드라와 그 들을 주었으니 두 성읍이요 ");
INSERT INTO kor_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","잇사갈 지파 중에서는 기시온과 그들과, 다브랏과 그 들과, ");
INSERT INTO kor_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","야르뭇과 그 들과, 언 간님과 그 들을 주었으니 네 성읍이요 ");
INSERT INTO kor_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","아셀 지파 중에서는 미살과 그 들과, 압돈과 그 들과, ");
INSERT INTO kor_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","헬갓과 그 들과, 르홉과 그 들을 주었으니 네 성읍이요 ");
INSERT INTO kor_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","납달리 지파 중에서는 살인자의 도피성 갈릴리 게데스와 그 들을 주었고 또 함못 돌과 그 들과, 가르단과 그 들을 주었으니 세 성 읍이라 ");
INSERT INTO kor_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","게르손 사람이 그 가족대로 얻은 성읍이 모두 열 세 성읍과 그 들이었더라 ");
INSERT INTO kor_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","그 남은 레위 사람 므라리 자손의 가족들에게 준 것은 스불론 지파 중에서 욕느암과 그 들과, 가르다와 그 들과, ");
INSERT INTO kor_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","딤나와 그 들과, 나할랄과 그 들이니 네 성읍이요 ");
INSERT INTO kor_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","르우벤 지파 중에서 준 것은 베셀과 그 들과, 야하스와 그 들과 ");
INSERT INTO kor_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","그데못과 그 들과, 므바앗과 그 들이니 네 성읍이요 ");
INSERT INTO kor_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","갓 지파 중에서 준 것은 살인자의 도피성 길르앗 라못과 그 들이요, 또 마하나임과 그 들과, ");
INSERT INTO kor_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","헤스본과 그 들과, 야셀과 그 들이니 모두 네 성읍이라 ");
INSERT INTO kor_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","이는 레위 가족의 남은 자 곧 므라리 자손이 그 가족대로 얻은 성읍이니 그 제비뽑아 얻은 성읍이 십 이 성읍이었더라 ");
INSERT INTO kor_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","레위 사람의 이스라엘 자손의 기업 중에서 얻은 성읍이 모두 사십 팔 성읍이요 또 그 들이라 ");
INSERT INTO kor_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","이 각 성읍의 사면에 들이 있었고 모든 성읍이 다 그러하였더라 ");
INSERT INTO kor_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","여호와께서 이스라엘의 열조에게 맹세하사 주마 하신 온 땅을 이와 같이 이스라엘에게 다 주셨으므로 그들이 그것을 얻어 거기 거하였으며 ");
INSERT INTO kor_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","여호와께서 그들의 사방에 안식을 주셨으되 그 열조에게 맹세하신 대로 하셨으므로 그 모든 대적이 그들을 당한 자가 하나도 없었으니 이는 여호와께서 그들의 모든 대적을 그들의 손에 붙이셨음이라 ");
INSERT INTO kor_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","여호와께서 이스라엘 족속에게 말씀하신 선한 일이 하나도 남음이 없이 다 응하였더라 ");
INSERT INTO kor_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","그 때에 여호수아가 르우벤 사람과 갓 사람과 므낫세 반 지파를 불러서 ");
INSERT INTO kor_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","그들에게 이르되 `여호와의 종 모세가 너희에게 명한 것을 너희가 다 지키며 또 내가 너희에게 명한 모든 일에 내 말을 너희가 청종하여 ");
INSERT INTO kor_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","오늘날까지 날이 오래도록 너희가 너희 형제를 떠나지 아니하고 오직 너희 하나님 여호와의 명하신 그 책임을 지키도다 ");
INSERT INTO kor_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","이제는 너희 하나님 여호와꼐서 이미 말씀하신 대로 너희 형제에게 안식을 주셨으니 그런즉 이제 너희는 여호와의 종 모세가 요단 저편에서 너희에게 준 소유지로 가서 너희의 장막으로 돌아가되 ");
INSERT INTO kor_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","크게 삼가 여호와의 종 모세가 너희에게 명한 명령과 율법을 행하여 너희 하나님 여호와를 사랑하고 그 모든 길로 행하며 그 계명을 지켜 그에게 친근히 하고 너희 마음을 다하며 성품을 다하여 그를 섬길지니라' 하고 ");
INSERT INTO kor_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","여호수아가 그들에게 축복하여 보내매 그들이 자기 장막으로 갔더라 ");
INSERT INTO kor_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","므낫세 반 지파에게는 모세가 바산에서 기업을 주었고 기타 반 지파에게는 여호수아가 요단 이편 서편에서 그 형제 중에서 기업을 준지라 여호수아가 그들을 그 장막으로 돌려보낼 때에 그들에게 축복하고 ");
INSERT INTO kor_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","일러 가로되 `너희는 많은 재산과 심히 많은 가축과 은,금,동,철과 심히 많은 의복을 가지고 너희의 장막으로 돌아가서 너희 대적에게서 탈취한 것을 너희 형제와 나눌찌니라' 하매 ");
INSERT INTO kor_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","르우벤 자손과 갓 자손과 므낫세 반 지파가 가나안 땅 실로에서 이스라엘 자손을 떠나 여호와께서 모세로 명하신 대로 얻은 땅 곧 그 소유지 길르앗으로 가니라 ");
INSERT INTO kor_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","르우벤 자손과 므낫세 반 지파가 가나안 땅 요단 언덕 가에 이르자 거기서 요단 가에 단을 쌓았는데 볼 만한 큰 단이었더라 ");
INSERT INTO kor_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","이스라엘 자손이 들은즉 이르기를 `르우벤 자손과 갓 자손과 므낫세 반 지파가 가나안 땅의 맨 앞편 요단 언덕 가 이스라엘 자손에게 속한 편에 단을 쌓았다' 하는지라 ");
INSERT INTO kor_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","이스라엘 자손이 이를 듣자 곧 이스라엘 자손의 온 회중이 실로에 모여서 그들과 싸우러 가려하니라 ");
INSERT INTO kor_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","이스라엘 자손이 제사장 엘르아살의 아들 비느하스를 길르앗 땅으로 보내어 르우벤 자손과 갓 자손과 므낫세 반 지파를 보게 하되 ");
INSERT INTO kor_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","이스라엘 각 지파에서 한 방백씩 열 방백을 그와 함께 하게 하니 그들은 각기 이스라엘 천만인 중 족속의 두령이라 ");
INSERT INTO kor_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","그들이 길르앗 땅에 이르러 르우벤 자손과 갓 자손과 므낫세 반 지파에게 나아가서 그들에게 말하여 가로되 ");
INSERT INTO kor_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","여호와의 온 회중이 말하기를 `너희가 어찌하여 이스라엘 하나님께 범죄하여 오늘날 여호와를 좇는 데서 떠나서 자기를 위하여 단을 쌓아 여호와를 거역하고자 하느냐 ? ");
INSERT INTO kor_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","브올의 죄악으로 인하여 여호와의 회중에 재앙이 내렸으나 오늘날까지 우리가 그 죄에서 정결함을 얻지 못하였거늘 그 죄악이 우리에게 부족하여서 ");
INSERT INTO kor_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","오늘날 너희가 돌이켜 여호와를 좇지 않고자 하느냐 ? 너희가 오늘날 여호와를 배역하면 내일은 그가 이스라엘 온 회중에게 진노하시리라 ");
INSERT INTO kor_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","그런데 너희 소유지가 만일 깨끗지 아니하거든 여호와의 성막이 있는 여호와의 소유지로 건너와 우리 중에서 소유를 취할 것이니라 오직 우리 하나님 여호와의 단 외에 다른 단을 쌓음으로 여호와께 패역하지 말며 우리에게도 패역하지 말라 ");
INSERT INTO kor_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","세라의 아들 아간이 바친 물건에 대하여 범죄하므로 이스라엘 온 회중에 진노가 임하지 아니하였었느냐 ? 그 죄악으로 망한 자가 그 사람 뿐이 아니었느니라' ");
INSERT INTO kor_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","르우벤 자손과 갓 자손과 므낫세 반 지파가 이스라엘 천만인의 두령에게 대답하여 가로되 ");
INSERT INTO kor_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","'전능하신 자 하나님 여호와,전능하신 자 하나님 여호와께서 아시나니 이스라엘도 장차 알리라 이 일이 만일 여호와께 패역함이거나 범죄함이거든 주는 오늘날 우리를 구원치 마시옵소서 ");
INSERT INTO kor_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","우리가 단을 쌓은 것이 돌이켜 여호와를 좇지 아니하려 함이거나 혹시 그 위에 번제나 소제를 드리려 함이거나 혹시 화목제물을 드리려 함이어든 여호와는 친히 벌하시옵소서 ");
INSERT INTO kor_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","우리가 목적이 있어서 주의하고 이같이 하였노라 곧 생각하기를 후일에 너희 자손이 우리 자손에게 말하여 이르기를 너희가 이스라엘 하나님 여호와와 무슨 상관이 있느냐 ? ");
INSERT INTO kor_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","너희 르우벤 자손 갓 자손아 ! 여호와께서 우리와 너희 사이에 요단으로 경계를 삼으셨나니 너희는 여호와께 분의가 없느니라 하여 너희 자손이 우리 자손으로 여호와 경외하기를 그치게 할까 하여 ");
INSERT INTO kor_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","우리가 말하기를 우리가 이제 한 단 쌓기를 예비하자 하였노니 이는 번제를 위함도 아니요 다른 제사를 위함도 아니라 ");
INSERT INTO kor_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","우리가 여호와 앞에서 우리 번제와 우리 다른 제사와 우리 화목제로 섬기는 것을 우리와 너희 사이와 우리의 후대 사이에 증거가 되게 할 뿐으로서 너희 자손으로 후일에 우리 자손에게 이르기를 너희는 여호와께 분의가 없다 못하게 하려 함이로라 ");
INSERT INTO kor_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","우리가 말하였거니와 만일 그들이 후일에 우리에게나 우리 후대에게 이같이 말하면 우리가 말하기를 우리 열조가 지은 여호와의단 모형을 보라 이는 번제를 위한 것도 아니요 다른 제사를 위한것도 아니라 오직 우리와 너희 사이에 증거만 되게 할뿐이라 ");
INSERT INTO kor_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","우리가 번제나 소제나 다른 제사를 위하여 우리 하나님 여호와의 성막 앞에 있는 단 외에 단을 쌓음으로 여호와께 패역하고 오늘날 여호와를 좇음에서 떠나려 함은 결단코 아니니라' 하리라 ");
INSERT INTO kor_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","제사장 비느하스와 그와 함께한 회중의 방백 곧 이스라엘 천만인의 두령들이 르우벤 자손과 갓 자손과 므낫세 자손의 말을 듣고 좋게 여긴지라 ");
INSERT INTO kor_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","제사장 엘르아살의 아들 비느하스가 르우벤 자손과 갓 자손과 므낫세 자손에게 이르되 우리가 `오늘날 여호와께서 우리 중에 계신 줄을 아노니 이는 너희가 이 죄를 여호와께 범치 아니하였음이라 너희가 이제 이스라엘 자손을 여호와의 손에서 건져내었느니라' 하고 ");
INSERT INTO kor_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","제사장 엘르아살의 아들 비느하스와 방백들이 르우벤 자손과 갓 자손을 떠나 길르앗 땅에서 가나안 땅에 돌아와 이스라엘 자손에게 이르러 회보하매 ");
INSERT INTO kor_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","그 일이 이스라엘 자손을 즐겁게 한지라 이스라엘 자손이 하나님을 찬송하고 르우벤 자손과 갓 자손의 거하는 땅에 가서 싸워 그것을 멸하자 하는 말을 다시 하지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","르우벤 자손과 갓 자손이 그 단을 엣이라 칭하였으니 우리 사이에 이 단은 여호와께서 하나님이 되시는 증거라 함이었더라 ");
INSERT INTO kor_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","여호와께서 이스라엘의 사방 대적을 다 멸하시고 안식을 이스라엘에게 주신지 오랜 후에 여호수아가 나이 많아 늙은지라 ");
INSERT INTO kor_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","여호수아가 온 이스라엘 곧 그 장로들과 두령들과 재판장들과 유사들을 불러다가 그들에게 이르되 '나는 나이 많아 늙었도다 ");
INSERT INTO kor_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","너희 하나님 여호와께서 너희를 위하여 이 모든 나라에 행하신 일을 너희가 다 보았거니와 너희 하나님 여호와 그는 너희를 위하여 싸우신 자시니라 ");
INSERT INTO kor_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","보라, 내가 요단에서부터 해 지는 편 대해까지의 남아있는 나라들과 이미 멸한 모든 나라를 내가 너희를 위하여 제비뽑아 너희 지파에게 기업이 되게 하였느니라 ");
INSERT INTO kor_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","너희 하나님 여호와 그가 너희 앞에서 그들을 쫓으사 너희 목전에서 떠나게 하시리니 너희 하나님 여호와께서 너희에게 말씀하신 대로 너희가 그 땅을 차지할 것이라 ");
INSERT INTO kor_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","그러므로 너희는 크게 힘써 모세의 율법책에 기록된 것을 다 지켜 행하라 ! 그것을 떠나 좌로나 우로나 치우치지 말라 ! ");
INSERT INTO kor_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","너희 중에 남아 있는 이 나라들 중에 가지 말라 ! 그 신들의 이름을 부르지 말라 ! 그것을 가리켜 맹세하지 말라 ! 또 그것을 섬겨서 그것에게 절하지 말라 ! ");
INSERT INTO kor_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","오직 너희 하나님 여호와를 친근히 하기를 오늘날까지 행한것 같이 하라 ");
INSERT INTO kor_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","대저 여호와께서 강대한 나라들을 너희 앞에서 쫓아내셨으므로 오늘날까지 너희를 당한 자가 하나도 없었느니라 ");
INSERT INTO kor_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","너희 중 한 사람이 천명을 쫓으리니 이는 너희 하나님 여호와 그가 너희에게 말씀하신 것 같이 너희를 위하여 싸우심이라 ");
INSERT INTO kor_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","그러므로 스스로 조심하여 너희 하나님 여호와를 사랑하라 ! ");
INSERT INTO kor_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","너희가 만일 퇴보하여 너희 중에 빠져 남아 있는 이 민족들을 친근히 하여 더불어 혼인하며 피차 왕래하면 ");
INSERT INTO kor_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","정녕히 알라 너희 하나님 여호와께서 이 민족들을 너희 목전에서 다시는 쫓아내지 아니하시리니 그들이 너희에게 올무가 되며 덫이 되며 너희 옆구리에 채찍이 되며 너희 눈에 가시가 되어서 너희가 필경은 너희 하나님 여호와께서 너희에게 주신 이 아름다운 땅에서 멸절하리라 ");
INSERT INTO kor_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","보라, 나는 오늘날 온 세상이 가는 길로 가려니와 너희 하나님 여호와께서 너희에게 대하여 말씀하신 모든 선한 일이 하나도 틀리지 아니하고 다 너희에게 응하여 그 중에 하나도 어김이 없음을 너희 모든 사람의 마음과 뜻에 아는 바라 ");
INSERT INTO kor_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","너희 하나님 여호와께서 너희에게 말씀하신 모든 선한 일이 너희에게 임한 것 같이 여호와께서 모든 불길한 일도 너희에게 임하게 하사 너희 하나님 여호와께서 너희에게 주신 이 아름다운 땅에서 너희를 멸절하기까지 하실 것이라 ");
INSERT INTO kor_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","만일 너희가 너희 하나님 여호와께서 너희에게 명하신 언약을 범하고 가서 다른 신들을 섬겨 그에게 절하면 여호와의 진노가 너희에게 미치리니 너희에게 주신 아름다운 땅에서 너희가 속히 망하리라 ");
INSERT INTO kor_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","여호수아가 이스라엘 모든 지파를 세겜에 모으고 이스라엘 장로들과 그 두령들과 재판장들과 유사들을 부르매 그들이 하나님 앞에 보인지라 ");
INSERT INTO kor_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","여호수아가 모든 백성에게 이르되 `이스라엘 하나님 여호와의 말씀에 옛적에 너희 조상들 곧 아브라함의 아비,나홀의 아비 데라가 강 저편에 거하여 다른 신들을 섬겼으나 ");
INSERT INTO kor_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","내가 너희 조상 아브라함을 강 저편에서 이끌어내어 가나안으로 인도하여 온 땅을 두루 행하게 하고 그 씨를 번성케 하려고 그에게 이삭을 주었고 ");
INSERT INTO kor_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","이삭에게는 야곱과 에서를 주었으며 에서에게는 세일산을 소유로 주었으나 야곱과 그 자손들은 애굽으로 내려갔으므로 ");
INSERT INTO kor_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","내가 모세와 아론을 보내었고 또 애굽에 재앙을 내렸나니 곧 내가 그 가운데 행한 것과 같고 그 후에 너희를 인도하여 내었었노라 ");
INSERT INTO kor_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","내가 너희 열조를 애굽에서 인도하여 내어 바다에 이르게 한즉 애굽 사람이 병거와 마병을 거느리고 너희 열조를 홍해까지 따르므로 ");
INSERT INTO kor_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","너희 열조가 나 여호와께 부르짖기로 내가 너희와 애굽 사람 사이에 흑암을 두고 바다를 이끌어 그들을 덮었었나니 내가 애굽에서 행한 일을 너희가 목도하였으며 또 너희가 여러 날을 광야에 거하였었느니라 ");
INSERT INTO kor_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","내가 또 너희를 인도하여 요단 저편에 거하는 아모리 사람의 땅으로 들어가게 하매 그들이 너희와 싸우기로 내가 그들을 너희 손에 붙이매 너희가 그 땅을 점령하였고 나는 그들을 너희 앞에서 멸절시켰으며 ");
INSERT INTO kor_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","때에 모압 왕 십볼의 아들 발락이 일어나 이스라엘을 대적하여 사람을 보내어 브올의 아들 발람을 불러다가 너희를 저주케 하려 하였으나 ");
INSERT INTO kor_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","내가 발람을 듣기를 원치 아니한 고로 그가 오히려 너희에게 축복하였고 나는 너희를 그 손에서 건져 내었으며 ");
INSERT INTO kor_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","너희가 요단을 건너 여리고에 이른즉 여리고 사람과, 아모리 사람과, 브리스 사람과, 가나안 사람과, 헷 사람과, 기르가스 사람과, 히위 사람과, 여부스 사람들이 너희와 싸우기로 내가 그들을 너희의 손에 붙였으며 ");
INSERT INTO kor_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","내가 왕벌을 너희 앞에 보내어 그 아모리 사람의 두 왕을 너희 앞에서 쫓아내게 하였나니 너희 칼로나 너희 활로나 이같이 한 것이 아니며 ");
INSERT INTO kor_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","내가 또 너희의 수고하지 아니한 땅과 너희가 건축지 아니한 성읍을 너희에게 주었더니 너희가 그 가운데 거하며 너희가 또 자기의 심지 아니한 포도원과 감람원의 과실을 먹는다 하셨느니라 ");
INSERT INTO kor_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","그러므로 이제는 여호와를 경외하며 성실과 진정으로 그를 섬길 것이라 너희의 열조가 강 저편과 애굽에서 섬기던 신들을 제하여 버리고 여호와만 섬기라 ! ");
INSERT INTO kor_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","만일 여호와를 섬기는 것이 너희에게 좋지 않게 보이거든 너희 열조가 강 저편에서 섬기던 신이든지 혹 너희의 거하는 땅 아모리 사람의 신이든지 너희 섬길 자를 오늘날 택하라 ! 오직 나와 내 집은 여호와를 섬기겠노라 !' ");
INSERT INTO kor_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","백성이 대답하여 가로되 `여호와를 버리고 다른 신들 섬기는 일을 우리가 결단코 하지 아니하오리니 ");
INSERT INTO kor_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","이는 우리 하나님 여호와 그가 우리와 우리 열조를 인도하여 애굽 땅 종 되었던 집에서 나오게 하시고 우리 목전에서 그 큰 이적들을 행하시고 우리가 행한 모든 길에서, 우리의 지난 모든 백성 중에서 우리를 보호하셨음이며 ");
INSERT INTO kor_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","여호와께서 또 모든 백성 곧 이 땅에 거하던 아모리 사람을 우리 앞에서 쫓아내셨음이라 그러므로 우리도 여호와를 섬기리니 그는 우리 하나님이심이니이다 !' ");
INSERT INTO kor_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","여호수아가 백성에게 이르되 `너희가 여호와를 능히 섬기지 못할 것은 그는 거룩하신 하나님이시요 ! 질투하는 하나님이시니 너희 허물과 죄를 사하지 아니하실 것임이라 ");
INSERT INTO kor_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","만일 너희가 여호와를 버리고 이방 신들을 섬기면 너희에게 복을 내리신 후에라도 돌이켜 너희에게 화를 내리시고 너희를 멸하시리라' ");
INSERT INTO kor_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","백성이 여호수아에게 말하되 `아니니이다 ! 우리가 정녕 여호와를 섬기겠나이다 !' ");
INSERT INTO kor_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","여호수아가 백성에게 이르되 `너희가 여호와를 택하고 그를 섬기리라 하였으니 스스로 증인이 되었느니라' 그들이 가로되 `우리가 증인이 되었나이다' ");
INSERT INTO kor_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","여호수아가 가로되 `그러면 이제 너희 중에 있는 이방 신들을 제하여 버리고 너희 마음을 이스라엘의 하나님 여호와께로 향하라 !' ");
INSERT INTO kor_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","백성이 여호수아에게 말하되 `우리 하나님 여호와를 우리가 섬기고 그 목소리를 우리가 청종하리이다 !' 한지라 ");
INSERT INTO kor_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","그 날에 여호수아가 세겜에서 백성으로 더불어 언약을 세우고 그들을 위하여 율례와 법도를 베풀었더라 ");
INSERT INTO kor_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","여호수아가 이 모든 말씀을 하나님의 율법책에 기록하고 큰 돌을 취하여 거기 여호와의 성소 곁에 있는 상수리나무 아래 세우고 ");
INSERT INTO kor_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","모든 백성에게 이르되 `보라, 이 돌이 우리에게 증거가 되리니 이는 여호와께서 우리에게 하신 모든 말씀을 이 돌이 들었음이라 그런즉 너희로 너희 하나님을 배반치 않게 하도록 이 돌이 증거가 되리라' 하고 ");
INSERT INTO kor_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","백성을 보내어 각기 기업으로 돌아가게 하였더라 ");
INSERT INTO kor_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","이 일 후에 여호와의 종 눈의 아들 여호수아가 일백 십세에 죽으매 ");
INSERT INTO kor_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","무리가 그를 그의 기업의 경내 딤낫 세라에 장사하였으니 딤낫 세라는 에브라임 산지 가아스산 북이었더라 ");
INSERT INTO kor_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","이스라엘이 여호수아의 사는 날 동안과 여호수아 뒤에 생존한 장로들 곧 여호와께서 이스라엘을 위하여 행하신 모든 일을 아는 자의 사는 날 동안 여호와를 섬겼더라 ");
INSERT INTO kor_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","이스라엘 자손이 애굽에서 이끌어 낸 요셉의 뼈를 세겜에 장사하였으니 이 곳은 야곱이 세겜의 아비 하몰의 자손에게 금 일백개를 주고 산 땅이라 그것이 요셉 자손의 기업이 되었더라 ");
INSERT INTO kor_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","아론의 아들 엘르아살도 죽으매 무리가 그를 그 아들 비느하스가 에브라임 산지에서 받은 산에 장사하였더라 ");
INSERT INTO kor_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","여호수아가 죽은 후에 이스라엘 자손이 여호와께 묻자와 가로되 `우리 중 누가 먼저 올라가서 가나안 사람과 싸우리이까 ?' ");
INSERT INTO kor_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","여호와께서 가라사대 유다가 올라갈지니라 보라 ! 내가 이 땅을 그 손에 붙였노라 하시니라 ");
INSERT INTO kor_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","유다가 그 형제 시므온에게 이르되 `나의 제비 뽑아 얻은 땅에 나와 함께 올라가서 가나안 사람과 싸우자 그리하면 나도 너의 제비 뽑아 얻은 땅에 함께 가리라' 이에 시므온이 그와 함께 가니라 ");
INSERT INTO kor_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","유다가 올라가매 여호와께서 가나안 사람과 브리스 사람을 그들의 손에 붙이신지라 그들이 베섹에서 일만명을 죽이고 ");
INSERT INTO kor_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","또 베섹에서 아도니 베섹을 만나서 그와 싸워 가나안 사람과 브리스 사람을 죽이니 ");
INSERT INTO kor_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","아도니 베섹이 도망하는지라 그를 쫓아가서 잡아 그 수족의 엄지 가락을 끊으매 ");
INSERT INTO kor_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","아도니 베섹이 가로되 `옛적에 칠십 왕이 그 수족의 엄지가락을 찍히고 내 상 아래서 먹을 것을 줍더니 하나님이 나의 행한 대로 내게 갚으심이로다' 하니라 무리가 그를 끌고 예루살렘에 이르렀더니 그가 거기서 죽었더라 ");
INSERT INTO kor_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","유다 자손이 예루살렘을 쳐서 취하여 칼날로 치고 성을 불살랐으며 ");
INSERT INTO kor_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","그 후에 유다 자손이 내려가서 산지와 남방과 평지에 거한 가나안 사람과 싸웠고 ");
INSERT INTO kor_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","유다가 또 가서 헤브론에 거한 가나안 사람을 쳐서 세새와 아히만과 달매를 죽였더라 헤브론의 본 이름은 기럇 아르바이었더라 ");
INSERT INTO kor_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","거기서 나아가서 드빌의 거민들을 쳤으니 드빌의 본 이름은 기럇세벨이라 ");
INSERT INTO kor_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","갈렙이 말하기를 `기럇 세벨을 쳐서 그것을 취하는 자에게는 내 딸 악사를 아내로 주리라' 하였더니 ");
INSERT INTO kor_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","갈렙의 아우요 그나스의 아들인 옷니엘이 그것을 취한 고로 갈렙이 그 딸 악사를 그에게 아내로 주었더라 ");
INSERT INTO kor_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","악사가 출가할 때에 그에게 청하여 `자기 아비에게 밭을 구하자' 하고 나귀에서 내리매 갈렙이 묻되 `네가 무엇을 원하느냐 ?' ");
INSERT INTO kor_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","가로되 `내게 복을 주소서 ! 아버지께서 나를 남방으로 보내시니 샘물도 내게 주소서' 하매 갈렙이 윗샘과 아랫샘을 그에게 주었더라 ");
INSERT INTO kor_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","모세의 장인은 겐 사람이라 그 자손이 유다 자손과 함께 종려나무 성읍에서 올라가서 아랏 남방의 유다 황무지에 이르러 그 백성 중에 거하니라 ");
INSERT INTO kor_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","유다가 그 형제 시므온과 함께 가서 스밧에 거한 가나안 사람을 쳐서 그곳을 진멸하였으므로 그 성읍 이름을 호르마라 하니라 ");
INSERT INTO kor_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","유다가 또 가사와 그 경내와 아스글론과 그 경내와 에그론과 그 경내를 취하였고 ");
INSERT INTO kor_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","여호와께서 유다와 함께 하신 고로 그가 산지 거민을 쫓아내었으나 골짜기의 거민들은 철병거가 있으므로 그들을 쫓아내지 못하였으며 ");
INSERT INTO kor_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","무리가 모세의 명한 대로 헤브론을 갈렙에게 주었더니 그가 거기서 아낙의 세 아들을 쫓아내었고 ");
INSERT INTO kor_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","베냐민 자손은 예루살렘에 거한 여부스 사람을 쫓아내지 못하였으므로 여부스 사람이 베냐민 자손과 함께 오늘날까지 예루살렘에 거하더라 ");
INSERT INTO kor_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","요셉 족속도 벧엘을 치러 올라가니 여호와께서 그와 함께 하시니라 ");
INSERT INTO kor_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","요셉 족속이 벧엘을 정탐케 하였는데 그 성읍의 본 이름은 루스라 ");
INSERT INTO kor_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","탐정이 그 성읍에서 한 사람의 나오는 것을 보고 그에게 이르되 청하노니 이 성읍의 입구를 우리에게 가르치라 그리하면 너를 선대하리라 하매 ");
INSERT INTO kor_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","그 사람이 성읍의 입구를 가르친지라 이에 칼날로 그 성읍을 쳤으되 오직 그 사람과 그 가족을 놓아 보내매 ");
INSERT INTO kor_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","그 사람이 헷 사람의 땅에 가서 성읍을 건축하고 그 이름을 루스라 하였더니 오늘날까지 그 곳의 이름이더라 ");
INSERT INTO kor_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","므낫세가 벧스안과, 그 향리의 거민과, 다아낙과, 그 향리의 거민과, 돌과, 그 향리의 거민과, 이블르암과, 그 향리의 거민과, 므깃도와, 그 향리의 거민들을 쫓아내지 못하매 가나안 사람이 결심하고 그 땅에 거하였더니 ");
INSERT INTO kor_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","이스라엘이 강성한 후에야 가나안 사람에게 사역을 시켰고 다 쫓아내지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","에브라임이 게셀에 거한 가나안 사람을 쫓아내지 못하매 가나안 사람이 게셀에서 그들 중에 거하였더라 ");
INSERT INTO kor_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","스불론은 기드론 거민과 나할롤 거민을 쫓아내지 못하였으나 가나안 사람이 그들 중에 거하여 사역을 하였더라 ");
INSERT INTO kor_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","아셀이 악고 거민과, 시돈 거민과, 알랍과, 악십과, 헬바와, 아빅과, 르홉 거민을 쫓아내지 못하고 ");
INSERT INTO kor_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","그 땅 거민 가나안 사람 가운데 거하였으니 이는 쫓아내지 못함이었더라 ");
INSERT INTO kor_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","납달리가 벧세메스 거민과 벧아낫 거민을 쫓아내지 못하고 그 땅 거민 가나안 사람 가운데 거하였으나 벧세메스와 벧아낫 거민들이 그들에게 사역을 하였더라 ");
INSERT INTO kor_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","아모리 사람이 단 자손을 산지로 쫓아들이고 골짜기에 내려오기를 용납지 아니하고 ");
INSERT INTO kor_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","결심하고 헤레스 산과 아얄론과 사알빔에 거하였더니 요셉 족속이 강성하매 아모리 사람이 필경은 사역을 하였으며 ");
INSERT INTO kor_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","아모리 사람의 지계는 아그랍빔 비탈의 바위부터 그 위였더라 ");
INSERT INTO kor_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","여호와의 사자가 길갈에서부터 보김에 이르러 가로되 `내가 너희로 애굽에서 나오게 하고 인도하여 너희 열조에게 맹세한 땅으로 이끌어 왔으며 또 내가 이르기를 내가 너희에게 세운 언약을 영원히 어기지 아니하리니 ");
INSERT INTO kor_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","너희는 이 땅 거민과 언약을 세우지 말며 그들의 단을 헐라 하였거늘 너희가 내 목소리를 청종치 아니하였도다 그리함은 어찜이뇨 ?' ");
INSERT INTO kor_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","그러므로 내가 또 말하기를 `내가 그들을 너희 앞에서 쫓아내지 아니하리니 그들이 너희 옆구리에 가시가 될 것이며 그들의 신들이 너희에게 올무가 되리라' 하였노라 ");
INSERT INTO kor_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","여호와의 사자가 이스라엘 모든 자손에게 이말씀을 이르매 백성이 소리를 높여 운지라 ");
INSERT INTO kor_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","그러므로 그곳을 이름하여 보김이라 하니라 무리가 거기서 여호와께 제사를 드렸더라 ");
INSERT INTO kor_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","전에 여호수아가 백성을 보내매 이스라엘 자손이 각기 그 기업으로 가서 땅을 차지하였고 ");
INSERT INTO kor_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","백성이 여호수아의 사는 날 동안과 여호수아 뒤에 생존한 장로들 곧 여호와께서 이스라엘을 위하여 행하신 모든 큰 일을 본 자의 사는 날 동안에 여호아를 섬겼더라 ");
INSERT INTO kor_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","여호아의 종 눈의 아들 여호수아가 일백 십세에 죽으매 ");
INSERT INTO kor_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","무리가 그의 기업의 경내 에브라임 산지 가아스산 북 딤낫 헤레스에 장사하였고 ");
INSERT INTO kor_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","그 세대 사람도 다 그 열조에게로 돌아갔고 그 후에 일어난 다른 세대는 여호와를 알지 못하며 여호와께서 이스라엘을 위하여 행하신 일도 알지 못하였더라 ");
INSERT INTO kor_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","이스라엘 자손이 여호와의 목전에 악을 행하여 바알들을 섬기며 ");
INSERT INTO kor_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","애굽 땅에서 그들을 인도하여 내신 그 열조의 하나님 여호와를 버리고 다른 신 곧 그 사방에 있는 백성의 신들을 좇아 그들에게 절하여 여호와를 진노하시게 하였으되 ");
INSERT INTO kor_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","곧 그들이 여호와를 버리고 바알과 아스다롯을 섬겼으므로 ");
INSERT INTO kor_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","여호와께서 이스라엘에게 진노하사 노략하는 자의 손에 붙여 그들로 노략을 당케하시며 또 사방 모든 대적의 손에 파시매 그들이 다시는 대적을 당치 못하였으며 ");
INSERT INTO kor_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","그들이 어디를 가든지 여호와의 손이 그들에게 재앙을 내리시매 곧 여호와께서 말씀하신 것과 같고 여호와께서 그들에게 맹세하신 것과 같아서 그들의 괴로움이 심하였더라 ");
INSERT INTO kor_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","여호와께서 사사를 세우사 노략하는 자의 손에서 그들을 건져내게 하셨으나 ");
INSERT INTO kor_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","그들이 그 사사도 청종치 아니하고 돌이켜 다른 신들을 음란하듯 좇아 그들에게 절하고 여호와의 명령을 순종하던 그 열조의 행한 길을 속히 치우쳐 떠나서 그와 같이 행치 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","여호와께서 그들을 위하여 사사를 세우실 때에는 그 사사와 함께 하셨고 그 사사의 사는 날 동안에는 여호와께서 그들을 대적의 손에서 구원하셨으니 이는 그들이 대적에게 압박과 괴롭게 함을 받아 슬피 부르짖으므로 여호와께서 뜻을 돌이키셨음이어늘 ");
INSERT INTO kor_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","그 사사가 죽은 후에는 그들이 돌이켜 그 열조보다 더욱 패괴하여 다른 신들을 좇아 섬겨 그들에게 절하고 그 행위와 패역한 길을 그치지 아니하였으므로 ");
INSERT INTO kor_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","여호와께서 이스라엘에게 진노하여 이르시되 이 백성이 내가 그 열조와 세운 언약을 어기고 나의 목소리를 청종치 아니하였은즉 ");
INSERT INTO kor_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","나도 여호수아가 죽을 때에 남겨둔 열국을 다시는 그들의 앞에서 하나도 쫓아내지 아니하리니 ");
INSERT INTO kor_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","이는 이스라엘이 그 열조의 지킨 것같이 나 여호와의 도를 지켜 행하나 아니하나 그들로 시험하려 함이라 하시니라 ");
INSERT INTO kor_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","그 열국을 머물러두사 속히 쫓아내지 아니하시며 여호수아의 손에 붙이지 아니하셨음이 이를 인함이었더라 ");
INSERT INTO kor_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","여호와께서 가나안 전쟁을 알지 못한 이스라엘을 시험하려 하시며 ");
INSERT INTO kor_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","이스라엘 자손의 세대 중에 아직 전쟁을 알지 못하는 자에게 그것을 가르쳐 알게 하려하사 남겨 두신 열국은 ");
INSERT INTO kor_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","블레셋 다섯 방백과 가나안 모든 사람과 시돈 사람과 바알헤르몬 산에서부터 하맛 어구까지 레바논 산에 거하는 히위 사람이라 ");
INSERT INTO kor_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","남겨두신 이 열국으로 이스라엘을 시험하사 여호와께서 모세로 그들의 열조에게 명하신 명령들을 청종하나 알고자 하셨더라 ");
INSERT INTO kor_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","이스라엘 자손은 마침내 가나안 사람과, 헷 사람과, 아모리 사람과, 브리스 사람과, 히위 사람과, 여부스 사람 사이에 거하여 ");
INSERT INTO kor_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","그들의 딸들을 취하여 아내를 삼으며 자기 딸들을 그들의 아들에게 주며 또 그들의 신들을 섬겼더라 ");
INSERT INTO kor_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","이스라엘 자손이 여호와 목전에 악을 행하여 자기들의 하나님 여호와를 잊어버리고 바알들과 아세라들을 섬긴지라 ");
INSERT INTO kor_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","여호와께서 이스라엘에게 진노하사 그들을 메소보다미아 왕 구산리사다임의 손에 파셨으므로 이스라엘 자손이 구산 리사다임을 팔년을 섬겼더니 ");
INSERT INTO kor_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","이스라엘 자손이 여호와께 부르짖으매 여호와께서 그들을 위하여 한 구원자를 세워 구원하게 하시니 그는 곧 갈렙의 아우 그나스의 아들 옷니엘이라 ");
INSERT INTO kor_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","여호와의 신이 그에게 임하셨으므로 그가 이스라엘 사사가 되어 나가서 싸울 때에 여호와께서 메소보다미아 왕 구산 리사다임을 그 손에 붙이시매 옷니엘의 손이 구산 리사다임을 이기니라 ");
INSERT INTO kor_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","그 땅이 태평한 지 사십년에 그나스의 아들 옷니엘이 죽었더라 ");
INSERT INTO kor_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","이스라엘 자손이 또 여호와의 목전에 악을 행하니라 이스라엘 자손이 여호와의 목전에 악을 행하므로 여호와께서 모압 왕 에글론을 강성케 하사 그들을 대적하게 하시매 ");
INSERT INTO kor_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","에글론이 암몬과 아말렉 자손들을 모아가지고 와서 이스라엘을 쳐서 종려나무 성읍을 점령한지라 ");
INSERT INTO kor_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","이에 이스라엘 자손이 모압 왕 에글론을 십 팔년을 섬기니라 ");
INSERT INTO kor_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","이스라엘 자손이 여호와께 부르짖으매 여호와께서 그들을 위하여 한 구원자를 세우셨으니 그는 곧 베냐민 사람 게라의 아들 왼손 잡이 에훗이라 이스라엘 자손이 그를 의탁하여 모압 왕 에글론에게 공물을 바칠 때에 ");
INSERT INTO kor_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","에훗이 장이 한 규빗 되는 좌우에 날선 칼을 만들어 우편 다리 옷 속에 차고 ");
INSERT INTO kor_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","공물을 모압 왕 에글론에게 바쳤는데 에글론은 심히 비둔한 자이었더라 ");
INSERT INTO kor_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","에훗이 공물 바치기를 마친 후에 공물을 메고 온 자들을 보내고 ");
INSERT INTO kor_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","자기는 길갈 근처 돌 뜨는 곳에서부터 돌아와서 가로되 `왕이여, 내가 은밀한 일을 왕에게 고하려 하나이다' 왕이 명하여 `종용케 하라' 하매 모셔 선 자들이 다 물러간지라 ");
INSERT INTO kor_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","에훗이 왕의 앞으로 나아가니 왕은 서늘한 다락방에 홀로 앉아 있는 중이라 에훗이 가로되 `내가 하나님의 명을 받들어 왕에게 고할 일이 있나이다' 하매 왕이 그 좌석에서 일어나니 ");
INSERT INTO kor_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","에훗이 왼손으로 우편 다리에서 칼을 빼어 왕의 몸을 찌르매 ");
INSERT INTO kor_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","칼자루도 날을 따라 들어가서 그 끝이 등뒤까지 나갔고 그가 칼을 그 몸에서 빼어내지 아니하였으므로 기름이 칼날에 엉기었더라 ");
INSERT INTO kor_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","에훗이 현관에 나와서 다락문들을 닫아 잠그니라 ");
INSERT INTO kor_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","에훗이 나간 후에 왕의 신하들이 와서 다락문이 잠겼음을 보고 가로되 `왕이 필연 다락방에서 발을 가리우신다' 하고 ");
INSERT INTO kor_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","그들이 오래 기다려도 왕이 다락문을 열지 아니하는지라 열쇠를 취하여 열고 본즉 자기 주가 이미 죽어 땅에 엎드러졌더라 ");
INSERT INTO kor_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","그들의 기다리는 동안에 에훗이 피하여 돌 뜨는 곳을 지나 스이라로 도망하니라 ");
INSERT INTO kor_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","그가 이르러서는 에브라임 산지에서 나팔을 불매 이스라엘 자손이 산지에서 그를 따라 내려오니 에훗이 앞서 가며 ");
INSERT INTO kor_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","무리에게 이르되 `나를 따르라 ! 여호와께서 너희 대적 모압 사람을 너희의 손에 붙이셨느니라' 하매 무리가 에훗을 따라 내려가서 모압 맞은편 요단강 나루를 잡아 지켜 한 사람도 건너지 못하게 하였고 ");
INSERT INTO kor_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","그 때에 모압 사람 일만명 가량을 죽였으니 다 역사요 용사라 한 사람도 피하지 못하였더라 ");
INSERT INTO kor_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","그날에 모압 사람이 이스라엘의 수하에 항복하매 그 땅이 팔십년 동안 태평하였더라 ");
INSERT INTO kor_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","에훗의 후에 아낫의 아들 삼갈이 사사로 있어 소 모는 막대기로 블레셋 사람 육백명을 죽였고 그도 이스라엘을 구원하였더라 ");
INSERT INTO kor_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","에훗의 죽은 후에 이스라엘 자손이 또 여호와의 목전에 악을 행하매 ");
INSERT INTO kor_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","여호와께서 하솔에 도읍한 가나안 왕 야빈의 손에 그들을 파셨는데 그 군대 장관은 이방 하로셋에 거하는 시스라요 ");
INSERT INTO kor_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","야빈 왕은 철병거 구백승이 있어서 이십년 동안 이스라엘 자손을 심히 학대한 고로 이스라엘 자손이 여호와께 부르짖었더라 ");
INSERT INTO kor_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","그 때에 랍비돗의 아내 여선지 드보라가 이스라엘의 사사가 되었는데 ");
INSERT INTO kor_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","그는 에브라임 산지 라마와 벧엘 사이 드보라의 종려나무 아래 거하였고 이스라엘 자손은 그에게 나아가 재판을 받더라 ");
INSERT INTO kor_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","드보라가 보내어 아비노암의 아들 바락을 납달리 게데스에서 불러다가 그에게 이르되 `이스라엘 하나님 여호와께서 이같이 명하지 아니하셨느냐 ? 이르시기를 너는 납달리 자손과 스불론 자손 일만명을 거느리고 다볼 산으로 가라 ");
INSERT INTO kor_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","내가 야빈의 군대 장관 시스라와 그 병거들과 그 무리를 기손강으로 이끌어 네게 이르게 하고 그를 네 손에 붙이리라 하셨느니라' ");
INSERT INTO kor_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","바락이 그에게 이르되 `당신이 나와 함께 가면 내가 가려니와 당신이 나와 함께 가지 아니하면 나는 가지 않겠노라' ");
INSERT INTO kor_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","가로되 `내가 반드시 너와 함께 가리라 그러나 네가 이제 가는 일로는 영광을 얻지 못하리니 이는 여호와께서 시스라를 여인의 손에 파실 것임이니라' 하고 드보라가 일어나 바락과 함께 게데스로 가니라 ");
INSERT INTO kor_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","바락이 스불론과 납달리를 게데스로 부르니 일만인이 그를 따라 올라가고 드보라도 그와 함께 올라가니라 ");
INSERT INTO kor_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","모세의 장인 호밥의 자손중 겐 사람 헤벨이 자기 족속을 떠나 게데스에 가까운 사아난님 상수리나무 곁에 이르러 장막을 쳤더라 ");
INSERT INTO kor_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","아비노암의 아들 바락이 다볼산에 오른 것을 혹이 시스라에게 고하매 ");
INSERT INTO kor_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","시스라가 모든 병거 곧 철병거 구백승과 자기와 함께 있는 온 군사를 이방 하로셋에서부터 기손강으로 모은지라 ");
INSERT INTO kor_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","드보라가 바락에게 이르되 `일어나라 ! 이는 여호와께서 시스라를 네 손에 붙이신 날이라 여호와께서 너의 앞서 행하지 아니하시느냐 ?' 이에 바락이 일만명을 거느리고 다볼 산에서 내려가니 ");
INSERT INTO kor_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","여호와께서 바락의 앞에서 시스라와 그 모든 병거와 그 온 군대를 칼날로 쳐서 패하게 하시매 시스라가 병거에서 내려 도보로 도망한지라 ");
INSERT INTO kor_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","바락이 그 병거들과 군대를 추격하여 이방 하로셋에 이르니 시스라의 온 군대가 다 칼에 엎드러졌고 남은 자가 없었더라 ");
INSERT INTO kor_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","시스라가 도보로 도망하여 겐사람 헤벨의 아내 야엘의 장막에 이르렀으니 하솔 왕 야빈은 겐 사람 헤벨의 집과 화평이 있음이라 ");
INSERT INTO kor_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","야엘이 나가 시스라를 영접하며 그에게 말하되 `나의 주여 ! 들어오소서 내게로 들어오시고 두려워하지 마소서' 하매 그 장막에 들어가니 야엘이 이불로 덮으니라 ");
INSERT INTO kor_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","시스라가 그에게 말하되 `청하노니 내게 물을 조금 마시우라 내가 목이 마르도다` 하매 젖부대를 열어 그에게 마시우고 그를 덮으니 ");
INSERT INTO kor_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","그가 또 가로되 `장막문에 섰다가 만일 사람이 와서 네게 묻기를 여기 어떤 사람이 있느냐 ? 하거든 너는 없다 하라' 하고 ");
INSERT INTO kor_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","그가 곤비하여 깊이 잠든지라 헤벨의 아내 야엘이 장막 말뚝을 취하고 손에 방망이를 들고 그에게로 가만히 가서 말뚝을 그 살쩍에 박으매 말뚝이 꿰뚫고 땅에 박히니 시스라가 기절하여 죽으니라 ");
INSERT INTO kor_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","바락이 시스라를 따를 때에 야엘이 나가서 그를 맞아 가로되 `오라 내가 너의 찾는 사람을 네게 보이리라' 바락이 그에게 들어가 보니 시스라가 죽어 누웠고 말뚝은 그 살쩍에 박혔더라 ");
INSERT INTO kor_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","이와 같이 이 날에 하나님이 가나안 왕 야빈을 이스라엘 자손 앞에 패하게 하신지라 ");
INSERT INTO kor_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","이스라엘 자손의 손이 가나안 왕 야빈을 점점 더 이기어서 마침내 가나안 왕 야빈을 진멸하였더라 ");
INSERT INTO kor_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","이날에 드보라와 아비노암의 아들 바락이 노래하여 가로되 ");
INSERT INTO kor_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","이스라엘의 두령이 그를 영솔하였고 백성이 즐거이 헌신하였으니 여호와를 찬송하라 ! ");
INSERT INTO kor_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","너희 왕들아 들으라 ! 방백들아 귀를 기울이라 ! 나 곧 내가 여호와를 노래할 것이요 이스라엘의 하나님 여호와를 찬송하리로다 ! ");
INSERT INTO kor_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","여호와여 ! 주께서 세일에서부터 나오시고 에돔 들에서부터 진행하실 때에 땅이 진동하고 하늘도 새어서 구름이 물을 내렸나이다 ");
INSERT INTO kor_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","산들이 여호와 앞에서 진동하니 저 시내산도 이스라엘 하나님 여호와 앞에서 진동하였도다 ");
INSERT INTO kor_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","아낫의 아들 삼갈의 날에 또는 야엘의 날에는 대로가 비었고 행인들은 소로로 다녔도다 ");
INSERT INTO kor_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","이스라엘에 관원이 그치고 그쳤더니 나 드보라가 일어났고 내가 일어나서 이스라엘의 어미가 되었도다 ");
INSERT INTO kor_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","무리가 새 신들을 택하였으므로 그 때에 전쟁이 성문에 미쳤으나 이스라엘 사만명 중에 방패와 창이 보였던고 ");
INSERT INTO kor_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","내 마음이 이스라엘의 방백을 사모함은 그들이 백성 중에서 즐거이 헌신하였음이라 여호와를 찬송하라 ! ");
INSERT INTO kor_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","흰 나귀를 탄 자들, 귀한 화문석에 앉은 자들, 길에 행하는 자들아 선파할지어다 ! ");
INSERT INTO kor_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","활 쏘는 자의 지꺼림에서 멀리 떨어진 물 긷는 곳에서도 여호와의 의로우신 일을 칭술하라 그의 이스라엘을 다스리시는 의로우신 일을 칭술하라 그 때에 여호와의 백성이 성문에 내려갔도다 ");
INSERT INTO kor_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","깰지어다, 깰지어다, 드보라여, 깰지어다, 깰지어다 ! 너는 노래할지어다, 일어날지어다 ! 바락이여, 아비노암의 아들이여 네 사로 잡은 자를 끌고 갈지어다 ");
INSERT INTO kor_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","그 때에 남은 귀인과 백성이 내려왔고 여호와께서 나를 위하여 용사를 치시려고 강림하셨도다 ");
INSERT INTO kor_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","에브라임에게서 나온 자는 아말렉에 뿌리 박힌 자요 그 다음에 베냐민은 너희 백성 중에 섞였으며 마길에게서는 다스리는 자들이 내려왔고 스불론에게서는 대장군의 지팡이를 잡은 자가 내려 왔도다 ");
INSERT INTO kor_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","잇사갈의 방백들이 드보라와 함께 하니 잇사갈의 심사를 바락도 가졌도다 그 발을 좇아 골짜기로 달려 내려가니 르우벤 시냇가에 큰 결심이 있었도다 ");
INSERT INTO kor_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","네가 양의 우리 가운데 앉아서 목자의 저 부는 소리를 들음은 어찜이뇨 ? 르우벤 시냇가에서 마음에 크게 살핌이 있도다 ");
INSERT INTO kor_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","길르앗은 요단 저편에 거하거늘 단은 배에 머무름은 어찜이뇨 ? 아셀은 해빈에 앉고 자기 시냇가에 거하도다 ");
INSERT INTO kor_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","스불론은 죽음을 무릅쓰고 생명을 아끼지 아니한 백성이요 납달리도 들의 높은 곳에서 그러하도다 ");
INSERT INTO kor_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","열왕이 와서 싸울 때에 가나안 열왕이 므깃도 물가 다아낙에서 싸웠으나 돈을 탈취하지 못하였도다 ");
INSERT INTO kor_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","별들이 하늘에서부터 싸우되 그 다니는 길에서 시스라와 싸웠도다 ");
INSERT INTO kor_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","기손강은 그 무리를 표류시켰으니 이 기손강은 옛 강이라 내 영혼아 ! 네가 힘 있는 자를 밟았도다 ");
INSERT INTO kor_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","그 때에 군마가 빨리 달리니 말굽소리는 땅을 울리도다 ");
INSERT INTO kor_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","여호와의 사자의 말씀에 메로스를 저주하라 ! 너희가 거듭 거듭 그 거민을 저주할 것은 그들이 와서 여호와를 돕지 아니하며 여호와를 도와 용사를 치지 아니함이니라 하시도다 ");
INSERT INTO kor_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","겐 사람 헤벨의 아내 야엘은 다른 여인보다 복을 받을 것이니 장막에 거한 여인보다 더욱 복을 받을 것이로다 ");
INSERT INTO kor_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","시스라가 물을 구하매 우유를 주되 곧 엉긴 젖을 귀한 그릇에 담아주었고 ");
INSERT INTO kor_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","손으로 장막 말뚝을 잡으며 오른손에 장인의 방망이를 들고 그 방망이로 시스라를 쳐서 머리를 뚫되 곧 살쩍을 꿰뚫었도다 ");
INSERT INTO kor_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","그가 그의 발 앞에 꾸부러지며 엎드러지고 쓰러졌고 그의 발 앞에 꾸부러져 엎드러져서 그 꾸부러진 곳에 엎드러져 죽었도다 ");
INSERT INTO kor_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","시스라의 어미가 창문으로 바라보며 살창에서 부르짖기를 `그의 병거가 어찌하여 더디 오는고 그의 병거 바퀴가 어찌하여 더디 구는고' 하매 ");
INSERT INTO kor_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","그 지혜로운 시녀들이 대답하였겠고 그도 스스로 대답하기를 ");
INSERT INTO kor_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","`그들이 어찌 노략물을 얻지 못하였으랴 ? 그것을 나누지 못하였으랴 ? 사람마다 한 두 처녀를 얻었으리로다 시스라는 채색옷을 노략하였으리니 그것은 수놓은 채색옷이리로다 곧 양편에 수놓은 채 색옷이리니 노략한 자의 목에 꾸미리로다' 하였으리라 ");
INSERT INTO kor_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","여호와여 ! 주의 대적은 다 이와 같이 망하게 하시고 주를 사랑하는 자는 해가 힘있게 돋음 같게 하시옵소서 ! 하니라 그 땅이 사십 년동안 태평하였더라 ");
INSERT INTO kor_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","이스라엘 자손이 또 여호와의 목전에 악을 행하였으므로 여호와께서 칠년 동안 그들을 미디안의 손에 붙이시니 ");
INSERT INTO kor_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","미디안의 손이 이스라엘을 이긴지라 이스라엘 자손이 미디안을 인하여 산에서 구멍과 굴과 산성을 자기를 위하여 만들었으며 ");
INSERT INTO kor_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","이스라엘이 파종한 때면 미디안 사람, 아말렉 사람, 동방 사람이 치러 올라와서 ");
INSERT INTO kor_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","진을 치고 가사에 이르도록 토지 소산을 멸하여 이스라엘 가운데 식물을 남겨두지 아니하며 양이나 소나 나귀도 남기지 아니하니 ");
INSERT INTO kor_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","이는 그들이 그 짐승과 장막을 가지고 올라와서 메뚜기떼 같이 들어오니 그 사람과 약대가 무수함이라 그들이 그 땅에 들어와 멸하려 하니 ");
INSERT INTO kor_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","이스라엘이 미디안을 인하여 미약함이 심한지라 이에 이스라엘 자손이 여호와께 부르짖었더라 ");
INSERT INTO kor_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","이스라엘 자손이 미디안을 인하여 여호와께 부르짖은 고로 ");
INSERT INTO kor_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","여호와께서 이스라엘 자손에게 한 선지자를 보내사 그들에게 이르되 이스라엘 하나님 여호와의 말씀에 내가 너희를 애굽에서 인도하여 내며 너희를 그 종 되었던 집에서 나오게 하여 ");
INSERT INTO kor_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","애굽 사람의 손과 너희를 학대하는 모든 자의 손에서 너희를 건져 내고 그들을 너희 앞에서 쫓아내고 그 땅을 너희에게 주었으며 ");
INSERT INTO kor_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","내가 또 너희에게 이르기를 나는 너희 하나님 여호와니 너희의 거하는 아모리 사람의 땅의 신들을 두려워 말라 하였으나 너희가 내 목소리를 청종치 아니하였느니라 하셨다 하니라 ");
INSERT INTO kor_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","여호와의 사자가 아비에셀 사람 요아스에게 속한 오브라에 이르러 상수리나무 아래 앉으니라 마침 요아스의 아들 기드온이 미디안 사람에게 알리지 아니하려 하여 밀을 포도주 틀에서 타작하더니 ");
INSERT INTO kor_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","여호와의 사자가 기드온에게 나타나 이르되 `큰 용사여 ! 여호와께서 너와 함께 계시도다' ");
INSERT INTO kor_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","기드온이 그에게 대답하되 `나의 주여 ! 여호와께서 우리와 함께 계시면 어찌하여 이 모든 일이 우리에게 미쳤나이까 또 우리 열조가 일찍 우리에게 이르기를 여호와께서 우리를 애굽에서 나오게 하신 것이 아니냐 한 그 모든 이적이 어디 있나이까 ? 이제 여호와께서 우리를 버리사 미디안의 손에 붙이셨나이다' ");
INSERT INTO kor_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","여호와께서 그를 돌아보아 가라사대 너는 이 네 힘을 의지하고 가서 이스라엘을 미디안의 손에서 구원하라 내가 너를 보낸 것이 아니냐 ? ");
INSERT INTO kor_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","기드온이 그에게 대답하되 `주여 ! 내가 무엇으로 이스라엘을 구원하리이까 ? 보소서 ! 나의 집은 므낫세 중에 극히 약하고 나는 내 아비 집에서 제일 작은 자니이다' ");
INSERT INTO kor_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","여호와께서 그에게 이르시되 내가 반드시 너와 함께 하리니 네가 미디안 사람 치기를 한 사람을 치듯 하리라 ");
INSERT INTO kor_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","기드온이 그에게 대답하되 `내가 주께 은혜를 얻었사오면 나와 말씀하신 이가 주 되시는 표징을 내게 보이소서 ! ");
INSERT INTO kor_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","내가 예물을 가지고 다시 주께로 와서 그것을 주 앞에 드리기까지 이곳을 떠나지 마시기를 원하나이다' 그가 가로되 `내가 너 돌아오기를 기다리리라' ");
INSERT INTO kor_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","기드온이 가서 염소 새끼 하나를 준비하고 가루 한 에바로 무교 전병을 만들고 고기를 소쿠리에 담고 국을 양푼에 담아서 상수리나무 아래 그에게로 가져다가 드리매 ");
INSERT INTO kor_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","하나님의 사자가 그에게 이르되 `고기와 무교전병을 가져 이 반석 위에 두고 그 위에 국을 쏟으라' 기드온이 그대로 하니 ");
INSERT INTO kor_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","여호와의 사자가 손에 잡은 지팡이 끝을 내밀어 고기와 무교전병에 대매 불이 반석에서 나와 고기와 무교전병을 살랐고 여호와의 사자는 떠나서 보이지 아니한지라 ");
INSERT INTO kor_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","기드온이 그가 여호와의 사자인줄 알고 가로되 `슬프도소이다 주 여호와여 ! 내가 여호와의 사자를 대면하여 보았나이다' ");
INSERT INTO kor_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","여호와께서 그에게 이르시되 너는 안심하라 ! 두려워 말라 ! 죽지 아니하리라 ! 하시니라 ");
INSERT INTO kor_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","기드온이 여호와를 위하여 거기서 단을 쌓고 이름을 `여호와 살롬'이라 하였더라 그것이 오늘까지 아비에셀 사람에게 속한 오브라에 있더라 ");
INSERT INTO kor_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","이날 밤에 여호와께서 기드온에게 이르시되 네 아비의 수소 곧 칠년된 둘째 수소를 취하고 네 아비에게 있는 바알의 단을 헐며 단 곁의 아세라 상을 찍고 ");
INSERT INTO kor_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","또 이 견고한 성 위에 네 하나님 여호와를 위하여 규례대로 한 단을 쌓고 그 둘째 수소를 취하여 네가 찍은 아세라나무로 번제를 드릴지니라 ");
INSERT INTO kor_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","이에 기드온이 종 열을 데리고 여호와의 말씀하신 대로 행하되 아비의 가족과 그 성읍 사람들을 두려워하므로 이 일을 감히 백주에 행하지 못하고 밤에 행하니라 ");
INSERT INTO kor_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","성읍 사람들이 아침에 일찌기 일어나 본즉 바알의 단이 훼파되었으며 단 곁의 아세라가 찍혔고 새로 쌓은 단 위에 그 둘째 수소를 드렸는지라 ");
INSERT INTO kor_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","서로 물어 가로되 `이것이 누구의 소위인고' 하고 그들이 캐어 물은 후에 가로되 `요아스의 아들 기드온이 이를 행하였도다' 하고 ");
INSERT INTO kor_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","성읍 사람들이 요아스에게 이르되 `네 아들을 끌어내라 그는 당연히 죽을지니 이는 바알의 단을 훼파하고 단 곁의 아세라를 찍었음이니라' ");
INSERT INTO kor_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","요아스가 자기를 둘러선 모든 자에게 이르되 `너희가 바알을 위하여 쟁론 하느냐 ? 너희가 바알을 구원 하겠느냐 ? 그를 위하여 쟁론하는 자는 이 아침에 죽음을 당하리라 바알이 과연 신(神)일진대 그 단을 훼파하였은즉 스스로 쟁론할 것이니라' 하니라 ");
INSERT INTO kor_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","그 날에 기드온을 여룹바알이라 하였으니 이는 그가 바알의 단을 훼파하였은즉 바알이 더불어 쟁론할 것이라 함이었더라 ");
INSERT INTO kor_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","때에 미디안 사람과 아말렉 사람과 동방 사람들이 다 모여 요단을 건너와서 이스르엘 골짜기에 진을 친지라 ");
INSERT INTO kor_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","여호와의 신이 기드온에게 강림하시니 기드온이 나팔을 불매 아비에셀 족속이 다 모여서 그를 좇고 ");
INSERT INTO kor_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","기드온이 또 사자를 온 므낫세에 두루 보내매 그들도 모여서 그를 좇고 또 사자를 아셀과 스불론과 납달리에 보내매 그 무리도 올라와서 그를 영접하더라 ");
INSERT INTO kor_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","기드온이 하나님께 여짜오되 `주께서 이미 말씀하심같이 내 손으로 이스라엘을 구원하려 하시거든 ");
INSERT INTO kor_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","보소서 ! 내가 양털 한 뭉치를 타작마당에 두리니 이슬이 양털에만 있고 사면 땅은 마르면 주께서 이미 말씀하심 같이 내 손으로 이스라엘을 구원하실 줄 내가 알겠나이다' 하였더니 ");
INSERT INTO kor_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","그대로 된지라 이튿날 기드온이 일찌기 일어나서 양털을 취하여 이슬을 짜니 물이 그릇에 가득하더라 ");
INSERT INTO kor_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","기드온이 또 하나님께 여짜오되 `주여, 내게 진노하지 마옵소서 ! 내가 이번만 말하리이다 구하옵나니 나로 다시 한번 양털로 시험하게 하소서 양털만 마르고 사면 땅에는 다 이슬이 있게 하옵소서' 하였더니 ");
INSERT INTO kor_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","이 밤에 하나님이 그대로 행하시니 곧 양털만 마르고 사면 땅에는 다 이슬이 있었더라 ");
INSERT INTO kor_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","여룹바알이라 하는 기드온과 그를 좇은 모든 백성이 일찌기 일어나서 하롯샘 곁에 진쳤고 미디안의 진은 그들의 북편이요 모레산 앞 골짜기에 있었더라 ");
INSERT INTO kor_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","여호와께서 기드온에게 이르시되 너를 좇은 백성이 너무 많은즉 내가 그들의 손에 미디안 사람을 붙이지 아니하리니 이는 이스라엘이 나를 거스려 자긍하기를 내 손이 나를 구원하였다 할까 함이니라 ");
INSERT INTO kor_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","이제 너는 백성의 귀에 고하여 이르기를 누구든지 두려워서 떠는 자여든 길르앗산에서 떠나 돌아가라 하라 하시니 이에 돌아간 백성이 이만 이천명이요 남은 자가 일만명이었더라 ");
INSERT INTO kor_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","여호와께서 또 기드온에게 이르시되 백성이 아직도 많으니 그들을 인도하여 물가로 내려가라 거기서 내가 너를 위하여 그들을 시험하리라 무릇 내가 누구를 가리켜 이르기를 이가 너와 함께 가리라 하면 그는 너와 함께 갈 것이요 내가 누구를 가리켜 이르기를 이는 너와 함께 가지 말 것이니라 하면 그는 가지 말것이니라 ");
INSERT INTO kor_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","이에 백성을 인도하여 물가에 내려가매 여호와께서 기드온에게 이르시되 무릇 개의 핥는 것같이 그 혀로 물을 핥는 자는 너는 따로 세우고 또 무릇 무릎을 꿇고 마시는 자도 그같이 하라 하시더니 ");
INSERT INTO kor_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","손으로 움켜 입에 대고 핥는 자의 수는 삼백명이요 그 외의 백성은 다 무릎을 꿇고 물을 마신지라 ");
INSERT INTO kor_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","여호와께서 기드온에게 이르시되 내가 이 물을 핥아 먹은 삼백명으로 너희를 구원하며 미디안 사람을 네 손에 붙이리니 남은 백성은 각각 그 처소로 돌아갈 것이니라 하시니 ");
INSERT INTO kor_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","이에 백성이 양식과 나팔을 손에 든지라 기드온이 이스라엘의 모든 사람을 각각 그 장막으로 돌려보내고 그 삼백명은 머물러 두 나라 미디안 진은 그 아래 골짜기 가운데 있었더라 ");
INSERT INTO kor_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","이 밤에 여호와께서 기드온에게 이르시되 일어나 내려가서 적진을 치라 내가 그것을 네 손에 붙였느니라 ");
INSERT INTO kor_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","만일 네가 내려가기를 두려워 하거든 네 부하 부라를 데리고 그 진으로 내려가서 ");
INSERT INTO kor_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","그들의 하는 말을 들으라 그 후에 네 손이 강하여져서 능히 내려가서 그 진을 치리라 기드온이 이에 그 부하 부라를 데리고 군대가 있는 진 가에 내려간즉 ");
INSERT INTO kor_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","미디안 사람과 아말렉 사람과 동방의 모든 사람이 골짜기에 누웠는데 메뚜기의 중다함 같고 그 약대의 무수함이 해변의 모래가 수다함 같은지라 ");
INSERT INTO kor_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","기드온이 그 곳에 이른즉 어떤 사람이 그 동무에게 꿈을 말하여 이르기를 `내가 한 꿈을 꾸었는데 꿈에 보리떡 한 덩어리가 미디안 진으로 굴러 들어와서 한 장막에 이르러 그것을 쳐서 무너뜨려 엎드러뜨리니 곧 쓰러지더라' ");
INSERT INTO kor_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","그 동무가 대답하여 가로되 `이는 다른 것이 아니라 이스라엘 사람 요아스의 아들 기드온의 칼날이라 하나님이 미디안과 그 모든 군대를 그의 손에 붙이셨느니라' 하더라 ");
INSERT INTO kor_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","기드온이 그 꿈과 해몽하는 말을 듣고 경배하고 이스라엘 진중에 돌아와서 이르되 `일어나라 ! 여호와께서 미디안 군대를 너희 손에 붙이셨느니라' 하고 ");
INSERT INTO kor_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","삼백명을 세 대로 나누고 각 손에 나팔과 빈 항아리를 들리고 항아리 안에는 횃불을 감추게 하고 ");
INSERT INTO kor_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","그들에게 이르되 `너희는 나만 보고 나의 하는대로 하되 내가 그 진가에 이르러서 하는대로 너희도 그리하여 ");
INSERT INTO kor_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","나와 나를 좇는 자가 다 나팔을 불거든 너희도 그 진 사면에서 또한 나팔을 불며 이르기를 여호와를 위하라 ! 기드온을 위하라 ! 하라' 하니라 ");
INSERT INTO kor_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","기드온과 그들을 좇은 일백명이 이경 초에 진 가에 이른즉 번병의 체번할 때라 나팔을 불며 손에 가졌던 항아리를 부수니라 ");
INSERT INTO kor_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","세 대가 나팔을 불며 항아리를 부수고 좌수에 횃불을 들고 우수에 나팔을 들어 불며 외쳐 가로되 `여호와와 기드온의 칼이여 !' 하고 ");
INSERT INTO kor_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","각기 당처에 서서 그 진을 사면으로 에워싸매 그 온 적군이 달음질하고 부르짖으며 도망하였는데 ");
INSERT INTO kor_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","삼백명이 나팔을 불 때에 여호와께서 그 온 적군으로 동무끼리 칼날로 치게 하시므로 적군이 도망하여 스레라의 벧 싯다에 이르고 또 답밧에 가까운 아벨므홀라의 경계에 이르렀으며 ");
INSERT INTO kor_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","이스라엘 사람들은 납달리와 아셀과 므낫세에서부터 모여서 미디안 사람을 쫓았더라 ");
INSERT INTO kor_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","기드온이 사자를 보내어 에브라임 온 산지로 두루 행하게 하여 이르기를 내려와서 미디안 사람을 치고 그들을 앞질러 벧 바라와 요단에 이르기까지 나루턱을 취하라 하매 이에 에브라임 사람들이 다 모여서 벧 바라와 요단에 이르기까지 그 나루턱을 취하고 ");
INSERT INTO kor_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","또 미디안 두 방백 오렙과 스엡을 사로잡아 오렙은 오렙 바위에서 죽이고 스엡은 스엡 포도주 틀에서 죽이고 미디안 사람을 추격하고 오렙과 스엡의 머리를 가지고 요단 저편에서 기드온에게로 나아오니라 ");
INSERT INTO kor_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","에브라임 사람들이 기드온에게 이르되 `네가 미디안과 싸우러 갈때에 우리를 부르지 아니하였으니 우리를 이같이 대접함은 어찜이뇨 ?' 하고 크게 다투는지라 ");
INSERT INTO kor_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","기드온이 그들에게 이르되 `나의 이제 행한 일이 너희의 한 것에 비교 되겠느냐 ? 에브라임의 끝물 포도가 아비에셀의 맏물 포도보다 낫지 아니하냐 ? ");
INSERT INTO kor_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","하나님이 미디안 방백 오렙과 스엡을 너희 손에 붙이셨으니 나의 한 일이 어찌 능히 너희의 한것에 비교 되겠느냐 ?` 기드온이 이말을 하매 그들의 노가 풀리니라 ");
INSERT INTO kor_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","기드온과 그 좇은 자 삼백명이 요단에 이르러 건너고 비록 피곤하나 따르며 ");
INSERT INTO kor_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","그가 숙곳 사람들에게 이르되 `나의 종자가 피곤하여 하니 청컨대 그들에게 떡덩이를 주라 나는 미디안 두 왕 세바와 살문나를 따르노라' ");
INSERT INTO kor_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","숙곳 방백들이 가로되 `세바와 살문나의 손이 지금 어찌 네 손에 있관대 우리가 네 군대에게 떡을 주겠느냐 ?' ");
INSERT INTO kor_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","기드온이 가로되 `그러면 여호와께서 세바와 살문나를 내 손에 붙이신 후에 내가 들가시와 찔레로 너희 살을 찢으리라' 하고 ");
INSERT INTO kor_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","거기서 브누엘에 올라가서 그들에게도 그같이 구한즉 브누엘 사람들의 대답도 숙곳 사람들의 대답과 같은지라 ");
INSERT INTO kor_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","기드온이 또 브누엘 사람들에게 일러 가로되 `내가 평안이 돌아올때에 이 망대를 헐리라' 하니라 ");
INSERT INTO kor_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","이 때에 세바와 살문나가 갈골에 있는데 동방 사람의 모든 군대중에 칼 든 자 십 이만명이 죽었고 그들을 좇아 거기 있더라 ");
INSERT INTO kor_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","적군이 안연히 있는 중에 기드온이 노바와 욕브하 동편 장막에 거한 자의 길로 올라가서 적군을 치니 ");
INSERT INTO kor_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","세바와 살문나가 도망하는지라 기드온이 추격하여 미디안 두 왕 세바와 살문나를 사로 잡고 그 온 군대를 파하니라 ");
INSERT INTO kor_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","요아스의 아들 기드온이 헤레스 비탈 전장에서 돌아오다가 ");
INSERT INTO kor_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","숙곳 사람 중 한 소년을 잡아 신문하매 숙곳 방백과 장로 칠십 칠인을 그를 위하여 기록한지라 ");
INSERT INTO kor_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","기드온이 숙곳 사람들에게 이르러 가로되 `너희가 전에 나를 기롱하여 이르기를 세바와 살문나의 손이 지금 어찌 네 손에 있관대 우리가 네 피곤한 사람에게 떡을 주겠느냐 ? 한 그 세바와 살문나를 보라'하고 ");
INSERT INTO kor_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","그 성읍 장로들을 잡고 들가시와 찔레로 숙곳 사람들을 징벌하고 ");
INSERT INTO kor_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","브누엘 망대를 헐며 그 성읍 사람들을 죽이니라 ");
INSERT INTO kor_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","이에 세바와 살문나에게 묻되 `너희가 다볼에서 죽인 자들은 어떠한 자이더뇨' 대답하되 `그들이 너와 같아서 모두 왕자 같더라' ");
INSERT INTO kor_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","가로되 `그들은 내 형제 내 어머니의 아들이니라 내가 여호와의 사심으로 맹세하노니 너희가 만일 그들을 살렸더면 나도 너희를 죽이지 아니하였으리라'하고 ");
INSERT INTO kor_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","그 장자 여델에게 이르되 `일어나 그들을 죽이라` 하였으나 그 소년이 칼을 빼지 못하였으니 이는 아직 어려서 두려워함이었더라 ");
INSERT INTO kor_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","세바와 살문나가 가로되 `네가 일어나 우리를 치라 대저 사람이 어떠하면 그 힘도 그러하니라' 기드온이 일어나서 세바와 살문나를 죽이고 그 약대 목에 꾸몄던 새 달 형상의 장식을 취하니라 ");
INSERT INTO kor_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","때에 이스라엘 사람들이 기드온에게 이르되 `당신이 우리를 미디안의 손에서 구원하셨으니 당신과 당신의 아들과 당신의 손자가 우리를 다스리소서' ");
INSERT INTO kor_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","기드온이 그들에게 이르되 `내가 너희를 다스리지 아니하겠고 나의 아들도 너희를 다스리지 아니할 것이요 여호와께서 너희를 다스리시리라' ");
INSERT INTO kor_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","기드온이 또 그들에게 이르되 `내가 너희에게 한 일을 청구하노니 너희는 각기 탈취한 귀고리를 내게 줄지니라' 하니 그 대적은 이스마엘 사람이므로 금 귀고리가 있었음이라 ");
INSERT INTO kor_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","무리가 대답하되 `우리가 즐거이 드리리이다` 하고 겉옷을 펴고 각기 탈취한 귀고리를 그 가운데 던지니 ");
INSERT INTO kor_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","기드온의 청한 바 금 귀고리 중 수가 금 일천 칠백 세겔이요 그 외에 또 새 달 형상의 장식과 패물과 미디안 왕들의 입었던 자색 의복과 그 약대 목에 둘렀던 사슬이 있었더라 ");
INSERT INTO kor_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","기드온이 그 금으로 에봇 하나를 만들어서 자기의 성읍 오브라에 두었더니 온 이스라엘이 그것을 음란하게 위하므로 그것이 기드온과 그 집에 올무가 되니라 ");
INSERT INTO kor_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","미디안이 이스라엘 자손 앞에 복종하여 다시는 그 머리를 들지 못하였으므로 기드온의 사는 날 동안 사십년에 그 땅이 태평하였더라 ");
INSERT INTO kor_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","요아스의 아들 여룹바알이 돌아가서 자기 집에 거하였는데 ");
INSERT INTO kor_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","기드온이 아내가 많으므로 몸에서 낳은 아들이 칠십인이였고 ");
INSERT INTO kor_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","세겜에 있는 첩도 아들을 낳았으므로 그 이름을 아비멜렉이라 하였더라 ");
INSERT INTO kor_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","요아스의 아들 기드온이 나이 많아 죽으매 아비에셀 사람의 오브라에 있는 그의 아비 요아스의 묘실에 장사하였더라 ");
INSERT INTO kor_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","기드온이 이미 죽으매 이스라엘 자손이 돌이켜 바알들을 음란하게 위하고 또 바알브릿을 자기들의 신으로 삼고 ");
INSERT INTO kor_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","사면 모든 대적의 손에서 자기들을 건져내신 여호와 자기들의 하나님을 기억지 아니하며 ");
INSERT INTO kor_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","또 여룹바알이라 하는 기드온의 이스라엘에게 베푼 모든 은혜를 따라서 그의 집을 후대치도 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","여룹바알의 아들 아비멜렉이 세겜에 가서 그 어미의 형제에게 이르러 그들과 외조부의 온 가족에게 말하여 가로되 ");
INSERT INTO kor_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","`청하노니 너희는 세겜 사람들의 귀에 말하라 여룹바알의 아들 칠십인이 다 너희를 다스림과 한 사람이 너희를 다스림이 어느 것이 너희에게 나으냐 ? 또 나는 너희의 골육지친임을 생각하라' ");
INSERT INTO kor_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","그 어미의 형제들이 그를 위하여 이 모든 말을 온 세겜 사람들의 귀에 고하매 그들의 마음이 아비멜렉에게로 기울어서 말하기를 `그는 우리 형제라' 하고 ");
INSERT INTO kor_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","바알브릿 묘에서 은 칠십 개를 내어 그에게 주매 아비멜렉이 그것으로 방탕하고 경박한 유를 사서 자기를 좇게 하고 ");
INSERT INTO kor_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","오브라에 있는 그 아비의 집으로 가서 여룹바알의 아들 곧 자기 형제 칠십인을 한 반석 위에서 죽였으되 오직 여룹바알의 말째 아들 요담은 스스로 숨었으므로 남으니라 ");
INSERT INTO kor_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","세겜 모든 사람과 밀로 모든 족속이 모여 가서 세겜에 있는 기둥 상수리나무 아래서 아비멜렉으로 왕을 삼으니라 ");
INSERT INTO kor_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","혹이 요담에게 그 일을 고하매 요담이 그리심산 꼭대기로 가서 서서 소리를 높이 외쳐 그들에게 이르되 세겜 사람들아 나를 들으라 그리하여야 하나님이 너희를 들으시리라 ");
INSERT INTO kor_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","하루는 나무들이 나가서 기름을 부어 왕을 삼으려 하여 감람나무에게 이르되 `너는 우리 왕이 되라' 하매 ");
INSERT INTO kor_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","감람나무가 그들에게 이르되 `나의 기름은 하나님과 사람을 영화롭게 하나니 내가 어찌 그것을 버리고 가서 나무들 위에 요동하리요' 한지라 ");
INSERT INTO kor_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","나무들이 또 무화과나무에게 이르되 `너는 와서 우리의 왕이 되라' 하매 ");
INSERT INTO kor_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","무화과나무가 그들에게 이르되 `나의 단것, 나의 아름다운 실과를 내가 어찌 버리고 가서 나무들 위에 요동하리요' 한지라 ");
INSERT INTO kor_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","나무들이 또 포도나무에게 이르되 `너는 와서 우리의 왕이 되라' 하매 ");
INSERT INTO kor_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","포도나무가 그들에게 이르되 `하나님과 사람을 기쁘게 하는 나의 새 술을 내가 어찌 버리고 가서 나무들 위에 요동하리요' 한지라 ");
INSERT INTO kor_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","이에 모든 나무가 가시나무에게 이르되 `너는 와서 우리의 왕이 되라` 하매 ");
INSERT INTO kor_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","가시나무가 나무들에게 이르되 `너희가 참으로 내게 기름을 부어 너희 왕을 삼겠거든 와서 내 그늘에 피하라 그리하지 아니하면 불이 가시나무에서 나와서 레바논의 백향목을 사를 것이니라' 하였느니라 ");
INSERT INTO kor_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","이제 너희가 아비멜렉을 세워 왕을 삼았으니 너희 행한것이 과연 진실하고 의로우냐 ? 이것이 여룹바알과 그 집을 선대함이냐 이것이 그 행한대로 그에게 보답함이냐 ? ");
INSERT INTO kor_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","우리 아버지가 전에 죽음을 무릅쓰고 너희를 위하여 싸워 미디안의 손에서 너희를 건져내었거늘 ");
INSERT INTO kor_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","너희가 오늘날 일어나서 우리 아버지의 집을 쳐서 그 아들 칠십인을 한 반석 위에서 죽이고 그 여종의 아들 아비멜렉이 너희 형제가 된다고 그를 세워 세겜 사람의 왕을 삼았도다 ");
INSERT INTO kor_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","만일 너희가 오늘날 여룹바알과 그 집을 대접한 것이 진실과 의로움이면 너희가 아비멜렉을 인하여 즐길 것이요 아비멜렉도 너희를 인하여 즐기려니와 ");
INSERT INTO kor_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","그렇지 아니하면 아비멜렉에게서 불이 나와서 세겜 사람들과 밀로 족속을 사를 것이요 세겜 사람들과 밀로 족속에게서도 불이 나와서 아비멜렉을 사를 것이니라 하고 ");
INSERT INTO kor_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","요담이 그 형제 아비멜렉을 두려워하여 달려 도망하여 브엘로 가서 거기 거하니라 ");
INSERT INTO kor_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","아비멜렉이 이스라엘을 다스린지 삼년에 ");
INSERT INTO kor_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","하나님이 아비멜렉과 세겜 사람들 사이에 악한 신을 보내시매 세겜 사람들이 아비멜렉을 배반하였으니 ");
INSERT INTO kor_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","이는 여룹바알의 아들 칠십인에게 행한 포학한 일을 갚되 그 형제를 죽여 피 흘린 죄를 아비멜렉과 아비멜렉의 손을 도와서 그 형제를 죽이게 한 세겜 사람에게로 돌아가게 하심이라 ");
INSERT INTO kor_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","세겜 사람들이 산들 꼭대기에 사람을 매복하여 아비멜렉을 엿보게 하고 무릇 그 길로 지나는 자를 다 겁탈하게 하니 혹이 그것을 아비멜렉에게 고하니라 ");
INSERT INTO kor_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","에벳의 아들 가알이 그 형제로 더불어 세겜에 이르니 세겜 사람들이 그를 의뢰하니라 ");
INSERT INTO kor_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","그들이 밭에 가서 포도를 거두어다가 밟아 짜서 연회를 배설하고 그 신당에 들어가서 먹고 마시며 아비멜렉을 저주하니 ");
INSERT INTO kor_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","에벳의 아들 가알이 가로되 `아비멜렉은 누구며 세겜은 누구기에 우리가 아비멜렉을 섬기리요 그가 여룹바알의 아들이 아니냐 그 장관은 스불이 아니냐 차라리 세겜의 아비 하몰의 후손을 섬길 것이라 우리가 어찌 아비멜렉을 섬기리요 ");
INSERT INTO kor_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","아하, 이 백성이 내 수하에 있었더면 내가 아비멜렉을 제하였으리라' 하고 아비멜렉에게 네 군대를 더하고 나오라고 말하니라 ");
INSERT INTO kor_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","그 성읍 장관 스불이 에벳의 아들 가알의 말을 듣고 노하여 ");
INSERT INTO kor_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","사자를 아비멜렉에게 가만히 보내어 가로되 `보소서 에벳의 아들 가알과 그 형제가 세겜에 이르러 성읍 무리를 충동하여 당신을 대적하게 하나니 ");
INSERT INTO kor_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","당신은 당신을 좇은 백성으로 더불어 밤에 일어나서 밭에 매복하였다가 ");
INSERT INTO kor_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","아침 해 뜰 때에 당신은 일찌기 일어나 이 성읍을 엄습하면 가알과 그를 좇은 백성이 나와서 당신을 대적하리니 당신은 기회를 보아 그들에게 행하소서' ");
INSERT INTO kor_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","아비멜렉과 그를 좇은 모든 백성이 밤에 일어나 네 떼로 나눠 세겜을 대하여 매복하였더니 ");
INSERT INTO kor_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","에벳의 아들 가알이 나와서 성읍 문 입구에 설 때에 아비멜렉과 그를 좇은 백성이 매복하였던 곳에서 일어난지라 ");
INSERT INTO kor_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","가알이 그 백성을 보고 스불에게 이르되 `보라 ! 백성이 산 꼭대기에서부터 내려오는도다' 스불이 그에게 대답하되 `네가 산(山) 그림자를 사람으로 보았느니라' ");
INSERT INTO kor_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","가알이 다시 말하여 가로되 `보라 ! 백성이 밭 가운데로 좇아 내려오고 또 한 떼는 므오느님 상수리나무 길로 좇아 오는도다' ");
INSERT INTO kor_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","스불이 그에게 이르되 `네가 전에 말하기를 아비멜렉이 누군데 우리가 그를 섬기리요 하던 그 입이 이제 어디 있느냐 이가 너의 업신여기던 백성이 아니냐 청하노니 이제 나가서 그들과 싸우라' ");
INSERT INTO kor_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","가알이 세겜 사람들의 앞서 나가서 아비멜렉과 싸우다가 ");
INSERT INTO kor_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","아비멜렉에게 쫓겨 그 앞에서 도망하였고 상하여 엎드러진 자가 많아서 성문 입구까지 이르렀더라 ");
INSERT INTO kor_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","아비멜렉은 아루마에 거하고 스불은 가알과 그 형제를 쫓아내어 세겜에 거하지 못하게 하더니 ");
INSERT INTO kor_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","이튿날 백성이 밭으로 나오매 혹이 그것을 아비멜렉에게 고하니라 ");
INSERT INTO kor_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","아비멜렉이 자기 백성을 세 떼로 나눠 밭에 매복하였더니 백성이 성에서 나오는 것을 보고 일어나서 그들을 치되 ");
INSERT INTO kor_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","아비멜렉과 그를 좇은 떼는 앞으로 달려가서 성문 입구에 서고 그 나머지 두 떼는 밭에 있는 모든 자에게 달려들어 그들을 죽이니 ");
INSERT INTO kor_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","아비멜렉이 그날 종일토록 그 성을 쳐서 필경은 취하고 거기 있는 백성을 죽이며 그 성을 헐고 소금을 뿌리니라 ");
INSERT INTO kor_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","세겜 망대의 사람들이 이를 듣고 엘브릿 신당의 보장으로 들어갔더니 ");
INSERT INTO kor_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","세겜 망대의 모든 사람의 모인 것이 아비멜렉에게 들리매 ");
INSERT INTO kor_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","아비멜렉과 그를 좇은 모든 백성이 살몬산에 오르고 아비멜렉이 손에 도끼를 들고 나무가지를 찍고 그것을 가져 자기 어깨에 메고 좇은 백성에게 이르되 `너희는 나의 행하는 것을 보나니 빨리 나와 같이 행하라' 하니 ");
INSERT INTO kor_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","모든 백성도 각각 나무가지를 찍어서 아비멜렉을 좇아 보장에 대어 놓고 그곳에 불을 놓으매 세겜 망대에 있는 사람들도 다 죽었으니 남녀가 대략 일천명이었더라 ");
INSERT INTO kor_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","아비멜렉이 데베스에 가서 데베스를 대하여 진 치고 그것을 취하였더니 ");
INSERT INTO kor_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","성중에 견고한 망대가 있으므로 그 성 백성의 남녀가 모두 그리로 도망하여 들어가서 문을 잠그고 망대 꼭대기로 올라간지라 ");
INSERT INTO kor_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","한 여인이 맷돌 윗짝을 아비멜렉의 머리 위에 내려던져 그 두골을 깨뜨리니 ");
INSERT INTO kor_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","아비멜렉이 자기의 병기 잡은 소년을 급히 불러 그에게 이르되 `너는 칼을 빼어 나를 죽이라 사람들이 나를 가리켜 이르기를 그가 여인에게 죽었다 할까 하노라' 소년이 찌르매 그가 곧 죽은지라 ");
INSERT INTO kor_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","이스라엘 사람들이 아비멜렉의 죽은 것을 보고 각각 자기 처소로 떠나갔더라 ");
INSERT INTO kor_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","아비멜렉이 그 형제 칠십인을 죽여 자기 아비에게 행한 악을 하나님이 이같이 갚으셨고 ");
INSERT INTO kor_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","또 세겜 사람들의 모든 악을 하나님이 그들의 머리에 갚으셨으니 여룹바알의 아들 요담의 저주가 그들에게 응하니라 ");
INSERT INTO kor_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","아비멜렉의 후에 잇사갈 사람 도도의 손자 부아의 아들 돌라가 일어나서 이스라엘을 구원하니라 그가 에브라임 산지 사밀에 거하여 ");
INSERT INTO kor_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","이스라엘의 사사가 된지 이십 삼년만에 죽으매 사밀에 장사되었더라 ");
INSERT INTO kor_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","그 후에 길르앗 사람 야일이 일어나서 이십 이년 동안 이스라엘의 사사가 되니라 ");
INSERT INTO kor_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","그에게 아들 삼십이 있어 어린 나귀 삼십을 탔고 성읍 삼십을 두었었는데 그 성들은 길르앗 땅에 있고 오늘까지 하봇야일이라 칭하더라 ");
INSERT INTO kor_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","야일이 죽으매 가몬에 장사되었더라 ");
INSERT INTO kor_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","이스라엘 자손이 다시 여호와의 목전에 악을 행하여 바알들과, 아스다롯과, 아람의 신들과, 시돈의 신들과, 모압의 신들과, 암몬 자손의 신들과, 블레셋 사람의 신들을 섬기고 여호와를 버려 그를 섬기지 아니하므로 ");
INSERT INTO kor_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","여호와께서 이스라엘에게 진노하사 블레셋 사람의 손과 암몬 자손의 손에 파시매 ");
INSERT INTO kor_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","그들이 그 해부터 이스라엘 자손을 학대하니 요단 저편 길르앗 아모리 사람의 땅에 거한 이스라엘 자손이 십팔년 동안 학대를 당하였고 ");
INSERT INTO kor_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","암몬 자손이 또 요단을 건너서 유다와 베냐민과 에브라임 족속을 치므로 이스라엘의 곤고가 심하였더라 ");
INSERT INTO kor_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","이스라엘 자손이 여호와께 부르짖어 가로되 `우리가 우리 하나님을 버리고 바알들을 섬김으로 주께 범죄하였나이다' ");
INSERT INTO kor_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","여호와께서 이스라엘 자손에게 이르시되 내가 애굽 사람과, 아모리 사람과, 암몬 자손과, 블레셋 사람에게서 너희를 구원하지 아니하였느냐 ? ");
INSERT INTO kor_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","또 시돈 사람과 아말렉 사람과 마온 사람이 너희를 압제할 때에 너희가 내게 부르짖으므로 내가 너희를 그들의 손에서 구원하였거늘 ");
INSERT INTO kor_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","너희가 나를 버리고 다른 신들을 섬기니 그러므로 내가 다시는 너희를 구원치 아니하리라 ");
INSERT INTO kor_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","가서 너희가 택한 신들에게 부르짖어서 환난 때에 그들로 너희를 구원하게 하라 ");
INSERT INTO kor_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","이스라엘 자손이 여호와께 여짜오되 `우리가 범죄하였사오니 주의 보시기에 좋은대로 우리에게 행하시려니와 오직 주께 구하옵나니 오늘날 우리를 건져 내옵소서 !' 하고 ");
INSERT INTO kor_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","자기 가운데서 이방 신들을 제하여 버리고 여호와를 섬기매 여호와께서 이스라엘의 곤고를 인하여 마음에 근심하시니라 ");
INSERT INTO kor_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","그 때에 암몬 자손이 모여서 길르앗에 진 쳤으므로 이스라엘 자손도 모여서 미스바에 진 치고 ");
INSERT INTO kor_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","길르앗 백성과 방백들이 서로 이르되 `누가 먼저 나가서 암몬 자손과 싸움을 시작할꼬 그가 길르앗 모든 거민의 머리가 되리라' 하니라 ");
INSERT INTO kor_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","길르앗 사람 큰 용사 입다는 기생이 길르앗에게 낳은 아들이었고 ");
INSERT INTO kor_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","길르앗의 아내도 아들들을 낳았더라 아내의 아들들이 자라매 입다를 쫓아내며 그에게 이르되 `너는 다른 여인의 자식이니 우리 아버지 집 기업을 잇지 못하리라' 한지라 ");
INSERT INTO kor_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","이에 입다가 그 형제를 피하여 돕 땅에 거하매 잡류가 그에게로 모여와서 그와 함께 출입하였더라 ");
INSERT INTO kor_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","얼마 후에 암몬 자손이 이스라엘을 치려 하니라 ");
INSERT INTO kor_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","암몬 자손이 이스라엘을 치려 할 때에 길르앗 장로들이 입다를 데려 오려고 돕 땅에 가서 ");
INSERT INTO kor_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","입다에게 이르되 `우리가 암몬 자손과 싸우려 하나니 당신은 와서 우리의 장관이 되라' ");
INSERT INTO kor_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","입다가 길르앗 장로들에게 이르되 `너희가 전에 나를 미워하여 내 아버지 집에서 쫓아내지 아니하였느냐 ? 이제 너희가 환난을 당하였다고 어찌하여 내게 왔느냐 ?' ");
INSERT INTO kor_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","길르앗 장로들이 대답하되 `이제 우리가 당신을 찾아온 것은 우리와 함께 가서 암몬 자손과 싸우려 하게 함이니 그리하면 우리 길르앗 모든 거민의 머리가 되리라' ");
INSERT INTO kor_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","입다가 길르앗 장로들에게 이르되 `너희가 나를 데리고 본향으로 돌아가서 암몬 자손과 싸우게 할 때에 만일 여호와께서 그들을 네게 붙이시면 내가 과연 너희 머리가 되겠느냐 ?' ");
INSERT INTO kor_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","길르앗 장로들이 입다에게 이르되 `여호와는 우리 사이의 증인이시니 당신의 말대로 우리가 반드시 행하리이다' ");
INSERT INTO kor_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","이에 입다가 길르앗 장로들과 함께 가니 백성이 그로 자기들의 머리와 장관을 삼은지라 입다가 미스바에서 자기의 말을 다 여호와 앞에 고하니라 ");
INSERT INTO kor_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","입다가 암몬 자손의 왕에게 사자를 보내어 이르되 `네가 나와 무슨 상관이 있기에 내 땅을 치러 내게 왔느냐 ?' ");
INSERT INTO kor_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","암몬 자손의 왕이 입다의 사자에게 대답하되 `이스라엘이 애굽에서 올라올 때에 아르논에서부터 얍복과 요단까지 내 땅을 취한 연고니 이제 그것을 화평히 다시 돌리라' ");
INSERT INTO kor_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","입다가 암몬 자손의 왕에게 다시 사자를 보내어 ");
INSERT INTO kor_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","그에게 이르되 `입다가 말하노라 이스라엘이 모압 땅과 암몬 자손의 땅을 취하지 아니하였느니라 ");
INSERT INTO kor_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","이스라엘이 애굽에서 올라올 때에 광야로 행하여 홍해에 이르고 가데스에 이르러서는 ");
INSERT INTO kor_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","이스라엘이 사자를 에돔 왕에게 보내어 이르기를 청컨대 나를 용납하여 네 땅 가운데로 지나게 하라 하였으나 에돔 왕이 이를 듣지 아니하였고 또 그같이 사람을 모압 왕에게 보내었으나 그도 허락지 아니함으로 이스라엘이 아데스에 유하였더니 ");
INSERT INTO kor_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","그후에 광야를 지나 에돔 땅과 모압 땅을 둘러 행하여 모압 땅 동편에서부터 와서 아르논은 모압 경계이므로 그 경내에는 들어가지 아니하였으며 ");
INSERT INTO kor_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","이스라엘이 헤스본 왕 곧 아모리 왕 시혼에게 사자를 보내어 그에게 이르되 청컨대 우리를 용납하여 당신의 땅으로 지나 우리 곳에 이르게 하라 하였으나 ");
INSERT INTO kor_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","시혼이 이스라엘을 믿지 아니하여 그 지경으로 지나지 못하게 할뿐 아니라 그 모든 백성을 모아 야하스에 진 치고 이스라엘을 치므로 ");
INSERT INTO kor_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","이스라엘의 하나님 여호와께서 시혼과 그 모든 백성을 이스라엘의 손에 붙이시매 이스라엘이 쳐서 그 땅 거민 아모리 사람의 온 땅을 취하되 ");
INSERT INTO kor_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","아르논에서부터 얍복까지와 광야에서부터 요단까지 아모리 사람의 온 지경을 취하었느니라 ");
INSERT INTO kor_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","이스라엘 하나님 여호와께서 이같이 아모리 사람을 자기 백성 이스라엘 앞에서 쫓아내셨거늘 네가 그 땅을 얻고자 하는 것이 가하냐 ? ");
INSERT INTO kor_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","네 신 그모스가 네게 주어 얻게 한 땅을 네가 얻지 않겠느냐 ? 우리 하나님 여호와께서 우리 앞에서 어떤 사람이든지 쫓아내시면 그 땅을 우리가 얻으리라 ");
INSERT INTO kor_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","이제 네가 모압 왕 십볼의 아들 발락보다 나은 것이 있느냐 ? 그가 이스라엘로 더불어 다툰 일이 있었느냐 ? 싸운 일이 있었느냐 ? ");
INSERT INTO kor_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","이스라엘이 헤스본과 그 향촌들과 아로엘과 그 향촌들과 아르논 연안에 있는 모든 성읍에 거한지 삼백년이어늘 그동안 너희가 어찌하여 도로 찾지 아니하였느냐 ? ");
INSERT INTO kor_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","내가 네게 죄를 짓지 아니하였거늘 네가 나를 쳐서 내게 악을 행하고자 하는도다 원컨대 심판하시는 여호와는 오늘날 이스라엘 자손과 암몬 자손의 사이에 판결하시옵소서' 하나 ");
INSERT INTO kor_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","암몬 자손의 왕이 입다의 보내어 말한 것을 듣지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","이에 여호와의 신이 입다에게 임하시니 입다가 길르앗과 므낫세를 지나서 길르앗 미스베에 이르고 길르앗 미스베에서부터 암몬 자손들에게로 나아갈 때에 ");
INSERT INTO kor_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","그가 여호와께 서원하여 가로되 `주께서 과연 암몬 자손을 내게 붙이시면 ");
INSERT INTO kor_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","내가 암몬 자손에게서 평안히 돌아올 때에 누구든지 내 집 문에서 나와서 나를 영접하는 그는 여호와께 돌릴 것이니 내가 그를 번제로 드리겠나이다' 하니라 ");
INSERT INTO kor_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","이에 입다가 암몬 자손에게 이르러 그들과 싸우더니 여호와께서 그들을 그 손에 붙이시매 ");
INSERT INTO kor_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","아로엘에서부터 민닛에 이르기까지 이십 성읍을 치고 또 아벨 그라밈까지 크게 도륙하니 이에 암몬 자손이 이스라엘 자손 앞에 항복하였더라 ");
INSERT INTO kor_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","입다가 미스바에 돌아와 자기 집에 이를 때에 그 딸이 소고를 잡고 춤추며 나와서 영접하니 그의 무남독녀라 ");
INSERT INTO kor_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","입다가 이를 보고 자기 옷을 찢으며 가로되 `슬프다, 내 딸이여 ! 너는 나로 하여금 참담케 하는 자요 너는 나를 괴롭게 하는 자 중의 하나이로다 내가 여호와를 향하여 입을 열었으니 능히 돌이키지 못하리로다' ");
INSERT INTO kor_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","딸이 그에게 이르되 `나의 아버지여 ! 아버지께서 여호와를 향하여 입을 여셨으니 아버지 입에서 낸 말씀대로 내게 행하소서 이는 여호와께서 아버지를 위하여 아버지의 대적 암몬 자손에게 원수를 갚으셨음이니이다' ");
INSERT INTO kor_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","아비에게 또 이르되 `이 일만 내게 허락하사 나를 두 달만 용납하소서 내가 나의 동무들과 함께 산에 올라가서 나의 처녀로 죽음을 인하여 애곡하겠나이다' ");
INSERT INTO kor_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","이르되 `가라 !' 하고 두달 위한하고 보내니 그가 동무들과 함께 가서 산 위에서 처녀로 죽음을 인하여 애곡하고 ");
INSERT INTO kor_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","두달만에 그 아비에게로 돌아온지라 아비가 그 서원한 대로 딸에게 행하니 딸이 남자를 알지 못하고 죽으니라 이로부터 이스라엘 가운데 규례가 되어 ");
INSERT INTO kor_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","이스라엘 여자들이 해마다 가서 길르앗 사람 입다의 딸을 위하여 나흘씩 애곡하더라 ");
INSERT INTO kor_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","에브라임 사람들이 모여 북으로 가서 입다에게 이르되 `네가 암몬 자손과 싸우러 건너 갈 때에 어찌하여 우리를 불러 너와 함께 가게 하지 아니하였느냐 ? 우리가 반드시 불로 너와 네 집을 사르리라' ");
INSERT INTO kor_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","입다가 그들에게 이르되 `나와 나의 백성이 암몬 자손과 크게 다툴 때에 내가 너희를 부르되 너희가 나를 그들의 손에서 구원하지 아니하므로 ");
INSERT INTO kor_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","내가 너희의 구원치 아니하는 것을 보고 내 생명을 돌아보지 아니하고 건너가서 암몬 자손을 쳤더니 여호와께서 그들을 내 손에 붙이셨거늘 너희가 어찌하여 오늘날 내게 올라와서 나로 더불어 싸우고자 하느냐 ?' 하고 ");
INSERT INTO kor_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","입다가 길르앗 사람을 다 모으고 에브라임과 싸웠더니 길르앗 사람들이 에브라임을 쳐서 파하였으니 이는 에브라임의 말이 너희 길르앗 사람은 본래 에브라임에서 도망한 자로서 에브라임과 므낫세중에 있다 하였음이라 ");
INSERT INTO kor_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","길르앗 사람이 에브라임 사람 앞서 요단 나루턱을 잡아 지키고 에브라임 사람의 도망하는 자가 말하기를 `청컨대 나로 건너게 하라 하면 그에게 묻기를 네가 에브라임 사람이냐' 하여 그가 만일 `아니라' 하면 ");
INSERT INTO kor_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","그에게 이르기를 십볼렛이라 하라 하여 에브라임 사람이 능히 구음을 바로 하지 못하고 씹볼렛이라면 길르앗 사람이 곧 그를 잡아서 요단 나루턱에서 죽였더라 그 때에 에브라임 사람의 죽은 자가 사만 이천명이었더라 ");
INSERT INTO kor_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","입다가 이스라엘 사사가 된지 육년이라 길르앗 사람 입다가 죽으매 길르앗 한 성읍에 장사되었더라 ");
INSERT INTO kor_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","그의 뒤에는 베들레헴 입산이 이스라엘의 사사이었더라 ");
INSERT INTO kor_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","그가 아들 삼십과 딸 삼십을 두었더니 딸들은 타국으로 시집 보내었고 아들들을 위하여는 타국에서 여자 삼십을 데려왔더라 그가 이스라엘 사사가 된지 칠년이라 ");
INSERT INTO kor_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","입산이 죽으매 베들레헴에 장사되었더라 ");
INSERT INTO kor_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","그의 뒤에는 스불론 사람 엘론이 이스라엘의 사사가 되어 십년 동안 이스라엘을 다스렸더라 ");
INSERT INTO kor_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","스불론 사람 엘론이 죽으매 스불론 땅 아얄론에 장사되었더라 ");
INSERT INTO kor_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","그의 뒤에는 비라돈 사람 힐렐의 아들 압돈이 이스라엘의 사사이었더라 ");
INSERT INTO kor_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","그에게 아들 사십과 손자 삼십이 있어서 어린 나귀 칠십필을 탔었더라 압돈이 이스라엘의 사사가 된지 팔년이라 ");
INSERT INTO kor_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","비라돈 사람 힐렐의 아들 압돈이 죽으매 에브라임 땅 아말렉 사람의 산지 비라돈에 장사되었더라 ");
INSERT INTO kor_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","이스라엘 자손이 다시 여호와의 목전에 악을 행하였으므로 여호와께서 그들을 사십년 동안 블레셋 사람의 손에 붙이시니라 ");
INSERT INTO kor_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","소라 땅에 단 지파의 가족 중 마노아라 이름하는 자가 있더라 그 아내가 잉태하지 못하므로 생산치 못하더니 ");
INSERT INTO kor_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","여호와의 사자가 그 여인에게 나타나시고 그에게 이르시되 `보라 ! 네가 본래 잉태하지 못하므로 생산치 못하였으나 이제 잉태하여 아들을 낳으리니 ");
INSERT INTO kor_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","그러므로 너는 삼가서 포도주와 독주를 마시지 말지며 무릇 부정한 것을 먹지 말지니라 ");
INSERT INTO kor_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","보라 ! 네가 잉태하여 아들을 낳으리니 그 머리에 삭도를 대지 말라 이 아이는 태에서 나옴으로부터 하나님께 바치운 나실인이 됨이라 그가 블레셋 사람의 손에서 이스라엘을 구원하기 시작하리라' ");
INSERT INTO kor_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","이에 그 여인이 가서 그 남편에게 고하여 가로되 `하나님의 사람이 내게 임하였는데 그 용모가 하나님의 사자의 용모 같아서 심히 두려우므로 어디서부터 온 것을 내가 묻지 못하였고 그도 자기 이름을 내게 이르지 아니하였으며 ");
INSERT INTO kor_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","그가 내게 이르기를 보라 네가 잉태하여 아들을 낳으리니 포도주와 독주를 마시지 말며 무릇 부정한 것을 먹지 말라 이 아이는 태에서 나옴으로부터 죽을 날까지 하나님께 바치운 나실인이 됨이라 하더이다' ");
INSERT INTO kor_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","마노아가 여호와께 기도하여 가로되 `주여 구하옵나니 주의 보내셨던 하나님의 사람을 우리에게 다시 임하게 하사 그로 우리가 그 낳을 아이에게 어떻게 행할 것을 우리에게 가르치게 하소서 !' ");
INSERT INTO kor_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","하나님이 마노아의 목소리를 들으시니라 여인이 밭에 앉았을 때에 하나님의 사자가 다시 그에게 임하셨으나 그 남편 마노아는 함께 있지 아니한지라 ");
INSERT INTO kor_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","여인이 급히 달려가서 그 남편에게 고하여 가로되 `보소서 ! 전일에 내게 임하였던 사람이 또 내게 나타났나이다' ");
INSERT INTO kor_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","마노아가 일어나 아내를 따라가서 그 사람에게 이르러 그에게 묻되 당신이 이 여인에게 말씀하신 사람이니이까 ? 가라사대 그로라 ");
INSERT INTO kor_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","마노아가 가로되 `당신의 말씀대로 되기를 원하나이다 이 아이를 어떻게 기르오며 우리가 그에게 어떻게 행하오리이까 ?' ");
INSERT INTO kor_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","여호와의 사자가 마노아에게 이르시되 `내가 여인에게 말한 것들을 그가 다 삼가서 ");
INSERT INTO kor_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","포도나무의 소산을 먹지 말며 포도주와 독주를 마시지 말며 무릇 부정한 것을 먹지 말아서 내가 그에게 명한 것은 다 지킬 것이니라' ");
INSERT INTO kor_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","마노아가 여호와의 사자에게 말씀하되 `구하옵나니 당신은 우리에게 머물러서 우리가 당신을 위하여 염소 새끼 하나를 준비하게 하소서' ");
INSERT INTO kor_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","여호와의 사자가 마노아에게 이르시되 `네가 비록 나를 머물리나 내가 너의 식물을 먹지 아니하리라 번제를 준비하려거든 마땅히 여호와께 드릴지니라' 하니 이는 마노아가 여호와의 사자인 줄 알지 못함을 인함이었더라 ");
INSERT INTO kor_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","마노아가 또 여호와의 사자에게 말씀하되 `당신의 이름이 무엇이니이까 ? 당신의 말씀이 이룰 때에 우리가 당신을 존숭하리이다' ");
INSERT INTO kor_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","여호와의 사자가 그에게 이르시되 `어찌하여 이를 묻느냐 ? 내 이름은 기묘니라' ");
INSERT INTO kor_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","이에 마노아가 염소 새끼 하나와 소제물을 취하여 반석 위에서 여호와께 드리매 사자가 이적을 행한지라 마노아와 그 아내가 본즉 ");
INSERT INTO kor_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","불꽃이 단에서부터 하늘로 올라가는 동시에 여호와의 사자가 단 불꽃 가운데로 좇아 올라간지라 마노아와 그 아내가 이것을 보고 얼굴을 땅에 대고 엎드리니라 ");
INSERT INTO kor_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","여호와의 사자가 마노아와 그 아내에게 다시 나타나지 아니하니 마노아가 이에 그가 여호와의 사자인 줄알고 ");
INSERT INTO kor_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","그 아내에게 이르되 `우리가 하나님을 보았으니 반드시 죽으리로다' ");
INSERT INTO kor_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","그 아내가 그에게 이르되 `여호와께서 우리를 죽이려 하셨더면 우리 손에서 번제와 소제를 받지 아니하셨을 것이며 이제 이런 말씀도 우리에게 이르지 아니하셨으리이다' 하였더라 ");
INSERT INTO kor_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","여인이 아들을 낳으매 이름을 삼손이라 하니라 아이가 자라매 여호와께서 그에게 복을 주시더니 ");
INSERT INTO kor_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","소라와 에스다올 사이 마하네단에서 여호와의 신이 비로소 그에게 감동하시니라 ");
INSERT INTO kor_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","삼손이 딤나에 내려가서 거기서 블레셋 딸 중 한 여자를 보고 ");
INSERT INTO kor_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","도로 올라와서 자기 부모에게 말하여 가로되 `내가 딤나에서 블레셋 사람의 딸 중 한 여자를 보았사오니 이제 그를 취하여 내 아내를 삼게 하소서' ");
INSERT INTO kor_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","부모가 그에게 이르되 `네 형제들의 딸 중에나 내 백성 중에 어찌 여자가 없어서 네가 할례받지 아니한 블레셋 사람에게 가서 아내를 취하려 하느냐 ?' 삼손이 아비에게 이르되 `내가 그 여자를 좋아 하오니 나를 위하여 그를 데려오소서' 하니 ");
INSERT INTO kor_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","이 때에 블레셋 사람이 이스라엘을 관할한고로 삼손이 틈을 타서 블레셋 사람을 치려 함이었으나 그 부모는 이 일이 여호와께서 나온 것인 줄은 알지 못하였더라 ");
INSERT INTO kor_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","삼손이 그 부모와 함께 딤나에 내려가서 딤나의 포도원에 이른즉 어린 사자가 그를 맞아 소리지르는지라 ");
INSERT INTO kor_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","삼손이 여호와의 신에게 크게 감동되어 손에 아무 것도 없어도 그 사자를 염소 새끼를 찢음 같이 찢었으나 그는 그 행한 일을 부모에게도 고하지 아니하였고 ");
INSERT INTO kor_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","그가 내려가서 그 여자와 말하며 그를 기뻐하였더라 ");
INSERT INTO kor_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","얼마 후에 삼손이 그 여자를 취하려고 다시 가더니 돌이켜 그 사자의 주검을 본즉 사자의 몸에 벌떼와 꿀이 있는지라 ");
INSERT INTO kor_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","손으로 그 꿀을 취하여 행하며 먹고 그 부모에게 이르러 그들에게 그것을 드려서 먹게 하였으나 그 꿀을 사자의 몸에서 취하였다고는 고하지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","삼손의 아비가 여자에게로 내려가매 삼손이 거기서 잔치를 배설하였으니 소년은 이렇게 행하는 풍속이 있음이더라 ");
INSERT INTO kor_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","무리가 삼손을 보고 삼십명을 데려다가 동무를 삼아 그와 함께 하게 한지라 ");
INSERT INTO kor_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","삼손이 그들에게 이르되 `이제 내가 너희에게 수수께끼를 하리니 잔치하는 칠일 동안에 너희가 능히 그것을 풀어서 내게 고하면 내가 베옷 삼십 벌과 겉옷 삼십 벌을 너희에게 주리라 ");
INSERT INTO kor_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","그러나 그것을 능히 내게 고하지 못하면 너희가 내게 베옷 삼십벌과 겉옷 삼십 벌을 줄지니라' 그들이 이르되 `너는 수수께끼를 하여 우리로 듣게 하라' ");
INSERT INTO kor_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","삼손이 그들에게 이르되 `먹는자에게서 먹는 것이 나오고 강한 자에게서 단 것이 나왔느니라' 그들이 삼일이 되도록 수수께끼를 풀지 못하였더라 ");
INSERT INTO kor_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","제 칠일에 이르러 그들이 삼손의 아내에게 이로되 `너는 네 남편을 꾀어 그 수수께끼를 우리에게 알리게 하라 그렇지 아니하면 너와 네 아비의 집을 불사르리라 너희가 우리의 소유를 취하고자하여 우리를 청하였느냐 ? 그렇지 아니하냐 ?' ");
INSERT INTO kor_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","삼손의 아내가 그의 앞에서 울며 가로되 `당신이 나를 미워할 뿐이요 사랑치 아니하는도다 우리 민족에게 수수께끼를 말하고 그 뜻을 내게 풀어 이르지 아니하도다' 삼손이 그에게 대답하되 `보라 내가 그것을 나의 부모에게도 풀어 고하지 아니하였거든 어찌 그대에게 풀어 이르리요' 하였으나 ");
INSERT INTO kor_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","칠일 잔치할 동안에 그 아내가 앞에서 울며 강박함을 인하여 제 칠일에는 그가 그 아내에게 수수께끼를 풀어 이르매 그 아내가 그것을 그 민족에게 고하였더라 ");
INSERT INTO kor_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","제 칠일 해 지기 전에 성읍 사람들이 삼손에게 이르되 `무엇이 꿀보다 달겠으며 무엇이 사자보다 강하겠느냐 ?' 한지라 삼손이 그들에게 대답하되 `너희가 내 암송아지로 밭갈지 아니하였더면 나의 수수께끼를 능히 풀지 못하였으리라' 하니라 ");
INSERT INTO kor_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","여호와의 신이 삼손에게 크게 임하시매 삼손이 아스글론에 내려가서 그곳 사람 삼십명을 쳐 죽이고 노략하여 수수께끼 푼 자들 에게 옷을 주고 심히 노하여 아비 집으로 올라갔고 ");
INSERT INTO kor_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","삼손의 아내는 삼손의 친구되었던 그 동무에게 준바 되었더라 ");
INSERT INTO kor_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","얼마 후 밀 거둘 때에 삼손이 염소 새끼를 가지고 그 아내에게로 찾아 가서 가로되 `내가 침실에 들어가 아내를 보고자 하노라' 장인이 들어 오지 못하게 하고 ");
INSERT INTO kor_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","가로되 `네가 그를 심히 미워하는 줄로 내가 생각한 고로 그를 네 동무에게 주었노라 그 동생이 그보다 더욱 아름답지 아니하냐 ? 청하노니 너는 그의 대신에 이를 취하라' ");
INSERT INTO kor_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","삼손이 그들에게 이르되 `이번은 내가 블레셋 사람을 해할지라도 그들에게 대하여 내게 허물이 없을 것이니라' 하고 ");
INSERT INTO kor_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","삼손이 가서 여우 삼백을 붙들어서 그 꼬리와 꼬리를 매고 홰를 취하고 그 두 꼬리 사이에 한 홰를 달고 ");
INSERT INTO kor_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","홰에 불을 켜고 그것을 블레셋 사람의 곡식 밭으로 몰아 들여서 곡식 단과 아직 베지 아니한 곡식과 감람원을 사른지라 ");
INSERT INTO kor_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","블레셋 사람이 가로되 누가 이일을 행하였느냐 ? 혹이 대답하되 딤나 사람의 사위 삼손이니 장인이 삼손의 아내를 취하여 그 동무 되었던 자에게 준 연고니라 블레셋 사람이 올라가서 그 여인과 그의 아비를 불사르니라 ");
INSERT INTO kor_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","삼손이 그들에게 이르되 `너희가 이같이 행하였은즉 내가 너희에게 원수를 갚은 후에야 말리라' 하고 ");
INSERT INTO kor_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","블레셋 사람을 크게 도륙하고 내려가서 에담 바위 틈에 거하니라 ");
INSERT INTO kor_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","이에 블레셋 사람이 올라와서 유다에 진을 치고 레히에 편만한지라 ");
INSERT INTO kor_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","유다 사람들이 가로되 `너희가 어찌하여 올라와서 우리를 치느냐 ?' 그들이 대답하되 `우리가 올라오기는 삼손을 결박하여 그가 우리에게 행한 대로 그에게 행하려 함이로라' ");
INSERT INTO kor_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","유다 사람 삼천명이 에담 바위틈에 내려가서 삼손에게 이르되 `너는 블레셋 사람이 우리를 관할하는 줄을 알지 못하느냐 ? 네가 어찌하여 우리에게 이같이 행하였느냐 ?' 삼손이 그들에게 이르되 `그들이 내게 행한 대로 나도 그들에게 행하였노라' ");
INSERT INTO kor_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","그들이 삼손에게 이르되 `우리가 너를 결박하여 블레셋 사람의 손에 붙이려고 이제 내려왔노라' 삼손이 그들에게 이르되 `너희는 친히 나를 치지 않겠다고 내게 맹세하라' ");
INSERT INTO kor_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","그들이 삼손에게 일러 가로되 `아니라 우리가 다만 너를 단단히 결박하여 그들의 손에 붙일 뿐이요 우리가 결단코 너를 죽이지 아니하리라' 하고 새 줄 둘로 결박하고 바위틈에서 그를 끌어내니라 ");
INSERT INTO kor_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","삼손이 레히에 이르매 블레셋 사람이 그에게로 마주 나가며 소리지르는 동시에 여호와의 신의 권능이 삼손에게 임하매 그 팔 위의 줄이 불탄 삼과 같아서 그 결박되었던 손에서 떨어진지라 ");
INSERT INTO kor_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","삼손이 나귀의 새 턱뼈를 보고 손을 내밀어 취하고 그것으로 일천명을 죽이고 ");
INSERT INTO kor_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","가로되 `나귀의 턱뼈로 한더미 두더미를 쌓았음이여 나귀의 턱뼈로 내가 일천명을 죽였도다' ");
INSERT INTO kor_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","말을 마치고 턱뼈를 그 손에서 내어던지고 그 곳을 라맛 레히라 이름하였더라 ");
INSERT INTO kor_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","삼손이 심히 목마르므로 여호와께 부르짖어 가로되 `주께서 종의 손으로 이 큰 구원을 베푸셨사오나 내가 이제 목말라 죽어서 할례 받지 못한 자의 손에 빠지겠나이다' ");
INSERT INTO kor_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","하나님의 레히에 한 우묵한 곳을 터치시니 물이 거기서 솟아나오는지라 삼손이 그것을 마시고 정신이 회복되어 소생하니 그러므로 그 샘 이름은 엔학고레라 이샘이 레히에 오늘까지 있더라 ");
INSERT INTO kor_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","블레셋 사람의 때에 삼손이 이스라엘 사사로 이십년을 지내었더라 ");
INSERT INTO kor_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","삼손이 가사에 가서 거기서 한 기생을 보고 그에게로 들어갔더니 ");
INSERT INTO kor_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","혹이 가사 사람에게 고하여 가로되 `삼손이 여기 왔다' 하매 곧 그를 에워싸고 밤새도록 성문에 매복하고 밤새도록 종용히 하며 이르기를 `새벽이 되거든 그를 죽이리라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","삼손이 밤 중까지 누웠다가 그 밤 중에 일어나 성문짝들과 두 설주와 빗장을 빼어 그것을 모두 어깨에 메고 헤브론 앞산 꼭대기로 가니라 ");
INSERT INTO kor_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","이 후에 삼손이 소렉 골짜기의 들릴라라 이름하는 여인을 사랑하매 ");
INSERT INTO kor_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","블레셋 사람의 방백들이 그 여인에게로 올라와서 그에게 이르되 삼손을 꾀어서 무엇으로 말미암아 그 큰 힘이 있는지 우리가 어떻게 하면 그를 이기어서 결박하여 곤고케 할수 있을는지 알아보라 그리하면 우리가 각각 은 일천 일백을 네게 주리라 ");
INSERT INTO kor_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","들릴라가 삼손에게 말하되 `청컨대 당신의 큰 힘이 무엇으로 말미암아 있으며 어떻게 하면 능히 당신을 결박하여 곤고케 할 수 있을는지 내게 말하라' ");
INSERT INTO kor_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","삼손이 그에게 이르되 `만일 마르지 아니한 푸른 칡 일곱으로 나를 결박하면 내가 약하여져서 다른 사람과 같으리라' ");
INSERT INTO kor_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","블레셋 사람의 방백들이 마르지 아니한 푸른 칡 일곱을 여인에게로 가져오매 그가 그것으로 삼손을 결박하고 ");
INSERT INTO kor_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","이미 사람을 내실에 매복시켰으므로 삼손에게 말하되 `삼손이여, 블레셋 사람이 당신에게 미쳤느니라'하니 삼손이 그 칡 끊기를 불탄 삼실을 끊음같이 하였고 그 힘의 근본은 여전히 알지 못하니라 ");
INSERT INTO kor_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","들릴라가 삼손에게 이르되 `보라 당신이 나를 희롱하여 내게 거짓말을 하였도다 청컨대 무엇으로 하면 당신을 결박할 수 있을는지 이제는 네게 말하라' ");
INSERT INTO kor_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","삼손이 그에게 이르되 `만일 쓰지 아니한 새 줄로 나를 결박하면 내가 약하여져서 다른 사람과 같으리라' ");
INSERT INTO kor_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","들릴라가 새 줄을 취하고 그것으로 그를 결박하고 그에게 이르되 삼손이여 블레셋 사람이 당신에게 미쳤느니라 하니 삼손이 팔 위의 줄 끊기를 실을 끊음같이 하였고 그 때에도 사람이 내실에 매복하였였더라 ");
INSERT INTO kor_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","들릴라가 삼손에게 이르되 `당신이 이때까지 나를 희롱하여 내게 거짓말을 하였도다 내가 무엇으로 하면 당신을 결박할 수 있을는지 내게 말하라' 삼손이 그에게 이르되 `그대가 만일 나의 머리털 일곱 가닥을 위선에 섞어 짜면 되리라' ");
INSERT INTO kor_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","들릴라가 바디로 그 머리털을 단단히 짜고 그에게 이르되 `삼손이여, 블레셋 사람이 당신에게 미쳤느니라' 하니 삼손이 잠을 깨어 직조틀의 바디와 위선을 다 빼어내니라 ");
INSERT INTO kor_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","들릴라가 삼손에게 이르되 `당신의 마음이 내게 있지 아니하면서 당신이 어찌 나를 사랑한다 하느뇨 ? 당신이 이 세번 나를 희롱하고 당신 큰 힘이 무엇으로 말미암아 있는 것을 말하지 아니하였도다' 하며 ");
INSERT INTO kor_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","날마다 그 말로 그를 재촉하여 조르매 삼손의 마음이 번뇌하여 죽을 지경이라 ");
INSERT INTO kor_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","삼손이 진정을 토하여 그에게 이르되 `내 머리에는 삭도를 대지 아니하였나니 이는 내가 모태에서 하나님의 나실인이 되었음이라 만일 내 머리가 밀리우면 내 힘이 내게서 떠나고 나는 약하여져서 다른 사람과 같으리라' ");
INSERT INTO kor_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","들릴라가 삼손의 진정을 다 토함을 보고 보내어 블레셋 사람의 방백들을 불러 가로되 `삼손이 내게 진정을 토하였으니 이제 한번만 올라오라' 블레셋 방백들이 손에 은을 가지고 여인에게로 올라오니라 ");
INSERT INTO kor_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","들릴라가 삼손으로 자기 무릎을 베고 자게 하고 사람을 불러 그 머리털 일곱 가닥을 밀고 괴롭게 하여 본즉 그 힘이 없어졌더라 ");
INSERT INTO kor_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","들릴라가 가로되 `삼손이여, 블레셋 사람이 당신에게 미쳤느니라' 하니 삼손이 잠을 깨며 이르기를 `내가 전과 같이 나가서 몸을 떨치리라' 하여도 여호와께서 이미 자기를 떠나신 줄을 깨닫지 못하였더라 ");
INSERT INTO kor_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","블레셋 사람이 그를 잡아 그 눈을 빼고 끌고 가사에 내려가 놋줄로 매고 그로 옥 중에서 맷돌을 돌리게 하였더라 ");
INSERT INTO kor_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","그의 머리털이 밀리운 후에 다시 자라기 시작하니라 ");
INSERT INTO kor_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","블레셋 사람의 방백이 가로되 `우리의 신이 우리 원수 삼손을 우리 손에 붙였다' 하고 다 모여 그 신 다곤에게 큰 제사를 드리고 즐거워하고 ");
INSERT INTO kor_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","백성들도 삼손을 보았으므로 가로되 `우리 토지를 헐고 우리 많은 사람을 죽인 원수를 우리의 신이 우리 손에 붙였다' 하고 자기 신을 찬송하며 ");
INSERT INTO kor_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","그들의 마음이 즐거울 때에 이르되 `삼손을 불러다가 우리를 위하여 재주를 부리게 하자' 하고 옥에서 삼손을 불러내매 삼손이 그들을 위하여 재주를 부리니라 그들이 삼손을 두 기둥 사이에 세웠더니 ");
INSERT INTO kor_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","삼손이 자기 손을 붙든 소년에게 이르되 `나로 이 집을 버틴 기둥을 찾아서 그것을 의지하게 하라' 하니라 ");
INSERT INTO kor_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","그 집에는 남녀가 가득하니 블레셋 모든 방백도 거기 있고 지붕에 있는 남녀도 삼천명 가량이라 다 삼손의 재주 부리는 것을 보더라 ");
INSERT INTO kor_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","삼손이 여호와께 부르짖어 가로되 `주 여호와여 구하옵나니 나를 생각하옵소서 하나님이여 구하옵나니 이번만 나로 강하게 하사 블레셋 사람이 나의 두 눈을 뺀 원수를 단번에 갚게 하옵소서 !' 하고 ");
INSERT INTO kor_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","집을 버틴 두 가운데 기둥을 하나는 왼손으로, 하나는 오른손으로 껴 의지하고 ");
INSERT INTO kor_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","가로되 `블레셋 사람과 함께 죽기를 원하노라' 하고 힘을 다하여 몸을 굽히매 그 집이 곧 무너져 그 안에 있는 모든 방백과 온 백성에게 덮이니 삼손이 죽을 때에 죽인 자가 살았을 때에 죽인 자보다 더욱 많았더라 ");
INSERT INTO kor_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","그의 형제와 아비의 온 집이 다 내려가서 그 시체를 취하여 가지고 올라와서 소라와 에스다올 사이 그 아비 마노아의 장지에 장사하니라 삼손이 이스라엘 사사로 이십년을 지내었더라 ");
INSERT INTO kor_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","에브라임 산지에 미가라 이름하는 사람이 있더니 ");
INSERT INTO kor_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","그 어미에게 이르되 `어머니께서 은 일천 일백을 잃어버리셨으므로 저주하시고 내 귀에도 말씀하셨더니 보소서 그 은이 내게 있나이다 내가 그것을 취하였나이다' 어미가 가로되 `내 아들이 여호와께 복 받기를 원하노라' 하니라 ");
INSERT INTO kor_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","미가가 은 일천 일백을 그 어미에게 도로 주매 어미가 가로되 `내가 내 아들을 위하여 한 신상을 새기며 한 신상을 부어만들 차로 내 손에서 이 은을 여호와께 거룩히 드리노라 그러므로 내가 이제 이 은을 네게 도로 돌리리라' ");
INSERT INTO kor_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","미가가 그 은을 어미에게 도로 주었으므로 어미가 그 은 이백을 취하여 은장색에게 주어 한 신상을 새기며 한 신상을 부어 만들었더니 그 신상이 미가의 집에 있더라 ");
INSERT INTO kor_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","이 사람 미가에게 신당이 있으므로 또 에봇과 드라빔을 만들고 한 아들을 세워 제사장을 삼았더라 ");
INSERT INTO kor_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","그 때에는 이스라엘에 왕이 없으므로 사람마다 자기 소견에 옳은 대로 행하였더라 ");
INSERT INTO kor_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","유다 가족에 속한 유다 베들레헴에 한 소년이 있으니 그는 레위인으로서 거기 우거하였더라 ");
INSERT INTO kor_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","이 사람이 거할 곳을 찾고자 하여 그 성읍 유다 베들레헴을 떠나서 행하다가 에브라임 산지로 가서 미가의 집에 이르매 ");
INSERT INTO kor_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","미가가 그에게 묻되 `너는 어디서부터 오느뇨' 그가 이르되 `나는 유다 베들레헴의 레위인으로서 거할 곳을 찾으러 가노라' ");
INSERT INTO kor_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","미가가 그에게 이르되 `네가 나와 함께 거하여 나를 위하여 아비와 제사장이 되라 내가 해마다 은 열과 의복 한 벌과 식물을 주리라' 하므로 레위인이 들어갔더니 ");
INSERT INTO kor_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","레위인이 그 사람과 함께 거하기를 만족히 여겼으니 이는 그 소년이 미가의 아들 중 하나같이 됨이라 ");
INSERT INTO kor_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","미가가 레위인을 거룩히 구별하매 소년이 미가의 제사장이 되어 그 집에 거한지라 ");
INSERT INTO kor_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","이에 미가가 가로되 `레위인이 내 제사장이 되었으니 이제 여호와께서 내게 복 주실 줄을 아노라' 하니라 ");
INSERT INTO kor_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","그 때에 이스라엘에 왕이 없었고 단 지파는 이때에 거할 기업의 땅을 구하는 중이었으니 이는 그들이 이스라엘 지파 중에서 이때까지 기업의 땅 분배함을 얻지 못하였음이라 ");
INSERT INTO kor_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","단 자손이 소라와 에스다올에서부터 자기 온 가족 중 용맹 있는 다섯 사람을 보내어 땅을 탐지하고 살피게 하며 그들에게 이르되 `너희는 가서 땅을 살펴보라' 하매 그들이 에브라임 산지에 가서 미가의 집에 이르러 거기서 유숙하니라 ");
INSERT INTO kor_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","그들이 미가의 집에 가까이 올 때에 레위 소년의 음성을 알아듣고 그리로 돌이켜 가서 그에게 이르되 `누가 너를 이리로 인도하였으며 네가 여기서 무엇을 하며 여기서 무엇을 얻었느냐 ?' ");
INSERT INTO kor_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","그가 그들에게 이르되 `미가가 여차여차히 나를 대접하여 나를 고빙하여 나로 자기 제사장을 삼았느니라' ");
INSERT INTO kor_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","그들이 그에게 이르되 `청컨대 우리를 위하여 하나님께 물어보아서 우리의 행하는 길이 형통할는지 우리에게 알게 하라' ");
INSERT INTO kor_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","그 제사장이 그들에게 이르되 `평안히 가라 너희의 행하는 길은 여호와 앞에 있느니라' ");
INSERT INTO kor_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","이에 다섯 사람이 떠나 라이스에 이르러 거기 있는 백성을 본즉 염려 없이 거하여 시돈 사람같이 한가하고 평안하니 그 땅에는 권세 잡은 자가 없어서 무슨 일에든지 괴롭게 함이 없고 시돈 사람과 상거가 멀며 아무 사람과도 상관하지 아니함이라 ");
INSERT INTO kor_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","그들이 소라와 에스다올에 돌아와서 그 형제에게 이르매 형제들이 그들에게 묻되 `너희 보기에 어떠하더뇨' ");
INSERT INTO kor_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","가로되 `일어나서 그들을 치러 올라가자 우리가 그 땅을 본즉 매우 좋더라 너희는 가만히 있느냐 ? 나아가서 그 땅 얻기를 게을리 말라 ");
INSERT INTO kor_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","너희가 가면 평안한 백성을 만날 것이요 그 땅은 넓고 그 곳에는 세상에 있는 것이 하나도 부족함이 없느니라' ");
INSERT INTO kor_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","단 지파 가족 중 육백명이 병기를 띠고 소라와 에스다올에서 출발하여 ");
INSERT INTO kor_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","올라가서 유다 기럇여아림에 진 치니 이러므로 그곳 이름이 오늘까지 마하네단이며 그 곳은 기럇여아림 뒤에 있더라 ");
INSERT INTO kor_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","무리가 거기서 떠나서 에브라임 산지 미가의 집에 이르니라 ");
INSERT INTO kor_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","전에 라이스 땅을 탐지하러 갔던 다섯 사람이 그 형제들에게 말하여 가로되 `이 집에 에봇과 드라빔과 새긴 신상과 부어만든 신상이 있는 줄을 너희가 아느냐 ? 그런즉 이제 너희는 마땅히 행할 것을 생각하라' 하고 ");
INSERT INTO kor_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","다섯 사람이 그 편으로 향하여 소년 레위 사람의 집 곧 미가의 집에 이르러 문안하고 ");
INSERT INTO kor_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","단 자손 육백명은 병기를 띠고 문 입구에 서니라 ");
INSERT INTO kor_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","땅을 탐지하러 갔던 다섯 사람이 그리로 들어가서 새긴 신상과 에봇과 드라빔과 부어 만든 신상을 취할 때에 제사장은 병기를 육백명과 함께 문 입구에 섰더니 ");
INSERT INTO kor_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","그 다섯 사람이 미가의 집에 들어가서 그 새긴 신상과 에봇과 드라빔과 부어 만든 신상을 취하여 내매 제사장이 그들에게 묻되 `너희가 무엇을 하느냐 ?' ");
INSERT INTO kor_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","그들이 그에게 이르되 `잠잠하라 네 손을 입에 대라 우리와 함께 가서 우리의 아비와 제사장이 되라 네가 한 사람의 집의 제사장이 되는 것과 이스라엘 한 지파, 한 가족의 제사장이 되는 것이 어느 것이 낫겠느냐 ?' ");
INSERT INTO kor_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","제사장이 마음에 기뻐하여 에봇과 드라빔과 새긴 우상을 취하고 그 백성 중으로 들어가니라 ");
INSERT INTO kor_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","그들이 돌이켜서 어린아이들과 가축과 물품을 앞에 두고 진행하더니 ");
INSERT INTO kor_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","미가의 집을 멀리 떠난 때에 미가의 이웃집 사람들이 모여서 단 자손을 따라 미쳐서는 ");
INSERT INTO kor_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","단 자손을 부르는지라 그들이 낯을 돌이켜 미가에게 이르되 `네가 무슨 일로 이같이 모아가지고 왔느냐 ?' ");
INSERT INTO kor_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","미가가 가로되 `나의 지은 신들과 제사장을 취하여 갔으니 내게 오히려 있는 것이 무엇이냐 ? 너희가 어찌하여 나더러 무슨 일이냐 ? 하느냐' ");
INSERT INTO kor_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","단 자손이 그에게 이르되 `네 목소리를 우리에게 들리게 말라 노한 자들이 너희를 쳐서 네 생명과 네 가족의 생명을 잃게 할까 하노라' 하고 ");
INSERT INTO kor_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","단 자손이 자기 길을 행한지라 미가가 단 자손이 자기보다 강한 것을 보고 돌이켜 집으로 돌아갔더라 ");
INSERT INTO kor_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","단 자손이 미가의 지은 것과 그 제사장을 취하고 라이스에 이르러 한가하고 평안한 백성을 만나 칼날로 그들을 치며 불로 그 성읍을 사르되 ");
INSERT INTO kor_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","그들을 구원할 자가 없었으니 그 성읍이 베드르홉 가까운 골짜기에 있어서 시돈과 상거가 멀고 상종하는 사람도 없음이었더라 단 자손이 성읍을 중건하고 거기 거하며 ");
INSERT INTO kor_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","이스라엘의 소생 그 조상 단의 이름을 따라 그 성읍을 단이라 하니라 그 성읍의 본 이름은 라이스더라 ");
INSERT INTO kor_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","단 자손이 자기를 위하여 그 새긴 신상을 세웠고 모세의 손자 게르손의 아들 요나단과 그 자손은 단 지파의 제사장이 되어 이 백성이 사로 잡히는 날까지 이르렀더라 ");
INSERT INTO kor_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","하나님의 집이 실로에 있을 동안에 미가의 지은 바 새긴 신상이 단 자손에게 있었더라 ");
INSERT INTO kor_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","이스라엘에 왕이 없을 그 때에 에브라임 산지 구석에 우거하는 어떤 레위 사람이 유다 베들레헴에서 첩을 취하였더니 ");
INSERT INTO kor_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","그 첩이 행음하고 남편을 떠나 유다 베들레헴 그 아비의 집에 돌아가서 거기서 넉달의 날을 보내매 ");
INSERT INTO kor_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","그 남편이 그 여자에게 다정히 말하고 그를 데려오고자 하여 하인 하나와 나귀 두 필을 데리고 그에게로 가매 여자가 그를 인도하여 아비의 집에 들어가니 그 여자의 아비가 그를 보고 환영하니라 ");
INSERT INTO kor_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","그 첩장인 곧 여자의 아비가 그를 머물리매 그가 삼일을 그와 함께 거하며 먹고 마시며 거기서 유숙하다가 ");
INSERT INTO kor_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","나흘 만에 일찌기 일어나 떠나고자 하매 여자의 아비가 그 사위에게 이르되 `떡을 조금 먹어 그대의 기력을 도운 후에 그대의 길을 행하라' ");
INSERT INTO kor_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","두 사람이 앉아서 함께 먹고 마시매 여자의 아비가 그 사람에게 이르되 `청하노니 이 밤을 여기서 유숙하여 그대의 마음을 즐겁게하라' ");
INSERT INTO kor_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","그 사람이 일어나서 가고자 하되 첩장인의 간청으로 다시 유숙하더니 ");
INSERT INTO kor_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","다섯째 날 아침에 일찌기 일어나 떠나고자 하매 여자의 아비가 이르되 `청하노니 그대의 기력을 돕고 해가 기울도록 머물라' 하므로 두 사람이 함께 먹고 ");
INSERT INTO kor_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","그 사람이 첩과 하인으로 더불어 일어나 떠나고자 하매 그 첩장인 곧 여자의 아비가 그에게 이르되 `보라 ! 이제 해가 저물어가니 청컨대 이 밤도 유숙하라 보라 ! 해가 기울었느니라 그대는 여기서 유숙하여 그대의 마음을 즐겁게 하고 내일 일찌기 그대의 길을 행하여 그대의 집으로 돌아가라' ");
INSERT INTO kor_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","그 사람이 다시 밤을 지내고자 아니하여 일어나 떠나서 여부스 맞은편에 이르렀으니 여부스는 곧 예루살렘이라 안장 지운 나귀 둘과 첩이 그와 함께 하였더라 ");
INSERT INTO kor_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","그들이 여부스에 가까왔을 때에 해가 지려 하는지라 종이 주인에게 이르되 `청컨대 우리가 돌이켜 여부스 사람의 이 성읍에 들어 가서 유숙하사이다' ");
INSERT INTO kor_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","주인이 그에게 이르되 `우리가 돌이켜 이스라엘 자손에게 속하지 아니한 외인의 성읍으로 들어갈 것이 아니니 기브아로 나아가리라' 하고 ");
INSERT INTO kor_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","또 그 종에게 이르되 `우리가 기브아나 라마 중 한 곳에 나아가 거기서 유숙하자' 하고 ");
INSERT INTO kor_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","모두 앞으로 행하더니 베냐민에 속한 기브아에 가까이 이르러는 해가 진지라 ");
INSERT INTO kor_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","기브아에 가서 유숙하려고 그리로 돌이켜 들어가서 성읍 거리에 앉았으나 그를 집으로 영접하여 유숙케 하는 자가 없었더라 ");
INSERT INTO kor_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","이미 저물매 한 노인이 밭에서 일하다가 돌아오니 그 사람은 본래 에브라임 산지 사람으로서 기브아에 우거하는 자요 그 곳 사람들은 베냐민 사람이더라 ");
INSERT INTO kor_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","노인이 눈을 들어 성읍 거리에 행객이 있는 것을 본지라 노인이 묻되 그대는 어디로 가며 어디서 왔느뇨 ? ");
INSERT INTO kor_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","그가 그에게 이르되 `우리는 유다 베들레헴에서 에브라임 산지 구석으로 가나이다 나는 그곳 사람으로서 유다 베들레헴에 갔다가 이제 여호와의 집으로 가는 중인데 나를 자기 집으로 영접하는 사람이 없나이다 ");
INSERT INTO kor_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","우리에게는 나귀들에게 먹일 짚과 보리가 있고 나와 당신의 여종과 당신의 종 우리들과 함께한 소년의 먹을 양식과 포도주가 있어 무엇이든지 부족함이 없나이다' ");
INSERT INTO kor_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","노인이 가로되 `그대는 안심하라 그대의 모든 쓸 것은 나의 담책이니 거리에서는 자지 말라' 하고 ");
INSERT INTO kor_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","그를 데리고 자기 집에 들어가서 나귀에게 먹이니 그들이 발을 씻고 먹고 마시니라 ");
INSERT INTO kor_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","그들이 마음을 즐겁게 할 때에 그 성읍의 비류들이 그 집을 에워 싸고 문을 두들기며 집 주인 노인에게 말하여 가로되 `네 집에 들어온 사람을 끌어내라 우리가 그를 상관하리라' ");
INSERT INTO kor_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","집 주인 그 사람이 그들에게로 나와서 이르되 `아니라 내 형제들아 청하노니 악을 행치 말라 이 사람이 내 집에 들었으니 이런 망령된 일을 행치 말라 ");
INSERT INTO kor_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","보라 여기 내 처녀 딸과 이 사람의 첩이 있은즉 내가 그들을 끌어 내리니 너희가 그들을 욕보이든지 어찌하든지 임의로 하되 오직 이사람에게는 이런 망령된 일을 행치 말라' 하나 ");
INSERT INTO kor_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","무리가 듣지 아니하므로 그 사람이 자기 첩을 무리에게로 붙들어 내매 그들이 그에게 행음하여 밤새도록 욕보이다가 새벽 미명에 놓은지라 ");
INSERT INTO kor_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","동틀 때에 여인이 그 주인의 우거한 그 사람의 집 문에 이르러 엎드러져 밝기까지 거기 누웠더라 ");
INSERT INTO kor_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","그의 주인이 일찌기 일어나 집 문을 열고 떠나고자 하더니 그 여인이 집 문에 엎드러지고 그 두 손이 문지방에 있는 것을 보고 ");
INSERT INTO kor_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","그에게 이르되 `일어나라 우리가 떠나가자' 하나 아무 대답이 없는지라 이에 그 시체를 나귀에 싣고 행하여 자기 곳에 돌아가서 ");
INSERT INTO kor_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","그 집에 이르러서는 칼을 취하여 첩의 시체를 붙들어 그 마디를 찍어 열 두덩이에 나누고 그것을 이스라엘 사방에 두루 보내매 ");
INSERT INTO kor_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","그것을 보는 자가 다 가로되 `이스라엘 자손이 애굽 땅에서 나온 날부터 오늘날까지 이런 일은 행치도 아니하였고 보지도 못하였도다 생각하고 상의한 후에 말하자' 하니라 ");
INSERT INTO kor_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","이에 모든 이스라엘 자손이 단에서부터 브엘세바까지와 길르앗 땅에서 나왔는데 그 회중이 일제히 미스바에서 여호와 앞에 모였으니 ");
INSERT INTO kor_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","온 백성의 어른 곧 이스라엘 모든 지파의 어른들은 하나님 백성의 총회에 섰고 칼을 빼는 보병은 사십만이었으며 ");
INSERT INTO kor_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","이스라엘 자손의 미스바에 올라간 것을 베냐민 자손이 들었더라 이스라엘 자손이 가로되 `이 악한 일의 정형을 우리에게 고하라' ");
INSERT INTO kor_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","레위 사람 곧 죽임을 당한 여인의 남편이 대답하여 가로되 `내가 내 첩으로 더불어 베냐민에 속한 기브아에 유숙하러 갔더니 ");
INSERT INTO kor_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","기브아 사람들이 나를 치러 일어나서 밤에 나의 우거한 집을 에워싸고 나를 죽이려 하고 내 첩을 욕보여서 그로 죽게 한지라 ");
INSERT INTO kor_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","내가 내 첩의 시체를 취하여 쪼개어 이스라엘 기업의 온 땅에 보내었노니 이는 그들이 이스라엘 중에서 음행과 망령된 일을 행하였음을 인함이로라 ");
INSERT INTO kor_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","이스라엘 자손들아 ! 너희가 다 여기 있은즉 너희의 의견과 방책을 낼지니라' ");
INSERT INTO kor_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","모든 백성이 일제히 일어나며 가로되 `우리가 하나라도 자기 장막으로 돌아가지 아니하며 하나라도 자기 집으로 들어가지 아니하고 ");
INSERT INTO kor_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","우리가 기브아 사람에게 이렇게 행하리니 곧 제비뽑아서 그들을 치되 ");
INSERT INTO kor_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","우리가 이스라엘 모든 지파 중에서 백에 열, 천에 백, 만에 천을 취하고 그 백성을 위하여 양식을 예비하고 그들로 베냐민의 기브아에 가서 그 무리의 이스라엘 중에서 망령된 일을 행한 대로 징계하게 하리라' 하니라 ");
INSERT INTO kor_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","이와 같이 이스라엘 모든 사람이 하나 같이 합심하여 그 성읍을 치려고 모였더라 ");
INSERT INTO kor_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","이스라엘 지파들이 베냐민 온 지파에 사람들을 보내어 두루 행하며 이르기를 `너희 중에서 생긴 이 악이 어찜이뇨 ? ");
INSERT INTO kor_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","그런즉 이제 기브아 사람 곧 그 비류를 우리에게 붙여서 우리로 죽여 이스라엘 중에 악을 제하여 버리게 하라' 하나 베냐민 자손이 그 형제 이스라엘 자손의 말을 듣지 아니하고 ");
INSERT INTO kor_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","도리어 각 성읍에서 기브아에 모이고 나가서 이스라엘 자손과 싸우고자 하니 ");
INSERT INTO kor_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","그 때에 성읍들에서 나온 베냐민 자손의 수는 칼을 빼는 자가 모두 이만 육천이요 그 외에 기브아 거민 중 택한 자가 칠백인데 ");
INSERT INTO kor_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","이 모든 백성 중에서 택한 칠 백명은 다 왼손잡이라 물매로 돌을 던지면 호리도 틀림이 없는 자더라 ");
INSERT INTO kor_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","베냐민 자손 외에 이스라엘 사람의 칼을 빼는 자의 수는 사십만명이니 다 전사라 ");
INSERT INTO kor_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","이스라엘 자손이 일어나 벧엘에 올라가서 하나님께 묻자와 가로되 우리 중에 누가 먼저 올라가서 베냐민 자손과 싸우리이까 ? 여호와께서 가라사대 유다가 먼저일지니라 ");
INSERT INTO kor_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","이스라엘 자손이 아침에 일어나 기브아를 대하여 진을 치니라 ");
INSERT INTO kor_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","이스라엘 사람들이 나가서 항오를 벌이고 거기서 그들과 싸우고자 하매 ");
INSERT INTO kor_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","베냐민 자손이 기브아에서 나와서 당일에 이스라엘 사람 이만 이천을 땅에 엎드러뜨렸으나 ");
INSERT INTO kor_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","22","이스라엘 사람들이 스스로 용기를 내어 첫날 항오를 벌였던 곳에 다시 항오를 벌이니라 ");
INSERT INTO kor_vpl VALUES ("JG20_23","008_20_23","JDG","20","23","23","이스라엘 자손이 올라가서 여호와 앞에서 저물도록 울며 여호와께 묻자와 가로되 `내가 다시 나아가서 나의 형제 베냐민 자손과 싸우리이까 ?' 여호와께서 가라사대 올라가서 치라 하시니라 ");
INSERT INTO kor_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","그 이튿날에 이스라엘 자손이 베냐민 자손을 치러 나아가매 ");
INSERT INTO kor_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","베냐민도 그 이튿날에 기브아에서 그들을 치러 나와서 다시 이스라엘 자손 일만 팔천을 땅에 엎드러뜨렸으니 다 칼을 빼는 자였더라 ");
INSERT INTO kor_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","이에 온 이스라엘 자손 모든 백성이 올라가서 벧엘에 이르러 울며 거기서 여호와 앞에 앉고 그 날이 저물도록 금식하고 번제와 화목제를 여호와 앞에 드리고 ");
INSERT INTO kor_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","27","여호와께 물으니라 (그 때에는 하나님의 언약궤가 거기 있고 ");
INSERT INTO kor_vpl VALUES ("JG20_28","008_20_28","JDG","20","28","28","아론의 손자 엘르아살의 아들 비느하스가 그 앞에 모셨더라) 이스라엘 자손이 묻자오되 `내가 다시 나가 나의 형제 베냐민 자손과 싸우리이까 말리이까' 여호와께서 가라사대 올라가라 내일은 내가 그를 네 손에 붙이리라 ");
INSERT INTO kor_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","이스라엘이 기브아 사면에 군사를 매복하니라 ");
INSERT INTO kor_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","이스라엘 자손이 제 삼일에 베냐민 자손에게로 치러 올라가서 전과 같이 기브아를 대하여 항오를 벌이매 ");
INSERT INTO kor_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","베냐민 자손이 나와서 백성을 맞더니 꾀임에 빠져 성읍을 떠났더라 그들이 큰 길 곧 한편은 벧엘로 올라가는 길이요 한편은 기브아의 들로 가는 길에서 백성을 쳐서 전과 같이 이스라엘 사람 삼십명 가량을 죽이기 시작하며 ");
INSERT INTO kor_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","스스로 이르기를 이들이 처음과 같이 우리 앞에서 패한다하나 이스라엘 자손은 이르기를 `우리가 도망하여 그들을 성읍에서 큰 길로 꾀어내자' 하고 ");
INSERT INTO kor_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","이스라엘 사람이 모두 그 처소에서 일어나서 바알다말에 항오를 벌였고 그 복병은 그 처소 곧 기브아 초장에서 쏟아져 나왔더라 ");
INSERT INTO kor_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","온 이스라엘 사람 중에서 택한 사람 일만이 기브아에 이르러 치매 싸움이 심히 맹렬하나 베냐민 사람은 화가 자기에게 미친 줄을 알지 못하였더라 ");
INSERT INTO kor_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","여호와께서 이스라엘 앞에서 베냐민을 쳐서 파하게 하시매 당일에 이스라엘 자손이 베냐민 사람 이만 오천 일백을 죽였으니 다 칼을 빼는 자이었더라 ");
INSERT INTO kor_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","이에 베냐민 자손이 자기가 패한 것을 깨달았으니 이는 이스라엘 사람이 기브아에 매복한 군사를 믿고 잠간 베냐민 사람 앞을 피하매 ");
INSERT INTO kor_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","복병이 급히 나와 기브아에 돌입하고 나아가며 칼날로 온 성읍을 쳤음이더라 ");
INSERT INTO kor_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","처음에 이스라엘 사람과 복병 사이에 상약하기를 `성읍에서 큰 연기가 치미는 것으로 군호를 삼자' 하고 ");
INSERT INTO kor_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","이스라엘 사람은 싸우다가 물러가고 베냐민 사람은 이스라엘 사람 삼십명 가량을 쳐 죽이기를 시작하며 이르기를 `이들이 정녕 처음 싸움같이 우리에게 패한다' 하다가 ");
INSERT INTO kor_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","연기 구름이 기둥 같이 성읍 가운데서 일어날 때에 베냐민 사람이 돌아보매 온 성읍에 연기가 하늘에 닿았고 ");
INSERT INTO kor_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","이스라엘 사람은 돌이키는지라 베냐민 사람이 화가 자기에게 미친 것을 보고 심히 놀라 ");
INSERT INTO kor_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","이스라엘 사람 앞에서 몸을 돌이켜 광야 길로 향하였으나 군사가 급히 추격하며 각 성읍에서 나온 자를 그 가운데서 진멸하니라 ");
INSERT INTO kor_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","그들이 베냐민 사람을 에워쌌더니 기브아 앞 동편까지 쫓으며 그 쉬는 곳에서 짓밟으매 ");
INSERT INTO kor_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","베냐민 중에서 엎드러진 자가 일만 팔천이니 다 용사더라 ");
INSERT INTO kor_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","그들이 몸을 돌이켜 광야로 도망하여 림몬 바위에 이르는 큰길에서 이스라엘이 또 오천명을 이삭 줍듯 하고 또 급히 따라 기돔에 이르러 또 이천명을 죽였으니 ");
INSERT INTO kor_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","이 날에 베냐민의 칼을 빼는 자의 엎드러진 것이 모두 이만 오천이니 다 용사더라 ");
INSERT INTO kor_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","베냐민 육백명이 돌이켜 광야로 도망하여 림몬 바위에 이르러 거기서 넉달을 지내었더라 ");
INSERT INTO kor_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","이스라엘 사람이 베냐민 자손에게로 돌아와서 온 성읍과 가축과 만나는 자를 다 칼날로 치고 닥치는 성읍마다 다 불살랐더라 ");
INSERT INTO kor_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","이스라엘 사람들이 미스바에서 맹세하여 이르기를 `우리 중에 누구든지 딸을 베냐민 사람에게 아내로 주지 아니하리라' 하였더라 ");
INSERT INTO kor_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","백성이 벧엘에 이르러 거기서 저녁까지 하나님 앞에 앉아서 대성 통곡하여 ");
INSERT INTO kor_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","가로되 `이스라엘의 하나님 여호와여 ! 오늘날 이스라엘 중에 어찌하여 한 지파가 이즈러졌나이까 ?' 하더니 ");
INSERT INTO kor_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","이튿날에 백성이 일찌기 일어나서 거기 한 단을 쌓고 번제와 화목제를 드렸더라 ");
INSERT INTO kor_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","이스라엘 자손이 가로되 `이스라엘 온 지파 중에 총회와 함께 하여 여호와 앞에 올라오지 아니한 자가 누구뇨? 하니 이는 그들이 크게 맹세하기를 미스바에 와서 여호와 앞에 이르지 아니하는 자는 반드시 죽일 것이라 하였음이라 ");
INSERT INTO kor_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","이스라엘 자손이 그 형제 베냐민을 위하여 뉘우쳐 가로되 `오늘날 이스라엘 중에 한 지파가 끊쳤도다 ");
INSERT INTO kor_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","그 남은 자들에게 우리가 어떻게 하면 아내를 얻게 하리요 우리가 전에 여호와로 맹세하여 우리 딸을 그들의 아내로 주지 아니하리라' 하였도다 ");
INSERT INTO kor_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","또 가로되 `이스라엘 지파 중 미스바에 올라와서 여호와께 이르지 아니한 자가 누구뇨 ?' 하고 본즉 야베스 길르앗에서는 한 사람도 진에 이르러 총회에 참여치 아니하였으니 ");
INSERT INTO kor_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","백성을 계수할 때에 야베스 길르앗 거민이 하나도 거기 없음을 보았음이라 ");
INSERT INTO kor_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","회중이 큰 용사 일만 이천을 그리로 보내며 그들에게 명하여 가로되 가서 야베스 길르앗 거민과 및 부녀와 어린 아이를 칼날로 치라 ");
INSERT INTO kor_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","너희의 행할 일은 모든 남자와 남자와 잔 여자를 진멸할 것이니라 하였더니 ");
INSERT INTO kor_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","그들이 야베스 길르앗 거민 중에서 젊은 처녀 사백인을 얻었으니 이는 아직 남자와 자지 아니하여서 남자를 알지 못하는 자라 그들이 실로 진으로 끌어 오니라 이는 가나안 땅이더라 ");
INSERT INTO kor_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","온 회중이 림몬 바위에 있는 베냐민 자손에게 보내어 평화를 공포하게 하였더니 ");
INSERT INTO kor_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","그 때에 베냐민이 돌아온지라 이에 이스라엘 사람이 야베스 길르앗 여인 중에서 살려둔 여자를 그들에게 주었으나 오히려 부족하므로 ");
INSERT INTO kor_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","백성들이 베냐민을 위하여 뉘우쳤으니 이는 여호와께서 이스라엘 지파들 중에 한 지파가 궐이 나게 하셨음이더라 ");
INSERT INTO kor_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","회중 장로들이 가로되 `베냐민의 여인이 다 멸절되었으니 이제 그 남은 자들에게 어떻게 하여야 아내를 얻게 할꼬 ?' ");
INSERT INTO kor_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","또 가로되 `베냐민의 도망하여 면한 자에게 마땅히 기업이 있어야 하리니 그리하면 이스라엘 중에 한 지파가 사라짐이 없으리라 ");
INSERT INTO kor_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","그러나 우리가 우리의 딸을 그들의 아내로 주지 못하리니 이는 이스라엘 자손이 맹세하여 이르기를 딸을 베냐민에게 아내로 주는 자는 저주를 받으리라 하였음이로다' ");
INSERT INTO kor_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","19","또 가로되 `보라, 벧엘 북편, 르보나 남편 벧엘에서 세겜으로 올라가는 큰길 동편 실로에 매년 여호와의 절기가 있도다' 하고 ");
INSERT INTO kor_vpl VALUES ("JG21_20","008_21_20","JDG","21","20","20","베냐민 자손에게 명하여 가로되 `가서 포도원에 숨어 ");
INSERT INTO kor_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","보다가 실로의 여자들이 무도하러 나오거든 너희는 포도원에서 나와서 실로의 딸 중에서 각각 그 아내로 붙들어 가지고 베냐민 땅으로 돌아가라 ");
INSERT INTO kor_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","만일 그 아비나 형제가 와서 우리에게 쟁론하면 우리가 그에게 말하기를 청컨대 너희는 우리에게 은혜를 베풀어 그들을 우리에게 줄지니라 이는 우리가 전쟁할 때에 각 사람을 위하여 그 아내를 얻어 주지 못하였고 너희가 자의로 그들에게 준것이 아니니 너희에게 죄가 없을 것임이니라 하겠노라' 하매 ");
INSERT INTO kor_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","베냐민 자손이 그같이 행하여 춤추는 여자 중에서 자기들의 수효대로 아내로 붙들어 가지고 자기 기업에 돌아가서 성읍들을 중건하고 거기 거하니라 ");
INSERT INTO kor_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","그 때에 이스라엘 자손이 그곳을 떠나 각각 그 지파, 그 가족에게로 돌아가되 곧 각각 그곳에서 나와서 자기 기업으로 돌아갔더라 ");
INSERT INTO kor_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","그 때에 이스라엘에 왕이 없으므로 사람이 각각 그 소견에 옳은 대로 행하였더라 ");
INSERT INTO kor_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","사사들의 치리하던 때에 그 땅에 흉년이 드니라 유다 베들레헴에 한 사람이 그 아내와 두 아들을 데리고 모압 지방에 가서 우거하였는데 ");
INSERT INTO kor_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","그 사람의 이름은 엘리멜렉이요 그 아내의 이름은 나오미요 그 두 아들의 이름은 말론과 기룐이니 유다 베들레헴 에브랏 사람들이더라 그들이 모압 지방에 들어가서 거기 유하더니 ");
INSERT INTO kor_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","나오미의 남편 엘리멜렉이 죽고 나오미와 그 두 아들이 남았으며 ");
INSERT INTO kor_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","그들은 모압 여자 중에서 아내를 취하였는데 하나의 이름은 오르바요 하나의 이름은 룻이더라 거기 거한지 십년 즈음에 ");
INSERT INTO kor_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","말론과 기룐 두 사람이 다 죽고 그 여인은 두 아들과 남편의 뒤에 남았더라 ");
INSERT INTO kor_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","그가 모압 지방에 있어서 여호와께서 자기 백성을 권고하사 그들에게 양식을 주셨다 함을 들었으므로 이에 두 자부와 함께 일어나 모압 지방에서 돌아오려 하여 ");
INSERT INTO kor_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","있던 곳을 떠나고 두 자부도 그와 함께 하여 유다 땅으로 돌아오려고 길을 행하다가 ");
INSERT INTO kor_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","나오미가 두 자부에게 이르되 `너희는 각각 어미의 집으로 돌아가라 너희가 죽은 자와 나를 선대한 것같이 여호와께서 너희를 선대하시기를 원하며 ");
INSERT INTO kor_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","여호와께서 너희로 각각 남편의 집에서 평안함을 얻게 하시기를 원하노라' 하고 그들에게 입맞추매 그들이 소리를 높여 울며 ");
INSERT INTO kor_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","나오미에게 이르되 `아니니이다 우리는 어머니와 함께 어머니의 백성에게로 돌아가겠나이다' ");
INSERT INTO kor_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","나오미가 가로되 `내 딸들아 돌아가라 너희가 어찌 나와 함께 가려느냐 ? 나의 태 중에 너희 남편될 아들들이 오히려 있느냐 ? ");
INSERT INTO kor_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","내 딸들아 돌이켜 너희 길로 가라 나는 늙었으니 남편을 두지 못할지라 가령 내가 소망이 있다고 말한다든지 오늘 밤에 남편을 두어서 아들들을 생산한다 하자 ");
INSERT INTO kor_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","너희가 어찌 그것을 인하여 그들의 자라기를 기다리겠느냐 ? 어찌 그것을 인하여 남편 두기를 멈추겠느냐 ? 내 딸들아 그렇지 아니하니라 여호와의 손이 나를 치셨으므로 나는 너희로 인하여 더욱 마음이 아프도다' ");
INSERT INTO kor_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","그들이 소리를 높여 다시 울더니 오르바는 그 시모에게 입 맞추되 룻은 그를 붙좇았더라 ");
INSERT INTO kor_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","나오미가 또 가로되 `보라, 네 동서는 그 백성과 그 신에게로 돌아가나니 너도 동서를 따라 돌아가라' ");
INSERT INTO kor_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","룻이 가로되 `나로 어머니를 떠나며 어머니를 따르지 말고 돌아가라 강권하지 마옵소서 ! 어머니께서 가시는 곳에 나도 가고, 어머니께서 유숙하시는 곳에서 나도 유숙하겠나이다 ! 어머니의 백성이 나의 백성이 되고, 어머니의 하나님이 나의 하나님이 되시리니 ");
INSERT INTO kor_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","어머니께서 죽으시는 곳에서 나도 죽어 거기 장사될 것이라 만일 내가 죽는 일 외에 어머니와 떠나면 여호와께서 내게 벌을 내리시고 더 내리시기를 원하나이다' ");
INSERT INTO kor_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","나오미가 룻의 자기와 함께 가기로 굳게 결심함을 보고 그에게 말하기를 그치니라 ");
INSERT INTO kor_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","이에 그 두 사람이 행하여 베들레헴까지 이르니라 베들레헴에 이를 때에 온 성읍이 그들을 인하여 떠들며 이르기를 `이가 나오미냐 ?' 하는지라 ");
INSERT INTO kor_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","나오미가 그들에게 이르되 `나를 나오미라 칭하지 말고 마라라 칭하라 이는 전능자가 나를 심히 괴롭게 하셨음이니라 ");
INSERT INTO kor_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","내가 풍족하게 나갔더니 여호와께서 나로 비어 돌아오게 하셨느니라 여호와께서 나를 징벌하셨고 전능자가 나를 괴롭게 하셨거늘 너희가 어찌 나를 나오미라 칭하느뇨 ?' 하니라 ");
INSERT INTO kor_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","나오미가 모압 지방에서 그 자부 모압 여인 룻과 함께 돌아왔는데 그들이 보리 추수 시작할 때에 베들레헴에 이르렀더라 ");
INSERT INTO kor_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","나오미의 남편 엘리멜렉의 친족 중 유력한 자가 있으니 이름은 보아스더라 ");
INSERT INTO kor_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","모압 여인 룻이 나오미에게 이르되 `나로 밭에 가게 하소서 ! 내가 뉘게 은혜를 입으면 그를 따라서 이삭을 줍겠나이다' 나오미가 그에게 이르되 `내 딸아 갈지어다' 하매 ");
INSERT INTO kor_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","룻이 가서 베는 자를 따라 밭에서 이삭을 줍는데 우연히 엘리멜렉의 친족 보아스에게 속한 밭에 이르렀더라 ");
INSERT INTO kor_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","마침 보아스가 베들레헴에서부터 와서 베는 자들에게 이르되 여호와께서 너희가 함께 하시기를 원하노라 그들이 대답하되 여호와께서 당신에게 복 주시기를 원하나이다 ");
INSERT INTO kor_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","보아스가 베는 자들을 거느린 사환에게 이르되 `이는 뉘 소녀냐 ?' ");
INSERT INTO kor_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","베는 자를 거느린 사환이 대답하여 가로되 `이는 나오미와 함께 모압 지방에서 돌아온 모압 소녀인데 ");
INSERT INTO kor_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","그의 말이 나로 베는 자를 따라 단 사이에서 이삭을 줍게 하소서 하였고 아침부터 와서는 잠시 집에서 쉰 외에 지금까지 계속하는 중이니이다' ");
INSERT INTO kor_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","보아스가 룻에게 이르되 `내 딸아 들으라 이삭을 주우러 다른 밭으로 가지 말며 여기서 떠나지 말고 나의 소녀들과 함께 있으라 ");
INSERT INTO kor_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","그들의 베는 밭을 보고 그들을 따르라 내가 그 소년들에게 명하여 너를 건드리지 말라 하였느니라 목이 마르거든 그릇에 가서 소년들의 길어 온 것을 마실지니라' ");
INSERT INTO kor_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","룻이 땅에 엎드려 절하며 그에게 이르되 `나는 이방 여인이어늘 당신이 어찌하여 내게 은혜를 베푸시며 나를 돌아보시나이까 ?' ");
INSERT INTO kor_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","보아스가 그에게 대답하여 가로되 `네 남편이 죽은 후로 네가 시모에게 행한 모든 것과 네 부모와 고국을 떠나 전에 알지 못하던 백성에게로 온 일이 내게 분명히 들렸느니라 ");
INSERT INTO kor_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","여호와께서 네 행한 일을 보응하시기를 원하며 이스라엘의 하나님 여호와께서 그 날개 아래 보호를 받으러 온 네게 온전한 상 주시기를 원하노라 !' ");
INSERT INTO kor_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","룻이 가로되 `내 주여, 내가 당신께 은혜 입기를 원하나이다 나는 당신의 시녀의 하나와 같지 못하오나 당신이 이 시녀를 위로하시고 마음을 기쁘게 하는 말씀을 하셨나이다' ");
INSERT INTO kor_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","식사할 때에 보아스가 룻에게 이르되 `이리로 와서 떡을 먹으며 네 떡 조각을 초에 찍으라' 룻이 곡식 베는 자 곁에 앉으니 그가 볶은 곡식을 주매 룻이 배불리 먹고 남았더라 ");
INSERT INTO kor_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","룻이 이삭을 주우러 일어날 때에 보아스가 자기 소년들에게 명하여 가로되 `그로 곡식 단 사이에서 줍게 하고 책망하지 말며 ");
INSERT INTO kor_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","또 그를 위하여 줌에서 조금씩 뽑아 버려서 그로 줍게 하고 꾸짖지 말라' 하니라 ");
INSERT INTO kor_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","룻이 밭에서 저녁까지 줍고 그 주운 것을 떠니 보리가 한 에바쯤 되는지라 ");
INSERT INTO kor_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","그것을 가지고 성읍에 들어가서 시모에게 그 주운 것을 보이고 그 배불리 먹고 남긴 것을 내어 시모에게 드리매 ");
INSERT INTO kor_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","시모가 그에게 이르되 `오늘 어디서 주웠느냐 ? 어디서 일을 하였느냐 ? 너를 돌아본 자에게 복이 있기를 원하노라 !' 룻이 누구에게서 일한 것을 시모에게 알게 하여 가로되 `오늘 일하게 한 사람의 이름은 보아스니이다' ");
INSERT INTO kor_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","나오미가 자부에게 이르되 `여호와의 복이 그에게 있기를 원하노라 ! 그가 생존한 자와 사망한 자에게 은혜 베풀기를 그치지 아니하도다' 나오미가 또 그에게 이르되 `그 사람은 우리의 근족이니 우리 기업을 무를 자 중 하나이니라' ");
INSERT INTO kor_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","모압 여인 룻이 가로되 `그가 내게 또 이르기를 내 추수를 다 마치기까지 너는 내 소년들에게 가까이 있으라 하더이다' ");
INSERT INTO kor_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","나오미가 자부 룻에게 이르되 `내 딸아 ! 너는 그 소녀들과 함께 나가고 다른 밭에서 사람을 만나지 아니하는 것이 좋으니라' ");
INSERT INTO kor_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","이에 룻이 보아스의 소녀들에게 가까이 있어서 보리 추수와 밀 추수를 마치기까지 이삭을 주우며 그 시모와 함께 거하니라 ");
INSERT INTO kor_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","룻의 시모 나오미가 그에게 이르되 `내 딸아 ! 내가 너를 위하여 안식할 곳을 구하여 너로 복되게 하여야 하지 않겠느냐 ? ");
INSERT INTO kor_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","네가 함께 하던 시녀들을 둔 보아스는 우리의 친족이 아니냐 ? 그가 오늘 밤에 타작 마당에서 보리를 까불리라 ");
INSERT INTO kor_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","그런즉 너는 목욕하고 기름을 바르고 의복을 입고 타작 마당에 내려가서 그 사람이 먹고 마시기를 다하기까지는 그에게 보이지 말고 ");
INSERT INTO kor_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","그가 누울 때에 너는 그 눕는 곳을 알았다가 들어 가서 그 발치 이불을 들고 거기 누우라 그가 너의 할일을 네게 고하리라' ");
INSERT INTO kor_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","룻이 시모에게 이르되 `어머니의 말씀대로 내가 다 행하리이다 !' 하니라 ");
INSERT INTO kor_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","그가 타작 마당으로 내려가서 시모의 명대로 다 하니라 ");
INSERT INTO kor_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","보아스가 먹고 마시고 마음이 즐거워서 가서 노적가리 곁에 눕는지라 룻이 가만히 가서 그 발치 이불을 들고 거기 누웠더라 ");
INSERT INTO kor_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","밤중에 그 사람이 놀라 몸을 돌이켜 본즉 한 여인이 자기 발치에 누웠는지라 ");
INSERT INTO kor_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","가로되 `네가 누구뇨 ?' 대답하되 `나는 당신의 시녀 룻이오니 당신의 옷자락으로 시녀를 덮으소서 당신은 우리 기업을 무를 자가 됨이니이다' ");
INSERT INTO kor_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","가로되 `내 딸아 ! 여호와께서 네게 복주시기를 원하노라 ! 네가 빈부를 물론하고 연소한 자를 좇지 아니하였으니 너의 베푼 인애가 처음보다 나중이 더하도다 ");
INSERT INTO kor_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","내 딸아, 두려워말라 ! 내가 네 말대로 네게 다 행하리라 ! 네가 현숙한 여자인 줄 나의 성읍 백성이 다 아느니라 ");
INSERT INTO kor_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","참으로 나는 네 기업을 무를자나 무를 자가 나보다 더 가까운 친족이 있으니 ");
INSERT INTO kor_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","이 밤에 여기서 머무르라 아침에 그가 기업 무를 자의 책임을 네게 이행하려 하면 좋으니 그가 그 기업 무를 자의 책임을 행할 것이니라 만일 그가 기업 무를 자의 책임을 네게 이행코자 아니하면 여호와의 사심으로 맹세하노니 내가 기업 무를 자의 책임을 네게 행하리라 아침까지 누울지니라' ");
INSERT INTO kor_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","룻이 새벽까지 그 발치에 누웠다가 사람이 피차 알아보기 어려울때에 일어났으니 보아스의 말에 여인이 타작 마당에 들어온 것을 사람이 알지 못하여야 할 것이라 하였음이라 ");
INSERT INTO kor_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","보아스가 가로되 `네 겉옷을 가져다가 펴서 잡으라` 펴서 잡으니 보리를 여섯번 되어 룻에게 이워주고 성으로 들어가니라 ");
INSERT INTO kor_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","룻이 시모에게 이르니 그가 가로되 `내 딸아 ! 어떻게 되었느냐 ?' 룻이 그 사람의 자기에게 행한 것을 다 고하고 ");
INSERT INTO kor_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","가로되 `그가 내게 이 보리를 여섯번 되어 주며 이르기를 빈손으로 네 시모에게 가지말라 하더이다` ");
INSERT INTO kor_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","이에 시모가 가로되 `내 딸아 ! 이 사건이 어떻게 되는 것을 알기까지 가만히 앉아 있으라 그 사람이 오늘날 이 일을 성취하기 전에는 쉬지 아니하리라' ");
INSERT INTO kor_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","보아스가 성문에 올라가서 거기 앉았더니 마침 보아스의 말하던 기업 무를 자가 지나는지라 보아스가 그에게 이르되 `아무여 이리로 와서 앉으라' 그가 와서 앉으매 ");
INSERT INTO kor_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","보아스가 성읍 장로 십인을 청하여 가로되 `당신들은 여기 앉으라' 그들이 앉으매 ");
INSERT INTO kor_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","보아스가 그 기업 무를 자에게 이르되 `모압 지방에서 돌아온 나오미가 우리 형제 엘리멜렉의 소유지를 관할하므로 ");
INSERT INTO kor_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","내가 여기 앉은 자들과 내 백성의 장로들 앞에서 그것을 사라고 네게 고하여 알게 하려 하였노라 네가 무르려면 무르려니와 네가 무르지 아니하려거든 내게 고하여 알게 하라 네 다음은 나요,그 외에는 무를 자가 없느니라' 그가 가로되 `내가 무르리라' ");
INSERT INTO kor_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","보아스가 가로되 `네가 나오미의 손에서 그 밭을 사는 날에 곧 죽은 자의 아내 모압 여인 룻에게서 사서 그 죽은 자의 기업을 그 이름으로 잇게 하여야 할지니라' ");
INSERT INTO kor_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","그 기업 무를 자가 가로되 `나는 내 기업에 손해가 있을까 하여 나를 위하여 무르지 못하노니 나의 무를 권리를 네가 취하라 나는 무르지 못하겠노라' ");
INSERT INTO kor_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","옛적 이스라엘 중에 모든 것을 무르거나 교환하는 일을 확정하기 위하여 사람이 그신을 벗어 그 이웃에게 주더니 이것이 이스라엘의 증명하는 전례가 된지라 ");
INSERT INTO kor_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","이에 그 기업 무를 자가 보아스에게 이르되 네가 너를 위하여 사라 하고 그 신을 벗는지라 ");
INSERT INTO kor_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","보아스가 장로들과 모든 백성에게 이르되 `내가 엘리멜렉과 기룐과 말론에게 있던 모든 것을 나오미의 손에서 산일에 너희가 오늘날 증인이 되었고 ");
INSERT INTO kor_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","또 말론의 아내 모압 여인 룻을 사서 나의 아내로 취하고 그 죽은 자의 기업을 그 이름으로 잇게 하여 그 이름이 그 형제 중과 그 곳 성문에서 끊어지지 않게 함에 너희가 오늘날 증인이 되었느니라' ");
INSERT INTO kor_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","성문에 있는 모든 백성과 장로들이 가로되 `우리가 증인이 되노니 여호와께서 네 집에 들어가는 여인으로 이스라엘 집을 세운 라헬, 레아 두 사람과 같게 하시고 너로 에브랏에서 유력하고 베들레헴에서 유명케 하시기를 원하며 ");
INSERT INTO kor_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","여호와께서 이 소년 여자로 네게 후사를 주사 네 집으로 다말이 유다에게 낳아준 베레스의 집과 같게 하시기를 원하노라' ");
INSERT INTO kor_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","이에 보아스가 룻을 취하여 아내를 삼고 그와 동침하였더니 여호와께서 그로 잉태케 하시므로 그가 아들을 낳은지라 ");
INSERT INTO kor_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","여인들이 나오미에게 이르되 `찬송할지로다 ! 여호와께서 오늘날 네게 기업 무를 자가 없게 아니하셨도다 이 아이의 이름이 이스라엘 중에 유명하게 되기를 원하노라 ! ");
INSERT INTO kor_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","이는 네 생명의 회복자며 네 노년의 봉양자라 곧 너를 사랑하며 일곱 아들보다 귀한 자부가 낳은 자로다' ");
INSERT INTO kor_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","나오미가 아기를 취하여 품에 품고 그의 양육자가 되니 ");
INSERT INTO kor_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","그 이웃 여인들이 그에게 이름을 주되 `나오미가 아들을 낳았다' 하여 그 이름을 오벳이라 하였는데 그는 다윗의 아비인 이새의 아비였더라 ");
INSERT INTO kor_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","베레스의 세계는 이러하니라 베레스는 헤스론을 낳았고 ");
INSERT INTO kor_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","헤스론은 람을 낳았고, 람은 암미나답을 낳았고 ");
INSERT INTO kor_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","암미나답은 나손을 낳았고, 나손은 살몬을 낳았고 ");
INSERT INTO kor_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","살몬은 보아스를 낳았고, 보아스는 오벳을 낳았고 ");
INSERT INTO kor_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","오벳은 이새를 낳았고, 이새는 다윗을 낳았더라 ");
INSERT INTO kor_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","에브라임 산지 라마다임소빔에 에브라임 사람 엘가나라 하는 자가 있으니 그는 여로함의 아들이요 엘리후의 손자요 도후의 증손이요 숩의 현손이더라 ");
INSERT INTO kor_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","그에게 두 아내가 있으니 하나의 이름은 한나요 하나의 이름은 브닌나라 브닌나는 자식이 있고 한나는 무자하더라 ");
INSERT INTO kor_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","이 사람이 매년에 자기 성읍에서 나와서 실로에 올라가서 만군의 여호와께 경배하며 제사를 드렸는데 엘리의 두 아들 홉니와 비느하스가 여호와의 제사장으로 거기 있었더라 ");
INSERT INTO kor_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","엘가나가 제사를 드리는 날에는 제물의 분깃을 그 아내 브닌나와 그 모든 자녀에게 주고 ");
INSERT INTO kor_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","한나에게는 갑절을 주니 이는 그를 사랑함이라 그러나 여호와께서 그로 성태치 못하게 하시니 ");
INSERT INTO kor_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","여호와께서 그로 성태치 못하게 하시므로 그 대적 브닌나가 그를 심히 격동하여 번민케 하더라 ");
INSERT INTO kor_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","매년에 한나가 여호와의 집에 올라갈 때마다 남편이 그같이 하매 브닌나가 그를 격동시키므로 그가 울고 먹지 아니하니 ");
INSERT INTO kor_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","그 남편 엘가나가 그에게 이르되 `한나여 어찌하여 울며 어찌하여 먹지 아니하며 어찌하여 그대의 마음이 슬프뇨 내가 그대에게 열아들보다 낫지 아니하뇨 ?' ");
INSERT INTO kor_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","그들이 실로에서 먹고 마신 후에 한나가 일어나니 때에 제사장 엘리는 여호와의 전 문설주 곁 그 의자에 앉았더라 ");
INSERT INTO kor_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","한나가 마음이 괴로와서 여호와께 기도하고 통곡하며 ");
INSERT INTO kor_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","서원하여 가로되 `만군의 여호와여 만일 주의 여종의 고통을 돌아보시고 나를 생각하시고 주의 여종을 잊지 아니하사 아들을 주시면 내가 그의 평생에 그를 여호와께 드리고 삭도를 그 머리에 대지 아니하겠나이다' ");
INSERT INTO kor_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","그가 여호와 앞에 오래 기도하는 동안에 엘리가 그의 입을 주목한즉 ");
INSERT INTO kor_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","한나가 속으로 말하매 입술만 동하고 음성은 들리지 아니하므로 엘리는 그가 취한 줄로 생각한지라 ");
INSERT INTO kor_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","엘리가 그에게 이르되 `네가 언제까지 취하여 있겠느냐 ? 포도주를 끊으라' ");
INSERT INTO kor_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","한나가 대답하여 가로되 `나의 주여, 그렇지 아니하니이다 나는 마음이 슬픈 여자라 포도주나 독주를 마신 것이 아니요 여호와 앞에 나의 심정을 통한 것뿐이오니 ");
INSERT INTO kor_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","당신의 여종을 악한 여자로 여기지 마옵소서 내가 지금까지 말한 것은 나의 원통함과 격동됨이 많음을 인함이니이다' ");
INSERT INTO kor_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","엘리가 대답하여 가로되 `평안히 가라 이스라엘의 하나님이 너의 기도하여 구한 것을 허락하시기를 원하노라' ");
INSERT INTO kor_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","엘리가 대답하여 가로되 `평안히 가라 이스라엘의 하나님이 너의 기도하여 구한 것을 허락하시기를 원하노라' ");
INSERT INTO kor_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","가로되 `당신의 여종이 당신께 은혜 입기를 원하나이다` 하고 가서 먹고 얼굴에 다시는 수색이 없으니라 ");
INSERT INTO kor_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","그들이 아침에 일찌기 일어나 여호와 앞에 경배하고 돌아가서 라마의 자기 집에 이르니라 엘가나가 그 아내 한나와 동침하매 여호와께서 그를 생각하신지라 ");
INSERT INTO kor_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","한나가 잉태하고 때가 이르매 아들을 낳아 사무엘이라 이름하였으니 이는 `내가 여호와께 그를 구하였다' 함이더라 ");
INSERT INTO kor_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","그 사람 엘가나와 그 온 집이 여호와께 매년제와 그 서원제를 드리러 올라갈 때에 ");
INSERT INTO kor_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","오직 한나는 올라가지 아니하고 그 남편에게 이르되 아이를 젖 떼거든 내가 그를 데리고 가서 여호와 앞에 뵈게 하고 거기 영영히 있게 하리이다 ");
INSERT INTO kor_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","그 남편 엘가나가 그에게 이르되 `그대의 소견에 선한 대로 하여 그를 젖 떼기까지 기다리라 오직 여호와께서 그 말씀대로 이루시기를 원하노라' 이에 그 여자가 그 아들을 양육하며 그 젖 떼기까지 기다리다가 ");
INSERT INTO kor_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","젖을 뗀 후에 그를 데리고 올라갈새 수소 셋과 가루 한 에바와 포도주 한 가죽부대를 가지고 실로 여호와의 집에 나아갔는데 아이가 어리더라 ");
INSERT INTO kor_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","그들이 수소를 잡고 아이를 데리고 엘리에게 가서 ");
INSERT INTO kor_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","한나가 가로되 `나의 주여 ! 당신의 사심으로 맹세하나이다 나는 여기서 나의 주 당신 곁에 서서 여호와께 기도하던 여자라 ");
INSERT INTO kor_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","이 아이를 위하여 내가 기도하였더니 여호와께서 나의 구하여 기도한 바를 허락하신지라  (I Samuel 129) 그러므로 나도 그를 여호와께 드리되 그의 평생을 여호와께 드리나이다' 하고 그 아이는 거기서 여호와께 경배하니라  ");
INSERT INTO kor_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","한나가 기도하여 가로되 내 마음이 여호와를 인하여 즐거워 하며 내 뿔이 여호와를 인하여 높아졌으며 내 입이 내 원수들을 향하여 크게 열렸으니 이는 내가 주의 구원을 인하여 기뻐함이니이다 ");
INSERT INTO kor_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","여호와와 같이 거룩하신 이가 없으시니 이는 주 밖에 다른 이가 없고 우리 하나님 같은 반석도 없으심이니이다 ");
INSERT INTO kor_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","심히 교만한 말을 다시 하지 말 것이며 오만한 말을 너희 입에서 내지 말지어다 ! 여호와는 지식의 하나님이시라 행동을 달아보시느니라 ");
INSERT INTO kor_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","용사의 활은 꺾이고 넘어진 자는 힘으로 띠를 띠도다 ");
INSERT INTO kor_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","유족하던 자들은 양식을 위하여 품을 팔고 주리던 자들은 다시 주리지 않도다 전에 잉태치 못하던 자는 일곱을 낳았고 많은 자녀를 둔 자는 쇠약하도다 ");
INSERT INTO kor_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","여호와는 죽이기도 하시고 살리기도 하시며 음부에 내리게도 하시고 올리기도 하시는도다 ");
INSERT INTO kor_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","여호와는 가난하게도 하시고 부하게도 하시며, 낮추기도 하시고 높이기도 하시는도다 ");
INSERT INTO kor_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","가난한 자를 진토에서 일으키시며 빈핍한 자를 거름더미에서 드사 귀족들과 함께 앉게 하시며 영광의 위를 차지하게 하시는도다 땅의 기둥들은 여호와의 것이라 여호와께서 세계를 그 위에 세우셨도다 ");
INSERT INTO kor_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","그가 그 거룩한 자들의 발을 지키실 것이요 악인으로 흑암 중에서 잠잠케 하시리니 힘으로는 이길 사람이 없음이로다 ");
INSERT INTO kor_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","여호와를 대적하는 자는 산산이 깨어질 것이라 하늘 우뢰로 그들을 치시리로다 여호와께서 땅끝까지 심판을 베푸시고 자기 왕에게 힘을 주시며 자기의 기름 부음을 받은 자의 뿔을 높이시리로다 하니라 ");
INSERT INTO kor_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","엘가나는 라마의 자기 집으로 돌아가고 그 아이는 제사장 엘리 앞에서 여호와를 섬기니라 ");
INSERT INTO kor_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","엘리의 아들들은 불량자라 여호와를 알지 아니하더라 ");
INSERT INTO kor_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","그 제사장들이 백성에게 행하는 습관은 이러하니 곧 아무 사람이 제사를 드리고 그 고기를 삶을 때에 제사장의 사환이 손에 세살 갈고리를 가지고 와서 ");
INSERT INTO kor_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","그것으로 남비에나 솥에나 큰 솥에나 가마에 찔러 넣어서 갈고리에 걸려 나오는 것은 제사장이 자기 것으로 취하되 실로에서 무릇 그 곳에 온 이스라엘 사람에게 이같이 할 뿐 아니라 ");
INSERT INTO kor_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","기름을 태우기 전에도 제사장의 사환이 와서 제사 드리는 사람에게 이르기를 `제사장에게 구워 드릴 고기를 내라 그가 네게 삶은 고기를 원치 아니하고 날것을 원하신다' 하다가 ");
INSERT INTO kor_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","그 사람이 이르기를 `반드시 먼저 기름을 태운 후에 네 마음에 원하는 대로 취하라` 하면 그가 말하기를 `아니라 지금 내게 내라 그렇지 아니하면 내가 억지로 빼앗으리라' 하였으니 ");
INSERT INTO kor_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","이 소년들의 죄가 여호와 앞에 심히 큼은 그들이 여호와의 제사를 멸시함이었더라 ");
INSERT INTO kor_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","사무엘이 어렸을 때에 세마포 에봇을 입고 여호와 앞에 섬겨더라 ");
INSERT INTO kor_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","그 어미가 매년제를 드리러 그 남편과 함께 올라갈 때마다 작은 겉옷을 지어다가 그에게 주었더니 ");
INSERT INTO kor_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","엘리가 엘가나와 그 아내에게 축복하여 가로되 `여호와께서 이 여인으로 말미암아 네게 후사를 주사 이가 여호와께 간구하여 얻어드린 아들을 대신하게 하시기를 원하노라' 하였더니 그들이 그 집으로 돌아가매 ");
INSERT INTO kor_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","여호와께서 한나를 권고하사 그로 잉태하여 세 아들과 두 딸을 낳게 하셨고 아이 사무엘은 여호와앞에서 자라니라 ");
INSERT INTO kor_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","엘리가 매우 늙었더니 그 아들들이 온 이스라엘에게 행한 모든 일과 회막문에서 수종드는 여인과 동침하였음을 듣고 ");
INSERT INTO kor_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","그들에게 이르되 `너희가 어찌하여 이런 일을 하느냐 ? 내가 너희의 악행을 이 모든 백성에게서 듣노라 ");
INSERT INTO kor_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","내 아들아 그리 말라 내게 들리는 소문이 좋지 아니하니라 너희가 여호와의 백성으로 범과케 하는도다 ");
INSERT INTO kor_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","사람이 사람에게 범죄하면 하나님이 판결하시려니와 사람이 여호와께 범죄하면 누가 위하여 간구하겠느냐 ?` 하되 그들이 그 아비의 말을 듣지 아니하였으니 이는 여호와께서 그들을 죽이기로 뜻하셨음이었더라 ");
INSERT INTO kor_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","아이 사무엘이 점점 자라매 여호와와 사람들에게 은총을 더욱 받더라 ");
INSERT INTO kor_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","하나님의 사람이 엘리에게 와서 그에게 이르되 `여호와의 말씀에 너희 조상의 집이 애굽에서 바로의 집에 속하였을 때에 내가 그들에게 나타나지 아니하였느냐 ? ");
INSERT INTO kor_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","이스라엘 모든 지파 중에서 내가 그를 택하여 나의 제사장을 삼아 그로 내 단에 올라 분향하며 내 앞에서 에봇을 입게 하지 아니하였느냐 ? 이스라엘 자손의 드리는 모든 화제를 내가 네 조상의 집에 주지 아니하였느냐 ? ");
INSERT INTO kor_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","너희는 어찌하여 내가 나의 처소에서 명한 나의 제물과 예물을 밟으며 네 아들들을 나보다 더 중히 여겨 내 백성 이스라엘의 드리는 가장 좋은 것으로 스스로 살지게 하느냐 ? ");
INSERT INTO kor_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","그러므로 이스라엘의 하나님 나 여호와가 말하노라 내가 전에 네 집과 네 조상의 집이 내 앞에 영영히 행하리라 하였으나 이제 나 여호와가 말하노니 결단코 그렇게 아니하리라 나를 존중히 여기는 자를 내가 존중히 여기고 나를 멸시하는 자를 내가 경멸히 여기리라 ");
INSERT INTO kor_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","보라, 내가 네 팔과 네 조상의 집 팔을 끊어 네 집에 노인이 하나도 없게 하는 날이 이를지라 ");
INSERT INTO kor_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","이스라엘에게 모든 복을 베푸는 중에 너는 내 처소의 환난을 볼 것이요 네 집에 영영토록 노인이 없을 것이며 ");
INSERT INTO kor_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","내 단에서 내가 끊어 버리지 아니할 너의 사람이 네 눈을 쇠잔케 하고 네 마음을 슬프게 할 것이요 네 집에 생산하는 모든 자가 젊어서 죽으리라 ");
INSERT INTO kor_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","네 두 아들 홉니와 비느하스가 한 날에 죽으리니 그 둘의 당할 그 일이 네게 표징이 되리라 ");
INSERT INTO kor_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","내가 나를 위하여 충실한 제사장을 일으키리니 그 사람은 내 마음 내 뜻대로 행할 것이라 내가 그를 위하여 견고한 집을 세우리니 그가 나의 기름 부음을 받은 자 앞에서 영구히 행하리라 ");
INSERT INTO kor_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","네 집에 남은 사람이 각기 와서 은 한 조각과 떡 한 덩이를 위하여 그에게 엎드려 가로되 청하노니 내게 한 제사장의 직분을 맡 겨 나로 떡 조각을 먹게 하소서 하리라 하셨다' 하니라 ");
INSERT INTO kor_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","아이 사무엘이 엘리 앞에서 여호와를 섬길 때에는 여호와의 말씀이 희귀하여 이상이 흔히 보이지 않았더라 ");
INSERT INTO kor_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","엘리의 눈이 점점 어두워 가서 잘 보지 못하는 그 때에 그가 자기 처소에 누웠고 ");
INSERT INTO kor_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","하나님의 등불은 아직 꺼지지 아니하였으며 사무엘은 하나님의 궤 있는 여호와의 전 안에 누웠더니 ");
INSERT INTO kor_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","여호와께서 사무엘을 부르시는지라 그가 대답하되 `내가 여기 있나이다' 하고 ");
INSERT INTO kor_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","엘리에게로 달려가서 가로되 `당신이 나를 부르셨기로 내가 여기 있나이다' 가로되 `나는 부르지 아니하였으니 다시 누우라' 그가 가서 누웠더니 ");
INSERT INTO kor_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","여호와께서 다시 사무엘을 부르시는지라 사무엘이 일어나서 엘리에게로 가서 가로되 `당신이 나를 부르셨기로 내가 여기 있나이다' 대답하되 `내 아들아 내가 부르지 아니 하였으니 다시 누우라' 하니라 ");
INSERT INTO kor_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","사무엘이 아직 여호와를 알지 못하고 여호와의 말씀도 아직 그에게 나타나지 아니한 때라 ");
INSERT INTO kor_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","여호와께서 세번째 사무엘을 부르시는지라 그가 일어나서 엘리에게로 가서 가로되 `당신이 나를 부르셨기로 내가 여기 있나이다' 엘리가 여호와께서 이 아이를 부르신 줄을 깨닫고 ");
INSERT INTO kor_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","이에 사무엘에게 이르되 `가서 누웠다가 그가 너를 부르시거든 네가 말하기를 여호와여 말씀하옵소서 주의 종이 듣겠나이다 하라' 이에 사무엘이 가서 자기 처소에 누우니라 ");
INSERT INTO kor_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","여호와께서 임하여 서서 전과 같이 사무엘아 ! 사무엘아 ! 부르시는지라 사무엘이 가로되 `말씀하옵소서 주의 종이 듣겠나이다' ");
INSERT INTO kor_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","여호와께서 사무엘에게 이르시되 보라, 내가 이스라엘 중에 한 일을 행하리니 그것을 듣는 자마다 두 귀가 울리리라 ");
INSERT INTO kor_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","내가 엘리의 집에 대하여 말한 것을 처음부터 끝까지 그날에 그에게 다 이루리라 ");
INSERT INTO kor_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","내가 그 집을 영영토록 심판하겠다고 그에게 이른 것은 그의 아는 죄악을 인함이니 이는 그가 자기 아들들이 저주를 자청하되 금하지 아니하였음이니라 ");
INSERT INTO kor_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","그러므로 내가 엘리의 집에 대하여 맹세하기를 엘리 집의 죄악은 제물이나 예물로나 영영히 속함을 얻지 못하리라 하였노라 ");
INSERT INTO kor_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","사무엘이 아침까지 누웠다가 여호와의 집 문을 열었으나 그 이상을 엘리에게 알게 하기를 두려워하더니 ");
INSERT INTO kor_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","엘리가 사무엘을 불러 가로되 `내 아들 사무엘아' 하니 대답하되 `내가 여기 있나이다' ");
INSERT INTO kor_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","가로되 `네게 무엇을 말씀하셨느냐 청하노니 내게 숨기지 말라 네게 말씀하신 모든 것을 하나라도 숨기면 하나님이 네게 벌을 내리시고 또 내리시기를 원하노라' ");
INSERT INTO kor_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","사무엘이 세세히 말하고 조금도 숨기지 아니하니 그가 가로되 `이는 여호와시니 선하신 소견대로 하실 것이니라' 하니라 ");
INSERT INTO kor_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","사무엘이 자라매 여호와께서 그와 함께 계셔서 그 말로 하나도 땅에 떨어지지 않게 하시니 ");
INSERT INTO kor_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","단에서부터 브엘세바까지의 온 이스라엘이 사무엘은 여호와의 선지자로 세우심을 입은 줄을 알았더라 ");
INSERT INTO kor_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","여호와께서 실로에서 다시 나타나시되 여호와께서 실로에서 여호와의 말씀으로 사무엘에게 자기를 나타내시니 ");
INSERT INTO kor_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","사무엘의 말이 온 이스라엘에 전파되니라 이스라엘은 나가서 블레셋 사람과 싸우려고 에벤에셀 곁에 진 치고 블레셋 사람은 아벡에 진 쳤더니 ");
INSERT INTO kor_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","이스라엘을 대하여 항오를 벌이니라 그 둘이 싸우다가 이스라엘이 블레셋 사람 앞에서 패하여 그들에게 전쟁에서 죽임을 당한 군사가 사천명 가량이라 ");
INSERT INTO kor_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","백성이 진으로 돌아오매 이스라엘 장로들이 가로되 `여호와께서 어찌하여 우리로 오늘 블레셋 사람 앞에 패하게 하셨는고 여호와의 언약궤를 실로에서 우리에게로 가져다가 우리 중에 있게 하여 그것으로 우리를 우리 원수들의 손에서 구원하게 하자' 하니 ");
INSERT INTO kor_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","이에 백성이 실로에 보내어 그룹 사이에 계신 만군의 여호와의 언약궤를 거기서 가져 왔고 엘리의 두 아들 홉니와 비느하스는 하나님의 언약궤와 함께 거기 있었더라 ");
INSERT INTO kor_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","여호와의 언약궤가 진에 들어 올 때에 온 이스라엘이 큰 소리로 외치매 땅이 울린지라 ");
INSERT INTO kor_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","블레셋 사람이 그 외치는 소리를 듣고 가로되 `히브리 진에서 큰 소리로 외침은 어찜이뇨 ?' 하다가 여호와의 궤가 진에 들어온 줄을 깨달은지라 ");
INSERT INTO kor_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","블레셋 사람이 두려워하여 가로되 `신이 진에 이르렀도다' 하고 또 가로되 `우리에게 화로다 전일에는 이런 일이 없었도다 ");
INSERT INTO kor_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","우리에게 화로다 누가 우리를 이 능한 신들의 손에서 건지리요 그들은 광야에서 여러가지 재앙으로 애굽인을 친 신들이니라 ");
INSERT INTO kor_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","너희 블레셋 사람들아 강하게 되며 대장부가 되어라 너희가 히브리 사람의 종이 되기를 그들이 너희의 종이 되었던 것 같이 말고 대장부 같이 되어 싸우라' 하고 ");
INSERT INTO kor_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","블레셋 사람이 쳤더니 이스라엘이 패하여 각기 장막으로 도망하였고 살륙이 심히 커서 이스라엘 보병의 엎드러진 자가 삼만이었으며 ");
INSERT INTO kor_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","하나님의 궤는 빼앗겼고 엘리의 두 아들 홉니와 비느하스는 죽임을 당하였더라 ");
INSERT INTO kor_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","당일에 어떤 베냐민 사람이 진에서 달려나와 그 옷을 찢고 그 머리에 티끌을 무릅쓰고 실로에 이르니라 ");
INSERT INTO kor_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","그가 이를 때는 엘리가 길 곁 자기 의자에 앉아 기다리며 그 마음이 여호와의 궤로 인하여 떨릴 즈음이라 그 사람이 성에 들어 오며 고하매 온 성이 부르짖는지라 ");
INSERT INTO kor_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","엘리가 그 부르짖는 소리를 듣고 가로되 `이 훤화하는 소리는 어찜이뇨' 그 사람이 빨리 와서 엘리에게 고하니 ");
INSERT INTO kor_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","때에 엘리의 나이 구십 팔이라 그 눈이 어두워서 보지 못하더라 ");
INSERT INTO kor_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","그사람이 엘리에게 고하되 `나는 진 중에서 나온 자라 내가 오늘 진 중에서 도망하여 왔나이다' 엘리가 가로되 `내 아들아 일이 어찌되었느냐 ?' ");
INSERT INTO kor_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","소식을 전하는 자가 대답하여 가로되 `이스라엘이 블레셋 사람 앞에서 도망하였고 백성 중에는 큰 살륙이 있었고 당신의 두 아들 홉니와 비느하스도 죽임을 당하였고 하나님의 궤는 빼앗겼나이다' ");
INSERT INTO kor_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","하나님의 궤를 말할 때에 엘리가 자기 의자에서 자빠져 문 곁에서 목이 부러져 죽었으니 나이 많고 비둔한 연고라 그가 이스라엘 사사가 된지 사십년이었더라 ");
INSERT INTO kor_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","그의 며느리 비느하스의 아내가 잉태하여 산기가 가까왔더니 하나님의 궤 빼앗긴 것과 그 시부와 남편의 죽은 소문을 듣고 갑자기 아파서 몸을 구푸려 해산하고 ");
INSERT INTO kor_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","죽어갈 때에 곁에 섰던 여인들이 그에게 이르되 `두려워 말라 네가 아들을 낳았다' 하되 그가 대답지도 아니하며 관념치도 아니하고 ");
INSERT INTO kor_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","이르기를 `영광이 이스라엘에서 떠났다' 하고 아이 이름을 이가봇이라 하였으니 하나님의 궤가 빼앗겼고 그 시부와 남편이 죽었음을 인함이며 ");
INSERT INTO kor_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","또 이르기를 하나님의 궤를 빼앗겼으므로 영광이 이스라엘에서 떠났다 하였더라 ");
INSERT INTO kor_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","블레셋 사람이 하나님의 궤를 빼앗아 가지고 에벤에셀에서부터 아스돗에 이르니라 ");
INSERT INTO kor_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","블레셋 사람이 하나님의 궤를 가지고 다곤의 당에 들어가서 다곤의 곁에 두었더니 ");
INSERT INTO kor_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","아스돗 사람이 이튿날 일찌기 일어나 본즉 다곤이 여호와의 궤 앞에서 엎드러져 그 얼굴이 땅에 닿았는지라 그들이 다곤을 일으켜 다시 그 자리에 세웠더니 ");
INSERT INTO kor_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","그 이튿날 아침에 그들이 일찌기 일어나 본즉 다곤이 여호와의 궤 앞에서 엎드러져 얼굴이 땅에 닿았고 그 머리와 두 손목은 끊어져 문지방에 있고 다곤의 몸둥이만 남았더라 ");
INSERT INTO kor_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","그러므로 다곤의 제사장들이나 다곤의 당에 들어가는 자는 오늘까지 아스돗에 있는 다곤의 문지방을 밟지 아니하더라 ");
INSERT INTO kor_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","여호와의 손이 아스돗 사람에게 엄중히 더하사 독종의 재앙으로 아스돗과 그 지경을 쳐서 망하게 하니 ");
INSERT INTO kor_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","아스돗 사람들이 이를 보고 가로되 `이스라엘 신의 궤를 우리와 함께 있게 못할지라 그 손이 우리와 우리 신 다곤을 친다' 하고 ");
INSERT INTO kor_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","이에 보내어 블레셋 사람의 모든 방백을 모으고 가로되 `우리가 이스라엘 신의 궤를 어찌할꼬' 그들이 대답하되 `이스라엘 신의 궤를 가드로 옮겨 가라' 하므로 이스라엘 신의 궤를 옮겨 갔더니 ");
INSERT INTO kor_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","그것을 옮겨간 후에 여호와의 손이 심히 큰 환난을 그 성에 더하사 성읍 사람의 작은 자와 큰 자를 다 쳐서 독종이 나게 하신지라 ");
INSERT INTO kor_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","이에 그들이 하나님의 궤를 에그론으로 보내니라 하나님의 궤가 에그론에 이른즉 에그론 사람이 부르짖어 가로되 `그들이 이스라엘 신의 궤를 우리에게로 가져다가 우리와 우리 백성을 죽이려 한다' 하고 ");
INSERT INTO kor_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","이에 보내어 블레셋 모든 방백을 모으고 가로되 `이스라엘 신의 궤를 보내어 본처로 돌아가게 하고 우리와 우리 백성 죽임을 면케 하자' 하니 이는 온 성이 사망의 환난을 당함이라 거기서 하나님의 손이 엄중하시므로 ");
INSERT INTO kor_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","죽지 아니한 사람들은 독종으로 치심을 받아 성읍의 부르짖음이 하늘에 사무쳤더라 ");
INSERT INTO kor_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","여호와의 궤가 블레셋 사람의 지방에 있은지 일곱 달이라 ");
INSERT INTO kor_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","블레셋 사람이 제사장들과 복술자들을 불러서 이르되 `우리가 여호와의 궤를 어떻게 할꼬 그것을 어떻게 본처로 보낼 것을 우리에게 가르치라' ");
INSERT INTO kor_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","그들이 가로되 `이스라엘 신의 궤를 보내려거든 거저 보내지 말고 그에게 속건제를 드려야 할지니라 그리하면 병도 낫고 그 손을 너희에게서 옮기지 아니하는 연고도 알리라' ");
INSERT INTO kor_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","그들이 가로되 `무엇으로 그에게 드릴 속건제를 삼을꼬' 가로되 `블레셋 사람의 방백의 수효대로 금독종 다섯과 금쥐 다섯이라야 하리니 너희와 너희 방백에게 내린 재앙이 일반임이니라 ");
INSERT INTO kor_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","그러므로 너희는 너희 독종의 형상과 땅을 해롭게 하는 쥐의 형상을 만들어 이스라엘 신께 영화를 돌리라 그가 혹 그 손을 너희와 너희 신들과 너희 땅에서 경하게 하실까 하노라 ");
INSERT INTO kor_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","애굽인과 바로가 그 마음을 강퍅케 한 것같이 어찌하여 너희가 너희 마음을 강퍅케 하겠느냐 ? 그가 그들 중에서 기이하게 행한 후에 그들이 백성을 가게 하므로 백성이 떠나지 아니하였느냐 ? ");
INSERT INTO kor_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","그러므로 새 수레를 만들고 멍에 메어 보지 아니한 젖 나는 소 둘을 끌어다가 수레를 소에 메우고 그 송아지들은 떼어 집으로 돌려 보내고 ");
INSERT INTO kor_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","여호와의 궤를 가져다가 수레에 싣고 속건제 드릴 금 보물은 상자에 담아 궤 곁에 두고 그것을 보내어 가게 하고 ");
INSERT INTO kor_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","보아서 궤가 그 본 지경 길로 올라가서 벧세메스로 가면 이 큰 재앙은 그가 우리에게 내린 것이요 그렇지 아니하면 우리를 친 것이 그 손이 아니요 우연히 만난 것인 줄 알리라' ");
INSERT INTO kor_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","그 사람들이 그같이 하여 젖나는 소 둘을 끌어다가 수레를 메우고 송아지들은 집에 가두고 ");
INSERT INTO kor_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","여호와의 궤와 및 금쥐와 그들의 독종의 형상을 담은 상자를 수레 위에 실으니 ");
INSERT INTO kor_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","암소가 벧세메스 길로 바로 행하여 대로로 가며 갈 때에 울고 좌우로 치우치지 아니하였고 블레셋 방백들은 벧세메스 경계까지 따라 가니라 ");
INSERT INTO kor_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","벧세메스 사람들이 골짜기에서 밀을 베다가 눈을 들어 궤를 보고 그것의 보임을 기뻐하더니 ");
INSERT INTO kor_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","수레가 벧세메스 사람 여호수아의 밭 큰 돌 있는 곳에 이르러 선지라 무리가 수레의 나무를 패고 그 소를 번제로 여호와께 드리고 ");
INSERT INTO kor_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","레위인은 여호와의 궤와 그 궤와 함께 있는 금 보물 담긴 상자를 내려다가 큰 돌 위에 두매 그 날에 벧세메스 사람들이 여호와께 번제와 다른 제를 드리니라 ");
INSERT INTO kor_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","블레셋 다섯 방백이 이것을 보고 그날에 에그론으로 돌아갔더라 ");
INSERT INTO kor_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","블레셋 사람이 여호와께 속건제로 드린 금독종은 이러하니 아스돗을 위하여 하나요, 가사를 위하여 하나요, 아스글론을 위하여 하나요, 가드를 위하여 하나요, 에그론을 위하여 하나이며, ");
INSERT INTO kor_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","드린 바 금쥐는 여호와의 궤를 놓은 큰돌에 이르기까지의 모든 견고한 성읍과 시골 동리 곧 다섯 방백에게 속한 사람의 모든 성읍의 수효대로였더라 그 돌은 벧세메스 사람 여호수아의 밭에 오늘까지 있더라 ");
INSERT INTO kor_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","벧세메스 사람들이 여호와의 궤를 들여다 본 고로 그들을 치사 오만 칠십인을 죽이신지라 여호와께서 백성을 쳐서 크게 살륙하셨으므로 백성이 애곡하였더라 ");
INSERT INTO kor_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","벧세메스 사람들이 가로되 `이 거룩하신 하나님 여호와 앞에 누가 능히 서리요 그를 우리에게서 뉘게로 가시게 할꼬` 하고 ");
INSERT INTO kor_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","사자들을 기랏여아림 거민에게 보내어 가로되 `블레셋 사람이 여호와의 궤를 도로 가져왔으니 너희는 내려와서 그것을 너희에게로 옮겨 가라' ");
INSERT INTO kor_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","기랏여아림 사람들이 와서 여호와의 궤를 옮겨 산에 사는 아비나답의 집에 들여 놓고 그 아들 엘리아살을 거룩히 구별하여 여호와의 궤를 지키게 하였더니 ");
INSERT INTO kor_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","사무엘이 이스라엘 온 족속에게 일러 가로되 `너희가 전심으로 여호와께 돌아오려거든 이방 신들과 아스다롯을 너희 중에서 제하고 너희 마음을 여호와께로 향하여 그만 섬기라 너희를 블레셋 사람의 손에서 건져내시리라' ");
INSERT INTO kor_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","이에 이스라엘 자손이 바알들과 아스다롯을 제하고 여호와만 섬기니라 ");
INSERT INTO kor_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","사무엘이 가로되 `온 이스라엘은 미스바로 모이라 내가 너희를 위하여 여호와께 기도하리라' 하매 ");
INSERT INTO kor_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","그들이 미스바에 모여 물을 길어 여호와 앞에 붓고 그날에 금식하고 거기서 가로되 `우리가 여호와께 범죄하였나이다' 하니라 사무엘이 미스바에서 이스라엘 자손을 다스리니라 ");
INSERT INTO kor_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","이스라엘 자손이 미스바에 모였다 함을 블레셋 사람이 듣고 그 방백들이 이스라엘을 치러 올라온지라 이스라엘 자손이 듣고 블레셋 사람을 두려워하여 ");
INSERT INTO kor_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","사무엘에게 이르되 `당신은 우리를 위하여 우리 하나님 여호와께 쉬지 말고 부르짖어 우리를 블레셋 사람의 손에서 구원하시게 하소서' ");
INSERT INTO kor_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","사무엘이 젖 먹는 어린 양을 취하여 온전한 번제를 여호와께 드리고 이스라엘을 위하여 여호와께 부르짖으매 여호와께서 응답하셨더라 ");
INSERT INTO kor_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","사무엘이 번제를 드릴 때에 블레셋 사람이 이스라엘과 싸우려고 가까이 오매 그날에 여호와께서 블레셋 사람에게 큰 우뢰를 발하여 그들을 어지럽게 하시니 그들이 이스라엘 앞에 패한지라 ");
INSERT INTO kor_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","이스라엘 사람들이 미스바에서 나가서 블레셋 사람을 따라 벧갈 아래에 이르기까지 쳤더라 ");
INSERT INTO kor_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","사무엘이 돌을 취하여 미스바와 센 사이에 세워 가로되 `여호와께서 여기까지 우리를 도우셨다' 하고 그이름을 에벤에셀이라 하니라 ");
INSERT INTO kor_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","이에 블레셋 사람이 굴복하여 다시는 이스라엘 경내에 들어오지 못하였으며 여호와의 손이 사무엘의 사는 날 동안에 블레셋 사람을 막으시매 ");
INSERT INTO kor_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","블레셋 사람이 이스라엘에게서 빼앗았던 성읍이 에그론부터 가드까지 이스라엘에게 회복되니 이스라엘이 그 사방 지경을 블레셋 사람의 손에서 도로 찾았고 또 이스라엘과 아모리 사람 사이에 평화가 있었더라 ");
INSERT INTO kor_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","사무엘이 사는 날 동안에 이스라엘을 다스렸으되 ");
INSERT INTO kor_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","해마다 벧엘과 길갈과 미스바로 순회하여 그 모든 곳에서 이스라엘을 다스렸고 ");
INSERT INTO kor_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","라마로 돌아왔으니 이는 거기 자기 집이 있음이라 거기서도 이스라엘을 다스렸으며 또 거기 여호와를 위하여 단을 쌓았더라 ");
INSERT INTO kor_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","사무엘이 늙으매 그 아들들로 이스라엘 사사를 삼으니 ");
INSERT INTO kor_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","장자의 이름은 요엘이요 차자의 이름은 아비야라 그들이 브엘세 바에서 사사가 되니라 ");
INSERT INTO kor_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","그 아들들이 그 아비의 행위를 따르지 아니하고 이를 따라서 뇌물을 취하고 판결을 굽게 하니라 ");
INSERT INTO kor_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","이스라엘 모든 장로가 모여 라마에 있는 사무엘에게 나아가서 ");
INSERT INTO kor_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","그에게 이르되 `보소서 당신은 늙고 당신의 아들들은 당신의 행위를 따르지 아니하니 열방과 같이 우리에게 왕을 세워 우리를 다스리게 하소서' 한지라 ");
INSERT INTO kor_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","우리에게 왕을 주어 우리를 다스리게 하라 한 그것을 사무엘이 기뻐하지 아니하여 여호와께 기도하매 ");
INSERT INTO kor_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","여호와께서 사무엘에게 이르시되 백성이 네게 한 말을 다 들으라 그들이 너를 버림이 아니요 나를 버려 자기들의 왕이 되지 못하게 함이니라 ");
INSERT INTO kor_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","내가 그들을 애굽에서 인도하여낸 날부터 오늘날까지 그들이 모든 행사로 나를 버리고 다른 신들을 섬김같이 네게도 그리하는도다 ");
INSERT INTO kor_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","그러므로 그들의 말을 듣되 너는 그들에게 엄히 경계하고 그들을 다스릴 왕의 제도를 알게 하라 ");
INSERT INTO kor_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","사무엘이 왕을 구하는 백성에게 여호와의 모든 말씀을 일러 ");
INSERT INTO kor_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","가로되 `너희를 다스릴 왕의 제도가 이러하니라 그가 너희 아들들을 취하여 그 병거와 말을 어거케 하리니 그들이 그 병거 앞에서 달릴 것이며 ");
INSERT INTO kor_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","그가 또 너희 아들들로 천부장과 오십부장을 삼을 것이며 자기 밭을 갈게 하고 자기 추수를 하게 할 것이며 자기 병거와 병거의 제구를 만들게 할 것이며 ");
INSERT INTO kor_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","그가 또 너희 딸들을 취하여 향료 만드는 자와 요리하는 자와 떡굽는 자를 삼을 것이며 ");
INSERT INTO kor_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","그가 또 너희 밭과 포도원과 감람원의 제일 좋은 것을 취하여 자기 신하들에게 줄 것이며 ");
INSERT INTO kor_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","그가 또 너희 곡식과 포도원 소산의 십일조를 취하여 자기 관리와 신하에게 줄 것이며 ");
INSERT INTO kor_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","그가 또 너희 노비와 가장 아름다운 소년과 나귀들을 취하여 자기 일을 시킬 것이며 ");
INSERT INTO kor_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","너희 양떼의 십분 일을 취하리니 너희가 그 종이 될 것이라 ");
INSERT INTO kor_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","그날에 너희가 너희 택한 왕을 인하여 부르짖되 그날에 여호와께서 너희에게 응답지 아니하시리라' ");
INSERT INTO kor_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","백성이 사무엘의 말 듣기를 거절하여 가로되 `아니로소이다 우리도 우리 왕이 있어야 하리니 ");
INSERT INTO kor_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","우리도 열방과 같이 되어 우리 왕이 우리를 다스리며 우리 앞에 나가서 우리의 싸움을 싸워야 할 것이니이다' ");
INSERT INTO kor_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","사무엘이 백성의 모든 말을 듣고 여호와께 고하매 ");
INSERT INTO kor_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","여호와께서 사무엘에게 이르시되 그들의 말을 들어 왕을 세우라 하시니 사무엘이 이스라엘 사람들에게 이르되 `너희는 각기 성읍으로 돌아가라' 하니라 ");
INSERT INTO kor_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","베냐민 지파에 기스라 이름하는 유력한 사람이 있으니 그는 아비엘의 아들이요 스롤의 손자요 베고랏의 증손이요 아비아의 현손 이라 베냐민 사람이더라 ");
INSERT INTO kor_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","기스가 아들이 있으니 그 이름은 사울이요 준수한 소년이라 이스라엘 자손 중에 그보다 더 준수한 자가 없고 키는 모든 백성보다 어깨 위는 더하더라 ");
INSERT INTO kor_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","사울의 아비 기스가 암나귀들을 잃고 그 아들 사울에게 이르되 `너는 한 사환을 데리고 일어나 가서 암나귀들을 찾으라' 하매 ");
INSERT INTO kor_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","그가 에브라임 산지와 살리사 땅으로 두루 다니되 찾지 못하고 사알림 땅으로 두루 다니되 없고 베냐민 사람의 땅으로 두루 다니되 찾지 못하니라 ");
INSERT INTO kor_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","그들이 숩 땅에 이른 때에 사울이 함께 하는 사환에게 이르되 돌아가자 내 부친이 암나귀 생각은 고사하고 우리를 위하여 걱정하실까 두려워하노라 ");
INSERT INTO kor_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","대답하되 `보소서 이 성에 하나님의 사람이 있는데 존중히 여김을 받는 사람이라 그가 말한 것은 반드시 다 응하나니 그리로 가사이다 그가 혹 우리의 갈 길을 가르칠까 하나이다' ");
INSERT INTO kor_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","사울이 그 사환에게 이르되 `우리가 가면 그 사람에게 무엇을 드리겠느냐 ? 우리 그릇에 식물이 다하였으니 하나님의 사람에게 드릴 예물이 없도다 무엇이 있느냐 ?' ");
INSERT INTO kor_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","사환이 사울에게 다시 대답하여 가로되 `보소서 내 손에 은 한 세겔의 사분 일이 있으니 하나님의 사람에게 드려 우리 길을 가르치게 하겠나이다' ");
INSERT INTO kor_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","(옛적 이스라엘에 사람이 하나님께 가서 물으려 하면 말하기를 선견자에게로 가자 하였으니 지금 선지자라 하는 자를 옛적에는 선견자라 일컬었더라) ");
INSERT INTO kor_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","사울이 그 사환에게 이르되 `네 말이 옳다 가자` 하고 그들이 하나님의 사람 있는 성으로 가니라 ");
INSERT INTO kor_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","그들이 성을 향한 비탈길로 올라가다가 물 길러 나오는 소녀들을 만나 그들에게 묻되 `선견자가 여기 있느냐 ?' ");
INSERT INTO kor_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","그들이 대답하여 가로되 `있나이다 보소서 그가 당신보다 앞섰으니 빨리 가소서 백성이 오늘 산당에서 제사를 드리므로 그가 오늘 성에 들어오셨나이다 ");
INSERT INTO kor_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","당신들이 성으로 들어가면 그가 먹으러 산당에 올라가기 전에 곧 만나리이다 그가 오기 전에는 백성이 먹지 아니하나니 이는 그가 제물을 축사한 후에야 청함을 받은 자가 먹음이라 그러므로 지금올라 가소서 금시로 만나리이다' 하는지라 ");
INSERT INTO kor_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","그들이 성읍으로 올라가서 그리로 들어갈 때에 사무엘이 마침 산당으로 올라가려고 마주 나오더라 ");
INSERT INTO kor_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","사울의 오기 전 날에 여호와께서 사무엘에게 알게 하여 가라사대 ");
INSERT INTO kor_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","내일 이맘 때에 내가 베냐민 땅에서 한 사람을 네게 보내리니 너는 그에게 기름을 부어 내 백성 이스라엘의 지도자를 삼으라 그가 내 백성을 블레셋 사람의 손에서 구원하리라 내 백성의 부르짖음이 내게 상달하였으므로 내가 그들을 돌아 보았노라 하시더니 ");
INSERT INTO kor_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","사무엘이 사울을 볼 때에 여호와께서 그에게 이르시되 보라, 이는 내가 네게 말한 사람이니 이가 내 백성을 통할하리라 하시니라 ");
INSERT INTO kor_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","사울이 성문 가운데 사무엘에게 나아가 가로되 `선견자의 집이 어디인지 청컨대 내게 가르치소서' ");
INSERT INTO kor_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","사무엘이 사울에게 대답하여 가로되 `내가 선견자니라 너는 내 앞서 산당으로 올라가라 너희가 오늘날 나와 함께 먹을 것이요 아침에는 내가 너를 보내되 네 마음에 있는 것을 다 네게 말하리라 ");
INSERT INTO kor_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","사흘 전에 잃은 네 암나귀들을 염려하지 말라 찾았느니라 온 이스라엘의 사모하는 자가 누구냐 ? 너와 네 아비의 온 집이 아니냐 ?' ");
INSERT INTO kor_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","사울이 대답하여 가로되 `나는 이스라엘 지파의 가장 작은 지파 베냐민 사람이 아니오며 나의 가족은 베냐민 지파 모든 가족 중에 가장 미약하지 아니하니이까 당신이 어찌하여 내게 이같이 말씀하시나이까 ?' ");
INSERT INTO kor_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","사무엘이 사울과 그 사환을 인도하여 객실로 들어가서 청한 자 중 수석에 앉게 하였는데 객은 삼십명 가량이었더라 ");
INSERT INTO kor_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","사무엘이 요리인에게 이르되 `내가 네게 주며 네게 두라고 말한 그 부분을 가져오라' ");
INSERT INTO kor_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","요리인이 넓적다리와 그것에 붙은 것을 가져다가 사울 앞에 놓는지라 사무엘이 가로되 `보라, 이는 두었던 것이니 네 앞에 놓고 먹으라 내가 백성을 청할 때부터 너를 위하여 이것을 두어서 이때를 기다리게 하였느니라' 그 날에 사울이 사무엘과 함께 먹으니라 ");
INSERT INTO kor_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","그들이 산당에서 내려 성에 들어가서는 사무엘이 사울과 함께 지붕에서 담화하고 ");
INSERT INTO kor_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","그들이 일찌기 일어날새 동틀 때 즈음이라 사무엘이 지붕에서 사울을 불러 가로되 `일어나라 내가 너를 보내리라' 하매 사울이 일어나고 그 두 사람 사울과 사무엘이 함께 밖으로 나가서 ");
INSERT INTO kor_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","성읍 끝에 이르매 사무엘이 사울에게 이르되 `사환으로 우리를 앞서게 하라' 사환이 앞서매 또 가로되 `너는 이제 잠간 서 있으라 내가 하나님의 말씀을 네게 들리리라' ");
INSERT INTO kor_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","이에 사무엘이 기름병을 취하여 사울의 머리에 붓고 입맞추어 가로되 `여호와께서 네게 기름을 부으사 그 기업의 지도자를 삼지 아니하셨느냐 ? ");
INSERT INTO kor_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","네가 오늘 나를 떠나가다가 베냐민 경계 셀사에 있는 라헬의 묘실 곁에서 두 사람을 만나리니 그들이 네게 이르기를 네가 찾으러 갔던 암나귀들을 찾은지라 네 아비가 암나귀들의 염려는 놓았으나 너희를 인하여 걱정하여 가로되 내 아들을 위하여 어찌하리요 하더라 할 것이요 ");
INSERT INTO kor_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","네가 거기서 더 나아가서 다볼 상수리나무에 이르면 거기서 하나님께 뵈려고 벧엘로 올라가는 세 사람이 너와 만나리니 하나는 염소 새끼 셋을 이끌었고 하나는 떡 세덩이를 가졌고 하나는 포도주 한 가죽부대를 가진 자라 ");
INSERT INTO kor_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","그들이 네게 문안하고 떡 두 덩이를 주겠고 너는 그 손에서 받으리라 ");
INSERT INTO kor_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","그 후에 네가 하나님의 산에 이르리니 그곳에는 블레셋 사람의 영문이 있느니라 네가 그리로 가서 그 성읍으로 들어갈 때에 선지자의 무리가 산당에서부터 비파와 소고와 저와 수금을 앞세우고 예언하며 내려오는 것을 만날 것이요 ");
INSERT INTO kor_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","네게는 여호와의 신이 크게 임하리니 너도 그들과 함께 예언을 하고 변하여 새 사람이 되리라 ");
INSERT INTO kor_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","이 징조가 네게 임하거든 너는 기회를 따라 행하라 ! 하나님이 너와 함께 하시느니라 ! ");
INSERT INTO kor_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","너는 나보다 앞서 길갈로 내려가라 내가 네게로 내려가서 번제와 화목제를 드리리니 내가 네게 가서 너의 행할 것을 가르칠 때까지 칠일을 기다리라' ");
INSERT INTO kor_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","그가 사무엘에게서 떠나려고 몸을 돌이킬 때에 하나님이 새 마음을 주셨고 그 날 그 징조도 다 응하니라 ");
INSERT INTO kor_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","그들이 산에 이를 때에 선지자의 무리가 그를 영접하고 하나님의 신이 사울에게 크게 임하므로 그가 그들 중에서 예언을 하니 ");
INSERT INTO kor_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","전에 사울을 알던 모든 사람이 사울의 선지자들과 함께 예언함을 보고 서로 이르되 `기스의 아들의 당한 일이 무엇이뇨 사울도 선지자들 중에 있느냐' 하고 ");
INSERT INTO kor_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","그곳의 어떤 사람은 말하여 이르되 `그들의 아비가 누구냐 ?' 한지라 그러므로 속담이 되어 가로되 `사울도 선지자들 중에 있느냐 ?' 하더라 ");
INSERT INTO kor_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","사울이 예언하기를 마치고 산당으로 가니라 ");
INSERT INTO kor_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","사울의 숙부가 사울과 그 사환에게 이르되 `너희가 어디로 갔더냐 ?' 사울이 가로되 `암나귀들을 찾다가 얻지 못하므로 사무엘에게 갔었나이다' ");
INSERT INTO kor_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","사울의 숙부가 가로되 `청하노니 사무엘이 너희에게 이른 말을 내게 고하라' ");
INSERT INTO kor_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","사울이 그 숙부에게 말하되 `그가 암나귀들을 찾았다고 우리에게 분명히 말하더이다' 하고 사무엘의 말하던 나라의 일은 고하지 아니하니라 ");
INSERT INTO kor_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","사무엘이 백성을 미스바로 불러 여호와 앞에 모으고 ");
INSERT INTO kor_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","이스라엘 자손에게 이르되 `이스라엘 하나님 여호와께서 이같이 말씀하시기를 내가 이스라엘을 애굽에서 인도하여 내고 너희를 애굽인의 손과 너희를 압제하는 모든 나라의 손에서 건져내었느니라 하셨거늘 ");
INSERT INTO kor_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","너희가 너희를 모든 재난과 고통 중에서 친히 구원하여 내신 너희 하나님을 오늘날 버리고 이르기를 우리 위에 왕을 세우라 하도다 그런즉 이제 너희 지파대로 천명씩 여호와 앞에 나아오라' 하고 ");
INSERT INTO kor_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","사무엘이 이에 이스라엘 모든 지파를 가까이 오게 하였더니 베냐민 지파가 뽑혔고 ");
INSERT INTO kor_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","베냐민 지파를 그 가족대로 가까이 오게 하였더니 마드리의 가족이 뽑혔고 그 중에서 기스의 아들 사울이 뽑혔으나 그를 찾아도 만나지 못한지라 ");
INSERT INTO kor_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","그러므로 그들이 또 여호와께 묻되 `그 사람이 여기 왔나이까 ?' 여호와께서 대답하시되 그가 행구 사이에 숨었느니라 ");
INSERT INTO kor_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","그들이 달려가서 거기서 데려오매 그가 백성 중에 서니 다른 사람보다 어깨 위나 더 크더라 ");
INSERT INTO kor_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","사무엘이 모든 백성에게 이르되 `너희는 여호와의 택하신 자를 보느냐 ? 모든 백성중에 짝할 이가 없느니라' 하니 모든 백성이 왕의 만세를 외쳐 부르니라 ");
INSERT INTO kor_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","사무엘이 나라의 제도를 백성에게 말하고 책에 기록하여 여호와앞에 두고 모든 백성을 각기 집으로 보내매 ");
INSERT INTO kor_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","사울도 기브아 자기 집으로 갈 때에 마음이 하나님께 감동된 유력한 자들은 그와 함께 갔어도 ");
INSERT INTO kor_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","어떤 비류는 가로되 `이 사람이 어떻게 우리를 구원하겠느냐 ?' 하고 멸시하며 예물을 드리지 아니하니라 그러나 그는 잠잠하였더라 ");
INSERT INTO kor_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","암몬 사람 나하스가 올라와서 길르앗 야베스를 대하여 진 치매 야베스 모든 사람이 나하스에게 이르되 `우리와 언약하자 그리하면 우리가 너를 섬기리라' ");
INSERT INTO kor_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","암몬 사람 나하스가 그들에게 이르되 `내가 너희 오른 눈을 다 빼어야 너희와 언약하리라 내가 온 이스라엘을 이같이 모욕하리라' ");
INSERT INTO kor_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","야베스 장로들이 이르되 `우리에게 이레 유예를 주어 우리로 이스라엘 온 지경에 사자를 보내게 하라 우리를 구원할 자가 없으면 네게 나아가리라' 하니라 ");
INSERT INTO kor_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","이에 사자가 사울의 기브아에 이르러 이말을 백성에게 고하매 모든 백성이 소리를 높여 울더니 ");
INSERT INTO kor_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","마침 사울이 밭에서 소를 몰고 오다가 가로되 `백성이 무슨 일로 우느냐 ?' 그들이 야베스 사람의 말로 고하니라 ");
INSERT INTO kor_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","사울이 이 말을 들을 때에 하나님의 신에게 크게 감동되매 그 노가 크게 일어나서 ");
INSERT INTO kor_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","한 겨리 소를 취하여 각을 뜨고 사자의 손으로 그것을 이스라엘 모든 지경에 두루 보내어 가로되 `누구든지 나와서 사울과 사무엘을 좇지 아니하면 그 소들도 이와 같이 하리라' 하였더니 여호와의 두려움이 백성에게 임하매 그들이 한 사람같이 나온지라 ");
INSERT INTO kor_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","사울이 베섹에서 그들을 계수하니 이스라엘 자손이 삼십만이요 유다 사람이 삼만이더라 ");
INSERT INTO kor_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","무리가 온 사자들에게 이르되 `너희는 길르앗 야베스 사람에게 이같이 이르기를 내일 해가 더울 때에 너희가 구원을 얻으리라 하라' 사자들이 돌아가서 야베스 사람들에게 고하매 그들이 기뻐하니라 ");
INSERT INTO kor_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","야베스 사람들이 이에 가로되 `우리가 내일 너희에게 나아가리니 너희 소견에 좋을 대로 우리에게 다 행하라' 하니라 ");
INSERT INTO kor_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","이튿날에 사울이 백성을 삼대에 나누고 새벽에 적진 중에 들어가서 날이 더울 때까지 암몬 사람을 치매 남은 자가 다 흩어져서 둘도 함께 한 자가 없었더라 ");
INSERT INTO kor_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","백성이 사무엘에게 이르되 `사울이 어찌 우리를 다스리겠느냐 ? 한 자가 누구니이까 ? 그들을 끌어내소서 우리가 죽이겠나이다' ");
INSERT INTO kor_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","사울이 가로되 `이 날에는 사람을 죽이지 못하리니 여호와께서 오늘날 이스라엘 중에 구원을 베푸셨음이니라' ");
INSERT INTO kor_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","사무엘이 백성에게 이르되 `오라 ! 우리가 길갈로 가서 나라를 새롭게 하자` ");
INSERT INTO kor_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","모든 백성이 길갈로 가서 거기서 여호와 앞에 사울로 왕을 삼고 거기서 여호와 앞에 화목제를 드리고 사울과 이스라엘 모든 사람이 거기서 크게 기뻐하니라 ");
INSERT INTO kor_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","사무엘이 온 이스라엘에게 이르되 `보라, 너희가 내게 한 말을 내가 다 듣고 너희 위에 왕을 세웠더니 ");
INSERT INTO kor_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","이제 왕이 너희 앞에 출입하느니라 보라, 나는 늙어 머리가 희었고 내 아들들도 너희와 함께 있느니라 내가 어려서부터 오늘날까지 너희 앞에 출입하였거니와 ");
INSERT INTO kor_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","내가 여기 있나니 여호와 앞과 그 기름 부음을 받은 자 앞에서 내게 대하여 증거하라 내가 뉘 소를 취하였느냐 ? 뉘 나귀를 취하였느냐 ? 누구를 속였느냐 ? 누구를 압제하였느냐 ? 내 눈을 흐리게 하는 뇌물을 뉘 손에서 취하였느냐 ? 그리하였으면 내가 그것을 너희에게 갚으리라' ");
INSERT INTO kor_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","그들이 가로되 `당신이 우리를 속이지 아니하였고 압제하지 아니하였고 뉘 손에서 아무 것도 취한 것이 없나이다' ");
INSERT INTO kor_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","사무엘이 백성에게 이르되 `너희가 내 손에서 아무 것도 찾아낸 것이 없음을 여호와께서 너희에게 대하여 증거하시며 그 기름 부음을 받은 자도 오늘날 증거하느니라' 그들이 가로되 `그가 증거하시나이다' ");
INSERT INTO kor_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","사무엘이 백성에게 이르되 `모세와 아론을 세우시며 너희 열조를 애굽 땅에서 인도하여 내신 이는 여호와시니 ");
INSERT INTO kor_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","그런즉 가만히 섰으라 ! 여호와께서 너희와 너희 열조에게 행하신 모든 의로운 일에 대하여 내가 여호와 앞에서 너희와 담론하리라 ");
INSERT INTO kor_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","야곱이 애굽에 들어간 후 너희 열조가 여호와께 부르짖으매 여호와께서 모세와 아론을 보내사 그 두 사람으로 너희 열조를 애굽에서 인도하여 내어 이곳에 거하게 하셨으나 ");
INSERT INTO kor_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","그들이 그 하나님 여호와를 잊은지라 여호와께서 그들을 하솔 군장 시스라의 손과 블레셋 사람의 손과 모압 왕의 손에 붙이셨더니 그들이 치매 ");
INSERT INTO kor_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","백성이 여호와께 부르짖어 가로되 우리가 여호와를 버리고 바알들과 아스다롯을 섬기므로 범죄하였나이다 그러하오나 이제 우리를 원수들의 손에서 건져 내소서 그리하시면 우리가 주를 섬기겠나이다 하매 ");
INSERT INTO kor_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","여호와께서 여룹바알과 베단과 입다와 나 사무엘을 보내사 너희를 너희 사방 원수의 손에서 건져내사 너희로 안전히 거하게 하셨거늘 ");
INSERT INTO kor_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","너희가 암몬 자손의 왕 나하스의 너희를 치러 옴을 보고 너희 하나님 여호와께서는 너희의 왕이 되실지라도 너희가 내게 이르기를 아니라 우리를 다스릴 왕이 있어야 하겠다 하였도다 ");
INSERT INTO kor_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","이제 너희의 구한 왕 너희의 택한 왕을 보라 여호와께서 너희 위에 왕을 세우셨느니라 ");
INSERT INTO kor_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","너희가 만일 여호와를 경외하여 그를 섬기며 그 목소리를 듣고 여호와의 명령을 거역하지 아니하며 또 너희와 너희를 다스리는 왕이 너희 하나님 여호와를 좇으면 좋으니라마는 ");
INSERT INTO kor_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","너희가 만일 여호와의 목소리를 듣지 아니하고 여호와의 명령을 거역하면 여호와의 손이 너희의 열조를 치신 것 같이 너희를 치실 것이라 ");
INSERT INTO kor_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","너희는 이제 가만히 서서 여호와께서 너희 목전에 행하시는 이 큰 일을 보라, ");
INSERT INTO kor_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","오늘은 밀 베는 때가 아니냐 ? 내가 여호와께 아뢰리니 여호와께서 우뢰와 비를 보내사 너희가 왕을 구한 일 곧 여호와의 목전에 범한 죄악이 큼을 너희로 밝히 알게 하시리라' ");
INSERT INTO kor_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","이에 사무엘이 여호와께 아뢰매 여호와께서 그 날에 우뢰와 비를 보내시니 모든 백성이 여호와와 사무엘을 크게 두려워하니라 ");
INSERT INTO kor_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","모든 백성이 사무엘에게 이르되 `당신의 종들을 위하여 당신의 하나님 여호와께 기도하여 우리로 죽지 않게 하소서 ! 우리가 우리의 모든 죄에 왕을 구하는 악을 더하였나이다' ");
INSERT INTO kor_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","사무엘이 백성에게 이르되 `두려워 말라 ! 너희가 과연 이 모든 악을 행하였으나 여호와를 좇는 데서 돌이키지 말고 오직 너희 마음을 다하여 여호와를 섬기라 ! ");
INSERT INTO kor_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","돌이켜 유익하게도 못하며 구원하지도 못하는 헛된 것을 좇지 말라 ! 그들은 헛되니라 ");
INSERT INTO kor_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","여호와께서는 너희로 자기 백성 삼으신 것을 기뻐하신 고로 그 크신 이름을 인하여 자기 백성을 버리지 아니하실 것이요 ");
INSERT INTO kor_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","나는 너희를 위하여 기도하기를 쉬는 죄를 여호와 앞에 결단코 범치 아니하고 선하고 의로운 도로 너희를 가르칠 것인즉 ");
INSERT INTO kor_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","너희는 여호와께서 너희를 위하여 행하신 그 큰 일을 생각하여 오직 그를 경외하며 너희의 마음을 다하여 진실히 섬기라 ! ");
INSERT INTO kor_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","만일 너희가 여전히 악을 행하면 너희와 너희 왕이 다 멸망하리라' ");
INSERT INTO kor_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","사울이 왕이 될 때에 사십세라 그가 이스라엘을 다스린지 이년에 ");
INSERT INTO kor_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","이스라엘 사람 삼천을 택하여 그 중에서 이천은 자기와 함께 믹마스와 벧엘산에 있게 하고 일천은 요나단과 함께 베냐민 기브아에 있게 하고 남은 백성은 각기 장막으로 보내니라 ");
INSERT INTO kor_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","요나단이 게바에 있는 블레셋 사람의 수비대를 치매 블레셋 사람이 이를 들은지라 사울이 온 땅에 나팔을 불어 이르되 `히브리 사람들은 들으라' 하니 ");
INSERT INTO kor_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","온 이스라엘이 사울의 블레셋 사람의 수비대를 친 것과 이스라엘이 블레셋 사람의 가증히 여김이 되었다 함을 듣고 길갈로 모여 사울을 좇으니라 ");
INSERT INTO kor_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","블레셋 사람이 이스라엘과 싸우려 하여 모였는데 병거가 삼만이요 마병이 육천이요 백성은 해변의 모래 같이 많더라 그들이 올라와서 벧아웬 동편 믹마스에 진 치매 ");
INSERT INTO kor_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","이스라엘 사람들이 위급함을 보고 절박하여 굴과 수풀과 바위틈과 은밀한 곳과 웅덩이에 숨으며 ");
INSERT INTO kor_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","어떤 히브리 사람들은 요단을 건너 갓과 길르앗 땅으로 가되 사울은 아직 길갈에 있고 그를 좇은 모든 백성은 떨더라 ");
INSERT INTO kor_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","사울이 사무엘의 정한 기한대로 이레를 기다리되 사무엘이 길갈로 오지 아니하매 백성이 사울에게서 흩어지는지라 ");
INSERT INTO kor_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","사울이 가로되 `번제와 화목제물을 이리로 가져오라' 하여 번제를 드렸더니 ");
INSERT INTO kor_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","번제 드리기를 필하자 사무엘이 온지라 사울이 나가 맞으며 문안하매 ");
INSERT INTO kor_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","사무엘이 가로되 왕의 행한 것이 무엇이뇨 ? 사울이 가로되 백성은 나에게서 흩어지고 당신은 정한 날 안에 오지 아니하고 블레셋 사람은 믹마스에 모였음을 내가 보았으므로 ");
INSERT INTO kor_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","이에 내가 이르기를 블레셋 사람은 나를 치러 길갈로 내려오겠거늘 내가 여호와께 은혜를 간구치 못하였다 하고 부득이하여 번제를 드렸나이다 ");
INSERT INTO kor_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","사무엘이 사울에게 이르되 `왕이 망령되이 행하였도다 ! 왕이 왕의 하나님 여호와께서 왕에게 명하신 명령을 지키지 아니하였도다 그리하였더면 여호와께서 이스라엘 위에 왕의 나라를 영영히 세우셨을 것이어늘 ");
INSERT INTO kor_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","지금은 왕의 나라가 길지 못할 것이라 여호와께서 왕에게 명하신 바를 왕이 지키지 아니하였으므로 여호와께서 그 마음에 맞는 사람을 구하여 그 백성의 지도자를 삼으셨느니라' 하고 ");
INSERT INTO kor_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","사무엘이 일어나 길갈에서 떠나 베냐민 기브아로 올라가니라 사울이 자기와 함께 한 백성을 계수하니 육백명 가량이라 ");
INSERT INTO kor_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","사울과 그 아들 요나단과 그들과 함께한 백성은 베냐민 게바에 있고 블레셋 사람은 믹마스에 진쳤더니 ");
INSERT INTO kor_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","노략군들이 삼대로 블레셋 사람의 진에서 나와서 한 대는 오브라길로 말미암아 수알 땅에 이르렀고 ");
INSERT INTO kor_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","한 대는 벧호론 길로 향하였고 한 대는 광야를 향한 스보임 골짜기가 내려다 보이는 지경 길로 향하였더라 ");
INSERT INTO kor_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","때에 이스라엘 온 땅에 철공이 없어졌으니 이는 블레셋 사람이 말하기를 `히브리 사람이 칼이나 창을 만들까 두렵다' 하였음이라 ");
INSERT INTO kor_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","온 이스라엘 사람이 각기 보습이나 삽이나 도끼나 괭이를 벼리려면 블레셋 사람에게로 내려갔었는데 ");
INSERT INTO kor_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","곧 그들이 괭이나 삽이나 쇠스랑이나 도끼나 쇠채찍이 무딜 때에 그리하였으므로 ");
INSERT INTO kor_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","싸우는 날에 사울과 요나단과 함께한 백성의 손에는 칼이나 창이 없고 오직 사울과 그 아들 요나단에게만 있으니라 ");
INSERT INTO kor_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","블레셋 사람의 부대가 나와서 믹마스 어귀에 이르렀더라 ");
INSERT INTO kor_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","하루는 사울의 아들 요나단이 자기 병기를 든 소년에게 이르되 우리가 건너편 블레셋 사람의 부대에게로 건너가자 하고 그 아비에게는 고하지 아니하였더라 ");
INSERT INTO kor_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","사울이 기브아 변경 미그론에 있는 석류나무 아래 머물렀고 함께 한 백성은 육백명 가량이며 ");
INSERT INTO kor_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","아히야는 에봇을 입고 거기 있었으니 그는 이가봇의 형제 아히둡의 아들이요 비느하스의 손자요 실로에서 여호와의 제사장이 되었던 엘리의 증손이었더라 백성은 요나단의 간 줄을 알지 못하니라 ");
INSERT INTO kor_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","요나단이 블레셋 사람의 부대에게로 건너가려 하는 어귀 사이 이 편에도 험한 바위가 있고 저편에도 험한 바위가 있는데 하나의 이름은 보세스요 하나의 이름은 세네라 ");
INSERT INTO kor_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","한 바위는 북에서 믹마스 앞에 일어섰고 하나는 남에서 게바 앞에 일어섰더라 ");
INSERT INTO kor_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","요나단이 자기 병기 든 소년에게 이르되 `우리가 이 할례 없는 자들의 부대에게로 건너가자 여호와께서 우리를 위하여 일하실까 하노라 여호와의 구원은 사람의 많고 적음에 달리지 아니하였느니라 !' ");
INSERT INTO kor_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","병기 든 자가 그에게 이르되 `당신의 마음에 있는 대로 다 행하여 앞서 가소서 내가 당신과 마음을 같이 하여 따르리이다' ");
INSERT INTO kor_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","요나단이 가로되 `보라, 우리가 그 사람들에게로 건너가서 그들에게 보이리니 ");
INSERT INTO kor_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","그들이 만일 이같이 우리에게 이르기를 우리가 너희에게로 가기를 기다리라 하면 우리는 우리 곳에 가만히 서서 그들에게로 올라가지 말 것이요 ");
INSERT INTO kor_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","그들이 만일 이같이 말하기를 우리에게로 올라오라 하면 우리가 올라갈 것은 여호와께서 그들을 우리 손에 붙이셨음이니 이것이 우리에게 표징이 되리라' 하고 ");
INSERT INTO kor_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","둘이 다 블레셋 사람의 부대에게 보이매 블레셋 사람이 가로되 `보라, 히브리 사람이 그 숨었던 구멍에서 나온다' 하고 ");
INSERT INTO kor_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","그 부대 사람들이 요나단과 그 병기 든 자를 대하여 가로되 우리에게로 올라오라 너희에게 한 일을 보이리라 한지