﻿USE sofia;
DROP TABLE IF EXISTS sofia.kog_vpl;
CREATE TABLE kog_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kog_vpl WRITE;
INSERT INTO kog_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jalde kaltake Saldiñga netshi Jateja Asukuá Duwe Jesú zʉnekualdal gaxane shalda miñmeyaldikue. Duwe Jesúki nauwibama Dabí, Abaldahámtshi atukuaga. ");
INSERT INTO kog_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaldahámki nauwisaná juldiútshi abama Isák tshate. Eñki Jakóp tshate. Jakópki Judá, akajatshi jiaga ajate. ");
INSERT INTO kog_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judáki Paldes, Selda tshate. Ekuetshi ajabaki Tamál. Paldeski Esaldóñ tshate. Eñki Aldám tshate. ");
INSERT INTO kog_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aldámki Aminadáp tshate. Eñki Nasóñ tshate. Nasóñki Sadmóñ tshate. ");
INSERT INTO kog_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Eñki Bohós tshate. E tshabaki Aldaháp. Bohóski Obét tshate. E tshabaki Aldút. Obétki Isahí tshate. ");
INSERT INTO kog_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","E zʉnake nauwibama sáñkalda Dabí tshate. Nauwibama Dabíki Saldamóñ tshate. E tshabaki Uldiyatshi asewá nane. ");
INSERT INTO kog_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saldamóñki Aldubuám tshate. Eñki Abiya tshate. Abiyaki Asá tshate. ");
INSERT INTO kog_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Eñki Jusapá tshate. Jusapáki Juldám tshate. Eñki Usiyatshi abama. ");
INSERT INTO kog_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiyaki Jutám tshate. Eñki Akás tshate. Akáski Esekiya tshate. ");
INSERT INTO kog_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Eñki Manasé tshate. Manaséki Amó tshate. Eñki Jusiya tshate. ");
INSERT INTO kog_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jusiyaki Jekoniya, akajatshi jiaga abama. Kauwizhéñ baxañ na nauwisaná juldiúkue kauwijí kagik zhinik san kagi Babildonia kawaldenane. ");
INSERT INTO kog_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ekí kawaldeñguenik na, exaki Jekoniyatshi asukuá Saldatiél kuká. Eñki Suldubabéltshi abama. ");
INSERT INTO kog_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Suldubabélki Abiyúd tshate. Eñki Eldiakím tshate. Eldiakímki Asúl tshate. ");
INSERT INTO kog_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eñki Saldók tshate. Saldókki Akím tshate. Eñki Eldiúd tshate. ");
INSERT INTO kog_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eldiúdki Eldiasál tshate. Eñki Matán tshate. Matánki Jakóp tshate. ");
INSERT INTO kog_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakópki Jusé tshate. Juséjañki Maldiya guxane. Maldiyaki Duwe Jesútshi ajaba. Duwe Jesú zʉnake Jatejañga ezua zʉnekualdal gaxaldixa guakldanega nzha. ");
INSERT INTO kog_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Akze, Duwe Jesútshi abamakue miñmenugekueki ekí zhikldogamak nitshigatuka: Nauwibama Abaldahámka zhinik panane nauwibama sáñkalda Dabí baxañ yo 14 tukua nitshinane. Guñguenik nauwibama Dabí baxañ zhinik nauwisaná juldiúkue nauwijí kagik zhinik san kagi Babildonia kawaldene baxañ yo mokue 14 tukua nitshinane. Guñgueni jiak Babildonia kawaldene baxañ zhinik Duwe Jesúga Jateja zʉnekualdal gaxaldixa guakldane kukanéñ yo mokue 14 tukua nitshine nzha. ");
INSERT INTO kog_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Guatshake Duwe Jesú Zʉnekualkaki ixagabaldeshi jai kagik ekí kukane: Ajaba nexaldixa Maldiyaki ezua sigí Jusé na akuxaldixa jeñ ashishá akuanekue na naldá. Naldatshak askuildegagáñga aldogueñga Jatetshi Aldunajañga somá akzalshane. ");
INSERT INTO kog_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ekí aksʉ́ñga na, Jusé asewá nexaldixajañki sha axatshane jañguá. Akze, aldéñki sigí janshizhe, guiyabaja guagamak izhuka nalguakna, guiyabaja majakue guagamak majaldixa jañguatshak jiaga, jiwak akzukuasʉ́ñ akzeshi na ziñ me majaldixa akldék. ");
INSERT INTO kog_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ekí majaldixa jañguatogueñga na kabagatshake, Jateja guaklde uldeñkaga Jusék kabixaga akizhañkatshak ekí akbeyá: “Ma sáñkalda Dabítshi atukuak, munzhi Maldiya misewá nexaldixa ipanasʉ́ñ mikzegazháldi. Jinak ekí mikbeyakí. Somá axaldegatukaki Jatetshi Aldunajañga akzalshane nak. ");
INSERT INTO kog_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ai somá axaldegatukaki sigí sukue axaldexaldixa. Eñki kukatshak Jesú axezhagakue miñgatsaldaldixa. Jinak ekí axezhagakue naldakí. Ejañki ajíkue sha atshixakue kaxabeti, kekualdaldixa nak.” ");
INSERT INTO kog_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Akze, saldiñga ekí zexeki mauzeñga ezua Jatetshi múldigaba naldiñga zʉxaitshixaja sakí zexaldixa guakldane amak zexaldiamak ekí zegatuka. Eja ekí guakldane: ");
INSERT INTO kog_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ezua munzhi sigí izhguajagáldega ne jiaga somá axaldegapanaldinik sigí sukue axaldexaldixa. Ai somáki Emanuél axeyaldaxaldixa nakldá.” Guatshak Emanuél guagatshake “Saldiñga netshi Jateki nasʉñ nañga izhuká” guashi. ");
INSERT INTO kog_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ekí kabi akzegueni Jusé uba akldeñguake Jateja guaklde uldeñkaja aksanekldalguamak atshiji na, Maldiya asewá naldaldiamak ipaná. ");
INSERT INTO kog_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Guatshak somá kukagá nogueñgaki asewá na askuildék guazhá. Guñguenik somá sigí sukue kukañguake agabenalguamak Jesú axeté na gua. ");
INSERT INTO kog_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Guatshak sáñkalda Eldodeki Juldeya baxe aksanegatoguéñ, Jesúki eñguiñga kuíbuldu Beldéñka kuká. Amak kukañgueni na, zumeya shagitiji tuñkakue niuwi nañkajaldi mual zhinik Jeldusaldéñ ");
INSERT INTO kog_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ekí iyazaldukshiñga saldi aldák: —¿Mani shi ezua somá mimisaná juldiútshi sáñkalda akldé akzé nexaldiamak kukane nok? Jinak kuká guane zʉñkualdakí. Nauwijuxaga kizhoguéñ ezua zumeyaja au kuká guxá zʉnatuñshiñga na, izhañkaté tuñkalde nak. Akna eñki akldé akzamakga akzukuakualdiamak tual nakalde nakldá. ");
INSERT INTO kog_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sáñkalda Eldodeja ezua somá sáñkalda nexaldixa kukane nukatshakna, aldunaxa señgaba akzegaksáni, ijaniñgaba guatoguakna saldiñga Jeldusaldéñ zaldakueja jiaga “¡sakí zexaldixa ne!” iyajanaldá. ");
INSERT INTO kog_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Guñguake sáñkaldaja Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue juizhi saldiñga kajuizhakuatshak ekí kaklduká: —Saldiñga netshi Jateja káguba ikualdal ezua gaxaldixa guakldaneki ¿muldetuañki mashi shi kukaldixa na? ");
INSERT INTO kog_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Guñguake akiyayó: —Eñki Juldeya baxega, kuíbuldu Beldéñka kukaldixa nakldá. Jinake ekí zʉñkualdakí. Jatejañga guagatoguamak ají múldigaba naldiñga zʉxaitshixaja ekí kalta gauwanane: ");
INSERT INTO kog_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Ezuak maiñ Juldeya baxe, kuíbuldu Beldéñ zaldakue zhinikga sáñkalda akzé giemi izhgaldaxaldixa niyó. Aija na, nají kuíbuldu juldiú sanákue numañ nagatuwi, nagaksanexaldixa. Akna mimijí kuíbulduki nóñgutse, akzaldagálde atuñka ne naldatshak jiaga, akzega naldaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ekí sezheklde agabeñguake sáñkalda Eldodeja zumeya shagitiji tuñkakue ziñ me kexauldá. Amak axaldagatshak somá mitsá itsegatuka akualdaldiamak muldetuañki mitsaga ai zumeya izhañkaté atune kaklduká. ");
INSERT INTO kog_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Guñgueniki ekí naldagálde nuxa kakbeya: —Beldéñka mineyaldinik somá sáñkalda nexaldixa muldetua miniyatshake miñzá gualdiake mokue jai minakbeyaldí. Ekíki nas jiaga akldé akzamakga akzukui tual neyaldikuamak. ");
INSERT INTO kog_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ekí kakbeñguake amak aldeyapanatshak, zumeya izhañkaté atune mokue atú. Ekí atuatshakna zeñ kakldeshiñgaba, ai zumeya kaksaja nejiñga somá izhogué sáñkaldak agaldiyá. ");
INSERT INTO kog_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Guñguake eni juldi ajuldunatshake, somá ajaba Maldiya na atú. Amak somá atuatshakna akldé akzamakga agazukui, ishkajiezhi, nuldu axayó. Jika maldé akzé somák agaxauwaldixa awaldaklde akué axapeguenik niuba, ezuañki puldatshak we juma neñshixa, ezuañki we juma izhuka izhabeka agaxáu. ");
INSERT INTO kog_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Guñguenik Jatejañga kabikga mokue sáñkalda Eldode nugéñ ga neyasé keshkaldukshi katuñshá. Guñguake mokue kauwijí kagixa aldeñkáki awaxañ ga saldi aldé na akuá. ");
INSERT INTO kog_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ai zumeya shagitiji tuñkakue saldi aldeñguenik, ezua Jateja guaklde uldeñkaga Jusék kabixaga akizhañkaji ekí akbeyá: “Sáñkalda Eldodejañki somá guaxaldiamak niyaldixa nakna ekí matshaldí. Izhgate xaldeki somá ajaba na kauldakuishi san kagi Ejiptuxa mauldeyaldí. Eñka izhoshiñga na, jiak nas mitsák mokue jai nagakue mikbeyaldatshak zhinik mauldaxaldí.” ");
INSERT INTO kog_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ekí akbeñguake ai sesʉñga amak somá, ajaba na izhgapañguñgueniki Ejiptu neñká kauldé. ");
INSERT INTO kog_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Eñka aldeñgueni sáñkalda Eldode shuizha na ashekualdá. Ekí zexeki mauzeñga ezua Jatetshi múldigaba naldiñga zʉxaitshixaja sakí zexaldixa guakldanamak zeklde. Eja na Saldiñga netshi Jatejañga guagatoguamak ekí kalta gauwanane: “Nasga na Nasukuá giemi Ejiptuxa izhogatogué uldaklduge nzha.” ");
INSERT INTO kog_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Amak awaldeñguenik na sáñkalda Eldodeja zumeya shagitiji tuñkakue mokue nagakue akbenalguamak axajanashazháne tuatshakna, zʉ́xaita zalda nusá akzék. Atshaga na, zumeya tuñkakueja mitsaga somá sáñkalda nexaldixaki kukaxá katuñshi zumeya izhañkaté atune agabene be agisék. Guñguakna kuíbuldu Beldéñ, eñgui baxeki saldiñga somá sigí sukuekue atsʉshi zhinik mozhua kagi yo itsegatukakueki nuk guaxal guak. ");
INSERT INTO kog_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ekí zegatshake, mauzeñga Jatetshi múldigaba naldiñga zʉxaitshixa Jeldemiyaja sakí zexaldixa guakldanamak zek. Ekí sezheklde: ");
INSERT INTO kog_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kuíbuldu Aldamáxaki zʉ́xaita izhajani jaldáñ abauwaté alduká. Aiki munzhi Aldakéltshi atukuakue kauwijí sukuakue shalda abauwatuka. Sukua kakshuanekue nak amak kaxakuañnegatshak jiaga, kagakuañnegasʉ́ñ kakzeshi, abauwaksá guakí nzha.” ");
INSERT INTO kog_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Guatshak somá ajatekue nañga Ejiptuxa izhogatogueñga, sáñkalda Eldodeki shuigueni ezua Jateja guaklde uldeñka Jusék kabixaga akizhañkaji ekí akbeyá: ");
INSERT INTO kog_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Somá guaxaldixa akldegatoneki au shuizhá guakna, izhgaté xaldeki somá ajaba na mokue mijí kagi Isayélka kaulde makualdí.” ");
INSERT INTO kog_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ekí akbeñguakna somá, ajaba nañga izhgapañguñgueniki, amak Isayélka kauldé. ");
INSERT INTO kog_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Guane nalgué, sáñkalda Eldodetshi asukuá Alkeldáu niñkauwañki ajate tsaldi Isayélga Juldeya baxañ aksanegaté Juséja nukañguakna, exa neyaxañ zhe akzék. Guñgueni Jatejañga kabixaga exa neyagábaki, Galdildeya baxañ niñkauwañki somá agisaldazháldiamak neyakue ishkaldukshane nalguakna, amak eñka aldé. ");
INSERT INTO kog_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Exa aldeyatshake eñgui baxe, kuíbuldu Nasaldéxa izhoxaldá. Ekí zexeki mauzeñga Jatetshi múldigaba naldiñga zʉxaitshixakueja ekí guakldanamak zek: “Jatejañga káguba ikualdal ezua gaxanaldixaki ‘kuíbuldu Nasaldéxa zalda nakldá’ akuaxaldixa nzha.” ");
INSERT INTO kog_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Guñgueni anuñka kagi zegatshake Juañ nik majaukshakue ají jiba atshaldá. Amak atshapanatshakna, Juldeya baxañ zʉk zeñka, ");
INSERT INTO kog_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","aldukal axaldakldekue ekí kakbeyatoguamakga kakbeyá: “Maiñ sha miyatshixakue majiñga maja xaldeki Jatek agakualdi guwíñ. Jinake ekí miñmeyakí. Saldiñga netshi Jateki abisajañ sanegapanaldixa niuwañ naki zexaldá guapanák.” ");
INSERT INTO kog_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juañ shaldaga na, mauzeñga Jateja ají múldigaba naldiñga zʉxaitshixa Isaiyak ekí kalta gaushanane: “Ezua sigí zʉk zeñka izhoshi na, aldukal axaldakldekue ekí jaldáñ kaxaldexaldixa: ‘Saldiñga netshi Sáñkalda naki miñkaldashi guapanakna, jian naxaldiamak jiúñgulda siyaxagauwakuamakbe aldunaxa janazhiktú guwíñ. Eñki ezua sáñkalda naxaldiéñ jiúñgulda me me zeñ jian axaxazakuamakbé, ai nagatuka muldetua mipanaldiamak mimijí aldunaxa jana akizhiktuwíñ.’” ");
INSERT INTO kog_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Guatshak Juañki béyakze kameyutshi galdaga sezheklde zhakuá ijuakue. Janáñkaldak axabekueki kuizhuga. Aldéñ gakue akldé gaxaki sesʉ, kalkaldeldi zalda jatiá gaxa na naldá. ");
INSERT INTO kog_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Aldéñ guaká aldukal axaldaxekueki, kuíbuldu Jeldusaldéñ zaldakue, saldiñga eñgui Juldeya baxañ zaldakue, nina Juldáñ xezhak baxañ zahauxa zaldakue juizhi na axaldaxá. ");
INSERT INTO kog_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Guane aikuejañki amak axaldukshi na, “sha atshanuge ni atuñkú” nexekueki Juañja nina Juldáñga nik kajaukshi, kajaukshi na kakuá. ");
INSERT INTO kog_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Amak kajaukshatoguéñ anuñka paldiseyukue, saduseyukue jiaga axaldagaté katuatshakna ekí kaxaldék: “Takbi sha ishkazguamak, maiñ shane mijañguxa ne jiaga, janshizhe minekue ga abeldashi mizhuka. Ne ¿sakí zhinik shi naldagálde nuxa sha atshamine mashamine ga abamildagéñ me, Jateja kaxañ atemajañ guiyaba mimatuñshazháldixa miñnék? ");
INSERT INTO kog_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Akze, nik mimajaukshakue miñnegake ekí atshakue: Sha atshá namak giemi majiñga maja, Jatek agakualdimine awatualdiamak jian atshakue miñgatsé ni mitú. ");
INSERT INTO kog_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ne axaldáñgaba ekí ajañgushaminaka itshanagába: ‘Saldiñga netshi Jateja nauwibama Abaldahám ají naldaldixa izhgakuxanane nakna, ai shtukuaga kaldakna ajíkue zʉnepanaldixa nakldá.’ Minegatshak Jate bualga nuxaga ai za auxabé tuazhé. Jinake ekí miñmenaka naldakí. Aldéñki jejié jagikue jiaga ai shtukuakue ixagabakuaka nak. ");
INSERT INTO kog_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kaigaga mieldekueki sha ajanashá abajiñga abajazháldi, jian atshaldiamak Jatek axakualdinakí naldiake, aldéñ naldiñga guiyaba katuñshaldixa za abá guane. Aiki kaldi zhenazhéki abeñgua akualdiniki ayoxa akuamakbé, Jateja guiyaba atemajañ kaxañ katuñshaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Guñguenik ekí kakbeyá: “Naski sha miyatshixakue majiñga maja miñgueniki, mokue Jatek agakualdimine mimawatualdiamak nik nuxa mimajaukshikugé. Naldatshak nalduxañ ezua zʉnekualdaldiamak nagatukaki nazhakaldak akzé nak, naski ni atabal nuxaki nakzaldagálde. E zʉnake Jatetshi Aldunakga mimajaukshi na, ai Alduna maiñldi auxaga miñkaldaldaldiamak miñgexaldixa. Atshaga na guksék jiaga mimajaukshiji jana mimajaukshatshakna, gukséja jika janshi axazguamak aldunaldi janshi miñkazgualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aldéñki janshizhekueki sha atshixakuek zhinik kagajuekualdixa za abá guane. Aiki aldó ajubak zhinik axajuekuamakbe kakualdixa. Aldó gataki muldetua jikak akuasha abegamakbé, aldéñki janshizhekueki askuiñgaba kabexaldixa. Aldó ajubaki egaba ayoxa akuamakbé na, aldéñki sha atshixakueki guksé sanazhéñka, guiyaba tu za nogakueñka kakaxaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Juañja ekí kágubakue nik kajaukshatogueñga na, Duwe Jesú jiaga Juañja nik jaukshaldiamak Galdildeya baxe zhinik nina Juldáñka ne. ");
INSERT INTO kog_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Guatshakna Juañjañki sha akldekshaldiamak jañgui ekí akbeyá: —Akze, ma guana nik najaukshakue migatsaldashá. ¡Ne sakí shi nas niñkauwañki nik majaukshaldikuamak naxaldakbalde na! ");
INSERT INTO kog_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Guñguake Duweja akiyó: —Akldé janshibeñki kaiga niuwañ guana, nik najaukshakue migatsahamak maldaxatshaldixa. Ekíki nasʉñ mozhuañga atshakue zʉñgatsahamak Jateja zʉnajañguanauxa axatshakualdixa nakldá. Ekí akbeñguake Juañja: —Ake, amak atshaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Guñguake amak jaukshatshak, Duwe nik akzʉxaitatshaga, alnoba akpezhatshake exa zhinikga na, Jatetshi Aldunaga shamíjañ axagatanaté tu. ");
INSERT INTO kog_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Atshaga na exa zhinik ekí múldigaba guagaté alduká: “Jejiéki Nasukuá giemi matshuwi izhgajañguge, nakldunauxabé izhuka nakna, zeñ nakzukuxa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ekí Duwe Jesúki nik ajaukshiñguenik Jatetshi Aldunajañga na zʉk zeñka neyakue aksaneguamak ne. Jinake exa uldeyazhá. Jiséja ijuldukshaka jañgui aksaneshi guajaldiamak. ");
INSERT INTO kog_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Eñka izhoshiñga na, Duweki 40 ldiuwi niuwisʉñ, sesʉñ ni ji nauwa ga naldáaki izhoshi na, aldiweki maldija gualdá na gua. ");
INSERT INTO kog_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Guñguakna jiséja ijuldukshaka jañgui aksanexal axaldagatshak ekí axaldék: —Mañki Saldiñga netshi Jatetshi Asukuá giemi maldahamak nake, jejié jagikue “gakue nek guwá” axaldék guwá. ");
INSERT INTO kog_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Guakna Duweja akiyó: —Jatetshi múldigabak ekí sezheklde: “Kágubaki gakue za gaji auxabé izhogazháka. Akze, aldunaxa auxabé akzeshi izhoxaldiamake, Saldiñga netshi Jateja ají múldigabak guagauxa za akldé giemiki agajueshka naldashá.” ");
INSERT INTO kog_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ekí akiyokuñguake, jiséja Duwe Jeldusaldéñka Jateja ají kuíbuldu izhgakuxaneñka uldeñgueni, juwí Jate axazakuaka bakaldaxa akldé zeñka ibekshiñguenik ekí akbeyá: ");
INSERT INTO kog_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Ma namak giemi Saldiñga netshi Jatetshi Asukuá maldahamak nake, mañgabaga tuexa zhinik jiñ akjienwá. Jinak ekí mikbeyakí. Jatetshi múldigabake ekí sezheklde nogashá: “Jatejañga aldéñ guaklde uldeñkakue migisaldi guakuak muldetua numañ matuál migakaxaldixa. Aikuejañki migisaldi guakuak, jikak akzaldi zubushi guamikldegak, ni kasak jiaga jagi makuí guakuak aksuí makuxaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Guake Duweja mokue akiyó: —Naldatshak Najatetshi múldigabak ekí jiaga guashi sezheklde naldashá: “Saldiñga netshi Sáñkalda, Mimijatega ‘¿Aldéñ atshaldixa guaklde atshakldegamak shi na?’ jañgui guashabináldi.” ");
INSERT INTO kog_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ekí akiyokuñguake, jiséja jai kagik saldiñga kuíbuldu nahauxaja ji janshagatse axaldekue juizhi tuñshaldiamak, Duwe guinue akaldak atemaxa ibekshiñguenik ekí akbeyá: ");
INSERT INTO kog_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Saldiñga ji tu makuauxaki maksanexaldiamak migenaka. Amak migexaldikuamak nuldu naxayoshi, akldé nakzukuakue nuxa migatsé. ");
INSERT INTO kog_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Guake Duweja jisék akiyó: —Nagajuezha guaté maldokldék. Jinak ekí mixaldekldaka naldakí. Jatetshi múldigabak ekí sezheklde: “Saldiñga netshi Sáñkalda, Mimijate za na akldé akzamakga akzukui, e za axazauwi miñgualdí.” ");
INSERT INTO kog_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Guñguake jiséja agajuezhatshak Jateja guaklde uldeñkakue niñkauwañki Duwe axazauwal axaldák na gua. ");
INSERT INTO kog_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Guñgueni Juañ nik majaukshakue kalseldi abexá guane Duwe Jesúja nukañguakna, mokue Nasaldéxa Galdildeya baxe ne. ");
INSERT INTO kog_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Guñgueni exa abá guagábaki, exa zhinik Kapeldahúm izhoxal ne. Ai kuíbulduki niwa Galdildeya xezhak Neptaldí, Sabuldóñ ldaxekuetshi kagi baxañ na zaldá. ");
INSERT INTO kog_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ekí zegatogatshake, mauzeñga Jatetshi múldigaba naldiñga zʉxaitshixa Isaiyaja sakí zexaldixa guakldane zexaldiamak na ekí zegatoxá. Ekí sezheklde: ");
INSERT INTO kog_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nina Juldáñki niwa Galdildeyaxa zhinik zabapanéñ xezhak ga Sabuldóñ ldaxetshi kagi baxañ, Neptaldí ldaxetshi kagi baxañ, matshuwi juldiú saná naldagáldekue zhekue. ");
INSERT INTO kog_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Exa zhekuekueki sha atshiji na, Saldiñga netshi Jate izhuka aksʉ́ñzekue ne, E shalda namaklde aldukapanaldixa. Ekí tuañ itsekldekue izhogakna aldunaldiñki shuanekue jana ne. Guanaldixa Jate shalda kakwashegatshak, niuwi nañkatshak muñshí stuamakbé kestuwi jana, Aldéñ ‘me ne’ muldetua atualdixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Atshak zhinik na Duwe Jesúja ekí guagapaná: “Jate jékaldaxa izhukaki abisajañ miñsanexaldiéñ ldiuwañ naki zexaldá guapanakna, maiñ sha miyatshixakue majiñga maja xaldeki Jatek agakualdi guwíñ” na guagatoxá. ");
INSERT INTO kog_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Guñgueni Duwe Jesú niwa Galdildeya xezhak neyatogueñki, mozhua sigí zhuakaja nalguekue katú. Ezuañki Simóñ axezhuka Péguldu jiaga akuakaga, ezuañki Andaldé axezhuka. Ekueki pikáu gukakue aldalguakna, pikáu akuxaldiamak kauwijí zhemá nik akuateyaté katú. ");
INSERT INTO kog_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Guñguake Duweja ekí kakbeyá: “Maiñ shi minagitiyaldixa nak nagapa kuizaldi. Maiñki pikáu niji za mizhekue ne, kaiga zhiniki jiba abisa minaxatshaldixa miñgexaldikue. Aiki káguba nagapa aldeyaldixakue miniyapanaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ekí kakbeyatshaga na, zhemá abashiñgueniki ubañga Duwe Jesúk amak axapa aldeyaldá na akuá. ");
INSERT INTO kog_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ekí aldeñgueni, nauwa ne zeñka aldeyatogueñki jiak, Duweja mokue mozhua zhuakajagaba Zebedeyutshi asukuákue Santiaku, Juañ na katú. Kauwijate nañga kanuwaxa zhemá za siyagaxáu katuñguake ekí kakbeyá: “Maiñ shi minagitiyaldixa nak nagapa kuizaldi.” ");
INSERT INTO kog_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kauwizhéñ jiaga ekí kakbeyatshaga na, kanuwa, kauwijate jiaga abajañgueniki ubañga Duwe Jesúk amak axapa aldeyaldá na akuá. ");
INSERT INTO kog_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Guñguenik Duwe Jesúki Galdildeya baxe juwí izhajuizhaldeka nahauxa “Saldiñga netshi Jateja kágubakue janshagatsaldi kaksanexaldixa nakldá” shizhiji na mizhatoxá. Ekí shizhiji na, kágubakue sakígaba mulbatá kakzegauxa keskaitshiji, se akzegagáldekueki se kakzukuí na mizhatoxá. ");
INSERT INTO kog_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Duwe ekí atshixá atuwi na, saldiñga Sildia baxe nahauxa jiaga e shalda izhgabejiñgaba. Guakna saldiñga nalda mulbatá akzekakue, se akzegagáldekue, abuá akzék za nukakue, pisti akzekakue, abuá axazauwaksá guanekue, jisétshi alduna ijuldunekue juizhi Duwek akualdák. Amak akualdaxake aldéñ keskaitshi, se kakzukui, jisétshi aldunakue kezheñshi na guatoxá. ");
INSERT INTO kog_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Guakna Duwe maniñgaba neyatshak, kágubakue matshuwi zhikzhe axapa na aldeyatoxá. Aikueki Galdildeya baxe zaldakue, Juldeya baxe zaldakue, eñguiñga kuíbuldu Jeldusaldéñ zaldakue, “10 kuíbuldu” axezhogaldi Dekápuldi baxe zaldakue, nina Juldáñ ataba niñkauwa zaldakue juizhi na ekí axapa aldeyá. ");
INSERT INTO kog_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Duwe Jesúja kágubakue matshuwi zhikzhe axaldagaté katuñguake, muldetua shi kaxaldiyaldiamak gaxa akshá zeñka nitshiguenik yaté. Guñguake aldéñ shaxaldixakue jiaga aldesañ axaldaguake ");
INSERT INTO kog_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ekí kakbeji, shi kaxaldiyaldá: ");
INSERT INTO kog_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mieldeke aldunaxa axaldáñgaba auxaga izhogazháka itshani na, ‘Jatega sha nagajuésh’ itshankakueki zeñ aldaldaldixa. Jinake naldakí. Jatejañki zeñ kajañgui, kaksanexaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mieldeke kaigabeñki itshani mauwi guxakueki zeñ aldaldaldixa. Jinake naldakí. Jatejañki aldéñ naldiñga kagakuañnexaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mieldeke axaldáñgaba aguáñ zhikzukuxakueki zeñ aldaldaldixa. Jinake naldakí. Jateja bieni kageshi kagi agatsauxa, jika ek axaldekue juizhi kagexaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mieldeke gakue kagajuezhi, ni kagajueshka jana Jatek akldunamak izhoxa za alduna jañguxakueki zeñ aldaldaldixa. Jinake naldakí. Jatejañki aldunaxa muldetua auxabé kakzukualdixa nak. ");
INSERT INTO kog_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mieldeke axautshikue guañ jañguxakueki zeñ aldaldaldixa. Jinake naldakí. Jateja guañ kajañgualdixa nak. ");
INSERT INTO kog_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mieldeke kauwijí aldunaxa Saldiñga netshi Jate za izhgajañgui, e za akzé ajañgui ashekuekueki zeñ aldaldaldixa. Jinake naldakí. Aikueki Jate naldi atualdixa nak. ");
INSERT INTO kog_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mieldeke axautshikue señgaba zhe aldoxaldiamak gaunekakueki zeñ aldaldaldixa. Jinake naldakí. Aikueki Jateja naldi ‘nají sukua giemikue nakldá’ kakuaxaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mieldeke Jateja jian izhogakue kajañguamak izhokldana kakzeká shalda nuxa axautshikueja sha kakuxakueki zeñ aldaldaldixa. Jinake naldakí. Aikueki Jateja naldi zeñ kajañgui kaksanexaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","”Ekíga na, mieldeke nas namak najañgui, nepanamine shalda nuxa axautshikueja sha mimakuí, nalda miñkakuashi na, saldiñga nalda naldagálde mimakuagakueki nuk mimakuakake zeñ minaldaldixa. ");
INSERT INTO kog_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ekí mimakuaká shalda egaba zeñ zalda miñzekaga zʉ́xaita zeñ itshani miñgualdí. Jinake naldakí. Ekí mimakuxá shaldaki jékaldaxa Jateja guagasá janshizhe miñkatshaldixa nak. Akze, ekíga guana, mimizhaxañga Jatetshi múldigaba naldiñga zʉxaitshixakueki sha kakuiñgaba kakuanane nakldá. ");
INSERT INTO kog_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","”Guatshak maiñki jai kagik zhekuekue kenañ naku zauwamak jana mizauñkakue. Akze, naku nuk izʉzé guane, ¿sakí shi mokue akzanamak akzukuanazʉnaka na? Naku izʉzé guaneki ni jiñ zauwazháka nak iyatanaldixa uteya nuxa guakue naldashá. ");
INSERT INTO kog_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","”Guatshak muñshí zaldaki zahauxa mastuñshakuamakbeñga na, maiñ jai kagik zhekuekue muñshí miyakzukuxakue. Ezua kuíbuldu gaxa akshá zeñka zhekueki saldiñgaja atuamakbeñga na, sakí miyatshixá, sakí mizhekue ne atuakagaba naldaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Akze, ni meja ezua muñshí zukuxa zuñguá gualdinik jika ipa guazhé. Ne saldiñga eni zhekuekue muldetua muñshí kakzukualdiamak mataxa iyaldaka. ");
INSERT INTO kog_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ekibeñga na, nagapa mineñkakue ga mimatualdiamak agatsaldi mizhekualdaldí. Ekíki kágubakueja jian ne, janshizhegaba atshiji izhogaté mimatuatshakna, Nauwijate jékaldaxa izhuka akldé akzamakga miyakzukushaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","”Nasga jai kagik Jateja jian izhoxa guiyaba nauwibama Muesék zʉñkabajane, ni Jatetshi múldigaba naldiñga zʉxaitshixakueja guashi sezheklde jiaga akzaldaksánshal nagazhánuge. Ne sakí guashi sezhekldanamak muldetua miñgajieñgualdikuamak, amak zekualdikuamak naklduge nakldá. ");
INSERT INTO kog_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Akze, namak miñmeyaldikue. Alnoba, kagi naldalga noxaldieñgaki, guiyaba jian izhoxa zʉñsanexa niuwi axaldaldaksáki guazháldixa. Ai Jatetshi guiyabaki aldéñ mashi akldañkaldixa jañguaneñka yo zegagáñgaki, ni meja jiaga ezua agatsalda nóñgutse nuxaki yushá guazhíta nzha. ");
INSERT INTO kog_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Akna mieldejañki ezua agatsaldaki aguáñ akzé jañgui, aija guagamak atshakí, azhi axautshikue jiaga ekíga amak axatshazháldiamak shizhiyaldiák zʉnake, Jateja saldiñga aldéñ aksanekákue guashiñki aguáñ akzé tuñka nakldá. Ekí ne, mieldejañki Jatetshi guiyabaja guagamak axatshiji na, axautshikue jiaga ekíga amak axatshaldiamak shizhiyaldiák, aiki Jateja aldéñ kaksanekákue guashiñki akzé tuñka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","”Akze, ekí miñmeyaldikue. Paldiseyukue, guiyaba shizhixakue juizhi Jateja jian izhogakue kajañguamak izhuká mituatshak jiaga, aikue zhakldé jian izhogakí minaldaldiák Jateja aldéñ sanegeñka jékaldaxa ni mitsák mimajuldukshazhíta nakldá. ");
INSERT INTO kog_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","”Akze, Jateja mauzeñga nauwibamakuek guiyaba ekí guaka zʉñkagenane minukaxa: ‘Axautshi guaxa atshasʉ́ñze.’ Ekíga na, ‘mieldejañki axautshi guaxá gualdiake agatsaldi atualdinik guiyaba tuakue agatsaldaldixa.’ ");
INSERT INTO kog_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ekí minukaxa ne nas zʉnake ekí miñmeyaldikue: Axautshi nusá aguanasʉ́ñze nak, mieldejañki ezua nusá aguanaldiák agatsaldi ne atualdixa. Ekíga na, mieldejañki ezua nusa agatsaldi sha axaldexaldiák, akldé akzekue sanekakuegaba ajuizhaldegéñ agatsaldi ne atuwi axeyaldaxaldixa. Ne mieldejañki ezua ‘se miktú ni gukú’ axaldexaldiák zʉnake guksé sanazhéñkaga neyaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","”Ekí nakna, mitsakgaba Jate axazakuageñka aldéñ akldé akzamakga miyakzukualdiamak mineyatshak, ezua sha axatshamaldega naldaldiake ‘sakí naguani izhuká’ be migisexaldiake, ");
INSERT INTO kog_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Jate amak akldé akzamakga akzukuagáñga mokue kualdinakue. Naldiniki axáñ misha ai na sezhgauwi mokue izhgakuañnegakue gualdinik zʉnake, kaiga guana Jate akldé akzamakga akzukual neyakue miñgatsaldaldixa. ");
INSERT INTO kog_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","”Mitsakgaba ezua sha axatshamaldeja mezhguaklde migatsaldi ne matuakue nugeñka mauldeyatoxaldiéñ sezhgauwakue. Azhi sezhgauwakíñga mauldeyaldiák guashiñki, aldéñga migatsaldi ne matuakuek makizhañkashaka. Gualdiake aijañki ají kabukuek kalseldi mabexal kakbeyaka. ");
INSERT INTO kog_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Akna namak ekí mikbeyaldikue. Ai sha axatshamalde na sezhgauwakí maldaldiák, sha atshamalde shalda mitsá ilzabiyakue majañguanauxa ilzabiyakíñgaki kalseldi zhinik makzʉxaitshazháldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","”Guatshak Jateja mauzeñga nauwibamakuek guiyaba ekí guaka zʉñkagenane minukaxa: ‘Misewá naldagálde na askuildegasʉ́ñze.’ ");
INSERT INTO kog_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ekí minukaxa ne, nas zʉnake ekí miñmeyaldikue: Sigíkuañ mimisewá naldagálde tuwi me miñguatshak alduna agauwi ‘e na sakí askuildekldaka’ aldunaxa miñnegatshake, e na askuildék zhuxañga miyatshaldixa. ");
INSERT INTO kog_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Akna, jiki sha atshindana miñzukuxa, mimakjieñguakaga mitualdiake, uteji izhgajuekuakue miñgatsé. Akna mimijí uba jibatshaldiñki ji tuatshak sha atshindana miñzukuxa naldaldiake axaldáñga ishkuiya, uteya miñguxá jana atshakue. Akze, sha atshabináldiamak abuák ezua agatsaldaki axaldáñga izhgitshuaksha miñguxá jana miyatshatshakna, akldé janshibé naldaldixa. Ne sha atshalga minoxaldiake, miñgatsauxaga Jateja guiyaba tu za nogakueñka mimaguteyaka ni mitú. ");
INSERT INTO kog_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ekíga na, mimijí káuxalda jibatshaldiñki sha atshindana miñzukuxa naldaldiake axaldáñga izhbeñgua, uteya miñguxá jana atshakue. Akze, sha atshabináldiamak abuák ezua agatsaldaki axaldáñga izhgitshuaksha miñguxá jana miyatshatshakna, akldé janshibé naldaldixa. Ne sha atshalga minoxaldiake miñgatsauxaga Jateja guiyaba tu za nogakueñka mimaguteyaka ni mitú. ");
INSERT INTO kog_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","”Akze, mauzeñga zalda guiyabaja ekí jiaga guaká minukaxa: ‘Mielde sigíjañki asewá majaldá gualdiake, “mabajá ni gukú” guaká xalte agegakue agatsaldaldixa nzha.’ ");
INSERT INTO kog_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ekí minukaxa ne, nas zʉnake ekí miñmeyaldikue: Sigíja asewá axautshi na askuildék guatshak za na, majaka naldaldixa. Ne jigabá shalda nuxa maja guanaldixa, munzhija mokue axautshi sigí guxa gualdiake, Jateja tuwiñki majanejañga asewá naldagálde tusheksha zhuxañga atshishaldixa. Ekíga na, munzhi asewája majane mielde sigíjañki guxa gualdiák, Jateja tuwiñki asewá naldagálde tushek guxaga tualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","”Akze, Jateja mauzeñga nauwibamakuek guiyaba ekí guaka zʉñkagenane minukaxa: ‘“Saldiñga netshi Jate natuaté nogéñ ni ekí atshaldikue axeldakú” axelte miñgualdinik amak atshakue, ne amak atshazhá guasʉ́ñze giemi nzha.’ ");
INSERT INTO kog_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ekí minukaxa ne, nas zʉnake ekí miñmeyaldikue: Ezuañgaba namak za zukuashi na, ni jigaba ité xaldek ‘atshaldikuamak ni axeldakú’ negasʉ́ñze miñgatsaldaldixa. Ekí nakna, Saldiñga netshi Jateki jékaldaxa zhinik saldiñga aksaneka nak, ‘jékaldaxaki nahamakga na nas namak atshaldikuamak ni axeldakú’ negasʉ́ñze. ");
INSERT INTO kog_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ekíga na, Jateki jai kagi agatsauxa aksaneka nak, ‘kagiki na nahéñ zhinik nas namak atshaldikuamak ni axeldakú’ negasʉ́ñze. Ekíga na, Jateki Jeldusaldéñtshi Sáñkalda akaldak akzé izhuka nak, ‘Jeldusaldéñki na nahéñ zhinik, nas namak atshaldikuamak ni axeldakú’ negasʉ́ñze giemi nzha. ");
INSERT INTO kog_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ekíga na, maiñ be mizhogéñ zhinik nuxa ‘namak atshaldikuamak ni axeldakú’ negasʉ́ñze. Jinak naldakí. Maiñ axaldáñga ni nauwa nuxaki awawa ldexa, ni dueba ldexa miñsuikualdagálde nak. ");
INSERT INTO kog_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Akna maiñ zʉnake ekí axeldagagábaki, egaba miyatshaldixa nake ‘atshaldikue nzha’ azhi atshabináldixa nake ‘atshazháldikue nzha’ za guagakue naldaldixa. Akze, akldé ipa minexaldiake, aiki jisék zhinik nakldega naldaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","”Akze, mauzeñga zalda guiyabaja ekí jiaga guaká minukaxa: ‘Mieldejañki axautshi sakígaba sha gualdiake, amak agatsaldiñga akiyushakue. Akna ezuaja axautshi ubak azhi jualdak sha gualdiake, sha guanamak jiak, ubak azhi jualdakga akiyushakue.’ ");
INSERT INTO kog_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ekí minukaxa ne, nas zʉnake ekí miñmeyaldikue: Mieldeki sha mimakualdiák, maiñ zhinik akiyushabináldi. Akna, waxa miñkabuxaldiák, ataba jiaga miñkabugexañ tuñshi miñgualdí. ");
INSERT INTO kog_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ekíga na, ezuajañki zhakuá minguxaldiamak mimezhguák gualdiake, maiñ zhiniki ‘nazikugasé nzha’ negagábaki ‘egaba akldé shuldejí’ mijañgualdí. ");
INSERT INTO kog_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ekibeñga sáñkaldaja jika maldé akuldeyakue miñkaldexaldiake, mitsá akuldeyakue miñkaldeklde guashiñki mutshua naldashi zeñka akuldeyakue. ");
INSERT INTO kog_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ekíga na, mieldejañki jika miñshishaldiake egaba amak akauwakue. Azhi, mieldejañki jigaba ‘nakwasha guwá’ miñmeyaldiák, ‘mikwashazhánaka nzha’ nexabináldi. ");
INSERT INTO kog_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","”Akze, mauzeñga guiyabaja ekí jiaga guaká minukaxa: ‘Zeñ miñguankakue, misanákueki kezhgajañguakue. Ne miyaguldiñkakue zʉnake kezhgajañguagábaki miñguldiyakue.’ ");
INSERT INTO kog_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ekí minukaxa ne, nas zʉnake ekí miñmeyaldikue: Miyaguldiñkakue jiaga kezhgajañguakue, janshizhe kaxatshakue. Mieldeke ‘agisa guakuéñ’ minjankakue jiaga maiñ zhiniki zeñ kajañgui miñgualdí. Ekíga na, sha mimakuxakue maiñ zhiniki Jateja kagaunexaldiamak akshishi miñgualdí. ");
INSERT INTO kog_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ekí miñmeñkugamak miyatshaldiakna, Nauwijate jékaldaxa izhukatshi sukuakue giemi miné mimawatualdixa. Akze, Nauwijatejañki jian izhukakue, jian izhogagáldekue juizhi janshizhe kaxatshiji na, zhualduxañga niuwi kaldañgashiji, níxalda ketsekuxa. ");
INSERT INTO kog_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ne maiñ mimezhgajañguxakue za mizhgajañgualdiák, sáñkaldak akiyalzabine zhiksuikakue ajañguamakga nuxa miyajañgualdixa. Akna ¿sakí shi ekí atshamine shalda nuxa Jateja janshizhe miñkatshaldixa na? ");
INSERT INTO kog_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ekíga na, maiñki mimikaja, zeñ miñguankakue mituatshak aikue za muldetua miyaxazguaxaldiake, Jate jañguazhékue ishkajanashamakga nuxa mishkatshaldixa. Akna ¿sakí shi ekí atshamine shalda nuxa Jateja akzé atshamine mimatualdixa na? ");
INSERT INTO kog_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ne maiñ zʉnake, Nauwijate jékaldaxa izhuka janshizhe, aldéñgaba muldetua auxaga naldakuauxabé izhuka nahamakbé naldi mizhekualdaldí. ");
INSERT INTO kog_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","”Maiñ jigabá janshizhe miyatshatshak, kágubakue mimatuatogéñ za na ‘e zʉnake sakí ekí janshizhe atshixá’ miñkajanaldiamak nuxa miyatshaldixa itshanabináldi. Ekí miyatshaldiák, Nauwijate jékaldaxa izhukaja niñkauwañki ai shaldaga janshizhe miñkatshazháldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","”Ekí nakna, nashi jika kagajueshkakue, ji miyakauwaldixa saldiñga mimatuakldegéñ kakauwabináldi. Akze, ezuakueki nashi guañ jañguxa ga abeldashi na miyagaba káguba matshuwi ashekuéñ azhi juwí izhajuizhaldegéñ, saldiñgaja katuatogéñ za na, akldé kagazukualdiamak nuxa nashikue agaxauneka. Akna namak miñmeyaldikue: Aikueki kágubaja ai shalda akldé kakzukuá guakna, auxabé iyapaná guane nakna, Jateja niñkauwañki janshizhe kaxatshazháldixa. ");
INSERT INTO kog_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Akna mitsák jika kagajueshkakue kagaunexaldá miñguatshak, ni mek jiaga akwashekuagába gaunegakue. ");
INSERT INTO kog_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Akze, nashi jika agajueshkakue ni me mimatú naldakí miyagaunexaldí. Ekí miyagaunegatshakna, ni me mimatuakí jiaga Mimijate mimatuñkajañki janshibé atshamine shalda janshizhe miñkatshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","”Ekíga na, mitságaba Nauwijate miyaxazguagatshak, ezuakuejañki Jate axazakuagatuka ga abeldashi axazakuagamak axazguaxabináldi. Aikueki axautshija katualdiamak káguba zhenéñ, azhi juwí izhajuizhaldegéñ akté noshi, Jate axazakuaka. Akna namak miñmeyaldikue: Aikueki kágubaja nuxa ai shalda akldé kakzukuá guakna, auxabé iyapaná guane nakna, Jateja niñkauwañki janshizhe kaxatshazháldixa. ");
INSERT INTO kog_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Akna maiñki ni me mimatuazhákldegaldi mimihezuañgaba ne xaldek miyaxazguaxaldí. Ekí miyaxazguagatshakna, ni me mimatuakí jiaga Mimijate mimatuñkajañki janshizhe miñkatshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","”Akze, Nauwijate miyaxazguagatshak, Jate jañguazhékueja jigabá Jate tsaldi ishkagazukuane axazakuagamak agatsaldi axazguaxabináldi. Aikuejañki ishkagazukuaneja kaldukaldiamak, ‘jiga ni guakú’ kakldegagálde múldigaba mokue aiga, aiga guashi axazakuaka. ");
INSERT INTO kog_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ne Saldiñga netshi Jate Mimijatega nak ni ji akshishagá minogeñga jiaga, ji miñgajuezhatuka auxaga akuakna, aikueja ji ishkagazukuanek axashishamak agatsaldi Mimijate axazguagakue miñgatsaldazháldi. ");
INSERT INTO kog_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ne maiñ zʉnake Nauwijate axazguaxaldá miñguatshak, jekí agatsaldi miyaxazguaxaldí: ‘Nauwijate jékaldaxa mizhuka, ma za akaldak, akaldak mikzé maldahamakga, saldiñga káguba zhekuauxaja ekí zañga shi migazukuí. ");
INSERT INTO kog_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Maldé zegagáñga, saldiñga káguba sanákue nahauxa ma za kaksanegakue shi mixajaní. Jékaldaxa zaldakue ma muldetua majañguauxabe mixajanashamakga, jai kagik zaldakue jiaga ekíga shi mixajanashijí. ");
INSERT INTO kog_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Niuwi neyauxa ji gakualdixa zʉñgeshi makualdí. ");
INSERT INTO kog_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nasʉñ sha zʉnakuanekue axabetañkaldamakga, sakígaba sha atsháñkalde zʉñkabetá makualdí. ");
INSERT INTO kog_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nasʉñ sakígaba sha atshindana zʉñzukuxa azhi ijuldunakualdiamak zʉñsanekák amak axatshiji ijulduni guanazʉñnegak zʉñgauneshi makualdí. Ekíga sha atshátshi sáñkalda jisé amak zʉnatshishi, zʉñgubiji guakuak yo maldazʉnakualdí. Jinak ekí mikshishakí. Ma zañga guana, kama na nahauxa miksuikualdi, saldiñga, saldiñga ma za masaneka, ma za akaldak mikzá naldakuauxa mikzé zañga maldaldataná nzha. Ekíga shi naldí.’” ");
INSERT INTO kog_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Guñgueni ekí jiaga shi kaxaldiyá: “Maiñ káguba sha mimakuanekue axabeta miñgualdiakna, Nauwijate jékaldaxa izhukaja jiaga maiñ sha miyaxatshatshak miñkabetaldixa. ");
INSERT INTO kog_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ekí ne, maiñki sha mimakuanekue axabetakí minaldaldiák zʉnake Mimijateja sha miyaxatshatshak ekíga miñkabetazháldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","”Mitsake muldetua Nauwijate miyaxazguaxaldiamake záaki mizhogatshak, ezuakueki Jate axasáaki axazakuagatuka ga abezhaldagamak atshabináldi. Aikueki asáaki ashekuéñ na izhajani akuatukakue jana abezhaldaka. Ekíki tuatukakueja asáaki ashekue katuwi, akldé kagazukualdiamak na ekí ajanashixa. Akna namak miñmeyaldikue: Aikueki kágubaja ai shalda akldé kakzukuá guakna, auxabé iyapaná guane nakna, Jateja niñkauwañki janshizhe kaxatshazháldixa. ");
INSERT INTO kog_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Akna maiñ zʉnake záaki mizhogéñ jiaga, niuwi neyauxa semizhgauwamakga muldetua sezhgauwakue miñgatsé. ");
INSERT INTO kog_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ekíki ni meja záaki zhekualdabinuka mimatuazháldiamak. Akze, ni meja ekí atshabinuka mimatuakí jiaga, ezuañgaba Mimijate mimatuatukaja ai shaldaki janshizhe miñkatshaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","”Jai kagik zalda jika akldé akzé kágubaja tuñkakue mishkibexaldixa za itshanabináldi. Akze, jikakueki nusaldeshi saldinaldixa, zumbúja galdixa, azhi tushekakueja mintushexal miñgakjuldunaka. ");
INSERT INTO kog_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Numa za ekí ishkibegagábaki, Jate jékaldaxa izhukaja ji akldé akzé jañguxa za miyatshaldí. Ekí miyatshaldiakna, jékaldaxa numa akzekue ishkibeshi miñguxa jana, Jateja saldi guazhíta janshizhe miñkatshaldixa. Aiki tushekaja mintushegazhíta, zumbúja miñgazhíta, ni sualdaja jiaga nusakuazhíta. ");
INSERT INTO kog_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Akze, ji akldé akzé mijañguxa naldiake, eñ za alduna kaumine mizhekualdaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","”Ezua muñshí zukuxaja jika matuñshamakga mimijí ubaja saldiñga mimatuñshaka. Akna ubak se miné minaldaldiake, saldiñga miñgatsauxa muñshí minzeklde minaldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ne ubak se naldabíne minaldaldiake miñgatsauxa muldetua tuañ minzeklde minaldaldixa nakldá. Azhi ji muñshí zalda miñkaldé mijañguxa, aiki tuañ zalda nuxa naldaldiák, ¡mitsá tuañ zalda miñkaldaldaldixa ne! ");
INSERT INTO kog_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","”Akze, ni meja mozhua sáñkaldakuek axazauwazháka naldashá. Jinake naldakí. Amak mozhua sáñkaldakue akizhuka nanake, ezuañki izhgajañgui axabetaldixa ne jiak, ezuañki aguldiji, aguáñ izhbashaldixa. Ekibeñga na, ‘Jate za sha akaldak akzé na’ jañgui axazauwal minogatshaga, paldata jiaga akldé akzé jañgui ai za niyal nogazháminaka naldashá. ");
INSERT INTO kog_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","”Akna ekí miñmeyaldikue: Izhogexañ ji miñgaldixa, ji mituxaldixa, ji mitshualdiyaldixa za ijanabináldi. Akze, ¿izhoxa guana gakue zhakldé akzeki tuakí shi miná? Ekíga ¿abuá guana zhakuá zhakldé akzeki tuakí shi miná? ");
INSERT INTO kog_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nubákue tu kuizguí. Gakue ishkiyaldigakí, ni ishkakugakí, ni mani ishkiyabegakí aldaldatshak jiaga, Nauwijate jékaldaxa zaldajañki auxaga kakauwatuka. Ne maiñ míñgaki nubákue zhakaldak Jateja miñzé mimatuwi zhinik muldetua numañ mimatualdixa. ");
INSERT INTO kog_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Azhi maiñ miñnekáki, nauwañgaba akldé mizhoxaldiamak za ijaná minogatshake akldé amak izhó miñzék guaka shi mijañgú? ");
INSERT INTO kog_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","”Akze, ¿jinak shi ji mitshualdiyaldixa za ijaná minók? Kaljumshi sakí kalkaldeldi jumaldeka kuistuwí. Aikueki jiba ishkajanasháaki, ni zhakuá izhgauwáaki jiaga, zʉ́xaita janshagatsekue jumaldeka. ");
INSERT INTO kog_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Naldatshak ekí miñmeyaldikue. Nauwibama Saldamóñ kabia zhakuá janshagatse ijuakue nane, ne kaljumshikueki e zhakaldakga janshagatsekue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Akze, kaljumshikue mitsá zegagá nuk kanatshak ayoxaldixa jiaga, Nauwijatejañga ekí janshi axazguxa. Ne ¿maiñ míñgaki kaljumshikue zhakaldak mitshualdiyaldixa miñgegazháldixa ne shi mijañgú? Ne ¿jinak shi ‘Jate numañ natualdixa shakldá’ alduna ishakí miná? ");
INSERT INTO kog_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","”Ekí numañ mimatuaka nakna, maiñ ‘¿Eñki ji galdikue ne? ¿Ji tuxaldikue ne? ¿Ji itshualdiyaldikue ne?’ ijanabináldi. ");
INSERT INTO kog_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Akze, Jate jañguazhékueja ekíga ji kagajueshka za niji ashekue. Naldatshak Mimijate jékaldaxa izhukajañki ji miñgajuezhatogauxa akuegaba nak ekí ijanakue miñgatsaldakí. ");
INSERT INTO kog_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ne ji akldé niyakue miñgatsaldakí. Saldiñga netshi Jateja auxaga miñsanexaldixa, ek akldunamak, jian mizhekualdaldixa za niji mizhekualdaldí. Ekí aldéñ za miñsanexaldixa niji mizhekualdaldiakna, ji miñgajuezhauxa miñgexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Akna niuwizhíñki sai zexaldixa, ji miñgajuezhaldixa shalda ijanabináldi. Jinake naldakí. Jiak amak zegatshake ijanakue ldiuwañga zexaldixa nak. Akze, niuwi neyauxa ijanakueki auxaga nakna, niuwizhíñtshi ijanakue naldakí nzha. ");
INSERT INTO kog_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","”Maiñ axautshikue agatsé axezhaxabináldi. Ekíki Saldiñga netshi Jateja zhinik ekíga miñgatsé ne mimatuwi axanibindakldék. ");
INSERT INTO kog_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Akze, maiñ axautshi sakí agatsaldi ne tuwi axamizhaxaldiake jiak, Jateja zhinik ekíga miñgatsé mimatuwi axamindaxaldixa. Akna maiñ axautshi sakí miñneshi mitualdiák, ake, ekíga maiñ jiaga mimawatualdixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ai shaldaga ekí kakbeyá: “¿Sakí zhinik shi axautshi ubak zubagi nóñgutse nuxa ijulduneki señ me tuminaka, jiak naldatshak maiñ axaldáñ niñkauwañki kaldi wézhilduka ubak minjuldune tuazháminaka na? ");
INSERT INTO kog_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ekibeñga na, sha atshamine axaldáñ izhgatuakí minuka jiaga, ¿sakí zhinik shi ezua aguáñ sha atshane ‘gaja, sha matshixa mabashaldiamak nas miksanekldaka nakldá’ axaldekbildaka na? ");
INSERT INTO kog_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Maiñki Jatek amak miyaxatshixa ga abeldashi mizhekueke axáñ misha axaldáñ matshuwi sha miyatshixa masha xaldek na ezua mimizhaguáñ sha atshixa sha atshá mashaldiamak aksanekbinaka naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","”Akze, Saldiñga netshi Jate za na akaldak akzé izhuka ne, ekí jañguazhékuek e shalda miyakbeyatshak miñgipanazháldi miñkildusakualdixa. Aiki jika akzé piyuk miyagegatshak sha guamakbeñga sha miñkakualdinik maiñ jiaga sha mimakuaka. Azhi ji akzé mituk miyaguteyaldiák, nusakuí itanamakbe janshagatse miyakbeyatshak iyapanazháldi, miñkiyatanaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ekí kakbejiñga ekí jiaga kakbeyá: “Ji miñgajueshká Jatek akshishal za mizhekualdatshak amak miñgexaldixa. Ekibeñga na, ji miñgajuezha gualdiake Jatek za niyal mizhekualdatshak amak miñzaldaldixa. Ekíga na, abá naldakí Jate agakuañnexalga za mizhekualdatshak mimaldukshi, amak miñkatshaldixa. ");
INSERT INTO kog_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jinake naldakí. Mieldejañki ji agajueshká Jatek akshishatshak amak agexaldixa. Mieldejañki ji agajueshká Jatek za niyatshak amak akzaldaldixa. Mieldejañki Jate agakuañnegatshak axaldukshi, amak axatshaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","”¿Mielde jatek shi mimijí sukuaja gakue miñshishatshak, jagi nuxa akáu miñguxa na? ");
INSERT INTO kog_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Azhi pikáu miñshishatshak, ¿takbi nuxa akáu miñguxa shi na? ");
INSERT INTO kog_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Maiñ sha miyatshixa naldi jiaga, mimijí sukuakue jika janshagatse za agexa miñkué. ¡Akna mitsá Nauwijate jékaldaxa izhuka míñgaki jika miyakshishatshak mimizhakldé janshizhe za miñkatshiji, miñgeka naldakí shi na! ");
INSERT INTO kog_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","”Saldiñga netshi Jateja nauwibama Muesék guiyaba zʉñkabajane na, ají múldigaba naldiñga zʉxaitshixakueja guashi sezheklde na ezuañgaba me ekí neklde: Maiñ axaldáñ mitsabé mimakundana miñzeka nake, ake, axautshi jiaga ekíga miñgualdí. ");
INSERT INTO kog_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","”Akze, Jate sanegeñka julduneñki niñpokuéñ nak ai ga juldunakue itshani miñgualdí. Jinake naldakí. Guiyaba tu za nogakueñka jiúñgulda mauldeyakueki wépakue jibañ akzaldazhé nak, eñkáñ matshuwi aldeji na, julduneñki wepokuéñ matshuwi ajuldunka nak. ");
INSERT INTO kog_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ne Jate nugeñka aldéñ na izhoshiñga mimezhokshaldieñka jiúñgulda mauldeyakueki jibañ ne, shibí me neñka nakna, anuñkaja nuxa akzaldi, eñkáñ aldeji na, julduneñki niñpokuéñ ajuldunka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","”Maiñ muldetua be noshi, numañ miyatualdí. Jinake ekí miñmeyakí. Anuñkakueki ‘naski Jatetshi múldigaba naldiñga zʉxaitshikuge na nakú’ naldagálde aldekakue jian miñgazukui, mimeyajuldukshi guakuak. Aikueki abak nuxa janshizhe ga aba izhukakue miñkaldagatshak, aldunaldiñki shanekue, sha mimakuakakue aldé nak. ");
INSERT INTO kog_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ekí aba izhukakue sakí azakuagéñ, ajanashéñ, izhogéñ me, sakí aldé katuminaka. Ekibeñga na, kaldi zhenéñ me, ji xalde ne zʉnatuñshixa. Azhi ¿zaldalduk kalwé gakue kuiyakue shi na? ");
INSERT INTO kog_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Akze, kaldi janshagatsejañki kalwé janshagatse za zheñguxa. Ne kaldi janshagatsaldagáldejañki kalwé nusagatsegaba nuxa zheñguxa. ");
INSERT INTO kog_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ekíga na, kaldi janshagatsejañki kalwé nusagatse zheñguazháka. Ekibeñga na jiak, janshagatsaldagáldejañki kalwé janshagatse zheñguazháka naldashá. ");
INSERT INTO kog_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Akze, kaldi kalwé janshagatsegaba zheñguazhéki abeñgualdiniki izhaxauwa guksék ayoxa akuxa. Ekibeñga na, mielde sha atshixakueki Jateja guiyaba katuñshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Akze, aikueki sakí ajanashéñ, azakuagéñ, shizhaldiyéñ me shanekue ne miñnexaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","”Akze, matshuwi nekue ‘nají Sáñkalda maldaksaneká’ naxaldegatshak jiaga, Najate jékaldaxa izhukaja aldéñ sanegeñka kajuldukshazháldixa. Ne mieldeki aldéñ jañguamak axatshixakue za na, ají giemikue kepani, jékaldaxa, aldéñ sanegeñka kajuldukshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Auxa zegatshak, matshuwi nekue ekí naxaldexaldixa: ‘Nauwijí Sáñkalda, nasʉñ jiaga ma niuwi zʉñgemaldekga na, mijí múldigaba naldiñga kágubakuek kagaskaitshatoñkalde. Ai niuwikga na, jisétshi aldunakue kágubakuek zhinik kezheñshatoñkalde. Ai niuwikga na, matshuwi janshagatse atú guazhámak jiaga atshatoñkalde naldashá.’ ");
INSERT INTO kog_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ekí naxaldegatshak jiaga, nas zhiniki ekí kakiyokualdikue: ‘Naski ni mitsák nají miné mimatuazhánuge naldashá. Maiñki sha miyatshixakue minák, nagajué zhekualdatogwíñ.’ ");
INSERT INTO kog_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","”Ekí nakna mieldekueki guakuge naxaldukshi, amak naxatshixakueki ekí jana izhukakue. Ezua sigí muldetua jañguxaja juwí gauwapanatshak, juxasakue muldetua kakuamak agajieñguxa. ");
INSERT INTO kog_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ekí kakuamak kama gukshanaldixa na, níxalda ateema zeshi, ni taniñgaba, múlkalda nejiñgaba juwík axabugatshak jiaga, wi wi atshishazháldixa. ");
INSERT INTO kog_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ne mieldekueja guakuge naldukatshak jiaga, amak naxatshazhékueki ekí jana izhukakue: Ezua sigí jañguagáldeja juwí gauwapanatshak juxasa kagi zhau zeñ nuxa agajieñguxa. ");
INSERT INTO kog_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Guanaldixa níxalda ateema zeshi, ni taniñgaba, múlkalda nejiñgaba juwík axabugatshake wi wi atshishi, nuk tiñgualdixa naldashá.” ");
INSERT INTO kog_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ekí shi kaxaldiji aksaldinatshakna saldiñgajañki “¡sakí ekí agatsaldi shi zʉñkaldixá!” kakldék. ");
INSERT INTO kog_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jinake naldakí. Duwe Jesújañki guiyaba shizhixakueja shizhiyamak shi kaxaldiyagábaki, muldetua niuwi axaldé ga agatsaldi shi kaxaldiyák. ");
INSERT INTO kog_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Duwe Jesúja ekí shi kaxaldiyatoguenik gaxa akshá zeñka zhinik zabatogatshake, káguba duwá zhikzhe agapa asabí. ");
INSERT INTO kog_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aiga na ezua sigí ajuba ikaldunatuka Duwek axaldagueni nuldu axayoshi ekí agakuañnék: —Nají Sáñkalda, ma janshi naxazgundana mikzék guashiñki, amak naxatsha guamildaká. ");
INSERT INTO kog_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Guake Duweja káuxalda ipañgui ekí akbeyá: —Janshi mixazgundana nzhakzék. Akna, kaigaga janshi migatsék shi gui. Axaldegatshaga na amak janshagatsék. ");
INSERT INTO kog_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Guakna Duweja: —Kaiga janshi mixazguge ni mek akbeyagábaki, egaba janshi migatsék guane matuexañ jian Jatek múldigaba agaskaitshixa nugeñka maldeyaldí. Exaki nauwibama Mueséja mielde ajuba ikaldunatuka janshi agatsekldejañki, ji Jatek agegakue guagamak ageshi makualdí. Ekíki janshi migatsék guane mawatualdiamak —na akbeyá. ");
INSERT INTO kog_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Guñgueni Duwe Jesú kuíbuldu Kapeldahúmka neyatshak, ezua suldáutshi sáñkalda Alduma zaldaja agakuañneshi ekí akbeyá: ");
INSERT INTO kog_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Duwe, nají nashi mulbatá naxakzeka, najuxa wi wi atshaksá guane guiyaba nagatuñka sha nzhok. ");
INSERT INTO kog_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nukajake Duweja akiyó: —Ake, se akzukual neyaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ekí nukatshakna sáñkaldaja akiyó: —Nají Sáñkalda, najúk nagakjuldú guashi nakzé naldazhúge nzha. Akna tuai zhinikga mijí múldigabak nuxa “nashi iskaitá shi gui” guashi niuwi makexaldiake, “amak se akzék gualdixa shakldá” nakué. ");
INSERT INTO kog_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jinak ekí nakualdaka naldakí. Nas nají sáñkalda niuwi nagegatshak amak axatshikuge. Naldatshak jiak, nas jiaga suldáutshi sáñkalda naugakna, niuwi kagekugamak naxajanashixa. Akna ezuañki “newa” axaldexaldikuake amak neñka, azhi ezuañki “jai nak guwá” axaldexaldikuake amak naxaldaka. Ekibeñga nají nashi “jalde atsha guwá” axaldexaldikuake amak naxatshixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ekí nukatshakna Duwejañki “¡sakí shi ekí nakbé!” akldeshi na, káguba agapa nakldekuek ekí kakbeyá: —Namak miñmeyaldikue. Jejié axautshi saná naldatshak mitsá alduna nazishamak, ni ezua nauwisaná Isayélkue ekíga muldetua alduna nazishaka tuakíñga nogashakú. ");
INSERT INTO kog_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Akna ekí miñmeyaldikue. Kagik zhekuauxa niuwi nañkajaldi, niuwi agajienaldi zalda matshuwi axautshi saná namak najañgualdixa. Aikue na jékaldaxa Najate sanegeñka ajuldunatshak atemajañ zeñ kakldeshi, nauwibama Abaldahám, Isák, Jakóp juizhiñga Jate abuazál axaldashi iyaldaxaldixakue. ");
INSERT INTO kog_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Naldatshak anuñka juldiú sanákue Jateja izhgakuxanekue aldéñ kaksanegasʉ́ñ kakzegéñ zhinik na, aldéñ sanegeñka kajuldukshazháldi na, tuañ zeñka kagajuekuane kaldokshaldixa. Akna, eni abanekue zʉxaita abauwi, kalzauldi za abaldixakue nzha. ");
INSERT INTO kog_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Guñgueniki Duweja sáñkaldak ekí akbeyá: —Mokue mijuldi neyabikuká ni gu. “Nají nashi nagiskaitshaldixa shakldá” namak jañgui, alduna nazishamaldamak zexaldixa nakldá. Ekí akbeyatshaga na, ají nashiki amak se akzukuá na gua. ");
INSERT INTO kog_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Guñgueniki Duwe Jesú Péguldu tshuxa neyatshake, etshi akagiki guañgua zalda akzegatuka sha tu. ");
INSERT INTO kog_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ekí tuñguake munzhitshi káuxalda kaugipañguatshake guañgua zalda iskaitshake, izhgaldagueniki akauwaldá na gua. ");
INSERT INTO kog_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Guñguenik tuañ zegapanatshake, matshuwi káguba jisétshi alduna ijuldunekue Duwek akualdák. Guñguake aldéñki múldigabak nuxa jisétshi aldunakue “newiñ” axaldegatshak amak kezheñshá. Atshaga na, saldiñga mulbatá akzekakue jiaga nuk kalzʉxaitshi, se kakzukuá. ");
INSERT INTO kog_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ekí zexeki mauzeñga Jatetshi múldigaba naldiñga zʉxaitshixa Isaiyak Jatejañga ezua zʉnekualdal gaxaldixa, sakí zʉñkatshaldixa shalda guakldane amak zexaldiamak ekí zek: “Ejañki saldiñga mulbatá mikzék guakue nahauxa se zʉñzukui, nuk zʉnguxá guane. Se zʉñzegagáldekue nuk zʉneskaitshá guane nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Guatshak Duwe Jesúja káguba zhikyokualdi duwá ibategaté katuatshakna, aldéñ shaxaldixakue ekí atshakue kakbeyá: —Niwak ataba niñkauwa kanuwak kuizakbateshí. ");
INSERT INTO kog_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ekí kakbeyatshakna, ezua guiyaba shizhixa Duwek axaldaguenik ekí axaldék: —Shi maldazʉñkaldixa, migapa nendana nakzeshi na, mani maldeyaldiák aldi jiaga migapa nenaka ni itshankú. ");
INSERT INTO kog_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Guñguake akiyó: —Ake, ekí jañguakue migatsé. Kalkalda piyuki kabaxaldixa jakata axaldé, nubáki kabaxaldixa juwí axaldé. Ne nas Jatetshi Asukuága ixagabaldekldugek niñkauwañki, nají juwí giemi kabaxaldikuamak naxaldaldazhé nzha. ");
INSERT INTO kog_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Atshaga na jiak, ezua agapa neñkaja ekí axaldék: —Duwe, migapa neyaldikuega naldatshak, axáñ misha najate numañ izhgatuwiñga, kagi izhgisha guakue maldajañgualdí. ");
INSERT INTO kog_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Guakna ekí akiyó: —Mieldekueki namak najañguagáldekueki aldunaldi shuane jana ne. Akna aikueja shuanekueki kagi ishkiyashaka majañgualdí. Ne ma zʉnake nagapa maldeyaldí —na akiyokuá. ");
INSERT INTO kog_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Guñgueniki Duwe Jesú aldéñ shaxaldixakue juizhi kanuwak ajuldunguenik uniñkauwa agabatexaldá. ");
INSERT INTO kog_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Amak agabategatogueñki tua kakzegagáñga, múlkalda kamakualdi neyaldá, niwa jiaga kamakualdi kuiziji na, kanuwak ni sʉnexaldá. Ekí zegatoguéñ, Duweki kabane na noxá. ");
INSERT INTO kog_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Noxakna aldéñ shaxaldixakueja uba agaldeñshi ekí axaldék: —Nauwijí Sáñkalda, yo zʉnakuá guwá. Ni zʉnatuasáñgui, zʉnakuaxaldá ni gu. ");
INSERT INTO kog_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Guake kakiyó: —¿Jinak shi ekí zʉ́xaita zalda zhe miñzék? Auxaga alduna nazishakí zhinik guana ekí miñzegashá. Ekí kakbeji na, izhgaldagueniki múlkalda kamakualdi neyatogué, niwa kuizatogué ekí axaldék: —Te nogwá. Ekí niuwi agegatshaga na múlkalda neyaksá, niwa jiaga kuizaksánatshake mokue janshibeñga ne na zexá. ");
INSERT INTO kog_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ekí atshaté atuatshakna, “¡sakí shi ekí atshí!” ajañgui na, ataba atabañ zhinik: —Jalde sigíki ¿me nak ekí múlkaldaja, niwaja amak axatshixa ne? —na izhgaldukajá. ");
INSERT INTO kog_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Guñgueni niwa uniñkauwa agabategatshake Gadalda baxe aldé. Exaki Duwe kanuwak zhinik akjienatshake, mozhua sigí jisétshi aldunakue kejuldune jakateldi shuanekue abegaldi zhinik axaldák. Guatshak jiséjañga aikueki kaksanegatshakna, zʉ́xaitsha kama kaxaldaldi, sha makuakuekue naldakna, ni me ai jakatak ga zʉxaitasʉ́ñ atuñká. ");
INSERT INTO kog_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nalgué ekueja Duwe ekí jaldáñ axaldék: —Jesú, mañki Saldiñga netshi Jatetshi Asukuá giemi maldé, ¿sakí maldazʉnakualdixa ne? ¿Azhi Jateja guiyaba zʉnatuñshaldixa niuwañ akldañkagáñga guiyaba zʉnatuñshal nakbalde ne? ");
INSERT INTO kog_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Guatshak exaga nauwa agajué zeñka matshuwi mitu zatoguakna, ");
INSERT INTO kog_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ai jisétshi aldunakueja Duwe ekí axakuañnék: —Jai sigíkuek zhinik izheyakue maldazʉnajañgualdiake, ake, uñguexa mitukuek kejuldunakue maldazʉnajañgualdí. ");
INSERT INTO kog_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Guñguake Duweja: —Ake, amak guwíñ. Ekí kakbeyatshakna, ai aldunakue sigíkuek zhinik saldi agazaxaitiñguenik, mitukuek iyajuldú. Guatshakna mitukue aldaldiñga niwa sáñkaldak guísʉgaxa pe pe pe akjienatshake, nuk ni izhgatushi ashuizhá. ");
INSERT INTO kog_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ekí atuñguakna, mitu numañ tuñkakue aldaldiñga kuíbulduxa aldeñgueni atunauxa sakí Duweja ai mozhua sigí jisétshi aldunakue kezheñshaté atune akuák. ");
INSERT INTO kog_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ekí aldukañguakna, saldiñga kuíbulduk zaldakue Duwe atuál saldi aldé. Amak atuatshakna Duwe mokue eñgui zhinik neyakue na axakuañnexá. ");
INSERT INTO kog_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ekí zegatogueni Duwe Jesú kanuwak juldungueniki akbateshi mokue ají kuíbuldu Kapeldahúmka akbaték. ");
INSERT INTO kog_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Exaki ezua sigí abuá axazauwaksánane ixabakak akshañga apebukueja Duwek akualdák. Ekueja Duwejañki se akzukualdixa alduna iyashiji akualdaklde katuakna, abuá axazauwaksánanek ekí akbeyá: —Nasukuá, zeñ itshanwá. Sha matshixa nuk mixabetá ni gukú. ");
INSERT INTO kog_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ekí aldukatshakna, anuñka guiyaba shizhixakuejañki kauwizhéñgaba ekí izhgabeyá: “Ekí negatshake Jate aguáñ izhbashi mual negashá.” ");
INSERT INTO kog_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ekí ajañguatuka Duwejañki katuñguakna ekí kaklduká: —¿Jinak shi ekí kutám agatsaldi minajañgú? ");
INSERT INTO kog_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Guake, ¿mielde shi aguáñ jibañ akzaldi, abuá axazauwaksánanek akbenaka na? ¿“Sha matshixa nuk mixabetá ni gukú” azhi “izhgaté xaldeki newa” shi akbenaka na? ");
INSERT INTO kog_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ne naski, Jatetshi Asukuága ixagabaldeklduge, jai kagik sha atshixakue axabetaldikuamak niuwi naxaldé mimatuñshaldikue. Guaguenik abuá axazauwaksánane ekí axaldék: —Izhgaté, mixabaka guxa xaldeki mijuldi newa. ");
INSERT INTO kog_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ekí akbeyatshaga amak izhgaldaguenik ajuldi ne. ");
INSERT INTO kog_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Guatshakna saldiñga tuatoxekuejañki: “¡Sakí shi ekí janshi akzukú!” ajañgui na, Jateja ekí agatsaldi atshexañ ezua kágubak kama agene shalda Jate za akldé akzamakga agazukuá. ");
INSERT INTO kog_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Duwe Jesú exa zhinik neyatogueñki, nas Mateyuk natú. Naski sáñkaldak akiyalzabine zhiksuikuge nalgukuakna nagasabiyaldiéñ ité natuñguake ekí naxaldék: —Shi maldagitiyaldixa nak nagapa kuizaldi. Ekí naxaldeguake izhgaldagukueniki amak agapa neyaldá. ");
INSERT INTO kog_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Guñguenik Duweki najuxa zatogueñga, matshuwi najanañga sáñkaldak akiyalzabine zhiksuikakue, axautshi sha atshixa akuakakue jiaga aldagueniki, Duwe shi kagitixakue juizhi yaldashi asaldá. ");
INSERT INTO kog_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ekí zaté zʉnatuatshakna, paldiseyukueja Duwe shi kagitixakuañ ekí zʉñkaldék: —¿Shi miñkaldixaki sakí zhinik shi sha atshixakue na, sáñkaldak akiyalzabine zhiksuikakue juizhi zatók? ");
INSERT INTO kog_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ekí nukajakna, Duweja kakbeyá: —Se nekueki méldiku kagajuezhazhé. Akze, mulbatá akzekakue guana, méldiku kagajueshka naldashá. ");
INSERT INTO kog_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ekí Jateja guaklde: “Kágubagaba guañ ajañgui ishkajanashixá na akldé naxatshakue kajañguge. Ne béyakze nagakuagakue za kajañguazhúge nzha.” Ekí guaklde na, sakí guashi guaklde tuakue ni mimajañgukú. Akze, naski mieldekue axaldáñgaba “jian sha izhokú” itshankakue Jatek axakualdinaldiamak kaldiyal nagazhánuge. Ekí ne, sha atshixakue niñkauwañki sha ajanashixa abajiñga abaja xaldeki Jatek axakualdinaldiamak kaldiyal naklduge ni mitú. ");
INSERT INTO kog_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Guñguenik Juañ nik majaukshakue shagitixakueja Duwe axaldaguenik ekí agalduká: —¿Sakí shi nasʉñki, paldiseyukue nañki Jate muldetua axazguagakualdiamake záaki katshekue ne, ma shi maxaldixakue zʉnake asáaki anuñka ashekua akuazhé na? ");
INSERT INTO kog_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Guake Duweja ekí nuxa kakiyó: —Nauwisaná sigí numa nexaldixa naldieñki matshuwi abuzatiakue akbeñka. Gualdinik aldéñ kagapañga nogeñga abuzál nakldekue ¿sakí shi itshani ashekualdaka na? Guanaldixa sigí numa neklde ishkapañgui awaldeyaldiéñ ldiuwañ zegatshak zʉnake apebukueki itshani, asáaki aldoxaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ekí kakbeñguenik jiak, ekí kakbeyá: “Ni meja zhakuá abisa ne duebak agapa guazhé. Azhi ekí guatshake, akldé zhindu axazgualdixa. Ekí guatshak míñgaki akldé nusakuá gualdixa naldashá. ");
INSERT INTO kog_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ekibeñga na, ni meja alditsha tanagáldega moñkú duebak kuashazhé. Azhi ekí kuashaldiake tanatshak moñkú dueba kualbenatshake, alditsha jiaga nuk zuldatshake, mozhuañga itshuana guaka naldashá. Ekí atshaka nakna, alditsha tanagáldega moñkú abisak za kuashakue. Ekí guanake mozhuañga alditsha, moñkú nañga nusaldeshi itshuanazháldixa naldashá.” ");
INSERT INTO kog_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ekí guaxalga nogueñga na, ezua sáñkalda juldiútshiga Duwe stak axaldagueni nuldu axayoshi ekí akbeyá: —Nabunzhiki kaiga guana nakshuizhá ni gu. Nak ma exa maldeyaldinik káuxalda ipa makuatshake “mokue izhgaté guaka shakldá” na jañgukú. ");
INSERT INTO kog_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ekí akbeñguake, Duweki izhgaldagueni nasʉñ shi kagitixakuañ juizhiñga agapa ne. ");
INSERT INTO kog_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Amak neyatogueñga na, ezua munzhi, ají mulbatája guxa guñguenik 12 kagi itsegatuka nalguák Duwe shaneldi ga naguenik zhakuá sʉxak juguá. ");
INSERT INTO kog_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aldéñki “Duwetshi zhakuá nuxaki jugualdatshake, se nakzukualdixa shakldá” jañguñguák ekí juguá. ");
INSERT INTO kog_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Amak juguatshaga na, Duweki neyatogué zhikbateguenik ai munzhi tuatshak ekí akbeyá: —Nabunzhi, zeñ nuxa itshanwá. Mañki “neskaitshaka shakldá” najañgui, alduna maldeshéñ zhinik na se mikzék ni gu. Atshak zhinikga na, ají mulbatá iskaiti, muldetua se akzék na gua. ");
INSERT INTO kog_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Guñguenik Duwe sáñkalda tshuxa neyatshake ezua shuigatshak ajanashamakga, kuizi ajuishi, káguba duwá zhikzhe nakldekueki jaldáñ shuane axabauwaté Duweja tuatshakna ");
INSERT INTO kog_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ekí kaxaldék: —Jai zhinik nuk akzʉxaitá guwíñ. Kumíki shuigazháne, egaba kabashi guatogák. Ekí aldukatshakna, shuane kakualguakna Duwe iyashimá. ");
INSERT INTO kog_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Guatshak jiaga, Duweja kakzʉxaitshiñguenik kumí shuane nugaldi juldungueni etshi káuxalda akpanatshaga mokue izhgaté na gua. ");
INSERT INTO kog_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ekí kumí izhgaldakshane shalda na, saldiñga eñgui baxe nahauxa izhukakueja ai shalda izhgabejiñgaba na ashekualdá. ");
INSERT INTO kog_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Duwe Jesú exa zhinik neyatogueñki, mozhua sigí uba isékue axapañga aldeji saldiñgaja nukandana agatsaldi ekí iyaxauldaldá: —Mañki nauwibama sáñkalda Dabítshi atukuaga maldé, guañ maldazʉnajañgualdí. ");
INSERT INTO kog_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Guñguenik Duwe juk juldungueni, ai mozhua uba isékue axaldagatshak ekí kaklduká: —¿Maiñ minajañguxáki uba minkukshanakldegamak shi minajañgú? Guake akiyayó: —Akze, amak zʉñkatshamildaka na kabajañgú. ");
INSERT INTO kog_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ekí akiyayokuñguakna Duweja ubak kaugikepañgui ekí kakbeyá: —Ake, maiñki “uba nazikukshaka shakldá” najañgui, alduna nazishaminamak uba minkuká ni gu. ");
INSERT INTO kog_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ekí kakbeyatshaga uba kekukshá. Gueni Duweja keshkaldukshi ekí kaxaldék: —Ekí uba mimekukshanuge meja akwashegazháldiamak kama ilshiji miñgualdí. ");
INSERT INTO kog_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ekí kaxaldeklde nalgué jiaga, exa zhinik aldeyapanatshaga sakí Duweja kaxatshane shalda saldiñga eñgui baxe nahauxa akuashiñgaba aldeyaldá. ");
INSERT INTO kog_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Exa zhinik agazaxaitatogueñga na, ezua sigí jisétshi aldunaja ijuldunatshak zukuakshaksá guane nalgué Duwek akualdák. ");
INSERT INTO kog_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Guake Duweja ai alduna izheñshatshaga na, jiak mokue zukuaxaldá. Guakna saldiñga atuatoxekuejañki “¡sakí ekí se akzukuxá!” ajañgui na: —¡Jai nauwisanákue Isayél kenañga ni mitsák ekí zegaté tuañkáalde giemi nzha! —na akuaxá. ");
INSERT INTO kog_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Akuagatshak paldiseyukueja niñkauwañki: —Ejiéki jisé ají aldunakue aksanekaja kama agegatshak guana ekí ají aldunakue izheñshashá —na nalda axakuaxá. ");
INSERT INTO kog_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Guñguenik Duwe Jesúki eñgui baxe kuíbuldu nahauxa juwí izhajuizhaldegeñka “Saldiñga netshi Jateja kágubakue janshagatsaldi kaksanexaldixa nakldá” kakbeji na mizhatoxá. Ekí kakbeji na, káguba mulbatá saldiñga nalda kakzekakue keskaitshi, se akzegagáldekueki se kakzukui na mizhatoxá. ");
INSERT INTO kog_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Duweja kágubakue duwá zhikzhe ashé katuatshakna, guañ kajañguá. Jinake ekí kajañguazhá. Ekueki jubeju aksaneka, numañ tuñka naldakí kakzegakldegamakbé kagusani, jie kakzeshi “sakíga ni atshanakldék” akldegagáldekue katuwák. ");
INSERT INTO kog_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ekí katuwakna shi kagitixakuañ ekí zʉñmeyá: —Tek gakue matshuuwi gugakuegaba negatshak, jiba atshakakue auxaga naldakí nahamakbe, matshuwi nepanaldixakue nañga naldatshak, nas shalda kakbeyakakue auxabé naldakí. ");
INSERT INTO kog_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Akna, tetshi jáugukuik jiba axatshaldixakue akldé gagakue akshishakuamakbé, nauwijí Sáñkaldaja nas shalda guaxaldixakue gaxaldiamak miyakshishaldí —na zʉñmeyá. ");
INSERT INTO kog_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Guñgueni Duwe Jesúja aldéñga 12 shi kagitixakuañ zʉnajuizhakuatshak jisétshi alduna kágubak ijuldunekue izheñshakualdiamak, saldiñga nalda mulbatá akzekakue iskaitshakualdiamak, se akzegagáldekue jiaga se kakzukuakualdiamak niuwi zʉñgé. ");
INSERT INTO kog_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Duweja aldéñ 12 shagitiyakualdinik ají múldigaba guaxal zʉnakaxaldixakuañki ekí zʉñkazhukakue: Ezuañki Simóñ, ega Péguldu jiaga akuaka. Ezuañki Andaldé, Simóñtshi aldani. Ezuañki Santiaku, ezuañki etshi aldani Juañ, alde mozhua nekueki Zebedeyutshi asukuákue. ");
INSERT INTO kog_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ezuañki Pildipi, ezuañki Baltoldomé, ezuañki Tumás, ezuañki nas Mateyu sáñkaldak akiyalzabine zhiksuikuge nane. Ezuañki Santiaku, eñki Alpeyutshi asukuá. Ezuañki Taldeyu, ");
INSERT INTO kog_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ezuañki Simóñ, eñki axautshi saná kauwijí kagik sanekakue akzʉxaitshaldiamak niji izhuka. Ezuañki Juda Iskaldiute, eja na aldiweki Duwe Jesú gexaldixa na naldá. ");
INSERT INTO kog_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Duwe Jesúja nasʉñ 12 shi kagitixakuañ ají múldigaba guaxal zʉnakagapanatshak ekí atshakue zʉñmeyá: “Nauwisaná naldagáldekue nugaldi neyabináldi. Ni Samaldiaxa kuíbuldukueni jiaga neyabináldi. ");
INSERT INTO kog_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ne nauwisaná Isayélkue Jatek axajuezhá guanekue nugaldi zʉnake mineyaldí. Ekueki jubeju numañ tuñkak agitshuani axajuezhamak Jatek axajuezhanekue. ");
INSERT INTO kog_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ekí mimakaxanuge neyabinoxaldiéñ na, maniñgaba mineyatshak ekí kakbeji mineyaldí: ‘Jate jékaldaxa izhukaja aldéñ naldiñga miñsanexaldiéñ zexaldá na guapán.’ ");
INSERT INTO kog_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ekí guashi na, saldiñga mulbatá akzekakue keskaitshi, shuanekueki mokue kezhgaldakshi, ajuba ikaldunatukakueki janshi kaxazguí, káguba jisétshi alduna ijuldunekueki kezheñshiji mineyaldí. Maiñki ekí egabá kagauneshiñga ni ji miñzabiyakue itshanabináldi. Akze, Nauwijate aldéñ naldiñga ají kamaki kágubakue miyagaunexaldiamak egabá miñgenamak agatsaldi maiñ zhinik kágubakue miyagaunexaldí. ");
INSERT INTO kog_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","”Mimakaxanugamak neyabipanatshak, ni nauwa paldata agatsé uldeyabináldi. ");
INSERT INTO kog_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ekíga na, gamá jiúñguldak miyuldeñka, zhakuá mozhua, sapatu mozhua uldeyagába, ni kaldi miñté mineñka jiaga uldeyabináldi. Jinake ekí mimakagakí. Maiñ mielde miyaxazauñkaki, ji migajueshka miñgaunegakue agatsaldaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","”Amak mimakaxanaldikue mielde kuíbulduxa mineyatshake, eñka ezuañki mimepanakuamak mimepanaka tu niji, eñka za kabashiñga mokue eñ zhinik mineyaldí. ");
INSERT INTO kog_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ai juk mijuldunatshak kishkazguagamakga ‘jai mizhekuekuañ Jate aldunaxa señgaba shi miñzukuí’ minexaldí. ");
INSERT INTO kog_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ai juk zaldakue muldetua minapanaldiake, ake, Jatejañga akshishaminamak aldunaxa señgaba kakzukualdixa. Azhi muldetua minapanakí naldaldiake aldunaxa señgaba kakzukuazháldixa. ");
INSERT INTO kog_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ne mielde juk azhi kuíbulduke miñkaldukakí, mimeyapanasʉ́ñ kakzexaldiake, eñ zhiniki ne miñgualdí. Neyabipanatshake Jateja guiyaba katuñshaldixa ne katuñshi na, kaksibuldi kasak zhiktiñguá mineyaldí. ");
INSERT INTO kog_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Namak miñmeyaldikue. Mielde kuíbuldukueki mimeyapanasʉ́ñ kakzexaldiake, Jateja kágubakue kagatsaldi ne katualdixa ldiuwañ zegatshak, mauzeñga Sulduma, Gumulda zaldakue zʉxaita sha ajanashanane shalda mitsá guiyaba katuñshaldixa guashiñki zhakaldak katuñshaldixa nzha.” ");
INSERT INTO kog_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ekí zʉñmejiñga ekí jiaga zʉñmeyá: “Jubeju nabi kenaxa axaká jana naski káguba aguldiñkugekue, miñgisalshakakue kenaldi ni mimakakú. Akna aguldiñkugekueki miñgisalshindana kakzegakna, takbi sha akuazháldiamak be noshi numañ atuamak numañ miyatualdí. Ekí mizhekualdaldiéñ shamíki ni ji sha guazhámakbe maiñ jiaga ni me sha guabíne mizhekualdaldí. ");
INSERT INTO kog_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","”Akna kágubakuek zʉnake be miyaxaldoxaldí. Akze, kauwizhéñki nagapa mineñka shalda nuxa minapanaldinik nauwisaná nauwa akldé akzekue miñgatsaldi ne matuakue nugeñka mimawaldeyaldixa. Ekíga na, nauwisanákuegaba izhajuizhaldegeñka mimawaldeyaldinik exaki kuizhushak miñgaldabikshaldixa. ");
INSERT INTO kog_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ekibeñga na, nagapa mineñká shalda sáñkalda aguáñ akzé, akldé akzé nugeñka miñgatsaldi ne mimawatualdiamak mimawaldeyaldixa. Eñkaki Jateja minkualdal nakaxane shalda ekuek, nauwisaná naldagáldekuek jiaga kakbeminakaga mitualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Akna mitsake amak mimakuxaldiniki miñgatsaldi ne mimawatualdieñka mimawaldeyatshak, ‘¿Sakí zhikzukuaxaldikue ne? ¿Sakí agatsaldi guaxaldikue ne?’ ijanagába. Akbiñgaki guagakue miñgatsegatshake Nauwijatetshi Aldunajañga sakí guagakue miñsanexaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Akze, maiñgabaga zukuaxabináldixa, ai Aldunaga na maiñ zhinik zukuaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","”Atshakna, nepanazhánekueja nepanaminekue shalda nuxa anuñkaki mimakuaxa mimakualdiamak miyaguldiñkakuek mimagaxeshi na, ezua nepanazháneja akaja giemiga nepanane ekíga gexaldixa. Azhi jatekueja kauwijí sukuakue axexaldixa. Azhi sukuakueja kauwijatekue kaguldiji, akuaxa akualdiamak axexaldixa. ");
INSERT INTO kog_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Akze, kagik káguba zhekuauxa zaldakuek najíkue miné shalda nuxa miyaguldiyaldixa niyó. Naldatshak mieldeke nas shalda guiyaba tuakue miñgatsegatshak jiaga, abá naldakí nagapa neyal za mishuixaldieñka yo mizhekualdaldiák zʉnake, mimeyakuane jékaldaxa izhoshiñga mizhogataná nakldá. ");
INSERT INTO kog_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mielde kuíbulduxaki nashaldá sha mimakuí gualdiák, eñka zhinik nakuishiñga awaxani mineyaldí. Akze, namak miñmeyaldikue. Nas jiba naxatshál mimakaxaldikueni saldiñga Isayél kuíbuldu nahauxaga naxatshiji saldikshagá minoxaldieñga, jiak mokue nas Jatetshi Asukuága ixagabaldeklduge naxaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","”Akze, ni mielde shitixaga nuxa aldéñ shaxaldixa zhakaldak akzé naldazhé. Ni mielde nashiki ají sáñkalda zhakaldak akzé naldazhé. ");
INSERT INTO kog_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Akna, maiñ nají nashi shi minagitixakue minakna, nas mimijí sáñkalda shi miñkaldikuge janañga miñgatsexaldiake, ai za auxabé jañguakue miñgatsé. Ekibeñga na, kágubakue sakí nakuaté mituake amakga mimakualdixa miñkualdakue. Akldé nas mimijí sáñkaldak jiaga, Belsebú jiséga ají aldunakue aksaneka naugé nalda naxakuagake, maiñ míñgaki ekíga nalda miñkakuaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","”Akna miyaguldiñkakue zhe miñzukuagába. Jinake naldakí. Ji ziñ me nanaldixa auxaga muetsexaldixa. Ekíga na, ji meja aksʉ́ñ nanaldixa auxaga muetseshi, washexaldixa. ");
INSERT INTO kog_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Akna zhe miñzek naldakí, naski ji ziñ me miñmenaldikue, maiñ zʉnake saldiñgaja nukandana jaldáñ káguba kenañ guagakue. ");
INSERT INTO kog_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Akna, kágubakue nuxa zhe miñzukuagába. Akze, ekuejañki mimijí abuá za guagaka, naldatshak aldunaldiñki sha mimakuazháka. Ne Saldiñga netshi Jate zʉnake abuák mimakuagaka, aldunaki jiséxa, guiyaba tu za nogakueñka gagaka nak, zhe miñzukuakue giemi miñgatsé nakldá. ");
INSERT INTO kog_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","”Naldatshak jiak aldéñga na muldetua numañ mimatuñka. Akze, kágubaja tuwiñki nubábuldu muldetua akzaldazhé jañgui na mozhua nubá muneda nauwamé akzék nabeyasatshak jiaga, Jateja zʉnake numañ katuwiñga na, ni ezua agatsalda nuxaki kagik akjieni shuigakue jañguakíñga shuigazháka. ");
INSERT INTO kog_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ne maiñ míñgaki Nauwijate numañ mimatuwi, ek muldetua auxaga akualdi na, mimijí sai mitsá agatsalda minduka jiaga auxaga akué. ");
INSERT INTO kog_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Akze, maiñ míñgaki nubábuldu zhakaldak miñzé minahakna, zhe miñzegagába mizhekualdaldí. ");
INSERT INTO kog_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","”Mieldejañki ‘naski Duwe Jesú namak jañgui, agapa neñkugé nakldakú’ kágubakue nogéñ guaxaldiák jiak, nas zhinik ekíga Najate jékaldaxa izhukak ‘eñki nagapa neñka, najíga nakldá’ akbeyaldikue. ");
INSERT INTO kog_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ekí ne, mieldejañki ‘naski Duwe agapa neyazhúge nakldakú’ kágubakue nogéñ guaxaldiák jiak, nas zhinik ekíga Najate jékaldaxa izhukak ‘eñki nagapa neyazhé nakldá’ akbeyaldikue nzha.” ");
INSERT INTO kog_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ekí zʉñmejiñga na ekí jiaga zʉñmeyá: “Maiñ minajañguxáki ¿kágubakue askuiñgaba kakldeshi, señgaba zhe kaldokshal kagik naklduge shi minajañgú? Naldagálde, ekí atshál nagazhánuge. Ne nakldugéñ zhinik nuxa na kágubakue sha sha ajañgui, kauzhikshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nas naklduge shalda na, najañguazhékuejañki nashaldá nuxa asukuája ajate aguldiyaldixa. Ekibeñga na, abunzhija ajaba aguldiyaldixa. Ekíga na, ajuazija akagi aguldiyaldixa. ");
INSERT INTO kog_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ekí nakna akaja giemi, ajúk zaldakuega najañguxaki aguldiyaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","”Mieldeki ajate azhi ajaba za na nazhakaldak izhgajañgualdiake nají nalda agatsaldazháka naldaldixa. Ekíga na, mieldeki asukuá azhi abunzhi za na nazhakaldak izhgajañgualdiake, nají nalda agatsaldazháka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Akze, mieldeki nagapa neyatoxaldiéñ, nají ne shalda guiyaba tuakue azhi shuigakue agatsexaldiake, egaba abeti ‘wa nuxa ni nakldexaldí’ izhgakuxane naldakue. Ekí izhgakugazháne naldaldiake, nají nalda agatsaldazháka naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mieldeki jai kagik izhoxa za akldé akzé jañgui, nagapa neyasʉ́ñ akzekáki shuigatshak jékaldaxa izhoshiñga izhogazháldixa. Ekí ne, mieldeki nas shalda shuigaka izhgakuxaldiák zʉnake, jékaldaxa izhoshiñga izhoxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","”Guatshak mieldeki mimepanatshak nasga naziyapanka. Ekíga na, mieldeki nazipanatshak nakaxanega jiaga ipanka. ");
INSERT INTO kog_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mieldejañki ezua Jatetshi múldigaba naldiñga zʉxaitshixa, ‘eñki Jatetshi múldigaba naldiñga zʉxaitshixa shakldá’ jañgui muldetua ipanaldiake, jiak Jateja ají múldigaba naldiñga zʉxaitshixa mitsá janshizhe axatshaldiamakga axatshaldixa. Ekíga na, mieldejañki ezua jian izhuka, ‘eñki Jateja jañguamak jian izhuka shakldá’ jañgui muldetua ipanaldiake, jiak Jateja jian izhuka mitsá janshizhe axatshaldiamakga axatshaldixa. ");
INSERT INTO kog_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ekíga na, namak miñmeyaldikue, mieldejañki ezua ai itsaldagálde nagapa neñká shalda ni nuxaki akáu gualdiake, Najateja ai shaldaki namak giemi janshizhe axatshaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ekí Duwe Jesúja nasʉñ 12 shi kagitixakuañ sakí ají jiba axatshakualdixa auxa zʉñmeñgueniki amak zʉnakaxá. Guñgueni aldéñki eñgui Galdildeya baxega kuíbuldukueni Ajate shalda kakbeji, shi kaxaldiyal ne na gua. ");
INSERT INTO kog_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Guñgueni Juañ nik majaukshakueki kalseldi izhoguéñ Duwe atshatoguauxa nukañguake, aldéñ shaxaldixakue ekí Duwek akzʉzukal kakaxá: ");
INSERT INTO kog_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—Saldiñga netshi Jateja ezua zʉnekualdal zʉñgakaxaldixa guakldane ne, ¿ma ai shi maldá? ¿Azhi aiki jiaktuakuega shi zʉñgatsá? ");
INSERT INTO kog_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Guake Duweja kakiyó: —Mokue Juañ nugaldi mineyaldiniki sakí mimijí ubak naldi atshaté natumine, sakí guagaté naldukamine miyakbeyaldí: ");
INSERT INTO kog_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Uba isʉ́ñzekueki kazʉtuñshapani, kalda ixanane neyagáldekue kaldeñshapani, ajuba ikaldunatukakueki mokue janshi kaxazguí, zukagáldekueki kazukshapani, shuanekue jiaga mokue kezhgaldakshi. Nashikue zʉnake Jateja sakí kalkualdaldixa shalda kakbeji. ");
INSERT INTO kog_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mieldeki alduna nazishál za nukaki Najateja zeñ jañguxa naldaldixa nakldá —na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ekí kakbeñguake Juañja shaxaldixakue saldi aldé guñguake, Duweja exa ashekualguekuek ekí Juañ shalda kakbeyaldá: “Maiñ zʉk zeñka káguba muldetua zhekualdazhéñka ¿me mitualdixa miñneshi shi neminá? ¿Azhi múlkaldaja abaldaxá mani mual axabuxaldiake aldi, aldi uldeyamakbé, ezua sigí mozhua, mozhua akldeka nuxa shi tual neminá? ");
INSERT INTO kog_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","E tual neyazhámine nake, ¿me shi tual neminá? ¿Azhi ezua sigí zhakuá akzé ijuakue shi tual neminá? Naldagálde. Mielde zhakuá akzé ijuakueki sáñkalda tshuxa za izhuka naldashá. ");
INSERT INTO kog_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ake, ezuañgabaki ¿me shi tual neminá? ¿Azhi ezua Jatetshi múldigaba naldiñga zʉxaitshixa shi tual neminá? Akze, e guana tual nemine naldashá. Ne Juañ míñgaki Jatetshi múldigaba naldiñga zʉxaitshixakue guashiñki zhakldé akzé giemi nakldá. ");
INSERT INTO kog_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juañ shaldaga guana, Najateja nakbeji ají múldigabak ekí sezheklde: ‘Nasga na mizhaxañga ezua maldeyaldixa shalda guashi jiúñgulda semixagauwi jana gaxaldikue nzha.’ ");
INSERT INTO kog_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Akna namak ekí miñmeyaldikue. Juañ nik majaukshakueki káguba kuka guanauxa guashiñki zhakaldak akzé na izhók. Naldatshak mielde minaldaldi nepanaminéñ zhinik na Jate jékaldaxa izhuka miñsanegapanatshak, aikuañ zʉnake Juañ zhakldé miñzekue minaldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","”Akze, Juañ nik majaukshakueja Jate shalda guagapanéñ zhinik kaiga yo, Jate jékaldaxa izhukaja ají kamak káguba kaksanegapanaldixa shalda akuagapanane. Ekí akuagaté aldukatshakna matshuwi nekuejañki kagatsauxa Jateja kaksanexaldiamak aldiji na, jiyájañgaba kagitamakuaté jiaga, abá naldakí kama izhalshijiñgaba ashekualdapanane. ");
INSERT INTO kog_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Guatshak Juañja Jate shalda guaxal nagagá nogueñgaki, Jateja nauwibama Muesék jian izhoxa guiyaba zʉñkabajaneja, ají múldigaba naldiñga zʉxaitshixakueja aldéñ sakí agatsaldi zʉñsanexaldixa shalda zʉñmeyatonane. ");
INSERT INTO kog_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Akze, mauzeñga Jateja ají múldigaba naldiñga zʉxaitshixa Eldiya mokue kagik gaxaldixa guakldane ne, ai namak jañgundana miñzegake, ake, Juañ na e tsaldiñga gaxane nakldá. ");
INSERT INTO kog_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Akna, saldiñga kuxa miñkaldikueke muldetua nukshi miñgualdí. ");
INSERT INTO kog_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","”Maiñ kaiga zhekualdabinukakuañ, ¿ji na shi mimezhguajanaka na? Maiñki sukuakue káguba zhenéñ ajokldegatukakue jana nuxa miyatshixa. Akze, sukuakueki ajokldeshiñga na, ");
INSERT INTO kog_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘kaigaki zeñ zʉñneshi kuizi ajuigatshak kuiskuizi’ izhgabeyatshak jiaga, ezuakuejañki ‘ekíki zʉñnunakí nakldá’ aldeshi amak akuizazhé. Ekí aldexaldiake ake, ‘kaigaki ezua zʉnshuane ibauwañkalduka janañgaba neshi kuisjokldeshi’ izhgabeyatshak jiaga, ezuakuejañki ‘ekíki zʉñnunakí nakldá’ aldeshi amak aldegazhé. ");
INSERT INTO kog_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","”Jinake ekí mimezhguajanaka naldakí. Juañjañki gakue miñgajamak gazhé, kalwéldia siyagaxaune tugazhé nalguakna, maiñki ‘eñki jisétshi aldunaja aksaneka nakna ekí izhók’ miñguaka. ");
INSERT INTO kog_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Naldatshak nas Jatetshi Asukuága ixagabaldeklduge zʉnake, maiñ mizajamakga zakuge, kalwéldia siyagaxaune nauwa tukuge. Ekí minatuatshakna, ‘E zʉnake zʉ́xaitsha zaxa, tuka. Eñki sha atshixa akuakakue, sáñkaldak akiyalzabine zhiksuikakuetshi apebu nzha’ minakuaka. Ekí mozhua kaldamakga minazʉnakuaka nak zʉnepanasʉ́ñ miñzeka. Naldatshak anuñka nekuejañki nasʉñ shizhiyañkaldamak jian atshiji ashekuéñ zhinik na, Saldiñga netshi Jate aldéñgaba mitsá ishkué ne awatuñshaka nakldá” na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Guñguenik Duwe Jesúja kuíbuldukue aldéñ naldi kaxabizhiji, exaga na akldé giemiki janshizhe ajanashaté atú guazhámak kaxatshaté atuatshak jiaga, sha ajanashixa abajiñga abajazháldi, Ajate axakualdinazhá guane shalda na kaxaldeshiñga ekí guak: ");
INSERT INTO kog_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Maiñ kuíbuldu Kuldasíñ zaldakue, Betsailda zaldakue na, ¡wau wau wau sakí guiyaba mitualdixa ne! Jinake naldakí. Matshuwi sha ajanashixakuetshi kuíbuldukue Tildu na Sidóñ na, maiñ nugeñka matshuwi janshizhe ajanashaté atú guazhámak miñkatshanugamak kaxatshanakuashíñki, kauwizhéñki mitsaga zhinik sha atsha majiñga maja, Jatek axakualdi guane nogataldé. Amak abajatshake sha ajanashane shalda izhajaniñgaba saldiñgaja katualdiamak ajanashá guane nogataldé. ");
INSERT INTO kog_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ne maiñ zʉnake sha atsha majazhá guaminéñ zhinik na, Jateja saldiñga agatsaldi ne tualdixa niuwañ zegatshak, kuíbuldu Tildu zaldakue, Sidóñ zaldakue guiyaba katuñshaldixa guashiñki, zhakaldak guiyaba mimatuñshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","”Maiñ kuíbuldu Kapeldahúm zaldakue, ¿sakí shi Jateki akldé miñzukui, mataxa mimebekshaldixa mijañgú? Akbiñgaki aguáñ giemi mimezhbashiji, guiyaba tu za nogakueñka mimausabaldixa nakldá. Jinake naldakí. Maiñ nugeñkaki, nas naldi janshizhe ajanashaté atú guazhámak miñkatshanugamakga Suldumaxa kaxatshanakuashiñki, kauwizhéñki sha atsha abajiñga abajanéñ zhinik Jateja ai kuíbuldu akldañgashazhá guane nogataldé. ");
INSERT INTO kog_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ne maiñ zʉnake sha atsha majazhá guaminéñ zhinik na, Jateja káguba agatsaldi azhi agatsaldakí ne tualdixa niuwañ zegatshak, Suldumaxa zaldakue guiyaba katuñshaldixa guashiñki, zhakaldak guiyaba mimatuñshaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ekí guaguenik na Duweja Ajate ekí axazguaxaldá: “Najate, ma za saldiñga alnoba agatsauxa, kagi agatsauxatshi Sáñkalda mizhuka akldé mikzamakga mikzukui, ‘zeñ nzhakldék’ ni mikbeñkú. Jinake naldakí. Mieldekueki kauwizhéñgaba matshuwi ishkué itshankakue, jika matshuwi shitiyanekue aldaldatshak jiaga, aikuek na sakí guashi shizhiyatokugeki katuñshazháldi, muldetua kagajienazháldiamak kagitshuakshamalde noxabalduka. Ne ai itsaldagálde axajankakue, sukua jana ma za alduna misha izhukakuek zʉnake amak katuñshamalde. ");
INSERT INTO kog_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Akze, ma ‘ekí ni atshaldikú’ jañgui amak atshamalde nak ‘zeñ nzhakldék’ ni mikbeñkú.” ");
INSERT INTO kog_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ekí axazguaguenik kágubakuek ekí kakbeyá: “Najateja ishkué nalda, kama axaldá nahauxa nasgaba nagene. Najate aldéñ za nas Asukuák me naugé auxaga akualkuge. Jiak ekibeñga na, nas Asukuák za aldéñ ‘me ne’ auxaga nakué. Ekí nakuakna, Najate ‘me ne’ mieldekueki katuñshaldikuamak kezhgakuxaldikuake, ekuek za na amak kakualdaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","”Maiñki sakígaba jibañ miñgatseshi, jigaba, jigabá atshakue miñgatsé miñgabejiñgaba aldunaxa jie miñzeshi, miñgusá miñzekakueki naxaldashi miñgualdí. Amak minaxaldaxaldiake, nas naldi mimezhiksekushaldikue. ");
INSERT INTO kog_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Maiñ nas za miñsanekldaka najañgui, nas shi miñkaldiyanaka minajañgualdí. Jinake ekí najañguakue naldakí. Naski sam akzaldi za atshikuge, aguáñ zhikzukuanuge ga za izhokuge nakna, ekí agatsaldi za miñsanexaldikue. Akna aldunaxa namak giemi mizhiksekualdixa. ");
INSERT INTO kog_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Jinak zhiksekuaminaka naldakí. Nasga ji shi miñkaldikugeki, shitiyasá jibañ miñzukuazháldixa. Ekíga na, ji naxatshakue miñmeñkugeki, atshasá jibañ miñzukuazháldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Atshake izhgasekué ldiuwañ zalguéñ, Duwe Jesú tek zʉxaitatoguéñ, nasʉñ shi kagitixakuañ maldi zʉnakuñguake, eñ gakue nauwa kakuguenik ga. ");
INSERT INTO kog_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ekí atshaté zʉnatuatshakna, paldiseyukuejañki ekí Duwe axaldék: —Tu guwá. Nauwisanátshi guiyabajañki izhgasekué ldiuwañki ni nauwa jiba atshasé guaka ne, shi migitixakue ¿jinak shi atshasé jiaga ekí ajanashatók? ");
INSERT INTO kog_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Guake Duweja kakiyó: —¿Nauwibama Dabíki ezua ldiuwañ apebukue juizhi maldija kakualdá guñguake sakí atshane sezheklde tuabíne sha? ");
INSERT INTO kog_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Guiyabaja Jatek pañ agaxeneki aldéñ múldigaba agaskaitshixakueja za gaka sezheklde nalgué jiaga, nauwibama Dabí apebukue juizhi Jate axazakuagaldi juldunguenik, ai pañ axá. ");
INSERT INTO kog_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ekí jiaga guiyabaja guaká be miñgisegakí shi na? Kizhiksekué ldiuwañki ni ji jiba atshiji atshasʉ́ñze guagatshak jiaga, ai ldiuwañ Jatek múldigaba agaskaitshixakueki juwí Jate axazakuagaldi jiba axajanashatshak, aldéñ tuwiñki sha atshiji axajanashixá katuazhé. ");
INSERT INTO kog_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ne naski ekí miñmeyaldikue. Nasga na, juwí Jate axazakuagaldi zalda guiyaba guashiñki, zhakaldak niuwi naxaldakna akldé amak naxatshakue miñgatsé. ");
INSERT INTO kog_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Maiñga Najateja ekí guagatshak sakí guashi guaklde miñgajienakí: “Kágubagaba guañ ajañgui ishkajanashixá na akldé naxatshakue kajañguge. Ne béyakze nagakuagakue za kajañguazhúge nzha.” Ekí guaklde na, sakí guashi guaklde miñgajiena guane guashiñki, shi nagitixakue kagatsaldazhékue jiaga sha ajanashiji guatuka axakezhagazhá guatabinaldé. ");
INSERT INTO kog_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ne naski Jatetshi Asukuága ixagabaldeklduge naugák niuwi ge guashi naxaldéñ na, izhgasekué ldiuwañ ajanashakuamak ajanashaka niuwi genaka nakldá —na kaxaldexá. ");
INSERT INTO kog_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Guñgueni Duwe Jesú exa zhinik neñgueniki juwí izhajuizhaldegeñka juldunatshak, ");
INSERT INTO kog_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ezua sigí káuxalda ixanane ité tu. Exa na, paldiseyukuejañki Duweki atshasé atshane izhakuaxaldixa aldiyatoshi ekí agazalduká: —¿Nauwijí guiyabaja kizhiksekué ldiuwañ jiaga janshibeñga shi ezua se akzukuakue guaka na? ");
INSERT INTO kog_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Guake ekí kakiyó: —Kizhiksekué ldiuwañ jiaga ¿mieldeke mimijí jubeju pokuéñ miñgakjienatshak ubañga mibekshixa naldazhé sha? ");
INSERT INTO kog_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ne káguba míñgaki jubeju zhakldé akzé nakldá. Akna amak kizhiksekué ldiuwañ jiaga, janshibeñga janshizhe atshakue guiyabaja guaka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ekí kakbeñgueniki sigík ekí akbeyá: —Káuxalda mixanane yu atshiwá. Amak atshatshaga nuxa na, atabañ zalda janañga janshagatsék. ");
INSERT INTO kog_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Guatshakna paldiseyukueki exa zhinik agazaxaitiñgueniki sakí agatsaldi Duwe Jesú sha akuí, akuaxaldixa aldiyaldá na akuapaná. ");
INSERT INTO kog_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ekí sha akualdixa ajañguatuka akualdi na, Duweki jiak exa zhinik ne. Amak neyatshakna matshuwi káguba axapa aldé. Ekuega na mulbatá akzekakueki nuk se kakzukuá. ");
INSERT INTO kog_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Gueni na aldéñki me ne guagasʉ́ñze kaxaldék. ");
INSERT INTO kog_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ekí zexeki Jateja mauzeñga ají múldigaba naldiñga zʉxaitshixa Isaiyak ezua zʉnekualdal gaxaldixa shalda akbenamak zexaldiamak ekí zek. Ekí sezheklde: ");
INSERT INTO kog_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Jejiéki nají nashi, naxazauwaldiamak izhgakuxanuge. Eñki matshuwi izhgajañguge, nakldunauxabé izhuka nakna, zeñ nakzukuxa nakldá. Nají Aldunakga na jañgugamak naxatshaldiamak aksaneshi, kama agexaldikue. Akna saldiñga saná nahauxak nasga niuwizhíne sakí kágubakue katuakuauxabé katualdikue kakbeyaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ni ega nuxaga kágubakue na múldigaba sashiji, ni kuizhakakshiji kaxaldegazháldixa. Káguba kenañ sekuazhikshiji agatsaldi negaté aldukazháldixa. ");
INSERT INTO kog_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","E nají nashijañki abaldaxá ishkuanaté nuká auxaga ishkuá guazhámakbe na, aldunaxa ‘jiga ni atshanakldék’ akldegagáldekue, agisanekue kagisalsha naldakí guañ kajañgualdixa. Ekíga na, guksé sanaté nuká nauxañgaba sañguazhámak, ejañki anuñka me za alduna nazishixakue ni mitsák nauxañgaba ai agitamakuazháldixa. Aldéñki ekí guañ kajañgui, janshizhe atshijiñga na, shane agubiyaldiéñ yo ekí atshaldixa. ");
INSERT INTO kog_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Káguba ikualdal gaxanaldikueki, saldiñga saná nahauxa matshuwi nekuejañki ‘e sha zʉnekualdaldixa na’ ajañgui alduna iyashaldixa nakldá,” ekí sezheklde nakldá. ");
INSERT INTO kog_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ezua ldiuwañ, ezua sigí jisétshi alduna ijuldunatshake uba isañguá, zukuakshaksá guane nalgué Duwe Jesúk akualdák. Guake Duwejañki ai alduna izheñshi se akzukuatshake stualdá, zukuaxaldá. ");
INSERT INTO kog_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Guakna saldiñga atuatoxekuejañki “¡sakí ekí se akzukuxá!” ajañgui na, ekí izhgabeyá: “¿Jejiéki nauwibama Dabítshi atukuaga naldaka shi na?” ");
INSERT INTO kog_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ekí paldiseyakuejañki aldukatshakna “ejiéki Belsebú, jiséga ají aldunakue aksanekaja kama agegatshak guana ekí ají aldunakue izheñshashá” nalda axakuák. ");
INSERT INTO kog_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Duweja sakí ajañguatuka akualdi na ekí kakbeyá: “Mielde sanáki kauwizhéñgaba axaukshapana akualdiake nuk izhgaldañgashixa naldashá. Ekibeñga na, ezua kuíbuldugaba azhi zhuajúk zaldagaba axaukshi izhguldiyapana akualdiák, san san aldeji zhuajúk zalda aldaldaksá gualdixa. ");
INSERT INTO kog_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ekíga na, jisé aldéñga ají aldunakue kágubak zhinik izheñshi guanake, jiségabaga izhguldiji, axaukshapanaka. Ekí ajanashatshake ¿sakí shi jiséja ají aldunakue aksanexalga nogaka na? ");
INSERT INTO kog_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Naldatshak jiaga, naski jisétshi aldunakue aksanekajañga kama nagenek ai aldunakue izheñshikuge nake, maiñ shi miñgitixakueja jiaga jisétshi aldunakue kágubak zhinik kezheñshatshake ¿ake, metshi kamak shi ekí kezheñshixa na? Kauwizhéñ ekí ajanashéñ na, jisétshi kamakga ají aldunakue kezheñshikuge nalda naguagakue miñgatsaldakí ne awatuñshixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ne nas niñkauwañki Saldiñga netshi Jatejañga ají Aldunak kama nagenéñ zhinik na jisétshi aldunakue neñshaldatshak guana, aldéñki au mimikenáñ sanexaldá guxá mimatuñshashá.” ");
INSERT INTO kog_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ekí kakbejiñga na ekí jiaga kakbeyá: “Mieldejañki ezua sigí kamakue ajúk numakue itushexal agakjuldundana akzexaldiake, ake, axáñ misha e shibañguakue agatsaldaka. Ekí guatshakna jika axaldauxa nuk itushegaka naldashá. ");
INSERT INTO kog_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","”Guatshak mieldeke nas na izhogakí nogatukaki aguldiñkuge naldaldixa. Ekibeñga na, mieldeke kágubakue Najateja kaksanexaldiamak juizhakui nagaunegazhéki, Jatek agajuekui mual atshixa naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","”Akna ekí miñmeyaldikue. Jatejañki kágubakue saldiñga nalda sha ajanashanaldixa kaxabetaka. Ekíga na, káguba azhi Jate aguáñ izhabaji mual nalda axakuakldaldixa jiaga kaxabetakaga. Ne mieldeke Jatetshi Alduna aguáñ izhbashi mual, nalda aguaxaldiák zʉnake, aiki axabetazháldixa. ");
INSERT INTO kog_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Akze, mieldeke nasga Jatetshi Asukuá ixagabaldekldugek jiaga aguáñ nezhbashi mual, nalda naguaxaldiák Jateja axabetaka. Ekí ne, mieldeke Jatetshi Alduna aguáñ izhbashi mual nalda aguaxaldiák zʉnake, aiki Jateja ni kaiga ni auxa zegatshak jiaga axabetazháldixa nzha.” ");
INSERT INTO kog_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Guñgueni ekí jiaga kakbeyá: “Kaldi janshagatsejañki kalwé janshagatse za zheñguxa. Ekibeñga na, kaldi janshagatsaldagáldejañki kalwé nusagatse za zheñguxa. Akze, kaldi zhenéñ zhinik me, ji xalde ne zʉnatuñshixa. Ekibeñga na, mieldeki ajanashéñ me sakí aldé tuminaka. ");
INSERT INTO kog_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Akze, takbiki káguba agisalshi mual za atshamakbé na sha atshiji mizhekue ne jiaga, ¿sakí shi múldigaba janshizhe zukuakbinaka na? Jinak ekí miñmeyakí. Káguba aldunaxa sakí akldeka, sakí itshanka naldaldiake, aiga guana múldigabak zukuaxaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ekí zhinik na, káguba janshizheki aldunaxa janshizhegaba za akldeka naldaldiake, amak janshizhegaba atshiji, múldigabak zukuaka naldaldixa. Ekíga na, káguba shaneki aldunaxa nusagatsegaba za akldeka naldaldiake, amak shanegaba atshiji, zukuaka naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ne nas ekí miñmeyaldikue. Niuwizhíne Najateja káguba kagatsaldi azhi kagatsaldakí ne katualdiéñ niuwañ zegatshak, ajañgua naldakí azakuakldauxa shalda katualdixa. ");
INSERT INTO kog_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Jinake naldakí. Auxa zegatshak, maiñ jai kagik ji múldigaba guakbinaldixa shalda Najateja miñgatsé azhi miñgatsaldakí ne mimatualdixa. Atshaga na ji janshizhe zukuakbineki miñgatsaldazhé mimatualdixa. Akze, ji shane zukuakbine zʉnake miñgatsaldi ne axamindaxaldixa nzha.” ");
INSERT INTO kog_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ekí guagueni anuñka paldiseyukue, guiyaba shizhixakueja Duwe Jesúk ekí agabeyá: —Shi maldazʉñkaldixa, Jateja jai kagik makaxanamak ne maldazʉnatuñshaldiamake, ezua janshizhe ajanashaté tu guañkáaldamak zʉñkatshá guwá. ");
INSERT INTO kog_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Guñguake kakiyó: —Maiñ sha miyatshixakue, Jate za akldé akzamakga akzukui izhoxabínekuek na Saldiñga netshi Jateja kagik nakaxanamak ne mimatuñshaldikuamake, mokue ezua janshizhe ajanashaté tu guabínamak miñkatshakuega minakshishatshak, ezua za mimatuñshaldikue. Eñki Jateja ají múldigaba naldiñga zʉxaitshixa Junás atshishanamaga nuxa mimatuñshaldikue. ");
INSERT INTO kog_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ai nauwibamaki ezua pikáu zʉ́xaitsha atematshi dzhizhaldi maikldiuwi, maikse izhonanamakbeñga, nas Jatetshi Asukuága ixagabaldeklduge nakuaxaldinik, shuanekue abegaldi maikldiuwi me noxaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","”Auxa zegatshak, Jateja saldiñga káguba agatsaldi ne katualdiéñ zegatshak, kuíbuldu Nínibexa zaldakue miñkizhgaldaxaldinik kaiga zhekualdabinukakue Jate guiyaba mimatuñshakue axamindaxaldixa. Jinake naldakí. Ekuejañki nauwibama Junásja Jatetshi múldigaba kakbeyatshakna, sha ajanashixa abajiñga abaja, Jatek axakualdi guananekue nak. Ne maiñ niñkauwañki naldiñki ai nauwibama zhakldé nakzé Najatetshi múldigaba miñmeyaldatshak jiaga, sha miyatshixa majiñga majazháldi, Najatek agakualdi guakí nibiná. ");
INSERT INTO kog_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ekibeñga na, Jateja saldiñga káguba agatsaldi ne katualdiéñ zegatshak, munzhi kagi Sabátshi sáñkalda miñkizhgaldaxaldinik kaiga zhekualdabinukakue Jate guiyaba mimatuñshakue axamindaxaldixa. Jinake naldakí. Nauwibama Saldamóñki muldetua ishkué izhoguák ai munzhiki agubisha maldé zeñka izhogué jiaga, ají múldigaba axaldukal nakldane nak. Ne maiñ niñkauwañki naldiñki ai nauwibama zhakldé nakzé miñkizhoxaldatshak jiaga, naldukasʉ́ñ miñzeka nzha. ");
INSERT INTO kog_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ekí kakbeyatoshiñga na ekí kakbeyá: “Ezua jisétshi alduna kágubak zhinik iyaldeñshatshak, zʉk zaldi káguba isʉ́ñ zaldi neyaldinik, mani izhogaka za niyá nuka. Akzaldakí naldaldiake ");
INSERT INTO kog_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ekí izhikbeyaldixa: ‘Kágubak nagazaxaitshaneñkaga mokue izhoxaldikuamak neyaldikue nzha.’ Gualdini eñka neyatshake, ai káguba ají aldunaxa Jatetshi Alduna izhogazhéga akzaldatshak, aiki juwí abata axautshi izhoxaldixa siyagaxauwane jana nuxa akzaldaldixa. ");
INSERT INTO kog_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ekí tualdiake, jiak aldéñ zhakaldak alduna shanekue kugua niji juizhakualdixa. Gualdiniki ekue na ai kágubak iyajuldunatshakna, eñki axañga agisaldatone guashiñki, zhakaldak agisaldaldixa nzha. Ne kaiga zhekualdabinuka sha miyatshixakuek ekibeñga miñgisaldaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ekí Duweja matshuwi kágubakuek kakbeyatogueñga na, ajaba, aldanikue juizhi aldagueniki, axazakuaxaldiamak jubaldaxa me aldák. ");
INSERT INTO kog_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Guakna ezuaja Duwek ekí akbeyá: —Duwe, mijaba, mizhanikue juizhi mixazakuakldana kakzeshi jubaldaxa akteté nagaldók. ");
INSERT INTO kog_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Guake ekí akiyó: —¿Mekue shi najaba, nakaja giemi jana nekue katualdikue na? ");
INSERT INTO kog_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ekí guaxeniki nasʉñ shi kagitixakue zʉnatuwi ekí guak: —Jejiékue na najaba, nakaja giemikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Jinak ekí katuakí. Mieldekueki Najate jékaldaxa izhukaja kajañguamak axajanashixakue na najaba, nakaja giemi jana nekue katuñkuge nakldá —na guaxá. ");
INSERT INTO kog_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ai ldiuwañga Duwe Jesú juk zhinik neñgueniki niwa xezhaxa yaté. ");
INSERT INTO kog_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Exaga na, káguba agubisha duwá ashenakna aldéñki shi kaxaldiyaldiamak ai niwakga ezua kanuwak iyabegueniki yaldagatshake kágubakueki niwa xezhaxaga ashená. ");
INSERT INTO kog_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Exa zhinik matshuwi jika atshakldegéñ zhinik shi kaxaldijiñga na, zuldak zhinik ekí shi kaxaldiyaldá: “Ezua zʉzikaja zulda tiñgui nixal ne. ");
INSERT INTO kog_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Amak tiñguatshak anuñkaki jiúñguldak akjiená, guane nalgué aiki nubája nagueniki nuk ga. ");
INSERT INTO kog_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Anuñkaki jagénaldi kagigaba zaldazháldi akjienaneki kagik ijiú me axañga munaldá. ");
INSERT INTO kog_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Aiki muldetua shijualda jieñguazháne naldi na, niuwija tuatshake jiyabulduni nuk kaná. ");
INSERT INTO kog_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Jiak, anuñka zuldaki kausú kenaldi akjienane nalgueki kausú nañga munapanatshake kausújañga jutekuá. ");
INSERT INTO kog_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Guatshak anuñka zulda zʉnake kagi janshizeñ akjienane nalguekueki muldetua munatshake, anuñkaki matshuwi nek, anuñka míñgaki akldé matshuuwi nek, azhinik míñgaki gugasá zalda na nexá.” ");
INSERT INTO kog_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gueniki ekí guak: “Ekí miñmeñkugeki saldiñga kuxa miñkaldikueke muldetua nukshi miñgualdí.” ");
INSERT INTO kog_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Guñgueni nasʉñ shi kagitixakuañ kaxaldagueni ekí akldukáñkalde: —Duwe, ¿jinak shi kágubakue jika atshakldegéñ zhinik akldé shi kabaxaldí? ");
INSERT INTO kog_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Guake zʉñmeyá: —Nauwijate jékaldaxa zaldajañki sakí janshagatsaldi miñsanexaldixa janaktunane nalgué jiaga, ni mek mu agisekuazháne. Ne maiñ namak najañguaminekuañ zʉnake mu miñgisekuane. Ekí ne, namak najañguazhékue zʉnake ekíga mu kagisekuazhé. ");
INSERT INTO kog_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Akze, mieldeki ají múldigaba agajienaneki akldeñga agajieñgualdixa. Ekíki matshuuwi agajienane naldaldiamak. Ekí ne, mieldeki agajienaldiamak kama ilshazhéki ji agajiena guane jiaga nuk akjuizhanshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ai zhinik na, najañguazhékue jika azhi káguba atshakldegéñ zhinik za kakbeñkuge. Jinake ekí kakbeyakí. Naldiñki sakí atshikuge natuál za aldogatshak jiaga, jinak ekí atshikuge kagajienazháldixa. Ekíga na, nas guakuge naldukal za aldogatshak jiaga, sakí guashi guakuge kagajienazháldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ekí amak kagajienazhéñ na Jatejañga ají múldigaba naldiñga zʉxaitshixa Isaiyak zhinik káguba zukazhékuek kakbene sezhekldamak zek. Ekí guakldane: “Maiñki nas guakuge nukajiñgaba miñguatshak jiaga, sakí guashi guakuge miñgajienazháldixa. Ekíga, sakí atshikuge natuwiñgaba miñguatshak jiaga, jinak ekí atshikuge miñgajienazháldixa. ");
INSERT INTO kog_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Akze, ai kágubakueki alduna axaldegaksá guanekue. Naldiñki kuxa kaxaldikuega ne jiaga, ji kakbeñkuge naxaldukasʉ́ñ kakzeshi. Ezuaja jika tuazháldiamak uba wis atshamakga, nas ji atshikuge atuasʉ́ñ kakzeka. Ekí ajanashakí naldiñguashíñki, ji atshikuge ubake atuwi na, ji kakbeñkuge kuxake aldukaka, ji kakbeñkuge aldunaxaki kagajienaka. Amak kagajienatshakna sha ajanashane abajiñga abaji, naxakualdinaka. Ekí naxakualdini guashiñki, nasga aldunaxa se kakzukui, sha ajanashane kaxabeti, kekuá guataldakué naldashá.” ");
INSERT INTO kog_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ekí sezheklde guagueniki aldéñ shi kagitixakuañgaba ekí zʉñmeyá: “Maiñ zʉnake nagapa neyabinogatshak, nas atshikuge natuwi, nají múldigaba naldi nukshi miñgajieni neyabinogakna, Najate matshuwi zeñ mimajañguxa. ");
INSERT INTO kog_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Akze, namak miñmeyaldikue. Matshuwi Jatetshi múldigaba naldiñga zʉxaitshixakue, axautshi jian izhukakue na, kauwizhéñ naldi maiñ mituamak tundana kakzegatshak jiaga atuazháne. Ekíga na, maiñ minukajamak aldukandana kakzegatshak jiaga, amak aldukazhá guanane naldashá. ");
INSERT INTO kog_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","”Nas zulda atshakldegéñ zhinik shi miñkaldikuge sakí guashi miñmeyaldikue nukaté nogwíñ. ");
INSERT INTO kog_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Anuñka zulda jiúñguldak akjienaneki ekí guashi. Eñki káguba anuñka nekueki Jateja sakí kaksanexaldixa shalda aldukatshak jiaga kagajienazháldi na, jiséja ai múldigaba aldunaxa kekushi, kakjuizhanshixa. ");
INSERT INTO kog_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Anuñka zulda jagénaldi akjienaneki ekí guashi. Eñki anuñka nekueki Jatetshi múldigaba aldukatshak ubáñ me zʉnake zeñ kakldeshi iyapanka. ");
INSERT INTO kog_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ekí iyapananaldixa jiaga, zuldaja shijualda kagik jieñguazhámakbe aldunaxa muldetua kagajienazhá guanaldixa na, anuñka me nuxa namak ajañguatoxaldiéñ, mitsake ai namak ajañguane shalda sha kakuí, jibañ atuapanatshake namak ajañguaksá guxakue. ");
INSERT INTO kog_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Anuñka zuldaki kausú kenaldi akjienaneki ekí guashi. Eñki anuñka nekuejañki Jatetshi múldigaba aldukatshak namak ajañgualdinik jai kagik izhoxa ji kagajueshká za iyajani, naldagálde nuxa ‘kabia nexaldatshake auxabé nakzeshi izhoxaldikue shakldá’ iyajani. Ekí zhinik na, kausúja zulda jutekuamakga Jatetshi múldigaba kakjuizhanshi na, aldéñ janshizhe izhogakue kajañguamak izhogazhékue. ");
INSERT INTO kog_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","”Naldatshak jiak, anuñka zuldaki kagi janshizeñka akjienaneki ekí guashi. Anuñka nekueja zʉnake Jatetshi múldigaba aldukatshak, muldetua kagajieni na amak axajanashixakue. Ekí ashekualdatshakna, anuñka zuldaki matshuwi nek, anuñka míñgaki akldé matshuuwi nek, azhinik míñgaki gugasá zalda nekldamakbé Jate akldunamak ashekualdaldixa guashi na zulda shalda ekí miñmeñkú” na zʉñmeyá. ");
INSERT INTO kog_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Guñgueniki Duwe Jesúja ezua ajanashakldegéñ zhinik ekí shi kaxaldiyaldá: “Najate jékaldaxa izhukaja káguba kaksanekakueki ji jana naldaka miñmeyaldikue: Aiki ezua te shjáugukuija zulda janshizhegaba ají tezhi ishkizhixá. ");
INSERT INTO kog_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Guane nalgué sesʉñ saldi axabá aldalgueñki, ai sigí aguldiñkaja nagueniki aldó kenañ kaldá shane zulda axakldigueniki mokue ne. ");
INSERT INTO kog_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Guñguenik aldó jiu, jiu munaldinik gata agatsaldaldiamak agatsegapanatshake, kaldá shane jiaga tundana agatsé nek. ");
INSERT INTO kog_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","”Ekí atuatshakna nashikueja tetshi ajáugukuik ekí agabeyal aldé: ‘Duwe, zulda janshizhe nixamalde ne, kaldá zulda shaneki ¿meja shi akldigú?’ ");
INSERT INTO kog_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Guñguake kakiyó: ‘Ezua kaguldiñka ekí zʉñkatshane nakldá.’ Guake ají nashikueja aklduká: ‘Ake, ¿kaldá shaneki nuk akldugate guakue shi maldazʉnajañgú?’ ");
INSERT INTO kog_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Guake kakiyó: ‘Ekí atshabináldi. Akbiñgaki, kaldá shane miyakldugatshake aldó juizhiñga aklduminaka nak. ");
INSERT INTO kog_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Akna mozhuañga shi negatoshí. Gualdinik auxa negatshake, nají nashi gakue guxaldixakuek ekí atshakue kakbeyaldikue: Kaldá shane misha miyaklduxaldiniki puldaldiamak, muldetua egaba shiba, shiba miñgualdí. Ekí miñgualdinik na aldóki minagakuxaldinik, nají gakue jubeniñgaba minakibexaldí.’” ");
INSERT INTO kog_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Guñguenik Duweja mokue ezua atshakldegéñ zhinik ekí shi kaxaldiyaldá: “Jate jékaldaxa izhukaja káguba kaksanekakueki, ji jana izhalteka miñmeyaldikue: Aiki ezua zulda sigíja ají tek nixane. ");
INSERT INTO kog_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ai zulda sanaki saldiñga zuldakue guashiñki zhaguáñ agatsé nuxa naldaldinik, jiak guildegatshake saldiñga kaldi aldishi guane iskaitañga guildegatshake, gulda matshuwi axabunatshigake exa nubákue iyaldakakue naldashá.” ");
INSERT INTO kog_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Guñguenik Duweja jiak mokue ezua atshakldegéñ zhinik shi kaxaldiyaldá: “Jate jékaldaxa izhukaja káguba kaksanekakueki ji jana saldiñgak axajiuwaka aldé miñmeyaldikue: Aikueki naku jana nekue. Nakuki ezua munzhija gakuek nauwañgaba itsheñguanaldixa zhikbegatshak nuk agaldaka naldashá,” ekí na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Guatshak Duwe Jesúja káguba duwá zhekualdekuek shi kaxaldiyatogatshak jika azhi káguba atshakldegéñ za na shi kaxaldiyatoxá. Akze, jika atshakldegéñ naldakíki shi kaxaldiyakí na naldá. ");
INSERT INTO kog_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ekí shizhiyatogatshake mauzeñga Jateja ají múldigaba naldiñga zʉxaitshixak Asukuáki sakí agatsaldi shizhiyaldixa guakshanamak zek. Ekí guakldane: “Nasga na kágubakue kaxazguaxaldatshak, jika atshakldegéñ zhinik za kaxazguaxaldikue. Akze, kagi gauñgukuenik zhinik ji muetsekuagá nokuge, ekí agatsaldi shi kaxaldiji za mu kagisekualdikue nzha.” ");
INSERT INTO kog_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Guñgueni Duwe Jesúja káguba duwá zhekualguekue “neyabiñkuká ni gu” kakbeñgueniki juldi juldú. Guñguakna nasʉñ shi kagitixakuañ kaxaldagueni ekí akldukáñkalde: —Duwe, ¿sakí guashi shi gakue kenañ kaldá shane munakak zhinik ekí makuaxá? ");
INSERT INTO kog_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Guake ekí zʉñkiyó: —Zulda janshizhe nika jana neki, nas Jatetshi Asukuága ixagabaldeklduge. ");
INSERT INTO kog_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ají te azaldigaldi jana neki, jejié kagi. Zulda janshizhe jana neki, Najateja aksanekakue. Ne kaldá zulda shane jana neki, jiséja aksanekakue. ");
INSERT INTO kog_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tetshi ajáugukui aguldiñka zulda shane nixane jana neki jisé. Aldó gugakuká guane jana neki jai kagik auxa zexaldixa ldiuwañ. Aldó gukakue jana neki Jateja guaklde uldeñkakue. ");
INSERT INTO kog_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","”Nashikueja kaldá shane agalduxaldini ayogamak jana neki auxa zegatshak Jateja káguba kagatsaldi ne katuakue niuwañ ekí zexaldixa: ");
INSERT INTO kog_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nas Jatetshi Asukuága ixagabaldekldugek guaklduge uldeñkakue kagik kakaxaldikue. Ekueja na, Najatek akldunazhámak ajanashixakue, axautshi sha atshishixakueki aldéñ namak giemi kaksanekakue kenañ zhinik nuk kagajuekualdixa. ");
INSERT INTO kog_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Gualdinik axajuekuanekueki guksé sanazhéñka kakuateyaldixa. Exa na, zʉ́xaita zalda guiyaba atuwi, kakzeshi abauwá za aldoxaldixa. ");
INSERT INTO kog_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ekí ne, jian izhukakue zʉnake Saldiñga netshi Jate, Kauwijatega saneshi izhogeñka aldéñ akldé kakzukui na, niuwi zʉ́xaita zalda muñshí zʉtuamak kazʉtuñshaldixa. Akna, saldiñga ai nukaminekuañ kuxa miñkaldikueke muldetua nukshi miñgualdí. ");
INSERT INTO kog_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Guñgueniki jiak mokue ekí shi zʉñkaldiyaldá: “Najate miñsanekáki ji zʉ́xaita zalda akzé jana ne miñmeyaldikue. Aiki, ezua niuba zʉ́xaita zalda akzé ezua tek kue. Ekí kualgué ezua sigíja akzá guñguake, axautshija akzaldazháldiamak muldetua mexá. Gueniki zeñ akldeshi, ai za akzé jañgui na, ai te axaldaldaldiamak saldiñga jika axaldalguauxaki nuk nabesañgueniñki ai te niñkauwañki izhgajabí. ");
INSERT INTO kog_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","”Ekibeñga na, Najate miñsanekáki ekí jiaga zʉxaita zalda akzé jana ne: Aiki ezua numa nabesaxaja níkuiti za niyá none. ");
INSERT INTO kog_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ekí niyatogueñki, ezua níkuiti zʉ́xaita zalda akzega akzá. Guñguakna ai za akzé jañgui na, axaldaldaldiamak saldiñga jika axaldalguauxaki nuk nabesañgueniñki ai niñkauwañki izhgajabí na gua.” ");
INSERT INTO kog_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Guñgueniki jiak mokue ekí shi zʉñkaldiyaldá: “Najateja aldéñ aksanekakueki, aksanegagáldekuek ji jana kagajuekualdixa miñmeyaldikue: Aiki ezua zhemá níbunik akuateyaldinik, jiak eni zhinik iyabekshatshake saldiñga nalda pikáu akué iyabekshixa. ");
INSERT INTO kog_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Amak dañ akué iyabekshaldinik pikáu gukakueja axezhaxa awaldeyatshak yaté xaldek muldetua pikáugaba agaldiji axajuekuapanka. Pikáu gakuegabaki nuldik akuashiji, akuashiji akuxa. Ne gasékueki egaba awateya, awateya akuxa. ");
INSERT INTO kog_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pikáu akldiji, axajuekuamakga na, auxa zegatshak Najateja káguba kagatsaldi ne katuakue niuwañ ekí kakualdixa. Atshakna aldéñ guaklde uldeñkakue kagik aldaxaldinik aldéñ akldunazhámak kutám za ajanashixakueki aldéñ akldunamak jian ajanashixak nuk kagajuekualdinik ");
INSERT INTO kog_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","guksé sanazhéñka kakuateyaldixa. Exaki zʉ́xaita zalda kakzeshi, abauwal za ashekualdategeñka nzha.” ");
INSERT INTO kog_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ekí shi zʉñkaldiyatoshi na, ekí zʉñnuká: —Ekí shi miñkaldikugekue ¿sakí guashi guakuge muldetua miñgajiená shi gu? Guake akiyoñkalde: —Akze, zʉñgajiená na gu. ");
INSERT INTO kog_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Guñguakna jiak, mokue ekí shi zʉñkaldiyaldá: —Saldiñga maiñ Najatetshi múldigaba sezhekldane miñkué shizhiyaminakakuañ, sakí aldéñ miñsanexaldixa jiaga miñgajienkákueki ji jana miné miñmeyaldikue. Aiki ezua sigíja ají numa akzekuegaba mexaneñka zhinik ají numa akzé axañga zalda uldagaka, jiak eni zhinikga na, aldiwan zalda jiaga uldagaka. ");
INSERT INTO kog_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ekí ajanashakldegéñ zhinik auxa shi zʉñkaldiyatogueniki exa zhinik neñgueni ");
INSERT INTO kog_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","kuíbuldu aldéñ guildekldeñka neyatshak, juwí izhajuizhaldegeñka shizhiyaldá. Ekí shizhiyatshakna aldukatoguekuejañki “¡sakí ekí janshagatsaldi shi zʉñkaldixá!” ajañgui na ekí izhgaldukaldá: —Eñki ¿meja ekí ishkué nalda shaxaldiyatogué? ¿Sakí ekí ajanashaté tu guañkáaldamak jiaga atshixa ne? ");
INSERT INTO kog_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Eñki kalgauxa tsukua nuxa naldazhé shi na? ¿Ajabaki Maldiya naldazhé shi na? ¿Eñki Santiaku, Jusé, Simóñ, Judá, ekuetshi atuwé nuxa naldazhé shi na? ");
INSERT INTO kog_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ajasʉkueki jai nauwikenáñga izhogakí shi na? ¿Guake miya zhinik shi ekí agatsaldi shizhiji, atshaka na? ");
INSERT INTO kog_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ekí axajani na, ji kakbeñká axaldukazháldi, iyapanazhá. Guakna Duweja: —Akze, ezua Jatetshi múldigaba naldiñga zʉxaitshixaga mashi neyatshak akzé jañgui axabeti, iyapanka. Ne akuíbulduk zaldakue, ajúk zaldakueja niñkauwañki axabetazháldi, akzé ajañguazhé nakldá —na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Guatshak exa zaldakuejañki namak axajanazháldi, iyapanazhá guakna, janshagatse ajanashaté atú guazhámak matshuwiñgaki kaxatshazhá na gua. ");
INSERT INTO kog_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Atshaga na, sáñkalda Eldodejañki Duwe Jesú atshatoguauxa shalda akuagaté nukatshakna ");
INSERT INTO kog_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","agaunekakuek ekí kakbeyá: “Eñki Juañ nik majaukshakuega shuane mokue izhgatene naldaka. Akna janshizhe ajanashaté atú guazhámak jiaga atshaka kama axaldé nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Akbiñgaki axañga sáñkalda Eldodejañki akaja giemi Pildipitshi asewá nane Eldodia izhgakuxane nalgué shalda Juañjañki “Jatetshi guiyabajañki mikaja iteñga nogeñgaki asewá guxa guasʉ́ñze guaka ni matú” axaldék. Ekí axaldegué shalda na, sáñkaldaja nusá akzeshi Juañ guxal guagueni kalseldi shezhasha iyatenega megakue guak. ");
INSERT INTO kog_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Aldéñki Juañ guaxa gundana akzegatshak jiaga, kágubakuejañki “eñki Jatetshi múldigaba naldiñga zʉxaitshixa shakldá” ajañguxa akualguakna guagexañ zheñga akzék. ");
INSERT INTO kog_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Guane nalgué, sáñkalda kagi itseklde noguéñ anuñka apebukue abuzatiakue kakbeyá. Amak axaldagatshake, asewá Eldodiatshi abunzhiki kuizatshakna sáñkalda zeñ akzukuá. ");
INSERT INTO kog_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Guñguakna, “jigaba maldakshishaldiake amak migexaldikue nzha” axagilté. ");
INSERT INTO kog_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ekí axakildagatshakna ajabaja aksaneguamak ekí akshishá: “Ake, Juañ nik majaukshakue tsáñkalda jika bakaldak iyatenega jai nakuldák guwá.” ");
INSERT INTO kog_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ekí akshishatshak sáñkaldaki itshanatshak jiaga, abuzál nakldekueja aldukaté, gaiyak ji akshishatshak amak agexaldixa axagiltene nalguakna, amak atshakue niuwi ge. ");
INSERT INTO kog_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Guakna kalseldiñga Juañ sáñkalda ibeñguakue guak. ");
INSERT INTO kog_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Amak iyabeñguñgueniki Juañtshi sáñkaldaki jika bakaldak iyatenega amak gaiyak akualdaguake aldéñ zhiniki ajabak akuldé agé. ");
INSERT INTO kog_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Guñgueni Juañ shaxaldixakueja ají abuá akugueniki shuanekue abegaldi abexá. Ekí abegueniki Duwe Jesúk agabeyal aldé na akuá. ");
INSERT INTO kog_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ekí Juañ akuaxane nukañguakna, Duweki nasʉñ shi kagitixakuañ na nauwihezuañgaba sʉnjá zaldi kanuwak ne. Guatshak jiaga, Duwe nene aldukañguakna, matshuuwi kágubakueja kauwikuíbulduldi zhinik kagixa ga axapa aldé. ");
INSERT INTO kog_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Gueni Duwe eñka akbategatshake, káguba duwá ajuizhaldekldekue katuatshakna guañ kajañgui na, aikuega mulbatá akzekakueki se kakzukuá. ");
INSERT INTO kog_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gueni niuwi yaldaxaldá guapanguakna nasʉñ shi kagitixakuañki kaxaldaxeni ekí akbeñkalde: —Au niuwi yaldaxaldá guapanashá. Ne jaiki káguba izhogazháldi, ni ji jiaga naldakí nakna kágubakuek “au neyabiñkuká na gu” kakbeyá guwá. Ekíki kuíbuldukueni gakue ishkajabiji aldeyapanaldiamak. ");
INSERT INTO kog_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ekí kakbeyatshakna ekí zʉñkiyó: —Gakue ishkajabiyal neyakue kagatsaldakí nakldá. Ne maiñga gakue miyakauwaldí. ");
INSERT INTO kog_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Guake ekí akiyoñkalde: —Jaiki jatshiwa pañ, mozhua pikáu me nuxa ni zʉñkaldá. ");
INSERT INTO kog_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Guake ekí zʉñkaldék: —Ake, ai nakuldák guwíñ. ");
INSERT INTO kog_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Guñgueni Duweja káguba nakldekue kaldá kaldeldi “jeñ yaté shi akuí.” Ekí guagueniki jatshiwa pañ, mozhua pikáu nalgué zhiksuigueniki mateldi stuaté noshi, Jatek ai shalda “zeñ nzhakldék” akbeyá. Ekí akbeñguenik pañ, pikáu zhikwatiyatshak matshuwi zhikldekshi shi kagitixakuañ kágubakuek kakauwakualdiamak zʉñgeguake, amak kakauwatshakna ");
INSERT INTO kog_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","saldiñgaja gaji yau kakzék. Ekí asatshak jiaga, gakue abanegaba 12 nuldi jialda na kakuashá. ");
INSERT INTO kog_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Atshaga na káguba matshuuwi nekue amak asatshak munzhi, sukuakue izata naldakí, sigíkuegaba iyazatatshak anuñka 5.000 naldashi ashekualdi na asajá. ");
INSERT INTO kog_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ekí Duweja kágubakue kakauñgueniki “mimijuldi neyabiñkuká ni gu” kakbeyatoguéñ nasʉñ shi kagitixakuañki kanuwak julduni, aksajañga ataba niñkauwa akbategakue zʉñmeyá. ");
INSERT INTO kog_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aldéñki amak kágubakue nuk kakagueniki, ahezua gaxa akshá zeñka Ajate axazguaxal nitshí. Guñgueni ahezua axazguashiñga, tuañ zegapanatshake, ");
INSERT INTO kog_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","nasʉñki kanuwak niwa mitakuaxa maldé zeñka neyaté na kaldoxá. Ekí neyañkaldogatshake, neyakualdialdi zhinik múlkalda kamakualdi niwa izhgaldakshatshak, atemajañ ni zʉñkabushiñgaba. ");
INSERT INTO kog_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ekí nejiñga na, au muñzeshi zegapanatshake Duwe gagaxa zhinik zabiñgueni niwa bakaldak ga kasam zʉñkaldaxaldá. ");
INSERT INTO kog_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Amak niwa bakaldak ga kasam zʉñkaldagaté katuatshakna, she she she zʉnetsheñshiñga: —Eñki alduna nuxa zʉñkizhañkatiuwi —guashi jaldáñ kauldañkalde. ");
INSERT INTO kog_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Guakna ubañga Duweja ekí zʉñkaldék: —¡Señgaba miñzegwíñ! Nasga na nakú. ¡Zhe miñzegagába! ");
INSERT INTO kog_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ekí nukajakna Péguldujañki ekí axaldék: —Duwe, ake, ma maldahamak nake, nas jiaga niwa bakaldak ga kasam mixaldeyaldikuamak niuwi nagé guwá. ");
INSERT INTO kog_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Guake Duweja: —Ake, nak guwá. Ekí akbeñguake Péguldu amak kanuwak zhinik akjiengueniki, niwa bakaldak ga Duwe nugeñka kasam neyaldá. ");
INSERT INTO kog_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amak neyatogueñki, múlkaldaja kamakualdi ni izhgaldakshixá za tuapanatshake, jiak, zhe akzeshi na tuasánapanatshak: —Nají Sáñkalda, nagaunek guwá —jaldáñ ixauldá. ");
INSERT INTO kog_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Amak axaldegatshaga na, Duweja káuxalda ageshi akldé tuasanazháldiamak akpani na ekí axaldék: —¿Jinak shi auxaga alduna nazishazhá makú? ¿Jinak shi amak mixatshaldikue azhi amak mixatshazháldikue mikldék? ");
INSERT INTO kog_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Gueniki kanuwaxa ajuldunatshake, múlkaldaki neyaksáni, muldetuañga ne na zexá. ");
INSERT INTO kog_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ekí katuatshakna kanuwaxaga kizhoxekueki Duwe Jesú akldé akzamakga akzukui na: —Mañki namak giemi Saldiñga netshi Jatetshi Asukuá ni maldá —axaldekalde. ");
INSERT INTO kog_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ekí niwak atabañ niñkauwa Jenesaldé baxe akbatekalde. ");
INSERT INTO kog_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Amak kakbategatshakna, exa zaldakueja Duwe Jesúki kaxaldene kakldegatshakna saldiñga eñgui baxe nahauxa “Duwe Jesú jai ni izhók” akuashi, dulda azaxaitshá. Ekí kágubakueja aldukañguakna saldiñga mulbatá kaxakzekakue akualdák. ");
INSERT INTO kog_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Amak akualdashi na, “mulbatá zʉñkakzekakue mijí zhakuá sʉxa nuxaki ajuguaka majañgualdí” na axakuañnexá. Amak kajañguake, saldiñgaja egaba ají zhakuá ajuguatshake saldi se kakzék na gua. ");
INSERT INTO kog_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Guñgueni anuñka paldiseyukue, guiyaba shizhixakue na Jeldusaldéñ zhinik nakldekueja Duwe Jesúk axaldagueni ekí agalduká: ");
INSERT INTO kog_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Shi migitixakueki ¿jinak shi nauwibamakueja sakí atshakue zʉñgatsé guakldanamak ajanashakí na? Jinake ekí mikbeyakí. Kauwizhéñki nauwibamakueja zagáñga sakí agatsaldi káuxalda itshizha xalde zakue guaka ne amak itshizhagába, asaxa nak. ");
INSERT INTO kog_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Guake Duweja ekí kakiyó: —¿Jinak shi maiñki mimisanákueja sakí atshakue shizhaldiyanamak miyatshaldiamak nuxa, Saldiñga netshi Jateja sakí atshakue niuwi zʉñgene niñkauwañki amak atshakí miná? ");
INSERT INTO kog_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jinak ekí miñmeyakí. Jateja ekí atshakue guaka: “Mijate, mijaba akzé jañgui, kaxabetakue. Mieldejañki ajate, ajaba aguldiji, nusa agatsaldi sha axaldexaldiake shuigakue agatsaldaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ekí guiyaba zʉñkabajane ne, maiñ zʉnake kágubakuek ajaba, ajate kaxabetazháldi, janshibeñga ekí axaldegaka shi miyaxaldixa: “Nas migaunekldaka naxaldé ne nuk Jatekgaba agexaldikue janaktú guanuge nakna, migaunegazhánaka ni atuñkú.” ");
INSERT INTO kog_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Akna mieldeki ekí atshaldixa nexaldiake, maiñ ajatekue axabeti agaunegakue kaksanexabíne. Ekí mimisanákueja atshakue shi miñkaldiyanamak atshiji na, Saldiñga netshi Jateja ají múldigabak sakí atshakue guaká niñkauwañki akzukuabiñsáni atshashibiná. ");
INSERT INTO kog_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Maiñki Jatek amak miyatshixa ga abeldashi mizhekue nakna, Jatetshi múldigaba naldiñga zʉxaitshixa Isaiyaja sakí miyatshaldixa guashi gauwanamak miyatshixa: ");
INSERT INTO kog_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Jejié kágubakueki múldigabak nuxa naxabetixakue ga naxazakuakakue. Naldatshak aldunaldi zʉnake najañguazháldi, nagajué za izhukakue. ");
INSERT INTO kog_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Akna axesé nuxa akldé nakzamakga nagazukuxakue. Jinake naldakí. Nas kakbeñkugamak shizhiyagábaki, kágubaja atshakue janaktune niñkauwañki shizhaldixa nak.” ");
INSERT INTO kog_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gueniki Duweja káguba duwá zhikzhe zhekualdekue axaldagakue kakbeyeni ekí kakbeyá: —Ji miñmeyaldikue muldetua izhgajieñgui, nukaté nogwíñ. ");
INSERT INTO kog_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jateja tuwiñki, kágubaja jigabá kaxak ishkáu gajéñ zhinik nuxa akzaldakuazháka tuñka. Akze, kaxak zhinikga jiak, ji múldigaba nusagatsaldi guagéñ zhinik guana zhikzaldakuxa tuñka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ekí guaguake, nasʉñ shi kagitixakuañ Duwe kaxaldagueni ekí akbeñkalde: —Duwe, ekí makuagatshake paldiseyukueki kauwizhéñ kaxaldeshi makuxá kakldegashá. ");
INSERT INTO kog_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Guake ekue shalda ekí zʉñmeyá: —Ezua tetshi ajáugukuija aldéñ nigazháneki shijualda nañga muldetua aklduxaldinik uteyamakbeñga na, Najate jékaldaxa izhukaja ají naldagáldekue, ají giemikue kenañ zhinik kagajuekualdixa. ");
INSERT INTO kog_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Akna paldiseyukue katuagába. Kauwizhéñki ekí jana nekue: Aiki ezua uba iséja ajanameñga uba isé jiúñguldak uldeyazháka. Azhi amak uldenake mozhuañga nusa zeñ kapenaka naldashá. ");
INSERT INTO kog_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Guake Péguldujañki ekí Duwek aklduká: —¿Sakí guashi shi gakue me zʉñzaldakuazháka zʉñmeji ekí makuák? ");
INSERT INTO kog_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Guake zʉñkiyó: —¿Sakí shi maiñ jiaga miñgajienakíñga ne minakbé? ");
INSERT INTO kog_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Azhi, ¿sakí shi miñgajienakí na? Saldiñga kaxak ishkáu miñgaldinik dzhizhaldi migatanaldinik ganukshaja egaba zʉxaitshixa naldashá. ");
INSERT INTO kog_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ekí ne, kaxak múldigaba akzʉxaitixaki aldunaxa zhinik akzʉxaitashá. Akna ji múldigaba nusagatsaldi guagéñ zhinik guana zhikzaldakuxa ne Jatejañki tuñka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Jinake ekí miñmeyakí. Kágubaja aldunaxa zhinik guana saldiñga sha atshaldixa janaktuatuka. Exa na, nusagatse jañgui, axautshi guaxa atshaldixa, asewá naldagálde na askuildexaldixa, abuá na atsha guasʉ́ñzamak ajanashaldixa janaktuatuka. Exaga na, tushexaldixa, naldagálde zukuaxaldixa, axautshi nalda aguaxaldixa janaktuatuka. ");
INSERT INTO kog_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Saldiñga ekí nusagatse atshá guana, Jateja tuwiñki, káguba akzaldakuxa tuñka. Ekí ne, nauwibamakueja káuxalda sakí agatsaldi itshizhakue akuagamak itshizhagába, egaba gakue ga atshéñ zhinik nuxa káguba akzaldakuxa Jatejañki tuazhé nakldá. ");
INSERT INTO kog_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ekí zʉñmeñgueni Duwe Jesú exa zhinik neñgueniki Tildu, Sidóñ baxe ne. ");
INSERT INTO kog_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Exaki ezua munzhi nauwisaná juldiú naldagálde Kanáñ zaldaga na Duwe Jesú axaldagueni, ekí jaldáñ ixauldá: —Nají Sáñkalda, mañki sáñkalda Dabítshi atukuaga maldé, guañ maldajañgualdí. Nabunzhi jisétshi aldunaja ijuldune guiyaba tuñshiñgaba ni gu. ");
INSERT INTO kog_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ekí agakuañnegatshak jiaga, Duweja ni nauwa akiyokuazhá. Ekí katuakna nasʉñ shi kagitixakuek axaldashi ekí agakuañnekalde: —Jalde munzhiki mixauldi zʉñgapa nagatogák, “newa” akbeyakue ni kabajañgú. ");
INSERT INTO kog_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Guake ekí guak: —Najatejañki nasaná Isayélkue za na kagaunexal nakaxane. Aikueki jubeju numañ tuñkak agitshuani axajuezhamak Jatek axajuezhanekue. ");
INSERT INTO kog_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ekí guagatshak jiaga, ai munzhiki Duwe axaldagueni, nuldu axayoshi ekí agakuañnék: —Nají Sáñkalda, nagaunekga makualdí. ");
INSERT INTO kog_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Guake Duweja ekí akiyó: —Sukuaja gakue gatuka ikuxa xaldeki piyuk aguteya atshasé naldaka naldashá. ");
INSERT INTO kog_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ekí akbeyatshakna munzhijañki ekí akiyó: —Nají Sáñkalda, namak ni makuák. Naldatshak piyu jiaga ajáugukuija gakue gatuka agakjienane meñki ga guxaga naldashá. ");
INSERT INTO kog_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Guake Duweja ekí akiyó: —Nabunzhi, mañki ¡mitsá alduna maldazishixá! Ekí alduna nazishiji nakshishamaldamak shi migatseshí. Ekí akbeyatshaga na, abunzhiki jisétshi alduna izheñshi, se akzukuá na gua. ");
INSERT INTO kog_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Duwe Jesú exa zhinik neñgueniki mokue niwa Galdildeyaxa neyatshak axezhaldi mizhiji, gaxa akshá zeñka nitshigueniki exa yaté. ");
INSERT INTO kog_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Exaki káguba duwá zhikzhe axaldagatshak se akzegagáldekue jiaga akualdák. Aikueki muldetua neyagáldekue, kalda axazauwagáldekue, uba isékue, zukuagagáldekue, mulbatá sha sha akzekakue juizhi Duwe stak matshuwi akualdaxake, nuk se kakzukuá. ");
INSERT INTO kog_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ekí se kakzukuatshakna, zukuagagálde nanekue zukuaxaldá, kalda axazauwagálde nanekue janshi kakzék, muldetua neyagálde nanekue neyaldá, uba isé nanekue stualdá. Ekí atuatshakna kágubakueja “¡sakí ekí Duweja se kakzukuxá!” kakldeshi na, Saldiñga netshi Jate, nauwisaná juldiútshi Ajatega za akaldak akzamakga na agazukuá. ");
INSERT INTO kog_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ekí káguba duwá zhekualgueñga na, Duweja nasʉñ shi kagitixakuañgaba zʉnajuizhakui ekí zʉñmeyá: —Kágubakue au maikldiuwi naldukshi naxapa aldogatshake, ji gakue kaxaldaldakí nakna guañ kajañgundana nzhakzék. Ekí maldija kakuiñga kauwijuldi kakashi guanugake, jiúñguldak me se kaktanaka nak, ji axagáldekuega kakagasʉ́ñ nzhakzék. ");
INSERT INTO kog_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ekí zʉñmeyatshakna ekí akbeyáñkalde: —Jai káguba izhogazhéñ ne ¿miya zhinik shi káguba anuñka zhekue kakáu guashi gakue niyakualdixa na? ");
INSERT INTO kog_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Guake Duweja zʉñnuká: —Ne, ¿mitsá me shi jika miñgaldixa miñkaldá? Guake akiyoñkalde: —Kugua pañ, pikáu abuldukue anuñka agatsalda na nuxa ni zʉñkaldá. ");
INSERT INTO kog_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ekí kakbeñguake Duweja káguba duwá zhikzhe nakldekue “jeñ yaté shi akuí.” ");
INSERT INTO kog_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Guagueniki Duweja pañ kugua, pikáu abuldu na zhiksuigueniki Jatek ai shalda “zeñ nzhakldék” akbeyá. Ekí akbeñguenik pañ, pikáu na zhikwatiyatshak matshuwi zhikldekshi nasʉñ shi kagitixakuañ kágubakuek kakauwakualdiamak zʉñgeguake amak kakauwatshakna, ");
INSERT INTO kog_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","saldiñgaja gaji yau kakzék. Ekí asatshak jiaga, abanegaba kugua nuldi jialda kuashañkalde. ");
INSERT INTO kog_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Atshaga na, káguba matshuwi nekue amak asatshak aikueki munzhi, sukuakue izata naldakí, sigíkuegaba iyazatatshak 4.000 ashekualdi na asajá. ");
INSERT INTO kog_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ekí kakauñgueniki Duweja “mimijuldi neyabiñkuká ni gu” kakbeñgueniki kanuwaxa kajuldungueni niwak akbateshi Magaldáñ baxe ne na kakuá. ");
INSERT INTO kog_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Guatshak paldiseyukue, saduseyukue na Duwe Jesú atuál aldeyatshak akuajaldiamak kakldeshi ekí axaldék: —Mañki Jate jékaldaxa izhuka naldi jai kagik makaxanamak ne maldazʉnatuñshaldiamake, ezua janshizhe ajanashaté tu guañkáaldamak zʉñkatshá makualdí. ");
INSERT INTO kog_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Guake Duwejañki ekí nuxa kakiyó: —Shañgabá zegapanatshak niuwi aktabé gualdiake, “niuwizhíñki niuwi stualdixa tiuwi” miñguaka. ");
INSERT INTO kog_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ekíga na, muñshak niuwi aktabé guatshak jiak, mauwigá zexaldiake “níxalda zek guaka tiuwi” miñguaka naldashá. Akze, maiñki alnobaxa, mauwik me níxalda zexaldixa azhi niuwi stualdixaki tuminaka. Naldatshak, kaiga ldiuwañ nas atshaté, shizhiyaté minatuatshak jiaga, Najateja ji mimatuñshindana akzeka ¿sakí shi tuakí miné jana miñgajienakí na? ");
INSERT INTO kog_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Akze, maiñ sha miyatshixakue, Jate za akldé akzamakga akzukui izhoxabínekuek na Saldiñga netshi Jateja kagik nakaxanamak ne mimatuñshaldikuamake, mokue ezua janshizhe ajanashaté tu guabínamak miñkatshakuega minakshishatshak, ezua za mimatuñshaldikue. Eñki Najateja nauwibama Junás atshishanamaga nuxa mimatuñshaldikue nakldá —kakbeñguenik exa zhinik ne na gua. ");
INSERT INTO kog_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Duwe Jesú nasʉñ shi kagitixakuañ nañga niwa ataba niñkauwa kakbateguenik katuatshake pañ gakualdixa zʉñjuizhá guane tu. ");
INSERT INTO kog_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Gueni Duweja ekí zʉñmeyá: —Maiñ paldiseyukuetshi, saduseyukuetshi pañ ishkishshixak be axaldoshi, muldetua numañ miyatualdí. ");
INSERT INTO kog_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ekí zʉñmeyatshak, ataba atabañ zhinik ekí zhikbeñkalde: —¿Pañ uldagazhá guáñkalde nak ekí zʉñmeyakí shi na? ");
INSERT INTO kog_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Guatshake Duwejañki sakí zhikbeyañkalduka akualdi na ekí zʉñkaldék: —¿Jinak shi pañ ishkishshixa miñmeyaldatshake, maiñ pañ uldagazhámine shalda mizhikbé? ¿Jinak shi auxaga alduna nazishakí miná? ");
INSERT INTO kog_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Kaiga jiaga me naugé, sakí atshanaka miñgajienakíñga shi na? ¿Mitsáte shi jatshiwa pañ matshuwi zhikldekshanuge káguba matshuuwi 5.000 nekue asatshak jiaga, abanegaba mitsá nuldi jialda kuashamine be miñgisegakí na? ");
INSERT INTO kog_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ekíga na, ¿mitsáte shi kugua pañ matshuwi zhikldekshanuge káguba matshuuwi 4.000 nekue asatshak jiaga, abanegaba mitsá nuldi jialda kuashamine shi na? ");
INSERT INTO kog_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ne ¿sakí shi pañ shalda miñmeyakí nokugé jiaga miñgajienazhá gua? Akna mokue ekíga miñmeyaldikue: Be noshi, paldiseyukue, saduseyukueja pañ ishkishshixa axajiuxa miñkajiuwi guakuak numañ miyatualdí. ");
INSERT INTO kog_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ekí mokue zʉñmeyatshakna sakí zʉñmeyatuka zʉñnék. Aldéñki pañ ishkishshixak be axaldogakue zʉñmeyatshake pañ shalda zʉñmeyagábaki, paldiseyukue, saduseyukue sakí agatsaldi shizhaldixak zʉnake be axaldoshi, numañ atuakue zʉñgatsé na zʉñmeyá. ");
INSERT INTO kog_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Guñgueniki kuíbuldu Sesaldeya, Pildipu baxe kaldeyatshak, Duweja nasʉñ shi kagitixakuañ ekí zʉñnuká: —¿Kágubakueja nas Jatetshi Asukuága ixagabaldeklduge me naugé shi nakuák? ");
INSERT INTO kog_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Zʉñnukañguake ekí akiyoñkalde: —Duwe, mañki anuñkakuejañki Juañ nik majaukshakuega maldé, ezuakuejañki Jatetshi múldigaba naldiñga zʉxaitshixa Eldiyaga maldé, ezuakuejañki Jatetshi múldigaba naldiñga zʉxaitshixa Jeldemiyaga maldé, ezuakuejañki Jatetshi múldigaba naldiñga zʉxaitshixa axautshi maldé na makuák. ");
INSERT INTO kog_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Guñguake: —Akze, maiñki ¿me naugé shi minajañgú? ");
INSERT INTO kog_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Guñguake Simóñ Péguldujañki akiyó: —Duwe, mañki Saldiñga netshi Jate aldéñgaba izhoshiñga izhukatshi Asukuá giemi na maldá. Aldéñga ezua zʉnekualdal zʉñgakaxaldixa guakldane ne, aiga maldé nakldá. ");
INSERT INTO kog_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ekí akiyokuakna ekí akbeyá: —Ma Simóñ, Junástshi asukuák, Saldiñga netshi Jate zeñ ni majañgú. Ekí namaklde maldakbeñkáki kágubaja nuxa mu migisekuazháne ne, Najate jékaldaxa izhukajañga ni ekí mu migisekú. ");
INSERT INTO kog_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Akna nas míñgaki ekí mikbeyaldikue: Mañki Péguldu maldé, aiki “jagiga” guashi. Akze, mañki sakí nashaldá namak nakuakbaldéki jagi abuwa jana nek kama kakukshi najíkueki keshjuizhakualdikue. Akze, nas naldi nagapa neñkakueki kakuiyakshi, kama kakukshaldikue nakna, ni jisé ni shuixaja jiaga kagubiyaka atuazhíta nzha. ");
INSERT INTO kog_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nasga na yabi migeshi jana káguba Najateja aksanekakueki maksanexaldiamak niuwi migexaldikue. Ekí niuwi migeshi na, jai kagik ma jiki “atshasé nzha” makuaxaldiake ake, jékaldaxa jiaga ekíga ajañguane naldaldixa. Ekibeñga na, jai kagik ma jiki “janshibé atshakuega nzha” makuaxaldiake ake, jékaldaxa ekíga ajañguane naldaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ekí guaguenik Saldiñga netshi Jateja ezua zʉnekualdal gaxaldixa guakldaneki Duweja aldéñ “aiga ne” ni mek akbeyasé na niuwi zʉñgexá. ");
INSERT INTO kog_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Atshak zhinik na, Duwe Jesúja nasʉñ shi kagitixakuañ ekí zʉñmeyaldá: —Naski Jeldusaldéñka neyakue nagatsaldaldixa. Exaki nauwisaná nauwa akldé akzekue, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue juizhi matshuwi guiyaba natuñshi, nakuagakuega zaldaldixa. Naldatshak shuixaldikuenik jiak, maiguake mokue izhgaldaxaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ekí zʉñmeyatshakna, Péguldujañki Duwe nauwa agajué zeñka uldeñgueniki ekí axaldexaldá: —Nají Sáñkalda, Jatejañga ni mitsák ekí migatsegasé shi jañguí. ¡Ni mitsák ekí zegazháka naldashá! ");
INSERT INTO kog_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ekí axaldegatshak Duweja akizhikbateguenik ekí axaldék: —Jiséga miksaneshi tukí maldakbeyakna ¡nagajuezha guaté maldokldék! Najate najañguamak nagatsexaldixa mañki nagitamakui makuxaki ¿mikldegakí shi na? Mañki Saldiñga netshi Jateja sakí zexaldixa janaktune, “ai za amak zegakuéñ” jañguagábaki, kágubakueja sakí zegaka atuamak niñkauwañki “ai za amak zegakuéñ” jañgui izhogashibaldá. ");
INSERT INTO kog_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Guñguenik saldiñga nasʉñ shi kagitixakuañ ekí zʉñmeyá: —Mieldeke namak giemi nagapa nendana miñzexaldiake, aike ekí naldakue miñgatsaldaldixa. Axaldáñgaba “nakldunamak izhogazháldiku” izhgakugakue. Ekíga na, nají miné shalda nuxa guiyaba tuakue, azhi shuigakue miñgatsaldaldiake egaba abeti, “wa nuxa ni nakldexaldí” izhgakuxamine naldakue. Ekí izhgakuxamine na, nas za nagapa neyalga nogakue. ");
INSERT INTO kog_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jinake ekí miñmeyakí. Mieldeki jai kagik izhoxa za akldé akzé jañgui, nagapa neyasʉ́ñ akzekáki shuigatshak jékaldaxa izhoshiñga izhogazháldixa. Ekí ne, mieldeki nas shalda shuigaka izhgakuxaldiák zʉnake, jékaldaxa izhoshiñga izhoxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","”Ekibeñga na, mieldeke káguba kagik zhekuauxa guashiñki zhakaldak jika axaldaldi jiaga, shuigatshake jékaldaxa izhoshiñga izhogagába, guiyaba tu za nogakueñka neyaldixaga ne, ¿jiñ shi axaldanekue axazauwaldixa na? Ekíga na, mashuigatshake jékaldaxa izhoshiñga mizhoxaldiamake ¿ji shi zabimildaka na? ");
INSERT INTO kog_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ne nas Jatetshi Asukuága ixagabaldeklduge guaklduge uldeñkakue juizhiñga Najatetshi zʉ́xaita muñshí zalda nañga mokue kagik naxaldikue niyó. Ekí naxaldatshaga na kágubakue ezua, ezua sakí agatsaldi ajanashiji ashekuane katualdikuenik kagatsahauxabé kaxatshaldikue. ");
INSERT INTO kog_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Akze, namak miñmeyaldikue. Anuñka miné jai izhoxabinukakuañ shuigagá minoxaldieñga maiñ naldi nas Jatetshi Asukuága ixagabaldekldugek kágubakue kaksanegapankuge minatualdixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ekí zʉñmeyatoguenik tezhuwa ldiuwi zeguake, Duwe Jesúki Péguldu na Santiakuki, aldani Juañ na agapa gaxa akldé akshá zeñka kauwihezuañgaba jeñ kaulditshí. ");
INSERT INTO kog_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Exaki ekueja atuatogueñga, Duweki sha ishkazguatshaga ají waxaki niuwi muñshí stuamak ishkazguí, ají zhakuáki tuasá muñshí zaldaba iyaté. ");
INSERT INTO kog_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ekí ishkazguatshaga nauwibama Muesé, ezuañki Eldiya akizhañkatshak Duwe na dulda izhgashaldá. ");
INSERT INTO kog_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Guakna Pégulduja Duwek ekí akbeyá: —Nají Sáñkalda, janshibeñga jai katshekualdé tiuwi. Ekíga maldajañgualdiake maigua tañkuá akpañgualdikue, ezuañki mijí, ezuañki Muesétshi, ezuañki Eldiyatshi. ");
INSERT INTO kog_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ekí akbeyatogueñga na, mauwi muñshí agastexaga tiñ ketsegatshake ek zhinik Jatega ekí zukuagaté alduká: “Jejiéki Nasukuá giemi matshuwi izhgajañguge, nakldunauxabé izhogakna muldetua miyaxaldukaldí.” ");
INSERT INTO kog_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ekí aldukatshakna, ai maigua shaxaldixakueki zhe kakzeshiñgaba na waxam jeñ apá. ");
INSERT INTO kog_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Duweja ekí katuakna kaxaldaxeni, kaugikepañgui ekí kakbeyá: —Jeñ izhgaté guwíñ. Zhe miñzegagába. ");
INSERT INTO kog_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Guake mokue azatuatshake jiak, Duwe za ahezua akté atú. ");
INSERT INTO kog_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Guñgueni gaxa akshá zeñka zhinik zabatoguéñ Duweja ekí kakbeyá: —Nas Jatetshi Asukuága ixagabaldeklduge shuixaldikueni mokue izhgaldagagáñgaki sakí ishkazguaté natumine ni mek akbeyabináldi. ");
INSERT INTO kog_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Guatshak ai shaxaldixakueja Duwek ekí agalduká: —Guiyaba shizhixakuejañki Jateja ezua zʉnekualdal zʉñgakaxaldixa nagagáñgaki ají múldigaba naldiñga zʉxaitshixa Eldiya nagakue agatsaldaldixaga akuaka. Ne ¿jinak shi ekí akuaka na? ");
INSERT INTO kog_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Guakna ekí kakiyó: —Namak nauwibama Eldiya axañga nagatshak ejañki saldiñga janaktuwi, siyagauwaldixa. ");
INSERT INTO kog_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ne nas zʉnake ekí miñmeyaldikue. Au, Eldiya tsaldi neki nak guane naldashá. Amak nagatshak, kágubakueja e atú guatshak jiaga “aiga nzha” axajanazháldi, sakígaba sha akundana kakzegamak akuane. Ekí agatsaldiñga na, nas Jatetshi Asukuága ixagabaldekldugek jiaga guiyaba natuñshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ekí guagatshakna, ai maigua nekueja Duwejañki Juañ nik majaukshakue shaldaga kakbeyatuka kakldék na gua. ");
INSERT INTO kog_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Guñgueni nitshinekue Duwe na axatanatshake kágubakue juizhi duwá katshekualdeñka zʉñnabigatshakna, ezua sigíjañki Duwe stak nuldu axayoshi ekí agakuañnék: ");
INSERT INTO kog_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Nají Sáñkalda, nasukuá guañ naxaguanakue ni majañgukú. Nasukuáki pisti akzeshiñga na matshuwi juizha guksék, nik naxaguteji guiyaba nagatuñshiñgaba ni gu. ");
INSERT INTO kog_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ekí akzegakna, shi maxaldixakuek se akzukuexañ kakuldaxaldatshak jiaga, amak se agazukuazháka ni atú. ");
INSERT INTO kog_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Guake Duweja akiyokui ekí guak: —Maiñ kutám za mijañguxakue nak, Jate alduna ishakí nibiná. Akna namak minajañgualdiamake ¿mitsá jimiñtuwi, abeti miñkizhogakue nagatsaldaldixa ne? Sukua nakuldák guwíñ. ");
INSERT INTO kog_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Amak akualdaxake, Duweja sukuak jisétshi alduna neyakue axaldegatshaga amak izhé. Ekí izheñshatshaga na, se akzék na gua. ");
INSERT INTO kog_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ekí zegueni Duwe nasʉñ shi kagitixakuañ axaldashi ahezuañgaba ekí akldukáñkalde: —¿Jinak shi nasʉñki alde jisétshi aldunaki sukuak izheñshá zʉñzegazháka nalgú? ");
INSERT INTO kog_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Guñguake ekí zʉñkiyó: —Akze, maiñki auxaga alduna nazishakí zhinik guana ekí miñzegashá. Namak miñmeyaldikue. Ezua zulda nóñgutse nuxa nanaldixa atema negamakbe, mieldeke nauwa nuxaki “Jate akshishanugamak naxatshaldixa shakldá” alduna mishaldiák, aldéñga matshuwi mimatshishaldixa. Akna jejié guinue “jai zhinik agajuezha guwá” miyaxaldexaldiake amak miñkatshaldixa. Akze, ekí agatsaldi alduna mishaldiakna, saldiñga atshaminakagaba, ni ji atshazháminaka naldazháldixa nakldá.  ");
INSERT INTO kog_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ne jalde jisétshi alduna sana neñshexañki záaki, muldetua Jate axazguaxal noshi za na neñshakue. Ekí atshakíki neñshasé nakldá. ");
INSERT INTO kog_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Guñgueni Galdildeyaxa kishjuizhaldegatshak, Duwe Jesúja ekí zʉñmeyá: —Nas Jatetshi Asukuága ixagabaldeklduge ne, neyazhakuashi aguldiñkugekuek naxaxexaldixa. ");
INSERT INTO kog_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Amak sha nakuí nakuaxanaldinik jiak, maiguake mokue izhgaldaxaldikue nakldá. Ekí kaldukatshakna, zʉñgatsauxa zʉnetshanshiñgaba na gua. ");
INSERT INTO kog_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Duwe Jesúki nasʉñ shi kagitixakuañ juizhiñga kuíbuldu Kapeldahúmka kaldeyatshak, exaki juwí Jate axazakuagaldi siyagaxauwaldiamak izhasabine zhiksuikakue Pégulduk axaldagueni ekí agalduká: —¿Shi mixaldixaki juwí Jate axazakuagaldi ilzabiyakue agatsahamak ilzabixaga naldazhé shi na? ");
INSERT INTO kog_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Guake kakiyó: —Akze, ilzabixaga nakldá. Gueniki Péguldu juk juldunatshake Duweja mishañga axazguashi ekí aklduká: —¿Mañki mielde shi muldetua jian atshakuamake naldaka majañgú? Jai kagik zalda sanekakueja ¿mekue shi zabishixa na? ¿Ajúk zaldakue azhi axautshikue? ");
INSERT INTO kog_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Guake Pégulduja akiyó: —Axautshikue za asabishixa naldashá. Guake Duweja: —Akze, ajúk zaldakuega ni ji ilzabiyakue kagatsaldazhámakbe, nas Jatetshi Asukuága naugák, ají juwík akilzabiyakue nagatsaldazháka. ");
INSERT INTO kog_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Naldatshak nusá kakzukui guanazʉñnegak ekí atshiwá: Ilzabiyexañ paldata zʉñkaldaldaldiamak niwaxa maldeyaldí. Exaki pikáu makuxaldiamak antiuwizhu maguteyaldinik kasak makugatshak, ají kaxakga ezua paldata matualdixa. Aiki nas, ma na auxaga ilzabi guashi nakna, eñka mauldeyaldiniki kakzabi makualdí. ");
INSERT INTO kog_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Atshak niuwañga na, nasʉñ shi kagitixakuañ Duwek kaxaldaguenik ekí akldukáñkalde: —Jate jékaldaxa izhukaja saldiñga zʉñsanekakuek, ¿mielde shi akldé akzé naldaldixa na? ");
INSERT INTO kog_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ekí kakldukañguake, Duweja ezua sukua nauwikenáñ akldagueni ");
INSERT INTO kog_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ekí guak: —Namak miñmeyaldikue. Maiñ mijañguxaldi yushi, sukua aguáñ zhikzukui, Jateja janshibé aksanegaka akldegamakbe miñnegakue. Ekí ayushakí minaldaldiák, Jate jékaldaxa izhukaja miñsanegazháldi, aldéñ sanegeñka mimajuldukshazhíta nakldá. ");
INSERT INTO kog_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ekí nakna Jateja tuwiñki, mieldekueki jalde sukua aguáñ zhikzukuamakbe zhikzukuxakue na aldéñ kaksanekakuañga akldé kakzé katuñka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ekibeñga na, mieldeke nagapa mineyéñ zhinik ezua sukua jejié jana ne mipanatshaga, nas jiaga nepanamine naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","”Ne mieldejañki ezua nepanane ai itsaldagálde axajanka sha atshishaldiák, ¡mitsá atemajañ guiyaba tualdixa ne! Akna ni me ijuldukshazháldiamak, akldé janshibé aldéñga ezua jagi atema gakldak zhikldiya gualdiniki ni izhgatushi shuixaldiamak níbuni juit zaldi akuateyakue. ");
INSERT INTO kog_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","”Akze namak, jai kagik kágubakueki jiyájañgaba kejuldukshi, sha ajanashindana kakzukualdixaga, ne mieldejañki ezua ijuldukshi, sha atshishaldiák, ¡wau wau wau aiki mitsá atemajañ guiyaba tualdixa ne! ");
INSERT INTO kog_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","”Ekí nakna, jigabá sha atshindana miñzukuxa, mimakjieñguakaga mitualdiake, uteji izhgajuekuakue miñgatsé. Akna káuxalda azhi kasa sha atshindana miñzukuxá naldaldiake, axaldáñga izhbeñgua, uteya miñguxá jana atshakue. Akze, atabañki gulda azhi kasa misʉ́ñze jékaldaxa mijuldunaldiák, akldé janshibé naldaldixa. Ne sha atshalga minoxaldiake, mozhua káuxalda, mozhua kasa nañga Jateja guksé sanazhéñka mimaguteyaka ni mitú. ");
INSERT INTO kog_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ekíga na, mimijí ubaki sha atshindana miñzukuxá naldaldiake axaldáñga ishkuiya, uteya miñguxá jana atshakue. Akze, atabañki uba misʉ́ñze jékaldaxa mijuldunaldiák, akldé janshibé naldaldixa. Ne sha atshalga minoxaldiake, mozhua uba nañga Jateja guksé sanazhéñka guiyaba tu za nogakueñka mimaguteyaka ni mitú. ");
INSERT INTO kog_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","”Akna nepananekue ai itsaldagálde axajankakue aguáñ kakzekue katuwi guamiñnegak, muldetua numañ miyatualdí. Akze, ekí miñmeyaldikue: Ai nepananekueki Jatejañga aldéñ guaklde uldeñkakuek numañ agatuál gaxanekuejañki ekue shalda na aldesañ akbeyal axaldaxal nuka.  ");
INSERT INTO kog_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Guatshak nas Jatetshi Asukuága ixagabaldekldugeke mieldekue Najatek agitshuaná guanekue mokue nakzaldi, kezhañgashi, kekualdaldikuamak kagik naklduge nakldakú. ");
INSERT INTO kog_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","”¿Sakí shi mijañgú? Ezua sigíja jubeju 100 axaldé ne, ezuamé akbena agitshuizha guanake, ¿jubeju matshuwi (99) nekue za na gaxaldiñga maja gueniki ezuamé agitshuanane za niyal ne atshazháka shi na? ");
INSERT INTO kog_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Namak miñmeyaldikue. Amak nijiñga akzá gualdiake, zʉ́xaita zeñ itshanaldixa. Akze, jubeju 99 agitshuanazhánekue shaldaki mitsá zeñ itshanka guashiñki, ezuamé akbena agitshuanane mokue akzane shalda guana akaldak zeñ itshanaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Akze, jubeju numañ tuñkaja ni ezua agitshuanasʉ́ñ kajañguamakbeñga na, Nauwijate jékaldaxa izhukajañga nepananekue ai itsaldagálde axajankakue ni ezua agitshuani, agijuldunakue kajañguakí giemi nakldá. ");
INSERT INTO kog_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","”Mitságaba ezua mimijanameñga nazipanane sha miñkatshaldiák ekí miyatshaldí. Axáñ misha mañgaba aldéñ na za ishkazguaxal maxaldeyatshak, “sha naxatshamalde nakldá” izhgastuñshi maxaldexaldí. Ai mixaldukshi na, sha mixatshane masha gualdiake, mokue ma na ishkaldaldakuamak kualdikshá makualdixa. ");
INSERT INTO kog_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ne, maldukazhá, sha atshane majasʉ́ñga akzexaldiake, ezua azhi mozhua nagapa neñkakuega e nugeñka migapa kauldeyakue. Jinake ekí atshakue naldakí. Jatetshi múldigaba sezhekldamake mieldeja ezua agatsé izhguagatogatshak, mozhua azhi maigua nukanamak nekue na, za na agatsé guakbildaka naldaldixa guaka nak. ");
INSERT INTO kog_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ne ekue jiaga axaldukasʉ́ñ akzeshi, sha atsha mashasʉ́ñga akzexaldiake, nazipananekue izhajuizhaldegeñka kakbeyakue. Guatshak ekueja aksanegatshak jiaga nukasʉ́ñ akzeshi, sha atsha mashazhá gualdiák zʉnake Jate jañguazhé azhi sáñkaldak akiyalzabine tusheshi zhiksuika janañga nuxa katuwi kaxaldaldakue miñgatsaldaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","”Namak miñmeyaldikue. Maiñ jai kagik jiki “atshasé nzha” miñguaxaldiake, ake, jékaldaxa jiaga ekíga ajañguane naldaldixa. Ekibeñga na, jai kagik jiki “janshibé atshakuega nzha” miñguaxaldiake ake, jékaldaxa jiaga ekíga ajañguane naldaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","”Ekí jiaga miñmeyaldikue: Jai kagik mozhua naldi muldetua ishkualdi Najate jékaldaxa izhukak ji miyakshishaldiák, akshishaminamak miñkatshaldixa. ");
INSERT INTO kog_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jinake naldakí. Mitságaba mozhua azhi maigua nagapa mineñkakue minahéñ zhinik mishjuizhaldegatshak, nas naldiñga mimikenáñ izhokuge nak. ");
INSERT INTO kog_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Guñgueni Péguldujañki Duwek axaldagueni ekí aklduká: —Ezua najanameñga mipanane sha naxatshalga noxaldiake ¿mitsá juizha shi axabetakue nagatsá? Eñki ¿matshuwi juizha sha naxatshatshak jiaga axabetiñga, kugua juizha akldañka shi axabetakue nagatsá? ");
INSERT INTO kog_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Guake Duweja akiyó: —Nas zʉnake ekí mikbeyaldikue: Kugua juizhamé auxabé naldazháka nak, axabetiñga 7 negaba 70 juizha axabetakue migatsaldaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ai shaldaga zʉñmeji na, Duwe Jesúja ekí shizhiyaldá: “Najate jékaldaxa izhukaja káguba kaksanekakueki sakí jana naldaka miñmeyaldikue: Aiki ezua sáñkalda ají nashikueja mitsá akzabiyakue agatsé kakshishaldiéñ zek. ");
INSERT INTO kog_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ekí atshapanatshak, axáñ misha ezua akldé zabiyakue agatsé akualdák. Ejañki izatasá zalda shaldá akizhuka. ");
INSERT INTO kog_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ekí shaldá akizhoguakna, zabí guashi axaldaldakí giemi tuñguake sáñkaldaja ekí niuwi ge: ‘Nají nashi, saldiñga ji axaldauxa nabagisaji, aldéñ, asewá, ají sukuakue juizhi ezuatshi nashikue za izhoxaldiamak nabesá guwíñ. Ekíki ji nakzabiyakue agatsé nauwa nuxaki ipanaldikuamak.’ ");
INSERT INTO kog_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","”Ekí akualdixa nukajake, nashi ají sáñkalda stak nuldu axayoshi, izhgajiezhi ekí agakuañnék: ‘Guañ naguani nauwa jinaktú makualdí. Mitsá mikzabiyakue niyaldikuenik auxaga mikzabiyaldikuega nzha.’ ");
INSERT INTO kog_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ekí agakuañneguakna, ají sáñkaldaja guañ aguaniñga ‘mitsá nakzabiyakue migatsé ne, auxaga éegaba mixabetá ni gukú’ axaldegueniki ‘neyabikuká ni gu’ akbeyá. ");
INSERT INTO kog_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","”Nalgué ai nashi exa zhinik neyatogueñki, ezua ajanameñga sáñkaldatshi nashiga anuñka nuxa ají shaldá akizhuka akldabí. Aldéñ zʉnake kamañ naldi gakldak ziñ guaxaldixa jana gui ekí axaldék: ‘Shaldá mitenogauxa nuk nakzabí guaté maldokldék.’ ");
INSERT INTO kog_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ekí nukajake shaldá akizhukaja nuldu axayoshi ekí agakuañnék: ‘Guañ naguani nauwa jinaktú makualdí. Mitsá mikzabiyakue nuk mikzabiyaldikuega nzha.’ ");
INSERT INTO kog_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ekí agakuañnegatshak jiaga nukagábaki, akzabiyazhá guane shalda kiejo guane kalseldi mexal guak. Auxaga akzabiyakíñgaki eniñga izhogakue guak. ");
INSERT INTO kog_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","”Ekí zeklde atuatshakna, sáñkaldatshi nashikueki matshuwi shañgá kakzeguakna, kauwijí sáñkaldak zekldauxa agabeyal aldé. ");
INSERT INTO kog_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Guñguake sáñkaldaja ají nashi guañ itshanazháne agixauldal guagueni axaldagatshak ekí axaldék: ‘Ma nají nashi shane ni matuñkú. Mañki nagakuañnék makuñguake, mitsá nakzabiyakue migatsalgué auxaga éegaba mixabetá guanuge. ");
INSERT INTO kog_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ne nas guañ miguananugamakga, ¿ma zhinik ezua nají nashiga shaldá mikizhuka nalgué ekíga guañ jañguakue migatsaldazhá shi guaná?’ ");
INSERT INTO kog_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Axaldegueni ají nashi ekí atshane shalda nusá akzukui na auxaga akzabiyakíñgaki kalse aksuikuekueja guiyaba kaxañ atuñshatoxaldiamak ge na gua.” ");
INSERT INTO kog_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Duweja ekí guagatoguenik ekí jiaga guak: —Maiñ nazipanaminekuañ ezua sha miñkatshane guañ jañgui, miñgatsauxa axabetakí minaldaldiák, ake, ai sáñkaldaja ají nashi guanamak Najate jékaldaxa izhuka mimakualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Duwe Jesúja ekí auxa shizhiñguenik, Galdildeya zhinik nina Juldáñ ataba niñkauwa akbategueniki ai tezhak ga Juldeya baxe nasʉñ na ne. ");
INSERT INTO kog_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ekí neyatshakna káguba duwá zhikzhe axapa aldé. Exaki aikuega mulbatá akzekakueki Duweja se kakzukuá. ");
INSERT INTO kog_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Atshakna, anuñka paldiseyukue Duwe axaldaguenik akuajaldiamak kakldeshi ekí agazalduká: —¿Nauwisanátshi guiyabajañki ji shaldagaba jiaga sigíja janshibeñga shi asewá majaka guaka na? ");
INSERT INTO kog_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Guake ekí kakiyó: —¿Maiñ Jatetshi múldigabak ekí guaka mizukuakshixa naldazhé shi na? “Jateja kasak zalda káguba gauwatshak sigí, munzhi na zhuasewá nexaldiamak gauwane.” ");
INSERT INTO kog_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Amak gauwatshakna ekí guakldane: “Sigí numa negatshak ajate, ajabak agajuezhaldinik, asewá na niñkauwañki askuildegatshake, abuáke mozhua aldanaldixa askuí abuá jana nek guxa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Akna, sigí, munzhi na mozhua aldanaldixa askuí abuá jana nek guxa. Akze, Saldiñga netshi Jateja naldiñga sigí, munzhi na askimimé nekshá guanega, ni meja jiaga kezhgajuekuakue agatsaldazháka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Guake mokue kauwizhéñ zhinik agalduká: —Aiki namak naldaka nake, ¿jinak shi nauwibama Mueséja “mielde sigíjañki asewá majaldá gualdiake, ‘mabajá ni gukú’ guaká xalte agegakue agatsaldaldixa nakldá” niuwi genane na? ");
INSERT INTO kog_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Guake ekí kakiyó: —Kasak Jateja sigí munzhi abashazháldixa kajañgui gauwane. Nalgué aldunaxa kuamaldekbine amak atshasʉ́ñ miñzeká shalda na, nauwibama Mueséja ekí agatsaldi munzhi majaminaka guakldane naldashá. ");
INSERT INTO kog_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ne nas zʉnake ekí miñmeyaldikue: Sigíja asewá axautshi na askuildék guatshak za na majaka naldaldixa. Ne munzhi axautshi na askuildék guakí nogeñga, majaldinik axautshi guxaldiák zʉna, asewá naldagálde tushek guxaga zexaldixa. Ekíga na, mieldejañki abajane guxa gualdiake, Jateja tuwiñki asewá naldagálde tushék guxaga tualdixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ekí kaldukajake, nasʉñ shi kagitixakuañ ekí akbeñkalde: —Ekí sigí asewá na ishkaldaldakue agatsé nake, ake, akldé janshibé numa negagába izhogakue nukshí. ");
INSERT INTO kog_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Guake ekí zʉñmeyá: —Tuejié múldigabaga saldiñgaja agajienazháka. Ne Jatejañga mieldeki amak izhó guashi agaunekakueja za na tuejié múldigaba agajieni izhogaka. ");
INSERT INTO kog_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Akze, jinak zhinik anuñka sigíkue numa negazhékue naldakí. Ezuakueki munzhi na askuildék atshazhákakue kukanekue. Ne ezuakueki kágubakuejañga kapuna guanekue. Ne ezuakue zʉnake “Jate jékaldaxa izhuka za na muldetua axazauwaldikuamake, munzhi izhguaja naldáaki, sameya za ni izhoxaldikú” izhgakuxanekue nak. Mieldeki ekí izhogaka akldexaldiák amak za izhogakue agatsaldaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Guatshak Duwe Jesúja sukuakue zeñ kajañgui káuxalda kepañgui, Jatek kakbeyaldiamak akualdagaté katuatshakna, nasʉñ shi kagitixakuañ sukua uldakldekue ekí kaxaldekalde: —Ekí Duwek sukua akuldagagába nogwíñ. ");
INSERT INTO kog_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ekí Duweja nukatshakna ekí guak: —Sukuakue nas nugéñ aldashi naguatók, kagitamakuagába. Jinake ekí miñmeyakí. Mieldekueki sukuakue aguáñ zhikzukui, Jate jékaldaxa izhuka alduna iyashamakbeñga alduna ishixakue na Jateja kaksanegaka naldaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ekí guagueniki sukuakue zeñ kajañgui káuxalda kepañguñgueniki exa zhinik ne na gua. ");
INSERT INTO kog_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Guñgueniki ezua sigíja Duwe Jesú axaldagueni ekí aklduká: —Shi maldazʉñkaldixa, Jateja jékaldaxa izhoshiñga nezhokshaldiamake, ¿sakí janshizhegaba atshakue shi nagatsá? ");
INSERT INTO kog_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Guake Duweja akiyó: —¿Jinak shi janshizhegaba atshakue shalda maldaklduká? Ezuañgaba auxaga janshizhe, eñki Saldiñga netshi Jate za naldashá. Akna aldéñga izhoshiñga mezhokshakue mikldegake, ake, guiyaba atsha nexaldixa nauwibamak zʉñkageneja guagamak matshaldí. ");
INSERT INTO kog_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Guake aklduká: —Ne, ai guiyabakueki ¿mieldekue shi amak atshakue nagatsaldaka na? Guake Duweja akbeyá: —Ai guiyaba atsha nexaldixajañki ekí guaka: “Axautshi guaxa atshasʉ́ñze. Misewá naldagálde na askuildek guasʉ́ñze, tushegasʉ́ñze, axautshi shalda naldagálde guagasʉ́ñze, ");
INSERT INTO kog_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mijate, mijaba akzé jañgui, kaxabetakue” guaka. Ekíga na, “maiñ axaldáñ mitsá miyajañguxa nake, kágubakue amaga mizhgajañgualdí” guaka naldashá. ");
INSERT INTO kog_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Guñguake akiyó: —Eñki guagamak amak atshijiñga izhokuge naldashá. Ne ¿mielde shi akldé atshakuega nagatsaldaka na? ");
INSERT INTO kog_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Guake Duweja akbeyá: —Naldakuauxabé izhokldana mikzegake, ake, maldeyaldinik jika mixaldauxa nabesá xaldeki, nashi jika agajueshkakuek makauwaldí. Ekí matshaldiakna jékaldaxa niñkauwañki, Jateja matshuuwi janshizhe mixatshaldixa. Mikbenugamak matshaldiniki nagapa neyaldá makualdí. ");
INSERT INTO kog_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ekí nukatshakna, ai sigíki zʉ́xaitsha kabia nalguakna itshaniñgaba ne. ");
INSERT INTO kog_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ekí tuatshakna, Duweja shi kagitixakuek ekí zʉñmeyá: —Namak miñmeyaldikue. Kabiakueki “Jate jékaldaxa izhuka shi naksaneshí” izhgakugexañki ¡mitsá jibañ kakzeka ne! ");
INSERT INTO kog_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jiak mokue ekíga miñmeyaldikue: Ezua kabiaja Jate za ají Sáñkalda ishkizhaxaldiamak izhgakugexañ jibañ akzeka. Aiki ezua béyakze atema skalda pokuéñ agaskaitazhákldegamakbe jana ne nakldá. ");
INSERT INTO kog_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ekí kaldukatshak míñgaki akldeñga “¡sakí shi ekí guak!” zʉñneshi akldukáñkalde: —Amak keyakualdexañ ekí jibañ nake, ake, ¿me iyakualdaka ne? ");
INSERT INTO kog_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ekí nukatshakna Duweja zʉnatuaté noshi ekí zʉñkiyó: —Kágubakueki axaldáñ ilkualdazháka ne, Saldiñga netshi Jate zʉnake saldiñga atshakagaba nak kalkualdakaga nakldá. ");
INSERT INTO kog_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ekí nukatshakna Péguldujañki Duwek ekí akbeyá: —Nasʉñki migapa neyakualdiamak, jika zʉñkaldauxa nuk majá guáñkalde naldashá. ¿Ne ai shaldaki Jateja ji janshizhe zʉñkatshaldixa shi na? ");
INSERT INTO kog_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Guake ekí zʉñkiyó: —Namak miñmeyaldikue. Niuwizhíne Najateja saldiñga mokue abisajañ janshi axazguatshaga, nas Asukuága ixagabaldeklduge saldiñga aksanegatokugeñkaga, maiñ nagapa mineñkakueki nas nañga misanexaldixa. Atshaga na, naski zʉ́xaita muñshí zalda nañga sanexa xaldoxéxa zhinik sanegatoxaldikueñga, maiñ jiaga 12 sanexa xaldoxéxa zhinik nauwisaná juldiúkue 12 ldaxe nekue kagatsaldi ne azhi kagatsaldakí ne mitualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Akze, mieldeke nas za nagapa neyaldiamake ají juwí, te, akajakue, ajate, ajaba, asewá, ají sukuakue majaka izhgakuxaldiakna, amak majane guashiñki Najateja 100 juizha agexaldixa. Ekíga na, jékaldaxa aldunaxa auxaga akzukui izhoshiñga izhokshataná nakldá. ");
INSERT INTO kog_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Guatshak kaiga akldé akzé axajankakue nanaldixa, Najate sanegeñkaki matshuwi aikuega aguáñ akzekue naldaldixa. Ekíga na, kaiga ai itsaldagálde axajankakue nanaldixa, Najate sanegeñkaki matshuwi aikuega akldé akzekue naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Guñgueni Duwe Jesúja ekí shizhiyaldá: “Najate jékaldaxa izhukaja káguba kaksanekakueki, sakí jana naldaka miñmeyaldikue. Aiki, ezua tetshi ajáugukuija ají te kalwé xaldeldi jiba axatshaldixakue zhe meñga kuíbulduxa niyal ne. ");
INSERT INTO kog_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Amak akzalguake, ezua ldiuwi akzaldakldegauxa akzaldi kakzabiyaldixa izhgakualdi, ají tezhi jeñ jibatshál kakaxá. ");
INSERT INTO kog_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","”Guñguenik niuwi jue zegatshake mokue kuíbulduxa neyatshak anuñka ji ajanashagába izhogatukakue katuñguakna, ");
INSERT INTO kog_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ekí kaxaldék: ‘Maiñ jiaga nají te kalwé xaldeldi jiba naxatshate guwíñ. Gualdiake miñzabiyakuauxa miñzabiyaldikue nzha.’ ");
INSERT INTO kog_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kakbeñguake amak jiba axajanashál aldé. Guñguenik jiak niuwi muanté, jiak niuwi uñguexáki mokue kuíbulduldi neyatshak, ekíga jiba axatshál jeñ kakaxá. ");
INSERT INTO kog_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","”Guñguenik jiak mokue niuwi agajienaldá kuíbulduxa neyatshak, anuñka ji ajanashagába izhogatukakue katuñguakna ekí kaxaldék: ‘¿Jinak shi maiñki jibatshagáñga niuwi miñneyatók?’ ");
INSERT INTO kog_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Guake akiyayó: ‘Ni me jiba axatshexañ zʉñgakuañnegakí naldashá.’ Guake ekí kakbeyá: ‘Ake, maiñ jiaga nají te kalwé xaldeldi jiba naxatshál newiñ.’ ");
INSERT INTO kog_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","”Guñguenik tuañ zexaldá guapanguake, tetshi ajáugukuija ají nashi jiba gekak ekí akbeyá: ‘Jiba naxatshatonekue nuk kajuizhakua xaldeki ekí agatsaldi kakzabi guwá. Axáñ misha niuwi agajienaldá zegatshak jiba naxatshál nakldekuek makzabiyapanaldinik, kakzabijiñga aldiweki muñshaga jiba naxatshál nakldekuexa yo makzabiyaldí.’ ");
INSERT INTO kog_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","”Guñguake akbenalguamak niuwi agajienaldá jiba axatshál nakldekue misha ezua ldiuwi akzaldakldegauxa akzaldiñgaba ezuak, ezuak kakzabí. ");
INSERT INTO kog_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Guñgueni muñshaga jiba axatshapananekue kakzabiyaldá. Kauwizhéñki akldé akzaldi kagasabiyaldixa ajañguane nalgué, zhualduxañga ezua ldiuwi akzaldakldegauxa akzaldiñga nuxa kaxasabí. ");
INSERT INTO kog_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ekí iyapanatshakna, tetshi ajáugukui kiejo axaldeshi ekí axaldék: ");
INSERT INTO kog_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Nasʉñki niuwi zʉnatuwi, naki nuk mijí jiba mixatshiji niuwi zʉñné guane. Ekí ne, jejiékue niñkauwañki aldiwan niuwi agajienaldá aldakldekueki maldé nuxa jiba mixajanashanekue ¿makzabiyauxabeñga shi maldazʉñzabí?’ ");
INSERT INTO kog_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","”Ekí aldexake ezua aikuekga ekí akiyó: ‘Tu guwá, napebu. ¿Ma nañki ezua ldiuwi akzaldakldegauxa akzaldiñga mikzabiyaldikue zhikbeñkalde naldazhé shi na? Akna mixatshakue nagatsahamak mixatshatogashakú. ");
INSERT INTO kog_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Akna mikzabinuge ipana xaldeki neyabikuká ni gu. Naski aldiwan naxatshapanane jiaga, ma mikzabiyanugauxaga akzabiyaldikue izhgakuxanuge. ");
INSERT INTO kog_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Azhi nají paldataki sakí gualdikue nakldék guake amak guazhánaka shi maldajañgú? ¿Azhi naski guañ jañgui ezuake akzabiyakue nagatsé guashiñki zʉ́xaita agekuge shaldaki mauldí shi mikzék?’ na tetshi ajáugukuija axaldexá.” ");
INSERT INTO kog_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ekí guaguenik ekí jiaga zʉñmeyá: “Akze, miñmenugamake, ai itsaldagálde axajankakue nanaldixa, Jate sanegeñkaki akldé akzekue naldaldixa. Ekíga na, kaiga akldé akzé axajankakue nanaldixa, Jate sanegeñkaki aguáñ akzekue naldaldixa nakldá. Akze, Jatejañga matshuwi nekue kaksanexaldiamak axaldagakue kakbeyatshak jiaga, matshuwi axaldagasʉ́ñ kakzegéñ zhinik na anuñka me kezhgakuka ne awatuñshixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ekí shizhiyatogueniki Jeldusaldéñka neñkága na, Duwe Jesúja 12 shi kagitixakuañgaba san zʉnauldeñgueni ekí zʉñmeyá: ");
INSERT INTO kog_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kaigaki Jeldusaldéñka na neyañkapán. Exaki nas Jatetshi Asukuága ixagabaldekldugek nezhakuashi, Jatek múldigaba agaskaitshixakuetshi sáñkaldakuek, guiyaba shizhixakuek naxaxexaldinik, shuigakue nagatsé axaneyaldaxaldixa. ");
INSERT INTO kog_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ekuejañga na, nauwisaná juldiú naldagáldekuek naxaxexaldixa. Kauwizhéñki naziyajokldexaldixa, kuizhushak nagaldabikshaldixa, kaldixa naxaldiya nakuaxaldixa nakldá. Ekí nakuaxa guanaldixa jiak, maiguake mokue izhgaldaxaldikue niyó” na zʉñmeyá. ");
INSERT INTO kog_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Guñgueni Zebedeyutshi asewáki asukuákue mozhua nasʉñ nañga agatsé Juañ, Santiaku nañga Duwek axaldagueni ezua akshishaldiamak nuldu axayó. ");
INSERT INTO kog_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ekí tuatshakna Duweja: —¿Ji maldakshishaldixa ne? Guake akiyó: —Jejié nasukuákueki, niuwizhíne saldiñga aksanexabaldoxaldieñkaga ezuañki atabañ, ezuañki atabañ mikyó iyaldagakue kajañgui makualdí. ");
INSERT INTO kog_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Guakna ekí kakiyó: —Ji nakshishabinuka miñnegakí nakldá. Ake, sakí agatsaldi atemajañ guiyaba tualdikue nagatsegapanamak ¿tuminaka shi miñnék? Guake asukuákuejañki akiyayó: —Akzé. Nasʉñ jiaga ma nañga ekíga guiyaba tunazʉnaka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Guake Duweja ekí kakbeyá: —Akze, miñguaxamakga nas guiyaba tuakue nagatsahamak mitualdixaga. Ne sanexaldikueñkaki nasga mielde nakyó iyaldaxaldixa izhgakugakue nagatsaldakí. Eñki Jateja na mieldeki nakyó iyaldaxaldixa janaktunekue za na amak kezhaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ekí akshishaté kaldukatshak shi kagitixa 10 kaldekuañki ni nauwa zʉñnunazhá. ");
INSERT INTO kog_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Guakna Duweja saldiñga zʉnajuizhakui ekí zʉñmeyá: —Miñkuahamakga na, Jate jañguazhékuetshi sáñkaldakuejañki kauwijí nashikue aguabiji mual axaldeshi za axasaneka. Sáñkalda akzekueja nashikueki kauwizhéñ za agasanegaka niuwi kaxaldé ne ajañgushixakue. ");
INSERT INTO kog_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ekí ne, maiñ zʉnake ekíga naldagábaki, mieldeke akldé miñzaldana miñzexaldiake, aike aguáñ zhikzukui, axautshikue kaxazauwakue miñgatsé. ");
INSERT INTO kog_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ekibeñga na, mieldeke akaldak miñzé mimatundana miñzexaldiake, ake, saldiñgatshi nashi nuxa izhogakue miñgatsé. ");
INSERT INTO kog_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Akze, nas Jatetshi Asukuága ixagabaldekldugek jiaga, axautshikue naxazauwaldiamak jai kagik nagazhánuge. Ne naski kaxazauwal naklduge. Ekí kaxazauwiñga na, matshuwi káguba sha ajanashixa shalda kesabiyaldikuamak shuixal naklduge nakldá. ");
INSERT INTO kog_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ekí nejiñga na, kuíbuldu Jeldikóxa zʉxaitañkaldogueñki, káguba duwá zhikzhe zʉñgapa aldeyaldá. ");
INSERT INTO kog_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ai jiúñgulda xezhakga na mozhua sigí uba isékue izhoguekueja Duwe zʉxaitatuka aldukañguakna saldiñgaja nukandana agatsaldi ekí iyaxauldaldá: —Nauwijí Sáñkalda, mañki nauwibama sáñkalda Dabítshi atukuaga maldé, guañ maldazʉnajañgualdí. ");
INSERT INTO kog_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ekí kauldaté aldukatshakna, kágubakuejañki ekí kaxaldék: —¡Sʉnjá nogakueki tuakí shi miná! Ekí kaxaldegatshak míñgaki, akldé jaldáñ ekí axauldaldá: —Nauwijí Sáñkalda, mañki Dabítshi atukuaga maldé, guañ maldazʉnajañgualdí. ");
INSERT INTO kog_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ekí aldegaté nukañguake, Duwe neyatogué agaldagueniki uba isékue axaldaxal kaxaldegueni ekí kaklduká: —¿Sakí shi amak guañ miñguanakue minajañgú? ");
INSERT INTO kog_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Guake akiyayó: —Nauwijí Sáñkalda, zʉtundana ni zʉñzék. ");
INSERT INTO kog_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Guñguake Duweja guañ kajañgui na, ubak kaugikepañguatshaga na uba kekukshá. Guake Duwek axapa aldeyaldá na akuá. ");
INSERT INTO kog_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ekí Duwe Jesú Jeldusaldéñka neñká nejiñga na, naki eñka izhañkaji, gaxa akshá zeñka Oldibuxaga, kuíbuldu Betapaje neyatshak, Duweja nasʉñ shi kagitixakuañga, mozhua aksajañga kakagapanatshak ");
INSERT INTO kog_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ekí kakbeyá: “Uñguexa kuíbulduxa newiñ. Exaki ezua buldu, awawa nañga shaklduka axaldí ubañga mitualdixa. Ekí mitualdiake, axawati minakuldaxaldí. ");
INSERT INTO kog_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Amak miyatshatshake ji miñgabeyaldiake ekí miyakbeyaldí: ‘Nauwijí Sáñkaldaja buldu agajuezhá guak. Jiak agajuezhaksá gualdiake ubañga mokue uzgauwaldixa nzha.’” ");
INSERT INTO kog_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ekí zexeki, mauzeñga ezua Jatetshi múldigaba naldiñga zʉxaitshixaja sakí zexaldixa guakldanamak zexaldiamak ekí zeklde. Ekí sezheklde: ");
INSERT INTO kog_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Siyóñ zaldakuek ekí kakbewíñ: ‘Tu guwíñ, mimijí Sáñkalda akzeki uñkuahí nagaté tiuwi. Aldéñki aguáñ zhikzukui na, bulduk íte nagatuka. Buldutshi awawak nuxa íte nagaté tiuwi.’” ");
INSERT INTO kog_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Amak mozhua shagitixakue kakaguake eñka aldeyatshake, Duweja kakbenalguamak ajanashá. ");
INSERT INTO kog_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Guñgueniki buldu, ají awawa nañga Duwek akualdaguenik, awawake kauwijí zhakuá abakaldak kejuakuekue akiyapañguñguake iyabexá. ");
INSERT INTO kog_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Guñguake kágubakue duwá zhikzhe ashekualdekueja Duwe akzé atuwi na neyaldiéñ anuñkakuejañki zhakuá abakaldak kejuakuekue abuapañgui, ezuakuejañki setábaxe xai axabeñguane abuapañgui na akuá. ");
INSERT INTO kog_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ekí ajanashijiñga na, agapa, aksaja neyatoguekueki zeñ kakldeshiñgaba na, jaldáñ ekí akuagapaná: —¡Nauwibama sáñkalda Dabítshi atukuaga zʉnekualdal nakldeki akldé akzamakga kuizakzukuí! ¡Jate, nauwijí Sáñkaldaja atsaldí jejié zʉñgakaxane, aldéñga zeñ shi jañguí! ¡Jate jékaldaxa izhukaki akldé akzamakga kuizakzukuí! ");
INSERT INTO kog_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ekí nejiñga na, Jeldusaldéñka juldunguenik saldiñga eñgui baxe zaldakuejañki “¡jinak shi ekí zegapán!” kakldeshi na: —¿Eñki me nak shi ekí axajanashí? —izhgalduká. ");
INSERT INTO kog_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Guake káguba axapa neyatoxekuejañki: —Eñki Duwe Jesú, aldéñki Jatetshi múldigaba naldiñga zʉxaitshixa, kuíbuldu Nasaldé, Galdildeya baxe zalda nakldá —na akuaxá. ");
INSERT INTO kog_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Guñgueni Duwe Jesúki juwí Jate axazakuageñka juldú. Exaki jigaba Jatek agaxexaldixa atshasʉ́ñzamak nabeyasatshak, kaxajabiyaté tuatshakna, eñka zhinik kaldeñshaldá. Ekí kaldeñshiñga na, paldata eni zaldak yushixakuetshi misa, shamí Jatek agaxexaldixa nabeyasaxakuetshi kaldoxá juizhi nuk kakizhikbeshi ");
INSERT INTO kog_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ekí kaxaldék: “Najatetshi múldigabak ekí guashi sezheklde: ‘Nají juwíki nas za naxazakuagéñ axezhoxaldixa nzha.’ Ekí sezheklde ne, ¿maiñki mitushexaldixa jube nuxa guamine shi mimatuñkú?” ");
INSERT INTO kog_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Exa juwí Jate axazakuageñkaga na uba isékue, muldetua neyagáldekue Duweja se kakzukualdiamak axaldaguake, amak se kakzukuá. ");
INSERT INTO kog_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ekí Duweki guagasá janshizhe atshaté atuatshakna, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakueki nusá kakzék. Ekí zhinik jiaga nusá kakzék, eñgui Jate axazakuagaldi sukuakueja “¡Jateja ezua zʉnekualdal gaxaneki, nauwibama sáñkalda Dabítshi atukuaga akaldak akzamakga kuizakzukuí!” akuagaté aldukatshakna guagasʉ́ñzamak agatsaldi akuaká ajañguatshakna, ni nauwa kakldunazháldi ");
INSERT INTO kog_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ekí Duwe axaldék: —¿Sukuakueja sakí mishaldá akuagatuka nukakí shi maldá? Guake kakiyó: —Akzé, nuká na gukú. Ne maiñki ¿Jatetshi múldigabak ekí sezheklde zukuakshabíne shi na? “Akze, sukuakue, somákue juizhi kauwixaxak zhinik mikldunamak agatsaldi akaldak mikzukualdiamake, mañga na janazhigaktumalde noxabaldók.” ");
INSERT INTO kog_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ekí atshatogueni, kabajeniki ai kuíbuldu zhinik kaldeñgueniki kuíbuldu Betaniaxa sesʉñki kabaxal zʉnauldé na gua. ");
INSERT INTO kog_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Abokualdi muñshaga, Duwe mokue kuíbulduldi neñká neyatogueñki maldija gualdá. ");
INSERT INTO kog_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ai jiúñgulda xezhakga ezua kaldi zhenka akté tuñguake, exa neyatshak zhekualdagálde, kalké za tu. Ekí tuatshakna kaldi ekí axaldék: —Ni mitsák mokue zhena guabaldáldixa nzha. Ekí axaldegatshaga na, kaldi agatsauxa kaná na gua. ");
INSERT INTO kog_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nasʉñ shi kagitixakuañki ekí zegaté katuatshakna, “¡sakí ekí atshixá!” jañgui na ekí akldukáñkalde: —¿Sakí shi kaldi zhenka anuñkáte kaná gu? ");
INSERT INTO kog_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Guake Duweja zʉñkiyó: —Namak miñmeyaldikue. Maiñ “Jateki ji agakuañnekldugamak naxatshaldixa shakldá” jañgui mozhua miñnék naldakí alduna ishiji miyakshishaldiák, nas kaldi guanugamakga atshaminaka. Ne jejié guinue “jai zhinik agajuezha xaldeki níbunixa iyawateya guwá” miyaxaldexaldiake ai jiaga amak miñkatshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Akze, Jate miyaxazguagatshak “ji akshishanugamak naxatshaldixa shakldá” jañgui, alduna ishiji miyakshishaldiák, amak miñkatshatshak mipanaldixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Guñgueniki Duwe Jesú Jate axazakuageñka juldú. Exa shizhiyatoguéñ, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, nauwisaná nauwa akldé akzekue na axaldagueni ekí agalduká: —¿Mañki mani zalda niuwi guxamalde shi ekí atshiji, shizhiyabaldók? ¿Meja ekí matshaldixa niuwi migene naldaka ne? ");
INSERT INTO kog_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Guñguake Duweja kakiyó: —Ake jiak, nas ezua miñnukaldikue. Ai nakiyó miñgualdiakna, jiak nas zhinik meja niuwi nagenek ekí atshatokuge miñmeyaldikue. ");
INSERT INTO kog_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juañ nik majaukshakueki, ¿meja káguba nik jaukshaldiamak shi niuwi agená? ¿Jate jékaldaxa izhukaja azhi kágubaja nuxa niuwi agene shi na? Ekí kakldukañguake kauwizhéñgaba sakí akiyayokualdixa ekí izhgabeyaldá: “‘Jate jékaldaxa izhukajañga niuwi agenane nakldá’ akiyokuakualdiake ekí zʉñnukaka: ‘Tukí Jatejañga niuwi agene nalguake, ¿jinak shi aldéñ shi miñkaldiyatshak “namak ni guak” jañguazhá guamine na?’ ");
INSERT INTO kog_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ne ake, ‘kágubaja nuxa niuwi agenane nakldá’ yokuexañki zheñga zʉñzukuashá. Jinak naldakí. Saldiñgaja Juañki Jatetshi múldigaba naldiñga zʉxaitshixa nane ajañguxa nak.” ");
INSERT INTO kog_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Guakna ekí nuxa akiyayó: —Mejañga Juañ niuwi agenane zʉñsʉ́ñ nzha. Guñguake aldéñ ekí nuxa kakiyó: —Ake jiak, amakbeñki nas jiaga ekí atshiji, shizhiyaldikuamake meja niuwi nagene miñmeyazháldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Guñgueniki Duweja ezua ajanashakldegéñ zhinik ekí kakbeyá: —Jejié miñmeyaldikue shaldaki ¿sakí shi jañguaminaka na? Ezua sigí mozhua sukua axaldé nalgué ezuak ekí akbeyá: “Nasukuá, kaigaki nají kalwé xaldeldi jiba naxatshate guwá.” ");
INSERT INTO kog_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Guake ekí akiyó: “Neyasʉ́ñ nzhakzék.” Ekí akbene nalgué jiaga, jiak aldiwanki amak ne. ");
INSERT INTO kog_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Guñguakna ajateja mokue ezua asukuák: “Nasukuá, kaigaki nají kalwé xaldeldi jiba naxatshate guwá.” Ekí akbeñguake eja zʉnake: “Ake, jate, amak mixatshaldikue nzha” akbene nalgué jiaga amak axatshazhá. ");
INSERT INTO kog_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ekí guagueniki ekí kaklduká: —Ai sukuakue mozhua nekue ¿mielde shi ajatek akldunamak axatshane mitú? Guake akiyayó: —Kasak neja. Guake Duweja ekí kakbeyá: —Namak miñmeyaldikue. Káguba sha atshixa mijañguxakue, aikuega na sáñkaldak akiyalzabine paldata zhiksuikakue, munzhi nakua niji za izhukakue jiaga sha ajanashixa abashatshakna, mimezhaxañga Jateja kaksanexaldixa. ");
INSERT INTO kog_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jinake ekí miñmeyakí. Juañ nik majaukshakueki jian izhoshi na, jian izhoxa jiúñgulde shi miñkaldiyatshak jiaga, namak axaldukazhá guamine. Ne niñkauwañki sha atshixa mijañguxakue, sáñkaldak akiyalzabine paldata zhiksuikakue, munzhi nakua niji za izhukakuejañki Juañja ekí guagaté aldukatshak “namak nukshí” axaldukshi sha atsha abajá guanekue. Ne maiñ zʉnake ekí ajanashaté mituatshak jiaga, “namak nukshí” jañguazháldi, sha atsha mashazhá guamine naldashá. ");
INSERT INTO kog_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","”Mokue ezua ajanashakldegéñ zhinik shi miñkaldiyaldikue muldetua naldukaté nogwíñ. Atiuwiñ zalguéñ ezua tetshi ajáugukuija ají tek kalwé zhenka nixá. Nigueniki muldetua kuldaldu ibé, mani kalwéldia axasiziñgualdiéñ siyagáu, ezuaja mataxa zhinik numañ tualdiamak jiaga gauwá. Ekí atshiñgueniki anuñka sigíkuek axabajá guñgueniki, aldéñki awaxani, maldé zaldi ne. ");
INSERT INTO kog_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Amak neñgueni, eñka izhoshi na, kalwé akuiyaldiéñ zeguake, ají nashikuega te axabajanekue nugeñka ajíki muan agaxexaldiamak agakuxal gaxá. ");
INSERT INTO kog_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Guane nalgué, nashikue amak eñka aldeyatshake keyapangueniki, ezuañki agaldabikshá, ezuañki akuaxá, maigua neki jagi iyabushi akuaxá. ");
INSERT INTO kog_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ekí tetshi ajáugukuija ajanashane nukañguake, jiak ají nashi axañga gaxanekue guashiñki akldé mokue kakaxá. Guane nalgué, ezuakue sha akuanamakga kakuá. ");
INSERT INTO kog_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ekí ajanashane mokue nukañguakna te shjáugukuija “nasukuá giemi natsaldí kagakaxa guanugake, aiki axabetá akualdixa shakldá” jañgui asukuá gaxá. ");
INSERT INTO kog_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","”Guane nalgué, amak asukuá exa neyaté atuatshakna, te axabajanekueja ekí izhgabeyá: “Uñkuejiéki te shjáugukuitshi asukuá nakna, jejié te bieni ipanaldixa. Akna, nasʉñ niñkauwañki ají bieni ipanakualdiamak guaxá kuizguí.” ");
INSERT INTO kog_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ekí izhgabeji, iyapangueni kalwé xaldeldi zhinik agazaxaitshiñgueniki akuaxá. ");
INSERT INTO kog_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","”Akna, te shjáugukui naxaldinik ekí atshanekueki ¿sai kakualdixa shi mijañgú? ");
INSERT INTO kog_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Guake ekí akiyayó: —Aldéñ naldi guañ kajañgua naldakí, nuk kakuaxaldixa. Gualdinik ají kalwé xaldaki axautshikuek, amak ajíki muan agegakakuek niñkauwañki kaxabajaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ekí akiyayokuñguake Duweja ekí kakbeyá: —Maiñ Jatetshi múldigabak ¿ekí guaka zukuakshabíne shi na? “Juwí gauxakueja ezua jagi zauwazháka ajañgui awateyá akuane. Ne aiga na jagi abuwa akldé akzé juwí muldetua agatsaldakuamak agatsé sekuá guane nakldá. Aiki Saldiñga netshi Jatejañga ekí zekuane. Ekí atshaté katuatshakna ‘¡sakí ekí janshizhe atshixá!’ zʉñnekshá guane nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","”Akna namak najañguazháldi, nazipanasʉ́ñ miñzeká shalda namak miñmeyaldikue. Najateja ekí miñzekakue aldéñ miñsanekák zhinik mimagajuekualdixa. Ne axautshikue kaksanegapanaldixa. Aikueja zʉnake aldéñ kajañguamak ashekualdi na, amak iyabuakualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ai jagi shalda miñmeyatokugeki, mieldeki jagik akbini penatshak matshuwi agisaldamakbeñga aldéñga izhgisalshaldixa. Ne ai jagiki mielde bakaldak akjienatshak guaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ekí Duweja anuñka agatsalda ajanashakldegéñ zhinik shizhiyaté aldukatshakna, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, paldiseyukuejañki kauwizhéñga kagatsé ekí guaklde kagajiená. ");
INSERT INTO kog_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Guakna Duwe akugexañ aldiyatshak jiaga, kágubakuejañki “Duweki Jatetshi múldigaba naldiñga zʉxaitshixa shakldá” ajañguatoxakna akugexañ zheñga na kakzukuá. ");
INSERT INTO kog_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Guñgueni Duwe Jesúja mokue ajanashakldegéñ zhinik ekí shizhiyaldá: ");
INSERT INTO kog_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Najate jékaldaxa izhukaja káguba kaksanexaldixa kezhgakukakueki sakí naldaka ne miñmeyaldikue. Aiki ezua sáñkaldaja asukuá numa nexaldixa nalguák zeñ izhajanaldiamak matshuwi abuzatiakue kakbeyaldiamak janaktú. ");
INSERT INTO kog_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Guane nalgué zakukañguake, tuatiakue kakbenekuek ‘au nagakuká ni gu’ kakbeyal ají nashikue kagakagatshak jiaga, nagasʉ́ñ kakzék. ");
INSERT INTO kog_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","”Ekí kakzeguake axautshi ají nashikue abuzál nagakue akbenekuek jiak, ekí kakbeyal kakaxá: ‘Nasukuá abuzakue jeñ janaktú ni gukú. Nají baka, guangatse akldé janshagatsekue tu, guaxal guakldugekue zakuká guakna nagakue zek ni gu.’ ");
INSERT INTO kog_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ekí kakbeyatshak jiaga, axaldukazháldi na san, san aldé, ezuañki ají tezhi, ezuañki jiba axaldaldi ne. ");
INSERT INTO kog_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ezuakueja zʉnake sáñkaldatshi nashikue akugueniki sha akuiñgaba akuaxá. ");
INSERT INTO kog_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Sáñkaldaja ekí ají nashikue akuaxane nukañguakna zʉxaita itsauldi, ají suldáukuek ekí atshanekue kakuaxal, kauwijí kuíbuldu kakiyoxal kakaxá. ");
INSERT INTO kog_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","”Gueni ají nashikuek ekí kakbeyá: ‘Nasukuá abuazaldiamak au jeñ janaktú guanuge. Naldatshak abuzál nagakue kakbenugekueki abuzál nagakue kagatsaldazhánekue ni tuñkú. ");
INSERT INTO kog_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Akna kuíbulduldi, jiúñguldeldi mieldekue miñnabixaldi, aikue niñkauwañki zal nagakue kakbeji miñgualdí.’ ");
INSERT INTO kog_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Akbeñguake amak kuíbulduldi, jiúñguldeldi aldeñgueni atuñguauxa, janshizhekue, shanekue juizhi zatiakue kagabeyá. Amak aldagatshakna asajaldi káguba jialda sʉnék. ");
INSERT INTO kog_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","”Guake sáñkaldaja asukuá abuzál nakldekue katuál eni juldunatshake, ezua sigíki ai niuwañ zhakuá iyatshualdixa itshualdiyazháne tu. ");
INSERT INTO kog_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ekí tuñguakna ekí axaldék: ‘Napebu, ¿sakí shi mañki nasukuá abuzál maldagatshak ai niuwañ zhakuá iyatshualdixa itshualdiazhámalde nakbalde na?’ Guakna akiyokuakue tuakí naldi na nuká nuxa na gua. ");
INSERT INTO kog_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Guake sáñkaldaja ají nashikue ekí atshakue kakbeyá: ‘Ai sigí ipana xaldeki guldak, kasak shiba xaldeki jubaldeldi tuañ zaldi uteya guwíñ. Eni abanekue kakzeshi, zʉxaita abauwi za abaldixakue nzha’ na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","”Ekí miñmeyaldatshake ekí miñmeji: Najate, Saldiñga netshi Jatejañga matshuwi kágubakue kaksanexaldiamak axaldagakue kakbeyatshak jiaga, matshuwi nekueki axaldagasʉ́ñ kakzeka. Akna Jatejañki anuñka me kezhgakuka ne awatuñshixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Guñguake paldiseyukuegaba izhgakualdi na, Duwe Jesúja jigabá guagéñ zhinik nuxa agatsé ne izhakuaxaldiamak janagatú. ");
INSERT INTO kog_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Guakna ezuakue kauwizhéñ na agatsekue, ezuakueki sáñkalda Eldode na agatsekue axaxaxanekueja ekí Duwek agabeyá: —Shi maldazʉñkaldixa, ekí maldazʉñkué, mañki namak za mazukuaka. Ekí namaklde shizhiji na, Jatetshi jiúñguldaki jian nahauxabé shi mizhixa. Mañki me naldaldí, aikueja nuxa sakí jañguakue, atshakue mikbeyatshak jiaga, aibé kaxalduka guabálde. ");
INSERT INTO kog_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Akna sakí majañguxá zʉñmeyá guwá. ¿Aldumatshi sáñkalda akldé akzé akilzabiyakue zʉñsanegamak shi akilzabiyakue naldaka na? ");
INSERT INTO kog_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ekí agaldukatshake kakiyokuéñ zhinik izhakuaxaldixa kakldeshi agaldukatuka Duweja katuakna ekí nuxa kakiyó: —Maiñki namak nakldukabinuka ga abeldashi minakldukatshak jiaga, ¿egaba ji miñkiyokugéñ zhinik nuxa minezhguaxaldixa tuakí shi nakú? ");
INSERT INTO kog_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Akna, ezua muneda sáñkaldak akiyalzabixa natuñsha guwíñ. Kakbeñguake ezua Aldumatshi muneda akualdaguake ");
INSERT INTO kog_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ekí kaklduká: —¿Jeñkáñ metshi waxa shi axaldí mitú? ¿Metshi axezhuka jai aksezheklde shi mitú? ");
INSERT INTO kog_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Guake akiyayó: —Ejiéki sáñkalda akldé akzé Aldumaxa zaldatshi nakldá. Guake Duweja ekí kakbeyá: —Ake, sáñkalda Aldumaxa zaldatshi nake agexal minokldék. Ekibeñga na, Saldiñga netshi Jateke ji agegakue miñgatsahamak miyagexaldí. ");
INSERT INTO kog_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ekí kakiyokuatshakna, “¡sakí ekí jañguanega yokuxá!” ajañgui na, abajañgueniki saldi aldé na akuá. ");
INSERT INTO kog_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ai ldiuwañga na, anuñka saduseyukue Duwe axaldák. Ekuejañki kágubakue ashuanaldinik Jateja mokue kezhgaldakshazháldixa ajañguxakue naldakna ekí agalduká: ");
INSERT INTO kog_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Shi maldazʉñkaldixa, nauwibama Mueséja nasʉñ juldiúkuañ ekí atshakue zʉñmeyanane. Ezua sigí sukua axaldegagáñga shuixaldiake, akaja giemijañga ai tsewa nane gugakue agatsaldaldixa. Ekíki akaja shuane tsaldiñga sukua axaldekldaldixaki, ai shtukua nitshixalga noxaldiamak. ");
INSERT INTO kog_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","”Ekí nalgué atiuwiñ zalguéñ, jai nauwikenáñga zhuakajagaba kugua sigíkue aldalgué, kasak zaldaja munzhi guxane nalgué, sukua axaldegagáñga shuizhá. Guñguake mozhua zeñ zaldaja niñkauwañki ai tsewa nane guxá. ");
INSERT INTO kog_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Guane nalgué, ai jiaga sukua axaldegagáñga shuizhá. Guñguenik egaba maiguaneja guguenik ekí akushiñga kugua aldalguauxa ai munzhi akugatshak jiaga, sukua abajagáñga ashuizhá. ");
INSERT INTO kog_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ekí nuk ashuigueni, aldiweki munzhi jiaga shuizhá. ");
INSERT INTO kog_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ekí zeklde ne, Jateja káguba ashuanaldixakue mokue kezhgaldakshaldixa ldiuwañ zegatshak, munzhi sigí zhuakajagaba kugua axaldane nak, ¿atshake mielde tsewa naldaldixa shi na? ");
INSERT INTO kog_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Guake Duweja ekí kakiyó: —Eñki naldagálde na mijañgú. Jinak naldakí. Jateja ají múldigabake ashuanaldixakue mokue kezhgaldakshaldixa guaká ne miñgajienagába, amak kezhgaldakshaka jiaga kama axaldé jañguakí minák. ");
INSERT INTO kog_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Akze, Jateja káguba ashuanaldixakue mokue kezhgaldakshatshak, jékaldaxaki numa aldegazhítakue. Aikueki Jateja guaklde uldeñkakue numa negazhámakga izhoxaldixakue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","”Ne Jateja ají múldigabak káguba ashuanaldixakue mokue kezhgaldakshaldixa shalda ¿ekí guaka zukuakshabíne shi na? ");
INSERT INTO kog_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nasga na mibama Abaldahámtshi, Isáktshi, Jakóptshi Ajatega nzhakú” guaklde. Akze, Saldiñga netshi Jateki shuanekuetshi Jate naldazhé, ne be nukakuetshi Jatega nakldá. ");
INSERT INTO kog_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ekí Duweja shizhiyaté aldukatshakna, káguba duwá ashekualdekueja “¡sakí ekí shizhixá!” na ajañguá. ");
INSERT INTO kog_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Duwe Jesúja ekí agatsaldi kaxaldegatshake saduseyukue “sakíga ni yokuanakldék” kakldekshazhá guane paldiseyukueja aldukañguake kauwizhéñgaba ajuizhaldék. ");
INSERT INTO kog_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Gueni aikuega na, ezuañki guiyaba muldetua shitiyá guaneja Duwe guajaldiamak akldeshi ekí aklduká: ");
INSERT INTO kog_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Shi maldazʉñkaldixa, Saldiñga netshi Jateja nauwibama Muesék guiyaba zʉñkabajane ¿mielde shi ai guiyaba atsha nexaldixa akldé giemiki akzé naldaka na? ");
INSERT INTO kog_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Guake Duweja Jatetshi múldigabak sezhekldamak ekí akiyó: —“Maiñ Saldiñga netshi Sáñkalda, Mimijatega, e za miñgatsauxa izhgajañgui na, miñnegauxa, mijañguauxa, e za mizhgajañgualdí.” ");
INSERT INTO kog_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jateja guiyaba zʉñkabajanauxaga, jejié guakugé na akldé giemiki akzé atshakue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ai janañga ne, guiyaba mozhua ne akzega, ekí guashi sezheklde: “Maiñ axaldáñ mitsá miyajañguxa nake, kágubakue amaga mizhgajañgualdí.” ");
INSERT INTO kog_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","E guiyaba mozhua me ne na, Jateja ají múldigabak guiyaba izhoxa sezhekldanauxa naldashi ne nakldá. ");
INSERT INTO kog_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ekí guaguenik paldiseyukue ajuizhaldexalga aldoxekuek Duwe Jesúja ekí kaklduká: ");
INSERT INTO kog_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Saldiñga netshi Jateja káguba ikualdal ezua gaxaldixa guakldane shaldaki, ¿sakí shi jañguaminaka na? ¿Metshi atukuaga shi na? Guake akiyayó: —Eñki nauwibama sáñkalda Dabítshi atukuaga naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Guake ekí kakbeyá: —Eñki atukua nuxa nake, ¿sakí shi nauwibamaja Jatetshi Aldunajañga aksanegatshak, ai káguba ikualdal gaxaldixaga “nají Sáñkalda nibaldá” axaldeshi Jatetshi múldigabak ekí gauwanane na? ");
INSERT INTO kog_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Saldiñga netshi Jateja nají Sáñkalda Zʉnekualkak ekí akbeyá: ‘Nas saldiñga aksanegatokugeñga, jibatshugaldi mual akldé akzéñ naldesañ yate guwá. Naski maguldiñkakuek auxaga magubishaldikueñka yo amak mizhoxaldixa nakldá.’” ");
INSERT INTO kog_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ake, nauwibama Dabí aldéñ naldiñga káguba ikualkak “nají Sáñkalda” axaldeklde nake, jiak ¿sakí shi atukua za naldaka na? ");
INSERT INTO kog_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ekí kakbeyatshakna ni meja akiyó akzegazháka atú. Guakna atshak zhinikga ni meja akldé akzʉzukaldixaga izhajanazhá na akuá. ");
INSERT INTO kog_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Guñgueni Duwe Jesúja kágubakue na aldéñ shi kagitixakuañ juizhi ekí zʉñmeyaldá: ");
INSERT INTO kog_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Guiyaba shizhixakue, paldiseyukueki Jatejañga guiyaba nauwibama Muesék zʉñkabajaneja sakí guaká shizhiyaldiamak niuwi kaxaldé. ");
INSERT INTO kog_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Akna, guiyabak zhinik ji atshakue miñmeñkáki amak atshakue miñgatsé. Ne kauwizhéñ kagastuwi amakga atshiji izhoxabináldi. Jinake naldakí. Kauwizhéñki ji atshakue shizhaldiyamak atshiji izhogazhékue nak. ");
INSERT INTO kog_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Aikueki guiyabaja guagauxabé shizhiyagábaki, zʉxaita amak ajanashaksá zalda shizhiji na, axautshikue amak ashekualdaldiamak nauwa nuxaki gaunegagáldekue. Aiki jika juat guasá akzé ezuaja gukubak uldeyaldiamak ikauwatshak, ni nauwa ai uldeji agaunegazhé jana ajanashixa. ");
INSERT INTO kog_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","”Naldatshak egatse ajanashauxa egaba kágubaja katuwi, kakzé kajañgualdiamak itshani nuxa ajanashixa. Akze, nauwisanákueki Jate axazakuagapanatshak ají múldigaba aksezhekldega jikak akué guldak, sʉgáxaldak zhigabañguxa ne, kauwizhéñki zʉ́xaitsha pakue izhgabañguxa. Ekíga na, zhakuá sʉxak shíxalda akldikualdakue ne, kauwizhéñki zʉ́xaitsha zhilduka shíxalda axakldikuekue. ");
INSERT INTO kog_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ekueki juwí izhajuizhaldegeñka aldeyatshak, azhi mieldegaba abuzál aldeyatshak, akldé akzekue iyaldageñka iyaldagazhá guasʉ́ñ akzekakue. ");
INSERT INTO kog_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ekíga na, káguba zheneñka aldeyatshak ‘shi maldazʉñkaldixá’ kaxabeti mual za kaxazakuagakue izhajankakue. ");
INSERT INTO kog_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","”Ne maiñki aldunaldi shi miñkaldiji miñsanekaki ezuamé miñkaldé. Eñki nasga naugé. Akna nasgaba shi minagitixakue, zhuakajagaba nekbine nakna, ezuake miñkabeti akldé miñzé mimatuwi na ‘shi maldaxaldixa nibaldá’ miñkaldegakue itshanabináldi. ");
INSERT INTO kog_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ekíga na, aldunaldiñki zhualduxa ezuamé Jate miñkizhuka. Eñki Saldiñga netshi Jate jékaldaxa izhuka nakldá. Ekí ezuañgaba Jate miñkizhogakna, ezua kagik zalda nuxa akldé akzukuiñga ‘mañki najate nibaldá’ axaldexabináldi. ");
INSERT INTO kog_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ekíga na, aldunaldi miñsanekáki zhualduxa ezuamé miñkizhuka. Eñki Jateja minkualdaldikuamak nakaxanega na nakú. Ekí nas za miñsanekuge miñkizhogakna, ezuake miñkabeti akldé miñzé mimatuwi na ‘mañki aldunaldi maldaksaneka nibaldá’ miñkaldegakue itshanabináldi. ");
INSERT INTO kog_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Akze, mieldeke akldé miñzaldana miñzexaldiake, aike aguáñ zhikzukui, axautshikue kaxazauwakue miñgatsé. ");
INSERT INTO kog_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jinake ekí miñmeyakí. Mieldeki axaldáñgaba akldé zhikzukualdiák jiak, Jateja niñkauwañki aguáñ izhbashaldixa. Ne mieldeki axaldáñgaba aguáñ zhikzukualdiake jiak, Jateja niñkauwañki akldé akzukualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","”Wau wau wau maiñ guiyaba shi mizhixakue, paldiseyukue Jate miñsaneká ga abeldashi mizhekue ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Maiñki juwí akyoshi jana kágubakue Jate jékaldaxa izhukaja kaksanekldana kakzekakue kagitamakui mual miñguxa. Akze, Jateja miñsanegakue jañguabíne, ni axautshikue Jateja kaksanegakue kakldegatshak jiaga, amak kaksanegakue kajañguabíne nzha.  ");
INSERT INTO kog_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","”Wau wau wau maiñ guiyaba shi mizhixakue, paldiseyukue ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Maiñki Jatek akldunamak mizhuká ga abeldashi atshiji, axesé nuxa Jate maldée miyaxazguaka. Ekí miyatshatshakna munzhi sigí ishuanekueki saldiñga nuk mikukakue. Ekí miyatshéñ zhinik na akldé guiyaba tuakue axaminaldaxaldixa. ");
INSERT INTO kog_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","”Wau wau wau maiñ guiyaba shi mizhixakue, paldiseyukue ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Maiñki axautshikue Jate namak mijañgushaldiamak abeldashi atshiji, nauwisaná naldagáldekue jiaga shi miyaxaldiyaldiamak maldée zaldi kagik, níbunik akbaték mineñka. Ekí shizhiji na, amak mimijanamé mijañgushéñ zhinik na, maiñ guiyaba tu za nogakueñka neyakue miñgatsé guashiñki, mutshuizha zeñka miyaxazguxa. ");
INSERT INTO kog_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","”Wau wau wau maiñ uba minsékue jana miné jiaga, axautshikue Jatetshi jiúñgulda tuñshaminaka mitshankakue ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Ekí shi mizhixa nak: Mieldeki ‘juwí Jate axazakuaka te nogéñ zhinik, nas namak atshaldikuamak ni axeldakú’ nekáki axeltenamak atshakue agatsaldazhé. Naldatshak ‘niuba Jate axazakuagaldi abexane sha nogéñ zhinik, nas namak atshaldikuamak ni axeldakú’ neká zʉnake axeltenamak atshakue agatsé miñguaka. ");
INSERT INTO kog_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Maiñ uba minsékue jana alduna miñkaldegagálde mizhekue. Niubaki Jate axazakuagaldi abexanéñ zhinik guana Jatetshi neklde ¿miñsʉ́ñ shi naldaka na? Akna, niuba akzaldaka guashiñki, Jate axazakuagaldi akldé akzega naldashá. ");
INSERT INTO kog_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ekí jiaga shi mizhixa: Mieldeki ‘Jatek jika akiyayoka te nogéñ zhinik, nas namak atshaldikuamak ni axeldakú’ nekáki axeltenamak atshakue agatsaldazhé. Naldatshak ‘ji Jatek agaxene ajuizhakuane aldéñ akiyayogeñka iyashenéñ zhinik, nas namak atshaldikuamak ni axeldakú’ neka zʉnake axeltenamak atshakue agatsé miñguaka. ");
INSERT INTO kog_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Maiñ uba minsékue jana mizhekue. Ji Jatek agaxene aldéñ akiyayogeñka iyashenéñ zhinik guana Jatetshi neklde ¿miñsʉ́ñ shi naldaka na? Akna Jatek agaxene ajuizhakuane akzaldaka guashiñki, Jatek jika akiyayogeñka akldé akzega naldashá. ");
INSERT INTO kog_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ai zhinik na, mieldeki ‘Jatek jika akiyayoka te nogéñ zhinik, nas namak atshaldikuamak ni axeldakú’ negatshak, aik za axakildagagábaki, ji Jatek agaxene ajuizhakuane exa iyashene juizhiñga axakildashi neka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ekíga na, mieldeki ‘juwí Jate axazakuaka te nogéñ zhinik, nas namak atshaldikuamak ni axeldakú’ negatshak, aik za axakildagagábaki, ai juwítshi ajáugukui, Saldiñga netshi Jate eni izhuka nañga axakildashi neka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ekíga na, mieldeki ‘jékaldaxa nahamakga nahéñ zhinik, nas namak atshaldikuamak ni axeldakú’ negatshak, aik za axakildagakí, sanexa xaldoxé, Jate exa saldiñga sanexaldiamak izhuka nañga axakildashi neka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","”Wau wau wau maiñ guiyaba shi mizhixakue, paldiseyukue ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Maiñki Jate akldunamak mizhuká ga abeldashi atshiji, jigaba nóñgutsekue aldubenu azhi jika we akzukualdixa jiba agabeñka uguá agatsalda miñkaldaldaldiake, ezuañki Jatek miyageka. Ekí atshakue miñgatsahamak atshabinogéñ, guiyabajañga jiak akldé akzé atshakue guaká miñjuizhanakí atshalga nogakue ne, ai zʉnake amak atshabíne. Ai akzé atshakueki Saldiñga netshi Jatek za axaldaldi na, kágubakue guañ kajañgui, kaxatshakue miñgatsahamak kaxatshiji izhogakue miñgatsé. ");
INSERT INTO kog_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Naldatshak maiñki ji nóñgutseki amak miyatshatshakna, akldé akzé niñkauwañki amak atshabíneñ zhinik na nik kadzezhá ijulduneki mikuka ne, béyakze atema ijuldune niñkauwañki tuagába, ai nañga mituká jana miyatshixa. Akna uba minsékue jana miné jiaga axautshikue Jatetshi jiúñgulda tuñshaminaka miñnekakue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","”Wau wau wau maiñ guiyaba shi mizhixakue, paldiseyukue ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Maiñki abak nuxa sha atshabíne ga abeldashi mizhekuéñ na, mimijí aldunaldi zʉnake axaldáñ za ajañgui, saldiñga mimijígaba naldakue jañgui mizhuka. Akna jaldu, puti abakaldeldi za iyajishka, sʉkldiñki iyajizhazhé jana ni miná. ");
INSERT INTO kog_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Maiñ paldiseyukue uba minsékue jana miné. Kasak misha mimijí aldunaxa ji nusagatse miñkaldé itshizhi nuk majakue. Ekí mimajatshak guana abak jiaga janshizhe miyatshaldixa. Aiki axáñ misha jaldu, puti sʉkldi muldetua iyajizhatshakna, saldiñga iyajizhanegaba jana naldaldixa. ");
INSERT INTO kog_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","”Wau wau wau maiñ guiyaba shi mizhixakue, paldiseyukue ¡sakí guiyaba mitualdixa ne! Maiñki jian mizhuka ga abeldashi mizhogéñ na káguba shuane kagi iyashaneñka abake janshí ze atuatshak, sʉkldíki shuanetshi abuá galdunatuka, zaldáxalda za abatogéñ jana ni miná. ");
INSERT INTO kog_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ekibeñga maiñki abak nuxa na sha atshabíne ga abeldashi atshabinogéñ, aldunaldi zʉnake shane, naldagálde atshiji, nusagatsegaba mijañguxa. ");
INSERT INTO kog_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","”Wau wau wau maiñ guiyaba shi mizhixakue, paldiseyukue juizhi ¡sakí guiyaba mitualdixa ne! Maiñ Jatek akldunamak izhukakuek miyaxabetixa ga abeldashi atshiji na, Jatetshi múldigaba naldiñga zʉxaitshixa nanekue, Jatek akldunamak jian izhuka nanekue akldé miyakzukualdiamak kauwijí abuá abexananeñka jigabá janshagatse miyagakauxa. ");
INSERT INTO kog_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ne aikueki mimibamakuejañga guaxanane. Naldatshak ekí mineka: ‘Nasʉñ nauwibamakue baxañ zhekuañkaldaldíñki, Jatetshi múldigaba naldiñga zʉxaitshixakue kakuaxaldiamak yo atshazhá guatañkaldalgué nakldá.’ ");
INSERT INTO kog_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ekí minegatshak sha atshalga mizhekuéñ zhinik na mimibamakueja Jatejañga gaxanekue akuaxá ajanashanamakga atshiji mizhuka awatuñshashibiná. ");
INSERT INTO kog_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Akna, mimibamakuejañki Jatejañga gaxanekue akuaxa ajanashiji awalditshigapananane ne, ¡maiñki mashi misʉgakualdixa nake amak isʉgakua guwíñ! ");
INSERT INTO kog_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","”Takbi sha ishkazguamak maiñ abake janshizhe miyatshixa ga abamildagatshak jiaga, sha atshiji nuxa mizhekue miné. Ekí mizhekualdatshakna ¿sakí shi Jateja guiyaba tu za nogakueñka mimakagazháldixa miñnék? ");
INSERT INTO kog_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Akna nasga Jatetshi múldigaba naldiñga zʉxaitshixakue, ají múldigaba shizhixakue, muldetua ishkué ga jañguxakue miñgakaxaldikue. Guanaldixa na, aikuega ezuakueki guaxa miñgualdixa, ezuakueki kaldixa axaldiya guaxa miñgualdixa, ezuakueki mishjuizhaldegeñkaga mipanaldinik kuizhushak miyakldabikshaldixa. Mindakuinekue san san kuíbuldu aldeyauxa kaldiji mineyaldixa. ");
INSERT INTO kog_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ekí miyatshaldiák, Jateja káguba gauñguenik zhinik kaiga yo, aldéñ akldunamak jian zhekuekue akuaxananauxa shalda maiñ miñgatsaldi ne mimatualdixa. Ai akuaxanekue na, kasak misha Abélki jian atshiji izhogué akuaxá guanane. Guñguenik exa zhinik panane ekí kakuashiñga, nauwibama Sakaldiya, Beldekiyatshi asukuák yo akuaxanane. Eñki Jate axazakuagaldi na aldéñ jika akiyayogeñka na, zhikyokuéñ akuaxanane. ");
INSERT INTO kog_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Akna saldiñga ai akuaxanekue shalda na, maiñ kaiga zhekualdabinukakuañ Jateja miñgatsaldi ne mimatualdixa namak ni miñmeñkú.” ");
INSERT INTO kog_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ekí kakbeyatoshiñga na Duweja ekí guak: “¡Jeldusaldéñ zaldakuañ, mitsá maiñ shalda itshaniñgaba izhokuge! Najateja ají múldigaba naldiñga zʉxaitshixakue miñgakagatshak, maiñki sha kakuí, kakuaxa, atshuake jagi kebushi kakuaxa miñguxa. Naldatshak shentája ají awawakue agikalda sʉkldi numañ katuwamakbé, mitsá juizha naski numañ mimatundana nakzegatshak jiaga, amak mimatuasʉ́ñ najañguamine. ");
INSERT INTO kog_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tu guwíñ. Numañ mimatuasʉ́ñ miñzegakna, Najate mimihezua mimabaja gui na, mimijí kuíbuldu nuk miñkibajaldixa. ");
INSERT INTO kog_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ekí miñmeyaldikue. Maiñki ‘¡Jate, nauwijí Sáñkaldaja atsaldí zʉñgakaxaneki, aldéñga zeñ shi jañguí!’ guagakíñgaki mokue natuabináta nzha” na guaxá. ");
INSERT INTO kog_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ekí guaguenik Duwe Jesú juwí Jate axazakuageñka zhinik akzʉxaitatoguéñ, nasʉñ shi kagitixakuañ kaxaldaxeni ai juwí sakí janshagatse ne tuñshaldá. ");
INSERT INTO kog_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Guake Duweja ekí zʉñmeyá: “Namak miñmeyaldikue. Jejié juwí sakí janshagatse mituñkaki niuwizhíneki nuk atiñgualdixa. Amak atiñguatshakna, ni ezua jagi nuxaki zhikté abazháldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Guñgueni gaxa akshá zeñka Oldibuxa kaldeyatshak, Duweki ité noguéñ nasʉñ shi kagitixakuañ kaxaldaxeni ahezuañgaba ekí akldukáñkalde: —Duwe, zʉñmeya guwá. ¿Ekí maldazʉñmeñkáki mitsák amak zexaldixa shi na? ¿Jiñ zhinik shi mokue kagik naxaldá makuxá, auxa zexaldá guxá tuakualdixa na? ");
INSERT INTO kog_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Guñguake Duweja zʉñkiyó: —Muldetua numañ miyatualdí, naldagálde ne namak mimajañgushaldiamak miñgabeyatshak, namak jañgui guamiñnegak. ");
INSERT INTO kog_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Jinake ekí miñmeyakí. Nas mokue kagik nagagá noxaldikueñga, matshuwi nekueki naldagálde nuxa “nasga na Jateja káguba ikualdal nakaxane, aiga na nakú” akuashi miñkiyaldañkatshakna, matshuwi kágubakue namak ajañgushaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Atshakna, san san kagi zaldagaba izhguabiyaldiamak axaukshi guatuka minukatshak, “auxa zexaldiéñ zek guxá nakbaldúk” jañgui zhe miñzegagába. Jinake naldakí. Auxa zexaldiéñ zegagáñgaki ekíga zegakue zaldaldixa, naldatshak jiaga auxa zegagá noxaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ekí zeshi na, ezua saná, axautshi saná na izhguabiyaldiamak axaukshaldixa. Ekibeñga na, sáñkalda san san zaldakuegaba izhguabiyaldiamak axaukshaldixa. Atshak gakue naldaksáñga ne zegatshakna maldija kakualdixa, saldiñga kagi kakshata atemajañ neyaldixa. ");
INSERT INTO kog_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Saldiñga ekí guiyaba atualdixaki aldiwe míñgaki mitsá guiyaba atualdixa shkasa nuxa naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","”Akze, kagik káguba saná zhekuauxa nepanamine shalda nuxa miyaguldiyaldixa niyó. Akna, minapanaldinik sha mimakuí, mimakuaxaldiamak mimaxexaldixa. ");
INSERT INTO kog_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Atshaga na najíkuega, matshuwi nekueki namak najañguaksánaldixa. Aikuega na, namak najañgualga nogatukakue kagualdiji aguldiñkakuek akizhakuashi axaxexaldixa. ");
INSERT INTO kog_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Atshake matshuwi nekue naldagálde nuxa “naski Jatetshi múldigaba naldiñga zʉxaitshikuge na nakú” aldeshi na, matshuwi kágubakue jian kakzukui, kejuldukshaldixa. ");
INSERT INTO kog_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sha atshá akldé akldeñga zeshi na, matshuuwi nekueki ataba atabañ zhinik jiaga ajañguaksá akualdixa. ");
INSERT INTO kog_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Naldatshak mieldeke nas shalda guiyaba tuakue miñgatsegatshak jiaga, abá naldakí nagapa neyal za mishuixaldieñka yo mizhekualdaldiák zʉnake, mimeyakuane jékaldaxa izhoshiñga mizhogataná nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Akze, “Saldiñga netshi Jateja kágubakue kekualdaldinik kaksanexaldixa nakldá” saldiñga kagik zhekuauxa kagabeyaldixa. Ekíki saldiñga saná nahauxaja Jateja sakí kaksanexaldixa aldukaldiamak. Ekí aldukatshak zhinik na auxa zegapanaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","”Mauzeñga Jatetshi múldigaba naldiñga zʉxaitshixa Daniélja sakí zexaldixa shalda ekí kaltak gauwanane: “Niuwizhíne juwí Jate axazakuagaldi ezua diuwi mikzukuakue iyaldagatshakna, auxaga akzaldakualdixa.” (Jalde zukuakshabinukakuañ, sakí guashi sezheklde izhgajieñguá miñgualdí.) Akna amak zegapanká mituatshak, ");
INSERT INTO kog_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Juldeya baxe mizhekualdaldiake akldé gaxa akshá zaldi minakuixaldí. ");
INSERT INTO kog_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mieldeki jutezhaldi izhoxaldiéñ, jika izhgakuxal juldi juldunakue agatsaldazháldi. ");
INSERT INTO kog_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ekibeñga na, mieldeki texa akldoxaldiéñ, ni ají zhakuá nuxaki juldiñga majane izhgakuxal neyagábaki, nakuigakue. ");
INSERT INTO kog_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Amak zegatshakna, munzhi somá axaldegatukakue, somá axaldukakue aldakuigazhákakueki ¡wau wau wau mitsá jibañ atualdixa ne! ");
INSERT INTO kog_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Akna, níxalda bual azhi zhiksekuakue ldiuwañ nakuigakue miñgatseshi guakuak Jate agakuañneshi miñgualdí. ");
INSERT INTO kog_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Jinake ekí miñmeyakí. Atshake atemajañ, zʉ́xaita zalda guiyaba atualdixa nak. Ekí guiyaba atualdixaki, kagi naldapaneni zhinik kaiga yo, ni niuwizhíne jiaga ekí agatsaldi guiyaba atuazhé ni atuazhíta zexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ai guiyaba tuwaki Jateja axañga saldikshaldixa jañguazhá guane guashiñki saldiñga ashuishi, ni me abazháka. Ne aldéñ izhgakuxanekue shalda nuxa na ekí guiyaba tuwa axañga saldikshaldixa jañguane nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","”Atshakna, ezuajañki: “Tu guwíñ. Jateja ezua zʉnekualdal gaxaldixa guaklde ne kagik naklde, jai na izhók” azhi “exa na izhók” miñgabeyaldiák namak ne jañguabináldi. ");
INSERT INTO kog_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Jinake naldakí. Atshakna ezuakueki naldagálde nuxa “nas na káguba ikualdal naklduge na” aldeshi iyaldañkaldixa. Ekíga na, ezuakueki naldagálde nuxa “nas na Jatetshi múldigaba naldiñga zʉxaitshikuge nakú” aldeshi iyaldañkaldixa. Aikue na Jatejañga izhgakuxanekue jiaga mieldeki naldagálde nuxa namak ne kajañgushaka nanake, amak kejuldukshaldiamak kama izhalshaldixa. Ekí ajanashiji na, matshuwi atemajañ ajanashaté atú guazhámak ajanashaldixa. ");
INSERT INTO kog_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Sakí zexaldixa zegagá nogeñga na ekí mimeshkaldukshikú. ");
INSERT INTO kog_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","”Akna, mieldejañki “Jateja ezua zʉnekualdal gaxaneki zʉk zaldi ité nakldók” miñgabeyaldiake aldi tual neyabináldi. Azhi maniñgaba “ziñ me ité nakldók” miñgabeyatshak jiaga, “namak nukshí” jañguabináldi. ");
INSERT INTO kog_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Jinake ekí miñmeyakí. Nas Jatetshi Asukuága ixagabaldeklduge mokue kagik naxaldikuéñ niuwañ zegatshak, saldiñga natundana agatsaldi naxaldikue nak. Atshakna, kuizhbañgui tuba, tuba atshatshak alnoba agatsauxa niuwi nañkajaldi, agajienaldi yo muñshí izguatshak saldiñga tuakuamakbeñga agatsaldi mokue kagik naxaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Aiki ekí jana naldaka: Mashi béyakze shuane gekualdaldiake, eñka guana tuakualdi shexá tinka naldashá. ");
INSERT INTO kog_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ekí zʉñmejiñga na Duwe Jesúja ekí jiaga zʉñmeyá: “Ekí jibañ atualdixa saldinatshak nuxa na niuwiki stuaksáni tuañ itsexaldixa, saxa jiaga tuañ itsexaldixa, alnobaxa zaldakueki wi wi me abatshake zumeyakueki aktinaldixa. ");
INSERT INTO kog_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ekí zexaldinik na, nas Jatetshi Asukuága ixagabaldeklduge mokue kagik naki naxaldá gugé guashi awatualdiamak alnobaxa ezua zegaté atuatshakna, saldiñga saná nahauxakue zʉ́xaita izhajani abauwiñgaba gualdixa. Gualdinik na, kágubakueja atemajañ kama naxaldé, tuasá muñshí zalda nazizhuka mauwixa zabaté nawatualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Atshake tata jananek atemajañ jaldáñ, jaldáñ axazajuigatshaga na, nas guaklduge uldeñkakue gaxanaldikuekuejañki najíkue, Najateja kezhgakuxanauxa nekue maxáiñtaba zahauxa zhinik saldiñga, saldiñga kajuizhakualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","”Ekí miñmeñkugé miñgajienaldiamak kaldi zhenka sakí atshaté mituwéñ zhinik ekí shitiyakue na mimajañgukú. Kaldi axé aktinapanká mituatshake, ‘niuwiya aldaxaldá gualdixa nakbatú’ miñkué. ");
INSERT INTO kog_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Amakbeñga na, sakí zexaldixa miñmeyanugauxa zegapanká mituatshakna, nas naki mokue kagik naxaldá guapankugé miñkualdaldixa. ");
INSERT INTO kog_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Namak miñmeyaldikue. Kaiga ldiuwañ mimisaná ldaxe izhoxabinuka naldalga noxaldieñgaki sakí zexaldixa miñmeyanugauxa amak zexaldixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Akze, alnoba, kagiki naldaksánaldixaga. Ne nají múldigaba zʉnake ni mitsák naldaksá guazhíta nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","”Ekí zexaldixa naldatshak, ji niuwañ, mitsá zegatshak naxaldikueki ezuañgaba Najate, Saldiñga netshi Jateja zañga akué. Ai zhinikga ni meja aksʉ́ñ. Aldéñ guaklde uldeñka jékaldaxa izhukakueja kaksʉ́ñ, ni nas Asukuá naugék jiaga naksʉ́ñ nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","”Akze, nauwibama Nuwé izhogué baxañki, saldiñgaja ‘sakíga ni zexaldí’ kaksʉ́ñ ashekuanamakga, naski Jatetshi Asukuága ixagabaldeklduge mokue kagik naxaldikuéñ niuwañ ekíga ashekualdaldixa. ");
INSERT INTO kog_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Atshak ni maxé zegagá nogueñki ashekuamakga ashekualdi na, zeñ kakldeshi asaji, azatushi, numa aldeshi, kauwijí sukuakue numa nexaldiamak axeshi ashekuanane. Ekí ashekualdatoshiñga, nauwibama Nuwé balku atemak juldunaldiéñ niuwañ yo, ekíga ashekuanane. ");
INSERT INTO kog_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Akze, sakí zexaldixa kaksʉ́ñ noguéñ, ni maxé zalda zegatshak saldiñga ni izhgatushi nija kakane. Ekibeñga, naski Jatetshi Asukuága ixagabaldeklduge mokue kagik naxaldikuéñ kaksʉ́ñ noxaldieñga naxaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mokue naxaldikue niuwañ zegatshak mozhua sigíkue ishkapa texa jiba ajanashatoxaldiéñ, ezuañki awaldeyaldixa, ezuañki abaldixa. ");
INSERT INTO kog_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ekíga na, mozhua munzhikue ishkapa jika abuldiyatoxaldiéñ, ezuañki awaldeyaldixa, ezuañki abaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","”Akze, mimijí Sáñkaldak ji ldiuwañ naxaldikue miñsʉ́ñ nogakna, be noshi, jinaktuál minoxaldí. ");
INSERT INTO kog_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Akze, ekí miñkualdakue. Juwítshi ajáugukuija sesʉñ mitsá zegatshak tusheka naxaldixa akualdi nuka guashiñki, iyatushexal axagajulduni guakuak kabagagába, jiaktuaté nogaka naldashá. ");
INSERT INTO kog_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ekibeñga na, maiñ muldetua janazhiktumine za mizhekualdaldí. Jinake naldakí. Nas Jatetshi Asukuága ixagabaldeklduge mitsák mokue kagik naxaldikue miñsʉ́ñ noxaldieñga naxaldikue nak.” ");
INSERT INTO kog_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ai shaldaga zʉñmeji na ezua atshakldegéñ zhinik ekí guak: “¿Mieldek shi nashi muldetua jañgua atshixa izhuka nak ají sáñkaldaja alduna ishaka jana minaldaldixa na? Ai nashi na ají sáñkaldaja mani neyaldá gualdiake, ají nashikue numañ agatuwi zakukatshake gakue kakauwakue agatsahamak kakauwaldiamak izhaka. ");
INSERT INTO kog_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Amak izhashi nenaldinik, sáñkalda mokue nagatshak, ai nashi sakí atshakue akbenamak axatshaté tuatshakna zeñ jañguxa. ");
INSERT INTO kog_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Namak miñmeyaldikue. Sáñkaldaja ekí ají nashi amak axatshaté tuatshakna, jika axaldauxa numañ agatualdiamak izhaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","”Azhi ai nashiga shane naldi ekí jañgui guashiñki, ‘nají sáñkalda maldé me nagazháldixa shakldá’ ");
INSERT INTO kog_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","akldeshi nashikue aldéñ na agatsekue kabugapanaka. Aldéñki stukakue juizhi zaji, stushi nuxa izhogapanaka. ");
INSERT INTO kog_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ekí atshatogeñga, sáñkalda mitsá zegatshak naxaldixa aksʉ́ñ, jiaktuakí noxaldieñga naxaldixa. ");
INSERT INTO kog_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ekí sáñkaldaja ají nashi amak axatshazháne tuatshakna, guiyaba kaxañ atemajañ tuñshi na, janshizhe izhukakue ga abeldakakue guiyaba atuatogeñkaga gaxaldixa. Exaki guiyaba atuwi na, zʉ́xaita zalda kakzeshi abauwá za aldogeñka nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ekí Duwe Jesú aldéñ jiaktuál nogakue zʉñmejiñga ekí zʉñmeyá: “Niuwizhíne jékaldaxa zhinik kágubakue kaksanexaldikuamak mokue kagik naxaldatshak, sakí jana naldaka ne miñmeyaldikue: Aiki uguá gaiyakue ezua sigí kauwipebu numa nexaldixajañki abuzál neyakue kakbene nalguakna axañga mitshúñ kakté akldabixal aldé. ");
INSERT INTO kog_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ai gaiyakuega na, jatshiwa nekueki muldetua jañguagáldekue jiak, jatshiwa nekueki muldetua jañguxakue. ");
INSERT INTO kog_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Akna, muldetua jañguagáldekuejañki mitshúñ awaldeyatshak, gas mokue akuashaldixa akueki awaldeyazhá. ");
INSERT INTO kog_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ne muldetua jañguxakueja zʉnake mitshúñ awaldeyatshak, gas akué jiaga awaldé. ");
INSERT INTO kog_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Eñka ai numa nexaldixa jiyagatuatoguéñ maldé me nagakí nalguake, saldiñga ubaja kakuiñgaba jeñ axabá. ");
INSERT INTO kog_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","”Guane nalgué, semuanté zegatogueñki jaldáñ ekí axauldá: ‘Au numa nexaldixa nagaté nzhok. Akldabixal kuizaldi.’ ");
INSERT INTO kog_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ekí aldukatshak saldiñga gaiyakue uba kakldeji, ishkaldagueniki kauwijí mitshúñ janagatualdá. ");
INSERT INTO kog_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ekí ajanashatoguéñ na, gaiya muldetua jañguagáldekueja muldetua jañguxakuek ekí axakuañnék: ‘Nauwijí mitshúñ zʉñgisanaldá guak, gas nauwa nuxaki zʉñkáu guwíñ.’ ");
INSERT INTO kog_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Guake kakiyó: ‘Ekí míñgaki auxaga zʉñkaldaldazháka nakna miñkauwazhánazʉnaka. Akna, maiñ naldi nabeyasajeñka izhgajabiyatiyakue miñgatsexaldixa nzha.’ ");
INSERT INTO kog_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","”Guake amak izhgajabiyal aldenaldeñga, numa nexaldixa nak. Naxeniki gaiya muldetua janazhiktunekueki axapañga abuzál kajuldukshá. Gueniki akldé ajuldunazháldiamak juwí akyó na gua. ");
INSERT INTO kog_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Agayoguenik kaiga guana, gaiya janazhiktuazhánekue jeñ aldaxeni numa nexaldixak ‘Duwe, juldunakualdiamak juwí zʉñgakpé ni guakuá’ ");
INSERT INTO kog_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","axakuañnegatshak jiaga, ekí nuxa kakiyó: ‘Namak miñmeyaldikue. Naski mimatuazhúgekue ni tuñkú. Akna miñgakpegazháldikue nzha.’” ");
INSERT INTO kog_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ekí zʉñmeji na ekí zʉñmeyá: “Ekibeñga na, ji ldiuwañ, mitsá zegatshak mokue kagik naxaldikue miñsʉ́ñ nogakna, be noshi, ‘kaigaki nagaté sʉnakldók’ najañgui, jinaktuál minoxaldí. ");
INSERT INTO kog_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","”Akze, jékaldaxa zhinik kágubakue kaksanexaldikuamak mokue kagik naxaldatshak, me jana miñkatshanaka miñmeyaldikue. Aiki, ezua sigí maldé zaldi neyaldixa nalguák, ají nashikue kexaulguenik: ‘Jejié nají paldata akldé nakizhikldexaldiamak numañ tuwi jiba naxakbeyal minoxaldí.’ ");
INSERT INTO kog_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Amak kagegapanatshak ezua, ezua mitsá numañ agatuakldegauxabé alduna ishaka katuwi kagé. Akna ezuake paldata akzegaba jatshiwa muksú jialda agé, ezuake paldata akzegaba mozhua muksú jialda agé, ezuake paldata akzé ezua muksú jialda agé. Ekí kageguenik maldé zaldi ne na gua. ");
INSERT INTO kog_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Guake nashi jatshiwa muksú jialda agenejañki ubañga paldata jiba axakbeji mokue mutshuizha akizhikldekshá. ");
INSERT INTO kog_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ekíga na, nashi mozhua muksú jialda agenejañki paldata jiba axakbeji mokue mutshuizha akizhikldekshá. ");
INSERT INTO kog_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ne nashi ezua muksú jialda me ageneja zʉnake kagi akuiyá guñgueni eñ kagi ishá. ");
INSERT INTO kog_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","”Guñgueni anuuñka zegatogueñki, nashikuetshi sáñkalda mokue naguenik, ají paldata mitsá akizhikldekshane kagatuwexañ kajuizhakuá. ");
INSERT INTO kog_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Guake jatshiwa muksú paldata akzegaba ipananejañki jiak, jatshiwa ipá uldashi ekí akbeyá: ‘Duwe, mijí niubagaba jatshiwa muksú nagemalde nañga mokue jatshiwa mikizhikldekshanuge jai tiuwi.’ ");
INSERT INTO kog_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Guake sáñkaldaja akiyó: ‘Mañki nají nashi janshibé amak za naxatshamalde nukshí. Nají paldata nauwamé ne jiaga, muldetua jiba naxakbeyakuamak naxatshamalde shalda kaiga míñgaki, akldé alduna mishiji na, akldé jika numañ maldagatualdiamak mizhaxaldikue. Akna nas nañga zeñ shi mikldeshí.’ ");
INSERT INTO kog_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","”Guñguenik jiak, nashi mozhua muksú paldata akzegaba ipananejañki ají sáñkaldak axaldeñgueni ekí akbeyá: ‘Duwe, mijí niubagaba mozhua muksú nagemalde nañga mokue mozhua mikizhikldekshanuge jai tiuwi.’ ");
INSERT INTO kog_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Guake sáñkaldaja ekíga akiyó: ‘Mañki nají nashi janshibé amak za naxatshamalde nukshí. Nají paldata nauwamé ne jiaga, muldetua jiba naxakbeyakuamak naxatshamalde shalda kaiga míñgaki akldé alduna mishiji na, akldé jika numañ maldagatualdiamak mizhaxaldikue. Akna nas nañga zeñ shi mikldeshí.’ ");
INSERT INTO kog_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","”Guñguenik jiak, nashi ezua muksú paldata akzé ipananejañki ají sáñkaldak axaldeñgueni ekí akbeyá: ‘Duwe, mijí nashikue tu me guabálde, axautshikue jibañ naldi jiba ajanashane zhiksuishi mizhuka. ");
INSERT INTO kog_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ekí maldakué naldi na, zhe maldakzukuatshakna, mijí niuba migitshuanazháldiamak kagi ishá nuxa guanuge. Akna mijí niuba nagemaldauxaga jaiga tiuwi.’ ");
INSERT INTO kog_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ekí akbeñguake, ají sáñkaldaja ekí akiyó: ‘Mañki nashi shane, miwa mikzeka nukshí. Tukí naski axautshikue jibañ naldi jiba ajanashane zhiksuishi izhokuge mikualdi nak míñgaki, ");
INSERT INTO kog_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","paldata zhikldegeñka nauwa nuxaki nakizhikldexaldiamak nakibexa guakue migatsane naldashá. Ekíki mokue naxaldatshake, nauwa akldé nuxaki nakizhikldeklde ipanaldikuamak.’ ");
INSERT INTO kog_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","”Guñguenik exa zhekualguekuek ekí kakbeyá: ‘Jaldek paldata akzé ezua muksú agenuge ikuxa xaldeki nashi paldata akzegaba uguá muksú axaldék niñkauwañki agé guwíñ. ");
INSERT INTO kog_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Jinake ekí miñmeyakí. Mieldeke ji axaldé muldetua jiba akbeyakuamak jiba akbeñka naldaldiake, jiak akldé agaxexaldixa. Akna agajueshka guashiñki zʉ́xaita axaldaldaldixa. Ekí ne, mieldeke ji nauwamé nuxa axaldé muldetua jiba akbeyakí naldaldiake, ji nauwamé axaldauxagaba iyakuxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Akna jalde nashi muldetua naxazauwazhéki ipana xaldeki jubaldeldi tuañ zaldi uteya guwíñ. Eni abane izhgastuatshakna zʉ́xaita akzeshi, mauwiñgaba za abaldixa nzha.’” ");
INSERT INTO kog_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ekí zʉñmejiñga ekí jiaga zʉñmeyá: “Niuwizhíne nas Jatetshi Asukuága ixagabaldeklduge mokue kagik naxaldatshak, zʉ́xaita muñshí zalda nañga, Jateja guaklde uldeñkakue auxaga juizhi naxaldikue. Ekí agatsaldi naxaldatshak, naski zʉ́xaita muñshí zalda nañga sanexaldikuamak sanexa xaldoxéxa yaldaxaldikue. ");
INSERT INTO kog_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Exa na, káguba saná nahauxa nastakgaba naxajuizhakualdixa. Atshakna jubeju numañ tuñkaja jubejukue tshibuk zhinik agajuekuamakbeñga, naski saldiñga sanákue mozhua nalda kezhgajuekualdikue. ");
INSERT INTO kog_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ekí kezhgajuekui na, káguba amak naxatshixakueki jibatshugaldi mual katsheñgui, amak naxatshazhékueki jibatshazhúgaldi mual katsheñgualdikue. ");
INSERT INTO kog_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","”Gualdinik na nasga saldiñga aksanekugek jibatshugaldi mual zhekuekuek ekí kakbeyaldikue: ‘Maiñ Najate zeñ mimajañguanekuek, aldéñ kagi gauwatshaga bieni miñgeshi jana zeñ mimajañguakue nahauxa janamiñgaktune mipanaldiéñ zek na gu. Akna aldéñ sanegatogéñ juldú guwíñ. ");
INSERT INTO kog_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Jinake naldakí. Maldi nakuí guatoguéñ gakue nakaumine. Ni naklduni guatoguéñ tuxaldikuamak ni nakaumine. Natuabíne nalgué jiaga, mimijúk muldetua nazipanamine. ");
INSERT INTO kog_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Zhakuá nagajuezhi guatoguéñ nazijualdimine. Mulbatá nakzeshi guatoguéñ numañ natumine. Kalseldi izhogatogukuéñ naxabizhamine nak.’ ");
INSERT INTO kog_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","”Ekí kakbeyaldatshakna amak naxatshixakueja ekí nagabeyaldixa: ‘Nauwijí Sáñkalda, ¿mitsák zalguéñ shi maldi makuí guatoguéñ gakue mikáu gakuñgú? ¿Azhi mitsák zalguéñ shi ni miklduni guatoguéñ matuxaldiamak ni mikáu gakuñgú? ");
INSERT INTO kog_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Azhi mitsák zalguéñ shi matuañkáalde nalgué jiaga, nauwijúk muldetua mipana gakuñgú? ¿Azhi mitsák zalguéñ shi zhakuá migajuezhi guatoguéñ mijualdi gakuñgú? ");
INSERT INTO kog_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Azhi mitsák zalguéñ shi mulbatá mikzeshi guatoguéñ numañ matú gakuñgú? ¿Azhi mitsák zalguéñ shi kalseldi mizhoguéñ mixabizhá gakuñgú?’ ");
INSERT INTO kog_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","”Ekí nagabeyatshakna, nas saldiñga aksanekugek ekí kakiyokualdikue: ‘Namak miñmeyaldikue. Mitsakgaba ezua nají nekldekue ai itsaldagálde axajankakue janshizhe miyaxatshatshakna, nasga naxatshamine nakldá.’ ");
INSERT INTO kog_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","”Gualdikueni jiak, jibatshazhúgaldi mual zhekuekuek ekí kakbeyaldikue: ‘Maiñ guiyaba tu za nogakueñka mineyaldiamak agatsaldi zhekuaminekuañki nagajuezha guatogwíñ. Jai zhinik guksé puldal za nugeñka newiñ. Exaki Jateja jisé, ají aldunakue juizhi guiyaba katuñshaldiamak janaktú guaneñka. ");
INSERT INTO kog_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Jinake naldakí. Maldi nakuí guatoguéñ ni ji gakue nakauwazhá guamine. Ni naklduni guatoguéñ tuxaldikuamak ni ji nakauwazhá guamine. ");
INSERT INTO kog_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Natuabíne minatuatshak mimijúk nazipanazhá guamine. Zhakuá nagajuezhi guatoguéñ nazijualdiyazhá guamine. Mulbatá nakzeshi guatoguéñ numañ natuazhá guamine. Kalseldi izhogatogukuéñ naxabizhazhá guamine nak.’ ");
INSERT INTO kog_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","”Ekí kakbeyaldatshakna amak naxatshazhékueja ekí nagabeyaldixa: ‘Duwe, ¿mitsák zalguéñ shi maldi makuí guatoguéñ, azhi ni miklduni guatoguéñ, azhi zhakuá migajuezhi guatoguéñ mikauwazhá gakuñgú? ¿Azhi mitsák zalguéñ shi matuañkáalde, azhi mulbatá mikzeshi guatoguéñ, azhi kalseldi mizhoguéñ migaunegazhá gakuñgú?’ ");
INSERT INTO kog_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","”Ekí nagabeyatshakna, ekí kakiyokualdikue: ‘Namak miñmeyaldikue. Mitsakgaba ezua nají nekldekue ai itsaldagálde axajankakue janshizhe kaxatshazhá miñguatshakna, nasga naxatshazhámine nakldá.’ ");
INSERT INTO kog_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","”Akze, amak naxatshazhékueki guiyaba tu za noshiñga nogakueñka aldeyaldixa. Amak naxatshixakue zʉnake jékaldaxa, nas nañga izhoshiñga izhoxaldieñka aldeyaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ekí Duwe Jesúja auxa shizhiñgueniki nasʉñ shi kagitixakuañ ekí zʉñmeyá: ");
INSERT INTO kog_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Maiñki miñkuamakga na, moshik zhiniki Jateja nauwibamakue san kagixa guiyaba atuwi ashekualgueñka zhinik kakzʉxaitshanéñ ldiuwañ be izhgisekui kajuizhaldegéñ zexaldixa. Atshaga na, nas Jatetshi Asukuága ixagabaldeklduge kaldixa naxaldiya nakuaxaldiamak aguldiñkugekuek naxaxexaldixa nakldá” na zʉñmeyá. ");
INSERT INTO kog_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Atshakna, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, nauwisaná nauwa akldé akzekue juizhi, Jatek múldigaba agaskaitshixa akldé akzé Kaipás nugeñka ajuizhaldék. ");
INSERT INTO kog_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ekí ajuizhaldegatshaga, Duwe Jesú sakí ziñgaba akuxaldinik akuaxaldixa janagatualdá. ");
INSERT INTO kog_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Guatshak kauwizhéñgaba ekí izhgabeyá: “Kajuizhaldegamak juizhaldexalga kaldoxaldiéñ guxa guanazʉñnegake, kágubakue kaukshishanazʉnaka nakna, atshake guxañkaldáaldi.” ");
INSERT INTO kog_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Duwe Jesúki kuíbuldu Betaniaxa izhoguéñ, Simóñ ajuba ikalduni akzeka nane tshuxa ne. ");
INSERT INTO kog_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Exaki ezua munzhija we juma izhuka maldée akzé jika janshagatsék akué aksui naxeni Duwe zatoxeñki sáñkaldeldi itsú. ");
INSERT INTO kog_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ekí itsukuaté katuatshakna, nasʉñ shi kagitixakuañ atshasʉ́ñzamak atshixá jañgui ekí zhikbeñkalde: —¿Sakí zhinik ejié we juma izhuka ekí itshuakshixá? ");
INSERT INTO kog_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ekí guagábaki, maldé akzaldi nabesá xaldeki aiki nashi jika agajueshkakuek akáu guakue ne. ");
INSERT INTO kog_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ekí zhikbeyañkalduka zʉnatuatshakna Duwe ekí zʉñkaldék: —¿Jinak jejié munzhi ekí nalda miyaguaká? Ekí netsukuatshake, janshibé naxatshiji akldé nakzukuashá. ");
INSERT INTO kog_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Akze, nashi jika agajueshkakueki miñkizhoxalga noná. Ne nas zʉnake miñkizhoxal za nogazháldikue. ");
INSERT INTO kog_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ekí nakna, jejié munzhijañki we juma izhuka netsukuatshake, axañga nají abuá abexaldixa janaktuwi guana naxatshashá. ");
INSERT INTO kog_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Namak miñmeyaldikue. Saldiñga kagi nahauxa Najateja káguba ikualdal nakaxane shalda akuagatshak, jejié munzhi sakí naxatshane be kagiseshi, akuaxalga noxaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Guñgueni Duweja 12 shi kagitixakue zʉnezhgakuxanega Juda Iskaldiute axezhukaki Jatek múldigaba agaskaitshixakuetshi sáñkaldakue tual neñguenik ");
INSERT INTO kog_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ekí kakbeyá: —Naski Duwe Jesú miñguxaldiamak miñgaunék guanugake, ¿mitsá nakzabiminaka ne? Guake kauwijí paldata akzegaba 30 agasabí. ");
INSERT INTO kog_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Atshak zhinik na, aldéñki mitsakgaba Duwe kagexaldiamak niyaldá na gua. ");
INSERT INTO kog_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Amak Jateja nauwibamakue san kagixa guiyaba atuwi ashekualgueñka zhinik kakzʉxaitshanéñ ldiuwañ be izhgisekui pañ ishkishshixa akjiukualdagálde kakajéñ zegapanakna, nasʉñ shi kagitixakuañ Duwe kaxaldaxeni ekí akldukáñkalde: —¿Mani shi ai gakue janaktuakue maldazʉnajañgú? ");
INSERT INTO kog_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Guake ekí zʉñmeyá: —Maiñ kuíbulduxa ai tshuxa mineyaldiniki ekí miyakbeyaldí: “Shi zʉñkaldixaja ekí ni makuaxá: ‘Jateja niuwi jananagaktunéñ naxakldañkaldá na gu. Kaiga ldiuwañ zeñ zʉñneshi katsahamak, naski mijúk nas shaxaldikugekue juizhi zaldikue nzha.’” ");
INSERT INTO kog_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ekí zʉñmeyatshakna nasʉñ na agatsekuek kakbenaldamak axajanashiji eñka gakue janagatú. ");
INSERT INTO kog_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Guñguenik tuañ zegapanatshake, Duwe nasʉñ 12 shi kagitixakue juizhi zaldiamak yaté. ");
INSERT INTO kog_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Amak zañkaldoguéñ ekí zʉñmeyá: —Namak miñmeyaldikue. Ezuak maiñga nezhguashi aguldiñkugekuek minagexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ekí zʉñmeyatshakna, itshaniñgaba ezuak, ezuak ekí akldukapánañkalde: —Nají Sáñkalda, ne ¿nas shi amak makuanaka maldajañgú? ");
INSERT INTO kog_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Guake ekí zʉñkiyó: —Ezuak maiñ nas gatokugéñ zabinukakga na nezhguashi aguldiñkugekuek nagexaldixa. ");
INSERT INTO kog_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Akze namak, naski Jatetshi Asukuága ixagabaldekldugeke, ají múldigabaja guagamak shuigakuega nagatsaldaldixa. Naldatshak, nezhguashi nakenaldixa zʉnake ¡mitsá atemajañ guiyaba tualdixa ne! Akna kukazhá guanaldíñki akldé janshibé naldatalgué. ");
INSERT INTO kog_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Gueni ai Duwe gegatuka Judajañki ekí akbeyá: —Shi maldaxaldixa, ne ¿nas shi amak makuanaka maldajañgú? Guake Duweja: —Mañga namak ni makuák. ");
INSERT INTO kog_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ekí zañkaldogueñga na, Duweja pañ zhiksuishi, Ajatek ai shalda “zeñ nzhakldék” akbeñguenik nauwa, nauwa zhikwatiji zʉñgegatshak ekí zʉñmeyá: —Jejié pañki nají abuá tsaldiñga ne nagipana xaldeki ga guwíñ. ");
INSERT INTO kog_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Guñguenik jaldu, kalwéldia siyagaxaune akué zhiksuishi, Ajatek ai shalda “zeñ nzhakldék” akbeñguenik ekí zʉñmeji zʉñgé: —Minauxaga jejié kalwéldia nauwa, nauwa tuxa guwíñ. ");
INSERT INTO kog_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Akze, jejié kalwéldiaki nají abi tsaldiñga ne. Ai na, káguba matshuwi nekue sha ajanashixa kaxabetaldiamak abi nakzuldi nakuaxaldiéñ naki zexaldá na guapán. Amak shuixaldatshak, Najateja minkualdaldiamak e na ishkualdi izhoxa abisa jiúñgulda miñgexaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ne ekí miñmeyaldikue. Auxa zegatshak, Najateja saldiñga kaksanexaldiéñ zegagá noxaldieñgaki mokue maiñ juizhiñga ai kalwéldia siyagaxaune tugazháldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Gueni Jate auxa kaxazbeñgueniki, gaxa akshá zeñka Oldibuxa saldi neñkalde. ");
INSERT INTO kog_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Exa kaldeñguenik Duwe Jesúja ekí zʉñmeyá: —Kaiga siañga na, maiñki alduna nazishabiñsáni nuk nagajuezha miñgualdixa nakldá. Jinake ekí miñmeyakí. Jateja nashaldá ají múldigabak ekí guashi sezheklde nak: “Nají jubeju numañ nagatuñkaki nasga shanekuek guakshaldatshake jubejukueki ezua, ezua nuk axajuezhaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Naldatshak shuixaldikuenik mokue izhgaldaxaldatshak miñsajañga Galdildeya baxe neyaldatshakna, exa mokue mimeshjuizhakualdikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ekí zʉñmeyatshakna Péguldujañki ekí akiyó: —Saldiñga mabaja akualdiák jiaga, nas zʉnake ni mitsák mabajazháldikue, migapa za neyaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ekí akbeyatshakna, Duweja akiyó: —Namak mikbeyaldikue. Kaiga siañ gayu kauldagá noxaldieñga, mañki maikjuizhañga “eñki tuazhúge nzha” maldakuaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ekí akbeyatshak jiaga, Pégulduja ekí zañga akiyó: —Amak ma nañga shuigakue nagatsexaldiák jiaga, ni mitsák “eñki tuazhúge nzha” makuagazháldikue nakldá. Ekí negatshakna saldiñga nasʉñ shi kagitixakuañ jiaga ekígaba na kaxaldexá. ");
INSERT INTO kog_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Guñguenik Duwe Jesú nasʉñ shi kagitixakuañ juizhiñga Jetsemaní axezhogeñka neyatshak ekí zʉñmeyá: “Maiñki jai iteté nogwíñ, naski uñguexa Jate nugaxazguashi.” ");
INSERT INTO kog_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ekí zʉñmeji na, Péguldu na Zebedeyutshi asukuákue Juañ, Santiaku na nauwa agajué zeñka agapa kauldeyeni Duwe aldunaxa akzekága itshaniñgaba akzeshi na ");
INSERT INTO kog_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ekí kakbeyá: “Aldunaxa señgaba nakzegaksáni, itshankugega nuxa shuixaldá gugé jana ni nakzegapán. Maiñki jai abá xaldeki, nas na kabagagába stuaté nogwíñ.” ");
INSERT INTO kog_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ekí kakbeñgueniki jiak, nauwa agajué zeñka neyatshak, Jate axazguaxaldiamak waxam pani ekí akbeyaldá: “Najatée, guiyaba atemajañ tuwi shuigakue nagatsaldaka nakualdatshak jiaga, ma ekíga najañguamildaka guashiñki, guiyaba tuakue naxazguakí naldatabaldaldé naldaka. Naldatshak, nas jañgugamak zekuagába, ma maldajañguamak zʉnake zekuakue ni majañgukú.” ");
INSERT INTO kog_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ekí axazguagueniki mokue maigua nekue nugeñka nagatshake, kabanekue sha sha katuakna uba kakldeñshi Pégulduk ekí axaldék: “¿Maiñki ni nauwa maldé nuxaki nas na kabagagába stuaté nogazháminaka shi na? ");
INSERT INTO kog_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kabagagábaki be noshi, Jate axazguaxal nogwíñ, jiséja sha atshakue miñsanegatshak, amak atshabináldiamak. Akze, aldunaldiñki nabajasʉ́ñ miñzegatshak jiaga, maiñgabaki auxaga kama miñkaldaldazháka nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Gueni mutshuizhane neyeniki Ajate ekí akbeyá: “Najatée, ai guiyaba atemajañ tuwi shuigakuega nagatsé nake, ma maldajañguamak za shi nagatseshí.” ");
INSERT INTO kog_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jiak ekí axazguagueniki mokue maigua nekue nugéñ nagatshake, ubajañga kagubiyane axabanekue sha sha katú. ");
INSERT INTO kog_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Guake mokue kabajeniki, maikjuizhane Ajate axazguashi axañga akbenaldamakga akbeyá. ");
INSERT INTO kog_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Gueniki mokue shi kagitixakuañ zʉñkaldagatshak ekí zʉñkaldék: “¿Maiñ zʉnake zhiksekui, kabaxalga shi minók? Tu guwíñ. Nas Jatetshi Asukuága ixagabaldeklduge neyazhakuashi sha atshixakuek naxaxexaldiéñ zek guashá. ");
INSERT INTO kog_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nakexaldixaki uñkuahí na nagapán. Akna, jeñ izhgaté xaldeki e nagatogaldi kuizaldi.” ");
INSERT INTO kog_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ekí guaxal nogueñga Duwe Jesú 12 shi kagitixakue nasʉñ nañga agatsé Judaki axaldák. E nañga na, kágubakue duwá zhikzhe Duwe akuxaldiamak shezhá, kaldi juizhi kaksui axaldák. Ai guxaldixakueki Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, nauwisaná nauwa akldé akzekueja kakaxanekue. ");
INSERT INTO kog_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Axañga Juda, Duwe gexaldixaja aikuek ekí kakbenane: “Nas mieldeki izhgajañgugé jana agatsaldi gualdikuake, ai miñguxaldí.” ");
INSERT INTO kog_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ekí kakbenalguamakga na Duwek axaldagueni: —Shi maldaxaldixa, ¿sai maldoxé? —axaldeshi jañguxá jana agatsaldi gua. ");
INSERT INTO kog_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Guake Duweja akiyó: —Napebu, atshál nakbaldamak atshiwá. Guake aldakldekueja Duwe axaldaxeni iyapani amak akuxá. ");
INSERT INTO kog_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Guakna ezua Duwe na izhoxejañki ají shezhá ishkaklduguenik Jatek múldigaba agaskaitshixa akldé akzetshi nashi agisalshiñga tuan kuxa axabeñguá. ");
INSERT INTO kog_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Guake Duweja ekí axaldék: —Shezhá mexa guatogwá. Akbiñgaki saldiñga shezhák kaukshixakueki, jiak eñkañga ashuixaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ekí miksʉ́ñ shi naldaka na? Nas Najate jékaldaxa izhuka agakuañnexaldatshak, ubañga aldéñ guaklde uldeñka izatasá nekue yo nakuál nagakagaka ni matú. ");
INSERT INTO kog_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ne Najateja ají múldigabak aldéñga káguba ikualdal ezua gaxaldixa guakldaneki guiyaba tuwi shuigakue agatsaldaldixa guashi sezhekldane. Ekí nashaldá guaka ne, Najate nagaunegakue agakuañnek guanugake, ¿ají múldigabaja guagamak sakí shi amak zegaka na? ");
INSERT INTO kog_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Atshaga na, aldéñ guxal nakldekue ekí kaxaldék: —Maiñ natuwiñki, ¿kágubakue sáñkaldak kaugakshishikuge nak shi ekí agatsaldi shezhá, kaldi juizhi nakuxal minák? Akze, naski niuwi neyauxa juwí Jate axazakuageñka shizhiji izhoxaldatshak jiaga, exaga ni mitsák nakugazhámine. ");
INSERT INTO kog_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Naldatshak saldiñga ekí zegatukaki, Najatetshi múldigaba naldiñga zʉxaitshixakueja aldéñga káguba ikualdal gaxaldixaki sakí agatsexaldixa guakldane amak nagatsexaldiamak zegatuka nakldá. Guatshake saldiñga nasʉñ shi kagitixakuañki Duwe ahezua kabajeni, nuk nakuishiñga ne na kakuá. ");
INSERT INTO kog_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Guñgueni Duwe Jesú akuxanekueja Jatek múldigaba agaskaitshixa akldé akzé, Kaipás nugeñka awaldé. Exaki nauwisaná nauwa akldé akzekue, guiyaba shizhixakue ajuizhaldeklde aldoxeñka. ");
INSERT INTO kog_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ekí Duwe awaldeyatoxeñga Pégulduki atuasánamak aldiwan nejiñga, Jatek múldigaba agaskaitshixa akldé akzetshi jubaldaxa, jueyáñ zeñka me ne. Exa juldungueniki sakí zexaldixa tualdiamak exa zalda kabukue na iyaté na gua. ");
INSERT INTO kog_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Eniñga na, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, akldé akzekue sanekakuegaba mieldejañki naldagálde nuxa Duwe Jesú sha atshane agatsaldi ne izhakuaxaldiéñ zhinik na shuigakue agatsé axeyaldaxaldiamak aldiyatshak jiaga ");
INSERT INTO kog_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kakzaldazhá. Akze, matshuwi nekueja naldagálde nuxa Duwe “agatsé nzha” izhakuagatshak jiaga, kaxagatsegazhá. Aldiweki mozhua nekueja ");
INSERT INTO kog_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ekí Duwe izhakuák: —Jejié sigíjañki: “Nas zʉnake juwí Jate axazakuaka tiñguanaka, jiak maiguake mokue gauwanaka nakldá” neka. ");
INSERT INTO kog_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Guakna, Jatek múldigaba agaskaitshixa akldé akzé izhgaldaxeni ekí Duwek aklduká: —Ekí mezhakuagatshak, ¿ji shalda ekí mezhakuaká shi mikldék? ¿Mañgaba zhikzukuashi kakiyokuabaldáldixa shi na? ");
INSERT INTO kog_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ekí akldukatshak jiaga, Duweki sʉnjá izhó. Guakna ekí axaldék: —Saldiñga netshi Jate izhoshiñga izhogamakga izhogéñ, mañki aldéñga Asukuá zʉnekualdal gaxaldixa guaklde, aiga maldake axazʉñgilté guwá. ");
INSERT INTO kog_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Guake Duweja akiyó: —Mañga, ai naugé namak nakuák guashibaldá. Ekí jiaga miñmeyaldikue: Niuwizhíne Saldiñga netshi Jateki auxaga kama aksuikue, saldiñga aksanegatogeñka, nas Asukuága ixagabaldekldugek jibatshaldi mual akldé akzeñka izhogaté minatualdixa. Ekíga na, jékaldaxa zhinik mauwixa mokue zabaté minatualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ekí guagatshakna Jatek múldigaba agaskaitshixa akldé akzejañki akldunasʉ́ñ neká awatuñshi na zhakuá izhgitshizgui ekí guak: —¡Jejié sigíja Jateki aguáñ izhbashi mual zukuaká nuká guashibiná! Ekí agatsaldi zukuagaté kaldukatshakna, kaiga mokue e agatsaldiñga ne zʉñmeyaldixa zʉñgajuezhaksá ");
INSERT INTO kog_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","guakna, ¿sakí agatsegaka miñguaxaldixa shi na? —Eñki shuigakue agatsé ni katú —akiyayó. ");
INSERT INTO kog_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Guakna, ezuakuejañki Duwe waxak jutú iyatuañgui, agaldabikshá. Ezuakuejañki waxa axabushi na ");
INSERT INTO kog_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ekí axaldék: —Mañki Jateja zʉnekualdal makaxane maldeka, ji atuazháka jiaga tu makuamak nake, ¿me shi mabúk? Zʉñmeya guwá. ");
INSERT INTO kog_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ekí zegatoguéñ Pégulduki eniñga jubaldaxa, jueyáñ zeñkaga ité noxeñki, ezua munzhi eniñga jibatshixaja axaldaxeniki ekí akbeyá: —Ma jiaga Jesú Galdildeyaxa zalda nañga izhomalde nakldá. ");
INSERT INTO kog_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ekí akbeyatshak, saldiñga aldukatoguéñ Pégulduja tuazhé guashi ekí guak: —Naldagálde, jinak ekí maldakuaká, naksʉ́ñ giemi nzha. ");
INSERT INTO kog_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Guñgueniki Péguldu julduneñka neyatshake mokue ezua munzhi eniñga jibatshixaja tuatshak ai izhoxekuek ekí kakbeyá: —Jejié sigí jiaga Jesú Nasaldéxa zalda nañga izhone nakldá. ");
INSERT INTO kog_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ekí nukatshak jiak, mokue Pégulduja: —Miya, “naski e tuazhúge giemi nakldá” ni axamiñkildakú. ");
INSERT INTO kog_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Guñgueni jiak, nauwa maldé zegatogueñki, exa zhekualdekueja Péguldu axaldaxeni ekí axaldék: —Ma jiaga Jesú agapa neñkakue zukuagamak mazukuagéñ zhinik na e na izhomaldega zʉñkualdaka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Guake Péguldujañki: —Nas namak guagakí naldikuake, Jatega shi guiyaba natuñshí. Akna namak axamiñkildashiñga na: “Ai sigí tuazhúge giemi nzha.” Ekí guagatshaga na, gayu kauldá na gua. ");
INSERT INTO kog_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ekí kauldatshaga, Duweja axañga sakí akbenane Pégulduja be agisék: “Kaiga siañ gayu kauldagá noxaldieñga, mañki maikjuizhañga ‘eñki tuazhúge nzha’ maldakuaxaldixa nakldá.” Ekí be agiseguakna ai zhinik akzʉxaitiñgueniki, zʉ́xaitsha itshankága mauwiñgaba na gua. ");
INSERT INTO kog_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Guñgueni muñzeguake saldiñga Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, nauwisaná nauwa akldé akzekue ajuizhaldeshi, Duwe Jesú sakí akuaxaldixa izhgakualdi aldoxaldá. ");
INSERT INTO kog_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Akna Duwe shiyabanega sáñkalda Pildatuk akualdé. ");
INSERT INTO kog_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Guñgueni Duweki shuigakue agatsé axeyaté guane, e izhguaklde Judaja nukatshakna, “¿jiná nakldeguák shi ekí gegukú?” akldeshi na, matshuwi itshaná. Ekí itshani na, Jatek múldigaba agaskaitshixakuetshi sáñkaldakuek, nauwisaná nauwa akldé akzekue nugeñka neñgueni Duwe kagexaldiamak paldata akzegaba 30 agaxene mokue kagishkualdikshiji ");
INSERT INTO kog_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ekí kakbeyá: —Ezua sigí agatsaldazhé ne jiaga akuaxaldiamak izhguaxaldatshak sha atshanuge ni atuñkú. Guake ekí akiyayó: —Nasʉñga ai tuakue zʉñgatsaldakí. Eñki mijí kaxa ni naldatók. ");
INSERT INTO kog_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ekí agabeñguake, Judaja ai paldataki juwí Jate axazakuagaldi kaguteyá. Eñka zhinik neñgueniki, aldéñgaba shilté shuizhá na gua. ");
INSERT INTO kog_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Guñguake ai paldataki Jatek múldigaba agaskaitshixakuetshi sáñkaldakueja apegueniki kauwizhéñgaba ekí izhgabeyá: —Jejié paldataki ezua akuaxaldiamak jiba akbeñkalde nak, guiyabaja guagamake mokue juwí Jate axazakuagaldi paldatagaba kualdi megazhánazʉnaka nakldá. ");
INSERT INTO kog_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ekí izhgabeñguenik na paldataki ekí jiba agabeyaldixa ishkakuxá. Eñkañga na, nashi guanekue Jeldusaldéñ ashuigatshak kagi iyashaldiéñ ezua muksú gauxak kagi axajabiyaldixa ajañguane. ");
INSERT INTO kog_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ai zhinik na kaiga yo ai kagiki “abi zuldanéñ” akuaka. ");
INSERT INTO kog_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ekí zexeki Jatetshi múldigaba naldiñga zʉxaitshixa Jeldemiyaja ekí zexaldixa guakldanamak zeklde: “Juldiútshi sáñkaldakueja eñki kauwijí paldata 30 akzaldaka ajañguane, ");
INSERT INTO kog_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","eñkañga na, ezua muksú gauxak kagi axajabí. Ekí ajanashatshakna, nauwijí Sáñkaldaja naksanekldamak ajanashá guane nzha.” ");
INSERT INTO kog_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ekí zegatogueñga na, Duwe Jesú sáñkalda Pildatuk akualdeyake ekí aklduká: —Guake, ¿ma shi juldiútshi sáñkalda akldé mikzé maldá? Guake akiyó: —Mañga ai naugé nakuák guashibaldá. ");
INSERT INTO kog_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Atshaga na, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, nauwisaná nauwa akldé akzekueja Duwe agatsaldi ne izhakuashiñgaba akuatshak jiaga, ni ji kakiyokuazhá. ");
INSERT INTO kog_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Guakna sáñkaldaja aklduká: —¿Matshuwi sha matshixa mizhakuaká nukakí shi maldá? ");
INSERT INTO kog_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ekí akbeyatshak jiaga, Duwejañki ni ezua múldigaba nuxaki izhakuaká zhikzukuaxaldiamak yokuazhá. Ekí tuatshakna sáñkaldaja “¡sakí nak shi ishkualdazhá gu!” jañguiñgaba na gua. ");
INSERT INTO kog_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Guatshak nauwisanákueki Jateja san kagixa zhinik kakzʉxaitshanéñ ldiuwañ be izhgisekui kajuizhaldegauxa Alduma zalda sáñkaldaja mielde paldesu nukaki kakibesakue ishkakuxaldiake kakibesamakga kakibesixa. ");
INSERT INTO kog_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Naldakna atshake ezua sigí Baldabá kalseldi abexane izhuka. Eñki saldiñgaja “shane shakldá” akualdi nuka. ");
INSERT INTO kog_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Atshak sáñkalda Pildatuja káguba duwá axajuizhaldegatshake ekí kaklduká: —¿Mielde shi miñkibesakue minajañgú? Baldabá azhi Jesú, eñki “Jateja káguba ikualdal gaxane” akuaka. ");
INSERT INTO kog_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jinake ekí kakldukazhá. Nauwisanátshi sáñkaldakuejañki Duwe Jesú mauldí axajanaté noshi nuxa agaxene katuwák. ");
INSERT INTO kog_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ai sáñkaldaja Duwe agatsaldi ne tuatogueñga asewája ekí akbeyal guak: “Kañ siañ sigí Jesú shalda kabi nakzeklde, alduna señgaba nakzegaksáni, ijaniñgaba ni guatokú. Aldéñki ni ji shalda agatsaldazhé nak guiyaba tuñshabaldáldi.” ");
INSERT INTO kog_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Guatshak Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, nauwisaná nauwa akldé akzekueja káguba duwá zhikzhe nakldekuek sáñkalda Pildatuk Baldabáki kakibesakue, Jesú niñkauwañki guaxal guagakue akshishakue kaxasashá. ");
INSERT INTO kog_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Guake jiak mokue kaklduká: —Ai mozhua nekue ¿mielde shi miñkibesakue minajañgú? Guake akiyayó: —Baldabá zʉñkibesa guwá. ");
INSERT INTO kog_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ekí akuaxake sáñkaldaja mokue kaklduká: —Guake, jejié Jesú, “Jateja káguba ikualdal gaxane” akuakáki ¿sakí gualdikue shi minajañgú? Guake saldiñga naldi ekí akiyayó: —¡Eñki kaldixa axaldiya guaxa guwá! ");
INSERT INTO kog_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Guake sáñkaldaja ekí kaklduká: —¿Sakígaba sha atshanéñ zhinik shi kaldixa axaldiya guagakueki minajañgú? Guatshak míñgaki mokue akldé jaldáñ ekí axaldék: —¡Eñki kaldixa axaldiya guaxa guwá! ");
INSERT INTO kog_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ekí axaldegatshak, sáñkaldaja Duwe Jesú kakibesakue kágubakueja ajañguazháldi na, akldé akldeñga kalzauldi, axaukshakaga ajanashaldá guxá katú. Ekí katuakna, ni agakuxal guaguenik saldiñgaja tuaté káuxalda itshizhiñga ekí kakbeyá: —Ekí atshaldatshake, jejié sigí shuigatshak, nasga guaxanuge nagatsaldazháldixa, ne maiñ zʉnake guaxamine miñgatsaldaldixa nzha awatuñshi ni ekí atshikú. ");
INSERT INTO kog_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ekí kakbeyatshak saldiñga naldi ekí akiyayó: —Ake wa, jejié sigí shuanaldixa shaldaki nasʉñ, nauwijí sukuakue juizhi shi zʉñgatseshí. ");
INSERT INTO kog_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Guake Baldabáki kakibesá. Guatshake Duwe Jesú niñkauwañki kuizhushak agaldabikshaldiniki, kaldixa axaldiya akuaxaldiamak niuwi ge na gua. ");
INSERT INTO kog_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Guake sáñkaldatshi suldáukueja Duwe Jesú sáñkalda tshuxa, kauwizhéñgaba ashekueñka awaldeyeniki aldahauxa nuk axajuizhakuá. ");
INSERT INTO kog_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gueniki Duwe aguáñ izhabashiñga, zhakuá iyajuishi, sáñkaldakueja zhakuá atsʉshi itshualdiyamak agatsé iyajualdí. ");
INSERT INTO kog_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Gueniki sáñkaldakueja sáñkaldak izhalshuxa tuñgatse kausúga zhikba zhikba axaxauweniki iyajiú. Gueniki sáñkaldaja kálbalda jiba akbeyamak kaldi nuxa jibatshaldi mual agaxé. Ekí akueniki iyajokldeshi sáñkalda akzé axajanashamak nuldu axayoshi ekí axaldék: —¡Juldiútshi sáñkalda akldé mikzé, zeñ shi mikldeshí! ");
INSERT INTO kog_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ekí agabeyeniki jutú iyatuañgui, kaldi agaxene iyakugueni eñkañga matshuwi juizha sáñkaldeldi agaldabikshá. ");
INSERT INTO kog_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ekí auxa iyajokldegatogueniki, zhakuá atsʉshi iyajuigueni, mokue ají zhakuága iyajualdieniki kaldixa axaldiya akuaxal awaldeyaldá na akuá. ");
INSERT INTO kog_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Guñgueni Duwe Jesú kuíbuldu zhinik agazaxaitshatogueñki, ezua sigí Simóñ axezhuka, Sildene zalda kakldabiguake, eñkáñ kaldi Duwe axaldiya akuaxaldixa kamañ naldi akuldeyexañ iyaxauwá. ");
INSERT INTO kog_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ekí Duwe awaldejiñga “Gólgota” axezhogeñka aldé. Eñki “káguba tsáñkalda zaldáxalda” guashi. ");
INSERT INTO kog_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Eñkaga na, suldáukueja kalwéldia yel akjiukue Duweja tugexañ agaxegatshak guaja tu gueniki tugazhá. ");
INSERT INTO kog_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Guñguake Duweki kaldik axaldiyeniki suldáukueja Duwetshi zhakuáki mieldekueja ipanaldixa ne atualdiamak ajanashiji aldiyá. Ekí zegatshake Jatetshi múldigaba naldiñga zʉxaitshixaja guakldamak zexaldiamak ekí zeklde: “Nají zhakuá abakaldak nazijuakueki ishkiyapana akuatshake nají zhakuá giemiki mieldetshi naldaldiamak aldiyá.” ");
INSERT INTO kog_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Gueniki nauwa antezhak Duwe numañ atualdiamak saldi iyaté. ");
INSERT INTO kog_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Eñkaga na, Duwe kaldixa axaldiyane asáñkaldake jinak shuigakue agatsé guaká ekí agazuñguane axaldiyá: “Jejié Jesúki juldiútshi sáñkalda akldé akzé nakldá.” ");
INSERT INTO kog_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ekí Duwe kaldixa axaldiyatshak mozhua sha atshixakueki kaldixa kaxaldiyatshakna ezuañki Duwetshi jibatshaldi, ezuañki jibatshazháldi mual axaldiyá. ");
INSERT INTO kog_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Duwe axaldiyaneñka zʉxaitixakuejañki aguáñ izhbashi mual, zʉ́xaita nusagatsaldi axaldeshi ");
INSERT INTO kog_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ekí axaldék: —¿Ma ekí nexabálde shi na? “Nas zʉnake Jate axazakuageñka juwí tiñguanaka, jiak gualdikuenik maiguake mokue gauwanaka nakldá.” Ekí maldeka neki mañgaba ishkuá guwá. Saldiñga netshi Jatetshi Asukuá maldahamak nake, kaldixa zhinik akjiena guwá. ");
INSERT INTO kog_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ekibeñga iyajokldeshi na, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue, nauwisaná nauwa akldé akzekue na ekí akuák: ");
INSERT INTO kog_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Jejiéjañki kágubakue muldetua kagauneshi, ikuá guxa ne, axaldáñ zʉnake ishkualdazháka tiuwi. Aldéñki nauwisaná juldiútshi Sáñkalda nahamak nake, ishkualdi kaldixa zhinik shi akjiení. Amak akjienaté katualdiakna, “namak nzha” jañguakualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Akze, aldéñki Saldiñga netshi Jate za alduna ishixa neki Jateja amak jañgualdiák, ejañga shi ikualdí. Jinake naldakí. “Naski Jatetshi Asukuá giemi nzhakú” neka nak. ");
INSERT INTO kog_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Guatshak mozhua shanekue Duwek akyó kaldixa axaldiyanekueja jiaga ekíga nusagatsaldi, sha axaldeshiñgaba na akuá. ");
INSERT INTO kog_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Duwe Jesú kaldixa axaldikualguéñ, niuwi muanté zhinik niuwi uñguexá kagi agatsauxa muldetua tuañ na zexá. ");
INSERT INTO kog_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Atshakna, Duweja jaldáñ ekí guak: —“Eldí, Eldí, ¿lama sabaktani?” Ekí guagatshake ekí guashi: “Najate, Najate ¿jinak shi nahezua nabajá makú?” ");
INSERT INTO kog_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ekí guagaté aldukatshakna, anuñka exa zhekualdekuejañga ekí guak: —Eñki nauwibama Eldiya ixauldatuka na ekí nek. ");
INSERT INTO kog_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ekí aldukatshaga na, ezua aikuega naldajiñga ezua samnek kuis kuis akzeldia agaldaksheniñki kaldik ijiú Duweja tuxaldiamak akulditshí tuñshá. ");
INSERT INTO kog_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ekí atshaté atuatshakna ezuakuejañki ekí akuák: —Agaunegagábaki, tuaté kuiznoshí, sakí amak Eldiyaja agaunexal naxaldí. ");
INSERT INTO kog_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Gueni Duwe Jesú mokue jaldáñ kauldeniki shuizhá. ");
INSERT INTO kog_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Atshaga na, juwí Jate axazakuageñkaga ezua zhakuá atema akaldak akzeñka juldunéñ agekualdé, aldéñgaba mataxa zhinik muan zuwá kagixa tiñ itshizbé na gua. Kakshata kamakualdi neji na, jagitemakue jiaga ishkualbé. ");
INSERT INTO kog_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ekí ishkualbenatshaga na, shuane abexaldialdi jagiga axakuiyananekue akpezhatshak matshuwi Jate jañguxa shuananekue mokue jeñ izhgaldashi, ");
INSERT INTO kog_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","abexananeñka zhinik akzʉxaitá. Aikue na Duwe mokue izhgaldagueni Jatetshi kuíbuldu Jeldusaldéñka aldeyatshak, káguba matshuwi nekuek kakizhañká. ");
INSERT INTO kog_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ekí kakshata neyatshak, zexauxa atuatshakna, suldáu Duwe tuatukakueja, kauwijí sáñkalda nañga zʉxaita zalda zhe kakzeshi na ekí akuák: —Namakga, jejié sigíki Saldiñga netshi Jatetshi Asukuá giemi naldé tiuwi. ");
INSERT INTO kog_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Atshaga na, matshuwi munzhikue Duwe ji agajuezhatshak agaxaunexaldiamak Galdildeya zhinik agapa aldakldekueki exaga agajué zeñka Duwe akuatoxauxa atuaté na aldoxá. ");
INSERT INTO kog_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Aikue na, ezuañki Maldiya Makldalda zalda, ezuañki Maldiya, eñki Santiakutshi, Jusétshi ajaba, ezuañki Zebedeyutshi asewá na naldá. ");
INSERT INTO kog_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Niuwi yaldagapanatshake ezua sigí kabia Jusé, kuíbuldu Aldimateyaxa zalda Duwe jañguxaga ");
INSERT INTO kog_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","nagueniki, Duwetshi abuá mexaldiamak sáñkalda Pildatuk niuwi akshishal ne. Amak niuwi ageguake, ");
INSERT INTO kog_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Duwetshi abuá kaldixa zhinik axawatiñgueniki zhakuá tiñne janshagatsek mañguá. ");
INSERT INTO kog_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Gueniki ají kagik jagiga shuanekue abexaldiamak axakuiyaneñka ni me abegazhéñkaga mexá. Gueni julduneñki jagi saldáñ pakue atema akyogueniki ne. ");
INSERT INTO kog_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ekí atshatogueñki Maldiya Makldalda zalda na, ezua Maldiya nañki Duwetshi abuá abegatoxeñka abuaxaga iteté noshi atuaté na aldoxá. ");
INSERT INTO kog_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Duwe Jesútshi abuá abegueni abokualdi, kizhiksekué ldiuwañki Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, paldiseyukue na sáñkalda Pildatuk axaldaxeni, ");
INSERT INTO kog_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ekí agabeyá: —Duwe, ejié Jesúki, kágubakue naldagálde jian kakzukuxa ité nogueñga ekí guakldane be zʉñgisék: “Nakuaxa guanaldixa jiak, maiguake mokue izhgaldaxaldikue niyó.” ");
INSERT INTO kog_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ekí guaklde nakna, maikldiuwi zʉxaitagáñgaki, ají abuá abexaneñka muldetua tuakue niuwi geshi makualdí. Ekí atshakíki, saigabaki aldéñ shagitixakue aldaxaldiniki ají abuá atusheshi awaldeyaldiniki, “Jesúki au izhgaté guane nzha” kágubakuek kagabeyaka. Amak kagabeji, ai namak jian kakzukualdiake, axañga Jesúja “Jateja káguba ikualdal gaxaldixa guakldane, aiga nzhakú” jian kakzukuanane guashiñki akldé naldagálde jian kakzukuaka nak. ");
INSERT INTO kog_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ekí agabeñguake: —Ake, abuá abexaneñka tualdixakue ulde xaldeki, ajanashakldegauxa ni meja akpeshi abuá uldeyazháldiamak tual miñguaxaldí. ");
INSERT INTO kog_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ekí kakbeñguake amak aldeñgueni abuá abexaneñka juldunéñ jagi saldáñ pakue atema akyokuega noguéñ ni meja akpegazháldiamak muldetua, muldetua juaxaldiyá. Akuñgueniki ai tualdixakue abajá na akuá. ");
INSERT INTO kog_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Guñgueni kizhiksekué ldiuwañ zʉxaitatshak, abokualdi dumiñkuke zhe meñga, Maldiya Makldalda zalda na ezua Maldiya nañga Duwe Jesútshi abuá abexaneñka atuál saldi aldé. ");
INSERT INTO kog_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Exa ezua Jatetshi guaklde uldeñka jékaldaxa zhinik agatanatshakna, kakshata atema ne. Amak agatangueniki Duwetshi abuá abexanaldi juldunéñ jagi saldáñ pakue atema agayone nalgué agajuekuñgueniki e bakaldak iyaté. ");
INSERT INTO kog_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ai guaklde uldeñkaki muñshí zaldaba izhuka, ají zhakuáki nuabi jana zʉ́xaita abutshi ijuakue. ");
INSERT INTO kog_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ekí zegaté atuatshak, abuá abexaneñka tuatoxekueki zʉ́xaita zhe kakzekága nuxa tau tau kakzeshi, ashuiká jana tuañ kakzék. ");
INSERT INTO kog_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Guatshak munzhikueki Jatetshi guaklde uldeñkaja ekí kakbeyá: —Zhe miñzegagába. Maiñki Duwe Jesú kaldixa axaldiya akuaxane niyabinuka minakué. ");
INSERT INTO kog_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Eñki jai izhogaksá. Shuiguenik mokue izhgaldaxaldixa guakldamak izhgaté guane nogashá. Akna, ají abuá ashanéñ tual nak guwíñ. ");
INSERT INTO kog_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Naldiniñki mija aldéñ shaxaldixakuek ekí kakbeyal mineyaldí: “Duwe Jesúki shuixeni mokue izhgaté guane. Miñsajañga Galdildeya neyakna exa mitualdixa niyó.” Ekí miñkualdaldiamak miñmeyá ni gukú. ");
INSERT INTO kog_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ekí kakbeñguakna munzhikue exa abexananeñka zhinik mija aldeyaldá. Kauwizhéñki sakí zegaté atunauxa zhe kakzegatshak, jiak zeñ kakzeshiñgaba na, aldaldiñga Duwek shagitiyatoñkaldekuañ zʉñmeyal aldeyaldá. ");
INSERT INTO kog_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ekí aldeyatogueñki tua kakzegagá, Duwejañga kakizhañkaji, kaxazguák. Kaxazguaxakna, aldéñ axaldaxeni, nuldu axayoshi, kasak káuxalda iyapañgui akldé akzamakga agazukuá. ");
INSERT INTO kog_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Guakna Duweja: —Zhe miñzegagába. Maiñki nagapa neñkakue, nakaja giemi nekldekuek ekí kakbeyal mineyaldí. Galdildeya baxe aldé ni gualdí. Exa nawatualdixa niyó —ekí na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ekí munzhikue aldeyatogueñki, anuñka Duwe Jesútshi abuá abexananeñka tuatonekue kuíbulduxa jeñ aldé. Exaki Jatek múldigaba agaskaitshixakuetshi sáñkaldakuek zegaté atunauxa agabeyá. ");
INSERT INTO kog_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ekí kagabeyake sáñkaldakue, nauwisaná nauwa akldé akzekue na izhajuizhaldegatshak, Jesútshi abuá sakí neklde akuaxaldixa izhgakualdi aldoxaldiamak janagatú. Ekí janagatunamakga kabukue naldagálde nuxa kágubakuek agabeyaldiamak shi kaxajiuwi, matshuwi paldata kagasabiji ");
INSERT INTO kog_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ekí nuxa guagakue kaxaldék: “‘Nasʉñki kañ sesʉñ jeñ kabá guáñkalde kaldoxeñga, Jesú aldéñ shaxaldiyatonekueja ají abuá atushegueniki awaldé guane nzha’ miñguaxaldí. ");
INSERT INTO kog_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ekí guakbinaldixa shalda mimijí sáñkalda akldé akzeja akwasheshi gualdiake, guiyaba mimatuñshi guakuak nasʉñga miñzukuagakualdixa. Ekíki kaxa miñgatseshi guakuak.” ");
INSERT INTO kog_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ekí kagabeñguake, kabukueja amak paldata iyapangueniki ekí zekldeki sakí nuxa guagakue kagabenalguamak akuaxaldá. Gueni kaiga yo, Duwe Jesútshi abuáki ekí nuxa neklde nauwisaná juldiúkueja aldukshi, akuaxalga nakldók. ");
INSERT INTO kog_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Guatshak nasʉñ 11 shagitiyatoñkaldekuañ amak Galdildeya baxe kaldeyatshak, Duwe Jesúja gaxa akshá zeñka akldabigakue zʉñmeneñka neñkalde. ");
INSERT INTO kog_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Exa aldéñ naldi katuatshak akldé akzamakga akzukuáñkalde. Guatshakna ezuakueki mozhua mozhua akldeshi “¿namak Duwe naldiñga naldaka ne?” axajaná. ");
INSERT INTO kog_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Gueni Duwe zʉñkaldaxeni ekí zʉñmeyá: —Saldiñga jika jékaldaxa zalda na nahauxa, alnobaxa, kagik zalda na nahauxa aksanék guakueki Saldiñga netshi Jateja nasgaba auxaga niuwi nagé ni gu. ");
INSERT INTO kog_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Guakna saldiñga kagi nahauxa mineyaldí. Amak neji na, káguba saná na nahauxa nashaldá kakbeji, nají múldigaba shi kaxaldiji miñgualdí. Ekíki kauwizhéñ jiaga shi nakiyatiji, naxapa aldeyaldiamak. Ekí miyakbeyatshak, mieldekueki namak najañgui neyapanaldiake Jate namak jañguane, nas Asukuák namak najañguane, Jatetshi Alduna namak jañguane ne awatuñshaldiamak nik kajaukshi miñgualdí. ");
INSERT INTO kog_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nasga shi miñkaldiji, sakí atshiji izhogakue niuwi miñgenugauxa, maiñ zhinik ekíga atshakue shi kaxaldiji miñgualdí. Naski namak ni miñmeñkú, maiñ na izhoshiñga auxa zexaldieñka yo, miñgapañga za izhoxaldikue niyó. Ekíga shi naldí.");
INSERT INTO kog_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jalde kaltake Duwe Jesúki, Saldiñga netshi Jatetshi Asukuága, zʉnekualdal naklde shalda miñmeyaldikue. ");
INSERT INTO kog_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jateja zʉnekualdal gaxaldixak akbeyatogatshak ají múldigaba naldiñga zʉxaitshixa Isaiyak kalta ekí gaushanane: “Nasga na mizhaxañga ezua maldeyaldixa shalda guashi jiúñgulda semixagauwi jana gaxaldikue nzha.” ");
INSERT INTO kog_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Ejiéga zʉk zeñka izhoshi na, aldukal axaldakldekue ekí jaldáñ kaxaldexaldixa: ‘Saldiñga netshi Sáñkalda naki miñkaldashi guapanakna, jian naxaldiamak jiúñgulda siyaxagauwakuamakbe, aldunaxa janazhiktú guwíñ. Eñki ezua sáñkalda naxaldiéñ jiúñgulda me me zeñ jian axaxazakuamakbé, ai nagatuka muldetua mipanaldiamak mimijí aldunaxa jana akizhiktuwíñ.’” ");
INSERT INTO kog_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ekí guakldalguamakna, Juañ nik majaukshakue zʉk zeñka ají jiba atshapanatshakna, aldukal axaldakldekue ekí kakbeyatoguamakga kakbeyá: “Maiñ sha miyatshixakue majiñga maja xaldeki Jatek agakualdinakue miñgatsé. Amak atshamine mimawatualdiamak nik ajaugakue. Ekíki Jateja sha atshamine miñkabetaldiamak.” ");
INSERT INTO kog_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ai aldukal axaldakldekuega na, kuíbuldu Jeldusaldéñ zaldakue, saldiñga eñgui Juldeya baxañ zaldakue juizhi na axaldaxá. Guane aikuejañki amak axaldukshi na, “sha atshanuge ni atuñkú” nexekueki Juañja nina Juldáñga nik kajaukshi, kajaukshi na kakuá. ");
INSERT INTO kog_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Guatshak Juañki béyakze kameyutshi galdaga sezheklde zhakuá ijuakue. Janáñkaldak axabekueki kuizhuga. Aldéñ gakue akldé gaxaki sesʉ, kalkaldeldi zalda jatiá gaxa na naldá. ");
INSERT INTO kog_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Guatshak aldéñki ekí agatsaldi na guagatoxá: “Naski axañga naklduge. Ne nalduxañ ezua zʉnekualdaldiamak nagatukaki nazhakaldak akzé nak, naski ni atabal nuxaki nakzaldagálde. ");
INSERT INTO kog_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Akna naski nik nuxa mimajaukshikugé. Ne, eja zʉnake Jatetshi Aldunakga mimajaukshi na, ai Alduna maiñldi auxaga miñkaldaldaldiamak miñgexaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Atshakna Juañja ekí kágubakue nik kajaukshatogueñga na, Duwe Jesú Galdildeya baxe, kuíbuldu Nasaldéxa zhinik nina Juldáñ nagatshak Juañja nik jaukshá. ");
INSERT INTO kog_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Amak jaukshatshak, Duwe nik akzʉxaitatshaga, alnoba akpezhaté tuatshake exa zhinikga na, Jatetshi Aldunaga shamíjañ axagatanaté tu. ");
INSERT INTO kog_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Atshaga na exa zhinik ekí múldigaba guagaté alduká: “Mañki, Nasukuá giemi matshuwi mezhgajañguge, nakldunauxabé mizhuka nakna, zeñ maldakzukuxa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ekí Duwe Jesúki nik ajaukshiñgueni Jatetshi Aldunaja ubañga zʉk zeñka neyakue aksaneguamak ne. ");
INSERT INTO kog_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Eniñki 40 ldiuwi izhogueñki, jiséja ijuldukshaka guaji aksaneshi izhó. Exaga Duweki ahezua béyakze sha makuakuekue kenaldi izhoguéñ, Jateja guaklde uldeñkakueja numañ tual axaldák na akuá. ");
INSERT INTO kog_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Guñgueni Juañ nik majaukshakue kalseldi abegatshake Duweki mokue Galdildeya baxe neñguenik, Ajate shalda múldigaba janshagatse ekí guashi izhoxaldá: ");
INSERT INTO kog_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Saldiñga netshi Jatejañki abisajañ sanegapanaldixa niuwañ naki zexaldá na guapán. Akna maiñ sha miyatshixakue majiñga, maja xaldeki Jatek agakualdi, aldéñ minkualdaldixa namak mijañgualdí.” ");
INSERT INTO kog_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Guñgueni Duwe Jesú niwa Galdildeya xezhak neyatogueñki, mozhua sigí zhuakaja nalguekue katú. Ezuañki Simóñ, ezuañki Andaldé axezhuka. Ekueki pikáu gukakue aldalguakna, pikáu akuxaldiamak kauwijí zhemá nik akuateyaté katú. ");
INSERT INTO kog_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Guñguake Duweja ekí kakbeyá: “Maiñ shi minagitiyaldixa nak nagapa kuizaldi. Maiñki pikáu niji za mizhekue ne, kaiga zhiniki jiba abisa minaxatshaldixa miñgexaldikue. Aiki káguba nagapa aldeyaldixakue miniyapanaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ekí kakbeyatshaga na, zhemá abashiñgueniki ubañga Duwe Jesúk amak axapa aldeyaldá na akuá. ");
INSERT INTO kog_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Gueni nauwa ne zeñka aldeyatogueñki jiak, Duweja Santiaku, Juañ na, Zebedeyutshi asukuákue, kanuwaxa zhemá za siyagaxáu katú. ");
INSERT INTO kog_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ekí katuatshaga ekí kakbeyá: “Maiñ shi minagitiyaldixa nak nagapa kuizaldi.” Ekí kakbeyatshaga na kauwijate, nashi kagaunekakue juizhi kanuwaxa abajañgueniki ubañga Duwe Jesúk amak axapa aldeyaldá na akuá. ");
INSERT INTO kog_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Guñgueni ekue nañga Duwe Jesú Kapeldahúmka aldeyatshak, zhigasekué ldiuwañ zegatshake juwí izhajuizhaldegeñka shi kaxaldiyaldá. ");
INSERT INTO kog_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ekí shi kaxaldiyatshakna guiyaba shizhixakueja shizhiyamak shi kaxaldiyagábaki, muldetua niuwi axaldé ga agatsaldi shi kaxaldiyá. Ekí agatsaldi shi kaxaldixá aldukatshakna kágubakueja “¡sakí ekí agatsaldi shi zʉñkaldixá!” na kakldexá. ");
INSERT INTO kog_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Guatshak aiga na, ezua sigí jisétshi alduna ijulduneja ekí kaulshá: ");
INSERT INTO kog_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Ma Jesú Nasaldéxa zalda maldé, ¿jinak shi nauwikenáñ izhoxaldá makú? ¿Zʉnakldañkashal nakbalde sha? Naski me maldé maldakué: Mañki janshizhegaba Jate jékaldaxa zaldatshi giemi maldé naldashibaldá. ");
INSERT INTO kog_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Guake Duweja jisétshi alduna ekí axaldék: —Sʉnjá nogwá. Sigík zhinik akzʉxaita makunék. ");
INSERT INTO kog_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ekí axaldeguake, jisétshi aldunaja ai sigí zʉxaita tau tau akzukuatshake, jaldáñ kauldi amak izhé. ");
INSERT INTO kog_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ekí zegaté atuatshakna saldiñga exa zhekualguekueja “¡sakí shi ekí izheñshí!” ajañgui na, ataba atabañ ekí izhgalduká: —¡Sakí shi ekí zek! Aldéñ múldigaba shizhixáki abisa ni mitsák nukañkáalde. Ají múldigabaki niuwi axaldé naguana, jisétshi aldunakue jiaga “newa” axaldegatshake amak axatshixa tiuwi. ");
INSERT INTO kog_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Guñgueni na Galdildeya baxe zahauxa izhukakueja akldé akldeñga Duwe shalda izhgabejiñgaba na ashekualdapaná. ");
INSERT INTO kog_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Guñgueni izhajuizhaldegeñka zhinik agazaxaitatshak, Duwe Jesúki ubañga Santiaku, Juañ na Simóñ Péguldu, Andaldé tshuxa ne. ");
INSERT INTO kog_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Exaki Simóñtshi akagiki guañgua zalda akzeka sha noguakna, Duwek agabeyá. ");
INSERT INTO kog_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ekí agabeñguake ai munzhik axaldeyeni, káuxaldak akpani izhgaldakshatshaga, guañgua zalda iskaitshake kakauwaldá na gua. ");
INSERT INTO kog_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Guñguenik tuañ zegapanatshake saldiñga mulbatá akzekakue, jisétshi alduna ijuldunekue juizhi Duwek akualdák. ");
INSERT INTO kog_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Atshaga na, naki saldiñga kuíbuldu ashekualguauxa jugatezhakgaba ajuizhaldék. ");
INSERT INTO kog_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Atshakna Duweja matshuwi mulbatá sha sha akzekakue se kakzukui, matshuwi jisétshi alduna ijuldunekue jiaga kezheñshá. Ai aldunakueja aldéñki Jatetshi Asukuága ne kakualdatshakna, Duweja ai shalda ni ji kakuakshakí na naldá. ");
INSERT INTO kog_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Abokualdi zhe meñga, Duwe Jesúki izhgaldaguenik juk akzʉxaitiñgueniki káguba isʉ́ñ zaldi Ajate axazguaxal ne. ");
INSERT INTO kog_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Guane nalgué, Simóñ Péguldu na agapa izhoguekue juizhiñga Duwe aldiyal aldé. ");
INSERT INTO kog_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Aldiji kakzalguake ekí agabeyá: —Saldiñga kuíbulduk zaldakue maldiyá aldogashá. ");
INSERT INTO kog_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Guake ekí nuxa kakiyó: —San san kuíbuldu akyó zhekuekue jiaga Saldiñga netshi Jate shalda kakbeyaldikuamak kuizaldi. Akze, naski ekí guaxal kagik naklduge nakldá. ");
INSERT INTO kog_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Akna Duwe Jesúki Galdildeya baxe juwí izhajuizhaldeka nahauxa Jate shalda shi kaxaldiji, jisétshi aldunakue kágubak ijuldune kezheñshi na mizhatoxá. ");
INSERT INTO kog_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Guatoguéñ ezua sigí ajuba ikaldunatuka Duwe Jesúk axaldagueni nuldu axayoshi ekí agakuañnék: —Ma janshi naxazgundana mikzék guashiñki, amak naxatsha guamildaká. ");
INSERT INTO kog_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Guake Duweja guañ jañgui na, káuxalda ipañgui ekí akbeyá: —Janshi mixazgundana nzhakzék. Akna, ¡kaigaga janshi migatsék shi gui! ");
INSERT INTO kog_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ekí axaldegatshaga se akzeshi, amak janshagatsék. ");
INSERT INTO kog_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Guake “au neyabikuká ni gu” akbeji na, ekí atshakue giemi axaldék: ");
INSERT INTO kog_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Kaiga janshi mixazguge ni mek akbeyagábaki, egaba janshi migatsék guane matuexañ jian Jatek múldigaba agaskaitshixa nugeñka maldeyaldí. Exaki nauwibama Mueséja mielde ajuba ikaldunatuka janshi agatsekldejañki, ji Jatek agegakue guagamak ageshi makualdí. Ekíki janshi migatsék guane mawatualdiamak. ");
INSERT INTO kog_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ekí akbene nalgué jiaga, ai sigí exa zhinik neñguenik “Duwe Jesúki janshi naxazguane nzha” saldiñgak akbeyaldá. Ekí Duwe shalda kakwasheguakna matshuwi nekueja ekíga kagaunegakue ajañguatshakna, aldéñki saldiñgaja tuaté kuíbulduk muldetua juldunazháka atú. Ekí atuakna, nauwa agajué zaldi káguba muldetua zhekualdazháldi izhogatshak jiaga, káguba saldiñga baxe zaldakueja atuál axaldaxalga na aldoxá. ");
INSERT INTO kog_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Guñgueni Duwe Jesúki anuñka ldiuwi eni izhogueni mokue kuíbuldu Kapeldahúm nak. Eñgui zhekuekuejañki Duwe mokue naklde aldukañguakna, ");
INSERT INTO kog_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","e atuál aldakldekue muldetua zhikyokualdi kas jugátezhak jiaga, ni ezua mokue juldunaksá zalda sʉnék. Guake Duwejañki Jatetshi múldigaba shi kaxaldiyaldá. ");
INSERT INTO kog_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Amak shizhiyatogueñga na, ezua sigí abuá axazauwaksánane ixabakak akshañga apebukue makaiwa aldaldi awaldák. ");
INSERT INTO kog_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Aiki Duwe nugeñka awaldaxaldixa ajañguane nalgué, kágubakue zhikyokualdi kas ashekualguakna, akualdeyazháka atú. Ekí atuñguake juwí bakaldaxa awalditshigueniki, juwí nauwa agapoñguñguenik, ai ga sigíki ixabakak akshañga shibuldik agajieñguá. ");
INSERT INTO kog_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ekueja Duwejañki se akzukualdixa alduna iyashiji akualdaklde katuakna, abuá axazauwaksánanek ekí akbeyá: —Nasukuá, sha matshixa nuk mixabetá ni gukú. ");
INSERT INTO kog_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Exaga, anuñka guiyaba shizhixakue iteté aldoxekueja ekí aldukatshakna ekí ajañguá: ");
INSERT INTO kog_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Eñki me nak ekí agatsaldi zukuagaka akldeká? Ekí negatshake Jate aguáñ izhbashi mual negashá. Akze, ezuañgaba Saldiñga netshi Jateja za na sha atshane axabetaka naldashá.” ");
INSERT INTO kog_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ekí ajañguatuka ubañga Duwejañki katuñguakna ekí kaklduká: —¿Jinak shi ekí agatsaldi mijañgú? ");
INSERT INTO kog_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Guake, ¿mielde shi aguáñ jibañ akzaldi abuá axazauwaksánanek akbenaka na? ¿“Sha matshixa nuk mixabetá ni gukú” azhi “izhgaté xaldeki mixabaka guxa newa”? ");
INSERT INTO kog_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ne naski, Jatetshi Asukuága ixagabaldeklduge, jai kagik sha atshixakue axabetaldikuamak niuwi naxaldé mimatuñshaldikue. Guaguenik abuá axazauwaksánane ekí axaldék: ");
INSERT INTO kog_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ekí mikbeyaldikue: Izhgaté, mixabaka guxa xaldeki mijuldi newa. ");
INSERT INTO kog_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ekí akbeyatshaga na, saldiñgaja tuatoguéñ amak izhgaldaguenik ixabaka gugueniki exa zhinik akzʉxaitá. Guatshakna saldiñga tuatoxekuejañki “¡sakí shi ekí janshi akzukú!” ajañgui na, Jate za akldé akzamakga agazukui ekí akuák: —¡Ni mitsák ekí janshizhe ajanashaté tu guañkáaldamak ni katú! ");
INSERT INTO kog_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Guñgueni Duwe Jesúki mokue niwa xezhaxa neyatshak, matshuwi kágubakue axaldagatshak shi kaxaldiyaldá. ");
INSERT INTO kog_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aldéñ exa mizhatogueñki, Alpeyutshi asukuá Aldebí tu. Eñki sáñkaldak akiyalzabine zhiksuika naldakna agasabiyaldiéñ ité tuñguake ekí axaldék: —Shi maldagitiyaldixa nak nagapa kuizaldi. Ekí axaldeguake izhgaldaguenik amak agapa neyaldá. ");
INSERT INTO kog_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Guñguenik Duwe aldéñ shaxaldixakue juizhi Aldebí tshuxa asatoguéñ matshuwi sáñkaldak akiyalzabine zhiksuikakue, axautshi sha atshixa akuakakue nañga asaldá. Akbiñgaki aikuega matshuwi Duwek agapa aldeyák. ");
INSERT INTO kog_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ekí ashekualdi asaté atuatshakna, guiyaba shizhixakue, paldiseyu na agatsekueja Duweja shaxaldixakue ekí axaldék: —¿Shi miñkaldixaki sakí zhinik shi sha atshixakue na sáñkaldak akiyalzabine zhiksuikakue juizhi zatók? ");
INSERT INTO kog_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ekí nukajakna, Duweja kakbeyá: —Se nekueki méldiku kagajuezhazhé. Akze, mulbatá akzekakue guana, méldiku kagajueshka naldashá. Ekibeñga na, naski mieldekue axaldáñgaba “jian sha izhokú” itshankakue Jatek axakualdinaldiamak kaldiyal nagazhánuge. Ekí ne, sha atshixakue niñkauwañki, sha ajanashixa abajiñga abaja xaldeki Jatek axakualdinaldiamak kaldiyal naklduge ni mitú. ");
INSERT INTO kog_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ezua ldiuwañ Juañ nik majaukshakueja shaxaldixakue na, paldiseyukueja shaxaldixakue nañki asáaki aldoguéñ, ezuakueja Duwe Jesúk axaldaguenik ekí agalduká: —¿Sakí shi Juañja shaxaldixakue na paldiseyukueja shaxaldixakue juizhiñki Jate muldetua axazakuaxaldiamake asáaki ashekue ne, ma shi maxaldixakue zʉnake asáaki anuñka ashekua akuazhé na? ");
INSERT INTO kog_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Guake Duweja ekí nuxa kakiyó: —Nauwisaná sigí numa nexaldixa naldieñki matshuwi abuzatiakue akbeñka. Gualdinik aldéñ kagapañga nogeñga abuzál nakldekue ¿sakí shi asáaki ashekualdaka na? Ekí ajanashazháka. ");
INSERT INTO kog_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Guanaldixa sigí numa neklde awaldeyaldiéñ ldiuwañ zegatshak zʉnake apebukueki itshani, asáaki aldoxaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ekí kakbeñguenik jiak, ekí kakbeyá: —Ni meja zhakuá abisa ne duebak agapa guazhé. Azhi ekí guatshake, akldé zhindu axazgualdixa. Ekí guatshak míñgaki akldé nusakuá gualdixa naldashá. ");
INSERT INTO kog_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ekibeñga na, ni meja alditsha tanagáldega moñkú duebak kuashazhé. Azhi ekí kuashaldiake tanatshak moñkú dueba kualbenatshake, alditsha jiaga itshuana guaka naldashá. Ekí atshaka nakna, alditsha tanagáldega moñkú abisak za kuashakue naldashá. ");
INSERT INTO kog_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Guñgueni ezua izhgasekué ldiuwañ zalguéñ, Duwe Jesú tek zʉxaitatoguéñ, aldéñ shaxaldixakuejañki eñ gakue nauwa akuguenik axá. ");
INSERT INTO kog_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Guakna paldiseyukueja ekí Duwe axaldék: —Tu guwá. Nauwisanátshi guiyabajañki izhgasekué ldiuwañki ni nauwa jiba atshasé guaka ne, shi migitixakue ¿jinak shi atshasé jiaga ekí ajanashatók? ");
INSERT INTO kog_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Guake Duweja kakiyó: —Nauwibama Dabíki ezua ldiuwañ apebukue juizhi gakue kagajuezhi, maldija kakualdá guñguake ¿sakí atshane sezheklde tuabíne sha? ");
INSERT INTO kog_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Guiyabaja Jatek pañ agaxeneki aldéñ múldigaba agaskaitshixakueja za gaka sezheklde. Naldiñki Jatek múldigaba agaskaitshixa akldé akzé Abiyatál izhoguéñ, nauwibama Dabí Jate axazakuagaldi juldunguenik, ai pañ gañgueni apebukuek jiaga kakaune. ");
INSERT INTO kog_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ekí kakbeyeni ekí jiaga kakbeyá: —Saldiñga netshi Jateja semana akldañkajauxa ezua niuwañki jiba atsháaki izhgasekuéñ janaktuatshak, ai niuwañki kágubakuek axazauwaldiamak janaktunane. Ne káguba gauwatshake ai izhgasekué niuwañ axazauwaldiamak gauwazháne. ");
INSERT INTO kog_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Akna naski Jatetshi Asukuága ixagabaldeklduge naugák niuwi ge guashi naxaldéñ na, izhgasekué ldiuwañ jiaga ajanashakuamak ajanashaka niuwi genaka nakldá. ");
INSERT INTO kog_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mokue ezua izhgasekué ldiuwañ Duwe Jesúki juwí izhajuizhaldegeñka juldunatshak ezua sigí káuxalda ixanane ité tu. ");
INSERT INTO kog_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Exa na, anuñkakueja Duweki atshasé atshane izhakuaxaldixa aldiyatoshi “izhgasekué ldiuwañ jiaga ai sigí se akzukuá gualdí” ajañgui na, Duwe za atuaté na aldoxá. ");
INSERT INTO kog_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nogatshak jiaga, Duwejañki sigí káuxalda ixananek ekí akbeyá: —Izhgaté xaldeki saldiñga matuakldegéñ axaté guwá. ");
INSERT INTO kog_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Amak izhgaldaxake Duweja exa zhekualguekuek kaklduká: —Nauwijí guiyabajañki kizhiksekué ldiuwañki ¿janshizhe atshakue azhi sha atshakue zʉñmeñka shi na? ¿Ai ldiuwañki ezua shuigaté nuka shuigazháldiamak yo guakue, azhi yo guagábaki egaba tu me guakue zʉñmeñka shi na? Ekí kakldukatshak ni akiyayokuazhá guaté ");
INSERT INTO kog_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","tuatshakna Duwejañki aldunaxa kuamaldekue katuwi na, itshani, nusá akzeshi ezua, ezua katuñgueni sigí ekí axaldék: —Káuxalda mixanane yu atshiwá. Amak atshatshaga na, auxaga janshagatsék. ");
INSERT INTO kog_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Guatshakna paldiseyukueki exa zhinik agazaxaitiñgueniki ezuakueki sáñkalda Eldode na agatsekue juizhi sakí agatsaldi Duwe Jesú sha akuí, akuaxaldixa aldiyaldá na akuapaná. ");
INSERT INTO kog_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Guñguake exa zhinik neñgueniki Duwe Jesú aldéñ shaxaldixakue nañga niwa xezhaxa neyatshak, matshuwi kágubakue agapa aldé. Ekueki Galdildeya baxe zaldakue, Juldeya baxe zaldakue, ");
INSERT INTO kog_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kuíbuldu Jeldusaldéñ zaldakue, Idumeyaxa zaldakue, nina Juldáñ atabañ niñkauwa zaldakue, mozhua kuíbuldu Tildu na Sidóñ eñgui baxañ zaldakue atuál aldé. Jinak aldeyazhá. Duweki atemajañ janshizhe atshatuka aldukañguák. ");
INSERT INTO kog_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ekí káguba agubisha matshuwi ajuizhaldegaté tuwakna Duweja dañ akzeshi guakuak aldéñ shaxaldixakuek kanuwa janagaktuakue kakbeyá. ");
INSERT INTO kog_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Akze, matshuwi mulbatá akzekakue se kakzukuane nalguakna, jiak mulbatá akzekakueja se kakzukualdiamak ajugualdixa ajañguá. ");
INSERT INTO kog_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Guatshak jisétshi alduna kágubak ijuldunekueja mitsakgaba Duwe atuatshake nuldu axayokshi ekí kaulshixa: “Mañki Saldiñga netshi Jatetshi Asukuá giemi ni maldá.” ");
INSERT INTO kog_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ekí aldegatshak jiaga, Duwejañki aldéñ me ne guagasʉ́ñze giemi kaxaldék. ");
INSERT INTO kog_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Guñgueni Duwe Jesú gaxa akshá zeñka nitshiguenik mielde axaldagakue kajañguxakueki kexauldatshak amak axaldák. ");
INSERT INTO kog_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ai zhinikga na, 12 kezhgakuxanekueki axapa aldeji na, aldéñ naldiñga muldetua shi kaxaldiyaldinik jiak, kauwizhéñ zhinik ekíga shizhaldiji na, ají múldigaba guaxal kakaxaldixakue na ekí kezhgakuxá. ");
INSERT INTO kog_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Amak kezhgakugatshaga, jisétshi alduna kágubak ijuldunekue iyaldeñshaldiamak niuwi kagé. ");
INSERT INTO kog_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aikuega na 12 kezhgakuxanekueki ekí axezhukakue: Ezuañki Simóñ nalgué aldéñki Péguldu axetene. ");
INSERT INTO kog_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ezuañki Santiaku, ezuañki etshi aldani Juañ, aldekueki Zebedeyutshi asukuákue, aldéñki Buanelje kaxaldexaldixa. Aiki nauwijí kaugiañki kuizhbañgui tsukuakue guashi. ");
INSERT INTO kog_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ezuañki Andaldé, ezuañki Pildipi, ezuañki Baltoldomé, ezuañki Mateyu, ezuañki Tumás, ezuañki Santiaku, eñki Alpeyutshi asukuá. Ezuañki Taldeyu, ezuañki Simóñ, eñki axautshi saná kauwijí kagik sanekakue akzʉxaitshaldiamak niji izhuka. ");
INSERT INTO kog_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ezuañki Juda Iskaldiute, eja na aldiweki Duwe Jesú gexaldixa na naldá. ");
INSERT INTO kog_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Guñgueni Duwe Jesú ezua tshuk juldunatshak matshuwi kágubaja aldéñ atuál ajuizhaldegatshakna, shaxaldixakue na gakue ga guashi niuwi kaxaldaldakí. ");
INSERT INTO kog_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Duwe ekí izhogatuka akajakueja aldukañguakna, “muldetua alduna axaldegaksá sʉnagú” akuashi ajuxa awaldeyaldiamak akuxal aldé. ");
INSERT INTO kog_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Atshak guiyaba shizhixakue Jeldusaldéñ zhinik agatananekueja: “Ejiéki Belsebú, jiséga ají aldunakue aksanekaja kama agegatshak guana ekí ají aldunakue izheñshashá” nalda axakuák. ");
INSERT INTO kog_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ekí akuaguakna, Duweja kágubakue kajuizhakuñguenik ajanashakldegéñ zhinik ekí kakbeyá: “¿Sakí shi jiséjañga ají aldunakue kágubak zhinik izheñshaka na? ");
INSERT INTO kog_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mitsák ezua sanágaba axaukshapana akualdiake, ezua sanágaba nalda aldaldaksánaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ekibeñga na, zhuajúk zaldagaba axaukshi izhguldiyapana akualdiák, san san aldeji, zhuajúk zalda aldaldaksá guxá naldashá. ");
INSERT INTO kog_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ekíga na, jisé aldéñga ají aldunakue na izhguldiji, axaukshi guanake, ají aldunakue aksanegaksáni na, izhgaldañgasha guaka naldashá. ");
INSERT INTO kog_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","”Azhi mieldejañki ezua sigí kamakue ajúk numakue itushexal agakjuldundana akzexaldiake, ake, axáñ misha e shibañguakue agatsaldaka. Ekí guatshakna, jika axaldauxa nuk itushegaka naldashá. ");
INSERT INTO kog_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","”Akze, namak miñmeyaldikue. Jatejañki kágubakue saldiñga nalda sha ajanashanaldixa kaxabetaka. Ekíga na, káguba azhi Jate aguáñ izhabaji mual nalda axakuakldaldixa jiaga kaxabetakaga. ");
INSERT INTO kog_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ekí ne, mieldeke Jatetshi Alduna aguáñ izhbashi mual, nalda aguaxaldiák zʉnake, aiki Jateja ni mitsák jiaga axabetazháldi, agatsaldiñga ne za tuná.” ");
INSERT INTO kog_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jinake ekí guagazhá. Akbiñgaki “Duweki jisétshi aldunajañga aksanegatshakna ekí atshishí” nalda axakuaklde naldák. ");
INSERT INTO kog_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Atshaga na, Duwe ajabaja, aldanikueja atuál aldagatshak jubaldaxa me aldagueni iyaxauldal akuák. ");
INSERT INTO kog_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Guakna káguba matshuwi Duwe aldesañ izhoxekueja ekí agabeyá: —Duwe, mijaba, mizhanikue, mijasʉkue juizhi maldiyal nakldekue, jubaldaxa akteté nagaldók. ");
INSERT INTO kog_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Guake Duweja ekí kakiyó: —¿Mekue shi najaba, nakaja giemi jana nekue katualdikue na? ");
INSERT INTO kog_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ekí guaxeniki aldesañ izhoxekue katú, katú gui ekí kakbeyá: —Jejiékue na najaba, nakaja giemikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Jinak ekí katuakí. Mieldekueki Najateja kajañguamak axajanashixakue na najaba, nakaja giemi jana nekue katuñkuge nakldá —na guaxá. ");
INSERT INTO kog_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Duwe Jesúja mokue niwa xezhaxa shi kaxaldiyaldá. Exaga na, káguba agubisha duwá ashenakna aldéñki shi kaxaldiyaldiamak ai niwakga ezua kanuwak iyabegueniki yaldagatshake kágubakueki niwa xezhaxaga ashená. ");
INSERT INTO kog_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Exa zhinik matshuwi jika atshakldegéñ zhinik shi kaxaldijiñga na, zuldak zhinik ekí shi kaxaldiyaldá: ");
INSERT INTO kog_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nukaté nogwíñ. Ezua zʉzikaja zulda tiñgui nixal ne. ");
INSERT INTO kog_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Amak tiñguatshak anuñkaki jiúñguldak akjiená, guane nalgué aiki nubája nagueniki nuk ga. ");
INSERT INTO kog_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Anuñkaki jagénaldi kagigaba zaldazháldi akjienaneki kagik ijiú me axañga munaldá. ");
INSERT INTO kog_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aiki muldetua shijualda jieñguazháne naldi na, niuwija tuatshake jiyabulduni nuk kaná. ");
INSERT INTO kog_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jiak, anuñka zuldaki kausú kenaldi akjienane, nalgueki kausú nañga munapanatshake kausújañga jutekuatshake ni nauwa negazhá. ");
INSERT INTO kog_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Guatshak anuñka zulda zʉnake kagi janshizeñ akjienane nalguekueki muldetua munatshake anuñkaki matshuwi nek, anuñka míñgaki akldé matshuuwi nek, azhinik míñgaki gugasá zalda na nexá.” ");
INSERT INTO kog_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Gueniki ekí guak: “Ekí miñmeñkugeki saldiñga kuxa miñkaldikueke muldetua nukshi miñgualdí.” ");
INSERT INTO kog_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ekí kakbeyatogueni Duwe Jesú aldéñ 12 shaxaldixakue, anuñka agapa neñkakue na nuxa abatshake ekí agalduká: —Duwe, ekí jika atshakldegéñ zhinik shi mizhiyatshak, ¿sakí guashi shi ekí shimizhí? ");
INSERT INTO kog_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Guñguake kakbeyá: —Nauwijatejañki sakí janshagatsaldi miñsanexaldixa janaktunane nalgué jiaga, ni mek mu agisekuazháne. Ne maiñ namak najañguaminekuañ zʉnake mu miñgisekuane. Ekí ne, namak najañguazhékue zʉnake jika azhi káguba atshakldegéñ zhinik za kakbeñkuge. ");
INSERT INTO kog_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jinake ekí kakbeyakí. “Naldiñki sakí atshikuge natuál za aldogatshak jiaga, jinak ekí atshikuge kagajienazháldixa. Ekíga na, nas guakuge naldukal za aldogatshak jiaga, sakí guashi guakugé kagajienazháldixa. Ekí kakzegakí naldiñguashíñki, kagajieni na, sha ajanashane abajiñga abaji, naxakualdinatshakna, nasga sha ajanashane kaxabeti, kekuanaka naldashá.” ");
INSERT INTO kog_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ekí kakbeñguenik ekí kakbeyá: “Maiñki zulda atshakldegéñ zhinik miñmeyaldatshak miñgajienakí nake, ¿sakí shi jika azhi káguba atshakldegéñ zhinik shi miñkaldiyaldatshak miñgajienaka na? ");
INSERT INTO kog_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","”Ake, ekí miñgajienakue. Zulda tiñgui nikaki Jatetshi múldigaba guakaga. ");
INSERT INTO kog_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Anuñka zulda jiúñguldak akjienaneki ekí guashi. Eñki káguba anuñka nekueki Jatetshi múldigaba aldukaldinik mitsá zegagáñga, jiséja ai múldigaba aldunaxa kekushi, kakjuizhanshixa. ");
INSERT INTO kog_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Anuñka zulda jagénaldi akjienaneki ekí guashi. Eñki anuñka nekueki Jatetshi múldigaba aldukatshak ubáñ me zʉnake zeñ kakldeshi iyapanka. ");
INSERT INTO kog_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ekí iyapananaldixa jiaga, zuldaja shijualda kagik jieñguazhámakbe aldunaxa muldetua kagajienazhá guanaldixa na, anuñka me nuxa namak ajañguatoxaldiéñ, mitsake ai namak ajañguane shalda sha kakuí, jibañ atuapanatshake namak ajañguaksá guxakue. ");
INSERT INTO kog_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Anuñka zuldaki kausú kenaldi akjienaneki ekí guashi. Eñki anuñka nekuejañki Jatetshi múldigaba aldukatshak namak ajañgualdinik, ");
INSERT INTO kog_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","jai kagik izhoxa ji kagajueshká za iyajani, naldagálde nuxa ‘kabia nexaldatshake auxabé nakzeshi izhoxaldikue shakldá’ iyajani na, jika matshuwi kaxaldexaldiamak za iyajani. Ekí zhinik na, kausúja zulda jutekuamakga, Jatetshi múldigaba kakjuizhanshi na, aldéñ janshizhe izhogakue kajañguamak izhogazhékue. ");
INSERT INTO kog_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","”Naldatshak jiak, anuñka zuldaki kagi janshizeñka akjienaneki ekí guashi. Anuñka nekueja zʉnake Jatetshi múldigaba aldukatshak, muldetua iyapani na, amak axajanashixakue. Ekí ashekualdatshakna, anuñka zuldaki matshuwi nek, anuñka míñgaki akldé matshuuwi nek, azhinik míñgaki gugasá zalda nekldamakbé Jate akldunamak ashekualdaldixa guashi na zulda shalda ekí miñmeñkú” na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ekí kakbejiñga na, Duwe Jesúja ekí shi kaxaldiyá: “¿Meja ezua muñshí zukuxa zuñguá gualdinik jika ipa, azhi jika sʉkldi íte guxa shi na? Ekí akuazhé, muldetua muñshí kakzukualdiamak mataxa iyaldaka. ");
INSERT INTO kog_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Akze, ji ziñ me nanaldixa auxaga muetsexaldixa. Ekíga na, ji meja aksʉ́ñ nanaldixa auxaga muetseshi, washexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Akna, saldiñga kuxa miñkaldikueke muldetua nukshi miñgualdí.” ");
INSERT INTO kog_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ekí kakbejiñga na ekí jiaga kakbeyá: “Nas ji miñmeyatokuge muldetua agajañgui minukaldí. Akze, miñgajienaldiamak mitsá kama milshaldiák, ake, jiak anuñkabeñga Jateja miñgajieñgualdixa. Ne azhinik míñgaki akldé jiaga miñgajieñgualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Akze, mieldeki ají múldigaba agajienaneki akldeñga agajieñgualdixa. Ekí ne, mieldeki agajienaldiamak kama ilshazhéki ji agajiena guane jiaga nuk akjuizhanshaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Duwe Jesúja ekí kakbejiñga na ekí jiaga shi kaxaldiyaldá: “Saldiñga netshi Jateja káguba kaksanekakueki sakí jana naldaka miñmeyaldikue. Aiki ezua zʉzikaja zulda nixaldinik ");
INSERT INTO kog_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","sesʉñ kabane azhi niuwisʉñ zʉtuaté noxaldiák jiaga, zhualduxañga sakí munatuka aksʉ́ñga guildegaté noxaldixa. ");
INSERT INTO kog_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Akze, kagiki zubuñguamakga zubuñgui na, axáñ misha axalda guildexaldinik gakue agaldiyapanaldixa. ");
INSERT INTO kog_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Gualdinik gakue akukanegaba gugakue ldiuwañ zegatshak nuk akuxaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ekí Duweja kakbejiñga na ekí kakbeyá: “Saldiñga netshi Jateja káguba kaksanekakueki, ¿ji jana ne, azhi ji jana izhalteka shi miñmeyanaka na? ");
INSERT INTO kog_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Aiki ezua zulda sanaki saldiñga zuldakue guashiñki zhaguáñ agatsé nuxa kagik aldixaldinik, ");
INSERT INTO kog_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","jiak guildegatshake saldiñga kaldi aldishi guane iskaitañga guildeka. Akna, gulda matshuwi axabunatshigake, exa nubákue sui zaldi iyaldakakue naldashá.” ");
INSERT INTO kog_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ekí shi kaxaldiyatoxamakbeñga na, Duwe Jesúja kágubakue Jatetshi múldigaba mitsá me axaldukshi, akiyapanaldixa katuauxabe matshuwi juizha jika azhi káguba atshakldegéñ za na shi kaxaldiyatoxá. ");
INSERT INTO kog_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Akze, jika atshakldegéñ naldakíki shi kaxaldiyakí na naldá. Naldatshak aldéñ shaxaldixakue na nuxa abatshake, sakí guashi guaklde muldetua kagajienaldiamak kakbeji na guatoxá. ");
INSERT INTO kog_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ai ldiuwañga tuañ zegapanatshak Duwe Jesúja aldéñ shaxaldixakue ekí kakbeyá: —Niwak ataba niñkauwa kanuwak kuizakbateshí. ");
INSERT INTO kog_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ekí kakbeñguake kágubakue abajañguenik, kanuwa Duwe izhoguega aldéñ nañga ajuldunguenik niwak aldeyaldá. Kágubakue jiaga axautshi kanuwak anuñka ajuldungueni axapa aldé. ");
INSERT INTO kog_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Amak agabategatogueñki múlkalda kamakualdi neyaldá, niwa jiaga kamakualdi kuiziji na, kanuwak ni sʉnexaldá. ");
INSERT INTO kog_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ekí zegatoguéñ, Duweki kanuwak numíldi jika bakaldak sáñkalda tene kabane na noxá. Noxakna aldéñ shaxaldixakueja uba agaldeñshi ekí axaldék: —Shi maldazʉñkaldixa, ni zʉnatuasáñgui, zʉnakuaxaldá guatshak jiaga, ¿mitséñ shi mikldék? ");
INSERT INTO kog_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Guñguake izhgaldagueniki múlkalda kamakualdi neyatogué, niwa kuizatogué ekí axaldék: —Te nogwá. Ekí niuwi agegatshaga na, múlkalda neyaksáni mokue janshibeñga ne na zexá. ");
INSERT INTO kog_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Guñgueni Duweja aldéñ shaxaldixakue ekí kaxaldék: —¿Jinak shi ekí zʉ́xaita zalda zhe miñzék? ¿Kaiga jiaga muldetua alduna nazishakíñga shi miná? ");
INSERT INTO kog_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Guatshak kauwizhéñki ekí atshaté atuatshakna zebuldú kakzeshi, “¡sakí shi ekí atshí!” ajañgui na, ataba atabañ zhinik: —¿Jalde sigíki me nak ekí múlkaldaja, niwaja amak axatshixa ne? —na izhgaldukajá. ");
INSERT INTO kog_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Guñgueni niwa uniñkauwa agabategatshake Jeldasa baxe aldé. ");
INSERT INTO kog_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Exaki Duwe kanuwak zhinik akjienatshake, ezua sigí jisétshi aldunakue ijuldune shuanekue abegaldi zhinik axaldák. ");
INSERT INTO kog_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Eñki jakateldi shuanekue abegaldi za izhuka. Ekí izhoshi jisétshi aldunakueja aksanegatshakna ni meja shakté akzegazháka, ni shezhashak jiaga shagaté kakzegazháka. ");
INSERT INTO kog_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Akze, axañga zhinik matshuwi juizha guldak, kasak shezhashak shagaté akuatshak jiaga, jiak shezhasha nuk zhikwati atshixa. Akna, ni meja agubiya guashi kama axaldaldazháka na naldá. ");
INSERT INTO kog_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ne aldéñki niuwisʉñ, sesʉñ jiaga gaxa akshá zaldi, jakateldi shuanekue abegaldi za mizhatoguéñ jaldáñ kauldi, jagik izhgisalshi zhikldabikshi za izhuka. ");
INSERT INTO kog_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nalgué Duwe maldé zeñka nagaté tuatshak naldajiñga axaldeji asták nuldu axayó. ");
INSERT INTO kog_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ekí Duweja tuwakna ekí jaldáñ axaldék: —Ma jisétshi alduna shane sigík zhinik ne guwá. Guakna akzʉxaitagáñga ai sigí jaldáñ ekí kaulshá: —Jesú mañki Jate akaldak akzetshi Asukuá giemi maldé, ¿sakí maldakualdixa ne? Saldiñga netshi Jate zʉnaldukaté, mañki guiyaba natuñshabaldáldi ni migakuañnekú. ");
INSERT INTO kog_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Guake Duweja jisétshi aldunak aklduká: —¿Me mixazhuka sha? Guñguake akiyó: —“Matshuuwi” naxazhuka nzha. Jinake naldakí. Jalde sigík matshuuwi ijulduñkalde nak. ");
INSERT INTO kog_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Guñguenik matshuwi juizha ekí Duwe axakuañnék: —Jeñgui baxe zhinik zʉnakzʉxaitsha guabaldáldi. ");
INSERT INTO kog_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Guatshake exaga gaxa akshá zeñka matshuwi mitu zatoguakna, ");
INSERT INTO kog_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","jisétshi aldunakueja Duwe ekí axakuañnék: —Uñguexa mitukuek kejuldunakue maldazʉnajañgualdí. ");
INSERT INTO kog_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Guñguake Duweja: —Ake, amak guwíñ. Ekí kakbeyatshakna, ai aldunakue sigík zhinik saldi akzʉxaitiñguenik mitukuek iyajuldú. Guatshakna mitukue matshuuwi anuñka 2.000 aldaldiñga niwa sáñkaldak guísʉgaxa pe pe pe akjienatshake, nuk ni izhgatuxá. ");
INSERT INTO kog_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ekí atuñguakna, mitu numañ tuñkakue aldaldiñga aldeñgueni kuíbulduk, eñgui akyó zhekuekuek jiaga ai shalda kakbeyá. Ekí aldukañguakna kágubakueja sakí amak zeklde atuál jeñ aldé. ");
INSERT INTO kog_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Aldeñguenik amak Duwe nugeñka aldeyatshake, sigí jisétshi aldunakue izheneki exaga ité atú. Eñki mokue muldetua alduna axaldeka, zhakuá jiaga itshualdí guane atuatshakna, zhe kakzék. ");
INSERT INTO kog_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Guñguakna Duweja sigí jisétshi aldunakue ijuldunane izheñshaté, mitu sakí agisaldaté atunekueja saldiñga atunauxa shalda nakldekuek agabeyá. ");
INSERT INTO kog_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ekí aldukañguakna Duwe mokue eñgui zhinik neyakue axakuañnexaldá. ");
INSERT INTO kog_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Guñgueni Duwe kanuwaxa juldunapanatshak, sigí jisétshi aldunakue izheneja ekí agakuañnék: —Migapa maldauldeyaldí. ");
INSERT INTO kog_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Guñguake Duweja amak atshakue jañguazhá guñguakna ekí akbeyá: —Mokue mijuldi maldeyaldinik Saldiñga netshi Sáñkalda sakí guañ majañgui, atemajañ janshi mikzukuane mijúk zaldakuek kabakbeyaldí. ");
INSERT INTO kog_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ekí akbeñguake amak ajuldi neñká, Duwe Jesúja mitsá atemajañ axatshane shalda guaxaldá. Ekí guashiñga na, Dekápuldi baxe zaldakuek jiaga ekíga kakbeyá. Ekí aldukatshakna saldiñgaja “¡sakí ekí janshi akzukuane ne!” na ajañguá. ");
INSERT INTO kog_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Eñka zhinik kanuwak mokue niwa ataba niñkauwa akbateguenik, Duwe Jesúki ai niwa xezhakga izhoguéñ kágubakue matshuwi axaldák. ");
INSERT INTO kog_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Atshaga na, exa juwí izhajuizhaldegeñka zalda sáñkalda Jailduja jiaga Duwe tual nak. Amak tuatshak asták nuldu axayoshi ");
INSERT INTO kog_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","agatsauxa ekí agakuañnék: —Nabunzhi nakshuixaldá guak nakshuishi guakuak, se makzukualdiamak káuxalda ipa gual najuxa maldeyaldí. ");
INSERT INTO kog_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ekí agakuañneguakna Duweja agapa neyatoguéñ, káguba duwá agapa neyatukakueja dañ agayoshi neyaldá. ");
INSERT INTO kog_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ai káguba kenañga na, ezua munzhi, ají mulbatája guxa guñguenik 12 kagi itsegatuka ");
INSERT INTO kog_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","nalguakna matshuwi méldikukueja iskaitshaldiamak jañgui tual neyatshak, iyazaxaitshagábaki, matshuwi guiyaba atuñshane. Ekí atshiji na, eñka ilzabiyaldiamak jika axaldauxa nuk saldikshatshak jiaga, ni meja iskaitshazháka atune. Akbiñgaki akldé akldeñga akzegapanane. ");
INSERT INTO kog_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nalgué “Duwejañki káguba se akzukuxa nzha” nukañguakna, káguba duwá zhekualgué kenañ Duwe shaneldi ga naguenik zhakuák juguá. ");
INSERT INTO kog_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jinake ekí juguazhá. “Naski Duwetshi zhakuá nuxaki jugualdatshake, se nakzukualdixa shakldá” jañguñguák. ");
INSERT INTO kog_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Amak juguatshakna, ubañga ají mulbatá tuaksáni, “mulbatá neskaitá shagú” akldék na gua. ");
INSERT INTO kog_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ekí zegatshaga Duweja ají kama nauwa izhé guxá akldexakna kágubakue katualdiamak izhbategueni ekí kaklduká: —¿Me shi zhakuák najuguá? ");
INSERT INTO kog_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Guakna aldéñ shaxaldixakueja akiyayó: —Duwe, kágubakue matshuwi dañ migayoshiñgaba guatshak, ¿sakí shi “¿me shi zhakuák najugú?” izukamildaka na? ");
INSERT INTO kog_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ekí agabeyatshak jiaga, Duweja atezhak zhekualdekuek meja se akzegexañ juguane akualdaldiamak katualga na noxá. ");
INSERT INTO kog_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Guakna ai munzhi Duweja se akzukuá guane akldeshi na, zhe akzeshi, tau tau atshijiñga, asták naguenik nuldu axayoshi na, ibaja naldakí namak akbeyá. ");
INSERT INTO kog_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ekí nukañguakna Duweja akbeyá: —Nabunzhi, mañki “neskaitshaka shakldá” najañgui, alduna maldeshéñ zhinik na se mikzék ni gu. Akna, auxaga se mikzék guane, aldunaxa señgaba mikzeshi neyabikuká ni gu. ");
INSERT INTO kog_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ekí akbeyatogueñga na, ezuakueja sáñkalda Jaildu ajuxa zhinik ekí agabeyal aldák: —Mibunzhiki au shua ni gua. Akna Duwe mijuxa neyakue akbeyalga nogakue migatsaldaksá ni gu. ");
INSERT INTO kog_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Duweja ekí nukatshak jiaga ai nukagába, sáñkaldak ekí akbeyá: —Migabeñká mitsheñshagábaki, nas za na muldetua alduna nazisha makualdí. ");
INSERT INTO kog_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ekí akbeñguenik kumí shuaneñka neyapanatshak, aldéñ shaxaldixakue Péguldu, Santiaku, aitshi akaja Juañ na nuxa agapa kauldé. Ai zhiniki axautshikuega ni me agapa neyakue jañguazhá. ");
INSERT INTO kog_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sáñkalda tshuxa aldeyatshake, ezua shuigatshak katshamakga, káguba nakldekueki jaldáñ shuane axabauwaté Duweja tuatshakna, ");
INSERT INTO kog_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","eni juldunguenik ekí kakbeyá: —¿Jinak shi ekí agatsaldi jaldáñ mauwabinók? Kumíki shuigazháne, egaba kabashi na guatók. ");
INSERT INTO kog_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ekí kakbeyatshak shuane kakualguakna Duwe iyashimá. Guatshak jiaga nuk kakzʉxaitshiñguenik shuanetshi ajaba, ajate, aldéñ shaxaldixakue maigua agapa nakldekue za na agapa shuane nugaldi kajuldukshá. ");
INSERT INTO kog_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Eniñga na, Duweja kumí shuane káuxaldak akpañguenik ekí akbeyá: —Taldita, kum. Ekí guagatshake ekí guashi: “Munzhi zhauwa, izhgaté guwá ni mikbeñkú.” ");
INSERT INTO kog_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ekí akbeyatshaga na, izhgaldagueni mizhaldá. Guatshak kumíki 12 kagi itsegatuka. Ekí zegaté atunekuejañki “¡sakí mokue ekí izhgaldaká!” agubisha iyajaná na aldoxá. ");
INSERT INTO kog_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ekí guatogatshak jiaga, Duwejañki ekí atshane shalda ni mek jiaga akbeyasé giemi na kaxaldexá. Guñgueniki Duweja kumí gakue akauwal guak na gua. ");
INSERT INTO kog_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Exa zhinik neñguenik, Duwe Jesúki mokue ají kuíbuldu guildekldeñka aldéñ shaxaldixakue juizhiñga ne. ");
INSERT INTO kog_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Exaga izhgasekué ldiuwañ zeguake, aldéñki juwí izhajuizhaldegeñka shizhiyaldá. Ekí shizhiyatshakna aldukatoguekuejañki “¡sakí ekí janshagatsaldi shi zʉñkaldixá!” ajañgui na ekí izhgaldukaldá: —¿Eñki mani ekí agatsaldi shizhiya shitiyane ne? ¿Meja ekí ishkué nalda shaxaldiyatogué? ¿Sakí ekí ajanashaté tu guañkáaldamak jiaga atshixa ne? ");
INSERT INTO kog_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Eñki kalgauxa tsukua nuxa naldazhé shi na? ¿Ajabaki Maldiya naldazhé shi na? ¿Eñki Santiaku, Jusé, Judá, Simóñ ekuetshi atuwé nuxa naldazhé shi na? ¿Ajasʉkueki jai nauwikenáñga izhogakí shi na? Ekí axajani na, ji kakbeñká axaldukazháldi, iyapanazhá. ");
INSERT INTO kog_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Guakna Duweja ekí kakbeyá: —Akze, ezua Jatetshi múldigaba naldiñga zʉxaitshixaga mashi neyatshak akzé jañgui axabeti, iyapanka. Ne akuíbulduk zaldakue, akajakueja, ajúk zaldakueja niñkauwañki axabetazháldi, akzé ajañguazhé nakldá. ");
INSERT INTO kog_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Guakna Duweja exa guildekldeñkaga janshagatse ajanashaté atú guazhámak kaxatshazháka tuakna, egaba anuñka me mulbatá akzekakue káuxalda kepañgui se kakzukuá. ");
INSERT INTO kog_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Guatshak Duweja exa zaldakue “¿sakí ekí namak naxajanazháka ne?” na akldexá. Guñgueni Duwe Jesúki anuñka kuíbuldukueni shizhiji na neyatoxá. ");
INSERT INTO kog_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ekí atshatoguéñ na, aldéñ 12 shaxaldixakue kajuizhakuatshak jisétshi alduna kágubak ijuldunekue iyaldeñshaldiamak niuwi kageshi na mozhua, mozhua ishkapa kakaxá. ");
INSERT INTO kog_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Amak kakagapanatshak ekí kakbeyá: “Ekí mimakaxaldatshak, ji miñgajuezhaldixa uldeyagábaki, kaldi miñté mineñka za miyuldeyaldí. Akna gamá jiúñguldak miyuldeñka, gakue, ni paldata uldeyabináldi. ");
INSERT INTO kog_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Egaba sapatu za na minjiu, zhakuá mozhua uldeyagábaki, ezuañgaba minjua mineyaldí.” ");
INSERT INTO kog_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ekí kakbeji ekí jiaga kakbeyá: “Amak neji, ezua kuíbulduxa mineyaldinik mielde tshuxa minapanaldiake, eñka za kabashiñga mokue eñ zhinik mineyaldí. ");
INSERT INTO kog_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ne mashiki miñkaldukakí, mimeyapanasʉ́ñ kakzexaldiake, eñ zhiniki ne miñgualdí. Neyabipanatshake Jateja guiyaba katuñshaldixa ne katuñshi na, kaksibuldi kasak zhiktiñguá mineyaldí. Namak miñmeyaldikue. Jateja káguba agatsaldi azhi agatsaldakí ne tualdixa niuwañ zegatshak, Suldumaxa, Gumuldaxa zaldakue guiyaba katuñshaldixa guashiñki, zhakaldak ejié kuíbuldu zaldakue katuñshaldixa nakldá” kakbeji na kakagapaná. ");
INSERT INTO kog_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Amak kakaguake san, san aldeñguenik kágubakuek: “Maiñ sha miyatshixakue majiñga maja xaldeki Jatek agakualdi guwíñ” agabeyá. ");
INSERT INTO kog_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ekíga na, jisétshi alduna matshuwi kágubak ijuldunekue kezheñshi, matshuwi mulbatá akzekakueki mantixa nauwa iyabeshi se kakzukui na aldeyatoxá. ");
INSERT INTO kog_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Guatshak sáñkalda Eldodejañki Duwe Jesú atshatoguauxa shalda akuagaté nuká. Akze, matshuwi kágubakueja Duwe shalda akuashiñga ezuakuejañki: “Eñki Juañ nik majaukshakuega shuane mokue izhgatene naldaka nakldá. Akna janshizhe ajanashaté atú guazhámak jiaga atshaka kama axaldé nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Guatshak ezuakuejañki “Jatetshi múldigaba naldiñga zʉxaitshixa Eldiyaga naldaka nakldá,” ezuakuejañki “Jatetshi múldigaba naldiñga zʉxaitshixa mauzeñga zalda janañga naldaka nakldá” na akuagatoxá. ");
INSERT INTO kog_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ekí nukatshakna sáñkaldaja ekí guak: “Eñki Juañ nik majaukshakuega nukshí. Naldiñki nasga sáñkalda ibeñguakue guakldalgukuamak akuaxa guane ne, mokue izhgate nukshí.” ");
INSERT INTO kog_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Sakí zekldane nak ekí jañguazhá. Aldéñki akaja giemi Pildipitshi asewá nane Eldodia izhgakuxane nalgué shalda Juañjañki “Jatetshi guiyabajañki mikaja iteñga nogeñgaki asewá guxa guasʉ́ñze guaka ni matú” axaldék. Ekí axaldegué shalda na, sáñkaldaja nusá akzeshi Juañ guxal guagueni kalseldi shezhasha iyatenega megakue niuwi ge. ");
INSERT INTO kog_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Juañ ekí neklde nalgué shalda na, ai munzhi Eldodiajañki akjuizhanáaki aguldijiñgaba guaxa gundana akzegatshak jiaga, amak atsha akzegazhá. ");
INSERT INTO kog_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Jinake naldakí. Asewá sáñkalda Eldodeja niñkauwañki Juañki Jatek akldunamak jian izhuka akualguakna zhe akzukui, numañ tuwi izhoxák. Akbiñgaki aldéñki Juañja shizhiyaté nukatshak, “sakíga ni atshanakldék” aldunaxa akldegakí naldatshak jiaga, axaldukandana akzeka. ");
INSERT INTO kog_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nalgué, kagi itseklde noguéñ akldé akzé axakyokuekue, ají suldáutshi sáñkaldakue, Galdildeya baxe zalda akldé akzekuegaba abuzatiakue kakbenekue axaldák. Atshaga na asewá Eldodiajañki Juañ sakí guaka akzá. ");
INSERT INTO kog_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Amak ajuizhaldekldalguéñ ai munzhitshi abunzhi eni juldunguenik kagakuizatshakna ajate zhakak, abuzál nakldekue jiaga matshuwi zeñ kakzukuá. Guakna ajate zhakajañki ekí akbeyá: —Ji nakshishindana mikzexaldiake amak migexaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Akna, ji maldakshishaldiake amak migeshiñga na, jejié kagi aksanekuge jiaga muan nakshisha makualdiák, migenaka ni mikbeñkú —axagilté. ");
INSERT INTO kog_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ekí akbeñguake akzʉxaitiñgueni ajabak ekí akldukal ne: —¿Ji akshishanaka ska ekí nakbé? Guake ajabaja ekí aksanék: —Ake, Juañ nik majaukshakue tsáñkalda mikuldagakue makshishaldí. ");
INSERT INTO kog_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ekí aksaneguák gaiya mija sáñkalda nugaldi neñgueni ekí akshishá: —Ake, kaigaga Juañ nik majaukshakue tsáñkalda jika bakaldak iyatenega jai nakuldagakue ni jañgukú. ");
INSERT INTO kog_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ekí akshishatshak sáñkaldaki zʉxaita itshanatshak jiaga, abuzál nakldekueja aldukaté, gaiyak ji akshishatshak amak agexaldixa axagiltene nalguakna, “mixatshazhánaka nzha” axaldegasʉ́ñ na atuwá. ");
INSERT INTO kog_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ekí atuwakna ubañga ezua ají kabuk Juañ sáñkalda ibeñguá xaldeki uldagakue niuwi agé. Guakna amak kalseldi neñgueniki Juañ sáñkalda ibeñguñgueniki ");
INSERT INTO kog_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","jika bakaldak itenega amak gaiyak akualdaguake aldéñ zhiniki ajabak agé. ");
INSERT INTO kog_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ekí agatsaldi Juañ akuaxane aldéñ shaxaldixakueja aldukañguake ají abuá akugueniki shuanekue abegaldi abexá na akuá. ");
INSERT INTO kog_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Guatshak Duweja aldéñ shaxaldixa gaxanekue mokue axaldagatshak, kauwizhéñ shizhaldiji ajanashatonauxa agabeyá. ");
INSERT INTO kog_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Atshakna, matshuwi kágubakue atuál axaldagatshakna ni gakue ga guashi jiaga niuwi kaxaldaldakí. Nalguakna Duweja ekí kakbeyá: —Maiñ za na nagapa sʉnjá zaldi kuizaldi. Exa na nauwa mizhiksekualdixa nzha. ");
INSERT INTO kog_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ekí kakbeñguakna kauwihezuañgaba sʉnjá zaldi kanuwak aldeyaldá. ");
INSERT INTO kog_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ekí aldeyaldixa ajañguatshak jiaga, kágubakueja neyaté atú. Ekí atuñguakna, saldiñga kuíbuldu eñgui baxe zaldakueki kagik ga aldaldiñga Duwe neyaldieñka kauwizhéñ mishañga jeñ aldé. ");
INSERT INTO kog_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Gueni Duwe eñka akbategatshake, káguba duwá ajuizhaldekldekue katuatshakna guañ kajañguá. Jinake ekí kajañguazhá. Ekueki jubejukue ezua kaksaneshi, numañ katuñka kaxaldaldagálde jana katuwakna matshuwi jika shi kaxaldiyaldá na gua. ");
INSERT INTO kog_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Atshaga na, au niuwi yaldaxaldá guapanguakna, aldéñ shaxaldixakueja axaldaxeni ekí agabeyá: —Au niuwi yaldaxaldá guapanashá. Ne jaiki káguba izhogazháldi, ni ji jiaga naldakí nakna ");
INSERT INTO kog_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","kágubakuek “au neyabiñkuká na gu” kakbeyá guwá. Ekíki kuíbuldukueni, eñgui baxe gakue ishkajabiji aldeyapanaldiamak. ");
INSERT INTO kog_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ekí agabeyatshak jiaga, Duweja ekí kakiyó: —Maiñga gakue miyakauwaldí. Guake akiyayó: —Ake, káguba anuñka nekue kakáu guashi jabiyakualdiamake, 200 ldiuwi kasa izhgáu naldashi paldata jiba akbeyakue naldaka. Ne ¿sakí shi amak kakáu guashi jabiyakualdixa na? ");
INSERT INTO kog_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ekí agabeyatshak Duweja ekí kakbeyá: —Mitsá gakue miñkaldé tuate guwíñ. Guake amak atuñguenik ekí agabeyá: —Jatshiwa pañ, mozhua pikáu me nuxa ni zʉñkaldá. ");
INSERT INTO kog_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Guñguake Duweja kágubakue anuñka, anuñka zhikzhekualdi kaldá kaldeldi iyaldaxal kakbeyakue guak. ");
INSERT INTO kog_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ekí kagabenalguamak kágubakue 50 naldashi, 100 naldashi negaba san san ashená. ");
INSERT INTO kog_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Guñguake Duweja jatshiwa pañ, mozhua pikáu nalgué zhiksuigueniki mateldi stuaté noshi, Jatek ai shalda “zeñ nzhakldék” akbeyá. Ekí akbeñguenik pañ zhikwatiyatshak matshuwi zhikldekshi aldéñ shaxaldixakueja kágubakuek kakauwaxañ kagé. Ekíga na, pikáu mozhua nalgué zhikldeklde saldiñgaja galdiamak kakauwaxañ kageguake ");
INSERT INTO kog_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","amak agaxauwatshakna, saldiñgaja gaji yau kakzék. ");
INSERT INTO kog_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ekí asatshak jiaga, Duweja shaxaldixakueja pikáu, pañ abanegaba 12 nuldi jialda na akuashá. ");
INSERT INTO kog_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Atshaga na káguba matshuuwi nekue amak asatshak, sigíkuegaba iyazatatshak 5.000 nekue ashekualdi na asajá. ");
INSERT INTO kog_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ekí Duweja kágubakue kakauñgueniki “mimijuldi neyabiñkuká ni gu” kakbeyatogueñga, aldéñ shaxaldixakueki kanuwak ajuldungueniki aksajañga ataba niñkauwa kuíbuldu Betsailda neyamak akbategakue kakbeyá. ");
INSERT INTO kog_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aldéñki amak kágubakue nuk kakagueniki ahezua gaxa akshá zeñka Ajate axazguaxal nitshí. ");
INSERT INTO kog_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Guñgueni ahezua axazguashiñga tuañ zegapanatshake, aldéñ shaxaldixakueki kanuwak niwa mitakuaxa maldé zeñka aldeyaté na noxá. ");
INSERT INTO kog_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nogueñki Duweja katuatshak aldeyaldialdi zhinik múlkalda kamakualdi kaxabushiñgaba kanuwa akbé akbé uldeyaxañ jibañ kakzukuí awaldeyaté katú. Ekí awaldeyatoguéñ muñzeshi zegapanatshake Duwe gagaxa zhinik zabiñgueni, niwa bakaldak ga kasam kaxaldashi keskaiti neyaldá. ");
INSERT INTO kog_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Amak niwa bakaldak ga kasam kaxaldagaté atuatshakna, alduna nuxa kakizhañkaxá ajañgui na jaldáñ axauldá. ");
INSERT INTO kog_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jinake ekí axauldazhá. Ezua nagaté atuatshak she she she kakzexák. Guakna ubañga Duweja ekí kaxaldék: —¡Señgaba miñzegwíñ! Nasga na nakú. ¡Zhe miñzegagába! ");
INSERT INTO kog_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Gueni aldéñki kanuwaxa juldunatshake, múlkaldaki neyaksáni, muldetuañga ne na zexá. Ekí atuatshakna “¡sakí ekí atshixá!” na ajañguá. ");
INSERT INTO kog_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jinake ekí ajañguazhá. Duweja gakue matshuwi nekshaté atuatshak jiaga, aldunaxa kuamaldekldekue aldalguakna ekí atemajañ atshaka kagajienazhá guane naldák. ");
INSERT INTO kog_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ekí Duwe Jesúki aldéñ shaxaldixakue na, niwak atabañ niñkauwa Jenesaldé baxe agabategueniki kanuwaki aiga axaldiyá. ");
INSERT INTO kog_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Guatshak agajienatshaga Duwe Jesú naklde atuatshakna, ");
INSERT INTO kog_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","saldiñga eñgui baxe nahauxa izhgabeyal, aldaldiñga aldé. Guakna kágubakueja mulbatá akzekakue jikak axashanega Duwe mashi izhuka aldukañgueñka akualdák. ");
INSERT INTO kog_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Akze, Duwe mani neyaldi, kuíbuldukueni azhi eñgui baxe neyatshak mulbatá akzekakue akualdashi, káguba zheneñka abuashiji na: “Mulbatá zʉñkakzekakue mijí zhakuá sʉxa nuxaki ajuguaka majañgualdí” na axakuañnexá. Amak kajañguake, saldiñgaja egaba ají zhakuá ajuguatshake saldi se kakzék na gua. ");
INSERT INTO kog_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Guñgueni paldiseyukue, anuñka guiyaba shizhixakue na Jeldusaldéñ zhinik nakldekueja Duwe Jesúk axaldagueni, ");
INSERT INTO kog_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","aldéñ shaxaldixakueki káuxalda itshizhakuamak itshizhagába, kakzaldaldekldekuega zapanká atú. ");
INSERT INTO kog_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jinake ekí atuazhá. Juldiú sanátshi abamakueki zagáñga káuxalda akzaldaldeklde janshi axazgualdiamake sakí itshizhakue naldakldegamak shizhaldixa. Naldakna saldiñga paldiseyukue, nauwisaná juldiúkue ekí itshizhagáñga asazhé. ");
INSERT INTO kog_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ekíga na, gakue nabeyasajeñka zhinik aldaxaldinik káuxalda itshizhakuamak itshizhagáñga asazhé. Ekibeñga na, nauwibamakue matshuwi sakí sakí atshixa nanamak agatsaldi ajanashiji na jaldu, puti, shauldu iyajishka nanamakga ajanashixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ekí izhukakue nalguák paldiseyukue, guiyaba shizhixakueja Duwek ekí agalduká: —Shi migitixakueki ¿jinak shi nauwibamakueja sakí atshakue zʉñgatsé guakldanamak ajanashakí na? Jinake ekí mikbeyakí. Kauwizhéñki nauwibamakueja zagáñga sakí agatsaldi káuxalda itshizha xalde zakue guaka ne amak itshizhagáñga káuxalda kakzaldaldekldega asaxa nak. ");
INSERT INTO kog_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Guñguake Duweja kakiyó: —Maiñki Jatek amak miyatshixa ga abeldashi mizhekue nakna, Jatetshi múldigaba naldiñga zʉxaitshixa Isaiyaja sakí miyatshaldixa guashi gauwanamak miyatshixa: “Jejié kágubakueki múldigabak nuxa naxabetixakue ga naxazakuakakue. Naldatshak aldunaldi zʉnake najañguazháldi, nagajué za izhukakue. ");
INSERT INTO kog_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Akna axesé nuxa akldé nakzamakga nagazukuxakue. Jinake naldakí. Nas kakbeñkugamak shizhiyagábaki, kágubaja atshakue janaktune niñkauwañki shizhaldixa nak.” ");
INSERT INTO kog_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ekí sezhekldamakbeñga na, maiñki Saldiñga netshi Jateja sakí atshakue guiyaba zʉñkabajane atshagábaki, mimibamakueja sakí atshakue shizhaldiyanamak niñkauwañki miñsuikualdi ulditshixabinuka. ");
INSERT INTO kog_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Gueni ekí jiaga kakbeyá: “Ekí atshiji na, mimisanákueja sakí atshakue shizhaldiyanamak miyatshaldiamake, Saldiñga netshi Jateja sakí atshakue niuwi zʉñgene niñkauwañki amak atshakí naldashibiná. ");
INSERT INTO kog_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Jinak ekí miñmeyakí. Jateja nauwibama Muesék zhinik ekí guiyaba atsha nexaldixa zʉñkagene: ‘Mijate, mijaba akzé jañgui, kaxabetakue. Mieldejañki ajate, ajaba aguldiji, nusa agatsaldi sha axaldexaldiake shuigakue agatsaldaldixa nakldá.’ ");
INSERT INTO kog_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ekí guiyaba zʉñkabajane ne, maiñ zʉnake kágubakuek ajaba, ajate kaxabetazháldi, janshibeñga ekí axaldegaka shi miyaxaldixa: ‘Nas migaunekldaka naxaldé ne nuk Jatekgaba agexaldikue janaktú guanuge nakna, migaunegazhánaka ni atuñkú.’ ");
INSERT INTO kog_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Akna mieldeki ekí atshaldixa nexaldiake, maiñ ajatekue axabeti agaunegakue kaksanexabíne. ");
INSERT INTO kog_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ekí mimisanákueja atshakue shi miñkaldiyanamak atshiji na, Saldiñga netshi Jateja ají múldigabak sakí atshakue guaká niñkauwañki akzukuabiñsáni atshashibiná. Ekí atshijiñga na, axautshi atshá shi miñkaldiyanamak atshiji Jateja guaká niñkauwañki atshakí izhogashibiná.” ");
INSERT INTO kog_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ekí kakbeñgueniki Duweja káguba duwá zhikzhe zhekualdekue axaldagakue kakbeyeni ekí kakbeyá: —Ji miñmeyaldikue saldiñgak muldetua izhgajieñgui, nukaté nogwíñ. ");
INSERT INTO kog_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jateja tuwiñki, kágubaja jigabá gajéñ zhinik nuxa akzaldakuazháka tuñka. Akze, kaxak zhinikga jiak, ji múldigaba nusagatsaldi guagéñ zhinik guana zhikzaldakuxa tuñka nakldá.  ");
INSERT INTO kog_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mielde kuxa miñkaldikueke muldetua nukshi miñgualdí. ");
INSERT INTO kog_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Guñgueni Duweja kágubakue kabaji, juldi juldunatshak aldéñ shaxaldixakueja ekí agalduká: —¿Ekí makuakáki, sakí guashi shi gakue me zʉñzaldakuazháka makuák? ");
INSERT INTO kog_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Guake kakiyó: —¿Sakí shi maiñ jiaga miñgajienakíñga ne minakbé? Azhi ¿sakí shi miñgajienakí na? Akze, jigaba miñgaldiák Jateja tuwiñki, aija miñzaldakuxa tuazhé. ");
INSERT INTO kog_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Jinake naldakí. Jigaba miñgatshak dzhizhaldi migatanaldinik ganukshaja egaba zʉxaitshixa naldashá. Duweja ekí guagatshake, saldiñga gakue agatséki janshibé ganazʉnakagaba ne zʉñmeji na ekí guaxá. ");
INSERT INTO kog_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ekí guashiñga na, ekí jiaga kakbeyá: —Akze, Jateja tuwiñki aldunaxa zhinikga ji múldigaba nusagatsaldi guashi, sha atshéñ zhinik guana, zhikzaldakuxa tuñka nakldá. ");
INSERT INTO kog_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Jinake ekí miñmeyakí. Kágubaja aldunaxa zhinik guana, saldiñga sha atshaldixa janaktuatuka. Exa na, nusagatse jañgui, asewá naldagálde na askuildexaldixa, abuá na atsha guasʉ́ñzamak ajanashaldixa janaktuatuka. Exaga na, tushexaldixa, axautshi guaxa atshaldixa, ");
INSERT INTO kog_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","saldiñga jika kauwijígaba naldakue za ajañgualdixa, axautshikue shane kaxatshaldixa, naldagálde nuxa ne axautshi jian agazukualdiamak azakuaxaldixa, jiwak zaldaba atshaldixa, axautshi aldunaxá aguanaldixa, axautshi nalda aguaxaldixa janaktuatuka. Exaga na, kauwizhéñ za kakzé izhajanaldixa, jigabá axesé atsha atshaldixa janaktuatuka. ");
INSERT INTO kog_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Saldiñga nusagatse atshá kágubaja ekí aldunaxa janaktuatshakna, aija guana káguba akzaldakuxa Jatejañki tuñka naldashá. ");
INSERT INTO kog_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Exa zhinik Duwe Jesú neñgueniki kuíbuldu Tildu Sidóñ baxe ne. Exaki ezua tshuk juldunatshak ni meja akualdazháldixa jañguane nalgué kágubakueja kakwashék. ");
INSERT INTO kog_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Exaga na, ezua munzhi abunzhiki jisétshi alduna ijuldune nalguakna, Duwe exa izhuka nukañguakna ubañga axaldagueni nuldu axayoshi ");
INSERT INTO kog_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ekí agakuañnék: —Nabunzhi jisétshi aldunaja ijuldune izheñshi makualdí. Guatshak ejié munzhiki nauwisaná naldagálde, kagi Penisia, Sildia baxega zalda. ");
INSERT INTO kog_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Guake Duweja ekí akiyó: —Axáñ nají sukuakue misha gakue kakldunauxa nugakauwí. Akze, sukuaja gakue gatuka ikuxa xaldeki piyuk aguteya atshasé naldaka naldashá. ");
INSERT INTO kog_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ekí akbeyatshakna munzhijañki ekí akiyó: —Nají Sáñkalda, namak ni makuák. Naldatshak piyu jiaga sukuakueja gakue gatuka agakjienane meñki ga guxaga naldashá. ");
INSERT INTO kog_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Guake Duweja ekí akiyó: —Namak ni maldakbé. Akna, mibunzhiki au jisétshi alduna izhé, se akzék na gu. Akna mijuldi neyabikuká ni gu. ");
INSERT INTO kog_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ekí akbenalguamak ajuxa neyatshake, au abunzhiki jisétshi alduna izhene, se akzeklde kabagéñ ité na tuwá. ");
INSERT INTO kog_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Guñgueni Duwe Jesú aldéñ shaxaldixakue nañga exa Tildu baxe zhinik neñkáki Sidóñ baxe zʉxaitiñgueni, Dekápuldi baxe niwa Galdildeyaxa agataná. ");
INSERT INTO kog_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Exa na, ezuakuejañki ezua sigí zukagálde, muldetua akzʉwashegagálde Duwek akualdeyeni ekí agakuañnék: —Jejié se akzexaldiamak káuxalda ipañgui makualdí. ");
INSERT INTO kog_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ekí agabeyake Duweja ai sigí kágubakue kenañ zhinik ahezua agajué zeñka uldé. Exaki ají káuxalda buldu sigítshi kuxak mozhuañga akjuldukshiñgueniki ají káuxalda bulduga jutú tup tup atshiji, sigítshi juáñgalda juguá. ");
INSERT INTO kog_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Gueniki mateldi stuaté noshi, atemajañ jubí akzeshi, ekí axaldék: —¡Epata! Ekí guagatshake “makpezha guwá” guashi. ");
INSERT INTO kog_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ekí akbeyatshaga na, kuxa magakpezhi zukaldá. Juáñgalda muldetua wi wi axatshiji, janshagatsaldi zukuaxaldá. ");
INSERT INTO kog_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Guñgueni Duwejañki exa zhekualdekuek aldéñ ekí atshane shalda ni mek jiaga akbeyasé na niuwi kagexá. Ekí niuwi kagegatshak míñgaki akldé akldeñga na Duwe sakí atshaté atune shalda akuashiñgaba na akuapaná. ");
INSERT INTO kog_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Guatshakna saldiñga kágubakueja zʉxaita zalda “¡sakí ekí atshixá!” ajañgui na: “Duwe Jesúki saldiñga atemajañ janshibeñgaba ni atshí. Akbiñgaki zukagáldekue kazukshi, zukuagagáldekue kazukuakshi ni atshí” na izhgabeyá. ");
INSERT INTO kog_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Atshaga na, mokue káguba duwá zhikzhe ajuizhaldék. Aikueki ji gakue kaxaldaldakí ne Duwe Jesúja katuatshakna, aldéñ shaxaldixakue kajuizhakui ekí kakbeyá: ");
INSERT INTO kog_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Kágubakue au maikldiuwi naldukshi naxapa aldogatshake, ji gakue kaxaldaldakí nakna guañ kajañgundana nzhakzék. ");
INSERT INTO kog_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Akze, anuñka nekueki maldé zeñka zhinik aldakldekue nak, maldija kakuiñga kauwijuldi kakashi guanugake, jiúñguldak me se kaktanaka nak, ji axagáldekuega kakagasʉ́ñ nzhakzék. ");
INSERT INTO kog_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ekí kakbeyatshakna aldéñ shaxaldixakueja ekí akiyayó: —Jai káguba izhogazhéñ ne, ¿miya zhinik shi káguba anuñka zhekue kakáu guashi gakue niyakualdixa na? ");
INSERT INTO kog_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Guake Duweja kaklduká: —¿Ne mitsá me shi jika miñgaldixa miñkaldá? Guake akiyayó: —Kugua pañ nuxa ni zʉñkaldá. ");
INSERT INTO kog_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ekí agabeñguake Duweja káguba duwá zhikzhe nakldekue: “Jeñ yaté shi akuí.” Guagueniki Duweja kugua pañ zhiksuigueniki Jatek ai shalda “zeñ nzhakldék” akbeyá. Ekí akbeñguenik pañ zhikwatiyatshak matshuwi zhikldeshi kágubakuek kakauwaxañ aldéñ shaxaldixakuek kageguake amak agaxáu. ");
INSERT INTO kog_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ekíga na, pikáu abuldu anuñka nuxa kaxaldalgué jiaga, Duweja Jatek ai shalda “zeñ nzhakldék” akbeñguenik ai jiaga zhikldekshi kágubakuek kakauwakue kakbeyá. ");
INSERT INTO kog_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Amak agaxauwatshakna, saldiñgaja gaji yau kakzék. Ekí asatshak jiaga, kagabanegaba aldéñ shaxaldixakueja kugua nuldi jialda akuashá. ");
INSERT INTO kog_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Atshaga na, matshuwi nekue anuñka 4.000 naldashi ashekualdi na asajá. Ekí kakauñgueniki Duweja “mimijuldi neyabiñkuká ni gu” kaxazguashi, kaxaldegatoshi na, ");
INSERT INTO kog_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aldéñ shaxaldixakue juizhiñga kanuwaxa juldungueni niwak akbateshi Dalmanuta baxe ne na gua. ");
INSERT INTO kog_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Guatshak paldiseyukue Duwe Jesú axaldagueni múldigaba axasashaldá. Ekí axasashiji na, akuajaldiamak kakldeshi ekí axaldék: —Mañki Jate jékaldaxa izhuka naldi jai kagik makaxanamak ne maldazʉnatuñshaldiamake, ezua janshizhe ajanashaté tu guañkáaldamak zʉñkatshá makualdí. ");
INSERT INTO kog_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ekí agabeyatshakna Duweki atemajañ jubí akzék gui na ekí guak: —¿Jinak kaiga zhekualdabinukakue Jateja kagik nakaxanamak ne mimatuñshaldikuamake, mokue ezua janshizhe ajanashaté tu guabínamak atshakue minakshishixá? Namak miñmeyaldikue. Ekí minakshishatshak jiaga, amak mimatuñshi miñkatshazháldikue nzha. ");
INSERT INTO kog_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ekí kakbeji kabajañguenik, aldéñ shaxaldixakue na mokue kanuwaxa juldungueni niwa ataba niñkauwa akbaték ne na gua. ");
INSERT INTO kog_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ekí kanuwak agabategatogatshake Duweja shaxaldixakue pañ axaldixa kakjuizhani na ezua me awaldene atú. ");
INSERT INTO kog_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Guake Duweja ekí keshkaldukshá: —Maiñ paldiseyukuetshi, sáñkalda Eldodetshi pañ ishkishshixak be axaldoshi, muldetua numañ miyatualdí. ");
INSERT INTO kog_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ekí kakbeyatshakna, ataba atabañ zhinik ekí izhgabeyá: —¿Pañ uldagazhá guáñkalde nak ekí zʉñmeyakí shi na? ");
INSERT INTO kog_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Guatshake Duwejañki sakí izhgabeyatuka akualdi na, ekí kaxaldék: —¿Jinak shi pañ ishkishshixa miñmeyaldatshake, maiñ pañ uldagazhámine shalda mizhikbé? ¿Kaiga jiaga me naugé, sakí atshanaka miñgajienakíñga shi na? Azhi ¿aldunaxa kuamaldekbine naldi miñgajienasʉ́ñ shi miñzék? ");
INSERT INTO kog_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Uba miñkué naldatshak jiaga, ji mituwéñ zhinik ¿jinak shitiyakí shi miná? Kuxa miñkaldikue naldatshak jiaga, ji minukaxa zhinik ¿jinak shi miñgajienakí na? Ekí atshaté natumine ¿be miñgisegakí shi na? ");
INSERT INTO kog_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Naldiñki jatshiwa pañ zhikwatiji matshuwi zhikldekshanuge káguba matshuuwi 5.000 nekue asatshak jiaga, abanegaba ¿mitsá nuldi jialda kuashamine shi na? Guake akiyayó: —Akze, 12 nuldi na kakuashiñgú. ");
INSERT INTO kog_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Guake Duweja: —Ekíga na, mitsáte shi kugua pañ zhikwatiji matshuwi zhikldekshanuge káguba matshuuwi 4.000 nekue asatshak jiaga, abanegaba ¿mitsá nuldi jialda kuashamine shi na? Guake: —Akze, kugua nuldi na kakuashiñgú. ");
INSERT INTO kog_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Guake Duweja ekí kaxaldék: —Ne ¿sakí shi maiñki kaiga jiaga sakí atshanaka miñgajienakíñga na? ");
INSERT INTO kog_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Guñgueni kuíbuldu Betsaildaxa aldeñguenik ezuakueja sigí uba isé Duwe Jesúk akualdeñguenik ekí axakuañnék: —Jejié sigí uba mikukshaldiamak káuxalda ipañgui makualdí. ");
INSERT INTO kog_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ekí agabeñguake Duweja ai sigí káuxaldak aksuiñga kuíbulduk zhinik akzʉxaitshá. Exaki Duweja ubak jutú tup tup guñgueni káuxalda mozhuañga ipañgui ekí aklduká: —¿Jika tuabikuká gue? ");
INSERT INTO kog_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Guake stu stu atshiji ekí akiyó: —Akze, au stu ni gukú. Gualdatshak kágubaki muldetuañga kagatsamak tuakí, egaba kaldikue neyatuka jana nuxa ni tuñkú. ");
INSERT INTO kog_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Guake Duweja mokue ubak káuxalda ipañguatshake stu stu atshiji muldetua uba ikukshatshake saldiñga jika agatsamak tuaka tu. ");
INSERT INTO kog_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Guñguenik Duweja: —Mokue mijuldi neyabikuká ni gu. Egaba kuíbulduxa kágubakuek kakbeji zʉxaitabaldáldi —na akbeyá. ");
INSERT INTO kog_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Guñgueniki Duwe Jesú aldéñ shaxaldixakue nañga Sesaldeya, Pildipu baxe kuíbuldukue eñgui akyó nukakueldi aldeyatoguéñ Duweja ekí kaklduká: —¿Kágubakueja naski me naugé shi nakuák? ");
INSERT INTO kog_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kakldukañguake akiyayó: —Duwe, mañki anuñkakuejañki Juañ nik majaukshakuega maldé, ezuakuejañki Jatetshi múldigaba naldiñga zʉxaitshixa Eldiyaga maldé, ezuakuejañki Jatetshi múldigaba naldiñga zʉxaitshixaga axautshi maldé na makuák. ");
INSERT INTO kog_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Guñguake: —Akze, maiñki ¿me naugé shi minajañgú? Guñguake Péguldujañki akiyó: —Duwe, mañki Saldiñga netshi Jateja ezua zʉnekualdal zʉñgakaxaldixa guakldane ne, aiga maldé nakldá. ");
INSERT INTO kog_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ekí guagatshak jiaga, Duweja aldéñ “me ne” ni mek akbeyasé na niuwi kagexá. ");
INSERT INTO kog_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Guñgueni Duwe Jesúja aldéñ shaxaldixakuek ekí shi kaxaldiyaldá: —Naski Jatetshi Asukuága ixagabaldekldugek matshuwi guiyaba tuakue nagatsexaldixa. Nauwisaná nauwa akldé akzekue, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue juizhi namak naxajanazháldi, naziyapanazháldixa. Ekí naxajani na, nakuagakuega zaldaldixa. Naldatshak shuixaldikuenik jiak, maiguake mokue izhgaldaxaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ekí Duweja kakibexa naldakí kakbeyatshakna, Péguldujañki Duwe nauwa agajué zeñka uldeñgueniki ekí axaldexaldá: —Ekí agatsaldi guagakue migatsaldakí ni matú. ");
INSERT INTO kog_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ekí axaldegatshak Duweja akizhikbateguenik aldéñ shaxaldixakue katú, katú atshiji na Péguldu ekí axaldék: —Jiséga miksaneshi tukí maldakbeyakna ¡nagajuezha guaté maldokldék! Mañki Saldiñga netshi Jateja sakí zexaldixa janaktune “ai za amak zegakuéñ” jañguagábaki, kágubakueja sakí zegaka atuamak niñkauwañki “ai za amak zegakuéñ” jañgui izhogashibaldá. ");
INSERT INTO kog_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ekí akbeñgueniki káguba duwá zhikzhe nakldekue, aldéñ shaxaldixakue juizhi kajuizhakuñguenik ekí kakbeyá: —Mieldeke namak giemi nagapa nendana miñzexaldiake, aike ekí naldakue miñgatsaldaldixa. Axaldáñgaba “nakldunamak izhogazháldiku” izhgakugakue. Ekíga na, nají miné shalda nuxa guiyaba tuakue, azhi shuigakue miñgatsaldaldiake egaba abeti, “wa nuxa ni nakldexaldí” izhgakuxamine naldakue. Ekí izhgakuxamine na, nas za nagapa neyalga nogakue. ");
INSERT INTO kog_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jinake ekí miñmeyakí. Mieldeki jai kagik izhoxa za akldé akzé jañgui, nagapa neyasʉ́ñ akzekáki shuigatshak jékaldaxa izhoshiñga izhogazháldixa. Ekí ne, mieldeki “Duwe nazikuanek agapa neñkuge shalda shuizha jiaga atshanaka shakldá” izhgakuxaldiák zʉnake, jékaldaxa izhoshiñga izhoxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","”Ekibeñga na, mieldeke káguba kagik zhekuauxa guashiñki zhakaldak jika axaldaldi jiaga, shuigatshake jékaldaxa izhoshiñga izhogagába, guiyaba tu za nogakueñka neyaldixaga ne, ¿jiñ shi axaldanekue axazauwaldixa na? ");
INSERT INTO kog_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ekíga na, mashuigatshake jékaldaxa izhoshiñga mizhoxaldiamake, ¿ji shi zabimildaka na? ");
INSERT INTO kog_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ekibeñga na, kaiga káguba zhekualdatukakue sha atshiji, Jatek axaldaldi za izhogazhékue kenañ mieldeki nas shalda, nají múldigaba nukaxá shalda jiwak akzeshi “naski Duwe Jesú agapa neñkugé nakldá” guagasʉ́ñ akzexaldiake jiak, nas mokue kagik naxaldatshak, ekibeñga jiwak nakzukui nají ne guagasʉ́ñ nakzexaldixa. Amak naxaldatshaga, nas Jatetshi Asukuága ixagabaldekldugeke Najatetshi muñshí zalda nañga, ají guaklde uldeñkakue juizhi naxaldikue niyó. ");
INSERT INTO kog_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Duwe Jesúja kakbejiñga na ekí jiaga kakbeyá: —Akze, namak miñmeyaldikue. Anuñka miné jai izhoxabinukakuañ shuigagá minoxaldieñga maiñ naldi Saldiñga netshi Jateja abisajañ ají kamak kágubakue kaksanegapanka mitualdixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ekí kakbeyatoguenik tezhuwa ldiuwi zeguake, Duwe Jesúki Péguldu, Santiaku, Juañ na agapa gaxa akldé akshá zeñka kauwihezuañgaba jeñ kaulditshí. Exaki ekueja atuatogueñga, Duweki sha ishkazguatshaga ");
INSERT INTO kog_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ají zhakuá jiaga tuasá muñshí zaldaba iyaté. Zhakuá ijizhiñgaba muldetua abutshi naldaka guashiñki zʉxaita muñshí agatsé na nexá. ");
INSERT INTO kog_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ekí ishkazguatshake nauwibama Eldiya, ezuañki Muesé akizhañkatshak Duwe na dulda izhgashaldá. ");
INSERT INTO kog_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Guakna Pégulduja Duwek ekí akbeyá: —Shi maldazʉñkaldixa, janshibeñga jai katshekualdé tiuwi. Akna maigua tañkuá kuizakpañguí, ezuañki mijí, ezuañki Muesétshi, ezuañki Eldiyatshi. ");
INSERT INTO kog_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Atshak kauwizhéñ zhe kakzeshiñgaba guatoxakna, Pégulduja ji guagakue akzaldazhá. ");
INSERT INTO kog_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Guatshaga na mauwiga tiñ ketsegatshake ek zhinik Jatega ekí zukuagaté alduká: “Jejiéki Nasukuá giemi matshuwi izhgajañguge izhogakna, muldetua miyaxaldukaldí.” ");
INSERT INTO kog_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ekí zegatshaga na, stu stu akuatshake, jiak Duwe za na kauwizhéñ nañga akté atú. ");
INSERT INTO kog_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Guñgueni gaxa akshá zeñka zhinik zabatoguéñ Duweja ekí kakbeyá: —Nas Jatetshi Asukuága ixagabaldeklduge shuixaldikueni mokue izhgaldagagáñgaki sakí ishkazguaté natumine, ni mek akbeyabináldi. ");
INSERT INTO kog_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ekí kakbeñguakna sakí zeklde ni mek agabeyazhá. Guatshak kauwizhéñgaba zʉnake Duweja shuixaldinik mokue izhgaldaxaldixa kakbene “¿sakí guashi ekí zʉñmene ne?” izhgabejiñgaba na akuá. ");
INSERT INTO kog_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Guatshak Duwek ekí agalduká: —Guiyaba shizhixakuejañki Jateja ezua zʉnekualdal zʉñgakaxaldixa nagagáñgaki ají múldigaba naldiñga zʉxaitshixa Eldiya nagakue agatsaldaldixaga akuaka. Ne ¿jinak shi ekí akuaka na? ");
INSERT INTO kog_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Guake ekí kakiyó: —Namak nauwibama Eldiya axañga nagatshak ejañki saldiñga janaktuwi, siyagauwaldixa. Guake, ¿jinak shi Jatetshi múldigabaja nas Asukuága ixagabaldekldugeki matshuwi guiyaba tuwi, kágubakueja nakzaldagálde naxajani, naziyapanazháldi na abetakue nagatsaldaldixa guashi ekí sezheklde na? ");
INSERT INTO kog_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ne nas zʉnake ekí miñmeyaldikue. Au, Eldiya tsaldi neki nak guane naldashá. Amak nagatshak, Jatetshi múldigabaja e shalda guakldanamak zeshi na, sakígaba sha akundana kakzegamak akuane nakldá. ");
INSERT INTO kog_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Duwe Jesú maigua nekue na exa zhinik aldéñ shaxaldixakue kabajanekue zhekualguéñ axatanatshake kágubakue duwá zhikzhe ajuizhaldeklde katú. Exaki guiyaba shizhixakueki kauwizhéñ na múldigaba ishkasashaté tu. ");
INSERT INTO kog_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ai kágubakueja Duwe atuatshak “¡Duwe naldiñga zabaté tiuwi!” akuashi na, zeñ kakldeshi aldaldiñga agaldabixal aldé. ");
INSERT INTO kog_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Guake Duweja ekí izuká: —¿Ji zhikbeji shi ekí múldigaba zhiksashaté mimatuñkuá? ");
INSERT INTO kog_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aiga kauwikenáñ zhinik, ezua sigíjañki ekí Duwek akbeyá: —Shi maldazʉñkaldixa, nasukuáki jisétshi alduna ijuldunejañga zukuakshaksá guane nakna jai mikuldaklduge. ");
INSERT INTO kog_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aijañki mitsakgaba nasukuá aksanegatshakna peñgui, kaxaldiñki jutúga kau axazguí, jualda zhiktenega, zhiktenega atshishi, abuá kuamaldega sha akzukuxa. Guakna shi maxaldixakuek ai alduna iyaldeñshaxañ kagakuañnexaldatshak jiaga, amak iyaldeñshazháka ni atú. ");
INSERT INTO kog_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Guake Duweja akiyokui ekí guak: —Jate alduna ishakí nibiná. Akna namak minajañgualdiamake ¿mitsá jimiñtuwi, abeti miñkizhogakue nagatsaldaldixa ne? Sukua nakuldák guwíñ. ");
INSERT INTO kog_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Guake amak akualdeyatshak, jisétshi alduna sukuak ijulduneja Duwe tuatshaga mokue pisti akzukui na, kagik peñguatshake pishkaldá, pishkaldá atshishi, kaxaldiñki jutúga kau axazguá. ");
INSERT INTO kog_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Guake Duweja sukua tshatek aklduká: —¿Mitsaga zhinik jisétshi aldunaja ekí akzukuapanane shi na? Guake akiyó: —Somá nóñgutse zhinik ekí akzukuapanane nakldá. ");
INSERT INTO kog_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ekí jisétshi aldunaja akzukui na, matshuwi juizha guaxaldiamak guksék, nik naxagutexa. Akna sakí agaunekbildaka guashiñki guañ zʉnajañgui yo zʉnakuá makualdí. ");
INSERT INTO kog_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ekí akbeyatshakna Duweja ekí akiyó: —“Agaunekbildaka guashiñki” najañguakue migatsaldakí. Akze, mieldeke nas namak najañgui, alduna nazishaldiák zʉnake, saldiñga kaxatshanakagaba nakldá. ");
INSERT INTO kog_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ekí akbeyatshak sukua tshate ubañga jaldáñ ekí nek: —Naski namak majañgui, alduna mishá ni gukú. Ne akldeñga mozhua, mozhua nakldegazháldiamak nagaunék makualdí. ");
INSERT INTO kog_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Guatshake kágubakue akldé akldeñga duwá naldaji aldagaté Duweja tuake ai jisétshi alduna izheñshi ekí axaldék: —Ma jisétshi alduna sukua zukuakshaksá, zukshaksá guamalde ekí ni mixaldekú: Izhé makualdinik ni mitsák mokue ijuldú guabaldáldi. ");
INSERT INTO kog_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Guake jisétshi aldunaki jaldáñ kauldi sukua mokue pisti akzukuatshake zʉxaita tau tau tau akzukueniki amak ne. Ekí neyatshak, sukuaki shuane jana majatshak matshuwi nekuejañki “shua ni gu” akuák. ");
INSERT INTO kog_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Guatshak Duwejañki sukua káuxaldak akpangueni juat izhgaldakshá akté. ");
INSERT INTO kog_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Guñgueni Duwe juldi juldunatshak aldéñ shaxaldixakueja ahezuañgaba ekí agalduká: —¿Jinak shi nasʉñki alde jisétshi aldunaki sukuak izheñshá zʉñzegazháka nalgú? ");
INSERT INTO kog_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Guake Duweja kakiyó: —Alde jisétshi alduna sana neñshexañki, záaki muldetua Jate axazguaxal noshi za na neñshakue. ");
INSERT INTO kog_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Guñgueni Duwe Jesú ai zhinik neñgueni Galdildeya baxe zʉxaitatogueñki ni meja eñgui izhuka akualdakue jañguazhá. ");
INSERT INTO kog_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jinake naldakí. Aldéñ shaxaldixakuegaba ekí shi kaxaldiyatoxák: “Nas Jatetshi Asukuága ixagabaldeklduge ne, neyazhakuashi aguldiñkugekuek naxaxexaldixa. Amak sha nakuí nakuaxanaldinik jiak, maiguake mokue izhgaldaxaldikue nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ekí kakbeyatshak jiaga, “sakí guashiñga ni ekí guak” kakldegazhá. Ni ai shalda agalduká kakzegazhá na gua. ");
INSERT INTO kog_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ekí Duwe Jesú aldéñ shaxaldixakue na aldeyatoshiñga na kuíbuldu Kapeldahúm aldé. Exaki juldi ajuldunatshake Duweja ekí kaklduká: —¿Ji shi jiúñguldak múldigaba zhiksashiji, zhikbeji naxabinoxá? ");
INSERT INTO kog_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ekí kakldukatshak jiúñguldake kauwizhéñgaba mieldek akldé akzé naldaldixa ne jiúñgulde múldigaba izhgasashiji aldagatone nalguakna, akiyayokuagábaki alduká nuxa na akuá. ");
INSERT INTO kog_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Guake Duwe yaldaxeni 12 aldéñ shaxaldixakue kexauldeni ekí kakbeyaldá: —Mieldeke akldé miñzé naldana miñzegake, aike aguáñ zhikzukuamine izhoshi na, saldiñgak kaxazauwakue miñgatsé. ");
INSERT INTO kog_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Gueniki Duweja ezua sukua kauwikenáñ uldagueni gulda axabeshi ekí kakbeyá: ");
INSERT INTO kog_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Mieldeke nagapa mineyéñ na ezua sukua jejié jana ne mipanatshaga, nas jiaga nepanamine naldaldixa. Ekíga na, mieldeke nas minepanatshaga, nas za nepanagábaki, Najate nakaxane jiaga ipanamine naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ezua ldiuwañ Juañja ekí Duwek akbeyá: —Shi maldazʉñkaldixa, ezua sigíja jisétshi aldunakue kágubak ijuldune “Duwe Jesútshi kamak newa ni mikbeñkú” axaldeshi izheñshaté tuñkalde. Naldatshak aiki nasʉñ nañga agatsé naldagálde nalguakna, “mokue ekí atshabaldáldi” ni kaxaldegú. ");
INSERT INTO kog_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Guake ekí akbeyá: —Mokue ekí kagitamakuabináldi. Jinake naldakí. Mieldeki natsaldí nají kamak janshizhe ajanashaté atú guazhámak atshá gualdinikga nalda naguagazháka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Akze, mielde aguldiyañkáaldeki, zʉñgauneka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Akna namak miñmeyaldikue, mieldejañki nagapa mineñká shalda ni nuxaki miñkáu gualdiake, Najateja ai shaldaki namak giemi janshizhe axatshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","”Ne mieldejañki ezua nepanane ai itsaldagálde axajanka sha atshishaldiák, ¡mitsá atemajañ guiyaba tualdixa ne! Akna ni me ijuldukshazháldiamak, akldé janshibé aldéñga ezua jagi atema gakldak zhikldiya gualdiniki ni izhgatushi shuixaldiamak níbunik akuateyakue. ");
INSERT INTO kog_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","”Akna, jiki sha atshindana miñzukuxa, mimakjieñguakaga mitualdiake, uteji izhgajuekuakue miñgatsé. Akna káuxalda sha atshindana miñzukuxa naldaldiake, izhbeñgua miñguxá jana atshakue. Akze, atabañki gulda misʉ́ñze jékaldaxa mijuldunaldiák, akldé janshibé naldaldixa. Ne sha atshalga minoxaldiake, mozhua káuxalda nañga Jateja guksé sanazhéñka guiyaba tu za nogakueñka mimaguteyaka ni mitú. ");
INSERT INTO kog_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ekíga na, ezua kasa sha atshindana miñzukuxa naldaldiake izhbeñgua miñguxá jana atshakue. Akze, atabañki kasa misʉ́ñze jékaldaxa mijuldunaldiák, akldé janshibé naldaldixa. Ne sha atshalga minoxaldiake, mozhua kasa nañga Jateja guksé sanazhéñka guiyaba tu za nogakueñka mimaguteyaka ni mitú. ");
INSERT INTO kog_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ekíga na, mimijí ubaki sha atshindana miñzukuxá naldaldiake, axaldáñga ishkuiya miñguxá jana atshakue. Akze, atabañki uba misʉ́ñze Jate sanegeñka mijuldunaldiák, akldé janshibé naldaldixa. Ne sha atshalga minoxaldiake, aldiweki mozhua uba nañga Jateja guiyaba tu za nogakueñka mimaguteyaka ni mitú. ");
INSERT INTO kog_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Exaga na, dzhi shuigagáldekue, guksé puldal za nugeñka nakldá. ");
INSERT INTO kog_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","”Akze, ji Jatek agaxexaldixa janshi agatseklde tualdiamak naku agaté xalde akiyayoka jana, saldiñga nekueki guiyaba atualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Akze, nakuki janshizhe, zauñka. Naldatshak nuk izʉzé guane, ¿sakí shi mokue akzanamak akzukuanazʉnaka na? Ne maiñ zʉnake naku izʉzeyazháne zauwamakbe, nagapa mineñkagaba muldetua ishkazauwi na, ataba atabañ señgaba zhe minoxaldí. ");
INSERT INTO kog_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Duwe Jesúja ekí shizhiyatoguenik aldéñ shaxaldixakue nañga Kapeldahúm zhinik Juldeya baxe zʉxaitiñgueni, nina Juldáñ ataba niñkauwa akbaték. Exaki mokue káguba duwá zhikzhe axajuizhaldeguake aldéñki shi kaxaldiyamakga shi kaxaldiyaldá. ");
INSERT INTO kog_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Atshakna, anuñka paldiseyukue Duwe axaldaguenik akuajaldiamak kakldeshi ekí agazalduká: —¿Nauwisanátshi guiyabajañki sigíja janshibeñga shi asewá majaka guaka na? ");
INSERT INTO kog_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Guake Duweja kakiyó: —¿Sakí shi nauwibama Mueséja ai shalda guiyaba zʉñmenane na? ");
INSERT INTO kog_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Guake ekí akiyayó: —Nauwibama Mueséjañki janshibé abajaka guashi na, mielde sigíjañki asewá majaldá gualdiake, “mabajá ni gukú” guaká xalte agegakue agatsaldaldixa guakldane. ");
INSERT INTO kog_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Guake Duweja ekí kakbeyá: —Nauwibamaja jinak ekí guagazhá. Maiñ aldunaxa kuamaldekbine amak atshasʉ́ñ miñzeká shalda na, ekí abajaminaka guakldane naldashá. ");
INSERT INTO kog_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Naldatshak “Jateja kasak zalda káguba gauwatshak sigí, munzhi na zhuasewá nexaldiamak gauwane.” ");
INSERT INTO kog_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Akna sigí numa negatshak ajate, ajabak agajuezhaldinik, asewá na niñkauwañki askuildegatshake, ");
INSERT INTO kog_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","abuáke mozhua aldanaldixa askuí abuá nek guxa nakldá.” Akna, sigí, munzhi na mozhua aldanaldixa askuí abuá jana nek guxa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Akze, Saldiñga netshi Jateja naldiñga sigí, munzhi na askimimé nekshá guanega, ni meja jiaga kezhgajuekuakue agatsaldazháka nakldá. ");
INSERT INTO kog_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Guñgueni mokue juldi aldagatshake aldéñ shaxaldixakueja ai shaldaga Duwek agalduká. ");
INSERT INTO kog_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Guakna Duweja ekí kakbeyá: —Mielde sigíjañki asewá majaldinik, axautshi guxaldiák, Jateja tuwiñki asewá kasaklde sha axatshiji, asewá naldagálde tushek guxaga zexaldixa. ");
INSERT INTO kog_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ekibeñga na, mielde munzhija asewá majaldinik axautshi guxaldiák, axautshi na askuildék guxaga zexaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Guatshak Duweja sukuakue zeñ kajañgui káuxalda kepañgualdiamak akualdagaté atuatshakna, aldéñ shaxaldixakueja sukua uldakldekue ekí axaldék: —Ekí Duwek sukua akuldagagába nogwíñ. ");
INSERT INTO kog_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ekí aldegatuka tuatshakna, akldunazháldi Duweja ekí kaxaldék: —Sukuakue nas nugéñ aldashi naguatók, kagitamakuagába. Jinake ekí miñmeyakí. Mieldekueki sukuakue aguáñ zhikzukui, Jate alduna iyashamakbeñga alduna ishixakue na Jateja kaksanegaka naldaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Namak miñmeyaldikue: Mieldeki sukua aguáñ zhikzukui, Jateja janshibé aksanegaka akldegamakbe akldegazhéki, Jateja aksanegazháldi ni aldéñ sanegeñka juldukshazhíta nakldá. ");
INSERT INTO kog_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ekí guagueniki sukuakue ezua ezua gulda kaxabegueni, zeñ kajañgualdiamak káuxalda kaipá na gua. ");
INSERT INTO kog_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Guñgueni Duwe Jesú neyapanatshake, ezua sigí naldajiñga axaldagueni nuldu axayoshi ekí aklduká: —Shi maldazʉñkaldixa janshizhe maldé, Jateja jékaldaxa izhoshiñga nezhokshaldiamake, ¿ji shi atshakue nagatsá? ");
INSERT INTO kog_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Akldukañguake akiyó: —¿Jinak shi janshizhe naugé maldaxaldék? Ezuañgaba auxaga janshizhe, eñki Saldiñga netshi Jate za naldashá. ");
INSERT INTO kog_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ejañga guiyaba atsha nexaldixa nauwibamak zʉñkageneja guaká mikuega. Aijañki ekí guaka: “Axautshi guaxa atshasʉ́ñze, misewá naldagálde na askuildek guasʉ́ñze, axautshi shalda naldagálde guagasʉ́ñze, tushegasʉ́ñze, axautshi itsasʉ́ñze, mijate, mijaba akzé jañgui, kaxabetakue” guaka mikué naldashá. ");
INSERT INTO kog_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Guñguake akiyó: —Shi maldazʉñkaldixa, eñki guagamak sukuak zhinik amak atshijiñga kaiga naldashakú. ");
INSERT INTO kog_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Guake Duweja izhgajañgui señ tuwi ekí akbeyá: —Ezua agatsalda atshakuega migatsaldashá. Aiki, jika mixaldauxa nuk nabesá xaldeki nashi jika agajueshkakuek makauwaldí. Ekí matshaldiakna, jékaldaxa niñkauwañki, Jateja matshuuwi janshizhe mixatshaldixa. Mikbenugamak matshaldiniki nagapa neyaldá makualdí. ");
INSERT INTO kog_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ekí akbeyatshakna, ai sigíki zʉ́xaitsha kabia nalguakna itshaniñgaba ne. ");
INSERT INTO kog_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Guake Duwe stu stu atsheni aldéñ shaxaldixakue ekí kakbeyá: —Kabiakueki “Saldiñga netshi Jate shi naksaneshí” izhgakugexañki ¡mitsá jibañ kakzeka ne! ");
INSERT INTO kog_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ekí guagatshakna aldéñ shaxaldixakuejañki “¡sakí shi ekí guak!” ajañguatshak jiak, Duweja mokue kakbeyá: —Nasukuákue, mieldeki kabia ldexak za agasjana izhukakueki “Jate za shi naksaneshí” izhgakugexañki ¡mitsá jibañ kakzeka ne! ");
INSERT INTO kog_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Akze, ezua kabiaja Jate za ají Sáñkalda ishkizhaxaldiamak izhgakugexañ jibañ akzeka. Aiki ezua béyakze atema skalda pokuéñ agaskaitazhákldegamakbe jana ne nakldá. ");
INSERT INTO kog_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ekí aldukatshak míñgaki akldeñga “¡sakí shi ekí guak!” kakldeshi ataba atabañ ekí izhgaldukaldá: —Amak keyakualdexañ ekí jibañ nake, ake, ¿me iyakualdaka ne? ");
INSERT INTO kog_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ekí nukatshakna Duweja katuaté noshi ekí kakiyó: —Kágubakueki axaldáñ ilkualdazháka ne, Saldiñga netshi Jate zʉnake saldiñga atshakagaba nak kalkualdakaga nakldá. ");
INSERT INTO kog_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ekí nukatshakna Péguldujañki Duwek ekí akbeyá: —Nasʉñki migapa neyakualdiamak, jika zʉñkaldauxa nuk majá guáñkalde naldashá. ");
INSERT INTO kog_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Guake Duweja akiyó: —Namak miñmeyaldikue. Mieldeke nas káguba ikualdal naklduge namak najañgui, nagapa za neyaldiamake ají juwí, te, akajakue, ajate, ajaba, ají sukuakue majaka izhgakuxaldiakna, ");
INSERT INTO kog_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","amak majane guashiñki zhakaldak ipanaldixa. Akze, juwí, te, akajakue, ajabakue, sukuakue nashaldá majane guashiñki Najateja jai kagiga 100 juizha agexaldixa. Ne amak ipani na, nagapa aldeñká shalda nuxa axautshikueja sha kakualdixa. Gualdiniki niuwizhíne jékaldaxa zʉnake Jateja aldunaxa auxaga akzukui izhoshiñga izhokshataná nakldá. ");
INSERT INTO kog_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Guatshak kaiga akldé akzé axajankakue nanaldixa, Najate sanegeñkaki matshuwi aikuega aguáñ akzekue naldaldixa. Ekíga na, kaiga ai itsaldagálde axajankakue nanaldixa, Najate sanegeñkaki matshuwi aikuega akldé akzekue naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Guñgueni Jeldusaldéñ aldeñká aldeyatoguéñ Duwe Jesúki kaksajañga neyatshakna, aldéñ shaxaldixakuejañki “¡jinak sha akualdieñka jiaga ekí neñká!” ajañguá. Ekíga na, agapa neyatoguekueki zhe kakzeshi aldé. Aldeyatoguéñ na, Duweja mokue 12 aldéñ shaxaldixakuegaba san kauldeji sakí agatsaldaldixa shalda ekí kakbeyaldá: ");
INSERT INTO kog_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Jeldusaldéñka na neyañkapán. Exaki nas Jatetshi Asukuága ixagabaldekldugek nezhakuashi, Jatek múldigaba agaskaitshixakuetshi sáñkaldakuek, guiyaba shizhixakuek naxaxexaldinik shuigakue nagatsé axaneyaldaxaldixa. Ekuejañga na, nauwisaná juldiú naldagáldekuek naxaxexaldixa. ");
INSERT INTO kog_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Amak naxegatshakna aikueki naziyajokldexaldixa, tup tup naxajanashaldixa, kuizhushak nagaldabikshaldixa, nakuaxa guanaldixa jiak, maiguake mokue izhgaldaxaldikue nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Guñgueni Zebedeyutshi asukuákue Santiaku, Juañ na Duwek axaldagueni ekí agabeyá: —Shi maldazʉñkaldixa, ezua migakuañnegakualdixa, amak zʉñkatshakue ni kabajañgú. ");
INSERT INTO kog_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Guake Duweja kaklduká: —¿Ji shi amak miñkatshakue minajañgú? ");
INSERT INTO kog_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Guake akiyayó: —Niuwizhíne muñshí zalda na saldiñga aksanexabaldoxaldieñkaga nasʉñ ezuake atabañ, ezuake atabañ mikyó yaldagakue zʉnajañgui makualdí. ");
INSERT INTO kog_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Guakna Duweja ekí kakiyó: —Ji nakshishabinuka miñnegakí nakldá. Ake, sakí agatsaldi atemajañ guiyaba tualdikue nagatsegapanamak ¿tuminaka shi miñnék? Azhi zʉxaita zalda jibañ tuwi zʉxaitakue nagatsegapanamak ¿nas na zʉxaitaminaka shi miñnék? ");
INSERT INTO kog_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Guake akiyayó: —Akzé. Nasʉñ jiaga ma nañga ekíga guiyaba tunazʉnaka nakldá. Guake Duweja ekí kakbeyá: —Akze, miñguaxamakga nas guiyaba tuakue nagatsahamak mitualdixaga. Ekíga na, zʉ́xaita zalda jibañ tuwi zʉxaitakue nagatsahamak mizʉxaitaldixaga nzha. ");
INSERT INTO kog_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ne sanexaldikueñkaki nasga mielde nakyó iyaldaxaldixa izhgakugakue nagatsaldakí. Eñki Jateja na mieldeki nakyó iyaldaxaldixa janaktunekue za na amak kezhaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ekí Santiaku, Juañ na Duwek agashishaté aldukatshakna, shagitixa 10 nekuejañki ni nauwa kakldunazhá. ");
INSERT INTO kog_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Guakna Duweja saldiñga aldéñ shaxaldixakue kajuizhakui ekí kakbeyá: —Miñkuahamakga na, Jate jañguazhékuetshi sáñkalda axajankakuejañki nashikue aguabiji mual axaldeshi za axasaneka. Sáñkalda akzekueja nashikueki kauwizhéñ za agasanegaka niuwi kaxaldé ne ajañgushixakue. ");
INSERT INTO kog_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ekí ne, maiñ zʉnake ekíga naldagábaki, mieldeke akldé miñzaldana miñzexaldiake, aike aguáñ zhikzukui, axautshikue kaxazauwakue miñgatsé. ");
INSERT INTO kog_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ekibeñga na, mieldeke akaldak miñzé mimatundana miñzexaldiake, ake, saldiñgatshi nashi nuxa izhogakue miñgatsé. ");
INSERT INTO kog_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Akze, nas Jatetshi Asukuága ixagabaldekldugek jiaga, axautshikue naxazauwaldiamak jai kagik nagazhánuge. Ne naski kaxazauwal naklduge. Ekí kaxazauwiñga na, matshuwi káguba sha ajanashixa shalda kesabiyaldikuamak shuixal naklduge nakldá. ");
INSERT INTO kog_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Guñguenik Duwe Jesú aldéñ shaxaldixakue juizhiñga kuíbuldu Jeldikóxa aldeñguenik exa zhinik káguba duwá zhikzhe axapa agazaxaitatogueñga, ezua sigí uba isé jiúñgulda xezhakga zʉshishiji na izhoxá. Aiki Baltimeyu axezhuka, Timeyutshi asukuá. ");
INSERT INTO kog_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ejañki Jesú, Nasaldéxa zalda zʉxaitapanká nukajakna, saldiñgaja nukandana agatsaldi ekí ixauldaldá: —Duwe Jesú, mañki nauwibama sáñkalda Dabítshi atukuaga maldé, guañ maldajañgualdí. ");
INSERT INTO kog_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ekí kauldaté aldukatshakna, matshuwi nekueja ekí axaldék: —¡Sʉnjá nogakueki tuakí shi maldá! Ekí axaldegatshak míñgaki akldé ekí kauldaldá: —Mañki Dabítshi atukuaga maldé, guañ maldajañgualdí. ");
INSERT INTO kog_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ekí Duweja nukañguake neyatogué agaldaxeni ekí guak: —Ai sigí jai nagaxañ naxakbeyá guwíñ. Amak agabejiñga na: —Duwe mixauldatshakgaba zeñ mikldeshi, izhgaldashi axaldewá. ");
INSERT INTO kog_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ekí agabeyatshaga na, juat izhgaldashi, zhakuá ibakualdé za duañgui, Duwek axaldeyatshake ");
INSERT INTO kog_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ekí aklduka: —¿Sakí shi amak guañ miguanakue maldajañgú? Guake akiyó: —Shi maldaxaldixa, zʉtundana ni nakzék. ");
INSERT INTO kog_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Guake Duweja akbeyá: —Mañki “uba nazikukshaka shakldá” najañgui, alduna nazishamaldéñ zhinik na, uba mikuká guane neyabikuká ni gu. Ekí akbeyatshaga na zʉtualdá. Guake Duwe neyatogué jiúñguldakga agapa ne na gua. ");
INSERT INTO kog_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ekí Duwe Jesú Jeldusaldéñka neñká nejiñga na, naki eñka izhañkaji, gaxa akshá zeñka Oldibuxaga, mozhua kuíbuldukue ezuañki Betapaje, ezuañki Betania naki aldeyatshak, Duweja aldéñ shaxaldixakue mozhuañki aksajañga kakagapanatshak ");
INSERT INTO kog_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ekí kakbeyá: “Uñguexa kuíbulduxa newiñ. Exa juldu me miñguatshake, ezua buldu awawa jiba agabeyagáldega shaklduka axaldí mitualdixa. Ekí mitualdiake, axawati minakuldaxaldí. ");
INSERT INTO kog_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Amak miyatshatshake, ‘¿jinak shi ekí guabipán?’ miñgaldukaldiake ekí miyokualdí: ‘Nauwijí Sáñkaldaja buldu agajuezhá guak. Jiak agajuezhaksá gualdiake ubañga mokue uzgauwaldixa nzha.’” ");
INSERT INTO kog_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Amak eñka aldeyatshake, buldu awawaki saldiñga zʉxaitatogéñ ezua tshuk juldunéñ axaldí atú. Ekí atuñguake axawatiyatogueñki ");
INSERT INTO kog_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","exaga ashekualguekueja ekí kaklduká: “¿Ji shi guabipán? ¿Jinak shi buldu awawa axawatiyabipán?” ");
INSERT INTO kog_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ekí kagaldukañguake Duweja yokuakue kakbenalguamak ayokuñguake, janshibeñga awaldeyaka kaxajaná. ");
INSERT INTO kog_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Guñgueniki buldu awawa Duwek akualdaguenik, kauwijí zhakuá abakaldak kejuakuekue akiyapañguñguake iyabexá. ");
INSERT INTO kog_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Guñguake matshuwi ashekualdekueja Duwe akzé atuwi na neyaldiéñ matshuwi nekuejañki zhakuá abuapañgui, ezuakuejañki setábaxe xai tashimaldi axabeñguane abuapañgui na akuá. ");
INSERT INTO kog_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ekí ajanashijiñga na, agapa, aksaja neyatoguekueki zeñ kakldeshiñgaba na, jaldáñ ekí akuagapaná: —¡Saldiñga netshi Jate akldé akzamakga kuizakzukuí! ¡Jate, nauwijí Sáñkaldaja atsaldí jejié zʉñgakaxane, aldéñga zeñ shi jañguí! ");
INSERT INTO kog_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Jateja jejié gaxaneki nauwibama sáñkalda Dabí sanexaldiamak niuwi ageshi, zeñ jañguanamakga zeñ shi jañguí. ¡Jate jékaldaxa izhukaki akldé akzamakga kuizakzukuí! ");
INSERT INTO kog_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Duwe ekí nejiñga na, Jeldusaldéñka juldunguenik juwí Jate axazakuageñka neñgueniki jeñ tu, jeñ tu na gua. Guatshake naki niuwi agajienaldá guapanakna, aldéñ 12 shaxaldixakue na exa zhinik aldeji, Betaniaxa jeñ ne na gua. ");
INSERT INTO kog_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Guñgueni abokualdi Betaniaxa zhinik neyatogueñki Duwe Jesúki maldija gualdá. ");
INSERT INTO kog_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Guñguakna nauwa maldé zeñka ezua kaldi zhenka tashí duakue akté tuñguakna, “kalwé axaldá sʉnakldá” jañgui tual ne. Atshake kalwé akukane kuiyakue ldiuwañ zegagá noxakna kalké za na tu. ");
INSERT INTO kog_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ekí tuatshakna kaldi ekí axaldék: “Kaiga zhinikga kalwé zhenabaldáldixa, ni meja ga guazhíta nzha.” Ekí axaldegatshake aldéñ shaxaldixakueja alduká na gua. ");
INSERT INTO kog_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Guñgueni Jeldusaldéñ neyatshak, Duweki juwí Jate axazakuageñka juldú. Exaki jigaba Jatek agaxexaldixa atshasʉ́ñzamak nabeyasatshak, kaxajabiyaté tuatshakna, eñka zhinik kaldeñshaldá. Ekí kaldeñshiñga na, paldata eni zaldak yushixakuetshi misa, shamí Jatek agaxexaldixa nabeyasaxakuetshi kaldoxá juizhi nuk kakizhikbé. ");
INSERT INTO kog_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ekíga na, juwí Jate axazakuageñka jika nabeyasaldixa zʉxaitshasé kaxaldék. ");
INSERT INTO kog_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ekí atshijiñga na, shizhijiñga ekí kaxaldék: “Najatetshi múldigabak ekí guashi sezheklde: ‘Nají juwíki saldiñga saná nahauxa nas za naxazakuagéñ axezhoxaldixa nzha.’ Ekí sezheklde ne, ¿maiñki mitushexaldixa jube nuxa guamine shi mimatuñkú?” ");
INSERT INTO kog_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ekí zeklde Jatek múldigaba agaskaitshixakuetshi sáñkaldakueja, guiyaba shizhixakueja aldukañguakna, Duwe sakí agatsaldi akuagaka ne aldiyaldá. Akbiñgaki saldiñga Duwe shizhiyatuka aldukatoxekuejañki “¡sakí ekí agatsaldi shizhixá!” ajañguaté atuatshakna, aldéñ zheñga na kakzukuá. ");
INSERT INTO kog_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Guatshak tuañ zexaldá guapanguake, Duweki aldéñ shaxaldixakue na kuíbulduk zhinik akzʉxaitá na gua. ");
INSERT INTO kog_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Guñgueni abokualdi muñshake Duwe Jesú, aldéñ shaxaldixakue juizhi mokue kaldi zhenka nugéñ azaxaitatshake agatsauxa kaná guane atú. ");
INSERT INTO kog_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ekí atuatshakna kaldi zhenka sakí axaldeklde Péguldujañki be agisegatshak Duwek ekí akbeyá: —Shi maldazʉñkaldixa. Tu guwá. Kaldi ekí axaldekbalde kaná guane tubaldá. ");
INSERT INTO kog_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Guñguake Duweja ekí kakiyó: —Maiñ Jatek alduna isha guakue miñgatsaldashá. ");
INSERT INTO kog_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Akze, namak miñmeyaldikue. “Jate akshishanugamak naxatshaldixa shakldá” mozhua miñnék naldakí alduna ishiji miyakshishaldiák, amak miñkatshaldixa. Akna jejié guinue “jai zhinik agajuezha xaldeki níbunixa iyawateya guwá” miyaxaldexaldiake amak miñkatshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Akna, ekí miñmeyaldikue: Jate miyaxazguagatshak “ji akshishanugamak naxatshaldixa shakldá” jañgui, alduna ishiji miyakshishaldiák, amak miñkatshatshak mipanaldixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jate miyaxazguagatshak, ezua sha mimakuane miñjuizhá naldakí nuká axabeti miñgualdí. Ekíki Nauwijate jékaldaxa izhukaja maiñ sha miyaxatshatshak miñkabetaldiamak.  ");
INSERT INTO kog_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Akze, maiñ sha mimakuanekue axabetakí minaldaldiák, ake, Mimijate jékaldaxa izhukaja ekíga maiñ sha miyaxatshixa miñkabetazháldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ekí kakbeyatoguenik Jeldusaldéñ mokue aldé. Exaki Duwe Jesú juwí Jate axazakuagaldi mizhatoguéñ, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue, nauwisaná nauwa akldé akzekue na axaldagueni ");
INSERT INTO kog_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ekí agalduká: —¿Mañki mani zalda niuwi guxamalde shi ekí atshabaldók? ¿Meja ekí matshaldixa niuwi migene naldaka ne? ");
INSERT INTO kog_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Guñguake Duweja kakiyó: —Ake jiak, nas ezua miñnukaldikue. Ai nakiyó miñgualdiakna, jiak nas zhinik meja niuwi nagenek ekí atshatokuge miñmeyaldikue. ");
INSERT INTO kog_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Juañ nik majaukshakueki, ¿meja káguba nik jaukshaldiamak shi niuwi agená? ¿Jate jékaldaxa izhukaja azhi kágubaja nuxa niuwi agene shi na? Nakiyó guwíñ. ");
INSERT INTO kog_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ekí kakldukañguake kauwizhéñgaba sakí akiyayokualdixa izhgabeyaldá: “‘Jate jékaldaxa izhukajañga niuwi agenane nakldá’ akiyokuakualdiake ekí zʉñnukaka: ‘Tukí Jatejañga niuwi agene nalguake, ¿jinak shi aldéñ shi miñkaldiyatshak “namak ni guak” jañguazhá guamine na?’ ");
INSERT INTO kog_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ne ake, ‘kágubaja nuxa niuwi agenane nakldá’ yokuakualdiake ¿sakí káguba zʉnakuaka ne?” Guatshak saldiñgaja Juañki Jatetshi múldigaba naldiñga zʉxaitshixa nanamakga ne ajañguxa naldakna zhe na kakzukuá. ");
INSERT INTO kog_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Guakna ekí nuxa akiyayó: —Mejañga Juañ niuwi agenane zʉñsʉ́ñ nzha. Guñguake aldéñ ekí nuxa kakiyó: —Ake jiak, amakbeñki nas ekí atshaldikuamake meja niuwi nagene miñmeyazháldikue nakldá —na kakiyokuá. ");
INSERT INTO kog_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Guñgueni Duwe Jesúja ajanashakldegéñ zhinik ekí shi kaxaldiyaldá: “Atiuwiñ zalguéñ ezua tetshi ajáugukuija ají tek kalwé zhenka nixá. Nigueniki muldetua kuldaldu ibé, mani kalwéldia axasiziñgualdiéñ siyagáu, ezuaja mataxa zhinik numañ tualdiamak jiaga gauwá. Ekí atshiñgueniki anuñka sigíkuek axabajá guñgueniki, aldéñki awaxani, maldé zaldi ne. ");
INSERT INTO kog_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","”Amak neñgueni, eñka izhoshi na, kalwé akuiyaldiéñ zeguake, ezua ají nashiga te axabajanekue nugeñka ajíki muan agaxexaldiamak agakuxal gaxá. ");
INSERT INTO kog_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Guane nalgué, nashi amak eñka neyatshake iyapangueni agaldabikshijiñgaba akuñgueniki egabañga mokue axaxá. ");
INSERT INTO kog_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ekí tetshi ajáugukuija ajanashane nukañguake, jiak mokue ezua ají nashi gaxá. Guane nalgué, amak eñka neñguake aiki aguáñ izhabashi mual axaldeshi, sáñkaldak akzaldi agaldabikshá. ");
INSERT INTO kog_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ekí ajanashane nukañguake, jiak mokue ezua ají nashi gaxane nalgué ai míñgaki akuaxá. Guñguake jiak, akldé ají nashikue gaxane nalgué ezuakueki akzaldi agaldabikshá, ezuakue zʉnake akuaxá. ");
INSERT INTO kog_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","”Ekí gashiñga aldiweki ezuamé agabá, aiki asukuá giemi matshuwi izhgajañguxa. Aldiweki ‘nasukuá giemi natsaldí kagakaxa guanugake, aiki axabetá akualdixa shakldá’ jañgui asukuá gaxá. ");
INSERT INTO kog_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Guane nalgué, amak asukuá exa neyaté atuatshakna, te axabajanekueja ekí izhgabeyá: ‘Uñkuejiéki te shjáugukuitshi asukuá nakna, jejié te bieni ipanaldixa. Akna, nasʉñ niñkauwañki ají bieni ipanakualdiamak guaxá kuizguí.’ ");
INSERT INTO kog_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ekí izhgabeji, iyapangueniki akuaxá. Guñguenik ají abuáki kalwé xaldeldi zhinik agazaxaitshá na akuá. ");
INSERT INTO kog_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","”Akna tetshi ajáugukuija ekí atshanekueki ¿sai kakualdixa shi mijañgú? Akze, exa neyaldiniki te axabajanekue nuk kakuaxá gualdinik, ají kalwé xaldaki axautshikuek niñkauwañki kaxabajaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ekí kakbeñguenik ekí jiaga kakbeyá: “Maiñ Jatetshi múldigabak ¿ekí guaka zukuakshabíne shi na? ‘Juwí gauxakueja ezua jagi zauwazháka ajañgui awateyá akuane. Ne aiga na jagi abuwa akldé akzé juwí muldetua agatsaldakuamak agatsé sekuá guane nakldá. ");
INSERT INTO kog_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Aiki Saldiñga netshi Jatejañga ekí zekuane. Ekí atshaté katuatshakna “¡sakí ekí janshizhe atshixá!” zʉñnekshá guane nakldá.’” ");
INSERT INTO kog_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ekí ajanashakldegéñ zhinik shizhiyaté aldukatshakna, nauwisanátshi sáñkaldakueja kauwizhéñ kagatsaldi ne katuñshi ekí guaklde kagajienakna, Duwe akugexañ aldiyaldá. Ekí ajañguatshak jiaga, zheñga kágubakueja kakzukuakna, egaba abajeniki saldi aldé na akuá. ");
INSERT INTO kog_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Guñgueni nauwisanátshi sáñkaldakueja ezuakueki paldiseyukue, ezuakueki sáñkalda Eldode na agatsekue Duwe Jesú atuál axaxá. Jinake axagazhá. Duwe ji akuakshéñ zhinik nuxa agatsé ne izhakuaxaldiamak. ");
INSERT INTO kog_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Amak Duwek axaldaxeni ekí agabeyá: —Shi maldazʉñkaldixa, ekí maldazʉñkué, mañki namak za mazukuaka. Ekí namaklde shizhiji na, Jatetshi jiúñguldaki jian nahauxabé shi mizhixa. Mañki me naldaldí, aikueja nuxa sakí jañguakue, atshakue mikbeyatshak jiaga, aibé kaxalduka guabálde. Akna ¿Aldumatshi sáñkalda akldé akzé akilzabiyakue zʉñsanegamak shi akilzabiyakue naldaka na? ");
INSERT INTO kog_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Akna ¿akilzabiyakue azhi akilzabiyañkaldáaldixa shi na? Zʉñmeyá guwá. Guatshak kauwizhéñki jian izhoxa kakualdana kakzeka ga abeldashi nuxa agaldukatuka Duweja akualdi na ekí kakiyó: —Ekí minakldukatshake, ¿ji miñkiyokugéñ zhinik nuxa minezhguaxaldixa tuakí shi nakú? Akna, ezua muneda Alduma zalda tuwexañ nakuldák guwíñ. ");
INSERT INTO kog_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Guake amak akualdeyake Duweja ekí kaklduká: —¿Jeñkáñ metshi waxa shi axaldí mitú? ¿Metshi axezhuka jai aksezheklde shi mitú? Guake akiyayó: —Ejiéki sáñkalda akldé akzé Aldumaxa zaldatshi nakldá. ");
INSERT INTO kog_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Guake Duweja ekí kakbeyá: —Ake, sáñkalda Aldumaxa zaldatshi nake agexal minokldék. Ekibeñga na, Saldiñga netshi Jateke ji agegakue miñgatsahamak miyagexaldí. Ekí kakiyokuatshakna, “¡sakí ekí jañguanega yokuxá!” na ajañguá. ");
INSERT INTO kog_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Guñgueni anuñka saduseyukue Duwe axaldák. Ekuejañki kágubakue ashuanaldinik Jateja mokue kezhgaldakshazháldixa ajañguxakue naldakna ekí agalduká: ");
INSERT INTO kog_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Shi maldazʉñkaldixa, nauwibama Mueséja nasʉñ juldiúkuañ ekí atshakue zʉñmeji, kalta zʉñkabashanane: Ezua sigí sukua axaldegagáñga shuixaldiake, akaja giemijañga ai tsewa nane gugakue agatsaldaldixa. Ekíki akaja shuane tsaldiñga sukua axaldekldaldixaki ai shtukua nitshixalga noxaldiamak. ");
INSERT INTO kog_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","”Ekí nalgué atiuwiñ zalguéñ, zhuakajagaba kugua sigíkue aldalgué, kasak zaldaja munzhi guxane nalgué, sukua axaldegagáñga shuizhá. ");
INSERT INTO kog_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Guñguake mozhuaneja ai tsewa nane guxá. Guane nalgué, ai jiaga sukua axaldegagáñga shuizhá. Ekíga na, maiguaneja exa zhinik jiak, ");
INSERT INTO kog_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","galdeni nekueja ekíga ai munzhi akugatshak jiaga, kugua aldalguauxa sukua abajagáñga ashuizhá. Ekí nuk ashuigueni, aldiweki munzhi jiaga shuizhá. ");
INSERT INTO kog_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ekí zeklde ne, Jateja káguba ashuanaldixakue mokue kezhgaldakshaldixa ldiuwañ zegatshak, munzhi sigí zhuakajagaba kugua axaldane nak, ¿atshake mielde tsewa naldaldixa shi na? ");
INSERT INTO kog_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Guake Duweja ekí kakiyó: —Eñki naldagálde na mijañgú. Jinak naldakí. Jateja ají múldigabake ashuanaldixakue mokue kezhgaldakshaldixa guaká ne miñgajienagába, amak kezhgaldakshaka jiaga kama axaldé jañguakí minák. ");
INSERT INTO kog_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Akze, Jateja káguba ashuanaldixakue mokue kezhgaldakshatshak, jékaldaxaki numa aldegazhítakue. Aikueki Jateja guaklde uldeñkakue numa negazhámakga izhoxaldixakue nakldá. ");
INSERT INTO kog_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","”Ne Jateja káguba ashuanaldixakue mokue kezhgaldakshaldixa shalda, ¿nauwibama Mueséja ezua kaldi puldatoguéñ sakí zeklde shalda gaune zukuakshabíne shi na? Ai kaldik zhinik Jateja “Nasga na mibama Abaldahámtshi, Isáktshi, Jakóptshi Ajatega nzhakú” nauwibamak akbene. ");
INSERT INTO kog_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Akze, Saldiñga netshi Jateki shuanekuetshi Jate naldazhé, ne be nukakuetshi Jatega nakldá. Ai zhinik na Jateja shuanekue izhgaldakshazháldixa mijañguxáki naldagálde giemi na mijañgú. ");
INSERT INTO kog_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Exaga na, ezua guiyaba shizhixajañki ekí agatsaldi izhgabeyaté nuká. Ekí ishkué ga agatsaldi Duwe Jesú yokuaté tuwakna aldéñ jiaga ekí aklduká: —Saldiñga netshi Jateja nauwibama Muesék guiyaba zʉñkabajane ¿mielde shi ai guiyaba atsha nexaldixa akldé giemiki akzé naldaka na? ");
INSERT INTO kog_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Guake Duweja ekí akiyó: —Guiyaba zʉñkabajanauxa atsha nexaldixa akldé akzeki ekí guaka: “Maiñ Isayélkuañ, muldetua nuká guwíñ. Saldiñga netshi Jate Nauwijatega aldéñ za na Saldiñga netshi Sáñkalda, ek zhinikga mokue e janamé ne naldakí giemi nakldá. ");
INSERT INTO kog_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nakna, Saldiñga netshi Sáñkalda, Mimijatega e za miñgatsauxa izhgajañgui na, miñnegauxa, mijañguauxa, kama miñkuauxa e za mizhgajañgualdí.” ");
INSERT INTO kog_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ekíga na, guiyaba mozhua ne akzega ekí guashi sezheklde: “Maiñ axaldáñ mitsá miyajañguxa nake, kágubakue amaga mizhgajañgualdí.” Axautshi guiyaba atsha nexaldixaki alde mozhua nekue zhakldé akzé naldakí giemi nakldá. ");
INSERT INTO kog_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Guake guiyaba shizhixaja ekí akiyó: —Shi maldazʉñkaldixa, mañki mishkuahamak, guagakuamak na ekí maldakiyokú: Saldiñga netshi Jateki ezuamé ne, ek zhinikga mokue Jate naldakí giemi nakldá. ");
INSERT INTO kog_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ekíga na, aldéñga béyakze agakuagakue, azhi muldi za duwá akiyogakue zʉñmeñká amak axatshakue akzé tuñka guashiñki mozhua guiyaba nekue na amak axatshiji akldé akzé giemi tuñka. Aiki, e za zʉñgatsauxa izhgajañgui na, kajañguauxa, kama zʉñkuauxa e za izhgajañguakue. Ekíga na, nasʉñ axaldáñ mitsá kajañguxa nake, amaga kágubakue izhgajañguakue zʉnajañguxa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ekí ishkué ga agatsaldi yokuane Duweja nukatshakna ekí akbeyá: —Mañki “Jateja janshibeñga ni naksanexaldí” naki mikldeshi ni guaté tuñkú. Ekí agatsaldi Duweja yokuatoguakna ni meja akldé akzʉzukaldixaga izhajanazhá na akuá. ");
INSERT INTO kog_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Guñgueni Duwe Jesú exa juwí Jate axazakuageñka shizhiyatogueñga ekí kaklduká: —Saldiñga netshi Jateja káguba ikualdal ezua gaxaldixa guakldane, guiyaba shizhixakueja ¿sakí shi eñki nauwibama sáñkalda Dabítshi atukua za ne akuagaka na? ");
INSERT INTO kog_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ekí akuaka ne, nauwibama Dabí Jatetshi Aldunajañga aksanegatshak ekí guaklde: “Saldiñga netshi Jateja nají Sáñkalda Zʉnekualkak ekí akbeyá: ‘Nas saldiñga aksanegatokugeñga, jibatshugaldi mual akldé akzéñ naldesañ yate guwá. Naski maguldiñkakuek auxaga magubishaldikueñka yo amak mizhoxaldixa nakldá.’” ");
INSERT INTO kog_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ake, nauwibama Dabí aldéñ naldiñga káguba ikualkak “nají Sáñkalda” axaldeklde nake, jiak ¿sakí shi atukua za naldaka na? Duweja ekí shizhiyatoguéñ matshuwi káguba nekuejañki kaklduni axaldukaté na aldoxá. ");
INSERT INTO kog_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Duweja ekí shizhijiñga ekí jiaga kakbeyá: “Guiyaba shizhixakue atshamakga atshabináldiamak muldetua numañ miyatualdí. Akze, kauwizhéñki kakzé kawatualdiamak na zhakuá wézhilduka izhatshualdixa. Kágubakue zheneñka aldeyatshak, kaxabeti mual za kaxazakuagakue izhajankakue. ");
INSERT INTO kog_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Juwí izhajuizhaldegeñka aldeyatshak azhi mieldegaba abuzál aldeyatshak, akldé akzekue iyaldageñka iyaldagazhá guasʉ́ñ akzekakue. ");
INSERT INTO kog_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Naldatshak munzhi sigí ishuanekueki iyasaji juizhi saldiñga ikukakue. Ne janshizhekue kawatualdiamake, kawatuatogeñki Jate maldée axazguakakue. Ekí ajanashixa nakna, Jateja axautshikue zhakaldak atemajañ guiyaba katuñshaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Guatshak Duwe Jesú Jatek agaxexaldiamak akuashixa buan izhogueñki, kágubakueja paldata aik akuashaté katú. Atshaga na matshuwi kabiakueja aldagueni paldata matshuwi akuashaté katú. ");
INSERT INTO kog_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ekí tuatogueñga na, ezua munzhi nashi, sigí ishuaneja naxeni mozhua muneda nauwamé akzekue kuashaté tu. ");
INSERT INTO kog_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Guakna Duweja aldéñ shaxaldixakue kajuizhakui ekí kakbeyá: “Namak miñmeyaldikue. Jalde munzhi nashi, sigí ishuanejañki saldiñgaja Jatek agaxeká guashiñki akldé agegashá. ");
INSERT INTO kog_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Jinake naldakí. Aldéñki nashi naldatshak jiaga axaldaldauxa, izhoxaldixa juizhi Jatek agegashá. Ekí ne, kabiakueja zʉnake kagipenane nuxa axegashá” na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Guñgueni Duwe Jesú juwí Jate axazakuageñka zhinik akzʉxaitatoguéñ, ezua aldéñ shaxaldixaja ekí akbeyá: —Shi maldazʉñkaldixa, tu guwá. Jejié juwíkue jagigaba atema sezheklde ¡sakí ekí janshagatsegaba siyagaxaune ne! ");
INSERT INTO kog_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Guake Duweja akiyó: —¿Jejié juwíkue sakí atemakue sezheklde matú? Ne niuwizhíneki nuk atiñguatshakna, ni ezua jagi nuxaki zhikté abazháldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Guñgueniki gaxa akshá zeñka Oldibuxa juwí Jate axazakuaka buaxa aldeyatshak, Duwe Jesúki ité noguéñ Péguldu, Santiaku, Juañ, Andaldé na Duwe ahezuañgaba ekí agalduká: ");
INSERT INTO kog_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Duwe, ekí maldazʉñmeñkáki ¿mitsák amak zexaldixa shi na? ¿Jiñ zhinik shi “amak zexaldá na guabatú” tuakualdixa na? ");
INSERT INTO kog_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Guñguake Duweja kakiyó: —Muldetua numañ miyatualdí, naldagálde ne namak mimajañgushaldiamak miñgabeyatshak, namak jañgui guamiñnegak. ");
INSERT INTO kog_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Jinake ekí miñmeyakí. Nas mokue kagik nagagá noxaldikueñga, matshuwi nekueki naldagálde nuxa nasga aldé aldeshi, “nasga na Jateja káguba ikualdal nakaxane, aiga na nakú” akuashi miñkiyaldañkatshakna, matshuwi kágubakue namak ajañgushaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","”Atshakna, san san kagi zaldagaba izhguabiyaldiamak axaukshi guatuka minukatshak, “auxa zexaldiéñ zek guxá nakbaldúk” jañgui zhe miñzegagába. Jinake naldakí. Auxa zexaldiéñ zegagáñgaki ekíga zegakue zaldaldixa, naldatshak jiaga auxa zegagá noxaldixa nak. ");
INSERT INTO kog_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ekí zeshi na, ezua saná, axautshi saná na izhguabiyaldiamak axaukshaldixa. Ekibeñga na, sáñkalda san san zaldakuegaba izhguabiyaldiamak axaukshaldixa. Atshak saldiñga kagi kakshata atemajañ neji, gakue naldaksáñga ne zegatshakna maldija kakualdixa. Ekí guiyaba atualdixaki aldiwe míñgaki mitsá guiyaba atualdixa shkasa nuxa naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","”Maiñ nagapa mineñkakuañ zʉnake muldetua numañ miyatualdí. Akze, nagapa mineñka shalda nuxa minapanaldinik nauwisaná nauwa akldé akzekue miñgatsaldi ne matuakue nugeñka mimawaldeyaldixa. Ekíga na, nauwisanákuegaba izhajuizhaldegeñka mimawaldeyaldinik exaki kuizhushak miñgaldabikshaldixa. Ekibeñga na, nagapa mineñká shalda sáñkalda aguáñ akzé, akldé akzé nugeñka miñgatsaldi ne mimawatualdiamak mimawaldeyaldixa. Eñkaki Jateja minkualdal nakaxane shalda kakbeminakaga mitualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","”Naldatshak auxa zegagá noxaldieñgaki ekí zegakue naldaldixa. Saldiñga netshi Jateja káguba ikualdal ezua gaxane shaldaki saldiñga saná nahauxa nuk kagabeyakue zaldaldixa. Gualdinik na auxa zexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Akna mitsake amak mimakuxaldiniki miñgatsaldi ne mimawatualdieñka mimawaldeyatshak, “¿sakí zhikzukuaxaldikue ne?” ijanagábaki, sakí guagakue Jatetshi Alduna miñsanegatshak egaba guagakue. Akze, maiñgabaga zukuaxabináldixa, ai Aldunaga na maiñ zhinik zukuaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","”Atshakna, nepanazhánekueja nepanaminekue shalda nuxa anuñkaki mimakuaxa mimakualdiamak miyaguldiñkakuek mimagaxeshi na, ezua nepanazháneja akaja giemiga nepanane ekíga gexaldixa. Azhi jatekueja kauwijí sukuakue axexaldixa. Azhi sukuakueja kauwijatekue kaguldiji, akuaxa akualdiamak axexaldixa. ");
INSERT INTO kog_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Akze, kagik káguba zhekuauxa zaldakuek najíkue miné shalda nuxa miyaguldiyaldixa niyó. Naldatshak mieldeke nas shalda guiyaba tuakue miñgatsegatshak jiaga, abá naldakí nagapa neyal za mishuixaldieñka yo mizhekualdaldiák zʉnake, mimeyakuane jékaldaxa izhoshiñga mizhogataná nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","”Niuwizhíne juwí Jate axazakuagaldi ezua diuwi mikzukuakue izhogazháka iyaldagatshakna, auxaga akzaldakualdixa. (Jalde zukuakshabinukakuañ, sakí guashi sezheklde izhgajieñguá miñgualdí.) Akna amak zegapanká mituatshak, Juldeya baxe mizhekualdaldiake akldé gaxa akshá zaldi minakuixaldí. ");
INSERT INTO kog_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mieldeki jutezhaldi izhoxaldiéñ, jika izhgakuxal juldi juldunakue agatsaldazháldi. ");
INSERT INTO kog_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ekibeñga na, mieldeki texa akldoxaldiéñ, ni ají zhakuá nuxaki juldiñga majane izhgakuxal neyagábaki, nakuigakue. ");
INSERT INTO kog_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Amak zegatshakna, munzhi somá axaldegatukakue, somá axaldukakue aldakuigazhákakueki ¡wau wau wau mitsá jibañ atualdixa ne! ");
INSERT INTO kog_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Akna, níxalda bual nakuigakue miñgatseshi guakuak Jate agakuañneshi miñgualdí. ");
INSERT INTO kog_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Jinake ekí miñmeyakí. Atshake atemajañ, zʉ́xaita zalda guiyaba atualdixa nak. Ekí guiyaba atualdixaki, Jateja kagi gauwa guenik zhinik, kaiga yo ekí agatsaldi guiyaba atuazhé, ni niuwizhíne jiaga atuazhíta zexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ai guiyaba tuwaki Jate, Saldiñga netshi Sáñkaldajañga axañga saldikshaldixa jañguazhá guane guashiñki saldiñga ashuishi, ni me abazháka. Ne aldéñ izhgakuxanekue shalda nuxa na ekí guiyaba tuwa axañga saldikshaldixa jañguane nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","”Atshakna, ezuajañki: “Tu guwíñ. Jateja ezua zʉnekualdal gaxaldixa guaklde ne kagik naklde, jai na izhók” azhi “exa na izhók” miñgabeyaldiák, namak ne jañguabináldi. ");
INSERT INTO kog_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jinake naldakí. Atshakna ezuakueki naldagálde nuxa “nas na káguba ikualdal naklduge na” aldeshi iyaldañkaldixa. Ekíga na, ezuakueki naldagálde nuxa “nas na Jatetshi múldigaba naldiñga zʉxaitshikuge nakú” aldeshi iyaldañkaldixa. Aikue na, Jatejañga izhgakuxanekue jiaga mieldeki naldagálde nuxa namak ne kajañgushaka nanake, amak kejuldukshaldiamak kama izhalshaldixa. Ekí ajanashiji na, matshuwi ajanashaté atú guazhámak ajanashaldixa. ");
INSERT INTO kog_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Akna muldetua be minoxaldí. Sakí zexaldiauxa zegagá nogeñga na ekí mimeshkaldukshikú. ");
INSERT INTO kog_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Duwe Jesúja kakbejiñga na ekí jiaga kakbeyá: “Ekí jibañ atualdixa sʉxake, niuwiki stuaksáni tuañ itsexaldixa, saxa jiaga tuañ itsexaldixa, ");
INSERT INTO kog_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","alnobaxa zaldakueki wi wi me abatshake zumeyakueki aktinaldixa. ");
INSERT INTO kog_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ekí zexaldinik na kágubakueja nas Jatetshi Asukuága ixagabaldeklduge atemajañ kama naxaldé, tuasá muñshí zalda nazizhuka mauwixa zabaté nawatualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Atshake nas guaklduge uldeñkakue gaxanaldikuekuejañki najíkue, Najateja kezhgakuxanauxa nekue maxáiñtaba zahauxa zhinik saldiñga, saldiñga kajuizhakualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","”Ekí miñmeñkugé miñgajienaldiamak kaldi zhenka sakí atshaté mituwéñ zhinik ekí shitiyakue na mimajañgukú. Kaldi axé aktinapanká mituatshake, ‘niuwiya aldaxaldá gualdixa nakbatú’ miñkué. ");
INSERT INTO kog_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Amakbeñga na, sakí zexaldixa miñmeyanugamak zegapanká mituatshakna, nas naki mokue kagik naxaldá guapankugé miñkualdaldixa. ");
INSERT INTO kog_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Namak miñmeyaldikue. Kaiga ldiuwañ mimisaná ldaxe izhoxabinuka naldalga noxaldieñgaki sakí zexaldixa miñmeyanugauxa amak zexaldixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Akze, alnoba, kagiki naldaksánaldixaga. Ne nají múldigaba zʉnake ni mitsák naldaksá guazhíta nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","”Ekí zexaldixa naldatshak, ji niuwañ mitsá zegatshak naxaldikueki ezuañgaba Najate, Saldiñga netshi Jateja zañga akué. Ai zhinikga ni meja aksʉ́ñ. Aldéñ guaklde uldeñka jékaldaxa izhukakueja kaksʉ́ñ, ni nas Asukuá naugék jiaga naksʉ́ñ nakldá. ");
INSERT INTO kog_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Akze, ji ldiuwañ mokue kagik naxaldikue miñsʉ́ñ nogakna, be noshi, ‘kaigaki nagaté sʉnakldók’ najañgui, jinaktuál Jate axazguaxal minoxaldí. ");
INSERT INTO kog_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","”Nas mokue kagik naxaldikueki me jana atshanaka miñmeyaldikue. Aiki ezua sigí maldé zaldi neyaldixa nalguák, ají nashikue ajúk jika numañ agatualdixa jiba kageshi na, ezua, ezuak ji axatshaldixa kakbeñka. Ezua ají nashiki juldunéñ numañ zʉtuñkake be nogakue akbeñka. ");
INSERT INTO kog_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Akze, juwítshi ajáugukuiki mitsá zegatshak nagaka miñkualdazháldi na, tuañ zegapanatshak, azhi semuanté zegatshak, azhi gayu kauldatshak, azhi muñzegatshak nagaka nakna be noshi, jiaktuál minoxaldí. ");
INSERT INTO kog_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ekibeñga tua miñzegagá noxaldieñga naxaldatshak, kabamine janazhiktuabínega mimatuwi guanakldegak janazhiktumine minoxaldí. ");
INSERT INTO kog_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Maiñ miñmeñkugamakga na saldiñgak ekí ni akbeñkú: Be noshi, jinaktuál minoxaldí.” ");
INSERT INTO kog_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Atshake Jateja nauwibamakue san kagixa guiyaba atuwi ashekualgueñka zhinik kakzʉxaitshanéñ ldiuwañ be ishkiyasekui pañ ishkishshixa akjiukualdagálde axajéñ zexaldixa moshik me na abatoxá. Atshaga na, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue juizhi Duwe Jesú sakí ziñgaba akuxaldinik akuaxaldixa aldiyaté na aldoxá. ");
INSERT INTO kog_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Noxakna kauwizhéñgaba ekí izhgabeyá: “Kajuizhaldegamak juizhaldexalga kaldoxaldiéñ guxa guanazʉñnegake, kágubakue kaukshishanazʉnaka nakna, atshake guxañkaldáaldi.” ");
INSERT INTO kog_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Atshake Duwe Jesúki kuíbuldu Betaniaxa izhoguéñ, Simóñ ajuba ikalduni akzeka nane tshuxa abuzál ne. Amak exa zatoxéñ, ezua munzhija we juma izhuka maldée akzé “naldu” naldi, jika janshagatsék akué aksui naxeni, aiki makpe Duwek sáñkaldeldi itsú. ");
INSERT INTO kog_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ekí itsukuaté atuatshakna, zhekualdekuega ezuakuejañki atshasʉ́ñzamak atshixá ajañgui ekí izhgabeyaldá: —¿Sakí zhinik ejié we juma izhuka ekí itshuakshixá? ");
INSERT INTO kog_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ekí guagábaki, maldé akzaldi, ezua kagi kasa izhgáu naldashi akzaldi nabesá xaldeki aiki nashi jika agajueshkakuek akáu guakue ne. Ekí ajañgui na, munzhiki gama axashiji na akuá. ");
INSERT INTO kog_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Guake Duwejañki ekí kaxaldék: —¿Jinak jejié munzhi ekí nalda miyaguaká? Auxabé nek ni gu. Ekí netsukuatshake, janshibé naxatshiji akldé nakzukuashá. ");
INSERT INTO kog_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Akze, nashi jika agajueshkakueki miñkizhoxalga noná nakna, mitsakgaba agaunekbinakaga naldaldixa naldashá. Ne nas zʉnake miñkizhoxal za nogazháldikue. ");
INSERT INTO kog_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ekí nakna, jejié munzhijañki ji naxatshaka tuwauxa naxatshiji na, we juma izhuka netsukuatshake, axañga nají abuá abexaldixa janaktuwi guana naxatshashá. ");
INSERT INTO kog_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Namak miñmeyaldikue. Saldiñga kagi nahauxa Najateja káguba ikualdal nakaxane shalda akuagatshak, jejié munzhi sakí naxatshane be kagiseshi, akuaxalga noxaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Guñgueni Duweja 12 aldéñ shaxaldixa izhgakuxanega Juda Iskaldiutejañki Duwe izhguashi kagexaldiamak Jatek múldigaba agaskaitshixakuetshi sáñkaldakue tual ne. ");
INSERT INTO kog_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ekí aldukatshakna zeñ izhajaniñgaba guñguakna, “ai shalda paldata mikzabiyakualdixa nzha” agabeyá. Akna aldéñki mitsakgaba Duwe kagexaldiamak niyaldá na gua. ");
INSERT INTO kog_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Guatshak Jateja nauwibamakue san kagixa guiyaba atuwi ashekualgueñka zhinik kakzʉxaitshanéñ ldiuwañ be ishkiyasekui pañ ishkishshixa akjiukualdagálde axajéñ na zegapaná. Ai ldiuwañga na jubeju zhauwa axaldixa Jatek axakuaxaldiéñ zexakna, aldéñ shaxaldixakueja ekí agalduká: —¿Mani shi ai gakue amak janaktuakue maldazʉnajañgú? ");
INSERT INTO kog_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Guake Duweja mozhua aldéñ shaxaldixakue kakashi ekí kakbeyá: —Kuíbulduxa mineyatshake, ezua sigí moñkúk ni uldeyatuka mituatshak agapañga mineyaldí. ");
INSERT INTO kog_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Gualdini mashi juldunaldiake, juwítshi ajáugukuik ekí miyakbeyaldí: “Shi zʉñkaldixaja ekí ni makuaxá: ‘¿Mijúk miya kaiga nas shaxaldikugekue juizhi galdikue shi na?’” ");
INSERT INTO kog_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Miyakldukatshake mateldi juizhaldék guashi atema siyagaunéñ mimatuñshaldixa. Gualdiake eñka gakue gakualdixa janamiyaktualdí. ");
INSERT INTO kog_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Guake aldeñgueni kuíbulduxa aldeyatshak, Duweja kakbenalguauxabé atú. Guñguake eñka ai gakue janagatú na akuá. ");
INSERT INTO kog_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Guñguenik tuañ zegapanatshake, Duwe aldéñ 12 shaxaldixakue juizhiñga nagueni ");
INSERT INTO kog_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","amak asatoguéñ Duweja ekí kakbeyá: —Namak miñmeyaldikue. Maiñ nas na zabinukakuega ezuake nezhguashi aguldiñkugekuek minagexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ekí kakbeyatshakna, izhajani ezuaja, ezuaja ekí akldukapaná: —Ne ¿nas shi amak makuanaka maldajañgú? ");
INSERT INTO kog_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Guake ekí kakiyó: —Maiñ 12 shi miñkaldikugekuega ezuake nas gatokugéñ pañ nuañgui gatukaga na nezhguashi aguldiñkugekuek nagexaldixa. ");
INSERT INTO kog_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Akze namak, naski Jatetshi Asukuága ixagabaldekldugeke, ají múldigabaja guagamak shuigakuega nagatsaldaldixa. Naldatshak, nezhguashi, nakenaldixa zʉnake ¡mitsá atemajañ guiyaba tualdixa ne! Akna kukazhá guanaldíñki akldé janshibé naldatalgué. ");
INSERT INTO kog_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ekí asatogueñga Duweja pañ zhiksuishi, Ajatek ai shalda “zeñ nzhakldék” akbeñguenik nauwa, nauwa zhikwatiji kagegatshak ekí kakbeyá: —Jejié pañki nají abuá tsaldiñga ne nagipana guwíñ. ");
INSERT INTO kog_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Guñgueniki jaldu, kalwéldia siyagaxaune akué zhiksuishi, Ajatek ai shalda “zeñ nzhakldék” akbeñguenik kageguake, saldiñga nauwa, nauwa atuxá. ");
INSERT INTO kog_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Guake ekí kakbeyá: —Jejié kalwéldiaki nají abi tsaldiñga ne. Ai na, káguba matshuuwi nekue ikualdaldikuamak abi nakzuldi nakuaxaldiéñ naki zexaldá na guapán. Amak shuixaldatshak, Najateja minkualdaldiamak e na ishkualdi izhoxa abisa jiúñgulda miñgexaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ne namak miñmeyaldikue. Auxa zegatshak, Najateja saldiñga kaksanexaldiéñ zegagá noxaldieñgaki mokue ai kalwéldia siyagaxaune tugazháldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Gueni Jate auxa axazabeñgueniki, Duwe aldéñ shaxaldixakue na gaxa akshá zeñka Oldibuxa saldi aldé. ");
INSERT INTO kog_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Exaki ekí kakbeyá: —Saldiñga alduna nazishabiñsáni na minagajuezhaldixa. Jinake ekí miñmeyakí. Jateja nashaldá ají múldigabak ekí guashi sezheklde nak: “Nají jubeju numañ nagatuñkaki nasga shanekuek guakshaldatshake jubejukueki ezua, ezua nuk axajuezhaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","”Naldatshak shuixaldikuenik mokue izhgaldaxaldatshak miñsajañga Galdildeya baxe neyaldatshakna, exa mokue mimeshjuizhakualdikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ekí kakbeyatshakna Péguldujañki ekí akiyó: —Saldiñga mabaja akualdiák jiaga, nas zʉnake ni mitsák mabajazháldikue, migapa za neyaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ekí akbeyatshakna, Duweja ekí akiyó: —Namak mikbeyaldikue. Kaiga siañ gayu mozhua zhikté kauldagá noxaldieñga, mañki maikjuizhañga “eñki tuazhúge nzha” maldakuaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ekí akbeyatshak jiaga, Pégulduja ekí zañga akiyó: —Amak ma nañga shuigakue nagatsexaldiák jiaga, ni mitsák “eñki tuazhúge nzha” makuagazháldikue nakldá. Ekí negatshakna saldiñga aldéñ shaxaldixakueja jiaga ekígaba na axaldexá. ");
INSERT INTO kog_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Guñguenik Duwe Jesú aldéñ shaxaldixakue juizhiñga Jetsemaní axezhogeñka neyatshak ekí kakbeyá: “Maiñki jai iteté nogwíñ, naski Jate nugaxazguashi.” ");
INSERT INTO kog_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ekí kakbeji na, Péguldu, Santiaku, Juañ na nauwa agajué zeñka agapa kauldeyeni Duwe aldunaxa akzekága itshaniñgaba akzeshi na, ");
INSERT INTO kog_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ekí kakbeyá: “Aldunaxa señgaba nakzegaksáni, itshankugega nuxa shuixaldá gugé jana ni nakzegapán. Maiñki jai abá xaldeki, kabagagába stuaté nogwíñ.” ");
INSERT INTO kog_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ekí kakbeñgueniki nauwa agajué zeñka neyatshak, Jate axazguaxaldiamak waxam pani ekí aldéñga jañguaka guashiñki guiyaba tuakue axazguazháka agakuañneshiñga ekí akbeyaldá: ");
INSERT INTO kog_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“‘Abba’, Najatée, mañki saldiñga atshamildakagaba nakna ekí migakuañnekú. Guiyaba atemajañ tuwi shuigakue nagatsaldaka nakualdatshak jiaga, ma ekíga najañguamildaka guashiñki, guiyaba tuakue naxazguakí naldatabaldaldé naldaka. Naldatshak, nas jañgugamak zekuagába, ma maldajañguamak zʉnake zekuakue ni majañgukú.” ");
INSERT INTO kog_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ekí axazguagueniki mokue maigua nekue nugeñka nagatshake, kabanekue sha sha katuakna uba kakldeñshi Simóñ Péguldu ekí axaldék: “¿Kabá nogakí shi maldók? ¿Mañki nauwa maldé nuxaki nas na kabagagába stuaté nogazhámildaka shi na? ");
INSERT INTO kog_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ekí kabagagábaki, be noshi, Jate axazguaxal nogwíñ, jiséja sha atshakue miñsanegatshak, amak atshabináldiamak. Akze, aldunaldiñki nabajasʉ́ñ miñzegatshak jiaga, maiñgabaki auxaga kama miñkaldaldazháka nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Gueni mokue Ajate axazguaxal neyeniki agakuañnekldamaga akbeyá. ");
INSERT INTO kog_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jiak ekí axazguagueniki mokue maigua nekue nugéñ nagatshake, ubajañga kagubiyane axabanekue sha sha katú. Uba kakldeyatshak Duwek ji akbeyakue kakzaldakí na naldá. ");
INSERT INTO kog_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Gueni Ajate maikjuizhane axazguaxal nenalgueni mokue kaxaldagatshak ekí kaxaldék: “¿Maiñ zʉnake zhiksekui, kabaxalga shi minók? Auxabé nek ni gu. Nas Jatetshi Asukuága ixagabaldeklduge neyazhakuashi sha atshixakuek naxaxexaldiéñ zek guashá. ");
INSERT INTO kog_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nakexaldixaki uñkuahí na nagapán. Akna, jeñ izhgaté xaldeki e nagatogaldi kuizaldi.” ");
INSERT INTO kog_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ekí guagatogueñga Duwe Jesúja 12 shaxaldixakue nañga agatsé Judaki axaldák. E nañga na, kágubakue duwá zhikzhe Duwe akuxaldiamak shezhá, kaldi juizhi kaksui axaldák. Ai guxaldixakueki Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue, nauwisaná nauwa akldé akzekueja kakaxanekue. ");
INSERT INTO kog_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Guatshak axañga Juda, Duwe gexaldixaja aikuek ekí kakbenane: “Nas mieldeki izhgajañgugé jana agatsaldi gualdikuake, ai miñguxaldinik nakuigasʉ́ñ miyuldeyaldí.” ");
INSERT INTO kog_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ekí kakbenalguamakga na Duwek axaldagueni: —Shi maldaxaldixa —axaldeshi jañguxá jana agatsaldi gua. ");
INSERT INTO kog_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Guake aldakldekueja Duwe iyapani amak akuxá. ");
INSERT INTO kog_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Amak akugatshaga na, ezua exa izhoxejañki ají shezhá ishkaklduguenik Jatek múldigaba agaskaitshixa akldé akzetshi nashi agisalshiñga tuan kuxa axabeñguá. ");
INSERT INTO kog_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Guatshake Duweja aldéñ guxal nakldekue ekí kaxaldék: —Maiñ natuwiñki, ¿kágubakue sáñkaldak kaugakshishikuge nak shi ekí agatsaldi shezhá, kaldi juizhi nakuxal minák? ");
INSERT INTO kog_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Akze, naski niuwi neyauxa juwí Jate axazakuageñka mimikenáñ shizhiji izhoxaldatshak jiaga, exaga ni mitsák nakugazhámine. Naldatshak saldiñga ekí zegatukaki, Najatetshi múldigabaja aldéñga káguba ikualdal gaxaldixaki, sakí agatsexaldixa guakldane amak nagatsexaldiamak zegatuka nakldá. ");
INSERT INTO kog_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Guatshake saldiñga aldéñ shaxaldixakueki Duwe ahezua abajeni nuk aldakuishiñga aldé. ");
INSERT INTO kog_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Exaga na, ezua nakua Duwek agapa neyatogueki egaba zhakuátema akba neyatoxé na, e jiaga akuxaldiamak zhakuáxa iyapanatshake ");
INSERT INTO kog_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ai za kaxabaji tubagatsega nakuí na gua. ");
INSERT INTO kog_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Guñgueni Duwe Jesúki Jatek múldigaba agaskaitshixa akldé akzé nugeñka awaldé. Exaki saldiñga Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, nauwisaná nauwa akldé akzekue, guiyaba shizhixakue ajuizhaldék. ");
INSERT INTO kog_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ekí Duwe awaldeyatoxeñga Pégulduki atuasánamak aldiwan nejiñga, Jatek múldigaba agaskaitshixa akldé akzetshi jubaldaxa, jueyáñ zeñka me ne. Exaki akuañgualdexaldiamak guksé ajuinéñ exa zalda kabukue na iyaté na gua. ");
INSERT INTO kog_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Eniñga na, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, akldé akzekue sanekakuegaba, mieldejañki Duwe Jesú sha atshane agatsaldi ne izhakuaxaldiéñ zhinik na shuigakue agatsé axeyaldaxaldiamak aldiyatshak jiaga kakzaldazhá. ");
INSERT INTO kog_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Akbiñgaki matshuwi nekueja naldagálde nuxa Duwe “agatsé nzha” izhakuagatshak jiaga, zhuajanañgaba akuagakí naldák. ");
INSERT INTO kog_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Guatoxeñki aldiweki ezuakuejañki Duwe Jesú agatsá naldazhé jiaga “agatsé nzha” akuashi ekí izhakuák: ");
INSERT INTO kog_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nasʉñki jejié sigíja ekí guagaté nukáñkalde: “Nas zʉnake jejié juwí Jate axazakuaka kágubaja nuxa gauwaneki tiñgualdikuenik, jiak maiguake mokue gauwaldikue. Aiki kágubaja nuxa gauwazháne naldaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ekí izhakuagatshak jiaga, zhuajanañgaba izhakuagakí na naldá. ");
INSERT INTO kog_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Guakna Jatek múldigaba agaskaitshixa akldé akzé kauwikenáñ izhgaldaxeni ekí Duwek aklduká: —Ekí mezhakuagatshak, ¿ji shalda ekí mezhakuaká shi mikldék? ¿Mañgaba zhikzukuashi kakiyokuabaldáldixa shi na? ");
INSERT INTO kog_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Akldukatshak jiaga, Duweja ni ji akiyokuagábaki, sʉnjá na noxá. Guakna mokue ekí aklduká: —¿Mañki Saldiñga netshi Jateja ezua zʉnekualdal zʉñgakaxaldixa guakldanega, Nauwijate akldé akzamakga kakzukuxatshi Asukuá giemi shi maldá? ");
INSERT INTO kog_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Guake Duweja akiyó: —Akzé. Aiga na nakú. Akna Saldiñga netshi Jateki auxaga kama aksuikue, saldiñga aksanegatogeñka, nas Asukuága ixagabaldekldugek jibatshaldi mual akldé akzeñka izhogaté minatualdixa. Ekíga na, jékaldaxa zhinik mauwixa mokue zabaté minatualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ekí guagatshakna Jatek múldigaba agaskaitshixa akldé akzejañki akldunasʉ́ñ neká awatuñshi na zhakuá izhgitshizgui ekí guak: —Kaiga mokue jejié sigí agatsaldiñga ne zʉñmeyaldixa zʉñgajuezhaksá guashá. ");
INSERT INTO kog_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Akze, Jate aguáñ izhbashi mual zukuaká nuká guashibiná. Akna ¿sakí agatsegaka miñguaxaldixa shi na? Guake saldiñgaja shuigakue agatsé axeté. ");
INSERT INTO kog_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Guakna, ezuakuejañki Duwe jutú iyatuañgui, zʉtuazháldiamak ubak zhakuá agabañgueniki agaldabikshiji ekí axaldék: —Mañki ji atuazháka jiaga tu makuamak nake, ¿me shi mabúk? Zʉñmeyá guwá. Guake exa zalda kabukueja jiaga Duwe agaldabikshaldá na akuá. ");
INSERT INTO kog_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ekí zegatoguéñ Pégulduki eniñga jubaldaxa, jueyáñ zeñkaga ité, noxeñki ezua munzhi Jatek múldigaba agaskaitshixa akldé akzetshi nashi zʉxaitá. ");
INSERT INTO kog_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ekí zʉxaitatoguéñ Pégulduki guksé ajuinéñ guañgualdegaté tuatshakna muldetua tuñgueni ekí akbeyá: —Ma jiaga Jesú Nasaldéxa zalda nañga izhomalde nakldá. ");
INSERT INTO kog_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ekí akbeyatshak, Pégulduja Duwe tuazhé guashi ekí guak: —Naldagálde, jinak ekí maldakuaká, naksʉ́ñ giemi nzha. Guaxeniki julduneñka neyatshake gayu kauldá. ");
INSERT INTO kog_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Exaga akldoxeñga na, ai nashijañga mokue tuatshak, exa zhekualdekuek ekí kakbeyá: —Jejié jiaga Jesúk agapa neñkaga nakldá. ");
INSERT INTO kog_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ekí nukatshak jiak, mokue Pégulduja ekí guak: —Miya, naski ai naldazhúge nakldá. Guñguenik jiak, nauwa maldé zegatogueñki exa zhekualdekueja ekí Péguldu axaldék: —Namak giemi ma jiaga Jesúk agapa neyatomalde Galdildeya zaldaga naldashibaldá. ");
INSERT INTO kog_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Guake Péguldujañki: —Nas namak guagakí naldikuake, Jatega shi guiyaba natuñshí. Akna namak axamiñkildashiñga na: “Ai sigí nakbeyabinukaki tuazhúge giemi nzha.” ");
INSERT INTO kog_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ekí guagatshaga na, gayu mutshuane kauldá na gua. Ekí kauldatshaga, Duweja axañga sakí akbenane Pégulduja be agisék: “Kaiga siañ gayu mutshuane kauldagá noxaldieñga, mañki maikjuizhañga ‘eñki tuazhúge nzha’ maldakuaxaldixa nakldá.” Ekí be agiseguakna itshankága mauwiñgaba na gua. ");
INSERT INTO kog_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Guñgueni muñzegapanatshake Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue, nauwisaná nauwa akldé akzekue juizhi ajuizhaldeshi na, saldiñga akldé akzekue sanekakuegaba ajuizhaldék. Ekí saldiñga aldaldi na, Duwe Jesú sakí akualdixa ishkakugueniki shiyabanega sáñkalda Pildatuk akualdé. ");
INSERT INTO kog_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ekí akualdeyake, Pildatuja Duwek ekí aklduká: —Guake, ¿ma shi juldiútshi sáñkalda akldé mikzé maldá? Guake akiyó: —Mañga ai naugé nakuák guashibaldá. ");
INSERT INTO kog_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Atshaga na, Jatek múldigaba agaskaitshixakuetshi sáñkaldakueja matshuwi atshane akuashi Duwe izhakuák. ");
INSERT INTO kog_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Guakna sáñkaldaja mokue aklduká: —¿Mitsá sha matshixa mizhakuaká nukakí shi maldá? ¿E zhikzukuaxabaldáldixa shi na? ");
INSERT INTO kog_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ekí akbeyatshak jiaga, Duwejañki ni nauwa yokuazhá. Ekí tuatshakna sáñkaldaja “¡sakí nak shi ishkualdazhá gu!” na jañguá. ");
INSERT INTO kog_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Guatshak nauwisanákueki Jateja san kagixa zhinik kakzʉxaitshanéñ ldiuwañ be izhgisekui kajuizhaldegauxa sáñkalda Pildatuja mielde paldesu nukaki kakibesakue agashishaldiake kakibesamakga kakibesixa. ");
INSERT INTO kog_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Naldakna atshake ezua sigí Baldabáki akuíbulduk zaldakue na kauwijí sáñkaldakue aguabiyaldiamak kaukakshishatoguéñ káguba guaxá ajanashane shalda na, aikue nañga kalseldi abexane na noxá. ");
INSERT INTO kog_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ekí noguéñ káguba duwá zhikzhe sáñkalda Pildatuk axaldaxeni, paldesu nuka ezua kakibesamakga kakibesakue agashishá. ");
INSERT INTO kog_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Guakna sáñkaldaja ekí kaklduká: —Ake, ¿mimisanátshi sáñkalda akldé akzé akuaka miñkibesa guakue shi minajañgú? ");
INSERT INTO kog_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jinake ekí kakldukazhá. Jatek múldigaba agaskaitshixakuetshi sáñkaldakuejañki Duwe Jesú mauldí axajanaté noshi nuxa agaxene katuwák. ");
INSERT INTO kog_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Guatshakna, Jatek múldigaba agaskaitshixakuetshi sáñkaldakueja, káguba duwá zhikzhe nakldekuek sáñkalda Pildatuk Baldabá kakibesakue akshishakue kaxasashiñgaba amak kaldekshá. ");
INSERT INTO kog_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Guake sáñkaldaja mokue kaklduká: —Guake, jejié “juldiútshi sáñkalda akldé akzé” miñguakáki ¿sakí gualdikue shi minajañgú? ");
INSERT INTO kog_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Guake jaldáñ ekí akiyayó: —¡Eñki kaldixa axaldiya guaxá guwá! ");
INSERT INTO kog_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Guake sáñkaldaja ekí kaklduká: —¿Sakígaba sha atshanéñ zhinik shi guagakueki minajañgú? Guatshak míñgaki mokue akldé jaldáñ ekí axaldék: —¡Eñki kaldixa axaldiya guaxa guwá! ");
INSERT INTO kog_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kágubakueja ekígaba axashishakna, kakldunamak kaxatshaldixa jañguakna Baldabáki kakibesá. Guatshake Duwe Jesú niñkauwañki kuizhushak agaldabikshaldiniki, kaldixa axaldiya akuaxaldiamak niuwi ge na gua. ");
INSERT INTO kog_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Guake suldáukueja Duwe Jesú sáñkalda tshuxa, kauwizhéñgaba ashekueñka awaldeyeniki aldahauxa nuk axajuizhakuá. ");
INSERT INTO kog_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gueniki Duwe aguáñ izhabashiñga, sáñkaldakueja zhakuá atsʉshi maksʉxaldá agatsé itshualdiyamak agatsé iyajualdí. Gueniki sáñkaldakueja izhalshuxa tuñgatse kausúga zhikba, zhikba axaxauweniki iyajiú. ");
INSERT INTO kog_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ekí akueniki sáñkalda akzé axaldegamak ekí axaldék: —¡Juldiútshi sáñkalda akldé mikzé, zeñ shi mikldeshí! ");
INSERT INTO kog_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ekí agabeyeniki sáñkaldeldi matshuwi juizha kaldik agaldabikshiji, jutú iyatuá. Gueni iyajokldeshi nuxa akldé akzukualdiamak axatshiji nuldu axayó. ");
INSERT INTO kog_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ekí auxa iyajokldegatogueniki, zhakuá atsʉshi maksʉxaldá agatsé iyajuigueni, mokue ají zhakuága iyajualdieniki kaldixa axaldiya akuaxal awaldeyaldá na akuá. ");
INSERT INTO kog_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Guñgueni Duwe Jesú awaldeyatogueñki, ezua sigí Simóñ axezhuka, Sildene zalda, Aldejánduldutshi, Alduputshi ajate atezhi zhinik kuíbulduk nagaté noxé kakldabí. Guake eñkáñ kaldi Duwe axaldiya akuaxaldixa kamañ naldi akuldeyexañ iyaxauwá. ");
INSERT INTO kog_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ekí Duwe awaldejiñga “Gólgota” axezhogeñka awaldé. Eñki “káguba tsáñkalda zaldáxalda” guashi. ");
INSERT INTO kog_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Eñkaga na, suldáukueja kalwéldia milda akjiukue Duweja tugexañ agaxegatshak jiaga tugazhá. ");
INSERT INTO kog_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Guñguake Duweki kaldik axaldiyá. Guñgueniki suldáukueja Duwetshi zhakuáki mieldekueja ipanaldixa ne atualdiamak ajanashiji aldiyá. ");
INSERT INTO kog_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Amak Duwe kaldik axaldiyatshake niuwi jue na zegatoxá. ");
INSERT INTO kog_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Duwe kaldixa axaldiyane asáñkaldake jinak shuigakue agatsé guaká ekí agazuñguane axaldiyá: “Jejiéki juldiútshi sáñkalda akldé akzé nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ekí Duwe kaldixa axaldiyatshak mozhua sha atshixakueki kaldixa kaxaldiyatshakna ezuañki Duwetshi jibatshaldi, ezuañki jibatshazháldi mual axaldiyá.  ");
INSERT INTO kog_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ai zhinik na, Jatetshi múldigabaja Duwe shalda guakldanamak nuxa zek: “Axautshikueja naldagálde nuxa tuñkáki, aldéñ jiaga guiyabaja guagamak axatshagálde ni atú.” ");
INSERT INTO kog_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Duwe axaldiyaneñka zʉxaitixakuejañki aguáñ izhbashi mual, zʉ́xaita nusagatsaldi axaldeshi ekí axaldék: —¿Ma ekí nexabálde shi na? “Nas zʉnake Jate axazakuageñka juwí tiñguanaka, jiak gualdikuenik maiguake mokue gauwanaka nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Ekí maldeka neki mañgaba ishkuá xaldeki, tuexa kaldixa zhinik akjiena guwá! ");
INSERT INTO kog_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ekibeñga iyajokldeshi na, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue na ekí akuák: —Jejiéjañki kágubakue muldetua kagauneshi, ikuá guxa ne, axaldáñ zʉnake ishkualdazháka tiuwi. ");
INSERT INTO kog_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Jateja aldéñki káguba ikualdal gaxaldixa guakldanega, nauwisaná Isayélkuetshi Sáñkalda nahamak nake, namak jañguakualdiamak ishkuá xaldeki kaldixa zhinik shi akjiení! Guatshak aldéñ na kaldixa axaldikualdekueja jiaga nusagatsaldi, sha axaldeshiñgaba na akuá. ");
INSERT INTO kog_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Duwe Jesú kaldixa axaldikualguéñ, niuwi muanté zhinik niuwi uñguexá kagi agatsauxa muldetua tuañ na zexá. ");
INSERT INTO kog_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Atshakna, Duweja jaldáñ ekí guak: —“Eldói, Eldói, ¿lama sabaktani?” Ekí guagatshake ekí guashi: “Najate, Najate, ¿jinak shi nahezua nabajá makú?” ");
INSERT INTO kog_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ekí guagaté aldukatshakna, anuñka exa zhekualdekuejañga ekí guak: —Nugwá, eñki nauwibama Eldiya ixauldatuka na ekí nek. ");
INSERT INTO kog_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Guakna ezua aikuega naldajiñga ezua samnek kuis kuis akzeldia agaldaksheniñki kaldik ijiú Duweja tuxaldiamak akulditshí tuñshiji ekí guak: —Tuaté kuiznoshí, sakí amak Eldiyaja kaldixa zhinik akjieñgual naxaldí. ");
INSERT INTO kog_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Gueni Duwe Jesú jaldáñ kauldeniki shuizhá. ");
INSERT INTO kog_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Atshaga na, juwí Jate axazakuageñkaga, ezua zhakuá atema akaldak akzeñka juldunéñ agekualdé, aldéñgaba mataxa zhinik muan zuwá kagixa tiñ itshizbé na gua. ");
INSERT INTO kog_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Guatshakna ezua suldáutshi sáñkalda Duwe buan akldoxéjañki ekí agatsaldi kauldeni, shuizhá guaté tuatshakna ekí guak: —Namakga, jejié sigíki Saldiñga netshi Jatetshi Asukuá giemi naldé tiuwi. ");
INSERT INTO kog_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Guatshake anuñka munzhikue agajué zeñka Duwe akuatoxauxa atuaté na aldoxá. Aikue na, ezuañki Maldiya Makldalda zalda, ezuañki Saldumé, ezuañki Maldiya, eñki Santiaku awawatshi, Jusétshi ajaba na naldá. ");
INSERT INTO kog_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ekueki Duwe jañguxakue ji agajuezhatshak agaxaunexaldiamak Galdildeya zhinik agapa aldakldekue. Kauwizhéñ nañga matshuwi munzhikue Duwek agapa Jeldusaldéñ aldakldekue jiaga na ashekualdá. ");
INSERT INTO kog_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Guatshake ezua sigí Jusé Aldimateyaxa zaldaki Saldiñga netshi Jateja saldiñga aksanexaldiéñ ldiuwañ zexaldixa jiaktuwi za izhuka. Eñki nauwisaná sanekakuegaba akldé akzekue nañga agatsé akzé na naldá. Atshaga nauwisanákue zhigasekué ldiuwañ naki zeshi guakna, saldiñga janaktuakue niuwañ na zaldá. Guatshakgaba naki tuañ zexaldá guapanakna, Juséja Duwetshi abuá mexaldiamak akzék naldakí sáñkalda Pildatuk niuwi akshishal ne. ");
INSERT INTO kog_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Amak akshishatshak sáñkaldaja “¡Jesúki mitsáte shuixé!” jañgui na suldáutshi sáñkalda naxal guak. Amak axaldagatshak “¿Jesú au shuanamak shi na?” aklduká. ");
INSERT INTO kog_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Shuanamakga ne akbeyakna janshibeñga Juséja Duwetshi abuá mexaldiamak uldeyaka niuwi agé. ");
INSERT INTO kog_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Guakna Juséjañki zhakuá tiñne janshagatse jabiñgueniki Duwetshi abuá kaldixa zhinik axawatiñgueniki aik mañguá. Gueniki jagiga shuanekue abexaldiamak axakuiyaneñka meguenik juldunéñ jagi saldáñ pakue atema akyó. ");
INSERT INTO kog_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ekí atshatogueñki Maldiya Makldalda zalda na, Maldiya Jusétshi ajaba nañki exa Duwetshi abuá mashi abegatuka atuaté na aldoxá. ");
INSERT INTO kog_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Guñgueni kizhiksekué ldiuwañ zʉxaiti, niuwi iyaldagatshak, Maldiya Makldalda zalda, Maldiya Santiakutshi ajaba, Saldumé nañga we juma izhuka Duwetshi abuák iyabexaldixa ajabí. ");
INSERT INTO kog_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Guñguenik abokualdi, dumiñkuke zhe meñga, ai munzhikueja Duwe Jesútshi abuá abexaneñka atuál aldeñká ");
INSERT INTO kog_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ataba atabañ zhinik ekí izhgabeyá: —Duwetshi abuá abexanaldi juldunéñ jagi saldáñ pakue atema akyokue ¿meja zʉñkagajuekualdixa ne? ");
INSERT INTO kog_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Izhgabene naldé, abexaneñka atuatshake jagi saldáñ pakue agubisha atema agayone nalgué jiaga, axajuekuá guane na atuwá. ");
INSERT INTO kog_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gueni abexanaldi ajuldunapanatshake ezua nakua zhakuá abutshi kasaxa duwá agatsé ijuakue jibatshaldi mual ité atuatshakna, she she she ishkaldakuí. ");
INSERT INTO kog_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Guakna ekí kakbeyá: —Zhe miñzegagába. Maiñki Duwe Jesú Nasaldéxa zalda kaldixa axaldiya akuaxane niyabinuka. Eñki shuiguenik mokue izhgaté guane nakna jai isʉ́ñ nzha. Akna, ají abuá ashanéñ tu guwíñ. ");
INSERT INTO kog_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Naldiniki Pégulduk, saldiñga Duweja shaxaldixakue juizhiñga ekí kakbeyal mineyaldí: “Duweki miñsajañga Galdildeya neyakna, maiñ exa mineyatshakna miñmeyananamakga aldéñ naldi mitualdixa niyó.” ");
INSERT INTO kog_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ekí atuatshakna munzhikuejañki “¡sakíga ni jañguakuá!” kakldegazháldi na tau, tau kakzeshi, exa abuá abexananeñka zhinik aldakuishi saldi aldé. Gueniki zhe kakzeshiñga, aldeyatogueñki sakí zeklde ni mek agabeyazhá na akuá.  ");
INSERT INTO kog_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Guatshak ai ldiuwañga dumiñkuke zhe meñga Duwe Jesúki mokue izhgaldagatshak, Maldiya Makldalda zalda mishañga akizhañká. Ai munzhiga na kugua jisétshi aldunakue izheñshanane. ");
INSERT INTO kog_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Amak akizhañkañguake Duwe agapa neyatonekuek sakí tune kakbeyal neyatshake, e shalda iyabauwiñgaba guaté katú. ");
INSERT INTO kog_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Guatshak Duweki shuigueni mokue izhgatene beñga nuka munzhija tune aldukatshak jiaga, namak ajañguazhá na gua. ");
INSERT INTO kog_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ekí zegueni Duwe Jesúja jiak, mokue mozhua agapa neyatonekue kuíbulduk zhinik agazaxaitiñguenik aldeyatogueñki, atshake sha agatsaldi kakizhañká. ");
INSERT INTO kog_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Gueni kauwizhéñ na agatsekue Duwe atú guane agabeyal aldeyatshak, ekue jiaga namak axajanazhá. ");
INSERT INTO kog_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aldiweki Duwe Jesúja aldéñ 11 shaxaldiyatonekue asaji ajuizhaldegatoguéñ kakizhañkatshak ekí kaxaldék: “¿Jinak shi alduna nazishazháldi, ezua, ezuaja naski mokue izhgaté guanuge natune miñmeyatshak jiaga, ‘namak jañguazháldiku’ itshanamine na?” ");
INSERT INTO kog_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Gueni ekí kakbeyá: “Maiñki saldiñga kagi nahauxa mineyaldí. Amak neji na, saldiñga káguba saná na nahauxa nas kekuanuge shalda miyakbeyaldí. ");
INSERT INTO kog_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Akze, mieldeki ‘nazikuanamak shakldá’ najañgui, amak awatuñshaldiamak nik ajaukshixa na Najateja ikualdaldixa. Ne mielde ekíga najañguakí naldaldiák zʉnake, eñki Najateja guiyaba tuakue agatsé axezhaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","”Mieldeki namak najañguxaki, nají aldé awatuñshaldiamak janshizhe ajanashaté atú guazhámak nasga nají kamak katshishaldikue. Ekí katshishi na, jisétshi aldunakue ‘Duwe Jesútshi kamak newa ni mikbeñkú’ axaldeshi kágubak zhinik iyaldeñshaldixa. Ekíga na, kauwizhéñ ezua kaugiañ zukuagazhék jiaga, nasga kazukuakshaldikue. ");
INSERT INTO kog_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ekibeñga na, kakldegakíñga takbi sui iyapanatshak, azhi suldimáñ atugatshak jiaga sha kakushazháldikue. Jiak ekíga na, mulbatá akzekakue káuxalda iyapañguatshak, nají kamajañga se kakzukualdixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nauwijí Sáñkalda Duwe Jesúja ekí kakbeñgueniki jékaldeldi awalditshí. Exaki Ajate jibatshaldi mual akldé akzeñka yaté na gua. ");
INSERT INTO kog_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Guatshak Duweja shaxaldiyatonekueki san, san aldeji, káguba zhekuauxa “Duwe Jesú zʉnekuane nakldá” akuashi na aldeyá. Ekí akuashi aldeyatoguéñ na, nauwijí Sáñkalda Duwe Jesújañki kagauneshiñga aldéñ shalda akuaká namaklde ne awatualdiamak janshizhe ajanashaté atú guazhámak na katshishatoxá. Ekíga shi naldí.");
INSERT INTO kog_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Matshuwi nekuejañki Duwe Jesú jai kagik izhogatoguéñ atshiji, shizhiyatone shalda kalta axauwane. ");
INSERT INTO kog_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ekí axauwanekuejañki kauwijí ubak naldi Duwe atshatonauxa atunekueja zʉñmeyanamakga zʉñgabeji kalta axauwane. Aikueki Jatek axazauwi ají múldigaba guakakue. ");
INSERT INTO kog_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Guatshak nas jiaga Duwe naxaldixa zegapananéñ zhinik muldetua zekldauxabé izukajiñgaba izhokugakna ai shalda, Duwe Teyupilduk, ma janshibé kalta migakauwaldikue itshananuge. ");
INSERT INTO kog_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ekíki Duwe shalda shi mixaldiyane namakldega ne mikualdaldiamak. ");
INSERT INTO kog_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Guatshak juldiú sanákue aksaneka sáñkalda Eldode izhogatogué baxañ, ezua sigí Sakaldiyaki Jatek múldigaba agaskaitshixa na naldá. Eñki Jatek múldigaba agaskaitshixa nane Abiya na agatsekue na naldá. Asewá Isabél jiaga Jatek múldigaba agaskaitshixa nane Aldóñ ldaxega na naldá. ");
INSERT INTO kog_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ai mozhua nekueki Jateja jian izhoxa guiyaba kaxabajaneja guagamak za ajanashixakue. Akna Jateja tuwiñki, kagatsaldazhé, jian za izhukakue katuñka. ");
INSERT INTO kog_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Naldatshak ni ezua sukua kaxaldegazhé. Munzhiki somá axaldegazháka nalguamakga na, mozhua aldamakga dueba, wezhu na aldaldá. ");
INSERT INTO kog_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ezua ldiuwañ Jatek múldigaba agaskaitshixakue Sakaldiya na agatsekue, Jate axazakuagaldi jibatshakue kagatsalguakna aldéñki ai jiba atshiji na guatoxá. ");
INSERT INTO kog_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Atshaga meja Jatek ezua we juma izhuka akiyogakue agatsé atualdiamak ajanashamakga aldiyá. Amak aldiyatshake Sakaldiya agatsé atuñguakna, ai akiyoxal juldú. ");
INSERT INTO kog_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Amak akiyogatogatshake, saldiñga jubaldeldi zhekualdekueki Jate axazakuashi na aldoxá. ");
INSERT INTO kog_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Amak yogatogueñki, ezua Jateja guaklde uldeñka eni yogatogualdi jibatshaldi mual akizhañká. ");
INSERT INTO kog_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Amak akizhañkatshake, Sakaldiyaki she she she ishkaldakuikshi, zhe akzukuá. ");
INSERT INTO kog_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Guakna guaklde uldeñkaja ekí akbeyá: —Zhe mikzegagába. Saldiñga netshi Jatejañki agakuañnekbaldamak maldukanéñ zhinik na, misewá Isabélki somá sigí sukue axaldexaldixa. Eñki Juañ axamizhaxaldixa. ");
INSERT INTO kog_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","E somáki matshuwi zeñ mikzukualdixa. E kukatshakna, kágubakue matshuwi zeñ kakzukualdixa. ");
INSERT INTO kog_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jinake naldakí. Eñki Jateja tuwiñki akzé tualdixa nak. Aldéñki ni mitsák jigaba mastukshakue tugazhíta naldaldixa. Ne kukagá noxaldieñga, Jatetshi Alduna za auxaga axaldeshi na, eja za aksaneka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Atema nexaldinik matshuwi asaná Isayélkue Jatek agijuldunaté nukakue mokue agakualdikshaldixa. ");
INSERT INTO kog_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Misukuáki Jatetshi múldigaba naldiñga zʉxaitshixa Eldiyak ají Aldunaja kama ageshi aksaneka nanamakga aksanegatshakna kágubakue kauwijí sukuakue mokue kajañgushiji, keshkabakualdixa. Ekíga na, jian izhukakueja “Jatek akldunamak izhoxaldikue shakldá” izhajanamakga, amak atshasʉ́ñ akzekakue ekíga itshani kezhokshaldixa. Ekí atshatshakna nauwijí Sáñkalda naldi nagatshak, kágubakueja muldetua iyapanaldiamak janaktualdixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ekí akbeyatshakna Sakaldiyaja aklduká: —Nas, nasewá nañki agubisha dueba, wezhu nek guáñkalde ne, ¿sakí shi amak somá zʉñkaldexaldixa nakualdaka na? ");
INSERT INTO kog_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Guñguake guaklde uldeñka Galdabiélja akiyó: —Saldiñga netshi Jatejañga naski axazauwaldikuamak niuwi nagene nakna, aldéñ tsaldiñga janshizhe mixatshaldixa mikbeyal nakaxane. ");
INSERT INTO kog_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Naldatshak mikbeñkuge “namak nzha” jañguazhámaldeñ zhinik na, kaiga zukuaxabiksánaldinik mikbenugamak zexaldixa ldiuwañ yo ekí mizhoxaldixa. Ne ai ldiuwañ zegatshake, mikbenugamak zexaldixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ekí zegatogatshake jubaldeldi ashekualdekueki Sakaldiya jiyagatuwi na, “¿jinak Jate axazakuagaldi maldé itsegapanká?” izhgalduká. ");
INSERT INTO kog_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Guatogueñki eni zhinik akzʉxaitatshake zukuagaksá guanega nalguakna, káuxaldak nuxa kaxazguaxaldiamak atshá. Ekí atuatshakna “eni Jateja jigaba tuñshé tiuwi” kakldék. ");
INSERT INTO kog_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Amak Jate axazakuagaldi jiba axatshiji aksaldiñguake ajuldi ne. ");
INSERT INTO kog_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ekí zeguenik anuñka zegatshake asewá Isabélki somá axaldexaldá. Guñguake jatshiwa saxa ajuldi za izhoshi na: ");
INSERT INTO kog_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Kaiga zʉna Saldiñga netshi Jate guañ najañgui, somá naxaldekshaldá. Akna somá naxaldegazháka shalda kágubakue jiwak nagazukuxa nazikuxá guxa tiuwi” akldeshi na izhoxá. ");
INSERT INTO kog_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Guane nalgué Isabél tezhuwa saxa itsegatogueñki, Jateja aldéñ guaklde uldeñka Galdabiélga Galdildeya baxe kuíbuldu Nasaldéxa gaxá. ");
INSERT INTO kog_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Exaki ezua munzhi Maldiya sigí izhguajagáldega nalgué, Juséki sáñkalda Dabí nanetshi atukuaga na akuxaldixa jeñ ashisha akuanekue na naldá. ");
INSERT INTO kog_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nalgué na, Jateja guaklde uldeñka ai munzhik akizhañkaji ekí axazguák: —Saldiñga netshi Jate atemajañ zeñ majañguane nakldók. Aldéñ naldiñga ma nañga na izhók. ");
INSERT INTO kog_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ekí akbeyatshake Maldiyajañki: “¿Jinak shi ekí naxaldegapán?” zhikldukshiñgaba ");
INSERT INTO kog_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","guñguake Jateja guaklde uldeñkaja ekí akbeyá: —Munzhi, Jateja atemajañ guañ majañguane nogéñ zhe mikzegagába nogwá. ");
INSERT INTO kog_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kaiga zhinik somá sigí sukue mixaldegapanaldixa. Amak mixaldegatshak eñki Jesú axemizhaxaldixa. ");
INSERT INTO kog_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Eñki akaldak akzé giemi naldaldixa. “Saldiñga netshi Jate akaldak akzetshi Asukuá giemi nakldá” akuaxaldixa. Nauwijate, Saldiñga netshi Sáñkaldajañga mimibama Dabí sáñkalda sanexaldixa itenamakga misukuáki izhaxaldixa. ");
INSERT INTO kog_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Amak izhagatshake, e zʉnake Jakóp shtukuakue juldiú sanákuetshi sáñkalda izhoshiñga na, ni mitsák sanegaksá guazhíta nakldá. ");
INSERT INTO kog_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Guake Maldiyaja: —Naski sigí izhguajagáldugega ne, ¿sakí shi amak somá naxaldexaldixa na? —aklduká. ");
INSERT INTO kog_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Guñguake akiyó: —Jatetshi Aldunaga mixagatanatshake, Saldiñga netshi Jate akaldak akzetshi kamaga mixagatani, ejañga somá mikzalshá gualdixa. Akna, somá mixaldexaldixaki janshizhe, sha atshagálde, “Saldiñga netshi Jatetshi Asukuá giemi nakldá” akuaxaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Akze, mizhú Isabél naldiñki wezhu, somá axaldegazháka akuaka nane naldatshak jiaga, somá axaldexaldá gueni tezhuwa saxa na itsegatók. ");
INSERT INTO kog_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Akze namak, Nauwijatejañga ni jiki atshazhákaki naldazhé giemi nakldá —na akbeyá. ");
INSERT INTO kog_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Guake Maldiyajañki: —Naski Saldiñga netshi Sáñkaldak axazauñkuge, ají nashi naugakna nakbemaldamak aldéñki shi naxatshiji —na guaxá. Ekí akbeyatogueniki, Jateja guaklde uldeñkaki ne na gua. ");
INSERT INTO kog_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ekí nukañguenik Maldiya janazhiktuñgueniki, mija kuíbuldu Juldeya baxe gaxakue akshashá zeñka ne. ");
INSERT INTO kog_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Amak neyatshak augwi Sakaldiya tshuk juldungueni aldú Isabél axazguák. ");
INSERT INTO kog_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ekí axazguaká nukatshake, ají somá dzhizhaxaga kamakualdi wi wi atshatshaga na, Isabélki Jatetshi Alduna muldetua auxaga axaldaldaldiamak ijuldú. ");
INSERT INTO kog_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Guakna ekí jaldáñ guak: —Ma zʉnake Saldiñga netshi Jateja saldiñga munzhikue zeñ kajañguxa guashiñki zhakaldak zeñ majañguxa. Ekíga na, somá sigí sukue mixaldexaldixa zeñ jañguxa ni tuñkú. ");
INSERT INTO kog_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Jinak Jate ekí atemajañ zeñ najañgui, nají Sáñkalda tshabaga naxabizhakue jañgué? ");
INSERT INTO kog_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Maldaxazguaká nukaldatshaga na, nají somá kamakualdi dzhizhaxaga zeñ akzukui wi wi na atshá. ");
INSERT INTO kog_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jateki aldéñ naldiñga zeñ majañguxa nakldá. Jinake naldakí. Aldéñ janshizhe mixatshaldixa mikbeyatshak namak jañguamalde nak —na aldanik akbeyá. ");
INSERT INTO kog_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Guake Maldiyaja ekí na guagapaná: “Saldiñga netshi Sáñkalda nagatsauxa akldé akzamakga akzukualdikue. ");
INSERT INTO kog_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ega na Nauwijate Nekualka nak nají aldunak zeñ nakzukuxa. ");
INSERT INTO kog_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Akze, naski ni me jiaga naldazhúge, egaba ají nashi nuxa naugé nezhikjuizhanshakí izhuka. Akna, kaiga zhinik niuwizhíne yo, saldiñgaja aldéñ sakí atemajañ zeñ najañguane shalda nakuagataná nakldá. ");
INSERT INTO kog_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Jinake naldakí. Saldiñga netshi Jateki janshizhe, sha atshagálde, auxaga kama axaldé izhukaki atemajañ janshizhe naxatshane nak. ");
INSERT INTO kog_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Akze, Jateki nauwibamakuexa zhinik niuwizhinexá jiaga axabeti zhema akizhukakueki guañ kajañgualga nogataná nzha. ");
INSERT INTO kog_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jatejañki saldiñga aksuikualdi kama axaldéñ zhinik guagasá atemajañ janshagatsegaba atshane. Aldéñki káguba sekuazhikshiji, kakzá naldazháuxa akzé itshankakue nuk ezua ezua kaldeñshi na, ji ajanashaldixa janagatunekue nuk kagitamakuane. ");
INSERT INTO kog_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ekíga na, sáñkalda akldé akzekueki kakjieñguane. Ne ai itsaldagálde axajankakue niñkauwañki akldé kakzukuane. ");
INSERT INTO kog_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Káguba jika agajueshkakueki ji kagajuezhaldiauxa kagene. Naldatshak kabiakue niñkauwañki, ni ji naldakí kaldeñshane nzha. ");
INSERT INTO kog_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Guatshak Jateja nauwisanákueki guañ kajañgualdixa kakbenanamak, akjuizhanakí aldéñ kaxazauñka Isayélkuañ zʉñgaunexalga za nogatuka. ");
INSERT INTO kog_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Akze, nauwibama Abaldahám atukuakue juizhi guañ zañga kajañgualdixa kakbenanamak, amak zʉñkatshijiñga nagatuka nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ekí guagueni Maldiyaki aldú na anuñka smaigua izhogueniki mokue ajuldi ne na gua. ");
INSERT INTO kog_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Guatshak Isabél somá guxaldixa ldiuwañ zegatshake, amakbeñga sigí sukue axaldék. ");
INSERT INTO kog_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jateja ekí atemajañ guañ jañguane aldukatshakna akyó izhukakueja, akajakueja e nañga zeñ na kakldexá. ");
INSERT INTO kog_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Guatshak juldiú sanákueki sigí sukue nauwa abeñguamak ai somá kukañguenik, ábigua ldiuwi itseguake abeñgualdieñka awaldé. Akuñguenik exa nenekueja ajate axezhogamakga, Sakaldiya, axeyaldaxaldixa akuagatshakna ");
INSERT INTO kog_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ajabajañki: —Eñki ekí axezhogazháldixa, Juañ axezhogakue naldaldixa nakldá —na guaxá. ");
INSERT INTO kog_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Guakna akiyayó: —Mikajakue ezua ekí axezhuka naldakí naldashá. ");
INSERT INTO kog_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Guñguenik ajatek asukuá me axezhaxaldixa agaldukaldiamake káuxaldak nuxa agalduká. ");
INSERT INTO kog_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Guakna jika akzuñgualdiamak shishiñgueni, “Juañ axezhoxaldixa nakldá” akzuñguá. Ekí atuatshakna saldiñgaja “¡sakí shi ekí axezhogaka na!” ajañguá. ");
INSERT INTO kog_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ekí ajateja akzuñguatshak, ubañga mokue zukuaxaldá. Guñguenik ají múldigabak naldi Jate akldé akzamakga akzukualdá. ");
INSERT INTO kog_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sakí zeklde eñgui akyó izhukakueja aldukatshak, “¡sakí ekí zeká!” ajañguá. Ekíga na, Juldeya baxe gaxakue akshashá zeñka izhukakueja jiaga, ekí zeklde shalda na izhgabeyatoxá. ");
INSERT INTO kog_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Saldiñga ekí zeklde aldukanekuejañki: “Saldiñga netshi Jatejañki ai somá ají kamak agauneshi izhogéñ zhinik na, ¿ji nexaldixa ne?” na izhgaldukajá. ");
INSERT INTO kog_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Guñgueni Jatetshi Aldunaja auxaga aksaneshiñga somátshi ajate Sakaldiyak ekí na guakshá: ");
INSERT INTO kog_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nasʉñ juldiú saná Isayélkuañki Saldiñga netshi Sáñkalda, Nauwijatega za akaldak akzamakga kuizakzukuí. Jinake naldakí. Nasʉñ ají kuíbuldukuañki zʉnekualdal naklde nak. ");
INSERT INTO kog_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Aldéñga ezua kamakue zʉnekualdal zʉñgakagatukaki, Eñki nauwibama sáñkalda Dabí, axazauñka nanetshi atukuaga ni zʉñgakagatók. ");
INSERT INTO kog_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Akze, mauzeñga zhinik Jateja ají múldigaba naldiñga zʉxaitshixa izhgakuxananekuek ekí zʉñkatshaldixa kakuakshanane. ");
INSERT INTO kog_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Aldéñga ezua zʉnekualdal zʉñgakaxanaldixak na, sha zʉnakundana akzekakuek, aguldiji kizhukakuek zʉñgubiji guakuak zʉnekualdaldixa. ");
INSERT INTO kog_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Akze, Saldiñga netshi Jatejañki nauwibamakue guañ kajañgui, atukuakue jiaga ekí kajañgualdixa kakbeji, kauwizhéñ na ishkualdi izhogapananane, ne akjuizhanáaki zʉñkatshaldixaga. ");
INSERT INTO kog_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Akze, aldéñga nauwibama Abaldahám axakildashi na, ");
INSERT INTO kog_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kaguldiji kizhukakue zʉñgubiji guakuak zʉnekualdaldixa akbenane. Amak zʉñkatshiji, zʉñgauneshiñga na zhe zʉñzegakí aldéñ za axazauwi na, ");
INSERT INTO kog_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kagik izhoxalga nogakualdieñki ají za naldi, axazauwi akldunamak jian izhogakualdixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Gueniki asukuá shalda jiaga Jatetshi Aldunaja ekí na guakshá: “Nasukuá, ma zʉnake ‘Saldiñga netshi Jate akaldak akzeja ají múldigaba naldiñga zʉxaitshixa nakldá’ makuaxaldixa nakldá. Jinake naldakí. Jateja nauwijí Sáñkalda zʉnekualdal gaxaldixaki kágubakueja iyapanaldiamak janakaktuwi, axañga jiúñgulda axakbeñgui jana maxatshaldiamak makaxane nak. ");
INSERT INTO kog_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Amak axatshiji na, kágubakue sha ajanashixa Jateja sakí kaxabeti, kekualdaldixa ne shi kabaxaldiyaldixa. ");
INSERT INTO kog_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Jinak ekí zʉnekualka naldakí. Nauwijateki atemajañ guañ zʉnajañguxa nak. Ekí zʉnajañguéñ zhinik na, niuwi zʉndañkashamakbé ezua jékaldaxa zhinik zʉnekualdal zʉñgakaxaldixa. ");
INSERT INTO kog_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","E zʉñgakagakíñgaki, sha katshixaga tuañ zʉñzukuane nak shuixaki zhe zʉñzukuxa. Ne ai Zʉnekualkaki aldunaxa mu zʉñzekui guxá jana zʉñzukuatshakna, Jate na señgaba zhe noxa shi zʉñkaldiyaldixa nzha.” Ekí na guakshá. ");
INSERT INTO kog_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Guñgueni somáki guildegatogatshake aldunak jiaga kamakue guildegatoshi na, asaná Isayélkuek Jatetshi múldigaba kakbeyakíñgaki, zʉk zeñka za na izhoxá. ");
INSERT INTO kog_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Atshak baxañki kagi Aldumaxa zaldakueja san san kagi agubiyanekueki aksaneka. Exa zalda sáñkalda akldé akzeki Agustu axezhukaja na káguba aldéñ aksanegauxaki nuk izatakue niuwi ge. ");
INSERT INTO kog_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Izatazhóshi, kasak izatatogatshak baxañki ezua sáñkalda aguáñ akzé Sildeniu axezhukaki kagi Sildiaxa zaldatshi sáñkalda na izhoxá. ");
INSERT INTO kog_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Guakna amak iyazataldiamake, saldiñga kauwijí kuíbulduxa, kauwibamakue kukananeñka, kaksezhexaldiamak aldeyakue kagatsék. ");
INSERT INTO kog_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ekí guñguakna Jusé jiaga Galdildeyaxa kuíbuldu Nasaldéxa izhuka nalgué, exa zhinik Juldeyaxaga kuíbuldu Beldéñka sáñkalda Dabí kukananeñka neyakue agatsék. Jinak naldakí. Aldéñki etshi atukuaga naldák. ");
INSERT INTO kog_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Eñka na kaxazhuka kaksezhexaldiamak neyatshake, asewá nexaldixa aldéñ na ishkualdi izhuka Maldiyaki somá axaldegatuka agapa uldé. ");
INSERT INTO kog_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Eñka na somá kukaldixa ldiuwañ zek. ");
INSERT INTO kog_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Guñguenik Maldiya somá kasak zalda sigí sukue axaldék. Guñguake zhakuák muldetua mañguá guñgueniki, béyakzekue kabagaldi nuxa sha na gua. Jinake naldakí. Matshuwi ashenatshake juwí axabagaka mani kabagakue naldakí naldák. ");
INSERT INTO kog_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Eñgui akyoñga kágubakueja kauwijí jubeju sesʉñ játuldi numañ atuwi aldoxeñki, ");
INSERT INTO kog_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jateja guaklde uldeñka kakizhañkatshakna, nauwijí Sáñkalda Jatetshi muñshí zaldaga me yo zek. Ekí atuatshak matshuuwi zhe kakzukuñguakna, ");
INSERT INTO kog_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","guaklde uldeñkaja ekí kakbeyá: “Zhe miñzegagába nogwíñ. Janshizhe zeklde miñmeyal naklduge, saldiñga káguba minauxa ai minukatshak atemajañ zeñ miñnexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ai na kaiga Beldéñka, sáñkalda Dabí kukananeñkaga, Jateja ezua minkualdal miñgakaxaldixa guakldane ni kuká, eñki Saldiñga netshi Sáñkalda nakldá. ");
INSERT INTO kog_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Eñka tual mineyatshak, béyakze kabagaldi somá atsʉshiga zhakuák makue sha mitualdixa niyó. Miñmeyanugamak mituatshaga na, ‘namak nakbeñgué tiuwi’ miñnexaldixa nzha.” ");
INSERT INTO kog_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Amak kakbeyatshaga na, matshuuwi jékaldaxa zalda Jateja guaklde uldeñkakue iyaldañkaji Jate akldé akzamakga akzukui ekí akuák: ");
INSERT INTO kog_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Saldiñga netshi Jate jékaldaxa zalda akaldak akaldak akzé izhogakna, ekí akzamakga zañga kuizakzukuí. Kagixa mieldekueki aldéñga zeñ kajañgualdiake, aikueki señgaba zhe shi kaldokshí.” ");
INSERT INTO kog_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ekí akuagatoguenik, jiak mokue jékaldaxa saldi alditshi, guñguake jubeju numañ tuñkakueja ataba atabañ ekí izhgabeyaldá: “Nauwijí Sáñkaldaja aldéñ guaklde uldeñkakue zhinik janshagatse zeklde zʉñmene, Beldéñka ai tual kuizaldi.” ");
INSERT INTO kog_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Amak izhgabeñgueniki ubañga eñka atuál aldeyatshake, Maldiya, Jusé na somáki béyakzekue kabagaldi sha atú. ");
INSERT INTO kog_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Amak somá atuatshakna Jateja guaklde uldeñkaja e shalda kakbenalguamak na akuagapaná. ");
INSERT INTO kog_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ekí guagaté aldukatshak saldiñgaja “¡sakí amak zeklde ne!” kakldék. ");
INSERT INTO kog_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Guatshak ajaba Maldiyaja zʉnake somá shalda zegauxa aldunaxa akjuizhanáaki, ai za jañguiñgaba na guatoxá. ");
INSERT INTO kog_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Guake jubeju numañ tuñkakueki mokue játuldi aldeñkáki, Saldiñga netshi Jate akldé akzamakga agazukui axazabeji saldi aldé. Jinake naldakí. Jateja guaklde uldeñkaja guaká aldukane, sakí zeklde kakbenalguauxabe atune nalguák. ");
INSERT INTO kog_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Guatshak somá ábigua ldiuwi itseguake, juldiú saná sigí sukueki nauwa abeñguamak abeñguakue zexakna amak abeñguá. Atshaga na Jateja guaklde uldeñkaja ai somá ajabak axaldegagá nogueñga axezhagakue akbenalguamakga na Jesú axeyaldaxá. ");
INSERT INTO kog_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Guñgueni Jateja nauwibama Muesék munzhiki somá axaldexaldinik, sakí janshi ishkazguí atshakue agatsaldaldixa guiyaba kaxabajanalguamak atshakue zeguake amak atshál aldé. Atshaga na, Jusé, Maldiya na Jeldusaldéñka juwí Jate axazakuageñka Saldiñga netshi Sáñkaldak “jalde somáki mijí za naldaldixa nzha” agabeyaldiamak somá awalditshí. ");
INSERT INTO kog_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jinake naldakí. Guiyabajañga saldiñga sigí sukue kasak kukaxákueki Saldiñga netshi Jatetshi za naldaldiamak agegakue guaka nalguák. ");
INSERT INTO kog_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ekíga na, ajatekue nauwijí Sáñkaldatshi guiyabaja guagamak mozhua shamí Jatek axakuaxaldiamak agaxexal jiaga exa aldene. ");
INSERT INTO kog_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Atshake Jeldusaldéñka ezua sigí Simehóñ na izhoxá. Eñki jian izhoshi na, Jate za akldé akzamakga akzukui izhuka. Nalguakna Jateja asaná Isayélkue ikualdal ezua gaxaldixa guakldane, ai za jiaktú nuka. Jatetshi Aldunaki e na izhuka nakna muldetua aksaneka na naldá. ");
INSERT INTO kog_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","E Aldunajañga na shuigagá noxaldieñga Jateja ezua zʉnekualdal gaxaldixa guakldane tualdixaga mu agisekuane. ");
INSERT INTO kog_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ekí Aldunajañga aksaneguakna juwí Jate axazakuageñka ne. Exaki somátshi ajabakue somá nañga guiyabaja guagamak ajanashál aldene katú. ");
INSERT INTO kog_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tuñguake Simehóñja somá zhikshiñguenik Jate akldé akzamakga akzukui na, ekí akbeyaldá: ");
INSERT INTO kog_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Nají Sáñkalda, naski mixazauñkuge nuxa naugé. Sakí maldaxatshaldixa nakbemaldamak naxatshá makuakna, kaiga zʉnake nají aldunaxa señgaba nakzeshi shuixaldakuká ni gu. ");
INSERT INTO kog_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nají ubak naldi zʉnekualdaldixa zʉñgakaxamalde au tu gugák. ");
INSERT INTO kog_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Eñki zʉnekualdal maldazʉñgakaxaldixa janaktuwi gaxamaldamak ne saldiñga saná nahauxa atuaka. ");
INSERT INTO kog_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ejañki saldiñga saná nahauxa namak majañguazhéñ zhinik aldunaldi tuañ ketsekldekuek, me maldé katuñshi, mu kagisekualdixa. Eja na, mijí kuíbuldu Isayél akldé zʉñzé zʉnakuakshaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kauwijí somá shalda ekí aldukatshakna, ajabakueja “¡sakí shi somá shalda ekí guak!” na ajañguá. ");
INSERT INTO kog_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Guñgueniki Simehóñja Jateja zeñ kajañguakue akshishiñguenik somá tshabak ekí akbeyá: “Jatejañki jejié mijí somák zhinik na, nasʉñ Isayélkue ekí zʉñkatshaldixa janaktune: Matshuwi nekueki kekualdaldixa, matshuwi nekueki kekualdazháldixa. Aldéñki Jate nugeñka jiúñgulda mauldeyakue ne zʉnatuñshatshak jiaga, matshuwi nekuejañki ‘naldagálde ne’ ajañgui, iyapanazháldixa. ");
INSERT INTO kog_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Akna, kauwizhéñ aldunaxa sakí ajañguatuka saldiñgaja atualdiamak mu ketsekualdixa nzha. Guatshakna mañki misukuá sha mixakuaté matuatshak matshuwi aldunaxa mikzeshi, atemajañ mitshanaldixa nakldá” na ajabak akbeyá. ");
INSERT INTO kog_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Atshaga na ezua munzhi weezhu, Jatetshi múldigaba naldiñga zʉxaitshixa, Ana jiaga exaga na izhoxá. Eñki Asél ldaxe, ajateki Penuél. Nalgué na, awawaga numa neguenik kugua kagi me asewá agapakualguenik ishuizhá guane ");
INSERT INTO kog_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","nalguakna, sameyaga 84 kagi itsegatuka. Aldéñki Jate axazakuageñka, e za axazguashi niuwisʉñ, sesʉñ jiaga eñka za izhuka. Matshuwi juizha Jate muldetua axazguaxaldiamake záaki izhuka. ");
INSERT INTO kog_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nalgué Simehóñja somá tshabakuek akbeyatogueñki kauwizhesañ nagueni, aldéñ jiaga ai somá shalda “zeñ nzhakldék” Jatek akbeyá. Guñgueniki saldiñga “Jateja ají kuíbuldu Jeldusaldéñ ikualdal ezua zʉñgakaxaldixaga shakldá” jañgui, jiaktuñkakuek somá shalda kakbeyaldá. ");
INSERT INTO kog_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Guñgueni Jateja nauwibama Muesék guiyaba kaxabajaneja guagamak ajanashatogueniki somátshi ajabakue mokue Galdildeyaxa, kauwijí kuíbuldu Nasaldéxa saldi aldé. ");
INSERT INTO kog_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Exa ashekualgueñki, somáki kamakue, muldetua ishkué guildeshi na, Saldiñga netshi Jateja zeñ jañguiñga na guildegatoxá. ");
INSERT INTO kog_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Guatshak juldiú sanákueki san kagixa guiyaba atuwi ashekualgueñka zhinik Jateja kakzʉxaitshanéñ ldiuwañ be kagisexaldiamak kagi akldañkajauxa Jeldusaldéñka izhajuizhaldeka. Nalguakna ai ldiuwañ zegauxa Jesútshi ajabakueki aldeñkakue na naldá. ");
INSERT INTO kog_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ai sanákuejañki kauwijí sukua 12 kagi itsegatshake ai ldiuwañ kasak izhajuizhaldexal exa awaldeyamakga na, Jesú auxa itsegatshak exa awaldé. ");
INSERT INTO kog_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Guane nalgué, exa izhajuizhaldeshi saldinguake mokue ajabakue kauwikuíbulduxa aldeyapanatshake kakldegakíñga, Jesúki eñkaga keyabá. ");
INSERT INTO kog_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Anuñka ishkapa aldeyakna “nauwiskuáki zʉñsajañga kágubakue juizhi ne guxá tiuwi” ajañgui atiuwiñ na aldeyá. Ekí aldeñgueni asanákue, apebukue neyatogueñka aldiyatshak jiaga ");
INSERT INTO kog_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","kakzaldazhá guakna jiak, mokue Jeldusaldéñkaga aldiyal na aldeyá. ");
INSERT INTO kog_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Maikldiuwi aldiyatshake, juwí Jate axazakuageñkaki kakzaldatshake Jesúki guiyaba shizhixakue kenañ izhoshi na, guiyaba akuagatshak muldetua nukshi, izukshi ité atú. ");
INSERT INTO kog_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ekí izukaté aldukatshakna, saldiñgaja “¡sakí nakua sukue nuxa ne ekí ishkuéñ zhinik guiyaba muldetua nukshi, yokuaka ne!” na ajañguá. ");
INSERT INTO kog_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ekí noguéñ ajatekueja kakzalguake, “¡sakí shi ekí atshí!” ajañgui na ajabaja: —Nasukuá, mijate nañki mijaniñgaba maldiyá kaldogatshak, ¿jinak ekí zʉñkatshamalde sha? ");
INSERT INTO kog_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Guñguake kakiyó: —¿Guatshake jinak shi amake naldiyabinók? ¿Naski Najate axazakuageñka izhogakue nagatsé miñsʉ́ñ ne? ");
INSERT INTO kog_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ekí kakbeyatshak, sakí guashi kakbeñká kagajienazhá. ");
INSERT INTO kog_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Guñgueniki mokue ajabakue na kauwijí kuíbuldu Nasaldéxa aldeyatshak, ajabakueja atshakue akbeyauxa amak za kaxatshixa na naldá. Guatshakna ajabajañki asukuá shalda ni ji akjuizhanáaki, ai za jañguiñgaba na guatoxá. ");
INSERT INTO kog_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Guatshake Jesúki guildegatogatshak, aldunak jiaga ishkué guildegatoxakna Saldiñga netshi Jateja, kágubakueja tuwi jiaga janshibé izhuka na atuwá. ");
INSERT INTO kog_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Guñguenik anuuñka zegatshake kagi Aldumaxa zalda sáñkalda akldé akzeki Tibeldiu axezhuka sáñkaldaldek guñgueni au 15 kagi izhogatogueñga na, sáñkalda aguáñ akzekueki ekí axezhuka itenekue: Ezuañki Ponsiu Pildatu, aiki Juldeyaxa zalda sáñkalda. Ezuañki Eldode, aiki Galdildeyaxa zalda sáñkalda, aldani Pildipiki Ituldeyaxa, Taldakoniaxa zalda sáñkalda. Ezuañki Aldisania, aiki Abildiniaxa zalda sáñkalda na naldá. ");
INSERT INTO kog_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ai sáñkaldakue izhogatoguéñ, Jatek múldigaba agaskaitshixa akldé akzekueki Anás, ezuañki Kaipás axezhukakue na izhoxá. Atshaga na Juañ, Sakaldiyatshi asukuáki zʉk zeñka izhogatoguéñ, Jateja ají múldigaba guaxaldiamak ixauldá. ");
INSERT INTO kog_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Guñguakna nina Juldáñ xezha eñgui baxe mizhiji na, aldukal axaldakldekue kakbeyatoguamakga ekí kakbeyá: “Maiñ sha miyatshixakue majiñga maja xaldeki Jatek agakualdinakue miñgatsé. Amak atshamine mimawatualdiamak nik ajaugakue. Ekíki Jateja sha atshamine miñkabetaldiamak.” ");
INSERT INTO kog_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ekí shizhiyatshakna mauzeñga Jatetshi múldigaba naldiñga zʉxaitshixa Isaiyaja ekí kaltak guashi sezhekldamakbe zek: “Ezua sigí zʉk zeñka izhoshi na, aldukal axaldakldekue ekí jaldáñ kaxaldexaldixa: ‘Saldiñga netshi Sáñkalda naki miñkaldashi guapanakna, jian naxaldiamak jiúñgulda siyaxagauwakuamakbe aldunaxa janazhiktú guwíñ. ");
INSERT INTO kog_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ekí atshiji na, ezua sáñkalda naxaldiéñ jiúñgulda po po ze axaxasheñgui, suksu ze akiyaxeji, me me zeñ jian axaxazakuí, tukui tukui ze jian axaxazakuamakbé, ai nagatuka muldetua mipanaldiamak mimijí aldunaxa jana akizhiktuwíñ. ");
INSERT INTO kog_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Amak nagatshakna káguba katshekuauxak Jateja ezua zʉnekualdal zʉñgakaxane tuakualdixa nakldá’” ekí kalta gauwanane. ");
INSERT INTO kog_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ekí Juañja Jatetshi múldigaba kakbeyatoguéñ, matshuwi kágubakue nik kajaukshaxañ aldagatshakna ekí kaxaldék: —Takbi sha ishkazguamak, maiñ shane mijañguxa ne jiaga, janshizhe minekue ga abeldashi mizhuka. Ne ¿sakí zhinik shi naldagálde nuxa sha atshamine mashamine ga abamildagéñ me, Jateja kaxañ atemajañ guiyaba mimatuñshazháldixa miñnék? ");
INSERT INTO kog_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Akze, nik mimajaukshakue miñnegake ekí atshakue: Sha atshá namak giemi majiñga maja, Jatek agakualdimine awatualdiamak jian atshakue miñgatsé ni mitú. Ne axaldáñgaba ekí ajañgushaminaka itshanagába: “Saldiñga netshi Jateja nauwibama Abaldahám ají naldaldixa izhgakuxanane nakna, ai shtukuaga kaldakna ajíkue zʉnepanaldixa nakldá.” Minegatshak Jate bualga nuxaga ai za auxabé tuazhé. Jinake ekí miñmenaka naldakí. Aldéñki jejié jagikue jiaga ai shtukuakue ixagabakuaka nak. ");
INSERT INTO kog_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kaigaga mieldekueki sha ajanashá abajiñga abajazháldi, jian atshaldiamak Jatek axakualdinakí naldiake, aldéñ naldiñga guiyaba katuñshaldixa za abá guane. Aiki kaldi zhenazhéki abeñgua akualdiniki ayoxa akuamakbé, Jateja guiyaba atemajañ kaxañ katuñshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ekí aldukatshakna káguba nakldekueja agalduká: —Guake, sha atshá majiñga maja guáñkalde zʉnawatualdiamake ¿mielde shi atshakue zʉñgatsá? ");
INSERT INTO kog_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Guake kakiyó: —Mieldeke zhakuá mozhua miñkaldaldaldiák axaldaldagáldek ezua akáu miñgualdí. Ekíga na, mieldeke gakue miñkaldaldaldiake gakue agajueshkak akáu miñgualdí. ");
INSERT INTO kog_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Guatshake sáñkaldak akiyalzabine zhiksuikakue nik kajaukshaldiamak axaldakldekueja jiaga ekíga agalduká: —Shi maldazʉñkaldixa, ¿mielde shi atshakue zʉñgatsá? ");
INSERT INTO kog_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Guake kakiyó: —Mitsá me nashikueja sáñkaldak akilzabiyakue kagatsahauxabe kakshishakue ne, zʉxaita shishagába. ");
INSERT INTO kog_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Guatshake suldáukueja jiaga ekíga agalduká: —Guake, nasʉñ jiaga ¿mielde shi atshakue zʉñgatsá? Guake kakiyó: —Maiñki nashikue “jigaba nagegakí minaldiake sha mimakualdikue nakldá” axaldegagába. Ekíga na, ezua agatsaldazhé “agatsé nzha” naldagálde izhguagagába. Ekí ne, mimijí jiba shalda mitsá miñgasabiyake, ai za auxabé ne mijañgualdí. ");
INSERT INTO kog_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Guatshak káguba azaldukatoxekuejañki Jateja ezua zʉnekualdaldiamak zʉñgakaxaldixa guakldane “mijá nagakuéñ” ajañgui, jiyagatuwiñgaba akuatoguakna, Juañ atuatshak “¿eñki aiga naldaka neki?” izhgalduká. ");
INSERT INTO kog_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Guakna Juañjañki ekí kakbeyá: “Naski nik nuxa mimajaukshikugé. Naldatshak nalduxañ ezua zʉnekualdaldiamak nagatukaki nazhakaldak akzé nak, naski ni atabal nuxaki nakzaldagálde. E zʉnake Jatetshi Aldunakga mimajaukshi na, ai Alduna maiñldi auxaga miñkaldaldaldiamak miñgexaldixa. Atshaga na guksék jiaga mimajaukshiji jana mimajaukshatshakna, gukséja jika janshi axazguamak aldunaldi janshi miñkazgualdixa. ");
INSERT INTO kog_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aldéñki janshizhekueki sha atshixakuek zhinik kagajuekualdixa za abá guane. Aiki aldó ajubak zhinik axajuekuamakbe kakualdixa. Aldó gataki muldetua jikak akuasha abegamakbé, aldéñki janshizhekueki askuiñgaba kabexaldixa. Aldó ajubaki egaba ayoxa akuamakbé na, aldéñki sha atshixakueki guksé sanazhéñka, guiyaba tu za nogakueñka kakaxaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ekí agatsaldi na, matshuwi juizha guiyaba kakbeji, Jateja káguba ikualdal ezua gaxaldixa guaklde naxaldixa shalda muldetua na kakbeyatoxá. ");
INSERT INTO kog_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Guatshak Juañja sáñkalda Eldode guiyaba guxaldiamak “sha atshalga nogakue migatsaldakí ni matú” axaldék. Jinak ekí axaldegazhá. Sha atshatoguamakga atshiji na, akaja giemitshi asewá nane Eldodia izhgakuxane nalguák. ");
INSERT INTO kog_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ekí axaldegatshak míñgaki jiak, akldé sha atshijiñga na, Juañ kalseldi mexal guak na gua. ");
INSERT INTO kog_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Amak Juañ kalseldi abegagá nogueñga aldéñki káguba matshuwi nik kajaukshatogueñga, Duwe Jesú jiaga nik jaukshá. Atshaga na, Duwejañki Ajate axazguagatogueñki alnoba akpezhatshaga, ");
INSERT INTO kog_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jatetshi Aldunaga shamíjañ axagataná. Atshaga na exa zhinik ekí múldigaba guagaté alduká: “Mañki, Nasukuá giemi matshuwi mezhgajañguge, nakldunauxabé mizhuka nakna, zeñ maldakzukuxa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Guatshake Duwe Jesúki anuñka 30 kagi itsegatogatshake Jatetshi jiba axatshaldá. Guatshak kágubakuejañki: “Eñki Jusétshi asukuá shakldá” na ajañguatoxá. Guatshak Juséki Eldítshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eldíki Matáttshi asukuá. Matátki Aldebítshi asukuá. Aldebíki Melkítshi asukuá. Melkíki Janahítshi asukuá. Janahíki Jusétshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Juséki Matatiyatshi asukuá. Matatiyaki Amótshi asukuá. Amóki Nahúmtshi asukuá. Nahúmki Esaldítshi asukuá. Esaldíki Nagáitshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagáiki Mahátshi asukuá. Maháki Matatiyatshi asukuá. Matatiyaki Semétshi asukuá. Seméki Joséktshi asukuá. Josékki Judátshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judáki Jonántshi asukuá. Jonánki Aldesátshi asukuá. Aldesáki Suldubabéltshi asukuá. Suldubabélki Saldatiéltshi asukuá. Saldatiélki Neldítshi asukuá. Neldíki Melkítshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melkíki Adítshi asukuá. Adíki Kosámtshi asukuá. Kosámki Edmadámtshi asukuá. Edmadámki Eltshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Elki Josuétshi asukuá. Josuéki Eldieseltshi asukuá. Eldieselki Joldímtshi asukuá. Joldímki Matáttshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matátki Aldebítshi asukuá. Aldebíki Simehóñtshi asukuá. Simehóñki Judátshi asukuá. Judáki Jusétshi asukuá. Juséki Jonámtshi asukuá. Jonámki Eldiakímtshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eldiakímki Meldeyatshi asukuá. Meldeyaki Menátshi asukuá. Menáki Matatátshi asukuá. Matatáki Natáñtshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natáñki Dabítshi asukuá. Dabíki Isahítshi asukuá. Isahíki Obéttshi asukuá. Obétki Bohóstshi asukuá. Bohóski Sadmóñtshi asukuá. Sadmóñki Nasóñtshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasóñki Aminadáptshi asukuá. Aminadápki Aldámtshi asukuá. Aldámki Adnítshi asukuá. Adníki Esaldóñtshi asukuá. Esaldóñki Paldestshi asukuá. Paldeski Judátshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judáki Jakóptshi asukuá. Jakópki Isáktshi asukuá. Isákki Abaldahámtshi asukuá. Abaldahámki Taldétshi asukuá. Taldéki Nakóltshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakólki Seldúktshi asukuá. Seldúkki Aldagáutshi asukuá. Aldagáuki Peldéktshi asukuá. Peldékki Ebéltshi asukuá. Ebélki Saldátshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Saldáki Kaináñtshi asukuá. Kaináñki Alpaxátshi asukuá. Alpaxáki Semtshi asukuá. Semki Nuwétshi asukuá. Nuwéki Aldaméktshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Aldamékki Matusaldéñtshi asukuá. Matusaldéñki Enóktshi asukuá. Enókki Jaldédtshi asukuá. Jaldédki Maldaldéltshi asukuá. Maldaldélki Kaináñtshi asukuá. ");
INSERT INTO kog_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaináñki Enústshi asukuá. Enúski Settshi asukuá. Setki Adáñtshi asukuá. Adáñ zʉnake Saldiñga netshi Jateja gaune nak ají nzha. ");
INSERT INTO kog_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Duwe Jesúki nik ajaukshiñguenik Jatetshi Alduna agatsauxa axaldaldi nina Juldáñ zhinik neyatshak, ejañga zʉk zeñka neyakue aksaneguamak ne. ");
INSERT INTO kog_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Eniñki 40 ldiuwi izhogueñki, jiséja ijuldukshaka guaji aksaneshi izhó. Anuñka izhogatoguéñ jiaga, Duweki ni ji nauwa ga naldáaki izhoshi na, aldiweki maldija gualdá na gua. ");
INSERT INTO kog_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Guñguakna jiséja ekí axaldék: —Mañki Saldiñga netshi Jatetshi Asukuá giemi maldahamak nake, jejié jagi “gakue nek guwá” axaldék guwá. ");
INSERT INTO kog_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Guakna Duweja akiyó: —Jatetshi múldigabak ekí sezheklde: “Kágubaki gakue za gaji auxabé izhogazháka naldashá.” ");
INSERT INTO kog_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ekí akiyokuñguake, jiséja jai kagik saldiñga kuíbuldu nahauxa ubañga tuñshaldiamak, Duwe guinuexa ibekshiñguenik ");
INSERT INTO kog_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ekí akbeyá: —Saldiñga kuíbuldu tu makuauxa, ji janshagatse axaldekue juizhi, maksanexaldiamak migenaka. Jinake naldakí. Saldiñga nasgaba nagaxenane ne, jiak mieldek agekldana nakzexaldiake agenaka nak. ");
INSERT INTO kog_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Akna amak auxaga migexaldikuamak nuldu naxayoshi, akldé nakzukuakue nuxa migatsé. ");
INSERT INTO kog_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Guñguake Duweja akiyó: —Jatetshi múldigabak ekí sezheklde: “Saldiñga netshi Sáñkalda, Mimijate za na akldé akzamakga akzukui, e za axazauwi miñgualdí.” ");
INSERT INTO kog_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ekí akiyokuñguake, jiséja Duwe kuíbuldu Jeldusaldéñka uldeñgueni juwí Jate axazakuaka bakaldaxa akldé zeñka ibekshiñguenik ekí akbeyá: —Ma namak giemi Saldiñga netshi Jatetshi Asukuá maldahamak nake, mañgabaga tuexa zhinik jiñ akjienwá. ");
INSERT INTO kog_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Jinak ekí mikbeyakí. Jatetshi múldigabake ekí sezheklde nogashá: “Jatejañga aldéñ guaklde uldeñkakue migisaldi guakuak muldetua numañ matuál migakaxaldixa. ");
INSERT INTO kog_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aikuejañki migisaldi guakuak, jikak akzaldi zubushi guamikldegak, ni kasak jiaga jagi makuí guakuak aksuí makuxaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Guake Duweja mokue akiyó: —Naldatshak Najatetshi múldigabak ekí jiaga guashi sezheklde naldashá: “Saldiñga netshi Sáñkalda, Mimijatega ‘¿Aldéñ atshaldixa guaklde atshakldegamak shi na?’ jañgui guashabináldi.” ");
INSERT INTO kog_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Guñguake jiséja Duwe ijuldukshazháka tuñguakna jiak, “mokue atshuakgaba zaldiéñ ijuldukshaldikuamak naxaldikue nzha” jañgui na agajuezhá na gua. ");
INSERT INTO kog_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Guñguake Duwe Jesú mokue Galdildeyaxa neyatshak Jatetshi Aldunaja za na kama ageshi izhuka atuatshakna, émaxe izhukakueja e shalda izhgabejiñgaba na ashekualdá. ");
INSERT INTO kog_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aldéñ émaxe juwí asanákue izhajuizhaldeka nogauxa shi kaxaldiji zhinik na, nukatukakuejañki “¡sakí ekí janshagatsegaba shi zʉñkaldixá!” na akuaxá. ");
INSERT INTO kog_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Guñgueni Duwe Jesú aldéñ guildekldeñka kuíbuldu Nasaldéxa neyatshak, zhiksekuakue ldiuwañ zeguake aldéñki juwí asanákue izhajuizhaldegeñka neyamakga ne. Exaki Jatetshi múldigaba zukuakshaxañ izhgaldaguake, ");
INSERT INTO kog_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ezua kalta makue Jatetshi múldigaba naldiñga zʉxaitshixa Isaiyaja gaunane agaxegatshak, zhiksoñgui ji zukuakshaldixa akzaldatshak ekí zukuakshaldá: ");
INSERT INTO kog_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Saldiñga netshi Sáñkaldatshi Alduna za naksaneshi na, eñki nas nañga ni izhók. Jinake naldakí. Aldéñ naldi jiba axatshaldikuamak nezhgakuxane nak. Aldéñga kágubakue sakí kalkualdaldixa, nashikuek kakbeyal nakaxane. Ekíga na, mieldekueki jiséja ají nashi kakuane, aikueke ‘minabesaldixa nakldá’ kakbeyal nakaxane. Ekíga na, uba isékue uba kekukshal nakaxane. Ekíga na, kakiyasalshi, aguáñ kezhabaji, guiyaba katuñshiji izhukakue kebesanshal nakaxane. ");
INSERT INTO kog_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ekíga na, saldiñgak ekí janshagatse kakbeyal nakaxane: ‘Saldiñga netshi Jate zeñ mimajañgui, minkualdaldiéñ zek na gu.’” ");
INSERT INTO kog_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ekí kaxakzukuakshiñgueni kalta mañguñguenik exa jiba atshixak agegueniki, shi kaxaldialdiamak yaté. Guatshakna exa ashekualguauxa muldetua e za señ atú. ");
INSERT INTO kog_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Guakna ekí kakbeyaldá: —Kaiga ldiuwañ na Jatetshi múldigaba ekí sezhekldane nukabinogeñga amak zek na gu. ");
INSERT INTO kog_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ekí kakbeyatshakna saldiñga aldukatoguekuejañki “eñki janshizhe nzha” izhgabeji na, “¡sakí ekí janshagatsegaba shi zʉñkaldixá!” ajañgui na ekí izhgaldukajá: —¿Jejiéki Jusétshi asukuá nuxa naldazhé shi na? ");
INSERT INTO kog_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ekí izhgaldukaté katuñguakna Duweja kakbeyá: —Kágubakueja akuagamak ekí minakbeyaldixa nakué: “Ma méldiku maldahamak nake, mañgabaga jiaga ilzʉxaitsha guwá. Akna, Kapeldahúmka janshizhe ajanashaté atú guazhámak matshixa maldukañkaldamak, jai mijí kuíbulduk naldi jiaga atshiwá.” ");
INSERT INTO kog_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","”Akze, namak miñmeyaldikue. Ni mielde Jatetshi múldigaba naldiñga zʉxaitshixaga akuíbulduk zaldakueja muldetua axaldukshi, iyapanazhé nakldá. ");
INSERT INTO kog_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Namak ni guakú. Jatetshi múldigaba naldiñga zʉxaitshixa Eldiya izhogué baxañ, maigua kagi muan níxalda zegakí, gakue naldaksáñga ne zegatshake maldija kakuiñgaba ashekuane. Atshaga na jai ají kagi Isayél matshuwi munzhi sigí ishuanekue maldija kakuí ");
INSERT INTO kog_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ashekualgué jiaga, Jateja Eldiya kagaunexal gagazháne. Ne ezua munzhi sigí ishuane, axautshi saná Sidóñka kuíbuldu Saldepta zalda nalgué za na agaunexal gaxane. ");
INSERT INTO kog_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ekibeñga na, Jatetshi múldigaba naldiñga zʉxaitshixa Eldiseyu izhogué baxañ, jai ají kagi Isayél ajuba ikaldunatukakue matshuwi ashekualgué jiaga, ni ezua aikue janshi kaxazguazháne. Ne ezua sigí Namáñ san kagi Sildiaxa zalda nalgué za na janshi axazguane naldashá. ");
INSERT INTO kog_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ekí aldukatshakna, saldiñga ai ajuizhaldegeñka ashekualguekueki zʉxaita kalzauldi, ");
INSERT INTO kog_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ishkaldagueni Duwe iyapanane kakldiñga kuíbulduk agazaxaitshiñgueni, kuíbuldusʉgaxa iyapeñgualdiamak awaldé. ");
INSERT INTO kog_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nalgué jiaga, Duweki egaba kauwikenañga jian zʉxaiti ne na gua. ");
INSERT INTO kog_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Guñgueni Duwe Jesúki Galdildeyaxa kuíbuldu Kapeldahúmka neyatshak, zhigasekué ldiuwañki juwí asanákue izhajuizhaldegeñka shi kaxaldiyaldá. ");
INSERT INTO kog_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ekí Duweki muldetua niuwi axaldé ga agatsaldi shi kaxaldixá aldukatshakna, “¡sakí ekí agatsaldi shi zʉñkaldixá!” na kakldexá. ");
INSERT INTO kog_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Exaga na, ezua sigí jisétshi alduna ijulduneja ekí jaldáñ kaulshá: ");
INSERT INTO kog_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Ma Jesú Nasaldéxa zalda maldé, ¿jinak shi nauwikenáñ izhoxaldá makú? ¿Zʉnakldañkashal nakbalde sha? Naski me maldé maldakué: Mañki janshizhegaba Jate jékaldaxa zaldatshi giemi maldé naldashibaldá. ");
INSERT INTO kog_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Guake Duweja jisétshi alduna ekí axaldék: —Sʉnjá nogwá. Sigík zhinik akzʉxaita makunék. Ekí axaldeguake, jisétshi aldunaja ai sigí kágubakue kenañ peñgui agisalshakí amak izhé. ");
INSERT INTO kog_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ekí zegaté atuatshakna saldiñga exa zhekualguekueja: “¡Sakí shi ekí izheñshí!” ajañgui na ataba atabañ ekí izhgabeyá: —¡Sakí shi ekí múldigaba guak! Ají múldigabaki niuwi axaldé naguana, jisétshi aldunakue jiaga “newa” axaldegatshake amak neñka tiuwi. ");
INSERT INTO kog_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ekí zeguenikna émaxe izhukakueja akldé akldeñga Duwe shalda izhgabejiñgaba na ashekualdapaná. ");
INSERT INTO kog_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Duwe Jesúki izhajuizhaldegeñka zhinik akzʉxaitatshak, Simóñ Péguldu tshuxa ne. Exaki etshi akagiki zʉ́xaitsha guañgua zalda akzeshiñgaba guatoguakna, Duweja iskaitshexañ axakuañnék. ");
INSERT INTO kog_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Guñguakna asták naguenik guañgua zalda “jalde munzhi zhinik iskaita guwá” axaldeguamak iskaitá. Guake ubañga izhgaldagueniki kakauwaldá na gua. ");
INSERT INTO kog_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Guñguenik tuañ zegapanatshake, saldiñga nalda mulbatá akzekakue Duwek akualdák. Guñguake aldéñki egaba ezua, ezua káuxalda kaipá me kakuatshake nuk se kakzukuá. ");
INSERT INTO kog_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Atshaga na, matshuwi káguba jisétshi alduna ijuldunekue jiaga kezheñshá. Ai aldunakue amak neñkáki jaldáñ: “Mañki Saldiñga netshi Jatetshi Asukuá giemi ni maldá” aldeshi aldé. Aikueja Duweki Jateja káguba kekualdal ezua gaxaldixa guakldane, aiga ne kakualdatshakna, Duweja ai shalda ni ji kakuakshakí na naldá. ");
INSERT INTO kog_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Abokualdi muñzegapanatshak, Duweki káguba isʉ́ñ zaldi ne. Guatshak jiaga kágubakueja aldiji, eñka kakzalguake neji guakuak axakuañnék. ");
INSERT INTO kog_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Guakna Duweja ekí kakbeyá: “Saldiñga netshi Jateja káguba janshagatsaldi kaksanexaldixa ne guashi kuíbuldu nauxa neyakue nagatsé. Akze, Najatejañki ekí atshaldikuamak nakaxane nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Akna asaná juldiúkue juwí izhajuizhaldeka nahauxa Duweja Jate shalda shi kaxaldijiñga na mizhatoxá. ");
INSERT INTO kog_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ezua ldiuwañki Duwe Jesú niwa Jenesaldé xezhaxa Jatetshi múldigaba guagatogueñga, kágubakueja aldukaldiamak muldetua zhikyokualdi duwá ashená. ");
INSERT INTO kog_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Guatshakna Duweja exa mozhua kanuwa abatakue tu, pikáu gukakueki zhemá iyajizhal agajienane noguák. ");
INSERT INTO kog_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ekí tuñguakna, Duweki Simóñtshik iyabeguenik ajáugukuik nauwa agajué zeñka uldeyal agakuañnék. Aik izhoshi na, niwa xezhaxa zhekualdekue shi kaxaldiyaldá. ");
INSERT INTO kog_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Auxa shizhiñgueniki ajáugukuik ekí akbeyá: —Akldé agajué, juit zeñka kanuwa uldé xaldeki zhemá pikáu gugexañ aguteya guwá. ");
INSERT INTO kog_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Guakna akiyó: —Duwe, naldiñki sesʉñ pikáu za niyañga mu zʉñzék kakuatshak, ni ezua nuxaki gugazhá guashiñkaldaldá. Naldatshak jiak, ma mokue zhemá aguteyakue maldakbeñkáki ake, amak mixatshaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Guake amak ajanashatshake, zhemá kagitshizbé zalda pikáu matshuuwi akuxá. ");
INSERT INTO kog_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ekí atuatshakna, ezua kanuwaxa izhoxekue kagaunexal nagaxañ jueya, jueya axajanashá. Amak aldaxeni pikáu mozhua kanuwak akuashixaga naki niñ tuasáni zalda na akuashá. ");
INSERT INTO kog_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ekí tuatshakna, Simóñ Péguldujañki Duwek nuldu axayoshi ekí akbeyá: —Nají Sáñkalda, nagajué izhogwá. Naski sha atshikuge naugák mizhesañ ité nogazhánaka nakldá. ");
INSERT INTO kog_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jinake ekí akbeyazhá. Aldéñ, kanuwaxa izhoxekue na: “¡Sakí shi ekí pikáu zʉnakukshí!” kakldexák. ");
INSERT INTO kog_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","E na jibatshixakueki Zebedeyutshi asukuákue Santiaku, Juañ naldekueja jiaga ekíga kakldék. Guñguake Duweja Simóñ Pégulduk ekí akbeyá: —Zhe mikzegagába. Mañki pikáu niji za mizhuka ne, kaiga zhiniki káguba nagapa aldeyaldixakue maldiyapanaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Guñguake kanuwa niwa xezhaxa awaldeñgueni kauwijí jibaki, jikakue juizhi nuk abashiñgueniki Duwe Jesúk axapa aldeyaldá na akuá. ");
INSERT INTO kog_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ezua ldiuwañ Duwe Jesú ezua kuíbulduxa izhogatogueñki, ezua sigí agatsauxa ajuba ikaldunatuka nak. Ejañki Duwe tuatshak waxam pani ekí agakuañnék: —Nají Sáñkalda, ma janshi naxazgundana mikzék guashiñki, amak naxatsha guamildaká. ");
INSERT INTO kog_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Guake Duweja káuxalda ipañgui akbeyá: —Janshi mixazgundana nzhakzék. Akna, kaigaga janshi migatsék shi gui. Axaldegatshaga na amak janshagatsék. ");
INSERT INTO kog_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Guakna Duweja ekí aksanék: —Kaiga janshi mixazguge ni mek akbeyagábaki, egaba janshi migatsék guane matuexañ jian Jatek múldigaba agaskaitshixa nugeñka maldeyaldí. Exaki nauwibama Mueséja mielde ajuba ikaldunatuka janshi agatsekldejañki, ji Jatek agegakue guagamak ageshi makualdí. Ekíki janshi migatsék guane mawatualdiamak. ");
INSERT INTO kog_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ekí akbeyatshak jiaga, Duwe sakí janshagatsegaba atshixá shaldaki akldé akldeñga izhgabejiñgaba na ashekualdá. Ai zhinik na, Duweja shizhiyatuka aldukaldiamak, mulbatá kalzʉxaitshaldiamak káguba matshuwi na axaldaxá. ");
INSERT INTO kog_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Guatshak jiaga, Duweki Ajate axazguaxaldiamak káguba zhekualdazháldi ahezua neyamakga neji na izhoxá. ");
INSERT INTO kog_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ezua ldiuwañ Duwe Jesú shizhiyatoguéñ, paldiseyukue, juldiútshi guiyaba shizhixakue juizhi aldukaldiamak iteté na aldoxá. Aikueki Galdildeyaxa kuíbuldu nahauxa, Juldeyaxa kuíbuldu nahauxa, kuíbuldu Jeldusaldéñka zaldakue juizhi aldaklde. Ekí ashekualgueñga, Jate Saldiñga netshi Sáñkaldajañga Asukuá Duwek mulbatá akzekakue iskaitshaldiamak kama agenamak atú. ");
INSERT INTO kog_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Amak shizhiyatogueñga na, ezua sigí abuá axazauwaksánane ixabakak akshañga apebukueja awaldák. Eñki juldiñga Duwe stak ashaldixa ajañgui awaldaklde nalgué, ");
INSERT INTO kog_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Duwe nugeñkaki kágubakue zhikyokualdi kas ashekualguakna, akualdeyazháka atú. Ekí atuñguake juwí bakaldaxa awalditshigueniki, juwí nauwa agapoñguñguenik ai ga sigíki ixabakak akshañga shibuldik káguba kenañ Duwe stakga agajieñguá. ");
INSERT INTO kog_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ekueja Duwejañki se akzukualdixa alduna iyashiji akualdaklde katuakna, abuá axazauwaksánanek ekí akbeyá: —Napebu, sha matshixa nuk mixabetá ni gukú. ");
INSERT INTO kog_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ekí aldukatshakna guiyaba shizhixakue, paldiseyukueja ekí ajañgualdá: “¿Aldéñki me ne itshanká? ¿Eñki me nak Saldiñga netshi Jate aguáñ izhbashi mual negaka itshanká? Akze, ezuañgaba Saldiñga netshi Jateja za na sha atshane axabetaka naldashá.” ");
INSERT INTO kog_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ekí ajañguatuka Duwejañki katuñguakna ekí kaklduká: —¿Jinak shi ekí agatsaldi mijañgú? ");
INSERT INTO kog_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Guake, ¿mielde shi aguáñ jibañ akzaldi abuá axazauwaksánanek akbenaka na? ¿“Sha matshixa nuk mixabetá ni gukú” azhi “izhgaté xaldeki newa” shi akbenaka na? ");
INSERT INTO kog_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ne naski, Jatetshi Asukuága ixagabaldeklduge, jai kagik sha atshixakue axabetaldikuamak niuwi naxaldé mimatuñshaldikue. Guaguenik abuá axazauwaksánane ekí axaldék: —Ekí mikbeyaldikue: Izhgaté, mixabaka guxa xaldeki mijuldi newa. ");
INSERT INTO kog_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ekí akbeyatshaga na, ashekualgué kenañ amak izhgaldaguenik ixabaka gugueniki ajuldi neñkáki, Jate za akldé akzamakga akzukui ne. ");
INSERT INTO kog_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Guatshakna saldiñga tuatoxekuejañki “¡sakí shi ekí janshi akzukú!” ajañgui na, Jate za akldé akzamakga agazukui ekí akuák: —¡Kaigaki janshizhe ajanashaté tu guañkáaldamak ni katú! ");
INSERT INTO kog_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Duwe Jesú exa zhinik neyatogueñki, ezua sigí Aldebí axezhuka tu. Eñki sáñkaldak akiyalzabine zhiksuika naldakna agasabiyaldiéñ ité tuñguake ekí axaldék: —Shi maldagitiyaldixa nak nagapa kuizaldi. ");
INSERT INTO kog_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ekí axaldeguake amak izhgaté, ají jiba jika juizhi nuk majañgueniki agapa neyaldá. ");
INSERT INTO kog_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Guñguenik Aldebíjañki Duwe ajuxa abuzaldiamak janaktú. Duweja exa neyatshak kágubakue matshuwi, sáñkaldak akiyalzabine zhiksuikakue nañga asaldá. ");
INSERT INTO kog_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ekí ashekualdi asaté atuatshakna paldiseyukueja, kauwizhéñ nañga agatsé guiyaba shizhixakuejañki, Duweja shaxaldixakuek ekí axaldék: —¿Sakí zhinik shi sha atshixakue na sáñkaldak akiyalzabine zhiksuikakue juizhi zabinók? ");
INSERT INTO kog_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ekí nukajakna, Duweja kakiyó: —Se nekueki méldiku kagajuezhazhé. Akze, mulbatá akzekakue guana, méldiku kagajueshka naldashá. ");
INSERT INTO kog_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ekibeñga na, naski mieldekue axaldáñgaba “jian sha izhokú” itshankakue Jatek axakualdinaldiamak kaldiyal nagazhánuge. Ekí ne, sha atshixakue niñkauwañki sha ajanashixa abajiñga abaja xaldeki Jatek axakualdinaldiamak kaldiyal naklduge ni mitú. ");
INSERT INTO kog_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Guñgueniki Duwek ekí agabeyá: —Guatshak Juañ nik majaukshakueja shaxaldixakue, paldiseyukueja shaxaldixakue juizhiñki anuñka juizhá Jate matshuwi axazguashi na, asáaki ashekue. Ne ma shi maxaldixakue zʉnake ekí asáaki izhogagábaki, asál, atuxal za nukakue. ");
INSERT INTO kog_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Guñguake Duweja ezua ajanashakldegéñ zhinik ekí kakiyó: —Nauwisaná sigí numa nexaldixa naldieñki matshuwi abuzatiakue akbeñka. Gualdinik aldéñ kagapañga nogeñga ¿sakí shi abuzál nakldekue “zagába nogwíñ” kakbeminaka na? ");
INSERT INTO kog_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Guanaldixa sigí numa neklde ishkapañgui awaldeyaldiéñ ldiuwañ zegatshak zʉnake apebukueki itshani, asáaki aldoxaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ekí kakbeñguenik jiak, ekí kakbeyá: —Ni meja zhakuá abisa ne, nauwa ibeñguá xaldeki duebak agapa guazhé. Azhi ekí guatshake, abisa jiaga nusakuá guaka. Guatshak abisak ibeñguane jiaga zhakuá duebak agukuagazháka naldashá. ");
INSERT INTO kog_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ekibeñga na, ni meja alditsha tanagáldega moñkú duebak kuashazhé. Azhi ekí kuashaldiake tanatshak moñkú dueba kualbenatshake, alditsha jiaga nuk zuldatshake, mozhuañga itshuana guaka naldashá. ");
INSERT INTO kog_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ekí atshaka nakna, alditsha tanagáldega moñkú abisak za kuashakue naldashá. ");
INSERT INTO kog_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Guatshak ji za tuxa shitiya guamalde ne, axautshi mikldunasé. Jinake naldakí. Ji za matuka naldaldiake, ai za akldé we mikzukuxa nak —na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ezua izhgasekué ldiuwañ zalguéñ, Duwe Jesú tek zʉxaitatoguéñ, aldéñ shaxaldixakuejañki eñ gakue nauwa akuguenik ajuba iyatuldi, iyatuldi axá. ");
INSERT INTO kog_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ekí katuatshakna, paldiseyukueja ekí kaxaldék: —Nauwisanátshi guiyabajañki izhgasekué ldiuwañki ni nauwa jiba atshasé guaka ne, maiñki ¿jinak shi atshasé jiaga ekí atshabinók? ");
INSERT INTO kog_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Guake Duweja kakiyó: —¿Nauwibama Dabí ezua ldiuwañ apebukue juizhi maldija kakualdá guñguake sakí atshane sezheklde tuabíne sha? ");
INSERT INTO kog_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Guiyabaja Jatek pañ agaxeneki aldéñ múldigaba agaskaitshixakueja za gaka sezheklde nalgué jiaga, nauwibama Dabí Jate axazakuagaldi juldunguenik, ai pañ gugueniki gatshak, apebukuek jiaga kakaune. ");
INSERT INTO kog_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ne naski Jatetshi Asukuága ixagabaldeklduge naugák niuwi ge guashi naxaldéñ na, izhgasekué ldiuwañ ajanashakuamak ajanashaka niuwi genaka nakldá —na kaxaldexá. ");
INSERT INTO kog_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mokue ezua izhgasekué ldiuwañ Duwe Jesúki juwí asanákue izhajuizhaldegeñka shizhiyal juldunatshake, ezua sigí káuxalda jibatshaldi ixanane ité tu. ");
INSERT INTO kog_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Exa na, guiyaba shizhixakue, paldiseyukue juizhi Duweki atshasé atshane izhakuaxaldixa aldiyatoshi, “izhgasekué ldiuwañ jiaga ai sigí se akzukuá gualdí” ajañgui na, Duwe za atuaté na aldoxá. ");
INSERT INTO kog_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ne Duwejañki kakldegatuka jiaga katuakna, sigí káuxalda ixananek ekí akbeyá: —Izhgaté xaldeki saldiñga matuakldegéñ axaté guwá. Axaldeguamak izhgaldaguake ");
INSERT INTO kog_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Duweja exa zhekualguekuek: —Ekí miñnukaldikue: ¿Nauwijí guiyabajañki kizhiksekué ldiuwañki janshizhe atshakue azhi sha atshakue zʉñmeñka shi na? ¿Ai ldiuwañki ezua shuigaté nuka shuigazháldiamak yo guakue, azhi yo guagábaki egaba tu me guakue zʉñmeñka shi na? ");
INSERT INTO kog_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ekí kakldukañguenik ashekualdauxa ezua, ezua katuñgueni sigík ekí axaldék: —Káuxalda mixanane yu atshiwá. Amak atshatshaga na, auxaga janshagatsék. ");
INSERT INTO kog_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Guatshakna, guiyaba shizhixakue, paldiseyukueki nusá kakzeshiñgaba na, sakí agatsaldi Duwe Jesú sha akualdixa izhgabeyaldá na akuapaná. ");
INSERT INTO kog_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Atshak bual Duwe Jesú Jate axazguaxal gaxa akshá zeñka nitshiguenik, sesʉñ axazguashiñga muetsék. ");
INSERT INTO kog_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Muñzegatshake agapa neñkakue axaldagakue kakbeñgueni 12 na kezhgakuxá. Aikueki aldéñ naldiñga shaxaldiyaldinik ají múldigaba guaxal kakaxaldixakue na ekí axezhukakue kezhgakuxá: ");
INSERT INTO kog_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ezuañki Simóñ nalgué aldéñki Péguldu axetene. Ezuañki Andaldé, Simóñtshi aldani, ezuañki Santiaku, ezuañki Juañ, ezuañki Pildipi, ezuañki Baltoldomé, ");
INSERT INTO kog_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ezuañki Mateyu, ezuañki Tumás, ezuañki Santiaku, eñki Alpeyutshi asukuá. Ezuañki Simóñ, eñki axautshi saná kauwijí kagik sanekakue akzʉxaitshaldiamak niji izhuka. ");
INSERT INTO kog_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ezuañki Juda, eñki axautshi Santiakutshi asukuá. Ezuañki Juda Iskaldiute, eja na aldiweki Duwe Jesú gexaldixa na naldá. ");
INSERT INTO kog_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ekí kezhgakuguenik, Duwe Jesúja ekue nañga guiyaxa zeñka agataná. Exa aldéñ agapa neñkakue matshuuwi ajuizhaldék. Ekíga na, matshuwi nekue saldiñga Juldeya baxe zaldakue, eñkaga kuíbuldu Jeldusaldéñ zaldakue, mozhua kuíbuldu Tildu, Sidóñ níbuni xezhaxa zaldakue juizhi na ekí ajuizhaldeklde ashekualdá. ");
INSERT INTO kog_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ekueki Duweja shizhixa axaldukal, mulbatá kalzʉxaitshaldiamak axaldaklde. Atshak jisétshi alduna ijuldunekueki se kakzukui nuk kezheñshá. ");
INSERT INTO kog_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ekíga na, Duweki kama axaldéñ zhinik na, mulbatá kakzekakue nalguauxa se kakzukuane, nalguakna saldiñgaja se kakzukualdiamak Duwe ajugundana na kakzexá. ");
INSERT INTO kog_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Guatshak Duwe Jesúja agapa neñkakue katuaté noshi ekí shi kaxaldiyaldá: “Mieldeke niuwabak, aldunaxa ji miñgajuezhauxa miñkaldaldazhé miñnekake zeñ minaldaldixa. Jinake naldakí. Jatejañki zeñ mimajañgui, miñsanexaldixa nak. ");
INSERT INTO kog_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mieldeke kaiga ldiuwañki maldi mimakuí mizhekueke, zeñ minaldaldixa. Jinake naldakí. Jatejañki auxabé miñzukualdixa nak. Mieldeke mauwi guabinukake zeñ minaldaldixa. Jinake naldakí. Aldiweki Jate zeñ miñzukui mishimaldixa nak. ");
INSERT INTO kog_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ekíga na mieldeke nas, Jatetshi Asukuága ixagabaldeklduge namak najañgui, nepanamine shalda nuxa axautshikuek kaguldijiñgaba, mimaxajuekui, nalda miñkakuashi, aguáñ mimezhabashi mimakuxake zeñ minaldaldixa. ");
INSERT INTO kog_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","”Mitsakgaba ekí mimakuaká shalda egaba zeñ zalda miñzekaga zʉ́xaita zeñ itshani miñgualdí. Jinake naldakí. Ekí mimakuxá shaldaki jékaldaxa Jateja guagasá janshizhe miñkatshaldixa nak. Akze, ekíga guana, sha mimakuxakuetshi abamakueja Jatetshi múldigaba naldiñga zʉxaitshixakue sha kakuanane nakldá. ");
INSERT INTO kog_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","”Ekí ne niñkauwañki kabiakue ¡wau wau wau sakí guiyaba mitualdixa ne! Jinake naldakí. Janshizhe mipanaldiauxa au ipana guamine nak. ");
INSERT INTO kog_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","”Ekíga na, mieldeke jai kagikga gakue ni ji jue naldakí auxaga miñkaldekueke ¡wau wau wau sakí guiyaba mitualdixa ne! Jinake naldakí. Aldiweki jue miñzeshi za mizhoxaldixa nak. ”Ekíga na, mieldeke kaigaki shimiñgaba, zeñ miñzeshi za mizhekueke ¡wau wau wau sakí guiyaba mitualdixa ne! Jinake naldakí. Aldiweki matshuwi itshani, mauwá za minoxaldixa nak. ");
INSERT INTO kog_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","”Ekíga na, mieldeke saldiñgaja ‘janshizhe nibaldá’ mimakuakakueke ¡wau wau wau sakí guiyaba mitualdixa ne! Jinake ekí miñmeyakí. Ekuetshi abamakueja ekíga ‘Jatetshi múldigaba naldiñga zʉxaitshikuge nzhakú’ naldagálde nuxa nekakue janshizhekue ne katuñka nane nak. ");
INSERT INTO kog_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","”Naldukabinukakuañ ekí miñmeyaldikue. Miyaguldiñkakue maiñ zhiniki kezhgajañgui miñgualdí. Azhi nusá miñguankakue jiaga maiñ zhiniki janshizhe za kaxatshiji miñgualdí. ");
INSERT INTO kog_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mieldeke ‘agisa guakuéñ’ minjankakue jiaga maiñ zhiniki zeñ kajañgui miñgualdí. Azhi sha mimakuxakue jiaga maiñ zhiniki Jateja kagaunexaldiamak akshishi miñgualdí. ");
INSERT INTO kog_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mieldeki waxa miñkabuxaldiák, ataba jiaga miñkabugexañ tuñshi miñgualdí. Ekíga na, ezua zhakuá minatushexaldiake, maiñ zhiniki ‘nazikugasé nzha’ negagábaki ‘egaba akldé shuldejí’ mijañgualdí. ");
INSERT INTO kog_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mieldejañki jika miñshishaldiake amak akauwakue. Azhi mieldejañki jigaba mintushexaldiake, miñgishkualdikshakue axaldexabináldi. ");
INSERT INTO kog_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Maiñ axaldáñ mitsabé mimakundana miñzeka nake, ake, axautshi jiaga ekíga miñgualdí. ");
INSERT INTO kog_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","”Maiñ mimezhgajañguxakue za mizhgajañgualdiák, sha atshixakue ajañguamakga nuxa miyajañgualdixa. Akna ¿sakí shi ekí atshamine shalda nuxa Jateja akzé atshamine mimatualdixa na? ");
INSERT INTO kog_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ekíga na, mielde janshizhe miñkatshixakue za janshizhe miyaxatshaldiák, sha atshixakue atshamakga nuxa miyatshaldixa. Akna ¿sakí shi ekí atshamine shalda nuxa Jateja akzé atshamine mimatualdixa na? ");
INSERT INTO kog_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ekíga na, mieldek jigaba muashalda miñguatshak auxaga miñkiyushakak za miyakwashaldiák, aiki sha atshixakueja izhgawashamakga nuxa mimuashaldixa. Akna ¿sakí shi ai zhinik me Jateja akzé atshamine mimatualdixa na? ");
INSERT INTO kog_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","”Naldatshak maiñ zʉnake miyaguldiñkakue kezhgajañgui, janshizhe kaxatshakue miñgatsé. Jigaba muashalda miñguatshak, ai shakuaki ‘ipanaldikue nak’ jañguagába, egaba muashakue miñgatsé. Ekí miyatshaldiakna Jateja atemajañ zʉ́xaita janshizhe miñkatshaldixa. Ekí miyatshaldiakna Saldiñga netshi Jate akaldak akzetshi sukuakue giemi miné minaldaldixa. Jinake naldakí. Nauwijateki sha atshixakue, aldéñ ‘zeñ nzhakldék’ akbeyazhékue jiaga juañ zaldaba za kaxatshixa nak. ");
INSERT INTO kog_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Akna Nauwijate, Saldiñga netshi Jatejañga, kágubakue guañ kajañgui kaxatshamakga, maiñ jiaga ekíga guañ kajañgui mizhekualdaldí. ");
INSERT INTO kog_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","”Maiñ axautshikue agatsé axezhaxabináldi. Ekíki Saldiñga netshi Jateja zhinik ekíga miñgatsé ne mimatuwi axanibindakldék. Ekíga na, axautshikue ‘guiyaba tuakue kagatsaldi ne tiuwi’ axakezhaxabináldi. Ekí minaldiake, Jateja zhinik ekíga miñgatsé mimakuashi axamindagazháldixa. Naldatshak káguba sakí sha mimakuane zʉnake egaba kaxabeta miñgualdí. Ekí miñgualdiake Jateja sha axatshamine ekíga miñkabetaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Maiñ axautshikue akáu miñgualdiák, ake, Jateja zhinik miñkauwaldixa. Amak miñkauwatshak jika kuashixak neñsha, neñsha tiñ, tiñ dañ miñkauwaldixa. Akze, maiñ mitsá guaja me mishkauwaldiake, ake, auxabeñga guaja me miñgaxauwaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ekí kakbeyatoguenik ezua ajanashakldegéñ zhinik shi kaxaldiyaldá: “Ezua uba iséja ajanameñga uba isé ¿janshibé shi jiúñguldak uldeyaka na? ¿Azhi amak uldenake mozhuañga nusa zeñ kapenazháka sha? ");
INSERT INTO kog_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","”Ni mielde shitixaga nuxa aldéñ shaxaldixa zhakaldak akzé naldazhé. Ne ai shitixaja shaxaldiyanamak shitiji, auxa shitiyatshake ají shizhixa janañga naldaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","”¿Sakí zhinik shi axautshi ubak zubagi nóñgutse nuxa ijulduneki señ me tuminaka, jiak naldatshak maiñ axaldáñ niñkauwañki kaldi wézhilduka ubak minjuldune tuazháminaka na? ");
INSERT INTO kog_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ekibeñga na, sha atshamine axaldáñ izhgatuakí minuka jiaga, ¿sakí zhinik shi ezua aguáñ sha atshane ‘gaja, sha matshixa mabashaldiamak nas miksanekldaka nakldá’ axaldekbildaka na? Maiñki Jatek amak miyaxatshixa ga abeldashi mizhekueke axáñ misha axaldáñ matshuwi sha miyatshixa masha xaldek na ezua mimizhaguáñ sha atshixa sha atshá mashaldiamak aksanekbinaka naldaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Guñgueni ekí jiaga kakbeyá: “Kaldi janshagatsejañki kalwé nusagatse zheñguazhé. Ekibeñga na jiak, kaldi janshagatsaldagáldejañki kalwé janshagatse zheñguazhé. ");
INSERT INTO kog_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Akze, kaldi zhenéñ zhinik me, ji xalde ne zʉnatuñshixa. Ai zhinik na, zaldalduk kalwé gakue kuiyasé naldashá. ");
INSERT INTO kog_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ekibeñga na, káguba janshizheki aldunaxa janshizhegaba za akldeka naldaldiake, amak janshizhegaba atshiji, zukuaka naldaldixa. Ekíga na, káguba shaneki aldunaxa nusagatsegaba za akldeka naldaldiake, amak shanegaba atshiji, zukuaka naldaldixa. Jinake naldakí. Aldunaxa sakí akldeka, sakí itshanka naldaldiake, aiga guana múldigabak zukuaxaldixa nak.” ");
INSERT INTO kog_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Guñgueni ekí kakbeyá: “Maiñki ‘nají Sañkaldá’ minaxaldegatshak, ¿jinak shi miñsanekugamak naxatshakí miná? ");
INSERT INTO kog_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ne mieldekueki naxaldashi, guakuge naxaldukshi, amak naxatshixakueki ekí jana izhukakue. ");
INSERT INTO kog_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ezua sigí juwí gauwapanatshak, juxasakue muldetua kakuamak juit zeñka agajieñguxa. Ekí kakuamak kama gukshanaldixa na, ni maxé zegatshak ni taniñgaba, juwík axabugatshak jiaga, wi wi atshishazháldixa. ");
INSERT INTO kog_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ne mieldekueja guakuge naldukatshak jiaga, amak naxatshazhékueki ekí jana izhukakue. Ezua sigí juwí gauwapanatshak juxasa jieñguagába gauxa. Guanaldixa, ni taniñgaba, juwík axabugatshake wi wi atshishi, nuk tiñgualdixa naldashá” na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Duwe Jesúja ekí kágubakue shi kaxaldiji aksaldiñguake ai zhiniki kuíbuldu Kapeldahúmka ne. ");
INSERT INTO kog_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Exaki ezua suldáutshi sáñkalda Alduma zalda na izhoxá. Ají nashi akldé izhgajañguxa mulbatá axakzeshiñgaba shuixaldá. ");
INSERT INTO kog_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Guñguakna sáñkaldaja Duwe shalda akuagaté nukañguake, ají nashi mulbatá iskaitshal naxaldiamak juldiú nauwa akldé akzekuek axakuañnexal kakaxá. ");
INSERT INTO kog_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Amak Duwe nugeñka aldeñgueni ekí matshuwi axakuañnék: —E sáñkaldaki agaunegakuamak magaunexaldixa. ");
INSERT INTO kog_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Jinake naldakí. Eñki axautshi saná naldatshak jiaga, nauwisaná izhgajañgui na, juwí kishjuizhaldexaldiéñ aldéñ naldi zʉnekauwal guak guane nak. ");
INSERT INTO kog_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ekí axakuañneguake Duweki amak kagapa neñguenik naki sáñkalda tshuxa neji neyapanatshak, sáñkaldaja apebukue Duwek ekí akbeyal kakaxá: —Nají Sáñkalda, najúk nagakjuldú guashi nakzé naldazhúge nak, natuál maldaxaldiamak kama ilshakue miguanakí nzhakú. ");
INSERT INTO kog_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ni nas jiaga matuál ne guashi nakzaldagálde nzhakú. Akna tuexa zhinikga mijí múldigabak nuxa “nashi iskaitá shi gui” guashi niuwi makexaldiake, “amak se akzék gualdixa shakldá” nakué. ");
INSERT INTO kog_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jinak ekí nakualdaka naldakí. Nas nají sáñkalda niuwi nagegatshak amak axatshikuge. Naldatshak jiak, nas jiaga suldáutshi sáñkalda naugakna, niuwi kagekugamak naxajanashixa. Akna ezuañki “newa” axaldexaldikuake amak neñka, azhi ezuañki “jai nak guwá” axaldexaldikuake amak naxaldaka. Ekibeñga nají nashi “jalde atsha guwá” axaldexaldikuake amak naxatshixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ekí nukatshakna Duwejañki: “¡Sakí shi ekí nakuaklde nukakú!” akldeshi na, káguba agapa duwá nakldekuek kakizhbateshi ekí kakbeyá: —Ekí miñmeyaldikue. Alde sáñkalda axautshi saná naldatshak mitsá alduna nazishamak, ni ezua nauwisaná Isayélkue ekíga muldetua alduna nazishaka tuakíñga nogashakú. ");
INSERT INTO kog_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Guñguake sáñkaldaja gaxanekue mokue juk aldeyatshake, nashi mulbatá akzegatoneki au se akzék guane na atuwá. ");
INSERT INTO kog_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ekí zegueni nauwa anuñka zeguake Duwe Jesú kuíbuldu Nahíñ axezhogeñka neyatshak, aldéñ shaxaldixakue na, matshuwi káguba zhikzhe axapa aldé. ");
INSERT INTO kog_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Naki kuíbuldu tezhak aldagatogueñki, ezua nakua shuane awaldeyaté tu. Shuanetshi ajabaki sameya, sigí ishuanane, asukuá akshuaneki e za axaldé. Naldakna káguba matshuwi ajabak axapa na aldeyatoxá. ");
INSERT INTO kog_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nalgué Duweja ai tshaba tuatshak matshuwi agakuañnekldana akzeshiñga ekí akbeyá: —Mauwagába nogwá. ");
INSERT INTO kog_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ekí akbeñgueniki shuane iyashane awaldeyatogué kaugipañguatshake awaldeyatoguekueja awaldeyaksá guñguake, Duweja ekí axaldék: —Nasukuá, izhgate guwá ni mikbeñkú. ");
INSERT INTO kog_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ekí axaldegatshaga na, shuane nalgué mokue juat izhgaldaguenik ité noshi zukuaxaldá. Guake Duweja ajabak agé. ");
INSERT INTO kog_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Saldiñga ekí atshaté atunekuejañki matshuwi zhe kakzeshi na, Saldiñga netshi Jate akldé akzamakga agazukui ekí akuák: —Jatetshi múldigaba naldiñga zʉxaitshixa ezua akldé akzé zʉñkizhañká guatiuwi. E na Jateja ajíkuañki zʉñgaunexaldixa gaxane nakldá. ");
INSERT INTO kog_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ekí Duwe atshatone shalda saldiñga káguba Juldeyaxa zalda, emaxé akyó zaldakue juizhi na izhgabeyapaná. ");
INSERT INTO kog_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Guatshak Juañ nik majaukshakueki aldéñ shaxaldixakueja Duwe Jesú atshatoguauxa shalda agabeyá. Ekí nukañguake, aikuega mozhuañki ");
INSERT INTO kog_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Duwek ekí akldukal kakaxá: —Saldiñga netshi Jateja ezua zʉnekualdal zʉñgakaxaldixa guakldane ne ¿ma ai shi maldá? ¿Azhi aiki jiaktuakuega shi zʉñgatsá? ");
INSERT INTO kog_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Guñguake gaxanekue amak Duwe nugeñka axaldeyatshak ekí agabeyá: —Juañ nik majaukshakueja ekí mikldukal zʉnakaxane: “Saldiñga netshi Jateja ezua zʉnekualdal zʉñgakaxaldixa guakldane ne ¿ma aiga shi maldá? ¿Azhi aiki jiaktuakuega shi zʉñgatsá?” ");
INSERT INTO kog_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Amak agaldukatshaga na, Duwejañki matshuwi mulbatá akzekakue kalzʉxaitshi, jisétshi alduna ijuldunekueki kezheñshi, uba isékue mokue uba kalkukshi na guatoxá. ");
INSERT INTO kog_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Guatogueniki axaxaxanekuek ekí kakbeyá: —Mokue Juañ nugaldi mineyaldiniki sakí mimijí ubak naldi atshaté natumine, sakí guagaté naldukamine miyakbeyaldí. Uba isʉ́ñzekueki kazʉtuñshapani, kalda ixanane neyagáldekue kaldeñshapani, ajuba ikaldunatukakueki mokue janshi kaxazguí, zukagáldekueki kazukshapani, shuanekue jiaga mokue kezhgaldakshi. Nashikue zʉnake Jateja sakí kalkualdaldixa shalda kakbeji. ");
INSERT INTO kog_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mieldeki alduna nazishál za nukaki Najateja zeñ jañguxa naldaldixa nakldá —na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ekí kakbeñguake Juañja gaxanekue saldi aldé guñguake, Duweja exa ashekualguekuek ekí Juañ shalda kakbeyaldá: “Maiñ zʉk zeñka káguba muldetua zhekualdazhéñka ¿me mitualdixa miñneshi shi neminá? ¿Azhi múlkaldaja abaldaxá mani mual axabuxaldiake aldi, aldi uldeyamakbé, ezua sigí mozhua, mozhua akldeka nuxa shi tual neminá? ");
INSERT INTO kog_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","E tual neyazhámine nake, ¿me shi tual neminá? ¿Azhi ezua sigí zhakuá agubisha janshagatse ijuakue shi tual neminá? Naldagálde. Mielde zhakuá akzé ijuakueki kabia, sáñkalda tshuxa za izhuka naldashá. ");
INSERT INTO kog_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ake, ezuañgabaki ¿me shi tual neminá? ¿Azhi ezua Jatetshi múldigaba naldiñga zʉxaitshixa shi tual neminá? Akze, e guana tual nemine naldashá. Ne Juañ míñgaki Jatetshi múldigaba naldiñga zʉxaitshixakue guashiñki zhakldé akzé giemi nakldá. ");
INSERT INTO kog_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juañ shaldaga guana, Najateja nakbeji ají múldigabak ekí sezheklde: ‘Nasga na mizhaxañga ezua maldeyaldixa shalda guashi jiúñgulda semixagauwi jana gaxaldikue nzha.’ ");
INSERT INTO kog_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Akna ekí miñmeyaldikue. Juañ nik majaukshakueki káguba kuka guanauxa guashiñki zhakaldak akzé na izhók. Naldatshak mielde minaldaldi nepanaminéñ zhinik na Jate miñsanegapanatshak, aikuañ zʉnake Juañ zhakldé miñzekue minaldaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Duweja guagatoxéñ matshuwi kágubakue, sáñkaldak akiyalzabine zhiksuikakue jiaga na aldukatoxá. Ekí aldukatshakna, “Saldiñga netshi Jateki zʉnajañguakuamak zʉnajañguxa shakldá” ajañgui iyapanane. Ekí ajañguxa ne awatuñshaldiamak Juañja nik kajaukshananekue. ");
INSERT INTO kog_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Naldatshak paldiseyukue, kauwisanátshi guiyaba shizhixakueja zʉnake Jateja sakí axatshakue kajañguxa iyapanazhá guanane. Akna Juañja nik kajaukshakue izhajanazhá guanane. ");
INSERT INTO kog_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Guñgueni Duweja ekí kakbeyá: “Maiñ kaiga zhekualdabinukakuañ, ¿ji na shi mimezhguajanaka na? ¿Ji jana mizhekue shi na? ");
INSERT INTO kog_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Maiñki sukuakue káguba zhenéñ ajokldegatukakue jana nuxa miyatshixa. Akze, sukuakueki ajokldeshiñga na, ‘kaigaki zeñ zʉñneshi kuizi ajuigatshak kuiskuizi’ izhgabeyatshak jiaga, ezuakuejañki ‘ekíki zʉñnunakí nakldá’ aldeshi amak akuizazhé. Ekí aldexaldiake ake, ‘kaigaki ezua zʉnshuane ibauwañkalduka janañgaba kuisjokldeshi’ izhgabeyatshak jiaga, ezuakuejañki ‘ekíki zʉñnunakí nakldá’ aldeshi amak aldegazhé. ");
INSERT INTO kog_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","”Jinake ekí mimezhguajanaka naldakí. Juañ nik majaukshakuejañki gakue miñgajamak gazhé, kalwéldia siyagaxaune tugazhé nalguakna, maiñki ‘eñki jisétshi aldunaja aksaneka nakna ekí izhók’ miñguaka. ");
INSERT INTO kog_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Naldatshak nas Jatetshi Asukuága ixagabaldeklduge zʉnake, maiñ mizajamakga zakuge, kalwéldia siyagaxaune nauwa tukuge. Ekí minatuatshakna, ‘E zʉnake zʉ́xaitsha zaxa, tuka. Eñki sha atshixa akuakakue, sáñkaldak akiyalzabine zhiksuikakuetshi apebu nzha’ minakuaka. Ekí mozhua kaldamakga minazʉnakuaka nak zʉnepanasʉ́ñ miñzeka. ");
INSERT INTO kog_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Naldatshak mieldekuejañki nasʉñ shizhiyañkaldamak jian atshiji ashekuéñ zhinik na, Saldiñga netshi Jate aldéñgaba mitsá ishkué ne awatuñshaka nakldá” na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ezua ldiuwañ ezua paldiseyuja Duwe Jesú ajuxa abuzatiakue akbeñguake amak neñguenik zaldiamak yaté. ");
INSERT INTO kog_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ai kuíbulduxaga ezua munzhi matshuwi sha atshiji izhuka nalgué, Duweki paldiseyu tshuxa zatuka nukañguake tual neyatshak, ezua we juma izhuka jika janshagatsék akué aksui uldé. ");
INSERT INTO kog_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Exa juldungueniki Duwe aldesañ nuldu axayoshi, sha atshixa shalda mauwiñgaba guatshake, ubaldiáki kasak itsukui, ají saikga ixañgui, nusgui, we juma izhuka kasak itsú na gua. ");
INSERT INTO kog_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Guatshak paldiseyu abuzatiakue akbeneja ekí tuatshakna: “Jalde sigíki Jatetshi múldigaba naldiñga zʉxaitshixa nahamak nake, jejié munzhi ekí axatshatukaki matshuwi sha atshixa ne akualdaka naldashá” na jañguá. ");
INSERT INTO kog_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ekí tuñguake Duweja ai paldiseyu Simóñ ekí akbeyá: —Ezua mikbeyakue nagatsé mikbeyaldikue. Guake akiyó: —Ake, shi maldaxaldixa, nakbeya guwá. ");
INSERT INTO kog_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Guake Duweja: —Mozhua sigíkue paldata washixak shaldá akiyaltene. Ezuajañki matshuuwi shaldá akizhuka, ezuañki nauwamé nuxa shaldá akizhuka. ");
INSERT INTO kog_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nalgué zabiyakue kagatsegatshak kakzaldazhá guñguake, paldata washaneja mozhua aldalguamakga éegaba “guanga, nakzabiyabináldi” kakbeyá. Ekí mikbeyaldatshak, mañki mozhua nekue ¿mieldeja shi paldata kakwashane akldé izhgajañgualdixa majañgú? —aklduká. ");
INSERT INTO kog_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Guake Simóñja ekí akiyó: —Nasgaba jañgua, akldé matshuuwi shaldá izhuka naneja akldé jañgualdixa ni jañgukú. Ekí akiyokuake Duweja: —Namakga ni maldakbé. ");
INSERT INTO kog_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Akbeñguenik munzhi señ tuwi mokue Simóñ akbeyá: —Jejié munzhi sakí naxatshane tu guwá. Mañki mibuzatagakue naldiñki nakbemalde naldatshak, mijúk juldunaldatshake nauwisaná atshamak kasa itshizhaldikuamak ni nagegazhámalde. Ne jejié munzhi niñkauwañki ají ubaldiákga kasa nazijizhá gueniki, ají saikga nexañguá guashá. ");
INSERT INTO kog_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mañki nauwisanákue muldetua ishpani atshamak mijúk nazipanazhámalde. Ne juldunkuenik jejié munzhi niñkauwañki muldetua nazipani naxatshatogashá. ");
INSERT INTO kog_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mañki nauwisanákue atshamak mantixa sáñkaldak nazibegazhámalde. Ne jejié munzhi niñkauwañki we juma izhuka kasak nazibé guashá. ");
INSERT INTO kog_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Akna ekí mikbeyaldikue. Jejié munzhiki zʉ́xaita najañguxa awatuñshashá. Jinake ekí najañguakí. Matshuuwi sha atshixa nane nuk axabeta guanuge nak. Ekí ne, mieldeki nauwamé axabeta guge zʉnake nauwamé nuxa najañgualdixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Guagueniki munzhik ekí akbeyá: —Ma sha atshamaldauxa éegaba mixabetá ni gukú. ");
INSERT INTO kog_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ekí aldukatshakna exa zal nakldekueja ekí izhgaldukaldá: —Jalde sigíki ¿me itshanák shi sha atshixa jiaga axabetá guxáki guak? ");
INSERT INTO kog_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Guatshak jiaga, Duweja munzhik ekí akbeyá: —Mañki alduna nazisha makuakna, miyakuá ni gu. Akna aldunaxa señgaba mikzeshi maldeyaldí —na akbeyá. ");
INSERT INTO kog_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ekí atshatoguenik, Duwe Jesújañki “Saldiñga netshi Jateja kágubakue janshagatsaldi kaksanexaldixa nakldá” kakbeji na, matshuwi kuíbuldu mizhatoxá. Amak mizhatogatshake aldéñ 12 shaxaldixakue na, ");
INSERT INTO kog_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","anuñka munzhikue, aldéñga mulbatá iskaitshanekue, jisétshi aldunakue izheñshanekue jiaga axapa aldé. Ekuega na ezuañki Maldiya Makldalda zalda, eñki Duweja kugua jisétshi alduna ijuldune nalgué nuk izheñshane. ");
INSERT INTO kog_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ezuañki Juana, asewá Kusaki sáñkalda Eldode jika axaldé numañ agatuñka. Ezuañki Susana guatshak axautshi munzhikue jiaga matshuwi na axapa aldeyatoxá. Ai munzhikuejañki ji kaxaldéñ zhinik Duwe aldéñ shaxaldixakue juizhi ji kagajuezhatshak kagauneshi na axapa aldeyatoxá. ");
INSERT INTO kog_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ezua ldiuwañ matshuuwi káguba kuíbuldu san san zaldakueja Duwe aldukal axaldaguakna, zulda atshakldegéñ zhinik ekí shi kaxaldiyaldá: ");
INSERT INTO kog_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ezua zʉzikaja zulda tiñgui nixal ne. Amak tiñguatshak anuñkaki jiúñguldak akjiená guane nalgué, iyataniñgaba guatogueñki nubája nuk ga. ");
INSERT INTO kog_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Anuñkaki jagénaldi akjienane, nalgué munapanatshake ni agajuezhiñgaba kaná. ");
INSERT INTO kog_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Jiak, anuñka zuldaki kausú kenaldi akjienane nalgueki, kausú nañga munapanatshake kausújañga jutekuá. ");
INSERT INTO kog_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Guatshak anuñka zʉnake kagi janshizeñ akjienane nalguekueki, muldetua munatshake gugasá zalda na nexá.” Gueniki ekí jaldáñ guak: “Ekí miñmeñkugeki saldiñga kuxa miñkaldikueke muldetua nukshi miñgualdí.” ");
INSERT INTO kog_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ekí aldukatshakna aldéñ shaxaldixakuejañki agalduká: —Duwe, ekí jika atshakldegéñ zhinik shi mizhiyatshak, ¿sakí guashi shi ekí shimizhí? ");
INSERT INTO kog_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Guñguake kakbeyá: —Nauwijatejañki sakí janshagatsaldi miñsanexaldixa ni mek mu agisekuazháne. Ne maiñ namak najañguaminekuañ zʉnake mu miñgisekuane. Ekí ne, namak najañguazhékue zʉnake jika azhi káguba atshakldegéñ zhinik za kakbeñkuge. Jinake ekí kakbeyakí. “Naldiñki sakí atshikuge natuál za aldogatshak jiaga, jinak ekí atshikuge kagajienazháldixa. Ekíga na, nas guakuge naldukal za aldogatshak jiaga, sakí guashi guakuge kagajienazháldixa” nak. ");
INSERT INTO kog_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","”Zulda atshakldegéñ zhinik shi miñkaldikugeki sakí guashi guaklduge miñmeyaldikue. Zulda miñmeyaldatshake, eñki Jatetshi múldigaba guashi. ");
INSERT INTO kog_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Anuñka zulda jiúñguldak akjienaneki ekí guashi. Eñki káguba anuñka nekueki Jatetshi múldigaba aldukaldinik jiséja ai múldigaba aldunaxa kekushi, kakjuizhanshixa. Ekíki namak ajañguazháldi, ni kaldakualdazháldiamak. ");
INSERT INTO kog_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Anuñka zulda jagénaldi akjienaneki ekí guashi. Eñki anuñka nekueki Jatetshi múldigaba aldukatshak zʉnake zeñ kakldeshi iyapanka. Ekí iyapananaldixa jiaga, shijualda kagik jieñguazhámakbe aldunaxa muldetua kagajienazhá guanaldixa na, anuñka me nuxa namak ajañguatoxaldiéñ, mitsake kakuaji, namak ajañguane shalda jibañ atuapanatshake namak ajañguaksá guxakue. ");
INSERT INTO kog_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Anuñka zuldaki kausú kenaldi akjienaneki ekí guashi. Eñki anuñka nekuejañki Jatetshi múldigaba aldukatshak namak jañgualdinik, mitsá zegagáñga jai kagik izhoxa kagajueshká za iyajani, kabia ldexa za iyajani, kakldunamak izhoxa za aldiñka. Ekí zhinik na, kausúja zulda jutekuamakga Jatetshi múldigaba kakjuizhanshi na, aldunaxa guildegakuamak akuildegazhékue. ");
INSERT INTO kog_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Naldatshak jiak, anuñka zuldaki kagi janshizeñka akjienaneki ekí guashi. Anuñka nekueki namak giemi aldunaxa shitindana kakzekakue Jatetshi múldigaba aldukatshak, muldetua iyapani, kakjuizhanakí amak axajanashiji, abá naldakí kagatsauxa axapa aldeñkakue. Ekí ashekualdatshakna, zulda matshuwi nekldamak Jate akldunamak ashekualdaldixa guashi na ekí miñmeñkú —na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ekí kakbejiñga na, Duwe Jesúja ekí shi kaxaldiyá: “Ni meja ezua muñshí zukuxa zuñguá gualdinik jika ipa, azhi jika sʉkldi íte guazhé. Ne muldetua muñshí kakzukualdiamak mataxa iyaldaka. Ekíki me juldunatshak muñshí kakzukualdiamak. ");
INSERT INTO kog_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","”Akze, ji ziñ me nanaldixa auxaga muetsexaldixa. Ekíga na, ji meja aksʉ́ñ nanaldixa auxaga muetseshi, washexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Akna nas ji miñmeyatokuge muldetua agajañgui minukaldí. Akze, mieldeki nají múldigaba agajienaneki akldeñga agajieñgualdixa. Ekí ne, mieldeki agajienaldiamak kama ilshazhéki ji agajiena guane akldeká jiaga nuk akjuizhanshaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Guatshak Duwe ajabaja, aldanikueja atuál aldagatshak, kágubakue duwá zhekualguakna aldesaxa aldeyasʉ́ñ atú. ");
INSERT INTO kog_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Guakna ezuaja Duwek ekí akbeyá: —Duwe, mijaba, mizhanikue juizhi matundana kakzeshi jubaldaxa akteté nagaldók. ");
INSERT INTO kog_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Guñguake akiyó: —Mieldekueki Jatetshi múldigaba aldukshi, guagamak axajanashixakue na najaba, nakaja giemi jana nekue katuñkuge nakldá. ");
INSERT INTO kog_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ezua ldiuwañ, Duwe Jesú aldéñ shaxaldixakue juizhi kanuwak ajuldunguenik ekí kakbeyá: —Niwak ataba niñkauwa kuizakbateshí. Kakbeñgueniki agabatexaldá. ");
INSERT INTO kog_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Amak agabategatogueñki Duweki kabá. Ekí kabagatogueñki múlkalda kamakualdi neyaldá, niwa jiaga kamakualdi kuiziji, kanuwak ni sʉneshi na atuasánaldixaga zexaldá. ");
INSERT INTO kog_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Guñguake Duwe uba agaldeñshi ekí axaldék: —Shi maldazʉñkaldixa, ni zʉnatuasáñgui, zʉnakuaxaldá ni gu. Agabeñguake izhgaldagueniki múlkalda kamakualdi neyatogué, niwa kuizatogué ekí axaldék: —Te nogwá. Ekí niuwi agegatshaga na múlkalda neyaksá, niwa jiaga kuizaksánatshake mokue janshibeñga ne na zexá. ");
INSERT INTO kog_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Guñgueni Duweja aldéñ shaxaldixakue ekí kaxaldék: —¿Jinak shi alduna nazishazhá miñguá? Ekí zeklde atuatshakna, zhe kakzeshi, “¡sakí shi ekí atshí!” ajañgui na, ataba atabañ zhinik: —¿Jalde sigíki me nak ekí múlkalda, niwa niuwi agegatshake amak axatshixa ne? —na izhgaldukajá. ");
INSERT INTO kog_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Guñgueni agabateshiñga na, Galdildeya buaxa, Jeldasa baxe aldé. ");
INSERT INTO kog_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Exaki Duwe kanuwak zhinik akjienatshake, ezua sigí exa zaldaga jisétshi aldunakue ijuldune axaldák. Eñki axañga zhinik zhakuá itshualdiyaksá guane, juk jiaga izhogaksáni na, jakateldi shuanekue abegaldi za izhogapanane. ");
INSERT INTO kog_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Guatshak ezuakuejañki guldak, kasak shezhashak shagatene atuaté aldogatshak jiaga, jiak jisétshi aldunakueja matshuwi juizha aksanegatshake shezhasha nuk zhikwati atshishi na, káguba isʉ́ñ zaldi neñshixa. Nalgué Duwe nagaté tuatshak axaldeji asták nuldu axayó. Ekí tuwakna Duweja jisétshi aldunakue sigík zhinik izheyakue kaxaldegatshak, akzʉxaitagáñga sigí jaldáñ ekí kaulshá: —Jesú mañki Jate akaldak akzetshi Asukuá giemi maldé, ¿sakí maldakualdixa ne? Guañ maldaguanaldí, guiyaba natuñshabaldáldi. ");
INSERT INTO kog_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Guake Duweja jisétshi aldunak aklduká: —¿Me mixazhuka sha? Guñguake akiyó: —“Matshuuwi” naxazhuka nzha. Jinak ekí akiyokuazhá. Matshuuwi jisétshi aldunakue sigík ijuldune nalguák. ");
INSERT INTO kog_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Guñguenik matshuwi juizha ekí Duwe axakuañnék: —Sehuldúldi zʉnakaxabaldáldi. ");
INSERT INTO kog_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Guatshake exaga gaxa akshá zeñka matshuwi mitu zatoguakna, jisétshi aldunakueja Duwe ekí axakuañnék: —Uñguexa mitukuek kejuldunakue maldazʉnajañgualdí. Guñguake Duweja: —Ake, amak guwíñ. ");
INSERT INTO kog_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ekí kakbeyatshakna, ai aldunakue sigík zhinik saldi akzʉxaitiñguenik, mitukuek iyajuldú. Guatshakna mitukue aldaldiñga niwa sáñkaldak guísʉgaxa pe pe pe akjienatshake, nuk ni izhgatuxá. ");
INSERT INTO kog_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ekí atuñguakna, mitu numañ tuñkakue aldaldiñga aldeñgueni kuíbulduk, eñgui akyó zhekuekuek jiaga ai shalda kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ekí zeklde aldukañguakna saldiñga atuál jeñ aldé. Amak Duwe nugeñka aldeyatshake, sigí jisétshi aldunakue izheneki asták ité atú. Eñki mokue muldetua alduna axaldeka, zhakuá jiaga itshualdí guane atuatshakna, zhe kakzék. ");
INSERT INTO kog_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Guñguakna, Duweja sigí jisétshi aldunakue ijuldunane izheñshaté atunekueja sakí janshi akzukuane shalda axautshikuek agabeyá. ");
INSERT INTO kog_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Guñgueni saldiñga Jeldasa baxe zaldakue matshuwi zhe kakzeguakna, Duwe mokue eñgui zhinik neyakue axakuañnék. Ekí axaldeguake aldéñ shaxaldixakue juizhi aldeyaldiamak mokue kanuwak ajuldú. ");
INSERT INTO kog_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ekí tuñguakna, sigí jisétshi aldunakue izheneja Duwe agakuañnék: —Migapa maldauldeyaldí. Guñguake abakue axaldeshi ekí akbeyá: ");
INSERT INTO kog_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Mokue mijuldi maldeyaldinik Saldiñga netshi Jate sakí atemajañ janshi mikzukuane kabakbeyaldí. Ekí akbeñguake amak neñguenik, kuíbulduxa ashekuauxa Duwe Jesúja mitsá atemajañ axatshane shalda na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Guñgueni Duwe Jesúki mokue niwa ataba niñkauwa akbateguenik, kágubakuejañki jiyagatuwiñgaba guatoxakna, zeñ kakldeshi iyapaná. ");
INSERT INTO kog_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Atshaga na, exa juwí izhajuizhaldegeñka zalda sáñkalda Jailduja jiaga Duwe axaldagueni asták nuldu axayoshi ajuxa tuatiakue agakuañnék. ");
INSERT INTO kog_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jinake ekí agakuañnegazhá. Abunzhi, ezuamé axaldé kumí, 12 kagi itsé nalgué akshuixaldá guñguák. Akbenalguamak neyatoguéñ, kágubakueja matshuwi dañ agayoshi neyaldá. ");
INSERT INTO kog_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ai káguba kenañga na, ezua munzhi, ají mulbatája guxa guñguenik 12 kagi itsegatshak iskaitaldiamak ilzabiyexañ jika axaldauxa nuk saldikshatshak jiaga, ni meja iskaitshazháka atú. ");
INSERT INTO kog_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Eja na Duwe shaneldi ga naguenik, zhakuá sʉxak juguatshakna, ubañga ají mulbatá tuaksá. ");
INSERT INTO kog_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Guñguakna Duweja izuká: —¿Me shi zhakuák najuguá? Izukatshak saldiñga juguazhánegaba akiyayokuñguakna, Péguldujañki ekí akbeyá: —Duwe, kágubakue matshuwi dañ migayoshiñgaba guatshak, ¿me ska majugú? ");
INSERT INTO kog_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Guñguakna mokue ekí guak: —Nas nakué, ezuak najuguá guashibiná. Akbiñgaki, kama nezhé guxá nakzegák. ");
INSERT INTO kog_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Guñguakna ai munzhija aldéñ ají zhakuák juguane akldék guxá tuñguakna, zhe akzeshi, tau tau atshijiñga, asták naguenik nuldu axayó. Saldiñgaja nukatoguéñ ekí Duwek akbeyá: —Nas mulbatá nakzeka naldakna, neskaitshamildaka jañgui na majugukuá. Amak majugualdatshaga nuxa na se nakzék na gua. ");
INSERT INTO kog_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ekí nukañguakna Duweja akbeyá: —Nabunzhi, mañki “neskaitshaka shakldá” najañgui, alduna maldeshéñ zhinik na se mikzék ni gu. Akna, aldunaxa señgaba mikzeshi neyabikuká ni gu. ");
INSERT INTO kog_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ekí akbeyatogueñga na, ezuaja sáñkalda Jaildu ajuxa zhinik ekí akbeyal nak: —Mibunzhiki au shua ni gua. Akna Duwe mijuxa neyakue akbeyalga nogakue migatsaldaksá ni gu. ");
INSERT INTO kog_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ekí nukañguakna Duweja Jailduk akbeyá: —Migabeñká mitsheñshagábaki, nas za na muldetua alduna nazisha makualdiake, mibunzhiki mokue izhgaldagatshake se akzexaldixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Akbeñguenik sáñkalda tshuxa neyatshak kágubakue juldukshagábaki, shuanetshi ajaba, ajate, aldéñ shaxaldixakue Péguldu, Juañ, Santiaku na nuxa kajuldukshá. ");
INSERT INTO kog_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Guatshake saldiñga agakuañnexal nakldekueki izhajani, jaldáñ abauwiñgaba akuatoxakna, Duweja ekí kakbeyá: —Mauwagába nogwíñ. Kumíki shuigazháne, egaba kabashi na guatók. ");
INSERT INTO kog_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ekí kakbeyatshak shuane kakualguakna Duwe iyashimá. ");
INSERT INTO kog_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Naldatshak Duweja kumí shuane káuxaldak akpañguenik ekí niuwi agé: —Nabunzhi, izhgaté guwá. ");
INSERT INTO kog_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ekí niuwi agegatshaga mokue alduna axaldagatshake izhgaté. Guñguake Duweja gakue akauwal guak. ");
INSERT INTO kog_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ajatekuejañki “¡sakí shi nauwibunzhi ekí izhgaldakshí!” ajañguatshak jiaga, Duwejañki ekí atshane shalda ni mek jiaga akbeyasé na niuwi kagexá. ");
INSERT INTO kog_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Guñgueni Duwe Jesúja aldéñ 12 shaxaldixakue kajuizhakuatshak jisétshi alduna kágubak ijuldunekue iyaldeñshaldiamak, mulbatá akzekakue jiaga iyazaxaitshaldiamak ají kama kagegatshak, niuwi jiaga kagé. ");
INSERT INTO kog_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ekí niuwi kageshiñga na, Saldiñga netshi Jate aldéñ naldiñga kágubakue janshagatsaldi kaksanexaldixa shalda akuaxaldiamak kakashi na, mulbatá akzekakue iyazaxaitshaldiamak jiaga kakaxá. ");
INSERT INTO kog_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Amak kakagapanatshak ekí kakbeyá: “Ekí mimakaxaldatshak, ji miñgajuezhaldixa uldeyabináldi. Ni kaldi miñté mineñka, gamá jiúñguldak miyuldeñka, gakue, paldata, ni zhakuá mozhua jiaga uldeyabináldi. ");
INSERT INTO kog_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Amak neji, ezua kuíbulduxa mineyaldinik mielde tshuxa minapanaldiake, eñka za kabashiñga mokue eñ zhinik mineyaldí. ");
INSERT INTO kog_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ne mielde kuíbulduxaki miñkaldukakí, mimeyapanasʉ́ñ kakzexaldiake, eñ zhiniki ne miñgualdí. Neyabipanatshake Jateja guiyaba katuñshaldixa ne katuñshi na, kaksibuldi kasak zhiktiñguá mineyaldí” kakbeji na kakagapaná. ");
INSERT INTO kog_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Amak kakaguake aldeñguenik san san kuíbuldu abizhauxa Jate aldéñ naldi sakí zʉnekualdaldixa shalda akuashi, mulbatá akzekakue iyazaxaitshiji na abizhá. ");
INSERT INTO kog_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Guatshak sáñkalda Eldodejañki Duwe Jesú atshatoguauxa shalda akuagaté nukatshak jiaga, Duweki “mega nindá” muldetua akzaldakí. Akbiñgaki ezuakuejañki “Juañ nik majaukshakuega mokue izhgatene naldaka nakldá,” ");
INSERT INTO kog_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ezuakuejañki “Jatetshi múldigaba naldiñga zʉxaitshixa Eldiyaga izhañkane naldaka nakldá,” ezuakuejañki “Jatetshi múldigaba naldiñga zʉxaitshixa mauzeñga zalda, ezua aiga mokue izhgatene naldaka nakldá” na akuagatoxá. ");
INSERT INTO kog_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ekí nukatshakna sáñkaldaja ekí guak: “Juañki nas naldi sáñkalda ibeñguakue guakldalgukuamak akuaxa guane. Ne kaiga ekí janshizhe ajanashaté atú guazhámak atshaté nukakugeki ¿me naldaka ne?” Ekí jañgui na, aldéñ naldi Duwe Jesú tualdiamak nijiñgaba na izhoxá. ");
INSERT INTO kog_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Guatshak Duweja aldéñ shaxaldixa gaxanekue mokue axaldagatshak, kauwizhéñ ajanashatonauxa agabeyá. Guñguake Duweja kauwihezuañgaba kuíbuldu Betsailda axezhogeñka kauldé. ");
INSERT INTO kog_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Guatshak kágubakueja mashi nene kakwasheguakna matshuuwi axapa aldé. Exa axaldeyatshak, Duwejañki muldetua kepani, Saldiñga netshi Jate aldéñ naldiñga janshagatsaldi kaksanexaldixa shi kaxaldiyá. Ekíga na, mulbatá akzekakue jiaga keskaitshá. ");
INSERT INTO kog_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Niuwi yaldaxaldá guapanguakna, aldéñ 12 shaxaldixakueja axaldaxeni ekí agabeyá: —Kágubakuek “neyabiñkuká na gu” kakbeyá guwá. Jinake naldakí. Jaiki káguba izhogazháldi, ni ji jiaga naldakí nakna kuíbuldukueni, eñgui baxe gakue axaldixa, mani axabaxaldixa ishkaldiji aldeyapanaldiamak. ");
INSERT INTO kog_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ekí agabeyatshak jiaga, Duweja ekí kakbeyá: —Maiñga gakue miyakauwaldí. Guake akiyayó: —Duwe, káguba matshuuwi zhekuéñ gakueki nauwañgaba nuxa, jatshiwa pañ, mozhua pikáu me ni zʉñkaldá. Akna gakue jabiyal neyakí naldakualdiake, kakauwazhánazʉnaka naldashá. ");
INSERT INTO kog_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Exaga káguba matshuuwi zhekualdi, sigíkuegaba iyazatatshak anuñka 5.000 naldashi na ashekualdá. Naldé jiaga Duweja aldéñ shaxaldixakuek ekí kakbeyá: —Kágubakue anuñka 50 negaba san san zhenal kakbewíñ. ");
INSERT INTO kog_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ekí kakbenalguamakbé axajanashiji na, saldiñga san san katshé na akuá. ");
INSERT INTO kog_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Guñgueni Duweja jatshiwa pañ, mozhua pikáu nalgué zhiksuigueniki mateldi stuaté noshi, Jatek ai shalda “zeñ nzhakldék” akbeyá. Ekí akbeñguenik pañ, pikáu zhikwatiyatshak matshuwi zhikldekshi aldéñ shaxaldixakueja kágubakuek kakauwaxañ kageguake, ");
INSERT INTO kog_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","amak agaxauwatshakna, saldiñgaja gaji yau kakzék. Ekí asatshak jiaga, Duweja shaxaldixakueja gakue abanegaba 12 nuldi na akuashá. ");
INSERT INTO kog_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ezua ldiuwañ Duwe Jesúja Ajate axazguagatoguéñ, aldéñ shaxaldixakue na nuxa ashekualdi ekí kaklduká: —¿Kágubakueja naski me naugé shi nakuák? ");
INSERT INTO kog_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kakldukañguake akiyayó: —Duwe, mañki anuñkakuejañki Juañ nik majaukshakuega maldé, ezuakuejañki Jatetshi múldigaba naldiñga zʉxaitshixa Eldiyaga maldé, Jatetshi múldigaba naldiñga zʉxaitshixa mauzeñga zaldaga ezua mokue izhgatene nuxa maldé na makuák. ");
INSERT INTO kog_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Guñguake: —Akze, maiñki ¿me naugé shi minajañgú? Guñguake Péguldujañki akiyó: —Duwe, mañki Saldiñga netshi Jateja ezua zʉnekualdal zʉñgakaxaldixa guakldane ne, aiga maldé nakldá. ");
INSERT INTO kog_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ekí guagatshak jiaga, Duweja ni mek ekí akbeyasé giemi na niuwi kagexá. ");
INSERT INTO kog_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Guñgueni Duwe Jesúja ekí jiaga kakbeyá: —Naski Jatetshi Asukuága ixagabaldekldugek matshuwi guiyaba tuakue nagatsexaldixa. Nauwisaná nauwa akldé akzekue, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue juizhi namak naxajanazháldi, naziyapanazháldixa. Ekí naxajani na, nakuagakuega zaldaldixa. Naldatshak shuixaldikuenik jiak, maiguake mokue izhgaldaxaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ekí aldéñ shaxaldixakuek za kakbeñguenik saldiñgak ekí kakbeyaldá: —Mieldeke namak giemi nagapa nendana miñzexaldiake, aike ekí naldakue miñgatsaldaldixa. Axaldáñgaba “nakldunamak izhogazháldiku” izhgakugakue. Ekíga na, niuwi neyauxa nají miné shalda nuxa guiyaba tuakue, azhi shuigakue miñgatsaldaldiake egaba abeti, “wa nuxa ni nakldexaldí” izhgakuxamine naldakue. Ekí izhgakuxamine na, nas za nagapa neyalga nogakue. ");
INSERT INTO kog_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jinake ekí miñmeyakí. Mieldeki jai kagik izhoxa za akldé akzé jañgui, nagapa neyasʉ́ñ akzekáki shuigatshak jékaldaxa izhoshiñga izhogazháldixa. Ekí ne, mieldeki nas shalda shuigaka izhgakuxaldiák zʉnake, jékaldaxa izhoshiñga izhoxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","”Ekibeñga na, mieldeke káguba kagik zhekuauxa guashiñki zhakaldak jika axaldaldi jiaga, shuigatshake jékaldaxa izhoshiñga izhogagába, guiyaba tu za nogakueñka neyaldixaga ne, ¿jiñ shi axaldanekue axazauwaldixa na? ");
INSERT INTO kog_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ekibeñga na, mieldeki nas shalda, nají múldigaba nukaxá shalda jiwak akzeshi “naski Duwe Jesú agapa neñkugé nakldá” guagasʉ́ñ akzexaldiake jiak, nas mokue kagik naxaldatshak, ekibeñga jiwak nakzukui “nají ne” guagasʉ́ñ nakzexaldixa. Amak naxaldatshaga, nas Jatetshi Asukuága ixagabaldekldugeke nají muñshí zalda nañga, Najatetshi muñshí zalda nañga, ají guaklde uldeñkakuetshi muñshí zalda nañga naxaldikue niyó. ");
INSERT INTO kog_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Akze, namak miñmeyaldikue. Anuñka miné jai izhoxabinukakuañ shuigagá minoxaldieñga maiñ naldi Saldiñga netshi Jateja abisajañ kágubakue kaksanegapanka mitualdixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ekí kakbeyatoguenik anuñka ábigua ldiuwi zeguake, Duwe Jesúki Péguldu, Juañ, Santiaku na agapa Jate axazguaxal gaxa akshá zeñka jeñ kaulditshí. ");
INSERT INTO kog_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Exa axazguagatogueñki, ají waxake sha ishkazguatshaga ají zhakuáki tuasá muñshí zaldaba iyaté. ");
INSERT INTO kog_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ekí ishkazguatogueñga na, mozhua nauwibama, ezuañki Muesé, ezuañki Eldiya akizhañkaji Duwe na dulda izhgashatshak ");
INSERT INTO kog_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","muñshí zaldaba izhukakue. Dulda izhgashatoguéñ Duweki kuíbuldu Jeldusaldéñka shuigakue agatsé zexaldixa ldiuwañ naki axakldañkaji guatuka izhgabeyá. ");
INSERT INTO kog_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Atshaga na Péguldu, e na nitshinekue jiaga uba kakuiñgaba axabagaté aldogué señ azatuatshake, Duweki tuasá muñshí ishkazguane, ai mozhua nekue na atú. ");
INSERT INTO kog_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Gueni ai mozhua nekue aldeyapanatshak Pégulduja Duwek ekí akbeyá: —Shi maldazʉñkaldixa, janshibeñga jai katshekualdé tiuwi. Akna maigua tañkuá kuizakpañguí, ezuañki mijí, ezuañki Muesétshi, ezuañki Eldiyatshi. Ekí akbeyatshak ji guagatuka akldegakíñga na ekí guaxá. ");
INSERT INTO kog_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ekí akbeyatogueñga na, mauwiga tiñ ketsék. Ekí mauwi sʉkldi abatshak zhe kakzukuá. ");
INSERT INTO kog_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Guatshakna mauwik zhinik Jatega ekí zukuagaté alduká: “Jejiéki Nasukuá giemi nas naldi izhgakuxanugeki muldetua miyaxaldukaldí.” ");
INSERT INTO kog_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ekí guagaté aldukañgueni jiak, Duweki ahezua akté atú. Guñgueni ai maigua shaxaldixakueja ekí ishkazguaté atune atshagaki ni mek agabeyazhá na akuá. ");
INSERT INTO kog_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Guñguenik abokualdik gaxa akshá zeñka zhinik asabatshake, kágubakue duwá zhikzhe Duwe Jesú akldabixal aldák. ");
INSERT INTO kog_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aiga na, ezua sigíjañki kauwikenáñ zhinik Duwe jaldáñ ekí akbeyá: —Shi maldazʉñkaldixa, nasukuá askimimé naxaldé nagatuwi, se naxakzukuá guakue ni migakuañnekú. ");
INSERT INTO kog_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Eñki jisétshi alduna ijulduneja aksanegatshak jaldáñ kaulshi, pisti akzukui. Ekí akzukuatshak, peñgui, kaxaldiñki jutúga kau ni akzukú. Maja naldakí guiyaba tuñshi na, naguagapaná ni gu. ");
INSERT INTO kog_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Guakna shi maxaldixakuek ai alduna iyaldeñshaxañ kagakuañnexaldatshak jiaga, amak iyaldeñshazháka ni atú. ");
INSERT INTO kog_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Guake Duweja akiyokui ekí guak: —Maiñ kutám za mijañguxakue nak, Jate alduna ishakí nibiná. Akna namak minajañgualdiamake ¿mitsá jimiñtuwi, abeti miñkizhogakue nagatsaldaldixa ne? Misukuá nakuldak guwá. ");
INSERT INTO kog_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sukua amak axaldeyatogueñki jiak, jisétshi aldunaja pisti akzukui, kagixa pak peñguá. Ekí tuatshakna, Duweja sukuak jisétshi alduna neyakue axaldegatshaga amak izhé. Guakna se akzukuane, mokue ajatek agé. ");
INSERT INTO kog_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ekí Duweki atshaté atuatshakna saldiñgajañki: “Nauwijatetshi kamaki ¡sakí ekí akaldak akaldak akzé ne!” na ajañguá. Kágubakuejañki “¡Duweki sakí ekí janshagatse atshixá!” izhgabeyatoguéñ aldéñ shaxaldixakuek za ekí kakbeyá: ");
INSERT INTO kog_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ji miñmeyaldikue muldetua nalduka guwíñ. Nas Jatetshi Asukuága ixagabaldeklduge ne, neyazhakuashi aguldiñkugekuek naxaxexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ekí kakbeyatshak jiaga, “sakí guashiñga ni ekí guak” kakldegazhá. Akze, Jatejañga sakí zexaldixa guashi guaká aldukazháldixa kajañguane naldakna kagajienazhá. Ni “¿sakí guashi shi ekí makuák?” aklduká kakzegazhá na gua. ");
INSERT INTO kog_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ezua ldiuwañ Duwe Jesúja shaxaldixakuegaba mieldek akldé akzé naldaldixa ne jiúñgulde múldigaba izhgasashaldá. ");
INSERT INTO kog_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Akna Duwejañki sakí ajañguatuka akualdi na, ezua sukua aldesañ uldagueni ekí kakbeyá: ");
INSERT INTO kog_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Mieldeke nagapa mineyéñ zhinik jejié sukua mipanatshaga, nas jiaga nepanamine naldaldixa. Ekíga na, mieldeke nas minepanatshaga, Najate nakaxane jiaga ipanamine naldaldixa. Akze, mieldeke aguáñ zhikzukuamineke Jate bualki akldé miñzé ne mimatuñka nakldá. ");
INSERT INTO kog_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Guñgueni Juañja Duwek ekí akbeyá: —Shi maldazʉñkaldixa, ezua sigíja jisétshi aldunakue kágubak ijuldune “Duwe Jesútshi kamak newa ni mikbeñkú” axaldeshi izheñshaté tuñkalde. Naldatshak aiki nasʉñ nañga agatsé naldagálde nalguakna, “mokue ekí atshabaldáldi” ni kaxaldegú. ");
INSERT INTO kog_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Guake ekí akbeyá: —Mokue ekí kagitamakuabináldi. Jinake naldakí. Mielde aguldiyañkáaldeki, zʉñgauneka naldaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Guatshak Duwe Jesúki mokue jékaldaxa nitshixaldixa ldiuwañ naki zegapanguakna, Jeldusaldéñka neyaldixa itshananalguamak neyaldá. ");
INSERT INTO kog_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Guñguakna, ezuakueki jiúñguldak kabashi neyaldiéñ janagaktuwi sajañga kakaxanekue Samaldiaxa ezua kuíbulduxa aldé. ");
INSERT INTO kog_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Aldeyatshak Duweki Jeldusaldéñkaga neyatoxakna, exa zaldakuejañki keyapanazháka kaxaldék. ");
INSERT INTO kog_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ekí Duwe iyapanazháka aldukañguakna aldéñ shaxaldixakuega, Santiaku, Juañ na ekí Duwek agabeyá: —Nauwijí Sáñkalda, nauwibama Eldiyaja akshishanamakga ¿Jateja jékaldaxa zhinik guksék kakuaxaldiamak kagakjieñgual akbeyá guakue shi maldazʉnajañgú? ");
INSERT INTO kog_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ekí akbeyatshakna kakizhbateguenik ekí kaxaldék: —Ekí atshasʉ́ñze ni mitú. Maiñ ji aldunatshi miné miñnegakí nzha. ");
INSERT INTO kog_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Akze, Jatetshi Asukuá ixagabaldekldugeki káguba akldañgashal nagagába, kekualdal naklduge nakldá. Guñgueniki axautshi kuíbulduldi aldé na akuá. ");
INSERT INTO kog_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Amak jiúñguldak aldeyatoguéñ, ezua sigíja Duwek ekí akbeyá: —Duwe, migapa nendana nakzeshi na, mani maldeyaldiák aldi jiaga migapa nenaka ni itshankú. ");
INSERT INTO kog_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Guñguake akiyó: —Ake, ekí jañguakue migatsé. Kalkalda piyuki kabaxaldixa jakata axaldé, nubáki kabaxaldixa juwí axaldé. Ne nas Jatetshi Asukuága ixagabaldekldugek niñkauwañki nají juwí giemi kabaxaldikuamak naxaldaldazhé nzha. ");
INSERT INTO kog_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ekí guaguenik ezuak ekí akbeyá: —Nagapa maldeyaldí. Guake akiyó: —Duwe, migapa neyaldikuega, naldatshak axáñ misha najate numañ izhgatuwiñga, kagi izhgisha guakue maldajañgualdí. ");
INSERT INTO kog_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Guake akiyó: —Mieldekueki namak najañguagáldekueki aldunaldi shuane jana ne. Akna aikueja shuanekueki kagi ishkiyashaka majañgualdí. Ne ma zʉnake Saldiñga netshi Jateja káguba janshagatsaldi kaksanexaldixa kakbeyal maldeyaldí. ");
INSERT INTO kog_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Guñguenik jiak ezuaja Duwek ekí akbeyá: —Duwe, migapa neyaldikuega naldatshak, axáñ misha najúk zaldakue “neñkuge nzha” kakbeyal neyakue maldajañgualdí. ");
INSERT INTO kog_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ekí akbeyatshak akiyó: —Mieldeki nagapa neyapanatshak jiaga, axáñ izhonane za jañgualga noxaldiák, aiki “Jate za ni naksanexaldí” ezuañgaba akldegazhé naldi na, Jate axazauwazháka naldaldixa nakldá —na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Guñgueniki Saldiñga netshi Sáñkalda Duwe Jesúja mokue 72 aldéñ agapa neñkakue izhgakugueniki mozhua, mozhua ishkapa mielde kuíbulduxa mashi, mashi aldéñ neyaldieñka sajañga kakaxá. ");
INSERT INTO kog_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Amak kakagapanatshak ekí kakbeyá: “Tek gakue matshuuwi gugakuegaba negatshak, jiba atshakakue auxaga naldakí nahamakbe, matshuwi nepanaldixakue nañga naldatshak, nas shalda kakbeyakakue auxabé naldakí. Akna, tetshi jáugukuik jiba axatshaldixakue akldé gagakue akshishakuamakbé, nauwijí Sáñkaldaja nas shalda guaxaldixakue gaxaldiamak miyakshishaldí. ");
INSERT INTO kog_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","”Akna newiñ. Egaba muldetua numañ miyatualdí. Jubeju zhauwakue nabi kenaxa axaká jana naski káguba aguldiñkugekue, miñgisalshakakue kenaldi ni mimakakú. ");
INSERT INTO kog_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Amak mineyatshak gamá jiúñguldak miyuldeñka, mozhua sapatu ni paldata uldeyabináldi. Mashi mimakaxanuge naldaldiake jian eñka neyabinogatshakna, káguba jiúñguldak dulda akshapana guabináldi. ");
INSERT INTO kog_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","”Ekí mineyaldinik mielde juk mijuldunatshak kishkazguagamakga: ‘Jai mizhekuekuañ Jate aldunaxa señgaba shi miñzukuí’ minexaldí. ");
INSERT INTO kog_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ai juk zaldaja aldunaxa señgaba izhoxa ipandana akzexaldiake, Jatejañga akshishaminamak aldunaxa señgaba akzukualdixa. Azhi ipandana akzegakí naldaldiake, aldunaxa señgaba akzukuazháldixa. ");
INSERT INTO kog_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mielde juk minapanaldiake antezhaxa antezhaxa kabaxal neyagábaki, ai juk ji gakue, ji ni miñgaxauwaldiake amak miñgaldí. Akze, nashi jiba atshixá shaldaki akzabiyakue zegamakga na, maiñ ai juk zaldakue miyagauneká shaldaki ji miñgajueshká miñgegakuamak miñgegakue kagatsaldaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","”Mielde kuíbulduxa mineyatshak, eñ zaldakue muldetua mimepanatshak, ji miñgaxáu gualdiake ai ga miñgualdí. ");
INSERT INTO kog_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Maiñ zhiniki eñka zaldakue mulbatá kakzekakueki nají kamak se kakzukui na, eñ zaldakuek ‘Saldiñga netshi Jateki abisajañ miñsanexaldiéñ ldiuwañ naki zexaldá na gu’ miyakbeyaldí. ");
INSERT INTO kog_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","”Ne mielde kuíbulduxa mineyatshak miñkaldukakí, mimeyapanasʉ́ñ kakzexaldiák zʉnake, saldiñgaja aldukaldiéñ axate xaldek ekí miñguaxaldí: ");
INSERT INTO kog_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mimijí kuíbuldu zhinik kaldeyapanatshak, Jateja guiyaba mimatuñshaldixa ne mimatuñshi kaksibuldi kasak zʉñmunane jiaga zhiktiñguá na kakú. Guatshak Saldiñga netshi Jateki saldiñga aksanexaldiéñ ldiuwañ naki zexaldá guapanká miñkualdakue miñgatsé.’ ");
INSERT INTO kog_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ekí miñmeyaldikue. Mielde kuíbuldukueki mimeyapanasʉ́ñ kakzexaldiake, Jateja kágubakue kagatsaldi ne katualdixa ldiuwañ zegatshak, mauzeñga Sulduma zaldakue zʉxaita sha ajanashanane shalda mitsá guiyaba katuñshaldixa guashiñki zhakaldak katuñshaldixa nzha.” ");
INSERT INTO kog_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Guñgueni ekí jiaga guak: “Maiñ kuíbuldu Kuldasíñ zaldakue, Betsailda zaldakue na, ¡wau wau wau sakí guiyaba mitualdixa ne! Jinake naldakí. Matshuwi sha ajanashixakuetshi kuíbuldukue Tildu na Sidóñ na, maiñ nugeñka matshuwi janshizhe ajanashaté atú guazhámak miñkatshanugamak kaxatshanakuashíñki, kauwizhéñki mitsaga zhinik sha atsha majiñga maja, Jatek axakualdi guane nogataldé. Amak abajatshake sha ajanashane shalda izhajaniñgaba saldiñgaja katualdiamak ajanashá guane nogataldé. ");
INSERT INTO kog_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ne maiñ zʉnake sha atsha majazhá guaminéñ zhinik na, Jateja saldiñga agatsaldi ne tualdixa niuwañ zegatshak, kuíbuldu Tildu zaldakue, Sidóñ zaldakue guiyaba katuñshaldixa guashiñki, zhakaldak guiyaba mimatuñshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Maiñ kuíbuldu Kapeldahúm zaldakue ¿sakí shi Jateki akldé miñzukui, mataxa mimebekshaldixa mijañgú? Akbiñgaki aguáñ giemi mimezhbashiji, guiyaba tu za nogakueñka mimausabaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ekí guagatoguenik, gaxaldixakue ekí kakbeyá: “Mieldeki shi miyaxaldiyatshak miñkaldukshi, miñgipanatshak, nasga naldukshi, nakiyapanaldixa. Ekibeñga na, mieldejañki mimepanazhá gualdiake, nasga naziyapanazháldixa. Ne mieldeki nazipanazhá gualdiake, nakaxanega iyapanazháldixa nakldá” na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Guñgueni Duweja ai 72 kakagueni mokue axaldagatshak, zeñ kakldeshi ekí agabeyá: —Nauwijí Sáñkalda, káguba jisétshi alduna ijuldunekue jiaga, “Duwe Jesúja mixaldék zhuxañga newa ni mixaldekú” kaxaldegatshake amak ni kezheñshiñgú. ");
INSERT INTO kog_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Guñguake kakiyó: —Akze, jisétshi aldunakue ekí niuwi miyagegatshaga, jiséki kuizhbañguitshi shitsha alnobaxa zhinik kagik akjienamakbé akjienaté tunuge. ");
INSERT INTO kog_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nukaté nogwíñ. Nasga na jisé kaguldiñkak kama axaldá nahauxak miyagubiyaldiamak niuwi miñgeshi, nají kama miñgenuge. Ai miñgenugéñ zhinik na ni ji, ni me jiaga sha mimakuazháldi na, takbi azhi zekú mitanatshak, sha mimakuazháldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Naldatshak jisétshi aldunakue neyakue niuwi miyagegamak miñkatshixa shalda za zeñ itshanagábaki, Jateja jékaldaxa izhoshiñga mimezhokshaldixa mimijí miñkazhuka ají aldíbulduk au mimakzuñgua guane shalda akldé giemiki zeñ itshani miñgualdí —ekí na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Atshaga na, Jatetshi Aldunajañga matshuwi zeñ akzukuatshak Jate ekí axazguaxaldá: “Najate, ma za saldiñga alnoba agatsauxa, kagi agatsauxatshi Sáñkalda mizhuka akldé mikzamakga mikzukui, ‘zeñ nzhakldék’ ni mikbeñkú. Jinake naldakí. Mieldekueki kauwizhéñgaba matshuwi ishkué itshankakue, jika matshuwi shitiyanekue aldaldatshak jiaga, aikuek na sakí guashi shizhiyatokugeki katuñshazháldi, muldetua kagajienazháldiamak kagitshuakshamalde noxabalduka. Ne ai itsaldagálde axajankakue sukua jana ma za alduna misha izhukakuek zʉnake amak katuñshamalde. Akze, ma ‘ekí ni atshaldikú’ jañgui amak atshamalde nak ‘zeñ nzhakldék’ ni mikbeñkú.” ");
INSERT INTO kog_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ekí axazguaguenik kágubakuek ekí kakbeyá: “Najateja ishkué nalda, kama axaldá nahauxa nasgaba nagene. Najate aldéñ za nas Asukuák me naugé auxaga akualkuge. Jiak ekibeñga na, nas Asukuák za aldéñ ‘me ne’ auxaga nakué. Ekí nakuakna, Najate ‘me ne’ mieldekueki katuñshaldikuamak kezhgakuxaldikuake, ekuek za na amak kakualdaldixa nzha.” ");
INSERT INTO kog_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ekí kakbeñguenik aldéñ shaxaldixakueja za aldukaldiamak ekí kakbeyá: “Maiñ zʉnake nagapa neyabinogatshak, nas atshikuge natuabinukakuañ Jate matshuwi zeñ mimajañguxa. ");
INSERT INTO kog_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Akze, ekí miñmeyaldikue. Matshuwi Jatetshi múldigaba naldiñga zʉxaitshixakue, sáñkalda akzekue na, kauwizhéñ naldi maiñ mituamak tundana kakzegatshak jiaga atuazháne. Ekíga na, maiñ minukajamak aldukandana kakzegatshak jiaga, amak aldukazhá guanane naldashá.” ");
INSERT INTO kog_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ezua ldiuwañ ezua asanátshi guiyaba shizhixaja Duwe Jesú guajaldiamak jañgui ekí aklduka: —Shi maldazʉñkaldixa, Jate jékaldaxa izhoshiñga nezhokshaldiamake ¿sakí shi atshakue nagatsá? ");
INSERT INTO kog_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Guake Duweja akiyó: —Jateja guiyaba nauwibama Muesék zʉñkabajaneja ¿izhoshiñga mizhoxaldiamake sakí izhogakue sezheklde shi mazukuakshí? ");
INSERT INTO kog_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Guñguake akiyó: —“Maiñ Saldiñga netshi Sáñkalda, Mimijatega e za miñgatsauxa izhgajañgui na, miñnegauxa, mijañguauxa, kama miñkuauxa e za mizhgajañgualdí.” Ekíga na, “maiñ axaldáñ mitsá miyajañguxa nake, kágubakue amaga mizhgajañgualdí.” ");
INSERT INTO kog_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Guñguake Duweja akiyó: —Janshibé ni maldakiyokú. Amak matshaldiák zʉnake izhoshiñga mizhogataná nzha. ");
INSERT INTO kog_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ekí nukatshakna, guiyaba shizhixaja “amak izhuka ne” axajanaldiamak jañgui na ekí aklduká: —Ake, nas ajañgugamakga izhgajañgualdikueki, ¿mielde naldaldixa ne? ");
INSERT INTO kog_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Guñguake Duweja ezua ajanashakldegéñ zhinik ekí akiyó: —Ezua sigí Jeldusaldéñka zhinik kuíbuldu Jeldikóxa zabatogueñki tushekakueja akldabigueni ají numakue, zhakuá juizhiñga nuk iyatushék. Sigíki kaugagashijiñgaba ezua izhguaxa agazukuñgueniki, exaga abaji saldi aldé. ");
INSERT INTO kog_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nauwa maldé zegatogueñki ezua Jatek múldigaba agaskaitshixa ai jiúñguldakga neyatogueñki, sigí agisane sha tuñguake, agaunegagábaki, egaba ibaték. ");
INSERT INTO kog_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ekíga na, ezua sigí Aldebí ldaxe, Jate axazakuagaldi jibatshixa nalgué ai jiúñguldakga neyatogueñki, sigí agisane sha tuñguake eja jiaga egaba ibaték. ");
INSERT INTO kog_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","”Guñguenik zʉnake ezua sigí Samaldiaxa zalda ai jiúñguldakga maldé zaldi zhinik zʉxaitatoxeñki, sigí agisane sha tuatshak guañ jañguá. ");
INSERT INTO kog_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ekí jañgui na, aldesañ axaldagueniki agisanéñ aldimediu tsaldi mantixa, kalwéldia siyagaxaune jeñ itsú, kuldita jeñ ibá. Guñgueniki ají buldukga ibekshiñgueni axabaxaldixa juwí awasheñka uldeñgueni jiaga numañ tu. ");
INSERT INTO kog_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Abokualdíki, ai juwítshi ajáugukuik mozhua ldiuwi kasa izhgáu naldashi akzabiji ekí akbeyá: “Jejié sigí agisane numañ nagatuaté maldoxaldí. Jiñ akldé metshuakshaldiake, ai shaldáki mokue naxaldatshak mikzabiyaldikue nzha.” ");
INSERT INTO kog_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ekí akbeyatoguenik ekí aklduká: —Mañki ekí maldukatshake, ai sigí akiyasalshane maigua nekueja jiúñguldak sha atune, ¿mieldeja axaldáñ ajañguamakga jañguane shi matú? ");
INSERT INTO kog_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Guñguake guiyaba shizhixaja akiyó: —Ai sigí agisane guañ jañguane na tuñkú. Guñguake Duweja: —Ake, ma jiaga kaiga zhiniki e atshanamakga matshaldí —na akbeyá. ");
INSERT INTO kog_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Guñgueni Duwe Jesú aldéñ shaxaldixakue juizhi Jeldusaldéñka aldeyatoshiñga na, ezua kuíbulduxa aldeyatshak munzhi Malta axezhukaja ajuxa kepaná. ");
INSERT INTO kog_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Guatshak exaki aldani Maldiyaki Duwe stak yaldagueni aldéñ shizhiyatuka axalduká na noxá. ");
INSERT INTO kog_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nogatshake aldú Maltaki nakldekuetshi jika janaktuakue agatseguakna, ai za ijaná noguakna Duwek ekí akbeyal nak: —Nají Sáñkalda, naldani nagaunegakí nak jiba nagatseshiñgaba guxá ¿tuakí shi maldá? Akna nagaunexal akbeya guwá. ");
INSERT INTO kog_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Guñguake Duweja: —Nabunzhi, mañki agubisha jika za ijaniñgaba, itshaniñgaba izhogashibaldá. ");
INSERT INTO kog_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Askimiñgaba ezua za akldé atshakue, aiki nají múldigaba za nukakue migatsaldashá. Mizhani Maldiyajañki ekí atshakue izhgakuxá guane nakna, ni meja jiaga ikugazháka naldaldixa nzha —na akbeyá. ");
INSERT INTO kog_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ezua ldiuwañ Duwe Jesúja Ajate axazguashi aksaldinatshak, ezua aldéñ shaxaldixaja ekí akbeyá: —Duwe, Juañ nik majaukshakueja aldéñ shaxaldixakuek Jate axazguagakue shi kaxaldiyanamak, ma jiaga shi zʉñkaldiya makualdí. ");
INSERT INTO kog_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Guñguake Duweja amak shi kaxaldiyaldá: —Maiñ Nauwijate axazguaxaldá miñguatshak jekí agatsaldi miyaxazguaxaldí: “Nauwijate, jékaldaxa mizhuka, ma za akaldak, akaldak mikzé maldahamakga, saldiñga káguba zhekuauxaja ekí zañga shi migazukuí. Maldé zegagáñga saldiñga káguba sanákue nahauxa ma za kaksanegakue shi mixajaní. Jékaldaxa zaldakue ma majañguauxabe mixajanashamakga, jai kagik zaldakue jiaga ekíga shi mixajanashijí. ");
INSERT INTO kog_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Niuwi neyauxa ji gakualdixa zʉñgeshi makualdí. ");
INSERT INTO kog_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nasʉñ sakígaba sha atsháñkalde zʉñkabetá makualdí. Jinake ekí migakuañnegakí. Saldiñga sha zʉnakuxakue axabeti kizhuka nak. Nasʉñ sakígaba sha atshindana zʉñzukuxa azhi ijuldunakualdiamak zʉñsanekak amak axatshiji ijulduni guanazʉñnegak zʉñgauneshi makualdí. Ekíga sha atshátshi sáñkalda jisé amak zʉnatshishi, zʉñgubiji guakuak yo maldazʉnakualdí.” ");
INSERT INTO kog_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ekí shi kaxaldiñguenik ekí kakbeyá: “Guatshak ezuak maiñ mimipebu miñkaldé ne, semuanté zegatogeñki mijuxa mixaldeyeni ekí mikbeyaka: ‘Napebu, gakue nauwa nakáu guwá. ");
INSERT INTO kog_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Akbiñgaki, maldé zaldi zhinik napebu nezhabinek ji akauwakue naxaldaldakí nak.’ ");
INSERT INTO kog_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ekí mikbeyatshak juldi zhinik ekí akiyomildaka: ‘Naxazguagagába nogwá. Au juwí jeñ ishkakyó, nasukuákue juizhi jeñ ashá guáñkalde ne, ji mikauwal izhgaldagazhánaka nzha.’ ");
INSERT INTO kog_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","”Ekí miñmeyaldikue. Akze, akzʉshishamaldeki mipebu nak za, izhgaldaxaldinik ji migajuezhauxa mikauwazháldixa. Akbiñgaki mikzék naldakí akshishal za maldoxaldiák guana, ji migajuezhauxa amak mikauwaldiamak izhgaldaxaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","”Akna ekí atshakue miñmeyaldikue. Ji miñgajueshká Jatek akshishal za mizhekualdatshak amak miñgexaldixa. Ekibeñga na, ji miñgajuezha gualdiake Jatek za niyal mizhekualdatshak amak miñzaldaldixa. Ekíga na, abá naldakí Jate agakuañnexalga za mizhekualdatshak mimaldukshi, amak miñkatshaldixa. ");
INSERT INTO kog_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jinake naldakí. Mieldejañki ji agajueshká Jatek akshishatshak amak agexaldixa. Mieldejañki ji agajueshká Jatek za niyatshak amak akzaldaldixa. Mieldejañki Jate agakuañnegatshak axaldukshi, amak axatshaldixa nak. ");
INSERT INTO kog_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","”¿Mielde jatek shi mimijí sukuaja gakue miñshishatshak, jagi nuxa akáu miñguxa na? ¿Mielde jatek shi mimijí sukuaja pikáu miñshishatshak, takbi nuxa akáu miñguxa na? ");
INSERT INTO kog_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Azhi guibu miñshishatshak, zekú nuxa akáu miñguxa na? Ekíki atshabíne naldashá. ");
INSERT INTO kog_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Maiñki sha miyatshixa naldi jiaga, mimijí sukuakue jika janshagatse za agexa miñkué. ¡Akna mitsá Nauwijate jékaldaxa izhuka míñgaki mieldeja ají Alduna agexaldiamak akshishatshak, akldé ageka naldakí shi na!” na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ezua ldiuwañ, ezua sigí jisétshi aldunaja ijuldunatshak zukuakshaksá guane nalgué, Duweja ai alduna izheñshatshaga na jiak, mokue zukuaxaldá. Guakna saldiñga atuatoxekuejañki “¡sakí ekí se akzukuxá!” na ajañguá. ");
INSERT INTO kog_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ekí ajañguatshak jiaga, anuñka nekueja zʉnake: “Ejiéki Belsebú, jiséga ají aldunakue aksanekaja kama agegatshak guana ekí ají aldunakue izheñshashá” nalda axakuák. ");
INSERT INTO kog_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ne ezuakuejañki Duwe akuajaldiamak kakldeshi ekí axaldék: —Mañki Jate jékaldaxa izhuka naldi jai kagik makaxanamak ne maldazʉnatuñshaldiamake, ezua janshizhe ajanashaté tu guañkáaldamak zʉñkatshá makualdí. ");
INSERT INTO kog_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Duweja sakí ajañguatuka akualdi na ekí kakbeyá: —Mielde sanáki kauwizhéñgaba axaukshapana akualdiake, nuk izhgaldañgashixa naldashá. Ekibeñga na, zhuajúk zaldagaba axaukshi izhguldiyapana akualdiák, san san aldeji, zhuajúk zalda aldaldaksá guxá naldashá. ");
INSERT INTO kog_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ekíga jisé aldéñga ají aldunakue na axaukshi guanake, ¿sakí shi jiséja ají aldunakue aksanexalga nogaka na? Jinake ekí miñmeyakí. Naski jisétshi aldunakue aksanekajañga kama nagenek na ají aldunakue izheñshikuge nakuakbine nak. ");
INSERT INTO kog_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Akze, naski jisétshi aldunakue aksanekajañga kama nagenek ai aldunakue izheñshikuge nake, maiñ shi miñgitixakueja jiaga jisétshi aldunakue kágubak zhinik kezheñshatshake ¿ake, metshi kamak shi ekí kezheñshixa na? Kauwizhéñ ekí ajanashéñ na, jisétshi kamakga ají aldunakue kezheñshikuge nalda naguagakue miñgatsaldakí ne awatuñshixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ne nas niñkauwañki, Saldiñga netshi Jatejañga ají kama nagenéñ zhinik na jisétshi aldunakue neñshaldatshak guana, aldéñki au mimikenáñ sanexaldá guxá mimatuñshashá. ");
INSERT INTO kog_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ekí kakbejiñga na, ekí jiaga kakbeyá: “Ezua sigí kamakue, jika kaukshaldiamak auxaga axaldejañki ají juwí numañ izhgatuaté nogeñki, ají numa agitshuanazháldixa. ");
INSERT INTO kog_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ne ezua jiak, aldéñ zhakaldak kamakueja zʉnake axaldashi, agubiji, ji kaukshaldixa axaldék za agasjanane ikuxa gualdinik, ají numa nuk agipanaldinik ishkauwaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Guñgueni ekí jiaga kakbeyá: “Guatshak mieldeke nas na izhogakí nogatukaki aguldiñkuge naldaldixa. Ekibeñga na, mieldeke kágubakue Najateja kaksanexaldiamak juizhakui nagaunegazhéki, Jatek agajuekui mual atshixa naldaldixa nakldá” na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Guñgueniki ekí kakbeyá: “Ezua jisétshi alduna kágubak zhinik iyaldeñshatshak, zʉk zaldi káguba isʉ́ñ zaldi neyaldinik mani izhogaka za niyá nuka. Akzaldakí naldaldiake ekí izhikbeyaldixa: ‘Kágubak nagazaxaitshaneñkaga mokue izhoxaldikuamak neyaldikue nzha.’ ");
INSERT INTO kog_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Gualdini eñka neyatshake, ai káguba ají aldunaxa Jatetshi Alduna izhogazhéga akzaldatshak, aiki juwí axautshi izhoxaldixa siyagaxauwane jana nuxa akzaldaldixa. ");
INSERT INTO kog_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ekí tualdiake, jiak aldéñ zhakaldak alduna shanekue kugua niji juizhakualdixa. Gualdiniki ekue na ai kágubak iyajuldunatshakna, eñki axañga agisaldatone guashiñki, zhakaldak agisaldaldixa nzha,” ekí na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ekí Duweja guagatogueñki, ezua munzhija azaldukatoguekue kenañ saldiñgaja aldukaldiamak ekí guak: —Mijaba mauldaklde, makuiyakshaneki Saldiñga netshi Jateja zeñ jañguxa tiuwi. ");
INSERT INTO kog_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ekí nukatshakna Duweja akiyó: —Akze, Najatetshi múldigaba nukshi, agipani amak axajanashixakue zʉnake akaldak giemi zeñ kajañguxá nakldá. ");
INSERT INTO kog_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kágubakue akldé akldeñga Duwe Jesú aldukaldiamak iyajuizhaldegatoguéñ ekí kakbeyaldá: “Maiñ kaiga zhekualdabinukakueki sha atshiji, kutám za mijañguxakue ne na tuñkú. Akze, Saldiñga netshi Jateja kagik nakaxanamak ne mimatuñshaldikuamake, mokue ezua janshizhe ajanashaté tu guabínamak miñkatshakuega minakshishatshak, ezua za mimatuñshaldikue. Eñki Najateja nauwibama Junás atshishanamaga nuxa mimatuñshaldikue. ");
INSERT INTO kog_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Akze, nauwibama sakí agatsekldéñ zhinik na Jateja gaxanamak ne Nínibexa zaldakuek katuñshanamakna naski, Jatetshi Asukuága ixagabaldeklduge, sakí nagatsexaldiéñ zhinik na Najatejañga nakaxanamak ne mimatuñshaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","”Auxa zegatshak, Jateja saldiñga káguba agatsaldi ne katualdiéñ zegatshak, munzhi kagi Sabátshi sáñkalda miñkizhgaldaxaldinik kaiga zhekualdabinukakue Jate guiyaba mimatuñshakue axamindaxaldixa. Jinake naldakí. Nauwibama Saldamóñki muldetua ishkué izhoguák ai munzhiki agubisha maldé zeñka izhogué jiaga, ají múldigaba axaldukal nakldane nak. Ne maiñ niñkauwañki, naldiñki ai nauwibama zhakldé nakzé miñkizhoxaldatshak jiaga, naldukasʉ́ñ miñzeka. ");
INSERT INTO kog_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ekibeñga na, Jateja saldiñga káguba agatsaldi ne katualdiéñ zegatshak, kuíbuldu Nínibexa zaldakue miñkizhgaldaxaldinik kaiga zhekualdabinukakue Jate guiyaba mimatuñshakue axamindaxaldixa. Jinake naldakí. Ekuejañki nauwibama Junásja Jatetshi múldigaba kakbeyatshakna, sha ajanashixa abajiñga abaja, Jatek axakualdi guananekue nak. Ne maiñ niñkauwañki naldiñki ai nauwibama zhakldé nakzé Jatetshi múldigaba miñmeyaldatshak jiaga, sha miyatshixa majiñga majazháldi, Jatek agakualdi guakí nibiná.” ");
INSERT INTO kog_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Gueniki ekí shi kaxaldiyá: “Ni meja ezua muñshí zukuxa zuñguá gualdinik tuasʉ́ñ zaldi ité guazhé, ni jika ipá guazhé. Ne muldetua muñshí kakzukualdiamak mataxa iyaldaka. Ekíki me juldunatshak muñshí kakzukualdiamak. ");
INSERT INTO kog_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Akze, ezua muñshí zukuxaja jika matuñshamakga mimijí ubaja saldiñga mimatuñshaka. Akna ubak se miné minaldaldiake, saldiñga miñgatsauxa muñshí minzeklde minaldaldixa nakldá. Ne ubak se naldabíne minaldaldiake, miñgatsauxa tuañ za minzeklde minaldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","”Muldetua be minoxaldí. Azhi ji muñshí zalda miñkaldé mijañguxa, aiki naldagálde tuañ zalda nuxa naldaldiák, ¡mitsá tuañ zalda miñkaldé naldaka ne! ");
INSERT INTO kog_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Akna, miñgatsauxa Jate shalda namaklde jañgui mipanaldiakna, akldé akldeñga ai namaklde miñsaneklde tuañ miñzukuakí, muñshí miñzukualdixa. Ekí za mizhoxaldiakna muñshí zukuxa zʉtuamakbé aldunaldi miñgatsauxa muñshí miñzeklde za mizhoxaldixa nzha.” ");
INSERT INTO kog_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Duwe Jesúja ekí shizhiji aksaldinatshak, ezua paldiseyuja ajuxa abuzatiakue akbeyatshak amak neñgueniki zaldiamak yaté. ");
INSERT INTO kog_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Duweki asanákue zagáñga itshizhamak itshizhagába, zapanká tuatshakna paldiseyuja: “¡Sakí anuñkabé atshakue tuñká!” na jañguá. ");
INSERT INTO kog_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Guake Duweja ekí axaldék: —Maiñ paldiseyukuañki abak nuxa sha atshabíne ga mizhekuéñ na, mimijí aldunaldi zʉnake shanegaba atshiji zhekualdi na, saldiñga mimijígaba naldakue mijañguxa. Akna jaldu, puti abakaldeldi za iyajishka, sʉkldiñki iyajizhazhé jana ni miná. ");
INSERT INTO kog_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ekí agatsaldi izhoshi na, alduna miñkaldegagáldekue jana ni miyatshí. ¿Ekí miñsʉ́ñ shi naldaka na? Jate káguba abuá agakauwanejañga guana alduna jiaga agenane. ");
INSERT INTO kog_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Akna abak nuxa Jatek akldunamak mizhuka ga izhogagábaki, aldunaxa akldunamak izhoshi na, ji miñkaldé nashikuek miyagaunexaldixa. Ekí miyatshatshakna, Jateja tiuwiñki miñgatsauxa janshi ishkazguamine mizhekualdaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","”Wau wau wau maiñ paldiseyukuek ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Maiñki jigaba nóñgutsekue aldubenu azhi jika we akzukualdixa jiba agabeñka uguá agatsalda miñkaldaldaldiake, ezuañki Jatek miyageka. Ekí atshakue miñgatsahamak atshabinogéñ, guiyabajañga jiak akldé akzé atshakue guaká miñjuizhanakí atshalga nogakue ne, ai zʉnake amak atshabíne. Ai akzé atshakueki Saldiñga netshi Jate izhgajañgui, kágubakue kaxatshakue miñgatsahamak kaxatshiji izhogakue miñgatsé nakldá. ");
INSERT INTO kog_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","”Wau wau wau maiñ paldiseyukuek ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Juwí izhajuizhaldegeñka mineyatshak, akldé akzekue iyaldageñka iyaldagazhá guasʉ́ñ miñzekakue. Ekíga na, káguba zheneñka mineyatshak miñkabeti mual za miñkazguagakue mitshanka nak. ");
INSERT INTO kog_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","”Wau wau wau maiñ paldiseyukuek ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Káguba shuane kagi iyashanéñ ezuaja akldegakíñga itanatshak sʉkldiñki galdune itanamak jana, maiñki abak nuxa na sha atshabíne ga abeldashi mizhogéñ na aldunaldi zʉnake nusagatsegaba mijañguxa nak. ");
INSERT INTO kog_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ekí nukatshakna, ezua asanátshi guiyaba muldetua akuéja akiyó: —Duwe, ekí makuagatshake, nasʉñ jiaga sha zʉñkaldeshi guashibaldá. ");
INSERT INTO kog_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Guñguake Duweja akiyó: —Wau wau wau maiñ guiyaba shi mizhixakuek ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Maiñki guiyaba zʉñkabajaneja guagauxabé shizhiyagábaki, zʉxaita amak ajanashaksá zalda shizhiji na, axautshikue amak ashekualdaldiamak nauwa nuxaki kagaunexabíne. Aiki jika juat guasá akzé ezuaja uldeyaldiamak mikauwatshak, ni nauwa ai uldeji agaunexabíne jana miyatshixa ni miná. ");
INSERT INTO kog_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","”Wau wau wau ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Maiñ Jatetshi múldigaba naldiñga zʉxaitshixa nanekuetshi abuá abexaneñka jigaba janshagatse miyagakauwatshak jiaga, sakí atshakue akuaká amak axatshabíne nak. Ne mimibamakuejañki aikue akuaxa akuanane. ");
INSERT INTO kog_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Akze, mimibamakueja ai Jatetshi múldigaba naldiñga zʉxaitshixakue akuaxananekuetshi abuá abexaneñka jigaba janshagatse miyagakauwatshak zhinik na, “nauwibamakueja janshibeñga ni kakuaxaná” mijañguxá awatuñshi ekí miyatshixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","”Ekí miyatshaldixa akualdiñga, Jateki akaldak izhikué izhogamakga ekí guakldane: “Nasga nají múldigaba guaxal gaxanaldikue, nají múldigaba naldiñga zʉxaitshixakue juldiú sanákuek kagakaxanaldikue na, ezuakueki sha kakualdixa, ezuakueki kakuaxa kakualdixa niyó.” ");
INSERT INTO kog_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ekí nakna, Jateja kagi, káguba gauñguenik zhinik kaiga yo, ají múldigaba naldiñga zʉxaitshixakue akuaxananauxa shalda maiñ kaiga zhekualdabinukakuañ miñgatsaldi ne mimatualdixa. ");
INSERT INTO kog_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ekí akuaxanekue na, Abél kasak misha akuaxá guanane. Guñguenik exa zhinik panane ekí kakuashiñga, nauwibama Sakaldiyak yo akuaxanane. Eñki Jate axazakuagaldi na, aldéñ jika akiyayogeñka na zhikyokuéñ akuaxanane. Akna saldiñga ai akuaxanekue shalda na, maiñ kaiga zhekualdabinukakuañ Jateja miñgatsaldi ne mimatualdixa ni miñmeñkú. ");
INSERT INTO kog_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","”Wau wau wau maiñ guiyaba shi mizhixakue ¡sakí guiyaba mitualdixa ne! Jinake naldakí. Maiñ Saldiñga netshi Jate “me ne” miñkué naldatshak, axautshikueja akualdazháldiamak miyagitamakuxa. Ekí atshiji na, Jate nugeñka mijuldunaldiamak yabi miñkaldé ne jiaga, maiñga juldunabíne, ni axautshikue juldunaldiamak akpexabíne jana miyatshixa nibiná. ");
INSERT INTO kog_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ekí kakbeñgueniki Duwe Jesú ai zhinik ne. Atshak zhinik na, asanátshi guiyaba shizhixakue, paldiseyukue juizhi kalzauldi, kagualdiji ashekualdi na, muldetua yokuasʉ́ñ agatsaldi agazaldukshiñgaba na ashekualdá. ");
INSERT INTO kog_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jinake naldakí. Miyagabaki yokuasʉ́ñzamak kakiyokuatshak zhinik na, agatsé ne iyazhakuaxaldixa aldiyatoguák. ");
INSERT INTO kog_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Atshaga na, kágubakue matshuuwi, izatasá zalda Duwe Jesú aldukaldiamak ajuizhaldeshi na, muldetua agubisha dañ izhatana zalda ajuizhaldék. Ekí ajuizhaldegatoguéñ na, Duweja aldéñ shaxaldixakuek misha ekí kakbeyaldá: “Paldiseyukueki abake sha atshagáldekue ga abeldashi ashekuakna, maiñ kauwizhéñ janañga izhoshi guamiñnegak muldetua numañ miyatualdí. ");
INSERT INTO kog_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Akze, ji ziñ me nanaldixa auxaga muetsexaldixa. Ekíga na, ji meja aksʉ́ñ nanaldixa auxaga muetseshi, washexaldixa. ");
INSERT INTO kog_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ekíga na, maiñ ziñ me miñguaká aldiweki saldiñgaja aldukandana akuaxaldixa. Ekibeñga na, nukasʉ́ñ me mizhikbeñká aldiweki saldiñgaja akualdaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","”Napebukue, ekí miñmeyaldikue: Maiñ kágubakue nuxa zhe miñzukuagába. Akze, ekuejañki mimijí abuá za guagaka, naldatshak aldunaldiñki sha mimakuazháka. ");
INSERT INTO kog_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ne me zʉnake zhe miñzukuakue miñmeyaldikue. Eñki Saldiñga netshi Jate aldéñki abuák mimakuagaka, aldunaki jiséxa, guiyaba tu za nogakueñka gagaka nak, e zʉnake zhe miñzukuakue giemi miñgatsé nakldá. ");
INSERT INTO kog_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","”Naldatshak jiak aldéñga na muldetua numañ mimatuñka. Akze, kágubaja tuwiñki nubábuldu muldetua akzaldazhé jañgui na jatshiwa nubá muneda nauwamé akzék nabeyasatshak jiaga, Jateja zʉnake ni ezua zhikjuizhansha naldakí numañ katuwiñga izhuka. ");
INSERT INTO kog_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne maiñ míñgaki nubábuldu zhakaldak miñzé minahakna, Nauwijatek muldetua auxaga akualdi na, mimijí sai mitsá agatsalda minduka jiaga auxaga miyakué. Akna zhe miñzegagába mizhekualdaldí.” ");
INSERT INTO kog_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Guñgueni Duweja: “Ekí miñmeyaldikue: Mieldejañki ‘naski Duwe Jesú namak jañgui, agapa neñkugé nakldakú’ kágubakue nogéñ guaxaldiák jiak, nas Jatetshi Asukuága ixagabaldekldugek ekíga Jateja guaklde uldeñkakue nogéñ ‘eñki nagapa neñka, najíga nakldá’ guaxaldikue. ");
INSERT INTO kog_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ekí ne, mieldejañki ‘naski Duwe agapa neyazhúge nakldakú’ kágubakue nogéñ guaxaldiák jiak, nas zhinik ekíga Jateja guaklde uldeñkakue nogéñ ‘eñki nagapa neyazhé nakldá’ guaxaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","”Guatshak mieldeke nasga Jatetshi Asukuá ixagabaldekldugek aguáñ nezhbashi mual nalda naguaxaldiák Jateja axabetaka. Ekí ne, mieldeke Jatetshi Alduna aguáñ izhbashi mual nalda aguaxaldiák zʉnake, aiki Jateja axabetazháldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","”Guatshak mitsakgaba nepanamine shalda izhajuizhaldegeñka azhi sanekakue izhajuizhaldegeñka miñgatsé ne mimawatualdieñka mimawaldeyatshak, ‘¿Sakí zhikzukuaxaldikue ne? ¿Sakí agatsaldi guaxaldikue ne?’ ijanagába. ");
INSERT INTO kog_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Akbiñgaki guagakue miñgatsegatshake Jatetshi Aldunajañga sakí guagakue miñsanexaldixa nak.” ");
INSERT INTO kog_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Káguba matshuuwi ashekualgué kenañ, ezuajañki Duwek ekí akbeyá: —Shi maldazʉñkaldixa, nauwijateja bieni zʉñkabajane ne, ji ipanakue nagatséki natuwék nagegakue makbeyaldí. ");
INSERT INTO kog_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Guñguake Duweja akiyó: —Ne naski ¿meja mieldeki ji bieni ipanakue agatsé azhi agatsaldazhé zhikwatiji gexaldikue niuwi nagaxene shi maldajañgú? ");
INSERT INTO kog_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ekí akbeñguenik saldiñgake ekí kakbeyá: —Be noshi muldetua numañ miyatualdí. Jika mimijígaba naldakue miñnexa za itshanabináldi. Jinake naldakí. Jika zʉ́xaita mixaldegatshak jiaga, auxabé mikzeshi zeñ mizhokshazháka nak. ");
INSERT INTO kog_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Guñgueniki ai shaldaga ezua ajanashakldegéñ zhinik shi kaxaldiyaldá: “Ezua sigí kabia nalgué ají tek matshuwi gakue nekshá. ");
INSERT INTO kog_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ekí nekshatshakna ekí jañguá: ‘¿Mani mexaldikue, gakue matshuwi naxaldeká? Numa jubeni miya akldé megakue naxaldaldaksá guxá.’ ");
INSERT INTO kog_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Guñgueni ekí jañguá: ‘Sakí atshanaka au jañguá ni gukú. Nají numa jube tiñguá gualdikueniki, akldé atemajañ gauwaldikue. Ekíki eniñgaba nají numakue, gakue juizhi ishkibexaldikuamak. ");
INSERT INTO kog_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ekí ishkibexaldatshak, matshuwi kagi jibatsháaki nakldunamak izhoxaldakuká gualdixa. Akna zhiksekui, ai gakue za na gaji, ai za na tushi, zeñ nakldeshi izhoxaldikue shakldá’ na jañguá. ");
INSERT INTO kog_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","”Guatshak Jatejañga ekí axaldék: ‘Mañki jañguabáldega ni ekí majañgú. Kaiga sesʉñga mashuixaldixa nzha. Amak mashuigatshake ekí numa ishkibexamaldeki ¿metshi abaldixa shi majañgú?’ ");
INSERT INTO kog_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","”Ekibeñga na, mielde axaldáñ za jika axaldaldaldiamak niji izhoxaldiák, ai kabia agisanamak agisaldaldixa. Ekí izhukaki Saldiñga netshi Jateja akzé tuñka niyazhé nakna, Jateja akzé tuazháldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ekí guagatogueniki aldéñ shaxaldixakuek ekí kakbeyaldá: “Akna ekí miñmeyaldikue: Izhogexañ ji miñgaldixa, ji mitshualdiyaldixa za ijanabináldi. ");
INSERT INTO kog_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Akze, izhoxa guana gakue zhakldé akzé naldashá. Ekíga abuá guana zhakuá zhakldé akzé naldashá. ");
INSERT INTO kog_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nubákue tu kuizguí. Gakue ishkiyaldigakí, ni ishkakugakí, ni mani ishkiyabegaka kaxaldaldakí aldaldatshak jiaga, Saldiñga netshi Jatejañki auxaga kakauwatuka. Ne maiñ míñgaki nubákue zhakaldak Jateja miñzé mimatuwi zhinik muldetua numañ mimatualdixa. ");
INSERT INTO kog_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Azhi maiñ miñnekáki, nauwañgaba akldé mizhoxaldiamak za ijaná minogatshake, ¿akldé amak izhó miñzék guaka shi mijañgú? ");
INSERT INTO kog_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ai nóñgutse me nuxa ijaniñgaba miñguatshak atshazháminaka ne, ¿jinak shi jika miñgajueshká shalda ijaniñgaba mizhekualdaldixa na? ");
INSERT INTO kog_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","”Kaigaki kaljumshi sakí jumaldeka kuistuwí. Aikueki jiba ishkajanasháaki, ni zhakuá izhgauwáaki jiaga, zʉ́xaita janshagatsekue jumaldeka. Naldatshak ekí miñmeyaldikue. Nauwibama Saldamóñ kabia zhakuá janshagatse ijuakue nane, ne kaljumshikueki e zhakaldakga janshagatsekue nakldá. ");
INSERT INTO kog_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Akze, kaljumshikue mitsá zegagá nuk kanatshak ayoxaldixa jiaga, Nauwijatejañga ekí janshi axazguxa. Ne maiñ míñgaki kaljumshikue zhakaldak ji mitshualdiyaldixa miñgexaldixa naldashá. Ne ¿jinak shi ‘Jate numañ natualdixa shakldá’ alduna ishakí miná? ");
INSERT INTO kog_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","”Ekí numañ mimatuaka nakna, maiñ ji miñgaldixa, ji mituxaldixa za niji, ijaná noxabináldi. ");
INSERT INTO kog_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Akze, Jate jañguazhékueja ekíga ji kagajueshka za niji ashekue. Naldatshak Mimijate jékaldaxa izhukajañki ji miñgajuezhatogauxa akuegaba nak ekí ijanakue miñgatsaldakí. ");
INSERT INTO kog_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ne Saldiñga netshi Jateja auxaga miñsanexaldixa za niji mizhekualdaldí. Ekí aldéñ za miñsanexaldixa niji mizhekualdaldiakna, ji miñgajuezhauxa miñgexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","”Maiñ shi minagitixakuañ anuñkabé minaldatshak jiaga, zhe miñzegagába. Jinake naldakí. Saldiñga netshi Jate, Mimijatega akldunamak, aldéñ na misanexaldixa mimajañguane nak. ");
INSERT INTO kog_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ekí nakna, jika miñkaldé nabesá miñgualdiniki aiki nashi jika agajueshkakuek kakauwi miñgualdí. Ekí miyatshaldiakna, jékaldaxa numa akzekue ishkibeshi miñguxá jana Jateja saldi guazhíta janshizhe miñkatshaldixa. Aiki miñsaldinazhíta, tushekaja mintushegazhíta, ni zumbúja jiaga miñgazhíta nzha. ");
INSERT INTO kog_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Akze, ji akldé akzé mijañguxa naldiake, eñ za alduna kaumine mizhekualdaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Guñgueni Duweja mokue ekí shi kaxaldiyaldá: “Maiñ Jate miyaxazauwaldiamak muldetua sezhgaumine, muñshí zukuxa zuñguamine za minoxaldí. ");
INSERT INTO kog_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Akze, nashikueja kauwijí sáñkalda ezua abuzál neyaldinik mitsá zegatshak mokue naxaldixa kaksʉ́ñ jiaga, juwí axagapexaldiamak jiaktuaté aldogamakbe, maiñ muldetua jinaktuaté minoxaldí. ");
INSERT INTO kog_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Akze, nashikueja kauwijí sáñkalda nenaldinik mokue nagatshak jiaktualga te katuatshakna, zeñ kajañgualdixa. Ekí kajañgui na kaxazauwaldiamak janazhiktualdinik, ‘zaxañ yate guwíñ’ kaxaldexaldinik aldéñ naldi gakue kagakshaldixa nakldá namak ni miñmeñkú. ");
INSERT INTO kog_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Akze, kauwijí sáñkalda mitsá zegatshak naxaldi, semuanté, azhi naki muñzeshi naxaldiák jiaga, jiaktualga te katuatshakna, matshuwi zeñ kajañgualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","”Akze, ekí miñkualdakue. Juwítshi ajáugukuija mitsá zegatshak tusheka naxaldixa akualdi nuka guashiñki, iyatushexal axagajulduni guakuak jiaktuaté nogaka naldashá. ");
INSERT INTO kog_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ekibeñga na, maiñ muldetua janazhiktumine za mizhekualdaldí. Jinake naldakí. Nas Jatetshi Asukuága ixagabaldeklduge mitsák mokue kagik naxaldikue miñsʉ́ñ noxaldieñga naxaldikue nak.” ");
INSERT INTO kog_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ekí kakbeyatshak, Péguldujañki ekí Duwek aklduká: —Duwe, nashi atshakldegéñ zhinik shi zʉñkaldiyamaldeki ¿nasʉñ za shi maldazʉñmé, azhi saldiñga juizhiñga zʉñmemalde sha? ");
INSERT INTO kog_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Guñguake Duweja mokue ezua ajanashakldegéñ zhinik akiyó: —¿Mieldek shi nashi akldé akzé muldetua jañgua atshixa izhuka nak ají sáñkaldaja alduna ishaka jana minaldaldixa na? Ai nashi na ají sáñkaldaja mani neyaldá gualdiake, ají nashikue numañ agatuwi, zakukatshake gakue kakauwakue agatsahamak kakauwaldiamak izhaka. ");
INSERT INTO kog_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Amak izhashi nenaldinik, sáñkalda mokue nagatshak, ai nashi sakí atshakue akbenamak axatshaté tuatshakna zeñ jañguxa. ");
INSERT INTO kog_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Namak miñmeyaldikue. Sáñkaldaja ekí ají nashi amak axatshaté tuatshakna, jika axaldauxa numañ agatualdiamak izhaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","”Azhi ai nashiga ekí jañgui guashiñki, “nají sáñkalda maldé me nagazháldixa shakldá” akldeshi axautshi nashikue, munzhikue, sigíkue juizhiñga kabugapanaka. Aldéñ za na zaji, stushi nuxa izhogapanaka. ");
INSERT INTO kog_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ekí atshatogeñga sáñkalda mitsá zegatshak naxaldixa aksʉ́ñ, jiaktuakí noxaldieñga naxaldixa. Ekí sáñkaldaja ají nashi amak axatshazháne tuatshakna, guiyaba kaxañ atemajañ tuñshi na, Jate jañguagáldekue guiyaba atuatogeñkaga gaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","”Akze, mielde nashiki ají sáñkaldaja sakí axatshakue jañguxa akshá nogatshak jiaga, amak axatshakí, ni amak axatshaldixa janazhiktuakí naldaldiák zʉnake, ají sáñkaldaja kaxañ atemajañ guiyaba tuñshaldixa. ");
INSERT INTO kog_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ekí ne niñkauwañki, ezua nashiki ají sáñkaldaja sakí axatshakue jañguxa aksʉ́ñzaldi amak axatshakí naldaldiák zʉnake, ají sáñkaldaja aguáñ agatsaldi guiyaba tuñshaldixa. Ekíga na, Jateja mieldeke akldé zeñ jañguane naldaldiake, aiki akldé amak axatshakue agatsé tualdixa. Ekibeñga na, mieldeki ají jiba akldé akzé axatshaldixa alduna ishaneki akldé amak axatshakue agatsé tuñka nakldá. ");
INSERT INTO kog_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Guñgueni Duweja ekí jiaga kakbeyá: “Naski jai kagik guksé zuñgual jana naklduge. Aiki Najateja káguba sha atshane shalda guiyaba tuakue kagatsé katualdixa. ¡Ai na mijá zegakuéñ jañgui izhokuge! ");
INSERT INTO kog_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ne ai zegagáñgaki nas naldi na guiyaba tuwi, shuigakue nagatsaldaldixa. ¡Ai na mijá zʉxaitakuéñ nakldeshi, itshani izhokuge! ");
INSERT INTO kog_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","”Maiñ minajañguxáki ¿kágubakue askuiñgaba kakldeshi, señgaba zhe kaldokshal kagik naklduge shi minajañgú? Naldagálde, ekí atshál nagazhánuge. Ne kágubakue sha sha kakldekshal naklduge. ");
INSERT INTO kog_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Akna kaiga zhinik zhuajúk zaldagaba jatshiwa aldé ne, maiguaki namak najañgui, jiak guatshak mozhuañki namak najañguazháldi na, nashaldá sha sha kakldexaldixa. ");
INSERT INTO kog_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Akna nashaldá ajateja asukuá aguldiyamak jiak, asukuája ekíga aguldiyaldixa. Ekíga na, ajabaja abunzhi aguldiyamak jiak, abunzhija ekíga aguldiyaldixa. Ekíga na, akagija ajuazi aguldiyamak jiak, ajuazija ekíga aguldiyaldixa nakldá” na aldéñ shaxaldixakuek kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Guñgueniki saldiñga kágubakuek ekí kakbeyaldá: —Maiñ se taniñgaba guaté mituatshak “níxalda zexaldixa tiuwi” guakbinaldixa amak zeka. ");
INSERT INTO kog_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ekíga na, múlkalda guañgua zaldi zhinik nagaté mituatshak “guañgua zexaldixa tiuwi” guakbinaldixa amak zeka naldashá. ");
INSERT INTO kog_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Akze, maiñki alnobaxa, mauwik me níxalda zexaldixa azhi guañgua zexaldixaki tuminaka. Naldatshak Jate “me ne” miñkué ga abamildakakue, kaiga ldiuwañ nas atshaté, shizhiyaté minatuatshak jiaga, Najateja ji mimatuñshindana akzeka ¿sakí shi tuakí miné jana miñgajienakí na? ");
INSERT INTO kog_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","”Ne maiñgabaga Jateja sakí jian atshakue mimajañguxá jañguakue miñgatsaldashá. ");
INSERT INTO kog_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Akze, mitsakgaba ezua sha axatshamaldeja mezhguaklde migatsaldi ne matuakue nugeñka mauldeyatoxaldiéñ sezhgauwakue niji makualdí. Azhi sezhgauwakíñga mauldeyaldiák guashiñki, aldéñga migatsaldi ne matuakuek makizhañkashaka. Gualdiake aijañki ají kabukuek kalseldi mabexal kakbeyaka. ");
INSERT INTO kog_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Akna ekí mikbeyaldikue. Ai sha axatshamalde na sezhgauwakí maldaldiák, sha atshamalde shalda mitsá ilzabiyakue majañguanauxa ilzabiyakíñgaki kalseldi zhinik makzʉxaitshazháldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Atshaga na, Duwe Jesú tual nenekueja ekí agabeyá: —Anuñka nauwisaná Galdildeya zaldakue Jatek béyakze axakuagatogueñga, sáñkalda Pildatuja niuwi genalguamak eñkaga kakuaxá guane nakldá. ");
INSERT INTO kog_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Guñguake Duweja kakiyó: —Guatshake kakuaxanekueki ¿axautshi Galdildeya zaldakue zhakaldak sha ajanashixa nalguák shi amak kakuaxane mijañgú? ");
INSERT INTO kog_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Naldagálde. Sha miyatshixa majiñga maja, Jatek agakualdinakí minaldaldiák, maiñ jiaga ekíga mishuixaldixa nakldá ni miñmeñkú. ");
INSERT INTO kog_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ekibeñga ezua juwí wézhilduka Sildué axezhogeñka tinatshak, Jeldusaldéñka zaldakue 18 guaxanane. Ne ¿aikueki axautshi exa zaldakue zhakaldak sha ajanashixa nalguák shi ekí ashuanane mijañgú? ");
INSERT INTO kog_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Naldagálde. Sha miyatshixa majiñga maja, Jatek agakualdinakí minaldaldiák, maiñ jiaga ekíga mishuixaldixa nakldá ni miñmeñkú. ");
INSERT INTO kog_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Guñgueni Duwe Jesúja ezua atshakldegéñ zhinik shi kaxaldiyaldá: “Ezua sigíja ají tek ezua kaldi zhenka na axakldoxá. Nalgué na kalwé kuiyaldiamak neyatshak, ni ezua akldikualdakí tu. ");
INSERT INTO kog_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ekí tuñguakna ají nashi te numañ tuñkak ekí akbeyá: ‘Kalwé bual maigua kagiga tual naxaldatshak jiaga, ni ezua kalwé tuakí naugakna meñguá makualdí. Egaba abái nuxa akté nzhok.’ ");
INSERT INTO kog_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ekí akbeyatshakna akiyó: ‘Duwe, janshibé jañguamakuashíñki, kaigabeñga meñguagába akté shi noshí. Nas kaiga zhinik mokue ezua kagi maldi, kagi akzheñgui, numañ tualdikue. ");
INSERT INTO kog_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Atshak zegatshake zhenapana gualdiake majakualdixa. Ne zhenazhá gualdiák zʉnake, meñguakualdixa nzha.’” ");
INSERT INTO kog_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kauwisaná zhigasekué ldiuwañ zegatshake, Duwe Jesúki juwí izhajuizhaldegeñka na shizhiyatoxá. ");
INSERT INTO kog_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Exaki ezua munzhi jisétshi alduna ijuldú guenik 18 kagi itsé. Ai aldunajañga ají mukshíñkalda me axazguá guane nak, jian atshaksá giemi guane na izhoxá. ");
INSERT INTO kog_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Duweja ai munzhi tuatshakna, nagakue akbeñguenik ekí akbeyá: —Munzhi, jisétshi aldunaga ekí mixazguane nak, kaigaga mibesanshaldatshakna jian mixazguá ni gukú. ");
INSERT INTO kog_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Akbeji káuxalda ipañguatshaga jian axazguatshak, Jate “zeñ nzhakldék” akbeyaldá na gua. ");
INSERT INTO kog_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Naldatshak, ai juwítshi sáñkaldaja Duweja izhgasekué ldiuwañ munzhi jian axazguaté tuatshakna, itsauldi ekí kágubakue kaxaldék: —Semana akldañkajauxa tezhuwa ldiuwañ me jibatshakue. Akna mulbatá mimeyazaxaitshaldiamake atshak za nagakue, ne kizhiksekué ldiuwañki nagasé ni za mitú. ");
INSERT INTO kog_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Guatshakna Duweja ekí akiyó: —Maiñ guiyabaja guagamak miyatshixa ga abamildaka. Akze, kizhiksekué ldiuwañ jiaga mimijí buldu, azhi mimijí bue axawati miñgualdinik ¿ni akauwal miyuldeñkaga naldabíne shi na? ");
INSERT INTO kog_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ekí ne, jalde munzhi zʉnake nauwibama Abaldahámtshi atukuaga ne jiaga, jiséja shaktene jana jian atshaksá gueni au 18 kagi itsekuatuka nak, ¿ai ldiuwañki shakjuishi jana se akzukuasʉ́ñze shi naldaldixa na? ");
INSERT INTO kog_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ekí kakbeyatshakna aguldiñkakueki jiwak kakzukuá. Guatshak azhinik zʉnake Duwe ekí atemajañ janshizhe atshaté atuatshakna, zeñ kakldeshiñgaba na akuá. ");
INSERT INTO kog_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Guñguenik ekí shi kaxaldiyaldá: —Saldiñga netshi Jateja káguba kaksanekakueki, ¿ji jana ne, azhi ji jana izhalteka shi miñmeyanaka na? ");
INSERT INTO kog_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Aiki, ezua zulda, sigíja ají tek nixaldinik kaldi zhuxañga guildegatshake, gulda matshuwi axabunatshigake, exa nubákue iyaldakakue naldashá. ");
INSERT INTO kog_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Guñguenik mokue shi kaxaldiyaldá: —Saldiñga netshi Jateja káguba kaksanekakueki ji jana saldiñgak axajiuwaka aldé miñmeyaldikue. ");
INSERT INTO kog_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Aikueki naku jana nekue. Nakuki ezua munzhija gakuek nauwañgaba itsheñguanaldixa zhikbegatshak nuk agaldaka naldashá —ekí na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Guñgueni Duwe Jesú Jeldusaldéñ neñká neyatoguéñ, kuíbulduk zʉxaitauxa shizhiyatoguéñ ");
INSERT INTO kog_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ezuaja ekí aklduká: —Nají Sáñkalda, ¿Saldiñga netshi Jatejañki káguba anuñkamé nuxa kekualdaldixa shi na? Guñguake ekí akiyó: ");
INSERT INTO kog_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Jate sanegeñka julduneñki niñpokuéñ nak, ai ga juldunakue kama ilshiji miñgualdí. Jinake ekí miñmeyakí. Matshuwi nekueki exa ajuldunaldiamak aldiyatshak jiaga, ajuldú kakzegazháldixa nak. ");
INSERT INTO kog_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Akze, juwítshi ajáugukuija izhgaldaxaldinik juwí akyogamakbeñga, niuwizhíne Jate sanegeñka juldunéñ agayogatshake jubaldeldiñga abaminekueki: “Nauwijí Sáñkalda, juwí zʉñgakpé ni guakuá” jaldáñ ekí miyagakuañnegatshak jiaga, ekí miñkiyokualdixa: “Naski mimatuazhúge, mani zalda ska miná.” ");
INSERT INTO kog_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Guatshakna ekí miyakiyokualdixa: “Duwe, nasʉñki ma na zatoñkalde, nauwijí kuíbulduxa shi zʉñkaldiyatomalde naldashá.” ");
INSERT INTO kog_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ekí miyakbeyatshak jiaga ekí miñkiyokualdixa: “Naski mimatuazhúge, mani zalda ska miná. Maiñki sha miyatshixakue minák, nuk nagajué zhekualdatogwíñ.” ");
INSERT INTO kog_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","”Ekí mimajuldukshazhánekue Jate sanegaldi, nauwibamakue Abaldahám, Isák, Jakóp, saldiñga Jatetshi múldigaba naldiñga zʉxaitshixa nanekue eni Jate nañga ashé mitualdixa. Ekí mituatshakna, jubaldaxa abaminekue zʉxaita mauwi za miyabaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ne eniñga na, saldiñga saná kagi maxáiñtaba izhgekuauxa zaldakue aldaxaldixa. Ekue na Jate sanegeñka ajuldunatshakna, atemajañ zeñ kakldeshi abuazál iyaldaxaldixakue. ");
INSERT INTO kog_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ai ldiuwañga na, kaiga ai itsaldagálde axajankakue nanaldixa, Jate sanegeñkaki anuñka aikuega akldé akzekue naldaldixa. Ekíga na, kaiga akldé akzé axajankakue nanaldixa, Jate sanegeñkaki anuñka aikuega aguáñ akzekue naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Atshaga na paldiseyukue aldaguenik, Duwek ekí agabeyá: —Sáñkalda Eldodeki makuaxaldixa majañguakna, jai zhinik awaxani izhakui guwá. ");
INSERT INTO kog_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ekí agabeyatshak kakiyó: —Ejié Eldode kalkalda piyu jana axautshi agisalsha izhate guanek ekí miyakbeyaldí: “Naski nají jiba nuk saldikshagá nokugakna, kaigabeñki mulbatá kakzekakue se kakzukui, jisétshi alduna ijuldunekue izheñshi izhoxaldikue. Ekí atshijiñga na, nauwa axañga nají jiba saldikshaldikue nzha.” ");
INSERT INTO kog_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Saigaba zegatoxaldiák jiaga, kaigabeñki Jeldusaldéñka neyateñga nogakue nagatsé. Jinake naldakí. Exa guana Jatetshi múldigaba naldiñga zʉxaitshixakue kakuageñka zak, nas jiaga exaga shuigakue nagatsaldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","”¡Jeldusaldéñ zaldakuañ, mitsá maiñ shalda itshaniñgaba izhokuge! Najateja ají múldigaba naldiñga zʉxaitshixakue miñgakagatshak, maiñki sha kakuí, kakuaxa, atshuake jagi kebushi kakuaxa miñguxa. Naldatshak shentája ají awawakue agikalda sʉkldi numañ katuwamakbé, mitsá juizha naski numañ mimatundana nakzegatshak jiaga, amak mimatuasʉ́ñ najañguamine. ");
INSERT INTO kog_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tu guwíñ. Numañ mimatuasʉ́ñ miñzegakna, Jate mimihezua mimabaja gui na, mimijí kuíbuldu nuk miñkibajaldixa. Ekí miñmeyaldikue. Maiñki “¡Jate, nauwijí Sáñkaldaja atsaldí zʉñgakaxaneki, aldéñga zeñ shi jañguí!” guagakíñgaki mokue natuabináta nzha —na guaxá. ");
INSERT INTO kog_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ezua ldiuwañ kauwisaná izhgasekuéñ zegatshak, paldiseyutshi sáñkaldaja Duwe Jesú ajuxa abuzatiakue akbeyatshak amak ne. Exaki paldiseyukue, guiyaba shizhixakuejañki Duweki jigaba shalda izhakuaxaldixa ajañgui na atuaté aldoxá. ");
INSERT INTO kog_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Exaga ezua sigí mulbatága jizhá akzeka Duweja abuán ité tuñguakna, ");
INSERT INTO kog_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","paldiseyukuek, kauwisanátshi guiyaba shizhixakuek ekí kaklduká: —¿Jateja jian izhoxa guiyaba nauwibamak zʉñkabajaneja kizhiksekué ldiuwañki mulbatá akzekakue iskaitshakue azhi iskaitshasé zʉñmeñka shi mijañgú? ");
INSERT INTO kog_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ekí kakldukatshak jiaga akiyayokuazhá. Guñguake Duweja sigí káuxalda ipañguatshaga se akzukuñgueniki, “neyabikuká ni gu” akbeyá. ");
INSERT INTO kog_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Guñgueniki mokue kaklduká: —Kizhiksekué ldiuwañ jiaga ¿mieldeke mimijí somá, azhi mimijí bue pokuéñ miñgakjienatshak, ubañga mibekshixa naldazhé sha? ");
INSERT INTO kog_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ekí kakbeyatshakna sakí akiyayokuakue atuakí na naldá. ");
INSERT INTO kog_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Exaga na, paldiseyuja abuzatiakue kakbenekue amak aldagatshak, kauwizhéñga akldé akzé yaldagéñ iyaldaxaldiamak ishkakugaté Duwe Jesúja katú. Ekí katuatshakna, ezua ajanashakldegéñ zhinik ekí kakbeyá: ");
INSERT INTO kog_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ezua numa aldexaldiéñ niuwañki kabuzatiakue mikbeyatshak eñka akldé akzekue yaldaxaldieñka yaldagagába. Jinake naldakí. Ezua mizhakaldak akzé abuzál nagakue akbene nagakaga. ");
INSERT INTO kog_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ne amak nagatshak tuatiakue mikbeneja “jalde yaldaxaldiamak mañki izhgaté guwá” mikbeyatshakna jiwak mikzeshi, aguáñ akzekue yaldageñga yaldagakue migatsegakaga nak. ");
INSERT INTO kog_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Akna abuzatiakue mikbeyatshak eñka aguáñ akzekue yaldageñka miyaldaxaldí. Ekíki tuatiakue mikbeneja “napebu, jai akldé akzekue yaldagéñ agaskaitá guwá” mikbeyaka. Ekí mikbeyaldiakna, abuzál nakldekueja akldé mikzukuaté matuakaga nak. ");
INSERT INTO kog_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Akze, mieldeki axaldáñgaba akldé zhikzukualdiák jiak, Jateja niñkauwañki aguáñ izhbashaldixa. Ne mieldeki axaldáñgaba aguáñ zhikzukualdiake jiak, Jateja niñkauwañki akldé akzukualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ekí kakbeñgueniki paldiseyu abuzál nagakue akbenek ekí akbeyá: —Mitsakgaba mibuzál nagakue majañguatshak, akldé mipebukue, mikajakue, misanákue, azhi kabia mikyó izhukakue za nuxa mibuzatagakue kakbeyabaldáldi. Jinake naldakí. Jiak, kauwizhéñ zhinik amak kabuzatiakue mikbeyatshak, mikizhakualdiksha guaka nak. ");
INSERT INTO kog_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ne mitsakgaba mibuzál nagakue majañguatshak, nashi jika agajueshkakue, agisalkakue, kalda isékue, uba isékue mibuzatagakue kabakbeyaldí. ");
INSERT INTO kog_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ekí matshaldiakna Jate zeñ majañgualdixa. Akze, kauwizhéñki mikiyushazháka ne, Jateja niñkauwañki auxa zegatshak jian izhoshi shuanaldixakue kezhgaldakshaldixa ldiuwañ atemajañ janshizhe mixatshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ekí nukatshakna, ezua aiga zatoxéja Duwe Jesúk ekí akbeyá: —Auxa zegatshak mieldekueki Jate aldéñ sanegeñka abuzál kajuizhakualdixakueki ¡mitsá zeñ naldaldixakue ne! ");
INSERT INTO kog_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ekí guaguakna, Duweja ai shaldaga kakbeji na, ajanashakldegéñ zhinik ekí shi kaxaldiyaldá: —Atiuwiñ zalguéñ, ezua sigíja matshuwi nekue abuzatagakue guaklde nalguák, gakue matshuwi janakagaktú. ");
INSERT INTO kog_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Guane nalgué zakukañguake, tuatiakue kakbenekuek ají nashik ekí kakbeyal gaxá: “Au gakue saldi janaktú gugakna shaldashí ni mimakuák.” ");
INSERT INTO kog_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ekí kakbeyatshak jiaga, ezua, ezuaja jinak aldeyazháka akuák. Kasakldejañki: “Naski kaiga nuxa kagi izhgajabi gugakna, ai tual neyakue nagatsakna mijí sáñkalda naxabetá ni gualdí, neyazhá gugák.” ");
INSERT INTO kog_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ezuajañki: “Naski kaiga nuxa uguá bue izhgajabi gugakna, ai tual neyakue nagatsakna mijí sáñkalda naxabetá ni gualdí, neyazhá gugák.” ");
INSERT INTO kog_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Guñgueni mokue ezuajañki: “Naski kaiga nuxa numaldék gugakna neyazhánaka ni tuñkú.” ");
INSERT INTO kog_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","”Guñguake nashi gaxanalgué ají sáñkalda nugeñka neyenik axaldekldauxa akbeyá. Ekí akbeyatshakna, itsauldi, ají nashi mokue ekí niuwi agé: “Mijá kuitnegwá. Kuíbulduldi, jiúñguldeldi, nashikue, agisanekue, uba isékue, kalda isékue matuauxa zal nagakue makbeyaldí.” ");
INSERT INTO kog_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Guñgueni jiak, mokue sáñkaldak ekí akbeyá: “Nakbemaldamak aikue mikuldaxaldatshak jiaga, asajaldi káguba jialda negazháñga ni gu.” ");
INSERT INTO kog_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ekí akbeñguake ají sáñkaldaja mokue ekí niuwi agé: “Kaigaki kuíbuldu xezhaldi maniñgaba káguba matualdí, jiúñguldak neyatukakuek jiaga, najúk nabuzál kauldashi makualdí. Ekíki asajaldi káguba jialda sʉnexaldiamak. ");
INSERT INTO kog_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ekí miñmeyaldikue. Kasak nekue nabuzál nagakue kakbenugekueja ni nauwa nuxaki axazháldixa nakldá” —guashi na shi kaxaldiyá. ");
INSERT INTO kog_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Guatshak Duwe Jesú jiúñguldak neyatoguéñ, káguba matshuwi axapa aldeyatukakuek kakizhbateguenik ekí kakbeyá: ");
INSERT INTO kog_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mieldeki nagapa neyaldixa jañgualdiake, ajate, ajaba, asewá, ají sukuakue, akajakue, axaldáñ jiaga zhakaldak najañguakue agatsaldaldixa. Ekí najañguakí naldaldiake, nagapa neyazháka naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Akze, mieldeki nagapa neyatoxaldiéñ, nají ne shalda guiyaba tuakue azhi shuigakue agatsexaldiake, egaba abeti ‘wa nuxa ni nakldexaldí’ izhgakuxane naldakue. Ekí izhgakugazháne naldaldiake, nagapa neyazháka naldaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ai shaldaga mozhua ajanashakldegéñ zhinik shi kaxaldiyaldá: “Ezua maiñga juwí wézhilduka miñgauwaldixa mijañgualdiake, axáñ misha ‘¿ai juwí sekuá guashi auxaga jika naxaldá shi na?’ jañguakue. ");
INSERT INTO kog_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Azhi egaba gauwapana guaminaldixaki, jika miñgajuezha guatshake sekuazhá guaminaka. Akna saldiñga atunekueja ekí miyajokldexaldixa: ");
INSERT INTO kog_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Eja míñgaki juwí gauwapana gueni sekuá akzegazhá guxá tubaldá.’ ");
INSERT INTO kog_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","”Ekibeñga na, ezua kagixa zalda sáñkalda 10.000 kaukshaldixa axaldé ne, axautshi sáñkalda mutshua naldashi (20.000) kaukshaldixakue axaldé na kaukshaldixa jañgualdiake, axáñ misha ubiyaka azhi ubiyazháka muldetua jañguakue agatsé. ");
INSERT INTO kog_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Agubiyazháka jañgualdiake, sáñkalda aldéñ kaugakshál nagatuka maldé zeñka nagatoxaldieñga, ekí akbeyal ají nashikue gaxaldixa: ‘Kaukshagába, señgaba zhe nogakualdiamak dulda zhiksha nuxa kuizguí.’ ");
INSERT INTO kog_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","”Ekibeñga, mieldeke nagapa mineyaldiamake ji akzé mijañguxa nahauxa nas shaldaki mashaminaka ne izhgakuxamine naldakue. Ekí izhgakugakí minaldiák, nagapa neyazháminaka naldaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Guñgueniki ekí jiaga kakbeyá: “Nakuki janshizhe, zauwaka zʉñkué. Ne nuk izʉzé guane, ¿sakí shi mokue akzanamak akzukuanazʉnaka na? ");
INSERT INTO kog_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Naku izʉzé guaneki ni jiñ zauwazháka nak uteya nuxa guakue naldashá. Akna saldiñga ai nukaminekuañ kuxa miñkaldikueke muldetua nukshi miñgualdí.” ");
INSERT INTO kog_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Guatshak sáñkaldak akiyalzabine zhiksuikakue, sha atshixa akuakakue juizhi Duwe Jesú aldukal axaldák. ");
INSERT INTO kog_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ekí axaldagatshakna paldiseyukueja, kauwisanátshi guiyaba shizhixakueja ekí Duwe nalda axakuák: “Jejiéki sha atshixakue jiaga kepani ekue na za zalda jiaga atshixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Guñguake Duweja ezua ajanashakldegéñ zhinik ekí shi kaxaldiyaldá: ");
INSERT INTO kog_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ezuak jubeju matshuwi (100) mixaldé ne, ezua migitshuizha guanake, ¿jubeju matshuwi (99) nekue za na, játuldiñga maja makueniki, ezua migitshuanane za nijiñga mikzá zalda niyazhámildaka sha? ");
INSERT INTO kog_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Amak mikzaldatshake, zeñ mikldeshiñgaba kukubak izhbi uldemildaka. ");
INSERT INTO kog_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Gualdinik mijuxa maldeyatshak, mipebukue, mikyó izhukakue mijúk majuizhakuatshak, ‘jubeju nagitshuanane mokue nakzane nakna, nas na zeñ miñnegwíñ’ kakbemildaka naldashá. ");
INSERT INTO kog_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","”Ekí miñmeyaldikue. Ekibeñga guana, jáugukuija ají jubeju akzaldatshak zeñ akldegamakbe, ezua sha atshixaja sha atsha majiñga maja, Jatek agakualdinatshak, jékaldaxa izhukakue zʉ́xaita zeñ izhajanaldixa. Ne matshuwi káguba (99) kauwizhéñgaba janshizhekue izhajani na, sha atsha majiñga maja, Jatek agakualdinakue kagatsaldazhé itshankakue shalda zʉnake zeñ izhajanazháldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","”Ekibeñga na, ezua munzhija muneda akzekuegaba uguá axaldé ne, ezuamé nuxa agitshuana guanake, ¿muñshí zukuxa zuñgua xaldek, muldetua zupeshi, nijiñga akzá zalda niyazháka sha? ");
INSERT INTO kog_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Amak akzaldatshake, apebukue, akyó izhukakue ajúk kajuizhakuatshak, ‘muneda nagitshuanane mokue nakzane nakna nas na zeñ miñnegwíñ’ kakbeyaka naldashá. ");
INSERT INTO kog_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ekibeñga guana, ezua sha atshixaja sha atsha majiñga maja, Jatek agakualdinatshak, jékaldaxa Jateja, aldéñ guaklde uldeñkakue juizhi zʉxaita zeñ izhajanaldixa nakldá miñmeyaldikue.” ");
INSERT INTO kog_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Guñgueniki Duweja mokue ezua ajanashakldegéñ zhinik shi kaxaldiyaldá: “Ezua sigí mozhua sigí sukuekue axaldé nalgué, ");
INSERT INTO kog_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","galdeni ne zaldajañki ajatek ekí akshishá: ‘Najate, mielde bieni maldagexaldixa nake, najíki nagé guwá.’ Guñguakna ajateja amak bieni muan, muan asukuákuek kagé. ");
INSERT INTO kog_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","”Amak kagegueni nauwa anuñka me zegatshake, galdeni zaldajañki ají bieni nuk nabesá guñguenik, san kagi maldé zaldi ne. Eñkaki naldagálde atshiji akldunamak izhoshi izhgasjabijiñgaba, ají bieni nuk itshuakshá. ");
INSERT INTO kog_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Amak nuk aksaldinatshake ai kagixa gakue negaksá, gakue atuakí naldapanatshakna, aldéñki jika agajuezhi na izhogapaná. ");
INSERT INTO kog_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Guñguakna ezua exa zaldaga jiba akshishiñguake, ají mitukue agakauwaldixa nuxa jiba agé. ");
INSERT INTO kog_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Amak agakauwatoguéñ maldija guiñgaba, guñguakna mitutshi gakue jiaga ga gundana akzegatshak jiaga, ni meja akauwakí na naldá. ");
INSERT INTO kog_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","”Ekí akzeshiñga, aldiweki uba akldeji guxá jana akzegatshakna ekí jañguá: ‘¿Najatetshi nashikuejañki gakue kagabá zalda axaji ashekuéñ shi nas asukuák niñkauwañki niuwi neyauxa akldé akldeñga maldi nakuí shuixaldá gugé jana shi izhokú? ");
INSERT INTO kog_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Akna mokue najate nugaldi ne guakue nagatsaldashá. Exa neyaldikuenik ekí akbeyaldikue: “Najate, naski Jate jékaldaxa izhuka sha axatshanugamak, ma jiaga sha mixatshanuge ni atuñkú. ");
INSERT INTO kog_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Akna kaiga zhiniki ‘nasukuá’ naxaldegakue migatsaldaksá. Guakna egabá ezua mijí nashi jana nuxa nazipana makualdí.”’ ");
INSERT INTO kog_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","”Ekí jañguñguenik, mokue ajate nugaldi neyaldá. Neñgueni stuakueñka me izhañkatshake, ajateja tuatshakna matshuwi guañ jañgui na, akldabixal naldiñga neñguenik gulda axabé na gua. ");
INSERT INTO kog_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Guñguake asukuája ekí akbeyá: ‘Najate, naski Jate jékaldaxa izhuka sha axatshanugamakga, ma jiaga sha mixatshanuge ni atuñkú. Akna kaiga zhiniki “nasukuá” naxaldegakue migatsaldaksá.’ ");
INSERT INTO kog_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ekí akbeyatshak jiaga, ajateja muldetua ipani, ají nashikuek ekí kakbeyá: ‘Nauwateñgaba zhakuá akaldak janshagatse tu uldák, nasukuák ijualdí guwíñ. Niuba káuxaldak mijiuwaldixa, sapatu miyakjiuwaldixa jiaga akuldák guwíñ. ");
INSERT INTO kog_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Naldiniki ezua baka guangatse, janshagatse uldák guaxa guwíñ. ¡Nasʉñ atemajañ zeñ zʉñneshi nasukuá kuizabuzají! ");
INSERT INTO kog_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Jinake naldakí. Jalde nasukuáki nakshuizha guane jana nagitshuanane ne, iteñga none mokue nakizhañka guane nak.’ Guakna zeñ kakldeshi, abuazaldá na akuá. ");
INSERT INTO kog_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","”Ekí ajanashatogueñki, asukuá kasak zaldaki tezhiñga na izhoxá. Guñguenik mokue ajúk naká naki jutezhak nagatogueñki, matshuwi azabeji akuizatuka nuká. ");
INSERT INTO kog_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ekí nukañguakna, ezua nashi ixaulguenik aklduká: ‘¿Jinak shi ekí aldegatók?’ ");
INSERT INTO kog_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Guñguake akiyó: ‘Mizhaniki nenane ne, shuigazhánega izhañkane. Nakna mijatejañki asukuá abuazaldiamak ezua baka guangatse, janshagatse guaxal guak guane, ai shalda na ekí aldegatók.’ ");
INSERT INTO kog_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","”Ekí nukatshakna itsauldiñgaba, ‘juldunazháldikue nzha’ nek. Guakna, ajateja akzʉxaitiñguenik agakuañnék: ‘Nasukuá, juldú guwá.’ ");
INSERT INTO kog_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Axaldegatshak ajatek ekí akiyó: ‘Jate, muldetua tu guwá. Nas mitsá kagi migapakualdi kaiga yo jiba za mixatshiji, ji maldakbeyaldiake ni mitsák amak mixatshazhá guazhúge. Ekí mixazauwatoxaldatshak jiaga, ni mitsák napebukue juizhi zeñ zʉñnék zakualdiamak, tshibu zhauwa nuxaki nakáu guabálde naldashá. ");
INSERT INTO kog_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ne, misukuá zʉnake munzhi nakua niñkakue juizhi bieni akaumalde nuk itshuaksha guane jiaga, mokue mixaldagatshak abuazaldiamak baka guangatse, janshagatse tu guaxal guakbalde naldashá.’ ");
INSERT INTO kog_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","”Guñguakna ajateja akiyó: ‘Nasukuá, mañki nagapa zañga mizhuka, nakna jika naxaldauxa neki mijígaba naldashá. ");
INSERT INTO kog_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ne mizhaniki neyatshake, zʉñshuizhá guane jana, zʉñgitshuanane ne, iteñga none mokue zʉñkizhañká guane shaldaki zeñ zʉñneshi abuzakue zʉñgatsaldashá,’” ekí na Duweja shi kaxaldiyatoxá. ");
INSERT INTO kog_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ekí kakbeñgueniki ezua ajanashakldegéñ zhinik aldéñ shaxaldixakuek shi kaxaldiyaldá: “Ezua sigí kabiaja ají nashik saldiñga jikakue numañ agatualdiamak axabajá. Guane nalgué, ají numakue agitshuakshapanká akizhakuák. ");
INSERT INTO kog_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Guñguake kabiaja ají nashi ixaulguenik ekí aklduká: ‘¿Namak shi nají numakue nagitshuakshabalduka maldukakú? Akna sakí jiba naxakbemalde xalte maldagexaldí. Jinake ekí mikbeyakí. Mañki jikakue numañ nagatuabiksá gualdixa nak.’ ");
INSERT INTO kog_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Guakna nashija aldéñgaba ekí jañguá: ‘Nají sáñkaldaja jiba nazikuxá guxaki, ¿izhó guashi sakí kasa izhgauwaldikue ne? Tezhi jiba ishkatsha zʉnake kama naxaldaldazhé nakldeka. Ne zʉshishá izhoxaki jiwak nakzeka.’ ");
INSERT INTO kog_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ekí jañgui na, ‘ekí ni atshaldikú’ akldék. ‘Sáñkalda jiba nazikuxaldinik axautshikue niñkauwañki kauwijuxa naziyapanaldiamak ekí atshaldikue nzha.’ ");
INSERT INTO kog_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","”Ekí jañguñguake ají sáñkaldatshi shaldá izhukakue ezua, ezua axaldaxal kakbeyá. Kasaklde axaldagatshak ekí aklduká: ‘¿Mañki mitsá shi nají sáñkaldatshi shaldá mizhók?’ ");
INSERT INTO kog_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Guñguake akiyó: ‘Naski 160 balde mantixa na shaldá nazizhók.’ Ekí akiyokuatshak ekí akbeyá: ‘Jalde mijí shaldá xalte ipana xaldeki jiak, nauwateñgaba abisa 80 niñkauwañki itsuñguá guwá.’ ");
INSERT INTO kog_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Galdeni ne axaldagatshak ekíga aklduká: ‘¿Mañki mitsá shi nají sáñkaldatshi shaldá mizhók?’ Guñguake akiyó: ‘Naski 100 gamañkalda na gakue shaldá nazizhók.’ Ekí akiyokuatshak ekí akbeyá: ‘Jalde mijí shaldá xalte ipana xaldeki jiak, abisa 80 niñkauwañki itsuñguá guwá.’ ");
INSERT INTO kog_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","”Sáñkaldaja ají nashi jikakue numañ agatuñka nane ekí naldagálde axatshane nukatshak jiaga ekí guak: ‘¡Nají nashiki jika agajuezhauxa axaldaldaldiamak muldetua jañgua janaktune nukshí!’ ”Akze, Jate jañguagáldekueki jai kagik sakí izhoxa, kauwizhéñ jana izhukakue nañki muldetua ishkaldalda kakué. Naldatshak Jateja muñshí izguanekueki ekíga jai kagik izhoxa kaksʉ́ñze nak, aldéñ jañguazhékue na muldetua ishkaldalda kaksʉ́ñ nakldá. ");
INSERT INTO kog_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ekí jiaga miñmeyaldikue. Maiñ jai kagik ji akzé miñkaldeki axautshikue kagauneshi, mimipebu aldexaldiamak jiba akbeyakue. Ekí miyatshaldiakna jai kagik zaldakue miñkazauwaksá guatshake, jékaldaxa izhoshiñga mizhoxaldieñka zʉnake muldetua mimeyapanaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","”Mieldeki jika nauwamé ne jiaga numañ tuakue agatsahamak numañ tualdiake, aiki ‘matshuwi jika ne jiaga numañ tuaka shakldá’ alduna iyashaka naldaldixa. Ne mieldeki jika nauwamé ne jiaga numañ tuakue agatsahamak numañ tuagába, naldagálde atshaldiake, ake, matshuwi jika numañ tuakue agatsegatshak ekíga numañ tuagába, naldagálde atshaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ekibeñga na, jai kagik ji akzé miñkaldekue muldetua numañ tuakue miñgatsahamak jiba akbeyakí minaldaldiake, ¿sakí shi Jateja namak giemi akzekue tuñka numañ miyagatualdiamak miñgexaldixa na? ");
INSERT INTO kog_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Akze, axautshitshi jika numañ tuakue miñgatsahamak tuagába amak jiba akbeyakí minaldaldiake, ¿sakí shi mimijí giemikue miñgaxexaldixa na? ");
INSERT INTO kog_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","”Guatshak ezua nashija mozhua sáñkaldakuek axazauwazháka naldashá. Jinake naldakí. Amak mozhua sáñkaldakue akizhuka nanake, ezuañki izhgajañgui, axabetaldixa ne, jiak ezuañki aguldiji, aguáñ izhbashaldixa. Ekibeñga na, ‘Jate za sha akaldak akzé na’ jañgui axazauwal minogatshaga, paldata jiaga akldé akzé jañgui ai za niyal nogazháminaka naldashá.” ");
INSERT INTO kog_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Guatshak paldiseyukuejañki paldata za ajañguxakue naldakna, Duweja ekí guagaté aldukatshakna iyajokldeshiñgaba na akuá. ");
INSERT INTO kog_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Guñguake Duweja ekí kakbeyá: “Maiñki kágubakueja izhogakue miñgatsahamak mizhuka miñkajanaldiamak mizhekualdatshak jiaga, Jateja zʉnake aldunaxa nusagatse miñneshi, mijañguxa auxaga miñgatuñka. Akze, kágubaja ji akzé tuñka, Jateja zʉnake akzaldagálde tuwi na, tuasʉ́ñ akzeka nakldá. ");
INSERT INTO kog_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","”Guatshak Juañ nik majaukshakueja Jate shalda guaxal nagagá nogueñgaki, nauwibama Muesék Jateja jian izhoxa guiyaba zʉñkabajane, ají múldigaba naldiñga zʉxaitshixakuek kalta kakaushananekue za zʉñsaneklde naldashá. Ne Juañja Jate shalda guagapaneni zhinik na, Saldiñga netshi Jateja janshagatsaldi káguba kaksanegapanaldixa shalda akuagapanane. Ekí akuagaté aldukatshakna, matshuwi nekuejañki kagatsauxa Jateja kaksanexaldiamak aldiji na, abá naldakí kama izhalshijiñgaba ashekualdapanane. ");
INSERT INTO kog_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Naldatshak Najateja guiyaba zʉñkabajananeki zʉñsanegaksá guazháldixa. Akze, alnoba, kagiki naldaksáñga gualdixa, naldatshak ai guiyaba zʉnake ni ji ezua agatsalda nóñgutse nuxaki yushá guazhíta nzha. ");
INSERT INTO kog_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","”Akna mielde sigíjañki asewá majaldinik axautshi guxaldiák, Jateja tuwiñki asewá naldagálde tushek guxaga zexaldixa. Ekibeñga na, mielde sigíjañki munzhi asewája majane guxaldiák, asewá naldagálde tushek guxaga zexaldixa nzha.” ");
INSERT INTO kog_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Guñgueni Duwe Jesúja ekí shi kaxaldiyaldá: “Atiuwiñ zalguéñ ezua sigí kabiaki zhakuá maldé akzé za ijuakue. Jika zʉxaita axaldaldakna, niuwi neyauxa we akzaldi za zaxa na izhoxá. ");
INSERT INTO kog_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Naldatshak jiak, ezua sigí nashi, Aldásaldu axezhuka, agatsauxa sawa balda, kabia juldunéñ ité nuka na naldá. ");
INSERT INTO kog_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Eñki maldija guiñgaba na, kabiaja gakue gatuka agakjienane nuxaki ga gundana akzeshiñgaba na izhoxá. Guatshak míñgaki piyukueja axaldaxeni sawak iyasuañguxa. ");
INSERT INTO kog_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","”Nalgué nashiki shuigatshak, Jateja guaklde uldeñkakueja nauwibama Abaldahám akyó izhogexañ awalditshí. Guñguenik kabia jiaga shuiguake kagi iyashá. ");
INSERT INTO kog_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","E zʉnake jiséxa neyatshak guiyaba tuwiñgaba izhoxaldá. Eñka zhinik maldé zeñka stuatshake, nauwibama Abaldahámki nashi Aldásaldu akyó ité tu. ");
INSERT INTO kog_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ekí tuatshakna ixauldá: ‘Najate Abaldahám, guañ maldaguanaldí. Tuejié Aldásaldu ají káuxalda bulduk nik alduañgua xaldeki nauwa sui nakzexaldiamak, nagakaxá guwá. Jinake naldakí. Naski jai guksék zʉ́xaita zalda guiyaba tuwiñgaba gugák.’ ");
INSERT INTO kog_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","”Ekí agakuañnegatshak jiaga akiyó: ‘Nasukuá, ekí be zhigisekuá guwá. Mañki kagixa mizhogueñgaki, jika janshagatsekuegaba mipanaldiauxa au ipaná guamalde. Ne jalde nashi Aldásaldu niñkauwañki kagixa guiyaba tuwi za izhone naldatshak, jexa zʉnake guañ jañgui, zeñ izhokshakue. Ne ma niñkauwañki guiyaba tuakue. ");
INSERT INTO kog_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ekí zhinik jiaga migaunegazhánaka. Jatejañga jai nauwibuánki atemajañ izhgajuekuane nogatuka. Ekíki jai zhinik ni me mizhogeñka agaskaiti guakuak. Ekíga na jiak, mizhogeñka zhinik ni me jai agaskaiti guakuak.’ ");
INSERT INTO kog_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","”Ekí akiyokuakna kabiaja ekí agakuañnék: ‘Ake, najate Abaldahám, tuejié Aldásaldu najate nugeñka gaxá guakue ni migakuañnekú. ");
INSERT INTO kog_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Jinake naldakí. Nakaja jatshiwa nekue sha atsha majiñga maja guakue keshkaldukshaldiamak. Ekíki ekue jiaga guiyaba tu za nogakuéñ aldashi guakuak.’ ");
INSERT INTO kog_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","”Guñguake nauwibamaja ekí akiyó: ‘Kauwizhéñki Muesé, Jatetshi múldigaba naldiñga zʉxaitshixakueja kalta gauwane kaxaldañga nak axaldukakue kagatsaldashá.’ ");
INSERT INTO kog_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","”Guñguake mokue akiyó: ‘Najate, nakajakueja ai za auxabé aldukazháka. Ne ezua shuanaldi zhinik izhgateneja “sha atsha majiñga maja, Jatek agakualdinakue” kakbeyatshak zʉnake amak aldukaldixa nzha.’ ");
INSERT INTO kog_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","”Ekí akbeñguake akiyó: ‘Mikajakuejañki Muesé, Jatetshi múldigaba naldiñga zʉxaitshixakueja kalta gauwanane aldukazhámakbeñga, ezua shuanaldini izhgateneja jiaga ji kakbeñka “namak sha nakbé” ajañguazháldixa naldashá,’” ekí na shi kaxaldiyá. ");
INSERT INTO kog_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ezua ldiuwañ Duwe Jesúja aldéñ shaxaldixakuek ekí kakbeyá: “Namak, kágubakueki jiyájañgaba kejuldukshi, sha ajanashindana kakzukualdixaga naldaldixa. Ne mieldejañki ezua ijuldukshi, sha atshishaldiák, ¡wau wau wau mitsá guiyaba tualdixa ne! ");
INSERT INTO kog_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Akze, ezua nepanane ai itsaldagálde axajanka sha atshishaldiák guiyaba tualdixa. Akna ni me ijuldukshazháldiamak, akldé janshibé aldéñga ezua jagi atema gakldak zhikldiya gualdiniki ni izhgatushi shuixaldiamak níbunik akuateyakue. ");
INSERT INTO kog_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Akna ni mielde ijulduni mual atshishabináldiamak be noshi muldetua numañ miyatualdí. ”Ezua mimijanamé nazipanane sha atshaldiák, ‘sha atsha nabakú’ sha atsha majaldiamak izhgastuñshi mual miyaksanexaldí. Gualdinik amak sha atshane maja guaté mitualdiák, axabetá miñgualdí. ");
INSERT INTO kog_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ekíga na, ezuañki atiuwiñga kugua juizha sha mixatshaldinik jiak, kugua juizha: ‘Sha mixatshanuge ni atuñkú. Ai majaldikue nak naxabetá makualdí’ migakuañnexaldiake amak maxabetaldí.” ");
INSERT INTO kog_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Guatshak aldéñ shaxaldixakueja Duwe Jesúk ekí agabeyá: —Duwe, akldé akldeñga ma za alduna mishiji izhogakualdiamak zʉñgaunék makualdí. ");
INSERT INTO kog_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Guñguake ekí kakiyó: —Akze, ezua zulda nóñgutse nuxa nanaldixa atema negamakbe, mieldeke nauwa nuxaki “Jate akshishanugamak naxatshaldixa shakldá” alduna mishaldiák, aldéñga matshuwi mimatshishaldixa. Akna, jejié kaldi atema “jai zhinik agalduxa xaldeki níbunixa jiená guwá” miyaxaldexaldiake, amak miñkatshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Gueni ekí jiaga shi kaxaldiyaldá: “Ezuak maiñ nashi miñkaldé guashiñki, aiki mimijí tezhi jibatshál zhinik, azhi jubeju numañ tual zhinik nagatshak: ‘Ma misha yaté xaldeki za guwá’ ¿axaldekminaka shi na? ");
INSERT INTO kog_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ne ekí nuxa axaldekbinaka: ‘Nauwateñgaba gakue galdikue jananagaktu guwá. Xaldeki zatoxaldatshake ji nagajuezhauxa maldakuldaxaldiamak janazhiktú guwá. Makualdinik na mañki matsaldixa nakldá.’ ");
INSERT INTO kog_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nashiki egaba ma aksanek me mixatshane shalda ¿‘zeñ nzhakldék’ miyakbeyaldixa shi na? ");
INSERT INTO kog_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ekibeñga guana, maiñ Jateja sakí axatshakue miñmeyauxabé miyatshaldinik ekí guagakue: ‘Nasʉñki egaba Jatetshi nashi kaxazauñka nuxa kaldakna, aldéñ axatshakue zʉñsanék me nuxa axatshiji izhoñkalde nakldá.’” ");
INSERT INTO kog_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Guñguenik Duwe Jesúki aldéñ shaxaldixakue juizhiñga Jeldusaldéñka neñká neyatoguéñ Samaldia na, Galdildeya na, zhikyokué baxañ zʉxaitá. ");
INSERT INTO kog_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Eñkaga na, ezua kuíbulduk juldunapanatshak, uguá sigíkueja akldabixal aldák. Ekueki ajuba kekaldunatukakue naldakna, guiyabaja guagamak agajué zeñka akteté aldoshi ");
INSERT INTO kog_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ekí iyaxauldá: —Duwe Jesú, shi maldazʉñkaldixa, guañ zʉñguani, janshi zʉñkazguakue ni kabajañgú. ");
INSERT INTO kog_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Guake Duweja katuatshak ekí kaxaldék: —Guiyabaja guagamak janshi miñgatsék guane mimawatualdiamak Jatek múldigaba agaskaitshixakue tual mineyaldí. Guñguake kakbenalguamak aldeyatoxeñki, janshi kagatsék. ");
INSERT INTO kog_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Guñguake ezuajañki janshi agatseklde tuñguake mokue Duwek axaldeñká neyatoshi, jaldáñ Jate “zeñ nzhakldék” akbeji, akldé akzamakga akzukui mokue axaldák. ");
INSERT INTO kog_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Amak axaldagueniki Duwe stak nuldu axayoshi “zeñ nzhakldék” akbeyá. Ekí akbeyal axaldaxeki juldiú saná naldagálde, Samaldiaxa zalda na naldá. ");
INSERT INTO kog_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nalguakna Duweja ekí izuká: —¿Uguá naldekue janshi kagatsegazhá shi gua? Guane ne ¿sakí zhinik etagua nekueki aldagazhá shi gu? ");
INSERT INTO kog_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ne ezuamé nuxa, eñki nauwisaná naldagáldeja za na Jatek “zeñ nzhakldék” akbeyal nak guxa tiuwi. ");
INSERT INTO kog_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Guñguenik ai sigík ekí akbeyá: —Kaiga zʉnake izhgaté xaldeki neyabikuká ni gu. Mañki alduna nazishá makuák janshi migatsék guane nzha. ");
INSERT INTO kog_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ezua ldiuwañ paldiseyukueja Duwe Jesúk ekí agalduká: —¿Mitsák zhinik shi Saldiñga netshi Jate kagik sanegapanaldixa na? Guñguake kakiyó: —Aldéñ sanegapankaki niuwabak mitualdixa mijañguatshak jiaga, tua naldi sanegaté tuazháminaka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ai zhinik na kágubakueja “jai na Jate sanegapán” azhi “uñguexa na Jate sanegapán” guagazháka naldaldixa. Jinake tuazháminaka naldakí. Saldiñga netshi Jatejañki mimikenañga kágubakue aldunaldi au kaksanegaté nogák. ");
INSERT INTO kog_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Guñgueni aldéñ shaxaldixakuek ekí kakbeyá: —Niuwizhíne maiñ na izhoxaldaksá naldaldikuéñ, naski Jatetshi Asukuága ixagabaldeklduge mokue kagik naxaldikuéñ niuwañ mijá zegakuéñ miñgatsauxa miñneshi natundana miñzexaldixa. Ekí miñzeshi na, atiuwiñ nuxaki miñgapa izhogakue minajañguatshak jiaga, ai ldiuwañ zegagá noxaldieñgaki natuabináldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Atshakna, anuñkakuejañki “jai ni izhók”, azhi “exa ni izhók” miñgabeyatshak, namak jañgui eñka, eñka naldiyal neyabináldi. ");
INSERT INTO kog_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jinake ekí miñmeyakí. Nas Jatetshi Asukuága ixagabaldeklduge mokue kagik naxaldikuéñ niuwañ zegatshak, saldiñga natundana agatsaldi naxaldikue nak. Atshakna, kuizhbañgui tuba, tuba atshatshak, alnoba agatsauxa muñshí izguatshak saldiñga tuakuamakbeñga agatsaldi mokue kagik naxaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Naldatshak axáñ misha matshuwi jiba tuwi, guiyaba tuakue nagatsaldaldixa. Ekíga na, matshuwi káguba kaiga zhekualdatukakueki kaguldiji, naziyapanazháldixa zegakue zaldaldixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","”Akze, nauwibama Nuwé izhogué baxañki, saldiñgaja “sakíga ni zexaldí” kaksʉ́ñ ashekuanamakga, naski Jatetshi Asukuága ixagabaldeklduge mokue kagik naxaldikuéñ niuwañ ekíga ashekualdaldixa. ");
INSERT INTO kog_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Atshak baxañ ashekuamakga ashekualdi na, zeñ kakldeshi asaji, azatushi, numa aldeshi, kauwijí sukuakue numa nexaldiamak axeshi ashekuanane. Ekí ashekualdatoshiñga, nauwibama Nuwé balku atemak juldunaldiéñ niuwañ yo, ekíga ashekuanane. Guñgueni ni maxé zalda zegatshak saldiñga ni izhgatushi nija kakane. ");
INSERT INTO kog_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","”Ekibeñga na, nauwibama Aldót izhogué baxañ janañga naldaldixa. Atshake eñgui baxañ zhekuekueki ashekuamakga ashekualdi na, zeñ kakldeshi asaji, azatushi, jika ishkajabiji, nabashkiyasaji, azaldishi, juwí izhaxauwi nuxa ashekuanane. ");
INSERT INTO kog_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ekí ashekualdi na, ashuixaldixa kakldegakíñga, nauwibama kuíbuldu Sulduma zhinik akzʉxaitatshak niuwañga, Jateja alnobaxa zhinik guksé zʉxaita tatshuakze níxalda jana gagatshak, abanekueki nuk kakldañgashá guanane. ");
INSERT INTO kog_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","”Ekibeñga, naski Jatetshi Asukuága ixagabaldeklduge mokue kagik naxaldikuéñ kaksʉ́ñ noxaldieñga kakizhañkaldikue niyó. ");
INSERT INTO kog_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Atshakna mieldeki jutezhaldi izhoxaldiéñ, jika izhgakuxal juldi juldunakue agatsaldazháldi. Ekibeñga na, mieldeki texa akldoxaldiéñ, ají numakue majane izhgakuxal neyakue agatsaldazháldixa. ");
INSERT INTO kog_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Akze, nauwibama Aldóttshi asewá sakí agisaldi shuanane be izhgisekuwíñ. ");
INSERT INTO kog_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","”Mieldeki jai kagik izhoxa za akldé akzé jañgui nagapa neyasʉ́ñ akzekaki shuigatshak jékaldaxa izhoshiñga izhogazháldixa. Ekí ne, mieldeki nas shalda shuigaka izhgakuxaldiák zʉnake, jékaldaxa izhoshiñga izhoxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Akze, ekí miñmeyaldikue. Mokue naxaldikue niuwañ zegatshak, sesʉñ zaldaldiake, mozhua zhikyo axabagatoxaldiéñ, ezuañki awaldeyaldixa, ezuañki abaldixa. ");
INSERT INTO kog_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ekíga na, mozhua munzhikue ishkapa jika abuldiyatoxaldiéñ, ezuañki awaldeyaldixa, ezuañki abaldixa.  ");
INSERT INTO kog_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ekíga na, mozhua sigíkue ishkapa tezhi jiba ajanashatoxaldiéñ, ezuañki awaldeyaldixa, ezuañki abaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ekí kakbeñguakna ekí agalduká: —Guatshake nauwijí Sáñkalda, ¿mashi amak mizhañkaldixa ne? Guñguake Duweja akuashiñga akuagamak kakiyó: —Mashi béyakze shuane gekualdaldiake, eñka guana tuakualdi shexá tinka naldashá. Amakbeñga na, nas mokue kagik naxaldatshak, saldiñgaja kakualdaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Guñgueni Duwe Jesúja aldéñ shaxaldixakuek Jate abá naldakí axazguagakue shalda ezua ajanashakldegéñ zhinik shi kaxaldiyaldá: ");
INSERT INTO kog_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Ezua kuíbulduxaki ezua agatsaldi ne azhi agatsaldakí ne tuñka na izhoxá. Ejañki Saldiñga netshi Jate axabetazháldi, zhe akzukuazhé. Ne kágubakue míñgaki ni nauwa guañ kajañguazhé. ");
INSERT INTO kog_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ai kuíbuldukga na, ezua munzhi sigí ishuanejañki ai agatsaldi ne tuñka ekí agakuañnexal nejiñgaba: ‘Ezua aguldiñkuge, nezhguaklde nak atshakue migatsahamak nakzukuák guakue ni migakuañnekú.’ ");
INSERT INTO kog_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ekí agakuañnegatshak jiaga, axañga amak axatshakí naldenik aldiwe zʉnake ekí jañguá: ‘Naski Saldiñga netshi Jate axabetazháldi, zhe nakzukuazhé. Ni káguba míñgaki guañ kajañguazhúge. ");
INSERT INTO kog_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Naldaldatshak jiaga, ai munzhija nakbeyaksá guakí neki axatshakue nagatsahamak axatshaldikue. Ekíki nagakuañnexal naxalga, naxalga nogatshake nagusañguazháldiamak.’” ");
INSERT INTO kog_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ekí kakbeñguenik Duweja kakbeyá: “Ai agatsaldi ne tuñkaki atshakue agatsahamak atshazhé nalgué jiaga, sakí atshane tu guwíñ. ");
INSERT INTO kog_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ake, Nauwijate míñgaki ají mimezhgakuxanekuek niuwi akbaja naldakí agakuañnexal minogéñ guana, ¿miñkatshakue agatsahamak miñkatshaldixa naldazhé shi na? ¿Azhi amak miñkatshaldiamak jimimatuñshá noxaldixa shi na? ");
INSERT INTO kog_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Naldagálde. Amak miñkatshakue agatsahamak miñkatshexañ jitú mimaldokshazháldixa ni miñmeñkú. Naldatshak jiaga, nas Jatetshi Asukuága ixagabaldekldugek mokue kagik naxaldatshak, ¿matshuwiñga alduna naziyashalga ska aldoxaldí?” ");
INSERT INTO kog_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Guñguenik Duwe Jesúja anuñka nekueki axaldáñgaba ji ajanashéñ zhinik Jateja jian nekue katuñka izhajani, axautshikueki kauwizhaguáñ akzekue tuñkakuek ezua ajanashakldegéñ zhinik ekí shi kaxaldiyaldá: ");
INSERT INTO kog_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Mozhua sigíkue Jate axazguaxal juwí aldéñ axazakuageñka aldé. Aikueki, ezuañki paldiseyu, ezuañki sáñkaldak akiyalzabine zhiksuika. ");
INSERT INTO kog_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Naldé paldiseyujañki akté noshi Jate ekí axazguaxaldá: ‘Jate, nasga axautshikue sha ajanashamak atshazhúge naugakna zeñ nzhakldék. Akze, axautshikueki sha atshixakue, tushekakue, kauwisewá naldagálde na askuildekakue. Ni jalde sáñkaldak akiyalzabine zhiksuika sha atshamake atshazhúge nak “zeñ nzhakldék” ni mikbeyatokú. ");
INSERT INTO kog_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Akze, naski semana akldañkajauxa muzhbaxeñga muldetua mixazguaxaldikuamak záaki izhokuge. Guiyabaja zʉñsanegamak ji uguá naxaldé ezua agatsaldaki izhgikuxa migekuge nakldá’ na akbeyá. ");
INSERT INTO kog_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","”Guatshake sáñkaldak akiyalzabine zhiksuikaki nauwa antezhaxa akté noshi, sha atshane shalda itshaniñgaba awatuñshaldiamak tabáxaldak abushi, ni ‘mateldi stu ni gualdikú’ akldegagába, Jate ekí agakuañnék: ‘Najate, naski sha mixatshanuge naugakna guañ najañgui, naxabetá makualdí’ na agakuañnexá.” Ekí kakbeñguenik ekí kakbeyá: ");
INSERT INTO kog_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ekí miñmeyaldikue. Ai sáñkaldak akiyalzabine zhiksuikaki Jateja janshizhe, sha atshagálde jana tune ajuxa nene. Ne paldiseyu zʉnake ekíga tuazháne. Jinake ekí miñmeyakí. Mieldeki axaldáñgaba akldé zhikzukualdiák jiak, Jateja niñkauwañki aguáñ izhbashaldixa. Ne mieldeki axaldáñgaba aguáñ zhikzukualdiake jiak, Jateja niñkauwañki akldé akzukualdixa nakldá” na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Guatshak Duwe Jesúja somákue zeñ kajañgui káuxalda kepañgualdiamak akualdagaté atuatshakna, aldéñ shaxaldixakueja somá uldakldekue ekí axaldék: —Ekí Duwek somá akuldagagába nogwíñ. ");
INSERT INTO kog_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ekí Duweja nukatshakna, sukuakue aldéñ nugeñka nagakue ixaulgueniki ekí guak: —Sukuakue nas nugéñ aldashi naguatók, kagitamakuagába. Jinake ekí miñmeyakí. Mieldekueki sukuakue aguáñ zhikzukui, Jate alduna iyashamakbeñga alduna ishixakue na, Jateja kaksanegaka naldaldixa nak. ");
INSERT INTO kog_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Namak miñmeyaldikue. Mieldeki sukua aguáñ zhikzukui, Jateja janshibé aksanegaka akldegamakbe akldegazhéki Jateja aksanegazháldi, ni aldéñ sanegeñka juldukshazhíta nakldá —na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Guñguenik ezua juldiúkuek aksanekaja ekí Duwek aklduká: —Shi maldazʉñkaldixa janshizhe maldé, Jateja jékaldaxa izhoshiñga nezhokshaldiamake, ¿ji shi atshakue nagatsá? ");
INSERT INTO kog_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Akldukañguake akiyó: —¿Jinak shi janshizhe naugé maldaxaldék? Ezuañgaba auxaga janshizhe, eñki Saldiñga netshi Jate za naldashá. ");
INSERT INTO kog_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ejañga guiyaba atsha nexaldixa nauwibamak zʉñkageneja guaká mikuega. Aijañki ekí guaka: “Misewá naldagálde na askuildek guasʉ́ñze, axautshi guaxa atshasʉ́ñze, tushegasʉ́ñze, axautshi shalda naldagálde guagasʉ́ñze, mijate, mijaba akzé jañgui, kaxabetakue” guaka mikué naldashá. ");
INSERT INTO kog_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Guñguake akiyó: —Eñki guagamak sukuak zhinik amak atshijiñga kaiga naldashakú. ");
INSERT INTO kog_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ekí akbeyaté nukatshakna Duweja akbeyá: —Ezua agatsalda atshakuega migatsaldashá. Aiki, jika mixaldauxa nuk nabesá xaldeki nashi jika agajueshkakuek makauwaldí. Ekí matshaldiakna, jékaldaxa niñkauwañki, Jateja matshuuwi janshizhe mixatshaldixa. Mikbenugamak matshaldiniki nagapa neyaldá makualdí. ");
INSERT INTO kog_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ekí nukatshakna, ai sanekaki zʉ́xaitsha kabia nalguakna zʉxaita itshaná. ");
INSERT INTO kog_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ekí tuatshakna Duweja ekí guak: —Kabiakueki “Saldiñga netshi Jate shi naksaneshí” izhgakugexañki ¡mitsá jibañ kakzeka ne! ");
INSERT INTO kog_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Akze, ezua kabiaja Jate za ají Sáñkalda ishkizhaxaldiamak izhgakugexañ jibañ akzeka. Aiki ezua béyakze atema skalda pokuéñ agaskaitazhákldegamakbe jana ne nakldá. ");
INSERT INTO kog_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Guatshakna aldukatoxekueja ekí agalduká: —Amak keyakualdexañ ekí jibañ nake, ake, ¿me iyakualdaka ne? ");
INSERT INTO kog_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ekí nukatshakna Duweja kakiyó: —Kágubakueki ji atshazháka ne, Saldiñga netshi Jate zʉnake atshakagaba nakldá. ");
INSERT INTO kog_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ekí nukatshakna Péguldujañki Duwek ekí akbeyá: —Nasʉñki migapa neyakualdiamak, jika zʉñkaldauxa nuk majá guáñkalde naldashá. ");
INSERT INTO kog_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Guñguake Duweja akiyó: —Namak miñmeyaldikue. Mieldeke “Jate za ni naksanexaldí” izhgakushi na, ají juwí, asewá, akajakue, ajatekue, ají sukuakue majaka izhgakuxaldiakna, ");
INSERT INTO kog_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ji majane guashiñki zhakaldak jai kagiga jiak Jateja agexaldixa. Gualdiniki niuwizhíne jékaldaxa zʉnake aldunaxa auxaga akzukui izhoshiñga izhokshataná nakldá. ");
INSERT INTO kog_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ekí kakbeyatoguenik, Duweja aldéñ 12 shaxaldixakuegaba san kauldeji ekí kakbeyá: “Jeldusaldéñka kaldeñká na neyañkaldók. Exaki Jatetshi múldigaba naldiñga zʉxaitshixakueja nas Jatetshi Asukuága ixagabaldekldugek sakí nagatsexaldixa guakldanauxa zexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Exaga na, nauwisaná juldiú naldagáldekuek naxaxexaldixa. Aikueki naziyajokldexaldixa, jiwak akzaldi nalda naxakuaxaldixa, tup tup naxajanashaldixa, ");
INSERT INTO kog_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kuizhushak nagaldabikshaldixa, aldiweki nakuaxaldixa. Ekí nakuaxa guanaldixa jiak, maiguake mokue izhgaldaxaldikue niyó.” ");
INSERT INTO kog_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ekí kakbeyatshak jiaga, aldéñ shaxaldixakuejañki “sakí guashiñga ni ekí guak” kakldegazhá. Jinake naldakí. Jatejañga sakí zexaldixa guashi guaká aldukazháldixa kajañguane naldakna, kagajieñguazhá guane nak. ");
INSERT INTO kog_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Guñguenik Duwe Jesú kuíbuldu Jeldikóxa naki neji guatoguéñ, ai jiúñgulda xezhakga ezua sigí uba isé zʉshishiji na izhoxá. ");
INSERT INTO kog_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nalgué na, aija káguba matshuwi zʉxaitaté nukatshak izuká: —¿Ji shi ekí negapán? ");
INSERT INTO kog_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Guake ekí agabeyá: —Ezua sigí Jesú, Nasaldéxa zalda na zʉxaitapán. ");
INSERT INTO kog_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Agabeñguake ekí agatsaldi ixauldá: —Duwe Jesú, mañki nauwibama sáñkalda Dabítshi atukuaga maldé, guañ maldajañgualdí. ");
INSERT INTO kog_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ekí kauldaté aldukatshakna, sajañga neyatoxekuejañki ekí axaldék: —¡Sʉnjá nogakueki tuakí shi maldá! Ekí axaldegatshak míñgaki akldé jaldáñ ekí kauldaldá: —Mañki Dabítshi atukuaga maldé, guañ maldajañgualdí. ");
INSERT INTO kog_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ekí negaté nukañguake Duwe neyatogué agaldaxeni agakuxal guak. Amak akualdagatshak ekí aklduka: ");
INSERT INTO kog_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Sakí shi amak guañ miguanakue maldajañgú? Guake akiyó: —Nají Sáñkalda, zʉtundana ni nakzék. ");
INSERT INTO kog_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Guake Duweja akbeyá: —Ake, señ stuwá. Mañki “uba nazikukshaka shakldá” najañgui, alduna nazishamaldéñ zhinik na uba mikuká ni gu. ");
INSERT INTO kog_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ekí akbeyatshaga na zʉtualdá. Guake Duwek agapa neñká, Jate akldé akzamakga akzukui na neyá. Ekíga na, saldiñga ekí atunekueja jiaga Jate za akldé akzamakga na agazukuá. ");
INSERT INTO kog_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Amak neyatoshiñga na, Duwe Jesúki Jeldikóxa izhañkañgueni zʉxaitaldá. ");
INSERT INTO kog_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Exaki ezua sigí Sakeyo axezhuka na izhoxá. Eñki sáñkaldak akiyalzabine zhiksuikakuetshi sáñkalda izhoguakna kabia na naldá. ");
INSERT INTO kog_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aldéñki Duwe Jesú tundana akzegatshak jiaga, tuasʉ́ñ na tuwá. Jinake naldakí. Aldéñki nóñgutse naldatshakgaba Duwek káguba matshuwi duwá agayogatshakna tuazháka naldák. ");
INSERT INTO kog_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Akna, Duwe neyaldieñka axañga naldajiñga neñguenik, muldetua tualdiamak kaldixa iyabexá. ");
INSERT INTO kog_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Guane nogueñki Duwe eñ zʉxaitatshake mateldi stuwi Sakeyo ekí akbeyá: —Nauwateñgaba akjiena guwá. Nas kaigaki mijuxa kabagakue na nagatsá. ");
INSERT INTO kog_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ekí axaldeguake nauwateñga amak akjiengueniki zeñ akldeshiñgaba ipani na ekí akbeyá: —Najuxa janshibé maldexabaxaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Guatshakna saldiñga tuatoxekueja Duwe nalda axakuashi ekí na yaldegapaná: —¿Sakí shi sigí sha atshixa tshuxa kabaxal ne? ");
INSERT INTO kog_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Exa aldeyatshak Sakeyoja izhgaldaguenik ekí Duwek akbeyá: —Nají Sáñkalda, naldukaté nogwá. Ji naxaldahauxa muan naldashiñki nashi jika agajueshkakuek kakauwaldikue. Mieldekueki sáñkaldak akiyalzabiyatshak ketsaji juizhi kekuxanuge naldaldiake, aikueke maxáiñjuizha naldashi kagishkualdikshaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Guñguake Duweja akiyó: —Kaigaga ma, mijúk zaldakue juizhi Jate mimekuá ni gu. Akbiñgaki, ma jiaga nauwibama Abaldahámja Jatek alduna ishixa nanamakga ishamalde nak. ");
INSERT INTO kog_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Akze, naski Jatetshi Asukuága ixagabaldekldugeke mieldekue agitshuaná guanekue mokue kaldiji, kezhañgashi, kekualdaldikuamak kagik naklduge nakldakú —na akbeyá. ");
INSERT INTO kog_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kágubakuejañki Duweja ekí shizhiyaté aldukatogueñga na, mokue ezua ajanashakldegéñ zhinik shi kaxaldiyaldá. Jinake ekí shi kaxaldiyazhá. Naki Jeldusaldéñka neji guatoxakna, kauwizhéñ ajañguatoguéki exa neyatshaga, Saldiñga netshi Jate sanegapani na, Duweki sáñkalda izhokshaldixa ajañguatoxák. ");
INSERT INTO kog_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nalguakna ekí shi kaxaldiyaldá: “Ezua sigí sáñkalda nexa sana nalgué, ají kagitshi sáñkalda akldé akzé iyaldaxaldiamak maldé zeñka niuwi izhgashishal nenaldinik, mokue sanexal naxaldixaga neyaldá. ");
INSERT INTO kog_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Guñguakna uguá ají nashikue agixauldal guagueniki zhualduxañgaba paldata anuñka naldashiñgaba kageshi na, ekí niuwi kagé: ‘Nas nenaldikueni mokue naxaldikuéñ yo, jejié paldata akldé nakizhikldexaldiamak jiba naxakbeyal minoxaldí.’ Ekí kakbeñgueniki amak ne na gua. ");
INSERT INTO kog_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Guatshakna ají kuíbulduk zaldakuejañki kaguldiji na, anuñka nekue niuwi axegeñka ekí guaxal axaxá: ‘Nasʉñga ejié sigí nauwijí sáñkalda akldé akzé izhagakue jañguakí ni kaldá.’ ");
INSERT INTO kog_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","”Ekí akuagatshak jiaga, kauwijí sáñkalda akldé akzé iyaldagueniki sanexal mokue nak. Nagueniki ají nashi paldata agenekuek mitsá akizhikldekshane kagatuwexañ agixauldal guak. ");
INSERT INTO kog_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Guake kasakldejañki axaldagueniki akbeyá: ‘Duwe, mijí paldata nagemaldeki uguá juizha mikizhikldekshanuge nakldá.’ ");
INSERT INTO kog_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Guake sáñkaldaja akiyó: ‘Mañki nají nashi janshibé naxatshamalde nukshí. Nají paldata nauwamé ne jiaga, muldetua jiba naxakbeyakuamak naxatshamalde shalda, kaiga míñgaki akldé alduna mishiji na, uguá kuíbuldu maldagaksanexaldiamak niuwi migexaldikue.’ ");
INSERT INTO kog_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Guñguenik jiak, mozhua neja axaldagueni ekí akbeyá: ‘Duwe, mijí paldata nagemaldeki jatshiwa juizha mikizhikldekshanuge nakldá.’ ");
INSERT INTO kog_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Guake akiyó: ‘Mañki jatshiwa kuíbuldu maldagaksanexaldiamak niuwi migexaldikue.’ ");
INSERT INTO kog_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","”Guñguenik jiak, mokue ezua nashija axaldagueni ekí akbeyá: ‘Duwe, mijí paldata nagemaldauxaga jaiga tiuwi. Migitshuanazháldiamak paniuwizhuk mañgua mikibexá nuxa guanuge. ");
INSERT INTO kog_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mañki zhe nakzukui na ekí nuxa mixatshanuge. Jinake zhe nakzukuakí. Mañki mijí nashikue tu me guabálde, axautshikue jibañ naldi jiba ajanashane zhiksuishi mizhuka nak.’ ");
INSERT INTO kog_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ekí akbeñguake sáñkaldaja akiyó: ‘Mañki nashi shane maldé, axaldáñga mijí múldigaba nakbeyamaldekga migatsaldi ne ni axamildák. Tukí naski nashikue tu me guazhúge, axautshikue jibañ naldi jiba ajanashane zhiksuishi izhokuge mikualdi nak míñgaki, ");
INSERT INTO kog_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿jinak shi paldata zhikldegeñka nauwa nuxaki nakizhikldexaldiamak nakibegazhá guamaldá? Ekíki mokue naxaldatshake, nauwa akldé nuxaki nakizhikldeklde ipanaldikuamak.’ ");
INSERT INTO kog_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","”Guñguenik exa zhekualguekuek ekí kakbeyá: ‘Jaldek paldata ikuxa xaldeki nashi uguá axaldék niñkauwañki agé guwíñ.’ ");
INSERT INTO kog_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ekí kakbeyatshakna ekí akiyayó: ‘Duwe, ejañki uguá juizha zhikldekshane axaldáñga nogashá.’ ");
INSERT INTO kog_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","”Guñguake sáñkaldaja kakiyó: ‘Ekí miñmeyaldikue. Mieldeke ji axaldé muldetua jiba akbeyakuamak jiba akbeñka naldaldiake, jiak akldé agaxexaldixa. Ekí ne, mieldeke ji nauwamé nuxa axaldé muldetua jiba akbeyakí naldaldiake, ji nauwamé axaldauxagaba iyakuxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Guatshak kaguldiñkugekue kauwijí sáñkalda ité naxajanazhánekue zʉnake jai nas nugeñgaba kauldák xaldeki nuk kakuaxa guwíñ.’” ");
INSERT INTO kog_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Duwe Jesúja ekí shi kaxaldiñgueniki, agapa neyatoguekuek kaksajañga Jeldusaldéñka neñká mokue neyaldá. ");
INSERT INTO kog_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nejiñga na, gaxa akshá zeñka Oldibuxaga mozhua kuíbuldukue ezuañki Betapaje, ezuañki Betania naki neyatshak, Duweja aldéñ shaxaldixakue mozhuañki aksajañga kakagapanatshak ekí kakbeyá: ");
INSERT INTO kog_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Uñguexa kuíbulduxa newiñ. Exa juldu me miñguatshake, ezua buldu awawa jiba agabeyagáldega shaklduka axaldí mitualdixa. Ekí mitualdiake, axawati minakuldaxaldí. ");
INSERT INTO kog_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Amak miyaxawatiyatshake, ezuajañki: ‘¿Jinak shi axawatiyabipán?’ miñgaldukaldiák ekí miyokualdí: ‘Nauwijí Sáñkaldaja agajuezhá guak.’” ");
INSERT INTO kog_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Amak kakaguake eñka aldeyatshake, Duweja kakbenalguauxabe atú. ");
INSERT INTO kog_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ekí atuñguake buldu awawa axawatiyatogueñki ajáugukuikueja kaklduká: —¿Jinak shi buldu awawa axawatiyabipán? ");
INSERT INTO kog_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Guñguake akiyayó: —Saldiñga netshi Sáñkaldaja agajuezhá guak. ");
INSERT INTO kog_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Guñgueniki buldu awawa Duwek akualdaguenik, kauwijí zhakuá abakaldak kejuakuekue akiyapañguñgueni Duwe iyabekshá. ");
INSERT INTO kog_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Guñgueni amak íte neyatoguéñ, kágubakueja Duwe akzé atuwi na neyaldiéñ zhakuá abakaldak kejuakuekue abuapañgui na akuá. ");
INSERT INTO kog_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Guñguenik gaxa Oldibu akshá zeñka zhinik zabapanatshake, saldiñga agapa neñkakueki duwá zhikzhe zeñ kakldeshiñgaba aldéñki janshizhe ajanashaté atú guazhámak atshaté atune shalda na, jaldáñ Jate akldé akzamakga agazukui na ");
INSERT INTO kog_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ekí akuagapaná: —¡Jate, nauwijí Sáñkaldaja jejié Sáñkalda akldé akzé izhaxaldixa atsaldí zʉñgakaxane, aldéñga zeñ shi jañguí! ¡Nauwijate jékaldaxa izhuka aldéñ na señgaba zhe shi zʉnaldokshí! ¡Jate jékaldaxa izhukaki akldé akzamakga kuizakzukuí! ");
INSERT INTO kog_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Guatshakna káguba matshuuwi zhekualdé kenaxaga anuñka paldiseyukueja ekí akuagaté aldukatshakna, Duwek agabeyá: —Shi maldazʉñkaldixa, migapa neñkakue ekí ma shalda akuagatshak, “ekí negagába nogwíñ” kaxaldegakueki ¿tuakí shi maldá? ");
INSERT INTO kog_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Guñguake kakiyó: —Namak miñmeyaldikue. Ekue ekí akldé nagazukuaksá gualdiake, ake, jagikue niñkauwañki ekíga nagazukui saldiñgaja nukandana akuagapanaldixa ni mitú. ");
INSERT INTO kog_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Guñgueni naki Jeldusaldéñ neji kuíbuldu tuatshakna, Duweja ai zaldakue shalda kebauwi ");
INSERT INTO kog_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ekí guak: —¡Maiñ Jeldusaldéñ zaldakue sakígaba aldunaxa señgaba miñzeshi mimezhokshaka kaiga miñgajiená guakue ni mimajañgukú! Miñgajiená guashiñki, Jateja amak mimezhokshaka naldataldé ne, kaiga zʉnake miñgajienazháldiamak miñkibexá guane. ");
INSERT INTO kog_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Guatshak ezua ldiuwañ zexaldixaki miyaguldiñkakue kaumiñshál miñkaldagatshak, muldetua me yo minabategatshakna, ni miya ga nakuigakue tuabináldixa. ");
INSERT INTO kog_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Atshakna saldiñga eni mizhekuekue maiñ, mimijí sukuakue juizhi muldetua nuk mimakuaxaldixa. Mimijí kuíbuldu jiaga nuk atiñgui, ni ezua jagi nuxaki zhikté abazháldixa nakldá. Jinake ekí miñgatsexaldixa naldakí. Saldiñga netshi Jateja ezua mimekualdal gagatshak jiaga, miñnegazhá guane nak. ");
INSERT INTO kog_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Guñgueni Jeldusaldéñ neyatshak, Duweki juwí Jate axazakuageñka juldú. Exaki jigaba Jatek agaxexaldixa atshasʉ́ñzamak juizhi nabeyasaté tuatshakna, eñka zhinik kaldeñshi ");
INSERT INTO kog_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ekí kaxaldék: “Najatetshi múldigabak ekí guashi sezheklde: ‘Nají juwíki nas za naxazakuagéñ zaldaldixa nzha.’ Ekí sezheklde ne, ¿maiñki mitushexaldixa jube nuxa guamine shi mimatuñkú?” ");
INSERT INTO kog_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Atshake Duweja niuwi neyauxa juwí Jate axazakuageñka shi kaxaldiji na guatoxá. Guatshak Jatek múldigaba agaskaitshixakuetshi sáñkaldakueja, guiyaba shizhixakue, juldiútshi aksanekakue juizhi, Duweki akuaxaldiamak aldiyá na noxá. ");
INSERT INTO kog_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ekí aldiyatshak jiaga, amak akuexañ kakzaldazháka atú. Jinake naldakí. Duweja shi kaxaldiyatuka saldiñga kágubakueja aldukandana kakzeshiñgaba ai za axaldukal ashekualdák. ");
INSERT INTO kog_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ezua ldiuwañ Duwe Jesúki Jate axazakuageñka kágubakuek sakí Jateja kekualdaldixa shi kaxaldiyatoguéñ, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue, juldiú nauwa akldé akzekue na axaldagueni ekí agalduká: ");
INSERT INTO kog_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—¿Mañki mani zalda niuwi guxamalde shi ekí atshiji, shizhiyabaldók? ¿Meja ekí matshaldixa niuwi migene naldaka ne? ");
INSERT INTO kog_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Guñguake kakiyó: —Ake jiak, nas ezua miñnukaldikue. Ai nakiyó guwíñ. ");
INSERT INTO kog_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Juañ nik majaukshakueki, ¿meja káguba nik jaukshaldiamak shi niuwi agená? ¿Jate jékaldaxa izhukaja azhi kágubaja nuxa niuwi agene shi na? ");
INSERT INTO kog_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ekí kakldukañguake kauwizhéñgaba sakí akiyayokualdixa ekí izhgabeyaldá: “‘Jate jékaldaxa izhukajañga niuwi agenane nakldá’ akiyokuakualdiake ekí zʉñnukaka: ‘Tukí Jatejañga niuwi agene nalguake, ¿jinak shi aldéñ shi miñkaldiyatshak “namak ni guak” jañguazhá guamine na?’ ");
INSERT INTO kog_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ne ake, ‘kágubaja nuxa niuwi agenane nakldá’ yokuakualdiake kágubakueja kakldunazháldi, jagi zʉneyabushi zʉnakuagaka naldashá. Jinake naldakí. Kauwizhéñ ‘Juañki Jatetshi múldigaba naldiñga zʉxaitshixa nane shakldá’ ajañguxa nak.” ");
INSERT INTO kog_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Guakna ekí nuxa akiyayó: —Mejañga Juañ niuwi agenane zʉñsʉ́ñ nzha. ");
INSERT INTO kog_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Guñguake aldéñ ekí nuxa kakiyó: —Ake jiak, amakbeñki nas jiaga ekí atshiji, shizhiyaldikuamake meja niuwi nagene miñmeyazháldikue nakldá —na kakiyokuá. ");
INSERT INTO kog_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Guñgueni Duwe Jesúja mokue ezua ajanashakldegéñ zhinik exa zhekualguekuek ekí shi kaxaldiyaldá: —Atiuwiñ zalguéñ ezua tetshi ajáugukuija ají tek kalwé zhenka nixá. Nigueniki anuñka sigíkuek axabajá guñgueniki, aldéñki awaxani, maldé zaldi anuñka izhoxal ne. ");
INSERT INTO kog_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Amak neñgueni, eñka izhoshi na, kalwé akuiyaldiéñ zeguake, ezua ají nashiga te axabajanekue nugeñka ajíki muan agaxexaldiamak agakuxal gaxá. Guane nalgué, nashi amak eñka neyatshake abushiñgaba akuñgueniki egabañga mokue axaxá. ");
INSERT INTO kog_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ekí tetshi ajáugukuija ajanashane nukañguake, jiak mokue ezua ají nashi gaxá. Guane nalgué amak eñka neñguake, aiki aguáñ izhabashi mual axaldeshi, akzaldi agaldabikshijiñgaba akuñgueniki, egabañga mokue axaxá. ");
INSERT INTO kog_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ekí ajanashane nukañguake, jiak mokue ezua ají nashi gaxane nalgué, aiki akiyasalshiñgueniki egabañga mokue agazaxaitshá. ");
INSERT INTO kog_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","”Ekí ajanashiñguake te shjáugukuija ekí zhiklduká: “Guake, ¿sai atshanaka ne? Nasukuá giemi izhgajañguge natsaldí kagakaxaldikue. Eñki axabetá akualdixa ni jañgukú.” ");
INSERT INTO kog_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Guane nalgué, amak asukuá gaxane exa neyaté atuatshakna, te axabajanekueja ekí izhgabeyá: “Uñkuejiéki te shjáugukuitshi asukuá nakna, jejié te bieni ipanaldixa. Akna, nasʉñ niñkauwañki ají bieni ipanakualdiamak guaxá kuizguí.” ");
INSERT INTO kog_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ekí izhgabeji, iyapangueni kalwé xaldeldi zhinik agazaxaitshiñgueniki akuaxá. ”Akna tetshi ajáugukuija ekí atshanekueki ¿sai kakualdixa shi mijañgú? ");
INSERT INTO kog_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Akze, exa neyaldiniki te axabajanekue nuk kakuaxá gualdinik, ají kalwé xaldaki axautshikuek niñkauwañki kaxabajaldixa nakldá. Ekí Duweja kakbeyatshakna nukatoguekueja ekí akuák: —Ni mitsák Jateja ekí zegakue shi jañguazháldi. ");
INSERT INTO kog_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ekí agabeyatshakna Duweja katuaté noshi ekí kakbeyá: —Ekí zegazháka guashiñki, ake, Jatetshi múldigabaja ¿sakí guashi shi ekí guak?: “Juwí gauxakueja ezua jagi zauwazháka ajañgui awateyá akuane. Ne aiga na jagi abuwa akldé akzé juwí muldetua agatsaldakuamak agatsé sekuá guane nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Akna mieldeki ai jagik akbini penatshak matshuwi agisaldamakbeñga aldéñga izhgisalshaldixa. Ne ai jagiki mielde bakaldak akjienatshak guaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ekí ajanashakldegéñ zhinik shizhiyaté aldukatshakna, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue juizhi kauwizhéñ kagatsaldi ne katuñshi ekí guaklde kagajienakna, Duwe ubañga akuxaldiamak aldiyaldá. Guatshak zheñga kágubakueja kakzukuakna, ajanashazhá na akuá. ");
INSERT INTO kog_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Akna, sáñkaldakueja Duwe Jesú be axaldoshi, ezuakue ziñ me axaxá. Aikueki Duweja guagatuka namak ajañguxakue ga abeldashi na, ji guakldéñ zhinik nuxa agatsé ne izhakuaxaldiamak aldiñkakue. Ekíki Duwe iyapanaldinik Alduma zalda sáñkaldaja sanexaldixa itenek agaxexaldiamak. ");
INSERT INTO kog_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Akna Duwek ekí agabeyá: —Shi maldazʉñkaldixa, mañki namak za mazukuaka, namaklde za shi mizhixa maldazʉñkué. Ekí shizhiji na, Jatetshi jiúñguldaki jian nahauxabé shi mizhixa. Mañki me naldaldí, aikueja nuxa sakí jañguakue, atshakue mikbeyatshak jiaga, aibé kaxalduka guabálde. ");
INSERT INTO kog_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Akna ¿Aldumatshi sáñkalda akldé akzé akilzabiyakue zʉñsanegamak shi akilzabiyakue naldaka na? ");
INSERT INTO kog_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ekí agaldukatshake kakiyokuéñ zhinik izhakuaxaldixa kakldeshi agaldukatuka Duweja katuakna ekí nuxa kakiyó: ");
INSERT INTO kog_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Ezua muneda Alduma zalda natuñsha guwíñ. ¿Jeñkáñ metshi waxa shi axaldí mitú? ¿Metshi axezhuka jai aksezheklde shi mitú? Guake akiyayó: —Ejiéki sáñkalda akldé akzé Aldumaxa zaldatshi nakldá. ");
INSERT INTO kog_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Guake Duweja ekí kakbeyá: —Ake, sáñkalda Aldumaxa zaldatshi nake agexal minokldék. Ekibeñga na, Saldiñga netshi Jateke ji agegakue miñgatsahamak miyagexaldí. ");
INSERT INTO kog_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kágubakue kenañ ekí kakiyokuatshakna, sakí zhinikga Duwe agatsé ne izhakuagaka kakzaldazhá. Egaba “¡sakí ekí jañguanega yokuxá!” ajañgui na, sʉnjá ashé nuxa na aldoxá. ");
INSERT INTO kog_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Guñgueni anuñka saduseyukue Duwe axaldák. Ekuejañki kágubakue ashuanaldinik Jateja mokue kezhgaldakshazháldixa ajañguxakue naldakna ekí agalduká: ");
INSERT INTO kog_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Shi maldazʉñkaldixa, nauwibama Mueséja nasʉñ juldiúkuañ ekí atshakue zʉñmeji, kalta zʉñkabashanane. Ezua sigí sukua axaldegagáñga shuixaldiake, akaja giemijañga ai tsewa nane gugakue agatsaldaldixa. Ekíki akaja shuane tsaldiñga sukua axaldekldaldixaki ai shtukua nitshixalga noxaldiamak. ");
INSERT INTO kog_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ekí nalgué atiuwiñ zalguéñ, zhuakajagaba kugua sigíkue aldalgué, kasak zaldaja munzhi guxane nalgué, sukua axaldegagáñga shuizhá. ");
INSERT INTO kog_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Guñguake mozhuaneja, ");
INSERT INTO kog_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","maiguaneja ai tsewa nane guxá. Guane nalgué, aikue jiaga sukua axaldegagáñga ashuizhá. Guñguenik exa zhinik jiak, galdeni nekueja ekíga ai munzhi akugatshak jiaga, kugua aldalguauxa sukua abajagáñga ashuizhá. ");
INSERT INTO kog_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ekí nuk ashuigueni, aldiweki munzhi jiaga shuizhá. ");
INSERT INTO kog_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ekí zeklde ne, Jateja káguba ashuanaldixakue mokue kezhgaldakshaldixa ldiuwañ zegatshak, munzhi sigí zhuakajagaba kugua axaldane nak, ¿atshake mielde tsewa naldaldixa shi na? ");
INSERT INTO kog_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Guñguake Duweja kakiyó: —Káguba kagik izhukakueki numa neshi, numa nexaldiamak geshi ajanashanamakga ashekue. ");
INSERT INTO kog_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Naldatshak Jateja kagi abisa gauwatshak mieldekue ashuanaldinik kezhgaldakshi kezhokshakue kagatsé katualdixakueki, exa numa aldegazhítakue nakldá. ");
INSERT INTO kog_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Akze, ekueki Jateja guaklde uldeñkakue shuigazhítakue nahamakbe, ni mitsák mokue shuigazhítakue naldaldixa. Ekíga na, Saldiñga netshi Jateja ashuanaldinik mokue kezhgaldakshaldixa izhoshiñga kezhokshaldixa nakna, ají sukuakue giemi aldaldaldixakue nakldá. ");
INSERT INTO kog_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","”Guatshak Jateja káguba ashuanaldixakue mokue kezhgaldakshaldixa shalda nauwibama Mueséjañga zʉnatuñshi ekí kalta gauwane: Saldiñga netshi Jateja kaldi puldatukak zhinik “Nasga na mibama Abaldahámtshi, Isáktshi, Jakóptshi Ajatega nzhakú” guaklde. ");
INSERT INTO kog_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Akze, Saldiñga netshi Jateki shuanekuetshi Jate naldazhé, ne be nukakuetshi Jatega nakldá. Jinake naldakí. Aldéñ tuwiñki, saldiñga shuanaldixakue beñga nukakue katuñka nak. ");
INSERT INTO kog_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ekí agatsaldi kakiyokuatshakna, anuñka asanátshi guiyaba shizhixakuejañki ekí akiyayó: —Shi maldazʉñkaldixa, janshibé ni makuák. ");
INSERT INTO kog_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Guñguakna ni meja akldé akzʉzukaldixaga izhajanazhá na akuá. ");
INSERT INTO kog_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Guñgueni Duwe Jesúja ekí kakbeyá: —Saldiñga netshi Jateja káguba ikualdal ezua gaxaldixa guakldane, ¿kágubakueja sakí shi nauwibama sáñkalda Dabítshi atukua za ne akuagaka na? ");
INSERT INTO kog_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ekí akuaka ne, nauwibama Dabíja naldiñga Jatetshi múldigabaga zubeyakue xaltek ekí guashi gauwanane: “Saldiñga netshi Jateja nají Sáñkalda Zʉnekualkak ekí akbeyá: ‘Nas saldiñga aksanegatokugeñga, jibatshugaldi mual akldé akzéñ naldesañ yate guwá. ");
INSERT INTO kog_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Naski maguldiñkakuek auxaga magubishaldikueñka yo amak mizhoxaldixa nakldá.’” ");
INSERT INTO kog_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ake, nauwibama Dabí aldéñ naldiñga káguba ikualkak “nají Sáñkalda” axaldeklde nake, jiak ¿sakí shi atukua za naldaka na? ");
INSERT INTO kog_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Guñgueni saldiñgaja aldukatoguéñ, Duweja aldéñ shaxaldixakuegaba ekí kakbeyá: ");
INSERT INTO kog_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Guiyaba shizhixakue atshamakga atshabináldiamak muldetua numañ miyatualdí. Akze, kauwizhéñki kakzé kawatualdiamak na zhakuá wézhilduka izhatshualdixa. Kágubakue zheneñka aldeyatshak, kaxabeti mual za kaxazakuagakue izhajankakue. Juwí izhajuizhaldegeñka aldeyatshak, azhi mieldegaba abuzál aldeyatshak, akldé akzekue iyaldageñka iyaldagazhá guasʉ́ñ akzekakue. ");
INSERT INTO kog_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Naldatshak munzhi sigí ishuanekueki iyasaji juizhi saldiñga ikukakue. Ne janshizhekue kawatualdiamake, kawatuatogeñki Jate maldée axazguakakue. Ekí ajanashixa nakna, Jateja axautshikue zhakaldak atemajañ guiyaba katuñshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Duwe Jesúja shi kaxaldiyatogueñga na, Jatek agaxexaldiamak akuasheñka kabiakueja paldata akuashaté katú. ");
INSERT INTO kog_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Atshaga na, ezua munzhi nashi, sigí ishuaneja mozhua muneda nauwamé akzekue kuashaté tu. ");
INSERT INTO kog_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ekí tuñguakna ekí kakbeyá: —Namak miñmeyaldikue. Jalde munzhi nashi, sigí ishuanejañki saldiñgaja Jatek agaxeká guashiñki akldé agegashá. ");
INSERT INTO kog_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Jinake naldakí. Aldéñki nashi naldatshak jiaga axaldaldauxa, izhoxaldixa juizhi Jatek agegashá. Ekí ne, kabiakueja zʉnake kagipenane nuxa axegashá. ");
INSERT INTO kog_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Guatshak anuñka Duwe aldéñ shaxaldixakueja juwí Jate axazakuaka shalda “¡Sakí ekí janshagatsegaba siyagaxaune ne! ¡Jagi janshagatsegaba, jika Jatek agaxenekue na siyagaxaunekue nak ekí janshagatse ne!” izhgabeyatshakna Duweja ekí kakbeyá: ");
INSERT INTO kog_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Kaiga na jejié juwí janshagatse mitualdinik, niuwizhíneki nuk atiñgualdixa. Amak atiñguatshakna, ni ezua jagi nuxaki zhikté abazháldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ekí Duwe Jesúja kakbeñguakna ekí agalduká: —Shi maldazʉñkaldixa, ¿ekí maldazʉñmeñkáki mitsák amak zexaldixa shi na? ¿Jiñ zhinik shi “amak zexaldá na guabatú” tuakualdixa na? ");
INSERT INTO kog_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Guñguake Duweja kakiyó: —Muldetua numañ miyatualdí, naldagálde ne namak mimajañgushaldiamak miñgabeyatshak, namak jañgui guamiñnegak. Jinake ekí miñmeyakí. Nas mokue kagik nagagá noxaldikueñga, matshuwi nekueki naldagálde nuxa nasga aldé aldeshi, “nasga na Jateja káguba ikualdal nakaxane, aiga na nakú” akuashi miñkiyaldañkaldixa nak. Ekueja na “auxa zexaldiéñ akldañká na gu” naldagálde miñgabeyatshak, “namak ni aldék” jañgui kagapa neyabináldi. ");
INSERT INTO kog_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","”Atshakna, san san kagi zaldagaba izhguabiyaldiamak axaukshi, azhi askuí kuíbuldugaba izhguabiyaldiamak axaukshi guatuka minukatshak, “auxa zexaldiéñ zek guxá nakbaldúk” jañgui zhe miñzegagába. Jinake naldakí. Auxa zexaldiéñ zegagáñgaki axáñ misha ekíga zegakue zaldaldixa, naldatshak jiaga ubañga auxa zek guazháldixa nak. ");
INSERT INTO kog_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kakbeñgueni: —Ekí zeshi na, ezua saná, axautshi saná na izhguabiyaldiamak axaukshaldixa. Ekibeñga na, sáñkalda san san zaldakuegaba izhguabiyaldiamak axaukshaldixa. ");
INSERT INTO kog_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Atshak saldiñga kagi kakshata atemajañ neji, gakue naldaksáñga ne zegatshakna maldija kakuí, mulbatá atemajañ kakzexaldixa. Atshakna, alnobaxaki atemajañ mitsheñshindana zegaté atuatshakna, “¿sakí zegapanaldixa ne?” kakldeshi, zhe kakzukualdixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","”Naldatshak amak zegagá noxaldieñga, nagapa mineñka shalda nuxa minapanaldinik sha mimakualdixa. Akze, miñgatsaldi ne mimawatualdiamak nauwisanákuegaba izhajuizhaldegeñka mimawaldeyaldinik kalseldi mimabexaldixa. Ekíga na, nagapa mineñká shalda sáñkalda aguáñ akzé, akldé akzé nugeñka miñgatsaldi ne mimawatualdiamak mimawaldeyaldixa. ");
INSERT INTO kog_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eñkaki Jateja minkualdal nakaxane shalda kakbeminakaga mitualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Naldatshak amak mimawaldeyagáñga, maiñgabaga “sakí zhikzukuaxaldikue ne ijanazháldiku” itshanakue. ");
INSERT INTO kog_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Jinake ekí miñmeyakí. Atshakna, nas naldiñga múldigaba ishkué ga miyaguldiñkakuek kakiyokuakue miñgexaldikue. Amak miyokuatshakna, ekueja miñkiyokuazháka, miñkiyatamakuazháka atualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","”Nepanaminekuañki mimijatekue, mimikajakue, mimisanákue, mimipebukue neyapanazhánekue aldák miyaguldiñkakuek mimagaxexaldixa. Akna anuñka minekuañki mimakuaxá gualdixa niyó. ");
INSERT INTO kog_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Akze, kagik káguba zhekuauxa zaldakuek najíkue miné shalda nuxa miyaguldiyaldixa niyó. ");
INSERT INTO kog_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Naldatshak sakígaba abuáke sha mimakualdiák jiaga, aldunaldi zʉnake sha mimakuazháka naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Naldatshak mieldeke nas shalda guiyaba tuakue miñgatsegatshak jiaga, abá naldakí nagapa neyal za mizhekualdaldiák zʉnake, mimeyakuane jékaldaxa izhoshiñga mizhogataná nakldá. ");
INSERT INTO kog_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ekí kakbejiñga na ekí kakbeyá: “Maiñ mitsák suldáu san kagi zaldakueja Jeldusaldéñ kaugagashál yabategaté mitualdiák, ‘kaiga zʉnake jalde kuíbuldu agaldañgashaldiéñ zek guxa nakbatú’ miñkualdaldixa. ");
INSERT INTO kog_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ekí zexaldá guxá mituatshakna, Juldeya baxe mizhekualdaldiake akldé gaxa akshá zaldi minakuixaldí. Kuíbuldukga mizhekualdaldiake ai zhinik akzʉxaiti mineyaldí. Azhi mieldeke agajué mizhoxaldiák kuíbulduk nagagába. ");
INSERT INTO kog_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jinake ekí miñmeyakí. Jatetshi múldigabaja jalde kuíbuldu sakí guiyaba tuñshaldixa guakldanauxa amak zexaldiéñ akldañkaldá guapanák. ");
INSERT INTO kog_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Amak zegatshakna, munzhi somá axaldegatukakue, somá axaldukakue aldakuigazhákakueki ¡wau wau wau mitsá jibañ atualdixa ne! Atshakna, Jateja guiyaba katuñshi, saldiñga jalde kagik zhekuekueki atemajañ guiyaba atualdiéñ zexaldixa. ");
INSERT INTO kog_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Atshak kaukshal aldagatshak, anuñka nauwisanákueki kakuaxaldixa. Anuñkakueki kakuxaldinik san san kagixa kawaldeyaldixa. Atshakna, nauwisaná naldagáldekueja nauwisanákue zʉxaita sha kakuí, kuíbuldu Jeldusaldéñ itana zalda aguabiyaldixa. Ekí zeshiñga na, mitsake Jateja juldiú saná naldagáldekue zeñ kajañgualdixa janaktunamak saldinagá noxaldieñgaki ekíga zaldaldixa niyó.” ");
INSERT INTO kog_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ekí kakbejiñga na ekí jiaga kakbeyá: “Atshakna atemajañ jibañ mitualdiéñ zexaldá guxa mimatuñshiñga na, alnobaxa zaldakue niuwi, saxa, zumeyakue ishkazguaté atú guazhámak zexaldixa. Guatshakna níbuniki zʉ́xaita kuizaté atú guazhámak kuizi na, shañgá akauldiñgaba gualdixa. Ekí zegaté aldukshi, atuwi na, saldiñga sanákueja ‘¿sakí zexaldixa ekí zegapanká?’ aldunaxa señgaba kakzegaksá zalda izhajanaldixa. ");
INSERT INTO kog_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Atshake alnobaxa zaldakue wi wi me abaldixakue nakna, kágubakue sakí zexaldixa shalda zʉxaita zalda zhe kakzekága maksʉtuáñ kakzexaldixa. ");
INSERT INTO kog_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ekí zexaldinik na, kágubakueja nas Jatetshi Asukuága ixagabaldeklduge atemajañ kama naxaldé, tuasá muñshí zalda nazizhuka mauwixa zabaté nawatualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ekí miñmeyanugamak zegapanká mituatshakna, zeñ miñneshi, abá naldakí alduna nazishalga minoxaldí. Jinake naldakí. Nas mokue kagik naki naxaldikuéñ, Najateja auxaga minkualdaldiéñ zexaldá guapanák.” ");
INSERT INTO kog_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Guñgueni kaldi atshakldegéñ zhinik ekí shi kaxaldiyá: —Kaldi zhenka, azhi mielde naldaldí, sakí atshixa jañgua guwíñ. ");
INSERT INTO kog_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kaldi axé aktinapanká mituatshake, “niuwiya aldaxaldá gualdixa nakbatú” miñkué. ");
INSERT INTO kog_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ekibeñga na, sakí zexaldixa miñmeyanugamak zegapanká mituatshakna, “Saldiñga netshi Jateja saldiñga aksanexaldiéñ zexaldá guxá nakbatú” miñkualdaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","”Namak miñmeyaldikue. Kaiga ldiuwañ mimisaná ldaxe izhoxabinuka naldalga noxaldieñgaki sakí zexaldixa miñmeyanugauxa amak zexaldixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Akze, alnoba, kagiki naldaksánaldixaga. Ne nají múldigaba zʉnake ni mitsák naldaksá guazhíta nakldá. ");
INSERT INTO kog_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","”Maiñ be noshi, muldetua numañ atuwi mizhekualdaldí. Ekíki ni jiyája Jate jañgua miñgitamakui guakuak. Akna stuxabináldi ni stukakue sha ajanashamak atshabináldi, ni jika jai kagik zalda miñgajueshká za ijanabináldi. Azhi ekí miyatshaldiák, janazhiktuazhámine noxaldieñga auxa zexaldixa. ");
INSERT INTO kog_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Akze, ezua béyakze akldegagá noxaldiéñ katúja tañguamakbeñga, saldiñga káguba zhekuauxa akldegagá noxaldieñga auxa zegapanaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Akna be noshi, jiminaktualdí. Amak minogatshakna, jibañ tuakuéñ zegapanakna Jate mimazʉxaitshaldiamak kama akshishal minoxaldí. Ekibeñga na, nas Jatetshi Asukuága ixagabaldeklduge mokue kagik naxaldatshak, miñzék naldakí minaxaldaxaldiamak Jatek akshishal minoxaldí —na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Atshaga na, Duwe Jesúja niuwi neyauxa, niuwisʉñki juwí Jate axazakuageñka shi kaxaldiji, sesʉñki gaxa akshá zeñka Oldibu axezhogeñka na izhoxá. ");
INSERT INTO kog_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ekí juwí Jate axazakuageñka shi kaxaldiyatoguakna, kágubakuejañki muñshaga axaldukal aldeji na ashekualdá. ");
INSERT INTO kog_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Guatshak Jateja juldiú saná san kagixa guiyaba atuwi ashekualgueñka zhinik kakzʉxaitshanéñ ldiuwañ be ishkiyasekui pañ ishkishshixa akjiukualdagálde axajéñ naki eñ na zegapaná. ");
INSERT INTO kog_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Atshaga na, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue juizhi kágubakue zhe kakzukui na, Duwe Jesú sakí akuxaldinik akuaxaldixa aldiyaté na aldoxá. ");
INSERT INTO kog_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ekí aldiyatogueñga na, Duweja 12 aldéñ shaxaldixa izhgakuxanega Juda Iskaldiuteki jiséja ijuldú aksanexaldá. ");
INSERT INTO kog_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Amak aksanegatogakna, Juda Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, juwí Jate axazakuageñka numañ zʉtuñkakuetshi sáñkaldakue juizhi katuál neñguenik sakí Duwe izhguashi, kagexaldiamak dulda ishkuashá. ");
INSERT INTO kog_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ekí aldukatshakna zeñ izhajaniñgaba guñguakna, “ai shalda paldata mikzabiyakualdixa nzha” agabeyatshakna ");
INSERT INTO kog_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","janshibé jañguá. Akna aldéñki mitsakgaba kágubaja atuakí noxaldiéñ Duwe kagexaldiamak niyaldá na gua. ");
INSERT INTO kog_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Guñgueni amak Jateja san kagixa guiyaba atuwi ashekualgueñka zhinik kakzʉxaitshanéñ ldiuwañ be ishkiyasekui pañ ishkishshixa akjiukualdagálde axajéñ na zegapaná. Ai ldiuwañga na jubeju zhauwa axaldixa Jatek axakuaxaldiéñ ");
INSERT INTO kog_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","zexakna, Duweja Péguldu, Juañ na ekí kakbeji kakaxá: —Maiñki ai gakue gakualdiamak janazʉñgaktuwi newiñ. ");
INSERT INTO kog_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Guñguake agalduká: —¿Mani shi gakue amak janaktuakue maldazʉnajañgú? ");
INSERT INTO kog_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Guñguake kakiyó: —Kuíbulduxa mijuldunatshake, ezua sigí moñkúk ni uldeyatuka mituatshak agapañga mineyaldí. Gualdini mashi juldunaldiake, ");
INSERT INTO kog_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","juwítshi ajáugukuik ekí miyakbeyaldí: “Shi zʉñkaldixaja ekí ni makuaxá: ‘¿Mijúk miya kaiga nas shaxaldikugekue juizhi galdikue shi na?’” ");
INSERT INTO kog_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Miyakldukatshake mateldi juizhaldék guashi atema siyagaunéñ mimatuñshaldixa. Gualdiake eñka gakue janamiyaktualdí. ");
INSERT INTO kog_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Guake aldeñgueni Duweja kakbenalguauxabé atú. Guñguake eñka ai gakue janagatú na akuá. ");
INSERT INTO kog_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Guñguenik axaldiéñ zegatshake, Duwe aldéñ shaxaldixakue juizhi asaldiamak ashená. ");
INSERT INTO kog_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Guñguenik Duweja ekí kakbeyá: —Jejié gakueki, nauwisanákue san kagixa zhinik Jateja kakzʉxaitshanéñ be izhgisekui gakualdixaki guiyaba tuwi shuigagá noxaldikueñga, ¡naski mitsá maiñ na gandana nakzeshi nagatokuge! ");
INSERT INTO kog_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Jinak ekí nakzegakí. Saldiñga netshi Jateja ajíkuañki auxaga kekualdi, saldiñga saldiñga kaksanexaldiéñ ldiuwañ zegagá noxaldieñgaki mokue ai gazháldikue nak. ");
INSERT INTO kog_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Guñgueniki Duweja jaldu, kalwéldia siyagaxaune akué zhiksuishi, ai shalda Ajatek “zeñ nzhakldék” akbeñguenik ekí kakbeyá: —Jejié kalwéldia nagipana xaldeki maiñgabaga izhgé, izhgé tugwíñ. ");
INSERT INTO kog_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ekí miñmeyaldikue. Auxa zegatshak, Najateja saldiñga kaksanexaldiéñ zegagá noxaldieñgaki mokue ai kalwéldia siyagaxaune tugazháldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Guñgueniki pañ zhiksuishi, ai shalda Ajatek “zeñ nzhakldék” akbeñguenik nauwa, nauwa zhikwatiji kagegatshak: —Jejié pañki nají abuá tsaldiñga ne miñgaldí. Amak miñgatshak, mimitsaldí shuixaldikue be zhigisekui za miñgaldí —na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Guñguenik auxa asañgueni Duweja jaldu, kalwéldia siyagaxaune akué zhiksuishi ekí kakbeyá: —Jejié kalwéldiaki nají abi tsaldiñga ne. Ai na, minkualdaldikuamak abi nakzuldi nakuaxaldiéñ naki zexaldá na guapán. Amak shuixaldatshak, Najateja minkualdaldiamak e na ishkualdi izhoxa abisa jiúñgulda miñgexaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","”Ne ezua nezhguashi, aguldiñkugekuek nagexaldixaki jai nas nañga na zatók. ");
INSERT INTO kog_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Akze namak, naski Jatetshi Asukuága ixagabaldekldugeke Najateja jananaktunamakga shuigakuega nagatsaldaldixa. Naldatshak nezhguashi, nakenaldixa zʉnake ¡wau wau wau mitsá guiyaba tualdixa ne! ");
INSERT INTO kog_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ekí kakbeyatshakna, kauwizhéñgaba: —¿Guatshake mieldek shi amak izhguashi genazʉnakaki na? —na izhgaldukajá. ");
INSERT INTO kog_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Exa ashekualgueñga na, Duweja shaxaldixakuegaba mieldek akldé akzé naldaldixa ne jiúñgulde múldigaba izhgasashaldá. ");
INSERT INTO kog_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ekí nukatshakna Duweja kakbeyá: —Jate jañguazhékuetshi sáñkalda akldé akzekuejañki nashikue aguabiji mual axaldeshi za axasaneka. Naldatshak kauwizhéñgabaki “nasʉñki nashi kagaunekakue na kaldá” aldekakue. ");
INSERT INTO kog_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ekí ne, maiñ zʉnake ekíga naldagábaki, mieldeke akldé miñzaldana miñzexaldiake, aike akldé awawakue jana aguáñ zhikzukui izhogakue miñgatsé. Ekibeñga na, mieldeke misaneka minaldaldiake, aike nashi jana axautshikuek axazauwakue miñgatsé. ");
INSERT INTO kog_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Mielde shi akldé akzé naldaldixa na? ¿Ezua zaldiamak egaba ité nuka, azhi ezua nashi gakue axaldiamak uldashi kaxazauñka? Akze, saldiñgaja tuwiñki, egaba zaldiamak ité nuka guana akldé akzé tuñka. Ekí ne, nas niñkauwañki miñkazauwi izhokuge naldashá. ");
INSERT INTO kog_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","”Maiñ zʉnake jibañ tuatogukuéñ jiaga, nabajá naldakí, nagapa nas nañga izhomine. ");
INSERT INTO kog_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ekí izhomine nakna, Najateja nas sáñkalda izhoxaldikuamak netenamakbe jiak, nas zhinik sáñkaldakue mimezhaxaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ekíki niuwizhíne auxa zegatshak, nas saldiñga aksanegatokugeñkaga nas nañga misanexaldiamak. Exaga na, sanexa xaldoxéxa zhinik nauwisaná juldiúkue 12 ldaxe nekue kagatsaldi ne azhi kagatsaldakí ne mitualdixa. Atshakna, nas na atemajañ zeñ miñneshi, minabuzaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Guñgueni Duwe Jesúja Simóñ Pégulduk ekí akbeyá: —Muldetua nuká guwá. Jiséja alduna nazishabiñsánshi mimejuldukshaka ne mimakuajaldiamak Jatek mimakshishá na gu. ");
INSERT INTO kog_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Akze, mañki mashishatshak jiaga, naski auxaga alduna nazishabiksá gui guamikldegak Najatek makbeñkuge. Mañki amak mokue nagakualdini mizhgaldagatshak, alduna nazishiji, mijanamé nagapa neñkakue abá naldakí aldeyaldiamak kagauneshi makualdí. ");
INSERT INTO kog_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ekí akbeyatshak Pégulduja ekí akiyó: —Nají Sáñkalda, naski kalseldi mawaldeyaldiák jiaga, migapañga nenaka, azhi shuigakue migatsaldaldiake, ma nañga shuanaka itshankuge nakldá. ");
INSERT INTO kog_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ekí akbeyatshakna, Duweja ekí akiyó: —Ekí mikbeyaldikue. Kaiga siañ gayu kauldagá noxaldieñga, mañki maikjuizhañga “eñki tuazhúge nzha” maldakuaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Guñgueni Duwe Jesúja aldéñ shaxaldixakuek ekí kaklduká: —Axañga Jatetshi múldigaba guaxal mimakaxaldatshak, “gamá jiúñguldak miyuldeñka, paldata ni mozhua sapatu uldeyabináldi” miñmeji mimakaxananuge nalgué, ¿jiñ shi jueñgá miñzeklde na? Guñguake akiyayó: —Ni jiñ jiaga jueñgá zʉñzegazhá na guakuá. ");
INSERT INTO kog_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Guñguake kakbeyá: —Ekí mimakaxananuge ne, kaiga niñkauwañki muldetua janazhiktumine mimakaxaldikue. Akna paldata miñkaldá, azhi gamá jiúñguldak miyuldeñka miñkaldá nake miyuldeyaldí. Shezhá miñkaldaldakí naldaldiake, miñkaldaldaldiamak mimijí zhakuák yushá miñgualdí. ");
INSERT INTO kog_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Jinak ekí miñmeyakí. Jatetshi múldigabaja nas shalda guakldanamak zegakuega zahák. Aijañki ekí guaka: “Axautshikueja naldagálde nuxa tuñkáki, aldéñ jiaga guiyabaja guagamak axatshagálde, ijulduni mual atshixa ni atú.” Ekí nas shalda akuakldauxa amak zexaldá na gu. ");
INSERT INTO kog_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Guatshakna ekí agabeyá: —Duwe, ake, jai mozhua shezhá zʉñkaldañga tiuwi. Guake kakiyó: —Auxabé nek ni gu. ");
INSERT INTO kog_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Guñguenik Duwe Jesú gaxa Oldibuxa neyamakga neyatshak, aldéñ shaxaldixakue jiaga axapa aldé. ");
INSERT INTO kog_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Exa agaldañkatshak Duweja ekí kakbeyá: “Jate axazguaxal nogwíñ, jiséja sha atshakue miñsanegatshak jiaga, amak atshabináldiamak.” ");
INSERT INTO kog_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ekí kakbeñgueniki nauwa agajué zeñka neji nuldu yoshi ekí Jatek akbeyaldá: ");
INSERT INTO kog_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Najate, guiyaba atemajañ tuwi shuigakue nagatsaldaka nakualdatshak jiaga, ma ekíga najañguamildaka guashiñki, guiyaba tuakue naxazguakí naldatabaldaldé naldaka. Naldatshak, nas jañgugamak zekuagába, ma maldajañguamak zʉnake zekuakue ni majañgukú.” ");
INSERT INTO kog_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ekí axazguagatogueñga na, Jateja guaklde uldeñka jékaldaxa zhinik ezuajañki kama agexal axagataná. ");
INSERT INTO kog_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Atshaga na, aldéñki atemajañ itshankaga, akldé akldeñga Ajate za na axazguaxá. Ekí akzeshi na, wizhi akzegatshake abi janañga na kagik akzuldá. ");
INSERT INTO kog_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Amak axazguashi aksaldiñguake izhgaldaguenik, aldéñ shaxaldixakue nugeñka nagatshake, atemajañ izhajankaga kagusá kakzeshi na kabanekue sha sha katú. ");
INSERT INTO kog_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ekí katuñguakna uba kaldeñshi ekí kaxaldék: “¿Ekí kabagakue miñgatsaldakí ne tuakí shi miná? Izhgaté xaldeki Jate axazguaxal nogwíñ, jiséja sha atshakue miñsanegatshak jiaga, amak atshabináldiamak.” ");
INSERT INTO kog_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ekí guaxalga noguéñ kágubakue duwá zhikzhe Duwe Jesú akuxaldiamak axaldák. Duweja 12 shaxaldixakue nañga agatsé Judaki ekuek aksaja axaldagatshak Duwe jañguxa jana agatsaldi ishkazakuagamakga axazguaxal aldesañ axaldák. ");
INSERT INTO kog_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Guatshakna Duweja Judak ekí akbeyá: —¿Sakí zhinik shi nas Jatetshi Asukuága ixagabaldekldugek maldajañguxa jana agatsaldi maldaxazguagatshake, nezhguashi aguldiñkugekuek nakemildaka shi mitshán? ");
INSERT INTO kog_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Guñgueni aldéñ shaxaldixakueja Duwe akuxaldixaga atuatshakna ekí agalduká: —Nauwijí Sáñkalda, ¿shezhák kaukshaldá guakue shi maldazʉnajañgú? ");
INSERT INTO kog_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kakiyokuagáñga, aikuega ezuajañki Jatek múldigaba agaskaitshixa akldé akzetshi nashi agisalshiñga tuan kuxa jibatshaldi mual axabeñguá. ");
INSERT INTO kog_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ekí tuatshakna, Duweja ekí kaxaldék: —Au auxabé nek guashá. Guagueniki kuxa axabeñguane axabenanéñ kaugipá guatshake mokue se akzukui, kuxa axabuñguá. ");
INSERT INTO kog_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ekí atshiñgueniki aldéñ Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, juwí Jate axazakuageñka numañ zʉtuñkakuetshi sáñkaldakue, kauwisanákuega nauwa akldé akzekue akuxal nakldekuek ekí kaxaldék: —Maiñ natuwiñki, ¿kágubakue sáñkaldak kaugakshishikuge nak shi ekí agatsaldi shezhá, kaldi juizhi nakuxal minák? ");
INSERT INTO kog_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Akze, naski niuwi neyauxa juwí Jate axazakuageñka mimikenáñ izhoxaldatshak jiaga, exaga ni mitsák nakugazhámine. Ne kaiga zʉnake Jatejañga minakuxaldixa janaktunéñ zek guakna, nakuxaminaka. Ekíga na, jisé tuañ zalda miñsaneka ldiuwañ zek na gu —na Duweja kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Guñgueni Duwe Jesú akugueniki Jatek múldigaba agaskaitshixa akldé akzé nugeñka awaldé. Ekí awaldeyatoguéñ Pégulduki atuasánamak aldiwan ne. ");
INSERT INTO kog_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Eñka awaldeyatshake jubaldaxa, jueyáñ zeñkaga abanekuejañki guksé ajuiguenik ajuizhaldekldéñ Péguldu jiaga kauwikenáñ yaté na gua. ");
INSERT INTO kog_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Atshaga ezua munzhi aiga jibatshixaja Péguldu waxak gukséja muñshí agastuatshak tuaté noshi ekí guak: —Jejié sigí jiaga Jesú nañga izhone nakldá. ");
INSERT INTO kog_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ekí guagatshak Pégulduja tuazhé guashi ekí guak: —Nasga ai sigí tuazhúge ne, me skandá. ");
INSERT INTO kog_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Guñguenik jiak, nauwa maldé zegatogueñki mokue ezuaja tuatshak ekíga axaldék: —Ma jiaga Jesúk agapa maldeñkaga naldashibaldá. Guake akiyó: —Miya, naski ai naldazhúge nakldá. ");
INSERT INTO kog_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Guñguenik jiak, nauwa maldé zegatogueñki mokue ezuaja ekíga axaldék: —Namak giemi jejié sigí jiaga Jesú na izhonega. Guatshakgaba aldéñ jiaga Galdildeya zalda nakldá. ");
INSERT INTO kog_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ekí axaldegatshakna Pégulduja ekí guak: —Jinakga ekí maldakuaká naksʉ́ñ giemi nzha. Ekí yokuatogueñga, gayu kauldá. ");
INSERT INTO kog_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Atshaga Duweja zhikbateguenik Péguldu muldetua señ tuatshaga aldéñ sakí akbenane Pégulduja be agisék: “Kaiga siañ gayu kauldagá noxaldieñga, mañki maikjuizhañga ‘eñki tuazhúge nzha’ maldakuaxaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ekí be agiseguakna ai zhinik akzʉxaitiñgueniki, zʉ́xaitsha itshankága mauwiñgaba na gua. ");
INSERT INTO kog_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Guatshak Duwe Jesú tuatoxekueja iyajokldeshi, agaldabikshaldá. ");
INSERT INTO kog_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ekí akuatoshi na, zʉtuazháldiamak ubak zhakuá agabañgueniki ekí axaldék: —Mañki ji atuazháka jiaga tu makuamak nake, ¿me shi mabúk? Zʉñmeyá guwá. ");
INSERT INTO kog_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ekí iyajokldeshi na, Duweki sha atshixa jana nusagatsaldi sha axaldeshiñgaba na akuá. ");
INSERT INTO kog_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Guñgueni muñzegapanatshake Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakue, kauwisaná nauwa akldé akzekue juizhi ajuizhaldeshi na, saldiñga akldé akzekue sanekakuegaba ajuizhaldék. Exaga na, Duwe awaldeyatshak ekí axaldék: ");
INSERT INTO kog_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Saldiñga netshi Jateja ezua zʉnekualdal zʉñgakaxaldixa guakldane, ai maldahamak nake zʉñmeyá guwá. Guake kakiyó: —Ne naski “ai nzhakú” miñmeyaldikuake namak naguanabináldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Azhi “¿jinak shi ekí minaklduká?” miñnukanugake ni nakiyokuabináldixa. ");
INSERT INTO kog_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Naldatshak Saldiñga netshi Jateki auxaga kama aksuikue, saldiñga aksanegatogeñka, nas Asukuága ixagabaldekldugek jibatshaldi mual akldé akzeñka izhoxaldikuéñ zexaldá na guapán. ");
INSERT INTO kog_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ekí kakbeyatshakna ekí agalduká: —Guake, ¿mañki Saldiñga netshi Jatetshi Asukuága maldé nukabaldá? Guake kakiyó: —Maiñga, ai naugé namak nakuák guashibiná. ");
INSERT INTO kog_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Guñguake kauwizhéñgaba ekí izhgabeyá: —Jejiéja axaxak naldi agatsé guaká nuká guashiñkaldá. Akna, kaiga mokue e agatsaldiñga ne zʉñmeyaldixa zʉñgajuezhaksá guashá. ");
INSERT INTO kog_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ekí izhgabeñguenik na, akldé akzekue ajuizhaldegatoguauxañga ishkaldagueniki Duwe Jesú agatsaldi ne sáñkalda Pildatuja tualdiamak akualdé. ");
INSERT INTO kog_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Exa awaldeyatshaga ekí izhakuashi akuaxaldá: —Jejié sigíjañki nauwijí kuíbuldu maiñ minazʉñsanekakue miñguabiji, kaumiñshishaldiamak katshishi ni guaté katú. Ekí atshiji na, Aldumaxa zalda sáñkalda akldé akzék akilzabiyasʉ́ñze ni zʉñsanék. Ne aldéñga na, Jateja ezua zʉnekualdal zʉñgakaxaldixaki, sáñkalda akzé iyaldaxaldixa guakldane, “nasga na ai nakú” negaté ni katú. ");
INSERT INTO kog_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ekí izhakuaguake, Pildatuja Duwek aklduká: —Guake, ¿ma shi juldiútshi sáñkalda akldé mikzé maldá? Guake akiyó: —Mañga ai naugé nakuák guashibaldá. ");
INSERT INTO kog_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Guñguake Pildatuja Jatek múldigaba agaskaitshixakuetshi sáñkaldakuek, káguba matshuwi zhikzhe nakldekuek juizhi kakbeyá: —Nasga jejié sigí sakí zhinik guiyaba tuakue agatsé axetenaka tuakí nzhakú. ");
INSERT INTO kog_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ekí kakbeyatshak míñgaki abá naldakí ekí agabeyaldá: —Jejiéjañki Galdildeyaxa zaldakue misha sáñkaldakue aguabishaldiamak, kaxa zukui shi kaxaldiyapaneni, kaigaki jai Juldeya baxe nahauxa ekíga shizhiyashá. ");
INSERT INTO kog_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ekí nukañguakna Pildatuja Duwe Jesú Galdildeya zalda ne kaklduká. ");
INSERT INTO kog_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Guñguake exa zalda ne akwasheguake, exa zalda sáñkalda Eldodeja agatsaldi ne tualdiamak agakaxá. Atshaga na, ai sáñkaldaki Jeldusaldéñga na mizhatoxá. ");
INSERT INTO kog_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Guñguake Eldodejañki Duwe tuatshakna, matshuwi zeñ akldék. Jinake naldakí. Axañga zhinik Duweja janshizhe ajanashaté atú guazhámak atshixa nukapanguenik zhinik, aldéñ naldi amak atshaté tundana akzeka nalguák. ");
INSERT INTO kog_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Guñguakna Duwe matshuwi akzʉzukshiñgaba guatshak jiaga, ni ji akiyokuazhá. ");
INSERT INTO kog_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Atshaga na, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, guiyaba shizhixakuejañki abá naldakí, akldé akldeñga Duwe izhakuashiñgaba na akuá. ");
INSERT INTO kog_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Guñguake Eldodeja ají suldáukue juizhi, Duwe aguáñ izhabashi mual, iyajokldeshi na, sáñkaldakueja zhakuá janshagatse itshualdiyamak agatsé iyajualdiñgueniki mokue sáñkalda Pildatuk akuazakáu na gua. ");
INSERT INTO kog_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Guatshak axañga zhiniki ai sáñkaldakue Eldode na Pildatu na izhguldiñkakue nane nalgué, ai ldiuwañ zhiniki zhuapebu aldék na akuá. ");
INSERT INTO kog_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Guñgueni sáñkalda Pildatuja juldiú aksanekakue, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, kágubakue juizhi kajuizhakuñguenik ");
INSERT INTO kog_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ekí kakbeyá: —Maiñki jejié sigíjañki kabiñsanekakue kauzʉñshishaldiamak kágubakue katshishixa nakizhguashi na, ai shalda agatsaldi ne tualdikuamak nakuldakbine. Naldatshak, naski maiñ natuabinogéñ, nakizhguakbinamak akzʉzukaldatshak jiaga, ni ji agatsaldazhéga tu guashakú. ");
INSERT INTO kog_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ni sáñkalda Eldodeja jiaga agatsaldazhéga tuwák guana, mokue jai zʉñkuzgauwa guane tuashibiná. Akze, ni ji shalda shuigakue agatsé axeté guashi agatsaldazhé giemi ¿tuakí shi miná? ");
INSERT INTO kog_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ekí tuñgakna, maldé guiyaba tuñshal guak gualdikueniki, mokue yakbexal guak gualdikue nzha.  ");
INSERT INTO kog_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Guatshak juldiúkueki Jateja san kagixa zhinik kakzʉxaitshanéñ ldiuwañ zegauxa sáñkalda Alduma zaldaja mielde paldesu nuka kakibesakue akuaxaldiake, amak kakibesakue agatseka. ");
INSERT INTO kog_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Naldatshak saldiñga aldaldi jaldáñ ekí axaldexaldá: —¡Jejié Jesúki guaxa guwá. Baldabá niñkauwañki zʉñkibesá makunék! ");
INSERT INTO kog_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Guatshak Baldabáki akuíbulduk zaldakue na kauwijí sáñkaldakue aguabiyaldiamak kaukakshishatoguéñ, káguba guaxá atshane shalda kalseldi abexane na noxá. ");
INSERT INTO kog_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Naldatshak Pildatujañki Duwe Jesú niñkauwañki ibesa gundana akzeshi na, mokue ekíga kagakuañnék. ");
INSERT INTO kog_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ekí kagakuañnegatshak míñgaki, akldé akldeñga jaldáñ ekí axaldexaldá: —¡Jejiéki kaldixa axaldiya guaxá guwá! ¡Jejiéki kaldixa axaldiya guaxá guwá! ");
INSERT INTO kog_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Guñguake, mokue maikjuizhane Pildatuja ekí kakbeyá: —¿Sakígaba sha atshanéñ shi ekí guakueki minajañgú? Ni nasga jejié ji sha atshane shuigakue agatsé axetenaka tuakí naldashakú. Ekí tuñgakna, maldé guiyaba tuñshal guak gualdikueniki mokue yakbexal guak gualdikue nzha. ");
INSERT INTO kog_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ekí kakbeyatshak míñgaki, kagusana naldakí akldé akldeñga jaldáñ ekí axaldeshiñgaba: —¡Kaldixa axaldiya guaxá guwá! Ekí axaldeshiñgaba aldiweki aguabiyá. ");
INSERT INTO kog_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Guake Pildatuja agashishatoguamak kaxatshaldixa jañguá. ");
INSERT INTO kog_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Amak kaxatshiji, Baldabáki akuíbuldu zaldakuek kauwijí sáñkaldakue aguabiji kaukakshishatone, ezua káguba guaxá atshane shalda kalseldi abexane nalgué jiaga, kakibesá. Guatshake Duwe Jesú niñkauwañki agashishiñguamak kaldixa axaldiya akuaxaldiamak niuwi ge na gua. ");
INSERT INTO kog_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Guñgueni Duwe Jesú awaldeyatogueñki, ezua sigí Simóñ axezhuka, Sildene zalda, atezhi zhinik kuíbulduk nagaté noxé kakldabí. Guake iyapangueni eñkáñ kaldi Duwe axaldiya akuaxaldixa kamañ naldi Duwek agapa akuldeyexañ iyaxauwá. ");
INSERT INTO kog_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ekí aldeyatoguéñ, kágubakue matshuwi zhikzhe Duwek axapa aldé. Aikuega na, anuñka munzhikueki Duwe shalda izhajaniñgaba jaldáñ abauwiñgaba na axapa aldeyatoxá. ");
INSERT INTO kog_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Guakna Duweja kakizhbateshi ekí kakbeyá: —Maiñ munzhi Jeldusaldéñ zaldakue nashaldá za nazibauwagábaki, maiñ axaldáñ, mimijí sukuakue shalda mibauwaldí. ");
INSERT INTO kog_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Akze, jibañ mitualdiéñ zegatshakna, ekí akuaxaldixa: “Kaiga zʉnake munzhi somá kaxaldegazhákakueki zeñ shi aldaldí. Ekibeñga na, munzhi somá kaxaldegagáldekuegaki zeñ shi aldaldí.” ");
INSERT INTO kog_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Atshakna, guinuekuek, gaxakuek ekí axaldexaldixa: “Maldazʉnakuaxaldiamak zʉnetiná, kagi zʉneshá guwíñ.” ");
INSERT INTO kog_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jinake ekí zexaldixa naldakí. Akldé nas sha atshazhúge naugé jiaga, ekí guiyaba natuñshi, sha nakuashá. Ne sha atshixakue míñgaki ¡mitsá nazhakaldak guiyaba katuñshaldixa ne! —na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Guatshakna mozhua sigí shane, guiyabaja guagamak atshazhékue jiaga Duwe nañga kaldixa axaldiya kakuaxaldiamak kawaldé. ");
INSERT INTO kog_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Guñgueni “káguba tsáñkalda zaldáxalda” axezhogeñka kawaldé. Eñkaga na, ai mozhua guiyabaja guagamak atshazhékue Duwe nañga kaldixa kaxaldiyatshakna ezuañki Duwetshi jibatshaldi, ezuañki jibatshazháldi mual axaldiyá. ");
INSERT INTO kog_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Exa axaldikualdi na, Duweja Ajatek ekí akbeyá: —Najate, ekí sha nakuatuka sakí ajanashatukakue kakldegakí nak, kaxabetá makualdí. Eñka na, suldáukueja Duwetshi zhakuáki mieldekueja ipanaldixa ne atualdiamak ajanashiji aldiyá. ");
INSERT INTO kog_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Exaga na, kágubakueja sakí zegatuka atuaté aldoguéñ, juldiúkue aksanekakueja Duwe iyajokldeshi na ekí akuák: —¡Jejiéjañki kágubakue muldetua kagauneshi, ikuá guxa ne, aldéñki Jateja káguba ikualdal gaxaldixa guakldane izhgakuxanamak nake, axaldáñgaba jiaga ishkuá shi gui! ");
INSERT INTO kog_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Guñgueni suldáukueja jiaga Duwe aldesañ axaldagatshak, iyajokldeshi kuis kuis akzeldia agaxauwaldixa atuñshi na ekí axaldék: ");
INSERT INTO kog_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Mañki juldiútshi sáñkalda akldé mikzé maldahamak nake, mañgaba ishkuá guwá. ");
INSERT INTO kog_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Guatshak Duwe kaldixa axaldiyane asáñkaldake ekí guashi agazuñguane axaldiyá: “Jejiéki juldiútshi sáñkalda akldé akzé nakldá.” ");
INSERT INTO kog_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Exaga na, ezua shane Duwek akyó kaldixa axaldiyaneja ekí nusagatsaldi sha axaldék: —¡Mañki Jateja káguba ikualdal gaxaldixa guakldane, ai maldamak nake, nasʉñ ma nañga zʉnekuá guwá! ");
INSERT INTO kog_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ekí axaldegatshakna jiak, ezua shaneja ekí axaldék: —Nasʉñ jai maigua zhualduxañga shuigakue zʉñgatsé axazʉneyatene ne, ¿sakí shi mañki Saldiñga netshi Jate jiaga zhe mikzukuakí na? ");
INSERT INTO kog_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Akze, nasʉñki sha katshixa shaldaki guiyaba tuakue zʉñgatsamak zʉnakuaxaldixa. Ne jejié sigí zʉnake ni mitsák sha atshazhé ¿tuakí shi maldá? ");
INSERT INTO kog_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Guñguenik Duwek ekí akbeyá: —Duwe, mañki mitsák saldiñga saldiñga maksanegapanatshak guañ najañgui, be nezhgisekuá makualdí. ");
INSERT INTO kog_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ekí akbeñguake akiyó: —Namak ni mikbeñkú. Kaigaga mashuigatshaga nas na jékaldaxa, janshi zeñka mizhogapanaldixa nakldá —na akbeyá. ");
INSERT INTO kog_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Atshak Duwe Jesú kaldixa axaldikualguéñ, niuwi muanté zhinik niuwi uñguexá kagi agatsauxa muldetua tuañ na zexá. ");
INSERT INTO kog_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Akbiñgaki niuwi stuaksá guak. Atshaga na, juwí Jate axazakuageñkaga, ezua zhakuá atema akaldak akzeñka juldunéñ agekualdé, aldéñgaba muan zuwá itshizbé na gua. ");
INSERT INTO kog_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Guñgueni Duwe Jesú jaldáñ ekí kauldá: —Najate, nají aldunaki mañga miksuí noxaldiamak migé ni gukú. Ekí guagatshaga shuizhá na gua. ");
INSERT INTO kog_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ekí zegaté tuatshakna, ezua suldáutshi sáñkaldaja Jate akldé akzamakga akzukui ekí guak: —Namakga jejié sigíki muldetua jian za izhuka, agatsaldazhé nane naldé tiuwi. ");
INSERT INTO kog_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Guatshak Duwe kaldixa axaldiya akuagaté atualdiamak ajuizhaldekldekueja ekí zexauxa zegaté atuwi na, eñka zhinik aldeñkáki mitsá izhajaniñgaba akuxa awatuñshaldiamak tabáxaldak abushi na aldeyá. ");
INSERT INTO kog_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Atshaga na, Duwe jañguxakueki, munzhikue Galdildeya zhinik agapa aldakldekue juizhi, exaga agajué zeñka Duwe akuatoxauxa atuaté na aldoxá. ");
INSERT INTO kog_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Exaga na, ezua sigí Jusé Juldeyaxa kuíbuldu Aldimateyaxa zalda na izhoxá. Eñki janshizhe jian za izhuka, Saldiñga netshi Jateja saldiñga aksanexaldiéñ ldiuwañ zexaldixa jiaktuwi za izhuka. Aldéñki asaná juldiú sanekakuegaba akldé akzekue na izhogatshak jiaga, ekuejañki Duwe shuigakue agatsé axeyaldagatshak, ekí jañguazháldi, akldunazhá guane. ");
INSERT INTO kog_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ekí nalguakna, Duwetshi abuá mexaldiamak sáñkalda Pildatuk niuwi akshishal ne. ");
INSERT INTO kog_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Guñguake amak niuwi ageguake, Duwetshi abuá kaldixa zhinik axawatiñgueniki zhakuá tiñne janshagatsek mañguá. Gueniki jagiga shuanekue abexaldiamak axakuiyaneñka ni me abegazhéñkaga mexá. ");
INSERT INTO kog_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Atshake kauwisanákue zhigasekué ldiuwañ zexaldá guapanakna ai niuwañki jibatshasʉ́ñzeñ niuwañ naldakna, tuañ zegagáñga saldiñga janaktuakue niuwañ na zaldá. ");
INSERT INTO kog_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Amak Juséja Duwetshi abuá mexal neyatshak, munzhikue Duwek agapa Galdildeya zhinik aldakldekue jiaga axapa aldé. Exaki Duwetshi abuá abexaneñka, sakí agatsaldi abegaté atú. ");
INSERT INTO kog_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ekí atuñgueni mokue ashekualgueñka aldeyatshak, kauwisanákueki ajanashamakga Duwetshi abuák iyabexaldixa we juma izhukakue saldi janagatú. Akuñguenik guiyabaja guagamak zhigasekué ldiuwañki jiba atshasʉ́ñze guagamakga na ajanashá. ");
INSERT INTO kog_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Guñguenik abokualdi, dumiñkuke zhe meñga, ai munzhikueja we juma izhuka Duwetshi abuák iyabexaldixa janagatune awaldeji ají abuá abexaneñka saldi aldé. ");
INSERT INTO kog_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Amak aldeyatshake, juldunéñ jagi saldáñ pakue atema agayone nalgué, axajuekuá guane na atuwá. ");
INSERT INTO kog_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Gueni eni ajuldunatshak, Duwe Jesú nauwijí Sáñkaldatshi abuáki atuazhá. ");
INSERT INTO kog_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Atuakí nalguake “¿sakí nexé?” ajañguatogueñki, tua kakzegagáñga mozhua sigíkue zhakuá muñshí zaldaba ijuakuekue kauwistakga kakizhañká. ");
INSERT INTO kog_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ekí atuatshak tiñ tiñ kakzeshi jie ajanashatshak sigíkueja ekí kakbeyá: —¿Jinak shi ezua be nogatuka shuane abegaldi niyabinók? ");
INSERT INTO kog_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Duweki shuiguenik mokue izhgaté guane nakna jai isʉ́ñ nakldá. Be izhgisekuá guwíñ, Galdildeyaxa maiñ na izhogueñga ekí miñmenane: ");
INSERT INTO kog_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Naski Jatetshi Asukuága ixagabaldeklduge ekí nagatsexaldixa. Nezhakuashi sha atshixakuek naxexaldinik, kaldixa naxaldiya nakuaxaldixa. Guanaldini jiak, shuixaldikuenik maiguake mokue izhgaté gualdikue niyó.” ");
INSERT INTO kog_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ekí kakbeyatshakna, Duweja kakbeyanalguamak be kagisék. ");
INSERT INTO kog_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Guñguake exa abexaneñka zhinik mokue aldeñguenik, Duweja 11 shaxaldiyatonekuek, axautshikue juizhi zegaté atunauxa nuk agabeyá. ");
INSERT INTO kog_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ekí guakldekueki, ezuañki Maldiya Makldalda zalda, ezuañki Juana, ezuañki Maldiya, Santiakutshi ajaba, axautshi munzhi kagapa nenekue juizhi ekí akuaklde. ");
INSERT INTO kog_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ekí kagabeyatshak “sakí mi amak zegakldék” ajañgui na, namak axajanazhá. ");
INSERT INTO kog_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Guatshak jiaga, Péguldu zʉnake naldajiñga abuá abexaneñka neñguenik eni akzʉtuatshak, zhakuá tiñne Duwetshi abuá abañguanane za na duwá tu. Ekí tuñguake mokue exa zhinik neñkáki, “¿sakí ekí zeklde ne?” akldeshi na neyá. ");
INSERT INTO kog_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Atshak ldiuwañga, ai Duwe agapa neñkakuega mozhua ezua kuíbuldu Emahúxa aldeñká aldé. Ai kuíbulduki Jeldusaldéñ zhinik nauwa maldé neyashi me na zaldá. ");
INSERT INTO kog_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Exa aldeyatoshi na, atshake sakí Duwe akuanauxa shalda izhgabeji aldé. ");
INSERT INTO kog_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ekí dulda ishkuashiji aldeyatogueñga na, Duwe Jesú naldiñga kakldabiguenik kagapa neyaldá. ");
INSERT INTO kog_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Atshaga atuwiñki atú guatshak, “Duwega nzha” atuazháldiamak kagitamakuá. ");
INSERT INTO kog_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Guñgueni Duweja kaklduká: —¿Jiúñguldak neyabinogatshak ji shalda shi ekí dulda izhgushabinók? Ekí kakldukatshakna izhajaniñgaba guatukakue aldeyaksá. ");
INSERT INTO kog_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Akuñguenik ezua Kaldepa axezhukajañki ekí axaldék: —Saldiñga Jeldusaldéñ izhonekuejañki sakí zeklde kakuegaba ne, ¿sakí shi ma za zeklde miksʉ́ñ na? ");
INSERT INTO kog_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Guake kaklduká: —Guatshake ¿sakí zeklde sha? Guñguake akiyayó: —Duwe Jesú Nasaldé zalda sakí agatseklde. Aldéñki Jatetshi múldigaba naldiñga zʉxaitshixa naldi na, Jateja tuwéñ, kágubakueja tuwéñ jiaga niuwi axaldega shizhixa, atemajañ janshizhe ajanashaté atú guazhámak atshixa atune. ");
INSERT INTO kog_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ekí izhogué jiaga, Jatek múldigaba agaskaitshixakuetshi sáñkaldakueja, nauwisaná aksanekakueja Aldumaxa zalda sáñkaldak akizhakuashi agaxé. Ekíki shuigakue agatsé axezhaxaldiamak. Amak axezhashi na, kaldixa axaldiyá akuaxane. ");
INSERT INTO kog_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Naldatshak nasʉñki “eja sha nasʉñ Isayélkuañ kaguldiñkakue zhinik zʉnebesanshaldixa shakldá” jañgui, jiaktuatoñkalde. Ne ekí akuaxeni au maikldiuwi zegaté nakldók. ");
INSERT INTO kog_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Ekí akuane naldé, kañ zhe muñzegapanatshake, anuñka munzhikue nasʉñ nañga agatsekueja Duwetshi abuá tual abexaneñka aldeyatshake atuazhá. Guake exa zhinik aldaxeni, ekí zʉñgabeyá: “Jateja guaklde uldeñkakueja ‘Duwe Jesúki beñga nakldók’ zʉñmeyaté ni katuwá.” Ekí zʉñgabeyatshakna: “¡Sakí amak zeklde ne!” jeñ zʉñgaldekshá guane. ");
INSERT INTO kog_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ekí zʉñgabeyakna jiak, ezuakue nasʉñ nañga agatsekue Duwetshi abuá abexaneñka atuál aldeyatshak, munzhikueja zʉñmenamakbeñga abuá atuazhá. ");
INSERT INTO kog_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Guake Duweja ekí kakbeyá: —¿Jinak muldetua jañguazháminaka ne? ¿Jinak shi Jatetshi múldigaba naldiñga zʉxaitshixakuejañki sakí zexaldiauxa kaltak zʉñmeyanane namak jañguexañ jibañ miñzukú? ");
INSERT INTO kog_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Akze, Saldiñga netshi Jateja káguba kekualdal gaxaldixa guakldane, eñki ekí agatsaldi guiyaba tuakue agatsexaldixa janaktunamak agatseklde. Jateja eñki jékaldaxa akldé akzamakga akzukuane izhokshagáñgaki ekí zegakue naldaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ekí kakbeñgueniki Jatetshi múldigabaja aldéñ shaldaga guagauxa sezheklde muldetua kagajienaldiamak agatsaldi kakbeyaldá. Kasak misha nauwibama Mueséja e shaldaga kalta gauwanane kakbeyapanguenik kakbejiñga, saldiñga Jatetshi múldigaba naldiñga zʉxaitshixakueja jiaga e shaldaga kalta gauwanauxa yo na kakbeji neyatoxá. ");
INSERT INTO kog_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ekí nejiñga na, kuíbuldu iyaldañkaldieñka naki aldeyapanake, Duweki egaba jian zʉxaitaldixa jana neyapanguakna ");
INSERT INTO kog_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","anuñka juizha axakuañnék: —Au tuañ zexaldá guapankaki jai zʉnexabashi maldeyaldí. Guñguake amak kauwizhéñ na abaldiamak kagapa ne. ");
INSERT INTO kog_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Guñguenik kauwizhéñ na zaldiamak yaldagueniki aldéñ gakue shalda Jatek “zeñ nzhakldék” akbeñgueniki, pañ zhikwati kagexaldá. ");
INSERT INTO kog_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Atshaga na, aiki uba kakldeji guxá jana kakzegatshake, “Duwe Jesúga naldashá” kakldék. Ekí kakldegatshaga na, ubañga atuazhá na akuá. ");
INSERT INTO kog_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Guñguakna ataba atabañ zhinik ekí izhgabeyaldá: —Kañ jiúñguldak aldéñ dulda zʉñshiji, Jatetshi múldigaba muldetua zʉñgajienaldiamak zʉñmeji nagatoxéñ, ¿aldunaxa muldetua janshí zʉñzukuazhá guazhá shi gua? ");
INSERT INTO kog_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Guake ubañga mokue kuíbuldu Jeldusaldéñka saldi aldé. Eñka aldeyatshake Duweja 11 shaxaldiyatonekue, axautshi ek axapa neñkakue juizhi ajuizhaldeklde ashé atú. ");
INSERT INTO kog_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Guatshak exa juizhaldekldekueja ai mozhua nekuek ekí kagabeyaldá: “¡Namakga nzha! ¡Nauwijí Sáñkalda, Duwe Jesúki shuixeni mokue izhgaté guane nakldók! Aldéñ naldiñga na Simóñ Pégulduk akizhañka guane nzha.” ");
INSERT INTO kog_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ekí kagabeñguake ai mozhua nekueja jiaga sakí Duwe kauwizhéñ nañga jiúñguldak neyatone ajanashatonauxa, guñgueniki sakí aldéñ gakue kagegatshaga “ega nakbatú” kakldeklde shalda na akuaxá. ");
INSERT INTO kog_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ekí akuaxal aldogueñga, Duwe Jesú naldiñga kauwikenáñ kakizhañkaji ekí kakbeyá: —¡Aldunaxa señgabá shi miñzeshí! ");
INSERT INTO kog_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ekí kaxazguashi, kakizhañkatshakna “alduna nuxa zʉñkizhañkaxá” ajañgui, matshuwi zhe kakzék. ");
INSERT INTO kog_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Guakna Duweja ekí kakbeyá: —¿Jinak shi ekí zhe miñzék? Minatuatshak ¿jinak mokue izhgatenuge namak najañguazháldi, mozhua mozhuañga shi miñnegatók? ");
INSERT INTO kog_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Akna, nas naldiñga naugé namak minatualdiamake, káuxaldak, kasak natú, najugua guwíñ. Jinake ekí miñmeyakí. Ezua alduna zañki gata axaldaldazhé, ne naski gata naldiñga naugé minatualdiamak. ");
INSERT INTO kog_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ekí kakbeñgueniki káuxalda, kasa katuñshá. ");
INSERT INTO kog_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Guatshakna kauwizhéñki Duwe beñga atuatshak, zʉ́xaita zeñ kakldekága nuxa, “¡eñki sakí ekí zeklde ne!” ajañgui na, auxaga “aldéñ naldiñga nzha” kakldegakíñga aldoxakna Duweja kaklduká: —¿Gakue ganaka miñkaldá shi na? ");
INSERT INTO kog_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Guñguake pikáu puldane agaxeguake, ");
INSERT INTO kog_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ipanguenik atuaté nogueñga nuk ga. ");
INSERT INTO kog_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Guñgueniki ekí kakbeyá: —Naski maiñ na izhogukueñga, Najatetshi múldigabaja nas shalda sakí nagatsexaldixa guagauxa zegakue naldaldixa miñmenuge. Nas shalda kalta sezhekldanauxaki nauwibama Mueséja, nauwibama Dabíja, Najatetshi múldigaba naldiñga zʉxaitshixakueja ekíga nagatsexaldixa kalta axauwanane. ");
INSERT INTO kog_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ekí kakbejiñga na, Jatetshi múldigabak aldéñ shalda muldetua kagajienaldiamak aldunaxa uba kakldeñshá. ");
INSERT INTO kog_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Gueni ekí kakbeyá: —Jatetshi múldigabak ekí sezheklde: Jateja nas Asukuák káguba kekualdal nakaxanaldixake kauwitsaldí guiyaba tuwi shuigakue nagatsaldaldixa. Amak shuixaldikuenik jiak, maiguake mokue izhgaldaxaldikue. ");
INSERT INTO kog_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ekí guagatoshiñga na, nagapa mineñkakueki natsaldí saldiñga káguba saná na nahauxa ekí miyakbeyaldixa: “Maiñ sha miyatshixa majiñga maja, Jatek agakualdi miñgualdiake, aldéñga sha miyatshixakue nuk miñkabetaldixa nzha.” Ekí kakbejiñga na, kasake kuíbuldu Jeldusaldéñka misha miñguagapanaldinik san, san kuíbuldu nahauxa ekíga miñguaxaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","”Akze, maiñki sakí nagatsegaté natuminauxa káguba zhekuauxa nekuek kakbeyakue miñgatsaldaldixa. ");
INSERT INTO kog_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Akze, Najateja ají Alduna naldiñga miñgakaxaldixa miñmenamak, naki miñgakashi na guapankú. Amak ai Alduna auxaga miñkaldaldaldiamak mipanatshaga, kama jékaldaxa zalda jiaga mipanaldixa. Amak ipanakíñga minoxaldieñki jai Jeldusaldéñka zhinik ne naldakí, jiaktuateñga minoxaldí —na Duweja kakbeyá. ");
INSERT INTO kog_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ekí kakbeñgueni Duwe Jesúja kuíbulduk zhinik kakzʉxaitshiñgueniki, kuíbuldu Betaniaxa akyó kauldeñgueni Ajateja zeñ kajañguakue akshishaldiamak káuxalda izhgaldakshá. ");
INSERT INTO kog_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ekí akshishatogueñga na, kagajuezhá, jékaldeldi awalditshí. ");
INSERT INTO kog_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ekí atuñguakna e za akldé akzamakga agazukuá. Guñguenik mokue Jeldusaldéñ aldeñkáki atemajañ zeñ kakldeshiñgaba saldi aldé. ");
INSERT INTO kog_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Exaki juwí Jate axazakuageñka niuwi neyauxa Jatek “zeñ nzhakldék” agabeji, akldé akzamakga agazukual za na ashekualdá. Ekíga shi naldí.");
INSERT INTO kog_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Duwe Jesúki Saldiñga netshi Jatetshi Asukuága, Jatetshi Múldigaba naldiñga ne nahamakga eja guaká zʉñwashekuxa. Nahamakga na, aldéñki kasakga ni ji jiaga naldagá nogueñga jiaga iteñga none. Aldéñga Jate nahamakga Ajate nañga izhoshiñga izhogatone. ");
INSERT INTO kog_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kasakgaki ni ji jiaga naldagá nogueñga jiaga Jate nañga izhoshiñga izhogatshak, ");
INSERT INTO kog_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jateja ek ga saldiñga jika na nahauxa gauwá guane. Ai zhinik na ni ji jiaga eñkáñ zhinik naldapanazhá guane naldakí nakldá. ");
INSERT INTO kog_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Aldéñga na izhoxa aksuikue, muñshí zalda naldi na kágubak aldunaxa muñshí zʉnezguxa. Aldéñga abisajañ zʉnezhokshatshakna muñshí zʉnzukuxa. ");
INSERT INTO kog_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Akze, ai muñshí zaldaki tuañ zaldi muñshí zukui na, tuañ zaldajañga ni mitsák jieldiksha guazhé. ");
INSERT INTO kog_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Jatejañga ezua sigí Juañ axezhuka gagatshak, ");
INSERT INTO kog_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","muñshí zalda shalda namaklde zʉñmeyaldiamak naklde. Ekíki ek zhinik saldiñga kágubaja muñshí zalda namak jañgui iyapanaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Naldatshak Juañki muñshí zʉnzukualdixaki naldazhé. Aldéñki e shalda namaklde zʉñmeyal za naklde. ");
INSERT INTO kog_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Akze, muñshí zalda namaklde nahamakga saldiñga kágubak muñshí zʉnzukuxaki jai kagik katshekuekuek tuakualdiamake naki zʉñkizhañkaji me na guatoxá. ");
INSERT INTO kog_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Naldiñki ek ga Jateja saldiñga gaune nalgué jiaga, káguba kenañ izhogatogatshak, “mega mizék” nuxa axajanane. ");
INSERT INTO kog_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aldéñga juldiúkue ají naldaldiamak kezhgakuxananekue kenañ kaxaldagatshak, ni aikueja jiaga iyapanazhá. ");
INSERT INTO kog_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Guane ne, mieldekuañki “Aldéñki Jatejañga zʉnekualdal gaxanamak shakldá” alduna ishiji ipaná guañkaldek zʉnake Jatetshi sukuakue giemi nek guashi niuwi zʉñgé guane. ");
INSERT INTO kog_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Amak Jatetshi sukuakue giemi negakualdiamake, nauwijatekuek zhinik, ni askuildek atshakuéñ zhinik, ni ezua sigíja sukua axaldaldana akzegéñ zhinik nuxa etshi negazhánazʉnaka. Ezuañgaba Jatega aldunaldi abisajañ zʉnakuksha guanéñ zhinik za na ají sukuakue giemi zʉnaldekshixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Akze, Jatetshi Múldigabaga na káguba naldi ixagabaldegueni nauwikenáñ izhogapanane. Amak zʉñkizhogatoguéñ, aldéñki auxaga namaklde nahamakga ne zʉñwashekui, zʉxaita atemajañ éegaba guañ zʉnajañguxa ne zʉnatuñshatone. Ekí zʉnatuñshatogatshakna, aldéñki Jatetshi Asukuá ezuamé nega Ajate akaldak akzamakga akzé tuatoñkalde nakldá. ");
INSERT INTO kog_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Guatshak e shaldaga namaklde guagatuka na, Juañja Duwe tuatshak muldetua nukakualdiamak agatsaldi ekí guaklde: “E shalda na ekí guagukú: ‘Ezua sigí zʉnekualdaldiamak nalduxañ nagatukaki kukagá nogukueñga izhoshiñga izhuka nahák, nazhakaldak akzé nakldá.’” ");
INSERT INTO kog_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ega na auxaga nahamakga, zʉxaita éegaba guañ zʉnajañguxa. Akna saldiñga e ipanañkaldekuañki amak guañ zaldaba zʉñkatshixaki ipanal za noxañkalduka. ");
INSERT INTO kog_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Guatshak guiyaba jian izhoxaki nauwibama Muesék zhinik ipanañkaldane. Ekí ne, Duwe Jesú Zʉnekualkaja zʉnake namaklde zʉñwashekui na, atemajañ éegaba guañ zʉnajañguxa zʉñwashekuá guane. ");
INSERT INTO kog_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Akze, Saldiñga netshi Jatega ni meja, ni mitsák ubak naldi atuazhé. Naldatshak Asukuá ezuamé nega Duwe Jesúki Jatega, Ajate na muldetua ishkaldaldi izhukaja za na Jate “me ne” muldetua zʉnatuñshatone nakldá. ");
INSERT INTO kog_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Akze, Juañja káguba nik kajaukshatoguéñ, juldiú sanekakuejañki Jeldusaldéñka zhinik Jatek múldigaba agaskaitshixakue, ekuek agauneka Aldebí ldaxekue juizhi aldéñ muldetua “me ne” naldaka agazaldukaldiamak axaxaxá. Amak agazaldukatshak, aldéñ ekí namaklde guashi na, ");
INSERT INTO kog_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","naldagálde guak náaldaki muldetua kagajienakldegamak ekí guak: —Jateja ezua zʉnekualdal gaxaldixa guakldane, naski ai naldazhúge nakldá. ");
INSERT INTO kog_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Guake mokue agalduká: —Guake, ¿me naldamildaka ne? ¿Jatetshi múldigaba naldiñga zʉxaitshixa nane Eldiyaga shi maldá? Guake ekí kakiyó: —Naski ni e jiaga naldazhúge nzha. Guake: —Ake, ¿Jatetshi múldigaba naldiñga zʉxaitshixa ezua jiaktuañkaldukaga shi maldá? Guake: —Miya. Ai jiaga naldazhúgega nzha. ");
INSERT INTO kog_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Guñguák zʉnake ekí agalduká: —Ake, ak zʉnake, ¿me namildaka maldúk? Guake, mikzʉzukal zʉnakaxanekuek kakbeyakualdiamake muldetua zʉñmeyakue migatsaldashá. Akna ¿me namildaka shi akuakbildaka na? ");
INSERT INTO kog_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Guake Jatetshi múldigaba naldiñga zʉxaitshixa Isaiyaja guakldanamak guashi kakiyó: —Nasga na zʉk zeñka izhoshi, naldukal naxaldakakue ekí jaldáñ kaxaldekuge: “Saldiñga netshi Sáñkaldaki naki miñkaldashi guapanakna, jian naxaldiamak jiúñgulda siyaxagauwakuamakbe aldunaxa jana akizhiktuwíñ” kaxaldekuge na nakú. ");
INSERT INTO kog_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Guatshake axaxaxanekueki paldiseyukuejañga gaxanekue. ");
INSERT INTO kog_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Naldekueja ekí agazalduká: —Guake, mañki ni Jateja ezua zʉnekualdal gaxaldixa guakldane, ni Eldiya, ni Jatetshi múldigaba naldiñga zʉxaitshixa ezua jiaktuañkalduka jiaga naldabálde naldatshake, ¿jinak shi kágubakue nik kajaukshabaldók? ");
INSERT INTO kog_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Guake ekí kakiyó: —Naski kágubakue nik nuxa kajaukshikuge. Naldatshak ezua mimikenañga izhogaté nogatshak jiaga “me ne” miñsʉ́ñga nogashá. ");
INSERT INTO kog_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","E guana zʉnekualdaldiamak nalduxañ nagatuka, nazhakaldak akzé nak naski ni atabal nuxaki nakzaldagálde nakldá —na kakbeyá. ");
INSERT INTO kog_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Guatshak Juañki nina Juldáñ ataba niñkauwañ Betania axezhogeñka kágubakue nik kajaukshatogueñka na ekí agazaldukatoxá. ");
INSERT INTO kog_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Guñguenik abokualdíki Juañja Duwe Jesú axaldagaté tuñguake ekí guak: “¡Tu guwíñ! Uñkuahí nagatukaki Jateja jubeju zhauwa jana nauwitsaldí shuixaldixa janazʉñgaktunega nagaté tiuwi. Eñki nauwitsaldí shuigatshakna káguba kagik katshekuauxa sha atshá zʉnguxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","E shaldaga na ekí guagukú: ‘Ezua sigí zʉnekualdaldiamak nalduxañ nagatukaki kukagá nogukueñga izhoshiñga izhuka nahák, nazhakaldak akzé nakldá.’ ");
INSERT INTO kog_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","”Akze, nas jiaga ubáñ meñki ‘e sha Jateja zʉnekualdal gaxaldixa guakldane na’ nakldegazháne. Ne jiaga, naski ají kuíbuldu Isayélkuañ ‘aiga nzha’ miñwashexaldiamak nik mimajaukshal naklduge.” ");
INSERT INTO kog_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Guñgueni aldéñ tunamak ekí zʉñmeyá: “Nas naldi Jatetshi Aldunaki aldéñ na izhoxaldiamak alnobaxa zhinik shamíjañ ek axagatanaté tunuge. ");
INSERT INTO kog_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Guatshak ubáñ meñki nas jiaga ‘ega nzha’ nakldegazhá guane. Naldatshak nik mimajaukshal nakaxanejañga zʉnekualdaldiamak nagatuka shalda ekí nakbenane: ‘Mielde nají Alduna aldéñ na izhoxaldiamak axagatanaté matualdiake, e na nají Aldunakga mimajaukshixa matualdixa niyó. Ekí mimajaukshi na, nají Alduna maiñldi auxaga miñkaldaldaldiamak miñgexaldixa.’ Ekí nakbene nalgué, ");
INSERT INTO kog_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","amak zegaté tunugéñ zhinik na tunugamak guashiñga, ‘eñki Saldiñga netshi Jatetshi Asukuá giemiga nakldá’ na miñmeyatokú.” ");
INSERT INTO kog_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Juañ nik majaukshakueja ekí guagatoguenik jiak abokualdike exaga mozhua aldéñ shi kagitixakuañ na izhoguéñ, ");
INSERT INTO kog_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Duwe Jesú zʉxaitaté tuatshakna ekí zʉñmeyá: —¡Tu guwíñ! Uñkuahí zʉxaitapankáki Jateja jubeju zhauwa jana nauwitsaldí shuixaldixa janazʉñgaktunega na zʉxaitapán. ");
INSERT INTO kog_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ekí kaldukañguake nasʉñ mozhua kaldekuañki ubañga Duwe Jesúk agapa neyaldá. ");
INSERT INTO kog_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kakuñguake Duwe zʉñkizhikbateguenik agapa neyaté zʉnatuñguake, ekí zʉñnuká: —Naldé, ¿ji miñgajuezhé? Zʉñnukañguake: —Aldabí, ¿mashi mizhuka sha? Guatshak “Aldabí” kaxaldegatshak, “Shi maldazʉñkaldixá” guashi. ");
INSERT INTO kog_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kakldukajake ekí zʉñkaldék: —Ake, tuatak guwíñ. Zʉñmeñguake amak tual agapa kaldeñguenik, niuwimaldá zhinik e na izhoshi, exaga tuañ zʉnzék. ");
INSERT INTO kog_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Guatshak amak Juañja Duwe shalda zʉñmeñguake agapa neyapánañkaldekuañki, ezuañki Andaldé. Eñki Simóñ Péguldutshi aldani ");
INSERT INTO kog_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","naldakna, ubáñ niyal neñguenik akzaldatshak ekí akbeyá: —¡Mesiya tu ni gakú! Guatshak “Mesiya” guagatshake, “Jateja ezua zʉnekualdal gaxaldixa guakldane” guashi. ");
INSERT INTO kog_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ekí akbeñgueniki Duwe Jesúk akuldák. Guake Duweja tuaté noshi ekí axaldék: —Mañki Simóñ, Juañ tsukua maldé. Naldatshak Sepa axamizhoxaldixa nzha. Guatshak Sepaki galdieguke Péguldu. ");
INSERT INTO kog_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Guatoguenik jiak abokualdike Duwe Jesú Galdildeya baxe neyaldixa akldeguenik Pildipi akzalguake ekí akbeyá: —Shi maldagitiyaldixa nak nagapa kuizaldi. ");
INSERT INTO kog_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Guatshak Pildipiki kuíbuldu Betsaildaxa zalda. Exaga na Andaldé, Péguldutshi jiaga na naldá. ");
INSERT INTO kog_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Naldé na, Pildipijañki Natanahél akzalguake ekí akbeyá: —¡Jateja ezua zʉnekualdal gaxaldixa guakldane tu ni gakú! E shaldaga na nauwibama Mueséja guiyaba xaltek gauwane, Jatetshi múldigaba naldiñga zʉxaitshixakueja jiaga kaltak axauwanega. Ega na Jesú, Jusétshi asukuá, Nasaldé zalda nzhaldá. ");
INSERT INTO kog_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Akbeñguake Natanahélja: —¿Ne, Nasaldéxa zhinik jiaga ezua zauwaka akzʉxaitañga mi guakldék? Guñguake Pildipija: —Egaba tuatak guwá. ");
INSERT INTO kog_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Akbeñguake Natanahél nagaté Duwe Jesúja tuatshak ekí zʉñmeyá: —¡Tu guwíñ! Uñkuahí naká na nauwisaná Isayél ldaxe naldi guxa naldakuamak ne. E na naldagálde zukuak atshagálde, jian ne tiuwi. ");
INSERT INTO kog_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ekí zʉñmeyaté nukatshakna Natanahélja ekí aklduká: —Duwe, ¿mashi maldatuñka nak shi me naugé mikualkú? Akldukañguake: —Akze, Pildipi maldiyagá noxeñga, kaldi zhenká stak ité matú guashalgukú. ");
INSERT INTO kog_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Guake ekí akbeyá: —Shi maldazʉñkaldixa, mañki Saldiñga netshi Jatetshi Asukuá matiuwi. Mañki nauwisaná Isayéltshi Sáñkalda akaldak akzé matiuwi. ");
INSERT INTO kog_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Guñguake Duweja ekí akiyó: —¿Kaldi zhenká staxa ité matunuge mikbeñkugák nuxa shi namaklde naugé maldajañgú? Akze, akldeñga atemajañ jiaga atshaté maldatualdixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Guñgueniki ekí zʉñmeyá: —Namakgaba miñmeyaldikue: Alnoba akpezhane te mituatshak Jateja guaklde uldeñkakue nas Asukuága ixagabaldekldugek zhinik nitshixal, zabal mitualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Galdildeyaxa kaldeñgueni maiguake kuíbuldu Kanáxa ezua numa nexaldixa na zexá. Atshake Duwetshi ajaba jiaga exa na izhoxá. ");
INSERT INTO kog_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Guatshak Duwe Jesú, aldéñ shi kagitixakuañ jiaga eñka zatiakue zʉñgabene nalguake jeñ ne. ");
INSERT INTO kog_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ekí zhekualdiñga kalwéldia siyagaxaune atuxaldixa janagatune nalgué nauxa saldinatshak, Duwe ajabaja ekí akbeyá: —Kalwéldia siyagaxaune kaksaldí na gu. ");
INSERT INTO kog_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Akbeyatshakna: —Jaba, ai zegatukaga tuakue zʉñgatsaldakí. Kaigabeñki muelzekuakue niuwañ naxakldañkagá nakldók. ");
INSERT INTO kog_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Akbeyatshak jiaga ajabaja exa jibatshixakuek ekí kakbeyá: —Ji eja atshakue miñmeyaldiake, amak miyaxatshaldí. ");
INSERT INTO kog_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Guatshak exaki tezhuwa jákboksukue teté. Aikueki atemakue, anuñka naldi ajauxá guashi ni asuñguxakue. Ai niki nauwisanátshi guiyabaja janshi mishkazgualdiamak jiba akbeyakue guagamak jiba agabeñka. ");
INSERT INTO kog_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nalgué na, Duweja exa jibatshixakuek ekí kakbeyá: —Ni tashígaba jákboksukuek muldetua suñguaminegaba guwíñ. Guñguake amak jialda jialda asuñguá. ");
INSERT INTO kog_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Guake Duweja ekí kakbeyá: —Kaigaki nauwa akbe xaldeki numa negatuka jika janagaktuatukaja guajaldiamak akulde guwíñ. Guake exa jibatshixakueja amak akualdeyatshak, ");
INSERT INTO kog_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","kauwizhéñki ni tashí nuxa akuxane kakué. Guatshak jika janaktuatukaja zʉnake ni tashík akuxane aksʉ́ñ. Nalgué guaji, nauwa tugatshake, kalwéldiaga neklde muldetua we akzé tu. Guakna numa negatuka ixaulgueni ");
INSERT INTO kog_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ekí akbeyá: —Saldiñga nekuejañki axáñ misha kalwéldia siyagaxaune akzeklde akldé we akzé misha axaldakldekuek agaxauñka. Gualdinik agubisha atugapanatshake, egaba aguáñ we akzé niñkauwañki agaxauñka. Ne mañki kalwéldia siyagaxaune akldé we akzé ¡kaiga mishkauwaldixa mexamalde noxé tubaldá! ");
INSERT INTO kog_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Guatshak Duwe Jesú “me ne” awatuñshaldiamak janshizhe ajanashaté atú guazhámak kasaklde atshaneki Galdildeya baxe kuíbuldu Kanáxa na ekí atshá. Ekí akldé akzé awatuñshatshakna, aldéñ shi kagitixakuañki namak jañgui alduna ishiji izhogapanañkalde. ");
INSERT INTO kog_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ekí atshatogueniki Duwe Jesú ajaba, aldanikue, shi kagitixakuañ juizhi kuíbuldu Kapeldahúmka zabí. Guñgueni exa anuñka nuxa izhogueñki ");
INSERT INTO kog_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jeldusaldéñka kajuizhaldegéñ ldiuwañ zexaldá guapanguakna Duwe jeñ zʉnaulditshí. Ai ldiuwañki nauwibama juldiúkue san kagixa guiyaba atuwi ashekualgueñka zhinik Jateja kakzʉxaitshanéñ ldiuwañ be izhgisekui kajuizhaldegéñ na zaldá. ");
INSERT INTO kog_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Guñgueni juwí Jate axazakuageñka kaldeyatshake, atsha guasʉ́ñzamak káguba ajanashatukakue Duweja zhe tu. Bue, jubeju, shamí Jatek agaxexaldixa nabeyasatukakue. Ekíga paldata eni zaldak yushatukakueki iteté katú. ");
INSERT INTO kog_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Guakna nubuldí guguenik kauwijí numakue bue, jubeju juizhiñga juwí Jate axazakuageñka zhinik kakzʉxaitshá. Ekíga na paldata yushixakue, kauwijí misa kakizhikbeshi paldata nuk kagildiñgaba kagaktiñgui kakzʉxaitshá. ");
INSERT INTO kog_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ekibeñga shamí nabesaxakue jiaga kakzʉxaitshiji ekí kaxaldék: —¡Jejiékue nuk akbexa guaté minokldék! ¡Ekí miyatshatshake Najatetshi juwí jika nabeyasaxa jube nuxa miñguxáki miñnegakí shi na! ");
INSERT INTO kog_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Duwe ekí atshatshakna shi kagitixakuañki Jatetshi múldigaba ekí sezheklde be zʉñgisék: “Mijí juwí agazaldakuatuka shaldaki nakzekága nuxa mauldí nakzexaldixa nzha.” ");
INSERT INTO kog_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Guatshak juldiú sanekakueja zʉnake ekí axaldék: —¿Sakí ajanashaté tu guañkáaldamak maldazʉñkatshatshak shi “eñki Jatejañga ekí atshá guashi niuwi agene nakbatú” jañguakualdixa na? ");
INSERT INTO kog_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Guake Duweja: —Ake, jejié juwí Jate axazakuaká aldéñ izhuka ne naldaksánsha miñgualdiake, jiak maiguake mokue aiga naldapanshaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Guake: —¡Sakí mi amak atshamikldék! Jejié juwí Jate axazakuaká aldéñ izhukaki axauwalda gueni 46 kagi jekí agatsexaldixa axauwatogashá. Ne ¿sakí mi mañki maiguak me mokue aiga naldapanshamildaka makuák? ");
INSERT INTO kog_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Guatshak Duweja juwí Jate izhogeñka shalda guagatshake, eñki ají abuá shalda na ekí guaklde. ");
INSERT INTO kog_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nalgué, nasʉñ shi kagitixakuañ Duwe shuigueni mokue izhgaldagatshakna, aldéñga sakí guakldane be zʉñgisék. Guatshakna namak jañguáñkalde: “E zʉnake aldéñ guakldamakga, Jatetshi múldigaba sezhekldeja jiaga guagamakga ni zek.” ");
INSERT INTO kog_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Duwe ekí atshatogueni exa Jeldusaldéñkaga Jateja nauwibamakue san kagixa guiyaba atuwi ashekualgueñka zhinik kakzʉxaitshanéñ ldiuwañ be izhgisekui kajuizhaldegéñ zʉxaitshalga kaldogueñga na, aldéñki “me ne” awatuñshaldiamak anuñka juizha ajanashaté atú guazhámak janshizhe atshiji izhó. Guatshakna matshuwi nekueja ekí atshaté atuñguakna, “e zʉnake Jateja ezua zʉnekualdal gaxaldixa guakldane nahamakga nzha” ajañgui na, alduna iyashapaná. ");
INSERT INTO kog_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Guatshak aldéñki saldiñga káguba sakí ne akué nalguakna alduna keshazhá. ");
INSERT INTO kog_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ni meja káguba sakí ne akbeyakue agajuezhazhá. Akbiñgaki saldiñga káguba aldunaxa tuñkagaba nalguák. ");
INSERT INTO kog_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Guatshak ezua sigí Nikudemu axezhuka, aldéñki paldiseyuga nauwisaná akldé akzekue nañga agatsé na naldá. ");
INSERT INTO kog_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ezua siañ, ejañki Duwe Jesú axazguaxal axaldaguenik ekí akbeyá: —Shi maldazʉñkaldixa, mañki me maldé awatuñshiñga ajanashaté tu guañkáaldamak janshizhe atshaté kabatuatshakna, Saldiñga netshi Jatejañga shi zʉñkaldiyal makaxanamakga ne kabajañguxa. Akze, Jate ma na izhogakí naldiñguashíñga, ekígaki atshazhámildaka naldashá. ");
INSERT INTO kog_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Guake Duweja ekí akbeyá: —Namakgaba mikbeyaldikue: Mieldeki abisajañ kukakí naldaldiake, Saldiñga netshi Jateja aksaneshi ni nauwa izho akzegazháka nakldá. ");
INSERT INTO kog_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Guñguake: —Ne, ¿sakí shi káguba atemaldék guane jiaga, mokue abisajañ kuka atshaka na? Azhi ¿mokue jabatshi dzhizhaldi yate, kukapana shi guakue na? ");
INSERT INTO kog_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Guñguake Duweja ekí akiyó: —Akze, namakgaba mikbeyaldikue: Mieldeki nik, aldunak kukakí naldaldiake, ni nauwa Jateja aksanegazháldi, ni aldéñ sanegeñka juldunazháka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Akze, gatak nuxa kuka makualdiake, abuák zaldaga nuxa maldaldaldixa. Jiak amakbé na aldunaldiñki Jatetshi Aldunak zhinikga abisajañ kuka makualdiake, ake, aldunake jékaldaxa zalda maldaldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Akna “abisajañ kukakue nzha” mikbeyaldatshak, “¡sakí ekí nakbeñká!” itshanagába. ");
INSERT INTO kog_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","”Akze, múlkaldaki maniñgaba neyatogatshak, tuasé naldatshak jikak axabugatshak nukamildaka. Ne jiak mani zhinikga naká, ni mashi neyaldixa zʉnake mikualdasé. Akze, mielde Jatetshi Aldunajañga kukshaneki ekibé janañga ne nakldá. ");
INSERT INTO kog_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Guake Nikudemuja jiak ekí aklduká: —Ne, ¿sakí shi amak zegaka na? ");
INSERT INTO kog_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Guake akiyó: —Naldiñki mañki Jateja guiyaba miñkabajane ají kuíbuldu Isayél shi maxaldixa mikzék jiaga, ¿sakí shi aiki migajienakí na? ");
INSERT INTO kog_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Guatshak namakgaba mikbeyaldikue: Nasʉñki zʉñkuahamak, tuñkaldamak za gakuagashá. Ne, ekí gakuagatshak jiaga, ¿sakí zhinik shi aiki “namak nzha” jañgui zʉñgipanakí miná? ");
INSERT INTO kog_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Naski jai kagik zalda shalda miñmeyatoxaldatshak, “namak nzha” jañgui nagipanakí miné tubaldá. Ak zʉna, jékaldaxa zalda shalda miñmeyaldatshak míñgaki, ¿sakí shi namak mijañgualdixa na? ");
INSERT INTO kog_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Guatshak ni me jai kagik zhinik jékaldaxa nitshi guazhé. Askimiñgaba nas Jatetshi Asukuága jékaldaxa zalda naugé, exa zhinik jai kagik naxaldatshak ixagabaldekldugek za na ekí atshikuge. ");
INSERT INTO kog_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","”Mauzeñga nauwibamakue zʉk zeñka azaxaitatoguéñ, takbija kakane ashuishi guakuak nauwibama Mueséja takbi tuñgatsega kaldik matáñ axaldiya guanamakbeñga na, nas Jatetshi Asukuága ixagabaldekldugek jiaga saldiñga natundana kaldixa naxaldiya nakuakue zaldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ekíki mieldeke “nazikuanamak shakldá” najañgui nepana miñgualdiake, Jate abisajañ izhoshiñga mimezhokshapanaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Guatshak Saldiñga netshi Jateki káguba kagik katshekuauxa zʉxaita zʉnezhgajañguxága na, Asukuá ezuamé axaldé jiaga, nauwitsaldí shuixaldiamak zʉñgakaxane. Ekíki mieldeki Asukuá “nazikuanamak shakldá” jañgui ipanaldiake, guiyaba tu za nogakueñka neyagába, jékaldaxa izhoshiñga izhoxaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Akze, sha katshixa shalda guiyaba tuakue zʉñgatsé axazʉndaxalki Asukuá jai kagik zʉñgakagazháne. Ek zhinik káguba kagik katshekuauxa zʉnekualdaldiamak zʉna zʉñgakaxane. ");
INSERT INTO kog_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Akna mieldeki Asukuá “nazikuanamak shakldá” jañgui ipanaldiake, sha atshixa shalda guiyaba tuakue agatsaldaksá guane naldaldixa. Ekí ne, mieldejañki ekíga ipanakí naldaldiák zʉnake, eñki Jateja guiyaba tuakue agatsé axetene abá guanega naldaldixa. Akbiñgaki “Jatetshi Asukuá ezuamé ne nazikuanamak shakldá” jañgui ipanazhá guane nak. ");
INSERT INTO kog_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jinak ekí guiyaba tuakue axaketene naldakí. Duwe Jesúki muñshí zalda nahamakga ne kagik nagatshak, e aldunaxa muñshí mezguakue kakldunazháldi na, jika kutám negaba za ajanashalga aldoxaldiamake, tuañ zeñ abandana kakzeshi iyapanazhá guane nak. ");
INSERT INTO kog_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Akze, mieldeki shane za atshál izhukakueki muñshí zalda ni nauwa kakldunazháldi, kawatuwi guakuak na muñshí zeñ agajué za alduka. Ekíki shane ajanashatuka mu kelzeshi guakuak. ");
INSERT INTO kog_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ekí ne, namaklde zʉñkuahamak za atshál kaldukakuañ zʉnake muñshí zaldak kaxaldaka. Ekíki jian katshauxaki Jatejañga zʉnatshishixa ne zʉnawatualdiamak. ");
INSERT INTO kog_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Guñgueniki Duwe Jesú, aldéñ shi kagitixakue juizhi émaxe Juldeyaga nasʉñ na anuñká izhoxaldiamak abá. Exa kágubakue zʉñkaldagatshake nik kajaukshi na guañkaldoxá. ");
INSERT INTO kog_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Atshake Juañ nik majaukshakueja jiaga káguba axaldeyatoxekue nik kajaukshalga na noxá. Kuíbuldu Enóñ, Saldím tezhake ni matshuwi naldakna exa ekí atshatoxá. ");
INSERT INTO kog_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Guatshake Juañ kalseldi abegagá na noxá. ");
INSERT INTO kog_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ekí atshatogueñki ezua juldiú sanekaga Juañ shagitixakue na sakí janshi ishkazguá jiúñgulde shalda izhgabeji, múldigaba izhgasashaldá. ");
INSERT INTO kog_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ekí ishkaldegatogueniki Juañ shagitixakuejañki axaldeñgueni ekí agabeyá: —Shi maldazʉñkaldixa, ezua, ma na nina Juldáñ uniñkauwa izhogué, ¡sakí atshaté maldúk! “Eñki Jatejañga gaxanamak nakldá” zʉñmemaldane ne, kaigaki e niñkauwañki saldiñgaja izhabixaldá guake, aldéñki nik kajaukshá na nogatók. ");
INSERT INTO kog_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Guake Juañja: —Jate jékaldaxa izhukajañga káguba niuwi agegazhánega ni ji atsha akzegazháka naldashá. ");
INSERT INTO kog_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Akze, maiñ naldi ekí guagaté naldukamine: “Jateja ezua zʉnekualdal gaxaldixa guakldane, naski ai naldazhúge nzha” miñmeyashalgukú. Etshi jiúñgulda axakbeñgui gugé jana atshál Jateja aksajañga nakaxane miñmeyashalgukú. ");
INSERT INTO kog_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Akze, ezua sigí numa nexaldixaja guana munzhiki ipanka. Eja munzhi ipanaté nukatshakna, apebu jika janagaktuñka jiaga matshuwi zeñ akldeka. Ekibeñga guana, Duwe Jesúk za axapa aldeyaldá guxá nukaldatshakna nagatsauxa zeñ nakldegashá. ");
INSERT INTO kog_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aldéñ za na akldé akldeñga akzukuakuamak agazukuatogashá. Guatshake nas niñkauwañki aguáñ aguáñ abakue nagatsék guashá. ");
INSERT INTO kog_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Akze, jékaldaxa zhinik nakldeki saldiñga zhakaldak akzé. Ne, kagik zaldake jai kazʉtuwamak nuxa gakuaka. Duwe Jesú zʉnake akaldak akzé, jékaldaxa zhinik nagatshak ");
INSERT INTO kog_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","eñka tunamak, nukanamak za guagatuka. Ekí guagatshak jiaga, ni meja “namak ni guak” jañgui agipanazhé. ");
INSERT INTO kog_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ekí ne, mieldeke “namak sha guak” jañgui agipánañkaldek zʉnake Jateki namak zukuaka ne kaxazguxa. ");
INSERT INTO kog_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jinake naldakí. Jateja ají Alduna guaja naldakí auxaga Asukuá gaxanek ageka nahéñ zhinik na, eñki ají múldigabaga zukuaka nak. ");
INSERT INTO kog_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Akze, Saldiñga netshi Jateja Asukuá Duwe Jesú izhgajañgui na, jika na nahauxa aksuikualdaldiamak agé guane nakldá. ");
INSERT INTO kog_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Akna mieldekuañki Asukuá namak jañgui ipanañkaldekuañki abisajañ izhoshiñga zʉnezhokshataná. Ekí ne, mieldejañki ipanasʉ́ñ akzexaldiake, jékaldaxa izhoshiñga izhokshazháldixa. Egabá guiyaba kaxañ atemajañ tuñshaldixa axetenega abá guane za nokshataná nakldá. ");
INSERT INTO kog_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Guatshak atshaga na paldiseyukuejañki “Duwe Jesúki Juañ iskaita zalda nashi nik jaukshane na itshenapán” aldukaldá. Guatshak namake, Duwe aldéñ naldi káguba nik jaukshazhá; aldéñ shi kagitixakuañ na ekí atshatoñkalde. Ekí aldukane Duwejañki akwasheguakna, ");
INSERT INTO kog_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Juldeyaxa zhinik akzʉxaitiñgueniki mokue Galdildeyaxaga zʉnauldé. ");
INSERT INTO kog_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Exa neyakualdiamake Samaldia baxe ga zʉxaitakue agatseguakna, ");
INSERT INTO kog_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","amak ai ga nejiñga ezua kuíbuldu Samaldiaxaga Sikál axezhogeñka jeñ ne. Eñkaki nauwibama Jakópja asukuá Jusék kagi bieni axabajananéñ tezhak na zaldá. ");
INSERT INTO kog_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Eñkaga na, ni kaksʉldi zhinik akuxaldiamak Jakópja kuiyanane nogeñka na zaldá. Exa kaldeyatshake naki niuwi muanté zeshi guatoxéñ, Duweki nejiñgaba agusá guatoxakna ai axakuiyanane nogué xezhak yaté. ");
INSERT INTO kog_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Guñguake nasʉñ shi kagitixakuañki kuíbulduldiñgaba gakue jabiyal ne. Guáñkalde kaldogueñki ezua Samaldiabunzhi ni guxal nagatshak, Duweja ekí akbeyá: —Nabunzhi, ni nauwa nakáu guwá. ");
INSERT INTO kog_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Guatshak juldiú sanákuejañki Samaldia zaldakue axabaldegasʉ́ñze giemi ajañguxa naldakna, Duweja ekí akshishatshak munzhijañki ekí akiyó: —Duwe, ¿sakí shi mañki juldiú saná maldé jiaga, nas Samaldiabunzhik ni nakshishamildaka na? ");
INSERT INTO kog_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Guake Duweja: —Mañki Saldiñga netshi Jateja ji mikauwaka miksʉ́ñga, ni nas ni mikshishikugék jiaga me naugé miksʉ́ñ tubaldá. Akze, mikué naldiñguashíñki ma zhinik niñkauwañki ni mikauwakue nakshisha guatabaldaldé. Amak guamakuashíñki ni izhoshiñga mezhokshakue mikáu guataldakué. ");
INSERT INTO kog_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Guake munzhija: —Duwe, ne ¿man zalda ni guxamalde shi izhoshiñga nezhokshaka mixaldeki maldakbé? Niki juit zeñka nuka ne, mañki ai akbemildaka mixaldaldakí tuashakú. ");
INSERT INTO kog_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Akze, nauwibama Jakópjañki auxaga ni zʉñkaldaldaldiamake jejié zʉñgakuiya, zʉñkabajanane. Ai niki nauwibama aldéñ, asukuákue, ají béyakzekue juizhi atuka nane. Ne, ¿mañki sakí shi e zhakldé mikzé jana ni nakaumildaka maldakbé? ");
INSERT INTO kog_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Guñguake Duweja ekí akiyó: —Akze, mieldeke jalde ni tuxaminaldixaki jiak mokue miñnunañga gualdixa. ");
INSERT INTO kog_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ne, mieldeke nas ni miñkaunaldikue tuxaminaldixa zʉnake, ni mitsák mokue miñnunapana guazháka. Akze, ai na maiñldiñga ni nañkajéñ jana nañkal za nogéñ zhinik, auxabé miñzukui izhoshiñga mimezhokshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Guake munzhija: —Ake, Duwe, ai ni nakáu guwá. Ekíki ni naklduni mokue jai guxal naxalga noshi guanakldegak. ");
INSERT INTO kog_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Guake Duweja ekí akbeyá: —Ake, misewá gugate guwá. ");
INSERT INTO kog_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Akbeñguake: —Miya, naski sigí naxaldaldakí nakldá. Guake Duweja akiyó: —Namak, sigí mixaldaldazhámak ni maldakbé. ");
INSERT INTO kog_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Akze, jatshiwa mixaldanane naldashá. Ne, kaiga migapakueki misewá naldagálde nakldá. Akna namakga na makuák. ");
INSERT INTO kog_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ekí nukatshakna munzhija ekí akbeyá: —Duwe, mañki Jatetshi múldigaba naldiñga mazʉxaitshixaga maldé matú ni gukú. ");
INSERT INTO kog_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Guatshak nauwibamakuexa zhinikga jejié guinuañ na Jate akldé akzamakga akzukui kaxazguaka. Ne maiñ juldiúkuañki Jeldusaldéñka za Jate akldé akzamakga akzukui axazguagakueñka ze miñguaka nakna, ¿mashi zaldaka sha? ");
INSERT INTO kog_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Guake Duweja akiyó: —Nabunzhi, mikbeyaldikueki namak jañgui nagipana makualdí. Ezua ldiuwañ zegatshakna Jate akldé akzamakga akzukuaki ni jejié guinuañ za, ni Jeldusaldéñka za naldaka naldaksá gualdixa. ");
INSERT INTO kog_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Akze, maiñ Samaldiakuañki Jate akldé akzamakga akzukuabinogatshak jiaga, muldetua “me ne” miñsʉ́ñga noshi ekí miyatshixa. Nasʉñ juldiúkuañ zʉnake muldetua “me ne” zʉñkualdi na akldé akzamakga kakzukuxa. Jinake naldakí. Jateja káguba zhekuauxa ikualdal ezua gaxaldixa guakldaneki nauwisaná juldiúk zhinikga naldaldixa nak. ");
INSERT INTO kog_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Guatshak ezua ldiuwañ akldañkaldixaki eñ zek na gu. Amak zegapanatshakna mieldekuejañki namak giemi Jate akldé akzamakga akzukuxakuejañki Jate shalda namaklde kakuahamak za aldunaxa zhinik akldé akzamakga agazukualdixa. Jinake naldakí. Aldéñki ekí agatsaldi akldé akzamakga akzukualdixakue niyatuka nak. ");
INSERT INTO kog_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Akze, Saldiñga netshi Jateki aldunaga ne. Akna akldé akzamakga akzukuexañki, e shalda namaklde mikualdiñga na, muldetua aldunaxa zhinik akldé akzamakga akzukuakue nakldá. ");
INSERT INTO kog_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Guake munzhija ekí akbeyá: —Akze, nas nakueki, Mesiya, Jateja zʉnekualdal gaxaldixa guakldaneki naxaldixaga nakué. E na naxaldiniki jika nuk shi zʉñkaldiyaldixa. ");
INSERT INTO kog_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Guake Duweja: —Akze, nas ai naugék guana dulda mikshatogashakú. ");
INSERT INTO kog_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ekí akbeyatogueñga na shi kagitixakuañ mokue ai nak. Kaldagatshake munzhi na dulda zhikshaté katuatshakna, “¡sakí shi Samaldiabunzhi na ekí dulda zhikshaka na!” zʉñnegatshak jiaga, ni mieldeke “¿ji migajuezhé?” azhi “¿ji shi zhikbeyabinók?” akldukazhá. ");
INSERT INTO kog_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Guakna munzhiki egabá muksú za na maji, kuíbulduldi neñgueni exa zhekuekuek ekí kakbeyaldá: ");
INSERT INTO kog_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—¡Ezua sigí tuatak guwíñ! ¡Ejañki saldiñga atshanugauxabe ni nakbé! ¡Azhi ega ska Jateja ezua zʉnekualdal gaxaldixa guakldanega naldaka na! ");
INSERT INTO kog_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Guñguake amak kuíbulduxa zhinik Duwe nugéñ saldi aldaxaldá. ");
INSERT INTO kog_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Guatshak amak aldagagá nogueñga na: —Shi maldazʉñkaldixa, jika nauwa ga guwá —kagakuañnegatshak jiaga ");
INSERT INTO kog_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ekí zʉñkiyó: —Nas gakuge naxaldeki “ji ne” miñkualdakí nakldá. ");
INSERT INTO kog_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ekí zʉñmeyatshakna nasʉñ shi kagitixakuañgaba ekí zhiklduká: —Ji neñki, ¿gakue akualdák mi akuatoxá? ");
INSERT INTO kog_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Guake Duweja ekí zʉñmeyá: —Nas gakue gakugeki Najate nakaxane najañguauxabe axatshiji ulditshigatoxaldatshak guana, gakue gaji jana atshashakú. ");
INSERT INTO kog_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Akze, akuagamak ekí guakbinaka: “Azaldixane gakue gugakuéñ zegexañki makaiwa saxaga na juezhatók.” Ne naski ekí miñmeyaldikue: ¡Uba zhikldeñsha xaldeki tekue jeñ tu guwíñ! ¡Gakue muñshí nekldega nee tuashibiná! ");
INSERT INTO kog_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Akze, gakue gukakueki jibatshane shalda ji ipanakue kagatsahamak iyapanka. Ekibeñga na, mieldekueja nepanakuká guanekue gakue gushi jana neyapanshatshakna, nepananekueki abisajañ izhoshiñga izhoxaldiamak ajanashixa. Akna gakue guka, zulda nixane na zhualduxañga zeñ izhajanaldixa. ");
INSERT INTO kog_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Akze, ai shalda na, namak akuashiñga ekí akuaka: “Ezuañki zʉzika, ezuajañki gakue neklde guka nakldá.” ");
INSERT INTO kog_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ekí akuagamakbeñga na, nas jiaga maiñ naldi jibatshazhámineñ gakue neklde jana gugaxañ mimakaxanuge. Akze, miñguxaldixaki axautshikue guana kama ilshiji, nishi jiba ajanashanane. Ne maiñki ai gugakuká guane guxabinuka nuxa nakldá —na zʉñmeyá. ");
INSERT INTO kog_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Guatogatshake kuíbulduxa munzhijañki “ezua sigíja saldiñga atshanugauxabe ni nakbé” kakbeyaté aldukañguéñ zhinik na, exa Samaldiaxa zaldakue matshuwi nekueja Duweki zʉnekualdal nakldamak ajañgui alduna iyashane. ");
INSERT INTO kog_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nalguakna kuíbulduxa zhinik axaldagueniki kauwizhéñ na anuñka izhogakue axakuañneguake, amak mutiuwiñ kakizhó. ");
INSERT INTO kog_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Amak izhoxañkaldoguéñ míñgaki exa zhekuekueja ají múldigaba naldi aldukatogatshakna, akldé matshuwi nekueja namak na ajañguá. ");
INSERT INTO kog_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Guñguakna munzhik ekí agabeyá: —Kaiga zʉnake ma sakí zʉñmemaldéñ zhinik za namak jañguagába, nauwijí kuxak naldi kaldukatshak míñgaki eñki namak giemi káguba kagik zhekuauxa ikualdal naklde naldiñga ne ni zʉñwashék. ");
INSERT INTO kog_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Amak mutiuwiñ izhogueniki jiak, Duwe Jesú exa zhinik Galdildeya baxe mokue neyaldá. ");
INSERT INTO kog_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Guatshak Duweja ekí guakldane: “Jatetshi múldigaba naldiñga zʉxaitshixaga akuíbulduk zaldakueja axabetazháldi, akzé ajañguazhé nakldá.” ");
INSERT INTO kog_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nalgué, Galdildeyaxa kaldeyatshak exa zaldakuejañki zeñ kakldeshi iyapaná. Jinake naldakí. Kauwizhéñ jiaga Jeldusaldéñka ajuizhaldexal alditshine nalgué, Duweki exa ajanashaté atú guazhámak janshizhe atshatonauxa atune nalguák. ");
INSERT INTO kog_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Guñgueni exa Galdildeyaxa kuíbuldu Kanáxa mokue ne. Exaki ni tashí nalgué kalwéldia nekshanalgueñka. Guatshak ezua sigí sáñkaldak axakyokueki Kapeldahúmka asukuá mulbatá axakzeshiñgaba guatogué, ");
INSERT INTO kog_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Duwe Jesú Juldeyaxa zhinik Galdildeyak naklde nukañguake akldabixal nak. Akldabigueni ekí akbeyá: —Guañ maldaguanaldí. Nasukuá nakshuigaté nogák, nagiskaitshate ni guakuá. ");
INSERT INTO kog_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Akbeyakna Duweja ekí akbeyá: —Maiñki me naugé mimatuñshaldikuamake, atemajañ ajanashaté atú guazhámak atshaté minatuatshak za na “namak nzha” minajañgualdixa tubaldá. ");
INSERT INTO kog_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ekí akbeyatshak jiaga ekí akbeyá: —Duwe, egaba mija nagwá. Nasukuá nakshuigagáñga nagiskaitshi makualdixá. ");
INSERT INTO kog_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Guakna Duweja ekí akbeyá: —Mijuldi neyabikuká ni gu. Misukuáki se akzeklde ité nakldók. Ekí akbeñguake “namak sha Duweja nakbé” jañguñguake amak ne. ");
INSERT INTO kog_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Neñgueni ajuxa agatanagá nogueñga, ají nashikueja jiúñguldaxaga agaldabigueni ekí agabeyá: —¡Misukuáki se akzék guane ité nzhok! ");
INSERT INTO kog_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Guñguake ekí kaklduká: —Nalgué, ¿mitsá zalguéñ se akzegapangué? Guake ekí akiyayó: —Mebák niuwi muanté izhgajié zegatshake guañgua zalda iskaitá na guñgú. ");
INSERT INTO kog_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Agabeyatshakna ajateja, ake, anuñka zalguéñ na Duweja “misukuáki se akzeklde ité nzhok” akbene be agisék. Guñguakna saldiñga ajúk zaldakue juizhi Duwe Jesúki “namak nzha” na ajañguá. ");
INSERT INTO kog_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Guatshak Duwe aldéñ “me ne” awatuñshiji ajanashaté atú guazhámak janshizhe atshaneki, mutshuizha ne na Juldeyaxa zhinik naguenik Galdildeyaxaki ekí atshá. ");
INSERT INTO kog_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Guñgueni anuñka zegatogueñki juldiúkuañ Jeldusaldéñka kajuizhaldegéñ ldiuwañ zeguake Duwe Jesú mokue exa jeñ zʉnaulditshí. ");
INSERT INTO kog_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Guatshake exaki ajulduneñga jubeju ajuldukshéñ tezhak na niwa axakuiyane, ebeldeyuke Betsata axezhuka na naldá. Aiki jatshiwa agatsalda sui zeñ ashé aldoxaldiamak jika axapanéñ. ");
INSERT INTO kog_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Eñ na sakígaba akzekakue matshuwi ashekue, uba isékue, muldetua neyagáldekue, miyagaba ixananekue juizhi axekualdi. Aikuejañki “niwa mitsák jato jato atshaldí” ajañgui jiyagatuál za alduka. ");
INSERT INTO kog_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Jinake naldakí. Atshuak zaldaldieñki Jateja guaklde uldeñka agatanaldinik niwa jato jato axaldegatshake, mielde misha niwaxa juldunatshake sakígaba akzegatonaldixa se akzeka nalguák. ");
INSERT INTO kog_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ekí noxekuega na, ezua sigíki izhgaldagaksánguenik 38 kagi itsé na gekualdá. ");
INSERT INTO kog_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ekí Duweja izhgaldagagálde sha za nuka tuatshakna, mitsá itsegatuka akwasheguák ekí aklduká: —¿Janshi mikzekldana mikzék shi gu? ");
INSERT INTO kog_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Guake izhgaldagagáldeja: —Duwe, naski ni me niwaxa najuldukshaxañ nagaunegaka naldakí. Akna niwa jato jato atshatshak, ezuakue misha naguabiyañga exa ajulduñga ajanashashá. ");
INSERT INTO kog_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Guake Duweja ekí akbeyá: —¡Izhgate xaldeki mixabaka guxaki newa! ");
INSERT INTO kog_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ekí akbeyatshaga na janshi akzeguake izhgate, ixabaka gugueniki amak neyaldá. Guatshake ai ldiuwañki kizhiksekué ldiuwañ na zaldá. ");
INSERT INTO kog_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Zaldakna juldiú sanekakueja sigí janshi akzeklde ekí axaldék: —Kaigaki kizhiksekué ldiuwañ ze ne, mixabaka mauldeyatshake guiyabaja guagazhámak atshashibaldá. ");
INSERT INTO kog_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Guake ekí kakbeyá: —Guatshak janshi nakzukuaneja guana ixabakuge guxa xaldeki neyakue nakbeyashaldá. ");
INSERT INTO kog_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Guake ekí agalduká: —Ne, ¿mieldeja shi mixabaka guxa xaldeki neyakue mixaldegatoxá? ");
INSERT INTO kog_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Guatshak meja janshi akzukuane aldéñ aksʉ́ñ na naldá. Akbiñgaki Duweki káguba matshuwi zhikzhe neyatoxé kenañ ga agitshuá guane naldák. ");
INSERT INTO kog_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Guñgueni mokue aldiwanki Duweja ai sigí juwí Jate axazakuageñkaga akldabigueni ekí axaldék: —Nukaté nogwá. Janshi mikzék guane nakna, akldé sha atshalga noxabaldáldi. ¡Akldé agatsaldi migisa nigunék! ");
INSERT INTO kog_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Guñguake sigí neñgueniki juldiú sanekakuek Duwe Jesúja janshi akzukuane kakbeyá. ");
INSERT INTO kog_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Duwe Jesú kizhiksekué ldiuwañ jiaga ekí atshatuka aldukañguakna sha akuí akuaxaldixa kakldeshi guiyaba atuñshaldiamak aldiyá na aldogapaná. ");
INSERT INTO kog_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Guatshakna Duwejañki ekí kakiyó: —Najateki niuwi neyauxa jibatshál za nogatuka. Nak nas jiaga e janañga jibatshál za noxaldikue naldashá. ");
INSERT INTO kog_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ekí aldukajé shalda na akuaxa akualdiamak akldeñga aldiyá na aldoxá. Akze, kizhiksekué ldiuwañtshi guiyabaja guagamak atshazháne shalda za aldiyazhá. Akbiñgaki “Saldiñga netshi Jateki Najatega nakldá” guagatshak, e zhuxañga ne nexé shalda na ekí aldiyatoxá. ");
INSERT INTO kog_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Guake Duwe Jesúja ekí kakbeyaldá: “Namakgaba miñmeyaldikue: Nas Jate Tsukuakga ni nasgaba nakldek ji atshazhánaka. Askimiñgaba Najate atshaté tuñgamak za atshanaka. Akze, Najate atshauxabe nas Asukuák jiaga atshikuge. ");
INSERT INTO kog_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Jinake naldakí. Najateki nezhgajañgui na, jika atshatogauxa natuñshixa nak. Guatshak kaiga zhinik míñgaki akldé atemajañga natuñshaldixa. Ekí atshaté minatuatshakna, ‘¡sakí ekí atshixá!’ minajañgualdixa. ");
INSERT INTO kog_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Akze, Najateja shuanekue jiaga mokue izhgaldakshi alduna kaxaldekshamakbeñga, nas Asukuák jiaga mieldeki abisajañ kezhokshanaka nakldexaldiake amak atshikuge. ");
INSERT INTO kog_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Akze, Najatejañga ni me agatsaldi azhi agatsaldakí ne axezhashi izhogakí. Ne, nas Asukuák za guana mielde agatsaldi azhi agatsaldakí ne tuwa axezhaxa niuwi nagene. ");
INSERT INTO kog_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ekíki saldiñgaja Najate akzé jañgui axabetamakga, nas Asukuák jiaga ekíga naxabetaldiamak. Akze, mieldeki nakzé najañguazháldi naxabetakí naldaldiák, Najate nakaxane jiaga ekíga axabetagálde naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","”Namakgaba miñmeyaldikue: Mieldeke Najate nakaxane namak jañgui, nají múldigaba minagipanatshakna abisajañ izhoshiñga izhoxabipanaldixa nakldá. Ekueke guiyaba tuakue miñgatsé axaminaldagazhíta. Aldunaldiñki shuamine jana Jatek agajué za izhoxabinogué, minepanatshakna e na izhoshiñga izhogapanamine. ");
INSERT INTO kog_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Guatshak namakgaba miñmeyaldikue: Ezua ldiuwañ akldañkaldixaki eñ zek na gu. Ekí zegatshakna nas Saldiñga netshi Jate Tsukua giemi naugék, mieldeke nají múldigaba nagipana miñgualdiák zʉnake, aldunaldi shuamine jana miné abisajañ izhoshiñga mimezhokshaldikue. ");
INSERT INTO kog_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jinak naldakí. Najatejañki izhoxa aldéñ aksuikuamakga, nas Asukuák jiaga ekíga izhoxa naksuikualdaldiamak nagé guane nak. ");
INSERT INTO kog_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ekíga na, káguba agatsaldi azhi agatsaldakí ne tuwi axezhaxa niuwi nagene. Jinake naldakí. Asukuága ixagabaldeklduge naugák. ");
INSERT INTO kog_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","”Ekí miñmeyaldatshak, ‘¡sakí shi ekí nakbé!’ miñnegagába. Akze, ezua ldiuwañ zexaldixaga. Eñ zegatshakna saldiñga shuanekue kabexanaldi zhinik naxaxak naldi kexauldaté naldukaldixa. ");
INSERT INTO kog_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Guatshakna aldi zhinikga agazaxaitaldixa. Atshakna mieldekueki kajañgugamak janshizhe ajanashiji izhonaldixakueki abisajañ izhoshiñga kezhokshaldikuamak kezhgaldakshaldikue. Guatshak mieldekue sha ajanashál za aldonaldixakue zʉnake kagatsé axakezhashi, guiyaba atú za kaldokshaldikuamak kezhgaldakshaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","”Naski nasgaba nakldek ni ji atshazhánaka. Askimiñgaba Najateja nakbeyaté nukaugamak za mielde agatsaldi ne tuwi guiyaba tuakue axezhakuge. Ekí atshaldatshak tuakuauxabe tuwi axezhakuge. Jinake naldakí. Ni mitsák nasgaba jañgugamak nuxa atshaldikue niyagába, Najate nakaxaneja jañguamak za atshaldikue niñkuge nak. ");
INSERT INTO kog_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Guatshak nasgaba akuakugéki auxabé naxakzaldazháka. ");
INSERT INTO kog_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Naldatshak ezua natunamak axanezhaka nañga. Ejañki namak naugé axanezhagatshak, namaklde za axanezhaka nas jiaga nakué. ");
INSERT INTO kog_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","”Guatshak maiñki ezuakuek Juañ nik majaukshakue akzʉzukal agakaxamine nalgué, aldéñki namak za nas shalda guaklde naldashá. ");
INSERT INTO kog_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Naldiñki nasga káguba axanezhaxaldixa nagajuezhiñki nagajuezhakí. Naldatshak jinak e shalda miñmeyakí. Namak minajañguatshak minkualdaldikue nak. ");
INSERT INTO kog_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Aldéñki muñshí stuñka jana muñshí zukui izhogatoguéñ na, eja guaká miñnuni zeñ miñneshi axaldukaté anuñka ldiuwi me nomine naldashá. ");
INSERT INTO kog_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","”Guatshak Juañja namak naugé guaká guashiñki zhakaldak namak nezguxa nañga. Aiki Najateja axatshiji agisʉgakualdikue nagene, amak axatshugéjañga na ‘Saldiñga netshi Jateja gaxanamakga ne tiuwi’ nezguxa naldashá. ");
INSERT INTO kog_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ekibeñga na, Najate nakaxanejañga nas shalda axanezhaka. Naldatshak ni mitsák mimijí ubak naldi e tuabíne, ni axaxak naldi zukuagaté nukabíne, ");
INSERT INTO kog_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ni ají múldigaba jiaga agipanabínega ne tiuwi. Akbiñgaki aldéñga nakaxane ne, ‘namak nzha’ najañguabíne nak. ");
INSERT INTO kog_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Guatshak maiñki ají múldigaba sezheklde muldetua shi mitiyaldiamak agatsaldi mituñka. Eñkáñ zhinik aldunaxa abisajañ izhoshiñga izhoxa jiúñgulde miñzaldaldixa jañgui na ekí miyatshixa. Naldiñki ejañga guana nas shaldaga guaka ");
INSERT INTO kog_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","naldatshak jiaga, ekí izhoshiñga mimezhokshaldikuamak nepanasʉ́ñ miñzegashá. ");
INSERT INTO kog_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","”Nasga káguba nuxa akldé nakzamakga nakzukualdixa nagajuezhiñki nagajuezhakí. ");
INSERT INTO kog_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Naldatshak naski nakualdi minuka: Jate izhgajañguabíne tuashakú. ");
INSERT INTO kog_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Najate naldataldé naski naklduge naldatshak jiaga, nazipanazhá guashibiná. Akze, axautshi, axaldáñgaba nagatuka guashí zʉna, ipaná guaminaka naldashá. ");
INSERT INTO kog_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Akze, ataba atabañ akldé mizhikzukualdiamak za niyabinuka. Ekí minogatshakna, Saldiñga netshi Jate, e za akaldak akzék zhinik janshibé atshabinuka tuwi, akldé miñzukualdiamak niyakí minakna, guane ¿sakí ‘namak nzha’ minajañgualdixá? ");
INSERT INTO kog_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","”Ekí minaldatshak jiaga, nas Najate nugeñka miñgatsé mimezhguaxaldikue minajañguake, naski naldazháldikue. Akze, mimezhguaxaldixaki nauwibama Mueséga guana ekí mimakuaxaldixa. Naldiñki miñgatsaldazhé mimatualdiamak na, eja guiyaba jian izhoxa miñmenek agasjanamine. ");
INSERT INTO kog_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Akze, Mueséjañga guana nas shalda guashi kalta gauwanane nak, Muesé namak jañguamimakuashíñki, nas jiaga namak najañguatabinaldé naldashá. ");
INSERT INTO kog_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ne, ni eja gauwanane namak jañguakí miné, ¿sakí shi nas guakuge míñgaki namak minagajañgualdixa na?” na kakbeyatoxá. ");
INSERT INTO kog_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Guñgueni Duwe Jesú mokue Galdildeyaxa neñgueni niwa Galdildeyatshi ataba niñkauwa akbaték. Guatshak e niwaga na kuíbuldu Tibeldiatshi jiaga akuaka. ");
INSERT INTO kog_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Guatshak kágubakue matshuwi zhikzhe axapa aldeyaldá. Jinake naldakí. Aldéñ “me ne” awatuñshaldiamak na ajanashaté atú guazhámak mulbatá akzekakue iskaitshaté atuñka nalguák. ");
INSERT INTO kog_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ekí kakbategueni Duweki nasʉñ shi kagitixakue nañga gaxa akshá zeñka iyabegueniki yaté. ");
INSERT INTO kog_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Atshake nauwibama juldiúkue san kagixa guiyaba atuwi ashekualgueñka zhinik Jateja kakzʉxaitshanéñ ldiuwañ be izhgisekui kajuizhaldegéñ naki zeshi na guatoxá. ");
INSERT INTO kog_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Guñgueni Duweja káguba matshuwi zhikzhe axaldagaté tuñguakna Pildipik ekí akbeyá: —Saldiñga ekueja gakue ga guashi ¿mani kagajabiyakualdixa sha? ");
INSERT INTO kog_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ekí akbeyatshak Duwejañki sakí atshaldixa akshañga nogatshak, Pildipi guajaldiamak na ekí akbeyá. ");
INSERT INTO kog_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Guñguake Pildipija akiyó: —Ni amak 200 ldiuwi kasa izhgaunuge guashí jiaga, aikueja nauwa nauwa axaldixa jabí guashi jueñga naldaka naldashá. ");
INSERT INTO kog_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gueni ezuak shi kagitixakuañga Andaldé, Simóñ Péguldutshi aldani naldeja ekí Duwek akbeyá: ");
INSERT INTO kog_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Jai ezua sukuajañki jatshiwa pañ aguáñ akzé sezheklde, mozhua pikáu nuxabé axaldá tiuwi. Guatshak aiki káguba anuñka zhekuéñ ¿sakí zauwaldixa ne? ");
INSERT INTO kog_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Guñguake Duweja ekí zʉñmeyá: —Saldiñga yaldagakue kakbeya guwíñ. Guatshak exaki kaldá kaldeldi zalguakna jeñ yaté. Guatshake sigíkuegaba iyazatatshak, anuñka 5.000 naldashi na aldaldá. ");
INSERT INTO kog_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Guñgueni Duweja pañ zhiksuiguenik Jatek ai shalda “zeñ nzhakldék” akbeñgueniki, yatenekuek ezua ezuak kakldunauxa kakauwakue guak. Ekíga na, pikáu jiaga kakauwakue guak. ");
INSERT INTO kog_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Guñgueni amak axajiñga yau kakzekldegaba neguake, nasʉñ shi kagitixakuañ ekí zʉñmeyá: —Gakue itshuani guakuak kagabanekueki nuk guxa guwíñ. ");
INSERT INTO kog_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Guñguake amak nuk kakuashatshake, jatshiwa pañ me nane nalgué gaji kagabanegaba 12 nuldi na sʉnexá. ");
INSERT INTO kog_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Guatshak kágubakueja Duwe Jesú aldéñ “me ne” awatuñshaldiamak na janshizhe ajanashaté atú guazhámak ekí atshaté atuñguakna ekí akuaxaldá: —¡E zʉnake namak giemi Jatetshi múldigaba naldiñga zʉxaitshixa kagik naxaldixa akuakldanega ne tiuwi! ");
INSERT INTO kog_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Guatshak ekueja axaldaxaldiniki kamañ naldi sáñkalda akzé ishkiyaldaxaldiamak awaldeyaldixa ajañguatuka Duweja katuñguakna, ahezua mokue akldé zaldi nitshí. ");
INSERT INTO kog_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Guñguenik niuwi iyaldaxaldá guapanguake, nasʉñ shi kagitixakuañki mokue niwak jeñ agatana, ");
INSERT INTO kog_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","kanuwak kajuldungueniki ataba niñkauwa Kapeldahúmka akbatexaldá. Guatshake muldetua tuañ zegatshak jiaga Duwe Jesúki zʉñnabigagáñga te ");
INSERT INTO kog_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","nogueñga na, múlkaldaja niwa kamakualdi izhgaldakshatshake kuisshaldá. ");
INSERT INTO kog_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ekí zegatshak jiaga maldé zeñka naki niwa mitakuaxá kanuwa uldeyañkaldoguéñ, Duweki niwa bakaldak ga kasam kanuwak akyó zʉñkaldagaté katuatshak, she she she na zʉnzheñshá. ");
INSERT INTO kog_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Guñguake ekí zʉñkaldék: —Nasga na nakú. ¡Zhe miñzegagába nogwíñ! ");
INSERT INTO kog_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ekí zʉñkaldeguake zeñ zʉñneshi kanuwaxa kajuldukshiñguenik, mitsá zegagáñga neyakualdixa jañguañkaldalgueñka jeñ izhañká. ");
INSERT INTO kog_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Guane nalgué, abokualdíki kágubakue ataba niñkauwa abane nalguekueja Duwe shi kagitixakuañ za na kanuwa ezua me ixekualguék Duwe naldakí kajuldungueni neñkalde kakldék. ");
INSERT INTO kog_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Guatshake anuñka kanuwakueki kuíbuldu Tibeldiaxa zhinik exa Duweja gakue shalda “Jatek, zeñ nzhakldék” akbene axatoneñka akyó jeñ izhañká. ");
INSERT INTO kog_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Guatshake Duwe, ni nasʉñ shi kagitixakuañ exa zʉnatuakí aldalguake, kauwizhéñ jiaga kanuwakuek jeñ ajuldungueniki Kapeldahúmka Duwe aldiji aldaxaldá. ");
INSERT INTO kog_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Guñgueni agabategatshake Duwe Jesú kakzalguake ekí agalduká: —Shi maldazʉñkaldixa, ¿mitsaga shi jexa naxabaldogú? ");
INSERT INTO kog_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Agaldukatshak ekí kakiyó: —Namakgaba miñmeyaldikue: Ni maiñga nuxa nas me naugé awatuñshaldikuamak janshizhe ajanashaté atú guazhámak atshaté natumine miñgajienane nak naldiyakí. ¡Egabá yau miñkaunugéñ zhinik naldiyabinukaki mimatuakí shi nakú! ");
INSERT INTO kog_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Gakue naldaksánaldixa za miñkaldaldaldiamak niji kama ilshakue miñgatsaldakí. Ne, gakue ni mitsák naldaksá guazháldixa auxabé mikzukui izhoshiñga mezhokshakue miñgexaldikue zʉnake, niji kama ilshakue miñgatsé. Akze, nas Jatetshi Asukuága ixagabaldekldugek na ekí atshaldikuamak niuwi nagenéñ zhinik Jateja janshibé atshikuge nawatuñshane nakldá. ");
INSERT INTO kog_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Guñguake agalduká: —Guake, Jatek akldunamak auxaga atshakualdiamake, ¿sakí shi atshakue zʉñgatsaldaldixa na? ");
INSERT INTO kog_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Guake Duweja kakiyó: —Jatek akldunamak atshijiñki ezuañgaba aldéñ nakaxane namak najañgui nazipanakue. ");
INSERT INTO kog_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Guñguake mokue agalduká: —Guake, me maldé maldazʉnatuñshaldiamake, ¿ji ajanashaté tu guañkáaldamak atshamildaka ne? Zʉnatuñsha guwá, “namak nzha” majañguakualdiamak. ");
INSERT INTO kog_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Akze, nauwibamakueki zʉk zaldi kawaldeyatoguéñ, jékaldaxa zhinikga gakue axaldiamak kagaktinanega axatone. Ekíga guana Jatetshi múldigaba sezhekldeja “gakue jékaldaxa zaldaga kagaxauwatone” guagashá. ");
INSERT INTO kog_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Guakna Duweja ekí kakbeyá: —Namakgaba miñmeyaldikue: Mueséjañga jékaldaxa zhinik gakue mimibamakuek kagegatogazháne; Najateja guana gakue namaklde jékaldaxa zhinik miñgeka naldashá. ");
INSERT INTO kog_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Akze, Jateja gakue miñgekáki jékaldaxa zhinikga miñkizhañkashatuka, eñki káguba kagik mizhekuauxa auxabé miñzukui mimezhokshaka nakldá. ");
INSERT INTO kog_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Guñguake ekí agashishá: —Duwe, ake, ai gakue zʉñgexal za maldoxaldí. ");
INSERT INTO kog_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Guñguake Duweja ekí kakiyó: —Nas guana gakue auxabé aldunaxa miñzukui mimezhokshanaka nakldá. Akna mieldeki naxaldaxaldiák, maldija gualga nogazhíta. Ekibeñga na, mieldeki namak najañgui nepanaldiák, ni akldunalga nogazhíta. ");
INSERT INTO kog_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Guatshak miñmeñkuamakga, sakí atshaté natú miñguatshak jiaga, namak najañguakí miné mimatuashakú. ");
INSERT INTO kog_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Akze, Najateja saldiñga najíkue naldaldiamak nagekákueki naziyapanal naxaldaxaldixa. Amak naxaldaxaldixakueki ni mitsák kepanazháldi kaldeñshazháldikue nzha. ");
INSERT INTO kog_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jinake naldakí. Nasgaba jañgugamak atshaldikuamak nuxa jékaldaxa zhinik zabagába, Najate nakaxane najañguamak axatshaldikuamak zabinuge nak. ");
INSERT INTO kog_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Akze, nakaxaneki ekí najañgui: Saldiñga nagenekue, ni ezua agitshuaksha guagába, ashuanaldini auxa zegatshak izhoshiñga izhoxaldiamak kezhgaldaksha guakue najañguxa. ");
INSERT INTO kog_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jinake naldakí. Najateja jañguxáki mieldekueki natuatshak Jate Tsukua naugé namak najañgui naziyapana guanaldixakueki izhoshiñga izhoxaldixakue kajañguxa nak. Ekuega na auxa zegatshak nasga mokue kezhgaldakshaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Guakna juldiú sanekakuejañki Duwe sha akuaxaldá. Akbiñgaki “nasga na gakue mimezhokshanaka jékaldaxa zhinik zabinuge nakldá” nexé shalda. ");
INSERT INTO kog_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Akna ekí izhgabeyaldá: —Jejié Jesúki ¿Jusé tsukua naldazhé shi na? Ajate, ajabaki nasʉñ katuñkaga naldashá. Ne, ¿sakí shi kaigaki “nas na jékaldaxa zhinik zabinuge nakldakú” negaka na? ");
INSERT INTO kog_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ekí aldegatoguakna Duweja ekí kaxaldék: —Ekí negagába nogwíñ. ");
INSERT INTO kog_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mieldeki Najate nakaxaneja nakuldagakí naldaldiák, nepanal naxaldagazháka. Mieldeki nakuldaxaldiák zʉnake, shuanaldini auxa zegatshak izhgaldakshaldikue. ");
INSERT INTO kog_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Akze, Jatetshi múldigaba naldiñga zʉxaitshixakueja ekí kaltak axauwane: “Jatejañga saldiñga nekue shi kaxaldiyaldixa nzha.” Akna mieldekue Najate aldukaji shagitiyanaldixakueki nepanal naxaldaxaldixa. ");
INSERT INTO kog_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ekí guagatshake mieldejañki Najate naldi tu guane guáshiñki guagakí. Ezuañgaba nas aldéñ zhinikga nakldugek za na tunuge nakldá. ");
INSERT INTO kog_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","”Namakgaba miñmeyaldikue: Mieldeki namak najañgui nazipanatshaga na auxabé akzukui izhoshiñga izhokshateñkuge. ");
INSERT INTO kog_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nas na gakue auxabé aldunaxa miñzukui mimezhokshanaka. ");
INSERT INTO kog_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ne, mimibamakueki zʉk zeñka azaxaitatoguéñ, jékaldaxa zhinikga gakue kagaktinanane axatogué jiaga, ashuizhañga akuanane. ");
INSERT INTO kog_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ekí ne, gakue jékaldaxa zhinik kaiga zabineki mieldeja ga gualdiák shuigazhíta. ");
INSERT INTO kog_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Akze, nas guana ejié gakue mezhokshakue izhoshiñga izhokuge jékaldaxa zhinik zabinuge nakldakú. Akna mieldejañki ga gualdiake izhoshiñga izhogataná. Akze, gakue miñgexaldikueki nají abuága na saldiñga káguba zhekuauxa izhoshiñga izhoxaldiamak akexaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ekí guaguakna juldiú sanekakueja kauwizhéñgaba kaxañ naldi ekí izhgaldukaldá: —¿Sakí shi jejiéja ají abuá naldi gakualdiamake zʉñkauwakaki guak? ");
INSERT INTO kog_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Guatshak Duweja ekí kakbeyaldá: —Akze, namakgaba miñmeyaldikue: Maiñ mizhoxaldiamak gakue miñgajamak Jatetshi Asukuá ixagabaldekldugetshi abuá gakí minaldaldiák, niki mitugamakga nají abi tugakí minaldaldiák, izhoshiñga izhogazháminaka minaldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ekí ne, mieldeke nají abuá ga, nají abi tuxa miñguatshakna auxabé miñzukui izhoshiñga mimezhokshapanaldikue. Akna shuaminaldixa auxa zegatshak nasga mokue mimezhgaldakshaldikue. ");
INSERT INTO kog_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Akze, gakue namaklde ga guakueki nají abuá. Ekibeñga na, tugakue namaklde tuxa guakueki nají abi nakldá. ");
INSERT INTO kog_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mieldejañki nají abuá galdiák, nají abi tuxaldiák, nasldi izhoxal za noxaldixa, jiak nas zhinik eldi izhoxal za noxaldikue. ");
INSERT INTO kog_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Akze, Najate nakaxane aldéñgaba izhoshiñga izhukak zhinik izhogatokuge. Ekibeñga na, mieldeki nakaji jana nazipanaldiák, nas zhinikga auxabé akzeshi izhoxaldixa. ");
INSERT INTO kog_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ekí gakue miñmeyatokugeki mimibamakueja gakue kagaktinane axatogatshak jiaga ashuizhañga guanane janañki naldazhé. Akze, gakue jékaldaxa zhinik zabinuge miñgaldiák zʉnake, auxabé miñzeshi izhoshiñga mizhogataná nzha. ");
INSERT INTO kog_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Guatshak Duwe Jesúki Kapeldahúmkaga juwí nauwisanákue izhajuizhaldegeñka na ekí shizhiyatoxá. ");
INSERT INTO kog_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ekí shi kaxaldiyaté aldukatshakna, matshuwi agapa neyatoxekuejañki ekí izhgabeyaldá: —Jejié shi zʉñkaldixáki múldigaba nukasʉ́ñ ne na guak. ¿Meja axaldukaldixa ne? ");
INSERT INTO kog_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Guatshak Duweja ekí kakldunazhé aldegatuka akualdi na ekí kaxaldék: —¿Ekí miñmeñkugé shañgá shi miñzukú? ");
INSERT INTO kog_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Guake, Jatetshi Asukuága ixagabaldeklduge mokue jékaldaxa izhonugeñkaga nitshigaté natuminák míñgaki, ¡sai jañguaminaka ne! ");
INSERT INTO kog_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Akze, Jatetshi Alduna guana auxabé miñzukui be mimezhokshaka. Ne, abuá zañki mimezhokshazháka naldashá. Akze, múldigaba nas miñmeñkugeki aldunaldi izhoxa shalda miñmeyashakú. Ai nagipana miñgualdiakna aldunaxa auxabé miñzukui mimezhokshaldixa. ");
INSERT INTO kog_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Naldatshak jiaga, anuñka minekuañki namak najañguakí naldashibiná. Guatshake akbiñgaki Duwejañki kasak zhinikga mieldekuejañki aldéñ “namak nzha” jañguazhékue akualdiñga na, meja aldéñ gexaldixa jiaga akshañga ");
INSERT INTO kog_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","noxakna ekí kakbeyá: —Akna ekí miñmeñgukú: “Ni me Najateja naxaldagakue tuñshakí naldaldiák, nepanal naxaldagazháka nakldá.” ");
INSERT INTO kog_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Guñguakna atshak zhiniki matshuwi axapa aldeyatoxekueki iyabá akuñguenikga akldé axapa aldeyaksá. ");
INSERT INTO kog_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Guakna Duweja nasʉñ 12 shi kagitixakuañ jiaga ekí zʉñnuká: —Guake, ¿maiñ jiaga nuk neyabandana miñzexaldá guxá maldúk? ");
INSERT INTO kog_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Guñguake Simóñ Péguldujañki ekí akiyó: —Nauwijí Sáñkalda, ¿mek agapa neyakualdixa nak shi amak atshakualdixa na? Akze, ma za guana múldigaba izhoshiñga zʉnezhokshaka maldazʉñmeñka naldashá. ");
INSERT INTO kog_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mañki Saldiñga netshi Jateja zʉnekualdal gaxaldixa guakldanega makaxane, ají giemiga janshizhegaba maldé zʉñkualdi na, namak majañguá guáñkalde naldashá. ");
INSERT INTO kog_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Guñguakna Duweja ekí zʉñmeyá: —Akze, naldiñki nas naldiñga 12 minekuañ mimezhgakuxanuge ne jiaga, ezuañki jiséjañga aksaneka minjiú te tuashakú. ");
INSERT INTO kog_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Guatshak Duweja ekí guagatshake Juda, Simóñ Iskaldiute tsukua shaldaga na ekí guaxá. Naldiñki eñki Duwe shi kagitixakue 12 kaldé nañga agatsé naldé, eja na Duwe gexaldixa na naldá. ");
INSERT INTO kog_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ekí Duwe Jesú atshatoguenik exa Galdildeya baxega shizhiji na mizhatoxá. Guatshake Juldeya baxeki neyasʉ́ñ na akzexá. Jinake naldakí. Exaki juldiú sanekakueja akuaxaldiamak aldiyá noxák. ");
INSERT INTO kog_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Guñgueni nauwisanákue Jeldusaldéñkagaba izhajuizhaldegéñ setábaxe xai za izhgakpa izhogakue ldiuwañ naki zeshi guatoxakna, ");
INSERT INTO kog_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Duwe aldanikueja ekí axaldék: —Jai be abá guagábaki Juldeyaxa maldeyaldí. Ekíki exa migapa nendana akzekakueja jiaga sakí jika atuazhámak agatsaldi matshixá mawatualdiamak. ");
INSERT INTO kog_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Akze, ni mielde saldiñgak awatuñshaldiamak niñkaki ziñ me egatse atshazhé naldashá. Akna matshamak nake, exa saldiñga ajuizhaldekldaldiéñ atuñsha guakue migatsaldashá. ");
INSERT INTO kog_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Guatshak jinak ekí axaldegazhá. Akaja giemikueja jiaga namak ajañguakí aldoxák. ");
INSERT INTO kog_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Guatshakna Duweja ekí kakiyó: —Kaigabeñki niuwi naxakldañkagá nogatshak, maiñki mielde niuwañ zaldaldi janshibeñga neminaka. ");
INSERT INTO kog_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Maiñki káguba sha atshixa jai kagik zhekuekuek aguldiyazháminaka. Akze, naski ekuek aguldiñkuge. Jinake naldakí. Kutám ajanashixá katuñgamak kakbeñkugé shalda. ");
INSERT INTO kog_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Akna maiñki ajuizhaldexaldieñka newiñ. Naski kaigabeñki niuwi naxakldañkagá nogák miñgapa neyazháldikue nzha. ");
INSERT INTO kog_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ekí kakbeñgueniki Galdildeyaxaga abá. ");
INSERT INTO kog_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Guane nalgué, aldanikue Jeldusaldéñ alditshiguenik aldiwan Duwe nitshí. Guñgueni exa saldiñgaja atualdiamak izhañkagába, ni mek atuñsha naldakí na izhoxá. ");
INSERT INTO kog_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Guatogatshake eñka ajuizhaldekldeñka juldiú sanekakuejañki Duwe aldiyá aldoshi ekí izhgaldukaldá: —E sigí ¿mani izhuká? ");
INSERT INTO kog_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Guatshakna exa duwá zhekualguekuejañki Duwe shalda izhgabejiñgaba na akuatoxá. Ezuakuejañki ekí akuashi: “Eñki sigí janshizhe ni tuñgukú.” Guatshak ezuakueja zʉnake ekí akuák: “Naldagálde. Eñki egaba káguba namak ne akldekshaldiamak nuxa neka nakldá.” ");
INSERT INTO kog_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ekí izhgabeyatshak jiaga, juldiú sanekakue zhe kakzukuatoguakna ni meja saldiñgaja nukaldiamake izhgabeyakí na naldá. ");
INSERT INTO kog_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Guñgueni ajuizhaldeklde ashekualdi naki muan zegatoguéñ zʉnake, Duwe Jesúki juwí Jate axazakuageñka neñguenik shizhiyaldá. ");
INSERT INTO kog_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Guatshakna juldiú sanekakueja ekí akuák: —¿Sakí shi ejiéki ni juis shitiyazhá guane jiaga ekí akualdaka na? ");
INSERT INTO kog_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Guñguake Duweja ekí kakiyó: —Akze, nas shizhikugeki nas jañguanuge naldazhé. Eñki nakaxaneja jañguanega guana guagatogashakú. ");
INSERT INTO kog_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mieldeki “Jate najañguamak atshaldikue nzha” itshanaldiakna, shizhiyatokugeki nas jañguanuge, azhi Saldiñga netshi Jatek zhinikga naklde, tualdixa. ");
INSERT INTO kog_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Akze, mieldejañki aldéñ jañguane nuxa guakáki axaldáñ za akldé zhikzukualdiamak guaka. Ekí ne, mieldejañki aldéñ gaxane za akldé akzukualdiamak zukuaká, e guana naldagálde nek náaldaki namak za zukuaka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","”Guatshak ekí miñnukaldikue: ¿Nauwibama Mueséjañga guiyaba miñkabajane naldazhé shi naldaka na? Naldatshak, ni ezuak aija guagamak atshabíne tuashakú. Akze, ¿jinak shi nakuaxa gundana miñzegatók? ");
INSERT INTO kog_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Guñguakna exa duwá zhekualguekueja ekí ayó: —E zʉnake jisétshi alduna mijuldú guanamak maldegashá. Ne, ¿me shi makuakldana akzegatók? ");
INSERT INTO kog_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Guñguake Duweja ekí kakbeyá: —Saldiñga maiñ ezua agatsalda tuabínamak atshaté natuminéñ me zhinik na “¡eñki sakí ekí kizhiksekué ldiuwañ jiaga atshaka ne!” naguanabinuka. ");
INSERT INTO kog_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Guatshak nauwibama Mueséjañga sigí sukue kukaldinik, ábiguake nauwa meñgua guakue miñmenamak miyatshixa. Naldatshak ekí miyatshixaki nauwibama Muesék zhinik nuxa nagazháne. Eñki axañga nauwibamakuexaga zhinik nagapananane naldashá. Guatshak kizhiksekué ldiuwañ jiaga nauwa meñguakue zexaldiák, amak miyatshixa naldashá. ");
INSERT INTO kog_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ekí ne, maiñ nauwibama Mueséja guiyaba miñgenamakbe miyatshaldixa miñneshi, sigí sukue amak zhiksekuakué ldiuwañ jiaga ají abuá nauwa meñgua miñguxa ne, ¿sakí shi nas zhiksekuakué ldiuwañ ezua abuá agatsauxa janshi akzukuanuge shalda nusá minaguán? ");
INSERT INTO kog_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Maiñ mituwéñ zhinik agatsegaka za tuagábaki, muldetua tuakuamak za tuakue miñgatsaldashá. ");
INSERT INTO kog_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Guñguakna exa Jeldusaldéñka zaldakuega anuñka nekuejañki ekí izhgabeyaldá: —¿Jejié akuaxaldiamak aldiyatuka naldazhé shi na? ");
INSERT INTO kog_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","E nake, uñkuái saldiñgaja atuakldegéñ duldashá te ska. Amak nogatshak ni meja sakí axaldegakí. Azhi, ¿sáñkaldakueja jiaga eñki Jateja ezua zʉnekualdal gaxaldixa guakldane, “aiga ne” ajañguá guane mi na? ");
INSERT INTO kog_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Akze, Jateja ezua zʉnekualdal gaxaldixa guakldaneki nagatshak, ni meja mani zalda aksʉ́ñ naldaldixa ne, jejiéki mashi zalda zʉñkué naldashá. ");
INSERT INTO kog_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ekí aldegatoguakna, Duwe Jesúja juwí Jate axazakuageñka shizhiyatoguéñ, saldiñgaja nukandana agatsaldi ekí guak: —Guake, me naugé, mashi zalda naugé miñkualdi nokugé nukabaldá. Naldatshak nasgaba nakldek nagazhánuge. Akze, nakaxaneki alduna ishaminaka naldatshak, “me ne” miñsʉ́ñze. ");
INSERT INTO kog_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ne, naski muldetua “me ne” nakualdi nogatuka. Jinake naldakí. Ek zhinikga naxaldatshak, e guana nakaxane nak. ");
INSERT INTO kog_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ekí neguakna sáñkaldakueja akuxaldixa ajañguatshak jiaga, ají niuwi akldañkagá noxakna amak akua kakzegazhá. ");
INSERT INTO kog_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Guatshak exa duwá zhekualdekuega matshuwi nekuejañki Duwe namak ajañgui ekí akuák: —Jateja ezua zʉnekualdal gaxaldixa guakldane naxaldini, ¿jalde sigí zhakldé “me ne” awatuñshaldiamak ajanashaté atú guazhámak atshá mi gualdí? ");
INSERT INTO kog_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ekí kágubakueja Duwe Jesú shalda akuagaté aldukañguakna, paldiseyukueja, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue na aldaldi kauwijí kabukuek Duwe kagakuxal axaxá. ");
INSERT INTO kog_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Guatshakna Duweja ekí guak: —Maiñ na anuñka me nuxa izhoxaldikueniki, jiak mokue nakaxanekga axaldeyaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Neyaldikueni minaldiyatshak jiaga miñzaldazháldikue. Akze, nas izhoxaldikueñkaki maiñ neyazháminaka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Guñguakna juldiú sanekakuegaba ataba atabañ ekí izhgabeyaldá: —Ne, jejié ¿mani mi nasʉñ zʉñzaldazhákldegaldi neyaldí? Azhi nauwisaná anuñkakueki san san kagildi ishkajiunekue ashekualdi, ¿eñka nauwisaná naldagáldekue juizhi shaxaldiyal mi neyaldí? ");
INSERT INTO kog_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Sakí guashi mi “minaldiyatshak jiaga miñzaldazháldikue nakldá. Nas izhoxaldikueñkaki maiñ neyazháminaka nakldá” guaká? ");
INSERT INTO kog_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Guñguenik amak ajuizhaldeshi sʉxake akldé akzé ldiuwañ azaxaitshatoguéñ, Duwe Jesú izhgaldagueni saldiñgaja nukaldiamak ekí guak: —Mieldeke ni miñnuna guake tuxal náxaldak guwíñ. ");
INSERT INTO kog_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mieldeke namak najañgui minazipanaldiák, aike Jatetshi múldigabak sezhekldamakga mimijí aldunaldi nina jana auxabé miñzukui mimezhokshi nañkaji zabal za noxaldixa. ");
INSERT INTO kog_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ekí guagatshake aldéñ ipanañkaldekuañ Jatetshi Alduna ipanakualdixa nalgué shalda na ekí guaxá. Guatshak atshagaki Jatetshi Alduna zʉñgatsabagáñga te na noxá. Jinake naldakí. Duwe akldé akzamakga agazukuagá noxák. ");
INSERT INTO kog_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Guatshak anuñkakueja ekí Duweja guagaté aldukatshakna ekí akuaxaldá: —Eñki Jatetshi múldigaba naldiñga zʉxaitshixa ezua naxaldixa, aiga nzha. ");
INSERT INTO kog_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ekíga na ezuakuejañki: —Eñki Jateja ezua zʉnekualdal gaxaldixa guakldanega nzha. Guatshak ezuakueja zʉnake ekí akuák: —Naldagálde. Jateja zʉnekualdal gaxaldixa guakldanega ejié jana Galdildeyaxa zalda nuxa naldazháka naldashá. ");
INSERT INTO kog_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Akze, Jatetshi múldigabake ¿ekí sezheklde miñsʉ́ñ shi na? Ezua zʉnekualdal gaxaldixa guakldaneki sáñkalda Dabí shtukuaga, etshi kuíbuldu naneñga Beldéñ zalda naldaldixa guaka naldashá. ");
INSERT INTO kog_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Guakna exa zhekualdekueki Duwe shalda nuxa zhuajanañgaba ajañguazháldi, sha sha na ajañguapaná. ");
INSERT INTO kog_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Guatshakna ezuakuejañki guiyaba atuñshaldiamak gugakue ajañguatshak jiaga, ni meja amak guazhá. ");
INSERT INTO kog_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Guatshake kabukueki Duwe Jesú guxal axaxane nalguekue mokue paldiseyukue, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue ashekualdeñka aldeyatshak, ekí agalduká: —Naldé, ¿jinake uldagazhá miñgué? ");
INSERT INTO kog_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Guñguake ekí kakiyó: —Akze, ni me ejié sigí janshagatsaldi zukuagamake zukuagazhé nzhaldá. ");
INSERT INTO kog_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Guñguake paldiseyukueja ekí kaxaldék: —¿Maiñ jiaga naldagálde nuxa namak miñnekshá guxá maldúk? ");
INSERT INTO kog_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Azhi sáñkaldakuek jiaga ezuake “e namak nzha” jañguá neká maldúk? Azhi ¿ezua paldiseyukuañ shi ekí kajañgú? ");
INSERT INTO kog_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Káguba e namak ajañguxakueki guiyaba zʉñkabajane aksékue nuxa nakna, ¡kagisá nonakue nzha! ");
INSERT INTO kog_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ekí akuagatshakna ezua paldiseyuga Nikudemuki atséñ zalguéñ Duwe Jesú tual nenaneja ekí guak: ");
INSERT INTO kog_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Guatshak ¿nauwijí guiyabajañki ezua sakí atshane axaxak naldi guagaté nukagáñga jiaga, guiyaba tuakue agatsaldi ne axezhagakue guaka naldé? ");
INSERT INTO kog_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Guake ekí axaldék: —Naldéki, ¿ma jiaga Galdildeyaxa zaldaga maldaldé? Jatetshi múldigaba sezhekldek muldetua niya tu makualdí. Makuatshak Galdildeya zaldaga nuxa, ezua Jatetshi múldigaba naldiñga zʉxaitshixa naká tuabaldáldixa nakldá.  ");
INSERT INTO kog_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Guñgueniki ezua ezua kauwijuldiñgaba nuk aldé na akuá. ");
INSERT INTO kog_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Guatshake Duwe Jesúki gaxa akshá zeñka Oldibuxa neñguenik, ");
INSERT INTO kog_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","abokualdik muñshake mokue juwí Jate axazakuagéñ nak. Guñguake káguba exa ashekualdauxa iyajuizhaldegatshak, yaldagueniki shi kaxaldiyaldá. ");
INSERT INTO kog_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Guatogueñki guiyaba shizhixakue, paldiseyukue na aldaldi ezua munzhi asewá naldagálde na gekualgueñga akuxane akualdagueni, saldiñga kenañ agaldagueniki ");
INSERT INTO kog_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ekí Duwek agabeyá: —Shi maldazʉñkaldixa, jalde munzhiki asewá naldagálde na gekualdeñga guxáñkalde nzha. ");
INSERT INTO kog_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Akze, nauwibama Mueséja guiyaba zʉñkabajanejañki munzhi egatshixakueki jagi ibushi guagakue guaka ne, mañki ¿sakí guakue guakbildaka sha? ");
INSERT INTO kog_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Guatshak ekí agazaldukatshake akuajaldiamak nuxa na ekí axaldegatoxá. Ekíki sakígaba yokualdiake, ai zhinik agatsé ne axeyaldaxaldiamak. Guatshak Duweki egaba jie atshiñgueniki káuxaldak kagi akzuñgualdá. ");
INSERT INTO kog_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ekí atshatogatshak agazaldukajiñgaba guñguák zʉnake jian agaldagueni ekí kakbeyá: —Ake, mieldeke sha atshabíne nake, aik mishañga jagi ibugwíñ. ");
INSERT INTO kog_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kakbeñgueniki mokue jie atshiñgueni káuxaldak kagi akzuñgualga te na noxá. ");
INSERT INTO kog_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ekí kakbeyaté aldukatshak niñkauwañki amak atshagába, kauwijí aldunajañga “nagatsaldi ne shakldá” kakldekshatshakna duebakue mishañga ezua ezua ai zhinik aldejiñga, munzhi za na agaldashi aldeyatshake, Duwe za abá. ");
INSERT INTO kog_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Guñguake Duwe jie nogué jian agaldaguenik ekí munzhik akbeyá: —Nabunzhi, ¿sakí shi ajanashá? ¿Ni me migatsé makuashi guiyaba matuñshazhá shi akú? ");
INSERT INTO kog_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Guñguake munzhija akiyó: —Duwe, ni me ekí nakuazhá na gu. Guñguake Duweja ekí akbeyá: —Ak zʉnake, nas jiaga, sha atshamalde migatsaldalga nuká axamizhagazháldikue. Akna neyabikuká ni gu. Akldé sha atshalga noxabaldáldi. ");
INSERT INTO kog_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Guñgueni Duwe Jesúja kágubakue ekí mokue kakbeyaldá: —Nas na muñshí zalda kagik mizhekuauxa muñshí minzukualdikue naugé. Akna mieldeke nepanamine nagapa mineñkake, akldé tuañ zaldi neyabináldixa. Nas auxabé muñshí minzukuapananuge mimezhokshaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ekí aldukatshakna paldiseyukueja ekí axaldék: —Ekí makuagatshak, ma axaldáñgaba ekí akuagashibaldá. Akna ¿sakí shi ai makuaká akzé naldaka na? ");
INSERT INTO kog_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Guatshak jiaga Duweja ekí kakiyó: —Akze, amak nas za akuakugák jiaga akzega naldaldixa nakldá. Jinake naldakí. Naski mani zhinik naklduge, mashi neyaldikue jiaga zhikualdi nogatokugák. Ne, maiñki mani zhinik naklduge, ni mashi neyaldikue miñsʉ́ñze. ");
INSERT INTO kog_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Akze, maiñki ezua agatsé azhi agatsaldakí ne kágubak mituwamak nuxa mituñka. Ne naski ni ezua agatsé azhi agatsaldakí ne tuakí nzhokú. ");
INSERT INTO kog_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Naldatshak amak tualdikuake, naski agatsahauxabe tualdikue. Jinake naldakí. Nahezua tuagábaki Najate nakaxane na ekí tuñge nak. ");
INSERT INTO kog_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Akze, mimijí guiyaba sezheklde miñkabajanejañki ekí guaka: Mozhua nekueja zhualduxañga atunamakgaba akuagatshakna akzé naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ekí nak, ezua tunamak ne guakaki, nas axaldáñga naugé. Mozhuane tunamak ne guakaki Najate nakaxanega nakldá. ");
INSERT INTO kog_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Guake ekí agalduká: —Guake, mijateki, ¿mani shi izhók? Guake Duweja kakiyó: —Maiñ me naugé miñkualdi nokuge guashiñki, Najate jiaga me ne miñkualdaka. Ne nas me naugé miñsʉ́ñ, ni Najate jiaga miñsʉ́ñ naldashá. ");
INSERT INTO kog_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Guatshak Duweja ekí guagatogatshake, juwí Jate axazakuageñka Jatek agaxexaldiamak akuashixa tezhak na ekí shizhiyatoxá. Guatshak jiaga, ají niuwi axakldañkagá noxakna, ni meja guxa akzegazhá. ");
INSERT INTO kog_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Guñguenik Duwe Jesúja mokue ekí kakbeyá: —Naski neyaldikue. Gualdini minaldiyatshak, miñzaldagáñga sha atshamine miñkabetazhánega mishuixaldixa. Nas nenaldikueñka maiñga neyazháminaka nakldá. ");
INSERT INTO kog_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Guakna juldiú sanekakuegaba ekí izhgabeyaldá: —Ne, ¿axaldáñ akuaxaldixa akldegák shi “nas nenaldikueñka maiñ neyazháminaka nakldá” guak? ");
INSERT INTO kog_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Guatshakna Duweja ekí kakbeyá: —Maiñki jai kagik sha ajanashéñ zalda nuxa miné. Akze, naski jai kagik zalda naldazhúge, jékaldaxa zalda nakldakú. ");
INSERT INTO kog_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Akna sha atshamine miñkabetazhánega mishuixaldixa miñmenuge. Akze, naski naldiñga naugé namak najañguakí minaldaldiák, sha atshamine miñkabetazhánega mishuixaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Guñguakna ekí axaldék: —Guake, mañki ¿me maldé maldúk? Guatshakna Duweja ekí kaxaldék: —Ak zʉnake, ¿ji shi maiñ na zhikbeyaldikue na? ");
INSERT INTO kog_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Akze, guaxaldañga gugák, matshuwi maiñ shalda guakldaka, miñgatsaldi ne mimatunaka. Naldatshak nas nakaxane namaklde za guakaja guagaté nukaugamak za káguba kagik mizhekuauxak miñmeji izhokuge. ");
INSERT INTO kog_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Guatshak jiaga, “Saldiñga netshi Jate shaldaga sha ekí zʉñmeyatók” kagajienazhá. ");
INSERT INTO kog_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Guakna Duweja ekí kakbeyá: —Jatetshi Asukuága ixagabaldekldugek nawatualdieñka kaldixa naxaldiya minakuatshak zhinik na, naski naldiñga naugé miñwashexaldixa. Ekí miñwashegatshakna, nas axaldáñgabaga ni ji atshagába, Najateja natuñshanamak za guaklduge miñwashexaldixa. ");
INSERT INTO kog_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Akze, Najate nakaxaneki nas nañga na izhók. Aldéñ akldunamak za axatshikuge nak, nahezua nabaja guazhé nakldá. ");
INSERT INTO kog_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ekí shizhiyatogatshakna matshuwi aldukatoxekueja namak ajañgui alduna iyashá. ");
INSERT INTO kog_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Guakna Duwe Jesúja juldiúkue aldéñ namak jañguanekuek ekí kakbeyá: —Mieldekuañki nají múldigaba nagipani amak naxatshál za minoxaldiake, namak giemi shi nagitiji nagapa mineñkakue minaldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Atshakna namaklde miñwashexaldixa. Ekí miñwashegatshak, namakldega na mimebesanshi, ezuatshi nashi za mimezhokshaksánshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Guakna ekí akiyayó: —Nasʉñki Abaldahám shtukuaga naldashiñkaldá. Ni mitsák ezuatshi nashi izho guañkáalde. Ne, ¿sakí shi zʉnebesanshaldixa zʉñmemildaka na? ");
INSERT INTO kog_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Guake Duweja ekí kakiyó: —Namakgaba miñmeyaldikue: Mieldeki sha atshál izhukaki sha atshátshi nashi nuxa ne nakldá. ");
INSERT INTO kog_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Gueni ekí kakbeyá: —Akze, ezua nashi sáñkalda akizhukaki e tshuk zalda naldiñga naldazhé naldashá. Sáñkalda tsukua zʉnake eñ zalda nak, eñga za izhogataná. ");
INSERT INTO kog_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Akna nas Saldiñga netshi Jate Tsukuak ezuatshi nashi naldak mimebesanshaldatshak, namak giemi minabesane minaldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","”Nas nakueki maiñki Abaldahám shtukuakuega miné. Minaldatshak jiaga, nas múldigaba miñmeñkugé nagipanasʉ́ñ miñzeshi na, nakuakldana miñzegashá. ");
INSERT INTO kog_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Akze, Najate ldesañ izhoshi tuwi nagatokugamak za miñmeñkuge. Ekíga na, maiñ zʉnake mimijateja miñmeyaté minukajamak za miyatshixa nibiná. ");
INSERT INTO kog_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Guatshakna ekí akiyayó: —Nauwijateki Abaldahám guana naldashá. Guake Duweja kakiyó: —Abaldahám tsukuakue giemi namimakuashíñki, e atshanamakgaba atshatabinaldé. ");
INSERT INTO kog_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ekí ne, naldiñki nas Saldiñga netshi Jateja namaklde nakbeyaté nukanugamak miñmeyaldatshak jiaga, nakuaxa gundana miñzegashá. Abaldahámga ekí agatsaldi atshazhé nane naldashá. ");
INSERT INTO kog_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Akze, maiñki ezua mimijate atshamak za miyatshixa nakldá. Guakna ekí axaldék: —Nasʉñga nuxa zʉnawatushek me kukáñkalde naldañkáalde ni naldatók. Jate ezua me zʉñkué, eñki Saldiñga netshi Jatega nakldá. ");
INSERT INTO kog_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Guakna Duweja ekí kakiyó: —Tukí Saldiñga netshi Jatega Jate miñkizhuka naldiñguashíñki, nezhgajañgui guatabinaldé. Jinake naldakí. Naski kagik naxaldatshak ek zhinikga naklduge, ni nasgaba nagazhánuge, ega nakaxane nak. ");
INSERT INTO kog_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Guatshak jinak nas miñmeñkugé miñgajienakí naldaka naldakí. Nají múldigaba naxaldukasʉ́ñ miñzeka nak. ");
INSERT INTO kog_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Akze, maiñki jisé guana jate miñkizhuka. Nahamakga guana aldéñ akldunamak za atshindana miñzegashá. Ejiéki kasaxa zhinikga káguba guaxa atshalga za izhoshi nagatuka. Eñki naldagálde zukuaka naldi na, naldagálde zukuaxa tshate, namaklde atshá ni nauwa axaldaldazhé. Nakna naldagálde za zukuagatshak, eñki ekí nahamakga ne nahák ekí zukuaka. ");
INSERT INTO kog_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Akna naski namaklde guaxaldatshak, “namak sha guak” najañguakí naldashibiná. ");
INSERT INTO kog_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Azhi ¿mieldeke sha atshuge nagatsé ne naxaldék guaminaka sha? Akze, namaklde za guaxaldatshak, ¿jinak shi “namak sha guak” najañguakí miná? ");
INSERT INTO kog_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Guatshak mieldeki Jatetshi ne naldaldiake, ají múldigaba axaldukal za noxaldixa. Ne, maiñki Jatetshi naldabíne nakna, aldéñ guaká axaldukakí naldashibiná. ");
INSERT INTO kog_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ekí kakbeyatshakna ekí akiyayó: —Akze, kabakuagamakga Samaldiaxágabe maldé, jisétshi alduna mijuldune tubaldá. ");
INSERT INTO kog_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Guakna Duweja ekí kakiyó: —Nasga jisétshi alduna nejuldune naldazhúge. Akze, naski Najate akzé jañgui axabeti izhokuge. Ne, maiñ niñkauwañki aguáñ nezhbashi mual guashibiná. ");
INSERT INTO kog_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Guatshak nasga nuxaga sakíki akldé nagazukualdiamak niji izhogazhúge. Ezuaja guana ekí nagazukualdiamak niji izhuka, ejañga na ai tuwa niuwi aksuikue. ");
INSERT INTO kog_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Namakgaba miñmeyaldikue: Mieldeke shi miñkaldiyanugamak naxatshál minukakuañki ni mitsák shuizha guabináta nzha. ");
INSERT INTO kog_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Guñguakna ekí akiyayó: —Kaiga míñgaki namak giemi jisétshi alduna mijuldunanamakga matú ni gakú. Akze, nauwibama Abaldahámki shuizhá guanane, ekibeñga na Jatetshi múldigaba naldiñga zʉxaitshixakue ekígaba ashuanane naldashá. Ne mañki ekí na makuák: “Mieldeke shi miñkaldiyanugamak naxatshál minukakuañki ni mitsák shuizha guabináta nzha.” ");
INSERT INTO kog_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Azhi ¿mañki nauwibama Abaldahám zhakaldak mikzé maldé shi mikldék? Eñki shua guanane, ekibeñga na Jatetshi múldigaba naldiñga zʉxaitshixakue ashuá guanane ne, ¿mañki me maldé mitshanká? ");
INSERT INTO kog_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Guakna Duweja ekí kakiyó: —Nasgaba akldé zhikzukualda guanugák, naxakzaldagáldega naldaka. Naldatshak Najatega na akldé nakzukual izhuka, ega na maiñ jiaga Jate akaldak miyakzukuxa miñguaka. ");
INSERT INTO kog_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ekí miñguagatshak jiaga “me nzha” miñsʉ́ñze. Naldatshak nas zʉnake “me ne” muldetua nakué nak, “naksʉ́ñze nzha” guaxaldikuák guashiñki, maiñ janañga naldagálde zukuakuge naldanaka. Naldatshak, nas zʉnake muldetua “me ne” nakualdi, aldéñ nakbeyamak axatshál za izhogatokuge. ");
INSERT INTO kog_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Akze, mimibama Abaldahám zʉnake zeñ akldeshi, nas naxaldikue ldiuwañ zegakue jañguiñgaba izhoguakna, amak nagaté natuatshak zeñ akldeklde. ");
INSERT INTO kog_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Guñguakna ekí axaldék: —50 kagi mitsegagá nuka jiaga, ¿sakí shi nauwibama Abaldahám tumalde guakbildaka na? ");
INSERT INTO kog_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Guñguakna Duweja ekí kakbeyá: —Namakgaba miñmeyaldikue: Abaldahám kukagá nogueñga naski naldiñga nanugega nakldakú. ");
INSERT INTO kog_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ekí negatshakna jagi iyabushi akuaxaldiamak izhgasuí. Guatshake Duweki kagitshuaniñga juwí Jate axazakuagéñ zhinik akzʉxaití ne na gua. ");
INSERT INTO kog_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Guñgueni Duwe Jesú neyatogueñki ezua sigí uba iséga kukanane tu. ");
INSERT INTO kog_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Guñguake nasʉñ shi kagitixakuañ ekí akldukáñkalde: —Shi maldazʉñkaldixa, uñkuejié sigí uba isé naldaldixaki ¿me sha atshane nak ekíga agatsé kukane naldaka ne? ¿Sigí aldéñ, azhi ajatekue? ");
INSERT INTO kog_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Guñguake ekí zʉñkiyó: —Ega nuxa aldéñ, azhi ajatekue sha atshane nak naldakí. Eñki Jateja ají kamak sakí axatshaka awatuñshaldiamak nuxa ekí kukane. ");
INSERT INTO kog_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nasʉñki muñshí zeñga na Najate nakaxanetshi jiba axatshalga nogakue zʉñgatsé. Akze, gualdinik tuañ zek guatshak zʉnake, ni me jibatshazháka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Guatshak kagik izhoxalga nokugeñgaki, nas na muñshí zalda naugakna kagik mizhekuekue muldetua muñshí minzukuge nakldakú. ");
INSERT INTO kog_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ekí zʉñmeñgueniki kagik tup atshiñguenik kaxaldiá na tiuwi gauñgueni, uba isé ubak ibegueniki ");
INSERT INTO kog_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ekí akbeyá: —Ni asuñguane akué nogeñka Silduéxa itshizhate guwá. Guatshak Sildué guagatshake “axaxane” guashi. Guñguake amak itshizhateñgueni, nagatshake uba ikuká guane nak. ");
INSERT INTO kog_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Guñguakna eñgui akyó izhukakueja, zʉshishá za nuka atunekueja jiaga ekí izhgaldukaldá: —¡Eñki ité, zʉshishá za nuka naldazhé shi na! ");
INSERT INTO kog_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Guñguake ezuakuejañki ekí guak: —Eñki aiga nakldá. Guatshak ezuakuejañki ekí guak: —E naldagálde, egabá e janá nuxa agatsé nakldá. Guñguakna aldéñ naldi ekí guak: —Nas ai na nakú. ");
INSERT INTO kog_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Guñguakna ekí agalduká: —Ai maldamak nake, ¿sakí zhinik shi kaigaki zʉtumildaka na? ");
INSERT INTO kog_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Guñguake kakiyó: —Ezua sigí Jesú axezhukaja tiuwi gauwa, ubak nazibegueniki ekí nakbeyá: “Silduéxa itshizhate guwá.” Nakbeñguake amak eñka itshizhaldatshake ¡zʉtualdá guanuge! ");
INSERT INTO kog_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Guñguakna ekí agalduká: —Gueni eñki ¿shegu? Guñguake: —Naksʉ́ñ nzha. ");
INSERT INTO kog_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Guñgueni paldiseyukue nugeñka sigí uba isé nane awaldé. ");
INSERT INTO kog_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Guatshak Duweja amak tiuwi gauwa, sigík ibegatshak uba ikuksha guatogatshake kizhiksekué ldiuwañ zane. ");
INSERT INTO kog_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nalguakna paldiseyukueja jiaga sakí zhinik zʉtuapanane ne agaldukañguake ekí kakbeyá: —Tiuwi ubak nazibeguake, itshizha me gualdatshake stualdá guanuge nakldá. ");
INSERT INTO kog_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Guñguake paldiseyukuega, ezuakuejañki ekí akuák: —E sigí ekí atshanega Jatek zhinik naklde naldazháka nukshí. Jinake naldakí. Guiyabaja zhiksekuakue ldiuwañ guagamak atshazhá guane nak. Guatshak jiak ezua aikuejañga zʉnake ekí akuák: —Naldatshak ¿sakí shi ezua sigí sha atshixa jiaga Jatetshi kamak atshixá jana ekí ajanashaté atú guazhámak janshizhe atshaka na? Ekí zhualduxañgaba ajañguakí naldi na, ");
INSERT INTO kog_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","uba isé nanek mokue ekí agazalduká: —Akze, ma uba mikukshane, e shalda ¿sai guakbildaka ne? Guake kakiyó: —Ake, naski “Jatetshi múldigaba naldiñga zʉxaitshixa nzha” guakldaka. ");
INSERT INTO kog_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Guatshak juldiú sanekakuejañki “stuagálde nane stuamak nzha” ajañguazhá guñguakna, etshi ajatekue iyaxauldá. ");
INSERT INTO kog_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Amak aldagatshak ekí kagazalduká: —Jai zʉñkualdakldeki ¿mimijí sukua giemi ne guakbinaka sha? Ai nake, ¿“uba isé kukanamak nzha” guakbinaka sha? Ne jiak, ¿sakí zhinik shi kaigaki zʉtuaka na? ");
INSERT INTO kog_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Guñguake ajatekueja ekí kakiyó: —Eñki nauwijí sukua nakldá. Uba iséga kukanane zʉñkué. ");
INSERT INTO kog_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ekí naldatshak, “sakíga ni kaigaki zʉtuapanane nzha” zʉnake zʉñsʉ́ñ, ni meja uba ikukshane nasʉñga zʉñsʉ́ñ nzha. Akna aldéñ aklduka miñgunék. Atemaldék guane naldaldiniñki aldéñ zhikzukuaxaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jinake anuñké ajatekueja guagazhá. Juldiú sanekakueja zhe kakzukuatoguák. Akbiñgaki izhgakualdi ekí akuaklde nalguák: Mieldejañki “Jesúki Jateja zʉnekualdal gaxaldixa guakldanega nakldá” guak gualdiake, eñki nauwisaná na juizhaldexa akibená gualdixa. ");
INSERT INTO kog_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ekí zhinik na ajatekueja ekí nuxa akuaklde: “Atemaldék guane naldaldiniñki aldéñ na akzʉzukakue miñgatsaldaldixa.” ");
INSERT INTO kog_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Guñguakna uba isé nane mutshuane iyaldañgashiñgueni ekí axaldék: —Saldiñga netshi Jate matuaté nogéñ namak axazʉñgilte guwá. Akze, nasʉñ zʉñkueki ejié uba mikukshane makuakáki sha atshixa nuxa ne. ");
INSERT INTO kog_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Guakna ekí kakiyó: —Nasga sha atshixa nak jiaga ekígaki naksʉ́ñ nzha. Ezuañgaba nakué: Zʉtuazhúge nanuge ne, kaigaki uba nekuká guane. ");
INSERT INTO kog_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Guakna mokue agazalduká: —Nalgué, ¿sakí makuñgué? ¿Sakí agatsaldi uba mikukshaldiamake makuñgué? ");
INSERT INTO kog_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Guakna ekí kakiyó: —Au miñmeyakuauxa miñmeyá gualdatshak jiaga, naxaldukakí naldashibiná. Ne, ¿jinak shi mokue aiga aiga nukandana miñzék? Azhi ¿maiñ jiaga shagitiji agapa mineñkakue nekldana miñzeshi shi gu? ");
INSERT INTO kog_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Guatshakna nusagatsaldi ekí axaldexaldá: —Ma na aik shagitiji agapa maldeñka naldabaldogake, ai naldabaldukaga. Akze, nasʉñki nauwibama Muesék guana shi kagitixa ni maldazʉnatú. ");
INSERT INTO kog_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nauwibama Mueséki Jateja axazguakldane zʉñkué. Ne ejié makuakáki “ni mani zalda nzha” zʉñsʉ́ñ ni naldatók. ");
INSERT INTO kog_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Guake ekí kakiyó: —¡Sakí shi ekí minék! Maiñki ejié mani zalda miñsʉ́ñ ne jiaga, naski ega uba nekukshane tuashakú. ");
INSERT INTO kog_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Akze, ekí zʉñkualdaka: Saldiñga netshi Jatega ezua sha atshixaja agakuañneklde nukazhé. Akze, ezuañgabaki aldéñ akldé akzamakga akzukual, jañguamak axatshál izhukaja za na agakuañnegamak nukaxa. ");
INSERT INTO kog_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ni mitsák zalgueñki “ezuaja uba isé kukane nalgué uba ikuksha ni guaná” nukañkáalde. ");
INSERT INTO kog_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Akna ekí naxatshaneki Jatek zhinikga nagazháne guashiñga, ni ji jiaga atsha akzegazháka naldashá. ");
INSERT INTO kog_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Guñguakna ekí axaldék: —¡Ma shanekga sezhek guamalde kukamalde naldabaldukak shi nasʉñ shi maldazʉñkaldiyaldixa mitshán! Ekí axaldegueniki ai zhinik agazaxaitshá. ");
INSERT INTO kog_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Guñgueni Duwe Jesúja ekí agazaxaitshane nukañgueni akzaldatshak ekí aklduká: —¿Ma Jatetshi Asukuága ixagabaldeklde “namak shakldá” jañguá shi makú? ");
INSERT INTO kog_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Guñguake ekí akiyó: —Duwe, eñki mielde nake nakbeya guwá, ekíki namak jañgualdikuamak. ");
INSERT INTO kog_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Guñguake Duweja akiyó: —E naldiñga tu guashibaldá. Aik guana dulda mikshatogashakú. ");
INSERT INTO kog_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Guñguake akldé akzamakga akzukualdiamak asták nuldu axayoshi ekí akbeyá: —Nají Sáñkalda, “namak nzha” ni majañgukú. ");
INSERT INTO kog_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ekí zegueni Duweja ekí guak: —Naski mieldeki agatsé, mieldeki agatsaldakí ne muetsekui kezhgajuekual kagik naklduge. Ekíki uba isé jana nekueki stuapanaldiamak, guatshake jiak uba ikué itshankakue niñkauwañki uba isananekue jana aldaldaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Guñguake exa anuñka paldiseyukue ekí aldukatoguekueja ekí agalduká: —Guake, ¿nasʉñ jiaga uba zʉnsʉ́ñzekue janañga kaldé zʉñmeji nukabaldá? ");
INSERT INTO kog_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Guñguake Duweja kakiyó: —Uba minsʉ́ñze itshanamimakuashíñki sha miyatshixa miñkabetaka. Ne, “auxaga zʉtuashiñkaldá” minegakna sha atshamine miñgatsaldi za minaldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Guñgueniki Duwe Jesúja ezua ajanashakldegéñ zhinik ekí shi kaxaldiyaldá: “Namakgaba miñmeyaldikue: Mieldeki jubejutshi kuldaldu abezhguane juldunéñ ga juldunagábaki, awaxani ga iyabexa juldunaldiake, eñki tusheka, shane naldashá. ");
INSERT INTO kog_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Akze, juldunéñ ga juldunka zʉnake jubeju numañ tuñka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","E na juldunéñ numañ tuñkaja juldukshaldixa. Juldunatshak jubejukueja ají múldigabaki axaldukaldixa. Gualdinik ajíkueki ezua ezua axezhogamak kexauldi, kakzʉxaitshaldixa. ");
INSERT INTO kog_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ajíkuegaba nuk kakzʉxaitshaldinik aldéñki aksaja neyatshak, ají jubejukuejañki agapa za aldeyaldixa. Jinake naldakí. Ají múldigabaki kakué nak. ");
INSERT INTO kog_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Akze, atuazhé zʉnake ni mitsák axapa aldeyazháldixa. Etshi múldigabaki aldukazhé nak, nuk iyaldakuixaldixa naldashá.” ");
INSERT INTO kog_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Duweja ekí izhguaji shi kaxaldiyatshak, aldukatoguekuejañki sakí guashi kakbeyatuka kagajienakí na naldá. ");
INSERT INTO kog_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Guakna Duweja mokue ekí kakbeyaldá: “Namakgaba miñmeyaldikue: Nasga na jubeju axasheñgualdi julduneñga naugé nakldakú. ");
INSERT INTO kog_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Saldiñga nazhaxañga juldunéñ ga ajuldunagába nakldekueki tusheka, shanekue nuxa nanekue. Akna kauwijí múldigabaki jubejukueja kaxaldukazhá guanane. ");
INSERT INTO kog_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Akze, nas na julduneñga naugé. Mieldeki nas ga juldunaldiake, eñki ikuanuge naldaldixa. Gualdini jubeju juldu, jiak zal akzʉxaitatshak galdixa auxaga akzaldamakbe, nas zhinikga akzaldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Guatshak tushekaki jinak naka naldakí. Eñki ezuañgaba tushexal, egatse agisalshal, zukuaxa atshál nuxa naka naldashá. Ne nas zʉnake aldunaxa ni ji jue naldakí muldetua zʉxaita zalda, auxabé miñzukui mimezhokshaldikuamak naklduge nakldá. ");
INSERT INTO kog_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","”Akze, nas na jubeju numañ tuñkuge janshizhe na nakú. Jubeju numañ tuñka janshizheja na ají jubejukue tsaldi shuixaldiamak jiaga aké zalda atshixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ekí ne, mieldeki egabá kasa izhgauwaldiamak nuxa jubeju tuatoxaldiák zʉnake, nabi nagaté tualdiake, jubeju numañ tuwa ají jiba naldazhé, ni jubejukue ají naldazhé nak, aikue za zheñgui nakuixaldixa. Ekí neyatshake nabija jubeju aksui gugatshake, azhiniki ezua ezua nuk neñshaldixa. ");
INSERT INTO kog_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jinak sigí anuñké nakuigakí. Axasabiyaldixa shalda za atshatogák, abualga ni jubeju akzé tuazhé nak. ");
INSERT INTO kog_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","”Nas na jubeju numañ tuñkuge janshizhe na nakú. Nají jubejukueki muldetua nakualdi, jiak kauwizhéñ zhinik ekíga kakualdi nokuge. ");
INSERT INTO kog_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Akze, Najate muldetua nakualdi, jiak aldéñ zhinik muldetua akualdi nokugamakbeñga na, nají jubejukue na ekí kizhuka. Akna ekue tsaldi shuixaldikuamak nasgaba aké zalda atshikuge. ");
INSERT INTO kog_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Guatshak nají jubejukue awagaxa jiaga naxaldañga. Ekueki jai naxagatshekuéñ zalda naldagálde nak, uldagakue nagatsaldaldixa. Ekueja jiaga nají múldigaba nukshi nagapa aldeyapanatshak, ekue juizhi askuiñgaba juizhakualdikueni, ezuañgaba nas za numañ tuwi izhoxaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","”Akze, nasgaba shuixaldikuamak aké gualdikuenik jiak mokue be izhoxa izhgakuxa atshikuge, nakna Najateki nezhgajañguxa. ");
INSERT INTO kog_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni meja shuixaldikuamak alduna nazikuxa akzegazháka. Ne, nas nakldeshi na aké guge. Ekí nasgaba shuixaldikuamak aké gualdikuenik jiak mokue be izhoxa izhgakuxa atshá niuwi naksuikue. Ekí atsha guakue Najateja nakbene nakldá.” ");
INSERT INTO kog_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ekí kakbeyatoguakna juldiú sanekakueki mokue zhualduxañgaba ajañguakí aldoshi na, ");
INSERT INTO kog_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","matshuwi nekuejañki ekí akuák: —¿Jinak ejié nukalga minuká? Jisétshi alduna ijuldune, “sakíga ni negatokú” akldegagálde ¿tuakí shi miná? ");
INSERT INTO kog_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Guakna ezuakueja zʉnake ekí akuák: —Guatshak múldigaba ekí guakága, ezua jisétshi alduna ijulduneja ekíki guagazháka naldashá. Azhi ¿mi zalgueñki ezua jisétshi aldunaja uba isé uba ikuksha shi guaté tuminá? ");
INSERT INTO kog_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Guñguenik Jeldusaldéñka níxalda bual zegatogueñki nauwisanákue kishjuizhaldegéñ zeklde na noxá. Ai ldiuwañki juwí Jate axazakuaká “ají za naldaldixa nzha” akuashi ajuizhaldegéñ. ");
INSERT INTO kog_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Atshake Duwe Jesúki juwí Jate axazakuakakga jueyáñ zalda atema akldikualdi Saldamóñ axezhogaldi mizhá noxeñki, ");
INSERT INTO kog_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","juldiú sanekakueja iyabateguenik ekí axaldexaldá: —¿Mitsák ekí mozhua mozhua zʉñnekshal za maldoxaldixa ne? Azhi Jateja ezua zʉnekualdal gaxaldixa guakldanega maldák míñgaki, abexa náaldaki zʉñmeya nuxa guatogwá. ");
INSERT INTO kog_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Guake Duweja kakiyó: —Au miñmeyá guanuge naldatshak jiaga, namak najañguabíne. Ekíga, nas jika atemajañ atshikugeki Najateja niuwi nagenamak atshaldatshak, aija guana muldetua me naugé nawatuñshixa. ");
INSERT INTO kog_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Naldatshak jiaga namak najañguakí naldashibiná. Jinake naldakí. Miñmenugamakga nají jubeju naldabínekue nak. ");
INSERT INTO kog_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Akze, nají jubejukuejañki nají múldigaba nukaxa, nakualdi nukakue nahák, naxapa za aldeñka. ");
INSERT INTO kog_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nasga aldunaxa auxabé kakzukui izhoshiñga kezhokshikuge nak, ni mitsák guiyaba tu za nogakueñka aldeyazhítakue. Aikueki naksuí nukakue nakna ni meja nazikuxa guazhíta niyó. ");
INSERT INTO kog_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ekíga na, najíkue naldaldixa nagene Najateki saldiñga zhakaldak akzé izhogakna, ni meja aikueki ají káuxaldak zhinik ikuxa akzek guazhíta. ");
INSERT INTO kog_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Akze, nas Najate nañki askimimé kaldé nakldá. ");
INSERT INTO kog_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ekí kakiyokuñguakna jagi iyabushi akuaxaldiamak mokue izhgasuí. ");
INSERT INTO kog_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Guakna Duweja: —Maiñki Najatetshi kamakga matshuwi janshizhegaba atshaté natumine. Ne ¿mielde shalda shi jagi nazibushi miñnék? ");
INSERT INTO kog_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Guake ekí akiyayó: —Janshizhe atshamalde shaldaga jagi mibuxañkaldáaldixa. Jate aguáñ izhbashi mual zukuakbalde shalda guana jagi mibugakualdixa. Akze, mañki kágubaga maldé jiaga, Saldiñga netshi Jatega maldé axamildagéñ zhinik guana ekí makuakualdixa. ");
INSERT INTO kog_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Guñguake Duweja kakiyó: —Akze, ekí mimijí guiyabak Jatejañga guashi aksezheklde: “‘Maiñki nas naldataldakuéga ni miná’ guaklduge.” ");
INSERT INTO kog_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Guatshak Jatetshi múldigaba sezhekldeja guakaga namakgaba nak ayusha akuazháka. Aiki Saldiñga netshi Jateja atshak zalda káguba ají múldigabaga aksuikuekue nalguák nuxa “maiñki nas naldataldakuéga ni miná” kakuakldane. ");
INSERT INTO kog_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ekí guaka ne, ake, nas míñgaki aldéñ naldiñga ají za naldaldikuamak nezhgakugueni jai kagik nakaxa guane naugé jiaga, ¿jinak shi ekí minaxaldék? Nas “Jate Tsukua nzhakú” guakugé shalda nuxa “Jate aguáñ izhbashi mual ekí negashibaldá” naxaldegakue miñgatsaldakí naldashá. ");
INSERT INTO kog_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Guatshak Najate atshamakga atshakí nanakuashíñki namak najañguakue miñgatsaldazháka. ");
INSERT INTO kog_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ne, Najate atshamakga atshuge nakna, guakugé shalda namak najañguakí minaldaldiák jiaga, atshikugéñ zhiniki namak najañguakue. Ekíki muldetua miñgajieni, ekí miñwashexaldiamak: Najateki nasldi izhuka, jiak naski aldéñldi izhokuge. ");
INSERT INTO kog_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ekí guagatshakna akuxaldixa mokue ajañguane nalgué, amak akuxa kakzegagá, ne. ");
INSERT INTO kog_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Guñgueni mokue nina Juldáñka uniñkauwa Juañja kasak kágubakue nik kajaukshatonaneñka neñgueniki anuñka exa izhó. ");
INSERT INTO kog_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Exaki matshuwi kágubakueja atuál axaldagatshak ekí akuák: “Juañjañga ni mitsák Jatetshi kamakga ezua ajanashaté tu guañkáaldamak atshazhá guane naldatshak, Duwe Jesú shalda zʉnake guakldauxabe zegaté tiuwi.” ");
INSERT INTO kog_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ekí akuashi na, exaki matshuwi nekueja Duwe namak ajañgui alduna iyashá. ");
INSERT INTO kog_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Guatshak ezua sigí Betaniaxa zalda Aldásaldu axezhukaki mulbatá akzeshiñgaba na guatoxá. Etshi aldúkue Maldiya, Malta jiaga exa zaldaga. ");
INSERT INTO kog_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Alde Maldiyaki Duwetshi kasak we juma izhuka itsukualdiniki ají saikga kañgualdixa na naldá. Guatshak Aldásaldu ekí akzegatoguakna, ");
INSERT INTO kog_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","aldúkuejañki Duwe Jesú ekí dulda akuazakauwá: “Duwe, nauwizhani mezhgajañguxa mulbatá akzeka sha nzhok.” ");
INSERT INTO kog_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ekí nukatshak Duweja ekí guak: —Ekí akzegatukaki shuizha nuxa gualdiamak akzegakí. Egaba Najate za akldé akzamakga agazukualdiamak, nas Asukuák jiaga akldé nakzé atualdiamak na ekí akzegatók. ");
INSERT INTO kog_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Guatshak Duweja Malta, Maldiya, Aldásaldu kezhgajañguxa nalguakna, ");
INSERT INTO kog_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","“Aldásalduki mulbatá akzeka sha nzhok” nukañgueni exaga mutiuwiñ izhogueniki, ");
INSERT INTO kog_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","shi kagitixakuañ ekí zʉñmeyá: —Mokue Juldeyaxa kuizneji. ");
INSERT INTO kog_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Zʉñmeyatshak: —Shi maldazʉñkaldixa, jiak ¿mauzeñ nuxa exaki juldiú sanekakue makuaxaldiamak naki jagi miyabuxal makuane ne shi mokue exa maldeyaldixa mitshán? ");
INSERT INTO kog_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kakbeyatshak ekí zʉñkiyó: —Niuwiki nañkaldinik zʉtuwiñga agajienka, ne auxa zʉtuagá nogashá. Akna mieldeki niuwisʉñ neyatukaki jikak akbinazhé. Akbiñgaki kagik muñshí zalda zʉtualga nogakna azatuaka nak. ");
INSERT INTO kog_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Akze, mieldeki sesʉñ neyaldiák, jikak akbinaka. Akbiñgaki muñshí zalda axaldaldakí nak. ");
INSERT INTO kog_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ekí guaguenik ekí jiaga zʉñmeyá: —Kezhgajañguxa Aldásalduki kabá guane nakldók. Akna uba akldeñshal neyaldikue. ");
INSERT INTO kog_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Zʉñmeyatshakna nasʉñki ekí akbeyá: —Nauwijí Sáñkalda, guatshak se akzexaldixa naguana kabá guane nukshí. ");
INSERT INTO kog_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Guatshak Duweja ekí guagatogatshake Aldásaldu shua guane shalda guagatshak, nasʉñki niuwabak kabane nuxa na kajañguá. ");
INSERT INTO kog_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Guñguakna zʉñgajienaldiamak ekí zʉñmeyá: —Aldásalduki shuizhá guane nakldók. ");
INSERT INTO kog_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Naldatshak exa izhogazhá guanuge shalda zeñ nakldeshi. Jinake naldakí. Maiñ ai zhinik namak najañgui akldé alduna minazishaldixa nak. Akna e nugaldi kuizaldi. ");
INSERT INTO kog_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Guñguakna Tumásga “Shpa” kaxaldekaja aldéñ nañga Duwe shi kagitixakuañ ekí zʉñmeyá: —Ake, nasʉñ jiaga Duwe na shuigakualdiamak agapa kuizaldi. ");
INSERT INTO kog_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Guñgueni exa neyatshake, Aldásalduki shuanekue abegaldi abegueni au makaiwa ldiuwi zegaté na noxá. ");
INSERT INTO kog_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Guatshak Betaniaki Jeldusaldéñ tezhakga, nauwa akyoñga na zaldá. ");
INSERT INTO kog_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Akna matshuwi juldiúkueja Maldiya, Malta, kauwizhani kakshuane nalgué shalda axakuañnexal aldakldekue na noxá. ");
INSERT INTO kog_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ekí aldogueñki Maltaja “Duwe nagaté nzhok” nukañguake akldabixal nak. Guatshake Maldiyaki juxaga na izhoxá. ");
INSERT INTO kog_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Akldabigueni Maltaja Duwe ekí akbeyá: —Duwe, jai izhomaldaldíñki naldani nakshuigazhá guataldalgué. ");
INSERT INTO kog_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Naldatshak nas nakueki, kaiga jiaga Saldiñga netshi Jatek ji makshishaldiake amak mixatshaldixa. ");
INSERT INTO kog_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Guñguakna Duweja ekí akiyó: —Mizhaniki shuane naldatshak mokue izhgaldaxaldixaga nakldá. ");
INSERT INTO kog_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Guñguake Maltaja ekí akbeyá: —Aguana, nas nakueki auxa zegatshak, shuanaldixakue izhgaldagakue ldiuwañ zegatshak aldéñ jiaga izhgaldaxaldixaga. ");
INSERT INTO kog_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Guñguake Duweja ekí akbeyá: —Nasga na shuanekue izhgaldakshikuge, abisajañ mimezhokshikuge. Akna mieldeki namak najañgui nepananeki shuigatshak jiaga, izhoshiñga izhokshaldikue. ");
INSERT INTO kog_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Amak nepanane izhoshiñga izhokshapananugeki ni mitsák shuishiñga shuigazhíta. Ekí mikbeñkugé ¿“namak shakldá” jañguá shi makú? ");
INSERT INTO kog_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Guake ekí akiyó: —Akzé. Nají Sáñkalda, naski Saldiñga netshi Jatetshi Asukuá giemi maldé ni majañgukú. Jatejañga zʉnekualdal kagik gaxaldixa guakldanega maldé majañguashakú. ");
INSERT INTO kog_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ekí guaxeniki mokue ajuxa neñguenik, aldani Maldiya ahezuañgaba ekí akbeyá: —Shi zʉñkaldixa naklde, axazguagatiakue na makuák. ");
INSERT INTO kog_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nukañguake ubáñ izhgaldagueni Duwe tual nak. ");
INSERT INTO kog_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Guatshake Duweki kuíbulduxa naldi juldunagá, Maltaja akldabinalgueñkaga akté na noxá. ");
INSERT INTO kog_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Guatshak juldiúkue Maldiya axakuañneshi ajúk zhekualdekueja ekí maldeñgaba izhgaldagueni neyaté atuñguake, “abuá abexaneñka mauwal neñká nakbatú” ajañgui na axapañga aldé. ");
INSERT INTO kog_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Amak Maldiya Duwe nugéñ naguenik, e tuatshak asták nuldu axayoshi ekí akbeyá: —Duwe, jai izhomaldaldíñki naldani nakshuigazhá guataldalgué. ");
INSERT INTO kog_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Akbeyatshak Duweja Maldiya mauwaté tuwi, juldiú agapa nakldekue jiaga abauwaté tuatshakna, aldéñ jiaga aldunaldi guañ akldeshi, zʉxaita itshaniñga ");
INSERT INTO kog_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ekí kaklduká: —¿Mashi ají abuá mexamine ne? Guñguake agabeyá: —Duwe, tuatak guwá. ");
INSERT INTO kog_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Guatshakna Duwe jiaga mauwá. ");
INSERT INTO kog_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Guñguakna juldiúkueja ekí izhgabeyá: —¡Tu guwá, mitsá izhgajañguxa nane mitú! ");
INSERT INTO kog_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Guatshakna aikuega ezuakuejañki ekí akuák: —Jejiéja guana ezua uba isé uba ikuksha guane, ake, ¿ekibeñga Aldásaldu shuigazháldiamak atshaka nane naldazhé sha? ");
INSERT INTO kog_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Guatshakna Duwe mokue aldunaldi zʉxaita guañ akldeshi, Aldásaldu abexaneñka ne. Eñkaki jakataga naldatshak julduneñki jagiga agayone na naldá. ");
INSERT INTO kog_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nalgué ekí guak: —Jagi agajuekua guwíñ. Guagatshak Maltajañki ekí akbeyá: —Nají Sáñkalda, naldaniki shuixenik makaiwa ldiuwi itsegatshake jaldazhikshaté nogashá. ");
INSERT INTO kog_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Guñguake Duweja ekí akbeyá: —Alduna nazisha makualdiake Saldiñga netshi Jate sakí akaldak akzé matualdixa mikbenuge, ¿mitsáte shi mikjuizhán? ");
INSERT INTO kog_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Guñguake jagi amak axajuekuñguake, Duwe mateldi zʉtuaté noshi Jatek ekí akbeyá: —Najate, naldukamalde shalda zeñ nzhakldék. ");
INSERT INTO kog_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nas maldakueki, naldukal za malduka. Naldatshak káguba jai ashekuekueja ma nakaxamaldamak ne ajañgualdiamak na ekí mikbeñkú. ");
INSERT INTO kog_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ekí akbeñgueniki jaldáñ kauldá: —¡Aldásaldu, jexa akzʉxaita guwá! ");
INSERT INTO kog_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Guatshakna shuane nogué amak akzʉxaitá. Guatshake káuxaldak, kasak muldetua makuega, waxake zhakuák makuega na akzʉxaitá. Guake Duweja ekí guak: —Isoñgua guwíñ, neyaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Guatshakna matshuwi juldiúkue Maldiya agakuañnexal aldakldekueja ekí Duwe Jesú atshaté atuatshakna, e namak ajañgui alduna iyashá. ");
INSERT INTO kog_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Guatshak anuñkakueja zʉnake Duwe ekí atshaté atune shalda paldiseyukuek agabeyal aldé. ");
INSERT INTO kog_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Guñguakna paldiseyukue, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue na aldaldi saldiñga akldé akzekue sanekakuegaba ajuizhakuá. Guñguenik ekí izhgabeyaldá: —¿Sai atshakualdixa ne? Ejié sigí agubisha “me ne” awatuñshaldiamak ajanashaté atú guazhámak atshapanák. ");
INSERT INTO kog_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Akze, tu me guakualdiake, eja za kaksanexaldiamak ajañgui saldiñgaja iyapanaldixa. Ekí zexaldiake, Aldumaxa zalda zʉñsanekakueja juwí Jate kaxazguaká zʉñkiyatiñgua, juldiúkuañki zʉnagaldañgashaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Guatshak ezua aikuega Kaipás axezhuka, ai kagiañki Jatek múldigaba agaskaitshixa akldé akzé izhoxejañki ekí guak: —Maiñ “jiga ni guagatokú” miñnegagáldekue ni miná. ");
INSERT INTO kog_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Miñnegazhámakga “muldetuañki saldiñga juldiúkuañ zʉnagaldañgashi guakuake, ezuamé sha saldiñga nauwisanákue tsaldi shuigakue na” jañguakí nibiná. ");
INSERT INTO kog_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ekí guagatshak aldéñgabaki ekí guagazhá. Ai kagiañ aldéñki Jatek múldigaba agaskaitshixa akldé akzé izhoxák, Jatetshi múldigaba naldi zʉxaitshiñga na, Duwe Jesúki nauwisanákue tsaldi shuixaldixa guashi ekí guak. ");
INSERT INTO kog_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ekí shuigatshak juldiú saná tsaldi zañki shuigazháldixa. Akze, saldiñga sanákue tsaldi shuixaldixa. Ekíki Jateja ají sukuakue san san zhekuekue juizhi askuiñga keshjuizhakualdiamak. ");
INSERT INTO kog_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ekí guagatshakna ai ldiuwañ zhinikga Duweki akuaxa akualdixa izhgakualdi na ashekualdapaná. ");
INSERT INTO kog_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Guñguakna Duweki saldiñgaja tundana zeñ juldiúkue ashekualdéñ akldé mizhaksá. Gueniki ai zhinik zʉnauldeji, ezua kuíbuldu naki zʉk zeñka Epaldahíñ axezhogeñka nasʉñ shi kagitixakuañ na anuñka izhoxaldiamak abá. ");
INSERT INTO kog_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Guñgueni nauwibama juldiúkue san kagixa guiyaba atuwi ashekualgueñka zhinik Jateja kakzʉxaitshanéñ ldiuwañ be zʉñgisexaldiamak kajuizhaldexaldiéñ naki zeshi na guatoxá. Ekí guatoxakna matshuwi eñgui baxe san san ashekualdi zhinik Jeldusaldéñkagaba na alditshigapaná. Ekíki ai ldiuwañ zegagáñga janshi ishkazakuá guanega naldaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Guñgueni exa Duwe aldiji, juwí Jate axazakuageñka ataba atabañ ekí izhgalduká: “¿Kaiga kishjuizhaldegéñ ldiuwañ nakga mi gualdí?” ");
INSERT INTO kog_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Guatshak Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, paldiseyukue na aldaldi ekí niuwi axene: Mieldejañki Duwe Jesú mashi izhuka tu gualdiake kakbeyakue, akuxaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Guatshak Jateja nauwibamakue san kagixa guiyaba atuwi ashekualgueñka zhinik kakzʉxaitshanéñ be kizhgisekué ldiuwañ zegexañ tezhuwa ldiuwi me abatogueñki Duwe Jesú mokue Betaniak zʉnauldák. Exa na Aldásaldu shuane nalgué aldéñga izhgaldakshane izhoxéñ na naldá. ");
INSERT INTO kog_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ai kaldagatshake Duwe abuazaldiamak axazalduxá. Guatshakna Maltajañki gakue zʉñgakshatogatshake, Aldásalduki Duwe na zaldixa ité na noxá. ");
INSERT INTO kog_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ekí kaldogueñga Maldiyajañki ezua we juma izhuka maldé akzé “naldu” naldi, anuñka mozhua jaldu naldashi uldagueniki, Duwetshi kasak itsukuñguenik ají saikga kañguá. Guatshake juldi zalguauxa aiga we na juma iyaldaxá. ");
INSERT INTO kog_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Guatshakna ezua shi kagitixakuañga Juda Iskaldiute Duwe gexaldixa naldejañki ekí guak: ");
INSERT INTO kog_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Jinak we juma izhuka ezua kagi kasa izhgáu naldashi akzaldi nabesá xaldeki, aiki nashi jika agajueshkakuek akáu guasé ne? ");
INSERT INTO kog_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Guatshak nashikue guañ jañguiñki ekí guagazhá. Egabá aldéñki paldata jiba akbeyakualdixa aksuikue ne, ai zhinik ikushi tusheka naldák nuxa na ekí guaxá. ");
INSERT INTO kog_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Guñguake Duweja ekí guak: —Munzhiki atshaté nakldók. We juma izhukaki shuixaldikuenik abuá nabegapanatshak ldiuwañ nebexaldixa mexane nak ekí naxatshatogashá. ");
INSERT INTO kog_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Akze, nashi jika agajueshkakueki miñkizhoxalga noná. Nas zʉnake miñkizhoxal za nogazháldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Atshake Duweki Betaniaxa izhogatuka kakwasheguakna matshuwi juldiúkue izhgazhe atuál aldé. Ekí aldeyatshak Duwe atuál zañki aldeyazhá; Aldásaldu shuane nalgué Duweja mokue izhgaldakshane jiaga na atuál aldeyá. ");
INSERT INTO kog_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Guatshakna Jatek múldigaba agaskaitshixakuetshi sáñkaldakuejañki Aldásaldu jiaga akuaxaldixa izhgakualdi na aldogapaná. ");
INSERT INTO kog_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Jinake naldakí. Aldásalduk zhinik nuxa matshuwi nekueki kakbeni, Duwe niñkauwañki namak ajañgui axapa aldeyatoxák. ");
INSERT INTO kog_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Guatshak Duwe Jesúki Betaniaxa naguenik abokualdiki Jeldusaldéñ neñká neyatogueñki, káguba matshuwi zhikzhe kajuizhaldeká ldiuwañ azaxaitshaldiamak Jeldusaldéñka aldenekueja Duwe nagatuka kakwashék. ");
INSERT INTO kog_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Guñguakna setábaxe xai izhgasuigueniki Duwek agaldabixalgaba aldák, zeñ kakldeshi jaldáñ ekí akuashi: —¡Saldiñga netshi Jate akldé akzamakga kuizakzukuí! ¡Jate, nauwijí Sáñkaldaja jejié nauwisaná Isayéltshi Sáñkalda akaldak akzé atsaldí zʉñgakaxane, aldéñga zeñ shi jañguí! ");
INSERT INTO kog_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Guatshak Duwejañki ezua buldu awawaga akzalguake eñkáñ iyabexane ité na neyatoxá. Ekí zegatshake Jatetshi múldigabak sezhekldamak na zexá: ");
INSERT INTO kog_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Siyóñ zalda minekuañ, zhe miñzegazháldi. ¡Tu guwíñ! Mimijí Sáñkalda akzeki uñkuahí buldutshi awawak ite nagaté tiuwi.” ");
INSERT INTO kog_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Guatshak ekí zegatshagaki “jinakga ni ekí zek” shi kagitixakuañ zʉñgajienazhá. Guane nalgué, aldéñ akaldak akzé awatuñguenik na, ekí zekldane be zʉñgisegatshak, Jatetshi múldigaba sezhekldaneja Duwe shaldaga sakí axajanashaldixa guagamakga ekí zekldane muldetua zʉñgajiená. ");
INSERT INTO kog_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Guatshak Aldásaldu shuane abexanalgualdi zhinik akzʉxaitaldiamak Duweja ixauldi izhgaldakshaté matshuwi nekueja atune nalguakna, axautshikuek ai shalda agabeyatone. ");
INSERT INTO kog_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nalgué shalda na, matshuwi nekueja Duwe “me ne” awatuñshaldiamak ajanashaté atú guazhámak ekí janshizhe atshane aldukane nalguakna, Duwe agaldabixal aldaklde. ");
INSERT INTO kog_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ekí zegaté atuatshakna paldiseyukuejañki ataba atabañ ekí izhgabeyá: “¡Tu guwíñ! ¡Kaiga míñgaki ni ji atshakue naldasá guxá tiuwi! ¡Saldiñgaja ekgaba axapa aldeyaldá guxá tiuwi!” ");
INSERT INTO kog_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Guatshak axautshi saná galdiegukue jiaga Jeldusaldéñka kajuizhaldeká ldiuwañ azaxaitshaldiamak Jate akldé akzukual alditshine. ");
INSERT INTO kog_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ekueja na Pildipiki Galdildeyaxa kuíbuldu Betsaildaxa zalda axaldagueni ekí axakuañnék: —Duwe, atshamildaka guashiñki Duwe Jesú zʉñkazguaksha guatabaldaldé. ");
INSERT INTO kog_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Guñguake aldéñki Andaldé nugeñka neñguenik akbeyá. Guñguake mozhua aldaldi Duwe Jesúk agabeyal aldé. ");
INSERT INTO kog_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Guakna Duweja ekí guak: —Kaiga zʉnake Jatetshi Asukuá ixagabaldekldugek nakzé nawatuñshaldiéñ akldañká na gu. ");
INSERT INTO kog_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Namakgaba miñmeyaldikue: Zulda kagik jienane galdunakí naldaldiák, ai zañga abaka. Akze, galdu gualdiák zʉnake, muni akldé matshuwi negaka naldashá. Amakbeñga na, shuixaldikuák za na matshuwi nekue izhoshiñga kezhokshaldikue. ");
INSERT INTO kog_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ekíga na, mieldeki jai kagik izhoxa za akldé akzé jañgui nagapa neyasʉ́ñ akzekaki, shuigatshak jékaldaxa izhoshiñga izhogazháldixa. Ekí ne, mieldeki nagapa neyaldiamake jai kagik izhoxa za akzé tuagába izhoxaldiák zʉnake, abisajañ izhoshiñga izhoxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Akze, mieldeke naxazaundanañga miñzexaldiake, nagapa neyal nogakue miñgatsaldaldixa. Ai zhinik na, minaxazauñkake mashi izhoxaldikuake eñka mizhekualdaldixa. Guatshak mieldeke ekí minaxazauñka naldaldiake, Najatejañki “janshibé naxatshamine tiuwi” miñkaldexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Zʉñmeñgueni ekí guak: “Kaigaki aldunaxa nakzekága itshaniñgaba na gukú. Akna ¿sai guaxaldikue ne? ‘Najate, ekí nagatsexaldixak nazikua makualdí’ akbeyazhánaka. Jinake naldakí. Naski ekí nagatsexaldixa naklduge nak.” ");
INSERT INTO kog_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Guagueni Jatek ekí akbeyá: “Najate, ma za akaldak mikzé maldé awatuñsha guwá.” Guatshakna alnobaxa zhinik múldigaba ekí nuká: “Sakí akaldak nakzé naugé awatuñshá guanuge naldatshak, mokue ekíga atshaldikue.” ");
INSERT INTO kog_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aldukatshakna exa ashekualguekuega ezuakuejañki kuizhbañgui ekí neklde akuagatshak, jiak ezuakuejañki Jateja guaklde uldeñkajañga axazguaká na akuaxá. ");
INSERT INTO kog_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Guakna Duweja ekí kakbeyá: —Nas nukaldikue múldigaba negazháne, maiñ minukaldiamak guana ekí neklde. ");
INSERT INTO kog_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kaiga zhinik na saldiñga kagik mizhekuekuek sha miyatshixa shalda guiyaba tuakue miñgatsaldi azhi miñgatsaldakí ne mimawatuwi mimeshkajuekualdiéñ zek na gu. Au jisé jai kagik sanegatuka kama ikuxaldikuéñ na zek. ");
INSERT INTO kog_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Guatshak naski saldiñga natualdieñka matáñ kaldixa naxaldiya nakuatshakna, káguba saná na nahauxa neyapanaldiamak nas nugeñgaba keshkuldaxaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ekí guagatshake aldéñki sakí akuí shuixaldixa shalda na guagatoxá. ");
INSERT INTO kog_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Guakna káguba ai zhekualdekueja ekí akiyayó: —Nasʉñki Jateja ezua zʉnekualdal gaxaldixa guakldaneki izhoshiñga izhoxaldixa ají múldigabak guaka zʉñkué naldashá. Ne ¿sakí shi mañki Jatetshi Asukuá ixagabaldekbalde jiaga, kaldixa maxaldiya makuagakue naldaldixa shi makuák? Guake Jatetshi Asukuá ixagabaldekbalde guaxabaldukaki ¿me naldaka ne? ");
INSERT INTO kog_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Guñguakna Duweja ekí kakbeyá: —Nauwa maldé meñki muñshí zalda mimikenáñ izhoxalga noxaldixa. Akna muñshí zalda miñkaldaldalga nogeñgaki neyalga nogwíñ, ekíki tuañ zalda mimakushi guakuak. Akze, mieldeki tuañ zaldi neyatukaki “maniñga ni neyatokú” akldegazhé. ");
INSERT INTO kog_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Akna, muñshí zalda miñkaldaldalga nogeñgaki ai za namak jañgui miñgualdí. Ekíki muñshí zaldi izhukakue nahamakga mizhekualdaldiamak. Ekí Duweja kakbeyatogueniki, ai zhinik neñgueni saldiñgaja atuazháldialdi ne na gua. ");
INSERT INTO kog_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Guatshak Duwe Jesúja atuatoguéñ matshuwi juizha aldéñ “me ne” awatuñshaldiamak janshizhe ajanashaté atú guazhámak atshatogatshak jiaga, juldiúkueja namak ajañguazhá. ");
INSERT INTO kog_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Akze, Jatetshi múldigaba naldiñga zʉxaitshixa Isaiyaja Jatek akbenamak zexaldiamak ekí zeklde. “Nají Sáñkalda, ¿meja shi ma shalda guakalde ‘namak na guak’ jañgú? Azhi ¿mieldek shi atemajañ atshane ‘aiki Saldiñga netshi Sáñkaldatshi kamaga nakbatú’ muegisekldá?” ");
INSERT INTO kog_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ekí zhinik na namak ajañgua kakzegazháne. Ai shaldaga Jatetshi múldigaba Isaiyaja ekí gauwane: ");
INSERT INTO kog_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ji atshikugé atuwi guakuak uba kesañguá guanuge, kagajienazháldiamak aldunaxa kakuamakuá guanuge, ekíki aldunaxa se kakzukui kekualdaldikuamak sha ajanashane kaxabetaldikuamak naxakualdi akuí guakuak.” ");
INSERT INTO kog_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jinak ekí gauwazhá. Duwe Jesú sakí akaldak akzé tuwi na, e shaldaga ekí guaklde nak. ");
INSERT INTO kog_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Guatshak ekí Duwe namak ajañguakí naldi jiaga, matshuwi nekueja, anuñka juldiú sanekakueja jiaga namak ajañgui alduna iyashá. Egaba saldiñgaja aldukatogéñ, “Duwe namak ni jañgukú” akuagakí na naldá. Akbiñgaki paldiseyukueja kakwashek gualdiake, nauwisaná na juizhaldexa kakiyawatiaka zheñga kakzukuák. ");
INSERT INTO kog_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jinake naldakí. Kágubaja kakzé katualdiamak za akldé aldiji, Jateja katuñká niñkauwañki aguáñ akzé ajañguxa nalguák. ");
INSERT INTO kog_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Guatshak saldiñgaja nukandana agatsaldi Duwe Jesúja ekí guak: “Mieldeki namak najañgui nazipana gualdiák, nas za ekí najañgui nepanagába, Najate nakaxanega ekí ipanaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ekibeñga na, mieldeki nas natualdiake, nakaxanega atualdixa. ");
INSERT INTO kog_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nas na muñshí zalda naugák kagik zhekuauxa muñshí kezgualdikuamak naklduge. Ekíki mielde namak najañgui nazipana guanekueki tuañ zaldiñga abaji guakuak. ");
INSERT INTO kog_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","”Guatshak mieldeke shi miñkaldiyatokuge nuká miñguatshak jiaga amak naxatshakí minoxaldiák, nasga guiyaba tuakue miñgatsé axamindagazháldikue. Jinake naldakí. Naski kagik mizhekuauxa miñgatsé axamindaxalki nagagába, minkualdal naklduge nak. ");
INSERT INTO kog_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Naldatshak mieldeke nazipanasʉ́ñ miñzeshi, ni nají múldigaba nagipanazhá miñgualdiák, auxa zegatshak miñgatsaldi ne mimawatualdiéñ akldañkatshak, nají múldigaba guagaté naldukaminejañga na guiyaba tuakue miñgatsé axamindaxaldixa. ");
INSERT INTO kog_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Jinake naldakí. Nas axaldáñ jañgua me guagagába, Najate nakaxaneja guagakue, shizhiyakue niuwi nagenauxabe guaklduge nak. ");
INSERT INTO kog_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Akze, Najateja abisajañ izhoshiñga mizhekualdaldiamak ekí miñmeyakue niuwi nagene nakué. Akna nas shi miñkaldikugéki Najateja miñmeyakue nakbenauxabe miñmeñkuge nakldá” na Duweja kakbeyatoxá. ");
INSERT INTO kog_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Guñgueni Jateja nauwibamakue san kagixa guiyaba atuwi ashekualgueñka zhinik kakzʉxaitshanéñ ldiuwañ be izhgisekui kajuizhaldegéñ naki abaldá. Guatoguéñ na, Duwe Jesújañki jai kagik zhinik neyaldiniki Ajate nugeñka neyaldixa ldiuwañ “naxakldañká sha gu” akualdi na, ajíkuañ jai kagik aldéñ na izhoñkaldekuañki zʉnezhgajañguiñgaba nagatoguamakga, zʉxaita ekí zʉnezhgajañguiñga izhó. ");
INSERT INTO kog_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Guatshak kajuizhaldeká ldiuwañtshi gakue gakualdiéñ zegatshake, au jiséjañki Simóñtshi asukuá Juda Iskaldiuteki Duwe gexaldiamak aksanék guane. ");
INSERT INTO kog_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nogué, Duwejañki “Saldiñga na nahauxaki Najateja nasgaba naksuikualdaldiamak nagene shakldá. Saldiñga netshi Jatek zhinikga nakldugamak jiak, mokue ek axaldeyapankugé shakldá” akualdi na, ");
INSERT INTO kog_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","zaldiamak yatene nogué, izhgaldagueniki ají zhakuá abakaldak ijuakualgueki itshui duwá guñgueniki, zʉñkazauwexañ ezua zhakuá janáñkaldak zhikbá. ");
INSERT INTO kog_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Guñgueniki kaltoxék ni akzukuñgueniki ezua ezuak aldéñ shi kagitixakuañ kasa zʉnejizhi, jiak zhakuá janáñkaldak akbakualdeke zʉnaxañgui zʉnaxañgui na guapaná. ");
INSERT INTO kog_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ekí atshiji Simóñ Péguldu nugeñka neyatshak, ejañki ekí akbeyá: —Nají Sáñkalda, ¿ma shi nas kasa nazijizhabapán? ");
INSERT INTO kog_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Guakna Duweja akiyó: —Jinak ekí miñkatshatokuge kaigabeñki ma migajienakíñga noxaldinik, aldiwan zʉnake migajienaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Guakna Pégulduja: —Ni mitsák kasa nazijizhakue majañguazháldikue nakldá. Guake Duweja: —Mijizhazhá gualdikuák guashiñki, nas na muldetua izhgapa izhogazhámildaka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Guake Simóñ Pégulduja: —¡Nají Sáñkalda, ak zʉnake, kasa za nazijizhagábaki, káuxalda, sáñkalda azhi najauksha makualdí! ");
INSERT INTO kog_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Guatshakna Duweja ekí akiyó: —Mieldeki ajauxá guaneki mokue jaukshakue naldazhé, kasa za ijizhakue. Jinake naldakí. Agatsahauxa janshagatsega nogatogák. Akze, maiñki janshi miñgatsegaba naldabinuka. Naldiñki saldiñga ekígaba naldakí miné jiaga. ");
INSERT INTO kog_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Akze, mieldeja gexaldixa aldéñki akualdiñga noxakna, “naldiñki saldiñga janshi miñgatsegaba naldakí na miná” na guaxá. ");
INSERT INTO kog_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Guñgueni amak auxa kasa zʉnejizhgueniki zhakuá abakaldak ne mokue izhbiñguñgueni, jiak zaldiamak yaldaguenik ekí zʉñmeyá: —¿Ekí miñkatshikugé miñgajiená shi gu? ");
INSERT INTO kog_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Maiñki “shi maldazʉñkaldixá”, “nají Sañkaldá” minaxaldegatshak, naxaldegakuamak na minaxaldék. Akze, naugamak ne. ");
INSERT INTO kog_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Akna nas mimijí Sáñkalda, shi miñkaldikugek jiaga miñkazauwi kasa minjizha guanuge ne, maiñ míñgaki ataba atabañ ekíga ishkatshakue miñgatsaldashá. ");
INSERT INTO kog_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nas ekí miñkazauwi miñkatshanuge nagastu miñgualdinik amakbé mishkatshaldiamak mimatuñsha na gukú. ");
INSERT INTO kog_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Namakgaba miñmeyaldikue: Ni mielde nashiki ají sáñkalda zhakaldak akzé naldazhé. Ni axaxa me guanega e gaxane zhakaldak akzé naldazhé. ");
INSERT INTO kog_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Akna ishkazauwakue miñkué nak, amak atshiji mizhekualdaldiake, zeñ minaldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","”Ekí guaxaldatshake, saldiñga maiñ shaldaki ekí guagakí. Akze, nas izhgakuxanugekueki muldetua nakualdi nogatuka. Naldatshak Jatetshi múldigabak sezhekldamak zexaldiamake ekí zexaldixa. Aiki ekí sezheklde: “Ezua nas na za zaxa ne, sha nakualdiamak niñkauwañki nakizhbatek guane.” ");
INSERT INTO kog_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","”Kaiga amak zegagá nogeñga ni ekí miñmeñkú. Ekíki amak zegaté mituatshak, naldiñga naugé namak minajañgualdiamak. ");
INSERT INTO kog_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Akze, namakgaba miñmeyaldikue: Mieldeja gaxanuge ipanatshak, nasga nazipanaldixa. Ekíga na, mieldeki nas nazipanatshak, nakaxanega ipanaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ekí zʉñmeyatoguenik Duwe Jesú aldunaxa akzekága itshaniñgaba, muldetua zʉñgajienaldiamak ekí zʉñmeyá: —Namakgaba miñmeyaldikue: Ezuak maiñga nezhguashi aguldiñkugekuek minagexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Guñguakna shi kagitixakuañgaba “sakíga ni jañguakuá” zʉñnegazháldi, “¿mielde shalda shi ekí guagaka na?” jañgui ataba atabañ atú. ");
INSERT INTO kog_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Guatshakna ezua shi kagitixakuañga nezhgajañguxake Duwek akyó giemi izhogukueñki, ");
INSERT INTO kog_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simóñ Péguldujañki me shalda ekí guagatuka akldukakue natuñshá. ");
INSERT INTO kog_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Guñguake Duwek akldé agayogukuenik ekí aklduká: —Nají Sáñkalda, ¿me shi ai naldaka na? ");
INSERT INTO kog_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Akldukañgukuake ekí nakiyó: —Mieldeki pañ zhikwati nuañguanuge galdiamak agexaldikuake, ai naldaldixa. Guñgueni amak pañ nuañguñgueni Juda Iskaldiute Simóñtshi asukuák ageguake, ");
INSERT INTO kog_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ipanatshak zhinik na jisé ijuldú na gua. Guake Duweja Juda ekí akbeyá: —Sakí matshaldixa nake, maldeñgaba amak atsha guwá. ");
INSERT INTO kog_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ekí guagaté kaldukatshak, zañkaldoxekuañ ni mieldek “ekí akbeji sha ekí akbé” zʉñgajienazhá. ");
INSERT INTO kog_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Egabá Judaki paldata jiba akbeyakualdixa aksuikue naldakna, ezuakuañki Duweja juizhaldekaldetshi jigabá juezhane nak ai jabiyal akbeyatuka, azhí nashikuek paldata nauwa kagegakue akbeyatuka ne jañguáñkalde. ");
INSERT INTO kog_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Guatshak Judaja Duwek amak pañ agipangueni ubañga akzʉxaiti ne. Guatshak tuañ na zaldá. ");
INSERT INTO kog_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Guñguenik Juda amak neyatshake Duwe Jesúja ekí zʉñmeyá: —Kaiga zʉnake Jatetshi Asukuá ixagabaldekldugek akldé nakzé nawatualdiéñ na zegapán. Guatshakna nas zhinik Jate akldé akzé katuñshaldikuéñ zexaldá na gu. ");
INSERT INTO kog_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Akze, nas Najate akldé akzé katuñshi atshikugamakga, jiak aldéñ zhinik akldé nakzé nawatuñshaldixa nakldá. Amak nakzukualdixa naki me na abapán. ");
INSERT INTO kog_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","”Shui nasukuákuañ, maiñ na mitsáki izhoxaldaksá na gu. Gualdinik minaldiyaldixa. Guatshak juldiú sanekakuek kakbeñgukuamakbeñga kaiga maiñ miñmeyaldikue: Nas neñkugaldiñga neyazháminaka. ");
INSERT INTO kog_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","”Akna atsha miñgualdixa abisa miñmeyaldikue. Aiki ataba atabañ ajañgual nogakue miñgatsaldaldixa. Nas mimezhgajañgui nagatokugamak, maiñgaba jiaga ekíga zhualduxa miyajañgualdí. ");
INSERT INTO kog_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ekí ataba atabañ ajañgual za minogatshak zhinik guana, saldiñgaja namak nas shi minagitixakue miné atualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Guatshak Simóñ Péguldujañki Duwek ekí aklduká: —Nají Sáñkalda, ¿mani shi neyabapán? Guñguake Duweja akbeyá: —Kaigaga nas neñkugaldi nagapa neyazhámildaka. Akze, aldiwan mañki nenaldikuéñ maldeyaldixaga nzha. ");
INSERT INTO kog_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Guakna ekí akbeyá: —Nají Sáñkalda, guatshak ¿jinak shi kaigaga migapañga neyazhánaka na? Akze, mitsaldí shuigakue nagatsexaldiák, amak atshanaka naldashá. ");
INSERT INTO kog_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Guake Duweja akiyó: —¿Amak natsaldí shuamikldegamak mi na? Akze, namakgaba mikbeyaldikue: Kaiga gayu kauldagá noxaldieñga, maikjuizhañga “eñki tuazhúge nzha” maldakuaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Guñgueni Duwe Jesúja ekí zʉñmeyá: —Aldunaxa señgabá miñzegaksá zalda itshanagábaki, Najate alduna isha, nas jiaga alduna nazisha mizhekualdaldí. ");
INSERT INTO kog_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Najate nugeñkaki izhogakue matshuwi nañga nakldá. Ekí naldakí nanake, ekí miñmeyazhánaka: Naski exa mizhekualdaldieñka janamiñgaktuwi ni neñkú. ");
INSERT INTO kog_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Amak janamiñgaktuwi neyaldikuenik mokue mimezhgakuxal naxaldikue. Ekíki mashi izhoxaldikueñka, maiñ jiaga nas na mizhoxaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Maiñki neyaldikueñka neyexañ jiúñgulda miñshañga nogashá. ");
INSERT INTO kog_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Guake Tumásja ekí akbeyá: —Nají Sáñkalda, ni mashi maldeyaldixa zʉñsʉ́ñga nuka ne, ¿sakí shi eñka neyexañ jiúñgulda zʉñkualdaldixa na? ");
INSERT INTO kog_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Guake Duweja ekí akiyó: —Nas guana eñka neyexañ jiúñgulda naugé. Nas na namaklde naugé, abisajañ mimezhokshanaka naugé nakldakú. Akna ni me nas naldakíñga Najatek axaldeyazháka. Nas zhinik za na Najatek axaldeyakue naldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Guatshak me naugé muldetua miñkualdi nonugake, Najate jiaga me ne miñkualdaka. Naldatshak kaiga zhiniki Najate tuminamakga, me ne muldetua miñkualdi nogapanaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Guake Pildipijañki ekí akbeyá: —Nají Sáñkalda, ake, Mijate zʉnatuñsha guwá. Guanake auxabé zʉñnegaka. ");
INSERT INTO kog_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Guñguake Duweja Pildipik akiyó: —Miñgapakualdalda gukué anuñka zegatshak jiaga, ¿me naugé miksʉ́ñga nokugé maldúk? Akze, mieldeki me naugé natune naldaldiake, Najate me ne tu guanega naldaka. Ne ¿sakí shi mañki “ake, Mijate natuñsha guwá” nakbemildaka na? ");
INSERT INTO kog_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Naski Najateldi izhokuge jiak Najateki nasldi izhuka ¿namak jañguakí shi maldá? Akbeñgueniki ekí zʉñmeyá: —Akze, nas múldigaba guakugega nasgaba jañguanuge miñmeyazhúge. Najate nasldi izhoxal za nukaga guana, aldéñ jañguamak nas zhinik atshatogashá. ");
INSERT INTO kog_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Naski Najateldi izhokuge jiak Najateki nasldi izhuka miñmeñkuge namak jañguwíñ. Ekí jañguakí minake, ake, sakí atshaté minatuwéñ zhinik namak jañguwíñ. ");
INSERT INTO kog_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Namakgaba miñmeyaldikue: Mieldeke alduna nazishál za minoxaldiake, nas atshugamakga miyatshaldixa. Ekíga na, nas atshugé zhakldé atemajañ jiaga miyatshaldixa. Jinake naldakí. Naski Najate na izhoxal neñkugé nak. ");
INSERT INTO kog_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Gualdini Najatek ji miyakshishatshak, nas naldashiñga miyakshishaldiake, nasga amak miñkatshaldikue. Ekíki nas Asukuák zhinik Najateki akaldak akzé ne tuñshaldikuamak. ");
INSERT INTO kog_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Akna ji nas jañgugamak minakshishaldiák, amak miñkatshaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","”Maiñ namak minezhgajañguxa minake, sakí atshakue miñmenugamak atshál minoxaldixa. ");
INSERT INTO kog_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Miñgauneshi miñgapá nonugamak, Najatek ají Alduna ekíga miñgapakualdi zañga izhoxaldixa miñgexaldiamak miñgakshishaldikue. ");
INSERT INTO kog_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","E Aldunaki namaklde za ne. Kagik zhekue naziyapanazhánekuejañki e atuazhé, ni “me ne” kaksʉ́ñze nak iyapanazháka. Ne maiñ zʉnake “me ne” miñkualdi nogatuka. Jinake naldakí. Maiñ na izhogaté noxaldiniki maiñldi izhoxaldixa nak. ");
INSERT INTO kog_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","”Mimihezua jate minsékue jana mimabajañki guagába, miñkaldaxaldikuega. ");
INSERT INTO kog_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mitsá zegagá nazipanazháne kagik zhekuekueki akldé natualga aldogazháldixa. Naldatshak maiñ zʉnake mokue minatualdixaga. Naski shuanaldikuenik izhoshiñga izhoxaldikue nakna, maiñ jiaga izhoshiñga mizhoxaldixa. ");
INSERT INTO kog_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Atshak ldiuwañ zʉnake Najateki nasldi izhuka, maiñki nasldi mizhuka, jiak naski maiñldi izhokuge namakga ne miñwashék guane naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Akze, mieldeke sakí atshakue miñmenuge nagipanamine, amak atshál minukak guana minezhgajañguxa naldaldixa. Ekí minezhgajañguxake Najate jiaga mimezhgajañgualdixa. Aikuañ na nas jiaga mimezhgajañgui, muldetua me naugé mu miñgisekualdikue. ");
INSERT INTO kog_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Guñguake Juda, eñki Juda Iskaldiute naldazhéjañki ekí aklduká: —Nají Sáñkalda, ¿sakí zhinik shi mipanazhánekueki me maldé mu kagisekuagába, nasʉñ za mu maldazʉñgisekualdixa na? ");
INSERT INTO kog_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Guñguake Duweja akiyó: —Mieldeke namak minezhgajañguxa minaldaldiake, aike miñmeñkugamak naxatshál minoxaldixa. Aikuañ na Najate mimezhgajañgualdixa. Gualdinik nas Najate na miñkaldagakualdinik maiñldiñga izhogakualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ne mieldeki nezhgajañguagálde zʉnake kakbeñkugamak atshál nogazhé. Guatshak múldigaba guagaté minaldukaxaga nasgaba guagakí. Eñki Najate nakaxanejañga guana nakuakshatogashá. ");
INSERT INTO kog_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","”Ekí saldiñga miñmeñkugeki miñgapá nokugeñga na ekí miñmeñkú. ");
INSERT INTO kog_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Guanaldixa Najateja ají Alduna natsaldí miñgauneshi miñgapakualdal miñgakagatshak, eja na auxaga shi miñkaldiyaldixa. Ekibeñga na, shi miñkaldiyanaldikuauxa be miñgisekualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","”Mimabajalda gugakna aldunaxa señgabá mikzexa miñkabaja ni gukú. Aldunaxa señgabá mikzexa nas naxaldéga ni miñgekú. Eñki kagik zhekue nepanazhánekueja sakí aldunaxa señgabá mikzegakue niñka nuxa naldazhé. Akna aldunaxa señgabá miñzegaksá zalda itshanagába. Ni zhe jiaga miñzegazháldi. ");
INSERT INTO kog_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Akze, neyaldikuenik mokue miñkaldaxaldikue guagaté naldukamine. Guatshak minezhgajañguamak nake, Najatek axaldeyaldikue minukatshak zeñ miñnegaka. Jinake naldakí. Najateki nazhakldé akzé nak. ");
INSERT INTO kog_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kaiga amak zegagá na ekí miñmeñkú. Ekíki amak zegaté mituatshakna namak minajañgualdiamak. ");
INSERT INTO kog_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","”Akldeñga dulda miñshál za nogazháldikue. Jinake naldakí. Jisé jai kagik sanegatukaki sha nakuál naxaldá guapanák. Guatshak aldéñgabaki sha nakuá guashi kama axaldaldakí. ");
INSERT INTO kog_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Naldatshak kágubakueja naski Najate izhgajañgui na, aldéñ naxaldek me axatshuge nawatualdiamak na ekí zegakue zaldaldixa. Ekí zʉñmeyatogueniki: —Izhgate xaldeki jai zhinik kuizaldi —na zʉñmeyá. ");
INSERT INTO kog_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Guñgueni Duwe Jesúja kausú zhenkak zhinik ekí shi zʉñkaldiyaldá: “Nas guana kausú muldetua zhenkatshi axalda namaklde naugé. Najateki kausú muldetua zhenaldiamak numañ tuñka jana nakldá. ");
INSERT INTO kog_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Akna kausútshi akulda muldetua zhenagáldekue axabeñguamakbe, akulda jana naxaldikuekue muldetua zhenakí naldaldiake, naxabeñgui guxá jana gualdixa. Ekíga na, akulda zhenkakue siyagaxauwamakbe, mielde akulda naxaldikue muldetua zhenkakueki akldé zhenaldiamak muldetua siyagauwaldixa. ");
INSERT INTO kog_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Akze, maiñki nají múldigaba miñmenuge nagipanaminéñ zhinik na, se miñkaxaune, janshi miñgatsék guamine. ");
INSERT INTO kog_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Akna maiñki nagajuezha naldakí nasldi izhoxal minoxaldí. Jiak nas zhinik mimezhgajuekua naldakí maiñldi izhoxaldikue. Akze, akulda axaldak axaldikualdakíñga aldéñgabaga kausú zhenazháka naldakldegamakbeñga na, maiñ nasldi izhogakíki zhenazháminaka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","”Akze, nas guana kausú zhenkátshi axalda naugé ne, maiñki etshi akulda jana naldashibiná. Akna mieldeke naxabena naldakí nasldi mizhuka, jiak nas zhinik mimeshkawati naldakí maiñldi izhokuge, aikuañ na kausú matshuwi zhenká jana Najatek akldunamak za mizhekualdaldixa. Akze, nas naldakíki ni ji atsha miñzegazháka nakldá. ");
INSERT INTO kog_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Guatshak mieldeki nasldi izhogagába naxabenane za noxaldiakna, akulda axabenane awateyamakbe awateyane kanaldixa. Gualdinik kanane apexaldinik gukséxa agaduañguatshak puldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Akze, naxabena naldakí nasldi izhoshi, shi miñkaldiyanuge miñjuizha naldakí amak atshál za minogatshakna, Najatek ji akshishindana miñzegatshak akshishakue. Gualdiake amak miñkatshaldixa. ");
INSERT INTO kog_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kausú matshuwi zhenká jana Najatek akldunamak za minaldatshakna, namak shi minagitixakue minaldaldixa. Ekí guana Najate akldé akzamakga miyakzukualdixa nzha. ");
INSERT INTO kog_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","”Najate nezhgajañguamakbeñga na, nas zhinik mimezhgajañguashakú. Ekí mimezhgajañgugé muldetua nagipana, aik agasjanamine za mizhekualdaldí. ");
INSERT INTO kog_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nas atshakue miñmenugamak atshál minogatshakna, mimezhgajañguge nagipana, aik agasjanamine za mizhekualdaldixa. Akze, nas jiaga Najateja atshakue nakbenamak atshugéñ zhinik aldéñ nezhgajañguxa agipana, aik agasjana za izhokugamakbe mizhekualdaldixa. ");
INSERT INTO kog_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ekí miñmeyaldatshake, nas zeñ zalda naxaldé, maiñ jiaga miñkaldaldatshak, muldetua miñgatsauxaga zeñ miñnexaldiamak na ekí miñmeñkú. ");
INSERT INTO kog_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","”Jalde na atsha guakue miñmeñkuge: Nas mimezhgajañgugamakga maiñgaba ataba atabañ miyajañgualdí. ");
INSERT INTO kog_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Zʉxaita zʉjañgua neki mipebu tsaldi mashuixaldiamak aké atsha. Ekí agatsaldi zʉjañguak iskaita nega naldakí nakldá. ");
INSERT INTO kog_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Akze, maiñki atshakue miñmeñkugamak naxatshabinogatshakna, napebu mimezhgajañgugekue naldashibiná. ");
INSERT INTO kog_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","‘Nají nashikué’ akldé miñkaldexaldaksá, ‘napebu mimezhgajañgugekué’ niñkauwañki miñkaldekuge. Jinake naldakí. Nashijañga ají sáñkalda atshauxa aksé ne, nas zʉnake Najateja guagaté nukanugauxa miñmeyatokuge nak. ");
INSERT INTO kog_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Guatshak maiñ nezhgakugazhámine, nas guana mimezhgakuxanuge naldashá. Ekí mimezhgakuxaldatshak, ezua jiba minaxatshaldiamak mimetenuge. Ai jibaki kausú zhenamak abá naldakí akldé akldeñga Jatek akldunamak za izhoshiñga neyabinoxaldixa. Ekí mizhekualdaldiakna, nas naldashiñga ji Najatek miyakshishatshak amak miñkatshaldixa. ");
INSERT INTO kog_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Akze, jalde na atsha guakue miñmeñkuge: Ataba atabañ miyajañgualdí. ");
INSERT INTO kog_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","”Guatshak káguba kagik zalda za jañguxakuek miyaguldiyatshak, nas misha ekí kaguldiji nagatokuge miñkualdakue. ");
INSERT INTO kog_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Akze, ekue janañga kagik zalda namimakuashíñki, kauwizhéñ na agatsekue ishkajañguamakga mimeshkajañguaka. Ne nasga najíkue za minaldaldiamak mimezhgakuxanuge nakna, ekue jana kagik zalda naldabiñsá guaminéñ zhinik na kaguldiji mizhekue. ");
INSERT INTO kog_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sakí miñmenuge bezhgisekuakue: Ni mielde nashiki ají sáñkalda zhakaldak akzé naldazhé. Akldé nas nuxaki sha nakuí guiyaba natuñshane nake, maiñ jiaga ekíga guana mimakualdixa. Ekibeñga na, mieldeki nas shaxaldiyatonuge nagipanatone nake, maiñ shi miyaxaldixá jiaga miñgipanaldixa. ");
INSERT INTO kog_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Guatshak najíkue minéñ zhinik na ekígaba sha mimakualdixa. Akbiñgaki nas nakaxane ‘me nzha’ kaksʉ́ñze nak. ");
INSERT INTO kog_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","”Akze, nas jai kagik nagazhá, ni Najatetshi múldigaba kakbeyazhá guanakuashíñki, sha ajanashiji naziyapanazhá guane shalda kagatsaldakí naldaka. Ne kaigaga ni meja ‘ají múldigaba nukazhánuge nzha’ guagazháka nakna, sha ajanashane shalda kagatsaldiñga naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Akze, mieldeki nas aguldiyaldikuake, Najate jiaga aguldiñkaga naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nas kauwikenáñ ajanashaté atú guazhámak janshizhe atshazhá guanakuashíñki, sha ajanashiji naziyapanazháne shalda kagatsaldakí naldaka. Ne kaiga míñgaki sakí atshaté natú guanekue jiaga, nas kaguldiñkugamakga Najate jiaga kaguldiñka. ");
INSERT INTO kog_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Guatshak ekí zekldeki kauwijí guiyabak aksezhekldamak zexaldiamak ekí zegatuka. Ekí sezheklde: ‘Jinak kaguldiyanaka naldakí jiaga, kaguldiñkuge.’ ");
INSERT INTO kog_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","”Akze, Najatek zhinikga Alduna namaklde za ne miñgaunexaldixa miñgakaxaldatshak, eja na nas shalda namak za nawashekualdixa. ");
INSERT INTO kog_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ekíga na, kasak zhinik shi nagitiji nagapakualdabinuka nak, maiñ jiaga natuminamak minakuaxaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Duwe Jesúja ekí zʉñmejiñga na: “Ekí miñmeñkugéki, ‘¿jinák ekí nagisaldapanká?’ miñneshi alduna nazishabiñsá guamiñnegak na ekí miñmeñkú. ");
INSERT INTO kog_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Akze, nauwisaná na juizhaldexa miñkiyawatialdixa. Ne ezua ldiuwañ jiaga akldañkaldixa: Atshakna mieldeke mimakuaxa guatshak jiaga, ‘Jatek axazauwiñga sha atshikú’ me kakldexaldixa. ");
INSERT INTO kog_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Akze, Najate ‘me ne’ kaksʉ́ñzamakga, nas jiaga me naugé kaksʉ́ñ nogakna ekí sha mimakualdixa. ");
INSERT INTO kog_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jinake ekí zexaldixa miñmeyakí. Amak zegaté mituatshak, ‘ekí zexaldixa nalguák shibáñ ekí zʉñmeñgú’ be miñgisexaldiamak. ”Jejié ekí miñmeñkugéki kasak zhinikga ekí miñmeyazhánuge. Akbiñgaki miñgapakualdalga nokugák. ");
INSERT INTO kog_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kaiga zʉnake mokue Najate nakaxane nugeñka neyaldá na guapankú. Guatshak mieldeke ‘¿mashi maldeyaldixa nak shi ekí makuák?’ nakldukakí naldashibiná. ");
INSERT INTO kog_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ne ekí miñmeyaldatshak zhinik na agubisha itshaniñgaba miñgú. ");
INSERT INTO kog_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Guatshak naski namak ni miñmeñkú. Nas ne gualdatshak guana akldé janshibé mimijíki naldaldixa. Jinake naldakí. Nas neyakí naldaldikuake, Jatetshi Alduna miñgauneshi miñgapakualdaldixa miñkaldagazháka nak. Akze, neyaldikuák guana miñgakaxaldikue naldashá. ");
INSERT INTO kog_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","”Amak e naxaldinik na, káguba saldiñga sanákue sha ajanashixa nuxa aldé kelzʉtuñshaldixa. Ekí atshatogatshakna, jian izhogakuamak izhoxaki mielde ne kakldekshaldixa. Ekíga na, guiyaba tuakue axamiyaldaxaki mielde ne kakldekshaldixa. ");
INSERT INTO kog_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Akze, nas namak najañguazháldi naziyapanazháneñ zhinik na sha ajanashixa aldé kelzʉtuñshaldixa. ");
INSERT INTO kog_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ekíga na, jian izhogakuamak za izhokugek Najatek axaldeyaldatshak akldé natuabiñsáneñ zhinik na, jian izhogakuamak izhoxaki mielde ne kakldekshaldixa. ");
INSERT INTO kog_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ekibeñga na, jisé jai kagik sanegatukaki agatsaldi ne axeyaté guanéñ zhinik na, guiyaba tuakue axamiyaldaxaki mielde nuxa ne kakldekshaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","”Guatshak matshuwi miñmeyakue naxaldañga naldatshak, kaigabeñki auxa miñgajienazhákaga na mimatuñkú. ");
INSERT INTO kog_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Naldatshak Jatetshi Alduna namaklde za ne amak miñkaldaxaldinik na, saldiñga namaklde miñgajienaldiamak miñsanexaldixa. Akze, ejañga aldéñgaba jañgua guane miñwashekuazháldixa; egabá naldukajamak za miñwashekui na, sakí zexaldixa jiaga miñwashekualdixa. ");
INSERT INTO kog_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Amak múldigaba nagipanaldinik miñgajienaldiamak miñgaskaitshatogatshakna, nas akldé nakzamakga nakzukualdixa. ");
INSERT INTO kog_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Akze, Najatek akuauxa neki nas nakuega. Akna ‘e Aldunajañki múldigaba nagipanaldinik miñgajienaldiamak miñgaskaitshaldixa nakldá’ na miñmeñkuá. ");
INSERT INTO kog_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","”Mitsá zegagá akldé natuabiñsá gualdixa. Gualdinik jiak mitsá zegagá noxaldieñga mokue minatualdixaga. Akze, Najatekga axaldeyaldikue nak.” ");
INSERT INTO kog_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Duwe Jesúja ekí zʉñmeyatshakna shi kagitixakuañga ezuakuañki ataba atabañ ekí zhikldukaldá: —¿Ekí guagatshake ji guashi ekí guaká? “Mitsá zegagá akldé natuabiñsá gualdinik, jiak mitsá zegagá mokue minatualdixaga nakldá” jiak zʉñmeyatshak, “Najatekga axaldeyaldikue nak” zʉñmeñkáki ¿sakí guashi ekí guaká? ");
INSERT INTO kog_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","—zhikldukatoshiñga na: —¿Sakí guashi akldeshi shi ekí “mitsá zegagá” guak? “Jiga ni guak” muldetua zʉñnegakí nzha. ");
INSERT INTO kog_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Guakna Duwejañki akldukandana zʉñzegatuka zʉnatuñguák ekí zʉñmeyá: —Naski “mitsá zegagá akldé natuabiñsá gualdixa. Gualdinik jiak mitsá zegagá noxaldieñga mokue minatualdixaga nakldá” ¿miñmenuge shalda shi ekí mizhiklduká? ");
INSERT INTO kog_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Namakgaba miñmeyaldikue: Maiñki zʉxaita itshaniñgaba, mauwiñgaba guabinogatshak, kagik zhekue neyapanazhánekue zʉnake zeñ kakldexaldixa. Guatshak maiñki itshaniñgaba guabinoxaldinik zʉnake, ai itshanaga zeñ zaldak miñkizhbatexaldixa. ");
INSERT INTO kog_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Akze, munzhi somá guxaldiéñ ldiuwañ axakldañkatshake agubisha akzegapanka. Gualdinik somá axaldegatshak zʉnake, sakí jibañ tuatonaldixa akualdaksá zalda zeñ akldeka. Jinake naldakí. Kagik somá kuká guxá shalda. ");
INSERT INTO kog_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Amakbeñga na, kaigaki itshaniñgaba miñguapanaldinik, jiak mokue mimatualdatshak zʉnake, zeñ zalda miñzekaga ni meja minguxa akzegazháka naldaldixa. ");
INSERT INTO kog_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Atshak zʉnake ni ji akldé nakldukalga noxabináldixa. Akze, namakgaba miñmeyaldikue: Nas naldashiñga Najatek ji miyakshishaldiák, amak miñkatshaldixa. ");
INSERT INTO kog_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Jai yo nas naldashi ni ji akshishabínega. Kaiga zʉnake ekí akshishal minoxaldí. Ekí miyakshishaldiake amak miñkatshaldixa, ekíki muldetua miñgatsauxa zeñ miñnexaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","”Ekí ezuak zhinik za shi miñkaldiji nagatokuge naldatshak, akldé ekí agatsaldi shi miñkaldiyaldaksá guakue ldiuwañ akldañkaldixa. Atshak zʉnake, Najate “me ne” miñgajiená guashi me agatsaldi shi miñkaldiyapanaldikue. ");
INSERT INTO kog_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Atshakna nas naldashiñga Najatek saldiñga miyakshishaldixa. Ekí miñmeyaldatshake, nas mimitsaldí Najatek mimakbeyaldikueki miñmeyakí. ");
INSERT INTO kog_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Jinake naldakí. Nas minezhgajañguxake Najate ldesaxa zhinikga naklduge namak minajañguxa nakna, Najate aldéñ jiaga mimezhgajañguxa nak. ");
INSERT INTO kog_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Akze, naski Najate na izhokugeñka zhinik kagik naklduge, ne jiak mokue jai zhinik Najatekga axaldeyaldikue nzha. ");
INSERT INTO kog_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Zʉñmeñguake shi kagitixakuañ ekí akbeyá: —Kaiga zʉnake auxaga zʉñgajienazhákldegamak agatsaldi zʉñmeyagába, zʉñgajiená guashi me agatsaldi ni maldazʉñkazguák. ");
INSERT INTO kog_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ni mikldukakue juezhakí saldiñga mikuegaba katuatshakna, kaiga zʉna Saldiñga netshi Jatek zhinikga nakbaldamak ne ni kabajañgú. ");
INSERT INTO kog_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Guake Duweja ekí zʉñkiyó: —Ak zʉnake, ¿kaiga guana namak minajañguxá nukabaldá? ");
INSERT INTO kog_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","¡Be nogwíñ! Ezua ezua mimaldeñshatshak naski nahezua minabajaldixa zexaldiéñ zek na gu. Guatshak nahezua giemi abáñki guazháldikue. Akze, Najateki nas nañga izhogák. ");
INSERT INTO kog_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","”Ekí miñmeyaldatshake, nasldi mizhogéñ zhinik auxaga aldunaxa señgabá miñzexaldiamak na ekí miñmeñkú. Jai kagik sha ajanashéñ izhoxalga minoxaldieñgaki guiyaba tualga minoxaldixa. Naldatshak naski kagik sha atsha na nahauxak agubiyá guanuge nak, zhe zhikzukuagába alduna nazishalga za minoxaldí. ");
INSERT INTO kog_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Duwe Jesúja ekí zʉñmeyatogueniki jékaldeldi zʉtuaté noshi ekí Jatek akbeyá: “Najate, kaiga zʉnake atshál naklduge niuwi naxakldañká. Guakna Misukuá akldé nakzé nawatuñshabikuká ni gu. Ekíki akldé mikzé mawatuñshaldikuamak. ");
INSERT INTO kog_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mañki káguba kagik zhekuauxa naksuikualdaldiamak niuwi nagemalde. Ekíki saldiñga nají naldaldixa nagemaldekueki aldunaxa abisajañ izhoshiñga kezhokshaldikuamak. ");
INSERT INTO kog_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Abisajañ izhoshiñga izhoxaki ezuañgaba ma za na Saldiñga netshi Jate namaklde mizhogamakga, muldetua me maldé kakualdi izhoxa. Amakbeñga na, nas kekualdaldikuamak nakaxamalde jiaga muldetua me naugé kakualdi izhoxa. ");
INSERT INTO kog_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Naski jai kagik izhoxaldatshak, jiba nagemalde mixatshiji migisʉgakualdatshakna, ma za akldé mikzé mawatuñshi za izhogatokuge. ");
INSERT INTO kog_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Akna, Najate, kagi ni ji gauwagá maldogueñga zhinik ma na akaldak zʉñzé izhoxa naxaldanega, mokue kaiga mizhesaxa mixaldeyaldatshak, ekíga akaldak nakzé nezhashi makualdí. ");
INSERT INTO kog_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","”Najate, káguba kagik zhekue anuñkakueki nají aldaldaldiamak nagemaldekuek na mañki me maldé mu kagisekuatonuge. Ekueki mijíkue giemi nalgué, najíkue aldaldaldiamak nagemalde. Ekuega na, mijí múldigaba kakbeñkugamak mixatshiji aldagatuka. ");
INSERT INTO kog_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Guatshak atshaldikue nagemaldauxaki ma zhinikgaba naklde kaigaki muldetua kakwashék guane. ");
INSERT INTO kog_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Akze, mijí múldigaba kagaskaitshaldikuamak nagemaldeki kakbeyaldatshak iyapaná guane. Akna namak giemi mizhesaxa zhinikga nakldugamak kakwashegatshak, mañga nakaxamaldamak ne ajañguane. ");
INSERT INTO kog_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","”Najate, ekue shalda na mikbeyaldikue. Kagik zhekue nazipanazhánekue shaldaki mikbeyakí. Nají naldaldiamak nagemaldekueki mijíkuega nak, ekue shalda na ekí mikbeyaldikue. ");
INSERT INTO kog_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Akze, saldiñga nají agatsekueki mijígaba, jiak mijí agatsekueki najígaba. Ekueki naxapa aldeyatoguéñ, akldé nakzé nawatuñshi aldagatuka. ");
INSERT INTO kog_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Naldatshak naski mixaldeyaldá guapankugák, jai kagik izhoxalga nogazháldikue. Guatshak ekueki jaiga ashekualdaldixa. Akna Najate, sha atshabálde janshizhe maldé, kama nagemaldekga kagisaldi guakuak kabeshi makualdí. Ekíki ma na askimimé kizhogamakga, kauwizhéñgaba jiaga ekíga askimimé ishkaldaldi ashekualdaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Akze, naski kagapa izhoxaldatshake, kama nagemaldekga kagisaldazháldiamak numañ katuwi, kabeshi izhonuge. Nakna ni ezua, guiyaba tu za nogakueñka neyaldiamak migitshuaksha guazhánuge. Ezuañgabaki guiyaba tu za nogakueñka neyaldixa nalgué za na itshuizhá guane. Ekíki mijí múldigaba sezhekldamak zexaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","”Kaigaki mokue ma nugeñka mixaldeyapankugé. Naldatshak jai kagik izhokugeñgaki ekue shalda mikbeyatokuge. Ekíki nas zeñ zalda naxaldé, kauwizhéñ jiaga kaxaldaldi kagatsahauxa zeñ kakldexaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Naski mijí múldigaba kakbenuge nakiyapanatshak, kagik zalda neyapanazhánekuejañki kaguldiji. Jinake naldakí. Nas jai kagik zalda naldazhúgamakga, kagik zalda naldaksá guanekue nak. ");
INSERT INTO kog_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ekue shalda mikbeyaldatshake, kagik zhinik kagajuekua giemi guakue mikbejiñki mikbeyakí. Egabá ‘jiséja sha kakuí guakuak numañ katuwi makualdí’ mikbeyatokuge. ");
INSERT INTO kog_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Akze, nas kagik zalda naldazhúgamakga, kagik zalda naldaksá guanekue. ");
INSERT INTO kog_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Guatshak mijí múldigabaki namaklde nakna, eñkáñ amak mixajanashaldiamak kabagaunexaldí. Ekíki mijí giemikue, ma za mixazauñkakue ashekualdaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ma mixazauwaldikuamak kagik nakaxamaldamakbeñga na, nas jiaga ekue mixazauwaldiamak kagi nahauxa kakagatokuge. ");
INSERT INTO kog_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ekue shalda na nas misha nagatsauxa mixazauwi za izhoxaldikuamak akekuge. Ekíki namaklde kakualdi na, kauwizhéñ jiaga najanamé mixazauwi, mijí za aldekue ashekualdaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","”Guatshak jaldekue shalda zañki mikbeyakí. Ekuek zhinik nas shalda aldukatshak namak najañgui naziyapanaldixakue shalda juizhiñga na ekí mikbeyaldikue: ");
INSERT INTO kog_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Najate, ma nasldi mizhogatshak jiak nas mahaldi izhokugamakbeñga, kauwizhéñgaba jiaga ekíga askimimé ishkaldaldi ashekualdaldiamak. Ekíga na, ekue jiaga nasʉñldi ashekualdaldiamak. Ekíki kagik zhekuekueja ma nakaxamaldamak ne ajañgualdiamak. ");
INSERT INTO kog_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Akze, mañki akaldak mikzé nalda nasldi izhoxaldixa nagemalde ne, jiak nas zhinik ekuek kagenuge. Ekíki nasʉñ askimimé kizhogamakbeñga, kauwizhéñgaba askimimé ishkaldaldi ashekualdaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Akna naski kauwizhéñldi izhoxaldatshak jiak, mañki nasldi mizhoxaldixaga. Ai zhinik na auxaga askimimé ishkaldaldi ashekualdaldieñka agaldañkaldiamak. Ekíki kagik zhekuekueja ma nakaxamalde ne kakwashexaldiamak. Ekíga na, nas maldezhgajañguamakbeñga nepananekue jiaga kezhgajañguamalde ne kakwashexaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","”Najate, nají nagemaldekueki mashi izhoxaldikuake eñka nas na izhogakue ni kajañgukú. Ekíki kagi ni ji gauwagá maldogueñga jiaga maldezhgajañguxa nalguák akaldak nakzé nalda nagemaldeki atuál aldoxaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","”Najate, jian atshakuamak za matshixa maldé, káguba kagik zhekue neyapanazhánekueki ‘me nzha’ kaksʉ́ñze maldé. Naldatshak nas zʉnake me maldé nakualdi noxabalduka. Akna nagemaldekuejañki nakaxamaldamak ne kakwasheklde. ");
INSERT INTO kog_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ekuek na muldetua me maldé kakwashekuanugamakga akldeñga kakwashekual noxaldikue. Ekíki sakí agatsaldi maldezhgajañguxakga na kauwizhéñ ataba atabañ ajañgual aldogatshakna, nas jiaga kauwizhéñldi izhoxaldikuamak.” ");
INSERT INTO kog_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Duwe Jesúja Jate ekí axazguagueniki, shi kagitixakuañ juizhi Jeldusaldéñ zhinik akzʉxaitiñgueniki kaguldu Seldúñ akbategueni uniñkauwa tezha kaldi oldibu xaldeldi ne. ");
INSERT INTO kog_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Exaki Duwe zʉnauldeyeñkaga nalguakna Juda Duwe gegatoxéja mashi ze akualdiñga nakldoxá. ");
INSERT INTO kog_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ekí akualguakna Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, paldiseyukue na aldaldi kabu axaxanekue, matshuwi suldáukue juizhi, muñshí pulkakue kaksui, jik awabiyaldixa kaksuikuegaba itshe exa kauldé. ");
INSERT INTO kog_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Guatshak Duwejañki sakí agatsexaldiauxa akualdi na, kakldabixal neñguenik ekí kaklduká: —¿Me shi niyabipán? ");
INSERT INTO kog_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Guñguake: —Jesú Nasaldéxa zalda na niyañkaldók. Akuaguake: —Ake, nas na ai naldiñga nakú. Guatshake Juda Duwe gegatoxé jiaga aldakldekue juizhi na akldoxá. ");
INSERT INTO kog_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ekí akldoxekueki Duweja “nas na ai naldiñga nakú” guagatshakna, kutámga uñguexagaba na kapená. ");
INSERT INTO kog_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Guñguake Duweja mokue kaklduká: —Ne, ¿me shi niyabipán? Guake akiyayó: —Jesú Nasaldéxa zalda na niyañkaldók. ");
INSERT INTO kog_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Guake kakiyó: —Aguana, nas na ai naldiñga naugé miñmeyashakú. Nas naldiyabinogák zʉnake, ake, jalde nagapakuekueki shaldejí. ");
INSERT INTO kog_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Guatshake aldéñga “Najate, nagemaldekuega ni ezua migitshuaksha guazhánuge nzha” guaklde zexaldiamak na ekí guaxá. ");
INSERT INTO kog_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Guatshake Simóñ Pégulduki shezhá axaldalgué ishkakldugueniki, Jatek múldigaba agaskaitshixa akldé akzetshi nashi agisalshiñga tuan kuxa jibatshaldi mual axabeñguá. Ai nashiki Malko axezhuka na naldá. ");
INSERT INTO kog_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Guñguakna Duweja Péguldu ekí axaldék: —¡Shezhá mexa guatogwá! Najatejañga guiyaba atemajañ tualdikue najañguá guane ne, ¿amak axatshazhá shi gualdikue na? ");
INSERT INTO kog_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Guñgueni suldáu aksanekaja, ají nashikue, juldiú sanekakuetshi kabukue juizhi, Duwe Jesú akugueniki guldak ishkaldiyá. ");
INSERT INTO kog_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Akuñgueniki Anás tshuxa misha awaldé. Akbiñgaki eñki Kaipástshi ajuazgui naldák. Kaipás na ai kagiañki Jatek múldigaba agaskaitshixa akldé akzé na izhoxá. ");
INSERT INTO kog_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Guatshak Kaipásjañga na juldiú sanekakuek ekí aksanekldane: “Saldiñga nauwisanákue shuigakue zeshi guakuake, muldetuañki ezuamé guana saldiñga tsaldi shuigakue zaldashá.” ");
INSERT INTO kog_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Exa awaldeyatogatshake Simóñ Péguldu, nas nañki alduxan Duwe Jesúk agapa na kaldeyá. Naski Jatek múldigaba agaskaitshixa akldé akzeki natuñka nalguakna, ajúk kaldagatshake Duwek agapañga juldi jubaldaxa jueyáñ zeñka juldú. ");
INSERT INTO kog_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Guatshake Pégulduki julduneñka me abane nalguake, sáñkalda natuñka nalgueki mokue kualdi, munzhi juldunéñ numañ zʉtuñka axazguagukuake, Péguldu juldukshá. ");
INSERT INTO kog_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Guakna munzhi juldunéñ numañ zʉtuñkaja ekí axaldék: —¿Ma jiaga ejié sigík shi magitixa naldabálde shi na? Guñguake: —¡Miya! Ai naldazhúge nakldá. ");
INSERT INTO kog_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Guatshak sui zegatoxakna guksé ajuine stak sáñkaldatshi nashikue, kabukue juizhi akuañgualdék akteté aldogatshak, Péguldu jiaga ekue nañga guañgualdék akté na noxá. ");
INSERT INTO kog_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Guatogatshake Jatek múldigaba agaskaitshixa akldé akzejañki nasʉñ shi kagitixakue shalda, ji shizhixa shalda Duwe Jesú akzʉzukaldá. ");
INSERT INTO kog_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Akzʉzukatshakna Duwejañki akiyó: —Naski saldiñgaja natuakldegéñ shizhiji, juwí kishjuizhaldegeñka, juwí Jate axazakuagaldi nauwisaná saldiñga ajuizhaldeklde ashé noguéñ shizhiyatonuge, ni ziñ me shizhiyatogazhánuge. ");
INSERT INTO kog_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Akna eñka sakí guagaté naldukatonekuek guana akldukakue. Ekuejañki ji guakldugauxa kakualdiñga nogashá. Ne ¿jinak shi nas maldaklduká? ");
INSERT INTO kog_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ekí akiyokuatshakna kabu aldesañ akldoguejañki kaxak akldabikshi ekí axaldék: —¿Tukí shi Jatek múldigaba agaskaitshixa akldé akzé akiyokuakueki migatsá? ");
INSERT INTO kog_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Guatshakna Duweja: —Jiki guagasʉ́ñzamak guakugake, nakbeya guakue naldashá. Akze, guagakuamak guakugake, ¿jinak shi ekí maldakldabikshí? ");
INSERT INTO kog_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Guñguake Duwe guldak ishkaldiyanamakga Anásja Kaipás ai kagiañ Jatek múldigaba agaskaitshixa akldé akzé naldék akuzgauwá na gua. ");
INSERT INTO kog_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Guatogatshake Simóñ Pégulduki guksé ajuine stak guañgualdexalga akté noguéñ, ekí agazalduká: —¿Ma jiaga ejiék shi magitixa naldabálde shi na? Guñguake tuazhé guashi na: —¡Miya! Ai naldazhúge nakldá. ");
INSERT INTO kog_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Guake sáñkaldatshi nashi, kuxa axabeñguane zhgajajañga ekí axaldék: —¿Ma oldibu xaldaxa e na matunuge naldazhé sha? ");
INSERT INTO kog_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Guñguake jiak mokue “tuazhúge nzha” guagatshaga na, gayu kauldá na gua. ");
INSERT INTO kog_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Guñguenik Duwe Jesúki Kaipás nugeñka iyaldañgashiñgueni, exa zhinik Alduma zalda sáñkaldaja sanexaldixa itene tshuxa muñshaga awaldé. Exa awaldeyatshak, juldiú sanekakuega sáñkalda tshuldi ajuldunazhá. Akbiñgaki ai zhinik nuxa nusa ishkazakuane, Jateja nauwibamakue san kagixa guiyaba atuwi ashekualgueñka zhinik kakzʉxaitshanéñ be kizhgisekué ldiuwañtshi gakue gazhá guakue kagatseshi guakuak. ");
INSERT INTO kog_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Guñguake ai sáñkalda Pildatu akzʉxaitiñguenik ekí kakzʉzuká: —Naldé, jalde sigíki ¿ji shaldaga agatsé tuwi zhinik shi minakizhañkashí? ");
INSERT INTO kog_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Guake ekí akiyayó: —Jejié shane naldazhé guashiñki, míge guazhá guatañkaldaldé naldashá. ");
INSERT INTO kog_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Guñguake kakbeyá: —Guake, maiñga ulde xaldeki mimijí guiyabaja guagamak tuakue miñgatsaldashá. Guatshakna ekí akiyayó: —Guatshak nasʉñ juldiúkuañgaba ni me guiyaba tuñshi guaxa atsha niuwi zʉñgexabíne naldashá. ");
INSERT INTO kog_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Guatshake Duweja aldéñga sakí agatsaldi shuixaldixa guakldane zexaldiamak na ekí zexá. ");
INSERT INTO kog_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Guñguake Pildatuki mokue juldungueni Duwe akuldaxal guaguenik ekí aklduká: —Guake, ¿ma shi juldiútshi sáñkalda akldé mikzé maldá? ");
INSERT INTO kog_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Guake Duweja: —¿Mañgaba mikldek shi ekí maldaklduká? Azhí ¿axautshikueja ekí migabeñkuge nak? ");
INSERT INTO kog_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Guake Pildatujañki: —Ne ¿naski juldiú saná naugák shi ekí jañgualdikue maldatú? Misaná juldiúkuega, mimijí Jatek múldigaba agaskaitshixakuetshi sáñkaldakue na aldaldi guana maxeshi nakualdakbalde naldashá. Ne, ¿jiñ mishkuldiñgué? ");
INSERT INTO kog_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Guake Duwejañki: —Nas sanekugeki jai kagik atuakldegéñ zalda naldazhé. Akze, jai zalda naldiñguashíñki, nají nashikueki juldiú sanekakuek nagaxeshi guakuak axaukshaka naldashá. Ne, nas sanekugeki jai zalda naldazhé nakldá. ");
INSERT INTO kog_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Guake Pildatuja: —Ak zʉnake, ¿ma sáñkalda akldé mikzé maldé nukabaldá? Guake Duwejañki: —Akze, mañga ai naugé nakuák guashibaldá. Naski jinak kagik kukanuge naldakí. Namaklde nakuahamak ne guaxal guana kagik naklduge. Akna saldiñga namaklde kakualdi amak izhukakueki nají múldigaba naxaldukaxakue nakldá. ");
INSERT INTO kog_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Guake Pildatujañki: —Ne, ¿ji shi “namaklde” naldakaki makuák? Ekí guagueniki mokue akzʉxaitiñguenik juldiúkuek ekí kakbeyá: —Nasga ejié sakí sha atshane agatsaldaka tuakí nzhakú. ");
INSERT INTO kog_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Azhi ne, maiñ nañki ekí zañga katshixa, kagi akldañkajauxa jalde mimijí akzé ldiuwañki ezua paldesu nuka miñkibesa gakuxa. Akna ¿ai mimisanátshi sáñkalda akldé akzé akuaka miñkibesa guakue shi minajañgú? ");
INSERT INTO kog_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ekí aldukatshakna jiak saldiñgaja agaxauldi ekí akuák: —¡Tuejiéga zʉñkibesabaldáldi! ¡Baldabá guana zʉñkibesa guwá! Guatshak Baldabáki sáñkaldak agubiyaldiamak kaukshixa na naldá. ");
INSERT INTO kog_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Guñguenik Pildatujañki Duwe Jesú ulde xaldeki kuizhushak akldabikshal guak. Guñguake amak akuñgueniki, ");
INSERT INTO kog_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","suldáukueja sáñkaldakueja sáñkaldak izhalshuxa tuñgatse kausúga zhikba zhikba axaxauweni iyajiú. Gueniki Duwe aguáñ izhabashiñga sáñkaldakueja zhakuá atsʉshi maksʉxaldá agatsé itshualdiyamak agatsé iyajualdiñgueni, ");
INSERT INTO kog_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","asták axaldagueni ekí axaldék: “¡Juldiútshi sáñkalda akldé mikzé, zeñ shi mikldeshí!” axaldeshi na waxa axabugatoxá. ");
INSERT INTO kog_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Guñgueni Pildatu juldunalgueni mokue akzʉxaitatshak juldiúkuek ekí kakbeyá: —Tu guwíñ. Miñkuldagaté na nokú. Ekíki ejié sakí sha atshane agatsaldaka tuakí naugé mitualdiamak. ");
INSERT INTO kog_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Guñguenik Duwe kausúga zhikba zhikba axaune sáñkaldak iyajiune, zhakuá atsʉshi maksʉxaldá agatsé iyajualdine akskaitatshake, Pildatuja ekí kakbeyá: —¡Tu guwíñ, jejié sigí! ");
INSERT INTO kog_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Amak atuatshaga na, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue, kauwijí kabukue juizhi jaldáñ axauldi ekí akuaxaldá: —¡Kaldixa axaldiya guaxa guwá! ¡Kaldixa axaldiya guaxa guwá! Guatshakna Pildatujañki: —Guake, ¡maiñ kaldik axaldiya guaxa guakueki tuakí miné! Akze, nasga sakí sha atshane agatsaldaka tuakí nzhakú. ");
INSERT INTO kog_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Guñguake jiak ekí akiyayó: —Nasʉñ sanáke ezua guiyaba zʉñkaldega. Aija guagamake, ejiéki Saldiñga netshi Jate aguáñ izhbashi mual “naski Jatetshi Asukuá na nakú” neka nakna shuigakue agatsé. ");
INSERT INTO kog_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pildatuja ekí nukatshakna akldé zhe akzeshi na, ");
INSERT INTO kog_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Duwe mokue juldukshiñguenik aklduká: —Ne mañki ¿man zalda maldé matú? Guatshak Duwejañki akiyokuazhá ");
INSERT INTO kog_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","guakna ekí axaldék: —Guake, ¿nakiyokuabaldáldixa ne maldúk? Akze, nas guana kaldik maxaldiya makuaxa guakue azhi mibesa guakue niuwi gexa naxaldé, ¿miksʉ́ñ nak shi anuñké maldakú? ");
INSERT INTO kog_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Guake Duweja akiyó: —Guatshak Jate jékaldaxa izhukajañga niuwi migegazháne guashíñga, ni sakí nakuá guashi niuwi mixaldaldazháka naldashá. Ekí nakna, guiyaba maldatuñshaldiamak nakene guana mizhakldeñga sha atshane agatsé nakldá. ");
INSERT INTO kog_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Atshak zhinik na, Pildatujañki Duwe miya zhiniki iyakbe gualdiamak niyatshak jiaga, juldiú sanekakuejañki axauldi ekí akuák: —¡Ejié iyakbe makualdiák guashiñki, Aldumatshi sáñkalda akldé akzetshi apebu naldabálde naldiñga ekí matshaldixa nzha! Akze, mieldeki “sáñkalda nakzé nzhakú” negatshake, sáñkalda akldé akzé aguldiñka naldashá. ");
INSERT INTO kog_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ekí akuagaté nukañguakna, Pildatuja Duwe mokue akzʉxaitshal guagueniki agatsé ne axezhaxaldieñka yaté. Aiga na ebeldeyuke “Gábata” kakuagatshake, “jakuakuegaba sezhekldéñ” axezhogeñka. ");
INSERT INTO kog_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Guatshake Jateja nauwibamakue san kagixa guiyaba atuwi ashekualgueñka zhinik kakzʉxaitshanéñ ldiuwañ be izhgisekui gakaxa janaktuakué ldiuwañ na zaldá. Zaldéñ na, anuñka niuwi muanté jana zegatoguéñ, Pildatuja ekí juldiúkuek kakbeyá: —¡Mimijí sáñkalda akzé jai tiuwi! ");
INSERT INTO kog_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kakbeyatshakna axauldiñga ekí aldék: —¡Zʉñgajuekua, ulde nuxa guatogwá! ¡Kaldixa axaldiya guaxa guwá! Guake Pildatuja: —Ne, ¿mimijí sáñkalda akzé shi kaldik axaldiya guaxa guapankú? Kakbeyatshakna Jatek múldigaba agaskaitshixakuetshi sáñkaldakuejañki: —Aldumatshi sáñkalda akldé akzé za sáñkalda zʉñnogashá. Ni exa zhinikga mokue ezua zʉñnukaga naldakí ni naldatók. ");
INSERT INTO kog_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Guñguák zʉnake kaldixa axaldiya akuaxaldiamak kakiyakbeguake, suldáukueja awaldé na gua. ");
INSERT INTO kog_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Duwe Jesú awaldeyatshak aldéñga axaldiya akuaxaldixa kaldi agashane kuíbulduk akzʉxaitiñgueni, “káguba tsáñkalda zaldáxalda” axezhogeñka na neyá. Exaki ebeldeyuke “Gólgota” akuaka. ");
INSERT INTO kog_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Exa neyatshake kaldik axaldiyá. Ekí akuatshake, e nañga mozhua akuaxaldixa nalguekueki ezuañki atabañ, ezuañki atabañ mual axaldiyatshak, Duweki muan nek na axaldiyá. ");
INSERT INTO kog_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Guatshake Pildatujañki jinak shuigakue agatsé guashiñga akzukue gauwal guagueniki, Duwe kaldixa axaldiyane asáñkaldake ekí guashi agazuñguane axaldiyal guak: “Jejiéki Jesú Nasaldéxa zalda juldiútshi sáñkalda akldé akzé nakldá.” ");
INSERT INTO kog_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Guatshakgaba Duwe axaldiyaneñkaki kuíbulduk akyó zalguakna matshuwi juldiúkueja sakí guashi agazuñguane azakuakshá. Guatshake maigua zukuaxak axauwane: ebeldeyuk, aldatín, galdieguk. ");
INSERT INTO kog_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nalguakna juldiúkue Jatek múldigaba agaskaitshixakuetshi sáñkaldakuejañki Pildatuk ekí agabeyal aldé: —“Jejiéki juldiútshi sáñkalda akldé akzé nakldá” akzuñguagábaki ekí yushakue: “Jejiéki ‘Juldiútshi sáñkalda akldé nakzé nzhakú’ neka nakldá” guashi akzuñgual guak guatogwá. ");
INSERT INTO kog_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Guakna ekí kakiyó: —Sakí akzuñgual guaklduge nake, auxabeñga abá gualdixa nakldá. ");
INSERT INTO kog_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Guatshake suldáukuejañki Duwe kaldixa axaldiñgueniki, ají zhakuá abakaldak ijuakue nalgué iyajuineki akugueni maxáiñtaba izhatuldí, makaiwa aldalguekueja ezua ezua iyapanaldiamak. Guatshake ají zhakuá giemi iyajuineki azbuamé tiñ sezheklde, miya zhiktuldindana agatsaldazhé ");
INSERT INTO kog_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","naldakna ekí ataba atabañ izhgabeyá: —Eñki nusakuañkaldáaldi. Egabá mieldeja ipanaldixa atuakualdiamak aldiya kuizguí. Guatshak Jatetshi múldigabak sezhekldamak zexaldiamak na ekí zexá. Ekí sezheklde: “Nají zhakuá abakaldak nazijuakueki ishkiyapana akuatshake nají zhakuá giemiki mieldetshi naldaldiamak aldiyá” sezhekldamak na suldáukue ajanashá. ");
INSERT INTO kog_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Guatogatshake Duwe axaldiyaneñka munzhi akldoxekueki, ezuañki Duwetshi ajaba, ezuañki etshi akaja giemi, ezuañki Maldiya, eñki Kaldepatshi asewá, ezuañki Maldiya Makldalda zalda na akldoxá. ");
INSERT INTO kog_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nogué na, Duweja ajaba tuatshake, nas shagitikuge nezhgajañguxak jiaga e na akté natuñguake, ekí ajabak akbeyá: —Jaba, misukuá jana naldaldixaki tuaiga tiuwi. ");
INSERT INTO kog_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Akbeñgueni nas jiaga ekí nakbeyá: —Mijabaki tuaiga tiuwi. Nakbeñguake atshak zhinik najaba jana nas na izhoxaldiamak ipaná guanuge. ");
INSERT INTO kog_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Guñgueniki Duweja saldiñga atshakue agatsalguauxaki isʉgakuá guane akualguakna, Jatetshi múldigabak sezhekldamak zexaldiamak ekí guak: —Ni naklduna ni gu. ");
INSERT INTO kog_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Guatshak astakga muksúk kuis kuis akzeldia jialda akualgué, ezua samnek agaldaksheniñki abaldaxájañ agatsék iyajiu, kaxak iyó agaxáu. ");
INSERT INTO kog_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Guñguake Duweja amak tugueniki ekí guak: —¡Atshakue nagatsauxa isʉgakuá ni gukú! Guagueniki jie atshiji ají alduna Ajatek agegatshake shuizhá na gua. ");
INSERT INTO kog_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Guatshak ekí zegatogatshake jika janaktuakue ldiuwañga zaldakna, tuañ zegatshake kizhiksekué akzé ldiuwañ zexaldá gualdixa na naldá. Akna ai ldiuwañ agazaldakuazháldiamak juldiú sanekakueja kaldixa axaldiyanekue ashuixaldiamak kalda kagishuñguakue Pildatuk niuwi gegakue axashishá. Ekíki tuañ zegagáñga shuanekue kaldixa zhinik axajieñgualdiamak. ");
INSERT INTO kog_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Amak niuwi geguake, suldáukuejañki Duwe kaldixa axaldikualgueñkaga axaldiyanekue ezua ezua amak kalda kakiyashuñguá. ");
INSERT INTO kog_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Guñgueni Duwe ldesañ aldagatshak, e zʉna shuizhá guane atuñguake kalda akiyashuñguazhá. ");
INSERT INTO kog_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Guatshak jiaga ezua suldáujañki ají sʉzak tezháxaldak akldeñshatshake ubañga abi, ni nañga akzuldá. ");
INSERT INTO kog_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ekí miñmeñkugeki nas naldi tunugauxabe namaklde za ni miñmeñkú. Namaklde guakuge nakualdi na, maiñ jiaga Duwe Jesú namak mijañgualdiamak na ekí miñmeñkú. ");
INSERT INTO kog_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Akze, ekí zekldeki Jatetshi múldigaba sezhekldauxabe zexaldiamak zeklde: “Ega ni ezua zaldáxalda akiyashuñgua guazháldixa.” ");
INSERT INTO kog_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ekíga antezhak jiaga sezheklde: “Sʉza agaldeñshaneki kauwijí ubak naldi atualdixa niyó.” ");
INSERT INTO kog_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ekí zegatogueni ezua sigí Jusé, kuíbuldu Aldimateyaxa zaldajañki Duwe Jesútshi abuá mexaldiamak sáñkalda Pildatuk niuwi akshishá. Guatshak ejañki Duwe namak jañguxa naldatshak, juldiú sanekakue zhe akzukuñguakna ni meja aksʉ́ñ ekí izhuka na naldá. Naldé na, amak Pildatuja niuwi ageguake, neñgueni Duwetshi abuáki gugueniki uldé na gua. ");
INSERT INTO kog_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Guatshake Nikudemu, atséñ zalguéñ Duwe axazguaxal nakldane jiaga nak. Ejañki ezua we juma izhuka “milda” na “aldué” na ishkajiune matshuuwi uldák. ");
INSERT INTO kog_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Guñgueni juldiúkuejañki abuá abexaldixa siyagaxauwamakga, mozhua aldaldi Duwetshi abuá gugueniki zhakuá tiñne janshagatsek abañguatogatshake, we juma izhuka iyabeshi na abañguatoxá. ");
INSERT INTO kog_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Guatshake Duwe kaldixa axaldiya akuaxané baxañga jika xaldeldi shuanekue abexaldixa abisa, ni me abegagáldega noxakna, ");
INSERT INTO kog_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","akyó me eñkaki zaldakna Duwetshi abuá exa abexá. Jinake naldakí. Juldiúkueja saldiñga janaktuwé ldiuwañ zʉxaitiñga guapanák. ");
INSERT INTO kog_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Guñgueni kizhiksekué ldiuwañ zʉxaitatshak abokualdi dumiñkuke zhe me muñzegapanatshake, Maldiya Makldalda zaldaki Duwe Jesútshi abuá abexaneñka ne. Exa neyatshake, jagi saldáñ pakue atema juldunéñ agayone nalgueki axajuekua guane tu. ");
INSERT INTO kog_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Guñguake naldajiñga neñguenik, Simóñ Péguldu na Duwe shagitiyatonuge nezhgajañguxa na kizhogueñka naguenik ekí zʉñmeyá: —¡Nauwijí Sáñkaldatshi abuáki abexaneñka zhinik awaldé! Gueniki ¿mani awaldene skandá? ¡Tuazhá ni gakuá! ");
INSERT INTO kog_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kaldukañguake Péguldu na abuá abexaneñka ne. ");
INSERT INTO kog_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Amak izhgapa naldajiñga kaldeyatshak, agubiñgukueni aksajañga exa ne. ");
INSERT INTO kog_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Guñgukueni juldunagába, jie eni akzʉtú gualdatshake, zhakuá Duwe abañguanane za na duwá tu. ");
INSERT INTO kog_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Guatshak Simóñ Pégulduki nazhaldiwan naguenik jian eni juldú. Juldunatshak zhakuá zañga na duwá tuatshake, ");
INSERT INTO kog_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","paniuwizhu sáñkaldak agabananeki atezhak sangaba zhikpaksʉnane duwá tu. ");
INSERT INTO kog_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Guñguake aksajañga nakldugek jiaga juldu, muldetua tualdatshake “izhgatenamakga nakbatú” nakldék. ");
INSERT INTO kog_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Akbiñgaki Duwe shagitiyatoñkaldekuañ Jatetshi múldigaba sezhekldeja Duweki shuixaldinik izhgaldagakuega zaldaldixa guaka zʉñgajienagá noguák. ");
INSERT INTO kog_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Guñgueni shagitiyatoñkaldekuañki mokue juldi ne na kakuá. ");
INSERT INTO kog_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Guatshake Maldiya Makldalda zaldaki exa abexaneñka jugatezhaxa akldoshi, mauwiñgaba eni Duwe abexanaldi jie akzʉtú. ");
INSERT INTO kog_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ekí akzʉtuatshake, mozhua Jateja guaklde uldeñkakue zhakuá abutshi ijuakuekue Duwetshi abuá gekuanéñ, ezuañki sáñkaldeldi, ezuañki kasaldi mual iteté tu. ");
INSERT INTO kog_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ekueja aklduká: —Munzhi, ¿jinak shi ekí mauwabaldók? Guñguake kakiyó: —Akze, nají Sáñkaldatshi abuá awaldé guane, ¿mani awaldene skandá? ");
INSERT INTO kog_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ekí guagueniki me stuatshake, Duwe Jesú ai akté nogué, “ega shakldá” akldegazhá. ");
INSERT INTO kog_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Gueni Duweja ekí aklduká: —Nabunzhi, ¿jinak shi ekí mauwabaldók? ¿Me niyabalduka sha? Guatshakna “aldéñki jai jika xalda numañ tuñka nuxa nindá” akldeshiñga ekí akbeyá: —Azhi ma ají abuá uldemalde nake, mashi uldemalde nakbeya guamaldake guxal nenaka nzha. ");
INSERT INTO kog_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Akbeyatshakna Duwejañki: —Nabunzhi, Maldiya. Axaldeguake tualdiamak izhbateguenik ebeldeyuk ekí axaldék: —¡Aldabuní! Guagatshake “shi maldaxaldixá” guashi. ");
INSERT INTO kog_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Guake Duweja ekí akbeyá: —Káuxalda nepañguagába. Najate nugeñka nitshigagá nokugák. Akna shaxaldiyatonuge nakaja giemi nekldekue nugeñka maldeyaldini ekí kabakbeyaldí: “Saldiñga netshi Jate axazauñkugega jiak miyaxazauñka, Najatega Mimijate nugaldi ni nitshikú.” ");
INSERT INTO kog_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Guñguake shagitiyatoñkaldekuañ katshekualguéñ nagueniki “¡Nauwijí Sáñkalda Duwe Jesú naldi ni tuñkuá!” zʉñmeji, akbenamak jiaga zʉñmeyá. ");
INSERT INTO kog_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Guñguenik ai dumiñku ldiuwañga tuañ zegueni, shagitiyatoñkaldekuañki juldiú sanekakue zhe zʉñzukui juwí ishkaldiyañkaldekue zhe kaldogueñga, Duwe Jesú naldiñga nauwikenáñ zʉñkizhañkaji ekí zʉñmeyá: —¡Aldunaxa señgabá shi miñzeshí! ");
INSERT INTO kog_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ekí zʉñmeñgueni káuxalda kaldabu akldenéñ, tezháxaldak sʉza agaldeñshanéñ zʉnatuñshá. Ekí katuatshakna, “¡Nauwijí Sáñkalda naldiñga nakbatú!” zʉñneguakna zeñ zʉñneshiñgaba na gua. ");
INSERT INTO kog_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Guñgueni jiak mokue ekí zʉñmeyá: —¡Aldunaxa señgabá shi miñzeshí! Sakí Najate axazauwaldikuamak nakaxanamakbeñga nas zhinik ni mimakakú. ");
INSERT INTO kog_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Guñgueni zʉnajuishi ekí zʉñmeyá: —Jatetshi Alduna miñsanexaldiamak ipana guwíñ. ");
INSERT INTO kog_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mieldeki sha atshane axabeta miñgualdiák, axabetanega naldaldixa. Azhi mieldeki axabetakí minaldaldiák, axabetazhánega naldaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Guatshak Duwe Jesú aldéñ shagitiyatoñkaldekuañ zʉñkizhañkatshak, Tumásga “Shpa” kaxaldeka 12 nasʉñ nañga agatséki izhogazhá. ");
INSERT INTO kog_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Guane nalguakna ekí akbeñkalde: —¡Nauwijí Sáñkalda Duwe Jesú naldi na katuñgú! Kakbeyatshak ekí zʉñkiyó: —Guatshak naski káuxalda kaldabu akldenéñ tu gualdatshak nají káuxalda buldu eñ julduksha, tezháxaldak sʉza agaldeñshanéñ nají káuxalda julduksha tu guakí naldaldikueniga namak jañguazháldikue nzha. ");
INSERT INTO kog_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ekí Duwe zʉñkizhañkañgueni ábigua ldiuwi zegatshake, Duwe shagitiyatoñkaldekuañ mokue kajuizhaldegatshake, Tumás jiaga nasʉñ nañga na izhoxá. Atshak juwí ishkaldiyañkalde, aldiñgaba zhe kaldoguéñ, Duwe Jesú naldi nauwikenáñ zʉñkizhañkaji ekí zʉñmeyá: —¡Aldunaxa señgabá shi miñzeshí! ");
INSERT INTO kog_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Guñguenik Tumás ekí akbeyá: —Nak xaldeki mijí káuxalda buldu jai káuxaldak kaldabu nakldenéñ natu guwá. Ekíga na, mijí káuxalda tezháxaldak sʉza nagaldeñshanéñ julduksha guwá. Naldiniki akldé mozhua mozhua mikldegagábaki, namak alduna nesha guwá. ");
INSERT INTO kog_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Guñguake ekí akbeyá: —¡Nají Sáñkalda, Saldiñga netshi Jate, Najate naldiñga ni maldá! ");
INSERT INTO kog_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Guatshakna Duweja ekí akbeyá: —¿Nas natu makuák nuxa shi namak maldajañgú? Akze, mieldekueki natuakíñga jiaga namak najañguxakueki zeñ naldaldixakue nzha. ");
INSERT INTO kog_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jai kaltak Duwe Jesú atshanauxa gauwazhánuge. Akze, aldéñ shagitiyañkaldoguéñ akldé matshuwiñga aldéñ “me ne” awatuñshaldiamak ajanashaté atú guazhámak janshizhe atshane. ");
INSERT INTO kog_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Naldatshak jai sezhekldekueki jinak sezheklde naldakí. Ekíki “Duwe Jesúki Jatetshi Asukuága, aldéñ zʉnekualdal zʉñgakaxaldixa guakldanega nzha” mijañgualdiamak. Ekíga, “Duwe Jesú nekuanamak shakldá” jañgui mipanatshakna, aldéñ zhinik aldunaxa auxabé miñzukui izhoshiñga izhoxabipanaldiamak. ");
INSERT INTO kog_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ekí zegueni kuíbuldu Tibeldiatshi niwa xezhaxa Duwe Jesúki shagitiyatoñkaldekuañ mokue ekí zʉñkizhañkane: ");
INSERT INTO kog_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Shagitiyatoñkaldekuañgaba Simóñ Péguldu, Tumásga “Shpa” kaxaldeka, Natanahél Galdildeya baxe Kanáxa zalda, nasʉñ Zebedeyutshi asukuákuañ, mokue mozhua nasʉñ na agatsekue nañga kizhogueñki, ");
INSERT INTO kog_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simóñ Péguldujañki ekí zʉñmeyá: —Pikáu guxal nzheñkú. Guñguake: —Ake, nasʉñ jiaga ma na neyakualdixa nzha. Gakuagueniki niwaxa kaldeñgueni kanuwakgaba kajuldungueniki, pikáu za niyá kaldogatshak jiaga, ai siañki ni ezua gugazhá. ");
INSERT INTO kog_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Gakuñguenik zhe muñzegapanatshake, Duwe Jesúga niwa xezhaxa izhañkatshak jiaga, “ega nzha” zʉñnegazhá. ");
INSERT INTO kog_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Guatshak ekí zʉñmeyá: —Nasukuákue, ¿pikáu gugazhámine naldazhé? —Gugazháñkalde nzha. ");
INSERT INTO kog_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Guake ekí zʉñmeyá: —Jibatshaldi mual zhemá aguteya guwíñ. Ekí miñgualdiake guxá miñgualdixa nzha. Zʉñmeñguake amak kaguteñguenik, pikáu agubisha guxane naldák, kanuwaxa ibeksha zʉñzegazhá. ");
INSERT INTO kog_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Guakna Duwe shagitiyatoñkaldekuañ nezhgajañguxake Pégulduk ekí akbeyá: —¡Uñkuejié nauwijí Sáñkalda tiuwi nakzék! Ekí Duwe Jesú ne nukatshakna, Simóñ Pégulduki pikáu guxaldiamak zhakuá itshuinalgué itshualdiñgueniki Duwe nugeñka neyaldiamak nixa iyawateyá. ");
INSERT INTO kog_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Guatshake niwa xezhaxa neyaxañki anuñka 50 gulda nuxa zaldakna, nasʉñki kanuwak zhemá pikáu akué jilgui saldi ne. ");
INSERT INTO kog_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Gakuñgueni niwa xezhaxa kanuwak zhinik kakjienatshake, guksé kuiti bakaldak pikáu puldá katuatshak pañ jiaga tu. ");
INSERT INTO kog_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Katuatshak Duweja ekí zʉñmeyá: —Pikáu kaiga guxamine anuñka uldak guwíñ. ");
INSERT INTO kog_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Guñguake Simóñ Pégulduki kanuwaxa iyabegueniki zhemá pikáu akué jilgui niwa xezhaxa uldák. Guatshake pikáu atemagaba, izatatshake 153, zhemák dañ akualdé jiaga jizbenazhá. ");
INSERT INTO kog_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Guñgueni Duweja ekí zʉñmeyá: —Nak xaldeki zawíñ. Guatshakna azhi mieldeke “‘¿me shi maldá?’ nugakldukshí” zʉñnegazhá. Akbiñgaki “eñki nauwijí Sáñkalda shakldá” zʉñkualdi noxák. ");
INSERT INTO kog_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Guñguake Duweja pañ zʉñkuldagueni ezua ezuak zʉñkáu. Ekíga na, pikáu jiaga zʉñkáu. ");
INSERT INTO kog_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Guatshak Duwe ekí zʉñkizhañkatshake, shuanalgué izhgaldagueni zhinik jaldeki maikjuizhane na shagitiyatoñkaldekuañ zʉñkizhañkajá. ");
INSERT INTO kog_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Guñgueni auxa katsatshake, Duweja Simóñ Péguldu ahezua ekí aklduká: —Nasukuá Simóñ, Juañ tsukua, ¿jaldekue zhakaldak shi maldezhgajañgú? Guñguake akiyó: —Akzé. Nají Sáñkalda, majañguge ne mikualdiñga nogashá. Guñguake Duweja ekí akbeyá: —Ake, nagapa neñkakue nají jubeju zhauwa jana nekueki numañ nagatuwi makualdí. ");
INSERT INTO kog_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Guñgueni jiak mutshuane ekí aklduká: —Simóñ, Juañ tsukua, ¿maldezhgajañguxa shi na? Guñguake akiyó: —Akzé. Nají Sáñkalda, naski majañguge mikualdiñga nogashá. Akbeñguake: —Ake, nají jubeju jana nekueki numañ nagatuwi nagaksaneshi makualdí. ");
INSERT INTO kog_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Guñgueni jiak maikjuizhane ekíga aklduká: —Simóñ, Juañ tsukua, ¿maldajañguamak shi na? Guatshakna Pégulduki maikjuizhane “¿maldajañguamak shi na?” akldukane shalda itshani ekí akiyó: —Nají Sáñkalda, mañki saldiñga mikuegaba nak, majañguge mikualdiñga nogashá. Akbeñguake ekí akbeyá: —Ak zʉnake, nají jubeju jana nekueki numañ nagatuwi makualdí. ");
INSERT INTO kog_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Akze, namakgaba mikbeyaldikue: Mañki akldé awawa maldalgueñki, mañgaba shi ishkabeshi janazhiktuwi, “mani nzheyaldikú” mikldexaldiake aldi maldeñka nane. Ne dueba maldegatshak zʉnake, gulda yu matshatshak, axautshija shi mixabeshi shi migatenega, neyasʉ́ñ mikzegaldi mawaldeyaldixa. ");
INSERT INTO kog_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ekí Duweja Pégulduk akbeyatshake, sakí agatsaldi aldéñ shalda shuigatshak Jate akldé akzamakga akzukualdixa ne guashi na ekí akbeyá. Gueniki ekí akbeyá: —Mañki nagapa za maldeyaldí. ");
INSERT INTO kog_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Akbeyatshak Pégulduki nagatonaldi zʉtuatshake, nas Duwe shagitiyatonuge nezhgajañguxake aldiwan nagaté natú. Nasga na Duwe shuigagáñga zañkaldoguéñ akldé agayogukuenik “Nají Sáñkalda, ¿mielde shi maguldiñkakuek magexaldixa na?” akldukanugega. ");
INSERT INTO kog_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nas nagaté natuatshak, Pégulduja Duwek ekí aklduká: —Nají Sáñkalda, akze, guatshake ¿uñkuejiéki? ");
INSERT INTO kog_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Guñguake akiyó: —Akze, eñki mokue kagik naxaldikuéñ yo “jaiga ni izhoxaldí” jañgualdikuake, ega ma jañguakue migatsaldakí nibatú. Mañki nas za nagapa maldeyaldí. ");
INSERT INTO kog_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Duweja ekí guaguéñ zhinik na, aldéñ ipananekuañgaba naski shuigazháldikue ne na dulda neshkuashiji aldeyapaná. Guatshak Duweja ekí guagatshake, “e zʉnake shuigazháldixa nzha” guashi akldeshiñki guagazhá. Egaba “akze, eñki mokue kagik naxaldikuéñ yo ‘jaiga ni izhoxaldí’ jañgualdikuake, ega ma jañguakue migatsaldakí nibatú” nuxa guaklde. ");
INSERT INTO kog_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nas shagitiyatonugek naldi na tunugamak miñmeji jalde miñgakauwanugekueki “namak shakldá” zʉñkualdaka. ");
INSERT INTO kog_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Guatshak Duwe Jesúki akldé matshuwiñga atshane nañga ne, ezua maja naldakí kalta sezhekldega nanake, mexá guashi jai kagik naldazháka ni jañgukú. Ekíga shi naldí.");
INSERT INTO kog_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Duwe Teyupildu, nas kasak kalta mikuzgaunugeki Duwe Jesú jai kagik izhoguéñ saldiñga atshatone, shizhiyatone ");
INSERT INTO kog_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ajateja jékaldaxa ulditshixaldiéñ yo shalda mikbeyananuge. Amak nitshigagá nogueñga, Duwejañki Jatetshi Aldunaja aksanegatshakna, ají múldigaba guaxal gaxaldixa izhgakuxanekue sakí ají jiba axajanashaldiamak kakbeyá. ");
INSERT INTO kog_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Guatshak Duweki guiyaba tuwi shuiguenik mokue izhgaldagueni, ají múldigaba guaxal gaxaldixakuek 40 ldiuwi anuñka juizha aldéñ naldiñga kakizhañká. Ekí kakizhañkaji na, “Duweki beñga nuká nakbatú” kakldekshaldiamak matshuwi nalda kaxatshá. Atshaga na, Saldiñga netshi Jatejañga kágubakue sakí janshagatsaldi kaksanexaldixa shalda akldé shi kaxaldiyane. ");
INSERT INTO kog_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ezua ldiuwañ Duwe Jesúja ají múldigaba guaxal gaxaldixakue na izhogueñga ekí atshakue kakbeyá: —Kaigabeñki jai Jeldusaldéñ zhinik neyagába, Najateja ají Alduna miñgakaxaldixa miñmeyananega, nas jiaga aiga miñmenuge jiaktuwi zhe minoxaldí. ");
INSERT INTO kog_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Akze, Juañ nik majaukshakuejañki nik nuxa mimajaukshanane. Ne anuñka ldiuwi zegatshak zʉnake Jatejañga ají Aldunak mimajaukshi na, ai Alduna maiñldi auxaga miñkaldaldaldiamak miñgexaldixa nakldá —na Duweja kakbeyá. ");
INSERT INTO kog_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Gueni Duwe Jesúja ají múldigaba guaxal gaxaldixakue na juizhaldegatoguéñ ekueja ekí agalduká: —Nauwijí Sáñkalda, ¿kaiga shi axautshi sanákue zʉñsanekakue magubiyaldinik, ma niñkauwañki Isayélkuañ maldazʉñsanegapanaldixa na? ");
INSERT INTO kog_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Guñguake Duweja ekí kakiyó: —Aiki Najateja aldéñga niuwi axaldahamak ji ldiuwañ amak zekualdixa janaktune. Ne maiñga ai miñkualdakue miñgatsaldakí nakldá. ");
INSERT INTO kog_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Naldatshak ekí miñkualdakue: Jatetshi Alduna auxaga miñkaldaldaldiamak mipanatshak, ají kama jiaga mipanaldixa. Amak mipanaldinik nashaldá, atshaté natuminamak miñguaxaldixa. Jai Jeldusaldéñ misha guaxabipanaldinik Juldeya eñgui baxe nahauxa ekíga guashi na, akldé Samaldiaxá guashi, aldiweki kagi maxáiñtaba izhgekuauxa nashaldá miñguaxaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ekí Duwe Jesúja kakbeñgueni kauwizhéñ atuaté aldogueñga, jékaldaxa awalditshigatshak mauwixa tuasá. ");
INSERT INTO kog_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ekí nitshiguake alnobaxa za azatú aldogueñki, tua kakzegagáñga mozhua sigí zhakuá abutshi ijuakuekue kauwizhesañ kakizhañká. ");
INSERT INTO kog_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Gueni ekí kakbeyá: —Maiñ Galdildeyaxa zaldakuek, ¿jinak shi alnobaxa zañga stu minók? Akze, ejié Duwe Jesúki maiñ nugéñ zhinik jékaldaxa sakí awalditshigaté mituamakbeñga mokue ega na kagik zabaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ekí zeguake Duweja ají múldigaba guaxal gaxaldixa kezhgakuxanekue gaxa akshá zeñka Oldibu axezhogeñka ashekualguenik mokue Jeldusaldéñ aldé. Ekí aldeyatshake kauwijí guiyabaja izhgasekué ldiuwañki mitsá nuxa zhikldoshi neyakue guagauxabé na zaldá. ");
INSERT INTO kog_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Exa aldeyatshake juwí kauwizhéñgaba ashekueñka mozhua zeñka saldi alditshí. Ekueki ekí axezhukakue: Péguldu, Juañ, Santiaku, Andaldé, Pildipi, Tumás, Baltoldomé, Mateyu, Santiaku, eñki Alpeyutshi asukuá. Ezuañki Simóñ, eñki axautshi sanákue kauwijí kagixa sanekakue akzʉxaitshaldiamak niji izhuka. Ezuañki Juda, eñki Santiakutshi asukuá na naldá. ");
INSERT INTO kog_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ekueki Duwe ipananekue, munzhi Duwe agauneka nanekue, ajaba Maldiya, Duwetshi aldanikue juizhi Jatek axazakuaxaldiamak ajuizhaldegamakga abá naldakí ajuizhaldeka na naldá. ");
INSERT INTO kog_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Atshak baxañga na, Duwe ipananegaba anuñka 120 ajuizhaldegatoguéñ, Péguldujañki kauwikenáñ izhgaldagueni ekí kakbeyá: ");
INSERT INTO kog_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Gajakuañ, mauzeñga Jatetshi Aldunaja nauwibama Dabí aksanegatshak Juda shalda Jatetshi múldigabak gaushanamak zegakue zanamak zeklde. Judajañki Duwe guxaldixakue amak akuxaldiamak uldenane. ");
INSERT INTO kog_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Akze, Judaki Duweja naldiñga nasʉñ nañga agatsé shagitiyakualdixa izhgakuxane nalguák, amak nasʉñ nañga axazauñka nane. ");
INSERT INTO kog_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","”Juda ekí Duwe izhguashi sha atshane shalda agasabine, ai paldatak na ezua kagi jabí. Exaki shuigueni sáñkalda zhikjiuwi mual akjienatshake dzhizha akduzbenatshake, ganuksha akzʉxaitá. ");
INSERT INTO kog_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Guñgueni saldiñga Jeldusaldéñka ashekuekueja ekí zeklde kakwasheguakna, ai kagiki Aseldama axeyaté. Kauwixauklduañki ‘abi zuldanéñ’ guashi.” ");
INSERT INTO kog_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Guñgueni Pégulduja ekí jiaga kakbeyá: “Zubeyakue xaltek e shalda ekí sezheklde: ‘E tshuxaki ni me izhogazhákldegaldi, sʉnjá shi zeshí.’ Ekí jiaga gauwanane: ‘Ají jiba axautshija niñkauwañki agipaná shi gui.’ ");
INSERT INTO kog_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Akna e naldataldaldéki ezua izhgakugakue zʉñgatsegashá. Aiki nasʉñ Duwe Jesúja shi zʉñkaldiji zʉñgapa izhonauxa izhonega naldakue. ");
INSERT INTO kog_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Akna Juañja Duwe nik jaukshiñguenik zhinik nauwikenáñ izhoshiñga jékaldaxa awalditshinéñ yo, nasʉñ nañga izhone naldakue. Jinake naldakí. Eñki nasʉñ nañga ‘Duwe Jesúki shuiguenik izhgatene tunugamak nzha’ guashi zʉñgaunexaldixa nak.” ");
INSERT INTO kog_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ekí kakbeyatshakna amak naldakakue mozhua ajañgui akuák. Ekuega na, ezuañki Jusé Balsabá, Justu jiaga akuaka. Ezuañki Matiá axezhuka. ");
INSERT INTO kog_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ekí ajañguñguenik Duwe Jesú axazakuagatoguéñ, ekí agabeyá: “Nauwijí Sáñkalda, mañki aldunaxa zʉñnegatogauxa mikuegaba. Akna jejié mozhua nekue mielde izhgakuxamalde zʉnatuñsha guwá. ");
INSERT INTO kog_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Eñki Juda naldataldé mixazauwi, mañga mijí múldigaba guaxal makaxaldiamak. Akze, Judaki shi migitixa mixazauñka nalgué, ai jiba majañgueniki shuigatshake neyakue agatsalgualdi ne guane.” ");
INSERT INTO kog_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ekí axashishiñgueniki, mielde ai naldaka ne atualdiamak ajanashiji na, aldiyatshake Matiá ne atuñguakna e ishkakuxá. Atshak zhinik na Matiá jiaga, Duwe Jesújañga 11 ají múldigaba guaxal gaxaldixa izhgakuxanekue nañga agatsé atualdá na gua. ");
INSERT INTO kog_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Guñgueni izhajuizhaldeká Pentekosté ldiuwañ zegatshake, saldiñga Duwe Jesú ipananekueki azbuangaba ajuizhaldeklde na ashekualdá. ");
INSERT INTO kog_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Amak ashekualgueñki kakldegagá nogueñga, múlkaldajañ kamakualdi jaldáñ akauldi alnobaxa zhinik zabiñgueni ashekualgualdi zahauxa kagakjuldú. ");
INSERT INTO kog_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Gueni guksé juna, juna puldatukajañ nauwa, nauwa zhikbeni exa ashekualdauxak ezuak, ezuak kagaldagaté atú. ");
INSERT INTO kog_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Amak kagaldagatshaga na, Jatetshi Alduna kagatsauxa auxaga kaxaldaldaldiamak kejuldú. Ai Aldunaja kaksaneshiñga na, saldiñga ashekualdauxa sha sha kaugiañ kauwizhéñ azakuagazhék kazukuakshaldá. ");
INSERT INTO kog_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Atshake juldiúkue Jatek akldunamak izhoxa niñkakue san san kagi nahauxa zhinik Jeldusaldéñ ajuizhaldexal aldakldekue na ashekualdá. ");
INSERT INTO kog_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ekueja ekí múlkaldajañ akauldaté aldukatshakna, duwá izhgazhé Duwe ipananekue ajuizhaldegatoguéñ atuál saldi aldák. Ekueki sha sha azakuakakue aldalgué, ai Duwe ipananekueja ezua, ezua kauwijí kaugiañ azakuagaté aldukatshakna, “sakíga ni ekí azakuák” kakldegazhá. ");
INSERT INTO kog_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Guakna, “¡sakí ekí azakuaká!” ajañgui na ekí izhgaldukaldá: —¿Saldiñga ekí sha, sha azakuagatukakueki Galdildeyaxa zaldakuega naldazhé shi na? ");
INSERT INTO kog_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ne “sakíga ni ekí nauwijí kaugiañ sha sha azakuagaka na” zʉñgajienakí naldatshak jiaga, nukanazʉnaka. ");
INSERT INTO kog_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Akze, nasʉñki san san kagi zaldakuañ jai mizhal nakalde: Anuñkaki Paltiaxa zalda, Mediaxa zalda, Eldámka zalda, Mesopotamiaxa zalda, jai Juldeya baxe zalda, Kapadosiaxa zalda, Pontuxa zalda, Asia baxe zalda, ");
INSERT INTO kog_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pildijiaxa zalda, Panpildiaxa zalda, Ejiptuxa zalda, Aldibia baxega kuíbuldu Sildene akyó zalda, anuñkaki kuíbuldu Alduma zalda jai mizhal nakalde. ");
INSERT INTO kog_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Aikuega na anuñka juldiúga, anuñka nekueki axautshi sanákue naldatshak jiaga, nasʉñ Jate kajañguamakbé ajañgualdixa izhgakuxanekue. Anuñkaki Kaldetaxa zalda, anuñkaki Aldabia baxe zalda katshekualdashá. Naldatshak jiaga, ai sha sha azakuagatukakuejañki “¡Jateki sakí ekí atemajañ janshagatse zʉñkatshixá!” akuagatshak, nasʉñ ezuak ezuak nauwijí kaugiañ naldiñga ni kalduká. ");
INSERT INTO kog_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gueni saldiñgajañki “¡sakí ekí sha sha azakuaká!” ajañgui, “sakíga ni jañguakuá” kakldegazháldi ekí izhgaldukaldá: —Ekí zegatshake, ¿eñki ji guashi ne? ");
INSERT INTO kog_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Guatshak ezuakuejañki iyajokldeshiñga na ekí akuák: —Ejiékueki stuxanekue nakna ekí azakuák. ");
INSERT INTO kog_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ekí akuaguake Pégulduki Duwejañga 11 gaxanekue juizhiñga izhgaldaxeni matshuwi ashekualdekueja nukandana ekí kakbeyaldá: “Nasanákuañ, saldiñga jai Jeldusaldéñ mizhekuekuañ jiaga, sakí zegaté mituñká shalda miñmeyaldikue nak, muldetua nukaté nogwíñ. ");
INSERT INTO kog_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Anuñkake stuxáñkaldekue ekí kazukuaká mijañguatshak, naldagálde ni mijañgú. Niuwi jue meñga ni me zʉtugazhé naldashá. ");
INSERT INTO kog_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ne ekí zekaki, Jatetshi múldigaba naldiñga zʉxaitshixa Juelja ekí zexaldixa kalta gauwanane: ");
INSERT INTO kog_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Saldiñga netshi Jateja ekí guak: Auxa zegapanatshake saldiñga káguba saná na nahauxa nají Alduna muldetua kagatsauxa kaxaldaldaldiamak kagakaxaldikue. Eja na mimiskuakue, mimibunzhikue nají múldigaba naldiñga kaldukshanamak kágubakuek kakbeñshaldikue. Ekíga na, nakuakue aldunaldi jigaba katuñshaldikue. Duebakueki kabi kakzukualdikue. ");
INSERT INTO kog_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Atshakna sigí, munzhi naxazauñkakue zʉnake nají Alduna muldetua kagatsauxa kaxaldaldaldiamak kagakaxaldikue. Eja na nají múldigaba naldiñga kaldukshanamak kágubakuek kakbeñshaldikue nakldá. ");
INSERT INTO kog_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Atshak alnobaxa zʉnake zegaté atú guazhámak zekualdikue. Ekibeñga, kagik jiaga nas za auxaga kama naksuikue ne awatuñshaldikuamak zegaté atú guazhámak zekualdikue. Ekí zekualdatshakna, kagike abi baxega ne, guksé puldi ijiáxalda setañgua zalda zegaté atualdixa. ");
INSERT INTO kog_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Atshakna, alnobaxa zʉnake niuwiki tuañ izgualdikue, saxaki abi itsune jana atsʉshi za ité izgualdikue nzha. Akze, nas Saldiñga netshi Sáñkaldak káguba agatsaldi azhi agatsaldakí ne katuál naxaldikuéñ ldiuwañki atemajañ akzé, zʉxaita zalda janshizhe niuwañ zegagáñgaki ekí zexaldixa nzha. ");
INSERT INTO kog_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Amak zegagá noxaldieñga, ezua minkualdal miñgakaxanaldikue, mieldejañki aik “nají Sáñkalda, sha atshikuge shalda guiyaba tuazháldikuamak nazikuá makualdí” axakuañnexaldiake amak ikualdaldixa nakldá.’” ");
INSERT INTO kog_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ekí sezheklde kakbeñgueni ekí jiaga kakbeyá: “Maiñ nauwibama Isayél shtukuakuañ, ekí miñmeyaldikue muldetua nukaté nogwíñ: Miñkuahamakga Saldiñga netshi Jateja Asukuá Duwe Jesú Nasaldéxa zalda aldéñga kagik gaxane mimatuñshane. Sakí ekí mimatuñshazhá. Aldéñga Asukuá Duwe mimikenáñ izhoguéñ, jika janshagatsegaba atemajañ atshaté tu guabínamak atshishane nak. ");
INSERT INTO kog_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Naldatshak jiaga, ezuakuañki Duwe aguldiñkakuek agemine. Ne amak gegagá minogueñga Jatejañki ekí zexaldixa janaktunalguamak nuxa zek. Guane nalgué, ai Duwe ageminekueki kutám atshixakue nalgué jiaga, Duwe akuaxaldiamak kagaunekbine. Ekí miyagaunegatshakna, ekuejañki amak kaldixa axaldiya akuaxá akuane. ");
INSERT INTO kog_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Duwe Jesú ekí shuane nalgué jiaga, Ajateja mokue izhgaldakshá. Akze, Duweki zʉxaita guiyaba tuwi shuigatshak jiaga, Jateja shuane za nokshazhá. Akze, ni jiyája ni shuixaja shuane za nokshazháka. ");
INSERT INTO kog_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nauwibama Dabíja e shalda ekí guaklde sezheklde: ‘Najate, mañki Saldiñga netshi Sáñkalda maldé, naldesañ izhoxal za matuñkuge. Mañki ekí natezhak za mizhogakna, sha nakundana akzekakue zhe nakzukuazháldi, nagubiyazháldixa. ");
INSERT INTO kog_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Akna, aldunaxa zeñ nakldeshi akldé mikzamakga mikzukualdikue. “Abuáke shuixaldatshak mokue maldezhgaldakshaldixa shakldá” za nakualdi jimiktualdikue. ");
INSERT INTO kog_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Jinake naldakí. Mañki shuanuge za naldokshabaldáldixa. Naski mijí za izhoshi, amak za mixatshikuge nakna, shuixaldatshak nají abuá galduñgua guabaldáldixa nak. ");
INSERT INTO kog_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Akze, mañki shuixaldikueni mokue maldezhgaldakshaldixaga natuñshamalde. Mañki naldesañ za mizhogakna, zʉxaita zalda zeñ maldakzukualdixa nakldá.’” ");
INSERT INTO kog_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ekí sezheklde kakbeñgueni ekí jiaga kakbeyá: “Nasanákue, nakzék naldakí ekí miñmeyanaka: Nauwibama Dabíki shuigueni ají abuá shuanekue abegeñka abexanane. Ai abexaneñki kaiga jiaga nauwikenáñga nogashá. ");
INSERT INTO kog_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Guatshak Dabíki Jatetshi múldigaba naldiñga zʉxaitshixa nalguakna, ezua zʉnekualdal naxaldixaja guaxaldixaga guashi ekí kalta gauwanane. Akze, Jateja ekí axakildashiñga akbene nauwibamaja akualdiñga none: ‘Nas ezua mitukua ma najíkue kaksanekbaldamak kaksanexaldixa izhaxaldikue niyó.’ ");
INSERT INTO kog_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Amak zegagá nogueñga Jatejañki nauwibama Dabík sakí zexaldixa tuñshatshak, ezua zʉnekualdal gaxaldixa guakldeki shuixaldinik mokue izhgaldakshaldixa guakshane. Ekíga na, shuane za nokshazháldi, ni ají abuá galduñguá guazháldixa guakshane. ");
INSERT INTO kog_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","”Ekí guakldalguamakga Duwe Jesú shuigueni Saldiñga netshi Jateja mokue izhgaldakshá. Nasʉñ saldiñga agapa kaldeñkakuañki Duwe amak izhgaldaguenik tuñkaldamak axautshikuek kakbeñka naldashá. ");
INSERT INTO kog_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jateja ekí Asukuá Duwe Jesú izhgaldakshiñgueniki jékaldaxa akldé akzukuiñga, aldéñ jibatshaldi mual sanexaldiamak ité. Aldéñga na ají Alduna Asukuák nasʉñ ajíkuañ zʉñgexaldiamak niuwi agexaldixa akbenalguamak niuwi ageguakna, aldéñ zhiniki ai Alduna muldetua zʉñgatsauxa zʉñkaldaldaldiamak zʉñgakaxane. Amak zʉñgene awatuñshi atshañkalduka na, tuabinuka, nukabinuka nakldá. ");
INSERT INTO kog_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Akze, nauwibama Dabí jékaldaxa nitshigazháne naldatshak, Jateja ezua zʉnekualdal gaxaldixa shaldaga ekí gauwá: ‘Saldiñga netshi Jateja nají Sáñkalda Zʉnekualkak ekí akbeyá: Nas saldiñga aksanegatokugeñga, jibatshugaldi mual akldé akzéñ naldesañ yate guwá. ");
INSERT INTO kog_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Naski maguldiñkakuek auxaga magubishaldikueñka yo amak mizhoxaldixa nakldá.’” ");
INSERT INTO kog_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ekí sezheklde kakbeñguenik ekí jiaga kakbeyá: “Akna maiñ saldiñga nauwisaná Isayélkuañ ekí muldetua miñkualdakue: Saldiñga netshi Jatejañga na ezua zʉnekualdal gaxaldixa guakldanamak Asukuá Duwe Jesúga zʉñgakaxá guane. Ega na, aldéñ naldiñga nauwijí Sáñkalda izhoxaldiamak itene. Ne ega na maiñ kaldixa axaldiyá akuakshishá guamine nakldá.” ");
INSERT INTO kog_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ekí aldukatshakna ajuizhaldekldekueja aldunaxa zʉxaita izhajanatshak, Péguldu na Duwejañga gaxanekue juizhiñga ekí agalduká: —Gajakuañ, guake Jate zʉñkabetaldiamake, ¿mielde shi atshakue zʉñgatsá? ");
INSERT INTO kog_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Guake Péguldujañki ekí kakiyó: —Maiñ ezuak minauxa sha miyatshixa majiñga maja xaldeki Jatek agakualdinakue. Ekí miyatshaldiakna, Asukuá Duwe Jesú namak mijañguxa miyawatuñshaldiamak nik mimajaukshakue. Ekíki Jateja sha miyatshixa miñkabetaldiamak. Gualdinik na ají Alduna miñgexaldixa. ");
INSERT INTO kog_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ají Alduna zʉñgexaldixa zʉñmeyatshake, aiki nasʉñ, nauwijí sukuakue, saldiñga aldéñ namak jañguxakue maldé zaldi izhukakue jiaga zʉñgexaldixaga guashi zʉñmeyanane. Akze, Saldiñga netshi Sáñkalda, Nauwijatejañga saldiñga ajíkuañ naldakualdiamak axaldagakue zʉñmeñkakuek ají Alduna zʉñgexaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ekí Pégulduja guashiñga na, jiak exa zhinik akldé kakbeyatoshiñga, keshkaldukshi ekí jiaga kagakuañnék: —Maiñ Jateja minkualdakue miyagakuañnexaldí. Ekíki shanekue kaiga zhekualdatukakue guiyaba katuñshatshak ekíga mimatuñshi guakuak. ");
INSERT INTO kog_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ekí kakbeyatshak ai múldigaba agipananekueki nik kajaukshá. Ai ldiuwañga matshuuwi anuñka 3.000 Duwe ipananekue juizhi izhgaldiyá na akuá. ");
INSERT INTO kog_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ekue na Duwejañga ají múldigaba guaxal gaxanekueja shi kaxaldixá muldetua axaldukshi, amak axajanashiji za izhukakue. Ekí izhoshi na, Duwe ipananekue na izhajuizhaldeshi, Duwe nauwitsaldí shuane shalda be zhigisekui axaldixa kagabene axaji, Jate axazakuashi za na ashekualdapaná. ");
INSERT INTO kog_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Atshaga na Duwe Jesújañga gaxanekueki kágubakueja janshizhe ajanashaté atú guazhámak matshuwi ajanashéñ zhinik na, exa ashekualdekueja “¡Jateja sakí ekí katshishixá!” ajañgui na ashekualdá. ");
INSERT INTO kog_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Duwe ipananekuegaba muldetua ishkaldaldi, ajañgui za aldoshi na, jika numa kaxaldekueki saldiñga netshi ajañgui na ");
INSERT INTO kog_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","atshuake kagi, numa nabeyasaldinik ai shalda iyapankáki mielde jika agajuezhatukakueki agaxauneka. ");
INSERT INTO kog_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Niuwi neyauxa juwí Jate axazakuageñka ajuizhaldexal za alduka. Ekíga na, kauwijuldi zeñ kakldeshi, gakue izhgaxauwi zhualduxa asaji, Duwe nauwitsaldí shuane shalda jiaga be ishkiyasekui axaji na ashekualdá. ");
INSERT INTO kog_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kauwizhéñki ekí ashekualdi, Jate za akldé akzamakga agazukui za ashekualdatshak, axautshikuejañki janshizhekue katuñka. Niuwi neyauxa, nauwijí Sáñkalda Duwe Jesúja akldé akldeñga káguba kekualdatshakna, aldéñ ipananekue juizhi izhgaldiji na ashekualdá. ");
INSERT INTO kog_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Guatshak juldiúkuejañki niuwi uñguexá zegauxa juwí Jate axazakuageñka axazakuaxal aldeyamakga, ezua ldiuwañ Péguldu, Juañ na Jate axazakuaxal saldi aldé. ");
INSERT INTO kog_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Atshake ezua sigí neyazhákaga kukanane awaldagaté atú. Ejiéki niuwi neyauxa juwí Jate axazakuageñka juldunéñ “Janshagatse” akuagéñ izhogexañ awaldeñka. Ekíki kágubakue ajuldunapanatshak paldata kakshishaldiamak. ");
INSERT INTO kog_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nalguakna ai sigíja Péguldu, Juañ na ajuldunaté katuatshak paldata kakshishá. ");
INSERT INTO kog_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Guake señ atuaté noshi Péguldujañki ekí axaldék: —Zʉnatuaté nogwá. ");
INSERT INTO kog_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ekí axaldeguake “jika nagaxauwexañ nakbatú” akldeshi amak katuatshake ");
INSERT INTO kog_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pégulduja ekí akbeyá: —Paldata ni niuba naxaldaldakí naldatshak migaunekldakldegauxa migaunexaldikue. Aiki, Duwe Jesú Nasaldéxa zaldaja niuwi migé zhuxañga ekí mikbeyaldikue: Izhgate xaldeki newa. ");
INSERT INTO kog_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ekí axaldeshi, gulda jibatshaldi akpana juat izhgaldakshapanatshaga ají kasak, kewáñ kama axaldaldaldá. ");
INSERT INTO kog_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Guakna zʉnzhgaté izhgaldagueni mizhaldá. Gueniki aldéñgaba zʉnte, zʉnte neji Jate akldé akzamakga akzukui na, kauwizhéñ nañga Jate axazakuagaldi juldú. ");
INSERT INTO kog_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Guatshakna saldiñga exa ashekualdekueja ai sigí ekí Jate akldé akzamakga akzukui, neyaté atuatshakna, ");
INSERT INTO kog_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","“eñki julduneñka ‘Janshagatse’ akuagéñ zʉshishi za izhuka tiuwi nakzék” kakldék. Guakna “sakíga ni ekí neyakldék” ajañguakí naldi na, “¡sakí ekí janshi agatseklde ne!” ajañguiñgaba na akuapaná. ");
INSERT INTO kog_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sigí janshi akzekldeki Péguldu, Juañ, iyabá naldakí izhogueñga, saldiñga exa ashekualdekueja “sakíga ni ekí janshi akzeklde na” ajañguakí nalguakna, aldaldiñga atuál saldi aldé, juwí Jate axazakuakakga jueyáñ zalda atema akldikue Saldamóñtshi akuageñka. ");
INSERT INTO kog_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ekí kaxaldaká Pégulduja tuatshakna ekí kakbeyá: “Maiñ nasaná Isayélkuañ, ai sigí ‘¡sakí ekí janshi akzeklde ne!’ jañguakue miñgatsaldazháldi, ni ekí zʉnatuakue miñgatsaldazháldi. ¿Nasʉñ nauwijí kamak, azhi Jate akldunamak za kizhuka kaldahéñ zhinik sigí janshi akzukui neñshapánañkalde shi minazʉnajañgú? Naldagálde. ");
INSERT INTO kog_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Akze, Saldiñga netshi Jateki, saldiñga nauwibamakuetshi Ajate izhoshiñga na Abaldahám, Isák, Jakóptshi Ajatega. Ejañga na Asukuá Duwe Jesú aldéñ axazauñkaki akldé akzamakga akzukuane. Ne maiñ niñkauwañki sáñkalda Pildatuja guaxal niuwi gexaldiamak agemine. Nalgué ai sáñkaldajañki Duwe agatsaldazhé tuwi ibesaldixa guagatshak jiaga, eja tuatogueñga Duweki miñsanegazháka ne guakbine. ");
INSERT INTO kog_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Akze, Duweki Ajateja zʉnekualdal gaxane, janshizhegaba, jian za atshixa nalgué jiaga ipanasʉ́ñ miñzeklde. Pildatujañki miñkibesaka jañguatshak jiaga, maiñki káguba guaxa atshixa niñkauwañki miñkibesakue agakuañnekbine. ");
INSERT INTO kog_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ekí miyatshatshakna, Duwe Jesúki aldunaxa auxaga zʉñzukui izhoshiñga zʉnezhokshixa guaxamine. Ne amak shuane nalgué jiaga, Jateja mokue izhgaldakshá guane. Ekí izhgaldakshane nasʉñki tuñkaldamak kabiñmeñká. ");
INSERT INTO kog_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","”Jalde sigí neyazháka mituñka naneja ‘Duwe Jesú namak shakldá’ jañguatshakna Duweja janshi akzukui, neñshapanane. Akze, Duwe alduna ishéñ guana eñki auxaga kama gushi, janshi akzeklde saldiñgak tuminaka nakldá. ");
INSERT INTO kog_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","”Nasanákuañ, ekí minakué. Maiñ, mimijí sáñkaldakue juizhi, Duwe Jesúki Jatejañga ezua zʉnekualdal gaxaldixa guakldane, ‘aiga shakldá’ miñnegazháldiñga na ekí guamine. ");
INSERT INTO kog_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Naldatshak, Saldiñga netshi Jateja ekí miyatshaldiamak mimebesá zhinik na, aldéñ ezua zʉnekualdal gaxaldixa guakldaneki guiyaba atuñshi, akuaxaldixa ají múldigaba naldiñga zʉxaitshixakuek kakuakshanamak zekuane. ");
INSERT INTO kog_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Akna kaiga zʉnake sha miyatshixaki majiñga maja xaldeki Jatek miyagakualdinaldí. Ekíki Jatejañki sha miyatshixa muldetua nuk miñkabetaldiamak, aldéñga aldunaxa señgaba miñzukui mimezhiksekushaldiamak. ");
INSERT INTO kog_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Akze, ejañga Asukuá Duwe Jesú zʉnekualdaldiamak, zʉñsanexaldiamak izhgakuxane. Nak jiak, ega na mokue kagik zʉñgakaxaldixa. ");
INSERT INTO kog_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ne kaigabeñki Jateja saldiñga gauwanekue mokue abisa guagá nogeñgaki Duweki jékaldaxaga izhoxal nogakue agatsé. Akze, mauzeñga zhinik Jateja ekí atshaldixa ají múldigaba naldiñga zʉxaitshixakuek kakuakshi zʉñmeyanane. ");
INSERT INTO kog_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","”Aiga na, Jatetshi múldigaba naldiñga zʉxaitshixa nauwibama Mueséja Jateja ezua zʉnekualdal gaxaldixa shalda guagatoshi ekí guaklde: ‘Saldiñga netshi Sáñkalda, Mimijatejañga na mimikenáñ zhinikga ezua najanamé ají múldigaba naldiñga zʉxaitshixaga miñgakaxaldixa. Ejañki ji miñmeñká muldetua axaldukakue miñgatsaldaldixa. ");
INSERT INTO kog_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ne mieldejañki ek muldetua axaldukakí naldaldiake, Jateja ají tuaksáni, izhgajuekuiñga izhgajuekualdixa nakldá.’ ");
INSERT INTO kog_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","”Guatshak saldiñga Jatetshi múldigaba naldiñga zʉxaitshixakueja nauwibama Samuélka panane, kaiga zegatukaki amak zegagá nogueñga jiaga ekí zexaldixa akuagatonane. ");
INSERT INTO kog_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Akze, Jateja ají múldigaba naldiñga zʉxaitshixakuek ezua zʉnekualdal gaxaldixa kakuakshananeki maiñ miñgakaxane. Ekíga na, Jateja nauwibamakue zeñ kajañgualdixa ishkualdi nogapananamak maiñ jiaga zeñ mimajañgualdixa. Akze, aldéñ nauwibama Abaldahám ekí akbeyá: ‘Ezua mitukuak zhinik na saldiñga saná na nahauxa zeñ kajañgualdikue nzha.’ ");
INSERT INTO kog_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ai zhinik na Jateja ezua zʉnekualdal gaxaldixa guakldanamakga, Asukuá aldéñ za axazauñka amak kagik gagatshak, maiñ juldiú sanákuañ misha zeñ mimajañgualdiamak miñgakaxane. Akze, ek zhinik na Jateja ezua ezua minauxa sha atsha mimashaldinik aldéñ miyagakualdinaldiamak miñgaunexaldixa nakldá.” ");
INSERT INTO kog_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ekí Péguldu, Juañ na kágubakuek kakbeyal aldogueñga, Jatek múldigaba agaskaitshixakue, juwí Jate axazakuageñka numañ zʉtuñkakuetshi sáñkalda, saduseyukue juizhi kaxaldák. ");
INSERT INTO kog_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Atshaga na, Duwejañga ají múldigaba guaxal gaxanekueja kágubakuek Duwe Jesú shalda shi kaxaldiji na, Duweki shuiguenik Ajatejañga mokue izhgaldakshanamakga káguba ashuanaldixakue jiaga kezhgaldakshaldixa akuagaté aldukatshakna, ai sáñkaldakue matshuwi nusá kakzék. ");
INSERT INTO kog_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ekí kakzeshi na, Péguldu, Juañ na keyapanguenik kalseldi kabexá. Atshake tuañ zexaldá guapanguake abokualdik agazaldukaldiamak jituakue kagatsék. ");
INSERT INTO kog_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Guatshake matshuwi nekueki Pégulduja Duwe shalda guagaté aldukane namak ajañguá. Ekuega na, sigígaba iyazatatshak anuñka 5.000 naldashi na Duwe ipananekuegaba izhaltexá. ");
INSERT INTO kog_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Abokualdike akldé akzekue sanekakuegaba, aikuega guiyaba shizhixakue, kauwisaná nauwa akldé akzekue juizhi Jeldusaldéñga ajuizhaldék. ");
INSERT INTO kog_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Exaga na, Anás, Kaipás Jatek múldigaba agaskaitshixa akldé akzekue izhogatshakna, Anástshi akajakueki Juañ, Aldejánduldu, exa zhinik akldé akajakue juizhi na izhoxá. ");
INSERT INTO kog_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Amak ajuizhaldegatshak Péguldu, Juañ na kauwibuán kaxakldagakue akuák. Amak kakualdagatshak ekí agazaldukaldá: —¿Meja niuwi miñgene, metshi kamak tuejié sigí janshi akzukuamine shi na? ");
INSERT INTO kog_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Guake Jatetshi Aldunaja auxaga Péguldu aksanegatshak ekí kakiyó: —Sáñkaldakue, nauwisaná akldé miñzekuañ ekí nuxa miñmenaka ni atuñkú. ");
INSERT INTO kog_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Jejié sigí neyazháka nane guañ jañgui, sakí janshi axazguañkalde kaiga minazʉñnukatshak, ");
INSERT INTO kog_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","maiñ, nauwisaná Isayélkuañ minauxa ekí miñkualdakue ni kabimajañgú. Eñki, Duwe Jesú Zʉnekualka Nasaldéxa zaldajañga jejié sigí janshi akzukuane nakna jai mimibuán akldogaka. Duwega na, maiñ kaldixa axaldiya akuakshamine nalgué jiaga, Jatejañki mokue izhgaldakshá guane. ");
INSERT INTO kog_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","E shaldaga ekí sezheklde: “Eñki juwí miñgauxakuek ezua jagi miñkazauwazháka jañgui uteyamine. Ne aiga na jagi abuwa akldé akzé juwí muldetua agatsaldakuamak agatsé sekuá guane nakldá.” ");
INSERT INTO kog_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","”Akze namak, Duwe Jesú za na zʉnekualdaka, e zhinik mokue axautshi zʉnekualdaka naldakí. Jinake naldakí. Saldiñga netshi Jateja Asukuá za na kagik saldiñga káguba saná zhe kaldogauxa zʉnekualdal zʉñgakaxane nak. ");
INSERT INTO kog_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Guatshakna sáñkaldakueja Péguldu, Juañ na ekí kakzék naldakí dulda ashaté atuatshakna, “kalta tuazhánekue ni ai itsaldagáldekue naldashá” kakldegatshak “¡sakí ekí dulda ashixá!” ajañgui na, “ekueki Jesúk agapa ashekuanamakga ne tiuwi” kakldék. ");
INSERT INTO kog_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Guatshakgaba sigí janshi axazakuane jiaga kauwizhéñ nañga akté atuakna, sakí sha kakuagakue atuazhá. ");
INSERT INTO kog_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Guakna sáñkaldakue ajuizhaldegatogueñka zhinik kauldeyakue akuagueniki kauwizhéñgaba ekue shalda izhgabeji na, ekí akuák: ");
INSERT INTO kog_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—Ejié mozhua nekue sakí kakuakue tuakí ni kaldá. Akze, ekuega na, ezua atemajañ janshizhe ajanashaté atú guazhámak ajanashane saldiñga Jeldusaldéñ zhekuekueja kakuéñ zhinik na, “ekí ajanashazháne nakldá” guagazhánazʉnaka. ");
INSERT INTO kog_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Naldatshak jiaga, sigí janshi axazakuane shalda akldeñga aldukazháldiamak, “maiñ Jesú shalda axautshikuek kakbeyalga minoxaldiák guiyaba mimatuñshakualdixa nzha” keshkaldukshakuega zʉñgatsaldaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ekí izhgabeñguenik na, ai mozhua nekue mokue kaldaxaulgueni ekí kaxaldék: —Kaiga zhinikga ni mitsák Jesú shalda guagakue, ni e shalda shizhiyakue miñgatsaldazháldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ekí kaxaldegatshak, Péguldu, Juañ na ekí ayó: —Saldiñga netshi Jatejañki mielde atshakuamak ne tuñka muldetua jañgua guwíñ. ¿Maiñ za amak miñkatshiji na, aldéñ niñkauwañki amak axatshañkaldáaldixa shi naldakualdixa na? ");
INSERT INTO kog_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ne nasʉñki Duwe Jesú atshaté tuñkaldamak, shizhiyaté nukañkaldamak guaxalga nogakue zʉñgatsaldashá. ");
INSERT INTO kog_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Sáñkaldakueja ekí aldukatshakna, mokue Duwe shalda akuaxaldiake guiyaba katuñshaldixa ne akldeñga keshkaldukshá. Ne atshake sakí guiyaba katuñshakue kakzaldakí naldakna egaba keyabesá. Jinake naldakí. Kágubakueja sigí janshi akzekldeki “Jatejañga janshi akzukuane shakldá” kakualdi na, e za akldé akzamakga agazukuatoxák. ");
INSERT INTO kog_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Akze, ai sigí ekí atú guazhámak agatsaldi janshi akzekldeki kuka zhinik dueba 40 kagi zʉxái itsé neyagálde nane. ");
INSERT INTO kog_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ekí Péguldu, Juañ na keyabesiñguake, Duwe ipananekue ashekualgueñka saldi aldé. Exaki Jatek múldigaba agaskaitshixakuetshi sáñkaldakueja, kauwisaná nauwa akldé akzekueja kaxaldekldalguauxa akuák. ");
INSERT INTO kog_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ekí aldukañguake saldiñga zhualduxañgaba Jatek ekí agabeyaldá: “Nauwijí Sáñkalda, mañki Saldiñga netshi Sáñkalda maldé, ma za na alnoba, kagi, níbuni eni jika na nahauxa gaumalde, ma za miksuí nogatuka. ");
INSERT INTO kog_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ma naldiñga mijí Aldunak zhinik nauwibama Dabí mixazauñkak ekí guakshamaldane: ‘¿Sakí zhinik shi káguba saná na nahauxa zʉxaita nusá kakzukui, kaguldiñkú? ¿Sakí zhinik shi nají kuíbuldu izhgakuxanuge jiaga axesé nuxa jananakizhgatuwi ashekuá? ");
INSERT INTO kog_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ekíga na, kagi nahauxa sáñkalda akldé akzekue, axakyokuekue juizhi kaunakshaldiamak jana izhgatuwi ajuizhaldék. Jinake naldakí. Nas, Saldiñga netshi Sáñkaldak, káguba ikualdal ezua gaxaldikue nañga kaguldiji kaunagashaldiamak.’ ");
INSERT INTO kog_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","”Ekí sezhekldamakga na, jai kuíbulduk sáñkaldakue Eldode, Ponsiu Pildatu na, juldiú naldagáldekue juizhi, nauwisanákue juizhi izhajuizhaldék. Jinake ekí ajuizhaldegazhá. Misukuá Duwe Jesúki káguba ikualdal makaxaldixa izhgakuxamalde, mijí za izhuka ne, sakí sha guakue janagatualdiamak. ");
INSERT INTO kog_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Naldatshak ma za kama na nahauxa miksuikuamakga ji ajanashaka kebesamaldamak nuxa ajanashá. Aiki amak zegagá nogueñga jiaga sakí zexaldixa jañguamaldamak nuxa zek guane. ");
INSERT INTO kog_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Akna kaigaki, ma nauwijí Sáñkaldak, sakí sha zʉnakualdixa zʉñgabeñká zʉñgatu makualdí. Nasʉñ kabixazauñkakuañ mijí múldigaba, Misukuá shalda zʉñzék naldakí guagakualdiamak maldazʉñgaunexaldí. ");
INSERT INTO kog_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ekíga na, Misukuá Duwe Jesú ma za mixazauñkak zhinik ekí niuwi maldazʉñgexaldí. Mulbatá akzekakue se kakzukui na, janshizhe ajanashaté atú guazhámak mijí kamak maldazʉnatshishaldí. Ekíki kama mixaldé mawatualdiamak.” ");
INSERT INTO kog_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ekí auxa axazakuagatshake, Jatejañga juwí ashekualgueki wi, wi atshishatshaga, saldiñga exa ashekualdekueki Jatetshi Alduna kagatsauxa kaxaldagueni kaksanegatshakna, Jateja guagakue kaksanegamak kakzék naldakí na akuagapaná. ");
INSERT INTO kog_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Saldiñga Duwe ipananekuegaba aldunaldi askuiñgaba kakldeshi, zhuajanañgaba ajañgui na ashekualdá. Akna ni mieldejañki jika axaldeki ají za naldaka jañguagába, ji kaxaldauxaki ataba atabañ izhgaxauwi na ashekualdá. ");
INSERT INTO kog_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Atshaga na, Duwejañga ají múldigaba guaxal gaxanekueki Jatetshi Aldunajañga atemajañ kama kageshi na, “nauwijí Sáñkalda Duwe Jesú shuiguenik mokue izhgaté guane nakldók” akuaxalga na aldoxá. Guatshakna Jateja Asukuá ipananekuegaba zʉ́xaita zalda zeñ kajañguxá na atuwá. ");
INSERT INTO kog_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Akbiñgaki, kauwizhéñga ni ezua ji agajueshka naldakí na naldá. Jinake ekí ashekualdakí. Atshuake Duwe ipananekuegaba mieldeki kagi azhi juwí axaldé nabeyasá akualdini, ai paldataki ");
INSERT INTO kog_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Duwejañga gaxanekuek akualdaka. Gualdiake ekueja zhiniki mielde Duwe ipananekuega ji kagajuezhatshak amak agaxauneka naldák. ");
INSERT INTO kog_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Guatshak ezua Jusé axezhukaki Aldebí ldaxega, Tshípaldexa zaldaga Duwejañga gaxanekuejañki Belnabé axaldeka. Belnabéki “axautshi guañ jañgui, aldunaxa guiyakshixa” guashi. ");
INSERT INTO kog_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ejañki te axaldalgué nabesañgueni paldata agasabineki Duwejañga gaxanekuek axautshi agaxaunexaldiamak kakuldák na gua. ");
INSERT INTO kog_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Atshak ezua sigí Ananiya axezhukaja, asewá Sapilda na kauwijí kagi nabeyasá. ");
INSERT INTO kog_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ekí nabeyasañgueni paldata agaxeguake asewá na izhgakualdi anuñkaki ishkabajañgueni, anuñkaki Duwejañga gaxanekuek axautshi agaxaunexaldiamak akualdák. ");
INSERT INTO kog_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Guake Pégulduja ekí Ananiya axaldék: —¿Sakíga jisé miksanegaka majañguatshak shi Jatetshi Alduna naldagálde nuxa namak ne jañgushamildaka mikldeklde na? Jinake ekí mikbeyakí. Kagi nabesamalde shalda auxaga makeká jana agatsaldi makegatshak jiaga, anuñkaki mijí ishkabaja atshamalde nak. ");
INSERT INTO kog_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kagi nabesagá maldogueñga ¿mijí naldazhá shi guaná? Ai nabesamalde paldata migasabineki ¿majañguamak jiba akbemildaka naldazhá shi guaná? Ne ¿sakí zhinik shi ekí sha atshamalde na? Ekí matshatshake káguba za naldagálde jañgushamildaka mikldegagába, Jatega guana naldagálde jañgushamildaka mikldeshi atshamalde naldashá. ");
INSERT INTO kog_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ekí Ananiyaja nukatshaga na shuanega pená. Ekí shuane saldiñga aldukajekuejañki atemajañ zhe na kakzexá. ");
INSERT INTO kog_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Guñguake anuñka nakuakue aldaxeni ají abuá abañguñgueniki kagi iyashál awaldé. ");
INSERT INTO kog_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ekí sigí shuiguenik nauwa auxa zegatogueñki, “ekíga ni zegatók” akldegagáldega asewá jiaga nak. ");
INSERT INTO kog_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Guake Pégulduja paldata tuñshi ekí aklduká: —Nakbeyá guwá. ¿Januñka akzaldi shi misewá na kagi nabesaminá? Guake akiyó: —Akze, tuanuñka akzaldi zʉñgaxene nakldá. ");
INSERT INTO kog_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Guake Pégulduja ekí axaldék: —¿Sakí zhinik shi maiñ Jatetshi Alduna ekí agatsaldi miñguajaldixa ishkualdi nominá? Tu guwá. Misewá kagi iyashál nenaldekue mokue nagaté tiuwi. Ne kaigaki ma jiaga kagi miyashál mawaldeyaldixa nakldá. ");
INSERT INTO kog_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ekí akbeyatshaga na, munzhi jiaga Péguldu stak shuanega pená. Gueni nakuakue ajuldunatshake shuanega atuwakna, ají abuá jiaga awaldeñgueni asewá kagi iyashané tezhak kagi iyashá. ");
INSERT INTO kog_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ekí zegatshakna Duwe ipananekueki atemajañ zhe kakzék. Ekíga na, saldiñga ekí zeklde aldukanekue jiaga zhe na kakzexá. ");
INSERT INTO kog_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Guatshakna Duwejañga gaxanekueki aldéñga kama kageká awatuñshi na, kágubakue kenañ atemajañ janshizhe ajanashaté atú guazhámak matshuwi ajanashá. Atshak baxañga saldiñga Duwe ipananegaba juwí Jate axazakuakakga jueyáñ zalda akldikue Saldamóñtshi akuageñka izhajuizhaldexalga na aldoxá. ");
INSERT INTO kog_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Guatshake axautshikuejañki Duwe ipananekue muldetua axabeti guatogatshak jiaga, ekue nañga kagatsé kawatuexañ zheñga na kakzegatoxá. ");
INSERT INTO kog_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Naldatshak akldé akldeñga sigí, munzhikue juizhi nauwijí Sáñkalda Duwe Jesú “namak nzha” ajañgui na, e ipananekue na izhgaldiyaldá na akuá. ");
INSERT INTO kog_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Guatshak Duwejañga gaxanekueki janshizhe ajanashaté atuatshakna, kágubakueja aldeyeñka mulbatá akzekakue iyaxabaka nañga agabexa ashá. Ekíki Péguldu zʉxaitatshake ají nuñgá nuxaki iskaiti neyatshake se kakzukualdiamak. ");
INSERT INTO kog_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ekíga na, Jeldusaldéñ akyó kuíbuldu nukakueldi zhinik jiaga káguba matshuwi izhgazhé Duwejañga gaxanekuek axaldák. Ekí axaldagatshakna, mulbatá kaxakzekakue, jisétshi alduna ijuldune shañgá akzukuatukakue juizhi akualdagatshakna, muldetua nuk se kakzukuá na gua. ");
INSERT INTO kog_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ekí Duwejañga gaxanekue nugaldiñgaba aldeyaté atuatshakna, Jatek múldigaba agaskaitshixa akldé akzé, e agauneka saduseyukue na agatsekue juizhi atemajañ mauldí kakzexaldá. ");
INSERT INTO kog_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ekí kakzeguakna Duwejañga gaxanekue guxa kalseldi mexal akuák. ");
INSERT INTO kog_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amak kabexane nalgué jiaga, ai siañki Saldiñga netshi Sáñkaldajañga aldéñ guaklde uldeñka kagakagatshak kalse kagakpeshi, kakzʉxaitshiñgueniki ");
INSERT INTO kog_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ekí kakbeyá: “Juwí Jate axazakuageñka mineyaldí. Exa akté noshi, Jateja Asukuák zhinik abisajañ mimakukshi izhoshiñga mimezhokshaka shalda auxaga exa zhekuekuek miyakbeyaldí.” ");
INSERT INTO kog_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ekí aldukanalguamakna abokualdi muñshaga juwí Jate axazakuageñka aldeñguenik, exa ashekualdekue amak shi kaxaldiyaldá. Ekí zeklde kaksʉ́ñga na, Jatek múldigaba agaskaitshixa akldé akzé, aldéñ na agatsekue juizhi aldagatshakna, kauwisaná Isayélkue nauwa akldé akzekue juizhaldegakue akuák. Amak ajuizhaldegatshak saldiñga akldé akzekue sanekakuegaba ajuizhaldék. Guñgueni Duwejañga gaxanekue kalseldi kagakuxal akuák. ");
INSERT INTO kog_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Guake kabukueja akuxal aldeyatshak atuazhá guakna, sáñkaldakuek ekí agabeji mokue aldák: ");
INSERT INTO kog_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Zʉñmeminamak, kalsexa kaldeyatshake muldetua nikuega te, kabukueki jugatezhakga akteté ni katuwá. Guake eni kajuldunatshake ni me isʉ́ñ nzhaldá.” ");
INSERT INTO kog_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ekí aldukatshakna juwí Jate axazakuageñka numañ zʉtuñkakuetshi sáñkalda, Jatek múldigaba agaskaitshixakuetshi sáñkaldakue na “¡sakíga ni jañguakuá!” kakzaldazháldi na, “¿ekí zeshi mashi akldañkaldixa ne?” na ajañguá. ");
INSERT INTO kog_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Atshaga na, ezuajañki nagueni ekí kakbeyá: “Nukaté nogwíñ. Maiñ sigíkue kalseldi mexaminekue ne, kaigaki juwí Jate axazakuageñka kágubakue shi kaxaldiji akteté nagaldók.” ");
INSERT INTO kog_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ekí aldukatshakna kabutshi sáñkalda, ají kabukue juizhi Duwejañga gaxanekue akuxal aldé. Gueni awaldaká akiyasalshaldiák kágubakueja jagi keyabushi kakuagaka zhe kakzukui na, akiyasalshagába kawaldák. ");
INSERT INTO kog_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Amak kawaldagueniki akldé akzekue sanekakuegaba buan keyaldañgashatshakna, Jatek múldigaba agaskaitshixa akldé akzejañki ekí kaxaldék: ");
INSERT INTO kog_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Nasʉñ ejié Jesú shalda shizhiyasʉ́ñze giemi miñmeñkalde nogashá. Naldatshak miñmeñkaldamak zʉñkatshagába, saldiñga Jeldusaldéñ zahauxa e shalda shizhiyaminegaba zegashá. Ekí me atshagábaki, ejié Jesú nasʉñga guaxáñkalde zʉñkazgundana miyatshashá. ");
INSERT INTO kog_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Guake Pégulduja, aldéñ janañga Duweja gaxanekue na ekí ayó: —Nasʉñki Saldiñga netshi Jateja guana axatshakue zʉñmeyamak akldé giemiki atshakue zʉñgatsaldashá. Ne kágubaja nuxa atshakue zʉñmeñkáki aguañga atshakue zʉñgatsaldashá. ");
INSERT INTO kog_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Akze, maiñki Duwe Jesú kaldixa axaldiya akuakshá guamine nalgué jiaga, nauwibamakuetshi Jate, Saldiñga netshi Jatejañga mokue izhgaldakshá guane. ");
INSERT INTO kog_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Aldéñga na Asukuá akaldak akzukui, jékaldaxa ulditshigatshak kágubakue kekualdi, kaksanexaldiamak niuwi ageshi, aldéñ sanegatogéñ jibatshaldi mual akldé akzeñka itene. Ekíki Jate zʉñgauneshiñga na, nasʉñ juldiú saná Isayélkuañ sha katshixa majiñga maja xaldeki agakualdinakualdiamak, sha katshixa zʉñkabetaldiamak. ");
INSERT INTO kog_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Akze, nasʉñki ekí zeklde tuñkaldamak kágubakuek kakbeyañkalduka. Ekibeñga na, Jatetshi Aldunaja jiaga ai namak ne katuñshixa. Akze, Jateja aldéñ amak kaxatshixakueki ají Alduna zʉñkaldaldaldiamak zʉñgeka nakldá. ");
INSERT INTO kog_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ekí guagaté aldukatshakna, sáñkaldakueki zʉ́xaita nusá kakzekága nuxa kakuaxa gundana na kakzexá. ");
INSERT INTO kog_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ekí kakzegatshak exaga ezuañki Gamaldiél axezhuka saldiñgaja axabetixa, paldiseyukue na agatsega, guiyaba shizhixa na izhoxá. Eja na akldé akzekuegaba kenañ izhgaldagueni Duwejañga gaxanekue ai zhinik maldé nuxa kakzʉxaitshakue guaguenik ");
INSERT INTO kog_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ekí kakbeyá: —Nasaná Isayélkuañ, ejié sigíkue sakí miñgualdixa jañguabinuka muldetua jañgua xaldek miyatshaldí. Ekí be izhgisekuwíñ. ");
INSERT INTO kog_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nauwa anuñka kagi zalguéñ Teyuda, eñki san zaldakue zʉñsaneka kakzʉxaitshaka jañgui na, axaldáñ za akzé neka nalguakna, anuñka sigígaba 400 agaunexaldixakue agapa aldeyaldá. Guane nalgué, e akuagatshake agapa neyatoguekueki san san nuk ishkajuezhá. Ekí zeguakna ji atshaldixa janaktune nalgué, amak atsha akzegazhá. ");
INSERT INTO kog_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ekí zegueni jiak, anuñka zalguéñ káguba izatakue niuwañ zegatogueñki, ezua sigí Galdildeya zaldaga Juda axezhuka izhoxaldá. E jiaga san zaldakue zʉñsaneka kakzʉxaitshaldiamak jañgui na, anuñka kágubakue agaunexaldiamak kezhgaunshaldá. Guane nalgué, e jiaga akuagatshake agapa neyatoguekueki san san nuk ishkajuezhá. ");
INSERT INTO kog_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","”Akna Jesúk agapa neñkakue shalda ekí guiyaba miñmeyaldikue. Ejié sigíkue ji ajanashatuka kagitamakuagábaki, egaba kebesa nuxa guwíñ. Jinake ekí miñmeyakí. Ekueki ji ajanashiji, shizhaldiyaldixa janagatuneki kágubaja nuxa janaktune naldiake, amak atsha kakzegazháldixa. ");
INSERT INTO kog_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ne Saldiñga netshi Jatejañga ekí ajanashiji, shizhaldiyaldixaki niuwi kagene naldiák zʉnake, kagitamakua miñzegazháldixa. Akze, ekí miyatshaldiák, Saldiñga netshi Jate naldiñga miñguldiji, kaugakshaminaka naldaldixa nzha. Ekí kakbeyake amak axalduká. ");
INSERT INTO kog_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Guatshak jiaga, Duwejañga gaxanekue kauldaxal akuagueni, kuizhushak anuñka juizha kagaldabikshá. Gueniki Duwe Jesú shalda akldé guagasʉ́ñze kagatsé naldaldixa niuwi kagaxeshi keyabesá. ");
INSERT INTO kog_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Guake Duwejañga gaxanekue amak sáñkaldakue nugaldi zhinik agazaxaitixáki zeñ izhajani aldé. Jinake zeñ izhajanazhá. Jateja Asukuá iyapananéñ zhinik akldé kakzukui mual guiyaba tuakue kajañguane kakualguák. ");
INSERT INTO kog_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Gueni niuwi neyauxa ezua tshuxa, ezua tshuxa, juwí Jate axazakuageñka jiaga “Jateja ezua zʉnekualdal gaxaldixa guakldaneki Duwe Jesúga nakldá” kágubakuek agabeji, shaxaldiyalga na aldoxá. ");
INSERT INTO kog_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Atshake kágubakue akldé akldeñga Duwe Jesú iyapanaldá. Aikuega na anuñka nekueki galdiegu azakuaka, ne akldé nekueki ebeldeyu azakuaka. Naldé na, niuwi neyauxa munzhi sigí ishuanekue ji kagajueshka agaxegatshak, galdiegu azakuakakueki kagaxegakue zaldamak kagaxegakí naldák ebeldeyu zukuakakue kiejo akualdá. ");
INSERT INTO kog_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ekí zegatuka aldukajakna, Duwejañga 12 ají múldigaba guaxal gaxanekueja Duwe ipananekuegaba nuk kajuizhakuñguenik ekí kakbeyá: “Akze, nasʉñki Jatetshi múldigaba Duwe Jesú shalda guana guagatogakue zʉñgatsaldashá. Ne amak guagagábaki, ai munzhikue ji kagajuezhatuka kagegakualdiamak za atshaldá guakualdiake, atshakue zʉñgatsahamak atshañkaldáaldixa naldashá. ");
INSERT INTO kog_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Akna gajakuañ, mimikenañga kugua sigíkue Jatetshi Aldunaja auxaga kaksaneshi, muldetua jañguxa mituñkakue ai jiba kagegakualdiamak miniyaldí. ");
INSERT INTO kog_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ekíki nasʉñki Jate za axazguaxalga, ají múldigaba guashi, shizhiji, ai za atsha alduna jañguakualdiamak.” ");
INSERT INTO kog_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ekí atshakue akuagatshakna saldiñgaja “janshibé nukshí” na ajañguá. Akna amak ai jiba agaxexaldixakue ishkakuxaldá. Guakna Estebañ, eñki Jate muldetua alduna ishixa, Jatetshi Aldunaja auxaga aksaneka ishkakuxá. E nañga na ekí axezhukakue ishkakuxá: Pildipi, Puldókuldu, Nikanól, Timón, Padmena. Ezuañki Nikuldá, eñki Antiukia zalda, juldiú saná naldagálde naldatshak, juldiúkueja Jate ajañguamak jañgualdixa izhgakuxane. ");
INSERT INTO kog_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ekí ishkakuxeniki Duwejañga gaxanekue nugeñka kawaldé. Guake ekuejañki Jateja kagaunexaldiamak akshishi na, ezua ezua sáñkaldak káuxalda kepañgui ai jiba kageshi keté. ");
INSERT INTO kog_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ai zhinik na, múldigaba Jateja Asukuá gaxane shalda akldé akldeñga kágubakueja aldukaldá. Ekí aldukshi na, Jeldusaldéñ zaldakueja Duwe namak ajañgui iyapananekue matshuwi izhgaldegatshakna, matshuwi Jatek múldigaba agaskaitshixakueja jiaga “Duwe Jesúki zʉnekuanamak nzha” ajañgui, iyapaná na akuá. ");
INSERT INTO kog_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Guatshak Estebañki Jateja naldiñga muldetua ají kama agegatshak, atemajañ atú guazhámak kágubakue kenañ atshiji izhogatshak, Jatejañga ekí atshishane atuñshá. ");
INSERT INTO kog_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Naldatshak anuñkakuejañki Estebañ kaguldiyaldá. Ekueki juldiúkuegaba juwí “nashi jáugukui akldogaksá guanekue izhajuizhaldegeñka” akuageñka ajuizhaldekakue. Aikuega na, anuñkaki kuíbuldu Sildenexa, Aldejandaldiyaxa zaldakue, anuñkaki Sildisia baxe, Asia baxe zaldakue. Ekueja na Estebañ múldigaba akiyatamakuatshak jiaga, ");
INSERT INTO kog_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","akizhgatiñgua kakzegazhá. Jinake naldakí. Jatetshi Aldunajañga muldetua ishkué nahamak guakshatoxák. ");
INSERT INTO kog_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ekí atuwakna, naldagálde Estebañ izhakuaxaldiamak anuñka sigíkue ziñgaba shaxajiú. Guakna ekí akuák: “Nasʉñ naldi nukañkaldoguéñ Estebañja nauwibama Muesé, Saldiñga netshi Jate jiaga nalda aguashi, aguáñ izhbashi mual guagaté nukáñkalde nzha.” ");
INSERT INTO kog_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ekí guagatshakna káguba exa ashekualdekue, kauwisaná nauwa akldé akzekue, guiyaba shizhixakue juizhi kalzaulshá. Ekí kalzauldi na, Estebañki iyapangueni akldé akzekue sanekakuegaba ashekualdeñka awaldé. ");
INSERT INTO kog_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Exaki jiak anuñkakue akldé Estebañ shalda naldagálde guaxaldixakue awaldák. Guake ekí akuaxaldá: “Ejiéjañki juwí Jate axazakuaká nalda aguashi na, nauwijí guiyaba Jateja nauwibama Muesék zʉñkabajane jiaga abá naldakí nalda aguaka nakldá. ");
INSERT INTO kog_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ekí neshi na, axaxak naldi ekí guagaté nukáñkalde. ‘Jesú Nasaldéxa zaldaja jejié juwí Jate axazakuaka tiñgualdixa nakldá. Ejañga na nauwibama Mueséja sakí izhogakue zʉñkabajane yushaldixa nakldá.’” ");
INSERT INTO kog_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ekí aldukatoguéñ, exaga akldé akzekuegaba ajuizhaldegéñ ashekualdauxaja Estebañ muldetuañga atuatshake, ají waxaki Jateja guaklde uldeñkatshi waxa muñshí stuamak na stuaté atuwá. ");
INSERT INTO kog_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Guñgueni Jatek múldigaba agaskaitshixa akldé akzejañki Estebañ ekí aklduká: —¿Namak shi ma shalda ekí agatsaldi mizhakuák? ");
INSERT INTO kog_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Guake ekí kakiyó: —Gajakue, jatekue, muldetua naldukaté minoxaldí. Saldiñga netshi Jate, e za atemajañ akaldak akzeja nauwibama Abaldahám akizhañká guanane. Atshagaki, nauwibama kuíbuldu Aldán neyagáñga Mesopotamia baxe izhogueñga ");
INSERT INTO kog_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","amak akizhañkaji na ekí akbeyá: “Mijí kagi, mikajakue maja xaldeki nas miksaneshiñga kagi matuñshaldikueñka maldeyaldí.” ");
INSERT INTO kog_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","”Ekí akbeñguamak ají kagi Mesopotamiaga, Kaldeyakuetshi kagixa zhinik neñgueni Aldánka neyatshak, exa anuñka izhogueñga na ajate ishuizhá. Guñgueni Jateja aksaneshiñga na, kaiga kagi katshekuéñ izhoxal uldakldane. ");
INSERT INTO kog_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Jateja amak jai uldagatshak jiaga, atshagaki nauwibamak kagi ité no guashi nuxaki agegazháne. Naldatshak aldéñga ekí axatshaldixa akbene: “Aldiweki ma jejié kagi mijí tukuaxá miñgenaldikue na, mimijí za naldalga noxaldixa nakldá.” Atshagaki nauwibama ni sukua ezua nuxaki axaldegagáldega naldé jiaga ekí axatshaldixa akbeyá. ");
INSERT INTO kog_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Guñgueniki Jateja ekí jiaga akbenane: “Mijí tukuakueki kauwijí kagi naldagálde axautshitshixa ashekualdaldixa. Exaki 400 kagi ashekualdi na, eñka zaldakuejañga kauwijí jiba za katshishi, nashi kakuí, guiyaba katuñshaldixa 