﻿USE sofia;
DROP TABLE IF EXISTS sofia.knv_fly_river_vpl;
CREATE TABLE knv_fly_river_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES knv_fly_river_vpl WRITE;
INSERT INTO knv_fly_river_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ya꞉su Kelisoko ebe Da꞉ibidikono walone gudula, ega꞉walo Da꞉ibidiko ebe A꞉ibalayamakono walone dawala, ebene me ebe Ya꞉sukono mabu epono mailono tanalola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","A꞉ibalayamako tetene wagilimite Da꞉ibidiko teta꞉mo pemaiga, Ya꞉sukono mabu epono tanalo ma kunula — A꞉ibalayamakono gudu Aisa꞉ketela. Aisa꞉kekono gudu Ya꞉ikobotela. Ya꞉ikobokono gudu Yudatela, wiyasiya Yudako kapiya kosiyodiliya꞉, ebeno nani ega꞉walo ekaki epetapi eba꞉go nilukulinamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudakono gudi netewa Peleseko ega꞉walo Silako, ibino menoko Ta꞉imatela. Pelesekono gudu Esalonatela. Esalonakono gudu Lamatela. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamakono gudu Aminadabatela. Aminadabakono gudu Nasonatela. Nasonakono gudu Samonotela. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Samonokono gudu Bowasetela, ebe guduno menoko La꞉iya꞉batela. Bowasekono gudu Obedatela, ebe guduno menoko Lutitela. Obedakono gudu Yesitela. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesikono gudu Da꞉ibiditela, ebete Isalaela opono Kawo Elawodubuma꞉ eda꞉nami. Ebene Da꞉ibidiko tetene wagilimite Yekonayako teta꞉mo pemaiga, Ya꞉sukono mabu epo me ebe Yu epo Kawokawo Elawodubula, ibino mailono tanalo ma kunula — Da꞉ibidikono gudu Solomonotela, ebe guduno menokote dopamo Ulayakono kamiyalema꞉ eda꞉nami. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonokono gudu Liyobaumatela. Liyobaumakono gudu Abayatela. Abayakono gudu A꞉isatela. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","A꞉isakono gudu Yosapatatela. Yosapatakono gudu Yolamatela. Yolamakono gudu Usayatela. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usayakono gudu Yautamatela. Yautamakono gudu A꞉iyasatela. A꞉iyasakono gudu Esekayatela. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekayakono gudu Ma꞉na꞉satela. Ma꞉na꞉sakono gudu A꞉monatela. A꞉monakono gudu Yausayatela. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yausayakono gudu Yekonayatela, wiyasiya ebe kapiya kosiyodiliya꞉, ebeno ekaki epetapi eba꞉go nilukulinamiya. Yekonayako tetelo Ba꞉baloni gowelaopiate pelamete Isalaela opo epo elawamo puwatete ibino Ba꞉baloni oponomamo ebo magataliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ebene gowelaopiate ibi Ba꞉baloni opamo demagataliya, ebe tetene wagilimite Yausepeko teta꞉mo pemaiga, Ya꞉sukono mabu epono tanalo ma kunula — Yekonayakono gudu Siyatiyelatela. Siyatiyelakono gudu Selababelatela. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selababelakono gudu Abiyudatela. Abiyudakono gudu Elayakimitela. Elayakimikono gudu A꞉isotela. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","A꞉isokono gudu Sa꞉idokatela. Sa꞉idokakono gudu A꞉ikimitela. A꞉ikimikono gudu Eliyudatela. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudakono gudu Eliyesatela. Eliyesakono gudu Ma꞉ta꞉natela. Ma꞉ta꞉nakono gudu Ya꞉ikobotela. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ya꞉ikobokono gudu Yausepetela. Yausepeko ebe Ma꞉likono awila ega꞉walo Ma꞉lite Ya꞉suko alaimiya, ebe gudu epate Godokono Alibodawa Kelisoma꞉ ka꞉minaka. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ebema꞉ Ya꞉sukono mabu epono tanalo ma kunula. A꞉ibalayamakono tetene wagilimite Da꞉ibidikono teta꞉mo pemaiga 14 epola, ega꞉walo Da꞉ibidikono tetene wagilimite gowelaopiate epo Ba꞉baloni opamo demagataliya ebe teta꞉mo pemaiga 14 epola, ega꞉walo Ba꞉baloni tetene wagilimite Kelisokono teta꞉mo pemaiga 14 epola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ebene Ya꞉su Kelisote keba kunu kawokaliyale, me ebe tanalola. Ebeno menoko Ma꞉liko Yausepetamo natamiya, ebene iba꞉te kapiyama꞉ eda꞉no, Ma꞉lite dopamo iyatawiya ebete Godokono Uliyanamo lamituma꞉ eda꞉te gudu kalaimimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ebeno awi Yausepeko ebe wade tuputupudawanomola. Ebema꞉ ebete Ma꞉liago kapiyama꞉ eda꞉no ebete ebeno lamituma꞉ eda꞉ tanalo diyatawiya, ebe tetelo ebe ubila Ma꞉liko gelebadiago alibutima꞉, mabu ebe ubia꞉nola epono ololo apulo ebetamo ilipo ikaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wiyasiya ebete me tanalo eba malagidilolo Kawodawa Godokono nopodawate iyo gabodo ebetamo maiganate negeni, “Da꞉ibidikono a꞉la꞉mu Yausepe, a꞉ma꞉le Ma꞉liko a꞉imano kamiyalema꞉ eda꞉ma꞉ akotoletola꞉la꞉, mabu ebeno tepo magumulo da꞉luta ebe gudu Godokono Wade-talena Uliyanate ebetamo ikami. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iyo, ebete dubu gudu kalaimimene ebene a꞉ma꞉ ebeno mailo Ya꞉suma꞉ neka꞉miye, mabu ebete ebeno epo ibino iyaiya kuba osiyodilole magumune uwatete ibino igilo ka꞉mula꞉lelaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ebene me tanalo bilibilinomate emaimiya, Kawodawa Godote ebeno woki awokalimidawado degiya ebe tabote nanitaboma꞉ keda꞉ma꞉, iyo, iyalo tetelo ebete tabo ma kunu giya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Buwelete lamituma꞉ eda꞉te dubu gudu kalaimimene, ebene iba꞉te ebeno mailo Ima꞉nuwelama꞉ keka꞉ima꞉na꞉.” Buka ka꞉la꞉mioledawa, modobola a꞉ma꞉ niyatawa me Ima꞉nuwela mailono magumu nitana ‘Godote ago nokolina.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ebema꞉ Yausepete u wata baine maiganate Godokono nopodawate ebe beda꞉ tabo kananiyale, ebete ebe tabamo tuduwatate Ma꞉liko ebeno kamiyalema꞉ ebo lawiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wiyasiya Ma꞉lite gudu Ya꞉suko alaimia꞉no Yausepete dopamo eba꞉go kapiyama꞉ kediya꞉, ebene Ma꞉lite Godokono gudu dalaimiya ebe tetelo Yausepete ebe Ya꞉suma꞉ ebo ka꞉miya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Elodite Yudiya opolo Kawo Elawodubuma꞉ eba eda꞉nalo, idoko idilo Ya꞉sute ebe opono Beteliyama duliyomololo ebo awokalani. Ebene egela epetapi da꞉petoiya, ebe tetelo mulolo mawele ka꞉la꞉miolepi dubate egelate da꞉pemaiganako eba apune mulu opone pelamiya Yudiya opono kawo duliyomolo Yelusalemamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Iba꞉te ma kunu pegeliya, “Keleka꞉ Yu epono Kawo Elawodubuma꞉ eda꞉ma꞉ dawokali ebe gudu? Ale ebeno mawele aimano mulu opolo umite ebe amamatema꞉ pelaema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ebema꞉ Kawo Elawodubu Elodite me tanalo dolowiya ebeno tepo magumulo woki bilibilinomoma꞉ ediya, ega꞉walo Yelusalema kawo duliyomololo dilukulionamiya ibi bilibilinomate atumu woki bilibili tanalo ebo kelawiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ebene Godotamo kalimagono ikameopino ununomo watowatopi ega꞉walo Godokono Totomu iyatulamepi, Elodite ibi bilibilinomo ebetamo ka꞉la꞉mite nalateda꞉liya, “La꞉imano woki keba kunula꞉ka꞉? La꞉ Yu epono Kawo Elawodubu Kelisote kebe duliyomololo nakawokalamene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iba꞉te ebetamo nowamiya, “Ebete Yudiya opono Beteliyama duliyomololo kawokalamene, mabu Godokono woki awokalimidawate Godokono Bukamo tabo ma kunu akuloliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Beteliyama duliyomolo Yudiya opolo ditana, Yudiya opono kawokawo elawodubu magumulo a꞉ma꞉ da꞉pesoa꞉, mabu a꞉ma꞉ magumune epono watodawate kemaigamene, naimano Isalaela epo ebete bulamenamene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ebene adimo tetelo Kawo Elawodubu Elodite mawele ka꞉la꞉miolepi diya gabodo ebetamo ebo ka꞉la꞉mini, mabu ebe ubila mawelete kebe tetelo kemaiganiyale iba꞉godone ebe tete kiyatawanama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ebete ebe tanalo lawenate ibi eba alibolenalo nanaleni, “La꞉ tolama꞉wete Beteliyama duliyomololo gudu wadenomamo nowadiawete da꞉numa꞉ema, modobola la꞉ walo ka꞉pelama꞉wete na napananiyala꞉, ebene nale atumu ka꞉tote ebe kakanamamatemamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ebema꞉ mawele ka꞉la꞉miolepiate Elodikono tabo olowinate gito tolameniya. Ebene iba꞉te eba tolamenalo, egelate da꞉pemaiganako ebe mulu opolo dopamo duminiya, ebe atu mawele walo na꞉ka꞉numiniya. Ebe tetelo iba꞉te mawele da꞉ka꞉numiniya kalakala ebo nelaweniya, o kalakala beda꞉ kawonomola꞉ka꞉, ebene ebe mawelete ibi dopolamenate eba tonalo, gudute kebolo kowataniyale mawelete ebe tetenomamo gito nutini. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ebema꞉ iba꞉te ebe moto guamo nopila꞉onate gudu ega꞉walo ebeno menoko Ma꞉liko ebo nulameniya. Ebe tetelo iba꞉te ibino pupamo eba ilukulinalo gudutamo tudila꞉onate ebe ebo amamateniya, ebene iba꞉te dopamo mani kawokawonomamo duwateiya ebe nilakapo inamabu waulatelenate gudutamo ebo ikameoniya, ma kunu golodo mani, ape abutimino wade nibo inamabu, ega꞉walo wade nibo ii inamabu idi. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ebe idokolo Godote iyolo ibi nanaleni, “La꞉ Kawo Elawodubu Eloditamo walo akotolama꞉la꞉,” ebema꞉ egela idilo iba꞉te wagilimite gabo idido ibino oponomamo ebo tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ebene idoko idilo Kawodawa Godokono nopodawate Yausepetamo iyolo pemaiganate ebe napanani, “Modobola a꞉ma꞉ samonomamo maigawete, gudu ega꞉walo ebeno menoko uwata꞉wete Isipiti opamo nalauta꞉la꞉. La꞉ ebolo eba nokolionalo, kebe tetelo nale la꞉ dakanaletama la꞉ mamo walo ebo ka꞉ka꞉pemamota, mabu tete tatalila Elodite gudu anakapuima꞉ Beteliyama duliyomololo ka꞉powadimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ebe tetelo Yausepete maiganate gudu ega꞉walo ebeno menoko uwatenate Isipiti opamo to gabodo ebo toniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ebema꞉ iba꞉te Isipiti opamo nemaimite ebo nokoliya Kawo Elawodubu Elodikono a꞉e teta꞉mo. Me tanalote ma kunu pemaigiya Kawodawa Godote ebeno woki awokalimidawado degiya ebe tabote nanitaboma꞉ keda꞉ma꞉, iyo, iyalo tetelo ebete tabo ma kunu giya, “Naimano gudute Isipiti opone ka꞉pema꞉ nale ebe keka꞉imamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ebene mawele ka꞉la꞉miolepi dubate Elodiko a꞉da꞉ demasigiya, ebete me tanalo iyatawate kawonomamo dowiya. Ebe ubi kawonomola gudu Kelisoko anakapuima꞉, ebema꞉ ebete Beteliyama duliyomololo ega꞉walo niyakabolo dilukulinamiya ebe epatamo gowelaopi dubu aliboliya, iba꞉te tolamete netewa ulama tete dubu gudi ega꞉walo a꞉lia꞉li gudi bilibilinomo kananakapulaema꞉. Ebete ma kunu osiyodiliya mabu mawele ka꞉la꞉miolepi dubate ebe aniya kawo mawelete iyalo netewa ulama tetelo dopamo emaigani. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Me tanalote ma kunu pemaigiya Kawodawa Godote ebeno woki awokalimidawa Yelemayado degiya ebe tabote nanitaboma꞉ keda꞉ma꞉, iyo, iyalo tetelo ebete tabo ma kunu giya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“La꞉ima duliyomolo epagodone iimi kawonomote maiga, mabu Lesula꞉te ebeno gudi liyalamena! Iyo, ebete gowelalo diina katepana꞉, mabu ebeno gudi bilibilinomate nanitabolo a꞉ela.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Walone tetelo Elodite da꞉iya, Yausepete Isipiti opolo eba okolinalo Godokono nopodawate iyo gabodo ebetamo ebo maigani. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nopodawate ebe nanani, “A꞉ma꞉ gudu ega꞉walo ebeno menoko uwata꞉wete, la꞉ Isalaela opamo na꞉kolowamiyala꞉, mabu gudu anakapuima꞉ dowagelenamiya iba꞉te a꞉elaiya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ebene Yausepete maigate gudu ega꞉walo ebeno menoko uwatete Isalaela opono pe gabodo walo na꞉ka꞉piya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wiyasiya Yausepete tanalo idi ma kunu olowiya, ka꞉lo Elodikono gudu Akeleyasiko ebete ebeno nabiwino gobebobo lawete Yudiya opolo Kawo Elawodubuma꞉ edi. Ebema꞉ Yausepete Yudiya opolo nokolima꞉ da꞉toletoliya, ebe tetelo Godote iyo gabodo tabo idi ma kunu palibiya ebete Ga꞉lili opamo ka꞉toma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ebene iba꞉te Ga꞉lili opono Nasalete duliyomolamo nemaimite ebo nokoliya, mabu iyalo tetelo Godokono woki awokalimipiate negeliya, “Epate Kelisoko Nasalete duliyomolodawama꞉ keka꞉ima꞉na꞉,” ebema꞉ me tanalote ma kunu pemaigiya Kawodawa Godokono tabote nanitaboma꞉ keda꞉ma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ebene ulama epetapi da꞉petolamiya, ebe tetelo Yoneko epo obamo waduba꞉midaoledawate pete Yudiya opono bulu opolo Godokono tabo ma kunu pa꞉kiyawaiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“La꞉imano kubane nolobila꞉la꞉, mabu Godote Kawo Elawodawama꞉ deda꞉na ebe tanalote na꞉pe!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nanitabola, Godokono woki awokalimidawa Aisayate dopamo Yonekono pe tanaloma꞉ tabo ma kunu giya, “Lumagite bulu opolo tabo ma kunu kawonomamo ka꞉pegemene, ‘Kawodawano gabo nosiyodiloma꞉la꞉, ebeno gabo na꞉tupugaima꞉la꞉!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ebe tetelo Yonekono okoli tanalo ebe epo epetapino ilukuli tanalo keba kunula꞉ka꞉ eba kunua꞉, mabu ebete ka꞉molo-goeo ipo kuba kaliku kau-goeo tama batago pulinaki, ega꞉walo ebeno bae siguniya ega꞉walo molo naonaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ebema꞉ Yelusalema kawo duliyomolo epo ega꞉walo Yudiya opo epo epetapi ega꞉walo Yodane Kolomo apulo dilukulionamiya, ibi bilibilinomate Yonetamo tolamiya ebeno tabo olowioma꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ebene iba꞉te ibino kuba danawokalilamoliya, ebete ibi Yodane Kolomolo obamo ebo waduba꞉midaoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ebe tetelo Pa꞉lisi tanebapi ega꞉walo Sa꞉diyusi tanebapi, ibi epetapi bilibilinomate Yonetamo tolamiya ebete ibi obamo kowaduba꞉midaolema꞉, wiyasiya Yonete ibi ulamete iba꞉tamo negiya, “La꞉ bu kalulata! La꞉ potele kanaletia obamo waduba꞉midaolema꞉ da꞉pelama꞉ema, ba꞉, Godokono kawo dowa tanalonomote la꞉tamo a꞉ka꞉pemene? Ao, ka꞉pemene! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","La꞉imano tepo magumu iyakobi da꞉midila꞉ema, modobola la꞉ la꞉imano nanitabo tanalo awokalima꞉ wadewade tanalo nosiyodilola꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","La꞉ a꞉ka꞉tuwa꞉ la꞉imano wokilo ma kunu akogelanakala꞉, ‘A modobola mabu A꞉ibalayamako ebe aimano ewono nabiwila.’ Ao, la꞉ a꞉ka꞉modobomata! Na la꞉tamo nani tabo gemo, Godogodolo elawo bitana ebete me nokolamo A꞉ibalayamakono gudi kosiyodilolema꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ebema꞉ ka꞉lo Godote ebeno kabi a꞉li, noloa꞉ da꞉imi kewa bilibilinomo ebete lute elamo kiyalekemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“La꞉ epetapi la꞉imano kubane dolobila꞉ima, nale ebe tanalo kawokalima꞉ la꞉ obamo waduba꞉midaolemata. Wiyasiya lumagi idino elawo kawonomola, naimano elawo nodoliona, ebema꞉ na wadenoa꞉ ebeno agowa ukulaleno obo aguwataema꞉. Ebete naimano walogabo apune ba꞉pena, ebene ebete la꞉ Godokono Uliyanamo ega꞉walo ebeno elamo ka꞉powaduba꞉midaolema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iyo, ebete witi-laisono nonoka balamo alomono inamabu elawi, ebene ebete witi-laiso naono ebeno moto guamo eba alomolo nonoka elamo ebo kiyalekemene, ebe elate uwomua꞉ tetelo nowaena, ka꞉egana꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ebene Ya꞉sute Ga꞉lili opone Yodane Kolomamo Yonetamo piya, ebete ebe obamo kaduba꞉midama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ebe tetelo Yonete negiya, “A꞉ma꞉le na obamo aduba꞉midanema꞉ modobola, wiyasiya mabu keleka꞉ a꞉ma꞉ ebe tanalo nagodone laema꞉ da꞉pa꞉wa꞉? Modoboa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Wiyasiya Ya꞉sute ebetamo negiya, “Modobola a kosiyodilomalema꞉, mabu Godokono tuputupu gabodo tolame magumulo ebete a tanalo bilibilinomo osiyodilolema꞉ danaenakomene, ale ubia꞉noma꞉ a꞉keda꞉onakoma꞉.” Ebe tetelo Yonete Ya꞉sukono tabamo tuduwatate ebo osiyodiliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ebene Ya꞉sute obone eba pidiwilo, ebe tetenomolo Godote ebeno Unu Duliyomolo a꞉iyamiditalo ebo umiya, ega꞉walo ebete tanalo idi ma kunu kumiya, Godokono Uliyana bigo ola keba kunula꞉ka꞉ eba kunu piwisigate ebetamo gito pokoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ebe tetelo tabote Unu Duliyomolone ma kunu piwisigiya, “Me naimano kapiya Gudunomola. Na ebetamo nekalakalitamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ebene Godokono Uliyanate Ya꞉suko bulu opamo nemagatiya, mabu ebe ubila Saitanatamo tete ebolo nikamete, ebete Ya꞉suko kuba gabamo kowabuga꞉tama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ebene Ya꞉sute bulu opolo 40 egelamo eba nokolilo, ebe tete geyageyanomolo bae kenanakia꞉, ebema꞉ ebete bae kape tanalo ebo iyatawiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ebene Saitanate ebetamo pemaigate ebe naniya, “A꞉ma꞉ Godokono nani Guduma꞉ deda꞉wena, me nokola baema꞉ na꞉midila꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ya꞉sute ebeno tabo eba wiyalo negiya, “Godokono Bukalo tabo ma kunu itana, ‘Lumagite me opono bae kapiyalo a꞉kigilonamene, wiyasiya ebete Godokono tabo bilibilinomo denaomene nanitabonomolo bigilonamene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ebene Saitanate Ya꞉suko Godokono wade-talena duliyomolo Yelusalemamo magatate Godoko Amamateno Iya Motono auba unamo nadipite ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ebe ebo naniya, “A꞉ma꞉ Godokono nani Guduma꞉ deda꞉wena, a꞉ma꞉ a꞉ka꞉tuwa꞉ opamo na꞉nepatega, mabu Godokono Bukalo tabo ma kunu itana, ‘Godote ebeno nopopi a꞉imano tanaloma꞉ kapalibolemene, iyo, iba꞉te ibino kotamo a꞉ma꞉ ka꞉pelaema꞉ta, ebema꞉ a꞉ma꞉le nokolalo agowa a꞉ka꞉nukamidaemene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Wiyasiya Ya꞉sute negiya, “Ao, nale ebe kuba tanalo a꞉kosiyodilomo, mabu Godokono Bukalo tabo idi ma kunu itana, ‘Opo lumagite Kawodawa Godoko wabudima꞉ akowagela꞉la꞉.’ Iyo, ebe mabuma꞉ me opo lumagite ebeno daedale wokiamo tanalo idi dosiyodilomene, ebete akomalagidilala꞉ Godote ebeno igilo gito ka꞉pa꞉mula꞉ema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ebene Saitanate Ya꞉suko damela ununomo ida꞉mo magatate me opo kawonomono iyaiya opo kawokawo eba niyatumiolo, iba꞉te ebe opo bilibilinomo ega꞉walo kawokawo inamabu ebo ulamoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Saitanate ebetamo negiya, “A꞉ma꞉ pupamo okoliawete na namamanatena꞉, ebene nale me tanalo bilibilinomo a꞉ma꞉tamo kikameomamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Wiyasiya Ya꞉sute ebetamo negiya, “Saitana, a꞉ma꞉ nagodone na꞉toa! Godokono Bukalo tabo idi ma kunu itana, ‘A꞉ma꞉ a꞉imano Kawodawa Godoko amamatelo ebe kapiyatamo na꞉tuduwatanakiye!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ebene Saitanate Ya꞉suko atepate, wiyasiya Godokono nopopiate pelamete ebe ebo pa꞉buiyatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ebene gabamaniate Yoneko idoko motamo diyatiya, Ya꞉sute ebe tanalo olowite ebete Ga꞉lili opamo gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ebete Nasalete duliyomolo atepate Kapeniyama duliyomololo nokolinami, Kapeniyama duliyomolo ebe Ga꞉lili Paka꞉ balalo itanami, me paka꞉ Sebulana ega꞉walo Na꞉patali me netewa gu epono opo niyakabolo itanami. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Me tanalote pemaigiya Godokono woki awokalimidawa Aisayate kebe tabo ka꞉kiyawaiyale ebe tabote nanitaboma꞉ keda꞉ma꞉, iyo, ebete iyalo tetelo ma kunu a꞉kiyawaiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulana opo epo ega꞉walo Na꞉patali opo epo, Ga꞉lili Paka꞉mo tolame gabo niyakabolo dilukuliawenama, la꞉ ebe epolata. Iyo, la꞉ Yodane Kolomo apu balalo da꞉pola꞉wenama ebe epolata, la꞉imano opono mailo ebe Yua꞉ epono Ga꞉lilila. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Piyate idoko magumulo dilukuliona, iba꞉te alo kawonomo kuima꞉na꞉, iyo, piyate a꞉e magumulo dilukuliona, wiyasiya igilo alote ibi ka꞉pukuilaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ebe tetelo Ya꞉sute Godokono tabo kiyawao eba wagilimilo negiya, “La꞉imano kubane olobila꞉wete woki iyakobi na꞉midila꞉la꞉, mabu Godokono Kawo Elawodawama꞉ eda꞉ tete tatalila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ebene Ya꞉sute Ga꞉lili Paka꞉ balado eba petolo dubu netewa ebo nulamiya, Saimonoko ebeno mailo idi Pitatela ega꞉walo ebeno ekawi A꞉nduluko, ibi netewapi namo uwatolepila, iba꞉te namo kamauamo na꞉utiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ebene Ya꞉sute iba꞉tamo negiya, “La꞉ na nowaloma꞉ena꞉la꞉, ebene nale la꞉ epo uwatepima꞉ ka꞉midilimamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ebe tetenomolo iba꞉te ibino kamau miyapate Ya꞉suko ebo waloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ebene Ya꞉sute kela꞉mo walo ka꞉tote Sebedikono gudu Ya꞉imesiko ega꞉walo ebeno ekawi Yoneko ebo ka꞉nulamiya, iba꞉te ibino nabiwa꞉go pelo ilukulite kamau osiyodilolitiya. Ebene Ya꞉sute ibi netewapi deka꞉la꞉miya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ebe tetenomolo iba꞉te ibino pe ega꞉walo ibino nabiwi miyapate Ya꞉suko ebo waloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ebene Ya꞉sute Ga꞉lili opo kawonomodo da꞉petonaki, ebe tetelo ebete Yu epono iyaiya balidi ibilamole motolo ibi eba iyatulamelo, Godote Kawo Elawodawama꞉ deda꞉na ebete ebe tanalono Wade Tabo iba꞉tamo ebo kiyawaonaki, ega꞉walo epo magumulo piyate iyaiya temetema꞉go dilukulionamiya ebete ibi bilibilinomo wadekobi atumu a꞉ka꞉midiolenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ebene ebe tetelo Siliya opo epo bilibilinomate atumu Ya꞉sukono tanalo kolowiote, iba꞉te ibino iyaiya temetema꞉gopi ebetamo ebo magaelenakiya. Ma kunu kubakuba uliyanagopi, ea꞉ temetema꞉gopi, ape kodakoda temetema꞉gopi, ega꞉walo iyaiya gabugabuagopi bilibilinomo epetapiate Ya꞉sutamo da꞉pelamenakiya, ebete ibi wadekobi ebo midiolenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nanitabola, ebe tetelo epo bilibilinomate Ya꞉sutamo iyaiya opone pelamoliya, iyo, iba꞉te Ga꞉lili opone, Teni Duliyomolono opone, Yelusalema kawo duliyomolone, Yudiya opone, ega꞉walo Yodane Kolomo apune iyaiya pelamolete Ya꞉suko ebo waloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ebene ebe epo bilibilinomate Ya꞉sutamo da꞉pelamiya, ebete ibi ulamete damela unamo nodolote gito nokoliya. Ebema꞉ ebe waloma꞉tapi dubate pelamete ebe da꞉pa꞉wa꞉midadigiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ebete ibi iyatulame ebo wagilimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ya꞉sute iba꞉tamo negiya, “Piyate ibi a꞉ka꞉tuwa꞉ ibi egegema꞉ gelalo Godoko ibino Kawodawama꞉ degelanaka, modobola iba꞉te nekalakalaonama꞉na꞉, mabu Godote Kawo Elawodawama꞉ deda꞉na, ebe wade duliyomolono tanalo ibinola! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Ega꞉walo piyate me tetelo temetema꞉go diimina, modobola iba꞉te nekalakalaonama꞉na꞉, mabu Godote iba꞉tamo gelebadi kikalaemene! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Ega꞉walo piyate amamaoa꞉pima꞉ deda꞉ona, modobola iba꞉te nekalakalaonama꞉na꞉, mabu Godote me opo kawonomo iba꞉tamo kikalaemene! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Ega꞉walo piyate tuputupu ilukuli tanaloma꞉ diyawaona, modobola iba꞉te nekalakalaonama꞉na꞉, mabu Godote ibino iyawa tanalo ka꞉modoboilaemene! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Ega꞉walo piyate nilakapo dawokalilamena, modobola iba꞉te nekalakalaonama꞉na꞉, mabu Godote iba꞉tamo ebeno nilakapo kawokalimene! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Ega꞉walo piyate ibino tepo magumu wadenomamo dukulalena, modobola iba꞉te nekalakalaonama꞉na꞉, mabu iba꞉te Godokono ololo kuima꞉na꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Ega꞉walo piyate dowaopiatamo milo dikalamena, modobola iba꞉te nekalakalaonama꞉na꞉, mabu Godote ibi ebeno gudima꞉ kegemene! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Ega꞉walo piyate tuputupu gabodo eba wapata꞉lamenalo ebe mabuma꞉ temeteme duwatenaka, modobola iba꞉te nekalakalaonama꞉na꞉, mabu Godote Kawo Elawodawama꞉ deda꞉na, ebe wade duliyomolono tanalo ibinola! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ega꞉walo epate na mabuma꞉ la꞉ malogolelo kawokawo temeteme eba ikalamelo la꞉ kubakubapima꞉ degelana, la꞉ atumu na꞉kekalakalala꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Iyo, la꞉ kawonomamo nekalakalala꞉, mabu walone tetelo la꞉le Godokono Unu Duliyomololo la꞉imano wiya kawokawonomo ka꞉nuwatemamota. Numa꞉la꞉, dopamo tetelo dilukulinamiya ebe kubakubapiate atumu Godokono woki awokalimipiatamo kawokawo temeteme eba kunu kikalamenamiya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ebene Ya꞉sute walo na꞉kegiya, “La꞉ me opono solu golalata, wiyasiya la꞉imano soluno golate dalatidimene, lumagi idite walo solukobi midima꞉ a꞉ka꞉modobomene. Ebe solu kubanomoma꞉ eda꞉, ebema꞉ epate iyabaiamo aminaolete agowamo ka꞉mikitaolema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ega꞉walo me tanalo idila, la꞉ me opo kawonomono alolata, mabu nanitabola, damela unulo ditana epate ebe duliyomolo wadenomamo buminama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Iyo, lumagite ebeno wuiki alo pite bagowo magumamo a꞉kiyatimene, wiyasiya ebete awokala baiamo kiyatimene, ebene ebe alote moto gulo dilukulina ebe epo bilibilinomo ka꞉pukuilaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ebema꞉ modobola la꞉imano alote ebe atu gabodo epo epetapi na꞉pukuilaemene, iba꞉te la꞉imano wadewade osiyodilole tanaloma꞉ la꞉imano Unu Duliyomolo Nabiwi kemoioma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ebene Ya꞉sute walo na꞉kegiya, “La꞉ wadenomamo nemalagidilala꞉, Godote Mosesedo epatamo dikalamiya ega꞉walo ebeno woki awokalimipiate ebeno Bukamo dakuloliya, nale ebe wadewade Totomu Tabo iyabaiamo alomoma꞉ ka꞉piya꞉. Ao, eba kunua꞉. Nale wiyasiya ebe iyaiya Totomu Tabono nanitabo tanalo awokalima꞉ piyamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na la꞉tamo nani tabo gemo. Me opo ega꞉walo tobolo unu ibino inamabuate tete geyageyanomolo eba pola꞉nalo Godokono Totomu Tabote atumu ba꞉ka꞉pola꞉nama꞉na꞉, ibi bilibilinomo magumulo tabo da꞉pesonomo idite akalatidimene. Iyo, Godote kebe tabo apuapu ebeno Bukamo dalomoliya, ebe tanalate epo biyatulamenakoma꞉na꞉ ebeno woko bilibilinomo opoliyale uwomuamo! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ebema꞉ Godokono Totomu Tabo bilibilinomo magumulo kebe lumagite tabo da꞉pesonomo idi ubia꞉noma꞉ eda꞉te, ebene ebete epetapi tudila꞉oa꞉ tanalo diyatulaemene, walone tetelo ebete Godokono Unu Duliyomololo da꞉pesonomoma꞉ ka꞉neda꞉mene. Wiyasiya kebe lumagite Godokono Totomu Tabo bilibilinomamo eba tuduwatalo epo epetapi atu tanalo osiyodilolema꞉ diyatulaemene, ebete Godokono Unu Duliyomololo kawoma꞉ ka꞉neda꞉mene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ebema꞉ nale la꞉ analemata, modobola la꞉le Godokono Totomu iyatulamepi ega꞉walo Pa꞉lisi tanebapi ibino tanalo nemalagidilala꞉. Epate ibi tuputupupima꞉ gelana, wiyasiya la꞉imano tuputupu ilukuli tanalote ibino ilukuli tanalo odolia꞉no la꞉ Godokono Unu Duliyomolamo a꞉ka꞉nopila꞉ema.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ebene Ya꞉sute walo na꞉kegiya, “Dopamo tetelo epate Godokono totomu tabo idi ma kunu diyatulamenakiya, la꞉ olowiyamata. ‘Lumagi akoanakapuma꞉la꞉. Potele lumagi idi danakapuimene, epono tabo anagilamelelamedawate ebetamo kuba wiya kikaemene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wiyasiya me tetelo nale tabo idi na꞉kegemo. Kebe lumagite ebeno ekawitamo da꞉dowamene, tanalo anagiyamidadawate ebetamo kuba wiya kikaemene, ega꞉walo kebe lumagite ebeno ekawi demalogomene, Ka꞉nisolo dubate ebetamo kuba wiya kikaema꞉na꞉, ega꞉walo kebe lumagite ebeno ekawi watoa꞉noma꞉ degemene, ebe kuba mabuma꞉ Godote ebe Ela Opamo kanalibomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ebema꞉ a꞉ma꞉ Godoko watidilonoma꞉ kalimagono inamabu patapatamo eba adaelo a꞉ma꞉ woki wadenomamo ma kunu da꞉nelawa꞉emene, ‘Eiye! Naimano ekawite natamo na꞉dowana!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","modobola ebe tetelo a꞉ma꞉ a꞉imano nilakapo inamabu ebamo natepapiye. A꞉ma꞉ dopamo toawete a꞉imano ekawi gelebadikobi na꞉mida꞉wete, ebene a꞉ma꞉ walo ka꞉pa꞉wete ebe nilakapo inamabu Godotamo ebo na꞉pikamiye. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“A꞉ma꞉tamo da꞉dowana ebe lumagite a꞉ma꞉ gabamani dubu kawotamo demagatatamene, la꞉ ebetamo nemaimia꞉no modobola a꞉ma꞉ dopamo eba꞉go na꞉negelebadiyala꞉. A꞉ma꞉ ebe gelebadikobi midia꞉no, nanitabola, ebete a꞉ma꞉ kawo dubuno kotamo ka꞉niyatima꞉ta, ebene kawo dubute a꞉imano kuba anagiyamidametate a꞉ma꞉ polisi dubutamo eba nalibolo, a꞉ma꞉ idoko motamo ebo ka꞉toma꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na a꞉ma꞉tamo nani tabo gemo, a꞉ma꞉ idoko moto gulo eba nokolilo, gabamani dubute kebako tete okolima꞉ a꞉ma꞉ danatamene, a꞉ma꞉le ebako kuba wiya modobutinomo modobuta꞉wete duliyomolamo walo ka꞉ka꞉pema꞉ta, wiyasiya a꞉ma꞉le ebe wiya modobutia꞉no a꞉ka꞉pemaigaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ebene Ya꞉sute walo na꞉kegiya, “Epate Godokono totomu tabo idi ma kunu diyatulamenakiya, la꞉ olowiyamata. ‘Lumagi idino kamiyale pilolo akolawa꞉la꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Wiyasiya me tetelo nale tabo idi na꞉kegemo. Kebe dubute kamiyale idi umite ubi ebetamo diyatimene, Godokono umi magumulo ebete ebeno tepo magumulo ebe kuba iyalo osiyodilo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ebema꞉ a꞉imano tumudi apu balidite a꞉ma꞉ kuba gabamo dowabuga꞉tatana, a꞉ma꞉ magoba꞉wete iyabaiamo neba꞉idila! Modobola a꞉imano balidite me tetelo alatidi, wiyasiya walone tetelo Godote a꞉imano ape kawonomo Ela Opamo ba꞉idilo modoboa꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ega꞉walo a꞉imano tumudi apu kotote a꞉ma꞉ kuba gabamo dowabuga꞉tatana, a꞉ma꞉ itamidawete iyabaiamo neba꞉idila. Modobola a꞉imano kotote me tetelo alatidi, modoboa꞉ walone tetelo a꞉ma꞉le ape kawonomago Ela Opamo toma꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ebene Ya꞉sute walo na꞉kegiya, “Ega꞉walo epate Godokono totomu tabo idi ma kunu iyatulamenakiya, ‘Kebe dubute ebeno ubia꞉ tetelo kamiyale dalibutimene, kuba꞉. Ebete ebe alibuti tabo pepamo akulolete ebetamo ikamelo ebo kanalibomene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wiyasiya me tetelo nale tabo idi na꞉kegemo. Dubu idino kamiyalete dubu ida꞉go kuba osiyodiloa꞉no, ebene ebeno awite ebe ubia꞉noma꞉ eda꞉te gito dalibutimene, ebe dubute kawo kuba kosiyodilomene, ebene ebete Godogodone kuba wiya nanitabolo kelaemene. Mabu ebeno kuba osiyodilo tanalodo ebeno kamiyalete eba tolo dubu idi da꞉nelaemene, Godokono umi magumulo ibi netewapino osiyodilo tanalote pilo tanaloma꞉ keda꞉mene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ebene Ya꞉sute walo na꞉kegiya, “Dopamo tetelo epate Godokono totomu tabo idi ma kunu diyatulamenakiya, la꞉ olowiyamata. ‘A꞉ma꞉le Godokono mailamo kebe tabo da꞉kiyawaemene ebe tabo bilibilinomo nanitabonomolo nosiyodiloliye.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Wiyasiya me tetelo nale tabo idi na꞉kegemo. A꞉ma꞉le epetapiatamo nani tabonomo gema꞉ dowagela꞉emene, iba꞉te a꞉imano tabo nanitabokobi ka꞉midima꞉ a꞉ma꞉le Godokono Unu Duliyomolono mailo akoka꞉miala꞉, mabu ebe Duliyomolo talenama꞉ eda꞉na, ebe Godokono okoli baila. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ega꞉walo me opono mailo akoka꞉miala꞉, mabu me opo atumu talenama꞉ eda꞉na, ebe Godokono agowa puti baila. Ega꞉walo atumu Yelusalema kawo duliyomolono mailo akoka꞉miala꞉, mabu ebe aimano Kawo Elawodawa Godokono duliyomolola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ega꞉walo a꞉imano tabo olowidawate a꞉imano tabo nanitabokobi ka꞉midima꞉, a꞉ma꞉le a꞉imano mailo akoka꞉miala꞉ mabu a꞉ma꞉ kawodawa꞉, iyo, a꞉ma꞉godolo elawo kitana꞉ a꞉imano kapiya kilikili eke keyakeyama꞉ midima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ebema꞉ modobola a꞉ma꞉ wiyasiya a꞉imano tabo kiyawao magumulo inamabu idino mailo ka꞉mia꞉no tabo nanitabolo ma kunu negiye, ‘Iyo, na kosiyodilomamo,’ ega꞉walo kebe tetelo a꞉ma꞉ tanalo idi osiyodilo modoboa꞉noma꞉ deda꞉emene, modobola a꞉ma꞉ nani tabo idi ma kunu negiye, ‘Ao, na a꞉kosiyodilomo.’ Eiye! Epetapiate a꞉imano tabo nanitabokobi ka꞉midima꞉ a꞉ma꞉le a꞉imano tabo elawokobi ka꞉mida꞉ema꞉ tabo idi akogeala꞉, mabu ebako tabo kiyawao tanalote Saitanagodone ka꞉pemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ebene Ya꞉sute walo na꞉kegiya, “Epate Godokono totomu tabo idi ma kunu diyatulamenakiya, la꞉ olowiyamata. ‘Lumagi idite a꞉imano balidi da꞉kubaimene, a꞉ma꞉ wiyasiya ebeno balidi ka꞉kubaimima꞉ta. Ega꞉walo lumagi idite a꞉imano lalo dowakeamidalemene a꞉ma꞉ atumu ebeno lalo kowakeamidalema꞉ta.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Wiyasiya me tetelo nale tabo idi na꞉kegemo. Potele a꞉ma꞉tamo kuba dosiyodilonako ebe ako-odiyobala꞉, ma kunu ebete a꞉ma꞉ tumudi apu tatakolo danagalimitamene, modobola a꞉ma꞉ pele apu ebetamo na꞉kikamiye. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ega꞉walo kebe lumagite a꞉imano lubudino inamabu laema꞉ ubi iyatilo a꞉ma꞉ tanalo anagiyamida baiamo magatama꞉ degemene, modobola ebetamo gito nikamiye ega꞉walo ebe atu tetelo a꞉imano sete inamabu akoamoeda꞉la꞉, a꞉ma꞉le ebetamo nilakapolo gito na꞉kikamiye. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ega꞉walo gabamani dubu idite ebeno inamabu kapiya kilomita tatalidopamo aguwataema꞉ a꞉ma꞉ danatamene, modobola a꞉ma꞉ kalakalago ebeno inamabu netewa kilomita muludopamo aguwawete eba꞉go gito na꞉tiye. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ega꞉walo kebe lumagite a꞉imano inamabu idima꞉ a꞉ma꞉ da꞉toweometamene, modobola a꞉ma꞉ ebetamo nilakapolo nikamiye. Iyo, idite tete idilo a꞉ma꞉godone inamabu lawete walo a꞉ma꞉tamo ikaema꞉ da꞉kegemene, modobola a꞉ma꞉le ebe gito nowalubiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ebene Ya꞉sute walo na꞉kegiya, “Epate ma kunu diyatulamenakiya, la꞉ olowiyamata. ‘A꞉ma꞉ a꞉imano namutudawa nilakapolo nemalagidilona, wiyasiya potele a꞉ma꞉go da꞉gowelaona a꞉ma꞉le ebako lumagitamo dowama꞉ kuba꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Wiyasiya me tetelo nale tabo idi na꞉kegemo. La꞉go da꞉gowelaona, modobola la꞉ ibi nilakapolo nemalagidilolenala꞉, ega꞉walo la꞉tamo temeteme dikalametana ibi Godotamo nowadipalatelenakiyala꞉ ebete ibi wadenomamo kowalubilinama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mako osiyodilo tanalodo la꞉ Unu Duliyomolo Nabiwino gudima꞉ beda꞉onamata, mabu ebete ebeno egelano alo ega꞉walo ebeno ulama kuba epo ega꞉walo tuputupu epo iba꞉tamo kapimiya pikalamenako. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Piyate la꞉ nilakapolo demalagidiloletana, la꞉ ebe epo kapiya demalagidilola꞉wenama la꞉imano woki keba kunula꞉ka꞉? Ebe mabuma꞉ Godote la꞉tamo wade wiya ba꞉kikalametamene? Ao, mabu mani pilolo uwatepiate atumu ibino namutupi kapiya malagidilolenaka! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ega꞉walo la꞉ la꞉imano epo kapiyatamo wadewade tanalo dosiyodilola꞉wenama la꞉imano woki keba kunula꞉ka꞉? La꞉ ebe wadewade osiyodilole magumudo epo epetapi ba꞉kodoila꞉ema? Ao, mabu nanitabokobi midia꞉piate atumu ibino epo kapiyatamo wadewade tanalo osiyodilolenaka! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ebema꞉ la꞉imano osiyodilole magumulo wadenomamo nilukuliniyala꞉, la꞉imano Unu Duliyomolono Nabiwi keba kunula꞉ka꞉ eba kunu, mabu ebegodolo kapiya kuba idi kitana꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ebene Ya꞉sute walo na꞉kegiya, “La꞉ nanisiwale, wadewade tanalo osiyodilole tetelo epetapiate la꞉imano wade tanalo uima꞉ ibino ololo apulo ako-osiyodilola꞉la꞉. La꞉ eba kunu dowagela꞉ema la꞉imano Unu Duliyomolono Nabiwite la꞉tamo wade wiya a꞉kikalametamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ebema꞉ nilakapo inamabu nigologolopiatamo ikalame tetelo epetapiate la꞉imano wade osiyodilo tanalo uima꞉ awokala ako-osiyodilala꞉. Numa꞉la꞉, mena netewa epate balidi ibilamole motolo ega꞉walo epono ololo apulo ibino nilakapo inamabu diyamo kawonomago ikalamenaka epetapiate ibi kemoiolema꞉. Ebema꞉ na la꞉tamo nani tabo gemo, iba꞉te epono moiole tanalo magumulo ibino kawo wiya iyalo elawa꞉, Godogodone walo a꞉kuwatema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wiyasiya la꞉imano nilakapo inamabu ikalame tetelo modobola la꞉le diya gabodo nosiyodiliyala꞉, ma kunu la꞉imano wade namutudawa idite akoiyatawala꞉, Godoko kapiyate niyatawamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Iyo, la꞉ nilakapo inamabu diya gabodo nikalamenakiyala꞉, ebene la꞉imano Nabiwi Godote la꞉imano diya osiyodilo tanalo umite ebete a꞉ka꞉tuwa꞉ la꞉tamo wade wiya bikalamenakoma꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ebene Ya꞉sute walo na꞉kegiya, “La꞉le Godago tabo gela tetelo mena netewa epoma꞉ akoeda꞉oala꞉. Iba꞉te balidi ibilamole motolo ega꞉walo epono ololo apulo utitatate tabo madodo unamo wadipalatelelo Godotamo ebo gelanaka, mabu ibi ubila epate ibino gela tanalo kolowilatelema꞉. Ebema꞉ na la꞉tamo nani tabo gemo, iba꞉te epono moiole tanalo magumulo ibino kawo wiya iyalo elawa꞉, Godogodone walo a꞉kuwatema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Wiyasiya a꞉ma꞉le Godago tabo degelaema, modobola a꞉ma꞉ motamo nodolawete gigiyu na꞉pemopiye. Ebene a꞉ma꞉le a꞉imano Nabiwa꞉go diya gabodo tabo eba gelalo, a꞉ma꞉le ebe a꞉kuma꞉emene, wiyasiya ebete a꞉imano diya osiyodilo tanalo umite a꞉ma꞉tamo wade wiya ebo kikaema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ebema꞉ a꞉ma꞉le Godago tabo gela tetelo, a꞉ma꞉ Godoko iyatawa꞉ lumagima꞉ akoeda꞉la꞉. Numa꞉la꞉, ebako lumagite Godoko toweome tetelo ma kunu malagidilonako, ‘Nale atu towetowe tabo bilibili teta꞉mo degenakomo, ebema꞉ Godote naimano tabo nanitabonomolo kolowimene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wiyasiya la꞉ ebako lumagima꞉ akoeda꞉oala꞉, mabu la꞉le la꞉imano iyaiya modoboa꞉ tanalo Godoko ana꞉no ebete iyalo iyatawanako. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ebema꞉ la꞉ Godotamo towetowe tabo ma kunu negelanakiyala꞉, ‘Aimano Unu Duliyomolono Nabiwi, modobola a꞉imano talena mailo epate nadipatema꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ega꞉walo modobola a꞉ma꞉le Kawo Elawodawama꞉ deda꞉wena ebe tanalote nawokalamene. Nanitabola, a꞉ma꞉le a꞉imano ubi tanalo keba kunu kalomawena Unu Duliyomololo eba kunu bosiyodilolenakoma꞉ta, ebema꞉ modobola a꞉ma꞉ me opolo a꞉imano ubi tanalo atumu na꞉kosiyodilolenakiye. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","‘Ega꞉walo modobola a꞉ma꞉ me kapiya egelano bae atamo modobolo nikaeama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ega꞉walo epetapiate atamo kuba dosiyodilolena, ale ebe kuba egebolelamete ka꞉dodolomatililaemalema꞉, ebema꞉ modobola a꞉ma꞉ atumu aimano kuba egeboleama꞉wete na꞉dodolomatiliama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","‘Ega꞉walo Saitanakono kuba gabamo wabuga꞉ta magumulo a꞉ma꞉le wiyasiya a eba walubilo a꞉imano wade gabodo nemagataenakiye, iyo, ebeno kuba osiyodilo magumune aimano igilo na꞉mula꞉leama꞉, mabu a꞉imano Kawo Elawodawa tanalo, ega꞉walo elawo kawonomo, ega꞉walo amama tanalo uwomua꞉ uwomua꞉ tetelo a꞉ma꞉godolo ba꞉pola꞉nama꞉na꞉. Taula.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ya꞉sute tabo moga꞉melo walo na꞉kegiya, “Epetapiate kuba la꞉tamo dosiyodiloliya, la꞉le ibino kuba da꞉dodolomatililama꞉ema la꞉imano Unu Duliyomolono Nabiwite atumu la꞉imano kuba egebolelametate ka꞉dodolomatililaema꞉ta, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","wiyasiya la꞉le epetapino kuba dodolomatililamea꞉no, la꞉imano Unu Duliyomolono Nabiwite atumu la꞉imano kuba egebolelametate a꞉ka꞉dodolomatililametamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ebene Ya꞉sute walo na꞉kegiya, “La꞉le Godokono woko osiyodiloma꞉ bae naoa꞉no da꞉pola꞉wenama, mena netewa epoma꞉ akoeda꞉oala꞉. Iba꞉te bae naoa꞉no pola꞉na tetelo ibino dopo mibomiboma꞉ eda꞉olamenaka, mabu ibi ubila epate ibino bae naoa꞉ tanalo kumilaema꞉. Ebema꞉ na la꞉tamo nani tabo gemo, iba꞉te epono moiole tanalo magumulo ibino kawo wiya iyalo elawa꞉, Godogodone walo a꞉kuwatema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wiyasiya a꞉imano bae naoa꞉no okoli tetelo modobola a꞉ma꞉ ebe tanalo diya gabodo nosiyodilonakiye. Ebema꞉ a꞉ma꞉ bae kapete umia꞉no, a꞉ma꞉le kalakalago dokoliawena a꞉ma꞉ eba kunu nokolitiye, a꞉ma꞉le a꞉imano eke wadipalatela꞉wete a꞉imano ololo wadenomamo kukulama꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ebene epate a꞉kiyatawaoma꞉na꞉ a꞉ma꞉le bae naoa꞉no dokoliawita, Nabiwi Godoko kapiyate kiyatawamene. A꞉ma꞉le ebe a꞉kuma꞉emene, wiyasiya ebete a꞉imano diya osiyodilo tanalo umite a꞉ma꞉tamo wade wiya ebo kikaema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ebene Ya꞉sute walo na꞉kegiya, “La꞉ me opolo inamabu dogodogokobi akomidilinala꞉, mabu me opolo wadewade kaliku nopaiate a꞉kubailamenaka ega꞉walo auli inamabu nabote atumu a꞉ka꞉kubailamenaka. Iyo, nanitabola, pilo epate moto guamo podolote la꞉imano inamabu epetapi gito ka꞉pa꞉kubailaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ebema꞉ modobola la꞉ Godokono Unu Duliyomololo la꞉imano inamabu dogodogokobi na꞉midilinala꞉, mabu ebolo nopaiate inamabu kenaona꞉, ega꞉walo nabote inamabu ka꞉kubailamena꞉, ega꞉walo pilo epate moto guamo odolote la꞉imano inamabu a꞉kuwatema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","La꞉ nanisiwale! La꞉imano inamabuate kebolo da꞉pola꞉nama꞉na꞉ la꞉imano tepo magumuno woki atumu ebolo ka꞉na꞉pola꞉nama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ebene Ya꞉sute walo na꞉kegiya, “Lumagino apeno alo ebe ebeno balidila. Ebema꞉ a꞉imano balidite wadenomamo da꞉pukuilaemene a꞉imano tepo magumuno alote atumu wadenomamo ka꞉ka꞉pukuilaemene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","wiyasiya balidite wadenomamo pukuilamea꞉no a꞉imano apete idoko magumulo kitanamene. Ebema꞉ a꞉ma꞉ nanisiwale, a꞉imano tepo magumuno alote didokomene, ebe idoko tanalo beda꞉ kawonomola꞉ka꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ega꞉walo me tanalo idila, lumagite netewa elawodubatamo wokodawama꞉ eda꞉ma꞉ modoboa꞉. Ebete eba kunu dowagelemene iditamo eba dowanalo idi nilakapolo bemalagidilonamene, ega꞉walo ebe iditamo eba utinalo idi ubia꞉noma꞉ beda꞉namene. Ebema꞉ a꞉ma꞉ atumu, Godotamo ega꞉walo manitamo kapiya tetelo tuduwatama꞉ modoboa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ebene Ya꞉sute walo na꞉kegiya, “Nale la꞉ analemata, la꞉imano ilukulio tanaloma꞉ woki bilibilima꞉ akoeda꞉onala꞉, iyo, la꞉le nao inamabu, nio inamabu, ega꞉walo pupuliono inamabu uwatema꞉ kawonomamo akomalagidilola꞉la꞉, mabu nao inamabu ega꞉walo pupuliono inamabu iba꞉te kawokawoma꞉ keda꞉ona꞉. Nao inamabute lumagitamo nanitabo igilo ba꞉kikaemene? Ao, a꞉kikaemene, ega꞉walo pupuliono inamabute atumu ebeno ape uwomua꞉ tetelo a꞉kowalubinamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ebema꞉ la꞉ olaolano tanalo nemalagidilala꞉, iba꞉te pali inamabu kamiona꞉ ega꞉walo iba꞉te pelamete naono pali inamabu ka꞉petapionakoa꞉, iyo, ibino pali inamabu alomono moto puliyala, wiyasiya la꞉imano Unu Duliyomolono Nabiwite iba꞉tamo bae modobolo ikalamenako. Numa꞉la꞉, Godokono nilakapo nanitabolo bitana olaolatamo, wiyasiya la꞉tamo keba kunu kitanale? Nanitabola, ebeno nilakapo la꞉tamo kawonomoma꞉ eda꞉te uwomua꞉ uwomua꞉ tetelo bitanamene! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ebema꞉ la꞉ woki bilibilima꞉ akoeda꞉oala꞉. Lumagite ebe a꞉ka꞉tuwa꞉ ebeno a꞉e tete egela ida꞉mo keba kunu na꞉kiyatimene, ega꞉walo ebete ebeno igilo keba kunu na꞉kegeyageyaima꞉tepamene? Gabo puliyala, kitana꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ebema꞉ mabu keleka꞉ la꞉ pupuliono inamabuma꞉ woki bilibilima꞉ deda꞉wenama? La꞉ me opono kaiyakaiyano tanalo nemalagidilala꞉, iba꞉te woko kosiyodilona꞉ ega꞉walo pupuliono inamabu kosiyodilolena꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nale la꞉ analemata, Kawo Elawodubu Solomonote inamabu dogodogodawanomoma꞉ eda꞉nami, wiyasiya ebete wadewade tita꞉gono inamabu da꞉pupulinaki, ebe kalikuno titi me opono kaiyakaiyano titite nodoilina. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Numa꞉la꞉, me opono uwagate ka꞉lo napepeuta, dumutu epate elamo kiyalekema꞉na꞉, wiyasiya Godote ebe nonoka inamabu tita꞉gonoma꞉ midilina, ebema꞉ ebete atumu la꞉tamo pupuliono inamabu modobolo bikalamenakoma꞉ta. La꞉ me tanalo wadenomamo iyatawaoa꞉no la꞉imano nanitabokobi midi tanalo Godotamo kawokawoa꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ebema꞉ la꞉le woki bilibilima꞉ eda꞉olo ma kunu akogelanakala꞉, ‘A beda꞉ na꞉kenaoma꞉, ega꞉walo a beda꞉ na꞉ka꞉nioma꞉, ega꞉walo a beda꞉ na꞉ka꞉pupulioma꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nanitabokobi midia꞉piate me inamabu woki bilibila꞉go olena, la꞉ wiyasiya eba kunu akowagelenala꞉, mabu ebe inamabu la꞉godolo modobolo pola꞉na꞉no la꞉imano Unu Duliyomolono Nabiwite iyalo iyatawanako. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ebema꞉ la꞉ la꞉imano Kawo Elawodawa Godotamo tudila꞉olo ebeno tuputupu okoli tanalo dopamo nowadiala꞉, ebene la꞉imano modoboa꞉ tetelo ebete la꞉imano iyaiya tanalo ulamelelametate la꞉tamo modobolo bikalamolenakoma꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ebema꞉ la꞉ dumutu egelano tanaloma꞉ woki bilibilima꞉ akoeda꞉oala꞉, mabu ebe egelano tanalote a꞉ka꞉tuwa꞉ kapawokalamene. Ka꞉lo egelalo da꞉pola꞉na ebe iyaiya tanalo nemalagidilola꞉, wiyasiya egela idino kuba tanalate pemaimia꞉no dopamo tole tanalote la꞉tamo akopa꞉la꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ebene Ya꞉sute walo na꞉kegiya, “Epo epetapino kuba osiyodilole tanaloma꞉ la꞉le ibi kubakubapima꞉ samamo akoka꞉la꞉miala꞉, ebene Godote la꞉ kubakubapima꞉ a꞉keka꞉la꞉mitamene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","mabu la꞉le epono tanalo keba kunu kanagilamelelama꞉ema, Godote la꞉imano tanalo eba kunu kanagilamelelaema꞉ta, ega꞉walo la꞉ epetapiatamo keba kunu kosiyodilola꞉wenakoma, eba kunu Godote la꞉tamo atumu ba꞉kosiyodilolenakomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Keleka꞉ mabu a꞉ma꞉le ekawino balidilo nonoka da꞉peso umilo wiyasiya a꞉imano balidilo ditana ebe kawo kewa tete kuma꞉wena꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ega꞉walo beda꞉ mabuma꞉ a꞉imano ekawitamo ma kunu degeawita, ‘Modobola a꞉imano balidilo ditana ebe nonoka da꞉peso nale kelaemamota,’ wiyasiya a꞉imano balidilo ditana ebe kawo kewa tete a꞉ma꞉ kelawa꞉wena꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Eiye! A꞉ma꞉ mena netewa lumagilata! Modobola a꞉ma꞉ dopamo a꞉imano balidilo ditana ebe kewa lawa꞉wete, a꞉ma꞉le walone wadenomamo mela꞉wete a꞉imano ekawino balidilo ditana ebe nonoka da꞉peso ebo kelaema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ega꞉walo me tanalo idila, la꞉le Godokono talena inamabu gaagaatamo akoikalama꞉la꞉. La꞉ eba kunu dowagela꞉ema, diyala, iba꞉te la꞉tamo olobila꞉te la꞉ kubanomamo da꞉baloletamene, ega꞉walo la꞉imano wadewade mani goeogoeatamo akoikalama꞉la꞉, iba꞉te ebe inamabu agowamo mikitaolete gito da꞉ba꞉miyapama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ebene Ya꞉sute walo na꞉kegiya, “La꞉ Godoko na꞉toweoma꞉la꞉, ebete la꞉tamo kikalaema꞉ta. Iyo, la꞉ ebeno wade tanalo nowadiala꞉, la꞉le kuimamota, ega꞉walo gigiyu nanakamiala꞉, ebete la꞉tamo ka꞉iyamidamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Numa꞉la꞉, piyate Godoko da꞉toweomenaka iba꞉te ebegodone kelaema꞉na꞉, ega꞉walo piyate ebeno wade tanalo dowadinaka iba꞉te kuima꞉na꞉, ega꞉walo piyate gigiyu danakaminaka ebete iba꞉tamo ka꞉iyamidamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","La꞉ magumulo kebe dubu ebeno gudute ebe baema꞉ da꞉toweoemene, wiyasiya ebetamo nokola ba꞉kikaemene? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ega꞉walo a꞉imano gudute a꞉ma꞉ namoma꞉ da꞉toweometamene, a꞉ma꞉ wiyasiya ebetamo bu kalu ba꞉kikama꞉emene? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Numa꞉la꞉, la꞉ wadewade epoa꞉ wiyasiya la꞉ iyatawalata la꞉imano guda꞉tamo wadewade bae ikalaema꞉, ebema꞉ la꞉imano Unu Duliyomolono Nabiwi atumu iyatawanomola wadewade tanalo epatamo ikalaema꞉, piyate ebe da꞉toweomenaka iba꞉tamo kikalaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ebema꞉ epate la꞉tamo beda꞉ tanalo osiyodiloma꞉ la꞉le ubi diyata꞉wenakoma, la꞉ epetapiatamo eba kunu nosiyodilonakiyala꞉, mabu Godote ebeno Totomu Tabo Mosesedo epatamo dikalamiya ega꞉walo ebeno woki awokalimipiate ebeno Bukamo dakuloliya, ebe kawokawo tabono magumu kapiya ebe ma kunula, la꞉ epetapiatamo nilakapo tanalo nawokaliminakiyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ebene Ya꞉sute walo na꞉kegiya, “La꞉ ta꞉kumi gigiyudo nopila꞉la꞉ mabu Ela Opamo da꞉nopila꞉onaka ebe gigiyu kawonomola, gabo kodakoda꞉. Epo bilibilinomate ebana nopila꞉ote ebe gabodo tolamena. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wiyasiya Godokono Igilo Duliyomolamo da꞉nopila꞉onaka ebe gigiyu ta꞉kuminomola, gabo kodakodala. Kapiyakapiya epate ebe gigiyu numite ebana tolamena.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ebene Ya꞉sute walo na꞉kegiya, “La꞉le Godokono mailamo a꞉da꞉ tabo kiyawaopi wadenomamo nulama꞉la꞉. Iba꞉te alagiole sipi-goeogoeono tama pupulite la꞉tamo ebo pelamenaka, wiyasiya ibino tepo magumulo ibi elawoelawo gaagaa keba kunula꞉ka꞉ eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","La꞉ ibino osiyodilole tanalo wadenomamo nulamelelamiyala꞉. Lumagite wadewade gala꞉ipi da꞉imi moeagono kewalo a꞉ka꞉nulaemene, ega꞉walo ebete moeagono kewamo tote umei kewano da꞉imi a꞉ka꞉netapiomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Numa꞉la꞉, wadewade kewalo wadewade da꞉ima꞉te ka꞉noloma꞉na꞉, ega꞉walo kuba kewalo kubakuba da꞉ima꞉te ka꞉noloma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Iyo, wade kewalo kubakuba da꞉ima꞉te a꞉ka꞉noloma꞉na꞉, ega꞉walo kuba kewalo wadewade da꞉ima꞉te a꞉ka꞉noloma꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ebema꞉ nanitabola, wadewade da꞉imi noloa꞉ kewa epate lute elamo kiyalekema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ebema꞉ la꞉ a꞉da꞉ tabo kiyawaopino osiyodilole tanalo eba ulamelo la꞉le ibino nolo tanalamo ibino nanitabo tanalo ebo kiyatawaomamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Numa꞉la꞉, piyate na Kawodawama꞉ gito deka꞉na꞉minaka wiyasiya nanitabo tanalo puliyala, ebe epate Godokono Unu Duliyomolamo a꞉ka꞉nopila꞉oma꞉na꞉. Wiyasiya piyate naimano Nabiwino ubi tanalamo da꞉tudila꞉ona, ibi kapiyate ebeno Unu Duliyomolamo ka꞉nopila꞉oma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ebema꞉ Godokono Kawo Egelalo epetapiate natamo ma kunu kegelama꞉na꞉, ‘Kawodawa, Kawodawa! Ale a꞉imano mailamo Godokono tabo a꞉kiyawaonakima꞉, ega꞉walo a꞉imano mailamo kuba uliyana alibolenakima꞉, ega꞉walo atumu ale anoano tanalo epetapi osiyodilolenakima꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wiyasiya nale iba꞉tamo kegemamo, ‘Na iyatawa꞉ la꞉imano tanalo. La꞉ kuba osiyodilolepilata, nagodone na꞉tolama꞉la꞉!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ebene Ya꞉sute walo na꞉kegiya, “Kebe lumagite naimano tabo olowiote ebe iyaiya tanalo dosiyodilolemene, ebe wade mulo woki lumagila. Ebete ebeno moto kodakoda damela unamo detiya, ebe dubu keba kunula꞉ka꞉ eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ebe tetelo ulamate dowiya obote ebo odoliya, ebene kawo awanomote pete moto dapadimagotiya motote kekagiya꞉ mabu ebete wade damelamo etiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wiyasiya kebe lumagite naimano tabo olowiote osiyodilolea꞉no, ebe daedale woki lumagila. Ebete ebeno moto wiyo damelamo detiya ebe dubu keba kunula꞉ka꞉ eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ebe tetelo ulamate dowiya obote ebo odoliya, ebene kawo awanomote pete moto dapadimagotiya motote kagate kubanomoma꞉ ebo ediya. O olalati beda꞉ kawonomola꞉ka꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ebene Ya꞉sute me iyaiya tanalo kiyawao dolopoligiya ebeno tabo olowiopi bilibilinomate nanoanoutiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","mabu ebete Godokono elawamo iyatulamiti, wiyasiya ebe ibino Godokono Totomu iyatulamepi keba kunula꞉ka꞉ eba kunua꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ebe tetelo Ya꞉sute damela unune da꞉piwisigiya epo epetapi bilibilinomate ebe a꞉wa꞉midalo ebo tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ebene kukulakukulago dubute ebetamo pete ebeno pupamo pokolite na꞉pegiya, “Kawodawa, a꞉imano ubi ditametana, a꞉ma꞉le na wadekobi ka꞉midinima꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ya꞉sute ebeno koto uwamidate ebe eba ologilo ebetamo negiya, “Na ubila, a꞉ma꞉ wadekobi nolowia!” ebema꞉ ebe tetenomolo kukulakukula temetemete ebegodone dolopoligiya ebete wadekobi ebo olowiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ebene Ya꞉sute ebetamo tabo idi ma kunu kegiya, “A꞉ma꞉ naimano tanaloma꞉ epo akonanala꞉la꞉. Modobola a꞉ma꞉ wiyasiya me tetenomolo toawete a꞉imano ape Godotamo kalimagono ikameodawatamo nanawokalimiye, ebene kalimagono nilakapo inamabu Godotamo akona꞉nikamiye, Mosesete da꞉kiyawaiya eba kunu. Ebe tanalote epo kiyatulaemene a꞉imano temetemete olopoligi.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ebene Ya꞉sute Kapeniyama duliyomolamo da꞉tiya Loma epono gowelaodawa elawodubu idite ebetamo pete ebe petoweomelo napaniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Kawodawa, naimano wokodawa motolo kawo gabugabuago watita, ebe ape kodakoda temetemete umita.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ebene Ya꞉sute ebetamo negiya, “Modobola, na pete ebe wadekobi ka꞉pa꞉midimamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Gowelaodawa elawodubute tabo eba wiyalo negiya, “Ao, Kawodawa, eba kunua꞉. Na wade lumagia꞉ a꞉ma꞉le naimano motamo podoloma꞉. Wiyasiya na niyatawitamo, a꞉ma꞉le motamo pea꞉no tabo gito degeaemene, naimano wokodawate nanitabonomolo wadekobi kolowimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mabu na atumu gowelaopino kawokawo elawodubuno opodawama꞉ eba eda꞉nalo ibino tabamo a꞉tuduwatanakomo, ega꞉walo atu tetelo naimano gowelaopiate naimano umi magumulo pola꞉na. Ibi magumulo nale idi danamo, ‘A꞉ma꞉ na꞉toa!’ ebete ebo ka꞉tomene. Ega꞉walo idi dakanamo, ‘A꞉ma꞉ na꞉pa꞉!’ ebete ebo ka꞉pemene. Atumu nale naimano wiya꞉ wokodawa danamo, ‘A꞉ma꞉ me tanalo nosiyodila!’ ebete ebe tanalo kosiyodilomene. Ebema꞉ Kawodawa, modobola a꞉ma꞉ tabote negea naimano wokodawate wadekobi kolowima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ya꞉sute ebe tabo dolowiya ebete nela꞉wiya, ebema꞉ ebe dowaloma꞉titiya ebe epatamo negiya, “Na la꞉tamo nanitabonomolo gemo, na Isalaela epo bilibilinomo magumulo mako lumagino nanitabokobi midi tanalo kuminakoa꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nale la꞉ analemata, epo bilibilinomate me opo kawonomono apune apune pelamolete, iba꞉te A꞉ibalayamako, Aisa꞉keko, ega꞉walo Ya꞉ikoboko iba꞉go kapimiya Kawo Elawodawa Godokono soliyomu bailo ka꞉pa꞉pola꞉nama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wiyasiya la꞉ Yu epo epetapi Godote la꞉ idoko magumamo ka꞉piyalekema꞉ta, ebe idoko magumulo la꞉ lalo eba oliomolelo kawonomamo kiimimamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ebene Ya꞉sute gowelaodawa elawodubutamo negiya, “Mabu a꞉ma꞉le na nanitabokobi a꞉midina꞉ta, ebema꞉ a꞉ma꞉ toawete a꞉imano wokodawa na꞉numiye, ebete wadekobi olowi.” Nanitabola, ebe tetenomolo Ya꞉sute ebe tabo eba gitalo wokodawate wadekobi ebo olowiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ebe tetelo Ya꞉sute Pitakono moto guamo nodolote ebeno moto lapino ebo numiya, ebete ape enaena gabugabuago watiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ebene Ya꞉sute ebe kamiyaleno koto dologimiya, gabugabute ebegodone eba olopoligolo ebete maigate Ya꞉suko mabuma꞉ bae okalimi woko ebo wagilimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Eba adimonalo duliyomolo epate kubakuba uliyanagopi bilibilinomo Ya꞉sutamo ebo magaeleniya, ebene ebete tabo kiyawao kapiyamo kubakuba uliyana iba꞉godone eba alibolenalo temetema꞉gopi epetapi bilibilinomo atumu wadekobi ebo ka꞉midioleni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nanitabola, Ya꞉sute makomako wadewade tanalo epatamo osiyodilolenaki, Godokono woki awokalimidawa Aisayate degiya ebe tabote nanitaboma꞉ keda꞉ma꞉, iyo, ebe dawate iyalo tetelo tabo ma kunu giya, “Ebete aimano gabugabu ega꞉walo temeteme kuwateaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Egela idilo epo epetapi bilibilinomate Ya꞉suko da꞉na꞉wa꞉midadigiya, ebete ebe tanalo umite ebe waloma꞉tapi nanaliya, “A paka꞉ apuamo ka꞉na꞉iwaliye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ebe tetelo Godokono Totomu iyatulamedawa idite pete ebetamo na꞉pegiya, “Iyatulamedawa, a꞉ma꞉ kebamo ka꞉toaemene, nale a꞉ma꞉ ebamo kowaloma꞉tamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Wiyasiya Ya꞉sute ebeno tabo olowite negiya, “Iyaiya, a꞉ma꞉ dopamo me tanalo idi wadenomamo nemalagidila. Tumu gaagaano lao bai damela gugu ba꞉pola꞉lamena ega꞉walo olaolate ibino moto etemoteonaka, wiyasiya na Epono Naniwi naimano wata bai puliyala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ebene waloma꞉tadawa idite negiya, “Kawodawa, modobola na dopamo tote, naimano nabiwi kadelete da꞉emene, nale ebeno ape bobamo niyatite na walone a꞉ma꞉ kowaloma꞉emamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ya꞉sute ebetamo nowamiya, “Ao, a꞉ma꞉ ka꞉lonomo na nowaloma꞉ena꞉, wiyasiya modobola a꞉elao epate ibi a꞉ka꞉tuwa꞉ ibino a꞉elaopi bobamo nalomoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ebene adimo tete eba tatalinalo Ya꞉sute peamo da꞉niwisigani ebe waloma꞉tapiate eba꞉go kapimiya niwitioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Iba꞉te peamo olonate da꞉tolameniya ebe tetelo kawo awanomote eba penalo kawokawo ulate maimionate pe guamo obo ebo polomeni, wiyasiya Ya꞉sute pe gulo u ebe watani. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ebema꞉ waloma꞉tapiate ebetamo pelamenate ebe eba pamutiyanalo ebo pananiya, “Kawodawa, aimano igilo na꞉mula꞉leama꞉! A ka꞉elaomalema꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ya꞉sute wiyasiya negeni, “La꞉ beda꞉ma꞉ ka꞉toletoleawenama? La꞉imano nanitabokobi midi tanalo depesonomola!” Ebe tetelo ebete maiganate awa ega꞉walo ulo kawiya nanaleni, “La꞉ nolodiyobala꞉!” ebene paka꞉te matalukobi olowinomo gito olowini. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ebe tetelo ibi bilibilinomate eba anoanonalo negelaniya, “Me kebako dubula꞉ka꞉? Awa ega꞉walo ulo iba꞉te ebeno tabo olowite a꞉tudila꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ebene egela idilo Ya꞉sute paka꞉ apuamo na꞉iwate Gadala duliyomolono opamo nemaigate, damelamo eba nodololo kubakuba uliyanagono dubu netewate eba꞉go ebo palugiya. Ebe dubu netewate a꞉elao epono bobo bailo okolionamiya ega꞉walo ibi elawoelawonomola, ebema꞉ epate ebe gabodo wapata꞉laema꞉ kawonomamo toletoleonamiya. Nanitabola, ebe opo epono tanalo ma kunula, iba꞉te maboele nokola damela eba obobolelo iyaiya bobo ebo osiyodilolenakiya iba꞉te ibino a꞉elao epono ape alomoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Me dubu netewate Ya꞉suko dumiya ebe tetenomolo iba꞉te gelatepaolo negeliya, “A꞉ma꞉ Godokono Gudulata! A꞉ma꞉ atamo beda꞉ tanalo na꞉kosiyodilaemene? Godokono kuba wiya ikalame tete pea꞉no, a꞉ma꞉ dopamo a anakapuaema꞉ ka꞉pa꞉wa꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ebe tetelo ibi niyakabolo dabiole goeogoeo bilibilinomate nala꞉go wapata꞉lamitiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ebema꞉ kubakuba uliyanagopi dubate Ya꞉suko toweomelo negeliya, “A꞉ma꞉ a me dubagodone aliboema꞉ ubi diyata꞉wita, modobola a꞉ma꞉le a goeogoeatamo naliboa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ya꞉sute iba꞉tamo negiya, “Na꞉tolama꞉la꞉!” Ebe tetelo iba꞉te dubagodone nemaimite goeogoeatamo ebo nopila꞉iya, ebema꞉ ebe goeogoeate damela unune puila꞉ote maboele damelane da꞉na꞉gudiya, obamo nololuote ibi bilibilinomate gito na꞉elaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ebe tetelo Ya꞉sute kubakuba uliyanagopi wadekobi keba kunu ka꞉midioliyale, goeogoeo ulamepi dubate ebe tanalo umite ibino duliyomolamo puila꞉ote epo bilibilinomo ebo nanaliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ebene duliyomolo epo bilibilinomate Ya꞉sutamo pelamete, iba꞉te ebe da꞉pumiya ebe napaniya ebete ibino opo atepate ka꞉toma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ebene Ya꞉sute peamo olote paka꞉ apuamo na꞉iwate ebeno okoli duliyomolo Kapeniyamamo gito nemaigiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ebe tetelo epate ape kodakoda temetema꞉go dubu patapatago aguwatiya, ebene Ya꞉sute ibino nanitabokobi midi tanalo umilamete ebetamo negiya, “Naimano namutudawa, a꞉ma꞉ nekalakala! Godote a꞉imano kuba egebolemetate a꞉dodolomatilima꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wiyasiya Godokono Totomu iyatulamepi epetapiate ebe tabo olowite ibi magumulo tabo ma kunu gelitiya, “Me dubute amamago kuba tabo ge Godokono ololo apulo!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iba꞉te ibino tepo magumulo degeliya, Ya꞉sute iyatawate iba꞉tamo negiya, “Mabu keleka꞉ la꞉imano tepo magumulo me kuba tanalo demalagidilawitama? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Me tabo kodakodala꞉ka꞉ nale gema꞉, ‘Godote a꞉imano kuba egebolemetate a꞉dodolomatilima꞉ta?’ O me tabo idi gema꞉ kodakodala꞉ka꞉, ‘A꞉ma꞉ maigawete na꞉toa?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ebema꞉ nale la꞉ kiyatulaemamota na Epono Naniwigodolo elawo bitana me opo kawonomolo epono kuba egebolelamete ka꞉dodolomatililaema꞉.” Ebene Ya꞉sute temetema꞉go dubutamo negiya, “A꞉ma꞉ maigawete, keta mokopiamidawete motamo na꞉toa.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ebema꞉ ebe dubute maigate ebeno motamo gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nanitabola, epo bilibilinomate ebe tanalo umite eba anoanoutalo Godokono mailo unamo ebo adipatiya, mabu ibino ololo apulo ebete Ya꞉sudo ebeno elawo kawonomo awokalimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ya꞉sute ebe motone nemaigate eba petonatolo dubu idi ebo numiya, ebeno mailo Ma꞉tiyutela, ebe ta꞉kese uwatedawala, ebete ebeno woko bailo okoliti. Ebe tetelo Ya꞉sute ebetamo negiya, “A꞉ma꞉ na nowaloma꞉ena꞉,” ebene ebete maigate Ya꞉suko nowaloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ebene Ya꞉sute ebe waloma꞉tapiago Ma꞉tiyukono motolo bae eba nautalo, ta꞉kese uwatepi ega꞉walo Godokono Totomu Tabo uwatea꞉pi ibi bilibilinomo epetapiate pelamete iba꞉go pepola꞉niya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ebe tetelo Pa꞉lisi tanebapi dubu epetapiate ebe tanalo umite ebe waloma꞉tapiatamo negeliya, “La꞉imano iyatulamedawate ta꞉kese mani elemasigilo uwatepi ega꞉walo Godokono Totomu Tabo uwatea꞉piago bae beda꞉ma꞉ kenanakole?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ya꞉sute ebe tabo olowite negiya, “Wadewade epate doketatamo a꞉ka꞉tolaema꞉na꞉, wiyasiya gabugabuagopiate ka꞉tolaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Iyo, piyate a꞉ka꞉tuwa꞉ degelana, ‘A wadewade epola,’ na ebakobako epo uwatema꞉ ka꞉piya꞉. Na wiyasiya kubakuba epo kapiya uwatema꞉ piyamo, iba꞉te na kowaloma꞉enema꞉. Ebema꞉ modobola la꞉ me Godokono Buka apuno tabo magumu na꞉nowadiala꞉, ‘La꞉ natamo kalimagono inamabu gito akopikanama꞉la꞉, na ubia꞉nola. Wiyasiya na ubila la꞉imano tepo magumulo nilakapo tanalo kuima꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ebene Yonekono waloma꞉tapi epetapiate Ya꞉sutamo pelamete ebe napalatediya, “Mabu keleka꞉ a ega꞉walo Pa꞉lisi tanebapi a bilibilinomate iyaiya tetelo bae naoa꞉no da꞉pola꞉nanakoma꞉ Godokono woko osiyodiloma꞉, wiyasiya a꞉ma꞉ waloma꞉tapiate bae naoa꞉no ka꞉pola꞉nanakoa꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ya꞉sute iba꞉tamo negiya, “Dubute kamiyale daidimene, ebe tetelo ebeno namutupiate soliyomu bailo tepo mibomibago gito ba꞉ka꞉pola꞉nama꞉na꞉? Ao, modoboa꞉! Iba꞉te eba꞉go soliyomu bae kapimiya kenaoma꞉na꞉. Wiyasiya kamiyale oli aidi dubute ebeno kamiyale duliyomolo ida꞉mo magata tete na꞉pe, nanitabola, ebe tetelo ebeno namutupiate ibino tepo temeteme tanaloma꞉ bae naoa꞉no ka꞉pola꞉nama꞉na꞉. Ebema꞉ numa꞉la꞉, me tete ebe la꞉imano kalakalago bae nao tetela mabu nale la꞉go bokolinamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ebene Ya꞉sute tabo moga꞉melo walo na꞉kegiya, “Lumagite oli kaliku apu tagala kalikuno bolegala꞉mo a꞉kowaluomene, mabu kaliku ukula tetelo ebe oli kaliku apute tagala kaliku kanagiyamidalemene, ebene bolegalete kawonomoma꞉ keda꞉mene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ega꞉walo atu gabodo lumagi idite tagala gautu-goeo tama kalila꞉mo oli da꞉imi obo akalatemene, mabu oli da꞉imi obote tagala gautu-goeo tama kalili ka꞉na꞉ta꞉pulaemene, ebene da꞉imi obote opamo ka꞉ka꞉liyaote da꞉imi obo ega꞉walo kalili ibi netewate kapiya tetelo ka꞉kubakubaoma꞉na꞉. Me mabuma꞉ iyatawadawate oli da꞉imi obo olioli tama kalili kapiyamo nalateonakomene, da꞉imi obo ega꞉walo kalili iba꞉te tete geyageyalo wadenomamo ka꞉pola꞉nama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ya꞉sute me tabo iba꞉tamo eba kiyawautalo, Yu watodawa dubute ebetamo pete pupamo pokolite na꞉pegiya, “Naimano buwele ka꞉ma꞉nomo a꞉e, wiyasiya a꞉ma꞉ pa꞉wete a꞉imano koto ebetamo da꞉powatila꞉emene ebete a꞉ene walo ka꞉kemaigamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ebema꞉ Ya꞉sute maigate ebe waloma꞉tapiago ebe kawo dubu ebo waloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ebe tetelo kamiyale idi 12 ulama tetelo kalima ka꞉ka꞉liya temetemete duminami, ebete Ya꞉sukono walogabo apune pete ebeno kaliku ebo pologiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","mabu ebete nemalagidiliya, “Nale ebeno kaliku dologimo, nale wadekobi kolowimamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ya꞉sute olobigate ebe dumiya ebetamo negiya, “Kamiyale, a꞉ma꞉ nekalakala! A꞉imano nanitabokobi midi tanalote a꞉ma꞉ wadekobi a꞉mida꞉ta.” Ebe tetenomolo ebe kamiyaleno temetemete ebo olopoligomiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ebene Ya꞉sute Yu watodawa dubuno motamo pete a꞉e buwele liyaema꞉ bibolo da꞉moleutiya ebe dubu ega꞉walo epo bilibilinomo ebo pulamiya, iba꞉te gowela kawonomago pola꞉niya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ebema꞉ ebete ibi nanaliya, “La꞉ bilibilinomo moto gune na꞉nemaimiala꞉. Buwele da꞉peso ka꞉eaka꞉, ebe u watita.” Wiyasiya ibi bilibilinomate ebe nekalakalatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ebe tetelo Ya꞉sute epo motone palibolete buwelete dekapitani ebe baiamo nopegate ebeno koto da꞉nelaemiya ebete ebo maigiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ebene ebe anoano tanalono tabote ebe opo kawonomamo gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ya꞉sute ebe duliyomolo atepate eba tonatolo, balidi tamiolame dubu netewate ebe eba waloma꞉tanatolo kawonomamo ebo negelapatiya, “Da꞉ibidikono A꞉la꞉mu! A꞉ma꞉ a na꞉nilakapoiama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ebene Ya꞉sute moto gu ida꞉mo nodolote ebe balidi tamiolame dubate atu motamo da꞉ka꞉nodoliya Ya꞉sute ibi nalateda꞉liya, “La꞉ nanitabokobi na꞉ka꞉mida꞉witama, nagodolo elawo bitana la꞉ wadekobi ka꞉midioletama꞉?” Iba꞉te tabo eba wiyalo negeliya, “Iyo, Kawodawa, a꞉ma꞉godolo elawo bitana.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ebe tetelo Ya꞉sute ibino balida꞉mo ebeno koto eba watiolelamelo iba꞉tamo negiya, “Mabu la꞉le na nanitabokobi a꞉midinimata, ebe mabuma꞉ nale la꞉imano balidi wadekobi ka꞉midiolemamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ebene ibino balidite wadekobi dolowiolamiya, Ya꞉sute ibi kawonomamo analelo iba꞉tamo negiya, “La꞉ me tanaloma꞉ epo epetapi akoanala꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","wiyasiya iba꞉te tote ebe opo kawonomamo Ya꞉sukono tanalo ebo na꞉kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ebene ebe dubu netewate eba tutalo epo epetapiate dubu idi Ya꞉sutamo ebo magatiya, mabu ebe tabo kiyawaoa꞉ kuba uliyanagonola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ebe tetelo Ya꞉sute ebegodone kuba uliyana dalibiya ebete tabo kiyawao ebo wagilimiya, ebema꞉ epo bilibilinomate me tanalo umite anoanolo negeliya, “A Isalaela opolo mako tanalo kuminakia꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","wiyasiya Pa꞉lisi tanebapiate negeliya, “Ebete kubakuba uliyanano Kawodawano elawamo alibolenako, Godokono elawamoa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ya꞉sute Yu epono kawokawo ega꞉walo egege duliyomolodo da꞉petonaki, ebe tetelo ebete ibino iyaiya balidi ibilamole motolo ibi eba iyatulamelo ebete Godokono Kawo Elawodawano tanalono Wade Tabo iba꞉tamo ebo kiyawaonaki, ega꞉walo ebete ibino iyaiya temetema꞉gopi wadekobi a꞉ka꞉midiolenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ebene egela idilo ebete epo bilibilinomo ulamete ebeno tepo magumulo kawonomamo nilakapoilamiti, mabu iba꞉te woki bilibilima꞉ ega꞉walo elawoa꞉noma꞉ eda꞉utiya, sipi-goeogoeate ulamedawa꞉no keba kunu kilukuline eba kunu. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ebene Ya꞉sute ebe waloma꞉tapiatamo negiya, “Godokono pali magumulo kono bilibilinomo a꞉kodakodaiya, wiyasiya tapio wokopi bilibilia꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ebema꞉ la꞉ pali namutudawatamo towetowe tabo negelala꞉, ebete wokopi epetapi pali magumamo kapalibolemene wadewade kono ka꞉powakalamima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ebe tetelo Ya꞉sute ebeno 12 waloma꞉tapi dubu ebetamo ka꞉la꞉mite iba꞉tamo elawo ebo ikalamiya, iba꞉te epagodone kubakuba uliyana kanalibolema꞉ ega꞉walo iyaiya temetema꞉gopi wadekobi ka꞉nimidiolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Me Ya꞉sukono 12 alibolepi dubuno mailola. Dopo dubu ebe Saimonotela, ebeno mailo idi Pitate, ega꞉walo ebeno ekawi A꞉ndulutela. Sebedikono gudi Ya꞉imesiko ega꞉walo ebeno ekawi Yoneko. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipiko, Batolomuko, Tomasiko, ega꞉walo Ma꞉tiyuko, ebe ta꞉kese uwatedawala. A꞉lapiyasikono gudu Ya꞉imesiko, Ta꞉diyasiko, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ega꞉walo Saimonoko. Me Saimono idi ebe ubila kapela Loma gabamani epago eba gowelalo iba꞉te ebeno Ka꞉inane opo ebo katepama꞉. Ega꞉walo walogabo dubu ebe Keliyota duliyomolodawa Yudasite, ebete walone tetelo Ya꞉suko anakapumipi walubiliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ya꞉sute me 12 dubu eba alibolelo ibi nanaliya, “La꞉ Yua꞉piatamo akotolama꞉la꞉, ega꞉walo Samaliya opo epatamo akonemaimiala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Wiyasiya la꞉ Isalaela opolo dilukuliona ebe Yu epo kapiyatamo na꞉tolamiyala꞉, iba꞉te tumamo dalatidioliya ebe sipi-goeogoeo keba kunula꞉ka꞉ eba kunu ilukulina. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ebene la꞉ eba tolamelo me tabo kapiyate na꞉kiyawaonatiyala꞉, ‘Godokono Kawo Elawodawama꞉ eda꞉ tete tatalila.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ega꞉walo la꞉ ebolo gabugabute dulamena ebe epo wadekobi na꞉na꞉midiolenakiyala꞉, kukulakukulagopi ibi atumu. Ebe atu tetelo a꞉elaopi a꞉e magumune nowadipalatelenakiyala꞉ ega꞉walo kubakuba uliyana epagodone nalibolenakiyala꞉. “Nanitabola, tete bilibilinomolo Godote ebeno wadewade tanalo la꞉tamo nilakapolo gito ikalamenakota, ebema꞉ modobola la꞉ epetapi atu nilakapo tanalago nowalubilinakiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ebema꞉ la꞉ eba tolamelo kawokawo mani gatele magumamo akoalomala꞉, ega꞉walo egege mani atumu akowatala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gabo tetelo la꞉ kapiyakapiya inamabu na꞉pupuliyala꞉, epetapi akouwata꞉la꞉. Ega꞉walo la꞉ inamabu alomono ikuwa, agowa pata, ega꞉walo gaubu atumu akouwata꞉la꞉, mabu duliyomolo epate wade wokodawano iyaiya modoboa꞉ tanalo ebolo na꞉modoboilamelemenakoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“La꞉ duliyomolo ida꞉mo nemaimiawete wade okoli lumagi nowadiawete da꞉numa꞉ema, ebeno motamo nodoloawete ebegodolo nilukula꞉tepawete walone ebeno motone opo ida꞉mo ka꞉ka꞉tolaemamota, iyo, la꞉ moto idine moto ida꞉mo eba kunu akonowagela꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ega꞉walo la꞉ kebe motamo da꞉nodoloaema, modobola la꞉ ebe moto epatamo nilakapo tabo ma kunu na꞉negeliyala꞉, ‘Godokono kalakalate la꞉godolo nitanamene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ebema꞉ ebe moto epate la꞉ kalakalago uwatetate la꞉imano tabo dolowima꞉na꞉, Godokono kalakalate iba꞉godolo nanitabonomolo kitanamene, wiyasiya iba꞉te la꞉ uwateta꞉no, la꞉ nilakapo tabo degelaema ebe tabono nanitabo tanalote ebolo a꞉kitanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ebene kebe epate la꞉ kalakalago uwateta꞉no, la꞉ ebe motone o duliyomolone eba tolamelo la꞉imano agowano tuwae na꞉moda꞉midatepaliyala꞉. Me tanalote ibi kiyatulaemene, Godokono tete ebe na꞉pe ebete ibino tanalo kapanagilamelelaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na la꞉tamo nani tabo gemo, Godote epono tanalo danagilamelelaemene, ebe Kawo Egelalo ebete me duliyomolo epatamo kuba wiya kawonomamo kikalaemene. Ebe tetelo ebete Sodomo ega꞉walo Gomola duliyomolo epatamo kuba wiya eba ikalamelo nilakapo kela꞉mo kawokalimene, wiyasiya nanitabola, ebete nilakapo idi a꞉kiyatimene la꞉ uwatea꞉piyatamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ebene Ya꞉sute walo na꞉kegiya, “La꞉ nolowiala꞉! La꞉ sipi-goeogoeo keba kunula꞉ka꞉ eba kunula, nale la꞉ elawoelawo gaagaano taneba magumamo alibolemata. Ebema꞉ piyate la꞉go gowelaopima꞉ deda꞉ona, la꞉le iba꞉go eba na꞉pola꞉nalo modobola la꞉ mulo wokinomago nemalagidiloleniyala꞉, ega꞉walo atu tetelo milonomoma꞉ eba eda꞉olo temeteme lumagi iditamo akoikamenakala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","La꞉ nanisiwale, mabu kubakubapiate la꞉ elawamo uwatetate tabo anagiyamida baiamo kemagatalema꞉ta, ega꞉walo Yu epono balidi ibilamole moto gulo iba꞉te la꞉ pa꞉ka꞉pa꞉ka꞉mo ka꞉na꞉ma꞉ga꞉tiolema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Iba꞉te la꞉ na mabuma꞉ iyaiya kawokawo elawodubuno ololo apuamo elawago demagataletamene, ebe tetelo la꞉ naimano Wade Tabo iba꞉tamo ega꞉walo Yua꞉piatamo ka꞉kiyawaomamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ega꞉walo iba꞉te la꞉ tabo anagiyamida baiamo demagataletamene, ebe tetelo la꞉imano gela tanaloma꞉ woki bilibilima꞉ akoeda꞉oala꞉, ma kunu, ‘Na beda꞉ tabo na꞉kegemo? Ega꞉walo na tabo keba kunu na꞉ka꞉kiyawaomo?’ Tete da꞉pemene Godote ebeno iyaiya tabono tanalamo la꞉ kowalubilima꞉ta, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","mabu la꞉ a꞉ka꞉tuwa꞉ a꞉ka꞉kiyawaoaema, la꞉imano Nabiwi Godokono Uliyanate la꞉do ka꞉kiyawaomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ebe tetelo naniwite ekawi a꞉eamo kalibomene, ega꞉walo atu gabodo ekawite naniwi kanakapuimene. Iyo, dubute ebeno gudu atumu kakamitimene, ega꞉walo guda꞉te dowaote ibino menokobila nabila a꞉eamo kalibolema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ebene na mabuma꞉ epo bilibilinomate la꞉tamo ka꞉dowaoma꞉na꞉, wiyasiya kebe lumagite temeteme magumulo kodakodalo utite uwomuamo da꞉nemaigamene, Godote ebeno igilo ka꞉mula꞉emene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ebema꞉ iba꞉te la꞉tamo temeteme dikalametamene, ebe tetelo la꞉ wiyasiya duliyomolo ida꞉mo nalautiyala꞉. Na la꞉tamo nani tabo gemo, la꞉ Isalaela opono duliyomolo bilibilinomolo woko eba nosiyodilolo ebe iyaiya woko opoliyalea꞉no Epono Naniwite ebo ka꞉pemaigamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Numa꞉la꞉, epono umi magumulo sukulu guduno iyatawa tanalote ebeno iyatulamedawano iyatawa kodolina꞉, ega꞉walo wokodawano elawote ebeno woko namutudawano elawo kodolinakoa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ebema꞉ modobola sukulu gudute ebeno iyatawa magumulo ebeno iyatulamedawa keba kunula꞉ka꞉ ebako dawama꞉ na꞉keda꞉mene, ega꞉walo wokodawate ebeno woko magumulo ebeno namutudawa keba kunula꞉ka꞉ ebako dawama꞉ na꞉keda꞉mene. La꞉ nolowiala꞉! Iba꞉te na moto namutudawa kuba uliyana Biyesibulu mailamo eka꞉na꞉miya, ebema꞉ walone iba꞉te atumu la꞉ naimano ekaki kuba mailonomamo keka꞉la꞉ima꞉ta!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ebene Ya꞉sute walo na꞉kegiya, “Ebema꞉ ebe elawoelawo dubu akotolelama꞉la꞉. Kebe itiole tanalate da꞉pola꞉na walone tetelo Godote kawokalilaemene, ega꞉walo waminaole tanalate da꞉pola꞉na walone epate kulamolema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ebema꞉ nale idoko tetelo la꞉ da꞉kiyawaolametanakoma, la꞉le wiyasiya alo tetelo na꞉kiyawaolamenakiyala꞉, ega꞉walo la꞉le nagodone gananalo dolowiawenakoma, ebe iyaiya tanaloma꞉ la꞉imano tabo madodo eba adipatelo epo bilibilinomatamo nawokalilamenakiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","La꞉ ape anakapulame iyatawaopi akotolelama꞉la꞉. Iba꞉godolo elawo puliyala epono uliyana anakapulamete Ela Opamo iyalekema꞉. Wiyasiya la꞉ Godoko kapiya na꞉tolemenala꞉, mabu ebegodolo elawo bitana epono ape ega꞉walo uliyana kapiya tetelo Ela Opamo iyalekema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Numa꞉la꞉, epate netewa piliyo olaola kapiya toea maniamo uwatema꞉ gelanaka, ebe olaolano igilo kawokawoa꞉, wiyasiya la꞉imano Nabiwi Godote ebako egege olaola eba malagidilolenalo, ebete modobo tabo gea꞉no ibi magumulo idi kapiyate a꞉ka꞉emene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ega꞉walo nanitabola, la꞉imano watono eke bilibilinomo Godote iyalo tetelo eka꞉la꞉mioliya, iyo, la꞉imano iyaiya tanalo ebete iyatawanomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ebema꞉ la꞉ woki bilibilima꞉ akoeda꞉onala꞉. Ebeno nilakapo olaolatamo nanitabonomolo bitana, wiyasiya ebeno nilakapo la꞉tamo kawonomoma꞉ eda꞉te ilukulina tetelo bitanamene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ebene Ya꞉sute walo na꞉kegiya, “Kebe lumagite awokala degemene, ‘Na Ya꞉suko waloma꞉tadawala,’ na atumu Nabiwi Godokono ololo apulo kegemamo, ‘Me lumagi ebe naimano ekawila.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wiyasiya kebe lumagite na iyatawa꞉ma꞉ degemene, na atumu Godotamo ebe iyatawa꞉ma꞉ ka꞉kegemamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ebene Ya꞉sute walo na꞉kegiya, “La꞉ na꞉kemalagidilawitama nale me opamo milo adaema꞉ pe? Ao, na epatamo milo ikalaema꞉ ka꞉piya꞉, na gowelaono gili ikalaema꞉ piyamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Numa꞉la꞉, naimano iyaiya tabono tanaloma꞉ anagiyamida tanalote epo magumulo ka꞉pemaigamene. Ma kunu anagiyamida tanalote dubu ega꞉walo ebeno nabiwi ibi magumulo kitanamene, ega꞉walo buwele ebeno menokago ibi magumulo kitanamene, ega꞉walo kamiyale ebeno awino menokago ibi magumulo kitanamene. Iyo, na anagiyamida tanalo epatamo ikalaema꞉ piyamo, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ebema꞉ nanitabola, na mabuma꞉ dubuno moto epate eba꞉go ka꞉gowelaoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ebema꞉ kebe lumagite ebeno nabiwila menokola kawonomamo eba malagidilelo na kela꞉mo demalagidilonena, ebe lumagite naimano woko osiyodiloma꞉ a꞉ka꞉modobomene. Ega꞉walo kebe lumagite ebeno gudi kawonomamo eba malagidilolenalo na kela꞉mo demalagidilonena, ebe lumagite naimano woko osiyodiloma꞉ a꞉ka꞉modobomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ega꞉walo kebe lumagite ebeno kewa olotolowa agute na waloma꞉enea꞉no, ebete atumu naimano woko osiyodiloma꞉ a꞉ka꞉modobomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ebema꞉ kebe lumagite ebeno kateneno ubi gabodo eba tolo ebeno igilo nagodone damoeda꞉mene, ebeno igilote kalatidimene, wiyasiya kebe lumagite ebeno igilo na mabuma꞉ datutimene, ebete nanitabo igilo kelaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ebene Ya꞉sute walo na꞉kegiya, “Kebe lumagite a꞉ma꞉ kalakalago dowalubitana ebete na walubinina, ega꞉walo kebe lumagite na dowalubinina ebete na kapiya kowalubinina꞉, ebete na Alibonedawa Godoko atumu na꞉kowalubina. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ebema꞉ kebe lumagite Godokono woki awokalimidawa kalakalago dowalubina ebete walone Godogodone ebeno woki awokalimidawano wiya ka꞉nelaemene, ega꞉walo kebe lumagite tuputupudawa kalakalago dowalubina ebete atumu tuputupudawano wiya ka꞉nelaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na la꞉tamo nani tabo gemo, me egegepi magumulo kebe lumagite na waloma꞉enedawama꞉ deda꞉na, ebe mabuma꞉ idawate gibagiba obo ebetamo dikaemene, ebete Godogodone delaemene ebe wade wiyate akalatidimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ebene Ya꞉sute ebeno 12 waloma꞉tapi iyatulame dolopoligiya, ebete ebe duliyomolo atepate Yu epono duliyomolo epetapilo ibi iyatulama꞉go eba tolo Godokono tabo ebo kiyawaolamenatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ebe tetelo Yoneko epo obamo waduba꞉midaoledawate idoko motolo eba okolinalo, Kelisote wadewade tanalo dosiyodilolenami ebete ebe tanalo olowiote ebe waloma꞉tapi ebetamo ebo aliboliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ebene ibi netewapiate Ya꞉sutamo da꞉pemaimiya iba꞉te ebe ma kunu paniya, “Yonete pema꞉ degi, a꞉ma꞉ ebe lumagila꞉ka꞉ o ale lumagi idi kemakopelenama꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ebene Ya꞉sute wiya tabo iba꞉tamo negiya, “La꞉ toawete la꞉le kebe tabo kolowiawitama ega꞉walo kebe tanalo kulama꞉witama, ebe iyaiya tanalo Yoneko nananala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Balidi tamiopiate balidi a꞉melea ega꞉walo agowa tataipiate nowapata꞉lama꞉! Kukulakukulagopiate wadekobi olowiya ega꞉walo galo tamiolamepiate nolowia! A꞉elaopiate a꞉ene walo a꞉kemaimiya ega꞉walo nigologolo epatamo Godokono Wade Tabote a꞉pe! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ebema꞉ kebe lumagite na nanitabokobi eba midinilo woki netewama꞉ eda꞉no, ebegodolo Godokono kalakala tanalote bitanamene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ebene Yonete dapaliboliya ebe dubate eba tolo, Ya꞉sute Yonekono tanaloma꞉ epatamo ebo kiyawaiya. Ebete negiya, “La꞉ Yonekono tanalo olowiawete bulu opamo da꞉nemaimiaima, beda꞉ tanalo uima꞉ ka꞉tolama꞉ima? Pudo kapiya awate gito dadegetiti, ebe uima꞉ ka꞉tolama꞉ima? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O la꞉ wadewade kaliku pupulio dubu uima꞉ ka꞉tolama꞉ima? Ao, la꞉ iyatawalata wadewade kaliku pupuliopiate bulu opolo kilukuliona꞉, wiyasiya iba꞉te kawokawo elawodubuno motolo ibino kateneno ubilo ilukuliona! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ebema꞉ la꞉ na niyatunama꞉la꞉, la꞉ beda꞉ma꞉ ka꞉tolama꞉ima? Godokono woki awokalimidawa uima꞉la꞉ka꞉? Iyo, na la꞉tamo nani tabo gemo, Yonete Godokono woki awokalimipi bilibilinomo odoili. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nanitabola, Yonekono tanaloma꞉ Godote ebeno Bukalo tabo ma kunu giya, ‘Nale Kelisokono dopo apuamo naimano tabo atadawa kapalibomamo, ebete ebe dopomete ebeno gabo kosiyodiloma꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ya꞉sute walo na꞉kegiya, “Nale la꞉tamo nani tabo gemo, wagilimi mabune me teta꞉mo pemaiga me opo kawonomolo dawokalaiya, ebe epo bilibilinomo magumulo Yoneko kawodawanomoma꞉ eda꞉na. Wiyasiya me tetene wagilimite Godote Kawo Elawodawama꞉ deda꞉na, ebe duliyomololo kebe lumagite da꞉pesonomoma꞉ deda꞉mene ebete Yoneko nanitabolo kodolimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Me tanalo idila. Yoneko tetene wagilimite me teta꞉mo pemaiga, elawoelawo dubu ubila Godokono Wade Duliyomolo ibi a꞉ka꞉tuwa꞉ ibino elawamo lawete ebamo ka꞉nopila꞉oma꞉, wiyasiya iba꞉te a꞉ka꞉modoboma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","La꞉ nolowiala꞉. Godokono woki awokalimipiate ebeno Bukamo dakuloliya ega꞉walo ebete ebeno Totomu Tabo Mosesedo epatamo dikalamiya, ebe wade tabono tanalote iyalo tetelo awokalate, penatete Yoneko teta꞉mo ebo pemaigi. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nanitabola, Godote dopamo tabo ma kunu kiyawaiya, ebeno woki awokalimidawa Elayako ka꞉pemene, iyo, Yoneko me ebe lumagila, ebema꞉ modobola la꞉ me tanalo nanitabokobi na꞉mida꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Galagodawa, a꞉ma꞉ wadenomamo nolowia!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ebene Ya꞉sute negiya, “Na me tete epono tanalo kebe uli tabamo nakawokalimo? Ibi olowame bailo dekalakalauta ebe gudi egege keba kunula꞉ka꞉ eba kunula. Gudi epetapiate epetapiatamo kegela, epetapiate epetapiatamo kegela, iba꞉te apaminateuilo ma kunu wagelena, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ale soliyomu eba osiyodilolo bibolo da꞉moleoma꞉ wiyasiya la꞉ ago kemaeawea꞉, ega꞉walo a a꞉e lumagi bobamo iyatima꞉ dowagelitama꞉ wiyasiya la꞉ ebe ka꞉liyama꞉wita꞉!’ Iyo, me tete epo eba kunu wagelena, iba꞉te Godokono wokopiatamo ubia꞉ tabo gelanaka. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Numa꞉la꞉, Yonete da꞉pemaigi ebe tetelo ebete elawo da꞉imi obo ka꞉ninakia꞉ ega꞉walo tete epetapilo ebete bae naoa꞉no lutanaki Godokono woko kosiyodiloma꞉, ebema꞉ epate negeliya, ‘Ebe kuba uliyanagonola!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Wiyasiya Epono Naniwite da꞉pemaigi, ebeno tanalo iyala. Ebete bae enanako ega꞉walo elawo da꞉imi obo a꞉ninako, ebema꞉ iba꞉te ma kunu gelanaka, ‘Ebeno kuba numa꞉la꞉! Ebe tumu goeoma꞉ eda꞉te bae kawonomamo nanako, ebe elawo da꞉imi obo ni kawodawala! Ebe ta꞉kese mani elemasigilo uwatepi ega꞉walo Godokono Totomu Tabo uwatea꞉pi epetapi ibino namutudawala!’” Ebene uwomunomolo Ya꞉sute iba꞉tamo negiya, “Godokono wade mulo tanalo dowaloma꞉tana, ebe epate ibino osiyodilole magumulo ebe mulo nanitabonomolo bawokaliminakoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ya꞉sute kebe iyaiya duliyomololo anoano tanalo bilibilinomo dosiyodilolenaki, ebe duliyomolo epate ibino kuba woki iyakobi midilite Godotamo kolobiliya꞉. Ebe mabuma꞉ Ya꞉sute ibi kawonomamo ma kunu analiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kolasini duliyomolo, a꞉ma꞉ kuba wiya kawonomo kelaema꞉ta! Betasaida duliyomolo, a꞉ma꞉ ebe atumu! Mabu nale la꞉godolo anoano tanalo dosiyodilolimo, nale ebakobako woko Taya duliyomololo ega꞉walo Saidono duliyomololo dopamo nosiyodiloliyataleka꞉, ebe Yua꞉ epate ibino kubakuba woki iyakobi ba꞉midiliyana꞉. Iyo, iba꞉te ibino kuba osiyodilole mabuma꞉ tepo temetemema꞉ eda꞉ote ebe temeteme kawokalima꞉ kubakuba kaliku pupuliote ono tuwaeamo gito bilukuliyana꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ebema꞉ na la꞉tamo negemo, Godote epono tanalo danagilamelelaemene, ebe Kawo Egelalo ebete Taya duliyomolo epatamo ega꞉walo Saidono duliyomolo epatamo kuba wiya eba ikalamelo nilakapo kela꞉mo kawokalimene, wiyasiya nanitabola, Kolasini duliyomolo ega꞉walo Betasaida duliyomolo, ebete la꞉tamo nilakapo a꞉kiyatimene! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ega꞉walo Kapeniyama duliyomolo, a꞉imano tanalo ma kunula. A꞉ma꞉ ubila a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉ma꞉ Godokono Unu Duliyomolamo kadipata꞉ema꞉, wiyasiya Godote a꞉ma꞉ Ela Opamo keba꞉idiloma꞉ta! Mabu nale a꞉ma꞉godolo anoano tanalo dosiyodilolimo, nale ebakobako woko Sodomo duliyomololo nosiyodiloliyataleka꞉, ebe Yua꞉ epate ibino kubane olobila꞉ote Godote ibi akanakapulamiyana꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ebema꞉ na a꞉ma꞉tamo negemo, Godote epono tanalo danagilamelelaemene, ebe Kawo Egelalo ebete Sodomo duliyomolo epatamo kuba wiya eba ikalamelo nilakapo kela꞉mo kawokalimene, wiyasiya Kapeniyama duliyomolo, ebete a꞉ma꞉tamo nilakapo a꞉kiyatimene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ebe tetelo Ya꞉sute Godotamo negiya, “Aba, a꞉ma꞉ me opo kawonomo ega꞉walo Unu Duliyomolo Namutudawama꞉ eda꞉nata! Na a꞉ma꞉tamo kalakala tabo gemo, mabu a꞉ma꞉ me opono kawokawo iyatawapi dubatamo a꞉imano mulo woki eba waminaolelo iyatawa꞉ epatamo awokalilamiata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aba, nanitabola, me tanalote a꞉imano ubilo pemaigi.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ebene Ya꞉sute epatamo negiya, “Naimano Nabiwi Godote tanalo bilibilinomo naimano kotamo alomiya nale kulamenama꞉, ebema꞉ ebete a꞉ka꞉tuwa꞉ iyatawala na ebeno Guduno tanalo, lumagi idite iyatawa꞉. Ega꞉walo Nabiwino tanalo atumu, lumagi idite iyatawa꞉ wiyasiya na ebeno Gudute a꞉ka꞉tuwa꞉ iyatawala, ega꞉walo nale piyatamo Nabiwino tanalo awokalima꞉ ubi diyatimo, ibinomate atumu Nabiwino tanalo ka꞉kiyatawaoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ebema꞉ la꞉ piyate mibomibo magumulo dilukula꞉wenama, la꞉ natamo da꞉pelama꞉ema nale tutulo okoli tanalo la꞉tamo kikalaemamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Numa꞉la꞉, netewa kau-goeogoeate woko eba osiyodilutalo, namutudawate ibino abaumu unamo kewa olotolowa iyatilamete iba꞉te kapimiya ebo ka꞉toma꞉na꞉, ebema꞉ a꞉ma꞉ atumu, a꞉ma꞉ ega꞉walo na, ale kapimiya ba꞉tonakoma꞉ woko kosiyodilonama꞉. Ebe tanalo magumulo a꞉ma꞉ naimano tanalo wadenomamo ma kunu kiyatawama꞉ta, nale mulo ega꞉walo milo okolidawama꞉ deda꞉namo. Ega꞉walo a꞉ma꞉ nagodone tutulo okoli kelaema꞉ta, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ebema꞉ nale a꞉imano abaumu teta꞉mo diyatimitama, a꞉ma꞉ ebe kewa olotolowa mibonomoma꞉ a꞉kegeaemene, ega꞉walo nale inamabu waguatama꞉ dikametama a꞉ma꞉ tutuma꞉ kegema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yu epono wokoa꞉ talena egela idilo Ya꞉sute ebe waloma꞉tapiago kono pali magumudo petolamiya, ebene bae kape tanalote ebe waloma꞉tapiatamo da꞉piya, iba꞉te kono naoma꞉ kapiyakapiya kubakubadopo ebo nowakalamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pa꞉lisi tanebapi epetapiate ebe tanalo umite Ya꞉sutamo negeliya, “Numa꞉, a꞉imano waloma꞉tapiate wokoa꞉ talena egela adikanalita.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ebene Ya꞉sute tabo eba wiyalo negiya, “Modobola Godote ebeno Bukamo dakuloliya, la꞉ ebe tanalo nemalagidilala꞉. Da꞉ibiditamo kuba tete da꞉piya, ebete ebeno wapata꞉lamepiago bae kapete dulamiti, ebene ebete beda꞉ tanalo kosiyodiliyale? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ebete Godokono Motamo nodolote, ebe Motono wokopiate Godotamo dalomonakiya ebe talena bae ebete ebeno wapata꞉lamepiago a꞉nenaiya. Ebe tanalo magumulo iba꞉te aimano totomu tabo adikanaliya, mabu totomu tabote a niyatuamena a bilibilinomate ebe bae nao talenala, Godotamo kalimagono ikameopiate a꞉ka꞉tuwa꞉ naonaka. Wiyasiya numa꞉la꞉, Da꞉ibidiate denaiya Godote ebe tanalo kubama꞉ kegiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ega꞉walo Godote ebeno Bukamo Mosesedo dakuloliya, me tanalo idi nemalagidilala꞉. Piyate ebetamo kalimagono ikameopima꞉ deda꞉ona, iba꞉te wokoa꞉ talena egelalo ebe amamateno motolo woko dosiyodilonaka, ebe tetelo iba꞉te ebe talena egela dadikanalenaka wiyasiya Godote ebe tanalo modoboma꞉ gena. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Ebema꞉ nale la꞉tamo gemo, Godoko Amamateno Motono talena nanitabolo bitana, wiyasiya nagodolo ditana ebe talenano elawote iyaiya talena epetapino elawo nodoilina. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Godote ebeno Bukalo negena, ‘La꞉ natamo kalimagono inamabu gito akopikanama꞉la꞉, na ubia꞉nola, wiyasiya na ubila la꞉imano tepo magumulo nilakapo tanalo uima꞉.’ La꞉ Pa꞉lisi tanebapiate me tabono magumu niyatawawetaleka꞉, na waloma꞉enepiate tuputupu tanalo eba osiyodilolo la꞉ ibi kubakubapima꞉ a꞉kegelawena꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","mabu nanitabola, na Epono Naniwite wokoa꞉ talena egela namutudawama꞉ eda꞉namo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ebene Ya꞉sute ibi miyapate ibino balidi ibilamole motamo da꞉nodoliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","koto apu a꞉eme dubute ebolo na꞉luti. Pa꞉lisi tanebapi epetapiate ebolo da꞉pola꞉niya, ibi ubila Ya꞉suko kubadawama꞉ kegelama꞉, ebema꞉ iba꞉te ebe nalatediya, “Wokoa꞉ talena egelalo temetema꞉godawa wadekobi midima꞉ talena ba꞉kitanale?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ebene Ya꞉sute iba꞉tamo negiya, “A꞉imano sipi-goeote talena egelalo damela gugamo da꞉negamene, a꞉ma꞉ samamo ebe nowaluba꞉wete ka꞉nowagilima꞉ta, a, nanitabola꞉ka꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","La꞉ me tanalo iyatawala, sipi-goeono igilo tanalote kawoma꞉ keda꞉na꞉ wiyasiya lumagino igilo ebe kawo tanalonomola. Ebema꞉ aimano totomu tabote talena kiyatiamena꞉ wokoa꞉ talena egelalo wadewade tanalo osiyodilolema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ebe tetelo Ya꞉sute koto apu a꞉eme dubutamo negiya, “A꞉imano koto nuwamida,” ebene ebete koto duwamidiya ebeno kotote wadekobi ebo olowiya, apulo wadeno ditameni eba kunu. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ebe mabuma꞉ Pa꞉lisi tanebapiate dowago tolamete tabo ebo negeliya Ya꞉suko kanakapuima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ebe tetelo Ya꞉sute Pa꞉lisi tanebapino kuba nopo iyatawate ebete ebe duliyomolo atepate gito tiya, ebene epo bilibilinomate ebeno tanalo umite ebe ebo waloma꞉tiya. Ibi magumulo piyate temetema꞉go da꞉pola꞉niya Ya꞉sute ibi bilibilinomo wadekobi midiolete, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ibi ma kunu kawiya analiya, “La꞉ naimano tanaloma꞉ epo akoanala꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ebema꞉ Ya꞉sukono osiyodilo magumulo Godokono woki awokalimidawa Aisayate degiya, ebe tabono nanitabo tanalote maigiya. Iyalo tetelo ebeno tabo kiyawao magumulo Godote ma kunu giya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Me naimano wade Wokodawala, nale ebe dopamo eka꞉miyamo. Nale ebe nilakapolo eba malagidilonalo ebetamo kawonomamo nekalakalanamo, ebema꞉ nale naimano Wade-talena Uliyana ebe unamo nalibote, ebene ebete iyaiya opo epatamo ibino igilo mula꞉lelame tanaloma꞉ tabo ka꞉kiyawaomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","“Me Wokodawate apaminateui tanalo kiyatawanakoa꞉, ebete naimano tabo eba kiyawaolo a꞉kegeatepaomene, ega꞉walo epono ololo apulo ebete tabo madodo unamo akadipatemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Piyate elawoa꞉noma꞉ deda꞉ona ebete iba꞉tamo nilakapago ka꞉tomene, eba kunu ebete balibali pudo gito akadikanalemene, ega꞉walo wuiki alono mena da꞉pesoma꞉ deda꞉na ebete gito a꞉ka꞉egamidamene. “Nanitabola, naimano Wokodawate wadewade tanalo eba osiyodilolelo Tuputupu Okoli tanalote Kubano wato kikopu kelaemene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ebema꞉ opo bilibilinomono epate me naimano Wokodawano pe tanalo makopelena.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ebe tetelo epo epetapiate dubu idi Ya꞉sutamo magatiya, ebe dubute tabo ka꞉kiyawaonakia꞉ ega꞉walo ebe balidi tamiomela, mabu ebe kuba uliyanagonola. Ebene Ya꞉sute ebe wadekobi da꞉midiya, ebete tabo kiyawao wagilimite balidi wadekobi ebo olowiomiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ebema꞉ epo bilibilinomate eba anoanoutalo negelitiya, “Diyala, me dubu Ya꞉suko da꞉ Da꞉ibidikono a꞉la꞉mu Kelisotela꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Wiyasiya Pa꞉lisi tanebapiate ibino tabo olowite negeliya, “Ao, ebete kubakuba uliyanano Kawodawa Biyesibulukono elawamo alibolenako, Godokono elawamoa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ebema꞉ Ya꞉sute ibino kuba woki iyatawate iba꞉tamo negiya, “Numa꞉la꞉, kapiya duliyomolono epate tetedo dadikanalema꞉na꞉ ebe duliyomolote ka꞉kubamene, ega꞉walo kapiya motono epate tetedo dadikanalema꞉na꞉ ebe moto epate a꞉kilukulinama꞉na꞉, ibino motote atumu ka꞉ka꞉kubamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ebema꞉ Saitanakono woki ma kunula, ebete ebeno kubakuba uliyana epagodone akalibola꞉le, mabu ebete eba kunu dowagelemene ebeno woko osiyodilo elawote kolopoligomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","La꞉le naimano tanaloma꞉ negelamata, ‘Ebete kubakuba uliyana Biyesibulukono elawamo alibolenako.’ Ebe tabo degelaema nanitabola꞉ka꞉? Ao, nanitaboa꞉. La꞉imano tanebapiate kubakuba uliyana dalibolenaka, ebe elawo iba꞉tamo potele kikalamenakole? Iyo, Godotela, Saitanatea꞉! Ebema꞉ la꞉imano tanebapino wade osiyodilo tanalote la꞉imano kuba woki awokalimina. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Me tanalo nanitabola, nale kubakuba uliyana Godokono Uliyanano elawamo alibolenakomo, ebema꞉ modobola la꞉ me tanalone kiyatawaomamota, Godokono Kawo Elawodawano tetete la꞉tamo ebe a꞉pe. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Numa꞉la꞉, Saitanako ebe elawodubu idi keba kunula꞉ka꞉ eba kunula, ega꞉walo ebete pilolo duwatiya ebe epo ebe ebeno motono inamabula. Ebema꞉ epate mako elawo dubuno motamo odolote ebeno inamabu uwatema꞉ ubi diyatima꞉na꞉, iba꞉te dopamo ebe ala꞉mo matuomeote ebene ebeno inamabu ebo kuwatema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Nanitabola, kebe lumagite na walubinia꞉no ebete naimano goweladawama꞉ eda꞉na, ma kunu ebete epo kapiya baiamo magaelema꞉ nago woko osiyodiloa꞉no wiyasiya ibi iyaiya alibolenako. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ebema꞉ nale la꞉ analemata, epono iyaiya kuba tanalo bilibilinomo Godote egebolelamete dodolomatili iyatawala, ega꞉walo kebe lumagite Godoko ubia꞉ tabo degemene, ebe kuba tabono tanalo Godote egebolemete ka꞉dodomatimene. Wiyasiya kebe lumagite Godokono Uliyanano osiyodilo tanaloma꞉ kubama꞉ degemene, Godote ebe kuba egebolemete a꞉ka꞉dodomatimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ebema꞉ kebe lumagite Epono Naniwino tanaloma꞉ odiyobo tabo da꞉kiyawaomene, Godote ebeno kuba egeboleme iyatawala, wiyasiya kebe lumagite Godokono Uliyanano woko osiyodilo tanaloma꞉ odiyobo tabo da꞉kiyawaomene, Godote ebe kuba egebolemete a꞉ka꞉dodomatiminamene, uwomua꞉ uwomua꞉ tetelo ebeno kubate bitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ya꞉sute tabo moga꞉melo walo na꞉kegiya, “Naimano da꞉imi keba kunula꞉ka꞉? La꞉le kewa wadenoma꞉ degelawenakoma ebe kewano da꞉imi wadewadenola, wiyasiya la꞉le kewa idi kubanoma꞉ degelawenakoma ebe kewano da꞉imi kubakubanola. Iyo, nanitabola, la꞉ iyaiya kewano da꞉imi ibino ololamo dulama꞉ema la꞉ ebo kiyatawaomamota ibi magumulo kebe da꞉ima꞉te naoma꞉ wadewadenoma꞉ keda꞉onale. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pa꞉lisi tanebapiala꞉, la꞉ bu kalulata! La꞉imano tepo magumu kubakubanomoma꞉ eba eda꞉onalo wade tabo keba kunu na꞉kegelaema? Gaboa꞉nola! Mabu lumagino tepo magumulo kebe tanalate ka꞉pola꞉nale, ebe tanalate ebeno tabo kiyawao tanalodo ka꞉pemaima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ebema꞉ wade lumagite ebeno tepo magumune wadewade tanalo ba꞉powaulatelenakomene, wiyasiya kuba lumagino tepo magumulo kubakuba tanalate pola꞉na, ebema꞉ ebegodone kuba tanalate ba꞉pemaimionakoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Na la꞉tamo negemo, epate ibino iyaiya kuba tabo da꞉kiyawaonaka, ebe kuba tabono tanaloma꞉ iba꞉te Godokono Kawo Egelalo ebeno dopo apuamo ka꞉nemaima꞉na꞉, ebene ebete ibino tanalo bilibilinomo eba anagilamelelamelo iba꞉tamo wiya dikalaemene, ibino taneba magumulo lumagi idite ebe odiyoboma꞉ tabo idi a꞉kegemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ebema꞉ a꞉ma꞉ nanisiwale! A꞉ma꞉le kebe iyaiya tabo ka꞉kiyawawenaka, walone tetelo Godote ebe tabo bilibilinomo eba anagilamelemelo, ebete a꞉ma꞉ tuputupudawama꞉ da꞉begemene o a꞉ma꞉ kubadawama꞉ da꞉beka꞉mitamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ebene Pa꞉lisi tanebapi epetapi ega꞉walo Godokono Totomu iyatulamepi iba꞉te Ya꞉suko naniya, “Iyatulamedawa, a ubila a꞉ma꞉godolo anoano tanalo idi uima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ya꞉sute tabo eba wiyalo iba꞉tamo negiya, “Kuba osiyodilolepi ega꞉walo nanitabokobi midia꞉pi, ibi ubi kawonomola Godokono elawo awokalimino anoano tanalo kuima꞉, wiyasiya Godote tanalo idi akawokalimene. Nanitabola, ebete ebeno woki awokalimidawa Yaonado dawokalimiya, ebe anoano tanalo kapiya la꞉tamo ikalamiyata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Numa꞉la꞉, Yaonate egela netewa-kapiya ega꞉walo idoko netewa-kapiya kawo namono tepo magumulo okoliti, ebema꞉ ebe atu gabodo Epono Naniwite egela netewa-kapiya ega꞉walo idoko netewa-kapiya bobo magumulo ka꞉lutamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ega꞉walo me tanalo idila. Godote epono tanalo danagilamelelaemene, ebe Kawo Egelalo Niniba duliyomolo epate maimiote la꞉ Yu epo kubakubapima꞉ keka꞉la꞉ima꞉ta, mabu ebe Yua꞉ epate Yaonakono tabo dolowiya iba꞉te ibino kubane Godotamo olobiliya. Ebe tetelo ibi ubila Godokono tabo Yaonagodone laema꞉, wiyasiya la꞉ tetelo Godote Epono Naniwino tanalo la꞉tamo eba awokaliminalo, la꞉ ebe tanalo ubia꞉nola. La꞉ numa꞉la꞉, Epono Naniwino elawote Yaonakono elawo nodoliona! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Ega꞉walo Godokono Kawo Egelalo Siba opo epono Kawo Elawo Kamiyalete maigate la꞉ atumu kubakubapima꞉ keka꞉la꞉ima꞉ta, mabu ebe Yua꞉ kamiyalete mulu oponomone piya Isalaela opamo Kawo Elawodubu Solomonokono mulo tabo ka꞉polowioma꞉. Ebe tetelo ebe ubila Godokono mulo Solomonogodone laema꞉, wiyasiya la꞉ tetelo Godote Epono Naniwino tanalo la꞉tamo eba awokaliminalo, la꞉ ebe tanalo ubia꞉nola. La꞉ numa꞉la꞉, Epono Naniwino mulote Solomonokono mulo nodoliona!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ebene Ya꞉sute negiya, “Kuba uliyanate lumagi idigodone da꞉nemaigamene, ebe tetelo ebete gagale opamo tote okoli bai idi kowadinatomene. Wiyasiya ebete wade okoli bai numia꞉no ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ebe a꞉ka꞉tuwa꞉ ebetamo kegemene, ‘Nale datepimo ebe atu okoli baiamo walo ka꞉ka꞉tomamo.’ Ebete walo ka꞉pete ebe okoli motolo idawate okolina꞉no, wadenomamo moda꞉midala ega꞉walo inamabu wadenomamo alomola, ebete ebe moto eba kunu ka꞉ka꞉puimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ebene ebete walo ka꞉tote kubakuba uliyana epetapi sebeni kanadabuilite ka꞉kemagaelemene, iba꞉te ebe motamo podolote ebolo kilukulinama꞉. Numa꞉la꞉, walone da꞉pelaema꞉na꞉ ebe kubakuba uliyanate kawokawo kuba ba꞉posiyodilolenakoma꞉na꞉, dopamo dokolinami ebe kapiya kuba uliyanano okoli eba kunua꞉. O ebe lumagi niyala! Ebe dopamo kela꞉mo kubadopola, wiyasiya me tetelo ebete kubanomoma꞉ eda꞉. Ebema꞉ me teteno kubakuba epala꞉, la꞉ nanisiwale, mabu la꞉ ma kunu kowagelemamota!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ya꞉sute epatamo tabo eba kiyawautalo, ebeno menoko ega꞉walo ekaki iba꞉te pelamete moto niyakabolo pelamota꞉oniya eba꞉go tabo ka꞉pegelama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ebema꞉ epo magumulo idawate Ya꞉suko naniya, “Numa꞉, a꞉imano menoko ega꞉walo ekaki iba꞉te moto niyakabolo ba꞉pelamota꞉ona. Ibi ubila a꞉ma꞉go tabo kegelaema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ya꞉sute ebe lumagitamo nowamiya, “Naimano menoko potelela꞉ka꞉, ega꞉walo naimano ekaki piyatela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ebene Ya꞉sute ebe waloma꞉tapi ebeno kotamo mida꞉lamolelo negiya, “Me epo ebe naimano menokobila ega꞉walo naimano ekakila, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","mabu potele naimano Unu Duliyomolono Nabiwino ubi tanalo dosiyodilomene, ebe lumagi naimano menokola ega꞉walo naimano ekawila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ebe atu egelalo Ya꞉sute moto gune pemaigate, ebete epo iyatulaema꞉ Ga꞉lili Paka꞉ balalo nokoliti, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ebene epo bilibilinomate ebetamo da꞉pelamiya, ebete peamo olote gito okoliya wiyasiya epate damela balalo pelamota꞉oniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ebene ebete iba꞉tamo tanalo epetapi bilibilinomo iyatulame oiamo eba awokalilamelo tabo idi ma kunu giya, “Lumagi idite pali amio bai dosiyodili kono kikopu aminaola꞉go ebo ti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ebete aminaola꞉go eba tonatolo kikopu epetapi iba꞉te gabamo gudiya, ebema꞉ olaolate pelamete ebo penaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kikopu epetapi iba꞉te nokola damelamo gudiya, ebolo damela kawoa꞉. Ebema꞉ iba꞉te samonomamo maimiya mabu damela bidobidoa꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ebene egelate da꞉pioli iba꞉te nalawoiya mabu ibino dolodolo magumamo ka꞉tolamea꞉, iyo, iba꞉te ebema꞉ samonomamo a꞉elaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kikopu epetapi iba꞉te moemoe uwago damelamo gudiya, ebema꞉ ebe uwagate dapepeiya kono ebo anakapulamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Wiyasiya kikopu epetapi iba꞉te wade damelamo gudiya, ebema꞉ iba꞉te apepeote ebo noloiya, epetapi 100 teta꞉mo, epetapi 60 teta꞉mo, epetapi 30 teta꞉mo bilibilinomoma꞉ eda꞉iya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ya꞉sute walo na꞉kegiya, “Galagodawa, a꞉ma꞉ wadenomamo nolowia!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ebe tetelo Ya꞉suko waloma꞉tapiate ebetamo pelamete na꞉pegeliya, “Beda꞉ mabuma꞉ a꞉ma꞉ oiamo epo diyatulama꞉wenaka?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ya꞉sute tabo eba wiyalo iba꞉tamo negiya, “Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalono magumu kelawa꞉ema꞉ nale elawo la꞉tamo ikalaimata, iyo, ebe tanalono waminaole tanalo la꞉ iyatawaimata. Wiyasiya nale ebe iyatawa tanalo epetapiatamo kikalamea꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nanitabola, Godokono tabo olowioma꞉ lumagigodolo wadewade woki da꞉pola꞉na, Godote ebetamo wadewade tanalo bilibilinomo ikameote ebeno tepo magumu ketabokaimene. Wiyasiya lumagigodolo wadewade woki pola꞉na꞉no, ebegodolo kebe kapiyakapiya tanalate da꞉pola꞉na Godote ebegodone walo ka꞉kuwatemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ebe mabuma꞉ nale epo oiamo iyatulamenakomo, mabu iba꞉te naimano tabono magumu wadite kuminakoa꞉, iyo, iba꞉te olowite atumu kiyatawaonakoa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ebema꞉ Godokono woki awokalimidawa Aisayate ibino tanaloma꞉ degiya ebe tabote nanitaboma꞉ eda꞉. Ebete iyalo tetelo ma kunu giya, ‘La꞉ tabo bolowinakomata wiyasiya a꞉kiyatawaoawenakoma, iyo, la꞉ magumu bowadinakomata wiyasiya a꞉kuma꞉wenakoma. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mabu me epono woki alatidiolamiya, ibi nanitabo tanalo olowima꞉ ubia꞉nola, ebema꞉ iba꞉te galo emopioliya, ega꞉walo ibino balidi atumu a꞉mula꞉oliya. Ebema꞉ iba꞉te ibino balidi mula꞉olea꞉noma꞉ neda꞉otaleka꞉, ibino balidite naimano wade tanalo bulamena꞉, ega꞉walo ibino galote nolowiotaleka꞉, iba꞉te ibino tepo magumuno woki wadenomamo malagidilolete natamo bolobila꞉na꞉, ebema꞉ na modobola ibi wadekobi midilima꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ebene Ya꞉sute ebe waloma꞉tapiatamo negiya, “Godokono kalakala kawonomo la꞉godolo bitana, mabu la꞉ la꞉imano balida꞉mo ebeno iyaiya tanalo wadenomamo nulamenamata! Iyo, la꞉le la꞉imano galamo Godokono nanitabo tanalo wadenomamo nolowionamata! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nale la꞉tamo nani tabo gemo, dopamo tetelo Godokono woki awokalimipi ega꞉walo tuputupu ilukuli epo epetapi, iba꞉te ubi kawonomo iyatinamiya la꞉le dulama꞉wenama ebe kawokawo tanalo ulaema꞉, wiyasiya iba꞉te ka꞉modobiya꞉, ega꞉walo ibi ubila la꞉le dolowiawenama ebe tanalo kolowioma꞉, wiyasiya iba꞉te ka꞉modobiya꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ebema꞉ la꞉ kono kikopu aminaola꞉go da꞉ti ebe lumagino oino magumu nolowiala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Godote Kawo Elawodawama꞉ deda꞉na, epate ebe tanalono tabo olowite magumu wadenomamo iyatawaoa꞉no, ebe tetelo Saitanate pete ibino tepo magumune ebe tabo walo ka꞉ka꞉puwatelaemene. Mako epo gabamo da꞉gudi, ibi ebe kono kikopu keba kunula꞉ka꞉ eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ega꞉walo epo epetapiate nokola damelamo da꞉gudi, ibi ebe kikopula. Iba꞉te Godokono tabo dolowima꞉na꞉, ebe tetenomolo kalakalago kelaema꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","wiyasiya ibino tepo magumulo dolodolo puliyala. Ebema꞉ iba꞉te Godokono woko magumulo tete da꞉pesamo ilukula꞉tepate, ebene Godokono taboma꞉ temeteme tanalate iba꞉tamo da꞉pemaimioma꞉na꞉ ega꞉walo epate ibino tanaloma꞉ degelama꞉na꞉, iba꞉te samonomamo kalautioma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Epo epetapi iba꞉te moemoe uwago damelamo da꞉gudi, ibi ebe kikopula. Iba꞉te Godokono tabo kolowima꞉na꞉, wiyasiya iba꞉te inamabu kawonomamo malagidilolena ega꞉walo ibino ilukuli tanaloma꞉ woki bilibilima꞉ eda꞉ona. Ebema꞉ ibino tepo magumulo ebakobako woki bilibilinomo ba꞉pola꞉na, me wokino tanalate wade tabo eba anakapumilo, ebene iba꞉te a꞉ka꞉noloma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Wiyasiya epo epetapi iba꞉te wade damelamo da꞉gudi, ibi ebe kikopula. Iba꞉te Godokono tabo olowite wade iyatawa lawete nanitabonomolo ka꞉noloma꞉na꞉, epetapi 100 teta꞉mo, epetapi 60 teta꞉mo, epetapi 30 teta꞉mo ka꞉noloma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ebene Ya꞉sute oi idi epo eba iyatulamelo na꞉kegiya, “Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalote ebe dubu idite ebeno pali amio bai osiyodilote wade kono kikopu daminaoli eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Idoko idilo epo bilibilinomate delaoniya, eba꞉go gowelaodawama꞉ deda꞉nami ebe dubute penate kuba uwago kikopu pali magumamo pamionate gito toni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Walone tetelo konote apepeote da꞉noloiya, kuba uwagate maimiote konono dolodolo ebo aupulatoliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ebene pali namutudawano wokopiate ebetamo pelamete ebe napaniya, ‘A꞉ma꞉ pali magumamo wadewade kikopu amiata, wiyasiya me kuba uwagate kebene kemaimile?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ebete tabo eba wiyalo negi, ‘Ago gowelaodawa idi, ebete ami.’ “Ebene wokopiate ebe nalatediya, ‘Modobola꞉ka꞉ a ebe kuba uwago kemagobelemalema꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Namutudawate wiyasiya negi, ‘Ao, la꞉le demagobela꞉ema, diyala, la꞉ atu tetelo wadewade kono epetapi da꞉bemagobelema. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ebema꞉ modobola iba꞉te kapimiya napepeoma꞉na꞉, wiyasiya walone nao kono uwate tetelo nale wokopi kanalemamo iba꞉te dopamo kuba uwago magobelete elamo kiyalekema꞉, ebene iba꞉te wadewade nao kono uwatete naimano pali inamabu alomono motamo kapalomoma꞉na꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ebene Ya꞉sute oi idi ibi eba iyatulamelo na꞉kegiya, “Godote Kawo Elawodawama꞉ deda꞉na ebe tanalo mastada kikopu keba kunula꞉ka꞉ eba kunula, iyo, tete idilo dubute me kikopu lawete ebeno pali magumamo gito ami. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nanitabola, me opo kawonomolo kewa kikopu kawokawonomo ba꞉pola꞉na wiyasiya mastada kikopu ebe da꞉pesonomola. Wiyasiya numa꞉la꞉, lumagite daimene ebe da꞉peso kikopute apete kewa bilibilinomo epetapi kodoilimene, ebene olaolate pelamete ebe kewa katomolo ba꞉pilukulionama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ebene Ya꞉sute oi idi ibi eba iyatulamelo na꞉kegiya, “Godote Kawo Elawodawama꞉ deda꞉na ebe tanalo palowa bae gamagamaimino tuwae inamabu keba kunula꞉ka꞉ eba kunula. Kamiyale idite modobo palowa lawete gamagamaimino inamabu kela꞉mo aminalete ebo ewegedi, ebene gamagamaimino inamabute palowa lawenomo eba lawelo palowa baete unamo ebo maigi.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ya꞉sute me tanalo epo bilibilinomatamo iyatulame oiamo kiyawaonaki, ma kunu ebete tanalo idi iba꞉tamo iyatulame oia꞉no ka꞉kiyawaonakia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ebe tanalote emaigiya Godote ebeno woki awokalimidawado degiya, ebe tabote nanitaboma꞉ keda꞉ma꞉. Ebete iyalo tetelo tabo ma kunu giya, “Na Godote epatamo tabo kiyawao tetelo iyatulame oiamo kiyawaonakomo. Iyo, nale me opo dosiyodiliyamo ebe tetene wagilimite me teta꞉mo pemaiga, kebe tanalate waminaole magumulo da꞉pola꞉namiya, na ebe tanalo ma kunu kawokalilaemamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ebene Ya꞉sute epo bilibilinomo miyapate moto guamo gito nodoliya. Ebe tetelo ebe waloma꞉tapiate ebetamo pelamete na꞉pegeliya, “Kono pali magumulo dapepeiya ebe kuba uwagono magumu keba kunula꞉ka꞉? A꞉ma꞉ a niyatuama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ya꞉sute ibino tabo eba wiyalo negiya, “Wade kono kikopu kebe dubute kaminaolile, ebe Epono Naniwila. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ebema꞉ ebeno pali ebe me opo kawonomola, wadewade kono kikopu ibi Godokono Unu Duliyomolono gudila, ega꞉walo kuba uwago ibi Saitanakono gudila. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kuba uwago dami ebe Saitanatela, ega꞉walo nao kono uwate tete ebe me opono uwomula, ega꞉walo nao kono uwatepi ibi Godokono nopopila. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ebema꞉ wokopiate kuba uwago magobelete elamo diyalekiya, me opono uwomu eba kunu kitanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ebe tetelo Epono Naniwite ebeno nopopi kapalibolemene. Ebema꞉ piyate ebeno epago eba ilukulinalo kuba dosiyodilolenaka, nopopiate ibi bilibilinomo puwatete ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","kawonomo elate dowaena ebe baiamo gito ka꞉niyalekema꞉na꞉, ebene iba꞉te ebolo lalo eba oliomolelo kawonomamo ebo kiimima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wiyasiya Godokono tuputupu ilukuli guda꞉godolo ebeno alote kawonomamo ka꞉pukuilaemene, ibino Nabiwino Unu Duliyomololo da꞉pukuilamena eba kunu. Galagodawa, a꞉ma꞉ wadenomamo nolowia!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalo ebe lumagite kawo mani ega꞉walo wadewade inamabu iyalo tetenomolo damelamo dowaminaoliya eba kunula. Walone tetelo ebete ebo a꞉iya, ebene ulama bilibilinomo da꞉petoiya lumagi idite damela obobo woko eba osiyodilolo ebe wadewade inamabu ebo ulamiya. Ebe tetelo ebete kalakalago walo kitiolete, ebene ebeno motamo tote ebeno inamabu bilibilinomo maniamo na꞉midiolete modobo mani ebo nelawiya. Ebene ebe maniamo ebete ebe damela lawete, ebe damela magumulo waminaolelo da꞉pola꞉niya ebe wadewade inamabuate ebenoma꞉ ebo eda꞉iya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ega꞉walo Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalo ebe olowame lumagite wadewade negege inamabu ola꞉go depata꞉na eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Egela idilo ebete kapiya negege wadenomo dumi, ebe tetelo ebeno inamabu bilibilinomo maniamo na꞉midiolete modobo mani nelawete, ebene ebe maniamo ebete ebe wade negege lawete ebenoma꞉ ebo midi.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ega꞉walo Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalo ebe lumagite namo bilibilinomo uwatolema꞉ kamau kolomamo daubi eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ebene namo bilibilinomate detaiya ebe tetelo wokopiate kamau kolomo balamo anamiyamidate wadewade namo bagowamo eba alomolo kubakuba namo gito iyalekiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ebema꞉ me opono uwomu eba kunu kitanamene. Ebe tetelo Godokono nopopiate pelamete kuba osiyodilolepi tuputupu ilukuli epagodone powagailite ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kawonomo elate dowaena ebe baiamo gito ka꞉niyalekema꞉na꞉, ebene iba꞉te ebolo lalo eba oliomolelo kawonomamo ebo kiimima꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ebema꞉ Ya꞉sute ebe waloma꞉tapiatamo negiya, “La꞉ me tanalo bilibilinomo wadenomamo na꞉kiyatawawenama?” Iba꞉te tabo eba wiyalo negeliya, “Iyo, a modobola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ebene Ya꞉sute iba꞉tamo walo na꞉kegiya, “Godokono Totomu iyatulamepi magumulo, potele Godokono Kawo Elawodawa tanalono magumu lawenomo delawi, ebe lumagi kawo moto namutudawa keba kunula꞉ka꞉ eba kunula. Ebe mulo dubuno motolo kawokawo wadewade inamabuate ba꞉pola꞉na, ma kunu tagalatagala inamabu ega꞉walo olioli inamabu kapimiya ba꞉pola꞉mena, ebema꞉ ebete ebeno ubilo ebe iyaiya inamabu epatamo ba꞉powaulatelenakomene ibi wadenomamo kowalubilinama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ebene Ya꞉sute ebe iyatulame oi kiyawao dolopoligiya, ebete ebe duliyomolone tote ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ebeno okoli duliyomolo Nasaleta꞉mo walo na꞉ka꞉tiya. Ebete epono balidi ibilamole motolo ibi eba iyatulamitalo iba꞉te anoanolo negelitiya, “Me dubuno mulo iyatulame woki ebete kebolo kiyatawile? Ega꞉walo ebete anoano tanalo pokono elawamo kosiyodilolenale? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ebe kapeneta dubuno gudula, ebeno menoko ebe Ma꞉litela. A iyatawala ebeno ekaki Ya꞉imesiko, Yausepeko, Saimonoko, ega꞉walo Yudasiko, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","iyo, ebeno ekaki buwelemele bilibilinomate ago bilukulina. Ebema꞉ me dubute ebeno elawo ega꞉walo mulo kebolo kuwatile?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ebene iba꞉te ebe ubia꞉noma꞉ eba eda꞉utalo Ya꞉sute ibi nanaliya, “Godokono woki awokalimidawa epate ebe unamo kadipatema꞉na꞉, wiyasiya ebeno duliyomolo epo ega꞉walo ebeno moto epo iba꞉te ebe ubia꞉noma꞉ beda꞉onakoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ebema꞉ Nasalete epono nanitabokobi midia꞉ mabuma꞉ Ya꞉sute ibino duliyomololo anoano tanalo bilibilinomo kosiyodiloliya꞉, ebete ibino taneba magumulo kapiyakapiyanomo osiyodiloliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ebe tetelo Ga꞉lili opono Kawo Elawodubu Elodite Ya꞉sukono osiyodilole tanalo olowiote, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ebete ebeno opopiatamo negiya, “Me Ya꞉suko ebe Yonete, epo obamo waduba꞉midaoledawala. Ebete a꞉e magumune emaigi, ebema꞉ me anoano tanalate ebegodone pemaiminaka.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Me tanalo ebe Yonete keba kunu ka꞉iyale ebe tanalola. Yonete dopamo eba okolinalo, Elodite ebeno ekawi Pilipikono kamiyale pilolo lawiya, ebe kamiyaleno mailo Elodiyasitela. Me mabuma꞉ Yonete Elodiko kawiya eba analo negiya, “A꞉ma꞉le ebe kamiyale lawe modoboa꞉, kawo kubanomola!” Ebema꞉ Elodite ebeno gowelaopi danaliya, iba꞉te Yoneko nelawete idoko moto guamo gito peba꞉idiliya, mabu ebete ebeno ubi iyatiya ebe osiyodilo tanalodo ebete Elodiyasiko kalakalakobi ka꞉midima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ebe tetelo Elodite ebe anakapuima꞉ ubi niyatiti wiyasiya ebete Yu epo tolelamelo gito atepiya, mabu iba꞉te Yoneko Godokono woki awokalimidawama꞉ gelanakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ebene Elodite dawokaliya, ebe egela malagidilolo ebeno namutupiate eba꞉go soliyomu bae nautiya. Ebe tetelo Elodiyasikono buwelete ibi bilibilinomono ololo apuamo pete eba pemaitalo, Elodite ebetamo kawonomamo kalakaliti, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ebema꞉ ebete buweletamo negiya, “Nale Godokono mailamo gemo, a꞉ma꞉le beda꞉ tanaloma꞉ ubi diyata꞉emene nale a꞉ma꞉tamo nanitabonomolo kikaemamota!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ebene buweleno menokote ebe daniya, ebete Eloditamo ma kunu nowamiya, “Na ubila Yoneko epo obamo waduba꞉midaoledawano wato kikopu kawatago. Ka꞉lonomo natamo nikanama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ebe tetelo Kawo Elawodubu Elodite ebeno tepo magumulo mibomiboma꞉ ediya, wiyasiya ebete dopamo degiya ebe tabo ebete Godokono mailamo giya soliyomu epono ololo apulo. Ebema꞉ ebete ebeno gowelaodawa idi daniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ebe dubute idoko motamo tote Yonekono wato ebo notowamidamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ebene ebete wato kikopu kawatago adaete buweletamo da꞉pikamiya, wiyasiya ebete ebeno menokotamo gito atiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ebe tetelo Yoneko waloma꞉tapiate ebeno apenomo pelawete bobo magumamo gito niyatiya, ebene iba꞉te tolamete ebe tanalo Ya꞉suko ebo naniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ya꞉sute ebe tanalo olowite ebe waloma꞉tapiago pe lawete gito tolamiya, ebete a꞉ka꞉tuwa꞉ diyamoa꞉ opamo ka꞉nemaigama꞉. Wiyasiya epo bilibilinomate ebeno to tanalo dolowiya, iba꞉te ibino iyaiya duliyomolone maimiote Ya꞉suago kanalugoma꞉ damela gaboiya gito tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ebene Ya꞉sute peago da꞉nemaigiya, epo bilibilinomo nulamete ibi kawonomamo na꞉nilakapoilamiya, ebema꞉ ebete damelamo nodolote ibino temetema꞉gopi wadekobi ebo nimidioliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Eba adimonalo ebe waloma꞉tapiate ebetamo pelamenate ebe napananiya, “Me epoa꞉ baila. Tete olopoligo, samamo kidokomene, ebema꞉ a꞉ma꞉ ibi nalibola꞉, iba꞉te iyaiya duliyomolamo tolamolete ibi a꞉ka꞉tuwa꞉ ibino bae ka꞉nuwateoma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ya꞉sute ibi nanaleni, “Ao, iba꞉te tolamea꞉no la꞉le iba꞉tamo nao inamabu dopamo nikalamola꞉la꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iba꞉te nowaiminiya, “Agodolo paibu bae ega꞉walo namo netewa ebenomate pola꞉na.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ya꞉sute iba꞉tamo negeni, “Ebe baela namola natamo nowada꞉la꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ebene ebete epo uwagolo ilukulima꞉ danaleni, ebe tetelo ebete paibu bae ega꞉walo namo netewa uwatenate, Unu Duliyomolamo melelo Godotamo kalakala tabo ebo geni. Ebene ebete ebe bae wakalamiolenate ebe waloma꞉tapiatamo ikalamenate, iba꞉te epo bilibilinomatamo gito ikalamoleniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ebe tetelo ibi bilibilinomate bae denaoniya ibino bae kape tanalo ebo olopoligolameni, ebene Ya꞉suko waloma꞉tapiate da꞉luiliniya ebe bae apuapuamo 12 bagowo ebe owiyaoleniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nanitabola, ebe bae 5,000 dubate naoniya ibino kamiyale guda꞉go. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ebene ebe tetenomolo Ya꞉sute epo eba alibolenalo ebe waloma꞉tapiatamo negeni, “Pe lawa꞉wete Ga꞉lili Paka꞉ apuamo na꞉na꞉iwala꞉la꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ebene ebete epo bilibilinomo alibolenate ebete damela unamo gito nodoloni Godago tabo ka꞉negelanama꞉. Ebene didokoni Ya꞉sute a꞉ka꞉tuwa꞉ ebolo okolini. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ebe tetelo waloma꞉tapiate peago paka꞉ tulituli tetenomodo eba tolamenalo, ulate pe apuamo obiyamidanaki, apuamo obiyamidanaki, eba kunu wageleni mabu awate ibi nodiyoboleni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ebema꞉ idoko tetelo egela walo tatalima꞉ eba eda꞉nalo, Ya꞉sute obo unudo iba꞉tamo ebo toni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wiyasiya ebete obo unudo eba tonatolo, iba꞉te ebe uminate eba toletoleonalo negelaniya, “Obolote pe!” ebema꞉ iba꞉te tole kawonomago ebo gelatepaoniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ebe tetenomolo Ya꞉sute ibi nanaleni, “Na Ya꞉sutela, la꞉ ka꞉toletoleonala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ebene Pitate wiyasiya ebetamo negeni, “Kawodawa, a꞉ma꞉lela꞉ka꞉? A꞉ma꞉ na nanana꞉, nale obo unudo a꞉ma꞉tamo ka꞉pema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ya꞉sute ebeno tabo eba wiyanalo negeni, “Na꞉pa꞉!” ebene Pitate pe atepanate obamo a꞉putinate obo unudo ebetamo ebo toni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wiyasiya ebete kawo awano ulo ulamenate ebo toletoleni, ebene ebete obamo eba ololunalo Ya꞉sutamo kawonomamo negeni, “Kawodawa, a꞉ma꞉ naimano igilo na꞉mula꞉nama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ebe tetenomolo Ya꞉sute koto uwamidanate Pitako lawenate nanani, “A꞉imano nanitabokobi midi tanalo kawoa꞉, da꞉pesola. Mabu keleka꞉ a꞉ma꞉le woki netewama꞉ deda꞉wa꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ebene iba꞉te walo peamo da꞉koloniya awate ebo olopoligoni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ebe tetelo Ya꞉suko waloma꞉tapiate ebe eba amamatenalo negelaniya, “Nanitabola, a꞉ma꞉ Godokono Gudulata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ebene iba꞉te duiya tetelo paka꞉ apuamo na꞉iwalete Genasalete opamo gito nemaimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ebe tetelo epate Ya꞉sukono tanalo iyatawaote ebe opono duliyomolo bilibilinomamo tabo nanalibiya, iba꞉te temetema꞉gopi ebetamo kemagaelema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ebema꞉ Ya꞉sute ebolo eba nokolinalo, temetema꞉gopiate da꞉pelamenakiya ebe na꞉petoweomenakiya iba꞉te ebeno kaliku kologioma꞉, ebene piyate ebeno kaliku dologionakiya iba꞉te wadekobi ebo olowionakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ebe tetelo Pa꞉lisi tanebapi ega꞉walo Godokono Totomu iyatulamepi, ibi epetapiate Yelusalema kawo duliyomolone pelamete Ya꞉sutamo na꞉pegeliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mabu keleka꞉ a꞉ma꞉ waloma꞉tapiate aimano ewoniate diyatulamenakiya ebe totomu tabo dowakalaminaka? Numa꞉, iba꞉te koto ukulaolea꞉no bae ebo naonaka!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ya꞉sute wiyasiya iba꞉tamo negiya, “La꞉ beda꞉ mabuma꞉ ewoniate degelanakiya ebe totomu tabo eba malagidilolenalo, wiyasiya Godokono Totomu Tabo ebe wakalaminamata? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Numa꞉la꞉, Godote ebeno Bukalo negiya, ‘La꞉imano menokobila nabila nowalubila꞉la꞉,’ ega꞉walo ebete na꞉kegiya, ‘Kebe lumagite ebeno menoko o nabiwino tanaloma꞉ kuba tabo da꞉kiyawaomene, la꞉le ebe nanakapumiyala꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wiyasiya la꞉ me Godokono tabo iyabaiamo alomawete negelanamata, ‘Lumagigodolo da꞉pola꞉na menokola nabiwila walubilima꞉, ebete iba꞉tamo ikalaema꞉ ubia꞉noma꞉ deda꞉mene, kuba꞉nola. Ebete gito kegemene, ‘Me inamabu talenala, nale Godotamo ikameote me inamabuamo naimano menokola nabiwila a꞉kowalubilimo.’ ’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ma kunu la꞉ magumulo kuba woki lumagite ebeno nabiwi kowalubinakoa꞉, mabu la꞉ Godokono nani tabo iyabaiamo alomolo wiyasiya la꞉imano ewoniate degelanakiya la꞉ ebe iyaiya tanalo kapiya osiyodilolenakomata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","La꞉ mena netewa epolata! Godokono woki awokalimidawa Aisayate la꞉imano tanaloma꞉ dopamo nanitabonomolo ma kunu egiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Me epate na tabamo amamanatenena, wiyasiya ibino tepo magumuno woki na niyakabolo kapola꞉na꞉, mulunomolo ba꞉na꞉pola꞉na. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iba꞉te naimano mailo unamo nadipatena, wiyasiya nanitabo tanalo puliyala, iyo, iba꞉te me opo epono totomu Godokono Totomunomoma꞉ midilite ebo iyatulamenaka.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ebene Ya꞉sute epo bilibilinomo ebetamo ka꞉la꞉mite iba꞉tamo negiya, “La꞉ me tabo olowiawete la꞉imano woki wadenomamo na꞉tuputupuilama꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nao inamabute lumagino tepo magumamo dopegamene ebe inamabute ebe a꞉ka꞉kubaimene, wiyasiya lumagino tabone da꞉pemaima꞉na꞉ ebe tanalate ebe ka꞉kubaima꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ebene Ya꞉suko waloma꞉tapiate ebetamo pelamete na꞉pegeliya, “A꞉ma꞉ iyatawala꞉ka꞉, Pa꞉lisi tanebapiate a꞉ma꞉le degeawa꞉ ebe taboma꞉ na꞉dowa?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ya꞉sute wiyasiya negiya, “Naimano Nabiwite Unu Duliyomololo dokolina, ebeno pali magumamo epate a꞉ka꞉tuwa꞉ ibino elawamo damionaka, ebe kewa bilibilinomo ebete dolodolago ka꞉pemagobelemene, wiyasiya ebete a꞉ka꞉tuwa꞉ kebe kewa kamionale, ebe kewanomate belamota꞉onama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ebema꞉ la꞉le Pa꞉lisi tanebapino tabo ako-olowiala꞉, na꞉miyapiyala꞉ mabu ibi balidi tamiopila, iba꞉te epo kubanu iyatulamenaka. Numa꞉la꞉, balidi tamio dubute balidi tamio dubu idi gabodo demagatamene iba꞉te damela gugamo kapimiya ka꞉na꞉gudima꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ebene Pitate ebe naniya, “A꞉ma꞉ me tanalono magumu a niyatuama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ya꞉sute tabo eba wiyalo negiya, “Epetapiate woki wadenomamo ka꞉tuputupuilamena꞉, la꞉ atumu. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","La꞉ iyatawala꞉ka꞉? Nao inamabute lumagi magumamo opegate wapuamo tote ebene neago ka꞉penemaigamene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","wiyasiya lumagite ebeno tabamo da꞉kiyawaomene, ebe tabo ebeno tepo magumuno woki mabune ka꞉pemaimioma꞉na꞉, ebe iyaiya tabote ebe ebo ka꞉kubaima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Numa꞉la꞉, lumagino tepo magumune wiyasiya kuba wokino tanalate pemaiminaka, ebene ebe kuba wokine me kawokawo kubate ka꞉pemaiminaka — lumagi anakapumi tanalo ega꞉walo inamabu pilo tanalo, buwele pilo tanalo ega꞉walo lumagi idino kamiyale pilo tanalo, a꞉da꞉ tabo kiyawao tanalo ega꞉walo lumagi idino mailo kubaimi tanalo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iyo, nanitabola! Me kubate pemaimite lumagi ebo ka꞉kubaima꞉na꞉, wiyasiya lumagite koto ukulalea꞉no bae denamene ebe tanalote ebeno woki mabu a꞉ka꞉kubaimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ebene Ya꞉sute ebe opo atepate Taya ega꞉walo Saidono kawokawo duliyomolono opamo gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ebe Ka꞉inane opolo dokolinami, kamiyale idi ebe Yua꞉ lumagila, ebete Ya꞉sutamo geatepago pete na꞉pegiya, “Da꞉ibidikono A꞉la꞉mu, na na꞉nilakapoinama꞉! Naimano gudu buwele kuba uliyanagonola, ebema꞉ ebete kawo temeteme iyatawana!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Wiyasiya Ya꞉sute ebe kamiyaleno tabo ka꞉wiya꞉, ebema꞉ ebe waloma꞉tapiate ebetamo pelamete na꞉pegeliya, “A꞉ma꞉ me kamiyale iyabaiamo naliba, mabu ebe ago depaita gowela kawonomo osiyodiluta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ebema꞉ Ya꞉sute ibino tabo eba wiyalo negiya, “Isalaela epo magumulo dalatidioliya, Godote na ebe sipi-goeogoeo kapiya olema꞉ paliboniya, iyaiya opo epatamoa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ebene ebe Yua꞉ kamiyalete ebeno tabo olowite ebetamo walo ka꞉pete ebeno agowa mabuamo pa꞉tuduwatalo na꞉pegiya “Kawodawa, a꞉ma꞉ na nowalubina꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ebema꞉ Ya꞉sute ebeno tabo eba wiyalo negiya, “Mabu keleka꞉ nale a꞉ma꞉ owalubima꞉ degeawita? Modoboa꞉ epate gudino bae epetapiatamo gito ikalaema꞉, mabu ebe osiyodilo tanalo ebe gaagaatamo ikalame tanalo keba kunula꞉ka꞉ eba kunula.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kamiyalete Ya꞉sutamo negiya, “Iyo, a꞉ma꞉le degeawa꞉ nanitabola, wiyasiya kawo dubu idino bae nao patapatane opamo da꞉penigudinaka, ebe bae apuapu gaagaate nao modobola!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ebene Ya꞉sute ebetamo negiya, “Kamiyale, a꞉ma꞉godolo nanitabokobi midi tanalo kawonomo bitana, ebema꞉ a꞉ma꞉le ubi diyata꞉wita, na ebe tanalo nanitabolo kosiyodilomamo.” Nanitabola, ebe tetenomolo ebe kamiyaleno buwelete wadekobi ebo olowiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ebene Ya꞉sute ebe opo atepate Ga꞉lili Paka꞉ balado petote damela unamo nodolote gito nokoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ebe tetelo epo bilibilinomate Ya꞉sutamo eba pelamelo iba꞉te ibino temetema꞉gopi ebetamo ebo magaeliya, ma kunu iba꞉te agowa kubakubapi, balidi tamiopi, tabo kiyawaoa꞉pi, ega꞉walo iyaiya gabugabuagopi epetapi bilibilinomo Ya꞉sutamo magaelete ebeno agowa mabuamo da꞉powadilatoliya, ebete ibi wadekobi ebo midioliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ebene epate kawonomamo anoanoiya mabu iba꞉te ibino balida꞉mo me iyaiya tanalo ulamiya, tabo kiyawaoa꞉piate tabo a꞉kiyawaiya, agowa kubakubapiate owapata꞉lamiya, ega꞉walo balidi tamiopiate balidi a꞉meleiya. Ebema꞉ ebe tetelo Godote Isalaela epo dowalubilinako, iba꞉te ebeno mailo unamo ebo adipatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ebene Ya꞉sute ebe waloma꞉tapi ebetamo ka꞉la꞉mite ibi nanaliya, “Na me epo na꞉nilakapoilamitamo, mabu iba꞉te nago netewa-kapiya egela dilukulinatiya ibino bae olopoligolami. Na ubia꞉nola ibi baea꞉no ibino iyaiya duliyomolamo gito alibolema꞉. Diyala, iba꞉te gabo tetelo elawoa꞉noma꞉ da꞉ba꞉neda꞉oma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ebe waloma꞉tapiate ebetamo negeliya, “Me baea꞉ opola. Ale me epo bilibilinomatamo bae ikalamole modoboa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ebene Ya꞉sute ibi nalateda꞉liya, “La꞉godolo kebalata baete ka꞉pola꞉nale?” Iba꞉te negeliya, “Sebeni bae ega꞉walo namo egege kapiyakapiyate pola꞉na.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ebene Ya꞉sute epo opamo ilukulima꞉ danaliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ebe tetelo ebete ebe sebeni bae apuapu ega꞉walo namo uwatete Godotamo kalakala tabo ebo giya, ebene ebete wakalamiolete ebe waloma꞉tapiatamo gito ikalamiya iba꞉te epatamo kikalamolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Ebe tetelo piyate ebe bae denaiya ibino bae kape tanalo gito olopoligolamiya. Nanitabola, ebe bae 4,000 dubate naiya ibino kamiyale guda꞉go, ebene da꞉luiliya ebe bae apuapuamo Ya꞉suko waloma꞉tapiate sebeni bagowo ebe owiyaoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ebene Ya꞉sute ebe epo ibino iyaiya duliyomolamo daliboliya, ebe tetelo ebete peamo olote Magadana opamo gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ebene Pa꞉lisi tanebapi epetapi ega꞉walo Sa꞉diyusi tanebapi iba꞉te ubi iyatiya Ya꞉sutamo pelamete ebe kuba gabamo ka꞉powabuga꞉tama꞉. Iba꞉te ebe ma kunu paniya, “A꞉ma꞉godolo Godokono elawo ditana, ebe tanalo awokalima꞉ anoano tanalo idi atamo nosiyodila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ya꞉sute tabo eba wiyalo iba꞉tamo negiya, “Egelate eba niwisigalo egela unu kalimakalimama꞉ da꞉neda꞉mene, la꞉ ebe tanalo uma꞉wete kegelamamota, ‘Dumutu egela wadenomamo ka꞉powalomene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ega꞉walo tete idilo egelate eba waloutalo la꞉ ulama bubu dulama꞉ema la꞉ kegelamamota, ‘Me egelate ka꞉kubamene.’ Iyo, la꞉ tobolo ununo iyaiya tanalo ulamole iyatawalata, wiyasiya me tetelo Godote la꞉ magumulo dosiyodilolena ebe iyaiya tanalono magumu la꞉ wadenomamo kiyatawawena꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kuba osiyodilolepi ega꞉walo nanitabokobi midia꞉pi, ibi ubi kawonomola Godokono elawo awokalimino anoano tanalo kuima꞉, wiyasiya Godote tanalo idi iba꞉tamo akawokalimene. Nanitabola, ebete Yaonado dawokalimiya ebe anoano tanalo kapiya la꞉tamo ikalamiyata.” Ebe tetelo Ya꞉sute ibi miyapate gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ebene Ya꞉sute ebe waloma꞉tapiago Ga꞉lili Paka꞉ apuamo da꞉na꞉iwaliya, ebe tetelo iba꞉te bae uwate tanalo na꞉dodomatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ya꞉sute iba꞉tamo negiya, “La꞉ wadenomamo nolowiala꞉. Palowa baete a꞉ka꞉tuwa꞉ unamo demaiga, Pa꞉lisi tanebapi ega꞉walo Sa꞉diyusi tanebapi ibino amama tanalo eba kunula. Eiye, mako tanalote la꞉tamo akopemaigala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ebema꞉ iba꞉te ibino taneba magumulo tabo ma kunu geliya, “Ebete atamo me tabo nege mabu ale bae kowadaea꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Wiyasiya iba꞉te tabo degelitiya Ya꞉sute iyatawate negiya, “La꞉imano nanitabokobi midi tanalo kawokawoa꞉. La꞉le baea꞉no pola꞉na tabo beda꞉ma꞉ kegelawitama? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Keleka꞉ mabu la꞉le naimano nanitabo tanalo wadenomamo kuma꞉wena꞉? Nale adimo idilo paibu bae 5,000 dubatamo dowakalamiolelamenimo, me tanaloma꞉ la꞉godolo woki ba꞉kitanale? Ebe tetelo la꞉ kebalata bagowo kowiyaola꞉wenima? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ega꞉walo egela idilo nale sebeni bae 4,000 dubatamo da꞉kowakalamiolelaimo, ebe tetelo la꞉ kebalata bagowo kowiyaola꞉ima? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","La꞉ beda꞉ mabuma꞉ naimano tanalo wadenomamo kemalagidilawena꞉? Nale la꞉imano bae nao tanaloma꞉ kegea꞉. La꞉ nanisiwale, Pa꞉lisi tanebapi ega꞉walo Sa꞉diyusi tanebapi ibino amama tanalote la꞉tamo akopemaigala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ebene Ya꞉suko waloma꞉tapiate ebeno tabo magumu wadenomamo ma kunu lawiya, Ya꞉sute palowa bae unamo maiga tabo danaliya, ebete Pa꞉lisi tanebapino amama iyatulame tanaloma꞉ giya. Ebe ubia꞉nola ebe kubate ebe waloma꞉tapiatamo pemaigama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ebene Ya꞉sute Sisaliya-Pilipai opamo da꞉nemaigiya ebete ebeno waloma꞉tapi ebo nalateda꞉liya, “Na Epono Naniwi iba꞉te poma꞉ kegelanake?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Iba꞉te negeliya, “Epetapiate a꞉ma꞉ Yoneko obamo waduba꞉midaoledawama꞉ gelanaka, epetapiate a꞉ma꞉ Elayama꞉ gelanaka, epetapiate a꞉ma꞉ Yelemayama꞉ gelanaka, ega꞉walo epetapiate a꞉ma꞉ Godokono woki awokalimidawa idima꞉ gelanaka.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ebene Ya꞉sute ibi nalateda꞉liya, “Wiyasiya la꞉le na poma꞉ ka꞉midina꞉wenama?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimono Pitate tabo eba wiyalo negiya, “A꞉ma꞉ Kelisotela, iyo, a꞉ma꞉ Igilo Godono Gudulata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ebene Ya꞉sute ebetamo nowamiya, “Saimono, Yonekono gudu, a꞉ma꞉ kawonomamo nekalakala! Mabu me tabo lumagi idite a꞉ma꞉ kiyatumita꞉, a꞉ma꞉ naimano Unu Duliyomolono Nabiwite iyatumiata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na a꞉ma꞉tamo ma kunu gemo, ‘A꞉ma꞉ Pitate, naimano nokolalata. Nanitabola, nale me nokola unamo naimano sosi ketemamo, ebema꞉ Saitanakono a꞉e tanalote ebe sosi kubaimima꞉ a꞉ka꞉modobomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Numa꞉, nale Kawo Elawodawa Godokono iyaiya ki a꞉ma꞉tamo kikameomamota. Ebema꞉ a꞉ma꞉le Saitanako kodiyobaema꞉ me opolo kebe gigiyu me kiamo demopiaemene, Godokono Unu Duliyomololo atu mopi tanalote ka꞉nitanamene, ega꞉walo a꞉ma꞉le lumagino igilo ka꞉mula꞉ma꞉ema꞉ me opolo kebe gigiyu me kiamo da꞉iyamidaemene, Unu Duliyomololo atu a꞉iyamida tanalote ka꞉nitanamene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ebene Ya꞉sute ebeno waloma꞉tapi kawonomamo ma kunu analiya, “Nale Kelisoma꞉ nanitabolo deda꞉namo, la꞉le me tanalo epetapi akokiyawaolama꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ebe tetelo Ya꞉sute ebe waloma꞉tapi iyatulame ma kunu wagilimiya, “Nale Yelusalema kawo duliyomolamo tote epagodone kawokawo temeteme ebo ka꞉nuwatemamo, Godokono ubila. Ebene Godotamo kalimagono ikameopino watowatopi, ega꞉walo Godokono Totomu iyatulamepi, ega꞉walo kawokawo dubu epetapi iba꞉te na kanakapunaema꞉na꞉, wiyasiya netewa-kapiya egelalo Godote na a꞉ene kadipanatenemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ebene Pitate Ya꞉suko waloma꞉tapi epetapiagodone kela꞉mo magatate ebe kawiya ma kunu naniya, “Kawodawa, me kubate a꞉ma꞉tamo akopemaigala꞉, modobola Godote nodiyobamene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ebene Ya꞉sute olobigate Pitatamo negiya, “Pita, a꞉ma꞉ Saitanako keba kunula꞉ka꞉ eba kunula! Na natepana꞉! A꞉ma꞉le naimano agowa ukamidadawama꞉ editata mabu a꞉imano woki Godotamo kiyata꞉wita꞉, a꞉ma꞉ epono wokilo okolinata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ebe tetelo Ya꞉sute ebe waloma꞉tapi nanaliya, “Kebe lumagite na waloma꞉enema꞉ ubi diyatimene, dopamo ebete ebeno tanalo dodolomatilite ebeno kewa olotolowa agute na ebo nowaloma꞉enemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nanitabola, kebe lumagite ebeno igilo nagodone damoeda꞉mene ebeno igilote kalatidimene, wiyasiya kebe lumagite ebeno igilo na mabuma꞉ datutimene ebete nanitabo igilo ebo ka꞉nuimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ebema꞉ lumagite opono inamabu bilibilinomo uwatenomo eba uwatelo, ebeno igilo datutimene ebe lumagino wiya keleka꞉? Ebete ebeno igilo walo ka꞉kelaema꞉ beda꞉ inamabu na꞉kikaemene? Gabo puliyala, kitana꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nanitabola, Epono Naniwite ebeno wade-talena nopopiago ega꞉walo Nabiwi Godokono elawo alonomago ka꞉pemene. Ebe tetelo ebete epono tanalo eba anagilamelelamelo ibino modobo woko wiya nanitabolo kikalaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na la꞉tamo nani tabo gemo, me tetelo dilukuliona ibi epetapiate Epono Naniwi ebeno Kawo Elawodawano elawago da꞉pemene, ebe kawo tanalo dopamo umite walone ebo ka꞉elaoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ebene sikisi egela dolopoligiya Ya꞉sute Pitako, Ya꞉imesiko, ega꞉walo ebeno ekawi Yoneko, ibinomo magataliya damela ununomo ida꞉mo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ebe tetelo ebe waloma꞉tapino dopo apulo Ya꞉sukono apete iyama꞉ ediya, ebene ebeno ololote egelano pukuilame keba kunula꞉ka꞉ ebakonoma꞉ eba eda꞉lo, ebeno pupuliono inamabuate atumu keyakeyanomoma꞉ eda꞉omiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ebene waloma꞉tapino ololo apuamo Moseseko ega꞉walo Elayako iba꞉te pemaimite Ya꞉suago tabo ebo gelitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ebe tetelo Pitate Ya꞉sutamo negiya, “Kawodawa, ale malo da꞉pola꞉nama꞉, kalakala kawonomola. A꞉ma꞉ ubi diyata꞉emene, nale nupunupu netewa-kapiya ketemotemamo, idi a꞉imanola, idi Mosesekonola, idi Elayakonola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pitate ebe tabo eba kiyawautalo, ebe tetenomolo pukuilame tema iyanomote pete ibi gito panalopamidaliya, ebene tema magumune tabote ma kunu piya, “Me naimano kapiya Gudunomola, na ebetamo nekalakalitamo. La꞉ ebeno tabo nolowiala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ebene Ya꞉suko waloma꞉tapiate ebe tabo olowite kawonomamo eba toletoleolo opamo ebo gudiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","wiyasiya Ya꞉sute pete ibi eba pologiolelo na꞉pegiya, “Nemaimiala꞉, akotoletoleala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ebe tetelo iba꞉te balidi da꞉meleiya lumagi idi kumiya꞉, Ya꞉suko kapiyate ebolo utiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Iba꞉te unu damelane eba piwitiolo Ya꞉sute ibi napanaliya, “La꞉le kebe anoano tanalo kuma꞉ema, ebe tanalo me tetelo epetapi akoanala꞉la꞉, wiyasiya Godote na Epono Naniwi a꞉ene walo dakadipanatenemene epo ebo kanalemamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ebene Ya꞉suko waloma꞉tapiate ebe nalatediya, “Mabu keleka꞉ Godokono Totomu iyatulamepiate degelanaka, Elayate dopamo pete, ebeno walogabo apune Kelisote ka꞉pemene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ebete tabo eba wiyalo negiya, “Nanitabola, Elayako dopamo pete tanalo bilibilinomo ka꞉pa꞉tuputupuilaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Na la꞉tamo negemo, Elayako epatamo iyalo a꞉pi wiyasiya iba꞉te ebeno tanalo kiyatawaoa꞉, ebene iba꞉te ibino ubilo kawokawo kuba ebetamo osiyodilolenakiya. Ebema꞉ la꞉ niyatawala꞉, Epono Naniwite atumu iba꞉godone kawokawo temeteme nanitabolo kuwatemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ebene ebe waloma꞉tapiate ebe tabono magumu wadenomamo ma kunu lawiya, Ya꞉sute Yoneko obamo waduba꞉midaoledawano tanaloma꞉ ge. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ebe tetelo iba꞉te epo epetapiatamo da꞉pemaimiya, dubu idite Ya꞉sutamo pete pupamo pokolite ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na꞉pegiya, “Kawodawa, a꞉ma꞉ naimano koi na꞉nilakapoima꞉! Mabu ebe ea꞉ tanalote lawenako, ebema꞉ tete epetapilo ebe elamo bega, obamo bega, eba kunu wagelena. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nale ebe a꞉ma꞉ waloma꞉tapiatamo demagaeakamo, wiyasiya iba꞉godolo elawo puliyala ebe wadekobi ka꞉midima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ya꞉sute wiyasiya iba꞉tamo negiya, “Eiye, la꞉ nanitabokobi midia꞉ kubakuba epolata! La꞉le natamo mibo ikanamenamata, ebema꞉ na ubia꞉nola tete geyageyalo la꞉go okolinama꞉! La꞉ koi natamo nemaga꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ebene Ya꞉sute kuba uliyana kawiya daniya ebete koi magumune gito nemaigiya, ebe tetenomolo koite wadekobi ebo olowiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ebene epo epetapino pola꞉na꞉ tetelo Ya꞉suko waloma꞉tapiate ebetamo pelamete na꞉pegeliya, “Mabu keleka꞉ ale kuba uliyana aliboma꞉ ka꞉modobaka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ebete iba꞉tamo negiya, “Ebe mabu ma kunu bitana, la꞉imano nanitabokobi midi tanalote depesoma꞉ eda꞉ona. Na la꞉tamo nani tabo gemo, mastada kikopu kawoa꞉, da꞉pesonomola. Wiyasiya la꞉imano nanitabokobi midi tanalote makonoma꞉ deda꞉mene, la꞉imano elawote modoboma꞉ eba eda꞉lo me damelatamo kegelamamota, ‘A꞉ma꞉ mene ebamo na꞉toatepa!’ ebene damelate la꞉imano tabamo ka꞉tuduwatamene. Me tabo nanitabola, la꞉godolo nanitabokobi midi tanalo eba itanalo osiyodiloa꞉ tanalo idite a꞉kitanamene, iyo, kodakoda tanalote modobonomoma꞉ keda꞉mene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ebema꞉ la꞉le la꞉imano ilukuli magumulo tete epetapilo bae naoa꞉no eba pola꞉nalo Godago tabo degelawenakoma, la꞉le elawo ebo kelaemamota mako kuba uliyana aliboma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tete idilo Ya꞉suko waloma꞉tapiate Ga꞉lili opolo kapiyama꞉ walo da꞉kediya, ebete iba꞉tamo negiya, “Godote Epono Naniwi kubakuba epono kotamo kiyatimene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ebene iba꞉te ebe kanakapuima꞉na꞉, wiyasiya netewa-kapiya egelalo Godote ebe a꞉ene walo kakadipatemene.” Ebema꞉ Ya꞉suko waloma꞉tapiate ebeno tabo olowite tepo temeteme kawonomo ebo lawiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ya꞉suko waloma꞉tapiate Kapeniyama duliyomolamo da꞉pelamiya, ebe tetelo dubu epetapiate Pitatamo pemaimiya Godoko Amamateno Iya Motono ka꞉pita꞉isin wiya uwatema꞉. Iba꞉te tabo ma kunu pegeliya, “La꞉imano iyatulamedawate Godokono Motono ta꞉kese mani a꞉kiyatinakole?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pitate negiya, “Iyo, iyatinako.” Ebene Pitate motamo da꞉nodoliya ebete tabo gea꞉no dopamo Ya꞉sute ebe naniya, “Saimono, a꞉imano woki keba kunula꞉ka꞉? Me opono kawokawo elawodubatamo ta꞉kese mani piyate kalomonake? Atu opo epatela꞉ka꞉ o kapela epatela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pitate ebeno tabo eba wiyalo negiya, “Kapela epate a꞉ka꞉tuwa꞉ alomonaka.” Ya꞉sute negiya, “Iyo, nanitabola, atu opo epate gabamaniatamo ta꞉kese mani kalomona꞉. Numa꞉la꞉, a Yu epo me Isalaela opono gudila, ebema꞉ mabu keleka꞉ ale Godokono Motono wokopiatamo ka꞉pita꞉isin mani dikalamenakoma꞉? Mabu kitana꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wiyasiya na iba꞉tamo temeteme ikalaema꞉ ubia꞉nola, ebema꞉ a꞉ma꞉ Ga꞉lili Paka꞉mo toawete tudi nanawotalama꞉. Dopamo dapalimene ebe namo lawa꞉wete ebeno tabo a꞉na꞉ma꞉midama꞉wete kapiya siliba mani ebo numiye, ebene a꞉ma꞉ ebe mani lawa꞉wete Godokono Motono wokopiatamo na꞉nikalamiye, a꞉imano ega꞉walo naimano ka꞉pita꞉isin wiya tanaloma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ebe tetelo Ya꞉suko waloma꞉tapiate pelamete ebe napaniya, “Godote Kawo Elawodawama꞉ deda꞉na, ebe duliyomololo kawodawama꞉ potele na꞉keda꞉mene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ebene ebete gudu da꞉peso ebetamo ka꞉mite ibino tetenomamo adipite ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","negiya, “Na la꞉tamo nani tabo gemo, la꞉le la꞉imano amama woki iyakobi midila꞉wete gudi egege keba kunula꞉ka꞉ ebakonoma꞉ neda꞉iyala꞉, mabu la꞉ eba kunu wagelea꞉no Godokono Kawo Elawodawano duliyomolamo a꞉ka꞉nopila꞉oaema. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nanitabola, kebe lumagite mako gudu da꞉pesomu ebe a꞉ka꞉tuwa꞉ ebe opamo diyatimene, ebete Godokono Kawo Elawodawano duliyomololo kawodawama꞉ ka꞉neda꞉mene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ega꞉walo kebe lumagite naimano mailamo mako gudu da꞉peso kalakalago dowalubina ebete na atumu na꞉kowalubinina.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ebene Ya꞉sute walo na꞉kegiya, “Ebema꞉ da꞉peso gudute na nanitabokobi eba midininalo, kebe lumagite ebe kuba gabamo dowabuga꞉tana, modobola epate ebe lawete ebeno kuwokoba꞉mo kawo nokolanomo ma꞉midaomete kewa꞉ kolomamo neba꞉idiloma꞉na꞉ ebete kulukulu obamo kololuma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","La꞉ nolowiala꞉, me opote kubanomo ka꞉kubamene! Nanitabola, Saitanakono kuba gabamo wabuga꞉ta tanalate epatamo kemaimioma꞉na꞉, wiyasiya kebe lumagigodone mako kuba tanalote demaigamene, Godote ebetamo kuba wiya kawonomo kikaemene! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ega꞉walo a꞉imano kotote o agowate a꞉ma꞉ kuba gabamo dowabuga꞉tatana, modobola a꞉ma꞉ itamidawete iyabaiamo neba꞉idila! Modobola a꞉ma꞉le kapiya kotago o kapiya agowago Godokono Igilo Duliyomolamo nopegama꞉, kubala koto netewago ega꞉walo agowa netewago Godote a꞉ma꞉ Ela Opamo neba꞉idiloma꞉. Nanitabola, ebe duliyomololo elate uwomua꞉ tetelo nowaena. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ega꞉walo a꞉imano balidite a꞉ma꞉ kuba gabamo dowabuga꞉tatana, modobola a꞉ma꞉ magoba꞉wete iyabaiamo neba꞉idila. Modobola a꞉ma꞉le balidi kapiyago Godokono Igilo Duliyomolamo nopegama꞉, kubala balidi netewago Godote a꞉ma꞉ Ela Opamo neba꞉idiloma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ebene Ya꞉sute walo na꞉kegiya, “Nale la꞉tamo negemo, Godote egege gudi kawonomamo eba malagidilolelo ebete ebeno nopopi iba꞉tamo palibolenako ibi ka꞉pa꞉buiyalatelema꞉. Ebema꞉ la꞉ nanisiwale, la꞉ mako gudu da꞉peso ubia꞉noma꞉ eda꞉wete la꞉imano tabamo ebe akokubaima꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ega꞉walo me tanalo idila. Piyate kuba osiyodilole magumulo dalatidiolena, na Epono Naniwite ebe epono igilo mula꞉lelaema꞉ piyamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ebema꞉ la꞉ me tanalo keba kunu na꞉kemalagidilaema? Dubu idi ebeno 100 sipi-goeogoeate da꞉pola꞉mena, ebene kapiyate dalatidimene ebete beda꞉ tanalo na꞉kosiyodilomene? Iyo, ebete 99 sipi-goeogoeo wade uwago opolo miyapate, ebete unuunu damelamo walo ka꞉nodolote dalatidi ebe sipi-goeo ka꞉nowadimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nale la꞉tamo nani tabo gemo, ebe dubuno kalakalate bitana alatidiolea꞉ 99 sipi-goeogoeo epetapiatamo, wiyasiya ebete dalatidi ebe sipi-goeo da꞉nuimene ebeno kalakalate kawonomoma꞉ keda꞉mene. Nanitabola, kalakala beda꞉ kawonomola꞉ka꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ebema꞉ la꞉imano Unu Duliyomolono Nabiwi atumu ubia꞉nola mako gudu da꞉peso kapiyate alatidima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ebene Ya꞉sute walo na꞉kegiya, “A꞉imano naniwite a꞉ma꞉tamo kuba tanalo dosiyodilomene, a꞉ma꞉ diya gabodo towawete ebeno kuba tanalo ebe na꞉niyatuma꞉. Ebene ebete a꞉imano tabo nanitabonomolo dolowimene, modobola a꞉ma꞉ eba꞉go walo namutudawama꞉ na꞉kediyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wiyasiya ebete a꞉imano tabo olowia꞉noma꞉ deda꞉mene, ebe tetelo a꞉ma꞉ walubima꞉ a꞉ma꞉le kapiya o netewa epo epetapi na꞉nuwatiye, ebene la꞉ naniwitamo palo tolama꞉wete atu tabo kawiya dananaema, ebete ebe tetelo la꞉imano tabo nanitaboma꞉ ka꞉midimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wiyasiya ebete la꞉imano tabo olowia꞉noma꞉ walo da꞉keda꞉mene, la꞉le ebeno tanalo sosi epatamo nanawokalimiyala꞉, ebene ebete sosi epo bilibilinomono tabo olowia꞉noma꞉ deda꞉mene, modobola, nitanamene. Ebe tetelo la꞉le ebe nanitabokobi midia꞉dawa keba kunula꞉ka꞉ ega꞉walo mani pilo dubu keba kunula꞉ka꞉ ebako lumagima꞉ mida꞉wete eba꞉go kapiyama꞉ walo akoeda꞉oala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ebene Ya꞉sute walo na꞉kegiya, “Na la꞉tamo nani tabo gemo, la꞉ Saitanakono tanalo kodiyobaema꞉ ebe keba kunu dematuomeaema, ebe matuomeo tanalote Godokono Unu Duliyomololo eba kunu ka꞉nitanamene, ega꞉walo lumagino igilo ka꞉mula꞉ema꞉ la꞉ kebe tanalo me opolo depamiaema, ebe atu tanalote Unu Duliyomololo pami eba kunu ka꞉nitanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ebema꞉ nale la꞉tamo tanalo idi na꞉kegemo, la꞉ nanitabokobi midipi netewate woki kapiyama꞉ eda꞉wete naimano Unu Duliyomolono Nabiwi toweomelo ebete tanalo idi matuomeoma꞉ danaema, nanitabola, ebete la꞉imano tabo olowite eba kunu kosiyodilomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mabu netewa o netewa-kapiya nanitabokobi midipiate woki kapiyago eba pola꞉nalo, iba꞉te naimano mailo deka꞉ima꞉na꞉ nale ebolo iba꞉go nanitabolo ka꞉lutamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ebe tetelo Pitate Ya꞉sutamo pete na꞉pegiya, “Kawodawa, naimano ekawi natamo kuba dosiyodilolenako na ebeno kuba kebako teta꞉mo na꞉ka꞉dodolomatilimo? Sebeni teta꞉mo modobola꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ya꞉sute ebetamo nowamiya, “Na a꞉ma꞉tamo negemo, sebeni teta꞉moa꞉. Ao, modobola a꞉ma꞉le a꞉imano okolina tetelo ma kunu 77 teta꞉mo ebeno kuba egebolema꞉wete na꞉dodolomatiliminakiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ebene ebete tabo moga꞉melo negiya, “La꞉ numa꞉la꞉, Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalo me oino magumu keba kunula꞉ka꞉ eba kunula. Opo idino Kawo Elawodubute ebeno kawokawo mani eba ka꞉la꞉miolelo ebeno woki nitameni ebeno wokopino nanitabokobi midi tanalo ka꞉pulamelelaema꞉. Ebene ebete ebeno woki ma kunu iyatiya, wokopi magumulo piyate ebegodone walubi mani gito duwata꞉digiya ibino tanalo ka꞉tuputupuilaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ebene ebete mani ka꞉la꞉miole dowagilimi, ebe tetelo epetapiate ebetamo dopo wokodawa magaiya, ebe dubute teni taoseni kawokawo mani ebegodone dopamo gito uwata꞉digi. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mabu ebete ebe mani wiyama꞉ ebegodolo gabote kitania꞉, ebema꞉ Kawo Elawodubute ebeno opopiatamo tabo ma kunu gi, ‘La꞉ me dubu, ebeno kamiyale ebeno gudi eba꞉go, ibi bilibilinomo uwata꞉wete maniamo midiola꞉wete kawokawo dubu epetapiatamo nikalama꞉la꞉, iba꞉te ilukulina tetelo ibino wiya꞉ wokopima꞉ keda꞉onama꞉. Na ebe gabodo me dubuno kuba wiya ebetamo kikaemamo.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ebe tetelo wiya꞉ dubute opamo gate ebeno pupamo okolite Kawo Elawodubutamo towetoweolo negi, ‘Iyaiya, a꞉ma꞉ nuta꞉tepa. Na gabo numite ebako kawo wiya nanitabolo ka꞉pa꞉wiyamo!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Kawo Elawodubute wiyasiya ebe nilakapoimilo nani, ‘A꞉imano wiya꞉ tanalo nale egebolemetate a꞉dodolomatilimata. A꞉ma꞉ kalakalago na꞉toa!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Wiyasiya ebe wiya꞉ wokodawate Kawo Elawodubugodone nemaigate eba tolo ebeno namutudawa idi ebo numi, ebe namutudawate ebegodone dopamo 100 mani egege duwati, walo ebetamo ka꞉wia꞉. Ebe tetelo ebete ebe kuwokobene lawete eba adimagotelo nani, ‘A꞉ma꞉ naimano mani natamo samonomamo na꞉wiya!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ebene ebeno namutudawate opamo gate ebetamo towetoweolo negi, ‘Iyaiya, a꞉ma꞉ nuta꞉tepa. Na gabo numite nanitabolo ka꞉pa꞉wiyamo!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Wiyasiya ebete ebeno namutudawa nilakapoimia꞉no idoko motamo gito magati, ebete ebolo eba okolinalo ebeno epate pa꞉wiyate ebe ebo ka꞉powagalima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ebe tetelo wokopi epetapiate ebe tanalo umite tepo temetemema꞉ eba eda꞉olo, iba꞉te tolamete ibino Kawo Elawodubutamo ebe tanalo ebo nawokalimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ebene Kawo Elawodubute ebe wokodawa ka꞉mite kawonomamo eba analo negi, ‘A꞉ma꞉ kuba wokodawanomolata! A꞉ma꞉le ka꞉lo duiyalo na da꞉toweonama꞉wa꞉ka, nale a꞉imano wiya꞉ tanalo kawonomo gito egebolema꞉kamata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ebema꞉ mabu keleka꞉ a꞉ma꞉le naimano wokodawa idi ka꞉nilakapoima꞉wa꞉ka꞉, nale a꞉ma꞉ da꞉nilakapoimitakama eba kunu?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ebe tetelo Kawo Elawodubute ebetamo kawonomamo dowate idoko motamo gito nalibi, ebete ebolo kawo temetema꞉go eba okolinalo teni taoseni kawokawo mani wiyate ebo ka꞉pemaigama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ebene Ya꞉sute uwomu tabo olowiopiatamo negiya, “La꞉ numa꞉la꞉! La꞉le la꞉imano tepo magumuno nilakapo awokalilamea꞉no ega꞉walo epo epetapino kuba egebolelamea꞉no, ebe tetelo naimano Unu Duliyomolono Nabiwite la꞉tamo atumu eba kunu osiyodilote la꞉ kawo temeteme baiamo kanalibolema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ebene Ya꞉sukono tabo kiyawao tanalote dolopoligomiya, ebete Ga꞉lili opo atepate Yudiya opodo petote Yodane Kolomo apuamo gito nemaigiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ebe tetelo epo bilibilinomate ebe opamo ebe dowaloma꞉tiya, ebete ibino temetema꞉gopi wadekobi ebo na꞉midioliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ebene Pa꞉lisi tanebapi epetapiate Ya꞉suko kuba gabamo kowabuga꞉tama꞉ ebetamo pelamete ebe napalatediya, “Kamiyalete ebeno awitamo beda꞉ kawo kuba osiyodilote ebo nakalibutimene? O ebe tetelo awite ebe dalibutimene Godokono Totomu Tabo bakadikanalemene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ya꞉sute tabo eba wiyalo negiya, “Modobola la꞉ Godokono Buka apuno tabo idi wadenomamo nemalagidilala꞉. Ebe tabote ma kunu itana, Godote me opono wagilimi mabune dubula kamiyalela osiyodiloliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ebene ebete negiya, ‘Me mabuma꞉ dubute ebeno nabiwila menokola miyapate, ebeno kamiyala꞉go kapiya bailo kokolioma꞉na꞉, ebene ibi netewapiate kapiyama꞉ eda꞉te walo iyama꞉ a꞉keda꞉ma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iyo, ibi kapiyanomola.’ Numa꞉la꞉, Godote ibi netewapi kapiyakobi a꞉midiliya, ebema꞉ lumagite ibi iyakobi midilima꞉ modoboa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ebene Pa꞉lisi tanebapi dubate Ya꞉sutamo negeliya, “A꞉ma꞉ degeawa꞉ ebe tabote nanitaboma꞉ deda꞉mene, keleka꞉ mabu Mosesete totomu tabo ma kunu diyatiya, dubute ebeno kamiyale alibutima꞉ kamiyale alibuti pepa osiyodilote ebetamo kikaemene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ya꞉sute iba꞉tamo negiya, “Mabu la꞉imano tepo magumu kodakoda-ibinomola Mosesete me totomu la꞉tamo ebema꞉ ikalamiyata, wiyasiya me opono wagilimi mabune Moseseko teta꞉mo pemaiga ebe tanalote eba kunu kitanamia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ebema꞉ nale la꞉tamo gemo, kamiyalete dubu ida꞉go kuba osiyodiloa꞉no, ebe tetelo ebeno awite ebe alibutite kamiyale idi daidimene, ebete Godokono ololo apulo ebe kamiyale pilolo kelaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ebene Ya꞉suko waloma꞉tapiate ebetamo negeliya, “Dubute kamiyale lawe magumulo mako kodakoda tanalote ditanamene, modobola dubate kamiyale a꞉kuwatolema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ebe tetelo Ya꞉sute wiyasiya negiya, “Nale la꞉ diyatulametama ebe tabono magumu kodakodanomola. Godote piyatamo mulo dikalaemene ibinomate ibino wokilo me tabono magumu laema꞉ ka꞉modoboma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dubu epetapiate kamiyale uwatolema꞉ ka꞉modobona꞉, mabu epetapi ibino apete menokobino tepo magumulo kubakubadopoma꞉ eda꞉tepaolamiya. Ega꞉walo dubu epetapiate kamiyale uwatolema꞉ ka꞉modobona꞉, mabu gowela magumulo epetapiate ibi eba kunu amilateliya. Ega꞉walo dubu epetapiate kamiyale uwatolema꞉ ka꞉modobona꞉, mabu ibi a꞉ka꞉tuwa꞉ ibi eba kunu midilina Kawo Elawodawa Godokono woko kosiyodilonama꞉. Ebema꞉ kebe lumagite me tabono magumu laema꞉ da꞉modobomene, modobola ebete nelaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ebene epate gudi Ya꞉sutamo nemagataliya ebete iba꞉tamo koto eba watiolelamelo Godoko kanama꞉ ebete ibi wadenomamo kowalubilinama꞉. Wiyasiya ebe waloma꞉tapiate epo kawiya eba analelo ibi dodiyoboliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ya꞉sute ibino osiyodilo tanalo umite negiya, “Gudi natamo pelaema꞉ modobola. Ako-odiyobola꞉la꞉ mabu mako epate Godote Kawo Elawodawama꞉ deda꞉na ebe duliyomolamo ka꞉nopila꞉oma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ebene ebe gudi kowalubilima꞉ ebete ebeno koto iba꞉tamo watiolelamete, ibi eba miyapalo ebeno to gabodo gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ebe tetelo dubu idite Ya꞉sutamo pete na꞉pegiya, “Iyatulamedawa, na beda꞉ wade tanalo osiyodilote uwomua꞉ igilo ebo na꞉kelaemo?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ya꞉sute ebetamo negiya, “A꞉ma꞉le wade tanalo osiyodiloma꞉ na beda꞉ma꞉ kanana꞉wa꞉? Godoko kapiyate wadedawala, ebema꞉ a꞉ma꞉ ubi diyata꞉emene ebeno Igilo Duliyomolamo nopegama꞉, modobola a꞉ma꞉le ebeno Totomu Tabamo na꞉tuduwatanakiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dubute ebetamo nowamiya, “Kebe totomu taboma꞉ kegeawa꞉?” Ya꞉sute ebeno tabo eba wiyalo negiya, “A꞉ma꞉ lumagi akoanakapuma꞉la꞉, lumagi idino kamiyale pilolo akolawa꞉la꞉, inamabu pilolo akouwata꞉la꞉, lumagi idino tanaloma꞉ a꞉da꞉ tabo akokiyawala꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ega꞉walo a꞉imano nabiwila menokola ibino tabamo na꞉tuduwatanakiye. Ega꞉walo totomu tabo idite ma kunu bitana, a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉ma꞉ demalagidilawena, modobola a꞉ma꞉le eba kunu a꞉ma꞉ niyakabolo dokolina ebe lumagi nilakapolo nemalagidilona.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ebene ebe oli ape dubute Ya꞉sutamo negiya, “Na me totomu tabo bilibilinomo kodakodalo uwatete kapiya idi kadikanaliya꞉. Ebema꞉ na beda꞉ tanalo idi na꞉kosiyodilomo?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ya꞉sute tabo eba wiyalo negiya, “A꞉ma꞉le wade lumaginomoma꞉ keda꞉ema꞉ ubi nanitabolo diyata꞉emene, modobola a꞉ma꞉ toawete epetapiate a꞉imano inamabu maniamo uwateometate, a꞉ma꞉le ebe mani nigologolopiatamo gito na꞉nikalamola꞉. Ebe tetelo a꞉ma꞉ walo ka꞉pa꞉wete na nowaloma꞉eniye, ebene a꞉imano inamabu bilibilinomate Godokono Unu Duliyomololo ka꞉nepola꞉nama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ebe oli ape dubute ebe tabo olowite tepo mibago gito tiya, mabu ebe inamabu bilibila꞉godawanomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ebema꞉ Ya꞉sute ebe waloma꞉tapi nanaliya, “Na la꞉tamo nani tabo gemo, Godote Kawo Elawodawama꞉ deda꞉na, inamabu bilibilinomagodawate ebe duliyomolamo nopegama꞉ kodakodanomola! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nale la꞉tamo tanalo idi na꞉kegemo, ka꞉molo-goeote kaliku waluono moe iyado nilupigama꞉ kodakodama꞉ eda꞉na, gaboa꞉nola. Atumu inamabu bilibilinomagodawate Godokono Kawo Elawodawano duliyomolamo nopegama꞉ kodakodanomoma꞉ eda꞉na, gabote nanitabonomolo a꞉kitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ya꞉suko waloma꞉tapiate ebe tabo olowite kawonomamo la꞉wa꞉ote ebetamo negeliya, “A꞉ma꞉le degeawa꞉ ebe tabote nanitaboma꞉ deda꞉na, piyate modobola꞉ka꞉ Godote ibino igilo mula꞉lelaema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Wiyasiya Ya꞉sute ibi ulamenate negiya, “Epate a꞉ka꞉tuwa꞉ ibino igilo mula꞉lema꞉ modoboa꞉, wiyasiya Godoko kapiyate modobola mabu ebegodolo elawo bitana tanalo bilibilinomo osiyodilolema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ebene Pitate Ya꞉sutamo eba wiyalo negiya, “A꞉ma꞉ numa꞉, a inamabu bilibilinomo miyapate a꞉ma꞉ nowaloma꞉enata. Ebema꞉ Godote atamo beda꞉ wiya na꞉kikaeaemene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ya꞉sute iba꞉tamo negiya, “Na la꞉tamo nani tabo gemo, Godote me opono iyaiya inamabu bilibilinomo olinoma꞉ da꞉midilimene, ebe tetelo na Epono Naniwite naimano Kawo Elawodawano okoli bailo kawo alonomago kokolitamo. Ebene atu tetelo la꞉le na dowaloma꞉ena꞉wenama, la꞉ kawokawo elawodubuno ilukuli bailo ilukula꞉wete Isalaela 12 gu epono iyaiya tanalo anagilamelelamepima꞉ keda꞉omamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nanitabola, kebe lumagite ebeno moto, o ebeno nanila nanikubila ekakila, o ebeno nabila menokobila gudila ega꞉walo ebeno opo, ebete na mabuma꞉ ebe iyaiya tanalo da꞉miyapamene, ebete ebe atu tanalo bilibilinomo walo ka꞉kuwatemene, ega꞉walo walone nale ebetamo uwomua꞉ igilo kikaemamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Iyo, ka꞉lo dopopi bilibilinomo da꞉pola꞉na iba꞉te walone walogabopima꞉ keda꞉oma꞉na꞉, ega꞉walo ka꞉lo walogabopi da꞉pola꞉na iba꞉te walone dopopima꞉ keda꞉oma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ebe atu tetelo Ya꞉sute na꞉kegiya, “Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalo ma kunula. Kawo dubu idite duiyanomolo maigate ebeno motone piwisigate ebo ti ebeno da꞉imi pali wokopi ka꞉nuwatema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ebene ebete dubu epetapi nulamete iba꞉tamo kapiya egelano woko wiya ikalaema꞉ nanali. Iba꞉te ebeno tabo olowite modoboma꞉ degeliya, ebete ibi ebo aliboli ebeno pali woko ka꞉nowagilima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ebene egelate kela꞉mo da꞉podolatepi, ebete walo ka꞉tote dubu epetapi olowame bailo gito lamota꞉onalo da꞉nulami, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ebete iba꞉tamo negi, ‘Modobola la꞉ atumu naimano pali wokamo na꞉ka꞉tolama꞉la꞉, ebene nale woko wiya la꞉tamo modobolo kikalaemamota.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ebe tetelo iba꞉te atu pali wokamo gito ka꞉tolamiya. “Ebene egela tuli tetelo ega꞉walo egelate da꞉ponolobigatepi, ebe netewa teta꞉mo ebete walo ka꞉tote wokopi epetapi atumu ka꞉nulamete wokamo ebo kanaliboli. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ebene egelate walo da꞉ka꞉toatepi, ebete walo ka꞉tote dubu epetapi olowame bailo gito lamota꞉onalo nulamete nananali, ‘Beda꞉ mabuma꞉ la꞉ ka꞉lo egelalo wokoa꞉no gito da꞉pola꞉wenama?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Iba꞉te ebetamo nowamiya, ‘Mabu idawate atamo woko kikaeama꞉ka꞉.’ “Ebene kawo dubute iba꞉tamo negi, ‘Modobola la꞉ atumu naimano pali wokamo na꞉ka꞉tolama꞉la꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Dadimoni ebe pali namutudawate penate ebeno woko umidawatamo na꞉pegeni, ‘A꞉ma꞉ wokopi bilibilinomo ka꞉la꞉miawete wiya nikalamola꞉. Walogabonomolo woko da꞉powagilima꞉ka ebe dubagodone wagilima꞉wete, wiyasiya duiyanomolo woko da꞉powagilima꞉ka a꞉ma꞉le ibi uwomulo nowalubiliye.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ebene walogabonomolo woko dowagilimiya ebe dubate dopamo pelamenate, ebete iba꞉tamo kapiya egelano modobo woko wiya eba kunu ikalameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ebene duiyanomolo woko dowagilimiya ebe dubate pelamenate kawodopamo na꞉puwatenamu pemalagidiloniya, wiyasiya ebete iba꞉tamo atu wiyanomo kikalamoleni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ebe tetelo iba꞉te wiya uwatenate pali namutudawatamo ubia꞉ tabo eba gelanalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ibi magumulo idawate penate na꞉pegeni, ‘Walone dowagilima꞉ka iba꞉te tete da꞉pesamo posiyodilote wiyasiya ebe woko wiya ago modobolo beda꞉ma꞉ kuwate, mabu a egela kawonomolo woko kawo koloago osiyodilutakama꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ebe tetelo ebete nowamini, ‘Naimano namutudawa, na kuba tanalo idi a꞉ma꞉tamo kosiyodiloa꞉. Duiyalo a꞉ma꞉la, nala, ale nani tabonomo negelakama꞉ a꞉ma꞉ kapiya egelano modobo woko wiya kelawa꞉ema꞉, nale a꞉ma꞉tamo ma kunu ebema꞉ ikaemata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ebema꞉ a꞉imano wiya lawa꞉wete kalakalago na꞉toa. A꞉ma꞉le woko wiya delawa꞉wa꞉, nale ebe atu modobo mani walone dowagilima꞉ka iba꞉tamo ubi diyatimo, nale eba kunu kikalaemamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Me woko wiya mani ebe naimano manila, ebema꞉ nale a꞉ka꞉tuwa꞉ naimano ubilo dosiyodilomo ebe naimano tanalola. Mabu keleka꞉ a꞉ma꞉le naimano nilakapo tanaloma꞉ da꞉dowawena?’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ebema꞉ Ya꞉sute uwomu tabo ma kunu giya, “Nanitabola, ka꞉lo walogabopi bilibilinomo da꞉pola꞉na iba꞉te walone dopopima꞉ keda꞉oma꞉na꞉, ega꞉walo ka꞉lo dopopi da꞉pola꞉na iba꞉te walone walogabopima꞉ keda꞉oma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ebene Ya꞉sute Yelusalema kawo duliyomolamo eba tutalo, gabo tetelo ebete ebeno 12 waloma꞉tapinomo uwatete tabo diya nanaliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“La꞉ nolowiala꞉, a Yelusalemamo tolamitama꞉. Ebolo Godote Epono Naniwi epatamo kikalaemene, ebene Godotamo kalimagono ikameopino watowatopi ega꞉walo Godokono Totomu iyatulamepi, iba꞉te ebe anakapuima꞉ gelate ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yua꞉piatamo ebo kikalaema꞉na꞉. Ebe epate ebe kalakalatete pa꞉ka꞉pa꞉ka꞉mo a꞉na꞉ma꞉ga꞉midaote ebe ebo kanakapuima꞉na꞉, wiyasiya netewa-kapiya egelalo Godote ebe a꞉ene kadipatemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ebene Sebedikono gudino menokote ebeno guda꞉go Ya꞉sutamo pete ebeno pupamo pokolite, ebete ebe kowalubima꞉ napaniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ya꞉sute ebetamo negiya, “A꞉ma꞉ beda꞉ ubi kiyata꞉wita nale a꞉ma꞉tamo osiyodiloma꞉?” Ebete tabo eba wiyalo negiya, “Me naimano gudi netewa na꞉kulama꞉wita? A꞉ma꞉le Kawo Elawodubuma꞉ deda꞉emene, a ubila a꞉ma꞉le degeaemene idawate a꞉imano tumudi apulo ega꞉walo idawate pele apulo a꞉imano Kawo Elawodubuno elawo magumulo kokoliutama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wiyasiya Ya꞉sute iba꞉tamo negiya, “La꞉le na wade wokiamo kanana꞉wita꞉. La꞉ modobola꞉ka꞉ nale da꞉nimo ebe temeteme kalila꞉mo nioma꞉?” Iba꞉te negeliya, “A modobola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ya꞉sute iba꞉tamo negiya, “Me tanalo nanitabola, nale da꞉nimo la꞉ ebe kalila꞉mo niawete temeteme bolowionakomata. Wiyasiya naimano tumudi apuamo ega꞉walo pele apuamo ilukuli tanaloma꞉ nale a꞉kegemo. Nabiwi Godote piyatamo dosiyodiloliya ibinomate ebolo ka꞉pola꞉nama꞉na꞉, iyo, me tanaloma꞉ ebete a꞉ka꞉tuwa꞉ kegemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ebene teni waloma꞉tapi epetapiate ebe tanalo olowite ebe dubu netewatamo na꞉dowautiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","wiyasiya Ya꞉sute ibi bilibilinomo ebetamo ka꞉la꞉mite negiya, “La꞉ iyatawalata, Godoko nanitabokobi midia꞉pino kawokawo dubate ibi a꞉ka꞉tuwa꞉ ibi eba wadipalatelelo epo epetapi kawonomamo analenaka, iba꞉te ibino ubi tanalamo ka꞉tudila꞉onama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wiyasiya la꞉ ebako epoma꞉ a꞉keda꞉oaema. Kebe lumagite la꞉imano kawodawama꞉ eda꞉ma꞉ ubi diyatimene, ebete la꞉imano wiya꞉ wokodawama꞉ neda꞉mene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ega꞉walo kebe lumagite dopodawama꞉ eda꞉ma꞉ ubi diyatimene, ebete la꞉imano idoko motono wokodawama꞉ neda꞉mene, iyo, ebe a꞉ka꞉tuwa꞉ ebe oponomamo iyatinomo niyatimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ma kunu Epono Naniwite da꞉piya, ebe ubia꞉nola me opo epate ebetamo wiya꞉ wokopima꞉ eda꞉oma꞉, wiyasiya ebete na꞉piya epatamo wiya꞉ wokodawama꞉ ka꞉peda꞉ma꞉, ega꞉walo ebeno igilo iyabaiamo iyatite ebeno a꞉e wiyate epo bilibilinomo epetapi Saitanakono idoko motone gito kowagailima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ya꞉sute ebe waloma꞉tapiago Yeliko kawo duliyomolone da꞉nemaimiya, ebe tetelo epo bilibilinomate ebe waloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ebene dubu netewa balidi tamiolamepila, iba꞉te gabo niyakabolo eba okoliutalo Ya꞉sukono pe tanalo olowite kawonomamo negeliya, “Da꞉ibidikono A꞉la꞉mu! A꞉ma꞉le a na꞉nilakapoiama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ebema꞉ epo bilibilinomate ibi kawiya analelo nodiyoboliya iba꞉te taboa꞉no kokoliutama꞉, wiyasiya iba꞉te kawonomamo walo na꞉kegeliya, “Kawodawa Ya꞉su, Da꞉ibidikono A꞉la꞉mu! A꞉ma꞉le a na꞉nilakapoiama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ebene Ya꞉sute ebamo utite ibi ka꞉la꞉mite iba꞉tamo negiya, “La꞉ beda꞉ ubi kiyata꞉witama nale la꞉tamo kosiyodiloma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Balidi tamiolamepiate negeliya, “Kawodawa, aimano balidi wadekobi na꞉midioleama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ebene Ya꞉sute ibi nilakapoilamelo ibino balida꞉mo ebeno koto dowatiolelamiya, ebe tetenomolo ibino balidite wadekobi olowiolamete iba꞉te Ya꞉suko ebo waloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ebene iba꞉te Yelusalema kawo duliyomolo niyakabamo eba pelamelo, Betapa꞉gi duliyomolo niyakabodo tolamete Olibi Kewakewa Unu Damelamo ebo nemaimiya. Ebe tetelo Ya꞉sute ebe waloma꞉tapi netewa dopamo eba nalibolelo ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","iba꞉tamo negiya, “La꞉ ebe tatali duliyomolamo toawete, ebe duliyomolamo da꞉nemaima꞉ema donoki-goeo ala꞉mo ma꞉midao ebeno gudago ka꞉nulama꞉digalemamota. Modobola la꞉ ale pamiawete ebeno gudago nemagaeliyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Idawate la꞉ odiyobolema꞉ tabo degemene la꞉ wiyasiya ma kunu kegelamamota, ‘Kawodawate me donoki-goeogoeo ubila, ebete walo samonomamo kakapalibolemene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ebene me tanalote pemaigiya Godokono woki awokalimidawate degiya ebe tabote nanitabokobi kolowima꞉. Iyalo tetelo ebete tabo ma kunu giya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“La꞉ Yelusalema epatamo na꞉negeliyala꞉, ‘Numa꞉la꞉, la꞉imano Kawo Elawodubute la꞉tamo pita. Ebete donoki-goeo unamo okolite milago pita, iyo, la꞉ numa꞉la꞉, ebete donoki da꞉pesago ba꞉pe.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ebene Ya꞉suko waloma꞉tapi netewate tote, ebete keba kunu kegiyale iba꞉te eba kunu nosiyodiliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Iba꞉te donoki-goeo ega꞉walo ebeno gudu Ya꞉sutamo magaelete, ibino watubino kaliku ibi unamo alomolamete, Ya꞉sute ebe kaliku unamo ebo okoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ebe tetelo epo bilibilinomo epetapiate ibino ga꞉ga꞉ga꞉ga꞉ kaliku pupukulamete gabamo apoago tolamiya, ega꞉walo epetapiate puwala otolete gabamo atumu kapotameonatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ebene piyate da꞉dopiya ega꞉walo Ya꞉sukono walogabo apune da꞉pelamitiya, iba꞉te kapimiya kawonomamo ma kunu gelitiya, “Da꞉ibidikono a꞉la꞉mu nadipata꞉la꞉! Godo, a꞉imano mailago da꞉pita, modobola a꞉ma꞉ ebe lumagi kawokobi na꞉midiye! O epala꞉, la꞉ Godoko moiolo unamo nadipata꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ebema꞉ Ya꞉sute Yelusalema kawo duliyomolamo da꞉nopegiya, me duliyomolo epo bilibilinomate ebe uima꞉ pemaimiote na꞉pegeliya, “Me lumagi potelela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ebe tetelo Ya꞉suago da꞉tolamitiya ibi bilibilinomate duliyomolo epono tabo eba wiyalo negeliya, “Me Godokono woki awokalimidawa Ya꞉sutela, ebete Ga꞉lili opono Nasalete duliyomolone pe.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ebe tetelo Ya꞉sute Godoko Amamateno Iya Motamo tote, ebe motolo ebete inamabu olowamepi nulamete ibi bilibilinomo elawonomamo na꞉na꞉ma꞉lateliya, ega꞉walo ebete mani odowaolepino patapata bigo olowamepino ilukuli patapatago ebo noba꞉midaolelamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ebene ebete iba꞉tamo negiya, “Godokono Bukalo tabo ma kunu bitana, ‘Naimano Moto epate Godoko Amamate Motoma꞉ kegelama꞉na꞉, la꞉le wiyasiya pilo epono motoma꞉ a꞉midimata.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ebe tetelo balidi tamiolamepi ega꞉walo agowa tataipi, iba꞉te Godoko Amamateno Iya Motamo da꞉pelamiya Ya꞉sute ibi wadekobi ebo midioliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Wiyasiya Godotamo kalimagono ikameopino watowatopi ega꞉walo Godokono Totomu iyatulamepi, iba꞉te Ya꞉sukono wade anoano tanalo dulamitiya iba꞉te ebetamo na꞉dowautiya. Ega꞉walo ebe atu tetelo iba꞉te tanalo idima꞉ ka꞉dowautiya ma kunu, gudi epetapiate eba gelatepautalo degelitiya, “Da꞉ibidikono a꞉la꞉mu nadipata꞉la꞉!” Ebe mabuma꞉ iba꞉te ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ya꞉suko naniya, “A꞉ma꞉ guda꞉te tabo kubanu degelita na꞉kolowiawita?” Wiyasiya Ya꞉sute iba꞉tamo negiya, “Iyo, na nolowitamo. Modobola la꞉ me Godokono Buka apuno tabo wadenomamo nemalagidilala꞉, ‘O aimano Kawodawa Godo, gudi egege ega꞉walo nono da꞉niona, a꞉ma꞉le ibino tabo magumune wadewade tabo kiyawaonakota a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉ma꞉ kemoiawenama꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ebene dadimoni Ya꞉sute ibi miyapanate kawo duliyomolo magumune maiganate Betani duliyomolamo tonate ebo nowatani. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Duiya idilo Ya꞉sute kawo duliyomolamo walo da꞉kolowamiya, gabo tetelo ebe bae kapete umiti, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ebene ebete umei kewa gabo niyakabolo pumite da꞉imi olema꞉ ebamo da꞉tiya wiyasiya paanomoiya nulamiya. Ebema꞉ ebete umei kewatamo negiya, “Uwomua꞉ tetelo da꞉imite a꞉ma꞉godone a꞉ka꞉nolonakomene!” Ebe tetenomolo ebe da꞉imi kewate alawoma꞉ ebo ediya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ya꞉suko waloma꞉tapiate ebe tanalo umite kawonomamo anoanote negeliya, “Umei kewate alawoma꞉ samonomamo beda꞉ma꞉ keda꞉le?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ya꞉sute ibino tabo eba wiyalo negiya, “Na la꞉tamo nani tabo gemo, la꞉ tete bilibilinomolo Godoko nanitabokobi eba midinalo la꞉imano tepo magumulo woki netewama꞉ eda꞉oa꞉no, nale umei kewatamo keba kunu kosiyodilomo, la꞉le ebe atu tanalo osiyodiloma꞉ ka꞉modobomamota. Ega꞉walo la꞉ nanitabokobi midilo me damelatamo ma kunu degelaema, ‘A꞉ma꞉ kewa꞉ kolomamo na꞉toatepa!’ la꞉le ebe tanalo nanitabolo kuimamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Iyo, nanitabola, la꞉ Godoko nanitabokobi eba midinalo beda꞉ tanaloma꞉ ebe da꞉toweoma꞉ema, ebe tetelo la꞉le ebe tanalo kelaemamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ebene Ya꞉sute Godoko Amamateno Iya Motamo tote epo eba niyatulamitalo, ebe tetelo Godotamo kalimagono ikameopino watowatopi ega꞉walo Yu epono kawokawo dubu epetapi, iba꞉te ebe odiyoboma꞉ pelamete ebe ma kunu palatediya, “A꞉ma꞉ me iyaiya tanalo pokono elawamo kosiyodilola꞉wena? Ega꞉walo me elawo a꞉ma꞉tamo potele kikametia?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ya꞉sute iba꞉tamo nowamiya, “Nale la꞉ dopamo kapiya tanaloma꞉ kalateda꞉lemamota. La꞉le na wiya tabo wadenomamo dowaminama꞉ema, ebene nale me tanalo pokono elawamo kosiyodilolenamo, ebe tanalo nale la꞉ ebo kanalemamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Naimano alateda꞉ tabo la꞉tamo ma kunu bitana, Yonete epo obamo dowaduba꞉midaolenaki, ebete ebeno elawo pogodone kelawile, Godogodonela꞉ka꞉ o lumagi idigodonela꞉ka꞉?” Ebema꞉ ibi a꞉ka꞉tuwa꞉ ibino taneba magumulo apaminateuilo negeliya, “Ale degelama꞉ Godote Yonetamo elawo ikami, ebete kegemene, ‘Mabu keleka꞉ la꞉le ebeno tabo nanitabokobi ka꞉mida꞉wea꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ega꞉walo a modoboa꞉ ebe ma kunu anama꞉, me opo lumagite Yonetamo elawo ikami, mabu ale me epono dowa tanalo tolemitama꞉. Ibi bilibilinomate negelana Yoneko Godokono woki awokalimidawala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ebema꞉ iba꞉te ibino tepo magumuno woki waminaolelo Ya꞉sutamo negeliya, “Yonekono elawo mabu a iyatawa꞉.” Ebema꞉ Ya꞉sute iba꞉tamo negiya, “Nale la꞉ atumu akanaletama nale me iyaiya tanalo pokono elawamo kosiyodilolenamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ebene Ya꞉sute ebe Yu watowatopiatamo negiya, “Na la꞉tamo oi tabo idi ka꞉kiyawaomamo. La꞉ ebe oi wadenomamo olowiawete ebeno magumu natamo nawokalimiyala꞉. Kapiya dubute nokolinami, ebeno koi netewala. Egela idilo ebete ebeno dopo koitamo pete na꞉pegi, ‘A꞉ma꞉ toawete naimano pali magumulo woko na꞉nosiyodila.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ebeno gudute nowami, ‘Ao, na ubia꞉nola,’ wiyasiya walone tetelo ebete woki iyakobi midite wokoma꞉ gito ti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ebene ebe dubute ekawitamo ka꞉pete atu tabo da꞉ka꞉pegi, ebe gudute nowami, ‘Iyo, Aba, na ka꞉tomamo,’ wiyasiya ebete ka꞉toa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ebene Ya꞉sute ebeno tabo olowiopiatamo negiya, “La꞉imano woki keba kunula꞉ka꞉? Gudi netewa magumulo ebeno nabiwi potele kekalakalaimile?” Iba꞉te negeliya, “Dopo gudutela.” Ebema꞉ Ya꞉sute iba꞉tamo negiya, “Na la꞉tamo nani tabo gemo, ta꞉kese mani elemasigilo uwatepi dubu ega꞉walo dubu bilibili kamiyale, iba꞉te la꞉imano gobebobo uwatelametate Godokono Kawo Elawodawano duliyomolamo ka꞉nopila꞉oma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mabu Yoneko epo obamo waduba꞉midaoledawate Godokono tuputupu gabodo da꞉pi, la꞉le ebeno tabo nanitabokobi ka꞉mida꞉wea꞉, wiyasiya mani pilolo uwatepi dubu ega꞉walo dubu bilibili kamiyale iba꞉te ebe nanitabokobi midite ibino tepo magumu Godotamo oba꞉midaliya. Nanitabola, ebe tetelo la꞉le ibino tanalo dulamelelama꞉ima, wiyasiya la꞉imano kubakuba woki iyakobi midilia꞉no Yonekono tabo kelawa꞉wea꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ebene Ya꞉sute walo na꞉kegiya, “Modobola la꞉le naimano iyatulame oi idi nolowiala꞉. Kawo dubu idite pali osiyodilote tupina da꞉imi kewa ebo ami, ebe da꞉imino mailo ebe gala꞉ipi da꞉imila. Amio tanalote dolopoligi, ebete kala ga꞉dimite da꞉imi ii egedioleno nokola bobo obobote, pali atila꞉pino unu nupunupu ebo eti. Ebe tetelo ebe dubute ebeno pali atila꞉pi dubu epetapiatamo gito atepi, iba꞉te ebolo woko eba osiyodilonalo ebe pali wadenomamo umilo ebeno da꞉imi kuwatolemenakoma꞉, ebene ebete mulu opamo gito ti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Ebene da꞉imi tapio tete da꞉pi ebete pali atila꞉piatamo wiya꞉ wokopi epetapi napaliboli, iba꞉te iba꞉godone ebeno da꞉imi ka꞉puwatema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wiyasiya pali atila꞉piate ibi uwatete idi gaubamo anagalimiya, ega꞉walo idi gito anakapumiya, ega꞉walo idi nokolamo mapemiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dopamo pali namutudawate kapiyakapiya wiya꞉ wokopi paliboli, ebene ebete walo epetapi bilibilinomo dakapaliboli pali atila꞉piate iba꞉tamo atu kubakuba tanalo kosiyodiloliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Walogabonomone ebete ebeno gudu eba palibolo ebeno wokilo negi, ‘Nanitabola, iba꞉te naimano gudutamo ka꞉tudila꞉oma꞉na꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Wiyasiya ebe pali atila꞉pi dubate ebe gudu pitalo dumiya iba꞉te ibino taneba magumulo negeliya, ‘Numa꞉la꞉, me gudute nabiwino inamabu namutudawama꞉ deda꞉mene, ebe gudute na꞉pe. Ebema꞉ modobola ale ebe anakapumite ebeno pali kelaemalema꞉,’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ebene iba꞉te ebe lawete palino kala magumune neba꞉idilote gito nanakapumiya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ebema꞉ Ya꞉sute olowiopiatamo negiya, “La꞉imano woki keba kunula꞉ka꞉? Pali namutudawate mulu opone da꞉pemene, ebete beda꞉ tanalo na꞉ka꞉posiyodilomene pali atila꞉piatamo?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yu watowatopiate ebeno tabo eba wiyalo negeliya, “Nanitabola, ebete ebe kuba wokopi kubanomamo palukolete kapanakapulaemene. Ebe tetelo ebete ebeno pali atila꞉pi dubu epetapiatamo ka꞉pikalaemene, da꞉imi nolo tetelo iba꞉te ebeno pali inamabu ebetamo wadenomamo kikameonakoma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ya꞉sute iba꞉tamo negiya, “La꞉ dopamo Godokono Bukalo me tabo nanitabolo eka꞉la꞉mioliamata, ‘Moto etepiate iyabaiamo diyatiya, ebe alote wiyasiya motono elawo mabuma꞉ eda꞉na. Me tanalo Godote osiyodili, ebema꞉ aimano wokilo nanoanoutama꞉!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ebema꞉ nale la꞉tamo negemo, Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalo ebete la꞉godone puwatete piyagodolo wadewade nolo da꞉imi da꞉pola꞉na ebako epatamo gito kikalaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Numa꞉la꞉, nale alono tanaloma꞉ degemo, ebeno kodakoda ebe nokola keba kunula꞉ka꞉ eba kunula. Iyo, me nokola unamo degamene ebe lumagite keta꞉ta꞉puwatiomene, ega꞉walo me nokolate lumagi dita꞉timene kedagodagoimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ebene Godotamo kalimagono ikameopino watowatopi ega꞉walo Pa꞉lisi tanebapi epetapi iba꞉te Ya꞉sukono oi tabo dolowiya, iba꞉te ebo iyatawaiya Ya꞉sute ibino tanaloma꞉ kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ebema꞉ iba꞉te ebe laema꞉ ubi iyatitiya, wiyasiya iba꞉te epo tolelamitiya mabu ibi bilibilinomate Ya꞉suko Godokono woki awokalimidawama꞉ gelanakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ebene Ya꞉sute iyatulame oi idi epatamo kiyawaolo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalo ma kunu itana. Kawo Elawodubu idite ebeno koino kamiyale laweno soliyomu osiyodilote ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ebeno wokopi ebo aliboli, ebete dopamo deka꞉la꞉mi ebe epo nuwatete soliyomu baiamo kemagaelema꞉. Wiyasiya iba꞉te pelaema꞉ ubia꞉noma꞉ eda꞉iya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ebene ebete walo wokopi epetapi eba kanalibolelo na꞉kegi, ‘Na dopamo deka꞉la꞉mimo, la꞉le ebe epo ma kunu walo nakananala꞉la꞉, ‘Na soliyomu inamabu osiyodilola꞉kamo, kau-goeogoeo gadigadinomo alukola꞉kamo, soliyomu inamabu bilibilinomo osiyodilole olopoligo. Modobola la꞉ pelama꞉wete na꞉penaoala꞉.’ ’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Wiyasiya iba꞉te ebe tabo ubia꞉noma꞉ eda꞉ote ibino iyaiya woko baiamo gito tolamoliya, ma kunu idawate ebeno pali wokoma꞉ ti ega꞉walo idawate olowame baiamo ti, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ebene epetapiate Kawo Elawodubuno wokopi uwatete eba malogolelo ibi ebo anakapulamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ebe tetelo Kawo Elawodubute kawonomamo dowalo ebeno gowelaopi ebo naliboli, ebene piyate ebeno wokopi danakapulamiya, gowelaopiate ibi kubanu anakapulamete ibino duliyomolo elamo gito imukalamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ebe tetelo ebete ebeno wokopiatamo negi, ‘Naimano koino kamiyale lawe soliyomuno inamabu bilibilinomo osiyodilola꞉kamo, wiyasiya nale dopamo deka꞉la꞉imo ebe epo wadewadenoa꞉, iba꞉te pelaema꞉ na ubia꞉nola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ebema꞉ modobola la꞉ kawokawo gabo gagao teta꞉mo tolama꞉wete, la꞉le da꞉nulama꞉ema ebe epo bilibilinomo nananaliyala꞉ iba꞉te naimano soliyomu bae ka꞉penaoma꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ebe tetelo wokopiate tolamete gabo gagao tetelo epo bilibilinomo ebo nuwatiya, ma kunu nigologolopi ega꞉walo inamabu bilibilinomagopi, ebe epo bilibilinomate kapimiya soliyomu baiamo pelamolete, iba꞉te bae kebe motolo kenautiye ebe kawo moto gu gito taboki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ebe tetelo Kawo Elawodubute epono koto uwatolelaema꞉ soliyomu motamo da꞉pi, ebete kapiya dubu ebo pumi ebete soliyomuno wade kalikunomo pulia꞉no podoli. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kawo Elawodubute ebetamo negi, ‘Namutudawa, mabu keleka꞉ a꞉ma꞉ wade kaliku pulia꞉no da꞉podolawa꞉?’ “Ebe tetelo ebete ebeno tabo olowite kowamiya꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ebema꞉ Kawo Elawodubute ebeno opopiatamo negi, ‘Modobola la꞉ ebeno kotola agowala ala꞉mo matuolamolema꞉wete idoko magumamo ba꞉idila꞉wete ebo nanatepiyala꞉. Ebete ebolo lalo eba oliomolelo kawonomamo kiimene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ebema꞉ Ya꞉sute uwomu tabo ma kunu giya, “Nanitabola, Godote epo bilibilinomo ka꞉la꞉mina, wiyasiya ibi magumulo kapiyakapiyanomo uwatenako.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ebe tetelo Pa꞉lisi tanebapiate tolamete Ya꞉sukono tanaloma꞉ ibi magumulo tabo da꞉negeliya ibino ubi ebo niyatiya, iba꞉te ebe kuba gabamo eba nowabuga꞉talo ebete kebako tabo gelo ebe ebo kelaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ebene iba꞉te ibino waloma꞉talepi epetapi ega꞉walo Kawo Elawodubu Elodikono tanebapi atu tetelo Ya꞉sutamo aliboliya. Iba꞉te ebetamo pelamete a꞉da꞉ elemasigi gabodo na꞉pegeliya, “Iyatulamedawa, a iyatawala a꞉ma꞉ nani tabo lumagilata, iyo, a꞉ma꞉ epo Godokono gabo wadenomamo iyatulamenata. Nanitabola, a꞉ma꞉ epetapino gito gela tanalamo ka꞉tuduwatawenakoa꞉, ega꞉walo a꞉ma꞉ epo unu nikapiamo kulama꞉wena꞉, ma kunu lumagi idi atepalo lumagi idi ebo a꞉kelawa꞉emene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ebema꞉ a꞉imano woki awokalima꞉wete a nanaa꞉, Loma epono Kawo Elawodubunomo Sisatamo ta꞉kese mani ikameoma꞉ modobola꞉ka꞉ o kubala꞉ka꞉? A ebetamo ba꞉kikameoma꞉ o a꞉kikameoma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ya꞉sute ibino elemasigi tanalo iyatawate negiya, “La꞉ mena netewa epolata! Mabu keleka꞉ la꞉le na masiginima꞉ dowagela꞉witama? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","La꞉ mani kapiya natamo nikanama꞉la꞉.” Ebene iba꞉te kapiya mani ebetamo dikamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ebete ibi nalateda꞉liya, “Me manilo da꞉pola꞉na, mailo ega꞉walo ololo pokonola꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Iba꞉te negeliya, “Kawo Elawodubunomo Sisakonola.” Ebene Ya꞉sute iba꞉tamo negiya, “Sisakono inamabu Sisatamo nikameala꞉, wiyasiya Godokono inamabu Godotamo nikameala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ebema꞉ iba꞉te Ya꞉sukono tabo olowite eba anoanolo ebe atepate gito tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A꞉e magumune maimioa꞉noma꞉ degelana, ebe epo Sa꞉diyusi tanebapila. Ebe atu egelalo ibi epetapiate Ya꞉sutamo pelamete ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","tabo ma kunu pegeliya, “Iyatulamedawa, Mosesete Godokono tabo ma kunu giya, ‘Dubute a꞉ete kamiyale gudia꞉no datepamene, ebeno ekawite ebe amole lawete ebeno naniwino tanaloma꞉ gudi nosiyodilolemene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aimano epo magumulo kapiya dubuno sebeni koiate ilukulinamiya. Dopo gudute kamiyale lawete gudi ulamea꞉no a꞉iya, ebene ebeno ekawite ebeno amole gito kelawiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ebe tetelo ebe atumu gudi ulamea꞉no gito ka꞉iya, ega꞉walo tetedawa idite eba kunu kowageliya. Ebene ebe sebeni atu alailame bilibilinomate eba kunu a꞉elaiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","wiyasiya kamiyalete walone gito a꞉iya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ebema꞉ iba꞉te a꞉e magumune igilamo demaimioma꞉na꞉, ebe Kawo Egelalo ebe kamiyalete sebeni dubu magumulo pokono kamiyalema꞉ na꞉keda꞉mene, mabu ebe ibi bilibilinomate aida꞉tepaiya?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ebene Ya꞉sute iba꞉tamo nowamiya, “La꞉ Sa꞉diyusi tanebapiate la꞉imano wokilo epono a꞉ela tanaloma꞉ kubanu gelanakomata, mabu la꞉ Godokono Buka tabo ega꞉walo ebeno elawo iyatawa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Me tanalo ebe nanitabola, epate a꞉e magumune maimio tetelo iba꞉te kamiyale walo a꞉ka꞉piaidiolema꞉na꞉ ega꞉walo dubu a꞉ka꞉puwatolema꞉na꞉, iyo, iba꞉te Godokono Unu Duliyomolono nopopimu bilukulionama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ebe mabuma꞉ Godokono Bukate a niyatuamena a꞉elaopiate a꞉e magumune maimioma꞉, iyo, ebete ebeno Bukalo la꞉tamo iyalo degiya ebe tabo la꞉ nanitabolo eka꞉la꞉mioliamata. Ebe tabote ma kunu itana, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nanitabola, na Godotela. A꞉ibalayamako, Aisa꞉keko, ega꞉walo Ya꞉ikoboko, iba꞉te uwomua꞉ tetelo poko kamamatene, na ebetela.’ Ebema꞉ la꞉ Sa꞉diyusi tanebapi, la꞉imano wokilo na꞉kemalagidilawenama ebe ewonino igilate olopoligoiya? Ao, kolopoligiya꞉, mabu a꞉elaopiate Godoko kamamatena꞉, wiyasiya piyate igilolo dilukulina ebe eponomate ebe amamatena.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ebe tetelo epo bilibilinomate Ya꞉sukono tabo olowite ebeno tabamo anoanolo nekalakalautiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ya꞉sukono tabote Sa꞉diyusi tanebapino tabo dalukolelamiya, ebe tanalo Pa꞉lisi tanebapiate olowite iba꞉te kapimiya ebetamo pelamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ebene ibi magumulo dubu idi ebe Godokono Totomu Tabo iyatawanomola, ebete Ya꞉suko kuba gabamo wabuga꞉tama꞉ ebe palateda꞉lo na꞉pegiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Iyatulamedawa, Godokono Totomu Tabo bilibilinomo magumulo kebe totomute kawonomoma꞉ keda꞉nale?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Ya꞉sute ebeno tabo eba wiyalo negiya, “Godokono Totomu Tabo bilibilinomo magumulo me tabote kawonomoma꞉ eda꞉na, ‘A꞉ma꞉ a꞉imano Kawodawa Godoko nilakapolo nemalagidilona, a꞉imano tepo magumunomamo, ega꞉walo a꞉imano uliyanano elawamo, ega꞉walo a꞉imano woki kawonomamo.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ega꞉walo me totomu kawonomo idi atumu ba꞉kitana, ‘A꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉ma꞉ demalagidilawena, modobola a꞉ma꞉le eba kunu a꞉ma꞉ niyakabolo dokolina ebe lumagi nilakapolo nemalagidilona.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nanitabola, Godote epatamo Mosesedo dikalamiya ega꞉walo ebeno woki awokalimipiate ebeno Bukamo dakuloliya, ebe Totomu Tabo bilibilinomono magumu ebe kapiyala, me kawokawo totomu netewa magumulo ba꞉pola꞉na.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ebene Pa꞉lisi dubate ibino taneba magumulo eba pola꞉nalo Ya꞉sute ibi nalateda꞉liya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“La꞉ Kelisokono tanaloma꞉ keba kunu kemalagidilawenama? Ebe pokono a꞉la꞉mula꞉ka꞉?” Iba꞉te ebetamo nowamiya, “Da꞉ibidikono a꞉la꞉mula, ebeno walone gudi magumune kawokalamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ya꞉sute iba꞉tamo negiya, “La꞉imano tabo nanitabola, ebema꞉ mabu keleka꞉ Da꞉ibidite Kelisoko ebeno Kawodawama꞉ deka꞉miya? Iyo, ebete Godokono Uliyanano elawamo tabo ma kunu kiyawaiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Kawodawa Godote naimano Kawodawa Kelisotamo nege, ‘A꞉ma꞉ naimano tumudi apuamo na꞉pokoliya, ebene a꞉ma꞉go gowelaopi a꞉ma꞉le naimano elawamo ibi ka꞉mikitaolema꞉ta.’ ’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ebene Ya꞉sute tabo moga꞉melo walo na꞉kegiya, “La꞉ me tabo eba malagidilolo na nanana꞉la꞉, Da꞉ibidite ebeno a꞉la꞉mu Kelisoko ebeno Kawodawama꞉ ka꞉milo ebete Godokono tumudi apuamo okolima꞉ giya, ebema꞉ ebe tanalote keba kunu na꞉ka꞉pemaigamene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ebe tetelo ibi magumulo lumagi idite Ya꞉sutamo wiya tabo gema꞉ ka꞉modobiya꞉, ebema꞉ ebe tetene wagilimite epate ebe tabo idi alateda꞉ma꞉ na꞉toletoleutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ebene Ya꞉sute epo bilibilinomo ega꞉walo ebeno waloma꞉tapiatamo tabo eba kiyawaolo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Godokono Totomu iyatulamepi ega꞉walo Pa꞉lisi tanebapi, Godote iba꞉tamo Mosesekono gobebobo ikalamiya, ma kunu Mosesete Bukamo dakuloliya iba꞉te ebe Totomu Tabo wadenomamo niyatulamenakoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ebema꞉ iba꞉te la꞉ Godokono tabamo tudila꞉oma꞉ danaletanakoma꞉na꞉, modobola la꞉ na꞉tudila꞉onakiyala꞉, wiyasiya la꞉le ibino iyaiya ilukuli tanalo dulama꞉ema la꞉ ibi akoibamilatela꞉la꞉, mabu iba꞉te epetapi kawonomamo analenaka wadewade tanalo kosiyodilolema꞉, wiyasiya nanitabo tanalo puliyala, iba꞉te ebe atu wadewade tanalo kosiyodilolenakoa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Numa꞉la꞉, iba꞉te ibino totomu tabamo epatamo iyaiya mibomibo tanalo ikalamenaka, iyo, ibino totomu tabo ebe epate mibomibo inamabu okolamo dowaguatena eba kunula. Ebema꞉ iba꞉te epono mibomibo dulaema꞉na꞉ walubi tanalo da꞉pesonomo idi kiyatinakoa꞉, koto makupiolete gito lamota꞉onanaka. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ega꞉walo ibi ubi kawonomola epate ibino unu tama eba ulamelelamelo ibi wadewadepima꞉ kegelama꞉. Ebema꞉ Godokono Buka apuapuno tabo iba꞉te egege pepamo akulolete ibino wato kaliamo ebo matuolamolenaka, ega꞉walo ibino watubino kalikuno apuapu iba꞉te baelamu a꞉deote ebo osiyodilolenaka. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ibi ubi kawonomola soliyomu osiyodilo tetelo kawokawo ilukuli bailo ilukulite ka꞉pola꞉nama꞉, ega꞉walo ibi ubila a Yu epono balidi ibilamole moto gulo kawokawo dubuno ilukuli bailo kilukulima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Iyo, ibi ubila olowame bailo epate ibi ulamete ebo kowalogolema꞉, ega꞉walo ibi ubila epate ibi iyatulamepima꞉ keka꞉la꞉ima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ebene Ya꞉sute ebe waloma꞉tapiatamo walo na꞉kegiya, “Modoboa꞉ epo epetapiate la꞉tamo iyatulamepima꞉ gelama꞉, mabu nanitabola, la꞉ bilibilinomo kapiya alailamelata ega꞉walo na la꞉imano kapiya Iyatulamedawanomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ega꞉walo me opolo la꞉ lumagi idi la꞉imano nabiwima꞉ akomida꞉la꞉, mabu la꞉imano kapiya Nabiwinomo Unu Duliyomololo bokolina. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ega꞉walo modoboa꞉ epo epetapiate la꞉tamo watowatopima꞉ gelama꞉, mabu na Kelisote la꞉imano kapiya Watodawanomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ebema꞉ kebe lumagite kawodawama꞉ eda꞉ma꞉ ubi diyatimene, modobola ebete la꞉imano wiya꞉ wokodawama꞉ neda꞉mene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","mabu kebe lumagite ebe a꞉ka꞉tuwa꞉ ebe kawoma꞉ da꞉midimene Godote ebe da꞉pesoma꞉ ka꞉midimene, ega꞉walo kebe lumagite ebe a꞉ka꞉tuwa꞉ ebe da꞉pesoma꞉ da꞉midimene Godote wiyasiya ebe kawoma꞉ ka꞉midimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ebene Ya꞉sute walo na꞉kegiya, “Godokono Totomu iyatulamepi ega꞉walo Pa꞉lisi tanebapi, la꞉ walone kuba wiya kawonomo kelaemamota, mabu la꞉ mena netewa epolata! Epate Godokono Kawo Elawodawano duliyomolamo opila꞉oma꞉ da꞉pelamenaka, la꞉le wiyasiya ibino gabo mopilamenamata. La꞉ a꞉ka꞉tuwa꞉ opila꞉oma꞉ ubia꞉nola, ebema꞉ la꞉ ibi atumu na꞉kodiyobolenamata! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Nanitabola, Godokono Totomu iyatulamepi ega꞉walo Pa꞉lisi tanebapi, la꞉ mena netewa epolata! “La꞉le amoleamoleno inamabu a꞉da꞉ elemasigi tanalodo eba uwatelo ebo opoliyalelamenakomata, ebene la꞉le ebe tanalo kuba꞉noma꞉ gelalo tolama꞉wete Godotamo balidi eba nibilamolelo ga꞉ga꞉ga꞉ga꞉ towetowe tabo ebo negelanakomata, mabu la꞉ ubila epate la꞉imano tanalo umilo la꞉ wadewadepima꞉ kegelama꞉. Ebema꞉ nanitabola, la꞉le kuba wiya kawonomo kelaemamota! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nanitabola, la꞉ Godokono Totomu iyatulamepi ega꞉walo Pa꞉lisi tanebapi, la꞉ kuba wiya kawonomo kelaemamota, mabu la꞉ mena netewa epolata! “La꞉ kewa꞉ kolomolo ega꞉walo opo kawonomolo amamago wapata꞉lamenamata kapiya lumagi idi lawa꞉wete la꞉imano tanebadawama꞉ ka꞉mida꞉ema꞉, ebene ebe oli lumagite la꞉ eba ibamilatelelo atu iyaiya kuba tanalo osiyodilolete wiyasiya ebeno kubate la꞉ bilibilinomono kuba kodoilimene. Ebema꞉ nanitabola, la꞉ bilibilinomate kapimiya Ela Opamo ka꞉niwitiomamota! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Eiye, la꞉ piyate kuba gabo diyatulama꞉wenama, la꞉ ebe balidi tamiopi dubulata! “La꞉ kuba wiya kawonomo kelaemamota, mabu la꞉ ma kunu gelanakomata, ‘Potele Godoko Amamateno Motono mailamo kiyawaote, ebete ebe tabo walo dakadikamidalemene, ebe tanalo kubanoa꞉. Wiyasiya ebete atu tabo Godokono Motono golodo inamabuno mailamo da꞉kiyawaomene, ebete ebeno tabo kodakodakobi midite walo akadikamidalemene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nanitabola, la꞉ balidi tamiolamepi dubula ega꞉walo la꞉ daedale wokiagopilata! Godoko Amamateno Motono talena kawonomola, wiyasiya moto gulo ditana ebe golodo inamabuno talena kawoa꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ega꞉walo la꞉ tanalo idi ma kunu gelanakomata, ‘Potele Godoko watidilono patapatano mailamo kiyawaote, ebete ebe tabo walo dakadikamidalemene, ebe tanalo kubanoa꞉. Wiyasiya ebete ebe patapata unulo ditana ebe kalimagono inamabuno mailamo atu tabo da꞉kiyawaomene, ebete ebeno tabo kodakodakobi midite walo akadikamidalemene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“Nanitabola, la꞉ balidi tamiolamepi dubulata! Godoko watidilono patapatano talena kawonomola, wiyasiya ebe unulo ditana ebe kalimagono inamabuno talena kawoa꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","La꞉ nolowiala꞉, ebe patapatate Godoko watidilonoma꞉ itana, ega꞉walo epate patapata unamo dalomonaka ebe kalimagono inamabuate atumu Godoko watidilonoma꞉ ka꞉pola꞉na. Ebema꞉ lumagite talena patapatano mailamo da꞉kiyawaomene ebete ebeno tabo walo akadikamidalemene, ega꞉walo idawate talena kalimagono inamabuno mailamo da꞉kiyawaomene ebete atumu ebeno tabo walo akadikamidalemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nanitabola, aimano Kawo Talena Godote ebeno Amamateno Motolo okolina, ebema꞉ lumagite Godokono talena mailamo da꞉kiyawaomene ebete ebeno tabo walo akadikamidalemene, ega꞉walo idawate Godokono Motono mailamo da꞉kiyawaomene ebete atumu ebeno tabo walo akadikamidalemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ega꞉walo me tanalo idila, Godokono Unu Duliyomololo ebete ebeno Kawo Elawodawano okoli bailo bokolina. Ebema꞉ lumagite Unu Duliyomolono mailamo da꞉kiyawaomene ebete ebeno tabo walo akadikamidalemene, ega꞉walo idawate Kawo Elawodawa Godokono mailamo da꞉kiyawaomene ebete atumu ebeno tabo walo akadikamidalemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nanitabola, Godokono Totomu iyatulamepi ega꞉walo Pa꞉lisi tanebapi, la꞉ kuba wiya kawonomo kelaemamota, mabu la꞉ mena netewa epolata! “La꞉ la꞉imano pali inamabu bilibilinomo magumulo teni apuapu eba anagilamolelo Godotamo ebeno apu wadenomamo ikameonakomata. Ebe tanalo magumulo la꞉ kapiya tanalo da꞉pesonomo kawotawenakoa꞉, wiyasiya Godokono kawokawo totomunomo osiyodilolema꞉ la꞉ wadenomamo kemalagidilawena꞉. Ma kunu la꞉ epagodolo tuputupulo kilukula꞉wena꞉, ega꞉walo la꞉le ibi nilakapolo kemalagidilola꞉wena꞉, ega꞉walo la꞉imano osiyodilole tanalodo Godokono nanitabo tanalo kawokalima꞉wena꞉. Ebema꞉ modobola la꞉ ebe kawokawo tanalo nosiyodilolenala꞉ ega꞉walo atu tetelo egege tanalo osiyodilolema꞉ akododolomatila꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Eiye, la꞉ piyate gabo kubanu diyatulama꞉wenama, la꞉ ebe balidi tamio dubulata! Ebema꞉ la꞉imano osiyodilo tanalo ma kunula, la꞉ obo nio tetelo la꞉ dopamo obo eba wadipapalamiolelo egege inamabu umagago balamo alomonakomata, wiyasiya la꞉imano kalili magumulo da꞉pola꞉na ebe kawokawo abale inamabu ulamea꞉no obago gito nionakomata! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nanitabola, Godokono Totomu iyatulamepi ega꞉walo Pa꞉lisi tanebapi, la꞉ kuba wiya kawonomo kelaemamota, mabu la꞉ mena netewa epolata! La꞉le la꞉imano kalili ega꞉walo meleki unu apu ukulalenakomata, wiyasiya la꞉imano tepo magumulo da꞉pola꞉na ebe tanalo kukulala꞉wenakoa꞉, ebema꞉ la꞉le pilo gabodo ega꞉walo kateneno ubi gabodo dosiyodilola꞉wenakoma, ebe kawokawo kuba tabokaonomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ebema꞉ a꞉ma꞉ Pa꞉lisi balidi tamiodawa, modobola a꞉ma꞉ kalili magumu dopamo ukulawete ebene bala atumu na꞉kukuliye! Ebe gabo kapiyado a꞉imano daleyate kolopoligomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nanitabola, Godokono Totomu iyatulamepi ega꞉walo Pa꞉lisi tanebapi, la꞉ kuba wiya kawonomo kelaemamota, mabu la꞉ mena netewa epolata! “Iyo, a꞉elaopino bobo baino piki epate wadewade tita꞉gonoma꞉ da꞉midilinaka, la꞉ eba kunula mabu unute wadenomamo pola꞉na wiyasiya piki mabulo epono goa abale tabokaote pola꞉na! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nanitabola, eba kunu epate la꞉imano unu tama eba ulamelelamenalo la꞉ tuputupupima꞉ ka꞉la꞉minata, wiyasiya la꞉imano tepo magumulo mena netewa tanalo ega꞉walo kuba osiyodilole tanalate la꞉godolo tabokaote pola꞉na.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ya꞉sute tabo moga꞉melo walo na꞉kegiya, “Godokono Totomu iyatulamepi ega꞉walo Pa꞉lisi tanebapi, la꞉ kuba wiya kawonomo kelaemamota, mabu la꞉ mena netewa epolata! “Numa꞉la꞉, la꞉imano ewoniate Godokono woki awokalimipi danakapulamenakiya, la꞉ me tetelo ebe Godokono tuputupu wokopi unamo eba wadipalatelelo ibino bobo bai wadenomamo osiyodilola꞉wete kaiyakaiya ebo amionakomata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ega꞉walo atu tetelo la꞉ na꞉kegelanakomata, ‘Aimano ewoniate dilukulinamiya, a ebe tetelo iba꞉go nilukulinataleka꞉, ale Godokono woki awokalimipiatamo walubi eba iyatilo aimano wadewade osiyodilole tanalodo ibino igilo ba꞉mula꞉lelamiyana꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ao, la꞉le atumu ibi banakapulama꞉wiyana꞉! Numa꞉la꞉, la꞉ a꞉ka꞉tuwa꞉ la꞉imano tabamo la꞉imano kuba woki awokalilamenakomata, iyo, la꞉ ewonino gudilata! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ebema꞉ la꞉imano ewoniate dowagilimiya, modobola la꞉ ibino kuba kawonomo opoliyawete la꞉imano kuba wiya Godogodone nelawiyala꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Eiye, la꞉ kaluno gudilata, iyo, la꞉ bu kalulata, ebema꞉ la꞉ Ela Opono wiya tanalone keba kunu nakalautiaema? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Nale la꞉ nanitabonomolo analemata, nale Godokono woki awokalimipi ega꞉walo ebeno mulopi dubu ega꞉walo ebeno nani Totomu iyatulamepi la꞉tamo kapalibolemamo. Wiyasiya la꞉le ibi epetapi kewamo eba tupuguilamelo kanakapulaemamota, ega꞉walo la꞉le epetapi la꞉imano balidi ibilamole motolo pa꞉ka꞉pa꞉ka꞉mo ka꞉na꞉ma꞉ga꞉tiolemamota, ebene naimano wokopiate la꞉imano temeteme ikalame magumune duliyomolo ida꞉mo danalautioma꞉na꞉, la꞉le ebamo nemaimiawete ibi walo duliyomolo ida꞉mo ka꞉ka꞉na꞉ma꞉talemamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ebema꞉ la꞉le kuba wiya kelaemamota, mabu me opono wagilimi mabune la꞉le Godokono woki awokalimipi anakapulamenakimata. Tuputupudawa A꞉ibolokono kalimate opamo deka꞉ka꞉liya, ebe tanalo wagilimi mabula. Ebene la꞉le tuputupu wokopi epetapi bilibilinomo anakapulama꞉wete, uwomu tetelo Godoko Amamateno Motolo la꞉le Balakayakono gudu Sekalayako ebo kanakapumiyamata, iyo, ebete ebe Motono Talena Bailo ega꞉walo Godotamo kalimagono ikameo bai tetenomolo eba utitalo, la꞉le ebe kubanomamo anagalimiyamata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“Ebema꞉ na la꞉tamo nani tabonomo gemo, me tete epatamo ebe kuba bilibilinomono wiyate nanitabolo ka꞉pemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ebene Ya꞉sute walo na꞉kegiya, “O Yelusalema, Yelusalema! A꞉ma꞉le Godokono woki awokalimipi anakapulamenakota, ega꞉walo ebete a꞉ma꞉ kowalubitama꞉ dapalibolenako, a꞉ma꞉le ibi nokolamo mapelama꞉welo akanakapulamenakota. Tete geyageyanomolo na ubi iyatinaimo a꞉imano epo naimano etakamo kitakeamidalema꞉, kakabate ebeno gudi ditakeamidalenako eba kunu, wiyasiya a꞉ma꞉ ubia꞉noma꞉ eda꞉namiyata! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ebema꞉ umu numita꞉, a꞉imano duliyomolote kubanomo ka꞉kubamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nale a꞉ma꞉tamo negemo, a꞉imano epate na tete geyageyanomolo a꞉kunaema꞉na꞉, wiyasiya a꞉imano walonepiate Godotamo ma kunu degelama꞉na꞉, ‘A꞉imano mailago da꞉pita, ale ebe unamo kadipatemalema꞉!’ ebe tetelo nale walo da꞉ka꞉pemo iba꞉te na ebo kunaema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ebene Ya꞉sute Godoko Amamateno Iya Moto atepate eba tolo, ebe waloma꞉tapiate ebetamo pelamete ebe kawokawo motono tanaloma꞉ ebo paniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ya꞉sute wiyasiya iba꞉tamo negiya, “La꞉ me inamabu bilibilinomo na꞉kulama꞉witama? Na la꞉tamo nani tabo gemo, walone me motono tanaloma꞉ nokola idite idi unulo a꞉ka꞉pola꞉nama꞉na꞉, mabu gowelaopiate nokola bilibilinomo mapitaolete opamo iyalekenomo ka꞉piyalekema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ebene Ya꞉sute Olibi Kewakewa Unu Damelalo eba okolitalo, ebe waloma꞉tapi a꞉ka꞉tuwa꞉ ebetamo pelamete na꞉pegeliya, “A꞉ma꞉le a nanaa꞉, Godokono Moto kubaimi tanalote kebe tetelo na꞉ka꞉pemaigamene? A꞉ma꞉le me opamo walo da꞉ka꞉pa꞉emene, ebe tanalo ega꞉walo me opono uwomu tanalono tetema꞉ a beda꞉ anoano tanalote na꞉kiyatuaemene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ya꞉sute wiyasiya iba꞉tamo negiya “La꞉ nanisiwale. Lumagi idite la꞉ demasigilitamene, la꞉ ebeno tabo ako-olowiala꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","mabu dubu bilibilinomo epetapiate naimano mailamo pelamete ka꞉pegelama꞉na꞉, ‘Na ebe Kelisotela!’ ebene iba꞉te epo bilibilinomo ma kunu eba pemasigiolelo iya gabamo ebo kemagatalema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ega꞉walo la꞉le iyaiya opo epono gowelao tanalo ega꞉walo ibino gowelaoma꞉ nopo iyati tanalo kolowiomamota. Ebe tetelo la꞉le la꞉imano woki kodakodailama꞉wete akotoletoleala꞉, mabu me tanalate nanitabolo ka꞉pemaimioma꞉na꞉ wiyasiya ebe tete ebe uwomu tetea꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nanitabola, opo epetapino epate opo epetapino epago ka꞉gowelaoma꞉na꞉, iyo, opo idite opo iditamo gowela tanalo kosiyodilomene, ebene iyaiya duliyomolo epetapilo epate baea꞉no kilukulioma꞉na꞉ ega꞉walo mumulate iyaiya opo bilibilinomamo ka꞉pelaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Numa꞉la꞉, kamiyalete gudu laema꞉ temeteme dowagilimi, me tanalo bilibilinomo eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ebe tetelo iba꞉te la꞉tamo kawokawo temeteme eba ikalamelo la꞉ elawamo uwatetate anakapulaema꞉ kemagatalema꞉ta, ega꞉walo na mabuma꞉ opo bilibilinomono epate la꞉tamo ka꞉dowaoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ebene epo epetapi bilibilinomate ibino nanitabokobi midi magumulo agowa eba ukamidaolelo, iba꞉te ibino namutupiatamo dowaote diya gabodo ibino mailo ibi anakapulamepiatamo kowatama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ega꞉walo Godokono mailamo a꞉da꞉ tabo kiyawaopiate ka꞉pemaimioma꞉na꞉ epo epetapi bilibilinomo kuba gabamo kemagatalema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ebe tetelo kuba osiyodilole tanalote kawonomoma꞉ keda꞉mene, ebema꞉ epono tepo magumulo nilakapo kimalagidilo tanalote gibagibanomoma꞉ keda꞉oma꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","wiyasiya numa꞉la꞉, kebe lumagite kodakodalo utite uwomuamo da꞉nemaigamene, Godote ebeno igilo ka꞉mula꞉emene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ebema꞉ Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalono Wade Tabo ebeno wokopiate dopamo me opo kawonomolo ka꞉kiyawaoma꞉na꞉ iyaiya opono epo bilibilinomate kolowioma꞉, ebene me opono uwomu ebo ka꞉pemaigamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Na Ma꞉tiyute buka ka꞉la꞉mioledawatamo negemo, a꞉ma꞉ me tabo Ya꞉sute degiya wadenomamo niyatawa. Ya꞉sute tabo moga꞉melo walo na꞉kegiya, “Godokono woki awokalimidawa Da꞉niyolote dopamo degiya ebe tanalote nanitabolo ka꞉pemaigamene, ebema꞉ Godokono Moto kubaimidawate ebe talena bailo utitalo la꞉le ebe duma꞉ema, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ebe tetelo modobola Yudiya opo epate unuunu damelamo nalautioma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iyo, moto tanatimilo dokolitamene, ebe lumagite moto guamo a꞉ka꞉nopegamene ebeno inamabu uwatema꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ega꞉walo tumulo woko dosiyodilutamene, ebe lumagite walo motamo a꞉ka꞉toamene ebeno lubudino kaliku laema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Numa꞉la꞉, lamitulamitu ega꞉walo nono dikalamena ebe kamiyala꞉tamo ebe egelate kubanomoma꞉ keda꞉mene! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ebema꞉ modobola la꞉ Godoko na꞉toweomiyala꞉, la꞉imano alautio tanalote gibagiba tetelo o wokoa꞉ talena egela tetelo akopemaigala꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","mabu ebe tetelo kawokawo temetemenomate nanitabolo ka꞉pemaimioma꞉na꞉. Numa꞉la꞉, me opo wagilimi mabune wagilimite ka꞉lo me teta꞉mo pemaiga, ebakobako temetema꞉te dopamo ka꞉pemaimiya꞉, ega꞉walo walone tetelo ebakobako temetema꞉te walo a꞉ka꞉pelaema꞉na꞉, iyo, iba꞉te kapiya tetenomolo ka꞉pemaimioma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Me tanalo nanitabola, Godote ebe tete gopowaimia꞉no lumagi idite me opolo igilolo a꞉kokolinamene, wiyasiya ebete deka꞉la꞉mioliya ebe epo nilakapoilamelo tete ka꞉gopowaimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ebe tetelo lumagi idite la꞉tamo ma kunu degemene, ‘Numa꞉la꞉, Godokono Alibodawa Kelisote malo bokolina!’ o, ‘Ebete ebolo bokolina!’ la꞉ nanitabokobi akomida꞉la꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","mabu elemasigi Kelisoma꞉ eda꞉opi ega꞉walo naimano mailamo a꞉da꞉ tabo kiyawaopi, iba꞉te pemaimiote iyaiya anoano tanalo kawokawonomo kosiyodilolema꞉na꞉. Iyo, ibi ubila ebe osiyodilole tanalamo Godote deka꞉la꞉mioliya ebe epo iya gabamo kemagatalema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Numa꞉la꞉, me tanalate pemaimioa꞉no nale la꞉ dopamo analemata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ebema꞉ iba꞉te la꞉tamo ma kunu degelama꞉na꞉, ‘Numa꞉la꞉, Kelisote bulu opolo bokolina!’ la꞉ ebamo akotolama꞉la꞉. Ega꞉walo iba꞉te da꞉kegelama꞉na꞉, ‘Numa꞉la꞉, ebete lumagi idino motolo opegate ba꞉luta!’ la꞉ nanitabokobi akomida꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nanitabola, molete da꞉la꞉uwa꞉midamene ebe tetelo egelate tobolo unu kawonomo eba pukuilamelo alote apune wagilimite apuamo gito ka꞉petomene, ebema꞉ na Epono Naniwite walo da꞉ka꞉pemo naimano pe tanalote eba kunu kitanamene, iyo, me opo epo bilibilinomate naimano pe tanalo kuima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Me tanalo ebe nanitabola, abale inamabute kebolo kitanamene, waliate aleola꞉go ebamo ka꞉guditama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ebe kawo temeteme tetete dolopoligomene, ebe tetenomolo egelate kidokomene ega꞉walo saganate a꞉ka꞉pukuilaemene, iyo, mawela꞉te tobolo unune opamo ka꞉pa꞉gudima꞉na꞉ ega꞉walo tobolo ununo elawoelawo inamabuate kalela꞉oma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ebe tetelo Epono Naniwino elawo awokalimino anoano tanalote tobolo unulo ka꞉pemaigamene, ebene me opono iyaiya epo bilibilinomate kawo tola꞉go kiimima꞉na꞉, mabu Epono Naniwite tobolo unune eba piwisigalo iba꞉te ebe ebo kuima꞉na꞉, ebete ebeno elawago ega꞉walo alo kawonomago ka꞉pemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ebene ebeno nopodawate tutele kawonomamo eba molelo, ebete Unu Duliyomolono nopopi epetapi iyaiya opo bilibilinomamo kapalibolemene, Godote deka꞉la꞉mioliya ebe epo me opo apune apune ka꞉puwatema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“La꞉ umei kewano tanalone me tanalo idi wadenomamo niyatawala꞉. Katomono wuiate pemaimite olioli paa da꞉mogoiamidalema꞉na꞉, ebe tanalote la꞉ kiyatulamema꞉ta ulamano tete ebe netatali, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ebema꞉ la꞉le me temeteme tanalo bilibilinomo dulama꞉ema, la꞉ kiyatawaomamota Epono Naniwino pe tete tatalila, ebe gigiyudo opegama꞉ pe. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na la꞉tamo nani tabo gemo, me tanalo bilibilinomate dopamo ka꞉pemaimioma꞉na꞉, walone me tete epate ebo ka꞉elaoma꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","iyo, me opo ega꞉walo tobolo unu iba꞉te kolopoligoma꞉na꞉, wiyasiya naimano tabote a꞉kolopoligomene, uwomua꞉ tetelo bitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Numa꞉la꞉, epate ebe Kawo Egelano tete iyatawa꞉, Unu Duliyomolono nopopi ega꞉walo Godokono Gudu iba꞉te iyatawa꞉, Nabiwi Godo kapiyate iyatawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nowako tetelo kebako tanalote ka꞉pemaigiyale, Epono Naniwite walo da꞉ka꞉pemene ebe tetelo atu tanalote ka꞉ka꞉pemaigamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mabu obote pea꞉no iba꞉te ebe tetelo bae naota ega꞉walo elawo da꞉imi obo kawonomamo niota, dubate kamiyale uwatoleta ega꞉walo kamiyala꞉te dubu uwatoleta, iba꞉te eba kunu eba wagelenalo Nowate kawo peamo ebo opegiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ebe tetelo iba꞉te kiyatawaonamia꞉ obo kawonomote odolote ibi bilibilinomo danakapulaemene, ebema꞉ Epono Naniwite walo da꞉ka꞉pemene ebe tetete eba kunu kitanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ebe tetelo dubu netewate tumulo dowapaitama꞉na꞉, Epono Naniwite pete idi eba pelawelo idi ebo katepamene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ega꞉walo kamiyale netewate bae delapautama꞉na꞉, ebete pete idi eba pelawelo idi ebo katepamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ebema꞉ la꞉ olowiolo nilukuliniyala꞉, mabu la꞉ iyatawa꞉ la꞉imano Kawodawano pe tete. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ega꞉walo me tanalo idi na꞉kemalagidilala꞉. Moto namutudawate pilo lumagino pe tete diyatawamene, ebete ebe idoko kawonomolo ebe teta꞉mo kolowionamene, mabu ebe ubia꞉nola pilo dawate ebeno motamo ka꞉popegama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ebema꞉ la꞉ atumu nolosiyodilala꞉, mabu diyala, la꞉ olowioa꞉no eba ilukulinalo Epono Naniwite ebo da꞉ba꞉pemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ebene Ya꞉sute walo na꞉kegiya, “Namutudawatamo da꞉tuduwatanako ebe mulo wokodawano tanalo keba kunula꞉ka꞉? Nanitabola, namutudawate ebe lawete wokopi epetapi ulamedawama꞉ kiyatimene, ma kunu ebete ibino bae nao tetelo iba꞉tamo bae kikalamolemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ebene ebe mulodawate woko wadenomamo eba osiyodilonalo, ebeno namutudawate pete ebeno tanalo da꞉puimene, ebe wokodawate kawonomamo kekalakalamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na la꞉tamo nani tabo gemo, namutudawate ebe mulo wokodawano tanaloma꞉ eba pekalakalalo, ebete ebe ebeno inamabu bilibilinomo ulamedawama꞉ kiyatimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Wiyasiya ebe wokodawate kuba woki lawete ebeno tepo magumulo ma kunu degemene, ‘Naimano namutudawate tete geyageyadopolo nokolina, samamo ka꞉pena꞉,’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ebe tetelo ebete woko osiyodiloa꞉no kuba osiyodilolepi epetapiago ebeno namutudawano bae kawiya naote elawo da꞉imi obo ebo ka꞉nioma꞉na꞉, ebema꞉ ebete daedalema꞉ eda꞉te wokopi epetapi alukole ebo kowagilimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ebene ebe daedale wokodawate olowioa꞉no eba okolinalo ebeno namutudawano pe tanalo a꞉kiyatawamene. Ebe tetelo namutudawate pete ");
INSERT INTO knv_fly_river_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","daedale wokodawa kawonomamo panagalimiote mena netewa epago kanalibomene ebeno kuba wiya ka꞉nelaema꞉, ebe temeteme bailo iba꞉te lalo eba noliomolelo kawonomamo kiimima꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ebene Ya꞉sute walo na꞉kegiya, “Ebe egelalo Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalote ma kunu kitanamene. Dubu idite oli kamiyale delawi, ebe tetelo teni buwelemela꞉te ibino wuiki alo uwatete motone nemaimiote eba꞉go soliyomu baiamo tolaema꞉ nemakopelitiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ibi magumulo paibu buwelemela꞉te daedalema꞉ eda꞉iya, wiyasiya paibu epetapiate wade wokiago tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ma kunu daedale buwelemela꞉te ibino alo dowatiya iba꞉te modobo obago kowatia꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","wiyasiya wade wokiago da꞉tolamiya ebe buwelemela꞉te modobo obo iyapote ibino alo ega꞉walo obo ebo watiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Didokoni dubute soliyomu baiamo samamo ka꞉pemaigania꞉, ebema꞉ buwelemela꞉te tete geyageyalo nipo demakopeleniya iba꞉te gito laoniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Sele tetenomolo lumagi idite ma kunu gepateni, ‘Ebe dubu na꞉pe! La꞉ bilibilinomate eba꞉go alugoma꞉ na꞉pelama꞉la꞉!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ebe tetelo ebe buwelemela꞉te maimionate ibino alo pioma꞉ eba wagelenalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ebene paibu daedale buwelemela꞉te ibino wade wokiago namutupiatamo negelaniya, ‘La꞉imano alo obo sa꞉sa꞉ apuapu atamo ikaeaema꞉ modobola꞉ka꞉? Aimano alote tete tatalila ka꞉egaoma꞉na꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Wiyasiya wade woki buwelemela꞉te iba꞉tamo negelaniya, ‘Ao, ale la꞉tamo dikalamoletamene, a bilibilinomate modoboa꞉noma꞉ keda꞉omalema꞉. Modobola la꞉ tolama꞉wete olowame motone obo na꞉niyapoala꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ebene daedale buwelemela꞉te obo olema꞉ da꞉tolameniya, dubute soliyomu baiamo ebo pemaigani. Ebe tetelo paibu buwelemela꞉te dopamo wade wokiago demakopeleniya, iba꞉te eba꞉go soliyomu motamo nodolonate moto namutudawate gigiyu gito pemopini. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ebene paibu daedale buwelemele epetapiate walone da꞉pelameniya, iba꞉te gigiyu niyakabamo putitatanate moto namutudawa ma kunu pananiya, ‘Aimano Kawodawa! Gigiyu na꞉pa꞉iyamidaeama꞉!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Wiyasiya ebete negeni, ‘Ao, na la꞉imano tanalo iyatawa꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ebene Ya꞉sute uwomu tabo ma kunu giya, “La꞉ olowiolo nilukuliniyala꞉, mabu Epono Naniwino egela ega꞉walo tete la꞉ kiyatawawena꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ebene Ya꞉sute walo na꞉kegiya, “Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalote ma kunu kitanamene. Kawo dubu idite mulu opamo eba tolo ebeno wokopi ebetamo ka꞉la꞉mite, iba꞉te ebeno inamabu ega꞉walo mani wadenomamo kulamelemenama꞉ iyaiya ikalamolete ebo tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ebe tetelo ebete iditamo 5,000 mani ikamiya, ega꞉walo iditamo 2,000 mani, ega꞉walo iditamo 1,000 mani, ibino wokiago modobolo eba kunu eba ikalamolelo, ebete ibi gito miyapiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ebene 5,000 mani delawiya ebe dubute tonomo tote bisnisi woko idi eba nosiyodilolo 5,000 mani idi ebo nosiyodiliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ega꞉walo 2,000 mani delawiya ebe dubute atumu eba ka꞉nowagelelo 2,000 mani idi nosiyodiliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","wiyasiya 1,000 mani delawiya ebe dubute tote damela nobobote ebeno kawodawano mani gito nowaminiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ulama epetapi da꞉petolamiya ebe wokopino kawodawate walo ka꞉pete iba꞉go kapimiya ibino mani uwomu ebo peka꞉la꞉miolelamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ebene 5,000 mani delawiya ebe dubute pete 10,000 mani eba pawokalimilo na꞉pegiya, ‘Kawodawa, numa꞉. A꞉ma꞉le natamo 5,000 mani ikanamiyata, wiyasiya naimano woko magumulo 5,000 mani idi walo da꞉kosiyodilimo, mela bitana.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ebeno kawodawate ebetamo negiya, ‘Oe! A꞉ma꞉ wade wokodawalata ega꞉walo wade tuputupudawalata! A꞉ma꞉ da꞉peso tanalo wadenomamo osiyodiliata, ebema꞉ na wiyasiya a꞉ma꞉ naimano kawokawo tanalo epetapi ulamedawama꞉ ka꞉midimamota. A꞉ma꞉ naimano kalakala soliyomu baiamo na꞉popega.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ebene 2,000 mani delawiya ebe dubute pete na꞉pegiya, ‘Kawodawa, numa꞉. A꞉ma꞉le natamo 2,000 mani ikanamiyata, wiyasiya naimano woko magumulo 2,000 mani idi walo da꞉kosiyodilimo, mela bitana.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ebeno kawodawate ebetamo negiya, ‘Oe! A꞉ma꞉ atumu wade wokodawalata ega꞉walo wade tuputupudawalata! A꞉ma꞉ da꞉peso tanalo wadenomamo osiyodiliata, ebema꞉ na wiyasiya a꞉ma꞉ naimano kawokawo tanalo epetapi ulamedawama꞉ ka꞉midimamota. A꞉ma꞉ naimano kalakala soliyomu baiamo na꞉popega.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ebene walogabodawate 1,000 mani delawiya, ebete pete na꞉pegiya, ‘Kawodawa, na iyatawala a꞉ma꞉ genegene dubunomolata. Epetapiate inamabu damionaka a꞉ma꞉ ebe inamabu gito ba꞉petapionakoma꞉ta, ega꞉walo iba꞉te kikopu ibino paliamo daminaolenaka a꞉ma꞉ nolo tetelo gito ba꞉puwatenakoma꞉ta a꞉ma꞉le a꞉ka꞉tuwa꞉ kenaoaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ebema꞉ a꞉ma꞉ da꞉toawiyala, nale a꞉ma꞉ tolemelo a꞉imano 1,000 mani damela magumamo gito nowaminiyamo. Mela, me ebela. A꞉imano inamabu na꞉kelawa꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ebeno kawodawate wiyasiya ebetamo negiya, ‘A꞉ma꞉ kuba damola wokodawanomolata! A꞉ma꞉ tabo ma kunu egeata, epetapiate damionaka nale ebe inamabu gito ba꞉petapionakomo, ega꞉walo iba꞉te kikopu daminaolenaka nale nolo tetelo gito ba꞉puwatenakomo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ebema꞉ mabu keleka꞉ a꞉ma꞉le naimano mani baneka wokopiatamo ka꞉nikalama꞉wiya꞉? Iba꞉te mani uwatete woko idi nosiyodilotaleka꞉ kawodopoma꞉ beda꞉na꞉, ebene nale pete a꞉ma꞉le natamo atu mani wiyasiya kele unudopamo walo ba꞉kikanama꞉wena꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ebene kawo dubute ebeno opopiatamo negiya, ‘La꞉ ebeno 1,000 mani laema꞉wete 10,000 maniago dubutamo nikama꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mabu kebe lumagigodolo wadewade woki da꞉pola꞉na, idawate ebetamo wadewade tanalo bilibilinomo ikameote ebeno tepo magumu ketabokaimene, wiyasiya kebe lumagigodolo wadewade woki pola꞉na꞉no, ebegodolo kebe kapiyakapiya tanalate da꞉pola꞉na idawate ebegodone walo ka꞉kuwatemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ebema꞉ me damola wokodawa idoko magumamo gito na꞉neba꞉idilala꞉, ebolo ebete epetapiago lalo eba noliomolelo kawonomamo kiimima꞉na꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ebene Ya꞉sute walo na꞉kegiya, “Epono Naniwite ebeno alo kawonomago ega꞉walo Unu Duliyomolono nopopiago da꞉pemene, ebe tetelo ebete ebeno Kawo Elawodawano okoli bailo ka꞉pokolitamene epono tanalo kapanagilamelelaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ebene iyaiya opo epo bilibilinomate ebetamo dapaladabutima꞉na꞉, ebe tetelo ebete ibi bilibilinomo iyaiya kalomomene, sipi-goeogoeo ulamedawate sipi ega꞉walo gautu iyaiya keba kunu kalomonakole eba kunu, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ebene ebete sipi-goeogoeo ebeno tumudi apuamo alomote ega꞉walo gautu-goeogoeo ebeno pele apuamo kalomomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ebe tetelo Kawo Elawodawate tumudi apu epatamo ma kunu kegemene, ‘Naimano Nabiwite wadewadepima꞉ degena, la꞉ ebeno Kawo Elawodawano duliyomolamo na꞉popila꞉la꞉ wadewade tanalo ebolo ka꞉puwata꞉ema꞉. Iyo, ebete me opo osiyodilo tetelo la꞉tamo dosiyodiliya, la꞉ me oli duliyomolo na꞉pelawa꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mabu na bae kapete dunamenaki ebe tetelo la꞉le bae natamo ikanamonenakimata, ega꞉walo na obo kapete dunamenaki la꞉le na obamo owalubininakimata. Nale kapeladawamu la꞉tamo da꞉pemaiganakimo ebe tetelo la꞉le na kalakalago elawenenakimata, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ega꞉walo pupuliono inamabua꞉ tetelo gito da꞉lutanakimo la꞉le kaliku a꞉pulinamenakimata. Gabugabute dunamenaki ebe tetelo la꞉le na wadenomamo unamenanakimata, ega꞉walo kubakubapi epetapiate na idoko motamo diyatininakiya la꞉le na unaema꞉ ebamo a꞉pelamenakimata.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ebe tetelo tuputupupiate wiya tabo Kawo Elawodawatamo kegelama꞉na꞉, ‘Kawodawa, kebe tetelo a꞉ma꞉ bae kapete dumititiyala, ale a꞉ma꞉ umitate bae ebo kikametiyala? Ega꞉walo ale obo kebolo kikametiyala? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kebe tetelo a꞉ma꞉le kapeladawamu da꞉pemaigawiyala, ale a꞉ma꞉ umitate kalakalago ebo kelawetiyala? Ega꞉walo ale wade kaliku kebolo ka꞉pulimitiyala? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kebe tetelo a꞉ma꞉ gabugabute dumititiyala ale walubi tanalo ebo ka꞉piyatiyama꞉? Ega꞉walo epetapiate a꞉ma꞉ idoko motamo diyatitiyala ale kebe tetelo a꞉ma꞉ uima꞉ ebamo ka꞉pelamiyama꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ebene Kawo Elawodawate iba꞉tamo kowaimene, ‘Me na waloma꞉enepi nulama꞉la꞉. Na la꞉tamo nani tabo gemo, la꞉le ibi magumulo lumagi da꞉pesonomotamo mako wade tanalo dosiyodilawenaima, la꞉le natamo osiyodilonaimata.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ebene ebete olobigate pele apupiatamo ma kunu kegemene, ‘Godote la꞉tamo kuba wiya ikalaema꞉ gena, ebema꞉ la꞉ naimano ololo apune na꞉tolama꞉la꞉! Ebete Saitanako ega꞉walo ebeno nopopino tanaloma꞉ a꞉ega꞉ ela iyalo demadiya, la꞉ ebe ela magumamo na꞉tolama꞉la꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mabu na bae kapete dunamenaki la꞉le bae natamo kikanama꞉wenakia꞉, ega꞉walo na obo kapete dunamenaki la꞉le obamo kowalubina꞉wenakia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na kapeladawamu da꞉pemaiganakimo, la꞉le na kalakalago kelawena꞉wenakia꞉, ega꞉walo na pupuliono inamabua꞉ tetelo gito da꞉lutanakimo la꞉le kaliku ka꞉pulinama꞉wenakia꞉. Gabugabute na dunamenaki ega꞉walo kubakubapi epetapiate na idoko motamo diyatininakiya, la꞉le na ka꞉powalubina꞉wenakia꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ebe tetelo iba꞉te ebetamo wiya tabo kegelama꞉na꞉, ‘Kawodawa, a꞉ma꞉ bae kapete o obo kapete kebe tetelo kumititiyala? Ega꞉walo a꞉ma꞉ kapeladawamu o inamabua꞉dawamu atamo kebe tetelo ka꞉pemaigawiyala? Ega꞉walo a꞉ma꞉ gabugabute dumititiyala o epetapiate a꞉ma꞉ idoko motamo diyatitiyala kebe tetelola꞉ka꞉? Ale a꞉ma꞉le eba kunu wagelitalo kumitanakia꞉!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ebete wiyasiya iba꞉tamo kegemene, ‘Na la꞉tamo nani tabo gemo, la꞉le naimano lumagi da꞉pesonomotamo mako wade tanalo osiyodiloa꞉no dilukula꞉wenaima, la꞉le natamo kosiyodilawenamia꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ebema꞉ Ya꞉sute uwomu tabo ma kunu giya, “Nanitabola, ebe kubakubapiate uwomua꞉ Temeteme Opamo eba tolamelo, wiyasiya tuputupupiate uwomua꞉ Igilo Opamo ka꞉tolaema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ebene Ya꞉sute me tabo bilibilinomo kiyawao dolopoligiya, ebete ebe waloma꞉tapiatamo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“La꞉ iyatawalata Aduga꞉la Soliyomu wagilima꞉ netewa egelate nepola꞉na. Ebe tetelo Godote Epono Naniwi epono kotamo kiyatimene, ebene iba꞉te ebe kewamo tupuguimite ebo kanakapuima꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ebe ulamalo Kayapasite Godotamo kalimagono ikameopino Unu Watodawanomoma꞉ eda꞉nami. Ebema꞉ ebe kawo dubu ega꞉walo ebeno opopi elawodubu ega꞉walo Yu epono kawokawo dubu epetapi, iba꞉te ebeno motamo aladabutite ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","tabo ebo iyatiya Ya꞉suko kanakapuima꞉. Ebema꞉ iba꞉te ebe diya gabodo laema꞉ gabo eba waditalo ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","epetapiate wiyasiya negeliya, “A Soliyomu tetelo ebe a꞉kelaema꞉, mabu epate atamo dowaote ago da꞉ba꞉gowelama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ebene Ya꞉sute Betani duliyomololo dubu idi Saimonokono motolo okoliti, ebe dubu dopamo kukulakukulagonola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ya꞉sute bae eba nitalo ebe tetelo kamiyale kapiyate pete, wade nibo ii nokola kalila꞉mo tabokaimi adaete Ya꞉sukono watamo ebo padipanamiya, ebe ii inamabuno wiya kawonomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ya꞉suko waloma꞉tapiate ebe tanalo dumiya iba꞉te dowaote negeliya, “Mabu keleka꞉ ebete wiya kawo inamabu dologala inamabuma꞉ da꞉midi? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","A me ii manima꞉ na꞉na꞉miditaleka꞉ mani kawonomo buwatena꞉, ebene ebe mani nigologolopiatamo gito bikalamolena꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ya꞉sute ibino tabo gela tanalo iyatawate wiyasiya iba꞉tamo negiya, “La꞉le me kamiyale kawiya beda꞉ma꞉ kanawitama? Ebete natamo wade tanalonomo osiyodilo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","La꞉ numa꞉la꞉, nigologolopiate tete geyageyanomolo la꞉go bilukulionama꞉na꞉, la꞉imano ubi tetelo ibi nowalubilinakiyala꞉, wiyasiya na uwomua꞉ tetelo la꞉go a꞉kokolinamo, tete tatalila nale la꞉ ka꞉miyapamamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ebema꞉ nale a꞉ea꞉no tetelo me kamiyalete wade nibo ii naimano apa꞉mo dopamo dadipana, ebe tanalodo ebete gabo osiyodilo naimano ape bobamo iyatima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na la꞉tamo nani tabo gemo, epate iyaiya opo bilibilinomamo Godokono Wade Tabo datanakoma꞉na꞉, iba꞉te me kamiyalete dosiyodilo ebe tanalo malagidilolo ba꞉nikiyawaonakoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ebene Ya꞉sukono 12 waloma꞉tapino taneba magumulo Keliyota duliyomolodawa Yudasite Godotamo kalimagono ikameopino watowatopiatamo tote, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na꞉negiya, “Nale Ya꞉suko la꞉imano kotamo diyatimo, la꞉le natamo beda꞉ wiya na꞉kikanama꞉ema?” Ebe tetelo iba꞉te 30 siliba mani ebo ikamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ebene ebe tetene wagilimite ebete gabo wadiya Ya꞉suko ibino kotamo kiyatima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ebene epate Unamo Maiga꞉ Palowa Bae Soliyomu nao dowagilimiya, ebe egelalo Ya꞉suko waloma꞉tapiate ebetamo pelamete na꞉pegeliya, “Ale Aduga꞉la Soliyomuno nao inamabu kebolo na꞉kosiyodilolema꞉, ale a꞉ma꞉go kapimiya kenaoma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ya꞉sute iba꞉tamo nowamiya, “La꞉ netewapi kawo duliyomolamo toawete aimano namutudawa idi da꞉numa꞉ema, ebe dubutamo ma kunu na꞉negeliyala꞉, ‘Iyatulamedawate ge, naimano olalati pemaiga tanalono tete tatalila, Godokono ubila. Ebema꞉ na ubila a꞉imano motolo nale naimano waloma꞉tapiago Aduga꞉la Soliyomu bae ka꞉penama꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ebene Ya꞉sute ibi keba kunu kanaliyale, ebe waloma꞉tapiate eba kunu nosiyodilote Aduga꞉la Soliyomu inamabu ebo nosiyodiloliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ebene ebe idokolo Ya꞉sute ebeno 12 waloma꞉tapiago bae naoma꞉ dilukuliniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ebe tetelo Ya꞉sute iba꞉tamo negeni, “Na la꞉tamo nani tabo gemo, la꞉imano taneba magumulo idawate na anakapunamepi kowalubilimene na lawenema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iba꞉te tepo mibomibonomoma꞉ eba eda꞉onalo Ya꞉sutamo idawate genaki, idawate genaki, “Kawodawa, nalela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ebete iba꞉tamo nowamini, “Bae kalila꞉mo potele nago koto ka꞉ma꞉ daduba꞉mida, ebe ebe lumagila. Ebete na anakapunamepino kotamo kiyatinimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iyo, ebe nanitabola, Epono Naniwite a꞉eamo ebe na꞉to, Godokono Bukalo tabo ma kunu itana, wiyasiya kebe lumagite ebe anakapumipiatamo dikalaemene, ebe lumagite kuba wiya kawonomo kelaemene. Me ebe mabuma꞉ ebe dubu ebeno menokote ebe alaimia꞉notaleka꞉ ba꞉modobona꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ebene Yudasiko, ebete dopamo Yu watowatopiago nopo diyatiya Ya꞉suko laema꞉, ebete negeni, “Iyatulamedawa, nalela꞉ka꞉?” Ya꞉sute nowamini, “A꞉ma꞉le ebe ebe geata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ebene iba꞉te bae eba naonalo, Ya꞉sute bae lawenate Godotamo kalakala tabo genate ebo wakamioni, ebema꞉ ebete ebe waloma꞉tapiatamo eba ikalamolenalo negeni, “La꞉ uwata꞉wete nenaoala꞉, me naimano apela.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ebene ebete kalili kelawenate, Godotamo kalakala tabo genate iba꞉tamo eba ikalamolenalo negeni, “La꞉ bilibilinomo na꞉niala꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mabu Godote epago milolo kilukulinama꞉ nopo diyatiya, me naimano kalimate ebe nopo kodakodaimina, iyo, me kalimate epo epetapi bilibilinomono kuba egebolelaema꞉ keka꞉ka꞉liyamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nale la꞉ analemata, na me tetelo me da꞉imi obo walo a꞉ka꞉nimo, wiyasiya naimano Nabiwite Kawo Elawodawama꞉ deda꞉na, ebe duliyomololo na oli da꞉imi obo walone tetelo la꞉go ka꞉na꞉niomalema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ebene iba꞉te Godoko amamateno oale alapionate, Olibi Kewakewa Unu Damelamo ka꞉tolamenama꞉ motone gito niwitioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ebe tetelo Ya꞉sute iba꞉tamo negeni, “Ka꞉lo idokolo la꞉ bilibilinomate na katepanemamota, mabu Godokono Bukalo tabo ma kunu itana, ‘Godote sipi-goeogoeo ulamedawa danakapuimene, ebe tetelo ebeno tanebano sipi-goeogoeate iyaiya kalautioma꞉na꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wiyasiya Godote na a꞉ene walo dakadipanatenemene, na Ga꞉lili opamo dopamo ka꞉tomamo. La꞉le na ebolo ka꞉punaemamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ebene Pitate Ya꞉sutamo negeni, “Ibi bilibilinomate a꞉e tolemelo a꞉ma꞉ atepatate dalautioma꞉na꞉, wiyasiya nale a꞉ma꞉ akatepatama!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ya꞉sute ebeno tabo eba wiyanalo negeni, “Na a꞉ma꞉tamo nani tabo gemo, ka꞉lo idokolo kakabate geoa꞉no, a꞉ma꞉ netewa-kapiya teta꞉mo na iyatawa꞉noma꞉ kegema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pitate ebetamo walo na꞉kegeni, “Na a꞉ma꞉go da꞉na꞉emo, nale a꞉ma꞉ iyatawa꞉noma꞉ a꞉kegemo!” Ebe tetelo Ya꞉suko waloma꞉tapi bilibilinomate ebe atu tabo kegelaniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ebene Ya꞉suko ega꞉walo ebe waloma꞉tapi iba꞉te kawo duliyomolone nemaimionate tatali opo ida꞉mo tolameniya, ebe opono mailo Getasemanila. Ya꞉sute ebolo iba꞉tamo na꞉negeni, “La꞉ malo na꞉pola꞉nala꞉. Na me tataliamo tomo Godotamo towetowe tabo ka꞉negema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ebe tetelo ebete Sebedikono gudi Ya꞉imesiko ega꞉walo Yoneko, ibi netewapi ega꞉walo Pitako ebalata towetoweo tabo gela baiamo magatalenate, ebene tepo mibomibo tanalo ega꞉walo woki temeteme tanalo ebetamo kawonomamo ebo pelameniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ebema꞉ Ya꞉sute iba꞉tamo negeni, “Na tepo temeteme kawonomamo iyatawanamo, mako tepo temetemete na anakapuname keba kunula꞉ka꞉ eba kunula. La꞉ malo nago olowiolo na꞉pola꞉nala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ebene ebete kela꞉mo toatepanate, ebeno ololo opamo niyatinate Godotamo ma kunu na꞉towetoweoni, “Naimano Nabiwi, a꞉ma꞉ modoboma꞉ degeaemene, me temeteme kalili nagodone nelawa꞉. Wiyasiya naimano ubia꞉, a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉imano ubila nosiyodila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ebene ebete waloma꞉tapiatamo da꞉peni laonalo pulamenate Pitatamo na꞉pegeni, “Mabu keleka꞉ la꞉le nago tete da꞉pesamo olowioa꞉noma꞉ deda꞉wenama?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ebe tetelo Ya꞉sute ibi nanaleni, “Godotamo olowiolo na꞉towetoweonala꞉, mabu la꞉le Saitanakono kuba gabamo wabuga꞉ta tanalamo da꞉ba꞉gudima. La꞉imano tepo magumulo wade tanalo osiyodiloma꞉ ubila, wiyasiya la꞉godolo osiyodiloma꞉ elawo puliyala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ya꞉sute tete idilo walo ka꞉tonate Godotamo ma kunu ka꞉na꞉towetoweoni, “Naimano Nabiwi, me tepo temeteme kalili a꞉ma꞉ nagodone laema꞉ gabote itana꞉no modobola, a꞉imano ubi ditanamene na ka꞉nimamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ebene ebete ebe waloma꞉tapiatamo walo da꞉ka꞉peni laonalo ka꞉pulameni, mabu ibino balidite uma꞉ na꞉elaolameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ebene Ya꞉sute netewa-kapiya tetelo ibi walo ka꞉miyapanate, dopamo ebete towetowe tabo keba kunu ka꞉negeniyale ebete Godotamo atumu ka꞉negeni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ebe tetelo ebete ebe waloma꞉tapiatamo da꞉ka꞉peni iba꞉tamo na꞉pegeni, “La꞉ ela amiolo walo beda꞉ma꞉ ka꞉kelawenama? Numa꞉la꞉, tete a꞉pe, kubakubapiate Epono Naniwi ibino kotamo nelawa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Iyo, la꞉ nemaimiala꞉, a na꞉tolaema꞉. Numa꞉la꞉, na anakapunamepino kotamo iyatinidawate ebe na꞉pe!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ya꞉sute ebe tabo eba genalo Yudasite ebo peni, Ya꞉sukono 12 waloma꞉tapino taneba magumulo ebe idila. Ebene eba꞉go dubu bilibilinomo epetapiate ibino gowelaono gili ega꞉walo gaubago da꞉pelameniya, ebe dubu ebe Godotamo kalimagono ikameopino watowatopi ega꞉walo Yu epono kawokawo dubu epetapi, iba꞉te dapaliboleniya ebe dubula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nanitabola, Yudasite ibi iyalo ma kunu analeni, “Nale daboeteomo, ebe ebe lumagila. La꞉ ebe samonomamo nelawiyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ebene Yudasite penate, Ya꞉sutamo tonomo tonate ebe nanani, “Iyatulamedawa, niyata!” Ebe tetenomolo ebete ebe ebo aboeteoni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ya꞉sute ebetamo negeni, “Namutudawa, a꞉ma꞉ beda꞉ tanalo osiyodiloma꞉ da꞉pa꞉wa꞉, nosiyodila,” ebene dubu epetapiate Ya꞉sutamo pelamenate ibino kotamo ebe kodakodanomolo ebo pelaweniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ebene Ya꞉suko waloma꞉tapi magumulo dubu idite ebeno gowelaono gili magoba꞉nate, Godotamo kalimagono ikameopino Unu Watodawanomono moto wokodawa anagaliminate galo apu ebo mapitamidameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wiyasiya Ya꞉sute ebetamo negeni, “A꞉imano gili walo na꞉kemapeda꞉, mabu gila꞉mo da꞉gowelaona walone epetapiate ibi atumu gila꞉mo kanakapulaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","A꞉ma꞉ iyatawala꞉ka꞉, nale ubi iyatite Godoko danamo, ebe tetelo na kowalubinima꞉ ebete ebeno 12 taoseni gowelao nopopi kapalibolemene? ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wiyasiya nale eba kunu dowagelemo, Godote dopamo ebeno Bukamo dakuloliya ebe nanitabo tanalate keba kunu na꞉kemaimioma꞉na꞉? Buka tabote nanitabolo gena me tanalate natamo nemaima꞉na꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ebe tetelo Ya꞉sute dubu epetapi bilibilinomatamo negeni, “Na pilo lumagila꞉ka꞉, o na gowelaodawala꞉ka꞉? Mabu keleka꞉ la꞉le gowelaono gila꞉go ega꞉walo gaubago na lawenema꞉ da꞉pelama꞉ema? Na egela epetapilo Godoko Amamateno Iya Motolo eba okolilo epo diyatulamenatimo, la꞉le na ebolo kelawena꞉wea꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","wiyasiya me tanalo bilibilinomate a꞉pemaimia, Godokono woki awokalimipiate ebeno Bukamo dopamo dakuloliya ebe tabono tanalate nanitaboma꞉ keda꞉oma꞉.” Ebe tetelo ebe waloma꞉tapi bilibilinomate ebe atepanate gito alautioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ebe tetelo Ya꞉suko delaweniya ebe dubate ebe Kayapasikono motamo magataniya, Kayapasiko ebe Godotamo kalimagono ikameopino Unu Watodawanomola. Iba꞉te Ya꞉suko ebe motamo magatana꞉no dopamo Godokono Totomu iyatulamepi ega꞉walo kawokawo dubu epetapi iba꞉te pelamenate ebo paladabutiniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ebe tetelo Pitate Ya꞉suko muludopone eba waloma꞉tanalo, ebete Unu Watodawanomono moto kala magumamo nopeganate atila꞉piago ebo nokolini. Ebe ubila kebe tanalote Ya꞉sutamo da꞉pemaigamene ebe tanalo ebeno balida꞉mo kuminama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ebene Godotamo kalimagono ikamepino watowatopi ega꞉walo Ka꞉nisolo dubu bilibilinomo epetapiate a꞉da꞉ tabo gelapi oleniya, Ya꞉sukono kuba olemenate ebe kanakapuima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ebema꞉ tabo gelapi bilibilinomate ebeno tanaloma꞉ a꞉da꞉ tabo kiyawaoniya wiyasiya ibino tabo gela magumulo Ka꞉nisolo dubate Ya꞉sukono a꞉e mabuma꞉ kuba idi kuminiya꞉. Ebene walogabo apuamo netewapiate kapimiya pemaiminate ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","olowiopiatamo na꞉pegelaniya, “Me dubute ma kunu gi, ‘Naimano elawo modobola Godoko Amamateno Moto anabulimite netewa-kapiya egelalo walo ka꞉ketemamo.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ebene Godotamo kalimagono ikameopino Unu Watodawanomote maiganate Ya꞉sutamo negeni, “A꞉ma꞉ tabo gea꞉noma꞉ beda꞉ma꞉ keda꞉wena? Me dubate a꞉imano tanaloma꞉ degelana keba kunula꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ya꞉sute tabo gea꞉no Unu Watodawanomote ebetamo walo na꞉kegeni, “Nale a꞉ma꞉ Igilo Godokono mailamo nanamata, a꞉ma꞉ a nanaa꞉, a꞉ma꞉ Godokono Gudu Kelisotela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ya꞉sute ebetamo nowamini, “A꞉ma꞉le ebe ebe geata. Nale la꞉ analemata, nanitabola, la꞉le na Epono Naniwi aimano Elawodawa Godokono tumudi apulo okolitalo kunaemamota, iyo, walone na Unu Duliyomolone tema magumudo kapawokalamamo!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ebema꞉ Unu Watodawanomote ebe tabo olowinate, ebeno kawo dowa tanalonomo kawokaliminama꞉ ebete da꞉pulini ebe lubudino ga꞉ga꞉ kaliku anagiyamidalenate negeni, “A me dubuno kuba kiyatawaoma꞉ tabo gedawa idi a ubia꞉nola! Ebete a꞉ka꞉tuwa꞉ kuba tabonomo dege la꞉ ebe olowiomata, mabu ebete nege, ‘Na ega꞉walo Godoko, a kapiyala!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ebema꞉ la꞉imano ubi keba kunula꞉ka꞉ ebeno tanaloma꞉?” Ka꞉nisolo dubate wiya tabo negelaniya, “Modobola ebete na꞉emene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ebene ibi epetapiate kowe ebeno ololamo meolenate, ega꞉walo epetapiate kotamo ebe tatakolo eba anagalimionalo ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","negelaniya, “A꞉ma꞉ Godokono woki awokalimidawa Kelisoma꞉ nanitabolo deda꞉wena, a nanaa꞉ a꞉ma꞉ piyate kanagalimiotana!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ebe tetelo Pitate ebe motono kala magumulo eba okolinalo, woko buwelete ebetamo penate ebe napanani, “A꞉ma꞉ atumu me Ga꞉lili opodawa Ya꞉suago pata꞉namiata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pitate ibi bilibilinomono ololo apulo negeni, “Ao, a꞉ma꞉le degeawena ebe tabo na iyatawa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ebene ebete kala ga꞉dimi gigiyamo da꞉toni, ebe tetelo woko buwele idite ebe uminate, ebolo da꞉pola꞉niya ebe epo nakapanaleni, “Me dubute Nasalete duliyomolodawa Ya꞉suago pata꞉nami!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wiyasiya Pitate ebe atu tabo ma kunu kegeni, “Na Godokono mailamo gemo, na ebe dubu iyatawa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ebene ebolo da꞉pola꞉niya iba꞉te tete da꞉pesamo ilukula꞉tepanate Pitatamo pelamenate ebe walo nakapananiya, “Nanitabola! A꞉ma꞉ Ya꞉sukono lumagi idilata, mabu a꞉imano tabo kiyawao tanalote me tanalo awokalimina, a꞉ma꞉le Ga꞉lili opodawa idima꞉ eda꞉nata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Wiyasiya Pitate negeni, “Godokono dopo apulo utite gemo, nale nani tabo gea꞉no ebete na kanaginaemene! Nale ebe dubu iyatawa꞉!” Ebene ebe tetenomolo kakabate degeoni, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ya꞉sute ebetamo dopamo kebe tabo kegenile, Pitate ebe tabo ebo malagidiloni, “Kakabate geoa꞉no a꞉ma꞉le netewa-kapiya teta꞉mo na iyatawa꞉noma꞉ kegema꞉ta.” Ebene Pitate iyabaiamo tonate kawo tepo temetemenomago iinomo ebo niini. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Egelate da꞉powaloiya Godotamo kalimagono ikameopino watowatopi ega꞉walo kawokawo dubu epetapi, ibi bilibilinomate tabo gelitiya Ya꞉suko anakapuima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ebene iba꞉te Ya꞉suko ala꞉mo matuomeote Paeletetamo ebo magatiya, ebe Loma epate Yudiya opamo dapalibiya ebe kapela Kawo Elawodubula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ebe tetelo Yu watowatopiate Ya꞉suko anakapuima꞉ nopo nanitabonomolo diyatiya, Yudasite ebe tanalo olowiya, ebe Ya꞉suko ibino kotamo diyatiya ebe lumagila. Ebema꞉ ebete idoko tetelo kebe kuba tanalo kosiyodilonile ebe mabuma꞉ tepo temeteme kawonomoma꞉ eda꞉lo, ebete 30 siliba mani Yu watowatopiatamo kowadaete na꞉pegiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Na kuba osiyodilonimo. Na tuputupu lumaginomo la꞉imano kotamo iyatinimo.” Ebene watowatopiate ebeno tabo eba wiyalo negeliya, “Ebe aimano tanaloa꞉, a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉imano tanalola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ebe tetelo Yudasite ebe mani Godoko Amamateno Iya Moto guamo ebo niyaleka꞉midiya, ebene ebete tote ebeno kuwokoba꞉mo ale nema꞉midaote ebe a꞉ka꞉tuwa꞉ ebe ebo nanakapumiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ebema꞉ Yu watowatopiate ebe mani eba uwatolelo ma kunu geliya, “Totomu tabote talena iyatiamena ale me mani Godokono maniago kapiyakobi ka꞉midilima꞉, mabu me mani lumagi anakapumi manila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ebene iba꞉te tabo ma kunu iyatiya, “Modobola a me maniamo Kalili Osiyodiloledawano Damela kelaemalema꞉, ebene kapela epate Yelusalema kawo duliyomololo da꞉pa꞉elaonakoma꞉na꞉, ale ibi me damelamo balomonakoma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ebema꞉ ebe tetene wagilimite me teta꞉mo pemaiga epate ebe damela Kalima Wiya Damelama꞉ ka꞉mina, mabu dopamo iba꞉te ebe maniamo lumagi anakapumite ebeno kalima opamo ebo ka꞉ka꞉liya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Iyalo tetelo Godokono woki awokalimidawa Yelemayate tabo ma kunu giya, “Isalaela epate 30 siliba mani uwatete negeliya, ‘Me Godokono wokodawano wiyala.’ Ebema꞉ Kawodawa Godote na Yelemayako keba kunu kananile epate ebe maniamo kebe tanalo na꞉kosiyodiloma꞉na꞉, iba꞉te nanitabolo eba kunu osiyodiliya, iyo, iba꞉te ebe maniamo Kalili Osiyodiloledawano Damela lawiya.” Ebema꞉ me tanalo nanitabola, Ya꞉suko tetelo Yu watowatopiate ebe damela maniamo delawiya, ebe tetelo Godote Yelemayado dopamo degiya ebe tabote nanitabonomoma꞉ ebo ediya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ebene Ya꞉sute kapela Kawo Elawodubu Paeletekono ololo apulo eba utitalo, ebete ebe ebo alatediya, “A꞉ma꞉ Yu epono Kawo Elawodubula꞉ka꞉?” Ya꞉sute negiya, “A꞉ma꞉le ebe ebe geata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ebene Godotamo kalimagono ikameopino watowatopi ega꞉walo kawokawo dubu epetapi, iba꞉te Ya꞉sukono tanaloma꞉ negelitiya ebete iyaiya kubakuba tanalo osiyodilolenami. Ebe tetelo Ya꞉sute wiyasiya tabo kegiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ebene Paeletete ebetamo negiya, “Iba꞉te negelita a꞉ma꞉ kawokawo kuba tanalo bilibilinomo osiyodiloliata. Ibino tabo gela na꞉kolowiawita?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wiyasiya Ya꞉sute kapiya tabo da꞉peso idi kegiya꞉, ebema꞉ kapela Kawo Elawodubute kawonomamo anoaniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ebe tete epono osiyodilo tanalo ma kunula, ulama bilibilinomo magumulo Yu epono Aduga꞉la Soliyomu tetelo ibi bilibilinomate idoko motolo kapiya lumagi mailamo deka꞉minakiya, kapela Kawo Elawodubu Paeletete ebe lumagi ebeno kuba wiyane gito alibonaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ebe tetelo lumagi idite idoko motolo okolinami, ebeno mailo Balabasitela ega꞉walo ebete kebe kawokawo kuba kosiyodiloliyale epo iyatawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ebema꞉ epate Paeletetamo dapaladabutiya ebete ibi nanaliya, “La꞉ ubila꞉ka꞉ nale Balabasiko ebeno kuba wiyane gito aliboma꞉? O la꞉ ubila꞉ka꞉ Ya꞉suko, epetapiate ebe Kelisoma꞉ deka꞉mina?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paeletete me tabo negiya mabu ebete iyatawiya Yu epo epetapiate Ya꞉sutamo nekalakalautiya, wiyasiya ibino watowatopiate ebe mabuma꞉ dowaote ebe gito magaiya, iyo, iba꞉godolo nanitabo tanalo puliyala, kitaniya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ebe tetelo Paeletete tabo anagiyamida bailo eba okolitalo, ebeno kamiyalete ebetamo tabo eba palibolo na꞉pegiya, “A꞉ma꞉ me tuputupu dubunomotamo tanalo idi ako-osiyodilala꞉, mabu na ka꞉lo idokolo ebe mabuma꞉ iyolo temeteme kawonomo elawenakamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wiyasiya Godotamo kalimagono ikameopino watowatopi ega꞉walo kawokawo dubu epetapi, iba꞉te tabo gela magumulo epo epetapi bilibilinomatamo elawo ikalamiya, iba꞉te Paeleteko kanama꞉ ebete Balabasiko igilamo gito alibote wiyasiya Ya꞉suko kanakapuima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ebene kapela Kawo Elawodubute iba꞉tamo walo na꞉kegiya, “Me netewapi magumulo nale poko gito nakalibomo?” Iba꞉te ebetamo nowamiya, “Balabasiko gito naliba!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Paeletete iba꞉tamo negiya, “Me Ya꞉suko epetapiate ebe Kelisoma꞉ degelana, nale ebe keba kunu nakamitimo?” Ibi bilibilinomate negeliya, “Kewa olotolowamo tupuguima꞉wete, ikoko nanagilamolema꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ebene Paeletete negiya, “Beda꞉ mabuma꞉? Ebete beda꞉ kuba kosiyodilile?” Wiyasiya iba꞉te kawonomamo gelatepaolo walo na꞉kegeliya, “Kewa olotolowamo na꞉tupuguima꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ebe tetelo Paeletete iyatawiya iba꞉te ebeno tabo kelawitiya꞉ wiyasiya gowela tanalote maigiti. Ebe mabuma꞉ ebete obo lawete epo bilibilinomono ololo apulo koto eba ukulalelo negiya, “Me tuputupudawano kalima ka꞉ka꞉liya tanalote naimano kubama꞉ a꞉keda꞉mene, la꞉ a꞉ka꞉tuwa꞉ la꞉imano kubala!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Epo bilibilinomate wiyasiya negeliya, “Modobola! Ebeno kalima ka꞉ka꞉liya mabuma꞉, a ega꞉walo aimano guda꞉go ebe kuba wiya kelaemalema꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ebema꞉ Paeletete Balabasiko idoko motone gito alibiya, ega꞉walo ebete gowelaopi nanaliya iba꞉te Ya꞉suko pa꞉ka꞉pa꞉ka꞉mo ka꞉na꞉ma꞉ga꞉midaoma꞉. Ebene ebe tanalo dolopoligiya ebete Ya꞉suko gowelaopiatamo gito ikalamiya, iba꞉te ebe kewa olotolowamo tupuguimite ikoko kanagilamolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ebe tetelo Paeletekono gowelaopi dubate Ya꞉suko Loma gabamanino kawo moto guamo magatate ibino gowelaopino taneba dubu bilibilinomate iba꞉go ebo naladabutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iba꞉te Ya꞉suko eba kalakalatelo ebeno kalikunomo pekanamete wiyasiya wiya kawonomo kalimakalima kaliku ebetamo ebo pulimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ebene iba꞉te moeagono ale nelawete anagogobeyamidaolo a꞉dete Ya꞉sukono watamo gito pulimiya, ega꞉walo iba꞉te gaubu ebeno tumudi kotamo iyatimiya, kawo elawodubuno elawo awokalimino gaubu keba kunula꞉ka꞉ eba kunu. Ebe tetelo iba꞉te ebe kalakalatelo ibino pupamo ilukulite ebetamo eba tudila꞉olo negeliya, “Eiye! Yu epono Kawo Elawodubu, a꞉ma꞉ niyata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ebene iba꞉te ebetamo kowe meolete, ebeno gaubu laemete watolo ebo anagalimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Iba꞉te ebe kalakalate dolopoligiya, kalimakalima kaliku ebeno apene pekanamete ebeno kalikunomo walo gito ka꞉pulimiya, ebene iba꞉te ebe a꞉e baiamo nemagatiya kewa olotolowamo ebe ka꞉na꞉tupuguima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Iba꞉te kawo duliyomolone eba tolamitalo gowelaopiate Sailiniya duliyomolo dubu idi Saimonoko numite ebo nelawiya Ya꞉sukono kewa olotolowa kaguwataema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ebene iba꞉te Gologota damelamo nemaimiya, ebe damelano mailo magumu ebe ‘Wato Goala.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ebolo iba꞉te elawo da꞉imi obo ega꞉walo temeteme olowia꞉no kaka mulamula adabulatelete Ya꞉sutamo dikamiya, ebete kela꞉mo alatipite gito atepiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ebe tetelo gowelaopiate ebe kewamo tupuguimite ikoko ebo anagilamolemiya, ebene iba꞉te ebeno kaliku iyaiya alabaoema꞉ nokola egege iyalekeolo kalakala tanalo osiyodilote, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","opolo ilukulite ebe ebo umitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ebe tetelo iba꞉te Ya꞉sukono wato unu apuamo ebeno a꞉e mabu awokalima꞉ tabo ma kunu akuloliya, “Me Ya꞉suko ebe Yu epono Kawo Elawodubula,” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ega꞉walo iba꞉te pilo dubu netewa Ya꞉suago iyaiya kewamo akotupuguilamiya, idi tumudi apuamo, idi pele apuamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ebene piyate ebe gabodo da꞉petolamitiya iba꞉te Ya꞉suko malogolo nekalakalatitiya, iyo, iba꞉te ibino wato wadegelatelelo ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","negelitiya, “Eiye! A꞉ma꞉ Godokono Moto anabulima꞉wete netewa-kapiya egelalo walo etema꞉ degeawia, a꞉ma꞉ ebe lumagilata! A꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉imano igilo na꞉mula꞉! A꞉ma꞉ Godokono nani Guduma꞉ deda꞉wena, a꞉ma꞉ kewa olotolowa unune na꞉piwisiga!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ebe tetelo Godotamo kalimagono ikameopino watowatopi, ega꞉walo Godokono Totomu iyatulamepi, ega꞉walo kawokawo dubu epetapi, iba꞉te Ya꞉suko atumu kalakalatelo na꞉kegelitiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ya꞉sute epo epetapino olalati tanalo mula꞉lelamenaki, wiyasiya ebe a꞉ka꞉tuwa꞉ ebeno igilo mula꞉ma꞉ modoboa꞉! Ebete Isalaela epono nani Kawo Elawodubuma꞉ deda꞉na, modobola ebete kewa olotolowa unune opamo na꞉piwisigana, iyo, ale ebe tanalo umite ebe nanitabokobi ebo ka꞉midimalema꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ebete negenako, ‘Na Godoko nanitabokobi na꞉midinamo, ega꞉walo na ebeno Gudula,’ ebema꞉ Godote ebetamo nekalakalataleka꞉ ebete ebeno igilo ba꞉mula꞉mena꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ebe tetelo eba꞉go da꞉tupuguilamiya, ebe pilo dubu netewate atumu Ya꞉suko malogolo kuba tabo na꞉kegelitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ebene egelate tuli teta꞉mo dutiya opo kawonomote ebo idokiya. Ebe tetelo idokote egelano alo eba mula꞉lo egelate a꞉iwate kela꞉mo a꞉niwisigatepani, egela tuli tetene wagilimite 3 koloko uwomuamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ebene Ya꞉sute Yu epono tabamo kawonomamo negeni, “Elai, Elai, lama sabakatani?” me tabono magumu ma kunu itana, “Naimano Godo, naimano Godo, na a꞉ma꞉le beda꞉ma꞉ katepana꞉wa꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Epetapi ebolo da꞉pola꞉niya iba꞉te ebeno tabo olowinate negelaniya, “Me dubute Elayako ebe ka꞉mina!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ebe tetenomolo ibi magumulo kapiya dubute na꞉puliganate, umago kaka da꞉imi obamo naduba꞉midanate pudamo namogotenate Ya꞉sutamo ebo nikameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wiyasiya epetapiate negelaniya, “Iyaiya, a kuma꞉tepiye! Elayate pete ebeno igilo da꞉ba꞉pa꞉mula꞉emene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ebe tetelo Ya꞉sute kawonomamo walo kegepatenate a꞉enomo ebo a꞉eni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ebene Godoko Amamateno Iya Motono kaliku ubilite tulituliya bolegale unune wagiliminate opamo ebo piwisigani, ega꞉walo mumulute da꞉peni iyaiya maboele nokola damelate eba bolaliyaolenalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","epo epetapino a꞉elao bobote a꞉ka꞉tuwa꞉ ebo bolaliyaoleniya. Ebema꞉ nanitabola, Ya꞉sute a꞉e magumune da꞉kemaigiya, ebe atu tetelo kebe tuputupupiate dopamo da꞉elaiya Godote ibi epetapi a꞉e magumune atumu eba kowadipalatelelo, iba꞉te ibino iyaiya nokola bobo magumune ibino apa꞉go ebo pemaimiya, iyo, iba꞉te Yelusalema kawo duliyomolamo nemaimiote ibi a꞉ka꞉tuwa꞉ ibino tanalo epatamo ebo nawokalilamoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ebene gowelaopino elawodubu ega꞉walo ebeno opopi magumulo piyate Ya꞉sukono a꞉e tanalo duminiya, iba꞉te mumulu ega꞉walo anoano tanalo epetapi eba ulamenalo kawo tole tanalonomago negelaniya, “Nanitabola, me lumagi ebe Godokono Gudula!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ebe tetelo kamiyale epetapi bilibilinomate Ya꞉suko uima꞉ mulune putitataniya, Ya꞉sute Ga꞉lili opone Yelusalema kawo duliyomolamo da꞉tiya iba꞉te ebe eba waloma꞉talo ebe wadenomamo walubinatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ebe kamiyaleno taneba magumulo Magadala duliyomolodawa Ma꞉liko, ega꞉walo Ma꞉li idi ebeno gudi netewa Ya꞉imesiko ega꞉walo Yausesiko, ega꞉walo Sebedikono kamiyale ebete ebeno gudi netewa dalailamiya, miba꞉te pola꞉niya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Adimo tetelo inamabu bilibilinomago dubu idite na꞉peni, ebeno mailo Yausepete A꞉limitiya duliyomolodawala, ebe Ya꞉suko waloma꞉tadawa idila. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ebe tetelo ebe dubute Paeletetamo tonate Ya꞉sukono ape lawenama꞉ ebe dananani, Paeletete ebeno gowelaopi ebo nanaleni iba꞉te ebetamo kikamenama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ebene ebete Ya꞉sukono ape lawenate oli keyakeya kalikamo auputinate ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","bobo magumamo ebo niyatini, ebe bobo ebe oli bobola, epate maboele nokola damela eba obobolo Yausepekonoma꞉ iyalo osiyodilomiya. Ebe tetelo Yausepete kawo nokolanomo mupiamidanate bobo gigiyu nemopinate gito toni, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ebene Magadala duliyomolodawa Ma꞉liko ega꞉walo Ma꞉li idi, iba꞉te nokola bobo apulo eba okolionalo Yausepekono osiyodilole tanalo ebo ulamelemeniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Egela idi ebe Yu epono wokoa꞉ egelala. Ebe tetelo Yu watowatopi ega꞉walo Pa꞉lisi tanebapi epetapi iba꞉te Paeletetamo tolamete ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ma kunu negeliya, “Kawodawa, ebe elemasigi dubu Ya꞉suko ebete a꞉ea꞉no dopamo negi, ‘Netewa-kapiya egelalo na a꞉ene ka꞉kemaigamamo.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","A me tanalo eba malagidilolo, a ubila a꞉ma꞉ tabo negea gowelaopiate ebe nokola bobo netewa-kapiya egelalo wadenomamo katila꞉ma꞉, mabu diyala, ebeno waloma꞉tapiate ebeno ape pilolo da꞉ba꞉pelaema꞉na꞉, ebene iba꞉te ma kunu kegelama꞉na꞉, ebete a꞉ene a꞉kemaigi. Numa꞉, dopo elemasigi tabote a temeteme ikaeami, wiyasiya kebe tetelo epate me elemasigi tabo idi nanitaboma꞉ da꞉midima꞉na꞉, aimano temeteme tanalote kawonomoma꞉ keda꞉mene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paeletete iba꞉tamo negiya, “Modobola, la꞉ bobo bai wadenomamo atila꞉ma꞉ naimano gowelaopi epetapi nuwata꞉la꞉. Ebene la꞉ a꞉ka꞉tuwa꞉ la꞉godolo wade woki da꞉pola꞉namene, la꞉ eba kunu nosiyodiliyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ebema꞉ iba꞉te bobo baiamo tolamete, bobo demopiya ebe nokola unamo pukala ebo niyatiya epate ologikapoma꞉, ebene iba꞉te bobo atila꞉ma꞉ gowelaopi ebo miyapiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ebene Yu epono wokoa꞉ talena egela dolopoligiya, Sande egelate eba waloutalo, Ma꞉li Magadala duliyomolodawa ega꞉walo Ma꞉li idi, iba꞉te kamiyale epetapiago nokola bobo uima꞉ ebo tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wiyasiya iba꞉te bobo baiamo nemaimia꞉no, dopamo kawo mumulunomote piya, ebene Kawodawa Godokono nopodawate Unu Duliyomolone piwisigate, bobo demopiniya ebe kawo nokola balamo pinimupiamidate ebe nokola unulo okoliti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ebeno ololo molete da꞉la꞉uwa꞉mida keba kunula꞉ka꞉ eba kunula, ega꞉walo ebeno pupuliono inamabuate keyakeyaibinomoma꞉ eba eda꞉omelo ebo pukuilamiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ebe mabuma꞉ bobo bai atila꞉pi dubate toletoleolo eba anakamiolo opamo gudite a꞉elaopimu polamota꞉oniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Godokono nopodawate wiyasiya kamiyala꞉tamo negiya, “La꞉ akotoletola꞉la꞉! Na iyatawala, la꞉le Ya꞉suko epate ebe kewa olotolowamo da꞉tupuguimiya, ebe waditamata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ebe malo puliyala mabu ebe emaigaka, ebete dopamo degi eba kunu! La꞉ pelama꞉wete ebete dekapitani ebe bai na꞉puma꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ebene la꞉le ebeno waloma꞉tapi samonomamo nananala꞉la꞉, ‘Ya꞉sute a꞉e magumune emaigaka. La꞉ nolowiala꞉, ebete Ga꞉lili opamo dopamo ka꞉tomene, la꞉ tolama꞉wete ebe ebo ka꞉nuimamota. Nanitabola, na Godokono nopodawate me tanaloma꞉ la꞉ dopamo analemata.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ebema꞉ iba꞉te bobo bai samamo atepate, kawo tole ega꞉walo kalakala tanalote ibi eba uwatelo, iba꞉te eba kunu puila꞉iya Ya꞉sukono waloma꞉tapi kananalema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Iba꞉te eba tolamelo ebe tetenomolo Ya꞉sute iba꞉go alugote iba꞉tamo negiya, “Niyaniyata!” ebene iba꞉te ebeno dopo apulo opamo na꞉gudite ebeno agowa eba na꞉wiyamidalemelo ebe ebo namamatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ya꞉sute iba꞉tamo negiya, “La꞉ akotoletoleala꞉. La꞉ tolama꞉wete, na dowaloma꞉enena ebe naimano ekaki nananaliyala꞉ iba꞉te Ga꞉lili opamo na꞉tolaema꞉na꞉. Iba꞉te na ebo ka꞉nunaema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ebene kamiyala꞉te Ya꞉sugodone eba tolamitalo, nokola bobo atila꞉pi gowelaopiate kawo duliyomolamo tolamete Godotamo kalimagono ikameopino watowatopi ebo nanaliya, bobo bailo demaimiya ebe tanalo bilibilinomo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ebene ebe watowatopiate Yu epono kawokawo dubu epetapiago naladabutite tabo ebo niyatiya gowelaopiatamo kawokawo mani kikalamolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Iba꞉te eba ikalamolelo negeliya, “La꞉ epo masigililo a꞉da꞉ tabo ma kunu na꞉negeliyala꞉, ‘Idokolo ale eba laonalo Ya꞉suko waloma꞉tapiate pelamenate ebeno ape pilolo ebo pelawa꞉diganiya.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ega꞉walo la꞉ woki bilibilima꞉ akoeda꞉oala꞉, mabu kapela Kawo Elawodubu Paeleteko me u lao tabo dolowimene, ale ebe ka꞉negelebadimimalema꞉ ebete la꞉tamo kuba wiya ikalamekapoma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ebene gowelaopiate ebe mani uwatete, Yu watowatopiate keba kunu kegeliye iba꞉te eba kunu osiyodiliya, ebe mabuma꞉ ebe a꞉da꞉ elemasigi tabote Yu epono duliyomolo epetapi bilibilinomamo tiya, ka꞉lo ebe tabote iba꞉godolo bitana, kolopoligona꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ebene Ya꞉sukono 11 waloma꞉tapiate Ga꞉lili opamo gito tolamiya, Ya꞉sute ibi dopamo danaliya ebe damela ununomamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iba꞉te ebe numite ebe ebo namamatiya, wiyasiya ebolo da꞉pola꞉niya ibi epetapiate woki bilibilima꞉ eba eda꞉utalo nanitabokobi ka꞉miditiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ebene Ya꞉sute iba꞉tamo pete ibi ma kunu panaliya, “Godote iyalo tetelo elawo kawonomo natamo ikanamiya, ebeno Unu Duliyomololo ega꞉walo me opo kawonomolo ebeno ubi tanalo bilibilinomo kosiyodilolenama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ebema꞉ la꞉ me opono iyaiya epo bilibilinomatamo tolama꞉wete ibi na waloma꞉enepima꞉ na꞉na꞉midiliyala꞉. Ma kunu la꞉le ibi Nabiwi Godokono mailamo, ega꞉walo ebeno Guduno mailamo, ega꞉walo ebeno Talena Uliyanano mailamo obamo na꞉nowaduba꞉midaoliyala꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ega꞉walo nale la꞉ diyatulamoletiama, ebe tanalo bilibilinomo la꞉le ibi na꞉niyatulamoliyala꞉ iba꞉te naimano tabamo ka꞉tudila꞉oma꞉. Umu numita꞉la꞉! Na uwomua꞉ tetelo la꞉go bokolinamo, me opono uwomu tete da꞉nemaigamene ebe teta꞉mo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ya꞉su Kelisoko ebe Godokono Alibodawala ega꞉walo ebeno Gudula, ebene Ya꞉sukono Wade Tabo dowagilimiya me ebe mabula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nanitabola, Godote dopamo ebeno woki awokalimidawa Aisayado Kelisokono pe tanaloma꞉ ebeno Bukamo tabo ma kunu akuloliya, “Nale Kelisokono dopo apuamo naimano tabo atadawa kapalibomamo, ebete ebeno gabo ka꞉posiyodiloma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Iyo, lumagite bulu opolo tabo ma kunu kawonomamo ka꞉pegemene, ‘Kawodawano gabo nosiyodiloma꞉la꞉. Ebeno gabo na꞉tupugaima꞉la꞉!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ebe mabuma꞉ Yonete pemaigiya. Ebete epo bulu opolo obamo eba powaduba꞉midaolelo, Godokono tabo ma kunu pa꞉kiyawaiya, “La꞉imano kubane olobila꞉wete obamo aduba꞉mida tanalo laema꞉ na꞉pelama꞉la꞉, ebene Godote la꞉imano kuba egebolelametate ka꞉dodolomatililaema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ebema꞉ epo bilibilinomate Yudiya opone ega꞉walo Yelusalema kawo duliyomolone tolamiya Yonekono tabo olowioma꞉, ebene iba꞉te ibino kuba danawokalilamoliya, Yonete ibi Yodane Kolomolo obamo ebo waduba꞉midaoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ebe tetelo Yonekono okoli tanalo ebe epo epetapino ilukuli tanalo keba kunula꞉ka꞉ eba kunua꞉, mabu ebete ka꞉molo-goeo ipo kuba kaliku kau-goeo tama batago pulinaki, ega꞉walo ebeno bae siguniya ega꞉walo molo naonaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yonete Godokono tabo eba pa꞉kiyawaolo negiya, “Lumagi idite naimano walogabo apune ba꞉pena. Ebeno elawo kawonomola, naimano elawo nodoliona, ebema꞉ na wadenoa꞉ nale opamo tuduwatate ebeno agowa ukulaolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nale la꞉ obamo waduba꞉midaolemata, wiyasiya ebete Godokono Uliyanamo la꞉ ka꞉powaduba꞉midaolema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ebe tetelo Ya꞉suko Ga꞉lili opono Nasalete duliyomolone pete, Yonete Yodane Kolomolo ebe obamo ebo aduba꞉midiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ya꞉sute obone eba pidiwilo, ebe tetenomolo Godote ebeno Unu Duliyomolo a꞉iyamiditalo ebo umiya, ebene ebete Godokono Uliyana umiya ebetamo bigo olamu da꞉piwisigiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ebene tabote Unu Duliyomolone ma kunu piwisigiya, “A꞉ma꞉ naimano kapiya Gudunomolata. Na a꞉ma꞉tamo nekalakalitamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ebe tetenomolo Godokono Uliyanate Ya꞉suko bulu opamo nemagatiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ebene ebete bulu opolo 40 egelamo eba nokolilo, Saitanate kuba gabamo kowabuga꞉tama꞉ ebetamo ebo pemaigiya. Ebolo iyaiya elawoelawo inamabuate na꞉pola꞉niya, wiyasiya Godokono nopopiate ebe na꞉buiyatitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ebene gabamaniate Yoneko idoko motamo diyatiya, ebe tetelo Ya꞉sute Ga꞉lili opamo Godokono Wade Tabo kiyawaoago ebo piya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ebete na꞉pegiya, “Wade tete a꞉pe. Godokono Kawo Elawodawama꞉ eda꞉ tete tatalila, ebema꞉ la꞉imano kubane olobila꞉wete Wade Tabo nanitabokobi na꞉mida꞉la꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ebene Ya꞉suko Ga꞉lili Paka꞉ balado eba tonatolo, ebete namo uwatolepi netewa ebo nulamiya, Saimonoko ega꞉walo ebeno ekawi A꞉nduluko iba꞉te namo kamauamo na꞉utiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ya꞉sute iba꞉tamo negiya, “La꞉ na nowaloma꞉ena꞉la꞉, ebene nale la꞉ epo uwatepima꞉ ka꞉midilimamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ebe tetenomolo iba꞉te ibino kamau miyapate Ya꞉suko ebo waloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ebene Ya꞉sute kela꞉mo walo ka꞉tote Sebedikono gudu Ya꞉imesiko ega꞉walo ebeno ekawi Yoneko ebo ka꞉nulamiya, iba꞉te ibino pelo okoliutalo kamau osiyodilolitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ya꞉sute ibi deka꞉la꞉miya, ebe tetenomolo iba꞉te ibino nabiwi Sebediko atepate Ya꞉suko ebo waloma꞉tiya, wiyasiya ibino nabiwino mani woko dosiyodilonamiya ebe dubu epetapiate eba꞉go pelo ilukulitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ebe tetelo Ya꞉sute ebe waloma꞉tapiago Kapeniyama duliyomolamo tolamiya. Ebene Yu epono wokoa꞉ talena egelalo ebete ibino balidi ibilamole motamo tote ibi da꞉niyatulamiti, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","iba꞉te ebeno tabamo nanoanoutiya, mabu ebete Godokono elawamo iyatulamiti wiyasiya ebe ibino Godokono Totomu iyatulamepi keba kunula꞉ka꞉ eba kunua꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ebe atu tetelo kuba uliyanagono dubute ibino balidi ibilamole moto gulo nokoliti, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ebene ebete geatepaolo negiya, “Ya꞉su Nasalete duliyomolodawa, a꞉ma꞉ atamo beda꞉ tanalo na꞉kosiyodilaemene? A꞉ma꞉ a kubaiaema꞉ ka꞉pa꞉wa꞉? Eiye, na iyatawala a꞉imano tanalo, a꞉ma꞉ ebe Godokono Wade-talena Dawalata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ya꞉sute wiyasiya ebe kawiya aniya, “A꞉ma꞉ kodakodawete, ebegodone na꞉nemaiga!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ebene kuba uliyanate geatepaoago ega꞉walo wageleago dubuno apene da꞉penemaigiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","epate ebe tanaloma꞉ nanoanoutiya. Idite idi ananaki, idite idi ananaki, “Me beda꞉la꞉ka꞉? Me iya oli iyatulame tanalola꞉ka꞉? Me dubuno elawo kawonomola! Numa꞉la꞉, kuba uliyanate ebeno tabamo a꞉tudila꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ebema꞉ nanitabola, ebe atu egelalo Ya꞉sukono woko osiyodilo tabote ebe Ga꞉lili opo kawonomamo gito tiya, iyo, piyate ebolo dilukulionamiya ibi bilibilinomate ebeno tanaloma꞉ tabo ebo na꞉kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ebene Ya꞉imesiko Yoneko iba꞉te Ya꞉suago Yu epono balidi ibilamole motone pemaimite, Saimonoko A꞉nduluko ibi netewapino motamo tolamenomo tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ebolo Saimonokono moto lapino ape enaena gabugabuago watiti, ebene epate me kamiyaleno tanaloma꞉ Ya꞉suko ebo aniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ebema꞉ Ya꞉sute ebetamo pete ebe kotamo dapadipatiya ebeno gabugabute nolopoligiya, ebene ebe kamiyalete maigate ibi mabuma꞉ bae okalimi woko ebo wagilimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Eba adimonalo egelate da꞉niwisigani, duliyomolo epate temetema꞉gopi bilibilinomo ega꞉walo kuba uliyanagopi Ya꞉sutamo ebo magaeleniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ebene ibi epetapi bilibilinomate moto gigiyu dopo apulo pepola꞉niya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ebe tetelo Ya꞉sute ibi magumulo iyaiya temetema꞉gopi epetapi bilibilinomo wadekobi midiolenate, ega꞉walo kubakuba uliyana bilibilinomo epetapiagodone ebo aliboleni. Ebe kuba uliyana iyatawala Ya꞉suko ebe Godogodone piya, ebema꞉ iba꞉te ebeno tanalo kawokalima꞉ ebete tabo gela talena ebe iyatilameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ebe idoko tetenomolo walo apuamo Ya꞉sute ebeno u wata baine maiganate, ebe a꞉ka꞉tuwa꞉ diyamoa꞉ opamo tonate Godago tabo ebo na꞉kiyawaoniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ebene duiyalo Saimonoko ega꞉walo ebeno namutupi iba꞉te Ya꞉suko wadima꞉ da꞉tolamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","iba꞉te ebe numite nananiya, “Epo bilibilinomate a꞉ma꞉ waditata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ebema꞉ Ya꞉sute iba꞉tamo negiya, “Kuba꞉, a ka꞉tolamiye. Nale duliyomolo epetapilo Godokono tabo ka꞉na꞉kiyawaomamo, mabu na ebema꞉ piyamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ebe tetelo ebete Ga꞉lili opono duliyomolo bilibilinomamo tonaki, ebene ebete Yu epono balidi ibilamole moto gulo Godokono tabo kiyawaolamenaki ega꞉walo ebete kuba uliyana epagodone akalibolenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ebene kukulakukulago dubute Ya꞉sutamo pete ebeno pupamo pokolite ebetamo kawiya eba petowetoweolo na꞉pegiya, “A꞉imano ubi ditametana, a꞉ma꞉le na wadekobi ka꞉midinima꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ya꞉sute ebe kawonomamo nilakapoimilo ebeno koto uwamidate ebe ologilo naniya, “Na ubila, a꞉ma꞉ wadekobi nolowia!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ebema꞉ ebe tetenomolo kukulakukula temetemete ebegodone olopoligote ebe wadekobi ebo olowiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ebene Ya꞉sute ebe eba alibolo kawonomamo ma kunu aniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“A꞉ma꞉ naimano tanaloma꞉ epo akonanala꞉la꞉. Modobola a꞉ma꞉ wiyasiya me tetenomolo toawete a꞉imano ape Godotamo kalimagono ikameodawatamo nanawokalimiye, ebene kalimagono nilakapo inamabu Godotamo akona꞉nikamiye, Mosesete da꞉kiyawaiya eba kunu. Ebe tanalote epo kiyatulaemene a꞉imano temetemete olopoligi.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wiyasiya ebe dubute eba tolo epo bilibilinomo na꞉kiyawaolamenatiya, ebema꞉ Ya꞉sute duliyomolo epetapiamo awokala toma꞉ ka꞉modobiya꞉. Ebe tetene wagilimite ebete wiyasiya bulu opolo okolinami, ebene apune apune epate ebetamo pelamenakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ebene egela epetapi dolopoligiya Ya꞉sute Kapeniyama duliyomolamo walo na꞉ka꞉piya. Ebete ebeno motolo dokoliti epate olowiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ebema꞉ ibi epetapi bilibilinomate da꞉pelamiya, moto gulo ega꞉walo gigiyu dopo apulo tete idi kitaniya꞉. Ebe tetelo Ya꞉sute Godokono tabo iba꞉tamo eba kiyawautalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","netewa-netewa dubate ape kodakoda temetema꞉go dubu ebetamo ebo aguwatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mabu epo bilibilinomate ebolo na꞉pola꞉niya, ebe dubate Ya꞉suko niyakabamo tolaema꞉ gaboa꞉nola. Ebema꞉ iba꞉te moto unamo nodolote, Ya꞉sute kebo kutitiyale iba꞉te ebe moto unu anabulimite temetema꞉go dubu ketago Ya꞉sutamo ebana nuwamidiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ya꞉sute ibino nanitabokobi midi tanalo umilamete temetema꞉go dubutamo negiya, “Naimano namutudawa, Godote a꞉imano kuba egebolemetate a꞉dodolomatilima꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wiyasiya Godokono Totomu iyatulamepi epetapi ebolo da꞉pola꞉niya, iba꞉te ebe tabo olowite ibino tepo magumulo ma kunu malagidilolitiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Me dubu amamago kuba tabo beda꞉ma꞉ kegele Godokono ololo apulo? Kuba egeboledawa potelela꞉ka꞉? Ebe Godoko kapiyatela!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ebe tetenomolo Ya꞉sute iyatawiya iba꞉te beda꞉ tanaloma꞉ woki kalomutiye, ebema꞉ ebete iba꞉tamo negiya, “Mabu keleka꞉ la꞉imano tepo magumulo me tanalo demalagidilola꞉witama? ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Me tabo kodakodala꞉ka꞉ nale me temetema꞉go dubutamo gema꞉, ‘Godote a꞉imano kuba egebolemetate a꞉dodolomatilima꞉ta?’ O me tabo idi gema꞉ kodakodala꞉ka꞉, ‘Maigawete, a꞉imano keta lawa꞉wete na꞉toa?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ebema꞉ nale la꞉ kiyatulaemamota, Epono Naniwigodolo elawo bitana me opolo epono kuba egebolelamete ka꞉dodolomatililaema꞉.” Ebene ebete ape kodakoda temetema꞉go dubutamo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nale a꞉ma꞉ anamata, nemaiga! A꞉imano keta mokopiamidawete motamo na꞉toa.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ebe tetelo ibi bilibilinomate ebe eba umitalo, me dubute maigate ebeno keta lawete samonomamo ebo tiya, ebema꞉ iba꞉te nanitabonomolo anoanolo negeliya, “Godoko unamo nadipata꞉la꞉. A dopamo mako tanalo kuminakia꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ebe tetelo Ya꞉sute Ga꞉lili balamo walo na꞉ka꞉tiya, ebene epo bilibilinomate ebetamo da꞉pelamiya, ebete ibi ebo iyatulamoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ebene ebete eba petonatolo A꞉lapiyasikono gudu Libaiko ebo numiya, ebe ta꞉kese uwatedawala, ebete ebeno woko bailo okoliti. Ebe tetelo Ya꞉sute ebetamo negiya, “Na nowaloma꞉ena꞉,” ebene ebete maigate Ya꞉suko nowaloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ebene tete da꞉peso da꞉petiya Ya꞉sute ebe waloma꞉tapiago Libaikono motolo ilukulite bae eba nautalo, ta꞉kese uwatepi ega꞉walo Godokono Totomu uwatea꞉pi epetapi iba꞉go na꞉pola꞉niya, mabu nanitabola, makomako epo bilibilinomate Ya꞉suko waloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ebema꞉ Pa꞉lisi tanebapino totomu tabo iyatulamepi epetapi iba꞉te ebe tanalo dumiya, iba꞉te Ya꞉suko waloma꞉tapiatamo negeliya, “Ebete ta꞉kese mani elemasigilo uwatepi ega꞉walo Godokono Totomu uwatea꞉piago bae beda꞉ma꞉ kenanakole?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ya꞉sute ebe tabo olowite iba꞉tamo negiya, “Modobo epate doketatamo a꞉ka꞉tolaema꞉na꞉, wiyasiya gabugabuagopiate ka꞉tolaema꞉na꞉. Iyo, piyate a꞉ka꞉tuwa꞉ degelana ‘A modobo epola,’ na ebako epo uwatema꞉ ka꞉piya꞉. Na wiyasiya kubakuba epo kapiya uwatema꞉ piyamo, iba꞉te na kowaloma꞉enema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tete idilo Yoneko waloma꞉tapi ega꞉walo Pa꞉lisi taneba watowatopino waloma꞉talepi iba꞉te bae naoa꞉no pola꞉niya. Ebene epo epetapiate Ya꞉sutamo pelamete ebe napalatediya, “Keleka꞉ mabu Yoneko waloma꞉tapi ega꞉walo Pa꞉lisi tanebapi iba꞉te iyaiya tetelo bae naoa꞉no da꞉pola꞉nanaka Godokono woko osiyodiloma꞉, wiyasiya a꞉ma꞉ waloma꞉tapiate bae naoa꞉no ka꞉pola꞉nanakoa꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ya꞉sute iba꞉tamo negiya, “Dubute kamiyale daidimene, ebe tetelo ebeno namutupiate soliyomu bailo baea꞉no gito ba꞉ka꞉pola꞉nama꞉na꞉? Ao, modoboa꞉! Ebete iba꞉go eba pola꞉nalo soliyomu bae kapimiya kenaoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wiyasiya kamiyale oli aidi dubute ebeno kamiyale duliyomolo ida꞉mo magata tete na꞉pe, nanitabola, ebe egelalo ebeno namutupiate ibino tepo temeteme tanaloma꞉ bae naoa꞉no ka꞉pola꞉nama꞉na꞉. Ebema꞉ numa꞉la꞉, me tete ebe la꞉imano kalakalago bae nao tetela mabu nale la꞉go bokolinamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ebene Ya꞉sute tabo moga꞉melo walo na꞉kegiya, “Lumagite oli kaliku apu tagala kalikuno bolegala꞉mo a꞉kowaluomene. Ebete ma kunu dosiyodilomene, oli kaliku apute tagala kaliku kanagiyamidalemene, ebene bolegalete kawonomoma꞉ keda꞉mene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Atu gabodo lumagite tagala gautu-goeo tama kalila꞉mo oli da꞉imi obo akalatemene, mabu oli da꞉imi obote tagala tama kalili ka꞉na꞉ta꞉pulaemene, ebene da꞉imi obote opamo ka꞉ka꞉liyaote da꞉imi obo ega꞉walo kalili ibi netewate kapiya tetelo ka꞉kubakubaoma꞉na꞉. Me mabuma꞉ iyatawadawate oli da꞉imi obo olioli tama kalili kapiyamo balateonakomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yu epono wokoa꞉ talena egela idilo Ya꞉sute ebe waloma꞉tapiago kono pali magumudo eba petolamenatolo, ebe waloma꞉tapiate kono kenaoma꞉ kapiyakapiya kubakubadopo ebo nowakalamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ebene Pa꞉lisi tanebapi epetapiate Ya꞉sutamo negeliya, “Numa꞉, a꞉ma꞉ waloma꞉tapiate wokoa꞉ talena egela beda꞉ma꞉ kadikanalite?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ya꞉sute iba꞉tamo negiya, “Modobola Godote ebeno Bukamo dakuloliya, la꞉ ebe tanalo nemalagidilala꞉. Da꞉ibiditamo kuba tete da꞉piya, ebete ebeno wapata꞉lamepiago bae kapete dulamiti, ebene ebete beda꞉ tanalo kosiyodiliyale? ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ebete Godokono Motamo nodolote, ebe Motono wokopiate Godotamo dalomonakiya ebe talena bae ebete a꞉nenaiya. Numa꞉la꞉, aimano totomu tabote a niyatuamena Godotamo kalimagono ikameopiate ebe bae a꞉ka꞉tuwa꞉ naonaka, epo epetapiate nao talenala. Wiyasiya Da꞉ibidite ebe bae nate, eba꞉go wapata꞉lamepiatamo dikalamoliya, Godote ebe tanalo kubama꞉ kegiya꞉. Nanitabola, me tanalote Abayatakono tetelo pemaigiya, ebe Godotamo kalimagono ikameopino Unu Watodawanomola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ebene Ya꞉sute iba꞉tamo negiya, “Numa꞉la꞉, Godote wokoa꞉ talena egela epo walubilima꞉ eba osiyodilolo, ebete ubi kiyatiya꞉ wokoa꞉ talena egelamo epono ilukuli tanalo ka꞉kodakodailaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ebema꞉ nanitabola, na Epono Naniwite wokoa꞉ talena egela namutudawama꞉ eda꞉namo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tete idilo Yu epono balidi ibilamole motamo Ya꞉sute walo da꞉ka꞉nodoliya, koto apu a꞉eme dubute ebolo nokoliti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ebene ebe duliyomolono Pa꞉lisi tanebapiate Ya꞉suko kodakodamo umitiya, ebete wokoa꞉ talena egelalo ebe lumagi wadekobi midilo iba꞉te ebe kubama꞉ kegelama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ebe tetelo Ya꞉sute koto apu a꞉eme dubutamo negiya, “A꞉ma꞉ maigawete, mamo na꞉pa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ebene Ya꞉sute ebe epatamo negiya, “Aimano totomu tabote kebe talena tanalo kiyatuamenale? Ale wokoa꞉ egelalo wade tanalo o kuba tanalo ba꞉kosiyodiloma꞉? Epo wadekobi ba꞉ka꞉midilima꞉ o ba꞉ka꞉kubailaema꞉?” Iba꞉te wiya tabo kegeliya꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ebema꞉ Ya꞉sute dowate ibino wato kodakoda tanalo umilamete, ebe mabuma꞉ ibi tepo mibomibago eba ulamolelo ebe dubutamo negiya, “A꞉imano koto nuwamida,” ebene ebete koto duwamidiya ebeno kotote wadekobi ebo olowiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ebe mabuma꞉ Pa꞉lisi tanebapiate dowago tolamete, ebe tetenomolo iba꞉te Kawo Elawodubu Elodikono tanebapiago tabo ebo negeliya Ya꞉suko anakapuima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ebe tetelo Ya꞉sute ebe waloma꞉tapiago Ga꞉lili Paka꞉mo walo na꞉ka꞉tiya, ebene Yu epo bilibilinomate ebe tanalo olowite iba꞉te Ga꞉lili opone, Yudiya opone, ega꞉walo Yelusalema kawo duliyomolone pelamolete ebe ebo waloma꞉tiya. Ega꞉walo epetapi bilibilinomate iyaiya mulu opone atumu a꞉ka꞉pelamoliya, iba꞉te Idumiya opone, Yodane Kolomo apune, Taya kawo duliyomolone, ega꞉walo Saidono kawo duliyomolone pelamoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ebene ibi magumulo Ya꞉sute temetema꞉gopi bilibilinomo wadekobi da꞉midioliya, temetema꞉gopi bilibilinomo epetapiate ebe tanalo eba iyatawaolo ebe ologioma꞉ mupuma꞉tiuilo da꞉pelamiya, ebe mabuma꞉ Ya꞉sute ebe waloma꞉tapi nanaliya iba꞉te pe kadaema꞉, ebe epate ibino mupuma꞉tiui tanalamo ebe kubaimikapoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ebe tetelo kuba uliyanagopiate Ya꞉suko duminakiya, iba꞉te ebeno agowa mabuamo da꞉pa꞉gudinakiya gelatepaolo gelanakiya, “A꞉ma꞉ Godokono Gudulata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","wiyasiya Ya꞉sute ibi kawonomamo analenaki, mabu ebe ubia꞉nola iba꞉te ebeno tanalo awokalima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ebe tetelo Ya꞉sute damela unu ida꞉mo da꞉nodoliya, ebete ebeno ubi epo ebetamo peka꞉la꞉mite, iba꞉te ebetamo ebo tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ebene ebete ibi magumulo 12 dubu uwatete iba꞉tamo negiya, “La꞉ naimano alibolepilata. Nale la꞉ uwatemata la꞉le nago ilukulinama꞉, ebema꞉ nale la꞉ Godokono tabo kiyawaoma꞉ kalibolemamota, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ega꞉walo na la꞉tamo elawo kikalaemamota la꞉le kuba uliyana epagodone kanalibola꞉ema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ya꞉sute 12 dubu duwatiya, me ibino mailola. Saimonoko, Ya꞉sute ebetamo Pita mailo idi ikamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedikono gudu Ya꞉imesiko ega꞉walo ebeno ekawi Yoneko, Ya꞉sute ibi netewapiatamo Bowanagese mailo ikalamiya, ebe mailono magumu ebe ‘Tobolo Gelapate Dubula.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","A꞉nduluko ega꞉walo Pilipiko, Batolomuko ega꞉walo Ma꞉tiyuko, Tomasiko ega꞉walo A꞉lapiyasikono gudu Ya꞉imesiko. Ta꞉diyasiko ega꞉walo Saimonoko, me Saimono idi ebe ubila kapela Loma gabamani epago eba gowelalo iba꞉te ebeno Ka꞉inane opo ebo katepama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ega꞉walo Ya꞉sute Keliyota duliyomolodawa Yudasiko atumu akolawiya, me dubu ebe walone tetelo Ya꞉suko anakapumipi dowalubiliya ebe dawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ebene Ya꞉sute motamo da꞉tiya epo bilibilinomate ebetamo pelamete walo eba꞉go dakapaladabutiya, ebema꞉ Ya꞉suko ega꞉walo ebe waloma꞉tapi bae naoma꞉ ka꞉modobiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ebe tetelo ebeno ekakiate ebe tanalo olowite ebe laema꞉ ebo tolamiya, mabu epate iba꞉tamo ma kunu geliya, “Ebe daedalela!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ebene Godokono Totomu iyatulamepi Yelusalema kawo duliyomolone da꞉pelamiya, ebe dubate na꞉pegeliya, “Biyesibuluko ebegodolo bokolina, iyo, ebete kubakuba uliyanano Kawodawano elawamo alibolenako, Godokono elawamoa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ebene Ya꞉sute epo ebetamo ka꞉la꞉mite oi epetapiamo eba iyatulamelo negiya, “Saitanate ebeno kubakuba uliyana lumagigodone bakalibolemene? Ao, akalibolemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Numa꞉la꞉, kapiya duliyomolono epate tetedo dadikanalema꞉na꞉ ebe duliyomolote ka꞉kubamene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ega꞉walo kapiya motono epate tetedo dadikanalema꞉na꞉ ebe motono epate a꞉kilukulinama꞉na꞉, ibino motote atumu ka꞉ka꞉kubamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ebema꞉ Saitanakono woki ma kunula, ebete ebeno kubakuba uliyana epagodone akalibola꞉le, mabu kebe tetelo ebete eba kunu dowagelemene ebeno woko osiyodilo elawo tanalote kolopoligomene, iyo, ebeno uwomu bitana. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Numa꞉la꞉, Saitanako ebe elawodubu idi keba kunula꞉ka꞉ eba kunula, ega꞉walo ebete pilolo duwatiya ebe epo ebe ebeno moto inamabula. Ebema꞉ epate mako elawodubuno motamo opila꞉ote ebeno inamabu uwatema꞉ ubi diyatima꞉na꞉, iba꞉te dopamo ebe ala꞉mo matuomeote, ebene ebeno inamabu ebo kuwatema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Na la꞉tamo nani tabo gemo, epono iyaiya kuba tanalo bilibilinomo Godote egebolelamete dodolomatili iyatawala, ega꞉walo epate Godoko ubia꞉ tabo degelama꞉na꞉, ebe iyaiya kuba tabono tanalo Godote egebolelamete ka꞉dodolomatililaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wiyasiya kebe lumagite Godokono Uliyanano osiyodilo tanaloma꞉ kubama꞉ degemene, Godote ebe lumagino kuba egebolemete a꞉ka꞉dodomatiminamene, ebete uwomua꞉ tetelo ebe kubadawama꞉ begenakomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nanitabola, me tanalo Ya꞉sute giya mabu ebe epate ma kunu geliya, “Ebe kuba uliyanagodawala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ebene Ya꞉sukono menoko ega꞉walo ebeno ekaki iba꞉te ebe uima꞉ da꞉pelamiya, iba꞉te moto niyakabolo eba pelamota꞉onalo, ebete iba꞉tamo pema꞉ tabo ebo nalibiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ebe tetelo epo bilibilinomate Ya꞉suko niyakabolo na꞉pola꞉niya, ebene iba꞉te ebetamo negeliya, “Numa꞉, a꞉imano menoko ega꞉walo ekaki iba꞉te moto niyakabolo ba꞉pepola꞉na. Ibi ubila a꞉ma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ya꞉sute iba꞉tamo nowamiya, “Naimano menoko potelela꞉ka꞉, ega꞉walo naimano ekaki piyatela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ebene ebete epo ebe niyakabolo da꞉pola꞉niya ulamete negiya, “Me epo ebe naimano menokobila ega꞉walo naimano ekakila. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Potele Godokono ubi tanalo dosiyodilomene, ebe lumagi naimano menokola ega꞉walo naimano ekawila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tete idilo Ya꞉sute Ga꞉lili Paka꞉ balalo epo iyatulamiti, ebene epo bilibilinomate ebetamo da꞉pelamiya, ebema꞉ ebete peamo olote pe potone kela꞉mo nalima꞉tepate peamo gito okoliya, wiyasiya epate Ga꞉lili damela balalo pepola꞉niya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ebene ebete iyaiya tanalo epetapi bilibilinomo iyatulame oiamo eba awokalilamelo, iyatulame tabo idi iba꞉tamo ma kunu giya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“La꞉ nolowiala꞉. Lumagi idite pali amio bai dosiyodili kono kikopu aminaola꞉go ebo ti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ebete aminaola꞉go eba tonatolo, kikopu epetapi iba꞉te gabamo gudiya, ebema꞉ olaolate pelamete ebo penaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kikopu epetapi iba꞉te nokola damelamo gudiya, ebolo damela kawoa꞉. Ebema꞉ iba꞉te samonomamo pemaimiya mabu damela bidobidoa꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ebene egelate da꞉pioli iba꞉te nalawoiya mabu ibino dolodolo magumamo ka꞉tolamea꞉, iyo, iba꞉te ebema꞉ samonomamo a꞉elaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kikopu epetapi iba꞉te moemoe uwago damelamo gudiya, ebema꞉ ebe uwagate dapepeiya kono ebo anakapulamiya, ebene iba꞉te ka꞉noloa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wiyasiya kikopu epetapi iba꞉te wade damelamo gudiya, ebema꞉ iba꞉te apepeote ebo noloiya, epetapi 30 teta꞉mo, epetapi 60 teta꞉mo, epetapi 100 teta꞉mo bilibilinomoma꞉ eda꞉iya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ya꞉sute walo na꞉kegiya, “Galagodawa, a꞉ma꞉ wadenomamo nolowia!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ebene epo bilibilinomate Ya꞉suko datepiya, kapiyakapiya epo epetapiate ebeno 12 waloma꞉tapiago ebetamo pelamete na꞉pegeliya, “A꞉imano iyatulame oino magumu keba kunula꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ya꞉sute iba꞉tamo negiya, “Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalono magumu kelawa꞉ema꞉ nale elawo la꞉tamo ikalaimata, iyo, ebe tanalono wamina tanalo la꞉ iyatawaimata. Wiyasiya epo epetapi eba kunua꞉, iba꞉te iyatulame oine tanalo bilibilinomo olowiote wadenomamo a꞉kiyatawaoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nanitabola, ‘Iba꞉te bowadinakoma꞉na꞉ wiyasiya a꞉kuminakoma꞉na꞉, ega꞉walo iba꞉te bolowinakoma꞉na꞉ wiyasiya a꞉kiyatawaonakoma꞉na꞉, ebema꞉ iba꞉te ibino kubane a꞉kolobila꞉oma꞉na꞉, ega꞉walo Godote ibino kuba a꞉kegebolelaemene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ebene Ya꞉sute ebe waloma꞉tapiatamo negiya, “La꞉ me iyatulame oino magumu kiyatawawita꞉, ebema꞉ la꞉ walone tetelo naimano iyatulame oi epetapino magumu keba kunu na꞉kiyatawaema? Me oino magumu ma kunula, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","kono kikopu aminaoledawa ebete Godokono tabo naminaolena. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ebene epo epetapiate gabamo da꞉gudi, ibi ebe kono kikopu keba kunula꞉ka꞉ eba kunula, iba꞉te tabo dolowima꞉na꞉ Saitanate pete ibino tepo magumune samonomamo ka꞉puwatelaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Epo epetapiate nokola damelamo da꞉gudi, ibi ebe kikopula, iba꞉te Godokono tabo dolowima꞉na꞉ kalakalago kelaema꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","wiyasiya ibino tepo magumulo dolodolo puliyala. Ebema꞉ iba꞉te Godokono woko magumulo tete da꞉pesamo ilukula꞉tepate, ebene Godokono taboma꞉ temeteme tanalate iba꞉tamo da꞉pemaimioma꞉na꞉ ega꞉walo epate ibino tanaloma꞉ degelama꞉na꞉, iba꞉te samonomamo kalautioma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Epo epetapi iba꞉te moemoe uwago damelamo da꞉gudi, ibi ebe kikopula. Iba꞉te Godokono tabo kolowima꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wiyasiya iba꞉te inamabu kawonomamo malagidilolena ega꞉walo ibino ilukuli tanaloma꞉ woki bilibilinomoma꞉ eda꞉ona, ebema꞉ ibino tepo magumulo ebakobako woki bilibilinomo ba꞉pola꞉na, me wokino tanalate wade tabo eba anakapumilo, ebene iba꞉te a꞉ka꞉noloma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wiyasiya epo epetapi iba꞉te wade damelamo da꞉gudi, ibi ebe kikopula. Iba꞉te Godokono tabo olowite, nanitabonomolo lawete ka꞉noloma꞉na꞉, epetapi 30 teta꞉mo, epetapi 60 teta꞉mo, epetapi 100 teta꞉mo ka꞉noloma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ebene Ya꞉sute iba꞉tamo negiya, “Lumagite ebeno wuiki alo bagowo magumamo a꞉kiyatimene ega꞉walo ebeno wata bai magumamo a꞉kiyatimene, wiyasiya ebete awokala baiamo kiyatimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kebe waminaole tanalate da꞉pola꞉na walone tetelo Godote kawokalilaemene, ega꞉walo kebe ulamolea꞉ tanalate da꞉pola꞉na walone epate alo tetelo kulamolema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Galagodawa, a꞉ma꞉ wadenomamo nolowia!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ega꞉walo Ya꞉sute iba꞉tamo na꞉kegiya, “La꞉le dolowiawenama ebe tanalo wadenomamo nulamenakiyala꞉! La꞉le lumagi iditamo anagiyamida tanalo keba kunu kosiyodilaema, Godote la꞉tamo eba kunu ka꞉posiyodilomene, wiyasiya la꞉imano anagiyamida wiyate kawonomamo ka꞉pemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nanitabola, Godokono tabo olowima꞉ lumagigodolo wadewade woki da꞉pola꞉na, Godote ebetamo wadewade tanalo bilibilinomo walo ka꞉kikameomene. Wiyasiya lumagigodolo wadewade woki pola꞉na꞉no, ebegodolo kebe kapiyakapiya tanalate da꞉pola꞉na Godote ebegodone walo ka꞉kuwatemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ebene Ya꞉sute walo na꞉kegiya, “Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalo ma kunula. Dubute ebeno kawo pali damelamo kono kikopu daminaoli, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ebene ebete kowata, kemaiga, eba kunu eba wagelenalo, ebe kono wuiate pemaimite ebo apepeiya. Wiyasiya kikopuate damela magumulo eba pola꞉nalo tete geyageyadopolo iba꞉te keba kunu dapepeona, ebe dubute kiyatawana꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","mabu palino damelate a꞉ka꞉tuwa꞉ inamabu noloilamena, dopamo paa ega꞉walo ula, ebene nao kikopu. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ebema꞉ nanitabola, nao kikopuate da꞉kodakodaoma꞉na꞉, ebe dubute samonomamo tote ka꞉nowakalaimene, mabu kono wakalami tete a꞉pe.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ebene Ya꞉sute walo na꞉kegiya, “Godote Kawo Elawodawama꞉ deda꞉na ebe tanalo ale beda꞉ ula꞉mo nakawokalima꞉, ega꞉walo ebe tanalo ale kebako iyatulame oiamo na꞉ka꞉tupugaima꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nanitabola, me opo kawonomolo kewa kikopu kawokawonomo ba꞉pola꞉na wiyasiya mastada kikopu da꞉pesonomola, ebema꞉ Godote Kawo Elawodawama꞉ deda꞉na ebe tanalo mastada kikopu keba kunula꞉ka꞉ eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Dubute daimene, ebe da꞉peso kikopute apete kewa epetapi bilibilinomo odoilite kawokawo katomo kuwamidaolemene, ebene olaolate pelamete kewa katomono golololo ba꞉pilukulionama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nanitabola, epono iyatawa tanalote da꞉modobiya, Ya꞉sute ibi mako iyatulame oi bilibilinomamo iyatulamenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iyo, ebete Godokono tabo iyatulame oiamo kiyawaonaki, wiyasiya epo epetapi bilibilinomate ibino iyaiya duliyomolamo walo da꞉ka꞉tolamolenakiya, ebe tetelo ebe waloma꞉tapiatamo oi bilibilinomono magumu diya gabodo awokalilamenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ebe egelate didokoni, Ya꞉sute ebe waloma꞉tapiatamo negeni, “A paka꞉ apuamo ka꞉na꞉iwaliye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ebene iba꞉te epo bilibilinomo epetapi miyapanate, Ya꞉sute dokolini ebe waloma꞉tapiate ebe peamo olonate gito tolameniya. Ebe tetelo pe epetapi atumu iba꞉go na꞉ka꞉tolameniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ebene kawo awanomote eba maiganalo kawokawo ulono obote waloma꞉tapino peamo da꞉poloniya, pe gu obote gito tabokani. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Wiyasiya Ya꞉suko pe walogabo apulo ebeno wato ilakamo apatinate ebo watani, ebema꞉ iba꞉te ebe amutiyanate nananiya, “Iyatulamedawa, a꞉ma꞉ a wadenomamo beda꞉ma꞉ kuama꞉wena꞉? A ka꞉elaomalema꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ebene Ya꞉sute maiganate awa kawiya nanani, “Nolodiyoba!” ega꞉walo ulotamo atu tabo na꞉kegeni, “Nolopoloala꞉!” ebene awate olopoligonate paka꞉te matalukobi olowinomo gito olowini. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ebema꞉ Ya꞉sute iba꞉tamo negeni, “La꞉ beda꞉ma꞉ ka꞉toletoleawenama? La꞉imano nanitabokobi midi tanalo puliyala꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wiyasiya iba꞉te kawonomamo eba anoanonalo ibino taneba magumulo negelaniya, “Me lumagi potelela꞉ka꞉? Awa ega꞉walo ulo iba꞉te ebeno tabo olowite a꞉tudila꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ebene Ya꞉suko ega꞉walo ebe waloma꞉tapi iba꞉te Ga꞉lili Paka꞉ apuamo na꞉iwaliya Gelasa duliyomolono opamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ya꞉sute pene damelamo eba nodololo, kuba uliyanagono dubute eba꞉go alugoma꞉ ebo piya. Ebe opo epono tanalo ma kunula, iba꞉te maboele nokola damela eba obobolelo iyaiya bobo ebo osiyodilolenakiya iba꞉te ibino a꞉elao epo alomoma꞉. Ebema꞉ me dubute ebe a꞉elao epono bobo baine piya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","mabu ebete ebe nokola bobo magumulo okolinami. Epate ebe auli ala꞉mo dematuomeonakiya ebe ale ka꞉modobonakia꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","iyo, tete bilibilinomolo iba꞉te ebeno agowala kotola auli ala꞉mo dematuolamolemenakiya, ebete kotono ale iyailinaki ega꞉walo agowano ale atumu a꞉kiyailinaki. Nanitabola, ebete elawonomoma꞉ eda꞉nami, ebema꞉ lumagite ebe odiyoboma꞉ modoboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ega꞉walo ebete egela ega꞉walo idoko bilibilinomolo nokola bobo magumulo ega꞉walo damela unulo eba geatepaolo, ebe a꞉ka꞉tuwa꞉ ebeno tama nokolamo danagalimionaki kalimate ebo pemaimiomenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ebene me dubute Ya꞉suko muluamo numite, ebetamo na꞉puligate ebeno agowa mabuamo da꞉na꞉tuduwatiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ya꞉sute ebetamo negiya, “Kuba uliyana, a꞉ma꞉ me dubugodone na꞉nemaiga!” Ebe tetelo ebete geatepaolo negiya, “Ya꞉su! A꞉ma꞉ Ununomo Godokono Gudulata! A꞉ma꞉le natamo beda꞉ tanalo na꞉kosiyodilaemene? Nale a꞉ma꞉ Godokono mailamo anamata, natamo kuba wiya akoikanama꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ebene Ya꞉sute ebe nalatediya, “A꞉imano mailo potelela꞉ka꞉?” Ebete nowamiya, “Naimano mailo Bilibilinomotela mabu a kuba uliyana bilibilinomola!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ebene ebe dubute Ya꞉suko kawiya eba toweomelo ebe naniya, “Nagodolo dilukulina ebe kubakuba uliyana me opone akoalibola꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ebe tetelo dabiole goeogoeo bilibilinomate damela unulo naoago ebolo nowapata꞉lamitiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ebema꞉ kubakuba uliyanate Ya꞉sutamo towetoweolo negeliya, “A꞉ma꞉le a goeogoeatamo naliboa꞉, ale iba꞉tamo ka꞉nopila꞉oma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ebene Ya꞉sute modobo tabo gete ibi ebo analiya, “Na꞉tolama꞉la꞉!” Ebe tetelo kubakuba uliyanate dubugodone pemaimite goeogoeatamo ebo nopila꞉iya, ebema꞉ ebe 2,000 goeogoeate damela unune puila꞉ote maboele damelane da꞉na꞉gudiya, obamo nololuote ibi bilibilinomate gito na꞉elaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ebe tetelo goeogoeo ulamepi dubate ebe tanalo umite ibino duliyomolamo puila꞉ote ebe duliyomolo epo ega꞉walo tumu motolo dilukulinamiya da꞉nikiyawaolamiya, epo bilibilinomate ebo pelamiya Ya꞉sute dosiyodiliya ebe tanalo uima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iba꞉te ebetamo pemaimite, dopamo kubakuba uliyana bilibilinomago dokolinami ebe dubu ebo pumiya, ebete kaliku pulite ebolo okoliti mabu ebeno woki a꞉tuputupuomiya. Me mabuma꞉ iba꞉te na꞉toletoleutiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ebene Ya꞉sute kubakuba uliyanagono dubutamo ega꞉walo goeogoeatamo kebe iyaiya tanalo kosiyodiloliyale, piyate ebe tanalo dulamiya iba꞉te epo epetapi ebo kiyawaolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ebe tetelo ebe epate Ya꞉suko kawiya naniya ebete ibino opo katepama꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ebene Ya꞉sute peamo eba ololo, dopamo kubakuba uliyanago dokolinami ebe dubute ebe ebo toweomiya, “Na niyala, a꞉ma꞉go ka꞉pa꞉mo!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wiyasiya Ya꞉sute ebe eba odiyobolo naniya, “A꞉ma꞉ motamo na꞉toa. Godote a꞉ma꞉tamo keba kunu kosiyodilola꞉kale ega꞉walo a꞉ma꞉ da꞉nilakapoimitaka, ebe kawokawo tanalonomo a꞉imano mabu epo na꞉nikiyawaolama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ebema꞉ me dubute Teni Duliyomolono opo kawonomamo tote, Ya꞉sute ebetamo dosiyodiliya ebe tanalo kiyawaolama꞉go tiya, ebene piyate ebe iyaiya tanalo dolowiya iba꞉te kawonomamo anoanoiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ebene Ya꞉sute peago paka꞉ apuamo walo da꞉ka꞉na꞉iwiya, ebete ebolo eba nokolitalo epo bilibilinomate ebetamo ebo pelamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ebe tetelo Yu epono balidi ibilamole moto umidawa dubu, ebeno mailo Ya꞉ilasitela, ebete Ya꞉sutamo pete ebeno agowa mabuamo pa꞉tuduwatate, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kawonomamo eba petowetoweolo na꞉pegiya, “Naimano buwele da꞉peso a꞉e tatalila. A꞉ma꞉ pa꞉wete a꞉imano koto ebetamo na꞉powatila꞉ ebete wadekobi kolowima꞉, ebene ebete a꞉ka꞉emene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ebene Ya꞉sute me dubago to dowagilimiya, epo bilibilinomate ebe eba a꞉wa꞉midalo mupuma꞉tiua꞉go tolamitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ibi magumulo kamiyale idi 12 ulama tetelo kalima ka꞉ka꞉liya temetemete uminami, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","doketa epo epetapiate ebetamo mibomibo tanalo ikameonamiya. Iba꞉te ebe wadekobi ka꞉midiya꞉, wiyasiya ebe kamiyalete ebeno mani iba꞉tamo eba ikalamolelo dopoliyaliya, ebeno temetemete kawodopoma꞉ ediya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ebema꞉ ebete Ya꞉sukono tanalo dolowiya epo magumamo nopegate, ebeno walogabo apune pete ebeno kaliku ebo pologiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","mabu ebete nemalagidiliya, “Nale ebeno kaliku dologimo na wadekobi ebo kolowimamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ebene ebete Ya꞉sukono kaliku dologiya, ebe tetenomolo ebeno kalima ka꞉ka꞉liya tanalote dolopoligiya ebete iyatawiya ebeno ape a꞉modobo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wiyasiya Ya꞉sute iyatawiya elawote ebegodone demaigiya, ebene ebete polobigate epo napalateda꞉liya, “Naimano kaliku potele kologile?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wiyasiya ebe waloma꞉tapiate ebe naniya, “Me epo bilibilinomate a꞉ma꞉tamo mupuma꞉tiua꞉go pelamita. A꞉ma꞉ ibi ulamelo beda꞉ma꞉ kegeawita a꞉ma꞉ potele kologita?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ya꞉sute ibi kowamilamiya꞉, wiyasiya ebete me lumagi kuima꞉ epo ulamoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ebe tetelo ebe kamiyalete iyatawiya Ya꞉sukono elawote ebeno ape wadekobi a꞉midi, ebema꞉ ebete toletolelo anakamiago pete, Ya꞉sukono agowa mabuamo pa꞉tuduwatalo ebeno temetemeno tanalo ebetamo ebo pawokalilamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ebene Ya꞉sute ebetamo negiya, “Kamiyale, a꞉imano nanitabokobi midi tanalote a꞉ma꞉ wadekobi a꞉mida꞉ta. A꞉ma꞉ kalakalago na꞉toa, mabu a꞉ma꞉ dumitanamiya, ebe temetemete olopoligo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ya꞉suko me tabo eba kiyawautalo, tabo adaepiate Yu watodawa Ya꞉ilasikono motone pelamete ebe napaniya, “A꞉imano buwele a꞉e, ebema꞉ Iyatulamedawa walo akoanala꞉ ebe wadekobi ka꞉pa꞉midima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ya꞉sute ibino tabo gito olowiatepiya, ebene ebete Ya꞉ilasiko naniya, “A꞉ma꞉ akotoletola꞉la꞉, a꞉ma꞉ Godoko nanitabokobi na꞉mida꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ebe tetelo ebete Pitako, Ya꞉imesiko, ega꞉walo ebeno ekawi Yoneko, ibi kapiya eba magatalelo epo epetapi nodiyoboliya iba꞉te iba꞉go ka꞉tolaema꞉ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ebene ibi a꞉ka꞉tuwa꞉ Ya꞉ilasikono motamo da꞉nemaimiya Ya꞉sute epo bilibilinomo ebo nulamiya, iba꞉te gowelalo kawonomamo iimitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ya꞉sute moto guamo nodolote ibi nananaliya, “La꞉ bilibilinomo gowelalo beda꞉ mabuma꞉ kiima꞉witama? Gudu buwele ka꞉eaka꞉, ebe u watita.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wiyasiya iba꞉te ebe nekalakalatitiya, ebema꞉ ebete ibi bilibilinomo motone gito paliboliya, ebene Ya꞉sute guduno menokola, nabiwila, ega꞉walo ebeno netewa-kapiya waloma꞉tapi uwatete, gudute dekapitani iba꞉te ebe teta꞉mo gito nopila꞉iya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ebe tetelo ebete buwele kotamo nelawete Yu epono tabamo naniya, “Talita kumi!” Me tabono magumu nitana, “Buwele, nale a꞉ma꞉ anamata, nemaiga!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ebene ebe tetenomolo ebe 12 ulama tete buwelete maigate nepatiya. Piyate me tanalo dumiya iba꞉te kawonomamo anoanoiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","wiyasiya Ya꞉sute ibi kawonomamo analiya, “La꞉ me tanaloma꞉ epo epetapi akoanala꞉la꞉!” ega꞉walo ebete iba꞉tamo na꞉kegiya, “Buweletamo nao inamabu nikameala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ebe tetelo Ya꞉sute ebe duliyomolone tote ebeno okoli duliyomolo Nasaleta꞉mo walo da꞉ka꞉tiya, ebe waloma꞉tapiate ebe ebana kapimiya ka꞉tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ebene Yu epono wokoa꞉ talena egelalo ebete balidi ibilamole motolo epo eba iyatulamitalo, ibi bilibilinomo epetapiate ebeno tabo dolowiutiya ebema꞉ anoanoutiya. Iba꞉te negeliya, “Me dubuno iyatulame tanalo mulonomola! Ebete me iyaiya tanalo kebolo kiyatawile? Ega꞉walo ebete anoano tanalo dosiyodilolena beda꞉ kawokawonomola꞉ka꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ebe kapeneta dubunomola, Ma꞉likono gudula. A iyatawala ebeno ekaki Ya꞉imesiko, Yausesiko, Yudasiko, ega꞉walo Saimonoko, iyo, ebeno ekaki buwelemela꞉te me duliyomololo ago bilukulita.” Ebene iba꞉te ebe ubia꞉noma꞉ eba eda꞉utalo ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ya꞉sute iba꞉tamo negiya, “Godokono woki awokalimidawa epate ebe unamo kadipatema꞉na꞉, wiyasiya ebeno duliyomolo epo ega꞉walo ebeno moto epo ega꞉walo ebeno kalima epo, iba꞉te ebe ubia꞉noma꞉ beda꞉onakoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Ebe tetelo Ya꞉sute Nasalete epono nanitabokobi midia꞉ tanaloma꞉ kawiya la꞉wa꞉te, ebete ebeno koto temetema꞉gopi kapiyakapiyanomatamo dowatiolelamiya ibi wadekobi ebo midioliya, wiyasiya ebete ibino duliyomololo anoano tanalo epetapi osiyodilolema꞉ ka꞉modobiya꞉, ebema꞉ ebete ibi eba miyapalo wiyasiya iyaiya duliyomolo epetapilo iyatulama꞉go pata꞉nami. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ebene Ya꞉sute ebeno 12 waloma꞉tapi ebetamo ka꞉la꞉mite, epetapi netewa, epetapi netewa, iyaiya duliyomolamo ebo aliboliya, ega꞉walo ebete iba꞉tamo elawo ikalamiya kubakuba uliyana epagodone kanalibolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ebete ibi nanaliya, “La꞉imano tolame tetelo gaubu kapiya nuwatiyala꞉, wiyasiya inamabu epetapi akouwata꞉la꞉, iyo, la꞉ baea꞉no, gatelea꞉no, ega꞉walo mania꞉no na꞉tolamiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ega꞉walo modobola la꞉ agowa inamabu ega꞉walo kapiyakapiya kaliku pupuliawete ebo na꞉tolamiyala꞉, pupuliono inamabu epetapi akouwata꞉la꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ebene la꞉ duliyomolo ida꞉mo nemaima꞉wete kebe moto guamo da꞉nodoloaema, la꞉ ebe motolo nilukula꞉tepawete walone ebe motone opo ida꞉mo ka꞉ka꞉tolaemamota, iyo, la꞉ moto idine moto ida꞉mo eba kunu akonowagela꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ega꞉walo kebe duliyomolo epate la꞉ kalakalago uwateta꞉no ega꞉walo la꞉imano tabo olowia꞉no, ebe duliyomolo eba atepalo la꞉le agowano tuwae na꞉moda꞉midatepaliyala꞉. Me tanalote ebe epo kiyatulaemene, Godokono tete ebe na꞉pe ebete ibino tanalo kapanagiyamidalaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ebema꞉ Ya꞉suko waloma꞉tapiate tolamete Godokono tabo na꞉kiyawaolamenatiya epate ibino kubane kolobila꞉ma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ebene iba꞉te epagodone kubakuba uliyana nalibolenakiya, ega꞉walo iba꞉te temetema꞉gopi epetapi bilibilinomo olibi kikopuno iamo ibino wato dabutilamolelamenakiya, ibi wadekobi ebo midiolenakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ebe tetelo Kawo Elawodubu Elodite ebe anoano tanalo olowiya, mabu epo bilibilinomate Ya꞉sukono tanalo eba iyatawaolo ibi magumulo epetapiate tabo ma kunu geliya, “Yoneko epo obamo waduba꞉midaoledawate a꞉e magumune emaigi, ebema꞉ me anoano tanalate ebegodone pemaiminaka.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ebene epetapiate negeliya, “Ebe Elayate, Godokono woki awokalimidawala,” wiyasiya epetapiate na꞉kegeliya, “Ao, ebe Godokono woki awokalimidawa idila, dopamo aimano ewoniatamo da꞉pemaimiya ibi keba kunula꞉ka꞉ eba kunula.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wiyasiya Elodite Ya꞉sukono tanalo dolowiya, ebete negiya, “Me dubu ebe Yonetela, nale ebeno wato dotowamidaimo, wiyasiya ebete a꞉ene walo a꞉kemaigi!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Me tanalo ebe Yonete keba kunu ka꞉iyale ebe tanalola. Yonete dopamo eba okolinalo, Kawo Elawodubu Elodite ebeno ekawi Pilipikono kamiyale pilolo lawiya, ebe kamiyaleno mailo Elodiyasitela. Me mabuma꞉ Yonete Elodiko kawiya eba analo negiya, “A꞉ma꞉le ebe kamiyale laema꞉ modoboa꞉, kawo kubanomola!” Ebema꞉ Elodite ebeno gowelaopi daliboliya, iba꞉te Yoneko nelawete idoko moto guamo gito peba꞉idiliya, mabu ebete ebeno ubi niyatiya ebe osiyodilo tanalodo ebete Elodiyasiko kalakalakobi ka꞉midima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ebe tetelo Elodiyasite Yonetamo dowate ebe anakapuima꞉ ebeno ubi ebo iyatiya, wiyasiya Elodite me tanalo osiyodiloma꞉ ubia꞉nola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ebete Yoneko na꞉tolemenami, mabu ebe iyatawala Yonete tuputupudawama꞉ eba eda꞉nalo Godokono talena magumulo okolina. Nanitabola, ebete Yonekono tabo dopamo dolowiya woki bilibilima꞉ ebo ediya, wiyasiya ebete idoko motolo eba okolinalo, Elodite ebe wadenomamo eba uminalo iyaiya tete epetapilo ebete ebeno tabo kalakalago olowinaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ebene Elodite dawokaliya, ebe egela malagidilolo ebete kawo soliyomu osiyodiluti. Ebema꞉ ebeno gabamani dubu, gowelaopi elawodubu, ega꞉walo Ga꞉lili opono watowatopi, ibi bilibilinomate soliyomu baiamo tolamiya. Ebe tetelo Elodiyasite wade tete ebo umiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ebete ebeno buwele nalibote, ebete ibino ololo apulo da꞉pemaiti, Elodiko ega꞉walo eba꞉go da꞉pola꞉niya iba꞉te ebetamo nekalakalautiya. Ebene Elodite buweletamo negiya, “A꞉ma꞉le kebe tanaloma꞉ na danana꞉emene, nale a꞉ma꞉tamo kikaemamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Elodite ebetamo nanitabonomolo walo na꞉kegiya, “A꞉ma꞉ beda꞉ tanaloma꞉ na danana꞉emene, a꞉imano ubi diyata꞉emene naimano inamabu apu ega꞉walo naimano opo epetapi, nale a꞉ma꞉tamo kikameomamota! Naimano tabo akadikanalemo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ebene ebe buwelete ebeno menokotamo tote na꞉negiya, “Na beda꞉ tanaloma꞉ na꞉ka꞉negemo?” Ebeno menokote naniya, “A꞉ma꞉ Yoneko epo obamo waduba꞉midaoledawano watoma꞉ ebe nananiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ebene ebe buwelete Kawo Elawodubu Eloditamo samonomamo walo ka꞉pete ebe napaniya, “Na ubila Yoneko epo obamo waduba꞉midaoledawano wato kikopu kawatago. Ka꞉lonomo natamo nikanama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ebema꞉ Elodite ebeno tepo magumulo mibomibonomoma꞉ ediya, wiyasiya ebete buweletamo kebe tabo kegiyale, eba꞉go da꞉pola꞉niya iba꞉te ebe tabo olowiya, ebe mabuma꞉ ebete amoeda꞉ma꞉ ka꞉modobiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ebe tetenomolo Elodite ebeno gowelaodawa dubu idi eba nalibolo, ebe naniya ebete Yonekono wato ka꞉nelaema꞉, ebene ebete idoko moto guamo tote Yonekono wato ebo notowamidamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ebene ebete wato kawatamo niyatite buweletamo dadaiya, ebete lawete ebeno menokotamo gito nikamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ebe tetelo Yoneko waloma꞉tapiate ebe tanalo dolowiya, iba꞉te ebeno apenomo pelawete nokola bobo magumamo gito niyatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ebene Ya꞉sute daliboliya ebe waloma꞉tapi dubate walo ebetamo ka꞉pelamete, iba꞉te kebe iyaiya tanalo epagodolo da꞉nosiyodiloliya ega꞉walo ibi keba kunu ka꞉niyatulamoliye, ebe tanalo bilibilinomoma꞉ iba꞉te ebe na꞉pa꞉kiyawaomiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ebe tetelo epo bilibilinomate Ya꞉suko uima꞉ odoliatepauilo wapata꞉lamitiya, ebema꞉ Ya꞉suko ega꞉walo ebe waloma꞉tapi bae naoma꞉ tete kumiya꞉. Ebe mabuma꞉ ebete ibi nanaliya, “Modobola a a꞉ka꞉tuwa꞉ diyamoa꞉ opamo tolamete ela kanamiye,” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ebene iba꞉te ibino peago diyamoa꞉ opo ida꞉mo tolaema꞉ ebo wagilimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wiyasiya iba꞉te eba tolamitalo, epo bilibilinomate ibi ulamete iyatawiya ibi piyatela꞉ka꞉. Ebema꞉ Ya꞉sute kebamo ka꞉tutiyale, ebe iyaiya duliyomolo bilibilino epate ebe tanalo umite, iba꞉te paka꞉ balado puila꞉ote ebe opamo dopamo gito nemaimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ebene Ya꞉sute ebamo da꞉nemaigiya, epo bilibilinomo nulamete ebeno tepo magumulo ibi kawonomamo na꞉nilakapoilamiya, mabu sipi-goeogoeate ulamedawa꞉no keba kunu kilukuline iba꞉te eba kunu pola꞉niya, ebema꞉ ebete ibi iyaiya tanalo epetapi bilibilinomo eba iyatulamelo, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","iba꞉te adimo teta꞉mo ebo nemaimioniya. Ebe tetelo ebe waloma꞉tapiate ebetamo pelamenate ebe napananiya, “Me epoa꞉ opola, samamo kidokomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ebema꞉ a꞉ma꞉ ibi nalibola꞉, iba꞉te iyaiya duliyomolamo ega꞉walo ea꞉ge motamo tolamete bae ka꞉nuwateoma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ya꞉sute wiyasiya ibi nanaleni, “Ao, la꞉le iba꞉tamo nao inamabu nikalamola꞉la꞉.” Ebene iba꞉te ebe nalateda꞉niya, “A tolamete kapiya ulamano woko wiya maniamo bae uwateote, iba꞉tamo ebo ba꞉kikalamolema꞉? Ao, a modoboa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ebene Ya꞉sute ibi nalateda꞉leni, “La꞉godolo kebalata baete ka꞉pola꞉nale? La꞉ tolama꞉wete na꞉nulama꞉la꞉.” Iba꞉te ulamenate negelaniya, “Agodolo paibu bae ega꞉walo namo netewa ba꞉pola꞉na.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ebene ebete ebe waloma꞉tapi nanaleni, “Epo nanala꞉la꞉ iyaiya taneba osiyodilolete wade uwagolo kilukulioma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ebema꞉ epate iyaiya taneba bilibilinomo osiyodilolenate ebo pola꞉niya, taneba idi magumulo 100, taneba idi magumulo 50, eba kunu ilukulioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ebene Ya꞉sute paibu bae ega꞉walo namo netewa uwatenate, Unu Duliyomolamo melenalo Godotamo kalakala tabo genate bae wakalamiolenate ebe waloma꞉tapiatamo gito ikalameni iba꞉te epatamo kikalamolenama꞉, ega꞉walo ebete atu gabodo namo netewa kuwatenate epo bilibilinomatamo ebo kikalamoleni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ebe tetelo epo bilibilinomate bae denaoniya ibino bae kape tanalo ebo olopoligolameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","Nanitabola, ebe bae 5,000 dubate naoniya, ebene da꞉luiliniya ebe bae apuapuamo ega꞉walo namo apuapuamo Ya꞉suko waloma꞉tapiate 12 bagowo ebe owiyaoleniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ebe tetenomolo Ya꞉sute epo eba alibolenalo ebe waloma꞉tapiatamo negeni, “Pe lawa꞉wete Ga꞉lili Paka꞉ apuamo na꞉na꞉iwala꞉la꞉ Betasaida duliyomolamo,” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ebene ebete ibi bilibilinomo alibolenate, ebete damela unamo gito nodoloni Godago tabo ka꞉negelanama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Didokoni waloma꞉tapiate peago paka꞉ tulitulinomodo eba tolamenalo, wiyasiya Ya꞉sute damelalo a꞉ka꞉tuwa꞉ okolini. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ebete ibi ulameni, iba꞉te pe elawonomamo dabidiloniya wiyasiya ibino elawo ka꞉modoboniya꞉ mabu awate ibi nodiyoboleni, ebema꞉ idoko tetelo egela walo tatalima꞉ eba eda꞉nalo, ebete obo unudo iba꞉tamo ebo toni ibino ololo apudo ka꞉petonama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Wiyasiya ebete obo unudo eba tonatolo, iba꞉te ebe uminate oboloma꞉ gelanate ebo gelatepaoniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","mabu ibi bilibilinomate kubanomamo toletoleoniya. Ebe tetenomolo Ya꞉sute ibi nanaleni, “Na Ya꞉sutela, la꞉ ka꞉toletoleonala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ebene ebete penate ibino peamo da꞉poloni awate gito olopoligoni. Ebe tetelo ebe waloma꞉tapiate kawonomamo anoanoniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mabu iba꞉te ibino tepo magumulo kodakodama꞉ eda꞉onamiya, iyo, ebe mabuma꞉ Ya꞉sute epo bilibilinomatamo bae dikalamoleni, iba꞉te ebe anoano tanalono magumu ibino wokiamo nipo wadiniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ebene iba꞉te duiya tetelo paka꞉ apuamo da꞉na꞉iwaliya Genasalete opono pe boboamo pe gito na꞉iliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Iba꞉te pene damelamo da꞉nodoloiya, piyate ebolo da꞉pola꞉niya ebe epate Ya꞉sukono tanalo samonomamo iyatawaote, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","iba꞉te ebe opono iyaiya duliyomolamo na꞉puila꞉iya epo epetapi ebeno pe tanalo kananalema꞉. Nanitabola, Ya꞉sute kebe duliyomololo da꞉lutanaki, epate ebe tanalo dolowinakiya temetema꞉gopi ketago ebo magatalenakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iyo, Ya꞉sute kebe iyaiya depeso ega꞉walo kawokawo duliyomolo ega꞉walo tumu motamo da꞉tonaki, epate ibino temetema꞉gopi ebamo demagatalenakiya, iba꞉te ibi ebe iyaiya duliyomolono inamabu olowame baiamo eba nowadilatililo ebe ebo na꞉toweomenakiya temetema꞉gopiate ebeno kaliku kologioma꞉. Ebema꞉ nanitabola, piyate ebeno kaliku dologionakiya, iba꞉te wadekobi ebo olowionakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ebene Pa꞉lisi tanebapi ega꞉walo Godokono Totomu iyatulamepi magumulo piyate Yelusalema kawo duliyomololo woko dosiyodilolenamiya, ibi epetapiate Ya꞉sutamo kapimiya da꞉pelamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","iba꞉te ebeno waloma꞉tapi epetapi pulamiya, iba꞉te koto ukulaolea꞉no bae denautiya. Me gabodo iba꞉te Pa꞉lisi tanebapino totomu tabo ida꞉mo ka꞉tudiliya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Numa꞉la꞉, Yu epo bilibilinomono ewoniate ibi diyatulamenamiya, ibi bilibilinomate ebe atu wokilo eba ilukulinalo ebo osiyodilolenaka, ega꞉walo Pa꞉lisi tanebapiate ebe ewonino totomu tabamo atumu wadenomamo ka꞉tudila꞉ona, kebako totomu da꞉pesonomo idi iba꞉te kadikamidalena꞉. Me mabuma꞉ ibino koto wadenomamo ukulaolea꞉no iba꞉te bae a꞉kenaoma꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ega꞉walo nao inamabu olowame bailo duwateoma꞉na꞉ iba꞉te ebe inamabu ukulaolea꞉no a꞉ka꞉penaoma꞉na꞉. Nanitabola, iba꞉godolo obo nio kalili ega꞉walo iyaiya okalimiono kalili ukulaole totomuate ba꞉ka꞉pola꞉na, iyo, ma kunu ibino ewoniate iba꞉tamo dikalamoliya, ebakobako totomu epetapi bilibilinomo iba꞉godolo ba꞉pola꞉na. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ebema꞉ Pa꞉lisi tanebapiate Godokono Totomu iyatulamepiago Ya꞉suko nalatediya, “Beda꞉ mabuma꞉ a꞉ma꞉ waloma꞉tapiate aimano ewoniate degelanakiya ebe totomuamo ka꞉tudila꞉ona꞉, wiyasiya ibi a꞉ka꞉tuwa꞉ ibi kubailamete koto ukulaolea꞉no bae ebo naonaka?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ya꞉sute iba꞉tamo negiya, “La꞉ mena netewa epolata! Godokono woki awokalimidawa Aisayate la꞉imano tanaloma꞉ dopamo nani tabo da꞉kiyawaiya, Godokono Bukalo ebe tabote ma kunu itana, ‘Me epate na tabamo amamanatenena, wiyasiya ibino tepo magumuno woki na niyakabolo ka꞉pola꞉na꞉, mulunomolo ba꞉na꞉pola꞉na. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Iba꞉te naimano mailo unamo nadipatena, wiyasiya nanitabo tanalo puliyala, iyo, iba꞉te me opo epono totomu Godokono Totomunomoma꞉ midilite ebo iyatulamenaka.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ebene Ya꞉sute walo na꞉kegiya, “Aisayakono tabo nanitabonomola, mabu la꞉ Godokono Totomu Tabonomo a꞉miyapiyamata, wiyasiya epate degelana ebe totomuamo tudila꞉onamata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“La꞉ mulo eponomolata! La꞉ Godokono Totomu Tabonomo iyabaiamo eba alomonalo, wiyasiya la꞉imano ewoniate degelanakiya la꞉ ebe iyaiya tanalo kapiya osiyodilolenakomata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Numa꞉la꞉, Godokono Bukalo Mosesete negiya, ‘La꞉imano menokobila nabila nowalubila꞉la꞉,’ ega꞉walo ebete na꞉kegiya, ‘Kebe lumagite ebeno menoko o nabiwino tanaloma꞉ kuba tabo da꞉kiyawaomene, la꞉le ebe nanakapumiyala꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wiyasiya la꞉ me Godokono tabo iyabaiamo alomawete negelanamata, ‘Lumagigodolo da꞉pola꞉na ebeno menokola nabiwila walubilima꞉, ebete iba꞉tamo ikalaema꞉ ubia꞉noma꞉ deda꞉mene, kuba꞉nola. Ebete gito kegemene, ‘Me inamabu talenala, nale Godotamo ikameote me inamabuamo naimano menokola nabiwila a꞉kowalubilimo.’ ’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ebema꞉ la꞉ ebako kuba woki lumagi nemalionakomata, ebete ebeno menokola nabiwila kowalubilina꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Iyo, me gabodo la꞉imano iyatulame tanalate Godokono nani tabo iyabaiamo alomona, ebene la꞉le ebe atu kuba woki gabodo iyaiya tanalo epetapi bilibilinomo na꞉kosiyodilolenamata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ebene Ya꞉sute epo ebetamo walo keka꞉la꞉mite iba꞉tamo negiya, “La꞉ bilibilinomo naimano tabo olowiawete, woki wadenomamo na꞉tuputupuilama꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Lumagi niyakabolo ditana ebe inamabute ebe magumamo opegate ebe a꞉ka꞉kubaimene, wiyasiya lumagino tepo magumune da꞉pemaima꞉na꞉ ebe tanalate ebe ka꞉kubaima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Galagodawa, a꞉ma꞉ wadenomamo nolowia!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ebene Ya꞉sute epo miyapate moto guamo da꞉nodoliya, ebe waloma꞉tapiate ebete beda꞉ tabo kegiyale, ebe tabono magumuma꞉ ebe nalatediya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ebete iba꞉tamo negiya, “Epetapiate woki wadenomamo ka꞉tuputupuilamena꞉, la꞉ atumu. La꞉ iyatawala꞉ka꞉? Nao inamabute lumagino tepo magumamo opegate ebe a꞉ka꞉kubaimene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","mabu nao inamabute lumagino woki mabuamo ka꞉tuta꞉, wiyasiya wapuamo tuta ebene neago ka꞉penemaigamene.” Ebema꞉ nanitabola, Ya꞉sute me tabamo nao inamabuno talena bilibilinomo iyabaiamo alomonomo alomiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ebene ebete walo na꞉kegiya, “Numa꞉la꞉, lumagino tepo magumune da꞉pemaimioma꞉na꞉ ebe tanalo kapiyate ebe ka꞉kubaima꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","mabu lumagino tepo magumune iyaiya kuba wokino tanalate pemaiminaka, ebene ebe kuba wokine me kawokawo kubate ka꞉pemaiminaka — buwele pilo tanalo ega꞉walo lumagi idino kamiyale pilo tanalo, inamabu pilo tanalo ega꞉walo lumagi idino inamabu ubi tanalo, dowa tanalo ega꞉walo lumagi anakapumi tanalo, elemasigi tanalo ega꞉walo lumagino mailo kubaimi tanalo, apa꞉mo kuba osiyodilole tanalo ega꞉walo iyaiya kuba olelo osiyodilole tanalo, amama tanalo ega꞉walo daedale wokino tanalo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iyo, nanitabola! Me kuba bilibilinomate lumagino tepo magumune pemaimite lumagi ebo ka꞉kubaima꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ebene Ya꞉sute ebe opo atepate Taya kawo duliyomolono opamo gito tiya. Ebe tetelo ebe ubia꞉nola ebete kebe motamo da꞉nodoliya epate iyatawaoma꞉, wiyasiya iba꞉te ebe moto samamo iyatawiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ebema꞉ ebe opo kamiyale idi, ebeno buwele da꞉peso kuba uliyanagonola, ebete Ya꞉sukono tanalo olowite ebetamo pete ebeno agowa mabuamo eba pa꞉tuduwatalo ebe ebo petoweomiya, ebete ebeno buwelegodone kuba uliyana kaliboma꞉. Wiyasiya me kamiyale Yu lumagia꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ebema꞉ Ya꞉sute ebetamo negiya, “Mabu keleka꞉ nale a꞉ma꞉ owalubima꞉ degeawita? Epate dopamo ibino guda꞉tamo bae nikalaema꞉na꞉. Modoboa꞉ iba꞉te gudino bae epetapiatamo gito ikalaema꞉, mabu ebe osiyodilo tanalo ebe gaagaatamo ikalame tanalo keba kunula꞉ka꞉ eba kunula.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ebete wiyasiya Ya꞉sutamo negiya, “Kawodawa, a꞉ma꞉le degeawa꞉ nanitabola, wiyasiya guda꞉te opamo diyalekenaka, ebe bae apuapu gaagaate naoma꞉ modobola!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ebene Ya꞉sute ebetamo negiya, “Mabu a꞉ma꞉ eba kunu egeata, a꞉ma꞉ kalakalago motamo na꞉toa. Kuba uliyanate a꞉imano buwelegodone a꞉nemaiga.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ebene ebe kamiyalete motamo tote ebeno buwele ebo numiya, kuba uliyanate ebegodone iyalo nemaigate, ebete ketalo watiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ebene Ya꞉sute Taya opo atepate Saidono kawo duliyomolamo tote, ebete Teni Duliyomolono opodo ka꞉petote Ga꞉lili Paka꞉mo walo gito ka꞉nemaigiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ebe tetelo epate galo tamiome ega꞉walo tabo kiyawaoa꞉ dubu Ya꞉sutamo magaete ebe na꞉petoweomiya ebete ebeno koto ebe dubutamo kowatima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ebene Ya꞉sute ebe dubu epagodone kela꞉mo iyabaiamo magatate, ebeno koto dubuno galo magumamo ebo nowodolataoliya, ebene ebete ebeno kotamo kowe meamidate dubuno mena ebo ologimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ebe tetelo Ya꞉sute Unu Duliyomolamo melelo, ela agolamidalo Yu epono tabamo negiya, “Epa꞉ta!” me tabono magumu ma kunu itana, “Na꞉totokoliala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ebema꞉ ebe dubuno galote totokoliyaote ega꞉walo ebeno menate wadekobi dolowiya, ebete tabo wadenomamo ebo kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Epate ebe tanalo dumiya iba꞉te anoanolo kawonomamo negeliya, “Ya꞉sute tanalo bilibilinomo wadenomamo osiyodilolenako. Numa꞉la꞉, ebete galo tamiolamepi tabo olowioma꞉ wadekobi na꞉midiolena, ega꞉walo atumu tabo kiyawaoa꞉pi tabo kiyawaoma꞉ wadekobi na꞉ka꞉midiolena!” Ebene Ya꞉sute ibi kawonomamo analiya, “La꞉le epo epetapiatamo me tanalo akoawokalima꞉la꞉!” Nanitabola, iyaiya tete epetapilo Ya꞉sute epo ma kunu analenaki, wiyasiya iba꞉te ebeno tabamo tudila꞉oa꞉no ebeno osiyodilole tanalo gito nawokaliminakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ebe tetelo epo bilibilinomate Ya꞉sutamo pelamete walo kapiyama꞉ na꞉ka꞉pediya, ebene ibino baete dolopoligolamiya Ya꞉sute ebe waloma꞉tapi ebetamo ka꞉la꞉mite ibi nanaliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Na me epo na꞉nilakapoilamitamo, mabu iba꞉te nago netewa-kapiya egela dilukulinata꞉ ibino bae olopoligolami. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na ibi baea꞉no ibino duliyomolamo dalibolemo, diyala, gabo tetelo elawoa꞉noma꞉ da꞉ba꞉neda꞉oma꞉na꞉, mabu ibi epetapiate mulunomone pelamoliya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wiyasiya ebe waloma꞉tapiate ebetamo negeliya, “Me baea꞉ opola. Ale me epo bilibilinomatamo bae ikalamolema꞉ modoboa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ebene Ya꞉sute ibi nalateda꞉liya, “La꞉godolo kebalata baete ka꞉pola꞉nale?” Iba꞉te negeliya, “Sebeni.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ebene Ya꞉sute epo opamo kilukulima꞉ danaliya, ebe tetelo ebete ebe sebeni bae apuapu uwatete Godotamo kalakala tabo ebo giya, ebene ebete wakalamiolete ebe waloma꞉tapiatamo gito ikalamiya iba꞉te epatamo kikalamolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ega꞉walo iba꞉godolo namo egege kapiyakapiya na꞉ka꞉pola꞉niya, ebene Ya꞉sute ebe namoma꞉ Godotamo kalakala tabo kegete, ebe waloma꞉tapi nanaliya iba꞉te epatamo ka꞉kikalamolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ebe tetelo piyate ebe bae denaiya ibino bae kape tanalo ebo olopoligolamiya. Nanitabola, ebe bae 4,000 epate naiya, ebene da꞉luiliya ebe bae apuapuamo Ya꞉suko waloma꞉tapiate sebeni bagowo ebe owiyaoliya. Ebene Ya꞉sute ebe epo ibino iyaiya duliyomolamo daliboliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ebe tetenomolo ebete ebe waloma꞉tapiago peamo olote Da꞉lamanuta opamo gito tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ebene Pa꞉lisi tanebapi epetapiate Ya꞉sutamo pelamete ebe napapaminatiya. Ibi ubila ebe kuba gabamo kowabuga꞉tama꞉, ebema꞉ iba꞉te ebe naniya, “A꞉ma꞉godolo Godokono elawo ditana, ebe tanalo awokalima꞉ anoano tanalo idi atamo nosiyodila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ebene Ya꞉sute ebeno tepo magumulo ela kawonomamo agolamidalo negiya, “Mabu keleka꞉ me tete epate anoano tanalo dowadina? Na la꞉tamo nani tabo gemo, Godote ebeno elawo awokalima꞉ me tete epatamo anoano tanalo a꞉kikalaemene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ebene ebete ibi ubia꞉noma꞉ eda꞉lo peamo olote paka꞉ apuamo walo na꞉ka꞉na꞉iwiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ga꞉lili Paka꞉ a꞉iwale wagilimia꞉no Ya꞉suko waloma꞉tapiate bae uwate tanalo na꞉dodomatiya, ebema꞉ iba꞉godolo kapiya baenomote itani pe gulo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ebene Ya꞉sute ibi kawonomamo analiya, “La꞉ wadenomamo nolowiala꞉! Palowa baete a꞉ka꞉tuwa꞉ unamo demaiga, Pa꞉lisi tanebapi ega꞉walo Elodiko ibino amama tanalo eba kunula. Eiye, mako amama tanalote la꞉tamo akopemaigala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ebema꞉ iba꞉te ibino taneba magumulo tabo ma kunu geliya, “Ebete atamo me tabo nege mabu a baea꞉nola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Wiyasiya iba꞉te tabo degelitiya Ya꞉sute iyatawate iba꞉tamo negiya, “La꞉le baea꞉no pola꞉na tabo beda꞉ma꞉ kegelawitama? La꞉le naimano nanitabo tanalo wadenomamo kuma꞉wena꞉ ega꞉walo kiyatawawena꞉. Mabu keleka꞉ la꞉le la꞉imano tepo magumu da꞉kodakodailama꞉wenama? ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","La꞉ balida꞉gopilata wiyasiya la꞉ kuma꞉wena꞉, iyo, la꞉ galagopilata wiyasiya la꞉ kolowiawena꞉. Nale adimo idilo paibu bae 5,000 dubatamo dowakalamiolelamenimo, me tanaloma꞉ la꞉godolo woki ba꞉kitanale? Ebe tetelo la꞉ bae apuapuamo kebalata bagowo kowiyaola꞉wenima?” Iba꞉te ebetamo nowamiya, “12 bagowola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ega꞉walo egela idilo nale sebeni bae 4,000 epatamo da꞉kowakalamiolelaimo, ebe tetelo la꞉ bae apuapuamo kebalata bagowo kowiyaola꞉ima?” Iba꞉te ebetamo nowamiya, “Sebenila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ebema꞉ Ya꞉sute iba꞉tamo walo na꞉kegiya, “Mabu keleka꞉ la꞉le naimano tanalo nanitabolo kiyatawawena꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ebene iba꞉te Betasaida duliyomolamo da꞉nemaimiya, epo epetapiate balidi tamio dubu Ya꞉sutamo magaete, ebe ebo petoweomiya ebete ebe kologima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ebene Ya꞉sute balidi tamio dubu kotamo lawete duliyomolone kela꞉mo magatate, ebete ebeno balida꞉mo kowe alomomete ebeno koto watililo ebe nalatediya, “A꞉ma꞉ inamabu na꞉kulama꞉wita?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ebe dubute melete negiya, “Na epo dowapata꞉lamita nulamitamo, wiyasiya ibi kewamula.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ebene Ya꞉sute ebeno koto ebe dubuno balida꞉mo walo da꞉kowatiliya, ebete kawonomamo melete ebeno balidite wadekobi ebo olowiomiya, iyo, ebe tetelo ebete inamabu bilibilinomo wadenomamo ebo ulamoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ebene Ya꞉sute ebe naniya, “A꞉imano motamo tonomo na꞉toa, me duliyomolamo walo akopa꞉la꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ebene Ya꞉sute ebe waloma꞉tapiago Sisaliya-Pilipai opono iyaiya duliyomolamo eba tutalo, gabo tetelo ebete ebeno waloma꞉tapi nanalateda꞉liya, “Epate na poma꞉ kegelanake?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iba꞉te negeliya, “Epetapiate a꞉ma꞉ Yoneko obamo waduba꞉midaoledawama꞉ gelanaka, epetapiate a꞉ma꞉ Elayako Godokono woki awokalimidawama꞉ gelanaka, ega꞉walo epetapiate a꞉ma꞉ Godokono woki awokalimidawa idima꞉ gelanaka.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ebene Ya꞉sute ibi nalateda꞉liya, “Wiyasiya la꞉le na poma꞉ ka꞉midina꞉wenama?” Pitate ebetamo nowamiya, “A꞉ma꞉ Kelisotela, Godokono Alibodawalata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ebene Ya꞉sute ebe waloma꞉tapi kawiya analiya, “La꞉le naimano tanaloma꞉ epetapi akokiyawaolama꞉la꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ebene Ya꞉sute ebe waloma꞉tapi eba iyatulamitalo negiya, “Epono Naniwi epagodone kawokawo temeteme walone kuwatemene, Godokono ubila. Iyo, Godotamo kalimagono ikameopino watowatopi, ega꞉walo Godokono Totomu iyatulamepi, ega꞉walo kawokawo dubu epetapi iba꞉te ebe ubia꞉noma꞉ keda꞉oma꞉na꞉, ebene epate ebe kanakapuima꞉na꞉ wiyasiya netewa-kapiya egelalo ebete a꞉ene walo ka꞉kemaigamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ebete me tabo iba꞉tamo degiya, Pitate Ya꞉suko waloma꞉tapi epetapiagodone kela꞉mo magatate ebe tabono tanaloma꞉ ebe kawiya ebo naniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ebene Ya꞉sute olobigate, waloma꞉tapi epetapi ulamete Pitako kawonomamo analo negiya, “Pita, a꞉ma꞉ Saitanako keba kunula꞉ka꞉ eba kunula! Na natepana꞉ mabu a꞉imano woki Godotamo kiyata꞉wita꞉, a꞉ma꞉ epono wokilo okolinata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ebema꞉ Ya꞉sute epo bilibilinomo ebe waloma꞉tapiago ebetamo ka꞉la꞉mite ibi nanaliya, “Kebe lumagite na waloma꞉enema꞉ ubi diyatimene, dopamo ebete ebeno tanalo dodolomatilite ebeno kewa olotolowa agute na ebo nowaloma꞉enemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nanitabola, kebe lumagite ebeno igilo nagodone damoeda꞉mene ebeno igilote kalatidimene, wiyasiya kebe lumagite Godokono Wade Tabo kiyawaoma꞉ ebeno igilo na mabuma꞉ datutimene ebete nanitabo igilo kelaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ebema꞉ lumagite opono inamabu bilibilinomo uwatenomo eba uwatelo, ebeno igilo datutimene ebe lumagino wiya keleka꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ebete ebeno igilo walo ka꞉kelaema꞉ beda꞉ inamabu na꞉kikaemene? Gabo puliyala, kitana꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Numa꞉la꞉, me tete epate kubakubanomoma꞉ eda꞉ote, iba꞉godolo Godoko nanitabokobi midi tanalo puliyala. Ebema꞉ kebe lumagite natamo ega꞉walo naimano taboma꞉ dilipomene, na Epono Naniwite atumu ebetamo kilipomamo, iyo, nale naimano Nabiwino elawo alonomago ega꞉walo ebeno wade-talena nopopiago da꞉pemo, ebe tetelo ebe ka꞉pilipoimamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ebene Ya꞉sute iba꞉tamo walo na꞉kegiya, “Na la꞉tamo nani tabo gemo, me tetelo dilukuliona ibi epetapiate Godokono Kawo Elawodawano tetete elawago da꞉pemene, ebe kawo tanalo dopamo umite walone ebo ka꞉elaoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ebene sikisi egela dolopoligiya Ya꞉sute Pitako, Ya꞉imesiko, ega꞉walo Yoneko damela ununomo ida꞉mo magataliya, iba꞉te a꞉ka꞉tuwa꞉ ebolo ka꞉na꞉pola꞉nama. Ebe tetelo ibino dopo apulo Ya꞉sukono apete iyama꞉ eba editalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ebeno pupuliono inamabuate pukuilamete nanitabolo keyakeyanomoma꞉ eda꞉omitiya, me opo kawonomolo lumagi idite kaliku ma kunu ukulalelo keyakeyanomoma꞉ midiolema꞉ modoboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ebene waloma꞉tapino ololo apuamo Moseseko ega꞉walo Elayako iba꞉te pemaimite Ya꞉suago tabo ebo gelitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ebe tetelo Pitate Ya꞉sutamo negiya, “Iyatulamedawa, ale malo da꞉pola꞉nama꞉, kalakala kawonomola. Modobola a nupunupu netewa-kapiya ketemotemalema꞉, idi a꞉imanola, idi Mosesekonola, idi Elayakonola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nanitabola, waloma꞉tapiate kawonomamo toletoleutiya, ebema꞉ Pitate woki wadenomamo malagidiloa꞉no ebe tabo gito giya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ebene temate pete ibi dapanalopamidaliya, tabote tema magumune ma kunu piya, “Me naimano kapiya Gudunomola, na ebetamo nekalakalitamo. La꞉ ebeno tabo nolowiala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wiyasiya ebe tetelo iba꞉te opo samonomamo umiote Moseseko Elayako ibi walo kulamiya꞉, Ya꞉suko kapiyate iba꞉go ebolo utiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ebene iba꞉te unu damelane eba piwitiolo Ya꞉sute ibi napanaliya, “La꞉le kebe tanalo kuma꞉ema, ebe tanalo me tetelo epetapi akoanala꞉la꞉, wiyasiya na Epono Naniwite a꞉ene walo da꞉kemaigamo, la꞉ epo ebo kanalemamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ebema꞉ iba꞉te ebe tanalo tepo magumamo iyatiya, wiyasiya a꞉ene maiga tanalono magumuma꞉ ibino taneba magumulo gelitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ebene iba꞉te Ya꞉suko nalatediya, “Beda꞉ mabuma꞉ Godokono Totomu iyatulamepiate degelanaka, Elayate dopamo pete, ebeno walogabo apune Kelisote ka꞉pemene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ya꞉sute iba꞉tamo negiya, “Nanitabola, Elayako dopamo pete iyaiya tanalo bilibilinomo ka꞉pa꞉tuputupuilaemene. Wiyasiya Godokono Bukalo tabo idi ma kunu ba꞉kitana, Epono Naniwi temeteme bilibilinomo kuwatemene ega꞉walo epate ebe ubia꞉noma꞉ keda꞉oma꞉na꞉. Me tabono magumuma꞉ la꞉imano woki keba kunu ka꞉pola꞉nale? ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na la꞉tamo negemo, Elayako epatamo iyalo a꞉pi wiyasiya iba꞉te ibino ubilo kawokawo kuba ebetamo osiyodilolenakiya, Godote ebeno Bukalo dopamo degiya eba kunu.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ebene iba꞉te waloma꞉tapi epetapiatamo pemaimite, epo bilibilinomate iba꞉go eba pola꞉nalo ebo pulamiya. Ebe tetelo Godokono Totomu iyatulamepiate Ya꞉suko waloma꞉tapiago eba apaminateuitalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","wiyasiya epate Ya꞉suko dumiya iba꞉te kawonomamo la꞉wa꞉olo ebetamo puila꞉ote nilakapo tabo ebo negeliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ebene Ya꞉sute ebe waloma꞉tapi nalateda꞉liya, “Mabu keleka꞉ la꞉ me dubago dapaminateua꞉witama?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ebe tetelo epo bilibilinomo magumulo lumagi idite Ya꞉sukono tabo eba wiyalo negiya, “Iyatulamedawa, na naimano gudu a꞉ma꞉tamo emaga꞉kamo mabu ebe kuba uliyanate lawenako, ebema꞉ ebe tabo kiyawaoma꞉ modoboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kebe tetelo kuba uliyanate ebe walo da꞉kelawemene opamo ka꞉peneba꞉idilomene, ebene ebete lalo eba oliomolelo pakote ebeno tabo magumune pemaimiomete, ebeno apete kodakodanomoma꞉ ebo keda꞉mene. Nale a꞉ma꞉ waloma꞉tapi anala꞉kamo iba꞉te kuba uliyana kaliboma꞉, wiyasiya iba꞉godolo elawo puliyala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ebema꞉ Ya꞉sute iba꞉tamo negiya꞉, “Eiye, la꞉ nanitabokobi midia꞉ epolata! La꞉ natamo mibo ikanamenamata, ebema꞉ na ubia꞉nola tete geyageyalo la꞉go okolinama꞉! La꞉ koi natamo nemaga꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ebene iba꞉te ebe koi Ya꞉sutamo demagatiya, kuba uliyanate Ya꞉suko umite koi kubanomamo ebo lawiya. Koite opamo gate wageleolo eba igiligautalo ebeno tabone pakote pemaimiomitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ebe tetelo Ya꞉sute koino nabiwi nalatediya, “Ebe me tanalo kebako tetelo kowagilimile?” Ebete nowamiya, “Gudu da꞉peso tetelo wagilimi. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tete bilibilinomolo kuba uliyanate ebe elamo keba꞉idilo, ega꞉walo obamo keba꞉idilo, eba kunu amitina ebe kanakapuima꞉. Ebema꞉ a꞉imano elawo tanalo modobola꞉ka꞉ a kowalubima꞉? Elawote modobolo ditametana, a nilakapoiamelo ebe nowalubiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ya꞉sute ebetamo negiya, “Mabu keleka꞉ a꞉ma꞉le naimano elawo tanaloma꞉ danana꞉wa꞉? Me tanalo naimano tanaloa꞉, ebe a꞉imano tanalola! Modobola a꞉ma꞉ Godoko nanitabokobi na꞉mida꞉, ebene a꞉ma꞉godolo elawo bitanamene iyaiya tanalo bilibilinomo osiyodilolema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ebe tetenomolo koino nabiwite kawonomamo negiya, “Na nanitabokobi na꞉miditamo wiyasiya naimano nanitabokobi midi tanalo da꞉pesola. Kawokobi na꞉midinama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ebene epo epetapi bilibilinomate eba pelamenapelo, Ya꞉sute ibi ulamete kuba uliyana kawiya analo negiya, “Taboa꞉dawa ega꞉walo galo tamiome uliyana, nale a꞉ma꞉ nanamata, ebegodone nemaigawete na꞉toa! Walo ebetamo akopopegala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ebe tetelo kuba uliyanate kawiya gepatelo koi opamo ba꞉idilote, ebene koite kubanomamo wageleolo kuba uliyanate ebegodone da꞉nemaigiya, ebete a꞉emu ebo kapitani. Ebe mabuma꞉ epetapiate negeliya, “Ebe a꞉e,” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","wiyasiya Ya꞉sute ebe kotamo lawete dadipatiya ebe ebo maigiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ebene Ya꞉sute moto guamo da꞉nopegiya, epo epetapino pola꞉na꞉ tetelo ebe waloma꞉tapiate ebe nalatediya, “Mabu keleka꞉ ale kuba uliyana aliboma꞉ ka꞉modobaka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ebete ibino tabo eba wiyalo negiya, “Kebe dawate ebeno okoli magumulo Godago tabo degelanaka, ebe kapiyate mako kuba uliyana kalibomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ebene iba꞉te ebe duliyomolo atepate Ga꞉lili opodo eba petolamelo, Ya꞉suko ubia꞉nola ebete kebolo ka꞉lutiyale epate iyatawaoma꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","mabu ebete ebe waloma꞉tapi iyaiya tanalo epetapi iyatulamiti. Ebete ibi iyatulamelo negiya, “Godote Epono Naniwi kubakuba epono kotamo kiyatimene, ebene iba꞉te ebe kanakapuima꞉na꞉, wiyasiya ebete netewa-kapiya egelalo a꞉ene walo ka꞉kemaigamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wiyasiya Ya꞉sute degiya ebe waloma꞉tapiate ebe tabono magumu wadenomamo kemalagidilutiya꞉, ebema꞉ iba꞉te me tanaloma꞉ Ya꞉suko alateda꞉ma꞉ na꞉toletoleutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ebene iba꞉te Kapeniyama duliyomolamo da꞉pelamiya, Ya꞉sute moto guamo nodolote ebe waloma꞉tapi ebo nalateda꞉liya, “Gabo tetelo la꞉ beda꞉ mabuma꞉ kegelawitakama?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Iba꞉te tabo kowaimiya꞉ mabu iba꞉te ibino taneba magumulo potele kawoma꞉ eda꞉ma꞉ apaminateuitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ebe mabuma꞉ Ya꞉sute okolite ebeno 12 waloma꞉tapi ebetamo ka꞉la꞉mite iba꞉tamo negiya, “Kebe lumagite kawoma꞉ eda꞉ma꞉ ubi diyatimene, ebete ebe a꞉ka꞉tuwa꞉ walogabodawama꞉ midite epetapino wiya꞉ wokodawama꞉ neda꞉mene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ebene Ya꞉sute gudu da꞉peso lawete ibino tetenomamo adipite, ebe kotamo eba a꞉wiyamidalo iba꞉tamo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kebe lumagite naimano mailamo mako gudu da꞉peso kalakalago dowalubina ebete na walubinina, ega꞉walo kebe lumagite na dowalubinina ebete na kapiya kowalubinina꞉, ebete na Alibonedawa Godoko atumu na꞉kowalubina.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ebene Yonete Ya꞉sutamo negiya, “Iyatulamedawa, ale kapiya dubu uima꞉, ebete a꞉imano mailamo kubakuba uliyana daliboliti, wiyasiya ale ebe kawiya anima꞉ ebe tanalo katepama꞉ mabu ebe aimano taneba lumagia꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Wiyasiya Ya꞉sute iba꞉tamo negiya, “La꞉le ebe ako-odiyobala꞉. Kebe lumagite naimano mailamo anoano tanalo dosiyodilomene, ebe lumagite tote naimano tanaloma꞉ kuba tabo a꞉ka꞉nikiyawaomene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","mabu nanitabola, kebe lumagite ago gowelaoa꞉dawama꞉ deda꞉na, ebete a walubina. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nale la꞉tamo nani tabo gemo, la꞉le na Kelisokono epoma꞉ deda꞉wenama, ebe mabuma꞉ idawate obo la꞉tamo dikalametamene, ebete Godogodone delaemene ebe wade wiyate akalatidimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ebene Ya꞉sute walo na꞉kegiya, “Da꞉peso gudute na nanitabokobi eba midininalo, kebe lumagite ebe kuba gabamo dowabuga꞉tana, modobola epate ebe lawete ebeno kuwokoba꞉mo kawo nokolanomo ma꞉midaomete kewa꞉ kolomamo neba꞉idiloma꞉na꞉, ebete atu kuba tanalo gudu iditamo osiyodilokapoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ega꞉walo a꞉imano kotote a꞉ma꞉ kuba gabamo dowabuga꞉tatana, notowamida! Modobola a꞉ma꞉le kapiya kotago Godokono Igilo Duliyomolamo nopegama꞉, modoboa꞉ koto netewago Ela Opamo toma꞉. Nanitabola, ebe opolo elate uwomua꞉ tetelo nowaena, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ebolo a꞉elao epono ape denalenaka ebe ea꞉ga꞉te ka꞉elaona꞉, ega꞉walo elate ka꞉egana꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ega꞉walo a꞉imano agowate a꞉ma꞉ kuba gabamo dowabuga꞉tatana, notowamida! Modobola a꞉ma꞉le kapiya agowago Godokono Igilo Duliyomolamo nopegama꞉, modoboa꞉ agowa netewago Godote a꞉ma꞉ Ela Opamo neba꞉idiloma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ebolo a꞉elao epono ape denalenaka ebe ea꞉ga꞉te ka꞉elaona꞉, ega꞉walo elate ka꞉egana꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ega꞉walo a꞉imano balidite a꞉ma꞉ kuba gabamo dowabuga꞉tatana, nemagoba꞉! Modobola a꞉ma꞉le balidi kapiyago Godote Kawo Elawodawama꞉ deda꞉na ebe duliyomolamo nopegama꞉, modoboa꞉ balidi netewago Godote a꞉ma꞉ Ela Opamo neba꞉idiloma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ebolo a꞉elao epono ape denalenaka ebe ea꞉ga꞉te ka꞉elaona꞉, ega꞉walo elate ka꞉egana꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ebene Ya꞉sute tabo idi ma kunu kegiya, “Epate solu baeamo keba kunu kalomonake, Godote epo bilibilinomono ilukuli tanalamo ebeno ela eba kunu kapalomolaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Solu wadenomola, wiyasiya lumagi idino solu golate dalatidimene, a꞉ma꞉le walo solukobi midima꞉ a꞉ka꞉modoboaemene. Ebema꞉ Godokono solute la꞉imano taneba magumulo nitanamene, iyo, modobola idite idi nilakapoimilo eba kunu nilukuliniyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ebene Ya꞉sute Ga꞉lili opo atepate Yudiya opodo petote Yodane Kolomo apuamo gito nemaigiya. Ebe tetelo epo bilibilinomate ebetamo walo da꞉ka꞉pelamiya, ebene ebete ibi walo na꞉kiyatulamiya mabu ebeno osiyodilo tanalo ma kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ebene Pa꞉lisi tanebapi epetapiate pelamete, Ya꞉suko kuba gabamo ka꞉powabuga꞉tama꞉ ebe napalatediya, “Dubute ebeno kamiyale dalibutimene, Godokono Totomu Tabo bakadikanalemene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ya꞉sute wiyasiya iba꞉tamo negiya, “Mosesete la꞉ beda꞉ totomu tabo kanaletiyala?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iba꞉te negeliya, “Dubute ebeno kamiyale alibutima꞉ Mosesete gabo atamo ma kunu osiyodiliya, dubute ebeno ubi diyatimene, ebete kamiyale alibuti pepa osiyodilote ebetamo gito kikaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ebene Ya꞉sute iba꞉tamo negiya, “Mabu la꞉imano tepo magumu kodakoda-ibinomola, Mosesete kamiyale alibuti tabo Godokono Bukamo ebema꞉ iyatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wiyasiya numa꞉la꞉, dopamo Godote me opo dosiyodiliya, ebe tetelo ebete dubula kamiyalela osiyodiloliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Me mabuma꞉ dubute ebeno nabiwila menokola miyapate ebeno kamiyala꞉go kapiya bailo kokolioma꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ebene ibi netewapiate kapiyama꞉ eda꞉te walo iyama꞉ a꞉keda꞉ma꞉na꞉. Iyo, ibi kapiyanomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Numa꞉la꞉, Godote ibi netewapi kapiyakobi a꞉midiliya, ebema꞉ lumagite ibi iyakobi midilima꞉ modoboa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Walone moto gulo Ya꞉suko waloma꞉tapiate ebe tabono magumuma꞉ ebe danalatediya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ebete iba꞉tamo ma kunu giya, “Kebe lumagite ebeno kamiyale alibutite kamiyale idi daidimene, ebete Godokono ololo apulo ebe kamiyale pilolo kaidimene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ega꞉walo kebe kamiyalete ebeno dubu alibutite dubu idi delaemene, ebete ebe dubu atumu pilolo kelaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ebene epo epetapiate ibino gudi Ya꞉sutamo nemagataliya, ebete iba꞉tamo koto eba watiolelamelo Godoko kanama꞉ ebete ibi wadenomamo kowalubilinama꞉. Wiyasiya ebe waloma꞉tapiate ebe epo kawiya analelo ibi dodiyoboliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ya꞉sute ibino osiyodilo tanalo umite iba꞉tamo dowalo negiya, “Gudi natamo pelaema꞉ modobola. Ako-odiyobola꞉la꞉, mabu mako epate Godote Kawo Elawodawama꞉ deda꞉na ebe duliyomolamo ka꞉nopilaoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na la꞉tamo nani tabo gemo, kebe lumagite gudu da꞉pesomu aimano Kawo Elawodawa Godoko lawea꞉no, ebe lumagite ebeno Kalakala Duliyomolamo a꞉ka꞉nopegamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ebene Ya꞉sute guda꞉tamo koto eba watiolelamelo Godoko ebo aniya, ebete ibi wadenomamo kowalubilinama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ebene Ya꞉sute maigate gabodo eba tutalo, dubu idite ebetamo na꞉puligate pupamo nokolite ebe naniya, “Wade Iyatulamedawa, na beda꞉ tanalo osiyodilote uwomua꞉ igilo ebo na꞉kelaemo?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ya꞉sute ebetamo negiya, “A꞉ma꞉le na wadedawama꞉ beda꞉ma꞉ keka꞉na꞉miawa꞉? Wadedawa idi puliyala, Godoko kapiyate wadedawanomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A꞉ma꞉ Godokono Totomu Tabo iyatawala. Lumagi akoanakapuma꞉la꞉, lumagi idino kamiyale pilolo akolawa꞉la꞉, inamabu pilolo akouwata꞉la꞉, lumagi idino tanaloma꞉ a꞉da꞉ tabo akokiyawala꞉, lumagino inamabu a꞉da꞉ gabodo akouwata꞉la꞉, ega꞉walo a꞉imano menokola nabiwila ibino tabamo na꞉tuduwatanakiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wiyasiya ebete Ya꞉sutamo negiya, “Iyatulamedawa, na da꞉peso tetene wagilimite me totomu bilibilinomo kodakodalo uwatete kapiya idi kadikanaliya꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ebene Ya꞉sute ebe uminate nilakapoimilo ebe naniya, “Kapiya tanalote a꞉ma꞉godolo ka꞉modobona꞉. Modobola, a꞉ma꞉ toawete, epetapiate a꞉imano inamabu bilibilinomo maniamo uwateometate, a꞉ma꞉le ebe mani nigologolopiatamo gito na꞉nikalamola꞉. Ebe tetelo a꞉ma꞉ walo ka꞉pa꞉wete na nowaloma꞉eniye, ebene a꞉imano inamabu bilibilinomate Godokono Unu Duliyomololo ka꞉nepola꞉nama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ebete ebe taboma꞉ dopo mibonomoma꞉ eda꞉te tepo mibago gito tiya, mabu ebe inamabu bilibilinomagodawanomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ebema꞉ Ya꞉sute ebe waloma꞉tapi ulamolelo nanaliya, “Godote Kawo Elawodawama꞉ deda꞉na, inamabu bilibilinomagopiate ebe duliyomolamo nopila꞉oma꞉ kodakodanomola!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ebe tetelo ebe waloma꞉tapiate ebeno taboma꞉ nanoanoutiya, ebene Ya꞉sute iba꞉tamo walo na꞉kegiya, “Naimano ekakiala꞉, Godote Kawo Elawodawama꞉ deda꞉na, epate ebe duliyomolamo nopila꞉oma꞉ kodakodanomola! ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Numa꞉la꞉, ka꞉molo-goeote kaliku waluono moe iyado nilupigama꞉ kodakodama꞉ eda꞉na, gaboa꞉nola. Atumu inamabu bilibilinomagodawate Godokono Kawo Elawodawano duliyomolamo nopegama꞉ kodakodanomoma꞉ eda꞉na, gabote nanitabonomolo a꞉kitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ebene iba꞉te kawonomamo la꞉wa꞉ote, ibi a꞉ka꞉tuwa꞉ ibino taneba magumulo negelitiya, “Ya꞉sute dege ebe tabote nanitaboma꞉ deda꞉na, piyate modobola꞉ka꞉ Godote ibino igilo mula꞉lelaema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ya꞉sute ibi ulamenate negiya, “Epate a꞉ka꞉tuwa꞉ ibino igilo mula꞉lema꞉ modoboa꞉, wiyasiya Godoko kapiyate modobola mabu ebegodolo elawo bitana iyaiya tanalo bilibilinomo osiyodilolema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ebene Pitate Ya꞉sutamo negiya, “A꞉ma꞉ numa꞉, a inamabu bilibilinomo miyapate a꞉ma꞉ nowaloma꞉enata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ya꞉sute iba꞉tamo walo na꞉kegiya, “Na la꞉tamo nani tabo gemo, kebe lumagite ebeno moto, o ebeno nanila nanikubila ekakila, o ebeno menokobila nabila gudila ega꞉walo ebeno opo, ebete na mabuma꞉ ega꞉walo Godokono Wade Tabo kiyawaoma꞉ ebe tanalo da꞉miyapamene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ebete me tetelo motola, nanila, nanikubila, ekakila, menokobila, gudila, ega꞉walo opo kawonomo walo ka꞉kuwatemene. Ega꞉walo ebe atu tetelo epate temeteme tanalo ebetamo kikameoma꞉na꞉, wiyasiya walone nale ebetamo uwomua꞉ igilo kikaemamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Iyo, nanitabola, ka꞉lo dopopi bilibilinomo da꞉pola꞉na, iba꞉te walone walogabopima꞉ keda꞉oma꞉na꞉, ega꞉walo ka꞉lo walogabopi da꞉pola꞉na, iba꞉te walone dopopima꞉ keda꞉oma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ebene Ya꞉sute ebe waloma꞉tapiago Yelusalema kawo duliyomolamo eba tolamitalo, ebete ibi dopolamete tuti. Ebe tetelo ebe waloma꞉tapiate woki bilibilinomoma꞉ eda꞉utiya, ega꞉walo kebe epate ibino walogabo apune da꞉pelamitiya iba꞉te atumu na꞉ka꞉toletoleutiya. Ebene Ya꞉sute ebeno 12 waloma꞉tapi uwatete, ebetamo da꞉pemaima꞉na꞉ ebe temeteme tanaloma꞉ ibi eba iyatulamelo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“La꞉ nolowiala꞉. A Yelusalemamo tolamitama꞉. Ebolo Godote Epono Naniwi epatamo kikalaemene, ebene Godotamo kalimagono ikameopino watowatopi ega꞉walo Godokono Totomu iyatulamepi, iba꞉te ebe anakapuima꞉ gelate Yua꞉piatamo ebo kikalaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ebene ebe epate ebe kalakalatete, ebetamo kowe meolete, pa꞉ka꞉pa꞉ka꞉mo ebe a꞉na꞉ma꞉ga꞉midaote kanakapuima꞉na꞉, wiyasiya ebete netewa-kapiya egelalo a꞉ene walo ka꞉kemaigamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ebene Sebedikono gudi Ya꞉imesiko ega꞉walo Yoneko iba꞉te pete Ya꞉sutamo na꞉pegeliya, “Iyatulamedawa, a ubila ale a꞉ma꞉ beda꞉ tanaloma꞉ danatamene, nikaeamiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ya꞉sute ibi nanaliya, “La꞉ beda꞉ tanalo ubila꞉ka꞉ nale la꞉tamo ikalaema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Iba꞉te tabo eba wiyalo negeliya, “A꞉ma꞉le Kawo Elawodubuma꞉ deda꞉emene, a ubila a꞉ma꞉le degeaemene idawate a꞉imano tumudi apulo ega꞉walo idawate pele apulo a꞉imano kawo alonomo magumulo kilukulitama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wiyasiya Ya꞉sute iba꞉tamo negiya, “La꞉le na wade wokiamo kanana꞉wita꞉. La꞉ modobola꞉ka꞉ nale da꞉nimo ebe temeteme kalila꞉mo nioma꞉? La꞉ modobola꞉ka꞉ Godote na a꞉e tanalamo daduba꞉midanemene ebe tanalamo la꞉ waduba꞉midaolema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Iba꞉te negeliya, “A modobola.” Ya꞉sute iba꞉tamo negiya, “Me tanalo nanitabola, nale da꞉nimo walone tetelo la꞉ atumu ebe kalila꞉mo niawete temeteme bolowionakomata, ega꞉walo Godote na daduba꞉midanemene ebe a꞉e tanalamo la꞉ kaduba꞉midaolema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wiyasiya naimano tumudi apuamo ega꞉walo pele apuamo ilukuli tanaloma꞉ nale a꞉kegemo. Godote piyatamo dosiyodilolelamiya ibinomate ebolo ka꞉pola꞉nama꞉na꞉, iyo, me tanaloma꞉ ebete a꞉ka꞉tuwa꞉ kegemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ebene Ya꞉suko waloma꞉tapi teni epetapiate ebe tanalo olowite, Ya꞉imesiko ega꞉walo Yoneko iba꞉tamo na꞉dowautiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","wiyasiya Ya꞉sute ibi bilibilinomo ebetamo ka꞉la꞉mite ibi nanaliya, “La꞉ iyatawalata, Godoko nanitabokobi midia꞉pino kawokawo dubate ibi a꞉ka꞉tuwa꞉ ibi eba wadipalatelelo epo epetapi elawamo analenaka, iba꞉te ibino ubi tanalamo ka꞉tudila꞉onama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Wiyasiya la꞉ ebako epoma꞉ a꞉keda꞉oaema. Kebe lumagite la꞉imano kawodawama꞉ eda꞉ma꞉ ubi diyatimene, ebete la꞉imano wiya꞉ wokodawama꞉ neda꞉mene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ega꞉walo kebe lumagite dopodawama꞉ eda꞉ma꞉ ubi diyatimene, ebete la꞉ bilibilinomono idoko motono wokodawama꞉ neda꞉mene, iyo, ebe a꞉ka꞉tuwa꞉ ebe oponomamo iyatinomo niyatimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Numa꞉la꞉, Epono Naniwite da꞉piya, ebe ubia꞉nola me opo epate ebetamo wiya꞉ wokopima꞉ eda꞉oma꞉, wiyasiya ebete na꞉piya epatamo wiya꞉ wokodawama꞉ ka꞉peda꞉ma꞉, ega꞉walo ebeno igilo iyabaiamo iyatite ebeno a꞉e wiyate epo bilibilinomo epetapi Saitanakono idoko motone gito kowagailima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ebe tetelo Ya꞉sute ebe waloma꞉tapiago Yeliko kawo duliyomolamo pelamete, ebene iba꞉te epo bilibilinomo epetapiago kapimiya ebe duliyomolone pemaimite eba tolamelo, Timiyasikono gudu Batimiyasiko balidi tamio dubula, ebete gabo niyakabolo eba okolitalo epo epetapi manima꞉ ebo toweolamiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ebene ebete Nasalete duliyomolodawa Ya꞉sukono pe tanalo olowite kawonomamo negiya, “Ya꞉su, Da꞉ibidikono A꞉la꞉mu! A꞉ma꞉le na na꞉nilakapoinama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ebe tetelo epo epetapi bilibilinomate ebe kawiya analo nodiyobiya ebete taboa꞉no kokolitama꞉, wiyasiya ebete kawonomamo walo na꞉kegiya, “Da꞉ibidikono A꞉la꞉mu! A꞉ma꞉le na na꞉nilakapoinama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ebene Ya꞉sute ebamo utite negiya, “La꞉ ebe mamo neka꞉miala꞉.” Ebene iba꞉te ebe balidi tamio dubu eba ka꞉milo ebetamo negeliya, “Nekalakala, ebete a꞉ma꞉ peka꞉mitata! Nemaiga!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ebe tetelo ebete ebeno lubudino kaliku iyabaiamo ba꞉idilote, samonomamo maigate Ya꞉sutamo ebo piya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ebene Ya꞉sute ebe nalatediya, “A꞉ma꞉ beda꞉ ubi kiyata꞉wita nale a꞉ma꞉tamo kosiyodiloma꞉?” Balidi tamio dubute negiya, “Iyatulamedawa, na ubila inamabu wadenomamo kulamolema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ya꞉sute ebe naniya, “A꞉ma꞉ na꞉toa. A꞉imano nanitabokobi midi tanalote a꞉ma꞉ wadekobi a꞉mida꞉ta,” ebema꞉ nanitabola, ebe tetenomolo ebeno balidite wadekobi dolowiomiya, ebete ebe to gabodo Ya꞉suko ebo waloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ebene iba꞉te Yelusalema kawo duliyomolo niyakabamo eba pelamelo, Betapa꞉gi duliyomolo ega꞉walo Betani duliyomolo tatalido tolamete Olibi Kewakewa Unu Damelamo ebo nemaimiya. Ebe tetelo Ya꞉sute ebe waloma꞉tapi netewa dopamo eba nalibolelo ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ibi nanaliya, “La꞉ ebe niyakabo duliyomolamo toawete, ebe duliyomolamo da꞉nemaima꞉ema donoki-goeo da꞉peso ala꞉mo ma꞉midao ka꞉numa꞉digamamota, lumagite dopamo ebe unamo kokoliya꞉. Modobola la꞉le ale pamiawete nemagaiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Idawate la꞉tamo degemene, ‘La꞉ me tanalo beda꞉ma꞉ kosiyodilawitama?’ la꞉ wiyasiya ma kunu negeliyala꞉, ‘Kawodawate donoki-goeo ubila, ebete walo samonomamo kakapalibomene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ebene iba꞉te tote, gabolo donoki-goeo da꞉peso gigiyu niyakabolo ma꞉midao numite ale ebo nepamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ebema꞉ piyate ebolo da꞉pola꞉niya iba꞉te ibi nalateda꞉liya, “La꞉ ale beda꞉ mabuma꞉ kepamiawitama?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ebene Ya꞉sute ibi netewapiatamo dopamo kebe tabo kegiyale, iba꞉te ebe atu tabo ibi danaliya ebe epate ibi gito miyapiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ebene iba꞉te ebe donoki-goeo da꞉peso Ya꞉sutamo magaete, ibino watubino kaliku donoki-goeo unamo alomomete, Ya꞉sute ebe kaliku unamo ebo okoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ebe tetelo epo epetapi bilibilinomate ibino ga꞉ga꞉ga꞉ga꞉ kaliku pupukulamete gabamo apoago tolamiya, ega꞉walo epetapiate gabo tametamene puwala otolete gabamo atumu kapotameonatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ebene piyate da꞉dopiya ega꞉walo Ya꞉sukono walogabo apune da꞉pelamitiya, ibi bilibilinomate kawonomamo ma kunu gelitiya, “Godoko nadipata꞉la꞉! Godo, a꞉imano mailago da꞉pita, modobola a꞉ma꞉ ebe lumagi kawokobi na꞉midiye! ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Iyo, aimano ewono nabiwi Da꞉ibidikono a꞉la꞉mute Kawo Elawodubuma꞉ deda꞉na, modobola a꞉ma꞉le ebe kawokobi na꞉midiye! O epala꞉, la꞉ Godoko moiolo unamo nadipata꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ebe tetelo Ya꞉sute Yelusalema kawo duliyomolamo nopegate, Godoko Amamateno Iya Motamo nodolote inamabu bilibilinomo ulamola꞉go ebo petiya, ebene dadimoni ebete Betani duliyomolamo walo na꞉ka꞉toni ebeno 12 waloma꞉tapiago. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Egela idilo iba꞉te Betanine walo da꞉ka꞉pelamitiya, gabo tetelo Ya꞉suko bae kape tanalo eba piyatawalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ebete umei kewa paagono muluamo pumite, da꞉imi olema꞉ ebamo gito tiya. Wiyasiya ebete ebamo da꞉nemaigiya paanomoiya nulamiya, mabu ebe tete umei da꞉imi kewano nolo tetea꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ebema꞉ ebete ebe umei kewatamo negiya, “Uwomua꞉ tetelo epate a꞉ma꞉godone da꞉imi a꞉kenaonakoma꞉na꞉!” Ebe tabo ebe waloma꞉tapiate olowiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ebene iba꞉te Yelusalemamo nemaimite Godoko Amamateno Iya Motamo tolamete, ebe motolo Ya꞉sute inamabu olowamepi nulamete elawonomamo na꞉na꞉ma꞉lateliya, ega꞉walo ebete mani odowaolepino patapata bigo olowamepino ilukuli patapatago ebo noba꞉midaolelamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ega꞉walo Yelusalema duliyomolo epate ibino inamabu apune apune dowadaenakiya, iba꞉te ebe inamabuago Godokono Motono kala magumudo podolote apudo da꞉nemaimionakiya, Ya꞉sute ibi ebe mabuma꞉ odiyoboliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ebe tetelo ebete epo eba iyatulamelo negiya, “Nanitabola, Godokono Bukalo tabo ma kunu bitana, ‘Naimano Moto iyaiya opo bilibilinomono epate Godoko Amamate Motoma꞉ kegelama꞉na꞉, la꞉le wiyasiya pilo epono motoma꞉ a꞉midimata!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ebene Godotamo kalimagono ikameopino watowatopi ega꞉walo Godokono Totomu iyatulamepi, iba꞉te ebe tabo olowite Ya꞉suko anakapuima꞉ gabo waditiya, wiyasiya iba꞉te ebe na꞉tolemitiya mabu epo bilibilinomate ebeno iyatulame tanaloma꞉ anoanolo nekalakalautiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ebene dadimoni Ya꞉suko ega꞉walo ebe waloma꞉tapi ebe kawo duliyomolone walo na꞉ka꞉tolameniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Egela idi duiyanomolo iba꞉te kawo duliyomolamo walo eba ka꞉pelamitalo, umei kewa dolodolone wagilimite apa꞉mo pemaiga alawoma꞉ eda꞉ ebo pumiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ebene Ya꞉sute dopamo beda꞉ tabo kegile, Pitate ebe tanalo malagidilote Ya꞉sutamo negiya, “Iyatulamedawa, numa꞉! A꞉ma꞉le kawiya danawia ebe umei kewate alawoma꞉ edi!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ya꞉sute wiyasiya iba꞉tamo negiya, “La꞉ Godoko nanitabokobi na꞉mida꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na la꞉tamo nani tabo gemo, kebe lumagite nanitabokobi midilo me damelamo ma kunu degemene, ‘A꞉ma꞉ kewa꞉ kolomamo na꞉toatepa!’ ebene ebete tepo magumulo woki netewama꞉ eda꞉no, ebe tanalote pemaigama꞉ nanitabokobi da꞉midimene, ebete ebe tanalo nanitabolo kuimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ebema꞉ nale la꞉ nanalemata, la꞉ beda꞉ tanaloma꞉ Godoko da꞉toweoma꞉ema, la꞉ ebe tanalo iyalo laema꞉ gelalo nanitabokobi na꞉midiyala꞉, ebene la꞉ ebe tanalo nanitabolo kelaemamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ega꞉walo kebe tetelo la꞉le maimiawete Godotamo towetowe tabo degelaema, ebene lumagi iditamo dowa tanalote ditanamene, la꞉ ebe lumagino kuba egebolema꞉wete na꞉dodolomatilimiyala꞉, ebene la꞉imano Unu Duliyomolono Nabiwite la꞉imano kuba egebolelametate atumu ka꞉ka꞉dodolomatililaema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wiyasiya la꞉ epono kuba egebolelama꞉wete dodolomatililamea꞉no, la꞉imano Unu Duliyomolono Nabiwite la꞉imano kuba egebolelametate a꞉ka꞉dodolomatililametamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ebe tetelo Ya꞉suko ega꞉walo ebe waloma꞉tapi Yelusalema kawo duliyomolamo walo na꞉ka꞉pelamiya. Ebene Ya꞉sute Godoko Amamateno Iya Motolo eba nepata꞉lo, Godotamo kalimagono ikameopino watowatopi, Godokono Totomu iyatulamepi, ega꞉walo kawokawo dubu epetapi, iba꞉te ebetamo pelamete ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ebe ma kunu palatediya, “A꞉ma꞉ me iyaiya tanalo pokono elawamo kosiyodilola꞉wena? Ega꞉walo me elawo potele kikametia, a꞉ma꞉le me tanalo kosiyodilola꞉wenama꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wiyasiya Ya꞉sute iba꞉tamo negiya, “Nale kapiya tanaloma꞉ la꞉ kalateda꞉lemamota. La꞉le na wiya tabo wadenomamo dowaminama꞉ema, ebene nale me tanalo pokono elawamo kosiyodilolenamo, ebe tanalo nale la꞉ ebo kanalemamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Naimano alateda꞉ tabo ma kunu bitana la꞉tamo, Yonete epo obamo dowaduba꞉midaolenaki, ebe elawo ebetamo potele kikamile, Godotela꞉ka꞉ o lumagitela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ebema꞉ ibi a꞉ka꞉tuwa꞉ ibino taneba magumulo apaminateuilo negeliya, “Ale degelama꞉ Godote Yonetamo elawo ikami, ebete kegemene, ‘Mabu keleka꞉ la꞉le ebeno tabo nanitabokobi ka꞉mida꞉wea꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ega꞉walo a modoboa꞉ ebe ma kunu anama꞉, me opo lumagite Yonetamo elawo ikami.” Iba꞉te epono dowa tanaloma꞉ toletoleolo tabo ma kunu geliya, mabu ibi iyatawala epo bilibilinomate Yoneko Godokono nanitabo woki awokalimidawama꞉ gelana. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ebema꞉ iba꞉te ibino tepo magumuno woki waminaolelo Ya꞉sutamo negeliya, “Yonekono elawo mabu a iyatawa꞉.” Ebe tetelo Ya꞉sute iba꞉tamo negiya, “Ebema꞉ nale la꞉ atumu akanaletama nale me iyaiya tanalo pokono elawamo kosiyodilolenamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ebene Ya꞉sute oi tabo ida꞉mo ibi ma kunu iyatulamiya, “Dubute pali osiyodilote tupina da꞉imi kewa bilibilinomo ebo ami, ebe da꞉imino mailo ebe gala꞉ipi da꞉imila. Ebene amio tanalote dolopoligi, ebete kala ga꞉dimite, da꞉imi ii egedioleno nokola bobo obobote, pali atila꞉pino unu nupunupu ebo eti. Ebe tetelo ebe dubute ebeno pali atila꞉pi dubu epetapiatamo gito atepi, iba꞉te ebolo woko eba osiyodilonalo, ebe pali wadenomamo umilo ebeno da꞉imi kuwatolemenakoma꞉, ebene ebete mulu oponomamo gito ti. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Ebene da꞉imi tapio tete da꞉pi ebete pali atila꞉piatamo wiya꞉ wokodawa napalibi, ebete iba꞉godone da꞉imino mani magumune ebeno kawodawano apu ka꞉pelaema꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","wiyasiya iba꞉te ebe lawete gaubamo anagalimiote inamabua꞉no gito nalibiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ebene pali namutudawate wiya꞉ wokodawa idi walo dakapalibi, wiyasiya iba꞉te ebe watolo eba kanagalimiolo ebe ilipo ikamete atumu gito kalibiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ebene ebete wiya꞉ wokodawa idi walo dakapalibi iba꞉te ebe anakapumiya. Ebene wiya꞉ wokopi bilibilinomo epetapiate da꞉pelamiya, iba꞉te atumu epetapi anagilamolete gito aliboliya, wiyasiya iba꞉te epetapi anakapulamoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ebene namutudawagodolo kapiya idi dokolinami, ebe gudu ebete kawonomamo malagidilonami. Ebema꞉ walogabonomone ebete ebe gudu eba palibolo ebeno wokilo negi, ‘Nanitabola, iba꞉te naimano gudutamo ka꞉tudila꞉oma꞉na꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ebe pali atila꞉pi dubate wiyasiya ibino taneba magumulo negeliya, ‘Numa꞉la꞉, me gudute nabiwino inamabu namutudawama꞉ deda꞉mene, ebe gudute na꞉pe. Ebema꞉ modobola ale ebe anakapumite ebeno pali lawenomo kelaemalema꞉,’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ebene iba꞉te ebe lawete anakapumite palino kala magumune gito neba꞉idiliya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ebema꞉ Ya꞉sute olowiopiatamo negiya, “La꞉imano woki keba kunula꞉ka꞉, pali namutudawate beda꞉ tanalo na꞉kosiyodilomene? Nanitabola, ebete pete pali atila꞉pi panakapulamete ebeno pali epetapiatamo ka꞉pikalaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Iyo, la꞉ dopamo Godokono Bukalo me tabo nanitabolo eka꞉la꞉mioliamata, ‘Moto etepiate iyabaiamo diyatiya, ebe alote wiyasiya motono elawo mabuma꞉ eda꞉na. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Me tanalo Godote osiyodili, ebema꞉ aimano wokilo nanoanoutama꞉!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ebema꞉ Yu watowatopi dubate Ya꞉suko laema꞉ ubila mabu ibi iyatawala ebete me iyatulame oi ibino tanaloma꞉ kiyawaiya, wiyasiya iba꞉te epo tolelamelo ebe atepate gito tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ebene Yu watowatopiate Pa꞉lisi tanebapi epetapi ega꞉walo Kawo Elawodubu Elodikono tanebapi Ya꞉sutamo aliboliya, iba꞉te ebe kuba gabamo eba nowabuga꞉talo ebete kebako tabo gelo ebe ebo kelaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Iba꞉te ebetamo pelamete a꞉da꞉ elemasigi gabodo na꞉pegeliya, “Iyatulamedawa, a iyatawala a꞉ma꞉ nani tabo lumagilata. A꞉ma꞉ epetapino gito gela tanalamo ka꞉tuduwatawenakoa꞉, ega꞉walo a꞉ma꞉ epo unu nikapiamo kulama꞉wena꞉, ma kunu lumagi idi atepalo lumagi idi ebo a꞉kelawa꞉emene. Iyo, a꞉ma꞉ epo Godokono gabo wadenomamo iyatulamenata, ebema꞉ a nanaa꞉, Loma epono Kawo Elawodubunomo Sisatamo ta꞉kese mani ikameoma꞉ modobola꞉ka꞉ o kubala꞉ka꞉? A ebetamo ba꞉kikameoma꞉ o a꞉kikameoma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wiyasiya Ya꞉sute ibino mena netewa tanalo iyatawate iba꞉tamo negiya, “Mabu keleka꞉ la꞉le na masiginima꞉ dowagela꞉witama? La꞉ mani kapiya natamo nikanama꞉la꞉, na kuimamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ebene iba꞉te mani kapiya ebetamo dikamiya, ebete ibi nalateda꞉liya, “Me manilo da꞉pola꞉na, mailo ega꞉walo ololo pokonola꞉ka꞉?” Iba꞉te negeliya, “Kawo Elawodubunomo Sisakonola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ebene Ya꞉sute iba꞉tamo negiya, “Sisakono inamabu Sisatamo nikameala꞉, wiyasiya Godokono inamabu Godotamo nikameala꞉.” Ebema꞉ iba꞉te ebeno taboma꞉ kawonomamo anoanoutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","A꞉e magumune maimioa꞉noma꞉ degelana, ebe epo Sa꞉diyusi taneba epola. Ibi epetapiate Ya꞉sutamo pelamete tabo ma kunu pegeliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Iyatulamedawa, Godokono Bukamo Mosesete tabo ma kunu akuloliya, ‘Dubute a꞉ete kamiyale gudia꞉no datepamene, ebeno ekawite ebe amole lawete ebeno naniwino tanaloma꞉ gudi nosiyodilolemene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kapiya dubuno sebeni koiate ilukulinamiya. Ibi magumulo dopo gudute kamiyale lawete gudi ulamea꞉no a꞉iya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ebene ebeno ekawite atu kamiyale kelawete gudi ulamea꞉no gito ka꞉iya, ega꞉walo tetedawa idite atumu kowageliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ebene ebe sebeni atu alailama꞉te gudia꞉no eba kunu a꞉elaiya, wiyasiya kamiyalete walone gito a꞉iya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ebema꞉ iba꞉te a꞉e magumune igilamo demaimioma꞉na꞉, ebe Kawo Egelalo ebe kamiyalete pokono kamiyalema꞉ na꞉keda꞉mene, mabu ebe sebeni dubate aida꞉tepaiya?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ebene Ya꞉sute iba꞉tamo negiya, “Mabu la꞉ Godokono Buka tabo ega꞉walo ebeno elawo iyatawa꞉, ebe mabuma꞉ la꞉imano wokilo epono a꞉ela tanaloma꞉ kubanu gelanakomata. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Numa꞉la꞉, epate a꞉e magumune igilamo demaimioma꞉na꞉, ebe tetelo iba꞉te kamiyale walo a꞉ka꞉piaidiolema꞉na꞉ ega꞉walo dubu a꞉ka꞉puwatolema꞉na꞉, wiyasiya iba꞉te Godokono Unu Duliyomolono nopopimu bilukulionama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ebe mabuma꞉ Godokono Bukate a niyatuamena a꞉elaopiate a꞉e magumune maimioma꞉. Iyo, Mosesete diyatiya ebe tabo la꞉ nanitabolo eka꞉la꞉mioliamata, ma kunu elate kewalo dowaiti wiyasiya kewate kolotolitiya꞉, ebe tetelo Godote Mosesetamo negiya, ‘Nanitabola, na Godotela. A꞉ibalayamako, Aisa꞉keko, ega꞉walo Ya꞉ikoboko iba꞉te uwomua꞉ tetelo poko kamamatene, na ebetela.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ebema꞉ la꞉ Sa꞉diyusi tanebapi la꞉imano wokilo na꞉kemalagidilawenama ebe ewonino igilate olopoligoiya? Ao, kolopoligiya꞉, mabu a꞉elaopiate Godoko kamamatena꞉ wiyasiya piyate igilolo dilukulina ebe eponomate ebe amamatena. Me mabuma꞉ la꞉ Sa꞉diyusi tanebapiate epono a꞉ela tanaloma꞉ kubanu gelanakomata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ebene Godokono Totomu iyatulamedawa idite pete, iba꞉te degelitiya ebe tabo ebo polowiya. Ya꞉sute Sa꞉diyusi tanebapiatamo tabo wadenomamo da꞉kiyawaiya, ebe tanalo umite ebete Ya꞉suko nalatediya, “Kebe totomu tabote kawonomoma꞉ keda꞉nale?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ya꞉sute negiya, “Me kawo totomunomola. ‘Isalaela epala꞉, la꞉ nolowiala꞉! Godoko aimano Kawodawala, ebe kapiyanomola, idi puliyala. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A꞉ma꞉ a꞉imano Kawodawa Godoko nilakapolo nemalagidilona, a꞉imano tepo magumunomamo ega꞉walo a꞉imano uliyanano elawamo, a꞉imano woki kawonomamo ega꞉walo a꞉imano elawo kawonomamo.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ega꞉walo me kawo totomunomo idila. ‘A꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉ma꞉ demalagidilawena, modobola a꞉ma꞉le eba kunu a꞉ma꞉ niyakabolo dokolina ebe lumagi nilakapolo nemalagidilona.’ Totomu tabo idite me kawokawo totomu netewa a꞉kodoilimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Godokono Totomu iyatulamedawate Ya꞉sutamo negiya, “Iyatulamedawa, nanitabola, a꞉ma꞉ wadenomamo geata. Aimano Kawodawa Godoko kapiyanomola, idawa puliyala, kokolina꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Lumagite ebeno tepo magumunomamo ega꞉walo ebeno uliyanano elawamo, ebeno woki kawonomamo ega꞉walo ebeno elawo kawonomamo ebete Godoko nilakapolo nemalagidilonamene. Ega꞉walo ebe a꞉ka꞉tuwa꞉ ebe demalagidilona, ebete eba kunu ebe niyakabolo dilukulina ebe epo nilakapolo nemalagidilolenamene. Nanitabola, me netewa totomuate kawokawonomoma꞉ eda꞉ona, wiyasiya Godotamo ikameo tanalate kawokawoma꞉ keda꞉ona꞉, iyo, epate elamo madolame sipi-goeogoeo ega꞉walo nilakapo inamabu epetapi Godotamo dikameonaka, ebete negena ebe tanalo bilibilinomate kawokawoma꞉ keda꞉ona꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ebete tabo wadenomamo degiya, Ya꞉sute olowite ebetamo negiya, “Godote Kawo Elawodawama꞉ deda꞉na, ebe duliyomolamo a꞉ma꞉ opegama꞉ tatalila.” Nanitabola, ebe tetene wagilimite epate Ya꞉suko tanalo idima꞉ alateda꞉ma꞉ na꞉toletoleutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ebene Ya꞉sute Godoko Amamateno Iya Motolo epo eba iyatulamitalo negiya, “Godokono Totomu iyatulamepiate negelana Godokono Alibodawa Kelisoko ebe Da꞉ibidikono a꞉la꞉mula, ebeno walone gudi magumune kawokalamene. Wiyasiya me tanalono magumu keba kunula꞉ka꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Numa꞉la꞉, Da꞉ibidite Godokono Uliyanano elawamo tabo ma kunu kiyawaiya, ‘Kawodawa Godote naimano Kawodawa Kelisotamo nege, ‘A꞉ma꞉ naimano tumudi apuamo na꞉pokoliya, ebene a꞉ma꞉go gowelaopi a꞉ma꞉le naimano elawamo ibi ka꞉mikitaolema꞉ta.’ ’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ebene Ya꞉sute tabo moga꞉melo walo na꞉kegiya, “La꞉ me tabo eba malagidilolo na nanana꞉la꞉, Da꞉ibidite ebeno a꞉la꞉mu Kelisoko ebeno Kawodawama꞉ ka꞉milo ebete Godokono tumudi apuamo okolima꞉ giya, ebema꞉ ebe tanalote keba kunu na꞉ka꞉pemaigamene?” Nanitabola, ebe tetelo epo bilibilinomate Ya꞉sukono tabo kalakalago olowitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ebene Ya꞉sute epo eba iyatulamitalo negiya, “La꞉le Godokono Totomu iyatulamepi wadenomamo nulama꞉la꞉. Ibi ubila ga꞉ga꞉ga꞉ga꞉ kaliku pupuliote olowame bailo eba wapata꞉lamelo, epate ibi ebo kowalogolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Iyo, ibi ubila a Yu epono balidi ibilamole moto gulo kawokawo dubuno ilukuli bailo kilukulima꞉, ega꞉walo ibi ubila soliyomu osiyodilo tetelo kawokawo ilukuli bailo ka꞉pola꞉nama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ega꞉walo iba꞉te amoleamoleno inamabu a꞉da꞉ elemasigi tanalodo eba uwatelo, ebo opoliyaolelamenaka, ebene iba꞉te ebe tanalo kuba꞉noma꞉ gelalo tolamete Godotamo balidi eba nibilamolelo ga꞉ga꞉ga꞉ga꞉ towetowe tabo ebo negelanaka, mabu ibi ubila epate ibino tanalo umilo ibi wadewadepima꞉ kegelama꞉. Ebe mabuma꞉, nanitabola, iba꞉te kuba wiya kawonomo kelaema꞉na꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ebene Godoko Amamateno Iya Motolo epate mani eba alomutalo, Ya꞉sute ebe mani alomo bai niyakabolo okolite epono mani alomo tanalo ulamiti. Inamabu dogodogopi epetapiate mani kawokawonomo alomutiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ebene inamabua꞉ amole kamiyale idite pete netewa mani egege, kapiya toea keba kunula꞉ka꞉ eba kunula, ebete ebo palomiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ya꞉sute ebe waloma꞉tapi ebetamo ka꞉la꞉mite negiya, “Na la꞉tamo nani tabo gemo, epate mani dapaloma, me inamabua꞉ amole kamiyalete ibi bilibilinomo odoili, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","mabu inamabu dogodogopiate ibino inamabu epetapi da꞉luililamenako ebe inamabu paloma, wiyasiya me amole kamiyale inamabua꞉nola. Ebete ebeno uwomu mani alomonomo apalomo, ebeno bae uwateono manila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ebene Ya꞉sute Godoko Amamateno Iya Motone eba piwisigitalo, ebeno waloma꞉tapi magumulo idawate negiya, “Iyatulamedawa, a꞉ma꞉ nulama꞉. Me nokola moto iyaiyanomola ega꞉walo wadewadenonomola!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ya꞉sute wiyasiya ebetamo negiya, “A꞉ma꞉ me kawokawo moto ba꞉kulama꞉wita? Me iyaiya motono tanaloma꞉ nokola idite nokola idi unulo a꞉ka꞉pola꞉nama꞉na꞉, mabu gowelaopiate nokola bilibilinomo mapitaolete opamo iyalekenomo ka꞉piyalekema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ebene Ya꞉sute Olibi Kewakewa Unu Damelalo eba okolitalo, Godoko Amamateno Iya Moto apuamo umilo okoliti. Ebe tetelo Pitako, Ya꞉imesiko, Yoneko, ega꞉walo A꞉nduluko, ibinomate ebetamo tolamete na꞉negeliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“A꞉ma꞉le a nanaa꞉, Godokono Moto kubaimi tanalote kebe tetelo na꞉ka꞉pemaigamene? A beda꞉ anoano tanalote na꞉kiyatuaemene, tete ebe na꞉pe me tanalo bilibilinomate ka꞉pemaimioma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ebene Ya꞉sute iba꞉tamo negiya, “La꞉ nanisiwale. Lumagi idite la꞉ demasigilitamene, la꞉ ebeno tabo ako-olowiala꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","mabu dubu bilibilinomo epetapiate naimano mailamo pelamete ka꞉pegelama꞉na꞉, ‘Na ebe Kelisotela!’ ebene iba꞉te epo bilibilinomo ma kunu eba pemasigiolelo iya gabamo ebo kemagatalema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ega꞉walo la꞉le iyaiya opo epono gowelao tanalo ega꞉walo ibino gowelaoma꞉ nopo iyati tanalo dolowiaema, la꞉ ebe mabuma꞉ akotoletoleala꞉. Me tanalate nanitabolo ka꞉pemaimioma꞉na꞉, wiyasiya ebe tete ebe uwomu tetea꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nanitabola, opo epetapino epate opo epetapino epago ka꞉gowelaoma꞉na꞉, iyo, opo idite opo iditamo gowela tanalo kosiyodilomene, ebene mumulate iyaiya opo bilibilinomamo ka꞉pelaema꞉na꞉, ega꞉walo iyaiya duliyomolo epetapilo epate baea꞉no kilukulioma꞉na꞉. Numa꞉la꞉, kamiyalete gudu laema꞉ temeteme dowagilimi, me tanalo eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ebema꞉ la꞉ la꞉imano tanalo wadenomamo nulamenala꞉, mabu kubakubapiate la꞉ elawamo uwatetate tabo anagiyamida baiamo kemagatalema꞉ta, ega꞉walo iba꞉te Yu epono balidi ibilamole moto gulo la꞉ gaubamo kalukolema꞉ta. Iba꞉te na mabuma꞉ la꞉imano tanalo danagilamelelametamene, ebe tetelo la꞉ iyaiya kawokawo elawodubuno ololo apulo utitatawete naimano Wade Tabo iba꞉tamo ebo ka꞉kiyawaomamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Iyo, uwomu tete pea꞉no, Godoko ubila la꞉le dopamo ebeno Wade Tabo iyaiya opo bilibilinomolo ka꞉na꞉kiyawaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ebema꞉ epate tabo anagiyamida baiamo la꞉ demagataletamene, ebe tetete pemaiga꞉no la꞉imano gela tanaloma꞉ woki bilibilima꞉ akoeda꞉oala꞉, ma kunu, ‘Na beda꞉ tabo na꞉kegemo?’ Tete da꞉pemene Godote kebe iyaiya tabono tanalamo la꞉ dowalubilitamene, modobola la꞉le ebe tabo kapiya na꞉kiyawaiyala꞉, mabu nanitabola, la꞉ a꞉ka꞉tuwa꞉ a꞉ka꞉kiyawaoaema, Godokono Uliyanate la꞉do ka꞉kiyawaomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ebe tetelo naniwite ekawi a꞉eamo kalibomene, ega꞉walo atu gabodo ekawite naniwi kanakapuimene, iyo, dubute ebeno gudu atumu kakamitimene, ega꞉walo guda꞉te dowaote ibino menokobila nabila a꞉eamo kalibolema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ebene na mabuma꞉ epo bilibilinomate la꞉tamo ka꞉dowaoma꞉na꞉, wiyasiya kebe lumagite kodakodalo utite uwomuamo da꞉nemaigamene, Godote ebeno igilo ka꞉mula꞉emene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Na Makate me buka ka꞉la꞉mioledawatamo negemo, a꞉ma꞉ me tabo Ya꞉sute degiya wadenomamo niyatawa. Ya꞉sute tabo moga꞉melo walo na꞉kegiya, “Godokono Moto kubaimidawate ebe talena bailo utitalo la꞉le ebe duma꞉ema, ebe tetelo modobola Yudiya opo epate unuunu damelamo nalautioma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iyo, moto tanatimilo dokolitamene, ebe lumagite moto guamo walo a꞉ka꞉nopegamene ebeno inamabu uwatema꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ega꞉walo tumulo woko dosiyodilutamene, ebe lumagite walo motamo a꞉ka꞉toamene ebeno lubudino kaliku laema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Numa꞉la꞉, lamitulamitu ega꞉walo nono dikalamena ebe kamiyala꞉tamo ebe egelate kubanomoma꞉ keda꞉mene! ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ebema꞉ modobola la꞉ Godoko na꞉toweomiyala꞉ me tanalate gibagiba tetelo akopemaimiala꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","mabu ebe tetelo kawokawo temetemenomate ka꞉pemaimioma꞉na꞉. Numa꞉la꞉, Godote me opo dosiyodiliya ebe tetene wagilimite ka꞉lo me teta꞉mo pemaiga, ebakobako temetema꞉te dopamo ka꞉pemaimiya꞉, ega꞉walo walone tetelo ebakobako temetema꞉te walo a꞉ka꞉pelaema꞉na꞉, kapiya tetenomamo ka꞉pemaimioma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Me tanalo nanitabola, Kawodawa Godote ebe tete gopowaimia꞉no lumagi idite me opolo igilolo a꞉kokolinamene, wiyasiya ebete kebe epo ka꞉la꞉miolete duwatiya ebe epo nilakapoilamelo tete ka꞉gopowaimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ebe tetelo lumagi idite la꞉tamo ma kunu degemene, ‘Numa꞉la꞉, Godokono Alibodawa Kelisote malo bokolita!’ o, ‘Numa꞉la꞉, ebete ebolo bokolita!’ la꞉ nanitabokobi akomida꞉la꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","mabu elemasigi Kelisoma꞉ eda꞉opi ega꞉walo naimano mailamo a꞉da꞉ tabo kiyawaopi, iba꞉te pemaimiote iyaiya anoano tanalo kosiyodilolema꞉na꞉. Iyo, ibi ubila ebe osiyodilole tanalamo Godote deka꞉la꞉mioliya ebe epo iya gabamo kemagatalema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ebema꞉ la꞉ wadenomamo nolowiala꞉, me tanalo bilibilinomate pemaimioa꞉no nale la꞉ dopamo analemata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ebe kawo temeteme tetete dolopoligomene, ebe tetelo egelate kidokomene ega꞉walo saganate a꞉ka꞉pukuilaemene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","iyo, mawela꞉te tobolo unune opamo ka꞉pa꞉gudima꞉na꞉, ega꞉walo tobolo ununo elawoelawo inamabuate kalela꞉oma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ebene ebe tetelo Epono Naniwite tobolo unune eba piwisigalo, iba꞉te ebe ebo kuima꞉na꞉, ebete ebeno elawago ega꞉walo alo kawonomago ka꞉pemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ebene ebete Unu Duliyomolono nopopi iyaiya opo bilibilinomamo kapalibolemene, Godote deka꞉la꞉mioliya ebe epo me opo apune apune ka꞉puwatema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“La꞉ umei kewano tanalone me tanalo idi wadenomamo niyatawala꞉. Katomono wuiate pemaimite olioli paa da꞉mogoiamidalema꞉na꞉, ebe tanalote la꞉ kiyatulamema꞉ta ulamano tete ebe netatali, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ebema꞉ me temeteme tanalate pemaimilo dulama꞉ema, la꞉ kiyatawaomamota Epono Naniwino pe tete tatalila, ebe gigiyudo opegama꞉ pe. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na la꞉tamo nani tabo gemo, me tanalo bilibilinomate dopamo ka꞉pemaimioma꞉na꞉, walone me tete epate ebo ka꞉elaoma꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","iyo, me opo ega꞉walo tobolo unu iba꞉te kolopoligoma꞉na꞉, wiyasiya naimano tabote a꞉kolopoligomene, uwomua꞉ tetelo bitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Numa꞉la꞉, epate ebe Kawo Egelano tete iyatawa꞉, Unu Duliyomolono nopopi ega꞉walo Godokono Gudu iba꞉te iyatawa꞉, Nabiwi Godo kapiyate iyatawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ebema꞉ la꞉ olowiolo nilukuliniyala꞉, mabu ebe tetete da꞉pemene la꞉ iyatawa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Me tanalote ma kunu kitanamene, kawo dubu idite mulu opolo ka꞉nokoliatepama꞉ ebeno moto wiya꞉ wokopiatamo katepamene iba꞉te wadenomamo kuiminama꞉. Ebene ebete iba꞉tamo woko iyaiya ikalamolete gigiyu umidawatamo kegemene, ‘A꞉ma꞉ naimano pe teta꞉mo olowiolo nokoliniye.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ebema꞉ la꞉ olowiolo nilukuliniyala꞉, mabu la꞉ iyatawa꞉ moto namutudawano pe tete, diyala, adimo tetelola꞉ka꞉ o idoko tetelola꞉ka꞉, walo apuamola꞉ka꞉ o duiya tetelola꞉ka꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Iyo, ebete samonomamo da꞉pemene la꞉ laonalo da꞉ba꞉pulametamene, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ebema꞉ nale me tabo la꞉ kapiyatamo kegea꞉, epo bilibilinomatamo gemo, la꞉ olowiolo nilukuliniyala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aduga꞉la Soliyomu ega꞉walo Unamo Maiga꞉ Palowa Bae Soliyomu ibino tanalo wagilima꞉ netewa egelate eba na꞉pola꞉nalo, ebe tetelo Godotamo kalimagono ikameopino watowatopi ega꞉walo Godokono Totomu iyatulamepi, iba꞉te Ya꞉suko anakapuima꞉ tabo ebo iyatiya, ebene iba꞉te ebe diya gabodo laema꞉ gabo waditiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Iba꞉te negeliya, “A soliyomu tetelo ebe a꞉kelaema꞉, mabu epate atamo dowaote ago da꞉ba꞉gowelama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ebene Ya꞉sute Betani duliyomololo dubu idi Saimonokono motolo bae niti, ebe dubu dopamo kukulakukulagonola. Ebe tetelo kamiyale kapiyate pete, wade nibo ii nokola kalila꞉mo tabokaimi adaete, ebete pitukamidate Ya꞉sukono watamo ebo padipanamiya, ebe ii inamabuno mailo ebe nadala, ebeno wiya kawonomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Epo epetapi ebolo da꞉pola꞉niya, iba꞉te dowaote ibi a꞉ka꞉tuwa꞉ ibino taneba magumulo tabo eba kiyawaolo negeliya, “Mabu keleka꞉ ebete me wade nibo ii dologala inamabuma꞉ da꞉midi? ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","A me ii manima꞉ na꞉na꞉miditaleka꞉ kapiya ulamano woko wiya mani buwatena꞉, ebene ebe mani nigologolopiatamo gito bikalamolena꞉.” Ebema꞉ iba꞉te ebe kamiyale kawiya ebo aniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wiyasiya Ya꞉sute iba꞉tamo negiya, “La꞉ ebe natepala꞉! Ebe kawiya beda꞉ma꞉ kanawitama? Ebete natamo wade tanalonomo osiyodilo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","La꞉ numa꞉la꞉, nigologolopiate tete geyageyanomolo la꞉go bilukulionama꞉na꞉, la꞉imano ubi tetelo iba꞉tamo nilakapo inamabu ebo nikalamenakiyala꞉, wiyasiya na uwomua꞉ tetelo la꞉go a꞉kokolinamo, tete tatalila nale la꞉ ka꞉miyapamamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ebema꞉ nanitabola, me kamiyalete natamo wade tanalo osiyodilo, kuba idi kitana꞉. Nale a꞉ea꞉no tetelo ebete naimano ape bobamo iyatima꞉ gabo dopamo osiyodilo, iyo, ebe tanalo eba malagidilolo ebete naimano apa꞉mo wade nibo ii ebema꞉ adipana. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na la꞉tamo nani tabo gemo, epate iyaiya opo bilibilinomamo Godokono Wade Tabo datanakoma꞉na꞉, iba꞉te me kamiyalete dosiyodilo ebe tanalo malagidilolo ba꞉nikiyawaonakoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ebene Ya꞉sukono 12 waloma꞉tapino taneba magumulo Keliyota duliyomolodawa Yudasite Godotamo kalimagono ikameopino watowatopiatamo tote, nopo ebo niyatiya Ya꞉suko ibino kotamo kiyatima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ebe tetelo iba꞉te ebe tanalo olowite kalakalaolo tabo ebo iyatiya ebetamo mani kikaema꞉, ebema꞉ Yudasite iba꞉godone tote gabo ebo nowadiya Ya꞉suko ibino kotamo kiyatima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yu epono osiyodilo tanalo ma kunula, iba꞉te ulama bilibilinomolo Unamo Maiga꞉ Palowa Bae Soliyomu nao dowagiliminakiya, ebe dopo egelalo Aduga꞉la Soliyomuma꞉ iba꞉te sipi-goeogoeo egege alukolenakiya. Ebe tanalo eba malagidilolo Ya꞉suko waloma꞉tapiate ebetamo negeliya, “A tolamete Aduga꞉la Soliyomuno nao inamabu kebolo na꞉ka꞉nosiyodilolema꞉, ale a꞉ma꞉go kapimiya kenaoma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ebene ebete ebe waloma꞉tapi netewa eba alibolelo iba꞉tamo negiya, “La꞉ kawo duliyomolamo na꞉toala꞉, ebene obo daguwaita ebe dubute la꞉go dapalugomene, la꞉ ebe ebo nowaloma꞉tiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ebete kebe motamo ka꞉nodolomene, la꞉ ebe moto namutudawatamo ma kunu na꞉negeliyala꞉, ‘Iyatulamedawate ge, moto keleka꞉ nale na waloma꞉tapiago Aduga꞉la Soliyomu bae kenaoma꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ebe tetelo ebete moto guamo la꞉ kemagatalema꞉ta, unu motolo tete kawo bitana, iyalo osiyodilaka. La꞉ ebolo aimano nao inamabu na꞉nosiyodiloliyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ebene Ya꞉suko waloma꞉tapi netewate kawo duliyomolamo nemaimite, Ya꞉sute kebe tanaloma꞉ kanaliyale, iba꞉te ebe tanalo nulamete Aduga꞉la Soliyomu inamabu ebo nosiyodiloliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ebema꞉ didokoni Ya꞉sute ebeno 12 waloma꞉tapiago ebe motamo na꞉pelameniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Iba꞉te ilukulinate bae eba naonalo Ya꞉sute negeni, “Na la꞉tamo nani tabo gemo, la꞉imano taneba magumulo idawate na anakapunamepi kowalubilimene na lawenema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ebe tetelo iba꞉te tepo mibomiboma꞉ eba eda꞉onalo, Ya꞉sutamo idawate genaki, idawate genaki, “Nalela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ya꞉sute iba꞉tamo negeni, “La꞉ 12 waloma꞉tapino taneba magumulo bae kalila꞉mo nago koto daduba꞉midamene, ebe ebe lumagila. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Iyo, ebe nanitabola, Epono Naniwite a꞉eamo ebe na꞉to, Godokono Bukalo tabo ma kunu bitana, wiyasiya kebe lumagite ebe anakapumipiatamo dikalaemene, ebe lumagite kuba wiya kawonomo kelaemene. Me ebe mabuma꞉ ebe dubu ebeno menokote ebe alaimia꞉notaleka꞉ ba꞉modobona꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ebene iba꞉te bae eba naonalo, Ya꞉sute bae lawenate Godotamo kalakala tabo genate ebo wakamioni, ebema꞉ ebete iba꞉tamo eba ikalamolenalo negeni, “La꞉ nuwata꞉la꞉, me naimano apela.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ebene ebete kalili kelawenate Godotamo kalakala tabo genate iba꞉tamo eba ikalamolenalo, ibi bilibilinomate ebo nioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ya꞉sute iba꞉tamo negeni, “Godote epago milolo kilukulinama꞉ nopo diyatiya, naimano kalimate ebe nopo kodakodaimina, iyo, me kalimate epo epetapi bilibilinomo walubilima꞉ keka꞉ka꞉liyamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na la꞉tamo nani tabo gemo, na me tetelo me da꞉imi obo walo a꞉ka꞉nimo, wiyasiya Godote Kawo Elawodawama꞉ deda꞉na, ebe duliyomololo na oli da꞉imi obo walone tetelo ebo ka꞉na꞉nimamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ebene iba꞉te Godoko amamateno oale alapionate, Olibi Kewakewa Unu Damelamo ka꞉tolamenama꞉ motone gito niwitioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ebe tetelo Ya꞉sute iba꞉tamo negeni, “La꞉ bilibilinomate na katepanemamota mabu Godokono Bukalo tabo ma kunu bitana, ‘Godote sipi-goeogoeo ulamedawa danakapuimene, ebe tetelo sipi-goeogoeate iyaiya kalautioma꞉na꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wiyasiya Godote na a꞉ene walo dakadipanatenemene, na Ga꞉lili opamo dopamo ka꞉tomamo. La꞉le na ebolo ka꞉punaemamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ebene Pitate Ya꞉sutamo negeni, “Ibi bilibilinomate a꞉e tolemelo dalautioma꞉na꞉, wiyasiya nale a꞉ma꞉ akatepatama!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ya꞉sute ebeno tabo eba wiyanalo negeni, “Na a꞉ma꞉tamo nani tabo gemo, ka꞉lo idokolo kakabate netewa teta꞉mo geoa꞉no, a꞉ma꞉ netewa-kapiya teta꞉mo na iyatawa꞉noma꞉ kegema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wiyasiya Pitate kawonomamo walo na꞉kegeni, “Na a꞉ma꞉go da꞉na꞉emo, nale a꞉ma꞉ iyatawa꞉noma꞉ a꞉kegemo!” Ebe tetelo ibi bilibilinomate ebe atu tabo kegelaniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ebene Ya꞉suko ega꞉walo ebe waloma꞉tapi iba꞉te kawo duliyomolone nemaimionate tatali opo ida꞉mo tolameniya, ebe opono mailo Getasemanila. Ya꞉sute ebolo iba꞉tamo na꞉negeni, “La꞉ malo na꞉pola꞉nala꞉. Na me tataliamo tomo Godotamo towetowe tabo ka꞉negema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ebe tetelo ebete Pitako, Ya꞉imesiko, ega꞉walo Yoneko, ibi ebalata towetoweo tabo gela baiamo magataleni, ebene tepo mibomibo ega꞉walo woki temeteme tanalo ebetamo kawonomamo ebo pelameniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ebema꞉ Ya꞉sute iba꞉tamo negeni, “Na tepo temeteme kawonomamo iyatawanamo, mako temetemete na anakapuname keba kunula꞉ka꞉ eba kunula. La꞉le naimano tanaloma꞉ malo olowiolo na꞉pola꞉nala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ebene ebete kela꞉mo tonate ebeno ape opamo niyatinate Godotamo ebo na꞉towetoweoni, gabote da꞉modobomene ebe teteno tepo temetemete ebe katepama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ebete negeni, “Oe, Aba! Tanalo bilibilinomo osiyodilolema꞉ a꞉ma꞉godolo elawo bitana, ebema꞉ a꞉ma꞉le me tepo temeteme kalili nagodone nelawa꞉. Wiyasiya naimano ubia꞉, a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉imano ubila nosiyodila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ebene ebete waloma꞉tapiatamo da꞉peni laonalo pulamenate Pitatamo na꞉pegeni, “Saimono, la꞉ beda꞉ma꞉ kelawenama? Mabu keleka꞉ la꞉le naimano tanaloma꞉ tete da꞉pesamo olowioa꞉noma꞉ deda꞉wenama?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ebe tetelo Ya꞉sute ibi nanaleni, “Godotamo olowiolo na꞉towetoweonala꞉, mabu la꞉le Saitanakono kuba gabamo wabuga꞉ta tanalamo da꞉ba꞉gudima. La꞉imano tepo magumulo wade tanalo osiyodiloma꞉ ubila, wiyasiya la꞉godolo osiyodiloma꞉ elawo puliyala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ebene Ya꞉sute walo ka꞉tonate, ebete dopamo Godotamo towetowe tabo keba kunu ka꞉negeniyale, ebete atumu ka꞉negeni, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ebene ebete ebe waloma꞉tapiatamo walo da꞉ka꞉peni laonalo ka꞉pulameni. Ebe tetelo ibino balidite unomoma꞉ na꞉elaolameni, ebe mabuma꞉ iba꞉te ilipago ebetamo gela tabo nipo wadiniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ebene ebete walo ka꞉tonate netewa-kapiya tetelo Godotamo na꞉towetoweonate da꞉ka꞉peni iba꞉tamo na꞉pegeni, “La꞉ ela amiolo walo beda꞉ma꞉ ka꞉kelawenama? Taula, tete a꞉pe, kubakubapiate Epono Naniwi ibino kotamo nelawa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Iyo, la꞉ nemaimiala꞉, a na꞉tolaema꞉. Numa꞉la꞉, na anakapunamepino kotamo iyatinidawate ebe na꞉pe!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ya꞉sute ebe tabo eba genalo ebe tetenomolo Yudasite peni, Ya꞉sukono 12 waloma꞉tapino taneba magumulo ebe idila. Ebene eba꞉go dubu bilibilinomo epetapiate ibino gowelaono gili ega꞉walo gaubago da꞉pelameniya, ebe dubu ebe Godotamo kalimagono ikameopino watowatopi, Godokono Totomu iyatulamepi, ega꞉walo kawokawo dubu epetapi, iba꞉te dapaliboleniya ebe dubula. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nanitabola, Yudasite ibi iyalo ma kunu analeni, “Nale daboeteomo, ebe ebe lumagila. La꞉le ebe samonomamo lawa꞉wete wadenomamo nemagatiyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ebene Yudasite penate Ya꞉sutamo tonomo tonate ebe nanani, “Iyatulamedawa!” Ebe tetenomolo ebete ebe eba aboeteonalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","dubu epetapiate Ya꞉suko ibino kotamo kodakodanomolo ebo laweniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ebe tetelo Ya꞉suko waloma꞉tapi magumulo dubu idite ebeno gowelaono gili magoba꞉nate, Godotamo kalimagono ikameopino Unu Watodawanomono moto wokodawa anagaliminate, galo apu ebo mapitamidameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ebene Ya꞉sute iba꞉tamo negeni, “Na pilo lumagila꞉ka꞉, o na gowelaodawala꞉ka꞉? Mabu keleka꞉ la꞉le gowelaono gila꞉go ega꞉walo gaubago na lawenema꞉ da꞉pelama꞉ema? ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na egela epetapilo Godoko Amamateno Iya Motolo la꞉go eba okolilo epo diyatulamenatimo, la꞉le na ebolo kelawena꞉wea꞉, wiyasiya me tanalate a꞉pemaimia Godokono Buka tabono tanalate nanitaboma꞉ keda꞉oma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ebe tetelo ebe waloma꞉tapi bilibilinomate ebe atepanate gito alautioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ebolo oli ape dubu nutini, ebete dopamo wade keyakeya kalikunomo pulinate Ya꞉suko waloma꞉tapiago ebamo da꞉nemaigani, ebema꞉ dubu epetapi ubila ebe kelawenama꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wiyasiya ebete ebeno kaliku atepanate kikopiyanomo atumu gito kalaula꞉ni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ebene iba꞉te Ya꞉suko Godotamo kalimagono ikameopino Unu Watodawanomono motamo gito magataniya. Iba꞉te ebe ebe motamo magatana꞉no dopamo Godotamo kalimagono ikameopino watowatopi epetapi, ega꞉walo Godokono Totomu iyatulamepi, ega꞉walo kawokawo dubu epetapi, ibi bilibilinomate pelamenate ebo paladabutiniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ebe tetelo Pitate Ya꞉suko muludopone eba waloma꞉tanalo, ebete Unu Watodawanomono moto kala magumamo nopeganate, ebete atila꞉piago elalo ebo na꞉giga꞉oniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ebene Unu Watodawanomo ega꞉walo Ka꞉nisolo dubu bilibilinomo epetapiate tabo gelapi oleniya, Ya꞉sukono kuba olemenate ebe kanakapuima꞉. Wiyasiya iba꞉te ebeno kuba idi kuminiya꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","iyo, tabo gelapi bilibilinomate ebeno tanaloma꞉ a꞉da꞉ tabo eba kiyawaonalo, iyaiya tabo degelaniya ibino tabote wiyasiya kapiyama꞉ keda꞉oniya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ebene epetapiate maiminate Ya꞉sukono tanaloma꞉ a꞉da꞉ tabo eba kiyawaonalo, iba꞉te ma kunu gelaniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ebete tabo degiti ale ma kunu olowitima꞉, ‘Me Godokono Moto epate kotamo detiya, nale anabulimite netewa-kapiya egelalo moto idi walo ka꞉ketemamo, ebako moto epo epetapiate etema꞉ modoboa꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wiyasiya dopo a꞉da꞉ tabo kiyawaopi keba kunula꞉ka꞉, me oli tabo gelapi eba kunula, iba꞉te ibino tabo gela magumulo Ya꞉sukono tanaloma꞉ woki kapiyama꞉ keda꞉oniya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ebene Godotamo kalimagono ikameopino Unu Watodawanomote ibino tanebalo maiganate Ya꞉suko nalateda꞉ni, “A꞉ma꞉ tabo gea꞉noma꞉ beda꞉ma꞉ keda꞉wena? Me dubate a꞉imano tanaloma꞉ degelana keba kunula꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ebe tetelo Ya꞉sute tabo gea꞉no gito utini, ebema꞉ Unu Watodawanomote ebe walo nakalateda꞉ni, “Godoko epate ebe damamatena, a꞉ma꞉ ebeno Gudu Kelisotela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ya꞉sute nowamini, “Na ebe ebetela. Ebene la꞉le na Epono Naniwi aimano Elawodawa Godokono tumudi apulo okolitalo kunaemamota, iyo, walone na Unu Duliyomolone tema magumudo kapawokalamamo!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ebema꞉ Unu Watodawanomote ebe tabo olowinate, ebeno kawo dowa tanalonomo kawokaliminama꞉ ebete da꞉pulini ebe kaliku anagiyamidalenate negeni, “A me dubuno kuba kiyatawaoma꞉ tabo gedawa idi a ubia꞉nola! ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ebete a꞉ka꞉tuwa꞉ kuba tabonomo dege la꞉ ebe olowiomata, mabu ebete nege, ‘Na ega꞉walo Godoko, a kapiyala!’ Ebema꞉ ebeno tanaloma꞉ la꞉imano ubi keba kunula꞉ka꞉?” Ebene ibi bilibilinomate Ya꞉sukono tanalo eba anagiyamidamenalo ebe anakapuima꞉ ebo gelaniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ebe tetelo ibi epetapiate Ya꞉sutamo kowe meolenate, ebeno ololo mula꞉menate eba anagalimionalo negelaniya, “A꞉ma꞉ Godokono woki awokalimidawama꞉ nanitabolo deda꞉wena, a꞉ma꞉ negea piyate kanagalimiotana!” ebene atila꞉pi dubate ebe lawenate kotamo ebo anagalimioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Ebe tetelo Pitate ebe motono kala magumulo ebeno ape kenaenaiminama꞉ elalo okolini. Ebene Unu Watodawanomono woko buwelete penate, Pitako wadenomamo pumionate ebe napanani, “A꞉ma꞉ atumu me Nasalete duliyomolodawa Ya꞉suago pata꞉namiata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wiyasiya Pitate negeni, “Ao, na ebe dubu iyatawa꞉. A꞉ma꞉le degeawena ebe tabo na kemalagidilona꞉.” Ebene ebete kala ga꞉dimi gigiyamo da꞉toni, ebe tetelo kakabate negeoni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ebene woko buwelete ebe uminate, ebolo dilukuliniya ebe epo walo nakanaleni, “Me Ya꞉sukono lumagi idila!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","wiyasiya Pitate ebe atu iyatawa꞉ tabo kegeni. Ebene ebolo da꞉pola꞉niya iba꞉te tete da꞉pesamo ilukula꞉tepanate Pitako walo nakananiya, “Nanitabola! A꞉ma꞉ Ya꞉sukono lumagi idilata, mabu a꞉ma꞉ Ga꞉lili opodawalata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wiyasiya Pitate negeni, “Godokono dopo apulo utite gemo, nale nani tabo gea꞉no ebete na kanaginaemene! La꞉le kebe lumagima꞉ kegelawenama, na ebe iyatawa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ebene ebe tetenomolo kakabate geo netewa tetema꞉ deda꞉meni, Ya꞉sute ebetamo dopamo kebe tabo kegenile, Pitate ebe tabo ebo malagidiloni, “Kakabate netewa teta꞉mo geoa꞉no, a꞉ma꞉le netewa-kapiya teta꞉mo na iyatawa꞉noma꞉ kegema꞉ta.” Ebene Pitate kawonomamo ebo iini. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Duiyanomolo Godotamo kalimagono ikameopino watowatopi, ega꞉walo Godokono Totomu iyatulamepi, ega꞉walo kawokawo dubu epetapi, me Ka꞉nisolo epo bilibilinomate nopo iyatiya. Ebema꞉ iba꞉te Ya꞉suko ala꞉mo matuomeote Paeletetamo demagatiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paeletete ebe nalatediya, “A꞉ma꞉ Yu epono Kawo Elawodubula꞉ka꞉?” Ya꞉sute ebetamo nowamiya, “A꞉ma꞉le ebe ebe geata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ebe tetelo Godotamo kalimagono ikameopino watowatopiate Ya꞉sukono tanaloma꞉ negelitiya ebete iyaiya kubakuba tanalo osiyodilolenami, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ebene Paeletete ebe walo nakalatediya, “A꞉ma꞉ ibino tabo ba꞉kowamiaemene? Iba꞉te negelita a꞉ma꞉ kawokawo kubakuba tanalo bilibilinomo osiyodiloledawalata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wiyasiya Ya꞉sute tabo idi kegiya꞉, ebema꞉ Paeletete kawonomamo anoaniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ebe tete epono osiyodilo tanalo ma kunula, ulama bilibilinomo magumulo Yu epono Aduga꞉la Soliyomu tetelo iba꞉te idoko motolo kapiya lumagi mailamo deka꞉minakiya, Paeletete ebe lumagi ebeno kuba wiyane gito alibonaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ebe tetelo kapiya dubu ebeno mailo Balabasitela, ebete idoko moto gulo okolinami, ebeno tanalo ma kunula. Dopamo dubu epetapiate Loma gabamaniago gowelaopima꞉ eba eda꞉olo, iba꞉te epo epetapi ebo anakapulamiya, ebe mabuma꞉ Loma gabamani watowatopiate ibi Balabasiko ebana uwatete idoko motamo gito alomiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ebema꞉ Ya꞉sute Paeletekono ololo apulo eba utitalo, epo bilibilinomate ebetamo pelamete napaniya, ebete soliyomu tetelo dopamo keba kunu kosiyodilonakile eba kunu walo ka꞉kosiyodiloma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ebene Paeletete iba꞉tamo negiya, “La꞉ ubila꞉ka꞉ nale la꞉ Yu epono Kawo Elawodubu gito aliboma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ebete me tabo giya mabu ebete iyatawiya, Yu epo bilibilinomate Ya꞉sutamo nekalakalautiya, wiyasiya ibino watowatopiate ebe mabuma꞉ dowaote ebe gito magaiya, iyo, iba꞉godolo nanitabo tanalo puliyala, kitaniya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wiyasiya ebe tetelo Godotamo kalimagono ikameopino watowatopiate epo epetapi bilibilinomatamo elawo ikalamiya iba꞉te Paeleteko kanama꞉, ebete Balabasiko idoko motone gito alibote wiyasiya Ya꞉sutamo kuba wiya kikaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ebene Paeletete iba꞉tamo walo na꞉kegiya, “Me dubu la꞉le Yu epono Kawo Elawodubuma꞉ degelawenama, nale ebe keba kunu nakamitimo?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Iba꞉te gelatepaolo negeliya, “Kewa olotolowamo tupuguima꞉wete, ikoko nanagilamolema꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ebene Paeletete negiya, “Beda꞉ mabuma꞉? Ebete beda꞉ kuba kosiyodilile?” Wiyasiya iba꞉te kawonomamo gelatepaolo walo na꞉kegeliya, “Kewa olotolowamo ebe na꞉tupuguima꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ebema꞉ Paeletete ebe epo kalakalakobi ka꞉midilima꞉ ubi eba iyatilo, ebete Balabasiko idoko motone gito alibiya, wiyasiya ebete ebeno gowelaopi nanaliya iba꞉te Ya꞉suko pa꞉ka꞉pa꞉ka꞉mo ka꞉na꞉ma꞉ga꞉midaoma꞉. Ebene ebe tanalo dolopoligiya ebete Ya꞉suko iba꞉tamo gito ikalamiya, iba꞉te ebe kewa olotolowamo tupuguimite ikoko kanagilamolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ebe tetelo gowelaopi dubate Ya꞉suko nemagatiya Loma gabamanino kawo moto guamo, ebe motono mailo ebe Pelatoliyamala, ebene iba꞉te ibino gowelaopino taneba dubu bilibilinomo ka꞉la꞉mite iba꞉go ebo naladabutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Iba꞉te Ya꞉suko eba kalakalatelo wiya kawonomo kalimakalima kaliku ebetamo ebo pulimiya, ega꞉walo iba꞉te moeagono ale nelawete anagogobeyamidaolo a꞉dete ebeno watamo gito pulimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ebene iba꞉te ebe kalakalatelo negeliya, “Eiye! Yu epono Kawo Elawodubu, a꞉ma꞉ niyata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ega꞉walo iba꞉te ebe gaubamo watolo anagalimiote ebetamo kowe meolete, iba꞉te ebe eba kalakalatelo ibino pupamo ilukulite ebetamo ebo tudila꞉iya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Iba꞉te ebe kalakalate dolopoligiya, kalimakalima kaliku ebeno apene pekanamete ebeno kalikunomo walo gito ka꞉pulimiya, ebene iba꞉te ebe nemagatiya kewa olotolowamo ebe ka꞉na꞉tupuguima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ebe tetelo dubu idi Saimonoko ebe Sailiniya duliyomolodawala, ebe A꞉lesandako ega꞉walo Lupasiko ibino nabiwila, ebete iyabaine kawo duliyomolamo me gabodo eba pitalo, gowelaopiate ebe odiyobote ebo lawiya Ya꞉sukono kewa olotolowa kaguwataema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ebene iba꞉te Ya꞉suko nemagatiya Gologota damelamo, ebe damela mailono magumu ebe ‘Wato Goala.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ebolo iba꞉te elawo da꞉imi obo ega꞉walo temeteme olowia꞉no kaka mulamula adabulatelete ebetamo dikamiya Ya꞉sute ka꞉niya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ebene egelate kela꞉mo da꞉podolatepiya 9 koloko tetelo, gowelaopiate Ya꞉suko kewamo tupuguimite ikoko ebo anagilamolemiya, ega꞉walo iba꞉te nokola egege iyalekeolo kalakala tanalo eba osiyodilolo ebeno kaliku iyaiya uwatemete ebo alabaomiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ebe tetelo iba꞉te Ya꞉sukono a꞉e mabu awokalima꞉ tabo unamo ma kunu akuloliya, “Me dubu ebe Yu epono Kawo Elawodubula,” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ega꞉walo iba꞉te pilo dubu netewa Ya꞉suago iyaiya kewamo akotupuguilamiya, idi tumudi apuamo, idi pele apuamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ebe tanalote ma kunu pemaigiya, Godote ebeno Bukamo dopamo dakuloliya ebe tabote nanitaboma꞉ keda꞉ma꞉, iyo, ebeno Bukalo tabote ma kunu itana, “Iba꞉te ebe kubakubapiago kapiyama꞉ midiya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ebene piyate ebe gabodo da꞉petolamitiya iba꞉te Ya꞉suko malogolo nekalakalatitiya, iyo, iba꞉te ibino wato wadegelatelelo negelitiya, “Eiye! A꞉ma꞉ Godokono moto anabulima꞉wete, netewa-kapiya egelalo walo etema꞉ degeawia, a꞉ma꞉ ebe lumagilata! ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Modobola, a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉imano igilo mula꞉wete kewa olotolowa unune opamo na꞉piwisiga!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ebe tetelo Godotamo kalimagono ikameopino watowatopiate Godokono Totomu iyatulamepiago Ya꞉suko atumu na꞉kekalakalatitiya, ma kunu idite iditamo genaki, idite iditamo genaki, eba kunu wagelitiya, “Ya꞉sute epo epetapino olalati tanalo mula꞉lelamenaki, wiyasiya ebe a꞉ka꞉tuwa꞉ ebeno igilo mula꞉ma꞉ modoboa꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ebete Godokono Alibodawa ega꞉walo Isalaela epono nani Kawo Elawodubuma꞉ deda꞉na, modobola ebete kewa olotolowa unune opamo na꞉piwisigana, iyo, ale ebe tanalo umite ebe nanitabokobi ebo ka꞉midimalema꞉!” Ebe tetelo eba꞉go da꞉tupuguilamiya, ebe dubu netewate atumu Ya꞉suko malogolo kuba tabo na꞉kegelitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ebene egelate tuli teta꞉mo dutiya opo kawonomote ebo idokiya. Ebe tetelo idokote egelano alo eba mula꞉lo egelate a꞉iwate kela꞉mo a꞉niwisigatepani, egela tuli tetene wagilimite 3 koloko uwomuamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ebene Ya꞉sute Yu epono tabamo kawonomamo negeni, “Elai, Elai, lama sabakatani?” me tabono magumu ma kunu itana, “Naimano Godo, naimano Godo, na a꞉ma꞉le beda꞉ma꞉ katepana꞉wa꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Epetapi ebolo da꞉pola꞉niya iba꞉te ebeno tabo olowinate negelaniya, “Numa꞉la꞉, ebe Elayako ebe ka꞉mina!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ebene kapiya dubu na꞉puliganate umago kaka da꞉imi obamo naduba꞉midanate pudamo namogotenate Ya꞉sutamo eba nikamenalo negeni, “Iyaiya, a kuma꞉tepiye! Elayate ebe pelawete opamo da꞉ba꞉powolukomene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ebe tetelo Ya꞉sute kawonomamo gepatenate a꞉enomo ebo a꞉eni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ebene Godoko Amamateno Iya Motono kaliku ubilite tulituliya bolegale unune wagiliminate opamo ebo piwisigani. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ega꞉walo Ya꞉sukono ololo apulo dutini, ebe gowelaopino elawodubute Ya꞉sute keba kunu ka꞉enile ebe tanalo uminate negeni, “Nanitabola, me dubu ebe Godokono Gudula!” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ebe tetelo kamiyale epetapiate Ya꞉suko uima꞉ mulune putitataniya, piyate eba꞉go Yelusalemamo da꞉pelamiya, ibi ebe kamiyalela, ega꞉walo ibino taneba magumulo Salomiko, ega꞉walo Magadala duliyomolodawa Ma꞉liko, ega꞉walo Ma꞉li idi ebeno gudi netewa Yausesiko ega꞉walo Da꞉pesodawa Ya꞉imesiko, miba꞉te pola꞉niya. Nanitabola, Ya꞉sute Ga꞉lili opolo depata꞉nami me netewa-kapiya kamiyala꞉te ebe wadenomamo walubinamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Adimo tetelo A꞉limitiya duliyomolodawa Yausepete na꞉peni, ebe Yu epono Ka꞉nisolo magumulo tuputupu lumagi idima꞉ eda꞉nami, iyo, ebete Godokono Kawo Elawodawama꞉ eda꞉ tete nemakopelenami. Ebene ebete ma kunu pemalagidiloni, ebe egela Yu epono wokoa꞉ egelano inamabu osiyodilole tetela mabu dumutu ebe talena egelala, ebema꞉ ebete tonate Paeleteko tolea꞉no nananani Ya꞉sukono ape lawenama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paeletete ebe tabo olowinate kawiya la꞉wa꞉nate wokilo negeni, “Ya꞉sute iyalo a꞉ka꞉eakale?” ebema꞉ ebete gowelaopino elawodubu ebetamo ka꞉minate Ya꞉sukono a꞉e tanaloma꞉ ebe ebo alateda꞉ni. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ebene Paeletete gowelaodawa elawodubugodone Ya꞉sukono a꞉e tete olowinate Yausepetamo modobo tabo ebo geni ebete Ya꞉sukono ape lawenama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ebene Yausepete wade keyakeya kalikunomo maniamo lawenate Ya꞉sukono ape opamo powolukonate, wade kalikamo auputinate nokola bobo magumamo ebo niyatini, ebe bobo epate maboele nokola damela eba obobolo iyalo ebo osiyodiliya. Ebe tetelo Yausepete kawo nokola mupiamidanate bobo gigiyu ebo nemopini, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ebene Magadala duliyomolodawa Ma꞉liko ega꞉walo Yausesikono menoko Ma꞉liko, Yausepete Ya꞉sukono ape diyatini iba꞉te ebe bobo bai uminiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ebene Yu epono wokoa꞉ talena egela tete dolopoligiya, Magadala duliyomolodawa Ma꞉liko, Ya꞉imesikono menoko Ma꞉liko, ega꞉walo Salomiko, iba꞉te tolamenate wade nibo inamabu maniamo nuwateoniya egela idilo Ya꞉sukono apa꞉mo kapabutilamelema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ebene Sande egela duiyanomolo egela eba waloutalo, iba꞉te nokola bobo baiamo da꞉tolamitiya ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","na꞉negeliya, “Bobo gigiyulo ditana ebe kawo nokola balamo potele na꞉ka꞉na꞉mupiamidaeaemene?” Iba꞉te ma kunu gelitiya mabu ebe nokola mibonomola, wiyasiya iba꞉te wadenomamo eba meleolo, ebe kawo nokola balamo iyalo mupiamida eba itanalo ebo numiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ebene iba꞉te nokola bobo magumamo nopila꞉ote, oli ape dubu keyakeya ga꞉ga꞉ kaliku pulite tumudi apulo dokoliti numite kawonomamo nanoanoutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ebete iba꞉tamo negiya, “La꞉ akoanoanoala꞉! Nasalete duliyomolodawa Ya꞉suko epate ebe kewa olotolowamo da꞉tupuguimiya, la꞉le ebe waditamata. Ebe malo puliyala, ebe emaigaka! Iba꞉te ditidi adimolo ebe diyatiniya ebe bai la꞉ numa꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ebema꞉ la꞉ tolama꞉wete Pitako ega꞉walo ebe waloma꞉tapi epetapi nananala꞉la꞉, ‘Ya꞉sute Ga꞉lili opamo dopamo ka꞉tomene. La꞉ tolama꞉wete ebe ebo ka꞉nuimamota, ebete la꞉ dopamo keba kunu kanaletia eba kunu.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ebene iba꞉te anoanolo anakamiago nokola bobo magumune pemaimiote gito pipuila꞉iya, wiyasiya iba꞉te lumagi idi kaniya꞉ mabu iba꞉te kawonomamo toletoleutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ebe Sande egela duiyanomolo Ya꞉sute a꞉e magumune maigate, Magadala duliyomolodawa Ma꞉litamo dopamo nawokaliya, ebe kamiyalegodone Ya꞉sute dopamo sebeni kubakuba uliyana aliboliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ebema꞉ Ma꞉lite tote, piyate Ya꞉suago dopamo dowapata꞉lamenamiya ebe epate eba iimitalo ibi ebo nanaliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","wiyasiya iba꞉te Ya꞉sukono igilamo maiga tanalo ega꞉walo Ma꞉lite ebe dumiya, iba꞉te ebe tabo olowite nanitabokobi ka꞉midiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Walone Ya꞉sukono waloma꞉tapi netewate Yelusalema kawo duliyomolone eba tutalo, Ya꞉sukono apete iyama꞉ eda꞉mete ebete iba꞉tamo ebo nawokaliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ebene ibi netewapiate walo na꞉ka꞉tiya waloma꞉tapi epetapi kananalema꞉, wiyasiya iba꞉te ebe tabo olowite nanitabokobi ka꞉midiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Walone Ya꞉sukono 11 waloma꞉tapiate ilukulite bae eba nautalo Ya꞉sute iba꞉tamo ebo nawokaliya, ebema꞉ ebete ibi kawiya analiya mabu iba꞉te ibino tepo magumulo kodakodaibima꞉ eba eda꞉olo nanitabokobi ka꞉midiya꞉, iyo, epetapiate ebeno igilo tanalo umite ibi dapanaliya, iba꞉te ibino tabo olowite ebeno a꞉e magumune maiga tanalo iba꞉te nanitabokobi ka꞉midiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ebene Ya꞉sute iba꞉tamo negiya, “La꞉ opo kawonomamo tolama꞉wete Godokono Wade Tabo iyaiya epo bilibilinomatamo na꞉nikiyawaolamenakiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kebe lumagite nanitabokobi midite ebene obamo aduba꞉mida tanalo delaemene, Godote ebeno igilo ka꞉mula꞉emene, wiyasiya kebe lumagite nanitabokobi midia꞉no Godote ebe lumagino tanalo anagiyamidamete ebetamo kuba wiya nanitabolo kikaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nanitabola, Godokono elawo awokalima꞉ anoano tanalate nanitabokobi midipiagodolo ka꞉pola꞉nama꞉na꞉. Iyo, iba꞉te naimano mailamo epagodone kuba uliyana balibolenakoma꞉na꞉ ega꞉walo iba꞉te Unu Duliyomolono nopopino iyaiya tabamo ba꞉kiyawaonakoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ebene iba꞉te kalu kotamo duwatolenakoma꞉na꞉ ega꞉walo iba꞉te a꞉e obo da꞉nionakoma꞉na꞉, ebe tanalate ibi a꞉ka꞉kubailamenakoma꞉na꞉, ega꞉walo iba꞉te temetema꞉gopiatamo ibino koto dowatiolelamenakoma꞉na꞉, ebe tetelo ebe temetema꞉gopiate wadekobi bolowionakoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ebene Kawodawa Ya꞉sute iba꞉tamo tabo kiyawao dolopoligiya, Godote ebe pelawete Unu Duliyomolamo ebo adipatiya, ebolo ebete Godokono tumudi apuamo gito nokoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ebene waloma꞉tapiate tolamete iyaiya opo bilibilinomolo Godokono tabo eba na꞉kiyawaolamelo, Kawodawa Ya꞉sute iba꞉go kapimiya Godokono woko nosiyodilonamiya, iyo, ebe tetelo ebete Godokono elawo awokalimino anoano tanalo magumudo ebe Wade Tabo elawokobi nimidinami. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Naimano wade namutudawa Tiyopolasi, niyata. Aimano taneba magumulo kebe iyaiya tanalate iyalo da꞉pemaimiya, piyate wagilimi mabune ibino balidinomamo ebe tanalo dulamoliya, ibi epetapiate Godokono Wade Tabo eba kiyawaolo ebe atu tanalo a ega꞉walo epo epetapi bilibilinomo ebo anaiya. Nanitabola, ebe tetene wagilimite epetapi bilibilinomate ebe iyaiya tanalo pepamo nanitabonomolo akulolema꞉ nowageleonamiya, wiyasiya ibi magumulo idawate woko wadenomamo kopoliya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ebema꞉ naimano kawodawa, nale me tanalo bibibilinomo ibino wagilame mabune wadenomamo eba malagidilolenapelo, naimano tepo magumuno wokilo ubi ebo iyatimo a꞉ma꞉tamo buka osiyodilote me tanalo ka꞉tuputupuilaema꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","iyo, epetapiate a꞉ma꞉ diyatumiotia, a꞉ma꞉le ebe tanalo bilibilinomo nanitabonomolo kiyatawaema꞉, nale me tanalo ebema꞉ osiyodilomo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ebe tetelo Elodite Yudiya opono Kawo Elawodubuma꞉ eba eda꞉nalo, dubu idi ebeno mailo Sekalayatela, ebete Abayakono tanebadawama꞉ eda꞉nami, ebe Godotamo kalimagono ikameodawa idila. Ebeno kamiyaleno mailo Elisabetitela, ebe kamiyaleno nabiwi atumu Godotamo kalimagono ikameodawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ebene ibi netewapino ilukuli tanalote Godokono ololo apulo tuputupunomoma꞉ eba eda꞉onalo iba꞉te ebeno totomu tabo bilibilinomamo nanitabonomolo tudila꞉onamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wiyasiya ibi niyaniyala, iba꞉godolo gudu puliyanomola mabu Elisabetiko ta꞉li kamiyalema꞉ eda꞉nami, iyo, Sekalayako ega꞉walo Elisabetiko iba꞉te kadele abelenomoma꞉ eba eda꞉olo gudu uima꞉ modoboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ebene sagana idilo Sekalayakono gu epono tetete pemaigiya, iba꞉te Godoko Amamateno Iya Motolo iyaiya woko ka꞉posiyodilolema꞉. Ebema꞉ egela idilo Sekalayate ebolo woko nosiyodiluti, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","mabu ebe egelalo ebeno epate Godokono ubi tanalamo eba tudila꞉olo ebe lawiya, ebete Godoko Amamateno Moto guamo nopegate, ebolo ebete wade nibo tuwae inamabu patapata unamo eba naminaolelo Godotamo ka꞉nikameoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ebene ebe inamabuate elalo eba wamoteutalo epo bilibilinomate Godoko Amamateno Moto niyakabolo ibino towetowe tabo Godotamo ebo negelitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ebe tetelo Godokono nopodawate wade nibo tuwae inamabu wamoteno patapata tumudi apudo eba pemaigalo Sekalayako kapiyatamo ebo pawokaliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ebene ebete ebe umite woki bilibilinomoma꞉ eda꞉lo kawonomamo toletoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wiyasiya nopodawate ebetamo negiya, “Sekalaya, a꞉ma꞉ akotoletola꞉la꞉. Godote a꞉imano towetowe tabo olowi, ebema꞉ a꞉imano kamiyale Elisabetite dubu gudu kalaimene. A꞉ma꞉ ebeno mailo Yonema꞉ neka꞉miye. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nanitabola, ebete dawokalamene a꞉ma꞉ kawonomamo ebo kekalakalama꞉ta, ega꞉walo epo bilibilinomate ebe mabuma꞉ atumu kawonomamo ka꞉kekalakalaoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ebete ebeno menokono tepolo eba okolilo Godokono Uliyanate ebe iyalo ketabokaimene, ebema꞉ Godokono dopo apulo ebete kawodawama꞉ keda꞉mene, ega꞉walo ebete elawo da꞉imi obo a꞉ka꞉ninakomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Nanitabola, ebete Isalaela epo bilibilinomo ibino Kawodawa Godotamo walo ka꞉kemagaelemene, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","iyo, ebete aimano Kawodawa dopomete ka꞉tomene ega꞉walo Wade-talena Uliyanate ebe unamo eba okolilo ebete elawonomoma꞉ keda꞉mene, Godokono woki awokalimidawa Elayako keba kunula꞉ka꞉ eba kunu. Ebema꞉ ebete nabi ega꞉walo gudi kapiyama꞉ walo ka꞉ka꞉midilimene, iyo, ebete Godokono tabo olowioa꞉pino woki iyakobi midililamete ka꞉tuputupuilamelelaemene, ega꞉walo ebete Kawodawano epo wadekobi ka꞉midilimene ebeno pe tanaloma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekalayate Godokono nopodawatamo negiya, “Na me tanalo nanitabonomolo keba kunu na꞉kiyatawamo, mabu na kadelenomola ega꞉walo naimano kamiyale abelenomola?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ebene Godokono nopodawate nowamiya, “Na ebe Ga꞉ibiliyolotela, Godokono ololo apulo utitanakomo, iyo, na ebete palibone me wade tabo a꞉ma꞉ kapanatama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Naimano tabote nanitabonomoma꞉ keda꞉mene, wiyasiya a꞉ma꞉le ebe tabo nanitabokobi ka꞉mida꞉wea꞉, ebema꞉ me tetene wagilimite ebe nanitabo tanalote pemaiga teta꞉mo a꞉ma꞉ tabo kiyawaoa꞉noma꞉ keda꞉ma꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ebe tetelo epo bilibilinomate Sekalayakono pemaiga tanalo eba makopelitalo iba꞉te negelitiya, “Tete geyageyanomolo ebete Godoko Amamateno Motolo beda꞉ma꞉ ka꞉lutale?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ebene ebete Godoko Amamateno Iya Motone da꞉pemaigiya epatamo tabo kiyawaoma꞉ ka꞉pa꞉modobiya꞉. Wiyasiya ebete iba꞉tamo kotamo da꞉pa꞉kiyawaiya, ebe tanalodo iba꞉te ma kunu iyatawiya, ebete Godokono Motolo eba lutalo, Godokono nopodawate ebetamo da꞉pemaiga ebeno balidite iyama꞉ ebo eda꞉ome. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ebene Sekalayakono woko tetete Godoko Amamateno Motolo dolopoligiya, ebete ebeno duliyomolamo ebo tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ebene egela epetapiate da꞉petoiya ebeno kamiyale Elisabetite lamituma꞉ dediya, ebete ebe tetene wagilimite paibu sagana magumulo ebeno motonomolo okoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ebe tetelo ebete ebeno tepo magumulo tabo ma kunu giya, “Ka꞉lo uwomu egela tetenomolo Godote na a꞉nilakapoinami, iyo, ebete gudu natamo eba ikanamelo naimano ilipo tanalo iyabaiamo iyatinami.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ebene Elisabetite lamituma꞉ eda꞉te, sikisi sagana da꞉petoiya Godote ebeno nopodawa Ga꞉ibiliyoloko Ga꞉lili opono Nasalete duliyomolamo ebo palibiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ebete buwele Ma꞉litamo Godokono nopo adaiya, ebe buwele dopamo Yausepetamo atamiya, me dubu Yausepeko ebe Kawo Elawodubu Da꞉ibidikono walone gudu idila. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ebene nopodawate Ma꞉liko napaniya, “A꞉ma꞉ niyata, Kawodawa Godote a꞉ma꞉ nilakapolo elawiata! Ebete a꞉ma꞉godolo bokolina!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ebema꞉ Ma꞉lite ebe tabo dolowiya woki bilibilinomoma꞉ eda꞉lo ebeno tepo magumulo negiya, “Me beda꞉ tanalola꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nopodawate ebetamo negiya, “Ma꞉li, a꞉ma꞉ akotoletola꞉la꞉, mabu Godote a꞉ma꞉ ma kunu a꞉nilakapoimita, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","a꞉ma꞉le lamituma꞉ eda꞉wete dubu gudu kalaima꞉ta, ebene a꞉ma꞉ ebeno mailo Ya꞉suma꞉ neka꞉miye. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ebete kawonomoma꞉ keda꞉mene, epate ebe Ununomo Godokono Guduma꞉ beka꞉minakoma꞉na꞉, iyo, Godote ebe Kawo Elawodubuma꞉ ka꞉midimene, ebeno ewono Da꞉ibidiko keba kunu kokolinamile eba kunu. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ebema꞉ nanitabola, Ya꞉ikobokono walone gudi magumulo ebete uwomua꞉ uwomua꞉ tetelo Kawo Elawodubuma꞉ beda꞉namene, iyo, ebeno Kawo Elawodawama꞉ eda꞉ tanalote a꞉kolopoligonamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma꞉lite wiyasiya nopodawatamo negiya, “Na buwelenomola ega꞉walo na awia꞉nola. Me tanalote natamo keba kunu na꞉kemaigamene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nopodawate ebetamo nowamiya, “Wade-talena Uliyanate a꞉ma꞉tamo ka꞉pemene, ega꞉walo Godokono elawote a꞉ma꞉ unamo kokolimene, ebema꞉ a꞉ma꞉le dalaima꞉emene ebe talena gudu epate Godokono Guduma꞉ beka꞉minakoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","A꞉ma꞉ a꞉imano menokono naniko Elisabetikono tanalo nemalagidila. Dopamo epate negelanakiya ebe ta꞉li kamiyalela, wiyasiya ebete abele tetelo lamituma꞉ eda꞉te sikisi saganate olopoligi. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nanitabola, tanalo bilibilinomo osiyodilolema꞉ Godogodolo elawo bitana, osiyodiloa꞉ tanalo idite ebegodolo kitana꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ebema꞉ Ma꞉lite negiya, “Na Kawodawa Godokono wiya꞉ woko buwelela. Modobola a꞉ma꞉le degeawa꞉, ebe tanalote nemaigamene,” ebene Godokono nopodawate ebegodone gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ebe tetelo Ma꞉lite samonomamo maigate Yudiya opono unuunu damelamo tote mulu duliyomolo ida꞉mo gito nemaigiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ebene ebete Sekalayakono motamo nodolote Elisabetiko eba na꞉wiyamidalo ebetamo nilakapo tabo ebo na꞉kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ebema꞉ Elisabetite Ma꞉likono nilakapo tabo dolowiya, ebe tetenomolo ebeno tepo magumulo gudute kawo kalakala lawete ebo igiligaiya. Ebene Godokono Uliyanate Elisabetikono tepo magumu detabokaimiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ebete tabo unamo adipatelo Ma꞉litamo negiya, “Kamiyale bilibilinomo magumulo Godote a꞉ma꞉ unamo adipatelo wadenomamo bowalubinama꞉ta, ega꞉walo a꞉ma꞉le dalaima꞉emene Godote ebe Kawodawa atumu uwomua꞉ tetelo bowalubinamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Naimano Kawodawano menoko, a꞉ma꞉le na unaema꞉ da꞉pa꞉wa꞉ kalakala kawonomola, wiyasiya me wade tanalonomote na kuba lumagitamo beda꞉ma꞉ ka꞉pemaigale? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nanitabola, nale a꞉imano tabo dolowimo, ebe tetelo naimano tepo magumulo gudute kawo kalakala lawete ebo igiligao, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ebema꞉ a꞉ma꞉tamo kalakala beda꞉ kawonomola꞉ka꞉, mabu a꞉ma꞉le Godoko nanitaboma꞉ a꞉midiata ebeno tabote a꞉ma꞉do nanitabonomoma꞉ keda꞉mene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ebene Ma꞉lite negiya, “Naimano kimalagidilote Godoko nowaloguta, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","iyo, naimano tepo magumute naimano Igilo Mula꞉dawa Godotamo nekalakalita, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","mabu ebete na malagidilonelo kalakala tanalo osiyodili na ebeno da꞉peso wiya꞉ woko buweletamo! Ebema꞉ me tetene wagilimite uwomua꞉ uwomua꞉ tetelo epo bilibilinomate na kalakala lumagima꞉ beka꞉na꞉minakoma꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mabu Elawonomo Godote natamo wadewade tanalo kawokawo osiyodiloli, iyo, ebe Kawodawano mailo talenala! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","“Nanitabola, piyate ebe da꞉tolemena ebete iba꞉tamo nilakapo biyatinakomene, iyo, epate me opolo tete geyageyanomolo eba ilukulinalo, ebete iba꞉tamo ma kunu bowagelenakomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ebema꞉ a tetelo ebete ebeno kotamo kawokawo tanalo osiyodiloli, ega꞉walo piyate ibi a꞉ka꞉tuwa꞉ amamaolo kawokawoma꞉ degeliya, ebete ibino nopo kubailamete ebeno elawamo ibi a꞉na꞉ma꞉lateli. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","“Ega꞉walo ebete kawokawo elawodubu ibino gobebobone iyabaiamo alomi, wiyasiya ebete ebe atu tetelo dologala epo owadipalateli. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iyo, piyate nigologololo dilukulinamiya, ebete ibi wadewade inamabuamo eba tabokailamelo, wiyasiya inamabu bilibilinomagopi inamabua꞉no gito aliboli. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","“Ebema꞉ nanitabola, ebete aimano ewoniatamo nanitabonomolo degiya, ebe tabote a tetelo nawokala, iyo, tete tatalila ebeno walubi tanalote ka꞉pemaigamene ebeno wiya꞉ wokodawa Isalaelatamo. Me ebe mabuma꞉ Godote A꞉ibalayamatamo kebe nilakapo kawokalimiyale, ebe nilakapamo ebeno walone gudi uwomua꞉ tetelo bemalagidilolenamene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ma꞉lite me iyaiya tabono tanalo kiyawao dolopoligiya, ebete netewa-kapiya sagana Elisabetiago okolite, ebene ebete ebeno duliyomolonomamo walo gito ka꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ebene Elisabetikono gudu alaimi tete da꞉piya ebete dubu gudu alaimite, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ebe niyakabolo dilukulinamiya ega꞉walo ebeno mabu epo, iba꞉te Godokono wade walubi tanalo Elisabetigodolo umite eba꞉go nekalakalaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ebene sebeni egela da꞉petoiya, a꞉iti egela tetelo iba꞉te dubu guduno tama itamida pukala osiyodiloma꞉ ebo pelamiya. Ebe tetelo epetapiate ubi iyatiya ebe gudu ebeno nabiwi Sekalayakono mailamo keka꞉ima꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","wiyasiya ebeno menokote negiya, “Ao, la꞉ ebeno mailo Yonema꞉ neka꞉miala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ebene iba꞉te la꞉wa꞉ote ebetamo negeliya, “Numa꞉, a꞉imano epagodolo me mailo kitana꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ebema꞉ iba꞉te ebeno nabiwitamo kotamo eba gelalo ebe nalatediya, ebeno ubi keba kunu kitanale gudutamo mailo kikaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ebene Sekalayate kotamo kiyawaolo epetapiate tabo akuloleno inamabu adaema꞉ danaliya, ebete ebe inamabu lawete ma kunu akuloliya, “Ebeno mailo Yonetela.” Ebe mabuma꞉ iba꞉te kawonomamo anoanoiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ebene ebe tetenomolo Sekalayakono tabo kiyawao tanalote wadekobi da꞉kolowimiya, ebete Godoko moio ebo wagilimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ebema꞉ ebeno duliyomolo epate ebe anoano tanalo dulamiya iba꞉te kawonomamo toletoleiya, ebene iba꞉te ebe iyaiya tanalo epo epetapi da꞉nikiyawaolamiya, ebe tabote Yudiya opono unuunu damelano duliyomolo bilibilinomamo ebo tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ega꞉walo piyate ebe tabo dolowiya iba꞉te eba malagidilolo negeliya, “Me gudu ebete kebako dawama꞉ na꞉keda꞉mene?” Iba꞉te me tabo negeliya mabu ibino umi magumulo Godokono elawote ebe gudugodolo nanitabonomolo itani. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ebene Godokono Uliyanate Yonekono nabiwi Sekalayakono tepo magumu detabokiya, ebete Godokono woki ma kunu awokalilamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Godote Isalaela epo wadenomamo dowalubilinako, ale ebe ebema꞉ kemoiomalema꞉, mabu ebete ebeno epo walubilima꞉ ebe na꞉pe, tete tatalila ebete ibino kuba osiyodilole magumune ibi ka꞉powagailimene! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Iyo, Godote a mabuma꞉ dadipati, ebe Kawo Igilo Mula꞉leamedawate ebe na꞉pe, ebe Godokono wokodawa Da꞉ibidikono walone gudu idila. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","“Nanitabola, piyate dopamo tetelo Godokono talena magumulo dilukulionamiya, ebete ebe wokopido ebeno woki eba awokalimilo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","piyate dowaote atamo gowela tanalo dosiyodilonaka, ebete a ibino elawo kotone kowagaimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Iyo, ebete tabo idi ma kunu kegiya, ebete aimano ewoniatamo ebeno nilakapo biyatinamene, ega꞉walo ebete iba꞉tamo kebe nopo nanitabonomolo kiyatiyale, ebe wade-talena tabo eba malagidilonalo uwomua꞉ tetelo ebete bosiyodilonakomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","“Ega꞉walo ebete aimano ewono A꞉ibalayamatamo nanitabonomolo na꞉kegiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","piyate ago da꞉gowelaonaka, ebete a ibino koto magumune kuwatemene, ebene ale ibi tolelamea꞉no ebe kapiyatamo woko bosiyodilonakoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Iyo, ale ebeno ololo apulo talena epoma꞉ eba eda꞉onalo, ale uwomua꞉ tetelo ebeno tuputupu gabodo bowapata꞉lamenama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ebene Sekalayate ebeno tabo moga꞉melo walo na꞉kegiya, “O naimano gudu Yone, epate a꞉ma꞉ Ununomo Godokono woki awokalimidawama꞉ beka꞉minakoma꞉ta, iyo, ebete dapalibomene, a꞉ma꞉le ebe Kawodawano gabo dopoma꞉wete eba tonatolo, ebeno gabo kosiyodiloema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ega꞉walo a꞉ma꞉le Godokono epo ma kunu kiyatulaema꞉ta, ebete ibino kuba eba egebolelamelo ka꞉dodolomatililaemene, iyo, ebete ebe gabodo ibino igilo ka꞉mula꞉lelaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","“Ebema꞉ nanitabola, aimano Godote a kawonomamo eba nilakapoiamenalo, ebeno igilo mula꞉leno alote atamo ebo ka꞉pemaigamene, egelate epatamo da꞉pemaiganako eba kunu. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ebe alote ebeno Unu Duliyomolone ka꞉pa꞉pukuilaemene, a꞉e magumulo ega꞉walo idoko magumulo dilukuliona ebe epatamo, ebema꞉ kalakala kawonomola, Godote ebeno milolo wapata꞉lame tanalono gabo a ebo kiyatuaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ebema꞉ Sekalayakono gudute eba apelo Godokono Uliyanate ebe magumulo elawonomoma꞉ ediya, ebene ebete bulu opamo tote ebo nokolinami, wiyasiya walone Godokono ubi tetelo ebete Isalaela epatamo ebo pemaigiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ebe tetelo Kawo Elawodubunomo Sisa Ogastasete opo kawonomamo tabo napalibiya epo bilibilinomate ibino mailo gabamanino bukamo kanalomolema꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ebe atu tetelo Kiliniyasete Siliya opono Kapela Elawodubuma꞉ eda꞉nami. Buka ka꞉la꞉mioledawa, modobola a꞉ma꞉ niyatawa, me dopo tetela epo bilibilinomate ibino mailo gabamanino bukamo danalomoliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ebema꞉ epo bilibilinomate ebe tanalo ka꞉nosiyodiloma꞉ ibino ewonino iyaiya duliyomolamo na꞉tolamoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ebene Yausepete Ga꞉lili opono Nasalete duliyomolone Yudiya opono Beteliyama duliyomolamo tiya, mabu ebe Kawo Elawodubu Da꞉ibidikono walone gudu idila ega꞉walo Da꞉ibidiko Beteliyama duliyomololo awokaliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ebe tetelo Ma꞉liko ebetamo atamiya ega꞉walo ebe lamitula, ebema꞉ ibi netewapiate kapimiya tiya iba꞉te ibino mailo ebolo kanalomoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ebene iba꞉te Beteliyamalo eba nilukulilo idoko idilo Ma꞉likono gudu alaimi tete da꞉peni, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ebete ebeno dopo koi gudu alaiminate ebe kalikamo auputinate kau-goeogoeono uwago nao bokose guamo gito adilatini, mabu kapela epate delaonakiya ebe motolo tetea꞉nola iba꞉te ebolo ilukulima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ebe tetelo sipi-goeogoeo ulamepiate Beteliyama duliyomolo niyakabolo uwago opolo ibino sipi-goeogoeo eba ulamenalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kawodawa Godokono nopodawate iba꞉tamo pawokalanate Godokono alo kawonomote ibi ebo pipukuilameni. Ebema꞉ iba꞉te kawonomamo toletoleoniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","wiyasiya nopodawate iba꞉tamo negeni, “La꞉ ka꞉toletoleonala꞉! Na la꞉tamo wade tabo adaemo, ebe tabote epo bilibilinomatamo kalakala kawonomo kikalaemene, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","mabu ka꞉lo idokolo Da꞉ibidikono duliyomololo la꞉imano Igilo Mula꞉lelamedawa awokala, ebe Kawodawa Kelisotela, Godokono Alibodawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","La꞉ tolama꞉wete ebe gudu kalikamo auputi ka꞉nuimamota, ega꞉walo ebe kau-goeogoeono uwago nao bokose guamo adilatila, iyo, la꞉le ebe anoano tanalo numa꞉wete ebo kiyatawaomamota naimano tabo nanitabonomola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ebe tetenomolo ebe nopodawago Godokono nopopi epetapi bilibilinomate gito pawokalaoniya, ebene iba꞉te Godoko eba adipatenalo negelaniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Godote ebeno Ununomo Duliyomololo dokolina, la꞉ ebe moiolo nadipata꞉la꞉. Me opolo ebete piyatamo dekalakalana, ebeno igilo mula꞉ tanalote iba꞉godolo nitanamene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ebene Godokono nopopiate Unu Duliyomolamo walo da꞉ka꞉nodoloniya, ebe tetelo sipi-goeogoeo ulamepiate negelaniya, “Kawodawa Godote a danae Beteliyama duliyomololo ka꞉lo idokolo da꞉pemaiga, a ebe tanalo uima꞉ ka꞉tolamiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ebene iba꞉te samonomamo tolamenate, Ma꞉liko, Yausepeko, ega꞉walo gudu kau-goeogoeono uwago nao bokose guamo adilati, iba꞉te ibi ebo nulameniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ebene sipi-goeogoeo ulamepiate gudu numinate, nopodawate ebeno tanaloma꞉ degeni, iba꞉te ebe tabo Ma꞉liko Yausepeko ibi ebo nanaleniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nanitabola, ebe tetene wagilimite piyate sipi-goeogoeo ulamepino tabo dolowiya ibi bilibilinomate kawonomamo anoanoiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ega꞉walo Ma꞉lite me iyaiya tanalo ebeno tepo magumamo alomonate tete bilibilinomolo kawonomamo nemalagidilolenami. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ebene ebe idokolo sipi-goeogoeo ulamepiate eba olowamionalo, Godoko amamata꞉go ebo tolameniya, mabu iba꞉te Godokono nopodawagodone kebe tabo kolowioniye, iba꞉te ebe tanalo bilibilinomo nanitabonomolo a꞉nulamoleniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ebene wuiki kapiya olopoligote dubu guduno tama itamida pukala osiyodilo tete da꞉piya, Yausepeko Ma꞉liko iba꞉te me gudu Ya꞉suma꞉ ka꞉miya, mabu ebeno menokote lamituma꞉ eda꞉no Godokono nopodawate me mailo iyalo ikamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Ebene tete da꞉piya iba꞉te Ya꞉suko lawete Yelusalema kawo duliyomolamo gito tolamiya menokola gudula ibino agima talena ka꞉nopoliyalema꞉, Godote Mosesedo totomu tabo diyatiya eba kunu. Iyo, ebe totomu tabote Yu epo ma kunu iyatulamena, agima talena olopoligo tetelo menokote bigo ola netewa o badu ola netewa Godotamo nikameomene, ebema꞉ Yausepeko Ma꞉liko iba꞉te me totomuamo tudila꞉ote kalimagono inamabu ebetamo eba kunu ikameiya. Ega꞉walo ebe atu tetelo ibi ubila gudu Ya꞉suko Godotamo ikaema꞉, mabu Godokono totomu tabo idite ma kunu kegena, dopo dubu gudi talenama꞉ midilite Godotamo kikameoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ebe tetelo dubu idi ebeno mailo Simiyonotela, ebete Yelusalema kawo duliyomololo okolinami. Ebe tuputupudawanomola, iyo, ebete Godotamo na꞉tuduwatanami ega꞉walo ebete Isalaela epono igilo mula꞉le tanalono maiga tete nemakopelenami. Ebema꞉ Godokono Uliyanate eba꞉go eba okolinalo ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ebe iyalo aniya ma kunu, ebete Godokono Alibodawa Kelisoko dopamo umite ebe walone ebo ka꞉emene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ebene Ma꞉liko Yausepeko iba꞉te Godokono totomuamo tudila꞉olo ibino gudu Godoko Amamateno Iya Motamo demagatiya, ebe tanalo Godokono Uliyanate Simiyonoko ebo iyatumiya. Ebe tetelo ebete Godokono Motamo pete, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","gudu Ya꞉suko pumite ebeno kotamo ebe pematopa꞉te Godotamo kalakala tabo ma kunu pa꞉kiyawaiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kawodawa, a꞉ma꞉le dopamo nanitabonomolo degeawiyala ebe tabote awokala, ebema꞉ na a꞉imano wiya꞉ wokodawate gelebadiago a꞉eamo ka꞉tomamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nanitabola, ka꞉lo naimano balida꞉mo a꞉imano igilo mula꞉ tanalo uimo, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ebe igilo mula꞉ tanalo a꞉ma꞉le a꞉modoboimiyata iyaiya epo bilibilinomono ololo apulo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iyo, a꞉imano igilo mula꞉ tanalo ebe wade alola, ebe alote Yua꞉piatamo a꞉imano ubi gabo eba awokaliminalo, a꞉imano Isalaela epatamo kawonomamo ba꞉pukuilamenamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ebene Simiyonote gudu Ya꞉sukono tanaloma꞉ kebe tabo ka꞉kiyawaiyale, Ma꞉liko Yausepeko iba꞉te ebe tabo olowite kawonomamo anoanoutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ebe tetelo Simiyonote Godoko naniya ebete ibi wadenomamo kowalubilinama꞉, ega꞉walo ebete guduno menoko Ma꞉litamo negiya, “Me gudu Ya꞉suko Godote ebe iyalo ka꞉mite elawiya, ebema꞉ ebete Isalaela epono magumulo ibino kubakuba tanalo ega꞉walo wadewade tanalo bilibilinomo kanagilamelelaemene. Iyo, ebeno okoli tanalote anoano tanaloma꞉ eda꞉te Godokono elawo kawokalimene, ebema꞉ epo epetapiate ebe tanalo umite ubia꞉ tabo gelate ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ibino kubakuba woki kawokalilamolema꞉na꞉. Ebe tetelo kawo temetemete a꞉ma꞉tamo pemaigate, gowelaono kiyoiyo gili keba kunula꞉ka꞉ ebe temetemete a꞉imano tepo magumu eba kunu kawamidamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ebe atu tetelo Godokono woki awokalimidawa kamiyale idite nokolinami, ebeno mailo A꞉natela, ebeno nabiwi Pa꞉nuwelatela, ebe A꞉sa gu lumagila. Me kamiyale ebe abelenomola. Dopamo ebete dubu lawete sebeni ulama okolite ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ebeno awite ebo a꞉iya, ebene ebete amolema꞉ eda꞉te ebe tetene wagilimite ebeno 84 ulama teta꞉mo pemaiga, ebete egela ega꞉walo idoko bilibilinomolo Godoko Amamateno Iya Motolo eba okolinalo ebe moto katepanakia꞉. Ebe tete geyageyanomolo ebete Godoko eba amamatenalo, tete epetapi bilibilinomolo bae naoa꞉no Godotamo towetowe tabo ebo genaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ebene Yausepeko Ma꞉liko iba꞉te Simiyonago tabo eba gelitalo, ebe atu tetenomolo A꞉nate pete gudu Ya꞉suko pumite kalakala tabo Godotamo ebo padipatiya. Ebema꞉ ebe tetene wagilimite, Yelusalema duliyomolo epo magumulo piyate ibino igilo mula꞉le tanalo maiga tete demakopelenamiya, iba꞉te Godokono Motamo da꞉pelamenakiya A꞉nate ibi bilibilinomatamo Ya꞉sukono tanaloma꞉ ebo kiyawaonaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ebene Ma꞉liko ega꞉walo Yausepeko iba꞉te Godokono totomu bilibilinomono iyaiya tanalo wadenomamo osiyodilolete, iba꞉te Ga꞉lili opono Nasalete duliyomolamo walo na꞉ka꞉tiya mabu ebe ibino duliyomolonomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ebolo gudu Ya꞉sute eba apelo elawoma꞉ ebo ediya, ega꞉walo ebete woki mulodawama꞉ eda꞉lo Godote ebeno nilakapo tanalamo ebe nowalubinami. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ya꞉sukono menokola nabiwila ibino tanalo ma kunula, ulama bilibilinomolo iba꞉te epo epetapiago Yelusalema kawo duliyomolamo tolamenakiya Yu epono Aduga꞉la Soliyomu ka꞉nosiyodiloma꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ebene Ya꞉sute 12 ulama tetema꞉ eba eda꞉lo iba꞉te ebe lawete walo na꞉ka꞉tolamiya ebe soliyomu baiamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ebene Soliyomuno egela dolopoligoiya iba꞉te Nasalete duliyomolamo walo na꞉ka꞉pelamiya, wiyasiya Ya꞉sute Yelusalemalo dolowagiliya ebeno menokola nabiwila, iba꞉te kiyatawaiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iba꞉te Ya꞉suko epago duliyomolamo toma꞉ gelate, ebe egela kapiyalo tonomo tote, ebene adimolo iba꞉te ebe ibino epagodolo ega꞉walo namutupiagodolo nowadinate ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ebe ka꞉numiniya꞉. Ebema꞉ egela idilo iba꞉te ebe wadiago Yelusalema kawo duliyomolamo walo ka꞉tote, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ebene netewa-kapiya egelalo iba꞉te ebe Godoko Amamateno Iya Motolo iyatulamepi dubago eba lutalo ebo numiya, ebete ibino tabo eba olowiolo ibino iyaiya iyatulame tanaloma꞉ ebo alateda꞉lenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ebe tetelo Ya꞉sute iba꞉go tabo eba kiyawaolo ibi tuputupu tabamo dowamilamenaki, ebema꞉ piyate ebeno tabo dolowiutiya ibi bilibilinomate kawonomamo anoanoutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ebema꞉ Ma꞉liko Yausepeko ibi netewapiate ebe da꞉numiya, kawiya nela꞉wa꞉ote menokote ebe naniya, “Gudu, a꞉ma꞉ me tanalo atamo beda꞉ma꞉ kosiyodilawia? A꞉imano nabiwila nala, ale a꞉ma꞉ tepo temetema꞉go wadinata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ya꞉sute wiyasiya iba꞉tamo negiya, “Mabu keleka꞉ la꞉le na me duliyomolono iyaiya motolo dowadina꞉witakama? Modobola la꞉ niyatawala꞉ na naimano Nabiwino Motolo ba꞉lutamo, na moto idilo lutama꞉ a꞉ka꞉modobomo!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iba꞉te wiyasiya ebe tabono magumu wadenomamo kelawiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ebe tetelo Ya꞉sute ebeno menokola nabiwila iba꞉go Nasalete duliyomolamo tote, ebolo eba nokolinalo ibino tabamo tuduwatanaki, ebene Ma꞉lite me iyaiya tanalo ebeno tepo magumamo alomote tete bilibilinomolo kawonomamo nemalagidilolenami. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ebema꞉ me tanalo nanitabola, Ya꞉sute mulo kimalagidilago eba apelo, Godoko ega꞉walo epo ebetamo nekalakalaonamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ebe tetelo Sisa Taibiliyasite 15 ulamalo opo kawonomono Kawo Elawodubunomoma꞉ eba eda꞉nalo, dubu epetapiate ebeno opopima꞉ ma kunu eda꞉onamiya, Poniyase Paeleteko Yudiya opono Kapela Elawodubula. Elodiko Ga꞉lili opono Kawo Elawodubula. Ebeno ekawi Pilipiko Ituliya opo ega꞉walo Ta꞉konaitasi opono Kawo Elawodubula. Ega꞉walo Laisaniyasiko A꞉bilini opono Kawo Elawodubula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ebe atu tetelo A꞉nasiko ega꞉walo Kayapasiko ibi netewapiate Godotamo kalimagono ikameopino Ununomo Watowatopima꞉ eda꞉onamiya, ebene Sekalayakono gudu Yoneko ebete bulu opolo eba okolinalo Godokono tabote ebetamo ebo piya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Iyo, ebete Yodane Kolomono opo kawonomamo tote Godokono tabo ma kunu na꞉kiyawaiya, “La꞉imano kubane olobila꞉wete obamo aduba꞉mida tanalo laema꞉ na꞉pelama꞉la꞉, ebene Godote la꞉imano kuba egebolelametate ka꞉dodolomatililaema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nanitabola, Godote dopamo ebeno woki awokalimidawa Aisayagodone Yonekono pe tanaloma꞉ ebeno Bukamo tabo ma kunu akuloliya, “Lumagite bulu opolo tabo ma kunu kawonomamo ka꞉pegemene, ‘Kawodawano gabo nosiyodiloma꞉la꞉, ebeno gabo na꞉tupugaima꞉la꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Godote me opono damela bolaliyao bilibilinomo ilatolete, damela unuunu kapatalulatolemene, iyo, ebete kalawikalawi gabo nanitabolo tuputupuilamolete, gabono damela gugu ilatolete ka꞉dilidililaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nanitabola, ebete epono igilo da꞉mula꞉lelaemene, ibi bilibilinomate ebe tanalo ebo kuima꞉na꞉!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ebene epo bilibilinomate Yonetamo na꞉pelamiya ebete ibi obamo kowaduba꞉midaolema꞉, wiyasiya ebete iba꞉tamo negiya, “La꞉ bu kalulata! La꞉ potele kanaletia obamo waduba꞉midaolema꞉ da꞉pelama꞉ema, ba꞉, Godokono kawo dowa tanalonomote la꞉tamo a꞉ka꞉pemene? Ao, ka꞉pemene! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","La꞉imano tepo magumu iyakobi da꞉midila꞉ema, modobola la꞉ la꞉imano nanitabo tanalo awokalima꞉ wadewade tanalo nosiyodilola꞉la꞉. La꞉ a꞉ka꞉tuwa꞉ la꞉tamo mako tabo gela akowagilima꞉la꞉, ‘A modobola mabu A꞉ibalayamako ebe aimano ewono nabiwila.’ Ao, la꞉ a꞉ka꞉modobomata! Na la꞉tamo nani tabo gemo, Godogodolo elawo bitana ebete me nokolamo A꞉ibalayamakono gudi kosiyodilolema꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ebema꞉ ka꞉lo Godote ebeno kabi a꞉li, noloa꞉ da꞉imi kewa bilibilinomo ebete lute elamo kiyalekemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Epate ebe tanalo olowite Yoneko nalatediya, “A Godokono dowa odiyoboma꞉ beda꞉ tanalo na꞉kosiyodiloma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ebete eba wiyalo negiya, “Modobola kaliku netewagodawate kalikua꞉dawa idi kowalubimene, ega꞉walo baeagodawate baea꞉dawa kowalubimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ebene ta꞉kese mani elemasigilo uwatepi dubu epetapi iba꞉te obamo waduba꞉midaolema꞉ da꞉pelamiya, iba꞉te ebe napalatediya, “Iyatulamedawa, a beda꞉ tanalo na꞉kosiyodiloma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ebete ibi nanaliya, “La꞉le ta꞉kese mani uwate tetelo a꞉da꞉ gabodo kawonomamo akouwatenakala꞉ la꞉ a꞉ka꞉tuwa꞉ la꞉ walubilima꞉, wiyasiya gabamani dubate degelanaka ebe modobolo nuwatenakiyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ebene gowelaopi epetapiate Yoneko nalatediya, “A keba kunula꞉ka꞉? A beda꞉ tanalo na꞉kosiyodiloma꞉?” Ebene ebete iba꞉tamo negiya, “La꞉le epo epetapino mani elawo gabodo o a꞉da꞉ gabodo akouwata꞉la꞉, ega꞉walo la꞉imano tabo gela magumulo epo epetapi akokubailama꞉la꞉, ega꞉walo la꞉imano woko wiya delawa꞉wenakoma ubia꞉ tabo gela꞉no kalakalago nuwatenakiyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Epate Yonekono tanalo eba malagidilolo, iba꞉te kalakalaolo nemalagidiliya Yoneko da꞉ Godokono Alibodawa Kelisotela꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ebene Yonete iba꞉tamo negiya, “Nale la꞉ obamo waduba꞉midaolemata, wiyasiya lumagi idite naimano walogabo apune ba꞉pena. Ebeno elawo kawonomola, naimano elawo nodoliona, ebema꞉ na wadenoa꞉ nale ebeno agowa ukulaolema꞉. Nanitabola, ebete la꞉ Godokono Uliyanamo ega꞉walo ebeno elamo ka꞉powaduba꞉midaolema꞉ta, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","iyo, ebete witi-laisono nonoka balamo alomono inamabu elawi, ebene ebete witi-laiso naono ebeno moto guamo eba alomolo nonoka elamo ebo kiyalekemene, ebe elate uwomua꞉ tetelo nowaena, ka꞉egana꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nanitabola, Yonete Godokono Wade Tabo da꞉kiyawaonaki, ebete iyaiya tanalo bilibilinomo iyatulamolenaki epate ibino woki iyakobi ka꞉midilima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ebene egela idilo Yonete Kawo Elawodubu Elodiko kawiya aniya, mabu ebete ebeno ekawino kamiyale Elodiyasiko pilolo lawiya ega꞉walo ebete kuba tanalo epetapi bilibilinomo osiyodilolenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ebe tetelo Elodite kuba tanalo kawonomo idi ma kunu kosiyodiliya, ebete Yoneko idoko motamo gito iyatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Elodite ebe idoko motamo iyatia꞉no, dopamo Yonete epo bilibilinomo obamo owaduba꞉midaoliya, Ya꞉suko ebalata. Ebema꞉ Ya꞉sute obamo aduba꞉mida tanalo lawete, Godotamo kalakala tabo eba kiyawautalo Godote ebeno Unu Duliyomolo ebo a꞉iyamidiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ebene Godokono Uliyanate bigo olamu ebe unamo eba piwisigalo, tabote Unu Duliyomolone ma kunu piwisigiya, “A꞉ma꞉ naimano kapiya Gudunomolata. Na a꞉ma꞉tamo nekalakalitamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ya꞉sute 30 ulamama꞉ eba eda꞉lo ebete ebeno kawo woko ebo wagilimiya, ebene ebeno mabu epono mailono tanalo ma kunula. Epate ibino wokilo ebe Yausepekono guduma꞉ gelanamiya, me Yausepeko Ilaikono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ilaiko Mata꞉takono gudula. Mata꞉tako Libaikono gudula. Libaiko Melekaikono gudula. Melekaiko Yanaikono gudula. Yanaiko Yausepekono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yausepeko Mata꞉tayasikono gudula. Mata꞉tayasiko A꞉imosokono gudula. A꞉imosoko Na꞉iumakono gudula. Na꞉iumako Esalaikono gudula. Esalaiko Nagaikono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiko Maa꞉takono gudula. Maa꞉tako Mata꞉tayasikono gudula. Mata꞉tayasiko Sema꞉inikono gudula. Sema꞉iniko Yausekekono gudula. Yausekeko Yaudakono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yaudako Yowananakono gudula. Yowananako Lisakono gudula. Lisako Selababelakono gudula. Selababelako Siyatiyelakono gudula. Siyatiyelako Nelaikono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nelaiko Melekikono gudula. Melekiko Adaikono gudula. Adaiko Kosamakono gudula. Kosamako Elamadamakono gudula. Elamadamako Eyakono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eyako Yosuwakono gudula. Yosuwako Eliyesakono gudula. Eliyesako Yolimikono gudula. Yolimiko Mata꞉takono gudula. Mata꞉tako Libaikono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libaiko Simiyonokono gudula. Simiyonoko Yudakono gudula. Yudako Yausepekono gudula. Yausepeko Yaonamakono gudula. Yaonamako Elayakimikono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elayakimiko Meleyakono gudula. Meleyako Menakono gudula. Menako Mata꞉taikono gudula. Mata꞉taiko Na꞉itanakono gudula. Na꞉itanako Da꞉ibidikono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Da꞉ibidiko Yesikono gudula. Yesiko Obedakono gudula. Obedako Bowasekono gudula. Bowaseko Samonokono gudula. Samonoko Nasonakono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasonako Aminadabakono gudula. Aminadabako Adaminakono gudula. Adaminako Anikono gudula. Aniko Esalonakono gudula. Esalonako Pelesekono gudula. Peleseko Yudakono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yudako Ya꞉ikobokono gudula. Ya꞉ikoboko Aisa꞉kekono gudula. Aisa꞉keko A꞉ibalayamakono gudula. A꞉ibalayamako Telakono gudula. Telako Neyokono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neyoko Selugukono gudula. Seluguko Liyukono gudula. Liyuko Pelegekono gudula. Pelegeko Ibakono gudula. Ibako Silakono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Silako Ka꞉inanekono gudula. Ka꞉inaneko Apasa꞉dakono gudula. Apasa꞉dako Semakono gudula. Semako Nowakono gudula. Nowako La꞉imekakono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","La꞉imekako Metusalakono gudula. Metusalako Inokokono gudula. Inokoko Yeledikono gudula. Yelediko Mayalalelakono gudula. Mayalalelako Ka꞉inanekono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ka꞉inaneko Inosokono gudula. Inosoko Setakono gudula. Setako A꞉da꞉mekono gudula. A꞉da꞉meko Godokono gudula. Ebema꞉ me Ya꞉sukono mabu epono tanalono uwomula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ebene Godokono Uliyanate Ya꞉sukono tepo magumu tabokaimite, Yodane Kolomone eba magatalo ebete bulu opamo gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ebene Ya꞉sute bulu opolo 40 egelamo eba nokolilo Saitanate ebe kuba gabamo kowabuga꞉tama꞉ ebetamo ebo pemaigiya. Ebe tete geyageyanomolo Ya꞉sute bae kenanakia꞉, ebema꞉ ebe tete dolopoligiya ebete bae kape tanalo ebo iyatawiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ebene Saitanate ebe naniya, “A꞉ma꞉ Godokono nani Guduma꞉ deda꞉wena, me nokola baema꞉ na꞉mida꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ya꞉sute ebeno tabo eba wiyalo negiya, “Godokono Bukalo tabo ma kunu itana, ‘Lumagite me opono bae kapiyalo a꞉kigilonamene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ebene Saitanate Ya꞉suko unamo magatate me opo kawonomono iyaiya opo kawokawo eba niyatumiolo, iba꞉te ebe tetenomolo ebe inamabu bilibilinomo ebo ulamoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Saitanate ebetamo negiya, “Me inamabu bilibilinomo ega꞉walo elawo kawonomo nale a꞉ma꞉tamo kikaemamota. Nanitabola, me opono inamabu bilibilinomo Godote natamo ikanamoniya, ebe mabuma꞉ nale kebe lumagitamo ikaema꞉ ubi diyatimo nagodolo elawo bitana ebetamo kikameoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iyo, a꞉ma꞉le na namamanatena꞉, ebene me inamabu bilibilinomo a꞉ma꞉le kuwatema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Wiyasiya Ya꞉sute ebeno tabo eba wiyalo negiya, “Godokono Bukalo tabo ma kunu itana, ‘A꞉ma꞉ a꞉imano Kawodawa Godoko amamatelo ebe kapiyatamo na꞉tuduwatanakiye.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ebene Saitanate ebe Yelusalema kawo duliyomolamo magatate Godoko Amamateno Iya Motono auba unamo nadipite ebe ebo naniya, “A꞉ma꞉ Godokono nani Guduma꞉ deda꞉wena, me motone opamo na꞉nepatega, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","mabu Godokono Bukalo tabo ma kunu itana, ‘Godote ebeno nopopi kapalibolemene iba꞉te a꞉ma꞉ wadenomamo ka꞉powalubitama꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","iyo, iba꞉te ibino kotamo a꞉ma꞉ ka꞉pelaema꞉ta, ebema꞉ a꞉ma꞉le nokolalo agowa a꞉ka꞉nukamidaemene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Wiyasiya Ya꞉sute ebetamo nowamiya, “Ao, nale ebe kuba tanalo a꞉kosiyodilomo, mabu Godokono Bukalo tabo idi ma kunu itana, ‘Opo lumagite Kawodawa Godoko wabudima꞉ akowagela꞉la꞉.’ Iyo, ebe mabuma꞉ me opo lumagite ebeno daedale wokiamo tanalo idi dosiyodilomene, ebete akomalagidilala꞉ Godote ebeno igilo gito ka꞉pa꞉mula꞉ema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ebene Saitanakono kuba gabamo wabuga꞉ta tanalo bilibilinomo dolopoligoiya, ebete Ya꞉suko tete da꞉pesamo ebo atepiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ebe tetelo Ya꞉sute Godokono Uliyanano elawago Ga꞉lili opamo walo na꞉ka꞉tiya, ebene ebe opo kawonomolo dilukulionamiya ebe epo bilibilinomate Ya꞉sukono tanaloma꞉ tabo ebo na꞉kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ebete ebe Yu epono balidi ibilamole motolo ibi diyatulamenaki, ebe mabuma꞉ ibi bilibilinomate ebe kawonomamo moionakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Egela idilo Ya꞉sute ebeno okoli duliyomolo Nasaleta꞉mo tiya, ebene ebete Yu epono wokoa꞉ talena egelalo dopamo keba kunu kosiyodilonakile, ebete ebe egelalo atu tanalo ka꞉nosiyodiliya, iyo, ebete epono balidi ibilamole motamo nodolote Godokono Bukano tabo ka꞉la꞉miolema꞉ ebo maigiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ebene iba꞉te Aisaya buka mokopi ebetamo ikamete, ebete paeamidate buka ka꞉la꞉miole ma kunu ebo wagilimiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Godokono Uliyanate nagodolo bokolina, mabu ebete na elaweniya, nale nigologololo dilukuliona ebe epatamo Godokono Wade Tabo katama꞉. “Ebete na apaliboniya idoko motolo dilukuliona ebe epatamo, ebema꞉ nale ibi ka꞉kiyawaolaemamo, tete ebe na꞉pe ibi idoko motone kowagailima꞉, ega꞉walo na balidi tamiolame epo kanalemamo, ibino balidi ka꞉meleoma꞉. “Iyo, nale mibomibago dowapata꞉lamena ebe epo tutunomoma꞉ ka꞉midilimamo, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ega꞉walo Kawodawa Godote ibino igilo da꞉mula꞉lelaemene, nale ibi me tabo kanalemamo, ebe tanalo na꞉pe.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ebene buka ka꞉la꞉miole dolopoligiya Ya꞉sute buka walo ka꞉mokopite wokodawatamo ikamete epo iyatulaema꞉ ibino ololo apulo gito okoliya. Ebe tetelo balidi ibilamole moto gulo da꞉pola꞉niya ebe epate Ya꞉suko wadenomamo umiutiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ebema꞉ ebete iba꞉tamo negiya, “Ka꞉lo nale me buka apuno tabo deka꞉la꞉miolemo, ebe tetenomolo ebeno nanitabo tanalote la꞉tamo ebe apawokala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ebene ebete Godokono tabo iba꞉tamo eba kiyawautalo ibi bilibilinomate nemalagidilutiya, “Ya꞉suko ebe wade lumaginomola,” ega꞉walo iba꞉te ebeno tabone kebe tabo kolowiye ebe wadewade taboma꞉ anoanolo negelitiya, “Me ebe Yausepekono gudula, ebeno mulo keba kunula꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ebene ebete iba꞉tamo negiya, “Na la꞉tamo nani tabo gemo. Epate muloma꞉ degelanaka, walone la꞉le ebako tabo natamo ma kunu kegelamamota, ‘A꞉ma꞉ nani doketama꞉ deda꞉wena, modobola a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉ma꞉ wadekobi na꞉mida꞉.’ Ega꞉walo la꞉le na kananemamota, ‘A꞉ma꞉le Kapeniyama duliyomololo da꞉nosiyodilola꞉wia ale ebe anoano tanalo olowima꞉, ebema꞉ ka꞉lo wiyasiya a꞉imano duliyomolonomolo ebako tanalo na꞉kosiyodilola꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ya꞉sute iba꞉tamo walo na꞉kegiya, “Na la꞉tamo nani tabo gemo, Godokono woki awokalimidawa ebeno duliyomolo epate ebe ubia꞉noma꞉ eda꞉ote a꞉kelaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ebema꞉ la꞉ naimano nani tabo nolowiala꞉. Elayate dokolinami ebe tetelo netewa-kapiya ulamalo ulamate kowonakia꞉, opo kawonomolo nao inamabute ebema꞉ olopoligiya. Ebe tetelo amoleamole bilibilinomate Isalaela opolo nigologololo ilukulionamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","wiyasiya Godote Elayako ebe Yu epono amoleamola꞉tamo kanalibiya꞉. Ao, ebete ebe Saidono opono Sa꞉lepata duliyomolamo nalibiya, ebolo dokolinami ebe amole kapiyanomo ka꞉nowalubima꞉. Ebe kamiyale Yu lumagia꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ega꞉walo me tanalo idila. Godokono woki awokalimidawa idi Elaisakono tetelo Isalaela opolo kukulakukulago dubu bilibilinomate nilukulionamiya, wiyasiya ibi magumulo Godote dubu idi wadekobi ka꞉midiya꞉, Siliya opodawa idi Na꞉imanako kapiya wadekobi midiya. Ebe dubu Yu lumagia꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ebene Yu epono balidi ibilamole motolo da꞉pola꞉niya, ibi bilibilinomate ebe tabo dolowiya kawonomamo dowaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ebema꞉ iba꞉te maimiote Ya꞉suko lawete duliyomolo magumune elawamo ebo powolukiya, mabu ibi ubila ebe damela unu ida꞉mo magatate maboele damelane ka꞉pa꞉na꞉mupiamidama꞉, iyo, mako damela Nasalete duliyomolo niyakabolo itanami. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ebe tetelo Ya꞉sute wiyasiya ebe epo bilibilinomono tetedo tote ebeno to gabodo gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ebene Ya꞉sute Ga꞉lili opono Kapeniyama duliyomolamo tote, Yu epono wokoa꞉ talena egelalo epo da꞉niyatulamiti, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","iba꞉te ebeno tabamo nanoanoutiya mabu ebete tabo Godokono elawamo kiyawauti. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ebe tetelo ibino balidi ibilamole moto gulo kuba uliyanagono dubute ebolo na꞉luti, ebene ebete geatepaolo kawonomamo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oe! Ya꞉su Nasalete duliyomolodawa, a꞉ma꞉ atamo beda꞉ tanalo na꞉kosiyodilaemene? A꞉ma꞉ a kubaiaema꞉ ka꞉pa꞉wa꞉? Eiye, na iyatawala a꞉imano tanalo, a꞉ma꞉ ebe Godokono Wade-talena Dawalata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ya꞉sute wiyasiya ebe kawiya naniya, “A꞉ma꞉ kodakodawete, ebegodone na꞉nemaiga!” Ebene kuba uliyanate epono ololo apulo ebe dubu opamo ba꞉idilote ebegodone ebo penemaigiya, wiyasiya ebetamo kuba tanalo idi kosiyodiliya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ebema꞉ ebe epo bilibilinomate anoanolo idite iditamo genaki, idite iditamo genaki, ma kunu wagelitiya, “Me tabono elawo keba kunula꞉ka꞉? Me dubuno elawo ega꞉walo a꞉di kawonomola! Numa꞉la꞉, kubakuba uliyanate ebeno tabo olowite iyabaiamo alautia!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ebene Ya꞉sukono woko osiyodilo tabote ebe opo kawonomamo gito tiya, iyo, piyate ebolo dilukulionamiya ibi bilibilinomate ebeno tanaloma꞉ tabo ebo na꞉kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ebene Ya꞉sute Yu epono balidi ibilamole motone pemaigate Saimonokono motamo gito tiya. Ebolo Saimonokono moto lapino ape elanomo gabugabute umiti, ebene ebeno tanaloma꞉ epate Ya꞉suko ebo aniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ebema꞉ Ya꞉sute tote ebeno wata baiamo nutite ebe gabugabute ebe katepama꞉ daniya, ebe tetenomolo gabugabute ebegodone eba olopoligolo ebete maigate ibi mabuma꞉ bae okalimi woko ebo wagilimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ebe tetelo egelate da꞉niwisigani, piyate ebe duliyomololo iyaiya temetema꞉go da꞉pola꞉niya ibino namutupiate ibi bilibilinomo Ya꞉sutamo ebo magaeleniya, ebene ebete ebeno koto iba꞉tamo watiolelamenalo ibi bilibilinomo wadekobi ebo midioleni. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ega꞉walo ebete kubakuba uliyana kawiya danaleni, iba꞉te epo epetapi bilibilinomagodone eba nemaimionalo gelatepaolo tabo ma kunu gelaniya, “Ya꞉su, a꞉ma꞉ ebe Godokono Gudulata!” Nanitabola, ebe kubakuba uliyana iyatawala Ya꞉suko ebe Godokono Alibodawa Kelisotela, wiyasiya ebete ibi kawiya eba analenalo, iba꞉te ebeno tanalo kawokalima꞉ ebete tabo gela talena ebo iyatilameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ebene egelate eba waloutalo Ya꞉sute ebe duliyomolone nemaigate diyamoa꞉ opamo na꞉tiya, ebema꞉ epate ebe wadiago tolamete ebo numiya, mabu ibi ubia꞉nola Ya꞉sute ibi miyapama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wiyasiya Ya꞉sute iba꞉tamo negiya, “Modobola na duliyomolo epetapiamo tote, Godote Kawo Elawodawama꞉ deda꞉na ebe tanalono Wade Tabo ka꞉na꞉kiyawaomamo, mabu Godote na ebema꞉ paliboniya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ebene Ya꞉sute ebe opono duliyomolo bilibilinomamo tonaki Yu epono balidi ibilamole moto gulo Godokono tabo ebo na꞉kiyawaonaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tete idilo Ya꞉sute Genasalete Paka꞉ balalo eba utitalo epo bilibilinomate ebetamo mupuma꞉tiua꞉go tolamitiya Godokono tabo olowioma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ebene ebete pe netewa paka꞉ balalo pola꞉nalo ulamiya, namo uwatolepi dubate ebe pe iyalo miyapate iba꞉te ibino kamau ukulaolitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ebema꞉ ibi magumulo Ya꞉sute dubu idino peamo oliya, ebe dubuno mailo Saimonotela. Ebene Ya꞉sute ebe daniya ebete ebeno pe potone kela꞉mo kalima꞉tepama꞉, ebete ebe tanalo osiyodilote Ya꞉sute peamo okolite Godokono tabo epo ebo iyatulamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ebene ebete Godokono tabo kiyawao dolopoligiya Saimonoko ebo aniya, “Pe kela꞉mo kulukulu teta꞉mo walo kalima꞉tepawete, a꞉ma꞉ ega꞉walo a꞉imano namutupi la꞉imano kamau obamo nowaduba꞉la꞉ namo kuwatola꞉ema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wiyasiya Saimonote ebetamo eba wiyalo negiya, “Kawo Iyatulamedawa, a idoko geyageyanomolo nipo odobinakama꞉, namo idi kelawenaka꞉. Wiyasiya kuba꞉, mabu a꞉ma꞉le na danana꞉wa꞉, ebema꞉ nale a꞉imano tabamo tuduwatalo na kamau obamo kowadubitemamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ebema꞉ ebete wokopi epetapiago ebe tanalo dosiyodiliya, namo bilibilinomate taote kamau tatalila teteoma꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ebene iba꞉te ibino namutupi epetapi pe idilo da꞉pola꞉niya kotamo na꞉midaolamiya iba꞉te ibi ka꞉powalubilima꞉. Ebema꞉ iba꞉te pelamete ebe pe netewamo namo da꞉powiyaoliya, pete tatalila obamo ololuoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ebene Saimonote ebe tanalo umite kawonomamo danoaniya, ebete Ya꞉sukono agowa mabuamo pete pupamo pokolite ebo pegiya, “Kawodawa, a꞉ma꞉ na atepana꞉wete na꞉toa, mabu na kuba lumagila!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Wiyasiya Ya꞉sute ebetamo negiya, “Akotoletola꞉la꞉, a꞉ma꞉ dopamo namo uwatedawama꞉ eda꞉namiata, wiyasiya me tetene wagilimite a꞉ma꞉ epo uwatedawalata.” Ebe tetelo Saimonago namo uwatole mani woko dosiyodilonamiya, ebe dubu Ya꞉imesiko ega꞉walo Yoneko, ibi netewapi Sebedikono gudila. Ebene ibi ega꞉walo wokopi epetapi ebolo da꞉pola꞉niya, iba꞉te ebe namo bilibilinomo ulamete atumu nakanoanoutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ebe mabuma꞉ Saimonoko ega꞉walo me dubu netewa epetapi iba꞉te ibino pe netewa pa꞉iliolete ibino woko inamabu bilibilinomo miyapate Ya꞉suko ebo waloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tete idilo Ya꞉sute duliyomolo idilo okoliti, ebe duliyomololo kuba kukulakukulago dubunomote nokolinami. Ebene ebete Ya꞉suko umite ebetamo pete ebeno ololo opamo piyatite towetowe tabo na꞉pegiya, “Kawodawa, a꞉imano ubi ditametana, a꞉ma꞉le na wadekobi ka꞉midinima꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ya꞉sute ebeno koto uwamidate ebe eba ologilo ebetamo negiya, “Na ubila, a꞉ma꞉ wadekobi nolowia!” ebema꞉ ebe tetenomolo kukulakukula temetemete ebegodone nolopoligiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ebene Ya꞉sute ebe kawiya eba analo negiya, “A꞉ma꞉ naimano tanaloma꞉ epo akoanala꞉la꞉. Modobola a꞉ma꞉ wiyasiya me tetenomolo toawete a꞉imano ape Godotamo kalimagono ikameodawatamo nanawokalimiye, ebene kalimagono nilakapo inamabu Godotamo akona꞉nikamiye, Mosesete da꞉kiyawaiya eba kunu. Ebe tanalote epo kiyatulaemene a꞉imano temetemete olopoligi.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wiyasiya Ya꞉sute kebe wadewade tanalo kosiyodilolenakile ebe tabote ebe opo kawonomamo tiya, ebema꞉ epo bilibilinomate ebetamo napaladabutiya ebeno tabo kolowioma꞉ ega꞉walo ebete ibino temetema꞉gopi wadekobi ka꞉midiolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ebete wiyasiya ibi miyapate bulu opamo a꞉ka꞉tuwa꞉ ebo tiya, ebe diyamoa꞉ opolo Godago tabo ka꞉negelama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Egela idilo Ya꞉sute epo eba iyatulamitalo, Pa꞉lisi tanebapi ega꞉walo Godokono Totomu iyatulamepi ibi epetapiate Ga꞉lili opono iyaiya duliyomolone pelamoliya, ebene epetapiate atumu Yudiya opone ega꞉walo Yelusalema kawo duliyomolone pelamolete ebo pepola꞉niya. Ebe tetelo Kawodawa Godokono elawote Ya꞉sugodolo nitani ebete temetema꞉gopi wadekobi ka꞉midiolema꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ebene dubu epetapiate ape kodakoda temetema꞉go dubu patapatago aguwaiya. Iba꞉te moto guamo odoloma꞉ gabo waditiya ibino namutudawa Ya꞉sukono agowa mabuamo kanadilatima꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","wiyasiya epo bilibilinomola ebema꞉ iba꞉te gabo idi kumiya꞉. Ebe mabuma꞉ iba꞉te moto unamo nodolote, Ya꞉sute kebo kutitiyale iba꞉te ebe moto unu anabulimite ebe dubu patapatago ebana nuwamidiya Ya꞉sutamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ya꞉sute ibino nanitabokobi midi tanalo umilamete dubutamo negiya, “Namutudawa, Godote a꞉imano kuba egebolema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wiyasiya Godokono Totomu tabo iyatulamepi ega꞉walo Pa꞉lisi tanebapi dubu iba꞉te ibino tepo magumulo ma kunu malagidilutiya, “Me dubu amama kawodawanomola, Godokono ololo apulo kuba tabo beda꞉ma꞉ kegele? Kuba egeboledawa potelela꞉ka꞉? Ebe Godoko kapiyatela!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iba꞉te ibino tepo magumulo degeliya Ya꞉sute iyatawate iba꞉tamo negiya, “Mabu keleka꞉ la꞉imano tepo magumulo me tanalo demalagidilola꞉witama? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Me tabo kodakodala꞉ka꞉ nale gema꞉, ‘Godote a꞉imano kuba egebolemetate a꞉dodolomatilima꞉ta?’ O me tabo idi gema꞉ kodakodala꞉ka꞉, ‘A꞉ma꞉ maigawete, na꞉toa?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ebema꞉ nale la꞉ kiyatulaemamota, na Epono Naniwigodolo elawo bitana me opo kawonomolo epono kuba egebolelamete ka꞉dodolomatililaema꞉.” Ebene ebete temetema꞉go dubutamo negiya, “Nale a꞉ma꞉ anamata, a꞉ma꞉ maigawete, a꞉imano keta mokopiamidawete motamo na꞉toa!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ebe tetenomolo ebe dubute ibino ololo apulo maigate ebeno keta lawete Godokono mailo unamo eba adipatelo ebeno motamo gito tiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ebema꞉ ebe epo bilibilinomate kawonomamo anoanoutiya. Iba꞉te Godokono mailo unamo eba adipatelo toletoleolo negeliya, “A ka꞉lo egelalo anoano tanalo nanitabonomolo ulaema꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Me tanalo dolopoligiya Ya꞉sute moto gune nemaigate dubu idi Libaiko ebo numiya, ebe ta꞉kese uwatedawala, ebete ebeno woko bailo okoliti. Ebe tetelo Ya꞉sute ebetamo negiya, “A꞉ma꞉ na nowaloma꞉ena꞉,” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ebene ebete maigate ebeno woko inamabu bilibilinomo miyapate Ya꞉suko ebo waloma꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ebene tete da꞉peso da꞉petiya Libaite ebeno motolo Ya꞉suko mabuma꞉ kawo soliyomunomo osiyodiliya. Ebe tetelo ta꞉kese uwatepi dubu epetapi ega꞉walo epo bilibilinomo epetapi iba꞉te Ya꞉suago soliyomu bae nautiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ebene Pa꞉lisi tanebapi ega꞉walo ibino totomu tabo iyatulamepi ibi epetapiate Ya꞉suko waloma꞉tapi kawiya nanaliya, “Mabu keleka꞉ la꞉le ta꞉kese mani elemasigilo uwatepi ega꞉walo Godokono Totomu Tabo uwatea꞉ epago da꞉imi obo niawete iba꞉go bae denawenakoma?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Wiyasiya Ya꞉sute ebe tabo olowite iba꞉tamo negiya, “Wadewade epate doketatamo a꞉ka꞉tolaema꞉na꞉, gabugabuagopiate ka꞉tolaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iyo, piyate a꞉ka꞉tuwa꞉ degelana, ‘A wadewade epola,’ na ebakobako epo uwatema꞉ ka꞉piya꞉. Na wiyasiya kubakuba epo kapiya uwatema꞉ piyamo, iba꞉te ibino iyaiya kuba osiyodilole tanalone kolobila꞉ma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ebene epo epetapiate Ya꞉sutamo negeliya, “Yoneko waloma꞉tapi ega꞉walo Pa꞉lisi tanebapino waloma꞉talepi iba꞉te iyaiya tetelo bae naoa꞉no Godotamo towetowe tabo ebo gelanaka, wiyasiya a꞉ma꞉ waloma꞉tapiate ma kunu ka꞉pola꞉nanakoa꞉. Iba꞉te tete bilibilinomolo elawo da꞉imi obo niote bae ebo naonaka.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ya꞉sute iba꞉tamo negiya, “Dubute kamiyale daidimene, ebe tetelo ebeno namutupiate soliyomu bailo baea꞉no gito ba꞉ka꞉pola꞉nama꞉na꞉? Ao, modoboa꞉! Iba꞉te eba꞉go soliyomu bae kapimiya kenaoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wiyasiya kamiyale oli aidi dubute ebeno kamiyale duliyomolo ida꞉mo magata tete na꞉pe, nanitabola, ebe egelalo ebeno namutupiate ibino tepo temeteme tanaloma꞉ bae naoa꞉no ka꞉pola꞉nama꞉na꞉. Ebema꞉ numa꞉la꞉, me tete ebe la꞉imano kalakalago bae nao tetela mabu nale la꞉go bokolinamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ebene Ya꞉sute iba꞉tamo me iyatulame oi kiyawaolamiya, “Lumagite oli kaliku itamidate tagala kalikuno bolegala꞉mo a꞉kowaluomene. Ebete ma kunu dosiyodilomene oli kalikute tagala kalikago a꞉ka꞉modobomene, walo ka꞉ka꞉bolegalemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Atu gabodo lumagite tagala gautu-goeo tama kalila꞉mo oli da꞉imi obo akalatemene, mabu oli da꞉imi obote tagala gautu-goeo tama kalili ka꞉na꞉ta꞉pulaemene, ebene da꞉imi obote opamo ka꞉ka꞉liyaote da꞉imi obo ega꞉walo kalili ibi netewate kapiya tetelo ka꞉kubakubaoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Me mabuma꞉ modobola iyatawadawate oli da꞉imi obo olioli tama kalili kapiyamo nalateonakomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ega꞉walo me tanalo idila. Lumagite tagala da꞉imi obo da꞉ninako ebete walone tetelo oli da꞉imi obo nima꞉ ubia꞉noma꞉ keda꞉mene mabu ebete begenakomene, ‘Tagala da꞉imi obo golanomola,’ wiyasiya ebako lumagi iyatawa꞉ oli da꞉imi obono wade gola tanalo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yu epono wokoa꞉ talena egela idilo Ya꞉sute ebe waloma꞉tapiago kono pali magumudo eba petolamenatolo, ebe waloma꞉tapiate kono kapiyakapiya kubakubadopo nowakalamite iba꞉te kenaoma꞉ tama ebo welamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ebema꞉ Pa꞉lisi tanebapi epetapiate Ya꞉sutamo negeliya, “Numa꞉, a꞉ma꞉ waloma꞉tapiate aimano totomu tabamo ka꞉tudila꞉oa꞉. Iba꞉te wokoa꞉ talena egela beda꞉ma꞉ kadikanalite?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ebene Ya꞉sute iba꞉tamo eba wiyalo negiya, “Modobola Godote ebeno Bukamo dakuloliya, la꞉ ebe tanalo nemalagidilala꞉. Da꞉ibiditamo kuba tete da꞉piya, ebete ebeno wapata꞉lamepiago bae kapete dulamiti, ebene ebete beda꞉ tanalo kosiyodiliyale? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ebete Godokono Motamo nodolote, ebe Motono wokopiate Godotamo dalomonakiya ebe talena bae ebete a꞉nenaiya. Numa꞉la꞉, aimano totomu tabote a niyatuamena Godotamo kalimagono ikameopiate ebe bae a꞉ka꞉tuwa꞉ naonaka, epo epetapiate nao talenala. Wiyasiya Da꞉ibidite ebe bae naote eba꞉go wapata꞉lamepiatamo dikalamoliya, Godote ebe tanalo kubama꞉ kegiya꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ebema꞉ Ya꞉sute iba꞉tamo negiya, “Nanitabola, na Epono Naniwite wokoa꞉ talena egela namutudawama꞉ eda꞉namo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wokoa꞉ talena egela idilo Ya꞉sute Yu epono balidi ibilamole moto guamo nodolote epo eba niyatulamitalo, tumudi apu koto a꞉eme dubute ebolo nokoliti. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ebene Pa꞉lisi tanebapi ega꞉walo Godokono Totomu iyatulamepi ibi epetapiate Ya꞉suko balidi kodakodamo umitiya, ebete wokoa꞉ talena egelalo ebe dubu wadekobi da꞉ba꞉midimene, iyo, ibi ubila Ya꞉sute ebe tanalo eba osiyodilolo kubama꞉ ebo kegelama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wiyasiya Ya꞉sute iyatawiya iba꞉te ibino tepo magumulo beda꞉ tanalo kemalagidilolitiye, ebema꞉ ebete ebe dubutamo negiya, “A꞉ma꞉ maigawete dopo apuamo na꞉pa꞉,” ebene ebe dubute maigate dopo apuamo pete gito putiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ebene Ya꞉sute iba꞉tamo negiya, “Nale la꞉ alateda꞉lemata, aimano totomu tabote kebe talena kiyatuamenale? Ale wokoa꞉ talena egelalo wade tanalo o kuba tanalo ba꞉kosiyodiloma꞉? Epo wadekobi ba꞉ka꞉midilima꞉ o ba꞉ka꞉kubailaema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ebe tetelo Ya꞉sute ibi bilibilinomo eba pulamolenatolo ebe dubutamo negiya, “A꞉imano koto nuwamida,” ebene ebete koto duwamidiya ebeno kotote wadekobi ebo olowiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ebe mabuma꞉ Pa꞉lisi tanebapiate kawonomamo dowaolo ibi magumulo tabo ebo geliya, “A me dubu Ya꞉suko keba kunu nakamitima꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ebe idokolo Ya꞉sute Godago tabo gelanama꞉ damela unu ida꞉mo nodoloni, ebema꞉ ebete idoko geyageyanomolo Godago tabo eba gelanalo egelate ebo powaloiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ebene egelate da꞉pemaigiya ebete ebeno waloma꞉tapi ebetamo ka꞉la꞉mite, ibi magumulo 12 dubu eba uwatelo ibi nanaliya, “La꞉ naimano alibolepilata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ebema꞉ Ya꞉sute 12 dubu duwatiya, me ibino mailola. Saimonoko Ya꞉sute ebetamo Pita mailo idi ikamiya, ega꞉walo ebeno ekawi A꞉nduluko. Ya꞉imesiko ega꞉walo Yoneko, Pilipiko ega꞉walo Batolomuko. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ma꞉tiyuko ega꞉walo Tomasiko, A꞉lapiyasikono gudu Ya꞉imesiko ega꞉walo Saimonoko. Me Saimono idila epate dopamo negelanakiya, ebete kapela Loma gabamani epago gowelaodawama꞉ eda꞉nami. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ega꞉walo Ya꞉sute dubu epetapi netewa kuwatiya, Ya꞉imesikono gudu Yudasiko ega꞉walo Keliyota duliyomolodawa Yudasiko, walone tetelo me walogabo dubute Ya꞉suko anakapumipi walubiliya ebe kelaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ebene Ya꞉sute ebe waloma꞉tapiago unu damelane apotame opo ida꞉mo da꞉niwitiya, ebe tetelo waloma꞉tapi epetapi ega꞉walo iyaiya epo bilibilinomate iba꞉go ebo palugiya. Ibi epetapiate Yelusalema kawo duliyomolone ega꞉walo Yudiya opono duliyomolo epetapine pelamiya, ega꞉walo ibi epetapiate kewa꞉ kolomo bala apune ka꞉pelamiya, ibi Taya kawo duliyomololo ega꞉walo Saidono kawo duliyomololo dilukulionamiya ebe epola. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nanitabola, ebe epo bilibilinomate pelamoliya Ya꞉sukono tabo olowioma꞉ ega꞉walo ebete ibino temetema꞉gopi wadekobi ka꞉midiolema꞉, ega꞉walo kuba uliyanagopiate ebetamo atumu a꞉ka꞉pelamiya, ebene ebete ibi bilibilinomo wadekobi ebo midioliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ebema꞉ ebe epo bilibilinomo ubila Ya꞉suko kologioma꞉, mabu iba꞉te iyatawaiya Godokono elawote ebe magumune da꞉pemaiganaki ebe tetelo ebete temetema꞉gopi wadekobi ebo midiolenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ebene Ya꞉sute ebeno waloma꞉tapi bilibilinomo eba ulamitalo nanaliya, “La꞉ piyate nigologololo dilukula꞉wenama, modobola la꞉ nekalakalala꞉, mabu Godote Kawo Elawodawama꞉ deda꞉na, ebe wade duliyomolono tanalo la꞉imanola! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Ega꞉walo me tetelo la꞉ bae kapete dulametana, modobola la꞉ nekalakalala꞉, mabu Godote la꞉imano bae kape tanalo ka꞉modoboilaemene! “Ega꞉walo me tetelo la꞉ piyate temetema꞉go diima꞉wenama, modobola la꞉ nekalakalala꞉, mabu walone la꞉ kawo kalakalate kuwatelema꞉ta! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ega꞉walo Epono Naniwino tanaloma꞉ epetapiate la꞉tamo dowaolo ubia꞉ tabo eba gelalo la꞉ demalogoletana, ega꞉walo iba꞉te la꞉imano mailo da꞉kubailamena, modobola la꞉ atumu na꞉kekalakalala꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Iyo, la꞉ kalakalaolo unamo nilapatela꞉iyala꞉, mabu walone tetelo la꞉le Godokono Unu Duliyomololo la꞉imano wiya kawokawonomo ka꞉nuwatemamota. Numa꞉la꞉, dopamo ibino ewoniate atu ubia꞉ tabo kegelanakiya Godokono woki awokalimipiatamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Wiyasiya me tetelo la꞉ piyate inamabu bilibilinomagopima꞉ deda꞉wenama, la꞉ kawo tepo temeteme kiyatawaomamota, mabu la꞉imano kalakala nelawenamata, walone kolopoligomene! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Ega꞉walo me tetelo la꞉ kebe epo bae kapete kulametana꞉, la꞉ kawo tepo temeteme kiyatawaomamota, mabu walone la꞉ bae kapete kuwatelema꞉ta! “Ega꞉walo me tetelo la꞉ piyate dekalakalawenama, la꞉ kawo tepo temeteme kiyatawaomamota, mabu walone la꞉ gowelago kiimimamota! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ega꞉walo epo bilibilinomate la꞉ demoioletamene, la꞉ nanisiwale, mabu walone tetelo la꞉ kawo tepo temeteme kiyatawaomamota! Numa꞉la꞉, dopamo ibino ewoniate Godokono mailamo a꞉da꞉ tabo kiyawaopi atumu emoiolenakiya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ebene Ya꞉sute walo na꞉kegiya, “Ebe mabuma꞉ na la꞉tamo negemo, piyate la꞉go da꞉gowelaona, modobola la꞉ ibi nilakapolo nemalagidilolenala꞉ ega꞉walo iba꞉tamo wadewade tanalo nosiyodilolenakiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ega꞉walo la꞉tamo malato tabo da꞉kiyawaonaka, ebe epono tanaloma꞉ Godotamo na꞉towetoweonakiyala꞉ ebete ibi wadenomamo kowalubilinama꞉, iyo, piyate la꞉tamo kuba tanalo dosiyodilolena la꞉ ibi Godotamo nowadipalatelenakiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ega꞉walo potele a꞉ma꞉ tatakolo danagalimitamene, modobola apu bala ebetamo na꞉kikamiye. Ega꞉walo kebe lumagite a꞉imano sete inamabu a꞉ma꞉godone elawamo delaemene, ebe atu tetelo a꞉imano lubudino inamabu akoamoeda꞉la꞉, a꞉ma꞉le ebetamo nilakapolo gito na꞉kikamiye. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Iyo, lumagite a꞉imano inamabu idima꞉ a꞉ma꞉ da꞉toweometamene, modobola ebetamo nilakapolo nikamiye, ega꞉walo kebe lumagite a꞉imano inamabu pilolo duwatemene, a꞉ma꞉ toawete ebe inamabu elawamo akonuwata꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ebema꞉ epate la꞉tamo beda꞉ tanalo osiyodiloma꞉ la꞉le ubi diyata꞉wenakoma, la꞉ epetapiatamo eba kunu nosiyodilonakiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Piyate la꞉ nilakapolo demalagidiloletana, la꞉ ebe epo kapiya demalagidilola꞉wenama la꞉imano woki keba kunula꞉ka꞉? Ebe mabuma꞉ Godote la꞉tamo wade wiya ba꞉kikalametamene? Ao, mabu kuba osiyodilolepiate atumu ibino namutupi kapiya nilakapolo malagidilolenaka! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ega꞉walo piyate la꞉tamo wadewade tanalo dosiyodilolena, la꞉ ebakobako epo kapiyatamo wadewade tanalo dosiyodilola꞉wenama la꞉imano woki keba kunula꞉ka꞉? Ebe mabuma꞉ Godote la꞉tamo wade wiya ba꞉kikalametamene? Ao, mabu kuba osiyodilolepiate ibino namutupi kapiyatamo atu wadewade tanalo kosiyodilolenaka! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ebema꞉ piyate la꞉tamo walo da꞉kikalamoletanaka, la꞉ ibi kapiyatamo mani dikalamola꞉ema la꞉imano woki keba kunula꞉ka꞉? Ebe mabuma꞉ Godote la꞉tamo wade wiya ba꞉kikalametamene? Ao, kuba osiyodilolepiate atumu ibino namutupi kapiyatamo mani ikalamolenaka mabu atu tanalo iba꞉godone walo ka꞉kuwatema꞉na꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wiyasiya modobola la꞉tamo gowelaopima꞉ deda꞉ona, la꞉ ibi nilakapolo nemalagidilolenala꞉ ega꞉walo iba꞉tamo wadewade tanalo nosiyodilolenakiyala꞉. Iba꞉te manima꞉ la꞉ danaletamene, modobola la꞉ iba꞉tamo gito nikalamiyala꞉, wiya tanalo akomalagidilala꞉. Mako osiyodilo tanalodo la꞉ Ununomo Godokono gudima꞉ eda꞉wete walone tetelo wiya kawonomo kuwatemamota. Numa꞉la꞉, ebete kuba osiyodilolepi ega꞉walo ebetamo kalakala tabo gela꞉pi ebakobako epatamo nilakapo tanalo osiyodilolenako. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ebema꞉ la꞉ epo bilibilinomo nilakapolo nemalagidilolenala꞉, la꞉imano Nabiwite ibi keba kunu kemalagidilolenale eba kunu.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ebene Ya꞉sute walo na꞉kegiya, “La꞉le epo epetapino iyaiya tanalo anagilamelelamelo ibi kubakubapima꞉ samamo akoka꞉la꞉miala꞉, ebene Godote la꞉imano tanalo anagilamelelamelo la꞉ kubakubapima꞉ a꞉keka꞉la꞉mitamene. Ega꞉walo modobola la꞉ epono kuba egebolelama꞉wete na꞉dodolomatililamiyala꞉, ebene Godote atumu la꞉imano kuba egebolelametate ka꞉dodolomatililaema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ega꞉walo modobola la꞉ epetapiatamo inamabu nilakapolo nikalamenakiyala꞉, ebene Godote atumu la꞉tamo eba ikalamelo tete bilibilinomolo ebete la꞉ inamabuamo betabokailamenakoma꞉ta, iyo, la꞉ epetapiatamo kebako uwomulo kikalama꞉wenakoma, Godote atumu la꞉tamo ebako uwomulo ba꞉kikalamenakoma꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ebene Ya꞉sute iyatulame oi eba kiyawaolo negiya, “Balidi tamio dubute balidi tamio dubu idi gabodo wadenomamo a꞉kemagatamene. Ebete eba kunu dowagelemene ibi netewapi damela gugamo kapimiya ka꞉na꞉gudima꞉na꞉, a, nanitabola꞉ka꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ebema꞉ ka꞉lo sukululo diyatawana ebe guduno iyatawa tanalote iyatulamedawano iyatawa kodolina꞉, wiyasiya walone ebeno sukulu dolopoligomene ebeno iyatawa tanalo ega꞉walo iyatulamedawano tanalo atu tetelo ka꞉pola꞉nama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Keleka꞉ mabu a꞉imano ekawino balidilo nonoka da꞉peso umilo wiyasiya a꞉imano balidilo ditana ebe kawo kewa tete kuma꞉wena꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ega꞉walo beda꞉ mabuma꞉ a꞉imano ekawitamo ma kunu degeawita, ‘Ekawi, modobola a꞉imano balidilo ditana ebe nonoka da꞉peso nale kelaemamota,’ wiyasiya a꞉imano balidilo ditana ebe kawo kewa tete a꞉ma꞉ kelawa꞉wena꞉? Eiye! A꞉ma꞉ mena netewa lumagilata! Modobola a꞉ma꞉ dopamo a꞉imano balidilo ditana ebe kewa lawa꞉wete, a꞉ma꞉le walone wadenomamo mela꞉wete a꞉imano ekawino balidilo ditana ebe nonoka da꞉peso ebo kelaema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ebene Ya꞉sute walo na꞉kegiya, “Wadewade kewalo kubakuba da꞉ima꞉te a꞉ka꞉noloma꞉na꞉, ega꞉walo kuba kewalo wadewade da꞉ima꞉te a꞉ka꞉noloma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Iyo, nanitabola, la꞉ iyaiya kewano da꞉imi ibino ololamo dulama꞉ema la꞉ ebo kiyatawaomamota, ibi magumulo kebe da꞉ima꞉te naoma꞉ wadewadenoma꞉ keda꞉onale. Ebema꞉ lumagite moeagono kewamo tote umei kewano da꞉imi a꞉ka꞉netapiomene, ega꞉walo ebete moeagono kewalo wadewade gala꞉ipi da꞉imi a꞉ka꞉nulaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ebema꞉ wade lumagite ebeno tepo magumune wadewade tanalo ba꞉powaulatelenakomene, wiyasiya kuba lumagino tepo magumulo kuba tanalate pola꞉na ebema꞉ ebegodone kubakuba tanalate ba꞉pemaimionakoma꞉na꞉, mabu lumagino tepo magumulo kebe tanalate ka꞉pola꞉nale, ebe tanalate ebeno tabo kiyawao tanalodo ka꞉pemaimioma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ebene Ya꞉sute walo na꞉kegiya, “Keleka꞉ mabu la꞉le na Kawodawama꞉ gito deka꞉na꞉miawenama, wiyasiya nale da꞉kiyawaonakomo ebe tanalo la꞉le kosiyodilola꞉wena꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ebema꞉ kebe lumagite natamo pete naimano tabo polowiote ebe iyaiya tanalo dosiyodilolemene, ebe lumagino tanalo keba kunu kitanale nale la꞉ wadenomamo kiyatulaemamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ebe lumagi wade moto detiya ebe dubu keba kunula꞉ka꞉ eba kunula. Ebete damela magumunomamo obobote kodakoda damela unamo ebeno moto ebo etiya, ebene ulama obote eba odololo ebe moto dapadimagotiya, wiyasiya motote kalegiya꞉ mabu etedawate ebeno moto wadenomamo etiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wiyasiya kebe lumagite naimano tabo olowite osiyodilolea꞉no, ebe kobokobo damelamo moto detiya ebe dubu keba kunula꞉ka꞉ eba kunula. Ebe motono mabu puliyala, kitaniya꞉, ebema꞉ ulama obote eba odololo ebe moto dapadimagotiya opamo gito kagiya. O olalati beda꞉ kawonomola꞉ka꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ya꞉sute epatamo me tanalo bilibilinomo kiyawao dolopoligiya ebete Kapeniyama duliyomolamo gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Loma epono gowelaodawa elawodubu idite ebolo okolinami, ebene ebeno wiya꞉ wokopi magumulo ebete kebe dubu kawonomamo demalagidilonami, ebe dubu kawo gabugabute umiti, ebe a꞉e tatalila. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ebema꞉ ebe elawodubute Ya꞉sukono tanalo olowite Yu watowatopi dubu epetapi ebetamo ebo ka꞉la꞉miya, iba꞉te Ya꞉suko ma kunu kananama꞉, ebete pete elawodubuno wokodawa wadekobi ka꞉pa꞉midima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ebene ibi epetapiate Ya꞉sutamo pelamete ebe toweomelo napaniya, “Me Loma opodawa elawodubu wade lumagila. Modobola a꞉ma꞉ ebe na꞉nowaluba꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mabu ebete a Yu epo kawonomamo nemalagidiloena, ega꞉walo ebete ebeno maniamo aimano balidi ibilamole moto eteami.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ebema꞉ Ya꞉sute iba꞉go na꞉tiya. Ebete eba tonatolo moto niyakabamo da꞉nemaigiya, ebe elawodubute ebeno namutupi ebo aliboliya iba꞉te Ya꞉suko kananama꞉, “Kawodawa, kodakoda tanalo idi naimano tanaloma꞉ ako-osiyodilala꞉. Na wade lumagia꞉ a꞉ma꞉le naimano motamo podoloma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ega꞉walo na wadenoa꞉ a꞉imano ololo apuamo pema꞉. Wiyasiya na niyatawitamo, a꞉ma꞉le motamo pea꞉no tabo gito degeaemene, naimano wokodawate nanitabonomolo wadekobi kolowimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mabu na atumu gowelaopino kawokawo elawodubuno opodawama꞉ eba eda꞉nalo ibino tabamo a꞉tuduwatanakomo, ega꞉walo atu tetelo naimano gowelaopiate naimano umi magumulo pola꞉na. Ibi magumulo nale idi danamo, ‘A꞉ma꞉ na꞉toa!’ ebete ebo ka꞉tomene. Ega꞉walo idi dakanamo, ‘A꞉ma꞉ na꞉pa꞉!’ ebete ebo ka꞉pemene. Atumu nale naimano wiya꞉ wokodawa danamo, ‘A꞉ma꞉ me tanalo nosiyodila!’ ebete ebe tanalo kosiyodilomene. Ebema꞉ Kawodawa, modobola a꞉ma꞉ tabote negea naimano woko dubute wadekobi kolowima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ya꞉sute ebe tabo dolowiya ebete nela꞉wiya, ebema꞉ ebe dowaloma꞉titiya ebete ebe epo bilibilinomatamo olobigate negiya, “Na la꞉tamo nanitabonomolo gemo, na Isalaela epo bilibilinomo magumulo mako nanitabokobi midi lumagi kuminakoa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ebene gowelaodawa elawodubute daliboliya ebe dubate ebeno motamo walo da꞉ka꞉pelamiya, iba꞉te ebe wiya꞉ wokodawa wadekobi olowilo pumiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Egela idilo Ya꞉sute duliyomolo ida꞉mo gito tiya, ebe duliyomolono mailo ebe Na꞉inila, ebe tetelo ebe waloma꞉tapi ega꞉walo epo bilibilinomo eba꞉go kapimiya tolamitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ebene ebete duliyomolono kala ga꞉dimi gigiyamo da꞉nemaigiya, ebe tetelo epo bilibilinomate a꞉e dubu agute duliyomolone pemaimiutiya ebe bobamo ka꞉piniyatima꞉, ebe a꞉e dubuno menoko amolela, ebeno gudu kapiyanomote a꞉iya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ebema꞉ Kawodawate ebe kamiyale umite nilakapoimilo ebetamo negiya, “A꞉ma꞉ akoitala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ebene Ya꞉sute tote a꞉e dubute dekapitani ebe patapata da꞉nologiya, ebe daguwatitiya ebe dubate ebamo eba putitatalo, ebete a꞉e dubutamo negiya, “Ekawi, nale a꞉ma꞉ anamata, nemaiga!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ebene ebe dubute maigate tabo kiyawao dowagilimiya, Ya꞉sute ebeno menokotamo gito ikamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ebema꞉ ibi bilibilinomate kawonomamo toletoleolo Godokono mailo unamo eba adipatelo negeliya, “Godokono woki awokalimidawa atamo a꞉pemaiga! Iyo, Godote ebeno epono igilo mula꞉lelaema꞉ pe!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ebema꞉ ebe Na꞉ini duliyomolono opo ega꞉walo opo epetapi tametamelo dilukulionamiya, ebe epo bilibilinomate Ya꞉sukono tanaloma꞉ tabo ebo na꞉kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ebe tetelo Yoneko epo obamo waduba꞉midaoledawa, ebeno waloma꞉tapiate me tanalo bilibilinomo ebe ebo pikiyawaomiya. Ebene ibi magumulo Yonete netewa dubu ka꞉la꞉mite ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ya꞉sutamo ebo naliboliya, iba꞉te ebe ma kunu kananama꞉, “Yonete pema꞉ degi, a꞉ma꞉ ebe lumagila꞉ka꞉ o ale lumagi idi kemakopelenama꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ebene iba꞉te Ya꞉sutamo pelamete na꞉pegeliya, “A Yonete paliboe a꞉ma꞉ ma kunu kapalateda꞉tama꞉, ‘Yonete pema꞉ degi, a꞉ma꞉ ebe lumagila꞉ka꞉ o ale lumagi idi kemakopelenama꞉?’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ebe tetenomolo Ya꞉sute ibino ololo apulo iyaiya temetema꞉gopi, ega꞉walo gabugabuagopi, ega꞉walo kuba uliyanagopi bilibilinomo wadekobi midioliya, ega꞉walo ebete balidi tamiopi atumu wadekobi a꞉ka꞉midioliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ebema꞉ ebete wiya tabo Yoneko waloma꞉tapiatamo negiya, “La꞉ toawete la꞉le kebe tanalo kulamola꞉ema ega꞉walo la꞉le kebe tabo kolowiaema, ebe iyaiya tanalo Yoneko nananala꞉. Balidi tamiopiate a꞉melea ega꞉walo agowa tataipiate nowapata꞉lama꞉! Kukulakukulagopiate wadekobi olowiya ega꞉walo galo tamiolamepiate nolowia! A꞉elaopiate a꞉ene walo a꞉kemaimiya ega꞉walo nigologolo epatamo Godokono Wade Tabote a꞉pe! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ebema꞉ kebe lumagite na nanitabokobi midinilo woki netewama꞉ eda꞉no, ebegodolo Godokono kalakalate bitanamene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ebene Yonete dapaliboliya ebe dubu netewate da꞉tiya, Ya꞉sute Yonekono tanaloma꞉ epatamo ebo kiyawaiya. Ebete negiya, “La꞉ Yonekono tanalo olowiawete bulu opamo danemaimiaima, beda꞉ tanalo uima꞉ ka꞉tolama꞉ima? Pudo kapiya awate gito dadegetiti, ebe uima꞉ ka꞉tolama꞉ima? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O la꞉ wadewade kaliku pupulio dubu uima꞉ ka꞉tolama꞉ima? Ao, la꞉ iyatawalata wadewade kaliku pupuliopiate bulu opolo kilukuliona꞉, wiyasiya iba꞉te kawokawo elawodubuno motolo ilukuliona! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ebema꞉ na niyatunama꞉la꞉, la꞉ beda꞉ma꞉ ka꞉tolama꞉ima? Godokono woki awokalimidawa uima꞉la꞉ka꞉? Iyo, na la꞉tamo nani tabo gemo, Yonete Godokono woki awokalimipi epetapi bilibilinomo odoili. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nanitabola, Yonekono tanaloma꞉ Godote ebeno Bukalo tabo ma kunu giya, ‘Nale Kelisokono dopo apuamo naimano tabo atadawa kapalibomamo, ebete ebe dopomete ebeno gabo kosiyodiloma꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ya꞉sute walo na꞉kegiya, “Nale la꞉ analemata, wagilimi mabune me teta꞉mo pemaiga me opo kawonomolo dawokalaiya, ebe epo bilibilinomo magumulo Yoneko kawodawanomoma꞉ eda꞉na. Wiyasiya me tetene wagilimite Godote Kawo Elawodawama꞉ deda꞉na, ebe duliyomololo kebe lumagite da꞉pesonomoma꞉ deda꞉mene ebete Yoneko nanitabolo kodolimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ebe tetelo dopamo Yonete kebe epo obamo dowaduba꞉midaoliya, ebe ta꞉kese uwatepi ega꞉walo epo epetapi bilibilinomo iba꞉te Ya꞉sukono tabo olowite Godokono gabo tuputupunomoma꞉ gelate ebo kalakalautiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wiyasiya Pa꞉lisi tanebapi ega꞉walo Godokono Totomu iyatulamepi iba꞉te dopamo Yonetamo ka꞉nemaimiya꞉ ebete ibi obamo waduba꞉midaolema꞉. Ebe tanalo magumulo iba꞉te Godokono wade tanalo odiyobiya, ebema꞉ iba꞉te Ya꞉sukono taboma꞉ kekalakalautiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ebema꞉ Ya꞉sute negiya, “Na me tete epono tanalo kebe uli tabamo nakawokalimo? La꞉ kebako epola꞉ka꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","La꞉ olowame bailo dekalakalauta ebe gudi egege keba kunula꞉ka꞉ eba kunula. Gudi epetapiate epetapiatamo kegela, epetapiate epetapiatamo kegela, iba꞉te apaminateuilo ma kunu wagelena, ‘Ale soliyomu eba osiyodilolo bibolo da꞉moleoma꞉ wiyasiya la꞉ ago kemaeawea꞉, ega꞉walo a a꞉e lumagi bobamo iyatima꞉ dowagelitama꞉ la꞉ wiyasiya ago kiima꞉wita꞉!’ Iyo, me tete epala꞉, la꞉ eba kunu wagelenamata, la꞉ Godokono wokopiatamo ubia꞉ tabo gelanakomata. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Numa꞉la꞉, Yoneko epo obamo waduba꞉midaoledawate da꞉pemaigi, ebe tetelo ebete elawo da꞉imi obo ka꞉ninakia꞉ ega꞉walo tete epetapilo ebete bae naoa꞉no lutanaki Godokono woko kosiyodiloma꞉, ebema꞉ la꞉ negelimata, ‘Ebe kuba uliyanagonola!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Wiyasiya Epono Naniwite da꞉pemaigi, ebeno tanalo iyala. Ebete bae enanako ega꞉walo elawo da꞉imi obo a꞉ninako ebema꞉ la꞉ ma kunu gelanakomata, ‘Ebeno kuba numa꞉la꞉! Ebe tumu goeoma꞉ eda꞉te bae kawonomamo nanako, ebe elawo da꞉imi obo ni kawodawala! Ebe ta꞉kese mani elemasigilo uwatepi ega꞉walo Godokono Totomu Tabo uwatea꞉pi epetapi ibino namutudawala!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ebene uwomunomolo Ya꞉sute iba꞉tamo negiya, “Godokono wade mulo tanalo dowaloma꞉tana, ebe epate ibino ilukuli magumulo ebe mulo nanitabonomolo bawokaliminakoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ebene Pa꞉lisi tanebadawa dubu idite Ya꞉suko naniya ebete ebegodolo bae ka꞉nenama꞉, ebema꞉ Ya꞉sute ebe dubuno motamo nodolote bae nama꞉ gito nokoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ebe duliyomololo kuba kamiyale idi okolinami, ebene Ya꞉sute Pa꞉lisi tanebadawano motolo bae deniti ebe kamiyalete ebe tanalo olowite wade nibo ii nokola kalila꞉mo tabokaimi ebo adaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ebe tetelo ebete Ya꞉sukono walogabo apune pete ebeno agowa mabuamo putite ebeno ipupamo Ya꞉sukono agowa pukulalemete agowa a꞉la꞉li ebeno eka꞉mo ebo iya꞉da꞉olemiya, ebene ebete ebeno agowa aboelatelemete ebete dadaiya ebe wade nibo ii ebeno agowamo gito adipanamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ebene Ya꞉suko daniya ebeno motamo pema꞉, ebe Pa꞉lisi tanebadawate kamiyaleno osiyodilo tanalo umite ebeno tepo magumulo ma kunu malagidiliya, “Me dubu ebe Godokono woki awokalimidawama꞉ neda꞉taleka꞉, ebete ebe kamiyaleno tanalo biyatawana꞉, ebe dologi ebe kamiyale dubu bilibili kamiyalela!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ebene Ya꞉sute Pa꞉lisi tanebadawatamo negiya, “Saimono, nagodolo tabo da꞉peso bitana a꞉ma꞉ kanatama꞉.” Ebene Saimonote negiya, “Modobola, Iyatulamedawa, negea.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ya꞉sute negiya, “Inamabu bilibilinomago dubu idi okolinami, ebene dubu netewate ebegodone mani uwatete tete geyageyanomolo ebetamo walo kikameiya꞉, idawate 500 mani, idawate 50 mani. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ibi netewapiate eba kunu wiyaolea꞉no eba ilukulinalo, egela idilo ebe kawo dubute ibi ebetamo ka꞉la꞉mite, ibi nilakapoilamelo ibino wiyaolea꞉no tanalo gito egebolelamiya. Ebema꞉ a꞉imano woki keba kunula꞉ka꞉, ibi netewapi magumulo kawo kalakalago ebe potele kemalagidilonamile?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimonote tabo eba wiyalo negiya, “Naimano woki bitana, mani kawonomo duwatiya ebe wiya꞉nodawala.” Ebene Ya꞉sute negiya, “A꞉ma꞉ nani tabo geata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ebe tetelo Ya꞉sute kamiyaletamo olobigate Saimonoko ebo alatediya, “A꞉ma꞉ me kamiyale na꞉kuma꞉wita? Na a꞉imano motamo da꞉podolomo, ebe tetelo a꞉ma꞉ natamo agowa ukulaleno obo kikanama꞉wea꞉. Ebete wiyasiya ebeno ipupamo naimano agowa ukulalenamete, agowa a꞉la꞉li ebeno eka꞉mo iya꞉da꞉olename. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ega꞉walo a꞉ma꞉le na kaboenatena꞉wea꞉, wiyasiya nale motamo da꞉podolomo ebe tetene wagilimite ebete naimano agowa aboelatole katepita꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ega꞉walo a꞉ma꞉ wade olibi kikopuno iamo naimano wato kabutima꞉wea꞉, ebete wiyasiya naimano agowamo wiya kawonomo wade nibo ii ebe adipana. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ebema꞉ na a꞉ma꞉tamo negemo, ebete natamo nilakapo kawonomamo dawokalimi, ebe osiyodilo tanalote tanalo idi ma kunu kawokalimi, Godote ebeno kawokawo kuba bilibilinomo egebolemete a꞉dodolomatilimi. Wiyasiya numa꞉, Godote lumagi idino kuba depeso da꞉dodolomatilimene, diyala, ebe lumagite nilakapo tanalo Godotamo akawokalimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ebene Ya꞉sute ebe kamiyaleno tepo magumu eba iyatawalo ebetamo negiya, “Godote a꞉imano kuba egebolemetate a꞉dodolomatilima꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ebema꞉ eba꞉go ilukulite bae denautiya iba꞉te ibi magumulo negeliya, “Lumagino kuba egebolema꞉ dege, me kebe amama dubula꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ebene Ya꞉sute kamiyaletamo walo na꞉kegiya, “A꞉imano nanitabokobi midi tanalote a꞉imano igilo a꞉mula꞉ma꞉ta. Kalakalago na꞉toa.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ebene egela epetapi dolopoligiya Ya꞉sute kawokawo ega꞉walo egege duliyomololo Godokono Wade Tabo kiyawaoago eba pata꞉lo, Godote Kawo Elawodawama꞉ deda꞉na ebete ebe tanalo na꞉kiyawaonaki. Ebe tetelo ebeno 12 waloma꞉tapi dubate eba꞉go tolamenakiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ega꞉walo kamiyale epetapiate eba꞉go atumu na꞉kowapata꞉lamenamiya, dopamo tetelo ibino taneba magumulo epetapiate kuba uliyanagopima꞉ eda꞉onamiya ega꞉walo epetapiate iyaiya temetema꞉gopima꞉ eda꞉onamiya, wiyasiya Ya꞉sute ibi wadekobi a꞉midioliya. Ebe kamiyale magumulo Magadala duliyomolodawa Ma꞉liko ebe idila, dopamo Ya꞉sute ebegodone sebeni kubakuba uliyana aliboliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ega꞉walo kamiyale idi Kusakono kamiyale Yowanatela, Kusako ebe Kawo Elawodubu Elodikono opodawa idila. Ega꞉walo kamiyale idi ebe Susa꞉natela. Ebe netewa-kapiya kamiyale iba꞉te kamiyale bilibilinomo epetapiago ibino maniamo Ya꞉suko ega꞉walo ebeno 12 waloma꞉tapi dubu walubilinakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ebene epo bilibilinomate iyaiya duliyomolone pelamolete Ya꞉suago dapaladabutiya, Ya꞉sute iyatulame oi iba꞉tamo ma kunu kiyawaiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Lumagi idite pali amio bai dosiyodili, ebe tetelo ebete kono kikopu aminaola꞉go eba tonatolo kikopu epetapi iba꞉te gabamo ebo gudiya, ebema꞉ epate agowamo da꞉mikitaoliya olaolate gito penaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kikopu epetapi iba꞉te nokola damelamo gudiya, ebema꞉ iba꞉te tete da꞉pesamo apepeote ebo alawoiya mabu ebe damela a꞉la꞉li puliyala. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kikopu epetapi iba꞉te moemoe uwago damelamo gudiya, ebema꞉ iba꞉te kapimiya apepeote moeagopi uwagate kono gito anakapulamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wiyasiya kikopu epetapi iba꞉te wade damelamo gudiya, ebema꞉ iba꞉te apepeote gito noloiya, kono idite 100 teta꞉mo, kono idite 100 teta꞉mo, iba꞉te eba kunu bilibilinomoma꞉ eda꞉iya.” Ebema꞉ Ya꞉sute kawonomamo negiya, “Galagodawa, a꞉ma꞉ wadenomamo nolowia!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ebene Ya꞉suko waloma꞉tapiate ebe nalatediya, “Me iyatulame oino magumu keba kunula꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ya꞉sute iba꞉tamo eba wiyalo negiya, “Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalono magumu kelawa꞉ema꞉ nale elawo la꞉tamo ikalaimata, iyo, ebe tanalono waminaole tanalo la꞉ iyatawaimata. Wiyasiya epo epetapi eba kunua꞉, iba꞉te ebe tanalono iyatulame oi olowiote, iba꞉te ebeno magumu bowadinakoma꞉na꞉ wiyasiya a꞉kuminakoma꞉na꞉, iyo, iba꞉te bolowinakoma꞉na꞉ wiyasiya a꞉kiyatawaonakoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ebene Ya꞉sute walo na꞉kegiya, “Me iyatulame oino magumu ma kunula, kono kikopu ebe Godokono tabola. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ebene epo epetapiate gabamo da꞉gudi, ibi ebe kono kikopu keba kunula꞉ka꞉ eba kunula. Iba꞉te Godokono tabo dolowima꞉na꞉, Saitanate pete ebe tabo ibino tepo magumune ka꞉puwatelaemene iba꞉te nanitabokobi midite igilo mula꞉ tanalo lawekapoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Epo epetapiate nokola damelamo da꞉gudi, ibi ebe kikopula. Iba꞉te tabo dolowima꞉na꞉ kalakalago kelaema꞉na꞉, wiyasiya ibino tepo magumulo dolodolo puliyala, ebema꞉ iba꞉te nanitabokobi midi magumulo tete da꞉pesamo ilukula꞉tepate temeteme tanalate iba꞉tamo da꞉pemaimioma꞉na꞉ iba꞉te samonomamo ka꞉gudima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Epo epetapiate moemoe uwago damelamo da꞉gudi, ibi ebe kikopula. Iba꞉te tabo kolowima꞉na꞉, wiyasiya iba꞉te inamabu uwatema꞉ eba malagidilolenalo woki bilibilima꞉ eda꞉ona, ebema꞉ ibino ilukuli tanalono ubi tanalate ibino nanitabokobi midi tanalo eba anakapumilo iba꞉te wade nao konoma꞉ a꞉keda꞉oma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ebene epo epetapiate wade damelamo da꞉gudi, ibi ebe kikopula. Iba꞉te Godokono tabo dolowima꞉na꞉ nanitabonomolo kelaema꞉na꞉, ebene iba꞉te ibino tepo magumulo ebe tabamo tudila꞉ote kodakodanomolo eba utitatalo wade nao kono ebo ka꞉noloma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ebene Ya꞉sute walo na꞉kegiya, “Lumagite ebeno wuiki alo pite bagowo magumamo a꞉kiyatimene ega꞉walo ebeno wata bai magumamo a꞉kiyatimene. Wiyasiya ebete alo awokala baiamo kiyatimene, ebene epate ebeno moto guamo da꞉podoloma꞉na꞉ iba꞉te ebe alo ka꞉puima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Numa꞉la꞉, kebe waminaole tanalate da꞉pola꞉na walone tetelo Godote kawokalilaemene, ega꞉walo kebe ulamolea꞉ tanalate da꞉pola꞉na walone epate alo tetelo kulamolema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ebema꞉ a꞉ma꞉ wadenomamo nolowia. Godokono tabo olowioma꞉ lumagigodolo wadewade woki da꞉pola꞉na, Godote ebetamo wadewade tanalo bilibilinomo walo ka꞉kikameomene. Ega꞉walo lumagigodolo wadewade woki pola꞉na꞉no wiyasiya ebete nemalagidilona, ‘Na wadedawala,’ ebegodolo kebe kapiyakapiya tanalate da꞉pola꞉na Godote ebegodone walo ka꞉kuwatemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ebene Ya꞉sukono menoko ega꞉walo ebeno ekaki ebetamo da꞉pelamiya, iba꞉te ebe uima꞉ ka꞉modobiya꞉ mabu epo bilibilinomate ebe niyakabolo na꞉pola꞉niya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ebema꞉ lumagi idite Ya꞉suko naniya, “A꞉imano menoko ega꞉walo ekaki iba꞉te moto niyakabolo ba꞉pelamota꞉ona. Ibi ubila a꞉ma꞉ kumitama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ebene Ya꞉sute ibi bilibilinomatamo negiya, “Potele Godokono tabo olowite ebetamo da꞉tuduwatamene, ebe lumagi naimano menokola ega꞉walo ebako epo naimano ekakila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Adimo idilo Ya꞉sute ebe waloma꞉tapiago peamo olonate ibi nanaleni, “A paka꞉ apuamo ka꞉na꞉iwaliye,” ebema꞉ iba꞉te paka꞉ a꞉iwale ebo wagiliminiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Iba꞉te eba na꞉iwalenalo Ya꞉sute ebe palai pe gulo gito nowatani, ebene kawo awanomote eba maiganalo kawokawo ulono obote pe guamo da꞉poloniya pete tatalila ololuna. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ebema꞉ iba꞉te Ya꞉sutamo pelamenate ebe eba pamutiyanalo ebo pananiya, “Iyatulamedawa, a ka꞉elaomalema꞉!” Ebe tetelo Ya꞉sute maiganate awa ega꞉walo kawokawo ulo kawiya nanaleni, “La꞉ nolodiyobala꞉!” ebene awate olopoligonate paka꞉te matalukobi ebo olowini. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ebema꞉ Ya꞉sute iba꞉tamo negeni, “La꞉imano nanitabokobi midi tanalo keleka꞉?” Wiyasiya iba꞉te tola꞉go anoanonalo ibino taneba magumulo negelaniya, “Me lumagi potelela꞉ka꞉? Ebete awa ega꞉walo ulo danale, iba꞉te ebeno tabamo a꞉tudila꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ebene Ya꞉suko ega꞉walo ebe waloma꞉tapi iba꞉te Gelasa duliyomolono opamo nemaimiya, ebe opote Ga꞉lili Paka꞉ apulo itanami. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ya꞉sute damelamo eba nodololo Gelasa duliyomolodawa kuba uliyanagono dubute eba꞉go palugiya, ebete tete geyageyanomolo kalikua꞉no okolinami ega꞉walo ebe motonomolo kokolinamia꞉. Nanitabola, ebe opo epono tanalo ma kunula, iba꞉te maboele nokola damela eba obobolelo iyaiya bobo ebo osiyodilolenakiya iba꞉te ibino a꞉elao epo alomoma꞉, ebene ebe dubute ebe nokola bobo magumulo okolinami. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ebete Ya꞉suko umite kawonomamo gepatete ebeno agowa mabuamo gate tabo madodo eba adipatelo negiya, “Ya꞉su! A꞉ma꞉ Ununomo Godokono Gudulata! A꞉ma꞉le natamo beda꞉ tanalo na꞉kosiyodilaemene? Nale a꞉ma꞉ na꞉toweoemata, natamo kuba wiya akoikanama꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ebete tabo ma kunu giya mabu Ya꞉sute kuba uliyana kawiya aniya ebegodone ka꞉nemaigama꞉. Nanitabola, dopamo tete bilibilinomo epetapilo ebe kuba uliyanate ebe dubu magumulo elawonomoma꞉ eda꞉nami, ebema꞉ epate ebeno agowala kotola auli ala꞉mo dematuolamolemenakiya, ebete ebe ale iyailinaki kuba uliyanano elawamo bulu opamo ebo alaula꞉naki. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ebene Ya꞉sute ebe nalatediya, “A꞉imano mailo potelela꞉ka꞉?” Ebete nowamiya, “Naimano mailo Bilibilinomotela,” mabu ebe magumulo kubakuba uliyana bilibilinomate ilukulinamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ebene ebe kubakuba uliyanate Ya꞉suko na꞉toweomiya, “A꞉ma꞉ a Ela Opamo akonaliboala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ebe tetelo dabiole goeogoeo bilibilinomate damela unulo nala꞉go ebolo nowapata꞉lamitiya. Kubakuba uliyanate Ya꞉suko na꞉toweomiya iba꞉te goeogoeo magumamo ka꞉nopila꞉oma꞉, ebene Ya꞉sute modobo tabo gete ibi ebo analiya, “Na꞉tolama꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ebema꞉ kubakuba uliyanate dubugodone nemaimite goeogoeoatamo da꞉nopila꞉iya, goeogoeo bilibilinomate damela unune puila꞉ote maboele damelane da꞉na꞉gudiya obamo nololuote gito na꞉elaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ebe tetelo goeogoeo ulamepi dubate ebe tanalo umite ibino duliyomolamo puila꞉ote, duliyomolo epo ega꞉walo tumu motolo dilukulionamiya da꞉nikiyawaolamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","epo bilibilinomate ebo pelamiya Ya꞉sute dosiyodiliya ebe tanalo uima꞉. Iba꞉te ebetamo pemaimite kubakuba uliyanate datepiya ebe dubu ebo pumiya, ebete kaliku pulite Ya꞉sukono agowa mabulo okoliti mabu ebeno woki a꞉tuputupuomiya. Me mabuma꞉ iba꞉te na꞉toletoleutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ebene piyate ebe tanalo dumiya ebe epate kubakuba uliyanagono dubute wadekobi keba kunu kolowiyale, ebe tanaloma꞉ epo epetapi ebo kiyawaolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ebe tetelo ebe Gelasa opo epo bilibilinomate Ya꞉suko naniya ebete ibino opo atepate ka꞉toma꞉ mabu iba꞉te kawonomamo toletoleutiya. Ebema꞉ Ya꞉sute peamo olote eba tolo, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","kubakuba uliyanate datepiya ebe dubute ebe na꞉toweomiya, “Na niyala, a꞉ma꞉go ka꞉pa꞉mo!” Wiyasiya Ya꞉sute ebe eba alibolo naniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“A꞉ma꞉ motamo na꞉toa. Godote a꞉ma꞉tamo kebe tanalo kosiyodilola꞉kale, a꞉imano duliyomolo epo ebe iyaiya tanalo na꞉nikiyawaolama꞉.” Ebene me dubute ebeno duliyomolamo tote, Ya꞉sute ebetamo dosiyodiloliya ebete ebe tanalo bilibilinomo epatamo ebo na꞉kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ya꞉sute paka꞉ apune walo da꞉ka꞉pa꞉iwiya, ebe tetelo epo bilibilinomate nekalakalaiya mabu iba꞉te ebeno pe tanalo makopelitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ebene Yu epono balidi ibilamole moto umidawa dubute Ya꞉sutamo piya, ebeno mailo Ya꞉ilasitela. Ebete Ya꞉sukono agowa mabuamo pa꞉tuduwatate ebe ebo petoweomiya ebete ebeno motamo ka꞉toma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","mabu ebeno kapiyanomo 12 ulama tete buwele ebete a꞉e tatalila. Ebene Ya꞉sute Ya꞉ilasikono motamo to dowagilimiya, epo bilibilinomate ebe eba a꞉wa꞉midalo mupuma꞉tiua꞉go tolamitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ibi magumulo kamiyale idi 12 ulama tetelo kalima ka꞉ka꞉liya temetemete uminami, ebete ebeno mani bilibilinomo doketa dubatamo eba ikalamelo ebo opoliyaliya, wiyasiya iba꞉te ebe wadekobi ka꞉midiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ebene me kamiyalete Ya꞉sukono walogabo apune pete ebeno kaliku da꞉pologiya, ebe tetenomolo ebeno kalima ka꞉ka꞉liya temetemete ebegodone gito olopoligiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ebene Ya꞉sute negiya, “Na potele kologinile?” Epo bilibilinomate iyatawa꞉noma꞉ eba gelalo Pitate ebe naniya, “Wade Iyatulamedawa, epo bilibilinomate a꞉ma꞉ eba a꞉wa꞉midalo mupuma꞉tiua꞉go pelamita.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ya꞉sute negiya, “Lumagi idite na ologini mabu elawote nagodone da꞉nemaiga, na ebo iyatawamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ebene ebe kamiyalete beda꞉ tanalo kosiyodiliyale wamina gabo kumiya꞉, ebema꞉ ebete anakamiago Ya꞉sukono agowa mabuamo pa꞉tuduwatate epo bilibilinomono ololo apulo ebeno tanalo ebo awokalimiya. Ebete Ya꞉suko beda꞉ mabuma꞉ ka꞉pologiyale ega꞉walo temetemete ebe tetenomolo ebegodone dolopoligiya, ebete ebe tanalo bilibilinomo Ya꞉sutamo ebo kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ebene Ya꞉sute ebetamo negiya, “Kamiyale, a꞉imano nanitabokobi midi tanalote a꞉ma꞉ wadekobi a꞉mida꞉ta. A꞉ma꞉ kalakalago na꞉toa.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ya꞉sute me tabo eba kiyawautalo Yu watodawa Ya꞉ilasikono motone tabo adaedawa idite pete Ya꞉ilasiko napaniya, “A꞉imano gudu buwele a꞉e. Iyatulamedawa walo akoanala꞉ ebe wadekobi ka꞉pa꞉midima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wiyasiya Ya꞉sute ebe tabo olowite Ya꞉ilasitamo negiya, “A꞉ma꞉ akotoletola꞉la꞉. A꞉ma꞉ Godoko nanitabokobi na꞉mida꞉, ebene a꞉imano buwelete wadekobi kolowimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ebene Ya꞉sute Ya꞉ilasikono motamo pemaigate epo epetapiate moto guamo odoloma꞉ ibi nodiyoboliya, wiyasiya Pitako, Yoneko, Ya꞉imesiko, ega꞉walo buweleno nabiwila menokola, eba꞉go mibinomate nopila꞉iya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ebe tetelo moto gulo da꞉pola꞉niya ebe epo bilibilinomate buwele liyamitiya, ebema꞉ Ya꞉sute ibi nanaliya, “La꞉ kiimitala꞉. Gudu buwele ka꞉eaka꞉, ebe u watita!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wiyasiya iba꞉te iyatawaiya gudute a꞉enomo a꞉iya, ebema꞉ iba꞉te Ya꞉suko nekalakalatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ebene Ya꞉sute tote buwele kotamo nelawete ebe eba ka꞉milo negiya, “Gudu, a꞉ma꞉ nemaiga!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ebema꞉ ebeno igilote ebetamo walo da꞉ka꞉piya ebe tetenomolo ebete na꞉kemaigiya, ebene Ya꞉sute ebeno menokola nabiwila nanaliya iba꞉te ebetamo bae kikameoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ebe mabuma꞉ iba꞉te nanoanoutiya wiyasiya Ya꞉sute ibi eba analelo negiya, “La꞉ me tanaloma꞉ epo epetapi akoanala꞉la꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ebe tetelo Ya꞉sute ebeno 12 waloma꞉tapi dubu ebetamo ka꞉la꞉mite iba꞉tamo elawo ebo ikalamiya epagodone kubakuba uliyana kanalibolema꞉ ega꞉walo iyaiya temetema꞉gopi wadekobi ka꞉nimidiolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ebene ebete ibi naliboliya Godote Kawo Elawodawama꞉ deda꞉na iba꞉te ebe tanalo epatamo ka꞉na꞉kiyawaoma꞉ ega꞉walo iba꞉te temetema꞉gopi wadekobi ka꞉na꞉midiolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ebete iba꞉tamo negiya, “La꞉imano tolame tetelo la꞉le gaubu, ega꞉walo mani alomono gatele, ega꞉walo bae, ega꞉walo mani, me inamabu akouwata꞉la꞉. Ega꞉walo la꞉ kapiyakapiya inamabu na꞉pupuliyala꞉, epetapi akouwata꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ebene la꞉ duliyomolo ida꞉mo nemaimiawete kebe motamo da꞉nodoloaema, la꞉ ebolo nilukula꞉tepawete walone ebe motone opo ida꞉mo ka꞉ka꞉tolaemamota, iyo, la꞉ moto idine moto ida꞉mo eba kunu akonowagela꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ega꞉walo kebe duliyomolo epate la꞉ uwateta꞉no, ebe duliyomolo eba atepalo la꞉le agowano tuwae na꞉moda꞉midatepaliyala꞉. Me tanalote ebe epo kiyatulaemene, Godokono tete ebe na꞉pe ebete ibino tanalo kapanagiyamidalaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ebema꞉ Ya꞉suko waloma꞉tapiate duliyomolo bilibilinomamo tolamete Godokono Wade Tabo epatamo eba na꞉kiyawaolo iyaiya temetema꞉gopi wadekobi ebo na꞉midioliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ebe tetelo Ga꞉lili opolo Elodite Kawo Elawodubuma꞉ eda꞉nami. Ebene Ya꞉sute kebe tanalo bilibilinomo kosiyodilolenakile Elodite ebe tanalo olowiote woki bilibilima꞉ ebo ediya, mabu epetapiate negeliya, “Yoneko epo obamo waduba꞉midaoledawate a꞉e magumune emaigi!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ebene epetapiate negeliya, “Ya꞉suko ebe Elayate, Godokono woki awokalimidawala, ebete atamo walo a꞉ka꞉pemaigi,” wiyasiya epetapiate na꞉kegeliya, “Ao, ebe Godokono woki awokalimidawa idila. Aimano ewoniatamo dopamo da꞉pemaimiya, ibino taneba magumulo idawate a꞉e magumune emaigi.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ebene Elodite negiya, “Na Yonekono wato otowamidaimo, wiyasiya me dubu potelela꞉ka꞉ nale ebeno osiyodilole tanalo dolowionamo?” ebema꞉ tete geyageyalo ebe ubila Ya꞉suko kuima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ya꞉sute daliboliya ebe waloma꞉tapi dubate ebetamo walo ka꞉pelamete iba꞉te kebe tanalo bilibilinomo ka꞉nosiyodiloliye ebe ebo pa꞉kiyawaomiya, ebene ebete epo epetapi miyapate ebe waloma꞉tapinomo uwatete iba꞉te Betasaida duliyomolamo gito tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ebema꞉ epo bilibilinomate Ya꞉sukono to tanalo olowite ebeno walogabone na꞉ka꞉tolamoliya, ebene ebete ibi kalakalago uwatete Godote Kawo Elawodawama꞉ deda꞉na ebe tanalo ibi ebo iyatulamiya, ega꞉walo atu tetelo ebete ibino temetema꞉gopi wadekobi ebo ka꞉midioliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Egelate eba niwisiganalo Ya꞉sukono 12 waloma꞉tapiate pelamenate ebe ebo pananiya, “A꞉ma꞉ epo nalibola꞉, iba꞉te iyaiya duliyomolamo ega꞉walo tumu motamo tolamolete bae ega꞉walo lao bai ka꞉nulaema꞉, mabu me epoa꞉ baila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wiyasiya Ya꞉sute iba꞉tamo negeni, “Ao, la꞉le iba꞉tamo nao inamabu nikalamola꞉la꞉.” Iba꞉te nowaiminiya, “Agodolo paibu bae ega꞉walo namo netewa ebenomate pola꞉na. Ebema꞉ a꞉ma꞉ ubila꞉ka꞉ ale tolamete aimano maniamo ibino bae ka꞉nuwateolaema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iba꞉te ma kunu gelaniya mabu 5,000 dubate ebolo pola꞉niya. Ebene Ya꞉sute ebe waloma꞉tapi nanaleni, “La꞉le epo iyaiya taneba osiyodilolete opamo kilukulioma꞉ nanaliyala꞉, iba꞉te taneba idilo 50, taneba idilo 50, ma kunu nilukulioma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ya꞉suko waloma꞉tapiate ebe tabo olowinate eba kunu osiyodiloniya, ebene epo bilibilinomate ibino tanebalo opamo gito ilukulioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ebene Ya꞉sute paibu bae ega꞉walo namo netewa uwatenate, Unu Duliyomolamo melelo Godotamo kalakala tabo genate ebe bae namago wakalamiolenate ebe waloma꞉tapiatamo gito ikalameni iba꞉te epatamo kikalamolenama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ebe tetelo epo bilibilinomate bae denaoniya ibino bae kape tanalo ebo olopoligolameni, ebene Ya꞉suko waloma꞉tapiate da꞉luiliniya ebe bae apuapuamo 12 bagowo ebe owiyaoleniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Egela idilo Ya꞉suko a꞉ka꞉tuwa꞉ diyamoa꞉ opolo Godago tabo eba gelitalo ebeno waloma꞉tapiate ebetamo ebo pemaimiya. Ebene ebete ibi nalateda꞉liya, “Epate na poma꞉ kegelanake?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Iba꞉te negeliya, “Epetapiate a꞉ma꞉ Yoneko obamo waduba꞉midaoledawama꞉ gelanaka, epetapiate Elayako Godokono woki awokalimidawama꞉ gelanaka, ega꞉walo epetapiate a꞉ma꞉ Godokono woki awokalimipiate dopamo aimano ewoniatamo da꞉pemaimiya, ibi magumulo idawate a꞉ene nemaigamu gelanaka.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ebene Ya꞉sute ibi nalateda꞉liya, “Wiyasiya la꞉le na poma꞉ ka꞉midina꞉wenama?” Pitate ebetamo nowamiya, “A꞉ma꞉ Kelisotela, Godokono Alibodawalata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ebene Ya꞉sute ibi kawiya eba analelo negiya, “La꞉ naimano tanaloma꞉ epetapi akokiyawaolama꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ebene ebete tabo moga꞉melo negiya, “Epono Naniwi epagodone kawokawo temeteme walone kuwatemene, Godokono ubila. Iyo, Godotamo kalimagono ikameopino watowatopi, ega꞉walo Godokono Totomu iyatulamepi, ega꞉walo kawokawo dubu epetapi iba꞉te ebe ubia꞉noma꞉ keda꞉oma꞉na꞉, ebene epate ebe kanakapuima꞉na꞉, wiyasiya netewa-kapiya egelalo ebete a꞉ene walo ka꞉kemaigamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ebene ebete ibi bilibilinomatamo negiya, “Kebe lumagite na waloma꞉enema꞉ ubi diyatimene, dopamo ebete ebeno tanalo dodolomatilite, ebene egela bilibilinomolo ebete ebeno kewa olotolowa agute na ebo nowaloma꞉enemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nanitabola, kebe lumagite ebeno igilo nagodone damoeda꞉mene ebeno igilote kalatidimene, wiyasiya kebe lumagite ebeno igilo na mabuma꞉ datutimene ebete nanitabo igilo kelaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ebema꞉ lumagite me opono inamabu bilibilinomo uwatenomo eba uwatelo ebeno igilo datutimene ebeno wiya keleka꞉? Godote lumagigodone ebeno igilo delaemene ebegodolo beda꞉ wade tanalote na꞉kitanamene? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ebema꞉ numa꞉la꞉, kebe lumagite natamo ega꞉walo naimano taboma꞉ dilipomene, na Epono Naniwite atumu ebetamo kilipomamo, iyo, nale naimano alago da꞉pemo, ebe tetelo Nabiwi Godoko ega꞉walo ebeno wade-talena nopopi ibino elawo alonomago pete ebe ka꞉pilipoimamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na la꞉tamo nani tabo gemo, me tetelo dilukuliona ibi epetapiate Godote Kawo Elawodawama꞉ deda꞉na, ebe kawo tanalo dopamo umite walone ebo ka꞉elaoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kapiya wuiki idi dolopoligiya ebe tetelo Ya꞉sute Pitako, Ya꞉imesiko, ega꞉walo Yoneko uwatete unu damela ida꞉mo magataliya, ebete ebolo Godago tabo ka꞉negelama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ebene ebe a꞉ka꞉tuwa꞉ Godago tabo eba gelitalo, ebeno ololo iyama꞉ ebo ediya ega꞉walo ebeno pupuliono inamabute keyakeyaibinomoma꞉ eba eda꞉omelo ebo pukuilamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ebe tetenomolo dubu netewa Elayako ega꞉walo Moseseko, iba꞉te pemaimite Ya꞉suago tabo gelitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Iyo, ibi netewapiate Godokono Unu Duliyomolono alago pemaimite eba꞉go tabo ma kunu gelitiya, Ya꞉sute Godokono nopo epatamo kawokalima꞉ ebete Yelusalema kawo duliyomololo ka꞉emene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitako ega꞉walo ebeno namutupi netewa iba꞉te u eba lautalo me anoano tanalo ebo pemaigiya, ebene iba꞉te ibino balidi paeamidaolete Ya꞉sukono alo ega꞉walo dubu netewa eba꞉go delamota꞉niya ebo ulamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ebene dubu netewate Ya꞉sugodone eba tutalo, Pitate ebe naniya, “Wade Iyatulamedawa, a malo da꞉pola꞉nama꞉, kalakala kawonomola. Modobola, a nupunupu netewa-kapiya ketemotemalema꞉, idi a꞉imanola, idi Mosesekonola, idi Elayakonola.” Pitate kimalagidiloa꞉no me tabo ebema꞉ giya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitate tabo eba kiyawautalo temate pete ibi gito panalopamidaliya, ebema꞉ iba꞉te na꞉toletoleutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ebene tema magumune tabote ma kunu pemaigiya, “Me naimano Gudula, nale ebe dopamo eka꞉miyamo! La꞉ ebeno tabo nolowiala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ebe tabote dolopoligiya iba꞉te Ya꞉suko kapiya umiya, ebene tete geyageyadopolo ebe waloma꞉tapiate kebe tanalo kumiye iba꞉te epo epetapi kanaliya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ebe egela idilo iba꞉te unu damelane da꞉piwitiya epo bilibilinomate pelamete Ya꞉suago gito palugiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ebene ibi magumulo kapiya dubute kawonomamo ebo gepatiya, “Iyatulamedawa, naimano guduno tanaloma꞉ a꞉ma꞉ toweoemata mabu ebe naimano kapiya gudunomola! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kuba uliyanate geatepago ebe delawenako, gudute opamo deganako ebeno apete kodakodanomoma꞉ eda꞉menako ebene ebeno tabone pakote pemaiminako, ega꞉walo ebe lawe tetelo kuba uliyanate naimano gudu samamo katepanakoa꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ebema꞉ nale a꞉ma꞉ waloma꞉tapi a꞉toweolama꞉kamo iba꞉te kuba uliyana kaliboma꞉, wiyasiya iba꞉godolo elawo puliyala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ya꞉sute wiyasiya ibi bilibilinomatamo negiya, “Eiye, la꞉ nanitabokobi midia꞉ kubakuba epolata! La꞉ natamo mibo ikanamenamata, ebema꞉ na ubia꞉nola tete geyageyalo la꞉go okolinama꞉!” Ebene ebete dubutamo negiya, “A꞉imano gudu mamo nemaga꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ebe tetelo koite eba penapelo kuba uliyanate ebe lawete opamo gito ba꞉idiliya, ebene koite kubanomamo ebo wageleiya. Ebene Ya꞉sute kuba uliyana kawiya daniya, ebe tetelo koite wadekobi olowite Ya꞉sute ebe ebeno nabiwitamo gito ikamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ebema꞉ ebe tanalo dumiya ebe epo bilibilinomate Godokono kawo elawo tanaloma꞉ nanoanoutiya. Ebema꞉ epate Ya꞉sukono osiyodilole tanalo bilibilinomoma꞉ eba anoanoutalo, ebe tetelo Ya꞉sute ebe waloma꞉tapiatamo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nale me tetelo la꞉tamo da꞉kiyawaomo, ebe tabo wadenomamo olowiawete akododomatiala꞉ — Godote Epono Naniwi kubakuba epono kotamo kiyatimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ebe tetelo iba꞉te ebe tabono magumu wadenomamo kemalagidiliya꞉ mabu wamina magumulo itanami, wiyasiya iba꞉te iyatawa꞉noma꞉ eba eda꞉olo me tabono magumu tanaloma꞉ Ya꞉suko anama꞉ na꞉toletoleutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ebene waloma꞉tapiate ibino taneba magumulo potele kawoma꞉ eda꞉ma꞉ apamiteuitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iba꞉te ibino tepo magumulo demalagidilutiya Ya꞉sute ebe tanalo iyatawiya, ebema꞉ ebete gudu lawete ebe balamo eba adipilo ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","iba꞉tamo negiya, “Kebe lumagite naimano mailamo mako gudu da꞉peso kalakalago dowalubina ebete na walubinina, ega꞉walo kebe lumagite na dowalubinina, ebete na kapiya kowalubinina꞉, ebete na Alibonedawa Godoko atumu na꞉kowalubina. Ebema꞉ la꞉imano taneba magumulo potele da꞉pesodawanomoma꞉ deda꞉mene ebe dawate kawonomoma꞉ keda꞉mene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ebene Yonete negiya, “Wade Iyatulamedawa, ale dubu idi uima꞉ ebete a꞉imano mailamo kubakuba uliyana daliboliti, wiyasiya ale ebe kawiya anima꞉ ebe tanalo katepama꞉ mabu ebe aimano taneba lumagia꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wiyasiya Ya꞉sute iba꞉tamo negiya, “La꞉le ebe ako-odiyobala꞉, mabu kebe lumagite la꞉go gowelaoa꞉dawama꞉ deda꞉na, ebete la꞉ walubilinata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ebene Ya꞉sute Godokono Unu Duliyomolamo nodolo tete detataliya, ebete ebe tanalo iyatawate ebeno woki kawonomamo ebo iyatiya Yelusalema kawo duliyomolamo ka꞉toma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ebene gabo tetelo ebete Samaliya opono duliyomolo ida꞉mo nopo atapi dopamo aliboliya, iba꞉te ebolo ebeno wata bai ega꞉walo bae ka꞉nosiyodilolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wiyasiya ebe duliyomolo epate iyatawaiya Ya꞉sute Yelusalemamo tolame gabodo da꞉tuti, ebema꞉ iba꞉te ebetamo ubia꞉ tabo geliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ebene Ya꞉imesiko ega꞉walo Yoneko, iba꞉te me tanalo umite negeliya, “Kawodawa, modobola꞉ka꞉ a Godoko kanama꞉ ebete Unu Duliyomolone ela palibote ibi ka꞉kubailaema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wiyasiya Ya꞉sute ibi netewapiatamo olobigate ibi kawonomamo eba analelo iba꞉tamo negiya, “Mabu keleka꞉ la꞉le na kuba wokiamo danana꞉ema? Mabu la꞉imano tepo magumuno woki ega꞉walo naimano tepo magumuno woki iyaiya ba꞉pola꞉na! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na Epono Naniwite epo kubailaema꞉ ka꞉piya꞉, wiyasiya nale ibino igilo mula꞉lelaema꞉ piyamo.” Ebete ebe tabo gete, iba꞉te duliyomolo ida꞉mo laoma꞉ gito tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iba꞉te eba tolamitalo dubu idite Ya꞉sutamo negiya, “A꞉ma꞉ keba apuamo da꞉toaemene, nale a꞉ma꞉ ebamo kowaloma꞉tamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Wiyasiya Ya꞉sute ebetamo negiya, “Iyaiya, a꞉ma꞉ dopamo me tanalo idi wadenomamo nemalagidila. Tumu gaagaano lao bai damela gugu ba꞉pola꞉lamena ega꞉walo olaolate ibino moto etemoteonaka, wiyasiya na Epono Naniwi, naimano wata bai puliyala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ebene Ya꞉sute dubu iditamo negiya, “A꞉ma꞉ na nowaloma꞉ena꞉.” Ebete wiyasiya Ya꞉sutamo negiya, “Kawodawa, modobola na dopamo tote, naimano kadele nabiwite da꞉emene, nale ebeno ape bobamo niyatite na walone a꞉ma꞉ kowaloma꞉emamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ya꞉sute ebetamo nowamiya, “Modobola a꞉elao epate ibi a꞉ka꞉tuwa꞉ ibino a꞉elaopi bobamo nalomoma꞉na꞉, wiyasiya a꞉ma꞉ toawete Godote Kawo Elawodawama꞉ deda꞉na ebe tanalono tabo epatamo na꞉nikiyawaonakiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ebene dubu idite negiya, “Kawodawa, na ubila a꞉ma꞉ kowaloma꞉etama꞉, wiyasiya modobola na dopamo tote naimano moto epatamo yawo tabo ka꞉negemamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Wiyasiya Ya꞉sute ebetamo negiya, “Kebe lumagite damela maboeleno inamabuamo pali woko eba wagilimilo, duliyomolono iyaiya tanalo malagidilolete wokone walo da꞉kolobigamene, ebako lumagite Kawo Elawodawa Godokono woko osiyodiloma꞉ a꞉ka꞉modobomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Me tabo dolopoligiya ebe tetelo Kawodawa Ya꞉sute 72 waloma꞉tapi epetapi uwatete epetapi netewa, epetapi netewa, ma kunu dopamo aliboliya, ebete da꞉tomene ebe duliyomolo bilibilinomamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ebete iba꞉tamo negiya, “Godokono pali magumulo kono bilibilinomo a꞉kodakodaiya, wiyasiya wakalami wokopi bilibilia꞉, ebema꞉ la꞉ pali namutudawatamo towetowe tabo negelala꞉, ebete wokopi epetapi pali magumamo kapalibolemene wadewade naono kono ka꞉powakalamima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ebema꞉ la꞉ na꞉tolama꞉la꞉! La꞉ sipi-goeogoeo egege keba kunula꞉ka꞉ eba kunula, nale la꞉ elawoelawo gaagaano taneba magumamo alibolemata. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","La꞉ mani alomono gatele akouwata꞉la꞉, ega꞉walo la꞉ bae alomono ikuwa ega꞉walo agowa pata akouwata꞉la꞉. Ega꞉walo la꞉ gabo tetelo lumagi ida꞉go danalugaema eba꞉go tabo eba negelalo la꞉imano woko tete akonikubaima꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ebene la꞉ kebe motamo da꞉nodoloaema, modobola la꞉ ebe moto epatamo nilakapo tabo na꞉negeliyala꞉ ma kunu, ‘Godokono kalakalate la꞉imano motolo nitanamene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ebema꞉ Godokono gelebadi lumagite ebolo dokolina, Godokono kalakalate ebegodolo nanitabolo kitanamene, wiyasiya ebako lumagite ebe motolo okolita꞉no, la꞉ nilakapo tabo degelaema ebe tabono nanitabo tanalote ebolo a꞉kitanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","La꞉ ebe moto kapiyalo na꞉nilukuliniyala꞉, ebene iba꞉te la꞉tamo dikalamoletamene ebe bae nawete ibino obo atumu na꞉ka꞉niyala꞉, mabu la꞉ wokopiate ebako wiya laema꞉ modobola, ega꞉walo duliyomolo ida꞉mo tolame tete pemaiga꞉no la꞉ moto idine moto ida꞉mo eba kunu akonowagela꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Iyo, la꞉le duliyomolo ida꞉mo tolama꞉wete iba꞉te la꞉ kalakalago duwatetamene, ebe tetelo iba꞉te kebe nao inamabu la꞉tamo dikalametamene kalakalago nenaiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ega꞉walo ebe duliyomololo dilukulina la꞉ ebe temetema꞉gopi wadekobi midiola꞉wete duliyomolo epo bilibilinomatamo ma kunu negeliyala꞉, ‘Godote Kawo Elawodawama꞉ deda꞉na ebe tanalote la꞉tamo etatali.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wiyasiya la꞉ duliyomolo ida꞉mo nemaima꞉wete iba꞉te la꞉ kalakalago uwateta꞉no, la꞉ ebe duliyomolo tulitulinomolo eba lamota꞉onalo ibi bilibilinomatamo ma kunu negeliyala꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘La꞉imano duliyomolono damela tuwae aimano agowane na꞉moda꞉midatepaolema꞉, mabu me tanalote la꞉ iyatulamitata Godokono tete ebe na꞉pe ebete la꞉imano tanalo kapanagilamelelametama꞉. Ebema꞉ me kawo tanalo akododomatiala꞉, Godokono Kawo Elawodawano tete la꞉tamo etatali!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ebene Ya꞉sute ebe waloma꞉tapiatamo negiya, “Na la꞉tamo nani tabo gemo, Godote epono tanalo danagilamelelaemene, ebe Kawo Egelalo ebete me duliyomolo epatamo kuba wiya kawonomamo kikalaemene. Ebe tetelo ebete Sodomo duliyomolo epatamo kuba wiya eba ikalamelo nilakapo kela꞉mo kawokalimene, wiyasiya nanitabola, ebete nilakapo a꞉kiyatimene me kuba epatamo!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ebene Ya꞉sute walo na꞉kegiya, “Kolasini duliyomolo, a꞉ma꞉ kuba wiya kawonomo kelaema꞉ta! Betasaida duliyomolo, a꞉ma꞉ ebe atumu! Mabu nale la꞉godolo anoano tanalo dosiyodilolimo, la꞉ ebe tetelo la꞉imano kubane kolobila꞉wea꞉. Wiyasiya nale ebakobako woko Taya duliyomololo ega꞉walo Saidono duliyomololo dopamo nosiyodiloliyataleka꞉, ebe Yua꞉ epate ibino kubakuba woki iyakobi ba꞉midiliyana꞉. Iyo, iba꞉te ibino kuba osiyodilole mabuma꞉ tepo temetemema꞉ eda꞉ote ebe temeteme kawokalima꞉ kubakuba kaliku pupuliote ono tuwaeamo gito bilukuliyana꞉ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ebema꞉ Godote epono tanalo danagilamelelaemene, ebe Kawo Egelalo ebete Taya duliyomolo epatamo ega꞉walo Saidono duliyomolo epatamo kuba wiya eba ikalamelo nilakapo kela꞉mo kawokalimene, wiyasiya nanitabola, Kolasini duliyomolo ega꞉walo Betasaida duliyomolo, ebete la꞉tamo nilakapo a꞉kiyatimene! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ega꞉walo Kapeniyama duliyomolo, a꞉imano tanalo ma kunula. A꞉ma꞉ ubila a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉ma꞉ Godokono Unu Duliyomolamo kadipata꞉ema꞉, wiyasiya Godote a꞉ma꞉ Ela Opamo keba꞉idiloma꞉ta!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ebene Ya꞉sute tabo moga꞉melo ebe waloma꞉tapiatamo negiya, “Kebe lumagite la꞉imano tabo dolowimene ebete ebe tanalo magumulo naimano tabo kolowimene, wiyasiya kebe lumagite la꞉ ubia꞉noma꞉ deda꞉mene ebete ebe tanalo magumulo na ubia꞉noma꞉ keda꞉mene, ega꞉walo kebe lumagite na ubia꞉noma꞉ deda꞉mene ebete na kapiya ubia꞉noma꞉ a꞉keda꞉mene, ebete na Alibonedawa Godoko atumu ubia꞉noma꞉ ka꞉keda꞉mene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ebene Ya꞉sute daliboliya ebe 72 dubate tolamete iyaiya duliyomololo woko nosiyodilote, iba꞉te da꞉kolowamiya kawo kalakalanomago ebetamo na꞉pegeliya, “Kawodawa, ale kubakuba uliyana a꞉imano mailamo kawiya dananalima꞉ iba꞉te aimano tabamo tudila꞉ote epagodone a꞉nemaimiya!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ya꞉sute iba꞉tamo eba wiyalo negiya, “Nanitabola, Godote Saitanako elawoa꞉kobi midite Unu Duliyomolone da꞉peba꞉idili nale uimo, iyo, molete keba kunu ka꞉la꞉uwa꞉midanakole ebete opamo samonomamo eba kunu pegi. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","La꞉ wadenomamo nolowiala꞉! Na elawo la꞉tamo ikalaimata la꞉le kalu ega꞉walo gopowaidubu la꞉imano agowamo ka꞉mikitaola꞉wenakoma꞉, ebe elawote la꞉imano gowelaodawa Saitanakono elawo nodoliona, ebema꞉ inamabu idite la꞉ a꞉ka꞉kubailametamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ega꞉walo me tanalo idila. Kuba uliyanate la꞉imano tabamo da꞉tudila꞉onaka ebe mabuma꞉ akokalakalala꞉, wiyasiya Godote la꞉imano mailo ebeno Unu Duliyomolono Bukamo dakulolelametiyala la꞉ ebe mabuma꞉ nekalakalala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ebe tetelo Godokono Uliyanate Ya꞉sukono tepo magumulo detabokiya ebete Godotamo kalakalago negiya, “Aba, a꞉ma꞉ me opo kawonomo ega꞉walo Unu Duliyomolo Namutudawama꞉ eda꞉nata! Na a꞉ma꞉tamo kalakala tabo gemo, mabu a꞉ma꞉ me opono kawokawo iyatawaopi dubatamo a꞉imano mulo woki eba waminaolelo iyatawa꞉ epatamo awokalilamiata. Aba, nanitabola, me tanalote a꞉imano ubilo pemaigi.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ebene Ya꞉sute epatamo negiya, “Naimano Nabiwi Godote tanalo bilibilinomo naimano kotamo alomiya nale kulamenama꞉, ebema꞉ ebete a꞉ka꞉tuwa꞉ iyatawala na ebeno Guduno tanalo, lumagi idite iyatawa꞉. Ega꞉walo Nabiwino tanalo atumu, lumagi idite iyatawa꞉ wiyasiya na ebeno Gudute a꞉ka꞉tuwa꞉ iyatawala, ega꞉walo nale piyatamo awokalima꞉ ubi diyatimo, ibinomate atumu Nabiwino tanalo ka꞉kiyatawaoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ebene Ya꞉sute ebeno waloma꞉tapiatamo polobigate tabo diya ebo analiya, “Godokono kalakala kawonomo la꞉godolo bitana, mabu la꞉ la꞉imano balida꞉mo ebeno iyaiya tanalo wadenomamo nulamenamata! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ebema꞉ nale la꞉ analemata, dopamo tetelo Godokono woki awokalimipi ega꞉walo kawokawo elawodubu iba꞉te ubi kawonomo iyatinamiya la꞉le dulama꞉wenama ebe kawokawo tanalo ulaema꞉, wiyasiya iba꞉te ka꞉modobiya꞉, ega꞉walo ibi ubila la꞉le dolowiawenama ebe tanalo kolowioma꞉, wiyasiya iba꞉te ka꞉modobiya꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ebene Godokono Totomu iyatulamedawa idi ubila Ya꞉sukono mulo tanalo ka꞉puima꞉, da꞉ nanitabola꞉ o da꞉ nanitaboa꞉, ebema꞉ ebete pete ebetamo na꞉pegiya, “Iyatulamedawa, na beda꞉ tanalo osiyodilote uwomua꞉ igilo ebo na꞉kelaemo?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ya꞉sute ebeno tabo eba wiyalo negiya, “Godote Bukamo ebeno Totomu Tabo dakuloliya, ebe tanalate a keba kunu kiyatuamenale? Ebe iyaiya tanalono magumu keba kunula꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ebe dubute nowamiya, “Godokono Bukate ma kunu gena, ‘A꞉ma꞉ a꞉imano Kawodawa Godoko nilakapolo nemalagidilona, a꞉imano tepo magumunomamo ega꞉walo a꞉imano uliyanano elawamo, a꞉imano elawo kawonomamo ega꞉walo a꞉imano woki kawonomamo,’ ega꞉walo totomu tabo idi ma kunu bitana, ‘A꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉ma꞉ demalagidilawena, modobola a꞉ma꞉le eba kunu a꞉ma꞉ niyakabolo dokolina ebe lumagi nilakapolo nemalagidilona.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ebene Ya꞉sute ebetamo negiya, “A꞉ma꞉ nani tabo geata. A꞉ma꞉ me tanalo osiyodilawete ebo bigilonama꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ebe dubute Ya꞉sukono taboma꞉ ilipote wiyasiya ebeno ilipo waminalo ma kunu giya, “Na niyakabolo dokolina, ebe lumagi potelela꞉ka꞉? Na poko na꞉kowalubinamo?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ya꞉sute ebeno tabo eba wiyalo negiya, “Dubu idite Yelusalema kawo duliyomolone Yeliko duliyomolamo eba niwisigitalo pilo dubate ebe lawete ebeno pupuliono inamabu pupukulamelemete ebe ebo anagalimiya. Ebene ebeno elawote dolopoligi iba꞉te ebe ebamo atepapate gito tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ebe tetelo Godotamo kalimagono ikameodawate ebe gabodo eba pitalo ebe pumite niyakabodo gito nodoliatepi. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ebene Libai gudawate ka꞉pete atumu ka꞉powageli. Dubute dekapitani ebete ebamo pemaigate ebe ebo pumi, wiyasiya ebete walubi ebetamo ka꞉piyatia꞉, gito ka꞉nodoliatepi. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ebene ebe gabodo da꞉piti, dubu idi ebe Yu lumagia꞉, ebe Samaliya opo dubula, ebete ebamo pemaigate ebe dubu da꞉pumi ebeno tepo magumulo nilakapo kawonomo piyati. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ebete ebetamo pete olibi kikopuno ii ega꞉walo wade mulamula ebeno bugomamo abutilamelemete kaliku apuapuamo gito matuolamolemi. Ebene ebete ebe dubu ebeno donoki-goeo unamo adipite duliyomolo ida꞉mo ebo magati, ebe duliyomololo kapela epate delaonaka ebete ebe motolo ebe dubu wadenomamo nowalubi. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Egela idilo Samaliya opo dubute netewa mani moto namutudawatamo eba ikamelo negi, ‘A꞉ma꞉ me dubu wadenomamo nowalubinatiye. Me manite modoboa꞉no, nale walo da꞉ka꞉pemo a꞉ma꞉tamo walo ka꞉ka꞉pa꞉wiyamo.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ebene Ya꞉sute tabo moga꞉melo Godokono Totomu iyatulamedawatamo negiya, “A꞉imano woki keba kunula꞉ka꞉? Pilo dubate danagalimiya ebe dubutamo netewa-kapiyate da꞉pelamiya, ibi magumulo potele ebe walubidawama꞉ ka꞉pedile? Ega꞉walo ebe niyakabolo dokolina ebako lumagimu potele ka꞉pedile ebetamo nilakapo kawokalima꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ebene Godokono Totomu iyatulamedawate tabo eba wiyalo negiya, “Yua꞉ lumagi kapiyate ebe kawonomamo pa꞉nilakapoimi.” Ebene Ya꞉sute negiya, “A꞉imano tabo nanitabola. Modobola, a꞉ma꞉ toawete epatamo nilakapo ma kunu nanawokaliminakiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ya꞉sute ebeno waloma꞉tapiago Yelusalema gabodo eba tolamitalo iba꞉te duliyomolo ida꞉mo da꞉nemaimiya, ebe tetelo kamiyale idi ebeno mailo Matatela ebete Ya꞉suko kalakalago naniya ebete ebeno motolo bae ka꞉penama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Matakono ekawino mailo Ma꞉litela, ebene Ya꞉sute motamo da꞉nodoliya Ma꞉lite ebeno agowa mabuamo pokolite Kawodawa Ya꞉sukono iyatumi tanalo wadenomamo olowiuti. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Wiyasiya Matate a꞉ka꞉tuwa꞉ bae okalimi tanalo eba osiyodilutalo ebe ubia꞉noma꞉ eda꞉te Ya꞉suko ebo paniya, “Kawodawa, a꞉ma꞉ na꞉kuma꞉wita naimano ekawite na kowalubinita꞉? Tanalo bilibilinomo na a꞉ka꞉tuwa꞉ osiyodilolitamo, ebema꞉ modobola a꞉ma꞉ ebe nana, ebete pete na na꞉powalubinina!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kawodawa Ya꞉sute ebeno tabo eba wiyalo negiya, “Mata, Mata! A꞉ma꞉ egege tanalo bilibilinomo osiyodilolema꞉ woki bilibilinomoma꞉ editata. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wiyasiya kapiya tanalote kawonomoma꞉ deda꞉na, Ma꞉lite ebe wade tanalo umite elawe, epate walone ebegodone a꞉kelaema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Egela idilo Ya꞉sute diyamoa꞉ opolo Godago tabo gelitiya. Ebe tanalo dolopoligiya ebe waloma꞉tapi magumulo idawate ebe naniya, “Kawodawa, Yonete ebe waloma꞉tapi iyatulami iba꞉te Godotamo keba kunu da꞉towetoweonakoma꞉na꞉, ebema꞉ modobola a꞉ma꞉ a ebe atu tanalo na꞉kiyatuama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ebene Ya꞉sute iba꞉tamo negiya, “La꞉ Godotamo towetowe tabo ma kunu negelanakiyala꞉, ‘Aimano Nabiwi, modobola a꞉imano talena mailo epate nadipatema꞉na꞉, ega꞉walo modobola a꞉ma꞉le Kawo Elawodawama꞉ deda꞉wena ebe tanalote napawokalamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","‘Ega꞉walo modobola a꞉ma꞉ me egelano bae atamo modobolo nikaeama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ega꞉walo epetapiate atamo kuba dosiyodilolena, ale ebe kuba egebolelamete ka꞉dodolomatililaemalema꞉, ebema꞉ modobola a꞉ma꞉ atumu aimano kuba egeboleama꞉wete na꞉dodolomatiliama꞉. ‘Ega꞉walo Saitanakono kuba gabamo wabuga꞉ta magumulo a꞉ma꞉le wiyasiya a eba walubilo a꞉imano wade gabodo nemagataenakiye.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ebene Ya꞉sute iba꞉tamo negiya, “Diyala, la꞉ magumulo lumagi idite sele tetenomolo ebeno namutudawatamo tote ma kunu da꞉negemene, ‘Naimano namutudawa, modobola꞉ka꞉ a꞉ma꞉le na nowalubina꞉? Natamo netewa-kapiya bae apuapu nikanama꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mabu naimano lumagite mulu opone walo a꞉kolowami, wiyasiya nagodolo bae puliyanomola nale ebetamo ikaema꞉!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Wiyasiya moto gulo da꞉luta, ebete tabo ma kunu kegemene, ‘Ao, a꞉ma꞉ temeteme natamo akoikanama꞉la꞉. Na gigiyu a꞉kodakodaiminakamo, ega꞉walo na atumu guda꞉go nowatanamo, ebema꞉ modoboa꞉ nale maigate bae a꞉ma꞉tamo ikaema꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Wiyasiya a꞉ma꞉le a꞉imano namutudawa toweome tanalo atepa꞉no, a꞉ma꞉tamo beda꞉ tanalote na꞉ka꞉pemaigamene? Iyo, ebete maigate a꞉imano iyaiya modoboa꞉ tanalo ka꞉modoboilaemene, wiyasiya ebete a꞉ma꞉tamo bae eba ikamelo a꞉ma꞉ ebeno namutudawama꞉ a꞉kegemene, mabu ebegodolo kalakala puliyala. Ebema꞉ mabu keleka꞉ ebete a꞉ma꞉tamo walubi diyatimene? Mabu a꞉ma꞉ towetowedawagodolo ilipo tanalo kitana꞉, ebete a꞉ma꞉ ebe mabunomoma꞉ kowalubima꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ebene ebe tabono magumu eba awokalimilo Ya꞉sute negiya, “Nale la꞉tamo gemo, la꞉ Godoko na꞉toweoma꞉la꞉, ebete la꞉tamo kikalaema꞉ta. Iyo, la꞉ ebeno wade tanalo nowadiala꞉, la꞉le kuimamota, ega꞉walo la꞉ gigiyu nanakamiala꞉, ebete la꞉tamo ka꞉iyamidamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Numa꞉la꞉, piyate Godoko da꞉toweomenaka iba꞉te ebegodone kelaema꞉na꞉, ega꞉walo piyate ebeno wade tanalo dowadinaka iba꞉te kuima꞉na꞉, ega꞉walo piyate gigiyu danakaminaka ebete iba꞉tamo ka꞉iyamidamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","La꞉ magumulo kebe dubu ebeno gudute ebe namoma꞉ da꞉toweoemene, wiyasiya ebetamo bu kalu ba꞉kikaemene? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ega꞉walo a꞉imano gudute a꞉ma꞉ kakaba kikopuma꞉ da꞉toweometamene, a꞉ma꞉ wiyasiya ebetamo gopowaidubu ba꞉kikama꞉emene? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Numa꞉la꞉, la꞉ wadewade epoa꞉ wiyasiya la꞉ iyatawalata la꞉imano guda꞉tamo wadewade bae ikalaema꞉, ebema꞉ la꞉imano Unu Duliyomolono Nabiwi atumu iyatawanomola ebeno Wade-talena Uliyana epatamo ikalaema꞉, piyate ebe da꞉toweomenaka iba꞉tamo kikalaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ebe tetelo tabo kiyawaoa꞉ kuba uliyanagono dubu ebolo okolinami, ebene Ya꞉sute ebegodone kuba uliyana dalibiya ebete tabo kiyawao ebo wagilimiya. Ebema꞉ epo bilibilinomo epetapiate Ya꞉sukono tanaloma꞉ eba anoanoutalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","wiyasiya epetapiate negelitiya, “Biyesibulukono elawote ebegodolo bitana. Ebete kubakuba uliyanano Kawodawano elawamo alibolenako, Godokono elawamoa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ebe tetelo epetapiate ubi iyatiya Ya꞉suko kuba gabamo kowabuga꞉tama꞉, ebema꞉ iba꞉te ebe naniya, “A꞉ma꞉godolo Godokono elawo nanitabolo ditana, anoano tanalo idi nosiyodila ebe tanalo atamo kawokalima꞉ema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ebema꞉ Ya꞉sute ibino kuba woki iyatawate iba꞉tamo negiya, “Numa꞉la꞉, kapiya duliyomolono epate tetedo dadikanalema꞉na꞉ ebe duliyomolote ka꞉kubamene, ega꞉walo kapiya motono epate tetedo dadikanalema꞉na꞉ ibino motote opamo kekagamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ebema꞉ Saitanakono woki ma kunula, ebete ebeno kubakuba uliyana epagodone akalibola꞉le, mabu ebete eba kunu dowagelemene ebeno woko osiyodilo elawote kolopoligomene. La꞉le naimano tanaloma꞉ negelamata, ‘Ebete kubakuba uliyana Biyesibulukono elawamo alibolenako.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ebe tabo degelaema nanitabola꞉ka꞉? Ao, nanitaboa꞉. La꞉imano tanebapiate kubakuba uliyana dalibolenaka, ebe elawo iba꞉tamo potele kikalamenakole? Iyo, Godotela, Saitanatea꞉! Ebema꞉ ebe la꞉imano tanebapino wade osiyodilo tanalote la꞉imano kuba woki awokalimina. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Me tanalo nanitabola, nale kubakuba uliyana Godokono elawamo epagodone alibolenakomo, ebema꞉ modobola la꞉ me tanalone kiyatawaomamota, Godokono Kawo Elawodawano tetete la꞉tamo ebe a꞉pe. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Numa꞉la꞉, Saitanako ebe elawodubu idi keba kunula꞉ka꞉ eba kunula, ega꞉walo ebete pilolo duwatiya ebe epo ebe ebeno motono inamabula. Ebema꞉ kebe tetelo elawo dubute ebeno gowelaono inamabu uwatete ebe a꞉ka꞉tuwa꞉ ebeno moto wadenomamo datila꞉namene, motono inamabuate wadenomamo ka꞉pola꞉nama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wiyasiya dubu idi ebeno elawote dopo dubuno elawo dodolina, ebe dubute pete gowela tanalo eba posiyodilolo dopo dubu kapanagalimiomene. Ebene ebete ebe dubuno gowelao inamabu ega꞉walo motono inamabu uwatete ebeno namutupiatamo kanalabaolaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nanitabola, kebe lumagite na walubinia꞉no ebete naimano gowelaodawama꞉ eda꞉na, ma kunu ebete epo kapiya baiamo magaelema꞉ nago woko osiyodiloa꞉no wiyasiya ibi iyaiya alibolenako.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ebene Ya꞉sute negiya, “Kuba uliyanate lumagi idigodone da꞉nemaigamene, ebe tetelo ebete gagale opamo tote okoli bai idi kowadinatomene. Wiyasiya ebete wade okoli bai numia꞉no ebe a꞉ka꞉tuwa꞉ ebetamo kegemene, ‘Nale datepimo ebe atu okoli baiamo walo ka꞉ka꞉tomamo.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ebete walo ka꞉pete ebe okoli moto wadenomamo moda꞉midala ega꞉walo inamabu wadenomamo alomola, ebete ebe moto eba kunu da꞉ka꞉puimene, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ebene ebete walo ka꞉tote sebeni kuba uliyana epetapi kanadabuilite ka꞉kemagaelemene, iba꞉te ebe motamo podolote ebolo kilukulinama꞉. Numa꞉la꞉, walone da꞉pelaema꞉na꞉ ebe kuba uliyanate kawokawo kuba ba꞉posiyodilolenakoma꞉na꞉, dopamo dokolinami ebe kapiya kuba uliyanano okoli eba kunua꞉. O ebe lumagi niyala! Ebe dopamo kela꞉mo kubadopola, wiyasiya me tetelo ebete kubanomoma꞉ eda꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ya꞉sute me tabo eba kiyawautalo, epo magumulo kamiyale idite ebetamo kawonomamo negiya, “A꞉ma꞉ dalaimitiyala ega꞉walo nono a꞉ma꞉tamo dikametiyala, ebe kamiyaleno kalakala beda꞉ kawonomola꞉ka꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wiyasiya Ya꞉sute negiya, “Modobola a꞉ma꞉ nanitabo tanalo idi nemalagidila. Piyate Godokono tabo olowiote ebetamo da꞉tudila꞉oma꞉na꞉, ebeno nanitabo kalakalate ebe epo kapiyagodolo bitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Epo bilibilinomate Ya꞉suko a꞉wa꞉midate eba lamota꞉onalo ebete iba꞉tamo negiya, “Me tete epo kubakubanomola! Ibi ubi kawonomola Godokono elawo awokalimino anoano tanalo kuima꞉, wiyasiya Godote tanalo idi iba꞉tamo akawokalimene. Nanitabola, ebete ebeno woki awokalimidawa Yaonado dawokalimiya, ebe anoano tanalo kapiya iba꞉tamo ikalamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iyo, Godote Yaonakono okoli tanalodo Niniba kawo duliyomolo epatamo ebeno elawo awokalimiya, ebene ebete atumu Epono Naniwido ebeno elawo walo kakawokalimene me tetelo dilukuliona ebe epatamo, wiyasiya anoano tanalo idi iba꞉tamo a꞉kosiyodilomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Ega꞉walo me tanalo idila. Godote epono tanalo danagilamelelaemene, ebe Kawo Egelalo Siba opo epono Kawo Elawo Kamiyalete maigate la꞉ Yu epo kubakubapima꞉ keka꞉la꞉ima꞉ta, mabu ebe Yua꞉ kamiyalete mulu oponomone piya Isalaela opamo Kawo Elawodubu Solomonokono mulo tabo ka꞉polowioma꞉. Ebe tetelo ebe ubila Godokono mulo Solomonogodone laema꞉, wiyasiya la꞉ tetelo Godote Epono Naniwino tanalo la꞉tamo eba awokaliminalo, la꞉ ebe tanalo ubia꞉nola. La꞉ numa꞉la꞉, Epono Naniwino mulote Solomonokono mulo nodoliona! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ega꞉walo Godokono Kawo Egelalo Niniba duliyomolo epate maimiote la꞉ atumu kubakubapima꞉ keka꞉la꞉ima꞉ta, mabu ebe Yua꞉ epate Yaonakono tabo dolowiya iba꞉te ibino kubane Godotamo olobiliya. Ebe tetelo ibi ubila Godokono tabo Yaonagodone laema꞉, wiyasiya la꞉ tetelo Godote Epono Naniwino tanalo la꞉tamo eba awokaliminalo, la꞉ ebe tanalo ubia꞉nola. La꞉ numa꞉la꞉, Epono Naniwino elawote Yaonakono elawo nodoliona!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ebene Ya꞉sute negiya, “Lumagite ebeno wuiki alo pite wamina baiamo a꞉kiyatimene, ega꞉walo ebete bagowo magumamo a꞉kiyatimene, wiyasiya ebete awokala baiamo kiyatimene, ebene epate ebeno moto guamo da꞉nodoloma꞉na꞉ iba꞉te ebe wade alo ebo ka꞉nuima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“A꞉imano apeno alo ebe a꞉imano balidila. Ebema꞉ a꞉imano balidite wadenomamo da꞉pukuilaemene a꞉imano tepo magumuno alote atumu wadenomamo ka꞉ka꞉pukuilaemene, wiyasiya balidite wadenomamo pukuilamea꞉no a꞉imano ape kawonomote idoko magumulo kitanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ebema꞉ a꞉ma꞉ nanisiwale, a꞉imano tepo magumuno alote idokoma꞉ akoeda꞉la꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","A꞉imano ape kawonomote alo magumulo ditanamene ega꞉walo a꞉imano ape apu idoko magumulo itana꞉no, ebe tetelo a꞉ma꞉ kawonomamo ka꞉pukuilaema꞉ta, wade wuiki alote a꞉ma꞉ da꞉pukuimitana eba kunu.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ya꞉sukono tabo kiyawao dolopoligiya Pa꞉lisi tanebapi dubu idite ebe naniya ebete ebegodolo bae ka꞉penama꞉, ebene Ya꞉sute ebe dubuno motamo nodolote bae nama꞉ gito nokoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Wiyasiya Ya꞉sute ebeno koto ukulalea꞉no bae nama꞉ da꞉nokoliya, ebema꞉ ebe Pa꞉lisi tanebapi dubute kawiya la꞉wiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ebene Ya꞉sute ebe naniya, “La꞉ Pa꞉lisi tanebapi la꞉imano kalili ega꞉walo meleki unu apu ukulalenakomata, wiyasiya la꞉imano tepo magumulo da꞉pola꞉na ebe inamabu kukulala꞉wenakoa꞉, ebema꞉ la꞉le dosiyodilola꞉wenakoma ebe pilo tanalo ega꞉walo kawokawo kuba osiyodilole tanalo epetapi tabokaonomola! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Eiye, la꞉ daedale epolata! Godote lumagino unu tama osiyodilote ega꞉walo magumu ako-osiyodiliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ebema꞉ modobola la꞉imano melekilo ega꞉walo kalililo beda꞉ inamabuate ka꞉pola꞉nale, la꞉ inamabua꞉piatamo gito nikalamola꞉la꞉! Iyo, ebe tanalo magumudo la꞉le la꞉imano tepo magumuno kuba kukulalemamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nanitabola, la꞉ Pa꞉lisi tanebapi kuba wiya kawonomo kelaemamota! La꞉ la꞉imano pali inamabu bilibilinomo magumulo teni apuapu eba anagilamolelo Godotamo ebeno apu wadenomamo ikameonakomata. Ebe tanalo magumulo la꞉ kapiya tanalo da꞉pesonomo kawotawenakoa꞉, wiyasiya kawokawo tanalonomo epetapi osiyodilolema꞉ la꞉ wadenomamo kemalagidilola꞉wena꞉, ma kunu la꞉ epagodolo tuputupulo kilukula꞉wena꞉ ega꞉walo Godokono nilakapo kawokalima꞉wena꞉. Ebema꞉ modobola la꞉ ebe kawokawo tanalo nosiyodilolenala꞉ ega꞉walo atu tetelo egege tanalo osiyodilolema꞉ akododolomatila꞉la꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nanitabola, la꞉ Pa꞉lisi tanebapiate kuba wiya kawonomo kelaemamota, mabu balidi ibilamole moto gulo la꞉ ubila kawokawo dubuno ilukuli bailo ilukulima꞉, ega꞉walo la꞉ ubila la꞉le inamabu olowame bailo eba wapata꞉lamelo epate la꞉ ulametate ebo kowalogoletama꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nanitabola, la꞉tamo da꞉pemene ebe kuba wiyate kawonomoma꞉ keda꞉mene, mabu la꞉ epono a꞉ela ape waminaole bobo keba kunula꞉ka꞉ eba kunulata! Ma kunu epate iyatawa꞉ abale inamabuate da꞉pola꞉na, ebema꞉ iba꞉te iyatawaoa꞉no ebana wapata꞉lamena.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ebene Godokono Totomu iyatulamedawa idite Ya꞉sutamo negiya, “Iyatulamedawa, a꞉ma꞉ Pa꞉lisi tanebapi tabamo da꞉kubailama꞉wa꞉, a꞉ma꞉ ebe tabamo a atumu a꞉kemalogoa꞉ta!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ya꞉sute ebeno tabo eba wiyalo negiya, “Iyo, la꞉ Godokono Totomu iyatulamepi, la꞉ atumu kuba wiya kawonomo kelaemamota, mabu la꞉ la꞉imano totomu tabamo epatamo iyaiya mibomibo tanalo ikalamenakomata! Iyo, la꞉imano totomu tabo epate mibomibo inamabu okolamo dowaguatena eba kunula, ebema꞉ la꞉le ibino mibomibo dulama꞉wenakoma walubi tanalo da꞉pesonomo idi kiyata꞉wenakoa꞉, koto makupiola꞉wete gito lamota꞉onanakomata. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Nanitabola, la꞉tamo da꞉pemene ebe kuba wiya kawonomoma꞉ keda꞉mene, mabu la꞉imano ewoniate Godokono woki awokalimipi nanitabolo anakapulamenakiya, wiyasiya ka꞉lo la꞉ la꞉imano ewonino iyaiya osiyodilole tanalo kubama꞉ gela꞉no ibi emoiolenakomata. Eiye! Ebe mabuma꞉ ibino kubate la꞉ magumulo atumu ba꞉kitana, wiyasiya la꞉ ebe kuba waminalo la꞉imano ewoniate danakapulamenakiya ebe tuputupupino bobo bai wadenomamo osiyodilolenakomata. Ebema꞉ numa꞉la꞉, ebe tanalote la꞉imano mena netewa tanalo awokalimina, mabu la꞉imano tepo magumulo atu kuba osiyodilole ubi ba꞉ka꞉pola꞉na Godokono wokopinomatamo! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ebe mabuma꞉ Godokono Mulo Tabote ma kunu gena, ‘Nale epatamo naimano woki awokalimipi ega꞉walo naimano alibolepi epetapi kanalibolemamo, wiyasiya iba꞉te ebe wokopi ubia꞉nola, ebene iba꞉te ibi epetapi eba anakapulamelo epetapiatamo temeteme bikalamenakoma꞉na꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ebema꞉ me tete epate kuba wiya kelaema꞉na꞉, mabu me opono wagilimi mabune iba꞉te Godokono woki awokalimipi anakapulamenakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Iyo, A꞉ibolokono kalimate opamo deka꞉ka꞉liya, ebe tanalo wagilimi mabula. Ebene iba꞉te tuputupu wokopi epetapi bilibilinomo anakapulamete, uwomu tetelo Godoko Amamateno Motolo Sekalayako ebo kanakapumiya, iyo, ebete ebe Motono Talena Bai ega꞉walo Godotamo kalimagono ikameo bai tetenomolo eba utitalo, iba꞉te ebe danagalimiya ebete gito a꞉iya. Ebema꞉ na la꞉tamo nani tabonomo gemo, me tete epate ebe kuba bilibilinomo mabuma꞉ wiya nanitabolo kelaema꞉na꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Nanitabola, la꞉ Godokono Totomu iyatulamepi, la꞉imano kuba wiyate kawonomoma꞉ keda꞉mene, mabu la꞉le epono gabo mopilamenamata iba꞉te Godogodone iyatawa kelaema꞉! La꞉ a꞉ka꞉tuwa꞉ ebeno wade tanalo laema꞉ ubia꞉nola, ebema꞉ piyate ubi diyatina wiyasiya la꞉le ibi atumu na꞉kodiyobolenamata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ebene Ya꞉sute ebe motone da꞉piwisigiya, ebe tetelo Godokono Totomu iyatulamepi ega꞉walo Pa꞉lisi tanebapi iba꞉te kawonomamo dowaote Ya꞉sukono tanaloma꞉ tabo kubanomamo gela ebo wagilimiya. Ega꞉walo ebe tetene wagilimite iba꞉te Ya꞉sutamo da꞉pelamenakiya iyaiya tanalo ebo pikiyawaomenakiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","mabu ibi ubila ebe kuba gabamo eba wabuga꞉talo ebete iya tabo kubanu gelo ebe ebo kelaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tete idilo epo bilibilinomate Ya꞉suko uima꞉ daladabutiya iba꞉te mupuma꞉tiua꞉go pelamitiya, idite idi mupiamidanaki, idite idi mupiamidanaki, eba kunu wagelitiya. Ebe tetelo Ya꞉sute ebe waloma꞉tapi nanaliya, “La꞉ nanisiwale! Palowa baete a꞉ka꞉tuwa꞉ unamo demaiga, Pa꞉lisi tanebapino amama tanalo eba kunula. Ebema꞉ mako amama tanalote la꞉tamo akopemaigala꞉, mabu ebe amama tanalo ebe ibino mena netewa tanalola. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Numa꞉la꞉, kebe itiole tanalate da꞉pola꞉na walone tetelo Godote kawokalilaemene, ega꞉walo waminaole tanalate da꞉pola꞉na walone epate kulamolema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ebene la꞉le idoko tetelo da꞉kiyawawenakoma, epate wiyasiya alo tetelo kolowioma꞉na꞉, ega꞉walo moto gulo la꞉le gananalo degelawenakoma, ebe iyaiya tanaloma꞉ iba꞉te tabo madodo eba adipatelo epo bilibilinomatamo kawokalilaema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ebene Ya꞉sute walo na꞉kegiya, “Naimano namutupiala꞉, nale la꞉tamo gemo, ape anakapulame iyatawaopi akotolelama꞉la꞉. Iba꞉te la꞉ danakapulametamene, iba꞉godolo elawo idite a꞉kitanamene la꞉imano uliyanano igilo kubailaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ebema꞉ la꞉ poko na꞉ka꞉tolema꞉wenama? Ebe Godotela, la꞉ ebe kapiya na꞉tolemenala꞉, mabu ebegodolo elawo bitana epo anakapulamete Ela Opamo iyalekema꞉. Iyo, na nani tabo gemo, ebe kapiya na꞉tolemenala꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Numa꞉la꞉, epate paibu piliyo olaola netewa toea maniamo uwatema꞉ gelanaka, ebe olaolano igilo kawokawoa꞉, wiyasiya Godote ebako da꞉peso ola kapiya a꞉ka꞉dodomatimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ega꞉walo me tanalo nanitabola, la꞉imano watono eke bilibilinomo Godote iyalo tetelo eka꞉la꞉mioliya, iyo, la꞉imano iyaiya tanalo ebete iyatawanomola. Ebema꞉ la꞉ woki bilibilima꞉ akoeda꞉oala꞉. Ebeno nilakapo olaolatamo nanitabolo bitana, wiyasiya ebeno nilakapo la꞉tamo kawonomoma꞉ eda꞉te ilukulina tetelo bitanamene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ebene Ya꞉sute walo na꞉kegiya, “Nale la꞉ analemata, kebe lumagite awokala degemene, ‘Na Ya꞉suko waloma꞉tadawala,’ na Epono Naniwite atumu Godokono nopopino ololo apulo kegemamo, ‘Me lumagi ebe naimano ekawila.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wiyasiya kebe lumagite na iyatawa꞉noma꞉ degemene, na atumu Godokono nopopiatamo ebe iyatawa꞉noma꞉ ka꞉kegemamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ega꞉walo kebe lumagite Epono Naniwino tanaloma꞉ odiyobo tabo da꞉kiyawaomene, Godote ebeno kuba egeboleme iyatawala, wiyasiya kebe lumagite Godokono Uliyanano osiyodilo tanaloma꞉ kubama꞉ degemene, Godote ebe kuba egebolemete a꞉ka꞉dodomatimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ebema꞉ iba꞉te la꞉imano tanalo kanagilamelelametama꞉ Yu epono balidi ibilamole motamo la꞉ demagataletamene, ebe tetelo la꞉le gabamani dubu ega꞉walo kawokawo dubu epetapi iba꞉tamo kebako tabo kegelaema꞉ woki bilibilima꞉ akoeda꞉oala꞉, ma kunu, ‘Na beda꞉ tabo na꞉kegemo? Ega꞉walo na iba꞉tamo tabo keba kunu na꞉ka꞉wiyamo?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Numa꞉la꞉, Godokono Uliyanate ebe tetenomolo la꞉le iba꞉tamo da꞉kiyawaema ebe tabo la꞉ kiyatulaema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ebene epo bilibilinomate Ya꞉suago da꞉pola꞉niya, lumagi idite ibino taneba magumulo ebetamo negiya, “Iyatulamedawa, naimano naniwi nana, aimano nabiwite atamo da꞉miyapaeami ebe inamabu bilibilinomo ebete wadenomamo nalabalemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ya꞉sute ebetamo nowamiya, “Dubu, a꞉ma꞉ potele kanatiya nale la꞉imano tanalo anagiyamidadawama꞉ keda꞉ma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ebene ebete epo bilibilinomatamo negiya, “La꞉ nanisiwale! Inamabu uwate ubi tanalote la꞉tamo akopemaigala꞉, mabu lumagite inamabu bilibilinomo eba uwatelo nanitabo igilo ebo a꞉kuimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ebene Ya꞉sute iyatulame oi idi iba꞉tamo ma kunu kiyawaiya, “Inamabu bilibilinomagodawa idite okolinami, ebeno opolo pali inamabuate kawonomamo apepeonamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ebene ebe a꞉ka꞉tuwa꞉ ebeno wokilo negi, ‘Naimano pali inamabu alomono moto modobolo ka꞉pola꞉na꞉, ebema꞉ na beda꞉ tanalo na꞉kosiyodilomo? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Oe! Na ma kunu kosiyodilomamo. Nale naimano pali inamabu alomono moto anabuilamete olioli moto kawokawo walo ka꞉ketemotemamo, ebene ebe moto magumamo naimano pali inamabu ega꞉walo kawokawo inamabu epetapi kalomomamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ebe tetelo nale naimano tepo magumulo kegemamo, ‘Na kawo dubunomola! Na kawokawo inamabu wadenomamo alomimo, ebema꞉ na ulama epetapi bilibilinomolo kodakoda woko osiyodiloa꞉no, na bae kena, elawo da꞉imi obo ka꞉ni, eba kunu kalakalago gito bokolinamo!’ ’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wiyasiya Godote ebetamo negi, ‘A꞉ma꞉ daedale lumagilata! Ka꞉lo idokolo nale a꞉imano igilo kelaemamota, ebene a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉imano tanaloma꞉ dalomawenamiya ebe inamabu bilibilinomo potele na꞉kuwatemene?’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ebema꞉ Ya꞉sute ebeno uwomu tabo ma kunu giya, “Lumagi a꞉ka꞉tuwa꞉ ebeno tanaloma꞉ inamabu dogodogokobi eba midililo wiyasiya ebeno tepo magumamo Godokono wadewade tanalo alomoa꞉no, ebe ebako daedale dawala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ebene Ya꞉sute ebe waloma꞉tapiatamo negiya, “Nale la꞉ analemata, la꞉imano ilukulio tanaloma꞉ woki bilibilima꞉ akoeda꞉onala꞉, iyo, la꞉le nao inamabu ega꞉walo pupuliono inamabu uwatema꞉ kawonomamo akomalagidilola꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Numa꞉la꞉, nao inamabu ega꞉walo pupuliono inamabu iba꞉te kawokawoma꞉ keda꞉ona꞉, mabu nao inamabute lumagitamo nanitabo igilo a꞉kikaemene, ega꞉walo pupuliono inamabuate atumu ebeno ape uwomua꞉ tetelo a꞉kowalubinamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ebema꞉ la꞉ owaowa olaolano tanalo nemalagidilala꞉, iba꞉te pali inamabu kamiona꞉ ega꞉walo iba꞉te pelamete naono pali inamabu ka꞉petapionakoa꞉, iyo, ibino pali inamabu alomono moto puliyala, wiyasiya Godote iba꞉tamo bae modobolo ikalamenako. Numa꞉la꞉, Godokono nilakapo nanitabolo bitana olaolatamo, wiyasiya ebeno nilakapo la꞉tamo kawonomoma꞉ eda꞉te uwomua꞉ uwomua꞉ tetelo bitanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ebema꞉ la꞉ woki bilibilima꞉ akoeda꞉oala꞉. Lumagi ebe a꞉ka꞉tuwa꞉ ebeno a꞉e tete egela ida꞉mo keba kunu na꞉kiyatimene, ega꞉walo ebete ebeno igilo keba kunu na꞉kegeyageyaima꞉tepamene? Gabo puliyala, kitana꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Numa꞉la꞉ la꞉ la꞉imano igilo tete da꞉pesamo geyageyailama꞉tepalema꞉ modoboa꞉, ebema꞉ mabu keleka꞉ la꞉ iyaiya tanalo epetapima꞉ woki bilibilinomoma꞉ deda꞉wenama? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“La꞉ me opono kaiyakaiyano tanalo nemalagidilala꞉, iba꞉te woko kosiyodilolena꞉ ega꞉walo pupuliono inamabu kosiyodilolena꞉. Nale la꞉ analemata, Kawo Elawodubu Solomonote inamabu bilibilinomagodawanomoma꞉ eda꞉nami, wiyasiya ebete wadewade tita꞉gono inamabu da꞉pupulinaki, ebe kalikuno titi me opono kaiyakaiyano wade titite nodoilina. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Numa꞉la꞉, me opono uwagate ka꞉lo napepeuta, dumutu epate elamo kiyalekema꞉na꞉, wiyasiya Godote ebe nonoka inamabu tita꞉gonoma꞉ midilina, ebema꞉ ebete atumu la꞉tamo pupuliono inamabu modobolo bikalamenakoma꞉ta. La꞉ me tanalo wadenomamo iyatawaoa꞉no la꞉imano nanitabokobi midi tanalo Godotamo kawokawoa꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ebema꞉ nao inamabu ega꞉walo obo nio tanaloma꞉ kawonomamo akomalagidilolenala꞉, ega꞉walo woki bilibilima꞉ akoeda꞉onala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Me opo kawonomolo epate me inamabu woki bilibila꞉go olena, la꞉ wiyasiya eba kunu akowagelenala꞉, mabu ebe inamabu la꞉godolo modobolo pola꞉na꞉no, la꞉imano Nabiwite iyalo iyatawanako. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ebema꞉ la꞉ Godote Kawo Elawodawama꞉ deda꞉na ebe tanalo dopamo nowadiala꞉, ebene la꞉imano modoboa꞉ tetelo ebete la꞉imano iyaiya tanalo ulamelelametate la꞉tamo modobolo bikalamenakoma꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ebene Ya꞉sute walo na꞉kegiya, “La꞉ naimano sipi-goeogoeo taneba da꞉pesolata, ebema꞉ la꞉ akotoletoleala꞉! Godote Kawo Elawodawama꞉ deda꞉na ebe wade tanalo la꞉imano Nabiwi ubila la꞉tamo ikalaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ebema꞉ la꞉ tolama꞉wete la꞉imano inamabu bilibilinomo maniamo na꞉midiola꞉wete nigologolopiatamo mani na꞉nikalamola꞉la꞉, iyo, la꞉ ebe gabodo olopoligoa꞉ mani gatele nosiyodilola꞉la꞉, ma kunu la꞉imano wadewade inamabuate Godokono Unu Duliyomololo ba꞉na꞉pola꞉lamenama꞉ta. Ebe inamabuate ebolo a꞉kolopoligoma꞉na꞉, iyo, pilo epate a꞉kuwatema꞉na꞉ ega꞉walo nopaiate a꞉kenalema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","La꞉ nanisiwale! La꞉imano inamabuate kebolo da꞉pola꞉nama꞉na꞉ la꞉imano tepo magumuno woki atumu ebolo ka꞉na꞉pola꞉nama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ebene Ya꞉sute walo na꞉kegiya, “La꞉ nanisiwale! Diyala, tanalo idite la꞉tamo da꞉ba꞉pemene, ebema꞉ la꞉imano kaliku pupuliawete nolosiyodilala꞉ ega꞉walo alo na꞉piala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Iyo, kawo dubuno wokopiate ebeno pe tanalo olowiolo keba kunu kemakopelene, modobola la꞉ eba kunu nilukuliniyala꞉. Numa꞉la꞉, ebe kawo dubute oli kamiyala꞉go kapiyama꞉ eda꞉te soliyomu baine da꞉pemene, ebeno wokopiate ebeno pe tanalo dolowima꞉na꞉ gigiyu kalakalago ebetamo gito ka꞉iyamidaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ebene kawo dubute da꞉pemene ibino kalakala kawonomoma꞉ keda꞉mene, mabu iba꞉te ebetamo olowiolo eba ilukulinalo ebete ibi ebo pulame. Nale la꞉ analemata, ebete ibino olosiyodilo tanalo pulamelelamete ebete ebeno lubudino kaliku pepekanate ebe a꞉ka꞉tuwa꞉ iba꞉tamo wiya꞉ wokodawama꞉ eba pa꞉midilo, wokopiate ilukulite ebete iba꞉tamo wade bae ebo ka꞉pikalaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Diyala, kawo dubute sele tetelo da꞉ba꞉pemene o walo apuamo da꞉ba꞉pemaigamene, ebema꞉ wokopiate ebetamo eba olowionalo, ebete iba꞉tamo da꞉pemene iba꞉te kawonomamo kekalakalaoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ega꞉walo me tanalo idi na꞉kemalagidilala꞉. Moto namutudawate pilo lumagino pe tete diyatawamene ebete ebe teta꞉mo kolowionamene, mabu ebe ubia꞉nola pilo dawate ebeno motamo ka꞉popegama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ebema꞉ la꞉ atumu nolosiyodilala꞉, mabu diyala, la꞉ olowioa꞉no eba ilukulinalo Epono Naniwite ebo da꞉ba꞉pemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ebema꞉ Pitate Ya꞉sutamo negiya, “Kawodawa, a꞉ma꞉ me iyatulame oi a kapiyatamo kegeawa꞉ o epo bilibilinomatamola꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Wiyasiya Kawodawa Ya꞉sute negiya, “Namutudawatamo da꞉tuduwatanako ebe mulo wokodawano tanalo keba kunula꞉ka꞉? Nanitabola, woko namutudawate ebe lawete wokopi epetapi ulamedawama꞉ kiyatimene, ma kunu ebete ibino bae nao tetelo iba꞉tamo modobolo kikalamolemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ebene ebe mulodawate woko wadenomamo eba osiyodilonalo, ebeno namutudawate pete ebeno tanalo da꞉puimene, ebe wokodawate kawonomamo kekalakalamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na la꞉tamo nani tabo gemo, namutudawate ebe mulo wokodawano tanaloma꞉ eba pekalakalalo, ebete ebe ebeno inamabu bilibilinomo ulamedawama꞉ kiyatimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Wiyasiya ebe wokodawate kuba woki lawete ebeno tepo magumulo ma kunu degemene, ‘Naimano woko namutudawate tete geyageyadopolo nokolina, samamo kapena꞉,’ ebe tetelo ebete woko osiyodiloa꞉no ebeno namutudawano bae kawiya nate elawo da꞉imi obo ebo ka꞉nimene, ebema꞉ ebete daedalema꞉ eda꞉te wokopi dubu ega꞉walo kamiyale epetapi alukole ebo kowagilimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ebene ebe daedale wokodawate olowioa꞉no eba okolinalo ebeno namutudawano pe tanalo a꞉kiyatawamene. Ebe tetelo namutudawate pete daedale wokodawa kawonomamo panagalimiote kuba osiyodilolepi epetapiago kanalibomene ebeno kuba wiya ka꞉nelaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nanitabola, kebe wokodawate ebeno namutudawano ubi tanalo iyatawate wiyasiya wade tanalo osiyodiloa꞉no, namutudawate ebe gaubamo kapanagalimiomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wiyasiya wokodawa idite ebeno namutudawano ubi tanalo iyatawa꞉no ebete kuba idi ebetamo dosiyodilomene, namutudawate ebe kuba mabuma꞉ wiya ka꞉pikaemene wiyasiya kawonomamo akapanagalimiomene. Numa꞉la꞉, epate lumagi iditamo wadewade inamabu dikameoma꞉na꞉ iba꞉te kawonomamo walo uwatema꞉ ka꞉kegelama꞉na꞉. Eba kunu Godote kebe lumagitamo wadewade tanalo bilibilidopo dikameomene, ebete ebe lumagino okoli magumulo atu wadewade tanalo ba꞉kolemenakomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ebene Ya꞉sute walo na꞉kegiya, “Na me opo epatamo Godokono ela ebe adaiyamo, iyo, ibino kuba wiya mabuma꞉ na ubila Godote me opo samamo kemadoema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Wiyasiya numa꞉la꞉, Godoko ubila ebete na a꞉e magumamo kaduba꞉midanema꞉, ebema꞉ ebe tanalote pea꞉no nale dopamo me opo epono kuba mabuma꞉ wiya idi iba꞉tamo a꞉kikalaemo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","La꞉ na꞉kemalagidilawitama nale me opamo milo adaema꞉ pe? Ao, na epatamo milo ikalaema꞉ ka꞉piya꞉, ibi anagiyamidalema꞉ piyamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Numa꞉la꞉, naimano iyaiya tabono tanaloma꞉ anagiyamida tanalote epo magumulo ka꞉pemaigamene. Ebema꞉ me tetene wagilimite moto idilo paibu atu alailama꞉te da꞉pola꞉nama꞉na꞉ ibi teta꞉mo anagiyamidalete, netewa-kapiyate netewapiatamo gowelaopima꞉ keda꞉ma꞉na꞉ ega꞉walo netewate netewa-kapiyatamo atumu gowelaopima꞉ ka꞉keda꞉ma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iyo, iba꞉te ma kunu ka꞉gowelaoma꞉na꞉, nabiate ibino koiatamo ega꞉walo koiate ibino nabiatamo, menokobiate ibino buwelemela꞉tamo ega꞉walo buwelemela꞉te ibino menokobiatamo, kamiyala꞉te ibino awino menokobiatamo ega꞉walo ebe menokobiate ibino etelamigatamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ebene Ya꞉sute epo bilibilinomatamo negiya, “La꞉ egelate da꞉niwisigana eba apulo bubu odolonalo duma꞉ema, la꞉ ma kunu kegelamamota, ‘Ulamate kowomene,’ ebene ebe tanalote nanitaboma꞉ keda꞉mene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ega꞉walo me tanalo idila. La꞉ awa ega꞉walo siyele ibino gowela tanalo duma꞉ema ma kunu kegelamamota, ‘Egelate enaenanomoma꞉ keda꞉mene,’ ebene ebe tanalote nanitaboma꞉ keda꞉mene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Iyo, la꞉ me opola tobolola ibino iyaiya tanalo ulamole iyatawalata, wiyasiya me tetelo Godote la꞉ magumulo dosiyodilolena ebe iyaiya tanalono magumu la꞉ wadenomamo beda꞉ma꞉ kiyatawawena꞉? Mabu la꞉ mena netewa epolata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ebene Ya꞉sute ebeno tabo moga꞉melo walo na꞉kegiya, “Beda꞉ mabuma꞉ la꞉ a꞉ka꞉tuwa꞉ la꞉imano tanalo wadenomamo kanagilama꞉wena꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","A꞉ma꞉tamo da꞉dowana ebe lumagite a꞉ma꞉ gabamani dubu kawotamo demagatatamene, la꞉ ebetamo nemaimia꞉no modobola a꞉ma꞉ dopamo goweladawago gelebadima꞉ na꞉nediyala꞉. A꞉ma꞉ ebe gelebadikobi midia꞉no, nanitabola, ebete a꞉ma꞉ kawo dubutamo kemagatama꞉ta, ebene kawo dubute wiyasiya a꞉imano kuba anagiyamidametate a꞉ma꞉ polisi dubutamo eba nalibolo, ebete a꞉ma꞉ idoko moto guamo ebo ka꞉niyatima꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na a꞉ma꞉tamo negemo, a꞉ma꞉ idoko moto gulo eba nokolilo, gabamani dubute kebako tete wiyama꞉ a꞉ma꞉ danatamene, a꞉ma꞉le ebako wiya modobutinomo modobuta꞉wete duliyomolamo walo ka꞉ka꞉pema꞉ta, wiyasiya a꞉ma꞉le ebe wiya modobutia꞉no a꞉ka꞉pemaigaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ebe tetelo Ya꞉suago da꞉pola꞉niya ebe epo epetapiate ebe naniya Ga꞉lili opo epono tanaloma꞉, iba꞉te sipi-goeogoeo alukolete kalima Godotamo eba ikameolo Paeletekono gowelaopiate iba꞉tamo pemaimite ebo panakapulamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ya꞉sute wiyasiya ebe epatamo negiya, “La꞉imano woki keba kunula꞉ka꞉? Ga꞉lili opo epo epetapi kubakubadopola꞉ka꞉, wiyasiya Paeletete danakapulami ibi kapiya kubakubanomola꞉ka꞉? Godote ibi kapiyatamo dowate kuba wiya ebema꞉ kikalamile? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ao, eba kunua꞉! Na la꞉tamo negemo, la꞉ bilibilinomo la꞉imano kubane olobila꞉oa꞉no la꞉ ebe atumu ka꞉ka꞉elaomamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ega꞉walo me tanalo idi na꞉kemalagidilala꞉, Silomo idili motonomote kagate 18 epo danakapulami, ibino tanaloma꞉ la꞉imano woki keba kunula꞉ka꞉? Ebe da꞉elaiya ibi kapiyate kubakubanomola꞉ka꞉, wiyasiya Yelusalema duliyomolo epo epetapi wadewade epola꞉ka꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ao, eba kunua꞉! Na la꞉tamo negemo, la꞉ bilibilinomo la꞉imano kubane olobila꞉oa꞉no la꞉ atumu ka꞉ka꞉elaomamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ebene Ya꞉sute iba꞉tamo me iyatulame oi tabo negiya, “Dubu idite ebeno pali magumamo da꞉imi kewa ami, ebene ebete walone da꞉imi tapioma꞉ da꞉pi da꞉imi ka꞉pulamea꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ebema꞉ ebete pali wokodawatamo negi, ‘Numa꞉, na netewa-kapiya ulamalo me kewalo da꞉imi dolenamo wiyasiya akulama꞉lemo. Modobola a꞉ma꞉ nema꞉lia mabu me kewate pali ebe kubaimina.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Pali wokodawate wiyasiya negi, ‘Kawodawa, modobola꞉ka꞉ na me kapiya ulamalo kuma꞉tepamamo. Na damela walo kelapate kewa mabuamo wade damela goeogoeono neago kaminaolemenatemamo, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ebema꞉ diyala, ulama idilo kewate da꞉ba꞉nolomene. Modobola a me tetelo katepamalema꞉, a꞉kema꞉lima꞉, wiyasiya noloa꞉no kema꞉limamo.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ebene Yu epono wokoa꞉ talena egela idilo Ya꞉sute ibino balidi ibilamole motolo epo iyatulamiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ibino taneba magumulo kamiyale idi okoliti, ebe 18 ulama magumulo kuba uliyanate ebetamo dikamiya ebe temetemete uminami, ebema꞉ ebete tuduwatalo pata꞉nami, waba uwamidate wadenomamo utima꞉ modobonomoa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ya꞉sute ebe umite ebe eba ka꞉milo negiya, “Kamiyale, a꞉ma꞉ dumitanamiya Godote ebe temetemeno ale epalamiolema꞉ta!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ebene Ya꞉sute ebetamo koto dowatiliya, ebe tetenomolo ebete waba uwamidate wadenomamo utite Godotamo kalakala tabo ebo adipatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Wiyasiya balidi ibilamole moto namutudawate Ya꞉sutamo na꞉dowiya mabu ebete wokoa꞉ talena egelalo ebe kamiyale wadekobi a꞉midiya. Ebema꞉ ebe dubute epatamo negiya, “Sikisi egela ba꞉pola꞉na epate woko osiyodiloma꞉. La꞉ ebe sikisi egelalo na꞉pelama꞉la꞉, me dubute la꞉imano temeteme tanaloma꞉ la꞉ kowalubilitama꞉, wiyasiya aimano talena egelaloa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ya꞉sute wiyasiya ebetamo negiya, “La꞉ mena netewa epolata! Wokoa꞉ talena egelalo la꞉ la꞉imano kau-goeo o donoki-goeo ibino ale pepalamiola꞉wete obo nio baiamo emagatalenakomata, a, nanitabola꞉ka꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wiyasiya me kamiyale ebe A꞉ibalayamakono buwele idila. Saitanate ebe 18 ulamalo ala꞉mo matuomeiya, ebema꞉ Godokono talena egelalo ale ebe walubite ebeno ale depalamiolema꞉ ebe wade tanalola!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ya꞉sute ebe tabo da꞉kiyawaiya ebe tetelo ebe odiyobopi bilibilinomate nilipoutiya, wiyasiya epetapi bilibilinomate nekalakalautiya mabu Ya꞉sute iyaiya tanalo bilibilinomo wadenomamo osiyodilolenami. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ebene Ya꞉sute negiya, “Godote Kawo Elawodawama꞉ deda꞉na, ebe tanalo keba kunula꞉ka꞉? Nale ebe tanalo beda꞉ ula꞉mo nakawokalimo? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ebe tanalo ebe mastada kikopu keba kunula꞉ka꞉ eba kunula. Dubute amite, ebe da꞉peso kikopute apete kawo kewama꞉ deda꞉mene, ebe tetelo olaolate pelamete ebe kewa katomolo ba꞉pilukulionama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ebene Ya꞉sute walo na꞉kegiya, “Godote Kawo Elawodawama꞉ deda꞉na, nale ebe tanalo beda꞉ ula꞉mo nakawokalimo? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ebe tanalo ebe ma kunula. Kamiyale idite modobo palowa lawete gamagamaimino tuwae inamabu kela꞉mo aminalete ebo ewegedi, ebene gamagamaimino inamabute palowa lawenomo eba lawelo palowa baete unamo ebo maigi.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ebene Ya꞉sute Yelusalema kawo duliyomolamo eba tolo ebete kawokawo duliyomolo epetapi ega꞉walo egege duliyomololo epo iyatulama꞉go tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ebe tetelo lumagi idite ebetamo negiya, “Kawodawa, epo bilibilinomo magumulo kapiyakapiyanomate igilo mula꞉ tanalo ba꞉kelaema꞉na꞉?” Ya꞉sute iba꞉tamo nowamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“La꞉ Godokono Unu Duliyomolono ta꞉kumi gigiyudo opila꞉oma꞉ woki kawonomamo niyatinala꞉, mabu nale la꞉tamo negemo, epetapi bilibilinomate ebe gigiyudo opila꞉oma꞉ dowagelema꞉na꞉ wiyasiya iba꞉te a꞉ka꞉modoboma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Numa꞉la꞉, moto namutudawate maigate gigiyu demopimene, ebe tetelo la꞉ balalo putitatawete gigiyu eba panakamilo ka꞉pegelamamota, ‘Kawodawa, gigiyu na꞉pa꞉iyamidaeama꞉!’ wiyasiya ebete ma kunu kegemene, ‘Na iyatawa꞉ la꞉imano tanalo. La꞉ kebe epola꞉ka꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ebe tetelo la꞉ ma kunu kegelamamota, ‘A a꞉ma꞉go bae naote da꞉imi obo a꞉nionakima꞉, iyo, a꞉ma꞉ aimano duliyomololo epo iyatulamenakiyata!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ebete wiyasiya la꞉tamo walo ka꞉kegemene, ‘Na iyatawa꞉ la꞉imano tanalo, la꞉ kebene ka꞉pelama꞉ema? La꞉ kuba osiyodilolepilata, nagodone na꞉tolama꞉la꞉!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ebema꞉ ebe tetelo la꞉ muludopolo nutitatawete, la꞉ Godokono Unu Duliyomolo magumulo A꞉ibalayamako, Aisa꞉keko, Ya꞉ikoboko, ega꞉walo Godokono woki awokalimipi bilibilinomo kulaemamota, wiyasiya Godote la꞉ iyabaiamo diyaleketamene, la꞉ lalo eba oliomolelo kawonomamo kiimimamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Numa꞉la꞉, ebe tetelo epo bilibilinomate me opo kawonomono apune apune pelamolete, Godote Kawo Elawodawama꞉ deda꞉na iba꞉te ebe duliyomolono soliyomu magumulo ka꞉pa꞉pola꞉nama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nanitabola, ibi bilibilinomo magumulo walogabopiate wiyasiya dopopima꞉ keda꞉oma꞉na꞉, ega꞉walo dopopiate wiyasiya walogabopima꞉ keda꞉oma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ebe tetenomolo Pa꞉lisi tanebapi dubu epetapiate pelamete Ya꞉sutamo na꞉pegeliya, “A꞉ma꞉ me duliyomolone iyabaiamo nalaula꞉, mabu Kawo Elawodubu Elodite a꞉ma꞉ anakapuima꞉ ubi niyatina.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ya꞉sute wiyasiya iba꞉tamo negiya, “La꞉ tolama꞉wete ebe elawoa꞉ tumu gaatamo ma kunu na꞉negelala꞉, ‘Ka꞉lo ega꞉walo dumutu na kubakuba uliyana epagodone alibolete temetema꞉gopi wadekobi ka꞉midiolemamo, ebene nale pino naimano woko kopoliyamamo.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ebene Ya꞉sute walo na꞉kegiya, “Nanitabola, na ka꞉lo me duliyomolone na꞉tutamo. Ka꞉lo, dumutu, ega꞉walo pino nale me gabodo tote Yelusalemamo ka꞉nemaigamamo. Mabu epate Yelusalemalo Godokono woki awokalimipi anakapulamenakiya, ebema꞉ modoboa꞉ nale duliyomolo idilo a꞉ema꞉, iyo, iba꞉te na atumu Yelusalemalo nakanakapunaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Yelusalema, Yelusalema! A꞉ma꞉le Godokono woki awokalimipi anakapulamenakota, ega꞉walo ebete a꞉ma꞉ kowalubitama꞉ dapalibolenako, a꞉ma꞉le ibi nokolamo mapelama꞉welo akanakapulamenakota. Tete geyageyanomolo na ubi niyatinaimo a꞉imano epo naimano etakamo kitakeamidalema꞉, kakabate ebeno gudi ditakeamidalenako eba kunu, wiyasiya a꞉ma꞉ ubia꞉noma꞉ eda꞉namiyata! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ebema꞉ umu numita꞉, a꞉imano duliyomolote kubanomo ka꞉kubamene. Nale a꞉ma꞉tamo negemo, a꞉imano epate na tete geyageyanomolo a꞉kunaema꞉na꞉, wiyasiya a꞉imano walonepiate Godotamo ma kunu degelama꞉na꞉, ‘A꞉imano mailago da꞉pita, ale ebe unamo kadipatemalema꞉!’ ebe tetelo nale walo da꞉ka꞉pemo iba꞉te na ebo kunaema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ebene Yu epono wokoa꞉ talena egela idilo Ya꞉sute bae nama꞉ Pa꞉lisi tanebapino watodawa idino motamo eba nodolutalo, ebolo da꞉pola꞉niya ebe epate ebe balidi kodakodamo umitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ebe tetelo dubu idi ape alupae temetemete duminami, ebete Ya꞉sukono ololo apuamo da꞉piya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ebema꞉ Ya꞉sute Godokono Totomu iyatulamepi ega꞉walo Pa꞉lisi tanebapi dubatamo negiya, “Aimano totomu tabote keba kunu kiyatuamenale? Wokoa꞉ talena egelalo lumagi wadekobi midima꞉ modobola꞉ka꞉ o kubala꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wiyasiya iba꞉te tabo idi kegeliya꞉, ebene Ya꞉sute ebe dubu kotamo lawete ebe wadekobi midite ebe ebo nalibiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ebene Ya꞉sute iba꞉tamo negiya, “A꞉imano gudute talena egelalo damela gugamo da꞉negamene, a꞉ma꞉le ebe samamo ka꞉nowalubima꞉ta, a, nanitabola꞉ka꞉? Iyo, ebe atu egelalo a꞉imano kau-goeote obo gula꞉mo da꞉negamene, a꞉ma꞉ atumu ebe samamo ka꞉nidimuima꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ebema꞉ iba꞉te ilipote Ya꞉sutamo wiya tabo gelama꞉ ka꞉modobiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ebene tete idilo Ya꞉sute bae nao bailo eba okolitalo, moto namutudawate dopamo deka꞉la꞉miya ebeno soliyomu bae ka꞉penaoma꞉, ebe dubate da꞉pelamiya ibi ubila kawokawo epono ilukuli bailo pilukulima꞉. Ya꞉sute ebe tanalo umite iba꞉tamo iyatulame oi idi ma kunu kiyawaiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Dubu idite oli kamiyale lawe soliyomu osiyodilo tetelo ebete a꞉ma꞉ eba꞉go bae nama꞉ danatamene, ebe tetelo a꞉ma꞉le kawodawano okoli baiamo akonokoliala꞉. Diyala, kawo dubu idite da꞉ba꞉pemene, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ebema꞉ soliyomu namutudawate pete a꞉ma꞉tamo ma kunu ka꞉pegemene, ‘A꞉ma꞉ eba꞉, nepauwa! Me kawo baiamo me dubute ka꞉pokolimene!’ Ebe tetelo a꞉ma꞉ eba ilipolo da꞉peso lumagino okoli bainomo kelaema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ebema꞉ modobola a꞉ma꞉ bae nama꞉ da꞉pa꞉emene, ebe tetelo a꞉ma꞉ da꞉pesodawano okoli bainomote na꞉pelawiye, ebene soliyomu namutudawate pete a꞉ma꞉tamo ma kunu ka꞉pegemene, ‘Namutudawa, me da꞉peso okoli bai atepawete, kawo okoli bai nelawa꞉.’ Ebene bae denauta ebe epo bilibilinomate a꞉ma꞉ eba umitalo, ebete a꞉ma꞉ eba kunu kekalakalaima꞉ta, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","mabu nanitabola, lumagite ebe a꞉ka꞉tuwa꞉ ebe kawoma꞉ da꞉midimene Godote ebe da꞉pesoma꞉ ka꞉midimene, ega꞉walo kebe lumagite ebe a꞉ka꞉tuwa꞉ ebe da꞉pesoma꞉ da꞉midimene Godote wiyasiya ebe kawoma꞉ ka꞉midimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ebene Ya꞉sute bae kebe motolo kenitiyale, ebete ebe moto namutudawatamo negiya, “A꞉ma꞉le soliyomu dosiyodilaemene ebe tetelo a꞉imano duliyomolo epo, ega꞉walo a꞉imano nanila ekakila, ega꞉walo a꞉imano kalima epo epetapi, ega꞉walo a꞉imano opolo dilukuliona inamabu bilibila꞉gopi akoka꞉la꞉miala꞉, mabu ebako epate a꞉ma꞉tamo walo ka꞉ka꞉wiyaoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wiyasiya a꞉ma꞉ soliyomu dosiyodilaemene, ebe tetelo inamabua꞉pi, agowa kubakubapi, ega꞉walo balidi tamiolamepi, ebakobako epo neka꞉la꞉miye soliyomu baiamo, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","mabu iba꞉godolo inamabu puliyala a꞉ma꞉tamo wiyaoma꞉. A꞉ma꞉le eba kunu dosiyodilawenakomene, Godote a꞉ma꞉ wadenomamo bowalubinakoma꞉ta, ega꞉walo tuputupu epate a꞉e magumune demaimioma꞉na꞉ ebe tetelo ebete wade wiya idi a꞉ma꞉tamo walo ka꞉kikaema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ebene Ya꞉suago bae nao bailo da꞉pola꞉niya, ibi magumulo lumagi idite ebeno tabo olowite ebetamo negiya, “Godote Kawo Elawodawama꞉ deda꞉na, ebe duliyomololo bae denaoma꞉na꞉ ebe epate kekalakalaoma꞉na꞉, kalakala beda꞉ kawonomola꞉ka꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ya꞉sute wiyasiya ebetamo negiya, “Dubu idite kawo soliyomu osiyodilo nopo eba iyatilo tabo dopamo epo epetapi bilibilinomatamo nalibi iba꞉te ka꞉pelaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ebene soliyomu egelate da꞉pi, ebete ebeno wokodawa ebo alibi ebe atu epo ka꞉kiyawaolamenatoma꞉. Ebene wokodawate tote iba꞉tamo na꞉negi, ‘La꞉ soliyomu baiamo na꞉pelama꞉la꞉, inamabu bilibilinomo a꞉modoboilaema꞉,’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","wiyasiya ibi bilibilinomate pelaema꞉ ubia꞉noma꞉ eda꞉ote idawate tabo idi genaki, idawate tabo idi genaki, eba kunu wagelitiya. “Ibino taneba magumulo idawate kawo dubuno wokodawatamo negi, ‘Na pali amio bai maniamo ka꞉lo elawa꞉kamo, ebema꞉ na ebe opo uima꞉ tutamo. Niyata, na a꞉ka꞉pemo.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Idawate na꞉kegi, ‘Na teni kau-goeogoeo maniamo ka꞉lo uwata꞉kamo, ebema꞉ na iba꞉godolo woko osiyodiloma꞉ tutamo. Niyata, na a꞉ka꞉pemo.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Idawate walo na꞉kegi, ‘Na kamiyale ka꞉lonomo aida꞉kamo, ebema꞉ na pema꞉ modoboa꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ebene wokodawate ebeno namutudawatamo ka꞉pete ebe epono ubia꞉ tanalo ebe napani. Kawo dubute ebeno tabo dolowi, ebete dowate wokodawa ebo ani, ‘A꞉ma꞉ samonomamo walo na꞉ka꞉toa. A꞉ma꞉ kawo duliyomolamo nemaigawete, ebe duliyomolono kawokawo ega꞉walo egege gabodo eba tolo, inamabua꞉pi, ega꞉walo agowa kubakubapi, ega꞉walo balidi tamiolamepi, ibi bilibilinomo me soliyomu baiamo nemagaeliye.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ebene wokodawate walo da꞉kolowami, ebe tetelo ebete na꞉pegi, ‘Kawodawa, a꞉ma꞉le degeawa꞉ka nale ebe tanalo a꞉nosiyodilomo. Epo bilibilinomate a꞉pelama꞉, wiyasiya soliyomu bailo tete kawodopo bitana epetapiate ka꞉pelaema꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ebema꞉ kawo dubute ebetamo na꞉kegi, ‘A꞉ma꞉ walo na꞉ka꞉toa, tumulo dilukuliona ega꞉walo iyaiya gabolo dowapata꞉lamita, ebe epo samamo nowalolatela꞉wete ibi atumu na꞉kemagaeliye naimano soliyomu motote ketabokama꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ebene ebe kawo dubute ebeno moto epatamo olobigate na꞉kegi, ‘Nale la꞉ nanitabonomolo analemata, nale dopamo deka꞉la꞉imo, ka꞉lo ebe epate ibino ubia꞉ tanalo dawokalima꞉ka, ibino taneba magumulo kapiya lumagi idite naimano soliyomu bae a꞉kenamene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ebene epo bilibilinomate Ya꞉suago da꞉tolamitiya, ebe tetelo ebete polobigate iba꞉tamo na꞉pegiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kebe lumagite natamo pema꞉ ubi diyatimene, ebete ebeno nabiwila menokola, ega꞉walo ebeno kamiyalela gudila, ega꞉walo ebeno nanila nanikubila ekakila, iyo, ebeno kateneno igilo atumu, ebete ebe tanalo bilibilinomo ginima꞉mo ilatelea꞉no, ebete na waloma꞉enema꞉ a꞉ka꞉modobomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Iyo, nanitabola, kebe lumagite ebeno kewa olotolowa agute na waloma꞉enea꞉no, ebete nago kapimiya toma꞉ a꞉ka꞉modobomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Numa꞉la꞉, la꞉imano taneba magumulo lumagi idite idili motonomo etema꞉ ubi diyatimene, ebete dopamo okolite moto eteno mani uwomu wadenomamo malagidilote, ebegodolo da꞉pola꞉na ebe mani ma kunu keka꞉la꞉miolemene, ebe moto opoliyama꞉ mani modobola꞉ka꞉ o modoboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ebete ma kunu wagelea꞉no ebeno motono alo alomote, ebe tetelo mani opoliyate woko datepamene, epate ebe tanalo uimite ebe eba kalakalatelo ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kegelama꞉na꞉, ‘Moto etema꞉ dowagilimi wiyasiya opoliyama꞉ elawoa꞉nola, me ebe dubula!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ega꞉walo me tanalo idila. Kawo elawodubu idite kawo elawodubu ida꞉go gowelama꞉ dowagelemene, ebete dopamo okolite ebe tanalo wadenomamo eba malagidilutalo ma kunu kegemene, ‘Naimano 10 taoseni gowelaopi dubate elawodubu idino 20 taoseni dubago gowela modobola꞉ka꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ebete ebeno wokilo modoboa꞉noma꞉ degemene, elawodubu idite muludopone eba pitalo, ebete ebeno obiale dubu dopamo kanalibolemene. Ebene iba꞉te kawo elawodubu iditamo nemaimite ka꞉negelama꞉na꞉, ‘La꞉ beda꞉ ubi kiyata꞉witama ale la꞉tamo kikalametama꞉? A ubila la꞉go milo kiyatima꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ebema꞉ Ya꞉sute uwomu tabo ma kunu giya, “Naimano tabono kawo magumu ma kunula, kebe lumagite ebeno okoli tanalono bilibilinomo tanalo ginima꞉mo ilatelea꞉no, ebete na waloma꞉enema꞉ a꞉ka꞉modobomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ebene Ya꞉sute walo na꞉kegiya, “Solu wadenomola, wiyasiya lumagi idino soluno golate dalatidimene, ebete walo solukobi midima꞉ a꞉ka꞉modobomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Numa꞉la꞉, epate sosowa ega꞉walo goeogoeono ne kubanomoma꞉ gelanaka wiyasiya ebako inamabu pali amio baiamo diyalekema꞉na꞉, pali inamabuate wadenomamo kapepeoma꞉na꞉. Wiyasiya lumagino tepo magumuno solu eba kunua꞉. Ebeno soluno golate dalatidimene, ebeno igilote kubanomoma꞉ eba eda꞉lo wade woko walo a꞉kosiyodilonakomene. Ebema꞉ ebete ebeno igilo walo wadekobi keba kunu na꞉ka꞉midimene? Gabo puliyala! Galagodawa, a꞉ma꞉ wadenomamo nolowia!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Egela idilo ta꞉kese mani elemasigilo uwatepi ega꞉walo Godokono Totomu Tabo uwatea꞉pi ibi epetapi bilibilinomate Ya꞉sutamo pelamiya ebeno tabo ka꞉polowioma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ebene Pa꞉lisi tanebapi ega꞉walo Godokono Totomu iyatulamepiate eba dowaolo negeliya, “Numa꞉la꞉, me dubute kubakuba epo kalakalago uwatete iba꞉go bae ebo nanako!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ebema꞉ Ya꞉sute me iyatulame oi iba꞉tamo ma kunu kiyawaiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“La꞉imano taneba magumulo lumagi idi ebeno 100 sipi-goeogoeo da꞉pola꞉mena, ebene kapiyate dalatidimene ebete keba kunu na꞉kowagelemene? Iyo, ebete 99 sipi-goeogoeo epetapi wade uwago nao bailo miyapate, dalatidi ebe sipi-goeo kapiya idi wadinatote ka꞉nuimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ebete da꞉nuimene ebe tetelo ebete agute kalakalago kemagaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ebene ebete motamo walo ka꞉pete ebeno namutupi ega꞉walo ebe niyakabolo dilukulina, ebe epo peka꞉la꞉mite iba꞉tamo ka꞉pegemene, ‘La꞉ nago kapimiya nekalakalaola꞉, mabu naimano sipi-goeo tumulo dalatidi nale walo a꞉kelaemo!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ebema꞉ Ya꞉sute tabo ma kunu giya, “Nale la꞉ analemata, kapiya lumagite ebeno kubane olobigate woki iyakobi da꞉midimene, ebe tetelo Godokono Unu Duliyomololo kalakala kawonomote kitanamene. Wiyasiya 99 epo epetapi iba꞉te a꞉ka꞉tuwa꞉ ibi tuputupupima꞉ degelana, ibi mabuma꞉ Godokono kalakalate nanitabolo a꞉kitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ega꞉walo me tanalo idila. Kamiyale idino teni mani da꞉pola꞉mena, ebene kapiyate dalatidimene ebe keba kunu na꞉kowagelemene? Ebete ebeno alo pite ega꞉walo moto gu wadenomamo eba moda꞉midalo mani wadinatote ebo ka꞉nuimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ebene ebete delaemene ebe tetelo ebeno namutupi ega꞉walo ebe niyakabolo dilukulina, ebete ebe epo ka꞉la꞉mite iba꞉tamo kegemene, ‘La꞉ nago kapimiya nekalakalaola꞉, mabu dalatidi ebe mani nale walo a꞉kelaemo!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ebema꞉ Ya꞉sute tabo ma kunu giya, “Na la꞉ analemata, kapiya lumagite ebeno kubane olobigate woki iyakobi da꞉midimene, Godokono Unu Duliyomololo ebeno nopopiate atumu kawonomamo kekalakalaoma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ebene Ya꞉sute tabo idi walo na꞉kegiya, “Koi netewago dubu okolinami, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ebene ekawite ebeno nabiwitamo negi, ‘A꞉ma꞉le a꞉e tetelo natamo ikanaema꞉ degeawia, ebe inamabu ega꞉walo damela ka꞉lo natamo nikanama꞉.’ Ebe tetelo nabiwite ebeno inamabu ega꞉walo mani tulituliya anagiyamidalelamete ebeno gudi netewatamo iyaiya ebo ikalamoli. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ebene ekawite bilibili egela ka꞉lutia꞉. Ebete nabiwigodone delawi ebe damela kawonomo maniamo midite mani lawete mulu opamo gito ti, ebolo ebete daedale wokilo kubakuba tanalo eba nosiyodilolelo ebeno mani gito nopoliyali. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ebene ebe mulu opo kawonomolo bae olopoligo tanalote epatamo ebo pemaigi, ebema꞉ bae kape tanalote ebe kawonomamo lawi. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ebema꞉ ebete tote ebe opo epono dubu idigodolo woko eba nelawelo, ebete ebe tumamo gito alibi ebeno goeogoeo ka꞉nulamenama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ebe tetelo epate sosowamo dalomonakiya ebe bae goeogoeoatamo da꞉pikalamolenaki, ebete tete bilibilinomolo ebe bae naoma꞉ ubi niyatinami, wiyasiya lumagi idite ebetamo nao inamabu kikamenakia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ebene egela epetapiate dolopoligiya ebete ebeno woki iyakobi midite negi, ‘Naimano nabiwino wokopiagodolo nao inamabu bilibilinomo ba꞉pola꞉na, iba꞉te a꞉ka꞉tuwa꞉ naonama꞉ modoboa꞉. Na wiyasiya malo bae kapelo a꞉ema꞉ wagelenamo! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Modobola na tote naimano nabiwitamo ma kunu ka꞉negemamo, ‘Aba, na Godotamo ega꞉walo a꞉ma꞉tamo iyaiya kuba tanalo a꞉nosiyodilolimo, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ebema꞉ na wadenoa꞉ a꞉ma꞉le na a꞉imano guduma꞉ ka꞉na꞉ima꞉. Modobola a꞉ma꞉ na wiyasiya a꞉imano wiya꞉ wokodawa idima꞉ na꞉midina꞉.’ ’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ebe tetelo ebete maigate ebeno nabiwitamo ebo ti. “Ebene ebete mulune eba pitalo, ebeno nabiwite ebe numite ebe kawonomamo nilakapoimilo ebetamo na꞉puligate ebe eba na꞉wiyamidalo ebo naboeti. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ebeno gudute negi, ‘Nabiwi, na Godotamo ega꞉walo a꞉ma꞉tamo iyaiya kuba tanalo a꞉nosiyodilolimo, ebema꞉ na wadenoa꞉ a꞉ma꞉le na a꞉imano guduma꞉ ka꞉na꞉ima꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Wiyasiya ebeno nabiwite wokodawa iditamo negi, ‘Wade kalikunomo samamo adaema꞉wete naimano koitamo na꞉pa꞉pulima꞉, ega꞉walo lini inamabu ebeno kotamo pipulima꞉wete agowa pata akona꞉pupuliomiye. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ebene a꞉ma꞉ toawete oli ape kau-goeo gadinomo nelawa꞉wete nananagalimiye. Ale soliyomu bae eba naonalo kekalakalaonamalema꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","mabu naimano gudu da꞉i ebete ka꞉lo igilo walo a꞉kelawe, ebete iyabaiamo dalatidi wiyasiya nale ebe walo a꞉kelaemo.’ Ebene ebe tetelo iba꞉te kalakala ebo wagilimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Wiyasiya ebe tetelo naniwite nabiwino pali bailo woko ebe nosiyodiluti. Dadimoni ebete woko baine moto tataliamo eba pemaiganalo mae diyamo ega꞉walo kalakala oaleno diyamo ebo polowini, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ebema꞉ ebete wokodawa idi ebetamo ka꞉minate nalateda꞉ni, ‘Me tanalo keba kunula꞉ka꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Wokodawate ebetamo negeni, ‘A꞉imano ekawi a꞉pa꞉ka, ebema꞉ a꞉imano nabiwite oli ape kau-goeo gadinomo anagalima꞉ka. Kalakala kawonomote itana mabu ebete olalatia꞉no a꞉ka꞉pemaigaka!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ebe mabuma꞉ naniwite dowanate moto guamo odolo ubia꞉noma꞉ eda꞉ni, ebene ebeno nabiwite motone pemaiganate ebe na꞉petoweomeni motamo ka꞉podolonama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ebete wiyasiya ebeno nabiwitamo negeni, ‘A꞉ma꞉ numa꞉, na ulama bilibilinomolo a꞉imano wokodawama꞉ eba eda꞉nalo, a꞉ma꞉le danana꞉wenakiya nale ubia꞉noma꞉ keda꞉nakia꞉. A꞉ma꞉le wiyasiya natamo beda꞉ inamabu kikanama꞉wia? Eiye! A꞉ma꞉ natamo da꞉peso gautu-goeo kikanama꞉wea꞉, nale naimano namutupiago eba naolo kekalakalaoma꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wiyasiya a꞉imano gudu idite a꞉imano inamabu uwatete, dubu bilibili kamiyala꞉go kuba eba nosiyodilolelo a꞉imano mani anatutulateli. Ebene ebe lumagite da꞉pa꞉ka, a꞉ma꞉ ebe kalakalakobi ka꞉mida꞉ema꞉ oli ape kau-goeo ebetamo anagalima꞉kata!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ebeno nabiwite ebetamo nowamini, ‘Naimano gudu, a꞉ma꞉ okolina tetelo nago okolinata, naimano inamabu bilibilinomo a꞉imanola. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wiyasiya a꞉imano ekawite da꞉i ebete ka꞉lo igilo walo a꞉kelawe, iyo, ebete iyabaiamo dalatidi ale ebe walo a꞉kelaema꞉. Ebema꞉ modobola a bae kapimiya eba naonalo kekalakalaonamalema꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ebene Ya꞉sute ebe waloma꞉tapiatamo negiya, “Kawo dubu idite dubu idi iyati ebete ebeno inamabu bilibilinomo wadenomamo kulamelemenama꞉. Ebene egela epetapi bilibilinomo da꞉petoiya, epo epetapiate ebe dogodogo dubu napaniya, ‘Numa꞉, a꞉ma꞉le diyata꞉wia ebe wokodawate a꞉imano inamabu pilo gabodo eba puwatelo ebo nowatutulatelenako.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Ebe tetelo kawo dubute ebeno wokodawa ka꞉mite ebetamo negi, ‘Na ka꞉lo dolowimo, ebe tanalo keba kunula꞉ka꞉? A꞉ma꞉le naimano woko eba osiyodilonalo kebako kuba kosiyodilola꞉wenamiya, modobola a꞉ma꞉ ebe iyaiya tanalo bilibilinomo a꞉imano woko bukalo wadenomamo na꞉tuputupuilama꞉wete ebo nadaiye nale kiyatawama꞉. Mabu a꞉ma꞉ modoboa꞉ naimano inamabu ulamedawama꞉ eda꞉ma꞉, ebema꞉ a꞉ma꞉ ka꞉lo woko katepama꞉ta.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ebene ebe wokodawate ebeno woko baiamo eba tolo tepo magumulo na꞉negi, ‘Kawo dubute naimano woko odiyobi, ebema꞉ na keba kunu na꞉kowagelemo? Na ubia꞉nola gowolesi obobole woko osiyodilolema꞉, na elawoa꞉nola. Ega꞉walo na epatamo manima꞉ da꞉towetoweomo na ilipokobi kolowimamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Oe, na iyatawala! Naimano woko namutudawa eba masigilo epo epetapi naimano namutupima꞉ ka꞉midilimamo. Nale eba kunu dosiyodilomo, naimano woko olopoligo tetelo ebe namutupiate naimano iyaiya modoboa꞉ tanalo magumulo kalakalago bowalubininakoma꞉na꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ebema꞉ ebe tetelo ebete ebeno woko namutudawa ma kunu masigi. Piyate ebe kawo dubutamo mani wiyaolea꞉no, ebete ibi bilibilinomo ka꞉la꞉mite dopodawatamo negi, ‘A꞉ma꞉ naimano woko namutudawatamo kebako mani ka꞉wiyawea꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ebete negi, ‘Nale 100 dolomu alono obo duwatimo, nale ka꞉wiya꞉.’ “Ebene kawo dubuno inamabu ulamedawate ebetamo negi, ‘Mela, a꞉ma꞉le duwata꞉wia ebe pepa. A꞉ma꞉le 100 uwomu egebola꞉wete wiyasiya 50 dolomu nakulola꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ebene ebete tetedawa iditamo negi, ‘A꞉ma꞉ kebako mani ka꞉wiyawea꞉?’ “Ebete nowami, ‘Nale 1,000 witi-laiso baiko duwatimo, nale ka꞉wia꞉.’ “Ebene kawo dubuno inamabu ulamedawate ebetamo negi, ‘Mela, a꞉ma꞉le duwata꞉wia ebe pepa. A꞉ma꞉le 1,000 uwomu egebola꞉wete wiyasiya 800 baiko nakulola꞉.’ Ebene kawo dubuno inamabu ulamedawate wiyaolea꞉pi bilibilinomatamo ma kunu genaki, iyo, ebete me gabodo ebeno woko namutudawa eba masigilo epo bilibilinomo epetapi ebeno namutupima꞉ gito midili. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Walone kawo dubute ebeno inamabu ulamedawano osiyodilo tanalo iyatawate negi, ‘Oe, ebe beda꞉ mulo kawodawala꞉ka꞉! Ebete na eba kubainamelo ebe a꞉ka꞉tuwa꞉ ebe walubi.’” Ebene Ya꞉sute ebeno iyatulame oino magumu ma kunu awokalimiya, “Me opolo nanitabokobi midia꞉ epate mulonomoma꞉ eba eda꞉onalo ibino maniamo iyaiya tanalo osiyodilolenaka ibi kowalubilinama꞉. Wiyasiya alo magumulo dilukuliona ebe epate tete epetapilo mulo woki malagidiloa꞉no ibi a꞉ka꞉tuwa꞉ ibino maniamo ibi kowalubilina꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nale la꞉ analemata, modobola la꞉ me opono maniamo epo la꞉imano namutupima꞉ na꞉midilinala꞉, ebema꞉ la꞉imano a꞉elao tetelo me opono inamabu dolopoligolametamene, Godokono Unu Duliyomololo la꞉imano namutupiate la꞉ atumu kalakalago kuwatema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Nanitabola, kebe lumagite da꞉peso tanalo wadenomamo dosiyodilomene, ebete kawo tanalo atumu wadenomamo ka꞉kosiyodilomene, ega꞉walo ebete da꞉peso tanalo magumulo delemasigimene, ebete kawo tanalo magumulo atumu ka꞉kelemasigimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ebema꞉ la꞉ me opolo la꞉imano inamabu tuputupu gabodo ulamena꞉no, Unu Duliyomololo da꞉pola꞉na ebe wadewade tanalo Godote la꞉tamo a꞉kikalamoletamene, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ega꞉walo la꞉le epetapino inamabu tuputupu gabodo ulamelelamena꞉no, idawate la꞉imano inamabunomo la꞉tamo a꞉kikalamolema꞉ta! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ega꞉walo me tanalo idila, lumagite netewa elawodubatamo wokodawama꞉ eda꞉ma꞉ modoboa꞉. Ebete eba kunu dowagelemene iditamo eba dowanalo idi nilakapolo bemalagidilonamene, ega꞉walo ebete iditamo eba utinalo idi ubia꞉noma꞉ beda꞉namene. Ebema꞉ a꞉ma꞉ atumu, Godotamo ega꞉walo manitamo kapiya tetelo tuduwatama꞉ modoboa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yu epo magumulo Pa꞉lisi tanebapiate mani kawonomamo malagidilolenamiya, ebema꞉ ibi epetapiate Ya꞉sukono tabo olowite ebe nekalakalatitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ebene Ya꞉sute iba꞉tamo negiya, “La꞉ epono ololo apulo la꞉imano unu tama wadekobi midilinamata, wiyasiya Godote la꞉imano tepo magumuno tanalo iyatawala, mabu epate kebe iyaiya tanalo unamo eba wadipalatelelo wadewadepima꞉ degelana, wiyasiya Godote ebe tanalo kuba abale niboma꞉ gena. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Godote ebeno Totomu Tabo Mosesedo epatamo dikalamiya ega꞉walo ebeno woki awokalimipiate Bukamo dakuloliya, ebe tagala tanalono tabote pete Yoneko teta꞉mo ebo pemaigi. Wiyasiya Yoneko tetene wagilimite Godote Kawo Elawodawama꞉ deda꞉na ebe oli tanalono tabote a꞉pe, ebene epetapiate me Wade Tabo eba kiyawaonalo, epo epetapi bilibilinomate olowite ibi ubila Godokono Wade Duliyomolamo ibi a꞉ka꞉tuwa꞉ ibino elawamo nopila꞉oma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Me tanalo nanitabola. Me opo ega꞉walo tobolo unu ibino inamabuate tete geyageyanomolo eba pola꞉nalo walone a꞉ka꞉tuwa꞉ kolopoligoma꞉na꞉, wiyasiya Godokono Totomu Tabo bilibilinomo magumulo madodo da꞉pesonomo idite a꞉kolopoligomene, ebeno tabote uwomua꞉ uwomua꞉ tetelo bitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ebene Ya꞉sute tabo idi kegiya, “Kebe dubute ebeno kamiyale alibutite kamiyale idi delaemene ebete Godokono ololo apulo pilo tanalo kosiyodilomene, ega꞉walo dubute ebeno kamiyale alibutite, idawate ebe kamiyale delaemene ebete pilo tanalo kosiyodilomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ebene Ya꞉sute me oi kiyawaiya, “Inamabu bilibilinomago dubu idite okolinami, ebete wiya kawokawo kaliku pupulinaki ega꞉walo tete bilibilinomolo wadewade nao inamabu ebe naonaki, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","wiyasiya ebeno moto gigiyu tetelo nigologolo dubute watitanaki, ebeno mailo Lasalesitela, ebeno apelo kani kawokawate pola꞉menami. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ebete inamabu bilibilinomago dubuno bae nao baine opamo da꞉pa꞉guditanaki, ebe bae papana naoma꞉ ubi niyatitanaki, wiyasiya gaagaate da꞉pelamenakiya ebeno kani ebo pema꞉menaolemenakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ebene egela idilo nigologolo dubute da꞉i, Godokono nopopiate ebeno uliyana pelawete Unu Duliyomolamo A꞉ibalayamatamo gito magatiya, wiyasiya inamabu bilibilinomago dubute da꞉i, epate ebeno ape pelawete bobamo gito niyatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ebene inamabu bilibilinomagodawate Ela Opolo temeteme magumulo eba nokolilo, mulunomone na꞉melete A꞉ibalayamako ebo numi, Lasalesiago dokoliutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ebe tetelo ebete kawonomamo eba negepatelo negi, ‘Aba A꞉ibalayama! A꞉ma꞉ na nilakapoinamelo Lasalesiko napaliba. Modobola ebete ebeno nege koto wui obamo aduba꞉midate naimano mena gibagibakobi na꞉pa꞉midina, mabu na me Ela Opolo temeteme kawonomo a꞉pelaemo!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Wiyasiya A꞉ibalayamate negi, ‘Gudu, a꞉ma꞉ nemalagidila. A꞉ma꞉le opolo dokoliawenamiya ebe tetelo a꞉ma꞉ wadewade inamabu watenamiyata, wiyasiya Lasalesiko kubakuba inamabu watenami. Ebema꞉ numa꞉, ka꞉lo ebete wade kalakalago pa꞉luta, a꞉ma꞉ wiyasiya kawo temeteme magumulo pa꞉lutata. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gudu, me tanalo idila. Aimano tetenomolo kawo bolegale bitana, ebema꞉ ale mene la꞉tamo pa꞉iwalema꞉ gabo puliyala, ega꞉walo la꞉le atamo pa꞉iwalema꞉ gabo atumu kitana꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ebene inamabu bilibilinomago dubute negi, ‘Aba A꞉ibalayama, nale a꞉ma꞉ na꞉toweoemata, a꞉ma꞉ naimano nabiwino motamo Lasalesiko nanalibiye, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mabu naimano paibu ekaki ba꞉pola꞉na. Modobola ebete iba꞉tamo tote kawiya nananalemene, iba꞉te me kawo temeteme opamo pelamekapoma꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“A꞉ibalayamate wiyasiya negi, ‘Ao! Godokono tabote iba꞉godolo bitana, ebete Mosesedo epatamo dikalamiya ega꞉walo ebeno woki awokalimipiate ebeno Bukamo dakuloliya ebe kawokawo tabo. Modobola iba꞉te ebe iyaiya tanalo olowiote Godokono ubi tanalamo na꞉tudila꞉oma꞉na꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Inamabu bilibilinomago dubute negi, ‘Ao, Aba A꞉ibalayama! Idawate a꞉ene igilamo maigate iba꞉tamo da꞉tomene, iba꞉te ebe anoano tanalo umite ibino kubane olobila꞉te woki iyakobi ebo ka꞉midilima꞉na꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“A꞉ibalayamate tabo eba wiyalo negi, ‘Iba꞉te Moseseko ega꞉walo Godokono woki awokalimipi dubu epetapiagodone tabo olowioa꞉no, lumagi idite a꞉ene iba꞉tamo da꞉nemaigamene, iba꞉te ebe tanalo duima꞉na꞉ ebe lumagino tabo atumu nanitabokobi a꞉ka꞉midima꞉na꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ebene Ya꞉sute ebe waloma꞉tapiatamo negiya, “Nanitabola, Saitanakono kuba gabamo wabuga꞉ta tanalate epatamo kemaimioma꞉na꞉, wiyasiya kebe lumagigodone demaimioma꞉na꞉ Godote ebe lumagitamo kuba wiya kawonomo kikaemene! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ebema꞉ modobola epate ebe lawete ebeno kuwokoba꞉mo kawo nokolanomo ma꞉midaomete kewa꞉ kolomamo neba꞉idiloma꞉na꞉, gudu da꞉peso idite ebeno kuba magumamo gakapoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ebema꞉ la꞉ a꞉ka꞉tuwa꞉ la꞉imano tanalo wadenomamo nulamenala꞉! “A꞉imano ekawite a꞉ma꞉tamo kuba dosiyodilomene, a꞉ma꞉le ebe na꞉totomutiye, ebene ebete ebeno kubane olobigate ebeno woki iyakobi da꞉midimene, a꞉ma꞉ ebeno kuba egebolema꞉wete na꞉dodolomatilimiye. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Iyo, ebete kapiya egelalo a꞉ma꞉tamo sebeni kubakuba tanalo osiyodilolete, ebene ebete sebeni teta꞉mo walo ka꞉pete ma kunu dakapanatamene, ‘Naimano naniwi, niyata. Na walo a꞉ma꞉tamo kuba a꞉kosiyodilomo,’ modobola a꞉ma꞉le ebeno kuba egebolema꞉wete ka꞉dodolomatilima꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ebene Kawodawa Ya꞉sute dopamo daliboliya Godokono woko ka꞉nosiyodiloma꞉, ebe alibolepi dubate ebetamo negeliya, “Aimano nanitabokobi midi tanalo kawokawokobi na꞉midiliama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kawodawa Ya꞉sute eba wiyalo negiya, “Mastada kikopu kawoa꞉, da꞉pesonomola. Wiyasiya la꞉imano nanitabokobi midi tanalote makonoma꞉ deda꞉mene, la꞉imano elawote modoboma꞉ eba eda꞉lo la꞉le me kewatamo kegelamamota, ‘A꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉imano dolodolo magobela꞉wete, kewa꞉ kolomamo na꞉toa!’ ebene me kewate la꞉imano tabamo ka꞉tuduwatamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ebene Ya꞉sute walo na꞉kegiya, “La꞉ me uli tabo wadenomamo nemalagidilala꞉. Epo magumulo idawate kawo elawodubuma꞉ eda꞉na ebene ebegodolo wiya꞉ wokopi epetapi bilibilinomo dilukulina, ebeno osiyodilo tanalo keba kunula꞉ka꞉? Kawo elawodubuno wiya꞉ wokodawa idite pali damela obobole woko ega꞉walo sipi-goeogoeo ulame woko opoliyalete motamo da꞉pemene, ebe tetelo ebeno kawodawate ebetamo ma kunu ba꞉kegemene, ‘A꞉ma꞉ niyalata, a꞉imano tanalo dopamo na꞉numa꞉. A꞉ma꞉ a꞉imano bae nawete, walone naimano bae na꞉pokalimiye’? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ao, kawo elawodubute eba kunu a꞉kowagelemene, wiyasiya ebete ebeno wokodawatamo ma kunu kegemene, ‘Bae okalimino daleya꞉ kaliku pula꞉wete naimano bae nosiyodila, ebene nale bae nao baiamo eba okolilo, a꞉ma꞉ wadewade bae ega꞉walo da꞉imi obo natamo kowadaema꞉ta. Naimano bae nao tanalo dolopoligomene, a꞉ma꞉ walone a꞉imano obo niawete a꞉imano bae ebo kenama꞉ta.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Me tanalo nanitabola. Kawo elawodubute ebeno wokodawa iyaiya woko osiyodilolema꞉ danamene, ebe tetelo wokodawate ebetamo tuduwatalo ebe woko dopoliyalemene, ebeno kawodawate ebetamo eba kalakalalo wiyasiya kawonomamo a꞉kemoiomene mabu ebe ebeno wokodawano watodawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ebema꞉ la꞉ olowiopi atumu. Kawo Elawodawa Godote la꞉le kebe iyaiya woko osiyodilolema꞉ danaletamene, modobola la꞉ ebe woko bilibilinomo opoliyala꞉wete ma kunu kegelamamota, ‘A Godokono wokopila. Ebete a beda꞉ tanaloma꞉ kanaile, ale ebeno elawamo kalakalago gito osiyodiloma꞉, ebema꞉ lumagi idite a moioema꞉ modoboa꞉. Modobola epate aimano Kawo Elawodawa Godoko kapiya nemoioma꞉na꞉!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ebene Ya꞉sute Yelusalema kawo duliyomolamo eba tolo, ebete Samaliya opo ega꞉walo Ga꞉lili opo tetenomodo tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ebete duliyomolo idi da꞉pesamo da꞉piya teni kukulakukulago dubate eba꞉go palugote mulune ebetamo kawonomamo na꞉pegeliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Ya꞉su, Wade Iyatulamedawa, a꞉ma꞉ a na꞉nilakapoiama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ya꞉sute ibi muluamo nulamete iba꞉tamo na꞉negiya, “La꞉ tolama꞉wete la꞉imano ape Godotamo kalimagono ikameopiatamo nanawokalilamola꞉la꞉.” Ebene iba꞉te eba tolamelo, gabo tetelo ibino apete wadekobi ebo nolowia. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ibino taneba magumulo kapiya idi ebeno apete wadekobi dolowiya, ebete ebe tanalo numite ebeno tabo madodo unamo adipatelo Godoko eba moiolo Ya꞉sutamo walo na꞉ka꞉piya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ebene ebete Ya꞉sukono agowa mabuamo pegate ebetamo kalakala tabo ebo pa꞉kiyawaiya. Ebe dubu Samaliya opodawala, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ebema꞉ Ya꞉sute ebeno tanalo umite epatamo negiya, “Numa꞉la꞉, Godokono elawote teni dubu wadekobi a꞉midiole, wiyasiya epetapi naini iba꞉te ka꞉pelamea꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Keleka꞉ mabu me kapela dubu, ebe kapiyate ka꞉pete ebeno kalakala tabo Godotamo da꞉pa꞉kiyawao?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ebene Ya꞉sute ebetamo negiya, “A꞉ma꞉ maigawete na꞉toa. A꞉imano nanitabokobi midi tanalote a꞉ma꞉ wadekobi a꞉mida꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ebene Pa꞉lisi tanebapi dubu epetapiate Godote Kawo Elawodawama꞉ deda꞉na ebe tanalono pemaiga tetema꞉ Ya꞉suko dalatediya, ebete ibino tabo eba wiyalo negiya, “Anoano tanalate la꞉ a꞉kiyatulametamene ma kunu, Godokono Kawo Elawodawano tete netatali. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Lumagi idite a꞉da꞉ elemasigi tabo ma kunu kegemene, ‘Numa꞉la꞉, ebe wade tanalote owagilimi, mela!’ ega꞉walo idawate ka꞉kegemene, ‘La꞉ ebe tanalo ebamo na꞉numa꞉la꞉!’ Wiyasiya Godokono Kawo Elawodawama꞉ eda꞉ tanalo eba kunua꞉, mabu ebe tanalo tepo magumuno tanalola, iyo, la꞉tamo iyalo a꞉pemaigiya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ebene ebete ebe waloma꞉tapiatamo negiya, “Me tetelo Epono Naniwite me opolo eba okolinalo, me opo epate anoano tanalo ebegodolo ulamenaka. Walone tetelo la꞉ ubi kiyatimamota mako egela walo ka꞉kuma꞉ema꞉, wiyasiya la꞉ a꞉kuma꞉ema. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ebe tetelo epetapiate la꞉tamo ma kunu kegelama꞉na꞉, ‘Mela, me anoano tanalo na꞉puma꞉la꞉!’ o ‘Ibe, ebamo na꞉numa꞉la꞉!’ wiyasiya la꞉ ibi akowaloma꞉tala꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nanitabola, molete da꞉la꞉uwa꞉midamene ebe tetelo egelate tobolo unu kawonomo ka꞉pukuimene, ebema꞉ na Epono Naniwite walo da꞉ka꞉pemo naimano pe egelate eba kunu kitanamene, iyo, me opo epo bilibilinomate naimano pe tanalo kuima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wiyasiya nanitabola, ebe tanalote pemaiga꞉no, dopamo me tete epate na ubia꞉noma꞉ eda꞉ote natamo temeteme kawokawonomo kikanamonema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nanitabola, Nowako tetelo kebako tanalote ka꞉pemaigiyale, Epono Naniwite walo da꞉ka꞉pemene ebe tetelo ebe atu tanalote ka꞉ka꞉pemaigamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ebe tetelo iba꞉te bae naota ega꞉walo elawo da꞉imi obo kawonomamo niota, dubate kamiyale uwatoleta ega꞉walo kamiyala꞉te dubu uwatoleta, iba꞉te eba kunu eba wagelenalo Nowate kawo peamo ebo opegiya. Ebene ebe tetelo obo kawonomote odolote epo bilibilinomo ebo anakapulamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ega꞉walo Lotako tetelo demaigiya, ebe atu tanalote eba kunu ka꞉kemaigamene. Epate bae naota ega꞉walo elawo da꞉imi obo kawonomamo niota, ibino inamabu maniamo midioleta ega꞉walo mani kawonomamo uwateota, pali inamabu amiota ega꞉walo moto etemoteota, iba꞉te eba kunu eba wagelenalo ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lotate Sodomo duliyomolone pemaigate ebo alauliya. Ebene ebe egelalo elate Godokono Unu Duliyomolone opamo pegate ibi bilibilinomate ela magumulo gito a꞉elaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ebema꞉ Godote Epono Naniwino nanitabo tanalo dawokalimene, ebe tetete eba kunu ka꞉kitanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ebe Kawo Egelalo kebe lumagite moto tanatimilo dokolitamene, ebete moto guamo walo a꞉ka꞉nopegamene ebeno inamabu uwatema꞉, ega꞉walo tumulo woko dosiyodilutamene ebe lumagite atumu ebeno motamo walo a꞉ka꞉toamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ebema꞉ la꞉ Lotakono kamiyaleno tanalo nemalagidilala꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nanitabola, kebe lumagite ebeno kateneno ubi gabodo eba tolo ebeno igilo Godogodone damoeda꞉mene, ebeno igilote kalatidimene, wiyasiya kebe lumagite ebeno igilo Godoko mabuma꞉ datutimene, ebete nanitabo igilo kelaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nale la꞉ analemata, ebe idokolo dubu netewate kapiya ketalo delanama꞉na꞉, Epono Naniwite penate idi eba pelawenalo idi ebo katepanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ega꞉walo kamiyale netewate bae delapautama꞉na꞉, ebete pete idi eba pelawelo idi ebo katepamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ega꞉walo dubu netewate pali bailo dowapaitama꞉na꞉, ebete pete idi eba pelawelo idi ebo katepamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ebene Ya꞉suko waloma꞉tapiate ebe nalatediya, “Kawodawa, me tanalate kebolo na꞉kemaimioma꞉na꞉?” Ya꞉sute wiyasiya iba꞉tamo negiya, “Abale inamabute kebolo kitanamene, waliate aleola꞉go ebamo ka꞉guditama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ebene Ya꞉sute iyatulame oi idi ebe waloma꞉tapiatamo na꞉kiyawaiya, mabu ebe ubia꞉nola iba꞉te tete bilibilinomolo Godotamo towetowe tabo gela magumulo iba꞉te wiya tabo samamo lawea꞉no elawoa꞉noma꞉ eda꞉okapoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ebete negiya, “Duliyomolo idilo tabo anagilamedawa dubute nokolinami, ebete Godotamo ka꞉tuduwatanakia꞉ ega꞉walo ebete epo ka꞉nilakapoilamenakia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ebe atu duliyomololo amole kamiyale idite na꞉kokolinami, ebete tete bilibilinomolo tabo anagilamedawatamo penaki ma kunu pegenaki, ‘A꞉ma꞉le nago da꞉gowelaona, ebe lumagitamo kuba wiya nikama꞉!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Ebene tabo anagilamedawate tete geyageyadopolo ebeno tabo kolowinakia꞉, wiyasiya walone ebete ebeno wokilo ma kunu gi, ‘Na Godotamo ka꞉tuduwatanakoa꞉ ega꞉walo na epatamo nilakapo kiyatinakoa꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","wiyasiya me kamiyalete tete geyageyalo natamo kawo temeteme ikanamena. Nale ebe walubia꞉no me temeteme tanalote a꞉kolopoligomene, ebema꞉ modobola nale ebeno ubi tanalamo tuduwatalo eba꞉go gowelaodawatamo kuba wiya kikaemamo!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ebene Kawodawa Ya꞉sute negiya, “Me tabo anagilamedawa ebe kuba lumagila, wiyasiya ebete degi, modobola la꞉ ebe tabo wadenomamo nemalagidilala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","La꞉imano woki keba kunula꞉ka꞉? Godokono epo magumulo piyate idoko tetelo ega꞉walo egela tetelo ebetamo towetoweolo diimina, ebete iba꞉tamo wiya ikalamea꞉noma꞉ ba꞉keda꞉mene? Ega꞉walo ebete ibi walubilima꞉ ubia꞉noma꞉ eda꞉lo tete ba꞉kegeyageyaima꞉tepamene? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ao! Nale la꞉ analemata, ebete ibi walubililo iba꞉go da꞉gowelaona ebe epatamo kuba wiya samonomamo ka꞉pikalaemene, wiyasiya Epono Naniwite da꞉pemene, ebe tetelo ebete me opo epagodolo nanitabokobi midi tanalo ba꞉ka꞉puimene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ya꞉sute me iyatulame oi idi epo epetapiatamo ka꞉kiyawaiya, mabu ibi a꞉ka꞉tuwa꞉ ibi tuputupupima꞉ eba gelanalo ebo gelanakiya epo epetapi wadewade epoa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ebete negiya, “Dubu netewate Godoko Amamateno Iya Motamo nodoliya Godotamo towetoweoma꞉, idi Pa꞉lisi tanebadawala, idi ta꞉kese mani elemasigilo uwatedawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ebene Pa꞉lisi dubute ebe a꞉ka꞉tuwa꞉ utite ebeno tanaloma꞉ ma kunu gi, ‘Godo, na a꞉ma꞉tamo kalakala tabo kiyawaomo, mabu na me epo epetapidopoa꞉. Ma kunu na inamabu pilolo kuwatenakoa꞉, a꞉da꞉ elemasigi gabodo kepata꞉nakoa꞉, ega꞉walo dubu idino kamiyale pilolo kelawea꞉. Ega꞉walo me ta꞉kese uwatedawate iyaiya kuba dosiyodilolena, na eba kunua꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na kapiya wuiki magumulo nale netewa egelalo a꞉imano woko osiyodiloma꞉ bae naoa꞉no lutanakomo, ega꞉walo nale duwatenakomo ebe inamabu bilibilinomo anagilamolete, epetapi teni apuapu magumune idi kapiya kelawe, idi kapiya kelawe, a꞉imano apu a꞉ma꞉tamo nanitabonomolo ikamenakomata.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Wiyasiya ta꞉kese uwatedawate muludopone nutite, ebete ebeno wato opamo tuduta꞉midate eba utitalo ilipago bodolo anagalimilo negi, ‘Godo, na kawokawo kuba a꞉ma꞉tamo osiyodilolimo, wiyasiya nale a꞉ma꞉ na꞉toweoemata, natamo kuba wiya ikanamea꞉no na na꞉nilakapoinama꞉!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ebene Ya꞉sute negiya, “Na la꞉tamo negemo, Godote me amama꞉ lumagino kuba egebolemete ebete ebeno motamo ebo ti, wiyasiya Pa꞉lisi dubu eba kunu kowagelea꞉. Godote ebeno tanalo ka꞉tupugaimea꞉, ebete ebeno kubago eba kunu ti. Mabu nanitabola, lumagite ebe a꞉ka꞉tuwa꞉ ebe kawoma꞉ da꞉midimene Godote ebe da꞉pesoma꞉ ka꞉midimene, ega꞉walo kebe lumagite ebe a꞉ka꞉tuwa꞉ ebe da꞉pesoma꞉ da꞉midimene Godote wiyasiya ebe kawoma꞉ ka꞉midimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ebene epate gudi egege Ya꞉sutamo nemagaeliya, ebete ebeno koto iba꞉tamo eba watiolelamelo Godoko kanama꞉ ebete ibi wadenomamo kowalubilinama꞉. Ebe tetelo ebe waloma꞉tapiate ebe tanalo umite epo kawiya analelo gudi nodiyoboliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","wiyasiya Ya꞉sute gudi ebetamo eba ka꞉la꞉milo ebe waloma꞉tapiatamo negiya, “Gudi natamo pelaema꞉ modobola. Ako-odiyobola꞉la꞉, mabu mako epate Godote Kawo Elawodawama꞉ deda꞉na ebe duliyomolamo ka꞉nopila꞉oma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na la꞉tamo nani tabo gemo, kebe lumagite gudu da꞉pesomu aimano Kawo Elawodawa Godoko lawea꞉no, ebe lumagite ebeno Kalakala Duliyomolamo a꞉ka꞉nopegamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ebene Yu epono watodawa idite Ya꞉suko eba alateda꞉lo naniya, “Wade Iyatulamedawa, na beda꞉ tanalo osiyodilote uwomua꞉ igilo ebo na꞉kelaemo?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ya꞉sute ebetamo negiya, “A꞉ma꞉le na wadedawama꞉ beda꞉ma꞉ keka꞉na꞉miawa꞉? Wadedawa idi puliyala, Godoko kapiyate wadedawanomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A꞉ma꞉ Godokono Totomu Tabo iyatawala. Lumagi idino kamiyale pilolo akolawa꞉la꞉, lumagi akoanakapuma꞉la꞉, inamabu pilolo akouwata꞉la꞉, lumagi idino tanaloma꞉ a꞉da꞉ tabo akokiyawala꞉, ega꞉walo a꞉imano nabiwila menokola ibino tabamo na꞉tuduwatanakiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wiyasiya ebete Ya꞉sutamo negiya, “Na da꞉peso tetene wagilimite me totomu bilibilinomo kodakodalo uwatete kapiya idi kadikanaliya꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ya꞉sute ebeno tabo olowite ebetamo negiya, “A꞉ma꞉godolo kapiya tanalote ka꞉modobona꞉. Modobola epetapiate a꞉imano inamabu bilibilinomo maniamo uwateometate a꞉ma꞉le ebe mani nigologolopi epetapiatamo nanalabaolama꞉. Ebe tetelo a꞉ma꞉ walo ka꞉pa꞉wete na nowaloma꞉eniye, ebene a꞉imano inamabu bilibilinomate Godokono Unu Duliyomololo ka꞉nepola꞉namene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ebete ebe tabo olowite ebeno tepo magumulo mibonomoma꞉ ediya mabu ebe inamabu bilibilinomagodawanomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ya꞉sute ebe uminate negiya, “Godote Kawo Elawodawama꞉ deda꞉na, inamabu bilibilinomagopiate ebe duliyomolamo nopila꞉oma꞉ kodakodanomola! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Numa꞉la꞉, ka꞉molo-goeote kaliku waluono moe iyado nilupigama꞉ kodakodama꞉ eda꞉na, gaboa꞉nola. Atumu inamabu bilibilinomagodawate Godokono Kawo Elawodawano duliyomolamo nopegama꞉ kodakodanomoma꞉ eda꞉na, gabote nanitabonomolo a꞉kitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ebene Ya꞉sukono tabo olowiopiate ebetamo negeliya, “A꞉ma꞉le degeawa꞉ ebe tabote nanitaboma꞉ deda꞉mene, piyate modobola꞉ka꞉ Godote ibino igilo mula꞉lelaema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ya꞉sute iba꞉tamo eba wiyalo negiya, “Epagodolo da꞉kodakodaona ebe iyaiya tanalo wiyasiya Godogodolo kodakodanomoa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ebene Pitate Ya꞉sutamo negiya, “A꞉ma꞉ numa꞉, aimano motono inamabu bilibilinomo miyapate a꞉ma꞉ nowaloma꞉enata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ya꞉sute iba꞉tamo walo na꞉kegiya, “Na la꞉tamo nani tabo gemo, kebe lumagite ebeno moto, o ebeno kamiyale, o ebeno nanila ekakila ega꞉walo ebeno menokobila nabila gudila, ebe iyaiya tanalo Kawo Elawodawa Godoko mabuma꞉ da꞉miyapamene, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ebete me tetelo wiyasiya Godogodone ebe atu tanalo bilibilinomo walo ka꞉kuwatemene, ega꞉walo walone ebete uwomua꞉ igilo ka꞉kelaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ebene Ya꞉sute ebeno 12 waloma꞉tapi dubu ebetamo ka꞉la꞉mite iba꞉tamo negiya, “La꞉ nolowiala꞉, a Yelusalemamo tolamitama꞉. Ebolo Godokono woki awokalimipiate Epono Naniwi mabuma꞉ Bukamo dakuloliya ebe tanalo bilibilinomate ka꞉pemaimioma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iyo, Godote ebe Yua꞉piatamo kikalaemene, ebene iba꞉te ebe malogolo eba kalakalatelo ebetamo kowe ka꞉meolema꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ega꞉walo iba꞉te pa꞉ka꞉pa꞉ka꞉mo ebe a꞉na꞉ma꞉ga꞉midaote ebene ebe gito kanakapuima꞉na꞉, wiyasiya ebete netewa-kapiya egelalo a꞉ene walo ka꞉kemaigamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Wiyasiya Ya꞉sute da꞉kiyawaiya, ebe waloma꞉tapiate ebe tabono magumu wadenomamo kelawiya꞉. Ebe tanalote waminalo itani ebema꞉ iba꞉te wadenomamo kemalagidiliya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ebene Ya꞉sute Yeliko kawo duliyomolo niyakabamo eba penapelo, balidi tamiome dubute gabo niyakabolo okolite manima꞉ epo ebe toweolamiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ebete epo bilibilinomo gabodo da꞉petolamitiya, ebe tanalo olowite epetapi ebo alateda꞉liya, “Beda꞉ tanalote ka꞉pitale?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Iba꞉te nowaimiya, “Nasalete duliyomolo dubu Ya꞉sute pita.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ebene ebete tabo kawonomamo gelo negiya, “Ya꞉su, Da꞉ibidikono A꞉la꞉mu! A꞉ma꞉le na na꞉nilakapoinama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ebe tetelo dopamo da꞉petolamitiya ebe epate ebe kawiya analo nodiyobiya ebete taboa꞉no kokolitama꞉, wiyasiya ebete kawonomamo walo na꞉kegiya, “Da꞉ibidikono A꞉la꞉mu! A꞉ma꞉le na na꞉nilakapoinama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ebene Ya꞉sute ebamo utite balidi tamiome dubuno tanaloma꞉ negiya, “Ebe nemaga꞉la꞉.” Ebete niyakabamo da꞉piya, ebe tetelo Ya꞉sute ebe nalatediya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“A꞉ma꞉ beda꞉ ubi kiyata꞉wita nale a꞉ma꞉tamo kosiyodiloma꞉?” Ebete negiya, “Kawodawa, na ubila inamabu wadenomamo kulamolema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ebene Ya꞉sute ebetamo negiya, “A꞉ma꞉ balidi na꞉mela꞉! A꞉imano nanitabokobi midi tanalote a꞉ma꞉ wadekobi a꞉mida꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ebema꞉ nanitabola, ebe tetenomolo ebeno balidite wadekobi dolowiomiya, ebete Godoko eba moiolo Ya꞉suko ebo waloma꞉tiya, ebene epo bilibilinomate ebe tanalo umite iba꞉te atumu Godokono mailo unamo ebo adipatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ebe tetelo Ya꞉sute Yeliko duliyomolo magumudo petuti, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ebe duliyomololo Sa꞉kiyaseko nokolinami, ebe ta꞉kese uwatepino watodawala ega꞉walo ebe inamabu bilibilinomagodawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ebete ebeno tepo magumulo negiya, “Ya꞉suko kebako dawala꞉ka꞉?” ebene ebete ebe kuima꞉ ubi kawonomamo niyatiti, wiyasiya ebe gopowai dubula ega꞉walo epo bilibilinomate Ya꞉suko a꞉wa꞉midiya, ebe mabuma꞉ ebete Ya꞉suko uima꞉ modoboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ebema꞉ ebete epono dopo apuamo puligate, umei kewamo gito nodoliya Ya꞉suko kuima꞉, mabu Ya꞉sute ebe gabodo piti. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ebene Ya꞉sute ebamo pemaigate balidi unamo da꞉pemeliya, ebe pumite napaniya, “Sa꞉kiyase, a꞉ma꞉ samamo na꞉piwisiga! Na ka꞉lo egelalo a꞉imano motolo ka꞉lutamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ebe tetelo Sa꞉kiyasete samamo piwisigate, Ya꞉suko lawete ebeno motamo kalakala kawonomago gito magatiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ebene epo bilibilinomate ebe tanalo umite ubia꞉ tabo ma kunu geliya, “Ebete kuba lumagino motamo a꞉to.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wiyasiya Sa꞉kiyasete ebeno motolo epono dopo apulo maigate Ya꞉sutamo negiya, “Kawodawa, a꞉ma꞉ numa꞉! Ka꞉lo nale naimano inamabu tulituliya anagiyamidalete, naimano inamabu epetapi nigologolopiatamo kikalamolemamo, ega꞉walo nale epetapino mani elemasigi gabodo duwatenakimo netewa-netewa teta꞉mo walo ka꞉ka꞉wiyaolemamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ebene Ya꞉sute negiya, “Ka꞉lo egelalo Godokono igilo mula꞉ tanalote me motamo a꞉pe, mabu me dubu atumu ebe A꞉ibalayamakono walone gudu idila. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nanitabola, piyate kuba osiyodilole tanalo magumulo dalatidiolena, ebe epo uwatete ibino igilo ka꞉mula꞉lelaema꞉ na Epono Naniwite ebema꞉ piyamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ebe tabo dolowiutiya ebe epate iyatawaiya Ya꞉sute Yelusalema kawo duliyomolo niyakabamo a꞉pemaiga, ebema꞉ iba꞉te ibino wokilo negeliya, “Diyala, me tetelo Godokono Kawo Elawodawano tanalote atamo da꞉ba꞉pemaigamene.” Ya꞉sute ibino tanalo iyatawate iyatulame oi idi iba꞉tamo ma kunu kiyawaiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Kawo dubu idite mulu opamo tiya, ebe ubila ebe mulu opolo Kawo Elawodubuno gobebobo nelawete, ebete ebeno duliyomolamo ebo ka꞉ka꞉pema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ebete toa꞉no, dopamo ebeno teni wokopi ebetamo ka꞉la꞉mite iditamo 100 mani, iditamo 100 mani, ma kunu eba ikalamolelo ibi nanaliya, ‘La꞉ me mani nekawokawoilamiyala꞉ naimano pe uwomuamo.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ebene ebete mulu opolo eba nokolilo, ebeno opo epo epetapiate ebetamo dowaote ebeno walogabo apune tabo atapi ebo aliboliya. Iba꞉te tolamete tabo ma kunu negeliya, ‘A ubia꞉nola me dubute aimano Kawo Elawodubuma꞉ eda꞉ma꞉, ebete aimano opamo walo a꞉ka꞉pemene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Wiyasiya kawo dubute mulu opolo Kawo Elawodubuno gobebobo nelawete ebeno duliyomolonomamo walo na꞉ka꞉piya. Ebe tetenomolo ebete dopamo piyatamo mani dikalamoliya, ebe wokopi ebetamo na꞉peka꞉la꞉miya ebeno mani uwomu iba꞉godone kiyatawaoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dopodawa ebete pete ebetamo na꞉pegiya, ‘Kawodawa, a꞉imano 100 maniamo nale 1,000 mani idi osiyodilimo.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kawo dubute ebetamo negiya, ‘Oe! A꞉ma꞉ wade wokodawalata! A꞉ma꞉ da꞉peso tanalo wadenomamo osiyodiliata, ebema꞉ nale a꞉ma꞉ teni duliyomolo ulamedawama꞉ ka꞉midimamota.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ebene tetedawa idite pete ebetamo na꞉pegiya, ‘Kawodawa, a꞉imano 100 maniamo nale 500 mani idi osiyodilimo,’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ebene kawo dubute ebetamo negiya, ‘Nale a꞉ma꞉ paibu duliyomolo ulamedawama꞉ ka꞉midimamota.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Walone tetedawa idite pete ebetamo na꞉pegiya, ‘Kawodawa, me a꞉imano 100 manila. A꞉ma꞉ da꞉toawiyala, na me mani kalikamo wadenomamo matuomeote epate umia꞉ baiamo ebo iyatiyamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Na a꞉ma꞉ tolemenamata mabu a꞉ma꞉ genegene dubunomolata. Epetapiate dalomonaka a꞉ma꞉ pa꞉wete ebe inamabu ba꞉puwatenakoma꞉ta, ega꞉walo iba꞉te damionaka a꞉ma꞉ ebe inamabu gito ba꞉petapionakoma꞉ta a꞉ma꞉le a꞉ka꞉tuwa꞉ kenaoaema꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ebema꞉ kawo dubute ebetamo negiya, ‘A꞉ma꞉ kuba wokodawalata! A꞉ma꞉le degeawa꞉, ebe tabote a꞉imano kuba awokalimi! Iyo, a꞉ma꞉ tabo ma kunu egeata, na genegene dubunomola, ega꞉walo epetapiate dalomonaka nale ebe inamabu ba꞉puwatenakomo, ega꞉walo iba꞉te damionaka nale ebe inamabu gito ba꞉petapionakomo. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ebema꞉ mabu keleka꞉ a꞉ma꞉le naimano mani baneka wokopiatamo ka꞉nikalama꞉wiya꞉? Iba꞉te mani uwatete woko idi nosiyodilotaleka꞉ kawodopoma꞉ beda꞉na꞉, ebene nale pete a꞉ma꞉le natamo atu mani wiyasiya kele unudopamo walo ba꞉kikanama꞉wena꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ebene kawo dubute ebeno opopi nanaliya, ‘La꞉ ebeno 100 mani laema꞉wete 1,000 maniago dubutamo nikama꞉la꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Iba꞉te wiyasiya ebetamo negeliya, ‘Kawodawa, eba kunua꞉! Ebe lumagite 1,000 mani iyalo uwati!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ebene kawo dubute iba꞉tamo nowamiya, ‘Na la꞉tamo negemo, kebe lumagigodolo wadewade woki da꞉pola꞉na, idawate ebetamo wadewade tanalo bilibilinomo kikameomene. Wiyasiya kebe lumagigodolo wadewade woki pola꞉na꞉no, ebegodolo kebe kapiyakapiya tanalate da꞉pola꞉na idawate ebegodone walo ka꞉kuwatemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ega꞉walo me tanalo idila. Piyate nago gowelaoma꞉ eba wagelenalo ubia꞉noma꞉ deda꞉ona nale ibino Kawo Elawodubuma꞉ eda꞉ma꞉, la꞉ ibi magaela꞉wete naimano dopo apulo gowelaono gila꞉mo gito napanakapulama꞉la꞉!’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ya꞉sute me tabo epatamo gete ibi dopolamete Yelusalema kawo duliyomolo apuamo gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ebe tetelo ebete Betapa꞉gi duliyomolo ega꞉walo Betani duliyomolo niyakabodo tote Olibi Kewakewa Unu Damelamo ebo nemaigiya, ebene ebete ebe waloma꞉tapi netewa dopamo eba nalibolelo ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","iba꞉tamo negiya, “La꞉ ebe tatali duliyomolamo toawete, ebe duliyomolamo da꞉nemaima꞉ema donoki-goeo da꞉peso ala꞉mo ma꞉midao ebo ka꞉nuimamota, lumagite dopamo ebe unamo kokoliya꞉. Modobola la꞉ ale pamiawete nemagaiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Idawate la꞉tamo degemene, ‘La꞉ ebe beda꞉ma꞉ kepamiawitama?’ la꞉ wiyasiya ma kunu negeliyala꞉, ‘Kawodawate donoki-goeo ubila.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ebene iba꞉te gabodo tote duliyomolamo eba nemaimilo Ya꞉sute ibi keba kunu kanaliyale, iba꞉te ebe iyaiya tanalo eba kunu nulamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Iba꞉te donoki-goeo da꞉peso eba pamitalo, ebe goeono namutupiate iba꞉tamo negeliya, “La꞉ ebe beda꞉ma꞉ kepamiawitama?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Iba꞉te tabo eba wiyalo negeliya, “Kawodawate donoki-goeo ubila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ebene iba꞉te donoki-goeo da꞉peso Ya꞉sutamo magaete, ibino watubino kaliku donoki-goeo unamo alomomete, iba꞉te Ya꞉suko ibino kotamo adipatete gito owodimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ebe tetelo Ya꞉sute eba tutalo epate ibino ga꞉ga꞉ga꞉ga꞉ kaliku pupukulamete gabamo apote, ebete ebe unudo tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ebete Olibi Kewakewa Unu Damelane eba niwisigalo Yelusalema kawo duliyomolo niyakabamo da꞉piya, ebe tetelo ebe dowaloma꞉tanakiya ebe epo bilibilinomate Godotamo kalakala tabo kapimiya kawonomamo wadipalatelelo ebe ebo moiya, mabu iba꞉te kawokawo anoano tanalo bilibilinomo ulamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Iba꞉te tabo ma kunu gelitiya, “Godo, a꞉imano mailago da꞉pita, modobola a꞉ma꞉ ebe Kawo Elawodubu kawokobi na꞉midiye! O epala꞉, la꞉ Godoko moiolo unamo nadipata꞉la꞉, ebe Unu Duliyomolono kalakala tanalono mabula!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ebene epono taneba magumulo da꞉pola꞉niya ebe Pa꞉lisi tanebapi dubate Ya꞉suko kawiya naniya, “Iyatulamedawa, a꞉ma꞉ waloma꞉tapi nodiyobola꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ya꞉sute iba꞉tamo nowamiya, “Nale la꞉tamo negemo, me epate na moionea꞉notaleka꞉ wiyasiya gabono nokolate na eba adipanatenelo kawonomamo begelitana꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ebene Ya꞉sute Yelusalema niyakabamo pete duliyomolo da꞉pumiya, ebete iilo ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","negiya, “Yelusalema, nale a꞉imano milo mabuma꞉ deda꞉namo, a꞉ma꞉ ebe tanalo niyatawawetaleka꞉ a꞉ma꞉ ebe milo belawa꞉wena꞉, wiyasiya a꞉ma꞉ naimano nanitabo tanalo uima꞉ modoboa꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nanitabola, tete ebe na꞉pe a꞉ma꞉go gowelaopima꞉ deda꞉ona, iba꞉te pelamete a꞉ma꞉ kapanakopa꞉midama꞉ta a꞉imano epo kanakapulaema꞉, ebene iba꞉te a꞉imano tametame apulo gowolesi kawokawonomo eba obobolelo iyaiya unuunu damela kosiyodilolema꞉na꞉, a꞉imano epate ibino igilo ka꞉mula꞉lema꞉ iba꞉te iyabaiamo alautiokapoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ebene piyate a꞉imano kala ga꞉dimi magumulo dilukuliona, iba꞉te ebe epo alukolete kopoliyadigalema꞉na꞉, ega꞉walo a꞉imano kawokawo moto iyalekete nokola idite nokola idi unulo a꞉kitanamene. Iba꞉te ma kunu ka꞉posiyodiloma꞉na꞉ mabu Godote a꞉ma꞉ walubima꞉ da꞉pe, a꞉ma꞉ ebe tete anaetoamidawete ebe kelawa꞉wea꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ebene Ya꞉sute Godoko Amamateno Iya Motamo tote, ebe motolo ebete inamabu olowamepi nulamete elawonomamo eba na꞉na꞉ma꞉latelelo ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","iba꞉tamo negiya, “Godokono Bukalo tabo ma kunu bitana, ‘Naimano Moto epate Godoko Amamate Motoma꞉ kegelama꞉na꞉,’ la꞉le wiyasiya pilo epono motoma꞉ a꞉midimata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ebema꞉ Godotamo kalimagono ikameopino watowatopi, ega꞉walo Godokono Totomu iyatulamepi, ega꞉walo Yu epono kawokawo dubu epetapi, iba꞉te Ya꞉suko anakapuima꞉ gabo ebe waditiya. Wiyasiya egela epetapilo Ya꞉sute Godoko Amamateno Iya Motolo epo eba iyatulamitalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","iba꞉te gabo kumiya꞉ mabu epo bilibilinomate Ya꞉sukono tabo olowioma꞉ ubi kawonomamo iyatilo iba꞉te eba꞉go ebo pola꞉niya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Egela idilo Ya꞉sute Godoko Amamateno Iya Motolo epo eba iyatulamitalo Godokono Wade Tabo da꞉kiyawauti, ebe tetelo Godotamo kalimagono ikameopi elawodubu, Godokono Totomu iyatulamepi, ega꞉walo kawokawo dubu epetapi, iba꞉te ebe odiyoboma꞉ ebo pelamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Iba꞉te ebe ma kunu palatediya, “A nanaa꞉, a꞉ma꞉ me iyaiya tanalo pokono elawamo kosiyodilola꞉wena? Ega꞉walo me elawo a꞉ma꞉tamo potele kikametia?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ya꞉sute wiyasiya iba꞉tamo negiya, “Nale la꞉ dopamo kapiya tanaloma꞉ kalateda꞉lemamota. Modobola la꞉le na nananiyala꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yonete epo obamo dowaduba꞉midaolenaki, ebe elawo ebetamo potele kikamile? Godotela꞉ka꞉ o lumagi iditela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ebema꞉ ibi a꞉ka꞉tuwa꞉ ibino taneba magumulo negeliya, “Ale degelama꞉ Godote Yonetamo elawo ikami, ebete kegemene, ‘Beda꞉ mabuma꞉ la꞉le ebeno tabo nanitabokobi ka꞉mida꞉wea꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ega꞉walo a modoboa꞉ ebe ma kunu anama꞉, me opo lumagite Yonetamo elawo ikami. Epate ebe tabo olowite a nokolamo mapeamete kanakapuaema꞉na꞉, mabu iba꞉te negelana Yoneko ebe Godokono woki awokalimidawala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ebema꞉ iba꞉te ibino tepo magumuno woki waminaolelo Ya꞉sutamo negeliya, “Yonekono elawo mabu a iyatawa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ebe tetelo Ya꞉sute iba꞉tamo negiya, “Ebema꞉ nale la꞉ atumu akanaletama nale me iyaiya tanalo pokono elawamo kosiyodilolenamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ebene Ya꞉sute me iyatulame oi epatamo negiya, “Dubute pali osiyodilote tupina da꞉imi kewa ebo ami, ebe da꞉imino mailo ebe gala꞉ipi da꞉imila. Ebene ebete ebeno pali atila꞉pi dubu epetapiatamo gito atepi, iba꞉te ebolo woko eba osiyodilonalo ebe pali wadenomamo umilo ebeno da꞉imi kuwatolemenakoma꞉, ebene ebete mulu opamo tote tete geyageyadopo nokoliatepi. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Da꞉imi tapio tetelo ebete pali atila꞉piatamo wiya꞉ wokodawa napalibi, ebete iba꞉godone da꞉imino mani magumune ebeno kawodawano apu ka꞉pelaema꞉, wiyasiya iba꞉te ebe wokodawa gaubamo anagalimiote inamabua꞉no gito nalibiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ebene ebete wiya꞉ wokodawa idi walo dakapalibi, iba꞉te ebe eba kanagalimiolo ebe ilipo ikamete atumu gito kalibiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ebene ebete walo idi dakapalibi, ebe netewa-kapiya tete dubula, wiyasiya iba꞉te ebe bugomokobi midite pali magumune ebe gito neba꞉idiliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ebe tetelo pali namutudawate negi, ‘Na keba kunu na꞉kowagelemo? Modobola nale kawonomamo demalagidilonamo ebe gudu kanalibomamo. Diyala, iba꞉te ebetamo da꞉ba꞉tudila꞉oma꞉na꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Wiyasiya ebe pali atila꞉pi dubate ebe gudu pitalo dumiya, iba꞉te ibino taneba magumulo negeliya, ‘Numa꞉la꞉, me gudute nabiwino inamabu namutudawama꞉ deda꞉mene, ebe gudute na꞉pe. Ebema꞉ modobola ale ebe anakapumite ebeno pali lawenomo kelaemalema꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ebe tetelo iba꞉te ebe lawete palino kala magumune neba꞉idilote gito nanakapumiya.” Ebema꞉ Ya꞉sute olowiopiatamo negiya, “La꞉imano woki keba kunula꞉ka꞉? Pali namutudawate beda꞉ tanalo na꞉ka꞉posiyodilomene atila꞉pi dubatamo? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nanitabola, ebete pete ibi panakapulamete ebeno pali epetapiatamo ka꞉pikalaemene.” Epate ebe tabo olowite negeliya, “Ao, ebe kubate a꞉ka꞉pemaigamene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ebema꞉ Ya꞉sute ibi ulamelo negiya, “Godokono Bukalo ditana me tabono magumu keba kunula꞉ka꞉? ‘Moto etepiate iyabaiamo diyatiya ebe alote wiyasiya motono elawo mabuma꞉ eda꞉na.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Numa꞉la꞉, ebe alono kodakoda ebe nokola keba kunula꞉ka꞉ eba kunula. Iyo, me nokola unamo degamene ebe lumagite keta꞉ta꞉puwatiomene, ega꞉walo me nokolate lumagi dita꞉timene kedagodagoimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ebene Godokono Totomu tabo iyatulamepi ega꞉walo Godotamo kalimagono ikameopino watowatopi, iba꞉te iyatawaiya Ya꞉sute ebe oi ibino tanaloma꞉ giya, ebema꞉ ibi ubila ebe tetenomolo ebe laema꞉, wiyasiya epo eba tolelamelo walo gito katepiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ebene Yu watowatopiate Ya꞉suko laema꞉ gabo eba wadilo dubu epetapiatamo mani ebo ikalamiya iba꞉te Ya꞉sutamo tolamete ebe kuba gabamo ka꞉nowabuga꞉tama꞉. Ibi ubila ebegodolo iya tabo olowite ebe tabono tanaloma꞉ Loma gabamanino kapela Kawo Elawodubutamo magatate, ebete ebe ebolo kanakapuima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ebema꞉ ebe dubate Ya꞉sutamo pelamete a꞉da꞉ elemasigi gabodo ebe napaniya, “Iyatulamedawa, a iyatawala a꞉ma꞉le da꞉kiyawawenaka ebe iyaiya tanalo ebe nanitabola, ega꞉walo a꞉ma꞉ epo unu nikapiamo kulama꞉wena꞉, ma kunu lumagi idi atepalo lumagi idi ebo a꞉kelawa꞉emene. Iyo, a꞉ma꞉ epo Godokono gabo wadenomamo iyatulamenata, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ebema꞉ a nanaa꞉, Loma epono Kawo Elawodubunomo Sisatamo ta꞉kese mani ikameoma꞉ modobola꞉ka꞉ o kubala꞉ka꞉? A ebetamo ba꞉kikameoma꞉ o a꞉kikameoma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ya꞉sute ibino mena netewa tanalo iyatawate iba꞉tamo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“La꞉ mani kapiya natamo nada꞉la꞉. Ebe manilo da꞉pola꞉na, mailo ega꞉walo ololo pokonola꞉ka꞉?” Iba꞉te ebeno tabo eba wiyalo negeliya, “Kawo Elawodubunomo Sisakonola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ebene Ya꞉sute iba꞉tamo negiya, “Sisakono inamabu Sisatamo nikameala꞉, wiyasiya Godokono inamabu Godotamo nikameala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ebene ebe dubate ka꞉modobiya꞉ epono ololo apulo Ya꞉suko kuba gabamo kowabuga꞉tama꞉, ebema꞉ iba꞉te eba anoanolo tabo idi kegeliya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","A꞉e magumune maimioa꞉noma꞉ degelana, ebe epo Sa꞉diyusi tanebapila. Ibi epetapiate Ya꞉sutamo pelamete tabo ma kunu pegeliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Iyatulamedawa, Godokono Bukamo Mosesete tabo ma kunu akuloliya, ‘Dubute a꞉ete kamiyale gudia꞉no datepamene, ebeno ekawite ebe amole lawete ebeno naniwino tanaloma꞉ gudi nosiyodilolemene.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Dopamo tetelo kapiya dubuno sebeni koiate nilukulinamiya. Ibi magumulo dopo gudute kamiyale lawete gudi ulamea꞉no a꞉iya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ebene ebeno ekawite ebeno amole kelawete eba kunu kowageliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ega꞉walo tetedawa idite atumu kowageliya, ebene ebe sebeni atu alailama꞉te gudia꞉no eba kunu a꞉elaiya ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","wiyasiya kamiyalete walone gito a꞉iya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ebema꞉ iba꞉te a꞉e magumune igilamo demaimioma꞉na꞉, ebe Kawo Egelalo ebe kamiyalete pokono kamiyalema꞉ na꞉keda꞉mene, mabu ebe sebeni dubate aida꞉tepaiya?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ebene Ya꞉sute iba꞉tamo negiya, “Numa꞉la꞉, me opolo dubate kamiyale uwatolete, ebene kamiyala꞉te atumu dubu akouwatolenaka, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","wiyasiya Godokono Unu Duliyomololo eba kunua꞉. Ebete kebe epo ebeno wadewade ga꞉limapi gudima꞉ deka꞉la꞉imene, iba꞉te a꞉e magumune nanitabonomolo igilamo kemaimioma꞉na꞉, ebene ebe tetelo iba꞉te kamiyale walo a꞉ka꞉piaidiolema꞉na꞉ ega꞉walo dubu a꞉ka꞉puwatolema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Me tanalo ebe nanitabola, iba꞉te a꞉e magumune emaimiya, ebema꞉ iba꞉te Godokono nopopimu eba ilukulionalo walo a꞉ka꞉elaoma꞉na꞉, wiyasiya Godokono gudima꞉ eba eda꞉olo uwomua꞉ igilago bilukulionama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Numa꞉la꞉, epate a꞉e magumune demaimioma꞉na꞉, ebe tanalo Mosesete a wadenomamo iyatuamiya. Iyo, ebete me tanalo Godokono Bukamo iyatiya, ma kunu elate kewalo dowaiti wiyasiya kewate kolotolitiya꞉, ebe tetelo Mosesete Kawodawa Godoko ka꞉milo negiya, ‘A꞉ibalayamako, Aisa꞉keko, Ya꞉ikoboko iba꞉te uwomua꞉ tetelo poko kamamatene, a꞉ma꞉ ebe Godotela.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ebema꞉ la꞉ Sa꞉diyusi tanebapi, la꞉imano wokilo na꞉kemalagidilawenama ebe ewonino igilate olopoligoiya? Ao, kolopoligiya꞉, mabu a꞉elaopiate Godoko kamamatena꞉ wiyasiya piyate igilolo dilukulina ebe eponomate ebe amamatena, iyo, a bilibilinomate ebeno uwomua꞉ igilago ilukulinama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ebe tetelo Godokono Totomu iyatulamepi epetapiate Ya꞉sutamo negeliya, “Iyo, Iyatulamedawa, a꞉ma꞉ wadenomamo geata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nanitabola, ebe tetene wagilimite epate Ya꞉suko tanalo idima꞉ alateda꞉ma꞉ na꞉toletoleutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ebene Ya꞉sute iba꞉tamo negiya, “Epate negelana Godokono Alibodawa Kelisoko ebe Da꞉ibidikono a꞉la꞉mula, ebeno walone gudi magumune kawokalamene. Wiyasiya me tanalono magumu keba kunula꞉ka꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","La꞉ numa꞉la꞉, Da꞉ibidite Sam Oale Bukamo tabo ma kunu akuloliya, ‘Kawodawa Godote naimano Kawodawa Kelisotamo nege, ‘A꞉ma꞉ naimano tumudi apuamo na꞉pokoliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ebene a꞉ma꞉go gowelaopi nale ibi a꞉imano agowa puti baima꞉ ka꞉midilimamo.’ ’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ebene Ya꞉sute tabo moga꞉melo walo na꞉kegiya, “Modobola, la꞉ me tabo eba malagidilolo na nanana꞉la꞉, Da꞉ibidite ebeno a꞉la꞉mu Kelisoko ebeno Kawodawama꞉ ka꞉milo ebete Godokono tumudi apuamo okolima꞉ giya, ebema꞉ ebe tanalote keba kunu na꞉ka꞉pemaigamene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ebene epo bilibilinomate ebeno tabo eba olowiutalo Ya꞉sute ebe waloma꞉tapiatamo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“La꞉le Godokono Totomu iyatulamepi wadenomamo nulama꞉la꞉. Ibi ubila ga꞉ga꞉ga꞉ga꞉ kaliku pupuliote olowame bailo eba wapata꞉lamelo epate ibi ebo kowalogolema꞉. Iyo, ibi ubila Yu epono balidi ibilamole moto gulo kawokawo dubuno ilukuli bailo kilukulima꞉, ega꞉walo ibi ubila soliyomu osiyodilo tetelo kawokawo ilukuli bailo ka꞉pola꞉na꞉ma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ega꞉walo iba꞉te amoleamoleno inamabu a꞉da꞉ elemasigi tanalodo eba uwatelo ebo opoliyalelamenaka, ebene iba꞉te ebe tanalo kuba꞉noma꞉ gelalo tolamete Godotamo balidi eba nibilamolelo ga꞉ga꞉ga꞉ga꞉ towetowe tabo ebo negelanaka, mabu ibi ubila epate ibino tanalo umilo ibi wadewadepima꞉ kegelama꞉. Ebema꞉ nanitabola, iba꞉te kuba wiya kawonomo kelaema꞉na꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ebene Ya꞉sute Godoko Amamateno Iya Motolo eba lutalo, inamabu bilibilinomagopiate ibino nilakapo inamabu Godotamo dapalomutiya, ebete ibino tanalo eba umitalo ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","inamabua꞉ amole kamiyale idi ebo kumiya, ebete mani egege netewa dapalomuti. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ebema꞉ ebete negiya, “Na la꞉tamo nani tabo gemo, epate mani dapaloma me inamabua꞉ amole kamiyalete ibi bilibilinomo odoili, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","mabu inamabu bilibilinomagopiate ibino inamabu epetapi da꞉luililamenako ebe inamabu paloma, wiyasiya me amole kamiyale inamabua꞉nola. Ebete ebeno bae uwateono mani alomonomo apalomo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ebe tetelo Ya꞉suko waloma꞉tapi epetapiate Godoko Amamateno Iya Motoma꞉ ma kunu gelitiya, “Me nokola moto kawokawo wadewadenonomola! Ega꞉walo epate malo Godotamo nilakapolo dikameonaka, ebe inamabuate wadewadenoma꞉ eda꞉ona!” Ebene Ya꞉sute iba꞉tamo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“La꞉ me inamabu dulama꞉witama, walone tetelo ibi bilibilinomate ka꞉kubakubaoma꞉na꞉. Ebe tetelo me iyaiya motono tanaloma꞉ nokola idite nokola idi unulo a꞉ka꞉pola꞉nama꞉na꞉, mabu gowelaopiate me nokola bilibilinomo mapitaolete opamo iyalekenomo ka꞉piyalekema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ebene iba꞉te Ya꞉suko nalatediya, “Iyatulamedawa, Godokono Moto kubaimi tanalote kebe tetelo na꞉ka꞉pemaigamene? A beda꞉ anoano tanalate na꞉kiyatuaemene tete ebe na꞉pe ebe tanalote ka꞉pemaigama꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ebene Ya꞉sute iba꞉tamo negiya, “La꞉ nanisiwale. Lumagi idite la꞉ demasigilitamene, la꞉ ebeno tabo ako-olowiala꞉, mabu dubu bilibilinomo epetapiate naimano mailamo pelamete ka꞉pegelama꞉na꞉, ‘Na ebe Kelisotela! Tete ebe na꞉pe!’ wiyasiya la꞉ ibi akowaloma꞉tala꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ega꞉walo la꞉le iyaiya opo epono gowelao tanalo ega꞉walo ibino gowelao nopo iyati tanalo dolowiaema, ebe mabuma꞉ la꞉ kawonomamo akotoletoleala꞉. Me tanalate nanitabolo ka꞉pemaimioma꞉na꞉, wiyasiya ebe tete ebe uwomu tetea꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ya꞉sute iba꞉tamo walo na꞉kegiya, “Nanitabola, opo epetapino epate opo epetapino epago ka꞉gowelaoma꞉na꞉, iyo, opo idite opo iditamo gowela tanalo kosiyodilomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ebene kawokawo mumulate iyaiya opo bilibilinomamo ka꞉pelaema꞉na꞉, ega꞉walo kawokawo gabugabuno temeteme tanalate ebe iyaiya epo kuwatema꞉na꞉, ega꞉walo iyaiya duliyomolo epetapilo epate baea꞉no kilukulioma꞉na꞉, ebene ebe atu tetelo tobolo unulo iyaiya anoano tanalo ega꞉walo Godokono elawo awokalimino tanalate ka꞉pemaimioma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Me tanalate maimioa꞉no kubakubapiate dopamo la꞉ elawamo uwatetate temeteme ebo kikalaema꞉ta. Iyo, Yu epono balidi ibilamole moto gulo iba꞉te la꞉imano tanalo anagilamelelametate la꞉ idoko motamo gito kalomoma꞉ta, ega꞉walo na mabuma꞉ iba꞉te la꞉ iyaiya kawokawo elawodubuno ololo apuamo magataletate, iba꞉te atumu la꞉imano tanalo kakanagilamelelaema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ebe tetelo la꞉ wiyasiya iba꞉tamo naimano Wade Tabote na꞉kiyawaiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ebema꞉ la꞉le ibino ololo apulo eba lamota꞉onalo la꞉imano mailo wadekobi keba kunu ka꞉midila꞉ema, ebe tetete pemaiga꞉no la꞉imano gela tanaloma꞉ woki bilibilima꞉ akoeda꞉oala꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","mabu nale la꞉tamo mulo woki ega꞉walo tabo eba ikalamelo, piyate la꞉go gowelaopima꞉ deda꞉ona iba꞉te la꞉imano nani tabo kubailaema꞉ a꞉ka꞉modoboma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Ega꞉walo me tanalo idila. La꞉imano nabila menokobila, ega꞉walo nanila ekakila, ega꞉walo la꞉imano kalima epo epetapila namutupila, iba꞉te la꞉go da꞉gowelaona ebe kubakubapino kotamo la꞉ kanalomoma꞉ta, iyo, la꞉ epetapi la꞉imano epate gito kanakapulaema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nanitabola, na mabuma꞉ epo bilibilinomate la꞉tamo ka꞉dowaoma꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","wiyasiya naimano umi magumulo la꞉imano watono eke idi kapiyate akalatidimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ebema꞉ la꞉imano kodakodalo utitata tanalodo la꞉le la꞉imano igilo ma kunu ka꞉mula꞉lemamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ebene Ya꞉sute walo na꞉kegiya, “Iyaiya opono gowelaopiate pelamete Yelusalema dapanakopa꞉midama꞉na꞉, la꞉ ebe tanalo duma꞉ema la꞉ kiyatawaomamota ebeno olalati tete ebe a꞉pemaiga. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ebema꞉ gowelaopiate pemaimioa꞉no, modobola Yudiya opo epate dopamo unuunu damelamo nalautioma꞉na꞉, ega꞉walo Yelusalemalo dilukuliona ibi atumu iyabaiamo na꞉ka꞉tolaema꞉na꞉. Numa꞉la꞉, ebe tetelo piyate tumulo da꞉pola꞉nama꞉na꞉ iba꞉te kawo duliyomolono kala ga꞉dimi magumamo nopila꞉oma꞉ modoboa꞉, mabu iba꞉te ebolo wade opila꞉o bai a꞉ka꞉nuima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nanitabola, Godote dopamo ebeno Bukamo dakuloliya ebe tanalate nanitabonomolo ka꞉pemaimioma꞉na꞉, iyo, ebe tete ebe Yelusalema duliyomolono kuba wiya lawe egelala. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ebema꞉ numa꞉la꞉, lamitulamitu ega꞉walo nono dikalamena ebe kamiyala꞉tamo ebe egelate kubanomoma꞉ keda꞉mene, mabu nanitabola, Godokono kawo dowa tanalonomote Yelusalema epatamo eba itanalo, ibino opolo kawokawo tepo temetema꞉te ka꞉pemaimioma꞉na꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Iyo, gowelaopiate ibi epetapi gowelaono gila꞉mo kanakapulaema꞉na꞉, ega꞉walo ibi epetapi ala꞉mo matuolamolete iyaiya mulu opamo kemagatalema꞉na꞉, ebene nanitabokobi midia꞉piate Yelusalema duliyomolo ibino agowamo ka꞉mikitama꞉na꞉, Godote iba꞉tamo dikalaemene ebe tete uwomuamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ebene egela, sagana, ega꞉walo mawele, ibi magumulo kawokawo anoano tanalate da꞉pemaimioma꞉na꞉, me opo kawonomolo epate woki bilibilima꞉ eba eda꞉olo balidi koba꞉midaolema꞉na꞉, iyo, ebe atu tetelo kewa꞉ kolomono kawokawo ulate maimiote kolomo bala dapalukolema꞉na꞉, iba꞉te ebe obono diyamo dolowima꞉na꞉ kawonomamo ka꞉toletoleoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ega꞉walo ebe tetelo tobolo ununo elawoelawo inamabuate kalela꞉oma꞉na꞉, ebema꞉ epate me opono kawo olalati tanalo eba makopelelo, iba꞉te tole kawonomamo lawete elawoa꞉noma꞉ ebo keda꞉oma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ebene ebe tetelo Epono Naniwite tobolo unune eba piwisigalo iba꞉te ebe ebo kuima꞉na꞉, ebete ebeno elawago ega꞉walo alo kawonomago ka꞉pemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ebema꞉ me temeteme tanalate maimi dowagilima꞉na꞉, ebe tetelo la꞉ unamo na꞉nemeliyala꞉ mabu la꞉imano igilo mula꞉le tete ebe netatali.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ebene Ya꞉sute uli tabo iba꞉tamo ma kunu iyatulamiya, “La꞉ umei kewa ega꞉walo iyaiya kewano tanalo wadenomamo nemalagidilala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","La꞉le ibino paa mogoiamidale tanalo dulama꞉ema, ebe tanalote la꞉ kiyatulamema꞉ta ulamano tete ebe netatali, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ebema꞉ me temeteme tanalate maimiolo dulama꞉ema, la꞉ kiyatawaomamota Godokono Kawo Elawodawano tete ebe na꞉pe. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Na la꞉tamo nani tabo gemo, me tanalo bilibilinomate dopamo ka꞉pemaimioma꞉na꞉, walone me tete epate ebo ka꞉elaoma꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","iyo, me opo ega꞉walo tobolo unu iba꞉te kolopoligoma꞉na꞉, wiyasiya naimano tabote a꞉kolopoligomene, uwomua꞉ tetelo bitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“La꞉ a꞉ka꞉tuwa꞉ la꞉ wadenomamo nulamenala꞉! La꞉ bae nao tanaloma꞉, ega꞉walo elawo da꞉imi obo nio tanaloma꞉, ega꞉walo me opono inamabu uwate tanaloma꞉ woki bilibilima꞉ akoeda꞉onala꞉. La꞉ nanisiwale, ebe Kawo Egelate samonomamo da꞉pemaigamene la꞉ kawonomamo da꞉bela꞉wa꞉oma, me tanalo ebe gubite inamabu danagalimi keba kunula꞉ka꞉ eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Iyo, ebe Kawo Egelate me opolo dilukuliona ebe epo bilibilinomatamo ma kunu ka꞉pemene, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ebema꞉ tete bilibilinomolo la꞉ olowiolo eba ilukulinalo Godotamo na꞉towetoweonala꞉. Ebe tanalo magumulo la꞉le ebeno elawo lawa꞉wete, kawokawo temetema꞉te da꞉pelaema꞉na꞉ la꞉ ebe iyaiya tanalo magumudo nemaimiawete Epono Naniwino dopo apulo ka꞉nelamota꞉onamamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ebene egela epetapilo Ya꞉sute Yelusalemamo da꞉penaki ebete Godoko Amamateno Iya Motolo epo piyatulamenaki, wiyasiya didokonaki ebete duliyomolone walo ka꞉tonaki Olibi Kewakewa Unu Damelalo ebo nowatanaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ebe tetelo epo bilibilinomate duiyanomolo Godoko Amamateno Motamo pelamenakiya ebeno tabo ka꞉polowioma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Unamo Maiga꞉ Palowa Bae Soliyomu ebeno mailo idi ebe Aduga꞉la Soliyomula, ebeno osiyodilo tanalo detataliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ebe tetelo Godotamo kalimagono ikameopino watowatopi ega꞉walo Godokono Totomu iyatulamepi dubu, iba꞉te Ya꞉suko anakapumi gabo waditiya, wiyasiya iba꞉te epo tolelamelo awokala kosiyodilutiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ebene Saitanate Keliyota duliyomolodawa Yudasikono tepo magumamo opegiya, Ya꞉sukono 12 waloma꞉tapino taneba magumulo ebe idila. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ebete Godotamo kalimagono ikameopino watowatopi ega꞉walo Godoko Amamateno Moto atila꞉pi dubu iba꞉tamo tote nopo ebo niyatiya Ya꞉suko ibino kotamo kiyatima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ebe tetelo iba꞉te ebe tanalo olowite kalakalaolo tabo ebo iyatiya ebetamo mani kikaema꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ebema꞉ Yudasite ebe tabamo tuduwatate, iba꞉godone tote gabo ebo nowadiya epoa꞉ tetelo Ya꞉suko ibino kotamo kiyatima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yu epono osiyodilo tanalo ma kunula, iba꞉te ulama bilibilinomolo Unamo Maiga꞉ Palowa Bae Soliyomu nao dowagiliminakiya, ebe dopo egelalo iba꞉te Aduga꞉la Soliyomuno sipi-goeogoeo egege alukolenakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ebema꞉ Ya꞉sute Pitako Yoneko ibi netewapi eba nalibolelo negiya, “La꞉ toawete Aduga꞉la Soliyomuno nao inamabu na꞉nosiyodiloliyala꞉, ale ka꞉penaoma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Iba꞉te ebetamo negeliya, “Ale kebolo na꞉ka꞉nosiyodilolema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ebete iba꞉tamo nowamiya, “La꞉ kawo duliyomolamo na꞉toala꞉, ebene obo daguwaita ebe dubute la꞉go dapalugomene, la꞉le ebe ebo nowaloma꞉tiyala꞉. Ebete kebe motamo ka꞉nodolomene, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","la꞉ ebe moto namutudawatamo ma kunu na꞉negeliyala꞉, ‘Iyatulamedawate a꞉ma꞉tamo ge, moto keleka꞉ nale naimano waloma꞉tapiago Aduga꞉la Soliyomu bae ka꞉penama꞉?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ebe tetelo ebete la꞉ moto guamo kemagatalema꞉ta, unu motolo tete kawo bitana, iyalo osiyodilaka. La꞉ ebolo nao inamabu na꞉nosiyodiloliyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ebene iba꞉te tote, Ya꞉sute kebe tanaloma꞉ kanaliyale, iba꞉te ebe tanalo nulamete Aduga꞉la Soliyomuno nao inamabu ebo nosiyodiloliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tete da꞉peni Ya꞉sute ebe alibolepi dubago bae nama꞉ ilukuliniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ebene ebete iba꞉tamo negeni, “Na ubi kawonomamo niyatinatimo, nale a꞉ea꞉no dopamo me Aduga꞉la Soliyomu la꞉go kenama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ebema꞉ nale la꞉tamo negemo, nale me soliyomu bae me tetelo walo a꞉kenamo, wiyasiya Godokono Kawo Elawodawano tete da꞉pemene, ebe tetelo me soliyomuno magumute nanitabolo dawokalamene nale ebo kenamamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ebene Ya꞉sute kalili lawenate Godotamo kalakala tabo genate iba꞉tamo negeni, “La꞉ me kalili lawa꞉wete, la꞉ magumulo idite iditamo kikame, idite iditamo kikame, ma kunu nowagela꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nale la꞉tamo negemo, na me tetelo me elawo da꞉imi obo walo a꞉ka꞉nimo, wiyasiya Godokono Kawo Elawodawano tete da꞉pemene, ebe tetelo nale ebo ka꞉nimamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ebe tetelo ebete bae kelawenate Godotamo kalakala tabo genate, wakamionate iba꞉tamo eba ikalamolenalo negeni, “Me naimano apela, la꞉ mabuma꞉ Godotamo ikaemo. La꞉le na malagidilonelo me tanalo nosiyodilonakiyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ebene ibino bae nao tanalo dolopoligoni, ebete kalili walo kelawenate negeni, “Me kalili ebe Godote epago milolo kilukulinama꞉ oli nopo diyatiya me ebe tanalola. La꞉ mabuma꞉ deka꞉ka꞉liyamene, me naimano kalimate ebe nopo kodakodaimina. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“La꞉ numa꞉la꞉! Na anakapunamepiatamo dikanaemene, ebe lumagite nago me bae nao bailo ba꞉luta! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Iyo, ebe nanitabola, Epono Naniwite a꞉eamo ebe na꞉to, Godote nopo dopamo diyatiya eba kunu, wiyasiya kebe lumagite ebe anakapumipiatamo dikalaemene, ebe dubute kuba wiya kawonomo kelaemene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ebene ibi a꞉ka꞉tuwa꞉ ibi magumulo idite idi ananaki, idite idi ananaki, eba kunu eba wagelenalo negelaniya, “Me kuba potele na꞉kosiyodilomene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ebe tetelo Ya꞉suko waloma꞉tapi magumulo potele kawoma꞉ eda꞉ tanaloma꞉ apaminateui tanalote maigani. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ebene Ya꞉sute iba꞉tamo negeni, “Godoko nanitabokobi midia꞉pino kawokawo elawodubate ibi a꞉ka꞉tuwa꞉ ibi eba wadipalatelelo epo epetapi elawamo analenaka iba꞉te ibino ubi tanalamo ka꞉tudila꞉onama꞉, ega꞉walo ebe kawokawopi ubila epate ibi walubilipima꞉ eba ka꞉la꞉milo ibi ebo kemoiolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wiyasiya la꞉imano tanalo eba kunua꞉. Modobola la꞉imano taneba magumulo kawodawate oli ape lumagi keba kunula꞉ka꞉ ebakodawama꞉ neda꞉mene, ega꞉walo la꞉imano watodawate atumu ebe wiya꞉ wokodawa keba kunula꞉ka꞉ ebakodawama꞉ na꞉keda꞉mene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Numa꞉la꞉, wadewade bae nao bailo dokolita epate ebako lumagi kawodawama꞉ gelanaka, wiyasiya kebe lumagite ebetamo bae dadaemenako iba꞉te ebe wiya꞉ wokodawama꞉ gelanaka. Nanitabola, na wiya꞉ wokodawa keba kunula꞉ka꞉, nale la꞉imano taneba magumulo ebako da꞉pesodawama꞉ eda꞉namo, ebema꞉ modobola la꞉ atumu eba kunu nilukuliniyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nanitabola, naimano kodakoda tanalo magumulo da꞉lutanakimo, la꞉le na katepana꞉wenakia꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ebema꞉ Nabiwite na Kawo Elawodubuma꞉ keba kunu ka꞉midiniyale nale la꞉ atumu eba kunu ka꞉ka꞉midilimamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ebene na Godokono Unu Duliyomololo Kawo Elawodawama꞉ eba neda꞉lo, la꞉ nago soliyomu bae nawete da꞉imi obo ebo ka꞉niomamota, ega꞉walo la꞉ kawokawo elawodubuno ilukuli bailo ilukula꞉wete Isalaela 12 gu epono iyaiya tanalo anagilamelelamepima꞉ keda꞉omamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ebene Ya꞉sute negeni, “Saimono, Saimono, a꞉ma꞉ nolowia. Dubute witi-laisono tanalo kuima꞉, da꞉ wadenola꞉ o da꞉ kubanola꞉, ebete keba kunu kanamogolenakole, Saitanako ubila a꞉ma꞉ kuba gabamo eba kunu kowabuga꞉tatama꞉, ebema꞉ Godote ebe tanalo iyatawate ebetamo modoboma꞉ ge. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ebema꞉ Saimono, nale a꞉ma꞉ mabuma꞉ Godoko a꞉toweoma꞉kamo, ebete a꞉ma꞉ eba walubilo a꞉imano nanitabokobi midi tanalote akalatidimene. A꞉ma꞉ natamo walo da꞉kolobigaemene, ebe tetelo a꞉imano ekaki elawokobi na꞉midiliye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pitate ebetamo nowamini, “Kawodawa, nale a꞉ma꞉go idoko motamo tote da꞉na꞉emo, na ebe tanaloma꞉ olosiyodilomo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ya꞉sute wiyasiya negeni, “Pita, na a꞉ma꞉tamo negemo, ka꞉lo idokolo kakabate geoa꞉no a꞉ma꞉ netewa-kapiya teta꞉mo na iyatawa꞉noma꞉ kegema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ya꞉sute iba꞉tamo negeni, “Nale la꞉ dopamo danaliboletima, la꞉ ma kunu analiamata, ‘Mania꞉no, ikuwa꞉no, ega꞉walo agowa pata꞉no na꞉tolamiyala꞉,’ ebema꞉ ebe tetelo la꞉ modoboa꞉ tanalo a꞉ka꞉niyatawaima?” Iba꞉te nowaiminiya, “Ao, nigologolo tanalo idi ka꞉numia꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ebene Ya꞉sute iba꞉tamo negeni, “Ka꞉lo wiyasiya na tabo idi ma kunu gemo, ale eba tolamelo la꞉godolo mani o baeno ikuwa da꞉pola꞉lametana nuwatiyala꞉, ega꞉walo pogodolo gowelaono gili itana꞉no, modobola ebete ebeno lubudino kaliku maniamo na꞉midite wiyasiya elawo gilite nelaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mabu na la꞉tamo negemo, Godote naimano tanaloma꞉ ebeno Bukamo dakuloliya, tete na꞉pe ebe tanalote kemaigamene, iyo, buka apuno tabote ma kunu gena, ‘Iba꞉te ebe kubakubapiago kapiyama꞉ midiya.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ebene iba꞉te negelaniya, “Kawodawa, a꞉ma꞉ numa꞉. Mela, gowelaono gili netewa ba꞉pola꞉na!” Ya꞉sute nowamini, “Eiye! La꞉ naimano tabono magumu wadenomamo kelawa꞉wena꞉. Taula, nitanana.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ebene Ya꞉sute Yelusalema duliyomolone nemaiganate ebete dopamo keba kunu kosiyodilonakile, eba kunu ebete ebe waloma꞉tapiago Olibi Kewakewa Unu Damelamo gito tolameniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ebete ebe damelamo nemaiganate ibi nanaleni, “La꞉ malo Godotamo na꞉towetoweonala꞉ mabu la꞉le Saitanakono kuba gabamo wabuga꞉ta tanalamo da꞉ba꞉gudima.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ebene ebete ibi miyapanate kela꞉mo tonate, ebe tetelo ebete pupamo nokolinate Godotamo ebo na꞉towetoweoni. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ebete na꞉geni, “Aba, a꞉ma꞉ ubi diyata꞉emene me tepo temeteme kalili nagodone nelawa꞉. Wiyasiya naimano ubia꞉, a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉imano ubila nosiyodila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ebe tetelo Godokono Unu Duliyomolone nopodawate ebetamo pemaiganate ebe elawokobi ebo pa꞉midini, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ega꞉walo ebete tepo temeteme kawonomoma꞉ eda꞉nate elawonomamo Godotamo eba towetoweonalo, ebeno kolowate kalimama꞉ eda꞉omenate opamo ebo ka꞉ka꞉liyaomeni. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ebene ebete towetoweo tabo gela baine maiganate ebe waloma꞉tapiatamo da꞉peni iba꞉te tepo temetema꞉go laonalo pulameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ebete iba꞉tamo negeni, “La꞉ beda꞉ mabuma꞉ kelawenama? La꞉ maimiawete Godotamo na꞉towetoweonala꞉, mabu la꞉le Saitanakono kuba gabamo wabuga꞉ta tanalamo da꞉ba꞉gudima.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ya꞉sute ebe tabo eba genalo, ebeno waloma꞉tapi 12 magumulo dubu idi Yudasite dubu bilibilinomo epetapi dopolamenate iba꞉te kapimiya ebo pelameniya. Ebene ebete Ya꞉sutamo nilakapo tabo genate ebe kapaboeteonama꞉ niyakabamo da꞉peni, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ya꞉sute ebetamo negeni, “Yudasi, a꞉ma꞉ Epono Naniwi eba paboeteolo ebe anakapumipiatamo ikalaema꞉ ka꞉pa꞉wa꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ebene Ya꞉suko lawe tanalote maigama꞉ eba penalo, ebe waloma꞉tapi dubate ebe tanalo uminate negelaniya, “Kawodawa, ale ibi gowelaono gila꞉mo bakalukolema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ebene ibi magumulo idawate maiganate Godotamo kalimagono ikameopino Ununomo Watodawano moto wokodawa anagaliminate ebeno tumudi apuno galo ebo mapitamidameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ya꞉sute wiyasiya ibi kawiya nanaleni, “Taula, nolodiyobala꞉!” ebene ebete ebe dubuno galo dologimini ebe tetelo wadekobi nolowini. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ebene Godotamo kalimagono ikameopino watowatopi, ega꞉walo Godoko Amamateno Moto atila꞉pi dubu, ega꞉walo kawokawo dubu epetapi, iba꞉te Ya꞉suko laema꞉ da꞉pelameniya ebete iba꞉tamo negeni, “Na pilo lumagila꞉ka꞉, o na gowelaodawala꞉ka꞉? La꞉le na lawenema꞉ gowelaono gila꞉go ega꞉walo gaubago beda꞉ma꞉ ka꞉pelama꞉ema? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na egela epetapilo Godoko Amamateno Iya Motolo la꞉imano ololo apulo da꞉pokolitanakimo, ebe tetelo la꞉le na kelawena꞉wea꞉. Wiyasiya me idoko la꞉imano tetela, iyo, idoko namutudawama꞉ deda꞉na ebeno elawo tetete a꞉pemaiga.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ebe tetelo iba꞉te Ya꞉suko kotamo kodakodanomolo lawenate, Godotamo kalimagono ikameopino Unu Watodawanomono motamo magataniya, wiyasiya Pitate ibi muludopone waloma꞉taleni. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ebene epetapiate motono kala magumulo ela madonate eba pola꞉nalo, Pitate kala ga꞉dimi magumamo nopeganate iba꞉go ebo nokolini. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ebe tetelo Pitate elano alolo eba nokolinalo, woko buwelete ebe wadenomamo uminate negeni, “Me dubu atumu Ya꞉suago pata꞉nami!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pitate wiyasiya negeni, “Kamiyale, na iyatawa꞉ ebe!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ebene iba꞉te tete da꞉pesamo ilukula꞉tepanate, dubu idite ebe wadenomamo uminate walo nakanani, “A꞉ma꞉ atumu ebe waloma꞉tadawa idilata!” Pitate wiyasiya negeni, “Dubu, na ebe iyatawa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tete kele kawodopo da꞉ka꞉petoni, dubu idite elawodopamo na꞉kegeni, “Nanitabola, me dubu Ya꞉suago pata꞉nami, mabu ebe Ga꞉lili opodawala!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pitate wiyasiya negeni, “Dubu, a꞉ma꞉le degeawena ebe tabono tanalo na iyatawa꞉!” Ebe tetenomolo ebete ebe tabo eba genalo kakabate negeoni, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ebene Kawodawa Ya꞉sute olobiganate da꞉nemeleni Pitako ebo numini. Ebe tetelo Ya꞉sute ebetamo dopamo kebe tabo kegenile, Pitate ebe tabo ebo malagidiloni, “Ka꞉lo idokolo kakabate geoa꞉no, a꞉ma꞉le netewa-kapiya teta꞉mo na iyatawa꞉noma꞉ kegema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ebene Pitate iyabaiamo tonate kawo tepo temetemenomago iinomo ebo niini. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ebene Godoko Amamateno Moto atila꞉pi dubate Ya꞉suko eba kalakalatenalo ebo anagalimioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Iba꞉te kalikamo ebeno ololo mula꞉menate ebe anagalimiolo negelaniya, “A꞉ma꞉ Godokono woki awokalimidawama꞉ nanitabolo deda꞉wena, a꞉ma꞉ negea piyate kanagalimiotana!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ega꞉walo iba꞉te ebe eba malogonalo kubakuba tabo epetapi bilibilinomo ebetamo ebo kiyawaoniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ebene egela walo apuamo Godotamo kalimagono ikameopino watowatopi, ega꞉walo Godokono Totomu iyatulamepi, ega꞉walo Yu epono kawokawo dubu epetapi, iba꞉te aladabutinate epetapiate Ya꞉suko ibino dopo apuamo magatanate nananiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“A꞉ma꞉ a nanaa꞉, a꞉ma꞉ Godokono Alibodawa Kelisotela꞉ka꞉?” Ebete wiyasiya iba꞉tamo negeni, “Nale la꞉imano tabo nanitabolo dowaimo la꞉ nanitabokobi a꞉ka꞉mida꞉ema, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ega꞉walo nale la꞉ tanalo idima꞉ dalateda꞉letama, ebe tetelo la꞉le natamo wiya tabo wadenomamo a꞉kegelaema. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nanitabola, na Epono Naniwite me tetene wagilimite Elawodawa Godokono tumudi apulo ka꞉nokolimamo!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ebe tetelo ibi bilibilinomate negelaniya, “A꞉imano tabono magumu keba kunula꞉ka꞉? A꞉ma꞉ Godokono nani Gudula꞉ka꞉?” Ebete iba꞉tamo nowamini, “La꞉le ebe ebe gelamata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ebema꞉ iba꞉te negelaniya, “A me dubuno kuba kiyatawaoma꞉ tabo gedawa idi a ubia꞉nola, mabu a a꞉ka꞉tuwa꞉ ebeno tabonomone ebe olowima꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ebene ibi bilibilinomate maimiote Ya꞉suko lawete Paeletetamo ebe gito magatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Iba꞉te ebeno tanalo eba anagilamelemelo Paeletetamo negeliya, “A me dubu uima꞉ ebete aimano epo eba iyatulamitalo da꞉kubailamiti, ebete ibi ma kunu odiyoboli iba꞉te Kawo Elawodubunomo Sisatamo ta꞉kese mani ikameoma꞉, ega꞉walo ebete iba꞉tamo negenako ebe Kelisotela, Kawo Elawodubula.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ebema꞉ Paeletete ebe nalatediya, “A꞉ma꞉ Yu epono Kawo Elawodubula꞉ka꞉?” Ya꞉sute ebetamo nowamiya, “A꞉ma꞉le ebe ebe geata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ebene Paeletete Godotamo kalimagono ikameopino watowatopi ega꞉walo tabo olowioma꞉ da꞉pelamiya ebe epo bilibilinomatamo negiya, “Na me dubuno kuba idi kumita꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wiyasiya iba꞉te elawonomamo walo na꞉kegeliya, “Ebete dopamo Ga꞉lili opone wagilimite mamo pemaiga epo kubanu iyatulamenaki, ma kunu Yudiya opo kawonomolo ebete ibi nanalenako iba꞉te gabamaniatamo gowelao tanalo kosiyodiloma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Paeletete ibino tabo olowite ebe a꞉ka꞉tuwa꞉ ebetamo negiya, “Oe, me dubu Ga꞉lili opodawala!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ebe tetelo Paeletete iyatawiya Elodite Yelusalema kawo duliyomololo okoliatepama꞉ da꞉piya, ebema꞉ ebete Ya꞉suko ebetamo gito nalibiya mabu Elodiko Ga꞉lili opono Kawo Elawodubula ega꞉walo Ya꞉suko ebe opone piya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ebene Elodite Ya꞉suko umite kawonomamo kalakaliya, mabu ebete Ya꞉sukono osiyodilole tanalo olowite tete geyageyanomolo ebe uima꞉ ubi eba iyatinalo ma kunu malagidilonami, “Diyala, Ya꞉sute naimano ololo apulo anoano tanalo idi da꞉bosiyodilomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ebe mabuma꞉ Elodite Ya꞉suko iyaiya tanalo bilibilinomoma꞉ nalateda꞉iya, wiyasiya Ya꞉sute ebetamo tabo kapiya idi kegiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ebene Godotamo kalimagono ikameopino watowatopi ega꞉walo Godokono Totomu iyatulamepi, iba꞉te maimiote Ya꞉sukono tanalo eba anagilamelemelo ebe kuba lumagima꞉ gelalo elawonomamo geliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ega꞉walo ebe atu tetelo Elodite ebeno gowelaopiago Ya꞉suko malogolo nekalakalatitiya. Ebe kalakala magumulo iba꞉te kawokawo elawodubate da꞉pupulinaka ebako kaliku ebetamo pulimite, ebene iba꞉te eba kunu Paeletetamo walo gito kanalibiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ega꞉walo me tanalo idila. Elodiko ega꞉walo Paeleteko ibi netewapiate dopamo idite iditamo dowanaki eba kunu wagelenamiya, wiyasiya me egelane wagilimite iba꞉te namutupima꞉ nanitabonomolo ediya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ebene Paeletete Godotamo kalimagono ikameopino watowatopi, ega꞉walo Yu epono kawokawo dubu epetapi, ega꞉walo kebe epate ibino tabo olowioma꞉ da꞉pelamiya, ibi bilibilinomo ebetamo ka꞉la꞉mite ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","iba꞉tamo negiya, “La꞉ me dubu natamo epo kubailamedawamu magaemata, wiyasiya nale la꞉imano ololo apulo ebeno iyaiya tanalo danagilamelemo ebegodolo kuba idi kumia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ega꞉walo Elodite atumu ebegodolo kuba idi kuimia꞉, ebete ebe atamo ebema꞉ kapalibo. Nanitabola, ebete kawo kuba idi kosiyodiloa꞉ ebete ebema꞉ a꞉ela. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ebema꞉ modobola nale ebe pa꞉ka꞉pa꞉ka꞉mo a꞉na꞉ma꞉ga꞉midaote gito kalibomamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Paeletete me tabo negiya mabu ebeno osiyodilo tanalo ebe ma kunula, ulama bilibilinomo magumulo Yu epono Aduga꞉la Soliyomu tetelo iba꞉te idoko motolo kapiya lumagi mailamo deka꞉minakiya, Paeletete ebe lumagi ebeno kuba wiyane gito alibonaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wiyasiya epo bilibilinomate Paeletetamo gelatepaolo negeliya, “Ao, Ya꞉suko nanakapuma꞉! A ubila a꞉ma꞉ Balabasiko gito naliba!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabasikono tanalo ma kunula. Dopamo ebete Loma gabamaniatamo gowelao tanalo eba osiyodilolo epo epetapi Yelusalemalo ebo anakapulamiya, ebema꞉ iba꞉te ebe idoko moto magumamo gito ba꞉idiliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ebe tetelo Paeleteko ubila Ya꞉suko gito kaliboma꞉, ebema꞉ ebete ebeno tabo madodo adipatelo epo bilibilinomo walo nakanaliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","wiyasiya ibi bilibilinomate kawonomamo negeliya, “Kewa olotolowamo tupuguima꞉wete, ikoko nanagilamolema꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ebene netewa-kapiya teta꞉mo Paeletete walo na꞉kegiya, “Mabu keleka꞉? Ebete beda꞉ kuba kosiyodilile? Na ebegodolo kuba idi kumita꞉ nale ebe a꞉eamo ebema꞉ alibola! Modobola nale ebe pa꞉ka꞉pa꞉ka꞉mo a꞉na꞉ma꞉ga꞉midaote gito kalibomamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wiyasiya iba꞉te olodiyoboa꞉no kawonomamo nega꞉gitiya Ya꞉suko kewa olotolowamo ka꞉tupuguima꞉, ebene ibino gelatepao tanalote kawonomoma꞉ dediya Paeletete iba꞉tamo gito tuduwatiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","iyo, iba꞉te ebe keba kunu kaniye, Paeletete eba kunu osiyodilote Ya꞉suko a꞉eamo alibo tabo ebo giya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ebene iba꞉te idoko motolo lumagi mailamo deka꞉miya, ebe dubu epo anakapulamedawa ega꞉walo gabamaniatamo gowelaodawala, Paeletete ebe ebeno kuba wiyane gito alibiya, wiyasiya ebete Ya꞉suko epatamo gito ikalamiya iba꞉te ibino ubi tanalo kosiyodiloma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Gowelaopiate Ya꞉suko a꞉e baiamo eba magatalo, Saimonoko Sailiniya duliyomolo dubula, ebete iyabaine kawo duliyomolamo ebe gabodo piti, ebene iba꞉te ebe elawamo lawete naniya, Ya꞉suko dopamo eba tutalo Saimonote ebeno kewa olotolowa kaguwataema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ebene epo bilibilinomate ebe eba waloma꞉titalo, ibino taneba magumulo kamiyale epetapiate Ya꞉sukono tanaloma꞉ iima꞉go tolamitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ya꞉sute wiyasiya iba꞉tamo olobigate negiya, “Yelusalema duliyomolo kamiyala꞉la꞉, la꞉ naimano tanaloma꞉ kiimitala꞉, la꞉ a꞉ka꞉tuwa꞉ la꞉ ega꞉walo la꞉imano gudino tanaloma꞉ niimitala꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mabu kuba tete ebe na꞉pe epate ma kunu kegelama꞉na꞉, ‘Ta꞉li kamiyale ega꞉walo lamitua꞉noma꞉ eda꞉o kamiyale ega꞉walo guda꞉tamo nono ikalamea꞉ kamiyale, iba꞉te olalati tetelo modobodopoma꞉ keda꞉oma꞉na꞉, wiyasiya guda꞉gopi kawo tepo temetemenomo kiyatawaoma꞉na꞉!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ebe tetelo epate temeteme magumulo unuunu damelatamo kegelama꞉na꞉, ‘La꞉ a unamo na꞉pa꞉guda꞉la꞉!’ ega꞉walo egege damelatamo kegelama꞉na꞉, ‘La꞉ a na꞉pitioa꞉la꞉!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ebema꞉ kamiyala꞉la꞉, la꞉ me tanalo nemalagidilala꞉. Kewate alawoa꞉noma꞉ eda꞉o tetelo kubakubapiate natamo mako kawo kuba osiyodiluta, ebema꞉ walone tetelo kewate alawoma꞉ deda꞉oma꞉na꞉, la꞉ nanisiwale! Diyala, ebe tetelo ibino tepo magumuno kubate kawonomoma꞉ eda꞉lamete la꞉tamo ega꞉walo la꞉imano guda꞉tamo iyaiya kuba kawokawonomo da꞉bosiyodilolema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ebe tetelo iba꞉te kuba osiyodilolepi dubu netewa Ya꞉suago magataliya, iba꞉te ibi kapimiya a꞉eamo kanalomoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ebema꞉ iba꞉te damela unu ida꞉mo nemaimiya, ebe damelano mailo ebe Wato Goala, ebene iba꞉te Ya꞉suko kewamo ebolo na꞉tupuguimite ikoko ebo nanagilamolemiya, ega꞉walo kubakuba tanalo osiyodilolepi dubu netewa atumu kuwatete, idi tumudi apuamo, idi pele apuamo, iyaiya kewa olotolowamo eba kunu ka꞉tupuguilamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ebene Ya꞉sute negiya, “Aba, a꞉ma꞉ ibino kuba egebolelama꞉wete na꞉dodolomatililama꞉, mabu iba꞉te beda꞉ tanalo kosiyodilute ibi iyatawa꞉.” Ebe tetelo Ya꞉suko anakapumipiate nokola egege iyalekeolo kalakala tanalo eba osiyodilolo ebeno kaliku iyaiya ebo alabaomiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ebene epate utitatate ebe eba umitalo, Yu watowatopi dubate ebe kalakalatelo negeliya, “Ebete epo epetapino olalati tanalo mula꞉lelamenaki, ebema꞉ ebete Godokono nani Kelisoma꞉ deda꞉na, modobola ebe a꞉ka꞉tuwa꞉ ebeno igilo na꞉mula꞉na!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Ega꞉walo gowelaopiate ebe atumu kalakalatelo na꞉kegelitiya, “A꞉ma꞉ Yu epono nani Kawo Elawodubuma꞉ deda꞉wena, a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉imano igilo na꞉mula꞉!” Ebene iba꞉te kaka da꞉imi obo ebetamo ebo ikamiya ebete ka꞉nima꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ega꞉walo iba꞉te Ya꞉suko da꞉tupuguimiya ebe kewa unamo tabo ma kunu akuloliya, “Me dubu ebe Yu epono Kawo Elawodubula.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ebe tetelo eba꞉go kewa olotolowamo da꞉tupuguilamiya, ibi netewapi magumulo dubu idite ebe kawonomamo malogolo ma kunu giya, “A, a꞉ma꞉ ebe Godokono Alibodawa Kelisotela꞉ka꞉? A꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉imano igilo mula꞉wete, aimano igilo atumu na꞉ka꞉mula꞉leama꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wiyasiya dubu idite ebe eba odiyobolo negiya, “Eiye! A꞉ma꞉ Godoko tolemea꞉noma꞉ keda꞉wita? A netewa-kapiyate kapiya a꞉e wiya eba lawitalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","gowelaopiate atamo kuba wiya wadenomamo ikaeamita mabu a kuba tanalo osiyodilolenaima꞉, wiyasiya Ya꞉sute kuba idi kosiyodiloa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ebene ebete Ya꞉sutamo negiya, “Ya꞉su, a꞉ma꞉ Kawo Elawodawano elawago da꞉ka꞉pa꞉emene, ebe tetelo na nilakapolo na꞉pemalagidiloniye!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ya꞉sute ebetamo nowamiya, “Na a꞉ma꞉tamo nani tabo gemo, ka꞉lo egelalo a꞉ma꞉ nago Kalakala Duliyomololo ka꞉lutama꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ebene egelate tuli teta꞉mo dutiya, egelano pukuilame tanalote olopoligote opo kawonomote ebo idokiya. Iyo, idokote egelano alo eba mula꞉lo egelate a꞉iwate kela꞉mo a꞉niwisigatepani, egela tuli tetene wagilimite 3 koloko uwomuamo, ebene Godoko Amamateno Iya Motono kaliku ubilite tulituliya ebo bolegaleni. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ebe tetelo Ya꞉sute kawonomamo gepatenate negeni, “Aba! Nale naimano uliyana a꞉imano kotamo iyatimo!” Ebete me tabo genate a꞉enomo ebo a꞉eni. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ebene gowelaopino elawodubute ebe tanalo uminate ebete Godokono mailo eba adipatenalo negeni, “Nanitabola, me dubu tuputupudawama꞉ eba eda꞉nalo kuba tanalo idi kosiyodiloa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ebene epo bilibilinomate Ya꞉sukono a꞉e tanalo uima꞉ da꞉pelamiya, kebe tanalate kemaimioniye iba꞉te ebe tanalo ulamenate kawo tola꞉go bodolo alukola꞉go ibino motamo gito tolameniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","wiyasiya Ya꞉sukono namutupi bilibilinomo ega꞉walo kebe kamiyala꞉te Ga꞉lili opone ebe dowaloma꞉iya, iba꞉te mulune putitatanate ebe iyaiya tanalo ebene pulameniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ebe tetelo dubu idi nokolinami, ebeno mailo Yausepetela, ebe Yudiya opono A꞉limitiya duliyomolodawala, ega꞉walo ebe tuputupudawala, ebete Godokono Kawo Elawodawano pe tete nemakopelenami. Ebe Yu epono Ka꞉nisolo dubu idila, wiyasiya Ka꞉nisolo dubu epetapiate Ya꞉suko anakapumi tabo degelitiya, ebete iba꞉go woki kapiyama꞉ keditia꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ebene ebe dubute Paeletekono ololo apuamo tonate Ya꞉sukono ape lawenama꞉ ebe ebo nanani. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ebene ebete Ya꞉sukono ape opamo powolukonate, wade keyakeya kalikamo auputinate nokola bobo magumamo gito niyatini, epate ebe bobo maboele nokola damela iyalo obobiya wiyasiya a꞉e lumagi idi ebamo dopamo kiyatiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","55","Ebe tetelo kebe kamiyala꞉te Ya꞉suago Ga꞉lili opone da꞉pelamiya, iba꞉te Yausepeko bobo baiamo waloma꞉tanate, ebe nokola bobo ega꞉walo Yausepete Ya꞉sukono ape keba kunu kiyatiniyale, ebe iyaiya tanalo ebo nulamelemeniya. Ebe egela Palaide egelala, Yu epono talena egelano inamabu osiyodilole tetela, mabu dumutu ebe ibino wokoa꞉ talena egelala. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ebema꞉ ebe kamiyala꞉te motamo ka꞉tolamenate wadewade nibo inamabu ebo nosiyodiloleniya egela idilo Ya꞉sukono apa꞉mo kapabutilamelema꞉, wiyasiya iba꞉te Yu epono wokoa꞉ egelalo tanalo idi kosiyodiliya꞉, mabu Godokono totomu tabote talena ma kunu iyatilamenami. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ebene kamiyala꞉te Palaide adimolo dosiyodiloleniya, iba꞉te ebe wadewade nibo inamabu Sande egela duiyanomolo bobo baiamo gito watiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Iba꞉te ebamo nemaimiote, bobo demopiniya ebe kawo nokola balamo iyalo mupiamida eba itanalo ebo numiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ebene iba꞉te nokola bobo magumamo nopila꞉ote wiyasiya Kawodawa Ya꞉sukono ape ka꞉numiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ebe tetelo iba꞉te ebe tanaloma꞉ woki bilibilima꞉ eba eda꞉utalo, dubu netewa ibino kaliku alonomola, iba꞉te pemaimite ibi niyakabolo pelamota꞉niya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ebene kamiyala꞉te kawonomamo toletoleolo ibino ololo opamo eba alomolo dubu netewate iba꞉tamo negeliya, “Keleka꞉ mabu la꞉le igilo lumagi a꞉elao epono bobo bailo da꞉powadiawitama? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ebe malo puliyala, ebe emaigaka! Ebete Ga꞉lili opolo la꞉ danaletia, la꞉ ebe tabo nemalagidilala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Iyo, ebete ma kunu giya, ‘Godote Epono Naniwi kubakubapino kotamo iyatite, iba꞉te ebe kewa olotolowamo tupuguimite ikoko kanagilamolema꞉na꞉, wiyasiya ebete netewa-kapiya egelalo a꞉ene walo ka꞉kemaigamene.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ebe tetelo ebe kamiyala꞉te Ya꞉sute iba꞉tamo dopamo kebe tabo kegiyale ebe tabo ebo malagidiliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ebene iba꞉te bobo baine duliyomolamo ka꞉tolamete iba꞉te bobo bailo da꞉nulamiya ebe iyaiya tanalo Ya꞉sukono 11 waloma꞉tapi ega꞉walo ebeno namutupi epetapi bilibilinomo ebo na꞉kiyawaolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ebe tetelo Magadala duliyomolodawa Ma꞉liko, Yowanako, Ya꞉imesikono menoko Ma꞉liko, ega꞉walo kamiyale epetapi, miba꞉tamo kebe tanalate bobo bailo kemaimiye, iba꞉te ebe tanalo Ya꞉sukono alibolepi dubatamo ebo na꞉kiyawaiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","wiyasiya iba꞉te ibino tabo dolowiya, ebe tabo daedale wokima꞉ gelate nanitabokobi ka꞉midiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ebe tetelo Pitate wiyasiya maigate bobo baiamo gito puligiya. Ebete nokola bobamo da꞉nemaigiya, nopega꞉no tuduwatalo Ya꞉sukono ape dauputiniya ebe kaliku balalo eba pola꞉nalo ebo nulamiya, wiyasiya tanalo idi ka꞉numiya꞉. Ebe mabuma꞉ ebete ebe tanalo ebeno wokilo kawonomamo malagidilago walo na꞉ka꞉piya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ebe atu egelalo Ya꞉suko waloma꞉tapi netewate Yelusalema kawo duliyomolone Emeyasi duliyomolamo tutiya, ebe gabono geyageya 10 kilomita keba kunula꞉ka꞉ eba kunula, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ebene gabo tetelo iba꞉te Ya꞉sutamo demaimiya ebe iyaiya tanalo bilibilinomoma꞉ kiyawago tutiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iba꞉te tabo gelago eba tutalo, Ya꞉sute ibino walogabo apune pete iba꞉go da꞉tuti, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ebe tetelo iba꞉te ibino balida꞉mo Ya꞉suko umiya, wiyasiya Godote ibino woki eba atutulatelelamelo iba꞉te kemalagidilutiya꞉ me Ya꞉sutela. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ebene Ya꞉sute ibi netewapi nanaliya, “La꞉ gabo tetelo eba tutalo beda꞉ tabo kegelawitama?” Ebema꞉ ibino dopote mibomiboma꞉ eda꞉olamete gito lamota꞉niya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ibi magumulo idino mailo Kolopasitela, ebete Ya꞉suko kapela dubumu midilo negiya, “Aimano Yelusalema duliyomololo dilukuliona, ebe kapela epo magumulo a꞉ma꞉ kapiya iyatawa꞉noma꞉ keda꞉wita me egela epetapilo atamo beda꞉ tanalate kemaimile?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ya꞉sute wiyasiya negiya, “Beda꞉ iyaiya tanalola꞉ka꞉?” Ebene iba꞉te nowaimiya, “Nasalete duliyomolodawa Ya꞉sutamo demaimi ebe tanalo. Ebete Godokono ololo apulo ebeno woki awokalimidawama꞉ eba eda꞉nalo tabo kiyawao magumulo ega꞉walo osiyodilole magumulo elawonomoma꞉ eda꞉nami. Me tanalo epo bilibilinomate nanitabonomolo umiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","wiyasiya Godotamo kalimagono ikameopino watowatopi ega꞉walo aimano kawokawo dubu epetapi, iba꞉te ebe gabamanino kotamo gito iyatiya, iba꞉te ebeno tanalo eba anagilamelemelo a꞉eamo kaliboma꞉, ebene iba꞉te ebe kewa olotolowamo tupuguimite ikoko ebo anagilamolemiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Dopamo a ma kunu malagidilonaima꞉, ebe Isalaela epono igilo mula꞉lelamedawala, wiyasiya ebete da꞉i ebe egelane wagilimite mamo pemaiga ka꞉lo netewa-kapiya egelama꞉ edita. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ebene aimano taneba magumulo kamiyale epetapiatamo ka꞉lo duiyanomolo da꞉pemaigaka, ebe tanalote a nanoanoiama꞉ka. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Iba꞉te bobo baiamo da꞉tolama꞉ka Ya꞉sukono ape ka꞉numa꞉ka꞉, ebema꞉ iba꞉te atamo walo ka꞉pelamete na꞉pegelaka, ‘A Godokono nopopi a꞉nulaema꞉. Iba꞉te negela Ya꞉suko a꞉ene emaigaka!’ ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ebene aimano taneba magumulo epetapiate bobo baiamo da꞉tolama꞉ka, ale kamiyala꞉godone dolowiakama꞉ ebe tanalo iba꞉te eba kunu nulama꞉ka, wiyasiya Ya꞉suko ka꞉numa꞉ka꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ebene Ya꞉sute ibi netewapiatamo negiya, “La꞉imano iyatawa lawe tanalo nanitaboa꞉, daedale gudi keba kunula꞉ka꞉ eba kunula, mabu Godokono woki awokalimipiate dopamo degelanakiya, la꞉ ibino iyaiya tabono tanalo nanitabokobi ka꞉midila꞉wena꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Me kawo tanalonomo la꞉ iyatawala꞉ka꞉? Godokono ubi tanalodo ebeno Alibodawa Kelisote dopamo kawokawo temeteme uwatete, ebene ebete ebeno Alonomo Duliyomolamo ka꞉nopegamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ebene Godokono Bukalo da꞉pola꞉na Kelisokono nanitabo tanalo awokalima꞉, Ya꞉sute ebe tanalo bilibilinomo ebo iyatulamiya, Mosesete Bukamo dakuloliya ebe tetene wagilimite Godokono woki awokalimipiate dakuloliya ebamo nemaiga. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ebene dadimoni iba꞉te ibino duliyomolamo maimioma꞉ eba tolamenalo, Ya꞉sute duliyomolo ida꞉mo ka꞉tonama꞉ degeni, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","wiyasiya iba꞉te ebe odiyobonate nananiya, “Modobola a꞉ma꞉ ago na꞉pa꞉, mabu egela na꞉niwisigana ega꞉walo samamo kidokomene.” Ebema꞉ Ya꞉sute ibino motamo tonate gito nodoloni. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iba꞉te kapimiya bae eba naonalo Ya꞉sute bae lawenate kalakala tabo Godotamo genate, ebene bae wakalaminate ibi netewapiatamo gito ikalameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ebema꞉ Godote ibino balidi paeamidalelamenate iba꞉te Ya꞉sukono tanalo ebo iyatawaniya, wiyasiya ebe tetenomolo Ya꞉sute ibino ololo apune gito alatidini. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ebene ibi netewapiate tabo ma kunu gelaniya, “Nanitabola, gabo tetelo ebete ago tabo eba kiyawaonapelo Godokono Buka apuno iyaiya tabo atamo dawokalilama꞉ka, ebe tetelo aimano tepo magumulo Godokono elate wamotitaka!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ebe tetenomolo ibi netewapiate Yelusalema kawo duliyomolamo walo na꞉kolowaminiya, ebolo Ya꞉sukono 11 waloma꞉tapi ega꞉walo piyate iba꞉go da꞉pola꞉niya, iba꞉te ibi bilibilinomo ebo nulameniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ebene Ya꞉suko waloma꞉tapiate ibi netewapiatamo negelaniya, “Nanitabola, Kawodawa Ya꞉sute a꞉ene emaigaka! Ebete Saimonotamo nanitabonomolo emaigaka!” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ebene ibi netewapiate gabo tetelo beda꞉ tanalo kumiye ega꞉walo Ya꞉sute iba꞉tamo bae eba wakalaminalo iba꞉te ebeno tanalo diyatawaniya, ebe iyaiya tanalo iba꞉te waloma꞉tapi epetapi ebo kiyawaolameniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Iba꞉te ebe tabo ma kunu eba gelanalo Ya꞉sute iba꞉tamo pawokalanate ibino tetenomolo putinate ibi nanaleni, “Godokono kalakalate la꞉godolo nitanana.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ebema꞉ iba꞉te la꞉wa꞉onate kawonomamo toletoleoniya mabu iba꞉te nemalagidiloniya Ya꞉suko ebe obolola. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ebete wiyasiya iba꞉tamo negeni, “Keleka꞉ mabu la꞉le toletoleolo woki bilibilima꞉ deda꞉wenama? Nanitabokobi midia꞉ tanalote la꞉imano tepo magumune beda꞉ma꞉ kemaigale? ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Modobola la꞉ naimano kotola agowala nulama꞉la꞉. Na Ya꞉sutela. La꞉ na na꞉pologiona꞉la꞉, na oboloa꞉, na lumagila. La꞉le na nunamenamata, na katena꞉gonola ega꞉walo goagonola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ebete ebe tabo genate ebeno kotola agowala iba꞉tamo ebo a꞉iyamidaoleni, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ebene iba꞉te kawonomamo kalakalaoniya, wiyasiya woki bilibilima꞉ eba eda꞉onalo ibino nanitabokobi midia꞉ tanalote kolopoligolameniya꞉. Ebema꞉ Ya꞉sute ibi nanaleni, “La꞉godolo inamabu idi ba꞉kitanale nale kenama꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ebene iba꞉te namo okalimi ebetamo ikamenate, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ebete lawenate ibino ololo apulo gito nani. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ebe tetelo Ya꞉sute iba꞉tamo negeni, “Nale la꞉go eba okolinalo la꞉tamo da꞉kiyawaonakimo, me ebe tanalola. Na dopamo ma kunu egimo, Godokono Bukate naimano tanaloma꞉ degena ebe tanalo bilibilinomate ka꞉pemaimioma꞉na꞉, iyo, Mosesete Totomu Tabo Bukamo dakuloliya, ega꞉walo Da꞉ibidite Sam Oale Bukamo dakuloliya, ega꞉walo Godokono woki awokalimipi epetapiate dakuloliya ebe tabono tanalo bilibilinomate nanitabonomoma꞉ keda꞉oma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ebene iba꞉te Godokono Buka apuno tanalo bilibilinomo wadenomamo kemalagidilolenama꞉ ebete ibino woki eba tuputupuilamelelamenalo ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ibi nanaleni, “Godokono Bukalo tabo ma kunu itana, ebeno Alibodawa Kelisote kawokawo temeteme uwatete ebo ka꞉emene, wiyasiya netewa-kapiya egelalo a꞉ene walo ka꞉kemaigamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ega꞉walo me Wade Tabote Yelusalema duliyomolone wagilimite me opo kawonomamo ma kunu ka꞉tomene, Godokono tabo kiyawaopiate naimano mailamo epo ka꞉nikiyawaolaema꞉na꞉, iba꞉te ibino kubane dolobila꞉oma꞉na꞉ Godote ibino kuba ebo ka꞉dodolomatililaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nanitabola, la꞉le me iyaiya tanalo wadenomamo ulamolimata, ebema꞉ la꞉ naimano tabo kiyawaopima꞉ keda꞉omamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ega꞉walo me tanalo idila. Naimano Nabiwite nanitabonomolo degiya la꞉ ebe tanalo kuimamota, nale ebeno elawo la꞉tamo kapalibomamo, ebema꞉ modobola la꞉ Yelusalema kawo duliyomololo ebe tanalo nemakopeliyala꞉, ebolo Godokono Elawote Unu Duliyomolone la꞉tamo ka꞉piwisigamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ebe tetelo Ya꞉sute ibi Yelusalema kawo duliyomolone magatalete iba꞉te Betani duliyomolo niyakabamo da꞉nemaimiya, ebete ebeno koto wadipalatelelo Godoko ebo aniya ebete ibi wadenomamo kowalubilinama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ebete ebe tabo eba gitalo, Godote ebe pelawete Unu Duliyomolamo ebo adipatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ebema꞉ iba꞉te ebolo Ya꞉suko amamatete, Yelusalema kawo duliyomolamo kawo kalakalago na꞉ka꞉tolamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ebene iba꞉te ebe duliyomololo eba ilukulinalo egela epetapi bilibilinomolo Godoko Amamateno Iya Motamo da꞉nodolonakiya, iba꞉te Godokono mailo unamo ebo adipatenakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Godote me opo osiyodiloa꞉no dopamo Tabote okolinami, ebete Godago eba okolionalo ebe ega꞉walo Godoko ibi kapiyanomola, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ebema꞉ me opo wagilimia꞉no Tabote Godago kapimiya eba kunu okolionamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ebene Godote me opono inamabu ega꞉walo tobolo ununo inamabu, iyaiya uliyana ega꞉walo epo, ebete ibi bilibilinomo Tabokono elawamo osiyodiloliya, ebema꞉ ibi bilibilinomo magumulo kapiya tanalo idite idawano elawamo kawokaliya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ebe tetelo nanitabo igilote Tabogodolo itanami, ebene me igilote aloma꞉ eda꞉te opo epo bilibilinomo ebo pukuilamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ebe mabuma꞉ me alote idoko magumulo pukuilamena, idokono elawote a꞉egamidama꞉ modoboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ebene Godokono alibodawa Yonete a꞉pemaigiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ebete epo bilibilinomatamo ebe alono tanalo eba pawokalimilo iba꞉te ebeno tabo olowite nanitabokobi ebo ka꞉midima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yonete alo me opamo kadaiya꞉, wiyasiya ebete epatamo alono tanalo kapawokalima꞉ ebema꞉ piya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yonete dapawokalimiya ebe alo ebe Godokono nanitabo alola, ebe alote me opo epo bilibilinomo pukuilamena. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nanitabola, Godote me opo Tabokono elawamo osiyodiliya, wiyasiya Tabote pete me opolo eba pokolinalo me opo epate ebeno tanalo kiyatawaiya꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","iyo, ebete ebeno oponomamo piya wiyasiya ebeno epate ebe kalakalago kelawiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wiyasiya numa꞉la꞉, kebe epate ebe nanitabonomolo delawiya ega꞉walo ebe nanitabokobi da꞉midiya, ebete iba꞉tamo elawo ikalamiya iba꞉te Godokono gudima꞉ keda꞉onama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Me guda꞉te me opo dubu idino ubi tanalamo ega꞉walo kateneno elawamo kawokalaiya꞉, wiyasiya iba꞉te Godokono elawo kapiyamo awokalaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ebene Tabote lumagino apa꞉mo pete ago eba pokolinalo ale ebeno alo kawonomo ebo umiyama꞉, ebako alo Nabiwi Godote ebeno kapiya Gudutamo ikamiya. Ebeno alono pukuilame magumulo ale me tanalo umiyama꞉, ebe Godokono nilakapo tanalo ega꞉walo nanitabo tanalo tabokanomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ebene Yonete ebeno tabo madodo unamo adipatelo Godokono Guduno tanalo ma kunu awokalimiya, “Nale dopamo kebe dawano tanaloma꞉ ka꞉kiyawaimo, me ebe lumagila. Nale ebeno tanaloma꞉ ma kunu gimo, ebete naimano walogabo apune ba꞉pena, ega꞉walo Godote ebetamo dikamiya ebe elawo kawonomote naimano elawo nodoliona, mabu nale me opamo awokala꞉no ebete dopamo okolinami.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ebe nilakapo tabokanomola, ebema꞉ ebeno nilakapo tanalodo ebete a bilibilinomatamo ebeno wadewade tanalo walo ikaeamenaki, walo ikaeamenaki, ebete eba kunu wagelenami. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nanitabola, Godote ebeno Totomu Tabo epatamo Mosesedo ikalamiya, wiyasiya ebete ebeno nilakapo tanalo ega꞉walo nanitabo tanalo Ya꞉su Kelisogodone awokalilamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Lumagi idite Godokono ololo dopamo kuminakia꞉, wiyasiya Godokono Gudu kapiyate ebeno Nabiwino tanalo epatamo apawokalimiya, mabu Nabiwila Gudula ibi kapiyanomola ega꞉walo Gudute Nabiwino ololo apulo okolina. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ebe tetelo Yelusalema kawo duliyomololo dilukulionamiya, ebe Yu watowatopiate Godotamo kalimagono ikameopi dubu ega꞉walo Libai gu dubu epetapi Yonetamo ebo naliboliya ebeno nanitabo tanalo ka꞉nuima꞉. Ebene iba꞉te Yonetamo pelamete ebe napalatediya, “A꞉ma꞉ potelela꞉ka꞉? A꞉imano nanitabo tanalo atamo nawokalima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yonete ibino tabo wiyama꞉ ubia꞉noma꞉ kediya꞉, wiyasiya ebete kalakalago ibi awokala nanaliya, “Na Godokono Alibodawa Kelisotea꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ebema꞉ iba꞉te ebe walo nakalatediya, “A꞉ma꞉ potelela꞉ka꞉? A꞉ma꞉ Godokono woki awokalimidawa Elayatela꞉ka꞉, a me opo epatamo walo da꞉ka꞉pemaigi?” Yonete ibino tabo eba wiyalo negiya, “Ao, na ebetea꞉.” Ebema꞉ iba꞉te ebe walo nakalatediya, “Mosesete lumagi idino pe tanaloma꞉ da꞉kiyawaiya, a꞉ma꞉ ebe Godokono Woki Awokalimidawa idila꞉ka꞉?” Yonete nowamiya, “Ao, na ebetea꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ebene iba꞉te ebetamo walo na꞉kegeliya, “A piyate kapaliboe, ale iba꞉tamo wiya tabo katama꞉, modobola a꞉imano tanalo nawokalima꞉, a꞉ma꞉ potelela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yonete ibino tabo eba wiyalo negiya, “Godokono woki awokalimidawa Aisayate naimano tanalo awokalima꞉ tabo ma kunu giya, ‘Lumagite bulu opolo tabo ma kunu kawonomamo ka꞉pegemene, ‘Kawodawano gabo na꞉tupugaima꞉la꞉.’ ’” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ebe tetelo kebe Yu watowatopiate ebe dubu Yonetamo dapaliboliya, ibi Pa꞉lisi tanebapila, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ebema꞉ ebe dubate ebe walo na꞉kegelamiya, “A꞉ma꞉le egeata a꞉ma꞉ Kelisotea꞉, ega꞉walo a꞉ma꞉ Elayatea꞉, ega꞉walo Mosesete Godokono wokodawano pe tanaloma꞉ da꞉kiyawaiya a꞉ma꞉ ebetea꞉. Ebema꞉ mabu keleka꞉ a꞉ma꞉le epo obamo dowaduba꞉midaola꞉wenaka?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yonete ibino tabo eba wiyalo negiya, “Nanitabola, nale epo obamo owaduba꞉midaolenakomo, wiyasiya la꞉ magumulo dokolina ebe lumagi idino tanalo la꞉ nanitabolo iyatawa꞉, ebe aimano Kawodawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ebete naimano walogabo apune ba꞉pena, wiyasiya na wadenoa꞉ nale ebeno agowa ukulaolema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yonete Yodane Kolomo apulo epo obamo dowaduba꞉midaolenaki, ebete ebe opono Betani duliyomololo eba okolinalo me tanalote ebetamo ebo pemaigiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ebene egela idilo Ya꞉sute ebetamo eba pitalo, Yonete ebe umite epetapiatamo negiya, “Numa꞉la꞉, ebe Godokono Sipi-goeo Da꞉pesote pita, ebete opo epono kuba osiyodilole wiya uwatelamete ebeno kalimamo kegebolelaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nale dopamo la꞉tamo kebe dawano tanaloma꞉ ka꞉kiyawaimo, me ebe lumagila. Nale ebeno tanaloma꞉ ma kunu gimo, dubu idite naimano walogabo apune ba꞉pena, wiyasiya ebeno elawo kawonomola, ebete naimano elawo nodoliona mabu nale me opamo awokala꞉no ebete dopamo okolinami. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Iyo, nale ebe umia꞉no dopamo ebeno nanitabo tanalo na iyatawa꞉, wiyasiya ebeno tanalo nale Isalaela epatamo awokalima꞉ piyamo, ega꞉walo nale epo obamo ebema꞉ waduba꞉midaolenakomo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ebene Yonete Ya꞉sukono tanalo awokalimilo negiya, “Nale ebeno tanalo ma kunu uimo, Godokono Uliyanate Unu Duliyomolone ebetamo bigo olamu piwisigitalo uimo, ebete ebegodolo ka꞉pokolinama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nale ebe tanalo umia꞉no dopamo Ya꞉sukono nanitabo tanalo iyatawa꞉, wiyasiya na epo obamo waduba꞉midaolema꞉ dapaliboniya ebe Kawodawate natamo negi, ‘Naimano Uliyanate pogodolo ka꞉pokolinama꞉ ebetamo da꞉piwisigamene, a꞉ma꞉le ebe lumagi uma꞉wete kiyatawama꞉ta, ebe naimano Uliyanamo epo waduba꞉midaoledawala.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nanitabola, ebe tanalo naimano balida꞉mo uimo, nale ebeno tanalo ebema꞉ awokalimo, ebe Godokono Gudula.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Egela idilo Yonete ebe waloma꞉tapi netewago dutiti, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ebe tetelo Ya꞉sute ibi niyakabodo eba petonatolo, Yonete ebe umite negiya, “Numa꞉la꞉, me Godokono Sipi-goeo Da꞉pesola, ebete epono kuba osiyodilole wiya kuwatelaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yoneko waloma꞉tapi netewate ebe tabo dolowiya iba꞉te ebe atepate Ya꞉suko ebo waloma꞉tiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ebene Ya꞉sute olobigate ibi ulamelo nanaliya, “La꞉imano ubi beda꞉la꞉ka꞉?” Iba꞉te ebeno tabo eba wiyalo ebe naniya, “Iyatulamedawa, ale a꞉ma꞉ La꞉baima꞉ ka꞉miata, ebema꞉ a꞉ma꞉ kebolo kokoliawena, a ubila ebe bai uima꞉.” Buka ka꞉la꞉mioledawa, modobola a꞉ma꞉ me tanalo niyatawa, Yu epate ibino tabamo wade iyatulamedawa idi La꞉baima꞉ ka꞉minaka. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ebene Ya꞉sute iba꞉tamo nowamiya, “Kuba꞉nola, la꞉ pa꞉wete na꞉puma꞉la꞉.” Ebene egelate kela꞉mo da꞉niwisigatepani, 4 koloko keba kunula꞉ka꞉ ebako tetelo ebe dubu netewate Ya꞉suago tonate, ebeno okoli bai numinate kapiya idoko eba꞉go ebo nelaniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ebe dubu netewapi magumulo idino mailo A꞉ndulutela, ebe Saimono Pitakono ekawila. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ebene duiyanomolo A꞉ndulute tote ebeno naniwi Saimonoko da꞉numiya ebe nananiya, “A Mesayako nanitabonomolo uima꞉!” Buka ka꞉la꞉mioledawa, modobola a꞉ma꞉ me tanalo niyatawa, Yu epate Godokono Alibodawa Kelisoko ibino tabamo Mesayama꞉ ka꞉minaka. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ebene A꞉ndulute ebeno naniwi Ya꞉sutamo demagatiya, Ya꞉sute ebe umite ebetamo negiya, “A꞉imano mailo ebe Saimonotela, a꞉ma꞉ Yonekono gudulata, wiyasiya epate a꞉ma꞉ oli mailo Kipasema꞉ keka꞉ima꞉ta.” Kipase mailono magumu nitana ‘Nokolala,’ ega꞉walo Guliki opo epono tabamo iba꞉te ebe mailo Pitama꞉ ka꞉minaka. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ebene egela idilo Ya꞉sute Ga꞉lili opamo ka꞉toma꞉ ubi diyatiya, ebe tetelo ebete Pilipiko umite ebe naniya, “Modobola a꞉ma꞉ na nowaloma꞉ena꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ebe dubu Pilipiko ebe Betasaida duliyomolodawala, ega꞉walo A꞉nduluko Saimonago iba꞉te ebe atu duliyomololo okolionamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ebene Pilipite Nata꞉niyoloko numite ebe nananiya, “Mosesete Godokono Totomu Bukalo pokono tanalo kawokalimiyale, ale ebe Kawodawa nanitabonomolo uima꞉. Iyo, Godokono woki awokalimipi epetapiate ebeno Bukalo atu lumagino tanaloma꞉ tabo walo dakawokalimiya, me ebe lumagila. Ebe Ya꞉sute Nasalete duliyomolodawala, Yausepekono gudula.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nata꞉niyolote wiyasiya negiya, “Nasalete duliyomolo wade duliyomoloa꞉, ebema꞉ ebe duliyomolone beda꞉ wade tanalote na꞉ka꞉pemaigamene?” Pilipite ebe naniya, “Modobola a꞉ma꞉ pa꞉wete ebeno tanalo na꞉puma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ebene Nata꞉niyolote ebetamo da꞉pemaigiya, Ya꞉sute ebe umite ebeno tanaloma꞉ negiya, “Me Isalaela opo dubu ebe nani tabo lumagila. Ebeno tepo magumulo a꞉da꞉ tanalo idi kitana꞉, puliyanomola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nata꞉niyolote ebe nalatediya, “Mabu keleka꞉ a꞉ma꞉ naimano tepo magumuno tanalo diyatawawita?” Ebene Ya꞉sute nowamiya, “Pilipite a꞉ma꞉ mamo pema꞉ ana꞉no ega꞉walo nale a꞉ma꞉go alugoa꞉no, a꞉ma꞉le da꞉imi kewano gololo magumulo dokoliawitaka, nale a꞉ma꞉ Godokono Uliyanano elawamo iyalo uma꞉kamata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ebe tetelo Nata꞉niyolote ebetamo negiya, “Iyatulamedawa, nanitabola a꞉ma꞉ ebe Godokono Gudulata! A꞉ma꞉ Isalaela epono Kawo Elawodubulata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ebene Ya꞉sute ebetamo negiya, “Nale a꞉ma꞉ da꞉imi kewano golololo dumitakama, ebe mabuma꞉ a꞉ma꞉le na nanitabokobi ka꞉midina꞉wita? Nanitabola, me tanalo kawo tanaloa꞉, wiyasiya a꞉ma꞉ walone nagodolo kawokawo anoano tanalonomo kulamolema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na a꞉ma꞉tamo nani tabonomo gemo, Godote ebeno Unu Duliyomolo a꞉iyamiditalo a꞉ma꞉ kuima꞉ta, iyo, Epono Naniwite waola gaboma꞉ eda꞉te, Godokono nopopiate ebe waola gabodo Unu Duliyomolamo ka꞉nodolo, ka꞉piwitio, eba kunu eba wagelelo, a꞉ma꞉le ibi ebo kulaema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Egela netewa epetapi da꞉petoiya, ebe tetelo Ga꞉lili opono Ka꞉ina duliyomololo dubu idite oli kamiyale lawe soliyomu osiyodiluti. Ebe soliyomu magumulo Ya꞉sukono menoko na꞉luti, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ega꞉walo Ya꞉sute ebe waloma꞉tapiago atumu ebolo na꞉ka꞉pola꞉niya mabu soliyomu namutudawate ibi analiya iba꞉te epo epetapiago soliyomu bae ka꞉penaoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ebene soliyomu osiyodilo magumulo wade da꞉imi obote dolopoligiya, ebe tetelo Ya꞉sukono menokote ebe naniya, “Epate wade da꞉imi obo da꞉nia samonomamo opoliya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ebene Ya꞉sute ebeno menokotamo negiya, “Maea, nale kebe tanalo osiyodiloma꞉ a꞉ma꞉le na akopanana꞉la꞉, mabu naimano elawo awokalimi tete nanitabolo ka꞉pea꞉, ebe tetete pemaigama꞉ Godote a꞉ka꞉tuwa꞉ na kananemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ebe tetelo ebeno menokote olobigate soliyomu namutudawano moto wokopiatamo negiya, “Ebete kebe tanalo osiyodiloma꞉ la꞉ danaletamene, modobola la꞉ ebe tanalo gito nosiyodiliyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ebe tetelo ebe motolo sikisi kawokawo obo upate na꞉pola꞉niya, me upa epate nokolamo osiyodiloliya ega꞉walo ibi magumulo epetapi 80 litala ega꞉walo epetapi 120 litala. Me upano tanalo ma kunu itani, nio oboa꞉ wiyasiya Yu epono osiyodilole magumulo iba꞉te Godokono totomu tabo ida꞉mo ka꞉tudila꞉oma꞉ ibino kotono daleya makomako upano obamo ukulaolenakiya, ibino ewoniate ibi diyatulamiya eba kunu. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ebema꞉ Ya꞉sute moto wokopi nanaliya, “La꞉ me upa obonomamo netabokailama꞉la꞉,” ebene iba꞉te nanitabonomolo detabokailamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ya꞉sute ibi ebo analiya iba꞉te kalila꞉mo iyapote soliyomu namutudawatamo ka꞉nikaema꞉. Ebene iba꞉te tolamete soliyomu namutudawatamo da꞉nikamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ebe tetelo ebete nite ebeno wokilo gola da꞉imi obonomoma꞉ giya. Ebe obote wade da꞉imi obonomoma꞉ keba kunu kediyale moto umi wokopiate iyatawaiya, wiyasiya soliyomu namutudawate ebe tanalo iyatawa꞉no, ebete oli kamiyale daiditi ebe dubu ebetamo ka꞉mite ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ebe naniya, “Numa꞉, aimano osiyodilo tanalo ma kunula, soliyomu osiyodilo tetelo ale epatamo wade golanomo da꞉imi obo dopamo ikalamenakoma꞉, iyo, iba꞉te ebe wade gola obo dopoliyama꞉na꞉, ebene walone ale gola꞉dopo obo iba꞉tamo ebo kikalaemalema꞉. Wiyasiya a꞉ma꞉ eba kunu kosiyodilawea꞉, a꞉ma꞉ soliyomu olopoligo tetelo me gola da꞉imi obonomo epatamo ikalamitata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ebema꞉ Ga꞉lili opono Ka꞉ina duliyomololo Godokono elawo awokalima꞉ Ya꞉sute me ebeno dopo anoano tanalo osiyodiliya. Ebe tetelo ebeno waloma꞉tapiate ebeno kawo elawonomo dumiya, iba꞉te ebe nanitabokobi ebo midiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ebene me tanalo dolopoligiya Ya꞉suko ega꞉walo ebeno waloma꞉tapi, iba꞉te ebeno menokago ega꞉walo ekakiago Kapeniyama duliyomolamo tolamete tete da꞉pesamo ebo nilukuliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mabu Yu epono Aduga꞉la Soliyomu osiyodilo tete detatalinapiya, ebema꞉ Ya꞉sute Yelusalema kawo duliyomolamo gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ebene ebete Godoko Amamateno Iya Motamo tote, ebe motolo epate kau-goeogoeo ega꞉walo sipi-goeogoeo ega꞉walo bigo olaola maniamo eba midiolitalo ebo nulamiya, ega꞉walo ebe atu tetelo epate patapatalo ilukulite epetapino mani dodowaolitiya ebete ibi ebo ka꞉nulamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Me mabuma꞉ Ya꞉sute ale uwatete pa꞉ka꞉pa꞉ka꞉ osiyodilote ebete ebe goeogoeo Godoko Amamateno Motono kala magumune elawonomamo ebo a꞉na꞉ma꞉lateliya, ega꞉walo ebete mani odowaolepino patapata oba꞉midaolelamete epono mani eba pa꞉na꞉gudilamelo iyaiya ebo petoiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ebene ebete bigo olaola olowamepi kawiya eba analelo negiya, “Me inamabu me motone nowagaila꞉la꞉. Naimano Nabiwino Moto talenala, ebema꞉ la꞉le olowame baima꞉ akomida꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ya꞉sute me tanalo dosiyodiliya ebeno waloma꞉tapiate Godokono Bukano tabo idi ebo malagidiliya, ebe tabote ma kunu itana, “A꞉imano Talena Moto mabuma꞉ naimano tepo magumuno elawote elanomoma꞉ eda꞉na.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ebe tetelo Yu watowatopi epetapiate Ya꞉suko naniya, “A꞉ma꞉ Godokono elawo awokalima꞉ aimano ololo apulo anoano tanalo nosiyodila, ebema꞉ a kiyatawaomalema꞉ a꞉ma꞉le Godokono Motolo dosiyodilawa꞉ ebe tanalo a꞉imano elawamo kosiyodilawea꞉, wiyasiya Godokono elawamo osiyodilata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ya꞉sute ibino tabo eba wiyalo negiya, “Kuba꞉nola, la꞉le me Godoko Amamateno Moto danabulima꞉ema, wiyasiya nale netewa-kapiya egelalo walo ka꞉ketemamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yu watowatopiate ebetamo negeliya, “A꞉ma꞉ na꞉kemalagidilawita, a꞉imano elawo modobola me moto kawonomo netewa-kapiya egelalo keta꞉ema꞉? Eiye! Me moto aimano nabiate 46 ulamamo etenamiya!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wiyasiya Ya꞉sute kebe tabo kegiyale ebe ebeno apeno tanaloma꞉ giya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ebema꞉ walone tetelo ebete a꞉e magumune da꞉kemaigiya, ebeno waloma꞉tapiate me tabono magumu ebo malagidiliya, ebene Godote ebeno tanaloma꞉ ebeno Bukalo kebe tanalo iyalo kawokalimiyale, iba꞉te ebe tanalo wadenomamo lawete nanitabokobi eba midilo Ya꞉sukono tabo atumu nanitabokobi ebo ka꞉midiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ebene Aduga꞉la Soliyomu tetelo Ya꞉sute Godokono elawo awokalima꞉ kebe kawokawo anoano tanalo Yelusalema duliyomololo kosiyodiloliyale, epo epetapi bilibilinomate ebe tanalo ulamete ebe nanitabokobi ebo midiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wiyasiya ibi magumulo Ya꞉sute ebeno nanitabo tanalo kapiya lumagi iditamo kawokalimiya꞉, mabu ebe iyatawanomola epo bilibilinomono tepo magumulo kuba elemasigi tanalate ba꞉pola꞉lamena. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ega꞉walo ebete lumagi idi kananakia꞉ ebete ebeno tepo magumuno tanalo nanitabonomolo kawokalima꞉, mabu ebete epo bilibilinomono tepo magumuno tanalo iyalo iyatawiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ebe tetelo Yu epono watodawa idi nokolinami, ebeno mailo Nikadimasitela, ebe Pa꞉lisi tanebadawa idila. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Idoko idilo ebete Ya꞉sutamo penate na꞉pegeni, “Iyatulamedawa, a epetapi iyatawala a꞉ma꞉ Godote palibiyata a ka꞉piyatuama꞉ema꞉, mabu Godote kebe lumagigodolo okolina꞉no, ebete a꞉ma꞉le dosiyodilola꞉wenaka ebako anoano tanalo osiyodilolema꞉ a꞉ka꞉modobomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ya꞉sute ebeno tabo eba wiyanalo negeni, “Na a꞉ma꞉tamo nani tabonomo gemo, lumagite olinoma꞉ eda꞉lo ebe oli igilamo walo awokala꞉no, Godote Kawo Elawodawama꞉ deda꞉na ebete ebe tanalono magumu a꞉kuimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ebema꞉ Nikadimasite Ya꞉suko nalateda꞉ni, “Lumagite kadelema꞉ deda꞉na, ebe tetelo ebete olinoma꞉ walo keba kunu na꞉keda꞉mene? Gaboa꞉nola, mabu ebete ebeno menokono tepo magumamo opegate menokote ebe walo alaima꞉ modoboa꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ya꞉sute ebetamo nowamini, “Nale a꞉ma꞉tamo nani tabo gemo, lumagite obamo ega꞉walo Godokono Uliyanano elawamo olinoma꞉ eda꞉no, Godote Kawo Elawodawama꞉ deda꞉na ebete ebe duliyomolamo a꞉ka꞉nopegamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Me opolo lumagite dawokaliya ebe tetelo ebeno igilote menokola nabiwila iba꞉godone pawokaliya, wiyasiya ebeno uliyanano nanitabo igilote Godokono Uliyanagodone ka꞉pemene, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ebema꞉ epate olinoma꞉ eda꞉ote walo awokalaoma꞉ degemo, ebe tanaloma꞉ a꞉ma꞉ akola꞉wa꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lumagite Godokono Uliyanano elawamo olinoma꞉ eda꞉lo ebe oli igilago walo dakawokalamene ebe tanalo ma kunula. Me opolo awate a꞉ka꞉tuwa꞉ ebeno ubilo iyaiya apune dapaloguta, a꞉ma꞉le ebeno diyamo kapiya olowitata wiyasiya awate kebene wagilimite ka꞉pitale ega꞉walo keba apulo ka꞉nolopoligutale a꞉ma꞉ iyatawa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikadimasite wiyasiya Ya꞉sutamo negeni, “A꞉imano tabono magumu na wadenomamo kelawea꞉. Me tanalo keba kunula꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ebene Ya꞉sute ebeno tabo eba wiyanalo negeni, “A꞉ma꞉ Isalaela epono iyatulamedawa idilata, wiyasiya mabu keleka꞉ a꞉ma꞉ me tanalono magumu kiyatawawena꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na a꞉ma꞉tamo nani tabonomo gemo, naimano tanebapiago ale diyatawaonama꞉ ebe iyaiya tanalo gelanakoma꞉, ega꞉walo ale iyalo dulamoliyama꞉ ebe iyaiya tanalo kiyawaonakoma꞉, wiyasiya la꞉ Yu epo epetapiate aimano tabo kolowiawenakoa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iyo, nale me tetelo la꞉ me opono tanalo da꞉kiyawaolametanakoma, la꞉ wiyasiya nanitabokobi ka꞉midila꞉wena꞉, ebema꞉ nale Godokono Unu Duliyomolono tanalo la꞉ walo da꞉ka꞉kiyawaolametama, diyala, la꞉ atumu nanitabokobi a꞉ka꞉midila꞉ema. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nanitabola, me opo epo magumulo lumagi idite Godokono Unu Duliyomolamo ka꞉nodoliya꞉, wiyasiya Epono Naniwite Unu Duliyomolone me opamo a꞉piwisigiya, ebema꞉ ebe kapiyate iyatawala Unu Duliyomolono tanalo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ega꞉walo me tanalo idila, Mosesete bulu opolo kalu idi auli inamabuamo osiyodilote gaubamo keba kunu kadipatiyale, modobola a꞉ma꞉ ebe tanalo nemalagidila. Ebe tetelo bu kaluate Isalaela epo magumulo kebe epo daloliya, iba꞉te Mosesekono auli kalutamo da꞉meleiya, Godote ibino igilo ebo mula꞉lelamiya. Ebema꞉ nanitabola, me tetelo Godote atu gabodo Epono Naniwi unamo kadipatemene, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ebene piyate ebe nanitabokobi da꞉midima꞉na꞉ iba꞉te uwomua꞉ igilo ebo kelaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mabu Godote me opo epo nilakapolo kawonomamo eba malagidilolelo ebeno Gudu kapiyanomo me opamo ebo palibiya, ebema꞉ piyate ebe nanitabokobi da꞉midima꞉na꞉ ibino igilate akalatidioma꞉na꞉ wiyasiya iba꞉te uwomua꞉ igilo kelaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","“Nanitabola, Godote ebeno Gudu dapalibiya, ebe tetelo ebe ubi kiyatiya꞉ ebeno Gudute epono tanalo anagilamelelamete kuba wiya kikalaema꞉, ao, wiyasiya ebe ubila ebete ibino igilo ka꞉pa꞉mula꞉lelaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ebema꞉ piyate Godokono Gudu nanitabokobi da꞉midina Godote iba꞉tamo kuba wiya a꞉kikalaemene, wiyasiya piyate ebe nanitabokobi midia꞉no Godote ebeno woki iyalo iyatiya iba꞉tamo kuba wiya kikalaema꞉, mabu iba꞉te nanitabokobi midi magumulo ebeno Gudu kapiyanomo kelawea꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","Numa꞉, Godokono alote me opamo da꞉piya iba꞉te ubia꞉noma꞉ eda꞉iya, wiyasiya ibi ubila idoko magumulo kilukulionama꞉ mabu ibino osiyodilole tanalo kubakubanomola. Iyo, kuba osiyodilolepiate wade alo ubia꞉noma꞉ eba eda꞉olo alo magumamo ka꞉pelamenakoa꞉, mabu ibi ubia꞉nola alote ibino kuba pukuilamelelaema꞉, ebema꞉ nanitabola, ibino kuba anagiyamida tanalote iba꞉tamo ka꞉pemaigamene, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wiyasiya piyate Godokono nanitabo gabodo da꞉tolamena iba꞉te alo magumamo ka꞉pelaema꞉na꞉, ebene iba꞉te wadewade tanalo Godokono elawamo eba osiyodilolelo alote ibino nanitabo tanalo ebo kawokalilaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ebe tanalo dolopoligiya Ya꞉sute ebe waloma꞉tapiago Yudiya opamo tolamete, iba꞉te ebolo tete geyageyadopolo eba nilukulilo epo epetapiate obamo aduba꞉mida tanalo laema꞉ da꞉pelamenakiya Ya꞉sute ibi ebo walubilinaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ega꞉walo atu tetelo epo epetapiate Yonetamo da꞉pelamenakiya, ebete ibi Inono duliyomolo niyakabolo atumu kowaduba꞉midaolenaki mabu ebolo obo kawodopola, ebe Inono duliyomolote Salimi duliyomolo tatalilo itana. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ebe tetelo gabamaniate Yoneko idoko moto guamo iyatia꞉nola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ebene egela idilo Yoneko waloma꞉tapiate Yu opono dubu ida꞉go epono apeno daleya ukulaole tanaloma꞉ apaminateuitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ebema꞉ epetapi iba꞉te ebe tabo gela magumune Yonetamo pelamete ebe napaniya, “Iyatulamedawa, dopamo Yodane Kolomo apulo a꞉ma꞉tamo da꞉pemaigi ebe dubuno tanalo a꞉ma꞉le atamo dawokalima꞉wia, ebete walo ka꞉pete epo obamo ba꞉powaduba꞉midaolenate, ega꞉walo epo bilibilinomate a miyapaete ebetamo na꞉tolama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yonete ibino tabo eba wiyalo negiya, “Lumagite wade tanalo a꞉ka꞉tuwa꞉ a꞉kelaemene, Godote ebetamo ikamea꞉no ebete gito ka꞉lutamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nale la꞉tamo degimo, la꞉ ebe tabo nanitabonomolo olowimata. Iyo, na ma kunu gimo, ‘Na Godokono Alibodawa Kelisotea꞉, wiyasiya Godote na napaliboniya Kelisoko dopomete ka꞉toma꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Dubu idite oli kamiyale delaemene, ebete soliyomu osiyodilote ebe kamiyalete nanitabonomolo ebenoma꞉ keda꞉mene. Ebe tetelo ebe dubuno wade namutudawate tete da꞉pesamo ebe niyakabamo nutite, ebeno namutudawano tabo madodo olowite ebeno kawo kalakala duimene, ebete atumu kekalakalamene. Nanitabola, na eba kunula, Kelisoko mabuma꞉ naimano tepo magumulo kalakala kawonomote etaboki, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ebema꞉ modobola ebete kawoma꞉ neda꞉mene, na wiyasiya da꞉pesoma꞉ keda꞉mamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Godokono Unu Duliyomolone da꞉piwisigiya ebe Kawodawate opo epo bilibilinomo nodoilina. Kebe lumagite me opolo dokolina, ebe me opono tanaloma꞉ kiyawaonako mabu ebe opo lumagila, wiyasiya Unu Duliyomolone da꞉piya ebe dawa eba kunua꞉. Ebete me opolo a꞉ka꞉tuwa꞉ Kawodawanomoma꞉ eba peda꞉nalo, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Unu Duliyomololo kebe tanalo kulamiyale ega꞉walo kebe tanalo kolowiyale, ebete ebe iyaiya tanalo opo epatamo napawokalilamena, wiyasiya ibi magumulo epetapi bilibilinomate ebeno tabo kelawena꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ebe mabuma꞉ kebe lumagite ebeno tabo nanitabonomolo delaemene, ebete ebe tanalodo me tanalo idi kawokalimene, Godoko kapiya ebe nanitabo tanalo awokalimidawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nanitabola, Godote dapalibiya ebe Kawodawate Godokono nani tabo kiyawaonako, mabu Godote ebeno Uliyanano elawo kawonomo ebetamo iyalo ikamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","iyo, Nabiwi Godote ebeno Gudu nilakapolo nemalagidilona, ebema꞉ ebete ebetamo elawo ikamiya ebete tanalo bilibilinomo osiyodilolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ebe mabuma꞉ kebe lumagite Godokono Gudu nanitabokobi da꞉midina, Godokono uwomua꞉ igilote ebegodolo bitana, ebete iyalo elawi, wiyasiya kebe lumagite Godokono Gudutamo tuduwata꞉no, Godokono kawo dowa tanalonomote ebetamo bitana ebema꞉ ebete nanitabo igilo a꞉kelawenamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ebene Pa꞉lisi tanebapiate Ya꞉sukono tanalo ma kunu olowiya, ebete epo bilibilinomo ebeno waloma꞉tapima꞉ midilite ibi obamo ebo waduba꞉midaolenaki, wiyasiya Yonete bilibili epo kowaduba꞉midaolenakia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ebe teteno nanitabo tanalote wiyasiya ma kunu itani, ebe epo magumulo Ya꞉sute lumagi idi obamo kaduba꞉midanakia꞉, ebeno waloma꞉tapiate a꞉ka꞉tuwa꞉ waduba꞉midaolenakiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ebene Ya꞉sute Pa꞉lisi tanebapino tabo gela tanalo diyatawiya, ebe tetelo ebete Yudiya opo atepate Ga꞉lili opamo olowaima꞉ malagidiliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ebene ebamo ka꞉nemaigama꞉ ebete duiyanomolo wagilimite Godokono ubilo Samaliya opodo tote ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ebe opono Saika duliyomolamo gito nemaigiya. Ewonino tetelo Ya꞉ikobote ebeno gudu Yausepetamo dikamiya me Saika duliyomolo ebe damela niyakabolo itana, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ega꞉walo Ya꞉ikobote dobobiya ebe obo gulite ebolo atumu ba꞉kitana. Ebene egela tuli tetenomolo Ya꞉sute tete geyageyadopo pete ebe obo guli niyakabolo pokolite ela ebe pamiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ebene Ya꞉suko waloma꞉tapiate bae maniamo uwateoma꞉ duliyomolamo da꞉tolamiya, ebe a꞉ka꞉tuwa꞉ obo gulilo eba okolitalo Samaliya opo kamiyale idite obo iyapoma꞉ duliyomolone ebo piya, ebene Ya꞉sute ebe naniya, “Na obo kapete unamita. Niyata, na obo nikanama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ebene kamiyalete Ya꞉sukono tabo eba wiyalo negiya, “Eiye, a꞉ma꞉ Yu opono dubulata ega꞉walo na Samaliya opono kamiyalela! A꞉ma꞉ na oboma꞉ beda꞉ma꞉ kanana꞉wa꞉?” Ebete ma kunu degiya mabu Yu epate Samaliya opo epo daleyagopima꞉ gelalo atu kalila꞉mo obo nioma꞉ talenama꞉ gelanaka. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ebene Ya꞉sute negiya, “Godote epatamo gito dikalamena ega꞉walo potele a꞉ma꞉ oboma꞉ da꞉towemeta, a꞉ma꞉le ebe netewa tanalo nanitabolo niyatawawetaleka꞉, a꞉ma꞉le na banana꞉wena꞉ nale a꞉ma꞉tamo igilo obo kikametama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kamiyalete ebetamo negiya, “Kawodawa, a꞉ma꞉ ebe igilo obo kebene na꞉kelawa꞉emene? A꞉ma꞉godolo obo iyapono inamabu puliyala, ega꞉walo numa꞉, me obo guli ebe kulukulunomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","A꞉ma꞉ aimano ewono Ya꞉ikoboko da꞉pesodawama꞉ gelo a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉ma꞉ kawoma꞉ ka꞉mida꞉wita? Me obo guli ebete a ebeno walone gudi mabuma꞉ obobiya, ebene ebe ega꞉walo ebeno gudi, ega꞉walo ebeno sipi-goeogoeo ega꞉walo kau-goeogoeo, ibi bilibilinomate me obo nionamiya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ya꞉sute wiyasiya ebetamo negiya, “Kebe lumagite me obo da꞉nimene ebe obo kapete walo ka꞉kuimene, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","wiyasiya nale kebe obo lumagitamo nima꞉ dikaemo ebe obo kapete walo a꞉kuminakomene. Ebe igilo obote lumagino okoli magumune tete bilibilinomolo ba꞉peka꞉ka꞉liyanamene, ma kunu ebete uwomua꞉ igilo nanitabonomolo kelaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ebene kamiyalete ebetamo negiya, “Kawodawa, niyata, a꞉ma꞉ ebe obo natamo nikanama꞉. Nale da꞉nimo, na walo obo kapete a꞉kunamenakomene ega꞉walo nale me obo iyapoma꞉ walo a꞉ka꞉penakomo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ya꞉sute ebe naniya, “A꞉ma꞉ duliyomolamo toawete, a꞉imano awi nadabua꞉wete mamo kapimiya na꞉piyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ebene kamiyalete nowamiya, “Na awia꞉nola.” Ya꞉sute ebetamo negiya, “A꞉ma꞉ awia꞉noma꞉ nanitabolo geata, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","mabu a꞉ma꞉ dopamo paibu iyaiya dubate aida꞉tepaiata, ega꞉walo ka꞉lo a꞉ma꞉go dokolina ebe dubu a꞉imano awinomoa꞉. Iyo, a꞉ma꞉ awia꞉noma꞉ nanitabolo geata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ebema꞉ kamiyalete ebetamo negiya, “Kawodawa, na niyatawitamo, nanitabola, a꞉ma꞉ Godokono woki awokalimidawa idilata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","A Samaliya epono ewoniate Godoko me damela ununomolo amamatenakiya ebema꞉ ale talenama꞉ gelanama꞉, wiyasiya la꞉ Yu epate negelanakomata epate Yelusalemalo Godoko namamatenama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ya꞉sute ebetamo negiya, “Kamiyale, nale degitamo, a꞉ma꞉ me tabo nanitabokobi na꞉mida꞉. Tete na꞉pe, piyate Nabiwi Godoko damamatena iba꞉te walo Yelusalemalo akamamatenama꞉na꞉ ega꞉walo me damela ununomolo akamamatenama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","La꞉ Samaliya opo epate Godoko amamate gabo nanitabonomolo iyatawa꞉, wiyasiya a Yu epate me tanalo iyatawala mabu Godokono igilo mula꞉ tanalote agodone opo kawonomamo pena. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nanitabola, tete ka꞉pemene, iyo, ebe na꞉pe, piyate Nabiwi Godoko nanitabonomolo damamatena iba꞉te oli woki uwatete ebeno Uliyanano elawamo ega꞉walo ebeno nanitabo tanalodo ebe bamamatenama꞉na꞉, mabu Nabiwite ebako epo olena ebe kamamatenama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Godote lumagino ololamo kokolina꞉, ebe uliyananomola. Ebema꞉ piyate ebe damamatena, modobola iba꞉te ebeno Uliyanano elawamo ega꞉walo ebeno nanitabo tanalodo namamatenama꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ebene kamiyalete ebetamo negiya, “Na iyatawala Mesayate ka꞉pemene, ebeno mailo idi Kelisotela. Ebete da꞉pemene Godokono tanalo bilibilinomo atamo kapawokalilaemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ya꞉sute ebetamo nowamiya, “Na a꞉ma꞉go tabo da꞉kiyawautama꞉, na Kelisotela.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ebe tetenomolo Ya꞉sukono waloma꞉tapiate duliyomolone da꞉ka꞉pelamiya, iba꞉te kawiya pela꞉wa꞉iya mabu ebete me kamiyala꞉go tabo eba kiyawautalo ebo pulamiya. Wiyasiya ibi magumulo lumagi idite ebe kamiyale ma kunu kaniya꞉, “A꞉ma꞉ beda꞉ tanalo osiyodiloma꞉ kowagela꞉wita?” ega꞉walo lumagi idite Ya꞉suko kaniya꞉, “Mabu keleka꞉ a꞉ma꞉le eba꞉go tabo da꞉kiyawawita?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ebema꞉ ebe tetelo kamiyalete ebeno upa obo gulilo atepate duliyomolamo tote epo ma kunu nanaliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dubu idi na꞉puma꞉la꞉. Diyala, ebe da꞉ Kelisotela꞉, mabu nale dopamo kebe kuba tanalo diya gabodo dosiyodilolenaimo, ebe iyaiya tanalo ebete natamo nanitabonomolo awokalilame.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ebema꞉ duliyomolo epate kamiyaleno tabamo tudila꞉ote Ya꞉suko uima꞉ gito tolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Duliyomolo epate eba pelamitalo ebe atu tetelo Ya꞉suko waloma꞉tapiate ebe kawiya naniya, “Iyatulamedawa, modobola a꞉ma꞉ bae nena.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wiyasiya Ya꞉sute iba꞉tamo negiya, “Ao, nale nama꞉ ditana ebe baeno nanitabo tanalo la꞉ iyatawa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ebema꞉ Ya꞉sukono waloma꞉tapiate ibi magumulo negeliya, “Diyala, lumagi idite ebetamo bae da꞉ ikamele.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ebene Ya꞉sute iba꞉tamo negiya, “Na dapaliboniya nale ebeno ubi tanalamo tuduwatalo ebeno woko uwomuamo da꞉nemaigamo, nale ebe gabodo elawo nanitabonomolo elawenakomo, bae na tanalo keba kunula꞉ka꞉ eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Numa꞉la꞉, la꞉ pali osiyodilole tetelo ma kunu gelanakomata, ‘Netewa-netewa saganate ba꞉na꞉pola꞉na, pali inamabu nao tete ka꞉pemene.’ Ebema꞉ nale la꞉ tabo idi analemata, la꞉le Godokono pali inamabu wadenomamo ulama꞉wete niyatawala꞉, nao inamabu uwate tete a꞉pe. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ega꞉walo me tanalo idila, kono wakalami wokodawate pali namutudawano uwomua꞉ igilo mabuma꞉ pali woko magumulo nao kono uwatenako. Nanitabola, namutudawate ebetamo wiya ikame iyalo owagilimi, iyo, me gabodo kono kikopu amiodawa ega꞉walo kono wakalami wokodawa, iba꞉te ibino wiya kawonomo kalakalago kapimiya kuwatema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Epate degelanaka ebe tanalo nanitabola, ‘Lumagi idite kono kikopu amiote wiyasiya ebeno ekawite pali inamabu uwate tetelo woko kosiyodilomene, ebene ibi netewapiate kapimiya kenaoma꞉na꞉.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ebema꞉ nale la꞉ pali inamabu uwatema꞉ eba kunu alibolemata, wiyasiya ebe pali inamabu la꞉le kamiawea꞉. Iyo, wokopi epetapiate dopamo kodakoda woko osiyodiliya, wiyasiya ka꞉lo la꞉ ibino wade woko osiyodilo magumune wadewade nao inamabu uwatenakomata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ebe tetelo ebe duliyomololo dilukulinamiya ebe Samaliya opo epo magumulo epetapi bilibilinomate Ya꞉suko nanitabokobi ebo midiya, mabu kamiyalete ibi ma kunu kiyawaolamiya, “Nale dopamo kebe kubakuba tanalo diya gabodo kosiyodilolenaimo, ebe iyaiya tanalo me dubute natamo nanitabonomolo awokalilame.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ebene iba꞉te ibino duliyomolone Ya꞉sutamo da꞉nemaimiya, iba꞉te ebe na꞉toweomiya ebete iba꞉godolo kokoliatepama꞉, ebema꞉ ebe tetelo Ya꞉sute netewa egela ebo ka꞉luti. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ebe tetelo duliyomolo epo epetapiate Ya꞉sukono tabo dolowiya, ibi magumulo epetapi bilibilinomate ebe nanitabokobi midite, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","kamiyale ma kunu aniya, “Dopamo tetelo a꞉imano tabo kapiya dolowima꞉ ale me dawa Ya꞉suko nanitabokobi ebo midima꞉, wiyasiya ka꞉lo ale aimano imila galamo ebeno tabo olowima꞉. Nanitabola, ebe me opo epono Igilo Mula꞉lelamedawala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Ya꞉sute me opolo dokolinami ebete ebeno tanaloma꞉ nanitabonomolo ma kunu genaki, “Godokono woki awokalimidawa ebeno duliyomolo epate ebe unamo akadipatema꞉na꞉, wiyasiya iba꞉te ebe ubia꞉noma꞉ beda꞉onakoma꞉na꞉.” Ebema꞉ Ya꞉sute ebe tanalo iyatawate Samaliya opolo netewa egelamo lutate, ebene ebe opo atepate ebeno Ga꞉lili opamo walo gito ka꞉tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ebe tetelo Ga꞉lili opo epo epetapiate ebe kalakalago lawiya, mabu iba꞉te dopamo Aduga꞉la Soliyomuma꞉ Yelusalema kawo duliyomolamo da꞉tolamiya Ya꞉sukono osiyodilole tanalo bilibilinomo nulamete wadewadenoma꞉ ebo negeliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ebene Ya꞉sute Ga꞉lili opono Ka꞉ina duliyomolamo walo gito ka꞉tiya, ebe duliyomolo ebe ebete dopamo Godokono elawo awokalimi tanalodo obonomo wade da꞉imi oboma꞉ da꞉midiya, ebe duliyomolola. Ebe tetelo gabamani dubu idi ebolo nokoliti, wiyasiya ebeno koite Kapeniyama duliyomololo kawo gabugabuago watiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ebene ebe gabamani dubute Ya꞉sute Yudiya opone pe tanalo dolowiya, ebema꞉ ebete ebetamo tote ebe nananiya, “Modobola꞉ka꞉ a꞉ma꞉ Kapeniyama duliyomolamo pa꞉wete naimano koi wadekobi na꞉pa꞉midiye, mabu ebe a꞉e tatalila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ya꞉sute wiyasiya ebetamo negiya, “La꞉ epo bilibilinomono tanalo ma kunula, nagodolo kawokawo anoano tanalo ulama꞉wea꞉no la꞉le na nanitabokobi ka꞉midina꞉wenakoa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Gabamani dubute ebetamo walo na꞉kegiya, “Kawodawa, niyata. A꞉ma꞉ nago samamo na꞉pa꞉, naimano gudute da꞉ba꞉emene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ebene Ya꞉sute ebetamo negiya, “A꞉ma꞉ kalakalago na꞉toa. A꞉imano koino igilote akalatidimene.” Ebe tetelo ebe dubute Ya꞉sukono tabo nanitabokobi midite ebeno Kapeniyama duliyomolamo to ebo wagilimiya, wiyasiya ebe atu egelalo ebete duliyomolamo ka꞉nemaigiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ebene egela idilo ebeno moto wokopi epetapiate eba꞉go dapalugiya, iba꞉te ebe napaniya, “Niyata, a꞉imano koite dutu igilo walo a꞉kelawi!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ebeno koite kebako tetelo wadekobi kolowile, ebete ebe tanalo laema꞉ ebeno wokopi dalateda꞉liya iba꞉te nowaimiya, “Dutu egela tuli tetelo, 1 koloko tete keba kunula꞉ka꞉, gabugabute ebe ebo atepi.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ebene nabiwite wokilo nemalagidiliya, ebe tete ebe atu tetenomola Ya꞉sute ebe dani koino igilote akalatidimene, ebema꞉ ebe ega꞉walo ebeno moto epo, ibi bilibilinomate Ya꞉suko nanitabokobi ebo midiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nanitabola, Ya꞉sute Yudiya opone Ga꞉lili opamo pete netewa anoano tanalo da꞉posiyodiloliya, me tanalo ebe idila. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Me tanalo dolopoligiya Ya꞉sute Yelusalema kawo duliyomolamo tiya Yu epono soliyomu idi ka꞉nuima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yelusalemano kala ga꞉dimi tetelo gigiyu idi bitana, ebeno mailo Sipi-goeogoeono Gigiyula, ega꞉walo me gigiyu niyakabolo mala꞉ ikila꞉no bobo ba꞉kitana, ebeno mailo Yu epono tabamo ebe Betesedala. Ebe bobo apuapune paibu tanatima꞉gopi motote lamota꞉onamiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ebene iyaiya temetema꞉gopi bilibilinomate ebe motono golololo pola꞉nanakiya, ibi magumulo epetapi balidi tamiopila, ega꞉walo epetapi agowa tataipila, ega꞉walo epetapi ape kodakoda temetema꞉gopila. Iba꞉te egela bilibilinomolo obono tete ebe makopelitanakiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","mabu iyaiya kapiyakapiya tetelo Kawodawa Godokono nopodawate bobono obo da꞉pologinaki obote gelewalemu ebo elewegediamidanaki. Ebe tetelo kebe temetema꞉godawate obo magumamo samamo da꞉niwisiganaki ebe kapiyate wade tanalo ebo lawenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ebene Ya꞉sute Beteseda bobamo da꞉nemaigiya, dubu idite ebolo na꞉luti, ebete 38 ulamalo pata꞉ modoboa꞉noma꞉ eda꞉nami. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ya꞉sute ebe eba watitalo da꞉numiya, ebete niyatawiya ebe dubute tete geyageyanomolo eba kunu okolinami. Ebema꞉ ebete ebe naniya, “A꞉ma꞉ ubila꞉ka꞉ Godote a꞉ma꞉ wadekobi midima꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Temetema꞉go dubute ebetamo nowamiya, “Kawodawa, me obo Godote gelewalemu dewegediamidanako, ebe tetelo na walubinidawa puliyala, ebema꞉ na obamo eba niwisigitalo wiyasiya lumagi idite dopamo niwisiganako modobo tanalo ka꞉nelaema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ya꞉sute ebetamo negiya, “A꞉ma꞉ maigawete, a꞉imano keta mokopiamidawete, na꞉toa.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ebe tetenomolo ebe dubute wadekobi olowite, ebeno keta lawete ebo tiya. Ya꞉sute ebe dubu wadekobi da꞉midiya, ebe egela ebe Yu epono wokoa꞉ talena egelala. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ebema꞉ ebe dubute keta eba aguwatitalo Yu watowatopi epetapiate ebe ma kunu kawiya aniya, “Eiye! Me aimano wokoa꞉ talena egelala! Keta aguwata magumulo a꞉ma꞉ aimano pukala adikamidala꞉ta!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ebete wiyasiya negiya, “Na wadekobi da꞉midini ebe dubute ma kunu anane, ‘A꞉imano keta mokopiamidawete na꞉toa.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ebema꞉ iba꞉te ebe nalatediya, “Kebe dubute kanata, a꞉ma꞉ keta aguawete ka꞉toaema꞉? A꞉ma꞉ a nanaa꞉, ebe dubu potelela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wiyasiya ebe dubute Yu watowatopiatamo wiya tabo gema꞉ ka꞉modobiya꞉, mabu ebete Ya꞉sukono tanalo kiyatawiya꞉ ega꞉walo Ya꞉sute ebe wadekobi midite ebete epo bilibilinomo magumamo gito nopegiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ebema꞉ walone Ya꞉sute Godoko Amamateno Iya Motolo ebe dubu walo da꞉kumiya ebo aniya, “Numa꞉, a꞉imano ape wadekobi olowi, ebema꞉ a꞉ma꞉ kuba idi walo ako-osiyodilala꞉. Diyala, kawo temetemete a꞉ma꞉tamo walo da꞉ba꞉ka꞉pemaigamene, ebene walogabo apuno temetemete kawonomoma꞉ eda꞉te, dopamo a꞉ma꞉ dumitanamiya ebe temeteme kodolimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ebe tetelo ebe dubute tote Yu watowatopi ma kunu nanaliya, “Na wadekobi da꞉midina꞉ka ebe dubu Ya꞉sutela.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mabu Ya꞉sute Yu epono wokoa꞉ talena egelalo temetema꞉gopi epetapi wadekobi da꞉midilinaki, ebema꞉ ibino watowatopi epetapiate ebetamo dowaote temeteme ikaema꞉ ebo wagilimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ebe tetelo Ya꞉sute iba꞉tamo negiya, “Naimano Nabiwite egela bilibilinomolo woko osiyodilona, ebema꞉ na ebeno Gudute atumu woko kosiyodilonamo, egela idi gito ka꞉lutanakoa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yu watowatopiate ebe tabo dolowiya iba꞉te ubi kawonomamo ebo iyatiya ebe kanakapuima꞉, mabu nanitabola, dopamo Ya꞉sute ibino talena egelano pukala adikamidaliya, wiyasiya me tetelo ebete Godoko ebeno nani Nabiwima꞉ gelo ebe a꞉ka꞉tuwa꞉ ebeno elawo Godokono elawago modoboma꞉ ge. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ebema꞉ Ya꞉sute iba꞉tamo negiya, “Na la꞉tamo nani tabonomo gemo, Godokono Gudute a꞉ka꞉tuwa꞉ ebeno ubilo tanalo idi osiyodiloma꞉ modoboa꞉, wiyasiya Gudute ebeno Nabiwino osiyodilo tanalo duminako ebete ebe atu tanalo ebe kosiyodilonako. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mabu Nabiwi Godote ebeno Gudu nilakapolo eba malagidilonalo ebeno osiyodilole tanalo bilibilinomo Gudutamo awokalilamena. Nanitabola, walone tetelo Nabiwite ebeno Gudutamo tanalo epetapi kawokawonomo kawokalilaemene ebete kosiyodilolema꞉, ebema꞉ la꞉ bilibilinomate ebe tanalo ulama꞉wete kanoanomamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nabiwite a꞉e lumagi igilamo keba kunu kadipatenakole, Gudute atumu eba kunu kowagelena, ebete kebe lumagitamo ubi diyatimene ebe lumagitamo nanitabo igilo kikaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ega꞉walo Nabiwi Godote a꞉ka꞉tuwa꞉ lumagi idino tanalo akanagiyamidaemene, wiyasiya ebete elawo Gudutamo ikamiya ebete epono iyaiya tanalo kanagilamelelaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ebema꞉ epo bilibilinomate Guduno mailo unamo kadipatema꞉na꞉, iba꞉te Nabiwino mailo keba kunu kadipatenake eba kunu. Kebe lumagite Gudutamo ubia꞉noma꞉ deda꞉na, ebete atumu Nabiwi Godotamo ubia꞉ tanalo nakawokalimina mabu me Gudu Nabiwite opo epatamo palibiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Na la꞉tamo nani tabonomo gemo, potele naimano tabo olowite ebene ebete na Alibonedawa nanitabokobi da꞉midina, ebegodolo uwomua꞉ igilo nanitabonomolo bitana, iyo, Godote ebe lumagino tanalo akanagiyamidaemene mabu ebete a꞉e magumune igilamo iyalo emaigi. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ebema꞉ na walo la꞉tamo nani tabonomo na꞉kegemo, tete ka꞉pemene, iyo, ebe na꞉pe, ebe tetelo a꞉elao epate Godokono Guduno tabo madodo dolowima꞉na꞉ iba꞉te uwomua꞉ igilamo kemaimioma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nanitabola, Nabiwi Godoko kapiyagodolo uwomua꞉ igilo bitana, ebema꞉ ebete ebeno Gudutamo elawo iyalo ikamiya ebete atumu Igilo Mabudawama꞉ ka꞉keda꞉nama꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ega꞉walo Nabiwite Gudutamo elawo walo a꞉kikamiya ebete epono tanalo kanagilamelelaema꞉, mabu me Gudu ebe Epono Naniwila. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ebema꞉ la꞉ olowiopi naimano kiyawao taboma꞉ akola꞉wa꞉oala꞉, mabu tete ebe na꞉pe, a꞉elao epate ebeno tabo madodo olowite ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bobo magumune igilamo kemaimioma꞉na꞉. Ebene ibi magumulo piyate me opolo wadewade tanalo kosiyodilolenaki iba꞉te Igilo Duliyomolamo ka꞉nodoloma꞉na꞉, wiyasiya piyate kubakuba tanalo dosiyodilolenakiya iba꞉te tabo anagiyamida bailo ibino kuba wiya ka꞉nuwatema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ya꞉sute walo na꞉kegiya, “Na a꞉ka꞉tuwa꞉ naimano ubilo tanalo idi osiyodiloma꞉ modoboa꞉, wiyasiya naimano Nabiwite na dananenako nale ebe gabo kapiyado epono tanalo ebo anagilamelelamenakomo. Ega꞉walo anagiyamida magumulo nale tuputupunomolo osiyodilonakomo, mabu na ubila na dapaliboniya ebe Kawodawa kapiya kekalakalaiminama꞉, na a꞉ka꞉tuwa꞉ na a꞉kekalakalaimo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Na a꞉ka꞉tuwa꞉ ma kunu degemo, ‘Na magumulo nanitabo tanalo bitana,’ epate ebe tabono nanitabo tanalo a꞉kelaema꞉na꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","wiyasiya Kawodawa idi bokolina, ebe Godotela, ebete naimano nanitabo tanalo awokalimina. Na iyatawala, ebete naimano tanaloma꞉ kebe tabo ka꞉kiyawaonale ebe tabo nanitabola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Dopamo tetelo la꞉ Yu watowatopiate dubu epetapi Yonetamo dalibola꞉ima, ebete iba꞉tamo naimano nanitabo tanalo atumu akawokalimi. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Numa꞉la꞉, me opo epate naimano tanaloma꞉ da꞉kiyawaona nale ibino tabo kolowinakoa꞉, wiyasiya Yonete dopamo da꞉kiyawai ebe tabo ebeno woki taboa꞉, ebe Godokono tabola. Ebe mabuma꞉ nale ebe atu tabo la꞉ walo nakanalemata, la꞉le nanitabokobi mida꞉wete Godote la꞉imano igilo ka꞉mula꞉lelametama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Iyo, Yoneko ebe wade alo keba kunula꞉ka꞉ ebe eba kunu pukuilamenami, ebene tete da꞉pesamo ebe alono tanaloma꞉ la꞉le la꞉imano ubi alomatepaolo ginima꞉mo walo na꞉kolowamimata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ega꞉walo me tanalo idila. Nabiwi Godote iyalo tetelo natamo dikanamiya, nale ebe woko eba osiyodilonalo naimano wokote naimano nanitabo tanalo awokalimina, na Godote paliboniya. Ebema꞉ dopamo tetelo Yonete naimano tanaloma꞉ nanitabo tanalo dawokalima꞉tepiya, wiyasiya me tetelo naimano wokote naimano nanitabo tanalo wadenomamo awokalimina. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nanitabola, na dapaliboniya ebe Nabiwite naimano nanitabo tanalo eba awokaliminalo, wiyasiya la꞉le ebeno tabo madodo kolowiawenakoa꞉ ega꞉walo ebeno ololo kuma꞉wenakoa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Iyo, ebeno tabo la꞉imano tepo magumulo kitana꞉, mabu ebete na me opamo paliboniya wiyasiya la꞉le naimano tabo nanitabokobi ka꞉mida꞉wena꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","La꞉le Godokono Buka apuno iyaiya tabo wadenomamo eka꞉la꞉miolenakomata, mabu la꞉ nemalagidilonamata ebe gabodo la꞉le uwomua꞉ igilo kelaemamota. Eiye, numa꞉la꞉! Me Buka apuno tabo bilibilinomate naimano nanitabo tanalo awokalimina, wiyasiya la꞉imano ka꞉la꞉miole magumulo ebe tabono magumunomo nanaetoamidanamata, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ebema꞉ la꞉ ubia꞉nola natamo pelama꞉wete nagodone uwomua꞉ igilo ka꞉pelawa꞉ema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Na ubia꞉nola me opo epate na moionema꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","mabu na iyatawala la꞉ kebako epola꞉ka꞉, la꞉imano tepo magumulo nilakapo kimalagidilo tanalote Godotamo nanitabolo kitana꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nanitabola, nale naimano Nabiwino elawamo piyamo wiyasiya la꞉le na kelawena꞉wena꞉, wiyasiya lumagi idite ebe a꞉ka꞉tuwa꞉ ebeno elawamo la꞉tamo da꞉pemene la꞉le ebe kalakalago kelaemamota, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","iyo, la꞉ ubila la꞉ magumulo idite idi kemoio, idite idi kemoio, eba kunu kowagela꞉wenama꞉. La꞉ nolowiala꞉, la꞉le iyaiya tuputupu tanalo aimano kapiya Godotamo osiyodilolema꞉ dowagela꞉ema ebe tetelo ebete la꞉ kemoiolema꞉ta, wiyasiya la꞉ ubia꞉nola. Me mabuma꞉ la꞉le na nanitabokobi a꞉ka꞉midina꞉ema, gabo puliyala! ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“La꞉ ma kunu akomalagidilala꞉, na kapiyate Nabiwi Godotamo la꞉ kuba osiyodilolepima꞉ keka꞉la꞉mitama꞉. Ao, Mosesete atumu la꞉ kubakubapima꞉ ka꞉keka꞉la꞉ima꞉ta, ebe la꞉le la꞉imano wade walubidawama꞉ degelawenakoma ebe dawala! ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ega꞉walo la꞉le Mosesekono tabo nanitabokobi na꞉mida꞉wenataleka꞉ la꞉le na atumu nanitabokobi ba꞉ka꞉midina꞉wena꞉, mabu ebete Godokono Bukamo iyaiya tabo dakuloliya, ebe tanalate naimano nanitabo tanalo awokalimina. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","La꞉ wiyasiya ebete Bukamo dakuloliya ebe tabo nanitabokobi ka꞉midila꞉wena꞉, ebema꞉ la꞉le naimano tabo nanitabokobi keba kunu na꞉ka꞉mida꞉ema? Gabo a꞉kitanamene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ebene ibino tabo kiyawao tanalo olopoligote, egela epetapi da꞉petoiya, tete idilo Ya꞉sute Ga꞉lili Paka꞉ apuamo peago gito na꞉iwiya, ebe paka꞉no mailo idi Taibiliyasila. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ebene epo bilibilinomate ebe ebamo waloma꞉tiya, mabu ebete temetema꞉gopiatamo dosiyodilolenaki, iba꞉te ebe anoano tanalo ulamoliya ega꞉walo iba꞉te kawo tanalo idi uima꞉ ubi iyatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ebene Ya꞉sute damela unamo nodolote ebe waloma꞉tapiago ebo nokoliti, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ebe tetelo Yu epono Aduga꞉la Soliyomu tete tatalima꞉ na꞉kediya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ebene adimo apulo epo epetapi bilibilinomate Ya꞉sutamo dapaladabutiniya, ebete ibi ulamenate Pilipiko nanani, “A me epo bilibilinomo walubilima꞉ bae kebolo na꞉kuwatelaema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ebe tetelo Ya꞉sute iyalo iyatawani ebete epatamo beda꞉ tanalo na꞉kosiyodilomene, ebema꞉ ebete Pilipiko me tabo anani, mabu ebe ubila ebeno nanitabokobi midi tanalo kuiminama꞉, da꞉ nanitabola꞉ o da꞉ nanitaboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ebene Pilipite ebetamo nowamini, “Me epo bilibilinomate bae kela꞉mo naoma꞉ kapiya ulamano woko wiya manite a꞉ka꞉modobomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ebe tetelo Ya꞉suko waloma꞉tadawa idi, ebeno mailo A꞉ndulutela, ebe Saimono Pitakono ekawila, ebete Ya꞉sutamo negeni, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Koi kapiya mela, ebegodolo paibu palowa bae ega꞉walo namo netewa ba꞉pola꞉na, wiyasiya ebe bae bilibilia꞉, me epo bilibilinomago a꞉ka꞉modobomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ebene Ya꞉sute ebe opono uwago kawonomo uminate ebe waloma꞉tapiatamo negeni, “La꞉ epo nanala꞉la꞉ iba꞉te gito kilukulima꞉.” Ebema꞉ epo bilibilinomate ebamo ilukulinate ebe epo deka꞉la꞉mioleniya ibino uwomu 5,000 dubuma꞉ eda꞉ni. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ebene Ya꞉sute ebe bae uwatenate Godotamo kalakala tabo genate, da꞉pola꞉niya ebe epatamo gito ikalamoleniya, ega꞉walo ebete namo kuwatenate eba kunu kowageleni epono bae kape tanalote ka꞉modobolamenama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ebe tetelo ebe baete ibi da꞉ugulamoleni Ya꞉sute ebe waloma꞉tapi nanaleni, “La꞉ da꞉luili ebe bae apuapu wadenomamo nuwata꞉la꞉, mabu ale me bae a꞉ka꞉kubailaema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ebema꞉ iba꞉te epagodolo da꞉luilini ebe palowa bae apuapu duwateniya, iba꞉te 12 bagowo ebe owiyaoleniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ya꞉sute ebeno elawo epatamo kawokaliminama꞉ me anoano tanalo dosiyodiloni, iba꞉te uminate negelaniya, “Nanitabola, me dubu ebe Godokono Iyanomo Woki Awokalimidawala, Godote me opamo paliboma꞉ degiya, me ebe Kawodawala!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ebe tetelo Ya꞉sute ibino ubi tanalo iyatawani, iba꞉te ebe lawenate ibino Kawo Elawodubuma꞉ gito ka꞉midinama꞉. Wiyasiya ebe ubia꞉nola, ebema꞉ ebete ibi miyapanate ebe a꞉ka꞉tuwa꞉ damela unu ida꞉mo gito nodoloni. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Egelate eba niwisiganalo Ya꞉suko waloma꞉tapiate paka꞉ balamo niwitionate, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","wiyasiya opote didokoni ebe tetelo Ya꞉sute iba꞉tamo samamo ka꞉peniya꞉, ebema꞉ iba꞉te peamo nolonate paka꞉ a꞉iwale ebo wagiliminiya Kapeniyama duliyomolo apuamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ebe tetelo kawo awate eba maiganalo kawokawo ulate ebo maimioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ebene iba꞉te paibu o sikisi kilomita mako tete geyageyadopolo eba nabidilonalo, ebe tetelo Ya꞉sute ibino pe niyakabamo obo unudo da꞉toni, iba꞉te ebe uminate kawonomamo ebo toletoleoniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","wiyasiya ebete ibi nanaleni, “Na Ya꞉sutela, la꞉ ka꞉toletoleonala꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ebema꞉ iba꞉te Ya꞉suko peamo kalakalago da꞉nowianiya, iba꞉te nela꞉wa꞉oniya mabu iba꞉te kebamo tolamenama꞉ dowageleniya, ebe tetenomolo iba꞉te ebe pe boboamo pe gito na꞉ilioniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ebene Ya꞉sute Ga꞉lili Paka꞉ apulo da꞉na꞉miyapani, egela idilo ebe epo bilibilinomate me tanalo iyatawaiya, Ya꞉sute ebe waloma꞉tapiago kapiya peago iba꞉tamo da꞉pa꞉iwaliya, wiyasiya adimo tetelo waloma꞉tapiate walo a꞉ka꞉tuwa꞉ da꞉ka꞉na꞉iwaleniya, Ya꞉sute iba꞉go ka꞉tonia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ebe atu tetelo Taibiliyasi duliyomolo epate Kawodawa Ya꞉sukono anoano osiyodilo tanaloma꞉ tabo ma kunu olowiya, ebete Godotamo baema꞉ kalakala tabo genate epo bilibilinomatamo dikalamoleni, ebema꞉ ibi bilibilinomo epetapiate ebe uima꞉ ibino peago ebe atu opamo ebo pelamoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wiyasiya ebe epate Ya꞉suko ega꞉walo ebe waloma꞉tapi ebolo nipo da꞉poliya, iba꞉te peamo walo kolote na꞉ka꞉tolamiya Kapeniyama duliyomolamo, iba꞉te Ya꞉suko ebolo ka꞉nowadima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ebene ebe epate Ya꞉suko Kapeniyama duliyomolo apulo da꞉numiya, iba꞉te ebe nananiya, “Iyatulamedawa, a꞉ma꞉ mamo kebe tetelo ka꞉pemaigawa꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ya꞉sute ibino tabo eba wiyalo negiya, “Nale la꞉tamo nani tabonomo gemo, la꞉le nagodone bae uwata꞉wenate, ebe baete la꞉ da꞉ugulamoletania la꞉le na unaema꞉ ebema꞉ pelaemata, wiyasiya naimano elawo awokalimino anoano tanalono magumu la꞉le la꞉imano wokiamo kelawa꞉wea꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","La꞉le kateneno ubi bae naoma꞉ woko kosiyodilonala꞉ mabu ebe baete samamo kabaleomene, wiyasiya modobola la꞉le uwomua꞉ igilo bae laema꞉ woko nosiyodilonala꞉. Mako bae na Epono Naniwite la꞉tamo kikalaemamota, mabu Nabiwi Godote me tanalo iyalo awokalimiya, na ebeno nanitabodawama꞉ eda꞉namo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ebene iba꞉te ebe naniya, “Ale Godokono iyaiya ubi tanalo kosiyodilolema꞉ beda꞉ woko na꞉kosiyodiloma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ya꞉sute iba꞉tamo nowamiya, “Godote la꞉godolo kapiya tanalonomo uima꞉ ubila, ebete me opamo dapalibiya la꞉ ebe dawa nanitabokobi na꞉mida꞉la꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ebema꞉ iba꞉te ebe walo nakaniya, “Ale a꞉ma꞉ nanitabokobi ka꞉miditama꞉ a꞉ma꞉le atamo beda꞉ anoano tanalo na꞉kosiyodilaemene? Modobola a꞉ma꞉ a꞉imano elawo atamo nawokalima꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Numa꞉, aimano ewoniate bulu opolo eba ilukulinalo, Godokono anoano osiyodilole tanalodo iba꞉te bae uwatenakiya, ebe baeno mailo ebe ma꞉nala. Iyo, Godokono Bukano tabote ma kunu itana, ‘Godote iba꞉tamo Unu Duliyomolono bae ikalamenaki,’ ebema꞉ modobola a꞉ma꞉ atumu a꞉imano elawo nawokalima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ya꞉sute negiya, “Nale la꞉tamo nani tabonomo gemo, Mosesete la꞉imano ewoniatamo dikalamenaki, ebe bae Unu Duliyomolono baenomoa꞉, wiyasiya me tetelo naimano Nabiwite Unu Duliyomolono baenomo la꞉tamo nikalamenata, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","mabu Godokono baenomo ebe Unu Duliyomolone da꞉piya ebe dawala, ebe kapiyate me opo epatamo nanitabo igilo ikalamena.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ebene iba꞉te ebe walo nakaniya, “Iyatulamedawa, modobola a꞉ma꞉le me tetene wagilima꞉wete ebe bae atamo nikaeamenakiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ebene Ya꞉sute negiya, “Na ebe igilo baela. Kebe lumagite natamo da꞉pemene ebe bae kapete walo a꞉kuminakomene, ega꞉walo kebe lumagite na nanitabokobi da꞉midinimene ebe obo kapete atumu a꞉kuminakomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Ka꞉lo nale la꞉imano tanalo ma kunu awokalimo, la꞉le la꞉imano balidinomamo naimano elawo uimata, wiyasiya la꞉le na nanitabokobi midinima꞉ ubia꞉nola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Naimano Nabiwite natamo ikanaema꞉ dowagelena, ebe epo bilibilinomate natamo ka꞉pelaema꞉na꞉, ega꞉walo kebe dawate natamo da꞉pemene nale ebe iyabaiamo gito akalibamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Numa꞉la꞉, Unu Duliyomolone na dapaliboniya nale ebe Kawodawano ubi tanalo osiyodiloma꞉ me opamo piyamo, na a꞉ka꞉tuwa꞉ naimano ubi tanalo a꞉kosiyodilomo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ebema꞉ na dapaliboniya ebe dawano ubi tanalo ma kunula, ebete natamo kebe epo kikanamenale ibi magumulo idi kapiyate akalatidimene, ebene Uwomu Egelalo nale ibi bilibilinomo nanitabo igilamo kowadipalatelemamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Iyo, naimano Nabiwi ubila, kebe lumagite ebeno Gudu umite nanitabokobi da꞉midimene, ebete uwomua꞉ igilo kelaemene, ebema꞉ nanitabola, Uwomu Egelalo nale ebe lumagi nanitabo igilamo kadipatemamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ebene Yu epo epetapiate Ya꞉sukono tanaloma꞉ ubia꞉ tabo geliya, mabu ebete tabo ma kunu giya, “Na ebe Unu Duliyomolone da꞉piya ebe igilo baela.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ebema꞉ iba꞉te negeliya, “A, nanitabola꞉ka꞉, me Ya꞉suko Yausepekono gudula! A iyatawala ebeno menokola nabiwila! Mabu keleka꞉ ebete Unu Duliyomolone pema꞉ dege?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ya꞉sute ibino tabo iyatawate iba꞉tamo nowamiya, “La꞉ magumulo ubia꞉ tabo kegelitala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nabiwi Godote lumagi idi natamo magaea꞉no, ebe dawate ebeno ubilo a꞉ka꞉tuwa꞉ natamo pema꞉ a꞉ka꞉modobomene, wiyasiya Nabiwite kebe dawa natamo demagaemene, nale ebe lawete Uwomu Egelalo uwomua꞉ igilamo kadipatemamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Numa꞉la꞉, dopamo Godokono woki awokalimipiate ebeno Bukamo tabo ma kunu akuloliya, ‘Tete na꞉pe, Godote a꞉ka꞉tuwa꞉ me opo epo bilibilinomo ebeno gabo kiyatulaemene.’ Ebema꞉ me tanalo nanitabola, potele Nabiwino tabo madodo olowite ebegodone wade iyatawa tanalo delawenako, ebe dawate natamo ka꞉pemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Naimano tabono magumu kubanu akolawa꞉la꞉. Me opo lumagi idite Nabiwino ololo dopamo kumiya꞉, wiyasiya potele Godogodone da꞉piwisigiya ebe kapiyate Nabiwino ololo umiya, ebema꞉ la꞉le ebe kapiyagodone Nabiwino tabo kolowiomamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Iyo, nale la꞉tamo nani tabonomo gemo, kebe lumagite na nanitabokobi da꞉midinina ebegodolo uwomua꞉ igilote bitanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na ebe igilo baela. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","“Numa꞉la꞉, la꞉imano ewoniate ma꞉nama꞉ deka꞉minakiya, iba꞉te bulu opolo ebe bae naonakiya ebene walone tetelo ibi bilibilinomate a꞉elaiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","wiyasiya Unu Duliyomolone da꞉piya, ebe bae lumagite denamene ebete a꞉ka꞉emene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na ebe Unu Duliyomolone da꞉piya ebe igilo baela, ebema꞉ nanitabola, kebe lumagite me bae denamene ebete uwomua꞉ tetelo nanitabo igilago bokolinamene. Nale ebetamo dikamenakomo ebe bae ebe naimano apeno katenela, mabu nale naimano ape me opo epatamo ikalaemo ibino igilo ka꞉mula꞉lelaema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ebema꞉ Yu epono dowate demaigiya, iba꞉te ibi magumulo apaminateuilo negeliya, “Ale me dubuno katene kenaoma꞉, ebete atamo keba kunu na꞉kikaeaemene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ebene Ya꞉sute iba꞉tamo negiya, “Nale la꞉tamo nani tabonomo gemo, la꞉le Epono Naniwino katene naoa꞉no ega꞉walo ebeno kalima nioa꞉no, nanitabo igilote la꞉godolo a꞉kitanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Iyo, kebe lumagite naimano katene denanako ega꞉walo naimano kalima da꞉ninako, ebegodolo uwomua꞉ igilote bitanamene, ega꞉walo nale Uwomu Egelalo ebe nanitabo igilamo kadipatemamo, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","mabu naimano katene ebe nanitabo igilo baela, ega꞉walo naimano kalima ebe nanitabo igilo obola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nanitabola, kebe lumagite naimano katene denanako ega꞉walo naimano kalima da꞉ninako, ebete na magumulo bokolina ega꞉walo nale ebe magumulo bokolinamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na dapaliboniya ebe Nabiwino nanitabo igilote nagodolo keba kunu kitanale, eba kunu kebe lumagite naimano katene denanakomene, ebete naimano igilago bokolinamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ebema꞉ numa꞉la꞉, naimano ape ebe Unu Duliyomolone da꞉piya ebe igilo baela. Me baete lumagitamo nanitabo igilo bikamenakomene, wiyasiya la꞉imano ewoniate denaonakiya ebe baete igilo iba꞉tamo nanitabolo kikalamenakia꞉, iyo, walone iba꞉te gito a꞉elaiya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ya꞉sute Kapeniyama duliyomololo Yu epono balidi ibilamole motolo ibi diyatulamiti, ebe tetelo ebete iba꞉tamo me tabo geyageyadopo kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ebe tetelo Ya꞉suko waloma꞉tapi epetapi bilibilinomate ebeno iyatulame tabo olowite negeliya, “Me tabono magumu kodakodanomola, potele laema꞉ na꞉ka꞉modobomene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iba꞉te ebeno iyatulame tanaloma꞉ kebe ubia꞉ tabo degelitiya, Ya꞉sute iyatawate negiya, “Mabu keleka꞉ naimano iyatulame tanalote la꞉imano nanitabokobi midi tanalo da꞉kubailamita? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nanitabola, Epono Naniwite dopamo dokolinami ebete ebe Kalakala Duliyomolamo walo ka꞉ka꞉nodolomene, ebema꞉ la꞉le ebe anoano tanalo duma꞉ema la꞉ keba kunu na꞉kowagela꞉ema? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Numa꞉la꞉, Godokono Uliyanate epatamo nanitabo igilo ikalamena, wiyasiya kateneno elawote iba꞉tamo igilo ikalaema꞉ ka꞉modobonakoa꞉. Ebema꞉ nanitabola, nale la꞉tamo da꞉kiyawaomo ebe tabo ebe igilola, iyo, ebe tabote Godokono Uliyanagodone pe, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","wiyasiya la꞉ epetapiate nanitabokobi ka꞉mida꞉wea꞉.” Ya꞉sute me tabo kiyawaiya mabu ebete ebeno woko wagilimi mabune iyalo iyatawiya, ebe waloma꞉tapi magumulo piyate ebe nanitabokobi midia꞉pima꞉ deda꞉onama꞉na꞉ ega꞉walo potele ebe anakapumipino kotamo diyatimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ebene ebete tabo moga꞉melo walo na꞉kegiya, “La꞉imano nanitabokobi midia꞉ tanaloma꞉ nale iyalo ma kunu gemo, Nabiwite elawo lumagitamo ikamea꞉no, ebete a꞉ka꞉tuwa꞉ ebeno ubilo natamo a꞉ka꞉pemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ebe mabuma꞉ Ya꞉suko waloma꞉tapi epetapi bilibilinomate eba꞉go wapata꞉laema꞉ ubia꞉noma꞉ eda꞉ote ibino iyaiya ilukuli tanalamo walo gito kolowamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ebene Ya꞉sute ebeno 12 waloma꞉tapi epetapi nalateda꞉liya, “La꞉ atumu, la꞉le na bakatepana꞉ema?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimono Pitate ebetamo nowamiya, “Kawodawa, a potamo na꞉ka꞉tolaema꞉ mabu a꞉ma꞉ kapiyagodolo nanitabo igilo tabonomo bitana? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","A iyatawala a꞉ma꞉ Godokono Wade-talena Dawalata, ebema꞉ ale a꞉ma꞉ nanitabokobi na꞉midinata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ya꞉sute wiyasiya iba꞉tamo negiya, “A, nanitabola꞉ka꞉, nale a꞉ka꞉tuwa꞉ la꞉ 12 dubu uwatimata, wiyasiya la꞉ nolowiala꞉, la꞉ magumulo kapiyate Saitanakono wokodawama꞉ eda꞉na!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ebete me tabo Yudasikono tanaloma꞉ giya, ebe dubu ebe Keliyota duliyomolodawa Saimonokono gudula. Dopamo me dubute 12 waloma꞉tapi magumulo okolinami, wiyasiya walone tetelo ebete Ya꞉suko anakapumipino kotamo ebe iyatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ebene ibino tabo kiyawao tanalo dolopoligiya, ebe tetene wagilimite Ya꞉sute Ga꞉lili opo kawonomolo pata꞉nami, wiyasiya ebete Yudiya opolo pata꞉ma꞉ ubia꞉nola mabu ebe opono Yu watowatopiate ebe anakapuima꞉ wagelenamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ebene Yu epono Nupunupu Etemoteono Soliyomu detataliya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ebe tetelo Ya꞉sukono ekakiate ebe naniya, “Modobola a꞉ma꞉ me Ga꞉lili opo atepawete Yudiya opamo walo na꞉ka꞉toa. Diyala, a꞉ma꞉le waloma꞉tapi epetapi ebolo da꞉ba꞉nulaemene, ebene a꞉ma꞉le dosiyodilola꞉wenaka iba꞉te ebe anoano tanalo wadenomamo kulaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Numa꞉, lumagite ubi diyatimene epo bilibilinomate ebe kowaloma꞉tama꞉, modobola ebete ebeno tanalo akowaminala꞉. Ebe mabuma꞉ a꞉ma꞉le me iyaiya anoano tanalo nanitabolo dosiyodilola꞉wenaka, modobola a꞉ma꞉ atumu a꞉imano tanalo me opo epo bilibilinomatamo nawokalimiye!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ya꞉sukono ekakiate ebe kalakalatelo me tabo kiyawaiya mabu iba꞉te ebe nanitabokobi ka꞉midiya꞉, epo epetapi bilibilinomate nanitabokobi midia꞉noma꞉ keba kunu keda꞉iye eba kunu. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ebema꞉ Ya꞉sute ebeno ekakino tabo eba wiyalo negiya, “La꞉ a꞉ka꞉tuwa꞉ la꞉imano iyaiya ubi tetelo la꞉imano tanalo ebo osiyodilolenakomata, wiyasiya naimano nanitabo tete Godogodone ka꞉pea꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Me opo epate la꞉tamo ka꞉dowaona꞉, wiyasiya iba꞉te natamo dowaona mabu nale ibino iyaiya kuba osiyodilole tanalo awokalilamenakomo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ebema꞉ la꞉ a꞉ka꞉tuwa꞉ soliyomu baiamo na꞉tolama꞉la꞉, wiyasiya na ka꞉lo a꞉ka꞉toamo mabu Godokono nanitabo tete natamo ka꞉pea꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ya꞉sute me tabo gete Ga꞉lili opolo ebo olowagiliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ya꞉sukono ekakiate soliyomuma꞉ da꞉tolamiya, ebete wiyasiya walone diya gabodo waloma꞉taliya, awokala ka꞉tiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ebe tetelo Yu watowatopiate soliyomu bailo ebe eba wadilo negeliya, “Me dubu Ya꞉suko keleka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ega꞉walo piyate soliyomuma꞉ da꞉pelamoliya ebe Yu epo bilibilinomate Ya꞉sukono tanaloma꞉ tabo gananalo kawonomamo kiyawautiya. Epetapi iba꞉te negeliya, “Ebe wade lumagila,” wiyasiya epetapiate negeliya, “Ao, ebe epo nemasigilina.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ebe tetelo iba꞉te Ya꞉sukono tanaloma꞉ awokala kegelitiya꞉ mabu iba꞉te ibino watowatopino dowa tanalo tolemitiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ebene epate ibino soliyomu eba osiyodilonatelo egela idilo Ya꞉sute iba꞉tamo nawokalate Godoko Amamateno Iya Motamo tote iyatulame ebo nowagilimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ebe tetelo ebeno iyatulame taboma꞉ Yu watowatopiate eba anoanoutalo negeliya, “Eiye! Me dubute kebako iyatawa kelawile mabu ebete ka꞉sukuliya꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ya꞉sute wiyasiya iba꞉tamo negiya, “Nale la꞉ diyatulametanama, ebe tabote na dapaliboniya ebe Kawodawagodone pena, na a꞉ka꞉tuwa꞉ naimano ubi tanalodo kiyatulametana꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","La꞉ a꞉ka꞉tuwa꞉ la꞉imano taneba magumulo naimano tanaloma꞉ ma kunu gelanamata, ‘Ebeno iyatulame tanalote Godogodone da꞉penale o da꞉ ebeno kateneno wokine da꞉penale.’ Numa꞉la꞉, la꞉ magumulo potele Godokono ubi tanalo osiyodiloma꞉ ubi diyatina, ebe modobola naimano iyatulame tanalono mabu la꞉tamo kiyawaoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iyo, kebe tetelo lumagite ebeno kateneno wokino tabo da꞉kiyawaona, ebe a꞉ka꞉tuwa꞉ ebe walogona, wiyasiya kebe lumagite ubi diyatina ebe alibodawa kapiya kowalogonama꞉, ebe lumagi ebe nanitabo tanalo awokalimidawala, ebegodolo elemasigi tanalo kitana꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Godote ebeno Totomu Tabo Mosesedo la꞉tamo ikalamiyata wiyasiya la꞉ magumulo kapiya idite ebe totomu tabo bilibilinomamo nanitabonomolo ka꞉tuduwatana꞉, a, nanitabola꞉ka꞉? Wiyasiya na tuputupu lumagima꞉ eba eda꞉nalo, mabu keleka꞉ la꞉le na anakapunaema꞉ dowagela꞉wenama?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ebe tetelo Ya꞉sukono tabo dolowiutiya ebe epo bilibilinomate ebetamo negeliya, “A꞉ma꞉ kuba uliyanagonolata! Potele kegitale a꞉ma꞉ anakapuima꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ya꞉sute wiyasiya iba꞉tamo negiya, “Nale la꞉imano ololo apulo kapiya anoano tanalo dosiyodilimo, la꞉ kawiya ebo la꞉wa꞉imata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","La꞉ numa꞉la꞉, Mosesete la꞉tamo pukala idi dikalametiyala, ebe pukala ebe la꞉le baibai guda꞉tamo tama itamida pukala kalomolama꞉wenakoma꞉. Iyo, la꞉le me pukala alomo tanalo Mosesegodone laema꞉ gelanamata, wiyasiya me tanalo ebegodone nanitabolo ka꞉pemaigiya꞉, la꞉imano ewoni epetapiagodone piya. Ega꞉walo Mosesete talena egelano pukala atumu la꞉tamo a꞉kikalamiyata, ebema꞉ ebe netewa pukala la꞉godolo eba pola꞉nalo gudu idino pukala iyatimi tetete wokoa꞉ talena egelalo demaiganako, la꞉le gito osiyodilonakomata mabu Godote ma kunu kegena꞉, tama itamida pukala iyati tanalote talena egelano pukala kadikamidalemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Iyo, la꞉imano osiyodilo tanalo ebe ma kunula, la꞉le Godokono ubi tanalamo ka꞉tudila꞉ema꞉ Mosesekono totomu tabo bilibilinomo magumulo kapiya kodakodalo eba lawelo wokoa꞉ talena egelano pukala ebo adikamidalenakomata. Ebema꞉ nale wokoa꞉ talena egelalo temetema꞉go dubu idi wadekobi da꞉midimo, wiyasiya mabu keleka꞉ la꞉le natamo da꞉dowawitama? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Eiye, la꞉ unu gabodo naimano tanalo gito akoanagiyamidanama꞉la꞉, modobola la꞉ wiyasiya Godokono tuputupu gabodo lumagino tanalo nanagiyamidama꞉la꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ebe tetelo Yelusalema duliyomololo dilukulionamiya ibi epetapiate negeliya, “A, nanitabola꞉ka꞉, me dubu ebe epetapiate anakapuima꞉ dowagelena ebe lumagila! ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Numa꞉la꞉, ebete ilipoa꞉no tabo awokala kiyawauta, wiyasiya aimano watowatopiate ebe odiyoboma꞉ tabo idi kegelita꞉. Diyala, ibi da꞉ iyatawala꞉, me dubute Godokono Alibodawa Kelisoma꞉ deda꞉na. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","A iyatawala me dubuno duliyomolono tanalo, wiyasiya Godokono Bukate a niyatuamena, nani Kelisote da꞉pemaigamene, ebe tetelo epate a꞉kiyatawaoma꞉na꞉ ebete kebene ka꞉pemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ebema꞉ Ya꞉sute Godoko Amamateno Iya Motolo epo eba iyatulamitalo kawonomamo negiya, “La꞉ nanitabolo iyatawala꞉ka꞉ nale kebene ka꞉piyamo ebe duliyomolono tanalo? Ega꞉walo naimano tanaloma꞉ la꞉godolo nanitabo iyatawa ba꞉kitanale? La꞉ nolowiala꞉, na a꞉ka꞉tuwa꞉ naimano ubilo ka꞉piya꞉ la꞉tamo, na Kawodawate paliboniya. Ebe nanitabo tanalo awokalimidawala, wiyasiya la꞉le ebeno tanalo kiyatawawena꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","iyo, na a꞉ka꞉tuwa꞉ ebeno tanalo iyatawala, mabu nale ebegodone piyamo ega꞉walo ebete na apaliboniya.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ebe taboma꞉ epetapi ubila Ya꞉suko idoko motamo iyatima꞉, wiyasiya ibi magumulo idawate ebe kelawiya꞉ mabu ebe tanalote nanitabolo pemaigama꞉ Godogodone tete pea꞉nola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wiyasiya ebe atu tetelo epo epetapi bilibilinomate Ya꞉suko nanitabokobi midilo negeliya, “Me dubugodolo anoano tanalo bilibilinomo ulamenakoma꞉, ebema꞉ ebe da꞉ Kelisotela꞉. Iyo, lumagi idite Keliso mailamo demaigamene, ebeno elawote me dubuno elawo a꞉kodolimene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Epo bilibilinomate Ya꞉sukono tanaloma꞉ tabo gananalo degelitiya, Pa꞉lisi tanebapiate olowite ebene ibi ega꞉walo Godotamo kalimagono ikameopino watowatopi iba꞉te Godoko Amamateno Moto atila꞉pi epetapi dubu ebo naliboliya, iba꞉te Ya꞉suko nelawete idoko motamo ka꞉piyatima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ebe atu tetelo Ya꞉sute epatamo na꞉kiyawauti, “Na la꞉go tete da꞉pesamo okolite, na dapaliboniya ebe Kawodawatamo walo ka꞉ka꞉tomamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ebene la꞉le na nipo kowadinimamota, mabu nale kebe duliyomolamo da꞉tomo la꞉le ebe duliyomolamo tolaema꞉ modoboa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ebema꞉ Yu watowatopiate ibino taneba magumulo negeliya, “Me dubute kebe duliyomolamo na꞉ka꞉tomene, ebene ale ebe uima꞉ a꞉ka꞉modoboma꞉? Diyala, aimano epo epetapiate iyaiya Yua꞉pino opolo da꞉nilukuliona, ebete iba꞉tamo da꞉ba꞉tomene iba꞉go ka꞉nokolima꞉, ebene ebete ebe Yua꞉pi Godokono tabo da꞉ba꞉niyatulaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ebete nege, ‘La꞉le na nipo kowadinimamota,’ ega꞉walo ebete walo na꞉kege, ‘Nale kebe duliyomolamo da꞉tomo la꞉le ebe duliyomolamo pelaema꞉ modoboa꞉.’ Eiye! Ebeno tabono magumu keba kunula꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yu epono Nupunupu Etemoteono Soliyomu magumulo uwomu egela ebe kawo egelanomoma꞉ eda꞉na. Ebene ebe egelate da꞉piya Ya꞉sute epo bilibilinomono magumulo maigate kawonomamo negiya, “Kebe lumagi obo kapete dumina, modobola ebete pete nagodolo obo na꞉pa꞉nimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ega꞉walo kebe lumagite na nanitabokobi da꞉midinimene, ebe lumagino tepo magumune uwomua꞉ igilo obote ba꞉peka꞉ka꞉liyanamene, mabu Godokono Bukate eba kunu gena.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Buka ka꞉la꞉mioledawa, modobola a꞉ma꞉ niyatawa Ya꞉sute me tabo Godokono Uliyanano tanaloma꞉ kiyawauti. Iyo, dopamo tetelo Uliyanano elawote Ya꞉suko nanitabokobi midipiagodolo kitanamia꞉, wiyasiya Godote ebe a꞉e magumune dadipatiya, ebete Unu Duliyomolamo odolote kawo alonomote ebe ebo na꞉pukuimiya. Ebe tetelo Ya꞉suko nanitabokobi midipiate Uliyanano elawo nanitabolo ebo lawiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ya꞉sukono tabo dolowiya ebe epono taneba magumulo epetapi bilibilinomate negeliya, “Me dubu ebe Godokono Iyanomo Woki Awokalimidawala, Mosesete dopamo pema꞉ nanitabolo degiya me ebe dubula.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wiyasiya epetapiate negeliya, “Ao, ebe Kelisotela, Godokono Alibodawala.” Ega꞉walo epetapiate na꞉kegeliya, “Ao, me dubu Ga꞉lili opodawala. Modoboa꞉ Kelisote mako kuba opolo pawokalama꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","mabu Godokono Bukate a niyatuamena, Kelisote Da꞉ibidikono Beteliyama duliyomololo ebeno walone guda꞉godone kawokalamene, Ga꞉lili opoloa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ebema꞉ epo magumulo Ya꞉sukono tanaloma꞉ anagiyamida tanalote maigiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ega꞉walo epetapi ubila ebe idoko motamo kiyatima꞉, wiyasiya ebe tetelo ibi magumulo lumagi idite ebetamo tanalo idi kosiyodiliya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ebene Pa꞉lisi tanebapi ega꞉walo Godotamo kalimagono ikameopino watowatopi, iba꞉te Ya꞉suko laema꞉ kebe dubu dopamo danaliboliya, ebe dubate Ya꞉suko lawea꞉no walo gito ka꞉pelamiya. Ebema꞉ Yu watowatopiate ibi nanaliya, “Keleka꞉ mabu la꞉le ebe dubu atamo kemagaeawea꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ebe dubate ibino tabo eba wiyalo negeliya, “Ebe dubuno tabo wadenonomola, a dopamo ebako tabo kolowionakia꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ebene Yu watowatopiate ibi kawiya eba analelo negeliya, “Eiye! La꞉ ebeno a꞉da꞉ elemasigi tabo olowiawete nanitabokobi a꞉ka꞉mida꞉ema? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Numa꞉la꞉, a Pa꞉lisi tanebapi ega꞉walo watowatopi epetapi, a magumulo lumagi idite ebeno tabo nanitabokobi ka꞉midina꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nanitabola, kebe kubakuba daleya epate ibino ubi tanalo ebetamo diyatina, iba꞉te Mosesekono totomu tabo wadenomamo niyatawaotaleka꞉, a keba kunula꞉ka꞉ iba꞉te atumu ebe nanitabokobi a꞉ka꞉midina꞉. Wiyasiya ibi bilibilinomo daedalepila, ebema꞉ Godote ibi Ela Opamo kiyalekemene!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ebe tetelo Nikadimasite ebe watowatopino taneba magumulo na꞉luti, ebete idoko tetelo Ya꞉suago tabo kiyawaonama꞉ dopamo da꞉toni ebe dubula. Ebene ebete watowatopi epetapiatamo negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“La꞉ nanisiwale! Aimano totomu tabo idite a niyatuamena, lumagi idino nanitabo tanalo laema꞉ ebeno tabo olowia꞉no ale ebe unu tama gabodo kubama꞉ gito a꞉kegelama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ebene iba꞉te ebe kawiya eba analo negeliya, “Eiye! A꞉ma꞉ atumu Ga꞉lili opono daleya lumagi idila꞉ka꞉? Modobola a꞉ma꞉ Godokono Buka apuno iyaiya tabo nulamoliye, ebema꞉ a꞉ma꞉ kiyatawama꞉ta Godokono woki awokalimipi bilibilinomo magumulo idawate Ga꞉lili opone dopamo kemaiganakia꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ebene dadimoni ebe epo bilibilinomate ibino iyaiya motamo ebo tolamoleniya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","wiyasiya Ya꞉sute Olibi Kewakewa Unu Damelamo gito toni. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ebene egela idilo Ya꞉sute Godoko Amamateno Iya Motamo duiyanomolo walo ka꞉pete, epo bilibilinomate ebetamo da꞉pelamiya, ebete okolite ibi iyatulame ebo wagilimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ebe tetelo Godokono totomu tabo iyatulamepi epetapi ega꞉walo Pa꞉lisi tanebapi, iba꞉te kamiyale idi lawete epono ololo apuamo gito magatiya, mabu me kamiyalete kamiyale idino awiago kawo kuba osiyodilutalo iba꞉te ebo ulamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ebema꞉ iba꞉te Ya꞉suko naniya, “Iyatulamedawa, me kamiyale kamiyale idino awiago kawo kuba eba osiyodilutalo, ale ibi ulamete me kamiyale ebo laema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesekono totomu tabote a niyatuamena, mako kamiyaleno kuba osiyodilo mabuma꞉ modobola epate ebe nokolamo mapemete nanakapuima꞉na꞉. Ebema꞉ a꞉imano woki keba kunula꞉ka꞉? Ale ebetamo a꞉e wiya ba꞉kikaema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iba꞉te me tabo Ya꞉sutamo negelitiya, mabu ibi ubila epono ololo apulo Ya꞉sukono tanalo ma kunu awokalima꞉, ebete Mosesekono totomu tabamo da꞉ba꞉tuduwatamene o a꞉ka꞉tuduwatamene. Ebete tuduwata꞉noma꞉ degemene, ebe tetelo iba꞉te ebe kubadawama꞉ kegelama꞉na꞉. Ya꞉sute wiyasiya ibino tabo wiya꞉no tuduwatate ebeno kotamo damelamo iyaiya tabo akuloliti. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ebema꞉ iba꞉te atu alateda꞉ tabo ebe kawiya analo atepa꞉no, ebe tetelo Ya꞉sute maigate negiya, “Kuba꞉nola, la꞉imano taneba magumulo potele kuba osiyodiloa꞉dawama꞉ deda꞉na, modobola ebete dopo nokola lawete ebe na꞉mida꞉emene, ebene la꞉ epetapiate walogabo apune ebe mapema꞉wete ebo nanakapumiyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ebene Ya꞉sute opamo walo ka꞉tuduwatate ebeno kotamo iyaiya tabo epetapi kakuloliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ebema꞉ piyate Ya꞉sukono tabo dolowiya, iba꞉te woki iyakobi midilite, ebene ibino taneba magumulo kapiya idi tonaki, kapiya idi tonaki, ebe dubu bilibilinomate iyaiya ma kunu tolamoliya kadelekadela꞉godone wagilimite oli ape dubatamo nemaiga. Ebe tetelo Ya꞉suko kapiyate ebolo okoliti, ega꞉walo ebe kamiyalete ebeno ololo apulo utiti. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ebene Ya꞉sute ebeno wato adipatete kamiyaletamo negiya, “Kamiyale, kuba wiya a꞉ma꞉tamo ikaema꞉ dowagelitaka, ebe epo keleka꞉? A꞉ma꞉ kuba dawama꞉ degita, ebako lumagi idi ba꞉ka꞉lutale?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ebete wiyasiya negiya, “Ao, Kawodawa, natamo kuba wiya ikanamedawa idi puliyala.” Ebene Ya꞉sute ebetamo negiya, “Na atumu a꞉ma꞉tamo kuba wiya a꞉kikametama. Modobola a꞉ma꞉ na꞉toa, walone tetelo ebako kuba walo ako-osiyodilala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tete idilo Ya꞉sute Pa꞉lisi tanebapiatamo walo na꞉ka꞉kiyawaiya, “Na ebe me opo kawonomono alola. Kebe lumagite na dowaloma꞉enena ebete idoko magumulo a꞉kepata꞉namene mabu ebegodolo nanitabo igilo alote bitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ebene Pa꞉lisi tanebapiate ebetamo negeliya, “A꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉ma꞉ adipatelo degeawa꞉, ebema꞉ epate a꞉imano tabo a꞉kelaema꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ya꞉sute ibino tabo eba wiyalo negiya, “Ao, na a꞉ka꞉tuwa꞉ na kadipatenakoa꞉, wiyasiya naimano nanitabo tanalo na a꞉ka꞉tuwa꞉ nawokalimitaleka꞉, naimano iyaiya tabote nanitabonomoma꞉ beda꞉ona꞉, mabu na kapiyate iyatawala nale kebene ka꞉piyamo ega꞉walo nale walo kebamo da꞉ka꞉tomo. La꞉le wiyasiya naimano tanalo kiyatawawena꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","mabu la꞉ me opo epono woki gabodo lumagino tanalo gito anagilamelemenakomata! Numa꞉la꞉, nale me opolo eba okolinalo lumagi idino tanalo anagiyamidamete kuba wiya kikamenakoa꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","wiyasiya kebe tetelo nale lumagi idino tanalo nanagiyamidametaleka꞉ ebeno tanalo nanitabolo bawokalimina꞉, mabu Nabiwite na dapaliboniya ebete elawo natamo ikanamiya ebe tanalo kosiyodiloma꞉. Ebeno woki ega꞉walo naimano woki kapiyala, ebema꞉ nale lumagi idino tanalo kubama꞉ degitamo na kapiyate kegita꞉, ebe tetelo naimano Nabiwite atu tabo ebe kegita. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","La꞉imano totomu tabo idite ma kunu gena, epono anagiyamida magumulo netewapiate atu tabo degelama꞉na꞉ tabo anagiyamidapiate ebe tanalo nanitaboma꞉ kegelama꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ebema꞉ numa꞉la꞉, nale naimano nanitabo tanalo eba awokaliminalo, na dapaliboniya ebe Nabiwite atumu naimano nanitabo tanalo la꞉tamo nakawokalimina.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ebe tetelo iba꞉te ebe negelamiya, “A꞉imano nabiwi ale kumita꞉. Ebe keleka꞉?” Ya꞉sute ibino tabo eba wiyalo negiya, “Na ega꞉walo naimano Nabiwi, aimano tanalo la꞉ kiyatawawena꞉. La꞉le naimano nanitabo tanalo niyatawawetaleka꞉, naimano Nabiwino tanalo atumu la꞉ biyatawawena꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ya꞉sute Godoko Amamateno Iya Motolo eba lutalo, ebete ebe Motono nilakapo mani alomo bailo epo eba iyatulamitalo me tabono iyaiya tanalo Pa꞉lisi tanebapiatamo ebo kiyawaiya. Ebe tetelo epetapi ubila ebe idoko motamo kiyatima꞉, wiyasiya ibi magumulo idawate ebe kelawiya꞉ mabu ebe tanalote nanitabolo pemaigama꞉ Godogodone tete pea꞉nola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ebema꞉ Ya꞉sute Pa꞉lisi tanebapiatamo walo na꞉kegiya, “Tete tatalila, nale la꞉ ka꞉miyapamamota, ebene la꞉le na eba wadinilo la꞉ la꞉imano kuba osiyodilole magumulo gito ka꞉elaomamota, mabu nale kebe duliyomolamo da꞉tomo la꞉ ebe duliyomolamo nago tolaema꞉ modoboa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ebema꞉ Yu watowatopiate ibino taneba magumulo negeliya, “Mabu keleka꞉ ebete dege a eba꞉go tolaema꞉ modoboa꞉? Me tabono magumu ma kunula꞉ka꞉, ebe a꞉ka꞉tuwa꞉ ebe bakanakapuimene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ebema꞉ Ya꞉sute ibino tabo eba wiyalo negiya, “La꞉ me opo epolata, wiyasiya na Unu Duliyomolone piyamo, na me opo lumagia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ebema꞉ nale la꞉ nanitabonomolo ma kunu analemata, la꞉ la꞉imano kuba magumulo ka꞉elaomamota, mabu na uwomua꞉ tetelo dokolinamo ebe Kawodawala. La꞉ me tanalo nanitabokobi midia꞉no, nanitabola, la꞉ bilibilinomate la꞉imano kuba osiyodilole magumulo ka꞉elaomamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ebene tabo olowiopiate ebe naniya, “A꞉ma꞉ potelela꞉ka꞉?” Wiyasiya Ya꞉sute iba꞉tamo negiya, “Wagilimi mabune nale la꞉ ma kunu analimata, na ebe Kawodawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ebema꞉ nagodolo tabo bilibilinomo epetapi ba꞉pola꞉na, nale la꞉ mabuma꞉ eba kiyawaolo la꞉imano tanalo ebo kanagilamelelaemamota. Wiyasiya numa꞉la꞉, ebe iyaiya tabote nagodone ka꞉pelamena꞉, na Alibonedawagodone pelamena. Ebe Kawodawa ebe nanitabo tanalo awokalimidawala, ebema꞉ nale iyalo tetelo ebegodone kebe iyaiya tabo kolowiyamo, na la꞉tamo ebe atu tabonomo ka꞉kiyawaonakomo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ebe tetelo iba꞉te wadenomamo kemalagidiliya꞉, Ya꞉sute Nabiwi Godokono tanaloma꞉ da꞉kiyawaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ebema꞉ Ya꞉sute iba꞉tamo walo na꞉kegiya, “La꞉ me opo epate na Epono Naniwi kewa olotolowa unamo dadipanatena꞉ema, la꞉ naimano tanalo ma kunu nanitabolo kiyatawaomamota, na ebe uwomua꞉ tetelo dokolinamo ebe Kawodawala, ega꞉walo nale kebe iyaiya tanalo kosiyodilolenamo na a꞉ka꞉tuwa꞉ naimano elawamo kosiyodilolena꞉, mabu na Alibonedawate na kebe iyaiya tabo kananiyale nale epatamo ebe atu tabonomo ka꞉kiyawaonakomo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ega꞉walo me tanalo idila. Na dapaliboniya ebe Kawodawate tete bilibilinomolo naimano osiyodilole tanaloma꞉ natamo nekalakalana, ebema꞉ ebete nago eba okolinalo na katepanena꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ebe tetelo epo epetapi bilibilinomate Ya꞉sukono tabo dolowiya, iba꞉te ebe nanitabokobi ebo midiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ebene Yu epo magumulo piyate Ya꞉suko nanitabokobi da꞉midiya, ebete iba꞉tamo negiya, “La꞉ naimano iyatulame magumulo dilukula꞉wenama, la꞉ naimano nani waloma꞉enepilata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ebene la꞉ Godokono nanitabo tanalo kiyatawaomamota, iyo, ebe nanitabo tanalote la꞉ mibomibo wiya꞉ woko magumune wagailitate tutupima꞉ ka꞉midilimamota, ega꞉walo kubadawa idino matuomeo tanalo idite la꞉godolo a꞉kitanamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ebe tetelo iba꞉te tabo eba wiyalo negeliya, “A A꞉ibalayamakono walone gudila. Ewonino tetene wagilimite me teta꞉mo pemaiga, aimano taneba magumulo lumagi idite kubadawa idino wiya꞉ wokodawama꞉ keda꞉namia꞉, ega꞉walo ale lumagi idino matuomeo tanalo kiyatawaonakoa꞉. Ebema꞉ mabu keleka꞉ a꞉ma꞉ atamo degeawa꞉, Godokono nanitabo tanalote a wiya꞉ woko magumune kowagaima꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ebene Ya꞉sute iba꞉tamo walo na꞉kegiya, “Na la꞉tamo nani tabonomo gemo, piyate kuba osiyodilole magumulo dilukuliona, ibi kubano wiya꞉ wokopima꞉ eda꞉ona. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nani gudunomote ebeno nabiwino moto epo magumulo ebeno okolina tetelo kalakalago bokolinamene, wiyasiya wiya꞉ wokodawano tanalo eba kunua꞉. Ebete ebeno woko namutudawano matuomeo magumulo bokolina, ebema꞉ tete idilo ebe namutudawate ebe ubia꞉noma꞉ deda꞉mene, ebete ebeno motone ebe gito kanalibomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ebema꞉ la꞉ nolowiala꞉. Godokono Gudute la꞉ kubadawa idino matuolamole magumune wagailitate ebeno atu alailame tutu ekakima꞉ da꞉midilitamene, ebe tetelo la꞉ nanitabonomolo tutuma꞉ keda꞉omamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ebene Ya꞉sute iba꞉tamo negiya, “Na iyatawala la꞉ A꞉ibalayamakono walone gudilata, wiyasiya la꞉ naimano iyatulame tanalo kuwata꞉wena꞉ ebema꞉ la꞉ ubila na kanakapunama꞉ema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Numa꞉la꞉, naimano Nabiwite iyalo tetelo natamo dawokalilamiya na ebe atu tanalo la꞉tamo awokalilamenakomo, ega꞉walo la꞉ atumu, la꞉imano a꞉da꞉ elemasigi nabiwite kebe tanalo kiyatulametiyala la꞉ ebe iyaiya tanalo kapiya bosiyodilolenakomata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ebene iba꞉te ebeno tabo eba wiyalo negeliya, “Aimano nabiwi ebe A꞉ibalayamatela.” Ebe tetelo ebete ibi nanaliya, “La꞉ A꞉ibalayamakono nani gudima꞉ neda꞉wenataleka꞉, ebete dosiyodilolenaki la꞉ ebe atu wadewade tanalo bosiyodilola꞉wenakona꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Numa꞉la꞉, nale Godogodone kebe iyaiya nanitabo tanalo kolowiyamo, na ebe atu tanalo la꞉tamo awokalilamenakomo. Ebema꞉ la꞉ ubila na kanakapunama꞉ema꞉, wiyasiya la꞉imano ewono nabiwi A꞉ibalayamate dopamo tuputupu lumagi iditamo dowate ebe anakapuima꞉ kowageliya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nanitabola, la꞉imano nabiwi idi bokolina, ebe kubadawate kebe tanalo kosiyodilolenakole la꞉ ebe atu kuba tanalo kosiyodilolenakomata, la꞉le wiyasiya A꞉ibalayamakono wadewade tanalo kosiyodilola꞉wena꞉!” Ebene iba꞉te ebeno tabo eba wiyalo negeliya, “A pilo gabodo kawokalaiya꞉, iyo, a nabia꞉ gudima꞉ keda꞉ona꞉. Ebema꞉ Godoko kapiya ebe aimano Nabiwila, ega꞉walo a ebeno nani gudinomola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ya꞉sute iba꞉tamo negiya, “Godote la꞉imano Nabiwinomoma꞉ neda꞉nataleka꞉, la꞉le na nilakapolo bemalagidilona꞉wenana꞉, mabu na Godogodone la꞉tamo piyamo. Iyo, na a꞉ka꞉tuwa꞉ naimano elawamo ka꞉piya꞉, na Godote paliboniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Wiyasiya la꞉le me tabono magumu wadenomamo kelawa꞉wea꞉, mabu la꞉le naimano iyatulame tanalo ubia꞉noma꞉ eda꞉onamata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Numa꞉la꞉, la꞉imano nabiwi ebe Saitanatela, ebema꞉ la꞉le ebeno gudima꞉ eba eda꞉onalo ebeno ubi tanalamo tudila꞉onakomata. Dopamo wagilimi mabune ebe tuputupu lumagi anakapumidawala, ega꞉walo ebete Godokono nanitabo tanalo ubia꞉noma꞉ eda꞉nami. Eiye, ebeno osiyodilole magumudo ebe a꞉ka꞉tuwa꞉ ebeno tanalo ma kunu awokaliminako, ebete a꞉da꞉ tabo kapiya kiyawaonako mabu ebegodolo nanitabo tanalo idi kitana꞉. Iyo, ebe a꞉da꞉ tabo kiyawaopino nabiwima꞉ eda꞉na, mabu a꞉da꞉ tabo kiyawao tanalo bilibilinomate ebegodone pemaimina! ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na wiyasiya iyaiya nanitabo tanalo kapiya kiyawaonakomo, ebema꞉ la꞉le la꞉imano a꞉da꞉ elemasigi nabiwi keba kunula꞉ka꞉ ebako epoma꞉ eba eda꞉wenalo la꞉ na nanitabokobi ka꞉midina꞉wena꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","La꞉ iyatawalata na nanitabo tanalo kiyawaodawala, ega꞉walo la꞉imano taneba magumulo lumagi idi modoboa꞉ na kuba osiyodilodawama꞉ ka꞉na꞉ima꞉. Ebema꞉ mabu keleka꞉ la꞉le na nanitabokobi ka꞉midina꞉wena꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Me tanalo nanitabola, kebe epate Godokono nani gudima꞉ deda꞉oma꞉na꞉ iba꞉te ebeno tabamo ba꞉tudila꞉onakoma꞉na꞉, wiyasiya la꞉ eba kunua꞉, ebema꞉ la꞉ ebeno tabo kolowiawenakoa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ebe tetelo Yu epo epetapiate Ya꞉sutamo negeliya, “Ale a꞉imano tanalo nanitabonomolo ma kunu awokalima꞉, a꞉ma꞉ kuba Samaliya opodawalata ega꞉walo a꞉ma꞉godolo kuba uliyanate okolina.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ya꞉sute ibino tabo eba wiyalo negiya, “Nagodolo kuba uliyanate kokolina꞉. Ao, naimano osiyodilole tanalate naimano Nabiwino mailo unamo adipatenako, wiyasiya la꞉le naimano mailo kubaiminakomata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Numa꞉la꞉, na a꞉ka꞉tuwa꞉ na kowalogonakoa꞉, mabu Kawodawa idite naimano tanalo eba anagiyamidanamelo ebete na ebo kowalogonemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ebema꞉ nale la꞉tamo nani tabonomo gemo, kebe lumagite naimano iyatulame tabamo da꞉tuduwatamene ebete a꞉e a꞉kuimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Ebe tetelo tabo olowiopiate Ya꞉sutamo walo na꞉kegeliya, “A꞉imano tabo kiyawao tanalodo a nanitabolo iyatawaoma꞉ a꞉ma꞉ kuba uliyanagonolata. Mabu A꞉ibalayamako ega꞉walo Godokono woki awokalimipi epetapi ibi bilibilinomate a꞉elaiya, wiyasiya a꞉ma꞉le negeata kebe lumagite a꞉imano tabamo da꞉tuduwatamene ebete a꞉e a꞉kuimene! A꞉ma꞉ na꞉kemalagidilawita a꞉imano elawote A꞉ibalayamakono elawo ega꞉walo Godokono wokopi epetapino elawo nodoilina? Eiye, a꞉imano amama tanalo beda꞉ kawonomola꞉ka꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ebene Ya꞉sute ibino tabo eba wiyalo negiya, “Kebe tetelo na a꞉ka꞉tuwa꞉ na nowalogotaleka꞉, ebe amama magumulo nanitabo tanalo idite a꞉kitanana꞉. Wiyasiya naimano Nabiwite na nowalogonena, nalea꞉. Ebe la꞉le nani Godoma꞉ deka꞉miawenama, ebetela. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","La꞉ ebeno tanalo nanitabolo iyatawa꞉, wiyasiya na kapiyate ebeno tanalo iyatawala. Numa꞉la꞉, nale la꞉tamo ma kunu negetaleka꞉, ‘Na ebeno tanalo iyatawa꞉,’ na a꞉da꞉ tabo begena꞉, wiyasiya na la꞉ a꞉da꞉ tabo kiyawaopi keba kunula꞉ka꞉ eba kunua꞉, ebema꞉ nale Nabiwino nanitabo tanalo iyatawala ega꞉walo nale ebeno iyaiya ubi tanalo kapiya bosiyodilolenakomo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ega꞉walo la꞉ me tanalo idi nemalagidilala꞉. La꞉imano ewono nabiwi A꞉ibalayamate ebeno tepo magumulo naimano pe tanalo demalagidilonaki kawo kalakala tanalo iyatawanaki, iyo, ebe egelate pema꞉ ebete kalakalago makopelenami.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ebe tetelo tabo olowiopiate ebe naniya, “Eiye! A꞉ma꞉ aimano ewono A꞉ibalayamako nanitabolo a꞉kuma꞉wiyala? Ebete iyalo tetenomolo a꞉iya ega꞉walo a꞉ma꞉ 50 ulama tete lumagia꞉, a꞉ma꞉ oli ape dubulata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ebene Ya꞉sute iba꞉tamo eba wiyalo negiya, “Na la꞉tamo nani tabonomo gemo, na ebe uwomua꞉ tetelo dokolinamo ebe Kawodawala. A꞉ibalayamate me opamo awokala꞉no na dopamo Godago okolinaimo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ebe tetelo iba꞉te ebe tabono tanaloma꞉ kawonomamo dowaote nokola ebo uwatiya ebe mapemete kanakapuima꞉, wiyasiya Godote ebe waminalo Amamateno Iya Moto atepate gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Egela idilo Ya꞉sute eba tonatolo balidi tamio dubu ebo numiya, ebe dubute ebeno menokono tepo magumune eba kunu pawokaliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ebene Ya꞉suko waloma꞉tapiate ebe nalatediya, “Iyatulamedawa, me dubute balidi tamiolo dapawokaliya pokono kubala꞉ka꞉? Ebenola꞉ka꞉ o ebeno menokola nabiwila ibino kubala꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ebene Ya꞉sute ibino tabo eba wiyalo negiya, “Me dubuno kuba꞉, ega꞉walo ebeno menokola nabiwila ibino kuba꞉. Me dubute ma kunu dapawokaliya, ebe mabu bitana Godote iyalo tetelo ubi iyatiya ebeno wokono kawo elawo ebegodolo kawokalima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","La꞉ nolowiala꞉, a egelano alo magumulo eba ilukulinalo, na dapaliboniya ale ebe Kawodawano woko osiyodilonama꞉, wiyasiya idoko tanalo na꞉pe, ebe tetelo lumagi idite woko a꞉kosiyodilomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nale me opolo eba okolinalo na me opono aloma꞉ eda꞉namo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ebe tetelo Ya꞉sute ebe tabo kiyawaote, ebete kowe damelamo meamidate ebe kowa꞉mo kobokobo osiyodilote dubuno balida꞉mo abutilamelemete ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ebe naniya, “A꞉ma꞉ Silomo mailagono mala꞉ ikila꞉ baiamo toawete mala꞉ ebo na꞉neta.” Silomo mailono magumu ebe nitana ‘Alibo Tanalola.’ Ebene ebe dubute ebe mala꞉ ikila꞉ bailo mala꞉ da꞉netiya, ebeno balidite na꞉melete ebete opo uma꞉go walo ebo ka꞉piya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ebe tetelo ebe niyakabolo dilukulinamiya ega꞉walo piyate dopamo ebe manima꞉ towetoweolo duminakiya, iba꞉te ebe umite ebo geliya, “Me dubu gabo balalo okolite manima꞉ da꞉toweolamitanaki, me ebe dubula꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Epetapiate ibino tabo eba wiyalo negeliya, “Iyo, ebe ebetela,” wiyasiya epetapiate negeliya, “Ao, ebe ebetea꞉, ebeno ololo keba kunula꞉ka꞉ ebako lumagi idila.” Wiyasiya ebe dubute a꞉ka꞉tuwa꞉ ebeno tanalo eba awokalimilo negiya, “Na ebe ebe dubula.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ebene iba꞉te ebe naniya, “A꞉imano balidi wadekobi keba kunu kolowiometa?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ebete ibino tabo eba wiyalo negiya, “Dubu idi ebeno mailo Ya꞉sutela, ebete kowe damelamo meamidate ebe kowa꞉mo kobokobo osiyodilote naimano balida꞉mo ebo alomo. Ebene ebete na nanane Silomo mala꞉ ikila꞉ bailo mala꞉ ka꞉netama꞉. Nale eba kunu da꞉nosiyodilomo, na balidi ebo melemo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ebene iba꞉te ebe walo nakaniya, “A꞉ma꞉ wadekobi da꞉midita, ebe dubu keleka꞉?” Ebete negiya, “Na iyatawa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Ya꞉sute balidi tamio dubu wadekobi ka꞉midima꞉, ebete kebe egelalo kobokobo osiyodilote ebeno balida꞉mo dalomomiya, ebe egela Yu epono wokoa꞉ talena egelala. Ebema꞉ epetapiate ebe wade walubi tanalo kanawokalima꞉, iba꞉te ebe dubu lawete Pa꞉lisi tanebapiatamo gito magatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ebe tetelo Pa꞉lisi tanebapiate talena egelano tanalo eba malagidilolo ebe naniya, “A꞉imano balidi wadekobi kebako gabodo kolowiometa?” Ebete ibino tabo eba wiyalo negiya, “Dubu idite naimano balida꞉mo kobokobo abutilamelenamete, nale mala꞉ da꞉netamo na balidi ebo melemo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ebe tetelo Pa꞉lisi tanebapi epetapiate negeliya, “Me dubute wokoa꞉ talena egelano pukala adikamidale, ebema꞉ ebe Godokono alibodawanomoa꞉.” Wiyasiya epetapiate negeliya, “Ao, ebe wade lumagila. Kubadawagodolo Godokono elawo kitana꞉ mako anoano tanalo osiyodilolema꞉.” Ebema꞉ ibi magumulo anagiyamida tanalote gito maigiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ebe tetelo iba꞉te ebe dubu walo nakaniya, “A꞉imano balidi wadekobi da꞉midilimita, ebe dubu a꞉ma꞉le poma꞉ kegeawita?” Ebete nowamiya, “Nale ebe Godokono woki awokalimidawa idima꞉ gitamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ebe tetelo ebe dubute menokono tepone balidi tamiolo dapawokaliya ega꞉walo ebeno balidite ka꞉lo wadekobi dolowiome, Yu watowatopiate ebe tanalo netewa nanitabokobi ka꞉midiliya꞉. Ebema꞉ iba꞉te ebe dubuno menokola nabiwila iba꞉tamo tabo gito alibiya iba꞉te ka꞉pema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Iba꞉te da꞉piya Yu watowatopiate iba꞉godone ibino guduno nanitabo tanalo lawete ibi nanaliya, “La꞉ egelamata me dubu la꞉imano gudula, ega꞉walo la꞉ egelamata ebe menokono tepone balidi tamiolo pawokaliya. Ebema꞉ la꞉ me tanalo atamo nawokalima꞉la꞉, ebeno balidite wadekobi kebako gabodo kolowiomele?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ebene ebeno menokola nabiwila iba꞉te ibino tabo eba wiyalo negeliya, “Nanitabola, ebe aimano gudula, ega꞉walo a iyatawala ebe menokono tepone balidi tamiolo pawokaliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Wiyasiya a iyatawa꞉ ebeno balidite wadekobi kebako gabodo kolowiomele ega꞉walo ebeno balidi potele wadekobi ka꞉midilimile. Ebe dubu kawola. Modobola la꞉ ebe nanala꞉, nanitabo tanalo ebete la꞉ ka꞉kiyawaolaema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ebe dubuno menokola nabiwila iba꞉te tabo ma kunu degeliya mabu iba꞉te Yu watowatopi tolelamiya. Watowatopiate iyalo egeliya, kebe lumagite Ya꞉suko Godokono Alibodawa Kelisoma꞉ degemene, iba꞉te ebetamo talena kiyatima꞉na꞉ ebete balidi ibilamole moto guamo epo epetapiago ka꞉podoloma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ebe mabuma꞉ ebe dubuno menokola nabiwila iba꞉te negeliya, “Aimano gudu ebe dubu kawola, modobola la꞉ ebe nanala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ebene Yu watowatopiate dopamo balidi tamiolo dokolinami, ebe dubu iba꞉tamo walo keka꞉mite ebe nakaniya, “A꞉ma꞉ Godokono ololo apulo eba utitalo nanitabo tanalo atamo nawokalima꞉, me dubu Ya꞉sute a꞉ma꞉tamo beda꞉ tanalo kosiyodilole? A iyatawala ebe iyaiya kuba osiyodiloledawala.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ebe tetelo ebete tabo eba wiyalo negiya, “Na iyatawa꞉, ebe da꞉ wade lumagila꞉ o da꞉ kuba lumagila꞉. Wiyasiya na kapiya tanalo iyatawitamo, na dopamo balidi tamiodawala, ka꞉lo na balidi a꞉melemo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ebene Yu watowatopiate ebe walo nakaniya, “Ebete a꞉ma꞉tamo beda꞉ tanalo osiyodilote a꞉imano balidi wadekobi ebo kolowiometa?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ebete negiya, “Na nani tabo la꞉ iyalo analemata, wiyasiya diyala, la꞉ wadenomamo kolowiawea꞉. Ebema꞉ la꞉ beda꞉ mabuma꞉ olowima꞉ walo da꞉kowagela꞉witama? La꞉ ebeno waloma꞉tapi epetapima꞉ eda꞉oma꞉la꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ebene iba꞉te wiyasiya ebe malogolo kawiya eba analo negeliya, “A꞉ma꞉ ebeno waloma꞉tadawa idilata, aa꞉! A Mosesekono waloma꞉tapila! ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mabu a iyatawala Godote Mosesedo tabo a꞉kiyawaonaki, wiyasiya me dubuno nanitabo tanalo a iyatawa꞉. Ebe kuba daleya duliyomolo idilo ega꞉walo pilo gabodo da꞉ awokaliyale!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ebene ebe dubute tabo eba wiyalo negiya, “Me beda꞉ kuba tanalola꞉ka꞉? Me dubute naimano balidi anoano gabodo wadekobi midiliname, wiyasiya la꞉ watowatopi iyatawa꞉ ebete kebene ka꞉piyale! ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","A bilibilinomo iyatawala Godote kuba osiyodilolepino tabo kolowinakoa꞉, wiyasiya kebe lumagite ebe Kawodawama꞉ gelo ebetamo da꞉tuduwatamene, Godote ebe lumagino tabo kolowimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Opo wagilimi mabune me teta꞉mo pemaiga idawate balidi tamio lumagi wadekobi da꞉midiya, a opo epate ebe anoano tanalo kuminakia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ebema꞉ naimano woki ma kunu itana, me dubu Godogodone pea꞉notaleka꞉, ebete epo kowalubilima꞉ wade tanalo idi osiyodiloma꞉ a꞉ka꞉modobona꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ebe tetelo Yu watowatopiate ebeno tabo eba wiyalo negeliya, “Eiye! A꞉ma꞉ menokono kuba osiyodilo tanalodo awokaliyata! Mabu keleka꞉ a꞉ma꞉ a iyatuaema꞉ dowagela꞉wita?” Ebene iba꞉te kawo dowago ebe dubutamo balidi ibilamole moto guamo popega talena iyatimite gito alibiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ebene Yu watowatopiate ebe dubu dowago dalibiya, Ya꞉sute ebe tanalo olowite ebe wadiago da꞉piya, ebete ebe dubu pumite ebe napaniya, “A꞉ma꞉ Epono Naniwi nanitabokobi na꞉ka꞉mida꞉wita?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ebene ebete nowamiya, “Kawodawa, Epono Naniwi potelela꞉ka꞉? A꞉ma꞉le na diyatunama꞉emene, nale ebe nanitabokobi ebo ka꞉midimamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ebene Ya꞉sute ebetamo negiya, “A꞉ma꞉le ebe numitata, mabu ka꞉lo a꞉ma꞉go ebete kiyawauta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ebe dubute negiya, “Nanitabola, Kawodawa, na ka꞉lo a꞉ma꞉ nanitabokobi na꞉midimata,” ebene ebete pupamo okolite Ya꞉suko ebo amamatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ebene Ya꞉sute negiya, “Na me opo epono iyaiya tanalo anagilamelelaema꞉ piyamo. Ebema꞉ piyate balidi tamiolo dilukuliona, na ibino balidi kepalamililaemamo iba꞉te tanalo bilibilinomo wadenomamo kulaema꞉, ega꞉walo piyate a꞉ka꞉tuwa꞉ ibino amama magumulo degelana, ‘A balidi na꞉meleonama꞉,’ nale ibino balidi wiyasiya idokoma꞉ ka꞉midililaemamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ebe tetelo Pa꞉lisi tanebapi epetapiate Ya꞉suko niyakabolo delamota꞉oniya, iba꞉te ebeno tabo olowite negeliya, “A꞉ma꞉ na꞉kegeawita, a atumu balidi tamiopila?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ebene Ya꞉sute iba꞉tamo negiya, “La꞉ Godokono tabono iyaiya tanalo iyatawaoa꞉noma꞉ neda꞉wetaleka꞉, ebete la꞉ balidi tamiopinomoma꞉ ka꞉la꞉mia꞉no la꞉imano kuba osiyodilole mabuma꞉ wiya ikalaema꞉ a꞉kegena꞉. Wiyasiya la꞉ negelanamata, ‘A Godokono tabono tanalo bilibilinomo modobolo ulamenama꞉,’ ebema꞉ la꞉imano kuba wiyate nanitabonomolo na꞉pe.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ebene Ya꞉sute walo na꞉kegiya, “Na la꞉tamo nani tabonomo gemo, kebe lumagite sipi-goeogoeono kala magumamo gigiyudo popega꞉no wiyasiya balado da꞉popegamene, ebe pilo lumagila ega꞉walo ebe epetapino inamabu elawamo uwatelamedawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wiyasiya kebe lumagite gigiyunomodo da꞉popegamene, ebe sipi-goeogoeono nani ulamedawanomola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ebe ulamedawate duiyanomolo kala magumune toma꞉ dowagelemene, gigiyu umidawate gigiyu ebetamo ka꞉iyamidaemene. Ebene ebete ebeno sipi-goeogoeonomo ibino mailamo deka꞉la꞉imene, iba꞉te ebeno tabo madodo olowite, ebete kala magumune ibi ebo ka꞉powaulatelemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ebete ebeno sipi-goeogoeo bilibilinomo powaulatelete, ibi dopolamete eba tonatolo iba꞉te ebe ebo kowaloma꞉tama꞉na꞉ mabu ibi iyatawala ibi ulamedawano tabo madodo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wiyasiya sipi-goeogoeate iya lumagi idi a꞉kowaloma꞉tama꞉na꞉. Ebako lumagite ibi deka꞉la꞉imene, iba꞉te ebe atepate iyabaiamo gito kalautioma꞉na꞉ mabu iba꞉te ebeno tabo madodo iyatawa꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ya꞉sute me iyatulame oiamo epo diyatulamiya, iba꞉te ebeno magumu wadenomamo kelawiya꞉, nipo malagidiliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ebema꞉ Ya꞉sute iba꞉tamo walo na꞉kegiya, “Na la꞉tamo nani tabonomo gemo, na ebe sipi-goeogoeono kala gigiyula. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na pea꞉no piyate dopamo da꞉pelamenakiya, ibi bilibilinomo pilo dubula ega꞉walo epetapino inamabu elawamo uwatelamepila, wiyasiya sipi-goeogoeate ibino tabo kolowionakia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","“Na ebe gigiyula. Kebe lumagite na magumudo da꞉popegamene ebete igilo mula꞉ tanalo nanitabolo ka꞉pelaemene. Iyo, ebako sipi-goeote adimo apuamo naimano kala magumamo ka꞉popega, duiya tetelo wade uwago nalema꞉ ka꞉to, ebete eba kunu eba wagelenalo nao inamabu modobolo bulamenakomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Numa꞉la꞉, pilo lumagi ega꞉walo na, aimano tanalo iyaiyala. Ebete sipi-goeogoeo pilolo uwate o alukole woki kapiyado ka꞉pemene ibi ka꞉pa꞉kubailaema꞉. Wiyasiya nale na꞉piyamo uwomua꞉ igilonomo iba꞉tamo eba ikalamelo iba꞉te uwomua꞉ tetelo kekalakalaonama꞉, ebema꞉ ebe igilo tanalote ibi magumulo tabokanomoma꞉ eba eda꞉lo lumagite modobutima꞉ modoboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ebema꞉ na ebe Wade Sipi-goeogoeo Ulamedawala. Naimano kalakala bitana, nale naimano igilo iyabaiamo eba iyatilo ibino igilo ka꞉mula꞉lelaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","“Wiyasiya kebe lumagite sipi-goeogoeo ulame woko wiyamo dosiyodilona, ebe ibi ulamedawanomoa꞉. Kebe tetelo ebete elawo gaa penapelo duimene, ebe a꞉ka꞉tuwa꞉ ebeno igilo eba mula꞉lo sipi-goeogoeo miyapate iyabaiamo gito kalaula꞉mene, ebene elawo gaate ibi epetapi eba palukolelo, epetapi iyaiya gito kalautioma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iyo, mako dubute sipi-goeogoeatamo olalati tanalote pelo duimene, ebete samamo kalaula꞉mene, mabu ebeno woko wiya ega꞉walo ebeno igilo ebe tanalo kapiya malagidilolena, sipi-goeogoeono tanalo nanitabolo kemalagidilolena꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ebene Ya꞉sute walo na꞉kegiya, “Na ebe Wade Sipi-goeogoeo Ulamedawala. “Nale naimano sipi-goeogoeono tanalo iyatawala, ega꞉walo ibi atumu naimano tanalo iyatawala, Nabiwi Godote naimano tanalo keba kunu kiyatawanale ega꞉walo nale ebeno tanalo atumu keba kunu kiyatawanamo eba kunu. Ebe mabuma꞉ naimano kalakala bitana, nale naimano igilo iyabaiamo eba iyatilo ibino igilo ka꞉mula꞉lelaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ega꞉walo naimano sipi-goeogoeo epetapi ba꞉pola꞉na, wiyasiya me tetelo iba꞉te me kala magumulo kilukuliona꞉. Wiyasiya nanitabola, iba꞉te naimano tabo dolowima꞉na꞉, nale ibi ebo kemagaelemamo iba꞉te me dopo sipi-goeogoeago kapimiya kilukulionama꞉, ebene ibi bilibilinomate kapiya kalalo aladabutite na ibino kapiya ulamedawate ibi wadenomamo ba꞉buiyalatelenamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Numa꞉la꞉, naimano kalakala bitana naimano igilo iyabaiamo iyatima꞉, ebema꞉ Nabiwite nilakapolo na nemalagidilonena. Ega꞉walo me tanalo idila, nale naimano igilo iyabaiamo diyatimo, nale nanitabolo walo ka꞉kelaemamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Lumagi idite naimano igilo nagodone a꞉kelaemene. Ao, na a꞉ka꞉tuwa꞉ naimano igilo iyabaiamo kiyatimamo mabu me tanalo ebe naimano tanalola, ega꞉walo na a꞉ka꞉tuwa꞉ walo ka꞉kelaemamo mabu elawo nagodolo bitana. Naimano Nabiwite na iyalo ananiya me tanalo kosiyodiloma꞉, ebema꞉ nale nanitabonomolo kosiyodilomamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ebe tetelo Ya꞉sute da꞉kiyawaiya ebe tabono tanaloma꞉ olowiopiate ibi a꞉ka꞉tuwa꞉ ibino taneba magumulo woki kapiyama꞉ ka꞉midiliya꞉, iba꞉te tulituliya gito kagaliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ibi epetapiate negeliya, “Me dubuno tabo la꞉le beda꞉ma꞉ kolowiawitama? Ebe kuba uliyanagonola, ebema꞉ ebe nedaedalita!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Epetapiate ibino tabo eba wiyalo negeliya, “Ao, kuba uliyanate daedalekobi da꞉midi, ebako lumagite Godokono iyatulame tabo wadenomamo kiyawaoma꞉ modoboa꞉, wiyasiya me dubuno iyaiya tabono tanalo wadewadenonomola. Ega꞉walo kuba uliyanagodawate modoboa꞉ balidi tamiodawano balidi wadekobi midilima꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ulama uwomu tetelo giba tanalote Yu epono opolo eba itanalo, ebe tetelo iba꞉te Yelusalema kawo duliyomololo Godoko Amamate Moto A꞉iyamida Soliyomu osiyodilutiya mabu ibino tanalo eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ebe tetelo Godoko Amamateno Motolo tanatimi idi nitanami, epate ebe tanatimi Solomonokono mailamo ka꞉minakiya. Ebene Ya꞉sute ebe tanatimilo eba nepata꞉lo, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","epo epetapiate pelamete ebe pa꞉wa꞉midadigalo ebetamo na꞉pegeliya, “A꞉imano nanitabo tanalo tete geyageyanomolo atamo kawokalima꞉wena꞉. Ebema꞉ modobola a꞉ma꞉ a niyatuama꞉, a꞉ma꞉ ebe Godokono Alibodawa Kelisotela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ya꞉sute ibino tabo eba wiyalo negiya, “Nale me tanaloma꞉ la꞉ dopamo analimata wiyasiya la꞉le na nanitabokobi ka꞉midina꞉wea꞉. Ega꞉walo nale kebe anoano tanalo naimano Nabiwino elawamo kosiyodilolenakomo, ebe tanalate naimano tanalo ebe awokalimina, na ebetela. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Wiyasiya nanitabola, la꞉le ebe iyaiya tanalo dulama꞉wenakoma na nanitabokobi ka꞉midina꞉wena꞉, mabu la꞉ naimano sipi-goeogoeonomoa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Naimano sipi-goeogoeate naimano tabo madodo olowinaka, ebene na ibino tanalo iyatawala ega꞉walo iba꞉te na nowaloma꞉enena. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ebema꞉ nale iba꞉tamo uwomua꞉ igilo dikalaemo iba꞉te a꞉ka꞉elaoma꞉na꞉, iyo, nale ibi kodakodalo eba uwatelo pilodawate naimano koto magumune idi kapiya a꞉kelaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nanitabola, naimano Nabiwite ibi bilibilinomo natamo iyalo ikanamoniya. Ebeno elawo kawonomola, idawano elawote ebeno elawo kodolina꞉, ebema꞉ ebe atumu ebe sipi-goeogoeo kodakodalo eba uwatelo pilodawate ebeno koto magumune idi kapiya laema꞉ modoboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nabiwi Godoko ega꞉walo na, a kapiyanomola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ebe tetelo epate me tabo dolowiya, iba꞉te nokola gito uwatiya Ya꞉suko mapemete ebe ebo kanakapuima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Wiyasiya Ya꞉sute iba꞉tamo negiya, “Naimano Nabiwite natamo dikanamoniya, nale ebe wadewade tanalo bilibilinomo la꞉imano ololo apulo osiyodilolenakomo. Ebema꞉ ebe wadewade osiyodilole tanalo magumulo la꞉le natamo beda꞉ tanaloma꞉ ka꞉dowawitama? Mabu keleka꞉ la꞉le na mapenaema꞉ dowagela꞉witama?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Iba꞉te nowaimiya, “Ale a꞉imano wade osiyodilo tanalo idi mabuma꞉ a꞉ma꞉ mapema꞉ kowagelita꞉. Ao, mabu bitana, a꞉ma꞉ me opo dawama꞉ eba eda꞉nalo wiyasiya a꞉ma꞉le negeata, a꞉ma꞉ ega꞉walo Godoko, la꞉ kapiyala! Godokono ololo apulo mako tabo kubanomola!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ya꞉sute ibino tabo eba wiyalo negiya, “Nale degemo ebe tabo kuba꞉. Ebema꞉ la꞉ me tanalo wadenomamo nemalagidilala꞉, Godote la꞉imano ewoniatamo dikalamiya ebe Totomu Bukalo ebeno tabote ma kunu itana, ‘La꞉ bilibilinomo Godoko keba kunula꞉ka꞉ ebako epoma꞉ eda꞉onamata.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Numa꞉la꞉, Godote ebeno Bukalo dawokalimina ebe nanitabo tanalono elawote uwomua꞉ tetelo bitanamene. Ebene ewonino tetelo Godokono Buka apuno tabote ibi Godoko keba kunula꞉ka꞉ ebako epoma꞉ ka꞉la꞉miya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","wiyasiya la꞉imano tetelo Godote na talenama꞉ midinite me opamo ebo paliboniya. Ebema꞉ na a꞉ka꞉tuwa꞉ na Godokono Guduma꞉ degemo, nale kuba tabo kegea꞉. Mabu keleka꞉ la꞉le kubama꞉ degelaema? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Ega꞉walo me tanalo idila, Godote natamo kebe wadewade tanalo osiyodilolema꞉ kikanamonenale, nale ebe tanalo osiyodilolea꞉no modobola la꞉ na nanitabokobi akomidina꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wiyasiya nale ebe wadewade tanalo la꞉ magumulo nanitabolo osiyodilolenakomo, ebema꞉ modobola la꞉ ebe tanalo eba ulamenalo naimano nanitabo tanalo ebo niyatawaonala꞉. Iyo, naimano wade osiyodilole tanalate naimano tanalo ebe awokalimina ma kunu, na ega꞉walo naimano Nabiwi, a kapiyanomola. Wiyasiya la꞉ ubia꞉nola me tanalo nanitabokobi midima꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ebe tetelo ibi ubila Ya꞉suko idoko motamo ebo kiyatima꞉, wiyasiya ebete ibi magumune iyabaiamo gito tiya iba꞉te ebe lawekapoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ebene ebete walo ka꞉tote Yodane Kolomo apuamo ka꞉na꞉iwate, Yonete dopamo epo obamo dowaduba꞉midaolenaki ebolo eba nokolitalo ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","epo bilibilinomate ebetamo ebo pelamoliya. Ebe tetelo iba꞉te negeliya, “Yonete Godokono elawamo iyaiya anoano tanalo kosiyodilolenakia꞉, wiyasiya me dubu Ya꞉sute dosiyodilolena ebe anoano tanalo kawokawonomola! Yonete ebeno tanaloma꞉ kebe tabo ka꞉kiyawaile, ebe tabono tanalo bilibilinomo nanitabonomola!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ebema꞉ ibi magumulo epo epetapi bilibilinomate Ya꞉suko nanitabokobi ebo midiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tete idilo Betani duliyomolono dubu idi, ebeno mailo Lasalesitela, ebe kawo gabugabute umiti. Me Betani duliyomolo ebe atu alailame kamiyale netewa Ma꞉liko ega꞉walo Matako, iba꞉te kebolo kokolionami ebe duliyomolola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Me kamiyale Ma꞉lite tete idilo Kawodawa Ya꞉sukono agowamo wade nibo inamabu adipanamete ebeno eka꞉mo a꞉la꞉li diya꞉da꞉olemiya ebe dawala, ega꞉walo gabugabute dumiti me dubu Lasalesiko ebe ebeno ekawila. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ebene ebe tetelo Ma꞉liko ega꞉walo Matako iba꞉te lumagi idi gito alibiya Ya꞉suko ma kunu kananama꞉, “Kawodawa, a꞉ma꞉le kawonomamo demalagidilawena, ebe lumagi kawo gabugabute umina.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ya꞉sute me tabo olowite ebeno waloma꞉tapiatamo negiya, “Me gabugabute Lasalesikono a꞉e uwomuma꞉ a꞉keda꞉mene. Gabugabute ebe dumina ebeno mabu ma kunula, Godoko ubila me tanalodo ebeno mailo ega꞉walo ebeno Guduno mailo kawokobi ka꞉midilima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nanitabola, Ma꞉liko, Matako, ega꞉walo Lasalesiko ebe Ya꞉sukono wade namutupila, ebete ibi kawonomamo nemalagidilolenami. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Wiyasiya Ya꞉sute Lasalesikono gabugabu tanalo dolowiya, ebete ebe ka꞉nowalubima꞉ Yudiya opono Betani duliyomolamo samonomamo ka꞉nemaigiya꞉, ebete kebe duliyomololo kokolinamile ebe duliyomololo netewa egela walo ebo kokoliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ebene Ya꞉sute ebe waloma꞉tapi nanaliya, “Modobola a Yudiya opamo walo ka꞉ka꞉tolamiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Iba꞉te ebeno tabo eba wiyalo negeliya, “Iyatulamedawa, ale ebe opone mamo a꞉pelaima꞉ mabu ebe epate a꞉ma꞉ nokolamo mapema꞉ wagelitiya. Ibi ubila a꞉ma꞉ kanakapumitama꞉, ebema꞉ mabu keleka꞉ a꞉ma꞉ ebamo walo samamo ka꞉ka꞉toaema꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ya꞉sute ibino tabo eba wiyalo negiya, “Kapiya egela magumulo modobo alote itananako, a, nanitabola꞉ka꞉? Ebene lumagite egelano alo magumulo depaitamene, ebete damela gugamo a꞉ka꞉negamene mabu me opono alonomo ebete numita. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wiyasiya ebete idoko tetelo depata꞉mene agowa ukamida tanalo kiyatawamene, mabu ebegodolo alo puliyala ebeno to gabo wadenomamo kuima꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ebe tetelo Ya꞉sute tabo eba moga꞉melo negiya, “Aimano namutudawa Lasalesiko u ebe watita, wiyasiya nale ebetamo tote ebe kanamutiyamamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ebene Ya꞉suko waloma꞉tapiate ebetamo negeliya, “Kawodawa, ebete u dowatita, wadenomola! Gabugabute ebegodone nolopoliguta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ya꞉suko waloma꞉tapiate ma kunu geliya, mabu ebete iba꞉tamo u wata tabo degiya ebe Lasalesikono a꞉e tanaloma꞉ giya, wiyasiya iba꞉te ebe tabono magumu kelawiya꞉, ebema꞉ iba꞉te u wata tanalonomoma꞉ negemu malagidiliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Ebene Ya꞉sute ebeno tabono magumu awokalimilo ma kunu giya, “La꞉ nolowiala꞉, ditidi nale Lasalesiago luta꞉no ebete a꞉enomo ebo a꞉i. Wiyasiya nale ebe mabuma꞉ tepo magumulo mibomibo kiyatawita꞉. La꞉ mabuma꞉ naimano kalakala bitana, mabu tete tatalila ebeno a꞉e tanalodo la꞉le naimano kawo elawo uma꞉wete na nanitabokobi ebo ka꞉midinimamota. Ebema꞉ modobola a ebetamo ka꞉tolamiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ebe tetelo Tomasiko, ebeno mailo idi Nedewale Gudula, ebete waloma꞉tapi epetapiatamo negiya, “Kuba꞉nola, a bilibilinomate Iyatulamedawago ebamo tolamete eba꞉go ka꞉na꞉elaiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ebene Ya꞉sute Betani duliyomolamo da꞉nemaigiya, ebete Lasalesikono tanalo ma kunu nolowiya, ebete da꞉i netewa-netewa egela bobo magumulo kapitani. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ebe Betani duliyomolo Yelusalema kawo duliyomolo tatalinomolo itana, ebe kawo duliyomolamo tolame gabono tete ebe netewa-kapiya kilomita keba kunula꞉ka꞉ eba kunula. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ebema꞉ Yu epo bilibilinomo epetapiate Lasalesikono a꞉e tabo olowite, iba꞉te kawo duliyomolone a꞉pelamoliya ebeno nanikubi Ma꞉liko ega꞉walo Matako ibi ka꞉pegelebadilaema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ebene ebe tetelo Matate Ya꞉sukono pe tanalo olowite eba꞉go alugoma꞉ gito tiya, wiyasiya Ma꞉liko ka꞉tiya꞉, ebete motolo luti. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matate Ya꞉suago nalugote ebete ebe nananiya, “Kawodawa, a꞉ma꞉ malo nokoliawitataleka꞉ naimano ekawite a꞉ka꞉ena꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Wiyasiya na iyatawala, ka꞉lo a꞉ma꞉le Godoko beda꞉ tanaloma꞉ danaemene, ebete a꞉ma꞉tamo nanitabolo kikaema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ebene Ya꞉sute ebe naniya, “A꞉imano ekawite a꞉e magumune walo ka꞉kemaigamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Matate ebeno tabo eba wiyalo negiya, “Iyo, na iyatawala Godote Uwomu Egelalo nanitabokobi midipi bilibilinomo igilamo ka꞉kowadipalatelemene, Lasalesiko ebana.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ebene Ya꞉sute ebetamo negiya, “Na ebe a꞉e magumune maiga tanalono elawo mabula, ega꞉walo na uwomua꞉ igilola, ebema꞉ kebe lumagite na nanitabokobi da꞉midinimene, a꞉e magumudo ebete uwomua꞉ igilo ka꞉nelaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nanitabola, kebe lumagite nagodolo eba okolinalo na nanitabokobi da꞉midinimene, ebete a꞉ka꞉emene. A꞉ma꞉ me tanalo nanitabokobi na꞉ka꞉mida꞉wita?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Matate ebeno tabo eba wiyalo negiya, “Iyo, Kawodawa! Nale a꞉ma꞉ nanitabokobi na꞉miditamata, a꞉ma꞉ ebe Kelisote, Godokono Gudulata. Ebete iyalo tetelo me opamo ka꞉pema꞉ degiya, a꞉ma꞉ ebe lumagilata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ebene Matate me tabo kiyawaote, ebete motamo walo ka꞉tote ebeno naniko Ma꞉litamo tabo diya gabodo ma kunu negiya, “Iyatulamedawa a꞉pe, ebe a꞉ma꞉ uima꞉ ubi iyatita.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ebema꞉ Ma꞉lite me tabo dolowiya ebete samonomamo maigate Ya꞉suago alugoma꞉ gito tiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ebe tetelo Ya꞉sute Betani duliyomolo tatalilo ela ebe amiti, Matate dopamo eba꞉go kebolo kanalugiyale ebe atu bailo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ebene Ma꞉lite motone samonomamo da꞉nemaigiya, ebe tetelo epetapiate ebe gelebadimima꞉ da꞉pelamiya, ebe epate atumu motone ka꞉nemaimiote ebe ebo waloma꞉tiya, mabu iba꞉te nemalagidiliya Ma꞉lite Lasalesikono bobamo iima꞉ to. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wiyasiya Ma꞉lite bobamo ka꞉tiya꞉, Ya꞉sute kebolo ka꞉lutiyale ebamo tiya. Ebete ebe numite ebeno agowa mabuamo eba negalo negiya, “Kawodawa, a꞉ma꞉ malo nokoliawitataleka꞉ naimano ekawi a꞉ka꞉ena꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ebe tetelo Ya꞉sute Ma꞉liko ega꞉walo piyate eba꞉go da꞉pelamiya ibi bilibilinomono iimi tanalo umite ebeno tepo magumulo ibi kawonomamo malagidilolete ebe atumu iima꞉ kowageliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ebene ebete ibi nanaliya, “La꞉le ebe bobamo kebe teta꞉mo kiyata꞉ima?” Iba꞉te ebeno tabo eba wiyalo negeliya, “Kawodawa, a꞉ma꞉ ago pa꞉wete ebeno bobo bai na꞉puma꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ebe tetenomolo Ya꞉sute ebo iiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ebene epate ebeno ii tanalo olowite negeliya, “Numa꞉la꞉, ebeno namutudawa malagidilo tanalo kawonomola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wiyasiya epetapiate negeliya, “Me dubute balidi tamio dubu wadekobi a꞉midi, a, nanitabola꞉ka꞉? Ebete samamo na꞉petaleka꞉, ebeno namutudawate a꞉ka꞉ena꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ebe tetelo Ya꞉sute ebeno tepo magumulo iima꞉ walo eba kowagelelo bobamo ebo tiya, ebe bobote damela maboele tetelo eba itanalo, epate Lasalesikono ape iyatite bobono gigiyu kawo nokolamo ebo mopiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ebene Ya꞉sute ebolo da꞉pola꞉niya ebe dubu epetapi nanaliya, “La꞉ gigiyuno nokola iyabaiamo na꞉mupiamidala꞉.” Ebe tetelo wiyasiya a꞉e lumagino naniko Matate negiya, “Kawodawa, iyaiya! Ka꞉lo ebeno apete netewa-netewa egela tetelo itana, ebema꞉ ebeno abale nibote kubanomamo kemaigamene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ebene Ya꞉sute ebeno tabo eba wiyalo negiya, “Nale a꞉ma꞉ dopamo ma kunu anamata, a꞉ma꞉ Godoko nanitabokobi da꞉mida꞉emene ebeno elawo kawonomo kuima꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ebene dubu epetapiate bobo gigiyuno nokola iyabaiamo mupiamidate, Ya꞉sute Godokono Unu Duliyomolamo melelo negiya, “Aba, na a꞉ma꞉tamo kalakala tabo gemo, mabu a꞉ma꞉ naimano towetowe tabo olowinakota. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iyo, na iyatawala a꞉ma꞉ tete bilibilinomolo naimano tabo olowionakota, wiyasiya nale me tabo me epono ololo apulo gemo, iba꞉te naimano nanitabo tanalo ma kunu kiyatawaoma꞉, a꞉ma꞉le me opamo na apaliboniyata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ebene Ya꞉sute me kalakala tabo Godotamo kiyawaote, ebete ebeno tabo madodo unamo adipatete kawiya negiya, “Lasalesi, a꞉ma꞉ bobo magumune na꞉pemaiga!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ebe tetelo a꞉e dubute Ya꞉sukono tabo dolowiya, ebete bobo magumune ebo pemaigiya, wiyasiya ebeno agowala kotola, ega꞉walo wato kalikamo aupulatolemela, Yu epate ibino a꞉elao epo kalikamo keba kunu kaupulatolenake eba kunu. Ebene Ya꞉sute epo nanaliya, “Modobola la꞉le ebe eba walubilo ebeno apene kaliku nepalamiolema꞉la꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ebe tetelo piyate Ma꞉liko gelebadimima꞉ da꞉pelamiya, Ya꞉sute Lasalesitamo beda꞉ tanalo kosiyodiliyale, iba꞉te ebe anoano tanalo umite epetapi bilibilinomate nanitabokobi ebo midiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","wiyasiya epetapiate nanitabokobi midia꞉no Pa꞉lisi tanebapiatamo tolamete ibi gito nanaliya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ebe mabuma꞉ Pa꞉lisi tanebapi ega꞉walo Godotamo kalimagono ikameopino watowatopi, iba꞉te Ka꞉nisolo dubu epetapi ebo ka꞉la꞉miya iba꞉go tabo kapimiya kegelama꞉. Ebene iba꞉te tabo ma kunu geliya, “Me dubute anoano tanalo bilibilinomo osiyodilolena, ebema꞉ a beda꞉ tanalo na꞉kosiyodiloma꞉ ebe odiyoboma꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kebe tetelo ale tanalo idi osiyodiloa꞉no gito duma꞉tepama꞉, epo bilibilinomate ebe nanitabokobi midite Kawo Elawodubuma꞉ kegelama꞉na꞉. Ebe tetelo Loma epono gowelaopiate pelamete aimano Godoko Amamateno Moto ega꞉walo aimano opo kawonomo ka꞉pa꞉kubailaema꞉na꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ebe tetelo dubu idi ebeno mailo Kayapasitela, ebete ebe ulamalo Godotamo kalimagono ikameopino Unu Watodawanomoma꞉ eda꞉nami, ebene ebete Ka꞉nisolo dubu epetapiatamo negiya, “Eiye, la꞉ daedalepima꞉ akoeda꞉oala꞉! Mabu keleka꞉ la꞉le me dubutamo osiyodiloma꞉ nanitabo gabo kuma꞉wita꞉? Ale ebe gito kanakapuimalema꞉! ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Iyo, modobola epo bilibilinomono taneba magumulo kapiyadawanomote na꞉emene epetapi mabuma꞉, ebema꞉ aimano opote a꞉ka꞉kubamene, a, nanitabola꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ebe tetelo Kayapasite Ya꞉sutamo dowalo ma kunu malagidiliya, me tabo ebe a꞉ka꞉tuwa꞉ ebeno mulo wokiamo kiyawao. Wiyasiya nanitabo tanalote ma kunu itani, Godote me tabo ebe magumudo kiyawauti, mabu ebe ulamalo ebete Kayapasitamo gobebobo ikamiya ebete kalimagono ikameopino Unu Watodawanomoma꞉ keda꞉nama꞉. Ebema꞉ Ya꞉sute a꞉ea꞉no, dopamo Kayapasite me tabono magumu iyatawa꞉no nanitabolo egiya, Ya꞉sute ebeno Yu epo bilibilinomo mabuma꞉ ka꞉emene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Wiyasiya Godote Kayapasido me tabo Yu epo kapiyatamo kegiya꞉, ao, ebete ma kunu giya, me opo kawonomolo iyaiya dilukuliona ibi magumulo piyate ebeno gudima꞉ deda꞉onama꞉na꞉, Ya꞉sute ebeno a꞉e tanalodo ibi bilibilinomo walo kuwatete ibi kapiya alailame gudima꞉ ka꞉midilimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ebene Kayapasite me tabo Ka꞉nisolo dubatamo da꞉kiyawauti, ebe tetene wagilimite iba꞉te Ya꞉suko anakapuima꞉ gabo ebo wadiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ebema꞉ Ya꞉sute ibino tanalo iyatawate tete da꞉peso Yudiya opolo awokala kepata꞉nakia꞉. Ebete wiyasiya ebe waloma꞉tapiago ebe opo atepate Ipala꞉ima duliyomolamo tolamete ebolo nilukuliya, ebe duliyomolo ebe bulu opo niyakabolo itana. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ebene Yu epono Aduga꞉la Soliyomu osiyodilo tete tatalima꞉ dediya, soliyomu osiyodilo tete pea꞉no ibi epetapi bilibilinomate Yelusalema kawo duliyomolamo dopamo tolamoliya, mabu ibi ubila Godokono ololo apulo ibino ape ukulale tanalodo iyaiya kuba daleya tanalo dopamo opoliyalete walone ebeno soliyomu kosiyodiloma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ebe tetelo ibi epetapiate Godoko Amamateno Iya Moto magumulo nutitatate Ya꞉suko nowadilo ibi a꞉ka꞉tuwa꞉ ibi magumulo negeliya, “La꞉imano woki keba kunula꞉ka꞉, Ya꞉suko soliyomu baiamo ba꞉ka꞉pemene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Iba꞉te tabo ma kunu degeliya mabu Godotamo kalimagono ikameopino watowatopi ega꞉walo Pa꞉lisi tanebapi, iba꞉te tabo iyalo iyatiya, “Kebe lumagite Ya꞉suko duimene, modobola ebete samamo a napanaemene, ebene ale tolamete ebe nelawete idoko motamo gito ka꞉piyatimalema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yu epate Aduga꞉la Soliyomu kosiyodiloma꞉ sikisi egelate eba na꞉pola꞉nalo, Ya꞉sute Betani duliyomolamo walo ebo ka꞉pemaigiya, ebe duliyomolo ebe Ya꞉sute a꞉e magumune dadipatiya ebe dubu Lasalesikono duliyomolola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ebene Lasalesikono naniko Matate walubipi epetapiago Ya꞉sukono wade bae osiyodilomitiya, ebene dubu bilibilinomate bae denautiya, Lasalesiko ibi magumulo na꞉luti. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wiyasiya ebeno naniko idi Ma꞉lite wiya kawonomo wade nibo ii inamabu, ebeno mailo ebe nadala, ebete adaete Ya꞉sukono agowamo padipanamete ebeno eka꞉mo agowa a꞉la꞉li ebo iya꞉da꞉olemiya. Ebene ebe moto gu ebe inamabuno wade nibote lawenomo elawiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ebe tetelo Ya꞉sukono waloma꞉tadawa idite bae nao bailo na꞉luti, ebeno mailo ebe Keliyota duliyomolodawa Yudasitela, walone ebete Ya꞉suko anakapumipino kotamo ebe kiyatimene. Ebete Ma꞉likono osiyodilo tanaloma꞉ negiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mabu keleka꞉ ebete me wade nibo inamabu manima꞉ ka꞉na꞉midia꞉? Ebete eba kunu nowageletaleka꞉ kapiya ulamano woko wiya mani buwatena꞉, ebene ale nigologolopiatamo bikalamolena꞉!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudasite me tabo degiya ebete a꞉da꞉ elemasigi gabodo giya. Ebete inamabua꞉ epono modoboa꞉ tanalo kemalagidilolenakia꞉ wiyasiya ebe ubila ebe kawo mani ebete a꞉ka꞉tuwa꞉ kuwatema꞉, mabu ebe Ya꞉sukono waloma꞉tapino mani umidawama꞉ eba eda꞉nalo tete epetapilo ebete mani pilolo uwatenaki. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ebema꞉ Ya꞉sute ebe waloma꞉tapiatamo negiya, “La꞉ Ma꞉liko natepala꞉, ebe natamo wade tanalo osiyodilo. Iyo, nale a꞉ea꞉no tetelo ebete naimano ape bobamo iyati tanalo malagidilolo me wade nibo inamabu naimano apa꞉mo ebema꞉ adipana. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","La꞉ numa꞉la꞉, nigologolopiate tete geyageyanomolo la꞉go bilukulinama꞉na꞉, la꞉imano ubi tetelo ibi nowalubilinakiyala꞉, wiyasiya na uwomua꞉ tetelo la꞉go a꞉kokolinamo, tete tatalila nale la꞉ ka꞉miyapamamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ebe tetelo epo epetapi bilibilinomate Ya꞉suko Betani duliyomololo okoli tanalo dolowiya, iba꞉te ebe uima꞉ ebamo gito tolamiya. Wiyasiya iba꞉te Ya꞉suko kapiya uima꞉ ka꞉tolamiya꞉, ibi ubila Ya꞉sute a꞉e magumune dadipatiya ebe dubu Lasalesiko atumu ka꞉ka꞉nuima꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ebene Yu watowatopi ebe tanalo dolowiya iba꞉te nopo ebo iyatiya Lasalesiko Ya꞉suago kanakapulaema꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mabu Lasalesikono tanalone epo bilibilinomate Ya꞉suko nanitabokobi a꞉midiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Egela idilo piyate Yelusalema kawo duliyomololo Aduga꞉la Soliyomu osiyodiloma꞉ da꞉pelamiya, ibi bilibilinomate iyatawaiya Ya꞉sute ebe duliyomolamo da꞉piti. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ebema꞉ iba꞉te puwala uwatete eba꞉go alugoma꞉ eba tolamitalo kawonomamo negelitiya, “Godoko nadipata꞉la꞉! Godo, a꞉imano mailago da꞉pita, modobola a꞉ma꞉ ebe lumagi kawokobi na꞉midiye! Ebe a Isalaela epono Kawo Elawodubula!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ebene Ya꞉sute oli ape donoki-goeo umite ebe unamo gito okoliya. Ebete eba kunu osiyodiliya Godokono tabote nanitaboma꞉ keda꞉ma꞉, mabu ebeno Bukalo tabo idite ma kunu bitana, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yelusalema duliyomolo epala꞉, la꞉ akotoletoleala꞉. Numa꞉la꞉, la꞉imano Kawo Elawodubute ebe na꞉pita, iyo, ebete donoki-goeo da꞉peso unamo okolite ba꞉pita.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ebe tetelo Ya꞉suko waloma꞉tapiate me Buka tabono magumu wadenomamo kemalagidilutiya꞉, wiyasiya walone Ya꞉sute Godokono elawo alago a꞉e magumune demaigiya, ebe tetelo ibino wokite tuputupuolamete iba꞉te ebo geliya, “Nanitabola, Ya꞉sute Yelusalemamo eba nopegalo, ale ebe demoima꞉, Godokono Buka apuno tabote ebeno tanaloma꞉ nanitabonomoma꞉ ebo edi!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Dopamo Ya꞉sute Lasalesiko bobo magumamo neka꞉mite a꞉e magumune dadipatiya, ebe tetene wagilimite piyate ebe anoano tanalo dumiya, iba꞉te iyaiya duliyomolamo tolamolete epo bilibilinomo epetapi ebo nikiyawaolamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ebe mabuma꞉ Yelusalema epo bilibilinomate ebe tanalo iyatawaote, iba꞉te Ya꞉sute ibino duliyomolamo pema꞉ dolowiya ebe uima꞉ gito pelamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ebema꞉ Pa꞉lisi tanebapiate ubia꞉noma꞉ eba eda꞉olo ibi a꞉ka꞉tuwa꞉ ibi magumulo negeliya, “La꞉ numa꞉la꞉! A elawokobi kolowita꞉, epo bilibilinomate a miyapaete ebe nowaloma꞉ta!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yu epono Aduga꞉la Soliyomu osiyodilo tetelo Yua꞉pi epetapiate Yelusalema kawo duliyomolamo Godoko amamatema꞉ da꞉tolamiya, ibi atumu ebe soliyomu bailo na꞉nepola꞉niya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ebene Ya꞉sukono waloma꞉tadawa idi Pilipiko, ebe Betasaida duliyomolodawala, epetapi iba꞉te ebetamo nemaimite ebe nananiya, “Namutudawa, a Ya꞉suko uima꞉ wagelitama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ebema꞉ Pilipite A꞉nduluko daniya, ibi netewapiate kapimiya tote Ya꞉suko ebo naniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ebene Ya꞉sute iba꞉tamo negiya, “Tete a꞉pe, Godokono elawo alote Epono Naniwi eba pukuimilo ebe dowalogomene, epo bilibilinomate ebeno nanitabo tanalo ebo kuima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ebema꞉ na la꞉tamo nani tabonomo gemo, kono kikopute damela magumamo ma꞉sigate da꞉na꞉emene, ebeno igilote nanitabolo a꞉kolopoligomene mabu walone kono kikopu epetapiate ebe magumune ka꞉pemaima꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ega꞉walo kebe lumagite ebeno igilo kapiya demalagidilona, ebeno igilote kalatidimene, wiyasiya kebe lumagite me opolo ebeno igilo malagidiloa꞉no, ebeno igilote Godokono Unu Duliyomololo uwomua꞉ tetelo bitanamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ebema꞉ kebe lumagite naimano wiya꞉ wokodawama꞉ eda꞉ma꞉ ubi diyatimene, modobola ebete na nowaloma꞉enemene, ebene nale kebe duliyomololo kokolinamo ebete ebe atu duliyomololo nago bokolinamene. Ega꞉walo me tanalo idila, kebe lumagite naimano nani wokodawama꞉ deda꞉mene, naimano Nabiwite ebe unamo kadipatemene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ebene Ya꞉sute Godotamo tabo eba kiyawaolo negiya, “Ka꞉lo na tepo magumulo mibomibonomoma꞉ editamo, ebema꞉ Nabiwi, na a꞉ma꞉tamo beda꞉ tabo na꞉kegemo? Nale ma kunu ba꞉kegemo, ‘Nabiwi, modoboa꞉ me olalati tetete natamo pema꞉’? Ao, nale mako tabo a꞉kegemo mabu na me temeteme laema꞉ me opamo ebema꞉ piyamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ebema꞉ Nabiwi, a꞉ma꞉ a꞉ka꞉tuwa꞉ a꞉imano elawo alo magumudo a꞉ma꞉ nowalogiye.” Ya꞉sute me tabo eba gitalo ebe tetenomolo Godokono Unu Duliyomolone tabote ma kunu piwisigiya, “Na a꞉ka꞉tuwa꞉ na iyalo owalogiyamo, ega꞉walo na a꞉ka꞉tuwa꞉ walo ka꞉kowalogomamo!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ebe tetelo piyate Ya꞉suko niyakabolo delamota꞉oniya, ebe epo bilibilinomate ebe tabo madodo olowite negeliya, “Me tobolo unute gewata,” wiyasiya epetapiate negeliya, “Ao, ebe Godokono nopodawate ebetamo pa꞉kiyawauta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ya꞉sute ibino tabo gela tanalo iyatawate negiya, “Me tabo na mabuma꞉ ka꞉pea꞉, la꞉ mabuma꞉ pe. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nanitabola, ka꞉lo me opo epate ibino kuba osiyodilole mabuma꞉ wiya kuwatema꞉na꞉, ebene me opono kuba elawodubu Saitanako Godote ebeno wato kikopu kitamidaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ega꞉walo Godote na unamo dadipatenemene, ebe a꞉e tanalodo na wiyasiya epo bilibilinomo natamo kemagaelemamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ya꞉sute me tabo da꞉kiyawaiya ebeno magumu ma kunula, ebe kewa olotolowalo keba kunu na꞉ka꞉emene, ebete ebe tanalo ebe awokalimiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ebene epo bilibilinomate Ya꞉sukono tabo eba wiyalo negeliya, “Godokono Totomu Tabo Bukate a niyatuamena, ebeno Alibodawa Kelisote uwomua꞉ tetelo bokolinamene. Ebema꞉ a꞉ma꞉ ma kunu beda꞉ma꞉ kegeawa꞉, Godote Epono Naniwino a꞉e tanalodo ebe unamo kadipatemene? Epono Naniwi potelela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ebene Ya꞉sute walo na꞉kegiya, “Godokono alote la꞉ magumulo tete kele geyageyadopo kitanamene, ebema꞉ modobola la꞉ me alo magumudo nowapata꞉lamenala꞉. La꞉ nanisiwale, idoko tanalote la꞉tamo akopa꞉la꞉, mabu idoko magumudo depata꞉na ebe lumagi iyatawa꞉ ebete kebe gabodo ka꞉tonale! ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ebema꞉ idoko tanalote pea꞉no alote la꞉imano tolame gabo eba pukuiminalo, modobola la꞉ nanitabokobi na꞉mida꞉la꞉, ebene la꞉le alono gudima꞉ keda꞉omamota.” Me tabo kiyawao dolopoligiya, Ya꞉sute ebe epo bilibilinomo miyapate diya gabodo iyabai ida꞉mo tote ebo niluti. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nanitabola, Ya꞉sute me opolo eba okolinalo Godokono elawo kawokalima꞉ ebete epono ololo apulo anoano tanalo bilibilinomo osiyodilolenaki, wiyasiya piyate ebe iyaiya tanalo dulamenakiya ibi magumulo Yu epo epetapiate ebe nanitabokobi ka꞉midiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ebene me tanalote eba kunu pemaigiya, Godokono woki awokalimidawa Aisayate degiya, ebe tabote nanitaboma꞉ keda꞉ma꞉. Iyalo tetelo ebete tabo ma kunu giya, “Kawodawa, a꞉ma꞉ a꞉imano kawo elawo piyatamo kawokalima꞉wenaka, ale a꞉imano tabo iba꞉tamo da꞉kiyawaima꞉, nanitabokobi potele ka꞉midile? Lumagi ka꞉luta꞉, puliyanomola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ebema꞉ mabu keleka꞉ epate Ya꞉suko nanitabokobi midima꞉ modoboa꞉noma꞉ deda꞉ona? Aisayate ebe tanalo awokalima꞉ tabo idi ma kunu kegiya, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Godote nanitabokobi midia꞉pino balidi idokoma꞉ midililamete, ibino tepo magumuno woki a꞉ka꞉kodakodailamelelamiya. Ebema꞉ ebete ibino tanaloma꞉ negena, ‘Iba꞉te balida꞉mo nanitabo tanalo uima꞉ modoboa꞉, iyo, ibino tepo magumulo naimano wade tanalo iyatawaoma꞉ modoboa꞉. Iba꞉te ibino tepo magumuno woki wadenomamo nemalagidilotaleka꞉ natamo bolobila꞉na꞉, ebema꞉ na modobola ibi nale wadekobi midilima꞉.’” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nanitabola, epate Ya꞉suko ubia꞉noma꞉ deda꞉oma꞉na꞉, Aisayate ebe tanaloma꞉ me tabo iyalo egiya, mabu ebeno balidite iyama꞉ eba eda꞉omelo ebete Ya꞉suko Godokono elawo alote pukuimitalo ebo umiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ebene epo epetapiate Ya꞉suko ubia꞉noma꞉ eba eda꞉olo, atu tetelo epo epetapi ega꞉walo ibino watowatopi epetapiate ebe nanitabokobi ebo midiya. Wiyasiya iba꞉te Pa꞉lisi tanebapi tolelamelo ibino nanitabokobi midi tanalo kawokalimiya꞉, Pa꞉lisi watowatopiate dowa magumulo ibi iyaiya duliyomolono balidi ibilamole motamo odolo talena iyatilamekapoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nanitabola, iba꞉te Ya꞉suko waloma꞉ta magumulo kodakodalo ka꞉pola꞉niya꞉ mabu ibi ubila epate iba꞉tamo kekalakalaoma꞉, wiyasiya Godote iba꞉tamo dekalakalana iba꞉te ebe tanalo kawonomamo kemalagidilonamia꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ebema꞉ Ya꞉sute kawonomamo eba gepatelo negiya, “Kebe lumagite na nanitabokobi da꞉midinina ebete na kapiya nanitabokobi ka꞉midinina꞉, ebete na dapaliboniya ebe dawa atumu nanitabokobi na꞉ka꞉midina, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ega꞉walo kebe lumagite naimano tanalo dumina, ebete na dapaliboniya ebe dawano tanalo na꞉kumina. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nanitabola, na me opo pukuima꞉ piyamo, ebema꞉ kebe lumagite na nanitabokobi da꞉midinina ebete idoko magumulo a꞉kokolinamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ega꞉walo me tanalo idila. Kebe lumagite naimano tabo olowite tuduwata꞉no, nale ebeno tanalo akanagiyamidaemo mabu na me opo epatamo kuba wiya ikalaema꞉ ka꞉piya꞉, wiyasiya na ibino igilo mula꞉lelaema꞉ piyamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Numa꞉la꞉, kebe lumagite na ubia꞉noma꞉ eda꞉te naimano iyaiya tabo uwatea꞉no, ebeno tanalo anagiyamidaema꞉ Kawodawa idi ba꞉luta. Iyo, Godote Uwomu Egelalo naimano tabamo ebe lumagino tanalo kanagilamelemene, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","mabu nale da꞉kiyawaonamo ebe iyaiya tabo na a꞉ka꞉tuwa꞉ naimano wokiamo ka꞉kiyawaona꞉, wiyasiya Nabiwite na dapaliboniya nale ebetamo tuduwatalo ebeno tabonomo kiyawaonamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na me tanalo iyatawala, Nabiwino totomu tabo ebe uwomua꞉ igilola, ebema꞉ ebete na keba kunu kananenakole, na eba kunu kiyawaonakomo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yu epono Aduga꞉la Soliyomu osiyodiloma꞉ kapiya egelate eba nitanalo, Ya꞉sute ebo iyatawiya me tetela, ebete tatalila me opo atepate Nabiwi Godotamo ka꞉tomene. Nanitabola, piyate me opolo ebenoma꞉ deda꞉onamiya, Ya꞉sute ibi nilakapoilamelo kawonomamo malagidilolenami, ebema꞉ ibi ebe nilakapago magatalete uwomunomamo ebo nemaigiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ebene ebe idokolo Ya꞉sute ebe waloma꞉tapiago ilukulinate bae naoniya. Ebe idoko pea꞉no Saitanate dopamo waloma꞉tadawa idi Yudasikono tepo magumamo kuba woki ma kunu iyatimiya, ebete Ya꞉suko anakapumipino kotamo ebe kiyatima꞉, me dubu Yudasiko ebe Keliyota duliyomolodawa Saimonokono gudula. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nanitabola, Ya꞉sute me netewa-kapiya tanalo iyalo iyatawiya, Nabiwi Godote ebetamo elawo ikamiya tanalo bilibilinomo osiyodilolema꞉, ega꞉walo ebe Godogodone piya, ega꞉walo ebe Godotamo walo ka꞉ka꞉tomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ebe mabuma꞉ ebete bae nao baine maiganate, lubudino kaliku pekananate wiya꞉ wokodawamu a꞉la꞉li iya꞉da꞉oleno kaliku lawenate gito pulini. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ebene ebete wakaluamo obo alatenate ebeno waloma꞉tapino agowa ukulaolelame ebo wagilimini, ega꞉walo ebete da꞉pulini ebe a꞉la꞉li iya꞉da꞉oleno kalikamo ebete ibino agowa a꞉la꞉li ebo iya꞉da꞉olelameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ebene ebete Saimono Pitatamo da꞉peni Pitate ebetamo negeni, “Kawodawa, a꞉ma꞉ naimano agowa ba꞉kukulalenama꞉emene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ya꞉sute tabo eba wiyanalo ebe nanani, “A꞉ma꞉ iyatawa꞉ nale a꞉ma꞉tamo beda꞉ tanalo kosiyodilonamo, wiyasiya a꞉ma꞉ walone kiyatawama꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ebema꞉ Pitate negeni, “Ao, ebe tanalo modoboa꞉! A꞉ma꞉ naimano agowa a꞉kukulala꞉emene.” Ya꞉sute wiyasiya ebe nanani, “Nale a꞉imano agowa ukulalea꞉no a꞉ma꞉ nagodolo gobeboboa꞉nola.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ebema꞉ Pitate ebetamo negeni, “Kawodawa, kuba꞉, a꞉ma꞉ naimano agowa kapiya akoukulala꞉la꞉. Modobola a꞉ma꞉ naimano kotola watola atumu na꞉kukulalenamiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ebene Ya꞉sute negeni, “Kebe lumagite mala꞉ iyalo deti ebeno apeno daleya puliyala, wiyasiya ebete ebeno agowa kapiya nukulalemene. Me tanalo nanitabola, la꞉ bilibilinomate oliolinoma꞉ eda꞉imata, wiyasiya la꞉imano taneba magumulo kapiya dawate olinoma꞉ keda꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ya꞉sute me tabo degeni mabu ebe iyalo iyatawiya, waloma꞉tapi magumulo ebe potele anakapumipino kotamo diyatimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ebe tetelo ebete ebeno waloma꞉tapino agowa ukulaolelame dolopoligoni, ebete ebeno lubudino kaliku walo ka꞉pulinate gito okolini. Ebene ebete ibi nanaleni, “La꞉ iyatawala꞉ka꞉, nale la꞉tamo dosiyodilomo ebe tanalono magumu? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","La꞉le na la꞉imano Iyatulamedawama꞉ gelanakomata ega꞉walo Kawodawama꞉ akoka꞉na꞉minakomata. Nanitabola, na ebe ebetela. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ebema꞉ walone la꞉le naimano osiyodilo tanalo ma kunu demalagidilawenakoma, ‘Aimano Iyatulamedawa ega꞉walo Kawodawa, ebete aimano agowa ukulaoleameni,’ modobola la꞉ a꞉ka꞉tuwa꞉ la꞉imano taneba magumulo idite idino agowa atumu nukulalemenakiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iyo, nale la꞉tamo uli osiyodilomo, walone la꞉le epetapiatamo ma kunu nosiyodilonakiyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na la꞉tamo nani tabonomo gemo, wokodawa idino elawote ebeno woko namutudawano elawo kodolinakoa꞉, ega꞉walo tabo atadawano elawote ebe dapalibomene ebe kawodawano elawo a꞉kodolimene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ebema꞉ la꞉ me iyaiya tanalo iyatawawete, ma kunu idite iditamo, idite iditamo, wiya꞉ woko dosiyodilawenakoma, ebene la꞉godolo kawo kalakalanomote bitananakomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ebene Ya꞉sute ebe waloma꞉tapiatamo negeni, “Godokono Bukalo tabo idi ma kunu itana, ‘Nago bae denanako, ebe lumagite naimano goweladawama꞉ keda꞉mene,’ ebema꞉ me tetelo aimano taneba magumulo me tabono tanalote nanitaboma꞉ keda꞉mene, Godokono ubila. Nanitabola, na la꞉imano tanalo iyatawanomola, mabu la꞉le na waloma꞉enema꞉ nale la꞉ uwatimata, ebema꞉ me tabote la꞉ bilibilinomono tanaloma꞉ kegena꞉, kapiya lumagino tanaloma꞉ gena. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ebe lumagino tanalote maiga꞉no nale la꞉ dopamo analemata. Ebene ebeno tanaloma꞉ Buka apuno tabote nanitabolo demaigamene, la꞉ nanitabokobi ebo ka꞉midimamota na uwomua꞉ tetelo dokolinamo ebe dawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na la꞉tamo nani tabonomo gemo, nale kebe wokodawa dalibomo, potele ebe wokodawa kalakalago dowalubimene ebete na kowalubinimene, ega꞉walo potele na dowalubinimene ebete na kapiya a꞉kowalubinimene, ebete na Alibonedawa Godoko atumu ka꞉kowalubimene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ebene Ya꞉sute me tabo kiyawao dolopoligini ebete tepo magumulo mibomibonomoma꞉ eda꞉nate ebe waloma꞉tapiatamo awokala negeni, “Na la꞉tamo nani tabonomo gemo, la꞉imano taneba magumulo idawate na anakapunamepi kowalubilimene na kelawenema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ebema꞉ ebe waloma꞉tapiate ibino taneba magumulo eba uma꞉tepauinalo nemalagidiloniya, “Me kuba potele na꞉kosiyodilomene?” wiyasiya iba꞉te lumagi kuminiya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ebe tetelo Ya꞉sute ebe waloma꞉tapi magumulo poko kawonomamo demalagidilonami, ebete Ya꞉suko niyakabolo na꞉luti, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ebene Saimono Pitate kotamo eba genalo ebe nanani, “A꞉ma꞉le Iyatulamedawa nana ebete pokono tanaloma꞉ kegenale.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ebene ebe waloma꞉tadawate Ya꞉suko niyakabamo nokoliatepanate ebe nanani, “Kawodawa, ebe lumagi potelela꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ya꞉sute ebeno tabo eba wiyanalo negeni, “Nale bae kalila꞉mo aduba꞉midate kebe lumagitamo dikaemo, ebe ebe lumagila.” Ebe tetelo ebete bae kalila꞉mo aduba꞉midanate, Keliyota duliyomolodawa Saimonokono gudu Yudasitamo gito ikameni. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ebene Yudasite ebe bae delaweni, ebe tetenomolo Saitanate ebeno tepo magumamo gito opegani. Ebene Ya꞉sute ebetamo negeni, “A꞉ma꞉le kebe tanalo osiyodiloma꞉ dowagela꞉wena, modobola samonomamo nosiyodila.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ebe tetelo bae nao bailo da꞉pola꞉niya, ebe waloma꞉tapi epetapi magumulo lumagi idite Ya꞉sukono tabono magumu kelaweniya꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasite ibino tanebapino mani umidawama꞉ eda꞉nami, ebema꞉ epetapiate nemalagidiloniya Ya꞉sute soliyomu osiyodilono bae epetapi ka꞉nuwateonama꞉ gena, ega꞉walo epetapiate nemalagidiloniya ebete nigologolopi maniamo ka꞉nowalubilinama꞉ gena. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ebene Yudasite Ya꞉sugodone bae delaweni, ebe tetenomolo ebete iba꞉godone maiganate idoko magumamo gito nopegani. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasite ibi da꞉miyapani ebe tetelo Ya꞉sute epetapiatamo negeni, “Me tetelo Godokono elawo alote Epono Naniwi eba pukuimilo ebe kowalogomene, ega꞉walo Epono Naniwite ebeno osiyodilo tanalodo Godoko kowalogomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ebema꞉ Godote ebe a꞉ka꞉tuwa꞉ ebe Epono Naniwi magumudo dowalogomene, ebe atu tetelo ebete Epono Naniwi elawo alamo eba pukuimilo ebe kowalogomene. Nanitabola, ebete ebe tanalo samonomamo kosiyodilomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ebene Ya꞉sute tabo idi na꞉kegeni, “Naimano guda꞉la꞉, na la꞉go tete da꞉pesamo okoliatepate la꞉le na ebo kowadinimamota. Iyo, nale kebe tabo Yu watowatopiatamo dopamo degimo, ka꞉lo la꞉tamo ebe atu tabo kegemo, nale kebe duliyomolamo da꞉tomo la꞉le ebe duliyomolamo pelaema꞉ modoboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Wiyasiya ka꞉lo idokolo na la꞉tamo oli totomu tabo ikalaemata la꞉ kowalubilitama꞉. Modobola la꞉imano ilukuli magumulo idite idi nilakapolo nemalagidilonala꞉, nale la꞉ keba kunu kemalagidiloletanama eba kunu. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kebe tetelo la꞉imano taneba magumulo idite idi nilakapolo kemalagidilo, idite idi nilakapolo kemalagidilo, la꞉ eba kunu dowagela꞉wenama, me gabodo epo bilibilinomate kiyatawaoma꞉na꞉ la꞉ naimano waloma꞉tapilata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ebene Saimono Pitate Ya꞉sutamo negeni, “Kawodawa, a꞉ma꞉ kebamo na꞉ka꞉toaemene?” Ya꞉sute tabo eba wiyanalo negeni, “Nale kebe duliyomolamo da꞉tomo, me tetelo la꞉le na waloma꞉enema꞉ modoboa꞉, wiyasiya nanitabola, la꞉le na walogabo apune kowaloma꞉enemamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ebene Pitate ebe walo nakanani, “Kawodawa, mabu keleka꞉ nale me tetelo a꞉ma꞉ waloma꞉ea꞉noma꞉ degeawa꞉? Na modobola naimano igilo a꞉ma꞉ mabuma꞉ iyabaiamo kiyatimamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ebe tetelo Ya꞉sute ebeno tabo eba wiyanalo negeni, “A꞉imano igilo na mabuma꞉ nanitabonomolo ba꞉kiyata꞉emene? Na a꞉ma꞉tamo nani tabonomo gemo, ka꞉lo idokolo kakabate geoa꞉no a꞉ma꞉ netewa-kapiya teta꞉mo na iyatawa꞉noma꞉ kegema꞉ta.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ebene Ya꞉sute tabo moga꞉menalo ebe waloma꞉tapiatamo negeni, “La꞉ tepo mibomiboma꞉ ega꞉walo woki bilibilima꞉ akoeda꞉oala꞉. Modobola la꞉ Godoko nanitabokobi na꞉mida꞉la꞉, ega꞉walo la꞉ na atumu nanitabokobi na꞉midina꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nanitabola, naimano Nabiwino moto gulo la꞉imano ilukuli bai bilibilinomo ba꞉pola꞉na. Me tanalo a꞉da꞉ma꞉ neda꞉taleka꞉ nale la꞉ akanaletana꞉, iyo, na la꞉imano nanitabo ilukuli bainomo osiyodilolema꞉ ka꞉tomamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ebene na la꞉imano ilukuli bai nosiyodilolete walo ka꞉pete la꞉ ebo ka꞉puwatemamota, ebe tetelo a bilibilinomate kapimiya naimano duliyomololo ba꞉nilukulinama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nanitabola, nale kebe duliyomolamo da꞉tomo, la꞉ ebe duliyomolamo tolame gabo iyatawalata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ebene Tomasite Ya꞉sutamo negeni, “Kawodawa, a꞉ma꞉le kebe duliyomolamo da꞉toaemene a ebe duliyomolo iyatawa꞉, ebema꞉ a gabo keba kunu na꞉kiyatawaoma꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ya꞉sute ebeno tabo eba wiyanalo negeni, “Na ebe gabola, ega꞉walo na nanitabo tanalo awokalimidawala, ega꞉walo na uwomua꞉ igilola. Lumagite nado Nabiwi Godotamo ka꞉tomene, gabo idido a꞉ka꞉toamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Numa꞉la꞉, la꞉ naimano tanalo iyatawalata, ebema꞉ me tetene wagilimite la꞉ naimano Nabiwino tanalo atumu ka꞉kiyatawaomamota. Nanitabola, la꞉ ebe iyalo umiamata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ebene Pilipite ebetamo negeni, “Kawodawa, a꞉ma꞉ atamo Nabiwino tanalo dawokalima꞉emene, a ka꞉modobomalema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ya꞉sute tabo eba wiyanalo negeni, “Pilipi, nale tete geyageyanomolo la꞉go okolinaimo, ebema꞉ mabu keleka꞉ a꞉ma꞉le naimano tanalo kiyatawawena꞉? A꞉ma꞉le na dunama꞉wia, ebe gabodo a꞉ma꞉le Nabiwi umiata, ebema꞉ keleka꞉ mabu a꞉ma꞉le ma kunu degeawa꞉, ‘Nabiwino tanalo atamo nawokalima꞉’? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pilipi, a꞉ma꞉ me tanalo nanitabokobi na꞉ka꞉mida꞉wena, na Nabiwigodolo bokolinamo ega꞉walo Nabiwite nagodolo bokolina?” Ebene Ya꞉sute ebe waloma꞉tapi bilibilinomatamo negeni, “Nale la꞉tamo kebe tabo ka꞉kiyawaonakimo, ebe iyaiya tabono tanalate nagodone ka꞉pelamena꞉, wiyasiya nagodolo dokolina, ebe Nabiwite naimano iyaiya tabamo ebeno wade woko osiyodilona. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ebema꞉ modobola la꞉ me tanalo nanitabokobi na꞉mida꞉la꞉, na Nabiwigodolo bokolinamo ega꞉walo ebete nagodolo bokolina. Wiyasiya la꞉ la꞉imano wokilo me tanalo kodakodama꞉ degelawenama, ebema꞉ nale kebe anoano tanalo la꞉ magumulo dosiyodilolenakimo, modobola la꞉ ebe tanalono magumu eba malagidilolo na nanitabokobi na꞉midina꞉la꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ka꞉lo idokolo na la꞉tamo nani tabonomo gemo, kebe lumagite na nanitabokobi da꞉midinimene, nale dosiyodilonamo ebete ebe atu woko ba꞉kosiyodilonamene. Nanitabola, ebe lumagino woko osiyodilo elawote naimano woko osiyodilo elawo ka꞉nodolimene mabu na Nabiwitamo ka꞉tomamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ebema꞉ la꞉le naimano mailamo beda꞉ tanaloma꞉ na da꞉toweonama꞉ema, nale la꞉tamo kikalaemamota mabu naimano osiyodilo tanalodo Nabiwite a꞉ka꞉tuwa꞉ ebe kowalogomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Iyo, la꞉ naimano mailamo beda꞉ tanaloma꞉ na da꞉toweonama꞉ema, na la꞉tamo gito kikalaemamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ebene Ya꞉sute ebe waloma꞉tapiatamo tabo idi na꞉kegeni, “La꞉le na nilakapolo demalagidilona꞉ema la꞉ naimano totomu tabamo ka꞉tudila꞉omamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ebema꞉ nale naimano Nabiwi kanamamo, ebete Walubidawa idi la꞉tamo kapaliboma꞉, ebete uwomua꞉ tetelo la꞉go bokolinamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ebe Godokono Wade-talena Uliyanala, Godokono nanitabo tanalo dawokalimina ebe ebe dawala. Me opo epate ebe kuminakoa꞉, ega꞉walo ebeno tanalo kiyatawaona꞉, ebema꞉ iba꞉te ibino tepo magumulo ebeno elawo nanitabolo a꞉kelaema꞉na꞉. Wiyasiya la꞉ nanitabokobi midipino tanalo eba kunua꞉ mabu la꞉ ebeno tanalo iyatawanomolata, iyo, ebete uwomua꞉ tetelo la꞉godolo bokolinamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ebema꞉ nale la꞉ gito a꞉ka꞉miyapatama, ao, nale me Walubidawa la꞉tamo nanitabolo kapalibomamo, ebene ebete la꞉godolo eba okolinalo walone na a꞉ka꞉tuwa꞉ la꞉tamo walo ka꞉ka꞉pemamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","“Tete da꞉pesolo me opo epate na a꞉kunaema꞉na꞉, wiyasiya la꞉le na kunaemamota, iyo, na uwomua꞉ igilago okolinamo, ebema꞉ la꞉ atumu ebe igilago ilukulinamata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","La꞉le na walo da꞉kunama꞉ema, ebe egelate da꞉pemaigamene, la꞉ me tanalo ebo kiyatawaomamota, na naimano Nabiwigodolo okolinamo ega꞉walo la꞉ nagodolo ilukulinamata, ebene na atumu la꞉godolo bokolinamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ebema꞉ piyate naimano totomu tabo bilibilinomo uwatete da꞉tudila꞉onakoma꞉na꞉, iba꞉te na nilakapolo malagidilonena. Nanitabola, kebe epate na nilakapolo demalagidilonena, naimano Nabiwite ibi atumu nilakapolo ba꞉kemalagidilolena, ega꞉walo nale ibi atumu nilakapolo eba kemalagidilolenalo na a꞉ka꞉tuwa꞉ naimano tanalo iba꞉tamo bawokaliminakomo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ebene Yudasi idite, Keliyota duliyomolodawa Yudasitea꞉, ebete Ya꞉suko nalateda꞉ni, “Kawodawa, me opo epate a꞉ma꞉ umia꞉no, ebe tetelo a a꞉ka꞉tuwa꞉ a꞉ma꞉ keba kunu na꞉kumitamene?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ya꞉sute tabo eba wiyanalo negeni, “Kebe lumagite na nilakapolo demalagidilonena, ebete naimano totomu tabamo ba꞉tuduwatanakomene, ebene naimano Nabiwite ebe nilakapolo bemalagidilonamene, ega꞉walo ale ebetamo pete ebegodolo ba꞉pokolionama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wiyasiya kebe lumagite na nilakapolo malagidilonena꞉no, ebete naimano totomu tabamo a꞉ka꞉tuduwatamene. Me tanalo nanitabola, la꞉ nagodone dolowiawenakoma ebe iyaiya totomu tabo naimanoa꞉, ebe totomuate na dapaliboniya ebe Nabiwigodone pelamena. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nale la꞉ miyapa꞉no me iyaiya tanalo dopamo la꞉tamo a꞉kiyawaomo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ebene nale la꞉ da꞉miyapatama, Nabiwi Godote naimano mailamo Walubidawa idi la꞉tamo kapalibomene, ebe ebeno Wade-talena Uliyanala. Nanitabola, nale dopamo kebe tanalo bilibilinomo la꞉ diyatulametanakima, ebete pete ebe atu iyaiya tanalo la꞉ walo eba ka꞉piyatulamelo la꞉imano woki ebo ba꞉tuputupuilamenakomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ega꞉walo me tanalo idila, nale la꞉tamo naimano tepo magumulo ditana ebe milo ikalaemata. Ebe milo me oponoa꞉, ebema꞉ la꞉ la꞉imano tepo magumulo woki bilibila꞉go ega꞉walo tola꞉go akoilukulinala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nale la꞉tamo nanitabolo degemo la꞉ olowimata, na Nabiwi Godotamo tote ebene la꞉tamo walo ka꞉ka꞉pemamo. Numa꞉la꞉, la꞉le na nanitabolo nilakapolo nemalagidilona꞉wenataleka꞉, naimano to tanaloma꞉ la꞉ bekalakalawena꞉, mabu ebeno elawo kawonomola, naimano elawo nodoliona. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Me tanalote maiga꞉no na la꞉ dopamo analemata, ebema꞉ me tanalote nanitabolo demaigamene, ebe tetelo la꞉ nanitabokobi ka꞉midimamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Wiyasiya ka꞉lo idokolo na la꞉tamo tabo kawonomo a꞉ka꞉kiyawaomo, mabu me opo namutudawa na꞉pe. Ebe kubadawano elawote nanitabolo natamo kitana꞉ nale ebetamo ka꞉tuduwatama꞉, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","wiyasiya naimano Nabiwite na kebe tanalo kosiyodilolema꞉ dananenako, nale ebe tanalo eba osiyodilolelo ebe kapiyatamo tuduwatanakomo. Iyo, me ebe gabodo me opo epate naimano tanalo niyatawaoma꞉na꞉, nale naimano Nabiwi nilakapolo demalagidilonamo. “Ebema꞉ modobola la꞉ nemaimiala꞉, a me motone ka꞉tolamiye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ebene Ya꞉sute ebe waloma꞉tapiatamo tabo idi na꞉kegeni, “Na gala꞉ipi tupina da꞉imi kewanomola, ega꞉walo naimano Nabiwite ebe da꞉imi kewa umidawama꞉ eda꞉na. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","“Ebema꞉ me kewano noloa꞉ katomo bilibilinomo ebete mabunomamo otolete iyabaiamo kiyalekemene, wiyasiya da꞉nolonaka ebe katomo bilibilinomo unu paago ebete unuya kotolemene iba꞉te kawonomamo walo ka꞉ka꞉noloma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nanitabola, nale la꞉tamo kebe iyaiya tabo ka꞉kiyawaonakimo ebe tabote la꞉ ukulaolenomo dukulaoletia, la꞉le oliolinoma꞉ ebo eda꞉imata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ebema꞉ modobola la꞉le na da꞉imi kewanomogodolo nilukulinala꞉, ebene na atumu la꞉godolo bokolinamo. Me tanalo wadenomamo nemalagidilala꞉, da꞉imi katomote ebeno apa꞉mo moga꞉no ebe a꞉ka꞉tuwa꞉ a꞉ka꞉nolomene, ebema꞉ la꞉ nagodolo ilukulina꞉no la꞉le nanitabolo a꞉ka꞉noloaema. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Na ebe gala꞉ipi tupina da꞉imi kewanomola, la꞉ katomolata. Kebe lumagite na magumulo dokolinamene ega꞉walo na atumu ebegodolo dokolinamo, ebete kawonomamo ka꞉nolomene, wiyasiya na la꞉imano tepo magumulo okolina꞉no la꞉ a꞉ka꞉tuwa꞉ wade tanalo idi a꞉kosiyodilaema. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ebema꞉ kebe lumagite na magumulo okolina꞉no, ebe noloa꞉ katomo keba kunula꞉ka꞉ eba kunula. Pali namutudawate ebe iyabaiamo deba꞉idilomene alawoma꞉ ebo ka꞉neda꞉mene, ebene lumagi idite pelawete elamo gito ka꞉peba꞉idilomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nanitabola, la꞉ nagodolo dilukula꞉wenama ega꞉walo naimano iyatulame tabote la꞉imano tepo magumulo da꞉pola꞉namene, ebe tetelo la꞉ naimano iyaiya tabo nanitabolo eba waloma꞉talenalo beda꞉ tanaloma꞉ naimano Nabiwi dalateda꞉ema ebete ebe tanalo la꞉tamo kikalaema꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mabu kebe tetelo la꞉ naimano da꞉iminomo keba kunula꞉ka꞉ eba kunu kawonomamo da꞉noloaema, ebe tetelo la꞉ me tanalo wadenomamo kawokalimamota, la꞉ ebe naimano waloma꞉tapinomolata. Me ebe gabodo Nabiwi Godote ebe a꞉ka꞉tuwa꞉ ebe kowalogomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Numa꞉la꞉, Nabiwite na nilakapolo keba kunu kemalagidilonenale, nale la꞉ eba kunu malagidilolenamata, ebema꞉ modobola la꞉ naimano nilakapo magumulo nilukuliniyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nanitabola, la꞉ naimano iyaiya totomu tabamo nanitabolo da꞉tudila꞉wenama, ebe gabodo la꞉le naimano nilakapo magumulo bilukulinamata, nale naimano Nabiwino totomu tabamo tuduwatalo ebeno nilakapo magumulo dokolinamo eba kunu. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ebema꞉ nale la꞉ me tabo analemata, mabu na ubila naimano kalakalate la꞉imano tepo magumulo tabokate ebolo kitanama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Me ebe naimano kawo totomu tabola la꞉tamo. Nale la꞉ nilakapolo keba kunu kemalagidiloletanama, la꞉imano taneba magumulo idite idi eba kunu nemalagidilowiniyala꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Numa꞉la꞉, lumagi idite ebeno namutupino igilo mula꞉lelaema꞉ ebeno igilo iyabaiamo gito diyatimene, eba kunu ebegodolo nanitabo nilakapo tanalote kawonomamo kawokalamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“Ega꞉walo me tanalo idila, la꞉le naimano totomu tabamo da꞉tudila꞉wema, ebe gabodo la꞉ naimano namutupima꞉ keda꞉omamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ebema꞉ me tetene wagilimite nale la꞉ naimano wiya꞉ wokopima꞉ walo a꞉keka꞉la꞉mitama mabu wiya꞉ wokopiate ibino namutudawano tepo magumuno woki nanitabolo kiyatawana꞉. Wiyasiya nale Nabiwigodone kebe iyaiya tanalo kolowiyamo, ebe tanalo bilibilinomo la꞉tamo awokalilaimo, ebema꞉ la꞉ naimano wiya꞉ wokopinomoa꞉, ao, la꞉ naimano namutupilata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ebema꞉ me kawo tanalo akododomatiala꞉, la꞉le na lawenea꞉no nale la꞉ dopamo uwatimata, la꞉le me opono iyaiya opolo eba nilukulionalo da꞉iminomate la꞉ magumulo ka꞉nolonama꞉. Ebene la꞉imano da꞉ima꞉te uwomua꞉ tetelo eba pola꞉nalo, la꞉ beda꞉ tanaloma꞉ Nabiwi Godoko naimano mailamo da꞉toweoma꞉wenakoma, ebete ebe tanalo la꞉tamo ebo bikalamenakoma꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Me ebe naimano kawo totomu tabola la꞉tamo, la꞉imano taneba magumulo idite idi nilakapolo nemalagidilowiniyala꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ebene Ya꞉sute tabo idi na꞉kegeni, “Me opo epate la꞉ naimano waloma꞉piatamo da꞉dowaoma꞉na꞉, ebe tetelo nemalagidiliyala꞉ iba꞉te dopamo natamo a꞉dowaiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ebema꞉ la꞉ me opo epoma꞉ nanitabolo neda꞉wenataleka꞉ iba꞉te la꞉ kalakalago buwatetana꞉, wiyasiya nale la꞉ ibino taneba magumune uwatimata, ebema꞉ iba꞉te la꞉ ubia꞉noma꞉ eda꞉olo la꞉tamo ba꞉dowaonama꞉na꞉ mabu la꞉ iba꞉go kapiyama꞉ keda꞉wena꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ega꞉walo nale la꞉ dopamo danaletima, la꞉le me tabo walo na꞉kemalagidilala꞉, wokodawano elawote ebeno woko namutudawano elawo kodolina꞉. Ebema꞉ kebe epate natamo kawokawo temeteme dikanamenakiya, iba꞉te la꞉tamo atu temeteme ba꞉kikalamenakoma꞉ta, ega꞉walo kebe epate naimano iyatulame tabamo da꞉tudila꞉iya, iba꞉te la꞉imano iyatulame tabamo atumu ka꞉ka꞉tudila꞉oma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","“Numa꞉la꞉, na dapaliboniya ebe dawano tanalo me opo epate iyatawa꞉, ebema꞉ iba꞉te na mabuma꞉ la꞉tamo iyaiya kubakuba tanalo bosiyodilolenakoma꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nale iba꞉tamo pete Godokono nani tabo pikiyawaoa꞉notaleka꞉, ebeno dowa tanalote ibino kuba osiyodilole mabuma꞉ a꞉ka꞉pena꞉, wiyasiya nale me opamo da꞉piyamo, ebe tetene wagilimite ibino kuba waminaole gabo kitanamia꞉, ebema꞉ ibino kuba wiyate nanitabolo na꞉pe. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Numa꞉la꞉, ibi magumulo kebe lumagite natamo da꞉dowana, ebete atumu naimano Nabiwitamo na꞉ka꞉dowana. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ebema꞉ nale me opo epo magumulo naimano Nabiwino kawokawo anoano tanalo posiyodilolea꞉notaleka꞉, ebeno dowa tanalote ibino kuba osiyodilole mabuma꞉ a꞉ka꞉pena꞉. Wiyasiya na ibino taneba magumulo ebeno elawo kawonomamo awokalimo, me opo lumagi idite ebako elawo awokalima꞉ modoboa꞉, iyo, iba꞉te naimano elawo nanitabonomolo umiya, wiyasiya iba꞉te natamo ega꞉walo Nabiwitamo kawonomamo dowaona. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Numa꞉la꞉, me tanalote ma kunu pemaigi Godokono Buka apuno tabote nanitaboma꞉ keda꞉ma꞉, mabu ebete Yu epatamo dikalamiya ebe Totomu Bukalo tabote ma kunu itana, ‘Nale ibi mabuma꞉ wadewade tanalo eba osiyodilolenalo, wiyasiya iba꞉te natamo a꞉dowaiya.’ ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Naimano walomatapiala꞉, na Walubidawa idi la꞉tamo kapalibomamo, ebe Nabiwi Godogodone da꞉pena ebe Wade-talena Uliyanala. Ebe Godokono nanitabo tanalo awokalimidawala, ebema꞉ ebete me opo epatamo da꞉pemene naimano tanalo kapawokalimene, ");
INSERT INTO knv_fly_river_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ebene la꞉ atumu naimano tanalo nakawokalimiyala꞉, mabu nanitabola, naimano woko wagilimi mabune la꞉ nago ilukulinaimata.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Na ka꞉lo idokolo me tanalo bilibilinomo la꞉tamo kiyawaomo, mabu na ubia꞉nola la꞉le agowa ukamidaolema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tete na꞉pe, Yu epate la꞉tamo talena kiyatilaema꞉ta la꞉le ibino iyaiya duliyomolono balidi ibilamole moto guamo opila꞉oma꞉, ega꞉walo ebe tetelo epetapiate la꞉ anakapulaema꞉ nopo eba iyatilo ebo kemalagidiloma꞉na꞉ iba꞉te Godokono woko osiyodilona. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nanitabola, iba꞉te eba kunu la꞉tamo kawokawo kuba osiyodilolema꞉ kowagelema꞉na꞉, mabu iba꞉te naimano tanalo ega꞉walo naimano Nabiwino tanalo iyatawa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ebema꞉ numa꞉la꞉, na me iyaiya tanalo la꞉tamo a꞉kiyawaomo, mabu na ubila me kuba tetete da꞉pemaigamene la꞉ ebo kemalagidilomamota, ebete aimano temeteme tanaloma꞉ a iyalo anai.” Ebene Ya꞉sute ebe waloma꞉tapiatamo tabo idi na꞉kegeni, “Na dopamo me iyaiya tanaloma꞉ la꞉ kanaletia꞉, mabu naimano woko wagilimi mabune pete me teta꞉mo pemaiga, ebe tete geyageyadopolo nale la꞉go okolinaimo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Wiyasiya tete na꞉pe, na dapaliboniya ebe dawatamo na walo ka꞉ka꞉tomamo. La꞉ ebe tanaloma꞉ woki bilibilima꞉ eba eda꞉wenalo, wiyasiya idawate na ma kunu kalateda꞉nena꞉, ‘A꞉ma꞉ kebamo na꞉ka꞉toaemene?’ ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","mabu la꞉ naimano to tanalo eba malagidilonalo tepo magumulo mibomibonomoma꞉ eda꞉onamata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ebema꞉ nale la꞉ nani tabo analemata, nale la꞉ da꞉miyapatama ebe wade tanalola, mabu na toa꞉no la꞉imano Walubidawa idi, ebe Godokono Uliyanala, ebete la꞉tamo a꞉ka꞉pemene. Iyo, na la꞉godone da꞉tomo, ebe tetelo na ebe Wade Walubidawa la꞉tamo nanitabolo kapalibomamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Ebete me opo epatamo da꞉pemene, ebe tetelo ebete iba꞉tamo me tanalo kapawokalilaemene, me tanalo ebe me opono kuba osiyodilole tanalo, ega꞉walo Godokono tuputupu okoli tanalo, ega꞉walo Godote epono kuba osiyodilole mabuma꞉ iba꞉tamo wiya ikalame tanalo, me ebe netewa-kapiya tanalola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nanitabola, Godokono Uliyanate me opo epono kuba osiyodilole tanalo kapawokalilaemene mabu iba꞉te na nanitabokobi ka꞉midinina꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ega꞉walo ebete ebeno tuputupu okoli tanalo kapawokalimene, mabu tete tatalila na Tuputupudawate me opo atepate Nabiwi Godotamo walo ka꞉ka꞉tomamo, ebe tetelo la꞉ la꞉imano balida꞉mo na walo a꞉kunama꞉ema. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ega꞉walo Godote epono kuba osiyodilole mabuma꞉ wiya iba꞉tamo dikalaemene, ebeno Uliyanate ebe tanalo kapawokalimene, mabu Godote me opono Kuba Elawodubu Saitanatamo kuba wiya nanitabolo kikaemene, iyo, ebete ebe tanalo kosiyodiloma꞉ tabo iyalo iyatiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nanitabola, nagodolo tanalo bilibilinomo ba꞉pola꞉na la꞉tamo kiyawaoma꞉, wiyasiya me tetelo la꞉imano woki modoboa꞉ ebe iyaiya tanalo la꞉le uwatema꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wiyasiya Godokono nanitabo tanalo Awokalimidawate da꞉pemene, ebe Wade-talena Uliyanate la꞉ ebeno nanitabo gabodo dopolametate, la꞉ eba magatalelo tanalo bilibilinomo ebo kiyatawaomamota. Ebe tetelo ebete a꞉ka꞉tuwa꞉ ebeno wokilo a꞉ka꞉kiyawaomene, wiyasiya ebete kebe tanalo Nabiwigodone kolowionakole ebete ebe iyaiya tanalo kapiya la꞉tamo ba꞉kiyawaonakomene, ega꞉walo kebe tanalate me opamo da꞉pemaimioma꞉na꞉, ebe tanalate pelamea꞉no dopamo ebete la꞉tamo bawokalilamenakomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iyo, ebete me gabodo na ka꞉powalogonemene, mabu ebete naimano tepo magumuno tanalo uwatete la꞉tamo nanitabonomolo kapawokalilaemene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Numa꞉la꞉, Nabiwigodolo da꞉pola꞉na ebe tanalo bilibilinomo ebe naimanola, ebema꞉ ebeno Uliyanate modobola naimano tepo magumuno tanalo la꞉tamo awokalilaema꞉, nale la꞉ danaletama eba kunu.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ebene Ya꞉sute ebe waloma꞉tapiatamo tabo idi na꞉kegeni, “Tete tatalila la꞉le na la꞉imano balida꞉mo a꞉kunama꞉ema, ebene tete da꞉peso dolopoligomene la꞉le na walo ka꞉kunaemamota.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ebene ebeno waloma꞉tapino taneba magumulo epetapiate epetapiatamo gelanakiya, epetapiate epetapiatamo gelanakiya, ma kunu wageleniya, “Ya꞉sute me tabo beda꞉ma꞉ kegele, tete tatalila la꞉ na a꞉kunama꞉ema ebene tete da꞉pesolo la꞉ na walo ka꞉kunaemamota? Ega꞉walo ebete ebeno Nabiwitamo toma꞉ dege, me tabono magumu keba kunula꞉ka꞉? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ega꞉walo ale me tabo idino magumu iyatawa꞉, ebete 'tete da꞉peso' tabo dege, ebe tete keba kunula꞉ka꞉?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ebe tetelo iba꞉te ibino taneba magumulo Ya꞉sukono tabo magumuno tanaloma꞉ kebe iyaiya alateda꞉ tabo degelaniya, Ya꞉sute iyatawanate iba꞉tamo walo na꞉kegeni, “Iyo, nale tabo ma kunu kiyawaomo, tete tatalila la꞉le na a꞉kunama꞉ema, ebene tete da꞉pesolo la꞉le na walo ka꞉kunaemamota. La꞉ me tabono magumuma꞉ kegelawenama? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na la꞉tamo nani tabonomo gemo, na la꞉godone da꞉tomo ebe tetelo me opo epate kekalakalaoma꞉na꞉, wiyasiya la꞉le na eba liyanamelo tepo mibomibo kawonomamo ebo kiyatawaomamota. Wiyasiya numa꞉la꞉, tete da꞉peso da꞉petomene, la꞉imano tepo mibomibo tanalo olopoligote la꞉le na mabuma꞉ kawo kalakala walo ka꞉kelaemamota. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ebema꞉ me tanalo ebe lamitu kamiyalete gudu alaima꞉ temeteme dolowita keba kunula꞉ka꞉ eba kunula. Ebete gudu eba alaimilo kawo temeteme ebo kiyatawamene, wiyasiya ebeno gudu dawokalamene ebe tetelo ebegodolo kalakala kapiyate kitanamene, mabu ebeno temeteme olopoligo ega꞉walo ebeno gudute igilolo awokala. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","La꞉imano tanalo atumu, me tetelo la꞉le naimano to tanaloma꞉ tepo magumulo mibomibonomoma꞉ eda꞉onamata, wiyasiya nale tote la꞉tamo walo da꞉ka꞉pemo la꞉le kawo kalakala walo ebo ka꞉kelaemamota, ebe kalakala lumagi idite kubaima꞉ modoboa꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Na la꞉tamo nani tabonomo gemo, ebe kalakala egelate la꞉tamo demaigamene, ebe tetelo la꞉ la꞉imano modoboa꞉ tanaloma꞉ na walo a꞉ka꞉toweonama꞉ema. Ebe tetene wagilimite la꞉ naimano mailamo kebe iyaiya tanaloma꞉ Nabiwi Godoko da꞉toweoma꞉wenakoma, ebete a꞉ka꞉tuwa꞉ ebe tanalo la꞉tamo bikalamenakoma꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dopamo tetelo la꞉le naimano mailamo ebe ka꞉toweoma꞉wenakia꞉, wiyasiya me tetelo nale la꞉ analemata, modobola la꞉ ebe na꞉toweomenakiyala꞉, ebene la꞉ ebegodone wade tanalo delawa꞉wenakoma ebe gabodo la꞉imano kalakala tanalote kawonomamo bitananakomene.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ebene Ya꞉sute tabo idi na꞉kegeni, “Nale iyatulame oiamo me iyaiya tanalo la꞉tamo awokalilaemo, wiyasiya tete ka꞉pemene nale la꞉ oiamo walo a꞉kiyatulametama, ebe tetelo na naimano Nabiwino tanalo la꞉tamo awokalanomo ka꞉kiyawaomamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ebe egelalo nale Nabiwitamo la꞉imano modoboa꞉ tanaloma꞉ walo a꞉ka꞉towetoweamo, wiyasiya la꞉ a꞉ka꞉tuwa꞉ naimano mailamo ebe ba꞉toweomenakomata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Numa꞉la꞉, Nabiwite la꞉ nilakapolo nemalagidilolenata. Ebete ma kunu wagelena mabu la꞉le na nilakapolo eba malagidilonenalo, nale ebegodone da꞉piyamo ebe tanalo la꞉ nanitabokobi na꞉midinamata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Iyo, nanitabola, na Nabiwigodone me opamo piyamo, wiyasiya me ebe tetela, nale me opo atepate Nabiwitamo walo ka꞉ka꞉tomamo.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ebene Ya꞉suko waloma꞉tapiate ebetamo negelaniya, “Kalakala kawonomola, a me tabo modobolo laema꞉ mabu a꞉ma꞉ atamo iyatulame oiamo ka꞉kiyawawena꞉, awokala kiyawaonata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Iyo, ka꞉lo idokolo a iyatawaoma꞉ a꞉ma꞉ tanalo bilibilinomo iyatawanomolata, ebema꞉ lumagi idite tanalo idima꞉ a꞉ma꞉ alateda꞉no a꞉ma꞉ ebeno tepo magumuno woki iyalo kiyatawama꞉ta. A me tanalone nanitabokobi na꞉midinama꞉, a꞉ma꞉ Godogodone piyata!” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ebene Ya꞉sute ibino tabo eba wiyanalo negeni, “Ka꞉lo idokolo la꞉ na nanitabolo nanitabokobi na꞉ka꞉midina꞉wenama? ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tete ka꞉pemene, iyo, ebe na꞉pe, la꞉ nagodone la꞉imano iyaiya motamo alautiawete, ebene na a꞉ka꞉tuwa꞉ ka꞉lutamo. Ebe tetelo nago dokolina ebe Nabiwi ebe kapiyate na akatepanemene, ebete nago ka꞉lutamene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ebema꞉ numa꞉la꞉, nale me iyaiya tanalo la꞉tamo a꞉kiyawaomo, mabu na ubila la꞉le nagodolo eba ilukulinalo naimano milote la꞉godolo kitanama꞉. Nanitabola, me opolo la꞉ kawokawo temeteme biyatawaonakomata, wiyasiya nekalakalala꞉! La꞉ akotoletoleala꞉ mabu naimano elawote me opono elawo iyalo anakapumi.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ya꞉sute me tabo kiyawao dolopoligoni, ebe tetelo ebete Godokono Unu Duliyomolamo eba melenalo towetowe tabo ma kunu geni, “Nabiwi, tete a꞉pe. Modobola a꞉ma꞉le na a꞉imano gudu eba walogonelo naimano wade tanalo nawokalima꞉, ebema꞉ na atumu a꞉ma꞉ eba walogolo a꞉imano wade tanalo kawokalimamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nanitabola, iyalo tetelo a꞉ma꞉le kawo elawo a꞉imano Gudutamo ikamiyata, ebema꞉ me opolo epo bilibilinomate ebetamo nanitabolo ka꞉tudila꞉oma꞉na꞉, ega꞉walo a꞉ma꞉le ibi magumulo kebe epo ebetamo kikama꞉wiyala, ibinomate uwomua꞉ igilo ebegodone kelaema꞉na꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ebe uwomua꞉ igilono tanalo ma kunula. Epate a꞉ma꞉ nani Godo kapiyama꞉ miditate a꞉imano tanalo ebo kiyatawaoma꞉na꞉, ega꞉walo atu tetelo iba꞉te na Ya꞉su Kelisokono tanalo ka꞉kiyatawaoma꞉na꞉, na ebe a꞉ma꞉le dapalibona꞉wiyala ebe dawala. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ebema꞉ nale me opamo pea꞉no a꞉ma꞉le iyalo natamo kebe iyaiya woko kikanamona꞉wiyala, nale ebe woko bilibilinomo opoliyalimo, iyo, me gabodo nale a꞉ma꞉ eba walogolo a꞉imano wade amama tanalo epatamo awokalimo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Nabiwi, me opo osiyodiloa꞉ tetelo nale a꞉ma꞉go eba okolinalo agodolo ditanami, modobola a꞉ma꞉le ebe elawo alamo na eba pukuinamelo a꞉imano ololo apulo na nowalogoniye.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ebene Ya꞉sute ebeno towetowe tabo moga꞉melo walo na꞉kegeni, “Nabiwi, me opolo a꞉ma꞉le natamo dikanama꞉wia iba꞉te a꞉imanoma꞉ eda꞉iya, ebema꞉ nale a꞉imano tanalo iba꞉tamo dawokalimo, iba꞉te a꞉imano tabamo a꞉tudila꞉iya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ebema꞉ ka꞉lo ibi iyatawala, a꞉ma꞉le iyalo natamo kebe wadewade tanalo kikanamona꞉wiyala ebe tanalo bilibilinomate a꞉ma꞉godone pelamiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Iyo, a꞉ma꞉le natamo dikanamona꞉wiyala ebe tabono iyaiya tanalo nale iba꞉tamo ikalamolimo, ebene iba꞉te nanitabolo uwatete ebo iyatawaiya nale a꞉ma꞉godone da꞉piyamo ebe tanalo, ega꞉walo a꞉ma꞉le na dapalibona꞉wiyala iba꞉te ebe tanalo nanitabokobi na꞉midina. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ebema꞉ na ibi towetowe tabamo a꞉ma꞉tamo na꞉powadipalatelenamo. Nale a꞉ma꞉ me opo epo epetapino tanaloma꞉ ka꞉petoweometana꞉, wiyasiya a꞉ma꞉le me tetelo natamo kebe kapiyakapiya epo kikanamona꞉wia ibi kapiyano tanaloma꞉ toweomenamata mabu ibi a꞉imanola. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Iyo, naimano tanalo bilibilinomo a꞉imanola ega꞉walo a꞉imano tanalo bilibilinomo naimanola, ebema꞉ me waloma꞉tapido a꞉ma꞉le na me opolo owalogoniata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","12","“O naimano Wade-talena Nabiwi, tete tatalila na me opo katepamo, wiyasiya me opo ebe naimano waloma꞉tapino ilukuli baila. Ebema꞉ a netewapiate kapiya wokilo keba kunu kokolionama꞉, iba꞉te eba kunu gelebadiago kapimiya kilukulinama꞉ modobola a꞉ma꞉ a꞉imano elawo mailamo ibi wadenomamo nulameniye. Ebe elawo mailo a꞉ma꞉le natamo iyalo ikanamiyata, ega꞉walo nale dopamo iba꞉go eba okolinalo ebe mailamo ibi wadenomamo buiyalatelenaimo. Nanitabola, ibi naimano buiyalatele magumulo kapiya idite kalatidia꞉, wiyasiya a꞉imano Buka apuno tabote nanitaboma꞉ keda꞉ma꞉ kapiya dubunomote kubakobi ebema꞉ olowi, a꞉ma꞉le Ela Opamo dopamo potele toma꞉ degeawiyala, me ebe dubula. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Tete tatalila nale a꞉ma꞉tamo ka꞉pemamo, iyo, nale me iyaiya towetowe tabo me opolo ebema꞉ kiyawaonamo, mabu na ubila naimano kawo kalakalate naimano waloma꞉tapino tepo magumulo netabokaomene. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nanitabola, nale a꞉imano wade tabo iba꞉tamo dikalaimo, ebe mabuma꞉ me opo epate iba꞉tamo na꞉dowaona. Dopamo tetelo iba꞉te me opo epago kapiyama꞉ eda꞉onamiya, wiyasiya iba꞉te oli igilo delawiya iba꞉te iya epoma꞉ ebo eda꞉iya, ebema꞉ ka꞉lo na keba kunu kokolinamo ibi eba kunula, ibi ega꞉walo na, a me opo epoma꞉ nanitabolo keda꞉ona꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“O Nabiwi, a꞉ma꞉le ibi me opone gito wagailima꞉ ka꞉toweometana꞉, wiyasiya nale a꞉ma꞉ na꞉toweomenamata, iba꞉te me opolo eba ilukulinalo a꞉ma꞉le ibi wadenomamo ka꞉buiyalatela꞉wenama꞉ Saitanate ibi kubailamekapoma꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nanitabola, na me opo lumagia꞉, ega꞉walo ibi atumu me opo epoma꞉ keda꞉ona꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Na iyatawala a꞉imano iyaiya tabono tanalo nanitabonomola, ebema꞉ modobola ebe nani tabamo a꞉ma꞉le ibi talenanomoma꞉ na꞉midiliye iba꞉te a꞉imano woko kosiyodilonama꞉. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ebene a꞉ma꞉le na me opamo keba kunu kapalibona꞉wiyala, nale ibi atumu eba kunu me opo kawonomamo kakanalibolemamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Iyo, nanitabola, ibi mabuma꞉ na a꞉ka꞉tuwa꞉ na talenama꞉ midite naimano ape niyatinamo a꞉imano woko kapiya kosiyodilonama꞉, mabu eba kunu iba꞉te atumu a꞉imano talena wokopima꞉ ka꞉keda꞉oma꞉na꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ebene Ya꞉sute ebeno towetowe tabo moga꞉menalo walo na꞉kegeni, “Nabiwi, nale a꞉ma꞉ me waloma꞉tapi kapiyama꞉ ka꞉toweometana꞉. Iba꞉te a꞉imano tabo iyaiya epatamo eba na꞉kiyawaolo, piyate ebe tabo olowite nanitabokobi da꞉midima꞉na꞉, nale ibi mabuma꞉ atumu ka꞉petoweomenamata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O Nabiwi, a꞉ma꞉le na magumulo keba kunu kokoliawena ega꞉walo nale a꞉ma꞉godolo keba kunu kokolinamo, modobola ibi bilibilinomate eba kunu kapiyama꞉ eba eda꞉onalo agodolo nilukulinama꞉na꞉. Ebene me opo epate ebe tanalo duima꞉na꞉, iba꞉te nanitabokobi ka꞉midima꞉na꞉ a꞉ma꞉le na dapalibona꞉wiyala ebe tanalo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nanitabola, a꞉ma꞉le na walogonelo kebe elawo alo iyalo kikanama꞉wiyala, ebe alo nale iba꞉tamo ikalaimo, ebema꞉ iba꞉te epo kapiyanomoma꞉ neda꞉oma꞉na꞉, ale kapiyanomoma꞉ keba kunu keda꞉nama꞉ eba kunu. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nale iba꞉godolo bokolinamo ega꞉walo a꞉ma꞉le nagodolo bokolinata, ebema꞉ modobola ibi bilibilinomate me gabodo epo kapiyanomoma꞉ neda꞉onama꞉na꞉. Ebene me opo epate ibino kapiyama꞉ eda꞉ tanalo duima꞉na꞉, iba꞉te me tanalo netewa ebo kiyatawaoma꞉na꞉, a꞉ma꞉le na dapalibona꞉wiyala ebe tanalo, ega꞉walo a꞉ma꞉le na nilakapolo keba kunu kemalagidilona꞉wena ibi atumu kawonomamo eba kunu ba꞉kemalagidilolenama꞉ta. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O Nabiwi, a꞉ma꞉le iyalo tetelo natamo kebe iyaiya epo bilibilinomo kikanama꞉wiyala, na ubila iba꞉te nale dokolinamo ebe duliyomololo nago kapimiya bilukulinama꞉na꞉, ebene a꞉ma꞉le na walogonelo kebe elawo alo dopamo kikanama꞉wiyala, iba꞉te ebe alo ebolo ka꞉nuima꞉na꞉. Nanitabola, me opo osiyodiloa꞉no a꞉ma꞉le na dopamo nilakapolo nemalagidilonenamiyata, ebe mabuma꞉ a꞉ma꞉le na walogonelo a꞉imano elawo alo natamo ikanamiyata. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“O Tuputupu Nabiwi, me opo epate a꞉imano tanalo kiyatawaona꞉, wiyasiya nale a꞉imano tanalo iyatawala, ega꞉walo naimano waloma꞉tapi atumu iyatawala a꞉ma꞉le na dapalibona꞉wiyala ebe tanalo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Iyo, nale a꞉imano tanalo me dopo waloma꞉tapiatamo awokalimo ega꞉walo ebe atu tanalo uwomua꞉ tetelo walo bakawokaliminakomo, mabu me gabodo a꞉ma꞉le na nilakapolo demalagidilona꞉wena ebe tanalote ibi bilibilinomo magumulo nitanamene ega꞉walo nale iba꞉godolo bokolinamo. “O Nabiwi, naimano waloma꞉tapi bilibilinomono tanaloma꞉ me naimano towetowe tabo uwomula. Taula.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ebene Ya꞉sukono towetowe tabo Godotamo kiyawao dolopoligoni, ebete ebe waloma꞉tapiago tonate Kidolono gowo na꞉iwanate olibi kewakewa pali idi magumamo gito nopegani. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ya꞉suko anakapumipino kotamo iyatidawa Yudasiko, ebete ebe opo iyatawala, mabu dopamo Ya꞉sute tete bilibilinomo epetapilo ebeno waloma꞉tapiago ebamo da꞉tolamenakiya ebo naladabutinakiya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ebema꞉ ebe idokolo Godotamo kalimagono ikameopino ununomo watowatopi ega꞉walo Pa꞉lisi tanebapi, iba꞉te Godokono Moto atila꞉pi ega꞉walo gowelaopi dubu epetapi naliboleniya. Ebene ebe dubate ibino gowelaono inamabu ega꞉walo wuiki alo uwatenate, Yudasite ibi ebo magataleni Ya꞉sute dopamo da꞉toni ebe baiamo. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ebe tetelo Godokono ubi tanalodo kebe tanalate Ya꞉sutamo da꞉pemaimioma꞉na꞉, ebe tanalo bilibilinomate pelamea꞉no Ya꞉sute dopamo eba iyatawanalo, ebete ebe gowelaopi dubatamo awokala pemaiganate ibi napanaleni, “La꞉ poko kowadiawenama?” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yudasite ebe dubago eba utinalo iba꞉te nowaminiya, “A Ya꞉suko Nasalete duliyomolodawa wadinama꞉.” Ebene Ya꞉sute iba꞉tamo negeni, “Na ebe ebetela,” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","wiyasiya iba꞉te ebeno ‘na ebe ebetela’ tabo dolowiniya, ebe tetelo ibi bilibilinomate walogabo apuamo eba ila꞉nalo opamo gito gudiniya. ");
INSERT INTO knv_fly_river_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ebene Ya꞉sute ibi walo nakalateda꞉leni, “La꞉ poko kowadiawenama?” Iba꞉te nowaminiya, “A Ya꞉suko Nasalete duliyomolodawa wadinama꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ya꞉sute iba꞉tamo walo wiya tabo na꞉kegeni, “Nale la꞉ analemata, na ebe ebetela. La꞉le na nanitabolo dowadina꞉wenama modobola na nelawena꞉la꞉, wiyasiya na waloma꞉enepi na꞉miyapala꞉ iba꞉te ibino iyaiya tanalamo gito ka꞉tolaema꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ebete me tabo negeni, ebete dopamo atu idoko tetelo Godotamo degeni ebe tabote nanitaboma꞉ keda꞉ma꞉, mabu dopamo ebete towetowe tabo ma kunu geni, “Nabiwi, a꞉ma꞉le natamo dikanama꞉wia ebe epo bilibilinomo magumulo nale kapiya idi katutia꞉.” ");
INSERT INTO knv_fly_river_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ebe tetelo Saimono Pitate ebeno gowelaono gili magoba꞉nate dubu 