﻿USE sofia;
DROP TABLE IF EXISTS sofia.knv_aramia_vpl;
CREATE TABLE knv_aramia_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES knv_aramia_vpl WRITE;
INSERT INTO knv_aramia_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ya꞉su Kelisoko ba꞉ Da꞉ibidikono eyono gudula, ba꞉gala Da꞉ibidiko ba꞉ A꞉ibalahamakono galane dawala, ba꞉bene ba꞉moe ba꞉ Ya꞉sukunu mabu tawakalubino mahiloeno komola. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","A꞉ibalahamako tetene tupuimiti Da꞉ibidiko teta꞉mo puluhuku, Ya꞉sukunu mabu tawakalubino komo ba꞉ma ka꞉nala — A꞉ibalahamakono gudu Aisa꞉ketela. Aisa꞉kekono gudu Ya꞉ikobotela. Ya꞉ikobokono gudu Yudatela, huiyatiya Yudako kapiya kododiya꞉ha꞉, ebeno komo nani ekaki eba꞉go nemedenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudakono gugudi netewa ba꞉ Peleseko ba꞉gala Silako, ibino menoko ba꞉ Ta꞉imatela. Pelesekono gudu Hesalonatela. Hesalonakono gudu Lamatela. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamakono gudu Aminadabatela. Aminadabakono gudu Nasonatela. Nasonakono gudu Samonotela. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Samonokono gudu Bowasetela, ba꞉be guduino menoko ba꞉ La꞉iha꞉batela. Bowasekono gudu Obedatela, ba꞉be guduino menoko ba꞉ Lutitila. Obedakono gudu Yesitila. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesikono gudu Da꞉ibiditila, ebete Isalaela hopoeno Ko Gawadubuma꞉ eda꞉nami. Ba꞉bene Da꞉ibidiko tetene tupuimiti Yekonayako teta꞉mo puluhuku, Ya꞉sukunu mabu tawakalubi ba꞉ ba꞉moi ba꞉bi Yunapi Koko Gawadubula, ibino mahiloeno komo ba꞉ma ka꞉nala — Da꞉ibidikono gudu Solomonotela, ba꞉be guduino menokote dopamo Ulayakono kamenama꞉ eda꞉nami. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonokono gudu Lihobaumatela. Lihobaumakono gudu Abayatela. Abayakono gudu A꞉isatela. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","A꞉isakono gudu Yehosapatatela. Yehosapatakono gudu Yolamatela. Yolamakono gudu Usayatela. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usayakono gudu Yautamatela. Yautamakono gudu A꞉ihasatela. A꞉ihasakono gudu Hesekayatela. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekayakono gudu Ma꞉na꞉satela. Ma꞉na꞉sakono gudu A꞉monatela. A꞉monakono gudu Yausayatela. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yausayakono gudu Yekonayatela, huiyatiya ebe kapiya kododiya꞉ha꞉, ebeno komo ekaki eba꞉go nemedenama꞉. Yekonayako tetelo Ba꞉baloni alaholohopa꞉te pelamete Isalaela hoponapi heloamo puwatete ibino Ba꞉baloni hoponomamo ba꞉bo magataliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ba꞉bene alaholohopa꞉te ibi Ba꞉baloni hopamo da꞉magataliya꞉, ba꞉ba tetene tupuimiti Yausepeko teta꞉mo puluhuku, Ya꞉sukunu mabu tawakalubino komo ba꞉ma ka꞉nala — Yekonayakono gudu Siyatiyelatela. Siyatiyelakono gudu Selababelatela. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selababelakono gudu Abiyudatela. Abiyudakono gudu Elayakimitila. Elayakimikono gudu A꞉isotela. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","A꞉isokono gudu Sa꞉idokatela. Sa꞉idokakono gudu A꞉ikimitila. A꞉ikimikono gudu Eliyudatela. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudakono gudu Eliyesatela. Eliyesakono gudu Ma꞉ta꞉natela. Ma꞉ta꞉nakono gudu Ya꞉ikobotela. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ya꞉ikobokono gudu Yausepetela. Yausepeko ba꞉ Ma꞉likono awila ba꞉gala Ma꞉liti Ya꞉suku balahimiya꞉, ba꞉be gudu tawakaluba꞉te Godokono Oemedawa Kelisoma꞉ ka꞉minaka. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ba꞉bema꞉ Ya꞉sukunu mabu tawakalubino komo ba꞉ma ka꞉nala. A꞉ibalahamako tetene tupuimiti Da꞉ibidiko teta꞉mo puluhuku 14 tawakalubila, ba꞉gala Da꞉ibidiko tetene tupuimiti alaholohopa꞉te tawakalubi Ba꞉baloni hopamo da꞉magataliya꞉ ba꞉ba teta꞉mo puluhuku 14 tawakalubila, ba꞉gala Ba꞉baloni tetene tupuimiti Kelisoko teta꞉mo puluhuku 14 tawakalubila. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ba꞉bene Ya꞉su Kelisote keba ka꞉na ka꞉hawakaluya꞉, ba꞉moe ba꞉be komola. Ebeno menoko Ma꞉liko Yausepetamo na꞉galuimiya꞉, ba꞉bene iba꞉te kapiyama꞉ eda꞉heno, Ma꞉liti dopamo iya꞉tawuya꞉ ebete Godokono Gobogobamo lamituma꞉ eda꞉te gudu kalahimima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ebeno awi Yausepeko ba꞉ hido tuputupudawanomola. Ba꞉bema꞉ ebete Ma꞉likoba꞉ kapiyama꞉ eda꞉heno ebete ebeno lamituma꞉ eda꞉ komo diya꞉tawuya꞉, ba꞉ba tetelo ebe ubila Ma꞉liko gelebadia꞉go ibuki, mabu ebe ubihinola tawakalubino holoholo hapulu ebetamo hilopo ikame. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Huiyatiya ebete ba꞉moe komo ba emalagidolo Kodawa Godokono nopodawate hiyo gabodo ebetamo uluhukunate na꞉goeniya꞉, “Da꞉ibidikono hogo Yausepe, ama꞉le Ma꞉liko amia꞉no kamenama꞉ eda꞉ma꞉ akatoletola꞉la꞉, mabu ebeno tepo ipuwalo demedena ba꞉be gudu Godokono Hido-talona Gobogobote ebetamo ikami. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iyo, ebete dubu gudu kalahimima꞉ne ba꞉bene ama꞉ ebeno mahilo Ya꞉suma꞉ na꞉ka꞉miya꞉, mabu ebete ebeno tawakalubi ibino hiya꞉hiya꞉ kuba ododili ipuwane uwatete ibino ka꞉ka꞉ komula꞉lelamema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ba꞉bene ba꞉moi hiliyonomo komate ikulihuya꞉, Kodawa Godote ebeno ukui hawakalimidawa ipuwado da꞉goiya꞉ ba꞉be tabote hibima꞉ keda꞉ma꞉, iyo, ya꞉lo tetelo ebete tabo ba꞉ma ka꞉na goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Bohelete lamituma꞉ eda꞉te dubu gudu kalahimima꞉ne, ba꞉bene iba꞉te ebeno mahilo Ima꞉nuwelama꞉ koka꞉mima꞉na꞉.” Buka ka꞉lamiholedawa, wadiyala ama꞉ niya꞉tawa ba꞉moe Ima꞉nuwela mahiloeno ipuwa nitana ‘Godote ago bemedena.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ba꞉bema꞉ Yausepete u wata bahini mahiganate Godokono nopodawate ebe bada tabo ka꞉goemeniya꞉, ebete ba꞉be tabamo papamiwatate Ma꞉liko ebeno kamenama꞉ ba꞉bo lawiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Huiyatiya Ma꞉liti gudu Ya꞉suku alahimihino Yausepete dopamo eba꞉go kapiyama꞉ kediya꞉ha꞉, ba꞉bene Ma꞉liti Godokono gudu dalahimiya꞉ ba꞉ba tetelo Yausepete ebe Ya꞉suma꞉ ba꞉bo ka꞉miya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Heloditi Yudiya hopolo Ko Gawadubuma꞉ ba eda꞉na, eta dulu Ya꞉suti ba꞉be hopoeno Beteleheme habalo ba꞉bo hawakalaniya꞉. Ba꞉bene komo hegelate da꞉petohuya꞉, ba꞉ba tetelo mululu oloki ka꞉lamiholepi dubate hegelate da꞉puluhukunako ba꞉ba hapuni muhulu hopone pelamiya꞉ Yudiya hopoeno ko haba Yelusalemamo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Iba꞉te ba꞉ma ka꞉na pega꞉luya꞉, “Keka꞉ Yu tawakalubino Ko Gawadubuma꞉ eda꞉ma꞉ da꞉hawakalui ba꞉be gudu? Ale ebeno oloki aeno muhulu hopolo umiti ebe adikumima꞉ pelamema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ba꞉bema꞉ Ko Gawadubu Heloditi ba꞉moe komo duliya꞉ ebeno tepo ipuwalo ukui bilibilinomoma꞉ ediya꞉, ba꞉gala Yelusalema ko habalo demedehonama꞉ ibi hiliyonomate atumu ukui bilibili komo ba꞉bo kalawiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ba꞉bene Godotamo hawa꞉goeno ikamehopino hununomo watowatopi ba꞉gala Godokono Tutumu iya꞉tulamepi, Heloditi ibi hiliyonomo ebetamo ka꞉lamiti nalateda꞉liya꞉, “La꞉eno ukui kebanala꞉ka꞉? La꞉ Yu tawakalubino Ko Gawadubu Kelisote kebe habalo na꞉ka꞉hawakalamene?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iba꞉te ebetamo na꞉huiyuya꞉, “Ebete Yudiya hopoeno Beteleheme habalo kohawakalama꞉ne, mabu Godokono ukui hawakalimidawate Godokono Bukamo tabo ba꞉ma ka꞉na miya꞉tiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Beteleheme haba Yudiya hopolo ditana, Yudiya hopoeno koko gawadubu ipuwalo ama꞉ deha꞉potoha꞉, mabu ama꞉ ipuwane tawakalubino watodawate kuluhukuma꞉ne, naeno Isalaela tawakalubi ebete bulamenamene.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ba꞉bene gapogapo tetelo Ko Gawadubu Heloditi oloki ka꞉lamiholepi diya gabodo ebetamo ba꞉bo ka꞉laminiya꞉, mabu ebe ubila olokiti keba tetelo kuluhukuniya꞉le iba꞉godone ba꞉be tete kiya꞉tawanama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ebete ba꞉be komo lawenate ibi ba oelamena na꞉goelameniya꞉, “La꞉ tolamete Beteleheme habalo gudu hidonomamo nohowaditi da꞉numima, wadiyala la꞉ gala kapelamete na na꞉pikiyanamiya꞉la꞉, ba꞉bene nale atumu katote ebe kakanadikumima꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ba꞉bema꞉ oloki ka꞉lamiholepa꞉te Helodikono tabo ulinate ba꞉ dito tolameniya꞉. Ba꞉bene iba꞉te ba tolamena, hegelate da꞉puluhukunako ba꞉be muhulu hopolo dopamo duminiya꞉, ba꞉be atu oloki gala na꞉kanuminiya꞉. Ba꞉ba tetelo iba꞉te oloki da꞉kanuminiya꞉ kalakala ba꞉bo nelaweniya꞉, o kalakala bada konomola꞉ka꞉, ba꞉bene ba꞉be olokiti ibi dopalamenate ba tona, guduti kebolo ka꞉kapitanuya꞉ olokiti ba꞉be tetenomamo dito nutiniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba꞉bema꞉ iba꞉te ba꞉be genama guamo nogomonate gudu ba꞉gala ebeno menoko Ma꞉liko ba꞉bo nulameniya꞉. Ba꞉ba tetelo iba꞉te ibino pupamo ba ahidina gudutamo papamila꞉nate ebe ba꞉bo adikuminiya꞉, ba꞉bene iba꞉te dopamo mani kokonomamo duwatehuya꞉ ba꞉bi malemale ilina uluhukulatelenate gudutamo ba꞉bo ikamehoniya꞉, ba꞉ma ka꞉na golodo mani, ape abutimino hido nibo ilina, ba꞉gala eta hido nibo ihi ilina. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ba꞉be dulu Godote hiyolo ibi na꞉goelameniya꞉, “La꞉ Ko Gawadubu Heloditamo gala akatolama꞉la꞉,” ba꞉bema꞉ eta hegelalo iba꞉te tupuimiti eta gabodo ibino hoponomamo ba꞉bo tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ba꞉bene eta dulu Kodawa Godokono nopodawate Yausepetamo hiyolo puluhukunate ebe na꞉pegoemeniya꞉, “Wadiyala ama꞉ tiyonomo mahigate, gudu ba꞉gala ebeno menoko uwatete Isipiti hopamo nalahuta꞉la꞉. La꞉ ba꞉bolo ba nemedena, keba tetelo nale la꞉ da꞉kakiyalamema la꞉ ba꞉mamo gala ba꞉bo kakapema꞉nemata, mabu tete tatalila Heloditi gudu anakapumima꞉ Beteleheme habalo kopohowadima꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ba꞉ba tetelo Yausepete mahiganate gudu ba꞉gala ebeno menoko uwatenate Isipiti hopamo to gabodo ba꞉bo toniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ba꞉bema꞉ iba꞉te Isipiti hopamo nikuliti ba꞉bolo nemediya꞉ Ko Gawadubu Helodikono hoe teta꞉mo. Ba꞉moe komote ba꞉ ba꞉ma ka꞉na uluhukuya꞉ Kodawa Godote ebeno ukui hawakalimidawa ipuwado da꞉goiya꞉ ba꞉be tabote hibima꞉ keda꞉ma꞉, iyo, ya꞉lo tetelo ebete tabo ba꞉ma ka꞉na goiya꞉, “Naeno guduti Isipiti hopone kopema꞉ nale ebe koka꞉mima꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ba꞉bene oloki ka꞉lamiholepi dubate Helodiko ha꞉da damihomiya꞉, ebete ba꞉moe komo iya꞉tawate konomamo maubuya꞉. Ebe ubi konomola gudu Kelisoko anakapumi, ba꞉bema꞉ ebete Beteleheme haba ba꞉gala tamelo demedenama꞉ ba꞉bi tawakaluba꞉tamo alaholohopi dubu boelamiya꞉, iba꞉te tolamete netewa gogo tete dubu gugudi ba꞉gala a꞉lia꞉li gugudi hiliyonomo konanakapulamema꞉. Ebete ba꞉ma ka꞉na ododiya꞉ mabu oloki ka꞉lamiholepi dubate ebe a꞉kiyamiya꞉ ko olokiti ya꞉lo netewa gogo tetelo dopamo uluhukuniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ba꞉moe komote ba꞉ ba꞉ma ka꞉na uluhukuya꞉ Kodawa Godote ebeno ukui hawakalimidawa Yelemayako ipuwado da꞉goiya꞉ ba꞉be tabote hibima꞉ keda꞉ma꞉, iyo, ya꞉lo tetelo ebete tabo ba꞉ma ka꞉na goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“La꞉ima habanapa꞉godone ihimi konomote uluhuku, mabu Lesula꞉te ebeno gugudi bela꞉lamena! Iyo, ebete howela꞉go dihina kekelamenaha꞉, mabu ebeno gugudi hiliyonomate ba꞉ a꞉ha꞉laha.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Galane tetelo Heloditi da꞉hoiya꞉, Yausepete Isipiti hopolo ba emedena Godokono nopodawate hiyo gabodo ebetamo ba꞉bo uluhukuniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nopodawate ebe na꞉goemeniya꞉, “Ama꞉ gudu ba꞉gala ebeno menoko uwatete, la꞉ Isalaela hopamo na꞉kawilala꞉la꞉, mabu gudu anakapumima꞉ dewagelenama꞉ iba꞉te a꞉ha꞉lahuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ba꞉bene Yausepete mahigate gudu ba꞉gala ebeno menoko uwatete Isalaela hopoeno pe gabodo gala na꞉kapiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Huiyatiya Yausepete eta komo ba꞉ma ka꞉na uliya꞉, ka꞉lo Helodikono gudu Akeleyasiko ebete ebeno nabiwino haba lawete Yudiya hopolo Ko Gawadubuma꞉ edi. Ba꞉bema꞉ Yausepete Yudiya hopolo nemedema꞉ da꞉toletoliya꞉, ba꞉ba tetelo Godote hiyo gabodo eta tabo ba꞉ma ka꞉na poemiya꞉ ebete Ga꞉lili hopamo kotoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ba꞉bene iba꞉te Ga꞉lili hopoeno Nasalete habamo nikuliti ba꞉bo nemediya꞉, mabu ya꞉lo tetelo Godokono ukui hawakalimipa꞉te na꞉ga꞉luya꞉, “Tawakaluba꞉te Kelisoko Nasaletenapima꞉ koka꞉mima꞉na꞉,” ba꞉bema꞉ ba꞉moe komote ba꞉ ba꞉ma ka꞉na uluhukuya꞉ Kodawa Godokono tabote hibima꞉ keda꞉ma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ba꞉bene komo gogo da꞉petolamiya꞉, ba꞉ba tetelo Yoneko tawakalubi beyamo wadulateledawate pete Yudiya hopoeno dito hopolo Godokono tabo ba꞉ma ka꞉na polamagiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“La꞉eno kubane nohobila꞉la꞉, mabu Godote Ko Gawadubuma꞉ deda꞉na ba꞉be komote ba꞉ na꞉pe!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ba꞉ hibila, Godokono ukui hawakalimidawa Aisayate dopamo Yonekono pe komoma꞉ tabo ba꞉ma ka꞉na goiya꞉, “Lumagiti dito hopolo tabo ba꞉ma ka꞉na ibulu kopegoema꞉ne, ‘Kodawoeno gabo na꞉hiduima꞉la꞉, ebeno gabo na꞉tuputupuima꞉la꞉!’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ba꞉ba tetelo Yonekono emede komo komopino emede komo huiyaha꞉, mabu ebete ka꞉molo-goe ipo kuba kaliko kau-goe tama kamaka꞉go pulinakui, ba꞉gala ebeno baa꞉ wawaka ba꞉gala molo benahanakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ba꞉bema꞉ Yelusalema ko habanapi ba꞉gala komo Yudiya hoponapi ba꞉gala Yodane Tuli hapulu demedehonama꞉, ibi hiliyonomate Yonetamo tolamiya꞉ ebeno tabo ulihoma꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ba꞉bene iba꞉te ibino kuba da꞉nehawakalilameholiya꞉, ebete ibi Yodane Tulilo beyamo ba꞉bo wadulateliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ba꞉ba tetelo Pa꞉lisi kapiyuimipi ba꞉gala Sa꞉diyusi kapiyuimipi, komo ibi hiliyonomate Yonetamo tolamiya꞉ ebete ibi beyamo kowadulatelema꞉, huiyatiya Yonete ibi ulamete iba꞉tamo na꞉goiya꞉, “La꞉ bu kalulata! La꞉ pote ka꞉goelamiti beyamo wadulatelema꞉ da꞉pelamema, aba꞉, Godokono konomo mauba komote la꞉tamo a꞉kapa꞉mene? Ao, kopema꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","La꞉eno tepo ipuwa hiya꞉ma꞉ da꞉midilima, wadiyala la꞉ la꞉eno hibi komo hawakalimima꞉ hidohido komo nododila꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","La꞉ ha꞉kiya la꞉eno ukuilo ba꞉ma ka꞉na akaga꞉lanakala꞉, ‘A modobola mabu A꞉ibalahamako ba꞉ aeno iniwa nabiwila.’ Ao, la꞉ a꞉kamodobamata! Na la꞉tamo hibi tabo begoemo, Godogodolo helo bitana ebete ba꞉moi nakolamo A꞉ibalahamakono gugudi kododilimima꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ba꞉bema꞉ ka꞉lo Godote ebeno kabi adi, hiliyonomo nolohoha꞉ gao keha ebete luhuti koa꞉mo kiya꞉hekema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Komo la꞉ la꞉eno kubane dohobila꞉huima, nale ba꞉be komo kohawakalimima꞉ la꞉ beyamo wadulatelemata. Huiyatiya eta lumagino helo konomote naeno helo na꞉gogolona, ba꞉bema꞉ na hidoenoha꞉ ebeno nato ukulaleno beya agatamema꞉. Ebete naeno gala hapuni ba꞉pena, ba꞉bene ebete la꞉ Godokono Gobogobamo ba꞉gala ebeno koa꞉mo kopewadulatelema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iyo, ebete witi-laisoeno nonoka tama꞉mo miya꞉teno ilina a꞉lawi, ba꞉bene ebete witi-laisa nahoeno ebeno genama guamo ba miya꞉te nonoka koa꞉mo ba꞉bo kiya꞉hekema꞉ne, ba꞉be koete itana tetelo na꞉woena, a꞉kaha꞉gale.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ba꞉bene Ya꞉suti Ga꞉lili hopone Yodane Tula꞉mo Yonetamo piya꞉, ebete ebe beyamo kadutima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ba꞉ba tetelo Yonete na꞉goiya꞉, “Ama꞉le na beyamo adunatene modobola, huiyatiya mabu keka꞉ ama꞉ ba꞉be komo nagodone lawema꞉ da꞉pa꞉? Modoboha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Huiyatiya Ya꞉suti ebetamo na꞉goiya꞉, “Modobola a kododima꞉nema꞉, mabu Godokono tuputupu gabodo tolame ipuwalo ebete a hiliyonomo komo ododilima꞉ da꞉kiyaa꞉menakomene, ale ubiha꞉ma꞉ a꞉keda꞉hanakama꞉.” Ba꞉ba tetelo Yonete Ya꞉sukunu tabamo papamiwatate ba꞉bo ododiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ba꞉bene Ya꞉suti beyane ba podolo, ba꞉ba tetenomolo Godote ebeno Hunu Haba a꞉hiya꞉midutalo ba꞉bo umiya꞉, ba꞉gala ebete eta komo ba꞉ma ka꞉na kumiya꞉, Godokono Gobogobo gimai hola keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉na pihitigate ebetamo dito pemediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ba꞉ba tetelo tabote Hunu Habane ba꞉ma ka꞉na pihitiguya꞉, “Ba꞉moe ba꞉ naeno kapiya Gudunomola. Na ebetamo na꞉kalakalutamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ba꞉bene Godokono Gobogobote Ya꞉suku dito hopamo na꞉magatuya꞉, mabu ebe ubila Saitanatamo tete ba꞉bolo nikamete, ebete Ya꞉suku kuba gabamo kemogabuimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ba꞉bene Ya꞉suti dito hopolo 40 hegela ba nemede, ba꞉be tete ga꞉ga꞉nomolo baa꞉ kananakuiha꞉, ba꞉bema꞉ ebete baa꞉ma꞉ kape komo ba꞉bo iya꞉tawuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ba꞉bene Saitanate ebetamo uluhukuti ebe na꞉goemiya꞉, “Ama꞉ Godokono hibi Guduma꞉ deda꞉na, ba꞉moi nakola baa꞉ma꞉ na꞉midila꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ya꞉suti ebeno tabo ba huiya na꞉goiya꞉, “Godokono Bukalo tabo ba꞉ma ka꞉na itana, ‘Lumagiti ba꞉moe hopoeno baa꞉ kapiyalo a꞉kaka꞉ka꞉namene, huiyatiya ebete Godokono hiliyonomo tabo komo da꞉nahamene hibinomolo ba꞉ka꞉ka꞉namene.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ba꞉bene Saitanate Ya꞉suku Godokono hido-talona haba Yelusalemamo magatate Godoko Adikumino Hiya꞉ Genamoeno uba hunamo nadipiti ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ebe ba꞉bo negoemiya꞉, “Ama꞉ Godokono hibi Guduma꞉ deda꞉na, ama꞉ ha꞉kiya hakamo na꞉nepatega, mabu Godokono Bukalo tabo ba꞉ma ka꞉na itana, ‘Godote ebeno nopopi amia꞉no komoma꞉ kopoelamema꞉ne, iyo, iba꞉te ibino kokotamo ama꞉ kopelawema꞉na꞉ta, ba꞉bema꞉ ama꞉le nakolalo nato a꞉kanukamidamena꞉ta.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Huiyatiya Ya꞉suti na꞉goiya꞉, “Ao, nale ba꞉be kuba komo a꞉kododa꞉mo, mabu Godokono Bukalo eta tabo ba꞉ma ka꞉na itana, ‘Hopo lumagiti Kodawa Godoko pawima꞉ akewagela꞉la꞉.’ Iyo, ba꞉be mabuma꞉ hopo haba lumagiti ebeno daedae ukuia꞉mo eta komo dododimini, ebete akemalagidolala꞉ Godote ebeno ka꞉ka꞉ dito kopemula꞉mema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ba꞉bene Saitanate Ya꞉suku eta hununomo hakamo magatate ba꞉moe hopo konomoeno hiya꞉hiya꞉ koko hopo ba niya꞉tumiho, iba꞉te ba꞉bi hiliyonomo hopo ba꞉gala koko ilina bulameholiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Saitanate ebetamo na꞉goiya꞉, “Ama꞉ pupamo emedete na nadikunama꞉, ba꞉bene nale ba꞉moi hiliyonomo komokomo ama꞉tamo kikamehoma꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Huiyatiya Ya꞉suti ebetamo na꞉goiya꞉, “Saitana, ama꞉ nagodone na꞉toa! Godokono Bukalo tabo ba꞉ma ka꞉na itana, ‘Ama꞉ amia꞉no Kodawa Godoko adikumilo ebe kapiyatamo na꞉papamiwatanakuya꞉!’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ba꞉bene Saitanate Ya꞉suku miya꞉pate, huiyatiya Godokono nopopa꞉te pelamete ebe ba꞉bo pebuiya꞉minuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ba꞉bene gabomana꞉te Yoneko du genamamo dihatiya꞉, Ya꞉suti ba꞉be komo uliti ebete Ga꞉lili hopamo ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ebete Nasalete haba miya꞉pate Kapeniyama habalo nemedenami, Kapeniyama haba ba꞉ Ga꞉lili Bobo dodolo itanami, ba꞉moe bobo Sebulana ba꞉gala Na꞉patali ba꞉moi netewa gu tawakalubino hopo tamelo itanami. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ba꞉moe komote uluhukuya꞉ Godokono ukui hawakalimidawa Aisayate kebe tabo kolamagiya꞉ ba꞉be tabote hibima꞉ keda꞉ma꞉, iyo, ebete ya꞉lo tetelo ba꞉ma ka꞉na olamagiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulana hoponapi ba꞉gala Na꞉patali hoponapi, Ga꞉lili Bobamo tolame gabo tamelo demedehonama, la꞉ ba꞉bi tawakalubilata. Iyo, la꞉ ba꞉ Yodane Tuli hapuwagutilo da꞉pola꞉nama ba꞉bi tawakalubilata, la꞉eno hopoeno mahilo ba꞉ Yuha꞉ tawakalubino Ga꞉lilila. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Puya꞉te du ipuwalo demedehona, iba꞉te alo konomo kumima꞉na꞉, iyo, puya꞉te hoe ipuwalo demedehona, huiyatiya ka꞉ka꞉ alote ibi ka꞉la꞉minalema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ba꞉ba tetelo Ya꞉suti Godokono tabo olamagi ba tupuimi na꞉goiya꞉, “La꞉eno kubane ohobila꞉te ukui hiya꞉ma꞉ na꞉midila꞉la꞉, mabu Godokono Ko Gawadubuma꞉ eda꞉ tete tatalila.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ba꞉bene Ya꞉suti Ga꞉lili Bobo dododo ba peto dubu netewa ba꞉bo nulamiya꞉, Saimonoko ebeno eta mahilo Pitatela ba꞉gala ebeno ekawi A꞉nduluku, ibi netewapi daha uwateholepila, iba꞉te daha kamahamo na꞉hutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ na na꞉ta꞉mahena꞉la꞉, ba꞉bene nale la꞉ tawakalubi uwatepima꞉ komidilima꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ba꞉ba tetenomolo iba꞉te ibino kamahu miya꞉palete Ya꞉suku ba꞉bo ta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ba꞉bene Ya꞉suti nanekela꞉mo gala katote Sebedikono gudu Ya꞉imesiko ba꞉gala ebeno ekawi Yoneko ba꞉bo kanulamiya꞉, iba꞉te ibino nabiwa꞉go bogelo ahiditi kamahu bihiduilamitiya꞉. Ba꞉bene Ya꞉suti ibi netewapi da꞉ka꞉lamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ba꞉ba tetenomolo iba꞉te ibino boge ba꞉gala nabiwi miya꞉palete Ya꞉suku ba꞉bo ta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ba꞉bene Ya꞉suti Ga꞉lili hopo konomodo da꞉petonakui, ba꞉ba tetelo ebete Yu tawakalubino hiya꞉hiya꞉ baidi ibubulamehole genamalo ibi ba iya꞉tulame, Godote Ko Gawadubuma꞉ deda꞉na ebete ba꞉be komoeno Hido Tabo iba꞉tamo ba꞉bo olamaginakui, ba꞉gala tawakalubi ipuwalo puya꞉te hiya꞉hiya꞉ temetema꞉go demedehonama꞉ ebete ibi hiliyonomo atumu akahiduilamenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ba꞉bene ba꞉ba tetelo Siliya hoponapi hiliyonomate atumu Ya꞉sukunu komo kulihote, iba꞉te ibino hiya꞉hiya꞉ temetema꞉gopi ebetamo ba꞉bo magahelenakuya꞉. Ba꞉ma ka꞉na kuba gobogobagopi, ala꞉ temetema꞉gopi, ape kodakoda temetema꞉gopi, ba꞉gala komo hiya꞉hiya꞉ tawetawa꞉gopi hiliyonomate Ya꞉sutamo da꞉pelamenakui, ebete ibi ba꞉bo hiduilamenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ba꞉ hibila, ba꞉ba tetelo tawakalubi hiliyonomate Ya꞉sutamo hiya꞉hiya꞉ hopone pelamiya꞉, iyo, iba꞉te Ga꞉lili hopone, Ta꞉ni Habahaboeno hopone, Yelusalema ko habane, Yudiya hopone, ba꞉gala Yodane Tuli hapuni hiya꞉hiya꞉ pelameholete Ya꞉suku ba꞉bo ta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ba꞉bene ba꞉bi tawakalubi hiliyonomate Ya꞉sutamo da꞉pelamiya꞉, ebete ibi ulamete haka hunamo nodolote dito nemediya꞉. Ba꞉bema꞉ ebe ta꞉matapi dubate pelamete ebe da꞉panataguma꞉diguya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ebete ibi iya꞉tulame ba꞉bo tupuimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Puya꞉te ibi ha꞉kiya ibi hegehegema꞉ ga꞉lalo Godoko ibino Kodawama꞉ da꞉ga꞉lanaka, wadiyala iba꞉te na꞉kalakalahanamena꞉, mabu Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be hido haboeno komo ibinola! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Ba꞉gala puya꞉te ba꞉ma tetelo temetema꞉go dihimina, wadiyala iba꞉te na꞉kalakalahanamena꞉, mabu Godote iba꞉tamo gelebadi kikalamema꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Ba꞉gala puya꞉te awagahaha꞉pima꞉ deda꞉hana, wadiyala iba꞉te na꞉kalakalahanamena꞉, mabu Godote ba꞉moe hopo konomo iba꞉tamo kikalamema꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Ba꞉gala puya꞉te tuputupu emede komoma꞉ da꞉kapimina, wadiyala iba꞉te na꞉kalakalahanamena꞉, mabu Godote ibino kape komo komodobuilamema꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Ba꞉gala puya꞉te malemale da꞉hawakalilamena, wadiyala iba꞉te na꞉kalakalahanamena꞉, mabu Godote iba꞉tamo ebeno malemale kohawakalimima꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Ba꞉gala puya꞉te ibino tepo ipuwa hidamo dukulalena, wadiyala iba꞉te na꞉kalakalahanamena꞉, mabu iba꞉te Godokono holoholo kumima꞉na꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Ba꞉gala puya꞉te maubahapa꞉tamo gelebadi dikalamena, wadiyala iba꞉te na꞉kalakalahanamena꞉, mabu Godote ibi ebeno gugudima꞉ kogoema꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Ba꞉gala puya꞉te tuputupu gabodo ba wapata꞉lamena ba꞉be mabuma꞉ temeteme duwatenaka, wadiyala iba꞉te na꞉kalakalahanamena꞉, mabu Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be hido haboeno komo ibinola! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ba꞉gala tawakaluba꞉te na mabuma꞉ la꞉ iduduputilamelo koko temeteme ba ikalame la꞉ kubapima꞉ da꞉ga꞉lana, la꞉ atumu na꞉kakalakalahala꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Iyo, la꞉ konomamo na꞉kalakalahala꞉, mabu galane tetelo la꞉le Godokono Hunu Habalo la꞉eno huiya kokonomo konuwatema꞉nemata. Numa꞉la꞉, dopamo tetelo demedenama꞉ ba꞉bi kubapa꞉te atumu Godokono ukui hawakalimipa꞉tamo koko temeteme ba꞉ba ka꞉na kikalamenama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉ ba꞉ ba꞉moe hopoeno solo golalata, huiyatiya la꞉eno solo golate dalatidimini, eta lumagiti gala soloma꞉ a꞉kamida꞉mene. Ba꞉be solo ba꞉ kubanomoma꞉ eda꞉, ba꞉bema꞉ tawakaluba꞉te gobogobamo hola꞉minalete natamo komikimoelema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ba꞉gala eta komo, la꞉ ba꞉ ba꞉moe hopo konomoeno alolata, mabu hibila, haka hunulu ditana tawakaluba꞉te ba꞉be haba hidonomamo buminamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Iyo, lumagiti ebeno wuiki alo pa꞉titi bagolo ipuwamo a꞉kihata꞉mene, huiyatiya ebete hawakala baha꞉mo kihatema꞉ne, ba꞉bene ba꞉be alote genama gulu demedena ba꞉bi tawakalubi hiliyonomo ka꞉la꞉minalema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ba꞉bema꞉ wadiyala la꞉eno alote ba꞉be atu gabodo komo tawakalubi na꞉la꞉minala꞉mene, iba꞉te la꞉eno hidohido ododili komoma꞉ la꞉eno Hunu Haboeno Nabiwi komilimihoma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉ hidamo nemalagidolala꞉, Godote Moseseko ipuwado tawakaluba꞉tamo dikalamiya꞉ ba꞉gala ebeno ukui hawakalimipa꞉te ebeno Bukamo da꞉miya꞉tiya꞉, nale ba꞉bi hidohido Tutumu Tabo gobogobamo miya꞉tema꞉ kapiya꞉ha꞉. Ao, eba ka꞉naha꞉. Nale huiyatiya ba꞉bi Tutumu Taboeno hibi komo hawakalimima꞉ piya꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na la꞉tamo hibi tabo begoemo. Ba꞉moe hopo ba꞉gala alomo ibino ilinate tete ga꞉ga꞉nomolo ba pola꞉na Godokono Tutumu Tabote atumu ba꞉kapola꞉namena꞉, ibi hiliyonomo ipuwalo eta deha꞉potonomo tabote a꞉kalatida꞉mene. Iyo, Godote kebe tabo komokomo ebeno Bukamo da꞉miya꞉tiya꞉, ba꞉bi komate tawakalubi biya꞉tulamenakomena꞉ ebeno oko hiliyonomo upula꞉le kuitita꞉mo! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ba꞉bema꞉ Godokono Tutumu Tabo hiliyonomo ipuwalo kebe lumagiti eta deha꞉potonomo tabo ubiha꞉ma꞉ eda꞉te, ba꞉bene ebete komopi papamila꞉haha꞉ komo diya꞉tulamemene, galane tetelo ebete Godokono Hunu Habalo deha꞉potonomoma꞉ koneda꞉ma꞉ne. Huiyatiya kebe lumagiti Godokono Tutumu Tabo hiliyonomamo ba papamiwata komo tawakalubi atu komo ododilima꞉ diya꞉tulamemene, ebete Godokono Hunu Habalo koma꞉ koneda꞉ma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ba꞉bema꞉ nale la꞉ begoelamemata, wadiyala la꞉le Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi ibino komo nemalagidolala꞉. Tawakaluba꞉te ibi tuputupupima꞉ ga꞉lana, huiyatiya la꞉eno tuputupu emede komote ibino emede komo gogoloheno la꞉ Godokono Hunu Habamo a꞉kana꞉pa꞉la꞉hamata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Dopamo tetelo tawakaluba꞉te Godokono eta tutumu ba꞉ma ka꞉na diya꞉tulamenakui, la꞉ uliya꞉mata. ‘Lumagi akanakapuma꞉la꞉. Pote eta lumagi danakapumimini, tawakalubino tabo anagilamelelamedawate ebetamo kuba huiya kikamema꞉ne.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Huiyatiya ba꞉ma tetelo nale eta tabo bekagoemo. Kebe lumagiti ebeno ekawitamo da꞉maubamene, tabo anagiya꞉midadawate ebetamo kuba huiya kikamema꞉ne, ba꞉gala kebe lumagiti ebeno ekawi diduduputimimini, Ka꞉nisolo dubate ebetamo kuba huiya kikamema꞉na꞉, ba꞉gala kebe lumagiti ebeno ekawi watohenoma꞉ da꞉goemene, ba꞉be kuba mabuma꞉ Godote ebe Koe Habamo konoemema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ba꞉bema꞉ ama꞉ Godoko owatidoloenoma꞉ hawa꞉goeno ilina patapatamo ba adahe ama꞉ ukui hidamo ba꞉ma ka꞉na da꞉nelawemena꞉, ‘A꞉iye! Naeno ekawiti natamo na꞉maubana!’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wadiyala ba꞉ba tetelo ama꞉ amia꞉no malemale ilina ba꞉bamo na꞉miya꞉patepuya꞉. Ama꞉ dopamo tote amia꞉no ekawi negelebadimiti, ba꞉bene ama꞉ gala kapete ba꞉be malemale ilina Godotamo ba꞉bo na꞉pikamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ama꞉tamo da꞉maubana ba꞉be lumagiti ama꞉ gabomani ko dubutamo da꞉magatamena꞉, la꞉ ebetamo nuluhukuhino wadiyala ama꞉ dopamo eba꞉go na꞉negelebadiya꞉la꞉. Ama꞉ ebe gelebadimihino, hibila, ebete ama꞉ ko dubuino kokotamo konihatema꞉na꞉ta, ba꞉bene ko dubuti amia꞉no kuba anagiya꞉midamete ama꞉ polisi dubutamo ba noeme, ama꞉ du genamamo ba꞉bo kotoma꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na ama꞉tamo hibi tabo begoemo, ama꞉ du genama gulu ba nemede, gabomani dubuti kebako tete emedema꞉ ama꞉ da꞉kiyamemena꞉, ama꞉le ba꞉bako kuba huiya modobotenomo modobotete habamo gala kakapema꞉na꞉ta, huiyatiya ama꞉le ba꞉be huiya modoboteheno a꞉kuluhukamena꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Tawakaluba꞉te Godokono eta tutumu ba꞉ma ka꞉na diya꞉tulamenakui, la꞉ uliya꞉mata. ‘Eta lumagino kamena pilolo akalawa꞉la꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Huiyatiya ba꞉ma tetelo nale eta tabo bekagoemo. Kebe dubuti eta kamena umiti ubi ebetamo dihatemene, Godokono umi ipuwalo ebete ebeno tepo ipuwalo ba꞉be kuba ya꞉lo ododi. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ba꞉bema꞉ amia꞉no tu hapu baiditi ama꞉ kuba gabamo demogabuimina, ama꞉ magubutiti gobogobamo na꞉da꞉na! Wadiyala amia꞉no baiditi ba꞉ma tetelo alatidi, huiyatiya galane tetelo Godote amia꞉no ape konomo Koe Habamo a꞉da꞉na modoboha꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ba꞉gala amia꞉no tu hapu kokotote ama꞉ kuba gabamo demogabuimina, ama꞉ itamidate gobogobamo na꞉da꞉na. Wadiyala amia꞉no kokotote ba꞉ma tetelo alatidi, modoboha꞉ galane tetelo ama꞉le ape konomago Koe Habamo to!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Ba꞉gala tawakaluba꞉te Godokono eta tutumu ba꞉ma ka꞉na iya꞉tulamenakuya꞉, ‘Kebe dubuti ebeno ubiha꞉ tetelo kamena dibukimini, kubaha꞉. Ebete ebe ibuki tabo pepamo miya꞉tete ebetamo ikamelo ba꞉bo konoemema꞉ne.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Huiyatiya ba꞉ma tetelo nale eta tabo bekagoemo. Eta dubuino kamenate eta dubago kuba ododihino, ba꞉bene ebeno awiti ebe ubiha꞉ma꞉ eda꞉te dito dibukimini, ba꞉be dubuti ko kuba kododima꞉ne, ba꞉bene ebete Godogodone kuba huiya hibilo kolawema꞉ne. Mabu ebeno kuba ododi komodo ebeno kamenate ba to eta dubu da꞉nelawemene, Godokono umi ipuwalo ibi netewapino ododi komote ba꞉ pilo komoma꞉ keda꞉ma꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Dopamo tetelo tawakaluba꞉te Godokono eta tutumu ba꞉ma ka꞉na diya꞉tulamenakui, la꞉ uliya꞉mata. ‘Ama꞉le Godokono mahilamo kebe tabo dolamagihomena꞉ ba꞉bi tabo hiliyonomo hibinomolo nododiliya꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Huiyatiya ba꞉ma tetelo nale eta tabo bekagoemo. Ama꞉le komopa꞉tamo hibinomo tabo goema꞉ dewagelemena꞉, iba꞉te amia꞉no tabo hibima꞉ komidima꞉ ama꞉le Godokono Hunu Haboeno mahilo akaka꞉ma꞉la꞉, mabu ba꞉be Haba talonama꞉ eda꞉na, ba꞉ Godokono emede bahila. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ba꞉gala ba꞉moe hopo haboeno mahilo akaka꞉ma꞉la꞉, mabu ba꞉moe hopo atumu talonama꞉ eda꞉na, ba꞉ Godokono nato a꞉puti bahila. Ba꞉gala atumu Yelusalema ko haboeno mahilo akaka꞉ma꞉la꞉, mabu ebe ba꞉ aeno Ko Gawadubu Godokono habala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ba꞉gala amia꞉no tabo ulidawate amia꞉no tabo hibima꞉ komidima꞉, ama꞉le amia꞉no mahilo akaka꞉ma꞉la꞉ mabu ama꞉ kodawaha꞉, iyo, ama꞉godolo helo kitanaha꞉ amia꞉no kapiya kilikili hinibo keyakeyama꞉ midi. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ba꞉bema꞉ wadiyala ama꞉ huiyatiya amia꞉no tabo olamagi ipuwalo eta ilinoeno mahilo ka꞉mihino tabo hibilo ba꞉ma ka꞉na na꞉goiya꞉, ‘Iyo, na kododima꞉nemo,’ ba꞉gala keba tetelo ama꞉ eta komo ododi modoboha꞉ma꞉ deda꞉mena꞉, wadiyala ama꞉ eta hibi tabo ba꞉ma ka꞉na na꞉goiya꞉, ‘Ao, na a꞉kododa꞉mo.’ A꞉iye! Komopa꞉te amia꞉no tabo hibima꞉ komidima꞉ ama꞉le amia꞉no tabo heluimima꞉ eta tabo akagaa꞉la꞉, mabu ba꞉bako tabo olamagi komote Saitanagodone kopema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Tawakaluba꞉te Godokono eta tutumu ba꞉ma ka꞉na diya꞉tulamenakui, la꞉ uliya꞉mata. ‘Eta lumagiti amia꞉no baidi da꞉kubahimimini, ama꞉ huiyatiya ebeno baidi kokubahimimima꞉na꞉ta. Ba꞉gala eta lumagiti amia꞉no lalo da꞉wakaa꞉midalemene ama꞉ atumu ebeno lalo kowakaa꞉midalemema꞉na꞉ta.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Huiyatiya ba꞉ma tetelo nale eta tabo bekagoemo. Pote ama꞉tamo kuba dododinako ebe akaduhima꞉la꞉, ba꞉ma ka꞉na ebete ama꞉ tu hapu tatakolo danagalimimina꞉, wadiyala ama꞉ pele hapu ebetamo na꞉kikamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ba꞉gala kebe lumagiti amia꞉no atuino ilina lawema꞉ ubi ihatelo ama꞉ tabo anagiya꞉mida habamo magatama꞉ da꞉goemene, wadiyala ebetamo dito nikamiya꞉ ba꞉gala ba꞉be atu tetelo amia꞉no sete ilina akamawada꞉la꞉, ama꞉le ebetamo malemalelo dito na꞉kikamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ba꞉gala eta gabomani dubuti ebeno ilina kapiya kilomita tatalidopamo agatamema꞉ ama꞉ da꞉goememena꞉, wadiyala ama꞉ kalakalago ebeno ilina netewa kilomita muhuludopamo aguti eba꞉go dito na꞉tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ba꞉gala kebe lumagiti amia꞉no eta ilinama꞉ ama꞉ da꞉toemehomena꞉, wadiyala ama꞉ ebetamo malemalelo nikamiya꞉. Iyo, etate eta tetelo ama꞉godone ilina lawete gala ama꞉tamo ikamema꞉ da꞉kagoemene, wadiyala ama꞉le ebe dito nowalubiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Tawakaluba꞉te ba꞉ma ka꞉na diya꞉tulamenakui, la꞉ uliya꞉mata. ‘Ama꞉ amia꞉no mabulubi malemalelo nemalagidolona, huiyatiya pote ama꞉go dalaholona ama꞉le ba꞉bako lumagitamo mauba kubaha꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Huiyatiya ba꞉ma tetelo nale eta tabo bekagoemo. La꞉tamo dalaholohona, wadiyala la꞉ ibi malemalelo nemalagidolenala꞉, ba꞉gala la꞉tamo temeteme dikalamena ibi Godotamo na꞉wadiya꞉paa꞉latelenakuya꞉la꞉ ebete ibi hidamo kowalubilinama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ba꞉mako ododi komodo la꞉ Hunu Haboeno Nabiwino gugudima꞉ beda꞉hanamata, mabu ebete ebeno hegeloeno alo ba꞉gala ebeno wegoloeno a꞉la꞉li kuba tawakalubi ba꞉gala tuputupu tawakalubi iba꞉tamo kapimilo pikalamenako. ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Puya꞉te la꞉ malemalelo demalagidolena, la꞉ ba꞉bi tawakalubi kapiya demalagidolenama la꞉eno ukui keba ka꞉nala꞉ka꞉? Ba꞉be mabuma꞉ Godote la꞉tamo hido huiya ba꞉kikalametamena꞉? Ao, mabu mani pilolo uwatepa꞉te atumu ibino mabulubi kapiya emalagidolenaka! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ba꞉gala la꞉ la꞉eno tawakalubi kapiyatamo hidohido komo dododilinama la꞉eno ukui keba ka꞉nala꞉ka꞉? La꞉ ba꞉bi hidohido ododili ipuwado komo tawakalubi ba꞉ka꞉gogoleoma? Ao, mabu hibima꞉ midiha꞉pa꞉te atumu ibino tawakalubi kapiyatamo hidohido komo ododilinaka! ");
INSERT INTO knv_aramia_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ba꞉bema꞉ la꞉eno ododili ipuwalo hidonomamo nemedeniya꞉la꞉, la꞉eno Hunu Haboeno Nabiwi keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉na, mabu ebegodolo eta kapiya kuba kitanaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉ hidamo, hidohido komo ododili tetelo komopa꞉te la꞉eno hido komo umima꞉ ibino holoholo hapulu akododila꞉la꞉. La꞉ eba ka꞉na dewagelema la꞉eno Hunu Haboeno Nabiwiti la꞉tamo hido huiya a꞉kikalama꞉mena꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ba꞉bema꞉ malemale ilina awaepa꞉tamo ikalame tetelo komopa꞉te la꞉eno hido ododi komo umima꞉ hawakala akododa꞉la꞉. Numa꞉la꞉, ma꞉lapila netewa tawakaluba꞉te baidi ibubulamehole genamalo ba꞉gala tawakalubino holoholo hapulu ibino malemale ilina diyamo konomago ikalamenaka komopa꞉te ibi komililameholema꞉. Ba꞉bema꞉ na la꞉tamo hibi tabo begoemo, iba꞉te tawakalubino mililamehole ipuwalo ibino ko huiya ba꞉ a꞉lawa꞉, Godogodone gala a꞉kuwata꞉mena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Huiyatiya la꞉eno malemale ilina ikalame tetelo wadiyala la꞉le diya gabodo nododiya꞉la꞉, ba꞉ma ka꞉na la꞉eno eta hido mabulubiti akiya꞉tawala꞉, Godoko kapiyate niya꞉tawamene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Iyo, la꞉ malemale ilina diya gabodo nikalamenakuya꞉la꞉, ba꞉bene la꞉eno Nabiwi Godote la꞉eno diya ododi komo umiti ebete ha꞉kiya la꞉tamo hido huiya bikalamenakomena꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉le Godokoba꞉ tabo ga꞉la tetelo ma꞉lapila netewa tawakalubima꞉ akeda꞉hala꞉. Iba꞉te baidi ibubulamehole genamalo ba꞉gala tawakalubino holoholo hapulu utitatate tabo madodo hunamo wadiya꞉paa꞉latelelo Godotamo ba꞉bo ga꞉lanaka, mabu ibi ubila tawakaluba꞉te ibino ga꞉la komo kulilatelema꞉. Ba꞉bema꞉ na la꞉tamo hibi tabo begoemo, iba꞉te tawakalubino mililamehole ipuwalo ibino ko huiya ba꞉ a꞉lawa꞉, Godogodone gala a꞉kuwata꞉mena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Huiyatiya ama꞉le Godokoba꞉ tabo da꞉ga꞉lama, wadiyala ama꞉ genamamo nodolote gigiho na꞉pekalapiluya꞉. Ba꞉bene ama꞉le amia꞉no Nabiwa꞉go diya gabodo tabo ba ga꞉la, ama꞉le ebe a꞉kuma꞉mena꞉ta, huiyatiya ebete amia꞉no diya ododi komo umiti ama꞉tamo hido huiya ba꞉bo kikamema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ba꞉bema꞉ ama꞉le Godokoba꞉ tabo ga꞉la tetelo, ama꞉ Godoko iya꞉tawaha꞉ lumagima꞉ akeda꞉la꞉. Numa꞉la꞉, ba꞉bako lumagiti Godoko toemeho tetelo ba꞉ma ka꞉na emalagidolonako, ‘Nale atu toetoe tabo hiliyo teta꞉mo dolamaginakomo, ba꞉bema꞉ Godote naeno tabo hibinomolo kulima꞉ne.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Huiyatiya la꞉ ba꞉bako lumagima꞉ akeda꞉hala꞉, mabu la꞉le la꞉eno modoboha꞉ komokomoma꞉ Godoko ga꞉lameheno ebete ya꞉lo iya꞉tawanako. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ba꞉bema꞉ la꞉ Godotamo toetoe tabo ba꞉ma ka꞉na na꞉ga꞉lanakuya꞉la꞉, ‘Aeno Hunu Haboeno Nabiwi, wadiyala amia꞉no talona mahilo tawakaluba꞉te nadipata꞉mena꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ba꞉gala wadiyala ama꞉le Ko Gawadubuma꞉ deda꞉na ba꞉be komote na꞉hawakalamene. Hibila, ama꞉le amia꞉no ubi keba ka꞉na ka꞉miya꞉teona Hunu Habalo ba꞉ba ka꞉na bododilinakomena꞉ta, ba꞉bema꞉ wadiyala ama꞉ hopo habalo amia꞉no ubi komokomo atumu na꞉kododilinakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","‘Ba꞉gala wadiyala ama꞉ ba꞉moe kapiya hegeloeno baa꞉ atamo modobolo nikaa꞉ma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ba꞉gala komopa꞉te atamo kuba dododilina, ale ba꞉bi kuba egebolelamete kadodoholelamema꞉nema꞉, ba꞉bema꞉ wadiyala ama꞉ atumu aeno kuba egebolea꞉mete nadodoholea꞉ma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","‘Ba꞉gala Saitanakono kuba gabamo emogabuimi ipuwalo ama꞉le huiyatiya a ba owalubi amia꞉no hido gabodo na꞉magatoenakuya꞉, iyo, ebeno kuba ododi ipuwane aeno ka꞉ka꞉ na꞉mula꞉lea꞉ma꞉, mabu amia꞉no Ko Gawadubu komo, ba꞉gala helo konomo, ba꞉gala awagaha komo emedena emedena tetelo ama꞉godolo ba꞉pola꞉namena꞉. Ba꞉ba꞉la.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ya꞉suti tabo moga꞉melo gala na꞉kagoiya꞉, “Komopa꞉te kuba la꞉tamo dododili, la꞉le ibino kuba dadodoholelamema la꞉eno Hunu Haboeno Nabiwiti atumu la꞉eno kuba egebolelamete kadodoholelamema꞉na꞉ta, ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","huiyatiya la꞉le komopino kuba adodolelameheno, la꞉eno Hunu Haboeno Nabiwiti atumu la꞉eno kuba egebolelamete a꞉kadodoholelama꞉mena꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉le Godokono oko owatima꞉ baa꞉ nahaheno da꞉pola꞉nama, ma꞉lapila netewa tawakalubima꞉ akeda꞉hala꞉. Iba꞉te baa꞉ nahaheno pola꞉na tetelo ibino dopo menemenema꞉ eda꞉halamenaka, mabu ibi ubila tawakaluba꞉te ibino baa꞉ nahaha꞉ komo kumilamema꞉. Ba꞉bema꞉ na la꞉tamo hibi tabo begoemo, iba꞉te tawakalubino mililamehole ipuwalo ibino ko huiya ba꞉ a꞉lawa꞉, Godogodone gala a꞉kuwata꞉mena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Huiyatiya amia꞉no baa꞉ naheno luta tetelo wadiyala ama꞉ ba꞉be komo diya gabodo nododinakuya꞉. Ba꞉bema꞉ ama꞉ baa꞉ kapete umihino, ama꞉le kalakalago demedena ama꞉ ba꞉ ba꞉ba ka꞉na na꞉lutiya꞉, ama꞉le amia꞉no hinibo ahigiwadolete amia꞉no holoholo hidamo kukulama꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ba꞉bene tawakaluba꞉te a꞉kiya꞉tawahamena꞉ ama꞉le baa꞉ naheno da꞉luta, Nabiwi Godoko kapiyate kiya꞉tawama꞉ne. Ama꞉le ebe a꞉kuma꞉mena꞉ta, huiyatiya ebete amia꞉no diya ododi komo umiti ama꞉tamo hido huiya ba꞉bo kikamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉ ba꞉moe hopolo ilina akadogodoguilamenala꞉, mabu ba꞉moe hopolo hidohido kaliko unawa꞉te a꞉kubahilamenaka ba꞉gala auli ilina hakate atumu a꞉kakubahilamenaka. Iyo, ba꞉ hibila, pilo tawakaluba꞉te genama guamo pogomote la꞉eno komo ilina dito kopekubahilamema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ba꞉bema꞉ wadiyala la꞉ Godokono Hunu Habalo la꞉eno ilina na꞉dogodoguilamenala꞉, mabu ba꞉bolo unawa꞉te ilina a꞉kanala꞉la꞉, ba꞉gala hakate ilina a꞉kakubahilama꞉le, ba꞉gala pilo tawakaluba꞉te genama guamo ogomote la꞉eno ilina a꞉kuwata꞉mena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","La꞉ hidamo! La꞉eno ilinate kebolo da꞉pola꞉namena꞉ la꞉eno tepo ipuwoeno ukui atumu ba꞉bolo konepola꞉nama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Lumagino apeno alo ba꞉ ebeno baidila. Ba꞉bema꞉ amia꞉no baiditi hidamo da꞉la꞉minalemene amia꞉no tepo ipuwoeno alote atumu hidonomamo kaka꞉la꞉minama꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","huiyatiya baiditi hidamo a꞉la꞉minaleheno amia꞉no apete du ipuwalo kitanama꞉ne. Ba꞉bema꞉ ama꞉ hidamo, amia꞉no tepo ipuwoeno alote da꞉dumini, ba꞉be du komo bada konomola꞉ka꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ba꞉gala ba꞉moe ba꞉ eta komola, lumagiti netewa gawadubatamo okodawama꞉ eda꞉ modoboha꞉. Ebete ba꞉ba ka꞉na dewagelemene etatamo ba maubana eta malemalelo bemalagidolonamene, ba꞉gala ebe etatamo ba utina eta ubiha꞉ma꞉ beda꞉namene. Ba꞉bema꞉ ama꞉ ba꞉ atumu, Godotamo ba꞉gala manitamo kapiya tetelo papamiwata modoboha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Nale la꞉ begoelamemata, la꞉eno emedeho komokomoma꞉ aka-ukuibilibilihonala꞉, iyo, la꞉le naha ilina, niho ilina, ba꞉gala pupulino ilina uwatema꞉ koamo akemalagidola꞉la꞉, mabu naha ilina ba꞉gala pupulino ilina iba꞉te kokoma꞉ keda꞉hanaha꞉. Naha ilinate lumagitamo hibi ka꞉ka꞉ ba꞉kikamemene? Ao, a꞉kikama꞉mene, ba꞉gala pupulino ilinate atumu ebeno ape emedena tetelo a꞉kowalubinamene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ba꞉bema꞉ la꞉ holaholoeno komo nemalagidolala꞉, iba꞉te pali ilina a꞉kamihala꞉ ba꞉gala iba꞉te pelamete nahoeno kikipo a꞉kapetapihala꞉, iyo, ibino pali ilina miya꞉teno genama puliyala, huiyatiya la꞉eno Hunu Haboeno Nabiwiti iba꞉tamo baa꞉ modobolo ikalamenako. Numa꞉la꞉, Godokono malemale hibilo bitana holaholatamo, huiyatiya la꞉tamo keba ka꞉na kitana? Ba꞉ hibila, ebeno malemale la꞉tamo konomoma꞉ eda꞉te emedena emedena tetelo bitanamene! ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ba꞉bema꞉ la꞉ ukui bilibilima꞉ akeda꞉hala꞉. Lumagiti ebe ha꞉kiya ebeno hoe tete eta hegelamo keba ka꞉na na꞉kihatemene, ba꞉gala ebete ebeno ka꞉ka꞉ keba ka꞉na na꞉ka꞉ga꞉gima꞉tepamene? Gabo puliyala, kitanaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ba꞉bema꞉ mabu keka꞉ la꞉ pupulino ilinama꞉ ukui bilibilima꞉ deda꞉hanama? La꞉ hopoeno haiyaino komo nemalagidolala꞉, iba꞉te oko a꞉kowata꞉la꞉ ba꞉gala pupulino ilina a꞉kododila꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nale la꞉ begoelamemata, Ko Gawadubu Solomonote dogodogodawanomoma꞉ eda꞉nami, huiyatiya ebete hidohido tita꞉goeno ilina da꞉pupulinakui, ba꞉bi kalikoeno titi ba꞉moe hopoeno haiyaino hido komote na꞉gogolena. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Numa꞉la꞉, ba꞉moe hopoeno hemate ka꞉lo napepehuta, dumutu tawakaluba꞉te koa꞉mo kiya꞉hekema꞉na꞉, huiyatiya Godote ba꞉bi nonoka ilina tita꞉goenoma꞉ midilina, ba꞉bema꞉ ebete atumu la꞉tamo pupulino ilina modobolo bikalamenakomena꞉ta. La꞉ ba꞉moe komo hidamo iya꞉tawahaheno la꞉eno hibima꞉ midi komo Godotamo kokoha꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ba꞉bema꞉ la꞉le ukui bilibilima꞉ eda꞉halo ba꞉ma ka꞉na akaga꞉lanakala꞉, ‘A bada na꞉ka꞉nahama꞉, ba꞉gala a bada na꞉ka꞉nihoma꞉, ba꞉gala a bada na꞉ka꞉pupulima꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hibima꞉ midiha꞉pa꞉te ba꞉moi ilina ukui bilibila꞉go oholena, la꞉ huiyatiya eba ka꞉na akewagelenala꞉, mabu ba꞉bi ilina la꞉godolo modobolo pola꞉naheno la꞉eno Hunu Haboeno Nabiwiti ya꞉lo iya꞉tawanako. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ba꞉bema꞉ la꞉ la꞉eno Ko Gawadubu Godotamo papamila꞉lo ebeno tuputupu emede komo dopamo nohowada꞉la꞉, ba꞉bene la꞉eno modoboha꞉ tetelo ebete la꞉eno komokomo ulamelelamete la꞉tamo modobolo bikalameholenakomena꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ba꞉bema꞉ la꞉ dumutu hegeloeno komoma꞉ ukui bilibilima꞉ akeda꞉hala꞉ mabu ba꞉be hegeloeno komote ha꞉kiya kopuluhukuma꞉ne. Ka꞉lo hegelalo da꞉pola꞉na ba꞉bi hiya꞉hiya꞉ komo nemalagidola꞉la꞉, huiyatiya eta hegeloeno kuba komate pikulihino dopamo tole komote la꞉tamo akapa꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Komo tawakalubino kuba ododili komoma꞉ la꞉le ibi kubapima꞉ tiyolo akaka꞉lama꞉la꞉, ba꞉bene Godote la꞉ kubapima꞉ a꞉kaka꞉lama꞉mena꞉ta, ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","mabu la꞉le tawakalubino komo keba ka꞉na danagilamelelamema, Godote ba꞉ ba꞉ba ka꞉na la꞉eno komo kanagilamelelamema꞉na꞉ta, ba꞉gala la꞉ komopa꞉tamo keba ka꞉na dododilinakoma, ba꞉ba ka꞉na Godote la꞉tamo atumu ba꞉ka-ododilinakomene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Keka꞉ mabu ama꞉le ekawino baidilo puhulu deha꞉poto umilo huiyatiya amia꞉no baidilo ditana ba꞉be ko keha tete kuminaha꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ba꞉gala bada mabuma꞉ amia꞉no ekawitamo ba꞉ma ka꞉na da꞉goita, ‘Wadiyala amia꞉no baidilo ditana ba꞉be puhulu deha꞉poto nale kolawemema꞉nemata,’ huiyatiya amia꞉no baidilo ditana ba꞉be ko keha tete ama꞉ kalawenaha꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","A꞉iye! Ama꞉ ma꞉lapila netewa lumagilata! Wadiyala ama꞉ dopamo amia꞉no baidilo ditana ba꞉be keha lawete, ama꞉le galane hidamo gahimiti amia꞉no ekawino baidilo ditana ba꞉be puhulu deha꞉poto ba꞉bo kolawemema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ba꞉gala ba꞉moe ba꞉ eta komola, la꞉le Godokono talona ilina gahagahatamo akikalama꞉la꞉. La꞉ ba꞉ba ka꞉na dewagelema, diyala, iba꞉te la꞉tamo ohobila꞉te la꞉ kubanomamo da꞉ aloholetamena꞉, ba꞉gala la꞉eno hidohido mani goegoa꞉tamo akikalama꞉la꞉, iba꞉te ba꞉bi ilina natamo mikimoelete dito miya꞉paledemena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉ Godoko na꞉toemehala꞉, ebete la꞉tamo kikalamema꞉na꞉ta. Iyo, la꞉ ebeno hido komo nohowada꞉la꞉, la꞉le kumima꞉nemata, ba꞉gala gigiho nanakama꞉la꞉, ebete la꞉tamo ka꞉hiya꞉midama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Numa꞉la꞉, puya꞉te Godoko da꞉toemehonaka, iba꞉te ebegodone kolawema꞉na꞉, ba꞉gala puya꞉te ebeno hido komo dohowadinaka iba꞉te kumima꞉na꞉, ba꞉gala puya꞉te gigiho danakaminaka ebete iba꞉tamo ka꞉hiya꞉midama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","La꞉ ipuwalo kebe dubu ebeno guduti ebe baa꞉ma꞉ da꞉toemehomene, huiyatiya ebetamo nakola ba꞉kikamemene? ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ba꞉gala amia꞉no guduti ama꞉ dahama꞉ da꞉toemehomena꞉, ama꞉ huiyatiya ebetamo bu kalu ba꞉kikameomena꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Numa꞉la꞉, la꞉ hidohido tawakalubiha꞉ huiyatiya la꞉ iya꞉tawahala la꞉eno guguda꞉tamo hidohido baa꞉ ikalamema꞉, ba꞉bema꞉ la꞉eno Hunu Haboeno Nabiwiti atumu iya꞉tawanomola hidohido komo tawakaluba꞉tamo ikalamema꞉, puya꞉te ebe da꞉toemehonaka iba꞉tamo kikalamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ba꞉bema꞉ tawakaluba꞉te la꞉tamo bada komo ododima꞉ la꞉le ubi dihatenakoma, la꞉ komopa꞉tamo ba꞉ ba꞉ba ka꞉na nododinakuya꞉la꞉, mabu Godote ebeno Tutumu Tabo Moseseko ipuwado tawakaluba꞉tamo dikalamiya꞉ ba꞉gala ebeno ukui hawakalimipa꞉te ebeno Bukamo da꞉miya꞉tiya꞉, ba꞉bi koko taboeno ipuwa kapiya ba꞉ ba꞉ma ka꞉nala, la꞉ komopa꞉tamo malemale komo na꞉hawakaliminakuya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉ tutuwa gigihodo na꞉pa꞉la꞉hala꞉, mabu Koe Habamo da꞉na꞉pa꞉la꞉hanaka ba꞉be gigiho konomola, gabo kodakodaha꞉. Tawakalubi hiliyonomate ba꞉bana na꞉pa꞉la꞉hate ba꞉be gabodo tolamena. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Huiyatiya Godokono Ka꞉ka꞉ Habamo da꞉na꞉pa꞉la꞉hanaka ba꞉be gigiho tutuwanomola, gabo kodakodala. Tawakalubi kapiyakapiyate ba꞉be gigiho numiti ba꞉bana tolamena.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉le Godokono mahilamo ha꞉da tabo olamagimipi hidamo nulama꞉la꞉. Iba꞉te gelebadihole sipi-goegoeno tama pupuliti la꞉tamo ba꞉bo pelamenaka, huiyatiya ibino tepo ipuwalo ibi helohelo gahagaha keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","La꞉ ibino ododili komokomo hidamo nulamelelamiya꞉la꞉. Lumagiti hidohido gala꞉ipi gao olagoeno kehalo a꞉kanulama꞉mene, ba꞉gala ebete olagoeno kehamo tote anahu kehoeno gao a꞉kanetapihamene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Numa꞉la꞉, hidohido kehalo hidohido gaote konolohoma꞉na꞉, ba꞉gala kuba kehalo ba꞉ kuba gaote konolohoma꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Iyo, hido kehalo kuba gaote a꞉kanolohamena꞉, ba꞉gala kuba kehalo hidohido gaote a꞉kanolohamena꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ba꞉bema꞉ hibila, hidohido gao nolohoha꞉ keha tawakaluba꞉te luhuti koa꞉mo kiya꞉hekema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ba꞉bema꞉ la꞉ ha꞉da tabo olamagimipino ododili komokomo ba ulame la꞉le ibino noloho komamo ibino hibi komo ba꞉bo kiya꞉tawahama꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Numa꞉la꞉, puya꞉te na Kodawama꞉ dito da꞉ka꞉naminaka huiyatiya hibi komo puliyala, ba꞉bi tawakaluba꞉te Godokono Hunu Habamo a꞉kana꞉pa꞉la꞉hamena꞉. Huiyatiya puya꞉te naeno Nabiwino ubi komamo da꞉papamila꞉halena, ibi kapiyate ebeno Hunu Habamo kona꞉pa꞉la꞉hama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ba꞉bema꞉ Godokono Ko Hegelalo komopa꞉te natamo ba꞉ma ka꞉na koga꞉lama꞉na꞉, ‘Kodawa, Kodawa! Ale amia꞉no mahilamo Godokono tabo olamagiminakuima꞉, ba꞉gala amia꞉no mahilamo kuba gobogobo oelamenakuima꞉, ba꞉gala atumu ale komo hanohano komo ododilinakuima꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Huiyatiya nale iba꞉tamo kogoema꞉nemo, ‘Na iya꞉tawaha꞉ la꞉eno komo. La꞉ kuba ododilipilata, nagodone na꞉tolama꞉la꞉!’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Kebe lumagiti naeno tabo ulihote ba꞉bi komokomo dododilimini, ebe hido mulu ukui lumagila. Ebete ebeno genama kodakoda haka hunamo detiya꞉, ba꞉be dubu keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ba꞉ba tetelo wegolate duya꞉ beyate ba꞉bo odoluya꞉, ba꞉bene konomo gogote pete genama da꞉pemida꞉miya꞉ genamate kakaguya꞉ha꞉ mabu ebete hido hakamo etiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Huiyatiya kebe lumagiti naeno tabo ulihote ododilihino, ebe ba꞉ daedae ukui lumagila. Ebete ebeno genama kulili hakamo detiya꞉ ba꞉be dubu huiyala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ba꞉ba tetelo wegolate duya꞉ beyate ba꞉bo odoluya꞉, ba꞉bene konomo gogote pete genama da꞉pemida꞉miya꞉ genamate kagate kubanomoma꞉ ba꞉bo ediya꞉. O olalati bada konomola꞉ka꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ba꞉bene Ya꞉suti ba꞉moi komokomo olamagi da꞉wibuya꞉ ebeno tabo ulihopi hiliyonomate na꞉hanohanohutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","mabu ebete Godokono heloamo iya꞉tulamitiya꞉, huiyatiya ebe ibino Godokono Tutumu iya꞉tulamepi huiyaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ba꞉ba tetelo Ya꞉suti haka hununi da꞉pihitiguya꞉ komo tawakalubi hiliyonomate ebe anataguma꞉talo ba꞉bo tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ba꞉bene kuitikuita꞉goeno dubuti ebetamo pete ebeno pupamo pemedete na꞉pegoiya꞉, “Kodawa, amia꞉no ubi ditama꞉na, ama꞉le na kohiduinamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ya꞉suti ebeno kokoto hogaminate ebe ba ologi ebetamo na꞉goiya꞉, “Na ubila, ama꞉ na꞉hida!” ba꞉bema꞉ ba꞉ba tetenomolo kuitikuiti temetemete ebegodone da꞉wibuya꞉ ebete ba꞉bo hiduya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ba꞉bene Ya꞉suti ebetamo eta tabo ba꞉ma ka꞉na kagoiya꞉, “Ama꞉ naeno komoma꞉ tawakalubi akanikiyalama꞉la꞉. Wadiyala ama꞉ huiyatiya ba꞉moe tetenomolo tote amia꞉no ape Godotamo hawa꞉goeno ikamehodawatamo na꞉nemutuimiya꞉, ba꞉bene hawa꞉goeno malemale ilina Godotamo akona꞉nikamiya꞉, Mosesete dolamagiya꞉ ba꞉ba ka꞉na. Ba꞉be komote tawakalubi kiya꞉tulamema꞉ne amia꞉no temetemete a꞉wibui.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ba꞉bene Ya꞉suti Kapeniyama habamo da꞉tuya꞉ Lomanapino eta alaholohodawa gawadubuti ebetamo pete ebe petoemeholo na꞉pegoemiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Kodawa, naeno okodawa genamalo ko tawetawa꞉go watita, ebe ape kodakoda temetemete umita.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Wadiyala, na pete ebe kopihiduimima꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Alaholohodawa gawadubuti tabo ba huiya na꞉goiya꞉, “Ao, Kodawa, eba ka꞉naha꞉. Na hido lumagiha꞉ ama꞉le naeno genamamo pa꞉pa꞉gama꞉. Huiyatiya na niya꞉tawutamo, ama꞉le genamamo peheno tabo dito da꞉goemena꞉, naeno okodawate hibinomolo kohidoma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mabu na atumu alaholohopino koko gawadubuino hopodawama꞉ ba eda꞉na ibino tabamo a꞉papamiwatanakomo, ba꞉gala atu tetelo naeno alaholohopa꞉te naeno umi ipuwalo pola꞉na. Ibi ipuwalo nale eta da꞉kiyamemo, ‘Ama꞉ na꞉toa!’ ebete ba꞉bo kotoma꞉ne. Ba꞉gala eta da꞉kakiyamemo, ‘Ama꞉ na꞉pa꞉!’ ebete ba꞉bo kopema꞉ne. Atumu nale naeno huiyaha꞉ okodawa da꞉kiyamemo, ‘Ama꞉ ba꞉moe komo nododa꞉!’ ebete ba꞉be komo kododima꞉ne. Ba꞉bema꞉ Kodawa, wadiyala ama꞉ tabote na꞉gaa꞉ naeno okodawate kohidoma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ya꞉suti ba꞉be tabo duliya꞉ ebete na꞉la꞉wiya꞉, ba꞉bema꞉ ebe da꞉ta꞉matutiya꞉ ba꞉bi tawakaluba꞉tamo na꞉goiya꞉, “Na la꞉tamo hibinomolo goemo, na Isalaela tawakalubi hiliyonomo ipuwalo ba꞉mako lumagino hibima꞉ midi komo a꞉kuma꞉lemo! ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nale la꞉ begoelamemata, hiliyonomo tawakaluba꞉te ba꞉moe hopo konomoeno hapuhapuni pelameholete, iba꞉te A꞉ibalahamako, Aisa꞉keko, ba꞉gala Ya꞉ikoboko iba꞉go kapimilo Ko Gawadubu Godokono poko habalo kopepola꞉nama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Huiyatiya komo la꞉ Yu tawakalubi Godote la꞉ du ipuwamo kopiya꞉hekema꞉na꞉ta, ba꞉be du ipuwalo la꞉ lalo ba ikilame konomamo kihimima꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ba꞉bene Ya꞉suti alaholohodawa gawadubutamo na꞉goiya꞉, “Mabu ama꞉le na hibima꞉ a꞉midina꞉ta, ba꞉bema꞉ ama꞉ tote amia꞉no okodawa na꞉numiya꞉, ebete a꞉hido.” Ba꞉ hibila, ba꞉ba tetenomolo Ya꞉suti ba꞉be tabo ba goita okodawate ba꞉bo hiduya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ba꞉ba tetelo Ya꞉suti Pitakono genama guamo nodolote ebeno moto kakidubu ba꞉bo numiya꞉, ebete ape koe tawetawa꞉go watitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ba꞉bene Ya꞉suti ba꞉be kamenoeno kokoto dologimiya꞉, tawetawete ebegodone ba uluhuku ebete mahigate Ya꞉suku mabuma꞉ baa꞉ okalimi oko ba꞉bo tupuimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ba gapogapohona habaluba꞉te hiliyonomo kuba gobogobagopi Ya꞉sutamo ba꞉bo magaheleniya꞉, ba꞉bene ebete tabo olamagi kapiyamo kuba gobogobo iba꞉godone ba oelamena komo temetema꞉gopi hiliyonomo atumu ba꞉bo kahiduilameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ba꞉ hibila, Ya꞉suti ba꞉makomako hidohido komo tawakaluba꞉tamo ododilinakui, Godokono ukui hawakalimidawa Aisayate da꞉goiya꞉ ba꞉be tabote hibima꞉ keda꞉ma꞉, iyo, ba꞉be dawate ya꞉lo tetelo tabo ba꞉ma ka꞉na goiya꞉, “Ebete aeno temeteme ba꞉gala tawetawe kuwatea꞉mema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Eta hegelalo komo tawakalubi hiliyonomate Ya꞉suku danataguma꞉diguya꞉, ebete ba꞉be komo umiti ebe ta꞉matapi na꞉goelamiya꞉, “A bobo hapuamo kona꞉hiwaliya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ba꞉ba tetelo Godokono Tutumu iya꞉tulamedawa etate pete ebetamo na꞉pegoiya꞉, “Iya꞉tulamedawa, ama꞉ kebamo da꞉tomena꞉, nale ama꞉ ba꞉bamo kota꞉matama꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Huiyatiya Ya꞉suti ebeno tabo uliti na꞉goiya꞉, “Hiya꞉, ama꞉ dopamo ba꞉moe eta komo hidamo nemalagidola. Tumu gahagahoeno laha bahi haka gugu ba꞉pola꞉lama꞉na ba꞉gala holaholate ibino genama etemotehonaka, huiyatiya na Tawakalubino Naniwi naeno wata bahi puliyala.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ba꞉bene eta ta꞉matadawate na꞉goiya꞉, “Kodawa, wadiyala na dopamo tote, naeno kadele nabiwiti da꞉hoemene, nale ebe bobamo nihatete na galane ama꞉ kota꞉mahema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ya꞉suti ebetamo na꞉huiyuya꞉, “Ao, ama꞉ ka꞉lonomo na na꞉ta꞉mahena꞉, huiyatiya wadiyala ha꞉laha tawakaluba꞉te ibi ha꞉kiya ibino ha꞉lahapi bobamo na꞉miya꞉ta꞉mena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ba꞉bene gapogapo tete ba tatalina Ya꞉suti boga꞉mo da꞉nihitiganiya꞉ ebe ta꞉matapa꞉te eba꞉go kapimilo nepalaganiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Iba꞉te boga꞉mo ololonate da꞉tolameniya꞉ ba꞉ba tetelo ko gogonomote ba pena koko gawiyate mahila꞉halenate boge guamo beya ba꞉bo pehaminahaniya꞉, huiyatiya Ya꞉suti boge gulu u bewataniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ba꞉bema꞉ ta꞉matapa꞉te ebetamo pelamenate ebe ba pemodoetena ba꞉bo pega꞉lameniya꞉, “Kodawa, aeno ka꞉ka꞉ na꞉mula꞉lea꞉ma꞉! A ba꞉ koha꞉lahama꞉nema꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ya꞉suti huiyatiya na꞉goeniya꞉, “La꞉ badama꞉ ka꞉toletolehonama? La꞉eno hibima꞉ midi komo hegehegenomola!” Ba꞉ba tetelo ebete mahiganate huhu ba꞉gala gawiya na꞉kiyahalameniya꞉, “La꞉ na꞉tatabahala꞉!” ba꞉bene bobote tatabanomoma꞉ ba꞉ dito eda꞉niya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ba꞉ba tetelo ibi hiliyonomate ba hanohanohona na꞉ga꞉laniya꞉, “Moe kebako dubula꞉ka꞉? Huhu ba꞉gala gawiya iba꞉te ebeno tabo uliti a꞉papamila꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ba꞉bene eta hegelalo Ya꞉suti bobo hapuamo na꞉hiwate Gadala haboeno hopamo nuluhukuti, hakamo ba nodolo kuba gobogobagoeno dubu netewapa꞉te eba꞉go ba꞉bo paluguya꞉. Ba꞉bi dubu netewapa꞉te ha꞉laha tawakalubino bobo habalo emedenama꞉ ba꞉gala ibi helohelonomola, ba꞉bema꞉ tawakaluba꞉te ba꞉be gabodo wapata꞉lame koamo toletolehonama꞉. Ba꞉ hibila, ba꞉be hopo tawakalubino komo ba꞉ma ka꞉nala, iba꞉te iya꞉ha꞉midale nakola haka ba aligili hiya꞉hiya꞉ bobo ba꞉bo ododilinakuya꞉ iba꞉te ibino ha꞉laha tawakalubi miya꞉tenoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ba꞉moi dubu netewapa꞉te Ya꞉suku dumiya꞉ ba꞉ba tetenomolo iba꞉te ga꞉ga꞉lo na꞉ga꞉luya꞉, “Ama꞉ Godokono Gudulata! Ama꞉ atamo bada komo na꞉kododiomena꞉? Godokono kuba huiya ikalame tete peheno, ama꞉ dopamo a alukuima꞉ ka꞉pa꞉wa?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ba꞉ba tetelo ibi tamelo dabihole goegoe hiliyonomate nala꞉go wapata꞉lamitiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ba꞉bema꞉ kuba gobogobagopi dubate Ya꞉suku toemeholo na꞉ga꞉luya꞉, “Ama꞉ a ba꞉moi dubagodone oea꞉mema꞉ ubi dihatita, wadiyala ama꞉le a goegoa꞉tamo noea꞉ma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Na꞉tolama꞉la꞉!” Ba꞉ba tetelo iba꞉te dubagodone ikuliti goegoa꞉tamo ba꞉bo nogomuya꞉, ba꞉bema꞉ ba꞉bi goegoa꞉te haka hununi pulila꞉hate iya꞉ha꞉midale hakane da꞉negudiya꞉, beyamo nululuhuliti ibi hiliyonomate ba꞉ dito neha꞉lahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ba꞉ba tetelo Ya꞉suti kuba gobogobagopi keba ka꞉na ka꞉hiduilamiya꞉, goegoe ulamepi dubate ba꞉be komo umiti ibino habamo pulila꞉hate tawakalubi hiliyonomo ba꞉bo nikiyalamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ba꞉bene habalubi hiliyonomate Ya꞉sutamo pelamete, iba꞉te ebe da꞉pumiya꞉ ebe na꞉pega꞉lamiya꞉ ebete ibino hopo miya꞉pate kotoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ba꞉bene Ya꞉suti boga꞉mo ololote bobo hapuamo na꞉hiwate ebeno emede haba Kapeniyamamo dito nuluhukuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ba꞉ba tetelo tawakaluba꞉te ape kodakoda temetema꞉goeno dubu talatalago agatuya꞉, ba꞉bene Ya꞉suti ibino hibima꞉ midi komo umilamete ebetamo na꞉goiya꞉, “Naeno mabulubi, ama꞉ na꞉kalakala! Godote amia꞉no kuba egebolemete adodoholema꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Huiyatiya komo Godokono Tutumu iya꞉tulamepa꞉te ba꞉be tabo uliti ibi ipuwalo tabo ba꞉ma ka꞉na ga꞉lutiya꞉, “Ba꞉moe dubuti awagalo kuba tabo begoe Godokono holoholo hapulu!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iba꞉te ibino tepo ipuwalo da꞉ga꞉luya꞉, Ya꞉suti iya꞉tawate iba꞉tamo na꞉goiya꞉, “Mabu keka꞉ la꞉eno tepo ipuwalo ba꞉moi kuba komo demalagidolitama? ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ba꞉moe tabo kodakodala꞉ka꞉ nale goema꞉, ‘Godote amia꞉no kuba egebolemete adodoholema꞉ta?’ O ba꞉moe eta tabo goema꞉ kodakodala꞉ka꞉, ‘Ama꞉ mahigate na꞉toa?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ba꞉bema꞉ nale la꞉ kiya꞉tulamema꞉nemata na Tawakalubino Naniwigodolo helo bitana ba꞉moe hopo konomolo tawakalubino kuba egebolelamete kadodoholelamema꞉.” Ba꞉bene Ya꞉suti temetema꞉goeno dubutamo na꞉goiya꞉, “Ama꞉ mahigate, tilo mokopa꞉midate genamamo na꞉toa.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ba꞉bema꞉ ba꞉be dubuti mahigate ebeno genamamo dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ba꞉ hibila, tawakalubi hiliyonomate ba꞉be komo umiti ba hanohanohuta Godokono mahilo hunamo ba꞉bo adipatiya꞉, mabu ibino holoholo hapulu ebete Ya꞉suku ipuwado ebeno helo konomo a꞉hawakalimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ya꞉suti ba꞉be genamane uluhukuti ba petonato eta dubu ba꞉bo numiya꞉, ebeno mahilo Ma꞉tiyutila, ebe ta꞉kese uwatedawala, ebete ebeno oko habalo lutiya꞉. Ba꞉ba tetelo Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉ na na꞉ta꞉mahena꞉,” ba꞉bene ebete mahigate Ya꞉suku na꞉ta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉go Ma꞉tiyukunu genamalo baa꞉ ba nahuta, komo hiliyonomo ta꞉kese uwatepi ba꞉gala Godokono Tutumu Tabo uwateha꞉pi iba꞉te pelamete iba꞉go pepola꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ba꞉ba tetelo komo Pa꞉lisi kapiyuimipi dubate ba꞉be komo umiti ebe ta꞉matapa꞉tamo na꞉ga꞉luya꞉, “La꞉eno iya꞉tulamedawate ta꞉kese mani ha꞉da amiholo uwatepi ba꞉gala Godokono Tutumu Tabo uwateha꞉pa꞉go baa꞉ badama꞉ ka꞉nanako?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ya꞉suti ba꞉be tabo uliti na꞉goiya꞉, “Hidohido tawakaluba꞉te dogetatamo a꞉katolama꞉mena꞉, huiyatiya tawetawa꞉gopa꞉te kotolamema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Iyo, puya꞉te ha꞉kiya da꞉ga꞉lana, ‘A hidohido tawakalubila,’ na ba꞉bakobako tawakalubi uwatema꞉ kapiya꞉ha꞉. Na huiyatiya kubakuba tawakalubi kapiya uwatema꞉ piya꞉mo, iba꞉te na kota꞉mahenema꞉. Ba꞉bema꞉ wadiyala la꞉ ba꞉moe Godokono Buka taboeno ipuwa na꞉nohowada꞉la꞉, ‘La꞉ natamo hawa꞉goeno ilina dito akapikanama꞉la꞉, na ubihinola. Huiyatiya na ubila la꞉eno tepo ipuwalo malemale komo umi.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ba꞉bene komo Yonekono ta꞉matapa꞉te Ya꞉sutamo pelamete ebe na꞉palatediya꞉, “Mabu keka꞉ a ba꞉gala Pa꞉lisi kapiyuimipi a hiliyonomate hiya꞉hiya꞉ tetelo baa꞉ nahaheno da꞉pola꞉nanakoma꞉ Godokono oko owatima꞉, huiyatiya ama꞉ ta꞉matapa꞉te baa꞉ nahaheno a꞉kapola꞉nala꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Dubuti kamena da꞉lawemene, ba꞉ba tetelo ebeno mabuluba꞉te poko habalo tepo menemena꞉go dito ba꞉ka꞉pola꞉namena꞉? Ao, wadiyaha꞉! Iba꞉te eba꞉go poko baa꞉ kapimilo konahama꞉na꞉. Huiyatiya kamena uli lawe dubuti ebeno kamena eta habamo magata tete ba꞉ na꞉pe, hibila, ba꞉ba tetelo ebeno mabuluba꞉te ibino tepo temeteme komoma꞉ baa꞉ nahaheno kopola꞉nama꞉na꞉. Ba꞉bema꞉ numa꞉la꞉, ka꞉lo ba꞉ la꞉eno kalakalago baa꞉ naha tetela mabu nale la꞉go bemedenamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ba꞉bene Ya꞉suti tabo moga꞉melo gala na꞉kagoiya꞉, “Lumagiti uli kaliko hapu pakala kalikoeno bolagala꞉mo a꞉kakohomehamene, mabu kaliko ukula tetelo ba꞉be uli kaliko haputi pakala kaliko kanagiya꞉midalema꞉ne, ba꞉bene bolagalete konomoma꞉ keda꞉ma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ba꞉gala atu gabodo eta lumagiti pakala gautu-goe tama kalila꞉mo uli gao beya a꞉kahaminamene, mabu uli gao beyate pakala gautu-goe tama kalili ka꞉na꞉ta꞉pumima꞉ne, ba꞉bene gao beyate hakamo ka꞉ka꞉la꞉te gao beya ba꞉gala kalili ibi netewate kapiya tetelo kokubakubahama꞉na꞉. Ba꞉moe mabuma꞉ iya꞉tawadawate uli gao beya uliuli tama kalili kapiyamo na꞉haminahanakamene, gao beya ba꞉gala kalili iba꞉te tete ga꞉ga꞉lo hidamo kopola꞉nama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ya꞉suti ba꞉moe tabo iba꞉tamo ba olamagita, Yu watodawa dubuti ebetamo pete pupamo pemedete na꞉pegoiya꞉, “Naeno bohele ka꞉ma꞉nomo hoe, huiyatiya ama꞉ pete amia꞉no kokoto ebetamo da꞉pemowatilamemena꞉ ebete hoene gala kakamahigama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ba꞉bema꞉ Ya꞉suti mahigate ebe ta꞉matapa꞉go ba꞉be ko dubu ba꞉bo ta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ba꞉ba tetelo eta kamena 12 gogo tetelo hawi ka꞉ka꞉la꞉ temetemete duminami, ebete Ya꞉sukunu gala hapuni pete ebeno kaliko ba꞉bo pologiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","mabu ebete nemalagidoluya꞉, “Nale ebeno kaliko dologimo, nale kohidoma꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ya꞉suti ohobigate ebe dumiya꞉ ebetamo na꞉goiya꞉, “Kamena, ama꞉ na꞉kalakala! Amia꞉no hibima꞉ midi komote ama꞉ a꞉hiduima꞉ta.” Ba꞉ba tetenomolo ba꞉be kamenoeno temetemete ba꞉bo wibomiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ba꞉bene Ya꞉suti Yu watodawa dubuino genamamo pete hoe bohele la꞉mema꞉ pa꞉lola꞉ da꞉moleholitiya꞉ ba꞉bi dubu ba꞉gala tawakalubi hiliyonomo ba꞉bo pulamiya꞉, iba꞉te howele konomago pola꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ba꞉bema꞉ ebete ibi na꞉goelamiya꞉, “La꞉ hiliyonomo genama guni nikula꞉la꞉. Bohele deha꞉poto kahaa꞉kaha꞉, ebete u bewatita.” Huiyatiya ibi hiliyonomate ebe na꞉walitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ba꞉ba tetelo Ya꞉suti tawakalubi genamane poelamete bohelete da꞉kapitanuya꞉ ba꞉be habamo na꞉pa꞉gate ebeno kokoto da꞉nelawemiya꞉ ebete ba꞉bo mahiguya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ba꞉bene ba꞉be hanohano komoeno tabote ba꞉be hopo konomamo ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ya꞉suti ba꞉be haba miya꞉pate ba tonato, baidi tamiholame dubu netewapa꞉te ebe ba ta꞉matanato ibulunomamo ba꞉bo nega꞉lapatiya꞉, “Da꞉ibidikono Hogo! Ama꞉ a na꞉malemalea꞉tea꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ba꞉bene Ya꞉suti eta genama guamo nodolote ba꞉bi baidi tamiholame dubate atu genamamo da꞉kanodoluya꞉ Ya꞉suti ibi nalateda꞉liya꞉, “La꞉ hibima꞉ na꞉ka꞉midiutama, nagodolo helo bitana la꞉ kohiduilamema꞉?” Iba꞉te tabo ba huiya na꞉ga꞉luya꞉, “Iyo, Kodawa, ama꞉godolo helo bitana.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ba꞉ba tetelo Ya꞉suti ibino baida꞉mo ebeno kokoto ba emowatilame iba꞉tamo na꞉goiya꞉, “Mabu la꞉le na hibima꞉ a꞉midinimata, ba꞉be mabuma꞉ nale la꞉eno baidi kohiduilamema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ba꞉bene ibino baiditi da꞉hidohidoholamiya꞉, Ya꞉suti ibi koamo kiyahalamelo iba꞉tamo na꞉goiya꞉, “La꞉ ba꞉moe komoma꞉ komo tawakalubi akakiyalama꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","huiyatiya iba꞉te tote ba꞉be hopo konomamo Ya꞉sukunu komo ba꞉bo nikiyahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ba꞉bene ba꞉bi dubu netewapa꞉te ba tuta komo tawakaluba꞉te eta dubu Ya꞉sutamo ba꞉bo magatuya꞉, mabu ebe tabo olamagiha꞉ kuba gobogobagoenola. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ba꞉ba tetelo Ya꞉suti ebegodone kuba gobogobo doemiya꞉ ebete tabo olamagi ba꞉bo tupuimiya꞉, ba꞉bema꞉ hiliyonomo tawakaluba꞉te ba꞉moe komo umiti hanohanoholo na꞉ga꞉luya꞉, “A Isalaela hopolo ba꞉mako komo kuminakuiha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","huiyatiya Pa꞉lisi kapiyuimipa꞉te na꞉ga꞉luya꞉, “Ebete kuba gobogoboeno Kodawoeno heloamo oelamenako, Godokono heloamoha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ya꞉suti Yunapino koko ba꞉gala hegehege habahabado da꞉petonakui, ba꞉ba tetelo ebete ibino hiya꞉hiya꞉ baidi ibubulamehole genamalo ibi ba iya꞉tulame ebete Godokono Ko Gawadubu komoeno Hido Tabo iba꞉tamo ba꞉bo olamaginakui, ba꞉gala ebete ibino hiya꞉hiya꞉ temetema꞉gopi akahiduilamenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ba꞉bene eta hegelalo ebete hiliyonomo tawakalubi ulamete ebeno tepo ipuwalo konomamo malemalelatelitiya꞉, mabu iba꞉te ukui bilibilima꞉ ba꞉gala heloha꞉ma꞉ eda꞉hutiya꞉, sipi-goegoa꞉te ulamedawaheno keba ka꞉na kemedena ba꞉ba ka꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goiya꞉, “Godokono pali ipuwalo kona hiliyonomo ba꞉ a꞉kodakodahui, huiyatiya wakalami okopi hiliyoha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ba꞉bema꞉ la꞉ pali namutudawatamo toetoe tabo na꞉ga꞉lala꞉, ebete komo okopi pali ipuwamo kopoelamema꞉ne hidohido kona nahoeno kopewakalamiholema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ba꞉ba tetelo Ya꞉suti ebeno 12 ta꞉matapi dubu ebetamo ka꞉lamiti iba꞉tamo helo ba꞉bo ikalamiya꞉, iba꞉te tawakaluba꞉godone kuba gobogobo konoelamema꞉ ba꞉gala hiya꞉hiya꞉ temetema꞉gopi konihiduilamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ba꞉moi ba꞉ Ya꞉sukunu 12 oelamepi dubuino mahilola. Dopo dubu ba꞉ Saimonotela, ebeno eta mahilo Pitate, ba꞉gala ebeno ekawi A꞉ndulutila. Sebedikono gugudi Ya꞉imesiko ba꞉gala ebeno ekawi Yoneko. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipiko, Batolomuku, Tomasiko, ba꞉gala Ma꞉tiyuku, ebe ta꞉kese uwatedawala. A꞉lapiyasikono gudu Ya꞉imesiko, Ta꞉diyasiko, ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ba꞉gala Saimonoko. Ba꞉moe eta Saimonoko ubila kapela Loma gabomani tawakaluba꞉go ba alaholo iba꞉te ebeno Ka꞉inane hopo ba꞉bo komiya꞉pama꞉. Ba꞉gala kuititidawa ba꞉ Keliyotanapi Yudasitila, ebete galane tetelo Ya꞉suku anakapumipi bowalubiliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ya꞉suti ba꞉moi 12 dubu ba oelame ibi na꞉goelamiya꞉, “La꞉ Yuha꞉pa꞉tamo akatolama꞉la꞉, ba꞉gala Samaliya hoponapa꞉tamo akanikula꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Huiyatiya la꞉ Isalaela hopolo demedehona ba꞉bi Yu tawakalubi kapiyatamo na꞉tolamiya꞉la꞉, iba꞉te tumamo dalatidiholiya꞉ ba꞉bi sipi-goegoe keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉na bemedena. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ba꞉bene la꞉ ba tolame ba꞉moe tabo kapiyate nolamagiminatuya꞉la꞉, ‘Godokono Ko Gawadubuma꞉ eda꞉ tete tatalila.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ba꞉gala la꞉ ba꞉bolo tawetawete dulamena ba꞉bi tawakalubi na꞉nihiduilamenakuya꞉la꞉, kuitikuita꞉gopi ibi atumu. Ba꞉be atu tetelo ha꞉lahapi hoe ipuwane na꞉wadiya꞉paa꞉latelenakuya꞉la꞉ ba꞉gala kuba gobogobo tawakaluba꞉godone noelamenakuya꞉la꞉. “Ba꞉ hibila, hiliyonomo tetelo Godote ebeno hidohido komo la꞉tamo malemalelo dito ikalamenakata, ba꞉bema꞉ wadiyala la꞉ komopi atu malemale komago nowalubilinakuya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ba꞉bema꞉ la꞉ ba tolame koko mani kuiha ipuwamo akamiya꞉ta꞉la꞉, ba꞉gala hegehege mani atumu akawatala꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gabo tetelo la꞉ kapiyakapiya ilina na꞉pupuliya꞉la꞉, komo akuwata꞉la꞉. Ba꞉gala la꞉ ilina miya꞉teno hika, nato ilina, ba꞉gala kuku atumu akuwata꞉la꞉, mabu habaluba꞉te hido okodawoeno modoboha꞉ komokomo ba꞉bolo na꞉modobuilamelemenakamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“La꞉ eta habamo nikuliti hido emede lumagi nohowaditi da꞉numima, ebeno genamamo nalehawaminate ebegodolo nemeda꞉tepate galane ebeno genamane eta hopamo kakatolamema꞉nemata, iyo, la꞉ eta genamane eta genamamo eba ka꞉na akanewagela꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ba꞉gala la꞉ kebe genamamo da꞉nalehawaminama, wadiyala la꞉ ba꞉be genamanapa꞉tamo nolata tabo ba꞉ma ka꞉na na꞉nega꞉luya꞉la꞉, ‘Godokono kalakalate la꞉godolo nitanamene.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ba꞉bema꞉ ba꞉be genamanapa꞉te la꞉ kalakalago uwatete la꞉eno tabo dulimina꞉, Godokono kalakalate iba꞉godolo hibilo kitanama꞉ne, huiyatiya iba꞉te la꞉ uwateheno, la꞉ nolata tabo da꞉ga꞉lama ba꞉be taboeno hibi komote ba꞉bolo a꞉kitanamene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ba꞉bene kebe tawakaluba꞉te la꞉ kalakalago uwateheno, la꞉ ba꞉be genamane o habane ba tolame la꞉eno natoeno puhulu na꞉moda꞉midatepaliya꞉la꞉. Ba꞉moe komote ibi kiya꞉tulamema꞉ne, Godokono tete ba꞉ na꞉pe ebete ibino komo kopanagilamelelamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na la꞉tamo hibi tabo begoemo, Godote tawakalubino komo danagilamelelamemene, ba꞉be Ko Hegelalo ebete ba꞉moi habaluba꞉tamo kuba huiya konomo kikalamema꞉ne. Ba꞉ba tetelo ebete Sodomo ba꞉gala Gomola habaluba꞉tamo kuba huiya ba ikalame malemale nanekela꞉mo kohawakalimima꞉ne, huiyatiya hibila, ebete malemale a꞉kihata꞉mene la꞉ uwateha꞉pa꞉tamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉ nulia꞉la꞉! La꞉ sipi-goegoe keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala, nale la꞉ helohelo gahagahoeno kapiyuimi ipuwamo oelamemata. Ba꞉bema꞉ puya꞉te la꞉go alaholohopima꞉ deda꞉hana, la꞉le iba꞉go ba nepola꞉na wadiyala la꞉ mulunomo ukuia꞉go nemalagidoleniya꞉la꞉, ba꞉gala atu tetelo tatabanomoma꞉ ba eda꞉ha temeteme eta lumagitamo akikamenakala꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","La꞉ hidamo, mabu kubapa꞉te la꞉ heloamo uwatete tabo anagiya꞉mida habamo komagatalema꞉na꞉ta, ba꞉gala Yunapino baidi ibubulamehole genama gulu iba꞉te la꞉ giya꞉pa꞉pa꞉mo ka꞉na꞉miga꞉latilima꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Iba꞉te la꞉ na mabuma꞉ hiya꞉hiya꞉ koko gawadubuino holoholo hapuamo heloago da꞉magatalemena꞉, ba꞉ba tetelo la꞉ naeno Hido Tabo iba꞉tamo ba꞉gala Yuha꞉pa꞉tamo kolamagimima꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ba꞉gala iba꞉te la꞉ tabo anagiya꞉mida habamo da꞉magatalemena꞉, ba꞉ba tetelo la꞉eno ga꞉la komoma꞉ aka-ukuibilibilihala꞉, ba꞉ma ka꞉na, ‘Na bada tabo na꞉ka꞉goemo? Ba꞉gala na tabo keba ka꞉na na꞉kolamagimo?’ Tete da꞉pemene Godote ebeno tabo komokomamo la꞉ kowalubilima꞉na꞉ta, ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","mabu la꞉ ha꞉kiya a꞉kolamagima꞉mata, la꞉eno Nabiwi Godokono Gobogobote la꞉ ipuwado kolamagima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ba꞉ba tetelo naniwiti ekawi hoea꞉mo koemema꞉ne, ba꞉gala atu gabodo ekawiti naniwi kanakapumima꞉ne. Iyo, dubuti ebeno gudu ba꞉ atumu kakamitima꞉ne, ba꞉gala guguda꞉te maubahalete ibino menokobi nabi hoea꞉mo koelamema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ba꞉bene na mabuma꞉ tawakalubi hiliyonomate la꞉tamo komaubahalema꞉na꞉, huiyatiya kebe lumagiti temeteme ipuwalo kodakodalo utiti kuitita꞉mo da꞉nuluhukumini, Godote ebeno ka꞉ka꞉ komula꞉mema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ba꞉bema꞉ iba꞉te la꞉tamo temeteme dikalamemena꞉, ba꞉ba tetelo la꞉ huiyatiya eta habamo nalahutihuya꞉la꞉. Na la꞉tamo hibi tabo begoemo, la꞉ Isalaela hopoeno haba hiliyonomolo oko ba nowatiho ba꞉bi oko upula꞉leheno Tawakalubino Naniwiti ba꞉bo kopuluhukuma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Numa꞉la꞉, tawakalubino umi ipuwalo sikulu guduino iya꞉tawa komote ebeno iya꞉tulamedawoeno iya꞉tawa kagogolonaha꞉, ba꞉gala okodawoeno helote ebeno oko namutudawoeno helo a꞉kagogolale. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ba꞉bema꞉ wadiyala sikulu guduti ebeno iya꞉tawa ipuwalo ebeno iya꞉tulamedawa keba ka꞉nala꞉ka꞉ ba꞉bakoma꞉ na꞉keda꞉mene, ba꞉gala okodawate ebeno oko ipuwalo ebeno namutudawa keba ka꞉nala꞉ka꞉ ba꞉bakoma꞉ na꞉keda꞉mene. La꞉ nulia꞉la꞉! Iba꞉te na genama namutudawa kuba gobogobo Biyesibulu mahilamo a꞉ka꞉namiya꞉, ba꞉bema꞉ galane iba꞉te atumu la꞉ naeno ekaki kuba mahilamo koka꞉lamima꞉na꞉ta!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Ba꞉bema꞉ ba꞉bi helohelo dubu akatolelama꞉la꞉. Kebe ihilatehole komate da꞉pola꞉na galane tetelo Godote kohawakalilamema꞉ne, ba꞉gala awalelahale komate da꞉pola꞉na galane tawakaluba꞉te kulameholema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ba꞉bema꞉ nale du tetelo la꞉ da꞉kiyalamenakoma, la꞉le huiyatiya alo tetelo nolamagiminakuya꞉la꞉, ba꞉gala la꞉ nagodone ganalo dulihonakoma, ba꞉bi komokomoma꞉ la꞉eno tabo madodo ba adipate tawakalubi hiliyonomatamo na꞉hawakalilamenakuya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","La꞉ ape anakapulame iya꞉tawahapi akatolelama꞉la꞉. Iba꞉godolo helo puliyala tawakalubino gobogobo anakapulamete Koe Habamo iya꞉hekema꞉. Huiyatiya la꞉ Godoko kapiya na꞉tolemenala꞉, mabu ebegodolo helo bitana tawakalubino ape ba꞉gala gobogobo Koe Habamo kapimilo iya꞉hekema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Numa꞉la꞉, tawakaluba꞉te netewa de holahola kapiya toea mana꞉mo uwatema꞉ ga꞉lanaka, ba꞉bi holaholoeno ka꞉ka꞉ kokoha꞉, huiyatiya la꞉eno Nabiwi Godote ba꞉bako hegehege holahola ba emalagidolena, ebete modobo tabo goeheno ibi ipuwalo eta kapiyate a꞉kahaa꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ba꞉gala hibila, la꞉eno watoeno hinibo hiliyonomo Godote ya꞉lo tetelo a꞉ka꞉lamiholiya꞉, iyo, la꞉eno hiya꞉hiya꞉ komo ebete iya꞉tawanomola. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ba꞉bema꞉ la꞉ ukui bilibilima꞉ akeda꞉hala꞉. Ebeno malemale holaholatamo hibilo bitana, huiyatiya ebeno malemale la꞉tamo konomoma꞉ eda꞉te emedena tetelo bitanamene!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Kebe lumagiti hawakala da꞉goemene, ‘Na Ya꞉suku ta꞉matadawala,’ na ba꞉ atumu Nabiwi Godokono holoholo hapulu kogoema꞉nemo, ‘Ba꞉moe lumagi ba꞉ naeno ekawila.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Huiyatiya kebe lumagiti na iya꞉tawaha꞉ma꞉ da꞉goemene, na ba꞉ atumu Godotamo ebe iya꞉tawaha꞉ma꞉ kakagoema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉ na꞉kemalagidolutama nale ba꞉moe hopamo gelebadi adahema꞉ pe? Ao, na tawakaluba꞉tamo gelebadi ikalamema꞉ kapiya꞉ha꞉, na alaholo gili ikalamema꞉ piya꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Numa꞉la꞉, naeno tabo komokomoma꞉ anagiya꞉mida komote tawakalubi ipuwalo kuluhukuma꞉ne. Ba꞉ ba꞉ma ka꞉na anagiya꞉mida komote dubu ba꞉gala ebeno nabiwi ibi ipuwalo kitanama꞉ne, ba꞉gala bohele ebeno menokago ibi ipuwalo kitanama꞉ne, ba꞉gala kamena ebeno awino menokago ibi ipuwalo kitanama꞉ne. Iyo, na anagiya꞉mida komo tawakaluba꞉tamo ikalamema꞉ piya꞉mo, ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ba꞉bema꞉ hibila, na mabuma꞉ dubuino genamanapa꞉te eba꞉go kalaholohoma꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ba꞉bema꞉ kebe lumagiti ebeno nabiwi ba꞉gala menoko konomamo ba emalagidole na nanekela꞉mo demalagidolonena, ba꞉be lumagiti naeno oko owatima꞉ a꞉kamodobamene. Ba꞉gala kebe lumagiti ebeno gugudi konomamo ba emalagidolena na nanekela꞉mo demalagidolonena, ba꞉be lumagiti naeno oko owatima꞉ a꞉kamodobamene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ba꞉gala kebe lumagiti ebeno keha pihiga aguti na ta꞉maheneheno, ebete atumu naeno oko owatima꞉ a꞉kamodobamene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ba꞉bema꞉ kebe lumagiti ebeno kateneno ubi gabodo ba to ebeno ka꞉ka꞉ natamo damawada꞉mene, ebeno ka꞉ka꞉te kalatidima꞉ne, huiyatiya kebe lumagiti ebeno ka꞉ka꞉ na mabuma꞉ datutimini, ebete hibi ka꞉ka꞉ kolawema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Kebe lumagiti ama꞉ kalakalago dowalubina ebete na bowalubinina, ba꞉gala kebe lumagiti na dowalubinina ebete na kapiya kowalubininaha꞉, ebete na Oenamedawa Godoko atumu na꞉ka-owalubina. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ba꞉bema꞉ kebe lumagiti Godokono ukui hawakalimidawa kalakalago dowalubina ebete galane Godogodone ebeno ukui hawakalimidawoeno huiya konelawema꞉ne, ba꞉gala kebe lumagiti tuputupudawa kalakalago dowalubina ebete ba꞉ atumu tuputupudawoeno huiya konelawema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na la꞉tamo hibi tabo begoemo, ba꞉moi hegehegepi ipuwalo kebe lumagiti na ta꞉mahenedawama꞉ deda꞉na, ba꞉be mabuma꞉ etate gibagiba beya ebetamo dikamemene, ebete Godogodone da꞉lawemene ba꞉be hido huiyate a꞉kalatida꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ba꞉bene Ya꞉suti ebeno 12 ta꞉matapi iya꞉tulame da꞉wibuya꞉, ebete ba꞉be haba miya꞉pate Yu tawakalubino komo habahabalo ibi iya꞉tulama꞉go ba to Godokono tabo ba꞉bo kiyahanatuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ba꞉ba tetelo Yoneko tawakalubi beyamo wadulateledawate du genamalo ba emedena, Kelisote hidohido komo dododilinami ebete ba꞉bi komo ulihote ebe ta꞉matapi ebetamo ba꞉bo oelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ba꞉bene ibi netewapa꞉te Ya꞉sutamo da꞉puluhukuya꞉ iba꞉te ebe ba꞉ma ka꞉na pega꞉lamiya꞉, “Ama꞉ ba꞉ Yonete pema꞉ da꞉goi ba꞉be lumagila꞉ka꞉, o ale eta lumagi beka꞉latiminama꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ba꞉bene Ya꞉suti huiya tabo iba꞉tamo na꞉goiya꞉, “La꞉ tote la꞉le kebe tabo kulihutama ba꞉gala kebe komo kulamiutama, ba꞉bi komokomo Yoneko na꞉nega꞉lama꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Baidi tamihopa꞉te a꞉la꞉minahala꞉ ba꞉gala nato a꞉ta꞉buta꞉midalelamepa꞉te ba꞉ na꞉wapata꞉lama꞉! Kuitikuita꞉gopa꞉te a꞉hidohidoha ba꞉gala galo duhulamepa꞉te ba꞉ nuliha! Ha꞉lahapa꞉te hoene gala a꞉kamahila꞉hala꞉ ba꞉gala awae tawakaluba꞉tamo Godokono Hido Tabote a꞉pe! ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ba꞉bema꞉ kebe lumagiti na hibima꞉ ba midini ukui netewama꞉ eda꞉heno, ebegodolo Godokono kalakala komote bitanamene!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ba꞉bene Yonete da꞉poelamiya꞉ ba꞉bi dubate ba to, Ya꞉suti Yonekono komoma꞉ tawakaluba꞉tamo ba꞉bo olamagiya꞉. Ebete na꞉goiya꞉, “La꞉ Yonekono komo ulihote dito hopamo da꞉nikulima, bada komo umima꞉ ka꞉tolamiuima? Pudu kapiya huhuti dito dagegetiti, ba꞉be umima꞉ ka꞉tolamiuima? ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O la꞉ hidohido kaliko pupuli dubu umima꞉ ka꞉tolamiuima? Ao, la꞉ iya꞉tawahala hidohido kaliko pupulihopa꞉te dito hopolo kemedehonaha꞉, huiyatiya iba꞉te koko gawadubuino genamalo ibino kateneno ubilo emedehona! ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ba꞉bema꞉ la꞉ na niya꞉tunama꞉la꞉, la꞉ badama꞉ ka꞉tolamiuima? Godokono ukui hawakalimidawa umima꞉la꞉ka꞉? Iyo, na la꞉tamo hibi tabo begoemo, Yonete Godokono ukui hawakalimipi hiliyonomo a꞉gogoli. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ba꞉ hibila, Yoneko mabuma꞉ Godote ebeno Bukalo tabo ba꞉ma ka꞉na goiya꞉, ‘Nale Kelisokono dopo hapuamo naeno tabo atadawa kopoemema꞉nemo, ebete ebe dopamete ebeno gabo kohiduimima꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ya꞉suti gala na꞉kagoiya꞉, “Nale la꞉tamo hibi tabo begoemo, tupuimi mabuni ba꞉ma teta꞉mo puluhuku ba꞉moe hopo konomolo da꞉hawakalahaliya꞉, ba꞉bi tawakalubi hiliyonomo ipuwalo Yoneko kodawanomoma꞉ eda꞉na. Huiyatiya ba꞉ma tetene tupuimiti Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be habalo kebe lumagiti deha꞉potonomoma꞉ deda꞉mene ebete Yoneko hibilo kogogoloma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ba꞉moe ba꞉ eta komola. Yoneko tetene tupuimiti ba꞉ma teta꞉mo puluhuku, helohelo dubate ubila Godokono Hido Haba ibi ha꞉kiya ibino heloamo lawete ba꞉bamo kona꞉pa꞉la꞉hama꞉, huiyatiya iba꞉te a꞉kamodobamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","La꞉ nulia꞉la꞉. Godokono ukui hawakalimipa꞉te ebeno Bukamo da꞉miya꞉tiya꞉ ba꞉gala ebete ebeno Tutumu Tabo Moseseko ipuwado tawakaluba꞉tamo dikalamiya꞉, ba꞉be hido taboeno komote ya꞉lo tetelo uluhukuti, penatete Yoneko teta꞉mo ba꞉bo puluhukui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ba꞉ hibila, Godote dopamo tabo ba꞉ma ka꞉na olamagiya꞉, ebeno ukui hawakalimidawa Elayako kopema꞉ne, iyo, Yoneko ba꞉moe ba꞉be lumagila, ba꞉bema꞉ wadiyala la꞉ ba꞉moe komo hibima꞉ na꞉mida꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Galagodawa, ama꞉ hidamo nulia꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Na ba꞉ma tete tawakalubino komo kebe go tabamo na꞉ka꞉hawakalimimo? Ibi ba꞉ kolowami habalo diya꞉da꞉mita ba꞉bi gugudi hegehege huiyala. Komo guguda꞉te komopa꞉tamo kaga꞉la, komopa꞉te komopa꞉tamo kaga꞉la, iba꞉te olowabeletihuilo ba꞉ma ka꞉na ewagelena, ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ale poko ba ododi pa꞉lola꞉ da꞉moleholema꞉ huiyatiya la꞉ ago kamoeha꞉, ba꞉gala a hoe lumagi bobamo ihatema꞉ dewagelitama꞉ huiyatiya la꞉ ebe kala꞉mitaha꞉!’ Iyo, ba꞉ma tete tawakalubi ba꞉ ba꞉ba ka꞉na ewagelena, iba꞉te Godokono okopa꞉tamo ubiha꞉ tabo bega꞉lanaka. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Numa꞉la꞉, Yonete da꞉puluhukui ba꞉ba tetelo ebete helo gao beya kaninakuiha꞉ ba꞉gala komo tetelo ebete baa꞉ naheno lutanakui Godokono oko kowatima꞉, ba꞉bema꞉ tawakaluba꞉te na꞉ga꞉luya꞉, ‘Ebe kuba gobogobagoenola!’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Huiyatiya Tawakalubino Naniwiti da꞉puluhukui, ebeno komo hiya꞉la. Ebete baa꞉ a꞉nanako ba꞉gala helo gao beya a꞉ninako, ba꞉bema꞉ iba꞉te ba꞉ma ka꞉na ga꞉lanaka, ‘Ebeno kuba numa꞉la꞉! Ebe tumu goema꞉ eda꞉te baa꞉ konomamo nanako, ebe helo gao beya ni kodawala! Ebe ta꞉kese mani ha꞉da amiholo uwatepi ba꞉gala komo Godokono Tutumu Tabo uwateha꞉pi ibino mabulubila!’” Ba꞉bene kuititinomolo Ya꞉suti iba꞉tamo na꞉goiya꞉, “Godokono hido mulu komo da꞉ta꞉matana, ba꞉bi tawakaluba꞉te ibino ododili ipuwalo ba꞉be mulu hibinomolo ba꞉hawakaliminakomena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ya꞉suti kebe habahabalo hanohano komo hiliyonomo dododilinakui, ba꞉bi haba tawakaluba꞉te ibino kuba ukui hiya꞉ma꞉ midiliti Godotamo kohobiliya꞉ha꞉. Ba꞉be mabuma꞉ Ya꞉suti ibi koamo ba꞉ma ka꞉na kiyahalamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kolasini haba, ama꞉ kuba huiya konomo kolawema꞉na꞉ta! Betasaida haba, ama꞉ ba꞉ atumu! Mabu nale la꞉godolo hanohano komo dododilimo, nale ba꞉bakobako oko Taya habalo ba꞉gala Saidono habalo dopamo nododiliya꞉tale, ba꞉bi Yuha꞉ tawakaluba꞉te ibino kubakuba ukui hiya꞉ma꞉ ba꞉midiliya꞉na꞉. Iyo, iba꞉te ibino kuba ododili mabuma꞉ tepo temetemema꞉ eda꞉hate ba꞉be temeteme kohawakalimima꞉ kubakuba kaliko pupuliti hoeno puhulamo dito ba꞉gagahidiya꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ba꞉bema꞉ na la꞉tamo na꞉goemo, Godote tawakalubino komo danagilamelelamemene, ba꞉be Ko Hegelalo ebete Taya habanapa꞉tamo ba꞉gala Saidono habanapa꞉tamo kuba huiya ba ikalame malemale nanekela꞉mo kohawakalimima꞉ne, huiyatiya hibila, Kolasini haba ba꞉gala Betasaida haba, ebete la꞉tamo malemale a꞉kihata꞉mene! ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ba꞉gala Kapeniyama haba, amia꞉no komo ba꞉ma ka꞉nala. Ama꞉ ubila ama꞉ ha꞉kiya ama꞉ Godokono Hunu Habamo kadipatema꞉, huiyatiya Godote ama꞉ Koe Habamo ka꞉da꞉nama꞉na꞉ta! Mabu nale ama꞉godolo hanohano komo dododilimo, nale ba꞉bakobako oko Sodomo habalo nododiliya꞉tale, ba꞉bi Yuha꞉ tawakaluba꞉te ibino kubane ohobila꞉hate Godote ibi ba꞉kanakapulamiya꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ba꞉bema꞉ na ama꞉tamo na꞉goemo, Godote tawakalubino komo danagilamelelamemene, ba꞉be Ko Hegelalo ebete Sodomo habaluba꞉tamo kuba huiya ba ikalame malemale nanekela꞉mo kohawakalimima꞉ne, huiyatiya Kapeniyama haba, ebete ama꞉tamo malemale a꞉kihata꞉mene!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ba꞉ba tetelo Ya꞉suti Godotamo na꞉goiya꞉, “Nabiwi, ama꞉ ba꞉moe hopo konomo ba꞉gala Hunu Haba Namutudawama꞉ eda꞉nata! Na ama꞉tamo kalakala tabo begoemo, mabu ama꞉ ba꞉moe hopoeno koko iya꞉tawahapi dubatamo amia꞉no mulu ukui ba awaminale, iya꞉tawaha꞉ tawakaluba꞉tamo hawakalilamia꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nabiwi, ba꞉ hibila, ba꞉moe komote amia꞉no ubilo puluhukui.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ba꞉bene Ya꞉suti tawakaluba꞉tamo na꞉goiya꞉, “Naeno Nabiwi Godote hiliyonomo komokomo naeno kokotamo a꞉miya꞉tiya꞉ nale kulamenama꞉, ba꞉bema꞉ ebete ha꞉kiya iya꞉tawala na ebeno Guduino komo, eta lumagiti iya꞉tawaha꞉. Ba꞉gala Nabiwino komo atumu, eta lumagiti iya꞉tawaha꞉ huiyatiya na ebeno Guduti ha꞉kiya iya꞉tawala, ba꞉gala nale puya꞉tamo Nabiwino komo hawakalimima꞉ ubi dihatemo, ibinomate atumu Nabiwino komo kakiya꞉tawahama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ba꞉bema꞉ la꞉ puya꞉te menemene ipuwalo demedenama, la꞉ natamo da꞉pelamema nale tutulu emede komo la꞉tamo kikalamema꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Numa꞉la꞉, netewa kau-goegoa꞉te oko ba owatita, namutudawate ibino abau hunamo keha pihiga ihatelamete iba꞉te kapimilo ba꞉bo kotoma꞉na꞉, ba꞉bema꞉ ama꞉ ba꞉ atumu, ama꞉ ba꞉gala na, ale badi ba꞉tonakoma꞉ oko kowatinama꞉. Ba꞉be komo ipuwalo ama꞉ naeno komo hidamo ba꞉ma ka꞉na kiya꞉tawama꞉na꞉ta, nale mulu ba꞉gala tatabadawama꞉ deda꞉namo. Ba꞉gala ama꞉ nagodone tutulu emede komo kolawema꞉na꞉ta, ");
INSERT INTO knv_aramia_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ba꞉bema꞉ nale amia꞉no abau teta꞉mo dihatemema, ama꞉ ba꞉be keha pihiga menemenenomoma꞉ a꞉kagaa꞉mena꞉ta, ba꞉gala nale ilina wagatama꞉ dikamema ama꞉ tutuma꞉ kogoema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yu tawakalubino eta okoha꞉ talona hegelalo Ya꞉suti ebe ta꞉matapa꞉go kona pali ipuwado petolamiya꞉, ba꞉bene baa꞉ kape komote ebe ta꞉matapa꞉tamo da꞉piya꞉, iba꞉te kona nahama꞉ kapiyakapiya kubakubadopo ba꞉bo newakalamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Komo Pa꞉lisi kapiyuimipa꞉te ba꞉be komo umiti Ya꞉sutamo na꞉ga꞉luya꞉, “Numa꞉, amia꞉no ta꞉matapa꞉te okoha꞉ talona hegela badikanalita.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ba꞉bene Ya꞉suti tabo ba huiya na꞉goiya꞉, “Wadiyala Godote ebeno Bukamo da꞉miya꞉tiya꞉, la꞉ ba꞉be komo nemalagidolala꞉. Da꞉ibiditamo kuba tete da꞉piya꞉, ebete ebeno wapata꞉lamepa꞉go baa꞉ma꞉ da꞉kapemitiya꞉, ba꞉bene ebete bada komo kododiya꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ebete Godokono Genamamo nodolote, ba꞉be Genamoeno okopa꞉te Godotamo da꞉miya꞉tenakui ba꞉be talona baa꞉ ebete ebeno wapata꞉lamepa꞉go a꞉nenahuya꞉. Ba꞉be komo ipuwalo iba꞉te aeno tutumu tabo adikanaliya꞉, mabu tutumu tabote a biya꞉tua꞉mena a hiliyonomate ba꞉be baa꞉ naha talonala, Godotamo hawa꞉goeno ikamehopa꞉te ha꞉kiya nahanaka. Huiyatiya numa꞉la꞉, Da꞉ibidia꞉te da꞉nahuya꞉ Godote ba꞉be komo kubama꞉ kagoiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ba꞉gala Godote ebeno Bukamo Moseseko ipuwado da꞉miya꞉tiya꞉, ba꞉moe eta komo nemalagidolala꞉. Puya꞉te ebetamo hawa꞉goeno ikamehopima꞉ deda꞉hana, iba꞉te okoha꞉ talona hegelalo ebe adikumino genamalo oko dowatihonaka, ba꞉ba tetelo iba꞉te ba꞉be talona hegela dadikanalenaka huiyatiya Godote ba꞉be komo modoboma꞉ goena. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Ba꞉bema꞉ nale la꞉tamo goemo, Godoko Adikumino Genamoeno talona hibilo bitana, huiyatiya nagodolo ditana ba꞉be talonoeno helote komo hiya꞉hiya꞉ talonoeno helo na꞉gogolena. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Godote ebeno Bukalo na꞉goena, ‘La꞉ natamo hawa꞉goeno ilina dito akapikanama꞉la꞉, na ubihinola, huiyatiya na ubila la꞉eno tepo ipuwalo malemale komo umi.’ La꞉ Pa꞉lisi kapiyuimipa꞉te ba꞉moe taboeno ipuwa niya꞉tawahotale, na ta꞉mahenepa꞉te tuputupu komo ba ododi la꞉ ibi kubapima꞉ ba꞉ka꞉ga꞉lana꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","mabu hibila, na Tawakalubino Naniwiti okoha꞉ talona hegela namutudawama꞉ eda꞉namo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ba꞉bene Ya꞉suti ibi miya꞉palete ibino baidi ibubulamehole genamamo da꞉nodoluya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","kokoto hapu hoeme dubuti ba꞉bolo na꞉lutiya꞉. Komo Pa꞉lisi kapiyuimipa꞉te ba꞉bolo da꞉pola꞉nuya꞉, ibi ubila Ya꞉suku kubadawama꞉ koga꞉lama꞉, ba꞉bema꞉ iba꞉te ebe nalatediya꞉, “Okoha꞉ talona hegelalo temetema꞉godawa hiduimima꞉ talona ba꞉kitana?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Amia꞉no sipi-goete talona hegelalo haka gugamo da꞉negamene, ama꞉ tiyolo ebe nowalubiti konuluhukutima꞉na꞉ta, aba꞉ hibila꞉ka꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","La꞉ ba꞉moe komo iya꞉tawahala, sipi-goeno ka꞉ka꞉ komote koma꞉ keda꞉naha꞉ huiyatiya lumagino ka꞉ka꞉ ba꞉ ko komonomola. Ba꞉bema꞉ aeno tutumu tabote talona kihatea꞉menaha꞉ okoha꞉ talona hegelalo hidohido komo ododilima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ba꞉ba tetelo Ya꞉suti kokoto hapu hoeme dubutamo na꞉goiya꞉, “Amia꞉no kokoto na꞉hogamina,” ba꞉bene ebete kokoto da꞉hogaminuya꞉ ebeno kokotote ba꞉bo hiduya꞉, hapulu hidoeno ditama꞉nuya꞉ ba꞉ba ka꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ba꞉be mabuma꞉ Pa꞉lisi kapiyuimipa꞉te maubahago tolamete tabo ba꞉bo nega꞉luya꞉ Ya꞉suku kanakapumima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ba꞉ba tetelo Ya꞉suti Pa꞉lisi kapiyuimipino kuba nopo iya꞉tawate ebete ba꞉be haba miya꞉pate ba꞉ dito tuya꞉, ba꞉bene tawakalubi hiliyonomate ebeno komo umiti ebe ba꞉bo ta꞉matuya꞉. Ibi ipuwalo puya꞉te temetema꞉go da꞉pola꞉nuya꞉ Ya꞉suti ibi hiliyonomo hiduilamete, ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ibi ba꞉ma ka꞉na kiyahalamiya꞉, “La꞉ naeno komoma꞉ tawakalubi akakiyalama꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ba꞉bema꞉ Ya꞉sukunu ododi ipuwalo Godokono ukui hawakalimidawa Aisayate da꞉goiya꞉, ba꞉be taboeno hibi komote uluhukuya꞉. Ya꞉lo tetelo ebeno tabo olamagi ipuwalo Godote ba꞉ma ka꞉na goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ba꞉moe ba꞉ naeno hido Okodawala, nale ebe dopamo a꞉ka꞉miya꞉mo. Nale ebe malemalelo ba emalagidolona ebetamo koamo na꞉kalakalanamo, ba꞉bema꞉ nale naeno Hido-talona Gobogobo ebe hunamo noemete, ba꞉bene ebete hiya꞉hiya꞉ hopo tawakaluba꞉tamo ibino ka꞉ka꞉ mula꞉lelame komoma꞉ tabo kolamagima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","“Ba꞉moe Okodawate olowabeletihui komo a꞉kiya꞉tawale, ebete naeno tabo ba olamagi a꞉kagaa꞉tepahamene, ba꞉gala tawakalubino holoholo hapulu ebete tabo madodo hunamo a꞉kadipata꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Puya꞉te heloha꞉ma꞉ deda꞉hana ebete iba꞉tamo malemala꞉go kotoma꞉ne, ba꞉ba ka꞉na ebete balibali pudu dito a꞉kadikanala꞉mene, ba꞉gala wuiki aloeno powa deha꞉potoma꞉ deda꞉na ebete dito a꞉kaha꞉guma꞉mene. “Ba꞉ hibila, naeno Okodawate hidohido komo ba ododili Tuputupu Emede komote Kuboeno wato kikipo kolawema꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ba꞉bema꞉ hopo hiliyonomoeno tawakaluba꞉te ba꞉moe naeno Okodawoeno pe komo belatimina.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ba꞉ba tetelo komo tawakaluba꞉te eta dubu Ya꞉sutamo magatuya꞉, ba꞉be dubuti tabo kolamaginakuiha꞉ ba꞉gala ebe baidi tamihomela, mabu ebe kuba gobogobagoenola. Ba꞉bene Ya꞉suti ebe da꞉hiduimiya꞉, ebete tabo olamagi tupuimiti baidi ba꞉bo a꞉la꞉minaliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ba꞉bema꞉ hiliyonomo tawakaluba꞉te ba hanohanohuta na꞉ga꞉lutiya꞉, “Diyala, ba꞉moe dubu Ya꞉suku da꞉ Da꞉ibidikono hogo Kelisotela꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Huiyatiya Pa꞉lisi kapiyuimipa꞉te ibino tabo uliti na꞉ga꞉luya꞉, “Ao, ebete kubakuba gobogoboeno Kodawa Biyesibulukunu heloamo oelamenako, Godokono heloamoha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ba꞉bema꞉ Ya꞉suti ibino kuba ukui iya꞉tawate iba꞉tamo na꞉goiya꞉, “Numa꞉la꞉, haba kapiya tawakaluba꞉te tetedo dadikanalemena꞉ ba꞉be habate kokubama꞉ne, ba꞉gala genama kapiya tawakaluba꞉te tetedo dadikanalemena꞉ ba꞉be genamanapa꞉te a꞉kemedenamena꞉, ibino genamate ba꞉ atumu kakakubama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ba꞉bema꞉ Saitanakono ukui ba꞉ma ka꞉nala, ebete ebeno kubakuba gobogobo tawakaluba꞉godone a꞉koelama꞉le, mabu ebete ba꞉ba ka꞉na dewagelemene ebeno oko owati helote kowiboma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","La꞉le naeno komoma꞉ na꞉ga꞉lamata, ‘Ebete kubakuba gobogobo Biyesibulukunu heloamo oelamenako.’ Ba꞉be tabo da꞉ga꞉lama hibila꞉ka꞉? Ao, hibiha꞉. La꞉eno kapiyuimipa꞉te kubakuba gobogobo doelamenaka, ba꞉be helo iba꞉tamo pote kikalamenako? Ba꞉ Godotela, Saitanateha꞉! Ba꞉bema꞉ la꞉eno kapiyuimipino hido ododi komote la꞉eno kuba ukui behawakalimina. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ba꞉moe komo ba꞉ hibila, nale kubakuba gobogobo Godokono Gobogoboeno heloamo oelamenakomo, ba꞉bema꞉ wadiyala la꞉ ba꞉moe komone kiya꞉tawahama꞉nemata, Godokono Ko Gawadubu tetete la꞉tamo ba꞉ a꞉pe. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Numa꞉la꞉, Saitanako ba꞉ eta helo dubu keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala, ba꞉gala ebete pilolo duwatiya꞉ ba꞉bi tawakalubi ba꞉ ebeno genamoeno ilinala. Ba꞉bema꞉ tawakaluba꞉te ba꞉mako helo dubuino genamamo ogomote ebeno ilina uwatemema꞉ ubi dihatemena꞉, iba꞉te dopamo ebe hala꞉mo matuhumihote ba꞉bene ebeno ilina ba꞉bo kuwatemema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ba꞉ hibila, kebe lumagiti na owalubinihino ebete naeno alaholodawama꞉ eda꞉na, ba꞉ma ka꞉na ebete tawakalubi kapiya baha꞉mo magahelema꞉ nago oko owatihino huiyatiya ibi hiya꞉hiya꞉ oelamenako. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ba꞉bema꞉ nale la꞉ begoelamemata, tawakalubino hiya꞉hiya꞉ hiliyonomo kuba komo Godote egebolelamete adodohole iya꞉tawala, ba꞉gala kebe lumagiti Godoko ubiha꞉ma꞉ da꞉goemene, ba꞉be kuba tabo komo Godote egebolemete kadodomema꞉ne. Huiyatiya kebe lumagiti Godokono Gobogoboeno ododi komoma꞉ kubama꞉ da꞉goemene, Godote ba꞉be kuba egebolemete a꞉kadodoma꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ba꞉bema꞉ kebe lumagiti Tawakalubino Naniwino komoma꞉ duhimi tabo dolamagimini, Godote ebeno kuba egeboleme iya꞉tawala, huiyatiya kebe lumagiti Godokono Gobogoboeno oko owati komoma꞉ duhimi tabo dolamagimini, Godote ba꞉be kuba egebolemete a꞉kadodomenamene, emedena emedena tetelo ebeno kubate bitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ya꞉suti tabo moga꞉melo gala na꞉kagoiya꞉, “Naeno gao keba ka꞉nala꞉ka꞉? La꞉ keha hidoma꞉ da꞉ga꞉lanakoma ba꞉be kehoeno gao ba꞉ hidohidoenola, huiyatiya la꞉ eta keha kubama꞉ da꞉ga꞉lanakoma ba꞉be kehoeno gao ba꞉ kubakubala. Iyo, ba꞉ hibila, la꞉ hiya꞉hiya꞉ kehoeno gao ibino holoholamo dulamema la꞉ ba꞉bo kiya꞉tawahama꞉nemata ibi ipuwalo kebe gaote nahama꞉ hidohidoma꞉ keda꞉hana. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pa꞉lisi kapiyuimipa꞉la꞉, la꞉ ba꞉ bu kalulata! La꞉eno tepo ipuwa kubanomoma꞉ ba eda꞉hana hido tabo keba ka꞉na na꞉ka꞉ga꞉loma? Gabohenola! Mabu lumagino tepo ipuwalo kebe komate ka꞉pola꞉na, ba꞉ ba꞉bi komate ebeno tabo olamagi komodo kopikulima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ba꞉bema꞉ hido lumagiti ebeno tepo ipuwane hidohido komo buluhukulatelenakomene, huiyatiya kuba lumagino tepo ipuwalo kuba komate pola꞉na, ba꞉bema꞉ ebegodone kuba komate ba꞉pikulinakomena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Na la꞉tamo na꞉goemo, tawakaluba꞉te ibino hiya꞉hiya꞉ kuba tabo dolamagiminaka, ba꞉bi kuba tabo mabuma꞉ iba꞉te Godokono Ko Hegelalo ebeno dopo hapuamo konikulima꞉na꞉, ba꞉bene ebete ibino hiliyonomo komo ba anagilamelelame iba꞉tamo huiya dikalamemene, ibi ipuwalo eta lumagiti ebe duhimima꞉ eta tabo a꞉kagaa꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ba꞉bema꞉ ama꞉ hidamo! Ama꞉le kebe hiya꞉hiya꞉ tabo dolamaginaka, galane tetelo Godote ba꞉bi hiliyonomo tabo ba anagilameleme, ebete ama꞉ tuputupudawama꞉ da꞉ goemene o ama꞉ kubadawama꞉ da꞉ ka꞉mimitamena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ba꞉bene komo Pa꞉lisi kapiyuimipi ba꞉gala Godokono Tutumu iya꞉tulamepi iba꞉te Ya꞉suku na꞉ga꞉lamiya꞉, “Iya꞉tulamedawa, a ubila ama꞉godolo eta hanohano komo umima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ya꞉suti tabo ba huiya iba꞉tamo na꞉goiya꞉, “Kuba ododilipi ba꞉gala hibima꞉ midiha꞉pi, iba꞉te ubi konomola Godokono helo hawakalimino hanohano komo kumima꞉, huiyatiya Godote eta komo a꞉kahawakalima꞉mene. Ba꞉ hibila, ebete ebeno ukui hawakalimidawa Yaonako ipuwado da꞉hawakalimiya꞉, ba꞉be hanohano komo kapiya la꞉tamo ikalamiya꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Numa꞉la꞉, Yaonate hegela netewa-kapiya ba꞉gala du netewa-kapiya ko dahoeno tepo ipuwalo lutiya꞉, ba꞉bema꞉ ba꞉be atu gabodo Tawakalubino Naniwiti hegela netewa-kapiya ba꞉gala du netewa-kapiya bobo ipuwalo kolutama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ba꞉gala eta komo. Godote tawakalubino komo danagilamelelamemene, ba꞉be Ko Hegelalo Niniba habanapa꞉te mahila꞉halete la꞉ Yu tawakalubi kubapima꞉ koka꞉lamima꞉na꞉ta, mabu ba꞉bi Yuha꞉ tawakaluba꞉te Yaonakono tabo duliya꞉ iba꞉te ibino kubane Godotamo ohobiliya꞉. Ba꞉ba tetelo ibi ubila Godokono tabo Yaonagodone lawe, huiyatiya la꞉ tetelo Godote Tawakalubino Naniwino komo la꞉tamo ba hawakalimina, la꞉ ba꞉be komo ubihinola. La꞉ numa꞉la꞉, Tawakalubino Naniwino helote Yaonakono helo na꞉gogolona! ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Ba꞉gala Godokono Ko Hegelalo Siba hoponapi Ko Gawa Kamenate mahigate la꞉ atumu kubapima꞉ koka꞉lamima꞉na꞉ta, mabu ba꞉be Yuha꞉ kamenate muhulu hoponomone piya꞉ Isalaela hopamo Ko Gawadubu Solomonokono mulu tabo kopulihoma꞉. Ba꞉ba tetelo ebe ubila Godokono mulu Solomonogodone lawe, huiyatiya la꞉ tetelo Godote Tawakalubino Naniwino komo la꞉tamo ba hawakalimina, la꞉ ba꞉be komo ubihinola. Ba꞉ hibila, Tawakalubino Naniwino muluti Solomonokono mulu na꞉gogolona!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Kuba gobogobote eta lumagigodone duluhukumini, ba꞉ba tetelo ebete gagale hopamo tote eta emede bahi kohowadinatoma꞉ne. Huiyatiya ebete hido emede bahi numihino ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ebe ha꞉kiya ebetamo kogoema꞉ne, ‘Nale da꞉miya꞉puimo ba꞉be atu emede baha꞉mo gala kakatoma꞉nemo.’ Ebete gala kapete ba꞉be emede genamalo etate emedenaheno, hidamo moda꞉midala ba꞉gala ilina hidamo miya꞉tela, ebete ba꞉be genama ba꞉ba ka꞉na kakapumima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ba꞉bene ebete gala katote komo sa꞉ba꞉ni kuba gobogobo kanadabuiliti kakamagahelema꞉ne, iba꞉te ba꞉be genamamo a꞉pa꞉la꞉hate ba꞉bolo kemedehonama꞉. Numa꞉la꞉, galane da꞉pelamemena꞉ ba꞉bi kuba gobogobate koko kuba ba꞉pododilinakomena꞉, dopamo demedenami ba꞉be kapiya kuba gobogoboeno emede huiyaha꞉. O ba꞉be lumagi niliya! Ebe dopamo nanekela꞉mo kubadopola, huiyatiya ba꞉ma tetelo ebete ba꞉ kubanomoma꞉ eda꞉. Ba꞉bema꞉ ba꞉ma teteno kubakuba tawakaluba꞉la꞉, la꞉ hidamo, mabu la꞉ ba꞉ ba꞉ma ka꞉na kewagelema꞉nemata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ya꞉suti tawakaluba꞉tamo tabo ba olamagita, ebeno menoko ba꞉gala ekaki iba꞉te pelamete genama tamelo pela꞉mota꞉hanuya꞉ eba꞉go tabo kopega꞉lama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ba꞉bema꞉ tawakalubi ipuwalo etate Ya꞉suku na꞉kiyamiya꞉, “Numa꞉, amia꞉no menoko ba꞉gala ekaki iba꞉te genama tamelo ba꞉pela꞉mota꞉hana. Ibi ubila ama꞉go tabo koga꞉lama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ya꞉suti ba꞉be lumagitamo na꞉huiyuya꞉, “Naeno menoko potela꞉ka꞉, ba꞉gala naeno ekaki puya꞉tela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ba꞉bene Ya꞉suti ebe ta꞉matapi ebeno kokotamo mida꞉lamelo na꞉goiya꞉, “Ba꞉moi ba꞉ naeno menokobila ba꞉gala naeno ekakila, ");
INSERT INTO knv_aramia_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","mabu pote naeno Hunu Haboeno Nabiwino ubi komo dododimini, ba꞉be lumagi naeno menokola ba꞉gala naeno ekawila.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ba꞉be atu hegelalo Ya꞉suti genama guni uluhukuti, ebete tawakalubi iya꞉tulamema꞉ Ga꞉lili Bobo dodolo nilutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ba꞉bene tawakalubi hiliyonomate ebetamo da꞉pelamiya꞉, ebete boga꞉mo ololote dito emediya꞉ huiyatiya tawakaluba꞉te haka dodolo pela꞉mota꞉hanuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ba꞉bene ebete iba꞉tamo komo hiliyonomo komokomo iya꞉tulame uwa꞉mo ba hawakalilame eta tabo ba꞉ma ka꞉na goiya꞉, “Eta lumagiti haka da꞉hiduimi kona kikipo haminahala꞉go ba꞉bo tui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ebete haminahala꞉go ba tonato komo kikipo iba꞉te gabamo gudiya꞉, ba꞉bema꞉ holaholate pelamete ba꞉bo penaliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Komo kikipo iba꞉te nakola hakamo gudiya꞉, ba꞉bolo haka koha꞉. Ba꞉bema꞉ iba꞉te tiyonomo ikulihuya꞉ mabu haka dobodoboha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ba꞉bene hegelate da꞉podolui iba꞉te na꞉waiwaihuya꞉ mabu ibino haha ipuwamo katolameha꞉, iyo, iba꞉te ba꞉bema꞉ tiyonomo ha꞉lahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Komo kikipo iba꞉te olagopi hemo hakamo gudiya꞉, ba꞉bema꞉ ba꞉bi hemate dapepehui kona ba꞉bo alukuliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Huiyatiya komo kikipo iba꞉te hido hakamo gudiya꞉, ba꞉bema꞉ ba꞉ba꞉te apepehote ba꞉bo nolohuya꞉, komo 100 teta꞉mo, komo 60 teta꞉mo, komo 30 teta꞉mo hiliyonomoma꞉ eda꞉huya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ya꞉suti gala na꞉kagoiya꞉, “Galagodawa, ama꞉ hidamo nulia꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ba꞉ba tetelo Ya꞉suku ta꞉matapa꞉te ebetamo pelamete na꞉pega꞉luya꞉, “Bada mabuma꞉ ama꞉ uwa꞉mo tawakalubi diya꞉tulamenaka?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ya꞉suti tabo ba huiya iba꞉tamo na꞉goiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komoeno ipuwa kolawema꞉ nale helo la꞉tamo ikalamimata, iyo, ba꞉be komoeno awaminale komokomo la꞉ ba꞉ iya꞉tawahuimata. Huiyatiya nale ba꞉be iya꞉tawa komo komopa꞉tamo kikalameha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ba꞉ hibila, Godokono tabo ulihoma꞉ lumagigodolo hidohido ukui da꞉pola꞉na, Godote ebetamo hiliyonomo hidohido komo ikamehote ebeno tepo ipuwa kotabuimima꞉ne. Huiyatiya lumagigodolo hidohido ukui pola꞉naheno, ebegodolo kebe kapiyakapiya komate da꞉pola꞉na Godote ebegodone gala kakuwatemema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ba꞉be mabuma꞉ nale tawakalubi uwa꞉mo iya꞉tulamenakomo, mabu iba꞉te naeno taboeno ipuwa ohowaditi a꞉kuma꞉la꞉, iyo, iba꞉te uliti atumu a꞉kiya꞉tawahala꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ba꞉bema꞉ Godokono ukui hawakalimidawa Aisayate ibino komoma꞉ da꞉goiya꞉ ba꞉be tabote ba꞉ hibima꞉ eda꞉. Ebete ya꞉lo tetelo ba꞉ma ka꞉na goiya꞉, ‘La꞉ tabo bulinakomata huiyatiya a꞉kiya꞉tawahanakamata, iyo, la꞉ ipuwa bohowadinakomata huiyatiya a꞉kuminakamata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mabu ba꞉moe tawakalubino ukui hegabema꞉ eda꞉halamiya꞉, ibi hibi komo uli ubihinola, ba꞉bema꞉ iba꞉te galo a꞉muhilameholiya꞉, ba꞉gala ibino baidi atumu a꞉mula꞉haliya꞉. Ba꞉bema꞉ iba꞉te ibino baidi mula꞉haleha꞉ma꞉ neda꞉hatale, ibino baiditi naeno hido komo bulamena꞉, ba꞉gala ibino galote nulihotale, iba꞉te ibino tepo ipuwoeno ukui hidamo emalagidolete natamo bohobila꞉na꞉, ba꞉bema꞉ na modobola ibi hiduilamema꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goiya꞉, “Godokono kalakala konomo la꞉godolo bitana, mabu la꞉ la꞉eno baida꞉mo ebeno komokomo hidamo nulamenamata! Iyo, la꞉le la꞉eno galamo Godokono hibi komo hidamo nulihonamata! ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nale la꞉tamo hibi tabo begoemo, dopamo tetelo Godokono ukui hawakalimipi ba꞉gala komo tuputupu emede tawakalubi, iba꞉te ubi konomo bihatenama꞉ la꞉le dulamenama ba꞉bi koko komo ulamema꞉, huiyatiya iba꞉te kamodobuya꞉ha꞉, ba꞉gala ibi ubila la꞉le dulihonama ba꞉bi komo kulihoma꞉, huiyatiya iba꞉te kamodobuya꞉ha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ba꞉bema꞉ la꞉ kona kikipo haminahala꞉go da꞉tui ba꞉be lumagino uwino ipuwa nulia꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Godote Ko Gawadubuma꞉ deda꞉na, tawakaluba꞉te ba꞉be komoeno tabo uliti ipuwa hidamo iya꞉tawahaheno, ba꞉ba tetelo Saitanate pete ibino tepo ipuwane ba꞉be tabo gala kakapuwatema꞉ne. Ba꞉mako tawakalubi gabamo da꞉gudi, ibi ba꞉bi kona kikipo keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ba꞉gala komo tawakalubi nakola hakamo da꞉gudi ibi ba꞉ ba꞉bi kikipola, iba꞉te Godokono tabo dulimina꞉, ba꞉ba tetenomolo kalakalago kolawema꞉na꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","huiyatiya ibino tepo ipuwalo haha puliyala. Ba꞉bema꞉ iba꞉te Godokono oko ipuwalo nanekela꞉mo emeda꞉tepate, ba꞉bene Godokono taboma꞉ temeteme komate iba꞉tamo da꞉pikulimina꞉ ba꞉gala tawakaluba꞉te ibino komoma꞉ da꞉ga꞉lamena꞉, iba꞉te tiyonomo kalahutihoma꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Komo tawakalubi iba꞉te olagopi hemo hakamo da꞉gudi ba꞉bi kikipola. Iba꞉te Godokono tabo kulima꞉na꞉, huiyatiya iba꞉te ilina konomamo emalagidolena ba꞉gala ibino emede komoma꞉ ukui bilibilima꞉ eda꞉hana. Ba꞉bema꞉ ibino tepo ipuwalo ba꞉bakobako ukui hiliyonomo ba꞉pola꞉na, ba꞉moi ukui komate hido tabo ba anakapumi, ba꞉bene iba꞉te a꞉kanolohamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Huiyatiya komo tawakalubi iba꞉te hido hakamo da꞉gudi ba꞉bi kikipola. Iba꞉te Godokono tabo uliti hido iya꞉tawa lawete hibinomolo konolohoma꞉na꞉, komo 100 teta꞉mo, komo 60 teta꞉mo, komo 30 teta꞉mo konolohoma꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ba꞉bene Ya꞉suti eta uwi tawakalubi ba iya꞉tulame na꞉kagoiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komo ba꞉ eta dubuti ebeno pali haka hiduimiti hido kona kikipo da꞉haminahali ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Eta dulu tawakalubi hiliyonomate da꞉lahani, eba꞉go alaholodawama꞉ deda꞉nami ba꞉be dubuti penate kuba hemo kikipo pali ipuwamo pamihonate ba꞉ dito toni. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Galane tetelo konate apepehote da꞉nolohui, kuba hemate ikuliti konoeno haha ba꞉bo a꞉wiholiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ba꞉bene pali namutudawoeno okopa꞉te ebetamo pelamete ebe na꞉pega꞉lamiya꞉, ‘Ama꞉ pali ipuwamo hidohido kikipo bamihuia꞉ta, huiyatiya ba꞉moi kuba hemate kebene kikulihui?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ebete tabo ba huiya na꞉goi, ‘Eta ago dalaholona, ba꞉bete amihui.’ “Ba꞉bene okopa꞉te ebe nalatediya꞉, ‘Wadiyala꞉ka꞉ a ba꞉bi kuba hemo komagobelema꞉nema꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Namutudawate huiyatiya na꞉goi, ‘Ao, la꞉le da꞉magobelema, diyala, la꞉ atu tetelo komo hidohido kona magobeledemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ba꞉bema꞉ wadiyala iba꞉te kapimilo napepehamena꞉, huiyatiya galane naha kona uwate tetelo nale okopi kokiyalamema꞉nemo iba꞉te dopamo kuba hemo magobelete koa꞉mo kiya꞉hekema꞉, ba꞉bene iba꞉te hidohido naha kona uwatete naeno pali ilina miya꞉teno genamamo kopemiya꞉tema꞉na꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ba꞉bene Ya꞉suti eta uwi ibi ba iya꞉tulame na꞉kagoiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na ba꞉be komo ba꞉ mastada kikipo huiyala, iyo, eta tetelo dubuti ba꞉moe kikipo lawete ebeno pali ipuwamo dito ami. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Hibila, ba꞉moe hopo konomolo keha kikipo kokonomo ba꞉pola꞉na huiyatiya mastada kikipo ba꞉ deha꞉potonomola. Huiyatiya numa꞉la꞉, lumagiti damimini ba꞉be deha꞉poto kikipote apete komo hiliyonomo keha kogogolema꞉ne, ba꞉bene holaholate pelamete ba꞉be keha gedawalo ba꞉pemedehonamena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ba꞉bene Ya꞉suti eta uwi ibi ba iya꞉tulame na꞉kagoiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na ba꞉be komo ba꞉ palawa baa꞉ huhuimino puhulu ilina huiyala. Eta kamenate modobo palawa lawete huhuimino ilina nanekele hola꞉minalete ba꞉bo a꞉ba꞉gui, ba꞉bene huhuimino ilinate palawa lawenomo ba lawe palawa baa꞉te hunamo ba꞉bo mahigui.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ya꞉suti ba꞉moi komokomo tawakalubi hiliyonomatamo iya꞉tulame uwa꞉mo kiyahanakui, ba꞉ma ka꞉na ebete eta komo iba꞉tamo iya꞉tulame uwihino kakiyahanakuiha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ba꞉be komote uluhukuya꞉ Godote ebeno ukui hawakalimidawa ipuwado da꞉goiya꞉, ba꞉be tabote hibima꞉ keda꞉ma꞉. Ebete ya꞉lo tetelo tabo ba꞉ma ka꞉na goiya꞉, “Na Godote tawakaluba꞉tamo tabo olamagi tetelo iya꞉tulame uwa꞉mo bolamaginakomo. Iyo, nale ba꞉moe hopo dododiya꞉mo ba꞉ba tetene tupuimiti ba꞉ma teta꞉mo puluhuku, kebe komate awaminale ipuwalo da꞉pola꞉nama꞉, na ba꞉bi komo ba꞉ma ka꞉na kohawakalilamema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ba꞉bene Ya꞉suti tawakalubi hiliyonomo miya꞉palete genama guamo dito nodoluya꞉. Ba꞉ba tetelo ebe ta꞉matapa꞉te ebetamo pelamete na꞉pega꞉luya꞉, “Kona pali ipuwalo dapepehui ba꞉bi kuba hemoeno ipuwa keba ka꞉nala꞉ka꞉? Ama꞉ a niya꞉tua꞉ma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Hido kona kikipo kebe dubuti ka꞉haminahali, ebe ba꞉ Tawakalubino Naniwila. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ba꞉bema꞉ ebeno pali ba꞉ ba꞉moe hopo konomola, hidohido kona kikipo ibi ba꞉ Godokono Hunu Haboeno gugudila, ba꞉gala kuba hemo ibi ba꞉ Saitanakono gugudila. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kuba hemo damihui ba꞉ Saitanatela, ba꞉gala naha kona uwate tete ba꞉ ba꞉moe hopoeno kuititila, ba꞉gala naha kona uwatepi ba꞉ Godokono nopopila. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ba꞉bema꞉ okopa꞉te kuba hemo magobelete koa꞉mo diya꞉heki, ba꞉moe hopoeno kuititi ba꞉ba ka꞉na kitanama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ba꞉ba tetelo Tawakalubino Naniwiti ebeno nopopi kopoelamema꞉ne. Ba꞉bema꞉ puya꞉te ebeno tawakaluba꞉go ba emedena kuba dododilinaka, nopopa꞉te ibi hiliyonomo puwatete ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","konomo koete da꞉woena ba꞉be baha꞉mo ba꞉ dito koniya꞉hekema꞉na꞉, ba꞉bene iba꞉te ba꞉bolo lalo ba ikilame konomamo ba꞉bo kihimima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Huiyatiya Godokono tuputupu emede guguda꞉godolo ebeno alote konomamo ka꞉la꞉minama꞉ne, ibino Nabiwino Hunu Habalo da꞉la꞉minana ba꞉ba ka꞉na. Galagodawa, ama꞉ hidamo nulia꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komo ba꞉ lumagiti ko mani ba꞉gala hidohido ilina ya꞉lo tetenomolo hakamo dawaminaliya꞉ ba꞉ba ka꞉nala. Galane tetelo ebete ba꞉bo hoiya꞉, ba꞉bene gogo hiliyonomo da꞉petohuya꞉ eta lumagiti haka aligi oko ba owati ba꞉bi hidohido ilina ba꞉bo ulamiya꞉. Ba꞉ba tetelo ebete kalakalago gala kihilatelete, ba꞉bene ebeno genamamo tote ebeno ilina hiliyonomo kolowamima꞉ nimidiliti modobo mani ba꞉bo nelawiya꞉. Ba꞉bene ba꞉be mana꞉mo ebete ba꞉be haka lawete, ba꞉be haka ipuwalo ugumuililo da꞉pola꞉nuya꞉ ba꞉bi hidohido ilinate ebenoma꞉ ba꞉bo eda꞉huya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ba꞉gala Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komo ba꞉ kolowami lumagiti hidohido nehe ilina ohola꞉go da꞉pata꞉na ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Eta hegelalo ebete kapiya hidonomo nehe dumi, ba꞉ba tetelo ebeno ilina hiliyonomo kolowamima꞉ nimidiliti modobo mani nelawete, ba꞉bene ba꞉be mana꞉mo ebete ba꞉be hido nehe lawete ebenoma꞉ ba꞉bo midi.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ba꞉gala Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komo ba꞉ lumagiti daha hiliyonomo uwateholema꞉ kamahu tula꞉mo dahubi ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ba꞉bene daha hiliyonomate da꞉tahui ba꞉ba tetelo okopa꞉te kamahu tuli dodamo adimuya꞉midate hidohido daha bagolamo ba miya꞉te kubakuba daha dito iya꞉hekiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ba꞉bema꞉ ba꞉moe hopoeno kuititi ba꞉ba ka꞉na kitanama꞉ne. Ba꞉ba tetelo Godokono nopopa꞉te pelamete kuba ododilipi tuputupu emede tawakaluba꞉godone powatiya꞉midalete ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","konomo koete da꞉woena ba꞉be baha꞉mo ba꞉ dito koniya꞉hekema꞉na꞉, ba꞉bene iba꞉te ba꞉bolo lalo ba ikilame konomamo ba꞉bo kihimima꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ba꞉bema꞉ Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goiya꞉, “La꞉ ba꞉moi hiliyonomo komo hidamo na꞉kiya꞉tawahonama?” Iba꞉te tabo ba huiya na꞉ga꞉luya꞉, “Iyo, a modobola.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ba꞉bene Ya꞉suti iba꞉tamo gala na꞉kagoiya꞉, “Godokono Tutumu iya꞉tulamepi ipuwalo, pote Godokono Ko Gawadubu komoeno ipuwa lawenomo da꞉lawi, ba꞉be lumagi ba꞉ ko genama namutudawa huiyala. Ba꞉be mulu dubuino genamalo koko hidohido ilinate ba꞉pola꞉na, ba꞉ma ka꞉na pakalapakala ilina ba꞉gala uliuli ilina kapimilo ba꞉pola꞉ma꞉na, ba꞉bema꞉ ebete ebeno ubilo ba꞉bi hiya꞉hiya꞉ ilina tawakaluba꞉tamo buluhukulatelenakomene ibi hidonomamo kowalubilinama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ba꞉bene Ya꞉suti ba꞉bi iya꞉tulame uwi olamagi da꞉wibuya꞉, ebete ba꞉be habane tote ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ebeno emede haba Nasaleta꞉mo gala na꞉katuya꞉. Ebete tawakalubino baidi ibubulamehole genamalo ibi ba iya꞉tulamita iba꞉te hanohanoholo na꞉ga꞉lutiya꞉, “Moe dubuino mulu iya꞉tulame ukui ebete kebolo kiya꞉tawui? Ba꞉gala ebete hanohano komo pokono heloamo kododilina? ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ebe kapeneta dubuino gudula, ebeno menoko ba꞉ Ma꞉litila. A iya꞉tawahala ebeno ekaki Ya꞉imesiko, Yausepeko, Saimonoko, ba꞉gala Yudasiko, ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","iyo, ebeno ekaki bohelemele hiliyonomate ago bemedena. Ba꞉bema꞉ ba꞉moe dubuti ebeno helo ba꞉gala mulu kebolo kuwati?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ba꞉bene iba꞉te ebe ubiha꞉ma꞉ ba eda꞉huta Ya꞉suti ibi na꞉kiyalamiya꞉, “Godokono ukui hawakalimidawa tawakaluba꞉te ebe hunamo kadipatema꞉na꞉, huiyatiya ebeno habanapi ba꞉gala ebeno genamanapi iba꞉te ebe ubiha꞉ma꞉ beda꞉hanakomena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ba꞉bema꞉ Nasaletenapino hibima꞉ midiha꞉ mabuma꞉ Ya꞉suti ibino habalo hiliyonomo hanohano komo kododiliya꞉ha꞉, ebete ibi ipuwalo kapiyakapiyanomo bododiliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ba꞉ba tetelo Ga꞉lili hopoeno Ko Gawadubu Heloditi Ya꞉sukunu ododili komokomo ulihote, ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ebete ebeno hopopa꞉tamo na꞉goiya꞉, “Ba꞉moe Ya꞉suku ba꞉ Yonete, tawakalubi beyamo wadulateledawala. Ebete hoe ipuwane a꞉mahigui, ba꞉bema꞉ ba꞉moi hanohano komate ebegodone pikulinaka.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ba꞉moe komo ba꞉ Yonete keba ka꞉na ka꞉hoiya꞉ ba꞉be komola. Yonete dopamo ba emedena Heloditi ebeno ekawi Pilipikono kamena pilolo lawiya꞉, ba꞉be kamenoeno mahilo ba꞉ Helodiyasitila. Ba꞉moe mabuma꞉ Yonete Helodiko ba kiyahame na꞉goemiya꞉, “Ama꞉le ba꞉be kamena lawe wadiyaha꞉, ko kubanomola!” Ba꞉bema꞉ Heloditi ebeno alaholohopi da꞉kiyalamiya꞉, iba꞉te Yoneko nelawete du genama guamo dito pa꞉da꞉nuya꞉, mabu ebete ebeno ubi bihatiya꞉ ba꞉be ododi komodo ebete Helodiyasiko kokalakaluimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ba꞉ba tetelo Heloditi ebe anakapumima꞉ ubi nihatitiya꞉ huiyatiya ebete Yu tawakalubi tolelamelo dito miya꞉puya꞉, mabu iba꞉te Yoneko Godokono ukui hawakalimidawama꞉ ga꞉lanakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ba꞉bene Heloditi da꞉hawakaluya꞉, ba꞉be hegela emalagidololo ebeno mabuluba꞉te eba꞉go poko baa꞉ benahutiya꞉. Ba꞉ba tetelo Helodiyasikono bohelete ibi hiliyonomoeno holoholo hapuamo pete ba pemoita, Heloditi ebetamo koamo kalakalutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ba꞉bema꞉ ebete boheletamo na꞉goiya꞉, “Nale Godokono mahilamo goemo, ama꞉le bada komoma꞉ ubi dihatemena꞉ nale ama꞉tamo hibinomolo kikamema꞉nemata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ba꞉bene boheleno menokote ebe da꞉kiyamiya꞉, ebete Heloditamo ba꞉ma ka꞉na huiyuya꞉, “Na ubila Yoneko tawakalubi beyamo wadulateledawoeno wato kikipo kapeyago. Ka꞉lonomo natamo nikanama꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ba꞉ba tetelo Ko Gawadubu Heloditi ebeno tepo ipuwalo menemenema꞉ ediya꞉, huiyatiya ebete dopamo da꞉goiya꞉ ba꞉be tabo ebete Godokono mahilamo goiya꞉ poko tawakalubino holoholo hapulu. Ba꞉bema꞉ ebete ebeno eta alaholodawa da꞉kiyamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ba꞉be dubuti du genamamo tote Yonekono wato ba꞉bo nitamidamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ba꞉bene ebete wato kikipo kapeyago adahete boheletamo da꞉pikamiya꞉, huiyatiya ebete ebeno menokotamo dito atuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ba꞉ba tetelo Yoneko ta꞉matapa꞉te ebeno ape pelawete bobo ipuwamo dito nihatiya꞉, ba꞉bene iba꞉te tolamete ba꞉be komo Ya꞉suku ba꞉bo nikiyamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ya꞉suti ba꞉be komo uliti ebe ta꞉matapa꞉go boge lawete dito tolamiya꞉, ebete ha꞉kiya tataba hopamo konuluhukuma꞉. Huiyatiya tawakalubi hiliyonomate ebeno to komo duliya꞉, iba꞉te ibino habahabane ikuliti Ya꞉sukuba꞉ konalugama꞉ haka gabuya dito tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ba꞉bene Ya꞉suti boga꞉go da꞉nuluhukuya꞉, tawakalubi hiliyonomo nulamete ibi konomamo nemalemalelateliya꞉, ba꞉bema꞉ ebete hakamo nodolote ibino temetema꞉gopi ba꞉bo nihiduilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ba gapogapohona ebe ta꞉matapa꞉te ebetamo pelamenate ebe na꞉pega꞉lameniya꞉, “Moe tawakalubiha꞉ bahila. Tete ba꞉ a꞉wibo, tiyo kuduma꞉ne, ba꞉bema꞉ ama꞉ ibi noelama꞉, iba꞉te habahabamo tolameholete ibi ha꞉kiya ibino baa꞉ konuwatehoma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ya꞉suti ibi na꞉goelameniya꞉, “Ao, iba꞉te tolameheno la꞉le iba꞉tamo naha ilina dopamo nikalamehola꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iba꞉te na꞉huiyaniya꞉, “Agodolo paibo baa꞉ ba꞉gala daha netewa ba꞉binomate pola꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Ba꞉be baa꞉ ba꞉gala daha natamo na꞉wadaha꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ba꞉bene ebete tawakalubi hemolo ahidima꞉ da꞉kiyalameniya꞉, ba꞉ba tetelo ebete paibo baa꞉ ba꞉gala daha netewa uwatenate, Hunu Habamo gahimilo Godotamo kalakala tabo ba꞉bo goeniya꞉. Ba꞉bene ebete ba꞉bi baa꞉ wakalamiholenate ebe ta꞉matapa꞉tamo ikalamenate, iba꞉te tawakalubi hiliyonomatamo dito ikalameholeniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ba꞉ba tetelo ibi hiliyonomate baa꞉ da꞉nahaniya꞉ ibino kape komo ba꞉bo wiboholameniya꞉, ba꞉bene Ya꞉suku ta꞉matapa꞉te da꞉luhiliniya꞉ ba꞉bi baa꞉ komokomamo 12 bagolo betabuilameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ba꞉ hibila, ba꞉be baa꞉ 5,000 dubate nahaniya꞉ ibino kamenakamena guguda꞉go. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ba꞉bene ba꞉ba tetenomolo Ya꞉suti tawakalubi ba oelamena ebe ta꞉matapa꞉tamo na꞉goeniya꞉, “Boge lawete Ga꞉lili Bobo hapuamo na꞉na꞉hiwala꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ba꞉bene ebete tawakalubi hiliyonomo oelamenate ebete haka hunamo dito nodoloniya꞉ Godokoba꞉ tabo konega꞉lanama꞉. Ba꞉bene da꞉duniya꞉ Ya꞉suti ha꞉kiya ba꞉bolo lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ba꞉ba tetelo ta꞉matapa꞉te boga꞉go bobo tuli tetenomodo ba tolamena, gawiyate boge hapuamo ola꞉la꞉midanakui, hapuamo ola꞉la꞉midanakui, ba꞉ba ka꞉na ewageleniya꞉ mabu huhuti ibi na꞉duhilameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ba꞉bema꞉ du tetelo hegela owaloho tatalima꞉ ba eda꞉na, Ya꞉suti beya hunudu iba꞉tamo ba꞉bo toniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Huiyatiya ebete beya hunudu ba tonato, iba꞉te ebe uminate ba toletolehona na꞉ga꞉laniya꞉, “Gubaliti pe!” ba꞉bema꞉ iba꞉te tole konomago ba꞉bo ga꞉ga꞉niya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ba꞉ba tetenomolo Ya꞉suti ibi na꞉goelameniya꞉, “Na Ya꞉sutila, la꞉ katoletolehonala꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ba꞉bene Pitate huiyatiya ebetamo na꞉goeniya꞉, “Kodawa, ama꞉lela꞉ka꞉? Ama꞉ na na꞉kiyanama꞉, nale beya hunudu ama꞉tamo kopema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ya꞉suti ebeno tabo ba huiyana na꞉goeniya꞉, “Na꞉pa꞉!” ba꞉bene Pitate boge miya꞉panate beyamo a꞉putinate beya hunudu ebetamo ba꞉bo toniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Huiyatiya ebete ko huhuino gawiya ulamenate ba꞉bo toletoleniya꞉, ba꞉bene ebete beyamo ba ululuna Ya꞉sutamo ibulunomolo na꞉goeniya꞉, “Kodawa, ama꞉ naeno ka꞉ka꞉ na꞉mula꞉nama꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ba꞉ba tetenomolo Ya꞉suti kokoto hogaminanate Pitako lawenate na꞉goemeniya꞉, “Amia꞉no hibima꞉ midi komo koha꞉, nanekelela. Mabu keka꞉ ama꞉le ukui netewama꞉ deda꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ba꞉bene iba꞉te gala boga꞉mo da꞉kololoniya꞉ huhuti ba꞉bo wiboniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ba꞉ba tetelo Ya꞉suku ta꞉matapa꞉te ebe ba adikumina na꞉ga꞉laniya꞉, “Hibila, ama꞉ ba꞉ Godokono Gudulata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ba꞉bene iba꞉te duiduiya tetelo bobo hapuamo na꞉hiwalete Genasalete hopamo dito nikuliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ba꞉ba tetelo tawakaluba꞉te Ya꞉sukunu komo iya꞉tawahate ba꞉be hopoeno hiliyonomo habahabamo tabo na꞉noemiya꞉, iba꞉te temetema꞉gopi ebetamo komagahelema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ba꞉bema꞉ Ya꞉suti ba꞉bolo ba nemedena, temetema꞉gopa꞉te da꞉pelamenakui ebe na꞉petoemehonakuya꞉ iba꞉te ebeno kaliko kologihoma꞉, ba꞉bene puya꞉te ebeno kaliko dologihonakui ba꞉ba꞉te ba꞉bo hidohidohonakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ba꞉ba tetelo komo Pa꞉lisi kapiyuimipi ba꞉gala Godokono Tutumu iya꞉tulamepi, iba꞉te Yelusalema ko habane pelamete Ya꞉sutamo na꞉pega꞉luya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mabu keka꞉ ama꞉ ta꞉matapa꞉te aeno iniwala꞉te diya꞉tulamenakui ba꞉bi tutumu tabo da꞉wakalaminaka? Numa꞉, iba꞉te kokoto ukulaleheno baa꞉ ba꞉bo nahanaka!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “La꞉ bada mabuma꞉ iniwala꞉te da꞉ga꞉lanakui ba꞉bi tutumu tabo ba emalagidolena, huiyatiya Godokono Tutumu Tabo bewakalaminamata? ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Numa꞉la꞉, Godote ebeno Bukalo na꞉goiya꞉, ‘La꞉eno menokobi nabi nowalubila꞉la꞉,’ ba꞉gala ebete na꞉kagoiya꞉, ‘Kebe lumagiti ebeno menoko o nabiwino komoma꞉ kuba tabo dolamagimini, la꞉le ebe nanakapumiya꞉la꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Huiyatiya la꞉ ba꞉moe Godokono tabo tama꞉mo miya꞉palo na꞉ga꞉lanamata, ‘Lumagigodolo da꞉pola꞉na menoko nabiwi owalubilima꞉, ebete iba꞉tamo ikalamema꞉ ubiha꞉ma꞉ deda꞉mene, kubahenola. Ebete dito kogoema꞉ne, ‘Ba꞉moi ilina talonala, nale Godotamo ikamehote ba꞉moi ilinamo naeno menoko nabiwi a꞉kowalubila꞉mo.’ ’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ba꞉ ba꞉ma ka꞉na la꞉ ipuwalo kuba ukui lumagiti ebeno nabiwi a꞉kowaluba꞉le, mabu la꞉ Godokono hibi tabo tama꞉mo miya꞉telo huiyatiya la꞉eno iniwala꞉te da꞉ga꞉lanakui la꞉ ba꞉bi komo kapiya bododilinakomata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","La꞉ ma꞉lapila netewa tawakalubilata! Godokono ukui hawakalimidawa Aisayate la꞉eno komoma꞉ dopamo hibinomolo ba꞉ma ka꞉na goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ba꞉moi tawakaluba꞉te na tabamo adikunamena, huiyatiya ibino tepo ipuwoeno ukui na tamelo kapola꞉naha꞉, muhulunomolo ba꞉nepola꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iba꞉te naeno mahilo hunamo nadipatena, huiyatiya hibi komo puliyala, iyo, iba꞉te hopo habanapino tutumu Godokono hibi Tutumuma꞉ midiliti ba꞉bo iya꞉tulamenaka.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ba꞉bene Ya꞉suti tawakalubi hiliyonomo ebetamo ka꞉lamiti iba꞉tamo na꞉goiya꞉, “La꞉ ba꞉moe tabo uliti la꞉eno ukui hidamo na꞉tuputupuilama꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Naha ilinate lumagino tepo ipuwamo dopegamene ba꞉be ilinate ebe a꞉kakubahima꞉mene, huiyatiya lumagino tabone dikulimina꞉ ba꞉bi komate ebe kokubahimima꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ba꞉bene Ya꞉suku ta꞉matapa꞉te ebetamo pelamete na꞉pega꞉luya꞉, “Ama꞉ iya꞉tawala꞉ka꞉, Pa꞉lisi kapiyuimipa꞉te ama꞉le da꞉gaa꞉ ba꞉be taboma꞉ na꞉maubaha?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ya꞉suti huiyatiya na꞉goiya꞉, “Naeno Nabiwiti Hunu Habalo demedena, ebeno pali ipuwamo tawakaluba꞉te ha꞉kiya ibino heloamo damihonaka, ba꞉bi keha hiliyonomo ebete hahago kopemagobelema꞉ne, huiyatiya ebete ha꞉kiya kebe keha kamihona, ba꞉binomate ba꞉la꞉mota꞉hanamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ba꞉bema꞉ la꞉le Pa꞉lisi kapiyuimipino tabo akulia꞉la꞉, na꞉miya꞉paliya꞉la꞉ mabu ibi ba꞉ baidi tamihopila, iba꞉te tawakalubi kubamo iya꞉tulamenaka. Numa꞉la꞉, baidi tamiho dubuti eta baidi tamiho dubu gabodo da꞉magatamene iba꞉te haka gugamo badi konegudima꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ba꞉bene Pitate ebe na꞉goemiya꞉, “Ama꞉ ba꞉moe komoeno ipuwa a niya꞉tua꞉ma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ya꞉suti tabo ba huiya na꞉goiya꞉, “Komopa꞉te ukui hidamo katuputupuilamenaha꞉, la꞉ ba꞉ atumu. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","La꞉ iya꞉tawahala꞉ka꞉? Naha ilinate lumagi ipuwamo opegate wapamo tote ba꞉bene nea꞉go kopenuluhukuma꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","huiyatiya lumagiti ebeno tabamo dolamagimini, ba꞉bi tabo ba꞉ ebeno tepo ipuwoeno ukui mabuni kopikulima꞉na꞉, ba꞉bi tabote ebe ba꞉bo kokubahimima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Numa꞉la꞉, lumagino tepo ipuwane hiya꞉hiya꞉ kuba ukui komate pikulinaka, ba꞉bene ba꞉bi kuba ukuia꞉godone ba꞉moi koko kubate kapikulinaka — lumagi anakapumi komo ba꞉gala ilina pilo komo, bohele pilo komo ba꞉gala eta lumagino kamena pilo komo, ha꞉da tabo olamagi komo ba꞉gala eta lumagino mahilo kubahimi komo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iyo, ba꞉ hibila! Ba꞉moi kubate pikuliti lumagi ba꞉bo kokubahimima꞉na꞉, huiyatiya lumagiti kokoto ukulahaheno baa꞉ da꞉namene ba꞉be komote ebeno ukui mabu a꞉kakubahima꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ba꞉bene Ya꞉suti ba꞉be hopo miya꞉pate Taya ba꞉gala Saidono koko haboeno hopamo dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ba꞉be Ka꞉inane hopolo demedenami, eta kamena ebe Yuha꞉ lumagila, ebete Ya꞉sutamo gaa꞉tepahago pete na꞉pegoiya꞉, “Da꞉ibidikono Hogo, na na꞉malemalenatena꞉! Naeno gudu bohele kuba gobogobagoenola, ba꞉bema꞉ ebete ko temeteme biya꞉tawana!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Huiyatiya Ya꞉suti ba꞉be kamenoeno tabo kahuiyuya꞉ha꞉, ba꞉bema꞉ ebe ta꞉matapa꞉te ebetamo pelamete na꞉pega꞉luya꞉, “Ama꞉ ba꞉moe kamena gobogobamo noema꞉, mabu ebe ago da꞉patita howele konomo bododita.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ba꞉bema꞉ Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Isalaela tawakalubi ipuwalo dalatidiholiya꞉, Godote na ba꞉bi sipi-goegoe kapiya oholema꞉ poenamiya꞉, komo hopo tawakaluba꞉tamoha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ba꞉bene ba꞉be Yuha꞉ kamenate ebeno tabo uliti ebetamo gala kapete ebeno nato mabamo pepapamiwatalo na꞉pegoiya꞉, “Kodawa, ama꞉ na nowalubina꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ba꞉bema꞉ Ya꞉suti ebeno tabo ba huiya na꞉goiya꞉, “Mabu keka꞉ nale ama꞉ owalubima꞉ da꞉goita? Wadiyaha꞉ tawakaluba꞉te gugudino baa꞉ komopa꞉tamo dito ikalame, mabu ba꞉be ododi komo ba꞉ gahagahatamo ikalame komo huiyala.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kamenate Ya꞉sutamo na꞉goiya꞉, “Iyo, ama꞉le da꞉gaa꞉ ba꞉ hibila, huiyatiya eta ko dubuino baa꞉ naha habane hopamo da꞉penigudinaka, ba꞉bi baa꞉ hapuhapu gahagahate naha wadiyala!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Kamena, ama꞉godolo hibima꞉ midi komo konomo bitana, ba꞉bema꞉ ama꞉le ubi dihatita, na ba꞉be komo hibilo kododima꞉nemo.” Ba꞉ hibila, ba꞉ba tetenomolo ba꞉be kamenoeno bohelete ba꞉bo hiduya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ba꞉bene Ya꞉suti ba꞉be hopo miya꞉pate Ga꞉lili Bobo dododo petote haka hunamo nodolote dito nemediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ba꞉ba tetelo tawakalubi hiliyonomate Ya꞉sutamo ba pelame iba꞉te ibino temetema꞉gopi ebetamo ba꞉bo magaheliya꞉, ba꞉ma ka꞉na iba꞉te nato kubakubapi, baidi tamihopi, tabo olamagimiha꞉pi, ba꞉gala komo hiliyonomo hiya꞉hiya꞉ tawetawa꞉gopi Ya꞉sutamo magahelete ebeno nato mabamo da꞉pewadila꞉lateliya꞉, ebete ibi ba꞉bo hiduilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ba꞉bene tawakaluba꞉te konomamo hanohanohuya꞉ mabu iba꞉te ibino baida꞉mo ba꞉moi komokomo ulamiya꞉, tabo olamagimiha꞉pa꞉te tabo olamagimiya꞉, nato kubakubapa꞉te a꞉wapata꞉lamiya꞉, ba꞉gala baidi tamihopa꞉te a꞉la꞉minahaliya꞉. Ba꞉bema꞉ ba꞉ba tetelo Godote Isalaela tawakalubi dowalubilinako, iba꞉te ebeno mahilo hunamo ba꞉bo adipatiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ba꞉bene Ya꞉suti ebe ta꞉matapi ebetamo ka꞉lamiti ibi na꞉goelamiya꞉, “Na ba꞉moi tawakalubi na꞉malemalelatilitamo, mabu iba꞉te nago netewa-kapiya hegela demedenati ibino baa꞉ a꞉wiboholami. Na ubihinola ibi baa꞉heno ibino habahabamo dito oelame. Diyala, iba꞉te gabo tetelo heloha꞉ma꞉ da꞉ neda꞉hamena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ebe ta꞉matapa꞉te ebetamo na꞉ga꞉luya꞉, “Moe baa꞉ha꞉ hopola. Ale ba꞉moi tawakalubi hiliyonomatamo baa꞉ ikalamehole modoboha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ba꞉bene Ya꞉suti ibi nalateda꞉liya꞉, “La꞉godolo kebaleta baa꞉te ka꞉pola꞉na?” Iba꞉te na꞉ga꞉luya꞉, “Sa꞉ba꞉ni baa꞉ ba꞉gala daha hegehege kapiyakapiyate pola꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ba꞉bene Ya꞉suti tawakalubi hakamo kahidima꞉ da꞉goelamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ba꞉ba tetelo ebete ba꞉bi sa꞉ba꞉ni baa꞉ komokomo ba꞉gala daha uwatete Godotamo kalakala tabo ba꞉bo goiya꞉, ba꞉bene ebete wakalamiholete ebe ta꞉matapa꞉tamo dito ikalamiya꞉ iba꞉te tawakaluba꞉tamo kikalameholema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Ba꞉ba tetelo puya꞉te ba꞉be baa꞉ da꞉nahuya꞉ ibino kape komo ba꞉ dito wiboholamiya꞉. Ba꞉ hibila, ba꞉be baa꞉ 4,000 dubate nahuya꞉ ibino kamenakamena guguda꞉go, ba꞉bene da꞉luhiliya꞉ ba꞉bi baa꞉ komokomamo Ya꞉suku ta꞉matapa꞉te sa꞉ba꞉ni bagolo betabuilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ba꞉bene Ya꞉suti ba꞉bi tawakalubi ibino habahabamo doelamiya꞉, ba꞉ba tetelo ebete boga꞉mo ololote Magadana hopamo ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ba꞉bene komo Pa꞉lisi kapiyuimipi ba꞉gala Sa꞉diyusi kapiyuimipi iba꞉te ubi bihatiya꞉ Ya꞉sutamo pelamete ebe kuba gabamo kopemogabuimima꞉. Iba꞉te ebe ba꞉ma ka꞉na pega꞉lamiya꞉, “Ama꞉godolo Godokono helo ditana, ba꞉be komo hawakalimima꞉ eta hanohano komo atamo nododa꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ya꞉suti tabo ba huiya iba꞉tamo na꞉goiya꞉, “Hegelate ba nihitiga hegela hunu hawihawima꞉ da꞉neda꞉mene, la꞉ ba꞉be komo umiti koga꞉lama꞉nemata, ‘Dumutu hegela hidamo kopowalohoma꞉ne.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ba꞉gala eta tetelo hegelate ba owalohuta la꞉ wegola bubu dulamema la꞉ koga꞉lama꞉nemata, ‘Ba꞉moe hegelate kokubama꞉ne.’ Iyo, la꞉ alomoeno komokomo ulame iya꞉tawahala, huiyatiya ba꞉ma tetelo Godote la꞉ ipuwalo dododilina ba꞉bi komoeno ipuwa la꞉ hidamo kiya꞉tawahanaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kuba ododilipi ba꞉gala hibima꞉ midiha꞉pi, ibi ubi konomola Godokono helo hawakalimino hanohano komo kumima꞉, huiyatiya Godote eta komo iba꞉tamo a꞉kahawakalima꞉mene. Ba꞉ hibila, ebete Yaonako ipuwado da꞉hawakalimiya꞉ ba꞉be hanohano komo kapiya la꞉tamo ikalamiya꞉ta.” Ba꞉ba tetelo Ya꞉suti ibi miya꞉palete ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉go Ga꞉lili Bobo hapuamo da꞉na꞉hiwaliya꞉, ba꞉ba tetelo iba꞉te baa꞉ uwate komo nadoduya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ hidamo nulia꞉la꞉. Palawa baa꞉te ha꞉kiya hunamo da꞉mahiga, Pa꞉lisi kapiyuimipi ba꞉gala Sa꞉diyusi kapiyuimipi ibino awagaha komo ba꞉ba ka꞉nala. A꞉iye, ba꞉mako komote la꞉tamo akuluhukala꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ba꞉bema꞉ iba꞉te ibi ipuwalo tabo ba꞉ma ka꞉na ga꞉luya꞉, “Ebete atamo ba꞉moe tabo begoe mabu ale baa꞉ kawadaheha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Huiyatiya iba꞉te tabo da꞉ga꞉lutiya꞉ Ya꞉suti iya꞉tawate na꞉goiya꞉, “La꞉eno hibima꞉ midi komo kokoha꞉. La꞉le baa꞉heno pola꞉na tabo badama꞉ ka꞉ga꞉lutama? ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Keka꞉ mabu la꞉le naeno hibi komo hidamo kuminaha꞉? Nale eta gapogapolo paibo baa꞉ 5,000 dubatamo da꞉wakalamiholenimo, ba꞉moe komoma꞉ la꞉godolo ukui ba꞉kitana? Ba꞉ba tetelo la꞉ kebaleta bagolo ka꞉tabuilameonima? ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ba꞉gala eta hegelalo nale sa꞉ba꞉ni baa꞉ 4,000 dubatamo da꞉kawakalamiholimo, ba꞉ba tetelo la꞉ kebaleta bagolo ka꞉tabuilamiuima? ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","La꞉ bada mabuma꞉ naeno komo hidamo kemalagidolonaha꞉? Nale la꞉eno baa꞉ naha komoma꞉ kagoeha꞉. La꞉ hidamo, Pa꞉lisi kapiyuimipi ba꞉gala Sa꞉diyusi kapiyuimipi ibino awagaha komote la꞉tamo akuluhukala꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ba꞉bene Ya꞉suku ta꞉matapa꞉te ebeno tabo ipuwa hidamo ba꞉ma ka꞉na lawiya꞉, Ya꞉suti palawa baa꞉ hunamo mahiga tabo da꞉kiyalamiya꞉, ebete Pa꞉lisi kapiyuimipino awagaha iya꞉tulame komoma꞉ goiya꞉. Ebe ubihinola ba꞉be kubate ebe ta꞉matapa꞉tamo uluhuku. ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ba꞉bene Ya꞉suti Sisaliya-Pilipai hopamo da꞉nuluhukuya꞉ ebete ebeno ta꞉matapi ba꞉bo nalateda꞉liya꞉, “Na Tawakalubino Naniwi iba꞉te pokomo ka꞉ga꞉lanaka?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Iba꞉te na꞉ga꞉luya꞉, “Komopa꞉te ama꞉ Yoneko beyamo wadulateledawama꞉ ga꞉lanaka, komopa꞉te ama꞉ Elayama꞉ ga꞉lanaka, komopa꞉te ama꞉ Yelemayama꞉ ga꞉lanaka, ba꞉gala komopa꞉te ama꞉ Godokono ukui hawakalimidawa etama꞉ ga꞉lanaka.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ba꞉bene Ya꞉suti ibi nalateda꞉liya꞉, “Huiyatiya la꞉le na pokomo ka꞉midinionama?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimono Pitate tabo ba huiya na꞉goiya꞉, “Ama꞉ ba꞉ Kelisotela, iyo, ama꞉ ba꞉ Ka꞉ka꞉ Godoeno Gudulata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ba꞉bene Ya꞉suti ebetamo na꞉huiyuya꞉, “Saimono, Yonekono gudu, ama꞉ koamo na꞉kalakala! Mabu ba꞉moe hibi komo eta lumagiti ama꞉ kiya꞉tumiha꞉, ama꞉ naeno Hunu Haboeno Nabiwiti iya꞉tumia꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na ama꞉tamo ba꞉ma ka꞉na goemo, ‘Ama꞉ ba꞉ Pitate, naeno nakolalata. Ba꞉ hibila, nale ba꞉moe nakola hunamo naeno sose ketema꞉nemo, ba꞉bema꞉ Saitanakono hoe komote ba꞉be sose kubahimima꞉ a꞉kamodobamene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Numa꞉, nale Ko Gawadubu Godokono hiya꞉hiya꞉ ki ama꞉tamo kikamehoma꞉nemata. Ba꞉bema꞉ ama꞉le Saitanako koduhimima꞉ ba꞉moe hopolo kebe gigiho ba꞉moi kia꞉mo da꞉kalapilamena꞉ Godokono Hunu Habalo atu kalapila komote konitanama꞉ne, ba꞉gala ama꞉le lumagino ka꞉ka꞉ komula꞉mema꞉ ba꞉moe hopolo kebe gigiho ba꞉moi kia꞉mo da꞉hiya꞉midamena꞉, Hunu Habalo atu a꞉hiya꞉mida komote konitanama꞉ne.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ba꞉bene Ya꞉suti ebeno ta꞉matapi koamo ba꞉ma ka꞉na kiyahalamiya꞉, “Nale Kelisoma꞉ hibilo deda꞉namo, la꞉le ba꞉moe komo komopi akakiyalama꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ba꞉ba tetelo Ya꞉suti ebe ta꞉matapi iya꞉tulame ba꞉ma ka꞉na tupuimiya꞉, “Nale Yelusalema ko habamo tote tawakaluba꞉godone koko temeteme ba꞉bo konuwatema꞉nemo, Godokono ubila. Ba꞉bene Godotamo hawa꞉goeno ikamehopino watowatopi, ba꞉gala Godokono Tutumu iya꞉tulamepi, ba꞉gala komo koko dubu iba꞉te na kanakapunamema꞉na꞉, huiyatiya netewa-kapiya hegelalo Godote na hoene kadipanatenema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ba꞉bene Pitate Ya꞉suku komo ta꞉matapa꞉godone nanekela꞉mo magatate ebe koamo ba꞉ma ka꞉na kiyamiya꞉, “Kodawa, ba꞉moe kubate ama꞉tamo akuluhukala꞉, wadiyala Godote na꞉duhima꞉mene!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ba꞉bene Ya꞉suti ohobigate Pitatamo na꞉goiya꞉, “Pita, ama꞉ Saitanako huiyala! Na na꞉miya꞉pana꞉! Ama꞉le naeno nato ukamidadawama꞉ editata mabu amia꞉no ukui Godotamo kihatitaha꞉, ama꞉ tawakalubino ukuilo emedenata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ba꞉ba tetelo Ya꞉suti ebe ta꞉matapi na꞉goelamiya꞉, “Kebe lumagiti na ta꞉mahenema꞉ ubi dihatemene, dopamo ebete ebeno komo adodolete ebeno keha pihiga aguti na ba꞉bo na꞉ta꞉mahena꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ba꞉ hibila, kebe lumagiti ebeno ka꞉ka꞉ natamo damawada꞉mene ebeno ka꞉ka꞉te kalatidima꞉ne, huiyatiya kebe lumagiti ebeno ka꞉ka꞉ na mabuma꞉ datutimini, ebete hibi ka꞉ka꞉ ebo konumima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ba꞉bema꞉ lumagiti hopoeno ilina hiliyonomo uwatenomo ba uwate, ebeno ka꞉ka꞉ datutimini ba꞉be lumagino huiya keka꞉? Ebete ebeno ka꞉ka꞉ gala kakalawema꞉ bada ilina na꞉kikamemene? Gabo puliyala, kitanaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ba꞉ hibila, Tawakalubino Naniwiti ebeno hido-talona nopopa꞉go ba꞉gala Nabiwi Godokono helonomo alago kopema꞉ne. Ba꞉ba tetelo ebete tawakalubino komo ba anagilamelelame ibino modobo oko huiya hibilo kikalamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na la꞉tamo hibi tabo begoemo, ba꞉ma tetelo demedehona komo iba꞉te Tawakalubino Naniwi ebeno Ko Gawadubu heloago da꞉pemene, ba꞉be ko komo dopamo umiti galane ba꞉bo koha꞉lahama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ba꞉bene sikisi hegela da꞉wibuya꞉ Ya꞉suti Pitako, Ya꞉imesiko, ba꞉gala ebeno ekawi Yoneko, ibinomo bemagataliya꞉ eta hununomo hakamo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ba꞉ba tetelo ebe ta꞉matapino dopo hapulu Ya꞉sukunu apete hiya꞉ma꞉ ediya꞉, ba꞉bene ebeno holoholote hegeloeno a꞉la꞉mina keba ka꞉nala꞉ka꞉ ba꞉bakoma꞉ ba eda꞉, ebeno pupulino ilinate atumu keyakeyanomoma꞉ eda꞉hamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ba꞉bene ta꞉matapino holoholo hapuamo Moseseko ba꞉gala Elayako iba꞉te puluhukuti Ya꞉sukuba꞉ tabo ba꞉bo ga꞉lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ba꞉ba tetelo Pitate Ya꞉sutamo na꞉goiya꞉, “Kodawa, ale ba꞉malo da꞉pola꞉nama꞉, kalakala konomola. Ama꞉ ubi dihatemena꞉, nale mimiya netewa-kapiya ketemotema꞉nemo, eta amia꞉nola, eta Mosesekonola, eta Elayakonola.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pitate ba꞉be tabo ba olamagita, ba꞉ba tetenomolo hiya꞉nomo a꞉la꞉mina hawaiti pete ibi dito patulateliya꞉, ba꞉bene hawai ipuwane tabote ba꞉ma ka꞉na piya꞉, “Ba꞉moe naeno kapiya Gudunomola, na ebetamo na꞉kalakalutamo. La꞉ ebeno tabo nulia꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ba꞉bene Ya꞉suku ta꞉matapa꞉te ba꞉be tabo uliti konomamo ba toletoleho hakamo ba꞉bo gudiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","huiyatiya Ya꞉suti pete ibi ba pologihole na꞉pegoiya꞉, “Na꞉mahila꞉hala꞉, akatoletolehala꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba꞉ba tetelo iba꞉te baidi da꞉gahilameholiya꞉ eta lumagi kumiya꞉ha꞉, Ya꞉suku kapiyate ba꞉bolo la꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Iba꞉te haka hununi ba pepalaga Ya꞉suti ibi na꞉pikiyalamiya꞉, “La꞉le kebe hanohano komo dumima, ba꞉be komo ba꞉ma tetelo komopi akakiyalama꞉la꞉, huiyatiya Godote na Tawakalubino Naniwi hoene gala da꞉kadipanatenemene tawakalubi ba꞉bo kokiyalamema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ba꞉bene Ya꞉suku ta꞉matapa꞉te ebe nalatediya꞉, “Mabu keka꞉ Godokono Tutumu iya꞉tulamepa꞉te da꞉ga꞉lanaka, Elayate dopamo pete, ebeno gala hapuni Kelisote kopema꞉ne?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ebete tabo ba huiya na꞉goiya꞉, “Hibila, Elayako dopamo pete hiliyonomo komokomo kopetuputupuilamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Na la꞉tamo na꞉goemo, Elayako tawakaluba꞉tamo ya꞉lo a꞉pi huiyatiya iba꞉te ebeno komo kiya꞉tawahaha꞉, ba꞉bene iba꞉te ibino ubilo koko kuba ebetamo ododilinakuya꞉. Ba꞉bema꞉ la꞉ niya꞉tawahala꞉, Tawakalubino Naniwiti atumu iba꞉godone koko temeteme hibilo kuwatema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ba꞉bene ebe ta꞉matapa꞉te ba꞉be taboeno ipuwa hidamo ba꞉ma ka꞉na lawiya꞉, Ya꞉suti Yoneko beyamo wadulateledawoeno komoma꞉ goe. ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ba꞉ba tetelo iba꞉te komo tawakaluba꞉tamo da꞉pikuliya꞉, eta dubuti Ya꞉sutamo pete pupamo pemedete ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na꞉pegoiya꞉, “Kodawa, ama꞉ naeno kuhi na꞉malemaleta꞉! Mabu ebe ala꞉ komote lawenako, ba꞉bema꞉ komo tetelo ebe koa꞉mo ba꞉ga, beyamo ba꞉ga, ba꞉ba ka꞉na ewagelena. ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nale ebe ama꞉ ta꞉matapa꞉tamo da꞉magaha꞉kamo, huiyatiya iba꞉godolo helo puliyala ebe hiduimima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “A꞉iye, la꞉ hibima꞉ midiha꞉ kuba tawakalubilata! La꞉le natamo menemene bikanamenamata, ba꞉bema꞉ na ubihinola tete ga꞉ga꞉lo la꞉go emedena! La꞉ kuhi natamo na꞉magaha꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ba꞉bene Ya꞉suti kuba gobogobo da꞉kiyahamiya꞉ ebete kuhi ipuwane dito uluhukuya꞉, ba꞉ba tetenomolo kuhiti ba꞉bo hiduya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ba꞉bene komo tawakaluba꞉te pola꞉naha꞉ tetelo Ya꞉suku ta꞉matapa꞉te ebetamo pelamete na꞉pega꞉luya꞉, “Mabu keka꞉ ale kuba gobogobo oemema꞉ kamodobakaha꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ebete iba꞉tamo na꞉goiya꞉, “Ba꞉be mabu ba꞉ma ka꞉na bitana, la꞉eno hibima꞉ midi komote hegehegema꞉ eda꞉hana. Na la꞉tamo hibi tabo begoemo, mastada kikipo koha꞉, deha꞉potonomola. Huiyatiya la꞉eno hibima꞉ midi komote ba꞉makoma꞉ deda꞉mene, la꞉eno helote modoboma꞉ ba eda꞉ ba꞉moe hakatamo koga꞉lama꞉nemata, ‘Ama꞉ ba꞉moene ebamo na꞉toatepa!’ ba꞉bene hakate la꞉eno tabamo kopapamiwatama꞉ne. Ba꞉moe tabo ba꞉ hibila, la꞉godolo hibima꞉ midi komo ba itana eta ododiha꞉ komote a꞉kitanamene, iyo, kodakoda komote modobonomoma꞉ keda꞉ma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ba꞉bema꞉ la꞉le la꞉eno emede ipuwalo komo tetelo baa꞉ nahaheno ba pola꞉na Godokoba꞉ tabo da꞉ga꞉lanakoma, la꞉le helo ba꞉bo kolawema꞉nemata ba꞉mako kuba gobogobo oemema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Eta tetelo Ya꞉suku ta꞉matapa꞉te Ga꞉lili hopolo gala da꞉kakapiyuya꞉, ebete iba꞉tamo na꞉goiya꞉, “Godote Tawakalubino Naniwi kuba tawakalubino kokotamo kihatema꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ba꞉bene iba꞉te ebe kanakapumima꞉na꞉, huiyatiya netewa-kapiya hegelalo Godote ebe hoene gala kakadipatema꞉ne.” Ba꞉bema꞉ Ya꞉suku ta꞉matapa꞉te ebeno tabo uliti tepo temeteme konomo ba꞉bo lawiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ya꞉suku ta꞉matapa꞉te Kapeniyama habamo da꞉pelamiya꞉, ba꞉ba tetelo komo dubate Pitatamo pikuliya꞉ Godoko Adikumino Hiya꞉ Genamoeno ka꞉pita꞉isin huiya uwatema꞉. Iba꞉te tabo ba꞉ma ka꞉na pega꞉luya꞉, “La꞉eno iya꞉tulamedawate Godokono Genamoeno ta꞉kese mani a꞉kihatenako?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pitate na꞉goiya꞉, “Iyo, ihatenako.” Ba꞉bene Pitate genamamo da꞉nodoluya꞉ ebete tabo goeheno dopamo Ya꞉suti ebe na꞉goemiya꞉, “Saimono, amia꞉no ukui keba ka꞉nala꞉ka꞉? Ba꞉moe hopoeno koko gawadubatamo ta꞉kese mani puya꞉te ka꞉miya꞉tenaka? Atu hopo tawakaluba꞉tela꞉ka꞉ o kapela tawakaluba꞉tela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pitate ebeno tabo ba huiya na꞉goiya꞉, “Kapela tawakaluba꞉te ha꞉kiya miya꞉tenaka.” Ya꞉suti na꞉goiya꞉, “Iyo, ba꞉ hibila, atu hopo tawakaluba꞉te gabomana꞉tamo ta꞉kese mani a꞉kamiya꞉ta꞉la꞉. Numa꞉la꞉, a Yu tawakalubi ba꞉moe Isalaela hopoeno gugudila, ba꞉bema꞉ mabu keka꞉ ale Godokono Genamoeno okopa꞉tamo ka꞉pita꞉isin mani dikalamenakoma꞉? Mabu kitanaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Huiyatiya na iba꞉tamo temeteme ikalame ubihinola, ba꞉bema꞉ ama꞉ Ga꞉lili bobamo tote kimai na꞉notalama꞉. Dopamo da꞉ta꞉mugamene ba꞉be daha lawete ebeno tabo alalaa꞉midamete kapiya siliba mani ba꞉bo numiya꞉, ba꞉bene ama꞉ ba꞉be mani lawete Godokono Genamoeno okopa꞉tamo na꞉nikalamiya꞉, amia꞉no ba꞉gala naeno ka꞉pita꞉isin huiya komoma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ba꞉ba tetelo Ya꞉suku ta꞉matapa꞉te pelamete ebe na꞉pega꞉lamiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be habalo kodawama꞉ pote na꞉keda꞉mene?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ba꞉bene ebete gudu deha꞉poto ebetamo ka꞉miti ibi tetenomamo adipiti ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na꞉goiya꞉, “Na la꞉tamo hibi tabo begoemo, la꞉le la꞉eno awagaha ukui hiya꞉ma꞉ midiliti gugudi hegehege keba ka꞉nala꞉ka꞉ ba꞉bakoma꞉ neda꞉huya꞉la꞉, mabu la꞉ ba꞉ba ka꞉na ewageleheno Godokono Ko Gawadubu habamo a꞉kana꞉pa꞉la꞉hamata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ba꞉ hibila, kebe lumagiti ba꞉mako gudu deha꞉potomo ebe ha꞉kiya ebe hopamo dihatemene, ebete Godokono Ko Gawadubu habalo kodawama꞉ koneda꞉ma꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ba꞉gala kebe lumagiti naeno mahilamo ba꞉mako gudu deha꞉poto kalakalago dowalubina ebete na atumu na꞉kowalubinina.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Ba꞉bema꞉ deha꞉poto guduti na hibima꞉ ba midinina, kebe lumagiti ebe kuba gabamo demogabuimina, wadiyala tawakaluba꞉te ebe lawete ebeno kokoba꞉mo konomo nakola ma꞉homete kehaha꞉ kolomamo na꞉da꞉namena꞉ ebete kulukulu beyamo kululuma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","La꞉ nulia꞉la꞉, ba꞉moe hopo habate kubanomo kokubama꞉ne! Hibila, Saitanakono kuba gabamo emogabuimi komate tawakaluba꞉tamo kikulihoma꞉na꞉, huiyatiya kebe lumagigodone ba꞉mako kuba komote duluhukumini, Godote ebetamo kuba huiya konomo kikamema꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ba꞉gala amia꞉no kokotote o natote ama꞉ kuba gabamo demogabuimina, wadiyala ama꞉ itamidate gobogobamo na꞉da꞉na! Wadiyala ama꞉le kapiya kokotago o kapiya natago Godokono Ka꞉ka꞉ Habamo nopega, kubala kokoto netewago ba꞉gala nato netewago Godote ama꞉ Koe Habamo na꞉da꞉na. Ba꞉ hibila, ba꞉be habalo koete itana tetelo na꞉woena. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ba꞉gala amia꞉no baiditi ama꞉ kuba gabamo demogabuimina, wadiyala ama꞉ magubutiti gobogobamo na꞉da꞉na. Wadiyala ama꞉le kapiya baida꞉go Godokono Ka꞉ka꞉ Habamo nopega, kubala baidi netewago Godote ama꞉ Koe Habamo na꞉da꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Nale la꞉tamo na꞉goemo, Godote hegehege gugudi konomamo ba emalagidole ebete ebeno nopopi iba꞉tamo poelamenako ibi kopebuiya꞉minalema꞉. Ba꞉bema꞉ la꞉ hidamo, la꞉ ba꞉mako gudu deha꞉poto ubiha꞉ma꞉ eda꞉hate la꞉eno tabamo ebe akakubahima꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ba꞉gala eta komo. Puya꞉te kuba ododili ipuwalo dalatidiholena, na Tawakalubino Naniwiti ba꞉bi tawakalubino ka꞉ka꞉ mula꞉lelamema꞉ piya꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ba꞉bema꞉ la꞉ ba꞉moe komo keba ka꞉na na꞉kemalagidoloma? Eta dubu ebeno 100 sipi-goegoa꞉te da꞉pola꞉ma꞉na, ba꞉bene kapiyate dalatidimini ebete bada komo na꞉kododimini? Iyo, ebete 99 sipi-goegoe hido hemo hopolo miya꞉palete, ebete hunuhunu hakamo gala kanodolote dalatidi ba꞉be sipi-goe konohowadima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nale la꞉tamo hibi tabo begoemo, ba꞉be dubuino kalakalate bitana komo alatidiholeha꞉ 99 sipi-goegoa꞉tamo, huiyatiya ebete dalatidi ba꞉be sipi-goe da꞉numimini ebeno kalakalate konomoma꞉ keda꞉ma꞉ne. Ba꞉ hibila, kalakala bada konomola꞉ka꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ba꞉bema꞉ la꞉eno Hunu Haboeno Nabiwiti atumu ubihinola ba꞉mako gudu deha꞉poto kapiyate alatidi.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Amia꞉no naniwiti ama꞉tamo kuba komo dododimini, ama꞉ diya gabodo tote ebeno kuba komo ebe na꞉niya꞉tuma꞉. Ba꞉bene ebete amia꞉no tabo hibinomolo dulimini, wadiyala ama꞉ eba꞉go gala mabulubima꞉ na꞉kediya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Huiyatiya ebete amia꞉no tabo uliha꞉ma꞉ deda꞉mene, ba꞉ba tetelo ama꞉ owalubima꞉ ama꞉le komo tawakalubi kapiya o netewa na꞉nuwatiya꞉, ba꞉bene la꞉ naniwitamo pawa tolamete atu tabo da꞉nikiyahamema, ebete ba꞉ba tetelo la꞉eno tabo hibima꞉ komidima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Huiyatiya ebete la꞉eno tabo uliha꞉ma꞉ gala da꞉keda꞉mene, la꞉le ebeno komo sose tawakaluba꞉tamo na꞉nehawakalimiya꞉la꞉, ba꞉bene ebete sose tawakalubi hiliyonomoeno tabo uliha꞉ma꞉ deda꞉mene, wadiyala, nitanamene. Ba꞉ba tetelo la꞉le ebe hibima꞉ midiha꞉dawa keba ka꞉nala꞉ka꞉ ba꞉gala mani pilo dubu keba ka꞉nala꞉ka꞉ ba꞉bako lumagima꞉ miditi eba꞉go gala akakapiyala꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Na la꞉tamo hibi tabo begoemo, la꞉ Saitanakono komo koduhimima꞉ ebe keba ka꞉na da꞉matuhumihoma, ba꞉be matuhumiho komote Godokono Hunu Habalo ba꞉ba ka꞉na konitanama꞉ne, ba꞉gala lumagino ka꞉ka꞉ komula꞉mema꞉ la꞉ kebe komo ba꞉moe hopolo da꞉pahamima, ba꞉be atu komote Hunu Habalo pahami ba꞉ba ka꞉na konitanama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ba꞉bema꞉ nale la꞉tamo eta komo bekagoemo, la꞉ hibima꞉ midipi netewapa꞉te ukui kapiyama꞉ eda꞉hate naeno Hunu Haboeno Nabiwi toemeholo ebete eta komo matuhumima꞉ da꞉kiyamema, hibila, ebete la꞉eno tabo uliti ba꞉ ba꞉ba ka꞉na kododima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mabu netewa o netewa-kapiya hibima꞉ midipa꞉te ukui kapiyalo ba pola꞉na, iba꞉te naeno mahilo da꞉ka꞉mimina꞉ nale ba꞉bolo iba꞉go hibilo kolutama꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ba꞉ba tetelo Pitate Ya꞉sutamo pete na꞉pegoiya꞉, “Kodawa, naeno ekawi natamo kuba dododilinako na ebeno kuba kebako teta꞉mo na꞉kadodolememo? Sa꞉ba꞉ni teta꞉mo wadiyala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ya꞉suti ebetamo na꞉huiyuya꞉, “Na ama꞉tamo na꞉goemo, sa꞉ba꞉ni teta꞉moha꞉. Ao, wadiyala ama꞉le amia꞉no emedena tetelo ba꞉ma ka꞉na 77 teta꞉mo ebeno kuba egebolemete nadodolemenakuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ba꞉bene ebete tabo moga꞉melo na꞉goiya꞉, “La꞉ numa꞉la꞉, Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komo ba꞉moe uwino ipuwa keba ka꞉nala꞉ka꞉ ba꞉ ba꞉ba ka꞉nala. Eta hopoeno Ko Gawadubuti ebeno koko mani ba ka꞉lamihole ebeno ukui nitama꞉nui ebeno okopino hibi komo kopulamelelamema꞉. Ba꞉bene ebete ebeno ukui ba꞉ma ka꞉na ihati, okopi ipuwalo puya꞉te ebegodone owalubi mani dito duwata꞉digahui ibino komo kotuputupuilamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ba꞉bene ebete mani ka꞉lamihole da꞉tupuimi, ba꞉ba tetelo komopa꞉te ebetamo dopo okodawa bemagahiya꞉, ba꞉be dubuti ta꞉ni taosene koko mani ebegodone dopamo dito uwata꞉digui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mabu ebete ba꞉be mani huiyama꞉ ebegodolo gabote kitanuiha꞉, ba꞉bema꞉ Ko Gawadubuti ebeno hopopa꞉tamo tabo ba꞉ma ka꞉na goi, ‘La꞉ ba꞉moe dubu, ebeno kamena ebeno gugudi eba꞉go, ibi hiliyonomo uwatete komo koko dubatamo kolowamilo nikalama꞉la꞉, iba꞉te emedena tetelo ibino huiyaha꞉ okopima꞉ keda꞉hanama꞉. Na ba꞉be gabodo ba꞉moe dubuino kuba huiya ebetamo kikamema꞉nemo.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ba꞉ba tetelo huiyaha꞉ dubuti hopamo gate ebeno pupamo emedete Ko Gawadubutamo toetoelo na꞉goi, ‘Hiya꞉, ama꞉ nuta꞉tepa. Na gabo numiti ba꞉bako ko huiya hibilo kopehuiyama꞉nemo!’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Ko Gawadubuti huiyatiya ebe malemaletelo na꞉goemi, ‘Amia꞉no huiyaha꞉ komo nale egebolemete adodolememata. Ama꞉ kalakalago na꞉toa!’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Huiyatiya ba꞉be huiyaha꞉ okodawate Ko Gawadubugodone uluhukuti ba to ebeno eta mabulubi ba꞉bo numi, ba꞉be mabulubiti ebegodone dopamo 100 hegehege mani duwati, gala ebetamo kahuiyaha꞉. Ba꞉ba tetelo ebete ebe kokobene lawete ba idadanaa꞉midaha na꞉goemi, ‘Ama꞉ naeno mani natamo tiyonomo na꞉huiya!’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ba꞉bene ebeno mabulubiti hopamo gate ebetamo toetoelo na꞉goi, ‘Hiya꞉, ama꞉ nuta꞉tepa. Na gabo numiti hibilo kopehuiyama꞉nemo!’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Huiyatiya ebete ebeno mabulubi malemaleteheno du genamamo ba꞉ dito magatui, ebete ba꞉bolo ba emedena ebeno tawakaluba꞉te pehuiyate ebe ba꞉bo kopuluhukutima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ba꞉ba tetelo komo okopa꞉te ba꞉be komo umiti tepo temetemema꞉ ba eda꞉ha, iba꞉te tolamete ibino Ko Gawadubutamo ba꞉be komo ba꞉bo nehawakalimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ba꞉bene Ko Gawadubuti ba꞉be okodawa ka꞉miti koamo ba kiyahame na꞉goemi, ‘Ama꞉ kubanomo okodawalata! Ama꞉le ka꞉lo duiduiyalo na da꞉toenamehona꞉ka, nale amia꞉no konomo huiyaha꞉ komo dito egebolema꞉kamata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ba꞉bema꞉ mabu keka꞉ ama꞉le naeno eta okodawa kamalemaleta꞉kaha꞉, nale ama꞉ da꞉malamaleta꞉kama ba꞉ba ka꞉na?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ba꞉ba tetelo Ko Gawadubuti ebetamo koamo maubate du genamamo dito noemi, ebete ba꞉bolo ko temetema꞉go ba emedena ta꞉ni taosene koko mani huiyate ba꞉bo kopuluhukuma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ba꞉bene Ya꞉suti kuititi tabo ulihopa꞉tamo na꞉goiya꞉, “La꞉ numa꞉la꞉! La꞉le la꞉eno tepo ipuwoeno malemale hawakalilameheno ba꞉gala komo tawakalubino kuba egebolelameheno, ba꞉ba tetelo naeno Hunu Haboeno Nabiwiti la꞉tamo atumu ba꞉ba ka꞉na ododiti la꞉ ko temeteme habamo konoelamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ba꞉bene Ya꞉sukunu tabo olamagi komote da꞉wibomiya꞉, ebete Ga꞉lili hopo miya꞉pate Yudiya hopodo petote Yodane Tuli hapuamo dito nuluhukuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ba꞉ba tetelo tawakalubi hiliyonomate ba꞉be hopamo ebe da꞉ta꞉matuya꞉, ebete ibino temetema꞉gopi ba꞉bo nihiduilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ba꞉bene komo Pa꞉lisi kapiyuimipa꞉te Ya꞉suku kuba gabamo kemogabuimima꞉ ebetamo pelamete ebe na꞉palatediya꞉, “Kamenate ebeno awitamo bada ko kuba ododiti ebo na꞉kibukimini? O ba꞉ba tetelo awiti ebe dibukimini Godokono Tutumu Tabo ba꞉kadikanalemene?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ya꞉suti tabo ba huiya na꞉goiya꞉, “Wadiyala la꞉ Godokono Bukoeno eta tabo hidamo nemalagidolala꞉. Ba꞉be tabote ba꞉ma ka꞉na itana, Godote ba꞉moe hopoeno tupuimi mabuni dubu kamena bododiliya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ba꞉bene ebete na꞉goiya꞉, ‘Ba꞉moe mabuma꞉ dubuti ebeno nabiwi ba꞉gala menoko miya꞉palete, ebeno kamenago kapiya bahilo kemedema꞉na꞉, ba꞉bene ibi netewapa꞉te kapiyama꞉ eda꞉te gala hiya꞉ma꞉ a꞉keda꞉mena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iyo, ibi ba꞉ kapiyanomola.’ Numa꞉la꞉, Godote ibi netewapi kapiyama꞉ a꞉midiliya꞉, ba꞉bema꞉ lumagiti ibi hiya꞉ma꞉ midili modoboha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ba꞉bene Pa꞉lisi kapiyuimipi dubate Ya꞉sutamo na꞉ga꞉luya꞉, “Ama꞉ da꞉gaa꞉ ba꞉be tabote hibima꞉ deda꞉mene, keka꞉ mabu Mosesete tutumu tabo ba꞉ma ka꞉na dihatiya꞉, dubuti ebeno kamena ibukima꞉ kamena ibuki pepa ododiti ebetamo kikamema꞉ne?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Mabu la꞉eno tepo ipuwa kodakoda hibinomola Mosesete ba꞉moe tutumu la꞉tamo ba꞉bema꞉ ikalamiya꞉ta, huiyatiya ba꞉moe hopoeno tupuimi mabuni Moseseko teta꞉mo puluhuku ba꞉be komote ba꞉ba ka꞉na kitanamiha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ba꞉bema꞉ nale la꞉tamo goemo, kamenate eta dubago kuba ododihino, ba꞉ba tetelo ebeno awiti ebe ibukiti eta kamena da꞉lawemene, ebete Godokono holoholo hapulu ba꞉be kamena pilolo kolawema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ba꞉bene Ya꞉suku ta꞉matapa꞉te ebetamo na꞉ga꞉luya꞉, “Dubuti kamena lawe ipuwalo ba꞉mako kodakoda komote ditanamene, modobola dubate kamenakamena a꞉kuwatehola꞉mena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ba꞉ba tetelo Ya꞉suti huiyatiya na꞉goiya꞉, “Nale la꞉ diya꞉tulamema ba꞉be taboeno ipuwa kodakoda hibila. Godote puya꞉tamo mulu dikalamemene ibinomate ibino ukuilo ba꞉moe taboeno ipuwa lawe komodoboma꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Komo dubate kamenakamena uwateholema꞉ kamodobohonaha꞉, mabu komo ibino apete menokobino tepo ipuwalo kubakubadopoma꞉ eda꞉tepahalamiya꞉. Ba꞉gala komo dubate kamenakamena uwateholema꞉ kamodobohonaha꞉, mabu alaholo ipuwalo komopa꞉te ibi ba꞉ba ka꞉na amilatiliya꞉. Ba꞉gala komo dubate kamenakamena uwateholema꞉ kamodobohonaha꞉, mabu ibi ha꞉kiya ibi ba꞉ba ka꞉na midilina Ko Gawadubu Godokono oko kowatihonama꞉. Ba꞉bema꞉ kebe lumagiti ba꞉moe taboeno ipuwa lawe da꞉modobomene, wadiyala ebete na꞉lawa꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ba꞉bene tawakaluba꞉te gugudi Ya꞉sutamo na꞉magataliya꞉ ebete iba꞉tamo kokoto ba emowatilame Godoko kogoemema꞉ ebete ibi hidamo kowalubilinama꞉. Huiyatiya ebe ta꞉matapa꞉te tawakalubi ba kiyahalame ibi da꞉duhilamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ya꞉suti ibino ododi komo umiti na꞉goiya꞉, “Gugudi natamo pelame wadiyala. Akaduhilama꞉la꞉ mabu ba꞉mako tawakaluba꞉te Godote Ko Gawadubuma꞉ deda꞉na ba꞉be habamo kona꞉pa꞉la꞉hama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ba꞉bene ba꞉bi gugudi kowalubilima꞉ ebete ebeno kokoto iba꞉tamo emowatilamete, ibi ba miya꞉pale ebeno to gabodo ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ba꞉ba tetelo eta dubuti Ya꞉sutamo pete na꞉pegoiya꞉, “Iya꞉tulamedawa, na bada hido komo ododiti wiboha꞉ ka꞉ka꞉ ebo na꞉ka꞉lawemo?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉le hido komo ododima꞉ na badama꞉ ka꞉kiyanama꞉wa? Godoko kapiyate hidodawala, ba꞉bema꞉ ama꞉ ubi dihatemena꞉ ebeno Ka꞉ka꞉ Habamo na꞉pa꞉gama꞉, wadiyala ama꞉le ebeno Tutumu Tabamo na꞉papamiwatanakuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dubuti ebetamo na꞉huiyuya꞉, “Kebe tutumu taboma꞉ ka꞉gaa꞉wa?” Ya꞉suti ebeno tabo ba huiya na꞉goiya꞉, “Ama꞉ lumagi akanakapuma꞉la꞉, eta lumagino kamena pilolo akalawa꞉la꞉, ilina pilolo akuwata꞉la꞉, eta lumagino komoma꞉ ha꞉da tabo akolamaga꞉la꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ba꞉gala amia꞉no nabiwi menoko ibino tabamo na꞉papamiwatanakuya꞉. Ba꞉gala eta tutumu tabote ba꞉ma ka꞉na bitana, ama꞉ ha꞉kiya ama꞉ demalagidolona, wadiyala ama꞉le ba꞉ba ka꞉na ama꞉ tamelo demedena ba꞉be lumagi malemalelo nemalagidolona.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ba꞉bene ba꞉be uli ape dubuti Ya꞉sutamo na꞉goiya꞉, “Na ba꞉moi hiliyonomo tutumu kodakodalo uwatete eta kapiya kadikanaliya꞉ha꞉. Ba꞉bema꞉ na bada eta komo na꞉kododimo?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ya꞉suti tabo ba huiya na꞉goiya꞉, “Ama꞉le hidonomo lumagima꞉ keda꞉ma꞉ ubi hibilo dihatemena꞉, wadiyala ama꞉ tote komopa꞉te amia꞉no ilina mana꞉mo uwatehomete, ama꞉le ba꞉bi mani awaepa꞉tamo dito na꞉nikalamehola꞉. Ba꞉ba tetelo ama꞉ gala kapete na na꞉ta꞉maheniya꞉, ba꞉bene amia꞉no ilina hiliyonomate Godokono Hunu Habalo konepola꞉nama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ba꞉be uli ape dubuti ba꞉be tabo uliti tepo menemena꞉go dito tuya꞉, mabu ebe ilina dogodogodawanomola. ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ba꞉bema꞉ Ya꞉suti ebe ta꞉matapi na꞉goelamiya꞉, “Na la꞉tamo hibi tabo begoemo, Godote Ko Gawadubuma꞉ deda꞉na, ilina hiliyonomagodawate ba꞉be habamo na꞉pa꞉gama꞉ kodakodanomola! ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nale la꞉tamo eta komo bekagoemo, ka꞉molo-goete kaliko akohomehoeno ola gugudu nilupiga kodakodama꞉ eda꞉na, gabohenola. Ba꞉ atumu ilina hiliyonomagodawate Godokono Ko Gawadubu habamo na꞉pa꞉ga kodakodanomola, gabote hibinomolo a꞉kitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ya꞉suku ta꞉matapa꞉te ba꞉be tabo uliti konomamo la꞉wa꞉hate ebetamo na꞉ga꞉luya꞉, “Ama꞉ da꞉gaa꞉ ba꞉be tabote hibima꞉ deda꞉na, puya꞉te modobola꞉ka꞉ Godote ibino ka꞉ka꞉ mula꞉lelamema꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Huiyatiya Ya꞉suti ibi ulamenate na꞉goiya꞉, “Tawakaluba꞉te ha꞉kiya ibino ka꞉ka꞉ mula꞉le modoboha꞉, huiyatiya Godoko kapiyate modobola mabu ebegodolo helo bitana hiliyonomo komokomo ododilima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ba꞉bene Pitate Ya꞉sutamo ba huiya na꞉goiya꞉, “Ama꞉ numa꞉, a ilina hiliyonomo miya꞉palete ama꞉ na꞉ta꞉mahenata. Ba꞉bema꞉ Godote atamo bada huiya na꞉kikaa꞉memene?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Na la꞉tamo hibi tabo begoemo, Godote ba꞉moe hopoeno hiliyonomo hiya꞉hiya꞉ ilina ulinoma꞉ da꞉midilimini, ba꞉ba tetelo na Tawakalubino Naniwiti naeno Ko Gawadubu emede bahilo konomo alago kolutama꞉nemo. Ba꞉bene atu tetelo la꞉le na da꞉ta꞉mahenenama, la꞉ koko gawadubuino gagahidi bahilo gagahiditi Isalaela 12 gu tawakalubino komokomo anagilamelelamepima꞉ keda꞉hama꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hibila, kebe lumagiti ebeno genama, o ebeno nani nanikokubi ekaki, o ebeno nabi menokobi gugudi ba꞉gala ebeno hopo, ebete na mabuma꞉ ba꞉bi komokomo da꞉miya꞉palemene, ebete ba꞉bi atu komokomo hiliyonomo gala kakuwatema꞉ne, ba꞉gala galane nale ebetamo wiboha꞉ ka꞉ka꞉ kikamema꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Iyo, ka꞉lo dopopi hiliyonomo da꞉pola꞉na iba꞉te galane galapima꞉ keda꞉hama꞉na꞉, ba꞉gala ka꞉lo galapi da꞉pola꞉na iba꞉te galane dopopima꞉ keda꞉hama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ba꞉be atu tetelo Ya꞉suti na꞉kagoiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komo ba꞉ ba꞉ma ka꞉nala. Eta ko dubuti duiduiyanomolo mahigate ebeno genamane uluhukuti ba꞉bo tui ebeno gao pali okopi konuwatema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ba꞉bene ebete komo dubu nulamete iba꞉tamo kapiya hegeloeno oko huiya ikalamema꞉ negoelami. Iba꞉te ebeno tabo uliti modoboma꞉ da꞉ga꞉lui, ebete ibi ba꞉bo oelami ebeno pali oko konetupuimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ba꞉bene hegelate nanekela꞉mo da꞉podolatepui, ebete gala katote komo dubu kolowami habalo dito la꞉mota꞉hanalo da꞉nulami, ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ebete iba꞉tamo na꞉goi, ‘Wadiyala la꞉ atumu naeno pali okamo na꞉katolama꞉la꞉, ba꞉bene nale oko huiya la꞉tamo modobolo kikalamema꞉nemata.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ba꞉ba tetelo iba꞉te atu pali okamo dito katolamiya꞉. “Ba꞉bene hegela tuli tetelo ba꞉gala hegelate dewegelegui, ba꞉bi netewa teta꞉mo ebete gala katote komo okopi atumu kanulamete okamo ba꞉bo kanoelami. ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ba꞉bene hegelate gala da꞉katoatepui, ebete gala katote komo dubu kolowami habalo dito la꞉mota꞉hanalo nulamete na꞉negoelami, ‘Bada mabuma꞉ la꞉ ka꞉lo hegelalo okoheno dito da꞉pola꞉nama?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Iba꞉te ebetamo na꞉huiyuya꞉, ‘Mabu etate atamo oko kikaa꞉ma꞉kaha꞉.’ “Ba꞉bene ko dubuti iba꞉tamo na꞉goi, ‘Wadiyala la꞉ atumu naeno pali okamo na꞉katolama꞉la꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Da꞉gapogapohoni ba꞉be pali namutudawate penate ebeno oko umidawatamo na꞉pegoeni, ‘Ama꞉ okopi hiliyonomo ka꞉lamiti huiya nikalamehola꞉. Galanenomolo oko da꞉petupuima꞉ka ba꞉bi dubagodone tupuimiti, huiyatiya duiduiyanomolo oko da꞉petupuima꞉ka ama꞉le ibi kuititilo nowalubiliya꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ba꞉bene galanenomolo oko da꞉tupuimi ba꞉bi dubate dopamo pelamenate, ebete iba꞉tamo kapiya hegeloeno modobo oko huiya ba꞉ba ka꞉na ikalameni. ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ba꞉bene duiduiyanomolo oko da꞉tupuimi ba꞉bi dubate pelamenate kodopamo na꞉puwatenamo pemalagidoloniya꞉, huiyatiya ebete iba꞉tamo ba꞉ atu huiyanomo beka-ikalameholeni. ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ba꞉ba tetelo iba꞉te huiya uwatenate pali namutudawatamo ubiha꞉ tabo ba ga꞉lana, ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ibi ipuwalo etate penate na꞉pegoeni, ‘Galane da꞉tupuima꞉ka iba꞉te tete nanekela꞉mo powatiti huiyatiya ba꞉be oko huiya ago modobolo badama꞉ kuwata꞉, mabu a hegela konomolo oko ko kolohago owatitakama꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ba꞉ba tetelo ebete na꞉huiyani, ‘Naeno mabulubi, na eta kuba komo ama꞉tamo kododiha꞉. Duiduiyalo ama꞉la, nala, ale hibi tabonomo bega꞉lakama꞉ ama꞉ kapiya hegeloeno modobo oko huiya kolawema꞉, nale ama꞉tamo ba꞉ma ka꞉na ba꞉bema꞉ ikamemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ba꞉bema꞉ amia꞉no huiya lawete kalakalago na꞉toa. Ama꞉le oko huiya da꞉lawa꞉, nale ba꞉be atu modobo mani galane da꞉tupuima꞉ka iba꞉tamo ubi dihatemo, nale ba꞉ ba꞉ba ka꞉na kikalamema꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ba꞉moe oko huiya mani ba꞉ naeno manila, ba꞉bema꞉ nale ha꞉kiya naeno ubilo dododimo ba꞉be komo ba꞉ naeno komola. Mabu keka꞉ ama꞉le naeno malemale komoma꞉ da꞉maubana?’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ba꞉bema꞉ Ya꞉suti kuititi tabo ba꞉ma ka꞉na goiya꞉, “Hibila, ka꞉lo galapi hiliyonomo da꞉pola꞉na iba꞉te galane dopopima꞉ keda꞉hama꞉na꞉, ba꞉gala ka꞉lo dopopi da꞉pola꞉na iba꞉te galane galapima꞉ keda꞉hama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ba꞉bene Ya꞉suti Yelusalema ko habamo ba tuta, gabo tetelo ebete ebeno 12 ta꞉matapinomo uwatete tabo diya na꞉goelamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“La꞉ nulia꞉la꞉, a Yelusalemamo tolamitama꞉. Ba꞉bolo Godote Tawakalubino Naniwi tawakaluba꞉tamo kikalamema꞉ne, ba꞉bene Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala Godokono Tutumu iya꞉tulamepi, iba꞉te ebe anakapumima꞉ ga꞉late ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yuha꞉pa꞉tamo ba꞉bo kikalamema꞉na꞉. Ba꞉ba꞉te ebe iya꞉da꞉tete giya꞉pa꞉pa꞉mo a꞉na꞉miga꞉titi ebe ba꞉bo kanakapumima꞉na꞉, huiyatiya netewa-kapiya hegelalo Godote ebe hoene kadipatema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ba꞉bene Sebedikono gugudino menokote ebeno guguda꞉go Ya꞉sutamo pete ebeno pupamo pemedete, ebete ebe kowalubima꞉ na꞉pegoemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉ bada ubi kihatiuta nale ama꞉tamo ododima꞉?” Ebete tabo ba huiya na꞉goiya꞉, “Ba꞉moi naeno gugudi netewa na꞉kulamiuta? Ama꞉le Ko Gawadubuma꞉ deda꞉mena꞉, na ubila ama꞉le da꞉goemena꞉ etate amia꞉no tu hapulu ba꞉gala etate pele hapulu amia꞉no Ko Gawadubu helo ipuwalo kolumutitama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Huiyatiya Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉le na hido ukuia꞉mo kaga꞉lanamitaha꞉. La꞉ modobola꞉ka꞉ nale da꞉nimo ba꞉be temeteme kalila꞉mo niho?” Iba꞉te na꞉ga꞉luya꞉, “A modobola.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Ba꞉moe komo ba꞉ hibila, nale da꞉nimo la꞉ ba꞉be kalila꞉mo nihote temeteme bulihonakomata. Huiyatiya naeno tu hapuamo ba꞉gala pele hapuamo ahidi komoma꞉ nale a꞉kagaa꞉mo. Nabiwi Godote puya꞉tamo da꞉hiduilamiya꞉ ba꞉binomate ba꞉bolo kopola꞉nama꞉na꞉, iyo, ba꞉moe komoma꞉ ebete ha꞉kiya kogoema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ba꞉bene komo ta꞉ni ta꞉matapa꞉te ba꞉be komo uliti ba꞉bi dubu netewapa꞉tamo na꞉maubahalitiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","huiyatiya Ya꞉suti ibi hiliyonomo ebetamo ka꞉lamiti na꞉goiya꞉, “La꞉ iya꞉tawahala, Godoko hibima꞉ midiha꞉pino koko dubate ibi ha꞉kiya ibi ba wadiya꞉paa꞉latele komo tawakalubi heloamo kiyahalamenaka, iba꞉te ibino ubi komamo kopapamila꞉halenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Huiyatiya la꞉ ba꞉bakopima꞉ a꞉keda꞉hamata. Kebe lumagiti la꞉eno koma꞉ eda꞉ ubi dihatemene, ebete la꞉eno huiyaha꞉ okodawama꞉ neda꞉mene, ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ba꞉gala kebe lumagiti dopoma꞉ eda꞉ ubi dihatemene, ebete la꞉eno du genamoeno okodawama꞉ neda꞉mene, iyo, ebe ha꞉kiya ebe hoponomamo ihatenomo nihata꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ba꞉ma ka꞉na Tawakalubino Naniwiti da꞉piya꞉, ebe ubihinola ba꞉moe hopo tawakaluba꞉te ebetamo huiyaha꞉ okopima꞉ eda꞉ha, huiyatiya ebete na꞉piya꞉ tawakaluba꞉tamo huiyaha꞉ okodawama꞉ kopeda꞉ma꞉, ba꞉gala ebeno ka꞉ka꞉ gobogobamo ihatete ebeno hoe huiyate komo hiliyonomo tawakalubi Saitanakono du genamane dito kuluhukulatelema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ya꞉suti ebe ta꞉matapa꞉go Yeliko ko habane da꞉nikuliya꞉, ba꞉ba tetelo tawakalubi hiliyonomate ebe beta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ba꞉bene dubu netewa baidi tamiholamela, iba꞉te gabo tamelo ba lumutita Ya꞉sukunu pe komo uliti ibulunomamo na꞉ga꞉luya꞉, “Da꞉ibidikono Hogo! Ama꞉ a na꞉malemalea꞉tea꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ba꞉bema꞉ hiliyonomo tawakaluba꞉te ibi kiyahalamelo na꞉duhilamiya꞉ iba꞉te tatabalo kolumutitama꞉, huiyatiya iba꞉te gala ibulunomamo na꞉kaga꞉luya꞉, “Kodawa Ya꞉su, Da꞉ibidikono Hogo! Ama꞉ a na꞉malemalea꞉tea꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ba꞉bene Ya꞉suti ba꞉bamo utiti ibi ka꞉lamiti iba꞉tamo na꞉goiya꞉, “La꞉ bada ubi kihatiutama nale la꞉tamo kododima꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Baidi tamihopa꞉te na꞉ga꞉luya꞉, “Kodawa, aeno baidi na꞉hiduilamelea꞉ma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ba꞉bene Ya꞉suti ibi malemalelatelelo ibino baida꞉mo ebeno kokoto demowatilamiya꞉, ba꞉ba tetenomolo ibino baiditi hidohidohote iba꞉te Ya꞉suku ba꞉bo ta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ba꞉bene iba꞉te Yelusalema ko haba tama꞉mo ba pelame, Betapa꞉gi haba tamedo tolamete Olibi Kehakeha Hunu Hakamo ba꞉bo nikuliya꞉. Ba꞉ba tetelo Ya꞉suti ebe ta꞉matapi netewa dopamo ba noelame ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","iba꞉tamo na꞉goiya꞉, “La꞉ ba꞉be tatali habamo tote, ba꞉be habamo da꞉nuluhukuma donoki-goe hala꞉mo ma꞉home ebeno gudago konulama꞉digalema꞉nemata. Wadiyala la꞉ hale pahamiti ebeno gudago na꞉magaheliya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Etate la꞉ duhilame tabo da꞉goemene la꞉ huiyatiya ba꞉ma ka꞉na koga꞉lama꞉nemata, ‘Kodawate ba꞉moi donoki-goegoe ubila, ebete gala tiyonomo kakapoelamema꞉ne.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ba꞉bene ba꞉moe komote uluhukuya꞉, Godokono ukui hawakalimidawate da꞉goiya꞉ ba꞉be tabote hibima꞉ keda꞉ma꞉. Ya꞉lo tetelo ebete tabo ba꞉ma ka꞉na goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“La꞉ Yelusalemanapa꞉tamo na꞉nega꞉luya꞉la꞉, ‘Numa꞉la꞉, la꞉eno Ko Gawadubuti la꞉tamo pita. Ebete donoki-goe hunamo emedete gelebadia꞉go pita, iyo, la꞉ numa꞉la꞉, ebete donoki deha꞉potago ba꞉pe.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ba꞉bene Ya꞉suku ta꞉matapi netewapa꞉te tote, ebete keba ka꞉na ka꞉goiya꞉ iba꞉te ba꞉ ba꞉ba ka꞉na nododiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Iba꞉te donoki-goe ba꞉gala ebeno gudu Ya꞉sutamo magahelete, ibino watuino kaliko ibi hunamo miya꞉telamete, Ya꞉suti ba꞉bi kaliko hunamo ba꞉bo emediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ba꞉ba tetelo komo tawakalubi hiliyonomate ibino ga꞉ga꞉ga꞉ kaliko pipikulamete gabamo apohohago tolamiya꞉, ba꞉gala komopa꞉te ele iya꞉hiliti gabamo atumu kamiya꞉teholenatuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ba꞉bene puya꞉te da꞉dopuya꞉ ba꞉gala Ya꞉sukunu gala hapuni da꞉pelamitiya꞉, iba꞉te kapimilo ibulunomamo ba꞉ma ka꞉na ga꞉lutiya꞉, “Da꞉ibidikono hogo nadipata꞉la꞉! Godo, amia꞉no mahilago da꞉pita, wadiyala ama꞉ ba꞉be lumagi na꞉koimiya꞉! O tawakaluba꞉la꞉, la꞉ Godoko milimiholo hunamo nadipata꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ba꞉bema꞉ Ya꞉suti Yelusalema ko habamo da꞉na꞉pa꞉guya꞉, ba꞉moe haba tawakalubi hiliyonomate ebe umima꞉ pikuliti na꞉pega꞉luya꞉, “Ba꞉moe lumagi potela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ba꞉ba tetelo Ya꞉sukuba꞉ da꞉tolamitiya꞉ ibi hiliyonomate habalubino tabo ba huiya na꞉ga꞉luya꞉, “Ba꞉moe ba꞉ Godokono ukui hawakalimidawa Ya꞉sutila, ebete Ga꞉lili hopoeno Nasalete habane pe.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ba꞉ba tetelo Ya꞉suti Godoko Adikumino Hiya꞉ Genamamo tote, ba꞉be genamalo ebete ilina kolowamipi nulamete ibi hiliyonomo helonomamo neta꞉malateliya꞉, ba꞉gala ebete mani oweheta꞉midahalepino patapata gimai kolowamipino ahidi patapatago ba꞉bo nohoba꞉midahalelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ba꞉bene ebete iba꞉tamo na꞉goiya꞉, “Godokono Bukalo tabo ba꞉ma ka꞉na bitana, ‘Naeno Genama tawakaluba꞉te Godoko Adikumi Genamama꞉ koga꞉lama꞉na꞉, la꞉le huiyatiya pilo tawakalubino genamama꞉ a꞉midimata.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ba꞉ba tetelo baidi tamiholamepi ba꞉gala nato a꞉ta꞉buta꞉midalelamepi, iba꞉te Godoko Adikumino Hiya꞉ Genamamo da꞉pelamiya꞉ Ya꞉suti ibi ba꞉bo hiduilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Huiyatiya Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala Godokono Tutumu iya꞉tulamepi, iba꞉te Ya꞉sukunu hido hanohano komo dulamitiya꞉ iba꞉te ebetamo na꞉maubahalitiya꞉. Ba꞉gala ba꞉be atu tetelo iba꞉te eta komoma꞉ kamaubahalitiya꞉ ba꞉ma ka꞉na, komo guguda꞉te ba ga꞉gita da꞉ga꞉lutiya꞉, “Da꞉ibidikono hogo nadipata꞉la꞉!” Ba꞉be mabuma꞉ iba꞉te ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ya꞉suku na꞉ga꞉lamiya꞉, “Ama꞉ guguda꞉te tabo kubamo da꞉ga꞉luta na꞉kuliuta?” Huiyatiya Ya꞉suti iba꞉tamo na꞉goiya꞉, “Iyo, na nulitamo. Wadiyala la꞉ ba꞉moe Godokono Buka tabo hidamo nemalagidolala꞉, ‘O aeno Kodawa Godo, gugudi hegehege ba꞉gala nono da꞉nihona, ama꞉le ibino tabo ipuwane hidohido tabo olamaginakata ama꞉ ha꞉kiya ama꞉ komilimihonama꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ba꞉bene da꞉gapogapohoniya꞉ Ya꞉suti ibi miya꞉palenate ko haba ipuwane uluhukunate Betani habamo tonate ba꞉bo newataniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Eta duiduiyalo Ya꞉suti ko habamo gala da꞉kawiluya꞉, gabo tetelo ebe baa꞉ kapete umitiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ba꞉bene ebete anahu keha gabo tamelo pumiti gao oholema꞉ ba꞉bamo da꞉tuya꞉ huiyatiya pahanomuya nulamiya꞉. Ba꞉bema꞉ ebete anahu kehatamo na꞉goiya꞉, “Emedena tetelo gaote ama꞉godone a꞉kanolonakamene!” Ba꞉ba tetenomolo ba꞉be gao kehate kaloloma꞉ ba꞉bo ediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ya꞉suku ta꞉matapa꞉te ba꞉be komo umiti koamo hanohanohote na꞉ga꞉luya꞉, “Anahu kehate kaloloma꞉ tiyonomolo badama꞉ keda꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Na la꞉tamo hibi tabo begoemo, la꞉ hiliyonomo tetelo Godoko hibima꞉ ba midina la꞉eno tepo ipuwalo ukui netewama꞉ eda꞉haheno, nale anahu kehatamo keba ka꞉na kododimo, la꞉le ba꞉be atu komo ododima꞉ komodoboma꞉nemata. Ba꞉gala la꞉ hibima꞉ midilo ba꞉moe hakatamo ba꞉ma ka꞉na da꞉ga꞉lama, ‘Ama꞉ kehaha꞉ kolomamo na꞉toatepa!’ la꞉le ba꞉be komo hibilo kumima꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Iyo, ba꞉ hibila, la꞉ Godoko hibima꞉ ba midina bada komoma꞉ ebe da꞉toemehoma, ba꞉ba tetelo la꞉le ba꞉be komo kolawema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ba꞉bene Ya꞉suti Godoko Adikumino Hiya꞉ Genamamo tote tawakalubi ba niya꞉tulamita, ba꞉ba tetelo Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala Yu tawakalubino komo koko dubu, iba꞉te ebe duhimima꞉ pelamete ebe ba꞉ma ka꞉na palatediya꞉, “Ama꞉ ba꞉moi komo pokono heloamo kododiliona? Ba꞉gala ba꞉moe helo ama꞉tamo pote kikameti?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ya꞉suti iba꞉tamo na꞉huiyuya꞉, “Nale la꞉ dopamo kapiya komoma꞉ kalateda꞉lema꞉nemata. La꞉le na huiya tabo hidamo da꞉ga꞉lanamema, ba꞉bene nale ba꞉moi komo pokono heloamo kododilinamo, ba꞉be komo nale la꞉ ba꞉bo kokiyalamema꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Naeno alateda꞉ tabo la꞉tamo ma kumu bitana, Yonete tawakalubi beyamo da꞉wadulatelenakui, ebete ebeno helo pogodone ka꞉lawi, Godogodonela꞉ka꞉ o eta lumagigodonela꞉ka꞉?” Ba꞉bema꞉ ibi ha꞉kiya ibi ipuwalo olowabeletihuilo na꞉ga꞉luya꞉, “Ale da꞉ga꞉lama꞉ Godote Yonetamo helo ikami, ebete kogoema꞉ne, ‘Mabu keka꞉ la꞉le ebeno tabo hibima꞉ kamidiha꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ba꞉gala a modoboha꞉ ebe ba꞉ma ka꞉na ga꞉lame, hopo lumagiti Yonetamo helo ikami, mabu ale ba꞉moi tawakalubino mauba komo betolemitama꞉. Ibi hiliyonomate na꞉ga꞉lana Yoneko Godokono ukui hawakalimidawala.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ba꞉bema꞉ iba꞉te ibino tepo ipuwoeno ukui ugumuililo Ya꞉sutamo na꞉ga꞉luya꞉, “Yonekono helo mabu a iya꞉tawaha꞉.” Ba꞉bema꞉ Ya꞉suti iba꞉tamo na꞉goiya꞉, “Nale la꞉ atumu a꞉kakiyalama꞉mata nale ba꞉moi komo pokono heloamo dododilinamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ba꞉bene Ya꞉suti ba꞉bi Yu watowatopa꞉tamo na꞉goiya꞉, “Na la꞉tamo eta uwi kokiyama꞉nemo. La꞉ ba꞉be uwi hidamo uliti ebeno ipuwa natamo na꞉hawakalimiya꞉la꞉. Kapiya dubuti nemedenami, ebeno kuhi netewala. Eta hegelalo ebete ebeno dopo kuhitamo pete na꞉pegoi, ‘Ama꞉ tote naeno pali ipuwalo oko na꞉nowata꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ebeno guduti na꞉huiyui, ‘Ao, na ubihinola,’ huiyatiya galane tetelo ebete ukui hiya꞉ma꞉ miditi okamo dito tui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ba꞉bene ba꞉be dubuti ekawitamo kapete atu tabo da꞉kapegoi, ba꞉be guduti na꞉huiyui, ‘Iyo, Nabiwi, na kotoma꞉nemo,’ huiyatiya ebete katoha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ba꞉bene Ya꞉suti ebeno tabo ulihopa꞉tamo na꞉goiya꞉, “La꞉eno ukui keba ka꞉nala꞉ka꞉? Gugudi netewa ipuwalo ebeno nabiwi pote ka꞉kalakaluimi?” Iba꞉te na꞉ga꞉luya꞉, “Dopo gudutila.” Ba꞉bema꞉ Ya꞉suti iba꞉tamo na꞉goiya꞉, “Na la꞉tamo hibi tabo begoemo, ta꞉kese mani ha꞉da amiholo uwatepi dubu ba꞉gala dubu bilibili kamenakamena, iba꞉te la꞉eno haba uwatelamete Godokono Ko Gawadubu habamo kona꞉pa꞉la꞉hama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mabu Yoneko tawakalubi beyamo wadulateledawate Godokono tuputupu gabodo da꞉pi, la꞉le ebeno tabo hibima꞉ kamidiha꞉, huiyatiya mani pilolo uwatepi dubu ba꞉gala dubu bilibili kamenakamena iba꞉te ebe hibima꞉ miditi ibino tepo ipuwa Godotamo ohoba꞉midaliya꞉. Ba꞉ hibila, ba꞉ba tetelo la꞉le ibino komo dulamelelamima, huiyatiya la꞉eno kubakuba ukui hiya꞉ma꞉ midilihino Yonekono tabo kalaweha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Wadiyala la꞉le naeno eta iya꞉tulame uwi nulia꞉la꞉. Eta ko dubuti pali ododiti tupina gao keha ba꞉bo amihui, ba꞉be gaoeno mahilo ba꞉ gala꞉ipi gaola. Amiho komote da꞉wibui, ebete kala imiti gao ihi adilutihoeno nakola bobo aligiti, pali lawamepino hunu mimiya ba꞉bo eti. Ba꞉ba tetelo ba꞉be dubuti ebeno pali komo lawamepi dubatamo dito miya꞉pui, iba꞉te ba꞉bolo oko ba owatina ba꞉be pali hidamo umilo ebeno gao kuwateholemenakoma꞉, ba꞉bene ebete muhulu hopamo ba꞉ dito tui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Ba꞉bene gao tapiho tete da꞉pi ebete pali lawamepa꞉tamo komo huiyaha꞉ okopi na꞉poelami, iba꞉te iba꞉godone ebeno gao kopuwatema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Huiyatiya pali lawamepa꞉te ibi uwatete eta kukamo anagalimihuya꞉, ba꞉gala eta dito anakapumiya꞉, ba꞉gala eta nakolamo mapemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dopamo pali namutudawate kapiyakapiya huiyaha꞉ okopi bepoelami, ba꞉bene ebete gala komo hiliyonomo da꞉kapoelami pali lawamepa꞉te iba꞉tamo ba꞉ atu kuba komokomo beka-ododiliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Galanomone ebete ebeno gudu ba poeme ebeno ukuilo na꞉goi, ‘Hibila, iba꞉te naeno gudutamo kopapamila꞉halema꞉na꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Huiyatiya ba꞉bi pali lawamepi dubate ba꞉be gudu pitalo dumi iba꞉te ibi ipuwalo na꞉ga꞉luya꞉, ‘Numa꞉la꞉, ba꞉moe guduti nabiwino ilina namutudawama꞉ deda꞉mene, ba꞉be guduti ba꞉ na꞉pe. Ba꞉bema꞉ wadiyala ale ebe anakapumiti ebeno pali kolawema꞉nema꞉,’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ba꞉bene iba꞉te ebe lawete palino kala ipuwane na꞉da꞉nate ba꞉ dito nanakapumiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ba꞉bema꞉ Ya꞉suti ulihopa꞉tamo na꞉goiya꞉, “La꞉eno ukui keba ka꞉nala꞉ka꞉? Pali namutudawate muhulu hopone da꞉pemene, ebete bada komo na꞉ka꞉pododimini pali lawamepa꞉tamo?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yu watowatopa꞉te ebeno tabo ba huiya na꞉ga꞉luya꞉, “Hibila, ebete ba꞉bi kuba okopi kubanomamo palukuliti kopanakapulamema꞉ne. Ba꞉ba tetelo ebete ebeno pali komo lawamepi dubatamo kopikalamema꞉ne, gao noloho tetelo iba꞉te ebeno pali ilina ebetamo hidamo kikamehonakoma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ dopamo Godokono Bukalo ba꞉moe tabo hibilo a꞉ka꞉lamiholia꞉mata, ‘Genama etepa꞉te tama꞉mo dihati, ba꞉be hototote huiyatiya genamoeno helo mabuma꞉ eda꞉na. Ba꞉moe komo ba꞉ Godote ododi, ba꞉bema꞉ aeno ukuilo na꞉hanohanohutama꞉!’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ba꞉bema꞉ nale la꞉tamo na꞉goemo, Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komo ebete la꞉godone puwatete puya꞉godolo hidohido noloho gao da꞉pola꞉na ba꞉bako tawakaluba꞉tamo dito kikalamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Numa꞉la꞉, nale hototoeno komoma꞉ da꞉goemo, ebeno kodakoda ba꞉ nakola huiyala. Iyo, ba꞉moe nakola hunamo da꞉gamene ba꞉be lumagiti kota꞉ta꞉pula꞉tihoma꞉ne, ba꞉gala ba꞉moe nakolate lumagi dihita꞉timini kotakotakuimima꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ba꞉bene Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala komo Pa꞉lisi kapiyuimipi iba꞉te Ya꞉sukunu uwi dulihuya꞉, iba꞉te ba꞉bo iya꞉tawahuya꞉ Ya꞉suti ibino komoma꞉ olamagiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ba꞉bema꞉ iba꞉te ebe lawema꞉ ubi bihatitiya꞉, huiyatiya iba꞉te tawakalubi betolelamitiya꞉ mabu ibi hiliyonomate Ya꞉suku Godokono ukui hawakalimidawama꞉ ga꞉lanakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ba꞉bene Ya꞉suti eta iya꞉tulame uwi tawakaluba꞉tamo olamagilo na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komo ba꞉ma ka꞉na itana. Eta Ko Gawadubuti ebeno kuhino kamena laweno poko ododiti ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ebeno okopi ba꞉bo oelami, ebete dopamo da꞉ka꞉lami ba꞉bi tawakalubi nuwatete poko habamo komagahelema꞉. Huiyatiya iba꞉te pelamema꞉ ubiha꞉ma꞉ eda꞉huya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ba꞉bene ebete gala komo okopi ba kanoelame na꞉kagoi, ‘Na dopamo da꞉ka꞉lamimo, la꞉le ba꞉bi tawakalubi ba꞉ma ka꞉na gala na꞉kanikiyalama꞉la꞉, ‘Na poko ilina a꞉hiduilama꞉kamo, kau-goegoe gadigadinomo alukula꞉kamo, poko ilina hiliyonomo hiduilame a꞉wibo. Wadiyala la꞉ pelamete na꞉penahala꞉.’ ’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Huiyatiya iba꞉te ba꞉be tabo ubiha꞉ma꞉ eda꞉hate ibino hiya꞉hiya꞉ okamo dito tolamiya꞉, ba꞉ma ka꞉na etate ebeno pali okamo tui ba꞉gala etate kolowami habamo tui, ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ba꞉bene komopa꞉te Ko Gawadubuino okopi uwatete ba iduduputilame ibi ba꞉bo anakapulamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ba꞉ba tetelo Ko Gawadubuti konomamo maubalo ebeno alaholohopi ba꞉bo noelami, ba꞉bene puya꞉te ebeno okopi danakapulami, alaholohopa꞉te ibi kubamo alukuliti ibino haba koa꞉mo dito emadomelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ba꞉ba tetelo ebete ebeno okopa꞉tamo na꞉goi, ‘Naeno kuhino kamena lawe pokoeno ilina hiliyonomo a꞉hiduilama꞉kamo, huiyatiya nale dopamo da꞉ka꞉lamimo ba꞉bi tawakalubi hidohidoenoha꞉, iba꞉te pelamema꞉ na ubihinola. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ba꞉bema꞉ wadiyala la꞉ koko gabo gagagaga teta꞉mo tolamete la꞉le da꞉nulamema, ba꞉bi tawakalubi hiliyonomo na꞉nikiyalama꞉la꞉ iba꞉te naeno poko baa꞉ kopenahama꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ba꞉ba tetelo okopa꞉te tolamete gabo gagagaga tetelo tawakalubi hiliyonomo ba꞉bo nuwatiya꞉, ba꞉ma ka꞉na awaepi ba꞉gala dogodogopi, ba꞉bi tawakalubi hiliyonomate kapimilo poko habamo pelameholete, iba꞉te baa꞉ kebe genamalo ka꞉nahuti ba꞉be ko genama gu ba꞉ dito tabui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ba꞉ba tetelo Ko Gawadubuti tawakalubino kokoto uwateholamema꞉ poko genamamo da꞉pi, ebete kapiya dubu bepumi ebete hidonomo poko kaliko pulihino podolui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ko Gawadubuti ebetamo na꞉goi, ‘Mabulubi, mabu keka꞉ ama꞉ hido kaliko pulihino da꞉podola?’ “Ba꞉ba tetelo ebete ebeno tabo uliti kahuiyaha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ba꞉bema꞉ Ko Gawadubuti ebeno hopopa꞉tamo na꞉goi, ‘Wadiyala la꞉ ebeno kokoto nato hala꞉mo matuhulamelemete du ipuwamo a꞉da꞉nate ba꞉bo na꞉nimiya꞉puya꞉la꞉. Ebete ba꞉bolo lalo ba ikilame konomamo kihima꞉ne.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ba꞉bema꞉ Ya꞉suti kuititi tabo ba꞉ma ka꞉na goiya꞉, “Hibila, Godote hiliyonomo tawakalubi beka꞉lamina, huiyatiya ibi ipuwalo kapiyakapiyanomo buwatenako.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ba꞉ba tetelo Pa꞉lisi kapiyuimipa꞉te tolamete Ya꞉sukunu komoma꞉ ibi ipuwalo tabo da꞉nega꞉luya꞉ ibino ubi ba꞉bo nihatiya꞉, iba꞉te ebe kuba gabamo ba nemogabuimi ebete kebako tabo goelo ebe ba꞉bo kolawema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ba꞉bene iba꞉te komo ibino ta꞉matalepi ba꞉gala Ko Gawadubu Helodikono kapiyuimipi atu tetelo Ya꞉sutamo oelamiya꞉. Ba꞉ba꞉te ebetamo pelamete ha꞉da amiho gabodo na꞉pega꞉luya꞉, “Iya꞉tulamedawa, a iya꞉tawahala ama꞉ hibi lumagilata, iyo, ama꞉ tawakalubi Godokono gabo hidamo iya꞉tulamenata. Hibila, ama꞉ komopino dito ga꞉la komamo a꞉kapapamiwatala꞉ta, ba꞉gala ama꞉ tawakalubi hunu nikapa꞉mo kulamenaha꞉, ba꞉ma ka꞉na eta lumagi miya꞉palo eta lumagi ebo a꞉kalawa꞉la꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ba꞉bema꞉ amia꞉no ukui hawakalimiti a na꞉kiyaa꞉ma꞉, Loma tawakalubino Konomo Gawadubu Sisatamo ta꞉kese mani ikameho hidola꞉ka꞉ o kubala꞉ka꞉? A ebetamo ba꞉kikamehoma꞉ o a꞉kikamehama꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ya꞉suti ibino ha꞉da amiho komo iya꞉tawate na꞉goiya꞉, “La꞉ ma꞉lapila netewa tawakalubilata! Mabu keka꞉ la꞉le na ha꞉da amihonamema꞉ dewagelitama? ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","La꞉ mani kapiya natamo nikanama꞉la꞉.” Ba꞉bene iba꞉te kapiya mani ebetamo dikamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ebete ibi nalateda꞉liya꞉, “Ba꞉moe manilo da꞉pola꞉na, mahilo ba꞉gala holoholo pokonola꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Iba꞉te na꞉ga꞉luya꞉, “Konomo Gawadubu Sisakonola.” Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Sisakono ilina Sisatamo nikamehala꞉, huiyatiya Godokono ilina Godotamo nikamehala꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ba꞉bema꞉ iba꞉te Ya꞉sukunu tabo uliti ba hanohanoho ebe miya꞉pate ba꞉ dito tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hoe ipuwane mahila꞉haleha꞉ma꞉ da꞉ga꞉lana, ba꞉bi tawakalubi ba꞉ Sa꞉diyusi kapiyuimipila. Ba꞉be atu hegelalo komo iba꞉te Ya꞉sutamo pelamete ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","tabo ba꞉ma ka꞉na pega꞉luya꞉, “Iya꞉tulamedawa, Mosesete Godokono tabo ba꞉ma ka꞉na goiya꞉, ‘Dubuti hoete kamena gugudihino da꞉miya꞉pamene, ebeno ekawiti ba꞉be hamole lawete ebeno naniwi mabuma꞉ gugudi nododilima꞉mene.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aeno tawakalubi ipuwalo kapiya dubuino sa꞉ba꞉ni kuhia꞉te nemedenama꞉. Dopo guduti kamena lawete gugudi ulameheno hoiya꞉, ba꞉bene ebeno ekawiti ebeno hamole dito kalawiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ba꞉ba tetelo ebe ba꞉ atumu gugudi ulameheno dito kahoiya꞉, ba꞉gala eta tetedawate ba꞉ba ka꞉na ka-ewageliya꞉. Ba꞉bene ba꞉bi sa꞉ba꞉ni badininipala hiliyonomate ba꞉ba ka꞉na ha꞉lahuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","huiyatiya kamenate galane dito hoiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ba꞉bema꞉ iba꞉te hoe ipuwane ka꞉ka꞉mo da꞉mahila꞉halemena꞉, ba꞉be Ko Hegelalo ba꞉be kamenate sa꞉ba꞉ni dubu ipuwalo pokono kamenama꞉ na꞉keda꞉mene, mabu ebe ibi hiliyonomate a꞉lawa꞉tepahuya꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ba꞉bene Ya꞉suti iba꞉tamo na꞉huiyuya꞉, “La꞉ Sa꞉diyusi kapiyuimipa꞉te la꞉eno ukuilo tawakalubino ha꞉la komoma꞉ kubamo ga꞉lanakomata, mabu la꞉ Godokono Buka tabo ba꞉gala ebeno helo iya꞉tawaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ba꞉moe komo ba꞉ hibila, tawakaluba꞉te hoe ipuwane mahila꞉hale tetelo iba꞉te gala kamenakamena a꞉kapuwatehola꞉mena꞉ ba꞉gala dubu a꞉kapuwatehola꞉mena꞉, iyo, iba꞉te Godokono Hunu Haboeno nopopimo bemedehonamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ba꞉be mabuma꞉ Godokono Bukate a biya꞉tua꞉mena ha꞉lahapa꞉te hoe ipuwane mahila꞉halema꞉, iyo, ebete ebeno Bukalo la꞉tamo ya꞉lo da꞉goiya꞉ ba꞉be tabo la꞉ hibilo a꞉ka꞉lamiholia꞉mata. Ba꞉be tabote ba꞉ma ka꞉na itana, ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Na ba꞉ Godotela. A꞉ibalahamako, Aisa꞉keko, ba꞉gala Ya꞉ikoboko, iba꞉te emedena tetelo poko kadikumina na ba꞉ ba꞉betela.’ Ba꞉bema꞉ la꞉ Sa꞉diyusi kapiyuimipi, la꞉eno ukuilo na꞉kemalagidolonama ba꞉bi iniwalino ka꞉ka꞉te a꞉wibuya꞉? Ao, kawibuya꞉ha꞉, mabu ha꞉lahapa꞉te Godoko a꞉kadikuma꞉la꞉, huiyatiya puya꞉te da꞉ka꞉ka꞉halena ba꞉bi tawakalubinomate ebe badikumina.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ba꞉ba tetelo hiliyonomo tawakaluba꞉te Ya꞉sukunu tabo uliti ebeno tabamo hanohanoholo na꞉kalakalahutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ya꞉sukunu tabote Sa꞉diyusi kapiyuimipino tabo dalukulilamiya꞉, ba꞉be komo Pa꞉lisi kapiyuimipa꞉te uliti iba꞉te kapimilo ebetamo pelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ba꞉bene ibi ipuwalo eta dubu ebe Godokono Tutumu Tabo iya꞉tawanomola, ebete Ya꞉suku kuba gabamo emogabuimima꞉ ebe palateda꞉lo na꞉pegoiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Iya꞉tulamedawa, Godokono Tutumu Tabo hiliyonomo ipuwalo kebe tutumuti konomoma꞉ keda꞉na?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Ya꞉suti ebeno tabo ba huiya na꞉goiya꞉, “Godokono Tutumu Tabo hiliyonomo ipuwalo ba꞉moe tabote ba꞉ konomoma꞉ eda꞉na, ‘Ama꞉ amia꞉no Kodawa Godoko malemalelo nemalagidolona, amia꞉no tepo ipuwanomamo, ba꞉gala amia꞉no gobogoboeno heloamo, ba꞉gala amia꞉no ukui konomamo.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ba꞉gala ba꞉moe eta konomo tutumu atumu ba꞉ka-itana, ‘Ama꞉ ha꞉kiya ama꞉ demalagidolona, wadiyala ama꞉le ba꞉ ba꞉ba ka꞉na ama꞉ tamelo demedena ba꞉be lumagi malemalelo nemalagidolona.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hibila, Godote tawakaluba꞉tamo Moseseko ipuwado dikalamiya꞉ ba꞉gala ebeno ukui hawakalimipa꞉te ebeno Bukamo da꞉miya꞉tiya꞉, ba꞉bi hiliyonomo Tutumu Taboeno ipuwa ba꞉ kapiyala, ba꞉moi koko tutumu netewa ipuwalo ba꞉pola꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ba꞉bene Pa꞉lisi dubate ibino kapiyuimi ipuwalo ba pola꞉na Ya꞉suti ibi nalateda꞉liya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“La꞉ Kelisokono komoma꞉ keba ka꞉na kemalagidolonama? Ebe pokono hogola꞉ka꞉?” Iba꞉te ebetamo na꞉huiyuya꞉, “Da꞉ibidikono hogola, ebeno eyoni gugudi ipuwane komahigama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉eno tabo ba꞉ hibila, ba꞉bema꞉ mabu keka꞉ Da꞉ibiditi Kelisoko ebeno Kodawama꞉ da꞉ka꞉miya꞉? Iyo, ebete Godokono Gobogoboeno heloamo tabo ba꞉ma ka꞉na olamagiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Kodawa Godote naeno Kodawa Kelisotamo na꞉goe, ‘Ama꞉ naeno tu hapuamo na꞉pemeda꞉, ba꞉bene ama꞉go alaholohopi ama꞉le naeno heloamo ibi komikimoelema꞉na꞉ta.’ ’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ba꞉bene Ya꞉suti tabo moga꞉melo gala na꞉kagoiya꞉, “La꞉ ba꞉moe tabo ba emalagidolo na na꞉kiyanama꞉la꞉, Da꞉ibiditi ebeno hogo Kelisoko ebeno Kodawama꞉ ka꞉milo ebete Godokono tu hapuamo emedema꞉ goiya꞉, ba꞉bema꞉ ba꞉be komote keba ka꞉na na꞉kuluhukumini?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ba꞉ba tetelo ibi ipuwalo eta lumagiti Ya꞉sutamo huiya tabo goema꞉ kamodobuya꞉ha꞉, ba꞉bema꞉ ba꞉ba tetene tupuimiti tawakaluba꞉te ebe eta tabo alateda꞉ma꞉ na꞉toletolehutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ba꞉bene Ya꞉suti tawakalubi hiliyonomo ba꞉gala ebeno ta꞉matapa꞉tamo tabo ba olamagi na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi, Godote iba꞉tamo Mosesekono oko haba ikalamiya꞉, ba꞉ma ka꞉na Mosesete Bukamo da꞉miya꞉tiya꞉ iba꞉te ba꞉bi Tutumu Tabo hidamo niya꞉tulamenakamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ba꞉bema꞉ iba꞉te la꞉ Godokono tabamo papamila꞉ma꞉ da꞉kiyalamenakomena꞉, wadiyala la꞉ na꞉papamila꞉nakuya꞉la꞉, huiyatiya la꞉le ibino emede komokomo dulamema la꞉ ibi akibamilatela꞉la꞉, mabu iba꞉te komopi koamo kiyahalamenaka hidohido komo kododilima꞉, huiyatiya hibi komo puliyala, iba꞉te ba꞉bi atu hidohido komo a꞉kododila꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Numa꞉la꞉, iba꞉te ibino tutumu tabamo tawakaluba꞉tamo menemene komokomo bikalamenaka, iyo, ibino tutumu tabo ba꞉ tawakaluba꞉te menemene ilina okamo da꞉wagalatelena ba꞉ba ka꞉nala. Ba꞉bema꞉ iba꞉te tawakalubino menemene dulamemena꞉ eta owalubi deha꞉potonomo a꞉kihata꞉la꞉, kokoto makupuhuliti dito la꞉mota꞉hananaka. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ba꞉gala ibi ubi konomola tawakaluba꞉te ibino hunu tama ba ulamelelame ibi hidohidopima꞉ koga꞉lama꞉. Ba꞉bema꞉ Godokono Buka tabo komokomo iba꞉te hegehege pepamo miya꞉teholete ibino wato kala꞉mo ba꞉bo matuhulameholenaka, ba꞉gala ibino watuino kaliko komokomo iba꞉te boelamo a꞉dehote ba꞉bo ododilinaka. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ibi ubi konomola poko ododi tetelo koko habalo ahiditi kopola꞉nama꞉, ba꞉gala ibi ubila a Yunapino baidi ibubulamehole genama gulu koko dubuino habalo kogagahidima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Iyo, ibi ubila kolowami habalo tawakaluba꞉te ibi ulamete ba꞉bo kawagaminalema꞉, ba꞉gala ibi ubila tawakaluba꞉te ibi iya꞉tulamepima꞉ koka꞉lamima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo gala na꞉kagoiya꞉, “Wadiyaha꞉ komo tawakaluba꞉te la꞉tamo iya꞉tulamepima꞉ ga꞉la, mabu hibila, la꞉ hiliyonomo ba꞉ kapiya badininipalalata ba꞉gala na ba꞉ la꞉eno kapiya Iya꞉tulamedawanomola. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ba꞉gala ba꞉moe hopolo la꞉ eta lumagi la꞉eno nabiwima꞉ akamida꞉la꞉, mabu la꞉eno kapiya Nabiwinomo Hunu Habalo bemedena. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ba꞉gala modoboha꞉ komo tawakaluba꞉te la꞉tamo watowatopima꞉ ga꞉la, mabu na Kelisote ba꞉ la꞉eno kapiya Watodawanomola. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ba꞉bema꞉ kebe lumagiti koma꞉ eda꞉ma꞉ ubi dihatemene, wadiyala ebete la꞉eno huiyaha꞉ okodawama꞉ neda꞉mene, ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","mabu kebe lumagiti ebe ha꞉kiya ebe koma꞉ da꞉midimini Godote ebe deha꞉potoma꞉ komidima꞉ne, ba꞉gala kebe lumagiti ebe ha꞉kiya deha꞉potoma꞉ da꞉midimini Godote huiyatiya ebe koma꞉ komidima꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi, la꞉ galane kuba huiya konomo kolawema꞉nemata, mabu la꞉ ma꞉lapila netewa tawakalubilata! Tawakaluba꞉te Godokono Ko Gawadubu habamo a꞉pa꞉la꞉hama꞉ da꞉pelamenaka, la꞉le huiyatiya ibino gabo bekalapilalamenamata. La꞉ ha꞉kiya a꞉pa꞉la꞉hama꞉ ubihinola, ba꞉bema꞉ la꞉ ibi atumu na꞉kaduhilamenamata! ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ba꞉ hibila, Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi, la꞉ ma꞉lapila netewa tawakalubilata! “La꞉le hamolehamoleno ilina ha꞉da amiho komodo ba uwate ba꞉bo wibuilamelelamenakomata, ba꞉bene la꞉le ba꞉be komo kubaha꞉ma꞉ ga꞉lalo tolamete Godotamo baidi ba nibubulamehole ga꞉ga꞉ga꞉ toetoe tabo ba꞉bo nega꞉lanakomata, mabu la꞉ ubila tawakaluba꞉te la꞉eno komo umilo la꞉ hidohidopima꞉ koga꞉lama꞉. Ba꞉bema꞉ hibila, la꞉le kuba huiya konomo kolawema꞉nemata! ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ba꞉ hibila, la꞉ Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi, la꞉ kuba huiya konomo kolawema꞉nemata, mabu la꞉ ma꞉lapila netewa tawakalubilata! “La꞉ kehaha꞉ kolomolo ba꞉gala hopo konomolo awagahago wapata꞉lamenamata eta kapiya lumagi lawete la꞉eno kapiyuimidawama꞉ komidima꞉, ba꞉bene ba꞉be uli lumagiti la꞉ ba ibamilatele atu kuba komokomo ododiliti huiyatiya ebeno kubate la꞉ hiliyonomoeno kuba kogogolema꞉ne. Ba꞉bema꞉ hibila, la꞉ hiliyonomate kapimilo Koe Habamo konepalagama꞉nemata! ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“A꞉iye, la꞉ puya꞉te kuba gabo diya꞉tulamenama, la꞉ ba꞉ ba꞉bi baidi tamihopi dubulata! “La꞉ kuba huiya konomo kolawema꞉nemata, mabu la꞉ ba꞉ma ka꞉na ga꞉lanakomata, ‘Pote Godoko Adikumino Genamoeno mahilamo olamagiti, ebete ba꞉be tabo gala da꞉kadikamidalemene, ba꞉be komo kubaha꞉. Huiyatiya ebete atu tabo Godokono Genamoeno golodo ilinoeno mahilamo dolamagimini, ebete ebeno tabo kodakodama꞉ miditi gala a꞉kadikamidala꞉mene.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hibila, la꞉ ba꞉ baidi tamiholamepi dubula ba꞉gala la꞉ daedae ukuipilata! Godoko Adikumino Genamoeno talona konomola, huiyatiya genama gulu ditana ba꞉be golodo ilinoeno talona koha꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ba꞉gala la꞉ eta komo ba꞉ma ka꞉na ga꞉lanakomata, ‘Pote Godoko owatidoloeno patapatoeno mahilamo olamagiti, ebete ba꞉be tabo gala da꞉kadikamidalemene, ba꞉be komo kubaha꞉. Huiyatiya ebete ba꞉be patapata hunulu ditana ba꞉be hawa꞉goeno ilinoeno mahilamo atu tabo dolamagimini, ebete ebeno tabo kodakodama꞉ miditi gala a꞉kadikamidala꞉mene.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“Hibila, la꞉ ba꞉ baidi tamiholamepi dubulata! Godoko owatidoloeno patapatoeno talona konomola, huiyatiya ebe hunulu ditana ba꞉be hawa꞉goeno ilinoeno talona koha꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","La꞉ nulia꞉la꞉, ba꞉be patapatate Godoko owatidoloenoma꞉ itana, ba꞉gala tawakaluba꞉te patapata hunamo da꞉miya꞉tenaka ba꞉bi hawa꞉goeno ilinate atumu Godoko owatidoloenoma꞉ kapola꞉na. Ba꞉bema꞉ lumagiti talona patapatoeno mahilamo dolamagimini ebete ebeno tabo gala a꞉kadikamidala꞉mene, ba꞉gala etate talona hawa꞉goeno ilinoeno mahilamo dolamagimini ebete atumu ebeno tabo gala a꞉kadikamidala꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ba꞉ hibila, aeno Ko Talona Godote ebeno Adikumino Genamalo bemedena, ba꞉bema꞉ lumagiti Godokono talona mahilamo dolamagimini ebete ebeno tabo gala a꞉kadikamidala꞉mene, ba꞉gala etate Godokono Genamoeno mahilamo dolamagimini ebete atumu ebeno tabo gala a꞉kadikamidala꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ba꞉gala eta komo, Godokono Hunu Habalo ebete ebeno Ko Gawadubuino luta bahilo bemedena. Ba꞉bema꞉ lumagiti Hunu Haboeno mahilamo dolamagimini ebete ebeno tabo gala a꞉kadikamidala꞉mene, ba꞉gala etate Ko Gawadubu Godokono mahilamo dolamagimini ebete atumu ebeno tabo gala a꞉kadikamidala꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ba꞉ hibila, Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi, la꞉ kuba huiya konomo kolawema꞉nemata, mabu la꞉ ma꞉lapila netewa tawakalubilata! “La꞉ la꞉eno pali ilina hiliyonomo ipuwalo ta꞉ni komokomo ba anagilamehole Godotamo ebeno komo hidamo ikamehonakomata. Ba꞉be komo ipuwalo la꞉ kapiya deha꞉potonomo komo a꞉kotalemata, huiyatiya Godokono kokonomo tutumu ododilima꞉ la꞉ hidamo kemalagidolenaha꞉. Ba꞉ma ka꞉na la꞉ tawakaluba꞉godolo tuputupulu kemedenaha꞉, ba꞉gala la꞉le ibi malemalelo kemalagidolenaha꞉, ba꞉gala la꞉eno ododili komodo Godokono hibi komo kahawakaliminaha꞉. Ba꞉bema꞉ wadiyala la꞉ ba꞉bi koko komo nododilinala꞉ ba꞉gala atu tetelo hegehege komo ododili akadodohola꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","A꞉iye, la꞉ puya꞉te gabo kubamo diya꞉tulamenama, la꞉ ba꞉ ba꞉bi baidi tamihopi dubulata! Ba꞉bema꞉ la꞉eno ododi komo ba꞉ ba꞉ma ka꞉nala, la꞉ beya niho tetelo la꞉ dopamo beya ba hola꞉minahale hegehege ilina humagago tama꞉mo miya꞉tenakomata, huiyatiya la꞉eno kalili ipuwalo da꞉pola꞉na ba꞉bi koko ababale ilina ulameheno beyago dito nihonakomata! ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ba꞉ hibila, Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi, la꞉ kuba huiya konomo kolawema꞉nemata, mabu la꞉ ma꞉lapila netewa tawakalubilata! La꞉le la꞉eno kalili ba꞉gala meleke hunu hapu bukulalenakomata, huiyatiya la꞉eno tepo ipuwalo da꞉pola꞉na ba꞉bi komokomo a꞉kukulala꞉lemata, ba꞉bema꞉ la꞉le pilo gabodo ba꞉gala kateneno ubi gabodo dododilinakoma, ba꞉bi koko kuba tabotabohonomola. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ba꞉bema꞉ Pa꞉lisi baidi tamihodawa, wadiyala ama꞉ kalili ipuwa dopamo ukulate ba꞉bene tame atumu na꞉kukuluya꞉! Ba꞉be gabo kapiyado amia꞉no dalowa꞉te kowiboma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ba꞉ hibila, Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi, la꞉ kuba huiya konomo kolawema꞉nemata, mabu la꞉ ma꞉lapila netewa tawakalubilata! “Iyo, ha꞉lahapino bobo bahino piki tawakaluba꞉te hidohido tita꞉goenoma꞉ da꞉midilinaka, la꞉ ba꞉ ba꞉ba ka꞉nala mabu hunuti hidamo pola꞉na huiyatiya piki mabulu tawakalubino goha ababale tabotabohote pola꞉na! ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hibila, ba꞉ ba꞉ba ka꞉na tawakaluba꞉te la꞉eno hunu tama ba ulamelelamena la꞉ tuputupupima꞉ ka꞉laminata, huiyatiya la꞉eno tepo ipuwalo ma꞉lapila netewa komo ba꞉gala kuba ododili komate la꞉godolo tabotabohote pola꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ya꞉suti tabo moga꞉melo gala na꞉kagoiya꞉, “Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi, la꞉ kuba huiya konomo kolawema꞉nemata, mabu la꞉ ma꞉lapila netewa tawakalubilata! “Numa꞉la꞉, la꞉eno iniwala꞉te Godokono ukui hawakalimipi danakapulamenakui, la꞉ ba꞉ma tetelo ba꞉bi Godokono tuputupu okopi hunamo ba wadiya꞉paa꞉latele ibino bobo bahi hidonomamo ododiliti haiyai ba꞉bo amihonakomata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ba꞉gala atu tetelo la꞉ na꞉kaga꞉lanakomata, ‘Aeno iniwala꞉te demedenama꞉, a ba꞉ba tetelo iba꞉go nemedenatale, ale Godokono ukui hawakalimipa꞉tamo owalubi ba ihate aeno hidohido ododili komodo ibino ka꞉ka꞉ ba꞉mula꞉lelamiya꞉na꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ao, la꞉le ba꞉ atumu ibi banakapulamiuya꞉na꞉! Numa꞉la꞉, la꞉ ha꞉kiya la꞉eno tabamo la꞉eno kuba ukui behawakalilamenakomata, iyo, la꞉ ba꞉ iniwalino gugudilata! ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ba꞉bema꞉ la꞉eno iniwala꞉te da꞉tupuimiya꞉, modobola la꞉ ibino kuba konomo upula꞉te la꞉eno kuba huiya Godogodone na꞉lawiya꞉la꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“A꞉iye, la꞉ kaluino gugudilata, iyo, la꞉ ba꞉ bu kalulata, ba꞉bema꞉ la꞉ Koe Haboeno huiya komone keba ka꞉na na꞉kalahutihoma? ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Nale la꞉ hibinomolo goelamemata, nale Godokono ukui hawakalimipi ba꞉gala ebeno mulupi dubu ba꞉gala ebeno hibi Tutumu iya꞉tulamepi la꞉tamo kopoelamema꞉nemo. Huiyatiya la꞉le komopi kehamo ba pihomolatele kanakapulamema꞉nemata, ba꞉gala la꞉le komo la꞉eno baidi ibubulamehole genamalo giya꞉pa꞉pa꞉mo ka꞉na꞉miga꞉latilima꞉nemata, ba꞉bene naeno okopa꞉te la꞉eno temeteme ikalame ipuwane eta habamo da꞉nawalelahalemena꞉, la꞉le ba꞉bamo nikuliti ibi gala eta habamo kakaneta꞉malatelema꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ba꞉bema꞉ la꞉le kuba huiya kolawema꞉nemata, mabu ba꞉moe hopoeno tupuimi mabuni la꞉le Godokono ukui hawakalimipi anakapulamenakuimata. Tuputupudawa A꞉ibolokono hawiti hakamo da꞉ka꞉ka꞉liya꞉, ba꞉be komo ba꞉ tupuimi mabula. Ba꞉bene la꞉le komo tuputupu okopi hiliyonomo anakapulamete, kuititi tetelo Godoko Adikumino Genamalo la꞉le Balakayakono gudu Sekalayako ba꞉bo kanakapumiya꞉mata, iyo, ebete ba꞉be Genamoeno Talona Haba ba꞉gala Godotamo hawa꞉goeno ikameho bahi tetenomolo ba la꞉na, la꞉le ebe kubanomamo anagalimiya꞉mata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“Ba꞉bema꞉ na la꞉tamo hibi tabonomo begoemo, ba꞉ma tete tawakaluba꞉tamo ba꞉bi hiliyonomoeno kuba huiyate hibilo kopema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “O Yelusalema, Yelusalema! Ama꞉le Godokono ukui hawakalimipi anakapulamenakata, ba꞉gala ebete ama꞉ kowalubima꞉ da꞉poelamenako, ama꞉le ibi nakolamo mapelamelo akanakapulamenakata. Tete ga꞉ga꞉nomolo na ubi nihatenamimo amia꞉no tawakalubi naeno ekatamo kitagua꞉midalema꞉, kakabate ebeno gugudi ditagua꞉midalenako ba꞉ba ka꞉na, huiyatiya ama꞉ ubiha꞉ma꞉ eda꞉nama꞉ta! ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ba꞉bema꞉ mu numitota꞉, amia꞉no habate kubanomo kokubama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nale ama꞉tamo na꞉goemo, amia꞉no tawakaluba꞉te na tete ga꞉ga꞉nomolo a꞉kunama꞉mena꞉, huiyatiya amia꞉no galanepa꞉te Godotamo ba꞉ma ka꞉na da꞉ga꞉lamena꞉, ‘Amia꞉no mahilago da꞉pita, ale ebe hunamo kadipatema꞉nema꞉!’ ba꞉ba tetelo nale gala da꞉kapemo iba꞉te na ba꞉bo kunamema꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ba꞉bene Ya꞉suti Godoko Adikumino Hiya꞉ Genama miya꞉pate ba to, ebe ta꞉matapa꞉te ebetamo pelamete ba꞉bi koko genamoeno komokomoma꞉ ba꞉bo pega꞉lamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “La꞉ ba꞉moi ilina hiliyonomo bekulamiutama? Na la꞉tamo hibi tabo begoemo, galane ba꞉moi genamoeno komoma꞉ eta nakolate eta hunulu a꞉kapola꞉namena꞉, mabu alaholohopa꞉te nakola hiliyonomo mapitahalete hopamo iya꞉hekenomo kopiya꞉hekema꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ba꞉bene Ya꞉suti Olibi Kehakeha Hunu Hakalo ba luta, ebe ta꞉matapi ha꞉kiya ebetamo pelamete na꞉pega꞉luya꞉, “Ama꞉ a na꞉kiyaa꞉ma꞉, Godokono Genama kubahimi komote keba tetelo na꞉kuluhukumini? Ama꞉le ba꞉moe hopamo gala da꞉kapemena꞉, ba꞉be komo ba꞉gala hopo haboeno kuititi komoeno tetema꞉ a bada hanohano komote na꞉kiya꞉tua꞉memene?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “La꞉ hidamo. Eta lumagiti la꞉ ha꞉da damiholamemena꞉, la꞉ ebeno tabo akulia꞉la꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","mabu komo hiliyonomo dubate naeno mahilamo pelamete kopega꞉lama꞉na꞉, ‘Na ba꞉ Kelisotela!’ ba꞉bene iba꞉te hiliyonomo tawakalubi ha꞉da ba꞉ma ka꞉na ba pamiholame hiya꞉ gabamo ba꞉bo komagatalema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ba꞉gala la꞉le hiya꞉hiya꞉ hopo tawakalubino alaholoho komo ba꞉gala ibino alaholohoma꞉ nopo tamote komo kulihoma꞉nemata. Ba꞉ba tetelo la꞉le la꞉eno ukui kodakoduilamete akatoletolehala꞉, mabu ba꞉moi komate hibilo kopikulima꞉na꞉ huiyatiya ba꞉be tete ebe kuititi teteha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ba꞉ hibila, komo hopo tawakaluba꞉te komo hopo tawakaluba꞉go kalaholohoma꞉na꞉, iyo, eta hopote etatamo alaholo komo kododima꞉ne, ba꞉bene komo habahabalo tawakaluba꞉te baa꞉heno kemedehoma꞉na꞉ ba꞉gala wima꞉la꞉te hiya꞉hiya꞉ hopo hiliyonomatamo kopelamema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Numa꞉la꞉, ba꞉moi hiliyonomo komo ba꞉ kamenate gudu lawema꞉ temeteme da꞉tupuimi ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ba꞉ba tetelo iba꞉te la꞉tamo koko temeteme ba ikalame la꞉ heloamo uwatete anakapulamema꞉ komagatalema꞉na꞉ta, ba꞉gala na mabuma꞉ hiliyonomo hopoeno tawakaluba꞉te la꞉tamo komaubahama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ba꞉bene komo hiliyonomo tawakaluba꞉te ibino hibima꞉ midi ipuwalo nato ba ukamidahale, iba꞉te ibino mabuluba꞉tamo maubahalete diya gabodo ibino mahilo ibi anakapulamepa꞉tamo kowatama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ba꞉gala Godokono mahilamo ha꞉da tabo olamagimipa꞉te kikulima꞉na꞉ komo hiliyonomo tawakalubi kuba gabamo komagatalema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ba꞉ba tetelo kuba ododili komote konomoma꞉ keda꞉ma꞉ne, ba꞉bema꞉ tawakalubino tepo ipuwalo malemale emalagidolo komote gibagiba hibima꞉ keda꞉hama꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","huiyatiya numa꞉la꞉, kebe lumagiti kodakodalo utiti kuitita꞉mo da꞉nuluhukumini, Godote ebeno ka꞉ka꞉ komula꞉mema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ba꞉bema꞉ Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komoeno Hido Tabo ebeno okopa꞉te dopamo ba꞉moe hopo konomolo kolamagimima꞉na꞉ hiya꞉hiya꞉ hopoeno tawakalubi hiliyonomate kulihoma꞉, ba꞉bene ba꞉moe hopoeno kuititi ba꞉bo kuluhukuma꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Na Ma꞉tiyuti buka ka꞉lamiholedawatamo na꞉goemo, ama꞉ ba꞉moe tabo Ya꞉suti da꞉goiya꞉ hidamo niya꞉tawa. Ya꞉suti tabo moga꞉melo gala na꞉kagoiya꞉, “Godokono ukui hawakalimidawa Da꞉niyolote dopamo da꞉goiya꞉ ba꞉be komote hibilo kuluhukuma꞉ne, ba꞉bema꞉ Godokono Genama kubahimidawate ba꞉be talona habalo la꞉nalo la꞉le ebe dumima, ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ba꞉ba tetelo wadiyala Yudiya hoponapa꞉te hunuhunu hakamo nalahutihamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iyo, genama panalo da꞉lutamene, ba꞉be lumagiti genama guamo a꞉kana꞉pa꞉gamene ebeno ilina uwatema꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ba꞉gala tumulu oko dowatitamene, ba꞉be lumagiti gala genamamo a꞉katoamene ebeno atuino kaliko lawema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Numa꞉la꞉, lamitulamitu ba꞉gala nono dikalamena ba꞉bi kamenakamenatamo ba꞉be hegelate kubanomoma꞉ keda꞉ma꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ba꞉bema꞉ wadiyala la꞉ toetoeholo Godoko na꞉toemehuya꞉la꞉, la꞉eno alahutiho komote gibagiba tetelo o okoha꞉ talona hegela tetelo akuluhukala꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","mabu ba꞉ba tetelo kokonomo temetema꞉te hibilo kopikulima꞉na꞉. Numa꞉la꞉, ba꞉moe hopo tupuimi mabuni tupuimiti ka꞉lo ba꞉ma teta꞉mo puluhuku, ba꞉bakobako temetema꞉te dopamo kapikuliya꞉ha꞉, ba꞉gala galane tetelo ba꞉bakobako temetema꞉te gala a꞉kapelama꞉mena꞉, iyo, iba꞉te kapiya tetenomolo kopikulima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ba꞉moe komo ba꞉ hibila, Godote ba꞉be tete gopowahimihino eta lumagiti ba꞉moe hopolo a꞉kemedenamene, huiyatiya ebete da꞉ka꞉lamiholiya꞉ ba꞉bi tawakalubi malemalelatelelo tete kogopowahimima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ba꞉ba tetelo eta lumagiti la꞉tamo ba꞉ma ka꞉na da꞉goemene, ‘Numa꞉la꞉, Godokono Oemedawa Kelisote ba꞉malo bemedena!’ o, ‘Ebete ba꞉bolo bemedena!’ la꞉ hibima꞉ akamida꞉la꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","mabu ha꞉da Kelisoma꞉ eda꞉hapi ba꞉gala naeno mahilamo ha꞉da tabo olamagimipi, iba꞉te ikulihote hiya꞉hiya꞉ hanohano komo kokonomo kododilima꞉na꞉. Iyo, ibi ubila ba꞉bi ododili komamo Godote da꞉ka꞉lamiholiya꞉ ba꞉bi tawakalubi hiya꞉ gabamo komagatalema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Numa꞉la꞉, ba꞉moi komate pikulihino nale la꞉ dopamo kiyalamemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ba꞉bema꞉ iba꞉te la꞉tamo ba꞉ma ka꞉na da꞉ga꞉lamena꞉, ‘Numa꞉la꞉, Kelisote dito hopolo bemedena!’ la꞉ ebamo akatolama꞉la꞉. Ba꞉gala iba꞉te da꞉kaga꞉lamena꞉, ‘Numa꞉la꞉, ebete eta lumagino genamalo awalelate ba꞉luta!’ la꞉ hibima꞉ akamida꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hibila, hegelate da꞉la꞉wa꞉hiyamene ba꞉ba tetelo hegelate alomo hunu konomo ba a꞉la꞉mina alote hapuni tupuimiti hapuamo dito kopetoma꞉ne, ba꞉bema꞉ na Tawakalubino Naniwiti gala da꞉kapemo naeno pe komote ba꞉ ba꞉ba ka꞉na kitanama꞉ne, iyo, hopo habanapi hiliyonomate naeno pe komo kumima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ba꞉moe komo ba꞉ hibila, abale ilinate kebolo ditana, wala꞉te alehola꞉go ba꞉bamo koguditama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ba꞉be ko temeteme tetete da꞉wibomene, ba꞉ba tetenomolo hegelate kuduma꞉ne ba꞉gala manomete a꞉ka꞉la꞉minamene, iyo, oloka꞉te alomone hopamo kopigudima꞉na꞉ ba꞉gala alomoeno helohelo ilinate komidiwiholema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ba꞉ba tetelo Tawakalubino Naniwino helo hawakalimino hanohano komote alomolo kuluhukuma꞉ne, ba꞉bene ba꞉moe hopoeno hiliyonomo hiya꞉hiya꞉ tawakaluba꞉te ko tola꞉go kihimima꞉na꞉, mabu Tawakalubino Naniwiti alomo hununi ba pihitiga iba꞉te ebe ba꞉bo kumima꞉na꞉, ebete ebeno heloago ba꞉gala alo konomago kopema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ba꞉bene ebeno nopodawate gebole ibulu ba mole, ebete Hunu Haboeno komo nopopi hiya꞉hiya꞉ hopo hiliyonomamo kopoelamema꞉ne, Godote da꞉ka꞉lamiholiya꞉ ba꞉bi tawakalubi ba꞉moe hopo hapuhapuni kopuwatema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“La꞉ anahu kehoeno komone ba꞉moe eta komo hidamo niya꞉tawahala꞉. Gedawoeno huha꞉te pikuliti uliuli paha da꞉mogolamemena꞉, ba꞉be komote la꞉ kiya꞉tulamema꞉na꞉ta gogoeno tete ba꞉ na꞉tatali, ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ba꞉bema꞉ la꞉le ba꞉moi temeteme komo hiliyonomo dulamema, la꞉ kiya꞉tawahama꞉nemata Tawakalubino Naniwino pe tete tatalila, ebe ba꞉ gigihodo a꞉pa꞉gama꞉ pe. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na la꞉tamo hibi tabo begoemo, ba꞉moi hiliyonomo komate dopamo kopikulihoma꞉na꞉, galane ba꞉ma tete tawakaluba꞉te ba꞉bo koha꞉lahama꞉na꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","iyo, ba꞉moe hopo ba꞉gala alomo iba꞉te kowiboma꞉na꞉, huiyatiya naeno tabote a꞉kawibamene, itana tetelo bitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Numa꞉la꞉, tawakaluba꞉te ba꞉be Ko Hegeloeno tete iya꞉tawahaha꞉, Hunu Haboeno nopopi ba꞉gala Godokono Gudu iba꞉te iya꞉tawahaha꞉, Nabiwi Godote ha꞉kiya iya꞉tawala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nowako tetelo kebako komote kuluhukuya꞉, Tawakalubino Naniwiti gala da꞉kapemene ba꞉ba tetelo atu komote kakuluhukuma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mabu beyate peheno iba꞉te ba꞉ba tetelo baa꞉ nahata ba꞉gala helo gao beya koamo nihota, dubate kamenakamena uwateholeta ba꞉gala kamenakamenate dubu uwateholeta, iba꞉te ba꞉ba ka꞉na ba ewagelena Nowate ko boga꞉mo ba꞉bo opeguya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba꞉ba tetelo iba꞉te kiya꞉tawahanamiha꞉ beya konomote odolote ibi hiliyonomo danakapulamemene, ba꞉bema꞉ Tawakalubino Naniwiti gala da꞉kapemene ba꞉be tetete ba꞉ ba꞉ba ka꞉na kitanama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ba꞉ba tetelo dubu netewate tumulu da꞉wapatitamena꞉, Tawakalubino Naniwiti pete eta ba pelawe eta ba꞉bo komiya꞉pama꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ba꞉gala kamenakamena netewate baa꞉ da꞉lapahutamena꞉, ebete pete eta ba pelawe eta ba꞉bo komiya꞉pama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ba꞉bema꞉ la꞉ uliholo nemedeniya꞉la꞉, mabu la꞉ iya꞉tawaha꞉ la꞉eno Kodawoeno pe tete. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ba꞉gala ba꞉moe eta komo na꞉kemalagidolala꞉. Genama namutudawate pilo lumagino pe tete diya꞉tawamene ebete ba꞉be du konomolo ba꞉ba teta꞉mo kulihonama꞉ne, mabu ebe ubihinola pilo dawate ebeno genamamo popegama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ba꞉bema꞉ la꞉ atumu na꞉hidala꞉, mabu diyala, la꞉ ulihoheno ba emedena Tawakalubino Naniwiti ba꞉bo da꞉ pemene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Namutudawatamo da꞉papamiwatanako ba꞉be mulu okodawoeno komo keba ka꞉nala꞉ka꞉? Ba꞉ hibila, namutudawate ebe lawete komo okopi ulamedawama꞉ kihatema꞉ne, ba꞉ma ka꞉na ebete ibino baa꞉ naha tetelo iba꞉tamo baa꞉ kikalameholema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ba꞉bene ba꞉be muludawate oko hidamo ba owatina, ebeno namutudawate pete ebeno komo da꞉pumimini, ba꞉be okodawate koamo kokalakalama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na la꞉tamo hibi tabo begoemo, namutudawate ba꞉be mulu okodawoeno komoma꞉ ba pekalakala, ebete ebe ebeno ilina hiliyonomo ulamedawama꞉ kihatema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Huiyatiya ba꞉be okodawate kuba ukui lawete ebeno tepo ipuwalo ba꞉ma ka꞉na da꞉goemene, ‘Naeno namutudawate tete ga꞉ga꞉dopolo nemedena, tiyolo kapenaha꞉,’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ba꞉ba tetelo ebete oko owatihino komo kuba ododilipa꞉go ebeno namutudawoeno baa꞉ koamo nahate helo gao beya ba꞉bo konihoma꞉na꞉, ba꞉bema꞉ ebete daedaema꞉ eda꞉te komo okopi alukuli ba꞉bo kotupuimima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ba꞉bene ba꞉be daedae okodawate ulihoheno ba emedena ebeno namutudawoeno pe komo a꞉kiya꞉tawamene. Ba꞉ba tetelo namutudawate pete ");
INSERT INTO knv_aramia_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","daedae okodawa koamo panagalimihote ma꞉lapila netewa tawakaluba꞉go konoemema꞉ne ebeno kuba huiya konelawema꞉, ba꞉be temeteme habalo iba꞉te lalo ba nikilame konomamo kihimima꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Ba꞉be hegelalo Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komote ba꞉ma ka꞉na kitanama꞉ne. Eta dubuti uli kamena da꞉lawi, ba꞉ba tetelo ta꞉ni bohelemela꞉te ibino wuiki alo uwatete genamane nikuliti eba꞉go poko habamo tolamema꞉ nelatimitiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ibi ipuwalo paibo bohelemela꞉te daedaema꞉ eda꞉huya꞉, huiyatiya komo paibate hido ukuia꞉go tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ba꞉ma ka꞉na daedae bohelemela꞉te ibino wuiki da꞉watui iba꞉te modobo beyago kawataha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","huiyatiya hido ukuia꞉go da꞉tolami ba꞉bi bohelemela꞉te modobo beya iyapohote ibino wuiki ba꞉gala beya ba꞉bo watuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Da꞉duni dubuti poko habamo tiyolo kapuluhukuniha꞉, ba꞉bema꞉ bohelemela꞉te tete ga꞉ga꞉lo nipo da꞉latimini iba꞉te ba꞉ dito lahaniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Iwa tetenomolo eta lumagiti ba꞉ma ka꞉na goewatani, ‘Dubuti ba꞉ na꞉pe! La꞉ hiliyonomate eba꞉go alugama꞉ na꞉pelama꞉la꞉!’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ba꞉ba tetelo ba꞉bi bohelemela꞉te mahila꞉halenate ibino wuiki pa꞉tihoma꞉ ba ewagelena, ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ba꞉bene paibo daedae bohelemela꞉te ibino hido ukui mabuluba꞉tamo na꞉ga꞉laniya꞉, ‘Wadiyala꞉ka꞉ la꞉eno wuiki beya tata atamo ikaa꞉mehoe? Aeno wuikiti tatalila koha꞉lahama꞉na꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Huiyatiya hido ukui bohelemela꞉te iba꞉tamo na꞉ga꞉laniya꞉, ‘Ao, ale la꞉tamo dikalamemena꞉, a hiliyonomate modoboha꞉ma꞉ keda꞉hama꞉nema꞉. Wadiyala la꞉ tolamete kolowami genamalo beya na꞉niyapohala꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ba꞉bene daedae bohelemela꞉te beya oholema꞉ da꞉tolameni, dubuti poko habamo ba꞉bo puluhukuni. Ba꞉ba tetelo paibo bohelemela꞉te dopamo hido ukuia꞉go da꞉latimini, iba꞉te eba꞉go poko genamamo nalehawaminanate genama namutudawate gigiho ba꞉ dito pekalapilani. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ba꞉bene komo paibo daedae bohelemela꞉te galane da꞉pelameni, iba꞉te gigiho tama꞉mo putitatanate genama namutudawa ba꞉ma ka꞉na pega꞉lameniya꞉, ‘Aeno Kodawa! Gigiho na꞉pa꞉hiya꞉midaa꞉ma꞉!’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Huiyatiya ebete na꞉goeni, ‘Ao, na la꞉eno komo iya꞉tawaha꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ba꞉bene Ya꞉suti kuititi tabo ba꞉ma ka꞉na goiya꞉, “La꞉ uliholo nemedeniya꞉la꞉, mabu Tawakalubino Naniwino hegela ba꞉gala tete la꞉ kiya꞉tawahanaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komote ba꞉ma ka꞉na kitanama꞉ne. Eta ko dubuti muhulu hopamo ba to ebeno okopi ebetamo ka꞉lamiti, iba꞉te ebeno ilina ba꞉gala mani hidamo kulamelemenama꞉ hiya꞉hiya꞉ ikalameholete ba꞉bo tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ba꞉ba tetelo ebete etatamo 5,000 mani bikamiya꞉, ba꞉gala etatamo 2,000 mani, ba꞉gala etatamo 1,000 mani, ibino ukuia꞉go modobolo ba꞉ba ka꞉na ba ikalamehole, ebete ibi ba꞉ dito miya꞉paliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ba꞉bene 5,000 mani da꞉lawiya꞉ ba꞉be dubuti tonomo tote eta bisnisi oko ba nowati eta 5,000 mani ba꞉bo nododiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ba꞉gala 2,000 mani da꞉lawiya꞉ ba꞉be dubuti atumu ba kanewagele eta 2,000 mani benododiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","huiyatiya 1,000 mani da꞉lawiya꞉ ba꞉be dubuti tote haka naligiti ebeno namutudawoeno mani dito nawaminuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Komo gogo da꞉petohuya꞉ ba꞉bi okopino namutudawate gala kapete iba꞉go kapimilo ibino mani kuititi ba꞉bo peka꞉lamiholelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ba꞉bene 5,000 mani da꞉lawiya꞉ ba꞉be dubuti pete 10,000 mani ba pehawakalimi na꞉pegoiya꞉, ‘Namutudawa, numa꞉. Ama꞉ 5,000 mani natamo ikanamiya꞉ta, huiyatiya naeno oko ipuwalo eta 5,000 mani gala da꞉kododimo, mola.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ebeno namutudawate ebetamo na꞉goiya꞉, ‘Ehe! Ama꞉ ba꞉ hido okodawalata ba꞉gala hido tuputupudawalata! Ama꞉ deha꞉poto komo hidamo ododia꞉ta, ba꞉bema꞉ na huiyatiya ama꞉ naeno komo koko komokomo ulamedawama꞉ komidima꞉nemata. Ama꞉ naeno kalakala poko habamo na꞉pa꞉pa꞉ga.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ba꞉bene 2,000 mani da꞉lawiya꞉ ba꞉be dubuti pete na꞉pegoiya꞉, ‘Namutudawa, numa꞉. Ama꞉ 2,000 mani natamo ikanamiya꞉ta, huiyatiya naeno oko ipuwalo eta 2,000 mani gala da꞉kododimo, mola.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ebeno namutudawate ebetamo na꞉goiya꞉, ‘Ehe! Ama꞉ ba꞉ atumu hido okodawalata ba꞉gala hido tuputupudawalata! Ama꞉ deha꞉poto komo hidamo ododia꞉ta, ba꞉bema꞉ na huiyatiya ama꞉ naeno komo koko komokomo ulamedawama꞉ komidima꞉nemata. Ama꞉ naeno kalakala poko habamo na꞉pa꞉pa꞉ga.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ba꞉bene kuititidawate 1,000 mani da꞉lawiya꞉, ebete pete na꞉pegoiya꞉, ‘Namutudawa, na iya꞉tawala ama꞉ tabo helonomo dubulata. Komopa꞉te ilina damihonaka ama꞉ ba꞉bi ilina dito ba꞉petapihonakomena꞉ta, ba꞉gala iba꞉te kikipo ibino pala꞉mo da꞉haminahalenaka ama꞉ noloho tetelo dito ba꞉puwatenakomena꞉ta ama꞉le ha꞉kiya konahama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ba꞉bema꞉ ama꞉ da꞉tuiya꞉la, nale ama꞉ tolemelo amia꞉no 1,000 mani haka ipuwamo dito nugumuiya꞉mo. Mola, ba꞉moe ba꞉bela. Amia꞉no ilina na꞉kalawa꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ebeno namutudawate huiyatiya ebetamo na꞉goiya꞉, ‘Ama꞉ kubanomo buhama okodawalata! Ama꞉ tabo ba꞉ma ka꞉na a꞉gaa꞉ta, komopa꞉te damihonaka nale ba꞉bi ilina dito ba꞉petapihonakomo, ba꞉gala iba꞉te kikipo da꞉haminahalenaka nale noloho tetelo dito ba꞉puwatenakomo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ba꞉bema꞉ mabu keka꞉ ama꞉ naeno mani baneka okopa꞉tamo kanikalamiya꞉ha꞉? Iba꞉te mani uwatete eta oko nowatitale kodopoma꞉ beda꞉na꞉, ba꞉bene nale pete ama꞉le natamo atu mani huiyatiya nanekela꞉mo hunudopamo gala ba꞉ka-ikanameona꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ba꞉bene ko dubuti ebeno hopopa꞉tamo na꞉goiya꞉, ‘La꞉ ebeno 1,000 mani lawemete 10,000 mana꞉goeno dubutamo nikama꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mabu kebe lumagigodolo hidohido ukui da꞉pola꞉na, etate ebetamo hiliyonomo hidohido komo ikamehote ebeno tepo ipuwa kotabuimima꞉ne, huiyatiya kebe lumagigodolo hidohido ukui pola꞉naheno, ebegodolo kebe kapiyakapiya komate da꞉pola꞉na etate ebegodone gala kakuwatemema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ba꞉bema꞉ ba꞉moe buhama okodawa du ipuwamo dito na꞉na꞉da꞉nala꞉, ba꞉bolo ebete komopa꞉go lalo ba nikilame konomamo kihimima꞉na꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Tawakalubino Naniwiti ebeno alo konomago ba꞉gala Hunu Haboeno nopopa꞉go da꞉pemene, ba꞉ba tetelo ebete ebeno Ko Gawadubu emede bahilo kopilutama꞉ne tawakalubino komo kopanagilamelelamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ba꞉bene hiya꞉hiya꞉ hopo tawakalubi hiliyonomate ebetamo da꞉pekapiyuimimina꞉, ba꞉ba tetelo ebete ibi hiliyonomo hiya꞉hiya꞉ komiya꞉tema꞉ne, sipi-goegoe ulamedawate sipi ba꞉gala gautu hiya꞉hiya꞉ keba ka꞉na ka꞉miya꞉tenako ba꞉ba ka꞉na, ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ba꞉bene ebete sipi-goegoe ebeno tu hapuamo miya꞉tete gautu-goegoe ebeno pele hapuamo komiya꞉tema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ba꞉ba tetelo Ko Gawadubuti tu hapu tawakaluba꞉tamo ba꞉ma ka꞉na kogoema꞉ne, ‘Naeno Nabiwiti hidohidopima꞉ da꞉goena, la꞉ ebeno Ko Gawadubu habamo na꞉pa꞉la꞉hala꞉ hidohido komokomo ba꞉bolo kopuwatema꞉. Iyo, ebete hopo haba ododi tetelo la꞉tamo da꞉hiduimiya꞉, la꞉ ba꞉moe uli haba na꞉pelawa꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mabu na baa꞉ kapete dunamenakui ba꞉ba tetelo la꞉le baa꞉ natamo ikanamehonenakuimata, ba꞉gala na beya kapete dunamenakui la꞉le na beyamo owalubininakuimata. Nale kapeladawamo la꞉tamo duluhukunakuimo ba꞉ba tetelo la꞉le na kalakalago a꞉lawenenakuimata, ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ba꞉gala pupulino ilinaha꞉ tetelo dito da꞉lutanakuimo la꞉le kaliko a꞉pulinamenakuimata. Tawetawete dunamenakui ba꞉ba tetelo la꞉le na hidamo buiya꞉menanenakuimata, ba꞉gala komo kubapa꞉te na du genamamo dihatenenakui la꞉le na unamema꞉ ba꞉bamo a꞉pelamenakuimata.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ba꞉ba tetelo tuputupupa꞉te huiya tabo Ko Gawadubutamo koga꞉lama꞉na꞉, ‘Kodawa, keba tetelo ama꞉ baa꞉ kapete dumitiya꞉la, ale ama꞉ umiti baa꞉ ba꞉bo kikametiya꞉la? Ba꞉gala ale beya kebolo kikametiya꞉la? ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Keba tetelo ama꞉ kapeladawamo da꞉puluhukuya꞉la, ale ama꞉ umiti kalakalago ba꞉bo ka꞉lawitiya꞉la? Ba꞉gala ale hido kaliko kebolo ka꞉pulimitiya꞉la? ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Keba tetelo ama꞉ tawetawete dumitiya꞉la ale owalubi ba꞉bo ka꞉pihatiya꞉ma꞉? Ba꞉gala komopa꞉te ama꞉ du genamamo dihatitiya꞉la ale keba tetelo ama꞉ umima꞉ ba꞉bamo ka꞉pelamiya꞉ma꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ba꞉bene Ko Gawadubuti iba꞉tamo kohuiyama꞉ne, ‘Ba꞉moi naeno ta꞉matapi nulama꞉la꞉. Na la꞉tamo hibi tabo begoemo, la꞉le ibi ipuwalo deha꞉potonomo lumagitamo ba꞉mako hido komo dododinamima, la꞉ natamo ododinamimata.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ba꞉bene ebete ohobigate pele hapupa꞉tamo ba꞉ma ka꞉na kogoema꞉ne, ‘Godote la꞉tamo kuba huiya ikalamema꞉ goena, ba꞉bema꞉ la꞉ naeno holoholo hapuni na꞉tolama꞉la꞉! Ebete Saitanako ba꞉gala ebeno nopopi mabuma꞉ ha꞉gaha꞉ koe ya꞉lo demaduya꞉, la꞉ ba꞉be koe ipuwamo na꞉tolama꞉la꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mabu na baa꞉ kapete dunamenakui la꞉le baa꞉ natamo kikanamenakuiha꞉, ba꞉gala na beya kapete dunamenakui la꞉le beyamo kowalubininakuiha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na kapeladawamo duluhukunakuimo, la꞉le na kalakalago kalawenenakuiha꞉, ba꞉gala na pupulino ilinaha꞉ tetelo dito da꞉lutanakuimo la꞉le kaliko kapulinamenakuiha꞉. Tawetawete na dunamenakui ba꞉gala komo kubapa꞉te na du genamamo dihatenenakui, la꞉le na kapowalubininakuiha꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ba꞉ba tetelo iba꞉te huiya tabo ebetamo koga꞉lama꞉na꞉, ‘Kodawa, ama꞉ baa꞉ kapete o beya kapete keba tetelo kumititiya꞉la? Ba꞉gala ama꞉ kapeladawamo o ilinaha꞉dawamo atamo keba tetelo ka꞉puluhukuya꞉la? Ba꞉gala ama꞉ tawetawete dumitiya꞉la o komopa꞉te ama꞉ du genamamo dihatitiya꞉la keba tetelola꞉ka꞉? Ale ama꞉ ba꞉ba ka꞉na ewagelitalo kuminakuiha꞉!’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ebete huiyatiya iba꞉tamo kogoema꞉ne, ‘Na la꞉tamo hibi tabo begoemo, la꞉le naeno deha꞉potonomo lumagitamo ba꞉mako hido komo ododihino demedenamima, la꞉le natamo kododinamiha꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ba꞉bema꞉ Ya꞉suti kuititi tabo ba꞉ma ka꞉na goiya꞉, “Ba꞉ hibila, ba꞉bi kubapa꞉te wiboha꞉ Temeteme Habamo ba tolame, huiyatiya tuputupupa꞉te wiboha꞉ Ka꞉ka꞉ Habamo kotolamema꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ba꞉bene Ya꞉suti ba꞉moi tabo hiliyonomo olamagi da꞉wibuya꞉, ebete ebe ta꞉matapa꞉tamo na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“La꞉ iya꞉tawahala Adaguila꞉ Poko tupuimima꞉ netewa hegelate ba꞉nepola꞉na. Ba꞉ba tetelo Godote Tawakalubino Naniwi tawakalubino kokotamo kihatema꞉ne, ba꞉bene iba꞉te ebe kehamo pihomotete ba꞉bo kanakapumima꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ba꞉be gogolo Kayapasiti Godotamo hawa꞉goeno ikamehopino Hununomo Watodawama꞉ eda꞉nami. Ba꞉bema꞉ ba꞉be ko dubu ba꞉gala ebeno hopopi ba꞉gala Yu tawakalubino komo koko dubu, iba꞉te ebeno genamamo pekapiyuimiti ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","tabo ba꞉bo ihatiya꞉ Ya꞉suku kanakapumima꞉. Ba꞉bema꞉ iba꞉te ebe diya lawema꞉ gabo ba ohowadita ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","komopa꞉te huiyatiya na꞉ga꞉luya꞉, “A Poko tetelo ebe a꞉kalawa꞉ma꞉, mabu tawakaluba꞉te atamo maubahalete ago alaholohodemena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ba꞉bene Ya꞉suti Betani habalo eta dubu Saimonokono genamalo lutiya꞉, ba꞉be dubu dopamo kuitikuita꞉goenola. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ya꞉suti baa꞉ ba nuta ba꞉ba tetelo kapiya kamenate pete, hido nibo ihi nakola kalila꞉mo tabuimi adahete Ya꞉sukunu watamo ba꞉bo pehaminamiya꞉, ba꞉be ihi ilinoeno huiya konomola. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ya꞉suku ta꞉matapa꞉te ba꞉be komo dumiya꞉ iba꞉te maubahalete na꞉ga꞉luya꞉, “Mabu keka꞉ ebete huiya ko ilina gigilepalama꞉ da꞉midi? ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","A ba꞉moe ihi kolowamima꞉ na꞉nimiditale mani konomo buwatena꞉, ba꞉bene ba꞉bi mani awaepa꞉tamo dito bikalameholena꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ya꞉suti ibino tabo ga꞉la iya꞉tawate huiyatiya iba꞉tamo na꞉goiya꞉, “La꞉le ba꞉moe kamena badama꞉ ka꞉kiyahamiutama? Ebete natamo hidonomo komo bododi. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","La꞉ numa꞉la꞉, awaepa꞉te tete ga꞉ga꞉nomolo la꞉go bemedehonamena꞉, la꞉eno ubi tetelo ibi nowalubilinakuya꞉la꞉, huiyatiya na emedena tetelo la꞉go a꞉kemedenamo, tete tatalila nale la꞉ komiya꞉palema꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ba꞉bema꞉ nale hoeha꞉ tetelo ba꞉moe kamenate hido nibo ihi naeno apa꞉mo da꞉hamina, ba꞉be komodo ebete gabo bihiduimi naeno ape bobamo ihatema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na la꞉tamo hibi tabo begoemo, tawakaluba꞉te hiya꞉hiya꞉ hiliyonomo hopamo Godokono Hido Tabo datanakomena꞉, iba꞉te ba꞉moe kamenate dododi ba꞉be komo emalagidololo ba꞉nolamagiminakomena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ba꞉bene Ya꞉sukunu 12 ta꞉matapi ipuwalo Keliyotanapi Yudasiti Godotamo hawa꞉goeno ikamehopino watowatopa꞉tamo tote, ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na꞉negoiya꞉, “Nale Ya꞉suku la꞉eno kokotamo dihatemo, la꞉le natamo bada huiya na꞉kikanameoma?” Ba꞉ba tetelo iba꞉te 30 siliba mani ba꞉bo ikamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ba꞉bene ba꞉ba tetene tupuimiti ebete gabo bohowadiya꞉ Ya꞉suku ibino kokotamo kihatema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ba꞉bene tawakaluba꞉te Hunamo Mahigaha꞉ Palawa Baa꞉ Poko naha da꞉tupuimiya꞉, ba꞉be hegelalo Ya꞉suku ta꞉matapa꞉te ebetamo pelamete na꞉pega꞉luya꞉, “Ale Adaguila꞉ Pokoeno naha ilina kebolo na꞉ka꞉hiduilamema꞉, ale ama꞉go kapimilo konahama꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ya꞉suti iba꞉tamo na꞉huiyuya꞉, “La꞉ netewapi ko habamo tote aeno eta mabulubi da꞉numima, ba꞉be dubutamo ba꞉ma ka꞉na na꞉nega꞉luya꞉la꞉, ‘Iya꞉tulamedawate goe, naeno olalati komoeno uluhuku tete tatalila, Godokono ubila. Ba꞉bema꞉ na ubila amia꞉no genamalo nale naeno ta꞉matapa꞉go Adaguila꞉ Poko baa꞉ kopenama꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ba꞉bene Ya꞉suti ibi keba ka꞉na ka꞉kiyalamiya꞉, ebe ta꞉matapa꞉te ba꞉ba ka꞉na nododiti Adaguila꞉ Poko ilina ba꞉bo nihiduilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ba꞉bene ba꞉be dulu Ya꞉suti ebeno 12 ta꞉matapa꞉go baa꞉ nahama꞉ da꞉gagahidiniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ba꞉ba tetelo Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Na la꞉tamo hibi tabo begoemo, la꞉ ipuwalo etate na anakapunamepi kowalubilima꞉ne na lawenema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iba꞉te tepo menemenenomoma꞉ ba eda꞉hana Ya꞉sutamo etate goenakui, etate goenakui, “Kodawa, nalela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ebete iba꞉tamo na꞉huiyaniya꞉, “Baa꞉ kalila꞉mo pote nago kokoto ka꞉ma꞉ daduti, ba꞉be ba꞉be lumagila. Ebete na anakapunamepino kokotamo kihatenema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iyo, ba꞉ hibila, Tawakalubino Naniwiti hoea꞉mo ba꞉ na꞉to, Godokono Bukalo tabo ba꞉ma ka꞉na itana, huiyatiya kebe lumagiti ebe anakapumipa꞉tamo dikalamemene, ba꞉be lumagiti kuba huiya konomo kolawema꞉ne. Ba꞉moe ba꞉be mabuma꞉ ba꞉be dubu ebeno menokote ebe alahimiha꞉ma꞉ eda꞉ ba꞉ wadiyala!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ba꞉bene Yudasiko, ebete dopamo Yu watowatopa꞉go nopo da꞉tamotiya꞉ Ya꞉suku lawema꞉, ebete na꞉goeniya꞉, “Iya꞉tulamedawa, nalela꞉ka꞉?” Ya꞉suti na꞉huiyaniya꞉, “Ama꞉ ba꞉ a꞉gaa꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ba꞉bene iba꞉te baa꞉ ba nahana, Ya꞉suti baa꞉ lawenate Godotamo kalakala tabo goenate ba꞉bo wakamihoniya꞉, ba꞉bema꞉ ebete ebe ta꞉matapa꞉tamo ba ikalamena na꞉goeniya꞉, “La꞉ uwatete na꞉nahala꞉, ba꞉moe ba꞉ naeno apela.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ba꞉bene ebete kalili kalawenate, Godotamo kalakala tabo goenate iba꞉tamo ba ikalamena na꞉goeniya꞉, “La꞉ hiliyonomo na꞉nihala꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mabu Godote tawakaluba꞉go komiloma꞉ nopo da꞉tamotiya꞉, ba꞉moe naeno hawiti ba꞉be nopo bekodakoduimina, iyo, ba꞉moe hawiti komo hiliyonomo tawakalubino kuba egebolelamema꞉ koka꞉ka꞉la꞉ma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nale la꞉ begoelamemata, na ba꞉ma tetelo ba꞉moe gao beya gala a꞉kana꞉mo, huiyatiya naeno Nabiwiti Ko Gawadubuma꞉ deda꞉na, ba꞉be habalo na uli gao beya galane tetelo la꞉go koninihoma꞉nema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ba꞉bene iba꞉te Godoko adikumino ohale alapihonate, Olibi Kehakeha Hunu Hakamo kotolamenama꞉ genamane ba꞉ dito ikuliniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ba꞉ba tetelo Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Ka꞉lo dulu la꞉ hiliyonomate na komiya꞉panema꞉nemata, mabu Godokono Bukalo tabo ba꞉ma ka꞉na itana, ‘Godote sipi-goegoe ulamedawa danakapumimini, ba꞉ba tetelo ebeno kapiyuimi sipi-goegoa꞉te hiya꞉hiya꞉ kalahutihoma꞉na꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Huiyatiya Godote na hoene gala da꞉kadipanatenemene, na Ga꞉lili hopamo dopamo kotoma꞉nemo. La꞉le na ba꞉bolo kopunamema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ba꞉bene Pitate Ya꞉sutamo na꞉goeniya꞉, “Ibi hiliyonomate hoe tolemelo ama꞉ miya꞉pate dalahutihomena꞉, huiyatiya nale ama꞉ a꞉kamiya꞉pamata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ya꞉suti ebeno tabo ba huiyana na꞉goeniya꞉, “Na ama꞉tamo hibi tabo begoemo, ka꞉lo dulu kakabate goehoheno, ama꞉ netewa-kapiya teta꞉mo na iya꞉tawaha꞉ma꞉ kogoema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pitate ebetamo gala na꞉kagoeniya꞉, “Na ama꞉go da꞉nehoemo, nale ama꞉ iya꞉tawaha꞉ma꞉ a꞉kagaa꞉mo!” Ba꞉ba tetelo Ya꞉suku ta꞉matapi hiliyonomate ba꞉ atu tabo bekaga꞉laniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ba꞉bene Ya꞉suku ba꞉gala ebe ta꞉matapi iba꞉te ko habane ikulinate eta tatali hopamo tolameniya꞉, ba꞉be hopoeno mahilo Getasemanila. Ya꞉suti ba꞉bolo iba꞉tamo na꞉negoeniya꞉, “La꞉ ba꞉malo na꞉pola꞉nala꞉. Na ba꞉moe tatalia꞉mo tomo Godotamo toetoe tabo konolamagima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ba꞉ba tetelo ebete Sebedikono gugudi Ya꞉imesiko ba꞉gala Yoneko, ibi netewapi ba꞉gala Pitako baleta toetoe tabo ga꞉la baha꞉mo magatalenate, ba꞉bene tepo menemene komo ba꞉gala ukui temeteme komo ebetamo konomamo ba꞉bo pelameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ba꞉bema꞉ Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Na tepo temeteme konomamo iya꞉tawanamo, ba꞉mako tepo temeteme na anakapuname huiyala. La꞉ ba꞉malo nago uliholo na꞉pola꞉nala꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ba꞉bene ebete nanekela꞉mo tonate, ebeno holoholo hakamo nihatenate Godotamo ba꞉ma ka꞉na netoetoeniya꞉, “Naeno Nabiwi, ama꞉ modoboma꞉ da꞉goemena꞉, ba꞉moe temeteme kalili nagodone na꞉lawa꞉. Huiyatiya naeno ubiha꞉, ama꞉ ha꞉kiya amia꞉no ubila nododa꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ba꞉bene ebete ta꞉matapa꞉tamo da꞉peniya꞉ lahanalo pulamenate Pitatamo na꞉pegoeniya꞉, “Mabu keka꞉ la꞉le nago tete nanekelelo uliho modoboha꞉ma꞉ deda꞉hanama?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ba꞉ba tetelo Ya꞉suti ibi na꞉goelameniya꞉, “Godotamo uliholo na꞉toetoehonala꞉, mabu la꞉le Saitanakono kuba gabamo emogabuimi komamo gudidimata. La꞉eno tepo ipuwalo hido komo ododima꞉ ubila, huiyatiya la꞉godolo ododi helo puliyala.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ya꞉suti eta tetelo gala katonate Godotamo ba꞉ma ka꞉na kanetoetoeniya꞉, “Naeno Nabiwi, ba꞉moe temeteme kalili ama꞉ nagodone lawema꞉ gabote itanaheno wadiyala, amia꞉no ubi ditanamene na konima꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ba꞉bene ebete ebe ta꞉matapa꞉tamo da꞉kapeniya꞉ lahanalo kapulameniya꞉, mabu ibino baiditi menemenema꞉ eda꞉halameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ba꞉bene Ya꞉suti netewa-kapiya tetelo ibi gala kamiya꞉palenate, dopamo ebete toetoe tabo keba ka꞉na ka꞉nolamaginiya꞉ ebete Godotamo ba꞉ atumu kanolamaginiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ba꞉ba tetelo ebete ebe ta꞉matapa꞉tamo da꞉kapeniya꞉ iba꞉tamo na꞉pegoeniya꞉, “La꞉ hawela amiholo gala badama꞉ ka꞉kalahonama? Numa꞉la꞉, tete ba꞉ a꞉pe, kubapa꞉te Tawakalubino Naniwi ibino kokotamo ba꞉ na꞉lawa꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Iyo, la꞉ na꞉pakaminala꞉, a ba꞉ na꞉tolamema꞉. Numa꞉la꞉, na anakapunamepino kokotamo ihatenedawate ba꞉ na꞉pe!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ya꞉suti ba꞉be tabo ba goena Yudasiti ba꞉bo peniya꞉, Ya꞉sukunu 12 ta꞉matapi ipuwalo ebe ba꞉ etala. Ba꞉bene eba꞉go komo dubu hiliyonomate ibino alaholoho gili ba꞉gala kukago pelameniya꞉, ba꞉bi dubu ba꞉ Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala Yunapino komo koko dubu, iba꞉te da꞉poelameniya꞉ ba꞉bi dubula. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ba꞉ hibila, Yudasiti ibi ya꞉lo ba꞉ma ka꞉na goelameniya꞉, “Nale daboetehomo, ba꞉be ba꞉be lumagila. La꞉ ebe tiyonomo na꞉lawiya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ba꞉bene Yudasiti penate, Ya꞉sutamo tonomo tonate ebe na꞉negoemeniya꞉, “Iya꞉tulamedawa, nolata!” Ba꞉ba tetenomolo ebete ebe ba꞉bo aboetehoniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ya꞉suti ebetamo na꞉goeniya꞉, “Mabulubi, ama꞉ bada komo ododima꞉ da꞉pa꞉, nododa꞉,” ba꞉bene komo dubate Ya꞉sutamo pelamenate ibino kokotamo ebe kodakodanomolo ba꞉bo laweniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ba꞉bene Ya꞉suku ta꞉matapi ipuwalo eta dubuti ebeno alaholo gili magubutinate, Godotamo hawa꞉goeno ikamehopino Hununomo Watodawoeno genama okodawa anagaliminate galo hapu ba꞉bo mapitamidameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Huiyatiya Ya꞉suti ebetamo na꞉goeniya꞉, “Amia꞉no gili gala na꞉kahula꞉, mabu gila꞉mo dalaholohona galane komopa꞉te ibi atumu gila꞉mo kanakapulamema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ama꞉ iya꞉tawala꞉ka꞉, nale ubi ihatete Godoko da꞉kiyamemo, ba꞉ba tetelo na kowalubinima꞉ ebete ebeno 12 taosene alaholoho nopopi kopoelamema꞉ne? ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Huiyatiya nale ba꞉ba ka꞉na dewagelemo, Godote dopamo ebeno Bukamo da꞉miya꞉tiya꞉ ba꞉bi hibi komate keba ka꞉na na꞉kikulimina꞉? Buka tabote hibilo goena ba꞉moi komate natamo nikula꞉mena꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ba꞉ba tetelo Ya꞉suti komo dubu hiliyonomatamo na꞉goeniya꞉, “Na pilo lumagila꞉ka꞉, o na alaholodawala꞉ka꞉? Mabu keka꞉ la꞉le alaholoho gila꞉go ba꞉gala kukago na lawenema꞉ da꞉pelamema? Na komo hegelalo Godoko Adikumino Hiya꞉ Genamalo ba luta tawakalubi diya꞉tulamenatimo, la꞉le na ba꞉bolo kalaweneha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","huiyatiya ba꞉moi hiliyonomo komate ba꞉ ikuliha, Godokono ukui hawakalimipa꞉te ebeno Bukamo dopamo da꞉miya꞉tiya꞉ ba꞉bi tabo komate hibima꞉ keda꞉hama꞉.” Ba꞉ba tetelo ebe ta꞉matapi hiliyonomate ebe miya꞉panate dito alahutihoniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ba꞉ba tetelo Ya꞉suku da꞉laweniya꞉ ba꞉bi dubate ebe Kayapasikono genamamo magataniya꞉, Kayapasiko ba꞉ Godotamo hawa꞉goeno ikamehopino Hununomo Watodawala. Iba꞉te Ya꞉suku ba꞉be genamamo magatanaheno dopamo Godokono Tutumu iya꞉tulamepi ba꞉gala komo koko dubu iba꞉te pelamenate ba꞉bo pekapiyaniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ba꞉ba tetelo Pitate Ya꞉suku muhuludopone ba ta꞉matana, ebete Hununomo Watodawoeno genama kala ipuwamo na꞉pa꞉ganate lawamepa꞉go ba꞉bo nilutiya꞉. Ebe ubila kebe komote Ya꞉sutamo duluhukumini ba꞉be komo ebeno baida꞉mo kuminama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ba꞉bene Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala komo Ka꞉nisolo dubu hiliyonomate ha꞉da tabo ga꞉lapi boholeniya꞉, Ya꞉sukunu kuba oholemenate ebe kanakapumima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ba꞉bema꞉ hiliyonomo tabo ga꞉lapa꞉te ebeno komoma꞉ ha꞉da bamihohoniya꞉ huiyatiya ibino tabo ga꞉la ipuwalo Ka꞉nisolo dubate Ya꞉sukunu hoe mabuma꞉ eta kuba kuminiya꞉ha꞉. Ba꞉bene kuititi hapuamo netewapa꞉te badi puluhukunate ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ulihopa꞉tamo na꞉pega꞉laniya꞉, “Ba꞉moe dubuti ba꞉ma ka꞉na goi, ‘Naeno helo modobola Godoko Adikumino Genama anabulimiti netewa-kapiya hegelalo gala kaketema꞉nemo.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ba꞉bene Godotamo hawa꞉goeno ikamehopino Hununomo Watodawate mahiganate Ya꞉sutamo na꞉goeniya꞉, “Ama꞉ tabo goeha꞉ma꞉ badama꞉ kedeona? Ba꞉moi dubate ama꞉ mabuma꞉ da꞉ga꞉lana keba ka꞉nala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ya꞉suti tabo goeheno Hununomo Watodawate ebetamo gala na꞉kagoeniya꞉, “Nale ama꞉ Ka꞉ka꞉ Godokono mahilamo na꞉goememata, ama꞉ a na꞉kiyaa꞉ma꞉, ama꞉ ba꞉ Godokono Gudu Kelisotela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ya꞉suti ebetamo na꞉huiyaniya꞉, “Ama꞉ ba꞉ a꞉gaa꞉ta. Nale la꞉ begoelamemata, hibila, la꞉le na Tawakalubino Naniwi aeno Helodawa Godokono tu hapulu lutalo kunamema꞉nemata, iyo, galane na Hunu Habane hawai ipuwado kopehawakalama꞉nemo!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ba꞉bema꞉ Hununomo Watodawate ba꞉be tabo ulinate, ebeno konomo mauba komo kohawakaliminama꞉ ebete da꞉puliniya꞉ ba꞉be atuino ga꞉ga꞉ kaliko anagiya꞉midalenate na꞉goeniya꞉, “A ba꞉moe dubuino kuba kiya꞉tawahama꞉ eta tabo goedawa a ubihinola! Ebete ha꞉kiya kubanomo tabo da꞉goe la꞉ ba꞉ ulihomata, mabu ebete na꞉goe, ‘Na ba꞉gala Godoko, a ba꞉ kapiyala!’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ba꞉bema꞉ la꞉eno ubi keba ka꞉nala꞉ka꞉ ebeno komoma꞉?” Ka꞉nisolo dubate huiya tabo na꞉ga꞉laniya꞉, “Wadiyala ebete na꞉haa꞉mene!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ba꞉bene komo iba꞉te kowe ebeno holoholamo mehoholenate, ba꞉gala komopa꞉te kokotamo ebe tatakolo ba anagalimihona ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na꞉ga꞉laniya꞉, “Ama꞉ Godokono ukui hawakalimidawa Kelisoma꞉ hibilo deda꞉na, a na꞉kiyaa꞉ma꞉ ama꞉ puya꞉te kanagalimihotana!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ba꞉ba tetelo Pitate ba꞉be genamoeno kala ipuwalo ba luta, oko bohelete ebetamo penate ebe na꞉pikiyameniya꞉, “Ama꞉ ba꞉ atumu ba꞉moe Ga꞉lili hoponapi Ya꞉sukuba꞉ pata꞉nama꞉ta!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pitate ibi hiliyonomoeno holoholo hapulu na꞉goeniya꞉, “Ao, ama꞉le da꞉goena ba꞉be tabo na iya꞉tawaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ba꞉bene ebete kala imi gigihamo da꞉toniya꞉, ba꞉ba tetelo eta oko bohelete ebe uminate, ba꞉bolo da꞉pola꞉nuya꞉ ba꞉bi tawakalubi na꞉kapekiyalameniya꞉, “Ba꞉moe dubuti Nasaletenapi Ya꞉sukuba꞉ pata꞉nami!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Huiyatiya Pitate ba꞉ atu tabo ba꞉ma ka꞉na kagoeniya꞉, “Na Godokono mahilamo goemo, na ba꞉be dubu iya꞉tawaha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ba꞉bene ba꞉bolo da꞉pola꞉nuya꞉ iba꞉te tete nanekelelo pola꞉natepanate Pitatamo pelamenate ebe gala na꞉kapikiyameniya꞉, “Hibila! Ama꞉ ba꞉ Ya꞉sukunu eta lumagilata, mabu amia꞉no tabo olamagi komote ba꞉moe komo behawakalimina, ama꞉ ba꞉ Ga꞉lili hopodawa etama꞉ eda꞉nata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Huiyatiya Pitate na꞉goeniya꞉, “Godokono dopo hapulu utiti na꞉goemo, nale hibi tabo goeheno ebete na kanagalinamema꞉ne! Nale ba꞉be dubu iya꞉tawaha꞉!” Ba꞉bene ba꞉ba tetenomolo kakabate da꞉goehoniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ya꞉suti ebetamo dopamo kebe tabo ka꞉goeniya꞉, Pitate ba꞉be tabo ba꞉bo emalagidoloniya꞉, “Kakabate goehoheno ama꞉le netewa-kapiya teta꞉mo na iya꞉tawaha꞉ma꞉ kogoema꞉na꞉ta.” Ba꞉bene Pitate gobogobamo tonate konomo tepo temetema꞉go ibulunomo ba꞉bo nihiniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hegelate da꞉powalohuya꞉ Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala komo kokopi, ibi hiliyonomate Ya꞉suku anakapumima꞉ tabo bega꞉lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba꞉bene iba꞉te Ya꞉suku hala꞉mo matuhumihote Paeletetamo ba꞉bo magatuya꞉, ebe ba꞉ Lomanapa꞉te Yudiya hopamo da꞉poemiya꞉ ba꞉be kapela Ko Gawadubula. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ba꞉ba tetelo Yu watowatopa꞉te Ya꞉suku anakapumima꞉ nopo hibinomolo da꞉tamotiya꞉, Yudasiti ba꞉be komo uliya꞉, ebe ba꞉ Ya꞉suku ibino kokotamo dihatiya꞉ ba꞉be lumagila. Ba꞉bema꞉ ebete du tetelo kebe kuba komo kododiniya꞉ ba꞉be mabuma꞉ tepo temeteme konomoma꞉ eda꞉lo, ebete 30 siliba mani Yu watowatopa꞉tamo kawadahete na꞉pegoiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Na kuba ododinimo. Na tuputupunomo lumagi la꞉eno kokotamo ihatenimo.” Ba꞉bene watowatopa꞉te ebeno tabo ba huiya na꞉ga꞉luya꞉, “Ebe aeno komoha꞉, ama꞉ ha꞉kiya amia꞉no komola.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ba꞉ba tetelo Yudasiti ba꞉bi mani Godoko Adikumino Hiya꞉ Genama guamo ba꞉bo nemela꞉midaliya꞉, ba꞉bene ebete tote ebeno kokoba꞉mo hale nema꞉homete ebe ha꞉kiya ebe ba꞉bo nanakapumiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ba꞉bema꞉ Yu watowatopa꞉te ba꞉bi mani ba uwatehole ba꞉ma ka꞉na ga꞉luya꞉, “Tutumu tabote talona bihatea꞉mena ale ba꞉moe mani Godokono mana꞉go kapiyuimima꞉, mabu ba꞉moe mani ba꞉ lumagi anakapumi manila.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ba꞉bene iba꞉te tabo ba꞉ma ka꞉na ihatiya꞉, “Wadiyala a ba꞉moe mana꞉mo Kalili Ododili-dawoeno Haka kolawema꞉nema꞉, ba꞉bene kapela tawakaluba꞉te Yelusalema ko habalo da꞉peha꞉lanakomena꞉, ale ibi ba꞉moe hakamo ba꞉miya꞉tenakoma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ba꞉bema꞉ ba꞉ba tetene tupuimiti ba꞉ma teta꞉mo puluhuku tawakaluba꞉te ba꞉be haka Hawi Huiya Hakama꞉ ka꞉mina, mabu dopamo iba꞉te ba꞉be mana꞉mo lumagi anakapumiti ebeno hawi hakamo ba꞉bo ka꞉ka꞉liya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ya꞉lo tetelo Godokono ukui hawakalimidawa Yelemayate tabo ba꞉ma ka꞉na goiya꞉, “Isalaela tawakaluba꞉te 30 siliba mani uwatete na꞉ga꞉luya꞉, ‘Ba꞉moe ba꞉ Godokono okodawoeno huiyala.’ Ba꞉bema꞉ Kodawa Godote na Yelemayako keba ka꞉na ka꞉kiyanami, tawakaluba꞉te ba꞉bi mana꞉mo kebe komo na꞉kododimina꞉, iba꞉te hibilo ba꞉ ba꞉ba ka꞉na ododiya꞉, iyo, iba꞉te ba꞉be mana꞉mo Kalili Ododilidawoeno Haka belawiya꞉.” Ba꞉bema꞉ ba꞉moe komo ba꞉ hibila, Ya꞉suku tetelo Yu watowatopa꞉te ba꞉be haka mana꞉mo da꞉lawiya꞉, ba꞉ba tetelo Godote Yelemayako ipuwado dopamo da꞉goiya꞉ ba꞉be tabote hibinomoma꞉ ba꞉bo ediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ba꞉bene Ya꞉suti kapela Ko Gawadubu Paeletekono holoholo hapulu ba la꞉na, ebete ebe ba꞉bo alatediya꞉, “Ama꞉ Yu tawakalubino Ko Gawadubula꞉ka꞉?” Ya꞉suti na꞉goiya꞉, “Ama꞉ ba꞉ a꞉gaa꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ba꞉bene Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala komo koko dubu, iba꞉te Ya꞉sukunu komoma꞉ na꞉ga꞉lutiya꞉ ebete hiya꞉hiya꞉ kuba bododilinami. Ba꞉ba tetelo Ya꞉suti huiyatiya tabo kagoiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ba꞉bene Paeletete ebetamo na꞉goiya꞉, “Iba꞉te na꞉ga꞉lita ama꞉ hiliyonomo koko kuba bododilia꞉ta. Ibino tabo ga꞉la na꞉kuliuta?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Huiyatiya Ya꞉suti eta tabo deha꞉poto kapiya kagoiya꞉ha꞉, ba꞉bema꞉ kapela Ko Gawadubuti konomamo hanohanuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ba꞉ba tete tawakalubino ododi komo ba꞉ma ka꞉nala, hiliyonomo gogo ipuwalo Yunapino Adaguila꞉ Poko tetelo ibi hiliyonomate du genamalo kapiya lumagi mahilamo da꞉ka꞉minakui, kapela Ko Gawadubu Paeletete ba꞉be lumagi ebeno kuba huiyane dito oemenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ba꞉ba tetelo eta lumagiti du genamalo nemedenami, ebeno mahilo Balabasitila ba꞉gala ebete kebe koko kuba dododiliya꞉ tawakaluba꞉te iya꞉tawahala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ba꞉bema꞉ tawakaluba꞉te Paeletetamo da꞉pekapiyuya꞉ ebete ibi na꞉goelamiya꞉, “La꞉ ubila꞉ka꞉ nale Balabasiko ebeno kuba huiyane dito oeme? O la꞉ ubila꞉ka꞉ Ya꞉suku, komopa꞉te ebe Kelisoma꞉ da꞉ka꞉mina?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paeletete ba꞉moe tabo begoiya꞉ mabu ebete iya꞉tawuya꞉ Yunapi hiliyonomate Ya꞉sutamo na꞉kalakalahutiya꞉, huiyatiya ibino watowatopa꞉te ba꞉be mabuma꞉ maubahate ebe dito magahiya꞉, iyo, iba꞉godolo hibi komo puliyala, kitanuya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ba꞉ba tetelo Paeletete tabo anagiya꞉mida habalo ba luta, ebeno kamenate ebetamo tabo ba poeme na꞉pegoiya꞉, “Ama꞉ ba꞉moe tuputupunomo dubutamo eta komo akododa꞉la꞉, mabu na ka꞉lo dulu ebe mabuma꞉ hiyolo temeteme konomo a꞉lawenakamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Huiyatiya Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala komo koko dubu, iba꞉te tabo ga꞉la ipuwalo komo hiliyonomo tawakaluba꞉tamo helo bikalamiya꞉, iba꞉te Paeleteko koga꞉lamema꞉ ebete Balabasiko ka꞉ka꞉mo dito oemete huiyatiya Ya꞉suku kanakapumima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ba꞉bene kapela Ko Gawadubuti iba꞉tamo gala na꞉kagoiya꞉, “Ba꞉moi netewapi ipuwalo nale poko dito na꞉koememo?” Iba꞉te ebetamo na꞉huiyuya꞉, “Balabasiko dito noema꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Paeletete iba꞉tamo na꞉goiya꞉, “Ba꞉moe Ya꞉su komopa꞉te ebe Kelisoma꞉ da꞉ga꞉lana, nale ebe keba ka꞉na na꞉kamitimo?” Ibi hiliyonomate na꞉ga꞉luya꞉, “Keha pihigamo pihomotete, ikoko nalukulima꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ba꞉bene Paeletete na꞉goiya꞉, “Bada mabuma꞉? Ebete bada kuba kododi?” Huiyatiya iba꞉te konomamo ga꞉ga꞉lo gala na꞉kaga꞉luya꞉, “Keha pihigamo na꞉pihomota꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ba꞉ba tetelo Paeletete iya꞉tawuya꞉ iba꞉te ebeno tabo kalawitiya꞉ha꞉ huiyatiya alaholoho komote uluhukutiya꞉. Ba꞉be mabuma꞉ ebete beya lawete hiliyonomo tawakalubino holoholo hapulu kokoto ba ukulaha na꞉goiya꞉, “Ba꞉moe tuputupudawoeno hawi ka꞉ka꞉la꞉ komote naeno kubama꞉ a꞉keda꞉mene, ba꞉ la꞉eno kubala!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hiliyonomo tawakaluba꞉te huiyatiya na꞉ga꞉luya꞉, “Wadiyala! Ebeno hawi ka꞉ka꞉la꞉ mabuma꞉, a ba꞉gala aeno guguda꞉go ba꞉be kuba huiya kolawema꞉nema꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ba꞉bema꞉ Paeletete Balabasiko du genamane ba꞉ dito oemiya꞉, ba꞉gala ebete alaholohopi na꞉goelamiya꞉ iba꞉te Ya꞉suku giya꞉pa꞉pa꞉mo ka꞉na꞉miga꞉tima꞉. Ba꞉bene ba꞉be komo da꞉wibuya꞉ ebete Ya꞉suku alaholohopa꞉tamo dito ikalamiya꞉, iba꞉te ebe keha pihigamo pihomotete ikoko kalukulimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ba꞉ba tetelo Paeletekono alaholohopi dubate Ya꞉suku Loma gabomanino ko genama guamo magatate ibino alaholohopino kapiyuimi dubu hiliyonomate iba꞉go ba꞉bo nekapiyuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iba꞉te Ya꞉suku ba waliti ebeno kalikonomo pekanamete huiyatiya huiya konomo hawihawi kaliko ebetamo ba꞉bo pulimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ba꞉bene iba꞉te olagoeno tupina nelawete anagogobeya꞉midahalo a꞉dete Ya꞉sukunu watamo dito pulimiya꞉, ba꞉gala iba꞉te kuku ebeno tu hapu kokotamo ihatemiya꞉, ko gawadubuino helo hawakalimino kuku keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉na. Ba꞉ba tetelo iba꞉te ebe iya꞉da꞉telo ibino pupamo ahiditi ebetamo ba papamila꞉ha na꞉ga꞉luya꞉, “A꞉iye! Yu tawakalubino Ko Gawadubu, ama꞉ nolata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ba꞉bene iba꞉te ebetamo kowe mehoholete, ebeno kuku lawemete watolo ba꞉bo anagalimihuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Iba꞉te ebe waliti da꞉wibuya꞉, hawihawi kaliko ebeno apene pekanamete ebeno kalikonomo gala dito kapulimiya꞉, ba꞉bene iba꞉te ebe hoe habamo na꞉magatuya꞉ keha pihigamo ebe konepihomotema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Iba꞉te ko habane ba tolamita alaholohopa꞉te eta Sailiniya habanapi dubu Saimonoko numiti ba꞉bo nelawiya꞉ Ya꞉sukunu keha pihiga kagatamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ba꞉bene iba꞉te Gologota hakamo nikuliya꞉, ba꞉be hakoeno mahilo ipuwa ba꞉ ‘Wato Gohala.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ba꞉bolo iba꞉te helo gao beya ba꞉gala temeteme uliha꞉ kaka mulamula kapiyuilamete Ya꞉sutamo dikamiya꞉, ebete nanekela꞉mo totoma꞉namidate ba꞉ dito miya꞉puya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ba꞉ba tetelo alaholohopa꞉te ebe kehamo pihomotete ikoko ba꞉bo alukulimiya꞉, ba꞉bene iba꞉te ebeno kaliko hiya꞉hiya꞉ alabahamema꞉ nakola hegehege iya꞉hekeholo iya꞉da꞉mi komo ododiti, ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","hakalo gagahiditi ebe ba꞉bo umitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ba꞉ba tetelo iba꞉te Ya꞉sukunu wato hunu hapuamo ebeno hoe mabu hawakalimima꞉ tabo ba꞉ma ka꞉na miya꞉tiya꞉, “Ba꞉moe Ya꞉suku ba꞉ Yu tawakalubino Ko Gawadubula,” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ba꞉gala iba꞉te pilo dubu netewa Ya꞉sukuba꞉ hiya꞉hiya꞉ kehamo a꞉kapihomolateliya꞉, eta tu hapuamo, eta pele hapuamo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ba꞉bene puya꞉te ba꞉be gabodo da꞉petolamitiya꞉ iba꞉te Ya꞉suku iduduputimilo niya꞉da꞉titiya꞉, iyo, iba꞉te ibino wato wagegelatelelo ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","na꞉ga꞉lutiya꞉, “A꞉iye! Ama꞉ Godokono Genama anabulimiti netewa-kapiya hegelalo gala etema꞉ da꞉goi, ama꞉ ba꞉be lumagilata! Ama꞉ ha꞉kiya amia꞉no ka꞉ka꞉ na꞉mula꞉! Ama꞉ Godokono hibi Guduma꞉ deda꞉na, ama꞉ keha pihiga hununi na꞉pihitiga!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ba꞉ba tetelo Godotamo hawa꞉goeno ikamehopino watowatopi, ba꞉gala Godokono Tutumu iya꞉tulamepi, ba꞉gala komo koko dubu, iba꞉te Ya꞉suku atumu iya꞉da꞉telo na꞉kaga꞉lutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ya꞉suti komo tawakalubino olalati komo bemula꞉lelamenakui, huiyatiya ebe ha꞉kiya ebeno ka꞉ka꞉ mula꞉ wadiyaha꞉! Ebete Isalaela tawakalubino hibi Ko Gawadubuma꞉ deda꞉na, wadiyala ebete keha pihiga hununi hopamo na꞉pihitigana, iyo, ale ba꞉be komo umiti ebe hibima꞉ ba꞉bo komidima꞉nema꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ebete na꞉goenako, ‘Na Godoko hibima꞉ na꞉midinamo, ba꞉gala na ba꞉ ebeno Gudula,’ ba꞉bema꞉ Godote ebetamo na꞉kalakalatale, ebete ebeno ka꞉ka꞉ ba꞉mula꞉mena꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ba꞉ba tetelo eba꞉go da꞉pihomolateliya꞉, ba꞉bi pilo dubu netewapa꞉te atumu Ya꞉suku iduduputimilo kuba tabo bekaga꞉lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ba꞉bene hegelate tuli teta꞉mo dutiya꞉ hopo konomote ba꞉bo duya꞉. Ba꞉ba tetelo du komote hegeloeno alo ba mula꞉, hegelate a꞉hiwate nanekela꞉mo a꞉nihitigatepaniya꞉, hegela tuli tetene tupuimiti 3 koloko teta꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ba꞉bene Ya꞉suti Yu tawakalubino tabamo ibulunomamo na꞉goeniya꞉, “Elai, Elai, lama sabakatani?” ba꞉moe taboeno ipuwa ba꞉ma ka꞉na itana, “Naeno Godo, naeno Godo, na ama꞉le badama꞉ ka꞉miya꞉pana꞉wa?” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Komo ba꞉bolo da꞉pola꞉nuya꞉ iba꞉te ebeno tabo ulinate na꞉ga꞉laniya꞉, “Ba꞉moe dubuti Elayako beka꞉mina!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ba꞉ba tetenomolo ibi ipuwalo kapiya dubuti nipuliganate, humago kaka gao beyamo nadutinate pudamo negalapata꞉midanate Ya꞉sutamo ba꞉bo nikameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Huiyatiya komopa꞉te na꞉ga꞉laniya꞉, “Hiya꞉, a kumitotiya꞉! Elayate pete ebeno ka꞉ka꞉ da꞉pemula꞉memene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ba꞉ba tetelo Ya꞉suti ibulunomo gala kagoewatanate hoenomo ba꞉bo hoeniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ba꞉bene Godoko Adikumino Hiya꞉ Genamoeno kaliko ubiliti tulituliya bolagale hununi tupuiminate hopamo ba꞉bo pihitiganiya꞉, ba꞉gala wima꞉la꞉te da꞉peniya꞉ iya꞉ha꞉midale nakola hakate ba bola꞉la꞉halena, ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","komo tawakalubino ha꞉laha bobote ha꞉kiya ba꞉bo ka꞉kehola꞉haniya꞉. Ba꞉bema꞉ hibila, Ya꞉suti hoe ipuwane da꞉kamahiguya꞉, ba꞉be atu tetelo kebe tuputupupa꞉te dopamo da꞉ha꞉lahuya꞉ Godote komo ibi hoe ipuwane atumu ba kawadia꞉paa꞉latele, iba꞉te ibino hiya꞉hiya꞉ nakola bobo ipuwane ibino apa꞉go ba꞉bo pikuliya꞉, iyo, iba꞉te Yelusalema ko habamo nikuliti ibi ha꞉kiya ibino komokomo tawakaluba꞉tamo ba꞉bo nehawakalilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ba꞉bene alaholohopino gawadubuti ba꞉gala ebeno hopopi ipuwalo puya꞉te Ya꞉sukunu hoe komo duminiya꞉, iba꞉te wima꞉la꞉ ba꞉gala komo hanohano komo ba ulamena konomo tole komago na꞉ga꞉laniya꞉, “Hibila, ba꞉moe ba꞉ Godokono Gudula!” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ba꞉ba tetelo komo hiliyonomo kamenakamenate Ya꞉suku umima꞉ muhuluni putitataniya꞉, Ya꞉suti Ga꞉lili hopone Yelusalema ko habamo da꞉tuya꞉ ba꞉ba꞉te ebe ba ta꞉mata ebe hidonomamo owalubinatuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ba꞉bi kamenakamena ipuwalo Magadalanapi Ma꞉liko, ba꞉gala eta Ma꞉li ebeno gugudi netewa Ya꞉imesiko ba꞉gala Yausesiko, ba꞉gala Sebedikono kamena ebete ebeno gugudi netewa dalahilamiya꞉, ba꞉moi ba꞉te pola꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Gapogapo tetelo eta ilina dogodogo dubuti na꞉peniya꞉, ebeno mahilo Yausepete A꞉limitiyanapila, ebe Ya꞉suku ta꞉matadawa etala. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ba꞉ba tetelo ba꞉be dubuti Paeletetamo tonate Ya꞉sukunu ape lawenama꞉ ebe da꞉nikiyameniya꞉, Paeletete ebeno alaholohopi ba꞉bo goelameniya꞉ iba꞉te ebetamo kikamenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ba꞉bene ebete Ya꞉sukunu ape lawenate uli keyakeya kalikamo a꞉wa꞉tinate ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","bobo ipuwamo ba꞉bo nihateniya꞉, ba꞉be bobo ba꞉ uli bobola, tawakaluba꞉te iya꞉ha꞉midale nakola haka ba aligi Yausepekonoma꞉ ya꞉lo ododimiya꞉. Ba꞉ba tetelo Yausepete konomo nakola emokamidanate bobo gigiho netakuminate ba꞉ dito toniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ba꞉bene Magadalanapi Ma꞉liko ba꞉gala eta Ma꞉li, iba꞉te nakola bobo hapulu ba lumutita Yausepekono ododili komokomo ba꞉bo ulamelemeniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Eta hegela ba꞉ Yu tawakalubino okoha꞉ hegelala. Ba꞉ba tetelo komo Yu watowatopi ba꞉gala Pa꞉lisi kapiyuimipi iba꞉te Paeletetamo tolamete ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ba꞉ma ka꞉na nega꞉luya꞉, “Kodawa, ba꞉be ha꞉da amiho dubu Ya꞉suku ebete hoeheno dopamo na꞉goi, ‘Netewa-kapiya hegelalo na hoene kakamahigama꞉nemo.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","A ba꞉moe komo ba emalagidolo, a ubila ama꞉ tabo na꞉gaa꞉ alaholohopa꞉te ba꞉be nakola bobo netewa-kapiya hegelalo hidamo kolawamema꞉, mabu diyala, ebeno ta꞉matapa꞉te ebeno ape pilolo da꞉ pelawemena꞉, ba꞉bene iba꞉te ba꞉ma ka꞉na koga꞉lama꞉na꞉, ebete hoene a꞉kamahigui. Numa꞉, dopo ha꞉da amiho tabote a temeteme ikaa꞉mi, huiyatiya keba tetelo tawakaluba꞉te ba꞉moe eta ha꞉da amiho tabo hibima꞉ da꞉midimina꞉, aeno temeteme komote konomoma꞉ keda꞉ma꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paeletete iba꞉tamo na꞉goiya꞉, “Wadiyala, la꞉ bobo haba hidamo lawamema꞉ naeno komo alaholohopi nuwata꞉la꞉. Ba꞉bene la꞉ ha꞉kiya la꞉godolo hido ukui da꞉pola꞉namene, la꞉ ba꞉ba ka꞉na nododiya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ba꞉bema꞉ iba꞉te bobo habamo tolamete, bobo da꞉kalapiluya꞉ ba꞉be nakola hunamo kukala ba꞉bo nihatiya꞉ tawakaluba꞉te ologikapoma꞉, ba꞉bene iba꞉te bobo lawamema꞉ alaholohopi ba꞉bo miya꞉paliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ba꞉bene Yu tawakalubino okoha꞉ talona hegela da꞉wibuya꞉, Sande hegelate ba owalohuta, Ma꞉li Magadalanapi ba꞉gala eta Ma꞉li, iba꞉te komo kamenakamenago nakola bobo umima꞉ ba꞉bo tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Huiyatiya iba꞉te bobo habamo nuluhukuhino, dopamo konomo wima꞉la꞉te piya꞉, ba꞉bene Kodawa Godokono nopodawate Hunu Habane pihitigate, bobo da꞉takuminiya꞉ ba꞉be ko nakola tama꞉mo penemokamidate ba꞉be nakola hunulu lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ebeno holoholo hegelate da꞉la꞉wa꞉hiya keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala, ba꞉gala ebeno pupulino ilinate keyakeyahibinomoma꞉ ba eda꞉hame ba꞉bo a꞉la꞉minahalemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ba꞉be mabuma꞉ bobo haba lawamepi dubate toletoleholo ba lililahale hakamo guditi ha꞉lahapimo toda꞉la꞉mota꞉hanuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Godokono nopodawate huiyatiya kamenakamenatamo na꞉goiya꞉, “La꞉ akatoletolehala꞉! Na iya꞉tawala, la꞉le Ya꞉suku tawakaluba꞉te ebe keha pihigamo da꞉pihomoti, ebe bohowaditamata. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ebe malo puliyala mabu ebe a꞉mahigaka, ebete dopamo da꞉goi ba꞉ba ka꞉na! La꞉ pelamete ebete da꞉kapitanui ba꞉be haba na꞉puma꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ba꞉bene la꞉le ebeno ta꞉matapi tiyonomolo na꞉nikiyalama꞉la꞉, ‘Ya꞉suti hoe ipuwane a꞉mahigaka. La꞉ nulia꞉la꞉, ebete Ga꞉lili hopamo dopamo kotoma꞉ne, la꞉ tolamete ebe ba꞉bo konumima꞉nemata. Hibila, na Godokono nopodawate ba꞉moe komoma꞉ la꞉ dopamo kiyalamemata.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ba꞉bema꞉ iba꞉te bobo haba tiyolo miya꞉pate, ko tole komo ba꞉gala kalakala komote ibi ba uwate, iba꞉te ba꞉ba ka꞉na pulila꞉huya꞉ Ya꞉sukunu ta꞉matapi konikiyalamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Iba꞉te ba tolame ba꞉ba tetenomolo Ya꞉suti iba꞉go alugate iba꞉tamo na꞉goiya꞉, “Nonolata!” ba꞉bene iba꞉te ebeno dopo hapulu hakamo neguditi ebeno nato ba na꞉ga꞉da꞉midaleme ebe ba꞉bo nadikumiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ akatoletolehala꞉. La꞉ tolamete, na da꞉ta꞉mahenena ba꞉bi naeno ekaki na꞉nikiyalama꞉la꞉ iba꞉te Ga꞉lili hopamo na꞉tolama꞉mena꞉. Iba꞉te na ba꞉bo konunamema꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ba꞉bene kamenakamenate Ya꞉sugodone ba tolamita, nakola bobo lawamepi alaholohopa꞉te ko habamo tolamete Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉bo nikiyalamiya꞉, bobo habalo dikuliya꞉ ba꞉bi hiliyonomo komokomo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ba꞉bene ba꞉bi watowatopa꞉te komo Yunapino koko dubago kapiyuimiti tabo ba꞉bo ihatiya꞉ alaholohopa꞉tamo koko mani kikalameholema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Iba꞉te ba ikalamehole na꞉ga꞉luya꞉, “La꞉ tawakalubi ha꞉da amiholamelo tabo ba꞉ma ka꞉na na꞉nega꞉luya꞉la꞉, ‘Du tetelo ale ba lahana Ya꞉suku ta꞉matapa꞉te pelamenate ebeno ape pilolo ba꞉bo pelawa꞉diganiya꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ba꞉gala la꞉ aka-ukuibilibilihala꞉, mabu kapela Ko Gawadubu Paeleteko ba꞉moe u laha tabo dulimini, ale ebe konegelebadimima꞉nema꞉ ebete la꞉tamo kuba huiya ikalamekapoma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ba꞉bene alaholohopa꞉te ba꞉bi mani uwatete, Yu watowatopa꞉te keba ka꞉na ka꞉ga꞉luya꞉ iba꞉te ba꞉ ba꞉ba ka꞉na ododiya꞉, ba꞉be mabuma꞉ ba꞉be ha꞉da tabote Yu tawakalubino hiya꞉hiya꞉ habahabamo tuya꞉, ka꞉lo ba꞉be tabote iba꞉godolo bitana, kekelanaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ba꞉bene Ya꞉sukunu 11 ta꞉matapa꞉te Ga꞉lili hopamo dito tolamiya꞉, Ya꞉suti ibi dopamo da꞉kiyalamiya꞉ ba꞉be hununomo hakamo. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iba꞉te ebe numiti ebe ba꞉bo nadikumiya꞉, huiyatiya ba꞉bolo da꞉pola꞉nuya꞉ komo iba꞉te ukui bilibilima꞉ ba eda꞉huta hibima꞉ kamiditiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ba꞉bene Ya꞉suti iba꞉tamo pete ibi ba꞉ma ka꞉na pikiyalamiya꞉, “Godote ya꞉lo tetelo helo konomo natamo ikanamiya꞉, ebeno Hunu Habalo ba꞉gala hopo konomolo ebeno hiliyonomo ubi komokomo kododilinama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ba꞉bema꞉ la꞉ hopo haboeno hiya꞉hiya꞉ tawakalubi hiliyonomatamo tolamete ibi na ta꞉mahenepima꞉ na꞉nimidiliya꞉la꞉. Ba꞉ma ka꞉na la꞉le ibi Nabiwi Godokono mahilamo, ba꞉gala ebeno Guduino mahilamo, ba꞉gala ebeno Talona Gobogoboeno mahilamo beyamo na꞉newadulateliya꞉la꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ba꞉gala nale la꞉ diya꞉tulamima, ba꞉bi hiliyonomo komokomo la꞉le ibi na꞉niya꞉tulamiya꞉la꞉ iba꞉te naeno tabamo kopapamila꞉halema꞉. Mu numitota꞉la꞉! Na emedena tetelo la꞉go bemedenamo, ba꞉moe hopoeno kuititi tete da꞉nuluhukumini ba꞉ba teta꞉mo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ya꞉su Kelisoko ba꞉ Godokono Oemedawala ba꞉gala ebeno Gudula, ba꞉bene Ya꞉sukunu Hido Tabo da꞉tupuimiya꞉ ba꞉moe ba꞉be mabula. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ba꞉ hibila, Godote dopamo ebeno ukui hawakalimidawa Aisayako ipuwado Kelisokono pe komoma꞉ ebeno Bukamo tabo ba꞉ma ka꞉na miya꞉tiya꞉, “Nale Kelisokono dopo hapuamo naeno tabo atadawa kopoemema꞉nemo, ebete ebeno gabo kopihiduimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Iyo, lumagiti dito hopolo tabo ba꞉ma ka꞉na ibulu kopegoema꞉ne, ‘Kodawoeno gabo na꞉hiduima꞉la꞉, ebeno gabo na꞉tuputupuima꞉la꞉!’” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ba꞉be mabuma꞉ Yonete a꞉puluhukuya꞉. Ebete tawakalubi dito hopolo beyamo ba pewadulatele Godokono tabo ba꞉ma ka꞉na polamagiya꞉, “La꞉eno kubane ohobila꞉te beyamo aduti komo lawema꞉ na꞉pelama꞉la꞉, ba꞉bene Godote la꞉eno kuba egebolelamete kadodoholelamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ba꞉bema꞉ tawakalubi hiliyonomate Yudiya hopone ba꞉gala Yelusalema ko habane tolamiya꞉ Yonekono tabo ulihoma꞉, ba꞉bene iba꞉te ibino kuba da꞉nehawakalilameholiya꞉, Yonete ibi Yodane Tulilo beyamo ba꞉bo wadulateliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ba꞉ba tetelo Yonekono emede komo komopino emede komo huiyaha꞉, mabu ebete ka꞉molo-goe ipo kuba kaliko kau-goe tama kamaka꞉go pulinakui, ba꞉gala ebeno baa꞉ wawaka ba꞉gala molo benahanakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yonete Godokono tabo ba polamagi na꞉goiya꞉, “Eta lumagiti naeno gala hapuni ba꞉pena. Ebeno helo konomote naeno helo na꞉gogolona, ba꞉bema꞉ na hidoenoha꞉ nale hopamo tudiwatate ebeno nato ukulalemema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nale la꞉ beyamo wadulatelemata, huiyatiya ebete Godokono Gobogobamo la꞉ kopewadulatelema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ba꞉ba tetelo Ya꞉suku Ga꞉lili hopoeno Nasalete habane pete, Yonete Yodane Tulilo ebe beyamo ba꞉bo adutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ya꞉suti beyane ba podolo ba꞉ba tetenomolo Godote ebeno Hunu Haba a꞉hiya꞉midutalo ba꞉bo umiya꞉, ba꞉bene ebete Godokono Gobogobo bumiya꞉ ebetamo gimai holamo da꞉pihitigutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ba꞉bene tabote Hunu Habane ba꞉ma ka꞉na pihitiguya꞉, “Ama꞉ naeno kapiya Gudunomolata. Na ama꞉tamo na꞉kalakalutamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ba꞉ba tetenomolo Godokono Gobogobote Ya꞉suku dito hopamo na꞉magatuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ba꞉bene ebete dito hopolo 40 hegela ba nemede, Saitanate kuba gabamo kemogabuimima꞉ ebetamo ba꞉bo uluhukuya꞉. Ba꞉bolo hiya꞉hiya꞉ helohelo ilinate na꞉pola꞉nuya꞉, huiyatiya Godokono nopopa꞉te ebe na꞉buiya꞉minutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ba꞉bene gabomana꞉te Yoneko du genamamo dihatiya꞉, ba꞉ba tetelo Ya꞉suti Ga꞉lili hopamo Godokono Hido Tabo olamaga꞉go ba꞉bo piya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ebete na꞉pegoiya꞉, “Hido tete ba꞉ a꞉pe. Godokono Ko Gawadubuma꞉ eda꞉ tete tatalila, ba꞉bema꞉ la꞉eno kubane ohobila꞉te Hido Tabo hibima꞉ na꞉mida꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ba꞉bene Ya꞉suku Ga꞉lili Bobo dododo ba tonato, ebete daha uwateholepi netewapi ba꞉bo nulamiya꞉, Saimonoko ba꞉gala ebeno ekawi A꞉nduluku iba꞉te daha kamahamo na꞉hutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ na na꞉ta꞉mahena꞉la꞉, ba꞉bene nale la꞉ tawakalubi uwatepima꞉ komidilima꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ba꞉ba tetenomolo iba꞉te ibino kamahu miya꞉palete Ya꞉suku ba꞉bo ta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ba꞉bene Ya꞉suti nanekela꞉mo gala katote Sebedikono gudu Ya꞉imesiko ba꞉gala ebeno ekawi Yoneko ba꞉bo kanulamiya꞉, iba꞉te ibino bogelo emedehote kamahu bihiduilamitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ya꞉suti ibi da꞉ka꞉lamiya꞉, ba꞉ba tetenomolo iba꞉te ibino nabiwi Sebediko miya꞉pate Ya꞉suku ba꞉bo ta꞉matuya꞉, huiyatiya ibino nabiwino mani oko dowatihonama꞉ ba꞉bi komo dubate eba꞉go bogelo pola꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ba꞉ba tetelo Ya꞉suti ebe ta꞉matapa꞉go Kapeniyama habamo tolamiya꞉. Ba꞉bene Yu tawakalubino okoha꞉ talona hegelalo ebete ibino baidi ibubulamehole genamamo tote ibi da꞉niya꞉tulamitiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","iba꞉te ebeno tabamo na꞉hanohanohutiya꞉, mabu ebete Godokono heloamo iya꞉tulamitiya꞉ huiyatiya ebe ibino Godokono Tutumu iya꞉tulamepi huiyaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ba꞉be atu tetelo kuba gobogobagoeno dubuti ibino baidi ibubulamehole genama gulu na꞉lutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ba꞉bene ebete gaa꞉tepahalo na꞉goiya꞉, “Ya꞉su Nasaletenapi, ama꞉ atamo bada komo na꞉kododiomena꞉? Ama꞉ a kubahia꞉mema꞉ ka꞉pa꞉wa? A꞉iye, na iya꞉tawala amia꞉no komo, ama꞉ ba꞉ Godokono Hido-talona Dawalata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ya꞉suti huiyatiya ebe na꞉kiyahamiya꞉, “Ama꞉ kodakodate, ebegodone nuluhuka!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ba꞉bene kuba gobogobote gaa꞉tepahago ba꞉gala ewagelehago dubuino apene duluhukuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","tawakaluba꞉te ba꞉be komoma꞉ na꞉hanohanohutiya꞉. Etate eta goemenakui, etate eta goemenakui, “Moe badala꞉ka꞉? Moe eta hiya꞉ uli iya꞉tulame komola꞉ka꞉? Ba꞉moe dubuino helo konomola! Numa꞉la꞉, kubakuba gobogobate ebeno tabamo a꞉papamila꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ba꞉bema꞉ hibila, ba꞉be atu hegelalo Ya꞉sukunu oko owati tabote ba꞉be Ga꞉lili hopo konomamo ba꞉ dito tuya꞉, iyo, puya꞉te ba꞉bolo demedehonama꞉ ibi hiliyonomate ebeno komoma꞉ tabo ba꞉bo nikiyahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ba꞉bene Ya꞉imesiko Yoneko iba꞉te Ya꞉sukuba꞉ Yu tawakalubino baidi ibubulamehole genamane pikuliti, Saimonoko A꞉nduluku ibi netewapino genamamo tolamenomo tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ba꞉bolo Saimonokono moto kakidubu ape koe tawetawa꞉go watitiya꞉, ba꞉bene tawakaluba꞉te ba꞉moe kamenoeno komoma꞉ Ya꞉suku ba꞉bo ga꞉lamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ba꞉bema꞉ Ya꞉suti ebetamo pete ebe kokotamo da꞉padipatiya꞉ ebeno tawetawete na꞉wibuya꞉, ba꞉bene ba꞉be kamenate mahigate ibi mabuma꞉ baa꞉ okalimi oko ba꞉bo tupuimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ba gapogapohona hegelate da꞉nihila꞉minaniya꞉, habaluba꞉te hiliyonomo temetema꞉gopi ba꞉gala kuba gobogobagopi Ya꞉sutamo ba꞉bo magaheleniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ba꞉bene komo ibi hiliyonomate genama gigiho dopo hapulu pepola꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ba꞉ba tetelo Ya꞉suti ibi ipuwalo komo hiya꞉hiya꞉ temetema꞉gopi hiliyonomo hiduilamenate, ba꞉gala hiliyonomo kuba gobogobo komopa꞉godone ba꞉bo oelameniya꞉. Ba꞉bi kuba gobogobo iya꞉tawahala Ya꞉suku ba꞉ Godogodone piya꞉, ba꞉bema꞉ iba꞉te ebeno komo kohawakalimima꞉ ebete tabo ga꞉la talona bihatelameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ba꞉be du tetenomolo owaloho hapuamo Ya꞉suti ebeno u wata bahini mahiganate, ebe ha꞉kiya tataba hopamo tonate Godokoba꞉ tabo ba꞉bo nega꞉laniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ba꞉bene duiduiyalo Saimonoko ba꞉gala ebeno mabulubi iba꞉te Ya꞉suku ohowadima꞉ da꞉tolamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","iba꞉te ebe numiti na꞉nega꞉lamiya꞉, “Hiliyonomo tawakaluba꞉te ama꞉ bohowaditata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ba꞉bema꞉ Ya꞉suti iba꞉tamo na꞉goiya꞉, “Kubaha꞉, a kotolamiya꞉. Nale komo habahabalo Godokono tabo konolamagima꞉nemo, mabu na ba꞉bema꞉ piya꞉mo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ba꞉ba tetelo ebete Ga꞉lili hopoeno hiliyonomo habahabamo tonakui, ba꞉bene ebete Yu tawakalubino baidi ibubulamehole genama gulu Godokono tabo olamaginakui ba꞉gala ebete kuba gobogobo tawakaluba꞉godone akoelamenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ba꞉bene kuitikuita꞉goeno dubuti Ya꞉sutamo pete ebeno pupamo pemedete ebetamo koamo ba petoetoe na꞉pegoiya꞉, “Amia꞉no ubi ditama꞉na, ama꞉le na kohiduinamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ya꞉suti ebe koamo malemaletelo ebeno kokoto hogaminate ebe ologilo na꞉goemiya꞉, “Na ubila, ama꞉ na꞉hida!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ba꞉bema꞉ ba꞉ba tetenomolo kuitikuiti temetemete ebegodone wibote ebe ba꞉bo hiduya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ba꞉bene Ya꞉suti ebe ba oeme koamo ba꞉ma ka꞉na kiyahamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ama꞉ naeno komoma꞉ tawakalubi akanikiyalama꞉la꞉. Wadiyala ama꞉ huiyatiya ba꞉moe tetenomolo tote amia꞉no ape Godotamo hawa꞉goeno ikamehodawatamo na꞉nemutuimiya꞉, ba꞉bene hawa꞉goeno malemale ilina Godotamo akona꞉nikamiya꞉, Mosesete dolamagiya꞉ ba꞉ba ka꞉na. Ba꞉be komote tawakalubi kiya꞉tulamema꞉ne amia꞉no temetemete a꞉wibui.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Huiyatiya ba꞉be dubuti ba to tawakalubi hiliyonomo na꞉kiyahalamenatuya꞉, ba꞉bema꞉ Ya꞉suti komo habahabamo hawakala toma꞉ kamodobuya꞉ha꞉. Ba꞉ba tetene tupuimiti ebete huiyatiya dito hopolo emedenami, ba꞉bene hapuhapuni tawakaluba꞉te ebetamo pelamenakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ba꞉bene komo hegela da꞉wibohuya꞉ Ya꞉suti Kapeniyama habamo gala na꞉kapiya꞉. Ebete ebeno genamalo da꞉lutiya꞉ tawakaluba꞉te ulihuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ba꞉bema꞉ komo ibi hiliyonomate da꞉pelamiya꞉, genama gulu ba꞉gala gigiho dopo hapulu eta habate kitanuya꞉ha꞉. Ba꞉ba tetelo Ya꞉suti Godokono tabo iba꞉tamo ba olamagita, ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","netewa-netewa dubate ape kodakoda temetema꞉goeno dubu ebetamo ba꞉bo agatuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mabu tawakalubi hiliyonomate ba꞉bolo na꞉pola꞉nuya꞉, ba꞉bi dubate Ya꞉suku tama꞉mo tolamema꞉ gabohenola. Ba꞉bema꞉ iba꞉te genama hunamo nalehawaminate, Ya꞉suti kebo ka꞉la꞉nuya꞉ iba꞉te ba꞉be genamoeno hunu a꞉himiti temetema꞉goeno dubu tilago Ya꞉sutamo ba꞉bana nadutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ya꞉suti ibino hibima꞉ midi komo umilamete temetema꞉goeno dubutamo na꞉goiya꞉, “Naeno mabulubi, Godote amia꞉no kuba egebolemete adodoholema꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Huiyatiya komo Godokono Tutumu iya꞉tulamepi ba꞉bo da꞉pola꞉nuya꞉, iba꞉te ba꞉be tabo uliti ibino tepo ipuwalo ba꞉ma ka꞉na emalagidolutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ba꞉moe dubu awagalo kuba tabo badama꞉ ka꞉goe Godokono holoholo hapulu? Kuba egeboledawa potela꞉ka꞉? Ba꞉ Godoko kapiyala!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ba꞉ba tetenomolo Ya꞉suti iya꞉tawuya꞉ iba꞉te bada komoma꞉ ukui da꞉miya꞉titiya꞉, ba꞉bema꞉ ebete iba꞉tamo na꞉goiya꞉, “Mabu keka꞉ la꞉eno tepo ipuwalo ba꞉moi komo demalagidolitama? ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ba꞉moe tabo kodakodala꞉ka꞉ nale ba꞉moe temetema꞉goeno dubutamo goema꞉, ‘Godote amia꞉no kuba egebolemete adodoholema꞉ta?’ O ba꞉moe eta tabo goema꞉ kodakodala꞉ka꞉, ‘Mahigate, amia꞉no tilo lawete na꞉toa?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ba꞉bema꞉ nale la꞉ kiya꞉tulamema꞉nemata, na Tawakalubino Naniwigodolo helo bitana ba꞉moe hopolo tawakalubino kuba egebolelamete kadodoholelamema꞉.” Ba꞉bene ebete ape kodakoda temetema꞉goeno dubutamo na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nale ama꞉ begoememata, na꞉mahiga! Amia꞉no tilo mokopa꞉midate genamamo na꞉toa.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ba꞉ba tetelo ibi hiliyonomate ebe ba umita, ba꞉be dubuti mahigate ebeno tilo lawete tiyonomolo ba꞉bo tuya꞉, ba꞉bema꞉ iba꞉te hibinomolo hanohanoholo na꞉ga꞉luya꞉, “Godoko hunamo nadipata꞉la꞉. A dopamo ba꞉mako komo kuminakuiha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ba꞉ba tetelo Ya꞉suti Ga꞉lili dodamo gala na꞉katuya꞉, ba꞉bene tawakalubi hiliyonomate ebetamo da꞉pelamiya꞉, ebete ibi ba꞉bo iya꞉tulamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ba꞉bene ebete ba petonato A꞉lapiyasikono gudu Libaiko ba꞉bo numiya꞉, ebe ta꞉kese uwatedawala, ebete ebeno oko habalo lutiya꞉. Ba꞉ba tetelo Ya꞉suti ebetamo na꞉goiya꞉, “Na na꞉ta꞉mahena꞉,” ba꞉bene ebete mahigate Ya꞉suku na꞉ta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ba꞉bene tete nanekele da꞉petuya꞉ Ya꞉suti ebe ta꞉matapa꞉go Libaikono genamalo ahiditi baa꞉ ba nahuta, komo ta꞉kese uwatepi ba꞉gala Godokono Tutumu uwateha꞉pi iba꞉go na꞉pola꞉nuya꞉, mabu hibila, ba꞉makomako tawakalubi hiliyonomate Ya꞉suku beta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Babema꞉ komo Pa꞉lisi kapiyuimipino tutumu iya꞉tulamepi iba꞉te ba꞉be komo dumiya꞉, iba꞉te Ya꞉suku ta꞉matapa꞉tamo na꞉ga꞉luya꞉, “Ebete ta꞉kese mani ha꞉da amiholo uwatepi ba꞉gala Godokono Tutumu uwateha꞉pa꞉go baa꞉ badama꞉ ka꞉nanako?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ya꞉suti ba꞉be tabo uliti iba꞉tamo na꞉goiya꞉, “Hidohido tawakaluba꞉te dogetatamo a꞉katolama꞉mena꞉, huiyatiya tawetawa꞉gopa꞉te kotolamema꞉na꞉. Iyo, puya꞉te ha꞉kiya da꞉ga꞉lana, ‘A hidohido tawakalubila,’ na ba꞉bakobako tawakalubi uwatema꞉ kapiya꞉ha꞉. Na huiyatiya kubakuba tawakalubi kapiya uwatema꞉ piya꞉mo, iba꞉te na kota꞉mahenema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Eta tetelo Yoneko ta꞉matapi ba꞉gala Pa꞉lisi kapiyuimi watowatopino ta꞉matalepi iba꞉te baa꞉ nahaheno pola꞉nuya꞉. Ba꞉bene komo tawakaluba꞉te Ya꞉sutamo pelamete ebe na꞉palatediya꞉, “Keka꞉ mabu Yoneko ta꞉matapi ba꞉gala Pa꞉lisi kapiyuimipi iba꞉te hiya꞉hiya꞉ tetelo baa꞉ nahaheno da꞉pola꞉nanaka Godokono oko owatima꞉, huiyatiya ama꞉ ta꞉matapa꞉te baa꞉ nahaheno a꞉kapola꞉nala꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Dubuti kamena da꞉lawemene, ba꞉ba tetelo ebeno mabuluba꞉te poko habalo baa꞉heno dito ba꞉ka꞉pola꞉namena꞉? Ao, wadiyaha꞉! Ebete iba꞉go ba pola꞉na poko baa꞉ kapimilo konahama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Huiyatiya kamena uli lawe dubuti ebeno kamena eta habamo magata tete ba꞉ na꞉pe, hibila, ba꞉be hegelalo ebeno mabuluba꞉te ibino tepo temeteme komoma꞉ baa꞉ nahaheno kopola꞉nama꞉na꞉. Ba꞉bema꞉ numa꞉la꞉, ka꞉lo ba꞉ la꞉eno kalakalago baa꞉ naha tetela mabu nale la꞉go bemedenamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ba꞉bene Ya꞉suti tabo moga꞉melo gala na꞉kagoiya꞉, “Lumagiti uli kaliko hapu pakala kalikoeno bolagala꞉mo a꞉kakohomehamene. Ebete ba꞉ma ka꞉na dododimini, uli kaliko haputi pakala kaliko kanagiya꞉midalema꞉ne, ba꞉bene bolagalete konomoma꞉ keda꞉ma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Atu gabodo lumagiti pakala gautu-goe tama kalila꞉mo uli gao beya a꞉kahaminamene, mabu uli gao beyate pakala tama kalili ka꞉na꞉ta꞉pumima꞉ne, ba꞉bene gao beyate hakamo ka꞉ka꞉la꞉te gao beya ba꞉gala kalili ibi netewate kapiya tetelo kokubakubahama꞉na꞉. Ba꞉moe mabuma꞉ iya꞉tawadawate uli gao beya uliuli tama kalili kapiyamo ba꞉haminahanakomene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yu tawakalubino eta okoha꞉ talona hegelalo Ya꞉suti ebe ta꞉matapa꞉go kona pali ipuwado ba petolamenato, ebe ta꞉matapa꞉te kona konahama꞉ kapiyakapiya kubakubadopo ba꞉bo newakalamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ba꞉bene komo Pa꞉lisi kapiyuimipa꞉te Ya꞉sutamo na꞉ga꞉luya꞉, “Numa꞉, ama꞉ ta꞉matapa꞉te okoha꞉ talona hegela badama꞉ kadikanalita?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Wadiyala Godote ebeno Bukamo da꞉miya꞉tiya꞉, la꞉ ba꞉be komo nemalagidolala꞉. Da꞉ibiditamo kuba tete da꞉piya꞉, ebete ebeno wapata꞉lamepa꞉go baa꞉ma꞉ da꞉kapemitiya꞉, ba꞉bene ebete bada komo kododiya꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ebete Godokono Genamamo nodolote, ba꞉be Genamoeno okopa꞉te Godotamo da꞉miya꞉tenakui ba꞉be talona baa꞉ ebete a꞉nenahuya꞉. Numa꞉la꞉, aeno tutumu tabote a biya꞉tua꞉mena Godotamo hawa꞉goeno ikamehopa꞉te ba꞉be baa꞉ ha꞉kiya nahanaka, komo tawakaluba꞉te naha talonala. Huiyatiya Da꞉ibiditi ba꞉be baa꞉ nahate eba꞉go wapata꞉lamepa꞉tamo dikalameholiya꞉, Godote ba꞉be komo kubama꞉ kagoiya꞉ha꞉. Ba꞉ hibila, ba꞉moe komote Abayatakono tetelo uluhukuya꞉, ebe Godotamo hawa꞉goeno ikamehopino Hununomo Watodawala.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Numa꞉la꞉, Godote okoha꞉ talona hegela tawakalubi owalubilima꞉ ba ododi, ebete ubi kihatiya꞉ha꞉ okoha꞉ talona hegelamo ibino emede komo kokodakoduilamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ba꞉bema꞉ hibila, na Tawakalubino Naniwiti okoha꞉ talona hegela namutudawama꞉ eda꞉namo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Eta tetelo Yu tawakalubino baidi ibubulamehole genamamo Ya꞉suti gala da꞉kanodoluya꞉, kokoto hapu hoeme dubuti ba꞉bolo na꞉lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ba꞉bene ba꞉be haboeno Pa꞉lisi kapiyuimipa꞉te Ya꞉suku baidi kodakodalo umitiya꞉, ebete okoha꞉ talona hegelalo ba꞉be lumagi hiduimilo iba꞉te ebe kubadawama꞉ koga꞉lama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ba꞉ba tetelo Ya꞉suti kokoto hapu hoeme dubutamo na꞉goiya꞉, “Ama꞉ mahigate, mamo na꞉pa꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ba꞉bene Ya꞉suti ba꞉be napa꞉tamo na꞉goiya꞉, “Aeno tutumu tabote kebe talona komo kiya꞉tua꞉mena? Ale okoha꞉ hegelalo hido komo o kuba komo ba꞉kododima꞉? Tawakalubi ba꞉ka꞉hiduilamema꞉ o ba꞉ka꞉kubahilamema꞉?” Iba꞉te huiya tabo kaga꞉luya꞉ha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ba꞉bema꞉ Ya꞉suti maubate ibino wato kodakoda komo umilamete, ba꞉be mabuma꞉ ibi tepo menemena꞉go ba ulamehole ba꞉be dubutamo na꞉goiya꞉, “Amia꞉no kokoto na꞉hogamina,” ba꞉bene ebete kokoto da꞉hogaminuya꞉ ebeno kokotote ba꞉bo hiduya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ba꞉be mabuma꞉ Pa꞉lisi kapiyuimipa꞉te maubahago tolamete, ba꞉ba tetenomolo iba꞉te Ko Gawadubu Helodikono kapiyuimipa꞉go tabo ba꞉bo nega꞉luya꞉ Ya꞉suku anakapumima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ba꞉ba tetelo Ya꞉suti ebe ta꞉matapa꞉go Ga꞉lili Bobamo gala na꞉katuya꞉, ba꞉bene Yu tawakalubi hiliyonomate ba꞉be komo uliti iba꞉te Ga꞉lili hopone, Yudiya hopone, ba꞉gala Yelusalema ko habane pelameholete ebe ba꞉bo ta꞉matuya꞉. Ba꞉gala komo tawakalubi hiliyonomate hiya꞉hiya꞉ muhulu hopone atumu a꞉kapelameholiya꞉, ba꞉ba꞉te Idumiya hopone, Yodane Tuli hapuni, Taya ko habane, ba꞉gala Saidono ko habane pelameholiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ba꞉bene ibi ipuwalo Ya꞉suti temetema꞉gopi hiliyonomo da꞉hiduilamiya꞉, komo temetema꞉gopi hiliyonomate ba꞉be komo ba iya꞉tawaha ebe ologihoma꞉ emokatihuilo da꞉pelamiya꞉, ba꞉be mabuma꞉ Ya꞉suti ebe ta꞉matapi na꞉goelamiya꞉ iba꞉te boge kadahemema꞉, ba꞉bi tawakaluba꞉te ibino emokatihui komamo ebe kubahimikapoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ba꞉ba tetelo kuba gobogobagopa꞉te Ya꞉suku duminakui, iba꞉te ebeno nato mabamo da꞉pegudinakui ga꞉ga꞉lo na꞉ga꞉lanakuya꞉, “Ama꞉ ba꞉ Godokono Gudulata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","huiyatiya Ya꞉suti ibi koamo kiyahalamenakui, mabu ebe ubihinola iba꞉te ebeno komo hawakalimi. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ba꞉ba tetelo Ya꞉suti eta haka hunamo da꞉nodoluya꞉, ebete ebeno ubi tawakalubi ebetamo peka꞉lamiti, iba꞉te ebetamo ba꞉bo tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ba꞉bene ebete ibi ipuwalo 12 dubu uwatete iba꞉tamo na꞉goiya꞉, “La꞉ ba꞉ naeno oelamepilata. Nale la꞉ buwatemata la꞉le nago kemedenama꞉, ba꞉bema꞉ nale la꞉ Godokono tabo olamagimima꞉ koelamema꞉nemata, ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ba꞉gala na la꞉tamo helo kikalamema꞉nemata la꞉le kuba gobogobo tawakaluba꞉godone konoelamema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ya꞉suti 12 dubu duwatiya꞉, ba꞉moi ba꞉ ibino mahilola. Saimonoko, Ya꞉suti ebetamo eta Pita mahilo bikamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedikono gudu Ya꞉imesiko ba꞉gala ebeno ekawi Yoneko, Ya꞉suti ibi netewapa꞉tamo Bowanagese mahilo bikalamiya꞉, ba꞉be mahiloeno ipuwa ba꞉ ‘Alomo Ga꞉lawata Dubula.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","A꞉nduluku ba꞉gala Pilipiko, Batolomuku ba꞉gala Ma꞉tiyuku, Tomasiko ba꞉gala A꞉lapiyasikono gudu Ya꞉imesiko. Ta꞉diyasiko ba꞉gala Saimonoko, ba꞉moe eta Saimono ebe ubila kapela Loma gabomani tawakaluba꞉go ba alaholo iba꞉te ebeno Ka꞉inane hopo ba꞉bo komiya꞉pama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ba꞉gala Ya꞉suti Keliyotanapi Yudasiko atumu a꞉kalawiya꞉, ba꞉moe dubu ba꞉ galane tetelo Ya꞉suku anakapumipi dowalubiliya꞉ ba꞉be dawala. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ba꞉bene Ya꞉suti genamamo da꞉tuya꞉ tawakalubi hiliyonomate ebetamo pelamete gala eba꞉go da꞉kapekapiyuya꞉, ba꞉bema꞉ Ya꞉suku ba꞉gala ebe ta꞉matapi baa꞉ nahama꞉ kamodobuya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ba꞉ba tetelo ebeno ekaka꞉te ba꞉be komo uliti ebe adabuima꞉ ba꞉bo tolamiya꞉, mabu tawakaluba꞉te iba꞉tamo ba꞉ma ka꞉na ga꞉luya꞉, “Ebe daedaela.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ba꞉bene Godokono Tutumu iya꞉tulamepi Yelusalema ko habane da꞉pelamiya꞉, ba꞉bi dubate na꞉pega꞉luya꞉, “Biyesibuluku ebegodolo bemedena, iyo, ebete kubakuba gobogoboeno Kodawoeno heloamo oelamenako, Godokono heloamoha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ba꞉bene Ya꞉suti tawakalubi ebetamo ka꞉lamiti komo uwi ba iya꞉tulame na꞉goiya꞉, “Saitanate ebeno kubakuba gobogobo lumagigodone ba꞉koelamemene? Ao, a꞉koelama꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Numa꞉la꞉, haba kapiya tawakaluba꞉te tetedo dadikanalemena꞉ ba꞉be habate kokubama꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ba꞉gala genama kapiya tawakaluba꞉te tetedo dadikanalemena꞉ ba꞉be genamanapa꞉te a꞉kemedenamena꞉, ibino genamate ba꞉ atumu kakakubama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ba꞉bema꞉ Saitanakono ukui ba꞉ma ka꞉nala, ebete ebeno kubakuba gobogobo tawakaluba꞉godone a꞉koelama꞉le, mabu keba tetelo ebete ba꞉ba ka꞉na dewagelemene ebeno oko owati helote kowiboma꞉ne, iyo, ebeno kuititi bitana. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Numa꞉la꞉, Saitanako ba꞉ eta helo dubu keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala, ba꞉gala ebete pilolo duwatiya꞉ ba꞉bi tawakalubi ba꞉ ebeno genamoeno ilinala. Ba꞉bema꞉ tawakaluba꞉te ba꞉mako helo dubuino genamamo ogomote ebeno ilina uwatemema꞉ ubi dihatemena꞉, iba꞉te dopamo ebe hala꞉mo matuhumihote, ba꞉bene ebeno ilina ba꞉bo kuwatemema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Na la꞉tamo hibi tabo begoemo, tawakalubino hiya꞉hiya꞉ hiliyonomo kuba komo Godote egebolelamete adodohole iya꞉tawala, ba꞉gala tawakaluba꞉te Godoko ubiha꞉ma꞉ da꞉ga꞉lamena꞉, ba꞉bi kuba tabo komokomo Godote egebolelamete kadodoholelamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Huiyatiya kebe lumagiti Godokono Gobogoboeno ododi komoma꞉ kubama꞉ da꞉goemene, Godote ba꞉be lumagino kuba egebolemete a꞉kadodomenamene, ebete emedena tetelo ebe kubadawama꞉ ba꞉goenakomene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ba꞉ hibila, ba꞉moe komo Ya꞉suti goiya꞉ mabu ba꞉bi tawakaluba꞉te ebeno komoma꞉ ba꞉ma ka꞉na ga꞉luya꞉, “Ebe kuba gobogobagoenola.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ba꞉bene Ya꞉sukunu menoko ba꞉gala ebeno ekaki iba꞉te ebe umima꞉ da꞉pelamiya꞉, iba꞉te genama tamelo ba pela꞉mota꞉hana, ebete iba꞉tamo pema꞉ tabo ba꞉bo noemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ba꞉ba tetelo tawakalubi hiliyonomate Ya꞉suku tamelo na꞉pola꞉nuya꞉, ba꞉bene iba꞉te ebetamo na꞉ga꞉luya꞉, “Numa꞉, amia꞉no menoko ba꞉gala ekaki iba꞉te genama tamelo ba꞉pepola꞉na. Ibi ubila ama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ya꞉suti iba꞉tamo na꞉huiyuya꞉, “Naeno menoko potela꞉ka꞉, ba꞉gala naeno ekaki puya꞉tela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ba꞉bene ebete tawakalubi ebe tamelo da꞉pola꞉nuya꞉ ulamete na꞉goiya꞉, “Ba꞉moi ba꞉ naeno menokobila ba꞉gala naeno ekakila. ");
INSERT INTO knv_aramia_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pote Godokono ubi komo dododimini, ba꞉be lumagi naeno menokola ba꞉gala naeno ekawila.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Eta tetelo Ya꞉suti Ga꞉lili Bobo dodolo tawakalubi biya꞉tulamitiya꞉, ba꞉bene tawakalubi hiliyonomate ebetamo da꞉pelamiya꞉, ba꞉bema꞉ ebete boga꞉mo ololote boge dodone nanekela꞉mo nalima꞉tepate boga꞉mo dito emediya꞉, huiyatiya tawakaluba꞉te Ga꞉lili haka dodolo pepola꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ba꞉bene ebete komo hiliyonomo komokomo iya꞉tulame uwa꞉mo ba hawakalilame, eta iya꞉tulame tabo iba꞉tamo ba꞉ma ka꞉na goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“La꞉ nulia꞉la꞉. Eta lumagiti haka da꞉hiduimi kona kikipo haminahala꞉go ba꞉bo tui. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ebete haminahala꞉go ba tonato, komo kikipo iba꞉te gabamo gudiya꞉, ba꞉bema꞉ holaholate pelamete ba꞉bo penaliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Komo kikipo iba꞉te nakola hakamo gudiya꞉, ba꞉bolo haka koha꞉. Ba꞉bema꞉ iba꞉te tiyonomo ikulihuya꞉ mabu haka dobodoboha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ba꞉bene hegelate da꞉podolui iba꞉te na꞉waiwaihuya꞉ mabu ibino haha ipuwamo katolameha꞉, iyo, iba꞉te ba꞉bema꞉ tiyonomo ha꞉lahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Komo kikipo iba꞉te olagopi hemo hakamo gudiya꞉, ba꞉bema꞉ ba꞉bi hemate dapepehui kona ba꞉bo alukuliya꞉, ba꞉bene ba꞉ba꞉te kanolohoha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Huiyatiya komo kikipo iba꞉te hido hakamo gudiya꞉, ba꞉bema꞉ ba꞉ba꞉te apepehote ba꞉bo nolohuya꞉, komo 30 teta꞉mo, komo 60 teta꞉mo, komo 100 teta꞉mo hiliyonomoma꞉ eda꞉huya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ya꞉suti gala na꞉kagoiya꞉, “Galagodawa, ama꞉ hidamo nulia꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ba꞉bene hiliyonomo tawakaluba꞉te Ya꞉suku da꞉miya꞉puya꞉, komo kapiyakapiya tawakaluba꞉te ebeno 12 ta꞉matapa꞉go ebetamo pelamete na꞉pega꞉luya꞉, “Amia꞉no iya꞉tulame uwino ipuwa keba ka꞉nala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komoeno ipuwa kolawema꞉ nale helo la꞉tamo ikalamimata, iyo, ba꞉be komoeno awamina komo la꞉ ba꞉ iya꞉tawahuimata. Huiyatiya komo tawakalubi eba ka꞉naha꞉, iba꞉te iya꞉tulame uwini hiliyonomo komokomo ulihote hidamo a꞉kiya꞉tawahamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ba꞉ hibila, ‘Iba꞉te bohowadinakomena꞉ huiyatiya a꞉kuminakamena꞉, ba꞉gala iba꞉te bulinakomena꞉ huiyatiya a꞉kiya꞉tawahanakamena꞉, ba꞉bema꞉ iba꞉te ibino kubane a꞉kohobila꞉hamena꞉, ba꞉gala Godote ibino kuba a꞉kegebolelama꞉mene.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goiya꞉, “La꞉ ba꞉moe iya꞉tulame uwino ipuwa kiya꞉tawahutaha꞉, ba꞉bema꞉ la꞉ galane tetelo naeno komo iya꞉tulame uwino ipuwa keba ka꞉na na꞉kiya꞉tawahonama? Ba꞉moe uwino ipuwa ba꞉ma ka꞉nala, ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","kona kikipo haminahaledawa ebete Godokono tabo behaminahalena. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ba꞉bene komo tawakalubi gabamo da꞉gudi ba꞉bi kona kikipo keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala, iba꞉te tabo dulimina꞉ Saitanate pete ibino tepo ipuwane tiyonomo kopuwatema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Komo tawakalubi nakola hakamo da꞉gudi, ibi ba꞉ ba꞉bi kikipola, iba꞉te Godokono tabo dulimina꞉ kalakalago kolawema꞉na꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","huiyatiya ibino tepo ipuwalo haha puliyala. Ba꞉bema꞉ iba꞉te Godokono oko ipuwalo nanekela꞉mo emeda꞉tepate, ba꞉bene Godokono Taboma꞉ temeteme iba꞉tamo da꞉pikulimina꞉ ba꞉gala tawakaluba꞉te ibino komoma꞉ da꞉ga꞉lamena꞉, iba꞉te tiyonomo kalahutihoma꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Komo tawakalubi iba꞉te olagopi hemo hakamo da꞉gudi ba꞉bi kikipola. Iba꞉te Godokono tabo kulima꞉na꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","huiyatiya iba꞉te ilina konomamo emalagidolena ba꞉gala ibino emede komoma꞉ ukui bilibilinomoma꞉ eda꞉hana, ba꞉bema꞉ ibino tepo ipuwalo ba꞉bakobako ukui hiliyonomo ba꞉pola꞉na, ba꞉moi ukui komate hido tabo ba anakapumi, ba꞉bene iba꞉te a꞉kanolohamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Huiyatiya komo tawakalubi iba꞉te hido hakamo da꞉gudi ba꞉bi kikipola. Iba꞉te Godokono tabo uliti, hibinomolo lawete konolohoma꞉na꞉, komo 30 teta꞉mo, komo 60 teta꞉mo, komo 100 teta꞉mo konolohoma꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Lumagiti ebeno wuiki alo bagolo ipuwamo a꞉kihata꞉mene ba꞉gala ebeno wata bahi ipuwamo a꞉kihata꞉mene, huiyatiya ebete hawakala baha꞉mo kihatema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kebe awalelahale komate da꞉pola꞉na galane tetelo Godote kohawakalilamema꞉ne, ba꞉gala kebe ugumuili komate da꞉pola꞉na galane tawakaluba꞉te alo tetelo kulameholema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Galagodawa, ama꞉ hidamo nulia꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ba꞉gala Ya꞉suti iba꞉tamo na꞉kagoiya꞉, “La꞉le dulihonama ba꞉bi komo hidamo nulamenakuya꞉la꞉! La꞉le eta lumagitamo anagiya꞉mida komo keba ka꞉na dododima, Godote la꞉tamo ba꞉ ba꞉ba ka꞉na kopododima꞉ne, huiyatiya la꞉eno anagiya꞉mida huiyate konomamo kopema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ba꞉ hibila, Godokono tabo ulihoma꞉ lumagigodolo hidohido ukui da꞉pola꞉na, Godote ebetamo hiliyonomo hidohido komo gala kakikamehoma꞉ne. Huiyatiya lumagigodolo hidohido ukui pola꞉naheno, ebegodolo kebe kapiyakapiya komate da꞉pola꞉na Godote ebegodone gala kakuwatemema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komo ba꞉ma ka꞉nala. Dubuti ebeno ko pali hakamo kona kikipo da꞉haminahali, ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ba꞉bene ebete kawata, kamahiga, ba꞉ba ka꞉na ba ewagelena, ba꞉bi kona huha꞉te ikulihote ba꞉bo apepehuya꞉. Huiyatiya kikipate haka ipuwalo ba pola꞉na, tete ga꞉ga꞉dopolo iba꞉te keba ka꞉na dapepehona, ba꞉be dubuti kiya꞉tawanaha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","mabu hakate ilina ha꞉kiya noluilamena, dopamo paha ba꞉gala ugiugi, ba꞉bene naha kikipo. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ba꞉bema꞉ hibila, naha kikipate da꞉kodakodahamena꞉, ba꞉be dubuti tiyonomo tote konewakalamima꞉ne mabu kona wakalami tete ba꞉ a꞉pe.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na ba꞉be komo ale bada goamo na꞉ka꞉hawakalimima꞉, ba꞉gala ba꞉be komo ale kebako iya꞉tulame uwa꞉mo na꞉ka꞉tuputupuimima꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hibila, ba꞉moe hopo konomolo keha kikipo kokonomo ba꞉pola꞉na huiyatiya mastada kikipo ba꞉ deha꞉potonomola, ba꞉bema꞉ Godote Ko Gawadubuma꞉ deda꞉na ba꞉be komo ba꞉ mastada kikipo huiyala. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Dubuti damimini, ba꞉be deha꞉poto kikipote apete komo hiliyonomo keha gogolete koko gedawa komela꞉midahalema꞉ne, ba꞉bene holaholate pelamete keha gedawoeno dedelalo ba꞉pemedehonamena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ba꞉ hibila, tawakalubino iya꞉tawa komote da꞉modobuya꞉, Ya꞉suti ibi ba꞉mako hiliyonomo iya꞉tulame uwa꞉mo iya꞉tulamenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iyo, ebete Godokono tabo iya꞉tulame uwa꞉mo olamaginakui, huiyatiya komo hiliyonomo tawakaluba꞉te ibino habahabamo gala da꞉katolamenakui, ba꞉ba tetelo ebe ta꞉matapa꞉tamo hiliyonomo uwino ipuwa diya gabodo ba꞉bo hawakalilamenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ba꞉be hegelate da꞉duniya꞉ Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goeniya꞉, “A bobo hapuamo kona꞉hiwaliya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ba꞉bene iba꞉te komo tawakalubi hiliyonomo miya꞉palenate, Ya꞉suti da꞉lutiya꞉ ebe ta꞉matapa꞉te ba꞉be boga꞉mo ololonate ba꞉ dito tolameniya꞉. Ba꞉ba tetelo komo boga꞉te atumu iba꞉go na꞉katolameniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ba꞉bene ko gogonomote ba mahigana koko gawiyoeno beyate ta꞉matapino boga꞉mo da꞉pa꞉la꞉haniya꞉, boge gu beyate dito taboniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Huiyatiya Ya꞉suku boge gala hapulu ebeno wato tenamo apatinate ba꞉bo wataniya꞉, ba꞉bema꞉ iba꞉te ebe modoetenate na꞉ga꞉lameniya꞉, “Iya꞉tulamedawa, ama꞉ a hidamo badama꞉ kua꞉menaha꞉? A ba꞉ koha꞉lahama꞉nema꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ba꞉bene Ya꞉suti mahiganate huhu na꞉kiyahameniya꞉, “Na꞉tataba!” ba꞉gala gawiyatamo atu tabo bekagoeniya꞉, “Na꞉ka꞉la꞉liyahala꞉!” ba꞉bene huhuti wibonate bobote tatabanomoma꞉ ba꞉ dito eda꞉niya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ba꞉bema꞉ Ya꞉suti iba꞉tamo na꞉goeniya꞉, “La꞉ badama꞉ ka꞉toletolehonama? La꞉eno hibima꞉ midi komo puliyala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Huiyatiya iba꞉te konomamo ba hanohanohona ibi ipuwalo na꞉ga꞉laniya꞉, “Moe lumagi potela꞉ka꞉? Huhu ba꞉gala gawiya iba꞉te ebeno tabo uliti a꞉papamila꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ba꞉bene Ya꞉suku ba꞉gala ebe ta꞉matapi iba꞉te Ga꞉lili Bobo hapuamo na꞉hiwaliya꞉ Gelasa haboeno hopamo. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ya꞉suti bogene hakamo ba nodolo kuba gobogobagoeno dubuti eba꞉go alugama꞉ ba꞉bo piya꞉. Ba꞉be hopo tawakalubino komo ba꞉ma ka꞉nala, iba꞉te iya꞉ha꞉midale nakola haka ba aligili hiya꞉hiya꞉ bobo ba꞉bo ododilinakuya꞉ iba꞉te ibino ha꞉laha tawakalubi miya꞉tenoma꞉. Ba꞉bema꞉ ba꞉moe dubuti ba꞉be ha꞉laha tawakalubino bobo habane piya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","mabu ebete ba꞉bi nakola bobo ipuwalo emedenami. Tawakaluba꞉te ebe auli hala꞉mo da꞉matuhumihonakui ba꞉be hale kamodobonakuiha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","iyo, hiliyonomo tetelo iba꞉te ebeno nato kokoto auli hala꞉mo da꞉matuhulameholemenakui, ebete kokotoeno hale iya꞉hilinakui ba꞉gala natoeno hale atumu akiya꞉hilinakui. Ba꞉ hibila, ebete helonomoma꞉ eda꞉nami, ba꞉bema꞉ lumagiti ebe duhimi modoboha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ba꞉gala ebete hegela du hiliyonomolo nakola bobo habalo ba꞉gala haka hunulu ba gaa꞉tepaha, ebe ha꞉kiya ebeno ape nakolamo danagalimihonakui hawiti ba꞉bo pikulihomenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ba꞉bene ba꞉moe dubuti Ya꞉suku muhulamo numiti, ebetamo nipuligate ebeno nato mabamo da꞉nepapamiwatuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ya꞉suti ebetamo na꞉goiya꞉, “Kuba gobogobo, ama꞉ ba꞉moe dubugodone nuluhuka!” Ba꞉ba tetelo ebete gaa꞉tepahalo na꞉goiya꞉, “Ya꞉su! Ama꞉ Hununomo Godokono Gudulata! Ama꞉le natamo bada komo na꞉kododiomena꞉? Na ama꞉ Godokono mahilamo goememata, natamo kuba huiya akikanama꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ba꞉bene Ya꞉suti ebe nalatediya꞉, “Amia꞉no mahilo potela꞉ka꞉?” Ebete na꞉huiyuya꞉, “Naeno mahilo Hiliyonomotela mabu a kuba gobogobo hiliyonomola!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ba꞉bene ba꞉be dubuti Ya꞉suku koamo ba toemeho ebe na꞉goemiya꞉, “Nagodolo demedehona ba꞉bi kubakuba gobogobo ba꞉moe hopone akoelama꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ba꞉ba tetelo dabihole goegoe hiliyonomate haka hunulu nala꞉go ba꞉bolo na꞉wapata꞉lamitiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ba꞉bema꞉ kuba gobogobate Ya꞉sutamo toetoeholo na꞉ga꞉luya꞉, “Ama꞉ a goegoa꞉tamo noea꞉ma꞉, ale iba꞉tamo konogomoma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ba꞉bene Ya꞉suti modobo tabo goete ibi ba꞉bo goelamiya꞉, “Na꞉tolama꞉la꞉!” Ba꞉ba tetelo kubakuba gobogobate dubugodone ikuliti goegoa꞉tamo ba꞉bo nogomuya꞉, ba꞉bema꞉ ba꞉bi 2,000 goegoa꞉te haka hununi pulila꞉hate iya꞉ha꞉midale hakane da꞉negudiya꞉, beyamo nululuhuliti ibi hiliyonomate ba꞉ dito neha꞉lahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ba꞉ba tetelo goegoe ulamepi dubate ba꞉be komo umiti ibino habamo pulila꞉hate habalubi ba꞉gala tumu genamalo demedehonama꞉ da꞉nikiyahalamiya꞉, tawakalubi hiliyonomate ba꞉bo pelamiya꞉, Ya꞉suti dododiya꞉ ba꞉be komo umima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iba꞉te ebetamo pikuliti, dopamo kubakuba gobogobo hiliyonomago demedenami ba꞉be dubu ba꞉bo pumiya꞉, ebete kaliko puliti ba꞉bolo lutiya꞉ mabu ebeno ukui a꞉tuputupumiya꞉. Ba꞉moe mabuma꞉ iba꞉te na꞉toletolehutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ba꞉bene Ya꞉suti kubakuba gobogobagoeno dubutamo ba꞉gala goegoa꞉tamo kebe komokomo kododiliya꞉, puya꞉te ba꞉bi komo dulamiya꞉ iba꞉te komo tawakalubi ba꞉bo kiyalamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ba꞉ba tetelo ba꞉bi tawakaluba꞉te Ya꞉suku na꞉kiyahamiya꞉ ebete ibino hopo komiya꞉pama꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ba꞉bene Ya꞉suti boga꞉mo ba ololo, dopamo kubakuba gobogobago demedenami ba꞉be dubuti ebe ba꞉bo toemehuya꞉, “Na niliyala, ama꞉go kopa꞉mo!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Huiyatiya Ya꞉suti ebe ba duhimi na꞉goemiya꞉, “Ama꞉ genamamo na꞉toa. Godote ama꞉tamo keba ka꞉na kododila꞉ka ba꞉gala ama꞉ da꞉malemaleta꞉ka, ba꞉bi koko komonomo amia꞉no mabu tawakalubi na꞉nikiyalamiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ba꞉bema꞉ ba꞉moe dubuti Ta꞉ni Habahaboeno hopo konomamo tote, Ya꞉suti ebetamo dododiliya꞉ ba꞉bi komo olamaga꞉go tuya꞉, ba꞉bene puya꞉te ba꞉bi komo dulihuya꞉ iba꞉te konomamo hanohanohuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ba꞉bene Ya꞉suti boga꞉go bobo hapuamo gala da꞉kana꞉hiwuya꞉, ebete ba꞉bolo ba niluta tawakalubi hiliyonomate ebetamo ba꞉bo pelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ba꞉ba tetelo Yu tawakalubino baidi ibubulamehole genama umidawa dubu, ebeno mahilo Ya꞉ilasitila, ebete Ya꞉sutamo pete ebeno nato mabamo pepapamiwatate, ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","konomamo ba petoetoe na꞉pegoiya꞉, “Naeno bohele deha꞉poto hoe tatalila. Ama꞉ pete amia꞉no kokoto ebetamo na꞉pemowatima꞉ ebete kohidoma꞉, ba꞉bene ebete a꞉kahaa꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ba꞉bene Ya꞉suti ba꞉moe dubago to da꞉tupuimiya꞉, tawakalubi hiliyonomate ebe ba anataguma꞉tuta emokatihuia꞉go tolamitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ibi ipuwalo eta kamena 12 gogo tetelo hawi ka꞉ka꞉la꞉ temetemete uminami, ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","komo dogeta tawakaluba꞉te ebetamo hiya꞉hiya꞉ menemene komo bikamenama꞉. Iba꞉te ebe kahiduimiya꞉ha꞉, huiyatiya ba꞉be kamenate ebeno mani iba꞉tamo ba ikalame dupula꞉liya꞉, ebeno temetemete kodopoma꞉ ediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ba꞉bema꞉ ebete Ya꞉sukunu komo duliya꞉ tawakalubi ipuwamo nopegate, ebeno gala hapuni pete ebeno kaliko ba꞉bo pologiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","mabu ebete nemalagidoluya꞉, “Nale ebeno kaliko dologimo na ba꞉bo kohidoma꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ba꞉bene ebete Ya꞉sukunu kaliko dologiya꞉, ba꞉ba tetenomolo ebeno hawi ka꞉ka꞉la꞉ komote da꞉wibuya꞉ ebete iya꞉tawuya꞉ ebeno ape ba꞉ a꞉hido. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Huiyatiya Ya꞉suti iya꞉tawuya꞉ helote ebegodone duluhukuya꞉, ba꞉bene ebete pohobigate tawakalubi na꞉palateda꞉liya꞉, “Naeno kaliko pote kologi?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Huiyatiya ebe ta꞉matapa꞉te ebe na꞉ga꞉lamiya꞉, “Ba꞉moi tawakalubi hiliyonomate ama꞉tamo emokatihuia꞉go pelamita. Ama꞉ ibi ulamelo badama꞉ kolamagiuta ama꞉ pote dologita?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ya꞉suti ibino tabo kahuiyuya꞉ha꞉, huiyatiya ebete ba꞉moe lumagi kumima꞉ tawakalubi bulameholiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ba꞉ba tetelo ba꞉be kamenate iya꞉tawuya꞉ Ya꞉sukunu helote ebeno ape a꞉hiduimi, ba꞉bema꞉ ebete toletolelo lililago pete, Ya꞉sukunu nato mabamo pepapamiwatalo ebeno temetemeno komokomo ebetamo ba꞉bo pehawakalilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Kamena, amia꞉no hibima꞉ midi komote ama꞉ a꞉hiduima꞉ta. Ama꞉ kalakalago na꞉toa, mabu ama꞉ duminama꞉ ba꞉be temetemete ba꞉ a꞉wibo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ya꞉suti ba꞉moe tabo ba olamagita, tabo adahepa꞉te Yu watodawa Ya꞉ilasikono genamane pelamete ebe na꞉pega꞉lamiya꞉, “Amia꞉no bohele a꞉hoe, ba꞉bema꞉ Iya꞉tulamedawa gala akagoema꞉la꞉ ebe kopihiduimima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ya꞉suti ibino tabo dito ulia꞉tepuya꞉, ba꞉bene ebete Ya꞉ilasiko na꞉goemiya꞉, “Ama꞉ akatoletola꞉la꞉, ama꞉ Godoko hibima꞉ na꞉mida꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ba꞉ba tetelo ebete Pitako, Ya꞉imesiko, ba꞉gala ebeno ekawi Yoneko, ibi kapiya ba magatale komo tawakalubi na꞉duhilamiya꞉ iba꞉te iba꞉go tolamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ba꞉bene ibi ha꞉kiya Ya꞉ilasikono genamamo da꞉nikuliya꞉ Ya꞉suti tawakalubi hiliyonomo ba꞉bo nulamiya꞉, iba꞉te howela꞉go konomamo ihimitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ya꞉suti genama guamo nodolote ibi na꞉negoelamiya꞉, “La꞉ hiliyonomo howela꞉go bada mabuma꞉ kihimiutama? Gudu bohele kahaa꞉kaha꞉, ebete u bewatita.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Huiyatiya iba꞉te ebe na꞉walitiya꞉, ba꞉bema꞉ ebete ibi hiliyonomo genamane ba꞉ dito poelamiya꞉, ba꞉bene Ya꞉suti guduino menoko, nabiwi, ba꞉gala ebeno netewa-kapiya ta꞉matapi uwatete, guduti da꞉kapitanuya꞉ iba꞉te ba꞉be habamo dito na꞉pa꞉la꞉huya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ba꞉ba tetelo ebete bohele kokotamo nelawete Yu tawakalubino tabamo na꞉goemiya꞉, “Talita kumi!” Ba꞉moe taboeno ipuwa nitana, “Bohele, nale ama꞉ begoememata, na꞉mahiga!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ba꞉bene ba꞉ba tetenomolo ba꞉be 12 gogo tete bohelete mahigate na꞉patiya꞉. Puya꞉te ba꞉moe komo dumiya꞉ iba꞉te koamo hanohanohuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","huiyatiya Ya꞉suti ibi konomamo kiyahalamiya꞉, “La꞉ ba꞉moe komoma꞉ komo tawakalubi akakiyalama꞉la꞉!” ba꞉gala ebete iba꞉tamo na꞉kagoiya꞉, “Boheletamo naha ilina nikamehala꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ba꞉ba tetelo Ya꞉suti ba꞉be habane tote ebeno emede haba Nasaleta꞉mo gala da꞉katuya꞉, ebe ta꞉matapa꞉te ebe bana kapimilo katolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ba꞉bene Yu tawakalubino okoha꞉ talona hegelalo ebete baidi ibubulamehole genamalo tawakalubi ba iya꞉tulamita, komo ibi hiliyonomate ebeno tabo dulihutiya꞉ ba꞉bema꞉ hanohanohutiya꞉. Iba꞉te na꞉ga꞉luya꞉, “Moe dubuino iya꞉tulame komo mulunomola! Ebete ba꞉moi komo kebolo kiya꞉tawui? Ba꞉gala ebete hanohano komo dododilina bada kokonomola꞉ka꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ebe kapeneta dubunomola, Ma꞉likono gudula. A iya꞉tawahala ebeno ekaki Ya꞉imesiko, Yausesiko, Yudasiko, ba꞉gala Saimonoko, iyo, ebeno ekaki bohelemela꞉te ba꞉moe habalo ago bemedena.” Ba꞉bene iba꞉te ebe ubiha꞉ma꞉ ba eda꞉huta ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Godokono ukui hawakalimidawa tawakaluba꞉te ebe hunamo kadipatema꞉na꞉, huiyatiya ebeno habanapi ba꞉gala ebeno genamanapi ba꞉gala ebeno hawi tawakalubi, iba꞉te ebe ubiha꞉ma꞉ beda꞉hanakomena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Ba꞉ba tetelo Ya꞉suti Nasaletenapino hibima꞉ midiha꞉ komoma꞉ koamo la꞉wa꞉te, ebete ebeno kokoto temetema꞉gopi kapiyakapiyanomatamo demowatilamiya꞉ ibi ba꞉bo hiduilamiya꞉, huiyatiya ebete ibino habalo komo hanohano komo ododilima꞉ kamodobuya꞉ha꞉, ba꞉bema꞉ ebete ibi ba miya꞉pale huiyatiya komo hiya꞉hiya꞉ habahabalo iya꞉tulama꞉go pata꞉nami. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ba꞉bene Ya꞉suti ebeno 12 ta꞉matapi ebetamo ka꞉lamiti, etapi netewa, etapi netewa, hiya꞉hiya꞉ habahabamo ba꞉bo oelamiya꞉, ba꞉gala ebete iba꞉tamo helo ikalamiya꞉ tawakaluba꞉godone kuba gobogobo konoelamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ebete ibi na꞉goelamiya꞉, “La꞉eno tolame tetelo kuku kapiya nuwatiya꞉la꞉, huiyatiya komo ilina akuwata꞉la꞉, iyo, la꞉ baa꞉heno, kuihaheno, ba꞉gala manihino na꞉tolamiya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ba꞉gala wadiyala la꞉ nato ilina ba꞉gala kapiyakapiya kaliko pupuliti ba꞉bo na꞉tolamiya꞉la꞉, komo pupulino ilina akuwata꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ba꞉bene la꞉ eta habamo nikuliti kebe genamamo da꞉nalehawaminama, la꞉ ba꞉be genamalo nemeda꞉tepate galane ba꞉be genamane eta hopamo kakatolamema꞉nemata, iyo, la꞉ eta genamane eta genamamo eba ka꞉na akanewagela꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ba꞉gala kebe habaluba꞉te la꞉ kalakalago uwateheno ba꞉gala la꞉eno tabo ulihoheno, ba꞉be haba ba miya꞉pa la꞉le natoeno puhulu na꞉moda꞉midatepaliya꞉la꞉. Ba꞉moe komote ba꞉bi tawakalubi kiya꞉tulamema꞉ne, Godokono tete ba꞉ na꞉pe ebete ibino komo kopanagiya꞉midalamema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ba꞉bema꞉ Ya꞉suku ta꞉matapa꞉te tolamete Godokono tabo nolamagiminatuya꞉ tawakaluba꞉te ibino kubane kohobila꞉ma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba꞉bene iba꞉te tawakaluba꞉godone kuba gobogobo boelameholenakuya꞉, ba꞉gala iba꞉te komo temetema꞉gopi hiliyonomo olibi kikipoeno iha꞉mo ibino wato dabutilamelelamenakui, ibi ba꞉bo hiduilamenakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ba꞉ba tetelo Ko Gawadubu Heloditi ba꞉bi hanohano komo ulihuya꞉, mabu hiliyonomo tawakaluba꞉te Ya꞉sukunu komo ba iya꞉tawaha ibi ipuwalo komopa꞉te tabo ba꞉ma ka꞉na ga꞉luya꞉, “Yoneko tawakalubi beyamo wadulateledawate hoe ipuwane a꞉mahigui, ba꞉bema꞉ ba꞉moi hanohano komate ebegodone pikulinaka.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ba꞉bene komopa꞉te na꞉ga꞉luya꞉, “Ebe Elayate, Godokono ukui hawakalimidawala,” huiyatiya komopa꞉te na꞉kaga꞉luya꞉, “Ao, ebe ba꞉ Godokono ukui hawakalimidawa etala, dopamo aeno iniwala꞉tamo da꞉pikuliya꞉ ba꞉bi huiyala.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Huiyatiya Heloditi Ya꞉sukunu komo duliya꞉, ebete na꞉goiya꞉, “Ba꞉moe dubu ba꞉ Yonetela, nale ebeno wato ditamidamimo, huiyatiya ebete hoene gala a꞉kamahigui!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ba꞉moe komo ba꞉ Yonete keba ka꞉na ka꞉hoiya꞉ ba꞉be komola. Yonete dopamo ba emedena Ko Gawadubu Heloditi ebeno ekawi Pilipikono kamena pilolo lawiya꞉, ba꞉be kamenoeno mahilo ba꞉ Helodiyasitila. Ba꞉moe mabuma꞉ Yonete Helodiko ba kiyahame na꞉goemiya꞉, “Ama꞉le ba꞉be kamena lawe wadiyaha꞉, ko kubanomola!” Ba꞉bema꞉ Heloditi ebeno alaholohopi doelamiya꞉, iba꞉te Yoneko nelawete du genama guamo dito pa꞉da꞉nuya꞉, mabu ebete ebeno ubi bihatiya꞉ ba꞉be ododi komodo ebete Helodiyasiko kokalakaluimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ba꞉ba tetelo Helodiyasiti Yonetamo maubate ebe anakapumima꞉ ebeno ubi ba꞉bo ihatiya꞉, huiyatiya Heloditi ba꞉moe komo ododima꞉ ubihinola. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ebete Yoneko na꞉tolemenami, mabu ebe iya꞉tawala Yonete tuputupudawama꞉ ba eda꞉na Godokono talona ipuwalo emedena. Ba꞉ hibila, ebete Yonekono tabo dopamo duliya꞉ ukui bilibilima꞉ ba꞉bo ediya꞉, huiyatiya ebete du genamalo ba emedena, Heloditi ebe hidamo ba umina komo hiya꞉hiya꞉ tetelo ebeno tabo kalakalago ulinakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ba꞉bene Heloditi da꞉hawakaluya꞉, ba꞉be hegela emalagidololo ebete ko poko bododitiya꞉. Ba꞉bema꞉ ebeno gabomani dubu, alaholoho gawadubu, ba꞉gala Ga꞉lili hopoeno watowatopi, ibi hiliyonomate tolamiya꞉ poko habamo. Ba꞉ba tetelo Helodiyasiti hido tete bumiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ebete ebeno bohele noemete, ebete ibino holoholo hapulu da꞉pemoitiya꞉, Helodiko ba꞉gala eba꞉go da꞉pola꞉nuya꞉ iba꞉te ebetamo na꞉kalakalahutiya꞉. Ba꞉bene Heloditi boheletamo na꞉goiya꞉, “Ama꞉le kebe komoma꞉ na da꞉goenamemena꞉, nale ama꞉tamo kikamema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Heloditi ebetamo hibinomolo gala na꞉kagoiya꞉, “Ama꞉ bada komoma꞉ na da꞉goenamemena꞉, amia꞉no ubi dihatemena꞉ naeno komo ilina ba꞉gala naeno komo hopo, nale ama꞉tamo kikamehoma꞉nemata! Naeno tabo a꞉kadikanala꞉mo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ba꞉bene ba꞉be bohelete ebeno menokotamo tote na꞉negoiya꞉, “Na bada komoma꞉ na꞉ka꞉negoemo?” Ebeno menokote na꞉goemiya꞉, “Ama꞉ Yoneko tawakalubi beyamo wadulateledawoeno watoma꞉ ebe na꞉negoemiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ba꞉bene ba꞉be bohelete Ko Gawadubu Heloditamo gala tiyonomo kapete ebe na꞉pegoemiya꞉, “Na ubila Yoneko tawakalubi beyamo wadulateledawoeno wato kikipo kapeyago. Ka꞉lonomo natamo nikanama꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ba꞉bema꞉ Heloditi ebeno tepo ipuwalo menemenenomoma꞉ ediya꞉, huiyatiya ebete boheletamo kebe tabo ka꞉goiya꞉, eba꞉go da꞉pola꞉nuya꞉ iba꞉te ba꞉be tabo uliya꞉, ba꞉be mabuma꞉ ebete amawada꞉ma꞉ kamodobuya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ba꞉ba tetenomolo Heloditi ebeno eta alaholohodawa dubu ba noeme, ebe na꞉goemiya꞉ ebete Yonekono wato konelawema꞉, ba꞉bene ebete du genama guamo tote Yonekono wato ba꞉bo nitamidamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ba꞉bene ebete wato kapeyamo nihatete boheletamo dadahiya꞉, ebete lawete ebeno menokotamo ba꞉ dito nikamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ba꞉ba tetelo Yoneko ta꞉matapa꞉te ba꞉be komo duliya꞉, iba꞉te ebeno ape pelawete nakola bobo ipuwamo dito nihatiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ba꞉bene Ya꞉suti doelamiya꞉ ba꞉bi ta꞉matapi dubate gala ebetamo kapelamete, iba꞉te kebe komokomo tawakaluba꞉godolo da꞉nododiliya꞉ ba꞉gala ibi keba ka꞉na ka꞉niya꞉tulamiya꞉, ba꞉bi hiliyonomo komokomoma꞉ iba꞉te ebe na꞉pikiyahamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ba꞉ba tetelo tawakalubi hiliyonomate Ya꞉suku umima꞉ gogolatepahuilo wapata꞉lamitiya꞉, ba꞉bema꞉ Ya꞉suku ba꞉gala ebe ta꞉matapi baa꞉ nahama꞉ tete kumiya꞉ha꞉. Ba꞉be mabuma꞉ ebete ibi na꞉goelamiya꞉, “Wadiyala a ha꞉kiya tataba hopamo tolamete hawela konamihuya꞉,” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ba꞉bene iba꞉te ibino boga꞉go eta tataba hopamo tolame ba꞉bo tupuimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Huiyatiya iba꞉te ba tolamita, tawakalubi hiliyonomate ibi ulamete iya꞉tawahuya꞉ ibi puya꞉tela꞉ka꞉. Ba꞉bema꞉ Ya꞉suti kebamo ka꞉tutiya꞉, ba꞉bi hiliyonomo habahabanapa꞉te ba꞉be komo umiti, iba꞉te bobo dododo pulila꞉hate ba꞉be hopamo dopamo dito nikuliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ba꞉bene Ya꞉suti ba꞉bamo da꞉nuluhukuya꞉, tawakalubi hiliyonomo nulamete ebeno tepo ipuwalo ibi konomamo nemalemalelateliya꞉, mabu sipi-goegoa꞉te ulamedawaheno keba ka꞉na kemedena iba꞉te ba꞉ba ka꞉na pola꞉nuya꞉, ba꞉bema꞉ ebete ibi komo hiliyonomo komokomo ba iya꞉tulame, ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","iba꞉te gapogapo teta꞉mo ba꞉bo nikuliniya꞉. Ba꞉ba tetelo ebe ta꞉matapa꞉te ebetamo pelamenate ebe na꞉pega꞉lameniya꞉, “Moe tawakalubiha꞉ bahila, tiyo kuduma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ba꞉bema꞉ ama꞉ ibi noelama꞉, iba꞉te habahabamo ba꞉gala tumu genamamo tolameholete baa꞉ konuwatehoma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ya꞉suti huiyatiya ibi na꞉goelameniya꞉, “Ao, la꞉le iba꞉tamo naha ilina nikalamehola꞉la꞉.” Ba꞉bene iba꞉te ebe nalateda꞉niya꞉, “A tolamete kapiya gogoeno oko huiya mana꞉mo baa꞉ uwatehote, iba꞉tamo ba꞉kikalameholema꞉? Ao, a modoboha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ba꞉bene Ya꞉suti ibi nalateda꞉leniya꞉, “La꞉godolo kebaleta baa꞉te ka꞉pola꞉na? La꞉ tolamete na꞉nulama꞉la꞉.” Iba꞉te ulamenate na꞉ga꞉laniya꞉, “Agodolo paibo baa꞉ ba꞉gala daha netewa ba꞉pola꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ba꞉bene ebete ebe ta꞉matapi na꞉goelameniya꞉, “Tawakalubi na꞉kiyalama꞉la꞉ hiya꞉hiya꞉ kapiyuilame ododiliti hido hemolo kahidima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ba꞉bema꞉ tawakaluba꞉te hiya꞉hiya꞉ kapiyuilame hiliyonomo ododilinate ba꞉bo pola꞉nuya꞉, eta kapiyuimi ipuwalo 100, eta kapiyuimi ipuwalo 50, ba꞉ba ka꞉na ahidihoniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ba꞉bene Ya꞉suti paibo baa꞉ ba꞉gala daha netewa uwatenate, Hunu Habamo gahimilo Godotamo kalakala tabo goenate baa꞉ wakalamiholenate ebe ta꞉matapa꞉tamo dito ikalameniya꞉ iba꞉te tawakaluba꞉tamo kikalameholenama꞉, ba꞉gala ebete atu gabodo daha netewa kuwatenate tawakalubi hiliyonomatamo ba꞉bo kikalameholeniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ba꞉ba tetelo ibi hiliyonomate baa꞉ da꞉nahaniya꞉ ibino kape komo ba꞉bo wiboholameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","Ba꞉ hibila, ba꞉be baa꞉ 5,000 dubate nahaniya꞉, ba꞉bene da꞉luhiliniya꞉ ba꞉bi baa꞉ komokomamo ba꞉gala daha hapuhapamo Ya꞉suku ta꞉matapa꞉te 12 bagolo betabuilameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ba꞉ba tetenomolo Ya꞉suti tawakalubi ba oelamena ebe ta꞉matapa꞉tamo na꞉goeniya꞉, “Boge lawete Ga꞉lili Bobo hapuamo na꞉na꞉hiwala꞉la꞉ Betasaida habamo,” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ba꞉bene ebete ibi hiliyonomo oelamenate, ebete haka hunamo dito nodoloniya꞉ Godokoba꞉ tabo koga꞉lanama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Da꞉duniya꞉ ta꞉matapa꞉te boga꞉go bobo tulinomodo ba tolamena, huiyatiya Ya꞉suti hakalo ha꞉kiya lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ebete ibi ulameniya꞉, iba꞉te boge helonomamo da꞉mabihoniya꞉ huiyatiya ibino helo kamodoboniya꞉ha꞉ mabu huhuti ibi na꞉duhilameniya꞉, ba꞉bema꞉ du tetelo hegela owaloho tatalima꞉ ba eda꞉na, ebete beya hunudu iba꞉tamo ba꞉bo toniya꞉ ibino holoholo hapudu kopenuluhukunama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Huiyatiya ebete beya hunudu ba tonato, iba꞉te ebe uminate gubalima꞉ ga꞉lanate ba꞉bo ga꞉ga꞉niya꞉ ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","mabu ibi hiliyonomate kubanomamo toletolehoniya꞉. Ba꞉ba tetenomolo Ya꞉suti ibi na꞉goelameniya꞉, “Na Ya꞉sutila, la꞉ katoletolehonala꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ba꞉bene ebete penate ibino boga꞉mo da꞉pololoniya꞉ huhuti ba꞉ dito wiboniya꞉. Ba꞉ba tetelo ebe ta꞉matapa꞉te konomamo hanohanohoniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mabu iba꞉te ibino tepo ipuwalo kodakodama꞉ eda꞉hanama꞉, iyo, ba꞉be mabuma꞉ Ya꞉suti hiliyonomo tawakaluba꞉tamo baa꞉ dikalameholeniya꞉, iba꞉te ba꞉be hanohano komoeno ipuwa ibino ukuia꞉mo nipo ohowadiniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ba꞉bene duiduiya tetelo iba꞉te bobo hapuamo da꞉na꞉hiwaliya꞉ Genasalete hopoeno boge utihole baha꞉mo boge dito nutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Iba꞉te bogene hakamo da꞉nalehawaminuya꞉, puya꞉te ba꞉bolo da꞉pola꞉nuya꞉ ba꞉bi tawakaluba꞉te Ya꞉sukunu komo tiyonomo iya꞉tawahate, ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","iba꞉te ba꞉be hopoeno habahabamo na꞉pulila꞉huya꞉ komo tawakalubi ebeno pe komo konikiyalamema꞉. Ba꞉ hibila, Ya꞉suti kebe habalo da꞉lutanakui, tawakaluba꞉te ba꞉be komo dulinakui temetema꞉gopi tilago ba꞉bo magatalenakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iyo, Ya꞉suti kebe hiya꞉hiya꞉ hegehege ba꞉gala koko habahaba ba꞉gala tumu genamamo da꞉tonakui, tawakaluba꞉te ibino temetema꞉gopi ba꞉bamo da꞉magatalenakui, iba꞉te ba꞉bi habahaboeno ilina kolowami habamo ba newadila꞉latele ebe ba꞉bo netoemehonakuya꞉ temetema꞉gopa꞉te ebeno kaliko kologihoma꞉. Ba꞉bema꞉ hibila, puya꞉te ebeno kaliko dologihonakui, ba꞉ba꞉te ba꞉bo hidohidohonakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ba꞉bene Pa꞉lisi kapiyuimipi ba꞉gala Godokono Tutumu iya꞉tulamepi ipuwalo puya꞉te Yelusalema ko habalo oko dowatihonama꞉, komo iba꞉te Ya꞉sutamo kapimilo da꞉pelamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","iba꞉te ebeno komo ta꞉matapi bepulamiya꞉, iba꞉te kokoto ukulaleheno baa꞉ da꞉nahutiya꞉. Ba꞉moe gabodo iba꞉te Pa꞉lisi kapiyuimipino eta tutumu tabamo kapapamiliya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Numa꞉la꞉, hiliyonomo Yu tawakalubino iniwala꞉te ibi diya꞉tulamenakui, ibi hiliyonomate ba꞉be atu ukuilo ba emedena ba꞉bo ododilinaka, ba꞉gala Pa꞉lisi kapiyuimipa꞉te ba꞉bi iniwalino tutumu tabamo atumu hidonomamo kapapamila꞉halena, kebako deha꞉potonomo tutumu iba꞉te a꞉kadikamidala꞉la꞉. Ba꞉moe mabuma꞉ ibino kokoto hidamo ukulaleheno iba꞉te baa꞉ a꞉kanahamena꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ba꞉gala naha ilina kolowami habalo duwatehomena꞉ iba꞉te ba꞉bi ilina ukulaleheno a꞉kapenahamena꞉. Ba꞉ hibila, iba꞉godolo beya niho kalili ba꞉gala hiya꞉hiya꞉ oho kalili ukulale tutumate ba꞉kapola꞉na, iyo, ba꞉ma ka꞉na ibino iniwala꞉te iba꞉tamo dikalameholiya꞉, komo ba꞉bakobako tutumu hiliyonomo iba꞉godolo ba꞉pola꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ba꞉bema꞉ Pa꞉lisi kapiyuimipa꞉te Godokono Tutumu iya꞉tulamepa꞉go Ya꞉suku nalatediya꞉, “Bada mabuma꞉ ama꞉ ta꞉matapa꞉te aeno iniwala꞉te da꞉ga꞉lanakui ba꞉bi tutumamo kapapamila꞉hanaha꞉, huiyatiya ibi ha꞉kiya ibi kubahilamete kokoto ukulaleheno baa꞉ ba꞉bo nahanaka?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ ma꞉lapila netewa tawakalubilata! Godokono ukui hawakalimidawa Aisayate la꞉eno komoma꞉ dopamo hibi tabo dolamagiya꞉, Godokono Bukalo ba꞉be tabote ba꞉ma ka꞉na itana, ‘Ba꞉moi tawakaluba꞉te na tabamo adikunamena, huiyatiya ibino tepo ipuwoeno ukui na tamelo kapola꞉naha꞉, muhulunomolo ba꞉nepola꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Iba꞉te naeno mahilo hunamo nadipatena, huiyatiya hibi komo puliyala, iyo, iba꞉te hopo habanapino tutumu Godokono hibi Tutumuma꞉ midiliti ba꞉bo iya꞉tulamenaka.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Aisayakono tabo hibinomola, mabu la꞉ Godokono hibi Tutumu Tabo a꞉miya꞉paliya꞉mata, huiyatiya tawakaluba꞉te da꞉ga꞉lana ba꞉bi tutumamo papamila꞉hanamata. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“La꞉ hibi mulu tawakalubilata! Iyo, la꞉ Godokono hibi Tutumu Tabo tama꞉mo ba miya꞉te, huiyatiya la꞉eno iniwala꞉te da꞉ga꞉lanakui la꞉ ba꞉bi komo kapiya bododilinakomata. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Numa꞉la꞉, Godokono Bukalo Mosesete na꞉goiya꞉, ‘La꞉eno menokobi nabi nowalubila꞉la꞉,’ ba꞉gala ebete na꞉kagoiya꞉, ‘Kebe lumagiti ebeno menoko o nabiwino komoma꞉ kuba tabo dolamagimini, la꞉le ebe nanakapumiya꞉la꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Huiyatiya la꞉ ba꞉moe Godokono tabo tama꞉mo miya꞉palo na꞉ga꞉lanamata, ‘Lumagigodolo da꞉pola꞉na menoko nabiwi owalubilima꞉, ebete iba꞉tamo ikalamema꞉ ubiha꞉ma꞉ deda꞉mene, kubahenola. Ebete dito kogoema꞉ne, ‘Ba꞉moi ilina talonala, nale Godotamo ikamehote ba꞉moi ilinamo naeno menoko nabiwi a꞉kowalubila꞉mo.’ ’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ba꞉bema꞉ la꞉ ba꞉bako kuba ukui lumagi nonaminanakomata, ebete ebeno menoko nabiwi a꞉kowalubila꞉le. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Iyo, ba꞉moe gabodo la꞉eno iya꞉tulame komate Godokono hibi tabo tama꞉mo miya꞉tena, ba꞉bene la꞉le ba꞉be atu kuba ukui gabodo komo hiya꞉hiya꞉ kuba komo hiliyonomo na꞉kododilinamata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ba꞉bene Ya꞉suti tawakalubi ebetamo gala kaka꞉lamiti iba꞉tamo na꞉goiya꞉, “La꞉ hiliyonomo naeno tabo uliti, ukui hidamo na꞉tuputupuilama꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Lumagi tamelo ditana ba꞉be ilinate ebe ipuwamo opegate ebe a꞉kakubahima꞉mene, huiyatiya lumagino tepo ipuwane dikulimina꞉ ba꞉bi komate ebe kokubahimima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Galagodawa, ama꞉ hidamo nulia꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ba꞉bene Ya꞉suti tawakalubi miya꞉palete genama guamo da꞉nodoluya꞉, ebe ta꞉matapa꞉te ebete bada tabo ka꞉goiya꞉ ba꞉be taboeno ipuwama꞉ ebe nalatediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ebete iba꞉tamo na꞉goiya꞉, “Komopa꞉te ukui hidamo katuputupuilamenaha꞉, la꞉ ba꞉ atumu. La꞉ iya꞉tawahala꞉ka꞉? Naha ilinate lumagino tepo ipuwamo opegate ebe a꞉kakubahima꞉mene, ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","mabu naha ilinate lumagino ukui mabamo katutaha꞉, huiyatiya wapamo tuta ba꞉bene nea꞉go kopenuluhukuma꞉ne.” Ba꞉bema꞉ hibila, Ya꞉suti ba꞉moe tabamo hiliyonomo naha ilinoeno talona hiliyonomo tama꞉mo miya꞉tenomo a꞉miya꞉tiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ba꞉bene ebete gala na꞉kagoiya꞉, “Numa꞉la꞉, lumagino tepo ipuwane dikulimina꞉ ba꞉bi komo kapiyate ebe kokubahimima꞉na꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","mabu lumagino tepo ipuwane hiya꞉hiya꞉ kuba ukui komate pikulinaka, ba꞉bene ba꞉bi kuba ukuia꞉godone ba꞉moi koko kubate kapikulinaka — bohele pilo komo ba꞉gala eta lumagino kamena pilo komo, ilina pilo komo ba꞉gala eta lumagino ilina ubi komo, mauba komo ba꞉gala lumagi anakapumi komo, ha꞉da amiho komo ba꞉gala eta lumagino mahilo kubahimi komo, apa꞉mo kuba ododili komo ba꞉gala hiya꞉hiya꞉ kuba oholelo ododili komo, awagaha komo ba꞉gala daedae ukui komo. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iyo, ba꞉ hibila! Ba꞉moi kuba hiliyonomate lumagino tepo ipuwane pikuliti lumagi ba꞉bo kokubahimima꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ba꞉bene Ya꞉suti ba꞉be hopo miya꞉pate Taya ko haboeno hopamo dito tuya꞉. Ba꞉ba tetelo ebe ubihinola ebete kebe genamamo da꞉nodoluya꞉ tawakaluba꞉te iya꞉tawaha, huiyatiya iba꞉te ba꞉be genama tiyo iya꞉tawahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ba꞉bema꞉ ba꞉be hoponapi kamena eta, ebeno bohele deha꞉poto kuba gobogobagoenola, ebete Ya꞉sukunu komo uliti ebetamo pete ebeno nato mabamo ba pepapamiwata ebe ba꞉bo petoemehuya꞉, ebete ebeno bohelegodone kuba gobogobo koemema꞉. Huiyatiya ba꞉be kamena Yu lumagiha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ba꞉bema꞉ Ya꞉suti ebetamo na꞉goiya꞉, “Mabu keka꞉ nale ama꞉ owalubima꞉ da꞉goita? Tawakaluba꞉te dopamo ibino guguda꞉tamo baa꞉ nikalama꞉mena꞉. Wadiyaha꞉ iba꞉te gugudino baa꞉ komopa꞉tamo dito ikalame, mabu ba꞉be ododi komo ba꞉ gahagahatamo ikalame komo huiyala.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ebete huiyatiya Ya꞉sutamo na꞉goiya꞉, “Kodawa, ama꞉le da꞉gaa꞉ ba꞉ hibila, huiyatiya guguda꞉te hopamo diya꞉hekenaka, ba꞉bi baa꞉ hapuhapu gahagahate naha wadiyala!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Mabu ama꞉ ba꞉ba ka꞉na a꞉gaa꞉ta, ama꞉ kalakalago genamamo na꞉toa. Kuba gobogobote amia꞉no bohelegodone uluhuku.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ba꞉bene ba꞉be kamenate genamamo tote ebeno bohele ba꞉bo numiya꞉, kuba gobogobote ebegodone ya꞉lo uluhukuti, ebete tilolo watitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ba꞉bene Ya꞉suti Taya hopo miya꞉pate Saidono ko habamo tote, ebete Ta꞉ni Habahaboeno hopodo kapetote Ga꞉lili Bobamo gala dito kanuluhukuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ba꞉ba tetelo tawakaluba꞉te galo duhumi ba꞉gala tabo olamagiha꞉ dubu Ya꞉sutamo magahete ebe na꞉petoemehuya꞉ ebete ebeno kokoto ba꞉be dubutamo kemowatimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ba꞉bene Ya꞉suti ba꞉be dubu tawakaluba꞉godone nanekela꞉mo hiya꞉ baha꞉mo magatate, ebeno kokoto dubuino galo ipuwamo ba꞉bo newadulateliya꞉, ba꞉bene ebete ebeno kokotamo kowe mehamidate dubuino ma꞉lapila ba꞉bo ologimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ba꞉ba tetelo Ya꞉suti Hunu Habamo gahimilo, hawela ama꞉midate Yu tawakalubino tabamo na꞉goiya꞉, “Epa꞉ta!” ba꞉moe taboeno ipuwa ba꞉ma ka꞉na itana, “Na꞉tutukula꞉hala꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ba꞉bema꞉ ba꞉be dubuino galote tutukula꞉hate ba꞉gala ebeno ma꞉lapilate da꞉hiduya꞉, ebete tabo hidamo ba꞉bo olamagiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Tawakaluba꞉te ba꞉be komo dumiya꞉ iba꞉te hanohanoholo konomamo ga꞉luya꞉, “Ya꞉suti hiliyonomo komo hidonomamo ododilinako. Numa꞉la꞉, ebete galo duhulamepi na꞉hiduilamena iba꞉te tabo kulihoma꞉, ba꞉gala tabo ga꞉laha꞉pi atumu na꞉kahiduilamena iba꞉te tabo koga꞉lama꞉!” Ba꞉bene Ya꞉suti ibi konomamo kiyahalamiya꞉, “La꞉le komo tawakaluba꞉tamo ba꞉moe komo akahawakalima꞉la꞉!” Ba꞉ hibila, komo hiya꞉hiya꞉ tetelo Ya꞉suti tawakalubi ba꞉ma ka꞉na kiyahalamenakui, huiyatiya iba꞉te ebeno tabamo papamila꞉haheno ebeno ododili komo ba꞉ dito nehawakalilamenakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ba꞉ba tetelo tawakalubi hiliyonomate Ya꞉sutamo pelamete gala na꞉kapekapiyuya꞉. Ba꞉bene ibino baa꞉te da꞉wiboholamiya꞉ Ya꞉suti ebe ta꞉matapi ebetamo ka꞉lamiti ibi na꞉goelamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Na ba꞉moi tawakalubi na꞉malemalelatilitamo, mabu iba꞉te nago netewa-kapiya hegela demedenati ibino baa꞉ a꞉wiboholami. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na ibi baa꞉heno ibino habahabamo doelamemo, diyala, gabo tetelo heloha꞉ma꞉ da꞉ neda꞉hamena꞉, mabu komo iba꞉te muhulunomone pelamiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Huiyatiya ebe ta꞉matapa꞉te ebetamo na꞉ga꞉luya꞉, “Moe baa꞉ha꞉ hopola. Ale ba꞉moi tawakalubi hiliyonomatamo baa꞉ ikalameholema꞉ modoboha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ba꞉bene Ya꞉suti ibi nalateda꞉liya꞉, “La꞉godolo kebaleta baa꞉te ka꞉pola꞉na?” Iba꞉te na꞉ga꞉luya꞉, “Sa꞉ba꞉ni.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ba꞉bene Ya꞉suti tawakalubi hakamo kahidima꞉ da꞉goelamiya꞉, ba꞉ba tetelo ebete ba꞉bi sa꞉ba꞉ni baa꞉ komokomo uwatete Godotamo kalakala tabo ba꞉bo goiya꞉, ba꞉bene ebete wakalamiholete ebe ta꞉matapa꞉tamo dito ikalamiya꞉ iba꞉te tawakaluba꞉tamo kikalameholema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ba꞉gala iba꞉godolo daha hegehege kapiyakapiya na꞉kapola꞉nuya꞉, ba꞉bene Ya꞉suti ba꞉bi dahama꞉ Godotamo kalakala tabo kagoete, ebe ta꞉matapi na꞉goelamiya꞉ iba꞉te tawakaluba꞉tamo kakikalameholema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ba꞉ba tetelo puya꞉te ba꞉be baa꞉ da꞉nahuya꞉ ibino kape komo ba꞉ dito wiboholamiya꞉. Ba꞉ hibila, ba꞉be baa꞉ 4,000 tawakaluba꞉te nahuya꞉, ba꞉bene da꞉luhiliya꞉ ba꞉bi baa꞉ komokomamo Ya꞉suku ta꞉matapa꞉te sa꞉ba꞉ni bagolo betabuilamiya꞉. Ba꞉bene Ya꞉suti ba꞉bi tawakalubi ibino habahabamo doelamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ba꞉ba tetenomolo ebete ebe ta꞉matapa꞉go boga꞉mo ololote Da꞉lamanuta hopamo ba꞉ dito tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ba꞉bene komo Pa꞉lisi kapiyuimipa꞉te Ya꞉sutamo pelamete ebe na꞉polowabeletiya꞉. Ibi ubila ebe kuba gabamo kemogabuimima꞉, ba꞉bema꞉ iba꞉te ebe na꞉ga꞉lamiya꞉, “Ama꞉godolo Godokono helo ditana, ba꞉be komo hawakalimima꞉ eta hanohano komo atamo nododa꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ba꞉bene Ya꞉suti ebeno tepo ipuwalo hawela konomamo ama꞉midalo na꞉goiya꞉, “Mabu keka꞉ ba꞉ma tete tawakaluba꞉te hanohano komo dohowadina? Na la꞉tamo hibi tabo begoemo, Godote ebeno helo hawakalimima꞉ ba꞉ma tete tawakaluba꞉tamo hanohano komo a꞉kikalama꞉mene!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ba꞉bene ebete ibi ubiha꞉ma꞉ eda꞉lo boga꞉mo ololote bobo hapuamo gala na꞉kana꞉hiwuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ga꞉lili Bobo a꞉hiwale tupuimihino Ya꞉suku ta꞉matapa꞉te baa꞉ uwate komo nadoduya꞉, ba꞉bema꞉ iba꞉godolo kapiya baa꞉nomote itanuya꞉ boge gulu. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ba꞉bene Ya꞉suti ibi koamo kiyahalamiya꞉, “La꞉ hidamo nulia꞉la꞉! Palawa baa꞉te ha꞉kiya hunamo da꞉mahiga, Pa꞉lisi kapiyuimipi ba꞉gala Helodiko ibino awagaha komo ba꞉ba ka꞉nala. A꞉iye, ba꞉mako awagaha komote la꞉tamo akuluhukala꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ba꞉bema꞉ iba꞉te ibi ipuwalo tabo ba꞉ma ka꞉na ga꞉luya꞉, “Ebete atamo ba꞉moe tabo begoe mabu a baa꞉henola.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Huiyatiya iba꞉te tabo da꞉ga꞉lutiya꞉ Ya꞉suti iya꞉tawate iba꞉tamo na꞉goiya꞉, “La꞉le baa꞉heno pola꞉na tabo badama꞉ ka꞉ga꞉lutama? La꞉le naeno hibi komo hidamo kuminaha꞉ ba꞉gala kiya꞉tawahanaha꞉. Mabu keka꞉ la꞉le la꞉eno tepo ipuwa badama꞉ da꞉kodakoduilamenama? ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","La꞉ baida꞉gopila huiyatiya la꞉ a꞉kuma꞉lemata, iyo, la꞉ galagopila huiyatiya la꞉ a꞉kulia꞉lemata. Nale eta gapogapolo paibo baa꞉ 5,000 dubatamo da꞉wakalamiholenimo, ba꞉moe komoma꞉ la꞉godolo ukui ba꞉kitana? Ba꞉ba tetelo la꞉ baa꞉ komokomamo kebaleta bagolo ka꞉tabuilameonima?” Iba꞉te ebetamo na꞉huiyuya꞉, “12 bagolola.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ba꞉gala eta hegelalo nale sa꞉ba꞉ni baa꞉ 4,000 tawakaluba꞉tamo da꞉kawakalamiholimo, ba꞉ba tetelo la꞉ baa꞉ komokomamo kebaleta bagolo ka꞉tabuilamiuima?” Iba꞉te ebetamo na꞉huiyuya꞉, “Sa꞉ba꞉nila.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ba꞉bema꞉ Ya꞉suti iba꞉tamo gala na꞉kagoiya꞉, “Mabu keka꞉ la꞉le naeno komo hibilo kiya꞉tawahanaha꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ba꞉bene iba꞉te Betasaida habamo da꞉nikuliya꞉, komo tawakaluba꞉te baidi tamiho dubu Ya꞉sutamo magahete, ebe ba꞉bo petoemehuya꞉ ebete ebe kologima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ba꞉bene Ya꞉suti baidi tamiho dubu kokotamo lawete habane nanekela꞉mo magatate, ebete ebeno baida꞉mo kowe miya꞉temete ebeno kokoto emowatilamelo ebe nalatediya꞉, “Ama꞉ ilina na꞉kulamiuta?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ba꞉be dubuti gahimiti na꞉goiya꞉, “Na tawakalubi da꞉wapata꞉lamita nulamitamo, huiyatiya ibi kehamo la꞉mota꞉hana.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ba꞉bene Ya꞉suti ebeno kokoto ba꞉be dubuino baida꞉mo gala da꞉kemowatilamiya꞉, ebete ibulu a꞉la꞉minalete ebeno baiditi ba꞉bo hidohidohomiya꞉, iyo, ba꞉ba tetelo ebete ilina hiliyonomo hidamo ba꞉bo ulameholiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ba꞉bene Ya꞉suti ebe na꞉goemiya꞉, “Amia꞉no genamamo tonomo na꞉toa, ba꞉moe habamo gala akapa꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉go Sisaliya-Pilipai hopoeno habahabamo ba tuta, gabo tetelo ebete ebeno ta꞉matapi na꞉nalateda꞉liya꞉, “Tawakaluba꞉te na pokomo ka꞉ga꞉lanaka?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iba꞉te na꞉ga꞉luya꞉, “Komopa꞉te ama꞉ Yoneko beyamo wadulateledawama꞉ ga꞉lanaka, komopa꞉te ama꞉ Elayako Godokono ukui hawakalimidawama꞉ ga꞉lanaka, ba꞉gala komopa꞉te ama꞉ Godokono ukui hawakalimidawa etama꞉ ga꞉lanaka.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ba꞉bene Ya꞉suti ibi nalateda꞉liya꞉, “Huiyatiya la꞉le na pokomo ka꞉midinionama?” Pitate ebetamo na꞉huiyuya꞉, “Ama꞉ ba꞉ Kelisotela, Godokono Oemedawalata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ba꞉bene Ya꞉suti ebe ta꞉matapi na꞉kiyahalamiya꞉, “La꞉le naeno komoma꞉ komopi akakiyalama꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ba꞉bene Ya꞉suti ebe ta꞉matapi ba iya꞉tulame na꞉goiya꞉, “Tawakalubino Naniwi tawakaluba꞉godone koko temeteme galane kuwatema꞉ne, Godokono ubila. Iyo, Godotamo hawa꞉goeno ikamehopino watowatopi, ba꞉gala Godokono Tutumu iya꞉tulamepi, ba꞉gala komo koko dubu iba꞉te ebe ubiha꞉ma꞉ keda꞉hama꞉na꞉, ba꞉bene tawakaluba꞉te ebe kanakapumima꞉na꞉ huiyatiya netewa-kapiya hegelalo ebete hoene gala kakamahigama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ebete ba꞉moe tabo iba꞉tamo da꞉goiya꞉, Pitate Ya꞉suku komo ta꞉matapa꞉godone nanekela꞉mo magatate ba꞉be tabo komoma꞉ ebe ba꞉bo nikiyahamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ba꞉bene Ya꞉suti ohobigate, komo ta꞉matapi ulamete Pitako kiyahamelo na꞉goiya꞉, “Pita, ama꞉ Saitanako huiyala! Na na꞉miya꞉pana꞉ mabu amia꞉no ukui Godotamo kihatitaha꞉, ama꞉ tawakalubino ukuilo emedenata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ba꞉bema꞉ Ya꞉suti tawakalubi hiliyonomo ebe ta꞉matapa꞉go ebetamo ka꞉lamiti ibi na꞉goelamiya꞉, “Kebe lumagiti na ta꞉mahenema꞉ ubi dihatemene, dopamo ebete ebeno komo adodolete ebeno keha pihiga aguti na ba꞉bo na꞉ta꞉mahena꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ba꞉ hibila, kebe lumagiti ebeno ka꞉ka꞉ natamo damawada꞉mene ebeno ka꞉ka꞉te kalatidima꞉ne, huiyatiya kebe lumagiti Godokono Hido Tabo olamagima꞉ ebeno ka꞉ka꞉ na mabuma꞉ datutimini, ebete hibi ka꞉ka꞉ kolawema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ba꞉bema꞉ lumagiti hopoeno ilina hiliyonomo uwatenomo ba uwate, ebeno ka꞉ka꞉ datutimini ba꞉be lumagino huiya keka꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ebete ebeno ka꞉ka꞉ gala kakalawema꞉ bada ilina na꞉kikamemene? Gabo puliyala, kitanaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Numa꞉la꞉, ba꞉ma tete tawakaluba꞉te kubakubanomoma꞉ eda꞉hate, iba꞉godolo Godoko hibima꞉ midi komo puliyala. Ba꞉bema꞉ kebe lumagiti natamo ba꞉gala naeno tabamo da꞉hilopomene, na Tawakalubino Naniwiti ba꞉ atumu ebetamo kohilopoma꞉nemo, iyo, nale naeno Nabiwino helonomo alago ba꞉gala ebeno hido-talona nopopa꞉go da꞉pemo, ba꞉ba tetelo ebe kopehilopuimima꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ba꞉bene Ya꞉suti iba꞉tamo gala na꞉kagoiya꞉, “Na la꞉tamo hibi tabo begoemo, ba꞉ma tetelo demedehona komo iba꞉te Godokono Ko Gawadubuino tetete heloago da꞉pemene, ba꞉be ko komo dopamo umiti galane ba꞉bo koha꞉lahama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ba꞉bene sikisi hegela da꞉wibuya꞉ Ya꞉suti Pitako, Ya꞉imesiko, ba꞉gala Yoneko eta hununomo hakamo magataliya꞉, iba꞉te ha꞉kiya ba꞉bolo konepola꞉nama꞉. Ba꞉ba tetelo ibino dopo hapulu Ya꞉sukunu apete hiya꞉ma꞉ ba edita, ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ebeno pupulino ilinate a꞉la꞉minahamete hibilo keyakeyanomoma꞉ eda꞉hamitiya꞉, ba꞉moe hopo konomolo eta lumagiti kaliko ba꞉ma ka꞉na ukulalelo keyakeyanomoma꞉ midili wadiyaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ba꞉bene ta꞉matapino holoholo hapuamo Moseseko ba꞉gala Elayako iba꞉te puluhukuti Ya꞉sukuba꞉ tabo ba꞉bo ga꞉lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ba꞉ba tetelo Pitate Ya꞉sutamo na꞉goiya꞉, “Iya꞉tulamedawa, ale ba꞉malo da꞉pola꞉nama꞉, kalakala konomola. Wadiyala a mimiya netewa-kapiya ketemotema꞉nema꞉, eta amia꞉nola, eta Mosesekonola, eta Elayakonola.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ba꞉ hibila, ta꞉matapa꞉te konomamo toletolehutiya꞉, ba꞉bema꞉ Pitate ukui hidamo emalagidoloheno ba꞉be tabo ba꞉ dito goiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ba꞉bene hawaiti pete ibi da꞉patulateliya꞉, tabote hawai ipuwane ba꞉ma ka꞉na piya꞉, “Ba꞉moe naeno kapiya Gudunomola, na ebetamo na꞉kalakalutamo. La꞉ ebeno tabo nulia꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Huiyatiya ba꞉ba tetelo iba꞉te hopo tiyonomo umihote Moseseko Elayako ibi gala kulamiya꞉ha꞉, Ya꞉suku kapiyate iba꞉go ba꞉bolo la꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ba꞉bene iba꞉te haka hununi ba pepalaga Ya꞉suti ibi na꞉pegoelamiya꞉, “La꞉le kebe komo kumioma, ba꞉be komo ba꞉ma tetelo komopi akakiyalama꞉la꞉, huiyatiya na Tawakalubino Naniwiti hoene gala da꞉kamahigamo, la꞉ tawakalubi ba꞉bo kokiyalamema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ba꞉bema꞉ iba꞉te ba꞉be komo tepo ipuwamo ihatiya꞉, huiyatiya hoene mahiga komoeno ipuwa ibi ipuwalo ga꞉lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ba꞉bene iba꞉te Ya꞉suku nalatediya꞉, “Bada mabuma꞉ Godokono Tutumu iya꞉tulamepa꞉te da꞉ga꞉lanaka, Elayate dopamo pete, ebeno gala hapuni Kelisote kopema꞉ne?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Hibila, Elayako dopamo pete hiliyonomo komokomo kopetuputupuilamema꞉ne. Huiyatiya Godokono Bukalo eta tabo ba꞉ma ka꞉na ba꞉ka-itana, Tawakalubino Naniwi temeteme hiliyonomo kuwatema꞉ne ba꞉gala tawakaluba꞉te ebe ubiha꞉ma꞉ keda꞉hama꞉na꞉. Ba꞉moe taboeno ipuwama꞉ la꞉eno ukui keba ka꞉na ka꞉pola꞉na? ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na la꞉tamo na꞉goemo, Elayako tawakaluba꞉tamo ya꞉lo a꞉pi huiyatiya iba꞉te ibino ubilo koko kuba ebetamo ododilinakuya꞉, Godote ebeno Bukalo dopamo da꞉goiya꞉ ba꞉ba ka꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ba꞉bene iba꞉te komo ta꞉matapa꞉tamo pikuliti, tawakalubi hiliyonomate iba꞉go ba pola꞉na ba꞉bo pulamiya꞉. Ba꞉ba tetelo Godokono Tutumu iya꞉tulamepa꞉te Ya꞉suku ta꞉matapa꞉go ba olowabeletehuita, ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","huiyatiya tawakaluba꞉te Ya꞉suku dumiya꞉ iba꞉te konomamo la꞉wa꞉halo ebetamo pulila꞉hate nolata tabo ba꞉bo nega꞉luya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ba꞉bene Ya꞉suti ebe ta꞉matapi nalateda꞉liya꞉, “Mabu keka꞉ la꞉ ba꞉moi dubago dolowabeletehuitama?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ba꞉ba tetelo tawakalubi hiliyonomo ipuwalo eta lumagiti Ya꞉sukunu tabo ba huiya na꞉goiya꞉, “Iya꞉tulamedawa, na naeno gudu ama꞉tamo a꞉magaha꞉kamo mabu ebe kuba gobogobote lawenako, ba꞉bema꞉ ebe tabo olamagi modoboha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Keba tetelo kuba gobogobote ebe gala da꞉kalawemene hopamo kopena꞉da꞉nama꞉ne, ba꞉bene ebete lalo ba ikilame paguti ebeno tabo ipuwane pikulimiti, ebeno apete kodakodanomoma꞉ ba꞉bo keda꞉ma꞉ne. Nale ama꞉ ta꞉matapi a꞉goelama꞉kamo iba꞉te kuba gobogobo koemema꞉, huiyatiya iba꞉godolo helo puliyala.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ba꞉bema꞉ Ya꞉suti iba꞉tamo na꞉goiya꞉, “A꞉iye, la꞉ hibima꞉ midiha꞉ tawakalubilata! La꞉le natamo menemene bikanamenamata, ba꞉bema꞉ na ubihinola tete ga꞉ga꞉lo la꞉go emedena! La꞉ kuhi natamo na꞉magaha꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ba꞉bene iba꞉te ba꞉be kuhi Ya꞉sutamo da꞉magatuya꞉, kuba gobogobote Ya꞉suku umiti kuhi kubanomamo ba꞉bo lawiya꞉. Kuhiti hakamo gate ewageleholo ba miwa꞉digahuta ebeno tabone paguti pikulimitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ba꞉ba tetelo Ya꞉suti kuhino nabiwi nalatediya꞉, “Ebe ba꞉moe komo kebako tetelo ka꞉tupuimi?” Ebete na꞉huiyuya꞉, “Gudu deha꞉poto tetelo tupuimi. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hiliyonomo tetelo kuba gobogobote ebe koa꞉mo ba꞉da꞉na, ba꞉gala beyamo ba꞉da꞉na, ba꞉ba ka꞉na amitina ebe kanakapumima꞉. Ba꞉bema꞉ amia꞉no helo modobola꞉ka꞉ a kowalubima꞉? Helote modobolo ditama꞉na, a malemalea꞉telo ebe nowaluba꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ya꞉suti ebetamo na꞉goiya꞉, “Mabu keka꞉ ama꞉le naeno helo komoma꞉ da꞉kiyanama꞉? Ba꞉moe komo naeno komoha꞉, ba꞉ amia꞉no komola! Wadiyala ama꞉ Godoko hibima꞉ na꞉mida꞉, ba꞉bene ama꞉godolo helo bitanamene hiliyonomo komokomo ododilima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ba꞉ba tetenomolo kuhino nabiwiti konomamo na꞉goiya꞉, “Na hibima꞉ na꞉miditamo huiyatiya naeno hibima꞉ midi komo deha꞉potola. Na꞉koiminama꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ba꞉bene komo tawakalubi hiliyonomate ba pelamenape, Ya꞉suti ibi ulamete kuba gobogobo kiyahamelo na꞉goiya꞉, “Taboha꞉dawa ba꞉gala galo duhumi gobogobo, nale ama꞉ bikiyahamemata, ebegodone uluhukuti na꞉toa! Gala ebetamo akapopegala꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ba꞉ba tetelo kuba gobogobote ibulu goewatalo kuhi hakamo a꞉da꞉nate, ba꞉bene kuhiti kubanomamo ewageleholo kuba gobogobote ebegodone duluhukuya꞉, ebete hoemo ba꞉bo kapitanuya꞉. Ba꞉be mabuma꞉ komopa꞉te na꞉ga꞉luya꞉, “Ebe a꞉hoe,” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","huiyatiya Ya꞉suti ebe kokotamo lawete dadipatiya꞉ ebe ba꞉bo mahiguya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ba꞉bene Ya꞉suti genama guamo da꞉na꞉pa꞉guya꞉, komo tawakaluba꞉te pola꞉naha꞉ tetelo ebe ta꞉matapa꞉te ebe nalatediya꞉, “Mabu keka꞉ ale kuba gobogobo oemema꞉ kamodobakaha꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ebete ibino tabo ba huiya na꞉goiya꞉, “Pote ebeno emede ipuwalo Godokoba꞉ tabo da꞉ga꞉lanaka, ebe kapiyate ba꞉mako kuba gobogobo koemema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ba꞉bene iba꞉te ba꞉be haba miya꞉pate Ga꞉lili hopodo ba petolame, Ya꞉suku ubihinola ebete kebolo ka꞉lutiya꞉ tawakaluba꞉te iya꞉tawaha, ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","mabu ebete ebe ta꞉matapi komo hiya꞉hiya꞉ komokomo biya꞉tulamitiya꞉. Ebete ibi iya꞉tulamelo na꞉goiya꞉, “Godote Tawakalubino Naniwi kuba tawakalubino kokotamo kihatema꞉ne, ba꞉bene iba꞉te ebe kanakapumima꞉na꞉, huiyatiya ebete netewa-kapiya hegelalo hoene gala kakamahigama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Huiyatiya Ya꞉suti da꞉goiya꞉ ebe ta꞉matapa꞉te ba꞉be taboeno ipuwa hidamo kemalagidolutiya꞉ha꞉, ba꞉bema꞉ iba꞉te ba꞉moe komoma꞉ Ya꞉suku alateda꞉ma꞉ na꞉toletolehutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ba꞉bene iba꞉te Kapeniyama habamo da꞉pelamiya꞉, Ya꞉suti genama guamo nodolote ebe ta꞉matapi ba꞉bo nalateda꞉liya꞉, “Gabo tetelo la꞉ bada mabuma꞉ ka꞉ga꞉lutakama?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Iba꞉te tabo kahuiyuya꞉ha꞉ mabu iba꞉te ibi ipuwalo pote koma꞉ eda꞉ma꞉ a꞉polowabeletehuiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ba꞉be mabuma꞉ Ya꞉suti emedete ebeno 12 ta꞉matapi ebetamo ka꞉lamiti iba꞉tamo na꞉goiya꞉, “Kebe lumagiti koma꞉ eda꞉ma꞉ ubi dihatemene, ebete ebe ha꞉kiya galanomoma꞉ miditi komopino huiyaha꞉ okodawama꞉ neda꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ba꞉bene Ya꞉suti gudu deha꞉poto lawete ibi tetenomamo adipiti, ebe kokotamo ba a꞉ga꞉da꞉mida iba꞉tamo na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kebe lumagiti naeno mahilamo ba꞉mako gudu deha꞉poto kalakalago dowalubina ebete na bowalubinina, ba꞉gala kebe lumagiti na dowalubinina ebete na kapiya kowalubininaha꞉, ebete na Oenamedawa Godoko atumu na꞉kowalubina.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ba꞉bene Yonete Ya꞉sutamo na꞉goiya꞉, “Iya꞉tulamedawa, ale eta dubu umima꞉ ebete amia꞉no mahilamo kuba gobogobo doelamiti, huiyatiya ale ebe a꞉kiyahamima꞉ ba꞉be komo kekelamema꞉ mabu ebe aeno kapiyuimi lumagiha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Huiyatiya Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉le ebe akaduhima꞉la꞉. Kebe lumagiti naeno mahilamo hanohano komo dododimini, ba꞉be lumagiti tote naeno komoma꞉ kuba tabo a꞉kanolamaga꞉mene, ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","mabu hibila, kebe lumagiti ago alaholohoha꞉dawama꞉ deda꞉na, ebete ba꞉ a bowalubina. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nale la꞉tamo hibi tabo begoemo, la꞉le na Kelisokono tawakalubima꞉ deda꞉hanama, ba꞉be mabuma꞉ etate beya la꞉tamo dikalamemena꞉, ebete Godogodone da꞉lawemene ba꞉be hido huiyate a꞉kalatida꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Deha꞉poto guduti na hibima꞉ ba midinina, kebe lumagiti ebe kuba gabamo demogabuimina, wadiyala tawakaluba꞉te ebe lawete ebeno kokoba꞉mo konomo nakola ma꞉homete kehaha꞉ kolomamo na꞉da꞉namena꞉, ebete atu kuba komo eta gudutamo ododikapoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ba꞉gala amia꞉no kokotote ama꞉ kuba gabamo demogabuimina, nitamida! Wadiyala ama꞉le kapiya kokotago Godokono Ka꞉ka꞉ Habamo na꞉pa꞉ga, kubala kokoto netewago Koe Habamo to. Ba꞉ hibila, ba꞉be habalo koete itana tetelo na꞉woena, ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ba꞉bolo tawakalubino ha꞉laha ape da꞉nalenaka ba꞉bi la꞉ga꞉te a꞉kaha꞉lahala꞉, ba꞉gala koete a꞉kaha꞉gale. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ba꞉gala amia꞉no natote ama꞉ kuba gabamo demogabuimina, nitamida! Wadiyala ama꞉le kapiya natago Godokono Ka꞉ka꞉ Habamo na꞉pa꞉ga, kubala nato netewago Godote ama꞉ Koe Habamo na꞉da꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ba꞉bolo tawakalubino ha꞉laha ape da꞉nalenaka ba꞉bi la꞉ga꞉te a꞉kaha꞉lahala꞉, ba꞉gala koete a꞉kaha꞉gale. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ba꞉gala amia꞉no baiditi ama꞉ kuba gabamo demogabuimina, na꞉magubuta꞉! Wadiyala ama꞉le kapiya baida꞉go Godote Ko Gawadubuma꞉ deda꞉na ba꞉be habamo na꞉pa꞉ga, kubala baidi netewago Godote ama꞉ Koe Habamo na꞉da꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ba꞉bolo tawakalubino ha꞉laha ape da꞉nalenaka ba꞉bi la꞉ga꞉te ba꞉pola꞉na, a꞉kaha꞉lahala꞉, ba꞉gala koete a꞉kaha꞉gale.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ba꞉bene Ya꞉suti eta tabo ba꞉ma ka꞉na kagoiya꞉, “Tawakaluba꞉te solo baa꞉mo keba ka꞉na ka꞉miya꞉tenaka, Godote tawakalubi hiliyonomoeno emede komamo ebeno koe ba꞉ba ka꞉na kopemiya꞉telamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Solo hidonomola, huiyatiya eta lumagino solo golate dalatidimini, ama꞉le gala soloma꞉ a꞉kamida꞉mena꞉ta. Ba꞉bema꞉ Godokono solote la꞉eno kapiyuimi ipuwalo nitanamene, iyo, wadiyala etate eta malemaletelo ba꞉ba ka꞉na nemedeniya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ba꞉bene Ya꞉suti Ga꞉lili hopo miya꞉pate Yudiya hopodo petote Yodane Tuli hapuamo dito nuluhukuya꞉. Ba꞉ba tetelo tawakalubi hiliyonomate ebetamo gala da꞉kapelamiya꞉, ba꞉bene ebete ibi gala na꞉ka-iya꞉tulamiya꞉ mabu ebeno ododi komo ba꞉ ba꞉ma ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ba꞉bene komo Pa꞉lisi kapiyuimipa꞉te pelamete, Ya꞉suku kuba gabamo kopemogabuimima꞉ ebe na꞉palatediya꞉, “Dubuti ebeno kamena dibukimini, Godokono Tutumu Tabo ba꞉kadikamidalemene?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “Mosesete la꞉ bada tutumu tabo ka꞉goelamitiya꞉la?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iba꞉te na꞉ga꞉luya꞉, “Dubuti ebeno kamena ibukima꞉ Mosesete gabo atamo ba꞉ma ka꞉na hiduimiya꞉, dubuti ebeno ubi dihatemene, ebete kamena ibuki pepa ododiti ebetamo dito kikamema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Mabu la꞉eno tepo ipuwa kodakoda hibinomola, Mosesete kamena ibuki tabo Godokono Bukamo ba꞉bema꞉ ihatiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Huiyatiya numa꞉la꞉, dopamo Godote ba꞉moe hopo dododiya꞉, ba꞉ba tetelo ebete dubu kamena bododiliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ba꞉moe mabuma꞉ dubuti ebeno nabiwi ba꞉gala menoko miya꞉palete ebeno kamenago kapiya bahilo kemedema꞉na꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ba꞉bene ibi netewapa꞉te kapiyama꞉ eda꞉te gala hiya꞉ma꞉ a꞉keda꞉mena꞉. Iyo, ibi ba꞉ kapiyanomola. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Numa꞉la꞉, Godote ibi netewapi kapiyama꞉ a꞉midiliya꞉, ba꞉bema꞉ lumagiti ibi hiya꞉ma꞉ midili modoboha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Galane genama gulu Ya꞉suku ta꞉matapa꞉te ba꞉be taboeno ipuwama꞉ ebe da꞉nalatediya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ebete iba꞉tamo ba꞉ma ka꞉na goiya꞉, “Kebe lumagiti ebeno kamena ibukiti eta kamena da꞉lawemene, ebete Godokono holoholo hapulu ba꞉be kamena pilolo kolawema꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ba꞉gala kebe kamenate ebeno dubu ibukiti eta dubu da꞉lawemene, ebete ba꞉be dubu atumu pilolo kolawema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ba꞉bene komo tawakaluba꞉te ibino gugudi Ya꞉sutamo na꞉magataliya꞉, ebete iba꞉tamo kokoto ba emowatilame Godoko kogoemema꞉ ebete ibi hidamo kowalubilinama꞉. Huiyatiya ebe ta꞉matapa꞉te ba꞉bi tawakalubi ba kiyahalame ibi da꞉duhilamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ya꞉suti ibino ododi komo umiti iba꞉tamo maubalo na꞉goiya꞉, “Gugudi natamo pelame wadiyala. Akaduhilama꞉la꞉, mabu ba꞉mako tawakaluba꞉te Godote Ko Gawadubuma꞉ deda꞉na ba꞉be habamo kona꞉pa꞉la꞉hama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na la꞉tamo hibi tabo begoemo, kebe lumagiti gudu deha꞉poto huiyamo aeno Ko Gawadubu Godoko laweheno, ba꞉be lumagiti ebeno Kalakala Habamo a꞉kana꞉pa꞉gamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ba꞉bene Ya꞉suti guguda꞉tamo kokoto ba emowatilame Godoko ba꞉bo goemiya꞉, ebete ibi hidamo kowalubilinama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ba꞉bene Ya꞉suti mahigate gabodo ba tuta, eta dubuti ebetamo nipuligate pupamo nemedete ebe na꞉goemiya꞉, “Hido Iya꞉tulamedawa, na bada komo ododiti wiboha꞉ ka꞉ka꞉ ebo na꞉ka꞉lawemo?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉le na hidodawama꞉ badama꞉ ka꞉ka꞉nama꞉wa? Eta hidodawa puliyala, Godoko kapiyate hidodawanomola. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ama꞉ Godokono Tutumu Tabo iya꞉tawala. Lumagi akanakapuma꞉la꞉, eta lumagino kamena pilolo akalawa꞉la꞉, ilina pilolo akuwata꞉la꞉, eta lumagino komoma꞉ ha꞉da tabo akolamaga꞉la꞉, lumagino ilina ha꞉da gabodo akuwata꞉la꞉, ba꞉gala amia꞉no nabiwi menoko ibino tabamo na꞉papamiwatanakuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Huiyatiya ebete Ya꞉sutamo na꞉goiya꞉, “Iya꞉tulamedawa, na deha꞉poto tetene tupuimiti ba꞉moi hiliyonomo tutumu kodakodalo uwatete eta kapiya kadikanaliya꞉ha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ba꞉bene Ya꞉suti ebe uminate malemaletelo ebe na꞉goemiya꞉, “Kapiya komote ama꞉godolo kamodobonaha꞉. Wadiyala ama꞉ tote, komopa꞉te amia꞉no ilina hiliyonomo mana꞉mo uwatehomete, ama꞉le ba꞉bi mani awaepa꞉tamo dito na꞉nikalamehola꞉. Ba꞉ba tetelo ama꞉ gala kapete na na꞉ta꞉maheniya꞉, ba꞉bene amia꞉no ilina hiliyonomate Godokono Hunu Habalo konepola꞉nama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ebete ba꞉be taboma꞉ dopo menemenenomoma꞉ eda꞉te tepo menemena꞉go dito tuya꞉, mabu ebe ilina dogodogodawanomola. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ba꞉bema꞉ Ya꞉suti ebe ta꞉matapi ulameholelo na꞉goelamiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ilina hiliyonomagopa꞉te ba꞉be habamo na꞉pa꞉la꞉hama꞉ kodakodanomola!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ba꞉ba tetelo ebe ta꞉matapa꞉te ebeno taboma꞉ na꞉hanohanohutiya꞉, ba꞉bene Ya꞉suti iba꞉tamo gala na꞉kagoiya꞉, “Naeno ekaka꞉la꞉, Godote Ko Gawadubuma꞉ deda꞉na, tawakaluba꞉te ba꞉be habamo na꞉pa꞉la꞉hama꞉ kodakodanomola! ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Numa꞉la꞉, ka꞉molo-goete kaliko akohomehoeno ola gugudu nilupiga kodakodama꞉ eda꞉na, gabohenola. Ba꞉ atumu ilina hiliyonomagodawate Godokono Ko Gawadubu habamo na꞉pa꞉ga kodakodanomola, gabote hibinomolo a꞉kitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ba꞉bene iba꞉te konomamo la꞉wa꞉hate ibi ha꞉kiya ibi ipuwalo na꞉ga꞉lutiya꞉, “Ya꞉suti da꞉goe ba꞉be tabote hibima꞉ deda꞉na, puya꞉te modobola꞉ka꞉ Godote ibino ka꞉ka꞉ mula꞉lelamema꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ya꞉suti ibi ulamenate na꞉goiya꞉, “Tawakaluba꞉te ha꞉kiya ibino ka꞉ka꞉ mula꞉le modoboha꞉, huiyatiya Godoko kapiyate modobola mabu ebegodolo helo bitana hiliyonomo komokomo ododilima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ba꞉bene Pitate Ya꞉sutamo na꞉goiya꞉, “Ama꞉ numa꞉, a ilina hiliyonomo miya꞉palete ama꞉ na꞉ta꞉mahenata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ya꞉suti iba꞉tamo gala na꞉kagoiya꞉, “Na la꞉tamo hibi tabo begoemo, kebe lumagiti ebeno genama, o ebeno nani nanikokubi ekaki, o ebeno menokobi nabi gugudi ba꞉gala ebeno hopo, ebete na mabuma꞉ ba꞉gala Godokono Hido Tabo olamagima꞉ ba꞉bi komo da꞉miya꞉palemene, ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ebete ba꞉ma tetelo hiliyonomo genama, nani, nanikokubi, ekaki, menokobi, gugudi, ba꞉gala hopo konomo gala kakuwatema꞉ne. Ba꞉gala ba꞉be atu tetelo tawakaluba꞉te temeteme komo ebetamo kikamehoma꞉na꞉, huiyatiya galane nale ebetamo wiboha꞉ ka꞉ka꞉ kikamema꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Iyo, ba꞉ hibila, ka꞉lo dopopi hiliyonomo da꞉pola꞉na, iba꞉te galane galapima꞉ keda꞉hama꞉na꞉, ba꞉gala ka꞉lo galapi da꞉pola꞉na, iba꞉te galane dopopima꞉ keda꞉hama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉go Yelusalema ko habamo ba tolamita, ebete ibi dopalamete tutiya꞉. Ba꞉ba tetelo ebe ta꞉matapa꞉te ukui bilibilinomoma꞉ eda꞉hutiya꞉, ba꞉gala kebe tawakaluba꞉te ibino gala hapuni da꞉pelamitiya꞉ iba꞉te atumu na꞉katoletolehutiya꞉. Ba꞉bene Ya꞉suti ebeno 12 ta꞉matapi uwatete, ebetamo da꞉pikulimina꞉ ba꞉bi temeteme komoma꞉ ibi ba iya꞉tulame na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“La꞉ nulia꞉la꞉, a Yelusalemamo tolamitama꞉. Ba꞉bolo Godote Tawakalubino Naniwi tawakaluba꞉tamo kikalamema꞉ne, ba꞉bene Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala Godokono Tutumu iya꞉tulamepi, iba꞉te ebe anakapumima꞉ ga꞉late Yuha꞉pa꞉tamo ba꞉bo kikalamema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ba꞉bene ba꞉ba꞉te ebe iya꞉da꞉tete, ebetamo kowe mehoholete, giya꞉pa꞉pa꞉mo ebe a꞉na꞉miga꞉titi kanakapumima꞉na꞉, huiyatiya ebete netewa-kapiya hegelalo hoene gala kakamahigama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ba꞉bene Sebedikono gugudi Ya꞉imesiko ba꞉gala Yoneko iba꞉te pete Ya꞉sutamo na꞉pega꞉luya꞉, “Iya꞉tulamedawa, a ubila ale ama꞉ bada komoma꞉ da꞉ga꞉lamemena꞉, nikaa꞉miya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ya꞉suti ibi na꞉goelamiya꞉, “La꞉ bada komo ubila꞉ka꞉ nale la꞉tamo ikalamema꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Iba꞉te tabo ba huiya na꞉ga꞉luya꞉, “Ama꞉le Ko Gawadubuma꞉ deda꞉mena꞉, a ubila ama꞉le da꞉goemena꞉ etate amia꞉no tu hapulu ba꞉gala etate pele hapulu amia꞉no konomo alo ipuwalo kolumutitama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Huiyatiya Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉le na hido ukuia꞉mo kaga꞉lanamitaha꞉. La꞉ modobola꞉ka꞉ nale da꞉nimo ba꞉be temeteme kalila꞉mo niho? La꞉ modobola꞉ka꞉ Godote na hoe komamo dadunatenemene ba꞉be komamo la꞉ wadulatele?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Iba꞉te na꞉ga꞉luya꞉, “A modobola.” Ya꞉suti iba꞉tamo na꞉goiya꞉, “Ba꞉moe komo ba꞉ hibila, nale da꞉nimo galane tetelo la꞉ ba꞉ atumu ba꞉be kalila꞉mo nihote temeteme bulihonakomata, ba꞉gala Godote na dadunatenemene ba꞉be hoe komamo la꞉ kowadulatelema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Huiyatiya naeno tu hapuamo ba꞉gala pele hapuamo ahidi komoma꞉ nale a꞉kagaa꞉mo. Godote puya꞉tamo da꞉hiduilamiya꞉ ba꞉binomate ba꞉bolo kopola꞉nama꞉na꞉, iyo, ba꞉moe komoma꞉ ebete ha꞉kiya kogoema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ba꞉bene komo ta꞉ni Ya꞉suku ta꞉matapa꞉te ba꞉be komo uliti, Ya꞉imesiko ba꞉gala Yoneko iba꞉tamo na꞉maubahalitiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","huiyatiya Ya꞉suti ibi hiliyonomo ebetamo ka꞉lamiti ibi na꞉goelamiya꞉, “La꞉ iya꞉tawahala, Godoko hibima꞉ midiha꞉pino koko dubate ibi ha꞉kiya ibi ba wadiya꞉paa꞉latele komo tawakalubi heloamo kiyahalamenaka, iba꞉te ibino ubi komamo kopapamila꞉halenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Huiyatiya la꞉ ba꞉bakopima꞉ a꞉keda꞉hamata. Kebe lumagiti la꞉eno koma꞉ eda꞉ ubi dihatemene, ebete la꞉eno huiyaha꞉ okodawama꞉ neda꞉mene, ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ba꞉gala kebe lumagiti dopoma꞉ eda꞉ ubi dihatemene, ebete la꞉ hiliyonomoeno du genamoeno okodawama꞉ neda꞉mene, iyo, ebe ha꞉kiya ebe hoponomamo ihatenomo nihata꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Numa꞉la꞉, Tawakalubino Naniwiti da꞉piya꞉, ebe ubihinola ba꞉moe hopo tawakaluba꞉te ebetamo huiyaha꞉ okopima꞉ eda꞉ha, huiyatiya ebete na꞉piya꞉ tawakaluba꞉tamo huiyaha꞉ okodawama꞉ kopeda꞉ma꞉, ba꞉gala ebeno ka꞉ka꞉ gobogobamo ihatete ebeno hoe huiyate komo hiliyonomo tawakalubi Saitanakono du genamane dito kuluhukulatelema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ba꞉ba tetelo Ya꞉suti ebe ta꞉matapa꞉go Yeliko ko habamo pelamete, ba꞉bene iba꞉te komo tawakalubi hiliyonomago kapimilo ba꞉be habane ikuliti ba tolame, Timiyasikono gudu Batimiyasiko baidi tamiho dubula, ebete gabo tamelo ba luta komo tawakalubi manima꞉ ba꞉bo toelameholitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ba꞉bene ebete Nasaletenapi Ya꞉sukunu pe komo uliti ibulunomamo na꞉goiya꞉, “Ya꞉su, Da꞉ibidikono Hogo! Ama꞉ na na꞉malemalenatena꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ba꞉ba tetelo komo hiliyonomo tawakaluba꞉te ebe kiyahamelo na꞉duhimiya꞉ ebete tatabalo kolutama꞉, huiyatiya ebete gala ibulunomamo na꞉kagoiya꞉, “Da꞉ibidikono Hogo! Ama꞉ na na꞉malemalenatena꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ba꞉bene Ya꞉suti ba꞉bamo utiti na꞉goiya꞉, “La꞉ ebe mamo na꞉ka꞉ma꞉la꞉.” Ba꞉bene iba꞉te ba꞉be baidi tamiho dubu ba ka꞉mi ebetamo na꞉ga꞉luya꞉, “Na꞉kalakala, ebete ama꞉ bepeka꞉mitata! Na꞉mahiga!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ba꞉ba tetelo ebete ebeno atuino kaliko tama꞉mo a꞉da꞉nate, tiyonomo mahigate Ya꞉sutamo ba꞉bo piya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ba꞉bene Ya꞉suti ebe nalatediya꞉, “Ama꞉ bada ubi kihatiuta nale ama꞉tamo kododima꞉?” Baidi tamiho dubuti na꞉goiya꞉, “Iya꞉tulamedawa, na ubila ilina hidamo kulamema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ya꞉suti ebe na꞉goemiya꞉, “Ama꞉ na꞉toa. Amia꞉no hibima꞉ midi komote ama꞉ a꞉hiduima꞉ta,” ba꞉bema꞉ hibila, ba꞉ba tetenomolo ebeno baiditi da꞉hidohidohuya꞉, ebete ba꞉be gabodo Ya꞉suku ba꞉bo ta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ba꞉bene iba꞉te Yelusalema ko haba tama꞉mo ba pelame, Betapa꞉gi haba ba꞉gala Betani haba tamedo tolamete Olibi Kehakeha Hunu Hakamo ba꞉bo nikuliya꞉. Ba꞉ba tetelo Ya꞉suti ebe ta꞉matapi netewa dopamo ba noelame ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ibi na꞉goelamiya꞉, “La꞉ ba꞉be tatali habamo tote, ba꞉be habamo da꞉nuluhukuma donoki-goe deha꞉poto hala꞉mo ma꞉home konuma꞉digama꞉nemata, lumagiti dopamo ebe hunamo kemediya꞉ha꞉. Wadiyala la꞉le hale pahamiti na꞉magahiya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Etate la꞉tamo da꞉goemene, ‘La꞉ ba꞉moe komo badama꞉ kododiutama?’ la꞉ huiyatiya ba꞉ma ka꞉na na꞉ga꞉luya꞉la꞉, ‘Kodawate donoki-goe ubila, ebete gala tiyonomo kakapoemema꞉ne.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ba꞉bene iba꞉te tote, gabolo donoki-goe deha꞉poto gigiho tamelo ma꞉home numiti hale ba꞉bo nepahamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ba꞉bema꞉ puya꞉te ba꞉bolo da꞉pola꞉nuya꞉ iba꞉te ibi nalateda꞉liya꞉, “La꞉ hale bada mabuma꞉ ka꞉pahamiutama?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ba꞉bene Ya꞉suti ibi netewapa꞉tamo dopamo kebe tabo ka꞉goiya꞉, iba꞉te ba꞉be atu tabo ibi da꞉kiyalamiya꞉ ba꞉bi tawakaluba꞉te ibi dito miya꞉paliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba꞉bene iba꞉te ba꞉be donoki-goe deha꞉poto Ya꞉sutamo magahete, ibino watuino kaliko donoki-goe hunamo miya꞉temete, Ya꞉suti ba꞉bi kaliko hunamo ba꞉bo emediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ba꞉ba tetelo komo hiliyonomo tawakaluba꞉te ibino ga꞉ga꞉ga꞉ kaliko pipikulamete gabamo apohohago tolamiya꞉, ba꞉gala komopa꞉te gabo tametamene ele iya꞉hiliti gabamo atumu kamiya꞉teholenatuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ba꞉bene puya꞉te da꞉dopuya꞉ ba꞉gala Ya꞉sukunu gala hapuni da꞉pelamitiya꞉, ibi hiliyonomate ibulunomamo ba꞉ma ka꞉na ga꞉lutiya꞉, “Godoko nadipata꞉la꞉! Godo, amia꞉no mahilago da꞉pita, wadiyala ama꞉ ba꞉be lumagi na꞉koimiya꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Iyo, aeno iniwa nabiwi Da꞉ibidikono hogote Ko Gawadubuma꞉ deda꞉na, wadiyala ama꞉le ebe na꞉koimiya꞉! O tawakaluba꞉la꞉, la꞉ Godoko milimiholo hunamo nadipata꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ba꞉ba tetelo Ya꞉suti Yelusalema ko habamo na꞉pa꞉gate, Godoko Adikumino Hiya꞉ Genamamo nodolote ilina hiliyonomo ulamehola꞉go ba꞉bo petuya꞉, ba꞉bene da꞉gapogapohoniya꞉ ebete Betani habamo gala na꞉katoniya꞉ ebeno 12 ta꞉matapa꞉go. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Eta hegelalo iba꞉te Betanini gala da꞉kapelamitiya꞉, gabo tetelo Ya꞉suku baa꞉ kape komo ba piya꞉tawa, ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ebete anahu keha pahagoeno muhulamo pumiti, gao oholema꞉ ba꞉bamo dito tuya꞉. Huiyatiya ebete ba꞉bamo da꞉nuluhukuya꞉ pahanomuya nulamiya꞉, mabu ba꞉be tete anahu gao kehoeno noloho teteha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ba꞉bema꞉ ebete ba꞉be anahu kehatamo na꞉goiya꞉, “Emedena tetelo tawakaluba꞉te ama꞉godone gao a꞉kanahanakamena꞉!” Ba꞉be tabo ebe ta꞉matapa꞉te uliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ba꞉bene iba꞉te Yelusalemamo nikuliti Godoko Adikumino Hiya꞉ Genamamo tolamete, ba꞉be genamalo Ya꞉suti ilina kolowamipi nulamete helonomamo neta꞉malateliya꞉, ba꞉gala ebete mani oweheta꞉midahalepino patapata gimai kolowamipino ahidi patapatago ba꞉bo nohoba꞉midahalelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ba꞉gala Yelusalemanapa꞉te ibino ilina hapuhapuni da꞉wadahenakui, iba꞉te ba꞉bi ilinago Godokono Genamoeno kala ipuwado palehawaminanakui hapudu da꞉nikulinakui, Ya꞉suti ibi ba꞉be mabuma꞉ duhilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ba꞉ba tetelo ebete tawakalubi ba iya꞉tulame na꞉goiya꞉, “Ba꞉ hibila, Godokono Bukalo tabo ba꞉ma ka꞉na bitana, ‘Naeno Genama hiliyonomo hiya꞉hiya꞉ hopo tawakaluba꞉te Godoko Adikumi Genamama꞉ koga꞉lama꞉na꞉, la꞉le huiyatiya pilo tawakalubino genamama꞉ a꞉midimata!’” ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ba꞉bene Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala Godokono Tutumu iya꞉tulamepi, iba꞉te ba꞉be tabo uliti Ya꞉suku anakapumima꞉ gabo bohowaditiya꞉, huiyatiya iba꞉te ebe na꞉tolemitiya꞉ mabu hiliyonomo tawakaluba꞉te ebeno iya꞉tulame komoma꞉ hanohanoholo na꞉kalakalahutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ba꞉bene da꞉gapogapohoniya꞉ Ya꞉suku ba꞉gala ebe ta꞉matapi ba꞉be ko habane gala na꞉kikuliniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Eta hegela duiduiyanomolo iba꞉te ko habamo gala ba kapelamita, anahu kehate hahane tupuimiti apa꞉mo puluhuku kaloloma꞉ eda꞉ ba꞉bo pumiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ba꞉bene Ya꞉suti dopamo bada tabo da꞉goi, Pitate ba꞉be komo emalagidolote Ya꞉sutamo na꞉goiya꞉, “Iya꞉tulamedawa, numa꞉! Ama꞉le da꞉kiyahami ba꞉be anahu kehate ba꞉ kaloloma꞉ edi!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “La꞉ Godoko hibima꞉ na꞉mida꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na la꞉tamo hibi tabo begoemo, kebe lumagiti hibima꞉ midilo ba꞉moe hakatamo ba꞉ma ka꞉na da꞉goemene, ‘Ama꞉ kehaha꞉ kolomamo na꞉toatepa!’ ba꞉bene ebete tepo ipuwalo ukui netewama꞉ eda꞉heno, ba꞉be komote uluhukuma꞉ hibima꞉ da꞉midimini, ebete ba꞉be komo hibilo kumima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ba꞉bema꞉ nale la꞉ na꞉goelamemata, la꞉ bada komoma꞉ Godoko da꞉toemehoma, la꞉ ba꞉be komo ya꞉lo lawema꞉ ga꞉lalo hibima꞉ na꞉mida꞉la꞉, ba꞉bene la꞉ ba꞉be komo hibilo kolawema꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ba꞉gala keba tetelo la꞉le mahila꞉hate Godotamo toetoe tabo dolamagimima, ba꞉bene eta lumagitamo mauba komote ditanamene, la꞉ ba꞉be lumagino kuba egebolemete nadodoholemiya꞉la꞉, ba꞉bene la꞉eno Hunu Haboeno Nabiwiti la꞉eno kuba egebolelamete atumu kakadodoholelamema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Huiyatiya la꞉ tawakalubino kuba egebolelamete adodoholelameheno, la꞉eno Hunu Haboeno Nabiwiti la꞉eno kuba egebolelamete a꞉kadodoholelama꞉mena꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ba꞉ba tetelo Ya꞉suku ba꞉gala ebe ta꞉matapi Yelusalema ko habamo gala na꞉kapikuliya꞉. Ba꞉bene ebete Godoko Adikumino Hiya꞉ Genamalo ba nepata꞉, Godotamo hawa꞉goeno ikamehopino watowatopi, Godokono Tutumu iya꞉tulamepi, ba꞉gala komo koko dubu, iba꞉te ebetamo pelamete ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ebe ba꞉ma ka꞉na palatediya꞉, “Ama꞉ ba꞉moi komo pokono heloamo kododiliona? Ba꞉gala ba꞉moe helo pote kikameti, ama꞉le ba꞉moi komo kododilinama꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Huiyatiya Ya꞉suti iba꞉tamo na꞉goiya꞉, “Nale kapiya komoma꞉ la꞉ kalateda꞉lema꞉nemata. La꞉le na huiya tabo hidamo da꞉ga꞉lanamema, ba꞉bene nale ba꞉moi komo pokono heloamo kododilinamo, ba꞉be komo nale la꞉ ba꞉bo kokiyalamema꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Naeno alateda꞉ tabo ma kumu bitana la꞉tamo, Yonete tawakalubi beyamo da꞉wadulatelenakui, ba꞉be helo ebetamo pote kikami, Godotela꞉ka꞉ o eta lumagitila꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ba꞉bema꞉ ibi ha꞉kiya ibi ipuwalo olowabeletihuilo na꞉ga꞉luya꞉, “Ale da꞉ga꞉lama꞉ Godote Yonetamo helo ikami, ebete kogoema꞉ne, ‘Mabu keka꞉ la꞉le ebeno tabo hibima꞉ kamidiha꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ba꞉gala a modoboha꞉ ebe ba꞉ma ka꞉na ga꞉lame, hopo lumagiti Yonetamo helo ikami.” Iba꞉te tawakalubino mauba komoma꞉ toletoleholo tabo ba꞉ba ka꞉na ga꞉luya꞉, mabu ibi iya꞉tawahala tawakalubi hiliyonomate Yoneko Godokono hibi ukui hawakalimidawama꞉ ga꞉lana. ");
INSERT INTO knv_aramia_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ba꞉bema꞉ iba꞉te ibino tepo ipuwoeno ukui ugumuililo Ya꞉sutamo na꞉ga꞉luya꞉, “Yonekono helo mabu a iya꞉tawaha꞉.” Ba꞉ba tetelo Ya꞉suti iba꞉tamo na꞉goiya꞉, “Ba꞉bema꞉ nale la꞉ atumu a꞉kakiyalama꞉mata nale ba꞉moi komo pokono heloamo dododilinamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ba꞉bene Ya꞉suti eta uwi tabamo ibi ba꞉ma ka꞉na iya꞉tulamiya꞉, “Dubuti pali ododiti tupina gao keha ba꞉bo amihui, ba꞉be gaoeno mahilo ba꞉ gala꞉ipi gaola. Ba꞉bene amiho komote da꞉wibui, ebete kala imiti, gao ihi adilutihoeno nakola bobo aligiti, pali lawamepino hunu mimiya ba꞉bo eti. Ba꞉ba tetelo ba꞉be dubuti ebeno pali komo lawamepi dubatamo dito miya꞉pui, iba꞉te ba꞉bolo oko ba owatina ba꞉be pali hidamo umilo ebeno gao kuwateholemenakoma꞉, ba꞉bene ebete muhulu hopamo ba꞉ dito tui. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Ba꞉bene gao tapiho tete da꞉pi ebete pali lawamepa꞉tamo huiyaha꞉ okodawa na꞉poemi, ebete iba꞉godone gaoeno mani ipuwane ebeno namutudawoeno komo kopelawema꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","huiyatiya iba꞉te ebe lawete kukamo anagalimihote ilinaheno dito noemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ba꞉bene pali namutudawate eta huiyaha꞉ okodawa gala da꞉kapoemi, huiyatiya iba꞉te ebe watolo ba kanagalimiho ebe hilopo ikamete atumu dito koemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ba꞉bene ebete gala eta huiyaha꞉ okodawa da꞉kapoemi iba꞉te ebe anakapumiya꞉. Ba꞉bene komo huiyaha꞉ okopi hiliyonomate da꞉pelami, iba꞉te ba꞉ atumu komo alukuliti dito oelamiya꞉, huiyatiya iba꞉te komo anakapulamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ba꞉bene namutudawagodolo eta kapiya nemedenami, ba꞉be gudu ebete konomamo emalagidolonami. Ba꞉bema꞉ galanomone ebete ba꞉be gudu ba poeme ebeno ukuilo na꞉goi, ‘Hibila, iba꞉te naeno gudutamo kopapamila꞉hama꞉na꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ba꞉bi pali lawamepi dubate huiyatiya ibi ipuwalo na꞉ga꞉luya꞉, ‘Numa꞉la꞉, ba꞉moe guduti nabiwino ilina namutudawama꞉ deda꞉mene, ba꞉be guduti ba꞉ na꞉pe. Ba꞉bema꞉ wadiyala ale ebe anakapumiti ebeno pali lawenomo kolawema꞉nema꞉,’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ba꞉bene iba꞉te ebe lawete anakapumiti palino kala ipuwane ba꞉ dito na꞉da꞉nuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ba꞉bema꞉ Ya꞉suti ulihopa꞉tamo na꞉goiya꞉, “La꞉eno ukui keba ka꞉nala꞉ka꞉, pali namutudawate bada komo na꞉kododimini? Hibila, ebete pete pali lawamepi panakapulamete ebeno pali komopa꞉tamo kopikalamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Iyo, la꞉ dopamo Godokono Bukalo ba꞉moe tabo hibilo a꞉ka꞉lamiholia꞉mata, ‘Genama etepa꞉te tama꞉mo dihati, ba꞉be hototote huiyatiya genamoeno helo mabuma꞉ eda꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ba꞉moe komo ba꞉ Godote ododi, ba꞉bema꞉ aeno ukuilo na꞉hanohanohutama꞉!’” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ba꞉bema꞉ Yu watowatopi dubate Ya꞉suku lawe ubila mabu ibi iya꞉tawahala ebete ba꞉be uwi ibino komoma꞉ olamagiya꞉, huiyatiya iba꞉te tawakalubi tolelamelo ebe miya꞉pate dito tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ba꞉bene Yu watowatopa꞉te komo Pa꞉lisi kapiyuimipi ba꞉gala Ko Gawadubu Helodikono kapiyuimipi Ya꞉sutamo oelamiya꞉, iba꞉te ebe kuba gabamo ba nemogabuimi ebete kebako tabo goelo ebe ba꞉bo kolawema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Iba꞉te ebetamo pelamete ha꞉da amiho gabodo na꞉pega꞉luya꞉, “Iya꞉tulamedawa, a iya꞉tawahala ama꞉ hibi lumagilata. Ama꞉ komopino dito ga꞉la komamo a꞉kapapamiwatala꞉ta, ba꞉gala ama꞉ tawakalubi hunu nikapa꞉mo kulamenaha꞉, ba꞉ma ka꞉na eta lumagi miya꞉palo eta lumagi ebo a꞉kalawa꞉la꞉ta. Iyo, ama꞉ tawakalubi Godokono gabo hidamo iya꞉tulamenata, ba꞉bema꞉ a na꞉kiyaa꞉ma꞉, Loma tawakalubino Konomo Gawadubu Sisatamo ta꞉kese mani ikameho hidola꞉ka꞉ o kubala꞉ka꞉? A ebetamo ba꞉kikamehoma꞉ o a꞉kikamehama꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Huiyatiya Ya꞉suti ibino ma꞉lapila netewa komo iya꞉tawate iba꞉tamo na꞉goiya꞉, “Mabu keka꞉ la꞉le na ha꞉da amihonamema꞉ dewagelitama? La꞉ mani kapiya natamo nikanama꞉la꞉, nale kumima꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ba꞉bene iba꞉te mani kapiya ebetamo dikamiya꞉, ebete ibi nalateda꞉liya꞉, “Ba꞉moe manilo da꞉pola꞉na, mahilo ba꞉gala holoholo pokonola꞉ka꞉?” Iba꞉te na꞉ga꞉luya꞉, “Konomo Gawadubu Sisakonola.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Sisakono ilina Sisatamo nikamehala꞉, huiyatiya Godokono ilina Godotamo nikamehala꞉.” Ba꞉bema꞉ iba꞉te ebeno taboma꞉ koamo hanohanohutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hoe ipuwane mahila꞉haleha꞉ma꞉ da꞉ga꞉lana, ba꞉bi tawakalubi ba꞉ Sa꞉diyusi kapiyuimipila. Komo iba꞉te Ya꞉sutamo pelamete tabo ba꞉ma ka꞉na pega꞉luya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Iya꞉tulamedawa, Godokono Bukamo Mosesete tabo ba꞉ma ka꞉na miya꞉tiya꞉, ‘Dubuti hoete kamena gugudihino da꞉miya꞉pamene, ebeno ekawiti ba꞉be hamole lawete ebeno naniwi mabuma꞉ gugudi nododilima꞉mene.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kapiya dubuino sa꞉ba꞉ni kuhia꞉te nemedenama꞉. Ibi ipuwalo dopo guduti kamena lawete gugudi ulameheno hoiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ba꞉bene ebeno ekawiti atu kamena kalawete gugudi ulameheno dito kahoiya꞉, ba꞉gala eta tetedawate ba꞉ atumu kewageliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ba꞉bene ba꞉bi sa꞉ba꞉ni badininipalate gugudihino ba꞉ba ka꞉na ha꞉lahuya꞉, huiyatiya kamenate galane dito hoiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ba꞉bema꞉ iba꞉te hoe ipuwane ka꞉ka꞉mo da꞉mahila꞉halemena꞉, ba꞉be Ko Hegelalo ba꞉be kamenate pokono kamenama꞉ na꞉keda꞉mene, mabu ebe sa꞉ba꞉ni dubate a꞉lawa꞉tepahuya꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Mabu la꞉ Godokono Buka tabo ba꞉gala ebeno helo iya꞉tawaha꞉, ba꞉be mabuma꞉ la꞉eno ukuilo tawakalubino ha꞉laha komoma꞉ kubamo ga꞉lanakomata. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Numa꞉la꞉, tawakaluba꞉te hoe ipuwane ka꞉ka꞉mo da꞉mahila꞉halemena꞉, ba꞉ba tetelo iba꞉te gala kamenakamena a꞉kapuwatehola꞉mena꞉ ba꞉gala dubu a꞉kapuwatehola꞉mena꞉, huiyatiya iba꞉te Godokono Hunu Haboeno nopopimo bemedehonamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ba꞉be mabuma꞉ Godokono Bukate a biya꞉tua꞉mena ha꞉lahapa꞉te hoe ipuwane mahila꞉halema꞉. Iyo, Mosesete dihatiya꞉ ba꞉be tabo la꞉ hibilo a꞉ka꞉lamiholia꞉mata, ba꞉ma ka꞉na koete kehalo da꞉woitiya꞉ huiyatiya kehate ka꞉mutigutiya꞉ha꞉, ba꞉ba tetelo Godote Mosesetamo na꞉goiya꞉, ‘Na ba꞉ Godotela. A꞉ibalahamako, Aisa꞉keko, ba꞉gala Ya꞉ikoboko, iba꞉te emedena tetelo poko kadikumina, na ba꞉ ba꞉betela.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ba꞉bema꞉ la꞉ Sa꞉diyusi kapiyuimipi, la꞉eno ukuilo na꞉kemalagidolonama ba꞉bi iniwalino ka꞉ka꞉te a꞉wibuya꞉? Ao, kawibuya꞉ha꞉, mabu ha꞉lahapa꞉te Godoko a꞉kadikuma꞉la꞉ huiyatiya puya꞉te da꞉ka꞉ka꞉halena ba꞉bi tawakalubinomate ebe badikumina. Ba꞉moe ba꞉be mabuma꞉ la꞉ Sa꞉diyusi kapiyuimipa꞉te tawakalubino ha꞉laha komoma꞉ kubamo ga꞉lanakomata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ba꞉bene eta Godokono Tutumu iya꞉tulamedawate pete, iba꞉te da꞉ga꞉lutiya꞉ ba꞉be tabo ba꞉bo puliya꞉. Ya꞉suti Sa꞉diyusi kapiyuimipa꞉tamo tabo hidamo dolamagiya꞉, ba꞉be komo umiti ebete Ya꞉suku nalatediya꞉, “Kebe tutumu tabote konomoma꞉ keda꞉na?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ya꞉suti na꞉goiya꞉, “Ba꞉moe ba꞉ konomo tutumula, ‘Isalaela tawakaluba꞉la꞉, la꞉ nulia꞉la꞉! Godoko aeno Kodawala, ebe ba꞉ kapiyanomola, eta puliyala. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ama꞉ amia꞉no Kodawa Godoko malemalelo nemalagidolona, amia꞉no tepo ipuwanomamo ba꞉gala amia꞉no gobogoboeno heloamo, amia꞉no ukui konomamo ba꞉gala amia꞉no helo konomamo.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ba꞉gala ba꞉moe ba꞉ eta konomo tutumula. ‘Ama꞉ ha꞉kiya ama꞉ demalagidolona, wadiyala ama꞉le ba꞉ ba꞉ba ka꞉na ama꞉ tamelo demedena ba꞉be lumagi malemalelo nemalagidolona.’ Eta tutumu tabote ba꞉moi koko tutumu netewa a꞉kagogola꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Godokono Tutumu iya꞉tulamedawate Ya꞉sutamo na꞉goiya꞉, “Iya꞉tulamedawa, hibila, ama꞉ hidamo gaa꞉ta. Aeno Kodawa Godoko ba꞉ kapiyanomola, eta puliyala, kemedenaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Lumagiti ebeno tepo ipuwanomamo ba꞉gala ebeno gobogoboeno heloamo, ebeno ukui konomamo ba꞉gala ebeno helo konomamo ebete Godoko malemalelo nemalagidolonamene. Ba꞉gala ebe ha꞉kiya ebe demalagidolona, ebete ba꞉ ba꞉ba ka꞉na ebe tamelo demedehona ba꞉bi tawakalubi malemalelo nemalagidolenamene. Ba꞉ hibila, ba꞉moi netewa tutumate kokonomoma꞉ eda꞉hana, huiyatiya Godotamo ikameho komate kokoma꞉ keda꞉hanaha꞉, iyo, tawakaluba꞉te koelo wamote sipi-goegoe ba꞉gala komo malemale ilina Godotamo dikamehonaka, ebete ba꞉bi hiliyonomo komo koko komoha꞉ma꞉ goena.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ebete tabo hidamo da꞉goiya꞉, Ya꞉suti uliti ebetamo na꞉goiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be habamo ama꞉ a꞉pa꞉gama꞉ ba꞉ tatalila.” Ba꞉ hibila, ba꞉ba tetene tupuimiti tawakaluba꞉te Ya꞉suku eta komoma꞉ alateda꞉ma꞉ na꞉toletolehutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ba꞉bene Ya꞉suti Godoko Adikumino Hiya꞉ Genamalo tawakalubi ba iya꞉tulamita na꞉goiya꞉, “Godokono Tutumu iya꞉tulamepa꞉te na꞉ga꞉lana Godokono Oemedawa Kelisoko ba꞉ Da꞉ibidikono hogola, ebeno eyoni gugudi ipuwane komahigama꞉ne. Huiyatiya ba꞉moe komoeno ipuwa keba ka꞉nala꞉ka꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Numa꞉la꞉, Da꞉ibiditi Godokono Gobogoboeno heloamo tabo ba꞉ma ka꞉na olamagiya꞉, ‘Kodawa Godote naeno Kodawa Kelisotamo na꞉goe, ‘Ama꞉ naeno tu hapuamo na꞉pemeda꞉, ba꞉bene ama꞉go alaholohopi ama꞉le naeno heloamo ibi komikimoelema꞉na꞉ta.’ ’” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ba꞉bene Ya꞉suti tabo moga꞉melo gala na꞉kagoiya꞉, “La꞉ ba꞉moe tabo ba emalagidolo na na꞉kiyanama꞉la꞉, Da꞉ibiditi ebeno hogo Kelisoko ebeno Kodawama꞉ ka꞉milo ebete Godokono tu hapuamo emedema꞉ goiya꞉, ba꞉bema꞉ ba꞉be komote keba ka꞉na na꞉kuluhukumini?” Ba꞉ hibila, ba꞉ba tetelo hiliyonomo tawakaluba꞉te Ya꞉sukunu tabo kalakalago ulihutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ba꞉bene Ya꞉suti tawakalubi ba iya꞉tulamita, ebete na꞉goiya꞉, “La꞉le Godokono Tutumu iya꞉tulamepi hidamo nulama꞉la꞉. Ibi ubila ga꞉ga꞉ga꞉ kaliko pupuliti kolowami habalo ba wapata꞉lame, tawakaluba꞉te ibi ba꞉bo kawagaminalema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Iyo, ibi ubila a Yunapino baidi ibubulamehole genama gulu koko dubuino habalo kogagahidima꞉, ba꞉gala ibi ubila poko ododi tetelo koko habalo ahiditi kopola꞉nama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ba꞉gala iba꞉te hamolehamoleno ilina ha꞉da amihoho komodo ba uwate ba꞉bo wibuilamelelamenaka, ba꞉bene iba꞉te ba꞉be komo kubaha꞉ma꞉ ga꞉lalo tolamete Godotamo baidi ba nibubulamehole ga꞉ga꞉ga꞉ toetoe tabo ba꞉bo nega꞉lanaka, mabu ibi ubila tawakaluba꞉te ibino komo umilo ibi hidohidopima꞉ koga꞉lama꞉. Ba꞉be mabuma꞉, hibila, iba꞉te kuba huiya konomo kolawema꞉na꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ba꞉bene Godoko Adikumino Hiya꞉ Genamalo tawakaluba꞉te mani ba miya꞉tita, Ya꞉suti ba꞉be haba tamelo emedete tawakalubino mani miya꞉te komo bulamitiya꞉. Komo ilina dogodogopa꞉te mani kokonomo bimiya꞉titiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ba꞉bene eta ilinaha꞉ hamole kamenate pete mani hegehege netewa, kapiya toea huiyala, ebete ba꞉bo pimiya꞉tiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ya꞉suti ebe ta꞉matapi ebetamo ka꞉lamiti na꞉goiya꞉, “Na la꞉tamo hibi tabo begoemo, tawakaluba꞉te mani da꞉pemiya꞉ta꞉, ba꞉moe ilinaha꞉ hamole kamenate ibi hiliyonomo a꞉gogole, ");
INSERT INTO knv_aramia_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","mabu ilina dogodogopa꞉te ibino komo ilina da꞉luhililamenaka ba꞉bi ilina bepemiya꞉ta꞉, huiyatiya ba꞉moe hamole kamena ilinahenola. Ebete ebeno kuititi mani miya꞉tenomo a꞉pemiya꞉te, ba꞉ ebeno baa꞉ uwatehoeno manila.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ba꞉bene Ya꞉suti Godoko Adikumino Hiya꞉ Genamane ba pihitiguta, ebeno ta꞉matapi ipuwalo etate na꞉goiya꞉, “Iya꞉tulamedawa, ama꞉ nulama꞉. Ba꞉moi nakola genama hiya꞉hiya꞉nomola ba꞉gala hidohidonomola!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ya꞉suti huiyatiya ebetamo na꞉goiya꞉, “Ama꞉ ba꞉moi koko genama bekulamiuta? Ba꞉moi genamoeno komoma꞉ eta nakolate eta nakola hunulu a꞉kapola꞉namena꞉, mabu alaholohopa꞉te nakola hiliyonomo mapitahalete hopamo iya꞉hekenomo kopiya꞉hekema꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ba꞉bene Ya꞉suti Olibi Kehakeha Hunu Hakalo ba luta, Godoko Adikumino Hiya꞉ Genama hapuamo umilo lutiya꞉. Ba꞉ba tetelo Pitako, Ya꞉imesiko, Yoneko, ba꞉gala A꞉nduluku, ibinomate ebetamo tolamete na꞉nega꞉luya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ama꞉ a na꞉kiyaa꞉ma꞉, Godokono Genama kubahimi komote keba tetelo na꞉kuluhukumini? A bada hanohano komote na꞉kiya꞉tua꞉memene, tete ba꞉ na꞉pe ba꞉moi hiliyonomo komate kopikulihoma꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ hidamo. Eta lumagiti la꞉ ha꞉da damiholamemena꞉, la꞉ ebeno tabo akulia꞉la꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","mabu komo hiliyonomo dubate naeno mahilamo pelamete kopega꞉lama꞉na꞉, ‘Na ba꞉ Kelisotela!’ ba꞉bene iba꞉te tawakalubi hiliyonomo ha꞉da ba꞉ma ka꞉na ba pamiholame hiya꞉ gabamo ba꞉bo komagatalema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ba꞉gala la꞉le hiya꞉hiya꞉ hopo tawakalubino alaholoho komo ba꞉gala ibino alaholohoma꞉ nopo tamote komo dulihoma, ba꞉be mabuma꞉ la꞉ akatoletolehala꞉. Ba꞉moi komate hibilo kopikulima꞉na꞉, huiyatiya ba꞉be tete ebe kuititi teteha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ba꞉ hibila, komo hopo tawakaluba꞉te komo hopo tawakaluba꞉go kalaholohoma꞉na꞉, iyo, eta hopote etatamo alaholo komo kododima꞉ne, ba꞉bene wima꞉la꞉te hiya꞉hiya꞉ hopo hiliyonomamo kopelamema꞉na꞉, ba꞉gala komo habahabalo tawakaluba꞉te baa꞉heno kemedehoma꞉na꞉. Numa꞉la꞉, ba꞉moe komo ba꞉ kamenate gudu lawema꞉ temeteme da꞉tupuimi ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ba꞉bema꞉ la꞉ la꞉eno komo hidamo nulamenala꞉, mabu kubapa꞉te la꞉ heloamo uwatete tabo anagiya꞉mida habamo komagatalema꞉na꞉ta, ba꞉gala iba꞉te Yunapino baidi ibubulamehole genama gulu la꞉ kukamo kalukulima꞉na꞉ta. Iba꞉te na mabuma꞉ la꞉eno komo danagilamelelamemena꞉, ba꞉ba tetelo la꞉ hiya꞉hiya꞉ koko gawadubuino holoholo hapulu utitatate naeno Hido Tabo iba꞉tamo ba꞉bo kolamagimima꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Iyo, kuititi tete peheno, Godoko ubila dopamo la꞉le ebeno Hido Tabo hiliyonomo hiya꞉hiya꞉ hopolo konolamagimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ba꞉bema꞉ tawakaluba꞉te tabo anagiya꞉mida habamo la꞉ da꞉magatalemena꞉, ba꞉be tetete uluhukuhino la꞉eno ga꞉la komoma꞉ aka-ukuibilibilihala꞉, ba꞉ma ka꞉na, ‘Na bada tabo na꞉ka꞉goemo?’ Tete da꞉pemene Godote kebe tabo komokomamo la꞉ dowalubilimina꞉, wadiyala la꞉le ba꞉bi tabo kapiya nolamagimiya꞉la꞉, mabu hibila, la꞉ ha꞉kiya a꞉kolamagima꞉mata, Godokono Gobogobote la꞉ ipuwado kolamagima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ba꞉ba tetelo naniwiti ekawi hoea꞉mo koemema꞉ne, ba꞉gala atu gabodo ekawiti naniwi kanakapumima꞉ne, iyo, dubuti ebeno gudu ba꞉ atumu kakamitima꞉ne, ba꞉gala guguda꞉te maubahalete ibino menokobi nabi hoea꞉mo koelamema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ba꞉bene na mabuma꞉ tawakalubi hiliyonomate la꞉tamo komaubahama꞉na꞉, huiyatiya kebe lumagiti kodakodalo utiti kuitita꞉mo da꞉nuluhukumini, Godote ebeno ka꞉ka꞉ komula꞉mema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Na Makate buka ka꞉lamiholedawatamo na꞉goemo, ama꞉ ba꞉moe tabo Ya꞉suti da꞉goiya꞉ hidamo niya꞉tawa. Ya꞉suti tabo moga꞉melo gala na꞉kagoiya꞉, “Godokono Genama kubahimidawate ba꞉be talona habalo la꞉nalo la꞉le ebe dumima, ba꞉ba tetelo wadiyala Yudiya hoponapa꞉te hunuhunu hakamo nalahutihamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iyo, genama panalo da꞉lutamene, ba꞉be lumagiti genama guamo gala a꞉kana꞉pa꞉gamene ebeno ilina uwatema꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ba꞉gala tumulu oko dowatitamene, ba꞉be lumagiti gala genamamo a꞉katoamene ebeno atuino kaliko lawema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Numa꞉la꞉, lamitulamitu ba꞉gala nono dikalamena ba꞉bi kamenakamenatamo ba꞉be hegelate kubanomoma꞉ keda꞉ma꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ba꞉bema꞉ wadiyala la꞉ Godoko na꞉toemehuya꞉la꞉ ba꞉moi komate gibagiba tetelo akapikulihala꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","mabu ba꞉ba tetelo kokonomo temetema꞉te kopikulima꞉na꞉. Numa꞉la꞉, Godote ba꞉moe hopo dododiya꞉ ba꞉ba tetene tupuimiti ka꞉lo ba꞉ma teta꞉mo puluhuku, ba꞉bakobako temetema꞉te dopamo kapikuliya꞉ha꞉, ba꞉gala galane tetelo ba꞉bakobako temetema꞉te gala a꞉kapelama꞉mena꞉, kapiya tetenomolo kopikulima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ba꞉moe komo ba꞉ hibila, Kodawa Godote ba꞉be tete gopowahimihino eta lumagiti ba꞉moe hopolo a꞉kemedenamene, huiyatiya ebete pui ka꞉lamiti duwatiya꞉ ba꞉bi tawakalubi malemalelatelelo tete kogopowahimima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ba꞉ba tetelo eta lumagiti la꞉tamo ba꞉ma ka꞉na da꞉goemene, ‘Numa꞉la꞉, Godokono Oemedawa Kelisote ba꞉malo bemedena!’ o, ‘Numa꞉la꞉, ebete ba꞉bolo bemedena!’ la꞉ hibima꞉ akamida꞉la꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","mabu ha꞉da Kelisoma꞉ eda꞉hapi ba꞉gala naeno mahilamo ha꞉da tabo olamagimipi, iba꞉te ikulihote hiya꞉hiya꞉ hanohano komo kododilima꞉na꞉. Iyo, ibi ubila ba꞉bi ododili komamo Godote da꞉ka꞉lamiholiya꞉ ba꞉bi tawakalubi hiya꞉ gabamo komagatalema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ba꞉bema꞉ la꞉ hidamo nulia꞉la꞉, ba꞉moi hiliyonomo komate pikulihino nale la꞉ dopamo kiyalamemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ba꞉be ko temeteme tetete da꞉wibomene, ba꞉ba tetelo hegelate kuduma꞉ne ba꞉gala manomete a꞉ka꞉la꞉minamene, ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","iyo, oloka꞉te alomone hopamo kopigudima꞉na꞉, ba꞉gala alomoeno helohelo ilinate komidiwiholema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ba꞉bene ba꞉ba tetelo Tawakalubino Naniwiti alomo hununi ba pihitiga, iba꞉te ebe ba꞉bo kumima꞉na꞉, ebete ebeno heloago ba꞉gala alo konomago kopema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ba꞉bene ebete Hunu Haboeno nopopi hiya꞉hiya꞉ hopo hiliyonomamo kopoelamema꞉ne, Godote da꞉ka꞉lamiholiya꞉ ba꞉bi tawakalubi ba꞉moe hopo hapuhapuni kopuwatema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“La꞉ anahu kehoeno komone ba꞉moe eta komo hidamo niya꞉tawahala꞉. Gedawoeno huha꞉te pikuliti uliuli paha da꞉mogolamemena꞉, ba꞉be komote la꞉ kiya꞉tulamema꞉na꞉ta gogoeno tete ba꞉ na꞉tatali, ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ba꞉bema꞉ ba꞉moi temeteme komate ikuliholo dulamema, la꞉ kiya꞉tawahama꞉nemata Tawakalubino Naniwino pe tete tatalila, ebe ba꞉ gigihodo a꞉pa꞉gama꞉ pe. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na la꞉tamo hibi tabo begoemo, ba꞉moi hiliyonomo komate dopamo kopikulihoma꞉na꞉, galane ba꞉ma tete tawakaluba꞉te ba꞉bo koha꞉lahama꞉na꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","iyo, ba꞉moe hopo ba꞉gala alomo iba꞉te kowiboma꞉na꞉, huiyatiya naeno tabote a꞉kawibamene, itana tetelo bitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Numa꞉la꞉, tawakaluba꞉te ba꞉be Ko Hegeloeno tete iya꞉tawahaha꞉, Hunu Haboeno nopopi ba꞉gala Godokono Gudu iba꞉te iya꞉tawahaha꞉, Nabiwi Godote ha꞉kiya iya꞉tawala. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ba꞉bema꞉ la꞉ uliholo nemedeniya꞉la꞉, mabu ba꞉be tetete da꞉pemene la꞉ iya꞉tawaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ba꞉moe komote ba꞉ma ka꞉na kitanama꞉ne, eta ko dubuti eta muhulu hopolo konemeda꞉tepama꞉ ebeno genama huiyaha꞉ okopa꞉tamo komiya꞉pama꞉ne iba꞉te hidamo kuminama꞉. Ba꞉bene ebete iba꞉tamo oko hiya꞉hiya꞉ ikalameholete, gigiho umidawa kogoemema꞉ne, ‘Ama꞉ naeno pe teta꞉mo uliholo nemedeniya꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ba꞉bema꞉ la꞉ uliholo nemedeniya꞉la꞉, mabu la꞉ iya꞉tawaha꞉ genama namutudawoeno pe tete, diyala, da꞉ gapogapo tetelola꞉ o du tetelola꞉, da꞉ owaloho hapuamola꞉ o duiduiya tetelola꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Iyo, ebete tiyonomo da꞉pemene la꞉ lahanalo da꞉ pulametamena꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ba꞉bema꞉ nale ba꞉moe tabo la꞉ kapiyatamo kagoeha꞉, hiliyonomo tawakaluba꞉tamo goemo, la꞉ uliholo nemedeniya꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Adaguila꞉ Poko ba꞉gala Hunamo Mahigaha꞉ Palawa Baa꞉ Poko, ibino komo tupuimima꞉ netewa hegelate ba nepola꞉na, ba꞉ba tetelo Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala Godokono Tutumu iya꞉tulamepi, iba꞉te Ya꞉suku anakapumima꞉ tabo ba꞉bo ihatiya꞉, ba꞉bene iba꞉te ebe diya lawema꞉ gabo bohowaditiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Iba꞉te na꞉ga꞉luya꞉, “A Poko tetelo ebe a꞉kalawa꞉ma꞉, mabu tawakaluba꞉te atamo maubahalete ago alaholohodemena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ba꞉bene Ya꞉suti Betani habalo eta dubu Saimonokono genamalo baa꞉ benutiya꞉, ba꞉be dubu dopamo kuitikuita꞉goenola. Ba꞉ba tetelo kapiya kamenate pete, hido nibo ihi nakola kalila꞉mo tabuimi adahete, ebete petokamidate Ya꞉sukunu watamo ba꞉bo pehaminamiya꞉, ba꞉be ihi ilinoeno mahilo ba꞉ nadala, ebeno huiya konomola. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Komo tawakalubi ba꞉bolo da꞉pola꞉nuya꞉, iba꞉te maubahalete ibi ha꞉kiya ibi ipuwalo tabo ba ga꞉la na꞉ga꞉luya꞉, “Mabu keka꞉ ebete ba꞉moe hido nibo ihi gigilepalama꞉ da꞉midi? ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","A ba꞉moe ihi kolowamima꞉ na꞉nimiditale kapiya gogoeno oko huiya mani buwatena꞉, ba꞉bene ba꞉bi mani awaepa꞉tamo dito bikalameholena꞉.” Ba꞉bema꞉ iba꞉te ba꞉be kamena ba꞉bo kiyahamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Huiyatiya Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ ebe na꞉miya꞉pala꞉! Badama꞉ ka꞉kiyahamiutama? Ebete natamo hidonomo komo bododi. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","La꞉ numa꞉la꞉, awaepa꞉te tete ga꞉ga꞉nomolo la꞉go bemedehonamena꞉, la꞉eno ubi tetelo iba꞉tamo malemale ilina ba꞉bo nikalamenakuya꞉la꞉, huiyatiya na emedena tetelo la꞉go a꞉kemedenamo, tete tatalila nale la꞉ komiya꞉palema꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ba꞉bema꞉ hibila, ba꞉moe kamenate natamo hido komo bododi, eta kuba kitanaha꞉. Nale hoeha꞉ tetelo ebete naeno ape bobamo ihatema꞉ gabo bihiduimi, iyo, ba꞉be komo ba emalagidolo ebete naeno apa꞉mo hido nibo ihi ba꞉bema꞉ hamina. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na la꞉tamo hibi tabo begoemo, tawakaluba꞉te hiya꞉hiya꞉ hiliyonomo hopamo Godokono Hido Tabo datanakomena꞉, iba꞉te ba꞉moe kamenate dododi ba꞉be komo emalagidololo ba꞉nolamagiminakomena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ba꞉bene Ya꞉sukunu 12 ta꞉matapi ipuwalo Keliyotanapi Yudasiti Godotamo hawa꞉goeno ikamehopino watowatopa꞉tamo tote, nopo ba꞉bo netamotiya꞉ Ya꞉suku ibino kokotamo kihatema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ba꞉ba tetelo iba꞉te ba꞉be komo uliti kalakalahalo tabo ba꞉bo ihatiya꞉ ebetamo mani kikamema꞉, ba꞉bema꞉ Yudasiti iba꞉godone tote gabo ba꞉bo nohowadiya꞉ Ya꞉suku ibino kokotamo kihatema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yunapino ododi komo ba꞉ ba꞉ma ka꞉nala, iba꞉te hiliyonomo gogolo Hunamo Mahigaha꞉ Palawa Baa꞉ Poko naha da꞉tupuiminakui, ba꞉be dopo hegelalo Adaguila꞉ Pokoma꞉ iba꞉te sipi-goegoe hegehege balukulinakuya꞉. Ba꞉be komo ba emalagidolo Ya꞉suku ta꞉matapa꞉te ebetamo na꞉ga꞉luya꞉, “A tolamete Adaguila꞉ Pokoeno naha ilina kebolo na꞉ka꞉nihiduilamema꞉, ale ama꞉go kapimilo konahama꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ba꞉bene ebete ebe ta꞉matapi netewa ba oelame iba꞉tamo na꞉goiya꞉, “La꞉ ko habamo na꞉toala꞉, ba꞉bene beya dagahita ba꞉be dubuti la꞉go da꞉palugamene, la꞉le ebe ba꞉bo na꞉ta꞉matuya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ebete kebe genamamo da꞉nodolomene, la꞉ ba꞉be genama namutudawatamo ba꞉ma ka꞉na na꞉nega꞉luya꞉la꞉, ‘Iya꞉tulamedawate goe, genama keka꞉ nale naeno ta꞉matapa꞉go Adaguila꞉ Poko baa꞉ kopenama꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ba꞉ba tetelo ebete genama guamo la꞉ komagatalema꞉na꞉ta, hunu genamalo haba ko bitana, ya꞉lo a꞉hiduima꞉ka. La꞉ ba꞉bolo aeno naha ilina na꞉nihiduilamiya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ba꞉bene Ya꞉suku ta꞉matapi netewapa꞉te ko habamo nuluhukuti, Ya꞉suti kebe komoma꞉ ka꞉kiyalamiya꞉, iba꞉te ba꞉bi komo nulamete Adaguila꞉ Poko ilina ba꞉bo nihiduilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ba꞉bema꞉ da꞉duniya꞉ Ya꞉suti ebeno 12 ta꞉matapa꞉go ba꞉be genamamo na꞉pelameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Iba꞉te ahidinate baa꞉ ba nahana, Ya꞉suti na꞉goeniya꞉, “Na la꞉tamo hibi tabo begoemo, la꞉ ipuwalo etate na anakapunamepi kowalubilima꞉ne na lawenema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ba꞉ba tetelo iba꞉te tepo menemenema꞉ ba eda꞉hana, Ya꞉sutamo etate goenakui, etate goenakui, “Nalela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ya꞉suti iba꞉tamo na꞉goeniya꞉, “La꞉ 12 ta꞉matapi ipuwalo baa꞉ kalila꞉mo nago kokoto dadutimini, ba꞉be ba꞉be lumagila. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Iyo, ba꞉ hibila, Tawakalubino Naniwiti hoea꞉mo ba꞉ na꞉to, Godokono Bukalo tabo ba꞉ma ka꞉na bitana, huiyatiya kebe lumagiti ebe anakapumipa꞉tamo dikalamemene, ba꞉be lumagiti kuba huiya konomo kolawema꞉ne. Ba꞉moe ba꞉be mabuma꞉ ba꞉be dubu ebeno menokote ebe alahimiha꞉ma꞉ eda꞉ ba꞉ wadiyala!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ba꞉bene iba꞉te baa꞉ ba nahana, Ya꞉suti baa꞉ lawenate Godotamo kalakala tabo goenate ba꞉bo wakamihoniya꞉, ba꞉bema꞉ ebete iba꞉tamo ba ikalamena na꞉goeniya꞉, “La꞉ nuwata꞉la꞉, ba꞉moe ba꞉ naeno apela.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ba꞉bene ebete kalili kalawenate Godotamo kalakala tabo goenate iba꞉tamo ba ikalamena, ibi hiliyonomate ba꞉bo nihoniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Godote tawakaluba꞉go komiloma꞉ nopo da꞉tamotiya꞉, ba꞉moe naeno hawiti ba꞉be nopo bekodakoduimina, iyo, ba꞉moe hawiti komo hiliyonomo tawakalubi owalubilima꞉ koka꞉ka꞉la꞉ma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na la꞉tamo hibi tabo begoemo, na ba꞉ma tetelo ba꞉moe gao beya gala a꞉kana꞉mo, huiyatiya Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be habalo na uli gao beya galane tetelo ba꞉bo koninima꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ba꞉bene iba꞉te Godoko adikumino ohale kapiya alapihonate, Olibi Kehakeha Hunu Hakamo kotolamenama꞉ genamane ba꞉ dito ikuliniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ba꞉ba tetelo Ya꞉suti iba꞉tamo na꞉goeniya꞉, “La꞉ hiliyonomate na komiya꞉panema꞉nemata, mabu Godokono Bukalo tabo ba꞉ma ka꞉na bitana, ‘Godote sipi-goegoe ulamedawa danakapumimini, ba꞉ba tetelo sipi-goegoa꞉te hiya꞉hiya꞉ kalahutihoma꞉na꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Huiyatiya Godote na hoene gala da꞉kadipanatenemene, na Ga꞉lili hopamo dopamo kotoma꞉nemo. La꞉le na ba꞉bolo kopunamema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ba꞉bene Pitate Ya꞉sutamo na꞉goeniya꞉, “Ibi hiliyonomate hoe tolemelo dalahutihomena꞉, huiyatiya nale ama꞉ a꞉kamiya꞉pamata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ya꞉suti ebeno tabo ba huiyana na꞉goeniya꞉, “Na ama꞉tamo hibi tabo begoemo, ka꞉lo dulu kakabate netewa teta꞉mo goehoheno, ama꞉ netewa-kapiya teta꞉mo na iya꞉tawaha꞉ma꞉ kogoema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Huiyatiya Pitate ibulunomolo gala na꞉kagoeniya꞉, “Na ama꞉go da꞉nehoemo, nale ama꞉ iya꞉tawaha꞉ma꞉ a꞉kagaa꞉mo!” Ba꞉ba tetelo ibi hiliyonomate ba꞉ atu tabo bekaga꞉laniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ba꞉bene Ya꞉suku ba꞉gala ebe ta꞉matapi iba꞉te ko habane ikulinate eta tatali hopamo tolameniya꞉, ba꞉be hopoeno mahilo Getasemanila. Ya꞉suti ba꞉bolo iba꞉tamo na꞉negoeniya꞉, “La꞉ ba꞉malo na꞉pola꞉nala꞉. Na ba꞉moe tatalia꞉mo tomo Godotamo toetoe tabo konolamagima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ba꞉ba tetelo ebete Pitako, Ya꞉imesiko, ba꞉gala Yoneko, ibi baleta toetoe tabo ga꞉la baha꞉mo magataleniya꞉, ba꞉bene tepo menemene komo ba꞉gala ukui temeteme komo ebetamo konomamo ba꞉bo pelameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ba꞉bema꞉ Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Na tepo temeteme konomamo iya꞉tawanamo, ba꞉mako tepo temeteme na anakapuname huiyala. La꞉le na mabuma꞉ ba꞉malo uliholo na꞉pola꞉nala꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ba꞉bene ebete nanekela꞉mo tonate ebeno ape hakamo nihatenate Godotamo ba꞉bo netoetoeniya꞉, gabote da꞉modobomene ba꞉ba teteno temetemete ebe komiya꞉pama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ebete na꞉goeniya꞉, “Iya꞉, Nabiwi! Hiliyonomo komokomo ododilima꞉ ama꞉godolo helo bitana, ba꞉bema꞉ ama꞉ ba꞉moe temeteme kalili nagodone na꞉lawa꞉. Huiyatiya naeno ubiha꞉, ama꞉ ha꞉kiya amia꞉no ubila nododa꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ba꞉bene ebete ta꞉matapa꞉tamo da꞉peniya꞉ lahanalo pulamenate Pitatamo na꞉pegoeniya꞉, “Saimono, la꞉ badama꞉ ka꞉lahonama? Mabu keka꞉ la꞉le na mabuma꞉ tete nanekelelo uliho modoboha꞉ma꞉ deda꞉hanama.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ba꞉ba tetelo Ya꞉suti ibi na꞉goelameniya꞉, “Godotamo uliholo na꞉toetoehonala꞉, mabu la꞉le Saitanakono kuba gabamo emogabuimi komamo gudidimata. La꞉eno tepo ipuwalo hido komo ododima꞉ ubila, huiyatiya la꞉godolo ododi helo puliyala.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ba꞉bene Ya꞉suti gala katonate, ebete dopamo Godotamo toetoe tabo keba ka꞉na ka꞉nolamaginiya꞉, ebete ba꞉ atumu kanolamaginiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ba꞉bene ebete ebe ta꞉matapa꞉tamo gala da꞉kapeniya꞉ lahanalo kapulameniya꞉. Ba꞉ba tetelo ibino baiditi menemenenomoma꞉ eda꞉halameniya꞉, ba꞉be mabuma꞉ iba꞉te hilopago ebetamo ga꞉la tabo nipo ohowadiniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ba꞉bene ebete gala katonate netewa-kapiya tetelo Godotamo netoetoenate da꞉kapeniya꞉ iba꞉tamo na꞉pegoeniya꞉, “La꞉ hawela amiholo gala badama꞉ ka꞉kalahonama? Ba꞉ba꞉la, tete ba꞉ a꞉pe, kubapa꞉te Tawakalubino Naniwi ibino kokotamo ba꞉ na꞉lawa꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Iyo, la꞉ na꞉pakaminala꞉, a ba꞉ na꞉tolamema꞉. Numa꞉la꞉, na anakapunamepino kokotamo ihatenedawate ba꞉ na꞉pe!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ya꞉suti ba꞉be tabo ba goena ba꞉ba tetenomolo Yudasiti peniya꞉, Ya꞉sukunu 12 ta꞉matapi ipuwalo ebe ba꞉ etala. Ba꞉bene eba꞉go dubu hiliyonomate ibino alaholoho gili ba꞉gala kukago da꞉pelameniya꞉, ba꞉bi dubu ba꞉ Godotamo hawa꞉goeno ikamehopino watowatopi, Godokono Tutumu iya꞉tulamepi, ba꞉gala komo koko dubu, iba꞉te da꞉poelameniya꞉ ba꞉bi dubula. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ba꞉ hibila, Yudasiti ibi ya꞉lo ba꞉ma ka꞉na goelameniya꞉, “Nale daboetehomo, ba꞉be ba꞉be lumagila. La꞉ ebe tiyonomo lawete hidamo na꞉magatuya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ba꞉bene Yudasiti penate Ya꞉sutamo tonomo tonate ebe na꞉negoemeniya꞉, “Iya꞉tulamedawa!” Ba꞉ba tetenomolo ebete ebe ba aboetehona, ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","komo dubate Ya꞉suku ibino kokotamo kodakodanomolo ba꞉bo laweniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ba꞉ba tetelo Ya꞉suku ta꞉matapi ipuwalo eta dubuti ebeno alaholo gili magubutinate, Godotamo hawa꞉goeno ikamehopino Hununomo Watodawoeno genama okodawa anagaliminate, galo hapu ba꞉bo mapitamidameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Na pilo lumagila꞉ka꞉, o na alaholodawala꞉ka꞉? Mabu keka꞉ la꞉le alaholoho gila꞉go ba꞉gala kukago na lawenema꞉ da꞉pelamema? ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na komo hegelalo Godoko Adikumino Hiya꞉ Genamalo la꞉go ba luta tawakalubi diya꞉tulamenatimo, la꞉le na ba꞉bolo kalaweneha꞉, huiyatiya ba꞉moi komate ba꞉ ikuliha Godokono Buka tabo komate hibima꞉ keda꞉hama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ba꞉ba tetelo ebe ta꞉matapi hiliyonomate ebe miya꞉panate dito alahutihoniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ba꞉bolo eta uli ape dubuti na꞉la꞉nuya꞉, ebete dopamo hido keyakeya kalikonomo pulinate Ya꞉suku ta꞉matapa꞉go ba꞉bamo da꞉puluhukuniya꞉, ba꞉bema꞉ komo dubate ubila ebe kolawenama꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","huiyatiya ebete ebeno kaliko miya꞉panate kikipuiyanomo atumu dito kalahula꞉niya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ba꞉bene iba꞉te Ya꞉suku Godotamo hawa꞉goeno ikamehopino Hununomo Watodawoeno genamamo ba꞉ dito magataniya꞉. Iba꞉te ebe ba꞉be genamamo magatanaheno dopamo Godotamo hawa꞉goeno ikamehopino komo watowatopi, ba꞉gala Godokono Tutumu iya꞉tulamepi, ba꞉gala komo koko dubu, ibi hiliyonomate pelamenate ba꞉bo pekapiyaniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ba꞉ba tetelo Pitate Ya꞉suku muhuludopone ba ta꞉matana, ebete Hununomo Watodawoeno genama kala ipuwamo na꞉pa꞉ganate ebete lawamepa꞉go koelo ba꞉bo nigiga꞉niya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ba꞉bene Hununomo Watodawa ba꞉gala komo Ka꞉nisolo dubu hiliyonomate tabo ga꞉lapi boholeniya꞉, Ya꞉sukunu kuba oholemenate ebe kanakapumima꞉. Huiyatiya iba꞉te ebeno eta kuba kuminiya꞉ha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","iyo, hiliyonomo tabo ga꞉lapa꞉te ebeno komoma꞉ ha꞉da ba amihohona, hiya꞉hiya꞉ tabo da꞉ga꞉laniya꞉ ibino tabote huiyatiya kapiyama꞉ keda꞉haniya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ba꞉bene komopa꞉te mahila꞉hanate Ya꞉sukunu komoma꞉ ha꞉da ba amihohona, iba꞉te ba꞉ma ka꞉na ga꞉laniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ebete tabo da꞉goiti ale ba꞉ma ka꞉na ulitima꞉, ‘Ba꞉moe Godokono Genama tawakaluba꞉te kokotamo detiya꞉, nale anabulimiti netewa-kapiya hegelalo eta genama gala kaketema꞉nemo, ba꞉bako genama komo tawakaluba꞉te ete modoboha꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Huiyatiya dopo ha꞉da amihopi keba ka꞉nala꞉ka꞉, ba꞉moi uli tabo ga꞉lapi ba꞉ ba꞉ba ka꞉nala, iba꞉te ibino tabo ga꞉la ipuwalo Ya꞉sukunu komoma꞉ ukui kapiyama꞉ keda꞉haniya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ba꞉bene Godotamo hawa꞉goeno ikamehopino Hununomo Watodawate ibi ipuwalo mahiganate Ya꞉suku nalateda꞉niya꞉, “Ama꞉ tabo goeha꞉ma꞉ badama꞉ kedeona? Ba꞉moi dubate ama꞉ mabuma꞉ da꞉ga꞉lana keba ka꞉nala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ba꞉ba tetelo Ya꞉suti tabo goeheno dito la꞉nuya꞉, ba꞉bema꞉ Hununomo Watodawate ebe gala na꞉kalateda꞉niya꞉, “Godoko tawakaluba꞉te dadikumina, ama꞉ ba꞉ ebeno Gudu Kelisotela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ya꞉suti na꞉huiyaniya꞉, “Na ba꞉ ba꞉betela. Ba꞉bene la꞉le na Tawakalubino Naniwi aeno Helodawa Godokono tu hapulu lutalo kunamema꞉nemata, iyo, galane na Hunu Habane hawai ipuwado kopehawakalama꞉nemo!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ba꞉bema꞉ Hununomo Watodawate ba꞉be tabo ulinate, ebeno konomo mauba komo kohawakaliminama꞉ ebete da꞉puliniya꞉ ba꞉be kaliko anagiya꞉midalenate na꞉goeniya꞉, “A ba꞉moe dubuino kuba kiya꞉tawahama꞉ eta tabo goedawa a ubihinola! ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ebete ha꞉kiya kubanomo tabo da꞉goe la꞉ ba꞉ ulihomata, mabu ebete na꞉goe, ‘Na ba꞉gala Godoko, a ba꞉ kapiyala!’ Ba꞉bema꞉ ebeno komoma꞉ la꞉eno ubi keba ka꞉nala꞉ka꞉?” Ba꞉bene ibi hiliyonomate Ya꞉sukunu komo ba anagiya꞉midamena ebe anakapumima꞉ ba꞉bo ga꞉laniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ba꞉ba tetelo komo iba꞉te Ya꞉sutamo kowe mehoholenate, ebeno holoholo mula꞉menate ba anagalimihona na꞉ga꞉laniya꞉, “Ama꞉ Godokono ukui hawakalimidawama꞉ hibilo deda꞉na, ama꞉ na꞉gaa꞉ puya꞉te kanagalimihotana!” ba꞉bene lawamepi dubate ebe lawenate kokotamo ba꞉bo anagalimihoniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Ba꞉ba tetelo Pitate ba꞉be genamoeno kala ipuwalo ebeno apete kotanotanonama꞉ koelo lutiya꞉. Ba꞉bene Hununomo Watodawoeno oko bohelete penate, Pitako hidamo pumihonate ebe na꞉pikiyameniya꞉, “Ama꞉ ba꞉ atumu ba꞉moe Nasaletenapi Ya꞉sukuba꞉ pata꞉nama꞉ta!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Huiyatiya Pitate na꞉goeniya꞉, “Ao, na ba꞉be dubu iya꞉tawaha꞉. Ama꞉le da꞉goena ba꞉be tabo na kemalagidolonaha꞉.” Ba꞉bene ebete kala imi gigihamo da꞉toniya꞉, ba꞉ba tetelo kakabate na꞉goehoniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ba꞉bene oko bohelete ebe uminate, ba꞉bolo da꞉pola꞉nuya꞉ ba꞉bi tawakalubi gala na꞉kakiyalameniya꞉, “Ba꞉moe ba꞉ Ya꞉sukunu eta lumagila!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","huiyatiya Pitate ba꞉ atu iya꞉tawaha꞉ tabo bekagoeniya꞉. Ba꞉bene ba꞉bolo da꞉pola꞉nuya꞉, iba꞉te tete nanekelelo pola꞉natepanate Pitako gala na꞉kakiyameniya꞉, “Hibila! Ama꞉ ba꞉ Ya꞉sukunu eta lumagilata, mabu ama꞉ Ga꞉lili hoponapilata.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Huiyatiya Pitate na꞉goeniya꞉, “Godokono dopo hapulu utiti na꞉goemo, nale hibi tabo goeheno ebete na kanagalinamema꞉ne! La꞉le kebe lumagima꞉ da꞉ga꞉lanama, na ebe iya꞉tawaha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ba꞉bene ba꞉ba tetenomolo kakabate goeho netewa tetema꞉ deda꞉meniya꞉, Ya꞉suti ebetamo dopamo kebe tabo ka꞉goeniya꞉, Pitate ba꞉be tabo ba꞉bo emalagidoloniya꞉, “Kakabate netewa teta꞉mo goehoheno, ama꞉le netewa-kapiya teta꞉mo na iya꞉tawaha꞉ma꞉ kogoema꞉na꞉ta.” Ba꞉bene Pitate ibulunomo ba꞉bo ihiniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Duiduiyanomolo Godotamo hawa꞉goeno ikamehopino watowatopi, ba꞉gala Godokono Tutumu iya꞉tulamepi, ba꞉gala komo koko dubu, ba꞉moi Ka꞉nisolo tawakalubi hiliyonomate nopo betamotiya꞉. Ba꞉bema꞉ iba꞉te Ya꞉suku hala꞉mo matuhumihote Paeletetamo da꞉magatuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paeletete ebe nalatediya꞉, “Ama꞉ Yu tawakalubino Ko Gawadubula꞉ka꞉?” Ya꞉suti ebetamo na꞉huiyuya꞉, “Ama꞉le ba꞉ a꞉gaa꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ba꞉ba tetelo Godotamo hawa꞉goeno ikamehopino watowatopa꞉te Ya꞉sukunu komoma꞉ na꞉ga꞉lutiya꞉ ebete hiya꞉hiya꞉ kuba bododilinami, ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ba꞉bene Paeletete ebe gala na꞉kalatediya꞉, “Ama꞉ ibino tabo ba꞉ka꞉huiyomena꞉? Iba꞉te na꞉ga꞉lita ama꞉ hiliyonomo koko kuba ododilidawalata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Huiyatiya Ya꞉suti eta tabo kagoiya꞉ha꞉, ba꞉bema꞉ Paeletete koamo hanohanuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ba꞉ba tete tawakalubino ododi komo ba꞉ma ka꞉nala, hiliyonomo gogo ipuwalo Yunapino Adaguila꞉ Poko tetelo iba꞉te du genamalo kapiya lumagi mahilamo da꞉ka꞉minakui, Paeletete ba꞉be lumagi ebeno kuba huiyane dito oemenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ba꞉ba tetelo kapiya dubu ebeno mahilo Balabasitila, ebete du genama gulu nemedenami, ebeno komo ba꞉ma ka꞉nala. Dopamo komo dubate Loma gabomana꞉go alaholohopima꞉ ba eda꞉ha, iba꞉te komo tawakalubi ba꞉bo anakapulamiya꞉, ba꞉be mabuma꞉ Loma gabomani watowatopa꞉te ibi Balabasiko bana uwatete du genamamo dito miya꞉tiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ba꞉bema꞉ Ya꞉suti Paeletekono holoholo hapulu ba la꞉na tawakalubi hiliyonomate ebetamo pelamete na꞉pega꞉lamiya꞉, ebete poko tetelo dopamo keba ka꞉na kododinakui ba꞉ba ka꞉na gala kakododima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ba꞉bene Paeletete iba꞉tamo na꞉goiya꞉, “La꞉ ubila꞉ka꞉ nale la꞉ Yu tawakalubino Ko Gawadubu dito oeme?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ebete ba꞉moe tabo begoiya꞉ mabu ebete iya꞉tawuya꞉, Yunapi hiliyonomate Ya꞉sutamo na꞉kalakalahutiya꞉, huiyatiya ibino watowatopa꞉te ba꞉be mabuma꞉ maubahate ebe ba꞉ dito magahiya꞉, iyo, iba꞉godolo hibi komo puliyala, kitanuya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Huiyatiya ba꞉ba tetelo Godotamo hawa꞉goeno ikamehopino watowatopa꞉te komo hiliyonomo tawakaluba꞉tamo helo bikalamiya꞉ iba꞉te Paeleteko koga꞉lamema꞉, ebete Balabasiko du genamane dito oemete huiyatiya Ya꞉sutamo kuba huiya kikamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ba꞉bene Paeletete iba꞉tamo gala na꞉kagoiya꞉, “Ba꞉moe dubu la꞉le Yu tawakalubino Ko Gawadubuma꞉ da꞉ga꞉lanama, nale ebe keba ka꞉na na꞉kamitimo?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Iba꞉te ga꞉ga꞉lo na꞉ga꞉luya꞉, “Keha pihigamo pihomotete, ikoko nalukulima꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ba꞉bene Paeletete na꞉goiya꞉, “Bada mabuma꞉? Ebete bada kuba kododi?” Huiyatiya iba꞉te konomamo ga꞉ga꞉lo gala na꞉kaga꞉luya꞉, “Keha pihigamo ebe na꞉pihomota꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ba꞉bema꞉ Paeletete ba꞉bi tawakalubi kokalakaluilamema꞉ ubi ba ihate, ebete Balabasiko du genamane ba꞉ dito oemiya꞉, huiyatiya ebete ebeno alaholohopi na꞉goelamiya꞉ iba꞉te Ya꞉suku giya꞉pa꞉pa꞉mo ka꞉na꞉miga꞉tima꞉. Ba꞉bene ba꞉be komo da꞉wibuya꞉ ebete Ya꞉suku iba꞉tamo dito ikalamiya꞉, iba꞉te ebe keha pihigamo pihomotete ikoko kalukulimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ba꞉ba tetelo alaholohopi dubate Ya꞉suku na꞉magatuya꞉ Loma gabomanino ko genama guamo, ba꞉be genamoeno mahilo ba꞉ Pelatoliyamala, ba꞉bene iba꞉te ibino alaholohopino kapiyuimi dubu hiliyonomo ka꞉lamiti iba꞉go ba꞉bo nekapiyuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Iba꞉te Ya꞉suku ba waliti huiya konomo hawihawi kaliko ebetamo ba꞉bo pulimiya꞉, ba꞉gala iba꞉te olagoeno tupina nelawete anagogobeya꞉midahalo a꞉dete ebeno watamo dito pulimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ba꞉bene iba꞉te ebe iya꞉da꞉telo na꞉ga꞉luya꞉, “A꞉iye! Yu tawakalubino Ko Gawadubu, ama꞉ nolata!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ba꞉gala iba꞉te ebe kukamo watolo anagalimihote ebetamo kowe mehoholete, iba꞉te ebe ba waliti ibino pupamo ahiditi ebetamo ba꞉bo papamila꞉huya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Iba꞉te ebe waliti da꞉wibuya꞉, hawihawi kaliko ebeno apene pekanamete ebeno kalikonomo gala dito kapulimiya꞉, ba꞉bene iba꞉te ebe na꞉magatuya꞉ keha pihigamo ebe konepihomotema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ba꞉ba tetelo eta dubu Saimonoko ebe ba꞉ Sailiniya habanapila, ebe ba꞉ A꞉lesandako ba꞉gala Lupasiko ibino nabiwila, ebete gobogobone ko habamo ba꞉moe gabodo ba pita, alaholohopa꞉te ebe duhimiti ba꞉bo lawiya꞉ Ya꞉sukunu keha pihiga kagatamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ba꞉bene iba꞉te Ya꞉suku na꞉magatuya꞉ Gologota hakamo, ba꞉be hakoeno mahilo ipuwa ba꞉ ‘Wato Gohala.’ ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ba꞉bolo iba꞉te helo gao beya ba꞉gala temeteme uliha꞉ kaka mulamula kapiyuilamete ebetamo dikamiya꞉ Ya꞉suti kaniya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ba꞉bene hegelate nanekela꞉mo da꞉podolatepuya꞉ 9 koloko tetelo, alaholohopa꞉te Ya꞉suku kehamo pihomotete ikoko ba꞉bo alukulimiya꞉, ba꞉gala iba꞉te nakola hegehege iya꞉hekeholo iya꞉da꞉mi komo ba ododi ebeno kaliko hiya꞉hiya꞉ uwatemete ba꞉bo alabahamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ba꞉ba tetelo iba꞉te Ya꞉sukunu hoe mabu hawakalimima꞉ tabo hunamo ba꞉ma ka꞉na miya꞉tiya꞉, “Ba꞉moe dubu ba꞉ Yu tawakalubino Ko Gawadubula,” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ba꞉gala iba꞉te pilo dubu netewa Ya꞉sukuba꞉ hiya꞉hiya꞉ kehamo a꞉kapihomolateliya꞉, eta tu hapuamo, eta pele hapuamo. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ba꞉be komote ba꞉ ba꞉ma ka꞉na uluhukuya꞉, Godote ebeno Bukamo dopamo da꞉miya꞉tiya꞉ ba꞉be tabote hibima꞉ keda꞉ma꞉, iyo, ebeno Bukalo tabote ba꞉ma ka꞉na itana, “Iba꞉te ebe kubapa꞉go kapiyama꞉ midiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ba꞉bene puya꞉te ba꞉be gabodo da꞉petolamitiya꞉ iba꞉te Ya꞉suku iduduputimilo niya꞉da꞉titiya꞉, iyo, iba꞉te ibino wato wagegelatelelo na꞉ga꞉lutiya꞉, “A꞉iye! Ama꞉ Godokono Genama anabulimiti, netewa-kapiya hegelalo gala etema꞉ da꞉goi, ama꞉ ba꞉be lumagilata! ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Wadiyala ama꞉ ha꞉kiya amia꞉no ka꞉ka꞉ mula꞉te keha pihiga hununi hopamo na꞉pihitiga!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ba꞉ba tetelo Godotamo hawa꞉goeno ikamehopino watowatopa꞉te Godokono Tutumu iya꞉tulamepa꞉go Ya꞉suku atumu na꞉ka-iya꞉da꞉titiya꞉, ba꞉ma ka꞉na etate etatamo goenakui, etate etatamo goenakui, ba꞉ba ka꞉na ewagelitiya꞉, “Ya꞉suti komo tawakalubino olalati komo bemula꞉lelamenakui, huiyatiya ebe ha꞉kiya ebeno ka꞉ka꞉ mula꞉ wadiyaha꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ebete Godokono Oemedawa ba꞉gala Isalaela tawakalubino hibi Ko Gawadubuma꞉ deda꞉na, wadiyala ebete keha pihiga hununi hopamo na꞉pihitigana, iyo, ale ba꞉be komo umiti ebe hibima꞉ ba꞉bo komidima꞉nema꞉!” Ba꞉ba tetelo eba꞉go da꞉pihomolateliya꞉, ba꞉bi dubu netewapa꞉te atumu Ya꞉suku iduduputimilo kuba tabo bekaga꞉lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ba꞉bene hegelate tuli teta꞉mo dutiya꞉ hopo konomote ba꞉bo duya꞉. Ba꞉ba tetelo du komote hegeloeno alo ba mula꞉, hegelate a꞉hiwate nanekela꞉mo a꞉nihitigatepaniya꞉, hegela tuli tetene tupuimiti 3 koloko teta꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ba꞉bene Ya꞉suti Yu tawakalubino tabamo ibulunomamo na꞉goeniya꞉, “Elai, Elai, lama sabakatani?” ba꞉moe taboeno ipuwa ba꞉ma ka꞉na itana, “Naeno Godo, naeno Godo, na ama꞉le badama꞉ ka꞉miya꞉pana꞉wa?” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Komo ba꞉bolo da꞉pola꞉nuya꞉ iba꞉te ebeno tabo ulinate na꞉ga꞉laniya꞉, “Numa꞉la꞉, ebe Elayako beka꞉mina!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ba꞉bene kapiya dubu nipuliganate, humago kaka gao beyamo nadutinate pudamo negalapata꞉midanate Ya꞉sutamo ba nikamena na꞉goeniya꞉, “Hiya꞉, a kumitotiya꞉! Elayate ebe pelawete hopamo da꞉padipotemene!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ba꞉ba tetelo Ya꞉suti ibulunomo goewatanate hoenomo ba꞉bo hoeniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ba꞉bene Godoko Adikumino Hiya꞉ Genamoeno kaliko ubiliti tulituliya bolagale hununi tupuiminate hopamo ba꞉bo pihitiganiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ba꞉gala Ya꞉sukunu holoholo hapulu da꞉la꞉nuya꞉, ba꞉be alaholohopino gawadubuti Ya꞉suti keba ka꞉na ka꞉hoeniya꞉ ba꞉be komo uminate na꞉goeniya꞉, “Hibila, ba꞉moe dubu ba꞉ Godokono Gudula!” ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ba꞉ba tetelo komo kamenakamenate Ya꞉suku umima꞉ muhuluni putitataniya꞉, ibi ba꞉ puya꞉te eba꞉go Yelusalemamo da꞉pelamiya꞉ ba꞉bi kamenakamenala, ba꞉gala ibi ipuwalo Salomiko, ba꞉gala Magadalanapi Ma꞉liko, ba꞉gala eta Ma꞉li ebeno gugudi netewa Yausesiko ba꞉gala Deha꞉potodawa Ya꞉imesiko, ba꞉moi ba꞉te pola꞉nuya꞉. Ba꞉ hibila, Ya꞉suti Ga꞉lili hopolo da꞉pata꞉nami ba꞉moi netewa-kapiya kamenakamenate ebe hidonomamo owalubinama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Gapogapo tetelo A꞉limitiya habanapi Yausepete na꞉peniya꞉, ebe Yunapi Ka꞉nisolo ipuwalo eta tuputupu lumagima꞉ eda꞉nami, iyo, ebete Godokono Ko Gawadubuma꞉ eda꞉ tete belatiminami. Ba꞉bene ebete ba꞉ma ka꞉na pemalagidoloniya꞉, ba꞉be hegela ba꞉ Yu tawakalubino okoha꞉ hegeloeno ilina hiduilame tetela mabu dumutu ba꞉ talona hegelala, ba꞉bema꞉ ebete tonate Paeleteko toleheno na꞉nikiyameniya꞉ Ya꞉sukunu ape lawenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paeletete ba꞉be tabo ulinate koamo la꞉wa꞉nate ukuilo na꞉goeniya꞉, “Ya꞉suku ya꞉lo a꞉ka꞉haa꞉ka?” ba꞉bema꞉ ebete alaholohopino gawadubu ebetamo ka꞉minate Ya꞉sukunu hibi hoe komoma꞉ ebe ba꞉bo alateda꞉niya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ba꞉bene Paeletete alaholohodawa gawadubugodone Ya꞉sukunu hoe tete ulinate Yausepetamo modobo tabo ba꞉bo goeniya꞉ ebete Ya꞉sukunu ape lawenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ba꞉bene Yausepete hidonomo keyakeya kaliko mana꞉mo lawenate Ya꞉sukunu ape hopamo padipotenate, hido kalikamo a꞉wa꞉tinate nakola bobo ipuwamo ba꞉bo nihateniya꞉, ba꞉be bobo tawakaluba꞉te iya꞉ha꞉midale nakola haka ba aligi ya꞉lo ba꞉bo ododiya꞉. Ba꞉ba tetelo Yausepete ko nakola emokamidanate bobo gigiho ba꞉bo netakuminiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ba꞉bene Magadalanapi Ma꞉liko ba꞉gala Yausesikono menoko Ma꞉liko, Yausepete Ya꞉sukunu ape dihateniya꞉ iba꞉te ba꞉be bobo haba uminiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ba꞉bene Yu tawakalubino okoha꞉ talona hegela tete da꞉wibuya꞉, Magadalanapi Ma꞉liko, Ya꞉imesikono menoko Ma꞉liko, ba꞉gala Salomiko, iba꞉te tolamenate hido nibo ilina mana꞉mo na꞉nuwatehoniya꞉ eta hegelalo Ya꞉sukunu apa꞉mo kopabutilamelemema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ba꞉bene Sande hegela duiduiyanomolo hegela ba owalohuta, iba꞉te nakola bobo habamo da꞉tolamitiya꞉ ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","na꞉nega꞉luya꞉, “Bobo gigiholo ditana ba꞉be ko nakola tama꞉mo pote na꞉ka꞉nemokamidaa꞉memene?” Iba꞉te ba꞉ma ka꞉na ga꞉lutiya꞉ mabu ba꞉be nakola menemenenomola, huiyatiya iba꞉te hidamo ba gahilamehole ba꞉be ko nakola tama꞉mo ya꞉lo emokamida ba itana ba꞉bo umiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ba꞉bene iba꞉te nakola bobo ipuwamo nogomote, uli ape dubu ga꞉ga꞉ keyakeya kaliko puliti tu hapulu da꞉lutiya꞉ numiti konomamo nehanohanohutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ebete iba꞉tamo na꞉goiya꞉, “La꞉ akahanohanohala꞉! Nasaletenapi Ya꞉suku tawakaluba꞉te ebe keha pihigamo da꞉pihomoti, la꞉le ebe bohowaditamata. Ebe malo puliyala, ebe a꞉mahigaka! Iba꞉te ditidi gapogapolo ebe dihateni ba꞉be haba la꞉ numa꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ba꞉bema꞉ la꞉ tolamete Pitako ba꞉gala komo ebe ta꞉matapi na꞉nikiyalama꞉la꞉, ‘Ya꞉suti Ga꞉lili hopamo dopamo kotoma꞉ne. La꞉ tolamete ebe ba꞉bo konumima꞉nemata, ebete la꞉ dopamo keba ka꞉na ka꞉kiyalamiti ba꞉ba ka꞉na.’” ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ba꞉bene iba꞉te hanohanoholo lililahala꞉go nakola bobo ipuwane pikuliti ba꞉ dito pipulila꞉huya꞉, huiyatiya iba꞉te eta lumagi kanikiyamiya꞉ha꞉ mabu iba꞉te koamo toletolehutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ba꞉be Sande hegela duiduiyanomolo Ya꞉suti hoe ipuwane mahigate Magadalanapi Ma꞉litamo dopamo nuluhukuya꞉, ba꞉be kamenagodone Ya꞉suti dopamo sa꞉ba꞉ni kuba gobogobo boelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ba꞉bema꞉ Ma꞉liti tote, puya꞉te dopamo Ya꞉sukuba꞉ da꞉wapata꞉lamenama꞉ ba꞉bi tawakaluba꞉te ba ihimita ibi ba꞉bo nikiyalamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","huiyatiya iba꞉te Ya꞉sukunu ka꞉ka꞉mo mahiga komo ba꞉gala Ma꞉liti ebe dumiya꞉, iba꞉te ba꞉be tabo uliti hibima꞉ kamidiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Galane Ya꞉sukunu ta꞉matapi netewapa꞉te Yelusalema ko habane ba tuta, Ya꞉sukunu apete hiya꞉ma꞉ eda꞉mete ebete iba꞉tamo ba꞉bo nuluhukuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ba꞉bene ibi netewapa꞉te gala na꞉katuya꞉ komo ta꞉matapi konikiyalamema꞉, huiyatiya iba꞉te ba꞉be tabo uliti hibima꞉ kamidiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Galane Ya꞉sukunu 11 ta꞉matapa꞉te ahiditi baa꞉ ba nahuta Ya꞉suti iba꞉tamo ba꞉bo nuluhukuya꞉, ba꞉bema꞉ ebete ibi koamo kiyahalamiya꞉ mabu iba꞉te ibino tepo ipuwalo kodakodahibima꞉ ba eda꞉ha hibima꞉ kamidiya꞉ha꞉, iyo, komopa꞉te ebeno ka꞉ka꞉ komo umiti ibi da꞉pikiyalamiya꞉, iba꞉te ibino tabo uliti ebeno hoe ipuwane mahiga komo iba꞉te hibima꞉ kamidiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ hopo konomamo tolamete Godokono Hido Tabo hiliyonomo hiya꞉hiya꞉ tawakaluba꞉tamo na꞉nolamagiminakuya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kebe lumagiti hibima꞉ miditi ba꞉bene beyamo aduti komo da꞉lawemene, Godote ebeno ka꞉ka꞉ komula꞉mema꞉ne, huiyatiya kebe lumagiti hibima꞉ midihino Godote ba꞉be lumagino komo anagiya꞉midamete ebetamo kuba huiya hibilo kikamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ba꞉ hibila, Godokono helo hawakalimima꞉ hanohano komate hibima꞉ midipa꞉godolo kopola꞉nama꞉na꞉. Iyo, iba꞉te naeno mahilamo tawakaluba꞉godone kuba gobogobo boelamenakomena꞉ ba꞉gala iba꞉te Hunu Haboeno nopopino hiya꞉hiya꞉ tabamo bolamagiminakomena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ba꞉bene iba꞉te kalu kokotamo duwateholenakomena꞉ ba꞉gala iba꞉te hoe beya da꞉nihonakomena꞉, ba꞉bi komate ibi a꞉kakubahilamenakamena꞉, ba꞉gala iba꞉te temetema꞉gopa꞉tamo ibino kokoto demowatilamenakomena꞉, ba꞉ba tetelo ba꞉bi temetema꞉gopa꞉te ba꞉hidohidohonakomena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ba꞉bene Kodawa Ya꞉suti iba꞉tamo tabo olamagi da꞉wibuya꞉, Godote ebe pelawete Hunu Habamo ba꞉bo adipatiya꞉, ba꞉bolo ebete Godokono tu hapuamo ba꞉ dito nemediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ba꞉bene ta꞉matapa꞉te tolamete hiliyonomo hiya꞉hiya꞉ hopolo Godokono tabo ba nolamagimi, Kodawa Ya꞉suti iba꞉go kapimilo Godokono oko na꞉nowatinami, iyo, ba꞉ba tetelo ebete Godokono helo hawakalimino hanohano komokomo ipuwado ba꞉be Hido Tabo na꞉neheluiminami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Naeno hido lumagi Tiyopolasi, nolata. A ipuwalo kebe komokomate ya꞉lo dikulihuya꞉, puya꞉te tupuimi mabuni ibino baidinomamo ba꞉bi komo dulameholiya꞉, komo iba꞉te Godokono Hido Tabo ba olamagimi ba꞉bi atu komokomo a ba꞉gala komo tawakalubi hiliyonomo ba꞉bo kiyahaa꞉miya꞉. Ba꞉ hibila, ba꞉ba tetene tupuimiti komopi hiliyonomate ba꞉bi komokomo pepamo hibinomolo miya꞉tehoma꞉ newagelenama꞉, huiyatiya ibi ipuwalo etate oko hidamo kupuliya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ba꞉bema꞉ naeno kodawa, nale ba꞉moi hiliyonomo komokomo ibino tupuilame mabuni hidonomamo ba emalagidolenape, naeno tepo ipuwoeno ukuilo ubi ba꞉bo ihatimo ama꞉tamo buka ododiti ba꞉moi komokomo kotuputupuilamema꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","iyo, komopa꞉te ama꞉ diya꞉tumihui, ama꞉le ba꞉bi hiliyonomo komokomo hibinomolo kiya꞉tawahama꞉, nale ba꞉moe komo ba꞉bema꞉ ododimo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ba꞉ba tetelo Heloditi Yudiya hopoeno Ko Gawadubuma꞉ ba eda꞉na, eta dubu ebeno mahilo Sekalayatela, ebete Abayakono kapiyuimidawama꞉ eda꞉nami, ebe ba꞉ Godotamo hawa꞉goeno ikamehodawa etala. Ebeno kamenoeno mahilo Elisabetitila, ba꞉be kamenoeno nabiwi atumu Godotamo hawa꞉goeno ikamehodawala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ba꞉bene ibi netewapino emede komote Godokono holoholo hapulu tuputupunomoma꞉ ba eda꞉na, iba꞉te ebeno hiliyonomo tutumu tabamo hibinomolo papamila꞉nama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Huiyatiya ibi niliya, iba꞉godolo gudu puliyanomola mabu Elisabetiko hogoha꞉ kamenama꞉ eda꞉nami, iyo, Sekalayako ba꞉gala Elisabetiko iba꞉te kadele kabelenomoma꞉ ba eda꞉ha gudu umi wadiyaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ba꞉bene eta manomelo Sekalayakono gu tawakalubino tetete uluhukuya꞉, iba꞉te Godoko Adikumino Hiya꞉ Genamalo hiya꞉hiya꞉ oko kopowatihoma꞉. Ba꞉bema꞉ eta hegelalo Sekalayate ba꞉bolo oko nowatitiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","mabu ba꞉be hegelalo ebeno tawakaluba꞉te Godokono ubi komamo papamila꞉halo ebe belawiya꞉, ebete Godoko Adikumino Genama guamo na꞉pa꞉gate, ba꞉bolo ebete hido nibo puhulu ilina patapata hunamo ba nehaminahale Godotamo konikamehoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ba꞉bene ba꞉bi ilinate koelo ba wamotita tawakalubi hiliyonomate Godoko Adikumino Genama tamelo ibino toetoe tabo Godotamo ba꞉bo nolamagimitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ba꞉ba tetelo Godokono nopodawate hido nibo puhulu ilina wamoteno patapata tu hapudu ba pehawakala Sekalayako kapiyatamo ba꞉bo puluhukuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ba꞉bene ebete ebe umiti ukui bilibilinomoma꞉ eda꞉lo konomamo toletoliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Huiyatiya nopodawate ebetamo na꞉goiya꞉, “Sekalaya, ama꞉ akatoletola꞉la꞉. Godote amia꞉no toetoe tabo uli, ba꞉bema꞉ amia꞉no kamena Elisabetiti dubu gudu kalahimima꞉ne. Ama꞉ ebeno mahilo Yonema꞉ na꞉ka꞉miya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ba꞉ hibila, ebete da꞉hawakalamene ama꞉ konomamo ba꞉bo kokalakalama꞉na꞉ta, ba꞉gala tawakalubi hiliyonomate ba꞉be mabuma꞉ atumu konomamo kakakalakalahama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ebete menokoeno tepolo ba emedena Godokono Gobogobote ebe ya꞉lo kotabuimima꞉ne, ba꞉bema꞉ Godokono dopo hapulu ebete kodawama꞉ keda꞉ma꞉ne, ba꞉gala ebete helo gao beya a꞉kaninakamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Ba꞉ hibila, ebete hiliyonomo Isalaela tawakalubi ibino Kodawa Godotamo gala kakamagahelema꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","iyo, ebete aeno Kodawa dopamete kotoma꞉ne ba꞉gala Hido-talona Gobogobote ebe hunamo ba emede ebete helonomoma꞉ keda꞉ma꞉ne, Godokono ukui hawakalimidawa Elayako keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉na. Ba꞉bema꞉ ebete nabi ba꞉gala gugudi kapiyama꞉ gala kakamidilima꞉ne, iyo, ebete Godokono tabo ulihoha꞉pino ukui hiya꞉ma꞉ midililamete kotuputupuilamelelamema꞉ne, ba꞉gala ebete Kodawoeno tawakalubi kohiduilamema꞉ne ebeno pe komoma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekalayate Godokono nopodawatamo na꞉goiya꞉, “Na ba꞉moe komo hibinomolo keba ka꞉na na꞉kiya꞉tawamo, mabu na kadelenomola ba꞉gala naeno kamena kabelenomola?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ba꞉bene Godokono nopodawate na꞉huiyuya꞉, “Na ba꞉ Ga꞉ibiliyolotela, Godokono holoholo hapulu la꞉nanakomo, iyo, na ebete poename ba꞉moe hido tabo ama꞉ kopikiyamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Naeno tabote hibinomoma꞉ keda꞉ma꞉ne, huiyatiya ama꞉le ba꞉be tabo hibima꞉ kamidiha꞉, ba꞉bema꞉ ba꞉ma tetene tupuimiti ba꞉be hibi komote puluhuku teta꞉mo ama꞉ tabo olamagiha꞉ma꞉ keda꞉ma꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ba꞉ba tetelo hiliyonomo tawakaluba꞉te Sekalayakono puluhuku komo ba latimita iba꞉te na꞉ga꞉litiya꞉, “Tete ga꞉ga꞉nomolo ebete Godoko Adikumino Genamalo badama꞉ ka꞉luta?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ba꞉bene ebete Godoko Adikumino Hiya꞉ Genamane da꞉puluhukuya꞉ tawakaluba꞉tamo tabo olamagima꞉ kapemodobuya꞉ha꞉. Huiyatiya ebete iba꞉tamo kokotamo da꞉polamagiya꞉, ba꞉be komodo iba꞉te ba꞉ma ka꞉na iya꞉tawahuya꞉, ebete Godokono Genamalo ba luta, Godokono nopodawate ebetamo duluhuku ebeno baidi hiya꞉ma꞉ ba꞉bo eda꞉hame. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ba꞉bene Sekalayakono oko tetete Godoko Adikumino Genamalo da꞉wibuya꞉, ebete ebeno habamo ba꞉bo tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ba꞉bene komo hegela da꞉petohuya꞉ ebeno kamena Elisabetiti lamituma꞉ dediya꞉, ebete ba꞉ba tetene tupuimiti paibo manome ipuwalo ebeno genamanomolo emediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ba꞉ba tetelo ebete ebeno tepo ipuwalo tabo ba꞉ma ka꞉na goiya꞉, “Ka꞉lo kuititi hegela tetenomolo Godote na a꞉malemalenateni, iyo, ebete gudu natamo ba ikaname naeno hilopo komo gobogobamo ihatenami.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ba꞉bene Elisabetiti lamituma꞉ eda꞉te, sikisi manome da꞉petohuya꞉ Godote ebeno nopodawa Ga꞉ibiliyoloko Ga꞉lili hopoeno Nasalete habamo ba꞉bo poemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ebete bohele Ma꞉litamo Godokono nopo badahiya꞉, ba꞉be bohele dopamo Yausepetamo a꞉galuimiya꞉, ba꞉moe dubu Yausepeko ba꞉ Ko Gawadubu Da꞉ibidikono eyono gudu etala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ba꞉bene nopodawate Ma꞉liko na꞉pegoemiya꞉, “Ama꞉ nolata, Kodawa Godote ama꞉ malemalelo a꞉lawia꞉ta! Ebete ama꞉go bemedena!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ba꞉bema꞉ Ma꞉liti ba꞉be tabo duliya꞉ ukui bilibilinomoma꞉ eda꞉lo ebeno tepo ipuwalo na꞉goiya꞉, “Moe komo badala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nopodawate ebetamo na꞉goiya꞉, “Ma꞉li, ama꞉ akatoletola꞉la꞉, mabu Godote ama꞉ ba꞉ma ka꞉na a꞉malemaleta꞉ta, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ama꞉le lamituma꞉ eda꞉te dubu gudu kalahimima꞉na꞉ta, ba꞉bene ama꞉ ebeno mahilo Ya꞉suma꞉ na꞉ka꞉miya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ebete konomoma꞉ keda꞉ma꞉ne, tawakaluba꞉te ebe Hununomo Godokono Guduma꞉ ba꞉ka꞉minakomena꞉, iyo, Godote ebe Ko Gawadubuma꞉ komidima꞉ne, ebeno iniwa Da꞉ibidiko keba ka꞉na kemedenami ba꞉ba ka꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ba꞉bema꞉ hibila, Ya꞉ikobokono eyoni gugudi ipuwalo ebete emedena emedena tetelo Ko Gawadubuma꞉ beda꞉namene, iyo, ebeno Ko Gawadubuma꞉ eda꞉ komote a꞉kawibonamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma꞉liti huiyatiya nopodawatamo na꞉goiya꞉, “Na bohelenomola ba꞉gala na awihinola. Ba꞉moe komote natamo keba ka꞉na na꞉kuluhukumini?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nopodawate ebetamo na꞉huiyuya꞉, “Hido-talona Gobogobote ama꞉tamo kopema꞉ne, ba꞉gala Godokono helote ama꞉ hunamo kemedema꞉ne, ba꞉bema꞉ ama꞉le dalahimimina꞉ ba꞉be talona gudu tawakaluba꞉te Godokono Guduma꞉ ba꞉ka꞉minakomena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ama꞉ amia꞉no menokoeno naniko Elisabetikono komo nemalagidola. Dopamo tawakaluba꞉te na꞉ga꞉lanakuya꞉ ebe hogoha꞉ kamenala, huiyatiya ebete kabele tetelo lamituma꞉ eda꞉te sikisi manome ba꞉ a꞉wibui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ba꞉ hibila, hiliyonomo komokomo ododilima꞉ Godogodolo helo bitana, eta ododiha꞉ komote ebegodolo kitanaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ba꞉bema꞉ Ma꞉liti na꞉goiya꞉, “Na Kodawa Godokono huiyaha꞉ oko bohelela. Wadiyala ama꞉le da꞉gaa꞉, ba꞉be komote nuluhukamene,” ba꞉bene Godokono nopodawate ebegodone ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ba꞉ba tetelo Ma꞉liti tiyonomo mahigate Yudiya hopoeno hunuhunu hakamo tote eta muhulu habamo dito nuluhukuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ba꞉bene ebete Sekalayakono genamamo nodolote Elisabetiko ba na꞉pa꞉watameho ebetamo nolata tabo ba꞉bo nolamagiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ba꞉bema꞉ Elisabetiti Ma꞉likono nolata tabo duliya꞉, ba꞉ba tetenomolo ebeno tepo ipuwalo guduti ko kalakala lawete ba꞉bo midiwihuya꞉. Ba꞉bene Godokono Gobogobote Elisabetikono tepo ipuwa da꞉tabuimiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ebete tabo hunamo adipatelo Ma꞉litamo na꞉goiya꞉, “Hiliyonomo kamenakamena ipuwalo Godote ama꞉ hunamo adipatelo hidonomamo bowalubinamena꞉ta, ba꞉gala ama꞉le dalahimimina꞉ Godote ba꞉be Kodawa atumu emedena tetelo bowalubinamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Naeno Kodawoeno menoko, ama꞉le na unamema꞉ da꞉pa꞉ kalakala konomola, huiyatiya ba꞉moe hidonomo komote na kuba lumagitamo badama꞉ kuluhuku? ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ba꞉ hibila, nale amia꞉no tabo dulimo, ba꞉ba tetelo naeno tepo ipuwalo guduti ko kalakala lawete ba꞉bo midiwiho, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ba꞉bema꞉ ama꞉tamo kalakala bada konomola꞉ka꞉, mabu ama꞉le Godoko hibima꞉ a꞉midia꞉ta ebeno tabote ama꞉ ipuwado hibinomoma꞉ keda꞉ma꞉ne!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ba꞉bene Ma꞉liti na꞉goiya꞉, “Naeno emalagidolote Godoko nawagaminuta, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","iyo, naeno tepo ipuwate naeno Ka꞉ka꞉ Mula꞉dawa Godotamo na꞉kalakaluta, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","mabu ebete na emalagidolonelo kalakala komo ododi na ebeno deha꞉poto huiyaha꞉ oko boheletamo! Ba꞉bema꞉ ba꞉ma tetene tupuimiti emedena emedena tetelo tawakalubi hiliyonomate na kalakala lumagima꞉ ba꞉ka꞉naminakomena꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mabu Helonomo Godote natamo koko hidohido komo ododili, iyo, ba꞉be Kodawoeno mahilo ba꞉ talonala! ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","“Ba꞉ hibila, puya꞉te ebe da꞉tolemena ebete iba꞉tamo malemale bihatenakomene, iyo, tawakaluba꞉te ba꞉moe hopolo tete ga꞉ga꞉nomolo ba emedehona, ebete iba꞉tamo ba꞉ ba꞉ma ka꞉na bewagelenakomene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ba꞉bema꞉ a tetelo ebete ebeno kokotamo koko komokomo ododili, ba꞉gala puya꞉te ibi ha꞉kiya awagahalo kokoma꞉ da꞉ga꞉lui, ebete ibino nopo kubahilamete ebeno heloamo ibi a꞉ta꞉malateli. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","“Ba꞉gala ebete koko gawadubu ibino helo habane tama꞉mo a꞉miya꞉ti, huiyatiya ebete ba꞉be atu tetelo hegehege tawakalubi a꞉wadiya꞉paa꞉lateli. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iyo, puya꞉te awaelo demedehonama꞉, ebete ibi hidohido ilinamo ba tabuilame, huiyatiya dogodogo ilinagopi ilinaheno dito oelami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","“Ba꞉bema꞉ hibila, ebete aeno iniwala꞉tamo hibinomolo da꞉goiya꞉, ba꞉be tabote a tetelo ba꞉ na꞉hawakala, iyo, tete tatalila ebeno owalubi komote kuluhukuma꞉ne ebeno huiyaha꞉ okodawa Isalaelatamo. Ba꞉moe ba꞉be mabuma꞉ Godote A꞉ibalahamatamo kebe malemale ka꞉hawakalimiya꞉, ba꞉be malemala꞉mo ebeno eyoni gugudi emedena tetelo bemalagidolenamene!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ma꞉liti ba꞉moi tabo komokomo olamagi da꞉wibuya꞉, ebete netewa-kapiya manome Elisabetikoba꞉ emedete, ba꞉bene ebete ebeno habanomamo gala dito katuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ba꞉bene Elisabetikono gudu alahimi tete da꞉piya꞉ ebete dubu gudu alahimiti, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ebe tamelo demedehonama꞉ ba꞉gala ebeno mabu tawakalubi, iba꞉te Godokono hido owalubi komo Elisabetigodolo umiti eba꞉go na꞉kalakalahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ba꞉bene sa꞉ba꞉ni hegela da꞉petohuya꞉, a꞉iti hegela tetelo iba꞉te dubu guduino tama itamida kukala ododima꞉ ba꞉bo pelamiya꞉. Ba꞉ba tetelo komopa꞉te ubi bihatiya꞉ ba꞉be gudu ebeno nabiwi Sekalayakono mahilamo koka꞉mima꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","huiyatiya ebeno menokote na꞉goiya꞉, “Ao, la꞉ ebeno mahilo Yonema꞉ na꞉ka꞉ma꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ba꞉bene iba꞉te la꞉wa꞉hate ebetamo na꞉ga꞉luya꞉, “Numa꞉, la꞉eno tawakaluba꞉godolo ba꞉moe mahilo kitanaha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ba꞉bema꞉ iba꞉te ebeno nabiwitamo kokotamo ba ga꞉la ebe nalatediya꞉, ebeno ubi keba ka꞉na kitana gudutamo mahilo kikamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ba꞉bene Sekalayate kokotamo olamagilo komopa꞉te tabo miya꞉teno ilina adahemema꞉ da꞉goelamiya꞉, ebete ba꞉be ilina lawete ba꞉ma ka꞉na miya꞉tiya꞉, “Ebeno mahilo Yonetela.” Ba꞉be mabuma꞉ iba꞉te konomamo hanohanohuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ba꞉bene ba꞉ba tetenomolo Sekalayakono tabo olamagi komote da꞉kahidomiya꞉, ebete Godoko milimiho ba꞉bo tupuimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ba꞉bema꞉ ebeno habanapa꞉te ba꞉bi hanohano komo dulamiya꞉ iba꞉te koamo toletolehuya꞉, ba꞉bene iba꞉te ba꞉bi komokomo tawakalubi da꞉nikiyahalamiya꞉, ba꞉be tabote Yudiya hopoeno hunuhunu hakoeno hiliyonomo habahabamo ba꞉bo tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ba꞉gala puya꞉te ba꞉be tabo duliya꞉ iba꞉te ba emalagidolo na꞉ga꞉luya꞉, “Ba꞉moe gudu ebete kebako dawama꞉ na꞉keda꞉mene?” Iba꞉te ba꞉moe tabo bega꞉luya꞉ mabu ibino umi ipuwalo Godokono helote ba꞉be gudugodolo hibinomolo itanuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ba꞉bene Godokono Gobogobote Yonekono nabiwi Sekalayakono tepo ipuwa da꞉tabuya꞉, ebete Godokono ukui ba꞉ma ka꞉na hawakalilamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Godote Isalaela tawakalubi hidonomamo dowalubilinako, ale ebe ba꞉bema꞉ komilimihoma꞉nema꞉, mabu ebete ebeno tawakalubi owalubilima꞉ ba꞉ na꞉pe, tete tatalila ebete ibino kuba ododili ipuwane ibi kopuluhukulatelema꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Iyo, Godote a mabuma꞉ dadipati, ba꞉be Ko Ka꞉ka꞉ Mula꞉lea꞉medawate ba꞉ na꞉pe, ebe ba꞉ Godokono okodawa Da꞉ibidikono eyono gudu etala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","“Ba꞉ hibila, puya꞉te dopamo tetelo Godokono talona ipuwalo demedehonama꞉, ebete ba꞉bi okopi ipuwado ebeno ukui ba hawakalimi na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","puya꞉te maubahalete atamo alaholoho komo dododinaka, ebete a ibino helo kokotone kuluhukua꞉tema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Iyo, ebete eta tabo ba꞉ma ka꞉na kagoiya꞉, ebete aeno iniwala꞉tamo ebeno malemale bihatenamene, ba꞉gala ebete iba꞉tamo kebe nopo hibinomolo da꞉tamotiya꞉, ba꞉be hido-talona tabo ba emalagidolona emedena tetelo ebete bododinakomene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","“Ba꞉gala ebete aeno iniwa A꞉ibalahamatamo hibinomolo na꞉kagoiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","puya꞉te ago dalaholohonaka, ebete a ibino kokoto ipuwane kuwatema꞉ne, ba꞉bene ale ibi tolelameheno ebe kapiyatamo oko bowatihonakoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Iyo, ale ebeno holoholo hapulu talona tawakalubima꞉ ba eda꞉hana, ale emedena tetelo ebeno tuputupu gabodo ba꞉wapata꞉lamenama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ba꞉bene Sekalayate ebeno tabo moga꞉melo gala na꞉kagoiya꞉, “O naeno gudu Yone, tawakaluba꞉te ama꞉ Hununomo Godokono ukui hawakalimidawama꞉ ba꞉ka꞉minamena꞉ta, iyo, ebete da꞉poememene, ama꞉le ba꞉be Kodawoeno gabo dopamete ba tonato, ebeno gabo kohiduimima꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ba꞉gala ama꞉le Godokono tawakalubi ba꞉ma ka꞉na kiya꞉tulamema꞉na꞉ta, ebete ibino kuba ba egebolelame kadodoholelamema꞉ne, iyo, ebete ba꞉be gabodo ibino ka꞉ka꞉ komula꞉lelamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","“Ba꞉bema꞉ hibila, aeno Godote a konomamo ba malemalea꞉tena, ebeno ka꞉ka꞉ mula꞉leno alote atamo ba꞉bo kopuluhukuma꞉ne, hegelate tawakaluba꞉tamo da꞉puluhukunako ba꞉ba ka꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ba꞉be alote ebeno Hunu Habane kopa꞉la꞉minama꞉ne, hoe ipuwalo ba꞉gala du ipuwalo demedehona ba꞉bi tawakaluba꞉tamo, ba꞉bema꞉ kalakala konomola, Godote ebeno tatabalo wapata꞉lame komoeno gabo a ba꞉bo kiya꞉tua꞉mema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ba꞉bema꞉ Sekalayakono guduti ba ape Godokono Gobogobote ebe ipuwalo helonomoma꞉ ediya꞉, ba꞉bene ebete dito hopamo tote ba꞉bo nemedenami, huiyatiya galane Godokono ubi tetelo ebete Isalaela tawakaluba꞉tamo ba꞉bo puluhukuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ba꞉ba tetelo Konomo Gawadubu Sisa Ogastasete hopo konomamo tabo bepoemiya꞉ hiliyonomo tawakaluba꞉te ibino mahilo gabomanino bukamo konemiya꞉tehoma꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ba꞉be atu tetelo Kiliniyasete Siliya hopoeno Kapela Gawadubuma꞉ eda꞉nami. Buka ka꞉lamiholedawa, wadiyala ama꞉ niya꞉tawa, ba꞉moe ba꞉ dopo tetela hiliyonomo tawakaluba꞉te ibino mahilo gabomanino bukamo da꞉nemiya꞉tehuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ba꞉bema꞉ hiliyonomo tawakaluba꞉te ba꞉be komo konododima꞉ ibino iniwalino hiya꞉hiya꞉ habahabamo na꞉tolameholiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ba꞉bene Yausepete Ga꞉lili hopoeno Nasalete habane Yudiya hopoeno Beteleheme habamo tuya꞉, mabu ebe ba꞉ Ko Gawadubu Da꞉ibidikono eyono gudu etala ba꞉gala Da꞉ibidiko Beteleheme habalo hawakaluya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ba꞉ba tetelo Ma꞉liko ebetamo a꞉galuimiya꞉ ba꞉gala ebe lamitula, ba꞉bema꞉ ibi netewapa꞉te badi tuya꞉ iba꞉te ibino mahilo ba꞉bolo konemiya꞉tema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ba꞉bene iba꞉te Betelehemelo ba nemede eta dulu Ma꞉likono gudu alahimi tete da꞉peniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ebete ebeno dopo bahibahi gudu alahiminate ebe kalikamo a꞉wa꞉tinate kau-goegoeno hemo naha bokose ipuwamo dito adila꞉teniya꞉, mabu kapela tawakaluba꞉te da꞉lahanakui ba꞉be genamalo haba puliyala iba꞉te ba꞉bolo emedema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ba꞉ba tetelo sipi-goegoe ulamepa꞉te Beteleheme haba tamelo hemohemo hopolo ibino sipi-goegoe ba ulamena, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kodawa Godokono nopodawate iba꞉tamo pehawakalanate Godokono alo konomote ibi ba꞉bo pa꞉la꞉minaleniya꞉. Ba꞉bema꞉ iba꞉te konomamo toletolehoniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","huiyatiya nopodawate iba꞉tamo na꞉goeniya꞉, “La꞉ katoletolehonala꞉! Na la꞉tamo hido tabo badahemo, ba꞉be tabote tawakalubi hiliyonomatamo kalakala konomo kikalamema꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","mabu ka꞉lo dulu Da꞉ibidikono habalo la꞉eno Ka꞉ka꞉ Mula꞉lelamedawa a꞉hawakala, ebe ba꞉ Kodawa Kelisote, Godokono Oemedawala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","La꞉ tolamete ba꞉be gudu kalikamo a꞉wa꞉ti konumima꞉nemata, ba꞉gala ebe kau-goegoeno hemo naha bokose ipuwamo adila꞉tela, iyo, la꞉le ba꞉be hanohano komo numiti ba꞉bo kiya꞉tawahama꞉nemata naeno tabo ba꞉ hibinomola.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ba꞉ba tetenomolo ba꞉be nopodawago komo Godokono nopopi hiliyonomate ba꞉ dito pehawakalahaleniya꞉, ba꞉bene iba꞉te Godoko ba adipatena na꞉ga꞉laniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Godote ebeno Hununomo Habalo demedena, la꞉ ebe milimiholo nadipata꞉la꞉. Ba꞉moe hopolo ebete puya꞉tamo da꞉kalakalana, ebeno ka꞉ka꞉ mula꞉ komote iba꞉godolo nitanamene!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ba꞉bene Godokono nopopa꞉te Hunu Habamo gala da꞉kanalehawaminaniya꞉, ba꞉ba tetelo sipi-goegoe ulamepa꞉te na꞉ga꞉laniya꞉, “Kodawa Godote a da꞉goea꞉me Beteleheme habalo ka꞉lo dulu duluhuku, a ba꞉be komo umima꞉ kotolamiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ba꞉bene iba꞉te tiyonomo tolamenate, Ma꞉liko, Yausepeko, ba꞉gala a꞉lia꞉li gudu kau-goegoeno hemo naha bokose ipuwamo adila꞉te, iba꞉te ibi ba꞉bo nulameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ba꞉bene sipi-goegoe ulamepa꞉te gudu numinate, nopodawate ebeno komoma꞉ da꞉goeniya꞉, iba꞉te ba꞉be tabo Ma꞉liko Yausepeko ibi ba꞉bo nikiyalameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ba꞉ hibila, ba꞉ba tetene tupuimiti puya꞉te sipi-goegoe ulamepino tabo dulihuya꞉ ibi hiliyonomate konomamo hanohanohuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ba꞉gala Ma꞉liti ba꞉moi komokomo ebeno tepo ipuwamo miya꞉tenate tete hiliyonomolo koamo nemalagidolenami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ba꞉bene ba꞉be dulu sipi-goegoe ulamepa꞉te ba wilalena, Godoko adikuma꞉go ba꞉bo tolameniya꞉, mabu iba꞉te Godokono nopodawagodone kebe tabo kulihoniya꞉, iba꞉te ba꞉bi hiliyonomo komo hibinomolo a꞉nulameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ba꞉bene wuiki kapiya wibote dubu guduino tama itamida kukala ododi tete da꞉piya꞉, Yausepeko Ma꞉liko iba꞉te ba꞉moe gudu Ya꞉suma꞉ ka꞉miya꞉, mabu ebeno menokote lamituma꞉ eda꞉heno Godokono nopodawate ba꞉moe mahilo ya꞉lo ikamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Ba꞉bene tete da꞉piya꞉ iba꞉te Ya꞉suku lawete Yelusalema ko habamo dito tolamiya꞉ menokola gudula ibino agima talona konupula꞉lema꞉, Godote Moseseko ipuwado tutumu tabo dihatiya꞉ ba꞉ba ka꞉na. Iyo, ba꞉be tutumu tabote Yunapi ba꞉ma ka꞉na iya꞉tulamena, agima talona upula꞉ tetelo menokote gimai hola netewa o badu hola netewa Godotamo nikamehamene, ba꞉bema꞉ Yausepeko Ma꞉liko iba꞉te ba꞉moe tutumamo papamila꞉te hawa꞉goeno ilina ebetamo ba꞉ ba꞉ba ka꞉na ikamehuya꞉. Ba꞉gala ba꞉be atu tetelo ibi ubila gudu Ya꞉suku Godotamo ikamema꞉, mabu Godokono eta tutumu tabote ba꞉ma ka꞉na kagoena, dopo dubu gugudi talonama꞉ midiliti Godotamo kikamehoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ba꞉ba tetelo eta dubu ebeno mahilo Simiyonotela, ebete Yelusalema ko habalo emedenami. Ebe tuputupudawanomola, iyo, ebete Godotamo na꞉papamiwatanami ba꞉gala ebete Isalaela tawakalubino ka꞉ka꞉ mula꞉le komoeno uluhuku tete belatiminami. Ba꞉bema꞉ Godokono Gobogobote eba꞉go ba emedena ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ebe ya꞉lo a꞉goemiya꞉ ba꞉ma ka꞉na, ebete Godokono Oemedawa Kelisoko dopamo umiti ebe galane ba꞉bo kohoema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ba꞉bene Ma꞉liko Yausepeko iba꞉te Godokono tutumamo papamila꞉lo ibino gudu Godoko Adikumino Hiya꞉ Genamamo da꞉magatuya꞉, ba꞉be komo Godokono Gobogobote Simiyonoko ba꞉bo iya꞉tumiya꞉. Ba꞉ba tetelo ebete Godokono Genamamo pete, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","gudu Ya꞉suku pumiti ebeno kokotamo ebe pematopa꞉te Godotamo kalakala tabo ba꞉ma ka꞉na polamagiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kodawa, ama꞉le dopamo hibinomolo da꞉goiya꞉la ba꞉be tabote a꞉hawakala, ba꞉bema꞉ na amia꞉no huiyaha꞉ okodawate gelebadia꞉go hoea꞉mo kotoma꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Hibila, ka꞉lo naeno baida꞉mo amia꞉no ka꞉ka꞉ mula꞉ komo ba꞉ umimo, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ba꞉be ka꞉ka꞉ mula꞉ komo ama꞉le a꞉hiduimiya꞉ta hiliyonomo hiya꞉hiya꞉ tawakalubino holoholo hapulu. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iyo, amia꞉no ka꞉ka꞉ mula꞉ komo ba꞉ hido alola, ba꞉be alote Yuha꞉pa꞉tamo amia꞉no ubi gabo ba hawakalimina, amia꞉no Isalaela tawakaluba꞉tamo koamo ba꞉la꞉minanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ba꞉bene Simiyonote gudu Ya꞉sukunu komoma꞉ kebe tabo kolamagiya꞉, Ma꞉liko Yausepeko iba꞉te ba꞉be tabo uliti konomamo hanohanohutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ba꞉ba tetelo Simiyonote Godoko bikiyamiya꞉ ebete ibi hidamo kowalubilinama꞉, ba꞉gala ebete guduino menoko Ma꞉litamo na꞉goiya꞉, “Ba꞉moe gudu Ya꞉suku Godote ebe ya꞉lo ka꞉miti a꞉lawiya꞉, ba꞉bema꞉ ebete Isalaela tawakalubi ipuwalo ibino kubakuba komo ba꞉gala hidohido komo hiliyonomo kanagilamelelamema꞉ne. Iyo, ebeno emede komote hanohano komoma꞉ eda꞉te Godokono helo kohawakalimima꞉ne, ba꞉bema꞉ komo tawakaluba꞉te ba꞉be komo umiti ubiha꞉ tabo ga꞉late ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ibino kubakuba ukui kohawakalilamema꞉na꞉. Ba꞉ba tetelo ko temetemete ama꞉tamo puluhukuti, alaholohoeno kiyokiyo gili keba ka꞉nala꞉ka꞉ ba꞉be temetemete amia꞉no tepo ipuwa ba꞉ba ka꞉na kalihamidama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ba꞉be atu tetelo eta Godokono ukui hawakalimidawa kamenate nemedenami, ebeno mahilo A꞉natela, ebeno nabiwi Pa꞉nuwelatela, ebe A꞉sa gu lumagila. Ba꞉moe kamena ba꞉ kabelenomola. Dopamo ebete dubu lawete sa꞉ba꞉ni gogo emedete ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ebeno awiti ba꞉bo hoiya꞉, ba꞉bene ebete hamolema꞉ eda꞉te ba꞉ba tetene tupuimiti ebeno 84 gogo teta꞉mo puluhuku, ebete hegela ba꞉gala du hiliyonomolo Godoko Adikumino Hiya꞉ Genamalo ba emedena ba꞉be genama kamiya꞉panakuiha꞉. Ba꞉be tete ga꞉ga꞉nomolo ebete Godoko ba adikumina, komo tete hiliyonomolo baa꞉ nahaheno Godotamo toetoe tabo ba꞉bo olamaginakui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ba꞉bene Yausepeko Ma꞉liko iba꞉te Simiyonokoba꞉ tabo ba ga꞉luta, ba꞉be atu tetenomolo A꞉nate pete gudu Ya꞉suku pumiti kalakala tabo Godotamo ba꞉bo padipatiya꞉. Ba꞉bema꞉ ba꞉ba tetene tupuimiti, Yelusalemanapi ipuwalo puya꞉te ibino ka꞉ka꞉ mula꞉le komoeno uluhuku tete da꞉latiminama꞉, iba꞉te Godokono Genamamo da꞉pelamenakui A꞉nate ibi hiliyonomatamo Ya꞉sukunu komoma꞉ ba꞉bo olamaginakui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ba꞉bene Ma꞉liko ba꞉gala Yausepeko iba꞉te Godokono hiliyonomo tutumuino komokomo hidamo ododiliti, iba꞉te Ga꞉lili hopoeno Nasalete habamo gala na꞉katuya꞉ mabu ba꞉be ba꞉ ibino habanomola. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ba꞉bolo gudu Ya꞉suti ba ape heloma꞉ ba꞉bo ediya꞉, ba꞉gala ebete ukui muludawama꞉ eda꞉lo Godote ebeno malemale komamo ebe nowalubinami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ya꞉sukunu menoko nabiwi ibino komo ba꞉ma ka꞉nala, gogo hiliyonomolo iba꞉te komo tawakaluba꞉go Yelusalema ko habamo tolamenakuya꞉ Yunapino Adaguila꞉ Poko konododima꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ba꞉bene Ya꞉suti 12 gogo tetema꞉ ba eda꞉ iba꞉te ebe lawete gala na꞉katolamiya꞉ ba꞉be poko habamo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ba꞉bene Pokoeno hegelate da꞉wibohuya꞉ iba꞉te Nasalate habamo gala na꞉kapelamiya꞉, huiyatiya Ya꞉suti Yelusalemalo da꞉pekaguya꞉ ebeno menoko nabiwi iba꞉te kiya꞉tawahuya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iba꞉te Ya꞉suku tawakaluba꞉go habamo na꞉tomo ga꞉late, ba꞉be hegela kapiyalo tonomo tote, ba꞉bene gapogapolo iba꞉te ebe ibino tawakaluba꞉godolo ba꞉gala mabuluba꞉godolo nohowadinate ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ebe kanuminiya꞉ha꞉. Ba꞉bema꞉ eta hegelalo iba꞉te ebe ohowada꞉go Yelusalema ko habamo gala katote, ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ba꞉bene netewa-kapiya hegelalo iba꞉te ebe Godoko Adikumino Hiya꞉ Genamalo iya꞉tulamepi dubago ba luta ba꞉bo numiya꞉, ebete ibino tabo ba uliho ibino iya꞉tulame komokomoma꞉ ba꞉bo alateda꞉lenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ba꞉ba tetelo Ya꞉suti iba꞉go tabo ba ga꞉la ibi tuputupu tabamo da꞉huiyalamenakui, ba꞉bema꞉ puya꞉te ebeno tabo dulihutiya꞉ ibi hiliyonomate koamo hanohanohutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ba꞉bema꞉ Ma꞉liko Yausepeko ibi netewapa꞉te ebe da꞉numiya꞉, koamo nela꞉wa꞉hate menokote ebe na꞉goemiya꞉, “Gudu, ama꞉ ba꞉moe komo atamo badama꞉ kododiui? Amia꞉no nabiwi ba꞉gala na, ale ama꞉ tepo temetema꞉go ohowadinata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “Mabu keka꞉ la꞉le na ba꞉moe haboeno hiya꞉hiya꞉ genamalo dohowadinitakama? Wadiyala la꞉ niya꞉tawahala꞉ na naeno Nabiwino Genamalo ba꞉lutamo, na eta genamalo luta a꞉kamodobamo!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iba꞉te huiyatiya ba꞉be taboeno ipuwa hidamo kalawiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ba꞉ba tetelo Ya꞉suti ebeno menoko nabiwi iba꞉go Nasalete habamo tote, ba꞉bolo ba nemedena ibino tabamo a꞉papamiwatanakui, ba꞉bene Ma꞉liti ba꞉moi komokomo ebeno tepo ipuwamo miya꞉tete hiliyonomo tetelo koamo nemalagidolenami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ba꞉bema꞉ ba꞉moe komo ba꞉ hibila, Ya꞉suti mulu emalagidolago ba ape, Godoko ba꞉gala tawakalubi ebetamo na꞉kalakalahanama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ba꞉ba tetelo Sisa Taibiliyasiti 15 gogolo hopo konomoeno Konomo Gawadubuma꞉ ba eda꞉na, komo dubate ebeno hopopima꞉ ba꞉ma ka꞉na eda꞉hanama꞉, Poniyase Paeleteko Yudiya hopoeno Kapela Gawadubula. Helodiko Ga꞉lili hopoeno Ko Gawadubula. Ebeno ekawi Pilipiko Ituliya hopo ba꞉gala Ta꞉konaitasi hopoeno Ko Gawadubula. Ba꞉gala Laisaniyasiko A꞉bilini hopoeno Ko Gawadubula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ba꞉be atu tetelo A꞉nasiko ba꞉gala Kayapasiko ibi netewapa꞉te Godotamo hawa꞉goeno ikamehopino Hununomo Watowatopima꞉ eda꞉nama꞉, ba꞉bene Sekalayakono gudu Yoneko ebete dito hopolo ba nemedena Godokono tabote ebetamo ba꞉bo piya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Iyo, ebete Yodane Tulino hopo konomamo tote Godokono tabo ba꞉ma ka꞉na nolamagiya꞉, “La꞉eno kubane ohobila꞉te beyamo aduti komo lawema꞉ na꞉pelama꞉la꞉, ba꞉bene Godote la꞉eno kuba egebolelamete kadodoholelamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ba꞉ hibila, Godote dopamo ebeno ukui hawakalimidawa Aisayagodone Yonekono pe komoma꞉ ebeno Bukamo tabo ba꞉ma ka꞉na miya꞉tiya꞉, “Lumagiti dito hopolo tabo ba꞉ma ka꞉na ibulu kopegoema꞉ne, ‘Kodawoeno gabo na꞉hiduima꞉la꞉, ebeno gabo na꞉tuputupuima꞉la꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Godote ba꞉moe hopoeno haka bola꞉la꞉ha hiliyonomo ihilateholete, hunuhunu haka apotalamima꞉ komidilima꞉ne, iyo, ebete keka꞉keka꞉ gabo hibilo tuputupuilamete, gaboeno haka gugu ihilateholete kodilidililamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ba꞉ hibila, ebete tawakalubino ka꞉ka꞉ da꞉mula꞉lelamemene, ibi hiliyonomate ba꞉be komo ba꞉bo kumima꞉na꞉!’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ba꞉bene tawakalubi hiliyonomate Yonetamo na꞉pelamiya꞉ ebete ibi beyamo kowadulatelema꞉, huiyatiya ebete iba꞉tamo na꞉goiya꞉, “La꞉ bu kalulata! La꞉ pote ka꞉goelamiti beyamo wadulatelema꞉ da꞉pelamema, aba꞉, Godokono konomo mauba komote la꞉tamo a꞉kapa꞉mene? Ao, kopema꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","La꞉eno tepo ipuwa hiya꞉ma꞉ da꞉midilima, wadiyala la꞉ la꞉eno hibi komo hawakalimima꞉ hidohido komo nododila꞉la꞉. La꞉ ha꞉kiya la꞉tamo ba꞉mako tabo ga꞉la akatupuima꞉la꞉, ‘A modobola mabu A꞉ibalahamako ba꞉ aeno iniwa nabiwila.’ Ao, la꞉ a꞉kamodobamata! Na la꞉tamo hibi tabo begoemo, Godogodolo helo bitana ebete ba꞉moi nakolamo A꞉ibalahamakono gugudi kododilimima꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ba꞉bema꞉ ka꞉lo Godote ebeno kabi adi, hiliyonomo nolohoha꞉ gao keha ebete luhuti koa꞉mo kiya꞉hekema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tawakaluba꞉te ba꞉be komo uliti Yoneko nalatediya꞉, “A Godokono mauba duhimima꞉ bada komo na꞉kododima꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ebete ba huiya na꞉goiya꞉, “Wadiyala kaliko netewagodawate eta kalikoha꞉dawa kowalubima꞉ne, ba꞉gala baa꞉godawate baa꞉ha꞉dawa kowalubima꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ba꞉bene komo ta꞉kese mani ha꞉da amiholo uwatepi dubu iba꞉te beyamo wadulatelema꞉ da꞉pelamiya꞉, iba꞉te ebe na꞉palatediya꞉, “Iya꞉tulamedawa, a bada komo na꞉kododima꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ebete ibi na꞉goelamiya꞉, “La꞉le ta꞉kese mani uwate tetelo ha꞉da gabodo konomamo akuwatenakala꞉ la꞉ ha꞉kiya la꞉ owalubilima꞉, huiyatiya gabomani dubate da꞉ga꞉lanaka ba꞉be modobolo nuwatenakuya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ba꞉bene komo alaholohopa꞉te Yoneko nalatediya꞉, “A keba ka꞉nala꞉ka꞉? A bada komo na꞉kododima꞉?” Ba꞉bene ebete iba꞉tamo na꞉goiya꞉, “La꞉le komo tawakalubino mani heloamo o ha꞉da gabodo akuwata꞉la꞉, ba꞉gala la꞉eno tabo ga꞉la ipuwalo komo tawakalubi akakubahilama꞉la꞉, ba꞉gala la꞉eno oko huiya da꞉lawenakoma ubiha꞉ tabo ga꞉laheno kalakalago nuwatenakuya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tawakaluba꞉te Yonekono komo ba emalagidolo, iba꞉te kalakalahalo nemalagidoluya꞉ Yoneko da꞉ Godokono Oemedawa Kelisotela꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ba꞉bene Yonete iba꞉tamo na꞉goiya꞉, “Nale la꞉ beyamo wadulatelemata, huiyatiya eta lumagiti naeno gala hapuni ba꞉pena. Ebeno helo konomote naeno helo na꞉gogolona, ba꞉bema꞉ na hidoenoha꞉ nale ebeno nato ukulalemema꞉. Hibila, ebete la꞉ Godokono Gobogobamo ba꞉gala ebeno koa꞉mo kopewadulatelema꞉na꞉ta, ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","iyo, ebete witi-laisoeno nonoka tama꞉mo miya꞉teno ilina a꞉lawi, ba꞉bene ebete witi-laisa nahoeno ebeno genama guamo ba miya꞉te nonoka koa꞉mo ba꞉bo kiya꞉hekema꞉ne, ba꞉be koete itana tetelo na꞉woena, a꞉kaha꞉gale.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ba꞉ hibila, Yonete Godokono Hido Tabo dolamaginakui, ebete hiliyonomo hiya꞉hiya꞉ komokomo biya꞉tulamenakui tawakaluba꞉te ibino ukui hiya꞉ma꞉ komidilima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ba꞉bene eta hegelalo Yonete Ko Gawadubu Helodiko konomamo kiyahamiya꞉, mabu ebete ebeno ekawino kamena Helodiyasiko pilolo lawiya꞉ ba꞉gala ebete komo hiliyonomo kubakuba komo bododilinakui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ba꞉ba tetelo Heloditi eta konomo kuba komo ba꞉ma ka꞉na kododiya꞉, ebete Yoneko du genamamo dito ihatiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Heloditi ebe du genamamo ihateheno, dopamo Yonete tawakalubi hiliyonomo beyamo a꞉wadulateliya꞉, Ya꞉suku baleta. Ba꞉bema꞉ Ya꞉suti beyamo aduti komo lawete, Godotamo kalakala tabo ba olamagita Godote ebeno Hunu Haba ba꞉bo a꞉hiya꞉miduya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ba꞉bene Godokono Gobogobote gimai holamo ebe hunamo ba pihitiga, tabote Hunu Habane ba꞉ma ka꞉na pihitiguya꞉, “Ama꞉ naeno kapiya Gudunomolata. Na ama꞉tamo na꞉kalakalutamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ya꞉suti 30 gogoma꞉ ba eda꞉ ebete ebeno ko oko ba꞉bo tupuimiya꞉, ba꞉bene ebeno mabu tawakalubino mahiloeno komo ba꞉ ba꞉ma ka꞉nala. Tawakaluba꞉te ibino ukuilo ebe Yausepekono guduma꞉ ga꞉lanama꞉, ba꞉moe Yausepeko ba꞉ Hilaikono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilaiko Mata꞉takono gudula. Mata꞉tako Libaikono gudula. Libaiko Melekaikono gudula. Melekaiko Yanaikono gudula. Yanaiko Yausepekono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yausepeko Mata꞉tayasikono gudula. Mata꞉tayasiko A꞉imosokono gudula. A꞉imosoko Na꞉ihumakono gudula. Na꞉ihumako Esalaikono gudula. Esalaiko Nagaikono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiko Maa꞉takono gudula. Maa꞉tako Mata꞉tayasikono gudula. Mata꞉tayasiko Sema꞉inikono gudula. Sema꞉iniko Yausekekono gudula. Yausekeko Yaudakono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yaudako Yowananakono gudula. Yowananako Lisakono gudula. Lisako Selababelakono gudula. Selababelako Siyatiyelakono gudula. Siyatiyelako Nelaikono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nelaiko Melekikono gudula. Melekiko Adaikono gudula. Adaiko Kosamakono gudula. Kosamako Elamadamakono gudula. Elamadamako Eyakono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eyako Yosuwakono gudula. Yosuwako Eliyesakono gudula. Eliyesako Yolimikono gudula. Yolimiko Mata꞉takono gudula. Mata꞉tako Libaikono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libaiko Simiyonokono gudula. Simiyonoko Yudakono gudula. Yudako Yausepekono gudula. Yausepeko Yaonamakono gudula. Yaonamako Elayakimikono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elayakimiko Meleyakono gudula. Meleyako Menakono gudula. Menako Mata꞉taikono gudula. Mata꞉taiko Na꞉itanakono gudula. Na꞉itanako Da꞉ibidikono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Da꞉ibidiko Yesikono gudula. Yesiko Obedakono gudula. Obedako Bowasekono gudula. Bowaseko Samonokono gudula. Samonoko Nasonakono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasonako Aminadabakono gudula. Aminadabako Adaminakono gudula. Adaminako Anikono gudula. Aniko Hesalonakono gudula. Hesalonako Pelesekono gudula. Peleseko Yudakono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yudako Ya꞉ikobokono gudula. Ya꞉ikoboko Aisa꞉kekono gudula. Aisa꞉keko A꞉ibalahamakono gudula. A꞉ibalahamako Telakono gudula. Telako Nehokono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nehoko Selugukunu gudula. Seluguku Liyukunu gudula. Liyuku Pelegekono gudula. Pelegeko Ibakono gudula. Ibako Silakono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Silako Ka꞉inanekono gudula. Ka꞉inaneko Apasa꞉dakono gudula. Apasa꞉dako Semakono gudula. Semako Nowakono gudula. Nowako La꞉imekakono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","La꞉imekako Metusalakono gudula. Metusalako Inokokono gudula. Inokoko Yeledikono gudula. Yelediko Mahalalelakono gudula. Mahalalelako Ka꞉inanekono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ka꞉inaneko Inosokono gudula. Inosoko Setakono gudula. Setako A꞉da꞉mekono gudula. A꞉da꞉meko Godokono gudula. Ba꞉bema꞉ ba꞉moe ba꞉ Ya꞉sukunu mabu tawakalubino komoeno kuititila. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ba꞉bene Godokono Gobogobote Ya꞉sukunu tepo ipuwa tabuimiti, Yodane Tulini ba magata ebete dito hopamo ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ba꞉bene Ya꞉suti dito hopolo 40 hegela ba nemede Saitanate ebe kuba gabamo kemogabuimima꞉ ebetamo ba꞉bo uluhukuya꞉. Ba꞉be tete ga꞉ga꞉nomolo Ya꞉suti baa꞉ kananakuiha꞉, ba꞉bema꞉ ba꞉be tete da꞉wibuya꞉ ebete baa꞉ma꞉ kape komo ba꞉bo iya꞉tawuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ba꞉bene Saitanate ebe na꞉goemiya꞉, “Ama꞉ Godokono hibi Guduma꞉ deda꞉na, ba꞉moe nakola baa꞉ma꞉ na꞉mida꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ya꞉suti ebeno tabo ba huiya na꞉goiya꞉, “Godokono Bukalo tabo ba꞉ma ka꞉na itana, ‘Lumagiti ba꞉moe hopoeno baa꞉ kapiyalo a꞉kaka꞉ka꞉namene.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ba꞉bene Saitanate Ya꞉suku hunamo magatate ba꞉moe hopo konomoeno hiya꞉hiya꞉ koko hopo ba niya꞉tumiho, iba꞉te ba꞉ba tetenomolo ba꞉bi hiliyonomo ilina bulameholiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Saitanate ebetamo na꞉goiya꞉, “Ba꞉moi hiliyonomo ilina ba꞉gala helo konomo nale ama꞉tamo kikamehoma꞉nemata. Ba꞉ hibila, hopo haboeno ilina hiliyonomo Godote natamo ikanamehoniya꞉, ba꞉be mabuma꞉ nale kebe lumagitamo ikamema꞉ ubi dihatemo nagodolo helo bitana ebetamo kikamehoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iyo, ama꞉le na nadikunama꞉, ba꞉bene ba꞉moi ilina hiliyonomo ama꞉le kuwatema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Huiyatiya Ya꞉suti ebeno tabo ba huiya na꞉goiya꞉, “Godokono Bukalo tabo ba꞉ma ka꞉na itana, ‘Ama꞉ amia꞉no Kodawa Godoko adikumilo ebe kapiyatamo na꞉papamiwatanakuya꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ba꞉bene Saitanate ebe Yelusalema ko habamo magatate Godoko Adikumino Hiya꞉ Genamoeno uba hunamo nadipiti ebe ba꞉bo negoemiya꞉, “Ama꞉ Godokono hibi Guduma꞉ deda꞉na, ba꞉moene hakamo na꞉nepatega, ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","mabu Godokono Bukalo tabo ba꞉ma ka꞉na itana, ‘Godote ebeno nopopi kopoelamema꞉ne iba꞉te ama꞉ hidamo kopowalubima꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","iyo, iba꞉te ibino kokotamo ama꞉ kopelawema꞉na꞉ta, ba꞉bema꞉ ama꞉le nakolalo nato a꞉kanukamidamena꞉ta.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Huiyatiya Ya꞉suti ebetamo na꞉huiyuya꞉, “Ao, nale ba꞉be kuba komo a꞉kododa꞉mo, mabu Godokono Bukalo eta tabo ba꞉ma ka꞉na itana, ‘Hopo lumagiti Kodawa Godoko pawima꞉ akewagela꞉la꞉.’ Iyo, ba꞉be mabuma꞉ hopo haba lumagiti ebeno daedae ukuia꞉mo eta komo dododimini, ebete akemalagidolala꞉ Godote ebeno ka꞉ka꞉ dito kopemula꞉mema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ba꞉bene Saitanakono kuba gabamo emogabuimiho komokomo hiliyonomo da꞉wibohuya꞉, ebete Ya꞉suku tete nanekela꞉mo ba꞉bo miya꞉puya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ba꞉ba tetelo Ya꞉suti Godokono Gobogoboeno heloago Ga꞉lili hopamo gala na꞉katuya꞉, ba꞉bene ba꞉be hopo konomolo demedehonama꞉ ba꞉bi tawakalubi hiliyonomate Ya꞉sukunu komoma꞉ tabo ba꞉bo nikiyahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ebete ba꞉bi Yu tawakalubino baidi ibubulamehole genamalo ibi diya꞉tulamenakui, ba꞉be mabuma꞉ ibi hiliyonomate ebe konomamo milimihonakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Eta hegelalo Ya꞉suti ebeno emede haba Nasaleta꞉mo na꞉tuya꞉, ba꞉bene ebete Yu tawakalubino okoha꞉ talona hegelalo dopamo keba ka꞉na kododinakui, ebete ba꞉be hegelalo atu komo bekanododiya꞉, iyo, ebete tawakalubino baidi ibubulamehole genamamo nodolote Godokono Bukoeno tabo ka꞉lamiholema꞉ ba꞉bo mahiguya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ba꞉bene iba꞉te Aisaya buka mokopi ebetamo ikamete, ebete pahaa꞉midate buka ka꞉lamihole ba꞉ma ka꞉na ba꞉bo tupuimiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Godokono Gobogobote nagodolo bemedena, mabu ebete na a꞉laweniya꞉, nale awaelo demedehona ba꞉bi tawakaluba꞉tamo Godokono Hido Tabo katama꞉. “Ebete na a꞉poenamiya꞉ du genamalo demedehona ba꞉bi tawakaluba꞉tamo, ba꞉bema꞉ nale ibi kokiyalamema꞉nemo, tete ba꞉ na꞉pe ibi du genamane kuluhukulatelema꞉, ba꞉gala na baidi tamiholame tawakalubi kokiyalamema꞉nemo, ibino baiditi ka꞉la꞉minahalelamema꞉. “Iyo, nale menemena꞉go da꞉wapata꞉lamena ba꞉bi tawakalubi tutunomoma꞉ komidilima꞉nemo, ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ba꞉gala Kodawa Godote ibino ka꞉ka꞉ da꞉mula꞉lelamemene, nale ibi ba꞉moe tabo kokiyalamema꞉nemo, ba꞉be komote ba꞉ na꞉pe.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ba꞉bene buka ka꞉lamihole da꞉wibuya꞉ Ya꞉suti buka gala kamokopiti okodawatamo ikamete tawakalubi iya꞉tulamema꞉ ibino holoholo hapulu dito emediya꞉. Ba꞉ba tetelo baidi ibubulamehole genama gulu da꞉pola꞉nuya꞉ ba꞉bi tawakaluba꞉te Ya꞉suku hidonomamo umihutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ba꞉bema꞉ ebete iba꞉tamo na꞉goiya꞉, “Ka꞉lo nale ba꞉moe buka tabo da꞉ka꞉lamiholemo, ba꞉ba tetenomolo ebeno hibi komote la꞉tamo ba꞉ a꞉puluhuku.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ba꞉bene ebete Godokono tabo iba꞉tamo ba olamagita ibi hiliyonomate nemalagidolutiya꞉, “Ya꞉suku ba꞉ hidonomo lumagila,” ba꞉gala iba꞉te ebeno tabone kebe tabo kulihuya꞉ ba꞉bi hidohido taboma꞉ hanohanoholo na꞉ga꞉lutiya꞉, “Moe ba꞉ Yausepekono gudula, ebeno mulu keba ka꞉nala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ba꞉bene ebete iba꞉tamo na꞉goiya꞉, “Na la꞉tamo hibi tabo begoemo. Tawakaluba꞉te muluma꞉ da꞉ga꞉lanaka, galane la꞉le ba꞉bako tabo natamo ba꞉ma ka꞉na koga꞉lama꞉nemata, ‘Ama꞉ hibi dogetama꞉ deda꞉na, wadiyala ama꞉ ha꞉kiya ama꞉ na꞉hiduima꞉.’ Ba꞉gala la꞉le na kokiyanamema꞉nemata, ‘Ama꞉le Kapeniyama habalo da꞉nododili ale ba꞉bi hanohano komo ulihuima꞉, ba꞉bema꞉ ka꞉lo huiyatiya amia꞉no habanomolo ba꞉bako komokomo na꞉kododila꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ya꞉suti iba꞉tamo gala na꞉kagoiya꞉, “Na la꞉tamo hibi tabo begoemo, Godokono ukui hawakalimidawa ebeno habaluba꞉te ebe ubiha꞉ma꞉ eda꞉hate a꞉kalawa꞉mena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ba꞉bema꞉ la꞉ naeno hibi tabo nulia꞉la꞉. Elayate demedenami ba꞉ba tetelo gogo netewa-kapiyalo wegolate konakuiha꞉, hopo konomolo naha ilinate ba꞉bema꞉ wibohuya꞉. Ba꞉ba tetelo hamolehamole hiliyonomate Isalaela hopolo awaelo emedehonama꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","huiyatiya Godote Elayako ba꞉bi Yu tawakalubino hamolehamola꞉tamo kanoemiya꞉ha꞉. Ao, ebete ebe Saidono hopoeno Sa꞉lepata habamo noemiya꞉, ba꞉bolo demedenami ba꞉be hamole kapiyanomo konowalubima꞉. Ba꞉be kamena Yu lumagiha꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ba꞉gala ba꞉moe ba꞉ eta komola. Eta Godokono ukui hawakalimidawa Elaisakono tetelo Isalaela hopolo hiliyonomo kuitikuita꞉gopi dubate nemedehonama꞉, huiyatiya ibi ipuwalo Godote eta dubu kahiduimiya꞉ha꞉, eta Siliya hoponapi Na꞉imanako kapiya bihiduimiya꞉. Ba꞉be dubu Yu lumagiha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ba꞉bene Yu tawakalubino baidi ibubulamehole genamalo da꞉pola꞉nuya꞉, ibi hiliyonomate ba꞉be tabo duliya꞉ konomamo maubahaliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ba꞉bema꞉ iba꞉te mahila꞉halete Ya꞉suku lawete haba ipuwane heloamo ba꞉bo uluhukutiya꞉, mabu ibi ubila ebe eta haka hunamo magatate iya꞉ha꞉midale hakane kopenemokamidama꞉, iyo, ba꞉mako haka Nasalete haba tamelo itanami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ba꞉ba tetelo Ya꞉suti huiyatiya ba꞉bi hiliyonomo tawakalubi tetedo tote ebeno to gabodo ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ba꞉bene Ya꞉suti Ga꞉lili hopoeno Kapeniyama habamo tote, Yu tawakalubino okoha꞉ talona hegelalo tawakalubi da꞉niya꞉tulamitiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","iba꞉te ebeno tabamo na꞉hanohanohutiya꞉ mabu ebete tabo Godokono heloamo olamagitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ba꞉ba tetelo ibino baidi ibubulamehole genama gulu kuba gobogobagoeno dubuti ba꞉bolo na꞉lutiya꞉, ba꞉bene ebete gaa꞉tepahalo ibulunomamo na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Iya꞉! Ya꞉su Nasaletenapi, ama꞉ atamo bada komo na꞉kododiomena꞉? Ama꞉ a kubahia꞉mema꞉ ka꞉pa꞉wa? A꞉iye, na iya꞉tawala amia꞉no komo, ama꞉ ba꞉ Godokono Hido-talona Dawalata!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ya꞉suti huiyatiya ebe na꞉kiyahamiya꞉, “Ama꞉ kodakodate, ebegodone nuluhuka!” Ba꞉bene kuba gobogobote tawakalubino holoholo hapulu ba꞉be dubu hopamo a꞉da꞉nate ebegodone ba꞉bo uluhukuya꞉, huiyatiya ebetamo eta kuba komo kododiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ba꞉bema꞉ ba꞉bi tawakalubi hiliyonomate hanohanoholo etate etatamo goenakui, etate etatamo goenakui, ba꞉ma ka꞉na ewagelitiya꞉, “Ba꞉moe taboeno helo keba ka꞉nala꞉ka꞉? Ba꞉moe dubuino helo ba꞉gala ha꞉hi konomola! Numa꞉la꞉, kuba gobogobate ebeno tabo ulihote gobogobamo ba꞉ alahutiha!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ba꞉bene Ya꞉sukunu oko owati tabote ba꞉be hopo konomamo ba꞉ dito tuya꞉, iyo, puya꞉te ba꞉bolo demedehonama꞉ ibi hiliyonomate ebeno komoma꞉ tabo ba꞉bo nikiyahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ba꞉bene Ya꞉suti Yu tawakalubino baidi ibubulamehole genamane puluhukuti Saimonokono genamamo dito tuya꞉. Ba꞉bolo Saimonokono moto kakidubu ape koenomo tawetawete umitiya꞉, ba꞉bene ebeno komoma꞉ tawakaluba꞉te Ya꞉suku ba꞉bo ga꞉lamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ba꞉bema꞉ Ya꞉suti tote ebeno wata baha꞉mo nutiti ba꞉be tawetawete ebe komiya꞉pama꞉ da꞉kiyamiya꞉, ba꞉ba tetenomolo tawetawete ebegodone ba uluhuku ebete mahigate ibi mabuma꞉ baa꞉ okalimi oko ba꞉bo tupuimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ba꞉ba tetelo hegelate da꞉nihila꞉minaniya꞉, puya꞉te ba꞉be habalo hiya꞉hiya꞉ temetema꞉go da꞉pola꞉nuya꞉ ibino mabuluba꞉te ibi hiliyonomo Ya꞉sutamo ba꞉bo magaheleniya꞉, ba꞉bene ebete ebeno kokoto iba꞉tamo emowatilamelo ibi hiliyonomo ba꞉bo hiduilameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ba꞉gala ebete kuba gobogobo da꞉kiyahalameniya꞉, iba꞉te komo tawakalubi hiliyonomagodone ba ikulina ga꞉ga꞉go tabo ba꞉ma ka꞉na ga꞉laniya꞉, “Ya꞉su, ama꞉ ba꞉ Godokono Gudulata!” Ba꞉ hibila, ba꞉bi kuba gobogobo iya꞉tawahala Ya꞉suku ba꞉ Godokono Oemedawa Kelisotela, huiyatiya ebete ibi ba kiyahalamena tabo ga꞉la talona ba꞉bo ihatelameniya꞉ iba꞉te ebeno komo hawakalimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ba꞉bene hegelate ba owalohuta Ya꞉suti ba꞉be habane uluhukuti tataba hopamo na꞉tuya꞉, ba꞉bema꞉ tawakaluba꞉te ebe ohowada꞉go tolamete ba꞉bo numiya꞉, mabu ibi ubihinola Ya꞉suti ibi miya꞉pale. ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Huiyatiya Ya꞉suti iba꞉tamo na꞉goiya꞉, “Wadiyala na komo habahabamo tote, Godote Ko Gawadubuma꞉ deda꞉na ba꞉be komoeno Hido Tabo konolamagima꞉nemo, mabu Godote na ba꞉bema꞉ poenamiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ba꞉bene Ya꞉suti ba꞉be hopoeno hiliyonomo habahabamo tonakui Yu tawakalubino baidi ibubulamehole genama gulu Godokono tabo ba꞉bo nolamaginakui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Eta tetelo Ya꞉suti Genasalete Bobo dodolo ba la꞉na tawakalubi hiliyonomate ebetamo emokatihuia꞉go tolamitiya꞉ Godokono tabo ulihoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ba꞉bene ebete boge netewa bobo dodolo pola꞉nalo ulamiya꞉, daha uwateholepi dubate ba꞉bi boge ya꞉lo miya꞉palete iba꞉te ibino kamahu bukulalitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ba꞉bema꞉ ibi ipuwalo Ya꞉suti eta dubuino boga꞉mo ololuya꞉, ba꞉be dubuino mahilo ba꞉ Saimonotela. Ba꞉bene Ya꞉suti ebe da꞉goemiya꞉ ebete ebeno boge dodone nanekela꞉mo kalima꞉tepama꞉, ebete ba꞉be komo ododiti Ya꞉suti boga꞉mo emedete Godokono tabo tawakalubi ba꞉bo iya꞉tulamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ba꞉bene ebete Godokono tabo olamagi da꞉wibuya꞉ Saimonoko ba꞉bo goemiya꞉, “Boge nanekela꞉mo kulukulu teta꞉mo gala kalima꞉tepate, ama꞉ ba꞉gala amia꞉no mabulubi la꞉eno kamahu beyamo na꞉wahuba꞉la꞉ daha kuwateholema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Huiyatiya Saimonote ebetamo ba huiya na꞉goiya꞉, “Ko Iya꞉tulamedawa, a du ga꞉ga꞉nomolo nipo wahubihonakama꞉, eta daha kalawenakaha꞉. Huiyatiya kubaha꞉, mabu ama꞉le na da꞉kiyanama꞉, ba꞉bema꞉ nale amia꞉no tabamo papamiwatalo na kamahu beyamo kowahubitotema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ba꞉bema꞉ ebete komo okopa꞉go ba꞉be komo dododiya꞉, dahadaha hiliyonomate tahate kamahu tatalila ta꞉teho, ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ba꞉bene iba꞉te ibino komo mabulubi eta bogelo da꞉pola꞉nuya꞉ kokotamo na꞉midahalamiya꞉ iba꞉te ibi kopowalubilima꞉. Ba꞉bema꞉ iba꞉te pelamete ba꞉bi boge netewa dahamo da꞉petabuilamiya꞉, bogete tatalila beyamo ululuhu. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ba꞉bene Saimonote ba꞉be komo umiti koamo da꞉hanohanuya꞉, ebete Ya꞉sukunu nato mabamo pete pupamo pemedete ba꞉bo pegoiya꞉, “Kodawa, ama꞉ na miya꞉panete na꞉toa, mabu na kuba lumagila!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Huiyatiya Ya꞉suti ebetamo na꞉goiya꞉, “Akatoletola꞉la꞉, ama꞉ dopamo daha uwateholedawama꞉ eda꞉nama꞉ta, huiyatiya ba꞉ma tetene tupuimiti ama꞉ tawakalubi uwatedawalata.” Ba꞉ba tetelo Saimonokoba꞉ daha uwatehole mani oko dowatinama꞉, ba꞉bi dubu Ya꞉imesiko ba꞉gala Yoneko, ibi netewapi ba꞉ Sebedikono gugudila. Ba꞉bene ibi ba꞉gala komo okopi ba꞉bolo da꞉pola꞉nuya꞉, iba꞉te ba꞉bi daha hiliyonomo ulamete atumu na꞉kahanohanohutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ba꞉be mabuma꞉ Saimonoko ba꞉gala ba꞉moi komo dubu netewapi iba꞉te ibino boge netewa putiholete ibino oko ilina hiliyonomo miya꞉palete Ya꞉suku ba꞉bo ta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Eta tetelo Ya꞉suti eta habalo lutiya꞉, ba꞉be habalo kubanomo kuitikuita꞉goeno dubuti nemedenami. Ba꞉bene ebete Ya꞉suku umiti ebetamo pete ebeno holoholo hakamo pihatete toetoe tabo na꞉pegoiya꞉, “Kodawa, amia꞉no ubi ditama꞉na, ama꞉le na kohiduinamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ya꞉suti ebeno kokoto hogaminate ebe ba ologi ebetamo na꞉goiya꞉, “Na ubila, ama꞉ na꞉hida!” ba꞉bema꞉ ba꞉ba tetenomolo kuitikuiti temetemete ebegodone na꞉wibuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ba꞉bene Ya꞉suti ebe ba kiyahame na꞉goemiya꞉, “Ama꞉ naeno komoma꞉ tawakalubi akakiyalama꞉la꞉. Wadiyala ama꞉ huiyatiya ba꞉moe tetenomolo tote amia꞉no ape Godotamo hawa꞉goeno ikamehodawatamo na꞉nemutuimiya꞉, ba꞉bene hawa꞉goeno malemale ilina Godotamo akona꞉nikamiya꞉, Mosesete dolamagiya꞉ ba꞉ba ka꞉na. Ba꞉be komote tawakalubi kiya꞉tulamema꞉ne amia꞉no temetemete a꞉wibui.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Huiyatiya Ya꞉suti kebe hido komokomo kododilinakui ba꞉be tabote ba꞉be hopo konomamo tuya꞉, ba꞉bema꞉ tawakalubi hiliyonomate ebetamo na꞉pekapiyuimiya꞉ ebeno tabo kulihoma꞉ ba꞉gala ebete ibino temetema꞉gopi kohiduilamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ebete huiyatiya ibi miya꞉palete dito hopamo ha꞉kiya ba꞉bo tuya꞉, ba꞉be tataba hopolo Godokoba꞉ tabo konega꞉lama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Eta hegelalo Ya꞉suti tawakalubi ba iya꞉tulamita, komo Pa꞉lisi kapiyuimipi ba꞉gala Godokono Tutumu iya꞉tulamepi iba꞉te Ga꞉lili hopoeno hiya꞉hiya꞉ habane pelameholiya꞉, ba꞉bene komopa꞉te atumu Yudiya hopone ba꞉gala Yelusalema ko habane pelameholete ba꞉bo pepola꞉nuya꞉. Ba꞉ba tetelo Kodawa Godokono helote Ya꞉sugodolo nitanuya꞉ ebete temetema꞉gopi kohiduilamema꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ba꞉bene komo dubate ape kodakoda temetema꞉goeno dubu talatalago agahiya꞉. Iba꞉te genama guamo a꞉pa꞉la꞉ha gabo bohowaditiya꞉ ibino mabulubi Ya꞉sukunu nato mabamo konadila꞉tema꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","huiyatiya tawakalubi hiliyonomola ba꞉bema꞉ iba꞉te eta gabo kumiya꞉ha꞉. Ba꞉be mabuma꞉ iba꞉te genama hunamo nalehawaminate, Ya꞉suti kebo ka꞉la꞉nuya꞉ iba꞉te ba꞉be genamoeno hunu a꞉himiti ba꞉be dubu talatalago ba꞉bana nadutiya꞉ Ya꞉sutamo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ya꞉suti ibino hibima꞉ midi komo umilamete dubutamo na꞉goiya꞉, “Mabulubi, Godote amia꞉no kuba egebolema꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Huiyatiya Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi dubu iba꞉te ibino tepo ipuwalo ba꞉ma ka꞉na emalagidolutiya꞉, “Moe dubu awaga konomola, Godokono holoholo hapulu kuba tabo badama꞉ ka꞉goe? Kuba egeboledawa potela꞉ka꞉? Ba꞉ Godoko kapiyala!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iba꞉te ibino tepo ipuwalo da꞉ga꞉luya꞉ Ya꞉suti iya꞉tawate iba꞉tamo na꞉goiya꞉, “Mabu keka꞉ la꞉eno tepo ipuwalo ba꞉moi komo demalagidolitama? ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ba꞉moe tabo kodakodala꞉ka꞉ nale goema꞉, ‘Godote amia꞉no kuba egebolemete adodolema꞉ta?’ O ba꞉moe eta tabo goema꞉ kodakodala꞉ka꞉, ‘Ama꞉ mahigate, na꞉toa?’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ba꞉bema꞉ nale la꞉ kiya꞉tulamema꞉nemata, na Tawakalubino Naniwigodo helo bitana ba꞉moe hopo konomolo tawakalubino kuba egebolelamete kadodoholelamema꞉.” Ba꞉bene ebete temetema꞉goeno dubutamo na꞉goiya꞉, “Nale ama꞉ begoememata, ama꞉ mahigate, amia꞉no tilo mokopa꞉midate genamamo na꞉toa!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ba꞉ba tetenomolo ba꞉be dubuti ibino holoholo hapulu mahigate ebeno tilo lawete Godokono mahilo hunamo ba adipate ebeno genamamo dito tuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ba꞉bema꞉ ba꞉bi tawakalubi hiliyonomate konomamo hanohanohutiya꞉. Iba꞉te Godokono mahilo hunamo ba adipate toletolehago na꞉ga꞉luya꞉, “A ka꞉lo hegelalo hanohano komo hibinomolo ulamema꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ba꞉moe komo da꞉wibuya꞉ Ya꞉suti genama guni nuluhukuti eta dubu Libaiko ba꞉bo numiya꞉, ebe ba꞉ ta꞉kese uwatedawala, ebete ebeno oko habalo lutiya꞉. Ba꞉ba tetelo Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉ na na꞉ta꞉mahena꞉,” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ba꞉bene ebete mahigate ebeno oko ilina hiliyonomo miya꞉palete Ya꞉suku ba꞉bo ta꞉matuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ba꞉bene tete nanekele da꞉petuya꞉ Libaiti ebeno genamalo Ya꞉suku mabuma꞉ konomo poko bododiya꞉. Ba꞉ba tetelo komo ta꞉kese uwatepi dubu ba꞉gala komo hiliyonomo tawakalubi iba꞉te Ya꞉sukuba꞉ poko baa꞉ benahutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ba꞉bene komo Pa꞉lisi kapiyuimipi ba꞉gala ibino tutumu iya꞉tulamepi iba꞉te Ya꞉suku ta꞉matapi na꞉kiyahalamiya꞉, “Mabu keka꞉ la꞉le ta꞉kese mani ha꞉da amiholo uwatepi ba꞉gala Godokono Tutumu Tabo uwateha꞉pi tawakaluba꞉go gao beya nihote iba꞉go baa꞉ da꞉nahanakoma?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Huiyatiya Ya꞉suti ba꞉be tabo uliti iba꞉tamo na꞉goiya꞉, “Hidohido tawakaluba꞉te dogetatamo a꞉katolama꞉mena꞉, tawetawa꞉gopa꞉te kotolamema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iyo, puya꞉te ha꞉kiya da꞉ga꞉lana, ‘A hidohido tawakalubila,’ na ba꞉bakobako tawakalubi uwatema꞉ kapiya꞉ha꞉. Na huiyatiya kubakuba tawakalubi kapiya uwatema꞉ piya꞉mo, iba꞉te ibino kuba ododili komokomone kohobila꞉ma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ba꞉bene komo tawakaluba꞉te Ya꞉sutamo na꞉ga꞉luya꞉, “Yoneko ta꞉matapi ba꞉gala Pa꞉lisi kapiyuimipino ta꞉matalepi iba꞉te hiya꞉hiya꞉ tetelo baa꞉ nahaheno Godotamo toetoe tabo ba꞉bo ga꞉lanaka, huiyatiya ama꞉ ta꞉matapa꞉te ba꞉ma ka꞉na a꞉kapola꞉nala꞉. Iba꞉te hiliyonomo tetelo helo gao beya nihote baa꞉ ba꞉bo nahanaka.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Dubuti kamena da꞉lawemene, ba꞉ba tetelo ebeno mabuluba꞉te poko habalo baa꞉heno dito ba꞉ka꞉pola꞉namena꞉? Ao, wadiyaha꞉! Iba꞉te eba꞉go poko baa꞉ kapimilo konahama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Huiyatiya kamena uli lawe dubuti ebeno kamena eta habamo magata tete ba꞉ na꞉pe, hibila, ba꞉be hegelalo ebeno mabuluba꞉te ibino tepo temeteme komoma꞉ baa꞉ nahaheno kopola꞉nama꞉na꞉. Ba꞉bema꞉ numa꞉la꞉, ka꞉lo ba꞉ la꞉eno kalakalago baa꞉ naha tetela mabu nale la꞉go bemedenamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ba꞉bene Ya꞉suti iba꞉tamo ba꞉moe iya꞉tulame uwi bikiyauya꞉, “Lumagiti uli kaliko itamidate pakala kalikoeno bolagala꞉mo a꞉kakohomehamene. Ebete ba꞉ma ka꞉na dododimini uli kalikote pakala kalikago a꞉kamodobamene, gala kakabolagalema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Atu gabodo lumagiti pakala gautu-goe tama kalila꞉mo uli gao beya a꞉kahaminamene, mabu uli gao beyate pakala gautu-goe tama kalili ka꞉na꞉ta꞉pumima꞉ne, ba꞉bene gao beyate hakamo ka꞉ka꞉la꞉te gao beya ba꞉gala kalili ibi netewate kapiya tetelo kokubakubahama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ba꞉moe mabuma꞉ wadiyala iya꞉tawadawate uli gao beya uliuli tama kalili kapiyamo na꞉haminahanakamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ba꞉gala ba꞉moe ba꞉ eta komola. Lumagiti pakala gao beya da꞉ninako ebete galane tetelo uli gao beya nima꞉ ubiha꞉ma꞉ keda꞉ma꞉ne mabu ebete ba꞉goenakomene, ‘Pakala gao beya golanomola,’ huiyatiya ba꞉bako lumagi iya꞉tawaha꞉ uli gao beyoeno hido gola komo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yu tawakalubino eta okoha꞉ talona hegelalo Ya꞉suti ebe ta꞉matapa꞉go kona pali ipuwado ba petolamenato, ebe ta꞉matapa꞉te kona kapiyakapiya kubakubadopo newakalamiti iba꞉te konahama꞉ tama ba꞉bo wehohuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ba꞉bema꞉ komo Pa꞉lisi kapiyuimipa꞉te Ya꞉sutamo na꞉ga꞉luya꞉, “Numa꞉, ama꞉ ta꞉matapa꞉te aeno tutumu tabamo kapapamila꞉haha꞉. Iba꞉te okoha꞉ talona hegela badama꞉ kadikanalita?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ba꞉bene Ya꞉suti iba꞉tamo ba huiya na꞉goiya꞉, “Wadiyala Godote ebeno Bukamo da꞉miya꞉tiya꞉, la꞉ ba꞉be komo nemalagidolala꞉. Da꞉ibiditamo kuba tete da꞉piya꞉, ebete ebeno wapata꞉lamepa꞉go baa꞉ma꞉ da꞉kapemitiya꞉, ba꞉bene ebete bada komo kododiya꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ebete Godokono Genamamo nodolote, ba꞉be Genamoeno okopa꞉te Godotamo da꞉miya꞉tenakui ba꞉be talona baa꞉ ebete a꞉nenahuya꞉. Numa꞉la꞉, aeno tutumu tabote a biya꞉tua꞉mena Godotamo hawa꞉goeno ikamehopa꞉te ba꞉be baa꞉ ha꞉kiya nahanaka, komo tawakaluba꞉te naha talonala. Huiyatiya Da꞉ibiditi ba꞉be baa꞉ nahate eba꞉go wapata꞉lamepa꞉tamo dikalameholiya꞉, Godote ba꞉be komo kubama꞉ kagoiya꞉ha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ba꞉bema꞉ Ya꞉suti iba꞉tamo na꞉goiya꞉, “Ba꞉ hibila, na Tawakalubino Naniwiti okoha꞉ talona hegela namutudawama꞉ eda꞉namo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Eta okoha꞉ talona hegelalo Ya꞉suti Yu tawakalubino baidi ibubulamehole genama guamo nodolote tawakalubi ba niya꞉tulamita, kokoto tu hapu hoeme dubuti ba꞉bolo na꞉lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ba꞉bene komo Pa꞉lisi kapiyuimipi ba꞉gala Godokono Tutumu iya꞉tulamepi iba꞉te Ya꞉suku baidi kodakodalo umitiya꞉, ebete okoha꞉ talona hegelalo ba꞉be dubu da꞉hiduimimini, iyo, ibi ubila Ya꞉suti ba꞉be komo ba ododi kubama꞉ ba꞉bo koga꞉lama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Huiyatiya Ya꞉suti iya꞉tawuya꞉ iba꞉te ibino tepo ipuwalo bada komokomo kemalagidolitiya꞉, ba꞉bema꞉ ebete ba꞉be dubutamo na꞉goiya꞉, “Ama꞉ mahigate dopo hapuamo na꞉pa꞉,” ba꞉bene ba꞉be dubuti mahigate dopo hapuamo pete ba꞉ dito putiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Nale la꞉ balateda꞉lemata, aeno tutumu tabote kebe talona komo kiya꞉tua꞉mena? Ale okoha꞉ talona hegelalo hido komo o kuba komo ba꞉kododima꞉? Tawakalubi ba꞉ka꞉hiduilamema꞉ o ba꞉ka꞉kubahilamema꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ba꞉ba tetelo Ya꞉suti ibi hiliyonomo ba pulameholenato ba꞉be dubutamo na꞉goiya꞉, “Amia꞉no kokoto na꞉hogamina,” ba꞉bene ebete kokoto da꞉hogaminuya꞉ ebeno kokotote ba꞉bo hiduya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ba꞉be mabuma꞉ Pa꞉lisi kapiyuimipa꞉te konomamo maubahalo ibi ipuwalo tabo ba꞉bo ga꞉luya꞉, “A ba꞉moe dubu Ya꞉suku keba ka꞉na na꞉kamitima꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ba꞉be dulu Ya꞉suti Godokoba꞉ tabo ga꞉lanama꞉ eta haka hunamo nodoloniya꞉, ba꞉bema꞉ ebete du ga꞉ga꞉nomolo Godokoba꞉ tabo ba ga꞉lana hegelate ba꞉bo powalohuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ba꞉bene hegelate da꞉puluhukuya꞉ ebete ebeno ta꞉matapi ebetamo ka꞉lamiti, ibi ipuwalo 12 dubu ba uwate ibi na꞉goelamiya꞉, “La꞉ ba꞉ naeno oelamepilata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ya꞉suti 12 dubu duwatiya꞉, ba꞉moi ba꞉ ibino mahilola. Saimonoko Ya꞉suti ebetamo eta Pita mahilo bikamiya꞉, ba꞉gala ebeno ekawi A꞉nduluku. Ya꞉imesiko ba꞉gala Yoneko, Pilipiko ba꞉gala Batolomuku. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ma꞉tiyuku ba꞉gala Tomasiko, A꞉lapiyasikono gudu Ya꞉imesiko ba꞉gala Saimonoko. Ba꞉moe eta Saimono tawakaluba꞉te dopamo na꞉ga꞉lanakuya꞉, ebete kapela Loma gabomani tawakaluba꞉go alaholodawama꞉ eda꞉nami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ba꞉gala Ya꞉suti komo dubu netewa beka-uwatiya꞉, Ya꞉imesikono gudu Yudasiko ba꞉gala Keliyotanapi Yudasiko, galane tetelo ba꞉moe kuititi dubuti Ya꞉suku anakapumipi bowalubiliya꞉ ebe kolawema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉go haka hununi eta apotami hopamo da꞉nepalaguya꞉, ba꞉ba tetelo komo ta꞉matapi ba꞉gala hiya꞉hiya꞉ tawakalubi hiliyonomate iba꞉go ba꞉bo paluguya꞉. Komo iba꞉te Yelusalema ko habane ba꞉gala Yudiya hopoeno komo habahabane pelamiya꞉, ba꞉gala komo iba꞉te kehaha꞉ kolomo dodo hapuni kapelamiya꞉, ibi ba꞉ Taya ko habalo ba꞉gala Saidono ko habalo demedehonama꞉ ba꞉bi tawakalubila. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ba꞉ hibila, ba꞉bi tawakalubi hiliyonomate pelameholiya꞉ Ya꞉sukunu tabo ulihoma꞉ ba꞉gala ebete ibino temetema꞉gopi kohiduilamelelamema꞉, ba꞉gala kuba gobogobagopa꞉te ebetamo atumu a꞉kapelamiya꞉, ba꞉bene ebete ibi hiliyonomo ba꞉bo hiduilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ba꞉bema꞉ ba꞉bi tawakalubi hiliyonomate ubila Ya꞉suku kologihoma꞉, mabu iba꞉te iya꞉tawahuya꞉ Godokono helote ebe ipuwane da꞉puluhukunakui ba꞉ba tetelo ebete temetema꞉gopi ba꞉bo hiduilamenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ba꞉bene Ya꞉suti ebeno hiliyonomo ta꞉matapi ba ulamita na꞉goelamiya꞉, “La꞉ puya꞉te awaelo demedenama, wadiyala la꞉ na꞉kalakalahala꞉, mabu Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be hido haboeno komo la꞉enola! ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Ba꞉gala ba꞉ma tetelo la꞉ baa꞉ kapete dulamena, wadiyala la꞉ na꞉kalakalahala꞉, mabu Godote la꞉eno kape komo komodobuilamema꞉ne! “Ba꞉gala ba꞉ma tetelo la꞉ puya꞉te temetema꞉go dihiminama, wadiyala la꞉ na꞉kalakalahala꞉, mabu galane la꞉ kiya꞉da꞉mima꞉nemata! ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ba꞉gala Tawakalubino Naniwi mabuma꞉ komopa꞉te la꞉tamo maubahalo ubiha꞉ tabo ba ga꞉la la꞉ diduduputilamena, ba꞉gala iba꞉te la꞉eno mahilo da꞉kubahilamena, wadiyala la꞉ atumu na꞉kakalakalahala꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Iyo, la꞉ kalakalahalo hunamo niya꞉patela꞉tepahaliya꞉la꞉, mabu galane tetelo la꞉le Godokono Hunu Habalo la꞉eno huiya kokonomo konuwatema꞉nemata. Numa꞉la꞉, dopamo ibino iniwala꞉te ba꞉ atu ubiha꞉ tabo bekaga꞉lanakuya꞉ Godokono ukui hawakalimipa꞉tamo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Huiyatiya ba꞉ma tetelo la꞉ puya꞉te dogodogopima꞉ deda꞉hanama, la꞉ ko tepo temeteme kiya꞉tawahama꞉nemata, mabu la꞉eno kalakala ba꞉ na꞉lawenamata, galane kowiboma꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Ba꞉gala ba꞉ma tetelo la꞉ puya꞉te baa꞉ma꞉ kakapiminaha꞉, la꞉ ko tepo temeteme kiya꞉tawahama꞉nemata, mabu galane la꞉ baa꞉ma꞉ kokapimima꞉nemata! “Ba꞉gala ba꞉ma tetelo la꞉ puya꞉te diya꞉da꞉minama, la꞉ ko tepo temeteme kiya꞉tawahama꞉nemata, mabu galane la꞉ howela꞉go kihimima꞉nemata! ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ba꞉gala tawakalubi hiliyonomate la꞉ da꞉mililameholemena꞉, la꞉ hidamo, mabu galane tetelo la꞉ ko tepo temeteme kiya꞉tawahama꞉nemata! Numa꞉la꞉, dopamo ibino iniwala꞉te Godokono mahilamo ha꞉da amiho tabo olamagimipi atumu a꞉mililameholenakuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Ba꞉be mabuma꞉ na la꞉tamo na꞉goemo, puya꞉te la꞉go dalaholohona, wadiyala la꞉ ibi malemalelo nemalagidolenala꞉ ba꞉gala iba꞉tamo hidohido komo nododilinakuya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ba꞉gala la꞉tamo mela tabo dolamagiminaka, ba꞉bi tawakalubino komoma꞉ Godotamo na꞉toetoehonakuya꞉la꞉ ebete ibi hidamo kowalubilinama꞉, iyo, puya꞉te la꞉tamo kuba komokomo dododilina la꞉ ibi Godotamo na꞉wadiya꞉paa꞉latelenakuya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ba꞉gala pote ama꞉ tatakolo danagalimimina꞉, wadiyala hapu ebetamo na꞉kikamiya꞉. Ba꞉gala kebe lumagiti amia꞉no sete ilina heloamo da꞉lawememena꞉, ba꞉be atu tetelo amia꞉no atuino ilina akamawada꞉la꞉, ama꞉le ebetamo malemalelo dito na꞉kikamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Iyo, lumagiti amia꞉no eta ilinama꞉ ama꞉ da꞉toemehomena꞉, wadiyala ebetamo malemalelo nikamiya꞉, ba꞉gala kebe lumagiti amia꞉no ilina pilolo duwatemene, ama꞉ tote ba꞉bi ilina heloamo akanuwata꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ba꞉bema꞉ tawakaluba꞉te la꞉tamo bada komo ododima꞉ la꞉le ubi dihatenakoma, la꞉ komopa꞉tamo ba꞉ ba꞉ba ka꞉na nododinakuya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Puya꞉te la꞉ malemalelo demalagidolena, la꞉ ba꞉bi tawakalubi kapiya demalagidolenama la꞉eno ukui keba ka꞉nala꞉ka꞉? Ba꞉be mabuma꞉ Godote la꞉tamo hido huiya ba꞉kikalametamena꞉? Ao, mabu kuba ododilipa꞉te atumu ibino mabulubi kapiya malemalelo emalagidolenaka! ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ba꞉gala puya꞉te la꞉tamo hidohido komo dododilina, la꞉ ba꞉bakobakopi kapiyatamo hidohido komo dododilinama la꞉eno ukui keba ka꞉nala꞉ka꞉? Ba꞉be mabuma꞉ Godote la꞉tamo hido huiya ba꞉kikalametamena꞉? Ao, mabu kuba ododilipa꞉te ibino mabulubi kapiyatamo atu hidohido komo beka-ododilinaka! ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ba꞉bema꞉ puya꞉te la꞉tamo gala da꞉kikalameholenaka, la꞉ ibi kapiyatamo mani dikalameholema la꞉eno ukui keba ka꞉nala꞉ka꞉? Ba꞉be mabuma꞉ Godote la꞉tamo hido huiya ba꞉kikalametamena꞉? Ao, kuba ododilipa꞉te atumu ibino mabulubi kapiyatamo mani ikalameholenaka mabu atu komo iba꞉godone gala kakuwatema꞉na꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Huiyatiya wadiyala la꞉tamo alaholopima꞉ deda꞉hana, la꞉ ibi malemalelo nemalagidolenala꞉ ba꞉gala iba꞉tamo hidohido komo nododilinakuya꞉la꞉. Iba꞉te manima꞉ la꞉ da꞉kiyalamemena꞉, wadiyala la꞉ iba꞉tamo dito nikalamiya꞉la꞉, huiya komo akemalagidolala꞉. Ba꞉mako ododi komodo la꞉ Hununomo Godokono gugudima꞉ eda꞉hate galane tetelo huiya konomo kuwatema꞉nemata. Numa꞉la꞉, ebete kuba ododilipi ba꞉gala ebetamo kalakala tabo ga꞉laha꞉pi ba꞉bakobako tawakaluba꞉tamo malemale komo ododilinako. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ba꞉bema꞉ la꞉ hiliyonomo tawakalubi malemalelo nemalagidolenala꞉, la꞉eno Nabiwiti ibi keba ka꞉na kemalagidolena ba꞉ba ka꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉le komo tawakalubino komokomo anagilamelelamelo ibi kubapima꞉ tiyolo akaka꞉lama꞉la꞉, ba꞉bene Godote la꞉eno komo anagilamelelamelo la꞉ kubapima꞉ a꞉kaka꞉lama꞉mena꞉ta. Ba꞉gala wadiyala la꞉ tawakalubino kuba egebolelamete nadodoholelamiya꞉la꞉, ba꞉bene Godote atumu la꞉eno kuba egebolelamete kadodoholelamema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ba꞉gala wadiyala la꞉ komopa꞉tamo ilina malemalelo nikalamenakuya꞉la꞉, ba꞉bene Godote atumu la꞉tamo ba ikalame tete hiliyonomolo ebete la꞉ ilinamo ba꞉tabuilamenakomena꞉ta, iyo, la꞉ komopa꞉tamo kebako dikalamenakoma, Godote ba꞉ atumu la꞉tamo ba꞉bako ba꞉kikalamenakomena꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ba꞉bene Ya꞉suti iya꞉tulame uwi ba olamagi na꞉goiya꞉, “Baidi tamiho dubuti eta baidi tamiho dubu gabodo hidamo a꞉kamagatamene. Ebete ba꞉ba ka꞉na dewagelemene ibi netewapi haka gugamo badi konegudima꞉na꞉, aba꞉ hibila꞉ka꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ba꞉bema꞉ ka꞉lo sikululu diya꞉tawana ba꞉be guduino iya꞉tawa komote iya꞉tulamedawoeno iya꞉tawa kagogolonaha꞉, huiyatiya galane ebeno sikulu da꞉wibomene ebeno iya꞉tawa komo ba꞉gala iya꞉tulamedawoeno komo atu tetelo kopola꞉nama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Keka꞉ mabu amia꞉no ekawino baidilo puhulu deha꞉poto umilo huiyatiya amia꞉no baidilo ditana ba꞉be ko keha tete kuminaha꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ba꞉gala bada mabuma꞉ amia꞉no ekawitamo ba꞉ma ka꞉na da꞉goita, ‘Ekawi, wadiyala amia꞉no baidilo ditana ba꞉be puhulu deha꞉poto nale kolawemema꞉nemata,’ huiyatiya amia꞉no baidilo ditana ba꞉be ko keha tete ama꞉ kalawenaha꞉? A꞉iye! Ama꞉ ma꞉lapila netewa lumagilata! Wadiyala ama꞉ dopamo amia꞉no baidilo ditana ba꞉be keha lawete, ama꞉le galane hidamo gahimiti amia꞉no ekawino baidilo ditana ba꞉be puhulu deha꞉poto ba꞉bo kolawemema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Hidohido kehalo kuba gaote a꞉kanolohamena꞉, ba꞉gala kuba kehalo hidohido gaote a꞉kanolohamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Iyo, ba꞉ hibila, la꞉ hiya꞉hiya꞉ kehoeno gao ibino holoholamo dulamema la꞉ ba꞉bo kiya꞉tawahama꞉nemata, ibi ipuwalo kebe gaote nahama꞉ hidohidoma꞉ keda꞉hana. Ba꞉bema꞉ lumagiti olagoeno kehamo tote anahu kehoeno gao a꞉kanetapihamene, ba꞉gala ebete olagoeno kehalo hidohido gala꞉ipi gao a꞉kanulama꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ba꞉bema꞉ hido lumagiti ebeno tepo ipuwane hidohido komo buluhukulatelenakomene, huiyatiya kuba lumagino tepo ipuwalo kuba komate pola꞉na ba꞉bema꞉ ebegodone kuba komate ba꞉pikulinakomena꞉, mabu lumagino tepo ipuwalo kebe komate ka꞉pola꞉na, ba꞉ ba꞉bi komate ebeno tabo olamagi komodo kopikulima꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Keka꞉ mabu la꞉ na Kodawama꞉ dito da꞉ka꞉naminama, huiyatiya nale dolamaginakomo ba꞉bi komo la꞉le kododilinaha꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ba꞉bema꞉ kebe lumagiti natamo pete naeno tabo pulihote ba꞉bi komokomo dododilimini, ba꞉be lumagino komo keba ka꞉na kitana nale la꞉ hidamo kiya꞉tulamema꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ba꞉be lumagi ba꞉ hido genama detiya꞉ ba꞉be dubu huiyala. Ebete haka ibulunomo aligiti kodakoda haka hunamo ebeno genama ba꞉bo etiya꞉, ba꞉bene hulama beyate ba odolo ba꞉be genama da꞉pemida꞉miya꞉, huiyatiya genamate kaleguya꞉ha꞉ mabu etedawate ebeno genama hidamo etiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Huiyatiya kebe lumagiti naeno tabo ulihote ododilihino, ebe ba꞉ bula꞉i hakamo genama detiya꞉ ba꞉be dubu huiyala. Ba꞉be genamoeno mabu puliyala, kitanuya꞉ha꞉, ba꞉bema꞉ hulama beyate ba odolo ba꞉be genama da꞉pemida꞉miya꞉ hakamo dito kaguya꞉. O olalati bada konomola꞉ka꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ya꞉suti tawakaluba꞉tamo ba꞉moi komokomo hiliyonomo olamagi da꞉wibuya꞉ ebete Kapeniyama habamo ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lomanapino eta alaholohodawa gawadubuti ba꞉bolo nemedenami, ba꞉bene ebeno huiyaha꞉ okopi ipuwalo ebete kebe dubu konomamo demalagidolonami, ba꞉be dubu ko tawetawete umitiya꞉, ebe hoe tatalila. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ba꞉bema꞉ ba꞉be gawadubuti Ya꞉sukunu komo uliti komo Yu watowatopi dubu ebetamo ba꞉bo ka꞉lamiya꞉, iba꞉te Ya꞉suku ba꞉ma ka꞉na konega꞉lamema꞉, ebete pete gawadubuino okodawa kopehiduimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ba꞉bene komo iba꞉te Ya꞉sutamo pelamete ebe toemeholo na꞉pega꞉lamiya꞉, “Ba꞉moe Lomanapi gawadubu hido lumagila. Wadiyala ama꞉ ebe na꞉nowaluba꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mabu ebete a Yu tawakalubi koamo nemalagidoloena, ba꞉gala ebete ebeno mana꞉mo aeno baidi ibubulamehole genama etea꞉mi.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ba꞉bema꞉ Ya꞉suti iba꞉go na꞉tuya꞉. Ebete ba tonato genama tama꞉mo da꞉nuluhukuya꞉, ba꞉be gawadubuti ebeno mabulubi ba꞉bo oelamiya꞉ iba꞉te Ya꞉suku konega꞉lamema꞉, “Kodawa, eta kodakoda komo na mabuma꞉ akododa꞉la꞉. Na hido lumagiha꞉ ama꞉le naeno genamamo pa꞉pa꞉gama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ba꞉gala na hidoenoha꞉ amia꞉no holoholo hapuamo pema꞉. Huiyatiya na niya꞉tawutamo, ama꞉le genamamo peheno tabo dito da꞉goemena꞉, naeno okodawate hibinomolo kohidoma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mabu na atumu alaholohopino koko gawadubuino hopodawama꞉ ba eda꞉na ibino tabamo a꞉papamiwatanakomo, ba꞉gala atu tetelo naeno alaholohopa꞉te naeno umi ipuwalo pola꞉na. Ibi ipuwalo nale eta da꞉kiyamemo, ‘Ama꞉ na꞉toa!’ ebete ba꞉bo kotoma꞉ne. Ba꞉gala eta da꞉kakiyamemo, ‘Ama꞉ na꞉pa꞉!’ ebete ba꞉bo kopema꞉ne. Atumu nale naeno huiyaha꞉ okodawa da꞉kiyamemo, ‘Ama꞉ ba꞉moe komo nododa꞉!’ ebete ba꞉be komo kododima꞉ne. Ba꞉bema꞉ Kodawa, wadiyala ama꞉ tabote na꞉gaa꞉ naeno oko dubuti kohidoma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ya꞉suti ba꞉be tabo duliya꞉ ebete na꞉la꞉wiya꞉, ba꞉bema꞉ ebe da꞉ta꞉matutiya꞉ ebete ba꞉bi tawakalubi hiliyonomatamo ohobigate na꞉goiya꞉, “Na la꞉tamo hibinomolo goemo, na Isalaela tawakalubi hiliyonomo ipuwalo ba꞉mako hibima꞉ midi lumagi a꞉kuma꞉lemo!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ba꞉bene alaholohodawa gawadubuti doelamiya꞉ ba꞉bi dubate ebeno genamamo gala da꞉kapelamiya꞉, iba꞉te ba꞉be huiyaha꞉ okodawa hido bepumiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Eta hegelalo Ya꞉suti eta habamo dito tuya꞉, ba꞉be haboeno mahilo ba꞉ Na꞉inila, ba꞉ba tetelo ebe ta꞉matapi ba꞉gala tawakalubi hiliyonomo eba꞉go kapimilo tolamitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ba꞉bene ebete haboeno kala imi gigihamo da꞉nuluhukuya꞉, ba꞉ba tetelo hiliyonomo tawakaluba꞉te hoe dubu aguti habane pikulitiya꞉ ebe bobamo kopinihatema꞉, ba꞉be hoe dubuino menoko hamolela, ebeno gudu kapiyanomote hoiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ba꞉bema꞉ Kodawate ba꞉be kamena umiti malemaletelo ebetamo na꞉goiya꞉, “Ama꞉ akihitala꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ba꞉bene Ya꞉suti tote hoe dubuti da꞉kapitanuya꞉ ba꞉be talatala da꞉nologiya꞉, ebe dagatutiya꞉ ba꞉bi dubate ba꞉bamo ba putitata, ebete hoe dubutamo na꞉goiya꞉, “Amoga, nale ama꞉ begoememata, na꞉mahiga!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ba꞉bene ba꞉be dubuti mahigate tabo olamagi da꞉tupuimiya꞉, Ya꞉suti ebeno menokotamo dito ikamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ba꞉bema꞉ ibi hiliyonomate konomamo toletoleholo Godokono mahilo hunamo ba adipate na꞉ga꞉luya꞉, “Godokono ukui hawakalimidawa atamo ba꞉ a꞉puluhuku! Iyo, Godote ebeno tawakalubino ka꞉ka꞉ mula꞉lelamema꞉ pe!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ba꞉bema꞉ ba꞉be Na꞉ini haboeno hopo ba꞉gala komo hopo tametamelo demedehonama꞉, ba꞉bi tawakalubi hiliyonomate Ya꞉sukunu komoma꞉ tabo ba꞉bo nikiyahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ba꞉ba tetelo Yoneko tawakalubi beyamo wadulateledawa, ebeno ta꞉matapa꞉te ba꞉moi hiliyonomo komokomo ebe ba꞉bo pikiyahamiya꞉. Ba꞉bene ibi ipuwalo Yonete netewa dubu ka꞉lamiti ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ya꞉sutamo ba꞉bo noelamiya꞉, iba꞉te ebe ba꞉ma ka꞉na konega꞉lamema꞉, “Ama꞉ ba꞉ Yonete pema꞉ da꞉goi ba꞉be lumagila꞉ka꞉, o ale eta lumagi beka꞉latiminama꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ba꞉bene iba꞉te Ya꞉sutamo pelamete na꞉pega꞉luya꞉, “A Yonete poea꞉me ama꞉ ma kumu kopalateda꞉ma꞉, ‘Ama꞉ ba꞉ Yonete pema꞉ da꞉goi ba꞉be lumagila꞉ka꞉, o ale eta lumagi beka꞉latiminama꞉?’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ba꞉ba tetenomolo Ya꞉suti ibino holoholo hapulu hiliyonomo hiya꞉hiya꞉ temetema꞉gopi, ba꞉gala tawetawa꞉gopi, ba꞉gala kuba gobogobagopi bihiduilamiya꞉, ba꞉gala ebete baidi tamihopi atumu akahiduilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ba꞉bema꞉ ebete huiya tabo Yoneko ta꞉matapa꞉tamo na꞉goiya꞉, “La꞉ tote la꞉le kebe komo kulameoma ba꞉gala la꞉le kebe tabo kulihoma, ba꞉bi komokomo Yoneko na꞉nega꞉lama꞉la꞉. Baidi tamihopa꞉te a꞉la꞉minahala꞉ ba꞉gala nato a꞉ta꞉buta꞉midalelamepa꞉te ba꞉ na꞉wapata꞉lama꞉! Kuitikuita꞉gopa꞉te a꞉hidohidoha ba꞉gala galo duhulamepa꞉te ba꞉ nuliha! Ha꞉lahapa꞉te hoene gala a꞉kamahila꞉hala꞉ ba꞉gala awae tawakaluba꞉tamo Godokono Hido Tabote a꞉pe! ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ba꞉bema꞉ kebe lumagiti na hibima꞉ midinilo ukui netewama꞉ eda꞉heno, ebegodolo Godokono kalakalate bitanamene!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ba꞉bene Yonete da꞉poelamiya꞉ ba꞉bi dubu netewate da꞉tuya꞉, Ya꞉suti Yonekono komoma꞉ tawakaluba꞉tamo ba꞉bo olamagiya꞉. Ebete na꞉goiya꞉, “La꞉ Yonekono komo ulihote dito hopamo da꞉nikulima, bada komo umima꞉ ka꞉tolamiuima? Pudu kapiya huhuti dito dagegetiti, ba꞉be umima꞉ ka꞉tolamiuima? ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O la꞉ hidohido kaliko pupuli dubu umima꞉ ka꞉tolamiuima? Ao, la꞉ iya꞉tawahala hidohido kaliko pupulihopa꞉te dito hopolo kemedehonaha꞉, huiyatiya iba꞉te koko gawadubuino genamalo emedehona! ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ba꞉bema꞉ na niya꞉tunama꞉la꞉, la꞉ badama꞉ ka꞉tolamiuima? Godokono ukui hawakalimidawa umima꞉la꞉ka꞉? Iyo, na la꞉tamo hibi tabo begoemo, Yonete Godokono komo ukui hawakalimipi hiliyonomo a꞉gogoli. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ba꞉ hibila, Yoneko mabuma꞉ Godote ebeno Bukalo tabo ba꞉ma ka꞉na goiya꞉, ‘Nale Kelisokono dopo hapuamo naeno tabo atadawa kopoemema꞉nemo, ebete ebe dopamete ebeno gabo kohiduimima꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ya꞉suti gala na꞉kagoiya꞉, “Nale la꞉ begoelamemata, tupuimi mabuni ba꞉ma teta꞉mo puluhuku ba꞉moe hopo konomolo da꞉hawakalahaliya꞉, ba꞉bi tawakalubi hiliyonomo ipuwalo Yoneko kodawanomoma꞉ eda꞉na. Huiyatiya ba꞉ma tetene tupuimiti Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be habalo kebe lumagiti deha꞉potonomoma꞉ deda꞉mene ebete Yoneko hibilo kogogoloma꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ba꞉ba tetelo dopamo Yonete pui beyamo da꞉wadulateliya꞉, ba꞉bi ta꞉kese uwatepi ba꞉gala komo hiliyonomo tawakalubi iba꞉te Ya꞉sukunu tabo uliti Godokono gabo tuputupunomoma꞉ ga꞉late ba꞉bo kalakalahutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Huiyatiya Pa꞉lisi kapiyuimipi ba꞉gala Godokono Tutumu iya꞉tulamepi iba꞉te dopamo Yonetamo kanikuliya꞉ha꞉ ebete ibi beyamo wadulatelema꞉. Ba꞉be komo ipuwalo iba꞉te Godokono hido komo a꞉duhimiya꞉, ba꞉bema꞉ iba꞉te Ya꞉sukunu taboma꞉ kakalakalahutiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ba꞉bema꞉ Ya꞉suti na꞉goiya꞉, “Na ba꞉ma tete tawakalubino komo kebe go tabamo na꞉ka꞉hawakalimimo? La꞉ kebako tawakalubila꞉ka꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","La꞉ ba꞉ kolowami habalo diya꞉da꞉mita ba꞉bi gugudi hegehege huiyala. Komo guguda꞉te komopa꞉tamo kaga꞉la, komopa꞉te komopa꞉tamo kaga꞉la, iba꞉te olowabeletihuilo ba꞉ma ka꞉na ewagelena, ‘Ale poko ba ododi pa꞉lola꞉ da꞉moleholema꞉ huiyatiya la꞉ ago kamoeha꞉, ba꞉gala a hoe lumagi bobamo ihatema꞉ dewagelitama꞉ la꞉ huiyatiya ago kihimitaha꞉!’ Iyo, ba꞉ma tete tawakaluba꞉la꞉, la꞉ ba꞉ ba꞉ba ka꞉na ewagelenamata, la꞉ Godokono okopa꞉tamo ubiha꞉ tabo bega꞉lanakomata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Numa꞉la꞉, Yoneko tawakalubi beyamo wadulateledawate da꞉puluhukui, ba꞉ba tetelo ebete helo gao beya kaninakuiha꞉ ba꞉gala komo tetelo ebete baa꞉ naheno lutanakui Godokono oko kowatima꞉, ba꞉bema꞉ la꞉ na꞉ga꞉luimata, ‘Ebe kuba gobogobagoenola!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Huiyatiya Tawakalubino Naniwiti da꞉puluhukui, ebeno komo hiya꞉la. Ebete baa꞉ a꞉nanako ba꞉gala helo gao beya a꞉ninako ba꞉bema꞉ la꞉ ba꞉ma ka꞉na ga꞉lanakomata, ‘Ebeno kuba numa꞉la꞉! Ebe tumu goema꞉ eda꞉te baa꞉ konomamo nanako, ebe helo gao beya ni kodawala! Ebe ba꞉ ta꞉kese mani ha꞉da amiholo uwatepi ba꞉gala komo Godokono Tutumu Tabo uwateha꞉pi ibino mabulubila!’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ba꞉bene kuititinomolo Ya꞉suti iba꞉tamo na꞉goiya꞉, “Godokono hido mulu komo da꞉ta꞉matana, ba꞉bi tawakaluba꞉te ibino emede ipuwalo ba꞉be mulu hibinomolo ba꞉hawakaliminakomena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ba꞉bene eta Pa꞉lisi kapiyuimidawa dubuti Ya꞉suku na꞉goemiya꞉ ebete ebegodolo baa꞉ konenama꞉, ba꞉bema꞉ Ya꞉suti ba꞉be dubuino genamamo nodolote baa꞉ nama꞉ dito nemediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ba꞉be habalo eta kuba kamena nemedenami, ba꞉bene Ya꞉suti Pa꞉lisi kapiyuimidawoeno genamalo baa꞉ da꞉nutiya꞉ ba꞉be kamenate ba꞉be komo uliti hido nibo ihi nakola kalila꞉mo tabuimi ba꞉bo adahiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ba꞉ba tetelo ebete Ya꞉sukunu gala hapuni pete ebeno nato mabamo putiti ebeno ihi baida꞉mo Ya꞉sukunu nato pukulalemete nato a꞉la꞉li ebeno hinibamo ba꞉bo meteteholemiya꞉, ba꞉bene ebete ebeno nato aboelateholemete ebete dadahiya꞉ ba꞉be hido nibo ihi ebeno natamo dito haminamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ba꞉bene Ya꞉suku da꞉goemiya꞉ ebeno genamamo pema꞉, ba꞉be Pa꞉lisi kapiyuimidawate kamenoeno ododi komo umiti ebeno tepo ipuwalo ba꞉ma ka꞉na emalagidoluya꞉, “Ba꞉moe dubu ebe Godokono ukui hawakalimidawama꞉ neda꞉tale, ebete ba꞉be kamenoeno komo biya꞉tawana꞉, ebe dologi ba꞉be kamena ba꞉ dubu bilibili kamenala!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ba꞉bene Ya꞉suti Pa꞉lisi kapiyuimidawatamo na꞉goiya꞉, “Saimono, nagodolo tabo deha꞉poto bitana ama꞉ kiyamema꞉.” Ba꞉bene Saimonote na꞉goiya꞉, “Wadiyala, Iya꞉tulamedawa, na꞉gaa꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ya꞉suti na꞉goiya꞉, “Eta ilina dogodogo dubu nemedenami, ba꞉bene dubu netewate ebegodone mani uwatete tete ga꞉ga꞉nomolo ebetamo gala kikamehuya꞉ha꞉, etate 500 mani, etate 50 mani. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ibi netewapa꞉te ba꞉ba ka꞉na huiyahaleheno ba emedena, eta hegelalo ba꞉be ko dubuti ibi ebetamo ka꞉lamiti, ibi malemalelatelelo ibino huiyahaleha꞉ komokomo dito egebolelamiya꞉. Ba꞉bema꞉ amia꞉no ukui keba ka꞉nala꞉ka꞉, ibi netewapi ipuwalo ko kalakalago ebe pote kemalagidolonami?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimonote tabo ba huiya na꞉goiya꞉, “Naeno ukui bitana, mani konomo duwatiya꞉ ba꞉be huiyaha꞉dawala.” Ba꞉bene Ya꞉suti na꞉goiya꞉, “Ama꞉ hibi tabo begaa꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ba꞉ba tetelo Ya꞉suti kamenatamo ohobigate Saimonoko ba꞉bo alatediya꞉, “Ama꞉ ba꞉moe kamena na꞉kumiuta? Na amia꞉no genamamo da꞉podolomo, ba꞉ba tetelo ama꞉ natamo nato ukulaleno beya kikanameha꞉. Ebete huiyatiya ebeno ihi baida꞉mo naeno nato ukulalenamete, nato a꞉la꞉li ebeno hinibamo a꞉meteteholename. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ba꞉gala ama꞉ na kaboenateneha꞉, huiyatiya nale genamamo da꞉podolomo ba꞉ba tetene tupuimiti ebete naeno nato aboelatehole kekelamitaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ba꞉gala ama꞉ hido olibi kikipoeno iha꞉mo naeno wato kabutimiha꞉, ebete huiyatiya naeno natamo huiya konomo hido nibo ihi behamina. ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ba꞉bema꞉ na ama꞉tamo na꞉goemo, ebete natamo malemale konomamo da꞉hawakalimi, ba꞉be ododi komote eta komo ba꞉ma ka꞉na kahawakalimi, Godote ebeno koko kuba hiliyonomo egebolemete adodoholeme. Huiyatiya numa꞉, Godote eta lumagino hegehege kuba dadodoholememene, diyala, ba꞉be lumagiti malemale komo Godotamo da꞉ a꞉kahawakalima꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ba꞉bene Ya꞉suti ba꞉be kamenoeno tepo ipuwa ba iya꞉tawa ebetamo na꞉goiya꞉, “Godote amia꞉no kuba egebolemete adodoholema꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ba꞉bema꞉ eba꞉go ahiditi baa꞉ da꞉nahutiya꞉ iba꞉te ibi ipuwalo na꞉ga꞉luya꞉, “Lumagino kuba egebolemema꞉ da꞉goe, moe kebe awagaha dubula꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ba꞉bene Ya꞉suti kamenatamo gala na꞉kagoiya꞉, “Amia꞉no hibima꞉ midi komote amia꞉no ka꞉ka꞉ a꞉mula꞉ma꞉ta. Kalakalago na꞉toa.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ba꞉bene komo hegela da꞉wibuya꞉ Ya꞉suti koko ba꞉gala hegehege habahabalo Godokono Hido Tabo olamaga꞉go ba pata꞉, Godote Ko Gawadubuma꞉ deda꞉na ebete ba꞉be komo benolamaginakui. Ba꞉ba tetelo ebeno 12 ta꞉matapi dubate eba꞉go tolamenakuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ba꞉gala komo kamenakamenate eba꞉go atumu na꞉kawapata꞉lamenama꞉, dopamo tetelo ibi ipuwalo komopa꞉te kuba gobogobagopima꞉ eda꞉hanama꞉ ba꞉gala komopa꞉te hiya꞉hiya꞉ temetema꞉gopima꞉ eda꞉hanama꞉, huiyatiya Ya꞉suti ibi a꞉hiduilamiya꞉. Ba꞉bi kamenakamena ipuwalo Magadalanapi Ma꞉liko ba꞉ etala, dopamo Ya꞉suti ebegodone sa꞉ba꞉ni kuba gobogobo boelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ba꞉gala eta kamena ba꞉ Kusakono kamena Yowanatela, Kusako ba꞉ Ko Gawadubu Helodikono hopodawa etala. Ba꞉gala eta kamena ba꞉ Susa꞉natela. Ba꞉bi netewa-kapiya kamenakamena iba꞉te komo hiliyonomo kamenakamenago ibino mana꞉mo Ya꞉suku ba꞉gala ebeno 12 ta꞉matapi dubu bowalubilinakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ba꞉bene tawakalubi hiliyonomate hiya꞉hiya꞉ habahabane pelameholete Ya꞉sukuba꞉ da꞉pekapiyuimiya꞉, Ya꞉suti iya꞉tulame uwi iba꞉tamo ba꞉ma ka꞉na olamagiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Eta lumagiti haka da꞉hiduimi, ba꞉ba tetelo ebete kona kikipo haminahala꞉go ba tonato komo kikipo iba꞉te gabamo ba꞉bo gudiya꞉, ba꞉bema꞉ tawakaluba꞉te natamo da꞉mikimoeli holaholate ba꞉ dito penaliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Komo kikipo iba꞉te nakola hakamo gudiya꞉, ba꞉bema꞉ iba꞉te nanekela꞉mo apepehote ba꞉bo waiwaihuya꞉ mabu ba꞉be hakoeno a꞉la꞉li puliyala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Komo kikipo iba꞉te olagopi hemo hakamo gudiya꞉, ba꞉bema꞉ iba꞉te kapimilo apepehote olagopi hemate kona ba꞉ dito alukuliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Huiyatiya komo kikipo iba꞉te hido hakamo gudiya꞉, ba꞉bema꞉ ba꞉ba꞉te apepehote ba꞉ dito nolohuya꞉, eta konate 100 teta꞉mo, eta konate 100 teta꞉mo, iba꞉te ba꞉ ba꞉ba ka꞉na hiliyonomoma꞉ eda꞉huya꞉.” Ba꞉bema꞉ Ya꞉suti ibulunomamo na꞉goiya꞉, “Galagodawa, ama꞉ hidamo nulia꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ba꞉bene Ya꞉suku ta꞉matapa꞉te ebe nalatediya꞉, “Ba꞉moe iya꞉tulame uwino ipuwa keba ka꞉nala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ya꞉suti iba꞉tamo ba huiya na꞉goiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komoeno ipuwa kolawema꞉ nale helo la꞉tamo ikalamimata, iyo, ba꞉be komoeno awaminale komokomo la꞉ ba꞉ iya꞉tawahuimata. Huiyatiya komo tawakalubi eba ka꞉naha꞉, iba꞉te ba꞉be komoeno iya꞉tulame uwi ulihote, iba꞉te ebeno ipuwa bohowadinakomena꞉ huiyatiya a꞉kuminakamena꞉, iyo, iba꞉te bulinakomena꞉ huiyatiya a꞉kiya꞉tawahanakamena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Ba꞉moe iya꞉tulame uwino ipuwa ba꞉ma ka꞉nala, kona kikipo ba꞉ Godokono tabola. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ba꞉bene komo tawakalubi gabamo da꞉gudi, ibi ba꞉bi kona kikipo keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala. Iba꞉te Godokono tabo dulimina꞉, Saitanate pete ba꞉be tabo ibino tepo ipuwane kopuwatema꞉ne iba꞉te hibima꞉ miditi ka꞉ka꞉ mula꞉ komo lawekapoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Komo tawakalubi nakola hakamo da꞉gudi, ibi ba꞉ ba꞉bi kikipola. Iba꞉te tabo dulimina꞉ kalakalago kolawema꞉na꞉, huiyatiya ibino tepo ipuwalo haha puliyala, ba꞉bema꞉ iba꞉te hibima꞉ midi ipuwalo nanekela꞉mo emeda꞉tepate temeteme komate iba꞉tamo da꞉pikulimina꞉ tiyonomo kogudima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Komo tawakalubi olagopi hemo hakamo da꞉gudi ba꞉bi kikipola. Iba꞉te tabo kulima꞉na꞉, huiyatiya iba꞉te ilina uwatema꞉ ba emalagidolena ukui bilibilima꞉ eda꞉hana, ba꞉bema꞉ ibino emede komoeno ubi komate ibino hibima꞉ midi komoeno ka꞉ka꞉ ba anakapumi iba꞉te hido naha konama꞉ a꞉keda꞉hamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ba꞉bene komo tawakalubi hido hakamo da꞉gudi ba꞉bi kikipola. Iba꞉te Godokono tabo dulimina꞉ hibinomolo kolawema꞉na꞉, ba꞉bene iba꞉te ibino tepo ipuwalo ba꞉be tabamo papamila꞉halete kodakodanomolo ba utitata hido naha kona ba꞉bo konolohoma꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Lumagiti ebeno wuiki alo pa꞉titi bagolo ipuwamo a꞉kihata꞉mene ba꞉gala ebeno wata bahi ipuwamo a꞉kihata꞉mene. Huiyatiya ebete wuiki hawakala baha꞉mo kihatema꞉ne, ba꞉bene tawakaluba꞉te ebeno genama guamo da꞉palehawaminamena꞉ iba꞉te ba꞉be alo kopumima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Numa꞉la꞉, kebe awalelahale komate da꞉pola꞉na galane tetelo Godote kohawakalilamema꞉ne, ba꞉gala kebe ugumuili komate da꞉pola꞉na galane tawakaluba꞉te alo tetelo kulameholema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ba꞉bema꞉ ama꞉ hidamo nulia꞉. Godokono tabo ulihoma꞉ lumagigodolo hidohido ukui da꞉pola꞉na, Godote ebetamo hiliyonomo hidohido komo gala kakikamehoma꞉ne. Ba꞉gala lumagigodolo hidohido ukui pola꞉naheno huiyatiya ebete nemalagidolona, ‘Na hidoenola,’ ebegodolo kebe kapiyakapiya komate da꞉pola꞉na Godote ebegodone gala kakuwatemema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ba꞉bene Ya꞉sukunu menoko ba꞉gala ebeno ekaki ebetamo da꞉pelamiya꞉, iba꞉te ebe umima꞉ kamodobuya꞉ha꞉ mabu tawakalubi hiliyonomate ebe tamelo na꞉pola꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ba꞉bema꞉ eta lumagiti Ya꞉suku na꞉kiyamiya꞉, “Amia꞉no menoko ba꞉gala ekaki iba꞉te genama tamelo ba꞉pela꞉mota꞉hana. Ibi ubila ama꞉ kumima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ba꞉bene Ya꞉suti ibi hiliyonomatamo na꞉goiya꞉, “Pote Godokono tabo uliti ebetamo da꞉papamiwatamene, ba꞉be lumagi ba꞉ naeno menokola ba꞉gala ba꞉bako tawakalubi ba꞉ naeno ekakila.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Eta gapogapolo Ya꞉suti ebe ta꞉matapa꞉go boga꞉mo ololonate ibi na꞉goelameniya꞉, “A bobo hapuamo kona꞉hiwaliya꞉,” ba꞉bema꞉ iba꞉te bobo a꞉hiwale ba꞉bo tupuiminiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Iba꞉te ba na꞉hiwalena Ya꞉suti ba꞉be palai boge gulu ba꞉ dito newataniya꞉, ba꞉bene ko gogonomote ba mahigana koko gawiyoeno beyate boge guamo da꞉pa꞉la꞉haniya꞉ bogete tatalila ululuna. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ba꞉bema꞉ iba꞉te Ya꞉sutamo pelamenate ebe ba pemodoetena ba꞉bo pega꞉lameniya꞉, “Iya꞉tulamedawa, a ba꞉ koha꞉lahama꞉nema꞉!” Ba꞉ba tetelo Ya꞉suti mahiganate huhu ba꞉gala koko gawiya na꞉kiyahalameniya꞉, “La꞉ na꞉tatabahala꞉!” ba꞉bene huhuti wibonate bobote tatabama꞉ ba꞉bo eda꞉niya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ba꞉bema꞉ Ya꞉suti iba꞉tamo na꞉goeniya꞉, “La꞉eno hibima꞉ midi komo keka꞉?” Huiyatiya iba꞉te tola꞉go hanohanoholo ibi ipuwalo na꞉ga꞉laniya꞉, “Moe lumagi potela꞉ka꞉? Ebete huhu ba꞉gala gawiya da꞉kiyahalame, iba꞉te ebeno tabamo a꞉papamila꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ba꞉bene Ya꞉suku ba꞉gala ebe ta꞉matapi iba꞉te Gelasa haboeno hopamo nikuliya꞉, ba꞉be hopote Ga꞉lili Bobo hapulu itanami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ya꞉suti hakamo ba nodolo Gelasa habanapi kuba gobogobagoeno dubuti eba꞉go paluguya꞉, ebete tete ga꞉ga꞉nomolo kalikoheno emedenami ba꞉gala ebe genamanomolo kemedenamiha꞉. Ba꞉ hibila, ba꞉be hopo tawakalubino komo ba꞉ma ka꞉nala, iba꞉te iya꞉ha꞉midale nakola haka ba aligili hiya꞉hiya꞉ bobo ba꞉bo ododilinakuya꞉ iba꞉te ibino ha꞉laha tawakalubi miya꞉tenoma꞉, ba꞉bene ba꞉be dubuti ba꞉bi nakola bobo ipuwalo emedenami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ebete Ya꞉suku umiti ibulunomo goewatate ebeno nato mabamo gate tabo madodo ba adipate na꞉goiya꞉, “Ya꞉su! Ama꞉ Hununomo Godokono Gudulata! Ama꞉le natamo bada komo na꞉kododiomena꞉? Nale ama꞉ betoemehomata, natamo kuba huiya akikanama꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ebete tabo ba꞉ma ka꞉na goiya꞉ mabu Ya꞉suti kuba gobogobo a꞉kiyahamiya꞉ ebegodone kuluhukuma꞉. Ba꞉ hibila, dopamo komo hiliyonomo tetelo ba꞉be kuba gobogobote ba꞉be dubu ipuwalo helonomoma꞉ eda꞉nami, ba꞉bema꞉ tawakaluba꞉te ebeno nato kokoto auli hala꞉mo da꞉matuhulameholemenakui, ebete ba꞉bi hale iya꞉hilinakui kuba gobogoboeno heloamo dito hopamo ba꞉bo alahula꞉nakui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ba꞉bene Ya꞉suti ebe nalatediya꞉, “Amia꞉no mahilo potela꞉ka꞉?” Ebete na꞉huiyuya꞉, “Naeno mahilo Hiliyonomotela,” mabu ebe ipuwalo kubakuba gobogobo hiliyonomate emedenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ba꞉bene ba꞉bi kubakuba gobogobate Ya꞉suku na꞉toemehuya꞉, “Ama꞉ a Koe Habamo akanoea꞉ma꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ba꞉ba tetelo dabihole goegoe hiliyonomate haka hunulu nala꞉go ba꞉bolo na꞉wapata꞉lamitiya꞉. Kubakuba gobogobate Ya꞉suku na꞉toemehuya꞉ iba꞉te goegoe ipuwamo konogomoma꞉, ba꞉bene Ya꞉suti modobo tabo goete ibi ba꞉bo goelamiya꞉, “Na꞉tolama꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ba꞉bema꞉ kubakuba gobogobate dubugodone ikuliti goegoa꞉tamo da꞉nogomuya꞉, goegoe hiliyonomate haka hununi pulila꞉hate iya꞉ha꞉midale hakane da꞉negudiya꞉ beyamo nululuhuliti ba꞉ dito neha꞉lahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ba꞉ba tetelo goegoe ulamepi dubate ba꞉be komo umiti ibino habamo pulila꞉hate, habalubi ba꞉gala tumu genamalo demedehonama꞉ da꞉nikiyahalamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","tawakalubi hiliyonomate ba꞉bo pelamiya꞉ Ya꞉suti dododiya꞉ ba꞉be komo umima꞉. Iba꞉te ebetamo pikuliti kubakuba gobogobate da꞉miya꞉puya꞉ ba꞉be dubu ba꞉bo pumiya꞉, ebete kaliko puliti Ya꞉sukunu nato mabulu lutiya꞉ mabu ebeno ukui a꞉tuputupumiya꞉. Ba꞉moe mabuma꞉ iba꞉te na꞉toletolehutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ba꞉bene puya꞉te ba꞉be komo dumiya꞉ ba꞉bi tawakaluba꞉te kubakuba gobogobagoeno dubuti keba ka꞉na ka꞉hiduya꞉, ba꞉be komoma꞉ komo tawakalubi ba꞉bo kiyalamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ba꞉ba tetelo ba꞉bi Gelasa hoponapi hiliyonomate Ya꞉suku na꞉ga꞉lamiya꞉ ebete ibino hopo miya꞉pate kotoma꞉ mabu iba꞉te konomamo toletolehutiya꞉. Ba꞉bema꞉ Ya꞉suti boga꞉mo ololote ba to, ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","kubakuba gobogobate da꞉miya꞉puya꞉ ba꞉be dubuti ebe na꞉toemehuya꞉, “Na niliya, ama꞉go kopa꞉mo!” Huiyatiya Ya꞉suti ebe ba oeme na꞉goemiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ama꞉ genamamo na꞉toa. Godote ama꞉tamo kebe komokomo kododila꞉ka, amia꞉no habalubi ba꞉bi komokomo na꞉nikiyalama꞉.” Ba꞉bene ba꞉moe dubuti ebeno habamo tote, Ya꞉suti ebetamo dododiliya꞉ ebete ba꞉bi komo hiliyonomo tawakaluba꞉tamo ba꞉bo nolamagiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ya꞉suti bobo hapuni gala da꞉kapa꞉hiwuya꞉, ba꞉ba tetelo tawakalubi hiliyonomate na꞉kalakalahuya꞉ mabu iba꞉te ebeno pe komo belatimitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ba꞉bene Yu tawakalubino baidi ibubulamehole genama umidawa dubuti Ya꞉sutamo piya꞉, ebeno mahilo Ya꞉ilasitila. Ebete Ya꞉sukunu nato mabamo pepapamiwatate ebe ba꞉bo petoemehuya꞉ ebete ebeno genamamo kotoma꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","mabu ebeno kapiyanomo 12 gogo tete bohele ebete hoe tatalila. Ba꞉bene Ya꞉suti Ya꞉ilasikono genamamo to da꞉tupuimiya꞉, hiliyonomo tawakaluba꞉te ebe ba anataguma꞉tuta emokatihuia꞉go tolamitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ibi ipuwalo eta kamena 12 gogo tetelo hawi ka꞉ka꞉la꞉ temetemete uminami, ebete ebeno mani hiliyonomo dogeta dubatamo ba ikalame ba꞉bo upula꞉liya꞉, huiyatiya iba꞉te ebe kahiduimiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ba꞉bene ba꞉moe kamenate Ya꞉sukunu gala hapuni pete ebeno kaliko da꞉pologiya꞉, ba꞉ba tetenomolo ebeno hawi ka꞉ka꞉la꞉ temetemete ebegodone ba꞉ dito wibuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Na pote kologini?” Tawakalubi hiliyonomate iya꞉tawaha꞉ma꞉ ba ga꞉la Pitate ebe na꞉kiyamiya꞉, “Hido Iya꞉tulamedawa, hiliyonomo tawakaluba꞉te ama꞉ ba anataguma꞉hita emokatihuia꞉go pelamita.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ya꞉suti na꞉goiya꞉, “Eta lumagiti na ologini mabu helote na ipuwane duluhuku, na ba꞉bo iya꞉tawamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ba꞉bene ba꞉be kamenate bada komo kododiya꞉ awamina gabo kumiya꞉ha꞉, ba꞉bema꞉ ebete lililago Ya꞉sukunu nato mabamo pepapamiwatate hiliyonomo tawakalubino holoholo hapulu ebeno komo ba꞉bo hawakalimiya꞉. Ebete Ya꞉suku bada mabuma꞉ ka꞉pologiya꞉ ba꞉gala temetemete ba꞉ba tetenomolo ebegodone da꞉wibuya꞉, ebete ba꞉bi komokomo hiliyonomo Ya꞉sutamo ba꞉bo kiyahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Kamena, amia꞉no hibima꞉ midi komote ama꞉ a꞉hiduima꞉ta. Ama꞉ kalakalago na꞉toa.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ya꞉suti ba꞉moe tabo ba olamagita Yu watodawa Ya꞉ilasikono genamane eta tabo adahedawate pete Ya꞉ilasiko na꞉pegoemiya꞉, “Amia꞉no gudu bohele a꞉hoe. Iya꞉tulamedawa gala akagoema꞉la꞉ ebe kopihiduimima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Huiyatiya Ya꞉suti ba꞉be tabo uliti Ya꞉ilasitamo na꞉goiya꞉, “Ama꞉ akatoletola꞉la꞉. Ama꞉ Godoko hibima꞉ na꞉mida꞉, ba꞉bene amia꞉no bohelete kohidoma꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ba꞉bene Ya꞉suti Ya꞉ilasikono genamamo puluhukuti komo tawakaluba꞉te genama guamo a꞉pa꞉la꞉hama꞉ ibi na꞉duhilamiya꞉, huiyatiya Pitako, Yoneko, Ya꞉imesiko, ba꞉gala boheleno nabiwi menoko, eba꞉go ba꞉moi ba꞉te na꞉pa꞉la꞉huya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ba꞉ba tetelo genama gulu da꞉pola꞉nuya꞉ ba꞉bi tawakalubi hiliyonomate bohele bela꞉mitiya꞉, ba꞉bema꞉ Ya꞉suti ibi na꞉goelamiya꞉, “La꞉ kihimitala꞉. Gudu bohele kahaa꞉kaha꞉, ebete u bewatita!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Huiyatiya iba꞉te iya꞉tawahuya꞉ guduti hoenomo hoiya꞉, ba꞉bema꞉ iba꞉te Ya꞉suku na꞉walitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ba꞉bene Ya꞉suti tote bohele kokotamo nelawete ebe ba ka꞉mi na꞉goiya꞉, “Gudu, ama꞉ na꞉mahiga!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ba꞉bema꞉ ebeno ka꞉ka꞉te ebetamo gala da꞉kapiya꞉ ba꞉ba tetenomolo ebete na꞉kamahiguya꞉, ba꞉bene Ya꞉suti ebeno menoko nabiwi na꞉goelamiya꞉ iba꞉te ebetamo baa꞉ kikamehoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ba꞉be mabuma꞉ iba꞉te na꞉hanohanohutiya꞉ huiyatiya Ya꞉suti ibi ba kiyalame na꞉goiya꞉, “La꞉ ba꞉moe komoma꞉ komo tawakalubi akakiyalama꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ba꞉ba tetelo Ya꞉suti ebeno 12 ta꞉matapi dubu ebetamo ka꞉lamiti iba꞉tamo helo ba꞉bo ikalamiya꞉ tawakaluba꞉godone kuba gobogobo konoelamema꞉ ba꞉gala hiya꞉hiya꞉ temetema꞉gopi konihiduilamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ba꞉bene ebete ibi noelamiya꞉ Godote Ko Gawadubuma꞉ deda꞉na iba꞉te ba꞉be komo tawakaluba꞉tamo konolamagimima꞉ ba꞉gala iba꞉te temetema꞉gopi konihiduilamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ebete iba꞉tamo na꞉goiya꞉, “La꞉eno tolame tetelo la꞉le kuku, ba꞉gala mani miya꞉teno kuiha, ba꞉gala baa꞉, ba꞉gala mani, ba꞉moi ilina akuwata꞉la꞉. Ba꞉gala la꞉ kapiyakapiya ilina na꞉pupuliya꞉la꞉, komo akuwata꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ba꞉bene la꞉ eta habamo nikuliti kebe genamamo da꞉nalehawaminama, la꞉ ba꞉bolo nemeda꞉tepate galane ba꞉be genamane eta hopamo kakatolamema꞉nemata, iyo, la꞉ eta genamane eta genamamo eba ka꞉na akanewagela꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ba꞉gala kebe habaluba꞉te la꞉ uwateheno, ba꞉be haba ba miya꞉pa la꞉le natoeno puhulu na꞉moda꞉midatepaliya꞉la꞉. Ba꞉moe komote ba꞉bi tawakalubi kiya꞉tulamema꞉ne, Godokono tete ba꞉ na꞉pe ebete ibino komo kopanagiya꞉midalamema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ba꞉bema꞉ Ya꞉suku ta꞉matapa꞉te hiliyonomo habahabamo tolamete Godokono Hido Tabo tawakaluba꞉tamo ba nolamagimi hiya꞉hiya꞉ temetema꞉gopi ba꞉bo nihiduilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ba꞉ba tetelo Ga꞉lili hopolo Heloditi Ko Gawadubuma꞉ eda꞉nami. Ba꞉bene Ya꞉suti kebe hiliyonomo komo kododilinakui Heloditi ba꞉bi komokomo ulihote ukui bilibilima꞉ ba꞉bo ediya꞉, mabu komopa꞉te na꞉ga꞉luya꞉, “Yoneko tawakalubi beyamo wadulateledawate hoe ipuwane a꞉mahigui!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ba꞉bene komopa꞉te na꞉ga꞉luya꞉, “Ya꞉suku ba꞉ Elayate, Godokono ukui hawakalimidawala, ebete atamo gala a꞉kapuluhukui,” huiyatiya komopa꞉te na꞉kaga꞉luya꞉, “Ao, ebe ba꞉ eta Godokono ukui hawakalimidawala. Aeno iniwala꞉tamo dopamo da꞉pikuliya꞉, ibi ipuwalo etate hoe ipuwane a꞉mahigui.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ba꞉bene Heloditi na꞉goiya꞉, “Na Yonekono wato itamidamimo, huiyatiya moe dubu potela꞉ka꞉ nale ebeno ododili komokomo dulihonamo?” ba꞉bema꞉ tete ga꞉ga꞉lo ebe ubila Ya꞉suku kumima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ya꞉suti doelamiya꞉ ba꞉bi ta꞉matapi dubate ebetamo gala kapelamete iba꞉te kebe hiliyonomo komokomo ka꞉nododiliya꞉ ebe ba꞉bo pikiyahamiya꞉, ba꞉bene ebete komo tawakalubi miya꞉palete ebe ta꞉matapinomo uwatete iba꞉te Betasaida habamo dito tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ba꞉bema꞉ hiliyonomo tawakaluba꞉te Ya꞉sukunu to komo ulihote ebeno galane na꞉katolameholiya꞉, ba꞉bene ebete ibi kalakalago uwatete Godote Ko Gawadubuma꞉ deda꞉na ba꞉be komo ibi ba꞉bo iya꞉tulamiya꞉, ba꞉gala atu tetelo ebete ibino temetema꞉gopi ba꞉bo kahiduilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hegelate ba nihitigana Ya꞉sukunu 12 ta꞉matapa꞉te pelamenate ebe ba꞉bo pega꞉lameniya꞉, “Ama꞉ tawakalubi noelama꞉, iba꞉te habahabamo ba꞉gala tumu genamamo tolameholete baa꞉ ba꞉gala laha bahi konulamema꞉, mabu moe tawakalubiha꞉ bahila.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Huiyatiya Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Ao, la꞉le iba꞉tamo naha ilina nikalamehola꞉la꞉.” Iba꞉te na꞉huiyaniya꞉, “Agodolo paibo baa꞉ ba꞉gala daha netewa ba꞉binomate pola꞉na. Ba꞉bema꞉ ama꞉ ubila꞉ka꞉ ale tolamete aeno mana꞉mo ibino baa꞉ konuwateholamema꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iba꞉te ba꞉ma ka꞉na ga꞉laniya꞉ mabu 5,000 dubate ba꞉bolo pola꞉nuya꞉. Ba꞉bene Ya꞉suti ebe ta꞉matapi na꞉goelameniya꞉, “La꞉le tawakalubi hiya꞉hiya꞉ kapiyuilame ododiliti hakamo ahidima꞉ na꞉kiyalama꞉la꞉, iba꞉te eta kapiyuimilo 50, eta kapiyuimilo 50, ba꞉ma ka꞉na nahidihamena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ya꞉suku ta꞉matapa꞉te ba꞉be tabo ulinate ba꞉ba ka꞉na ododiniya꞉, ba꞉bene tawakalubi hiliyonomate ibino kapiyuimilo hakamo dito gagahidiniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ba꞉bene Ya꞉suti paibo baa꞉ ba꞉gala daha netewa uwatenate, Hunu Habamo gahimilo Godotamo kalakala tabo goenate ba꞉bi baa꞉ dahago wakalamiholenate ebe ta꞉matapa꞉tamo dito ikalameniya꞉ iba꞉te tawakaluba꞉tamo kikalameholenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ba꞉ba tetelo tawakalubi hiliyonomate baa꞉ da꞉nahaniya꞉ ibino kape komo ba꞉bo wiboholameniya꞉, ba꞉bene Ya꞉suku ta꞉matapa꞉te da꞉luhiliniya꞉ ba꞉bi baa꞉ komokomamo 12 bagolo betabuilameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Eta hegelalo Ya꞉suku ha꞉kiya tataba hopolo Godokoba꞉ tabo ba ga꞉luta ebeno ta꞉matapa꞉te ebetamo ba꞉bo pikuliya꞉. Ba꞉bene ebete ibi nalateda꞉liya꞉, “Tawakaluba꞉te na pokomo ka꞉ga꞉lanaka?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Iba꞉te na꞉ga꞉luya꞉, “Komopa꞉te ama꞉ Yoneko beyamo wadulateledawama꞉ ga꞉lanaka, komopa꞉te Elayako Godokono ukui hawakalimidawama꞉ ga꞉lanaka, ba꞉gala komopa꞉te ama꞉ Godokono ukui hawakalimipa꞉te dopamo aeno iniwala꞉tamo da꞉pikuliya꞉, ibi ipuwalo etate hoene na꞉mahigamo ga꞉lanaka.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ba꞉bene Ya꞉suti ibi nalateda꞉liya꞉, “Huiyatiya la꞉le na pokomo ka꞉midinionama?” Pitate ebetamo na꞉huiyuya꞉, “Ama꞉ ba꞉ Kelisotela, Godokono Oemedawalata!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ba꞉bene Ya꞉suti ibi kiyahalamelo na꞉goiya꞉, “La꞉le naeno komoma꞉ komopi akakiyalama꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ba꞉bene ebete tabo moga꞉melo na꞉goiya꞉, “Tawakalubino Naniwi tawakaluba꞉godone koko temeteme galane kuwatema꞉ne, Godokono ubila. Iyo, Godotamo hawa꞉goeno ikamehopino watowatopi, ba꞉gala Godokono Tutumu iya꞉tulamepi, ba꞉gala komo koko dubu iba꞉te ebe ubiha꞉ma꞉ keda꞉hama꞉na꞉, ba꞉bene tawakaluba꞉te ebe kanakapumima꞉na꞉, huiyatiya netewa-kapiya hegelalo ebete hoene gala kakamahigama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ba꞉bene ebete ibi hiliyonomatamo na꞉goiya꞉, “Kebe lumagiti na ta꞉mahenema꞉ ubi dihatemene, dopamo ebete ebeno komo adodolete, ba꞉bene hiliyonomo hegelalo ebete ebeno keha pihiga aguti na ba꞉bo na꞉ta꞉mahenenamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ba꞉ hibila, kebe lumagiti ebeno ka꞉ka꞉ natamo damawada꞉mene ebeno ka꞉ka꞉te kalatidima꞉ne, huiyatiya kebe lumagiti ebeno ka꞉ka꞉ na mabuma꞉ datutimini, ebete hibi ka꞉ka꞉ kolawema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ba꞉bema꞉ lumagiti hopoeno ilina hiliyonomo uwatenomo ba uwate ebeno ka꞉ka꞉ datutimini ebeno huiya keka꞉? Godote lumagigodone ebeno ka꞉ka꞉ da꞉lawememene, ebegodolo bada hido komote na꞉kitanamene? ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ba꞉bema꞉ numa꞉la꞉, kebe lumagiti natamo ba꞉gala naeno tabamo da꞉hilopomene, na Tawakalubino Naniwiti ba꞉ atumu ebetamo kohilopoma꞉nemo, iyo, nale naeno alago da꞉pemo, ba꞉ba tetelo Nabiwi Godoko ba꞉gala ebeno hido-talona nopopi ibino helonomo alago pete ebe kopehilopuimima꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na la꞉tamo hibi tabo begoemo, ba꞉ma tetelo demedehona komo iba꞉te Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be ko komo dopamo umiti galane ba꞉bo koha꞉lahama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Eta kapiya wuiki da꞉wibuya꞉ ba꞉ba tetelo Ya꞉suti Pitako, Ya꞉imesiko, ba꞉gala Yoneko uwatete eta haka hunamo magataliya꞉, ebete ba꞉bolo Godokoba꞉ tabo konega꞉lama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ba꞉bene ebe ha꞉kiya Godokoba꞉ tabo ba ga꞉luta, ebeno holoholo hiya꞉ma꞉ ba꞉bo ediya꞉ ba꞉gala ebeno pupulino ilinate keyakeyahibinomoma꞉ ba eda꞉hame ba꞉bo a꞉laminahalemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ba꞉ba tetenomolo dubu netewa Elayako ba꞉gala Moseseko, iba꞉te puluhukuti Ya꞉sukuba꞉ tabo bega꞉lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Iyo, ibi netewapa꞉te Godokono Hunu Haboeno alago puluhukuti eba꞉go tabo ba꞉ma ka꞉na ga꞉lutiya꞉, Ya꞉suti Godokono nopo tawakaluba꞉tamo kohawakalimima꞉ ebete Yelusalema ko habalo kohoema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitako ba꞉gala ebeno mabulubi netewa iba꞉te u ba lahuta ba꞉moe hanohano komo ba꞉bo uluhukuya꞉, ba꞉bene iba꞉te ibino baidi a꞉la꞉minahalete Ya꞉sukunu alo ba꞉gala dubu netewa eba꞉go da꞉la꞉mota꞉nuya꞉ ba꞉bo ulamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ba꞉bene dubu netewapa꞉te Ya꞉sugodone ba tuta, Pitate ebe na꞉goemiya꞉, “Hido Iya꞉tulamedawa, a ba꞉malo da꞉pola꞉nama꞉, kalakala konomola. Wadiyala, a mimiya netewa-kapiya ketemotema꞉nema꞉, eta amia꞉nola, eta Mosesekonola, eta Elayakonola.” Pitate ukuihino ba꞉moe tabo ba꞉bema꞉ goiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitate tabo ba olamagita hawaiti pete ibi dito patulateliya꞉, ba꞉bema꞉ iba꞉te na꞉toletolehutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ba꞉bene hawai ipuwane tabote ba꞉ma ka꞉na puluhukuya꞉, “Ba꞉moe ba꞉ naeno Gudula, nale ebe dopamo a꞉ka꞉miya꞉mo! La꞉ ebeno tabo nulia꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ba꞉be tabote da꞉wibuya꞉ iba꞉te Ya꞉suku kapiya bumiya꞉, ba꞉bene tete ga꞉ga꞉dopolo ba꞉bi ta꞉matapa꞉te kebe komo kumiya꞉ iba꞉te komo tawakalubi kakiyalamiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ba꞉be eta hegelalo iba꞉te haka hununi da꞉pepalaguya꞉ tawakalubi hiliyonomate pelamete Ya꞉sukuba꞉ dito paluguya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ba꞉bene ibi ipuwalo kapiya dubuti ibulunomo ba꞉bo goepatiya꞉, “Iya꞉tulamedawa, naeno guduino komoma꞉ ama꞉ betoemehomata mabu ebe ba꞉ naeno kapiya gudunomola! ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kuba gobogobote gaa꞉tepahago ebe da꞉lawenako, guduti hakamo da꞉ganako ebeno apete kodakodanomoma꞉ eda꞉menako ba꞉bene ebeno tabone paguti pikuliminako, ba꞉gala ebe lawe tetelo kuba gobogobote naeno gudu tiyolo a꞉kamiya꞉pale! ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ba꞉bema꞉ nale ama꞉ ta꞉matapi a꞉toelamehola꞉kamo iba꞉te kuba gobogobo koemema꞉, huiyatiya iba꞉godolo helo puliyala.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ya꞉suti huiyatiya ibi hiliyonomatamo na꞉goiya꞉, “A꞉iye, la꞉ hibima꞉ midiha꞉ kuba tawakalubilata! La꞉ natamo menemene bikanamenamata, ba꞉bema꞉ na ubihinola tete ga꞉ga꞉lo la꞉go emedena!” Ba꞉bene ebete dubutamo na꞉goiya꞉, “Amia꞉no gudu mamo na꞉magaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ba꞉ba tetelo kuhiti ba penape kuba gobogobote ebe lawete hakamo dito a꞉da꞉nuya꞉, ba꞉bene kuhiti kubanomamo ba꞉bo ewagelehuya꞉. Ba꞉bene Ya꞉suti kuba gobogobo da꞉kiyahamiya꞉, ba꞉ba tetelo kuhiti hidote Ya꞉suti ebe ebeno nabiwitamo dito ikamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ba꞉bema꞉ ba꞉be komo dumiya꞉ ba꞉bi tawakalubi hiliyonomate Godokono ko helo komoma꞉ na꞉hanohanohutiya꞉. Ba꞉bema꞉ tawakaluba꞉te Ya꞉sukunu hiliyonomo ododili komokomoma꞉ ba hanohanohuta, ba꞉ba tetelo Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nale ba꞉ma tetelo la꞉tamo dolamagimo, ba꞉be tabo hidamo uliti akadodala꞉ — Godote Tawakalubino Naniwi kuba tawakalubino kokotamo kihatema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ba꞉ba tetelo iba꞉te ba꞉be taboeno ipuwa hidamo kemalagidoluya꞉ha꞉ mabu awamina ipuwalo itanami, huiyatiya iba꞉te iya꞉tawaha꞉ma꞉ ba eda꞉ha ba꞉moe taboeno ipuwa komoma꞉ Ya꞉suku kiyamema꞉ na꞉toletolehutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ba꞉bene ta꞉matapa꞉te ibi ipuwalo pote koma꞉ eda꞉ma꞉ olowabeletehuitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iba꞉te ibino tepo ipuwalo demalagidolutiya꞉ Ya꞉suti ba꞉be komo iya꞉tawuya꞉, ba꞉bema꞉ ebete gudu lawete ebe tama꞉mo ba adipi ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","iba꞉tamo na꞉goiya꞉, “Kebe lumagiti naeno mahilamo ba꞉mako gudu deha꞉poto kalakalago dowalubina ebete na bowalubinina, ba꞉gala kebe lumagiti na dowalubinina, ebete na kapiya kowalubininaha꞉, ebete na Oenamedawa Godoko atumu na꞉kowalubina. Ba꞉bema꞉ la꞉ ipuwalo pote deha꞉potodawanomoma꞉ deda꞉mene ba꞉be dawate konomoma꞉ keda꞉ma꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ba꞉bene Yonete na꞉goiya꞉, “Hido Iya꞉tulamedawa, ale eta dubu umima꞉ ebete amia꞉no mahilamo kuba gobogobo doelamiti, huiyatiya ale ebe a꞉kiyahamima꞉ ba꞉be komo kekelamema꞉ mabu ebe aeno kapiyuimi lumagiha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Huiyatiya Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉le ebe akaduhima꞉la꞉, mabu kebe lumagiti la꞉go alaholohodawama꞉ deda꞉na, ebete ba꞉ la꞉ bowalubilinata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ba꞉bene Ya꞉suti Godokono Hunu Habamo nodolo tete da꞉tataliya꞉, ebete ba꞉be komo iya꞉tawate ebeno ukui konomamo ba꞉bo ihatiya꞉ Yelusalema ko habamo kotoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ba꞉bene gabo tetelo ebete Samaliya hopoeno eta habamo nopo atapi dopamo oelamiya꞉, iba꞉te ba꞉bolo ebeno wata bahi ba꞉gala baa꞉ konihiduilamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Huiyatiya ba꞉be habanapa꞉te iya꞉tawahuya꞉ Ya꞉suti Yelusalemamo tolame gabodo da꞉tutiya꞉, ba꞉bema꞉ iba꞉te ebetamo ubiha꞉ tabo bega꞉luya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ba꞉bene Ya꞉imesiko ba꞉gala Yoneko, iba꞉te ba꞉moe komo umiti na꞉ga꞉luya꞉, “Kodawa, wadiyala꞉ka꞉ a Godoko kiyame ebete Hunu Habane koe poemete ibi kokubahilamema꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Huiyatiya Ya꞉suti ibi netewapa꞉tamo ohobigate ibi konomamo ba kiyahalame iba꞉tamo na꞉goiya꞉, “Mabu keka꞉ la꞉le na kuba ukuia꞉mo da꞉kiyanamema? Mabu la꞉eno tepo ipuwoeno ukui ba꞉gala naeno tepo ipuwoeno ukui hiya꞉hiya꞉ ba꞉pola꞉na! ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na Tawakalubino Naniwiti tawakalubi kubahilamema꞉ kapiya꞉ha꞉, huiyatiya nale ibino ka꞉ka꞉ mula꞉lelamema꞉ piya꞉mo.” Ebete ba꞉be tabo goete, iba꞉te eta habamo lahama꞉ ba꞉ dito tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iba꞉te ba tolamita eta dubuti Ya꞉sutamo na꞉goiya꞉, “Ama꞉ keba hapuamo da꞉tomena꞉, nale ama꞉ ba꞉bamo kota꞉matama꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Huiyatiya Ya꞉suti ebetamo na꞉goiya꞉, “Hiya꞉, ama꞉ dopamo ba꞉moe eta komo hidamo nemalagidola. Tumu gahagahoeno laha bahi haka gugu ba꞉pola꞉lama꞉na ba꞉gala holaholate ibino genama etemotehonaka, huiyatiya na Tawakalubino Naniwi, naeno wata bahi puliyala.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ba꞉bene Ya꞉suti eta dubutamo na꞉goiya꞉, “Ama꞉ na na꞉ta꞉mahena꞉.” Ebete huiyatiya Ya꞉sutamo na꞉goiya꞉, “Kodawa, wadiyala na dopamo tote, naeno kadele nabiwiti da꞉hoemene, nale ebe bobamo nihatete na galane ama꞉ kota꞉mahema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ya꞉suti ebetamo na꞉huiyuya꞉, “Wadiyala, ha꞉laha tawakaluba꞉te ibi ha꞉kiya ibino ha꞉lahapi bobamo na꞉miya꞉ta꞉mena꞉, huiyatiya ama꞉ tote Godote Ko Gawadubuma꞉ deda꞉na ba꞉be komoeno tabo tawakaluba꞉tamo na꞉nolamaginakuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ba꞉bene eta dubuti na꞉goiya꞉, “Kodawa, na ubila ama꞉ ta꞉mahe, huiyatiya wadiyala na dopamo tote naeno genamanapa꞉tamo yawo tabo konegoema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Huiyatiya Ya꞉suti ebetamo na꞉goiya꞉, “Kebe lumagiti haka aligilino ilinamo pali oko ba tupuimi, haboeno komokomo emalagidolete okone gala da꞉kohobigamene, ba꞉bako lumagiti Ko Gawadubu Godokono oko owatima꞉ a꞉kamodobamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ba꞉moe tabo da꞉wibuya꞉ ba꞉ba tetelo Kodawa Ya꞉suti komo 72 ta꞉matapi uwatete etapi netewa, etapi netewa, ba꞉ma ka꞉na dopamo oelamiya꞉, ebete da꞉tomene ba꞉bi hiliyonomo habahabamo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ebete iba꞉tamo na꞉goiya꞉, “Godokono pali ipuwalo kona hiliyonomo ba꞉ a꞉kodakodahui, huiyatiya wakalami okopi hiliyoha꞉, ba꞉bema꞉ la꞉ pali namutudawatamo toetoe tabo na꞉ga꞉lala꞉, ebete komo okopi pali ipuwamo kopoelamema꞉ne hidohido nahoeno kona kopewakalamima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ba꞉bema꞉ la꞉ na꞉tolama꞉la꞉! La꞉ sipi-goegoe hegehege keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala, nale la꞉ helohelo gahagahoeno kapiyuimi ipuwamo oelamemata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","La꞉ mani miya꞉teno kuiha akuwata꞉la꞉, ba꞉gala la꞉ baa꞉ miya꞉teno hika ba꞉gala nato ilina akuwata꞉la꞉. Ba꞉gala la꞉ gabo tetelo eta lumaga꞉go da꞉nalugama eba꞉go tabo ba nega꞉la la꞉eno oko tete akanikubahima꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ba꞉bene la꞉ kebe genamamo da꞉nalehawaminama, wadiyala la꞉ ba꞉be genamanapa꞉tamo nolata tabo na꞉nega꞉luya꞉la꞉ ba꞉ma ka꞉na, ‘Godokono kalakalate la꞉eno genamalo nitanamene.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ba꞉bema꞉ Godokono gelebadi lumagiti ba꞉bolo demedena, Godokono kalakalate ebegodolo hibilo kitanama꞉ne, huiyatiya ba꞉bako lumagiti ba꞉be genamalo lutaheno, la꞉ nolata tabo da꞉ga꞉lama ba꞉be taboeno hibi komote ba꞉bolo a꞉kitanamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","La꞉ ba꞉be genama kapiyalo na꞉nemediya꞉la꞉, ba꞉bene iba꞉te la꞉tamo dikalameholemena꞉ ba꞉bi baa꞉ nahate ibino beya atumu na꞉kanihuya꞉la꞉, mabu la꞉ okopa꞉te ba꞉bako huiya lawe wadiyala, ba꞉gala eta habamo tolame tete uluhukuhino la꞉ eta genamane eta genamamo eba ka꞉na akanewagela꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Iyo, la꞉le eta habamo tolamete iba꞉te la꞉ kalakalago duwatemena꞉, ba꞉ba tetelo iba꞉te kebe naha ilina la꞉tamo dikalamemena꞉ kalakalago na꞉nahuya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ba꞉gala ba꞉be habalo demedena la꞉ ba꞉bi temetema꞉gopi hiduilamete habalubi hiliyonomatamo ba꞉ma ka꞉na na꞉ga꞉luya꞉la꞉, ‘Godote Ko Gawadubuma꞉ deda꞉na ba꞉be komote la꞉tamo ba꞉ a꞉tatali.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Huiyatiya la꞉ eta habamo nikuliti iba꞉te la꞉ kalakalago uwateheno, la꞉ ba꞉be haba tulinomolo ba la꞉mota꞉hana ibi hiliyonomatamo ba꞉ma ka꞉na na꞉ga꞉luya꞉la꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘La꞉eno haboeno haka puhulu aeno natone na꞉moda꞉midatepalema꞉, mabu ba꞉moe komote la꞉ biya꞉tulamitata Godokono tete ba꞉ na꞉pe ebete la꞉eno komo kopanagilamelelamema꞉. Ba꞉bema꞉ ba꞉moe ko komo akadodala꞉, Godokono Ko Gawadubu tetete la꞉tamo ba꞉ a꞉tatali!’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goiya꞉, “Na la꞉tamo hibi tabo begoemo, Godote tawakalubino komo danagilamelelamemene, ba꞉be Ko Hegelalo ebete ba꞉moi habaluba꞉tamo kuba huiya konomamo kikalamema꞉ne. Ba꞉ba tetelo ebete Sodomo habaluba꞉tamo kuba huiya ba ikalame malemale nanekela꞉mo kohawakalimima꞉ne, huiyatiya hibila, ebete malemale a꞉kihata꞉mene ba꞉moi kuba tawakaluba꞉tamo!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Kolasini haba, ama꞉ kuba huiya konomo kolawema꞉na꞉ta! Betasaida haba, ama꞉ ba꞉ atumu! Mabu nale la꞉godolo hanohano komo dododilimo, la꞉ ba꞉ba tetelo la꞉eno kubane kohobila꞉ha꞉. Huiyatiya nale ba꞉bakobako oko Taya habalo ba꞉gala Saidono habalo dopamo nododiliya꞉tale, ba꞉bi Yuha꞉ tawakaluba꞉te ibino kubakuba ukui hiya꞉ma꞉ ba꞉midiliya꞉na꞉. Iyo, iba꞉te ibino kuba ododili mabuma꞉ tepo temetemema꞉ eda꞉hate ba꞉be temeteme komo kohawakalimima꞉ iba꞉te kubakuba kaliko pupuliti hoeno puhulamo dito ba꞉gagahidiya꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ba꞉bema꞉ Godote tawakalubino komo danagilamelelamemene, ba꞉be Ko Hegelalo ebete Taya habanapa꞉tamo ba꞉gala Saidono habanapa꞉tamo kuba huiya ba ikalame malemale nanekela꞉mo kohawakalimima꞉ne, huiyatiya hibila, Kolasini haba ba꞉gala Betasaida haba, ebete la꞉tamo malemale a꞉kihata꞉mene! ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ba꞉gala Kapeniyama haba, amia꞉no komo ba꞉ma ka꞉nala. Ama꞉ ubila ama꞉ ha꞉kiya ama꞉ Godokono Hunu Habamo kadipatema꞉, huiyatiya Godote ama꞉ Koe Habamo ka꞉da꞉nama꞉na꞉ta!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ba꞉bene Ya꞉suti tabo moga꞉melo ebe ta꞉matapa꞉tamo na꞉goiya꞉, “Kebe lumagiti la꞉eno tabo dulimini ebete ba꞉be komo ipuwalo naeno tabo kulima꞉ne, huiyatiya kebe lumagiti la꞉ ubiha꞉ma꞉ deda꞉mene ebete ba꞉be komo ipuwalo na ubiha꞉ma꞉ keda꞉ma꞉ne, ba꞉gala kebe lumagiti na ubiha꞉ma꞉ deda꞉mene ebete na kapiya ubiha꞉ma꞉ a꞉keda꞉mene, ebete na Oenamedawa atumu ubiha꞉ma꞉ kakeda꞉ma꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ba꞉bene Ya꞉suti doelamiya꞉ ba꞉bi 72 dubate tolamete hiya꞉hiya꞉ habahabalo oko nowatiti, iba꞉te da꞉kawilaliya꞉ ko kalakalanomago ebetamo na꞉pega꞉luya꞉, “Kodawa, ale kuba gobogobo amia꞉no mahilamo da꞉nikiyahalamima꞉ iba꞉te aeno tabamo papamila꞉halete tawakaluba꞉godone ikuliya꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ya꞉suti iba꞉tamo ba huiya na꞉goiya꞉, “Hibila, Godote Saitanako heloha꞉ma꞉ miditi Hunu Habane da꞉pa꞉da꞉nui nale umimo, iyo, hegelate keba ka꞉na ka꞉la꞉wa꞉hiyanako ebete hopamo tiyonomo ba꞉ba ka꞉na pegui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","La꞉ hidamo nulia꞉la꞉! Na helo la꞉tamo ikalamimata la꞉le kalu ba꞉gala iwawa la꞉eno natamo komikimoelenakoma꞉, ba꞉be helote la꞉eno alaholodawa Saitanakono helo na꞉gogolona, ba꞉bema꞉ eta ilinate la꞉ a꞉kakubahilama꞉mena꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ba꞉gala ba꞉moe ba꞉ eta komola. Kuba gobogobate la꞉eno tabamo da꞉papamila꞉halenaka ba꞉be mabuma꞉ akakalakalahala꞉, huiyatiya Godote la꞉eno mahilo ebeno Hunu Haboeno Bukamo da꞉miya꞉telamiya꞉la la꞉ ba꞉be mabuma꞉ na꞉kalakalahala꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ba꞉ba tetelo Godokono Gobogobote Ya꞉sukunu tepo ipuwalo da꞉tabuya꞉ ebete Godotamo kalakalago na꞉goiya꞉, “Nabiwi, ama꞉ ba꞉moe hopo konomo ba꞉gala Hunu Haba Namutudawama꞉ eda꞉nata! Na ama꞉tamo kalakala tabo begoemo, mabu ama꞉ ba꞉moe hopoeno koko iya꞉tawahapi dubatamo amia꞉no mulu ukui ba awaminale iya꞉tawaha꞉ tawakaluba꞉tamo hawakalilamia꞉ta. Nabiwi, ba꞉ hibila, ba꞉moe komote amia꞉no ubilo puluhukui.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ba꞉bene Ya꞉suti tawakaluba꞉tamo na꞉goiya꞉, “Naeno Nabiwi Godote hiliyonomo komokomo naeno kokotamo a꞉miya꞉tiya꞉ nale kulamenama꞉, ba꞉bema꞉ ebete ha꞉kiya iya꞉tawala na ebeno Guduino komo, eta lumagiti iya꞉tawaha꞉. Ba꞉gala Nabiwino komo atumu, eta lumagiti iya꞉tawaha꞉ huiyatiya na ebeno Guduti ha꞉kiya iya꞉tawala, ba꞉gala nale puya꞉tamo hawakalimima꞉ ubi dihatemo, ibinomate atumu Nabiwino komo kakiya꞉tawahama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ba꞉bene Ya꞉suti ebeno ta꞉matapa꞉tamo pohobigate tabo diya ba꞉bo goelamiya꞉, “Godokono kalakala konomo la꞉godolo bitana, mabu la꞉ la꞉eno baida꞉mo ebeno komokomo hidamo nulamenamata! ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ba꞉bema꞉ nale la꞉ begoelamemata, dopamo tetelo Godokono ukui hawakalimipi ba꞉gala koko gawadubu iba꞉te ubi konomo bihatenama꞉ la꞉le dulamenama ba꞉bi koko komo ulamema꞉, huiyatiya iba꞉te kamodobuya꞉ha꞉, ba꞉gala ibi ubila la꞉le dulihonama ba꞉bi komo kulihoma꞉, huiyatiya iba꞉te kamodobuya꞉ha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ba꞉bene eta Godokono Tutumu iya꞉tulamedawate ubila Ya꞉sukunu mulu komo kopumima꞉, da꞉ hibila꞉ o da꞉ hibiha꞉, ba꞉bema꞉ ebete pete ebetamo na꞉pegoiya꞉, “Iya꞉tulamedawa, na bada komo ododiti wiboha꞉ ka꞉ka꞉ ebo na꞉ka꞉lawemo?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ya꞉suti ebeno tabo ba huiya na꞉goiya꞉, “Godote Bukamo ebeno Tutumu Tabo da꞉miya꞉tiya꞉, ba꞉bi komate a keba ka꞉na kiya꞉tua꞉mena? Ba꞉bi komokomoeno ipuwa keba ka꞉nala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ba꞉be dubuti na꞉huiyuya꞉, “Godokono Bukate ba꞉ma ka꞉na goena, ‘Ama꞉ amia꞉no Kodawa Godoko malemalelo nemalagidolona, amia꞉no tepo ipuwanomamo ba꞉gala amia꞉no gobogoboeno heloamo, amia꞉no helo konomamo ba꞉gala amia꞉no ukui konomamo,’ ba꞉gala eta tutumu tabo ma kumu bitana, ‘Ama꞉ ha꞉kiya ama꞉ demalagidolona, wadiyala ama꞉le ba꞉ ba꞉ba ka꞉na ama꞉ tamelo demedena ba꞉be lumagi malemalelo nemalagidolona.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉ hibi tabo begaa꞉ta. Ama꞉ ba꞉moe komo ododiti ba꞉bo ba꞉ka꞉ka꞉namena꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ba꞉be dubuti Ya꞉sukunu taboma꞉ hilopote huiyatiya ebeno hilopo ugumuilo ba꞉ma ka꞉na goiya꞉, “Na tamelo demedena, ba꞉be lumagi potela꞉ka꞉? Na poko na꞉kowalubinamo?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ya꞉suti ebeno tabo ba huiya na꞉goiya꞉, “Eta dubuti Yelusalema ko habane Yeliko habamo ba nihitiguta pilo dubate ebe lawete ebeno pupulino ilina pipikulamelemete ebe ba꞉bo anagalimihuya꞉. Ba꞉bene ebeno helote da꞉wibui iba꞉te ebe ba꞉bamo miya꞉patepate ba꞉ dito tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ba꞉ba tetelo Godotamo hawa꞉goeno ikamehodawate ba꞉be gabodo ba pita ebe pumiti tamedo dito negogolatepui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ba꞉bene Libai gudawate kapete ba꞉ atumu kapewageli. Dubuti da꞉kapitanui ebete ba꞉bamo puluhukuti ebe ba꞉bo pumi, huiyatiya ebete owalubi ebetamo kapihateha꞉, ba꞉ dito kanegogolatepui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ba꞉bene ba꞉be gabodo da꞉piti, eta dubu ebe Yu lumagiha꞉, ebe Samaliya hoponapi dubula, ebete ba꞉bamo puluhukuti ba꞉be dubu da꞉pumi ebeno tepo ipuwalo malemale konomo bipihati. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ebete ebetamo pete olibi kikipoeno ihi ba꞉gala hido mulamula ebeno bugumamo abutilamelemete kaliko hapuhapamo dito matuhulameholemi. Ba꞉bene ebete ba꞉be dubu ebeno donoki-goe hunamo adipiti eta habamo ba꞉bo magatui, ba꞉be habalo kapela tawakaluba꞉te da꞉lahanaka ebete ba꞉be genamalo ba꞉be dubu hidonomamo nowalubi. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Eta hegelalo Samaliya hoponapi dubuti netewa mani genama namutudawatamo ba ikame na꞉goi, ‘Ama꞉ ba꞉moe dubu hidonomamo nowalubinatiya꞉. Ba꞉moi maniti modoboheno, nale gala da꞉kapemo ama꞉tamo gala kakapehuiyama꞉nemo.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ba꞉bene Ya꞉suti tabo moga꞉melo Godokono Tutumu iya꞉tulamedawatamo na꞉goiya꞉, “Amia꞉no ukui kebanala꞉ka꞉? Pilo dubate danagalimihui ba꞉be dubutamo netewa-kapiyate da꞉pelami, ibi ipuwalo pote ebe owalubidawama꞉ ka꞉pedi? Ba꞉gala ebe tamelo demedena ba꞉bako lumagimo pote ka꞉pedi ebetamo malemale kohawakalimima꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ba꞉bene Godokono Tutumu iya꞉tulamedawate tabo ba huiya na꞉goiya꞉, “Ba꞉ Yuha꞉ lumagi kapiyate ebe koamo pemalemaleti.” Ba꞉bene Ya꞉suti na꞉goiya꞉, “Amia꞉no tabo ba꞉ hibila. Wadiyala, ama꞉ tote tawakaluba꞉tamo malemale ba꞉ma ka꞉na na꞉nehawakaliminakuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ya꞉suti ebeno ta꞉matapa꞉go Yelusalema gabodo ba tolamita iba꞉te eta habamo da꞉nikuliya꞉, ba꞉ba tetelo eta kamena ebeno mahilo Matatela ebete Ya꞉suku kalakalago na꞉goemiya꞉ ebete ebeno genamalo baa꞉ kopenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Matakono ekawino mahilo Ma꞉litila, ba꞉bene Ya꞉suti genamamo da꞉nodoluya꞉ Ma꞉liti ebeno nato mabamo pemedete Kodawa Ya꞉sukunu iya꞉tumi komo hidonomamo ulihutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Huiyatiya Matate ha꞉kiya baa꞉ hiduimi komo ba ododita ebe ubiha꞉ma꞉ eda꞉te Ya꞉suku ba꞉bo pegoemiya꞉, “Kodawa, ama꞉ na꞉kumiuta naeno ekawiti na kowalubinitaha꞉? Hiliyonomo komo na ha꞉kiya ododilitamo, ba꞉bema꞉ wadiyala ama꞉ ebe na꞉kiyama꞉, ebete pete na na꞉powalubinina!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kodawa Ya꞉suti ebeno tabo ba huiya na꞉goiya꞉, “Mata, Mata! Ama꞉ hiliyonomo hegehege komo ododilima꞉ ukui bilibilinomoma꞉ editata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Huiyatiya kapiya komote konomoma꞉ deda꞉na, Ma꞉liti ba꞉be hido komo umiti ba꞉ a꞉lawe, tawakaluba꞉te galane ebegodone a꞉kalawa꞉mena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Eta hegelalo Ya꞉suti tataba hopolo Godokoba꞉ tabo bega꞉lutiya꞉. Ba꞉be komote da꞉wibuya꞉ ebe ta꞉matapi ipuwalo etate ebe na꞉goemiya꞉, “Kodawa, Yonete ebe ta꞉matapi iya꞉tulami iba꞉te Godotamo keba ka꞉na da꞉toetoehonakomena꞉, ba꞉bema꞉ wadiyala ama꞉ a ba꞉be atu komo na꞉kiya꞉tua꞉ma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ Godotamo toetoe tabo ba꞉ma ka꞉na na꞉ga꞉lanakuya꞉la꞉, ‘Aeno Nabiwi, wadiyala amia꞉no talona mahilo tawakaluba꞉te nadipata꞉mena꞉, ba꞉gala wadiyala ama꞉le Ko Gawadubuma꞉ deda꞉na ba꞉be komote na꞉hawakalamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","‘Ba꞉gala wadiyala ama꞉ ba꞉moe hegeloeno baa꞉ atamo modobolo nikaa꞉ma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ba꞉gala komopa꞉te atamo kuba dododilina, ale ba꞉bi kuba egebolelamete kadodoholelamema꞉nema꞉, ba꞉bema꞉ wadiyala ama꞉ atumu aeno kuba egebolea꞉mete nadodoholea꞉ma꞉. ‘Ba꞉gala Saitanakono kuba gabamo emogabuimi ipuwalo ama꞉le huiyatiya a ba owalubi amia꞉no hido gabodo na꞉magatoenakuya꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Diyala, la꞉ ipuwalo eta lumagiti iwa tetenomolo ebeno mabulubitamo tote ba꞉ma ka꞉na da꞉ negoemene, ‘Naeno mabulubi, wadiyala꞉ka꞉ ama꞉ na nowalubina꞉? Baa꞉ netewa-kapiya natamo nikanama꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mabu naeno lumagiti muhulu hopone gala a꞉kawila, huiyatiya nagodolo baa꞉ puliyanomola nale ebetamo ikamema꞉!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Huiyatiya genama gulu da꞉luta, ebete tabo ba꞉ma ka꞉na kogoema꞉ne, ‘Ao, ama꞉ temeteme natamo akikanama꞉la꞉. Na gigiho a꞉kodakoduiminakamo, ba꞉gala na atumu guguda꞉go ba꞉ na꞉watanamo, ba꞉bema꞉ hidoha꞉ nale mahigate baa꞉ ama꞉tamo ikame.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Huiyatiya ama꞉le amia꞉no mabulubi toemeho komo ekelameheno, ama꞉tamo bada komote na꞉ka꞉puluhukumini? Iyo, ebete mahigate amia꞉no modoboha꞉ komokomo komodobuilamema꞉ne, huiyatiya ebete ama꞉tamo baa꞉ ba ikame ama꞉ ebeno mabulubima꞉ a꞉kagaa꞉mene, mabu ebegodolo kalakala puliyala. Ba꞉bema꞉ mabu keka꞉ ebete ama꞉tamo owalubi dihatemene? Mabu ama꞉ toetoedawagodolo hilopote kitanaha꞉, ebete ama꞉ ba꞉be mabu kapiyama꞉ kowalubima꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ba꞉bene ba꞉be taboeno ipuwa ba hawakalimi Ya꞉suti na꞉goiya꞉, “Nale la꞉tamo goemo, la꞉ Godoko na꞉toemehala꞉, ebete la꞉tamo kikalamema꞉na꞉ta. Iyo, la꞉ ebeno hido komo nohowada꞉la꞉, la꞉le kumima꞉nemata, ba꞉gala la꞉ gigiho nanakama꞉la꞉, ebete la꞉tamo ka꞉hiya꞉midama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Numa꞉la꞉, puya꞉te Godoko da꞉toemehonaka iba꞉te ebegodone kolawema꞉na꞉, ba꞉gala puya꞉te ebeno hido komo dohowadinaka iba꞉te kumima꞉na꞉, ba꞉gala puya꞉te gigiho danakaminaka ebete iba꞉tamo ka꞉hiya꞉midama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","La꞉ ipuwalo kebe dubu ebeno guduti ebe dahama꞉ da꞉toemehomene, huiyatiya ebetamo bu kalu ba꞉kikamemene? ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ba꞉gala amia꞉no guduti ama꞉ kakaba kikipoma꞉ da꞉toemehomena꞉, ama꞉ huiyatiya ebetamo iwawa ba꞉kikameomena꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Numa꞉la꞉, la꞉ hidohido tawakalubiha꞉ huiyatiya la꞉ iya꞉tawahala la꞉eno guguda꞉tamo hidohido baa꞉ ikalamema꞉, ba꞉bema꞉ la꞉eno Hunu Haboeno Nabiwiti atumu iya꞉tawanomola ebeno Hido-talona Gobogobo tawakaluba꞉tamo ikalamema꞉, puya꞉te ebe da꞉toemehonaka iba꞉tamo kikalamema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ba꞉ba tetelo tabo olamagiha꞉ kuba gobogobagoeno dubuti ba꞉bolo na꞉lutiya꞉, ba꞉bene Ya꞉suti ebegodone kuba gobogobo doemiya꞉ ebete tabo olamagi ba꞉bo tupuimiya꞉. Ba꞉bema꞉ komo tawakalubi hiliyonomate Ya꞉sukunu komoma꞉ ba hanohanohuta, ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","huiyatiya komopa꞉te na꞉ga꞉lutiya꞉, “Biyesibulukunu helote ebegodolo bitana. Ebete kubakuba gobogoboeno Kodawoeno heloamo oelamenako, Godokono heloamoha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ba꞉ba tetelo komopa꞉te ubi bihatiya꞉ Ya꞉suku kuba gabamo emogabuimima꞉, ba꞉bema꞉ iba꞉te ebe na꞉ga꞉lamiya꞉, “Ama꞉godolo Godokono helo hibilo ditana, eta hanohano komo nododa꞉ ba꞉be komo atamo kohawakalimima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ba꞉bema꞉ Ya꞉suti ibino kuba ukui iya꞉tawate iba꞉tamo na꞉goiya꞉, “Numa꞉la꞉, haba kapiya tawakaluba꞉te tetedo dadikanalemena꞉ ba꞉be habate kokubama꞉ne, ba꞉gala genama kapiya tawakaluba꞉te tetedo dadikanalemena꞉ ibino genamate hopamo kokagama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ba꞉bema꞉ Saitanakono ukui ba꞉ma ka꞉nala, ebete ebeno kubakuba gobogobo tawakaluba꞉godone a꞉koelama꞉le, mabu ebete ba꞉ba ka꞉na dewagelemene ebeno oko owati helote kowiboma꞉ne. La꞉le naeno komoma꞉ na꞉ga꞉lamata, ‘Ebete kubakuba gobogobo Biyesibulukunu heloamo oelamenako.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ba꞉be tabo da꞉ga꞉lama hibila꞉ka꞉? Ao, hibiha꞉. La꞉eno kapiyuimipa꞉te kubakuba gobogobo doelamenaka, ba꞉be helo iba꞉tamo pote kikalamenako? Ba꞉ Godotela, Saitanateha꞉! Ba꞉bema꞉ ba꞉bi la꞉eno kapiyuimipino hido ododi komote la꞉eno kuba ukui behawakalimina. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ba꞉moe komo ba꞉ hibila, nale kubakuba gobogobo Godokono heloamo tawakaluba꞉godone oelamenakomo, ba꞉bema꞉ wadiyala la꞉ ba꞉moe komone kiya꞉tawahama꞉nemata, Godokono Ko Gawadubu tetete la꞉tamo ba꞉ a꞉pe. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Numa꞉la꞉, Saitanako ba꞉ eta helo dubu keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala, ba꞉gala ebete pilolo duwatiya꞉ ba꞉bi tawakalubi ba꞉ ebeno genamoeno ilinala. Ba꞉bema꞉ keba tetelo helo dubuti ebeno alaholohoeno ilina uwatete ebe ha꞉kiya ebeno genama hidamo da꞉lawamenamene, genamoeno ilinate hidamo kopola꞉nama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Huiyatiya eta dubu ebeno helote dopo dubuino helo da꞉gogolona, ba꞉be dubuti pete alaholo komo ba pododi dopo dubu kopanagalimihoma꞉ne. Ba꞉bene ebete ba꞉be dubuino alaholoho ilina ba꞉gala genamoeno ilina uwatemete ebeno mabuluba꞉tamo konalabahalamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ba꞉ hibila, kebe lumagiti na owalubinihino ebete naeno alaholodawama꞉ eda꞉na, ba꞉ma ka꞉na ebete tawakalubi kapiya baha꞉mo magahelema꞉ nago oko owatihino huiyatiya ibi hiya꞉hiya꞉ oelamenako.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Kuba gobogobote eta lumagigodone duluhukumini, ba꞉ba tetelo ebete gagale hopamo tote eta emede bahi kohowadinatoma꞉ne. Huiyatiya ebete hido emede bahi numihino ebe ha꞉kiya ebetamo kogoema꞉ne, ‘Nale da꞉miya꞉puimo ba꞉be atu emede baha꞉mo gala kakatoma꞉nemo.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ebete gala kapete ba꞉be emede genama hidamo moda꞉midala ba꞉gala ilina hidamo miya꞉tela, ebete ba꞉be genama ba꞉ba ka꞉na da꞉kapumimini, ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ba꞉bene ebete gala katote komo sa꞉ba꞉ni kuba gobogobo kanadabuiliti kakamagahelema꞉ne, iba꞉te ba꞉be genamamo a꞉pa꞉la꞉hate ba꞉bolo kemedehonama꞉. Numa꞉la꞉, galane da꞉pelamemena꞉ ba꞉bi kuba gobogobate koko kuba ba꞉pododilinakomena꞉, dopamo demedenami ba꞉be kapiya kuba gobogoboeno emede huiyaha꞉. O ba꞉be lumagi niliya! Ebe dopamo nanekela꞉mo kubadopola, huiyatiya ba꞉ma tetelo ebete ba꞉ kubanomoma꞉ eda꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ya꞉suti ba꞉moe tabo ba olamagita, tawakalubi ipuwalo eta kamenate ebetamo ibulunomo na꞉goiya꞉, “Ama꞉ dalahimiya꞉la ba꞉gala nono ama꞉tamo dikamiya꞉la, ba꞉be kamenoeno kalakala bada konomola꞉ka꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Huiyatiya Ya꞉suti na꞉goiya꞉, “Wadiyala ama꞉ eta hibi komo nemalagidola. Puya꞉te Godokono tabo uliti ebetamo da꞉papamila꞉hamena꞉, ebeno hibi kalakalate ba꞉bi tawakalubi kapiyagodolo bitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hiliyonomo tawakaluba꞉te Ya꞉suku a꞉ga꞉diya꞉midate ba la꞉mota꞉hana ebete iba꞉tamo na꞉goiya꞉, “Ba꞉ma tete tawakalubi kubakubanomola! Iba꞉te ubi konomola Godokono helo hawakalimino hanohano komo kumima꞉, huiyatiya Godote eta komo iba꞉tamo a꞉kahawakalima꞉mene. Ba꞉ hibila, ebete ebeno ukui hawakalimidawa Yaonako ipuwado da꞉hawakalimiya꞉, ba꞉be hanohano komo kapiya iba꞉tamo ikalamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iyo, Godote Yaonakono emede komodo Niniba ko habanapa꞉tamo ebeno helo a꞉hawakalimiya꞉, ba꞉bene ebete atumu Tawakalubino Naniwi ipuwado ebeno helo gala kakahawakalimima꞉ne ba꞉ma tetelo demedehona ba꞉bi tawakaluba꞉tamo, huiyatiya eta hanohano komo iba꞉tamo a꞉kododa꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Ba꞉gala eta komo. Godote tawakalubino komo danagilamelelamemene, ba꞉be Ko Hegelalo Siba hoponapi Ko Gawa Kamenate mahigate la꞉ Yu tawakalubi kubapima꞉ koka꞉lamima꞉na꞉ta, mabu ba꞉be Yuha꞉ kamenate muhulu hoponomone piya꞉ Isalaela hopamo Ko Gawadubu Solomonokono mulu tabo kopulihoma꞉. Ba꞉ba tetelo ebe ubila Godokono mulu Solomonogodone lawe, huiyatiya la꞉ tetelo Godote Tawakalubino Naniwino komo la꞉tamo ba hawakalimina, la꞉ ba꞉be komo ubihinola. La꞉ numa꞉la꞉, Tawakalubino Naniwino muluti Solomonokono mulu na꞉gogolona! ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ba꞉gala Godokono Ko Hegelalo Niniba habanapa꞉te mahila꞉halete la꞉ atumu kubapima꞉ koka꞉lamima꞉na꞉ta, mabu ba꞉bi Yuha꞉ tawakaluba꞉te Yaonakono tabo duliya꞉ iba꞉te ibino kubane Godotamo ohobiliya꞉. Ba꞉ba tetelo ibi ubila Godokono tabo Yaonagodone lawe, huiyatiya la꞉ tetelo Godote Tawakalubino Naniwino komo la꞉tamo ba hawakalimina, la꞉ ba꞉be komo ubihinola. La꞉ numa꞉la꞉, Tawakalubino Naniwino helote Yaonakono helo na꞉gogolona!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Lumagiti ebeno wuiki alo pa꞉titi awamina baha꞉mo a꞉kihata꞉mene, ba꞉gala ebete bagolo ipuwamo a꞉kihata꞉mene, huiyatiya ebete hawakala baha꞉mo kihatema꞉ne, ba꞉bene tawakaluba꞉te ebeno genama guamo da꞉nalehawaminamena꞉ iba꞉te ba꞉be hido alo ba꞉bo konumima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Amia꞉no apeno alo ba꞉ amia꞉no baidila. Ba꞉bema꞉ amia꞉no baiditi hidamo da꞉la꞉minalemene amia꞉no tepo ipuwoeno alote atumu hidonomamo kaka꞉la꞉minama꞉ne, huiyatiya baiditi hidamo a꞉la꞉minaleheno amia꞉no ape konomote du ipuwalo kitanama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ba꞉bema꞉ ama꞉ hidamo, amia꞉no tepo ipuwoeno alote duma꞉ akeda꞉la꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Amia꞉no ape konomote alo ipuwalo ditanamene ba꞉gala amia꞉no ape hapu du ipuwalo itanaheno, ba꞉ba tetelo ama꞉ konomamo ka꞉la꞉minama꞉na꞉ta, hido wuiki alote ama꞉ da꞉la꞉minana ba꞉ba ka꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ya꞉sukunu tabo olamagi da꞉wibuya꞉ eta Pa꞉lisi kapiyuimi dubuti ebe na꞉goemiya꞉ ebete ebegodolo baa꞉ kopenama꞉, ba꞉bene Ya꞉suti ba꞉be dubuino genamamo nodolote baa꞉ nama꞉ dito nemediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Huiyatiya Ya꞉suti ebeno kokoto ukulahaheno baa꞉ nama꞉ da꞉nemediya꞉, ba꞉bema꞉ ba꞉be Pa꞉lisi kapiyuimi dubuti koamo la꞉wiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ba꞉bene Ya꞉suti ebe na꞉goemiya꞉, “La꞉ Pa꞉lisi kapiyuimipi la꞉eno kalili ba꞉gala meleke hunu hapu bukulalenakomata, huiyatiya la꞉eno tepo ipuwalo da꞉pola꞉na ba꞉bi ilina a꞉kukulala꞉lemata, ba꞉bema꞉ la꞉le dododilinakoma ba꞉bi pilo komo ba꞉gala komo koko kuba ododili komokomo tabotabohonomola! ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","A꞉iye, la꞉ daedae tawakalubilata! Godote lumagino hunu tama ododiti ba꞉gala ipuwa aka-ododiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ba꞉bema꞉ wadiyala la꞉eno melekelo ba꞉gala kalililo bada ilinate ka꞉pola꞉na, la꞉ ilinaha꞉pa꞉tamo dito nikalamehola꞉la꞉! Iyo, ba꞉be komo ipuwado la꞉le la꞉eno tepo ipuwoeno kuba kukulalema꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ba꞉ hibila, la꞉ Pa꞉lisi kapiyuimipi kuba huiya konomo kolawema꞉nemata! La꞉ la꞉eno pali ilina hiliyonomo ipuwalo ta꞉ni komokomo ba anagilamehole Godotamo ebeno komo hidamo ikamehonakomata. Ba꞉be komo ipuwalo la꞉ kapiya deha꞉potonomo komo a꞉kotalemata, huiyatiya komo kokonomo komo ododilima꞉ la꞉ hidamo kemalagidolenaha꞉, ba꞉ma ka꞉na la꞉ tawakaluba꞉godolo tuputupulu kemedenaha꞉ ba꞉gala Godokono malemale kahawakaliminaha꞉. Ba꞉bema꞉ wadiyala la꞉ ba꞉bi koko komo nododilinala꞉ ba꞉gala atu tetelo hegehege komo ododili akadodohola꞉la꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ba꞉ hibila, la꞉ Pa꞉lisi kapiyuimipa꞉te kuba huiya konomo kolawema꞉nemata, mabu baidi ibubulamehole genama gulu la꞉ ubila koko dubuino habalo ahidi, ba꞉gala la꞉ ubila la꞉le ilina kolowami habalo ba wapata꞉lame tawakaluba꞉te la꞉ ulamete ba꞉bo kawagaminalema꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ba꞉ hibila, la꞉tamo da꞉puluhukumini ba꞉be kuba huiyate konomoma꞉ keda꞉ma꞉ne, mabu la꞉ tawakalubino ha꞉laha ape awaminale bobo huiyalata! Ba꞉ma ka꞉na tawakaluba꞉te iya꞉tawahaha꞉ ababale ilinate da꞉pola꞉na, ba꞉bema꞉ iba꞉te iya꞉tawahaheno ba꞉bana wapata꞉lamena.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ba꞉bene eta Godokono Tutumu iya꞉tulamedawate Ya꞉sutamo na꞉goiya꞉, “Iya꞉tulamedawa, ama꞉ Pa꞉lisi kapiyuimipi tabamo da꞉kubahilama꞉, ama꞉ ba꞉be tabamo a atumu a꞉ka-iduduputia꞉ma꞉ta!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ya꞉suti ba huiya na꞉goiya꞉, “Iyo, la꞉ Godokono Tutumu iya꞉tulamepi, la꞉ ba꞉ atumu kuba huiya konomo kolawema꞉nemata, mabu la꞉ la꞉eno tutumu tabamo tawakaluba꞉tamo menemene komokomo bikalamenakomata! Iyo, la꞉eno tutumu tabo ba꞉ tawakaluba꞉te menemene ilina okamo da꞉wagalatelena ba꞉ba ka꞉nala, ba꞉bema꞉ la꞉le ibino menemene dulamenakoma eta owalubi deha꞉potonomo a꞉kihata꞉lemata, kokoto makupuhuliti dito la꞉mota꞉hananakomata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Ba꞉ hibila, la꞉tamo da꞉puluhukumini ba꞉be kuba huiyate konomoma꞉ keda꞉ma꞉ne, mabu la꞉eno iniwala꞉te Godokono ukui hawakalimipi hibilo anakapulamenakuya꞉, huiyatiya ka꞉lo la꞉ la꞉eno iniwalino ododili komokomo kubama꞉ ga꞉laheno ibi a꞉mililameholenakomata. A꞉iye! Ba꞉be mabuma꞉ ibino kubate la꞉ ipuwalo atumu ba꞉ka-itana, huiyatiya la꞉ ba꞉be kuba ugumuilo la꞉eno iniwala꞉te danakapulamenakui ba꞉bi tuputupupino bobo bahi hidonomamo ododilinakomata. Ba꞉bema꞉ numa꞉la꞉, ba꞉be komote la꞉eno ma꞉lapila netewa komo behawakalimina, mabu la꞉eno tepo ipuwalo atu kuba ododili ubi ba꞉kapola꞉na Godokono hibi okopa꞉tamo! ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ba꞉be mabuma꞉ Godokono Mulu Tabote ba꞉ma ka꞉na goena, ‘Nale tawakaluba꞉tamo naeno ukui hawakalimipi ba꞉gala naeno komo oelamepi konoelamema꞉nemo, huiyatiya iba꞉te ba꞉bi okopi ubihinola, ba꞉bene iba꞉te komo ibi ba anakapulame komopa꞉tamo temeteme bikalamenakomena꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ba꞉bema꞉ ba꞉ma tete tawakaluba꞉te kuba huiya kolawema꞉na꞉, mabu ba꞉moe hopoeno tupuimi mabuni iba꞉te Godokono ukui hawakalimipi anakapulamenakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Iyo, A꞉ibolokono hawiti hakamo da꞉ka꞉ka꞉liya꞉, ba꞉be komo ba꞉ tupuimi mabula. Ba꞉bene iba꞉te komo tuputupu okopi hiliyonomo anakapulamete, kuititi tetelo Godoko Adikumino Genamalo Sekalayako ba꞉bo kanakapumiya꞉, iyo, ebete ba꞉be Genamoeno Talona Haba ba꞉gala Godotamo hawa꞉goeno ikameho bahi tetenomolo ba la꞉na, iba꞉te ebe danagalimiya꞉ ebete ba꞉ dito hoiya꞉. Ba꞉bema꞉ na la꞉tamo hibi tabonomo begoemo, ba꞉ma tete tawakaluba꞉te ba꞉bi hiliyonomo kuba mabuma꞉ huiya hibilo kolawema꞉na꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ba꞉ hibila, la꞉ Godokono Tutumu iya꞉tulamepi, la꞉eno kuba huiyate konomoma꞉ keda꞉ma꞉ne, mabu la꞉le tawakalubino gabo bekalapilalamenamata iba꞉te Godogodone iya꞉tawa kolawema꞉! La꞉ ha꞉kiya ebeno hido komo lawe ubihinola, ba꞉bema꞉ puya꞉te ubi dihatena huiyatiya la꞉le ibi atumu na꞉kaduhilamenamata!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ba꞉bene Ya꞉suti ba꞉be genamane da꞉pihitiguya꞉, ba꞉ba tetelo Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi iba꞉te konomamo maubahate Ya꞉sukunu komoma꞉ tabo kubanomamo ga꞉la ba꞉bo tupuimiya꞉. Ba꞉gala ba꞉ba tetene tupuimiti iba꞉te Ya꞉sutamo da꞉pelamenakui hiya꞉hiya꞉ komo ba꞉bo pikiyahamenakuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","mabu ibi ubila ebe kuba gabamo ba emogabuimi ebete hiya꞉ tabo kubamo goelo ebe ba꞉bo kolawema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Eta tetelo tawakalubi hiliyonomate Ya꞉suku umima꞉ da꞉kapiyuimiya꞉ iba꞉te emokatihuia꞉go pelamitiya꞉, etate eta emokamidanakui, etate eta emokamidanakui, ba꞉ba ka꞉na ewagelitiya꞉. Ba꞉ba tetelo Ya꞉suti ebe ta꞉matapi na꞉goelamiya꞉, “La꞉ hidamo! Palawa baa꞉te ha꞉kiya hunamo da꞉mahiga, Pa꞉lisi kapiyuimipino awagaha komo ba꞉ba ka꞉nala. Ba꞉bema꞉ ba꞉mako awagaha komote la꞉tamo akuluhukala꞉, mabu ba꞉be awaga komo ba꞉ ibino ma꞉lapila netewa komola. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Numa꞉la꞉, kebe ihilatehole komate da꞉pola꞉na galane tetelo Godote kohawakalilamema꞉ne, ba꞉gala awalelahale komate da꞉pola꞉na galane tawakaluba꞉te kulameholema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ba꞉bene la꞉le du tetelo dolamagiminakoma, tawakaluba꞉te huiyatiya alo tetelo kulihoma꞉na꞉, ba꞉gala genama gulu la꞉le ganalo da꞉ga꞉lanakoma, ba꞉bi komokomoma꞉ iba꞉te tabo madodo ba adipate tawakalubi hiliyonomatamo kohawakalilamema꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Naeno mabuluba꞉la꞉, nale la꞉tamo goemo, ape anakapulame iya꞉tawahapi akatolelama꞉la꞉. Iba꞉te la꞉ danakapulamemena꞉, iba꞉godolo eta helote a꞉kitanamene la꞉eno gobogoboeno ka꞉ka꞉ kubahilamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ba꞉bema꞉ la꞉ poko na꞉ka꞉tolemeonama? Ebe ba꞉ Godotela, la꞉ ebe kapiya na꞉tolemenala꞉, mabu ebegodolo helo bitana tawakalubi anakapulamete Koe Habamo iya꞉hekema꞉. Iyo, na hibi tabo begoemo, ebe kapiya na꞉tolemenala꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Numa꞉la꞉, tawakaluba꞉te paibo de holahola netewa toea mana꞉mo uwatema꞉ ga꞉lanaka, ba꞉bi holaholoeno ka꞉ka꞉ kokoha꞉, huiyatiya Godote ba꞉bako deha꞉poto hola kapiya a꞉kadodamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ba꞉gala ba꞉moe komo ba꞉ hibila, la꞉eno watoeno hinibo hiliyonomo Godote ya꞉lo tetelo a꞉ka꞉lamiholiya꞉, iyo, la꞉eno hiya꞉hiya꞉ komo ebete iya꞉tawanomola. Ba꞉bema꞉ la꞉ ukui bilibilima꞉ akeda꞉hala꞉. Ebeno malemale holaholatamo hibilo bitana, huiyatiya ebeno malemale la꞉tamo konomoma꞉ eda꞉te emedena tetelo bitanamene!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Nale la꞉ begoelamemata, kebe lumagiti hawakala da꞉goemene, ‘Na Ya꞉suku ta꞉matadawala,’ na Tawakalubino Naniwiti ba꞉ atumu Godokono nopopino holoholo hapulu kogoema꞉nemo, ‘Ba꞉moe lumagi ba꞉ naeno ekawila.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Huiyatiya kebe lumagiti na iya꞉tawaha꞉ma꞉ da꞉goemene, na ba꞉ atumu Godokono nopopa꞉tamo ebe iya꞉tawaha꞉ma꞉ kakagoema꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ba꞉gala kebe lumagiti Tawakalubino Naniwino komoma꞉ duhimi tabo dolamagimini, Godote ebeno kuba egeboleme iya꞉tawala, huiyatiya kebe lumagiti Godokono Gobogoboeno ododi komoma꞉ kubama꞉ da꞉goemene, Godote ba꞉be kuba egebolemete a꞉kadodoma꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ba꞉bema꞉ iba꞉te la꞉eno komo kanagilamelelamema꞉ Yu tawakalubino baidi ibubulamehole genamamo la꞉ da꞉magatalemena꞉, ba꞉ba tetelo la꞉le gabomani dubu ba꞉gala komo koko dubu iba꞉tamo kebako tabo ga꞉lama꞉ ukui bilibilima꞉ akeda꞉hala꞉, ba꞉ma ka꞉na, ‘Na kebe tabo na꞉ka꞉goemo? Ba꞉gala na iba꞉tamo tabo keba ka꞉na na꞉ka꞉huiyamo?’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Numa꞉la꞉, Godokono Gobogobote ba꞉ba tetenomolo la꞉le iba꞉tamo dolamagimima ba꞉be tabo la꞉ kiya꞉tulamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ba꞉bene tawakalubi hiliyonomate Ya꞉sukuba꞉ da꞉pola꞉nuya꞉, eta lumagiti ibi ipuwalo ebetamo na꞉goiya꞉, “Iya꞉tulamedawa, naeno naniwi na꞉kiyama꞉, aeno nabiwiti atamo da꞉miya꞉palea꞉mi ba꞉bi dogodogo ilina ebete hidamo nalabala꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ya꞉suti ebetamo na꞉huiyuya꞉, “Dubu, ama꞉ pote ka꞉kiyamiti nale la꞉eno komo anagiya꞉midadawama꞉ keda꞉ma꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ba꞉bene ebete tawakalubi hiliyonomatamo na꞉goiya꞉, “La꞉ hidamo! Ilina uwate ubi komote la꞉tamo akuluhukala꞉, mabu lumagiti hiliyonomo ilina ba uwate hibi ka꞉ka꞉ ebo a꞉kuma꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ba꞉bene Ya꞉suti eta iya꞉tulame uwi iba꞉tamo ba꞉ma ka꞉na olamagiya꞉, “Eta ilina dogodogodawate nemedenami, ebeno hakalo pali ilinate konomamo apepehonama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ba꞉bene ebe ha꞉kiya ebeno ukuilo na꞉goi, ‘Naeno pali ilina miya꞉teno genama modobolo kapola꞉naha꞉, ba꞉bema꞉ na bada komo na꞉kododimo? ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ehe! Na ba꞉ma ka꞉na kododima꞉nemo. Nale naeno pali ilina miya꞉teno genama anabulilamete uliuli koko genama gala kaketemotema꞉nemo, ba꞉bene ba꞉bi genama ipuwamo naeno pali ilina ba꞉gala komo koko ilina komiya꞉tema꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ba꞉ba tetelo nale naeno tepo ipuwalo kogoema꞉nemo, ‘Na konomo dubula! Na koko ilina hidonomamo a꞉miya꞉timo, ba꞉bema꞉ na komo hiliyonomo gogolo kodakoda oko owatihino, na baa꞉ kana, helo gao beya kani, ba꞉ba ka꞉na kalakalago dito bemedenamo!’ ’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Huiyatiya Godote ebetamo na꞉goi, ‘Ama꞉ daedae lumagilata! Ka꞉lo dulu nale amia꞉no ka꞉ka꞉ kolawemema꞉nemata, ba꞉bene ama꞉ ha꞉kiya amia꞉no komoma꞉ da꞉miya꞉tenama꞉ ba꞉bi ilina hiliyonomo pote na꞉kuwatemene?’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ba꞉bema꞉ Ya꞉suti ebeno kuititi tabo ba꞉ma ka꞉na goiya꞉, “Lumagi ha꞉kiya ebeno komoma꞉ ilina ba dogodoguilame huiyatiya ebeno tepo ipuwamo Godokono hidohido komo miya꞉teheno, ebe ba꞉ ba꞉bako daedae dawala.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goiya꞉, “Nale la꞉ begoelamemata, la꞉eno emedeho komokomoma꞉ aka-ukuibilibilihonala꞉, iyo, la꞉le naha ilina ba꞉gala pupulino ilina uwatema꞉ koamo akemalagidola꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Numa꞉la꞉, naha ilina ba꞉gala pupulino ilina iba꞉te kokoma꞉ keda꞉hanaha꞉, mabu naha ilinate lumagitamo hibi ka꞉ka꞉ a꞉kikama꞉mene, ba꞉gala pupulino ilinate atumu ebeno ape emedena tetelo a꞉kowalubinamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ba꞉bema꞉ la꞉ owa holaholoeno komo nemalagidolala꞉, iba꞉te pali ilina a꞉kamihala꞉ ba꞉gala iba꞉te pelamete nahoeno kikipo a꞉kapetapihala꞉, iyo, ibino pali ilina miya꞉teno genama puliyala, huiyatiya Godote iba꞉tamo baa꞉ modobolo ikalamenako. Numa꞉la꞉, Godokono malemale hibilo bitana holaholatamo, huiyatiya ebeno malemale la꞉tamo konomoma꞉ eda꞉te emedena emedena tetelo bitanamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ba꞉bema꞉ la꞉ ukui bilibilima꞉ akeda꞉hala꞉. Lumagi ebe ha꞉kiya ebeno hoe tete eta hegelamo keba ka꞉na na꞉kihatemene, ba꞉gala ebete ebeno ka꞉ka꞉ keba ka꞉na na꞉ka꞉ga꞉gima꞉tepamene? Gabo puliyala, kitanaha꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Numa꞉la꞉, la꞉ la꞉eno ka꞉ka꞉ tete nanekela꞉mo ga꞉gilama꞉tepale modoboha꞉, ba꞉bema꞉ mabu keka꞉ la꞉ komo komokomoma꞉ dukuibilibilihonama? ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“La꞉ hopoeno haiyaino komo nemalagidolala꞉, iba꞉te oko a꞉kowata꞉la꞉ ba꞉gala pupulino ilina a꞉kododila꞉la꞉. Nale la꞉ begoelamemata, Ko Gawadubu Solomonote ilina dogodogodawanomoma꞉ eda꞉nami, huiyatiya ebete hidohido tita꞉goeno ilina da꞉pupulinakui, ba꞉bi kalikoeno titi ba꞉moe hopoeno haiyaino hido komote na꞉gogolena. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Numa꞉la꞉, ba꞉moe hopoeno hemate ka꞉lo napepehuta, dumutu tawakaluba꞉te koa꞉mo kiya꞉hekema꞉na꞉, huiyatiya Godote ba꞉bi nonoka ilina tita꞉goenoma꞉ midilina, ba꞉bema꞉ ebete atumu la꞉tamo pupulino ilina modobolo bikalamenakomena꞉ta. La꞉ ba꞉moe komo hidamo iya꞉tawahaheno la꞉eno hibima꞉ midi komo Godotamo kokoha꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ba꞉bema꞉ naha ilina ba꞉gala beya niho komo konomamo akemalagidolenala꞉, ba꞉gala ukui bilibilima꞉ akeda꞉hanala꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ba꞉moe hopo konomolo tawakaluba꞉te ba꞉moi ilina ukui bilibila꞉go oholena, la꞉ huiyatiya eba ka꞉na akewagelenala꞉, mabu ba꞉bi ilina la꞉godolo modobolo pola꞉naheno, la꞉eno Nabiwiti ya꞉lo iya꞉tawanako. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ba꞉bema꞉ la꞉ Godote Ko Gawadubuma꞉ deda꞉na ba꞉be komo dopamo nohowada꞉la꞉, ba꞉bene la꞉eno modoboha꞉ tetelo ebete la꞉eno komokomo ulamelelamete la꞉tamo modobolo bikalameholenakomena꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉ naeno sipi-goegoe kapiyuimi deha꞉potolata, ba꞉bema꞉ la꞉ akatoletolehala꞉! Godote Ko Gawadubuma꞉ deda꞉na ba꞉be hido komo la꞉eno Nabiwiti ubila la꞉tamo ikalame. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ba꞉bema꞉ la꞉ tolamete la꞉eno ilina hiliyonomo nekolowamiholete awaepa꞉tamo mani na꞉nikalamehola꞉la꞉, iyo, la꞉ ba꞉be gabodo wiboha꞉ mani kuiha nododila꞉la꞉, ba꞉ma ka꞉na la꞉eno hidohido ilinate Godokono Hunu Habalo ba꞉nepola꞉lama꞉namena꞉ta. Ba꞉bi ilinate ba꞉bolo a꞉kawibohamena꞉, iyo, pilo tawakaluba꞉te a꞉kuwata꞉mena꞉ ba꞉gala unawa꞉te a꞉kanala꞉mena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","La꞉ hidamo! La꞉eno ilinate kebolo da꞉pola꞉namena꞉ la꞉eno tepo ipuwoeno ukui atumu ba꞉bolo konepola꞉nama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉ hidamo! Diyala, eta komote la꞉tamo da꞉ pemene, ba꞉bema꞉ la꞉eno kaliko pupuliti na꞉hidala꞉ ba꞉gala alo na꞉pa꞉tihala꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Iyo, ko dubuino okopa꞉te ebeno pe komo uliholo keba ka꞉na ka꞉latimina, wadiyala la꞉ ba꞉ ba꞉ba ka꞉na nemedeniya꞉la꞉. Numa꞉la꞉, ba꞉be ko dubuti uli kamenago kapiyama꞉ eda꞉te poko habane da꞉pemene, ebeno okopa꞉te ebeno pe komo dulimina꞉ gigiho kalakalago ebetamo dito ka꞉hiya꞉midamema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ba꞉bene ko dubuti da꞉pemene ibino kalakala konomoma꞉ keda꞉ma꞉ne, mabu iba꞉te ebetamo uliholo ba emedena ebete ibi ba꞉bo pulame. Nale la꞉ begoelamemata, ebete ibino hido komo pulamelelamete ebete ebeno atuino kaliko pepekanate ebe ha꞉kiya iba꞉tamo huiyaha꞉ okodawama꞉ ba pimidi, okopa꞉te gagahiditi ebete iba꞉tamo hido baa꞉ ba꞉bo kopikalamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Diyala, ko dubuti iwa tetelo da꞉ pemene o owaloho hapuamo da꞉ puluhukumini, ba꞉bema꞉ okopa꞉te ebetamo ba ulihona, ebete iba꞉tamo da꞉pemene iba꞉te koamo kokalakalahama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ba꞉gala ba꞉moe eta komo na꞉kemalagidolala꞉. Genama namutudawate pilo lumagino pe tete diya꞉tawamene ebete ba꞉ba teta꞉mo kulihonama꞉ne, mabu ebe ubihinola pilo dawate ebeno genamamo popegama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ba꞉bema꞉ la꞉ atumu na꞉hidala꞉, mabu diyala, la꞉ ulihoheno ba emedena Tawakalubino Naniwiti ba꞉bo da꞉ pemene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ba꞉bema꞉ Pitate Ya꞉sutamo na꞉goiya꞉, “Kodawa, ama꞉ ba꞉moe iya꞉tulame uwi a kapiyatamo ka꞉gaa꞉wa o hiliyonomo tawakaluba꞉tamola꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Huiyatiya Kodawa Ya꞉suti na꞉goiya꞉, “Namutudawatamo da꞉papamiwatanako ba꞉be mulu okodawoeno komo keba ka꞉nala꞉ka꞉? Ba꞉ hibila, oko namutudawate ebe lawete komo okopi ulamedawama꞉ kihatema꞉ne, ba꞉ma ka꞉na ebete ibino baa꞉ naha tetelo iba꞉tamo modobolo kikalameholema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ba꞉bene ba꞉be muludawate oko hidamo ba owatina, ebeno namutudawate pete ebeno komo da꞉pumimini, ba꞉be okodawate koamo kokalakalama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na la꞉tamo hibi tabo begoemo, namutudawate ba꞉be mulu okodawoeno komoma꞉ ba pekalakala, ebete ebe ebeno ilina hiliyonomo ulamedawama꞉ kihatema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Huiyatiya ba꞉be okodawate kuba ukui lawete ebeno tepo ipuwalo ba꞉ma ka꞉na da꞉goemene, ‘Naeno oko namutudawate tete ga꞉ga꞉dopolo nemedena, tiyolo kapenaha꞉,’ ba꞉ba tetelo ebete oko owatihino ebeno namutudawoeno baa꞉ koamo nate helo gao beya ba꞉bo konima꞉ne, ba꞉bema꞉ ebete daedaema꞉ eda꞉te komo okopi dubu ba꞉gala kamenakamena alukuli ba꞉bo kotupuimima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ba꞉bene ba꞉be daedae okodawate ulihoheno ba emedena ebeno namutudawoeno pe komo a꞉kiya꞉tawamene. Ba꞉ba tetelo namutudawate pete daedae okodawa koamo panagalimihote komo kuba ododilipa꞉go konoemema꞉ne ebeno kuba huiya konelawema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ba꞉ hibila, kebe okodawate ebeno namutudawoeno ubi komo iya꞉tawate huiyatiya hido komo ododihino, namutudawate ebe kukamo kopanagalimihoma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Huiyatiya eta okodawate ebeno namutudawoeno ubi komo iya꞉tawaheno ebete eta kuba ebetamo dododimini, namutudawate ba꞉be kuba mabuma꞉ huiya kopikamema꞉ne huiyatiya koamo a꞉kapanagalimihamene. Numa꞉la꞉, tawakaluba꞉te eta lumagitamo hidohido ilina dikamehomena꞉ iba꞉te konomamo gala uwatemema꞉ kakaga꞉lama꞉na꞉. Ba꞉ ba꞉ba ka꞉na Godote kebe lumagitamo hidohido komo hiliyodopo dikamehomene, ebete ba꞉be lumagino emede ipuwalo atu hidohido komo ba꞉koholemenakomene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Na hopo habanapa꞉tamo Godokono koe badahiya꞉mo, iyo, ibino kuba huiya mabuma꞉ na ubila Godote ba꞉moe hopo tiyolo kemadomema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Huiyatiya numa꞉la꞉, Godoko ubila ebete na hoe ipuwamo kadunatenema꞉, ba꞉bema꞉ ba꞉be komote peheno nale dopamo hopo habanapino kuba mabuma꞉ eta huiya iba꞉tamo a꞉kikalama꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","La꞉ na꞉kemalagidolutama nale ba꞉moe hopamo gelebadi adahema꞉ pe? Ao, na tawakaluba꞉tamo gelebadi ikalamema꞉ kapiya꞉ha꞉, ibi anagiya꞉midalema꞉ piya꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Numa꞉la꞉, naeno tabo komokomoma꞉ anagiya꞉mida komote tawakalubi ipuwalo kuluhukuma꞉ne. Ba꞉bema꞉ ba꞉ma tetene tupuimiti eta genamalo paibo badininipalate da꞉pola꞉namena꞉ ibi teta꞉mo anagiya꞉midalete, netewa-kapiyate netewatamo alaholopima꞉ keda꞉ma꞉na꞉ ba꞉gala netewate netewa-kapiyatamo atumu alaholopima꞉ kakeda꞉ma꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iyo, iba꞉te ba꞉ma ka꞉na kalaholohoma꞉na꞉, naba꞉te ibino kuhia꞉tamo ba꞉gala kuhia꞉te ibino naba꞉tamo, menokoba꞉te ibino bohelemela꞉tamo ba꞉gala bohelemela꞉te ibino menokoba꞉tamo, kamenakamenate ibino awino menokoba꞉tamo ba꞉gala ba꞉bi menokoba꞉te iba꞉tamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ba꞉bene Ya꞉suti hiliyonomo tawakaluba꞉tamo na꞉goiya꞉, “La꞉ hegelate da꞉nihitigana ba꞉ba hapulu bubu odolonalo dumima, la꞉ ba꞉ma ka꞉na koga꞉lama꞉nemata, ‘Wegolate koma꞉ne,’ ba꞉bene ba꞉be komote hibima꞉ keda꞉ma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ba꞉gala eta komo. La꞉ huhu ba꞉gala gogo ibino mauba komo dumima ba꞉ma ka꞉na koga꞉lama꞉nemata, ‘Hegelate koenomoma꞉ keda꞉ma꞉ne,’ ba꞉bene ba꞉be komote hibima꞉ keda꞉ma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Iyo, la꞉ hopo haba ba꞉gala alomo ibino komokomo ulame iya꞉tawahala, huiyatiya ba꞉ma tetelo Godote la꞉ ipuwalo dododilina ba꞉bi komoeno ipuwa la꞉ hidamo badama꞉ kiya꞉tawahanaha꞉? Mabu la꞉ ba꞉ ma꞉lapila netewa tawakalubilata!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ba꞉bene Ya꞉suti ebeno tabo moga꞉melo gala na꞉kagoiya꞉, “Bada mabuma꞉ la꞉ ha꞉kiya la꞉eno komo hidamo kanagilamenaha꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ama꞉tamo da꞉maubana ba꞉be lumagiti ama꞉ gabomani ko dubutamo da꞉magatamena꞉, la꞉ ebetamo nuluhukuhino wadiyala ama꞉ dopamo alaholodawago gelebadima꞉ na꞉nediya꞉la꞉. Ama꞉ ebe gelebadimihino, hibila, ebete ama꞉ ko dubutamo komagatama꞉na꞉ta, ba꞉bene ko dubuti huiyatiya amia꞉no kuba anagiya꞉midamete ama꞉ polisi dubutamo ba noeme, ebete ama꞉ du genama guamo ba꞉bo konihatema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na ama꞉tamo na꞉goemo, ama꞉ du genama gulu ba nemede, gabomani dubuti kebako tete huiyama꞉ ama꞉ da꞉kiyamemena꞉, ama꞉le ba꞉bako huiya modobotenomo modobotete habamo gala kakapema꞉na꞉ta, huiyatiya ama꞉le ba꞉be huiya modoboteheno a꞉kuluhukamena꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ba꞉ba tetelo Ya꞉sukuba꞉ da꞉pola꞉nuya꞉ komo ba꞉bi tawakaluba꞉te ebe bega꞉lamiya꞉ Ga꞉lili hopo tawakalubino komoma꞉, iba꞉te sipi-goegoe alukuliti hawi Godotamo ba ikameho Paeletekono alaholohopa꞉te iba꞉tamo pikuliti ba꞉bo panakapulamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ya꞉suti huiyatiya ba꞉bi tawakaluba꞉tamo na꞉goiya꞉, “La꞉eno ukui kebanala꞉ka꞉? Komo Ga꞉lili hoponapi kubakubadopola꞉ka꞉, huiyatiya Paeletete danakapulami ba꞉bi kapiya kubakubanomola꞉ka꞉? Godote ibi kapiyatamo maubate kuba huiya ba꞉bema꞉ kikalami? ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ao, eba ka꞉naha꞉! Na la꞉tamo na꞉goemo, la꞉ hiliyonomo la꞉eno kubane ohobila꞉heno la꞉ ba꞉ atumu kakaha꞉lahama꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ba꞉gala ba꞉moe eta komo na꞉kemalagidolala꞉, Silomo hununomo genamate kagate 18 tawakalubi danakapulami, ibino komoma꞉ la꞉eno ukui keba ka꞉nala꞉ka꞉? Ba꞉bi da꞉ha꞉lahui ibi kapiyate kubakubanomola꞉ka꞉, huiyatiya komo Yelusalema habanapa꞉te hidohido tawakalubila꞉ka꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ao, eba ka꞉naha꞉! Na la꞉tamo na꞉goemo, la꞉ hiliyonomo la꞉eno kubane ohobila꞉heno la꞉ ba꞉ atumu kakaha꞉lahama꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ba꞉bene Ya꞉suti iba꞉tamo ba꞉moe iya꞉tulame uwi begoiya꞉, “Eta dubuti ebeno pali ipuwamo gao keha bami, ba꞉bene ebete galane gao tapihoma꞉ da꞉pi gao kapulameha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ba꞉bema꞉ ebete pali okodawatamo na꞉goi, ‘Numa꞉, na netewa-kapiya gogolo ba꞉moe kehalo gao doholenamo huiyatiya a꞉kulama꞉lemo. Wadiyala ama꞉ na꞉ta꞉ma꞉, mabu ba꞉moe kehate pali bekubahimina.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Pali okodawate huiyatiya na꞉goi, ‘Kodawa, wadiyala꞉ka꞉ na ba꞉moe kapiya gogolo kuma꞉tepama꞉nemo. Na haka gala kohoba꞉midalete keha mabamo hido haka goegoeno nea꞉go kohaminahalenatema꞉nemo, ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ba꞉bema꞉ diyala, eta gogolo kehate da꞉ nolomene. Wadiyala ale ba꞉ma tetelo komiya꞉pama꞉nema꞉, a꞉kata꞉ma꞉ma꞉, huiyatiya noloheno kota꞉mema꞉nemo.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ba꞉bene eta Yu tawakalubino okoha꞉ talona hegelalo Ya꞉suti ibino baidi ibubulamehole genamalo tawakalubi biya꞉tulamitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ibi ipuwalo eta kamena na꞉lutiya꞉, ebe 18 gogo ipuwalo kuba gobogobote ebetamo dikamiya꞉ ba꞉be temetemete uminami, ba꞉bema꞉ ebete papamiwatane pata꞉nami, buiga hogaminate hidamo uti modobonomoha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ya꞉suti ebe umiti ebe ba ka꞉mi na꞉goiya꞉, “Kamena, ama꞉ duminama꞉ Godote ba꞉be temetemeno hale a꞉pahalamilima꞉ta!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ba꞉bene Ya꞉suti ebetamo kokoto demowatilamiya꞉, ba꞉ba tetenomolo ebete buiga hogaminate hidamo utiti Godotamo kalakala tabo ba꞉bo adipatiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Huiyatiya baidi ibubulamehole genama namutudawate Ya꞉sutamo na꞉maubuya꞉ mabu ebete okoha꞉ talona hegelalo ba꞉be kamena a꞉hiduimiya꞉. Ba꞉bema꞉ ba꞉be dubuti tawakaluba꞉tamo na꞉goiya꞉, “Sikisi hegela ba꞉pola꞉na tawakaluba꞉te oko owatima꞉. La꞉ ba꞉bi sikisi hegelalo na꞉pelama꞉la꞉, ba꞉moe dubuti la꞉eno temeteme komoma꞉ la꞉ kowalubilima꞉, huiyatiya aeno talona hegelaloha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ya꞉suti huiyatiya ebetamo na꞉goiya꞉, “La꞉ ma꞉lapila netewa tawakalubilata! Okoha꞉ talona hegelalo la꞉ la꞉eno kau-goe o donoki-goe ibino hale pepahalamiti beya niho baha꞉mo a꞉magatalenakomata, aba꞉ hibila꞉ka꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Huiyatiya ba꞉moe kamena ba꞉ A꞉ibalahamakono bohele etala. Saitanate ebe 18 gogolo hala꞉mo matuhumihuya꞉, ba꞉bema꞉ Godokono talona hegelalo ale ebe owalubiti ebeno hale da꞉pahalamilimima꞉ ba꞉ hido komola!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ya꞉suti ba꞉be tabo dolamagiya꞉ ba꞉ba tetelo ebe duhimipi hiliyonomate na꞉hilopohutiya꞉, huiyatiya komopi hiliyonomate na꞉kalakalahutiya꞉ mabu Ya꞉suti hiliyonomo komokomo hidonomamo ododilinami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be komo keba ka꞉nala꞉ka꞉? Na ba꞉be komo bada goamo na꞉ka꞉hawakalimimo? ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ba꞉be komo ba꞉ mastada kikipo huiyala. Dubuti amiti, ba꞉be deha꞉poto kikipote apete ko kehama꞉ deda꞉mene, ba꞉ba tetelo holaholate pelamete ba꞉be keha gedawalo ba꞉pemedehonamena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, nale ba꞉be komo bada goamo na꞉ka꞉hawakalimimo? ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ba꞉be komo ba꞉ ba꞉ma ka꞉nala. Eta kamenate modobo palawa lawete huhuimino puhulu ilina nanekele hola꞉minalete ba꞉bo a꞉ba꞉gui, ba꞉bene huhuimino ilinate palawa lawenomo ba lawe palawa baa꞉te hunamo ba꞉bo mahigui.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ba꞉bene Ya꞉suti Yelusalema ko habamo ba to ebete komo koko habahaba ba꞉gala hegehege habahabalo tawakalubi iya꞉tulama꞉go tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ba꞉ba tetelo eta lumagiti ebetamo na꞉goiya꞉, “Kodawa, tawakalubi hiliyonomo ipuwalo kapiyakapiyanomate ka꞉ka꞉ mula꞉ komo ba꞉ka꞉lawemena꞉?” Ya꞉suti iba꞉tamo na꞉huiyuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“La꞉ Godokono Hunu Haboeno tutuwa gigihodo a꞉pa꞉la꞉hama꞉ ukui konomamo nihatenala꞉, mabu nale la꞉tamo na꞉goemo, komo hiliyonomate ba꞉be gigihodo a꞉pa꞉la꞉hama꞉ dewagelemena꞉ huiyatiya iba꞉te a꞉kamodobamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Numa꞉la꞉, genama namutudawate mahigate gigiho da꞉kalapilamene, ba꞉ba tetelo la꞉ tamelo putitatate gigiho ba panakami kopega꞉lama꞉nemata, ‘Kodawa, gigiho na꞉pa꞉hiya꞉midaa꞉ma꞉!’ huiyatiya ebete ba꞉ma ka꞉na kogoema꞉ne, ‘Na iya꞉tawaha꞉ la꞉eno komo. La꞉ kebe napila꞉ka꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ba꞉ba tetelo la꞉ ba꞉ma ka꞉na koga꞉lama꞉nemata, ‘A ama꞉go baa꞉ nahate gao beya a꞉nihonakuima꞉, iyo, ama꞉ aeno habalo tawakalubi iya꞉tulamenakuya꞉ta!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ebete huiyatiya la꞉tamo gala kakagoema꞉ne, ‘Na iya꞉tawaha꞉ la꞉eno komo, la꞉ kebene ka꞉pelameoma? La꞉ kuba ododilipilata, nagodone na꞉tolama꞉la꞉!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ba꞉bema꞉ ba꞉ba tetelo la꞉ muhuludopolo nutitatate, la꞉ Godokono Hunu Haba ipuwalo A꞉ibalahamako, Aisa꞉keko, Ya꞉ikoboko, ba꞉gala Godokono ukui hawakalimipi hiliyonomo kulamema꞉nemata, huiyatiya Godote la꞉ gobogobamo diya꞉hekemena꞉, la꞉ lalo ba ikilame konomamo kihimima꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Numa꞉la꞉, ba꞉ba tetelo tawakalubi hiliyonomate ba꞉moe hopo konomoeno hapuhapuni pelameholete, Godote Ko Gawadubuma꞉ deda꞉na iba꞉te ba꞉be haboeno poko ipuwalo kopepola꞉nama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ba꞉ hibila, ibi hiliyonomo ipuwalo galapa꞉te huiyatiya dopopima꞉ keda꞉hama꞉na꞉, ba꞉gala dopopa꞉te huiyatiya galapima꞉ keda꞉hama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ba꞉ba tetenomolo komo Pa꞉lisi kapiyuimi dubate pelamete Ya꞉sutamo na꞉pega꞉luya꞉, “Ama꞉ ba꞉moe habane gobogobamo nalahula꞉, mabu Ko Gawadubu Heloditi ama꞉ anakapumima꞉ ubi bihatena.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “La꞉ tolamete ba꞉be heloha꞉ tumu gahatamo ba꞉ma ka꞉na na꞉nega꞉lala꞉, ‘Ka꞉lo ba꞉gala dumutu na kuba gobogobo tawakaluba꞉godone oelamete temetema꞉gopi kohiduilamema꞉nemo, ba꞉bene na pino naeno oko kupula꞉ma꞉nemo.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Hibila, na ka꞉lo ba꞉moe habane na꞉tutamo. Ka꞉lo, dumutu, ba꞉gala pino nale ba꞉moe gabodo tote Yelusalemamo konuluhukuma꞉nemo. Mabu tawakaluba꞉te Yelusalemalo Godokono ukui hawakalimipi anakapulamenakuya꞉, ba꞉bema꞉ modoboha꞉ na eta habalo hoe, iyo, iba꞉te na atumu Yelusalemalo na꞉kanakapunama꞉mena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Yelusalema, Yelusalema! Ama꞉le Godokono ukui hawakalimipi anakapulamenakata, ba꞉gala ebete ama꞉ kowalubima꞉ da꞉poelamenako, ama꞉le ibi nakolamo mapelamelo akanakapulamenakata. Tete ga꞉ga꞉nomolo na ubi nihatenamimo amia꞉no tawakalubi naeno ekatamo kitagua꞉midalema꞉, kakabate ebeno gugudi ditagua꞉midalenako ba꞉ba ka꞉na, huiyatiya ama꞉ ubiha꞉ma꞉ eda꞉nama꞉ta! ");
INSERT INTO knv_aramia_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ba꞉bema꞉ mu numitota꞉, amia꞉no habate kubanomo kokubama꞉ne. Nale ama꞉tamo na꞉goemo, amia꞉no tawakaluba꞉te na tete ga꞉ga꞉nomolo a꞉kunama꞉mena꞉, huiyatiya amia꞉no galanepa꞉te Godotamo ba꞉ma ka꞉na da꞉ga꞉lamena꞉, ‘Amia꞉no mahilago da꞉pita, ale ebe hunamo kadipatema꞉nema꞉!’ ba꞉ba tetelo nale gala da꞉kapemo iba꞉te na ba꞉bo kunamema꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ba꞉bene eta Yu tawakalubino okoha꞉ talona hegelalo Ya꞉suti baa꞉ nama꞉ eta Pa꞉lisi kapiyuimipino watodawoeno genamamo ba nodoluta, ba꞉bolo da꞉pola꞉nuya꞉ ba꞉bi tawakaluba꞉te ebe baidi kodakodalo umitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ba꞉ba tetelo eta dubu ape alupoe temetemete duminami, ebete Ya꞉sukunu holoholo hapuamo da꞉piya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ba꞉bema꞉ Ya꞉suti Godokono Tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi dubatamo na꞉goiya꞉, “Aeno tutumu tabote keba ka꞉na kiya꞉tua꞉mena? Okoha꞉ talona hegelalo lumagi hiduimi wadiyala꞉ka꞉ o kubala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Huiyatiya iba꞉te eta tabo kaga꞉luya꞉ha꞉, ba꞉bene Ya꞉suti ba꞉be dubu kokotamo lawete ebe hiduimiti ebe ba꞉bo noemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Amia꞉no guduti talona hegelalo haka gugamo da꞉negamene, ama꞉le ebe tiyolo konowalubima꞉na꞉ta, aba꞉ hibila꞉ka꞉? Iyo, ba꞉be atu hegelalo amia꞉no kau-goete beya ma꞉pea꞉mo da꞉negamene, ama꞉ atumu ebe tiyolo konuluhukutima꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ba꞉bema꞉ iba꞉te hilopohote Ya꞉sutamo huiya tabo ga꞉lama꞉ kamodobuya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ba꞉bene eta tetelo Ya꞉suti baa꞉ na habalo ba luta, genama namutudawate dopamo da꞉ka꞉lamiya꞉ ebeno poko baa꞉ kopenahama꞉, ba꞉bi dubate da꞉pelamiya꞉ ibi ubila koko tawakalubino habalo pegagahidi. Ya꞉suti ba꞉be komo umiti iba꞉tamo eta iya꞉tulame uwi ba꞉ma ka꞉na kiyauya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Eta dubuti uli kamena lawe poko tetelo ebete ama꞉ eba꞉go baa꞉ nama꞉ da꞉kiyamemena꞉, ba꞉ba tetelo ama꞉ ko habamo akanemeda꞉la꞉. Diyala, eta ko dubuti da꞉ pemene, ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ba꞉bema꞉ poko namutudawate pete ama꞉tamo ba꞉ma ka꞉na kopegoema꞉ne, ‘Ama꞉ eba꞉, nelehega! Ba꞉moe ko haba ba꞉moe dubuti kopemedema꞉ne!’ Ba꞉ba tetelo ama꞉ ba hilopo deha꞉poto habanomo kolawema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ba꞉bema꞉ wadiyala ama꞉ baa꞉ nama꞉ da꞉pemena꞉, ba꞉ba tetelo ama꞉ deha꞉poto habanomote na꞉pelawiya꞉, ba꞉bene poko namutudawate pete ama꞉tamo ba꞉ma ka꞉na kopegoema꞉ne, ‘Mabulubi, ba꞉moe deha꞉poto haba miya꞉pate, ko haba na꞉lawa꞉.’ Ba꞉bene baa꞉ da꞉nahuta ba꞉bi tawakalubi hiliyonomate ama꞉ ba umita, ebete ama꞉ ba꞉ba ka꞉na kokalakaluimima꞉na꞉ta, ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","mabu hibila, lumagiti ebe ha꞉kiya ebe koma꞉ da꞉midimini Godote ebe deha꞉potoma꞉ komidima꞉ne, ba꞉gala kebe lumagiti ebe ha꞉kiya ebe deha꞉potoma꞉ da꞉midimini Godote huiyatiya ebe koma꞉ komidima꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ba꞉bene Ya꞉suti baa꞉ kebe genamalo ka꞉nutiya꞉, ebete ba꞉be genama namutudawatamo na꞉goiya꞉, “Ama꞉le poko dododimina꞉ ba꞉ba tetelo amia꞉no habanapi, ba꞉gala amia꞉no nani ekaki, ba꞉gala amia꞉no komo hawi tawakalubi, ba꞉gala amia꞉no hopolo demedehona ilina hiliyonomagopi akaka꞉lama꞉la꞉, mabu ba꞉bako tawakaluba꞉te ama꞉tamo gala kakahuiyama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Huiyatiya ama꞉ poko dododimina꞉, ba꞉ba tetelo ilinaha꞉pi, nato kubakubapi, ba꞉gala baidi tamiholamepi, ba꞉bakobako tawakalubi na꞉ka꞉lamiya꞉ poko habamo, ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","mabu iba꞉godolo ilina puliyala ama꞉tamo huiyama꞉. Ama꞉le ba꞉ba ka꞉na dododinakomena꞉, Godote ama꞉ hidamo bowalubinakomena꞉ta, ba꞉gala tuputupu tawakaluba꞉te hoe ipuwane da꞉mahila꞉hamena꞉ ba꞉ba tetelo ebete eta hido huiya ama꞉tamo gala kakikamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ba꞉bene Ya꞉sukuba꞉ baa꞉ naha bahilo da꞉pola꞉nuya꞉, ibi ipuwalo eta lumagiti ebeno tabo uliti ebetamo na꞉goiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ba꞉be habalo baa꞉ da꞉nahamena꞉ ba꞉bi tawakaluba꞉te kokalakalahama꞉na꞉, kalakala bada konomola꞉ka꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ya꞉suti huiyatiya ebetamo na꞉goiya꞉, “Eta dubuti ko poko ododi nopo ba ihate tabo dopamo komo hiliyonomo tawakaluba꞉tamo noemi iba꞉te kopelamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ba꞉bene poko hegelate da꞉pi, ebete ebeno okodawa ba꞉bo oemi ba꞉bi atu tawakalubi kokiyahalamenatoma꞉. Ba꞉bene okodawate tote iba꞉tamo na꞉negoi, ‘La꞉ poko habamo na꞉pelama꞉la꞉, ilina hiliyonomo a꞉hiduilamema꞉,’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","huiyatiya ibi hiliyonomate pelamema꞉ ubiha꞉ma꞉ eda꞉hate etate eta tabo goenakui, etate eta tabo goenakui, ba꞉ba ka꞉na ewagelitiya꞉. “Ibi ipuwalo etate ko dubuino okodawatamo na꞉goi, ‘Na pali haka mana꞉mo ka꞉lo a꞉lawa꞉kamo, ba꞉bema꞉ na umima꞉ tutamo. Nolata, na a꞉kapa꞉mo.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Etate na꞉kagoi, ‘Na ta꞉ni kau-goegoe mana꞉mo ka꞉lo uwata꞉kamo, ba꞉bema꞉ na iba꞉godolo oko owatima꞉ tutamo. Nolata, na a꞉kapa꞉mo.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Etate gala na꞉kagoi, ‘Na uli kamena a꞉lawa꞉kamo, ba꞉bema꞉ na pe modoboha꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ba꞉bene okodawate ebeno namutudawatamo kapete ba꞉bi tawakalubino ubiha꞉ komo ebe na꞉pikiyami. Ko dubuti ebeno tabo duli, ebete maubate okodawa ba꞉bo kiyami, ‘Ama꞉ tiyonomo gala na꞉katoa. Ama꞉ ko habamo nuluhukuti, ba꞉be haboeno koko ba꞉gala hegehege gabodo ba to, ilinaha꞉pi, ba꞉gala nato kubakubapi, ba꞉gala baidi tamiholamepi, ibi hiliyonomo ba꞉moe poko habamo na꞉magaheliya꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ba꞉bene okodawate gala da꞉kawilui, ba꞉ba tetelo ebete na꞉pegoi, ‘Kodawa, ama꞉le da꞉gaa꞉ka nale a꞉nododimo. Hiliyonomo tawakaluba꞉te a꞉pelama꞉, huiyatiya poko habalo haba kodopo bitana komopa꞉te kopelamema꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ba꞉bema꞉ ko dubuti ebetamo na꞉goi, ‘Ama꞉ gala katote tumulu demedehona ba꞉gala hiya꞉hiya꞉ gabolo da꞉wapata꞉lamita, ba꞉bi tawakalubi tiyo nowalolete ibi atumu na꞉kamagaheliya꞉ naeno poko genamate kotaboma꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ba꞉bene ba꞉be ko dubuti ebeno genamanapa꞉tamo ohobigate na꞉kagoi, ‘Nale la꞉ hibinomolo goelamemata, nale dopamo da꞉ka꞉lamimo, ka꞉lo ba꞉bi tawakaluba꞉te ibino ubiha꞉ komo da꞉hawakalima꞉ka, ibi ipuwalo eta kapiya lumagiti naeno poko baa꞉ a꞉kanamene.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ba꞉bene tawakalubi hiliyonomate Ya꞉sukuba꞉ da꞉tolamitiya꞉, ba꞉ba tetelo ebete pohobigate iba꞉tamo na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kebe lumagiti natamo pema꞉ ubi dihatemene, ebete ebeno nabiwi menoko, ba꞉gala ebeno kamena gugudi, ba꞉gala ebeno nani nanikokubi ba꞉gala ekaki, iyo, ebeno kateneno ka꞉ka꞉ atumu, ebete ba꞉bi hiliyonomo komokomo gunima꞉mo ihilateleheno, ebete na ta꞉mahenema꞉ a꞉kamodobamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Iyo, ba꞉ hibila, kebe lumagiti ebeno keha pihiga aguti na ta꞉maheneheno, ebete nago kapimilo toma꞉ a꞉kamodobamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Numa꞉la꞉, la꞉ ipuwalo eta lumagiti hununomo genama etema꞉ ubi dihatemene, ebete dopamo emedete genama eteno mani kuititi hidamo emalagidolote, ebegodolo da꞉pola꞉na ba꞉bi mani ba꞉ma ka꞉na koka꞉lamiholema꞉ne, ba꞉be genama upula꞉ma꞉ mani modobola꞉ka꞉ o modoboha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ebete ba꞉ma ka꞉na ewageleheno ebeno genamoeno hototo amihote, ba꞉ba tetelo mani upula꞉te oko da꞉miya꞉pamene, tawakaluba꞉te ba꞉be komo umimiti ebe ba waliti, ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","koga꞉lama꞉na꞉, ‘Genama etema꞉ da꞉tupuimi huiyatiya upula꞉ma꞉ helohenola, ba꞉moe ba꞉be dubula!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ba꞉gala eta komo. Eta ko gawadubuti eta ko gawadubutamo alaholoma꞉ dewagelemene, ebete dopamo emedete ba꞉be komo hidamo ba emalagidoluta ba꞉ma ka꞉na kogoema꞉ne, ‘Naeno 10 taosene alaholohopi dubate eta gawadubuino 20 taosene dubago alaholo modobola꞉ka꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ebete ebeno ukuilo modoboha꞉ma꞉ da꞉goemene, eta ko gawadubuti muhuludopone ba pita, ebete ebeno ubihale dubu dopamo konoelamema꞉ne. Ba꞉bene iba꞉te eta ko gawadubutamo nikuliti konega꞉lama꞉na꞉, ‘La꞉ bada ubi kihatiutama ale la꞉tamo kikalamema꞉? A ubila la꞉go komiloma꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ba꞉bema꞉ Ya꞉suti kuititi tabo ba꞉ma ka꞉na goiya꞉, “Naeno taboeno ko ipuwa ba꞉ma ka꞉nala, kebe lumagiti ebeno emede komokomo hiliyonomo gunima꞉mo ihilateleheno, ebete na ta꞉mahenema꞉ a꞉kamodobamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Solo hidonomola, huiyatiya eta lumagino solo golate dalatidimini, ebete gala soloma꞉ a꞉kamida꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Numa꞉la꞉, tawakaluba꞉te nene ba꞉gala goegoeno ne kubanomoma꞉ ga꞉lanaka huiyatiya ba꞉bako ilina pali hakamo diya꞉hekemena꞉, ilinate hidamo kapepehoma꞉na꞉. Huiyatiya lumagino tepo ipuwoeno solo eba ka꞉naha꞉. Ebeno solo golate dalatidimini, ebeno ka꞉ka꞉te kubanomoma꞉ ba eda꞉ hido oko gala a꞉kowatinakamene. Ba꞉bema꞉ ebete ebeno ka꞉ka꞉ gala hidoma꞉ keba ka꞉na na꞉ka꞉midimini? Gabo puliyala! Galagodawa, ama꞉ hidamo nulia꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Eta hegelalo ta꞉kese mani ha꞉da amiholo uwatepi ba꞉gala Godokono Tutumu Tabo uwateha꞉pi komo ibi hiliyonomate Ya꞉sutamo pelamiya꞉ ebeno tabo kopulihoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ba꞉bene Pa꞉lisi kapiyuimipi ba꞉gala Godokono Tutumu iya꞉tulamepa꞉te ba maubaha na꞉ga꞉luya꞉, “Numa꞉la꞉, ba꞉moe dubuti kuba tawakalubi kalakalago uwatete iba꞉go baa꞉ ba꞉bo nanako!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ba꞉bema꞉ Ya꞉suti ba꞉moe iya꞉tulame uwi iba꞉tamo ba꞉ma ka꞉na olamagiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“La꞉ ipuwalo eta lumagi ebeno 100 sipi-goegoe da꞉pola꞉ma꞉na, ba꞉bene kapiyate dalatidimini ebete keba ka꞉na na꞉kewagelemene? Iyo, ebete komo 99 sipi-goegoe hido hemo naha bahilo miya꞉palete, eta dalatidi ba꞉be sipi-goe kapiya ohowadinatote konumima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ebete da꞉numimini ba꞉ba tetelo ebete aguti kalakalago komagahema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ba꞉bene ebete gala genamamo kapete ebeno mabulubi ba꞉gala ebe tamelo demedena, ba꞉bi tawakalubi peka꞉lamiti iba꞉tamo kopegoema꞉ne, ‘La꞉ nago kapimilo na꞉kalakalahala꞉, mabu naeno sipi-goe tumulu dalatidi nale gala a꞉kalawemo!’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ba꞉bema꞉ Ya꞉suti tabo ba꞉ma ka꞉na goiya꞉, “Nale la꞉ begoelamemata, kapiya lumagiti ebeno kubane ohobigate ukui hiya꞉ma꞉ da꞉midimini, ba꞉ba tetelo Godokono Hunu Habalo kalakala konomote kitanama꞉ne. Huiyatiya komo 99 tawakalubi iba꞉te ha꞉kiya ibi tuputupupima꞉ da꞉ga꞉lana, ibi mabuma꞉ Godokono kalakalate hibilo a꞉kitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ba꞉gala eta komo ba꞉ma ka꞉nala. Eta kamenoeno ta꞉ni mani da꞉pola꞉ma꞉na, ba꞉bene kapiyate dalatidimini ebe keba ka꞉na na꞉kewagelemene? Ebete ebeno alo pa꞉titi ba꞉gala genama gu hidamo ba moda꞉mida mani ohowadinatote ba꞉bo konumima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ba꞉bene ebete da꞉lawemene ba꞉ba tetelo ebeno mabulubi ba꞉gala ebe tamelo demedena, ebete ba꞉bi tawakalubi ka꞉lamiti iba꞉tamo kogoema꞉ne, ‘La꞉ nago kapimilo na꞉kalakalahala꞉, mabu dalatidi ba꞉be mani nale gala a꞉kalawemo!’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ba꞉bema꞉ Ya꞉suti tabo ba꞉ma ka꞉na goiya꞉, “Na la꞉ begoelamemata, kapiya lumagiti ebeno kubane ohobigate ukui hiya꞉ma꞉ da꞉midimini, Godokono Hunu Habalo ebeno nopopa꞉te atumu koamo kokalakalahama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ba꞉bene Ya꞉suti eta tabo gala na꞉kagoiya꞉, “Kuhi netewagoeno dubuti nemedenami, ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ba꞉bene amogate ebeno nabiwitamo na꞉goi, ‘Ama꞉le hoe tetelo natamo ikanamema꞉ da꞉goi, ba꞉bi ilina ba꞉gala haka ka꞉lo natamo nikanama꞉.’ Ba꞉ba tetelo nabiwiti ebeno ilina ba꞉gala mani tulituliya anagiya꞉midalelamete ebeno gugudi netewatamo hiya꞉hiya꞉ ba꞉bo ikalameholi. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ba꞉bene amogate hiliyo hegela kalutiha꞉. Ebete nabiwigodone da꞉lawi ba꞉be haka konomo kolowamiti mani lawete muhulu hopamo ba꞉ dito tui, ba꞉bolo ebete daedae ukuilo kubakuba komo ba nododili ebeno mani ba꞉ dito nupula꞉li. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ba꞉bene ba꞉be muhulu hopo konomolo baa꞉ wibo komote tawakaluba꞉tamo ba꞉bo uluhukui, ba꞉bema꞉ baa꞉ kape komote ebe konomamo lawi. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ba꞉bema꞉ ebete tote ba꞉be hoponapino eta dubugodolo oko ba nelawe, ebete ebe tumamo dito oemi ebeno goegoe konulamenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ba꞉ba tetelo tawakaluba꞉te nena꞉mo da꞉miya꞉tenakui ba꞉bi baa꞉ goegoa꞉tamo da꞉pikalameholenakui, ebete hiliyonomo tetelo ba꞉bi baa꞉ nahama꞉ ubi nihatenami, huiyatiya eta lumagiti ebetamo naha ilina kikamenakuiha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ba꞉bene komo hegelate da꞉wibui ebete ebeno ukui hiya꞉ma꞉ miditi na꞉goi, ‘Naeno nabiwino okopa꞉godolo naha ilina konomo ba꞉pola꞉na, iba꞉te ha꞉kiya nahana modoboha꞉. Na huiyatiya ba꞉malo baa꞉ kapelo hoema꞉ ewagelenamo! ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wadiyala na tote naeno nabiwitamo ba꞉ma ka꞉na konegoema꞉nemo, ‘Nabiwi, na Godotamo ba꞉gala ama꞉tamo kuba komokomo a꞉nododilimo, ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ba꞉bema꞉ na hidoenoha꞉ ama꞉le na amia꞉no guduma꞉ ka꞉nami. Wadiyala ama꞉ na huiyatiya amia꞉no eta okodawama꞉ na꞉midina꞉.’ ’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ba꞉ba tetelo ebete mahigate ebeno nabiwitamo ba꞉bo tui. “Ba꞉bene ebete muhuluni ba pita, ebeno nabiwiti ebe numiti ebe konomamo malemaletelo ebetamo nipuligate ebe ba na꞉pa꞉watameho ba꞉bo naboetehui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ebeno guduti na꞉goi, ‘Nabiwi, na Godotamo ba꞉gala ama꞉tamo kuba komokomo a꞉nododilimo, ba꞉bema꞉ na hidoenoha꞉ ama꞉le na amia꞉no guduma꞉ ka꞉nami.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Huiyatiya ebeno nabiwiti eta okodawatamo na꞉goi, ‘Hidonomo kaliko tiyolo adahemete naeno kuhitamo na꞉pepulima꞉, ba꞉gala kakaeto ebeno kokotamo pipulimiti nato ilina akona꞉pupulimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ba꞉bene ama꞉ tote uli ape kau-goe gadinomo nelawete na꞉nanagalimiya꞉. Ale poko baa꞉ ba nahana kokalakalahanama꞉nema꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","mabu ba꞉moe naeno gudu da꞉hoi ebete ka꞉lo gala na꞉kaka꞉ka꞉, ebete gobogobamo dalatidi huiyatiya nale ebe gala a꞉kalawemo.’ Ba꞉bene ba꞉ba tetelo iba꞉te kalakala ba꞉bo tupuimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Huiyatiya ba꞉ba tetelo naniwiti nabiwino pali habalo oko benowatiti. Da꞉gapogapohoni ebete oko habane genama tatalia꞉mo ba puluhukuna moe diyamo ba꞉gala kalakala ohaleno diyamo ba꞉bo pulihoni, ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ba꞉bema꞉ ebete eta okodawa ebetamo ka꞉minate nalateda꞉ni, ‘Moe komo keba ka꞉nala꞉ka꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Okodawate ebetamo na꞉goeni, ‘Amia꞉no amoga a꞉pa꞉ka, ba꞉bema꞉ amia꞉no nabiwiti uli ape kau-goe gadinomo anagalima꞉ka. Kalakala konomote itana mabu ebete olalatihino a꞉kapuluhukaka!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ba꞉be mabuma꞉ naniwiti maubanate genama guamo odolo ubiha꞉ma꞉ eda꞉ni, ba꞉bene ebeno nabiwiti puluhukunate ebe na꞉petoemehoni genamamo kopodolonama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ebete huiyatiya ebeno nabiwitamo na꞉goeni, ‘Ama꞉ numa꞉, na gogo hiliyonomolo amia꞉no okodawama꞉ ba eda꞉na, ama꞉le da꞉goenamenakui nale ubiha꞉ma꞉ keda꞉nakuiha꞉. Ama꞉ huiyatiya natamo bada ilina kikanamiui? A꞉iye! Ama꞉ natamo deha꞉poto gautu-goe kikanameha꞉, nale naeno mabuluba꞉go ba naha kokalakalahama꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Huiyatiya ba꞉moe amia꞉no eta guduti amia꞉no ilina uwatete, dubu bilibili kamenakamenago kuba ba nododili amia꞉no mani a꞉newatulateli. Ba꞉bene ba꞉be lumagiti da꞉pa꞉ka, ama꞉ ebe kokalakaluimima꞉ uli ape kau-goe ebetamo anagalimima꞉kata!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ebeno nabiwiti ebetamo na꞉huiyani, ‘Naeno gudu, ama꞉ emedena tetelo nago emedenata, naeno ilina hiliyonomo ba꞉ amia꞉nola. ");
INSERT INTO knv_aramia_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Huiyatiya ba꞉moe amia꞉no amogate da꞉hoi ebete ka꞉lo gala a꞉kaka꞉ka꞉, iyo, ebete gobogobamo dalatidi ale ebe gala a꞉kalawema꞉. Ba꞉bema꞉ wadiyala a baa꞉ kapimilo ba nahana kokalakalahanama꞉nema꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goiya꞉, “Eta ko dubuti eta dubu bihati ebeno ilina hiliyonomo hidamo kulamelemenama꞉. Ba꞉bene komo hegela hiliyonomo da꞉petohui, komo tawakaluba꞉te ba꞉be dogodogo dubu na꞉pega꞉lamiya꞉, ‘Numa꞉, ama꞉le dihati ba꞉be okodawate amia꞉no ilina pilo gabodo ba puwate ba꞉bo newatulatelenako.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Ba꞉ba tetelo ko dubuti ebeno okodawa ka꞉miti ebetamo na꞉goi, ‘Na ka꞉lo dulimo, ba꞉be komo kebanala꞉ka꞉? Ama꞉le naeno oko ba owatina kebako kuba dododilinama꞉, wadiyala ama꞉ ba꞉bi komokomo hiliyonomo amia꞉no oko bukalo hidamo netuputupuilamete ba꞉bo nadahiya꞉ nale kiya꞉tawama꞉. Mabu ama꞉ modoboha꞉ naeno ilina ulamedawama꞉ eda꞉, ba꞉bema꞉ ama꞉ ka꞉lo oko kekelamema꞉na꞉ta.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ba꞉bene ba꞉be okodawate ebeno oko habamo ba to tepo ipuwalo na꞉negoi, ‘Ko dubuti naeno oko a꞉duhimi, ba꞉bema꞉ na keba ka꞉na na꞉kewagelemo? Na ubihinola siwi aligili oko owati, na helohenola. Ba꞉gala na tawakaluba꞉tamo manima꞉ da꞉toetoemo na kohilopoma꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ehe, na iya꞉tawala! Naeno namutudawa ha꞉da ba amihome komo tawakalubi naeno mabulubima꞉ komidilima꞉nemo. Nale ba꞉ba ka꞉na dododimo, naeno okone uluhuku tetelo ba꞉bi mabuluba꞉te naeno modoboha꞉ komokomo ipuwalo kalakalago bowalubininakomena꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ba꞉bema꞉ ba꞉ba tetelo ebete ebeno namutudawa ha꞉da ba꞉ma ka꞉na amihomi. Puya꞉te ba꞉be ko dubutamo mani huiyahaleheno, ebete ibi hiliyonomo ka꞉lamiti dopodawatamo na꞉goi, ‘Ama꞉ naeno namutudawatamo kebako mani kahuiyaha꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ebete na꞉goi, ‘Nale 100 dolomo aloeno beya duwatimo, nale kahuiyaha꞉.’ “Ba꞉bene ko dubuino ilina ulamedawate ebetamo na꞉goi, ‘Mola, ama꞉le duwati ba꞉be pepa. Ama꞉le 100 kuititi egebolete huiyatiya 50 dolomo na꞉miya꞉ta꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ba꞉bene ebete eta tetedawatamo na꞉goi, ‘Ama꞉ kebako mani kahuiyaha꞉?’ “Ebete na꞉huiyui, ‘Nale 1,000 witi-laisa baika duwatimo, nale kahuiyaha꞉.’ “Ba꞉bene ko dubuino ilina ulamedawate ebetamo na꞉goi, ‘Mola, ama꞉le duwati ba꞉be pepa. Ama꞉le 1,000 kuititi egebolete huiyatiya 800 baika na꞉miya꞉ta꞉.’ Ba꞉bene ko dubuino ilina ulamedawate huiyahaleha꞉pi hiliyonomatamo ba꞉ma ka꞉na goenakui, iyo, ebete ba꞉moe ba꞉be gabodo ebeno namutudawa ha꞉da ba amihome komo hiliyonomo tawakalubi ebeno mabulubima꞉ ba꞉ dito midili. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Galane ko dubuti ebeno ilina ulamedawoeno ododi komo iya꞉tawate na꞉goi, ‘Ehe, ebe bada mulu kodawala꞉ka꞉! Ebete na ba kubahiname ebe ha꞉kiya ebe bowalubi.’” Ba꞉bene Ya꞉suti ebeno iya꞉tulame uwino ipuwa ba꞉ma ka꞉na hawakalimiya꞉, “Ba꞉moe hopolo hibima꞉ midiha꞉ tawakaluba꞉te mulunomoma꞉ ba eda꞉hana ibino mana꞉mo hiya꞉hiya꞉ komokomo bododilinaka ibi kowalubilinama꞉. Huiyatiya alo ipuwalo demedehona ba꞉bi tawakaluba꞉te komo tetelo mulu ukui emalagidoloheno ibi ha꞉kiya ibino mana꞉mo ibi kowalubilinaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nale la꞉ begoelamemata, wadiyala la꞉ ba꞉moe hopoeno mana꞉mo tawakalubi la꞉eno mabulubima꞉ na꞉midilinala꞉, ba꞉bema꞉ la꞉eno ha꞉laha tetelo ba꞉moe hopoeno ilina da꞉wiboholamemena꞉, Godokono Hunu Habalo la꞉eno mabuluba꞉te la꞉ atumu kalakalago kuwatema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ba꞉ hibila, kebe lumagiti deha꞉poto komo hidamo dododimini, ebete ko komo atumu hidamo kakododima꞉ne, ba꞉gala ebete deha꞉poto komo ipuwalo ha꞉da damihomene, ebete ko komo ipuwalo atumu ha꞉da kakamihoma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ba꞉bema꞉ la꞉ ba꞉moe hopolo la꞉eno ilina tuputupu gabodo ulamenaheno, Hunu Habalo da꞉pola꞉na ba꞉bi hidohido komo Godote la꞉tamo a꞉kikalamehola꞉mena꞉ta, ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ba꞉gala la꞉le komopino ilina tuputupu gabodo ulamelelamenaheno, eta dawate la꞉eno ilinanomo la꞉tamo a꞉kikalamehola꞉mena꞉ta! ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ba꞉gala ba꞉moe ba꞉ eta komola, lumagiti netewa gawadubatamo okodawama꞉ eda꞉ modoboha꞉. Ebete ba꞉ba ka꞉na dewagelemene etatamo ba maubana eta malemalelo bemalagidolonamene, ba꞉gala ebete etatamo ba utina eta ubiha꞉ma꞉ beda꞉namene. Ba꞉bema꞉ ama꞉ ba꞉ atumu, Godotamo ba꞉gala manitamo kapiya tetelo papamiwata modoboha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yu tawakalubi ipuwalo Pa꞉lisi kapiyuimipa꞉te mani konomamo emalagidolenama꞉, ba꞉bema꞉ komo iba꞉te Ya꞉sukunu tabo uliti ebe na꞉walititiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ tawakalubino holoholo hapulu la꞉eno hunu tama bihiduilamenamata, huiyatiya Godote la꞉eno tepo ipuwa komo iya꞉tawala, mabu tawakaluba꞉te kebe komokomo hunamo ba wadiya꞉paa꞉latele hidohidoma꞉ da꞉ga꞉lana, huiyatiya Godote ba꞉bi komokomo kuba abale niboma꞉ goena. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Godote ebeno Tutumu Tabo Moseseko ipuwado tawakaluba꞉tamo dikalamiya꞉ ba꞉gala ebeno ukui hawakalimipa꞉te Bukamo da꞉miya꞉tiya꞉, ba꞉be pakala komoeno tabote pete Yoneko teta꞉mo ba꞉bo puluhukui. Huiyatiya Yoneko tetene tupuimiti Godote Ko Gawadubuma꞉ deda꞉na ba꞉be uli komoeno tabote ba꞉ a꞉pe, ba꞉bene komopa꞉te ba꞉moe Hido Tabo ba olamagimina, komo tawakalubi hiliyonomate uliti ibi ubila Godokono Hido Habamo ibi ha꞉kiya ibino heloamo na꞉pa꞉la꞉ha. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ba꞉moe komo ba꞉ hibila. Ba꞉moe hopo ba꞉gala alomo ibino ilinate tete ga꞉ga꞉nomolo ba pola꞉na galane ha꞉kiya kowibohoma꞉na꞉, huiyatiya Godokono Tutumu Tabo hiliyonomo ipuwalo eta madodo deha꞉potonomote a꞉kawibamene, ebeno tabote emedena emedena tetelo bitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ba꞉bene Ya꞉suti eta tabo bekagoiya꞉, “Kebe dubuti ebeno kamena ibukiti eta da꞉lawemene ebete Godokono holoholo hapulu pilo komo kododima꞉ne, ba꞉gala dubuti ebeno kamena ibukiti, etate ba꞉be kamena da꞉lawemene ebete pilo komo kododima꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ba꞉bene Ya꞉suti ba꞉moe uwi bikiyahuya꞉, “Eta ilina dogodogo dubuti nemedenami, ebete huiya koko kaliko bepupulinakui ba꞉gala tete hiliyonomolo hidohido naha ilina benahanakui, ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","huiyatiya ebeno genama gigiho tetelo awae dubuti watitanakui, ebeno mahilo Lasalesitila, ebeno apelo kuma kokote pola꞉ma꞉nami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ebete ilina dogodogo dubuino baa꞉ naha habane hopamo da꞉peguditanakui, ba꞉be baa꞉ ugiugi nahama꞉ ubi nihatitanakui, huiyatiya gahagahate da꞉pelamenakui ebeno kuma ba꞉bo pa꞉loma꞉nalemenakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ba꞉bene eta hegelalo awae dubuti da꞉hoi, Godokono nopopa꞉te ebeno gobogobo pelawete Hunu Habamo A꞉ibalahamatamo dito magatuya꞉, huiyatiya ilina dogodogo dubuti da꞉hoi, tawakaluba꞉te ebeno ape pelawete bobamo dito nihatiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ba꞉bene ilina dogodogodawate Koe Habalo temeteme ipuwalo ba nemede, muhulunomone negahimite A꞉ibalahamako binumi, Lasalesikoba꞉ da꞉lumutiti. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ba꞉ba tetelo ebete konomamo ba negoewata na꞉goi, ‘Nabiwi A꞉ibalahama! Ama꞉ na malemalenatenelo Lasalesiko na꞉poema꞉. Wadiyala ebete ebeno kokoto nege beyamo adutiti naeno ma꞉lapila na꞉pegibagibuimina, mabu na ba꞉moe Koe Habalo temeteme konomo a꞉pelawemo!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Huiyatiya A꞉ibalahamate na꞉goi, ‘Gudu, ama꞉ nemalagidola. Ama꞉le hopo habalo demedenama꞉ ba꞉ba tetelo ama꞉ hidohido ilina bewatenama꞉ta, huiyatiya Lasalesiko kubakuba ilina bewatenami. Ba꞉bema꞉ numa꞉, ka꞉lo ebete hido kalakalago piluta, ama꞉ huiyatiya ko temeteme ipuwalo pilutata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gudu, ba꞉moe ba꞉ eta komola. Aeno tetetetelo konomo bolagale bitana, ba꞉bema꞉ ale ba꞉moene la꞉tamo pa꞉hiwale gabo puliyala, ba꞉gala la꞉le atamo pa꞉hiwale gabo atumu kitanaha꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ba꞉bene ilina dogodogo dubuti na꞉goi, ‘Nabiwi A꞉ibalahama, nale ama꞉ betoemehomata, ama꞉ naeno nabiwino genamamo Lasalesiko na꞉noemiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mabu naeno paibo ekaki ba꞉pola꞉na. Wadiyala ebete iba꞉tamo tote na꞉nikiyahalama꞉mene, iba꞉te ba꞉moe ko temeteme habamo pelamekapoma꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“A꞉ibalahamate huiyatiya na꞉goi, ‘Ao! Godokono tabote iba꞉godolo bitana, ebete Moseseko ipuwado tawakaluba꞉tamo dikalamiya꞉ ba꞉gala ebeno ukui hawakalimipa꞉te ebeno Bukamo da꞉miya꞉tiya꞉ ba꞉bi koko tabo. Wadiyala iba꞉te ba꞉bi komokomo ulihote Godokono ubi komamo na꞉papamila꞉mena꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ilina dogodogo dubuti na꞉goi, ‘Ao, Nabiwi A꞉ibalahama! Etate hoene ka꞉ka꞉mo mahigate iba꞉tamo da꞉tomene, iba꞉te ba꞉be hanohano komo umiti ibino kubane ohobila꞉te ukui hiya꞉ma꞉ ba꞉bo komidilima꞉na꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“A꞉ibalahamate tabo ba huiya na꞉goi, ‘Iba꞉te Moseseko ba꞉gala komo Godokono ukui hawakalimipi dubagodone tabo ulihoheno, eta lumagiti hoene iba꞉tamo da꞉nemahigamene, iba꞉te ba꞉be komo dumimina꞉ ba꞉be lumagino tabo atumu hibima꞉ a꞉kamida꞉mena꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goiya꞉, “Hibila, Saitanakono kuba gabamo emogabuimi komate tawakaluba꞉tamo kikulihoma꞉na꞉, huiyatiya kebe lumagigodone dikulihomena꞉ Godote ba꞉be lumagitamo kuba huiya konomo kikamema꞉ne! ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ba꞉bema꞉ wadiyala tawakaluba꞉te ebe lawete ebeno kokoba꞉mo konomo nakola ma꞉homete kehaha꞉ kolomamo na꞉da꞉namena꞉, eta deha꞉poto guduti ebeno kuba ipuwamo gakapoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ba꞉bema꞉ la꞉ ha꞉kiya la꞉eno komo hidamo nulamenala꞉! “Amia꞉no ekawiti ama꞉tamo kuba dododimini, ama꞉le ebe na꞉tutumutiya꞉, ba꞉bene ebete ebeno kubane ohobigate ebeno ukui hiya꞉ma꞉ da꞉midimini, ama꞉ ebeno kuba egebolemete nadodomiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Iyo, ebete kapiya hegelalo ama꞉tamo sa꞉ba꞉ni kuba komokomo ododiliti, ba꞉bene ebete sa꞉ba꞉ni teta꞉mo gala kapete ba꞉ma ka꞉na da꞉kapegoememena꞉, ‘Naeno naniwi, nolata. Na gala ama꞉tamo kuba a꞉kododa꞉mo,’ wadiyala ama꞉le ebeno kuba egebolemete kadodolemema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ba꞉bene Kodawa Ya꞉suti dopamo doelamiya꞉ Godokono oko konowatima꞉, ba꞉bi oelamepi dubate ebetamo na꞉ga꞉luya꞉, “Aeno hibima꞉ midi komo na꞉kokoilamelea꞉ma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kodawa Ya꞉suti ba huiya na꞉goiya꞉, “Mastada kikipo koha꞉, deha꞉potonomola. Huiyatiya la꞉eno hibima꞉ midi komote ba꞉makoma꞉ deda꞉mene, la꞉eno helote modoboma꞉ ba eda꞉ la꞉le ba꞉moe kehatamo koga꞉lama꞉nemata, ‘Ama꞉ ha꞉kiya amia꞉no haha magobelete, kehaha꞉ kolomamo na꞉nuta꞉!’ ba꞉bene ba꞉moe kehate la꞉eno tabamo kopapamiwatama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “La꞉ ba꞉moe go tabo hidamo nemalagidolala꞉. Tawakalubi ipuwalo etate ko gawadubuma꞉ deda꞉na ba꞉bene ebegodolo komo huiyaha꞉ okopi hiliyonomo demedena, ebeno ododi komo keba ka꞉nala꞉ka꞉? Ko gawadubuino huiyaha꞉ okodawa etate pali haka aligili oko ba꞉gala sipi-goegoe ulame oko wibuilamete genamamo da꞉pemene, ba꞉ba tetelo ebeno kodawate ebetamo ba꞉ma ka꞉na ba꞉ka꞉goemene, ‘Ama꞉ niliya, amia꞉no komo dopamo na꞉numa꞉. Ama꞉ amia꞉no baa꞉ nate, galane naeno baa꞉ na꞉pokalimiya꞉’? ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ao, ko gawadubuti eba ka꞉na a꞉kewagela꞉mene, huiyatiya ebete ebeno okodawatamo ba꞉ma ka꞉na kogoema꞉ne, ‘Baa꞉ okalimino dalowa꞉ha꞉ kaliko puliti, naeno baa꞉ na꞉hiduima꞉, ba꞉bene nale baa꞉ na habamo ba emede, ama꞉ hidohido baa꞉ ba꞉gala gao beya natamo kowadahema꞉na꞉ta. Naeno baa꞉ na komo da꞉wibomene, ama꞉ galane amia꞉no beya niti amia꞉no baa꞉ ba꞉bo konama꞉na꞉ta.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Ba꞉moe komo ba꞉ hibila. Ko gawadubuti ebeno okodawa hiya꞉hiya꞉ oko owatihoma꞉ da꞉goememene, ba꞉ba tetelo okodawate ebetamo papamiwatalo ba꞉bi oko dupula꞉lemene, ebeno kodawate ebetamo ba kalakala huiyatiya koamo a꞉kamilimihamene mabu ebe ba꞉ ebeno okodawoeno watodawala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ba꞉bema꞉ la꞉ ulihopi ba꞉ atumu. Ko Gawadubu Godote la꞉ kebe hiya꞉hiya꞉ oko owatihoma꞉ da꞉goelamemena꞉, wadiyala la꞉ ba꞉bi hiliyonomo oko upula꞉lete ba꞉ma ka꞉na koga꞉lama꞉nemata, ‘A Godokono okopila. Ebete a bada komoma꞉ ka꞉goea꞉mi, ale ebeno heloamo kalakalago dito ododima꞉, ba꞉bema꞉ eta lumagiti a milia꞉mehoe modoboha꞉. Wadiyala tawakaluba꞉te aeno Ko Gawadubu Godoko kapiya na꞉milimihamena꞉!’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ba꞉bene Ya꞉suti Yelusalema ko habamo ba to, ebete Samaliya hopo ba꞉gala Ga꞉lili hopo tetenomodo tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ebete eta haba deha꞉potoamo da꞉piya꞉ ta꞉ni kuitikuita꞉gopi dubate eba꞉go palugate muhuluni ebetamo ibulunomo na꞉pega꞉luya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Ya꞉su, Hido Iya꞉tulamedawa, ama꞉ a na꞉malemalea꞉tea꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ya꞉suti ibi muhulamo nulamete iba꞉tamo na꞉negoiya꞉, “La꞉ tolamete la꞉eno ape Godotamo hawa꞉goeno ikamehopa꞉tamo na꞉nemutuilamehola꞉la꞉.” Ba꞉bene iba꞉te ba tolame, gabo tetelo ibino apete ba꞉bo nihidohidohuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ibi ipuwalo eta kapiya ebeno apete da꞉hiduya꞉, ebete ba꞉be komo numiti ebeno tabo madodo hunamo adipatelo Godoko ba milimiho Ya꞉sutamo gala na꞉kapiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ba꞉bene ebete Ya꞉sukunu nato mabamo pegate ebetamo kalakala tabo ba꞉bo polamagiya꞉. Ba꞉be dubu ba꞉ Samaliya hoponapila, ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ba꞉bema꞉ Ya꞉suti ebeno komo umiti tawakaluba꞉tamo na꞉goiya꞉, “Numa꞉la꞉, Godokono helote ta꞉ni dubu a꞉hiduilame, huiyatiya komo naini iba꞉te kapelameha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Keka꞉ mabu ba꞉moe kapela dubu, ebe kapiyate kapete ebeno kalakala tabo Godotamo da꞉polamagi?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉ mahigate na꞉toa. Amia꞉no hibima꞉ midi komote ama꞉ a꞉hiduima꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ba꞉bene komo Pa꞉lisi kapiyuimi dubate Godote Ko Gawadubuma꞉ deda꞉na ba꞉be komoeno uluhuku tetema꞉ Ya꞉suku dalatediya꞉, ebete ibino tabo ba huiya na꞉goiya꞉, “Hanohano komate la꞉ a꞉kiya꞉tulama꞉mena꞉ta ba꞉ma ka꞉na, Godokono Ko Gawadubuino tete ba꞉ na꞉tatali. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Eta lumagiti ha꞉da amiho tabo ba꞉ma ka꞉na kogoema꞉ne, ‘Numa꞉la꞉, ba꞉be hido komote ba꞉ a꞉tupuimi, mola!’ ba꞉gala etate kakagoema꞉ne, ‘La꞉ ba꞉be komo ebamo na꞉numa꞉la꞉!’ Huiyatiya Godokono Ko Gawadubuma꞉ eda꞉ komo eba ka꞉naha꞉, mabu ba꞉be komo ba꞉ tepo ipuwoeno komola, iyo, la꞉tamo ya꞉lo a꞉puluhukuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ba꞉bene ebete ebe ta꞉matapa꞉tamo na꞉goiya꞉, “Ba꞉ma tetelo Tawakalubino Naniwiti ba꞉moe hopolo ba emedena, hopo habanapa꞉te hanohano komo ebegodolo ulamenaka. Galane tetelo la꞉ ubi kihatema꞉nemata ba꞉mako hegela gala kakumima꞉, huiyatiya la꞉ a꞉kuma꞉mata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ba꞉ba tetelo komopa꞉te la꞉tamo ba꞉ma ka꞉na koga꞉lama꞉na꞉, ‘Mola, ba꞉moe hanohano komo na꞉puma꞉la꞉!’ o ‘Bela, ebamo na꞉numa꞉la꞉!’ huiyatiya la꞉ ibi akata꞉matala꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ba꞉ hibila, hegelate da꞉la꞉wa꞉hiyamene ba꞉ba tetelo hegelate alomo hunu konomo ka꞉la꞉minahama꞉ne, ba꞉bema꞉ na Tawakalubino Naniwiti gala da꞉kapemo naeno pe hegelate ba꞉ ba꞉ba ka꞉na kitanama꞉ne, iyo, hopo habanapi hiliyonomate naeno pe komo kumima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Huiyatiya hibila, ba꞉be komote puluhukuhino, dopamo ba꞉ma tete tawakaluba꞉te na ubiha꞉ma꞉ eda꞉hate natamo temeteme kokonomo kikanamehonema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ba꞉ hibila, Nowako tetelo kebako komote kuluhukuya꞉, Tawakalubino Naniwiti gala da꞉kapemene ba꞉ba tetelo ba꞉be atu komote kakuluhukuma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ba꞉ba tetelo iba꞉te baa꞉ nahata ba꞉gala helo gao beya koamo nihota, dubate kamenakamena uwateholeta ba꞉gala kamenakamenate dubu uwateholeta, iba꞉te ba꞉ba ka꞉na ba ewagelena Nowate ko boga꞉mo ba꞉bo opeguya꞉. Ba꞉bene ba꞉ba tetelo beya konomote odolote tawakalubi hiliyonomo ba꞉bo anakapulamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ba꞉gala Lotoko tetelo duluhukuya꞉, ba꞉be atu komote ba꞉ba ka꞉na kakuluhukuma꞉ne. Tawakaluba꞉te baa꞉ nahata ba꞉gala helo gao beya koamo nihota, ibino ilina kolowamiholita ba꞉gala mani koamo uwatehota, pali ilina amihota ba꞉gala genama etemotehota, iba꞉te ba꞉ba ka꞉na ba ewagelena ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lotote Sodomo habane uluhukuti ba꞉bo alahuliya꞉. Ba꞉bene ba꞉be hegelalo koete Godokono Hunu Habane hopamo pegate ibi hiliyonomate koelo dito ha꞉lahuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ba꞉bema꞉ Godote Tawakalubino Naniwino hibi komo da꞉hawakalimimini, ba꞉be tetete ba꞉ ba꞉ba ka꞉na kakitanama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ba꞉be Ko Hegelalo kebe lumagiti genama panalo da꞉lutamene, ebete genama guamo gala a꞉kana꞉pa꞉gamene ebeno ilina uwatema꞉, ba꞉gala tumulu oko dowatitamene ba꞉be lumagiti atumu ebeno genamamo gala a꞉katoamene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ba꞉bema꞉ la꞉ Lotokono kamenoeno komo nemalagidolala꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kebe lumagiti ebeno kateneno ubi gabodo ba to ebeno ka꞉ka꞉ Godotamo damawada꞉mene, ebeno ka꞉ka꞉te kalatidima꞉ne, huiyatiya kebe lumagiti ebeno ka꞉ka꞉ Godoko mabuma꞉ datutimini, ebete hibi ka꞉ka꞉ kolawema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nale la꞉ begoelamemata, ba꞉be dulu dubu netewate kapiya tilolo da꞉lanamena꞉, Tawakalubino Naniwiti pete eta ba pelawe eta ba꞉bo komiya꞉pama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ba꞉gala kamenakamena netewate baa꞉ da꞉lapahutamena꞉, ebete pete eta ba pelawe eta ba꞉bo komiya꞉pama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ba꞉gala dubu netewate pali habalo da꞉wapatitamena꞉, ebete pete eta ba pelawe eta ba꞉bo komiya꞉pama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ba꞉bene Ya꞉suku ta꞉matapa꞉te ebe nalatediya꞉, “Kodawa, ba꞉moi komate kebolo na꞉kikulihomena꞉?” Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “Abale ilinate kebolo ditana, wala꞉te alehola꞉go ba꞉bamo koguditama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ba꞉bene Ya꞉suti eta iya꞉tulame uwi ebe ta꞉matapa꞉tamo nolamagiya꞉, mabu ebe ubihinola iba꞉te hiliyonomo tetelo Godotamo toetoe tabo ga꞉la ipuwalo iba꞉te huiya tabo tiyolo laweheno heloha꞉ma꞉ eda꞉hakapoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ebete na꞉goiya꞉, “Eta habalo tabo anagilamedawa dubuti nemedenami, ebete Godotamo kapapamiwatanakuiha꞉ ba꞉gala ebete tawakalubi kamalemalelatelenakuiha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ba꞉be atu habalo eta hamole kamenate na꞉kemedenami, ebete hiliyonomo tetelo tabo anagilamedawatamo penakui ba꞉ma ka꞉na pegoenakui, ‘Ama꞉le nago dalaholohona, ba꞉be lumagitamo kuba huiya nikama꞉!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Ba꞉bene tabo anagilamedawate tete ga꞉ga꞉dopolo ebeno tabo kulinakuiha꞉, huiyatiya galane ebete ebeno ukuilo ba꞉ma ka꞉na goi, ‘Na Godotamo a꞉kapapamiwatalemo ba꞉gala na tawakaluba꞉tamo malemale a꞉kihata꞉lemo, ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","huiyatiya ba꞉moe kamenate tete ga꞉ga꞉lo natamo ko temeteme bikanamena. Nale ebe owalubihino ba꞉moe temeteme komote a꞉kekelamene, ba꞉bema꞉ wadiyala nale ebeno ubi komamo papamiwatalo eba꞉go alaholohodawatamo kuba huiya kikamema꞉nemo!’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ba꞉bene Kodawa Ya꞉suti na꞉goiya꞉, “Ba꞉moe tabo anagilamedawa ebe ba꞉ kuba lumagila, huiyatiya ebete da꞉goi, wadiyala la꞉ ba꞉be tabo hidamo nemalagidolala꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","La꞉eno ukui keba ka꞉nala꞉ka꞉? Godokono tawakalubi ipuwalo puya꞉te du tetelo ba꞉gala hegela tetelo ebetamo toetoeholo dihimina, ebete iba꞉tamo huiya ikalameha꞉ma꞉ ba꞉keda꞉mene? Ba꞉gala ebete ibi owalubili ubiha꞉ma꞉ eda꞉lo tete ba꞉ka꞉ga꞉gima꞉tepamene? ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ao! Nale la꞉ begoelamemata, ebete ibi owalubililo iba꞉go dalaholohona ba꞉bi tawakaluba꞉tamo kuba huiya tiyonomo kopikalamema꞉ne, huiyatiya Tawakalubino Naniwiti da꞉pemene, ba꞉ba tetelo ebete hopo habanapa꞉godolo hibima꞉ midi komo ba꞉ka꞉pumimini?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ya꞉suti ba꞉moe eta iya꞉tulame uwi komo tawakaluba꞉tamo kolamagiya꞉, mabu ibi ha꞉kiya ibi tuputupupima꞉ ba ga꞉lana komopi tawakalubiha꞉ma꞉ ga꞉lanakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ebete na꞉goiya꞉, “Dubu netewate Godoko Adikumino Hiya꞉ Genamamo nodoluya꞉ Godotamo toetoehoma꞉, eta Pa꞉lisi kapiyuimidawa dubula, eta ta꞉kese mani ha꞉da amiholo uwatedawala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ba꞉bene Pa꞉lisi dubuti ebe ha꞉kiya utiti ebeno komoma꞉ ba꞉ma ka꞉na goi, ‘Godo, na ama꞉tamo kalakala tabo bolamagimo, mabu na ba꞉moi komo tawakalubidopoha꞉. Ba꞉ma ka꞉na na ilina pilolo a꞉kuwata꞉lemo, ha꞉da gabodo a꞉kapata꞉lemo, ba꞉gala eta dubuino kamena pilolo kalaweha꞉. Ba꞉gala ba꞉moe ta꞉kese uwatedawate hiya꞉hiya꞉ kuba dododilina, na eba ka꞉naha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na kapiya wuiki ipuwalo nale netewa hegelalo amia꞉no oko owatima꞉ baa꞉ naheno lutanakomo, ba꞉gala nale duwatenakomo ba꞉bi ilina hiliyonomo anagilameholete, komo ta꞉ni komokomo ipuwane eta kapiya kalawe, eta kapiya kalawe, amia꞉no komo ama꞉tamo hibinomolo ikamenakomata.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Huiyatiya ta꞉kese uwatedawate muhuludopone nutiti, ebeno wato hopamo toda꞉miduimiti ba la꞉na ebete hilopago bodolo anagalimilo na꞉goi, ‘Godo, na koko kuba ama꞉tamo ododilimo, huiyatiya nale ama꞉ betoemehomata, natamo kuba huiya ikanameheno na na꞉malemalenatena꞉!’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Na la꞉tamo na꞉goemo, Godote ba꞉moe awagaha꞉ lumagino kuba egebolemete ebete ebeno genamamo ba꞉bo tui, huiyatiya Pa꞉lisi dubu eba ka꞉na kewageleha꞉. Godote ebeno komo katuputupuimimiha꞉, ebete ebeno kubago ba꞉ba ka꞉na tui. Mabu hibila, lumagiti ebe ha꞉kiya ebe koma꞉ da꞉midimini Godote ebe deha꞉potoma꞉ komidima꞉ne, ba꞉gala kebe lumagiti ebe ha꞉kiya ebe deha꞉potoma꞉ da꞉midimini Godote huiyatiya ebe koma꞉ komidima꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ba꞉bene tawakaluba꞉te gugudi hegehege Ya꞉sutamo na꞉magaheliya꞉, ebete ebeno kokoto iba꞉tamo ba emowatilame Godoko kogoemema꞉ ebete ibi hidamo kowalubilinama꞉. Ba꞉ba tetelo ebe ta꞉matapa꞉te ba꞉be komo umiti tawakalubi kiyahalamelo gugudi na꞉duhilamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","huiyatiya Ya꞉suti gugudi ebetamo ba ka꞉lami ebe ta꞉matapa꞉tamo na꞉goiya꞉, “Gugudi natamo pelame wadiyala. Akaduhilama꞉la꞉, mabu ba꞉mako tawakaluba꞉te Godote Ko Gawadubuma꞉ deda꞉na ba꞉be habamo kona꞉pa꞉la꞉hama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na la꞉tamo hibi tabo begoemo, kebe lumagiti gudu deha꞉poto huiyamo aeno Ko Gawadubu Godoko laweheno, ba꞉be lumagiti ebeno Kalakala Habamo a꞉kana꞉pa꞉gamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ba꞉bene Yu tawakalubino eta watodawate Ya꞉suku ba alateda꞉ na꞉goemiya꞉, “Hido Iya꞉tulamedawa, na bada komo ododiti wiboha꞉ ka꞉ka꞉ ebo na꞉ka꞉lawemo?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉le na hidodawama꞉ badama꞉ ka꞉ka꞉nama꞉wa? Eta hidodawa puliyala, Godoko kapiyate hidodawanomola. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ama꞉ Godokono Tutumu Tabo iya꞉tawala. Eta lumagino kamena pilolo akalawa꞉la꞉, lumagi akanakapuma꞉la꞉, ilina pilolo akuwata꞉la꞉, eta lumagino komoma꞉ ha꞉da tabo akolamaga꞉la꞉, ba꞉gala amia꞉no nabiwi menoko ibino tabamo na꞉papamiwatanakuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Huiyatiya ebete Ya꞉sutamo na꞉goiya꞉, “Na deha꞉poto tetene tupuimiti ba꞉moi hiliyonomo tutumu kodakodalo uwatete eta kapiya kadikanaliya꞉ha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ya꞉suti ebeno tabo uliti ebetamo na꞉goiya꞉, “Ama꞉godolo kapiya komote kamodobonaha꞉. Wadiyala komopa꞉te amia꞉no hiliyonomo ilina mana꞉mo uwatehomete ama꞉le ba꞉bi mani komo awaepa꞉tamo na꞉nalabahalama꞉. Ba꞉ba tetelo ama꞉ gala kapete na na꞉ta꞉maheniya꞉, ba꞉bene amia꞉no ilina hiliyonomate Godokono Hunu Habalo konepola꞉nama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ebete ba꞉be tabo uliti ebeno tepo ipuwalo menemenenomoma꞉ ediya꞉ mabu ebe ilina dogodogodawanomola. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ya꞉suti ebe umiti na꞉goiya꞉, “Godote Ko Gawadubuma꞉ deda꞉na, ilina hiliyonomagopa꞉te ba꞉be habamo na꞉pa꞉la꞉hama꞉ kodakodanomola! ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Numa꞉la꞉, ka꞉molo-goete kaliko akohomehoeno ola gugudu nilupiga kodakodama꞉ eda꞉na, gabohenola. Ba꞉ atumu ilina hiliyonomagodawate Godokono Ko Gawadubu habamo na꞉pa꞉ga kodakodanomola, gabote hibinomolo a꞉kitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ba꞉bene Ya꞉sukunu tabo ulihopa꞉te ebetamo na꞉ga꞉luya꞉, “Ama꞉ da꞉gaa꞉ ba꞉be tabote hibima꞉ deda꞉na, puya꞉te modobola꞉ka꞉ Godote ibino ka꞉ka꞉ mula꞉lelamema꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ya꞉suti iba꞉tamo ba huiya na꞉goiya꞉, “Tawakaluba꞉godolo da꞉kodakodahana ba꞉bi komokomo huiyatiya Godogodolo kodakoda hibiha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ba꞉bene Pitate Ya꞉sutamo na꞉goiya꞉, “Ama꞉ numa꞉, aeno genamoeno ilina hiliyonomo miya꞉palete ama꞉ na꞉ta꞉mahenata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ya꞉suti iba꞉tamo gala na꞉kagoiya꞉, “Na la꞉tamo hibi tabo begoemo, kebe lumagiti ebeno genama, o ebeno kamena, o ebeno nani ekaki ba꞉gala ebeno menokobi nabi gugudi, ba꞉bi komokomo Ko Gawadubu Godoko mabuma꞉ da꞉miya꞉palemene, ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ebete ba꞉ma tetelo huiyatiya Godogodone ba꞉bi atu hiliyonomo komokomo gala kakuwatema꞉ne, ba꞉gala galane ebete wiboha꞉ ka꞉ka꞉ kakalawema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ba꞉bene Ya꞉suti ebeno 12 ta꞉matapi dubu ebetamo ka꞉lamiti iba꞉tamo na꞉goiya꞉, “La꞉ nulia꞉la꞉, a Yelusalemamo tolamitama꞉. Ba꞉bolo Godokono ukui hawakalimipa꞉te Tawakalubino Naniwi mabuma꞉ Bukamo da꞉miya꞉tiya꞉ ba꞉bi hiliyonomo komate kopikulihoma꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iyo, Godote ebe Yuha꞉pa꞉tamo kikalamema꞉ne, ba꞉bene iba꞉te ebe iduduputimilo ba iya꞉da꞉te ebetamo kowe komehoholema꞉na꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ba꞉gala iba꞉te giya꞉pa꞉pa꞉mo ebe a꞉na꞉miga꞉titi ba꞉bene ebe dito kanakapumima꞉na꞉, ebe huiyatiya netewa-kapiya hegelalo hoene gala kakamahigama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Huiyatiya Ya꞉suti dolamagiya꞉, ebe ta꞉matapa꞉te ba꞉be taboeno ipuwa hidamo kalawiya꞉ha꞉. Ba꞉be komote awalelalo itanuya꞉ ba꞉bema꞉ iba꞉te hidamo kemalagidoluya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ba꞉bene Ya꞉suti Yeliko ko haba tama꞉mo ba penape, baidi tamihome dubuti gabo tamelo emedete manima꞉ tawakalubi betoelameholitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ebete tawakalubi hiliyonomo gabodo da꞉petolamitiya꞉, ba꞉be komo uliti komopi ba꞉bo alateda꞉liya꞉, “Bada komote ka꞉pita?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Iba꞉te na꞉huiyuya꞉, “Nasaletenapi dubu Ya꞉suti pita.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ba꞉bene ebete tabo konomamo goelo na꞉goiya꞉, “Ya꞉su, Da꞉ibidikono Hogo! Ama꞉ na na꞉malemalenatena꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ba꞉ba tetelo dopamo da꞉petolamitiya꞉ ba꞉bi tawakaluba꞉te ebe kiyahamelo na꞉duhimiya꞉ ebete tatabalo kolutama꞉, huiyatiya ebete gala ibulunomamo na꞉kagoiya꞉, “Da꞉ibidikono Hogo! Ama꞉ na na꞉malemalenatena꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ba꞉bene Ya꞉suti ba꞉bamo utiti baidi tamihome dubuino komoma꞉ na꞉goiya꞉, “Ebe na꞉magaha꞉la꞉.” Ebete tama꞉mo da꞉piya꞉, ba꞉ba tetelo Ya꞉suti ebe nalatediya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ama꞉ bada ubi kihatiuta nale ama꞉tamo kododima꞉?” Ebete na꞉goiya꞉, “Kodawa, na ubila ilina hidamo kulamema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉ baidi na꞉gahima꞉! Amia꞉no hibima꞉ midi komote ama꞉ a꞉hiduima꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ba꞉bema꞉ hibila, ba꞉ba tetenomolo ebeno baiditi da꞉hidohidohuya꞉, ebete Godoko ba milimiho Ya꞉suku ba꞉bo ta꞉matuya꞉, ba꞉bene hiliyonomo tawakaluba꞉te ba꞉be komo umiti iba꞉te atumu Godokono mahilo hunamo ba꞉bo adipatiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ba꞉ba tetelo Ya꞉suti Yeliko haba ipuwado petutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ba꞉be habalo Sa꞉kiyaseko nemedenami, ebe ta꞉kese uwatepino watodawala ba꞉gala ebe ilina dogodogodawala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ebete ebeno tepo ipuwalo na꞉goiya꞉, “Ya꞉suku kebako dawala꞉ka꞉?” ba꞉bene ebete ebe kumima꞉ ubi konomamo nihatitiya꞉, huiyatiya ebe gopowahi dubula ba꞉gala tawakalubi hiliyonomate Ya꞉suku anagogoba꞉miduya꞉, ba꞉be mabuma꞉ ebete Ya꞉suku umima꞉ modoboha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ba꞉bema꞉ ebete tawakalubino dopo hapuamo puligate, anahu kehamo dito nodoluya꞉ Ya꞉suku kumima꞉, mabu Ya꞉suti ba꞉be gabodo pitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ba꞉bene Ya꞉suti ba꞉bamo puluhukuti baidi hunamo da꞉pegahimiya꞉, ebe pumiti na꞉pegoemiya꞉, “Sa꞉kiyase, ama꞉ tiyo na꞉pihitiga! Na ka꞉lo hegelalo amia꞉no genamalo kolutama꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ba꞉ba tetelo Sa꞉kiyasete tiyo pihitigate, Ya꞉suku lawete ebeno genamamo kalakala konomago dito magatuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ba꞉bene tawakalubi hiliyonomate ba꞉be komo umiti ubiha꞉ tabo ba꞉ma ka꞉na ga꞉luya꞉, “Ebete kuba lumagino genamamo a꞉to.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Huiyatiya Sa꞉kiyasete ebeno genamalo tawakalubino dopo hapulu mahigate Ya꞉sutamo na꞉goiya꞉, “Kodawa, ama꞉ numa꞉! Ka꞉lo nale naeno ilina tulituliya anagiya꞉midalete, naeno komo ilina awaepa꞉tamo kikalameholema꞉nemo, ba꞉gala nale komopino mani ha꞉da amiho gabodo duwatenakuimo netewa-netewa teta꞉mo gala kakahuiyahalema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Ka꞉lo hegelalo Godokono ka꞉ka꞉ mula꞉ komote ba꞉moe genamamo a꞉pe, mabu ba꞉moe dubu atumu ba꞉ A꞉ibalahamakono eyono gudu etala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ba꞉ hibila, puya꞉te kuba ododili ipuwalo dalatidiholena, ba꞉bi tawakalubi uwatete ibino ka꞉ka꞉ komula꞉lelamema꞉ na Tawakalubino Naniwiti ba꞉bema꞉ piya꞉mo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ba꞉be tabo dulihutiya꞉ ba꞉bi tawakaluba꞉te iya꞉tawahuya꞉ Ya꞉suti Yelusalema ko haba tama꞉mo a꞉puluhuku, ba꞉bema꞉ iba꞉te ibino ukuilo na꞉ga꞉luya꞉, “Diyala, ba꞉ma tetelo Godokono Ko Gawadubu komote atamo da꞉ uluhukumini.” Ya꞉suti ibino komo iya꞉tawate eta iya꞉tulame uwi iba꞉tamo ba꞉ma ka꞉na olamagiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Eta ko dubuti muhulu hopamo tuya꞉, ebe ubila ba꞉be muhulu hopolo Ko Gawadubu haba nelawete, ebete ebeno habamo ba꞉bo kakapema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ebete toheno, dopamo ebeno ta꞉ni okopi ebetamo ka꞉lamiti etatamo 100 mani, etatamo 100 mani, ba꞉ba ka꞉na ba ikalamehole ibi na꞉goelamiya꞉, ‘La꞉ ba꞉moi mani na꞉kokoilamiya꞉la꞉ naeno pe kuitita꞉mo.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ba꞉bene ebete muhulu hopolo ba nemede, komo ebeno hoponapa꞉te ebetamo maubahate ebeno gala hapuni tabo atapi ba꞉bo oelamiya꞉. Iba꞉te tolamete tabo ba꞉ma ka꞉na nega꞉luya꞉, ‘A ubihinola ba꞉moe dubuti aeno Ko Gawadubuma꞉ eda꞉, ebete aeno hopamo gala a꞉kapa꞉mene.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Huiyatiya ko dubuti muhulu hopolo ko gawadubu haba nelawete ebeno habanomamo gala na꞉kapiya꞉. Ba꞉ba tetenomolo ebete dopamo puya꞉tamo mani dikalameholiya꞉, ba꞉bi okopi ebetamo na꞉peka꞉lamiya꞉ ebeno mani kuititi iba꞉godone kiya꞉tawama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dopodawa ebete pete ebetamo na꞉pegoiya꞉, ‘Kodawa, amia꞉no 100 mana꞉mo nale eta 1,000 mani bododimo.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ko dubuti ebetamo na꞉goiya꞉, ‘Ehe! Ama꞉ ba꞉ hido okodawalata! Ama꞉ deha꞉poto komo hidamo ododia꞉ta, ba꞉bema꞉ nale ama꞉ ta꞉ni habahaba ulamedawama꞉ komidima꞉nemata.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ba꞉bene eta tetedawate pete ebetamo na꞉pegoiya꞉, ‘Kodawa, amia꞉no 100 mana꞉mo nale eta 500 mani bododimo,’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ba꞉bene ko dubuti ebetamo na꞉goiya꞉, ‘Nale ama꞉ paibo habahaba ulamedawama꞉ komidima꞉nemata.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Galane eta tetedawate pete ebetamo na꞉pegoiya꞉, ‘Kodawa, ba꞉moe ba꞉ amia꞉no 100 manila. Ama꞉ da꞉tuya꞉la, na ba꞉moe mani kalikamo hidamo matuhumihote tawakaluba꞉te umiha꞉ baha꞉mo ba꞉bo ihatiya꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Na ama꞉ betolemenamata mabu ama꞉ tabo helonomo dubulata. Komopa꞉te da꞉miya꞉tenaka ama꞉ pete ba꞉bi ilina ba꞉puwatenakomena꞉ta, ba꞉gala iba꞉te damihonaka ama꞉ ba꞉bi ilina dito ba꞉petapihonakomena꞉ta ama꞉le ha꞉kiya konahama꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ba꞉bema꞉ ko dubuti ebetamo na꞉goiya꞉, ‘Ama꞉ kuba okodawalata! Ama꞉le da꞉gaa꞉, ba꞉be tabote amia꞉no kuba behawakalimi! Iyo, ama꞉ tabo ba꞉ma ka꞉na a꞉gaa꞉ta, na tabo helonomo dubula, ba꞉gala komopa꞉te da꞉miya꞉tenaka nale ba꞉bi ilina ba꞉puwatenakomo, ba꞉gala iba꞉te damihonaka nale ba꞉bi ilina dito ba꞉petapihonakomo. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ba꞉bema꞉ mabu keka꞉ ama꞉le naeno mani baneka okopa꞉tamo kanikalamiya꞉ha꞉? Iba꞉te mani uwatete eta oko nowatitale kodopoma꞉ beda꞉na꞉, ba꞉bene nale pete ama꞉le natamo atu mani huiyatiya nanekela꞉mo hunudopamo gala ba꞉ka-ikanameona꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ba꞉bene ko dubuti ebeno hopopi na꞉kiyahalamiya꞉, ‘La꞉ ebeno 100 mani lawemete 1,000 mana꞉goeno dubutamo nikama꞉la꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Iba꞉te huiyatiya ebetamo na꞉ga꞉luya꞉, ‘Kodawa, eba ka꞉naha꞉! Ba꞉be lumagiti 1,000 mani ya꞉lo uwati!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ba꞉bene ko dubuti iba꞉tamo na꞉huiyuya꞉, ‘Na la꞉tamo na꞉goemo, kebe lumagigodolo hidohido ukui da꞉pola꞉na, etate ebetamo hiliyonomo hidohido komo kikamehoma꞉ne. Huiyatiya kebe lumagigodolo hidohido ukui pola꞉naheno, ebegodolo kebe kapiyakapiya komate da꞉pola꞉na etate ebegodone gala kakuwatemema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ba꞉gala eta komo. Puya꞉te nago alaholohoma꞉ ba ewagelena ubiha꞉ma꞉ deda꞉hana nale ibino Ko Gawadubuma꞉ eda꞉ma꞉, la꞉ ibi magahelete naeno dopo hapulu alaholo gila꞉mo dito na꞉panakapulama꞉la꞉!’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ya꞉suti ba꞉moe tabo tawakaluba꞉tamo goete ibi dopalamete Yelusalema ko haba hapuamo ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ba꞉ba tetelo ebete Betapa꞉gi haba ba꞉gala Betani haba tamedo tote Olibi Kehakeha Hunu Hakamo ba꞉bo nuluhukuya꞉, ba꞉bene ebete ebe ta꞉matapi netewa dopamo ba noelame ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","iba꞉tamo na꞉goiya꞉, “La꞉ ba꞉be tatali habamo tote, ba꞉be habamo da꞉nuluhukuma donoki-goe deha꞉poto hala꞉mo ma꞉home ba꞉bo konumima꞉nemata, lumagiti dopamo ebe hunamo kemediya꞉ha꞉. Wadiyala la꞉ hale pahamiti na꞉magahiya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Etate la꞉tamo da꞉goemene, ‘La꞉ ebe badama꞉ ka꞉pahamiutama?’ la꞉ huiyatiya ba꞉ma ka꞉na na꞉ga꞉luya꞉la꞉, ‘Kodawate donoki-goe ubila.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ba꞉bene iba꞉te gabodo tote habamo ba nuluhuku Ya꞉suti ibi keba ka꞉na ka꞉kiyalamiya꞉, iba꞉te ba꞉bi komokomo ba꞉ba ka꞉na nulamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Iba꞉te donoki-goe deha꞉poto ba pahamita, namutuluba꞉te iba꞉tamo na꞉ga꞉luya꞉, “La꞉ ebe badama꞉ ka꞉pahamiutama?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Iba꞉te tabo ba huiya na꞉ga꞉luya꞉, “Kodawate donoki-goe ubila.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ba꞉bene iba꞉te donoki-goe deha꞉poto Ya꞉sutamo magahete, ibino watuino kaliko donoki-goe hunamo miya꞉temete, iba꞉te Ya꞉suku ibino kokotamo adipatete ba꞉ dito adipiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ba꞉ba tetelo Ya꞉suti ba tuta tawakaluba꞉te ibino ga꞉ga꞉ga꞉ kaliko pipikulamete gabamo apohohote, ebete ba꞉be hunudu tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ebete Olibi Kehakeha Hunu Hakane ba nihitiga Yelusalema ko haba tama꞉mo da꞉piya꞉, ba꞉ba tetelo ebe da꞉ta꞉matanakui ba꞉bi tawakalubi hiliyonomate Godotamo kalakala tabo kapimilo koamo wadiya꞉paa꞉latelelo ebe ba꞉bo milimihuya꞉, mabu iba꞉te koko hanohano komo hiliyonomo ulamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Iba꞉te tabo ba꞉ma ka꞉na ga꞉lutiya꞉, “Godo, amia꞉no mahilago da꞉pita, wadiyala ama꞉ ba꞉be Ko Gawadubu na꞉koimiya꞉! O tawakaluba꞉la꞉, la꞉ Godoko milimiholo hunamo nadipata꞉la꞉, ebe ba꞉ Hunu Haboeno kalakala komoeno mabula!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ba꞉bene tawakalubi ipuwalo da꞉pola꞉nuya꞉ ba꞉bi Pa꞉lisi kapiyuimi dubate Ya꞉suku na꞉kiyahamiya꞉, “Iya꞉tulamedawa, ama꞉ ta꞉matapi na꞉duhilama꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ya꞉suti iba꞉tamo na꞉huiyuya꞉, “Nale la꞉tamo na꞉goemo, ba꞉moi tawakaluba꞉te na milinamehoneha꞉tale huiyatiya gaboeno nakolate na ba adipanatene koamo ba꞉ga꞉litana꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ba꞉bene Ya꞉suti Yelusalema tama꞉mo pete haba da꞉pumiya꞉, ebete ihilo ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","na꞉goiya꞉, “Yelusalema, nale amia꞉no tataba mabuma꞉ deda꞉namo, ama꞉ ba꞉be komo niya꞉tawatale ama꞉ ba꞉be tataba ba꞉laweona꞉, huiyatiya ama꞉ naeno hibi komo umi modoboha꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ba꞉ hibila, tete ba꞉ na꞉pe ama꞉go alaholohopima꞉ deda꞉hana, iba꞉te pelamete ama꞉ kopetanamaminama꞉na꞉ta amia꞉no tawakalubi kanakapulamema꞉, ba꞉bene iba꞉te ama꞉ tametamelo kokonomo siwi ba aligili hunuhunu haka hiya꞉hiya꞉ kododilima꞉na꞉, amia꞉no tawakaluba꞉te ibino ka꞉ka꞉ komula꞉lema꞉ iba꞉te gobogobamo alahutihokapoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ba꞉bene puya꞉te amia꞉no kala imi ipuwalo demedehona, iba꞉te ba꞉bi tawakalubi alukuliti kohawaminadigalema꞉na꞉, ba꞉gala amia꞉no koko genama iya꞉hekete eta nakolate eta nakola hunulu a꞉kitanamene. Iba꞉te ba꞉ma ka꞉na kopododima꞉na꞉ mabu Godote ama꞉ owalubima꞉ da꞉pe, ama꞉ ba꞉be tete otate ebe kalaweha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ba꞉bene Ya꞉suti Godoko Adikumino Hiya꞉ Genamamo tote, ba꞉be genamalo ebete ilina kolowamipi nulamete helonomamo ba neta꞉malatele ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","iba꞉tamo na꞉goiya꞉, “Godokono Bukalo tabo ba꞉ma ka꞉na bitana, ‘Naeno Genama tawakaluba꞉te Godoko Adikumi Genamama꞉ koga꞉lama꞉na꞉,’ la꞉le huiyatiya pilo tawakalubino genamama꞉ a꞉midimata!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ba꞉bema꞉ Godotamo hawa꞉goeno ikamehopino watowatopi, ba꞉gala Godokono Tutumu iya꞉tulamepi, ba꞉gala Yunapino komo kokopi, iba꞉te Ya꞉suku anakapumima꞉ gabo bohowaditiya꞉. Huiyatiya komo hegelalo Ya꞉suti Godoko Adikumino Hiya꞉ Genamalo tawakalubi ba iya꞉tulamita, ");
INSERT INTO knv_aramia_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","iba꞉te gabo kumiya꞉ha꞉ mabu tawakalubi hiliyonomate Ya꞉sukunu tabo ulihoma꞉ ubi konomamo ihatelo iba꞉te eba꞉go ba꞉bo pola꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Eta hegelalo Ya꞉suti Godoko Adikumino Hiya꞉ Genamalo tawakalubi ba iya꞉tulamita Godokono Hido Tabo dolamagitiya꞉, ba꞉ba tetelo Godotamo hawa꞉goeno ikamehopino watowatopi, Godokono Tutumu iya꞉tulamepi, ba꞉gala komo koko dubu, iba꞉te ebe duhimima꞉ ba꞉bo pelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Iba꞉te ebe ba꞉ma ka꞉na palatediya꞉, “A na꞉kiyaa꞉ma꞉, ama꞉ ba꞉moi komo pokono heloamo kododiliona? Ba꞉gala ba꞉moe helo ama꞉tamo pote kikameti?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “Nale la꞉ dopamo kapiya komoma꞉ kalateda꞉lema꞉nemata. Wadiyala la꞉le na na꞉ga꞉lanamiya꞉la꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yonete tawakalubi beyamo da꞉wadulatelenakui, ba꞉be helo ebetamo pote kikami? Godotela꞉ka꞉ o eta lumagitila꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ba꞉bema꞉ ibi ha꞉kiya ibi ipuwalo na꞉ga꞉luya꞉, “Ale da꞉ga꞉lama꞉ Godote Yonetamo helo ikami, ebete kogoema꞉ne, ‘Bada mabuma꞉ la꞉le ebeno tabo hibima꞉ kamidiha꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ba꞉gala a modoboha꞉ ebe ba꞉ma ka꞉na ga꞉lame, hopo lumagiti Yonetamo helo ikami. Tawakaluba꞉te ba꞉be tabo uliti a nakolamo mapea꞉mete kanakapua꞉mema꞉na꞉, mabu iba꞉te na꞉ga꞉lana Yoneko ba꞉ Godokono ukui hawakalimidawala.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ba꞉bema꞉ iba꞉te ibino tepo ipuwoeno ukui ugumuililo Ya꞉sutamo na꞉ga꞉luya꞉, “Yonekono helo mabu a iya꞉tawaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ba꞉ba tetelo Ya꞉suti iba꞉tamo na꞉goiya꞉, “Ba꞉bema꞉ nale la꞉ atumu a꞉kakiyalama꞉mata nale ba꞉moi komo pokono heloamo dododilinamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ba꞉bene Ya꞉suti ba꞉moe iya꞉tulame uwi tawakaluba꞉tamo na꞉goiya꞉, “Dubuti pali ododiti tupina gao keha ba꞉bo amihui, ba꞉be gaoeno mahilo ba꞉ gala꞉ipi gaola. Ba꞉bene ebete ebeno pali komo lawamepi dubatamo dito miya꞉pui, iba꞉te ba꞉bolo oko ba owatina ba꞉be pali hidamo umilo ebeno gao kuwateholemenakoma꞉, ba꞉bene ebete muhulu hopamo tote tete ga꞉ga꞉dopo benemeda꞉tepui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Gao tapiho tetelo ebete pali lawamepa꞉tamo huiyaha꞉ okodawa na꞉poemi, ebete iba꞉godone gaoeno mani ipuwane ebeno namutudawoeno komo kopelawema꞉, huiyatiya iba꞉te ba꞉be okodawa kukamo anagalimihote ilinaheno dito noemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ba꞉bene ebete eta huiyaha꞉ okodawa gala da꞉kapoemi, iba꞉te ebe ba kanagalimiho ebe hilopo ikamete atumu dito koemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ba꞉bene ebete gala eta da꞉kapoemi, ba꞉be ba꞉ netewa-kapiya tete dubula, huiyatiya iba꞉te ebe bugumu miya꞉temete pali ipuwane ebe ba꞉ dito na꞉da꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ba꞉ba tetelo pali namutudawate na꞉goi, ‘Na keba ka꞉na na꞉kewagelemo? Wadiyala nale koamo demalagidolonamo ba꞉be gudu konoemema꞉nemo. Diyala, iba꞉te ebetamo da꞉ papamila꞉halemena꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Huiyatiya ba꞉be pali lawamepi dubate ba꞉be gudu pitalo dumi iba꞉te ibi ipuwalo na꞉ga꞉luya꞉, ‘Numa꞉la꞉, ba꞉moe guduti nabiwino ilina namutudawama꞉ deda꞉mene, ba꞉be guduti ba꞉ na꞉pe. Ba꞉bema꞉ wadiyala ale ebe anakapumiti ebeno pali lawenomo kolawema꞉nema꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ba꞉ba tetelo iba꞉te ebe lawete palino kala ipuwane na꞉da꞉nate ba꞉ dito nanakapumiya꞉.” Ba꞉bema꞉ Ya꞉suti ulihopa꞉tamo na꞉goiya꞉, “La꞉eno ukui keba ka꞉nala꞉ka꞉? Pali namutudawate bada komo na꞉ka꞉pododimini lawamepi dubatamo? ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hibila, ebete pete ibi panakapulamete ebeno pali komopa꞉tamo kopikalamema꞉ne.” Tawakaluba꞉te ba꞉be tabo uliti na꞉ga꞉luya꞉, “Ao, ba꞉be kubate a꞉kuluhukamene!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ba꞉bema꞉ Ya꞉suti ibi ulamelo na꞉goiya꞉, “Godokono Bukalo ditana ba꞉moe taboeno ipuwa keba ka꞉nala꞉ka꞉? ‘Genama etepa꞉te tama꞉mo dihati ba꞉be hototote huiyatiya genamoeno helo mabuma꞉ eda꞉na.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Numa꞉la꞉, ba꞉be hototoeno kodakoda ba꞉ nakola huiyala. Iyo, ba꞉moe nakola hunamo da꞉gamene ba꞉be lumagiti kota꞉ta꞉pula꞉tihoma꞉ne, ba꞉gala ba꞉moe nakolate lumagi dihita꞉timini kotakotakuimima꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ba꞉bene Godokono Tutumu iya꞉tulamepi ba꞉gala Godotamo hawa꞉goeno ikamehopi gawadubu, iba꞉te iya꞉tawahuya꞉ Ya꞉suti ba꞉be uwi ibino komoma꞉ goiya꞉, ba꞉bema꞉ ibi ubila ba꞉ba tetenomolo ebe lawe, huiyatiya tawakalubi ba tolelame gala dito kekelalamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ba꞉bene Yu watowatopa꞉te Ya꞉suku lawema꞉ gabo ba ohowadi komo dubatamo mani ba꞉bo ikalamiya꞉ iba꞉te Ya꞉sutamo tolamete ebe kuba gabamo konemogabuimima꞉. Ibi ubila ebegodolo hiya꞉ tabo uliti ba꞉be taboeno komoma꞉ Loma gabomanino kapela Ko Gawadubutamo magatate, ebete ebe ba꞉bolo kanakapumima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ba꞉bema꞉ ba꞉bi dubate Ya꞉sutamo pelamete ha꞉da amiho gabodo ebe na꞉pega꞉lamiya꞉, “Iya꞉tulamedawa, a iya꞉tawahala ama꞉le dolamaginaka ba꞉bi komokomo ba꞉ hibila, ba꞉gala ama꞉ tawakalubi hunu nikapa꞉mo kulamenaha꞉, ba꞉ma ka꞉na eta lumagi miya꞉palo eta lumagi ebo a꞉kalawa꞉la꞉ta. Iyo, ama꞉ tawakalubi Godokono gabo hidamo iya꞉tulamenata, ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ba꞉bema꞉ a na꞉kiyaa꞉ma꞉, Loma tawakalubino Konomo Gawadubu Sisatamo ta꞉kese mani ikameho hidola꞉ka꞉ o kubala꞉ka꞉? A ebetamo ba꞉kikamehoma꞉ o a꞉kikamehama꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ya꞉suti ibino ma꞉lapila netewa komo iya꞉tawate iba꞉tamo na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“La꞉ mani kapiya natamo nadaha꞉la꞉. Ba꞉be manilo da꞉pola꞉na, mahilo ba꞉gala holoholo pokonola꞉ka꞉?” Iba꞉te ebeno tabo ba huiya na꞉ga꞉luya꞉, “Konomo Gawadubu Sisakonola.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Sisakono ilina Sisatamo nikamehala꞉, huiyatiya Godokono ilina Godotamo nikamehala꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ba꞉bene ba꞉bi dubate kamodobuya꞉ha꞉ tawakalubino holoholo hapulu Ya꞉suku kuba gabamo kemogabuimima꞉, ba꞉bema꞉ iba꞉te ba hanohanoho eta tabo kaga꞉luya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hoe ipuwane mahila꞉haleha꞉ma꞉ da꞉ga꞉lana, ba꞉bi tawakalubi ba꞉ Sa꞉diyusi kapiyuimipila. Komo iba꞉te Ya꞉sutamo pelamete tabo ba꞉ma ka꞉na pega꞉luya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Iya꞉tulamedawa, Godokono Bukamo Mosesete tabo ba꞉ma ka꞉na miya꞉tiya꞉, ‘Dubuti hoete kamena gugudihino da꞉miya꞉pamene, ebeno ekawiti ba꞉be hamole lawete ebeno naniwi mabuma꞉ gugudi nododilima꞉mene.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Dopamo tetelo kapiya dubuino sa꞉ba꞉ni kuhia꞉te nemedenama꞉. Ibi ipuwalo dopo guduti kamena lawete gugudi ulameheno hoiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ba꞉bene ebeno ekawiti ebeno hamole kalawete ba꞉ba ka꞉na kewageliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ba꞉gala eta tetedawate ba꞉ atumu kewageliya꞉, ba꞉bene ba꞉bi sa꞉ba꞉ni badininipalate gugudihino ba꞉ba ka꞉na ha꞉lahuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","huiyatiya kamenate galane dito hoiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ba꞉bema꞉ iba꞉te hoe ipuwane ka꞉ka꞉mo da꞉mahila꞉halemena꞉, ba꞉be Ko Hegelalo ba꞉be kamenate pokono kamenama꞉ na꞉keda꞉mene, mabu ebe sa꞉ba꞉ni dubate a꞉lawa꞉tepahuya꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Numa꞉la꞉, ba꞉moe hopolo dubate kamenakamena uwateholete, ba꞉bene kamenakamenate atumu dubu akuwateholenaka, ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","huiyatiya Godokono Hunu Habalo eba ka꞉naha꞉. Ebete pui ebeno hidohido ga꞉limapi gugudima꞉ da꞉ka꞉lamimini, ba꞉ba꞉te hoe ipuwane hibinomolo ka꞉ka꞉mo komahila꞉halema꞉na꞉, ba꞉bene ba꞉ba tetelo iba꞉te gala kamenakamena a꞉kapuwatehola꞉mena꞉ ba꞉gala dubu a꞉kapuwatehola꞉mena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ba꞉moe komo ba꞉ hibila, iba꞉te hoe ipuwane a꞉mahila꞉haliya꞉, ba꞉bema꞉ iba꞉te Godokono nopopimo ba emedena gala a꞉kaha꞉lahamena꞉, iyo, iba꞉te Godokono gugudima꞉ ba eda꞉ha wiboha꞉ ka꞉ka꞉go bemedehonamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Numa꞉la꞉, tawakaluba꞉te hoe ipuwane da꞉mahila꞉halemena꞉, ba꞉be komo Mosesete a hidamo iya꞉tua꞉miya꞉. Iyo, ebete ba꞉moe komo Godokono Bukamo ihatiya꞉, ba꞉ma ka꞉na koete kehalo da꞉woitiya꞉ huiyatiya kehate ka꞉mutigutiya꞉ha꞉, ba꞉ba tetelo Mosesete Kodawa Godoko ka꞉milo na꞉goiya꞉, ‘A꞉ibalahamako, Aisa꞉keko, Ya꞉ikoboko iba꞉te emedena tetelo poko kadikumina, ama꞉ ba꞉be Godotela.’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ba꞉bema꞉ la꞉ Sa꞉diyusi kapiyuimipi, la꞉eno ukuilo na꞉kemalagidolonama ba꞉bi iniwalino ka꞉ka꞉te a꞉wibuya꞉? Ao, kawibuya꞉ha꞉, mabu ha꞉lahapa꞉te Godoko a꞉kadikuma꞉la꞉ huiyatiya puya꞉te da꞉ka꞉ka꞉halena ba꞉bi tawakalubinomate ebe badikumina, iyo, a hiliyonomate ebeno wiboha꞉ ka꞉ka꞉go bemedenama꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ba꞉ba tetelo komo Godokono Tutumu iya꞉tulamepa꞉te Ya꞉sutamo na꞉ga꞉luya꞉, “Iyo, Iya꞉tulamedawa, ama꞉ hidamo gaa꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ba꞉ hibila, ba꞉ba tetene tupuimiti tawakaluba꞉te Ya꞉suku eta komoma꞉ alateda꞉ma꞉ na꞉toletolehutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Tawakaluba꞉te na꞉ga꞉lana Godokono Oemedawa Kelisoko ba꞉ Da꞉ibidikono hogola, ebeno eyoni gugudi ipuwane komahigama꞉ne. Huiyatiya ba꞉moe komoeno ipuwa keba ka꞉nala꞉ka꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","La꞉ numa꞉la꞉, Da꞉ibiditi Sam Ohale Bukamo tabo ba꞉ma ka꞉na miya꞉tiya꞉, ‘Kodawa Godote naeno Kodawa Kelisotamo na꞉goe, ‘Ama꞉ naeno tu hapuamo na꞉pemeda꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ba꞉bene ama꞉go alaholohopi nale ibi amia꞉no nato a꞉puti bahima꞉ komidilima꞉nemo.’ ’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ba꞉bene Ya꞉suti tabo moga꞉melo gala na꞉kagoiya꞉, “Wadiyala, la꞉ ba꞉moe tabo ba emalagidolo na na꞉kiyanama꞉la꞉, Da꞉ibiditi ebeno hogo Kelisoko ebeno Kodawama꞉ ka꞉milo ebete Godokono tu hapuamo emedema꞉ goiya꞉, ba꞉bema꞉ ba꞉be komote keba ka꞉na na꞉kuluhukumini?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ba꞉bene hiliyonomo tawakaluba꞉te ebeno tabo ba ulihuta Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“La꞉le Godokono Tutumu iya꞉tulamepi hidamo nulama꞉la꞉. Ibi ubila ga꞉ga꞉ga꞉ kaliko pupuliti kolowami habalo ba wapata꞉lame tawakaluba꞉te ibi ba꞉bo kawagaminalema꞉. Iyo, ibi ubila a Yunapino baidi ibubulamehole genama gulu koko dubuino habalo kogagahidima꞉, ba꞉gala ibi ubila poko ododi tetelo koko habalo ahiditi kopola꞉nama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ba꞉gala iba꞉te hamolehamoleno ilina ha꞉da amihoho komodo ba uwate ba꞉bo wibuilamelelamenaka, ba꞉bene iba꞉te ba꞉be komo kubaha꞉ma꞉ ga꞉lalo tolamete Godotamo baidi ba nibubulamehole ga꞉ga꞉ga꞉ toetoe tabo ba꞉bo nega꞉lanaka, mabu ibi ubila tawakaluba꞉te ibino komo umilo ibi hidohidopima꞉ koga꞉lama꞉. Ba꞉bema꞉ hibila, iba꞉te kuba huiya konomo kolawema꞉na꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ba꞉bene Ya꞉suti Godoko Adikumino Hiya꞉ Genamalo ba luta, ilina dogodogopa꞉te ibino malemale ilina Godotamo da꞉pemiya꞉titiya꞉, ebete ibino komo ba umita ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","eta ilinaha꞉ hamole kamena ba꞉bo kumiya꞉, ebete mani hegehege netewa da꞉pemiya꞉tiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ba꞉bema꞉ ebete na꞉goiya꞉, “Na la꞉tamo hibi tabo begoemo, tawakaluba꞉te mani da꞉pemiya꞉ta꞉ ba꞉moe ilinaha꞉ hamole kamenate ibi hiliyonomo a꞉gogole, ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","mabu ilina dogodogopa꞉te ibino komo ilina da꞉luhililamenaka ba꞉bi ilina bepemiya꞉ta꞉, huiyatiya ba꞉moe hamole kamena ilinahenola. Ebete ebeno baa꞉ uwatehoeno mani miya꞉tenomo a꞉pemiya꞉te.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ba꞉ba tetelo komo Ya꞉suku ta꞉matapa꞉te Godoko Adikumino Hiya꞉ Genamama꞉ ba꞉ma ka꞉na ga꞉litiya꞉, “Ba꞉moi koko nakola genama hidohidonomola! Ba꞉gala tawakaluba꞉te ba꞉malo Godotamo malemalelo dikamehonaka, ba꞉bi ilinate hidohidoma꞉ eda꞉hana!” Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“La꞉ ba꞉moi ilina dulameholitama, galane tetelo ibi hiliyonomate kokubakubahama꞉na꞉. Ba꞉ba tetelo ba꞉moi genamoeno komoma꞉ eta nakolate eta nakola hunulu a꞉kapola꞉namena꞉, mabu alaholohopa꞉te nakola hiliyonomo mapitahalete hopamo iya꞉hekenomo kopiya꞉hekema꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ba꞉bene iba꞉te Ya꞉suku nalatediya꞉, “Iya꞉tulamedawa, Godokono Genama kubahimi komote keba tetelo na꞉kuluhukumini? A bada hanohano komate na꞉kiya꞉tua꞉memena꞉ tete ba꞉ na꞉pe ba꞉be komote kopuluhukuma꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ hidamo. Eta lumagiti la꞉ ha꞉da damiholamemena꞉, la꞉ ebeno tabo akulia꞉la꞉, mabu komo hiliyonomo dubate naeno mahilamo pelamete kopega꞉lama꞉na꞉, ‘Na ba꞉ Kelisotela! Tete ba꞉ na꞉pe!’ huiyatiya la꞉ ibi akata꞉matala꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ba꞉gala la꞉le hiya꞉hiya꞉ hopo tawakalubino alaholoho komo ba꞉gala ibino alaholohoma꞉ nopo tamote komo dulihoma, ba꞉be mabuma꞉ la꞉ koamo akatoletolehala꞉. Ba꞉moi komate hibilo kopikulima꞉na꞉, huiyatiya ba꞉be tete ebe kuititi teteha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ya꞉suti iba꞉tamo gala na꞉kagoiya꞉, “Ba꞉ hibila, komo hopo tawakaluba꞉te komo hopo tawakaluba꞉go kalaholohoma꞉na꞉, iyo, eta hopote etatamo alaholo komo kododima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ba꞉bene koko wima꞉la꞉te hiya꞉hiya꞉ hopo hiliyonomamo kopelamema꞉na꞉, ba꞉gala koko tawetaweno temeteme komate ba꞉bi hiya꞉hiya꞉ tawakalubi kuwatema꞉na꞉, ba꞉gala komo habahabalo tawakaluba꞉te baa꞉heno kemedehoma꞉na꞉, ba꞉bene ba꞉be atu tetelo alomo hunulu hanohano komokomo ba꞉gala Godokono helo hawakalimino komate kopikulihoma꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ba꞉moi komate ikulihino kubapa꞉te dopamo la꞉ heloamo uwatete temeteme ba꞉bo kikalamema꞉na꞉ta. Iyo, Yunapino baidi ibubulamehole genama gulu iba꞉te la꞉eno komo anagilamelelamete la꞉ du genamamo dito komiya꞉tema꞉na꞉ta, ba꞉gala na mabuma꞉ iba꞉te la꞉ hiya꞉hiya꞉ koko gawadubuino holoholo hapuamo magatalete, iba꞉te atumu la꞉eno komo kakanagilamelelamema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ba꞉ba tetelo la꞉ huiyatiya iba꞉tamo naeno Hido Tabote nolamagimiya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ba꞉bema꞉ la꞉le ibino holoholo hapulu ba la꞉mota꞉hana la꞉eno mahilo keba ka꞉na da꞉hiduilamema, ba꞉be tetete uluhukuhino la꞉eno ga꞉la komoma꞉ aka-ukuibilibilihala꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","mabu nale la꞉tamo mulu ukui ba꞉gala tabo ba ikalame, puya꞉te la꞉go alaholohopima꞉ deda꞉hana iba꞉te la꞉eno hibi tabo kubahilamema꞉ a꞉kamodobamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Ba꞉gala eta komo. La꞉eno nabi ba꞉gala menokobi, nani ba꞉gala ekaki, la꞉eno komo hawi tawakalubi ba꞉gala mabulubi, iba꞉te la꞉go dalaholohona ba꞉bi kubapino kokotamo la꞉ konemiya꞉tema꞉na꞉ta, iyo, komo la꞉ la꞉eno tawakaluba꞉te dito kanakapulamema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ba꞉ hibila, na mabuma꞉ hiliyonomo tawakaluba꞉te la꞉tamo komaubahama꞉na꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","huiyatiya naeno umi ipuwalo la꞉eno watoeno hinibo eta kapiyate a꞉kalatida꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ba꞉bema꞉ la꞉eno kodakodalo utitata komodo la꞉le la꞉eno ka꞉ka꞉ ba꞉ ba꞉ma ka꞉na komula꞉lema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Hiya꞉hiya꞉ hopoeno alaholohopa꞉te pelamete Yelusalema da꞉petanamaminamena꞉, la꞉ ba꞉be komo dumima la꞉ kiya꞉tawahama꞉nemata ebeno olalati tete ba꞉ a꞉puluhuku. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ba꞉bema꞉ alaholohopa꞉te pikulihoheno, wadiyala Yudiya hoponapa꞉te dopamo hunuhunu hakamo nalahutihamena꞉, ba꞉gala Yelusalemalo demedehona ibi atumu gobogobamo na꞉katolama꞉mena꞉. Numa꞉la꞉, ba꞉ba tetelo puya꞉te tumulu da꞉pola꞉namena꞉ iba꞉te ko haboeno kala imi ipuwamo na꞉pa꞉la꞉ha modoboha꞉, mabu iba꞉te ba꞉bolo hido awalela bahi a꞉kanuma꞉mena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ba꞉ hibila, Godote dopamo ebeno Bukamo da꞉miya꞉tiya꞉ ba꞉bi komate hibinomolo kopikulima꞉na꞉, iyo, ba꞉be tete ba꞉ Yelusalema haboeno kuba huiya lawe hegelala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ba꞉bema꞉ numa꞉la꞉, lamitulamitu ba꞉gala nono dikalamena ba꞉bi kamenakamenatamo ba꞉be hegelate kubanomoma꞉ keda꞉ma꞉ne, mabu hibila, Godokono konomo mauba komote Yelusalemanapa꞉tamo ba itana, ibino hopolo koko tepo temetema꞉te kopikulihoma꞉na꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Iyo, alaholohopa꞉te komo ibi alaholoho gila꞉mo kanakapulamema꞉na꞉, ba꞉gala komo ibi hala꞉mo matuhulameholete hiya꞉hiya꞉ muhulu hopamo komagatalema꞉na꞉, ba꞉bene hibima꞉ midiha꞉pa꞉te Yelusalema haba ibino natamo komikitama꞉na꞉, Godote iba꞉tamo dikalamemene ba꞉be tete kuitita꞉mo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ba꞉bene hegela, manome, ba꞉gala oloki, ibi ipuwalo koko hanohano komate dikulihomena꞉, ba꞉moe hopo konomolo tawakaluba꞉te ukui bilibilima꞉ ba eda꞉ha baidi kohoba꞉midalema꞉na꞉, iyo, ba꞉be atu tetelo kehaha꞉ kolomoeno koko gawiyate pakaminate haka dodo da꞉palukulimina꞉, iba꞉te ba꞉be beyoeno diyamo dulimina꞉ konomamo kotoletolehoma꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ba꞉gala ba꞉ba tetelo alomoeno helohelo ilinate komidiwiholema꞉na꞉, ba꞉bema꞉ tawakaluba꞉te ba꞉moe hopoeno ko olalati komo ba latimi, iba꞉te tole konomo lawete heloha꞉ma꞉ ba꞉bo keda꞉hama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ba꞉bene ba꞉ba tetelo Tawakalubino Naniwiti alomo hununi ba pihitiga iba꞉te ebe ba꞉bo kumima꞉na꞉, ebete ebeno heloago ba꞉gala alo konomago kopema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ba꞉bema꞉ ba꞉moi temeteme komate ikuli da꞉tupuimimina꞉, ba꞉ba tetelo la꞉ hunamo na꞉negahilameholiya꞉la꞉ mabu la꞉eno ka꞉ka꞉ mula꞉le tete ba꞉ na꞉tatali.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ba꞉bene Ya꞉suti go tabo iba꞉tamo ba꞉ma ka꞉na iya꞉tulamiya꞉, “La꞉ anahu keha ba꞉gala hiya꞉hiya꞉ kehoeno komo hidamo nemalagidola꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","La꞉le ibino paha mogolame dulamema, ba꞉be komote la꞉ kiya꞉tulamema꞉na꞉ta gogoeno tete ba꞉ na꞉tatali, ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ba꞉bema꞉ ba꞉moi temeteme komate ikuliholo dulamema, la꞉ kiya꞉tawahama꞉nemata Godokono Ko Gawadubu tete ba꞉ na꞉pe. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Na la꞉tamo hibi tabo begoemo, ba꞉moi hiliyonomo komate dopamo kopikulihoma꞉na꞉, galane ba꞉ma tete tawakaluba꞉te ba꞉bo koha꞉lahama꞉na꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","iyo, ba꞉moe hopo ba꞉gala alomo iba꞉te kowiboma꞉na꞉, huiyatiya naeno tabote a꞉kawibamene, itana tetelo bitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“La꞉ ha꞉kiya la꞉ hidamo nulamenala꞉! La꞉ baa꞉ naha komoma꞉, ba꞉gala helo gao beya niho komoma꞉, ba꞉gala ba꞉moe hopoeno ilina uwate komoma꞉ aka-ukuibilibilihala꞉. La꞉ hidamo, ba꞉be Ko Hegelate tiyonomolo da꞉puluhukumini la꞉ konomamo la꞉wa꞉hademata, ba꞉moe komo ba꞉ gubiti ilina danagalimi keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Iyo, ba꞉be Ko Hegelate ba꞉moe hopolo demedehona ba꞉bi tawakalubi hiliyonomatamo ba꞉ma ka꞉na kopema꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ba꞉bema꞉ hiliyonomo tetelo la꞉ uliholo ba emedena Godotamo na꞉toetoehonala꞉. Ba꞉be komo ipuwalo la꞉le ebeno helo lawete, koko temetema꞉te da꞉pelamemena꞉ la꞉ ba꞉bi ipuwado nikuliti Tawakalubino Naniwino dopo hapulu konela꞉mota꞉hanama꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ba꞉bene komo hegelalo Ya꞉suti Yelusalemamo da꞉penakui, ebete Godoko Adikumino Hiya꞉ Genamalo tawakalubi piya꞉tulamenakui, huiyatiya da꞉dunakui ebete habane gala kuluhukunakui Olibi Kehakeha Hunu Hakalo ba꞉bo newatanakui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ba꞉ba tetelo tawakalubi hiliyonomate duiduiyanomolo Godoko Adikumino Genamamo pelamenakuya꞉ ebeno tabo kopulihoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hunamo Mahigaha꞉ Palawa Baa꞉ Poko ebeno eta mahilo ba꞉ Adaguila꞉ Pokola, ebeno ododi komo da꞉tataliya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ba꞉ba tetelo Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala Godokono tutumu iya꞉tulamepi dubu, iba꞉te Ya꞉suku anakapumi gabo bohowaditiya꞉, huiyatiya iba꞉te tawakalubi tolelamelo hawakala kododitiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ba꞉bene Saitanate Keliyotanapi Yudasikono tepo ipuwamo opeguya꞉, Ya꞉sukunu 12 ta꞉matapi ipuwalo ebe ba꞉ etala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ebete Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala Godoko Adikumino Genama lawamepi dubu iba꞉tamo tote nopo ba꞉bo netamotiya꞉ Ya꞉suku ibino kokotamo kihatema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ba꞉ba tetelo iba꞉te ba꞉be komo uliti kalakalahalo tabo ba꞉bo ihatiya꞉ ebetamo mani kikamema꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ba꞉bema꞉ Yudasiti ibino tabamo papamiwatate, iba꞉godone tote gabo ba꞉bo nohowadiya꞉ tawakalubiha꞉ tetelo Ya꞉suku ibino kokotamo kihatema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yunapino ododi komo ba꞉ma ka꞉nala, iba꞉te hiliyonomo gogolo Hunamo Mahigaha꞉ Palawa Baa꞉ Poko naha da꞉tupuiminakui, ba꞉be dopo hegelalo iba꞉te Adaguila꞉ Pokoeno sipi-goegoe hegehege balukulinakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ba꞉bema꞉ Ya꞉suti Pitako Yoneko ibi netewapi ba noelame na꞉goiya꞉, “La꞉ tote Adaguila꞉ Pokoeno naha ilina na꞉nihiduilamiya꞉la꞉, ale kopenahama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Iba꞉te ebetamo na꞉ga꞉luya꞉, “Ale kebolo na꞉ka꞉nihiduilamema꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ebete iba꞉tamo na꞉huiyuya꞉, “La꞉ ko habamo na꞉toala꞉, ba꞉bene beya dagahita ba꞉be dubuti la꞉go da꞉palugamene, la꞉le ebe ba꞉bo na꞉ta꞉matuya꞉la꞉. Ebete kebe genamamo da꞉nodolomene, ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","la꞉ ba꞉be genama namutudawatamo ba꞉ma ka꞉na na꞉nega꞉luya꞉la꞉, ‘Iya꞉tulamedawate ama꞉tamo goe, genama keka꞉ nale naeno ta꞉mahenepa꞉go Adaguila꞉ Poko baa꞉ kopenama꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ba꞉ba tetelo ebete la꞉ genama guamo komagatalema꞉na꞉ta, hunu genamalo haba ko bitana, ya꞉lo a꞉hiduima꞉ka. La꞉ ba꞉bolo naha ilina na꞉nihiduilamiya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ba꞉bene iba꞉te tote, Ya꞉suti kebe komoma꞉ ka꞉kiyalamiya꞉, iba꞉te ba꞉bi komo nulamete Adaguila꞉ Pokoeno ilina ba꞉bo nihiduilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tete da꞉peniya꞉ Ya꞉suti ebe oelamepi dubago baa꞉ nahama꞉ ahidiniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ba꞉bene ebete iba꞉tamo na꞉goeniya꞉, “Na ubi konomamo nihatenatimo, nale hoeheno dopamo ba꞉moe Adaguila꞉ Poko la꞉go konama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ba꞉bema꞉ nale la꞉tamo na꞉goemo, nale ba꞉moe poko baa꞉ ba꞉ma tetelo gala a꞉kanamo, huiyatiya Godokono Ko Gawadubu tete da꞉pemene, ba꞉ba tetelo ba꞉moe pokoeno ipuwate hibinomolo da꞉hawakalamene nale ba꞉bo konama꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ba꞉bene Ya꞉suti kalili lawenate Godotamo kalakala tabo olamaginate iba꞉tamo na꞉goeniya꞉, “La꞉ ba꞉moe kalili lawete, la꞉ ipuwalo etate etatamo kikame, etate etatamo kikame, ba꞉ma ka꞉na newagela꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nale la꞉tamo na꞉goemo, na ba꞉ma tetelo ba꞉moe helo gao beya gala a꞉kana꞉mo, huiyatiya Godokono Ko Gawadubu tete da꞉pemene, ba꞉ba tetelo nale ba꞉bo konima꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ba꞉ba tetelo ebete baa꞉ kalawenate Godotamo kalakala tabo olamaginate, wakamihonate iba꞉tamo ba ikalamena na꞉goeniya꞉, “Ba꞉moe ba꞉ naeno apela, la꞉ mabuma꞉ Godotamo ikamemo. La꞉le na emalagidolonelo ba꞉moe komo nododinakuya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ba꞉bene ibino baa꞉ naha komo da꞉wiboniya꞉, ebete kalili gala kalawenate na꞉goeniya꞉, “Ba꞉moe kalili ba꞉ Godote tawakaluba꞉go komiloma꞉ uli nopo da꞉tamotiya꞉ ba꞉moe ba꞉be komola. La꞉ mabuma꞉ da꞉ka꞉ka꞉la꞉mene, ba꞉moe naeno hawiti ba꞉be nopo bekodakoduimina. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“La꞉ numa꞉la꞉! Na anakapunamepa꞉tamo dikanamemene, ba꞉be lumagiti nago ba꞉moe baa꞉ naha habalo ba꞉luta! ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Iyo, ba꞉ hibila, Tawakalubino Naniwiti hoea꞉mo ba꞉ na꞉to, Godote nopo dopamo da꞉tamotiya꞉ ba꞉ba ka꞉na, huiyatiya kebe lumagiti ebe anakapumipa꞉tamo dikalamemene, ba꞉be dubuti kuba huiya konomo kolawema꞉ne!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ba꞉bene ibi ha꞉kiya ibi ipuwalo etate eta goemenakui, etate eta goemenakui, ba꞉ba ka꞉na ba ewagelena na꞉ga꞉laniya꞉, “Ba꞉moe kuba pote na꞉kododimini?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ba꞉ba tetelo Ya꞉suku ta꞉matapi ipuwalo pote koma꞉ eda꞉ komoma꞉ olowabeletihui komote uluhukuniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Godoko hibima꞉ midiha꞉pino koko gawadubate ibi ha꞉kiya ibi ba wadiya꞉paa꞉latele komo tawakalubi bikiyahalamenaka iba꞉te ibino ubi komamo kopapamila꞉halenama꞉, ba꞉gala ba꞉bi kokopi ubila tawakaluba꞉te ibi owalubilipima꞉ ba ka꞉lami ibi ba꞉bo komililameholema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Huiyatiya la꞉eno komo eba ka꞉naha꞉. Wadiyala la꞉ ipuwalo kodawate uli ape lumagi kebanala꞉ka꞉ ba꞉bakoma꞉ neda꞉mene, ba꞉gala la꞉eno watodawate atumu ebe huiyaha꞉ okodawa kebanala꞉ka꞉ ba꞉bakoma꞉ na꞉keda꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Numa꞉la꞉, hidohido baa꞉ naha habalo da꞉luta tawakaluba꞉te ba꞉bako lumagi kodawama꞉ ga꞉lanaka, huiyatiya kebe lumagiti ebetamo baa꞉ dadahemenako iba꞉te ebe huiyaha꞉ okodawama꞉ ga꞉lanaka. Ba꞉ hibila, na huiyaha꞉ okodawa kebanala꞉ka꞉, nale la꞉ ipuwalo ba꞉bako deha꞉potodawama꞉ eda꞉namo, ba꞉bema꞉ wadiyala la꞉ atumu ba꞉ba ka꞉na nemedeniya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Hibila, naeno kodakoda komo ipuwalo da꞉lutanakuimo, la꞉le na kamiya꞉panenakuiha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ba꞉bema꞉ Nabiwiti na Ko Gawadubuma꞉ keba ka꞉na ka꞉midiniya꞉ nale la꞉ atumu ba꞉ba ka꞉na kakamidilima꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ba꞉bene na Godokono Hunu Habalo Ko Gawadubuma꞉ ba neda꞉, la꞉ nago poko baa꞉ nahate gao beya ba꞉bo konihoma꞉nemata, ba꞉gala la꞉ koko gawadubuino gagahidi bahilo gagahiditi Isalaela 12 gu tawakalubino komokomo anagilamelelamepima꞉ keda꞉hama꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ba꞉bene Ya꞉suti na꞉goeniya꞉, “Saimono, Saimono, ama꞉ nulia꞉. Dubuti witi-laisoeno komo kumima꞉, da꞉ hidola꞉ o da꞉ hidoha꞉, ebete keba ka꞉na kanamogolenako, Saitanate ubila ama꞉ kuba gabamo ba꞉ba ka꞉na kemogabuimima꞉, ba꞉bema꞉ Godote ba꞉be komo iya꞉tawate ebetamo modoboma꞉ goe. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ba꞉bema꞉ Saimono, nale ama꞉ mabuma꞉ Godoko a꞉toemehakamo, ebete ama꞉ ba owalubi amia꞉no hibima꞉ midi komote a꞉kalatida꞉mene. Ama꞉ natamo gala da꞉kohobigamena꞉, ba꞉ba tetelo amia꞉no ekaki na꞉heluilamiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pitate ebetamo na꞉huiyaniya꞉, “Kodawa, nale ama꞉go du genamamo tote da꞉nehoemo, na ba꞉be komoma꞉ a꞉hidomo!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ya꞉suti huiyatiya na꞉goeniya꞉, “Pita, na ama꞉tamo na꞉goemo, ka꞉lo dulu kakabate goehoheno ama꞉ netewa-kapiya teta꞉mo na iya꞉tawaha꞉ma꞉ kogoema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Nale la꞉ dopamo da꞉noelamima, la꞉ ba꞉ma ka꞉na a꞉kiyahalamia꞉mata, ‘Manihino, hikaheno, ba꞉gala nato ilinaheno na꞉tolamiya꞉la꞉,’ ba꞉bema꞉ ba꞉ba tetelo la꞉ modoboha꞉ komo a꞉ka꞉niya꞉tawahuima?” Iba꞉te na꞉huiyaniya꞉, “Ao, eta awae komo kanumiha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Ka꞉lo huiyatiya na eta tabo ba꞉ma ka꞉na goemo, ale ba tolame la꞉godolo mani o baeno hika da꞉pola꞉lama꞉na nuwatiya꞉la꞉, ba꞉gala pogodolo alaholo gili itanaheno, wadiyala ebete ebeno atuino kaliko nekolowamiti huiyatiya helo giliti na꞉lawa꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mabu na la꞉tamo na꞉goemo, Godote naeno komoma꞉ ebeno Bukamo da꞉miya꞉tiya꞉, tete ba꞉ na꞉pe ba꞉be komote kuluhukuma꞉ne, iyo, buka tabote ba꞉ma ka꞉na goena, ‘Iba꞉te ebe kubapa꞉go kapiyama꞉ midiya꞉.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ba꞉bene iba꞉te na꞉ga꞉laniya꞉, “Kodawa, ama꞉ numa꞉. Mola, alaholoho gili netewa ba꞉pola꞉na!” Ya꞉suti na꞉huiyaniya꞉, “A꞉iye! La꞉ naeno taboeno ipuwa hidamo kalawenaha꞉. Ba꞉ba꞉la, nitanana.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ba꞉bene Ya꞉suti Yelusalema habane uluhukunate ebete dopamo keba ka꞉na kododinakui, ba꞉ba ka꞉na ebete ebe ta꞉matapa꞉go Olibi Kehakeha Hunu Hakamo dito tolameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ebete ba꞉be hakamo nuluhukunate ibi na꞉goelameniya꞉, “La꞉ ba꞉malo Godotamo na꞉toetoehonala꞉ mabu la꞉le Saitanakono kuba gabamo emogabuimi komamo gudidimata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ba꞉bene ebete ibi miya꞉palenate nanekela꞉mo tonate, ba꞉ba tetelo ebete pupamo nemedenate Godotamo ba꞉bo netoetoeniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ebete na꞉goeniya꞉, “Nabiwi, ama꞉ ubi dihatemena꞉ ba꞉moe temeteme kalili nagodone na꞉lawa꞉. Huiyatiya naeno ubiha꞉, ama꞉ ha꞉kiya amia꞉no ubila nododa꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ba꞉ba tetelo Godokono Hunu Habane nopodawate ebetamo puluhukunate ebe ba꞉bo peheluiminiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ba꞉gala ebete tepo temeteme konomoma꞉ eda꞉nate helonomamo Godotamo ba toetoena, ebeno kolohate hawima꞉ eda꞉hamenate hakamo ba꞉bo ka꞉ka꞉la꞉hameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ba꞉bene ebete toetoe tabo ga꞉la bahini mahiganate ebe ta꞉matapa꞉tamo da꞉peniya꞉ iba꞉te tepo temetema꞉go lahanalo pulameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ebete iba꞉tamo na꞉goeniya꞉, “La꞉ bada mabuma꞉ ka꞉lahonama? La꞉ pakaminate Godotamo na꞉toetoehonala꞉, mabu la꞉le Saitanakono kuba gabamo emogabuimi komamo gudidimata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ya꞉suti ba꞉be tabo ba goena, ebeno ta꞉matapi 12 ipuwalo eta dubu Yudasiti komo dubu hiliyonomo dopalamenate iba꞉te kapimilo ba꞉bo pelameniya꞉. Ba꞉bene ebete Ya꞉sutamo nolata tabo goenate ebe kopaboetehonama꞉ tama꞉mo da꞉peniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ya꞉suti ebetamo na꞉goeniya꞉, “Yudasi, ama꞉ Tawakalubino Naniwi ba paboeteho ebe anakapumipa꞉tamo ikalamema꞉ ka꞉pa꞉wa?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ba꞉bene Ya꞉suku lawe komote uluhukuma꞉ ba pena, ebe ta꞉matapi dubate ba꞉be komo uminate na꞉ga꞉laniya꞉, “Kodawa, ale ibi alaholo gila꞉mo ba꞉kalukulima꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ba꞉bene ibi ipuwalo etate mahiganate Godotamo hawa꞉goeno ikamehopino Hununomo Watodawoeno genama okodawa anagaliminate ebeno tu hapu galo ba꞉bo mapitamidameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ya꞉suti huiyatiya ibi na꞉kiyahalameniya꞉, “Ba꞉ba꞉la, nekelamenata!” ba꞉bene ebete ba꞉be dubuino galo dologiminiya꞉ ba꞉ba tetelo na꞉hidoniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ba꞉bene Godotamo hawa꞉goeno ikamehopino watowatopi, ba꞉gala Godoko Adikumino Genama lawamepi dubu, ba꞉gala komo koko dubu, iba꞉te Ya꞉suku lawema꞉ da꞉pelameniya꞉ ebete iba꞉tamo na꞉goeniya꞉, “Na pilo lumagila꞉ka꞉, o na alaholodawala꞉ka꞉? La꞉le na lawenema꞉ alaholoho gila꞉go ba꞉gala kukago badama꞉ ka꞉pelameoma? ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na komo hegelalo Godoko Adikumino Hiya꞉ Genamalo la꞉eno holoholo hapulu da꞉pelutanakuimo, ba꞉ba tetelo la꞉le na kalaweneha꞉. Huiyatiya ba꞉moe du la꞉eno tetela, iyo, du namutudawama꞉ deda꞉na ebeno helo tetete ba꞉ a꞉puluhuku.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ba꞉ba tetelo iba꞉te Ya꞉suku kokotamo kodakodanomolo lawenate, Godotamo hawa꞉goeno ikamehopino Hununomo Watodawoeno genamamo magataniya꞉, huiyatiya Pitate ibi muhuludopone ta꞉mataleniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ba꞉bene komopa꞉te genamoeno kala ipuwalo koe emadonate ba pola꞉na, Pitate kala imi ipuwamo na꞉pa꞉ganate iba꞉go ba꞉bo nilutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ba꞉ba tetelo Pitate koeno alolo ba niluta, oko bohelete ebe hidamo uminate na꞉goeniya꞉, “Ba꞉moe dubu atumu Ya꞉sukuba꞉ pata꞉nami!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pitate huiyatiya na꞉goeniya꞉, “Kamena, na iya꞉tawaha꞉ ebe!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ba꞉bene iba꞉te tete nanekelelo pola꞉natepanate, eta dubuti ebe hidamo uminate gala na꞉kakiyameniya꞉, “Ama꞉ ba꞉ atumu ebe ta꞉matadawa etala!” Pitate huiyatiya na꞉goeniya꞉, “Dubu, na ebe iya꞉tawaha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tete nanekela꞉mo kodopo da꞉kapetoniya꞉, eta dubuti helodopamo na꞉kagoeniya꞉, “Hibila, ba꞉moe dubu Ya꞉sukuba꞉ pata꞉nami, mabu ebe Ga꞉lili hoponapila!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pitate huiyatiya na꞉goeniya꞉, “Dubu, ama꞉ da꞉goena ba꞉be taboeno komo na iya꞉tawaha꞉!” Ba꞉ba tetenomolo ebete ba꞉be tabo ba goena kakabate na꞉goehoniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ba꞉bene Kodawa Ya꞉suti ohobiganate da꞉negahiminiya꞉ Pitako ba꞉bo numiniya꞉. Ba꞉ba tetelo Ya꞉suti ebetamo dopamo kebe tabo ka꞉goeniya꞉, Pitate ba꞉be tabo ba꞉bo emalagidoloniya꞉, “Ka꞉lo dulu kakabate goehoheno, ama꞉le netewa-kapiya teta꞉mo na iya꞉tawaha꞉ma꞉ kogoema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ba꞉bene Pitate gobogobamo tonate konomo tepo temetema꞉go ibulunomo ba꞉bo nihiniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ba꞉bene Godoko Adikumino Genama lawamepi dubate Ya꞉suku ba walitina ba꞉bo anagalimihoniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Iba꞉te kalikamo ebeno holoholo mula꞉menate ebe anagalimiholo na꞉ga꞉laniya꞉, “Ama꞉ Godokono ukui hawakalimidawama꞉ hibilo deda꞉na, ama꞉ na꞉gaa꞉ puya꞉te kanagalimihotana!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ba꞉gala iba꞉te ebe ba iduduputimina komo hiliyonomo kubakuba tabo ebetamo ba꞉bo olamagiminiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ba꞉bene hegela owaloho hapuamo Godotamo hawa꞉goeno ikamehopino watowatopi, ba꞉gala Godokono Tutumu iya꞉tulamepi, ba꞉gala Yunapino komo kokopi, iba꞉te kapiyuiminate komopa꞉te Ya꞉suku ibino dopo hapuamo magatanate na꞉ga꞉lameniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ama꞉ a na꞉kiyaa꞉ma꞉, ama꞉ ba꞉ Godokono Oemedawa Kelisotela꞉ka꞉?” Ebete huiyatiya iba꞉tamo na꞉goeniya꞉, “Nale la꞉eno tabo hibinomolo da꞉huiyamo la꞉ hibima꞉ a꞉kamida꞉mata, ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ba꞉gala nale la꞉ eta komoma꞉ dalateda꞉lema, ba꞉ba tetelo la꞉le natamo huiya tabo hidamo a꞉kaga꞉lamata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ba꞉ hibila, na Tawakalubino Naniwiti ba꞉ma tetene tupuimiti Helodawa Godokono tu hapulu konilutama꞉nemo!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ba꞉ba tetelo ibi hiliyonomate na꞉ga꞉laniya꞉, “Amia꞉no taboeno ipuwa keba ka꞉nala꞉ka꞉? Ama꞉ ba꞉ Godokono hibi Gudula꞉ka꞉?” Ebete iba꞉tamo na꞉huiyaniya꞉, “La꞉ ba꞉ a꞉ga꞉lamata.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ba꞉bema꞉ iba꞉te na꞉ga꞉laniya꞉, “A ba꞉moe dubuino kuba kiya꞉tawahama꞉ eta tabo goedawa a ubihinola, mabu a ha꞉kiya ebeno tabonomone ba꞉ ulima꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ba꞉bene ibi hiliyonomate mahila꞉halete Ya꞉suku lawete Paeletetamo ba꞉ dito magatuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Iba꞉te ebeno komo ba anagilameleme Paeletetamo na꞉ga꞉luya꞉, “A ba꞉moe dubu umima꞉ ebete aeno tawakalubi ba iya꞉tulamita da꞉kubahilamiti, ebete ibi ba꞉ma ka꞉na duhilami iba꞉te Konomo Gawadubu Sisatamo ta꞉kese mani ikamehoma꞉, ba꞉gala ebete iba꞉tamo na꞉goenako ebe ba꞉ Kelisotela, Ko Gawadubula.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ba꞉bema꞉ Paeletete ebe nalatediya꞉, “Ama꞉ Yu tawakalubino Ko Gawadubula꞉ka꞉?” Ya꞉suti ebetamo na꞉huiyuya꞉, “Ama꞉le ba꞉ a꞉gaa꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ba꞉bene Paeletete Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala tabo ulihoma꞉ da꞉pelamiya꞉ ba꞉bi tawakalubi hiliyonomatamo na꞉goiya꞉, “Na ba꞉moe dubuino eta kuba kumitaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Huiyatiya iba꞉te helonomamo gala na꞉kaga꞉luya꞉, “Ebete dopamo Ga꞉lili hopone tupuimiti ba꞉mamo puluhuku tawakalubi kubamo iya꞉tulamenakui, ba꞉ma ka꞉na Yudiya hopo konomolo ebete ibi na꞉kiyalamenako iba꞉te gabomana꞉tamo alaholoho komo kododima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Paeletete ibino tabo uliti ebe ha꞉kiya ebetamo na꞉goiya꞉, “Ehe, ba꞉moe dubu ba꞉ Ga꞉lili hoponapila!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ba꞉ba tetelo Paeletete iya꞉tawuya꞉ Heloditi Yelusalema ko habalo emeda꞉tepama꞉ da꞉piya꞉, ba꞉bema꞉ ebete Ya꞉suku ebetamo ba꞉ dito noemiya꞉ mabu Helodiko Ga꞉lili hopoeno Ko Gawadubula ba꞉gala Ya꞉suku ba꞉be hopone piya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ba꞉bene Heloditi Ya꞉suku umiti konomamo kalakaluya꞉, mabu ebete Ya꞉sukunu ododili komokomo ulihote tete ga꞉ga꞉nomolo ebe umima꞉ ubi ba ihatena ba꞉ma ka꞉na emalagidolonami, “Diyala, Ya꞉suti naeno holoholo hapulu eta hanohano komo da꞉ ododimini.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ba꞉be mabuma꞉ Heloditi Ya꞉suku hiliyonomo komokomoma꞉ nalateda꞉huya꞉, huiyatiya Ya꞉suti ebetamo eta tabo kapiya kagoiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ba꞉bene Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala Godokono Tutumu iya꞉tulamepi, iba꞉te mahila꞉halete Ya꞉sukunu komo ba anagilameleme ebe kuba lumagima꞉ ga꞉lalo helonomamo ga꞉luya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ba꞉gala ba꞉be atu tetelo Heloditi ebeno alaholohopa꞉go Ya꞉suku iduduputimilo niya꞉da꞉titiya꞉. Ba꞉be iya꞉da꞉ ipuwalo iba꞉te koko gawadubate da꞉pupulinaka ba꞉bako kaliko ebetamo pulimiti, ba꞉bene Heloditi ebe Paeletetamo gala ba꞉ba ka꞉na kanoemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ba꞉gala ba꞉moe ba꞉ eta komola. Helodiko ba꞉gala Paeleteko ibi netewapa꞉te dopamo etate etatamo maubanakui ba꞉ba ka꞉na ewagelenama꞉, huiyatiya ba꞉moe hegelane tupuimiti iba꞉te mabulubima꞉ hibinomolo ediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ba꞉bene Paeletete Godotamo hawa꞉goeno ikamehopino watowatopi, ba꞉gala Yunapino komo koko dubu, ba꞉gala puya꞉te ibino tabo ulihoma꞉ da꞉pelamiya꞉, ibi hiliyonomo ebetamo ka꞉lamiti, ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","iba꞉tamo na꞉goiya꞉, “La꞉ ba꞉moe dubu natamo tawakalubi kubahilamedawamo magahemata, huiyatiya nale la꞉eno holoholo hapulu ebeno komokomo danagilamelememo ebegodolo eta kuba kumiha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ba꞉gala Heloditi atumu ebegodolo eta kuba kumimiha꞉, ebete ebe atamo ba꞉bema꞉ kapoeme. Hibila, ebete eta ko kuba kododiha꞉ ebete ebema꞉ hoela. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ba꞉bema꞉ wadiyala nale ebe giya꞉pa꞉pa꞉mo a꞉na꞉miga꞉titi dito koemema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Paeletete ba꞉moe tabo begoiya꞉ mabu ebeno ododi komo ba꞉ ba꞉ma ka꞉nala, hiliyonomo gogo ipuwalo Yunapino Adaguila꞉ Poko tetelo iba꞉te du genamalo kapiya lumagi mahilamo da꞉ka꞉minakui, Paeletete ba꞉be lumagi ebeno kuba huiyane ba꞉ dito oemenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Huiyatiya tawakalubi hiliyonomate Paeletetamo ga꞉ga꞉lo na꞉ga꞉luya꞉, “Ao, Ya꞉suku nanakapuma꞉! A ubila ama꞉ Balabasiko dito noema꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabasikono komo ba꞉ma ka꞉nala. Dopamo ebete Loma gabomana꞉tamo alaholo komo ba ododi komo tawakalubi Yelusalemalo ba꞉bo anakapulamiya꞉, ba꞉bema꞉ iba꞉te ebe du genamamo dito a꞉da꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ba꞉ba tetelo Paeleteko ubila Ya꞉suku dito koemema꞉, ba꞉bema꞉ ebete ebeno tabo madodo adipatelo tawakalubi hiliyonomo gala na꞉kakiyalamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","huiyatiya ibi hiliyonomate ibulunomo na꞉ga꞉luya꞉, “Keha pihigamo pihomotete, ikoko nalukulima꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ba꞉bene netewa-kapiya teta꞉mo Paeletete gala na꞉kagoiya꞉, “Mabu keka꞉? Ebete bada kuba kododi? Na ebegodolo eta kuba kumitaha꞉, nale ebe hoea꞉mo ebema꞉ oemela! Wadiyala nale ebe giya꞉pa꞉pa꞉mo a꞉na꞉miga꞉titi dito koemema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Huiyatiya iba꞉te ekelalameheno konomamo na꞉ga꞉gitiya꞉ Ya꞉suku keha pihigamo kopihomotema꞉, ba꞉bene ibino ga꞉ga꞉ komote konomoma꞉ dediya꞉ Paeletete iba꞉tamo dito papamiwatuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","iyo, iba꞉te ebe keba ka꞉na ka꞉kiyahamiya꞉, Paeletete ba꞉ba ka꞉na ododiti Ya꞉suku hoea꞉mo oeme tabo ba꞉bo goiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ba꞉bene iba꞉te du genamalo lumagi mahilamo da꞉ka꞉miya꞉, ba꞉be dubu ba꞉ tawakalubi anakapulamedawa ba꞉gala gabomana꞉tamo alaholodawala, Paeletete ebe ebeno kuba huiyane dito oemiya꞉, huiyatiya ebete Ya꞉suku tawakaluba꞉tamo dito ikalamiya꞉ iba꞉te ibino ubi komo kododima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Alaholohopa꞉te Ya꞉suku hoe habamo ba magata, Saimonoko Sailiniya habanapi dubula, ebete gobogobone ko habamo ba꞉be gabodo pitiya꞉, ba꞉bene iba꞉te ebe heloamo lawete na꞉ga꞉lamiya꞉, Ya꞉suku dopamo ba tuta Saimonote ebeno keha pihiga kagatamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ba꞉bene tawakalubi hiliyonomate ebe ba ta꞉matuta, ibi ipuwalo komo kamenakamenate Ya꞉suku mabuma꞉ ihima꞉go tolamitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ya꞉suti huiyatiya iba꞉tamo ohobigate na꞉goiya꞉, “Yelusalemanapi kamenakamenala꞉, la꞉ na mabuma꞉ kihimitala꞉, la꞉ ha꞉kiya la꞉ ba꞉gala la꞉eno gugudi mabuma꞉ nihimitala꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mabu kuba tete ba꞉ na꞉pe tawakaluba꞉te ba꞉ma ka꞉na koga꞉lama꞉na꞉, ‘Hogoha꞉ kamenakamena ba꞉gala lamituma꞉ eda꞉haha꞉ kamenakamena ba꞉gala guguda꞉tamo nono ikalameha꞉ kamenakamena, iba꞉te olalati tetelo modobodopoma꞉ keda꞉hama꞉na꞉, huiyatiya guguda꞉gopi konomo tepo temeteme kiya꞉tawahama꞉na꞉!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ba꞉ba tetelo tawakaluba꞉te temeteme ipuwalo hunuhunu hakatamo koga꞉lama꞉na꞉, ‘La꞉ a hunamo na꞉peguda꞉la꞉!’ ba꞉gala hegehege hakatamo koga꞉lama꞉na꞉, ‘La꞉ a na꞉pihia꞉tea꞉la꞉!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ba꞉bema꞉ kamenakamenala꞉, la꞉ ba꞉moe komo nemalagidolala꞉. Kehate kaloloma꞉ eda꞉haha꞉ tetelo kubapa꞉te natamo ba꞉mako ko kuba bododita, ba꞉bema꞉ galane tetelo kehate kaloloma꞉ deda꞉hamena꞉, la꞉ hidamo! Diyala, ba꞉ba tetelo ibino tepo ipuwoeno kubate konomoma꞉ eda꞉lamete la꞉tamo ba꞉gala la꞉eno guguda꞉tamo hiya꞉hiya꞉ kokonomo kuba da꞉ ododilimina꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ba꞉ba tetelo iba꞉te kuba ododilipi dubu netewa Ya꞉sukuba꞉ magataliya꞉, iba꞉te ibi kapimilo hoea꞉mo konimiya꞉tema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ba꞉bema꞉ iba꞉te eta haka hunamo nikuliya꞉, ba꞉be hakoeno mahilo ba꞉ Wato Gohala, ba꞉bene iba꞉te Ya꞉suku kehamo ba꞉bolo nipihomotete ikoko ba꞉bo nalukulimiya꞉, ba꞉gala kuba ododilipi dubu netewa atumu kuwatete, eta tu hapuamo, eta pele hapuamo, hiya꞉hiya꞉ keha pihigamo ba꞉ba ka꞉na kapihomolateliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Nabiwi, ama꞉ ibino kuba egebolelamete nadodolelama꞉, mabu iba꞉te bada komo kododita ibi iya꞉tawaha꞉.” Ba꞉ba tetelo Ya꞉suku anakapumipa꞉te nakola hegehege iya꞉hekeholo iya꞉da꞉mi komo ba ododi ebeno kaliko hiya꞉hiya꞉ ba꞉bo alabahamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ba꞉bene tawakaluba꞉te utitatate ebe ba umita, Yu watowatopi dubate ebe walitilo na꞉ga꞉luya꞉, “Ebete komo tawakalubino olalati komo bemula꞉lelamenakui, ba꞉bema꞉ ebete Godokono hibi Kelisoma꞉ deda꞉na, wadiyala ebe ha꞉kiya ebeno ka꞉ka꞉ na꞉mula꞉na!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Ba꞉gala alaholohopa꞉te ebe atumu iya꞉da꞉telo na꞉kaga꞉lutiya꞉, “Ama꞉ Yu tawakalubino hibi Ko Gawadubuma꞉ deda꞉na, ama꞉ ha꞉kiya amia꞉no ka꞉ka꞉ na꞉mula꞉!” Ba꞉bene iba꞉te kaka gao beya ebetamo ba꞉bo ikamiya꞉ ebete konima꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ba꞉gala iba꞉te Ya꞉suku da꞉pihomotiya꞉ ba꞉be keha hunamo tabo ba꞉ma ka꞉na miya꞉tiya꞉, “Ba꞉moe dubu ba꞉ Yu tawakalubino Ko Gawadubula.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ba꞉ba tetelo eba꞉go keha pihigamo da꞉pihomolateliya꞉, ibi netewapi ipuwalo eta dubuti ebe konomamo iduduputimilo ba꞉ma ka꞉na goiya꞉, “Aba꞉, ama꞉ ba꞉ Godokono Oemedawa Kelisotela꞉ka꞉? Ama꞉ ha꞉kiya amia꞉no ka꞉ka꞉ mula꞉te, aeno ka꞉ka꞉ atumu na꞉kamula꞉lea꞉ma꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Huiyatiya eta dubuti ebe ba duhimi na꞉goiya꞉, “A꞉iye! Ama꞉ Godoko tolemeha꞉ma꞉ kediuta? A netewa-kapiyate ba꞉ kapiya hoe huiya ba lawita, ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","alaholohopa꞉te atamo kuba huiya hidamo ikaa꞉mita mabu a kuba komokomo bododilinamima꞉, huiyatiya Ya꞉suti eta kuba kododiha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ba꞉bene ebete Ya꞉sutamo na꞉goiya꞉, “Ya꞉su, ama꞉ Ko Gawadubu heloago da꞉kapemena꞉, ba꞉ba tetelo na malemalelo na꞉pemalagidoloniya꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ya꞉suti ebetamo na꞉huiyuya꞉, “Na ama꞉tamo hibi tabo begoemo, ka꞉lo hegelalo ama꞉ nago Kalakala Habalo kolutama꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ba꞉bene hegelate tuli teta꞉mo dutiya꞉, hegeloeno a꞉la꞉mina komote ekelamete hopo konomote ba꞉bo duya꞉. Iyo, du komote hegeloeno alo ba mula꞉, hegelate a꞉hiwate nanekela꞉mo a꞉nihitigatepaniya꞉, hegela tuli tetene tupuimiti 3 koloko teta꞉mo, ba꞉bene Godoko Adikumino Hiya꞉ Genamoeno kaliko ubiliti tulituliya ba꞉bo bolagaleniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ba꞉ba tetelo Ya꞉suti konomamo goewatanate na꞉goeniya꞉, “Nabiwi! Nale naeno gobogobo amia꞉no kokotamo ihatemo!” Ebete ba꞉moe tabo goenate hoenomo ba꞉bo hoeniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ba꞉bene alaholohopino gawadubuti ba꞉be komo uminate ebete Godokono mahilo ba adipatena na꞉goeniya꞉, “Hibila, ba꞉moe dubu tuputupudawama꞉ ba eda꞉na eta kuba komo kododiha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ba꞉bene tawakalubi hiliyonomate Ya꞉sukunu hoe komo umima꞉ da꞉pelamiya꞉, kebe komate kikulihoniya꞉ iba꞉te ba꞉bi komo ulamenate ko tola꞉go bodolo alukula꞉go ibino genamamo ba꞉ dito tolameniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","huiyatiya Ya꞉sukunu mabulubi hiliyonomo ba꞉gala kebe kamenakamenate Ga꞉lili hopone ebe da꞉ta꞉mahiya꞉, iba꞉te muhuluni putitatanate ba꞉bi hiya꞉hiya꞉ komokomo ba꞉bene pulameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ba꞉ba tetelo eta dubu nemedenami, ebeno mahilo Yausepetela, ebe Yudiya hopoeno A꞉limitiya habanapila, ba꞉gala ebe ba꞉ tuputupudawala, ebete Godokono Ko Gawadubuino pe tete belatiminami. Ebe Yunapi Ka꞉nisolo dubu etala, huiyatiya komo Ka꞉nisolo dubate Ya꞉suku anakapumi tabo da꞉ga꞉lutiya꞉, ebete iba꞉go ukui kapiyama꞉ keditiya꞉ha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ba꞉bene ba꞉be dubuti Paeletekono holoholo hapuamo tonate Ya꞉sukunu ape lawenama꞉ ebe ba꞉bo nikiyameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ba꞉bene ebete Ya꞉sukunu ape hopamo padipotenate, hido keyakeya kalikamo a꞉wa꞉tinate nakola bobo ipuwamo dito nihateniya꞉, tawakaluba꞉te ba꞉be bobo iya꞉ha꞉midale nakola haka ya꞉lo aligiya꞉ huiyatiya eta hoe lumagi dopamo kihatiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","55","Ba꞉ba tetelo kebe kamenakamenate Ya꞉sukuba꞉ Ga꞉lili hopone da꞉pelamiya꞉, iba꞉te Yausepeko bobo habamo ta꞉matanate, ba꞉be nakola bobo ba꞉gala Yausepete Ya꞉sukunu ape keba ka꞉na dihateniya꞉, iba꞉te ba꞉bi komokomo ba꞉bo nulamelemeniya꞉. Ba꞉be hegela ba꞉ Palaide hegelala, Yunapino talona hegeloeno ilina hiduilame tetela, mabu dumutu ba꞉ ibino okoha꞉ talona hegelala. ");
INSERT INTO knv_aramia_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ba꞉bema꞉ ba꞉bi kamenakamenate genamamo katolamenate hidohido nibo ilina ba꞉bo nihiduilameniya꞉ eta hegelalo Ya꞉sukunu apa꞉mo kopabutilamelemema꞉, huiyatiya iba꞉te Yunapino okoha꞉ hegelalo eta komo kododiya꞉ha꞉, mabu Godokono tutumu tabote talona ba꞉ma ka꞉na ihatelamenami. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ba꞉bene kamenakamenate Palaide gapogapolo da꞉hiduilameniya꞉, iba꞉te ba꞉bi hidohido nibo ilina Sande hegela duiduiyanomolo bobo habamo dito watuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Iba꞉te ba꞉bamo nikuliti, bobo da꞉takuminiya꞉ ba꞉be ko nakola tama꞉mo ya꞉lo emokamida ba itana ba꞉bo numiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ba꞉bene iba꞉te nakola bobo ipuwamo nogomote huiyatiya Kodawa Ya꞉sukunu ape kanumiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ba꞉ba tetelo iba꞉te ba꞉be komoma꞉ ukui bilibilima꞉ ba eda꞉huta, dubu netewa ibino kaliko a꞉la꞉minahalenomola, iba꞉te puluhukuti ibi tamelo pela꞉mota꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ba꞉bene kamenakamenate konomamo toletoleholo ibino holoholo hakamo ba miya꞉te dubu netewapa꞉te iba꞉tamo na꞉ga꞉luya꞉, “Keka꞉ mabu la꞉le ka꞉ka꞉ lumagi ha꞉laha tawakalubino bobo habalo da꞉pohowaditama? ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ebe malo puliyala, ebe a꞉mahigaka! Ebete Ga꞉lili hopolo la꞉ da꞉kiyalami, la꞉ ba꞉be tabo nemalagidolala꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Iyo, ebete ba꞉ma ka꞉na goiya꞉, ‘Godote Tawakalubino Naniwi kubapino kokotamo ihatete, iba꞉te ebe keha pihigamo pihomotete ikoko kalukulimima꞉na꞉, huiyatiya ebete netewa-kapiya hegelalo hoene gala kakamahigama꞉ne.’” ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ba꞉ba tetelo ba꞉bi kamenakamenate Ya꞉suti iba꞉tamo dopamo kebe tabo kolamagiya꞉ ba꞉be tabo ba꞉bo emalagidoluya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ba꞉bene iba꞉te bobo habane habamo katolamete iba꞉te bobo habalo da꞉nulamiya꞉ ba꞉bi komokomo Ya꞉sukunu 11 ta꞉matapi ba꞉gala ebeno komo mabulubi hiliyonomo ba꞉bo nikiyahalamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ba꞉ba tetelo Magadalanapi Ma꞉liko, Yowanako, Ya꞉imesikono menoko Ma꞉liko, ba꞉gala komo kamenakamena, ba꞉moi ba꞉tamo kebe komate bobo habalo kikulihuya꞉, iba꞉te ba꞉bi komokomo Ya꞉sukunu oelamepi dubatamo ba꞉bo nikiyahuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","huiyatiya iba꞉te ibino tabo dulihuya꞉, ba꞉be tabo daedae ukui komoma꞉ ga꞉late hibima꞉ kamidiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ba꞉ba tetelo Pitate huiyatiya mahigate bobo habamo dito puliguya꞉. Ebete nakola bobamo da꞉nuluhukuya꞉, na꞉pa꞉gaheno papamiwatane Ya꞉sukunu ape da꞉wa꞉tiniya꞉ ba꞉bi kaliko tamelo ba pola꞉na ba꞉bo nulamiya꞉, huiyatiya eta komo kanumiya꞉ha꞉. Ba꞉be mabuma꞉ ebete ba꞉be komo ebeno ukuilo konomamo emalagidolago gala na꞉kapiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ba꞉be atu hegelalo Ya꞉suku ta꞉matapi netewapa꞉te Yelusalema ko habane Emeyasi habamo tutiya꞉, ba꞉be gaboeno ga꞉ga꞉ ba꞉ 10 kilomita keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala, ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ba꞉bene gabo tetelo iba꞉te Ya꞉sutamo dikulihuya꞉ ba꞉bi hiliyonomo komokomoma꞉ olamagima꞉go tutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iba꞉te tabo ga꞉lago ba tuta, Ya꞉suti ibino gala hapuni pete iba꞉go da꞉tutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ba꞉ba tetelo iba꞉te ibino baida꞉mo Ya꞉suku umiya꞉, huiyatiya Godote ibino ukui ba atulatelelame iba꞉te kemalagidolutiya꞉ha꞉ ba꞉moe ba꞉ Ya꞉sutila. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ba꞉bene Ya꞉suti ibi netewapi na꞉goelamiya꞉, “La꞉ gabo tetelo ba tuta bada tabo ka꞉ga꞉lutama?” Ba꞉bema꞉ ibino dopote menemenema꞉ eda꞉halamete ba꞉ dito la꞉mota꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ibi ipuwalo etoeno mahilo Kolopasitila, ebete Ya꞉suku kapela hopo dubumu midilo na꞉goiya꞉, “Aeno Yelusalema habalo demedehona, ba꞉bi kapela tawakalubi ipuwalo ama꞉ kapiyate iya꞉tawaha꞉ma꞉ kediuta ba꞉moi hegelalo atamo bada komate dikulihui?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ya꞉suti huiyatiya na꞉goiya꞉, “Bada komokomola꞉ka꞉?” Ba꞉bene iba꞉te na꞉huiyuya꞉, “Nasaletenapi Ya꞉sutamo dikulihui ba꞉bi komo. Ebete Godokono holoholo hapulu ebeno ukui hawakalimidawama꞉ ba eda꞉na tabo olamagi ipuwalo ba꞉gala ododili ipuwalo helonomoma꞉ eda꞉nami. Ba꞉moe komo tawakalubi hiliyonomate hibinomolo umiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","huiyatiya Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala aeno komo koko dubu, iba꞉te ebe gabomanino kokotamo dito ihatiya꞉, iba꞉te ebeno komo ba anagilameleme hoea꞉mo koemema꞉, ba꞉bene iba꞉te ebe keha pihigamo pihomotete ikoko ba꞉bo alukulimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Dopamo a ba꞉ma ka꞉na emalagidolonamima꞉, ebe ba꞉ Isalaela tawakalubino ka꞉ka꞉ mula꞉lelamedawala, huiyatiya ebete da꞉hoi ba꞉be hegelane tupuimiti ba꞉mamo puluhuku ka꞉lo ba꞉ netewa-kapiya hegelama꞉ edita. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ba꞉bene aeno kapiyuimi ipuwalo komo kamenakamenatamo ka꞉lo duiduiyanomolo duluhukaka, ba꞉be komote a na꞉hanohanuia꞉ma꞉ka. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Iba꞉te bobo habamo da꞉tolama꞉ka Ya꞉sukunu ape kanuma꞉kaha꞉, ba꞉bema꞉ iba꞉te atamo gala kapelamete na꞉pega꞉laka, ‘A Godokono nopopi a꞉nulamema꞉. Iba꞉te na꞉ga꞉la Ya꞉suku hoene a꞉mahigaka!’ ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ba꞉bene aeno kapiyuimi ipuwalo komopa꞉te bobo habamo da꞉tolama꞉ka, ale kamenakamenagodone dulia꞉kama꞉ ba꞉bi komo iba꞉te ba꞉ ba꞉ba ka꞉na nulama꞉ka, huiyatiya Ya꞉suku kanuma꞉kaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ba꞉bene Ya꞉suti ibi netewapa꞉tamo na꞉goiya꞉, “La꞉eno iya꞉tawa lawe komo hibiha꞉, daedae gugudi keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala, mabu Godokono ukui hawakalimipa꞉te dopamo da꞉ga꞉lanakui, la꞉ ibino hiya꞉hiya꞉ tabo hibima꞉ kamidilinaha꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ba꞉moe konomo komo la꞉ iya꞉tawahala꞉ka꞉? Godokono ubi komodo ebeno Oemedawa Kelisote dopamo koko temeteme uwatete, ba꞉bene ebete ebeno A꞉la꞉minanomo Habamo kona꞉pa꞉gama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ba꞉bene Godokono Bukalo da꞉pola꞉na Kelisokono hibi komo hawakalimima꞉, Ya꞉suti ba꞉bi hiliyonomo komokomo ba꞉bo iya꞉tulamiya꞉, Mosesete Bukamo da꞉miya꞉tiya꞉ ba꞉ba tetene tupuimiti Godokono ukui hawakalimipa꞉te da꞉miya꞉tiya꞉ ba꞉bamo nuluhuku. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ba꞉bene da꞉gapogapohoniya꞉ iba꞉te ibino habamo ikulima꞉ ba tolamena, Ya꞉suti eta habamo kotonama꞉ da꞉goeniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","huiyatiya iba꞉te ebe duhiminate na꞉ga꞉lameniya꞉, “Wadiyala ama꞉ ago na꞉pa꞉, mabu hegela ba꞉ na꞉nihitigana ba꞉gala tiyolo kuduma꞉ne.” Ba꞉bema꞉ Ya꞉suti ibino genamamo tonate dito nodoloniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iba꞉te kapimilo baa꞉ ba nahana Ya꞉suti baa꞉ lawenate kalakala tabo Godotamo goenate, ba꞉bene baa꞉ wakalaminate ibi netewapa꞉tamo dito ikalameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ba꞉bema꞉ Godote ibino baidi pahaa꞉midalelamenate iba꞉te Ya꞉sukunu komo ba꞉bo iya꞉tawaniya꞉, huiyatiya ba꞉ba tetenomolo Ya꞉suti ibino holoholo hapuni ba꞉ dito alatidiniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ba꞉bene ibi netewapa꞉te tabo ba꞉ma ka꞉na ga꞉laniya꞉, “Hibila, gabo tetelo ebete ago tabo ba olamaginape Godokono Bukoeno komokomo atamo da꞉hawakalilama꞉ka, ba꞉ba tetelo aeno tepo ipuwalo Godokono koete wamotitaka!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ba꞉ba tetenomolo ibi netewapa꞉te Yelusalema ko habamo gala na꞉kawilaniya꞉, ba꞉bolo Ya꞉sukunu 11 ta꞉matapi ba꞉gala puya꞉te iba꞉go da꞉pola꞉nuya꞉, iba꞉te ibi hiliyonomo ba꞉bo nulameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ba꞉bene Ya꞉suku ta꞉matapa꞉te ibi netewapa꞉tamo na꞉ga꞉laniya꞉, “Hibila, Kodawa Ya꞉suti hoene a꞉mahigaka! Ebete Saimonotamo hibilo uluhukaka!” ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ba꞉bene ibi netewapa꞉te gabo tetelo bada komo dumiya꞉ ba꞉gala Ya꞉suti iba꞉tamo baa꞉ ba wakalamina iba꞉te ebeno komo diya꞉tawaniya꞉, ba꞉bi komokomo iba꞉te komo ta꞉matapi ba꞉bo kiyahalameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Iba꞉te ba꞉be tabo ba꞉ma ka꞉na ba ga꞉lana Ya꞉suti iba꞉tamo puluhukunate ibino tetenomolo putinate ibi na꞉goelameniya꞉, “Godokono kalakalate la꞉godolo nitanana.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ba꞉bema꞉ iba꞉te la꞉wa꞉hanate konomamo toletolehoniya꞉ mabu iba꞉te nemalagidoloniya꞉ Ya꞉suku ba꞉ gubalila. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ebete huiyatiya iba꞉tamo na꞉goeniya꞉, “Keka꞉ mabu la꞉le toletoleholo ukui bilibilima꞉ deda꞉hanama? Hibima꞉ midiha꞉ komote la꞉eno tepo ipuwane badama꞉ kuluhuku? ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wadiyala la꞉ naeno kokoto ba꞉gala nato nulama꞉la꞉. Na ba꞉ Ya꞉sutila. La꞉ na na꞉pologihona꞉la꞉, na gubaliha꞉, na lumagila. La꞉le na nunamenamata, na katena꞉goenola ba꞉gala gohagoenola.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ebete ba꞉be tabo goenate ebeno kokoto ba꞉gala nato iba꞉tamo ba꞉bo mutuilameniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ba꞉bene iba꞉te konomamo kalakalahaniya꞉, huiyatiya ukui bilibilima꞉ ba eda꞉hana ibino hibima꞉ midiha꞉ komote kawiboholameniya꞉ha꞉. Ba꞉bema꞉ Ya꞉suti ibi na꞉goelameniya꞉, “La꞉godolo eta ilina ba꞉kitana nale konama꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ba꞉bene iba꞉te daha okalimi ebetamo ikamenate, ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ebete lawenate ibino holoholo hapulu ba꞉ dito naniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ba꞉ba tetelo Ya꞉suti iba꞉tamo na꞉goeniya꞉, “Nale la꞉go ba emedena la꞉tamo dolamaginakuimo, ba꞉moe ba꞉be komola. Na dopamo ba꞉ma ka꞉na a꞉goimo, Godokono Bukate naeno komoma꞉ da꞉goena ba꞉bi hiliyonomo komate kikulihoma꞉na꞉, iyo, Mosesete Tutumu Tabo Bukamo da꞉miya꞉tiya꞉, ba꞉gala Da꞉ibiditi Sam Ohale Bukamo da꞉miya꞉tiya꞉, ba꞉gala komo Godokono ukui hawakalimipa꞉te da꞉miya꞉tiya꞉ ba꞉bi hiliyonomo tabo komate hibinomoma꞉ keda꞉hama꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ba꞉bene iba꞉te Godokono Bukoeno hiliyonomo komo hidonomamo kemalagidolenama꞉ ebete ibino ukui ba tuputupuilamelelamena ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ibi na꞉kiyalameniya꞉, “Godokono Bukalo tabo ba꞉ma ka꞉na itana, ebeno Oemedawa Kelisote koko temeteme uwatete ba꞉bo kohoema꞉ne, huiyatiya netewa-kapiya hegelalo hoene gala kakamahigama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ba꞉gala ba꞉moe Hido Tabote Yelusalema habane tupuimiti ba꞉moe hopo konomamo ba꞉ma ka꞉na kotoma꞉ne, Godokono tabo olamagimipa꞉te naeno mahilamo tawakalubi konikiyahalamema꞉na꞉, iba꞉te ibino kubane dohobila꞉hamena꞉ Godote ibino kuba ba꞉bo kadodoholelamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ba꞉ hibila, la꞉le ba꞉moi komokomo hidonomamo ulameholimata, ba꞉bema꞉ la꞉ naeno tabo olamagimipima꞉ keda꞉hama꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ba꞉gala eta komo. Naeno Nabiwiti hibinomolo da꞉goiya꞉ la꞉ ba꞉be komo kumima꞉nemata, nale ebeno helo la꞉tamo kopoemema꞉nemo, ba꞉bema꞉ wadiyala la꞉ Yelusalema ko habalo ba꞉be komo na꞉latimiya꞉la꞉, ba꞉bolo Godokono Helote Hunu Habane la꞉tamo kopihitigama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ba꞉ba tetelo Ya꞉suti ibi Yelusalema ko habane magatalete iba꞉te Betani haba tama꞉mo da꞉nikuliya꞉, ebete ebeno kokoto wadiya꞉paa꞉latelelo Godoko ba꞉bo kiyamiya꞉ ebete ibi hidonomamo kowalubilinama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ebete ba꞉be tabo ba goita, Godote ebe pelawete Hunu Habamo ba꞉bo adipatiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ba꞉bema꞉ iba꞉te ba꞉bolo Ya꞉suku adikumiti, Yelusalema ko habamo ko kalakalago na꞉katolamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ba꞉bene iba꞉te ba꞉be habalo ba emedena komo hiliyonomo hegelalo Godoko Adikumino Hiya꞉ Genamamo da꞉nalehawaminanakui, iba꞉te Godokono mahilo hunamo ba꞉bo adipatenakuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Godote ba꞉moe hopo ododihino dopamo Tabote emedenami, ebete Godokoba꞉ ba emedena ebe ba꞉gala Godoko ibi ba꞉ kapiyanomola, ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ba꞉bema꞉ ba꞉moe hopo tupuimihino Tabote Godokoba꞉ kapimilo ba꞉ba ka꞉na emedenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ba꞉bene Godote ba꞉moe hopoeno ilina ba꞉gala alomoeno ilina, hiya꞉hiya꞉ gobogobo ba꞉gala tawakalubi, ebete ibi hiliyonomo Tabokono heloamo ododiliya꞉, ba꞉bema꞉ ibi hiliyonomo ipuwalo eta kapiya komote eta dawoeno heloamo kuluhukuya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ba꞉ba tetelo hibi ka꞉ka꞉te Tabogodolo itanami, ba꞉bene ba꞉moe ka꞉ka꞉te aloma꞉ eda꞉te hopo tawakalubi hiliyonomo ba꞉bo a꞉la꞉minaliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ba꞉be mabuma꞉ ba꞉moe alote du ipuwalo ba꞉la꞉minana, duino helote ha꞉gumi modoboha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ba꞉bene Godokono oemedawa Yonete a꞉puluhukuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ebete tawakalubi hiliyonomatamo ba꞉be aloeno komo ba pehawakalimi iba꞉te ebeno tabo uliti hibima꞉ ba꞉bo komidima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yonete alo ba꞉moe hopamo kadahiya꞉ha꞉, huiyatiya ebete tawakaluba꞉tamo aloeno komo kopehawakalimima꞉ ba꞉bema꞉ piya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yonete da꞉pehawakalimiya꞉ ba꞉be alo ba꞉ Godokono hibi alola, ba꞉be alote hopo habanapi hiliyonomo ba꞉la꞉minalena. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ba꞉ hibila, Godote ba꞉moe hopo Tabokono heloamo ododiya꞉, huiyatiya Tabote pete ba꞉moe hopolo ba pemedena hopo tawakaluba꞉te ebeno komo kiya꞉tawahuya꞉ha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","iyo, ebete ebeno hoponomamo piya꞉ huiyatiya ebeno tawakaluba꞉te ebe kalakalago kalawiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Huiyatiya numa꞉la꞉, kebe tawakaluba꞉te ebe hibinomolo da꞉lawiya꞉ ba꞉gala ebe hibima꞉ da꞉midiya꞉, ebete iba꞉tamo helo ikalamiya꞉ iba꞉te Godokono gugudima꞉ keda꞉hanama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ba꞉moi guguda꞉te eta dubuino ubi komamo ba꞉gala kateneno heloamo kahawakalahaliya꞉ha꞉, huiyatiya iba꞉te Godokono helo kapiyamo hawakalahaliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ba꞉bene Tabote lumagino apa꞉mo pete ago ba pemedena ale ebeno alo konomo ba꞉bo umiya꞉ma꞉, ba꞉bako alo Nabiwi Godote ebeno kapiya Gudutamo ikamiya꞉. Ebeno aloeno a꞉la꞉mina ipuwalo ale ba꞉moe komo bumiya꞉ma꞉, ebe Godokono malemale komo ba꞉gala hibi komo tabonomola. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ba꞉bene Yonete ebeno tabo madodo hunamo adipatelo Godokono Guduino komo ba꞉ma ka꞉na hawakalimiya꞉, “Nale dopamo kebe dawoeno komoma꞉ kolamagimo, ba꞉moe ba꞉betela. Nale ebeno komoma꞉ ba꞉ma ka꞉na goimo, ebete naeno gala hapuni ba꞉pena, ba꞉gala Godote ebetamo dikamiya꞉ ba꞉be helo konomote naeno helo na꞉gogolona, mabu nale ba꞉moe hopamo hawakalaheno ebete dopamo nemedenami.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ebe malemale tabonomola, ba꞉bema꞉ ebeno malemale komodo ebete a hiliyonomatamo ebeno hidohido komo gala ikaa꞉menakui, gala ikaa꞉menakui, ebete ba꞉ba ka꞉na ewagelenami. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ba꞉ hibila, Godote ebeno Tutumu Tabo tawakaluba꞉tamo Moseseko ipuwado ikalamiya꞉, huiyatiya ebete ebeno malemale komo ba꞉gala hibi komo Ya꞉su Kelisogodone a꞉hawakalilamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Eta lumagiti Godokono holoholo dopamo kuminakuiha꞉, huiyatiya Godokono Gudu kapiyate ebeno Nabiwino komo tawakaluba꞉tamo a꞉pehawakalimiya꞉, mabu Nabiwi Gudu ibi ba꞉ kapiyanomola ba꞉gala Guduti Nabiwino holoholo hapulu bemedena. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ba꞉ba tetelo Yelusalema ko habalo demedehonama꞉, ba꞉bi Yu watowatopa꞉te komo Godotamo hawa꞉goeno ikamehopi dubu ba꞉gala Libai gu dubu Yonetamo ba꞉bo noelamiya꞉ ebeno hibi komo konumima꞉. Ba꞉bene iba꞉te Yonetamo pelamete ebe na꞉palatediya꞉, “Ama꞉ potela꞉ka꞉? Amia꞉no hibi komo atamo na꞉hawakalima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yonete ibino tabo huiyama꞉ ubiha꞉ma꞉ kediya꞉ha꞉, huiyatiya ebete kalakalago ibi hawakala na꞉goelamiya꞉, “Na Godokono Oemedawa Kelisoteha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ba꞉bema꞉ iba꞉te ebe gala na꞉kalatediya꞉, “Ama꞉ potela꞉ka꞉? Ama꞉ Godokono ukui hawakalimidawa Elayatela꞉ka꞉, a hopo habanapa꞉tamo gala da꞉kapuluhukui?” Yonete ibino tabo ba huiya na꞉goiya꞉, “Ao, na ebeteha꞉.” Ba꞉bema꞉ iba꞉te ebe gala na꞉kalatediya꞉, “Mosesete eta lumagino pe komoma꞉ dolamagiya꞉, ama꞉ ba꞉be Godokono Ukui Hawakalimidawa etala꞉ka꞉?” Yonete na꞉huiyuya꞉, “Ao, na ebeteha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ba꞉bene iba꞉te ebetamo gala na꞉kaga꞉luya꞉, “A puya꞉te da꞉poea꞉ma꞉, ale iba꞉tamo huiya tabo katama꞉, wadiyala amia꞉no komo na꞉hawakalima꞉, ama꞉ potela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yonete ibino tabo ba huiya na꞉goiya꞉, “Godokono ukui hawakalimidawa Aisayate naeno komo hawakalimima꞉ tabo ba꞉ma ka꞉na goiya꞉, ‘Lumagiti dito hopolo tabo ba꞉ma ka꞉na ibulu kopegoema꞉ne, ‘Kodawoeno gabo na꞉tuputupuima꞉la꞉.’ ’” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ba꞉ba tetelo kebe Yu watowatopa꞉te ba꞉bi dubu Yonetamo da꞉poelamiya꞉, ibi ba꞉ Pa꞉lisi kapiyuimipila, ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ba꞉bema꞉ ba꞉bi dubate ebe gala na꞉kaga꞉lamiya꞉, “Ama꞉le a꞉gaa꞉ta ama꞉ Kelisoteha꞉, ba꞉gala ama꞉ Elayateha꞉, ba꞉gala Mosesete Godokono eta okodawoeno pe komoma꞉ dolamagiya꞉ ama꞉ ebeteha꞉. Ba꞉bema꞉ mabu keka꞉ ama꞉le tawakalubi beyamo da꞉wadulatelenaka?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yonete ibino tabo ba huiya na꞉goiya꞉, “Hibila, nale tawakalubi beyamo a꞉wadulatelenakomo, huiyatiya la꞉ ipuwalo demedena ba꞉be eta lumagino komo la꞉ hibilo iya꞉tawaha꞉, ebe ba꞉ aeno Kodawala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ebete naeno gala hapuni ba꞉pena, huiyatiya na hidoenoha꞉ nale ebeno nato ukulalemema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yonete Yodane Tuli hapulu tawakalubi beyamo da꞉wadulatelenakui, ebete ba꞉be hopoeno Betani habalo ba emedena ba꞉moe komote ebetamo ba꞉bo uluhukuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ba꞉bene eta hegelalo Ya꞉suti ebetamo ba pita, Yonete ebe umiti komopa꞉tamo na꞉goiya꞉, “Numa꞉la꞉, Godokono Sipi-goe Deha꞉potote pita, ebete hopo tawakalubino kuba ododili huiya uwatelamete ebeno hawa꞉mo kegebolelamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nale dopamo la꞉tamo kebe dawoeno komoma꞉ kolamagimo, ba꞉moe ba꞉betela. Nale ebeno komoma꞉ ba꞉ma ka꞉na goimo, eta dubuti naeno gala hapuni ba꞉pena, huiyatiya ebeno helo konomola, ebete naeno helo na꞉gogolona mabu nale ba꞉moe hopamo hawakalaheno ebete dopamo nemedenami. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Iyo, nale ebe umihino dopamo ebeno hibi komo na iya꞉tawaha꞉, huiyatiya ebeno komo nale Isalaela tawakaluba꞉tamo hawakalimima꞉ piya꞉mo, ba꞉gala nale tawakalubi beyamo ba꞉bema꞉ wadulatelenakomo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ba꞉bene Yonete Ya꞉sukunu komo hawakalimilo na꞉goiya꞉, “Nale ebeno komo ba꞉ma ka꞉na umimo, Godokono Gobogobote Hunu Habane ebetamo gimai holamo pihitigutalo umimo, ebete ebegodolo kopemedenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nale ba꞉be komo umihino dopamo Ya꞉sukunu hibi komo iya꞉tawaha꞉, huiyatiya na tawakalubi beyamo wadulatelema꞉ da꞉poenamiya꞉ ba꞉be Kodawate natamo na꞉goi, ‘Naeno Gobogobote pogodolo kopemedenama꞉ ebetamo da꞉pihitigamene, ama꞉le ba꞉be lumagi umiti kiya꞉tawama꞉na꞉ta, ebe ba꞉ naeno Gobogobamo tawakalubi wadulateledawala.’ ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ba꞉ hibila, ba꞉be komo naeno baida꞉mo umimo, nale ebeno komo ba꞉bema꞉ hawakalimimo, ebe ba꞉ Godokono Gudula.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Eta hegelalo Yonete ebe ta꞉matapi netewapa꞉go da꞉la꞉nuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ba꞉ba tetelo Ya꞉suti ibi tamedo ba petonato, Yonete ebe umiti na꞉goiya꞉, “Numa꞉la꞉, ba꞉moe ba꞉ Godokono Sipi-goe Deha꞉potola, ebete tawakalubino kuba ododili huiya kuwatelamema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yoneko ta꞉matapi netewapa꞉te ba꞉be tabo duliya꞉ iba꞉te ebe miya꞉pate Ya꞉suku ba꞉bo ta꞉matuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ba꞉bene Ya꞉suti ohobigate ibi ulamelo na꞉kiyalamiya꞉, “La꞉eno ubi badala꞉ka꞉?” Iba꞉te ebeno tabo ba huiya ebe na꞉kiyamiya꞉, “Iya꞉tulamedawa, ale ama꞉ La꞉baima꞉ ka꞉ma꞉ta, ba꞉bema꞉ ama꞉ kebolo kemedeona, a ubila ba꞉be haba umi.” Buka ka꞉lamiholedawa, wadiyala ama꞉ ba꞉moe komo niya꞉tawa, Yunapa꞉te ibino tabamo eta hido iya꞉tulamedawa La꞉baima꞉ ka꞉minaka. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ba꞉bene Ya꞉suti iba꞉tamo na꞉huiyuya꞉, “Kubahenola, la꞉ pete na꞉puma꞉la꞉.” Ba꞉bene hegelate nanekela꞉mo da꞉nihitigatepaniya꞉, 4 koloko keba ka꞉nala꞉ka꞉ ba꞉bako tetelo ba꞉bi dubu netewapa꞉te Ya꞉sukuba꞉ tonate, ebeno emede haba numinate kapiya dulu eba꞉go ba꞉bo nelaniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ba꞉bi dubu netewapi ipuwalo etoeno mahilo A꞉ndulutila, ebe ba꞉ Saimono Pitakono ekawila. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ba꞉bene duiduiyanomolo A꞉nduluti tote ebeno naniwi Saimonoko da꞉numiya꞉ ebe na꞉nikiyamiya꞉, “A Mesayako hibinomolo umima꞉!” Buka ka꞉lamiholedawa, wadiyala ama꞉ ba꞉moe komo niya꞉tawa, Yunapa꞉te Godokono Oemedawa Kelisoko ibino tabamo Mesayama꞉ ka꞉minaka. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ba꞉bene A꞉nduluti ebeno naniwi Ya꞉sutamo da꞉magatuya꞉, Ya꞉suti ebe umiti ebetamo na꞉goiya꞉, “Amia꞉no mahilo ba꞉ Saimonotela, ama꞉ Yonekono gudulata, huiyatiya tawakaluba꞉te ama꞉ uli mahilo Kipasema꞉ koka꞉mima꞉na꞉ta.” Kipase mahiloeno ipuwa nitana ‘Nakolala,’ ba꞉gala Gulikinapino tabamo iba꞉te ba꞉be mahilo Pitama꞉ ka꞉minaka. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ba꞉bene eta hegelalo Ya꞉suti Ga꞉lili hopamo kotoma꞉ ubi dihatiya꞉, ba꞉ba tetelo ebete Pilipiko umiti ebe na꞉kiyamiya꞉, “Wadiyala ama꞉ na na꞉ta꞉mahena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ba꞉be dubu Pilipiko ebe ba꞉ Betasaida habanapila, ba꞉gala A꞉nduluku Saimonokoba꞉ iba꞉te ba꞉be atu habalo emedenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ba꞉bene Pilipiti Nata꞉niyoloko numiti ebe na꞉nikiyamiya꞉, “Mosesete Godokono Tutumu Bukalo pokono komo ka꞉hawakalimiya꞉, ale ba꞉be Kodawa hibinomolo umima꞉. Iyo, Godokono komo ukui hawakalimipa꞉te ebeno Bukalo atu lumagino komoma꞉ tabo gala da꞉kahawakalimiya꞉, ba꞉moe ba꞉betela. Ebe ba꞉ Ya꞉suti Nasaletenapila, Yausepekono gudula.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nata꞉niyolote huiyatiya na꞉goiya꞉, “Nasalete haba hido habaha꞉, ba꞉bema꞉ ba꞉be habane bada hido komote na꞉kuluhukumini?” Pilipiti ebe na꞉kiyamiya꞉, “Wadiyala ama꞉ pete ebeno komo na꞉puma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ba꞉bene Nata꞉niyolote ebetamo da꞉puluhukuya꞉, Ya꞉suti ebe umiti ebeno komoma꞉ na꞉goiya꞉, “Ba꞉moe Isalaela hoponapi dubu ba꞉ hibi lumagila. Ebeno tepo ipuwalo eta ha꞉da amiho komo kitanaha꞉, puliyanomola.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nata꞉niyolote ebe nalatediya꞉, “Mabu keka꞉ ama꞉ naeno tepo ipuwoeno komo diya꞉tawuta?” Ba꞉bene Ya꞉suti na꞉huiyuya꞉, “Pilipiti ama꞉ mamo pema꞉ kiyameheno ba꞉gala nale ama꞉go alugaheno, ama꞉le gao kehoeno dedela ipuwalo da꞉lutaka, nale ama꞉ Godokono Gobogoboeno heloamo ya꞉lo uma꞉kamata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ba꞉ba tetelo Nata꞉niyolote ebetamo na꞉goiya꞉, “Iya꞉tulamedawa, hibila ama꞉ ba꞉ Godokono Gudulata! Ama꞉ Isalaela tawakalubino Ko Gawadubulata!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Nale ama꞉ gao kehoeno dedelalo duma꞉kama, ba꞉be mabuma꞉ ama꞉le na hibima꞉ ka꞉midiniuta? Ba꞉ hibila, ba꞉moe komo ko komoha꞉, huiyatiya ama꞉ galane nagodolo kokonomo hanohano komo kulamema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na ama꞉tamo hibi tabonomo begoemo, Godote ebeno Hunu Haba a꞉hiya꞉midutalo ama꞉ kumima꞉na꞉ta, iyo, Tawakalubino Naniwiti wakolama꞉ eda꞉te, Godokono nopopa꞉te ba꞉be wakolado Hunu Habamo kanalehawamina, kapepalaga, ba꞉ba ka꞉na ba ewagele, ama꞉le ibi ba꞉bo kulamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Komo netewa hegelate da꞉petohuya꞉, ba꞉ba tetelo Ga꞉lili hopoeno Ka꞉ina habalo eta dubuti uli kamena lawe poko bododitiya꞉. Ba꞉be poko ipuwalo Ya꞉sukunu menokote na꞉lutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ba꞉gala Ya꞉suti ebe ta꞉matapa꞉go atumu ba꞉bolo na꞉kapola꞉nuya꞉ mabu poko namutudawate ibi a꞉kiyalamiya꞉ iba꞉te komo tawakaluba꞉go baa꞉ kopenahama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ba꞉bene poko ododi ipuwalo hido gao beyate da꞉wibuya꞉, ba꞉ba tetelo Ya꞉sukunu menokote ebe na꞉kiyamiya꞉, “Tawakaluba꞉te hido gao beya da꞉niha ba꞉ tiyonomo a꞉hawamina.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ba꞉bene Ya꞉suti ebeno menokotamo na꞉goiya꞉, “Adi, nale kebe komo ododima꞉ ama꞉le na akapikiyanama꞉la꞉, mabu naeno helo hawakalimi tete hibilo kapeha꞉, ba꞉be tetete uluhukuma꞉ Godote ha꞉kiya na kokiyanamema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ba꞉ba tetelo ebeno menokote ohobigate poko namutudawoeno genama okopa꞉tamo na꞉goiya꞉, “Ebete kebe komo ododima꞉ la꞉ da꞉goelamemena꞉, wadiyala la꞉ ba꞉be komo dito nododiya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ba꞉ba tetelo ba꞉be genamalo sikisi koko beya upate na꞉pola꞉nuya꞉, ba꞉moi upa tawakaluba꞉te nakolamo ododiliya꞉ ba꞉gala ibi ipuwalo komo 80 litala ba꞉gala komo 120 litala. Ba꞉moi upoeno komo ba꞉ma ka꞉na itanuya꞉, niho beyaha꞉ huiyatiya Yu tawakalubino ododili ipuwalo iba꞉te Godokono eta tutumamo kopapamila꞉halema꞉ ibino kokotoeno dalowa꞉ ba꞉makomako upoeno beyamo ukulalenakuya꞉, ibino iniwala꞉te ibi diya꞉tulamiya꞉ ba꞉ba ka꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ba꞉bema꞉ Ya꞉suti genama okopi na꞉goelamiya꞉, “La꞉ ba꞉moi upa beyanomamo na꞉tabuilama꞉la꞉,” ba꞉bene iba꞉te hibinomolo da꞉tabuilamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ya꞉suti ibi ba꞉bo goelamiya꞉ iba꞉te kalila꞉mo iyapote poko namutudawatamo konikamema꞉. Ba꞉bene iba꞉te tolamete poko namutudawatamo da꞉nikamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ba꞉ba tetelo ebete niti ebeno ukuilo golanomo gao beyama꞉ goiya꞉. Ba꞉be beyate hidonomo gao beyama꞉ keba ka꞉na kediya꞉ genama umi okopa꞉te iya꞉tawahuya꞉, huiyatiya poko namutudawate ba꞉be komo iya꞉tawaheno, ebete uli kamena da꞉lawitiya꞉ ba꞉be dubu ebetamo ka꞉miti ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ebe na꞉goemiya꞉, “Numa꞉, aeno ododi komo ba꞉ma ka꞉nala, poko ododi tetelo ale tawakaluba꞉tamo hidonomo gola gao beya dopamo ikalamenakoma꞉, iyo, iba꞉te ba꞉be hido gola beya da꞉hawaminamena꞉, ba꞉bene galane ale golaha꞉dopo beya iba꞉tamo ba꞉bo kikalamema꞉nema꞉. Huiyatiya ama꞉ ba꞉ba ka꞉na kododiha꞉, ama꞉ poko kuititi tetelo ba꞉moe golanomo gao beya tawakaluba꞉tamo ikalamitata!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ba꞉bema꞉ Ga꞉lili hopoeno Ka꞉ina habalo Godokono helo hawakalimima꞉ Ya꞉suti ba꞉moe ebeno dopo hanohano komo bododiya꞉. Ba꞉ba tetelo ebeno ta꞉matapa꞉te ebeno konomo helo dumiya꞉, iba꞉te ebe hibima꞉ ba꞉bo midiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ba꞉bene ba꞉moe komo da꞉wibuya꞉ Ya꞉suku ba꞉gala ebeno ta꞉matapi, iba꞉te ebeno menokago ba꞉gala ekaka꞉go Kapeniyama habamo tolamete tete nanekele ba꞉bo nemediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mabu Yunapino Adaguila꞉ Poko ododi tete da꞉tatalinapiya꞉, ba꞉bema꞉ Ya꞉suti Yelusalema ko habamo dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ba꞉bene ebete Godoko Adikumino Hiya꞉ Genamamo tote, ba꞉be genamalo tawakaluba꞉te kau-goegoe ba꞉gala sipi-goegoe ba꞉gala gimai holahola ba kolowamiholita ba꞉bo nulamiya꞉, ba꞉gala ba꞉be atu tetelo tawakaluba꞉te patapatalo ahiditi komopino mani doweheta꞉midahalitiya꞉ ebete ibi ba꞉bo kanulamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ba꞉moe mabuma꞉ Ya꞉suti hale uwatete giya꞉pa꞉pa꞉ ododiti ebete ba꞉bi goegoe Godoko Adikumino Genamoeno kala ipuwane helonomamo ba꞉bo ta꞉malateliya꞉, ba꞉gala ebete mani oweheta꞉midahalepino patapata ohoba꞉midahalelamete tawakalubino mani ba penegudilame hiya꞉hiya꞉ ba꞉bo petohuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ba꞉bene ebete gimai holahola kolowamipi ba kiyahalame na꞉goiya꞉, “Ba꞉moi ilina ba꞉moe genamane nuluhukulatela꞉la꞉. Naeno Nabiwino Genama talonala, ba꞉bema꞉ la꞉le kolowami habama꞉ akamida꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ya꞉suti ba꞉moe komo dododiya꞉ ebeno ta꞉matapa꞉te Godokono Bukoeno eta tabo ba꞉bo emalagidoluya꞉, ba꞉be tabote ba꞉ma ka꞉na itana, “Amia꞉no Talona Genama mabuma꞉ naeno tepo ipuwoeno helote koenomoma꞉ eda꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ba꞉ba tetelo komo Yu watowatopa꞉te Ya꞉suku na꞉ga꞉lamiya꞉, “Ama꞉ Godokono helo hawakalimima꞉ aeno holoholo hapulu hanohano komo nododa꞉, ba꞉bema꞉ a kiya꞉tawahama꞉nema꞉ ama꞉le Godokono Genamalo dododa꞉ ba꞉be komo amia꞉no heloamo kododiha꞉, huiyatiya Godokono heloamo ododa꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Kubahenola, la꞉le ba꞉moe Godoko Adikumino Genama danabulimima, huiyatiya nale netewa-kapiya hegelalo gala kaketema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yu watowatopa꞉te ebetamo na꞉ga꞉luya꞉, “Ama꞉ na꞉kemalagidoluta, amia꞉no helo modobola ba꞉moe konomo genama netewa-kapiya hegelalo ketema꞉? A꞉iye! Ba꞉moe genama aeno naba꞉te 46 gogo ipuwalo etenama꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Huiyatiya Ya꞉suti kebe tabo da꞉goiya꞉ ba꞉ ebeno apeno komoma꞉ goiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ba꞉bema꞉ galane tetelo ebete hoe ipuwane da꞉kamahiguya꞉, ebeno ta꞉matapa꞉te ba꞉moe tabo komo ba꞉bo emalagidoluya꞉, ba꞉bene Godote ebeno komoma꞉ ebeno Bukalo kebe komo ya꞉lo da꞉hawakalimiya꞉, iba꞉te ba꞉be komo hidamo lawete hibima꞉ ba midi Ya꞉sukunu tabo komo atumu hibima꞉ ba꞉bo kamidiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ba꞉bene Adaguila꞉ Poko tetelo Ya꞉suti Godokono helo hawakalimima꞉ kebe koko hanohano komo Yelusalema habalo dododiliya꞉, komo tawakalubi hiliyonomate ba꞉bi komo ulamete ebe hibima꞉ ba꞉bo midiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Huiyatiya ibi ipuwalo Ya꞉suti ebeno hibi komo eta kapiya lumagitamo kahawakalimiya꞉ha꞉, mabu ebe iya꞉tawanomola tawakalubi hiliyonomoeno tepo ipuwalo kuba ha꞉da amiho komate ba꞉pola꞉lama꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ba꞉gala ebete eta lumagi kakiyamenakuiha꞉ ebete ebeno tepo ipuwoeno komo hibinomolo kohawakalimima꞉, mabu ebete tawakalubi hiliyonomoeno tepo ipuwoeno komokomo ya꞉lo iya꞉tawuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ba꞉ba tetelo Yunapino eta watodawate nemedenami, ebeno mahilo Nikadimasitila, ebe ba꞉ Pa꞉lisi kapiyuimidawa etala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Eta dulu ebete Ya꞉sutamo penate na꞉pegoeniya꞉, “Iya꞉tulamedawa, a komopa꞉te iya꞉tawahala ama꞉ ba꞉ Godote poemiya꞉ta a kopiya꞉tua꞉mema꞉, mabu Godote kebe lumagigodolo emedenaheno, ebete ama꞉le dododilinaka ba꞉bako hanohano komo ododilima꞉ a꞉kamodobamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ya꞉suti ebeno tabo ba huiyana na꞉goeniya꞉, “Na ama꞉tamo hibi tabonomo begoemo, lumagiti ulinoma꞉ eda꞉lo ba꞉be uli ka꞉ka꞉mo gala hawakalaheno, Godote Ko Gawadubuma꞉ deda꞉na ebete ba꞉be komoeno ipuwa a꞉kuma꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ba꞉bema꞉ Nikadimasiti Ya꞉suku nalateda꞉niya꞉, “Lumagiti kadelema꞉ deda꞉na, ba꞉ba tetelo ebete ulinoma꞉ gala keba ka꞉na na꞉keda꞉mene? Gabohenola, mabu ebete ebeno menokoeno tepo ipuwamo opegate menokote ebe gala alahimi modoboha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ya꞉suti ebetamo na꞉huiyaniya꞉, “Nale ama꞉tamo hibi tabo begoemo, lumagiti beyamo ba꞉gala Godokono Gobogoboeno heloamo ulinoma꞉ eda꞉heno, Godote Ko Gawadubuma꞉ deda꞉na ebete ba꞉be habamo a꞉kana꞉pa꞉gamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ba꞉moe hopo habalo lumagiti da꞉hawakaluya꞉ ba꞉ba tetelo ebeno ka꞉ka꞉te menoko nabiwi iba꞉godone puluhukuya꞉, huiyatiya ebeno gobogoboeno hibi ka꞉ka꞉te Godokono Gobogobogodone kopema꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ba꞉bema꞉ tawakaluba꞉te ulinoma꞉ eda꞉hate gala hawakalahalema꞉ da꞉goemo, ba꞉be komoma꞉ ama꞉ akala꞉wa꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lumagiti Godokono Gobogoboeno heloamo ulinoma꞉ eda꞉lo ba꞉be uli ka꞉ka꞉go gala da꞉kahawakalamene ba꞉be komo ba꞉ ba꞉ma ka꞉nala. Ba꞉moe hopolo huhuti ha꞉kiya ebeno ubilo hiya꞉hiya꞉ hapuni da꞉pa꞉muta, ama꞉le ebeno diyamo kapiya bulitata huiyatiya huhuti kebene ka꞉petupuimita ba꞉gala keba hapulu ka꞉niwibuta ama꞉ iya꞉tawaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikadimasiti huiyatiya Ya꞉sutamo na꞉goeniya꞉, “Amia꞉no taboeno ipuwa na hidamo kalaweha꞉. Ba꞉moe komo keba ka꞉nala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ba꞉bene Ya꞉suti ebeno tabo ba huiyana na꞉goeniya꞉, “Ama꞉ ba꞉ Isalaela tawakalubino iya꞉tulamedawa etalata, huiyatiya mabu keka꞉ ama꞉ ba꞉moe komoeno ipuwa kiya꞉tawanaha꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na ama꞉tamo hibi tabonomo begoemo, naeno kapiyuimipa꞉go ale diya꞉tawahanama꞉ ba꞉bi komo bega꞉lanakoma꞉, ba꞉gala ale ya꞉lo dulamiya꞉ma꞉ ba꞉bi komo bikiyahanakoma꞉, huiyatiya la꞉ komo Yunapa꞉te aeno tabo a꞉kulia꞉lemata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iyo, nale ba꞉ma tetelo la꞉ hopo haboeno komokomo da꞉kiyahalamenakoma, la꞉ huiyatiya hibima꞉ kamidilinaha꞉, ba꞉bema꞉ nale Godokono Hunu Haboeno komokomo la꞉ gala da꞉kakiyahalamema, diyala, la꞉ ba꞉ atumu hibima꞉ a꞉kamidila꞉mata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ba꞉ hibila, hopo habanapi ipuwalo eta lumagiti Godokono Hunu Habamo kanodoluya꞉ha꞉, huiyatiya Tawakalubino Naniwiti Hunu Habane ba꞉moe hopamo a꞉pihitiguya꞉, ba꞉bema꞉ ebe kapiyate iya꞉tawala Hunu Haboeno komokomo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ba꞉gala eta komo, Mosesete dito hopolo eta kalu auli ilinamo ododiti kukamo keba ka꞉na kadipatiya꞉, wadiyala ama꞉ ba꞉be komo nemalagidola. Ba꞉ba tetelo bu kalate Isalaelanapi ipuwalo pui daloholiya꞉, ba꞉ba꞉te Mosesekono auli kalutamo da꞉gahilameholiya꞉, Godote ibino ka꞉ka꞉ ba꞉bo mula꞉lelamiya꞉. Ba꞉bema꞉ hibila, ba꞉ma tetelo Godote ba꞉ atu gabodo Tawakalubino Naniwi hunamo kadipatema꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ba꞉bene puya꞉te ebe hibima꞉ da꞉midimina꞉ iba꞉te wiboha꞉ ka꞉ka꞉ ba꞉bo kolawema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mabu Godote ba꞉moe hopo tawakalubi malemalelo konomamo ba emalagidole ebeno Gudu kapiyanomo ba꞉moe hopo habamo ba꞉bo poemiya꞉, ba꞉bema꞉ puya꞉te ebe hibima꞉ da꞉midimina꞉ ibino ka꞉ka꞉te a꞉kalatidihamena꞉ huiyatiya iba꞉te wiboha꞉ ka꞉ka꞉ kolawema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","“Ba꞉ hibila, Godote ebeno Gudu da꞉poemiya꞉, ba꞉ba tetelo ebe ubi kihatiya꞉ha꞉ ebeno Guduti tawakalubino komo anagilamelelamete kuba huiya kikalamema꞉, ao, huiyatiya ebe ubila ebete ibino ka꞉ka꞉ kopemula꞉lelamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ba꞉bema꞉ puya꞉te Godokono Gudu hibima꞉ da꞉midina Godote iba꞉tamo kuba huiya a꞉kikalama꞉mene, huiyatiya puya꞉te ebe hibima꞉ midihino Godote ebeno ukui ya꞉lo ihatiya꞉ iba꞉tamo kuba huiya kikalamema꞉, mabu iba꞉te hibima꞉ midi ipuwalo ebeno Gudu kapiyanomo kalaweha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","Numa꞉, Godokono alote ba꞉moe hopamo da꞉piya꞉ iba꞉te ubiha꞉ma꞉ eda꞉huya꞉, huiyatiya ibi ubila du ipuwalo kemedehonama꞉ mabu ibino ododili komokomo kubakubanomola. Iyo, kuba ododilipa꞉te hido alo ubiha꞉ma꞉ ba eda꞉ha alo ipuwamo a꞉kapelama꞉la꞉, mabu ibi ubihinola alote ibino kuba a꞉la꞉minalelame, ba꞉bema꞉ hibila, ibino kuba anagiya꞉mida komote iba꞉tamo kuluhukuma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Huiyatiya puya꞉te Godokono hibi gabodo da꞉tolamena iba꞉te alo ipuwamo kopelamema꞉na꞉, ba꞉bene iba꞉te hidohido komo Godokono heloamo ba ododili alote ibino hibi komo ba꞉bo kohawakalilamema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ba꞉be komo da꞉wibuya꞉ Ya꞉suti ebe ta꞉matapa꞉go Yudiya hopamo tolamete, iba꞉te ba꞉bolo tete ga꞉ga꞉dopolo ba nemede komo tawakaluba꞉te beyamo aduti komo lawema꞉ da꞉pelamenakui Ya꞉suti ibi ba꞉bo owalubilinakui. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ba꞉gala atu tetelo komo tawakaluba꞉te Yonetamo da꞉pelamenakui, ebete ibi Inono haba tamelo atumu kawadulatelenakui mabu ba꞉bolo beya kodopola, ba꞉be Inono habate Salimi haba tatalilo itana. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ba꞉ba tetelo gabomana꞉te Yoneko du genama guamo ihatehenola. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ba꞉bene eta hegelalo Yoneko ta꞉matapa꞉te eta Yunapi dubago tawakalubino apeno dalowa꞉ ukulale komoma꞉ olowabeletihuiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ba꞉bema꞉ komo iba꞉te ba꞉be tabo ga꞉la ipuwane Yonetamo pelamete ebe na꞉pega꞉lamiya꞉, “Iya꞉tulamedawa, dopamo Yodane Tuli hapulu ama꞉tamo da꞉puluhukui ba꞉be dubuino komo ama꞉le atamo da꞉hawakalimi, ebete gala kapete tawakalubi beyamo ba꞉pewadulatelenate, ba꞉gala tawakalubi hiliyonomate a miya꞉poete ebetamo ba꞉ na꞉tolama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yonete ibino tabo ba huiya na꞉goiya꞉, “Lumagiti hido komo ha꞉kiya a꞉kalawa꞉mene, Godote ebetamo ikameheno ebete dito kolutama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nale la꞉tamo da꞉goimo, la꞉ ba꞉be tabo hibilo ulihuimata. Iyo, na ba꞉ma ka꞉na goimo, ‘Na Godokono Oemedawa Kelisoteha꞉, huiyatiya Godote na na꞉poenamiya꞉ Kelisoko dopamete kotoma꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Eta dubuti uli kamena da꞉lawemene, ebete poko ododiti ba꞉be kamenate hibinomolo ebenoma꞉ keda꞉ma꞉ne. Ba꞉ba tetelo ba꞉be dubuino hido mabulubiti nanekela꞉mo ebe tama꞉mo nutiti, ebeno mabulubino tabo madodo uliti ebeno ko kalakala dumimini, ebete atumu kokalakalama꞉ne. Ba꞉ hibila, na ba꞉ ba꞉ba ka꞉nala, Kelisoko mabuma꞉ naeno tepo ipuwalo kalakala konomote a꞉tabui, ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ba꞉bema꞉ wadiyala ebete koma꞉ neda꞉mene, na huiyatiya deha꞉potoma꞉ keda꞉ma꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Godokono Hunu Habane da꞉pihitiguya꞉ ba꞉be Kodawate hopo tawakalubi hiliyonomo na꞉gogolena. Kebe lumagiti ba꞉moe hopolo demedena, ebe ba꞉ ba꞉moe hopoeno komoma꞉ olamaginako mabu ebe ba꞉ hopo lumagila, huiyatiya Hunu Habane da꞉piya꞉ ba꞉be dawa eba ka꞉naha꞉. Ebete ba꞉moe hopolo ha꞉kiya Kodawanomoma꞉ ba peda꞉na, ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hunu Habalo kebe komokomo kulamiya꞉ ba꞉gala kebe komokomo kulihuya꞉, ebete ba꞉bi komokomo hopo habanapa꞉tamo na꞉pehawakalilamena, huiyatiya ibi ipuwalo komo hiliyonomate ebeno tabo a꞉kalawa꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ba꞉be mabuma꞉ kebe lumagiti ebeno tabo hibinomolo da꞉lawemene, ebete ba꞉be komodo ba꞉moe eta komo kohawakalimima꞉ne, Godoko kapiya ba꞉ hibi komo hawakalimidawala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ba꞉ hibila, Godote da꞉poemiya꞉ ba꞉be Kodawate Godokono hibi tabo bolamaginako, mabu Godote ebeno Gobogoboeno helo konomo ebetamo ya꞉lo ikamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","iyo, Nabiwi Godote ebeno Gudu malemalelo nemalagidolona, ba꞉bema꞉ ebete ebetamo helo ikamiya꞉ ebete hiliyonomo komokomo ododilima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ba꞉be mabuma꞉ kebe lumagiti Godokono Gudu hibima꞉ da꞉midina, Godokono wiboha꞉ ka꞉ka꞉te ebegodolo bitana, ebete ya꞉lo a꞉lawi, huiyatiya kebe lumagiti Godokono Gudutamo papamiwataheno, Godokono konomo mauba komote ebetamo bitana ba꞉bema꞉ ebete hibi ka꞉ka꞉ a꞉kalawenamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ba꞉bene Pa꞉lisi kapiyuimipa꞉te Ya꞉sukunu komo ba꞉ma ka꞉na ulihuya꞉, ebete hiliyonomo tawakalubi ebeno ta꞉matapima꞉ midiliti ibi beyamo ba꞉bo wadulatelenakui, huiyatiya Yonete hiliyo tawakalubi kawadulatelenakuiha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ba꞉be teteno hibi komote huiyatiya ba꞉ma ka꞉na itanuya꞉, ba꞉bi tawakalubi ipuwalo Ya꞉suti eta lumagi beyamo kadutinakuiha꞉, ebeno ta꞉matapa꞉te ha꞉kiya wadulatelenakuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ba꞉bene Ya꞉suti Pa꞉lisi kapiyuimipino tabo ga꞉la komo diya꞉tawuya꞉, ba꞉ba tetelo ebete Yudiya hopo miya꞉pate Ga꞉lili hopamo wilama꞉ emalagidoluya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ba꞉bene ba꞉bamo konuluhukuma꞉ ebete duiduiyanomolo tupuimiti Godokono ubilo Samaliya hopodo tote ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ba꞉be hopoeno Saika habamo dito nuluhukuya꞉. Iniwali tetelo Ya꞉ikobote ebeno gudu Yausepetamo dikamiya꞉ ba꞉moe Saika haba ba꞉be haka tamelo itana, ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ba꞉gala Ya꞉ikobote daligiya꞉ ba꞉be beya ma꞉pete ba꞉bolo atumu ba꞉ka-itana. Ba꞉bene hegela tuli tetenomolo Ya꞉suti tete ga꞉ga꞉dopo pete ba꞉be beya ma꞉pe tamelo pemedete hawela bepamitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ba꞉bene Ya꞉suku ta꞉matapa꞉te baa꞉ mana꞉mo uwatehoma꞉ habamo da꞉tolamiya꞉, ebe ha꞉kiya beya ma꞉pelo ba luta eta Samaliyanapi kamenate beya iyapoma꞉ habane ba꞉bo piya꞉, ba꞉bene Ya꞉suti ebe na꞉goemiya꞉, “Na beya kapete unamita. Nolata, na beya nikanama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ba꞉bene kamenate Ya꞉sukunu tabo ba huiya na꞉goiya꞉, “A꞉iye, ama꞉ Yunapi dubulata ba꞉gala na Samaliyanapi kamenala! Ama꞉ na beyama꞉ badama꞉ ka꞉goenama꞉wa?” Ebete ba꞉ma ka꞉na da꞉goiya꞉ mabu Yunapa꞉te Samaliyanapi dalowa꞉gopima꞉ ga꞉lalo atu kalila꞉mo beya nihoma꞉ talonama꞉ ga꞉lanaka. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Godote tawakaluba꞉tamo dito dikalamena ba꞉gala pote ama꞉ beyama꞉ da꞉toemeha, ama꞉le ba꞉bi netewa komo hibilo niya꞉tawotale, ama꞉le na ba꞉kiyanameona꞉ nale ama꞉tamo ka꞉ka꞉ beya kikamema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kamenate ebetamo na꞉goiya꞉, “Kodawa, ama꞉ ba꞉be ka꞉ka꞉ beya kebene na꞉ka꞉laweomena꞉? Ama꞉godolo beya iyapoeno ilina puliyala, ba꞉gala numa꞉, ba꞉moe beya ma꞉pe ba꞉ kulukulunomola. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ama꞉ aeno iniwa Ya꞉ikoboko deha꞉potodawama꞉ goelo ama꞉ ha꞉kiya ama꞉ koma꞉ ka꞉midiuta? Ba꞉moe beya ma꞉pe ebete a ebeno eyoni gugudi mabuma꞉ aligiya꞉, ba꞉bene ebe ba꞉gala ebeno gugudi, ba꞉gala ebeno sipi-goegoe ba꞉gala kau-goegoe, ibi hiliyonomate ba꞉moe beya binihonama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ya꞉suti huiyatiya ebetamo na꞉goiya꞉, “Kebe lumagiti ba꞉moe beya da꞉nimini ebe beya kapete gala kakumima꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","huiyatiya nale kebe beya lumagitamo nima꞉ dikamemo ebe beya kapete gala a꞉kuminakamene. Ba꞉be ka꞉ka꞉ beyate lumagino emede ipuwane hiliyonomo tetelo ba꞉peka꞉ka꞉la꞉namene, ba꞉ma ka꞉na ebete wiboha꞉ ka꞉ka꞉ hibilo kolawema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ba꞉bene kamenate ebetamo na꞉goiya꞉, “Kodawa, nolata, ama꞉ ba꞉be beya natamo nikanama꞉. Nale da꞉nimo, na gala beya kapete a꞉kunamenakamene ba꞉gala nale ba꞉moe beya iyapoma꞉ gala a꞉kapenakamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ya꞉suti ebe na꞉goemiya꞉, “Ama꞉ habamo tote, amia꞉no awi nadabuiti mamo badi na꞉piya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ba꞉bene kamenate na꞉huiyuya꞉, “Na awihinola.” Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉ awiha꞉ma꞉ hibi tabo begaa꞉ta, ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","mabu ama꞉ dopamo paibo hiya꞉hiya꞉ dubate a꞉lawa꞉tepahuia꞉ta, ba꞉gala ka꞉lo ama꞉go demedena ba꞉be dubu amia꞉no hibi awiha꞉. Iyo, ama꞉ awiha꞉ma꞉ hibilo gaa꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ba꞉bema꞉ kamenate ebetamo na꞉goiya꞉, “Kodawa, na niya꞉tawutamo, hibila, ama꞉ ba꞉ Godokono ukui hawakalimidawa etalata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","A Samaliyanapino iniwala꞉te Godoko ba꞉moe hununomo hakalo adikuminakuya꞉ ba꞉bema꞉ ale talonama꞉ ga꞉lanama꞉, huiyatiya la꞉ Yunapa꞉te na꞉ga꞉lanakomata tawakaluba꞉te Yelusalemalo Godoko nadikuminakamena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ya꞉suti ebetamo na꞉goiya꞉, “Kamena, nale da꞉goitamo, ama꞉ ba꞉moe tabo hibima꞉ na꞉mida꞉. Tete ba꞉ na꞉pe, puya꞉te Nabiwi Godoko dadikumina iba꞉te gala Yelusalemalo a꞉kadikuminakamena꞉ ba꞉gala ba꞉moe hununomo hakalo a꞉kadikuminakamena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","La꞉ Samaliyanapa꞉te Godoko adikumi gabo hibilo iya꞉tawaha꞉, huiyatiya a Yunapa꞉te ba꞉moe komo iya꞉tawahala mabu Godokono ka꞉ka꞉ mula꞉ komote agodone hopo haba konomamo pena. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ba꞉ hibila, tete kopema꞉ne, iyo, ba꞉ na꞉pe, puya꞉te Nabiwi Godoko hibilo dadikumina iba꞉te uli ukui uwatete ebeno Gobogoboeno heloamo ba꞉gala ebeno hibi komodo ebe badikuminakomena꞉, mabu Nabiwiti ba꞉bako tawakalubi boholena ebe kadikuminama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Godote lumagino holoholamo kemedenaha꞉, ebe ba꞉ gobogobonomola. Ba꞉bema꞉ puya꞉te ebe dadikumina, wadiyala iba꞉te ebeno Gobogoboeno heloamo ba꞉gala ebeno hibi komodo nadikuminakamena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ba꞉bene kamenate ebetamo na꞉goiya꞉, “Na iya꞉tawala Mesayate kopema꞉ne, ebeno eta mahilo Kelisotela. Ebete da꞉pemene Godokono hiliyonomo komokomo atamo kopehawakalilamema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ya꞉suti ebetamo na꞉huiyuya꞉, “Na ama꞉go tabo dolamagimitama꞉, na ba꞉ Kelisotela.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ba꞉ba tetenomolo Ya꞉sukunu ta꞉matapa꞉te haba ipuwane da꞉kapelamiya꞉, iba꞉te koamo pela꞉wa꞉huya꞉ mabu ebete ba꞉moe kamenago tabo ba olamagimita ba꞉bo pulamiya꞉. Huiyatiya ibi ipuwalo eta lumagiti ba꞉be kamena ba꞉ma ka꞉na kakiyamiya꞉ha꞉, “Ama꞉ bada komo ododima꞉ kewageliuta?” ba꞉gala eta lumagiti Ya꞉suku kakiyamiya꞉ha꞉, “Mabu keka꞉ ama꞉le eba꞉go tabo dolamagimita?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ba꞉bema꞉ ba꞉ba tetelo kamenate ebeno upa beya ma꞉pelo miya꞉pate habamo tote tawakalubi ba꞉ma ka꞉na nikiyalamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Eta dubu na꞉puma꞉la꞉. Diyala, ebe da꞉ Kelisotela꞉, mabu nale dopamo kebe kuba komo diya gabodo dododilinamimo, ba꞉bi komokomo ebete natamo hibinomolo a꞉hawakalilame.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ba꞉bema꞉ habaluba꞉te kamenoeno tabamo papamila꞉halete Ya꞉suku umima꞉ ba꞉ dito tolamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Habaluba꞉te ba pelamita ba꞉be atu tetelo Ya꞉suku ta꞉matapa꞉te ebe na꞉kiyahamiya꞉, “Iya꞉tulamedawa, wadiyala ama꞉ baa꞉ na꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Huiyatiya Ya꞉suti iba꞉tamo na꞉goiya꞉, “Ao, nale nama꞉ ditana ba꞉be baeno hibi komo la꞉ iya꞉tawaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ba꞉bema꞉ Ya꞉sukunu ta꞉matapa꞉te ibi ipuwalo na꞉ga꞉luya꞉, “Diyala, eta lumagiti ebetamo baa꞉ kuda꞉ ikame.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Na da꞉poenamiya꞉ nale ebeno ubi komamo papamiwatalo ebeno oko kuitita꞉mo da꞉nuluhukumu, nale ba꞉be gabodo helo hibinomolo a꞉lawenakomo, baa꞉ na komo keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Numa꞉la꞉, la꞉ pali ododili tetelo ba꞉ma ka꞉na ga꞉lanakomata, ‘Netewa-netewa manomete ba꞉nepola꞉na, pali ilina naha tete kopema꞉ne.’ Ba꞉bema꞉ nale la꞉ eta tabo begoelamemata, la꞉le Godokono pali ilina hidamo ulamete niya꞉tawahala꞉, naha ilina uwate tete ba꞉ a꞉pe. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ba꞉gala eta komo, kona wakalami okodawate pali namutudawoeno wiboha꞉ ka꞉ka꞉ mabuma꞉ pali oko ipuwalo naha kona buwatenako. Ba꞉ hibila, namutudawate ebetamo huiya ikame ya꞉lo a꞉tupuimi, iyo, ba꞉moe gabodo kona kikipo amihodawa ba꞉gala kona wakalami okodawa, iba꞉te ibino huiya konomo kalakalago kapimilo kuwatema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tawakaluba꞉te da꞉ga꞉lanaka ba꞉ hibila, ‘Eta lumagiti kona kikipo amihote huiyatiya ebeno ekawiti pali ilina uwate tetelo oko kowatima꞉ne, ba꞉bene ibi netewapa꞉te badi konahama꞉na꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ba꞉bema꞉ nale la꞉ pali ilina uwatema꞉ ba꞉ ba꞉ba ka꞉na oelamemata, huiyatiya ba꞉bi pali ilina la꞉le kamihoha꞉. Iyo, komo okopa꞉te dopamo kodakoda oko owatiya꞉, huiyatiya ka꞉lo la꞉ ibino hido oko owati ipuwane hidohido naha ilina buwatenakomata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ba꞉ba tetelo ba꞉be habalo demedenama꞉ ba꞉bi Samaliyanapi ipuwalo komo hiliyonomate Ya꞉suku hibima꞉ ba꞉bo midiya꞉, mabu kamenate ibi ba꞉ma ka꞉na kiyalamiya꞉, “Nale dopamo kebe kuba komo diya gabodo dododilinamimo, ba꞉bi komokomo ba꞉moe dubuti natamo hibinomolo a꞉hawakalilame.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ba꞉bene iba꞉te ibino habane Ya꞉sutamo da꞉nikuliya꞉, iba꞉te ebe betoemehuya꞉ ebete iba꞉godolo kemeda꞉tepama꞉, ba꞉bema꞉ ba꞉ba tetelo Ya꞉suti netewa hegela bekalutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ba꞉ba tetelo komo habaluba꞉te Ya꞉sukunu tabo komokomo dulihuya꞉, ibi ipuwalo komo hiliyonomate ebe hibima꞉ miditi, ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","kamena ba꞉ma ka꞉na kiyamiya꞉, “Dopamo tetelo amia꞉no tabo kapiya dulima꞉ ale ba꞉moe Ya꞉suku hibima꞉ ba꞉bo midima꞉, huiyatiya ka꞉lo ale aeno hibila galamo ebeno tabo ulima꞉. Hibila, ebe ba꞉ hopo habanapino Ka꞉ka꞉ Mula꞉lelamedawala.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Ya꞉suti hopo habalo demedenami ebete ebeno komoma꞉ hibinomolo ba꞉ma ka꞉na goenakui, “Godokono ukui hawakalimidawa ebeno habaluba꞉te ebe hunamo a꞉kadipata꞉mena꞉, huiyatiya iba꞉te ebe ubiha꞉ma꞉ beda꞉hanakomena꞉.” Ba꞉bema꞉ Ya꞉suti ba꞉be komo iya꞉tawate Samaliya hopolo netewa hegela lutate, ba꞉bene ba꞉be hopo miya꞉pate ebeno Ga꞉lili hopamo gala dito katuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ba꞉ba tetelo komo Ga꞉lili hoponapa꞉te ebe kalakalago lawiya꞉, mabu iba꞉te dopamo Adaguila꞉ Pokoma꞉ Yelusalema ko habamo da꞉tolamiya꞉ Ya꞉sukunu hiliyonomo ododili komokomo nulamete hidonomoma꞉ ba꞉bo nega꞉luya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ba꞉bene Ya꞉suti Ga꞉lili hopoeno Ka꞉ina habamo gala dito katuya꞉, ba꞉be haba ba꞉ ebete dopamo Godokono helo hawakalimi komodo beyanomo hido gao beyama꞉ da꞉midiya꞉, ba꞉be habala. Ba꞉ba tetelo eta gabomani dubuti ba꞉bolo na꞉lutiya꞉, huiyatiya ebeno kuhiti Kapeniyama habalo ko tawetawa꞉go watitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ba꞉bene ba꞉be gabomani dubuti Ya꞉suti Yudiya hopone pe komo duliya꞉, ba꞉bema꞉ ebete ebetamo tote ebe na꞉nikiyamiya꞉, “Wadiyala꞉ka꞉ ama꞉ Kapeniyama habamo pete naeno kuhi na꞉pihiduimiya꞉, mabu ebe hoe tatalila.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ya꞉suti huiyatiya ebetamo na꞉goiya꞉, “La꞉ tawakalubi hiliyonomoeno komo ba꞉ ba꞉ma ka꞉nala, nagodolo koko hanohano komo ulameheno la꞉le na hibima꞉ a꞉kamidina꞉lemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Gabomani dubuti ebetamo gala na꞉kagoiya꞉, “Kodawa, nolata. Ama꞉ tiyolo nago na꞉pa꞉, naeno guduti hoedemene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉ kalakalago na꞉toa. Amia꞉no kuhino ka꞉ka꞉te a꞉kalatida꞉mene.” Ba꞉ba tetelo ba꞉be dubuti Ya꞉sukunu tabo hibima꞉ miditi ebeno Kapeniyama habamo to ba꞉bo tupuimiya꞉, huiyatiya ba꞉be atu hegelalo ebete habamo kanuluhukuya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ba꞉bene eta hegelalo komo ebeno genama okopa꞉te eba꞉go da꞉paluguya꞉, iba꞉te ebe na꞉pikiyamiya꞉, “Nolata, amia꞉no kuhiti dutu gala a꞉kaka꞉ki!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ebeno kuhiti kebako tetelo ka꞉hidui, ebete ba꞉be komo lawema꞉ ebeno okopi dalateda꞉liya꞉ iba꞉te na꞉huiyuya꞉, “Dutu hegela tuli tetelo, 1 koloko tete keba ka꞉nala꞉ka꞉, tawetawete ebe ba꞉bo miya꞉pui.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ba꞉bene nabiwiti ukuilo nemalagidoluya꞉, ba꞉be tete ba꞉ atu tetenomola Ya꞉suti ebe da꞉kiyami kuhino ka꞉ka꞉te a꞉kalatida꞉mene, ba꞉bema꞉ ebe ba꞉gala ebeno genamanapi, ibi hiliyonomate Ya꞉suku hibima꞉ ba꞉bo midiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ba꞉ hibila, Ya꞉suti Yudiya hopone Ga꞉lili hopamo pete netewa hanohano komo da꞉pododiliya꞉, ba꞉moe komo ba꞉ etala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ba꞉moe komo da꞉wibuya꞉ Ya꞉suti Yelusalema ko habamo tuya꞉ Yunapino eta poko konumima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yelusalemoeno kala imi tetelo eta gigiho bitana, ebeno mahilo Sipi-goegoeno Gigihola, ba꞉gala ba꞉moe gigiho tamelo mala꞉ ikiloeno bobo ba꞉ka-itana, ebeno mahilo Yu tawakalubino tabamo ba꞉ Betesedala. Ba꞉be bobo hapuhapulu panagopi genama paibate la꞉mota꞉hanama꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ba꞉bene hiya꞉hiya꞉ temetema꞉gopi hiliyonomate ba꞉bi genamoeno dedelalo pola꞉nanakuya꞉, ibi ipuwalo komo baidi tamihopila, ba꞉gala komo nato a꞉ta꞉buta꞉midalelamepila, ba꞉gala komo ape kodakoda temetema꞉gopila. Iba꞉te hegela hiliyonomolo beyoeno tete belatimitanakuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","mabu hiya꞉hiya꞉ kapiyakapiya tetelo Kodawa Godokono nopodawate boboeno beya da꞉pologinakui beyate gelewalemo ba꞉bo ikiya꞉midanakui. Ba꞉ba tetelo kebe temetema꞉godawate beya ipuwamo tiyolo da꞉nihitiganakui ebe kapiyate hido komo ba꞉bo lawenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ba꞉bene Ya꞉suti Beteseda bobamo da꞉nuluhukuya꞉ eta dubuti ba꞉bolo na꞉lutiya꞉, ebete 38 gogolo pata꞉ modoboha꞉ma꞉ eda꞉nami. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ya꞉suti ebe ba luta da꞉numiya꞉, ebete niya꞉tawuya꞉ ba꞉be dubuti tete ga꞉ga꞉nomolo ba꞉ba ka꞉na emedenami. Ba꞉bema꞉ ebete ebe na꞉goemiya꞉, “Ama꞉ ubila꞉ka꞉ Godote ama꞉ hiduimi?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Temetema꞉goeno dubuti ebetamo na꞉huiyuya꞉, “Kodawa, ba꞉moe beya Godote gelewalemo da꞉pikiya꞉midanako, ba꞉ba tetelo na owalubinidawa puliyala, ba꞉bema꞉ na beyamo ba nihitiguta huiyatiya eta lumagiti dopamo nihitiganako modobo komo konelawema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉ mahigate, amia꞉no tilo mokopa꞉midate, na꞉toa.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ba꞉ba tetenomolo ba꞉be dubuti hidote, ebeno tilo lawete ba꞉bo tuya꞉. Ya꞉suti ba꞉be dubu da꞉hiduimiya꞉, ba꞉be hegela ba꞉ Yu tawakalubino okoha꞉ talona hegelala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ba꞉bema꞉ ba꞉be dubuti tilo ba agatuta komo Yu watowatopa꞉te ebe ba꞉ma ka꞉na kiyahamiya꞉, “A꞉iye! Ba꞉moe ba꞉ aeno okoha꞉ talona hegelala! Tilo agata ipuwalo ama꞉ aeno kukala badikamidala꞉ta!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ebete huiyatiya na꞉goiya꞉, “Na da꞉hiduiname ba꞉be dubuti ba꞉ma ka꞉na goename, ‘Amia꞉no tilo mokopa꞉midate na꞉toa.’” ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ba꞉bema꞉ iba꞉te ebe nalatediya꞉, “Kebe dubuti ka꞉goemeta, ama꞉ tilo aguti kotoma꞉? Ama꞉ a na꞉kiyaa꞉ma꞉, ba꞉be dubu potela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Huiyatiya ba꞉be dubuti Yu watowatopa꞉tamo huiya tabo goe kamodobuya꞉ha꞉, mabu ebete Ya꞉sukunu komo kiya꞉tawuya꞉ha꞉ ba꞉gala Ya꞉suti ebe hiduimiti ebete tawakalubi hiliyonomo ipuwamo ba꞉ dito nopeguya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ba꞉bema꞉ galane Ya꞉suti Godoko Adikumino Hiya꞉ Genamalo ba꞉be dubu gala da꞉kumiya꞉ ba꞉bo goemiya꞉, “Numa꞉, amia꞉no apete a꞉hido, ba꞉bema꞉ ama꞉ eta kuba gala akododa꞉la꞉. Diyala, ko temetemete ama꞉tamo gala da꞉ kuluhukumini, ba꞉bema꞉ gala hapu temetemete konomoma꞉ eda꞉te, dopamo ama꞉ duminama꞉ ba꞉be temeteme kogogoloma꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ba꞉ba tetelo ba꞉be dubuti tote Yu watowatopi ba꞉ma ka꞉na nikiyalamiya꞉, “Na da꞉hiduinama꞉ka ba꞉be dubu ba꞉ Ya꞉sutila.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mabu Ya꞉suti Yunapino okoha꞉ talona hegelalo komo temetema꞉gopi da꞉hiduilamenakui, ba꞉bema꞉ komo ibino watowatopa꞉te ebetamo maubahalete temeteme ikame ba꞉bo tupuimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ba꞉ba tetelo Ya꞉suti iba꞉tamo na꞉goiya꞉, “Naeno Nabiwiti hegela hiliyonomolo oko bowatina, ba꞉bema꞉ na ebeno Guduti atumu oko beka-owatinamo, eta hegela dito a꞉kalutalemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yu watowatopa꞉te ba꞉be tabo duliya꞉ iba꞉te ubi konomamo ba꞉bo ihatiya꞉ ebe kanakapumima꞉, mabu hibila, dopamo Ya꞉suti ibino talona hegeloeno kukala badikamidaliya꞉, huiyatiya ba꞉ma tetelo ebete Godoko ebeno hibi Nabiwima꞉ goelo ebe ha꞉kiya ebeno helo Godokono heloago modoboma꞉ goe. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ba꞉bema꞉ Ya꞉suti iba꞉tamo na꞉goiya꞉, “Na la꞉tamo hibi tabonomo begoemo, Godokono Guduti ha꞉kiya ebeno ubilo eta komo ododi modoboha꞉, huiyatiya Guduti ebeno Nabiwino ododi komo duminako ebete ba꞉be atu komo beka-ododinako. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mabu Nabiwi Godote ebeno Gudu malemalelo ba emalagidolona ebeno hiliyonomo ododili komokomo Gudutamo hawakalilamena. Hibila, galane tetelo Nabiwiti ebeno Gudutamo komo kokonomo komokomo kohawakalilamema꞉ne ebete kododilima꞉, ba꞉bema꞉ la꞉ hiliyonomate ba꞉bi komo ulamete kohanohanohoma꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nabiwiti hoe lumagi ka꞉ka꞉mo keba ka꞉na kadipatenako, Guduti atumu ba꞉ ba꞉ba ka꞉na kewagelena, ebete kebe lumagitamo ubi dihatemene ba꞉be lumagitamo hibi ka꞉ka꞉ kikamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ba꞉gala Nabiwi Godote ha꞉kiya eta lumagino komo a꞉kanagiya꞉midama꞉mene, huiyatiya ebete helo Gudutamo ikamiya꞉ ebete tawakalubino komokomo kanagilamelelamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ba꞉bema꞉ hiliyonomo tawakaluba꞉te Guduino mahilo hunamo kadipatema꞉na꞉, iba꞉te Nabiwino mahilo keba ka꞉na kadipatenaka ba꞉ba ka꞉na. Kebe lumagiti Gudutamo ubiha꞉ma꞉ deda꞉na, ebete atumu ubiha꞉ komo Nabiwi Godotamo na꞉kahawakalimina mabu ba꞉moe Gudu Nabiwiti hopo tawakaluba꞉tamo poemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Na la꞉tamo hibi tabonomo begoemo, pote naeno tabo uliti ba꞉bene ebete na Oenamedawa hibima꞉ da꞉midina, ebegodolo wiboha꞉ ka꞉ka꞉ hibinomolo bitana, iyo, Godote ba꞉be lumagino komo a꞉kanagiya꞉midama꞉mene mabu ebete hoe ipuwane ka꞉ka꞉mo ya꞉lo uluhukui. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ba꞉bema꞉ na gala la꞉tamo hibi tabonomo bekagoemo, tete kopema꞉ne, iyo, ba꞉ na꞉pe, ba꞉ba tetelo ha꞉laha tawakaluba꞉te Godokono Guduino tabo madodo dulimina꞉ iba꞉te wiboha꞉ ka꞉ka꞉mo komahila꞉halema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ba꞉ hibila, Nabiwi Godoko kapiyagodolo wiboha꞉ ka꞉ka꞉ bitana, ba꞉bema꞉ ebete ebeno Gudutamo helo ya꞉lo ikamiya꞉ ebete atumu Ka꞉ka꞉ Mabudawama꞉ kakeda꞉nama꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ba꞉gala Nabiwiti Gudutamo helo gala a꞉kikamiya꞉ ebete tawakalubino komokomo kanagilamelelamema꞉, mabu ba꞉moe Gudu ba꞉ Tawakalubino Naniwila. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ba꞉bema꞉ la꞉ ulihopi naeno olamagi taboma꞉ akala꞉wa꞉hala꞉, mabu tete ba꞉ na꞉pe, ha꞉laha tawakaluba꞉te ebeno tabo madodo uliti ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bobo ipuwane ka꞉ka꞉mo komahila꞉halema꞉na꞉. Ba꞉bene ibi ipuwalo puya꞉te hopo habalo hidohido komo dododilinakui iba꞉te Ka꞉ka꞉ Habamo konalehawaminama꞉na꞉, huiyatiya puya꞉te kuba komokomo dododilinakui iba꞉te tabo anagiya꞉mida habalo ibino kuba huiya konuwatema꞉na꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ya꞉suti gala na꞉kagoiya꞉, “Na ha꞉kiya naeno ubilo eta komo ododi modoboha꞉, huiyatiya naeno Nabiwiti na da꞉kiyanamenako nale ba꞉be gabo kapiyado tawakalubino komo ba꞉bo anagilamelelamenakomo. Ba꞉gala anagiya꞉mida ipuwalo nale tuputupunomolo ododinakomo, mabu na ubila na da꞉poenamiya꞉ ba꞉be Kodawa kapiya kokalakaluiminama꞉, na ha꞉kiya na a꞉kakalakaluima꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Na ha꞉kiya ba꞉ma ka꞉na da꞉goemo, ‘Na ipuwalo hibi komo bitana,’ tawakaluba꞉te ba꞉be taboeno hibi komo a꞉kalawa꞉mena꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","huiyatiya eta Kodawate bemedena, ebe ba꞉ Godotela, ebete naeno hibi komo behawakalimina. Na iya꞉tawala, ebete na mabuma꞉ kebe tabo kolamagina ba꞉be tabo ba꞉ hibinomola. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Dopamo tetelo la꞉ Yu watowatopa꞉te komo dubu Yonetamo doelamima, ebete iba꞉tamo naeno hibi komo atumu a꞉kahawakalimi. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Numa꞉la꞉, hopo habanapa꞉te na mabuma꞉ dolamagimina nale ibino tabo a꞉kulia꞉lemo, huiyatiya Yonete dopamo dolamagi ba꞉be tabo ebeno ukui taboha꞉, ba꞉ Godokono tabola. Ba꞉be mabuma꞉ nale ba꞉be atu tabo la꞉ gala na꞉kagoelamemata, la꞉le hibima꞉ miditi Godote la꞉eno ka꞉ka꞉ komula꞉lelamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Iyo, Yoneko ba꞉ hido alo keba ka꞉nala꞉ka꞉ ebe ba꞉ba ka꞉na a꞉la꞉minanami, ba꞉bene tete nanekelelo ba꞉be aloeno komoma꞉ la꞉le la꞉eno ubi miya꞉ta꞉tepalo gunima꞉mo gala na꞉kawilalimata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ba꞉gala eta komo. Nabiwi Godote ya꞉lo tetelo natamo dikanamiya꞉, nale ba꞉be oko ba owatina naeno okote naeno hibi komo behawakalimina, na ba꞉ Godote poenamiya꞉. Ba꞉bema꞉ dopamo tetelo Yonete na mabuma꞉ hibi komo da꞉hawakalima꞉tepui, huiyatiya ba꞉ma tetelo naeno okote naeno hibi komo hidonomamo hawakalimina. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ba꞉ hibila, na da꞉poenamiya꞉ ba꞉be Nabiwiti naeno hibi komo ba hawakalimina, huiyatiya la꞉le ebeno tabo madodo a꞉kulia꞉lemata ba꞉gala ebeno holoholo a꞉kuma꞉lemata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Iyo, ebeno tabo la꞉eno tepo ipuwalo kitanaha꞉, mabu ebete na hopo habamo poenamiya꞉ huiyatiya la꞉le naeno tabo hibima꞉ kamidinaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","La꞉le Godokono Bukoeno tabo komokomo hidonomamo a꞉ka꞉lamiholenakomata, mabu la꞉ nemalagidolonamata ba꞉be gabodo la꞉le wiboha꞉ ka꞉ka꞉ kolawema꞉nemata. A꞉iye, numa꞉la꞉! Ba꞉moi Buka komokomo hiliyonomate naeno hibi komo behawakalimina, huiyatiya la꞉eno ka꞉lamihole ipuwalo ba꞉bi taboeno hibi ipuwa notanamata, ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ba꞉bema꞉ la꞉ ubihinola natamo pelamete nagodone wiboha꞉ ka꞉ka꞉ kopelawema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Na ubihinola hopo habanapa꞉te na milinamehone, ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","mabu na iya꞉tawala la꞉ kebako tawakalubila꞉ka꞉, la꞉eno tepo ipuwalo malemale emalagidolo komote Godotamo hibilo kitanaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ba꞉ hibila, nale naeno Nabiwino heloamo piya꞉mo huiyatiya la꞉le na kalawenenaha꞉, huiyatiya eta lumagiti ebe ha꞉kiya ebeno heloamo la꞉tamo da꞉pemene la꞉le ebe kalakalago kolawema꞉nemata, ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","iyo, la꞉ ubila la꞉ ipuwalo etate eta kamilimiho, etate eta kamilimiho, ba꞉ba ka꞉na kewagelenama꞉. La꞉ nulia꞉la꞉, la꞉le tuputupu komokomo aeno kapiya Godotamo ododilima꞉ dewagelema ba꞉ba tetelo ebete la꞉ komililameholema꞉na꞉ta, huiyatiya la꞉ ubihinola. Ba꞉moe mabuma꞉ la꞉le na hibima꞉ a꞉kamidina꞉mata, gabo puliyala! ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“La꞉ ba꞉ma ka꞉na akemalagidolala꞉, na kapiyate Nabiwi Godotamo la꞉ kuba ododilipima꞉ koka꞉lamima꞉. Ao, Mosesete atumu la꞉ kubapima꞉ kakaka꞉lamima꞉na꞉ta, ebe ba꞉ la꞉le la꞉eno hido owalubidawama꞉ da꞉ga꞉lanakoma ba꞉be dawala! ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ba꞉gala la꞉le Mosesekono tabo hibima꞉ na꞉midionatale la꞉le na atumu hibima꞉ ba꞉kamidiniona꞉, mabu ebete Godokono Bukamo tabo komokomo da꞉miya꞉tiya꞉, ba꞉bi komate naeno hibi komo behawakalimina. ");
INSERT INTO knv_aramia_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","La꞉ huiyatiya ebete Bukamo da꞉miya꞉tiya꞉ ba꞉be tabo hibima꞉ kamidinaha꞉, ba꞉bema꞉ la꞉le naeno tabo hibima꞉ keba ka꞉na na꞉ka꞉midioma? Gabo a꞉kitanamene!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ba꞉bene ibino tabo olamagimi komo wibote, komo hegela da꞉petohuya꞉, eta tetelo Ya꞉suti Ga꞉lili Bobo hapuamo boga꞉go dito na꞉hiwuya꞉, ba꞉be boboeno eta mahilo ba꞉ Taibiliyasila. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ba꞉bene tawakalubi hiliyonomate ebe ba꞉bamo ta꞉matuya꞉, mabu ebete temetema꞉gopa꞉tamo dododilinakui, iba꞉te ba꞉bi hanohano komo ulamiya꞉ ba꞉gala iba꞉te eta ko komo umima꞉ ubi bihatiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ba꞉bene Ya꞉suti haka hunamo nodolote ebe ta꞉matapa꞉go ba꞉bo nilutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ba꞉ba tetelo Yunapino Adaguila꞉ Poko tete ba꞉ tatalima꞉ na꞉ka-ediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ba꞉bene gapogapo hapulu komo hiliyonomo tawakaluba꞉te Ya꞉sutamo da꞉pekapiyuiminiya꞉, ebete ibi ulamenate Pilipiko na꞉goemeniya꞉, “A ba꞉moi hiliyonomo tawakalubi owalubilima꞉ baa꞉ kebolo na꞉kuwatelamema꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ba꞉ba tetelo Ya꞉suti ya꞉lo iya꞉tawaniya꞉ ebete tawakaluba꞉tamo bada komo na꞉kododimini, ba꞉bema꞉ ebete Pilipiko ba꞉moe tabo begoemeniya꞉, mabu ebe ubila ebeno hibima꞉ midi komo kumiminama꞉, da꞉ hibila꞉ o da꞉ hibiha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ba꞉bene Pilipiti ebetamo na꞉huiyaniya꞉, “Ba꞉moi tawakalubi hiliyonomate baa꞉ nanekele nahama꞉ kapiya gogoeno oko huiya maniti a꞉kamodobamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ba꞉ba tetelo Ya꞉suku ta꞉matadawa eta, ebeno mahilo A꞉ndulutila, ebe ba꞉ Saimono Pitakono amogala, ebete Ya꞉sutamo na꞉goeniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kuhi kapiya mola, ebegodolo paibo palawa baa꞉ ba꞉gala daha netewa ba꞉pola꞉na, huiyatiya ba꞉bi baa꞉ bilibiliha꞉, ba꞉moi tawakalubi hiliyonomago a꞉kamodobamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ba꞉bene Ya꞉suti ba꞉be hopoeno hemo konomo uminate ebe ta꞉matapa꞉tamo na꞉goeniya꞉, “La꞉ tawakalubi na꞉kiyalama꞉la꞉ iba꞉te dito kogagahidima꞉.” Ba꞉bema꞉ tawakalubi hiliyonomate ba꞉bamo gagahidinate ba꞉bi tawakalubi da꞉ka꞉lamiholeniya꞉ ibino kuititi ba꞉ 5,000 dubuma꞉ eda꞉niya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ba꞉bene Ya꞉suti ba꞉be baa꞉ uwatenate Godotamo kalakala tabo goenate, da꞉pola꞉nuya꞉ ba꞉bi tawakaluba꞉tamo dito ikalameholeniya꞉, ba꞉gala ebete daha kuwatenate ba꞉ba ka꞉na kewageleniya꞉ tawakalubino baa꞉ kape komote komodobolamenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ba꞉ba tetelo ba꞉bi baa꞉te ibi da꞉wigulameniya꞉ Ya꞉suti ebe ta꞉matapi na꞉kiyalameniya꞉, “La꞉ da꞉luhili ba꞉bi baa꞉ komokomo hidamo nuwata꞉la꞉, mabu ale ba꞉moi baa꞉ gigilepalama꞉ a꞉kamidila꞉ma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ba꞉bema꞉ iba꞉te tawakaluba꞉godolo da꞉luhiliniya꞉ ba꞉bi palawa baa꞉ komokomo duwateniya꞉, iba꞉te 12 bagolo betabuilameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ya꞉suti ebeno helo tawakaluba꞉tamo kohawakaliminama꞉ ba꞉moe hanohano komo dododiniya꞉, iba꞉te uminate na꞉ga꞉laniya꞉, “Hibila, ba꞉moe dubu ba꞉ Godokono Hiya꞉nomo Ukui Hawakalimidawala, Godote hopo habamo poemema꞉ da꞉goiya꞉, ba꞉moe ba꞉be Kodawala!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ba꞉ba tetelo Ya꞉suti ibino ubi komo biya꞉tawaniya꞉, iba꞉te ebe lawenate ibino Ko Gawadubuma꞉ dito komidinama꞉. Huiyatiya ebe ubihinola, ba꞉bema꞉ ebete ibi miya꞉palenate ebe ha꞉kiya eta haka hunamo dito nodoloniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hegelate ba nihila꞉minana Ya꞉suku ta꞉matapa꞉te bobo dodamo nepalaganate, ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","huiyatiya hopote da꞉duniya꞉ ba꞉ba tetelo Ya꞉suti iba꞉tamo tiyolo kapeniya꞉ha꞉, ba꞉bema꞉ iba꞉te boga꞉mo nololonate bobo a꞉hiwale ba꞉bo tupuiminiya꞉ Kapeniyama haba hapuamo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ba꞉ba tetelo ko huhuti ba mahigana koko gawiyate ba꞉bo mahila꞉haleniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ba꞉bene iba꞉te paibo o sikisi kilomita ba꞉mako tete ga꞉ga꞉dopolo ba nemabihona, ba꞉ba tetelo Ya꞉suti ibino boge tama꞉mo beya hunudu da꞉toniya꞉, iba꞉te ebe uminate konomamo ba꞉bo toletolehoniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","huiyatiya ebete ibi na꞉goelameniya꞉, “Na Ya꞉sutila, la꞉ katoletolehonala꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ba꞉bema꞉ iba꞉te Ya꞉suku boga꞉mo kalakalago da꞉natopiniya꞉, iba꞉te na꞉la꞉wa꞉haniya꞉ mabu iba꞉te kebamo tolamenama꞉ dewageleniya꞉, ba꞉ba tetenomolo iba꞉te ba꞉be boge utihole baha꞉mo boge ba꞉ dito nutiniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ba꞉bene Ya꞉suti Ga꞉lili Bobo hapulu da꞉nemiya꞉paleniya꞉, eta hegelalo ba꞉bi tawakalubi hiliyonomate ba꞉moe komo biya꞉tawahuya꞉, Ya꞉suti ebe ta꞉matapa꞉go kapiya boga꞉go iba꞉tamo da꞉pa꞉hiwaliya꞉, huiyatiya gapogapo tetelo ta꞉matapa꞉te gala ha꞉kiya da꞉kana꞉hiwaleniya꞉, Ya꞉suti iba꞉go katoniya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ba꞉be atu tetelo Taibiliyasi habanapa꞉te Kodawa Ya꞉sukunu hanohano ododi komoma꞉ tabo ba꞉ma ka꞉na uliya꞉, ebete Godotamo baa꞉ma꞉ kalakala tabo goenate tawakalubi hiliyonomatamo dikalameholeniya꞉, ba꞉bema꞉ komo ibi hiliyonomate ebe umima꞉ ibino boga꞉go ba꞉be atu hopamo ba꞉bo pelameholiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Huiyatiya iba꞉te Ya꞉suku ba꞉gala ebe ta꞉matapi ba꞉bolo nipo da꞉poholiya꞉, iba꞉te boga꞉mo gala kololohote na꞉katolamiya꞉ Kapeniyama habamo, iba꞉te Ya꞉suku ba꞉bolo konohowadima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ba꞉bene ba꞉bi tawakaluba꞉te Ya꞉suku Kapeniyama haba hapulu da꞉numiya꞉, iba꞉te ebe na꞉nega꞉lamiya꞉, “Iya꞉tulamedawa, ama꞉ ba꞉mamo kebako tetelo ka꞉puluhukawa?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Nale la꞉tamo hibi tabonomo begoemo, la꞉le nagodone baa꞉ uwatenate, ba꞉be baa꞉te la꞉ da꞉wigulameni la꞉le na unamema꞉ ba꞉bema꞉ pelamemata, huiyatiya naeno helo hawakalimino hanohano komoeno ipuwa la꞉le la꞉eno ukuia꞉mo kalaweha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","La꞉le kateneno ubi baa꞉ nahama꞉ oko kowatihonala꞉ mabu ba꞉be baa꞉te tiyolo kababalehoma꞉ne, huiyatiya wadiyala la꞉le wiboha꞉ ka꞉ka꞉ baa꞉ lawema꞉ oko nowatihonala꞉. Ba꞉mako baa꞉ na Tawakalubino Naniwiti la꞉tamo kikalamema꞉nemata, mabu Nabiwi Godote ba꞉moe komo ya꞉lo a꞉hawakalimiya꞉, na ba꞉ ebeno hibidawama꞉ eda꞉namo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ba꞉bene iba꞉te ebe na꞉ga꞉lamiya꞉, “Ale Godokono ubi komokomo kododilima꞉ bada oko na꞉kowatihoma꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ya꞉suti iba꞉tamo na꞉huiyuya꞉, “Godote la꞉godolo kapiyanomo komo umi ubila, ebete hopo habamo da꞉poemiya꞉ la꞉ ba꞉be dawa hibima꞉ na꞉mida꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ba꞉bema꞉ iba꞉te ebe gala na꞉kaga꞉lamiya꞉, “Ale ama꞉ hibima꞉ komidima꞉ ama꞉le atamo bada hanohano komo na꞉kododiomena꞉? Wadiyala ama꞉ amia꞉no helo atamo na꞉hawakalima꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Numa꞉, aeno iniwala꞉te dito hopolo ba emedena, Godokono hanohano ododi komodo iba꞉te baa꞉ uwatenakuya꞉, ba꞉be baeno mahilo ba꞉ ma꞉nala. Iyo, Godokono Bukoeno tabote ba꞉ma ka꞉na itana, ‘Godote iba꞉tamo Hunu Haboeno baa꞉ bikalamenakui,’ ba꞉bema꞉ wadiyala ama꞉ ba꞉ atumu amia꞉no helo na꞉hawakalima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ya꞉suti na꞉goiya꞉, “Nale la꞉tamo hibi tabonomo begoemo, Mosesete la꞉eno iniwala꞉tamo dikalamenakui, ba꞉be baa꞉ Hunu Haboeno hibi baa꞉ha꞉, ba꞉moe hopoeno baa꞉la, huiyatiya ba꞉ma tetelo naeno Nabiwiti Hunu Haboeno hibi baa꞉ la꞉tamo nikalamenata, ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","mabu Godokono hibi baa꞉ ba꞉ Hunu Habane da꞉piya꞉ ba꞉be dawala, ebe kapiyate hopo habanapa꞉tamo hibi ka꞉ka꞉ bikalamena.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ba꞉bene iba꞉te ebe gala na꞉kaga꞉lamiya꞉, “Iya꞉tulamedawa, wadiyala ama꞉le ba꞉ma tetene tupuimiti ba꞉be baa꞉ atamo nikaa꞉menakuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Na ba꞉ ka꞉ka꞉ baa꞉la. Kebe lumagiti natamo da꞉pemene ebe baa꞉ kapete gala a꞉ka-uminakamene, ba꞉gala kebe lumagiti na hibima꞉ da꞉midinimini ebe beya kapete atumu a꞉kuminakamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Ka꞉lo nale la꞉eno komo ba꞉ma ka꞉na hawakalimimo, la꞉le la꞉eno baidinomamo naeno helo umimata, huiyatiya la꞉le na hibima꞉ midinima꞉ ubihinola. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Naeno Nabiwiti natamo ikanamema꞉ dewagelena, ba꞉bi tawakalubi hiliyonomate natamo kopelamema꞉na꞉, ba꞉gala kebe dawate natamo da꞉pemene nale ebe gigiha꞉ baha꞉mo dito a꞉koema꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Numa꞉la꞉, Hunu Habane na da꞉poenamiya꞉ nale ba꞉be Kodawoeno ubi komo ododima꞉ ba꞉moe hopamo piya꞉mo, na ha꞉kiya naeno ubi komo a꞉kododa꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ba꞉bema꞉ na da꞉poenamiya꞉ ba꞉be dawoeno ubi komo ba꞉ma ka꞉nala, ebete natamo kebe tawakalubi kikanamena ibi ipuwalo eta kapiyate a꞉kalatida꞉mene, ba꞉bene Kuititi Hegelalo nale ibi hiliyonomo hibi ka꞉ka꞉mo kowadiya꞉paa꞉latelema꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Iyo, naeno Nabiwiti ubila, kebe lumagiti ebeno Gudu umiti hibima꞉ da꞉midimini, ebete wiboha꞉ ka꞉ka꞉ kolawema꞉ne, ba꞉bema꞉ hibila, Kuititi Hegelalo nale ba꞉be lumagi hibi ka꞉ka꞉mo kadipatema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ba꞉bene komo Yunapa꞉te Ya꞉sukunu komoma꞉ ubiha꞉ tabo bega꞉luya꞉, mabu ebete tabo ba꞉ma ka꞉na goiya꞉, “Na ba꞉ Hunu Habane da꞉piya꞉ ba꞉be ka꞉ka꞉ baa꞉la.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ba꞉bema꞉ iba꞉te na꞉ga꞉luya꞉, “Aba꞉ hibila꞉ka꞉, ba꞉moe Ya꞉suku ba꞉ Yausepekono gudula! A iya꞉tawahala ebeno menokola nabiwila! Mabu keka꞉ ebete Hunu Habane pema꞉ da꞉goe?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ya꞉suti ibino tabo iya꞉tawate iba꞉tamo na꞉huiyuya꞉, “La꞉ ipuwalo ubiha꞉ tabo kaga꞉lutala꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nabiwi Godote eta lumagi natamo magaheheno, ba꞉be dawate ebeno ubilo ha꞉kiya natamo pema꞉ a꞉kamodobamene, huiyatiya Nabiwiti kebe dawa natamo da꞉magahemene, nale ebe lawete Kuititi Hegelalo wiboha꞉ ka꞉ka꞉mo kadipatema꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Numa꞉la꞉, dopamo Godokono ukui hawakalimipa꞉te ebeno Bukamo tabo ba꞉ma ka꞉na miya꞉tiya꞉, ‘Tete ba꞉ na꞉pe, Godote ha꞉kiya hopo habanapi hiliyonomo ebeno gabo kiya꞉tulamema꞉ne.’ Ba꞉bema꞉ ba꞉moe komo ba꞉ hibila, pote Nabiwino tabo madodo uliti ebegodone hido iya꞉tawa komo da꞉lawenako, ba꞉be dawate natamo kopema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Naeno taboeno ipuwa kubamo akalawa꞉la꞉. Eta hopo haba lumagiti Nabiwino holoholo dopamo kumiya꞉ha꞉, huiyatiya pote Godogodone da꞉pihitiguya꞉ ebe kapiyate Nabiwino holoholo umiya꞉, ba꞉bema꞉ la꞉le ebe kapiyagodone Nabiwino tabo kulima꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Iyo, nale la꞉tamo hibi tabonomo begoemo, kebe lumagiti na hibima꞉ da꞉midinina ebegodolo wiboha꞉ ka꞉ka꞉te bitanamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na ba꞉ ka꞉ka꞉ baa꞉la. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","“Numa꞉la꞉, la꞉eno iniwala꞉te ma꞉nama꞉ da꞉ka꞉minakui, iba꞉te dito hopolo ba꞉be baa꞉ benahanakuya꞉ ba꞉bene galane tetelo ibi hiliyonomate a꞉ha꞉lahuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","huiyatiya Hunu Habane da꞉piya꞉, ba꞉be baa꞉ lumagiti da꞉namene ebete a꞉kahaa꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na ba꞉ Hunu Habane da꞉piya꞉ ba꞉be ka꞉ka꞉ baa꞉la, ba꞉bema꞉ hibila, kebe lumagiti ba꞉moe baa꞉ da꞉namene ebete emedena tetelo hibi ka꞉ka꞉go bemedenamene. Nale ebetamo dikamenakomo ba꞉be baa꞉ ba꞉ naeno apeno katenela, mabu nale naeno ape hopo habanapa꞉tamo ikalamemo ibino ka꞉ka꞉ komula꞉lelamema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ba꞉bema꞉ Yunapino maubate duluhukuya꞉, iba꞉te ibi ipuwalo olowabeletihuilo na꞉ga꞉luya꞉, “Ale ba꞉moe dubuino katene konahama꞉, ebete atamo keba ka꞉na na꞉kikaa꞉memene?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Nale la꞉tamo hibi tabonomo begoemo, la꞉le Tawakalubino Naniwino katene nahaheno ba꞉gala ebeno hawi nihoheno, hibi ka꞉ka꞉te la꞉godolo a꞉kitanamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Iyo, kebe lumagiti naeno katene da꞉nanako ba꞉gala naeno hawi da꞉ninako, ebegodolo wiboha꞉ ka꞉ka꞉te bitanamene, ba꞉gala nale Kuititi Hegelalo ebe hibi ka꞉ka꞉mo kadipatema꞉nemo, ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","mabu naeno katene ba꞉ hibi ka꞉ka꞉ baa꞉la, ba꞉gala naeno hawi ba꞉ hibi ka꞉ka꞉ beyala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ba꞉ hibila, kebe lumagiti naeno katene da꞉nanako ba꞉gala naeno hawi da꞉ninako, ebete na ipuwalo bemedena ba꞉gala nale ebe ipuwalo bemedenamo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na da꞉poenamiya꞉ ba꞉be Nabiwino hibi ka꞉ka꞉te nagodolo keba ka꞉na kitana, ba꞉ ba꞉ba ka꞉na kebe lumagiti naeno katene da꞉nanakomene, ebete naeno ka꞉ka꞉go bemedenamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ba꞉bema꞉ numa꞉la꞉, naeno ape ba꞉ Hunu Habane da꞉piya꞉ ba꞉be ka꞉ka꞉ baa꞉la. Ba꞉moe baa꞉te lumagitamo hibi ka꞉ka꞉ bikamenakomene, huiyatiya la꞉eno iniwala꞉te da꞉nahanakui ba꞉be baa꞉te ka꞉ka꞉ iba꞉tamo hibilo kikalamenakuiha꞉, iyo, galane iba꞉te dito ha꞉lahuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ya꞉suti Kapeniyama habalo Yu tawakalubino baidi ibubulamehole genamalo ibi diya꞉tulamitiya꞉, ba꞉ba tetelo ebete iba꞉tamo ba꞉moe tabo ga꞉ga꞉dopo bolamagiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ba꞉ba tetelo komo Ya꞉suku ta꞉matapi hiliyonomate ebeno iya꞉tulame tabo uliti na꞉ga꞉luya꞉, “Ba꞉moe taboeno ipuwa kodakodanomola, pote lawema꞉ na꞉ka꞉modobomene?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iba꞉te ebeno iya꞉tulame komoma꞉ kebe ubiha꞉ tabo da꞉ga꞉litiya꞉, Ya꞉suti iya꞉tawate na꞉goiya꞉, “Mabu keka꞉ naeno iya꞉tulame komote la꞉eno hibima꞉ midi komo da꞉kubahilamita? ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ba꞉ hibila, Tawakalubino Naniwiti dopamo demedenami ebete ba꞉be Kalakala Habamo gala kakanodoloma꞉ne, ba꞉bema꞉ la꞉le ba꞉be hanohano komo dumima la꞉ keba ka꞉na na꞉kewageleoma? ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Numa꞉la꞉, Godokono Gobogobote tawakaluba꞉tamo hibi ka꞉ka꞉ bikalamena, huiyatiya kateneno helote iba꞉tamo ka꞉ka꞉ ikalamema꞉ a꞉kamodobale. Ba꞉bema꞉ hibila, nale la꞉tamo dolamagimo ba꞉be tabo ba꞉ ka꞉ka꞉la, iyo, ba꞉be tabote Godokono Gobogobogodone pe, ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","huiyatiya la꞉ komopa꞉te hibima꞉ kamidiha꞉.” Ya꞉suti ba꞉moe tabo bolamagiya꞉ mabu ebete ebeno oko tupuimi mabuni ya꞉lo iya꞉tawuya꞉, ebe ta꞉matapi ipuwalo puya꞉te ebe hibima꞉ midiha꞉pima꞉ deda꞉hanamena꞉ ba꞉gala pote ebe anakapumipino kokotamo dihatemene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ba꞉bene ebete tabo moga꞉melo gala na꞉kagoiya꞉, “La꞉eno hibima꞉ midiha꞉ komoma꞉ nale ya꞉lo ba꞉ma ka꞉na goemo, Nabiwiti helo lumagitamo ikameheno, ebete ha꞉kiya ebeno ubilo natamo a꞉kapa꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ba꞉be mabuma꞉ komo Ya꞉suku ta꞉matapi hiliyonomate eba꞉go wapata꞉lame ubiha꞉ma꞉ eda꞉hate ibino hiya꞉hiya꞉ emede komamo gala dito kawilaliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ba꞉bene Ya꞉suti ebeno komo 12 ta꞉matapi nalateda꞉liya꞉, “La꞉ ba꞉ atumu, la꞉le na ba꞉ka꞉miya꞉paneoma?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimono Pitate ebetamo na꞉huiyuya꞉, “Kodawa, a potamo na꞉ka꞉tolamema꞉ mabu ama꞉ kapiyagodolo hibi ka꞉ka꞉ tabonomo bitana? ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","A iya꞉tawahala ama꞉ ba꞉ Godokono Hido-talona Dawalata, ba꞉bema꞉ ale ama꞉ hibima꞉ na꞉midinata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “Aba꞉ hibila꞉ka꞉, nale ha꞉kiya la꞉ 12 dubu buwatimata, huiyatiya la꞉ nulia꞉la꞉, la꞉ ipuwalo kapiyate Saitanakono okodawama꞉ eda꞉na!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ebete ba꞉moe tabo Yudasikono komoma꞉ goiya꞉, ba꞉be dubu ba꞉ Keliyotanapi Saimonokono gudula. Dopamo ba꞉moe dubuti 12 ta꞉matapi ipuwalo emedenami, huiyatiya galane tetelo ebete Ya꞉suku anakapumipino kokotamo ebe bihatiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ba꞉bene ibino tabo olamagimi komo da꞉wibuya꞉, ba꞉ba tetene tupuimiti Ya꞉suti Ga꞉lili hopo konomolo pata꞉nami, huiyatiya ebete Yudiya hopolo pata꞉ ubihinola mabu ba꞉be hopoeno Yu watowatopa꞉te ebe anakapumima꞉ ewagelenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ba꞉bene Yunapino Mimiya Etemotehoeno Poko da꞉tataliya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ba꞉ba tetelo Ya꞉sukunu ekaka꞉te ebe na꞉ga꞉lamiya꞉, “Wadiyala ama꞉ ba꞉moe Ga꞉lili hopo miya꞉pate Yudiya hopamo gala na꞉katoa. Diyala, ama꞉le komo ta꞉matapi ba꞉bolo da꞉ nulameomena꞉, ba꞉bene ama꞉le dododilinaka iba꞉te ba꞉bi hanohano komo hidamo kulamema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Numa꞉, lumagiti ubi dihatemene tawakalubi hiliyonomate ebe kota꞉matama꞉, wadiyala ebete ebeno komo akugumuia꞉la꞉. Ba꞉be mabuma꞉ ama꞉le ba꞉moi hanohano komo hibilo dododilinaka, wadiyala ama꞉ ba꞉ atumu amia꞉no komo hopo habanapi hiliyonomatamo na꞉hawakalimiya꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ya꞉sukunu ekaka꞉te ebe iya꞉da꞉telo ba꞉moe tabo bolamagimiya꞉ mabu iba꞉te ebe hibima꞉ kamidiya꞉ha꞉, komo tawakalubi hiliyonomate hibima꞉ midiha꞉ma꞉ keba ka꞉na keda꞉haliya꞉ ba꞉ba ka꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ba꞉bema꞉ Ya꞉suti ebeno ekakino tabo ba huiya na꞉goiya꞉, “La꞉ ha꞉kiya la꞉eno hiya꞉hiya꞉ ubi tetelo la꞉eno komo ba꞉bo ododilinakomata, huiyatiya naeno hibi tete Godogodone kapeha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Hopo habanapa꞉te la꞉tamo kamaubahalenaha꞉, huiyatiya iba꞉te natamo maubahalena mabu nale ibino kuba ododili komokomo a꞉hawakalilamenakomo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ba꞉bema꞉ la꞉ ha꞉kiya poko habamo na꞉tolama꞉la꞉, huiyatiya na ka꞉lo a꞉katoamo mabu Godokono hibi tete natamo kapeha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ya꞉suti ba꞉moe tabo goete Ga꞉lili hopolo ba꞉bo pekaguya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ya꞉sukunu ekaka꞉te pokoma꞉ da꞉tolamiya꞉, ebete huiyatiya galane diya gabodo ta꞉mataliya꞉, hawakala katuya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ba꞉ba tetelo Yu watowatopa꞉te poko habalo ebe ba ohowadi na꞉ga꞉luya꞉, “Ba꞉moe dubu Ya꞉suku keka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ba꞉gala puya꞉te pokoma꞉ da꞉pelameholiya꞉ ba꞉bi Yu tawakalubi hiliyonomate Ya꞉sukunu komoma꞉ tabo ganalo konomamo olamagimitiya꞉. Komo iba꞉te na꞉ga꞉luya꞉, “Ebe hido lumagila,” huiyatiya komopa꞉te na꞉ga꞉luya꞉, “Ao, ebe tawakalubi bamihoholamena.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ba꞉ba tetelo iba꞉te Ya꞉sukunu komoma꞉ hawakala kaga꞉lutiya꞉ha꞉ mabu iba꞉te ibino watowatopino mauba komo betolemitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ba꞉bene tawakaluba꞉te ibino poko ba ododinate eta hegelalo Ya꞉suti iba꞉tamo nehawakalate Godoko Adikumino Hiya꞉ Genamamo tote iya꞉tulame ba꞉bo netupuimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ba꞉ba tetelo ebeno iya꞉tulame taboma꞉ Yu watowatopa꞉te ba hanohanohuta na꞉ga꞉luya꞉, “A꞉iye! Ba꞉moe dubuti kebako iya꞉tawa ka꞉lawi mabu ebete kasikuluya꞉ha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “Nale la꞉ diya꞉tulamenama, ba꞉be tabote na da꞉poenamiya꞉ ba꞉be Kodawagodone pena, na ha꞉kiya naeno ubi komodo kiya꞉tulamenaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","La꞉ ha꞉kiya la꞉ ipuwalo naeno komoma꞉ ba꞉ma ka꞉na ga꞉lanamata, ‘Ebeno iya꞉tulame komote Godogodone da꞉pena o da꞉ ebeno kateneno ukuini da꞉pena.’ Numa꞉la꞉, la꞉ ipuwalo pote Godokono ubi komo ododilima꞉ ubi dihatena, ebe modobola naeno iya꞉tulame komoeno mabu la꞉tamo olamagi. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iyo, keba tetelo lumagiti ebeno kateneno ukui hapuni tabo dolamagina, ebe ha꞉kiya ebe bawagaminana, huiyatiya kebe lumagiti ubi dihatena ebe oemedawa kapiya kawagaminanama꞉, ba꞉be lumagi ba꞉ hibi komo hawakalimidawala, ebegodolo eta ha꞉da amiho komo kitanaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Godote ebeno Tutumu Tabo Moseseko ipuwado la꞉tamo ikalamiya꞉ta huiyatiya la꞉ ipuwalo eta kapiyate ba꞉bi hiliyonomo tutumamo hibilo kapapamiwatanaha꞉, aba꞉ hibila꞉ka꞉? Huiyatiya na tuputupu lumagima꞉ ba eda꞉na, mabu keka꞉ la꞉le na anakapunamema꞉ dewagelenama?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ba꞉ba tetelo Ya꞉sukunu tabo dulihutiya꞉ ba꞉bi tawakalubi hiliyonomate ebetamo na꞉ga꞉luya꞉, “Ama꞉ kuba gobogobagoenolata! Pote ka꞉goita ama꞉ anakapumima꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ya꞉suti huiyatiya iba꞉tamo na꞉goiya꞉, “Nale la꞉eno holoholo hapulu kapiya hanohano komo dododimo, la꞉ koamo ba꞉bo la꞉wa꞉huimata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","La꞉ numa꞉la꞉, Mosesete la꞉tamo eta kukala dikalamiya꞉la, ba꞉be kukala ba꞉ la꞉le bahibahi guguda꞉tamo tama itamida kukala komiya꞉telamenakoma꞉. Iyo, la꞉le ba꞉moe kukala miya꞉te komo Mosesegodone lawema꞉ ga꞉lanamata, huiyatiya ba꞉moe komo ebegodone hibilo kuluhukuya꞉ha꞉, la꞉eno komo iniwala꞉godone piya꞉. Ba꞉gala Mosesete talona hegeloeno kukala atumu la꞉tamo a꞉kikalamiya꞉ta, ba꞉bema꞉ ba꞉bi netewa kukala la꞉godolo ba pola꞉na eta guduino kukala ihateme tetete okoha꞉ talona hegelalo duluhukunako, la꞉le dito ododinakomata mabu Godote ba꞉ma ka꞉na kagoenaha꞉, tama itamida kukala ihate komote talona hegeloeno kukala kadikamidalema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Iyo, la꞉eno ododi ba꞉ ba꞉ma ka꞉nala, la꞉le Godokono ubi komamo kopapamila꞉halema꞉ Mosesekono hiliyonomo tutumu ipuwalo kapiya kodakodalo ba lawe okoha꞉ talona hegeloeno kukala ba꞉bo adikamidalenakomata. Ba꞉bema꞉ nale okoha꞉ talona hegelalo eta temetema꞉goeno dubu da꞉hiduimimo, huiyatiya mabu keka꞉ la꞉le natamo da꞉maubahalitama? ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","A꞉iye, la꞉ hunu gabodo naeno komo dito akanagiya꞉midanama꞉la꞉, wadiyala la꞉ huiyatiya Godokono tuputupu gabodo lumagino komo nanagiya꞉midama꞉la꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ba꞉ba tetelo Yelusalema habalo demedehonama꞉ komo iba꞉te na꞉ga꞉luya꞉, “Aba꞉ hibila꞉ka꞉, ba꞉moe dubu ba꞉ komopa꞉te anakapumima꞉ dewagelena ba꞉be lumagila! ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Numa꞉la꞉, ebete hilopoheno tabo hawakala bolamagita, huiyatiya aeno watowatopa꞉te ebe duhimima꞉ eta tabo kaga꞉lutaha꞉. Diyala, iba꞉te da꞉ iya꞉tawahala꞉, ba꞉moe dubuti Godokono Oemedawa Kelisoma꞉ deda꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","A iya꞉tawahala ba꞉moe dubuino haba komo, huiyatiya Godokono Bukate a biya꞉tua꞉mena, hibi Kelisote da꞉puluhukumini, ba꞉ba tetelo tawakaluba꞉te a꞉kiya꞉tawahamena꞉ ebete kebene da꞉pemene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ba꞉bema꞉ Ya꞉suti Godoko Adikumino Hiya꞉ Genamalo tawakalubi ba iya꞉tulamita ibulunomo na꞉goiya꞉, “La꞉ hibilo iya꞉tawahala꞉ka꞉ nale kebene da꞉piya꞉mo ba꞉be haboeno komo? Ba꞉gala naeno komoma꞉ la꞉godolo hibi iya꞉tawa ba꞉kitana? La꞉ nulia꞉la꞉, na ha꞉kiya naeno ubilo kapiya꞉ha꞉ la꞉tamo, na Kodawate poenamiya꞉. Ebe ba꞉ hibi komo hawakalimidawala, huiyatiya la꞉le ebeno komo kiya꞉tawahanaha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","iyo, na ha꞉kiya ebeno komo iya꞉tawala, mabu nale ebegodone piya꞉mo ba꞉gala ebete na a꞉poenamiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ba꞉be taboma꞉ komopa꞉te ubila Ya꞉suku du genamamo ihatema꞉, huiyatiya ibi ipuwalo etate ebe kalawiya꞉ha꞉ mabu ba꞉be komote hibilo uluhukuma꞉ Godogodone tete pehenola. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Huiyatiya ba꞉be atu tetelo komo tawakalubi hiliyonomate Ya꞉suku hibima꞉ midilo na꞉ga꞉luya꞉, “Ba꞉moe dubugodolo hanohano komo hiliyonomo ulamenakoma꞉, ba꞉bema꞉ ebe da꞉ Kelisotela꞉. Iyo, eta lumagiti Keliso mahilamo da꞉mahigamene, ebeno helote ba꞉moe dubuino helo a꞉kagogolamene!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Hiliyonomo tawakaluba꞉te Ya꞉sukunu komoma꞉ tabo ganalo da꞉ga꞉litiya꞉, Pa꞉lisi kapiyuimipa꞉te uliti ba꞉bene ibi ba꞉gala Godotamo hawa꞉goeno ikamehopino watowatopi iba꞉te komo Godoko Adikumino Genama lawamepi dubu ba꞉bo noelamiya꞉, iba꞉te Ya꞉suku nelawete du genamamo kopihatema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ba꞉be atu tetelo Ya꞉suti tawakaluba꞉tamo nolamagitiya꞉, “Na la꞉go nanekela꞉mo emedete, na da꞉poenamiya꞉ ba꞉be Kodawatamo gala kakatoma꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ba꞉bene la꞉le na nipo kohowadinima꞉nemata, mabu nale kebe habamo da꞉tomo la꞉le ba꞉be habamo tolame modoboha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ba꞉bema꞉ Yu watowatopa꞉te ibi ipuwalo na꞉ga꞉luya꞉, “Ba꞉moe dubuti kebe habamo na꞉ka꞉tomene, ba꞉bene ale ebe umima꞉ a꞉kamodobama꞉? Diyala, aeno komo tawakaluba꞉te hiya꞉hiya꞉ Yuha꞉pino hopolo da꞉nemedehona, ebete iba꞉tamo da꞉ tomene iba꞉go konemedema꞉, ba꞉bene ebete ba꞉bi Yuha꞉pi Godokono tabo da꞉niya꞉tulamemene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ebete na꞉goe, ‘La꞉le na nipo kohowadinima꞉nemata,’ ba꞉gala ebete gala na꞉kagoe, ‘Nale kebe habamo da꞉tomo la꞉le ba꞉be habamo pelame modoboha꞉.’ A꞉iye! Ebeno taboeno ipuwa keba ka꞉nala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yunapino Mimiya Etemotehoeno Poko ipuwalo kuititi hegela ba꞉ ko hegelanomoma꞉ eda꞉na. Ba꞉bene ba꞉be hegelate da꞉piya꞉ Ya꞉suti tawakalubi hiliyonomo ipuwalo mahigate ibulunomo na꞉goiya꞉, “Kebe lumagi beya kapete dumina, wadiyala ebete pete nagodolo beya na꞉pena꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ba꞉gala kebe lumagiti na hibima꞉ da꞉midinimini, ba꞉be lumagino tepo ipuwane wiboha꞉ ka꞉ka꞉ beyate ba꞉peka꞉ka꞉la꞉namene, mabu Godokono Bukate ba꞉ba ka꞉na goena.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Buka ka꞉lamiholedawa, wadiyala ama꞉ niya꞉tawa Ya꞉suti ba꞉moe tabo Godokono Gobogoboeno komoma꞉ olamagitiya꞉. Iyo, dopamo tetelo Gobogoboeno helote Ya꞉suku hibima꞉ midipa꞉godolo kitanamiha꞉, huiyatiya Godote ebe hoe ipuwane dadipatiya꞉, ebete Hunu Habamo odolote ko alonomote ebe ba꞉bo na꞉la꞉minuya꞉. Ba꞉ba tetelo Ya꞉suku hibima꞉ midipa꞉te Gobogoboeno helo hibilo ba꞉bo lawiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ya꞉sukunu tabo dulihuya꞉ ba꞉bi tawakalubi ipuwalo komo hiliyonomate na꞉ga꞉luya꞉, “Ba꞉moe dubu ba꞉ Godokono Hiya꞉nomo Ukui Hawakalimidawala, Mosesete dopamo pema꞉ hibilo da꞉goiya꞉ ba꞉moe ba꞉bela.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Huiyatiya komopa꞉te na꞉ga꞉luya꞉, “Ao, ebe ba꞉ Kelisotela, Godokono Oemedawala.” Ba꞉gala komopa꞉te na꞉kaga꞉luya꞉, “Ao, ba꞉moe dubu Ga꞉lili hoponapila. Modoboha꞉ Kelisote ba꞉bako kuba hopone pehawakala, ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","mabu Godokono Bukate a biya꞉tua꞉mena, Kelisote Da꞉ibidikono Beteleheme habalo ebeno eyoni guguda꞉godone kohawakalama꞉ne, Ga꞉lili hopoloha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ba꞉bema꞉ tawakalubi ipuwalo Ya꞉sukunu komoma꞉ anagiya꞉mida komote uluhukuya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ba꞉gala komopa꞉te ubila ebe du genamamo kihatema꞉, huiyatiya ba꞉ba tetelo ibi ipuwalo eta lumagiti ebetamo eta komo kododiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ba꞉bene Pa꞉lisi kapiyuimipi ba꞉gala Godotamo hawa꞉goeno ikamehopino watowatopi, iba꞉te Ya꞉suku lawema꞉ kebe dubu dopamo da꞉noelamiya꞉, ba꞉bi dubate Ya꞉suku laweheno gala dito kapelamiya꞉. Ba꞉bema꞉ Yu watowatopa꞉te ibi na꞉kiyalamiya꞉, “Keka꞉ mabu la꞉le ba꞉be dubu atamo kamagaheha꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ba꞉bi dubate ibino tabo ba huiya na꞉ga꞉luya꞉, “Ba꞉be dubuino tabo hidonomola, a dopamo ba꞉bako tabo kulinakuiha꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ba꞉bene Yu watowatopa꞉te ibi ba kiyahalame na꞉ga꞉luya꞉, “A꞉iye! La꞉ ebeno ha꞉da amiho tabo uliti hibima꞉ a꞉ka꞉midioma? ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Numa꞉la꞉, a Pa꞉lisi kapiyuimipi ba꞉gala komo watowatopi, a ipuwalo eta lumagiti ebeno tabo hibima꞉ kamidinaha꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ba꞉ hibila, kebe kuba dalowa꞉ tawakaluba꞉te ibino ubi komo ebetamo dihatena, iba꞉te Mosesekono tutumu tabo hidamo niya꞉tawahatale, iba꞉te atumu ebe hibima꞉ ba꞉ka꞉midina꞉. Huiyatiya ibi hiliyonomo ba꞉ daedaepila, ba꞉bema꞉ Godote ibi Koe Habamo kiya꞉hekema꞉ne!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ba꞉ba tetelo Nikadimasiti ba꞉bi watowatopino kapiyuimi ipuwalo na꞉lutiya꞉, ebe ba꞉ du tetelo Ya꞉sukuba꞉ tabo olamaginama꞉ dopamo da꞉toniya꞉ ba꞉be dubula. Ba꞉bene ebete komo watowatopa꞉tamo na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“La꞉ hidamo! Aeno eta tutumu tabote a biya꞉tua꞉mena, eta lumagino hibi komo lawema꞉ ebeno tabo ulihino ale ebe hunu gabodo kubama꞉ dito a꞉kaga꞉lama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ba꞉bene iba꞉te ebe ba kiyahame na꞉ga꞉luya꞉, “A꞉iye! Ama꞉ ba꞉ atumu Ga꞉lili hopoeno dalowa꞉ lumagi etala꞉ka꞉? Wadiyala ama꞉ Godokono Buka taboeno komokomo nulameholiya꞉, ba꞉bema꞉ ama꞉ kiya꞉tawama꞉na꞉ta Godokono ukui hawakalimipi hiliyonomo ipuwalo etate Ga꞉lili hopone dopamo kuluhukunakuiha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ba꞉bene da꞉gapogapohoniya꞉ ba꞉bi tawakalubi hiliyonomate ibino hiya꞉hiya꞉ genamamo ba꞉bo tolameholeniya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","huiyatiya Ya꞉suti Olibi Kehakeha Hunu Hakamo ba꞉ dito toniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ba꞉bene eta hegelalo Ya꞉suti Godoko Adikumino Hiya꞉ Genamamo duiduiyanomolo gala kapete, tawakalubi hiliyonomate ebetamo da꞉pelamiya꞉, ebete emedete ibi iya꞉tulame ba꞉bo tupuimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ba꞉ba tetelo komo Godokono tutumu iya꞉tulamepi ba꞉gala Pa꞉lisi kapiyuimipi, iba꞉te eta kamena lawete tawakalubino holoholo hapuamo ba꞉ dito magatuya꞉, mabu ba꞉moe kamenate eta kamenoeno awa꞉go konomo kuba ododitalo iba꞉te ba꞉bo ulamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ba꞉bema꞉ iba꞉te Ya꞉suku na꞉kiyamiya꞉, “Iya꞉tulamedawa, ba꞉moe kamena eta kamenoeno awa꞉go konomo kuba ba ododita, ale ibi ulamete ba꞉moe kamena ba꞉bo lawema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesekono tutumu tabote a biya꞉tua꞉mena, ba꞉mako kamenoeno kuba ododi mabuma꞉ wadiyala tawakaluba꞉te ebe nakolamo mapemete nanakapuma꞉mena꞉. Ba꞉bema꞉ amia꞉no ukui keba ka꞉nala꞉ka꞉? Ale ebetamo hoe huiya ba꞉kikamema꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iba꞉te ba꞉moe tabo Ya꞉sutamo na꞉ga꞉litiya꞉, mabu ibi ubila tawakalubino holoholo hapulu Ya꞉sukunu komo ba꞉ma ka꞉na hawakalimi, ebete Mosesekono tutumu tabamo da꞉papamiwatamene o da꞉ a꞉kapapamiwatamene. Ebete papamiwataha꞉ma꞉ da꞉goemene, ba꞉ba tetelo iba꞉te ebe kubadawama꞉ koga꞉lama꞉na꞉. Ya꞉suti huiyatiya ibino tabo huiyaheno tudiwatate ebeno kokotamo hakamo hiya꞉hiya꞉ tabo bimiya꞉teholitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ba꞉bema꞉ iba꞉te atu alateda꞉ tabo ebe kiyahame ekelalameheno, ba꞉ba tetelo Ya꞉suti mahigate na꞉goiya꞉, “Kubahenola, la꞉ ipuwalo pote kuba ododiha꞉dawama꞉ deda꞉na, wadiyala ba꞉bete dopo nakola lawete ebe na꞉mida꞉ma꞉mene, ba꞉bene la꞉ komopa꞉te gala hapuni ebe mapemete ba꞉bo nanakapumiya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ba꞉bene Ya꞉suti hakamo gala katudiwatate ebeno kokotamo komo hiya꞉hiya꞉ tabo bekamiya꞉teholitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ba꞉bema꞉ puya꞉te Ya꞉sukunu tabo duliya꞉, iba꞉te ukui hiya꞉ma꞉ midiliti, ba꞉bene ibi ipuwalo eta kapiya tonakui, eta kapiya tonakui, ba꞉bi dubu hiliyonomate hiya꞉hiya꞉ ba꞉ma ka꞉na tolameholiya꞉ kadelekadela꞉godone tupuimiti uli ape dubatamo nuluhuku. Ba꞉ba tetelo Ya꞉suku kapiyate ba꞉bolo lutiya꞉, ba꞉gala ba꞉be kamenate ebeno holoholo hapulu na꞉la꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ba꞉bene Ya꞉suti ebeno wato adipatete kamenatamo na꞉goiya꞉, “Kamena, kuba huiya ama꞉tamo ikamema꞉ dewagelitaka, ba꞉bi tawakalubi keka꞉? Ama꞉ kuba dawama꞉ da꞉goita, eta ba꞉bako lumagi ba꞉ka꞉luta?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ebete huiyatiya na꞉goiya꞉, “Ao, Kodawa, natamo kuba huiya ikanamedawa puliyala.” Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Na ba꞉ atumu ama꞉tamo kuba huiya a꞉kikama꞉mata. Wadiyala ama꞉ na꞉toa, galane tetelo ba꞉bako kuba gala akododa꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Eta tetelo Ya꞉suti Pa꞉lisi kapiyuimipa꞉tamo gala na꞉kolamagiya꞉, “Na ba꞉ ba꞉moe hopo konomoeno alola. Kebe lumagiti na da꞉ta꞉mahenena ebete du ipuwalo a꞉kapata꞉namene mabu ebegodolo hibi ka꞉ka꞉ alote bitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ba꞉bene Pa꞉lisi kapiyuimipa꞉te ebetamo na꞉ga꞉luya꞉, “Ama꞉ ha꞉kiya ama꞉ adipatelo da꞉gaa꞉, ba꞉bema꞉ tawakaluba꞉te amia꞉no tabo a꞉kalawa꞉mena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Ao, na ha꞉kiya na a꞉kadipata꞉lemo, huiyatiya naeno hibi komo na ha꞉kiya na꞉hawakalimitale, naeno hiya꞉hiya꞉ tabote hibinomoma꞉ beda꞉hana꞉, mabu na kapiyate iya꞉tawala nale kebene ka꞉piya꞉mo ba꞉gala nale gala kebamo da꞉katomo. La꞉le huiyatiya naeno komo kiya꞉tawahanaha꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","mabu la꞉ hopo habanapino ukui gabodo lumagino komo dito anagilamelemenakomata! Numa꞉la꞉, nale ba꞉moe hopolo ba emedena eta lumagino komo anagiya꞉midamete kuba huiya a꞉kikama꞉lemo, ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","huiyatiya keba tetelo nale eta lumagino komo nanagiya꞉midametale ebeno komo hibilo ba꞉hawakalimina꞉, mabu Nabiwiti na da꞉poenamiya꞉ ebete helo natamo ikanamiya꞉ ba꞉be komo kododima꞉. Ebeno ukui ba꞉gala naeno ukui ba꞉ kapiyala, ba꞉bema꞉ nale eta lumagino komo kubama꞉ da꞉goitamo na kapiyate kagoitaha꞉, ba꞉ba tetelo naeno Nabiwiti atu tabo bekagoita. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","La꞉eno eta tutumu tabote ba꞉ma ka꞉na goena, tawakalubino anagiya꞉mida ipuwalo netewapa꞉te atu tabo da꞉ga꞉lamena꞉ tabo anagiya꞉midapa꞉te ba꞉be komo hibima꞉ koga꞉lama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ba꞉bema꞉ numa꞉la꞉, nale naeno hibi komo ba hawakalimina, na da꞉poenamiya꞉ ba꞉be Nabiwiti atumu naeno hibi komo la꞉tamo na꞉kahawakalimina.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ba꞉ba tetelo iba꞉te ebe na꞉ga꞉lamiya꞉, “Amia꞉no nabiwi ale kumitaha꞉. Ebe keka꞉?” Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Na ba꞉gala naeno Nabiwi, aeno komo la꞉ kiya꞉tawahanaha꞉. La꞉le naeno hibi komo niya꞉tawahotale, naeno Nabiwino komo atumu la꞉ biya꞉tawahona꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ya꞉suti Godoko Adikumino Hiya꞉ Genamalo ba luta, ebete ba꞉be Genamoeno malemale mani miya꞉tehoeno habalo tawakalubi ba iya꞉tulamita ba꞉moi tabo komokomo Pa꞉lisi kapiyuimipa꞉tamo ba꞉bo olamagiya꞉. Ba꞉ba tetelo komopa꞉te ubila ebe du genamamo kihatema꞉, huiyatiya ibi ipuwalo etate ebe kalawiya꞉ha꞉ mabu ba꞉be komote hibilo uluhukuma꞉ Godogodone tete pehenola. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ba꞉bema꞉ Ya꞉suti Pa꞉lisi kapiyuimipa꞉tamo gala na꞉kagoiya꞉, “Tete tatalila, nale la꞉ komiya꞉palema꞉nemata, ba꞉bene la꞉le na ba ohowadini la꞉ la꞉eno kuba ododili ipuwalo ba꞉ dito koha꞉lahama꞉nemata, mabu nale kebe habamo da꞉tomo la꞉ ba꞉be habamo nago tolame modoboha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ba꞉bema꞉ Yu watowatopa꞉te ibi ipuwalo na꞉ga꞉luya꞉, “Mabu keka꞉ ebete da꞉goe a eba꞉go tolame modoboha꞉? Ba꞉moe taboeno ipuwa ba꞉ma ka꞉nala꞉ka꞉, ebe ha꞉kiya ebe ba꞉kanakapumimini?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ba꞉bema꞉ Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “La꞉ ba꞉ ba꞉moe hopo tawakalubilata, huiyatiya na Hunu Habane piya꞉mo, na ba꞉moe hopo lumagiha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ba꞉bema꞉ nale la꞉ hibinomolo ba꞉ma ka꞉na goelamemata, la꞉ la꞉eno kuba ododili ipuwalo koha꞉lahama꞉nemata, mabu na ba꞉ emedena tetelo demedenamo ba꞉be Kodawala. La꞉ ba꞉moe komo hibima꞉ midihino, ba꞉ hibila, la꞉ hiliyonomate la꞉eno kuba ododili ipuwalo koha꞉lahama꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ba꞉bene tabo ulihopa꞉te ebe na꞉ga꞉lamiya꞉, “Ama꞉ potela꞉ka꞉?” Huiyatiya Ya꞉suti iba꞉tamo na꞉goiya꞉, “Tupuimi mabuni nale la꞉ ba꞉ma ka꞉na a꞉goelamimata, na ba꞉ ba꞉be Kodawala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ba꞉bema꞉ nagodolo komo hiliyonomo tabo komokomo ba꞉pola꞉na, nale la꞉ mabuma꞉ ba olamagi la꞉eno komo ba꞉bo kanagilamelelamema꞉nemata. Huiyatiya numa꞉la꞉, ba꞉bi tabo komokomate nagodone kapelamenaha꞉, na Oenamedawagodone pelamena. Ba꞉be Kodawa ba꞉ hibi komo hawakalimidawala, ba꞉bema꞉ nale ya꞉lo tetelo ebegodone kebe tabo komokomo kulihuya꞉mo na la꞉tamo ba꞉bi atu tabonomo beka-olamaginakomo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ba꞉ba tetelo iba꞉te hidamo kemalagidoluya꞉ha꞉, Ya꞉suti Nabiwi Godokono komoma꞉ dolamagiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ba꞉bema꞉ Ya꞉suti iba꞉tamo gala na꞉kagoiya꞉, “La꞉ hopo habanapa꞉te na Tawakalubino Naniwi keha pihiga hunamo dadipanatenema, la꞉ naeno komo ba꞉ma ka꞉na hibilo kiya꞉tawahama꞉nemata, na ba꞉ emedena tetelo demedenamo ba꞉be Kodawala, ba꞉gala nale kebe komokomo kododilinamo na ha꞉kiya naeno heloamo kododilinaha꞉, mabu na Oenamedawate na kebe tabo komokomo ka꞉kiyanamiya꞉ nale tawakaluba꞉tamo ba꞉bi atu tabonomo beka-olamaginakomo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ba꞉gala eta komo. Na da꞉poenamiya꞉ ba꞉be Kodawate hiliyonomo tetelo naeno ododili komoma꞉ natamo na꞉kalakalana, ba꞉bema꞉ ebete nago ba emedena na kamiya꞉panenaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ba꞉ba tetelo komo tawakalubi hiliyonomate Ya꞉sukunu tabo dulihuya꞉, iba꞉te ebe hibima꞉ ba꞉bo midiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ba꞉bene Yu tawakalubi ipuwalo puya꞉te Ya꞉suku hibima꞉ da꞉midiya꞉, ebete iba꞉tamo na꞉goiya꞉, “La꞉ naeno iya꞉tulame ipuwalo demedenama, la꞉ ba꞉ naeno hibi ta꞉matapilata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ba꞉bene la꞉ Godokono hibi komo kiya꞉tawahama꞉nemata, iyo, ba꞉be hibi komote la꞉ huiyaha꞉ menemene oko ipuwane uluhukulatelete tutupima꞉ komidilima꞉na꞉ta, ba꞉gala eta kubadawoeno eta matuhumiho komote la꞉godolo a꞉kitanamene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ba꞉ba tetelo iba꞉te tabo ba huiya na꞉ga꞉luya꞉, “A ba꞉ A꞉ibalahamakono eyoni gugudila. Iniwalino tetene tupuimiti ba꞉ma teta꞉mo puluhuku, a ipuwalo eta lumagiti eta kubadawoeno huiyaha꞉ okodawama꞉ keda꞉namiha꞉, ba꞉gala ale eta lumagino matuhumiho komo a꞉kiya꞉tawahalema꞉. Ba꞉bema꞉ mabu keka꞉ ama꞉ atamo da꞉gaa꞉, Godokono hibi komote a huiyaha꞉ oko ipuwane kuluhukua꞉tema꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ba꞉bene Ya꞉suti iba꞉tamo gala na꞉kagoiya꞉, “Na la꞉tamo hibi tabonomo begoemo, puya꞉te kuba ododili ipuwalo demedehona, ibi ba꞉ kuboeno huiyaha꞉ okopima꞉ eda꞉hana. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hibi gudunomote ebeno nabiwino genamanapi ipuwalo emedena tetelo kalakalago bemedenamene, huiyatiya huiyaha꞉ okodawoeno komo eba ka꞉naha꞉. Ebete ebeno oko namutudawoeno matuhumiho ipuwalo bemedena, ba꞉bema꞉ eta tetelo ba꞉be namutudawate ebe ubiha꞉ma꞉ deda꞉mene, ebete ebeno genamane ebe dito konoemema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ba꞉bema꞉ la꞉ nulia꞉la꞉. Godokono Guduti la꞉ eta kubadawoeno matuhulame ipuwane uluhukulatelete ebeno tutu badininipala ekakima꞉ da꞉midilimina꞉, ba꞉ba tetelo la꞉ hibinomolo tutuma꞉ keda꞉hama꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Na iya꞉tawala la꞉ ba꞉ A꞉ibalahamakono eyoni gugudila, huiyatiya la꞉ naeno iya꞉tulame komo kuwatenaha꞉ ba꞉bema꞉ la꞉ ubila na kanakapunamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Numa꞉la꞉, naeno Nabiwiti ya꞉lo tetelo natamo da꞉hawakalilamiya꞉ na ba꞉bi atu komo la꞉tamo a꞉hawakalilamenakomo, ba꞉gala la꞉ ba꞉ atumu, la꞉eno ha꞉da amiho nabiwiti kebe komokomo kiya꞉tulametiya꞉la la꞉ ba꞉bi komo kapiya bododilinakomata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ba꞉bene iba꞉te ebeno tabo ba huiya na꞉ga꞉luya꞉, “Aeno nabiwi ba꞉ A꞉ibalahamatela.” Ba꞉ba tetelo ebete ibi na꞉goelamiya꞉, “La꞉ A꞉ibalahamakono hibi gugudima꞉ neda꞉honatale, ebete dododilinakui la꞉ ba꞉bi atu hidohido komo bododilionakona꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Numa꞉la꞉, nale Godogodone kebe hibi komokomo kulihuya꞉mo, na ba꞉bi atu komo la꞉tamo a꞉hawakalilamenakomo. Ba꞉bema꞉ la꞉ ubila na kanakapunamema꞉, huiyatiya la꞉eno iniwa nabiwi A꞉ibalahamate dopamo eta tuputupu lumagitamo maubate ebe anakapumima꞉ kewageliya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ba꞉ hibila, la꞉eno eta nabiwi bemedena, ba꞉be kubadawate kebe komokomo kododilinako la꞉ ba꞉bi atu kuba komo beka-ododilinakomata, la꞉le huiyatiya A꞉ibalahamakono hidohido komo kododilinaha꞉!” Ba꞉bene iba꞉te ebeno tabo ba huiya na꞉ga꞉luya꞉, “A pilo gabodo kahawakalahaliya꞉ha꞉, iyo, a nabiha꞉ gugudima꞉ keda꞉hanaha꞉. Ba꞉bema꞉ Godoko kapiya ba꞉ aeno Nabiwila, ba꞉gala a ba꞉ ebeno hibi gugudinomola.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ya꞉suti iba꞉tamo na꞉goiya꞉, “Godote la꞉eno hibi Nabiwima꞉ neda꞉natale, la꞉le na malemalelo bemalagidoloneonana꞉, mabu na ba꞉ Godogodone la꞉tamo piya꞉mo. Iyo, na ha꞉kiya naeno heloamo kapiya꞉ha꞉, na Godote poenamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Huiyatiya la꞉le ba꞉moe taboeno ipuwa hidamo kalaweha꞉, mabu la꞉le naeno iya꞉tulame komo ubiha꞉ma꞉ eda꞉hanamata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Numa꞉la꞉, la꞉eno nabiwi ba꞉ Saitanatela, ba꞉bema꞉ la꞉le ebeno gugudima꞉ ba eda꞉hana ebeno ubi komamo papamila꞉hanakomata. Dopamo tupuimi mabuni ebe ba꞉ tuputupu lumagi anakapumidawala, ba꞉gala ebete Godokono hibi komo ubiha꞉ma꞉ eda꞉nami. A꞉iye, ebeno ododili ipuwado ebe ha꞉kiya ebeno komo ba꞉ma ka꞉na hawakaliminako, ebete ha꞉da tabo kapiya bolamaginako mabu ebegodolo eta hibi komo kitanaha꞉. Iyo, ebe ba꞉ ha꞉da amihopino nabiwima꞉ eda꞉na, mabu hiliyonomo ha꞉da amihoho komate ebegodone pikulina! ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na huiyatiya hibi tabo komokomo kapiya bolamaginakomo, ba꞉bema꞉ la꞉le la꞉eno ha꞉da amiho nabiwi huiyama꞉ ba eda꞉hana la꞉ na hibima꞉ kamidininaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","La꞉ iya꞉tawahala na hibi tabo olamagidawala, ba꞉gala la꞉ ipuwalo eta lumagi modoboha꞉ na kuba ododidawama꞉ ka꞉nami. Ba꞉bema꞉ mabu keka꞉ la꞉le na hibima꞉ kamidininaha꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ba꞉moe komo ba꞉ hibila, kebe tawakaluba꞉te Godokono hibi gugudima꞉ deda꞉hamena꞉ iba꞉te ebeno tabamo ba꞉papamila꞉hanakomena꞉, huiyatiya la꞉ eba ka꞉naha꞉, ba꞉bema꞉ la꞉ ebeno tabo a꞉kulia꞉lemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ba꞉ba tetelo komo Yunapa꞉te Ya꞉sutamo na꞉ga꞉luya꞉, “Ale amia꞉no komo hibinomolo ba꞉ma ka꞉na hawakalimima꞉, ama꞉ ba꞉ kuba Samaliya hoponapilata ba꞉gala ama꞉ ipuwalo kuba gobogobote bemedena.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Na ipuwalo kuba gobogobote kemedenaha꞉. Ao, naeno ododili komate naeno Nabiwino mahilo hunamo adipatenako, huiyatiya la꞉le naeno mahilo bekubahiminakomata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na ha꞉kiya na a꞉kawagaminalemo, mabu eta Kodawate naeno komo ba anagiya꞉midaname ebete na ba꞉bo kawagaminanema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ba꞉bema꞉ nale la꞉tamo hibi tabonomo begoemo, kebe lumagiti naeno iya꞉tulame tabamo da꞉papamiwatamene ebete hoe a꞉kuma꞉mene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Ba꞉ba tetelo tabo ulihopa꞉te Ya꞉sutamo gala na꞉kaga꞉luya꞉, “Amia꞉no tabo olamagi komodo a hibilo iya꞉tawahama꞉ ama꞉ kuba gobogobagoenola. Mabu A꞉ibalahamako ba꞉gala komo Godokono ukui hawakalimipi ibi hiliyonomate a꞉ha꞉lahuya꞉, huiyatiya ama꞉le na꞉gaa꞉ta kebe lumagiti amia꞉no tabamo da꞉papamiwatamene ebete hoe a꞉kuma꞉mene! Ama꞉ na꞉kemalagidoluta amia꞉no helote A꞉ibalahamakono helo ba꞉gala komo Godokono okopino helo na꞉gogolena? A꞉iye, amia꞉no awagaha komo bada konomola꞉ka꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ba꞉bene Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Keba tetelo na ha꞉kiya na nawagaminatale, ba꞉be awagaha ipuwalo eta hibi komote ba꞉ka꞉-itanana꞉. Huiyatiya naeno Nabiwiti na nawagaminanena, naleha꞉. Ebe ba꞉ la꞉le hibi Godoma꞉ da꞉ka꞉minama, ba꞉betela. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","La꞉ ebeno komo hibilo iya꞉tawaha꞉, huiyatiya na kapiyate ebeno komo iya꞉tawala. Numa꞉la꞉, nale la꞉tamo ba꞉ma ka꞉na na꞉goetale, ‘Na ebeno komo iya꞉tawaha꞉,’ na ha꞉da tabo ba꞉goena꞉, huiyatiya na la꞉ ha꞉da amihopi huiyaha꞉, ba꞉bema꞉ nale Nabiwino hibi komo iya꞉tawala ba꞉gala nale ebeno ubi komokomo kapiya bododilinakomo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ba꞉gala la꞉ ba꞉moe eta komo nemalagidolala꞉. La꞉eno iniwa nabiwi A꞉ibalahamate ebeno tepo ipuwalo naeno pe komo demalagidolonakui ko kalakala komo biya꞉tawanakui, iyo, ba꞉be hegelate pema꞉ ebete kalakalago latiminami.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ba꞉ba tetelo tabo ulihopa꞉te ebe na꞉ga꞉lamiya꞉, “A꞉iye! Ama꞉ aeno iniwa A꞉ibalahamako hibilo a꞉kumiuya꞉la? Ebete ya꞉lo tetenomolo a꞉hoiya꞉ ba꞉gala ama꞉ 50 gogo tete lumagiha꞉, ama꞉ ba꞉ uli ape dubulata!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ba꞉bene Ya꞉suti iba꞉tamo ba huiya na꞉goiya꞉, “Na la꞉tamo hibi tabonomo begoemo, na ba꞉ emedena tetelo demedenamo ba꞉be Kodawala. A꞉ibalahamate hawakalaha꞉ tetelo na dopamo Godokoba꞉ emedenamimo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ba꞉ba tetelo iba꞉te ba꞉be tabo mabuma꞉ konomamo maubahalete nakola ba꞉bo uwatiya꞉ ebe mapemete kanakapumima꞉, huiyatiya Godote ebe ugumuilo Adikumino Hiya꞉ Genama miya꞉pate ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Eta hegelalo Ya꞉suti ba tonato baidi tamiho dubu ba꞉bo numiya꞉, ba꞉be dubuti ebeno menokoeno tepo ipuwane ba꞉ba ka꞉na pehawakaluya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ba꞉bene Ya꞉suku ta꞉matapa꞉te ebe nalatediya꞉, “Iya꞉tulamedawa, ba꞉moe dubuti baidi tamiholo da꞉pehawakaluya꞉ pokono kubala꞉ka꞉? Ebenola꞉ka꞉ o ebeno menoko nabiwi ibino kubala꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ba꞉bene Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Ba꞉moe dubuino kubaha꞉, ba꞉gala ebeno menoko nabiwi ibino kubaha꞉. Ba꞉moe dubuti ba꞉ma ka꞉na da꞉pehawakaluya꞉, ba꞉be mabu bitana Godote ya꞉lo tetelo ubi bihatiya꞉ ebeno okoeno ko helo ebegodolo kohawakalimima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","La꞉ nulia꞉la꞉, a hegeloeno alo ipuwalo ba emedena, na da꞉poenamiya꞉ ale ba꞉be Kodawoeno oko bowatihonama꞉, huiyatiya du komote ba꞉ na꞉pe, ba꞉ba tetelo eta lumagiti oko a꞉kowata꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nale ba꞉moe hopolo ba emedena na ba꞉ hopo haboeno aloma꞉ eda꞉namo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ba꞉ba tetelo Ya꞉suti ba꞉be tabo olamagiti, ebete kowe hakamo mehamidate ba꞉be kowa꞉mo bula꞉i ododiti dubuino baida꞉mo abutilamelemete ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ebe na꞉goemiya꞉, “Ama꞉ Silomo mahilagoeno mala꞉ ikila baha꞉mo tote mala꞉ ba꞉bo na꞉neta.” Silomo mahiloeno ipuwa ba꞉ nitana ‘Oeme Komola.’ Ba꞉bene ba꞉be dubuti ba꞉be mala꞉ ikila bahilo mala꞉ da꞉netuya꞉, ebeno baiditi na꞉la꞉minalemete ebete hopo uma꞉go gala ba꞉bo kapiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ba꞉ba tetelo ebe tamelo demedehonama꞉ ba꞉gala puya꞉te dopamo ebe manima꞉ toetoelo duminakui, iba꞉te ebe umiti ba꞉bo ga꞉luya꞉, “Ba꞉moe dubu ba꞉ gabo tamelo emedete manima꞉ da꞉toetoitanakui, ba꞉moe ba꞉be dubula꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Komopa꞉te ibino tabo ba huiya na꞉ga꞉luya꞉, “Iyo, ebe ba꞉ ba꞉betela,” huiyatiya komopa꞉te na꞉ga꞉luya꞉, “Ao, ebe ebeteha꞉, ebeno holoholo huiya lumagi etala.” Huiyatiya ba꞉be dubuti ha꞉kiya ebeno komo ba hawakalimi na꞉goiya꞉, “Na ba꞉ ba꞉be dubula.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ba꞉bene iba꞉te ebe na꞉ga꞉lamiya꞉, “Amia꞉no baidi keba ka꞉na ka꞉hidohidohometa?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ebete ibino tabo ba huiya na꞉goiya꞉, “Eta dubu ebeno mahilo ba꞉ Ya꞉sutila, ebete kowe hakamo mehamidate ba꞉be kowa꞉mo bula꞉i ododiti naeno baida꞉mo ba꞉bo miya꞉te. Ba꞉bene ebete na na꞉goename Silomo mala꞉ ikila bahilo mala꞉ konetama꞉. Nale ba꞉ba ka꞉na da꞉nododimo, naeno baiditi ba꞉bo a꞉la꞉minahale.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ba꞉bene iba꞉te ebe gala na꞉kaga꞉lamiya꞉, “Ama꞉ da꞉hiduima꞉, ba꞉be dubu keka꞉?” Ebete na꞉goiya꞉, “Na iya꞉tawaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Ya꞉suti baidi tamiho dubu kohiduimima꞉, ebete kebe hegelalo bula꞉i ododiti ebeno baida꞉mo da꞉miya꞉temiya꞉, ba꞉be hegela ba꞉ Yu tawakalubino okoha꞉ talona hegelala. Ba꞉bema꞉ komopa꞉te ba꞉be hido owalubi komo konehawakalimima꞉, iba꞉te ba꞉be dubu lawete Pa꞉lisi kapiyuimipa꞉tamo dito magatuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ba꞉ba tetelo Pa꞉lisi kapiyuimipa꞉te talona hegeloeno komo ba emalagidolo ebe na꞉ga꞉lamiya꞉, “Amia꞉no baidi kebako gabodo ka꞉hidohidohometa?” Ebete ibino tabo ba huiya na꞉goiya꞉, “Eta dubuti naeno baida꞉mo bula꞉i abutilamelenamete, nale mala꞉ da꞉netamo naeno baiditi ba꞉bo a꞉la꞉minahale.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ba꞉ba tetelo komo Pa꞉lisi kapiyuimipa꞉te na꞉ga꞉luya꞉, “Ba꞉moe dubuti okoha꞉ talona hegeloeno kukala adikamidale, ba꞉bema꞉ ebe Godokono hibi oemedawaha꞉.” Huiyatiya komopa꞉te na꞉ga꞉luya꞉, “Ao, ebe hido lumagila. Kubadawagodolo Godokono helote kitanaha꞉ ba꞉mako hanohano komokomo ododilima꞉.” Ba꞉bema꞉ ibi ipuwalo anagiya꞉mida komote ba꞉ dito uluhukuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ba꞉ba tetelo iba꞉te ba꞉be dubu gala na꞉kaga꞉lamiya꞉, “Amia꞉no baidi da꞉hiduilame, ba꞉be dubu ama꞉le poma꞉ ka꞉goiuta?” Ebete na꞉huiyuya꞉, “Nale ebe Godokono ukui hawakalimidawa etama꞉ goitamo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ba꞉ba tetelo ba꞉be dubuti menokoeno tepone baidi tamiholo da꞉pehawakaluya꞉ ba꞉gala ebeno baiditi ka꞉ma꞉ da꞉hidohidohome, Yu watowatopa꞉te ba꞉bi netewa komokomo hibima꞉ kamidiliya꞉ha꞉. Ba꞉bema꞉ iba꞉te ba꞉be dubuino menoko ba꞉gala nabiwi iba꞉tamo tabo dito oemiya꞉ iba꞉te kopema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Iba꞉te da꞉piya꞉ Yu watowatopa꞉te iba꞉godone ibino guduino hibi komo lawete ibi na꞉goelamiya꞉, “La꞉ a꞉ga꞉lamata ba꞉moe dubu ba꞉ la꞉eno gudula, ba꞉gala la꞉ a꞉ga꞉lamata ebe menokoeno tepone baidi tamiholo pehawakaluya꞉. Ba꞉bema꞉ la꞉ ba꞉moe komo atamo na꞉hawakalima꞉la꞉, ebeno baiditi kebako gabodo ka꞉hidohidohome?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ba꞉bene ebeno menoko nabiwi iba꞉te ibino tabo ba huiya na꞉ga꞉luya꞉, “Hibila, ebe ba꞉ aeno gudula, ba꞉gala a iya꞉tawahala ebe menokoeno tepone baidi tamiholo pehawakaluya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Huiyatiya a iya꞉tawaha꞉ ebeno baiditi kebako gabodo ka꞉hidohidohome ba꞉gala ebeno baidi pote ka꞉hiduilame. Ebe dubu kola. Wadiyala la꞉ ebe na꞉ga꞉lama꞉la꞉, hibi komo ebete la꞉ kokiyalamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ba꞉be dubuino menoko nabiwi iba꞉te tabo ba꞉ma ka꞉na da꞉ga꞉luya꞉ mabu iba꞉te Yu watowatopi betolelamiya꞉. Watowatopa꞉te ya꞉lo a꞉ga꞉luya꞉, kebe lumagiti Ya꞉suku Godokono Oemedawa Kelisoma꞉ da꞉goemene, iba꞉te ebetamo talona kihatemema꞉na꞉ ebete baidi ibubulamehole genama guamo komo tawakaluba꞉go podoloma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ba꞉be mabuma꞉ ba꞉be dubuino menoko nabiwi iba꞉te na꞉ga꞉luya꞉, “Aeno gudu ba꞉ dubu kola, wadiyala la꞉ ebe na꞉ga꞉lama꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ba꞉bene Yu watowatopa꞉te dopamo baidi tamiholo demedenami, ba꞉be dubu iba꞉tamo gala kaka꞉miti ebe na꞉kaga꞉lamiya꞉, “Ama꞉ Godokono holoholo hapulu ba la꞉na hibi komo atamo na꞉hawakalima꞉, ba꞉moe dubu Ya꞉suti ama꞉tamo bada komo kododi? A iya꞉tawahala ebe ba꞉ hiya꞉hiya꞉ kuba ododilidawala.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ba꞉ba tetelo ebete tabo ba huiya na꞉goiya꞉, “Na iya꞉tawaha꞉, ebe da꞉ hido lumagila꞉ o da꞉ hido lumagiha꞉. Huiyatiya na kapiya komo biya꞉tawutamo, na dopamo baidi tamihodawala, ka꞉lo naeno baiditi ba꞉ a꞉la꞉minahale.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ba꞉bene Yu watowatopa꞉te ebe gala na꞉kaga꞉lamiya꞉, “Ebete ama꞉tamo bada komo ododiti amia꞉no baidi ba꞉bo ka꞉hiduilame?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ebete na꞉goiya꞉, “Na hibi tabo la꞉ ya꞉lo a꞉goelamemata, huiyatiya diyala, la꞉ da꞉ hidamo kuliha꞉. Ba꞉bema꞉ la꞉ bada mabuma꞉ ulima꞉ gala da꞉kewagelitama? La꞉ ebeno komo ta꞉matapima꞉ eda꞉hama꞉la꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ba꞉bene iba꞉te huiyatiya ebe iduduputimilo ba kiyahame na꞉ga꞉luya꞉, “Ama꞉ ba꞉ ebeno ta꞉matadawa etalata, aha꞉! A Mosesekono ta꞉matapila! ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mabu a iya꞉tawahala Godote Moseseko ipuwado tabo olamaginakui, huiyatiya moe dubuino hibi komo a iya꞉tawaha꞉. Ebe eta kuba dalowa꞉ habalo ba꞉gala pilo gabodo kuda꞉ a꞉hawakaluya꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ba꞉bene dubuti tabo ba huiya na꞉goiya꞉, “Moe bada kuba komola꞉ka꞉? Ba꞉moe dubuti naeno baidi hanohano gabodo a꞉hiduilame, huiyatiya la꞉ watowatopi iya꞉tawahaha꞉ ebete kebene ka꞉piya꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","A hiliyonomo iya꞉tawahala Godote kuba ododilipino tabo a꞉kulia꞉le, huiyatiya kebe lumagiti ebe Kodawama꞉ goelo ebetamo da꞉papamiwatamene, Godote ba꞉be lumagino tabo kulima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hopo tupuimi mabuni ba꞉ma teta꞉mo puluhuku eta dawate baidi tamiho lumagi da꞉hiduimiya꞉, a hopo tawakaluba꞉te ba꞉be hanohano komo kuminakuiha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ba꞉bema꞉ naeno ukui ba꞉ma ka꞉na itana, ba꞉moe dubu Godogodone peha꞉tale, ebete tawakalubi kowalubilima꞉ eta hido komo ododima꞉ ba꞉ka꞉modobona꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ba꞉ba tetelo Yu watowatopa꞉te ebeno tabo ba huiya na꞉ga꞉luya꞉, “A꞉iye! Ama꞉ menokoeno kuba ododi komodo hawakaluya꞉ta! Mabu keka꞉ ama꞉ a iya꞉tua꞉mema꞉ dewagelita?” Ba꞉bene iba꞉te ko maubago ba꞉be dubutamo baidi ibubulamehole genama guamo pa꞉pa꞉ga talona ihatemete ba꞉ dito oemiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ba꞉bene Yu watowatopa꞉te ba꞉be dubu maubago doemiya꞉, Ya꞉suti ba꞉be komo uliti ebe ohowada꞉go da꞉piya꞉, ebete ba꞉be dubu pumiti ebe na꞉pegoemiya꞉, “Ama꞉ Tawakalubino Naniwi hibima꞉ na꞉ka꞉midiuta?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ba꞉bene ebete na꞉huiyuya꞉, “Kodawa, Tawakalubino Naniwi potela꞉ka꞉? Ama꞉le na diya꞉tunamemena꞉, nale ebe hibima꞉ ba꞉bo komidima꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Ama꞉le ebe numitata, mabu ka꞉lo ama꞉go ba꞉bete olamagita.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ba꞉be dubuti na꞉goiya꞉, “Hibila, Kodawa, na ka꞉lo ama꞉ ba꞉ hibima꞉ na꞉midimata,” ba꞉bene ebete pupamo emedete Ya꞉suku ba꞉bo adikumiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ba꞉bene Ya꞉suti na꞉goiya꞉, “Na hopo habanapino komokomo anagilamelelamema꞉ piya꞉mo. Ba꞉bema꞉ puya꞉te baidi tamiholo demedehona, na ibino baidi kopahalamililamema꞉nemo iba꞉te hiliyonomo komokomo hidamo kulamema꞉, ba꞉gala puya꞉te ha꞉kiya ibino awagaha ipuwalo da꞉ga꞉lana, ‘A baidi a꞉la꞉minahalepila,’ nale ibino baidi huiyatiya duhuma꞉ komidililamema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ba꞉ba tetelo komo Pa꞉lisi kapiyuimipa꞉te Ya꞉suku tamelo da꞉la꞉mota꞉hanuya꞉, iba꞉te ebeno tabo uliti na꞉ga꞉luya꞉, “Ama꞉ na꞉ka꞉goiuta, a atumu baidi tamihopila?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “La꞉ Godokono tabo komokomo iya꞉tawaha꞉ma꞉ neda꞉hatale, ebete la꞉ hibi baidi tamihopima꞉ ka꞉lamihino la꞉eno kuba ododili mabuma꞉ huiya ikalamema꞉ ba꞉ka꞉goena꞉. Huiyatiya la꞉ na꞉ga꞉lanamata, ‘A Godokono tabo komokomo hiliyonomo modobolo ulamenama꞉,’ ba꞉bema꞉ la꞉eno kuba huiyate hibinomolo ba꞉ na꞉pe.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Na la꞉tamo hibi tabonomo begoemo, kebe lumagiti sipi-goegoeno kala ipuwamo gigihodo pa꞉pa꞉gaheno huiyatiya dito tetedo da꞉popegamene, ebe ba꞉ pilo lumagila ba꞉gala ebe ba꞉ komopino ilina heloamo uwatelamedawala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Huiyatiya kebe lumagiti gigihonomodo da꞉pa꞉pa꞉gamene, ebe ba꞉ sipi-goegoeno hibi ulamedawanomola. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ba꞉be ulamedawate duiduiyanomolo kala ipuwane uluhukuma꞉ dewagelemene, gigiho umidawate gigiho ebetamo ka꞉hiya꞉midamema꞉ne. Ba꞉bene ebete ebenonomo sipi-goegoe ibino mahilamo da꞉ka꞉lamimini, iba꞉te ebeno tabo madodo uliti, ebete kala ipuwane ibi ba꞉bo kopuluhukulatelema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ebete ebeno sipi-goegoe hiliyonomo puluhukulatelete, ibi dopalamete ba tonato iba꞉te ebe ba꞉bo kota꞉matama꞉na꞉ mabu iba꞉te iya꞉tawahala ibi ulamedawoeno tabo madodo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Huiyatiya sipi-goegoa꞉te eta hiya꞉ lumagi a꞉kata꞉matamena꞉. Ba꞉bako lumagiti ibi da꞉ka꞉lamimini, iba꞉te ebe miya꞉pate gobogobamo dito kalahutihoma꞉na꞉ mabu iba꞉te ebeno tabo madodo iya꞉tawaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ya꞉suti ba꞉moe iya꞉tulame uwa꞉mo tawakalubi diya꞉tulamiya꞉, iba꞉te ebeno ipuwa hidamo kalawiya꞉ha꞉, nipo emalagidoluya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ba꞉bema꞉ Ya꞉suti iba꞉tamo gala na꞉kagoiya꞉, “Na la꞉tamo hibi tabonomo begoemo, na ba꞉ sipi-goegoeno kala gigihola. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na peheno puya꞉te dopamo da꞉pelamenakui, ibi hiliyonomo ba꞉ pilo dubula ba꞉gala komopino ilina heloamo uwatelamepila, huiyatiya sipi-goegoa꞉te ibino tabo kulihonakuiha꞉ ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","“Na ba꞉ gigihola. Kebe lumagiti na ipuwado da꞉pa꞉pa꞉gamene ebete ka꞉ka꞉ mula꞉ komo hibilo kopelawema꞉ne. Iyo, ba꞉bako sipi-goete gapo hapuamo naeno kala ipuwamo kapa꞉pa꞉ga, duiduiya tetelo hido hemo nalema꞉ kanuluhuku, ebete ba꞉ba ka꞉na ba ewagelena naha ilina modobolo bulamenakomene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Numa꞉la꞉, pilo lumagi ba꞉gala na, aeno komo hiya꞉hiya꞉la. Ebete sipi-goegoe pilolo uwate o alukuli ukui kapiyado kopema꞉ne ibi kopekubahilamema꞉. Huiyatiya nale na꞉piya꞉mo hibi wiboha꞉ ka꞉ka꞉ iba꞉tamo ba ikalame iba꞉te emedena tetelo kokalakalahanama꞉, ba꞉bema꞉ ba꞉be ka꞉ka꞉ komote ibi ipuwalo tabonomoma꞉ ba eda꞉ lumagiti modobote modoboha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ba꞉bema꞉ na ba꞉ Hido Sipi-goegoe Ulamedawala. Naeno kalakala bitana, nale naeno ka꞉ka꞉ gobogobamo ba ihate ibino ka꞉ka꞉ komula꞉lelamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","“Huiyatiya kebe lumagiti sipi-goegoe ulame oko huiyamo dowatina, ebe ibino hibi ulamedawaha꞉. Keba tetelo ebete helo gaha penapelo dumimini, ebe ha꞉kiya ebeno ka꞉ka꞉ ba mula꞉ sipi-goegoe miya꞉palete gobogobamo dito kalahula꞉ma꞉ne, ba꞉bene helo gahate komo ibi ba palukuli, komo hiya꞉hiya꞉ ba꞉ dito kalahutihoma꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iyo, ba꞉mako dubuti sipi-goegoa꞉tamo olalati komote pelo dumimini, ebete tiyolo kalahula꞉ma꞉ne, mabu ebeno oko huiya ba꞉gala ebeno ka꞉ka꞉ ba꞉bi komo kapiya bemalagidolena, sipi-goegoeno komo hibilo kemalagidololenaha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Na ba꞉ Hido Sipi-goegoe Ulamedawala. “Nale naeno sipi-goegoeno komo iya꞉tawala, ba꞉gala iba꞉te ba꞉ atumu naeno komo iya꞉tawahala, Nabiwi Godote naeno komo keba ka꞉na kiya꞉tawana ba꞉gala nale ebeno komo atumu keba ka꞉na kiya꞉tawanamo ba꞉ba ka꞉na. Ba꞉be mabuma꞉ naeno kalakala bitana, nale naeno ka꞉ka꞉ gobogobamo ba ihate ibino ka꞉ka꞉ komula꞉lelamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ba꞉gala naeno komo sipi-goegoe ba꞉pola꞉na, huiyatiya ba꞉ma tetelo iba꞉te ba꞉moe kala ipuwalo kemedehonaha꞉. Ba꞉ hibila, ba꞉ba꞉te naeno tabo dulimina꞉, nale ibi ba꞉bo komagahelema꞉nemo iba꞉te ba꞉moi dopo sipi-goegoa꞉go kapimilo kemedehonama꞉, ba꞉bene ibi hiliyonomate kapiya kalalo kapiyuimiti na ibino kapiya ulamedawate ibi hidamo ba꞉buiya꞉minalenamo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Numa꞉la꞉, naeno kalakala bitana naeno ka꞉ka꞉ gobogobamo ihatema꞉, ba꞉bema꞉ Nabiwiti malemalelo na nemalagidolonena. Ba꞉gala eta komo, nale naeno ka꞉ka꞉ gobogobamo dihatemo, nale hibilo gala kakalawema꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Eta lumagiti naeno ka꞉ka꞉ nagodone a꞉kalawa꞉mene. Ao, na ha꞉kiya naeno ka꞉ka꞉ gobogobamo kihatema꞉nemo mabu ba꞉moe komo ba꞉ naeno komola, ba꞉gala na ha꞉kiya gala kakalawema꞉nemo mabu helo nagodolo bitana. Naeno Nabiwiti na ya꞉lo a꞉goenamiya꞉ ba꞉moe komo kododima꞉, ba꞉bema꞉ nale hibilo kododima꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ba꞉ba tetelo Ya꞉suti dolamagiya꞉ ba꞉be tabo mabuma꞉ ulihopa꞉te ibi ha꞉kiya ibi ipuwalo ukui kapiyama꞉ kamidiliya꞉ha꞉, iba꞉te tulituliya dito kagaliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Komo iba꞉te na꞉ga꞉luya꞉, “Ba꞉moe dubuino tabo la꞉le badama꞉ kulihutama? Ebe kuba gobogobagoenola, ba꞉bema꞉ ebe na꞉daedaita!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Komopa꞉te ibino tabo ba huiya na꞉ga꞉luya꞉, “Ao, kuba gobogobote daedaema꞉ da꞉midi, ba꞉bako lumagiti Godokono iya꞉tulame tabo hidamo olamagi modoboha꞉, huiyatiya ba꞉moe dubuino tabo komokomo hidonomola. Ba꞉gala kuba gobogobagodawate modoboha꞉ baidi tamihodawoeno baidi hiduilameleme!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Gogo kuititi tetelo giba komote Yu tawakalubino hopolo ba itana, ba꞉ba tetelo iba꞉te Yelusalema ko habalo Godoko Adikumi Genamoeno A꞉hiya꞉mida Poko bododitiya꞉ mabu ibino komo ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ba꞉ba tetelo Godoko Adikumino Genamalo eta pana nitanami, tawakaluba꞉te ba꞉be pana Solomonokono mahilamo ka꞉minakuya꞉. Ba꞉bene Ya꞉suti ba꞉be panalo ba nepata꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","komo tawakaluba꞉te pelamete ebe panataguma꞉digalo ebetamo na꞉pega꞉luya꞉, “Amia꞉no hibi komo tete ga꞉ga꞉nomolo atamo kahawakaliminaha꞉. Ba꞉bema꞉ wadiyala ama꞉ a niya꞉tua꞉ma꞉, ama꞉ ba꞉ Godokono Oemedawa Kelisotela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Nale ba꞉moe komoma꞉ la꞉ dopamo a꞉goelamimata huiyatiya la꞉le na hibima꞉ kamidiniha꞉. Ba꞉gala nale kebe hanohano komo naeno Nabiwino heloamo dododilinakomo, ba꞉bi komate naeno komo behawakalimina, na ba꞉ ba꞉betela. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Huiyatiya hibila, la꞉le ba꞉bi komokomo dulamenakoma na hibima꞉ a꞉kamidina꞉lemata, mabu la꞉ naeno sipi-goegoenomoha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Naeno sipi-goegoa꞉te naeno tabo madodo ulinaka, ba꞉bene na ibino komo iya꞉tawala ba꞉gala iba꞉te na na꞉ta꞉mahenena. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ba꞉bema꞉ nale iba꞉tamo wiboha꞉ ka꞉ka꞉ dikalamemo iba꞉te a꞉kaha꞉lahamena꞉, iyo, nale ibi kodakodalo ba uwatele pilodawate naeno kokoto ipuwane eta kapiya a꞉kalawa꞉mene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ba꞉ hibila, naeno Nabiwiti ibi hiliyonomo natamo ya꞉lo ikanamehoniya꞉. Ebeno helo konomola, eta dawoeno helote ebeno helo a꞉kagogolale, ba꞉bema꞉ ebe atumu ba꞉bi sipi-goegoe kodakodalo ba uwatele pilodawate ebeno kokoto ipuwane eta kapiya lawe modoboha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nabiwi Godoko ba꞉gala na, a ba꞉ kapiyanomola.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ba꞉ba tetelo tawakaluba꞉te ba꞉moe tabo duliya꞉, iba꞉te nakola ba꞉ dito uwatiya꞉ Ya꞉suku mapemete ebe ba꞉bo kanakapumima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Huiyatiya Ya꞉suti iba꞉tamo na꞉goiya꞉, “Naeno Nabiwiti natamo dikanamehoniya꞉, nale ba꞉bi hiliyonomo hidohido komo la꞉eno holoholo hapulu ododilinakomo. Ba꞉bema꞉ ba꞉bi hidohido ododili komo ipuwalo la꞉le natamo bada komoma꞉ ka꞉maubahaliutama? Mabu keka꞉ la꞉le na mapenamema꞉ dewagelitama?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Iba꞉te na꞉huiyuya꞉, “Ale amia꞉no eta hido ododi mabuma꞉ ama꞉ mapemema꞉ kewagelitaha꞉. Ao, mabu bitana, ama꞉ hopo haba dubuma꞉ ba eda꞉na huiyatiya ama꞉le na꞉gaa꞉ta, ama꞉ ba꞉gala Godoko, la꞉ ba꞉ kapiyala! Godokono holoholo hapulu ba꞉mako tabo kubanomola!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Nale da꞉goemo ba꞉be tabo kubaha꞉. Ba꞉bema꞉ la꞉ ba꞉moe komo hidamo nemalagidolala꞉, Godote la꞉eno iniwala꞉tamo dikalamiya꞉ ba꞉be Tutumu Bukalo ebeno tabote ba꞉ma ka꞉na itana, ‘La꞉ hiliyonomo ba꞉ Godoko huiya tawakalubima꞉ eda꞉hanamata.’ ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Numa꞉la꞉, Godote ebeno Bukalo da꞉hawakalimina ba꞉be hibi taboeno helote wiboha꞉ tetelo bitanamene. Ba꞉bene iniwalino tetelo Godokono Buka tabote ibi Godoko huiyama꞉ ka꞉lamiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","huiyatiya la꞉ tetelo Godote na talonama꞉ midiniti hopo habamo ba꞉bo poenamiya꞉. Ba꞉bema꞉ na ha꞉kiya na Godokono Guduma꞉ da꞉goemo, nale kuba tabo kagoeha꞉. Mabu keka꞉ la꞉le kubama꞉ da꞉ga꞉lama? ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Ba꞉gala eta komo, Godote natamo kebe hidohido komo ododilima꞉ dikanamehonena, nale ba꞉bi komo ododilihino wadiyala la꞉ na hibima꞉ akamidina꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Huiyatiya nale ba꞉bi hidohido komo la꞉ ipuwalo hibilo ododilinakomo, ba꞉bema꞉ wadiyala la꞉ ba꞉bi komo ba ulamena naeno hibi komo ba꞉bo niya꞉tawahanala꞉. Iyo, naeno hido ododili komate naeno komo behawakalimina ba꞉ma ka꞉na, na ba꞉gala naeno Nabiwi, a ba꞉ kapiyanomola. Huiyatiya la꞉ ubihinola ba꞉moe komo hibima꞉ midi!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ba꞉ba tetelo ibi ubila Ya꞉suku du genamamo ba꞉bo kihatema꞉, huiyatiya ebete ibi ipuwane gobogobamo ba꞉ dito tuya꞉ iba꞉te ebe lawekapoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ba꞉bene ebete gala katote Yodane Tuli hapuamo kana꞉hiwate, Yonete dopamo tawakalubi beyamo da꞉wadulatelenakui ba꞉bolo ba nemede ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","hiliyonomo tawakaluba꞉te ebetamo ba꞉bo pelameholiya꞉. Ba꞉ba tetelo iba꞉te na꞉ga꞉luya꞉, “Yonete Godokono heloamo hanohano komokomo kododilinakuiha꞉, huiyatiya ba꞉moe Ya꞉suti dododilina ba꞉bi hanohano komo ba꞉ kokonomola! Yonete ebeno komoma꞉ kebe tabo kolamagi, ba꞉be taboeno hiliyonomo komokomo ba꞉ hibinomola!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ba꞉bema꞉ ibi ipuwalo komo tawakalubi hiliyonomate Ya꞉suku hibima꞉ ba꞉bo midiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Eta tetelo eta Betani habanapi dubu, ebeno mahilo Lasalesitila, ebe ko tawetawete umitiya꞉. Ba꞉moe Betani haba ba꞉ badininipala kamena netewa Ma꞉liko ba꞉gala Matako, iba꞉te kebolo kemedenama꞉ ba꞉be habala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ba꞉moe Ma꞉liti ba꞉ eta tetelo Kodawa Ya꞉sukunu natamo hido nibo ilina haminamete ebeno hinibamo a꞉la꞉li da꞉meteteholemiya꞉ ba꞉be dawala, ba꞉gala tawetawete dumitiya꞉ ba꞉moe dubu Lasalesiko ba꞉ ebeno amogala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ba꞉bene ba꞉ba tetelo Ma꞉liko ba꞉gala Matako iba꞉te eta lumagi ba꞉ dito oemiya꞉ Ya꞉suku ba꞉ma ka꞉na konikiyamema꞉, “Kodawa, ama꞉le konomamo demalagidolona, ba꞉be lumagi ko tawetawete umina.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ya꞉suti ba꞉moe tabo uliti ebeno ta꞉matapa꞉tamo na꞉goiya꞉, “Ba꞉moe tawetawete Lasalesikono hoe kuititima꞉ a꞉keda꞉mene. Tawetawete ebe dumina ba꞉be mabu ba꞉ma ka꞉nala, Godoko ubila ba꞉moe komodo ebeno mahilo ba꞉gala ebeno Guduino mahilo kokokoilamema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Hibila, Ma꞉liko, Matako, ba꞉gala Lasalesiko ba꞉ Ya꞉sukunu hido mabulubila, ebete ibi koamo nemalagidolenami. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Huiyatiya Ya꞉suti Lasalesikono tawetawe komo duliya꞉, ebete ebe konowalubima꞉ Yudiya hopoeno Betani habamo tiyonomolo kanuluhukuya꞉ha꞉, ebete kebe habalo kemedenami ba꞉be habalo netewa hegela gala ba꞉bo kemediya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ba꞉bene Ya꞉suti ebe ta꞉matapi na꞉goelamiya꞉, “Wadiyala a Yudiya hopamo gala kakatolamiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Iba꞉te ebeno tabo ba huiya na꞉ga꞉luya꞉, “Iya꞉tulamedawa, ale ba꞉be hopone mamo a꞉pelamima꞉ mabu ba꞉bi tawakaluba꞉te ama꞉ nakolamo mapemema꞉ ewagelitiya꞉. Ibi ubila ama꞉ kanakapumima꞉, ba꞉bema꞉ mabu keka꞉ ama꞉ ba꞉bamo gala tiyolo kakatoma꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ya꞉suti ibino tabo ba huiya na꞉goiya꞉, “Kapiya hegela ipuwalo modobo alote itananako, aba꞉ hibila꞉ka꞉? Ba꞉bene lumagiti hegeloeno alo ipuwalo da꞉patitamene, ebete haka gugamo a꞉kanegamene mabu ba꞉moe hopoeno hibi alo ebete numita. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Huiyatiya ebete du tetelo da꞉pata꞉mene nato ukamida komo kiya꞉tawama꞉ne, mabu ebegodolo alo puliyala ebeno to gabo hidamo kumima꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ba꞉ba tetelo Ya꞉suti tabo ba moga꞉me na꞉goiya꞉, “Aeno mabulubi Lasalesiko u bewatita, huiyatiya nale ebetamo tote ebe konemodoetema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ba꞉bene Ya꞉suku ta꞉matapa꞉te ebetamo na꞉ga꞉luya꞉, “Kodawa, ebete u da꞉watita, hidonomola! Tawetawete ebegodone nuluhukuta.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ya꞉suku ta꞉matapa꞉te ba꞉ma ka꞉na ga꞉luya꞉, mabu ebete iba꞉tamo u wata tabo da꞉goiya꞉ ba꞉ Lasalesikono hoe komoma꞉ goiya꞉, huiyatiya iba꞉te ba꞉be taboeno ipuwa kalawiya꞉ha꞉, ba꞉bema꞉ iba꞉te hibi u wata komoma꞉ na꞉goemo emalagidoluya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Ba꞉bene Ya꞉suti ebeno taboeno ipuwa hawakalimilo ba꞉ma ka꞉na goiya꞉, “La꞉ nulia꞉la꞉, ditidi nale Lasalesikoba꞉ lutaha꞉ tetelo ebete hoenomo a꞉hoi. Huiyatiya nale ebe mabuma꞉ tepo ipuwalo menemene kiya꞉tawutaha꞉. La꞉ mabuma꞉ naeno kalakala bitana, mabu tete tatalila ebeno hoe komodo la꞉le naeno ko helo umiti na hibima꞉ ba꞉bo komidinima꞉nemata. Ba꞉bema꞉ wadiyala a ebetamo kotolamiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ba꞉ba tetelo Tomasiko, ebeno eta mahilo Nedewale Gudula, ebete komo ta꞉matapa꞉tamo na꞉goiya꞉, “Kubahenola, a hiliyonomate Iya꞉tulamedawago ba꞉bamo tolamete eba꞉go koneha꞉lahuya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ba꞉bene Ya꞉suti Betani habamo da꞉nuluhukuya꞉, ebete Lasalesikono komo ba꞉ma ka꞉na nuliya꞉, ebete da꞉hoi netewa-netewa hegela bobo ipuwalo kapitanui. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ba꞉be Betani haba Yelusalema ko haba tatalinomolo itana, ba꞉be ko habamo tolame gaboeno tete ba꞉ netewa-kapiya kilomita keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ba꞉bema꞉ komo Yu tawakalubi hiliyonomate Lasalesikono hoe tabo uliti, iba꞉te ko habane a꞉pelameholiya꞉ ebeno nanikokubi Ma꞉liko ba꞉gala Matako ibi kopegelebadilamema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ba꞉bene ba꞉ba tetelo Matate Ya꞉sukunu pe komo uliti eba꞉go alugama꞉ ba꞉ dito tuya꞉, huiyatiya Ma꞉liko katuya꞉ha꞉, ebete genamalo lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matate Ya꞉sukuba꞉ nalugate ebete ebe na꞉negoemiya꞉, “Kodawa, ama꞉ ba꞉malo nemedetale naeno amogate ba꞉ka꞉hoena꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Huiyatiya na iya꞉tawala, ka꞉lo ama꞉le Godoko bada komoma꞉ da꞉kiyamemena꞉, ebete ama꞉tamo hibilo kikamema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ba꞉bene Ya꞉suti ebe na꞉goemiya꞉, “Amia꞉no amogate hoe ipuwane gala kakamahigama꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Matate ebeno tabo ba huiya na꞉goiya꞉, “Iyo, na iya꞉tawala Godote Kuititi Hegelalo hibima꞉ midipi hiliyonomo ka꞉ka꞉mo kakawadiya꞉paa꞉latelema꞉ne, Lasalesiko bana.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ba꞉bene Ya꞉suti ebetamo na꞉goiya꞉, “Na ba꞉ hoe ipuwane mahiga komoeno helo mabula, ba꞉gala na ba꞉ wiboha꞉ ka꞉ka꞉la, ba꞉bema꞉ kebe lumagiti na hibima꞉ da꞉midinimini, hoe ipuwado ebete wiboha꞉ ka꞉ka꞉ konelawema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ba꞉ hibila, kebe lumagiti nagodolo ba emedena na hibima꞉ da꞉midinimini, ebete a꞉kahaa꞉mene. Ama꞉ ba꞉moe komo hibima꞉ na꞉ka꞉midiuta?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Matate ebeno tabo ba huiya na꞉goiya꞉, “Iyo, Kodawa! Nale ama꞉ hibima꞉ na꞉miditamata, ama꞉ ba꞉ Kelisote, Godokono Gudulata. Ebete ya꞉lo tetelo ba꞉moe hopamo kopema꞉ da꞉goiya꞉, ama꞉ ba꞉be lumagilata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ba꞉bene Matate ba꞉moe tabo olamagiti, ebete genamamo gala katote ebeno naniko Ma꞉litamo tabo diya gabodo ba꞉ma ka꞉na negoiya꞉, “Iya꞉tulamedawa a꞉pe, ebe ama꞉ umima꞉ ubi bihatita.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ba꞉bema꞉ Ma꞉liti ba꞉moe tabo duliya꞉ ebete tiyonomo mahigate Ya꞉sukuba꞉ alugama꞉ ba꞉ dito tuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ba꞉ba tetelo Ya꞉suti Betani haba tatalilo hawela bamitiya꞉, Matate dopamo eba꞉go kebolo ka꞉naluguya꞉ ba꞉be atu bahilo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ba꞉bene Ma꞉liti genamane tiyonomo duluhukuya꞉, ba꞉ba tetelo komopa꞉te ebe gelebadimima꞉ da꞉pelamiya꞉, ba꞉bi tawakaluba꞉te atumu genamane kikuliti ebe ba꞉bo ta꞉matuya꞉, mabu iba꞉te nemalagidoluya꞉ Ma꞉liti Lasalesikono bobo habalo ihima꞉ to. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Huiyatiya Ma꞉liti bobo habamo katuya꞉ha꞉, Ya꞉suti kebolo ka꞉lutiya꞉ ba꞉bamo tuya꞉. Ebete ebe numiti ebeno nato mabamo ba nega na꞉goiya꞉, “Kodawa, ama꞉ ba꞉malo nemedetale naeno amogate ba꞉ka꞉hoena꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ba꞉ba tetelo Ya꞉suti Ma꞉liko ba꞉gala puya꞉te eba꞉go da꞉pelamiya꞉ ibi hiliyonomoeno ihimi komo umiti ebeno tepo ipuwalo ibi konomamo emalagidolete ebe atumu ihima꞉ kewageliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ba꞉bene ebete ibi na꞉goelamiya꞉, “La꞉le ebe bobamo keba teta꞉mo kihatiuima?” Iba꞉te ebeno tabo ba huiya na꞉ga꞉luya꞉, “Kodawa, ama꞉ ago pete ebeno bobo haba na꞉puma꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ba꞉ba tetenomolo Ya꞉suti ba꞉bo ihiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ba꞉bene tawakaluba꞉te ebeno ihi komo uliti na꞉ga꞉luya꞉, “Numa꞉la꞉, ebeno mabulubi emalagidolo komo konomola.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Huiyatiya komopa꞉te na꞉ga꞉luya꞉, “Ba꞉moe dubuti baidi tamiho dubu a꞉hiduimi, aba꞉ hibila꞉ka꞉? Ebete tiyolo na꞉petale, ebeno mabulubiti ba꞉ka꞉hoena꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ba꞉ba tetelo Ya꞉suti ebeno tepo ipuwalo ihima꞉ gala ba kewagele bobo habamo ba꞉bo tuya꞉, ba꞉be bobote haka iya꞉ha꞉midale tetelo ba itana, tawakaluba꞉te Lasalesikono ape ihatete boboeno gigiho ko nakolamo ba꞉bo takumiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ba꞉bene Ya꞉suti ba꞉bolo da꞉pola꞉nuya꞉ ba꞉bi komo dubu na꞉goelamiya꞉, “La꞉ gigihoeno nakola tama꞉mo nemokamidala꞉.” Ba꞉ba tetelo huiyatiya hoe lumagino naniko Matate na꞉goiya꞉, “Kodawa, hiya꞉! Ka꞉lo ebeno apete netewa-netewa hegela tetelo itana, ba꞉bema꞉ ebeno abale nibote kubanomamo kopatema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ba꞉bene Ya꞉suti ebeno tabo ba huiya na꞉goiya꞉, “Nale ama꞉ dopamo ba꞉ma ka꞉na a꞉goememata, ama꞉ Godoko hibima꞉ da꞉midimina꞉ ebeno helo konomo kumima꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ba꞉bene komo dubate bobo gigihoeno nakola tama꞉mo emokamidate, Ya꞉suti Godokono Hunu Habamo gahimilo na꞉goiya꞉, “Nabiwi, na ama꞉tamo kalakala tabo begoemo, mabu ama꞉ naeno toetoe tabo ulinakata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iyo, na iya꞉tawala ama꞉ hiliyonomo tetelo naeno tabo ulihonakata, huiyatiya nale ba꞉moe tabo ba꞉moi tawakalubino holoholo hapulu goemo, iba꞉te naeno hibi komo ba꞉ma ka꞉na kiya꞉tawahama꞉, ama꞉le ba꞉moe hopo habamo na a꞉poenamiya꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ba꞉bene Ya꞉suti ba꞉moe kalakala tabo Godotamo olamagiti, ebete ebeno tabo madodo hunamo adipatete ibulunomamo na꞉goiya꞉, “Lasalesi, ama꞉ bobo ipuwane na꞉puluhuka!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ba꞉ba tetelo hoe dubuti Ya꞉sukunu tabo duliya꞉, ebete bobo ipuwane ba꞉bo puluhukuya꞉, huiyatiya ebeno nato, kokoto, ba꞉gala wato kalikamo a꞉wiholemela, Yunapa꞉te ibino ha꞉laha tawakalubi kalikamo keba ka꞉na ka꞉wiholenaka ba꞉ba ka꞉na. Ba꞉bene Ya꞉suti tawakalubi na꞉goelamiya꞉, “Wadiyala la꞉le ebe ba owalubi ebeno apene kaliko na꞉pahalamilima꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ba꞉ba tetelo puya꞉te Ma꞉liko gelebadimima꞉ da꞉pelamiya꞉, Ya꞉suti Lasalesitamo bada komo kododiya꞉, iba꞉te ba꞉be hanohano komo umiti komo hiliyonomate hibima꞉ ba꞉bo midiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","huiyatiya komopa꞉te hibima꞉ midihino Pa꞉lisi kapiyuimipa꞉tamo tolamete ibi ba꞉ dito nikiyalamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ba꞉be mabuma꞉ Pa꞉lisi kapiyuimipi ba꞉gala Godotamo hawa꞉goeno ikamehopino watowatopi, iba꞉te komo Ka꞉nisolo dubu ba꞉bo ka꞉lamiya꞉ iba꞉go tabo kapimilo koga꞉lama꞉. Ba꞉bene iba꞉te tabo ba꞉ma ka꞉na ga꞉luya꞉, “Ba꞉moe dubuti hiliyonomo hanohano komo bododilina, ba꞉bema꞉ a bada komo na꞉kododima꞉ ebe duhimima꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Keba tetelo ale eta komo ododihino dito duma꞉tepama꞉, hiliyonomo tawakaluba꞉te ebe hibima꞉ miditi Ko Gawadubuma꞉ koga꞉lama꞉na꞉. Ba꞉ba tetelo Lomanapino alaholohopa꞉te pelamete aeno Godoko Adikumino Genama ba꞉gala aeno hopo konomo kopekubahilamema꞉na꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ba꞉ba tetelo eta dubu ebeno mahilo Kayapasitila, ebete ba꞉be gogolo Godotamo hawa꞉goeno ikamehopino Hununomo Watodawama꞉ eda꞉nami, ba꞉bene ebete komo Ka꞉nisolo dubatamo na꞉goiya꞉, “A꞉iye, la꞉ daedaepima꞉ akeda꞉hala꞉! Mabu keka꞉ la꞉le ba꞉moe dubutamo ododima꞉ hibi gabo kumitaha꞉? Ale ebe dito kanakapumima꞉nema꞉! ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Iyo, wadiyala hiliyonomo tawakalubi ipuwalo kapiyadawanomote na꞉haa꞉mene komopi mabuma꞉, ba꞉bema꞉ aeno hopote a꞉kakubamene, aba꞉ hibila꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ba꞉ba tetelo Kayapasiti Ya꞉sutamo maubalo ba꞉ma ka꞉na emalagidoluya꞉, ba꞉moe tabo ebe ha꞉kiya ebeno mulu ukuia꞉mo olamagi. Huiyatiya hibi komote ba꞉ma ka꞉na itanuya꞉, Godote ba꞉moe tabo ebe ipuwado olamagitiya꞉, mabu ba꞉be gogolo ebete Kayapasitamo haba ikamiya꞉ ebete hawa꞉goeno ikamehopino Hununomo Watodawama꞉ keda꞉nama꞉. Ba꞉bema꞉ Ya꞉suti hoeheno, dopamo Kayapasiti ba꞉moe taboeno ipuwa iya꞉tawaheno hibilo a꞉goiya꞉, Ya꞉suti ebeno Yu tawakalubi hiliyonomo mabuma꞉ kohoema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Huiyatiya Godote Kayapasiko ipuwado ba꞉moe tabo Yunapi kapiyatamo kagoiya꞉ha꞉, ao, ebete ba꞉ma ka꞉na goiya꞉, ba꞉moe hopo konomolo hiya꞉hiya꞉ demedehona ibi ipuwalo puya꞉te ebeno gugudima꞉ deda꞉hanamena꞉, Ya꞉suti ebeno hoe komodo ibi hiliyonomo gala kuwatete ibi kapiya badininipalama꞉ komidilima꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ba꞉bene Kayapasiti ba꞉moe tabo Ka꞉nisolo dubatamo dolamagitiya꞉, ba꞉ba tetene tupuimiti iba꞉te Ya꞉suku anakapumi gabo ba꞉bo ohowadiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ba꞉bema꞉ Ya꞉suti ibino komo iya꞉tawate tete nanekelelo Yudiya hopolo hawakala kapata꞉nakuiha꞉. Ebete huiyatiya ebe ta꞉matapa꞉go ba꞉be hopo miya꞉pate Ipala꞉ima habamo tolamete ba꞉bolo nemediya꞉, ba꞉be haba ba꞉ dito hopo tamelo itana. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ba꞉bene Yunapino Adaguila꞉ Poko ododi tete tatalima꞉ dediya꞉, poko ododi tete peheno komo ibi hiliyonomate Yelusalema ko habamo dopamo tolameholiya꞉, mabu ibi ubila Godokono holoholo hapulu ibino ape ukulale komodo kuba dalowa꞉ komokomo dopamo wibuilamete galane ebeno poko kododima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ba꞉ba tetelo komo iba꞉te Godoko Adikumino Hiya꞉ Genama ipuwalo nutitatate Ya꞉suku nohowadilo ibi ha꞉kiya ibi ipuwalo na꞉ga꞉luya꞉, “La꞉eno ukui keba ka꞉nala꞉ka꞉, Ya꞉suku poko habamo ba꞉ka꞉pemene?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Iba꞉te tabo ba꞉ma ka꞉na da꞉ga꞉luya꞉ mabu Godotamo hawa꞉goeno ikamehopino watowatopi ba꞉gala Pa꞉lisi kapiyuimipi, iba꞉te tabo ya꞉lo ihatiya꞉, “Kebe lumagiti Ya꞉suku dumimini, wadiyala ebete tiyolo a na꞉pikiyaa꞉ma꞉mene, ba꞉bene ale tolamete ebe nelawete du genamamo dito kopihatema꞉nema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yu tawakaluba꞉te Adaguila꞉ Poko kododima꞉ sikisi hegelate ba nepola꞉na, Ya꞉suti Betani habamo gala ba꞉bo kapuluhukuya꞉, ba꞉be haba ba꞉ Ya꞉suti hoe ipuwane dadipatiya꞉ ba꞉be dubu Lasalesikono habala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ba꞉bene Lasalesikono naniko Matate komo owalubipa꞉go Ya꞉sukunu hido baa꞉ bododimitiya꞉, ba꞉bene dubu hiliyonomate baa꞉ da꞉nahutiya꞉, Lasalesiko ibi ipuwalo na꞉lutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Huiyatiya ebeno eta naniko Ma꞉liti huiya konomo hido nibo ihi ilina, ebeno mahilo ba꞉ nadala, ebete adahete Ya꞉sukunu natamo pehaminamete ebeno hinibamo nato a꞉la꞉li ba꞉bo meteteholemiya꞉. Ba꞉bene ba꞉be genama gu ba꞉be ilinoeno hido nibote tabonomo a꞉tabuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ba꞉ba tetelo Ya꞉sukunu eta ta꞉matadawate baa꞉ naha habalo na꞉lutiya꞉, ebeno mahilo ba꞉ Keliyotanapi Yudasitila, galane ebete Ya꞉suku anakapumipino kokotamo ebe kihatema꞉ne. Ebete Ma꞉likono ododi komoma꞉ na꞉goiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mabu keka꞉ ebete ba꞉moe hido nibo ilina kolowamima꞉ kanimidiha꞉? Ebete ba꞉ba ka꞉na newageletale kapiya gogoeno oko huiya mani buwatena꞉, ba꞉bene ale awaepa꞉tamo bikalameholena꞉!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudasiti ba꞉moe tabo da꞉goiya꞉ ebete ha꞉da amiho gabodo goiya꞉. Ebete ilinaha꞉ tawakalubino modoboha꞉ komokomo kemalagidolenakuiha꞉ huiyatiya ebe ubila ba꞉be ko mani ebete ha꞉kiya kuwatema꞉, mabu ebe Ya꞉suku kapiyuimipino mani umidawama꞉ ba eda꞉na komo tetelo ebete mani pilolo uwatenakui. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ba꞉bema꞉ Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goiya꞉, “La꞉ Ma꞉liko na꞉miya꞉pala꞉, ebe natamo hido komo bododi. Iyo, nale hoeha꞉ tetelo ebete naeno ape bobamo ihate komo emalagidololo ba꞉moe hido nibo ilina naeno apa꞉mo ba꞉bema꞉ hamina. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","La꞉ numa꞉la꞉, awaepa꞉te tete ga꞉ga꞉nomolo la꞉go bemedehonamena꞉, la꞉eno ubi tetelo ibi nowalubilinakuya꞉la꞉, huiyatiya na emedena tetelo la꞉go a꞉kemedenamo, tete tatalila nale la꞉ komiya꞉palema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ba꞉ba tetelo komo tawakalubi hiliyonomate Ya꞉suku Betani habalo emede komo duliya꞉ iba꞉te ebe umima꞉ ba꞉bamo ba꞉ dito tolamiya꞉. Huiyatiya iba꞉te Ya꞉suku kapiya umima꞉ katolamiya꞉ha꞉, ibi ubila Ya꞉suti hoe ipuwane dadipatiya꞉ ba꞉be dubu Lasalesiko atumu kakanumima꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ba꞉bene Yu watowatopi ba꞉be komo duliya꞉ iba꞉te nopo ba꞉bo tamotiya꞉ Lasalesiko Ya꞉sukuba꞉ kanakapulamema꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mabu Lasalesikono komone hiliyonomo tawakaluba꞉te Ya꞉suku hibima꞉ a꞉midiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Eta hegelalo puya꞉te Yelusalema ko habalo Adaguila꞉ Poko ododima꞉ da꞉pelamiya꞉, ibi hiliyonomate iya꞉tawahuya꞉ Ya꞉suti ba꞉be habamo da꞉pitiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ba꞉bema꞉ iba꞉te ele uwateholete eba꞉go alugama꞉ ba tolamita ibulunomamo na꞉ga꞉lutiya꞉, “Godoko nadipata꞉la꞉! Godo, amia꞉no mahilago da꞉pita, wadiyala ama꞉ ba꞉be lumagi na꞉koimiya꞉! Ebe ba꞉ a Isalaela tawakalubino Ko Gawadubula!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ba꞉bene Ya꞉suti uli ape donoki-goe umiti ba꞉be hunamo dito emediya꞉. Ebete ba꞉ba ka꞉na ododiya꞉ Godokono tabote hibima꞉ keda꞉ma꞉, mabu ebeno Bukalo eta tabote ba꞉ma ka꞉na bitana, ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yelusalemanapa꞉la꞉, la꞉ akatoletolehala꞉. Numa꞉la꞉, la꞉eno Ko Gawadubuti ba꞉ na꞉pita, iyo, ebete donoki-goe deha꞉poto hunamo emedete pita.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ba꞉ba tetelo Ya꞉suku ta꞉matapa꞉te ba꞉moe Buka taboeno ipuwa hidamo kemalagidolutiya꞉ha꞉, huiyatiya galane Ya꞉suti Godokono helo alago hoe ipuwane da꞉mahiguya꞉, ba꞉ba tetelo ibino ukuiti tuputupuhulamete iba꞉te ba꞉bo ga꞉luya꞉, “Hibila, Ya꞉suti Yelusalemamo ba na꞉pa꞉ga, ale ebe da꞉milimihuima꞉, Godokono Buka tabote ebeno komoma꞉ hibinomoma꞉ ba꞉bo edi!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Dopamo Ya꞉suti Lasalesiko bobo ipuwamo neka꞉miti hoe ipuwane dadipatiya꞉, ba꞉ba tetene tupuimiti puya꞉te ba꞉be hanohano komo dumiya꞉, iba꞉te hiya꞉hiya꞉ habahabamo tolameholete komo hiliyonomo tawakalubi ba꞉bo nikiyahalamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ba꞉be mabuma꞉ Yelusalemanapi hiliyonomate ba꞉be komo iya꞉tawahate, iba꞉te Ya꞉suti ibino habamo pema꞉ duliya꞉ ebe umima꞉ ba꞉ dito pelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ba꞉bema꞉ Pa꞉lisi kapiyuimipa꞉te ubiha꞉ma꞉ ba eda꞉ha ibi ha꞉kiya ibi ipuwalo na꞉ga꞉luya꞉, “La꞉ numa꞉la꞉! A kahelohelohutaha꞉, hiliyonomo tawakaluba꞉te a miya꞉poete ebe ba꞉ na꞉ta꞉mata!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yunapino Adaguila꞉ Poko ododi tetelo komo Yuha꞉pa꞉te Yelusalema ko habamo Godoko adikumima꞉ da꞉tolamiya꞉, ibi atumu ba꞉be poko habalo na꞉nepola꞉nuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ba꞉bene Ya꞉sukunu ta꞉matadawa eta Pilipiko, ebe ba꞉ Betasaidanapila, komo iba꞉te ebetamo nikuliti ebe na꞉nega꞉lamiya꞉, “Mabulubi, a Ya꞉suku umima꞉ ewagelitama꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ba꞉bema꞉ Pilipiti A꞉nduluku da꞉kiyamiya꞉, ibi netewapa꞉te badi tote Ya꞉suku ba꞉bo nega꞉lamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ba꞉bene Ya꞉suti iba꞉tamo na꞉goiya꞉, “Tete ba꞉ a꞉pe, Godokono helo alote Tawakalubino Naniwi ba a꞉la꞉mina ebe dawagaminamene, tawakalubi hiliyonomate ebeno hibi komo ba꞉bo kumima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ba꞉bema꞉ na la꞉tamo hibi tabonomo begoemo, kona kikipote haka ipuwamo ma꞉tigate da꞉nehoemene, ebeno ka꞉ka꞉te hibilo a꞉kawibamene mabu galane komo kona kikipate ba꞉be ipuwane kopikulima꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ba꞉gala kebe lumagiti ebeno ka꞉ka꞉ kapiya demalagidolona, ebeno ka꞉ka꞉te kalatidima꞉ne, huiyatiya kebe lumagiti ba꞉moe hopolo ebeno ka꞉ka꞉ emalagidoloheno, ebeno ka꞉ka꞉te Godokono Hunu Habalo itana itana tetelo bitanamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ba꞉bema꞉ kebe lumagiti naeno huiyaha꞉ okodawama꞉ eda꞉ma꞉ ubi dihatemene, wadiyala ebete na na꞉ta꞉mahena꞉mene, ba꞉bene nale kebe habalo demedenamo ebete ba꞉be atu habalo nago bemedenamene. Ba꞉gala eta komo, kebe lumagiti naeno hibi okodawama꞉ deda꞉mene, naeno Nabiwiti ebe hunamo kadipatema꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ba꞉bene Ya꞉suti Godotamo tabo ba olamagi na꞉goiya꞉, “Ka꞉lo na tepo ipuwalo menemenenomoma꞉ editamo, ba꞉bema꞉ Nabiwi, na ama꞉tamo bada tabote na꞉ka꞉goemo? Nale ba꞉ma ka꞉na ba꞉ka꞉goemo, ‘Nabiwi, modoboha꞉ ba꞉moe olalati tetete natamo pe’? Ao, nale ba꞉mako tabo a꞉kagaa꞉mo mabu na ba꞉moe temeteme lawema꞉ hopo habamo ba꞉bema꞉ piya꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ba꞉bema꞉ Nabiwi, ama꞉ ha꞉kiya amia꞉no helo alo ipuwado ama꞉ nawagaminuya꞉.” Ya꞉suti ba꞉moe tabo ba goita ba꞉ba tetenomolo Godokono Hunu Habane tabote ba꞉ma ka꞉na pihitiguya꞉, “Na ha꞉kiya na ya꞉lo awagaminuya꞉mo, ba꞉gala na ha꞉kiya gala kakawagaminama꞉nemo!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ba꞉ba tetelo puya꞉te Ya꞉suku tamelo da꞉la꞉mota꞉hanuya꞉, ba꞉bi tawakalubi hiliyonomate ba꞉be tabo madodo uliti na꞉ga꞉luya꞉, “Ba꞉moe ba꞉ alomote goewata,” huiyatiya komopa꞉te na꞉ga꞉luya꞉, “Ao, ebe ba꞉ Godokono nopodawate ebetamo polamagita.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ya꞉suti ibino tabo ga꞉la komo iya꞉tawate na꞉goiya꞉, “Ba꞉moe tabote na mabuma꞉ kapeha꞉, la꞉ mabuma꞉ pe. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ba꞉ hibila, ka꞉lo hopo habanapa꞉te ibino kuba ododili mabuma꞉ huiya kuwatema꞉na꞉, ba꞉bene ba꞉moe hopoeno kuba gawadubu Saitanako Godote ebeno wato kikipo kitamidamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ba꞉gala Godote na hunamo dadipanatenemene, ba꞉be hoe komodo na huiyatiya hiliyonomo tawakalubi natamo komagahelema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ya꞉suti ba꞉moe tabo dolamagiya꞉ ebeno ipuwa ba꞉ma ka꞉nala, ebe keha pihigalo keba ka꞉na da꞉hoemene, ebete ba꞉be komo behawakalimiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ba꞉bene tawakalubi hiliyonomate Ya꞉sukunu tabo ba huiya na꞉ga꞉luya꞉, “Godokono Tutumu Tabo Bukate a biya꞉tua꞉mena, ebeno Oemedawa Kelisote emedena tetelo bemedenamene. Ba꞉bema꞉ ama꞉ ba꞉ma ka꞉na badama꞉ ka꞉gaa꞉wa, Godote Tawakalubino Naniwino hoe komodo ebe hunamo kadipatema꞉ne? Tawakalubino Naniwi potela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ba꞉bene Ya꞉suti gala na꞉kagoiya꞉, “Godokono alote la꞉ ipuwalo tete nanekela꞉mo ga꞉ga꞉dopo kitanama꞉ne, ba꞉bema꞉ wadiyala la꞉ ba꞉moe alo ipuwado na꞉wapata꞉lamenala꞉. La꞉ hidamo, du komote la꞉tamo akapa꞉la꞉, mabu du ipuwado da꞉pata꞉na ba꞉be lumagi iya꞉tawaha꞉ ebete kebe gabodo da꞉tona! ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ba꞉bema꞉ du komote peheno alote la꞉eno tolame gabo ba a꞉la꞉minana, wadiyala la꞉ hibima꞉ na꞉mida꞉la꞉, ba꞉bene la꞉le aloeno gugudima꞉ keda꞉hama꞉nemata.” Ba꞉moe tabo olamagi da꞉wibuya꞉, Ya꞉suti ba꞉bi tawakalubi hiliyonomo miya꞉palete diya gabodo eta baha꞉mo tote ba꞉bo nilutiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ba꞉ hibila, Ya꞉suti hopo habalo ba emedena Godokono helo kohawakalimima꞉ ebete tawakalubino holoholo hapulu hiliyonomo hanohano komokomo bododilinakui, huiyatiya puya꞉te ba꞉bi komo dulamenakui ibi ipuwalo komo Yu tawakaluba꞉te ebe hibima꞉ kamidiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ba꞉bene ba꞉moe komote ba꞉ ba꞉ba ka꞉na uluhukuya꞉, Godokono ukui hawakalimidawa Aisayate da꞉goiya꞉, ba꞉be tabote hibima꞉ keda꞉ma꞉. Ya꞉lo tetelo ebete tabo ba꞉ma ka꞉na goiya꞉, “Kodawa, ama꞉ amia꞉no ko helo puya꞉tamo da꞉hawakaliminaka, ale amia꞉no tabo iba꞉tamo dolamagimima꞉, hibima꞉ pote ka꞉midi? Lumagi kalutaha꞉, puliyanomola.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ba꞉bema꞉ mabu keka꞉ tawakaluba꞉te Ya꞉suku hibima꞉ midi modoboha꞉ma꞉ deda꞉hana? Aisayate ba꞉be komo hawakalimima꞉ eta tabo ba꞉ma ka꞉na kagoiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Godote hibima꞉ midiha꞉pino baidi duhuma꞉ midililamete, ibino tepo ipuwoeno ukui akakodakoduilamelelamiya꞉. Ba꞉bema꞉ ebete ibi mabuma꞉ na꞉goena, ‘Iba꞉te baida꞉mo hibi komo umi modoboha꞉, iyo, ibino tepo ipuwalo naeno hido komo iya꞉tawa modoboha꞉. Iba꞉te ibino tepo ipuwoeno ukui hidamo nemalagidolotale natamo bohobila꞉na꞉, ba꞉bema꞉ na modobola ibi nale hiduilame.’” ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ba꞉ hibila, tawakaluba꞉te Ya꞉suku ubiha꞉ma꞉ deda꞉hamena꞉, Aisayate ba꞉be komoma꞉ ba꞉moe tabo ya꞉lo a꞉goiya꞉, mabu ebeno baiditi hiya꞉ma꞉ ba eda꞉hame ebete Ya꞉suku Godokono helo alote a꞉la꞉minutalo ba꞉bo umiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ba꞉bene komo tawakaluba꞉te Ya꞉suku ubiha꞉ma꞉ ba eda꞉ha, atu tetelo komo tawakalubi ba꞉gala komo ibino watowatopa꞉te ebe hibima꞉ ba꞉bo midiya꞉. Huiyatiya ba꞉ba꞉te Pa꞉lisi kapiyuimipi tolelamelo ibino hibima꞉ midi komo kahawakalimiya꞉ha꞉, Pa꞉lisi watowatopa꞉te mauba ipuwalo ibi hiya꞉hiya꞉ habahaboeno baidi ibubulamehole genamamo a꞉pa꞉la꞉ha talona ihatelamekapoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ba꞉ hibila, iba꞉te Ya꞉suku ta꞉mata ipuwalo kodakodalo kapola꞉nuya꞉ha꞉ mabu ibi ubila tawakaluba꞉te iba꞉tamo kokalakalahama꞉, huiyatiya Godote iba꞉tamo da꞉kalakalana iba꞉te ba꞉be komo koamo kemalagidolonamiha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ba꞉bema꞉ Ya꞉suti ibulunomo ba goewata na꞉goiya꞉, “Kebe lumagiti na hibima꞉ da꞉midinina ebete na kapiya hibima꞉ kamidininaha꞉, ebete na da꞉poenamiya꞉ ba꞉be dawa atumu hibima꞉ na꞉kamidina, ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ba꞉gala kebe lumagiti naeno komo dumina, ebete na da꞉poenamiya꞉ ba꞉be dawoeno komo na꞉ka-umina. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ba꞉ hibila, na ba꞉moe hopo a꞉la꞉minama꞉ piya꞉mo, ba꞉bema꞉ kebe lumagiti na hibima꞉ da꞉midinina ebete du ipuwalo a꞉kemedenamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ba꞉gala ba꞉moe ba꞉ eta komola. Kebe lumagiti naeno tabo uliti papamiwataheno, nale ebeno komo a꞉kanagiya꞉midama꞉mo mabu na hopo habanapa꞉tamo kuba huiya ikalamema꞉ kapiya꞉ha꞉, huiyatiya na ibino ka꞉ka꞉ mula꞉lelamema꞉ piya꞉mo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Numa꞉la꞉, kebe lumagiti na ubiha꞉ma꞉ eda꞉te naeno tabo komokomo uwateheno, ebeno komo anagiya꞉midamema꞉ eta Kodawate ba꞉luta. Iyo, Godote Kuititi Hegelalo naeno tabo komamo ba꞉be lumagino komo kanagilamelemema꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","mabu nale dolamaginamo ba꞉bi tabo komokomo na ha꞉kiya naeno ukuilo kolamaginaha꞉, huiyatiya Nabiwiti na da꞉poenamiya꞉ nale ebetamo papamiwatalo ebeno tabonomo bolamaginamo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na ba꞉moe komo iya꞉tawala, Nabiwino tutumu tabo ba꞉ wiboha꞉ ka꞉ka꞉la, ba꞉bema꞉ ebete na keba ka꞉na ka꞉goenamenako, na ba꞉ ba꞉ba ka꞉na olamaginakomo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yu tawakalubino Adaguila꞉ Poko ododima꞉ kapiya hegelate ba nitana, Ya꞉suti ba꞉bo iya꞉tawuya꞉ ba꞉moe ba꞉ tetela, ebete tatalila ba꞉moe hopo miya꞉pate Nabiwi Godotamo kotoma꞉ne. Ba꞉ hibila, puya꞉te ba꞉moe hopolo ebenoma꞉ deda꞉hanama꞉, Ya꞉suti ibi malemalelatelelo konomamo emalagidolenami, ba꞉bema꞉ ibi ba꞉be malemala꞉go magatalete kuititinomamo ba꞉bo nuluhukuya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ba꞉bene ba꞉be dulu Ya꞉suti ebe ta꞉matapa꞉go ahidinate baa꞉ benahaniya꞉. Ba꞉be du peheno Saitanate dopamo eta ta꞉matadawa Yudasikono tepo ipuwamo kuba ukui ba꞉ma ka꞉na ihatemiya꞉, ebete Ya꞉suku anakapumipino kokotamo ebe kihatema꞉, ba꞉moe Yudasiko ba꞉ Keliyotanapi Saimonokono gudula. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Hibila, Ya꞉suti ba꞉moi netewa-kapiya komo ya꞉lo iya꞉tawuya꞉, Nabiwi Godote ebetamo helo ikamiya꞉ hiliyonomo komokomo ododilima꞉, ba꞉gala ebe ba꞉ Godogodone piya꞉, ba꞉gala ebe ba꞉ Godotamo gala kakatoma꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ba꞉be mabuma꞉ ebete baa꞉ naha habane mahiganate, atuino kaliko pekananate huiyaha꞉ okodawamo a꞉la꞉li meteteholeno kaliko lawenate dito puliniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ba꞉bene ebete wahikalamo beya haminanate ebeno ta꞉matapino nato ukulalelame ba꞉bo tupuiminiya꞉, ba꞉gala ebete da꞉puliniya꞉ ba꞉be a꞉la꞉li meteteholeno kalikamo ebete ibino nato a꞉la꞉li ba꞉bo meteteholelameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ba꞉bene ebete Saimono Pitatamo da꞉peniya꞉ Pitate ebetamo na꞉goeniya꞉, “Kodawa, ama꞉ naeno nato ba꞉kukulaleomena꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ya꞉suti tabo ba huiyana ebe na꞉goemeniya꞉, “Ama꞉ iya꞉tawaha꞉ nale ama꞉tamo bada komo dododinamo, huiyatiya ama꞉ galane kiya꞉tawama꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ba꞉bema꞉ Pitate na꞉goeniya꞉, “Ao, ba꞉be komo modoboha꞉! Ama꞉ naeno nato a꞉kukulala꞉mena꞉ta.” Ya꞉suti huiyatiya ebe na꞉goemeniya꞉, “Nale amia꞉no nato ukulaleheno ama꞉ nagodolo habahenola.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ba꞉bema꞉ Pitate ebetamo na꞉goeniya꞉, “Kodawa, kubaha꞉, ama꞉ naeno nato kapiya akukulala꞉la꞉. Wadiyala ama꞉ naeno kokoto ba꞉gala wato atumu na꞉kukulalenamiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ba꞉bene Ya꞉suti na꞉goeniya꞉, “Kebe lumagiti mala꞉ ya꞉lo da꞉tui ebeno apeno dalowa꞉ puliyala, huiyatiya ebete ebeno nato kapiya nukulala꞉mene. Ba꞉moe komo ba꞉ hibila, la꞉ hiliyonomate uliulinoma꞉ eda꞉huimata, huiyatiya la꞉ ipuwalo kapiya dawate ulinoma꞉ keda꞉naha꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ya꞉suti ba꞉moe tabo da꞉goeniya꞉ mabu ebete ya꞉lo iya꞉tawuya꞉, ta꞉matapi ipuwalo ebe pote anakapumipino kokotamo dihatemene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ba꞉ba tetelo ebete ebeno ta꞉matapino nato ukulalelame da꞉wiboniya꞉, ebete ebeno atuino kaliko gala kapulinate ba꞉ dito emedeniya꞉. Ba꞉bene ebete ibi na꞉goelameniya꞉, “La꞉ iya꞉tawahala꞉ka꞉, nale la꞉tamo dododimo ba꞉be komoeno ipuwa? ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","La꞉le na la꞉eno Iya꞉tulamedawama꞉ ga꞉lanakomata ba꞉gala Kodawama꞉ akaka꞉naminakomata. Ba꞉ hibila, na ba꞉ ba꞉betela. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ba꞉bema꞉ galane la꞉le ba꞉moe naeno ododi komo ba꞉ma ka꞉na demalagidolonakoma, ‘Aeno Iya꞉tulamedawa ba꞉gala Kodawa, ebete aeno nato ukulalea꞉meni,’ wadiyala la꞉ ha꞉kiya la꞉ ipuwalo etate etoeno nato atumu nukulalemenakuya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iyo, nale la꞉tamo ba꞉ go bododimo, galane tetelo la꞉le komopa꞉tamo ba꞉ma ka꞉na nododinakuya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na la꞉tamo hibi tabonomo begoemo, eta okodawoeno helote ebeno oko namutudawoeno helo a꞉kagogolale, ba꞉gala tabo atadawoeno helote ebe da꞉poememene ba꞉be kodawoeno helo a꞉kagogolamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ba꞉bema꞉ la꞉ ba꞉moi komokomo iya꞉tawahate, ba꞉ma ka꞉na etate etatamo, etate etatamo, huiyaha꞉ oko dowatinakoma, ba꞉bene la꞉godolo konomo kalakalate bitananakomene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo na꞉goeniya꞉, “Godokono Bukalo eta tabote ba꞉ma ka꞉na itana, ‘Nago baa꞉ da꞉nanako, ba꞉be lumagiti naeno alaholodawama꞉ keda꞉ma꞉ne,’ ba꞉bema꞉ ba꞉ma tetelo a ipuwalo ba꞉moe tabo komote hibima꞉ keda꞉ma꞉ne, Godokono ubila. Ba꞉ hibila, na la꞉eno komo iya꞉tawanomola, mabu la꞉le na ta꞉mahenema꞉ nale la꞉ uwatimata, ba꞉bema꞉ ba꞉moe tabo komote la꞉ hiliyonomoeno komoma꞉ kagoenaha꞉, kapiya lumagino komoma꞉ goena. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ba꞉be lumagino komote uluhukuhino nale la꞉ dopamo goelamemata. Ba꞉bene ebeno komoma꞉ Buka taboeno komote hibilo duluhukumini, la꞉ hibima꞉ ba꞉bo komidima꞉nemata na ba꞉ emedena tetelo demedenamo ba꞉be dawala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na la꞉tamo hibi tabonomo begoemo, nale kebe okodawa doememo, pote ba꞉be okodawa kalakalago dowalubimini ebete na kowalubinima꞉ne, ba꞉gala pote na dowalubinimini ebete na kapiya a꞉kowalubina꞉mene, ebete na Oenamedawa Godoko atumu kakowalubima꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ba꞉bene Ya꞉suti ba꞉moe tabo olamagi da꞉wiboniya꞉ ebete tepo ipuwalo menemenenomoma꞉ eda꞉nate ebe ta꞉matapa꞉tamo hawakala na꞉goeniya꞉, “Na la꞉tamo hibi tabonomo begoemo, la꞉ ipuwalo etate na anakapunamepi kowalubilima꞉ne na kolawenema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ba꞉bema꞉ ebe ta꞉matapa꞉te ibi ipuwalo ba uma꞉tepahuina nemalagidoloniya꞉, “Ba꞉moe kuba pote na꞉kododimini?” huiyatiya iba꞉te lumagi kuminiya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ba꞉ba tetelo Ya꞉suti ebe ta꞉matapi ipuwalo poko koamo demalagidolonami, ba꞉bete Ya꞉suku tamelo na꞉lutiya꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ba꞉bene Saimono Pitate kokotamo ba goena ebe na꞉goemeniya꞉, “Ama꞉le Iya꞉tulamedawa na꞉kiyama꞉ ebete pokono komoma꞉ kolamagina.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ba꞉bene ba꞉be ta꞉matadawate Ya꞉suku tama꞉mo nemeda꞉tepanate ebe na꞉goemeniya꞉, “Kodawa, ba꞉be lumagi potela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ya꞉suti ebeno tabo ba huiyana na꞉goeniya꞉, “Nale baa꞉ kalila꞉mo adutiti kebe lumagitamo dikamemo, ba꞉be ba꞉be lumagila.” Ba꞉ba tetelo ebete baa꞉ kalila꞉mo adutinate, Keliyotanapi Saimonokono gudu Yudasitamo ba꞉ dito ikameniya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ba꞉bene Yudasiti ba꞉be baa꞉ da꞉laweniya꞉, ba꞉ba tetenomolo Saitanate ebeno tepo ipuwamo ba꞉ dito opeganiya꞉. Ba꞉bene Ya꞉suti ebetamo na꞉goeniya꞉, “Ama꞉le kebe komo ododima꞉ dewagelena, wadiyala tiyonomo nododa꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ba꞉ba tetelo baa꞉ naha habalo da꞉pola꞉nuya꞉, ba꞉bi komo ta꞉matapi ipuwalo eta lumagiti Ya꞉sukunu taboeno ipuwa kalaweniya꞉ha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasiti ibino kapiyuimipino mani umidawama꞉ eda꞉nami, ba꞉bema꞉ komopa꞉te nemalagidoloniya꞉ Ya꞉suti poko ododino komo baa꞉ konuwatehoma꞉ goena, ba꞉gala komopa꞉te nemalagidoloniya꞉ ebete awaepi mana꞉mo konowalubilima꞉ goena. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ba꞉bene Yudasiti Ya꞉sugodone baa꞉ da꞉laweniya꞉, ba꞉ba tetenomolo ebete iba꞉godone mahiganate du ipuwamo ba꞉ dito nopeganiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasiti ibi da꞉miya꞉paliniya꞉ ba꞉ba tetelo Ya꞉suti komopa꞉tamo na꞉goeniya꞉, “Ba꞉ma tetelo Godokono helo alote Tawakalubino Naniwi ba a꞉la꞉mina ebe kawagaminama꞉ne, ba꞉gala Tawakalubino Naniwiti ebeno ododi komodo Godoko kawagaminama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ba꞉bema꞉ Godote ebe ha꞉kiya ebe Tawakalubino Naniwi ipuwado dawagaminamene, ba꞉be atu tetelo ebete Tawakalubino Naniwi helo alamo ba a꞉la꞉mina ebe kawagaminama꞉ne. Ba꞉ hibila, ebete ba꞉be komo tiyonomo kododima꞉ne.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ba꞉bene Ya꞉suti eta tabo bekagoeniya꞉, “Naeno guguda꞉la꞉, na la꞉go tete nanekele emeda꞉tepate la꞉le na ba꞉bo kohowadinima꞉nemata. Iyo, nale kebe tabo Yu watowatopa꞉tamo dopamo da꞉goimo, ka꞉lo la꞉tamo ba꞉be atu tabo bekagoemo, nale kebe habamo da꞉tomo la꞉le ba꞉be habamo pelame modoboha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Huiyatiya ka꞉lo dulu na la꞉tamo uli tutumu tabo bikalamemata la꞉ kowalubilima꞉. Wadiyala la꞉eno emede ipuwalo etate eta malemalelo nemalagidolonala꞉, nale la꞉ keba ka꞉na kemalagidoletanama ba꞉ba ka꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Keba tetelo la꞉ ipuwalo etate eta malemalelo kemalagidolo, etate eta malemalelo kemalagidolo, la꞉ ba꞉ba ka꞉na dewagelenama, ba꞉moe gabodo hiliyonomo tawakaluba꞉te kiya꞉tawahama꞉na꞉ la꞉ ba꞉ naeno ta꞉matapilata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ba꞉bene Saimono Pitate Ya꞉sutamo na꞉goeniya꞉, “Kodawa, ama꞉ kebamo na꞉ka꞉tomena꞉?” Ya꞉suti tabo ba huiyana na꞉goeniya꞉, “Nale kebe habamo da꞉tomo, ba꞉ma tetelo la꞉le na ta꞉mahene modoboha꞉, huiyatiya hibila, la꞉le na galane kota꞉mahenema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ba꞉bene Pitate ebe gala na꞉kagoemeniya꞉, “Kodawa, mabu keka꞉ nale ba꞉ma tetelo ama꞉ ta꞉maheha꞉ma꞉ da꞉gaa꞉? Na modobola naeno ka꞉ka꞉ ama꞉ mabuma꞉ gobogobamo kihatema꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ba꞉ba tetelo Ya꞉suti ebeno tabo ba huiyana na꞉goeniya꞉, “Amia꞉no ka꞉ka꞉ na mabuma꞉ hibilo ba꞉kihateomena꞉? Na ama꞉tamo hibi tabonomo begoemo, ka꞉lo dulu kakabate goehoheno ama꞉ netewa-kapiya teta꞉mo na iya꞉tawaha꞉ma꞉ kogoema꞉na꞉ta.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ba꞉bene Ya꞉suti tabo moga꞉melo ebe ta꞉matapa꞉tamo na꞉goeniya꞉, “La꞉ tepo menemenema꞉ ba꞉gala ukui bilibilima꞉ akeda꞉hala꞉. Wadiyala la꞉ Godoko hibima꞉ na꞉mida꞉la꞉, ba꞉gala la꞉ na atumu hibima꞉ na꞉midina꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ba꞉ hibila, naeno Nabiwino genama gulu la꞉eno emedeho haba hiliyonomo ba꞉pola꞉na. Ba꞉moe komo ha꞉dama꞉ neda꞉tale nale la꞉ ba꞉ka꞉goelametana꞉, iyo, na la꞉eno hibi habanomo hiduilamema꞉ kotoma꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ba꞉bene na la꞉eno haba nihiduilamete gala kapete la꞉ ba꞉bo kopuwatema꞉nemata, ba꞉ba tetelo a hiliyonomate kapimilo naeno habalo ba꞉nemedenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ba꞉ hibila, nale kebe habamo da꞉tomo, la꞉ ba꞉be habamo tolame gabo iya꞉tawahala.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ba꞉bene Tomasiti Ya꞉sutamo na꞉goeniya꞉, “Kodawa, ama꞉le kebe habamo da꞉tomena꞉ a ba꞉be haba iya꞉tawaha꞉, ba꞉bema꞉ a gabo keba ka꞉na na꞉kiya꞉tawahama꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ya꞉suti ebeno tabo ba huiyana na꞉goeniya꞉, “Na ba꞉ gabola, ba꞉gala na ba꞉ hibi komo hawakalimidawala, ba꞉gala na ba꞉ wiboha꞉ ka꞉ka꞉la. Lumagiti na ipuwado Nabiwi Godotamo kotoma꞉ne, eta gabodo a꞉katoamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Numa꞉la꞉, la꞉ naeno komo iya꞉tawahala, ba꞉bema꞉ ba꞉ma tetene tupuimiti la꞉ naeno Nabiwino komo atumu kakiya꞉tawahama꞉nemata. Ba꞉ hibila, la꞉ ebe ya꞉lo umia꞉mata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ba꞉bene Pilipiti ebetamo na꞉goeniya꞉, “Kodawa, ama꞉ atamo Nabiwino komo da꞉hawakalimimina꞉, a komodoboma꞉nema꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ya꞉suti tabo ba huiyana na꞉goeniya꞉, “Pilipi, nale tete ga꞉ga꞉nomolo la꞉go emedenamimo, ba꞉bema꞉ mabu keka꞉ ama꞉le naeno komo hibilo kiya꞉tawanaha꞉? Ama꞉le na dunami ba꞉be gabodo ama꞉le Nabiwi ba꞉ umia꞉ta, ba꞉bema꞉ keka꞉ mabu ama꞉le ba꞉ma ka꞉na da꞉gaa꞉, ‘Nabiwino komo atamo na꞉hawakalima꞉’? ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pilipi, ama꞉ ba꞉moe komo hibima꞉ na꞉ka꞉midiona, na Nabiwi ipuwalo bemedenamo ba꞉gala Nabiwiti na ipuwalo bemedena?” Ba꞉bene Ya꞉suti ebe ta꞉matapi hiliyonomatamo na꞉goeniya꞉, “Nale la꞉tamo kebe tabo kolamaginakuimo, ba꞉bi tabo komokomate nagodone kapelamenaha꞉, huiyatiya na ipuwalo demedena, ba꞉be Nabiwiti naeno hiya꞉hiya꞉ tabamo ebeno hido oko bowatina. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ba꞉bema꞉ wadiyala la꞉ ba꞉moe komo hibima꞉ na꞉mida꞉la꞉, na Nabiwi ipuwalo bemedenamo ba꞉gala ebete na ipuwalo bemedena. Huiyatiya la꞉ la꞉eno ukuilo ba꞉moe komo kodakodama꞉ da꞉ga꞉lanama, ba꞉bema꞉ nale kebe hanohano komo la꞉ ipuwalo dododilinakuimo, wadiyala la꞉ ba꞉bi komoeno ipuwa ba emalagidolo na hibima꞉ na꞉midina꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ka꞉lo dulu na la꞉tamo hibi tabonomo begoemo, kebe lumagiti na hibima꞉ da꞉midinimini, nale dowatinamo ebete ba꞉be atu oko ba꞉ka-owatinamene. Ba꞉ hibila, ba꞉be lumagino oko owati helote naeno oko owati helo konegogoloma꞉ne mabu na ba꞉ Nabiwitamo kotoma꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ba꞉bema꞉ la꞉le naeno mahilamo bada komoma꞉ na da꞉toenamehonema, nale la꞉tamo kikalamema꞉nemata mabu naeno ododi komodo Nabiwiti ha꞉kiya ebe kawagaminama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Iyo, la꞉ naeno mahilamo bada komoma꞉ na da꞉toenamehonema, na la꞉tamo dito kikalamema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo eta tabo bekagoeniya꞉, “La꞉ na malemalelo demalagidolonema la꞉ naeno tutumu tabamo kopapamila꞉hama꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ba꞉bema꞉ nale naeno Nabiwi kogoemema꞉nemo, ebete eta Owalubidawa la꞉tamo kopoemema꞉, ba꞉bete emedena tetelo la꞉go bemedenamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ebe ba꞉ Godokono Hido-talona Gobogobola, Godokono hibi komo da꞉hawakalimina ebe ba꞉be dawala. Hopo habanapa꞉te ebe a꞉kuma꞉la꞉, ba꞉gala ebeno komo a꞉kiya꞉tawahala꞉, ba꞉bema꞉ iba꞉te ibino tepo ipuwalo ebeno helo hibilo a꞉kalawa꞉mena꞉. Huiyatiya la꞉ hibima꞉ midipino komo eba ka꞉naha꞉ mabu la꞉ ebeno komo iya꞉tawahanomola, iyo, ebete emedena tetelo la꞉godolo bemedenamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ba꞉bema꞉ nale la꞉ dito a꞉kamiya꞉pala꞉mata, ao, nale ba꞉moe Owalubidawa la꞉tamo hibilo kopoemema꞉nemo, ba꞉bene ebete la꞉godolo ba emedena galane na ha꞉kiya la꞉tamo gala kakapema꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","“Tete nanekelelo hopo habanapa꞉te na a꞉kunama꞉mena꞉, huiyatiya la꞉le na kunamema꞉nemata, iyo, na wiboha꞉ ka꞉ka꞉go emedenamo, ba꞉bema꞉ la꞉ ba꞉ atumu ba꞉be ka꞉ka꞉go emedehonamata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","La꞉le na gala da꞉kunamema, ba꞉be hegelate da꞉puluhukumini, la꞉ ba꞉moe komo ba꞉bo kiya꞉tawahama꞉nemata, na naeno Nabiwi ipuwalo emedenamo ba꞉gala la꞉ na ipuwalo emedehonamata, ba꞉bene na atumu la꞉ ipuwalo bemedenamo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ba꞉bema꞉ puya꞉te naeno tutumu tabo hiliyonomo uwatete da꞉papamila꞉nakomena꞉, ba꞉ba꞉te na malemalelo emalagidolonena. Ba꞉ hibila, kebe tawakaluba꞉te na malemalelo demalagidolonena, naeno Nabiwiti ibi atumu malemalelo ba꞉kemalagidolena, ba꞉gala nale ibi atumu malemalelo ba kemalagidole na ha꞉kiya naeno komo iba꞉tamo ba꞉hawakaliminakomo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ba꞉bene eta Yudasiti, Keliyotanapi Yudasitiha꞉, ebete Ya꞉suku nalateda꞉niya꞉, “Kodawa, hopo habanapa꞉te ama꞉ umihino, ba꞉ba tetelo a ha꞉kiya ama꞉ keba ka꞉na na꞉kumitamena꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ya꞉suti tabo ba huiyana na꞉goeniya꞉, “Kebe lumagiti na malemalelo demalagidolonena, ebete naeno tutumu tabamo ba꞉papamiwatanakomene, ba꞉bene naeno Nabiwiti ebe malemalelo bemalagidolonamene, ba꞉gala ale ebetamo pete ebegodolo ba꞉pemedenama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Huiyatiya kebe lumagiti na malemalelo emalagidolonenaheno, ebete naeno tutumu tabamo a꞉kapapamiwatamene. Ba꞉moe komo ba꞉ hibila, la꞉ nagodolo dulihonakoma ba꞉bi tutumu tabo naenoha꞉, ba꞉bi tutumate na da꞉poenamiya꞉ ba꞉be Nabiwigodone pelamena. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nale la꞉ miya꞉paleheno ba꞉moi komokomo dopamo la꞉tamo ba꞉ olamagimo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ba꞉bene nale la꞉ da꞉miya꞉palema, Nabiwi Godote naeno mahilamo eta Owalubidawa la꞉tamo kopoemema꞉ne, ebe ba꞉ ebeno Hido-talona Gobogobola. Ba꞉ hibila, nale dopamo kebe hiliyonomo komo la꞉ diya꞉tulamenakuima, ebete pete ba꞉bi atu komokomo la꞉ gala ba kapiya꞉tulame la꞉eno ukui ba꞉bo ba꞉tuputupuilamenakomene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ba꞉gala ba꞉moe ba꞉ eta komola, nale la꞉tamo naeno tepo ipuwalo ditana ba꞉be hete bikalamemata. Ba꞉be hete ba꞉moe hopo haboenoha꞉, ba꞉bema꞉ la꞉ la꞉eno tepo ipuwalo ukui bilibila꞉go ba꞉gala tola꞉go akemedehala꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nale la꞉tamo hibilo da꞉goemo la꞉ ulimata, na Nabiwi Godotamo tote ba꞉bene la꞉tamo gala kakapema꞉nemo. Numa꞉la꞉, la꞉le na hibilo malemalelo nemalagidolonenatale, naeno to komoma꞉ la꞉ ba꞉kalakalahona꞉, mabu ebeno helo konomola, naeno helo na꞉gogolona. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ba꞉moe komote uluhukuhino na la꞉ dopamo goelamemata, ba꞉bema꞉ ba꞉moe komote hibilo duluhukumini, ba꞉ba tetelo la꞉ hibima꞉ komidima꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Huiyatiya ka꞉lo dulu na la꞉tamo tabo konomo a꞉kolamaga꞉mo, mabu hopo haba namutudawa ba꞉ na꞉pe. Ba꞉be kubadawoeno helote hibilo natamo kitanaha꞉ nale ebetamo kopapamiwatama꞉, ");
INSERT INTO knv_aramia_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","huiyatiya naeno Nabiwiti na kebe komokomo kododilima꞉ da꞉kiyanamenako, nale ba꞉bi komo ba ododili ebe kapiyatamo papamiwatanakomo. Iyo, ba꞉moe ba꞉be gabodo hopo habanapa꞉te naeno komo niya꞉tawahamena꞉, nale naeno Nabiwi malemalelo demalagidolonamo. “Ba꞉bema꞉ wadiyala la꞉ na꞉pakaminala꞉, a ba꞉moe genamane kotolamiya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo eta tabo bekagoeniya꞉, “Na ba꞉ hibi gala꞉ipi tupina gao kehala, ba꞉gala naeno Nabiwiti ba꞉be gao keha umidawama꞉ eda꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","“Ba꞉bema꞉ ba꞉moe kehoeno nolohoha꞉ gedawa hiliyonomo ebete mabunomamo iya꞉hiliti gobogobamo kiya꞉hekema꞉ne, huiyatiya da꞉nolohonaka ba꞉bi gedawa hiliyonomo hunu pahago ebete hunuya kiya꞉hilima꞉ne iba꞉te konomamo gala kakanolohoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ba꞉ hibila, nale la꞉tamo kebe tabo komokomo kolamaginakuimo ba꞉bi tabote la꞉ ukulalenomo dukulali, la꞉le uliulinoma꞉ ba꞉bo eda꞉huimata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ba꞉bema꞉ wadiyala la꞉le na hibi gao kehagodolo nemedehonala꞉, ba꞉bene na ba꞉ atumu la꞉ ipuwalo bemedenamo. Ba꞉moe komo hidamo nemalagidolala꞉, gao gedawate ebeno apa꞉mo moga꞉heno ebe ha꞉kiya a꞉kanolamene, ba꞉bema꞉ la꞉ na ipuwalo emedenaheno la꞉le hibilo a꞉kanolohamata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Na ba꞉ hibi gala꞉ipi tupina gao kehala, la꞉ gedawalata. Kebe lumagiti na ipuwalo demedenamene ba꞉gala na atumu ebe ipuwalo demedenamo, ebete konomamo konoloma꞉ne. Huiyatiya na la꞉eno tepo ipuwalo emedenaheno la꞉ ha꞉kiya eta hido komo a꞉kododa꞉mata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ba꞉bema꞉ kebe lumagiti na ipuwalo emedenaheno, ebe ba꞉ nolohoha꞉ gedawa keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala. Pali namutudawate ebe gobogobamo da꞉da꞉namene kaloloma꞉ ba꞉bo koneda꞉ma꞉ne, ba꞉bene eta lumagiti pelawete koa꞉mo dito kopa꞉da꞉nama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ba꞉ hibila, la꞉ na ipuwalo demedenama ba꞉gala naeno iya꞉tulame tabote la꞉eno tepo ipuwalo da꞉pola꞉namene, ba꞉ba tetelo la꞉ naeno hiya꞉hiya꞉ tabo hibilo ba ta꞉matale bada komoma꞉ naeno Nabiwi da꞉ga꞉lamema ebete ba꞉be komo la꞉tamo kikalamema꞉na꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mabu keba tetelo la꞉ naeno hibi gao keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉na konomamo da꞉nolohoma, ba꞉ba tetelo la꞉ ba꞉moe komo hidamo kohawakalimima꞉nemata, la꞉ ba꞉ naeno hibi ta꞉matapilata. Ba꞉moe ba꞉be gabodo Nabiwi Godote ebe ha꞉kiya ebe kawagaminama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Numa꞉la꞉, Nabiwiti na malemalelo keba ka꞉na kemalagidolonena, nale la꞉ ba꞉ba ka꞉na emalagidolenamata, ba꞉bema꞉ wadiyala la꞉ naeno malemale ipuwalo nemedeniya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ba꞉ hibila, la꞉ naeno hiya꞉hiya꞉ tutumu tabamo hibilo da꞉papamila꞉hanama, ba꞉be gabodo la꞉le naeno malemale ipuwalo bemedenamata, nale naeno Nabiwino tutumu tabamo papamiwatalo ebeno malemale ipuwalo demedenamo ba꞉ba ka꞉na. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ba꞉bema꞉ nale la꞉ ba꞉moe tabo begoelamemata, mabu na ubila naeno kalakalate la꞉eno tepo ipuwalo tabote ba꞉bolo kitanama꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Ba꞉moe ba꞉ naeno ko tutumu tabola la꞉tamo. Nale la꞉ malemalelo keba ka꞉na kemalagidoletanama, la꞉ ipuwalo etate eta ba꞉ba ka꞉na nemalagidolohuiniya꞉la꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Numa꞉la꞉, eta lumagiti ebeno mabulubino ka꞉ka꞉ mula꞉lelamema꞉ ebeno ka꞉ka꞉ gobogobamo dito dihatemene, ba꞉ba ka꞉na ebegodolo hibi malemale komote konomamo kohawakalama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“Ba꞉gala eta komo, la꞉le naeno tutumu tabamo da꞉papamila꞉hama, ba꞉be gabodo la꞉ naeno mabulubima꞉ keda꞉hama꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ba꞉bema꞉ ba꞉ma tetene tupuimiti nale la꞉ naeno huiyaha꞉ okopima꞉ gala a꞉kaka꞉lama꞉mata mabu huiyaha꞉ okopa꞉te ibino namutudawoeno tepo ipuwoeno ukui hibi a꞉kiya꞉tawahala꞉. Huiyatiya nale Nabiwigodone kebe komokomo kulihuya꞉mo, ba꞉bi hiliyonomo komo la꞉tamo a꞉hawakalilamimo, ba꞉bema꞉ la꞉ naeno hibi huiyaha꞉ okopiha꞉, ao, la꞉ ba꞉ naeno mabulubilata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ba꞉bema꞉ ba꞉moe ko komo akadodala꞉, la꞉le na laweneheno nale la꞉ dopamo uwatimata, la꞉le hopo haboeno hiya꞉hiya꞉ hopolo ba nemedehona hibi gaote la꞉ ipuwalo konolohonama꞉. Ba꞉bene la꞉eno gaote emedena tetelo ba pola꞉na, la꞉ bada komoma꞉ Nabiwi Godoko naeno mahilamo da꞉toemehonakoma, ebete ba꞉be komo la꞉tamo ba꞉bo bikalamenakomena꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ba꞉moe ba꞉ naeno ko tutumu tabola la꞉tamo, la꞉ ipuwalo etate eta malemalelo nemalagidolohuiniya꞉la꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ba꞉bene Ya꞉suti eta tabo bekagoeniya꞉, “Hopo habanapa꞉te la꞉ naeno ta꞉matapa꞉tamo da꞉maubahamena꞉, ba꞉ba tetelo nemalagidoluya꞉la꞉ iba꞉te dopamo natamo a꞉maubahaliya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ba꞉bema꞉ la꞉ hopo habanapima꞉ hibilo neda꞉honatale iba꞉te la꞉ kalakalago buwatetana꞉, huiyatiya nale la꞉ ibi ipuwane uwatimata, ba꞉bema꞉ iba꞉te la꞉ ubiha꞉ma꞉ eda꞉halo la꞉tamo ba꞉maubahanamena꞉ mabu la꞉ iba꞉go kapiyama꞉ keda꞉hanaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ba꞉gala nale la꞉ dopamo da꞉goelamima, la꞉le ba꞉moe tabo gala na꞉kemalagidolala꞉, okodawoeno helote ebeno oko namutudawoeno helo a꞉kagogolale. Ba꞉bema꞉ kebe tawakaluba꞉te natamo koko temeteme dikanamenakui, iba꞉te ba꞉ la꞉tamo atu temeteme ba꞉kikalamenakomena꞉ta, ba꞉gala kebe tawakaluba꞉te naeno iya꞉tulame tabamo da꞉papamila꞉hui, ba꞉ba꞉te la꞉eno iya꞉tulame tabamo atumu kakapapamila꞉hama꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","“Numa꞉la꞉, na da꞉poenamiya꞉ ba꞉be dawoeno komo hopo habanapa꞉te iya꞉tawahaha꞉, ba꞉bema꞉ iba꞉te na mabuma꞉ la꞉tamo kuba komokomo bododilinakomena꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nale iba꞉tamo pete Godokono hibi tabo polamagiha꞉tale, ebeno mauba komote ibino kuba ododili mabuma꞉ ba꞉ka꞉pena꞉, huiyatiya nale ba꞉moe hopo habamo da꞉piya꞉mo, ba꞉ba tetene tupuimiti ibino kuba ugumuili gabo kitanamiha꞉, ba꞉bema꞉ ibino kuba huiyate hibilo ba꞉ na꞉pe. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Numa꞉la꞉, ibi ipuwalo kebe lumagiti natamo da꞉maubana, ebete atumu naeno Nabiwitamo na꞉kamaubana. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ba꞉bema꞉ nale hopo habanapi ipuwalo naeno Nabiwino koko hanohano komo pododiliha꞉tale, ebeno mauba komote ibino kuba ododili mabuma꞉ ba꞉ka꞉pena꞉. Huiyatiya na ibi ipuwalo ebeno helo konomamo a꞉hawakalimimo, eta hopo lumagiti ba꞉bako helo hawakalimi modoboha꞉, iyo, iba꞉te naeno helo hibinomolo umiya꞉, huiyatiya iba꞉te natamo ba꞉gala Nabiwitamo koamo maubahana. ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Numa꞉la꞉, ibi ipuwalo ba꞉moe komote ba꞉ma ka꞉na uluhukui Godokono Buka tabote hibima꞉ keda꞉ma꞉, mabu ebete Yunapa꞉tamo dikalamiya꞉ ba꞉be Tutumu Bukalo tabote ba꞉ma ka꞉na itana, ‘Nale ibi mabuma꞉ hidohido komo ba ododilina, huiyatiya iba꞉te natamo a꞉maubahuya꞉.’ ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Naeno ta꞉matapa꞉la꞉, na eta Owalubidawa la꞉tamo kopoemema꞉nemo, ebe ba꞉ Nabiwi Godogodone da꞉puluhukuna ba꞉be Hido-talona Gobogobola. Ebe ba꞉ Godokono hibi komo hawakalimidawala, ba꞉bema꞉ ebete hopo habanapa꞉tamo da꞉pemene naeno komo kopehawakalimima꞉ne, ");
INSERT INTO knv_aramia_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ba꞉bene la꞉ ba꞉ atumu naeno komo na꞉kahawakalimiya꞉la꞉, mabu hibila, naeno oko tupuimi mabuni la꞉ ba꞉ nago emedenamimata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Na ka꞉lo dulu ba꞉moi komokomo hiliyonomo la꞉tamo olamagimo, mabu na ubihinola la꞉le nato ukamidahale. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tete ba꞉ na꞉pe, Yu tawakaluba꞉te la꞉tamo talona kihatelamema꞉na꞉ta la꞉ ibino hiya꞉hiya꞉ habahaboeno baidi ibubulamehole genama guamo a꞉pa꞉la꞉hama꞉, ba꞉gala ba꞉ba tetelo komopa꞉te la꞉ anakapulamema꞉ nopo ba tamote ba꞉bo kemalagidoloma꞉na꞉ iba꞉te Godokono oko bowatina. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ba꞉ hibila, iba꞉te ba꞉ ba꞉ba ka꞉na la꞉tamo koko kuba ododilima꞉ kewagelema꞉na꞉, mabu iba꞉te naeno komo ba꞉gala naeno Nabiwino komo iya꞉tawahaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ba꞉bema꞉ numa꞉la꞉, na ba꞉moi komokomo la꞉tamo ba꞉ olamagimo, mabu na ubila ba꞉moe kuba tetete da꞉puluhukumini la꞉ ba꞉bo kemalagidoloma꞉nemata, ebete aeno temeteme komoma꞉ a ya꞉lo a꞉kiyaa꞉mi.” Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo eta tabo bekagoeniya꞉, “Na dopamo ba꞉moi komokomoma꞉ la꞉ kakiyahalameha꞉, mabu naeno oko tupuimi mabuni pete ba꞉ma teta꞉mo puluhuku, ba꞉be tete ga꞉ga꞉dopolo nale la꞉go emedenamimo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Huiyatiya tete ba꞉ na꞉pe, na da꞉poenamiya꞉ ba꞉be dawatamo na gala kakatoma꞉nemo. La꞉ ba꞉be komoma꞉ ukui bilibilima꞉ ba eda꞉hana, huiyatiya etate na ba꞉ma ka꞉na kalateda꞉nenaha꞉, ‘Ama꞉ kebamo na꞉ka꞉tomena꞉?’ ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","mabu la꞉ naeno to komo ba emalagidolona tepo ipuwalo menemenenomoma꞉ eda꞉hanamata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ba꞉bema꞉ nale la꞉ hibi tabo begoelamemata, nale la꞉ da꞉miya꞉palema ba꞉ hido komola, mabu na toheno la꞉eno eta Owalubidawa, ebe ba꞉ Godokono Gobogobola, ebete la꞉tamo a꞉kapa꞉mene. Iyo, na la꞉ ipuwane da꞉tomo, ba꞉ba tetelo na ba꞉be Hido Owalubidawa la꞉tamo hibilo kopoemema꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Ebete hopo habanapa꞉tamo da꞉pemene, ba꞉ba tetelo ebete iba꞉tamo netewa-kapiya komokomo kopehawakalilamema꞉ne, ba꞉moi komokomo ba꞉ hopo haboeno kuba ododili komo, ba꞉gala Godokono tuputupu emede komo, ba꞉gala Godote tawakalubino kuba ododili mabuma꞉ iba꞉tamo huiya ikalame komo, ba꞉moi ba꞉bi komokomola. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ba꞉ hibila, Godokono Gobogobote hopo habanapino kuba ododili komo kopehawakalilamema꞉ne mabu iba꞉te na hibima꞉ kamidininaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ba꞉gala ebete tuputupu emede komo kopehawakalimima꞉ne, mabu tete tatalila na Tuputupudawate ba꞉moe hopo miya꞉pate Nabiwi Godotamo gala kakatoma꞉nemo, ba꞉ba tetelo la꞉ la꞉eno baida꞉mo na gala a꞉kunama꞉mata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ba꞉gala Godote tawakalubino kuba ododili mabuma꞉ huiya iba꞉tamo dikalamemene, ebeno Gobogobote ba꞉be komo kopehawakalimima꞉ne, mabu Godote ba꞉moe hopoeno Kuba Gawadubu Saitanatamo kuba huiya hibilo kikamema꞉ne, iyo, ebete ba꞉be komo kododima꞉ tabo ya꞉lo ihatiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ba꞉ hibila, nagodolo hiliyonomo komokomo ba꞉pola꞉na la꞉tamo olamagima꞉, huiyatiya ba꞉ma tetelo la꞉eno ukui modoboha꞉ ba꞉bi komo la꞉le kuwatema꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Huiyatiya Godokono hibi komo Hawakalimidawate da꞉pemene, ba꞉be Hido-talona Gobogobote la꞉ ebeno hibi gabodo dopalamete, la꞉ ba magatale hiliyonomo komo ba꞉bo kiya꞉tawahama꞉nemata. Ba꞉ba tetelo ebete ha꞉kiya ebeno ukuilo a꞉kolamaga꞉mene, huiyatiya ebete kebe komokomo Nabiwigodone dulihonako ebete ba꞉bi komo kapiya la꞉tamo bolamaginakomene, ba꞉gala kebe komate hopo habamo da꞉pikulimina꞉, ba꞉bi komate pelameheno dopamo ebete la꞉tamo ya꞉lo ba꞉hawakalilamenakomene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iyo, ebete ba꞉moe gabodo na kopawagaminanema꞉ne, mabu ebete naeno tepo ipuwoeno komokomo uwatete la꞉tamo hibilo kopehawakalilamema꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Numa꞉la꞉, Nabiwigodolo da꞉pola꞉na ba꞉bi hiliyonomo komokomo ba꞉ naenola, ba꞉bema꞉ ebeno Gobogobote modobola naeno tepo ipuwoeno komokomo la꞉tamo hawakalilame, nale la꞉ da꞉goelamema ba꞉ ba꞉ba ka꞉na.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ba꞉bene Ya꞉suti ebe ta꞉matapa꞉tamo eta tabo bekagoeniya꞉, “Tete tatalila la꞉le na la꞉eno baida꞉mo a꞉kunama꞉mata, ba꞉bene tete nanekele da꞉wibomene la꞉le na gala kakunamema꞉nemata.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ba꞉bene ebeno ta꞉matapi ipuwalo komopa꞉te komopa꞉tamo ga꞉lanakui, komopa꞉te komopa꞉tamo ga꞉lanakui, ba꞉ma ka꞉na ewageleniya꞉, “Ya꞉suti ba꞉moe tabo badama꞉ ka꞉goe, tete tatalila la꞉ na a꞉kunama꞉mata ba꞉bene tete nanekelelo la꞉ na gala kakunamema꞉nemata? Ba꞉gala ebete Nabiwitamo toma꞉ da꞉goe, ba꞉moe taboeno ipuwa keba ka꞉nala꞉ka꞉? ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ba꞉gala ale ba꞉moe eta komo iya꞉tawaha꞉, ebete 'tete nanekele' tabo da꞉goe, ba꞉be tete kebako tetela꞉ka꞉?” ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ba꞉ba tetelo iba꞉te ibi ipuwalo Ya꞉sukunu tabo ipuwoeno komoma꞉ kebe hiya꞉hiya꞉ alateda꞉ tabo da꞉ga꞉laniya꞉, Ya꞉suti iya꞉tawanate iba꞉tamo gala na꞉kagoeniya꞉, “Iyo, nale tabo ba꞉ma ka꞉na olamagimo, tete tatalila la꞉le na a꞉kunama꞉mata, ba꞉bene tete nanekelelo la꞉le na gala kakunamema꞉nemata. La꞉ ba꞉moe taboeno ipuwama꞉ ka꞉ga꞉lonama? ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na la꞉tamo hibi tabonomo begoemo, na la꞉ ipuwane da꞉tomo ba꞉ba tetelo hopo habanapa꞉te kokalakalahama꞉na꞉, huiyatiya la꞉le na ba la꞉name tepo menemene konomamo ba꞉bo kiya꞉tawahama꞉nemata. Huiyatiya numa꞉la꞉, tete nanekele da꞉petomene, la꞉eno tepo menemene komo wibote la꞉le na mabuma꞉ ko kalakala gala kakalawema꞉nemata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ba꞉bema꞉ ba꞉moe komo ba꞉ lamitu kamenate gudu alahimima꞉ temeteme dulita keba ka꞉nala꞉ka꞉ ba꞉ba ka꞉nala. Ebete gudu ba alahimi ko temeteme ba꞉bo kiya꞉tawama꞉ne, huiyatiya ebeno gudu da꞉hawakalamene ba꞉ba tetelo ebegodolo kalakala kapiyate kitanama꞉ne, mabu ebeno temeteme ba꞉ a꞉wibo ba꞉gala ebeno guduti ka꞉ka꞉go hawakala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","La꞉eno komo ba꞉ atumu, ba꞉ma tetelo la꞉le naeno to komoma꞉ tepo ipuwalo menemenenomoma꞉ eda꞉hanamata, huiyatiya nale tote la꞉tamo gala da꞉kapuluhukumu la꞉le ko kalakala gala ba꞉bo kakalawema꞉nemata, ba꞉be kalakala eta lumagiti kubahimi modoboha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Na la꞉tamo hibi tabonomo begoemo, ba꞉be kalakala hegelate la꞉tamo duluhukumini, ba꞉ba tetelo la꞉ la꞉eno modoboha꞉ komoma꞉ na gala a꞉katoenamehona꞉mata. Ba꞉ba tetene tupuimiti la꞉ naeno mahilamo kebe komokomoma꞉ Nabiwi Godoko da꞉toemehonakoma, ebete ha꞉kiya ba꞉bi komo la꞉tamo bikalamenakomena꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dopamo tetelo la꞉le naeno mahilamo ebe katoemehonakuiha꞉, huiyatiya ba꞉ma tetelo nale la꞉ begoelamemata, wadiyala la꞉ ebe na꞉toemehonakuya꞉la꞉, ba꞉bene la꞉ ebegodone hido komo da꞉lawenakoma ba꞉be gabodo la꞉eno kalakala komote konomamo bitananakomene.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ba꞉bene Ya꞉suti eta tabo bekagoeniya꞉, “Nale iya꞉tulame uwa꞉mo ba꞉moi komokomo la꞉tamo ba꞉ a꞉hawakalilamemo, huiyatiya tete kopema꞉ne nale la꞉ uwa꞉mo gala a꞉kiya꞉tulama꞉mata, ba꞉ba tetelo na naeno Nabiwino komo la꞉tamo hawakalanomo kolamagima꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ba꞉be hegelalo nale Nabiwitamo la꞉eno modoboha꞉ komoma꞉ gala a꞉katoetoa꞉mo, huiyatiya la꞉ ha꞉kiya naeno mahilamo ebe ba꞉toemehonakomata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Numa꞉la꞉, Nabiwiti la꞉ malemalelo nemalagidolenata. Ebete ba꞉ma ka꞉na ewagelena mabu la꞉le na malemalelo ba emalagidolonena, nale ebegodone da꞉piya꞉mo ba꞉be komo la꞉ hibima꞉ na꞉midinamata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Iyo, ba꞉ hibila, na Nabiwigodone ba꞉moe hopamo piya꞉mo, huiyatiya ba꞉moe ba꞉ tetela, nale hopo haba miya꞉pate Nabiwitamo gala kakatoma꞉nemo.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ba꞉bene Ya꞉suku ta꞉matapa꞉te ebetamo na꞉ga꞉laniya꞉, “Kalakala konomola, a ba꞉moe tabo modobolo lawema꞉ mabu ama꞉ atamo iya꞉tulame uwa꞉mo kolamaginaha꞉, hawakala olamaginata. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Iyo, ka꞉lo dulu a ba꞉ iya꞉tawahama꞉ ama꞉ hiliyonomo komokomo iya꞉tawanomola, ba꞉bema꞉ eta lumagiti eta komoma꞉ ama꞉ alateda꞉heno ama꞉ ebeno tepo ipuwoeno ukui ya꞉lo kiya꞉tawama꞉na꞉ta. A ba꞉moe komone hibima꞉ na꞉midinama꞉, ama꞉ ba꞉ Godogodone piya꞉ta!” ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ba꞉bene Ya꞉suti ibino tabo ba huiyana na꞉goeniya꞉, “Ka꞉lo dulu la꞉ na hibilo hibima꞉ na꞉ka꞉midinionama? ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tete kopema꞉ne, iyo, ba꞉ na꞉pe, la꞉ nagodone la꞉eno hiya꞉hiya꞉ genamamo alahutihote, ba꞉bene na ha꞉kiya kolutama꞉nemo. Ba꞉ba tetelo nago demedena ba꞉be Nabiwi ebe kapiyate na a꞉kamiya꞉pana꞉mene, ebete nago kolutama꞉ne. ");
INSERT INTO knv_aramia_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ba꞉bema꞉ numa꞉la꞉, nale ba꞉moi komokomo la꞉tamo ba꞉ olamagimo, mabu na ubila la꞉le na ipuwalo ba emedena naeno hetete la꞉godolo kitanama꞉. Ba꞉ hibila, ba꞉moe hopolo la꞉ koko temeteme biya꞉tawahanakomata, huiyatiya na꞉kalakalahala꞉! La꞉ akatoletolehala꞉ mabu naeno helote ba꞉moe hopoeno helo ya꞉lo anakapumi.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ya꞉suti ba꞉moe tabo olamagi da꞉wiboniya꞉, ba꞉ba tetelo ebete Godokono Hunu Habamo ba gahimina toetoe tabo ba꞉ma ka꞉na olamaginiya꞉, “Nabiwi, tete ba꞉ a꞉pe. Wadiyala ama꞉le na amia꞉no gudu ba awagaminane naeno hido komo na꞉hawakalima꞉, ba꞉bema꞉ na atumu ama꞉ ba awagamina amia꞉no hido komo kohawakalimima꞉nemo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ba꞉ hibila, ya꞉lo tetelo ama꞉le ko helo amia꞉no Gudutamo ikamiya꞉ta, ba꞉bema꞉ hopo habanapi hiliyonomate ebetamo hibilo kopapamila꞉halema꞉na꞉, ba꞉gala ama꞉le ibi ipuwalo kebe tawakalubi ebetamo dikamihuya꞉la, ibinomate wiboha꞉ ka꞉ka꞉ ebegodone kolawema꞉na꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ba꞉be wiboha꞉ ka꞉keno komo ba꞉ ba꞉ma ka꞉nala. Tawakaluba꞉te ama꞉ hibi kapiya Godoma꞉ miditi amia꞉no komo ba꞉bo kiya꞉tawahama꞉na꞉, ba꞉gala atu tetelo iba꞉te na Ya꞉su Kelisokono komo kakiya꞉tawahama꞉na꞉, na ba꞉ ama꞉le da꞉poenamiya꞉la ba꞉be dawala. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ba꞉bema꞉ nale ba꞉moe hopamo peheno ama꞉le ya꞉lo natamo kebe hiya꞉hiya꞉ oko kikanamehoniuya꞉la, nale ba꞉bi oko hiliyonomo upula꞉limo, iyo, ba꞉moe gabodo nale ama꞉ ba awagamina amia꞉no hido awagaha komo tawakaluba꞉tamo a꞉hawakalimimo. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Nabiwi, ba꞉moe hopo ododiha꞉ tetelo nale ama꞉go ba emedena agodolo ditanami, wadiyala ama꞉le ba꞉be helo alamo na ba a꞉la꞉minane amia꞉no holoholo hapulu na nawagaminaniya꞉.” ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ba꞉bene Ya꞉suti ebeno toetoe tabo moga꞉melo gala na꞉kagoeniya꞉, “Nabiwi, ba꞉moe hopolo ama꞉le natamo dikanami ba꞉ba꞉te amia꞉noma꞉ eda꞉huya꞉, ba꞉bema꞉ nale amia꞉no komo iba꞉tamo da꞉hawakalimimo, iba꞉te amia꞉no tabamo a꞉papamila꞉huya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ba꞉bema꞉ ka꞉lo ibi iya꞉tawahala, ama꞉le ya꞉lo natamo kebe hidohido komo kikanamehoniuya꞉la ba꞉bi hiliyonomo komate ba꞉ ama꞉godone pelamiya꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Iyo, ama꞉le natamo dikanamehoniya꞉la ba꞉bi tabo komokomo nale iba꞉tamo ikalameholimo, ba꞉bene iba꞉te hibilo uwatete ba꞉bo iya꞉tawahuya꞉ nale ama꞉godone da꞉piya꞉mo ba꞉be komo, ba꞉gala ama꞉le na da꞉poenamiya꞉la iba꞉te ba꞉be komo hibima꞉ na꞉midina. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ba꞉bema꞉ na ibi toetoe tabamo ama꞉tamo na꞉pewadiya꞉paa꞉latelenamo. Nale ama꞉ komo hopo habanapino komoma꞉ kapetoemehonaha꞉, huiyatiya ama꞉le ba꞉ma tetelo natamo kebe kapiyakapiya tawakalubi kikanamehoniui ibi kapiyoeno komoma꞉ toemehonamata, mabu ibi ba꞉ amia꞉nola. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Iyo, naeno hiliyonomo komokomo ba꞉ amia꞉nola ba꞉gala amia꞉no hiliyonomo komokomo ba꞉ naenola, ba꞉bema꞉ ba꞉moi ta꞉matapi ipuwado ama꞉le na hopo habalo awagaminania꞉ta. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","12","“O naeno Hido-talona Nabiwi, tete tatalila na hopo haba komiya꞉pama꞉nemo, huiyatiya ba꞉moe hopo ba꞉ naeno ta꞉matapino emede habala. Ba꞉bema꞉ a netewapa꞉te kapiya ukuilo keba ka꞉na kemedenama꞉, iba꞉te ba꞉ ba꞉ba ka꞉na gelebadia꞉go kapimilo kemedenama꞉ wadiyala ama꞉ amia꞉no helo mahilamo ibi hidamo nulameniya꞉. Ba꞉be helo mahilo ama꞉le natamo ya꞉lo ikanamiya꞉ta, ba꞉gala nale dopamo iba꞉go ba emedena ba꞉be mahilamo ibi hidamo buiya꞉minalenamimo. Ba꞉ hibila, ibi naeno buiya꞉minale ipuwalo eta kapiyate kalatidiha꞉, huiyatiya amia꞉no Buka tabote hibima꞉ keda꞉ma꞉ kapiya dubunomote ba꞉bema꞉ kubui, ama꞉le Koe Habamo dopamo pote toma꞉ da꞉goiya꞉la, ba꞉moe ba꞉be dubula. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Tete tatalila nale ama꞉tamo kopema꞉nemo, iyo, nale ba꞉moi hiya꞉hiya꞉ toetoe tabo ba꞉moe hopolo ba꞉bema꞉ olamaginamo, mabu na ubila naeno ko kalakalate naeno ta꞉matapino tepo ipuwalo na꞉tabotabohamene. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Hibila, nale amia꞉no hido tabo iba꞉tamo dikalamimo, ba꞉be mabuma꞉ hopo habanapa꞉te iba꞉tamo na꞉maubahalena. Dopamo tetelo iba꞉te hopo habanapa꞉go kapiyama꞉ eda꞉hanama꞉, huiyatiya iba꞉te uli ka꞉ka꞉ da꞉lawi iba꞉te hiya꞉ tawakalubima꞉ ba꞉bo eda꞉huya꞉, ba꞉bema꞉ ka꞉lo na keba ka꞉na kemedenamo ibi ba꞉ ba꞉ba ka꞉nala, ibi ba꞉gala na, a hopo habanapima꞉ hibilo keda꞉hanaha꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“O Nabiwi, ama꞉le ibi ba꞉moe hopone dito uluhukulatelema꞉ katoemehonaha꞉, huiyatiya nale ama꞉ na꞉toemehonamata, iba꞉te ba꞉moe hopolo ba emedena ama꞉le ibi hidamo kobuiya꞉minalenama꞉ Saitanate ibi kubahilamekapoma꞉. ");
INSERT INTO knv_aramia_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ba꞉ hibila, na ba꞉moe hopo lumagiha꞉, ba꞉gala ibi ba꞉ atum