﻿USE sofia;
DROP TABLE IF EXISTS sofia.knjNT_vpl;
CREATE TABLE knjNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES knjNT_vpl WRITE;
INSERT INTO knjNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ja' ton sbi eb yichmam naj Jesucristo yin xolilal ti'. Ja' Jesucristo, yic'aal naj David c'al yic'aal pax naj Abraham. ");
INSERT INTO knjNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ja' naj Abraham, smam naj Isaac, catu' naj Isaac, smam naj Jacob. Ja' naj Jacob, smam naj Judá yetoj wan xa eb yuẍtaj. ");
INSERT INTO knjNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ja' naj Judá yetoj ix Tamar, ey yuninal eb, naj Fares c'al naj Zara. Ja' naj Fares, smam naj Esrom. Ja' naj Esrom, smam naj Aram. ");
INSERT INTO knjNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ja' naj Aram, smam naj Aminadab. Ja' naj Aminadab, smam naj Naasón. Ja' naj Naasón, smam naj Salmón. ");
INSERT INTO knjNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ja' naj Salmón yetoj ix Rahab, ey yuninal eb, naj Booz. Ja' naj Booz yetoj ix Rut, ey yuninal eb, naj Obed. Ja' naj Obed, smam naj Isaí. ");
INSERT INTO knjNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ja' naj Isaí, smam naj rey David, smam naj Salomón. Ja' xutx naj Salomón tu', ja' ix yistil naj Urias yet sbabelal. ");
INSERT INTO knjNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ja' naj Salomón, smam naj Roboam. Ja' naj Roboam, smam naj Abías. Ja' naj Abías, smam naj Asa. ");
INSERT INTO knjNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ja' naj Asa, smam naj Josafat. Ja' naj Josafat, smam naj Joram. Ja' naj Joram, smam naj Uzías. ");
INSERT INTO knjNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ja' naj Uzías, smam naj Jotam. Ja' naj Jotam, smam naj Acaz. Ja' naj Acaz, smam naj Ezequías. ");
INSERT INTO knjNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ja' naj Ezequías, smam naj Manasés. Ja' naj Manasés, smam naj Amón. Ja' naj Amón, smam naj Josías. ");
INSERT INTO knjNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ja' naj Josías, smam naj Jeconías yetoj eb yuẍtaj. Ja' yul stiempoal eb tu' jix i'letoj eb yuninal Israel yu yak'le servil eb bey Babilonia. ");
INSERT INTO knjNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ja' yet ey xa ec' eb bey Babilonia tu' xin, jix ali Salatiel, sc'aal naj Jeconías. Ja' naj Salatiel, smam naj Zorobabel. ");
INSERT INTO knjNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ja' naj Zorobabel, smam naj Abiud. Ja' naj Abiud, smam naj Eliaquim. Ja' naj Eliaquim, smam naj Azor. ");
INSERT INTO knjNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ja' naj Azor, smam naj Sadoc. Ja' naj Sadoc, smam naj Aquim. Ja' naj Aquim smam naj Eliud. ");
INSERT INTO knjNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ja' naj Eliud, smam naj Eleazar. Ja' naj Eleazar, smam naj Jacob. ");
INSERT INTO knjNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ja' naj Jacob, smam naj José, yichamil ix María, ix xutx naj Jesús, naj chi yij Cristo, ja' ton naj Ak'bil Yopiso yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yu tu' xin, canlajonwan eb ichmame yet tax c'al naj Abraham masanta' c'al naj David. Catu' canlajonwan pax eb yet tax c'al naj David masanta' c'al jix i'letoj eb Israel bey Babilonia. Catu' canlajonwan pax eb yet tax c'al jix i'letoj eb Israel tu' bey Babilonia masanta' c'al jix ali naj Cristo. ");
INSERT INTO knjNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jaxca c'al ti' yoc sk'aneal yalubal Jesucristo ti': Ey xa strato naj José yetoj ix María. K'ane to c'al, c'am to chi yil-le sba eb, pero mimejal xa pax ix María tu'. Ja' naj Santo Espíritu jix aon pitzc'u a jun unin tu' yin ix. ");
INSERT INTO knjNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ja' naj José tu', caw jijyom naj yin sley Moisés. Cax c'al jijyom naj pero ma yal sc'ul naj jix abcha sk'umal ix María tu' yu ánima, yuxan jix yoche naj chi lawi ey jun strato eb tu' yin ewantajil. ");
INSERT INTO knjNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ja' yet lalan to sna'on naj José jun tu' xin, catu' jix x'oxon a sba jun yángel naj Kaawil yin weyicheal tet naj, catu' jix yalon tet jaxca ti': —José, jaach yic'aal naj David, manchej jaach xiw ja wi'on María ja wistil oj. Yutol ja' jun unin ey xa oc yin ix tu', ja' naj Santo Espíritu jix aon oc yin ix. ");
INSERT INTO knjNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ja' jun unin oj aloj tu', winaj unin. Oj ja wak' yij sbi Jesús, yutol ja' oj colon el eb sconob xol spenail, ẍi jun ángel tu' tet naj José. ");
INSERT INTO knjNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jix yun masanil wan ti' yet watx' chi yun tzet jix yal naj Kaawil, yet jix yak'balnen sti' jun ẍejab yalon jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ey jun ix k'opo ix, c'am to chi yil-le sba yetoj junoj winaj, pero oj pitzc'u a jun unin yin. Ja' jun unin oj aloj tu', winaj unin. Emanuel oj yija, ẍi yul An Juun Tz'ibebil can oj. Emanuel chi yal yel oc apnoj: Ey ec' Dios ketoj. ");
INSERT INTO knjNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ja' yet jix el sweyan naj José tu' xin, jix sjijen naj jaxca jix yun yalon jun yángel naj Kaawil tu' tet naj, catu' jix ẍa'on sc'ul yi'on ix. ");
INSERT INTO knjNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero ma to c'al yil-le sba eb, masanta' c'al jix ali naj sbabel yune' ix tu', catu' jix yak'on yij Jesús naj José tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ja' bey jun conob chi yij Belén yul yet Judea, ja' tu' jix ali Jesús. Ja' yet jun tiempoal tu', ja' naj Herodes ey oc reyal bey Judea tu'. Ey wan winaj chi yij ilom weycan. Ja' yet jix ali Jesús, jix tit ta' c'al eb bey chi aol c'u. Jix apni eb bey Jerusalén. ");
INSERT INTO knjNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jix sk'anlen eb jaxca ti': —¿Beytu' ey oc jun winaj unin jix ali, jun tol oj oc sreyal oj eb Israel? Ja' bey chi aol c'u, ja' ta' tu' jix kil jun weycan, jun jix tx'oxon yalubal jun unin tu' e on. Yuxan jix cu tit kila, catu' chi kaon ey cu ba tet, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ja' yet jix yaben naj rey Herodes jun ti', tu' xa c'al jix q'uey can a sc'ul naj yetoj masanil eb a Jerusalén tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Catu' jix yawten oc masanil eb yaawil yak'omal xaambal eb Israel tet Dios, c'al eb cuywam yin sley Moisés, catu' jix sk'anlen el tet eb, beytu' t'inan chi ali naj Cristo. ");
INSERT INTO knjNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jix tak'wi eb tet naj jaxca ti': —Ja' bey conob Belén yul yet Judea, ja' tu' oj aloj. Yutol ey jun ẍejab Dios quey tu' jix yute tz'iben can jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ja' jun conob Belén yul yet Judea, yali' conob ch'an yintaj wan xa conob yul yet Judea tu', pero miman yel oc apnoj yintaj wan xa tu', yutol ja' bey jun yali' conob tu' oj pitzc'u a jun yaaw. Catu' ja' oj ak'on cuenta jin conob Israel, ẍi yul An Juun Tz'ibebil can tu', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Catu' jix yawten eb ilom weycan, eb chi yij pax yin mago naj Herodes tu' yin ewantajil, catu' jix sk'anlen naj tet eb: —¿Bak'ini tax jix x'ox a sba jun weycan tu'? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jix lawi yaben naj xin, catu' jix chejletoj eb bey conob Belén tu' yu naj. Jix yalon tet eb jaxca ti': —Asi' wej titu'. Chi cam je k'anlen je yab yu jun unin tu'. Catu' ja' yet chi ilcha je yu xin, catu' chex ec' je yalon wab an, beytu' ey oc ec' oj, yet watx' chin to pax wi' ey jin ba tet, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jix lawi yaben eb wan k'ane tu' xin, catu' jix to eb. Ja' jun weycan jix yil a toj eb yet ey ec' eb bey chi aol c'u tu', jix babi c'al sattaj eb, masanta' c'al jix apni batxnaj yiban bey ey ec' jun unin tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ja' yet jix yilon jun weycan eb tu' caw jix tzala a sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jix apni eb bey na bey ey ec' naj unin tu'. Jix yilon oc yin naj eb yetoj xutx, ja' ton ix María. Catu' jix ey kaan eb tet jun unin tu', jix yi'on ey sba eb tet. Jix lawi tu' xin, catu' jix sjajon sc'uanbalil sa'beal eb tu'. Jix sa'on can eb oro tet jun unin tu'. Catu' jix sa'on pax can eb jun tujan te' suk'uk'i xa c'al yel sab yet chi tz'a'i, c'al jun tujan yal te' suk'uk'i pax sab chi yij mirra. ");
INSERT INTO knjNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jix lawi c'al jun tu' xin, catu' jix al-le tet eb yin weyicheal tol manchej ec' yal eb tet Herodes beytu' ey oc ec' naj unin tu', yuxan tx'oj xa beal jix yi' eb yet jix meltzo eb bey sconob. ");
INSERT INTO knjNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jix c'al paxtoj eb ilom weycan xin, catu' jix x'oxon a sba jun yángel naj Kaawil tet José yin weyicheal, catu' jix yalon tet naj jaxca ti': —Eyman, aan waan oj. Ijbatoj naj unin yetoj xutx, catu' chex to bey conob Egipto. Eyan nej ec' titu' masanta' c'al oj wal e ach, catu' chex meltzo pax tej. Yutol ja' naj Herodes, oj ak'on seyle jun unin tu' yutol chi yoche chi yak' cam oj, ẍi jun ángel tu' tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yuxan jix a waan José tu', catu' jix yi'on bey naj nene' tu' yetoj, c'al xutx yet ak'balil tu'. Catu' jix to eb bey Egipto. ");
INSERT INTO knjNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jix ey ec' eb titu' masanta' c'al jix cam naj Herodes, catu' jix meltzo eb junel xa. Jaxca ton ti' jix yune', yu yunen el tzet jix yal naj Kaawil, yet jix yak'balnen sti' jun ẍejab yalon jaxca ti': “Jix wawte pax tej jin C'aal bey Egipto,” ẍi yul An Juun. ");
INSERT INTO knjNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ja' yet jix yilon naj Herodes tol ma xa ec' eb mago tu' sc'atan naj. Tu' c'al jix etnele yu eb, yuxan caw jix tit sjowal sc'ul naj, yuxan jix chej mak'le cam masanil eb winaj unin, eb unin masanta' caab jabil xa sk'inal eb, yutol jaxca tu' jantaj xa stiempoal yal-le tet naj yu eb mago. Bey conob Belén yetoj c'al bey masanil scawilal jix mak'le cam eb unin tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jaxca ton ti' jix yun tzet jix s'ibe can naj ẍejab Dios, chi yij Jeremías yet jix yalon naj jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ey aw jix able yoc bey conob Ramá. Ey mimej ok'il, yetoj mimej cus c'ulal. Ja' ix Raquel, caw jix mi'chcha sc'ul yok' yu eb yune'. C'am xa chi tz'ini ix yu eb yune' tu', yu jix cam eb, ẍi naj Jeremías. ");
INSERT INTO knjNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ja' yet jix cam naj Herodes tu' xin, jix x'oxon a sba jun yángel naj Kaawil tet naj José yin weyicheal yet ey ec' naj bey Egipto tu', catu' jix yalon tet naj jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Aan waan oj. I'toj naj unin ti' yetoj xutx. Meltzan nej bey je conob Israel. Yutol ja' eb jix ochen jix mak'on cam naj nene' unin ti', camnaj xa eb, ẍi jun ángel tu' tet naj José. ");
INSERT INTO knjNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Catu' jix a waan naj José tu', catu' jix yi'on meltzo naj nene' naj tu' yetoj xutx junel xa bey slugar eb yet Israelal tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero jix yab José tol ja' naj Arquelao ey oc yaawil bey Judea sq'uexel oj smam naj Herodes. Yuxan jix xiw naj smeltzo titu' junel xa. Jix yalon Dios tu' yin weyicheal tet naj tzet watx' chi yune', yuxan jix to can eb bey yul-laj yet Galilea. ");
INSERT INTO knjNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jix apni eb titu' xin. Jix caay eb bey jun conob chi yij Nazaret. Jaxca ton tu' jix yune', yu yunen tzet albilcan yu eb ẍejab Dios yet peyxa, yet jix s'iben can eb tol t'inan chi yija Jesús a Nazaret. ");
INSERT INTO knjNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ja' c'al ton oc yet jun tiempoal tu' jix to naj Juan Bautista bey jun cusiltaj tx'otx' yul yet Judea. Jix c'oli yalon sk'ane Dios naj tet eb ánima jix apni eb yab tet. ");
INSERT INTO knjNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jix yalon tet eb jaxca ti': —Na' wej je ba yin je penail, yutol ja' naj Yaaw bey satcan, tuxa chi oc can Yaawil titi', ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ja' ton naj Juan ti' jix al-le yin naj yin ey oj to yu naj ẍejab Dios chi yij Isaías, yet jix yalon can jaxca ti' yul An Juun Tz'ibebil can oj: Ey jun mac txequel bey cusiltaj tx'otx' oj yal yin ipal jaxca ti': “Jaxca chi yun swa'nele junoj be yet chi jul junoj yaaw, quey tu' che yute je wa'nen je beybal, yutol oj jul naj Kaawil” quey tu' oj yute yaloni, ẍi yul An Juun Tz'ibebil can oj. ");
INSERT INTO knjNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ja' spichil naj Juan tu' ey oc oj, ja' ton xil no' camello chembil, catu' tz'um ey oc sc'alil oj naj. Ja' jun tujan no' tinquin tzu chi ẍi naj, c'al yetoj yal awcab chi yuq'ue. ");
INSERT INTO knjNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ja' eb a Jerusalén yetoj eb a Judea c'al jantaj eb a sti'laj ja' Jordán, chi bet eb yab chi yal tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jix yal el spenail eb tet Dios, catu' jix ak'le can bautizar eb yu naj Juan bey yul ja' Jordán tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ec'al eb fariseo yetoj eb saduceo jix apni sc'atan naj yu yak'le bautizar eb yu naj. Pero jix yal naj tet eb jaxca ti': —Jaexti', caw jelan jex yin i'o eytej sate jaxca no' laba. ¿Tumi che na' tol chi ske' je colon el je ba tet jun miman sya'ilal oj jul je yiban yu sjowal sc'ul Dios? ");
INSERT INTO knjNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ta yel chi sna' sba je c'ul yin je penail, sowalil watx' che yute je beybal, yet watx' chi txeclo el oj tol yel jix je na' je ba. ");
INSERT INTO knjNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Manchej je yal jaxca ti': “C'am tzet chi cu na', yic'aal jon naj Abraham jon,” man je chi oj. Yutol chi wal e ex an, k'inaloj ta chi yal sc'ul Dios, chi ske' yuten oc wan ch'en ti' animail, catu' chi oc yic'aal oj naj Abraham je q'uexel oj. ");
INSERT INTO knjNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ja' jun miman sya'tajil oj jul je yiban, laan jaxca junoj winaj listo xa ye yetoj yeche yich junoj te'. Masanil te' c'am swatx'il sat chi yak'a, chi tzoc' a oj, catu' chi sk'ojontoj yiban k'ak'. ");
INSERT INTO knjNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jainti', yel chex wak' bautizar yetoj ja', pero ey jun mac txequel tol to oj jul oj. Ja' jaxca tol oj jex yak' bautizar yetoj Santo Espíritu, ma yetoj k'ak'. Ja' jun mac txequel oj jul tu', yel xa c'al miman yel oc apnoj wintaj an. Yuxan man jin moo oj wak'on servil, cax c'al asan yu wi'on el xanab, man jin moo oj. ");
INSERT INTO knjNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ja' jun mac txequel chi wal tu', laan jaxca junoj mac txequel chi xeye strigo, yu yi'on can el sk'ail ixim xol sbak' ixim. Chi lawi xeyeni, catu' chi yi'ontoj strigo tu' bey sc'uanbal, jal sk'ail ixim chi el can tu', chi sec'le can toj yiban jun k'ak' c'am chi tani, ẍi naj Juan tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ja' yet jun tiempoal tu', jix tit Jesús bey jun lugar chi yij Galilea, catu' jix apni sc'atan naj Juan yet ey ec' naj bey ja' Jordán, yu yapni sk'anon sbautismo tet. ");
INSERT INTO knjNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yin sbabelal ma yal sc'ul naj Juan chi yak' bautizar naj. Ja' ti' yet, jix yal tet Jesús jaxca ti': —Jin moo jainti', tol chin ja wak' bautizar, pero ila, tol cha woche tol chach wak' bautizar, ẍi Juan tu' tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jix yalon Jesús tu' tet jaxca ti': —Sowalil chin ja wak' bautizar, yutol smoo jin jijen masanil tzet chi yal Dios, ẍi Jesús tet naj. Catu' jix sjijen naj Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jix c'al lawi yak'le bautizar Jesús tu', catu' jix atej yul ja'. Ja' yet jun txolan tu' jix jajcha satcan, catu' jix yiloni, tol jix eyol Yespíritu Dios yiban Jesús jaxca junoj no' uch. ");
INSERT INTO knjNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Catu' jix yaben jayeb k'ane eb jix tit bey satcan. Tol jix yal jaxca ti': —Ja' ton jun jin C'aal ti', cam c'ulnebil wu an. Caw chin tzala yetoj, ẍi jayeb k'ane tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Catu' jix i'letoj Jesús yu Yespíritu Dios bey jun cusiltaj tx'otx', yutol oj ak'le yijbale naj yin spenail yu naj diablo. ");
INSERT INTO knjNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","C'am tzet jix slo' yin cawinaj c'ual, cawinaj ak'bal. Catu' jix tit swail Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jix apni naj diablo tu' sc'atan naj, yu yak'len yijban naj yin spenail, catu' jix yaloni: —Tutun tol Sc'aal jaach Dios, al tet wan ch'en ti' tol chi oc ch'en yin panil, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jix yalon Jesús tet naj diablo tu' jaxca ti': —Ja' yul An Juun Tz'ibebil can oj, chi alon jaxca ti': “Man asanne oj yu lo'be yuxan tol iquis jon. Pero chi cu iquisbi pax ec' yu sk'ane Dios,” quey tu' yalon yul An Juun, ẍi Jesús tet naj diablo. ");
INSERT INTO knjNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jix lawi jun tu' xin, catu' jix i'letoj naj Jesús yu naj diablo bey jun conob asan Dios ey yet, ja' ton conob Jerusalén. Catu' jix i'le atoj yu bey ẍumuc templo. ");
INSERT INTO knjNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jix yalon naj diablo tet naj jaxca ti': —Ilala, ta tol Sc'aal jaach Dios, k'oj eytoj ja ba sat tx'otx' tu', yutol chi yal can yul An Juun Tz'ibebil can jaxca ti': Oj ẍejtej eb yángel Dios yu ja teynelei. Catu' oj jaach yi' a eb yetoj sk'ab, yet watx' man oj yasitoj ja wajan yin ch'en, ẍi yul An Juun tu', ẍi naj diablo tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jix yalon pax Jesús tu' jaxca ti': —Pero chi yal pax yul An Juun Tz'ibebil can tu' jaxca ti': “Manchej ja wak'le ja wijban ja Diosal Kaawil yin spenail,” ẍi yul An Juun tu', ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Catu' jix i'letoj Jesús yu naj bey jun miman wonan. Catu' jix c'oli x'oxle masanil wan mimej conoblaj yul yiban k'inal ti' yu naj, c'al tzettaj mimej yel oc apnoj bey jun jun conob tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jix lawi tu' xin, catu' jix yalon naj diablo tet naj jaxca ti': —Masanil wan chin tx'oxtoj e ach ti', oj wak' e ach, ta chach ey kaan e in an, catu' cha walon ja ba e in an, ẍi naj diablo tu' tet naj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Catu' jix yalon naj Jesús tu' tet naj jaxca ti': —Jaach Satanás, elan jin c'atan an. Yutol chi yal yul An Juun Tz'ibebil can jaxca ti': “Chex ey kaan sattaj Dios Kaawil. Asan Dios che yak' servil,” ẍi yul An Juun, ẍi Jesús tet naj diablo. ");
INSERT INTO knjNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jaxa yet tu' jix el naj sc'atan Jesús tu', jix toi, catu' jix jul eb ángel, jix jul ak'le servil naj yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ja' yet jix yaben naj Jesús tol ey oc naj Juan yul preso, catu' jix to naj bey Galilea. ");
INSERT INTO knjNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero ma ey ec' bey Nazaret, pero ja' bey Capernaum jix ey eyi. Ja' jun conob tu' ja' sti' ja' mar ey. Bey yul-laj tx'otx' yet Zabulón c'al tx'otx' yet Neftalí, ja' tu' ey. ");
INSERT INTO knjNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jaxca ton ti' jix yune', yu yunen el tzet jix yal naj ẍejab Dios chi yij Isaías yet peyxa, tol chi yal jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ja' sti' ja' mar ey tx'otx' yet Zabulón c'al tx'otx' yet Neftalí, bey sk'axepal ec' ja' miman Jordán. Ja' bey titu' ey jun lugar chi yij Galilea, bey ey ec' ec'al eb man Israel oj. ");
INSERT INTO knjNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ja' eb ánima tu', k'ej k'inal to ey spixan eb. Pero oj yil jun saj k'inal eb tol miman yel oc apnoj. Ja' eb ey bey jun lugar tu', jaxca tol camnaj el spixan eb. Pero oj jul saj k'inal bey spixan eb tu', ẍi yul An Juun Tz'ibebil can oj. ");
INSERT INTO knjNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ja' yet jix apni Jesús bey jun lugar tu' xin, catu' jix c'oli yalon el sk'ane Dios tet eb ánima, jix yalon tet eb jaxca ti': —Na' wej je ba yin je penail, yutol ja' naj Yaaw bey satcan, Tuxa chi oc can yin Yaawil titi', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ja' yet jun c'u, yet lalan yec' naj Jesús bey sti' ja' mar Galilea, jix yilon yin naj Simón naj, naj chi yij Pedro, yetoj jun yuẍtaj chi yij Andrés. Lalan smitx'wi pescado eb titu', yutol mitx'om pescado eb. ");
INSERT INTO knjNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Catu' jix yalon Jesús tu' tet eb jaxca ti': —Ocan nej tzajan wintaj an, cuywan nej, oj wak' je yopiso. Jaxca che yute je mitx'on no' pescado ti', quey tu' oj je yute je yi'ontej eb ánima e in an, ẍi naj Jesús tu' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jix sbej xa c'al can xim eb tu' yet jun txolan tu'. Catu' jix oc tzajan eb yintaj Jesús yu scuywi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jix beytoj eb janic' xa, catu' jix yilon yin cawan xa yuẍtaj pax sba, ja' ton naj Jacobo, yetoj naj Juan, eb sc'aal naj Zebedeo. Ey oc eb yul sbarco yetoj smam. Lalan snipen xim eb, yet jix awtele eb yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yet xa c'al jun txolan tu', jix sbej can sbarco eb c'al smam eb tu', catu' jix oc tzajan eb yintaj naj Jesús, jix oc eb yin scuywom oj naj. ");
INSERT INTO knjNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jix ec' eb yetoj Jesús bey masanil yul-laj yet Galilea tu'. Jix ec' naj cuywa yul-laj snail bey chi syamba sba eb Israel yin culto. Catu' jix yalon can el watx' k'ane, tzet utbil chi yun yoc Dios Yaawil oj eb. Catu' jix yak'on can wa'xoj sc'ul masanil mac txequel ya' ey yu yal c'al tzet ya'ilal. ");
INSERT INTO knjNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Masanil eb ánima yul yet Siria jix yab sk'umal Jesús eb, yuxan jix yi'tej eb sya' ey eb. Yal c'al tzet ya'ilal ey oc yin eb jix yi'tej eb sc'atan naj Jesús, yetoj eb ey oc pena espíritu yin, yetoj eb cha'bil oybinaj sat yu, c'al eb sicbinaj el smimanil, jix i'letej masanil eb sc'atan Jesús, catu' jix wa'xi can sc'ul masanil eb yu naj. ");
INSERT INTO knjNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ec'al eb ánima a Galilea tu', jix tzajlo yintaj naj, c'al eb a Decápolis, c'al eb a Jerusalén, c'al eb a Judea, yetoj eb a sk'axepaltoj ja' Jordán. ");
INSERT INTO knjNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ja' yet jix yilon jun miman bulan ánima naj Jesús, catu' jix atoj bey jun wonan. Catu' jix ey chotan naj titu'. Jix oc joyan eb scuywom naj yinlaj. ");
INSERT INTO knjNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Catu' jix c'oli scuywa tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ja' eb chi yotajne el sba tol man watx' oj eb sattaj Dios, caw watx' yet eb, yutol ey xa oc Yaawil satcan Yaawil oj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ja' eb chi cus sc'ul yu spenail, caw watx' yet eb, yutol oj miman c'ulnele eb yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ja' eb suc chi yute sba, caw watx' yet eb, yutol oj yi' eb jun yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ja' eb chi yoche chi wa'xi oc sbeybal yin masanil sc'ul, caw watx' yet eb, yutol oj oc Dios yetoj eb yin swa'xi oc eb. ");
INSERT INTO knjNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ja' eb chi ok' sc'ul yin yet animail, caw watx' yet eb, yutol oj ok' pax sc'ul Dios yin eb. ");
INSERT INTO knjNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ja' eb c'am chi ẍa' apnoj nioj spenail bey spixan, caw watx' yet eb, yutol oj ey ec' eb yetoj Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ja' eb ak'om tan jowal, caw watx' yet eb, yutol oj al-le eb yuninal oj Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ja' eb chi yil sya'ilal, yu c'al tol watx' sbeybal eb, caw watx' yet eb, yutol oj oc Yaaw a satcan, Yaawil oj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ja' jaex xin, ta jin ya'il oj yuxan chex buchlei, ta jin ya'il oj chex etnelei, catu' chi na'le a k'ane je yin, caw watx' je yet. ");
INSERT INTO knjNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tzalan nej sic'lebil, yutol caw miman watx'ilal oj je cha' spaj oj bey satcan. Jaxca chi yun je yilon sya'ilal ti', quey tu' jix yun yilon sya'ilal eb ẍejab Dios yet peyxa. ");
INSERT INTO knjNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jaxca chi yun atz'am yin cu lo'be, quey tu' che yun yul yiban k'inal ti'. K'inaloj ta chi q'uey sc'a'chi'al nioj atz'am, ¿tzet to wal oj yun sc'a'chi'bi junel xa? C'am xa yopiso. Tuxa c'al chi k'ojle el oj, catu' chi tec'letoj yu ánima. ");
INSERT INTO knjNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jaxca junoj tzejtebal, quey jex tu' bey yul yiban k'inal ti'. K'inaloj ta ey junoj conob sjolom junoj wonan, caw miman txequel sic'lebil, c'am chi ske' smajchelei. ");
INSERT INTO knjNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ja' yet chi cu tzejon cu tzejtebal, tumi ja' yalan junoj can te' chi ka octoj, c'amaj, ja' yiban junoj tzet yetal batxan a oj. Ja' tu' chi katoj, yet watx' chi tzejtenele masanil eb ey ec' yul na yu. ");
INSERT INTO knjNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jaxca junoj tzejtebal tu', quey jex ojab tu' xin, txeclo ojab el je saj k'inal sattaj ánima. Chi yal yel oc apnoj, je watx' beybal, yet watx' chi yal watx' k'ane eb yin cu Mam Dios ey ec' bey satcan. ");
INSERT INTO knjNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Manchej je na' tol yu wak'on lawoj sley Moisés c'al wan cuybanile jix yak' eb ẍejab Dios yet peyxa, yuxan jix jin jul an. C'amaj, pero jix jin jul an, yu jin tx'oxon tzet yel oc apnoj masanil wan tu', yuxan jix jin jul an. ");
INSERT INTO knjNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Caw yel chi wal e ex, tol sowalil oj yun masanil tzet yetal tz'ibebil can yul An Ley tu'. Yet ey to c'al ec' yul yiban k'inal ti' c'al satcan, c'am junoj tzet yetal yul An Juun Tz'ibebil can tu' tol man oj yune'. C'am junoj letra, c'am junoj punto, tol oj ec' tzet chi yala, masanta' c'al oj yun masanil tzet tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ja' mac txequel tol c'am chi sjije wan ley tu', cax c'al junoj chejbanil yul an ley tol caw yeynajil ey yel oc apnoj, catu' chi cuywa pax tet ánima yet watx' c'am chi sjije pax eb. Ja' ton jun mac txequel tu', yel xa c'al yeynajil ey yel oc apnoj xol eb ey oc Dios Yaawil oj. Jal eb chi jijen masanil tzet chi yal ley tu' xin, catu' chi cuywa pax tet eb ánima yet watx' chi sjijen pax eb, ja' ton eb tu' miman yel oc apnoj xol eb ey oc Dios Yaawil oj. ");
INSERT INTO knjNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yuxan chi wal e ex, tol sowalil watx' che yute je beybal yintaj sbeybal eb cuywam yin sley Moisés c'al eb fariseo. Ta c'amaj ma c'al ta ske' yoc Dios je Yaawil oj. ");
INSERT INTO knjNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ey bey jix kab tzet albil can tet eb kichmam yet peyxa. Tol chi yal jaxca ti': “Manchej je mak' cam je yet animail. Yal c'al mac txequel chi smak' cam junoj yet animail, sowalil chi i'letoj sattaj ley, catu' chi na'le oc yin,” ẍi ley tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero jain, chi wal e ex an, tol yal c'al mac txequel chi chichon oc sc'ul yin junoj yet animail, sowalil oj na'le oc yin. Yal c'al mac txequel chi buchon junoj yet animail, oj na'le oc yin eb yu eb sat yaaw. Yal c'al mac txequel chi bawa yin junoj yet animail, ey smey chi to can bey infierno, bey xol k'ak'. ");
INSERT INTO knjNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yuxan, ta lalan je to je yak'on je sa'beal tet Dios yet che yak' tz'a' oj, catu' chi tit yul je c'ul tol ey junoj mac txequel bey jix oc je mul, ");
INSERT INTO knjNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","batxba wej can ey je sa'beal tu' yich yajantaj bey chi tz'a'toj tu', catu' chi to je wa'nen ye jun je cus c'ulal tu' yetoj jun mac txequel tu'. Chi lawi jun tu' xin, chex juli, catu' che yak'on je sa'beal tu' tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","K'inaloj ta ey junoj mac txequel chex awten sattaj naj yaaw yu junoj k'ane, ak' wej je yip je wa'nen jun k'ane tu' yul-laj be yetoj, catu' c'am chex i'letoj sattaj naj alcal yu. Yutol ta chex apni sattaj naj alcal tu', ja' naj alcal tu' chex aon oc yul sk'ab eb policía, catu' chex yi'ontoj eb preso. ");
INSERT INTO knjNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Caw yel chi wal e ex, ma jex jajle el oj masanta' c'al tz'ajan che yak' can masanil je multa. ");
INSERT INTO knjNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ey bey jix kab tzet albil can yul sley Dios, bey chi yal jaxca ti': “Manchej je oc je mul yul sk'ab je yichamil c'al yul sk'ab je yistil,” ẍi yul sley Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero, jain, chi wal e ex, yal c'al mac winajil chi ilon oc junoj ix ix yu yochen oc oj, jix oc smul yul sc'ul yetoj ix. ");
INSERT INTO knjNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","K'inaloj jaex, ta chex ak'le ey q'uey yu sbak' je sat bey je watx', catu' chi etex el je na'bal yu, yel xa c'al watx' tol che yi' eltej jun sbak' je sat tu', catu' che k'ojon el oj. Yutol yel watx' ta ja' junoj tujanil je mimanil chi q'uey el oj, yintaj pax tol masanil je mimanil chi k'ojletoj bey infierno. ");
INSERT INTO knjNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","K'inaloj ta jaex, ja' je watx' k'ab chex ak'on ey q'uey oj, catu' chi etex el je na'bal yu, yel xa c'al watx' tol che tzoc' el jun je watx' k'ab tu', catu' che k'ojon el oj. Yutol yel watx' je yet ta junoj tujan je mimanil chi q'uey el oj, yintaj pax tol masanil je mimanil chi k'ojletoj bey infierno. Chi yal yel oc apnoj tol ta ey junoj tzet yetal chi cu ijban yin spenail, yel watx' chi kun bey c'al tet sowalil yet c'am chi cu to yin spenail. ");
INSERT INTO knjNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Albil pax can jun xa ti' yet peyxa tu': “Ja' mac chi spo'le sba yetoj yistil, sowalil chi swa'ne an yuunal po'lebail naj, catu' chi yak'on can an naj tet ix, ẍi.” ");
INSERT INTO knjNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero jain chi wal e ex, ta ey junoj mac txequel chi spo'le sba yetoj yistil, pero c'am pax smul ix ix tu' chi yaoc yul sk'ab yichamil tu', tol ja' naj chi aontoj ix yin mulal bian. Yetoj pax oj, ta ey junoj mac txequel chi i'on ix jix spo'le sba yetoj yichamil tu', mul chi yun naj. ");
INSERT INTO knjNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ey bey jix kab tzet jix al-le can tet eb kichmam yet peyxa, yet jix yal jaxca ti': “Ta che loctej sbi naj Kaawil yet che yak'on je ti' yin junoj tzet yetal, sowalil che yak' yun tzet che yal tu'” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero, jain chi wal e ex, c'am ojab bak'in che loctej junoj yal c'al tzet bieal. Ma ske' je locontej sbi satcan, yutol ja' titu', chotan ey Dios yak'on Yaawil, yutol sdespacho yei. ");
INSERT INTO knjNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yetoj pax sat tx'otx' ti', ma ske' je locban sbi, yutol jaxca tol sbatxlub yajan Dios yei. Yetoj pax conob Jerusalén, ma ske' je locban sbi, yutol sconob naj Rey miman yel oc apnoj. ");
INSERT INTO knjNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yetoj pax je jolom, c'am chi ske' che loctej, yutol man je yetoj yul je yet. Ila tol c'am chi ske' je yu je yak'on sajboj ma je yak'on k'ejboj junoj xil je ya'. ");
INSERT INTO knjNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ja' yet chex k'anab xin, “ye,” je chi. “C'amaj,” je chi. Ma ske' je locontej yal c'al tzet bieal, yutol ja' bey naj diablo chi tit wan tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ey bey jix kab tzet albil can yet peyxa, yet chi yal jaxca ti': “Ta ey mac chi smak' po' sbak'sat yet animail, mak'le ojab pax po' yet jun tu'. Ta ey mac chi mak'on eltej ye yet animail, mak'le ojab pax eltej yet jun tu',” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero jain, chi wal e ex an, Manchej je pajtze pena c'ulal tet je yet animail. Ja' ti' je yet, ta ey mac chi mak'ontoj jun pac' oj je ti', che jacbatoj jun pac' xa tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ta ey mac chi yoche chi tok'on ec' je camiẍ sattaj ley, jaj wej pax can toj pax je chumpa. ");
INSERT INTO knjNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yetoj pax oj, ta ey mac txequel chex tenon oc yalan yijatz yu sto je yak'on yul-laj be nan oj legua, asi', ak' wej can junoj legua tet. ");
INSERT INTO knjNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yal c'al mac txequel chi k'anon smaane junoj tzet yetal e ex, ak' wej tet, manchej je baasne. ");
INSERT INTO knjNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ey bey jix kab tzet albil can yet peyxa, tol chi yal jaxca ti': “Ja' eb watx' je yak'on yetoj, cam c'ulne wej eb. Jal eb pena je yak'on yetoj xin, chichon ojab oc je c'ul yin eb,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero jain chi wal e ex an, sowalil che cam c'ulne eb ac'ul oc je yin. Ja' eb chi sk'anontej sjowal sc'ul Dios je yiban, ja' ojab swatx' c'ulal Dios tu' che k'antej yiban eb. Ak' wej watx' c'ulal tet eb ac'ul oc je yin. Txalan nej yu eb chex buchoni, c'al eb chex etneni. ");
INSERT INTO knjNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jaxca ton ti' oj je yute je tx'oxon el oj tol yuninal jex cu Mam ey ec' bey satcan. Yutol ja' cu Mam tu', chi yak' aol c'u yiban eb pena c'al eb watx'. Yetoj pax oj, chi ey nab yiban eb pena sna'bal, yetoj pax yiban eb watx' sna'bal. ");
INSERT INTO knjNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ta asan ch'an eb chex c'am c'ulneni oj je cam c'ulne pax oj, ¿tumi ta oj je cha' spaj jun je cam c'ulal tu' che na'? Tol ja' eb tejom el tolabal quey ton tu' chi yun pax eb. ");
INSERT INTO knjNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yetoj pax oj, ta asanne yetoj eb je watx'il ánima bey watx' je k'anabi. ¿Ta watx' jaxca tu' che na'? Tol ja' eb man to otajnen oj Dios, quey pax tu' sbeybal eb. ");
INSERT INTO knjNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tz'ajaji ojab che yun yin masanil tzet yetal watx' xin, jaxca cu Mam ey ec' bey satcan, tz'ajan yin smasanil tzet yetal watx'. ");
INSERT INTO knjNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Che yil c'al je ba. Man ojab asanne oj sattaj eb ánima, watx' che yute je ba. Ta asanne sattaj eb, watx' che yute je ba, c'am nioj spaj oj je cha' tet cu Mam ey ec' bey satcan. ");
INSERT INTO knjNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yuxan, ja' yet che yak'on nioj je sa'beal tet junoj meba', manchej je yal el xol ánima jaxca chi yute sba eb caab sat. Yutol ja' eb tu', chi x'ox xa c'al el eb yul-laj snail yambabail yin culto, c'al yul-laj calle, yet watx' chi al-le eb watx'il yu ánima. Caw yel chi wal e ex, ja' wan watx' k'ane chi al-le yin eb tu', chi oc spajtzebal oj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Jal jaex xin, ja' ojab yet che yak'on nioj tzet yetal tet eb meba', ma ske' je yalon tet ánima. Cax c'al tet mac yel xa c'al watx' je yak'on yetoj, manchej je yal tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ak' wej je sa'beal tu' yin ewantajil. Cax c'al yin ewantajil che yak'a, pero chi yil cu Mam Dios, catu' oj spajtzen e ex. ");
INSERT INTO knjNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ja' yet chex txali, manchej je yute je ba jaxca eb caab sat. Yutol, ja' eb caab sat tu', caw chi ẍa' sc'ul eb xali yul-laj snail yambabail yin culto, c'al bey chi syamba sba eb ánima, yet watx' chi al-le eb watx'il yu eb ánima. Caw yel chi wal e ex, ja' ton wan watx' k'ane chi al-le yin eb tu', chi oc spajtzebal oj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Jal jex jaexti' xin, ja' yet chex txali, ocan nej toj yul je na je txojli. Che majchen je puerta, catu' chex txali tet cu Mam Dios, Ja' ey ec' je yetoj, cax c'al c'am che yil yin. Cax c'al c'am mac chi ilon je txali, oj yab c'al ta' Dios catu' oj pajtzele je txa tu' yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ja' yet chex txali tu', man ojab ja'c'ala' c'al oj tzet che yala, jaxca eb man to otajnen oj Dios. Yutol ja' eb tu', ja' sna'on eb tol yu miman chi yute yajan xa eb, yuxan oj able eb yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yuxan, manchej je yute je ba jaxca eb tu' xin. Yutol yotaj xa cu Mam Dios tzet caw sowalil chi oc je yu, yet c'am to che k'an tet. ");
INSERT INTO knjNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yuxan, quey tu' che yute txaloj je ba jaxca ti': Mamin, ey jaach ec' bey satcan. Miman ojab yel oc apnoj ja bi. ");
INSERT INTO knjNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Titan ja wak' Yaawilal titi'. Jaxca ojab yunen tzet cha woche bey satcan tu', quey ojab tu' yunen sat tx'otx' ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ak' cu lo'be oj cu lo' yet jun jun c'u on. ");
INSERT INTO knjNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ak' miman c'ulal kiban yu cu penail, jaxca chi kute kak'on miman c'ulal yiban eb ey tzet chi cu uteni. ");
INSERT INTO knjNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Manchej jon ja cha' ijbaletoj yin spenail. Catu' chon ja colon pax el yul sk'ab jun yaawil spenail. Yutol asan jaach Yaaw jaach tobal k'inal. Catu' miman ja wopiso, catu' miman pax ja wel oc apnoj. Amén. ");
INSERT INTO knjNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ta che yak' miman c'ulal yin eb ey tzet chex uten jaexti', oj ak'le pax miman c'ulal yin je penail yu cu Mam Dios ey ec' bey satcan. ");
INSERT INTO knjNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero ta c'am che yak' miman c'ulal yin eb ey tzet chex uten tu' xin, ma yak' pax miman c'ulal cu Mam Dios yin je penail. ");
INSERT INTO knjNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ja' yet che yijle nocha je ba, manchej je yute je ba jaxca eb caab sat. Yutol ja' eb tu', cusiltaj xa c'al chi yute sat eb, yet watx' chi txeclo el sattaj ánima tol lalan yijle nocha sba eb. Caw yel chi wal e ex, tol ja' ton yu chi il-le eb yu eb ánima tu', ja' ton chi oc spajtzebal oj tet eb, catu' c'am xa spajtzebal eb oj ẍa' tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero jaexti' xin, ja' yet che yijle nocha je ba, tzala c'ulal yoc je sat, c'al sak'al che yute je mimanil, ");
INSERT INTO knjNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","yet watx' c'am chi na'cha el yu ánima ta jex lalan je yijle nocha je ba. Jaxca tu' xin, asan cu Mam Dios otajneni tol lalan je yijlen nocha je ba. Oj pajtzele e ex yu Dios yu che yun jaxca tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Manchej je yamba je be'omal yul yiban k'inal ti', yutol chi ibitoj, chi k'uxbitoj, ma chi to yu elk'om. ");
INSERT INTO knjNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yel watx' ja' bey satcan che yamba je be'omal. Ja' bey satcan tu', c'am chi oc yial, c'am chi k'uxbitoj, c'am xa pax elk'om chi elk'anentoj. ");
INSERT INTO knjNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yutol ja' bey chi cu yamba cu be'omal, ja' tu' chi ka pax toj cu na'bal. ");
INSERT INTO knjNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ja' sbak' cu sat jaxca tol sejtebal cu mimanil yei. Yuxan, ta watx' tzet bey ey oc cu sat, saj k'inal jon toni, catu' watx' c'al tzet chi el kunen yetoj cu mimanil. ");
INSERT INTO knjNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero ta jaex, pena bey che yaoc je sat, chex can xol k'ej k'inal yu. Ta c'am je saj k'inal xin, oj jex can xa c'al can xol jun miman k'ej k'inal. ");
INSERT INTO knjNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","C'am junoj mac txequel chi ske' jun laan c'al yak'on servil cawan oj spatrón. Yutol ja' naj chi scajle sba yetoj junoj, catu' chi scam c'ulne sba pax yetoj junoj xa. Ey junoj chi sjije naj tzet chi yala, catu' junoj xa c'am yel oc apnoj yul sat naj. Yuxan c'am chi ske' jun laan je cam c'ulnen je yak'on servil Dios c'al je cam c'ulnen ch'en tumin. ");
INSERT INTO knjNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yuxan chi wal e ex, tol manchej jex oc il yu je cawil titi', yu je lo'be, c'al yu je pichil. Ta chi yak' Dios cu cawil, ¿tumi ja' to wal cu lo'be man oj yak'a? Ta jix yak' Dios cu mimanil, ¿tumi ja' to wal cu pichil man oj yak'a? ");
INSERT INTO knjNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ila no' tz'iquin chi ec' jenenoj satcan. C'am yawo no'. C'am sjatx'o no'. Toj ey tzet chi yamba can no'. Pero ja' cu Mam Dios ey bey satcan chi ak'on slo'be no'. Il tax chi yak' slo'be no' tz'quin tu', oj yak' pax e ex tol yel xa c'al miman je yel oc apnoj yintaj no' yul sat Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Ma ey junoj jex chi ske' je yaon oc junoj xa c'u yak'il je k'inal yu che yak' bis c'ulal yin? ");
INSERT INTO knjNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yetoj pax oj, ¿tzet yuxan chex oc bis c'ulal yu je pichil? Na'tej yin an xumac cultaj tinani'. Ja' an xumac te' tu', c'am chi mulna an, c'am chi ske' x'alwi an. ");
INSERT INTO knjNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero chi wal e ex, cax c'al caw sak'al yili spichil naj rey Salomón jix yaoc oj, pero ma c'al ta' apnoj yili jaxca an xumac te' tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Caw sak'al yili an xumac te' tu' yu Dios. Tol watx' yili an tinani', jaxa yecal xin, chi taj el oj, catu' ja' yet tajnaj xa el oj, catu' chi tz'a'i. ¿Tumi man oj jex pichle yu Dios? Jaex c'am che yaoc Dios yin je c'ul. ");
INSERT INTO knjNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yuxan, manchej jex oc bis c'ulal yu bey chi tit je lo'be c'al yu tzet che yuq'ue, yetoj pax yu je pichil. ");
INSERT INTO knjNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ja' eb man otanen oj Dios, caw chi yak' bis c'ulal eb seyon ec' wan tzet yetal tu'. Jal jon pax xin, ja' cu Mam Dios ey bey satcan yotaj xa tol caw chi oc yopiso wan ti' ku. ");
INSERT INTO knjNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yuxan ak' wej je yip je yaon oc je ba yul sk'ab cu Mam Dios sic'lebil. Catu' watx' c'al che yute je beybal jaxca chi yoche sc'ul. Ta oj je yun jaxca chi wal ti', oj yak' masanil wan tzet yetal ti' e ex. ");
INSERT INTO knjNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yuxan, manchej jex oc bis c'ulal yu tzet e ex yecal, yutol man je yotaj oj tzet i'bil oc yu jun c'u yet yecal tu', yuxan ma ske' je yoc bis c'ulal yu. K'ojbil c'al chi na'otene yin tzettaj yetal i'bil oc yu jun jun c'u. ");
INSERT INTO knjNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Manchej je na' oc yin wanoj xa mac txequel, yet watx' c'am chi sna' oc Dios je yin. ");
INSERT INTO knjNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yutol ta che na' oc yin junoj xa mac txequel, jaxca che yute je na'on oc yin tu', quey tu' oj yun sna'on oc Dios je yin. Yuxan ja' je yechbal che yak'balne, ja' oj ak'balnele pax e ex. ");
INSERT INTO knjNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","K'inaloj ta junoj ja wet animail chi to sc'ail te' yul sat. Cha woche cha wi' eltej jun sc'ail te' tu', pero k'inaloj ey pax junoj patzab ey octoj yul ja sat. Ta c'am cha wiltej tol ey te' ey octoj yul ja sat, ¿tumi ja' jun sc'ail te' ey octoj yul sat ja wet animail tu' oj ske' ja wi'on eltej? ");
INSERT INTO knjNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ta ey junoj te' patzab ey octoj yul ja sat xin, toj oj ske' ja walon tet ja wet animail jaxca ti': “Kil to wal, ki' eltej jun sc'ail te' ey octoj yul ja sat tu',” toj ja chi. ");
INSERT INTO knjNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Pero ta tol quey tu' cha wute ja waloni, caab sat jaach. I' wej eltej jun te' patzab ey octoj yul ja sat tu' babel, Ja' yet tu' bian, oj ske' ja wiloni, catu' oj ja wi'on eltej jun sc'ail te' yul sat ja wet animail tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ja' wan cuybanile yet Dios, laan jaxca jun tujan ch'en, perla sbi. Caw ey stool. Yuxan ma ske' kak'on tet eb tol c'am nioj yel oc apnoj Dios yul sat, yutol laan eb jaxca no' tx'i' ixa sjowal tool c'al stit kin. Ey eb xin, laan jaxca no' txitam, tol tu' c'al chi stec'toj wan tzet yetal xaan tu' ta chi ale tet. Yutol asan yin tzet chi slo' tu' ey yel oc apnoj yul sat no': ");
INSERT INTO knjNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","K'an wej, oj yak' Dios e ex. Sey wej, catu' oj ilcha je yu. Awan nej octoj sti' puerta, catu' oj jajle e ex. ");
INSERT INTO knjNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yutol yal c'al mac txequel chi k'anoni, chi ẍa'. Ja' mac chi seyon ec' oj, chi ilcha yu. Ja' mac chi awi octoj sti' puerta, chi jajle tet. ");
INSERT INTO knjNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ja' jaex mame jex ti', ta chi sk'an je c'aal junoj lo'be e ex, ¿tumi ja' junoj ch'en che yak' tet? ");
INSERT INTO knjNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma xin, ta ja' junoj pescado chi sk'an e ex, ¿tumi ja' junoj laba che yak' tet? ");
INSERT INTO knjNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ja' jaexti', cax c'al c'am je watx'il, pero je yotaj che yak' tzet yetal watx' tet eb je yuninal. Yel c'al chi yak' pax cu Mam ey ec' bey satcan. Oj yak' tzet yetal watx' tet eb chi k'anon tet. ");
INSERT INTO knjNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Che yoche tol watx' chi yute sba eb je yet animail e ex, yuxan, watx' ojab che yute pax je ba tet eb. Yutol quey tu' jix yun chejle kunen yu sley Moisés tz'ibebil can oj, c'al tzet tz'ibebil can yu eb ẍejab Dios yet peyxa tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ja' yul jun yali' sat puerta chex oqui. Yutol ey jun xa puerta miman sat, catu' miman pax sat sbeal, pero ja' bey sya'tajilal chi apni jun be tu', catu' ec'al eb ánima chi to yul. ");
INSERT INTO knjNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Jal pax jun yali' sat puerta tu' xin, txene pax sat sbeal, catu' c'am tx'ial ánima chi to yul, pero ja' jun be tu' chi apni bey k'inale. ");
INSERT INTO knjNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Che yil c'al je ba tet eb chi yal oc sba ẍejab oj Dios, yutol ja' yet oj jul eb je c'atan, suc c'al oj yute sba eb jaxca no' me', pero tol pena tzet chi sna' oc eb je yin, jaxca junoj no' oj caw tx'i'taj. ");
INSERT INTO knjNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Oj je yotajne el eb sic'lebil yu tzet yetal chi el yunen eb, jaxca kotajnen el junoj te' te' yu sat. K'inaloj junoj te' q'uix tinani', man mansan oj sat chi yak'a. K'inaloj pax junoj ste'al tulus tinani', man tzoyol oj sat chi yak'a. ");
INSERT INTO knjNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Masanil te' te' watx', watx' c'al sat te' chi yak'a. Ja' masanil te' te' pena, pena c'al sat te' chi yak'a. ");
INSERT INTO knjNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ja' te' te' watx', ma ske' tol pena sat te' chi yak'a. Ja'c'ala' te' te' pena, ma ske' tol watx' sat te' chi yak'a. ");
INSERT INTO knjNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","Yuxan, ja' eb chi yal oc sba ẍejab oj Dios tu', oj je yotajne el eb sic'lebil yu sbeybal eb tu', c'al yu tzettaj yetal chi el yunen eb. Masanil te' te' tol man watx' oj sat chi yak'a, chi k'ajle a te' catu' chi k'ojletoj te' xol k'ak' yu chi tz'a'toj, quey ton tu' oj utele eb man watx' oj sbeybal. ");
INSERT INTO knjNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Man masanil oj eb chi yal e in an jaxca ti': “Mamin, Waawil jaach an,” ẍi eb e in an, oj oc yul sk'ab Yaaw a satcan. Asanne eb chi jijen yochwan cu Mam ey ec' satcan, asanne eb tu' oj oc oj. ");
INSERT INTO knjNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ja' yet oj jul jun c'ual tu', ec'al eb oj alon e in jaxca ti': “Mamin, Waawil jaach an, caw jix cu ec' kalon el ja k'ane, yetoj ja wip jix ki'on el pena espíritu yin eb ánima. Yetoj pax ja wip, ec'al milagro jix el kuneni,” oj yalon eb e in an. ");
INSERT INTO knjNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero oj jin tak'woj tet eb jaxca ti': “C'am c'al bey jix jex wotajne el junel oj an. Elan nej c'al jin c'atan an, yutol asanne c'al spenail jix el je yuneni,” jin chi, oj jin tak'woj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yal c'al mac txequel chi aben jin k'ane, catu' chi sjijeni, laan eb jaxca jun winaj jelan. Ja' jun winaj tu', ja' yiban ch'en jix swa'ne sna. ");
INSERT INTO knjNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jix jul jun miman yax nab, catu' jix ec' elom ja' yinlaj sna, catu' jix jul pax jun miman ka'e', catu' jix low yin jun na tu'. Pero ma telc'o oj yutol caw watx' ye xe' yiban ch'en tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jal eb chi aben jin k'ane, pero c'am chi sjije pax eb, laan eb jaxca jun winaj suc sna'bal. Ja' jun winaj tu', ja' yiban c'uun tx'otx' jix swa'ne sna. ");
INSERT INTO knjNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Jix jul jun miman yax nab, catu' jix ec' elom ja' yinlaj na, catu' jix jul pax jun miman ka'e', catu' jix low yin jun na tu', Jix telc'otoj tu', jix etex xa c'al to oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ja' yet jix lawi sk'anab naj Jesús tet eb ánima tu' xin, tuxa c'al chi q'uey can a sc'ul eb yu wan cuybanile ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yutol ja' yet lalan sk'anab naj xol eb tu', jix txeclo el oj tol ey ton yopiso naj yu Dios. Man laan oj scuybanil naj jaxca eb cuywam yin sley Moisés. ");
INSERT INTO knjNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ja' yet jix pax eytej Jesús bey jun wonan tu' xin, ec'al eb ánima jix tzajlo yintaj naj. ");
INSERT INTO knjNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ey jun winaj caw ya' ey sic'lebil yu jun ya'bil chi yij lepra, jun chi k'a'toj ánima yu. Ja' jun winaj tu', jix apni sc'atan Jesús, catu' jix ey kaan sattaj naj, catu' jix yalon jaxca ti': —Mamin, ta chi yal ja c'ul, chi ske' ja wak'on can wa'xoj jin c'ul an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Catu' jix sbatxban oc sk'ab naj Jesús yiban naj, catu' jix yalon jaxca ti': —Chi yal jin c'ul. Tol chi wak' can wa'xoj ja c'ul, ẍi Jesús tet naj. Yet xa c'al jun txolan tu' jix wa'xi can sc'ul naj yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Catu' jix yalon Jesús tet naj jaxca ti': —Manchej ja wal tet ánima. Asi' tx'ox ja ba tet junoj naj yak'omal xaambal tet Dios. Catu' cha wak'on can ja xaambal tu' tet Dios jaxca yalon sley Moisés yet watx' chi il-le yu conob tol jix wa'xi can ja c'ul, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ja' yet jix apni Jesús bey conob Capernaum, jix apni jun capitán sc'atan naj, catu' jix oc tean yin naj. ");
INSERT INTO knjNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jix yalon naj jaxca ti': —Mamin, ja' jun jin moso ey ec' wetoj bey jin na ti', jix to telan sat tx'at. Sicbinaj el smimanil. Caw chi chiwa yul-laj smimanil chi yabe, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jix yalon Jesús tu' tet naj jaxca ti': —Oj jin toj xin, catu' oj toj wak'on can wa'xoj sc'ul, ẍi Jesús tet naj capitán tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero jix yalon naj capitán tu' tet Jesús jaxca ti': —Mamin, man jin moo oj chach oc yul jin na an. Asanne ojab tol chach k'anab toj titi', catu' oj wa'xoj can sc'ul naj jin moso tu' an. ");
INSERT INTO knjNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wotaj jun ti' an, yutol jainti', ey eb waawil chin chejoni. Ja'c'ala' ey pax eb soldado chin cheja. Ta ey junoj mac chin cheja, chi c'al sjije stoi. Ta ey mac chi wawte, chi c'al sjije sjuli. Yetoj pax oj, ta ey tzet chin chej swa'ne junoj jin moso an, chi c'al sjije swa'neni, ẍi naj capitán tu' tet naj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ja' yet jix yilon Jesús tol caw chi yaoc sc'ul jun naj capitán tu' yin, jix q'uey a sc'ul, yuxan jix yal tet eb tzajan oc yintaj jaxca ti': —Caw yel chi wal e ex an, c'am to junoj wet a Israel jix wil yaon oc sc'ul yin Dios jaxca jun winaj ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chi walon pax e ex, tol ec'al eb oj tit bey masanil yul yiban k'inal ti', catu' oj ey chotan eb low yetoj naj Abraham, yetoj naj Isaac, c'al yetoj naj Jacob bey te' smeẍa naj a satcan. ");
INSERT INTO knjNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ja' eb Israel, smoo yoc eb bey jun lo' tu', pero ey eb oj k'ojle eltoj xol k'ej k'inal yinna, bey oj oc ok'il c'al chi c'uxon ey ye eb yu sya'il, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jix lawi yalon jun tu' xin, catu' jix yalon Jesús tet naj capitán tu' jaxca ti': —Tinani', paxan bey ja na, oj yun c'al ta' tzet jix ja waoc yin ja c'ul, ẍi Jesús tet naj. Jix wa'xi xa c'al sc'ul jun smoso naj capitán tu' yet jun txolan tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jix to naj Jesús bey sna naj Pedro tu'. Ja' titu' jix yiloni, tol telantoj ix sni' naj Pedro tu' yu jun k'ak'al ya'bil. ");
INSERT INTO knjNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Catu' jix oc mitx'an Jesús tu' yin sk'ab ix, ja' yet tu', catu' jix el jun k'ak'al ya'bil tu' yin ix, catu' jix a waan ix, catu' jix c'oli yak'le servil eb yu ix. ");
INSERT INTO knjNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jaxa yet yey c'ualil xin, ec'al eb ey oc pena espíritu yin jix apni sc'atan naj Jesús. Asan ch'an yu jun k'aneal jix el can eb pena espíritu yin eb yu naj Jesús tu'. Ja'c'ala' pax masanil eb ánima ya' ey, jix wa'xi c'al can sc'ul eb masanil yu naj. ");
INSERT INTO knjNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jix c'al yunen wan tzet jix el yunen Jesús ti' xin, yet watx' chi yun el tzet jix yal naj ẍejab Dios chi yij Isaías yet tax peyxa, yet jix yalon naj jaxca ti': “Ja' naj jix i'on el cu ya'ilal kin, catu' jix yak'on jul cu c'ul yin yal c'al tzet ya'ilal chi cu ioni,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ja' yet jix yilon Jesús tol man xa ánima oj jix oc joyan xa c'al yintaj, jix yijban ec'toj eb scuywom bey jun xa sk'axepal ja' mar. ");
INSERT INTO knjNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pero ja' yet c'am to chi ec'toj eb tu', jix apni jun cuywam yin sley Moisés sc'atan naj, catu' jix yalon naj jaxca ti': —Mamin, yal c'al bey oj jaach toj, oj jin toj ja wetoj an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Catu' jix yalon Jesús tet naj jaxca ti': —Ja' no' wax ey sna ch'en no', c'al no' tz'quin, ey sweyub no'. Pero jainti', cax c'al Ak'bil Wopiso yu Dios xol eb ket animail an, c'am nioj jin na bey chin weyi, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jix yal pax jun xa ey oc s'ajil oj eb scuywom tet naj jaxca ti': —Mamin, oj jin ec' c'al cuywoj ja wintaj an. Asan xin, ak' nioj xa jin permiso an, chi woche chin muj can toj jin mam an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Catu' jix yalon Jesús tu' tet naj jaxca ti': —Tzajlan cuywoj wintaj an. Ja' eb camnaj to el yul sat Dios, ja' eb chi ske' smujon can eb yet camnajil tu', ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jix lawi jun tu' xin, catu' jix octoj Jesús yul barco catu' jix oc pax toj eb scuywom yetoj. Catu' jix k'axpon eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Pero yet lalan sbey eb yiban ja' tu', catu' jix jul jun miman ka'e' caw jow. Jix c'oli sbilwi a sat ja', catu' jix to ja' yul te' barco tu'. Jal naj Jesús tu' xin, tol chi wey naj. ");
INSERT INTO knjNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Catu' jix tenle el sweyan naj yu eb scuywom tu', jix yalon eb tet naj jaxca ti': —Mamin, col jon, tol lalan cu pax ey yich ja', ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","—¿Tzet yuxan caw chex xiwi? ¿Tzet yuxan c'am che yaoc je c'ul yin Dios? ẍi naj Jesús tet eb. Jix lawi tu' xin, catu' jix a waan Jesús tu'. Catu' jix stenon oc tucan jun ka'e' tu', c'al ja' mar tu'. Catu' jix sjijen yoc tucan yu, tz'inini xa c'al. ");
INSERT INTO knjNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","—¿Tzet la ye jun winaj ti'? yuxan chi yak' mandar ka'e' yetoj ja' mar, catu' chi sjijen tet, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jix lawi jun tu' xin, jix ec' apnoj eb sk'axepal ja' bey jun lugar chi yij Gadara. Jix apni cawan winaj ey oc pena espíritu yin sc'atan naj Jesús titu'. Speto eb bey camposanto. Yel xa c'al ey smey eb, yuxan c'am mac chi ec' bey jun be tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ja' yet jix yilon yin Jesús eb, catu' jix el yaw eb tu' jix yalon eb tet Jesús jaxca ti': —Jaach Sc'aal Dios, ¿tzet ja walon ja wet kin? ¿Tumi yin ey oj to c'al catu' chach jul yu jon ja waon oc yin sya'tajil? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ja' scawilal eb tu' ey pax ec' jun miman bulan no' txitam lalan slo'on cultaj no'. ");
INSERT INTO knjNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yuxan jix yal eb pena espíritu tu' tet Jesús jaxca ti': —Ta chon ja wujte el yin eb ánima ti', ja' yin no' txitam tu' chon ja wa can oc oj, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Ocan nej yin no' xin, ẍi Jesús tet eb. Yuxan jix el eb yin eb ánima tu', catu' ja' yin no' txitam tu' jix oc can eb. Yuxan eyman jix to no' yu eb. Jix sk'ojon el sba no' masanil sat pac'an masanta' c'al jix ey apnoj no' xol ja' mar. Catu' jix jik'wi eytoj masanil no' xol ja' tu', catu' jix cam no'. ");
INSERT INTO knjNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jal eb yilomal no' txitam tu' xin, caw jix xiw a eb. Yuxan jix to eb yin eymanil bey conob yu sto yalon eb tzet jix yun no' txitam tu' c'al yu eb jix el can pena espíritu tu' yin. ");
INSERT INTO knjNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yuxan, masanil conob jix eltoj yilon Jesús tu', catu' jix sk'anon eb tet Jesús, tol chi sbos el sba naj yul sconob eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Catu' jix octoj naj Jesús yul jun barco tu', catu' jix k'axpon ec' yiban ja'. Jix ec' apnoj bey jun xa sk'axepal ja' bey ey sconob. ");
INSERT INTO knjNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ey jun winaj sicbinaj el smimanil, Jix i'letej naj sc'atan naj Jesús, batxbil oc yu eb sat sweyub. Jix yilon oc Jesús tu' xin, tol chi yaoc eb yin sc'ul, eb inen oc naj tu' tol oj wa'xoj can sc'ul naj yu Jesús. Yuxan jix yal naj tet naj sicbinaj el tu' jaxca ti': —Jaach wuẍtaj, ak' tzalaboj ja c'ul. Jix ak'le miman c'ulal yin ja penail, ẍi Jesús tet naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ey jaywan eb cuywam yin sley Moisés ey ec' titu' xin, jix sna' eb yul sc'ul yin Jesús jaxca ti': “Ja' jun winaj ti', buchwal k'ane chi yun yin Dios yu tzet jix yal tu',” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jal naj Jesús xin, jix yotajne el tzet chi sna' oc eb yin, yuxan jix yal tet eb jaxca ti': —¿Tzet yuxan pena tzet chi ec' yul je c'ul tu' win an? ");
INSERT INTO knjNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Beytet junoj yel subo yali che na'? Ta cu chi jaxca ti': “Tol jix lawi can ja penail,” ma ja', “aan waan oj, beyan”. ");
INSERT INTO knjNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ja' tinani' xin, oj jin tx'ox je yila, tol ja' jain Ak'bil Wopiso xol eb ket animail yu Dios chi c'al ske' wu wak'on can miman c'ulal yin spenail eb ánima yul yiban k'inal ti' yutol oj wa'xoj can sc'ul naj, ẍi Jesús tet eb. Jix lawi tu' xin, catu' jix yalon tet naj sicbinaj el smimanil tu' jaxca ti': —Aan waan oj, i' a ja weyub, paxan bey ja na, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jix a waan naj tu', catu' jix to naj bey sna. ");
INSERT INTO knjNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ja' yet jix yilon eb yaman ec' titu' tzet jix yun xin, jix xiw a eb. Catu' jix yalon watx' k'ane eb tet Dios yutol miman yopiso jix yak' tet eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jix el Jesús bey jun lugar tu'. Catu' jix yilontoj yin jun winaj chi yij Mateo. Ja' jun winaj ti', chotan ey stejon el tolabal tet eb ánima, catu' jix yalon Jesús tet naj jaxca ti': —Tzajlan cuywoj wintaj an, ẍi Jesús tet naj. Catu' jix to xa c'al naj yetoj Jesús yet jun txolan tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ja' yet jix ey chotan naj Jesús low yetoj eb scuywom bey sna naj Mateo tu', catu' ec'al eb tejom el tolabal c'al eb pena sbeybal jix jul ec' low yetoj Jesús yin meẍa. ");
INSERT INTO knjNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jix c'al yil eb fariseo jaxca tu', catu' jix sk'anlen eb tet eb scuywom Jesús tu' jaxca ti': —¿Tzet yuxan chi low je cuywam ti' yetoj eb tejom el tolabal c'al yetoj eb pena sbeybal? ẍi eb fariseo tu' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jix c'al yab Jesús jaxca tu' xin, catu' jix tak'witoj tet eb, jix yalon jaxca ti': —C'am yopiso junoj anwam yu eb watx' sc'ul, asan eb ya' ey, ja' eb tu' ey yopiso yu. ");
INSERT INTO knjNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Asi' wej, otajne wej el tzet chi yal yel oc apnoj jun k'ane yul An Juun Tz'ibebil can oj bey chi yal jaxca ti': “Chi woche tol chi ok' je c'ul yin je yet animail. Man asanne oj xaambal chi woche,” ẍi yul An Juun tu'. Man yu oj wawten eb watx' sbeybal sna'oni, yuxan jix jin jul an, pero yu wawten eb chi yotajnen el sba tol penawom eb, yet watx' chi sna' sba sc'ul eb yin spenail, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jix apni eb scuywom naj Juan Bautista sc'atan Jesús, catu' jix sk'anlen eb tet naj jaxca ti': —¿Tzet yuxan c'am chi yijle nocha sba eb ja cuywom? Jal jon jaonti' jon, chi kijle nocha cu ba on. Quey pax tu' eb fariseo, chi yijle pax nocha sba eb, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jix tak'wi Jesús tu' tet eb jaxca ti': —K'inaloj ta ey junoj nupil chi oc tinani'. Ja' eb awtebil bey jun nupil tu', ¿tumi oj ske' tol man oj low eb yet ey ec' naj lalan snupi tu' yetoj eb? Ja' yet man xa ey oj ec' naj, ja' yet tu', c'am xa chi low eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","C'am junoj jon chi cu lot' el nioj cu ac' pichil catu' chi kaon oc snipil oj junoj xil pichile. Ta ey bey quey tu' chi kute xin, chi ketne el an ac' tu'. Yetoj pax oj, man watx' oj chi yun can an xil tu' yu an ac' tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Yetoj pax oj, c'am mac chi aon ey vino tol to chi wa'xi yul junoj icham net tz'um, yutol ja' yet chi ch'ib a jun vino tu', chi nic'chatoj no' net tz'um tu' yu. Catu' tu' c'al chi etex el vino tu', c'al no' tz'um tu'. Yuxan, asan yul ac' tz'um chi ey wan vino tol to chi wa'xi tu', yet watx' c'am c'al junoj tu' c'al chi etex el oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ja' yet lalan to yalon Jesús wan ti' tet eb, catu' jix apni jun yaawil eb Israel sc'atan naj. Jix ey kaan naj sattaj yajan Jesús, catu' jix yalon jaxca ti': —Tuxa chi cam ix jin cutz'in an. Toon wetoj an, catu' chi to ja batxban oc ja k'ab yiban ix yet watx' chi wa'xi can sc'ul ix, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Catu' jix to Jesús tu' yetoj naj xin. Jix to pax eb scuywom naj yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ja' xol eb ánima tzajan yintaj Jesús tu', ey oc jun ix ix caw ya' ey. Ey xa lacaweb jabil ian c'al chi cam ix yu s'ilal ix chi eyi. Yuxan jix yak' yip ix sjitzontoj sba yintaj Jesús, catu' jix oc mitx'an ix yin sti' spichil Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yutol jix yal ix yul sc'ul jaxca ti': “Tol oj wa'xoj can jin c'ul an, tane chin mitx' sti' spichil naj Jesús tu',” ẍi ix yul sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jix meltzotoj jacan Jesús tu' yintaj, jix oc t'anan yin ix. Jix yalon naj tet ix jaxca ti': —Txo ix, tzalaan tinani'. Tol jix wa'xi can a ja c'ul wu an, yu jix jin ja waoc yin ja c'ul an, ẍi Jesús tet ix. Yet xa c'al jun txolan tu' jix wa'xi can sc'ul ix yin junelne. ");
INSERT INTO knjNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ja' yet jix apni Jesús bey sna naj yaaw tu' xin, jix yiloni tol lalan xule wan jaxca yili chirimia, catu' caw chi wek'ek'i ánima yok'i. ");
INSERT INTO knjNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yuxan jix yal naj tet eb ánima jaxca ti': —Elan nej toj sti' na ti'. Ja' ix unin ti', man camnaj oj ix, tu' c'al chi wey ix, ẍi naj tet eb. Pero tu' c'al jix tzeele naj yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jix lawi yujtele eltoj eb sti' na yu naj xin, catu' jix octoj naj bey ey ec' ix k'opo ix unin tu'. Catu' jix oc mitx'an naj yin sk'ab ix tu', catu' jix a waan ix. ");
INSERT INTO knjNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Masanil eb ánima bey jun lugar tu' jix aben sk'umal jun tzet jix yun tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jix el naj Jesús bey titu' xin, Lalan sto naj yul be catu' jix tzajlo cawan winaj c'am chi ske' yilwi yintaj naj. Jix awitoj eb tet naj yin ipal jaxca ti': —Jaach yic'aal naj David ¿c'am mi chi ok' ja c'ul kin? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ja' yet jix apni Jesús bey na xin, jix sjitzon xa c'al toj sba eb sc'atan naj. Jix sk'anlen Jesús tet eb jaxca ti': —¿Chim je yaoc yin je c'ul tol chi ske' wu tzet che k'an e in tu' an? ẍi Jesús tet eb. —Ja' ton Mamin, chi kaoc yin cu c'ul on tol chi ske' ja wu, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Catu' jix sbatxban oc sk'ab naj yin sbak' sat eb tu', catu' jix yalon tet eb jaxca ti': —Yutol jix je yaoc yin je c'ul, yuxan, yun ojab tzet jix je yaoc yin je c'ul tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Catu' jix jajcha can sat eb, chi xa ske' yilwi eb xin, catu' jix cam yalon Jesús tet eb jaxca ti': —Manchej je yal el jun ti' tet eb ánima, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero ja' tu' c'al ch'an yeltoj eb, catu' jix c'oli yalon el eb tet masanil eb bey jun lugar tu' tzet jix yun Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ja' yet lalan yeltej eb tu' xin, catu' jix i'letej jun winaj sc'atan Jesús. Ja' jun winaj tu', c'am chi ske' sk'anabi, yutol ey oc jun pena espíritu yin. ");
INSERT INTO knjNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jix c'al ujtele el jun pena espíritu tu' yin naj yu Jesús xin, catu' jix k'anab a naj. Masanil eb ánima jix ilon jun ti', caw jix q'uey a sc'ul eb sic'lebil, yuxan jix yal eb jaxca ti': —C'am to bey chi kil junoj tzet yetal jaxca jun ti' cu xol jaon Israel jon ti', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jal eb fariseo xin, jix yal eb jaxca ti': —Ja' jun winaj ti', chi ta' ske' yi'on el pena espíritu yin ánima, yutol ja' ton yaawil eb pena espíritu tu' ey oc yetoj naj, ẍi eb fariseo tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jix ec' Jesús yul-laj masanil conoblaj c'al yul-laj aldealaj, catu' jix cuywa can yul-laj snail sculto eb Israel. Jix yal el watx' k'ane yu tzet chi yun yoc Dios Yaawil oj eb ánima. Jix yak' pax can wa'xoj sc'ul eb ánima yin yal c'al tzet ya'bilal chi ioni. ");
INSERT INTO knjNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ja' yet jix yilon eb ánima naj Jesús, jix cus a sc'ul naj yin eb. Yutol laan yili eb jaxca junoj bulan no' me' c'am yilomal. Ey oc eb yin som c'ulal c'al yin sya'tajilal jix yil naj. ");
INSERT INTO knjNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yuxan jix yal tet eb scuywom jaxca ti': —Ja' eb ánima ti', stiempoal yi'le a eb tinani', jaxca ixim trigo stiempoal xa sc'uplei. Caw yel caw listo c'al ye eb, pero jaywanne pax mac lalan smulna xol eb. ");
INSERT INTO knjNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yuxan, txalan nej tet naj a mulnail ti', yet watx' tol chi ẍejtej eb smulnawom xol eb, ẍi Jesús tet scuywom. ");
INSERT INTO knjNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ja' yet tu', jix yawtentej eb lacawan scuywom Jesús. Catu' jix yak'on yopiso eb yin i'o can el pena espíritu yin ánima. Jix yak'on pax can yopiso eb yin ak'o can wa'xo sc'ul ánima yin yal c'al tzet ya'bilal, c'al yin yal c'al tzet sya'ilal. ");
INSERT INTO knjNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ja' sbi eb ti': Simón, naj chi al-le pax Pedro, yetoj jun yuẍtaj naj chi yij Andrés. Jacobo, yetoj pax jun yuẍtaj chi yij Juan. Ja' eb cawan tzunan ti', sc'aal naj Zebedeo eb. ");
INSERT INTO knjNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ey jun chi yij Felipe, ey jun chi yij Bartolomé. Ey jun chi yij Tomás. Ey jun chi yij Mateo, naj tejom el tolabal yet yalantoj. Ey jun xa chi yij Jacobo, naj sc'aal naj Alfeo. Ey jun chi yij Lebeo, chi yij pax naj yin Tadeo. ");
INSERT INTO knjNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ey jun xa chi yij Simón, yetbi sba yetoj eb Cananista yet yalan toj. Ey jun chi yij Judas Iscariote, naj jix aon oc Jesús yul sk'ab camich. ");
INSERT INTO knjNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Catu' jix chejletoj eb lacawan ti' yu Jesús. Pero ja' yet c'am to chi to eb, jix yalon wan chejbanile ti' tet eb, jix yal jaxca ti': —Manchej jex ec' bey wan lugar bey ey ec' eb man Israel oj. Manaj pax bey wan conoblaj yul yet Samaria. ");
INSERT INTO knjNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Asan bey eb q'ueynaj toj xol eb ket Israelal chex eq'ui. Yutol ja' eb, jaxca junoj no' me' chi q'uey ec' oj, quey tu' ye eb. ");
INSERT INTO knjNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Chi ec' je yal el oj, tol ja' naj Yaaw a satcan tuxa chi oc can Yaawil titi'. ");
INSERT INTO knjNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ja' eb ya' ey yu lepra, che yak' can wa'xoj sc'ul eb, c'al jantaj eb ya' ey yu yal c'al tzet ya'bilal. Che pitzc'une can a eb camnaj. Catu' che yi'on can el pena espíritu yin eb ánima. Tu' c'al chi wak' jun opiso ti' e ex, yuxan manchej je k'an je tool tet eb bey oj je yak'balne tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","C'am c'al nioj tzet che yi' yet chex toi. Manchej je yi' ch'en oro, ma ch'en plata, c'am junoj centavo che yi'toj. ");
INSERT INTO knjNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Manchej je yi'toj je morral yu yet je be. Junne je camiẍ che yaoc oj yet chex toi. C'am che yi'toj junoj xa moan je xanab, c'am che yi'toj junoj xa je k'ojoch. Chi wal wan ti' e ex, yutol smasanil eb mulnawom, smoo ẍa'on sgasto eb. ");
INSERT INTO knjNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ja' yet chex apni bey jun jun conob, c'al bey jun jun aldea, ja' bey sna junoj mac txequel watx' sbeybal chex ey eyi, masanta' c'al chex to bey junoj xa lugar. ");
INSERT INTO knjNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ja' yet chex apni bey jun jun na, “Ey ojab je watx' c'ulal yetoj Dios,” je chi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ta yel ey watx' c'ulal eb yetoj Dios che yila, oj jex cha'le yu eb. Ta c'amaj, man oj jex cha'le yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ta c'am chex cha'le yu eb, catu' c'am pax chi ẍa' eb yab tzet che yala, chex el bey sna eb tu', c'al yul sconob eb tu'. Che tzic can el spojojal je yajan yu je tx'oxon el oj tol c'am je yalon je yet yin eb, catu' chex toi. ");
INSERT INTO knjNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Caw yel chi wal e ex, ja' yet oj jul jun c'ual chi na'le oc yin eb ánima, yel miman sya'tajilal oj ẍa' eb ma jex cha'on tu' yintaj eb ánima a conob Sodoma c'al Gomorra. ");
INSERT INTO knjNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ilala, tol chex jin chejtoj xol ánima jaxca tol chin chejtoj no' me' xol no' oj. Yuxan, listo c'al che yute je ba jaxca junoj no' laba caw jelan. Pero suc che yute je ba jaxca no' uch. ");
INSERT INTO knjNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Che yil c'al je ba, yutol ey eb oj jex i'ontoj sattaj eb yaaw. Catu' oj jex mak'le yu eb yul-laj snail sculto eb ket Israelal. ");
INSERT INTO knjNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Oj jex i'letoj sattaj eb mimej yaaw, c'al sattaj eb rey jin ya'il oj. Ja' titu' oj ske' je yalon can el jin k'aneal, c'al tet eb man Israel oj. ");
INSERT INTO knjNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ja' yet oj jex i'letoj sattaj eb yaaw tu', manchej jex oc bis c'ulal yu tzet oj je yala. Yutol ja' yet jun txolan tu', ja' Dios oj ak'on na'cha el je yu tzet oj je yala. ");
INSERT INTO knjNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Manaj jex oj jex k'anab oj, pero tol ja Yespíritu cu Mam Dios oj maanen je ti', catu' ja' oj k'anab je yin. ");
INSERT INTO knjNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ja' yet jun tiempoal tu', ey eb yuẍtaj sba oj yaoc yuẍtaj eb yul sk'ab camich. Ey pax eb mame oj yaoc yuninal yul sk'ab camich. Ey bey xin, oj yak'le jowal eb uninale yetoj smam c'al xutx, catu' oj yaon oc smam c'al xutx eb tu' yul sk'ab camich. ");
INSERT INTO knjNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Masanil eb ánima oj tit sjowal je yin wu c'al. Pero ja' mac eb oj techa yu masanil, oj colcha oj. ");
INSERT INTO knjNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ja' yet pena chi yute sba eb e ex, bey jun conob bey ey jex ec' oj, elan nej a oj catu' chex to bey junoj xa conob. Caw yel chi wal e ex c'am to c'al chi lawi je yec' bey masanil sconoblaj eb ket Israelal tu', catu' oj jin jul pax junel xa, jain Ak'bil Wopiso xol eb ket animail yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","C'am junoj cuywom ec'ban yel oc apnoj yintaj scuywam. C'am pax junoj moso ec'ban yel oc apnoj yintaj spatrón. ");
INSERT INTO knjNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ta tol laan junoj cuywom yetoj scuywam, watx' ton jaxca tu' chi yune'. Quey pax tu' junoj moso yetoj spatrón. Jainti', jaxca tol a na jin. Jal jex xin, jaxca tol uninale jex. Ey mac chi aloni tol Beelzebú jin, naj yaawil eb pena espíritu. Ta chi al-le jaxca tu' win an, yel xa c'al pena oj al-le je yin. ");
INSERT INTO knjNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yuxan manchej jex xiw tet ánima. Yutol ja' masanil jantaj tzet yetal majan ey tinani', oj txeclo a oj. Yetoj jantaj tzet yetal ewan c'uan yei, oj ak'le otajnele el oj. ");
INSERT INTO knjNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ja' wan tzet chi wal e ex yin ewantajil, al wej el masanil tet ánima. Yetoj wan tu' c'al chin sa' je yabe, al wej el yul-laj calle. ");
INSERT INTO knjNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Manchej jex xiw tet eb chi ske' jex yak'on cam oj, yutol ¿Toj oj ske' yak'on cam je pixan eb? Ja' tet Dios smoo chex xiwi, yutol chi ske' jex yak'on cam oj, catu' chi yaontoj je pixan bey infierno. ");
INSERT INTO knjNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","I' wej je cuenta yin no' ni'tej tz'iquin tinani', c'am yel oc apnoj no', cac'on no' chi txonle yin centavo. Cax c'al c'am yel oc apnoj no', pero c'am junoj no' comon c'al chi cami, c'am chi ey q'uey sat tx'otx' ta c'am chi el yin sc'ul cu Mam Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Jaexti', yel miman je yel oc apnoj yintaj no' tu'. Ja' xil je jolom masanil bisbil yu Dios. Yuxan, manchej jex xiwi. ");
INSERT INTO knjNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yal c'al mac txequel c'am chi q'uixwi yalon sattaj ánima tol wet an, oj wal oc eb wetoj sattaj cu Mam Dios ey ec' satcan. ");
INSERT INTO knjNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero ja' eb chi alon sattaj ánima tol man wet oj an, oj wal pax sattaj cu Mam Dios ey ec' satcan tol man wet oj pax eb an. ");
INSERT INTO knjNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Manchej je na' tol oj oc watx' c'ulal xol eb ánima yul yiban k'inal ti' yutol jix jin jul an. Man oj oc watx' c'ulal xol eb yutol jix jin jul an. Pero oj scajlen a sba eb, yutol jix jin jul an. ");
INSERT INTO knjNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yu jix jin jul an, oj scajlen a sba naj winaj yetoj smam, c'al oj scajlen a sba ix ix yetoj xutx, c'al oj scajlen a sba ix alibe yetoj yalib. ");
INSERT INTO knjNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yuxan ja' c'al oc eb junne nail ye tu', oj scajle a sba eb. Ja' eb cajat ey oc eb yul sna. ");
INSERT INTO knjNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ja' mac txequel yel miman yel oc apnoj smam xutx wintaj an, man smoo oj yoc wetoj an. Ja'c'ala' pax eb tol yel miman yel oc apnoj sc'aal ma scutz'in yul sat wintaj an, man smoo oj eb yoc wetoj an. ");
INSERT INTO knjNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ja' eb c'am chi yal sc'ul chi yil sya'ilal jin ya'il oj an, eb c'am chi yal sc'ul chi ale oc yin culus jin ya'il oj an, man smoo oj eb yoc wetoj an. ");
INSERT INTO knjNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ja' eb asanne scawil chi sya' ilne yul yiban k'inal ti', oj q'uey el sk'inal eb yin junelne. Jal eb bejan sc'ul scam jin ya'il oj an, ja' ton eb tu', oj ẍa' k'inale tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ja' eb chex cha'oni, jain chin ẍa' eb. Ja' eb chin cha'on tu', lalan pax ẍa'on eb mac jix jin chejontej an. ");
INSERT INTO knjNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ja' mac chi cha'on junoj ẍejab Dios, asan yutol ẍejab Dios, jaxca spaj jun ẍejab Dios tu' oj yi', quey pax tu' oj yi' jun chi cha'on tu'. Ja' mac chi ẍa'on junoj mac txequel tol watx' sbeybal, asan yutol watx' sbeybal tu', jaxca spaj oj yi' jun watx' sbeybal tu', quey pax tu' oj yi' jun chi ẍa'on tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yal c'al mac txequel chi sa'on asan junoj wasu siquil ja' yuc' junoj eb jin cuywom, asan yutol jin cuywom, cax c'al junoj eb c'am yel oc apnoj. Ja' jun chi sa'on jun siquil ja' tu' oj ẍa' spaj siquil ja' tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ja' yet jix lawi yalon wan chejbanil ti' naj Jesús tet eb lacawan scuywom tu' xin, catu' jix toi. Catu' jix ec' yul-laj conoblaj bey jun lugar tu'. Jix ec' yalon el sk'aneal c'al scuywa tet eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ja' yet jun tiempoal tu', ey oc naj Juan Bautista yul preso. Jix yab naj tzettaj yetal lalan yel yunen naj Cristo. Yuxan jix ẍejtoj cawan scuywom bey ey ec' Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jix sk'anlen eb tet Jesús jaxca ti': —¿Jaachti', Cristo jaach, ja' ton naj lalan kechbanen sjuli, ma ey junoj xa chi kechbane sjul on xin? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jix tak'wi Jesús tet eb jaxca ti': —Paxan nej toj bey naj Juan tu', catu' che yalon yab naj Juan tu' wan che yab ti', c'al wan che yil ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Che yal tet naj tol ey eb c'am c'al ta chi ske' yilwi, chi xa ilwi eb tinani'. Ja' eb c'am c'al ta' chi ske' sbeyi, chi xa bey eb tinani'. Ja' eb ey oc lepra yin jix wa'xi can sc'ul eb. Ja' eb c'am chi yabe, jix yab can a eb. Ey pax eb camnaj xa jix pitzc'u can a oj. Catu' lalan yaben watx' k'ane yet colbanile eb meba'. ");
INSERT INTO knjNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Caw watx' yet eb c'am chi somcha can el sc'ul win an. Quey tu' che yute je yalon tet naj Juan tu' yet chex apni, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ja' yet lalan spax can toj eb chejabwom tu', jix yalontej Jesús yin naj Juan tu' tet eb ánima jaxca ti': —Na' wej tej, tzet jix bet je yil bey cusiltaj tx'otx' tu'. ¿Jam junoj te' a chi bilwi yu ka'e' jix bet je yila? ");
INSERT INTO knjNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ta man a oj, ¿tzet jix bet je yil xin? ¿Ma ja' junoj winaj watx' spichil jix bet je yila? Je yotaj xa tol ja' eb watx' spichil tu', ja' bey sna eb yaaw ey ec' eb. ");
INSERT INTO knjNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ta manaj wan tu' xin, ¿tzet jix bet je yila? ¿Ma ja' junoj yalomal el sk'ane Dios jix bet je yila? Yalomal ton el sk'ane Dios jix bet je yil tu'. Pero ja' naj Juan tu', man asanne oj ẍejab Dios tu' yopiso. ");
INSERT INTO knjNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yutol ja' ton sk'aneal naj Juan ti', yalnaj can Dios yul An Juun Tz'ibebil can oj, bey chi yal jaxca ti': Oj jin chejtoj jun jin chejab, oj baboj to ja sattaj. Jaxca chi yun swa'xi junoj be, jaxca tu', oj yute wa'xoj sbeybal eb ánima yu, yet c'am to chach juli, ẍi yul An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Caw yel chi wal e ex, tol ja' xol ánima yul yiban k'inal ti', c'am junoj mac txequel ec'ban yel oc apnoj yintaj naj Juan Bautista tu'. Pero yal c'al mac txequel ey oc Dios Yaawil oj, yel ec'ban swatx'il yet eb yintaj naj Juan tu', cax c'al c'am c'al yel oc apnoj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yet tax jix ẍa'on el yich yak'wi bautizar ánima Juan, masanta' c'al tinani' ey eb chi yoche chi el yich jun Yaawilal a satcan yetoj jowal. Ey eb caw chi yak' yip yoc Dios Yaawil oj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yutol ja' masanil eb ẍejab Dios jix aloni, tol oj oc Dios Yaawil oj. Quey pax tu' yal-le can yul sley Moisés. Jix yalon eb masanta' c'al jix jul naj Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ja' tinani', ta chi ske' che yaoc yin je c'ul ja' naj Juan tu', ja' ton naj Elías, jun albil can tol oj jul oj, jun echbanebil sjuli. ");
INSERT INTO knjNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ja' wan che yab ti', na' wej tej sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Pero ja' eb ánima yet jun tiempoal ti', oj waltej e ex tzet utbil ye oc sna'bal eb. Laan eb jaxca unin tu' c'al chi ec'ab txombal. Ey eb chi yal tet wanoj xa yet uninal jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Jix koche chex sajchi ketoj, pero na'ba c'al jix ketne cu ba cu sonle je yu, pero ma c'al jex canalwoj pax oj. Yetoj pax oj na'ba c'al jix cu bit'ne wan bit' caw cusiltaj xa c'al yoqui, pero ma c'al jex ok' pax ketoj jon,” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Quey c'al tu' ye yet jix jul ec' naj Juan Bautista, yutol ja' sbeybal naj Juan tu', c'am tzet watx' chi yoche chi slo', c'al chi yuq'ue. Yuxan chi yal eb, tol junoj pena espíritu chi etneni. ");
INSERT INTO knjNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ja' yet jix jin jul xin, jain Ak'bil Wopiso yu Dios xol eb ket animail an. Jainti', chin lowi, chi wuq'ue. Pero ẍi eb win an: “Ja' Jesús tu', asan c'al lo' c'al uq'ue vino chi yoche. Yamigo sba naj yetoj eb tejom el tolabal, c'al yetoj wan xa eb pena sbeybal,” ẍi eb win an. Yal c'al tzet chi kune, pena che yal kin. Pero ja' eb ey oc sjelanil Dios yin, chi txeclo el eb tu' yin tzet chi el yuneni, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jix lawi jun tu', catu' jix ẍa'on el yich yalontej Jesús spenail eb ánima bey wan conoblaj bey caw ey milagro jix yune'. Cax c'al caw ey milagro jix el yunen snan xol eb titu', pero ma sna' sba sc'ul eb yin spenail. Yuxan jix yal naj jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Chi wal e ex an, jex a Corazín, caw ok'bal jex c'ule. C'al jex a Betsaida, ok'bal jex pax c'ule. K'inaloj ta ja' bey Tiro yetoj bey Sidón jix yun wan milagro jix utele je xol ti'. Ma'i tax mi jix yaoc eb wan eel coẍtal spichil oj. Yetoj sti'k'ak'il taan ma'i tax mi jix yatoj eb yin sjolom yu xeclonen el eb tol caw chi cus sc'ul eb yu spenail. ");
INSERT INTO knjNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yuxan, ja' yet oj jul jun c'ual yet chi sna' oc Dios yin ánima, yel xa c'al miman sya'tajilal oj je cha' yintaj eb a Tiro c'al eb a Sidón. ");
INSERT INTO knjNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ja'c'ala' jex a Capernaum, che na' tol je moo je ya apnoj satcan, pero tol oj jex toj bey sya'tajilal. Ta ja' bey conob Sodoma jix wun wan milagro jaxca wan jix wun je xol tu', jix mi sna' sba sc'ul eb yin spenail, ey mi ec' sconob eb tu' tinani'. ");
INSERT INTO knjNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yuxan chi wal e ex, ja' yet oj jul jun c'ual yet chi sna' oc Dios yin ánima, yel xa c'al miman sya'tajil oj je cha' yintaj eb a Sodoma tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ja' yet jun tiempoal tu', jix txali Jesús. Jix yal naj yin xa jaxca ti': —Mamin, Yaaw jaach bey satcan, c'al bey yul yiban k'inal ti', chi wal watx' k'ane e ach an, yutol jix ja weba el wan ti' tet eb jelan, c'al tet eb caw jelan yul sat eb yet animail. Jal eb c'am yel oc apnoj yul sat ánima xin, jix ja wak' yotajne el eb. ");
INSERT INTO knjNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Quey tu' jix ja wute jaxca tu', Mamin yutol quey tu' jix ẍa' ja c'ul, ẍi Jesús tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jix lawi jun tu' xin, catu' jix yalon Jesús tet eb ánima jaxca ti': —Ja' naj jin Mam an, jix yak' can masanil tzettaj yetal yul jin k'ab. C'am junoj mac txequel otajnen jin, jain C'aale jin ti' an. Asan jin Mam tu' otajnen jin an. Yetoj pax oj, c'am mac comon c'al chi otajnen el jin Mam an. Asan jin, jain Sc'aal jin ti' an, wotaj an, yetoj pax tet mac chi yal jin c'ul chi wak' otajnele el an. ");
INSERT INTO knjNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yuxan, sebax wej e in je masanil an, jex c'uumbinaj yu mulnail, c'al yu yalil je yijatz, oj jex wak' xew an. ");
INSERT INTO knjNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","I' wej jun ijatz oj wak' e ex an. Cuywan nej wintaj an, yutol jainti', yin watx' c'ulal chin cha' ánima. Yeynajil chi wute jin ba an, catu' oj je cha' xewbal je pixan. ");
INSERT INTO knjNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ja' jun ijatz chi wak' je yij ti' an, man al oj, catu' man pax ya'taj oj jin je yak'on servil, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ja' yet jun xewbal c'u yet eb Israel, jix ec' Jesús bey jun be xol wan ixim trigo yetoj eb scuywom. Jix tit swail eb scuywom tu', yuxan jix yi' el jayeb sjolom ixim trigo eb, catu' jix buchon eltej ixim eb, catu' chi sc'uxun eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ja' yet jix yilon jaywan eb fariseo jaxca tu' xin, jix yalon eb tet Jesús jaxca ti': —Ilala, ja' wan ja cuywom ti', lalan smulna eb yet sc'ual xewilal ti', pero ey cu ley tol c'am chi cu mulna yet sc'ual xewilal, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Catu' jix yalon Jesús tet eb jaxca ti': —¿Tumi c'am to bey che yil yul An Juun Tz'ibebil can oj, bey chi yal tzet yunnaj David junel, yet jix tit swail yetoj eb yetbi? ");
INSERT INTO knjNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jix octoj yul Snail Sley Dios, jix slo'on ixim pan yet Dios yei, yetoj eb yetbi naj tu'. Ja' wan pan tu', asan eb yak'omal xaambal tet Dios ey sleyal slo'oni. Jal naj David yetoj eb yetbi naj tu' xin, c'am sleyal tol chi slo' eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ma c'am to che yil yul sley Moisés tol ja' eb yak'omal xaambal tet Dios chi ak'wi servil yul templo tu' yet sc'ual xewilal, pero c'am chi oc smul oj eb? ");
INSERT INTO knjNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Chi wal e ex an, tol ja' titi' ey junoj mac txequel yel xa c'al miman yel oc apnoj yintaj Stemplo Dios tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ta jix na'cha el je yu tzet albil can yu Dios yul An Juun Tz'ibebil can bey chi yal jaxca ti': “Chi woche tol chi ok' je c'ul yin je yet animail. Man asanne oj xaambal chi woche,” ẍi yul An Juun tu'. K'inaloj ta chi na'cha el jun tu' je yu, c'am mi che yak' low yin eb c'am smul. ");
INSERT INTO knjNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Jainti', chi ske' walon tzet chi ske' el kunen yet sc'ual xewilal, tu', yutol Ak'bil Wopiso yu Dios xol eb ket animail, ẍi Jesús tet eb fariseo tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jix lawi jun tu' xin, catu' jix to Jesús tu', catu' jix octoj yul snail sculto eb Israel tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ey jun winaj sicbinaj el jun sk'ab naj ey ec' titu'. Ey pax eb chi yoche chi ilcha junoj k'ane chi oc smul oj Jesús, yuxan jix sk'anle eb tet naj jaxca ti': —¿Ey sleyal chi ak'le can wa'xoj sc'ul junoj ya' ey yet sc'ual xewilal? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Catu' jix tak'wi Jesús tu' tet eb: —K'inaloj ta ey junoj jex chi to junoj je me' yul junoj jolan yet sc'ual xewilal, ¿tumi c'am chi to je yi' atej? ");
INSERT INTO knjNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Jal junoj ánima, yel xa c'al miman yel oc apnoj yintaj junoj no' me' tu'. Yuxan, chi ton ske' kak'on junoj watx' c'ulal yet sc'ual xewilal, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jix lawi yalon jun tu' xin, catu' jix yalon tet naj jaxca ti': —Bi eltoj ja k'ab, ẍi Jesús tet naj. Jix sbion eltoj sk'ab naj, catu' jix wa'xi can jaxca c'al ta' jun xa sk'ab naj. ");
INSERT INTO knjNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ja' yet tu', jix eltej eb fariseo tu' sti' na, catu' jix c'oli slatinen sba eb yin Jesús tu' yu tzet utbil chi yute yak'on cam naj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ja' yet jix yotajnen el Jesús tzet lalan sna'on oc eb yin xin, catu' jix to tu'. Ec'al eb ánima jix tzajlo yintaj naj, catu' jantaj eb ya' ey xol eb jix wa'xi can sc'ul eb yu naj. ");
INSERT INTO knjNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Catu' jix yalon naj tet eb jaxca ti': —C'am junoj mac bey che yala mac txequel jix ak'on wa'xo je c'ul, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jaxca tu' jix yute yalon tet eb tu', yet watx' chi yun tzet albil can yu naj ẍejab Dios, naj chi yij Isaías yet peyxa, yet jix tz'iben can tzet jix yal Dios tet, tol jix yal jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ja' ton jun jin chejab sic'bil el wu ti' an. Miman jin cam c'ulal yin naj an. Caw chin tzala yetoj. Oj wak' can Wespíritu yin naj. Catu' oj yalon el snan xol eb man Israel oj, tol oj na'le oc yin eb yin sjichanil. ");
INSERT INTO knjNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","C'am bey oj yak' jowal. C'am bey oj a yaw. C'am mac oj aben yalon el naj yul-laj calle. ");
INSERT INTO knjNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ey eb caw ok'bal sc'ul, jaxca junoj te' a c'uun spajchai. Ma xin, jaxca junoj tzejtebal tuxa chi tani, quey tu' eb. Pero ja' ton oj colon eb, man oj yak' low yin eb. Quey ton tu' oj yune' masanta' c'al oj oc can naj yin Yaawilal. Ja' yet oj yak'on Yaawilal tu', yin sjichanil oj yak'a. ");
INSERT INTO knjNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Catu' ja' oj aon oc yip oj sc'ul masanil eb conoblaj, ẍi Dios yul An Juun Tz'ibebil can oj. ");
INSERT INTO knjNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ey jun winaj jix i'letej sc'atan Jesús, tol c'am chi ske' yilwi, c'am chi ske' pax sk'anabi, yutol ey jun pena espíritu ey oc yin. Pero jix wa'xi can sc'ul yu Jesús. Yuxan jix ilwi can a oj, catu' jix k'anab pax a oj. ");
INSERT INTO knjNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Masanil eb ánima jix ilon jun tu', jix quey a sc'ul eb catu' jix yalon eb jaxca ti': —¿Jam jun yic'aal naj David echbanebil sjul ku ti'? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero ja' yet jix yaben eb fariseo jun ti', jix yalon eb jaxca ti': —Chi ta' ske' yi'on el pena espíritu jun winaj ti' yin ánima, yutol ja' yaawil eb pena espíritu tu' ey oc yetoj naj, jun chi yij Beelzebú, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jix yotajne el naj Jesús tzet chi sna' eb, yuxan jix yal tet eb jaxca ti': —K'inaloj ey junoj miman conob bey chi po'cha eb yaaw, catu' chi yak'len a jowal eb. Chi lawi ey jun conob tu' yu. K'inaloj ey junoj conob, ma xin junoj nail ánima chi po'cha yu jowal, chi lawi ey oj. ");
INSERT INTO knjNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Quey ton tu', ye naj Satanás, ta chi po'cha yetoj yet pena espíritual, ¿tzet utbil oj can can naj yin yopiso? ");
INSERT INTO knjNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Jainti', che yala tol yu yipal naj Beelzebú chi wi' can el eb pena espíritu tu'. Ta yel ta' che yala, ¿mac pax txequel ey oc yetoj eb je cuywom yet chi yi'on el eb pena espíritu yin eb tu'? Yuxan ja' ton eb je cuywom tu' chi tx'oxon el oj tol man jichan oj je na'oni. ");
INSERT INTO knjNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Jainti' asan yu yipal Yespíritu Dios chi wi' can el eb pena espíritu tu' yin eb ánima ti'. Ja' ton yin jun ti' chi txeclo el oj tol jix ẍa' el yich yak'on Yaawil Dios je xol. ");
INSERT INTO knjNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","K'inaloj ta ey junoj winaj caw ey yip. Toj ey junoj mac txequel comon c'al oj ske' yoc elk'an yul sna naj. Asan ta chi ak'cha ganar naj catu' chi pixle ey naj bian, jam yet tu' chi ske' yelk'anele el toj yul sna naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ja' eb man wetoj ey oc oj, ac'ul oc eb win an. Ja' eb c'am chi yamban oc eb wetoj an, ja' ton eb chi ak'on sajlem can toj. ");
INSERT INTO knjNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yuxan chi wal e ex an, tol yal c'al tzet penail chi yal ánima c'al chi el yuneni, oj ak'le miman c'ulal yin yu Dios. Pero jal pax mac chi buchon naj Santo Espíritu xin, c'am xa c'al miman c'ulal yin eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ta ey junoj mac txequel chi alon junoj tzet yetal pena win an, jain Ak'bil Wopiso yu Dios xol eb ket animail ti', oj ak'le miman c'ulal yin eb. Pero ja' mac txequel chi yal buchwal k'ane yin naj Santo Espíritu, c'am c'al bak'in oj ak'le miman c'ulal yiban eb. Manaj yet jun tiempoal ti', catu' manaj yet ey oj to tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","K'inaloj ta ey te' te' watx', c'am sat pena chi yak'a. Ja'c'ala', pax te' te' pena, c'am pax sat te' watx' chi yak'a. Yu sat jun jun te' chi yak'a, yuxan chi kotajne el tzet te'al te' te' tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jaexti', laan jex jaxca no' laba. Pena jex. Yuxan ¿Tumi ey nioj tzet yetal watx' chi ske' je yaloni? Yutol ja' tzet ey bey cu pixan, ja' chi kala. ");
INSERT INTO knjNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ja' mac watx' sna'bal, watx' tzet chi yala, yutol asan tzet watx' ey bey spixan eb. Jal pax eb pena sna'bal xin, pena pax tzet chi yala, yutol asan tzet pena ey bey spixan eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Chi wal e ex, tol ja' yet oj jul jun c'ual chi na'le oc kin, oj na'le oc yin masanil ánima yu masanil wan k'ane c'am tzet chi oqui jix yal eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ja' Dios oj na'on oc je yin yu tzet che yala. Ja' yet tu' oj al-le oj ta oj oc tzet jix je yal tu' je mul oj, ma c'amaj, ẍi Jesucristo. ");
INSERT INTO knjNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ey wan eb cuywam yin sley Moisés c'al wan eb fariseo jix alon tet Jesús jaxca ti': —Jaach cuywam, chi koche cha tx'ox jun milagro kila, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yuxan jix yal Jesús tet eb jaxca ti': —Ja' jaex yet jun tiempoal ti', caw pena jex, manaj yin Dios che yaoc je c'ul. Tu' c'al che k'an milagro je yila, junoj tzet chi tx'oxon el yipal Dios. Pero junne milagro oj tx'oxle e ex, ja' ton junoj jaxca jun tx'oxbil yu Dios yin jun ẍejab chi yij Jonás. ");
INSERT INTO knjNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ja' naj Jonás tu', oxeb c'u, oxeb ak'bal ey eytoj naj yul sc'ul jun no' miman pescado. Jaxca jix yun naj Jonás tu', jaxca tu' oj wun an, jain Ak'bil Wopiso yu Dios xol eb ket animail ti'. Oxeb c'u, oxeb ak'bal oj jin eytoj yul tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ja' yet jix ec' yalon el sk'aneal Dios naj Jonás tu' tet eb a Nínive, jix sna' sba sc'ul eb. Jal tinani' ec'ban jin yintaj naj Jonás tu' an, pero toj yu jun tu' yuxan chi sna' sba je c'ul. Yuxan ja' yet oj jul jun c'ual yet chi na'le oc je yin, oj a waan eb a Nínive tu', ja' eb oj alon a je penail. ");
INSERT INTO knjNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ila pax jun ix yaaw bey Sur yet peyxa tu'. Caw naat titnaj ix, Jix jul ec' ix yab tzet chi yal naj Salomón yutol miman sjelanil naj. Jal tinani', ec'ban jin yintaj naj Salomón tu', pero c'am chi jul eb ánima yab tzet chi wal an. Yuxan ja' yet oj jul jun c'ual yet chi na'le oc je yin, oj a waan ix tu', catu' oj yalon a je penail ix. ");
INSERT INTO knjNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","K'inaloj ta ey junoj pena espíritu chi el yin junoj ánima tinani'. Chi lawi tu' xin, chi ec' bey masanil tajin lugarlaj. Chi seyon ec' bey watx' chi xew nioj. Pero c'am chi ilcha bey watx' chi eyi. Yuxan chi sna' jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Oj jin meltzo bey ey jin ta' a bey xin tit a,” ẍi. Ja' yet chi apni, chi yilon oc spixan naj tu', laan jaxca junoj na q'uisbil xa, caw watx' yili. ");
INSERT INTO knjNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yuxan chi to yi'tej jujwanoj xa yet pena espíritu ec'ban xa spenail yintaj. Catu' chi swa'nen xa c'al ey sba eb yin spixan naj. Yuxan, yel xa c'al pena chi yun yel oc naj yintaj yet sbabelal. Jaxca ton jun winaj tu', quey ton tu' oj yun yetex xa c'al el sna'bal eb ánima ti', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lalan to yalon Jesús tet eb ánima, catu' jix apni xutx naj yetoj eb yuẍtaj naj. Sti' na jix apni eb. Jix yoche eb chi k'anab yetoj naj. ");
INSERT INTO knjNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yuxan ey jun mac txequel jix alon tet Jesús jaxca ti': —Ey ec' ja txutx yetoj eb ja wuẍtaj sti' na, tol chi yoche eb chi k'anab ja wetoj, ẍi tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jix tak'wi Jesús tu' tet naj jaxca ti': —¿Mac txequel jin txutx tu', mac txequel eb wuẍtaj tu' an cha na'? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Catu' jix x'oxon oc eb scuywom tu' tet naj, jix yalon jaxca ti': —Ja' ton eb ti' jaxca jin txutx yei, ja' ton eb ti' jaxca wuẍtaj yei. ");
INSERT INTO knjNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yutol yal c'al mac txequel chi jijen jaxca chi yoche jin Mam bey satcan, ja' ton eb tu' jaxca tol wuẍtaj an, jaxca tol wanab an, jaxca tol jin txutx an, ẍi Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ja' yet jun c'u tu', jix eltej Jesús yul na. Jix to ey chotan sti' ja' mar. ");
INSERT INTO knjNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ec'al eb ánima jix apni sc'atan naj, bey ey ec' titu'. Yuxan jix octoj yul jun barco, jix ey chotan oj. Jal eb ánima tu' xin, jix can eb sti' ja' tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ec'al k'aneal jix yaltej Jesús tet eb. Wan sk'aneal yet tx'oxbanile. Jix yal naj tet eb jaxca ti': —Ey jun winaj jix eltoj txi'o trigo. ");
INSERT INTO knjNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Lalan ẍi'on ey ixim, catu' ey wan chi ey q'uey can yul be. Pero ja' no' tz'quin jix ec' sic'on a oj. ");
INSERT INTO knjNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ey ixim xin, yibanlaj saam ch'en jix apni can ixim bey xaxo ch'an tx'otx'al, catu' eyman jix aol ixim tu', yutol xaxo ch'an tx'otx'al. ");
INSERT INTO knjNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ja' yet jix aol c'u tu' xin, eyman jix taj el oj, yutol man naat oj jix ey xe' yul tx'otx' yiban ch'en saam ch'en tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ey ixim jix apni pax can xol q'uix, pero jix c'al ch'iba te' q'uix tu', catu' jix q'uey el ixim. ");
INSERT INTO knjNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jal pax ixim, jix ey can bey yax tx'otx' xin, ja' yet jix yak'on sat, ey ixim jolome ciento sbak' jix yak'a, ey ixim sesenta sbak' jix yak'a, ey ixim xin, treinta sbak' jix yak'a. ");
INSERT INTO knjNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ja' wan tzet che yab ti', na' wej tej sic'lebil, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jix sjitzontoj sba eb scuywom tu' sc'atan Jesús, catu' jix sk'anlen eb tet naj jaxca ti': —¿Tzet yuxan asan yin sk'aneal tx'oxbanile chach k'anab tet eb ánima? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yuxan jix tak'wi Jesús tet eb jaxca ti': —Asan e ex chi tx'oxle wan tzet yetal c'am to mac otajnen yu Dios, yet watx' chi na'cha el je yu tzet wal ye jun Yaawil Dios. Jal tet wanoj xa xin, c'am chi ak'le yotajne el eb. ");
INSERT INTO knjNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yutol ja' mac chi yoche chi yotajne el oj, yel xa c'al oj ak'le yotajne el oj. Jal mac c'am chi yoche chi yotajne el wan ti' xin, ta ey nioj tzet yotaj, oj i'le can ec' masanil tet. ");
INSERT INTO knjNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cax c'al asan yin sk'aneal tx'oxbanile chin k'anab tet eb ánima. C'am c'al chi na'cha yu eb yutol cax c'al chi yil junoj tzet yetal eb, pero chi can eb jaxca tol c'am tzet chi yil eb. Yetoj pax oj, cax c'al chi yab eb, pero c'am nioj chi na'cha el yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yuxan lalan yunen el yin wan ánima ti' tzet jix yal naj Isaías yet peyxa, yet jix yalon jaxca ti': Caw yel oj je yabe, pero ma na'cha el je yu. Caw yel oj je yila, pero ma na'cha el je yu tzet oj je yil tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yutol ja' wan ánima ti', jix cawxi el sna'bal eb. Jaxca tol majan xiquin eb yet watx' c'am chi yab eb beytet yel. Yetoj pax oj, jaxca tol chi smutz' ey sat eb, yet watx' c'am chi yil eb beytet jun yel tu'. Tutun c'am nioj chi na'cha el yu eb. C'am chi sq'uex sbeybal eb, yet watx' chin col el eb an, ẍi Dios yul An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jal jex xin, watx' je yet, yutol che yil yetoj je sat, catu' che yaben yetoj je txiquin tzetal yel. ");
INSERT INTO knjNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Caw yel chi wal e ex, ec'al eb ẍejab Dios yet peyxa, yetoj wan xa eb watx' sbeybal, jix yoche sc'ul eb chi yil wan che yil ti', pero ma yil eb. Jix yoche pax eb chi yab wan che yab ti', pero ma yab eb. ");
INSERT INTO knjNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ab wej tzet chi wal an xin. Oj waltej e ex tzet chi yal yel oc apnoj jun sk'aneal naj txi'om trigo tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ja' ixim jinat jix ey q'uey yul be, yechel eb ánima chi aben sk'ane Dios, tzet utbil chi yun yoc Dios Yaawil oj eb, pero c'am chi na'cha pax el yu eb. Chi jul naj diablo sc'atan eb xin, catu' chi ak'le q'ueytoj wan k'ane tu' yul sc'ul eb yu naj diablo. ");
INSERT INTO knjNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ja' ixim jix apni pax can yibanlaj ch'en, yechel eb ánima chi cha'on sk'ane Dios yin tzala c'ulal. ");
INSERT INTO knjNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero c'am chi techa yu eb, man miman oj tiempo chi beytoj eb yin sk'ane tu'. Yutol ja' yet chi jul junoj sya'ilal, ma xin, yet chi yilon sya'ilal eb sya'il oj sk'ane Dios, yin junoj txolan catu' chi meltzo eb yintaj junel xa. ");
INSERT INTO knjNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ja' ixim jix apni pax xol te' q'uix, yechel pax jun xa bulan eb chi aben sk'ane Dios. Pero asan tzet yetal ey yul yiban k'inal ti' chi sna' eb. Chi sna' eb sbe'omal, chi sna' eb yet smimanil. Yuxan na'ba c'al chi al-le el sk'ane Dios tet eb. Laan chi yun yel oc apnoj eb jaxca ixim trigo c'am chi wa'xi sjolom. ");
INSERT INTO knjNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero ja' ixim jix ey q'uey bey yax tx'otx' xin, yechel eb chi aben sk'ane Dios catu' chi na'cha el yu. Ja' ton eb tu' laan jaxca ixim jolome ec'al sbak'. Ey eb xin, jaxca ixim jolome cien sbak'. Ey eb xin, jaxca ixim jolome sesenta sbak'. Ey eb xin, treinta sbak' chi yak'a, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jix yaltej Jesús jun xa sk'aneal ti' tet eb scuywom, jix yal jaxca ti': —Oj waltej e ex tzet ye oc yet ey oc Dios Yaawil oj. K'inaloj ta ey junoj winaj chi txi'wi watx' jinat trigo bey junoj tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ja' yet lalan swey naj, chi jul mac ac'ul oc yin naj, catu' chi jul txi'ontoj an triw ch'im xol strigo naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ja' yet to oj po ixim trigo tu', catu' chi txeclo el an tiriw ch'im xol. ");
INSERT INTO knjNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yuxan chi to al-le yu eb smoso tet naj a awo tu', chi yalon eb jaxca ti': “Ja' ixim ja jinat jix bet ja tx'i' sat ja tx'otx' caw watx' ixim, ¿pero tzet yuxan ey wan an tiriw ch'im xol xin?” ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Tejan ja' junoj eb ac'ul oc win jix bet txi'ontoj xol,” ẍi naj tet eb. “¿Chim yal ja c'ul chi to cu tok'a atej an tiriw ch'im tu' xol ixim trigo?” ẍi pax eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“C'amaj, yutol ja' yet chi tok'le a an tiriw ch'im tu', chi tit ixim trigo yetoj. ");
INSERT INTO knjNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yel watx' chi can can jaxca tu', masanta' c'al yet chi c'uple a ixim trigo tu'. Catu' oj walon tet eb chi mulna tu' tol chi sic'le can el an yu eb. Yin stopanil oj yute eb, catu' oj yak'on tz'a' eb. Oj lawoj tu' xin, catu' oj yi'ontoj ixim trigo eb bey jin c'uanbal an,” ẍi naj, ẍi Jesucristo tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jix lawi jun tu' xin, catu' jix yalontej jun xa sk'aneal Jesús ti': —Oj waltej e ex tzet utbil chi yun ẍ'ib sbisil eb ánima chi oc Dios Yaawil oj. Laan chi yun jaxca junoj jinat mostaza chi yaw junoj ánima sat x'otx'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ja' an yinatil mostaza tu', yali' yintaj masanil jinat. Pero ja' yet chi ch'ibi, yel miman chi yun yintaj wanoj xa awo coc'taj c'al chi kawa. Mimej chi yun ch'ib a oj jaxca te' te' mimejtaj, catu' chi jul no' tz'iquin yin sk'ablaj, chi swa'nen sweyub no' titu', ẍi Jesucristo tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jix yalon pax Jesús jun xa k'aneal ti': —Oj waltoj jun xa k'aneal ti' e ex, tzet utbil chi yun ẍ'ib sbisil eb ánima chi oc yalan Yaawil a satcan. Ja' jun tu', laan jaxca nioj yich pan chi ya eytoj ix ix xol oxeboj echbal harina. Yu nioj yich pan tu', chi ch'ib a masanil ixim, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ja' yet jix k'anab el Jesús snan xol eb ánima tu', yin tx'oxbanile k'aneal c'al jix k'anab tet eb, ");
INSERT INTO knjNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","yet watx' chi yun tzet albil can yu jun ẍejab Dios yet peyxa, yet jix s'iben can jaxca ti': Yin tx'oxbanile k'aneal oj wute k'anab jin ba tet ánima. Oj wal wan tzet yetal c'am mac txequel otajnen yet tax c'al jix wa'xi can yul yiban k'inal ti', ẍi yul An Juun Tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jix yalontoj sba naj Jesús tu' tet eb ánima tu' xin, catu' jix octoj yul na. Catu' jix oc pax toj eb scuywom naj yetoj, catu' jix yalon eb tet naj jaxca ti': —Ja' sk'aneal an tiriw ch'im jix ja wala, al e on, tzet chi yal yel oc apnoj, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Catu' jix yalon Jesús tu' tet eb jaxca ti': —Ja' naj chi txi'on watx' trigo tu', wechel ton jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an. ");
INSERT INTO knjNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ja' tx'otx' tx'otx' bey jix oc awo tu', yechel yul yiban k'inal ti'. Ja' ixim jinat watx' tu', yechel ton eb ey xa oc yalan Yaawil a satcan. Ja' an tiriw ch'im tu', yechel ton eb yet diablo. ");
INSERT INTO knjNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ja' jun ac'ul oc yin naj a tx'otx' tu', yechel ton naj diablo. Ja' yet stiempoal syambale ixim trigo tu', yechel ton yet oj lawoj yul yiban k'inal ti'. Ja' eb chi mulna yet chi c'uple a trigo tu', yechel eb ángel. ");
INSERT INTO knjNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jaxca chi yun sic'le el an tiriw ch'im tu', catu' chi to an tz'a' oj, quey tu' oj yun eb ánima yet oj lawoj yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, oj jin chejtej eb wángel, oj ec' yambale a masanil eb yu eb chi ak'on somcha sna'bal yet animail yetoj pax eb pena tzet chi el yuneni. Oj ec' i'le el eb bey oj wak' Yaawilal. ");
INSERT INTO knjNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Catu' oj k'ojletoj eb bey jun lugar jaxca caw jow k'ak'. Oj ok' eb titu', catu' oj natx'atx' oj ye eb yu sya'il. ");
INSERT INTO knjNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jal eb watx' sbeybal xin, jaxca yili c'u quey tu' oj yun yili eb yalan Yaawil Yaaw a satcan. Na' wej tej wan tzet che yab ti' sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ja' eb chi oc yalan Yaawil a satcan, laan eb jaxca junoj tzet yetal miman stool mujbil yul tx'otx'. Chi ilcha yu junoj winaj, catu' chi smujon can junel xa bey c'al ta' ey tu'. Yin c'al tzala c'ulal chi to txon can el masanil tzet yetal naj, catu' jix manon el jun tx'otx' bey mujan jun be'omal tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ja' yet ey oc eb ánima yalan Yaawil a satcan, laan jaxca junoj txonwom, chi ec' seyon wan ch'en tol caw ey stool, perla sbi. ");
INSERT INTO knjNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ja' yet chi ilcha junoj caw watx', chi xon can el masanil settaj yetal, catu' chi smanon el jun perla tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Oj waltej jun xa sk'aneal ti' e ex an, yu tzet utbil oj yun yel oc eb yalan Yaawil a satcan. K'inaloj ey junoj txim mitx'bal pescado chi ale eytoj xol ja'. Tool c'al yi'on atej masanil tujanil no' pescado. ");
INSERT INTO knjNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ja' yet chi no tx'an xin, chi yi'on atej tx'an eb mitx'om pescado tu' sti' ja', catu' chi ey chotan eb yi'on el no' watx' chi c'ubantoj eb yul xuc. Catu' chi sk'ojon can el no' pena eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Quey ton tu' oj yun yel oc eb ánima yet oj lawoj jun yul yiban k'inal ti'. Oj tit eb ángel yu yi'on el eb pena tu' xol eb watx'. ");
INSERT INTO knjNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Catu' oj sk'ojon can toj eb pena eb tu' yul jun lugar jaxca horno bey k'ak'. Ja' titu' oj ok' eb, oj natx'atx' oj ye eb yu sya'il, ẍi Jesucristo tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jix lawi tu' xin, catu' jix sk'anlen Jesús tet eb scuywom jaxca ti': —¿Chim na'cha el masanil wan ti' je yu? ẍi naj tet eb. —Ja' ton Mamin, chi na'cha el ku on, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jaexti', cuybil jex xa yin tzet chi yun yel oc eb ánima yet ey oc Yaaw a satcan Yaawil oj eb. Yuxan chi ske' je yak'on cuyle wan ac' cuybanile yetoj wan icham. Jaxca chi yun junoj winaj a na, chi ske' yi'on el wan tzet yetal ac' c'al wan icham bey sc'una, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ja' yet jix lawi yalontej wan cuybanile ti' Jesús, chi yal yin wan tx'oxbanile k'aneal, catu' jix to naj. ");
INSERT INTO knjNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jix apni naj bey sconob. Jix octoj yul snail sculto eb Israel, jix c'oli scuywa snan xol eb yul na tu', catu' jix yalon eb jaxca ti': —¿Beytu' jix scuy oc sjelanil jun winaj ti'? ¿Tzetlaj chi yun ske'on yunen wan milagro ti' yu? ");
INSERT INTO knjNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ja' jun naj ti', ja' ton sc'aal naj josom te' ti'. Ja' ix xutx naj, ja' ton ix María. Kotaj pax eb yuẍtaj naj, naj Jacobo, José, Simón yetoj Judas. ");
INSERT INTO knjNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yetoj pax eb yanab naj, ey ec' eb cu xol ti'. Yuxan, ¿bey mi jix tz'aj bet yi' sjelanil naj tu'? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yuxan, tu' c'al jix somcha a sc'ul eb yin naj, yuxan jix yal tet eb jaxca ti': —Ey c'al ta' yel oc apnoj eb ẍejab Dios yul sat masanil ánima. Asan yul sat eb yet conob eb, c'al yul sat eb junne sna yetoj eb, c'am ton yel oc apnoj eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jayebne milagro jix el yunen Jesús bey sconob tu', yutol ma yaoc sc'ul eb yin naj. ");
INSERT INTO knjNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ja' naj Herodes, naj yaawil yul yet Galilea, jix yab sk'aneal Jesús naj yet jun tiempoal tu', ");
INSERT INTO knjNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yuxan jix yal naj tet eb ey oc yopiso yalan naj jaxca ti': —Ja' jun naj tu', ja' ton naj Juan Bautista, pitzc'unaj a naj xol eb camnaj. Yuxan ey yipal yunen wan milagro tu', ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Quey tu' jix yute naj yalon jaxca tu', yutol camnaj xa naj Juan tu' yu naj. Jaxca ti' jix yune' yuxan ak'bil cam naj yu. Ey jun yuẍtaj naj Herodes tu', chi yij Felipe. Herodías sbi yistil. Ja' naj Herodes tu', jix smonte el yistil yuẍtaj tu'. Yuxan jix yal naj Juan tet naj Herodes jaxca ti': —Caw man smoo oj cha yi' ix ti', ẍi naj Juan tu' tet naj. Yuxan jix ak'le sc'ul naj Herodes tu' yu ix. Catu' jix ak'le mitx'le naj Juan tu', catu' jix oc naj yul preso, jix oc cadena yin naj. ");
INSERT INTO knjNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jix yoche naj Herodes tu', chi yak' cam naj Juan tu', pero chi xiw naj tet eb conob. Yutol chi sna' eb ánima masanil tol ẍejab Dios ye naj Juan tu': ");
INSERT INTO knjNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ja' yet jix ẍa'on sk'inal ya'bilal naj Herodes xin, jix syamba oc eb ánima. Jix canalwi ix yune' Herodías tu' sattaj eb masanil. Caw sak'al yec' ix jix yil naj Herodes tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yuxan jix sloctej sbi Dios catu' jix yak'on sti' tet ix jaxca ti': —Yal c'al tzet oj ja k'an e in an, oj wak' e ach an, ẍi naj tet ix. ");
INSERT INTO knjNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pero ak'bil xa sc'ul ix yu xutx, yuxan jix yal ix jaxca ti': —Ja' sjolom naj Juan Bautista cha wak' yul junoj plato e in an, ẍi ix tet naj Herodes tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ja' yet jix yaben naj rey tu' jaxca tu' xin, caw jix cus a sc'ul naj. Pero xax sloctej sbi Dios naj. Jix yab pax eb ey ec' yetoj naj. Yuxan jix yala, tol chi ak'le tet ix. ");
INSERT INTO knjNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jix yak'on orden naj tol chi to i'le el sjolom naj Juan tu' yul preso. ");
INSERT INTO knjNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jix bet eb catu' jix i'letej sjolom naj Juan tu' yul junoj plato, catu' jix yak'on eb tet ix, catu' jix yak'on ix tet xutx. ");
INSERT INTO knjNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Catu' jix apni eb scuywom naj Juan tu', catu' jix yi'ontoj smimanil naj eb, catu' jix smujon can eytoj eb. Jix lawi tu' xin, jix to yalon eb tet Jesús tzet jix yun scam naj. ");
INSERT INTO knjNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ja' yet jix yaben Jesús jun tu' xin, catu' jix octoj yul jun barco yetoj eb scuywom tu', catu' jix to eb bey jun cusiltaj tx'otx' xojli. Ja' yet jix yaben a sk'umal eb ánima bey conoblaj, jix to eb yetoj yajan catu' jix to eb bey oj apnoj Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ja' yet jix eltej Jesús yul barco tu' xin, jix yilon jun miman bulan ánima ey xa ec' titu'. Jix ok' sc'ul naj yin eb, catu' jix yak'on can wa'xoj sc'ul eb ya' ey eb i'bil oc oj. ");
INSERT INTO knjNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jaxa yet yey c'ualil tu' jix apni eb scuywom sc'atan, catu' jix yalon eb tet naj jaxca ti': —Ilala, lalan sto c'u, cusiltaj tx'otx' pax bey ey jon ec' ti', yuxan tejan watx' ta cha chej pax eb ánima ti' bey wan aldealaj cu cawil-laj ti', yet watx' chi to sman low sba eb, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—¿Tzet yuxan oj toj sman low sba eb? Ak' wej low eb jaexti', ẍi naj tet eb scuywom tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Pero asan ch'an joeb cu yali' pan i'bil, yetoj cac'on no' pescado, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—I' wej tej e in an xin, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Catu' jix yalon tet eb ánima bulan ec' titu', tol chi ey chotan eb sat ac'al tu', catu' jix yi'on a ixim joeb pan tu' c'al no' cac'on pescado. Jix a t'anan satcan, catu' jix yalon yu diosalil yu. Jix spo'on ey ixim pan tu', catu' jix yak'on tet eb scuywom. Ja' eb jix po'ontoj xol ánima. ");
INSERT INTO knjNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jix low eb masanil xin, catu' jix no can sc'ul eb. Jix lawi tu', catu' jix syamban a ixim jix can can sobra oj tu', lacaweb to xuc ixim jix yamcha a oj. ");
INSERT INTO knjNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Joeb mil eb winaj jix lowi, pero ma bisle eb ix c'al eb unin. ");
INSERT INTO knjNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jix lawi jun tu' xin, catu' jix yalon Jesús tet eb scuywom tol chi octoj eb yul barco, catu' chi babi k'axpon ec'toj eb, yajban chi yal to sba naj tet eb ánima bulan ec' titu'. ");
INSERT INTO knjNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jix lawi yalon to sba tet eb ánima tu' xin, catu' jix to bey jun wonan txaloj xojli. Ey xa ec' titu' xojli catu' jix k'ejbi ey oj. ");
INSERT INTO knjNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jal eb scuywom xin, ey xa ec' eb snan ja' yetoj te' barco tu'. Lalan xa pitxlo te' yu ja', yutol caw jow stit ka'e' sattaj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tuxa chi sajbi catu' jix apni Jesús yintaj eb. Jix bey naj yetoj yajan yiban ja'. ");
INSERT INTO knjNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ja' yet jix yilontoj eb cuywom tu', tol chi bey naj yiban ja', jix xiw a eb yu. Jix el yaw eb yu xiw c'ulal, jix yalon eb jaxca ti': —Jix jul jun cu lab, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Catu' jix yalon naj tet eb jaxca ti': —Manchej jex oc il. Jain Jesús jin ti' an. Manchej jex xiwi, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Catu' jix yalon naj Pedro tu' tet Jesús: —Wuẍtaj, ta yel jaach, chej jin bey yiban ja', catu' chin to e ach tu' an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Sebach, ẍi Jesús tet naj. Catu' jix eytej naj Pedro yul te' barco tu', catu' jix yak'len naj sto sc'atan Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ja' yet jix yabeni tol caw jow ka'e', jix xiw a oj. Jix yabeni, tol lalan spax ey xol ja', yuxan jix a yaw: —Wuẍtaj, col jin an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Eyman jix oc mitx'an Jesús yin sk'ab naj catu' jix yalon tet naj jaxca ti': —Jaachti', c'am cha waoc ja c'ul win an. ¿Tzet yuxan jix ja wak' caab c'ulal? ẍi Jesús tet naj Pedro tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Catu' ja' yet jix octoj eb yul te' barco tu' xin, catu' jix oc tucan jun ka'e' tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jix yi'on ey sba eb ey xa c'al ta' octoj yul te' barco tu' tet Jesús, catu' jix yalon eb tet naj jaxca ti': —Caw yel Sc'aal jaach Dios jaachti', ẍi eb cuywom tu' tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jix k'axpo ec' eb xin, jix ec' apnoj eb bey conob Genesaret. ");
INSERT INTO knjNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ja' yet jix yilon oc eb ánima tol ja' Jesús jun jix juli, jix abcha el yul-laj masanil jun lugar tu', catu' jix i'letej masanil eb ya' ey bey ey ec' naj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jix sk'anon eb ta asan tol chi smitx' nioj sti' spichil naj. Ja' masanil eb jix mitx'on sti' spichil naj tu', jix wa'xi can sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ey wan eb fariseo yetoj wan eb cuywam yin sley Moisés jix tit bey Jerusalén. Jix apni eb sc'atan Jesús, catu' jix sk'anlen eb tet naj jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Tzet yuxan c'am chi sbeybalne sbeybal eb kichmam eb ja cuywom ti'? Ila, c'am chi x'a' sk'ab eb yet chi low eb, jaxca ta' sley eb kichmam tu', ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jix tak'wi Jesús tet eb jaxca ti': —Jal jex pax oj, ¿tzet yuxan c'am che jije pax wan chejbanile jix yak' can Dios? ¿Tzet yuxan asan wan scuybanil eb je yichmam che beybalne? ");
INSERT INTO knjNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yutol albil can yu Dios jaxca ti': “Ey ojab yel oc apnoj je mam c'al je txutx yul je sat.” “Ja' mac chi buchon smam ma xutx, cam ojabi,” ẍi Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero jaexti', che yala, tol man sowalil oj chi colwa junoj mac txequel tet smam xutx, ta chi yal tet smam xutx jaxca ti': “C'am nioj tzet chi ske' wak'on e ex, yutol masanil tzet ey e in an, yet xa Dios yei,” ta ẍi, caw watx' che yabe. ");
INSERT INTO knjNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Catu' man xa sowalil oj chi colwa tet smam ma xutx je yaloni. Ila ton che yute je yintajnen el chejbanil ey can yu Dios, yu c'al scuybanil je yichmam che beybalne tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Caab sat jex. Yel ton ta' tzet albil can yu naj Isaías je yin yet jix yal jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ja' wan ánima ti', yin c'al ch'an sti' eb, ey oc swatx' k'ane chi yal e in an. Pero naat ey el sna'bal eb win an. ");
INSERT INTO knjNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na'ba c'al chi tz'aj yi' ey sba eb e in an. Asan wan ẍejbanil eb ánima chi yak' eb cuyle oj, ẍi Dios yul An Juun Tz'ibebil can oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Catu' jix awteletej eb ánima sc'atan yu Jesús, catu' jix yalon tet eb jaxca ti': —Jacba wej je txiquin yin tzet oj wala, catu' na'cha ojab el je yu. ");
INSERT INTO knjNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Manaj tzet chi octoj yul cu ti' manaj chi cu etnen el sattaj Dios. Pero ja' tzet chi atej yul cu ti', ja' chi cu etnen el yul sat Dios, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yuxan, jix apni eb scuywom sc'atan catu' jix yalon eb tet naj jaxca ti': —¿Ja wotaj mi tol caw jix tit sjowal eb naj fariseo ja win yu tzet jix ja wal tu'? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero jix yal Jesús tet eb jaxca ti': —Masanil awo tol manaj cu Mam Dios a satcan jix awoni, oj tok'le a yetoj c'al xe', yuxan quey ton tu' oj yun eb. ");
INSERT INTO knjNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yuxan yilxa eb. Laan eb jaxca junoj mac txequel c'am chi ske' yilwi, chi tz'aj quetz junoj xa mac c'am chi ske' yilwi. K'inaloj ta ey junoj mac c'am chi ske' yilwi, chi tz'aj quetz junoj xa mac c'am chi ske' pax yilwi, chi tok'letoj sba eb scawanil sat pac'an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Catu' jix yalon naj Pedro tet Jesús jaxca ti': —Watx' ta cha wal e on tzet chi yal yel oc apnoj jun tx'oxbanil k'aneal jix ja wal tet eb fariseo tu', ẍi naj Pedro tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yuxan jix yal Jesús jaxca ti': —¿Tumi jaexti', c'am chi na'cha pax el je yu? ");
INSERT INTO knjNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tumi man je yotaj oj tol ja' tzet chi octoj yul cu ti', yul cu c'ul chi ey apnoj, catu' chi eli? ");
INSERT INTO knjNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero ja' tzet chi atej yul cu ti', ja' bey cu na'bal chi pitzc'u a oj. Ja' ton wan tu' chi cu etnen el yul sat Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yuxan ja' bey sna'bal ánima chi pitzc'u a masanil spenail. Jaxca mak'o cam ánima. Jaxca mul yul sk'ab naj ichamile ma ix istile. Jaxca smul yet c'am to ketbi. Jaxca elk'an. Jaxca na'o a k'ane. Jaxca buchwal k'ane. ");
INSERT INTO knjNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ja' ton wan ti' chi etenen el eb ánima yul sat Dios ta chi yun eb. Jal pax yu c'am chi cu tx'a' cu k'ab yet chi cu low tu' xin, c'am chi cu etex el yul sat Dios, ẍi Jesucristo. ");
INSERT INTO knjNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jix lawi tu' xin, catu' jix el Jesús bey titu'. Jix to bey jun lugar bey ey wan conob chi yij Tiro c'al Sidón. ");
INSERT INTO knjNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ey ec' jun ix ix man Israel oj titu', a Canaán ix. Jix apni ix yintaj Jesús catu' jix el yaw ix, jix yalon ix tet naj jaxca ti': —Mamin, jaach yic'aal naj David, tol oj wal chi ok' ja c'ul win an. Ey jun ix wune' an, ey oc pena espíritu yin ix. Caw chi yab sya'il ix yu, ẍi ix tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero ma c'al tak'woj Jesús tet ix. Catu' jix apni eb scuywom sc'atan naj, jix yalon eb tet jaxca ti': —Watx' ta cha chej can meltzo ix, yutol caw chi awi ix kintaj, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Catu' jix tak'wi Jesús tu' jaxca ti': —Asan tet eb ket Israelal chejbil jin tej yu Dios. Yutol jaxca no' me' chi q'uey ec' oj, quey tu' eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero jix sjitztej sba ix ix tu' sc'atan eb. Jix sbej ey kaan sba ix sattaj Jesús. Jix yalon ix jaxca ti': —Mamin, colwaan e in an, ẍi ix tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—Pero man watx' oj ta chi stok'le ec' slo'be eb uninale catu' chi ak'le tet no' tx'i', ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Catu' jix yalon ix tu' tet Jesús jaxca ti': —Yel ton Mamin, pero ja' no' tx'i' tu', chi sic'on a sc'ail slo'be eb unin chi ey q'uey yalan smeẍa naj a na tu', ẍi ix tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yuxan jix yal naj tet ix jaxca ti': —Jaachti' chi wila, tol yel c'ulal cha waoc ja c'ul yin Dios. Yuxan ske' ojab ja wochwan, ẍi Jesús tet ix. Eyman jix wa'xi sc'ul ix yune' ix tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jix el Jesús bey titu' xin, catu' jix to sti'laj ja' mar bey Galilea. Jix atoj naj bey jun wonan, catu' jix ey chotan naj titu'. ");
INSERT INTO knjNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ec'al eb ánima jix apni sc'atan naj, bey ey ec' naj titu'. Jix yi'on apnoj eb, eb c'am chi ske' sbeyi, eb c'am chi ske' yilwi, eb c'am chi ske' sk'anabi, eb man tz'anan oj smimanil, c'al wan xa eb ya' ey yu yal c'al tzet ya'ilal. Jix i'letej eb bey yajantaj Jesús, catu' jix wa'xi can sc'ul eb yu naj. ");
INSERT INTO knjNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jix k'anab can a eb c'am c'al ta' chi ske' sk'anabi. Eb man c'al ta' tz'ajan oj smimanil, jix wa'xi can eb. Eb c'am chi ske' sbeyi, jix bey can a eb. C'al eb c'am c'al ta' chi ske' yilwi, jix ilwi can a eb. Ja' yet jix yilon masanil wan ti' eb ánima tu', jix q'uey a sc'ul eb. Catu' jix yalon watx' k'ane eb tet cu Diosal jaon Israel jon ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jix yawtetej eb scuywom Jesús, catu' jix yalon tet eb jaxca ti': —Caw chi ok' jin c'ul yin wan ánima ti' an, yutol oxeb xa c'ual ey c'al ec' eb ketoj titi'. Ja' tinani', c'am xa tzet chi slo' eb. C'am chi woche chin chej pax eb bey sna ta c'am chi low eb chi to eb. Ey smey chi pax yip eb yul-laj be, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","—Pero caw ec'al eb, ¿tzet wal oj kak' slo' eb bey jun cusiltaj tx'otx' ti'? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Jayeb ixim pan i'bil oc je yu? ẍi Jesús tet eb. —Jujeb ixim pan yetoj jayc'on no' pescado, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Catu' jix yalon Jesús tet eb ánima tu' tol chi ey chotan eb sat tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Catu' jix yi'on a ixim pan tu', c'al jayc'on no' pescado tu', catu' jix yalon yu diosalil tet Dios yu. Catu' jix spo'on ey oj, jix yak'on tet eb scuywom, ja' eb cuywom tu', jix po'ontoj xol ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jix low eb masanil, watx' jix yun sno sc'ul eb. Ja' yet jix lawi slow eb tu', jujeb to xuc ixim sobra jix can can oj. ");
INSERT INTO knjNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Caneb mil winaj jix lowi, c'am chi oc eb ix c'al eb unin sbisil oj. ");
INSERT INTO knjNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jix lawi tu' xin, jix yalontoj sba Jesús tet eb ánima tu', jix octoj yul jun barco catu' jix to bey jun lugar chi yij Magdala. ");
INSERT INTO knjNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ey wan eb fariseo c'al wan eb saduceo jix apni sc'atan Jesús, yu yak'len yijban naj yin spenail. Jix sk'an eb yil junoj milagro chi tit bey Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jix yalon Jesús tet eb jaxca ti': —Jaexti', jelan jex che na', ja' yet yey c'ualil che yal jaxca ti': “Man oj yak' nab, ila lalan tz'a' asun,” je chi. ");
INSERT INTO knjNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ey bey xin, ja' yet sk'inibalil che yal jaxca ti': “Yoc xa nab ti', ila moyan, k'ej jolinaj xa c'al,” je chi. Jelan jex ton je yiloni, ta oj yak' nab ma c'amaj. Pero c'am chi na'cha el je yu wan yechel chi tx'oxon tzet ye jun tiempoal tinani'. Yuxan caab sat jex ton xin. ");
INSERT INTO knjNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ja' ánima yet jun tiempoal ti', caw pena eb, manaj yin Dios chi yaoc sna'bal eb. Yuxan, tu' c'al chi sk'an junoj milagro eb yila, junoj tzet chi tx'oxon yipal Dios. Asanxane jun milagro oj tx'oxle tet eb, ja' ton jun jaxca jun tx'oxbil yin naj Jonás yu Dios yet peyxa, ẍi Jesús tet eb. Jix lawi tu' xin, jix el sc'atan eb, catu' jix toi. ");
INSERT INTO knjNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ja' yet jix ec'toj Jesús yetoj eb scuywom bey jun xa sk'axepal ja' mar, ma c'al sna' eb yi' slo'be. ");
INSERT INTO knjNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Catu' jix yalon Jesús tu' tet eb jaxca ti': —Ab wej xin. Che yil c'al je ba yu yich span eb fariseo c'al yu yich span eb saduceo, caw ey smey chex etex el yu, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jix c'oli yalon eb cuywom tu' xol eb jaxca ti': —¿Yu mi c'am cu lo'be i'bil ku, yuxan quey tu' chi yala? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jix yotajne el Jesús tzet chi yal eb, yuxan jix yal tet eb jaxca ti': —¿Tzet yuxan miman che yalotane yu c'am je lo'be i'bil je yu? Caw c'am che yaoc Dios yin je c'ul. ");
INSERT INTO knjNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tumi c'am to c'al chi na'cha el je yu? ¿Tumi c'am xa che na'tej ixim joeb pan jix slo' eb joeb mil winaj, yetoj jayeb xa xuc ixim sobra jix ec' je yamba can a oj? ");
INSERT INTO knjNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yetoj pax ixim jujeb pan jix wak' slo' eb caneb mil winaj. ¿Tumi c'am xa che na'tej jayeb to xuc ixim sobra jix ec' je yamba a oj? ");
INSERT INTO knjNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ja' yet jix wak'on bina yich span eb fariseo c'al eb saduceo e ex, ma na'cha el je yu tzet chi yal yel oc apnoj. Ja' jix je yute je na'oni tol ja' ixim ja' caw pan chi wal an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ja' yet jix yalon Jesús jaxca tu' tet eb, catu' jix na'cha el yu eb tol manaj ja' caw yich pan chi yala, pero tol ja' scuybanil eb fariseo c'al eb saduceo jix yal naj yich panil. ");
INSERT INTO knjNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ja' yet jix apni Jesús yetoj eb scuywom bey conob Cesarea yet Filipos, jix sk'anlen tet eb jaxca ti': —Jain Ak'bil Wopiso yu Dios xol eb ket animail, ¿mac jin txequel yalon eb ánima che yabe? ");
INSERT INTO knjNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—Ey eb chi aloni, jaach ab Juan Bautista jaach. Ey eb xin, jaach ab Elías jaach yalon eb. Ey eb xin, jaach ab Jeremías jaach, ma xin junoj xa ẍejab Dios ec'naj peyxa, ẍi wanoj xa, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Jal jex pax oj, ¿mac jin txequel je yaloni? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jix tak'wi naj Pedro tet Jesús jaxca ti': —Jaachti', jaach ton Cristo jaach, Sc'aal jaach Dios iquis, ẍi naj Pedro tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yuxan jix yal pax Jesús tet naj Pedro tu' jaxca ti': —Simón, sc'aal naj Jonás, watx' ja wet, yutol ja' tzet jix ja wal ti' man ánima oj jix alon e ach. Ja' ton cu Mam ey ec' satcan jix ak'on ja wontajne el oj. ");
INSERT INTO knjNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jain chi wak' can ja wij Pedro. (Pedro chi yal yel oc apnoj ch'en.) Ja' yiban jun miman ch'en ti' oj jin wa'ne atoj eb wiglesia. Ja' jun wiglesia tu', c'am bak'in oj ak'le lawoj yu camich. ");
INSERT INTO knjNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ja' e ach oj wak' slaweal yet chi oc Dios Yaawil oj eb ánima. Ja' tzet oj ja wak' sleyal yul yiban k'inal ti', ey xa c'al ta' sleyal yu naj a satcan. Ja' tzet c'am cha wak' sleyal yul yiban k'inal ti', c'am c'al ta' sleyal yu naj a satcan, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jix lawi tu' xin, catu' jix yalon tet eb scuywom, tol manchej c'al yal el eb ta tol Cristo ton naj. ");
INSERT INTO knjNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ja' yet tax jun tiempoal tu' jix c'oli yalon Jesús tet eb scuywom, yin tzet oj jul yiban naj. Jix yalon jaxca ti': —Sowalil oj jin toj bey Jerusalén. Ja' ta' titu' oj toj wil sya'ilal yu eb yicham winajil conob, c'al yu eb yaawil eb yak'omal xaambal tet Dios, c'al yu eb cuywam yin sley Moisés. Oj jin yak' cam eb an, pero ja' yet yox c'ual tu' oj jin pitzc'u a oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Catu' jix i'le el naj xojli yu naj Pedro tu', jix tenchanele naj yu. Jix yalon tet jaxca ti': —Wuẍtaj, caw man jaxca tu' sna'on Dios. Ja' wan tzet jix ja wal ti', ma ske' sjul ja wiban bian, ẍi naj Pedro tu' tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Catu' jix oc t'anan Jesús tu' yin naj, jix yalon tet jaxca ti': —Jaach Satanás, elan jin sattaj, yutol cha woche chi somcha el jin na'bal. Manaj tzet chi sna' Dios cha na'. Asan yin yet ánima ey oc ja na'bal, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jix lawi tu' xin, catu' jix yalon tet eb scuywom jaxca ti': —Ta ey mac chi yoche chi ec' c'al cuywoj wintaj an, sowalil ojab man xa yetoj sba yul yet. Yab ojab sya'il eb jin ya'il oj, jaxca tol chi locbale a eb yin culus. Ta bejan sc'ul eb jaxca tu', ec' ojab eb cuywoj wintaj an. ");
INSERT INTO knjNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yutol ja' eb c'am chi yoche chi cam bey yul yiban k'inal ti', chi sbej el eb jun k'inale tol ey c'al yin tobal k'inal. Jal pax eb bejan sc'ul scam jin ya'il oj an xin, ja' ton eb tu' oj cha'on k'inale tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","K'inaloj ta chi kak' ganar ki'on masanil tzet ey yul yiban k'inal ti', pero ta c'am pax scolbanil cu pixan, chi cu to can bey sya'tajilal yin junelne. ¿Tzet cu ganar jaxca tu' xin? ¿Tzet wal oj kak' smanbanil oj cu pixan? ");
INSERT INTO knjNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ja' jain Ak'bil Wopiso yu Dios xol eb ket animail tuxa oj jin jul yetoj swatx'ilal c'al sejejial jin Mam an. Oj jin jul yetoj eb wángel an. Catu' oj wak'on sq'uexel tet jun jun ánima tu' yin ja'ta'c'ala' tzet jix el yuneni. ");
INSERT INTO knjNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Caw yel chi wal e ex, ey jaywan je xol ti', c'am to chi cami, catu' oj yilon wuli, jain Ak'bil Wopiso yu Dios xol eb ket animail ti', catu' oj jin oc Yaawilal an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wak'i tax tu', naj Pedro yetoj Jacobo c'al jun yuẍtaj Jacobo tu' chi yij Juan jix i'letoj eb yu Jesús. Asan eb jix i'letoj yu naj. Jix to eb bey jun miman wonan. ");
INSERT INTO knjNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ja' titu' jix q'uexmo yili Jesús jix yil eb. Jix tzejeji a sat naj jaxca c'u. Ja' spichil naj, caw saj jix yun el oj. ");
INSERT INTO knjNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Eyman jix x'ox a sba naj Moisés yetoj naj Elías. Jix k'anab eb yetoj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Catu' jix yalon naj Pedro tu' tet Jesús jaxca ti': —Wuẍtaj, caw watx' ket yutol ey jon ec' titi'. Ta chi yal ja c'ul, chi cu wa'ne oxeboj pat titi', junoj ja wet, junoj yet naj Moisés, yetoj junoj yet naj Elías, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lalan to sk'anab naj Pedro tu', catu' jix ey jotna jun asun yiban eb. Ey junoj mac jix alon xol jun asun tu', jix yal jaxca ti': —Ja' ton jin C'aal ti' bey caw chi cam el jin c'ul an. Caw chin tzala yetoj an. Ab tzet chi yal naj, ẍi. ");
INSERT INTO knjNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ja' yet jix yaben eb cuywom tu' wan k'ane tu', jix ey pajna eb sat tx'otx'. Caw jix xiw a eb sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yuxan jix apni Jesús sc'atan eb, catu' jix sbatx'ban oc sk'ab yiban eb. Jix yalon tet eb jaxca ti': —Aan nej waan oj manchej jex xiwi, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ja' yet jix yilontej eb, c'am xa mac txequel ey ec' oj, asanxane Jesús ey ec' xojli. ");
INSERT INTO knjNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ja' yet lalan spax eytej eb bey jun wonan tu', jix yalon Jesús tet eb jaxca ti': —Manchej je yal yin jun jix je yil ti'. Ja' to yet oj jin pitzc'u a xol eb camnaj, jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, ja' yet tu' che yalon el oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Catu' jix sk'anlen eb scuywom tu' tet naj jaxca ti': —Ja' eb cuywam yin sley Moisés, chi yal eb jaxca ti': “Ja' naj Elías, sowalil oj baboj jul oj,” ẍi eb. ¿Tzet yuxan chi yal eb jaxca tu'? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Catu' jix yalon naj tet eb tu' jaxca ti': —Yel ton chi yal eb, tol sowalil chi jul naj Elías tu', yet watx' chi sna' sba eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero chi wal e ex, tol julnaj xa ec' oj. Pero ma na'cha el yu eb ánima ta tol ja'. Yuxan jix yun eb tet naj jaxca chi yoche. Quey tu' oj wute pax waben sya'il yu eb, jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, ẍi Jesús tet eb scuywom tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Catu' jix na'cha el yu eb tol ja' naj Juan Bautista chi yal Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ja' yet jix apni eb bey bulan ec' ánima tu', jix apni jun winaj sc'atan Jesús. Jix ey kaan naj yajantaj Jesús. Catu' jix yalon tet Jesús jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Mamin, ok' ja c'ul yin jun jin c'aal ti' an. Chi tit snum sat yin. Caw chi yetne sc'ul naj yu. Ey bey ian chi to yiban k'ak' ma yul-laj ja' yu. ");
INSERT INTO knjNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Jix wi'tej bey ja cuywom ti', pero ma wa'xoj yu eb, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yuxan jix yal Jesús jaxca ti': —Jaexti', caw c'am che yaoc je c'ul yin Dios. Caw caw je na'bal. Ilala, ey xa tiempo c'al we ec' je yetoj. ¿Bak'in oj na'cha el je yu xin? Chi yab sya'il jin c'ul je yu. Asi', i'tej naj unin tu' e in an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ja' yet jix apni naj unin tu' sc'atan Jesús, jix tzuwa naj yin jun pena espíritu ey oc yin naj unin tu'. Catu' jix yujten el yin naj. Yet jun txolan tu' jix wa'xi can sc'ul naj unin yu naj. ");
INSERT INTO knjNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ja' yet jix can Jesús xojli yetoj eb scuywom tu' jix sk'anlen eb tet naj jaxca ti': —¿Tzet yuxan ma el jun pena espíritu tu' yin naj ku on? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Yutol c'am che yaoc je c'ul yin Dios. Caw yel chi wal e ex, ta tol che yaoc je c'ul yin, cax c'al asan jaxca junoj sbak' mostaza, oj ske' je yalon tet junoj wonan jaxca ti': “Elan titi', asi' bey junoj xa lugar,” ta je chi tet, oj el je yu. Masanil c'al tzet yetal oj ske' je yu, ta tol yel che yaoc je c'ul yin Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero ja' jun tujan pena espíritu ti', man comon oj chi eli. Asanxane ta chex txali catu' che yijlen nocha je ba, catu' oj ske'on je yi'on el yin eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ja' yet lalan yec'ab Jesús yetoj eb scuywom bey jun lugar chi yij Galilea, jix yalon tet eb jaxca ti': —Jainti', cax c'al Ak'bil Wopiso yu Dios xol eb ket animail ti' an, pero oj jin ale oc yul sk'ab wan winaj. ");
INSERT INTO knjNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Oj jin yak' cam eb an, ja' yet yox c'ual tu', catu' oj jin pitzc'u a oj, ẍi Jesús tet eb. Ja' yet jix yaben wan ti' eb, caw jix cus a sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ja' yet jix apni eb bey conob Capernaum, jix apni eb tejom el tumin yet stemplo Dios sc'atan Pedro, catu' jix sk'anlen eb jaxca ti': —¿Chim yak' jun je cuywam tu' ch'en tumin chi k'anle yu stemplo Dios, ma c'am chi yak'a? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Chi yak'a, ẍi Pedro tet eb. Ja' yet jix octoj naj Pedro yul na tu', ja' Jesús jix babi k'anlen tet naj jaxca ti': —Simón, ¿tzet ẍi ja c'ul? ¿Mac tet chi stej el ch'en tumin eb rey yul yiban k'inal ti'? ¿Jam tet eb yuninal eb, ma ja' tet eb tx'oj conobal? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Ja' eb tx'oj conobal chi ak'oni, ẍi naj Pedro. Yuxan jix yal naj Jesús tet naj jaxca ti': —Ta quey tu' xin, ja' eb c'aale, man sowalil oj chi yak' yet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero c'am chi koche chi tit sjowal eb kin. Yuxan, asi' sti' ja' mar. Asi', a eytoj ch'en anzuelo yul ja', ja' no' babel pescado chi mi'chai, cha wi' atej. Ja' yul sti' jun no' tu' oj ilcha jun tumin. I' atej jun tumin tu', catu' cha wak'on jin tolabal oj c'al ja tolabal oj tet mac chi tejon el ch'en tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ja' yet jun tiempoal tu' jix sk'anle el eb scuywom Jesús tet naj jaxca ti': —¿Mac txequel yel miman yel oc apnoj xol eb yalan Yaawil naj a satcan? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Catu' jix yawtentej jun unin Jesús tu', catu' jix yaon oc snan xol eb. ");
INSERT INTO knjNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jix yalon naj jaxca ti': —Caw yel chi wal e ex, ta c'am chi sna' sba je c'ul, ta c'am che yute je na'bal jaxca eb unin, ma ske' yoc Naj a satcan je Yaawil oj. ");
INSERT INTO knjNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yuxan, ja' eb yeynajil chi yute sba jaxca jun unin ti', ja' ton eb tu', caw miman yel oc apnoj yalan jun Yaawil Naj a satcan. ");
INSERT INTO knjNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yal c'al mac chi cha'on sjul junoj unin jaxca jun ti', yutol wet an, jaxca tol jain chin ẍa' eb an. ");
INSERT INTO knjNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ta ey mac txequel chi ak'on etex el sna'bal junoj unin chi yaoc sc'ul win an, caw ok'bal c'ule eb. Yutol caw miman sya'ilal oj ẍa' yu jun tu'. Yel watx' yet ta chi pixle oc t'unan junoj ch'en ch'en yet molino yin snuk', catu' chi k'ojletoj xol ja' mar, yet watx' c'am chi yetne el sna'bal jun unin tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Caw ok'bal c'ule eb ánima yu wan tzet chi ak'on etex el sna'bal eb tu'. Tobal k'inal ey c'al ta' wan tu', pero ja' eb chi etnen el sna'bal eb tu', caw ok'bal c'ule eb. ");
INSERT INTO knjNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yuxan, ta ja' junoj je k'ab ma junoj je yajan chi ak'on etex el je na'bal, yel watx' che tzoc' el oj, catu' che k'ojon el oj, yet watx' c'am chi etex el je na'bal yu yin junelne. Yutol cax c'al man tz'ajan oj je mimanil, ta oj je cha' je k'inal tol ey c'al yin tobal k'inal, caw watx' je yet. Pero ta tz'ajan ye je k'ab c'al je yajan, catu' chex toj pax xol k'ak' c'am chi tani, man watx' oj je yet. ");
INSERT INTO knjNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ta ja' junoj sbak' je sat chi ak'on etex el je na'bal xin, yel pax watx' che yi' eltej, che k'ojon el oj, yet watx' c'am chi etex el je na'bal yu yin junelne. Yutol cax c'al jun ch'an sbak' je sat, ta oj je cha' k'inale tol ey c'al yin tobal k'inal, caw watx' je yet. Pero ta tz'ajan c'al sbak' je sat, catu' chex to pax can xol k'ak' bey infierno, caw man watx' oj je yet. ");
INSERT INTO knjNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Caw ma ske' je yintajnen el junoj eb unin ti'. Chi wal e ex, ja' eb ángel chi teynen jun jun unin ti', ey ec' eb yetoj cu Mam Dios tobal k'inal bey satcan. ");
INSERT INTO knjNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, jix jin jul yu jin colon el eb q'ueynajtoj an. ");
INSERT INTO knjNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","K'inaloj ta ey jun mac txequel ey junoj ciento sme', catu' chi q'ueytoj junoj no', ¿c'am mi chi sbej can no' noventa y nueve yetbi tu' low bey junoj wonan, catu' chi to seyon ec' no' jix q'ueytoj tu'? ");
INSERT INTO knjNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ta chi ilcha no' yu naj, caw chi tzala oc naj yin no' yintaj pax no' noventa y nueva ma c'al q'ueytoj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Quey ton tu' cu Mam ey ec' bey satcan xin, man yochwan oj tol ey junoj xol eb unin ti' chi q'uey can el oj. ");
INSERT INTO knjNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ta ey junoj ja wuẍtaj chi oc smul e ach, chach to ja txojli bey sc'atan, catu' cha walon tet tzet utbil tol jix oc smul e ach. Ta chi ẍa' yab e ach, tol jix ja wak' ganar ja wuẍtaj junel xa, ch'al tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero ta c'am chi ẍa' yab e ach, yel watx' cha wi'toj jun cawanoj xa mac chi to alon ja wetoj tet. “Ey ojab cawanoj ma oxwanoj testigo, yet watx' ey yip masanil tzet chi al-lei,” jaxca yalon yul An Juun Tz'ibebil can oj. ");
INSERT INTO knjNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pero ta ja'c'ala' c'am chi ẍa' yab tet eb xin, yel watx' cha wal tet iglesia. Ta c'am c'al ta' chi ẍa' yab tet iglesia tu', can ojab jaxca junoj tx'oj conob, ma jaxca junoj tejom el tolabal yul ja sat. ");
INSERT INTO knjNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Caw yel chi wal e ex, ja' tzet oj je yak' sleyal yul yiban k'inal ti', ey pax sleyal yu naj a satcan. Ja' tzet c'am sleyal je yu yul yiban k'inal ti', c'am pax sleyal yu naj a satcan. ");
INSERT INTO knjNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Chi wal pax can e ex an, ta ey cawanoj jex jun laan c'al ẍa'on je c'ul junoj tzet yetal catu' che k'anon yin txail, oj ak'le e ex yu cu Mam ey ec' bey satcan. ");
INSERT INTO knjNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yutol yal c'al bey ey ec' cawanoj ma oxwanoj catu' chi syamban sba yu yi'on ey sba eb e in an, ey jin ec' yetoj eb, ẍi Jesucristo. ");
INSERT INTO knjNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Catu' jix sjitzontoj sba naj Pedro tu' sc'atan naj, catu' jix sk'anlen tet jaxca ti': —Wuẍtaj, ta ey junoj wuẍtaj jaxca c'al ti' chi oc smul e in an, ¿jayel chi wak' miman c'ulal yin an? ¿Sowalil mi jujel chi wak' miman c'ulal yin an? ẍi naj Pedro, jix sk'anleni. ");
INSERT INTO knjNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","—Man c'al jujelne oj, cax c'al siete veces setenta oj chi oc smul e ach, ak' c'al miman c'ulal yin, ẍi naj tet. ");
INSERT INTO knjNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Oj waltej e ex tzet oj yun yel oc eb ey oc Naj a satcan Yaawil oj. Oj el oc eb jaxca eb smoso jun naj rey chi yi' scuenta yin sjec' eb. ");
INSERT INTO knjNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lalan to ẍa'on el yich yi'on scuenta tu', catu' chi i'le sjul junoj naj caw ec'al mil quetzal sjec' tet naj rey tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero c'am ch'en yu naj. C'am xa tzet utbil chi yun yak'on pax sjec' naj tu'. Yuxan jix yal naj rey tu' tol sowalil chi txonle el naj yetoj c'al yistil c'al yuninal, c'al jantaj tzet ey tet naj, catu' chi pax sjec' naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Catu' jix ey kaan naj sattaj naj rey tu', catu' jix yalon sba naj tet naj rey jaxca ti': “Mamin, caw miman cha wute ja c'ul win an. Oj wak' pax jin jec' tu' e ach an,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Catu' jix ok' sc'ul naj rey tu' yin naj. Chi jo'le q'uey sjec' naj yu naj rey yiban masanil, catu' jix jajle el naj yu naj rey tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ja' yet jix eltej naj tu', catu' jix ilcha el junoj yet moso naj yu. Ey mi jayeboj quetzal sjec' naj tet naj. Yuxan jix oc mitx'an naj yin, catu' jix oc pitz'an naj yin snuk' jun winaj tu'. Jix yalon naj tet jaxca ti': “I'tej ch'en ja maan tumin e in tinani' an,” ẍi naj tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Catu' jix ey kaan naj ey smaan tu' sattaj naj. Jix yalon jaxca ti': “Caw miman cha wute ja c'ul win an. Oj wak' pax jin maan tu' e ach an,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero ma c'al yal sc'ul naj chi yak' miman c'ulal, ja' ti' yet tol jix to ya can oc preso, masanta' c'al chi yak' pax smaan tumin naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ey pax wan xa yet mosoal naj jix ilon tzet jix yun naj, caw chi cus sc'ul eb yu. Yuxan jix to yal eb tet naj patrón tu' yu tzet jix yun naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Catu' jix awtele naj c'am smiman c'ulal tu' yu naj patrón tu', jix yalon naj tet naj jaxca ti': “Caw pena ja c'ul jaach moso. Jix jin jo'le q'uey masanil ja jec', yu jix jaach oc tean win an. ");
INSERT INTO knjNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yu jix wak' miman c'ulal ja win, smoo jix ja wak' miman c'ulal pax yin naj ja wet mosoal,” ẍi naj rey tu' tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Caw jix tit sjowal naj rey tu' sic'lebil. Jix aletoj naj preso yu naj rey tu'. Jix yalon naj rey tol chi ak'le castigar naj masanta' c'al chi yak' pax masanil sjec' naj tet naj rey tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ta c'am che yak' miman c'ulal yin masanil je c'ul yin spenail je yuẍtaj, je yanab chi oc e ex, c'am pax chi yak' miman c'ulal cu Mam ey ec' satcan je yin, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jix lawi yalon wan tu' Jesús xin, catu' jix el bey Galilea tu', catu' jix to yul-laj yet Judea, bey sk'axepal ec' ja' miman Jordán. ");
INSERT INTO knjNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Caw ec'al eb ánima jix tzajlo yintaj. Jix yak'on can wa'xoj sc'ul jantaj eb ya' ey. ");
INSERT INTO knjNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ey wan eb fariseo jix apni sc'atan Jesús yu yak'le yijban naj eb yin spenailal. Jix yak'on k'anlebal eb tet Jesús, jix yal eb jaxca ti': —¿Ey mi sleyal chi ske' spo'len sba winaj yetoj yistil yu yal c'al tzet yetal? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Catu' jix tak'wi Jesús tet eb jaxca ti': —¿Tumi c'am to che yil yul An Juun Tz'ibebil can oj, tol ja' tax yet jix swa'nen yul yiban k'inal ti' Dios, jix wa'nele naj winaj c'al ix ix? ");
INSERT INTO knjNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Catu' jix yalon pax can jaxca ti': “Yuxan ja' eb winaj, oj sbej can smam c'al xutx catu' oj sjunbanen ey sba eb yetoj yistil, yuxan jaxca tol junxane animail chi yun can el eb,” ẍi Dios yul An Juun. ");
INSERT INTO knjNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yuxan, man xa cawan oj eb, pero tol junxane chi yun can el eb. Yuxan ja' eb junbanebil xa yu Dios, manchej po'le ey eb yu ánima, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Catu' jix sk'anlen pax eb tet Jesús jaxca ti': —¿Pero tzet yuxan albil pax can yu naj Moisés tol chi ske' yak'on junoj an yuunal po'lebail junoj winaj tet yistil, catu' chi spo'len sba eb? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","—Yutol caw caw je na'bal, yuxan jix ẍa' naj Moisés je po'len je ba yetoj je yistil. Pero ja' tax yet jix wa'xi yul yiban k'inal yu Dios, man jaxca tu' jix yute. ");
INSERT INTO knjNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yuxan chi wal e ex, yal c'al mac txequel chi yujtetoj pax yistil, pero c'am pax smul ix chi yaoc yul sk'ab naj, catu' chi yi'on junoj xa ix naj, mul chi yun naj tu'. Ja' naj chi i'on ix spo'lenaj sba yetoj yichamil tu', mul pax chi yun naj tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Catu' jix yalon eb scuywom tu' tet naj jaxca ti': —Ta junelne c'am chi ske' spo'len sba naj yetoj yistil xin, yel mi watx' c'am chi oc kistil, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yuxan jix yal naj tet eb jaxca ti': —Pero man masanil oj ánima chi techa yu wan che yal ti'. Asanne eb chi oc Dios yetoj chi techa yu. ");
INSERT INTO knjNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ey mac man tzajan oj ye smimanil yin tax yalubal. Yuxan c'am chi oc yetbi eb. Ey mac xin, ja' yet animail chi uten yin tol c'am xa chi ske' yoc yetbi. Ey mac xin, c'am chi oc yistil yutol asanne naj Yaawil ey satcan chi yoche chi yak' servil. Ja' eb chi techa yu jaxca tu', techa ojab yu eb xin, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jix lawi jun tu' xin, catu' ey wan unin jix i'letej sc'atan Jesús yu ánima, yu sbatxban oc sk'ab naj yiban eb c'al yu chi txali naj yu eb. Pero jix tenle oc tucan sjul eb sc'atan naj yu eb scuywom. ");
INSERT INTO knjNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Catu' jix yalon Jesús tet eb scuywom tu' jaxca ti': —Cha' wej jul eb unin e in an. Manchej je ten oc tucan eb, yutol asan eb ey oc sna'bal yin Dios jaxca eb unin ey oc sna'bal yin smam xutx, asan eb ey yalon yet yoc naj a satcan Yaawil oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Catu' jix yaon atoj sk'ab naj yiban sjolom eb. Jix lawi jun tu', catu' jix toi. ");
INSERT INTO knjNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ja' yet junel, ey jun ach'e jix apni sc'atan Jesús. Jix sk'anlen tet naj jaxca ti': —Mamin, caw watx' jaach, yuxan chin k'anle e ach an, ¿tzet yetal sowalil chi wun an, catu' chi wi'on k'inale tol ey c'al yin tobal k'inal an? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¿Tzet yuxan chin ja wal watx'il an? C'am junoj mac txequel watx', asan Dios watx'. Ta cha woche cha cha' jun k'inale tol ey c'al yin tobal k'inal tu', jije ẍejbanil Dios, ẍi Jesús tet naj ach'e tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","¿Beytet wan chejbanile tu' chin jije xin? ẍi naj tet Jesús. —Manchej jaach mak'wi cam ánima. Manchej oc ja mul yul sk'ab ja wetbi. Manchej jaach elk'anwi. Manchej ja na' a k'ane yin ja wet animail. ");
INSERT INTO knjNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ey ojab yel oc apnoj ja mam ja txutx yul ja sat. Cam c'ulne eb ja wet animail jaxca cha wute ja cam c'ulnen ja ba, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Yin tax jin yali'al jix c'oli c'al jin jijen masanil wan chejbanil ti'. ¿Tumi c'am nioj xa sowalil chin jije, ch'al tu'? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Ta cha woche tol tz'ajan cha jije masanil, asi', txon can el masanil ja tzet yetal, catu' cha po'ontoj stool tu' xol eb meba', catu' oj ja cha'on ja be'omal bey satcan. Chi lawi tu' xin, catu' chach ec' c'al cuywoj wintaj an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ja' yet jix yaben naj ach'e wan tu', catu' jix paxtoj naj yin cus c'ulalil, yutol caw be'om naj sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jix lawi tu' xin, catu' jix yalon Jesús tet eb scuywom jaxca ti': —Caw yel chi wal e ex, tol ja' eb be'om, caw ya'taj yoc Naj a Satcan Yaawil oj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Chi wal pax e ex, k'inaloj junoj no' camello. ¿Tumi ta chi ske' yec' el no' yul yixal junoj acuẍa? Yel xa c'al subotaj jun tu' yintaj chi oc Naj a Satcan Yaawil oj eb be'om, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ja' yet jix yaben jun tu' eb scuywom tu', caw jix q'uey a sc'ul eb. Catu' jix yalon eb tu' jaxca ti': —Ta quey tu' jaxca tu' xin, ¿mac mi txequel oj ske' scolchai? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yuxan jix oc t'anan Jesús yin eb, catu' jix yalon jaxca ti': —Ja' jun ti', c'am ton chi ske' yu junoj ánima. Pero ja' Dios chi ske' yu, yutol masanil c'al chi ske' yu, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Catu' jix yalon naj Pedro tu' tet Jesús jaxca ti': —Wuẍtaj, jaonti', jix cu bej can masanil cu tzettaj yetal, catu' jix cu ec' c'al cuywoj ja wintaj, ¿tzet oj yun kel oc apnoj jaonti'? ẍi naj Pedro tu' tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jix yalon Jesús tet eb tu' jaxca ti': —Caw yel chi wal e ex, ja' yet oj ac'boj masanil tzettaj yetal, catu' oj je cha'on spaj je yet tu'. Ja' jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, oj jin ey chotan bey jin despacho an, bey oj txeclo el jin watx'ilal c'al jin tzejejial. Ja' jaex je lacawanil jix jex ec' c'al cuywoj wintaj ti' an, oj jex ey chotan jun jun jex bey jun jun je despacho. Oj je na'on oc yin eb ket Israelal, eb lacaweb bulanil. ");
INSERT INTO knjNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yal c'al mac chi sbej can sna, yuẍtaj, yanab, smam, xutx, yetbi, yuninal, c'al x'otx' jin ya'il oj, ja' ton eb tu', caw miman sq'uexel oj ẍa' eb. Yetoj pax oj, oj ẍa' pax k'inale tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ey eb miman yel oc apnoj cu xol tinani'. Pero ja' yet jun tiempoal chi wal tu', c'am xa nioj yel oc apnoj eb. Ey pax eb xin, c'am nioj yel oc apnoj cu xol tinani', pero ja' yet tu', caw miman xa yel oc apnoj eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yu jun tu', yuxan jix yal Jesús tet eb scuywom jaxca ti': —Oj waltej e ex tzet chi yun yel oc eb ánima yet ey oc Naj a Satcan, Yaawil oj eb. Ja' junel ey jun naj patrón, ja' yet jun sk'inib jix to naj seyon jaywan oj chi mulna bey awbil an yuva naj. ");
INSERT INTO knjNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Jix ilcha eb xin, catu' jix yak'on strato yetoj eb. Jix yalon naj tet eb tol jun denario oj tolanele sc'u jun jun eb yu naj. Catu' jix chejletoj eb bey smulnail tu' yu naj. ");
INSERT INTO knjNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ja' yet a las nueve jix eltoj naj ec'ab txombal. Catu' jix yilon yin wan winaj c'am smulnail. ");
INSERT INTO knjNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Catu' jix yalon naj tet eb jaxca ti': “Ta che yoche chex mulnai, asi' wej mulna wintaj an. Oj wak' jantaj smoo chi wak' yu je mulnail tu' an,” ẍi naj tet eb. Catu' jix to eb mulna yu naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jix eltoj naj patrón ec'ab junel xa yet chuman c'u, catu' jix yak'on trato yetoj jaywan xa jaxca c'al jix yute yak'on strato yetoj eb jix oc yin mulanil yet a las nueve. Ja'c'ala' jix yun yet a las tres. ");
INSERT INTO knjNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jix to naj ec'ab junel xa yet a las cinco bey txombal. Ey wan xa winaj c'am smulnail jix yil titu'. Catu' jix yalon tet eb tu' jaxca ti': “¿Tzet yuxan tu' c'al ey jex ec' titi' yet chi ec' c'u? ¿Tumi c'am nioj je mulnail?” ẍi naj patrón tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“C'am, yutol c'am mac chi cu ochen yin mulnail on,” ẍi eb tet naj. “Ta quey tu' xin, asi' wej mulna bey jin tx'otx'. Oj wak' jantaj ja tool smoo cha wi',” ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ja' yet jix k'ejbi, jix yalon naj patrón tet scaporal jaxca ti': “Awtetej eb jin mulnawom, catu' cha wak'on stool sc'u eb. Ja' eb tzunan xa c'al jix oc yin mulnail cha tolane babel. Catu' ja' eb babel jix oqui, tzunan xa cha tolane eb,” ẍi naj patrón tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Yuxan ja' eb yey c'ualil xa jix oc yin mulnail tu', ja' eb jix babi juli. Jun denario stool eb jix ẍa'. ");
INSERT INTO knjNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jix lawi tu' xin, jix jul eb seb jix oc yin mulnail tu'. Ja' yet jix jul eb tu', ja' sna'on eb tol yel miman stool eb oj ẍa'. Pero tol ja'c'ala' jun denario ch'en jix ẍa' eb. ");
INSERT INTO knjNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ja' yet jix lawi ẍa'on stool eb tu', catu' jix yak'on jowal eb yetoj naj patrón tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jix yal eb jaxca ti': “Ja' eb naj tzunan xa jix jul mulnail ti', junxane hora jix mulna eb naj. Pero laan pax stool eb naj jix yi' ketoj jon, jaon jix techa c'al ec' c'u ku ti' xol k'ak',” ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Catu' jix yalon naj tet jun jun eb naj tu' jaxca ti': “Jaach wamigo, c'am chin q'uextoj tzet jix wal an. ¿Tumi man jun denario oj jix kute cu trato xin? ");
INSERT INTO knjNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yuxan cha' ja tool ti', paxantoj. Chi el yin jin c'ul wak'on stool eb tzunan xa c'al jix oc yin mulnail ti' jaxca je tool chi wak' ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Jainti', ey walon wet chi wak'on jin tumin jaxca bey chi el yin jin c'ul. Ma ske' stit ja jowal win an, yutol watx' chi wute jin c'ul tet junoj mac txequel,” ẍi naj patrón tu' tet eb naj. ");
INSERT INTO knjNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yuxan, ja' eb c'am nioj yel oc apnoj tinani', yel miman oj yun yel oc eb. Jal eb miman yel oc apnoj tinani', c'am xa yel oc apnoj eb titu'. Ec'al mac awtebil yu Dios, pero jaywanne mac sic'bil el oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ja' yet lalan yatoj Jesús yetoj eb ánima yul sbeal conob Jerusalén, jix yawten el eb lacawan scuywom xol eb, jix yalon tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Ilala, lalan katoj bey Jerusalén ti'. Jainti', cax c'al Ak'bil Wopiso yu Dios xol eb ket animail ti', pero oj jin ale oc yul sk'ab eb yaawil yak'omal xaambal tet Dios, c'al yul sk'ab eb cuywam yin sley Moisés. Catu' oj yak'on elol camich eb wiban titu'. ");
INSERT INTO knjNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Catu' oj jin yaon oc yul sk'ab eb man Israel oj. Oj jin sbuchon eb. Oj jin smak' eb. Oj jin locbale a yin culus yu eb. Pero ja' yet yox c'ual oj jin pitzc'unele a oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jix apni eb sc'aal naj Zebedeo yetoj c'al xutx sc'atan Jesús, ja' ton naj Jacobo, yetoj naj Juan. Jix ey kaan ix txutxe tu' sattaj Jesús yutol ey tzet chi yoche sc'ul chi sk'an tet. ");
INSERT INTO knjNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Catu' jix yalon Jesús tet ix jaxca ti': —¿Tzet cha woche cha k'an e in an? ẍi naj tet ix. —Ja' yet oj jaach oc yaawil, tol oj wal cha cha' ey chotan eb wune' ti' ja c'atan, junoj bey ja watx' k'ab, junoj bey ja q'uexan, ẍi ix tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Catu' jix yalon Jesús tet eb jaxca ti': —Jaexti', c'am chi na'cha el je yu tzet che k'an e in an. ¿Oj mi techa je yu je yak'le porobal jaxca oj jin utele oj? Ja' tzet oj jul wiban, jaxca tol chin ak'le bautizar yu. ¿Yuxan ta oj techa je yu? ẍi Jesús tet eb. —Oj techa oj, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Yel toni oj jex ak'le porobal jaxca oj yun wak'le porobal. Jaxca sya'il oj ec' el wiban an, quey tu' sya'ilal oj ec' el je yiban. Pero jainti', c'am walon wet jex jin chotban ey bey jin watx' k'ab ma bey jin q'uexan. Yutol jix wa'nele wan lugar tu' yu cu Mam Dios yu mac txequel eb oj ey chotan titu'. Yuxan, oj yak' tet eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ja' yet jix yaben jun ti' eb laonwan xa cuywom tu', jix tit sjowal eb yin eb cawan tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yuxan jix yambale oc bulan eb lacawan yu Jesús, catu' jix yalon tet eb jaxca ti': —Tol je yotaj xa, ja' eb ey oc yaawil bey jun jun mimej conob, chi c'al yak' mandar eb. Quey pax tu' eb mimej winaj xol conob, yaaw xa c'al chi yute sba eb yiban ánima. ");
INSERT INTO knjNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero ja' je xol jaexti', man jaxca oj tu' oj yune'. Ta ey mac chi yoche caw miman yopiso je xol, sowalil chi oc yak'omal oj servil eb yet cuywomal masanil. ");
INSERT INTO knjNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yetoj pax oj, ta ey mac je xol chi yoche tol miman yel oc apnoj, sowalil chi oc mosoal xol eb yet cuywomal. ");
INSERT INTO knjNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ila jin, jain Ak'bil Wopiso yu Dios xol eb ket animail ti', man yu oj wak'le servil yuxan jix jin jul an, pero yu wak'wi servil. Jix jin jul yu wak'on jin ba cam oj, yet watx' ec'al mac txequel chi colcha can el wu an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ja' yet jix el eb bey Jericó bey ey ec' eb tu', ec'al ánima jix oc tzajan yintaj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ey cawan winaj c'am chi ske' yilwi chotan ey sti' be. Ja' yet jix yaben eb tol ja' Jesús chi ec' el titu', jix a yaw eb yin yipal, jix yalon eb jaxca ti': —Mamin, jaach yic'aal naj David, ok' ja c'ul kin on, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Catu' jix tenchanele eb yu eb ánima tu', yet watx' chi tz'ini eb. Pero tol yel xa c'al jix a sjowal yel yaw eb: —Mamin, jaach yic'aal naj David, ok' ja c'ul kin on, ẍi eb tet Jesús junel xa. ");
INSERT INTO knjNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Catu' jix oc linan naj Jesús tu'. Jix yawtentej eb Jesús sc'atan, catu' jix yalon tet eb jaxca ti': —¿Tzet che yoche chex wute an? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Mamin, chi koche chi cu ilwi can a ja wu, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Catu' jix ok' can sc'ul Jesús yin eb. Jix yaon oc sk'ab naj yiban sbak' sat eb. Jix jajcha can sat eb yet jun txolan tu' yu naj. Jix lawi tu' xin, jix tzajlo eb yintaj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ja' yet lalan xa yapni Jesús yetoj eb scuywom bey scawilal conob Jerusalén, jix apni eb bey conob Betfagé, yin sc'ul wonan Olivo. Catu' jix ẍejon baboj cawan eb scuywom Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jix yalon naj tet eb jaxca ti': —Baban nej toj bey jun aldea cu sattaj toj ti'. Ja' tu' oj je yil jun no' txutxe burro, txuan oc no' yetoj jun xa no' ach'e xa. Che ti el no' catu' che yi'ontej no' titi'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ta ey mac txequel chi alon e ex, che yal tet eb jaxca ti': “Ey tzet oj oc no' yu naj Kaawil,” je chi tet. Catu' oj jajletej no' e ex yin eymanil, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Quey ton tu' jix yun xin, yet watx' chi yun tzet tz'ibebil can yu naj ẍejab Dios yet peyxa, yet jix yalon can jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Je chi tet eb a conob Sión jaxca ti': “Ila sjul je Reyal je xol. Chi jul yin yeynajil yiban no' burro. Ey a yiban no' ach'e burro,” je chi, ẍi yul An Juun Tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Catu' jix to eb cawan cuywom tu'. Jix sjijen eb tzet jix yal Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jix yi'ontej no' txutxe burro tu' eb yetoj no' ach'e xa tu' tet Jesús. Jix yaon oc wan spichil eb cuywom tu' yiban no' s'aam oj. Catu' jix a Jesús yiban no'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ja' yet lalan sbey eb tu', ec'al eb ánima chi slitx'ba ey spichil yul sbe. Ey mac txequel xin, sk'ab te' chi bet tzoc'tej, catu' chi yaon ey yul sbe naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ja' jantaj eb babel sattaj, c'al jantaj eb tzajan yintaj jix ẍa'on el yich eb yel yaw jaxca ti': —Tit ojab swatx' c'ulal Dios yiban jun yic'aal naj David ti'. Kal wej watx' k'ane tet jun chejbiltej yu naj Kaawil ti'. Kal wej yu diosal tet Naj a Satcan, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ja' yet jix apni Jesús bey conob Jerusalén, jix a somna masanil eb ánima, jix sk'anlen eb jaxca ti': —¿Mac txequel jun chi jul ti'? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ey eb jix alon jaxca ti': —Ja' ton ẍejab Dios, Jesús a Nazaret yul yet Galilea, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jix lawi jun tu' xin, jix octoj Jesús yul Stemplo Dios. Jix yujten eltej eb chi txonwi, c'al eb chi manwi titu'. Jix stenon a pac'laboj smeẍa eb q'uexom tumin, c'al ẍila eb txonom uch. ");
INSERT INTO knjNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jix yalon tet eb jaxca ti': —Albil can yu Dios yul An Juun Tz'ibebil can jaxca ti': “Ja' jin na an, Snail Txa oj yija,” ẍi An Juun tu'. Pero jaexti', jaxca c'al junoj na ch'en bey chi sc'uba el sba eb elk'om, quey tu' che yute, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ja' yet ey ec' naj yul templo tu', ey eb c'am chi ske' yilwi jix apni sc'atan naj, yetoj eb c'am chi ske' sbeyi. Jix wa'xi can eb yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero ja' yet jix yilon wan milagro tu' eb yaawil eb yak'omal xaambal tet Dios, yetoj eb cuywam yin sley Moisés, catu' jix yaben eb yel yaw wan ach'e c'al wan k'opo tol chi yal jaxca ti': “Tit ojab swatx' c'ulal Dios yiban jun yic'aal naj David ti',” ẍi eb. Jix tit sjowal eb sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jix yalon eb tet Jesús jaxca ti': —¿Chim ja wab tzet chi yal wan ach'e c'al wan k'opo ti'? ẍi eb tet Jesús. —Chi ton wab an. ¿Tumi c'am to che yil yul An Juun Tz'ibebil can bey chi yal wan chi yal eb ti'? Bey chi yal jaxca ti': Ja' eb unin, eb watx' xa, c'al eb chi to txutxwi, ja' eb jix ja wak' k'anab yalon watx' k'ane e ach. Quey tu' yalon can yul An Juun Tz'ibebil can tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jix lawi tu' xin, jix bejle can eb yu naj, catu' jix to naj. Jix el bey Jerusalén tu' catu' jix apni bey Betania. Ja' tu' jix ec' ak'bal yu naj titu'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ja' yet jun xa sk'inibalil, yet lalan spaxtoj Jesús bey Jerusalén, catu' jix tit swail. ");
INSERT INTO knjNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jix yiloni tol ey jun te' higo sti' be. Jix to naj sc'atan te', pero c'am junoj sat te' jix ilcha yu naj. Asan xaj te' ey. Yuxan jix yal naj tet te' jaxca ti': —C'am xa bak'in oj ja wak' ja sat, ẍi Jesús tet te' higo tu'. Catu' ja' yet jun txolan tu' jix taj xa c'al el te'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ja' yet jix yilon eb scuywom jun tu', caw jix q'uey a sc'ul eb: —¿Tzet jix yun staj el jun te' ti' yin junoj txolan? ẍi eb jix sk'anlen eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","—Caw yel chi wal e ex, ta tol che yaoc Dios yin je c'ul, catu' c'am nioj che yak' caab c'ulal, yal c'al tzet oj ske' je yu. Man asanne oj jaxca tzet jix wute jun te' ti', oj ske' je yu. Pero cax c'al che yal tet jun wonan ti': “Elan titi', k'oj eytoj ja ba xol ja' mar,” ta je chi tet, oj ske' je yu. ");
INSERT INTO knjNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Catu' yal c'al tzet oj je k'an yet oj jex txaloj, oj ak'le e ex, ta tol che yaoc yin je c'ul, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Catu' jix oc Jesús yul stemplo Dios. Jix cuywa tet eb ánima yul tu'. Jix apni eb yaawil yak'omal xaambal eb Israel yetoj eb yicham winajilal eb Israel tu' sc'atan naj catu' jix sk'anlen eb tet naj jaxca ti': —¿Tzet ja wopiso yuxan jix ja wun wan tu' ewi? ¿Mac txequel jix ak'on ja wopiso tu'? ẍi eb tet Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Catu' jix yalon Jesús tet eb jaxca ti': —Ey pax jun tzet oj jin k'anle el e ex. Ta oj je yal e in an, catu' oj walon e ex mac jix ak'on wopiso ti' yuxan chi wun wan ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Al wej e in an, ¿mac jix ak'on yopiso naj Juan yin yak'on bautizar ánima? ¿Dios mi jix ak'on tet ma ja' ánima? ẍi Jesús tet eb. Catu' jix c'oli yalonten eb xol tu' yu jun tzet jix sk'anle tu', jix c'oli yalon eb jaxca ti': —¿Tzet chi kute cu pajtzen tet? Yutol ta chi kala, tol ja' Dios jix ak'on yopiso naj Juan tu', “¿tzet yuxan ma je yaoc yin je c'ul xin?” ẍi mi e on. ");
INSERT INTO knjNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero ta chi kala, tol ánima jix ak'on yopiso tu', caw ey smey yu eb ánima, yutol ja' naj Juan tu' caw ẍejab Dios sna'on ánima masanil, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yuxan jix yalon eb jaxca ti': —Man kotaj oj, ẍi eb tet Jesús. —Ta quey tu' xin, man pax oj wal e ex mac jix ak'on wopiso, yuxan chi wun wan tzet yetal ti', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Catu' jix yalon Jesús tet eb jaxca ti': —¿Tzet ẍi je c'ul yu jun k'aneal oj waltej ti'? ẍi Jesús tet eb. Ey jun winaj ey cawan sc'aal. Jix yalon tet naj babel winaj jaxca ti': “Jaach jin C'aal, asi', mulnail bey cu mulnail tinani',” ẍi naj mame tu' tet sc'aal. ");
INSERT INTO knjNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“C'amaj, c'am chin to jainti',” ẍi naj c'aale tu' tet smam tu'. Pero ja' yet juneb xa tu' xin, jix sna'on sba sc'ul catu' jix toi. ");
INSERT INTO knjNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jix lawi jun tu' xin, catu' jix yalon naj tet naj tzunan unin jaxca c'al jix yute yalon tet naj babel. “Ye xin Mamin, oj jin toj,” ẍi naj c'aale tu': Pero ma toj pax naj. ");
INSERT INTO knjNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tinani' xin, chin k'anle e ex, ¿mac junoj eb naj c'aale tu' jix jijen tzet jix yal smam tu'? ẍi Jesús tet eb. —Ja' naj babel unin jix sjije tzet jix yal smam tu', ẍi eb. Catu' jix yalon Jesús tet eb jaxca ti': —Caw yel chi wal e ex, ta oj oc Naj a Satcan je Yaawil oj, babel oj oc eb tejom el tolabal c'al eb ix amul ix je sattaj. ");
INSERT INTO knjNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yutol ja' naj Juan Bautista tu', jix yal e ex tzet watx' che yute je wa'nen je beybal, pero ma je yaoc yin je c'ul tzet jix yala. Pero la, ja' eb tejom el tolabal c'al eb ix amul ix jix yaoc eb yin sc'ul tzet jix yala. Cax c'al jix je yil tzet jix yute sna'on sba eb yet jix sna' sba sc'ul eb yin spenail, pero ma je na' je ba yetoj eb. Ma je yaoc yin je c'ul tzet jix yal naj Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ab wej jun xa k'aneal oj waltej ti' an xin: Ey jun winaj jix yaw uva bey sat jun x'otx', catu' jix oc colal yinlaj. Jix swa'nen jun jolan bey oj stec' el yal yuva tu'. Jix tz'ajon pax a jun ilbal uva xol tu'. Jix lawi tu' xin, jix yaon can toj jun x'otx' tu' yetoj c'al yawo maanil tet wan eb mulnawom winaj. Catu' jix to ec'ab bey jun xa lugar naat. ");
INSERT INTO knjNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ja' yet jix a apnoj stiempoal syambale a an, jix ẍejontoj wan ẍejab naj yu sto ẍa'on eb jantaj yet naj t'inan yi'on tet eb naj jix maanen can tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero ja' yet jix apni eb xin, jix mi'cha eb chejab yu eb mulnawom tu'. Ey jun jix mak'le yu eb. Ey jun xa xin, jix cam xa c'al yu eb. Jal jun xa xin, tol jix k'ojch'ennele yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jix ẍejontoj wan xa eb ẍejab naj a tx'otx' tu'. Ec'ban sbisil eb yintaj eb babel tu', pero ja'c'ala' jix utele eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Catu' jaxa naj c'aale jix chejletoj. “Oj xiw eb tet jun jin c'aal ti' an,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero ja' yet jix yilon eb naj mulnawom tu', tol ja' naj c'aale tu' chi apni, jix slatinen el sba eb, catu' jix yalon eb jaxca ti': “Ja' yet oj cam naj smam naj ti', ja' oj i'on can jun tx'otx' ti' sattaj oj. Cu mak' wej cam oj, yet watx' jaon xa chi ki' can jun tx'otx' ti',” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yuxan asanne c'al jix apni naj sc'atan eb, catu' jix sac'ontej eb, jix sjutxon el naj eb sti' el tx'otx' tu', catu' ja' titu' jix mak'le cam naj yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","¿Tzet oj utele eb mulnawom tu' yu naj a tx'otx' tu' yet oj jul naj che na'? ẍi Jesús tet eb fariseo tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—Oj ak'le cam masanil wan ánima pena tu' yu naj yet oj jul oj. Catu' oj yaon can toj x'otx' tu' maanil junel xa tet wanoj xa mulnawom tol yel oj yak' jantaj yet naj t'inan chi yi' yin c'al stiempoal, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yuxan, jix yal pax Jesús tet eb jaxca ti': —¿Tumi c'am to bey che yil yul An Juun Tz'ibebil can oj tzet oj jin utele el oj bey chi yal jaxca ti'? Ey jun ch'en jix yintajne el eb wa'nem na. Ja' ton jun tu' yel jix oc yopiso. Ja' naj Kaawil jix unen jun tu', yuxan, ja' yet chi kiloni, caw chi q'uey a cu c'ul yu, ẍi yul An Juun Tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yuxan, chi wal e ex, tol c'am xa je yalon je yet yoc Naj a Satcan je Yaawil oj. Tx'oj xa animail oj oc je q'uexel oj. Ja' ton eb tu' laan jaxca eb oj ak'on yuca' tx'otx' tx'otx' tet naj a tx'otx' tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yal c'al mac chi smak' ey sba yiban jun ch'en tu', coc' xa c'al chi yun sk'atoj. Quey tu' oj yun yel oc eb chin intajnen el oj. Jal mac oj jin na' oc yin, jaxca junoj mac txequel chi ey q'uey jun ch'en tu' yiban, coc' xa c'al chi yuntoj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ja' yet jix yaben wan k'aneal ti' eb yaawil yak'omal xaambal eb Israel tet Dios, yetoj eb fariseo tu', jix na'cha el yu eb tol ja' eb chi al-lei. ");
INSERT INTO knjNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yuxan jix yoche eb jix mi'cha Jesús. Pero chi xiw eb tet eb ánima. Yutol ja' Jesús tu', ẍejab ton Dios yul sat ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jix yaltej jun xa sk'aneal ti' Jesús tet eb. Jix yalon jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Oj waltej e ex, tzet chi yun yel oc eb ánima chi oc Naj a Satcan Yaawil oj. Ey jun rey jix yaoc sk'inal jun sc'aal yet jix nupi. ");
INSERT INTO knjNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jix c'al ẍa' el yich jun k'in tu', catu' jix ẍejontoj eb ẍejab to yawten eb, eb awtebil xa ta' a'. Pero ma yal sc'ul eb jix apni bey jun k'in tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yuxan, jix yalon naj tet wan xa eb ẍejab jaxca ti': “Asi' wej, al wej tet eb awtebil xa c'al ta' wu tu' an, tol watx' xa ye slo'be eb tol oj low eb titi'. Jix wak' ak'le cam jayc'on no' wacax yetoj wan no' caw lotzebil. Caw watx' xa ye masanil, yuxan asi' al wej tet eb, tol chi tit eb yin eymanil bey jun nupil ti',” ẍi naj rey tu' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Jix to eb ẍejab naj tu' yaloni. Pero ma c'al ta' sjije eb awtebil tu' sjuli. Ey jun tol jix to yil can yawo bey x'otx'. Ey jun xa jix to yil can snegocio. ");
INSERT INTO knjNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jal wan xa eb xin, jix mitx'le can eb ẍejab naj rey tu' yu eb. Jix mak'le eb yu eb, masanta' c'al jix cam eb ẍejabwom tu' yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ja' yet jix yaben naj rey tu', caw jix tit sjowal naj. Yuxan jix ẍejtoj wan eb soldado naj, jix bet ak'le cam wan ánima tu', catu' jix nusle tz'a' sconob eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jix lawi jun tu' xin, catu' jix yalon tet wan xa eb ẍejab jaxca ti': “Watx' xa ye masanil tzet t'inan chi k'anle yu jun nupil ti'. Pero ja' eb awtebil tu', man smoo oj eb sjuli. ");
INSERT INTO knjNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yuxan, asi' wej yul-laj calle. Jantaj c'al mac che yil yin che chejtej bey jun k'in ti',” ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jix to wan xa eb chejabwom tu' yul-laj calle xin. Ec'al mac txequel bey jix yal eb. Ey eb pena. Ey eb watx' jix apni oc oj. Jun txolan catu' jix no jun na bey ey oc k'in tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Catu' jix octoj naj rey tu' yul sna, yu yilon eb jix apni tu'. Jix yilon naj tol ey jun winaj man ey oj oc spichil yet nupil yu naj, ");
INSERT INTO knjNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","yuxan jix yal naj rey tu' tet naj jaxca ti': “Jaach wamigo, ¿tzet yuxan comon c'al chach octej bey nupil ti'? Ila tol man ey oj oc ja pichil yet nupil,” ẍi naj rey tet. C'am xa c'al tzet jix yal naj. ");
INSERT INTO knjNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Catu' jix yalon naj rey tu' tet wan eb smoso ey ec' yetoj titu' jaxca ti': “C'al wej ey yajan jun winaj ti' c'al sk'ab. Catu' che yi'on a oj, chi to je k'ojon can eltoj xol k'ej k'inal. Ja' titu' oj ok' oj, catu' oj natx'atx' oj ye yu sya'il,” ẍi naj rey tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Chi yal yel oc apnoj jun sk'aneal ti', tol ec'al mac txequel awtebil yu Dios, pero jaywanne mac sic'bil el oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jix lawi tu' xin, catu' jix to eb fariseo tu'. Jix sna'otanen eb yin Jesús, yu yak'len yijban naj eb yin spenail yu junoj tzet yetal chi yal naj, catu' chi yak'on queja eb yaloni. ");
INSERT INTO knjNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yuxan jix ẍejtoj jaywan scuywom eb sc'atan Jesús, yetoj jaywan eb spartido naj Herodes. Jix bet yalon eb jaxca ti': —Jaach cuywam kotaj sic'lebil tol yel c'al cha wala. Kotaj pax oj, tol yel c'al cha wute pax cuywa ja ba yin jun beybale chi yoche Dios. Catu' jun laan c'al cha wute ja c'ul yin ánima yutol laan c'al yel oc apnoj eb yul ja sat. ");
INSERT INTO knjNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Tzet ja chi jaachti'? Ja' ch'en tumin chi k'anle el e on yu naj yaaw bey Roma, ¿ey mi sleyal chi kak'a, ma c'amaj cha na'? ẍi eb tet. ");
INSERT INTO knjNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero yotaj xa Jesús tol man watx' oj tzet lalan sna'on oc eb yin. Yuxan jix yal naj tet eb jaxca ti': —Jaexti', caw caab sat jex. ¿Tzet yuxan che yak'le jin je yijban yin spenail? ");
INSERT INTO knjNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tx'ox wej ch'en tumin chi ak'le tet naj yaaw tu' e in an, ẍi naj tet eb. Catu' jix tx'oxon jun denario ch'en tumin tu' eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Catu' jix sk'anlen naj tet eb tu' jaxca ti': —¿Mac ey yechel sat ey oc yin ch'en ti'? ¿Mac ey oc sbi yin ch'en? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Ja' ton yechel naj yaaw bey Roma, c'al sbi naj, ẍi eb. —Ak' wej tzet yetal yet c'al ta' naj yaaw tu' tet xin, jal tzet yetal yet c'al ta' Dios, ak' wej pax tet, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ja' yet jix yaben eb wan tu', tu' c'al jix q'uey a sc'ul eb. Catu' jix el eb sc'atan naj, jix to eb. ");
INSERT INTO knjNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ja' c'al oc yet jun c'u tu', ey wan eb saduceo jix apni sc'atan Jesús. Ja' eb chi aloni tol c'am chi pitzc'u a eb camnaj. Yuxan jix sk'anle eb tet naj jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Jaach cuywam, jix yal can naj Moisés yul An Juun jix s'ibe can jaxca ti': “Ta ey junoj winaj c'am to yuninal chi ali, catu' chi cami, sowalil ja' junoj xa yuẍtaj chi i'on can a yistil, catu' chi el yuninal yetoj ix, jaxca tu' xin, chi yi' el yic'aal yuẍtaj naj,” ẍi can Moisés tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ja' junel, ja' cu xol ti' jon, ey jujwan winaj, yuẍtaj c'al sba eb. Jix oc yetbi naj babel winaj, pero jix camtoj naj. C'am c'al junoj yuninal naj jix el can oj. Ja' naj tzunan yintaj naj babel tu' jix i'on can ix. ");
INSERT INTO knjNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pero jix cam pax naj, ja'c'ala' c'am yuninal naj jix el can oj. Ja'c'ala' quey tu' jix yun naj yet yox, masanta' c'al jix lawi ec' ix ix tu' sc'atan eb naj sjujwanil, ja'c'ala' jix yun eb naj. ");
INSERT INTO knjNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Jix lawi scamtoj eb naj sjujwanil xin, catu' jix cam pax ix ix tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ja' yet oj pitzc'u a eb camnaj tu' xin, ¿mac txequel naj ey yistil ix sic'lebil? Yutol jix il-le ix yu eb naj jujwan tu', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Catu' jix yalon Jesús tet eb saduceo tu' jaxca ti': —Jaexti', che yak' q'ueytoj je ba, yutol man je yotaj oj tzet ẍi yul An Juun Tz'ibebil can oj. Man pax je yotaj oj jantaj yipal Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yutol ja' yet oj pitzc'u a eb camnaj tu', ma xa yil-le sba eb titu'. C'am mac oj yatoj scutz'in alibeal. Yutol jaxca xa eb ángel bey satcan oj yun eb. ");
INSERT INTO knjNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Man to c'al je yotaj oj pax oj, tol oj pitzc'u pax a eb camnaj. ¿Tumi c'am to che yil yul An Juun Tz'ibebil can tu' tzet albil can yu Dios e ex, yet chi yal jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Jain ton ti', Sdiosal jin naj Abraham, Sdiosal jin naj Isaac, Sdiosal jin naj Jacob,” ẍi can oj. Yuxan cax c'al camnaj xa eb, kotaj, tol man junelne oj jix cam el eb. Yutol kotaj tol ja' Dios man Sdiosal oj eb camnaj, pero Sdiosal eb iquis. Jaxca tu' jix x'ox Jesús yil eb tol oj pitzc'u a eb camnaj. ");
INSERT INTO knjNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ja' yet jix yaben wan ti' eb ánima, caw jix q'uey a sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ja' yet jix yaben eb fariseo, tol ma ske' spajtzen eb saduceo tet Jesús, catu' jix syamba sba eb yin. ");
INSERT INTO knjNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ey jun xol eb tu' caw cuywam yin sley Moisés. Jix yochen jix yijban Jesús yin spenail, yuxan jix tz'aj sk'anlen naj tet naj jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Jaach cuywam, beytet junoj chejbanil yul sley Moisés ec'ban yel oc apnoj yintaj masanil wanoj xa? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Catu' jix yalon Jesús tet jaxca ti': —Cam c'ulne wej naj Kaawil cu Diosal yin masanil je c'ul yin masanil je pixan, c'al yin masanil je na'bal. ");
INSERT INTO knjNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ja' ton jun chejbanile ti', ec'ban yel oc apnoj yintaj masanil. ");
INSERT INTO knjNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ey jun xa txen xa man laan oj yel oc apnoj jaxca jun ti', tol chi yal jaxca ti': “Cam c'ulne wej je yet animail, jaxca che yute je cam c'ulnen je ba jun jun jex,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ta chi cu jije caab chejbanile ti', jaxca tol lalan cu jijen masanil ẍejbanil Dios, c'al masanil jantaj tzet tz'ibebil can yu eb ẍejab Dios, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yaman to ec' eb fariseo tu', catu' jix sk'anlen Jesús tet eb: ");
INSERT INTO knjNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Tzet ẍi je c'ul yin naj Cristo? ¿Mac ey yic'aal che na'? ẍi Jesús tet eb. —Yic'aal naj David, ẍi jun tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Pero ja' naj David tu', ak'bil yal yu Santo Espíritu, tzet utbil tol ja' jun Cristo tu', Yaawil naj David yei, jix yal jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Jix yal Dios Kaawil tet naj Waawil jaxca ti': “Eyan chotan bey jin watx' k'ab an, masanta' c'al oj can eb ja cajat ja walan wu an,” ẍi Dios tet naj Waawil, ẍi naj David tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Quey tu' jix yute yalon can naj David, pero tzet utbil tol ja' naj Cristo Yaawil yala. Ma ske' asanne oj tol yic'aal naj David yei, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","C'am junoj eb jix ske' spajtzen tzet jix yala. Yuxan, yet tax c'al tu', c'am junoj mac txequel chi stec'ba sba sk'anlen junoj xa tzet yetal tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jix lawi jun tu' xin, catu' jix yalon Jesús tet eb ánima c'al tet eb scuywom jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Ja' eb cuywam yin sley Moisés yetoj eb fariseo, ey ton yopiso eb scuywa yin sley Moisés. ");
INSERT INTO knjNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yuxan, jije wej yal c'al tzet chi yal eb catu' che beybalneni. Pero ja' sbeybal eb xin, manchej je beybalne. Yutol ja' tzet chi yal eb, toj chi sbeybalne eb. ");
INSERT INTO knjNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ja' wan chejbanil chi yak' eb, laan jaxca junoj ijatz c'am chi laccha ku. Chi syamba eb, catu' chi yak'on eb kija. Pero ja' eb xin, toj chi yoche eb chi oc lacan yin nioj. Quey tu' chi yute yak'on eb kij wan chejbanil caw ya'taj. ");
INSERT INTO knjNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Asan yu chi yoche eb tol watx' eb yul sat ánima, yuxan chi yaon oc eb wan tzet yetal watx' yili yin. Ey wan tz'um tx'uye ye bey tz'ibebil oc nioj sk'ane cu Mam Dios, chi yaoc eb yin sk'ab yetoj yin spalan. Mimej tx'uye ye chi yute oc eb. Chi yaon oc jojquiẍtaj pichile eb, jojquiẍtaj sti'laj. ");
INSERT INTO knjNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ja' bey chi oc mimej lo'o, asan bey caw watx' chi ey chotan eb. Yetoj pax bey snail sculto eb, asan bey chi ey chotan eb mimej winaj chi ey chotan eb. ");
INSERT INTO knjNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ja' yet chi ec' eb yul-laj calle, caw chi tzala eb yet chi yi'on ey sba ánima tet eb. Caw chi tzala eb yet chi al-le oc eb cuywamil. ");
INSERT INTO knjNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pero jaexti' xin, manchej je cha' chex al-le oc cuywamil, yutol junne je cuywam, ja' ton Cristo, tol jain toni. Jal jex xin, je yuẍtaj je ba, je yanab je ba je masanil. ");
INSERT INTO knjNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","C'am junoj mac txequel bey yul yiban k'inal ti' chi ske' comon c'al che yal oc je mam oj. Yutol junne je Mam, ja' ton naj ey bey satcan. ");
INSERT INTO knjNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","C'am ojab chex tzalai yet jex al-le yaawil, yutol junne je Yaawil, ja' ton Cristo, tol jain toni. ");
INSERT INTO knjNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yal c'al mac bejan c'al sc'ul yoc yak'omal oj servil je xol, ja' ton jun tu' yel miman yel oc apnoj. ");
INSERT INTO knjNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yal c'al mac chi yi' a can sba, oj utele yin yeynajil. Jal eb chi yi' eytej sba, ja' ton eb tu' oj i'le a oj. ");
INSERT INTO knjNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ja' jaex, cuywam jex yin sley Moisés ti' xin, yetoj jex jaex fariseo jex ti', caw ok'bal jex c'ule. Caab sat jex. Ila che tenoc tucan eb ánima chi yoche chi oc Dios Yaawil oj. Ma jex oc jaexti', catu' c'am che cha' pax oc eb chi yoche chi oqui. ");
INSERT INTO knjNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Jex cuywam yin sley Moisés c'al jex fariseo, caw ok'bal jex c'ule. Caab sat jex. Ila che yi' can ec' sna eb ix camnaj xa yichamil. Chi lawi tu' caw miman che yute yajan je txa, tzet utbil oj chi sna' ánima tol c'am je mul. Ja' ton yu wan tu', yuxan caw miman sya'tajil oj je cha'. ");
INSERT INTO knjNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Jex cuywam yin sley Moisés, c'al jex fariseo, caw ok'bal jex c'ule, caab sat jex. Chilan je yec' yul-laj yiban k'inal ti' yetoj yiban ja' mar, yu ec' je monten oc junoj mac txequel je yetoj yin je cuybanil. Ja' eb che yak' ganar yoc tu', tu' c'al chi etex el sna'bal eb je yu, yu je cuybanil tu'. Yel xa c'al pena chi el oc eb je yintaj, yuxan, smoo ec'ban sya'tajil oj ẍa' eb je yintaj. ");
INSERT INTO knjNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Jaexti', laan jex jaxca junoj mac txequel c'am chi ske' yilwi, chi tz'aj squetztoj junoj xa mac txequel. Caw ok'bal jex c'ule, yutol je chi jaxca ti': “Ta ey junoj mac txequel chi sloctej sbi stemplo Dios yet chi yak'on sti', man caw sowalil oj chi yun sti' tu', yutol c'am caw yel oc apnoj jun stemplo Dios tu'. Pero ta ja' sbi ch'en oro sa'beal bey stemplo Dios chi sloctej xin, sowalil chi yak' yun tzet jix yal tu' xin,” je chi. ");
INSERT INTO knjNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yuxan, caw c'am je na'bal. Jaxca tol c'am chi ske' je yilwi nioj. ¿Beytet junoj yel miman yel oc apnoj che na'? ¿Jam ch'en oro tu' xojli, ma ja' stemplo Dios tu'? Ja' ch'en oro sa'beal tu', asan yutol yet stemplo Dios ch'en, yuxan yet Dios yei. ");
INSERT INTO knjNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Che yalon pax jaxca ti': “Ta ey jun mac txequel chi sloctej sbi smeẍail xaambal bey chi atoj xaambal yet chi yak'on sti', man caw sowalil oj chi yun sti' tu'. Pero ta ja' xaambal batxan atoj yiban tu' chi sloctej sbi, caw sowalil chi yak' yun tzet jix yal tu' xin,” je chi. ");
INSERT INTO knjNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yuxan, caw c'am je na'bal. Jaxca tol c'am chi ske' je yilwi nioj. ¿Beytet junoj yel miman yel oc apnoj che na'? ¿Jam xaambal tu', ma ja' jun smeẍail bey chi atoj batxan tu'? Ja' jun xaambal tu', yutol ey xa atoj yiban meẍa tu' yuxan yet Dios yei. ");
INSERT INTO knjNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yuxan, ta ey mac chi sloctej sbi jun meẍa bey chi atoj xaambal tu', man asanne oj jun tu' lalan slocontej sbi. Pero lalan slocontej sbi masanil tzet batxan atoj yiban pax oj. ");
INSERT INTO knjNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ja'c'ala' mac chi sloctej sbi stemplo Dios, man asanne oj templo tu' lalan slocontej sbi, pero lalan pax slocontej sbi Dios yetoj, yutol asan Dios ey yet. ");
INSERT INTO knjNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ta ey mac chi sloctej sbi satcan, chi yal yel oc apnoj tol lalan slocontej sbi sdespacho cu Mam Dios, lalan slocon pax tej sbi Dios, yutol ja' bey satcan ey ec' oj. ");
INSERT INTO knjNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Jex cuywam yin sley Moisés c'al jex fariseo, caw ok'bal jex c'ule. Caab sat jex. Che yak' sdiezmoal an alawen, an ani', c'al an comino. Pero wan ẍejbanil Dios miman yel oc apnoj, toj che jije. Ja' ton wan chejbanile ti' chi aloni, tol sowalil watx' ojab chi kute cu ba, chi ok' cu c'ul yin ket animail, catu' chi kaon oc cu c'ul yin Dios. Pero ila c'am yel oc apnoj wan ti' yul je sat. Caw sowalil tol che jije wan ti', catu' che jijen pax wan xa tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jaexti', laan jex jaxca junoj mac c'am chi ske' yilwi, chi tz'aj squetztoj junoj xa mac txequel. Laan jex jaxca junoj mac txequel chi yi' atej junoj no' yali' us chi to xol slo'be, jal junoj no' camello chi tuk'le eytoj. Quey jex tu', yutol chex xiw tet wan chejbanile man miman oj yel oc apnoj. Jal wan chejbanile caw miman yel oc apnoj xin, c'am che jije. ");
INSERT INTO knjNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Jex cuywam yin sley Moisés c'al jex fariseo, caw ok'bal jex c'ule. Caab sat jex. Jaexti', laan jex jaxca junoj mac txequel asan yinlaj vaso c'al yinlaj plato chi x'a' el oj. Pero ja' yul, nonaj el yu elk'an c'al yu spenail. ");
INSERT INTO knjNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Jaex fariseo jex ti', jaxca tol c'am chi ske' je yilon nioj. Babel che sajbane yul jun je vaso tu'. Ta quey tu' che yute, tol saj yul, saj oj yun can yinlaj pax oj yul sat Dios. Chi yal yel oc apnoj tol c'am tzet pena je yin. ");
INSERT INTO knjNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Jex cuywam yin sley Moisés c'al jex fariseo, ok'bal jex c'ule. Caw caab sat jex. Laan jex jaxca junoj spantion junoj camnaj watx' yili, saj xa c'al luq'uinaj. Pero ja' yul, nonaj el yu sbajil camom, c'al yu tzet man watx' oj. ");
INSERT INTO knjNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Quey jex ton tu' xin, yutol ja' yul sat eb ánima watx' che yute je ba. Pero, caw caab sat jex yul je c'ul, catu' caw ey je penail. ");
INSERT INTO knjNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jex cuywam yin sley Moisés c'al jex fariseo, ok'bal jex c'ule. Caw caab sat jex. Jaexti' chi bet je wa'nen a spantion eb ẍejab Dios, c'al spantion eb watx' c'al jix el yuneni. ");
INSERT INTO knjNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Catu' che yalon pax oj: “K'inaloj ta ey jon xa yet jix ec' eb kichmam yet peyxa tu', ma mi cu oc yetoj eb jix mak'on cam wan eb ẍejab Dios,” je chi. ");
INSERT INTO knjNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero ja' yet che yalon jaxca tu', che tx'ox el oj tol yic'aal jex eb jix mak'on cam eb ẍejab Dios tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ja' tzet jix ẍa' el yich eb je yichmam tu' yuneni, ja' lalan je yak'on lawoj. ");
INSERT INTO knjNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Jaexti', caw jelan jex yin spenail jaxca junoj laba. ¿Tzet oj je yute je colon el je ba yul sk'ab jun sya'tajilal bey infierno? ");
INSERT INTO knjNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ab wej. Oj jin chejtoj wan eb ẍejab Dios e ex, c'al wan eb jelan yin yet Dios yetoj wan eb cuywam. Ey eb oj je yak' cam oj, oj je yaoc eb yin culus. Ey eb, tol oj je mak' yul-laj snail bey che yak' culto. Oj je yujte ec' eb bey conoblaj. ");
INSERT INTO knjNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ey ánima c'am junoj spenail tol smoo scam yu, pero jix mak'le cam eb. Ja' ton masanil eb yet tax c'al scamichal naj Abel, naj c'am junoj spenail tol smoo scam yu, masanta' c'al scamichal naj Zacarías, sc'aal naj Berequías, oj ale oc eb je mul oj. Ja' naj Zacarías tu', ja' ton naj camnaj yu je yichmam snan xol stemplo Dios yetoj smeẍail xaambal. ");
INSERT INTO knjNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Caw yel chi wal e ex, ja' scamichal masanil eb tu', oj ak'le smul oj eb ánima ey ec' tinani'. ");
INSERT INTO knjNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ja' jaexti' jex a Jerusalén ti'. Che mak' cam eb ẍejab Dios, c'al wan xa eb chejbiltej yu Dios je nan je xol che k'ojch'enne eb. Ec'al el chi woche jix jex wawtetej e in ti' an, jaxca junoj no' caẍlan chi sk'uttetej yune', catu' chi smooni, pero ma yal je c'ul. ");
INSERT INTO knjNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ab wej, ja' jun je na ti', oj can can yin tz'ininial. ");
INSERT INTO knjNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chi wal e ex, c'am xa bey oj je yil win an masanta' c'al yet oj je yalon jaxca ti': “Kal wej watx' k'ane tet naj chi juli, ja' ton naj chejbiltej yu naj Kaawil,” je chi, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jix eltej Jesús yul stemplo Dios xin. Lalan xa stoi, catu' jix sjitzon xa c'al toj sba eb cuywom sc'atan naj. Jix c'oli x'oxon wan snail stemplo Dios eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pero jix yal naj tet eb jaxca ti': —Ilala, ja' masanil wan ti', caw yel chi wal e ex an, ja' wan ch'en ch'en latz'bil a ti', c'am xa junoj oj can can yiban yet ch'enal. Masanil oj ec' bulna oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jix lawi tu' xin, catu' jix to naj bey jun wonan chi yij Olivo. Ja' yet jix ey chotan titu', jix apni eb scuywom sc'atan. Jix sk'anlen eb jaxca ti': —Chi koche cha wal e on, ¿bak'in oj jul jun jix ja wal e on tu'? ¿Tzet echele oj x'ox Dios, yet tuxa oj jaach jul oj, yetoj pax yet oj lawoj yul yiban k'inal ti'? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Catu' jix yalon Jesús tet eb tu' jaxca ti': —Caw listo che yute je ba, yet watx' c'am junoj mac txequel oj i'on eytej je sat. ");
INSERT INTO knjNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yutol ec'al mac oj jul oj, oj tz'aj yaoc jin bi yin. Oj yalon eb jaxca ti': “Jain ton Cristo jin an,” ẍi eb oj slan yalon eb. Ec'al ánima oj yi' eytej sat eb. ");
INSERT INTO knjNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Oj je yab yoc mimej jowal. Oj je yab sk'umal wan xa ian chi oqui. Pero manchej jex xiwi, yutol sowalil oj yun c'al ta' wan tu'. Asan xin, man to oj lawoj ec' yul yiban k'inal ti' yet tu', ẍi eb echele tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yutol ey wan mimej conob oj yak'le jowal yetoj yet mimej conobal. Oj yak'le jowal eb yaaw yetoj yet yaawil. Ec'al bey oj jul ya'bil. Oj jul mimej wail. Ec'al bey oj ec' quixcab. ");
INSERT INTO knjNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero ja' masanil wan tu', asan jix to yichbanil sya'tajil, ey wan xa oj jul oj. ");
INSERT INTO knjNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Jaexti', oj jex i'letoj sattaj eb yaaw, catu' oj je yilon sya'ilal yu eb. Oj jex yak' cam eb. Masanil ánima oj chichon oc sc'ul je yin wu c'al. ");
INSERT INTO knjNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ja' yet jun tiempoal tu', ec'al mac txequel oj meltzo pax yintaj junel xa. Oj yac'ulne sba eb. Oj yak'le cam sba eb. ");
INSERT INTO knjNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ec'al mac oj yal oc sba ẍejab oj Dios. Ec'al mac txequel oj etnen eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Oj a can ánima yin spenail, yuxan, ec'al eb oj sbej can scam c'ulne sba. ");
INSERT INTO knjNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ja' mac tec'an oj yute sba masanta' c'al slawubal, ja' ton eb tu' oj colcha oj. ");
INSERT INTO knjNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ja' jun watx' k'ane chi alon tzet chi yun yoc Naj a Satcan Yaawil oj eb ánima, ja' sowalil oj al-le can el bey masanil yul yiban k'inal ti', yet watx' chi yab bey jun jun conob. Catu' ja' yet tu' oj jul slawubal. ");
INSERT INTO knjNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Pero ey jun mac txequel ya'bil el yu Dios, ja' oj etnen el wan tzet yetal. Ja' naj Daniel, ẍejab Dios yet peyxa, ja' jix alon yin jun ti'. (Ja' mac chi ilon jun sk'aneal ti', na'cha ojab el yu.) Ja' yet oj je yilon jun mac txequel tu' yul stemplo Dios, ");
INSERT INTO knjNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ja' mac ey ec' bey Judea, toj ojab eb bey wonanlaj. ");
INSERT INTO knjNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ja' mac ey atoj ẍumuc spananil sna, yet oj jul jun tu', manchej xa eytej yu yi'on to eltoj nioj tzet yetal yul na. ");
INSERT INTO knjNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yetoj eb ey ec' xol smulnail, manchej xa ojab meltzo yintaj to yi'on spichil. ");
INSERT INTO knjNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ja' yet jun tiempoal tu', ok'bal c'ule eb ix mimejal xa, yetoj eb ey to yune' chi txutxwi. ");
INSERT INTO knjNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","K'an wej tet Dios tol man ojab nabil k'inal oj yet oj jex el tu', manaj sc'ual xewilal pax oj. ");
INSERT INTO knjNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yutol ja' jun miman sya'tajil oj jul yet jun tiempoal tu', c'am to bey jix ec' junel oj jaxca tu' yet tax c'al jix wa'xi yul yiban k'inal ti' yu Dios. C'am pax bey oj ec' junoj xa jaxca tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ta c'am chi smitx' oc tucan jun sya'tajilal tu', c'am junoj mac txequel oj colcha can el yul sk'ab camich. Pero yu c'al scam c'ulal Dios yin eb sic'bil xa el yu, yuxan oj smitx' oc tucan oj txenne oj yun can yajan jun tiempoal tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ta ey mac chi alon e ex jaxca ti': “Ila titi' ja' ton naj Cristo ey ec' titi',” ma “Ila titu', ey ec' Cristo titu',” ta ẍi eb jaxca tu' manchej je cha' je yabe. ");
INSERT INTO knjNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yutol ey wan eb oj tz'aj yal oc sba Cristoal oj x'ox a sba, c'al wan eb oj tz'aj yal oc sba ẍejab oj Dios. Oj tz'aj x'ox echele c'al milagro eb tzet utbil oj chi yi' eytej sat ánima eb. Oj yak'le pax eb yi'on eytej sat eb sic'bil xa el yu Dios, ta chi ske' yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yin ey oj to, catu' chi walon can wan ti' e ex an. ");
INSERT INTO knjNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yuxan, ta ey eb oj alon jaxca ti' e ex: “Ila, ey ec' Cristo bey cusiltaj tx'otx',” ta ẍi eb, caw c'am chex to je yila. Ta ey eb chi alon pax jaxca ti': “Ila ey ec' naj bey jun na,” ta ẍi eb, man je cha' je yabe. ");
INSERT INTO knjNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yutol jaxca yet chi a letzna nab caw miman txequel, chi txeclo bey masanil yul yiban k'inal ti', chi txeclo bey chi aol c'u c'al bey chi to can c'u, quey tu' oj yun xeclo jin jul an, jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an. ");
INSERT INTO knjNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yal c'al bey telan can junoj mimanile camnaj xa, ja' tu' chi syamba sba no' mij. Quey tu' oj yun je yotajne el oj yet oj jin jul yet tu' an. ");
INSERT INTO knjNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ja' yet oj lawoj ec' jun miman sya'ilal tu', oj k'ejboj el c'u, catu' oj tan yajan xaaw. Ja' weycan oj tit q'uey satcan. Yetoj wan tzet ey yipal bey satcan, oj tz'icotenele eb. ");
INSERT INTO knjNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Catu' oj txeclo a jun yechel bey satcan, tzet utbil tol jain Ak'bil Wopiso yu Dios xol eb ket animail ti' tol lalan wul an. Ja' eb ánima bey jun jun conob yul yiban k'inal ti', oj ok' eb yet oj yilon eb jin jul xol asun yetoj miman wipal c'al miman jin tzejejial. ");
INSERT INTO knjNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Oj xule ch'en trompeta yin caw ipal. Catu' jain Ak'bil Wopiso yu Dios xol eb ket animail ti', oj jin chejtej eb wángel, catu' oj ec' syamba a eb sic'bil el wu bey masanil yul yiban k'inal ti'. Oj ec' i'le a eb masanta' c'al bey chi lawi yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Na' wej tzet utbil chi yun yak'on xaj te' higo. Ja' yet chi uninbi sk'ablaj te', yet lalan xa stit sat te', je yotaj xa tol tuxa chi oc nabil k'inal. ");
INSERT INTO knjNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Quey ton tu' oj yun sna'cha el je yu yet oj je yilon sjul wan ti', na'cha ojab el je yu, tol nianxane catu' chin jul an. ");
INSERT INTO knjNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Caw yel chi wal e ex, c'am to c'al chi cam ánima ey ec' yet jun tiempoal ti', catu' oj yunen masanil wan jix wal ti' an. ");
INSERT INTO knjNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ja' satcan ti' c'al yul yiban k'inal ti', oj lawoj. Pero ja' jin k'ane, man oj ec' tzet chi wal an. ");
INSERT INTO knjNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pero c'am mac otajnen tzet c'ual c'al jantaj hora oj jin jul an. Eb ángel bey satcan, man yotaj oj eb. Jainti' Sc'aal jin Dios, pero man wotaj oj pax oj, asan Dios Mame yotaj. ");
INSERT INTO knjNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Jaxca tzet jix yun yet jun tiempoal yet ec'naj naj Noé, quey tu' oj yun yet jun tiempoal yet oj jin jul an, jain Ak'bil Wopiso yu Dios xol eb ket animail ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yutol ja' yet c'am to chi jul jun miman yax nab tu', toj ey tzet chi sna' ánima, tol chi low eb, tol chi yuc' ja' eb. Chi yil-len sba eb. C'al yaontoj scutz'in eb alibeal, masanta' c'al yet jun c'u yet jix octoj naj Noé yul te' arca. ");
INSERT INTO knjNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma na'cha el nioj yu eb, masanta' c'al jix jul jun yax nab tu', catu' jix cam eb masanil. Jaxca c'al jix yun eb yet jun tiempoal tu', quey tu' oj yun ánima yet oj jin jul an jain Ak'bil Wopiso yu Dios xol eb ket animail ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","K'inaloj ta ey cawan oj winaj junne chi mulnai. Ey jun oj i'letoj, ey jun oj can oj. ");
INSERT INTO knjNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","K'inaloj ey pax cawan oj ix lalan scawni, jun oj i'letoj, jun oj can oj. ");
INSERT INTO knjNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yuxan, caw listo che yute je ba, yutol man je yotaj oj jantaj hora oj jin jul an, jain je Yaawil jin ti' an. ");
INSERT INTO knjNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","K'inaloj junoj naj a na tinani'. Ta yotaj jantaj ak'bal chi jul junoj elk'om, caw listo chi yute sba, catu' c'am chi ẍa' oc elk'om yin sna. ");
INSERT INTO knjNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yuxan, listo c'al pax che yute je ba. Yutol ja' yet man na'an oj el jin julbal je yu, ja' yet tu' oj jin jul yin eymanil, jain Ak'bil Wopiso yu Dios xol eb ket animail ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","K'inaloj ja' junoj patrón yetoj smoso. Ja' junoj jijyom, jun ey sna'bal, ja' ton jun tu' oj yaoc yopiso yin yak'on cuenta sna yetoj masanil tzet ey eb. Pero ¿mac txequel jun jijyom tu' che na? ");
INSERT INTO knjNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ja' ton jun lalan smulna jaxca chi yoche naj patrón tu' yet oj jul junel xa. Caw watx' yet jun tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Caw yel chi wal e ex, oj yaoc naj yin yaawil yiban masanil tzet yetal ey naj patrón tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero ta ja' jun moso tu', pena sna'bal. Chi sna' tol man oj jul naj patrón tu' yin eymanil. ");
INSERT INTO knjNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yuxan chi c'oli smak'on yet mosoal. Chi ec' low yetoj eb uq'uem an. Chi uc'wi pax an yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ja' yet man na'an oj el sjul naj patrón tu' yu naj, ja' ton yet tu' oj jul oj. ");
INSERT INTO knjNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Catu' oj oc miman sya'tajil yiban naj moso tu'. Oj ali can toj naj yetoj eb yet caab satil tu'. Ja' titu' oj ok' oj, c'al oj natx'atx' oj ye yu sya'il. ");
INSERT INTO knjNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Oj wal e ex an, tzet oj yun yel oc eb ánima yet oj oc Naj a Satcan Yaawil oj eb. Ja' junel, ey laonwan eb ix k'opo ix. Jix to eb bey jun nupil yet ak'balil, jix yi'ontoj scantin eb. Jix bet eb ẍa'on sjul naj oj nupi tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ey jowan eb ix c'am sna'bal, jowan xa xin, caw jelan. ");
INSERT INTO knjNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ja' eb c'am sna'bal tu', c'am xa sobrail yaceite eb jix yi'toj, asan c'al ch'an nioj ey ey yul scantin eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jal eb ix jelan tu' xin, jix yi'toj jun xa limeta yaceite eb ix. ");
INSERT INTO knjNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ja' naj jix nupi tu', caw jix ec' hora sjul naj. Yuxan, jix tit sweyan eb ix. Catu' jix wey a masanil eb ix. ");
INSERT INTO knjNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pero ja' yet chuman wal ak'bal, ey jun mac jix awi tet eb: “Tol chi jul naj oj nupi tu'. Asi' cha' wej naj,” ẍi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Catu' jix a waan eb ix tu'. Jix yaon oc sk'ak'al scantin eb ix. ");
INSERT INTO knjNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Catu' jix yalon eb ix c'am sna'bal tu' tet eb ix jelan jaxca ti': “Ak' wej nioj je yaceite e on. Tol lalan stan el cu cantin ti',” ẍi eb tet eb jelan tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ma kak'a, ta tol chi kak' nioj je yet, ma mi yab ket catu' ma pax yab je yet. Asi', man wej nioj je yet bey chi txonlei,” ẍi pax eb ix. ");
INSERT INTO knjNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yuxan jix to eb ix sman nioj yet. Ja' yet xax to eb, catu' jix jul naj oj nupi tu'. Ja' eb listo ye yetoj scantin jix octoj eb ix yetoj naj bey nupil tu', catu' jix smajchen spuerta eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ja' yet jix jul eb ix c'am sna'bal tu', jix to awi octoj eb: “Mamin, Mamin, jajon octoj,” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero jix yalon eltej naj tet eb: “C'amaj. Caw yel chi wal e ex, ma jex wotaj an,” ẍi eltej naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yuxan, chi wal e ex, caw listo che yute je ba. Yutol man je yotaj oj, tzet c'ual, c'al jantaj hora oj jin jul jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Oj wal e ex an, tzet oj yun yel oc eb ánima yet ey oc Naj a Satcan Yaawil oj eb. Ja' junel, ey jun winaj jix to bey jun xa conob caw naat. Ja' yet tuxa chi toi, jix yawtentej eb smoso sc'atan, jix yak'on can wan ch'en stumin yul sk'ab eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ey jun naj bey jix yak' can joeb mil quetzal. Ey jun naj bey jix yak' can caab mil quetzal. Ey jun naj bey jix yak' can jun mil quetzal. Ja'ta'c'ala' sbak' satil jun jun jix yil oc oj. Jix lawi tu' xin, catu' jix to naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ja' naj moso jix cha'on can ch'en joeb mil quetzal tu', jix yak' negoicio naj yetoj ch'en. Jix yak'on ganar joeb xa mil quetzal naj yetoj ch'en. ");
INSERT INTO knjNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ja'c'ala' pax naj jix cha'on ch'en caab mil quetzal. Jix yak' pax ganar caab xa mil quetzal naj yetoj ch'en. ");
INSERT INTO knjNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jal naj jix cha'on ch'en jun mil quetzal xin, jix sjol jun jolan naj, catu' jix smujon eytoj ch'en naj. ");
INSERT INTO knjNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Peyxa tax tu', catu' jix jul naj spatrón eb tu'. Catu' jix yi'on cuenta naj yetoj eb moso yin ch'en tumin yin jun junal. ");
INSERT INTO knjNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ja' naj cha'nen ch'en joeb mil quetzal tu', ja' naj babel jix apni sattaj naj. Catu' jix yak'on can ch'en joeb mil quetzal jix yak' ganar naj tu'. Catu' jix yalon naj tet spatrón tu' jaxca ti': “Mamin, jix ja wak' can joeb mil quetzal ch'en ja tumin ti' e in an. Pero ja' tinani' xin, tol ey pax joeb mil quetzal yune' ch'en jix wak' ganar an,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Catu' jix yalon naj patrón tu' tet naj jaxca ti': “Watx' xin, caw watx' jix ja wute mulna ja ba e in an. Jix ja jije jaxca chi woche an. Yutol jijyom jaach yin nian ti', yuxan miman to c'al tzet oj wak' e ach an. Yuxan ak' tzala a ja c'ul wetoj an,” ẍi naj patrón tet naj smoso tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jix lawi tu' xin, jix apni naj cha'nen ch'en caab mil quetzal. Jix yalon naj tet spatrón tu' jaxca ti': “Mamin, jix ja wak' can caab mil quetzal ch'en ja tumin ti' e in an. Pero ja' tinani' xin, tol ey pax caab mil quetzal yune' ch'en jix wak' ganar ti',” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Catu' jix yalon naj patróne tu' tet naj jaxca ti': “Watx' xin, caw watx' jix ja wute mulna ja ba e in an. Jix ja jije jaxca chi woche. Yutol jijyom jaach yin nian ti', yuxan, miman to c'al tzet oj wak' e ach an, yuxan ak' tzala a ja c'ul wetoj an,” ẍi naj tet jun xa smoso tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pero ja' yet jix apni naj cha'nen jun mil quetzal sattaj naj xin, jix yalon naj tet naj spatrón jaxca ti': “Patrón, wotaj tol ch'aan jaach. Cha jatx' tzet man awbil oj ja wu. Tuxa c'al cha cha' sganar junoj xa ánima. ");
INSERT INTO knjNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yuxan, jix jin xiw a e ach an, jix jin mujon ch'en ja tumin tu' yul tx'otx'. Tol ja' ch'en ja tumin jix ja wak' e in an, ey ec' ch'en smasanil ti' xin,” ẍi naj tet spatrón. ");
INSERT INTO knjNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Catu' jix yalon naj patrón tu' tet naj jaxca ti': “Jaachti', moso jaach na yalbanil, pero c'am ja watx'il. Caw isa jaach. Tutun tol ja wotaj xa tol chin jatx' bey tzet man awbil oj wu an, catu' chin cha'on tzet chi yak' ganar junoj xa ánima. ");
INSERT INTO knjNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yuxan, tzet yuxan ma ja watoj ch'en jin tumin ti' maanil, catu' chin cha'on pax ch'en yetoj yune' yet chin jul ti',” ẍi naj tet naj moso tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jix lawi tu' xin, jix yalon naj tet wan eb ey ec' titu': “I' wej ec' ch'en mil quetzal tu' tet naj. Ak' wej ch'en tet naj ey laoneb mil quetzal yet tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yutol ja' mac ey yet, oj ak'le wan xa tet, yet watx' chi yak' sobra tet. Jal eb c'am wal yet, ja' nioj yet eb ey ta' a', oj i'le ec' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ja' naj moso c'am yopiso ti', chi to je k'oj can eltoj naj xol k'ej k'inal, bey oj ok' oj, c'al chi natx'atx' oj ye yaben sya'il,” ẍi naj patrón tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jain Ak'bil Wopiso yu Dios xol eb ket animail ti', oj jin jul yetoj eb wángel masanil yetoj jin miman tzejejial. Catu' oj jin ey chotan bey jin despacho. Ja' yet tu' oj txeclo el oj tol caw miman wel oc apnoj. ");
INSERT INTO knjNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Masanil ánima bey jun jun conoblaj, oj jul eb jin sattaj. Jaxca junoj naj ilom me' chi po'on el no' me' xol no' chiw, quey tu' oj wute jin po'on snan eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ja' eb jaxca tol jin me' yei, oj can eb bey jin watx' k'ab. Jal eb jaxca no' chiw yei, oj can eb bey jin q'uexan. ");
INSERT INTO knjNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jain Rey jin ti' an, oj wal tet eb bey jin watx' k'ab jaxca ti': “Jaexti', albil can e ex yu jin Mam tol oj yak' swatx' c'ulal e ex. Ocan nej wetoj bey oj wak' Yaawilal. Ja' tax yet jix wa'xi can yul yiban k'inal ti' yu Dios, wa'nebil xa c'al ta' jun ti' je yu. ");
INSERT INTO knjNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yutol ja' yet jix tit jin wail, jix jin je yak' low oj. Ja' yet jix tit jin tajin ti'al, jix je yak'on tzet jix wuc' an. Ja' yet jix jin ec'le k'ano posada, jix je yak' jin posada bey je na. ");
INSERT INTO knjNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yet c'am jin pichil, jix je yak'on jin pichil, yet ya' jin ey, jix jin ec' je yila. Ja' yet ey jin oc preso, jix bet jin je yil jin oc toj,” jin chi oj walon tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Catu' ja' eb watx' sbeybal sattaj Dios tu', oj tak'woj eb e in jaxca ti' an: “Mamin, ¿bak'ini ey ja wail jix kila, c'al ja tajin ti'al tu'? Toj ey tzet jix kak' e ach. ");
INSERT INTO knjNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Bak'ini jix kil ja wec' k'ano posada sti'laj cu na, catu' jix kak'on ja posada tu'? ¿Bak'ini c'am xa ja pichil, catu' jix kak'on ja pichil tu'? ");
INSERT INTO knjNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Bak'ini ya' jaach ey, ma bak'ini ey jaach oc preso catu' jix jaach bet kiloni?” ẍi eb, catu' oj yalon eb e in an. ");
INSERT INTO knjNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Catu' oj walon tet eb jaxca ti': “Caw yel chi wal e ex, ja' yet jix je yak'on wan watx' c'ulal ti' tet eb wuẍtaj c'al tet eb wanab, cax c'al tet eb c'am yel oc apnoj, pero chi yal yel oc apnoj tol e in jix je yune',” jin chi, oj walon tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Oj lawoj jun tu' xin, catu' oj walon tet eb ey ec' bey jin q'uexan k'ab jaxca ti': “Elan nej jaexti' jin c'atan an, yutol jow Dios je yin. Asi' wej can xol jun k'ak' c'am bak'in chi tani, bey jun lugar wa'nebil can yu Dios bey oj toj can naj diablo yetoj eb yángel. ");
INSERT INTO knjNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yutol ja' yet jix tit jin wail, ma jin je yak' low nioj. Yet jix tit jin tajin ti'al, ma je yak' nioj tzet jix wuc' an. ");
INSERT INTO knjNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Jix jin ec'le k'ano posada, pero ma je yak' jin posada. Ja' yet c'am jin pichil, c'am nioj jin pichil jix je yak'a. Yetoj pax yet ya' jin ey, c'al yet ey jin oc preso, ma jin bet je yil an,” jin chi oj walon tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Catu' oj yalon eb e in an jaxca ti': “Mamin, ¿bak'ini ey ja wail jix kila, ma ja tajin ti'al tu', yetoj yet jix jaach ec' k'ano posada, c'al yet c'am ja pichil, c'al yet ya' jaach ey tu', c'al yet preso ja wei? ¿Tumi ey bey ma cu colwa e ach xin?” ẍi eb, oj yalon eb e in an. ");
INSERT INTO knjNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pero oj wal tet eb jaxca ti': “Caw yel chi wal e ex, ja' yet ma jex colwa tet eb wuẍtaj tu' c'al tet eb wanab tu', cax c'al c'am yel oc apnoj eb, pero chi yal yel oc apnoj tol ja' e in, ma jex colwa oj,” jin chi, oj walon tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ja' eb tu', oj toj eb bey sya'tajilal yin junelne. Jal eb watx' sbeybal sattaj Dios xin, oj ẍa' sk'inal eb, tol ey c'al yin tobal k'inal, ẍi Jesucristo tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ja' yet jix lawi yalon Jesús wan ti' tet eb ánima, jix yalon jaxca ti' tet eb scuywom: ");
INSERT INTO knjNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Je yotaj xa, tol caabe xa c'al chi oc cu pascua. Jain Ak'bil Wopiso yu Dios xol eb ket animail ti', ja' ton yet tu' oj jin ale oc yul sk'ab eb oj jin aon oc yin te' culus, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ja' eb yaawil yak'omal xaambal eb Israel tet Dios, yetoj eb cuywam yin sley Moisés, c'al eb yicham winajil conob, jix syamba sba eb bey jun miman sna naj Caifás, naj sat yaawil yak'omal xaambal eb Israel tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jix slatine el eb tzet lek'ti'al oj yaoc eb yiban Jesús, tzet utbil oj chi mi'cha naj yu eb, catu' chi yak'on cam naj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jix yalon eb jaxca ti': —Ma ske' cu mitx'on yet k'in ti', yutol ey smey, oj tit sjowal eb ánima kin yu, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jix apni Jesús bey conob Betania. Jix apni bey sna naj Simón, naj ya' ey yet peyxa yu jun ya'bil chi yij lepra. ");
INSERT INTO knjNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chotan ey Jesús slowi, catu' jix apni jun ix ix sc'atan. Jix yi'tej jun ch'en net alabastro ix. Nonaj ch'en yetoj jun ambal suk'uk'i sab caw ey stool. Jix sec'on atoj ix yin sjolom Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jix yilon jun tu' eb scuywom, catu' jix tit sjowal eb yin ix. Catu' jix yalon eb jaxca ti': —¿Tzet yuxan na'ba c'al chi etex el jun ti'? ");
INSERT INTO knjNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ja' jun ambal suk'uk'i sab ti', caw ey stool. Yel watx' chi txonle el oj, catu' chi po'letoj stool xol eb meba', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ja' yet jix yaben Jesús jun tu', jix yalon tet eb jaxca ti': —¿Tzet yuxan pena che yal yin ix? Ja' jun jix yun ix e in ti' an, caw watx'. ");
INSERT INTO knjNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ja' eb meba' che yal tu', ey c'al ec' eb je yetoj. Pero jainti', c'am jin c'al ec' je yetoj. ");
INSERT INTO knjNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yin ey oj to jix yaon oc jun suk'uk'i sab ti' ix yin jin mimanil, yet watx' listo xa we an, yet chin mujle an. ");
INSERT INTO knjNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Caw yel chi wal e ex, yal c'al tzet lugaril bey yul yiban k'inal ti', bey oj al-le el sk'aneal yet colbanile, oj al-le pax el sk'aneal tzet jix yun ix ix ti', catu' oj na'letej ix, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ja' naj chi yij Judas Iscariote, naj ey oc tz'ajil oj eb lacawan scuywom Jesús, jix bet k'anab yetoj eb yaawil yak'omal xaambal eb Israel tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jix yalon naj tet eb jaxca ti': —Ta chi waoc Jesús yul je k'ab, ¿jantaj chin je tolane? ẍi naj tet eb. Jix yak'on treinta tumin plata eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yuxan, ja' yet jun c'u tu', jix ẍa' xa c'al el yich seyon tzet utbil oj yute yaon oc Jesús yul sk'ab eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ja' yet babel sc'ual jun k'in yet chi lo'le ixim pan c'am yich, jix oc joyan eb cuywom yin Jesús, catu' jix sk'anlen eb tet naj jaxca ti': —¿Beytu' cha woche chi cu wa'ne bey oj cu lowoj, yu cu na'ontej k'in pascua ti'? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Asi' bey conob. Chex to bey sna jun winaj. Che yalon tet jaxca ti': “Chi yal cu cuywam, tol nianxane tiempoal ey jin ec' oj. Yuxan ja' bey ja na ti' oj jin low yetoj jin cuywom ti', yu cu na'ontej k'in pascua,” quey tu' che yute je yalon tet naj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yuxan, jix to eb cuywom tu' jaxca jix yun yal-le tet eb tu' yu naj. Jix swa'nen tzet oj slo' eb yet pascua tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yet jix k'ejbi ey xin, jix ey chotan Jesús low yetoj eb scuywom tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ja' yet lalan slow yetoj eb, jix yalon jaxca ti': —Caw yel chi wal e ex, Ja' cu xol ti' ey jun oj jin aon oc yul sk'ab camich, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Caw jix cus a sc'ul eb yet jix yaben eb jun tu'. Yuxan jun jun eb jix sk'anle yab eb tet: —Wuẍtaj, ¿man mi jain oj wun jun tu'? ẍi eb yin jun junal tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yuxan jix yal Jesús tet eb jaxca ti': —Ja' jun mac junne ey sk'ab wetoj yul plato ey ey cu nan ti', ja' ton jun tu' oj jin aon oc yul sk'ab camich. ");
INSERT INTO knjNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jainti', Ak'bil Wopiso yu Dios xol eb ket animail ti', pero sowalil oj jin cam oj, jaxca tz'ibebil can yul An Juun Tz'ibebil can oj. Pero ok'bal c'ule jun oj jin aon oc yul sk'ab camich tu'. Yel watx' yet jun winaj tu' ta ma aloj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ja' naj Judas, naj jix aon oc naj yul sk'ab camich tu', jix yalon naj jaxca ti': —Jaach cuywam, ¿man mi jain oj cha wal tu'? ẍi naj tet Jesús. —Jaach toni, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ja' yet lalan slow Jesús yetoj eb scuywom tu', catu' jix yi'on a ixim pan. Jix yalon yu diosal tet Dios yu ixim. Catu' jix spo'on ec' xol eb tu'. Catu' jix yalon tet eb: —Low wej. Jin mimanil jun ti', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Catu' jix yi'on a jun vaso. Jix yalon yu diosalil tet Dios yu tzet ey yul jun vaso tu'. Catu' jix yak'on tet eb. —Uc' wej jun ti' je masanil. ");
INSERT INTO knjNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yutol jin chiq'uil jun ti'. Yu jin chiq'uil ti', yuxan oj yun jun ac' strato Dios. Oj el jin chiq'uil ti' yet watx' ec'al mac oj lawoj can spenail yu. ");
INSERT INTO knjNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Chi wal can e ex tinani', c'am xa bey oj wuc' yal sat an uva ti', masanta' c'al yet jun c'ual oj wuc' junel xa je yetoj titu'. Yet oj oc xa c'al cu Mam yin Yaawil, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jix sbit'nen eb jun bit' chi sbit'ne ta' eb tet Dios, catu' jix to eb bey wonan Olivo. ");
INSERT INTO knjNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jix yalon Jesús tet eb titu' jaxca ti': —Ja' yet jun ak'bal ti', oj caablaboj a je c'ul win je masanil an. Quey tu' yalon can yul An Juun Tz'ibebil can oj, bey chi yal jaxca ti': “Oj wak' cam naj ilom me'. Ja' no' me' tu', oj sajlem can toj no'” ẍi yul An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero ja' yet oj jin pitzc'u pax a oj, oj jin baboj to je sattaj bey Galilea, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Catu' jix yalon naj Pedro tet Jesús jaxca ti': —Cax c'al oj caablaboj a sc'ul masanil eb ja win, pero jainti', c'am bak'in oj caablaboj a jin c'ul, ẍi naj Pedro tu' tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—Caw yel chi wal e ach, ja' yet jun ak'bal ti', oxel xax jin ja wi' el ja win an, catu' oj ok' a no' caẍlan. Oj ja waloni tol man jin ja wotaj an, ẍi Jesús tet naj Pedro. ");
INSERT INTO knjNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Cax c'al oj jin cam ja wetoj, pero tutun ma jaach wi' el win an, ẍi naj Pedro tu' tet Jesús. Ja'c'ala' yalon masanil eb cuywom. ");
INSERT INTO knjNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jix lawi jun tu' xin, catu' jix to Jesús yetoj eb scuywom bey jun lugar chi yij Getsemaní. Jix yalon tet eb titu' jaxca ti': —Eyan nej can chotan titi'. To jin txaloj cu sattaj ti', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jix yi'on sbey naj Pedro yetoj, c'al eb cawan sc'aal naj Zebedeo. Catu' jix c'oli scus a sc'ul, c'al yoc yin tac c'ulal. ");
INSERT INTO knjNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jix yalon Jesús tet eb: —Ian chin cam yu cus c'ulal chi wab an. Canan nej titi'. Iquis ojab jex wetoj an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Catu' jix jitzontoj sba nioj xa. Jix ey kaan oj, catu' jix ey xa c'al noan sat tx'otx'. Catu' jix txali jaxca ti': —Mamin, ta chi ske' cha na', manchej jul jun sya'ilal tu' wiban an. Pero man jaxca oj chi woche jainti' an, pero jaxca ojab cha woche jaachti', ẍi Jesús yin xa. ");
INSERT INTO knjNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jix lawi tu' xin, jix jul junel xa bey jix can can eb oxwan tu', catu' jix yiloni, lalan swey eb. Yuxan jix yal tet naj Pedro: —¿Tumi c'am chi ske' je tec'ba je ba tet weyan junoj hora wetoj an? ");
INSERT INTO knjNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","I' wej el je weyan. Txalan nej, yet watx' c'am chex ey q'ueyi, yet ey mac chi yak'le jex yijban yin spenail. Ja' cu pixan, tec'an ton yei, pero ja' cu mimanil, c'am chi techa yu, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Catu' jix to naj junel xa txaloj. Jix yalon yin xa jaxca ti': —Mamin, ta c'am chi ske' tol c'am chi jul jun sya'ilal ti' wiban an, ske' ojab jaxca cha woche, ẍi Jesús yin xa. ");
INSERT INTO knjNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Catu' jix jul junel xa sc'atan eb oxwan tu', jix yiloni tol chi wey a eb, yutol caw c'am chi techa weyan yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jix can eb yu naj junel xa. Jix to txaloj yet yoxelal. Jaxca c'al jix yute txaloj sba yet sbabelal, quey tu' jix yute txaloj sba. ");
INSERT INTO knjNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jix jul junel xa sc'atan eb scuywom tu' xin, jix yalon tet eb jaxca ti': —¿Tumi ja'c'ala' je weyi? ¿Tumi comon xewilal che yune'? Ja' tinani', jix a apnoj yorail wale oc yul sk'ab eb penawom, jain Ak'bil Wopiso yu Dios xol eb ket animail ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Aan nej waan oj, toon nej. Ilala, chi jul naj oj jin aon oc yul sk'ab eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lalan to yaloni, catu' jix apni naj Judas, naj yet cuywomal sba yetoj eb naj jusluc'wan tu'. Ec'al ánima ey ec' yetoj naj. Ey eb i'bil oc espada, ey eb i'bil oc ste'. Chejbiltej eb yu eb yaawil yak'omal xaambal eb Israel tet Dios, c'al yu eb icham winaj ey yopiso xol eb Israel tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ja' naj Judas tu', naj lalan yaon oc Jesús yul sk'ab eb, jix yal tet eb tzet oj yute x'oxon oc oj, jix yal tet eb jaxca ti': —Ja' jun oj jin tz'ub el sti', ja' ton jun tu' che mitx'a, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuxan, jix sjitztoj sba sc'atan Jesús yin eymanil. Jix yalon tet naj jaxca ti': —Buenas noches, Jaach Cuywam, ẍi naj Judas tet Jesús. Catu' jix oc tz'uban yin sti' naj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","—Jaach wamigo, ¿tzet chi jul ja wune? ẍi Jesús tet naj. Catu' jix oc eb yin naj Jesús yin eymanil. Jix smitx'on naj eb. C'anani jix yute eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pero ey jun ey ec' yetoj Jesús, jix tzac' atej yespada yin eymanil. Jix tzoc'on el xiquin jun smoso naj yaawil yak'omal xaambal eb tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Catu' jix yalon Jesús tet naj jaxca ti': —Ak' meltzo ey ja wespada tu' yul s'umal. Yutol ja' mac chi yak'balne espada yin jowal, yetoj espada oj yun scami. ");
INSERT INTO knjNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Tumi man ja wotaj oj, ta chi woche chin k'ana, ey ec'ban sesenta mil ángel bey cu Mam Dios, tol chi jul colwa win yin eymanil? ");
INSERT INTO knjNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero k'inaloj ta chin k'ana, ma el oc jaxca yalon can yul An Juun Tz'ibebil can oj, tol sowalil jaxca ti' oj ec' el wiban an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jix lawi tu' xin, catu' jix yalon tet eb jix apni pax tu': —¿Tumi elk'om jin che yila, yuxan i'bil oc je yespada c'al je te', chin jul je mitx'oni? Jun jun c'al c'u chotan jin ey jin cuywa je nan je xol bey yul stemplo Dios, pero ma jin je mitx' pax titu'. ");
INSERT INTO knjNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Jaxca ton ti' chi yun xin, yu yunen el tzet tz'ib ye can yu eb ẍejab Dios yul An Juun Tz'ibebil can oj, ẍi Jesús tet eb. Jix bejle can Jesús yu eb cuywom xojli. Jix el eb smasanil. ");
INSERT INTO knjNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ja' eb jix mitx'on Jesús tu', jix yi'toj naj eb sattaj Caifás, naj yaawil yak'omal xaambal eb tet Dios. Ja' ta' titu' jix syamba sba eb cuywam yin sley Moisés, c'al eb icham winaj ey yopiso. ");
INSERT INTO knjNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ja' naj Pedro, naat tzajan c'al chi yute sba naj, masanta' c'al jix apni bey jun miman sna naj sat yaawil eb tu'. Jix ey chotan yetoj eb policía, yet watx' chi yila, tzet c'al oj jul oj. ");
INSERT INTO knjNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ja' eb yaawil yak'omal xaambal eb tet Dios tu', yetoj eb icham winaj c'al masanil eb sat yaaw, jix sey wan testigo eb jix sna'on a k'ane eb yin Jesús tu', tzet utbil oj yun scami. ");
INSERT INTO knjNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ec'al eb jix oc testigoal tu', jix sna'on a k'ane eb yin Jesús tu'. Pero c'am junoj jix oc yopiso tzet jix yala. Tzunan xa jix apni cawan xa lek'ti' testigo. ");
INSERT INTO knjNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Jix yalon eb jaxca ti': —Jaonti', jix kab yalon jun winaj ti' jaxca ti': “Jainti', chi ske' wuchon ey stemplo Dios, pero ja' yet yox c'ual tu' chi a pax sq'uexel wu an,” ẍi naj, jix kabe, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ja' naj yaawil yak'omal xaambal eb tet Dios, jix a linan naj, jix yalon tet Jesús jaxca ti': —¿Tumi c'am chach tak'wi nioj? ¿Tumi c'am cha wab wan chi yal eb ti' ja win? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero ja' naj Jesús, c'am c'al tzet jix yala. Yuxan, jix yal tet naj junel xa jaxca ti': —Al e on, ta Cristo jaach, ta Sc'aal jaach Dios. Sowalil cha wal sattaj Dios iquis, ta yel cha wala, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—Jain ton ti' jaxca ja walon tu'. Chi wal pax e ex, ja' jain Ak'bil Wopiso yu Dios xol eb ket animail ti', oj jin je yil yet chotan jin ey bey swatx' k'ab Dios, naj Miman Yipal. Oj je yil pax weyol satcan xol asun, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ja' yet jix yaben wan tu' naj yaaw tu', jix snic'ontoj nioj spichil naj, catu' jix yalon naj tet eb yet yaawilal jaxca ti': —Ja' jun winaj ti', buchwal chi yun yin Dios. ¿Tzet to wal chi oc testigo ku tinani', yutol jaon caw jix kabe tol chi buchwa yin Dios? ");
INSERT INTO knjNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Tzet ẍi je c'ul yin naj tinani' xin? ẍi naj yaaw tu'. —Pena chi el yunen naj, smoo chi cami, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jix c'oli tzuble oc eb yin sat. Jix smak'on naj eb. Ey eb jix smak'ontoj sti' naj. ");
INSERT INTO knjNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Catu' jix yalon eb tet Jesús jaxca ti': —Jaach Cristo, na' el oj mac jix jaach mak'oni, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ja' naj Pedro tu', chotan ec' bey sti' jun miman na tu'. Jix apni jun ix criada sc'atan, jix yalon ix jaxca ti': —Jaachti', ja wetbi ja ba yetoj Jesús a Galilea, ẍi ix tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","—Man wotaj oj jun cha wal e in tu' an, ẍi naj sattaj masanil eb, catu' jix yi'on el sba naj yin. ");
INSERT INTO knjNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lalan xa wal yeltoj bey spuertail tu', catu' jix yilon jun xa ix, jix yalon ix tet eb yaman ec' oj: —Ja' ton jun winaj ti', yetbi sba yetoj naj Jesús a Nazaret, ẍi ix. ");
INSERT INTO knjNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jix yi'on el sba naj Pedro yin junel xa. —Ch'il Dios caw man wotaj oj jun winaj tu', ẍi naj Pedro tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yet jun xa txolan catu' jix yalon eb ey ec' titu' tet naj Pedro jaxca ti': —Caw yel ja wetbi ja ba yetoj eb scuywom Jesús, yutol laan ja k'anab yetoj eb chi kabe, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Catu' jix c'oli sk'anontej sjowal sc'ul Dios naj yiban. —Chi yil Dios tol ja' jun winaj tu', caw man wotaj oj an, ẍi naj Pedro tet eb. Ja' yet jix lawi yalon jun tu', catu' jix ok' a no' caẍlan. ");
INSERT INTO knjNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jix sna'ontej naj tzet jix yal Jesús tet, yet jix yalon jaxca ti': “Oxel xax jin ja wi'on el ja win, catu' oj ok' a no' caẍlan, yet oj ja waloni tol ma jin ja wotaj oj,” ẍi Jesús tet naj. Yuxan, jix eltoj naj Pedro sti' na tu', catu' jix mi'chcha sc'ul naj yok' sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Jaxa yet jix sajbi, jix syamba oc sba eb yaawil yak'omal xaambal eb Israel tet Dios, yetoj eb ichamtaj winaj ey yopiso xol eb. Jix c'oli slatinen eb tzet oj yute yak'on cam Jesús eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Catu' jix sc'alon naj eb. Jix yi'ontoj naj eb sattaj naj Poncio Pilato, naj yaawil ye bey titu'. ");
INSERT INTO knjNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ja' yet jix yilon naj Judas, naj jix aon oc Jesús yul sk'ab eb, tol oj cam xa c'al naj yu eb, caw jix sna' sba sc'ul yu smul tu'. Jix to sc'atan eb yaawil yak'omal xaambal eb Israel tet Dios, c'al sc'atan eb yicham winajil conob. Jix yoche jix yak' meltzo ch'en treinta tumin plata jix ẍa' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yuxan jix yal naj tet eb jaxca ti': —Caw jix oc jin mul waon oc naj yul sk'ab camich, yutol c'am nioj smul naj, ẍi naj Judas tet eb. Catu' jix yalon eb tet naj jaxca ti': —Jaonti' bian, c'am c'al kalon ket yin jun ja mul tu', junel cha na', il c'al tzet cha wute ja ba, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ja' yet jix yaben naj jaxca tu', jix sk'ojon can octoj ch'en tumin tu' yul stemplo Dios, catu' jix toi. Jix yaon oc jun tx'an naj yin snuk'. Jix st'unban a sba, catu' jix cami. ");
INSERT INTO knjNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ja' eb yaawil yak'omal xaambal eb Israel tet Dios tu' jix sic'on a ch'en tumin tu'. Jix yalon eb jaxca ti': —Ma ske' kaontoj wan tumin ti' xol ch'en sa'beal, yutol stool camich ch'en, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Catu' jix sna'on eb tzet oj oc ch'en yu eb. Jix manle el jun x'otx' jun naj tz'ajlom yetoj ch'en tumin, catu' jix oc camposantoal, yet watx' ey bey chi muji eb tx'oj conoblajil chi cam titu'. ");
INSERT INTO knjNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yuxan, jix yij can a jun lugar tu', X'otx'al Chic'. Ja'c'ala' sbi tinani'. ");
INSERT INTO knjNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jaxca ton ti' jix yun yunen tzet jix yal can jaxca ti': “Jix yi' a ch'en treinta tumin plata eb, ch'en stool jun mac txequel jix manle yu eb Israel. ");
INSERT INTO knjNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ja' yetoj jun tumin tu', jix sman el x'otx' naj tz'ajlom eb. Jaxca tu' jix yute yalon can naj Kaawil e in an,” ẍi naj Jeremías yul An Juun Tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ja' yet jix apni naj Jesús sattaj naj Pilato, naj yaawil conob tu', jix sk'anlen el naj tet Jesús jaxca ti': —¿Tumi jaachti' Sreyal jaach eb Israel? ẍi naj tet Jesús. —Jaa', jain toni, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ja' eb yaawil yak'omal xaambal eb Israel tet Dios c'al eb icham winaj jix na'on a k'ane yiban naj, pero c'am tzet jix spajtze naj. ");
INSERT INTO knjNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yuxan jix yal naj Pilato tet Jesús junel xa: —¿Tumi c'am cha wab wan chi yal eb ja win ti'? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero c'am junoj k'ane jix spajtze tet eb. Yuxan caw jix q'uey a sc'ul Pilato yin naj Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ja' yet chi ec' k'in jun jun jabil, beybalnebil yu yaaw chi jajle el jun jun a preso, ja'ta'c'ala' mac chi sk'an jajcha conob. ");
INSERT INTO knjNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ey jun naj chi yij Barrabás, ey oc naj preso. Otajbil naj yu masanil ánima. ");
INSERT INTO knjNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ja' yet jix yamba sba conob tu', jix sk'anlen Pilato tet eb: —¿Mac junoj che yoche chin jajel oj, jam naj Barrabás, ma ja' Jesús, jun chi al-le Cristoal? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yutol jix yotajne el naj tol yu ẍichon c'ulal eb yaawil yak'omal xaambal eb Israel tet Dios, yuxan jix yi'tej naj eb bey naj Pilato tu'. Yuxan quey tu' jix yal tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ja' yet chotan octoj naj Pilato tu' yul sdespacho, jix yaltej ix yistil naj tet jaxca ti': “C'am nioj ja wet cha waltoj xol tzet chi ale oc yiban naj c'am nioj spenail tu', yutol jix jin weychene jun tu' ma'i ak'balil. Caw jix jin xiw yu jun jin weyich tu' an,” ẍi ix. ");
INSERT INTO knjNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero ja eb yaawil yak'omal xaambal tu', c'al eb ichamtaj winaj jix ak'on sc'ul eb ánima, yuxan ja' naj Barrabás jix sk'an jajcha eb. Ja' naj Jesús, jix sk'an cam naj eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jix sk'anlen el naj yaaw tu' junel xa tet conob: —¿Mac junoj eb cawan ti' che yoche chin jajle el oj? ẍi naj tet eb. —Ja' naj Barrabás chi koche cha jaj el oj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—¿Pero tzet oj wute pax Jesús, jun chi al-le Cristoal? ẍi naj. —Tol chi cam yin culus, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Tzet yetal junoj pena jix sey yun jix je yil xin? ẍi naj tet eb. Pero tu' c'al jix a sjowal yel yaw eb yaloni: —Tol chi cam yin culus, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ja' yet jix yilon naj Pilato tu', tol ma xa yak' ganar scolcha Jesús. Yutol ip c'al x'emcha a eb yu. Yuxan, jix yak'on bet tit nioj ja'. Jix x'a'on el sk'ab naj sattaj masanil eb, yu x'oxon el oj, tol c'am naj ey oc xol yetoj eb. Catu' jix yalon tet eb jaxca ti': —Jainti', c'am jin mul yin scamichal jun naj c'am nioj spenail ti'. Il wej c'al je ba jaexti' je txojli, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Catu' jix yalon masanil eb tu' tet jaxca ti': —Cax c'al chi tit kiban c'al yiban eb kic'aal, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ja' yet jix yaben naj Pilato jaxca tu' xin, jix sjajon el naj Barrabás. Jal naj Jesús, jix yak' orden smak'lei, catu' jix bejle can yul sk'ab eb jix aon oc yin culus. ");
INSERT INTO knjNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ja' eb soldado naj yaaw tu', jix i'ontoj bey sna naj gobernador. Ja' titu' jix oc joyan masanil eb soldado yin naj. ");
INSERT INTO knjNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jix yi'on el spichil naj eb, jix yaon oc jun cajin pichile eb yin naj. ");
INSERT INTO knjNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jix spatx'onen ey jun q'uix eb. Jix yaon atoj eb yin sjolom naj scorona oj. Jix yaon oc jun te' a eb yul swatx' k'ab sk'ojoch oj naj. Jix lawi tu' xin, jix tz'aj skaban ey sba eb tet naj. Jix c'oli sbuchon eb. Jix tz'aj yalon eb tet naj jaxca ti': —Tzalaan, jaach Sreyal eb Israel, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Catu' jix c'oli tzuble oc eb yin naj. Jix yi'on ec' te' a eb tet. Jix smak'on oc te' eb yin sjolom naj. ");
INSERT INTO knjNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jix lawi sbuchwa c'al eb yin naj jaxca tu' xin, jix yi'on el an pichile cajin yili tu' yin naj. Jix yaon c'al ta' oc spichil naj eb. Catu' jix i'letoj naj yu eb bey oj ale oc naj yin culus. ");
INSERT INTO knjNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lalan sbey eb yetoj Jesús catu' jix ẍa'len el sba eb yetoj jun winaj a Cirene, Simón sbi naj. Ja' naj Simón tu' jix al-le octoj yalan sculusal Jesús tu' yu eb. Jix yi'ontoj naj. ");
INSERT INTO knjNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jaxca tu' jix yun yapni eb bey jun lugar chi yij Gólgota. Ja' Gólgota tu', chi yal yel oc apnoj, Slugaril Sbajil Jolome. ");
INSERT INTO knjNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jix ak'le yuc' vino calan ye yetoj sc'ail jun tujan caw c'a' yu eb. Pero ja' yet jix yabeni, ma ẍa' sc'ul jix yuq'ue. ");
INSERT INTO knjNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Catu' jix yaon oc naj eb yin te' culus. Catu' jix c'oli yak'on suerte eb soldado yin spichil naj, catu' jix spo'on ec' an eb yin. Jaxca ton ti' jix yun yu yunen el tzet tz'ibebil can yu jun ẍejab Dios peyxa, yet jix yalon can jaxca ti': “Jix yaoc suerte eb yin jin pichil catu' jix spo'on ec' an eb xol,” ẍi yul An Juun Tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jix lawi tu' xin, catu' jix ey chotan eb steynen Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jix tz'ibele oc jayeb letra sjolomtaj atoj. Ja' jayeb letra tu' chi aloni tzet yuxan chi cami. “Ja' ton Jesús ti', Sreyal eb Israel,” ẍi wan letra tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ey pax cawan elk'om jix culusnele yetoj Jesús. Jun bey swatx' k'ab, jun xa bey sq'uexan k'ab. ");
INSERT INTO knjNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ja' eb chi ec' titu', chi buchwa can atoj eb yin, catu' chi a tx'umna eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Jix yalon eb jaxca ti': —Jaach ton ti', cha wuchtoj stemplo Dios ja wala, catu' cha wa'nen a sq'uexel yet yox c'ual. Col ja ba tinani'. Ta tol yel Sc'aal jaach Dios, eyantej yin te' culus tu', ẍi atoj eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ja' eb yaawil yak'omal xaambal tet Dios, c'al eb cuywam yin sley Moisés, c'al eb fariseo, c'al eb ichamtaj winaj, jix c'al buchwa atoj eb yin naj. Jix yal eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ey mac jix scolo, pero c'am chi ske' scolon pax sba tinani'. Ta c'uxan ta' ja' cu Reyal, jaon Israel jon ti', ja' tinani', ey ojab tej yin te' culus ti' kila. Jaxca tu' xin, oj kaoc cu c'ul yin. ");
INSERT INTO knjNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ila chi tz'aj yaoc Dios yip oj sc'ul. Colwa ojab Dios tu' yetoj, catu' oj kiloni, ta tol yel ey scam c'ulal Dios tu' yin. Ila, Sc'aal Dios ẍi e on, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ja' eb elk'om locan a yetoj Jesús tu', jix buchwa pax eb yin. ");
INSERT INTO knjNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chuman wal c'u, catu' jix k'ejbi masanil yul yiban k'inal, masanta' c'al yet a las tres. ");
INSERT INTO knjNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ja' c'al oc yet a las tres tu', jix el yaw Jesús yin ipal: —Elí, Elí, ¿lama sabactani? ẍi Jesús. Chi yal yel oc apnoj: Jaach jin Diosal, Jaach jin Diosal, ¿tzet yuxan chin ja bej can jin txojli? ");
INSERT INTO knjNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ey jaywan eb ey ec' titu', jix aben tzet jix yal tu', catu' jix yalon eb tu' jaxca ti': —Ja' naj Elías, jun ẍejab Dios, ja' chi yawte jun ti', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ja' yet tu' ey jun yetbi eb jix to lemna oj. Jix bet yaon eytoj jun tzet yetal lababi xol vinagre. Jix yaon oc ẍumuc jun te' a. Jix yaon atoj yin sti' Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ey wan eb jix alon tet naj jaxca ti': —Yil xa sba. Oj kila ta oj jul eytej naj yu Elías tu', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jix el yaw Jesús junel xa yin yel xa yipal, catu' jix cami. ");
INSERT INTO knjNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ja' yet xa c'al jun txolan tu', catu' jix ey tz'ilna snan an k'ap ey oc smajil oj yul snan stemplo Dios tu'. Jix ẍa' eytej stit tz'ilna sjolom masanta' c'al jix eyol sti'laj. Ey pax jun miman quixcab jix eq'ui. Ey wan ch'en mimej ch'en jix jat can a yu. ");
INSERT INTO knjNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ey pax ch'en ch'en bey mujan octoj eb camnaj jix jajchai. Yuxan ec'al eb yet xa Dios camnaj xa jix pitzc'u a yetoj smimanil. ");
INSERT INTO knjNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ja' yet jix pitzc'u a Jesús, catu' jix eltej eb yul ch'en bey mujan eb tu'. Jix to eb bey yul conob Jerusalén. Ja' ton jun conob yet ta' Dios yei. Ec'al ánima jix ilon yin eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ja' yet jix yaben jun quixcab, c'al wan xa tzet jix yun tu', naj capitán, c'al eb soldado chi teynen Jesús tu', caw jix xiw a eb. Jix yalon eb jaxca ti': —Ja' jun jix cam ti', tol yel caw Sc'aal Dios naj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ey wan eb ix ix t'anantej naat. Eb ix jix ec' yintaj naj yet ey ec' naj bey Galilea yu yak'le servil naj Jesús yu eb ix. Ja' yet jix tit naj bey Galilea tu', catu' jix tit pax eb ix yetoj. ");
INSERT INTO knjNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ey oc María Magdalena xol eb ix, yetoj María xutx naj Jacobo yetoj naj José, yetoj pax xutx eb sc'aal naj Zebedeo. ");
INSERT INTO knjNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ey jun winaj be'om chi yij José, a conob Arimatea. Ja' jun winaj tu', scuywom pax Jesús. Yey c'ualil xa jix apni naj, ");
INSERT INTO knjNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","catu' jix octoj naj sc'atan naj Pilato yu sk'anon eytej smimanil Jesús yin culus. Jix yalon naj Pilato tet eb soldado tu' tol chi ak'le tet. ");
INSERT INTO knjNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Catu' jix to naj yi'on eytej smimanil Jesús tu', catu' jix pichon oc yul jun sábana saj yei. ");
INSERT INTO knjNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ey jun ch'en ch'en jolbil xa, yet naj José yei. C'am to junoj camom xax mujle yul jun ch'en tu'. Ja' tu' jix bet ya octoj smimanil Jesús tu' naj. Jix lawi tu', catu' jix sbalon can oc jun miman ch'en smajil oj, catu' jix to eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Chotan ey María Magdalena yetoj jun xa ix María scawilal ch'en ch'en tu' yet xax yune'. ");
INSERT INTO knjNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ja' yet jun xa c'ual, yet jix lawi sc'ual swa'nen settaj yetal oj sk'anbalne eb yet sábado, jix syamban ey sba eb yaawil yak'omal xaambal tet Dios, c'al eb fariseo, jix apni eb sattaj naj Pilato. ");
INSERT INTO knjNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jix apni yalon eb jaxca ti': —Mamin yaaw, jix cu na'tej, tol ja yet c'am to chi cam jun lek'ti' tu', jix yal jaxca ti': “Scaabial jin cami, catu' oj jin pitzc'u pax a oj,” ẍi naj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yuxan, c'am mi cha wak' favor e on. Cha chej to teynele bey jix bet oc can toj smimanil tu', masanta' c'al yet yox c'ual tu'. Ta c'amaj, tala oj yelk'ane eltej smimanil eb scuywom tu'. Jaxa ta' yuna oj, oj yalon eb jaxca ti' xol ánima tol jix pitzc'u a xol eb camnaj. Ta quey tu' oj yute eb jaxca tu', ja' jun tzunan slek'ti'al eb tu', yel xa c'al pena yintaj jun babel lek'ti'al jix yak' jun winaj tu', ẍi eb tet Pilato tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Catu' jix yalon naj Pilato tu' tet eb jaxca ti': —Ta quey tu' jaxca tu', chi ske' je yi'ontoj soldado titu', yet watx' che teynen yetoj eb, ẍi naj Pilato tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Catu' jix to eb tu', jix yi'ontoj eb soldado eb tu' yetoj. Jix steynen ch'en ch'en eb bey jix octoj smimanil Jesús tu'. Jix ya can oc selloal ch'en ch'en ey oc smajil tu'. Ja' eb soldado tu', jix can eb sti' ch'en tu' steyneni. ");
INSERT INTO knjNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jix ec' c'u yet sc'ual xewilal, catu' jix sajbi a yet domingo, yet babel sc'ual semana. Catu' jix to ix María Magdalena yetoj jun xa María bey jix bet can smimanil Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ja' yet lalan sto eb tu', jix ec' jun quixcab caw jow, catu' jix eyol jun yángel naj Yaaw bey satcan catu' jix apni bey mujan Jesús tu'. Jix yi'on el ch'en smajil tu' catu' jix ey chotan yiban ch'en. ");
INSERT INTO knjNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Caw chi tzejeji yili jaxca sletz'lon yich can. Caw saj spichil jaxca saj bacom. ");
INSERT INTO knjNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ja' yet jix yilon eb soldado ey ec' steynen ch'en ch'en tu', jix lujlun a eb yu xiw c'ulal. Jix telc'otoj eb, jaxca tol jix cam el eb. ");
INSERT INTO knjNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Catu' jix yalon jun ángel tu' tet eb ix jaxca ti': —Manchej jex xiwi. Wotaj tol ja' Jesús, naj jix culusnelei, ja' naj che sey ec' oj. ");
INSERT INTO knjNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","C'am xa naj ey ec' titi'. Jix pitzc'unele a jaxca jix yute yalon e ex. Titan nej toonabi, catu' che yilon bey jix can naj. ");
INSERT INTO knjNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Catu' asi' wej eyman, chi to je yal tet eb jix ec' cuywoj yintaj naj, tol jix pitzc'unele a xol eb camnaj. Oj baboj apnoj je sattaj bey Galilea. Oj je yil yin naj titu'. Ja' wan ti' chi jul wal e ex an, ẍi jun ángel tu' tet eb ix. ");
INSERT INTO knjNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Catu' jix sbejon can ch'en ch'en eb ix bey jix mujle naj tu' yin eymanil. Jix xiw a eb, pero caw jix tzala pax eb. Yuxan jix to eb yin ani. Jix to yalon eb tet eb scuywom Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lalan to sto eb tu', jix x'oxon a sba Jesús tet eb. Jix sk'anleni ta watx' sc'ul eb. Catu' jix sjitzon xa c'al tej sba eb sc'atan. Jix yi'on ey sba eb tet Jesús, jix oc lak'an eb yin yajan. ");
INSERT INTO knjNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jix yalon Jesús tet eb: —Manchej jex xiwi. Asi' al wej tet eb wuẍtaj c'al tet eb wanab, tol chi to eb bey Galilea. Ja' titu' oj yil eb win an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lalan to sto eb ix ix tu', catu' jix to jun cawan eb soldado chi teynen ch'en ch'en tu' yul conob. Jix apni eb sc'atan eb yaawil yak'omal xaambal eb Israel tet Dios. Jix bet yal eb masanil tzet jix yun yel oc titu'. ");
INSERT INTO knjNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jix lawi yaben eb masanil tzet jix yun tu', catu' jix to eb slatinen sba yetoj eb ichamtaj winaj ey yopiso, tol oj yaoc miman oj tumin eb tet eb soldado tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Catu' jix yalon tet eb jaxca ti': —Jaxca ti' oj je yute je yalon jaxca ti': “Lalan cu wey yet ak'balil, catu' jix jul eb scuywom yi'ontoj smimanil tu',” je chi, ẍi eb tet eb soldado tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ta chi yab a naj yaaw jun ti', c'am tzet che na', oj cu monte naj jaonti', yet watx' c'am tzet chi elol je yiban, ẍi eb tet eb soldado tu'. ");
INSERT INTO knjNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Catu' jix ẍa'on ch'en tumin tu' eb soldado tu'. Jix ec' yalon el eb jaxca jix yun yal-le tet eb tu'. Yuxan ja' jun lek'ti'al k'ane ti', chi to c'al yal eb Israel tinani'. ");
INSERT INTO knjNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jix to eb jusluc'wan scuywom Jesús bey Galilea tu'. Ja' bey jun wonan, jun jix yal can Jesús tet eb, ja' titu' jix apni eb. ");
INSERT INTO knjNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ja' titu', jix yil eb yin Jesús. Jix yi'on ey sba eb tet naj. Pero ey jun cawan eb ma yaoc yin sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jix sjitztej sba Jesús sc'atan eb sjusluc'wanil, jix yalon tet eb jaxca ti': —Jix jin ale oc Yaawilal yiban masanil tzet ey bey satcan, c'al yiban masanil tzet ey bey yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yuxan, asi' wej cuywa xol-laj ánima bey jun jun conob, yet watx' oj oc eb jin cuywom oj. Che yak' can bautizar eb yin sbi cu Mam Dios, c'al yin jin bi, jain Sc'aal Dios jin ti' an, c'al yin sbi naj Santo Espíritu. ");
INSERT INTO knjNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Che cuy can eb, yet watx' masanil tzet jix wal can e ex, oj sjije eb. Otajne wej el sic'lebil, tol jain, chin ec' je yetoj tobal k'inal, masanta' c'al oj lawoj yul yiban k'inal ti', ẍi Jesús tet eb scuywom tu'. Amén.");
INSERT INTO knjNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Ja' ti' watx' sk'aneal naj Jesucristo, Sc'aal Dios. Jaxca ti' jix yun yel yich jaxca jix yun tz'iben can jun ẍejab Dios jun chi yij Isaías yul An Juun Tz'ibebil can oj Jix yal Dios jaxca ti' yin Sc'aal: Oj jin chej baboj jun jin chejab ja sattaj. Ja' oj wa'nen sbeybal eb ánima yet c'am to chach apni, ẍi Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ja' jun jin chejab tu', ja' bey cusiltaj tx'otx' oj yal yin ipal jaxca ti': “Jaxca chi yun swa'nele junoj be yet chi jul junoj yaaw, quey tu' che yute je wa'nen je beybal, yutol oj jul naj Kaawil,” quey tu' oj yute yaloni, ẍi can yul An Juun Tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yuxan jix yak' bautizar eb ánima naj Juan bey cusiltaj tx'otx'. Jix yalon tet eb tol sowalil chi sna' sba sc'ul eb yin spenail, catu' chi yak'on bautizar sba eb, yet watx' chi jo'le q'uey spenail eb yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Masanil eb ánima yul-laj yet Judea c'al eb a Jerusalén jix bet aben oj. Chi lawi yalon atej spenail eb tet Dios, catu' chi yak'on sba eb yak' bautizar naj Juan yul ja' miman Jordán. ");
INSERT INTO knjNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ja' naj Juan tu', xil no' camello chembil ey oc spichil oj, jal sc'alil xin, asan tz'um c'alile. Ja' jun tujan no' tinquin tzu chi chi'lei chi ẍi naj, catu' yal xol-lajil te' awcab chi yuq'ue. ");
INSERT INTO knjNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Catu' jix yalon el xol eb ánima jaxca ti': —Ey jun naj tzajan sjul wintaj an, yel xa c'al yel miman yel oc apnoj wintaj an. Yu jun tu', yuxan man jin moo oj wak'on servil nioj, cax c'al chin ey noan sattaj jin xuyon el x'anil xanab naj, man jin moo oj. ");
INSERT INTO knjNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jainti', caw yel chex wak' bautizar yetoj ja'. Pero ja' jun chi wal tu' an, ja' oj ak'on naj Santo Espíritu e ex. Tol oj jex ak'le bautizar yu, ẍi naj Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ja' yet jun tiempoal tu', jix el Jesús bey conob Nazaret yul yet Galilea. Jix apni yak'on bautizar sba tet naj Juan bey ja' Jordán. ");
INSERT INTO knjNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ja' yet lalan yatej yul ja' tu', jix yilon sjajcha spuertail satcan, catu' jix eyol naj Espíritu yiban jaxca junoj no' uch. ");
INSERT INTO knjNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jix lawi jun tu' xin, jix yaben yal-le eytej jayeb k'ane bey satcan tet eb, jix yalon eytej jaxca ti': —Jaach ton ti', jin C'aal jaach, cam c'ulnebil jaach wu an. Caw chin tzala ja win an, ẍi. ");
INSERT INTO knjNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jix lawi jun tu' xin, jix i'letoj Jesús yu Yespíritu Dios bey jun cusiltaj tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cawinaj c'u jix bet ec' naj titu' xol no' nok' ey smey. Jix ijbalele naj yin spenail yu naj Satanás pero ma toj naj. Jix lawi tu', jix jul ak'le servil naj yu eb ángel. ");
INSERT INTO knjNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ja' yet jix ale oc naj Juan yul preso, jix to Jesús bey Galilea. Jix yalon can el watx' k'ane yu chi oc Dios yaawil oj eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jix yalon jaxca ti': —Jix jul stiempoal, janic'xane wal catu' oj wa'xoj oc Dios Yaawil oj. Yu jun tu', yuxan na' wej je ba yin je penail. Cha' wej je yab jun sk'aneal yet scolbanil je pixan, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Lalan yec' Jesús sti' ja' mar bey Galilea, catu' jix yiloni, ey ec' naj Simón yetoj jun yuẍtaj chi yij Andrés. Lalan yaon eytoj xim eb xol ja', yutol mitx'om pescado eb. ");
INSERT INTO knjNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Catu' jix yalon Jesús tet eb jaxca ti': —Ocan nej tzajan wintaj an, cuywan nej wintaj an, oj wak' je yopiso. Jaxca che yute je mitx'on no' pescado ti', quey tu' oj je yute je yi'ontej eb ánima e in an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jix sbej xa c'al can xim eb yet jun txolan tu'. Yu scuywi eb, yuxan jix tzajlo eb yintaj naj. ");
INSERT INTO knjNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jix bey to nioj xa, catu' jix yilontoj yin naj Jacobo yetoj naj Juan, eb sc'aal naj Zebebeo. Ey atoj eb yul jun barco, lalan snipen xim eb. ");
INSERT INTO knjNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Catu' jix awteletej eb naj yu Jesús. Jix tit eb xin, jix sbejon can smam eb yetoj eb yaman yul te' barco tu', catu' jix to eb yetoj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jix apni eb bey conob Capernaum. Ja' yet sc'ual xewilal jix octoj Jesús yul snail sculto eb Israel cuywa oj. ");
INSERT INTO knjNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Caw jix q'uey a sc'ul eb yet jix yaben eb wan cuybanil jix yak'a, yutol ja' yet jix cuywa snan xol eb tu', jix txeclo el oj, tol ey yopiso yu Dios, man jaxca oj eb cuywam yin sley Moisés. ");
INSERT INTO knjNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ja' bey snail sculto eb Israel tu', ey jun winaj ey oc pena espíritu yin ey ec' oj. Jix a yaw yin ipal, jix yalon jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Tzet ja walon ja wet ketoj jaach Jesús a Nazaret? ¿Ma yu cu jul ja wak'on q'uey el oj, yuxan jix jaach juli? Wotaj mac jaach txequel. Jaach ton ti' sic'bil jaach el yu Dios, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Catu' jix tzule jun pena espíritu yu Jesús, jix yalon tet jaxca ti': —Tz'in cachi. Elan yin jun winaj ti', ẍi Jesús tet. ");
INSERT INTO knjNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Catu' jix yak'on tit jun joybinaj sat yin naj tu' yu jun pena espíritu tu'. Jix el yaw, catu' jix el yin naj. ");
INSERT INTO knjNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jix q'uey a sc'ul masanil ánima jix iloni. Yu jun tu', yuxan jix c'oli yalotanen eb jaxca ti': —¿Tzet la ye jun ti'? ¿Tzet la cuybanilal jun chi jul ti'? Ja' jun winaj ti', chi c'al ske' yu yak'on mandar eb pena espíritu. Ila, tol chi sjije eb tet, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Eyman jix abcha el sk'umal Jesús xol masanil eb a lugar bey Galilea tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jix lawi jun tu' xin, catu' jix eltej eb yul snail sculto eb Israel tu', catu' jix to Jesús yetoj Jacobo c'al Juan bey sna naj Simón yetoj Andrés. ");
INSERT INTO knjNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Telan ey ix sni' naj Simón, caw ya' ey ix yu jun k'ak', yuxan jix yal eb tet Jesús tzet utbil tol ya' ey ix. ");
INSERT INTO knjNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Catu' jix sjitzontoj sba naj sc'atan ix, jix oc mitx'an yin sk'ab ix, jix nic'le a waan ix. Yet jun txolan tu', eyman jix wa'xi can sc'ul ix. Jix el jun k'ak' tu' yin ix. Catu' jix c'oli yak'le servil eb yu ix. ");
INSERT INTO knjNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ja' yet xax to c'u, yet numumi xa c'al yei, jix i'letej masanil eb ya' ey sc'atan Jesús, c'al eb ey oc pena espíritu yin. ");
INSERT INTO knjNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Caw ec'al ánima jix syamba sba sti' na. ");
INSERT INTO knjNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Caw ec'al eb jix apni. Yal c'al tzet ya'bilal chi etnen eb jix wa'xi can sc'ul eb yu Jesús. Caw ey eb ey oc pena espíritu yin jix yi' can el yin ánima. Ma cha'le k'anab eb pena espíritu yu naj, yutol yotaj xa eb mac txequel naj. ");
INSERT INTO knjNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ja' yet ey to sajbi, k'ej jolinaj to, jix a waan Jesús, catu' jix to txaloj bey jun lugar tz'inini sti' el conob. ");
INSERT INTO knjNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Catu' jix to naj Simón yetoj eb yetbi tu', jix to eb seyon ec' oj. ");
INSERT INTO knjNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ja' yet jix ilcha yu eb, jix yalon eb tet naj jaxca ti': —Masanil ánima chach seyoni, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Catu' jix yalon naj tet eb: —Toon nej bey wan aldea cawil-laj ti', tol oj toj wal can el sk'ane Dios xol-laj ánima. Yutol yu jun ti', yuxan jix jin jul an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jix ec' eb bey masanil yul-laj yet Galilea, catu' jix ec' yalon can el sk'ane Dios bey jun jun snail bey chi syamba sba eb Israel yin culto. Jix ujtele pax can el pena espíritu yin ánima yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ey jun winaj jix apni sc'atan Jesús, ya' ey yu jun tujan ya'bil chi k'a'toj ánima yu, chi yij lepra. Jix ey kaan jun winaj tu', jix yaloni: —Ta chi yal ja c'ul, chi ske' ja wak'on can wa'xoj jin c'ul, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ja' Jesús, jix ok' sc'ul yin naj, catu' jix sbatxba oc sk'ab naj yiban naj: —Chi yal jin c'ul. Tol chi wak' can wa'xoj ja c'ul, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jix c'al yal jaxca tu' xin, jix wa'xi can jun tujan ya'bil tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Catu' jix chejle pax naj yu Jesús. Catu' jix cam al-le can tet naj jaxca ti' yu Jesús: ");
INSERT INTO knjNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Ab xin. C'am bey cha wal jun ti'. Asi', tx'ox ja ba tet naj yak'omal xaambal tet Dios. Asi' ak' ja wofrenda tet Dios, jaxca yalon sley Moisés. Jaxca tu' oj yun xeclo el oj tol jix jaach wa'xi, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero ja' yet jix to naj, jix c'oli yalon el oj tzet jix yun swa'xi can sc'ul. Pilan jix yal el smasanil. Yu jun tu' xin, ma xa ske' yoc Jesús yul jun jun conob, yutol ec'al mac chi yoche chi apni sc'atan naj. Yuxan ja' bey c'am ánima jix ec' c'al. Pero chi apni c'al eb a jun jun lugar sc'atan naj. ");
INSERT INTO knjNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jayeb jix to c'u tu', jix apni pax Jesús junel xa bey conob Capernaum. Catu' jix abchai, tol ey ec' bey sna. ");
INSERT INTO knjNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yu jun tu', yuxan ec'al ánima jix syamba oc sba bey sna naj yet tu'. Ma yab yul na tu', yuxan ey eb jix can can sti' na. Catu' jix c'oli yalon sk'ane Dios Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ey jun winaj sicbinaj el smimanil, jix i'letej yu canwan winaj. ");
INSERT INTO knjNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero ma ske' yoctoj eb bey ey ec' Jesús, yutol caw ey ánima. Yu jun tu', yuxan jix atoj eb yiban ẍumuc spananil na tu'. Jix sjolon eb jun jolan yet c'ulal bey ey ec' Jesús. Jix yaon eytoj t'unun oj jun winaj tu' eb yul sweyub. Catu' jix ey apnoj sat tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ja' yet jix yilon Jesús, tol chi yaoc sc'ul eb yin, jix yalon tet naj sicbinaj el smimanil tu' jaxca ti': —Jaach wuẍtaj, jix ak'le miman c'ulal yin ja penail, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pero ey wan eb cuywam yin sley Moisés chotan ec' titu'. Jix sna'on eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Tzet yuxan quey tu' chi yal jun winaj ti' jaxca ti'? Buchwal k'ane chi yun yin Dios. C'am junoj ánima chi ske' yak'on miman c'ulal yin cu penail, asan Dios,” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yotaj xa pax Jesús tzet chi sna' eb, yu jun tu', yuxan jix yal tet eb: —¿Tzet yuxan quey tu' che na' jaxca tu'? ");
INSERT INTO knjNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Beytet junoj yel subo yali che na'? Ta jin chi jaxca ti': “Tol jix ak'le miman c'ulal yin ja penail,” ma ja', “aan waan oj, i' a ja weyub catu' beyan”. ");
INSERT INTO knjNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ja' tinani' xin, oj jin tx'ox e ex an, tol ja' jain Ak'bil Wopiso xol eb ket animail yu Dios ti', chi c'al ske' wu wak'on miman c'ulal yin spenail eb ánima bey yul yiban k'inal ti', ẍi Jesús tet eb. Catu' jix yalon naj tet naj sicbinaj el smimanil tu': ");
INSERT INTO knjNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Jain chi wal e ach an, aan waan oj. I' a ja weyub ti'. Paxan bey ja na, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jix a xa c'al waan naj yet jun txolan tu'. Jix yi'on a sweyub naj. T'anan oc eb, catu' jix pax naj. Tuxa c'al jix q'uey can a sc'ul eb masanil. Jix yalon watx' k'ane eb tet Dios: —Caw c'am bey chi kil junoj tzet yetal jaxca ti', ẍi xa c'al eb. ");
INSERT INTO knjNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jix lawi jun tu' xin, jix to Jesús sti' ja' mar Galilea junel xa. Jix apni pax eb ánima masanil sc'atan naj. Catu' jix cuywa tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lalan sbeyi, catu' jix yilon yin jun naj chi ijon Leví, sc'aal naj Alfeo. Chotan ey bey chi tejwi el tolabal tet eb ánima: —Tzajloan, cuywan wintaj an, ẍi Jesús tet naj. Catu' jix a waan oj, jix tzajlo yintaj naj cuywoj. ");
INSERT INTO knjNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jix lawi tu', catu' jix to Jesús bey sna naj Leví tu'. Jix low yetoj eb scuywom titu', pero ey pax wan eb tejom el tolabal jix low yetoj eb yin meẍa, c'al wan xa eb pena pax sbeybal. Yutol ec'al mac jix tzajlo yintaj. ");
INSERT INTO knjNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ja' yet jix yilon eb cuywam yin sley Moisés c'al eb fariseo, tol lalan slow naj yetoj eb pena sbeybal tu', jix yalon eb tet eb scuywom naj jaxca ti': —¿Tzet yuxan chi low Jesús yetoj eb tejom el tolabal c'al yetoj eb pena sbeybal ti'? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ja' yet jix yaben Jesús jaxca tu', jix yalon tet eb: —K'inaloj ta ey ec' junoj anwam tinani', ¿toj ey yopiso yu eb watx' sc'ul? Asan yu eb ya' ey, ja' eb tu' ey yopiso yu. Quey jin pax tu', man yu oj wawten eb watx' sbeybal sna'oni, yuxan jix jin jul an, pero yu wawten eb chi yotajnen el sba tol penawom eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ja' junel, lalan yijle nocha sba scuywom naj Juan yetoj eb fariseo, Yuxan ey wan mac jix apni sc'atan Jesús catu' jix sk'anleni: —Ja' eb scuywom naj Juan c'al eb scuywom eb fariseo, chi yijle nocha sba eb. ¿Tzet yuxan c'am chi yun pax eb ja cuywom jaachti'? ẍi eb tet. ");
INSERT INTO knjNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Catu' jix yalon naj tet eb jaxca ti': —K'inaloj ey junoj nupil chi oc tinani'. Ja' eb awtebil, ¿tumi oj ske' man oj low eb yet ey to ec' naj lalan snupi tu' yetoj eb? ");
INSERT INTO knjNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ja' to yet oj a apnoj stiempoal yi'le el naj xol eb, ja' yet tu' oj yijle nocha sba eb. ");
INSERT INTO knjNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tol ey jun xa cuybanile chi tx'oxon el oj tol c'am chi ẍa'le sba icham cuybanile yetoj wan ac' jin cuybanil. K'inaloj ey junoj an icham pichile chi jolcha tinani'. Toj ey mac txequel chi aon oc an ac' nip man to tx'a'bil oj snipil oj an. Yutol ja' an ac' nip tu', chi utz' an, catu' chi mimanbi snic'chanajil an icham tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yetoj pax oj, c'am junoj mac txequel chi aon ey vino tol to chi wa'xi yul junoj icham tz'um snetal vino, yutol ja' yet chi ch'ib a jun vino tu', chi nic'chatoj no' net tz'um tu' yu. Catu' tu' c'al chi etex el vino tu' yetoj jun no' tz'um tu'. Yu jun tu', yuxan asan yul no' ac' tz'um snetal vino, ja' tu' chi ey vino tol to chi wa'xi tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ja' yet jun sc'ual xewilal, jix ec' Jesús yul jun be snan xol wan ixim trigo yetoj eb scuywom. Jix yi'on el jayeb sjolom ixim eb scuywom tu', yu sc'uxon eb yet lalan sbey eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yu jun tu', yuxan jix yal eb fariseo tet Jesús jaxca ti': —Ilala, ¿tzet yuxan chi yun eb ja cuywom ti' tzet tol ey sleyal kunen yet sc'ual xewilal? Man sleyal oj chi yute eb jaxca tu', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero jix yal Jesús tet eb jaxca ti': —¿Tumi c'am to bey che yil yul An Juun Tz'ibebil can oj, tzet jix yun naj rey David junel, yet jix tit swail yetoj eb yaman yetoj? ");
INSERT INTO knjNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Jix octoj yul snail Dios, yet ey oc Abiatar yaawil yak'omal xaambal eb tet Dios. Jix slo'on eytoj ixim pan yet Dios yei, tol asan eb yak'omal xaambal tet Dios ey sleyal slo'oni, jix yak' pax tet eb yaman yetoj tu'. Pero ja' jun tzet jix yun tu', man pena oj yul sat Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ja' Dios jix alon can oj, yuxan jix el yich sc'ual xewilal, yet ánima yei. Pero man yu oj sjijen sc'ual xewilal eb yuxan jix wa'nele eb yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jainti', chi ske' walon an, tzet chi ske' el kunen yet sc'ual xewilal, yutol Ak'bil Wopiso xol eb ket animail ti' yu Dios, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ja' yet junel xa, jix oc Jesús yul jun snail sculto eb Israel. Ey jun naj sicbinaj el jun sk'ab ey ec' titu'. ");
INSERT INTO knjNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ey eb jix smaj yila, ta chi wa'xi can sk'ab naj sicbinaj el sk'ab tu' yu Jesús yet sc'ual xewilal tu', catu' chi yak'on queja eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Catu' jix yalon Jesús tet naj sicbinaj el sk'ab tu' jaxca ti': —Aan linan oj. Ocan linan cu nan ti', ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Catu' jix yalon tet eb ánima tu': —¿Beytet junoj ey sleyal kunen yet sc'ual xewilal che na'? ¿Jam tzet watx' chi ske' el kuneni, ma ja' tzet pena? ¿Chim ske' kak'on can wa'xoj sc'ul junoj ya' ey, ma ja' cu bejon cam chi ske'? ẍi naj tet eb. Tz'in xa c'al ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Catu' jix ec' t'anan oj naj xol eb tu', jix tit sjowal naj. Jix cus sc'ul yutol caw caw eb. Catu' jix yalon tet naj tu': —Bi eltoj ja k'ab, ẍi Jesús tet naj. Jix sbion eltoj sk'ab naj. Catu' jix wa'xi can oj. ");
INSERT INTO knjNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Catu' jix eltej eb fariseo tu' sti' na, jix slatinen el sba eb yetoj eb spartido naj Herodes, yu tzet chi yute yak'on cam Jesús eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pero ja' naj Jesús, jix to sti' ja' mar Galilea yetoj eb scuywom. Caw ec'al ánima a Galilea jix to yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yutol jix yab sk'umal eb tol caw ey milagro jix yun Jesús, yuxan ec'al eb jix apni sc'atan. Ey eb a Judea, c'al eb a Jerusalén, yetoj eb a Idumea c'al eb a sk'axepaltoj ja' Jordán. Ey eb jix tit scawilal conob Tiro c'al conob Sidón. ");
INSERT INTO knjNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yu jun tu', yuxan jix yal Jesús tet eb scuywom, tol listo c'al ye junoj barco yu eb, yet watx' c'am chi witz' oc sba ánima yin naj, yutol ec'al eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yutol ec'al eb jix wa'xi sc'ul yu naj. Yu jun tu', yuxan ec'al to c'al eb ya' ey jix bet yak' sba tet. ");
INSERT INTO knjNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jal eb pena espíritu xin, ja' yet jix yilon eb yin naj, jix ey kaan eb sattaj, catu' chi yalon eb yin ipal jaxca ti': —Jaachti', Sc'aal jaach Dios, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero jix yak' sowalil Jesús tet eb, yet watx' manchej yal eb mac txequel Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Catu' jix to Jesús bey jun wonan. Jix yawten eb jix ẍa' sc'ul yawteni, catu' jix apni eb titu'. ");
INSERT INTO knjNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Lacawan eb jix yaoc yopiso, yet watx' chi ec' eb yetoj, c'al yu ẍejontoj eb, to yalon el sk'aneal yet colbanile eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jix yak'on yopiso eb yak'on wa'xoj sc'ul eb ya' ey, c'al yi'on can el pena espíritu eb yin ánima. ");
INSERT INTO knjNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ja' sbi eb ti' slacawanil: Simón, naj jix yij can a Pedro yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yetoj Jacobo, c'al jun yuẍtaj chi yij Juan. Ja' cawan eb ti', sc'aal Zebedeo eb. Jix yij can a eb Boanerges yu Jesús. Ja' jun bie tu', chi yal yel oc apnoj, eb c'un stit sjowal. ");
INSERT INTO knjNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ey jun chi yij Andrés, ey jun chi yij Felipe, ey jun chi yij Bartolomé, ey jun chi yij Mateo, ey jun chi yij Tomás, ey jun xa chi yij Jacobo, naj sc'aal Alfeo, ey jun chi yij Tadeo, ey jun xa chi yij Simón. Ja' jun xa Simón ti', ey oc yin spartido eb Cananista yet yalantoj. ");
INSERT INTO knjNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ey jun xa xin, ja' ton Judas Iscariote. Ja' ton jun ti', jix aon oc Jesús yul sk'ab camich. Jix lawi jun tu', catu' jix to Jesús bey jun na yetoj eb scuywom. ");
INSERT INTO knjNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ec'al ánima jix syamba pax sba junel xa yin eb, yuxan ma xa ske' slow naj yetoj eb scuywom tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ja' yet jix yaben eb yuẍtaj Jesús c'al xutx naj, jix apni eb titu', t'inan xa chi apni yi'toj naj eb, yutol jix tit sloco naj, yalon eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ey wan eb cuywam yin sley Moisés jix tit bey conob Jerusalén, jix yalon jaxca ti': —Ja' Beelzebú yaawil eb pena espíritu ey oc yetoj Jesús ti'. Yu jun tu', yuxan chi ske' yi'on el pena espíritu tu' Jesús, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Catu' jix awteletej eb yu Jesús tu'. Catu' jix yalontej wan k'ane tet eb: —Ja' Satanás tu', ¿tumi oj yujte el eb pena espíritu tu'? ");
INSERT INTO knjNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chi wal e ex tzet yuxan man oj yun jaxca tu'. K'inaloj chi yak'le a jowal eb ánima bey junoj mimej conob. Ja' jun conob tu', chi lawi ey oj. ");
INSERT INTO knjNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","K'inaloj ta ey junoj nail ánima chi po'cha yu jowal. Chi etex el jun nail ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Quey pax ton tu' Satanás xin. K'inaloj ta chi po'cha yetoj eb pena espíritu, catu' chi yak'len jowal yetoj eb, chi uchontoj eb, catu' chi lawi yopiso. ");
INSERT INTO knjNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","K'inaloj junoj winaj, caw ey yip. C'am junoj mac comon c'al oj oc yul sna, catu' oj i'le eltoj settaj yetal. Asantane chi ak'cha ganar pixcha can ey naj sbabelal bian, Jam yet tu', chi ak'cha ganar yi'le eltoj settaj yetal naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Caw yel chi wal e ex an, yal c'al tzet spenail ánima chi oqui, c'al jantaj spenail chi yal eb yin Dios, oj ak'le miman c'ulal yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero yal c'al mac pena chi yal yin Santo Espíritu, c'am miman c'ulal yin. Chi oc smul oj yin junelne, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Quey tu' jix yute yalon jaxca tu', yutol jix yal eb tol pena espíritu ey oc yin naj. ");
INSERT INTO knjNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jix apni xutx Jesús yetoj eb yuẍtaj. Asan sti' na jix oc linan eb. Jix yak'on awtele eltej Jesús eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Catu' ja' eb chotan ey scawilal Jesús, jix alon tet jaxca ti': —Ey ec' ja txutx sti' na yetoj eb ja wuẍtaj. Jaach ab chach seyle ec' yu eb, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Catu' jix yalon tet eb: —¿Mac txequel jin txutx che na', mac txequel eb wuẍtaj an? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Catu' jix ec' t'anan oj xol-laj eb chotan ey scawilal tu'. Jix yaloni: —Ja' ton eb ti', jaxca jin txutx yei, ja' ton eb ti' jaxca wuẍtaj yei. ");
INSERT INTO knjNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yutol yal c'al mac chi jijen jaxca chi yoche sc'ul Dios, ja' ton eb tu' jaxca tol wuẍtaj, jaxca tol wanab, jaxca tol jin txutx eb an, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ja' junel jix cuywa Jesús sti' ja' mar. Ec'al ánima jix yamchai. Yu jun tu', yuxan jix atoj yul jun barco ey ec' sti' ja' tu', jix ey chotan yul. Jal eb ánima tu' xin, jix can eb sti' ja' mar tu' masanil. ");
INSERT INTO knjNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Miman tzet jix yak' scuy eb titu'. Jix yalontej wan k'ane tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Ab wej wan oj wal ti'. Ey jun naj jix to txi'o trigo. ");
INSERT INTO knjNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ey janic' ixim jix apni can txi'laboj yul-laj be. Pero jix ec' sic'le a ixim yu no' tz'iquin. ");
INSERT INTO knjNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ey ixim jix ey q'uey yiban wan ch'en, bey xaxo tx'otx'. Jun txolan jix aol oj, yutol xaxo x'otx'al. ");
INSERT INTO knjNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero jix c'al aol c'u, jix taj el ixim, yutol man miman oj xe' ixim eytoj yul tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ey pax ixim, jix ey q'uey xol q'uix, pero jix ch'ib a te' q'uix tu'. Catu' jix muje el yu te'. Yuxan ma can sjolom ixim. ");
INSERT INTO knjNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero ja' ixim jix ey q'uey bey yax sat tx'otx', jix ch'ib a ixim, jix can sjolom ixim. Ey ixim jolome trenta sbak' jix yak'a, ey ixim sesenta, ey ixim xin, cien jix yak'a. ");
INSERT INTO knjNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ja' wan che yab ti', na'otane wej sic'lebil, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ja' yet man xa ey oj ec' eb ánima tu' sc'atan Jesús, jix sk'anlen el eb scuywom slacawanil tet naj, c'al eb ey ec' scawilal: —¿Tzet wal chi yal yel oc apnoj jun k'ane jix ja wal ti'? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Catu' jix yalon naj tet eb: —Asan e ex chi x'ox Dios wan tzet yetal tol c'am to mac otajneni, yet watx' chi na'cha el je yu tzet chi yun yoc Dios je Yaawil oj. Pero ja' tet eb comon ánima, asan wan k'ane tx'oxom el cuybanile chi wal tet, ");
INSERT INTO knjNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","yet watx' c'am chi na'cha el yu eb. Cax c'al chi yil junoj tzet yetal eb, pero cac'al tu' chi can eb, jaxca tol c'am tzet chi yil eb. Yetoj pax oj, cax c'al chi yab eb, pero c'am nioj chi na'cha el yu eb. Yu jun tu', yuxan c'am nioj chi q'uexcha sna'bal eb, yuxan c'am pax chi ak'le miman c'ulal yin spenail eb yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ta c'am chi na'cha el je yu tzet chi yal yel oc apnoj jun sk'aneal yet tx'oxbanile jix wal ti' an, ¿tzet oj yun sna'cha el je yu wan xa k'ane masanil? ");
INSERT INTO knjNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ja' naj txi'om trigo tu', yechel eb chi alon el sk'ane Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ja' ixim jinat jix ey q'uey sti' be, yechel eb ánima chi c'al xew yaben sk'ane Dios, catu' chi jul naj Satanás, chi yak'on q'ueytoj yul sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ja' ixim jix ey q'uey yiban ch'en, yechel eb ánima eyman chi ẍa' yab sk'ane Dios yin tzala c'ulal. ");
INSERT INTO knjNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero man tec'an oj ye eb, jaxca junoj te' te' man miman oj xe' eytoj xol tx'otx'. Yuxan jaxa yet chi jul jun sya'ilal, ma yet chi ac'ulnele eb yu c'al sk'ane Dios, jun txolan catu' chi somcha el sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ja' ixim jix ey q'uey xol q'uix, yechel pax jun xa bulan eb chi aben sk'ane Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero asan tzet yetal ey yul yiban k'inal ti' chi yoche eb. Chi etex el sna'bal eb yu chi yoche eb chi oc sbe'omal. Asan yin tzet yetal chi yoche oc eb, caw chi yaoc sna'bal eb yin. Yu jun tu', yuxan tu' c'al chi yetne el sba sk'ane Dios yin eb. Laan eb jaxca ixim trigo c'am swatx'il sjolom chi yak'a. ");
INSERT INTO knjNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jal ixim jix ey q'uey bey yax tx'otx' tu' xin, yechel pax eb chi aben sk'ane Dios, catu' chi yaon oc yin sc'ul. Ja' ton eb tu' laan jaxca ixim treinta sbak' chi yak'a. Ey pax eb laan jaxca ixim sesenta sbak' chi yak'a, c'al jun ciento, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jix yal pax tej Jesús jaxca ti': —Ja' yet chi kaon oc cu tzejtebal, toj wal chi kaoctoj yalan junoj cante'. C'am pax chi kaoc yalan junoj tx'at. Ja' yiban junoj tzet yetal naat batxan a oj, ja' tu' chi ka atoj, yet watx' chi tzejtane masanil yul na tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jantaj tzet ewan c'uan ye tinani', oj txeclo c'al ta' a oj yetoj jantaj tzet c'ubabil el tinani', oj ak'le otajnele el oj. ");
INSERT INTO knjNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Na'otane wej wan che yab ti' sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ak' wej je txiquin yin tzet che yabe, yutol jaxca che yute je yak'on je txiquin tu', jaxca tu' oj yute yak'on Dios na'cha el je yu. Catu' yel xa c'al oj yak' na'cha el je yu. ");
INSERT INTO knjNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yutol ja' mac chi yoche chi na'cha el yu, yel xa c'al oj ak'le na'cha el yu eb. Jal eb c'am chi yoche chi na'cha el yu xin, ja' nioj tzet ian chi na'cha el yu eb, oj i'le ec' tet eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jix yal pax tej Jesús jaxca ti' tet eb: —Oj waltej e ex tzet oj yun yel oc eb chi oc Dios Yaawil oj. K'inaloj junoj winaj chi txi'on jinat sat x'otx'. ");
INSERT INTO knjNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chi lawi tu' chi wey jun ak'bal, catu' chi a waan jun jun sk'inibalil. Yajban chi ec' tiempo, chi aol yawo naj tu', catu' chi ch'ibi. Pero man yotaj oj naj tzet chi yun ẍ'ibi, ");
INSERT INTO knjNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","yutol asan yu syaxil tx'otx' chi ch'ibi. Yin sbabelal, xaj jix to c'al. Catu' chi can sjolom, catu' chi yak'on sat. ");
INSERT INTO knjNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ja' yet chi taj el oj, chi c'uple a oj, yutol chi a apnoj stiempoal. ");
INSERT INTO knjNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","¿Tzet chi yun ya can sbisil eb ánima chi oc Dios Yaawil oj, che na'? Oj waltej jun k'ane je yabe, tzet chi yun ẍ'ib sbisil eb. ");
INSERT INTO knjNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Laan eb jaxca junoj sbak' mostaza chi awle bey junoj tx'otx'. Ja' jun an jinat tu', caw yali' ch'an an yintaj masanil wanoj xa jinat bey yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero asan yawchai, chi ch'ibi, yel miman chi yun yintaj masanil wan xa ita. Mimej chi yun sk'ablaj, yuxan masanta' no' tz'iquin chi oc ewan no' yalan yenel, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ja' yet jix yalon el sk'ane Dios Jesús tet eb ánima, ec'al wan k'ane jaxca wan ti' jix yaltej. Asan wan chi na'cha el yu eb jix yaltej. ");
INSERT INTO knjNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Asan c'al wan k'ane ti' jix yak'balne, yet jix k'anab xol eb. Jal tet eb scuywom xin, chi swatx' alne el oj. ");
INSERT INTO knjNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ja' yet jun c'ual tu', yet yey c'ualil, jix yalon Jesús tet eb scuywom jaxca ti': —Toon nej bey jun xa sk'axepal ja', ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yu jun tu' xin, jix bej can eb ánima ey ec' sti' ja' tu'. Catu' jix octoj eb yul te' barco bey ey oc Jesús tu', catu' jix to eb. Ey wan xa barco jix to pax yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pero ey jun miman ka'e' caw jow jix apni yiban ja'. Tol tax jix octoj ja' yul te' yu jun ka'e' tu'. Ian jix no el te' yu ja'. ");
INSERT INTO knjNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jal Jesús xin, tol chi wey naj ẍopeltoj te' barco tu', ey oc sk'an. Catu' jix stenle el sweyan naj yu eb tu': —Wuẍtaj, ¿tumi c'am chach oc il nioj? Ila lalan cu lawi el oj, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Catu' jix a waan Jesús tu', jix stenon oc tucan jun ka'e' tu'. Jix yalon pax tet ja' mar: —Ocan tucan oj, ẍi naj tet ja'. Jaxca tu' xin, jix oc tucan jun ka'e' tu', jix num ey masanil. ");
INSERT INTO knjNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Catu' jix yalon tet eb scuywom: —¿Tzet yuxan caw chex xiwi? ¿Tzet yuxan c'am che yaoc je c'ul win an? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tu' c'al jix q'uey a sc'ul eb yu sic'lebil. Catu' jix yalon eb: —¿Tzet la ye jun winaj ti'? Ila chi sjije ka'e' c'al ja' mar tzet chi yala, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jix ec' apnoj Jesús yetoj eb scuywom bey jun xa sk'axepal ja' mar, bey jun lugar chi yij Gadara. ");
INSERT INTO knjNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lalan yeltej Jesús yul barco, catu' jix apni jun winaj sc'atan, speto campo santo. Ja' jun winaj tu', ey oc pena espíritu yin. ");
INSERT INTO knjNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Asan bey mujan eb camnaj caan naj. C'am mac chi tzaje spixon ey naj yetoj cadena. ");
INSERT INTO knjNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tx'ial el xa c'al jix c'al-le ey naj yetoj cadena, chi oc yin sk'ab c'al yin yajan. Pero coc' xa c'al chi yun toj ch'en stujon toj. C'am junoj chi tzaje tet. ");
INSERT INTO knjNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tobal k'inal, c'ualil c'al ak'balil chi ec'ab bey wonanlaj c'al bey campo santo. Chi el yaw. Chi smak'on yasoj sba yetoj ch'en. ");
INSERT INTO knjNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ja' yet jix yilontej yin Jesús naat to ey naj, jix yak'on yip naj stit sc'atan. Jix ey kaan naj sattaj Jesús yet jix apni. ");
INSERT INTO knjNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jix yalon Jesús tu' tet jaxca ti': —Jaach pena espíritu, elan yin naj ti', ẍi Jesús tet. Catu' jix a yaw yin ipal. Jix yalon jaxca ti': —¿Tzet ja walon ja wet win, jaach Jesús? Jaachti' Sc'aal jaach Dios, naj yel xa c'al miman yel oc apnoj. Yu wal dios e ach jin k'an an, manchej jin ja wetne, ẍi jun pena espíritu tu' tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Catu' jix sk'anlen el Jesús tet naj tu': —¿Tzet ja bi? ẍi Jesús tet naj. —Legión cu bi, yutol caw ec'al jon, ẍi wan pena espíritu tu' yin naj. ");
INSERT INTO knjNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Caw jix oc tean yin Jesús, yet watx' c'am chi chejle el eb pena espíritu bey jun lugar tu' yu naj. ");
INSERT INTO knjNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ja' scawilal tu' ey jun wonan. Ey wan no' txitam lalan slowi. ");
INSERT INTO knjNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jix oc tean eb pena espíritu tu' yin Jesús. Jix yalon eb: —Chej jon can toj xol no' txitam tu', yet watx' jaxa yin no' chi cu oc can oj, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Catu' jix cha'letoj eb yu Jesús tu' yin no'. Catu' jix el eb yin naj tu', ja' yin no' txitam tu' jix to can eb. Ey mi caab oj mil no' txitam tu'. Jix sk'ojon el sba no' sat pac'an bey chi low no' tu'. Jix ey apnoj no' xol ja' mar. Pilan jix jik'wi no' titu'. ");
INSERT INTO knjNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ja' eb naj ilom txitam, caw jix xiw a eb naj sic'lebil. Jix to eb el oj. Jix ec' yalon can el eb yul conob, c'al bey naatlaj el oj, yuxan ec'al ánima jix bet ilon tzet jix yun tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jix apni eb ánima bey ey ec' Jesús tu' xin, jix yilon oc eb yin naj bey jix el eb pena espíritu tu', chotan ec' naj titu'. Ey xa oc spichil naj, watx' xa sc'ul naj. Yu jun tu', caw jix xiw a eb ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ja' eb jix ilon wan tzet yetal jix el yunen Jesús tu', ja' eb jix alon yab wan xa eb ánima tu'. Jix yal eb masanil tzet jix yun yin naj bey jix el eb pena espíritu tu', c'al tzet jix yun no' txitam tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yu c'al tu', jix oc tean eb ánima yin Jesús, tol chi el Jesús yul x'otx'al eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ja' yet jix octoj Jesús yul barco, ja' naj bey jix el eb pena espíritu tu', jix oc tean tet naj, tol chi to naj yetoj. ");
INSERT INTO knjNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero ma cha'letoj naj yu Jesús yetoj, jix yalon tet naj jaxca ti': —Paxan bey ja na, catu' cha walon tet ja mam c'al tet eb ja wican jaxca ti': “Tumi jantaj xa tzet jix el yunen Dios win an, jix ok' sc'ul naj win an,” ja chi, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jix to naj tu', jix ec' yalon el naj bey wan conob yul yet Decápolis. Jix yal el naj jantaj tzet jix el yunen Jesús yin naj, yuxan tuxa c'al jix q'uey a sc'ul ánima masanil. ");
INSERT INTO knjNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jix lawi jun tu' xin, catu' jix pax ec' Jesús bey jun xa sk'axepal ja' mar bey speto ta' a'. Ja' yet jix ec' apnoj titu', ec'al ánima jix syamba pax sba yin junel xa. ");
INSERT INTO knjNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jix apni jun yaawil snail sculto eb Israel chi yij Jairo. Jix c'al yil yin Jesús, jix sbejon ey kaan sba sattaj. ");
INSERT INTO knjNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jix c'oli yoc tean yin Jesús, jix yalon tet jaxca ti': —Caw tuxa chi cam jun jin cutz'in an. Toon wetoj an, catu' chi to ja batxban oc ja k'ab yiban ix, yet watx' chi wa'xi can sc'ul ix catu' c'am chi cam ix, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Catu' jix to Jesús yetoj naj. Ec'al ánima jix to yintaj, tuxa c'al chi witz'le xa c'al oc sba eb yin. ");
INSERT INTO knjNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ja' xol ánima tu', ey jun ix ix caw ya' ey sic'lebil, lacaweb xa jabil c'al c'oli yey s'ilal ix. ");
INSERT INTO knjNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ec'al eb anwam bey jix bet yetne sba ix. Pilan jix lawi can el tzet ey ix tet eb. Pero c'am nioj jix wa'xi sc'ul ix yu eb, ja' ti' yet, tol chi c'al a can. ");
INSERT INTO knjNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Pero jix yab sk'umal Jesús ix. Jix sjitz'ontoj sba ix yintaj naj xol ánima tu'. Jix smitx'on sti' spichil naj ix. ");
INSERT INTO knjNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yutol jix sna' ix: “Asanne c'al jin mitx'on nioj sti' spichil naj, oj wa'xoj can jin c'ul,” ẍi ix. ");
INSERT INTO knjNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ja' yet jun txolan tu' jix oc tucna yey s'ilal ix. Jix yab swa'xi can sya'ilal ix tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jix yotajnen el Jesús tol ey mac jix wa'xi can yu yipal naj. Yuxan jix meltzotoj t'anan yintaj yilon xol ánima tu', jix sk'anlen tet eb jaxca ti': —¿Mac txequel jun jix mitx'on jin pichil ti'? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Catu' jix yalon eb scuywom tu' tet naj jaxca ti': —Tol cha wila chi switz' oc sba ánima ja win, catu' chi to wal ja k'anlen pax oj mac jix mitx'on ja pichil, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero ja' Jesús xin, jix ec' c'al t'anan oj xol eb seyoni, mac jun jix mitx'on spichil tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jal ix ix tu' xin, caw chi bilwi a ix yu xiw c'ulal. Yotaj ix, tol jix wa'xi can sc'ul ix yu, yuxan jix to ix sc'atan Jesús, jix ey kaan ix sattaj. Jix yalon ix masanil tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Catu' jix yalon naj tet ix jaxca ti': Txo ix, jix wa'xi ja c'ul yutol jix ja waoc ja c'ul win an. Paxan yin tzala c'ulal. Tol jix wa'xi ja c'ul yin jun ja ya'bilal ti', ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lalan to yalon Jesús, catu' jix apni wan eb jix bet bey sna naj yaawil snail sculto eb Israel tu'. Jix yalon eb tet naj: —Ja' ix ja cutz'in ma'eal cam ix. Na'ba xa c'al mi chi to yetne sba naj Cuywam ti' to yiloni, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero ja' yet jix yaben Jesús tzet jix yal eb tu', jix yalon tet naj yaawil snail sculto tu' jaxca ti': —Manchej jaach oc il. Asan tol cha waoc Dios yin ja c'ul, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jix lawi tu', c'am mac jix ẍa'toj yintaj. Asan Pedro yetoj Jacobo, yetoj Juan yuẍtaj Jacobo tu', asanne eb jix ẍa'toj yetoj. ");
INSERT INTO knjNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jix apni bey sna naj yaaw tu' xin, catu' jix yiloni caw chi ok' ánima. Caw chi wek'ek'i eb yel yaw. ");
INSERT INTO knjNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Catu' jix octoj yul na tu', catu' jix yalon tet eb jaxca ti': —¿Tzet yuxan caw chex ok'i? Ja' ix unin ti', man camnaj oj ix, tu' c'al chi wey ix, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero tu' c'al jix tzeele naj yu eb. Catu' jix ujtele eltej eb sti' na yu, catu' jix yi'on octoj smam c'al xutx ix unin tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jix oc mitx'an yin sk'ab ix, catu' jix yalon tet ix jaxca ti': —Talita cumi, ẍi. Chi yal yel oc apnoj: “Jaach unin, jain chi wal e ach an, aan waan oj.” ");
INSERT INTO knjNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jix a xa c'al waan ix yet jun txolan tu', catu' jix ec'ab ix. Lacaweb jabil xa sk'inal ix. Ja' jantaj eb ey ec' titu', caw jix q'uey a sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jix cam sc'ul Jesús yalon tet eb, tol manchej yal el jun ti' eb. Catu' jix chejle ak'le low ix tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jix pax tej Jesús bey jun lugar bey ey ec' tu', catu' jix apni bey sconob tu'. Jix to eb scuywom yetoj. ");
INSERT INTO knjNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ja' yet sc'ual xewilal jix cuywa yul snail sculto eb Israel. Ec'al mac jix abeni. Pero tu' c'al jix q'uey can a sc'ul eb yu. Jix yalon eb jaxca ti': —¿Beytu' jix scuy jun winaj ti' wan ti'? ¿Beytu' jix yi' sjelanil tu'? ¿Tzet chi yun ske'on milagro tu' yu? ");
INSERT INTO knjNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yutol ja' jun ti', ja' ton jun josom te', yune' ix María. Yuẍtaj sba yetoj Jacobo, José, Judas, yetoj Simón. Ey ec' eb yanab naj cu xol ti', ẍi eb. Yu jun tu', yuxan tu' c'al jix q'uey a sc'ul eb yin. ");
INSERT INTO knjNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Catu' jix yalon Jesús tet eb tu' jaxca ti': —Ey c'al ta' yel oc apnoj eb ẍejab Dios yul sat ánima masanil. Asan yul sat eb yet conob eb, c'al yul sat eb yican eb, c'al yul sat eb junne nail ye yetoj eb, c'am yel oc apnoj eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma ske' yunen junoj milagro titu'. Asan jaywan ya' ey jix sbatxba oc sk'ab yiban, catu' jix wa'xi can sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jix q'uey a sc'ul naj yutol ma yaoc sc'ul eb yin. Jix lawi tu' xin, jix ec' cuywa bey wan aldealaj scawilal sconob tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jix yawtentej eb lacawan scuywom Jesús sc'atan. Catu' catajwan jix yute ẍejontoj eb. Jix yak'on yopiso eb i'o el pena espíritu. ");
INSERT INTO knjNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ja' yet c'am to chi to eb, jix yalon tet eb jaxca ti': —Ja' yet chex toi, c'am c'al yet je be che yi'. Manchej je yi' je pa, je lo'be, c'al je tumin. Asan je k'ojoch che yi'. ");
INSERT INTO knjNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Asan je pichil ey oc ti' che yi'toj, yetoj je xanab. ");
INSERT INTO knjNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yal c'al tzet nail bey chex apni, ja' c'al titu' che yak' je posada masanta' c'al chex to bey junoj xa lugar. ");
INSERT INTO knjNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ta ey bey c'am chex cha'le yu ánima, catu' c'am chi yal sc'ul eb chi yabe, c'am chex can bey jun lugar tu', che tzic can el spojojal je yajan, yu je tx'oxon can el oj, tol c'am xa je yalon je yet yin eb. Caw yel chi wal e ex an, ja' yet oj jul jun c'ual chi na'le oc yin ánima, yel miman castigo oj ẍa' eb mac eb ma jex cha'on tu' yintaj eb a Sodoma c'al eb a Gomorra, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jix to eb scuywom tu' xin. Jix ec' yalon el eb, tol sowalil chi sna' sba eb ánima yin spenail. ");
INSERT INTO knjNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Caw ey pena espíritu jix yi' can el yin eb ánima. Caw ey eb ya' ey jix ec' ya can oc aceite olivo eb yin, catu' jix wa'xi can sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jix yab naj rey Herodes wan tzet chi el yunen Jesús yet jun tiempoal tu', yutol jix sajlemtoj sk'aneal xol masanil ánima. Yu jun tu', yuxan ey eb jix alon jaxca ti': —Ja' jun tu', ja' naj Juan Bautista jix pitzc'u a xol eb camnaj. Yu jun tu', yuxan ey yipal yunen wan tu', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ey wan xa xin, jix yal eb jaxca ti': —Ja' jun tu', ja' naj Elías, ẍi eb. Ey wan xa jix aloni: —Ja' junoj eb ẍejab Dios, jaxca eb yet peyxa, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ja' yet jix yaben naj Herodes wan ti', jix yaloni: —Ja' jun chi yal eb tu', ja' naj Juan, jun jix wak' i'le el sjolom. Ja' ton jix pitzc'u a xol eb camnaj, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Tol yu jun ti', yuxan jix cam naj Juan tu' yu naj Herodes. Ey jun yuẍtaj naj Herodes tu' chi yij Felipe. Herodías sbi yistil. Montebil el yistil naj Felipe tu' yu naj Herodes tu'. Ja' naj Juan jix alon tet Herodes tu' jaxca ti': —Caw c'am sleyal cha monte el yistil naj ja wuẍtaj, ẍi naj tet. Yu jun tu', jix tit sjowal ix Herodías tu'. Jix c'oli yak'on sc'ul oj Herodes ix tu'. Yuxan jix yak' mitx'le Juan, jix yaoc preso catu' jix pixle yetoj cadena. Ja' ix Herodías tu', caw chi chichon oc sc'ul ix yin naj. Chi yoche ix chi yak' cam naj, pero c'am c'al chi ske'. ");
INSERT INTO knjNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yutol yotaj Herodes tu', tol ja' naj Juan, caw watx' sbeybal, catu' tol yet Dios yei. Yu jun tu', jix xiw a yu. Jix yaon oc steynemal tu', yet watx' manchej ak'le cam yu ix Herodías tu'. Ey bey chi yaltej sk'ane Dios Juan tu' tet Herodes tu'. Cax c'al c'am chi na'cha el yu sic'lebil, pero caw chi tzala yaben tet. ");
INSERT INTO knjNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ja' yet jix ẍa'on sk'inal ya'bilal Herodes, jix seyon ix tzet utbil chi yute cam naj Juan tu'. Ey jun miman lo' jix oc yu Herodes tu'. Jix yak' low eb yet yaawilal, yetoj eb yaawil eb soldado, c'al eb mimej winaj yul yet Galilea tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ey jun yune' ix Herodías tu', Jix octoj ix xol bey lalan yoc lo' tu', catu' jix canalwi ix. Watx' xa c'al yec' ix jix yil Herodes yetoj eb ey ec' low yetoj tu'. Yu jun tu', yuxan jix yal Herodes tu' tet ix jaxca ti': —K'an tzet chi yoche ja c'ul e in an, oj wak' e ach an, ẍi naj tet ix. ");
INSERT INTO knjNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jix sloctej sbi Dios, catu' jix yak'on sti' tet ix, jix yaloni: —Yal c'al tzet yetal junoj cha k'an e in an, oj wak' e ach. Cax c'al snan oj bey ey jin oc yaawilal ti', oj wak' an, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ja' yet jix eltej ix xin, jix sk'anlen ix tet xutx jaxca ti': —¿Tzet cha woche chin k'an an? ẍi ix tet xutx tu'. Catu' jix tak'wi ix txutxe tu': —Ja' sjolom Juan Bautista cha k'ana, ẍi ix. ");
INSERT INTO knjNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jix octoj ix sc'atan naj rey tu', catu' jix yalon ix tet jaxca ti': —Chi woche ja' sjolom Juan Bautista cha wak' e in tinani' an. Ja' yul junoj plato chi woche cha wak' e in an, ẍi ix. ");
INSERT INTO knjNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Caw jix cus a naj rey tu' yet jix yaben naj. Pero ma xa ske' sq'uexban naj, yutol jix sloctej sbi Dios naj, catu' jix yaben pax eb ey ec' yetoj naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Catu' jix chejletoj jun soldado yu naj, catu' jix bet tit sjolom Juan. ");
INSERT INTO knjNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jix to jun soldado tu' bey preso xin, catu' jix bet yi'on el sjolom Juan tu'. Jix yi'ontej yul jun plato tu', catu' jix yak'on tet ix. Catu' jix yak'on ix tet xutx tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ja' yet jix yaben eb scuywom Juan tu', jix apni eb, catu' jix bet mujle can smimanil naj yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jix apni eb ẍejab Jesús tu' sc'atan naj junel xa, catu' jix yalontej eb jantaj c'al tzet jix yun eb, c'al tzet jix yak' cuyle can eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jix lawi to c'al yalontej eb, catu' jix yalon Jesús tu' tet eb jaxca ti': —Toon nej xew nioj cu txojli bey c'am ánima, ẍi naj. Jix yal naj jaxca tu', yutol caw c'am nioj scolil eb yu ánima. Ey chi juli, ey chi toi. Caw c'am stiempo eb slowi. ");
INSERT INTO knjNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Catu' jix octoj Jesús yul jun barco tu' yetoj eb scuywom. Catu' jix to eb xojli bey c'am ánima. ");
INSERT INTO knjNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero ec'al ánima jix ilon sto eb. Xax yotajne pax el Jesús eb. Yu jun tu', ec'al eb a conob bey wan conoblaj scawilal tu' jix to yetoj yajan, babel jix apni eb sattaj eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jix eltej Jesús yul barco tu', jix yiloni, tol ec'al eb ánima ey xa ec' oj. Jix ok' sc'ul yin eb tu', yutol laan eb jaxca wanoj no' me' c'am yilomal. Catu' jix c'oli scuyle eb yu. ");
INSERT INTO knjNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ja' yet lalan xa sto c'u, jix apni eb scuywom sc'atan, catu' jix yalon eb tet naj jaxca ti': —Lalan xa sto c'u. Ja' bey lugar bey ey jon ec' ti', cusiltaj tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yuxan tejan watx' cha chejtoj eb ánima ti' bey ey ánima, yetoj bey wan aldea cawil-laj ti', catu' chi smanon low sba eb titu', yutol c'am slo'be eb, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Ak' wej low eb jaexti', ẍi Jesús tet eb scuywom tu'. Catu' jix yalon eb tet: —¿Chi to cu man junoj caab cien quetzal, ch'al tu', catu' chi kak'on low eb? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Jayeb ixim pan i'bil oc je yu? Sey wej ila, ẍi naj tet eb. Jix yilon eb, catu' jix yalon eb tet naj: Asan joeb ixim ketbi, yetoj cac'on no' pescado, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Catu' jix yalon Jesús tol chi ey chotan eb ánima masanil yin bulquiltaj chi yunne eb bey jun ac'al tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jix ey chotan eb tu'. Ey jun jun bulan yin cincuentataj, ey eb yin cien. ");
INSERT INTO knjNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Catu' jix yi'on a ixim joeb pan tu' yetoj no' cac'on pescado tu' Jesús. Jix a t'anan satcan, catu' jix yalon yu diosalil yu. Jix c'oli xi'ontoj ixim, catu' jix yak'on tet eb scuywom yetoj cac'on no' pescado, catu' jix spo'on ec' eb xol ánima. ");
INSERT INTO knjNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Masanil ánima watx' jix yun slow eb sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ja' yet jix lawi slow eb tu' lacaweb to xuc jix no yu sobra ixim, c'al sobra no' pescado jix yambale a yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ja' eb winaj jix low tu', joeb mil eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jix lawi jun tu' xin, jix yalon Jesús tet eb scuywom tol chi oc eb yul barco, catu' chi babi k'axpo ec' eb sattaj naj, chi ec' apnoj eb bey conob Betsaida. Jal Jesús xin, jix to can yu yalontoj sba tet eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jix lawi yalontoj sba tet eb xin, jix to bey jun wonan txaloj. ");
INSERT INTO knjNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ey xa ec' te' barco tu' snan ja' yetoj eb scuywom yet jix k'ejbi. Jal Jesús tu' xin, ey to can ec' sat tx'otx' xojli. ");
INSERT INTO knjNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Catu' jix yilontoj, caw chi el yip eb smak'on ja', yutol jow sjul ka'e' sattaj eb. Ja' yet tuxa chi sajbi, jix beytoj Jesús yetoj yajan yiban ja'. Chi yoche chi babi sattaj eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ja' yet jix yilontoj eb tol chi bey naj yiban ja', jix sna' eb tol lab jun chi jul sc'atan eb tu', yuxan caw jix el yaw eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jix xiw a eb masanil, yutol masanil eb jix iloni. Catu' jix yalon naj tet eb jaxca ti': —Manchej jex oc il. Jain Jesús jin an. Manchej jex xiwi, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jix lawi tu', jix atoj yetoj eb yul barco tu', catu' jix oc tucan ka'e' tu'. Tuxa c'al jix q'uey can a sc'ul eb yu masanil. ");
INSERT INTO knjNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Cax c'al xax yil smilagro Jesús eb yin ixim joeb pan, pero c'am to chi na'cha el yopiso yu eb, yutol c'am to chi jajcha sna'bal eb. ");
INSERT INTO knjNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jix k'axpo ec' eb xin, jix ec' apnoj eb bey conob Genesaret. Jix can can sbarco eb bey sti' ja'. ");
INSERT INTO knjNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jix c'al eltej eb yul barco tu', jix yilon oc eb ánima tol ja' Jesús jix juli. ");
INSERT INTO knjNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yuxan jix to eb sbatxtej masanil eb ya' ey bey jun lugar tu', jix i'letej eb sc'atan Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yal c'al bey jix ec' naj, yul-laj aldea ma yul-laj conob, ma bey caan ánima naatlaj el oj, jix i'le eltej eb ya' ey yul-laj calle. Jix sk'anon eb smitx' nioj sti' spichil naj. Masanil eb jix mitx'on sti' spichil naj tu', jix wa'xi c'al can sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ey wan eb fariseo c'al wan eb cuywam yin sley Moisés jix tit bey Jerusalén, jix syamba oc bulan sba eb yin Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jix yil eb, tol ey jaywan eb scuywom Jesús c'am chi sajbane sk'ab eb yet chi low jaxca yalon sleyalil eb, yuxan pena jix can eb yul sat eb, yu ma sajbane sk'ab eb. Yu jun tu' xin, jix al-le eb penail yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ja' eb fariseo tu', c'al masanil eb Israel, beybalnebil c'al sbeybal yichmam eb yu, yuxan ta c'am chi cam sajbane sk'ab eb jaxca yalon sbeybal eb tu', tutun c'am chi low eb. ");
INSERT INTO knjNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ja' yet chi jul eb yet chi bet eb txombal, masanta' c'al chi cam sajbane sk'ab eb catu' chi low eb, jaxca yalon sley eb tu'. Ey to c'al wan xa tzet yetal chi sbeybalne eb, jaxca sajbanilal svaso eb, c'al ẍalu, c'al masanil smitx'k'ab eb yet lo', c'al sweyub eb. ");
INSERT INTO knjNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yuxan jix yal eb fariseo tu' c'al eb cuywam yin sley Moisés tet Jesús jaxca ti': —¿Tzet yuxan c'am chi sbeybalne eb ja cuywom wan sbeybal eb kichmam? Pena chi can eb, yutol c'am chi x'a' sk'ab eb catu' chi low eb, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Catu' jix yalon Jesús tet eb jaxca ti': —Jaexti' caw caab sat jex. Yel ton ta' tzet albil can yu Isaías je yin, yet jix s'iben can jaxca ti' yul An Juun Tz'ibebil can oj: Ja' wan ánima ti', yin c'al ch'an sti' eb ey oc swatx' k'ane chi yal e in an. Pero naat el sna'bal eb win an. ");
INSERT INTO knjNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na'ba c'al chi tz'aj yi' ey sba eb e in an. Asan wan ẍejbanil ánima chi yak' cuyle eb. Pero jaxca tol jin chejbanil chi yute oc eb, ẍi Dios yul An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jaexti', jix je bej can ẍejbanil Dios, ja' scuybanil je yichmam che beybalne. Jaxca x'a'banil ẍalu tu', c'al vaso tu'. Ey to c'al wan xa che beybalne jaxca wan ti'. ");
INSERT INTO knjNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yu c'al je beybalnen wan sbeybal je yichmam, yuxan che bejon can je beybalnen ẍejbanil Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Jix yal can Moisés jaxca ti': “Ey ojab yel oc apnoj je mam c'al je txutx yul je sat. Ja' mac chi sba smam ma xutx, cam ojabi,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero ja' je yalon jaexti', tol man sowalil oj chi colwa junoj mac txequel tet smam ma tet xutx. Ila ta ey junoj mac chi alon tet smam ma tet xutx jaxca ti': “C'am chi ske' jin colwa e ex, yutol masanil tzet ey e in an, yet xa Dios yei,” ta ẍi. ");
INSERT INTO knjNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ta ey mac chi yal jaxca tu', man xa sowalil oj chi colwa tet smam c'al tet xutx je yaloni. ");
INSERT INTO knjNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Cac'al ton tu' che yute je yintajnen el ẍejbanil Dios, pero ja' pax sbeybal je yichmam che yak' cuyle oj. Catu' ec'al to c'al wan xa che beybalne jaxca wan ti', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jix lawi tu' xin, jix yawten pax tej eb ánima Jesús tu' junel xa. Jix yalon tet eb jaxca ti': —Ab wej je masanil tzet oj wal an. Na'cha ojab el je yu. ");
INSERT INTO knjNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ja' tzet chi octoj yul cu ti', c'am chi cu tz'ilbitoj yu yul sat Dios. Ja' wan tzet chi tit yin cu na'bal, ja' chi cu tz'ilbinentoj yul sat Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Na'otane wej sic'lebil wan tzet chi wal ti' an, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Catu' jix el Jesús tu' xol eb ánima tu', catu' jix octoj yul na yetoj eb scuywom tu'. Jix sk'anlen el eb tet naj: —¿Tzet chi yal yel oc apnoj jun cuybanile jix ja wal ti'? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Catu' jix yalon tet eb jaxca ti': —¿Tumi c'am chi na'cha pax el je yu, jaexti'? ¿Tumi man je yotaj oj, tol ja' tzet chi octoj yul cu ti', c'am chi cu tz'ilbitoj yul sat Dios yu? ");
INSERT INTO knjNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yutol manaj bey cu na'bal chi apni. Ja' yul cu c'ul chi ey apnoj, chi lawi tu' xin, chi eli, ẍi Jesús tet eb. Quey tu' jix yute yalon jaxca tu', tzet utbil tol jantaj c'al tzet chi lo'le c'al ta' a', c'am sleyal yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jix yalon pax jun xa ti' tet eb: —Ja' wan tzet chi tit yin cu na'bal, ja' chi cu tz'ilbinentoj yul sat Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yutol ja' yin sna'bal ánima chi pitzc'u a wan pena na'bale ti'. Ey mac ey xa yetbi, catu' chi yunen mul yetoj junoj xa mac txequel. Ey eb man to c'al yetbi oj sba, catu' chi yunen mul. Ey eb chi smak' cam yet animail. ");
INSERT INTO knjNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ey eb chi elk'anwi. Ey eb chi ochen oc tzet ey bey junoj xa. Ey eb c'am swatx'il chi yute sba. Ey eb chi yak' lek'ti'al. Ey eb c'am chi q'uixwi yunen junoj tzet yetal yin comon c'al. Ey eb chi chichon oc sc'ul yin junoj mac txequel yu tzet ey tet. Ey eb comon c'al chi buchwai. Ey eb chi smimanne sba. Ey pax mac c'am sna'bal. ");
INSERT INTO knjNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ja' wan spenail ti', ja' yin sna'bal ánima chi pitzc'u a oj. Ja' chi tz'ilbinen el eb yul sat Dios, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Catu' jix to Jesús tu' bey jun lugar chi yij Tiro c'al Sidón. Jix apni bey jun na, ma yoche jix abcha a oj ta ey ec' naj titu', pero jix abchai. ");
INSERT INTO knjNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ey jun ix ix ey jun yune' k'opo ey oc pena espíritu yin titu'. Jix yab sk'umal ix txutxe tu' tol jix apni Jesús titu'. Catu' jix to ix sc'atan naj, jix bet ey kaan ix sattaj. ");
INSERT INTO knjNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ja' jun ix ix tu', man Israel oj ix, a Sirofenicia ix. Jix sk'an ix tet Jesús tol chi yi' el jun pena espíritu yin ix k'opo tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero jix yal Jesús tet ix jaxca ti': —Low ojab eb uninale babel. Man watx' oj ta chi tok'le ec' slo'be eb, catu' chi ak'le tet no' tx'i', ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Catu' jix tak'wi ix tet naj jaxca ti': —Yel ton Mamin, pero ja' no' tx'i', chi sic' a sc'ail slo'be eb uninale chi ey c'otna yalan meẍa, ẍi ix tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yu jun tu', yuxan jix yal naj tet ix jaxca ti': —Ja' jun cha wal e in ti' an, caw watx'. Chi ske' chach pax bey ja na, yutol jix el jun pena espíritu tu' yin ix ja wune' tu', ẍi naj tet ix. ");
INSERT INTO knjNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ja' yet jix apni ix bey sna, jix yilon ix, telan atoj jun yune' ix tu' sat tx'at, xax el jun pena espíritu tu' yin ix. ");
INSERT INTO knjNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jix el Jesús bey Tiro bey ey ec' tu' xin, jix ec' bey conob Sidón, c'al bey wan conob yul yet Decápolis. Catu' jix apni bey sti' ja' mar Galilea. ");
INSERT INTO knjNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ja' yet ey ec' titu', jix i'letej jun winaj c'am chi yabe yu wan ánima tet naj. C'am chi ske' pax sk'anab jun winaj tu'. Jix sk'anon eb tet Jesús yet watx' chi ya oc sk'ab Jesús yiban naj. ");
INSERT INTO knjNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Catu' jix yi'on el naj txojli xol ánima tu'. Jix yaon octoj jun yiximal sk'ab naj yul jun jun xiquin naj. Jix lawi jun tu' xin, catu' jix tz'uben Jesús yin sk'ab, catu' jix yaon oc yin yak' naj. ");
INSERT INTO knjNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Catu' jix a t'anan Jesús satcan tu', jix a sc'ul, catu' jix yalon jaxca ti': —Efata, ẍi. Chi yal yel oc apnoj. Jajchaan can oj. ");
INSERT INTO knjNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ja' yet jun txolan tu', jix jajcha can xiquin naj tu'. Jix wa'xi pax can yak' naj, jix k'anab a naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Catu' jix cam can yalon Jesús tet eb ánima tu' jaxca ti': —C'am bey che yal jun ti', ẍi naj tet eb. Pero ja' yet jix yalon tet eb jaxca tu', yel xa c'al jix yal el eb. ");
INSERT INTO knjNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Caw jix q'uey a sc'ul eb ánima tu'. Jix yalon eb jaxca ti': —Caw watx' chi yun swa'nen masanil tzet yetal. Chi jajcha xiquin eb c'am chi yabe yu, catu' chi k'anab can a eb c'am c'al ta' chi ske' sk'anabi, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ja' yet jun tiempoal tu', caw ec'al ánima jix yamcha yin Jesús, pero c'am nioj slo'be eb. Yu jun tu', yuxan jix yawtetej eb scuywom sc'atan, catu' jix yalon tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Caw chi ok' jin c'ul yin wan ánima ti', yutol oxeb xa c'u ey c'al ec' eb ketoj, ja' tinani' c'am xa tzet chi slo' eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ta c'am chi low eb catu' chi cu chejon paxtoj eb bey sna, chim telc'o eb yul-laj be yu wail. Yutol ey eb yel naat ey, ẍi Jesús tet eb scuywom tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—Pero, ¿tzet wal oj kak' slo' eb bey jun cusiltaj tx'otx' ti'? ẍi eb scuywom tu' tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Jayeb ixim pan je yetbi? ẍi naj tet eb. —Jujeb ixim, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Catu' jix ẍejon ey chotan eb ánima Jesús tu' sat tx'otx'. Jix yi'on a ixim pan tu' sjujebal, catu' jix yalon yu diosalil yu ixim. Jix spo'on ec' oj, jix yak'on tet eb scuywom. Ja' eb jix po'ontoj xol ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ey pax jayc'on no' pescado yetbi eb. Jix yalon pax yu diosalil tet Dios, catu' jix yalon tet eb scuywom tu', tol chi po'le ec' no' xol eb ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jix low eb masanil, watx' jix yun sno sc'ul eb. Ja' yet jix lawi slow eb tu', jujeb xuc jix no can yu sobrail ixim jix to cani. ");
INSERT INTO knjNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ey mi pax caneb oj mil eb jix lowi. Jix lawi tu' xin, catu' jix yalontoj sba Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jix octoj naj yul barco yetoj eb scuywom. Jix to eb bey yul-laj yet jun lugar chi yij Dalmanuta. ");
INSERT INTO knjNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ey wan eb fariseo jix apni sc'atan Jesús. Jix c'oli steelen sba eb yetoj, yu yak'on porobal eb. Yuxan jix sk'an eb yil junoj milagro chi tit bey Dios tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jix a sc'ul Jesús, catu' jix yalon tet eb jaxca ti': —¿Tzet yuxan chi sk'an wan ánima ti' yil junoj milagro e in an? Caw yel chi wal e ex an, c'am junoj milagro oj tx'oxle yil eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Catu' jix el sc'atan eb fariseo tu', catu' jix octoj yul te' barco junel xa yetoj eb scuywom. Jix k'axpo ec' eb bey jun pac' xa ja' mar tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma c'al sna' eb scuywom Jesús tu' yi' span yul te' barco. Asan ch'an jun jenan ixim jix yi' eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jix yalon Jesús tet eb tu' jaxca ti': —Ab wej. Che yil c'al je ba yu yich span eb fariseo, c'al yu yich span Herodes, ey smey chex etex el yu, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Catu' jix yalon eb cuywom tu' yu tzet jix yal tu': —¿Jam yu c'am cu pan i'bil, yuxan quey tu' chi yala? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Catu' c'am chi na'cha yu eb tol chi yal yu scuybanil eb fariseo yet chi yal yin yich span eb. Yotaj Jesús tzet chi yal eb. Yu jun tu', yuxan jix yal tet eb jaxca ti': —¿Tzet yuxan caw che yala, tol c'am je pan i'bil je yala? ¿Tumi c'am to chi na'cha el je yu? ¿Tumi man to je yotaj oj, tzet chi yal yel oc apnoj jun ti'? C'am to c'al chi jul je na'bal. ");
INSERT INTO knjNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Tumi c'am che yil xin, tumi c'am che yab sk'umal? ¿Tumi c'am xa che na'tej? ");
INSERT INTO knjNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ja' yet jix jin po'on ec' ixim joeb pan xol ánima, ¿jayeb to xuc jix no can yu sobra? ẍi naj tet eb. —Lacaweb to xuc, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Jal pax yet jix jin po'on ec' ixim jujeb pan xol eb caneb mil ánima, ¿jayeb to xuc jix no can yu sobra ixim? ẍi naj tet eb. —Jujeb to xuc, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—¿Tzet yuxan c'am to c'al chi na'cha el nioj je yu xin yet chi wal yin yich span eb fariseo? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jix lawi jun tu', jix apni eb bey conob Betsaida. Catu' jix i'letej jun winaj c'am chi ske' yilwi sc'atan Jesús tu' yu ánima. Jix sk'anon eb tet naj tol chi yaoc sk'ab yiban naj. ");
INSERT INTO knjNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Catu' jix oc mitx'an naj yin sk'ab naj tu'. Jix quetzle el naj sti' conob yu Jesús. Jix yaon oc nioj s'ub naj yin sat naj tu'. Jix yaon oc sk'ab naj yiban naj, catu' jix sk'anlen naj tet, ta chi xa ske' yilon nioj. ");
INSERT INTO knjNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jix yak'len naj yiloni, jix yalon naj tet Jesús jaxca ti': —Chi xa wil yec'ab ánima, asan tol jaxca te' te' chi wil an, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yuxan jix yaoc sk'ab Jesús yiban sat naj junel xa. Catu' jix wa'xi xa c'al yilwi naj sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Catu' jix chejle pax naj yu Jesús bey sna. Jix yalon tet naj jaxca ti': —Manchej jaach ec' yul conob. C'am pax cha wal jun ti' tet junoj mac txequel titu', ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jix lawi jun tu', jix ec' Jesús yetoj eb scuywom bey wan aldealaj bey conob Cesarea yet Filipos. Jix sk'anlen naj yul-laj be tet eb: —¿Mac jin txequel yalon eb ánima che yabe? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—Ey eb chi aloni tol ab Juan Bautista jaach, yal eb. Ey eb xin, tol ab Elías jaach, yalon eb. Ey mac xin, tol ab ẍejab Dios jaach, ec'naj jaach ab peyxa, ẍi eb scuywom tu' tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Jal jex pax oj, ¿mac jin txequel je yaloni? ẍi naj tet eb. Catu' jix tak'wi naj Pedro tet naj jaxca ti': —Jaachti', jaach ton Cristo, Ak'bil ja Wopiso Colwawomal jaach, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Catu' jix yalon Jesús tet eb jaxca ti': —C'am bey che yal el jun ti', ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Catu' jix c'oli yalon naj tet eb scuywom tu', tzettaj yetal oj jul yiban. Jix yalon naj jaxca ti': —Jainti', Ak'bil Wopiso xol eb ket animail yu Dios ti', pero sowalil miman sya'ilal oj ec' el wiban an. Ja' eb ichamtaj winaj ey yopiso, yetoj eb yaawil yak'omal xaambal tet Dios, c'al eb cuywam yin sley Moisés, oj jin yintajne el eb an. Oj jin yak' cam eb an. Pero ja' yet yox c'ual tu', oj jin pitzc'u a oj, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jichan c'al jix yute yalon Jesús tu' wan ti' tet eb. Catu' jix i'le el naj xojli yu Pedro tu', jix yak'len tenon oc tucan yaloni. ");
INSERT INTO knjNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Catu' jix to t'anan Jesús yin eb scuywom tu'. Jix tenchanen Pedro, jix yalon tet naj jaxca ti': —Jaach Satanás, elan jin c'atan an, yutol manaj tzet chi sna' Dios cha na'. Asan yin yet ánima ey oc ja na'bal, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Catu' jix yawten eb scuywom c'al eb ánima. Jix yalon tet eb: —Ta ey mac chi yoche chi ec' c'al cuywoj wintaj an, sowalil ojab man xa yetoj sba yul yet. Yab ojab eb sya'il wu an, cax c'al chi ale oc eb yin culus. Ta bejan sc'ul eb jaxca tu', ec' ojab c'al eb cuywoj wintaj an. ");
INSERT INTO knjNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yutol ja' eb c'am chi yoche chi cam bey yul yiban k'inal ti', chi sbej el eb jun k'inale tol ey c'al yin tobal k'inal. Jal pax eb chi bejcha sc'ul scam wu xin, c'al yu sk'aneal colbanile, ja' ton eb tu' oj ẍa' sk'inal tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","K'inaloj ta chi kak' ganar ki'on masanil tzet ey yul yiban k'inal ti', pero c'am pax scolbanil cu pixan, ¿tzet wal cu ganar jaxca tu'? ");
INSERT INTO knjNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Tzet wal oj kak' stool oj scolchabal cu pixan tu'? ");
INSERT INTO knjNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ja' eb ánima yet jun tiempoal ti', manaj yin Dios chi yaoc sna'bal eb, caw pena eb. Ta ey mac chi q'uixwi a wu sattaj eb, catu' chi q'uixwi pax a yu jin k'ane, oj jin q'uixwoj pax a yu eb, jain Ak'bil Wopiso yu Dios xol eb ket animail ti' yet oj jin jul yetoj swatx'il c'al yipal jin Mam an, c'al eb ángel asan Dios ey yet. ");
INSERT INTO knjNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jix yalon pax Jesús tet eb jaxca ti': —Caw yel chi wal e ex an, ey jaywan je xol mac jex ey jex ec' ti' oj to je yil yoc can Dios yin Yaawil yetoj yipal yet c'am to chex cami, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jobix jix to yalon Jesús wan tu', jix yi'ontoj Pedro, yetoj Jacobo c'al Juan bey jun miman wonan. Asan eb jix to yetoj naj. Jix q'uexmo yili naj titu' sattaj eb. ");
INSERT INTO knjNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jix tzejeji a spichil. Saj lukinaj xa c'al jaxca sajbat. C'am junoj tx'a'wom yul yiban k'inal ti' chi apni sajbanen pichile jaxca yet tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Catu' jix yilontoj eb oxwan tu', ey ec' naj Elías yetoj Moisés. Lalan sk'anab eb yetoj Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yuxan jix yal naj Pedro tet Jesús jaxca ti': —Wuẍtaj, jaach Cuywam, caw watx' ket yutol ey jon ec' titi'. Tejan watx' chi cu wa'ne oxeb oj pat, junoj ja wet, junoj yet Moisés, yetoj junoj yet Elías, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Caw jix xiw a eb scuywom Jesús tu', yuxan man yotaj oj Pedro tzet jix yala. ");
INSERT INTO knjNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jix lawi tu' xin, catu' jix ey jotna jun asun yiban eb. Catu' jix eltej jayeb k'ane xol jun asun tu', jix yal jaxca ti': —Ja' ton jin C'aal bey miman chi cam el jin c'ul ti' an. Ak' wej je txiquin tet, ẍi. ");
INSERT INTO knjNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Catu' jix yilontej eb, c'am xa mac ey ec' oj. Asanxane Jesús ey ec' oj. ");
INSERT INTO knjNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ja' yet lalan spax eytej bey jun wonan tu', jix yalon naj tet eb jaxca ti': —C'am junoj mac bey che yal el jun tzet jix je yil ti'. Ja' to yet oj jin pitzc'u a xol eb camnaj, jain Ak'bil Wopiso yu Dios xol eb ket animail ti', ja' yet tu' oj je yalon el oj, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yu jun tu', yuxan c'ubabil ey jun k'ane ti' yul sc'ul eb. C'am bey jix yal eb. Ja' yet jix yalon tol oj pitzc'u a xol eb camnaj tu', jix c'oli sna'otanen eb, tzet chi yal yel oc apnoj jun k'ane tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Catu' jix sk'anlen el eb jun ti' tet naj: —Ja' eb cuywam yin sley Moisés chi yal eb jaxca ti': “Ja' Elías, sowalil oj baboj jul oj,” ẍi eb. ¿Tzet yuxan chi yal eb jaxca tu'? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Catu' jix yalon tet eb tu' jaxca ti': —Yel toni, sowalil oj baboj jul naj Elías tu', yet watx' chi sna' sba eb ánima yin spenail. Pero, ¿tzet chi yal An Juun Tz'ibebil can win jain Ak'bil Wopiso yu Dios xol eb ket animail ti'? Chi yal yul An tol oj wil sya'ilal, catu' oj jin intajnele can el yu ánima. ");
INSERT INTO knjNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Chi wal e ex an, tol ja' Elías tu', julnaj xa ec' oj. Ey eb jix yak' sna'bal oj yetnen jaxca chi yoche sc'ul eb. Jaxca jix al-le can yin naj yul An Juun Tz'ibebil can oj, quey ton tu' jix yute eb, ẍi naj tet eb scuywom tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ja' yet lalan yapni eb bey ey ec' wan xa eb cuywom, jix yilontoj Jesús, tol ec'al ánima ey ec' yetoj eb. Ja' eb cuywam yin sley Moisés, lalan steelen sba eb yetoj eb scuywom Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ja' yet jix yilontoj masanil eb ey xa ec' tu', tol chi apni Jesús, caw jix q'uey a sc'ul eb. Yuxan jix yak' ani eb sto ẍa'oni. ");
INSERT INTO knjNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ja' yet jix apni eb sc'atan, jix sk'anlen el naj tet eb jaxca ti': —¿Tzet yinal che teele je ba yetoj eb? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ey jun naj jix tak'wi a xol eb ánima tu': —Mamin, jaach Cuywam, jix wi'tej jun jin c'aal e ach an. Ey oc pena espíritu yin, yuxan c'am chi ske' sk'anabi. ");
INSERT INTO knjNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yal c'al bey ey ec' naj catu' chi tita, chi telc'o naj yu. Chi eltej som sti' naj yu, catu' chi natx'atx'i ye naj. Caw lalan sbajbitoj naj yu. Jix wal-le tet eb chi ec' c'al cuywoj ja wintaj an, tol chi yi' can el eb yin naj, pero ma ske' yu eb, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Catu' jix yalon Jesús tet eb tu' jaxca ti': —Jaexti', caw c'am che yaoc je c'ul yin Dios. Miman xa tiempo c'al we ec' je yetoj an, ¿bak'in to c'al oj na'cha el je yu xin? Chi yab sya'il jin c'ul je yu. Asi' i' wej tej jun unin tu' e in an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jix bet yi'ontej naj. Ja' yet jix yilon oc jun pena espíritu tu', tol ja' Jesús, jix yi' sjowal yin jun unin tu'. Jix telc'otoj naj unin tu', catu' jix c'oli yec' pitxpon naj yu. Jix elol som sti' naj. ");
INSERT INTO knjNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Catu' jix sk'anlen Jesús tet smam jun unin tu': —¿Jantaj xa stiempoal smi'cha yu? ẍi Jesús tet naj. Catu' jix yalon naj mame tu' jaxca ti': —Yin tax syaliẍal ey xa oc yin. ");
INSERT INTO knjNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ec'al xa el chi to yiban k'ak' yu, c'al xol ja', chi yoche chi yak' cam oj. ¿Ta chi ske' ja wu, catu' ta chi ok' ja c'ul kin, colwaan, ja wi'on el yin jin k'an an? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—Chi ske' ta cha waoc Dios yin ja c'ul. Ja' masanil eb chi yaoc sc'ul yin Dios, masanil c'al tzet yetal chi ske' yu eb, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Catu' jix a yaw smam naj unin tu' yin ipal: —Chi waoc yin jin c'ul an. Ocan wetoj catu' chi a c'al can waon oc yin jin c'ul, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ja' yet jix yilon Jesús tol ec'al ánima chi syamba sba yin, catu' jix tzuon jun pena espíritu tu': —Jaach pena espíritu ak'om chacanboj ánima c'al ak'om umisboj ánima, chi wal e ach an, elan yin jun unin ti'. C'am xa chach oc yin junel xa, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Catu' jix el yaw jun pena espíritu tu'. Jix jowbi yin jun unin tu' junel xa. Catu' jix el yin, jix ey can jilan yu. Yu jun tu', yuxan ec'al eb jix aloni tol jix cam xa c'al naj. ");
INSERT INTO knjNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ja' naj Jesús, jix oc mitx'an yin sk'ab naj, jix sq'uetzon a waan. Catu' jix a waan naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jix lawi tu' xin, catu' jix octoj xojli yetoj eb scuywom yul jun na tu'. Jix sk'anlen el eb tet jaxca ti': —¿Tzet yuxan ma ske' ku ki'on el jun pena espíritu tu'? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Catu' jix yalon naj tet eb: —Ja' jun tujan pena espíritu tu', man comon oj chi eli. Asan ta chex txali, catu' che yijle nocha je ba chi ske' je yi'on el oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ja' yet jix el eb titu', catu' jix to eb, jix ec' eb yul-laj yet Galilea. Jix yoche Jesús tol c'am mac jix aben yapni, ");
INSERT INTO knjNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","yutol lalan scuywa tet eb scuywom. Yuxan jix yal tet eb jaxca ti': —Jainti', cax c'al Ak'bil Wopiso xol eb ket animail yu Dios ti', pero oj jin ale oc yul sk'ab wan winaj. Oj jin yak' cam eb. Pero ja' yet yox c'ual, oj jin pitzc'u a oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero ja' eb xin, ma na'cha el yu eb tzet chi yala. Pero yutol chi xiw eb sk'anlen el tet naj, ma pax sk'anle eb tzet chi yal yel oc apnoj wan ti'. ");
INSERT INTO knjNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Catu' jix apni eb bey conob Capernaum. Ja' yet ey xa ec' eb bey sna jix sk'anlen naj tet eb jaxca ti': —¿Tzet jix je yal yul-laj be? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero tz'in xa c'al ẍi eb, yutol ja' yet ey oc eb yul be tu', chi c'oli yalon eb, mac txequel junoj miman yel oc apnoj xol eb tu', yutol jun jun c'al eb, miman yel oc apnoj eb sna'oni. ");
INSERT INTO knjNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yuxan jix ey chotan Jesús. Jix yawtentej eb slacawanil sc'atan, catu' jix yalon tet eb jaxca ti': —Ta ey junoj chi yoche je xol ti', tol miman chi yun yel oc apnoj, sowalil chi oc je yak'omal oj servil je masanil, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Catu' jix yi'ontej jun unin Jesús xol eb. Jix slacon a oj, catu' jix yalon tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Yal c'al mac chi cha'on apnoj junoj unin jaxca jun ti' yin jin bi, jaxca tol jain chin ẍa' apnoj, man asanne oj jin chin ẍa' apnoj eb, chi ẍa' pax apnoj naj jix jin chejontej, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Catu' jix yalon naj Juan tet Jesús jaxca ti': —Wuẍtaj, jaach Cuywam, ey jun winaj jix kila, lalan yi'on el pena espíritu yin ánima yin ja wipal. Pero jix cu tenchane, yutol man junne oj chi ec' ketoj, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Catu' jix yalon Jesús tu': —Ma ske' je tenon oc tucan yunen naj. Yutol c'am junoj mac txequel chi xew yak'on junoj milagro yetoj wipal, catu' chi yalon pax jin k'umal. ");
INSERT INTO knjNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yutol ja' eb man ac'ul oj oc kin, ja' ketoj ey oc eb. ");
INSERT INTO knjNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yal c'al mac chex colon eltej yalan, yutol wet jex jain Cristo jin ti' an, yuxan cax c'al siquil ja' junoj vaso ja' chi ak'le e ex, sowalil oj ẍa' eb spaj. ");
INSERT INTO knjNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ta ey mac chi ak'on etex el sna'bal junoj unin tol chi yaoc sc'ul win an, caw ok'bal c'ule. Yel mi watx' chi pixle oc t'unan junoj miman ẍ'enal molino yin snuk' sbabelal catu' chi k'ojletoj xol ja' mar, yet watx' c'am chi yak' etex el sna'bal jun mac txequel tu', catu' c'am chi a can jun spenail tu' yiban jun chi yun jaxca tu' yutol caw pena jun ti' yul sat Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Yetoj pax oj, ta ey junoj je k'ab chi ak'on etex el je na'bal, yel watx' che tzoc' el jun je k'ab tu', yet watx' c'am chi etex el je na'bal junelne. Yutol cax c'al junxane je k'ab, pero ta oj je cha' je k'inal tol ey c'al yin tobal k'inal, watx' je yet. Pero ta oj jex to can bey sya'tajilal xin, bey c'am chi tan k'ak' k'ak', cax c'al tz'ajan masanil yetbi je mimanil, pero pena c'al ta' je yet.  ");
INSERT INTO knjNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ja' jun k'ak' tu' c'am bak'in oj tan oj. Yuxan c'am pax bak'in oj lawoj yaben sya'il ánima titu'. ");
INSERT INTO knjNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ta ja' junoj je yajan chi ak'on etex el je na'bal, yel watx' che tzoc' el jun je yajan tu', yet watx' c'am chi etex el je na'bal yu jun tu' yin junelne. Yutol cax c'al junxane je yajan, pero ta oj je cha' je k'inal tol ey c'al yin tobal k'inal, watx' je yet. Pero ta oj jex toj can bey sya'tajilal xin, bey c'am chi tan k'ak' k'ak', cax c'al tz'ajan masanil yetbi je mimanil, pero pena c'al ta' je yet.  ");
INSERT INTO knjNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ja' jun k'ak' k'ak' tu', c'am bak'in oj tan k'ak'. Yuxan c'am pax bak'in oj lawoj sya'il ánima titu'. ");
INSERT INTO knjNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ta ja' junoj sbak' je sat chi ak'on etex el je na'bal, yel watx' che yi' eltej, yet watx' c'am chi etex el je na'bal yu jun tu' yin junelne. Yutol cax c'al junxane sbak' je sat, pero ta oj je cha' je k'inal tol ey c'al yin tobal k'inal, watx' je yet. Pero ta oj jex to can bey sya'tajilal xin, bey c'am chi tan k'ak', cax c'al tz'ajan sbak' je sat scaabil, pero pena c'al ta' je yet. ");
INSERT INTO knjNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ja' jun k'ak' tu', c'am bak'in oj tan oj. Yuxan c'am pax bak'in oj lawoj yaben sya'il ánima titu'. ");
INSERT INTO knjNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jaxca chi yun yeytoj yatz'amil tzet chi cu lo', jaxca tu' oj yun yale eytej k'ak' yiban eb masanil. Yetoj pax oj, quey pax tu' masanil xaambal, chi ey yatz'amil. ");
INSERT INTO knjNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ja' atz'am atz'am, caw ey yopiso atz'am. Pero k'inaloj ta ey nioj atz'am chi q'uey el sc'a'chi'al. ¿Tzet to wal oj yun c'a'chibi a junel xa? Jaxca ojab yoc yopiso atz'am atz'am tu' xin, quey ojab jex tu'. Ey ojab pax watx' c'ulal je xol, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jix el Jesús bey Capernaum tu' xin, catu' jix toi, jix ec' yul-laj yet Judea. Jix apni bey jun lugar bey sk'axepal ja' Jordán. Jix syamba pax sba eb ánima titu' junel xa yin naj. Catu' jix cuywa naj tet eb, jaxca c'al ta' sbeybal. ");
INSERT INTO knjNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ey wan eb fariseo jix apni sc'atan, yutol jix yoche eb jix jul yak'le yijban naj eb yin spenail. Yuxan jix sk'anle eb tet naj ta ey sleyal chi spo'le sba junoj winaj yetoj yistil. ");
INSERT INTO knjNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Catu' jix yalon naj tet eb tu' jaxca ti': —¿Tzet ẍi chejbanile ey can yu Moisés yul An Juun Tz'ibebil can oj? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Catu' jix yalon eb: —Ja' Moisés tu', albil can yu, tol chi ske' yak'on yuunal po'lebail junoj winaj tet yistil, catu' chi spo'len sba eb, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Catu' jix yalon Jesús tu' tet eb jaxca ti': —Yu caw caw je na'bal, yuxan yalnaj can Moisés tu' jun chejbanil tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero yet tax c'al jix swa'nen yul yiban k'inal ti' Dios, jix swa'nen pax jun winaj yetoj jun ix. ");
INSERT INTO knjNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Catu' jix yalon can jaxca ti': “Yu jun tu', ja' eb winaj oj el eb yintaj smam c'al xutx, catu' oj sjunbanen sba eb yetoj yistil. ");
INSERT INTO knjNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Catu' jaxca tol junxane animail chi yun can el eb scawanil,” ẍi Dios. Yuxan man xa cawan oj sbey eb, pero tol junxane chi yun can el eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yuxan ja' eb junbanebil yu Dios, cam ojab chi po'le ey snan eb yu ánima, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Catu' jix octoj Jesús yul na yetoj eb scuywom xin, jix sk'anlen el eb tet naj tzet chi yal yel oc apnoj jun tzet jix yal tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Catu' jix yalon naj tet eb jaxca ti': —Yal c'al mac chi spo'le sba yetoj yistil, catu' chi yi'on junoj xa ix, mul chi yune', catu' lalan yaon oc smul yul sk'ab ix. ");
INSERT INTO knjNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yetoj pax oj, yal c'al mac ixal chi spo'le sba yetoj yichamil catu' chi yi'on junoj xa winaj, mul pax chi yune', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ey wan unin jix i'letej sc'atan Jesús yu eb ánima, yu yaontoj sk'ab naj yiban sjolom eb. Pero ja' eb scuywom jix tenon oc tucan eb ánima chi i'on jul eb unin tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ja' yet jix yilon Jesús jaxca tu', jix tit sjowal yin eb. Jix yalon naj tet eb jaxca ti': —Cha' wej jul eb unin e in an. Man je tenoc tucan eb, yutol asan eb laan sna'bal jaxca eb unin tu', asan eb ey yalon yet yoc Dios Yaawil oj. Yutol sowalil che yaoc je c'ul yin Dios jaxca chi yun yaon oc sc'ul eb unin yin smam xutx. ");
INSERT INTO knjNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Caw yel chi wal e ex an, ja' mac man oj cha'on Dios Yaawil oj jaxca chi yute ẍa'on junoj unin, ma oc Dios Yaawil oj eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Catu' jix c'oli slacon a eb unin tu'. Jix yaon atoj sk'ab yiban sjolom eb, catu' jix sk'anon swatx' c'ulal Dios yiban eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lalan xa sto Jesús yul be, catu' ey jun winaj caw ani ye jix apni sc'atan. Jix ey kaan sattaj naj, catu' jix yaloni: —Mamin, jaach watx' cuywam, chin k'anle e ach an, ¿tzet yetal sowalil chi wun an, catu' chin cha'on jin k'inal tol ey c'al yin tobal k'inal? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—¿Tzet yuxan chin ja wal watx'il? Jun ch'an mac txequel watx', asan Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ja wotaj wan ẍejbanil Dios chi alon jaxca ti': “Manchej oc ja mul yul sk'ab ja wistil. Manchej jaach mak'wi cam ánima. Manchej jaach elk'anwi. Manchej ja na' a k'ane yin ja wet animail. Manchej ja wet k'anene ja wet animail. Ey ojab yel oc apnoj ja mam c'al ja txutx yul ja sat,” ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Mamin, chi xa jije masanil wan chejbanile tu' yet jix jin tit oc yin uninal, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Catu' jix oc t'anan naj yin jun be'om tu', catu' jix cam sc'ul naj yin, catu' jix yalon tet jaxca ti': —Jun to ja tz'ajloi. Asi', txon can el masanil tzet yetal ey e ach, catu' cha po'ontoj stool tu' tet eb meba', catu' oj ja cha'on ja be'omal bey satcan. Chi lawi tu' xin, chach jul pax jin c'atan junel xa an, catu' chach ec' c'al cuywoj wintaj an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ja' yet jix yaben jun be'om jaxca tu', jix cus a sc'ul naj sic'lebil. Cusiltaj xa c'al sc'ul yet jix pax toj, yutol miman tzet ey tet. ");
INSERT INTO knjNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jix c'al pax toj xin, catu' jix meltzotej t'anan Jesús yin eb scuywom tu'. Jix c'oli yalon jaxca ti': —Ja' eb be'om ti', caw ya'taj yoc Dios Yaawil oj eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jix q'uey a sc'ul eb cuywom tu' yet jix yaben eb jaxca tu'. Catu' jix yalon naj junel xa tet eb jaxca ti': —Jex jin cuywom an, ja' eb chi yaoc sbe'omal yip oj sc'ul, ta oj oc Dios Yaawil oj eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","K'inaloj junoj no' camello tinani', ¿tumi ta chi ec' el no' yul yixal junoj acuẍa? Quey tu' eb be'om tu', ta oj oc eb bey oj yak' Dios Yaawil, caw ya'taj yoctoj eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ja' yet jix yaben eb jun tu', tol jix q'uey a sc'ul eb sic'lebil. Catu' jix yalon eb xol tu': —Ta quey tu' jaxca tu', ¿mac wal txequel oj ske' scolchai? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Catu' jix oc t'anan Jesús yin eb, catu' jix yalon jaxca ti': —Ja' jun ti', c'am junoj ánima chi ske' yu. Pero ja' Dios chi ske' yu, yutol masanil tzet yetal chi c'al ske' yu, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Catu' jix yalon Pedro tu' tet naj: —Wuẍtaj, jaonti', jix cu bej can masanil cu tzettaj yetal, catu' jix cu ec' c'al cuywoj ja wintaj, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Caw yel chi wal e ex an, yal c'al mac chi sbej can sna wu c'al an, ma yuẍtaj, ma yanab, ma smam xutx, ma yuninal, ma xin, x'otx' chi sbej can wu c'al an, c'al yu jun sk'aneal yet colbanile, ja' ton jun evangelio ti', caw miman xa oj yute ẍa'on spaj yet jun tiempoal ti' yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Oj ẍa' cien oj sq'uexel sna tu', yuẍtaj, c'al yanab, smam c'al xutx, yuninal, c'al x'otx' tu'. Oj yab ton sya'il eb yu eb ánima, pero ja' yet jun tiempoal oj jul yet ya to tu', oj ẍa' sk'inal eb tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ey eb miman yel oc apnoj cu xol tinani'. Pero ja' yet chi wal tu' an, ec'al eb c'am xa nioj yel oc apnoj. Ey pax eb xin, c'am nioj yel oc apnoj cu xol tinani'. Pero ja' yet tu', ey eb caw miman xa oj yun yel oc apnoj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Babel sto Jesús sattaj eb scuywom yet lalan yatoj eb yul jun be chi a apnoj bey Jerusalén. Ja' eb scuywom tu', tu' c'al chi q'uey a sc'ul eb. Jal wan xa ánima yaman yetoj eb xin, caw chi xiw eb. Catu' jix awtele eltej eb scuywom tu' slacawanil yu naj xol eb ánima tu'. Jix c'oli yalontej tet eb masanil tzet oj jul yiban. ");
INSERT INTO knjNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Ilala, lalan ka wej toj bey Jerusalén ti'. Jainti', cax c'al Ak'bil Wopiso xol eb ket animail yu Dios ti', pero oj jin ale oc yul sk'ab eb yaawil yak'omal xaambal tet Dios, c'al yul sk'ab eb cuywam yin sley Moisés. Catu' chi yak'on elol camich eb wiban an, catu' oj jin yaon oc yul sk'ab eb man Israel oj. ");
INSERT INTO knjNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Oj buchwa eb win. Oj jin smak' eb. Oj tz'ubloj oc eb win an. Catu' oj jin yak'on cam eb. Pero ja' yet yox c'ual tu', oj jin pitzc'u a oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jix apni eb sc'aal naj Zebedeo tu' sc'atan Jesús, ja' ton Jacobo yetoj Juan, catu' jix yalon eb tet naj jaxca ti': —Wuẍtaj, ja' tzet oj cu k'an e ach, chi koche cha wak' e on, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Tzet chi yoche je c'ul chi wak' e ex? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Ja' yet oj jaach oc Yaawil oj, chi oj wal jon ja cha' ey chotan jon ja c'atan, junoj jon bey ja watx' k'ab, junoj jon bey ja q'uexan k'ab, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Jaexti', c'am chi na'cha el je yu tzet che k'an e in an. ¿Oj mi techa je yu je yak'le porobal jaxca oj jin utele an? Ja' tzet oj jul wiban jaxca tol chin ak'le bautizar yu. ¿Tumi ta oj techa je yu? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Oj techa oj, ẍi eb. —Yel toni, oj jex ak'le porobal jaxca oj yun wak'le porobal. Jaxca sya'ilal oj ec' el wiban an, quey tu' oj ec' el je yiban. ");
INSERT INTO knjNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero jainti', c'am walon wet jex jin chotban ey bey jin watx' k'ab ma bey jin q'uexan k'ab. Yutol watx' xa ye yu cu Mam Dios yu mac eb oj ey chotan titu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ja' yet jix yaben laonwan xa eb scuywom jun k'ane tu', jix tit sjowal eb yin Jacobo c'al yin Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Catu' jix awteletej eb slacawanil yu Jesús tu' sc'atan. Jix yalon tet eb jaxca ti': —Tol je yotaj xa, ja' eb ey oc yaawil bey jun jun mimej conob, yel c'ulal yak'on mandar eb. Quey pax tu' eb mimej winaj xol conob, yaaw xa c'al chi yute sba eb yiban ánima. ");
INSERT INTO knjNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero je xol jaexti', man jaxca oj tu' oj yune'. Ta ey mac chi yoche caw miman yopiso je xol, sowalil chi oc yak'omal oj servil eb yet cuywomal, catu' miman ton yopiso. ");
INSERT INTO knjNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yetoj pax oj, ta ey mac je xol chi yoche tol miman yel oc apnoj, sowalil chi oc mosoal tet eb yet cuywomal. ");
INSERT INTO knjNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yutol jainti', cax c'al Ak'bil Wopiso xol eb ket animail yu Dios ti', man yu oj wak'le servil yuxan jix jin jul an, pero yu wak'wi servil. Jix jin jul yu wak'on cam jin ba an, yet watx' ec'al mac txequel chi colcha can el wu an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jix apni Jesús bey conob Jericó yetoj eb scuywom. Ja' yet jix el eb titu', catu' jix to eb, caw ec'al ánima jix to yetoj eb. Ja' sti' be tu', ey jun winaj chotan ey oj, Bartimeo sbi, sc'aal naj Timeo. Ja' jun winaj tu', c'am chi ske' yilwi, yuxan chi sk'anwi limosna tet ánima. ");
INSERT INTO knjNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ja' jix yabeni, tol ja' Jesús a Nazaret chi juli, jix a yaw yin ipal jix yalon jaxca ti': —Jesús, jaach yic'aal naj David, ¿c'am mi chi ok' ja c'ul win an? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ec'al mac jix tenchanen naj Bartimeo tu', yet watx' chi tz'ini naj. Pero tol jix a can yel yaw naj: —Jaach yic'aal David, c'am mi chi ok' ja c'ul win an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Catu' jix oc tucan Jesús tu', jix yaloni: —Awte wej tej naj e in an, ẍi naj tet eb tzajan oc yintaj. Catu' jix awteletej naj tu': —Tzalaan. Aan waan oj. Sebach, ẍi Jesús, ẍi eb tet. ");
INSERT INTO knjNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jix sk'oj can el spichil ey oc yin naj tu', jix a jucna oj, catu' jix to yin eymanil sc'atan Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jix sk'anlen el Jesús tet jaxca ti': —¿Tzet chi yoche ja c'ul? ẍi Jesús tet naj. —Mamin, chi woche cha wa'ne can jin sat ti' an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Oj jin wa'ne ja sat ti' an, yutol jix ja waoc ja c'ul yin Dios. Chi xa ske' ja paxi, ẍi Jesús tet naj. Yet xa c'al jun txolan tu', jix wa'xi sat naj tu' yu naj. Catu' jix tzajlo naj yintaj Jesús tu' bey lalan stoi. ");
INSERT INTO knjNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ja' yet lalan xa yapni Jesús yetoj eb scuywom scawilal conob Jerusalén, ja' bey conob Betfagé yetoj Betania, bey yich wonan Olivo, jix ẍej baboj cawan eb scuywom Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jix yalon tet eb jaxca ti': —Baban nej toj bey jun aldea cu sattajtoj ti'. Ja' yet oj jex apnoj oc oj, ey jun no' ach'e burro txuan oj ilcha je yu. C'am to junoj mac chi a junel oj yiban no'. Che ti el no' catu' che yi'ontej. ");
INSERT INTO knjNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ta ey mac chi alon jaxca ti' e ex: “¿Tzet yuxan che ti el no?” ta ẍi, quey ti' che yute je yaloni, “Tol oj oc yopiso no' yu naj Kaawil. Eyman oj jul kak' can no',” je chi, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Catu' jix babi eb, jix ilcha no' ach'e burro tu' yu eb. Txuan oc no' sti' jun na yul be. Catu' jix stion el eb. ");
INSERT INTO knjNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ey mac ey ec' titu', jix sk'anlen el eb tet eb scuywom tu' jaxca ti': —¿Tzet che yune'? ¿Tzet yuxan che ti el no' burro ti'? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Catu' jix yalon eb jaxca jix yun scuyle eb yu Jesús tu'. Catu' jix bejletej no' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Catu' jix yi'ontej no' eb bey naj tu'. Jix yaon atoj spichil eb sk'an oj yichin no', catu' jix atoj Jesús yiban no'. ");
INSERT INTO knjNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ja' yet lalan sbeyi, caw ec'al ánima chi slitx'ban ey spichil sattaj naj yul be tu'. Ey mac xin, sk'ablaj te' chi bet soc' el oj, catu' chi yaon ey yul be tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ja' eb babel sattaj c'al eb tzajan oc yintaj, chi a yaw eb yu tzala c'ulal yin ipal, chi yalon eb jaxca ti': —Yu wal dios. Kal wej watx' k'ane yin jun chejbiltej yu naj Kaawil ti': ");
INSERT INTO knjNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kal wej watx' k'ane yin naj oj oc cu yaawil oj ti', jaxca jix yun yoc naj kichmam David yaawil peyxa. Kal wej yu diosal tet Dios, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ja' yet jix apni Jesús yul conob Jerusalén, jix octoj yul stemplo Dios. Jix ec' t'anan oj yin masanil tzettaj yetal ey yul tu'. Pero yel c'ulal xa c'al yey c'u, yuxan jix to naj bey conob Betania yetoj eb scuywom slacawanil. ");
INSERT INTO knjNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ja' yet jix k'inibi a yet jun xa c'ual yet speto eb bey Betania, jix tit swail Jesús yul-laj be, ");
INSERT INTO knjNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","catu' jix yilontoj naat, ey jun te' higo, ey xaj te'. Jix to yiloni. Caw c'am c'al junoj sat te' ey atoj. Asan c'al xaj te' ey, yutol man stiempoal oj yak'on sat te'. ");
INSERT INTO knjNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yu jun tu', yuxan jix yal naj tet te' higo tu' jaxca ti': —C'am xa mac txequel oj lo'on ja sat, ẍi Jesús tet te'. Jix yab eb scuywom yalon jaxca tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Catu' jix apni eb bey Jerusalén. Catu' jix octoj Jesús yul stemplo Dios tu'. Jix c'oli yujten eltej jantaj eb chi txonwi yul tu', c'al eb chi manwi. Jix stenon a pac'laboj smeẍa eb q'uexom tumin, c'al ẍila eb txonom uch. ");
INSERT INTO knjNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma xa ẍa' ec' junoj mac txequel yetoj tzettaj yetal yul templo tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Catu' jix c'oli scuywa snan xol eb tu' jaxca ti': —Yalnaj can Dios jaxca ti' yul An Juun Tz'ibebil can oj. “Ja' jin na, snail txa oj yun can yu masanil conoblaj,” ẍi. Pero jaexti', jaxca xa c'al junoj na ch'en bey chi sc'uba el sba eb elk'om quey tu' che yute, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ja' wan tzet jix yun Jesús ti', jix yab eb yaawil yak'omal xaambal eb Israel tet Dios, c'al eb cuywam yin sley Moisés. Jix xiw a eb yu, yutol miman yel oc apnoj wan cuybanil jix yak' yul sat ánima masanil. Yuxan jix sey eb tzet utbil chi yute yak'on cam naj eb. ");
INSERT INTO knjNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pero ja' yet jix k'ejbi can ey oj, jix el yul conob tu' yetoj eb scuywom. ");
INSERT INTO knjNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ja' yet ec' eb yet yewial yet sk'inibalil scawilal te' higo tu' xin, jix yil eb tol jix taj el te' yetoj c'al xe': ");
INSERT INTO knjNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Catu' jix sna'ontej Pedro tu', catu' jix yalon tet Jesús jaxca ti': —Wuẍtaj, ila te' higo jix ja tzu can el yet ewi. Jix taj el te', ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Catu' jix yalon Jesús tu' jaxca ti': —A wej oc je c'ul yin Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","K'inaloj ey junoj jex che yal tet jun wonan ti' jaxca ti': “Elan quey ti'. K'oj eytoj ja ba yul ja' mar,” ta je chi. Ta c'am che yak' caab c'ulal, ta che yaoc yin je c'ul tol oj yun jaxca che yal tu', caw yel oj yune'. ");
INSERT INTO knjNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yuxan chi wal e ex an, ja' yet chex txali, che yaoc yin je c'ul, tol oj je cha' tzet che k'an tu'. Ta che yaoc yin je c'ul, oj ak'le e ex. ");
INSERT INTO knjNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ta ey mac chi oc smul e ex, ja' yet chex txali, jo' wej q'uey spenail tu' yin je c'ul. Ta quey tu' che yute, oj jo'le pax q'uey je penail yu cu Mam Dios a satcan. ");
INSERT INTO knjNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ta c'am che jo' q'uey xin, man pax oj jo'le q'uey je yet yu cu Mam Dios tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Catu' jix apni pax eb bey Jerusalén junel xa, catu' jix octoj Jesús yul stemplo Dios, jix c'oli yec'ab c'al yul. Catu' jix oc pax toj eb yaawil yak'omal xaambal eb Israel tet Dios, yetoj eb cuywam yin sley Moisés c'al eb ichamtaj winaj. ");
INSERT INTO knjNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Catu' jix sk'anlen eb tet Jesús jaxca ti': —¿Tzet ja wopiso, yu jun tu', yuxan jix ja wun wan ti' ewi? ¿Mac txequel jix ak'on ja wopiso tu'? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Catu' jix yalon Jesús tet eb jaxca ti': —Ey pax jun tzet yetal oj jin k'anle el e ex an. Ta oj je pajtze e in an, catu' oj walon e ex mac jix ak'on wopiso wunen wan ti' an. ");
INSERT INTO knjNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Mac jix ak'on yopiso naj Juan, yuxan jix ak'wi bautizar ánima? ¿Dios mi, ma ánima? Al wej e in an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Catu' jix c'oli yalon eb xol tu', catu' jix yalon eb jaxca ti': —¿Tzet wal chi kute kalon tet? Ta chi kal tol ja' Dios jix ak'on yopiso naj, ja' xam yalon e on: “¿Tzet yuxan ma je ya pax oc yin je c'ul xin?” ẍi mi. ");
INSERT INTO knjNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero ma pax ske' kaloni, tol ánima jix ak'on yopiso naj, ẍi eb. Quey tu' chi yute yalon eb, yutol chi xiw eb tet eb ánima, yutol ja' naj Juan tu', caw ẍejab Dios ye naj yul sat eb ánima masanil. ");
INSERT INTO knjNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yuxan jix yal eb tet Jesús jaxca ti': —Man kotaj oj mac jix ak'on yopiso naj Juan tu', ẍi eb. —Ta quey tu' xin, man oj wal pax e ex mac jix ak'on wopiso wunen wan ti' an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Catu' jix yalontej Jesús tu' jun sk'aneal yet tx'oxbanile ti', jix yal jaxca ti': —Ey jun winaj jix yaw wan uva sat jun x'otx'. Jix yaoc colal yin. Jix swa'nen jun jolan bey oj stec' el yal uva tu'. Jix tz'ajon pax a jun ilbal uva xol tu'. Jix lawi tu' xin, jix yaon can toj x'otx' tu' maanil yetoj c'al yawoal tet wan mulnawom winaj. Jix to ec'ab bey jun xa lugar naat tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ja' yet jix a apnoj stiempoal syambale el an uva tu' xin, jix ẍejontoj jun ẍejab bey eb mulnawom tu', yu sto ẍa'on naj jantaj yet naj t'inan yi'oni. ");
INSERT INTO knjNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Jix apni naj xin, jix tzac'ontej eb, jix smak'on naj eb. Xew c'al tu', catu' jix ẍejon pax eb, c'am nioj tzet jix yi' naj. ");
INSERT INTO knjNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Catu' jix ẍejontoj jun xa ẍejab naj a tx'otx' tu' tet eb junel xa. Pero jix k'ojch'ennele jun xa naj tu' yu eb yet jix apni. Jix jolcha sjolom naj yu eb. Caw pena jix yute sba eb yin. ");
INSERT INTO knjNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jix to chejletoj jun xa yu naj. Ja' jun xa tu' xin, jix cam xa c'al yu eb. Ec'al to c'al wan xa eb jix chejtoj, ey eb tu' c'al jix yasi smak'lei, ey eb xin, jix cam xa c'al yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ey jun q'uetxan sc'aal naj a tx'otx' tu', miman chi cam el sc'ul naj yin. Jix ẍej pax toj naj yin xa c'al tzunanil. “Oj xiw eb tet jin c'aal ti',” ẍi naj yul sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero ja' yet lalan yapni naj, jix swa'alne eb maanenen tx'otx' tu' jaxca ti': “Ja' jun c'aale, tol chi juli, pero ja' yet oj cam smam naj, ja' oj i'on can x'otx' ti' sattaj oj. Cu mak' wej cam oj, jaon xa oj ki' can tx'otx' ti',” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yuxan jix c'al apni naj, catu' jix mitx'le naj yu eb, jix mak'le cam oj, catu' jix k'ojle smimanil sti' el jun tx'otx' tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Chin k'anle e ex xin, ¿tzet oj utele eb maanenen tx'otx' tu' yu naj a tx'otx' tu' che na'? Oj yak' cam eb naj yet oj jul oj. Catu' oj yaon can toj x'otx' tu' maanil tet wanoj xa mac txequel. ");
INSERT INTO knjNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Tumi c'am to bey che yil yul An Juun Tz'ibebil can oj bey chi yal jaxca ti': Ey jun ch'en jix yintajne el eb wa'nem na. Ja' ton jun tu' yel jix oc yopiso. ");
INSERT INTO knjNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ja' naj Kaawil jix uten jun tu', yu jun tu', yuxan ja' yet chi kiloni, caw chi q'uey a cu c'ul yu, ẍi yul An Juun Tz'ibebil can tu'? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Catu' jix yak'le eb smitx'on Jesús, yutol jix na'cha el yu eb, tol ja' eb chi al-le yu jun k'aneal tu'. Pero chi xiw eb tet ánima, yuxan ma mitx'le Jesús yu eb tu'. Catu' jix paxtoj eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jix lawi jun tu' xin, catu' jix chejletej jaywan eb fariseo yetoj eb spartido Herodes sc'atan Jesús yu yak'len yijban naj eb yin spenail yu junoj tzet yetal chi yala, catu' chi yak'on queja eb, yaloni. ");
INSERT INTO knjNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jix c'al apni eb xin, jix yalon eb tet naj jaxca ti': —Jaach cuywam, kotaj tol yel tzet cha wala. Kotaj pax oj, tol jun laan c'al cha wute ja c'ul yin masanil ánima, yutol laan c'al yel oc apnoj eb yul ja sat. Catu' chach cuywa yin yel yin jun beybale chi ẍa' sc'ul Dios. ¿Tzet ja chi jaachti'? Ja' ch'en tumin chi k'anle el e on yu naj yaaw bey Roma, ¿ey mi sleyal chi kak'a, ma c'amaj? ¿Watx' mi chi kak' ch'en, ma c'amaj cha na'? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero yotaj xa Jesús, tol caab satil chi yun eb, yuxan jix yal tet eb jaxca ti': —¿Tzet yuxan che yak'le jin je yijban yin spenail? Asi', i' wej tej junoj ch'en tumin tu' wil an, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Catu' jix bet yi'on jun tumin tu' eb, catu' jix sk'anlen Jesús tet eb jaxca ti': —¿Mac txequel jun ey oc yechel sat yin jun tumin ti'? ¿Mac txequel jun ey oc sbi yin ch'en ti'? ẍi naj tet eb. —Yechel sat naj yaaw bey Roma yetoj c'al sbi naj, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Ak' wej tzet yetal yet c'al ta' naj yaaw tu' tet xin. Catu' ja' tzet yetal yet c'al ta' Dios, ak' wej pax tet, ẍi Jesús tet eb. Ja' yet jix yaben wan tu' eb, tu' c'al jix q'uey a sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ja' junel ey wan eb saduceo jix apni sc'atan Jesús. Eb chi aloni, tol c'am chi pitzc'u a eb camnaj. Jix yalon eb tet naj jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Jaach cuywam, ja' Moisés jix tz'iben can jaxca ti': “K'inaloj ey junoj mac chi cami, catu' chi can yistil, pero c'am junoj yuninal jix el can oj. Ja' junoj uẍtajeal sowalil chi i'on ix, yet watx' ta chi el yuninal jun xa tu', jaxca tol yuninal naj jix cam tu' chi yun can oc oj.” Quey tu' jix yute yalon can Moisés. ");
INSERT INTO knjNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ja' junel, ey jujwan winaj yuẍtaj c'al sba. Jix oc yistil naj babel winaj. Pero jix camtoj naj, c'am c'al yuninal naj jix el can oj. ");
INSERT INTO knjNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ja' jun xa naj uẍtajeal jix i'on can ix. Jix cam pax toj jun xa naj tu', ja'c'ala', c'am yuninal jix el pax can oj. Ja'c'ala' jix yun naj yet yox uẍtajeal. ");
INSERT INTO knjNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sjujwanil eb naj, jix yi'le c'al ix eb naj. C'am c'al eb jix el can junoj yuninal. Jix lawi scamtoj eb naj sjujwanil xin, catu' jix cam pax ix. ");
INSERT INTO knjNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ja' yet oj pitzc'u a eb camnaj tu' xin, ¿mac wal junoj yel ey yalon yet yin jun ix tu'? Yutol jix c'al yi'le ix eb naj sjujwanil, ẍi eb saduceo tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Catu' jix yalon Jesús tet eb jaxca ti': —Caw che yak' q'ueytoj je ba, yutol man je yotaj oj tzet chi yal yul An Juun Tz'ibebil can oj. Man je yotaj oj pax jantaj yipal Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ja' yet oj pitzc'u a eb camnaj tu', toj oj to yi'le sba eb ánima. Yutol jaxca xa eb ángel bey satcan oj yun can el eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero c'am chi na'cha el je yu ta oj pitzc'u a eb camnaj. ¿Tumi c'am bey che yil tzet tz'ibebil can yu Moisés yul An Juun Tz'ibebil can xin, yu tzet jix yal Dios tet yet jix k'anab eltej xol k'ak' k'ak' yin te' q'uix? Jix yal Dios jaxca ti': “Jain ton ti' Sdiosal jin Abraham, Sdiosal jin Isaac, Sdiosal jin Jacob,” ẍi yul An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yu jun tu', yuxan cax c'al camnaj xa eb, kotaj tol man junelne oj jix q'uey el eb, yutol kotaj, tol ja' Dios, man Sdiosal oj eb camnaj, pero Sdiosal eb iquis. Yu jun tu' xin, caw che yak' q'ueytoj je ba, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ey pax jun cuywam yin sley Moisés jix apni sc'atan naj, jix yab steelen sba eb saduceo tu' yetoj Jesús. Jix yabe, tol watx' jix yute spajtzen sk'anlebal eb Jesús, yuxan jix yak' pax jun sk'anlebal tet naj jaxca ti': —¿Beytet junoj chejbanile yel miman yel oc apnoj yintaj masanil? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Catu' jix yalon Jesús tu' jaxca ti': —Ja' ton jun chejbanile tol ec'ban yintaj masanil ti', chi yal jaxca ti': “Ab wej xin jex Israel, ja' naj Kaawil cu Diosal, junne ton naj. ");
INSERT INTO knjNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cam c'ulne wej naj Kaawil cu Diosal yin masanil je c'ul, c'al yin masanil je pixan, c'al yin masanil je na'bal, c'al yin masanil je yip,” ẍi. Ja' ton jun chejbanile ti', ec'ban yel oc apnoj yintaj masanil. ");
INSERT INTO knjNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ja'c'ala' jun xa oj wal ti', txen xa man laan oj yetoj jun babel tu', chi yal jaxca ti': “Cam c'ulne wej je yet animail jaxca che yute je cam c'ulnen je ba jun jun jex,” ẍi. C'am junoj xa chejbanile yel miman yel oc apnoj yintaj caab ti', ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Catu' jix yalon naj cuywam yin ley tu' tet naj jaxca ti': —Watx' ton Mamin, yel ton cha wala. Junne cu Dios, c'am junoj xa. ");
INSERT INTO knjNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Sowalil ton chi cu cam c'ulne Dios yin masanil cu c'ul, yin masanil cu na'bal, yin masanil cu pixan, c'al yin masanil kip. Yetoj pax oj, sowalil ton chi cu cam c'ulne eb ket animail jaxca chi kute cu cam c'ulnen cu ba jun jun jon ti'. Ja' caab ti', ec'ban yel oc apnoj yintaj masanil xaambal, ec'ban yel oc apnoj yintaj sa'beal chi tz'a' sattaj Dios, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ja' yet jix yaben Jesús tol watx' jix yute tak'woj sba naj tet, jix yalon tet naj jaxca ti': —Nianxane oj oc Dios ja Waawil oj, ẍi Jesús tet naj. Jix lawi tu' xin, c'am junoj xa mac jix stec'ba sba sk'anlen junoj xa tzet yetal tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ja' yet jix cuywa Jesús yul stemplo Dios junel, jix yal naj jaxca ti': —¿Tzet yuxan chi yal eb cuywam yin sley Moisés jaxca ti': “Ja' Cristo yic'aal David c'al?” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yutol ja' naj David tu', ak'bil yal yu Santo Espíritu junel jaxca ti': Jix yal Dios Kaawil tet naj Waawil jaxca ti': “Eyan chotan bey jin watx' k'ab masanta' c'al oj can eb chi chichon oc sc'ul ja win ja walan wu an,” ẍi Dios tet naj Waawil, ẍi David. ");
INSERT INTO knjNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Quey tu' jix yute yalon David tu', tzet utbil tol ja' Cristo, Yaawil yei. Yu jun tu', man asanne oj tol yic'aal David yei, ẍi Jesús tet eb. Ec'al ánima jix aben jun k'ane ti'. Jix tzala xa c'al a eb yabeni. ");
INSERT INTO knjNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ja' yet lalan scuywa Jesús xol ánima tu', jix yal tet eb jaxca ti': —Che yil c'al je ba, yutol ja' eb cuywam yin sley Moisés, caw ey smey sbeybal eb. Chi ẍa' sc'ul eb yec' tok'ok'oj yetoj jojan spichil chi yaoc oj. Ja' yet chi yi'on ey sba ánima tet eb yul-laj calle, watx' xa c'al chi yab eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ja' bey snail syambabail eb yin culto, asan bey chi ey chotan eb mimej winaj chi yoche eb chi ey chotan oj. Yetoj yet chi oc mimej lo', asan bey chi ey eb mimej winaj chi ey eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Chi yi'on ec' sna eb ix camnaj xa yichamil eb. Chi lawi jun tu', naat chi yute yajan xa, yet watx' c'am chi txeclo el sattaj ánima ta ey spenail eb. Yu jun tu', yel miman castigo oj ẍa' eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Chotan ey Jesús yul templo junel, bey scawilal cha'bal ofrenda. Jix yilon c'al yaon eytoj yofrenda ánima. Ec'al eb be'om jix ya eytoj yet, mimantaj chi yute yaon eytoj eb. ");
INSERT INTO knjNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Lalan to c'al wal tu', jix apni jun ix ix camnaj xa yichamil, meba' ch'an ix. Jix yaon eytoj caab centavo yet ix, caw nian ch'an yet ix tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Catu' jix yawtentej eb scuywom Jesús tu', jix yalon tet eb jaxca ti': —Caw yel chi wal e ex an, ja' jun ix meba' ix camnaj xa yichamil ti', ec'ban yofrenda ix jix ec' ya eytoj yintaj c'al masanil eb jix ec' ya eytoj yet yul cha'bal ofrenda ti'. ");
INSERT INTO knjNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yutol jun jun c'al mac txequel, sobra xa c'al stumin eb jix ec' ya eytoj. Jal jun ix ti' xin, caw meba' ton ix, pero tz'ajan jix ya eytoj stumin ix yin ofrendail, ẍi Jesús tet eb. Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ja' yet lalan yeltej Jesús yul stemplo Dios, jix yalon jun scuywom tet naj jaxca ti': —Wuẍtaj, ila jun jun wan ch'en ti'. Yetoj wan na ti', caw mimej eb, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Catu' jix yalon Jesús tet jaxca ti': —Ja' wan mimej na cha wil ti', chi wal e ach an, ja' wan ch'en latz'bil a ti', c'am xa junoj oj can can yiban yet ch'enal. Pilan oj ec' bulna oj, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jix lawi tu' xin, catu' jix to eb bey jun wonan Olivo, ja' spaq'uil tu', ja' tu' ey stemplo Dios. Jix ey chotan Jesús bey wonan tu' xin, catu' ja' naj Pedro yetoj Jacobo, Juan c'al Andrés, jix sk'anle el eb tet naj yet ey ec' eb xojli yetoj, jix yal eb tet naj jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Chi koche cha wal e on, ¿bak'in oj jul jun jix ja wal e on tu'? ¿Tzet echele oj x'ox Dios, yet tuxa oj yun wan tu'? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Catu' jix yalon Jesús tet eb tu' jaxca ti': —Listo c'al che yute je ba, yet watx' c'am junoj mac txequel oj i'on eytej je sat. ");
INSERT INTO knjNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yutol ec'al mac oj sbon oc sba yin jin bi, “Jain ton Cristo jin an,” ẍi eb oj tz'aj yalon eb. Ec'al ánima oj yi' eytej sat eb. ");
INSERT INTO knjNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Oj je yab yoc mimej jowal. Oj je yaben sk'umal wan xa ian chi oqui. Man to slawub oj yul yiban k'inal tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yutol ey wan mimej conob oj yak'le jowal yetoj yet mimej conobal. Oj yak'le a jowal eb yaaw yetoj yet yaawil. Caw ey bey oj ec' quixcab. Oj jul mimej wail yiban ánima. Oj a somna eb. Ja' wan tu', yichbanil sya'tajilal jix to c'al yei. Ey wan xa oj jul oj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Jaexti' xin, tec'an c'al che yute je ba, yutol oj jex ale oc yul sk'ab eb yaaw. Oj jex smak' eb yul snail bey chi syamba sba eb yin culto. Oj jex yi'toj eb sattaj eb yaaw, c'al sattaj eb rey, yutol jix je yaoc je c'ul win an. Quey tu' oj yun sjul je yiban xin, yet watx' oj ske' je yalon can el jin k'aneal tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Sowalil babel oj alcha can el sk'aneal yet colbanile bey jun jun conob, catu' oj jul slawub c'ual tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ja' yet oj jex i'letoj sattaj eb yaaw tu', manchej je na' yin ey oj to yu tzet oj je yala. C'am pax chex oc il yu. Ja' tzet oj ak'le je yal yu Dios yet jun txolan tu', ja' che yala. Yutol manaj jex oj jex k'anab oj, pero ja' Santo Espíritu oj k'anab oj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ey eb uẍtajeal, oj yaoc yuẍtaj yul sk'ab camich. Ey pax eb mame quey tu' oj yute sba yin sc'aal. Ey eb c'aale oj yak'le jowal yetoj smam, catu' oj yak'on cam eb. ");
INSERT INTO knjNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Masanil xa c'al ánima oj chichon oc sc'ul je yin, yutol jix je yaoc je c'ul win an. Pero ja' mac tec'an c'al ye masanta' c'al chi cami, ja' ton eb tu' oj colcha oj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pero ja' jun ya'bil el yu Dios, ja' oj etnen el wan tzet yetal. Ja' Daniel, jun ẍejab Dios peyxa, ja' jix alon can yu jun tu'. Ja' mac chi ilon a jun k'ane ti', na'cha ojab el yu. Ja' yet oj je yiloni, tol ey ec' jun tu' bey caw man smoo oj ye ec' oj, toj ojab eb ey ec' bey Judea bey wonanlaj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ja' mac ey atoj yiban ẍumuc spananil sna yet jun c'ual tu', manchej xa eytej, catu' manchej xa octoj yul sna tu' yu yi'on eltej nioj xa settaj yetal catu' chi to el oj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yetoj eb ey ec' xol smulnail, manchej xa ojab meltzo yintaj sto yi'on spichil. ");
INSERT INTO knjNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ja' yet jun tiempoal tu', ok'bal c'ule eb ix mimejal xa, yetoj eb ey to yune' chi yak' txutxwoj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","K'an wej tet Dios, tol man ojab nabil k'inal oj yet oj jex el tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yutol ja' jaxca jun miman sya'ilal oj jul yet jun tiempoal tu', c'am to bey jix jul junel oj yechel tax c'al swa'xi yul yiban k'inal ti' yu Dios. Asan ch'an junel tu', c'am xa bak'in oj yun junel xa jaxca tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ta c'am chi smitx' oc tucan jun sya'ilal tu' Dios yet jun tiempoal tu', c'am junoj mac oj colcha can el yul sk'ab camich. Pero yu scam c'ulal yin eb sic'bil xa el yu, yuxan oj smitx' oc tucan oj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ta ey mac oj alon e ex jaxca ti': “Asi' toon ab wej, ila, tol ja' naj Cristo ey ec' titi',” ma “Il wej toon abi, tol ey ec' titu',” ta ẍi jex utelei, manchej je cha' je yabe. ");
INSERT INTO knjNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yutol ey wan eb oj tz'aj yal oc sba Cristoal oj x'ox a sba, c'al wan eb oj yal oc sba ẍejab oj Dios. Oj tz'aj x'ox eb echele, c'al milagro. Quey tu' oj yun yi'le eytej sat eb ánima yu eb. Oj yak'le pax eb yi'on eytej sat eb sic'bil xa el yu Dios ta chi ske' yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero jaexti', tec'an c'al che yute je ba. Ey oj to chi walon can masanil wan ti' e ex an. ");
INSERT INTO knjNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ja' yet jun tiempoal tu', yet tuxa oj lawoj jun miman sya'ilal tu', oj k'ej jolel c'u, catu' oj tan yajan xaaw. ");
INSERT INTO knjNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Catu' oj tit q'uey weycan satcan. Yetoj wan tzet yetal ey yipal bey satcan, oj tzicotan el ey oj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Oj lawoj tu' xin, catu' oj yilon eb ánima tu' weyol xol asun jain Ak'bil Wopiso xol eb ket animail yu Dios ti' an, oj jin jul yetoj masanil wipal c'al jin tzejejial. ");
INSERT INTO knjNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Oj jin chejtej eb wángel catu' oj ec' yambale a eb sic'bil el wu bey masanil yul yiban k'inal ti'. Oj ec' i'le a eb masanta' c'al bey chi lawi yul yiban k'inal ti', c'al eb bey chi lawi apnoj satcan, oj ec' yambaletej eb. ");
INSERT INTO knjNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ab wej jun k'ane oj waltej yu te' higo. Ja' yet chi uninbi sk'ab te', yet lalan xa stit xaj te', je yotaj xa tol tuxa chi oc nabil k'inal. ");
INSERT INTO knjNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Quey ton tu' oj yun sna'cha el je yu, tol tuxa oj jin jul an. ");
INSERT INTO knjNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Caw yel chi wal e ex an, ey eb ey ec' yet jun tiempoal ti' c'am to c'al chi cami, catu' oj yunen masanil wan jix wal ti' an. ");
INSERT INTO knjNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ja' satcan c'al yul yiban k'inal ti' oj lawoj, pero ja jin k'ane man oj ec' tzet chi wal an. ");
INSERT INTO knjNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pero c'am mac otajnen tzet c'ual, c'al jantaj hora oj jin jul an. Eb ángel bey satcan, man yotaj oj eb. Jainti', tol pax Sc'aal jin Dios an, pero man wotaj oj pax oj. Asan Dios Mame yotaj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yu jun tu' caw listo che yute je ba, majwaan nej. Txalan nej, yutol man je yotaj oj bak'in oj jul stiempoal jun tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jaxca ton junoj winaj chi to ec'ab naat, chi can sna. Chi yalon can tet eb smoso tzet chi yun can jun jun eb. Catu' chi steyne puerta naj tu' sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pero eb mosoal tu' man yotaj oj eb bak'in chi jul naj a na tu' bey sna junel xa, ma tol k'ejbintajil, ma chuman ak'bal, ma yet lalan xa yok' no' caẍlan, ma ja' yet chi sajbi el xin. Man je yotaj oj bak'in oj jin jul pax yet scaelal. Yu jun tu', caw listo che yute je ba, ");
INSERT INTO knjNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","yet watx' man ojab jaxca oj tol weynaj jex el oj catu' oj jin jul tzac'na oj. ");
INSERT INTO knjNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ja' wan chi wal e ex ti' an, chi wal e ex je masanil. Caw listo c'al che yute je ba, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Cabe oj xa c'al yoc sk'in pascua eb Israel, yet chi slo'on ixim pan eb c'am yich, catu' jix syamba oc sba eb yaawil yak'omal xaambal eb Israel tu' tet Dios, yetoj eb cuywam yin sley Moisés. Jix c'oli slatinen eb tzet utbil chi yute smitx'on Jesús eb yin ewantajil, catu' chi yak'on cam naj eb yaloni. ");
INSERT INTO knjNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jix yal eb jaxca ti': —Ma ske' cu mitx'on yul k'in, yutol ey smey, oj tit sjowal eb ánima kin yu, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ey ec' Jesús bey Betania, bey sna naj Simón, naj ya' ey yet yalantoj yu jun ya'bil chi k'a'toj ánima yu, jun chi yij lepra. Chotan ey Jesús tu' slowi, catu' jix apni jun ix ix sc'atan. Yetbi oc ix jun ch'en alabastro limeta. Nonaj yu jun ambal suk'uk'i sab, caw miman stool, nardo sbi. Jix jul c'al ix, catu' jix swuk'on el snuk' ch'en ix, catu' jix stobon atoj ix yiban sjolom Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pero ey cawan eb ey ec' xol eb ey ec' titu' jix tit sjowal eb. Jix yalon eb jaxca ti': —¿Tzet yuxan tu' c'al chi etnele el jun ambal suk'uk'i sab ti'? ");
INSERT INTO knjNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tol oj wal jix txonle el oj, catu' jix po'le ec' stool xol eb meba', yutol ja' jun ti' ec'ban mi junoj oxeb cien quetzal stool, ẍi eb. Caw jix tit sjowal eb yin ix ix tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Catu' jix yalon Jesús tet eb jaxca ti': —Bej wej je yalon jun ti' jaxca tu', ¿tzet yuxan pena che yal yin ix? Ja' jun jix yun ix win ti' an, caw watx'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ja' eb meba' che yal tu', ey c'al ec' eb je yetoj. Ja' yet oj je yoche je yak' junoj tzet yetal tet eb, oj ske' je yak'oni. Pero jainti', man tobal k'inal oj ey jin ec' je yetoj. ");
INSERT INTO knjNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ja' masanil tzet chi ske' yu ix jix yak' e in an. Ey oj to chi yaon oc ix jun suk'uk'i sab ti' yin jin mimanil ti', yet watx' listo xa ye jin mimanil an, catu' chin to mujle oj. ");
INSERT INTO knjNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Caw yel chi wal e ex an, yal c'al tzet lugaril yul yiban k'inal ti' bey oj al-le el sk'aneal yet colbanile, oj al-le pax el sk'aneal jun tzet jix yun ix ix ti', yu sna'letej ix, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ja' naj Judas Iscariote, naj ey oc tz'ajil oj eb lacawan scuywom Jesús, ja' jix bet ec' k'anab yetoj eb yaawil yak'omal xaambal eb Israel tet Dios, yu bet slatinen yaon oc Jesús yul sk'ab eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ja' yet jix yaben eb, caw jix tzala a eb, yuxan jix yak' sti' eb, yaon oc tumin eb tet Judas tu'. Jix c'oli seyon tzet utbil oj yute yaon oc Jesús yul sk'ab eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ja' yet sbabel sc'ual jun k'in yet chi lo'le ixim pan c'am yich, yet chi ak'le cam no' me' yet pascua, jix yak' k'anlebal eb scuywom tu' tet Jesús: —¿Beytu' cha woche chi cu to cu wa'ne junoj lugar bey oj cu lowoj, yu cu na'ontej pascua ti'? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Catu' jix ẍejontoj cawan scuywom tu', jix yalon tet eb jaxca ti': —Asi' wej bey conob. Ey jun winaj oj je yil yin titu', i'bil oc jun moc ja' yu. Chex tzajlo c'al yintaj naj. ");
INSERT INTO knjNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ja' bey chi apni, che yal tet naj a na tu' jaxca ti': “Quey ti' jix yun yalon naj cu cuywomal ti' e on jon, ¿Beytu' ey jun cuarto bey oj jin low yetoj eb jin cuywom, yu cu na'ontej pascua ti'? ẍi,” je chi tet. ");
INSERT INTO knjNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Catu' oj x'oxon jun mimantaj cuarto e ex wa'nebil xa el oj. Naat ey a oj jun cuarto tu'. Ja' tu' che wa'ne tzet oj cu lo', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Catu' jix to eb cuywom tu', catu' jix apni eb yul conob. Jix ilcha yu eb jaxca c'al jix yute yalon Jesús tu' tet eb. Catu' jix swa'nen eb tzet oj slo' eb yu pascua tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jaxa yet sk'ejbintajil xin, catu' jix apni naj yetoj eb scuywom slacawanil. ");
INSERT INTO knjNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ja' yet lalan slow eb yin meẍa tu', catu' jix yalon Jesús tet eb jaxca ti': —Caw yel chi wal e ex an, ja' jun oj jin aon oc yul sk'ab camich, ey ec' cu xol ti', lalan slow ketoj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Catu' jix cus a eb yet jix yaben jun k'ane tu' eb. Yuxan jun junal jix yute sk'anlen el eb tet: —¿Man mi jain oj ti'? ẍi eb yin jun junal. ");
INSERT INTO knjNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Catu' jix yalon tet eb jaxca ti': —Ja' je xol je lacawanil ey oc oj. Lalan slow wetoj an, yul jun plato ey ey cu nan ti'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Jainti', Ak'bil Wopiso xol eb ket animail yu Dios ti', pero sowalil oj jin cam jaxca yal-le can yu An Juun Tz'ibebil can oj. Pero ok'bal c'ule jun oj jin aon oc yul sk'ab camich tu'. Yel xa c'al watx' yet, ta ma c'al ta' aloj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lalan slow eb, jix yi'on a ixim pan Jesús. Jix yalon yu diosal yu ixim. Jix lawi tu' jix spo'on ey oj, jix yak'on tet eb: —Lo' wej, ja' ton jin mimanil ti', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Catu' jix yi'on pax a jun vaso. Ja' yet jix lawi yalon yu diosal yu, catu' jix yaontoj tet eb. Masanil eb, jix uq'uen eltej tzet ey ey yul jun vaso tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ja' ton jun ti' jin chiq'uil. Ja' yu, yuxan oj yun jun ac' strato Dios. Oj el jin chiq'uil ti', yet watx' ec'al mac oj colcha yu. ");
INSERT INTO knjNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Caw yel chi wal e ex an, c'am xa bey oj wuc' yal uva, ja' to c'al yet oj oc Dios Yaawilal catu' oj wuq'uen je yetoj junel xa, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jix lawi sbit'nen jun bit' eb chi sbit'ne c'al ta' eb tet Dios, catu' jix to eb bey wonan Olivo tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jix yalon Jesús tet eb titu' jaxca ti': —Ja' yet jun ak'bal ti', oj caablaboj a je c'ul win je masanil an. Quey tu' yalon can yul An Juun Tz'ibebil can oj, chi yal jaxca ti': “Oj wak' cam naj ilom me'. Ja' no' me' tu', oj sajlem can toj no',” ẍi An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero ja' yet chin pitzc'u pax a oj, oj jin baboj toj je sattaj bey Galilea, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Catu' jix cam yalon naj Pedro tu' tet naj jaxca ti': —Cax c'al mi chi caablabi a sc'ul eb masanil ja win, pero jainti', ma c'al ta' caablabi a jin c'ul ja win an, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—Caw yel chi wal e ach an, ja' yet jun ak'bal ti', oxel xa jin ja wi'on el ja win catu' oj ok' no' caẍlan yet scaelal, yet oj ja waloni, tol ma jin ja wotaj oj, ẍi Jesús tet Pedro tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero Ja' naj Pedro tu' xin, jix stec'ba c'al sba yaloni, tol oj stec'ba sba: —Cax c'al oj jin cam ja wetoj an, pero tutun ma jaach wi' el win an, ẍi naj tet Jesús. Jun laan c'al yalon eb scuywom tu' masanil jaxca tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jix lawi tu' xin, catu' jix apni Jesús yetoj eb scuywom tu' bey jun lugar chi yij Getsemaní. Catu' jix yalon tet eb tu' jaxca ti': —Eyan nej can chotan titi', yajban chin to txaloj, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Asan Pedro yetoj Jacobo c'al Juan jix yi'toj yetoj. Catu' jix c'oli cus a sc'ul c'al yoc bis c'ulal. ");
INSERT INTO knjNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yuxan jix yal tet eb jaxca ti': —Ian chin cam yu cus c'ulal chi wab an. Canan nej titi', iquis ojab jex wetoj an, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Catu' jix sjitzontoj sba janic' xa sattajtoj catu' jix ey noan sat tx'otx', jix txali yu sk'anoni ta chi ske' c'am chi jul jun sya'ilal tu' yiban yet jun yorail tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jix yal yin xa jaxca ti': —Mamin, masanil c'al tzet yetal chi c'al ske' ja wu. Ta chi ske' tol c'am chi jul jun sya'ilal ti' wiban. Pero c'am ojab chi yun tzet chi woche, jainti' an, ja' ojab ja wochwan chi yune', ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jix lawi tu', catu' jix apni sc'atan eb oxwan tu', pero jix yiloni, tol lalan swey eb. Yuxan jix yal tet naj Pedro jaxca ti': —Simón, ¿tumi lalan ja weyi? ¿Tumi ma ske' ja tec'ban ja ba tet weyan junoj hora wetoj an? ");
INSERT INTO knjNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","I' wej el je weyan. Txalan nej, yet watx' c'am chex ey q'ueyi, yet ey mac chi yak'le jex yijban yin spenail. Ja' cu pixan tec'an ton yei, pero ja' cu mimanil c'am chi techa yu, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Catu' jix to txaloj junel xa. Jaxca c'al jix yute txaloj sba yet sbabelal, quey tu' jix bet yute txaloj sba junel xa. ");
INSERT INTO knjNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ja' yet jix jul junel xa, ja'c'ala' chi wey eb, yutol caw c'am chi techa weyan yu eb. Ma xa na'cha tzet jix yute tak'woj sba eb tet. ");
INSERT INTO knjNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ja' yet jix bet ec' txaloj yet yoxelal, jix yalon tet eb jaxca ti': —¿Tumi ja'c'ala' je weyi? ¿Tumi comon xewilal che yune'? K'ojbil xa, jix a apnoj yorail wale oc yul sk'ab eb penawom, jain Ak'bil Wopiso xol eb ket animail yu Dios ti'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Aan linan oj toon nej. Chi jul naj oj jin aon oc yul sk'ab eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Lalan to yalon tu', catu' jix apni Judas, naj jix ocle tz'ajil oj eb lacawan. Ec'al ánima jix apni yetoj. Ey eb i'bil yespada, ey eb i'bil ste'. Ja' eb yaawil yak'omal xaambal eb tet Dios, c'al eb cuywam yin sley Moisés, yetoj eb icham winaj ey yopiso, ja' eb jix chejon eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ja' Judas tu', ja' ton naj jix txonon Jesús, albil xa yu, tzet oj yute x'oxon oc oj, jix yal tet eb jaxca ti': —Ja' jun oj jin tz'ub el sti', ja' ton jun tu', che mitx'a. C'anani che yute catu' che yi'ontoj, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yu jun tu', yuxan palan c'al yapni naj yin Jesús. —Jaach cuywam, ẍi naj tet Jesús. Catu' jix oc tz'ubna yin sti' naj. ");
INSERT INTO knjNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Catu' jix oc bulna eb yin, jix smitx'on eb, catu' jix i'letoj naj yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ja' eb yaman yetoj, ey jun jix yi' atej yespada. Jix tzoc'on el xiquin jun smoso naj yaawil yak'omal xaambal eb tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Catu' jix yalon Jesús tet eb ánima jix apni bulna yin tu' jaxca ti': —¿Tumi elk'om jin che yila, yuxan i'bil oc je yespada, c'al je te' chi jul jin je mitx'oni? ");
INSERT INTO knjNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Jun jun c'al c'u jix jin cuywa je xol yul stemplo Dios, pero ma jin je mitx' pax titu'. Jaxca ton ti' chi yun xin, yu yunen tzet tz'ibebil can yul An Juun Tz'ibebil can oj, ẍi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jix bejle can naj yu eb scuywom xojli, jix to eb el masanil. ");
INSERT INTO knjNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero ey jun naj ach'e tzajan c'al yintaj naj. Pichan oc jun an sábana yin smimanil, catu' jix oc mitx'na eb yin naj. ");
INSERT INTO knjNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero jix sbej can an sábana naj yul sk'ab eb, catu' jix el t'irt'on naj. ");
INSERT INTO knjNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Catu' jix yi'ontoj Jesús eb tu', bey naj yaawil yak'omal xaambal eb Israel tet Dios. Ja' ta' titu' jix syamba masanil eb yaawil eb yak'omal xaambal eb tet Dios, yetoj eb icham winaj, c'al eb cuywam yin sley Moisés. ");
INSERT INTO knjNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jal pax Pedro xin, naat tzajan yintaj Jesús masanta' c'al jix apni bey sgalera sna naj sat yaawil eb tu'. Catu' jix ey chotan k'aẍnoj yetoj eb policía sti' na tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ja' eb yaawil yak'omal xaambal eb tet Dios, c'al masanil eb sat yaaw, jix sey wanoj k'ane eb chi sna' a yin Jesús, yet watx' chi elol camich yiban yu eb. Pero c'am c'al tzet jix ilcha yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ec'al eb jix yak'le sna'on a k'ane yiban naj. Pero tx'oj tx'oj c'al tzet chi yal jun jun, yuxan ma ẍa'le sba yalon eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ey jun cawan eb jix yak'le ya waan sna'on a k'ane yin naj, catu' jix yalon eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ja' jaonti', jix kab yalon naj jaxca ti': “Jainti', oj wuch ey jun stemplo Dios wa'nebil yu ánima ti'. Ja' yet yox c'ual tu', catu' oj wa'xoj a sq'uexel wu an, man ánima oj, oj wa'nen oj,” ẍi naj jix kabe, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero toj c'al yu jun tu' chi ẍa'le sba yalon eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Catu' jix a waan naj yaawil yak'omal xaambal eb tet Dios tu' snan xol eb. Catu' jix yalon tet Jesús jaxca ti': —¿Tumi c'am chach tak'wi nioj? ¿Tumi c'am cha wab wan chi yal eb ja win ti'? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero tz'in c'al ẍi, ma c'al tak'woj. Catu' jix yalon naj tet Jesús junel xa: —¿Tumi jaach Cristo jaachti'? ¿Tumi jaach Sc'aal jaach Dios, naj chi al-le watx' k'ane yin? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Jaa', jain toni. Jain ton Ak'bil Wopiso xol eb ket animail yu Dios ti', oj jin je yil yet chotan jin ey bey swatx' k'ab Dios, naj miman yipal. Oj je yil pax weyol satcan xol asun, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Catu' jix snic'ontoj nioj spichil naj tu'. Catu' jix yalon naj jaxca ti': —¿Tzet to wal chi oc testigo ku tinani'? ");
INSERT INTO knjNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jix kabe, tol caw chi buchwa naj yin Dios. ¿Tzet je chi yu tinani'? ẍi naj. —Cam ojabi, ẍi eb masanil. ");
INSERT INTO knjNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jix lawi c'al jun tu', ey eb jix tz'ubli oc yin. Catu' jix smajchen sat naj eb, jix c'oli smak'on naj eb. Catu' jix sk'anlen el eb tet: —Na' el oj, mac jix jaach mak'oni, ẍi eb tet Jesús. Jix lawi jun tu', catu' ja' eb policía jix mak'on naj sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ey ec' naj Pedro bey sgalerail jun na tu', catu' jix apni jun ix criada naj yaawil yak'omal xaambal eb Israel tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Jix yilon ix yin Pedro, yet lalan sk'aẍni. Jix cam xa c'al yoc t'anan ix yin naj, jix yalon ix tet jaxca ti': —Jaachti', ja wetbi ja ba yetoj Jesús a Nazaret, ẍi ix tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero jix yi' el naj yin. —Ja' jun mac txequel cha wal tu', man wotaj an. Caw c'am nioj chi na'cha el wu wan tzet cha wal e in tu' an, ẍi naj tet ix. Jix lawi jun tu', catu' jix sjitzon el sba naj bey galera tu'. Catu' jix ok' a no' caẍlan. ");
INSERT INTO knjNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jix yilon ix criada tu' yin junel xa. Jix yalon ix tet eb yaman ec' titu': —Ja' ton jun winaj ti', yetbi sba yetoj eb scuywom Jesús, ẍi ix. ");
INSERT INTO knjNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero jix yi' pax el yin junel xa. Jun jix to txolan tu', jix yalon pax eb ey ec' titu' tet: —Caw yel, jaachti' ja wetbi ja ba yetoj eb yutol a Galilea jaach. Ilala, laan ja k'anab yetoj eb a Galilea, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Catu' jix c'oli sk'anontej sjowal sc'ul Dios yiban naj Pedro tu'. Jix slocontej sbi Dios, jix yaloni: —Ja' jun winaj che yal tu', caw man wotaj an, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yet xa c'al jun txolan tu', jix ok' a no' caẍlan yet scaelal. Catu' jix sna'ontej naj tzet jix yal Jesús tu' tet yet jix yalon jaxca ti': “C'am to chi ok' no' caẍlan yet scaelal catu' oj jin ja wi'on el ja win yin yoxelal yet oj ja waloni, tol ma jin ja wotaj oj,” ẍi Jesús tet naj. Ja' yet jix sna'ontej jun tu', catu' jix mi'chcha sc'ul yok'i. ");
INSERT INTO knjNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ja' yet jix sajbi a oj, jix syamba oc sba eb yaawil yak'omal xaambal eb Israel tet Dios yin sk'umbalba yetoj eb icham winaj, c'al eb cuywam yin sley Moisés, yetoj masanil wan xa eb sat yaaw. Jix lawi tu', jix sc'alon Jesús eb, jix yi'ontoj naj eb, catu' jix bet yak'on eb tet naj Pilato, naj yaaw. ");
INSERT INTO knjNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Catu' jix sk'anlen el naj Pilato tu' tet Jesús jaxca ti': —¿Tumi jaachti', Sreyal jaach eb Israel? ẍi naj tet Jesús. —Jaa', jain ton an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ja' eb yaawil yak'omal xaambal eb Israel tet Dios, ec'al tzet jix yal eb yiban Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yu jun tu', yuxan jix yal Pilato tu' tet naj jaxca ti': —¿Tumi c'am chach tak'wi nioj? Ab jantaj tzet chi yal a eb ja win, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero ja' naj Jesús xin, c'am nioj jix tak'wi. Yu jun tu', yuxan tuxa c'al chi q'uey a sc'ul Pilato yin. ");
INSERT INTO knjNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Beybalnebil c'al ta' yu Pilato tol chi sjaj el junoj a preso yet k'in jun jun jabil. Ja'ta'c'ala' mac chi sk'an jajcha eb conob. ");
INSERT INTO knjNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ey jun naj chi yij Barrabás, preso ye yetoj jaywan xa yetbi. Yak'lenaj jowal eb yetoj eb yaaw. Ey wan ánima camnaj yu eb yet yak'len jowal eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ja' yet jix apni bulna ánima tu', catu' jix sk'anlen eb tet Pilato, ta chi sjaj el junoj eb a preso jaxca c'al ta' sbeybal jun jun k'in. ");
INSERT INTO knjNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Catu' jix yalon naj tet eb jaxca ti': —¿Jam naj je Reyal jaex Israel jex ti' che yoche chin jaj el oj? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Quey tu' jix yute yaloni, yutol yotaj xa tol yu ẍichon c'ulal eb yaawil yak'omal xaambal eb Israel tet Dios yin, yuxan jix yi'tej Jesús eb sattaj. ");
INSERT INTO knjNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Catu' jix yak'on sc'ul ánima eb tu' yet watx' ja' Barrabás chi sk'an jajcha eb. ");
INSERT INTO knjNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Catu' jix sk'anlen Pilato tu' tet eb ánima tu' junel xa: —¿Tzet che yoche chi wute pax naj che yal oc je Reyal oj tu' xin? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Catu' jix a bulna eb yalon yin ipal jaxca ti': —Culusne naj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—Pero, ¿tzet yetal junoj pena jix sey yun jix je yil xin? ẍi naj tet eb. Tol jix a c'al yaw eb yaloni: —Culusne naj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Caw jix yoche naj Pilato tol watx' chi can yul sat conob, yuxan ja' naj Barrabás jix sjaj el oj. Jal naj Jesús jix yak' mak'le oj, catu' jix yaon oc yul sk'ab eb chi aon oc yin culus. ");
INSERT INTO knjNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ja' eb soldado jix i'ontoj Jesús bey sgalerail sna naj yaaw chi yij Pretorio. Ja' titu', jix awtele eytej eb soldado masanil. ");
INSERT INTO knjNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jix yaoc jun moradotaj pichile eb yin Jesús, jaxca wan pichile chi yaoc eb yaaw. Jix sk'alon ey xoyan jun q'uix eb. Jix yaon oc eb yin sjolom scorona oj. ");
INSERT INTO knjNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Catu' jix tz'ajon yal eb tet jaxca ti': —Tzalaan jaach Sreyal eb Israel, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jix c'oli smak'on oc jun a eb yin sjolom. Chi tz'ubli oc eb yin naj, catu' jix tz'aj skabanle ey sba eb tet. ");
INSERT INTO knjNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jix lawi yetnen eb jaxca tu' xin, jix yi'on el an moradotaj pichile eb tu' yin, catu' jix yaon c'al ta' can oc spichil eb. Catu' jix yi'ontoj naj eb bey oj ale oc naj yin culus tu' yu eb. ");
INSERT INTO knjNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ey jun winaj a Cirene chi yij Simón, smam Alejandro yetoj Rufo. Lalan to sjul bey jix bet ec'ab oj. Catu' jix ak'le jun sculusal Jesús yijtoj naj yu eb soldado. ");
INSERT INTO knjNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ja' bey jun lugar chi yij Gólgota, ja' tu' jix yi'toj Jesús eb tu'. Gólgota chi yal yel oc apnoj: Slugaril Sbajil Jolome. ");
INSERT INTO knjNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jix yak' yal uva calan yetoj jun xa tujan chi yij mirra yuc' naj eb. Pero ma ẍa' yuc' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jix lawi jun tu', catu' jix yaon oc naj eb yin te' culus, catu' jix yak'on suerte eb soldado yin spichil naj, yu yilon eb tzettaj yetal chi yi' can jun jun eb. ");
INSERT INTO knjNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A las nueve yet sk'inibalil, catu' jix yaon oc naj eb yin culus tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ey jayeb letra tz'ibebil oc oj. Ja' chi alon tzet yuxan jix elol camich yiban. “Ja' naj Sreyal eb Israel,” ẍi jayeb letra tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ey pax cawan elk'om jix culusnele yetoj naj, jun bey swatx' k'ab, jun xa bey sq'uexan k'ab. ");
INSERT INTO knjNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yuxan jix yun ton jaxca yalon can yul An Juun Tz'ibebil can oj, bey chi yal jaxca ti': “Oj utele jaxca chi utele eb penawom,” ẍi yul An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ja' eb jix ec' scawilal tu', jix buchwa can atoj eb yin. Catu' jix a tx'umna eb tet, jix yalon eb jaxca ti': —A… jaach ton ti', cha wuch ey stemplo Dios ja wala, catu' cha wa'nen a sq'uexel yin yox c'ual. ");
INSERT INTO knjNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Col ja ba. Eyantej yin te' culus tu', ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ja'c'ala' eb yaawil yak'omal xaambal eb Israel tet Dios, yetoj eb cuywam yin sley Moisés, jix buchwa pax atoj eb yin naj, catu' jix yalon eb jaxca ti': —Ey mac jix scolo, pero ja', c'am chi ske' scolon pax sba tinani', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","—Ta chi yi' eytej sba yin culus, jun chi yal oc sba Cristoal, cu Reyal oj, jaon Israel jon ti', chi kaoc cu c'ul yin, ẍi eb. Tol tax eb locan a yin culus tu' yetoj, jix buchwa pax eb yin. ");
INSERT INTO knjNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ja' yet jix chumanbi c'u, jix k'ejbi masanil yul yiban k'inal masanta' c'al yet a las tres. ");
INSERT INTO knjNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yet xa c'al jun txolan tu', jix a yaw Jesús yin ipal: —Eloí, Eloí, ¿lama sabactani? ẍi a oj. Chi yal yel oc apnoj: Jaach jin Diosal, Jaach jin Diosal, ¿tzet yuxan chin ja bej can jin txojli? ");
INSERT INTO knjNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ja' eb ey ec' scawilal tu', jix yab eb yoc jun k'ane tu', yuxan jix yal eb jaxca ti': —Ab wej ja' jun ẍejab Dios chi yij Elías chi yawte, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jix lawi tu', ey jun winaj ani stoi, jix c'al apni titu', catu' jix yaon eytoj jun tzet chi lababi xol vinagre. Jix yaon oc xam jun te' a, catu' jix yaon atoj yin sti' Jesús, jix yaloni: —Yil xa sba, oj kila ta oj jul i'le eytej naj yu Elías tu', ẍi. ");
INSERT INTO knjNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Catu' jix a yaw Jesús junel xa yin ipal, catu' jix el sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ja' yet jix cam Jesús tu', jix ey nic'na snan an k'ap ey oc smajil oj yul snan stemplo Dios tu'. Jix ẍa' eytej snic'chatoj sjolomtaj, masanta' c'al jix eyol sti'laj. ");
INSERT INTO knjNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jix yab naj yaawil eb soldado linan oc sattaj Jesús yel yaw. Jix yil tzet jix yun scami, yuxan jix yal jaxca ti': —Ja' jun jix cam ti', tol yel caw Sc'aal Dios, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ey pax wan eb ix ix t'anantej naat. Yaman ix María Magdalena yetoj eb, c'al ix Salomé, c'al María xutx José yetoj Jacobo, naj tzunan unin. ");
INSERT INTO knjNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ja' wan eb ix ix ti', jix ec'ab c'al eb yintaj naj yet ey ec' naj bey Galilea. Jix ak'le servil naj yu eb. Ec'al to c'al wan xa eb ix ix yaman sto yetoj naj bey Jerusalén. ");
INSERT INTO knjNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ja' yet jun c'u tu', sc'ual swa'nen settaj yetal eb oj sk'anbalne yutol yecal oj xa c'al sc'ual xewilal. Ja' yet lalan xa sk'ejbi xin, ");
INSERT INTO knjNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","jix apni naj José a Arimatea. Mimej winaj xol eb yet yaawil. Ja' José tu', echbanebil pax yoc Dios Yaawil yu. C'am nioj chi xiwi catu' jix octoj sattaj Pilato, jix bet sk'anon smimanil Jesús tet. ");
INSERT INTO knjNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Caw jix q'uey a sc'ul Pilato yet jix yabeni tol camnaj xa Jesús. Yu jun tu', yuxan jix bet yak' tit naj yaawil eb soldado, catu' jix sk'anlen el tet, ta camnaj xa Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ja' yet jix yabeni, tol camnaj xa, catu' jix yaloni, tol chi ske' sto yi'on eytej smimanil Jesús tu' naj José tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ja' José tu', jix sman jun sábana caw watx'. Catu' jix bet yi'on eytej jun mimanile tu'. Jix spichon oc jun sábana tu' yin. Catu' jix bet yaon can octoj yul jun ch'en ch'en jolbil xa tu', jix smajchen can yetoj jun ch'en. ");
INSERT INTO knjNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ja' ix María Magdalena yetoj ix María xutx José, jix yil eb bey jix octoj smimanil tu'. ");
INSERT INTO knjNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ja' yet jix ey can c'u yet sc'ual xewilal, jix sman ix María Magdalena yetoj ix Salomé, c'al María xutx naj Jacobo wan tzet yetal suk'uk'i sab, yu sto yaon oc eb yin Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ja' yet jix sajbi a yet domingo, jix to eb bey ch'en ch'en bey jix muji octoj tu'. Lalan yaol c'u, yet jix apni eb. ");
INSERT INTO knjNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Catu' jix yalon eb jaxca ti': —¿Mac oj balon el ch'en smajil bey mujan octoj tu' e on? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ja' ch'en smajil tu' caw miman ch'en. Pero jix yilontoj eb, elnaj xa ch'en. ");
INSERT INTO knjNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Catu' jix yilon eb yet jix oc apnoj eb yul ch'en ch'en tu', chotan ey jun ángel bey swatx' k'ab eb, jaxca yili junoj ach'e. Ey oc jun jojan saj pichile yu. Caw jix xiw a eb ix sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Catu' jix yalon jun ángel tu' tet eb ix: —Manchej jex xiwi. Jaexti', ja' Jesús a Nazaret che sey ec' oj, jun jix ale oc yin culus. Jix pitzc'u a oj. C'am xa mac ey ec' yul ch'en ti'. Il wej bey jix jul ale octej naj yu eb ti'. ");
INSERT INTO knjNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Asi' wej, al wej tet wan eb scuywom c'al tet Pedro, tol babel sto naj je sattaj bey Galilea. Oj je yil yin titu' jaxca jix yute yalon can e ex, ẍi jun ángel tu' tet eb ix. ");
INSERT INTO knjNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Catu' jix eltej eb ix yul ch'en ch'en tu'. Catu' jix to eb. Caw chi bilwi eb yu xiwcanil. C'am junoj mac tet jix yal el eb, yutol chi xiw eb. ");
INSERT INTO knjNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ja' yet domingo yet ey to sajbi jix pitzc'u a Jesús. Ja' tet ix María Magdalena jix babi x'ox a sba. Ja' ton yin jun ix tu' i'bil el jujwan pena espíritu yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jix bet yal ix tet wan eb naj jix ec' yetoj Jesús yet yalantoj. Yutol caw chi ok' eb yu cusilal. ");
INSERT INTO knjNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ja' yet jix yalon ix tet eb, tol jix pitzc'u a Jesús, catu' tol jix yil ix yin naj, ma ẍa' yab eb. ");
INSERT INTO knjNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Catu' jix x'oxon a sba Jesús tet cawan eb scuywom, sti' el conob yet lalan sbey eb. Tx'oj yili jix yil eb. ");
INSERT INTO knjNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yu jun tu' xin, jix meltzo eb yu bet yalon eb tet wan xa yet cuywomal. Pero ma pax ẍa' yab eb. ");
INSERT INTO knjNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ja' junel xa, yet lalan slow eb scuywom jusluc'wanil, jix x'oxon a sba Jesús tet eb. Jix tzule eb yu, yutol jix yak' caab c'ulal eb, catu' caw caw sna'bal eb. Ila ma ẍa' yab eb tet eb jix ilon yet jix pitzc'u a oj. ");
INSERT INTO knjNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Catu' jix yalon tet eb jaxca ti': —Asi' wej bey masanil yul yiban k'inal. Asi' al wej el sk'aneal yet colbanile xol masanil ánima. ");
INSERT INTO knjNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ja' mac oj yaoc yin sc'ul, catu' chi yak'on bautizar sba, oj colcha oj. Pero ja' mac c'am chi yaoc yin sc'ul xin, oj jul sya'ilal yiban. ");
INSERT INTO knjNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ja' eb oj yaoc yin sc'ul, oj ske' x'oxon wan milagro eb ti': Oj ske' yi'on can el pena espíritu eb yin ánima yu wipal an. Oj k'anab a eb yin tx'oj ti'eal. ");
INSERT INTO knjNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ta chi smitx' laba eb, ta chi yuc' eytoj eb junoj tzet yetal chi cam ánima yu, c'am tzet oj i'on eb. Ta chi sbatxba oc sk'ab eb yiban eb ya' ey, oj wa'xoj can sc'ul eb yu eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ja' yet jix lawi yalon jun ti' naj Kaawil Jesús tet eb scuywom tu', jix i'le pax a naj satcan, catu' jix ey chotan bey swatx' k'ab Dios. ");
INSERT INTO knjNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Catu' jix to eb yalon el sk'ane Dios tu' bey jun jun lugar. Jix oc c'al naj Kaawil yetoj eb. Ja' c'al naj jix mulna yetoj eb, yet watx' chi txeclo el oj, tol yel jun k'ane chi ec' yal el eb tu'. Amén.");
INSERT INTO knjNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Ja' tinani' xin, chin tz'ibetoj jun juun ti' e ach Teófilo, yet watx' cha wotajne el oj, tol yel wan tzet yetal jix ja cuy el tu'. Cax c'al ec'al ánima jix tz'ibentoj wan tzet yetal jix yun cu xol ti', pero jix jin na' tol watx' ta chi waltoj e ach masanil tzet jix yun yin xolilal yet tax jix ẍa'on el yich. Ja' eb chi alon el sk'ane Dios tinani', ec'al eb jix ilon wan tu' yet tax jix ẍa'on el yich. Ja' yin jix cu cuyle yu eb on. Jix jin cuy masanil wan ti' yin c'uan c'ulal yet watx' chi ske' jin tz'ibentoj e ach yin jichan. ");
INSERT INTO knjNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ja' yet ey oc Herodes yaawil bey tx'otx' Judea, ey jun bulan eb yak'omal xaambal eb Israel tet Dios chi yij sbi Abías. Ey jun winaj xol eb chi yij sbi Zacarías. Elisabet sbi yistil naj. Yic'aal to Aarón pax ix. ");
INSERT INTO knjNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Watx' sbeybal eb scawanil yul sat Dios. Jijyom eb tet ẍejbanil c'al tet sley naj Kaawil. Yuxan c'am junoj mac chi ske' yaloni, tol ey junoj spenail eb. ");
INSERT INTO knjNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","C'am junoj yuninal eb, yutol man unewom oj ix. Yetoj pax oj icham ánima xa eb scawanil. ");
INSERT INTO knjNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ja' yet jun c'ual, yet jix a apnoj stiempoal yak'wi servil Zacarías yetoj jaywan xa eb yetbi, yet chi ak'le servil Dios yu eb Israel, ");
INSERT INTO knjNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","jix yaoc puesto eb, jaxca c'al ta' sbeybal eb jun jun ta' el, yu xeclo el mac oj cha'on jun opiso tu'. Ja' yiban Zacarías jix eyi. Yuxan jix octoj naj yul stemplo naj Kaawil. Jix bet yak'on tz'a' pom suk'uk'i sab. ");
INSERT INTO knjNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ja' yet jix yak'on tz'a' tu', masanil eb ánima ey oc titu' ey can eb sti' templo txaloj. ");
INSERT INTO knjNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ja' yet ey octoj tu', jix jul x'oxon ec' sba jun yángel naj Kaawil tet Zacarías tu'. Jix jul ec' wojan bey jun pac' smeẍail snusbanil pom tu' bey yet c'ulal swatx' k'ab Zacarías. ");
INSERT INTO knjNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ja' yet jix yilon yin jun ángel naj tu', caw jix q'uey a sc'ul. Jix xiw can a naj yu. ");
INSERT INTO knjNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Catu' jix yalon jun ángel tu' tet naj jaxca ti': —Zacarías, manchej jaach xiwi, jix yab Dios ja txa. Yuxan, ja' ja wetbi Elisabet, oj aloj jun swinaj unin. Juan oj ja wak' yij sbi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Caw oj tzala je c'ul yin. Ec'al ánima oj tzala a yet oj yabeni tol jix ali jun je yuninal. ");
INSERT INTO knjNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ja' jun unin tu', caw miman oj yun yel oc apnoj yul sat Dios. Man oj yuc' vino, man oj yuc' an. Ey xa oc Santo Espíritu yin naj yet oj aloj naj. ");
INSERT INTO knjNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ec'al eb Israel oj swa'ne oc sba yin naj Kaawil Dios junel xa yu jun ja c'aal tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ja' naj Juan tu' oj baboj sattaj naj Kaawil. Jaxca c'al sna'bal naj Elías c'al yipal naj, quey tu' oj yun sna'bal c'al yipal naj ja c'aal. Yuxan oj tenchanele eb mame, c'al eb uninale yet ey jowal xol eb, yet watx' chi tan el oj. Ja' oj q'uexon pax sna'bal eb, yet watx' ey eb listo xa ye yet oj jul naj Kaawil, ẍi jun ángel tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jix yalon Zacarías tu' tet jun ángel jaxca ti': —¿Tzet oj yun wotajne el oj ta tol yel wan cha wal ti'? Yutol jainti', caw icham jin xa an, yetoj wetbi an, ixnam xa pax ix, ẍi naj tet jun ángel. ");
INSERT INTO knjNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jix yalon jun ángel tu' tet naj: —Jain, Gabriel jin an. Yak'omal jin servil Dios an. Jain jix jin chejletej yu jul walon jun k'ane ti' e ach an. ");
INSERT INTO knjNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tinani', ma xa ske' ja k'anab nioj, masanta' c'al oj aloj jun unin jix wal tu' an. Yutol ma ja waoc yin ja c'ul tzet jix wal tu' an, yuxan quey tu' oj ja wune. Ja' to yet oj apnoj stiempoal catu' oj yunen jun ti', ẍi jun ángel tu' tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ja' eb ánima chi yechbane yeltej Zacarías tu'. Jix q'uey a sc'ul eb yutol caw miman tiempo jix bet octoj naj yul stemplo Dios tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jaxa yet jix eltej, ma xa ske' sk'anab tet eb. Jix sna'on el eb conob tu' tol ey junoj tzet yetal jix x'ox Dios tet naj. Sk'ab xa c'al jix x'ox yin yechel oj, yutol jix maji el sti' naj. ");
INSERT INTO knjNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jix apnoj stiempoal jix lwai yak'le servil yu naj Zacarías, catu' jix paxtoj eb bey sna. ");
INSERT INTO knjNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Man to pey oj tu', catu' jix yijon oc unin ix Elisabet. Joeb xaaw ey xa c'al ec' ix bey sna. Jix c'oli sna'ontanen jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Yu yipal naj Kaawil, yuxan quey tu' chi wun an, yetoj pax yet watx' c'am xa chi al-le jin k'umal yu ánima, yutol c'am wune' an,” ẍi ix. ");
INSERT INTO knjNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Wajeb xa xaaw yijon oc jun unin ix Elisabet tu', catu' jix chejletej ángel Gabriel yu Dios bey conob Nazaret, bey tx'otx' Galilea. ");
INSERT INTO knjNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Jix jul ec' bey jun ix k'opo chi yij sbi María. C'am to chi yil-le sba yetoj junoj winaj. Ja' jun ix tu', ey xa strato ix yetoj jun winaj chi yij sbi José, ic'aale to ye naj yu naj rey David. ");
INSERT INTO knjNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jix octoj jun ángel tu' bey ey ec' ix. Jix yalon tet ix jaxca ti': —Tzalaan c'al yutol caw xaan jaach yu naj Kaawil Dios. Ey oc Dios ja wetoj. Yel xa c'al miman swatx' c'ulal Dios jix yak' e ach sattaj masanil ja wet ixal, ẍi ángel Gabriel. ");
INSERT INTO knjNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ja' yet jix yilon oc ix yin jun ángel tu', jix q'uey a sc'ul ix. Jix sna'ontej ix tzet chi yal yel oc apnoj tzet jix yal jun ángel tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Catu' jix yalon pax jun ángel tu' tet ix jaxca ti': —María, manchej jaach xiwi, yutol miman swatx' c'ulal Dios jix x'ox e ach. ");
INSERT INTO knjNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ja' tinani', oj oc jun unin ja win, oj aloj jun winaj unin ja wu. Jesús, oj ja wak' yij sbi. ");
INSERT INTO knjNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Caw miman winaj oj yun yel oc oj. Oj bina oj tol sc'aal jun yel xa c'al miman yel oc apnoj, ja' ton Dios. Ja' Dios Kaawil tu', oj aon oc naj reyal. Catu' oj oc can sq'uexel oj naj rey David, naj yichmam naj. ");
INSERT INTO knjNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Oj oc Yaawil oj eb ja wet conob Israel yin tobal k'inal. C'am bak'in oj lawoj jun yopiso tu', ẍi jun ángel tu' tet ix. ");
INSERT INTO knjNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","—¿Pero tzet oj yun ske'on jun cha wal tu'? Jainti' c'am to wetbi, ẍi ix tet jun ángel tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","—Ja' Santo Espíritu oj jul ja wiban. Ja' yipal naj yel xa c'al miman yel oc apnoj tu', ja' oj eyol yenel ja wiban. Yuxan, ja' jun unin oj aloj tu' yet c'al Dios yei. Oj bina oj, tol Sc'aal Dios naj. ");
INSERT INTO knjNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Catu' ja' ja wican Elisabet, caw ixnam xa ix, pero oj aloj jun swinaj unin. Chi yal eb ánima tol c'am bak'in oj yil junoj unin ix. Pero wajeb xa xaaw yijon oc unin ix tinani'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yutol masanil chi c'al ske' yu Dios, ẍi jun ángel tu' tet ix. ");
INSERT INTO knjNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Catu' jix tak'wi ix María: —Ẍejab Kaawil wei, yuxan ske' ojab jaxca jix ja wal tu', ẍi ix tet jun ángel tu': Jix lawi tu' xin, catu' jix to jun ángel tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Txenxane tiempo catu' jix to María bey jun conob ey ey xol wan wonquiltaj tx'otx' yul yet Judea. ");
INSERT INTO knjNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jix apni ix bey sna naj Zacarías. Jix ak'le scawil sc'ul ix Elisabet yu ix. ");
INSERT INTO knjNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ja' yet jix yaben Elisabet sk'anab ix María tu', catu' jix bilwi a jun unin ey xa oc yin ix tu'. Catu' caw ey oc Santo Espíritu yin ix Elisabet tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Catu' jix yalon ix yin ipal jaxca ti': —Jaachti', yel miman swatx' c'ulal Dios jix x'ox e ach sattaj masanil eb ix ket ixal. Miman pax swatx' c'ulal oj x'ox tet jun oj aloj ja wu. ");
INSERT INTO knjNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Jainti', c'am nioj wel oc apnoj, jal jaachti' xin, xutx jaach naj Kaawil. Pero chach jul pax k'anab wetoj an. ");
INSERT INTO knjNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Asanne c'al jix waben ja k'anab yet jix jaach juli, jix bilwi a jun unin ey xa oc win ti' an. Quichan xa c'al tol chi tzala chi wab an. ");
INSERT INTO knjNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jaachti', xa waoc yin ja c'ul tol oj yun tzet jix yal naj Kaawil e ach. Yuxan, caw tzala c'ulalil ja wei, ẍi Elisabet tu' tet ix María. ");
INSERT INTO knjNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jix lawi tu' xin, jix yalon María jaxca ti': —Chi wal watx' k'ane tet naj Kaawil yin masanil jin c'ul. ");
INSERT INTO knjNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Caw chi tzala jin c'ul yin Dios cu Colomal. ");
INSERT INTO knjNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Jainti', yak'omal jin servil Dios an. C'am nioj wel oc apnoj, pero jix ok' sc'ul Dios win an. Yuxan oj yal eb ánima tobal k'inal tol Dios jix x'ox swatx' c'ulal e in an. ");
INSERT INTO knjNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yutol ja' Dios, caw miman yipal. Miman swatx'ilal jix x'ox e in an. C'am junoj xa bie jaxca sbi Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tobal k'inal chi ok' sc'ul yin mac jijyom tet. ");
INSERT INTO knjNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jix x'ox el oj tol caw miman yipalil. Jix can can eb chi yec'banne sba yalan yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jix i'le can el eb yaaw yin yopiso, jal eb c'am yel oc apnoj, jix i'le a can eb. ");
INSERT INTO knjNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jix yak' no sc'ul eb ey snochail. Jal eb be'om, c'am nioj tzet jix ak'le tet eb catu' jix ujteletoj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Jix oc ketoj jaon Israel jon ti', jaon yak'omal jon servil ti'. Ma toj q'uey c'ulal yok' sc'ul kin. ");
INSERT INTO knjNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Jaxca yalon can tet eb kichmam, yutol yak'naj can sti' tet naj Abraham, c'al tet jantaj eb yic'aal yin junelne, ẍi ix María tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Oxeb mi xaaw jix bet ec' María tu' bey Elisabet, catu' jix meltzotej bey sna tu' junel xa. ");
INSERT INTO knjNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ja' yet jix jul xa c'al stiempoal ali yune' ix Elisabet, winaj unin jun jix ali. ");
INSERT INTO knjNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ja' yet jix yaben eb ánima scawilal c'al eb yican tol jix x'ox swatx' c'ulal naj Kaawil tet ix, jix tzala a eb yetoj ix. ");
INSERT INTO knjNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jujubixi tax ali, catu' jix apni eb bey sna naj Zacarías, yu yale oc jun yechel chi yij sbi circuncisión yin swinajil jun unin tu'. Jix yoche eb jix yij sbi jun unin yin Zacarías, yet watx' chi oc sq'uexel oj smam tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero jix yalon ix txutxe tu' tet eb jaxca ti': —C'amaj, Juan oj yija, ẍi ix tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—¿Tzet yuxan quey tu' oj ja wak' yija? C'am junoj je yetbi quey tu' yoc sbi, ẍi eb tet ix. ");
INSERT INTO knjNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ja' yet jix sk'anlen eb tet smam naj unin tu' yin yechel tzet bieal chi yoche chi yij naj. ");
INSERT INTO knjNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Catu' jix sk'anon nioj tzet yetal bey chi tz'ibe ey tu'. Catu' jix s'iben ey oj: “Juan chi yij sbi jun unin ti',” jix s'iben ey oj. Tuxa c'al jix q'uey a sc'ul masanil eb yet jix yilon jun tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ja' yet jix tz'iben jun tu' yu naj Zacarías, catu' jix jajcha a sti' yu chi ske' sk'anabi. Jix yalon watx' k'ane naj tet Dios tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yuxan, caw chi q'uey a sc'ul jantaj eb ánima scawilal. Catu' jix abcha sk'umal jun ti' bey masanil jun wonquiltaj tx'otx' bey tx'otx' yul yet Judea tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ja' masanil eb jix aben wan tu', catu' jix sna'ontane eb, tzet yei. Jix yalon eb jaxca ti': —¿Tzet oj yun yel oc jun unin ti'? ẍi eb. Quey tu' jix yal eb yin naj yutol chi ske' yilon eb tol ey oc yipal naj Kaawil yin jun unin tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ja' smam jun unin tu', ja' ton naj Zacarías. Caw ey oc Santo Espíritu yin. Yuxan jix ak'le k'anab a yu. Jix yalon jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kal wej watx' k'ane tet naj Kaawil, cu Diosal jaon Israel jon ti'. Yutol jix jul ku, jaon sconob jon ti', yu cu scolon el oj. ");
INSERT INTO knjNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Oj yatej jun cu Colomal caw miman yipal. Ja' snan xol eb yic'aal naj David, naj yak'omal servil Dios, ja' xol eb oj aloj. ");
INSERT INTO knjNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jaxca tu' jix yute yalon can Dios yet peyxa, yet jix yak'balnen eb ẍejab, ja' ton eb profeta, sic'bil el yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Jix yal can Dios tol oj cu scol el yul sk'ab eb cajat oc kin, c'al yul sk'ab jantaj eb chi chichon oc sc'ul kin. ");
INSERT INTO knjNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Albil pax can tol oj ok' sc'ul yin eb kichmam. Man oj toj q'uey c'ulal jun strato jix yak' yetoj eb, yutol ja' jun strato tu', asan Dios ey yet. ");
INSERT INTO knjNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Quey tu' jix yute yak'on can sti' tet kichmam Abraham yet jix slocon sbi tet. ");
INSERT INTO knjNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Jix yal can oj tol oj cu scol el yul sk'ab eb cajat oc kin, yet watx' c'am chi cu xiw wej kak'on servil Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Quey tu' oj kute yet watx', watx' ojab cu beybal, asanne ojab yin Dios chi kaoc cu c'ul tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jal jaachti' xin, jaach jin c'aal, oj jaach oc ẍejab oj Dios miman yel oc apnoj. Yutol oj jaach baboj sattaj naj Kaawil, catu' oj c'oli swa'nen sna'bal eb ánima, jaxca chi yun swa'xi junoj be. ");
INSERT INTO knjNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Jaach oj ja wak' na'cha el yu eb sconob tzet oj yun scolcha eb, catu' oj el can spenail eb yiban. ");
INSERT INTO knjNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yutol cam c'ulnebil jon yu Dios. Caw chi ok' sc'ul cu Diosal kin wej. Jaxca chi yun yaol c'u, catu' chi cu sejteneni, jaxca tu' oj yun sjul jun chejbiltej yu Dios tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yu sejtenen spixan eb ey ec' xol k'ej k'inal tu'. Eb lalan sto bey camich. Ja' oj tx'oxon pax e on tzet chi yun cu beybalneni, yet watx' yin watx' c'ulal chi cu ec' yetoj, ẍi naj Zacarías. ");
INSERT INTO knjNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ja' jun unin tu', jix ch'ib c'al a oj, jix jul sna'bal, catu' jix betle ec' bey cusiltaj tx'otx', masanta' c'al jix a apnoj stiempoal x'oxon a sba tet eb yet Israelal. ");
INSERT INTO knjNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ja' yet jun tiempoal tu', ey jun naj yaaw a Roma, Augusto sbi naj. Jix yak' jun chejbanil naj tol chi bisle jantaj ánima ey yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jix oc jun babel biswal yet ey oc naj Cirenio yaawil bey jun lugar Siria sbi. ");
INSERT INTO knjNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sowalil chi to masanil ánima bey sconob yichmam yu jun biswal tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yuxan jix tit naj José bey conob Nazaret yul scuenta Galilea. Jix to naj bey conob Belén yul scuenta Judea. Ja' jun naj rey David tu', ichmame ye naj yu naj José. ");
INSERT INTO knjNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jix to naj José yak' sbi yetoj ix María yul an libro bey conob Belén. Xax yak' strato eb pero c'am to chi yil-le sba eb, pero mimejal xa ix. ");
INSERT INTO knjNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yet ey ec' eb bey conob Belén jix jul stiempoal yali jun yune' ix María. ");
INSERT INTO knjNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ja' titu' jix ali naj babel unin, catu' jix spichon oc an k'ap ix yin naj nene' tu', catu' jix yaon eytoj ix yul jun jucub bey chi low no' nok', yutol c'am bey chi ey ey eb bey jun posada tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bey scawilal conob Belén ey wan eb naj ilom me'. Ey ec' eb bey jun ac'al yet jun ak'bal tu'. Tol chi sweyne sme' eb naj. ");
INSERT INTO knjNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jix jul jun yángel cu Mam Dios yin eymanil sc'atan wan ilom me'. Jix el sejejial yinlaj eb naj yu yipal cu Mam Dios. Caw chi xiw eb naj ilom me' tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero jix yal naj ángel tu' tet eb naj: —Manchej jex xiwi, yutol i'bil jun caw watx' k'ane wu an. Yu jun k'ane ti' oj tzalaboj masanil eb ánima yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ja' bey conob Belén, sconob naj David, jix ali jun unin, je Colomal, Cristo sbi yopiso naj, tol je Yaawil. ");
INSERT INTO knjNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Oj je na'tej ta caw yel chi wal e ex yet che yilon jun unin tu' pichbil oc k'ap yin, ey eytoj yul jun jucub, ẍi jun ángel tet eb naj ilom me' tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ja' yet lalan yal-le jun ti' tet eb xin, catu' jix jul wan xa eb ángel. Jix tit yin eymanil bey satcan. Jix yalon watx' k'ane eb tet Dios jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Kal wej watx' k'ane tet Dios bey satcan, c'al yetoj bey yul yiban k'inal ti'! Yu swatx' c'ulal Dios oj jul watx' c'ulal yin eb ánima chi tzala yetoj, ẍi wan ángel tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Xax paxtoj wan ángel bey satcan tu', catu' jix yal-len wan ilom me' tu' tet yet. Jix yalon eb jaxca ti': —Toon nej bey Belén tu', kil wej naj Kaawil jix al-le e on tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Catu' jix to eb yin ani. Jix txax eltej ix María yetoj naj José yu eb naj, catu' jix yilontej jun unin eb naj tu', tol jilan eytoj yul jun jucub. ");
INSERT INTO knjNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yet jix yilontej eb naj ilom me' tu', jix yalon eb naj tet naj José yetoj ix María tzet yetal jix al-le tet eb naj yu wan ángel yin jun nene' unin tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Masanil mac txequel jix aben yalon wan ilom me' tu', jix q'uey a sc'ul eb yu tzet yetal chi yal wan ilom me' tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Jal ix María xin, jix yaoc wan k'ane ti' yin sc'ul, jix sna'on el wan k'ane ti' ix. ");
INSERT INTO knjNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Catu' jix paxtoj eb naj ilom me' tu' xin. Jix yalon watx' k'ane eb naj tet Dios yu masanil tzet yetal jix yab eb naj, jix yil eb naj. Yutol masanil jix yil eb naj jaxca tzet yetal jix al-le tet eb naj yu wan ángel. ");
INSERT INTO knjNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jujubixi tax ali jun unin tu', jix ale oc jun yechel chi yij sbi circuncisión yin swinajil. Catu' jix yijon sbi yin Jesús yu eb. Ja' ton jun bie ti' jix yal can naj ángel tet María. Yet c'am to chi oc jun unin tu' yin. ");
INSERT INTO knjNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ja' sbeybal eb Israel, sowalil ey jun tiempoal chi sajbane sba eb ix yet xax ali yune', jaxca yalon sley Moisés. Yuxan, ja' yet jix lawi stiempoal sajbanen sba ix María, jix yi'ontoj eb jun unin tu' bey Jerusalén. Jix bet ak'le jun unin tu' yu eb tet naj Kaawil. ");
INSERT INTO knjNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jix yun eb jaxca tu', yutol quey tu' tz'ibebil can yul sley naj Kaawil, chi yal jaxca ti': “Ja' jun winaj unin chi babi ali, chi ak'le tet naj Kaawil yu yak'on servil,” ẍi yul An Juun Tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yu pax yak'on xaambal eb tet Dios, yuxan jix bet eb, chi yal sleyal xaambal jaxca ti': “Sowalil cac'onoj no' cajmu, ma cac'onoj cuate',” ẍi ley. ");
INSERT INTO knjNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ja' yet jun tiempoal tu', ey ec' jun naj chi yij sbi Simeón bey Jerusalén tu'. Caw watx' sbeybal naj, asan tet Dios chi yi' ey sba. Echbanebil c'al sjul Scolomal eb yet Israelal yu. Ey oc Santo Espíritu yin naj. ");
INSERT INTO knjNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ja' tet naj jix ak'le na'cha el oj, tol ma to oj cam naj masanta' c'al oj yil oc yin Cristo naj, naj chejbiltej yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jix ijbaletoj naj bey stemplo Dios yu Santo Espíritu tu'. Ja' yet jix i'letoj nene' Jesús bey stemplo Dios yu naj José c'al xutx yu sjijen eb yunen jaxca yalon can yul ley, ");
INSERT INTO knjNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","catu' jix cha'le ec' jun naj nene' Jesús yu naj Simeón, catu' jix ẍelon a naj, catu' jix yalon watx' k'ane tet Dios yu jun tu', jix yal jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Mamin, jainti' ja wak'omal servil we an. Ja' tinani', cam oj jin yin watx' c'ulalil yutol jix yun tzet albil can ja wu e in an. ");
INSERT INTO knjNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yutol jix wil yetoj jin sat jun Colwawom an. ");
INSERT INTO knjNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ja' ton jun naj ti', jix ja wak' yopiso sattaj masanil ánima yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ja' ton jun ti', oj ak'on saj k'inal yin spixan eb man Israel oj. Ja' jaon ja conob Israel jon xin, miman oj yun kel oc apnoj jon, ẍi naj Simeón tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ja' naj José yetoj xutx naj Jesús tu', jix q'uey a sc'ul eb yaben tzet jix yal naj Simeón tu' yin naj unin tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Catu' jix sk'anon swatx' c'ulal Dios naj Simeón yiban eb. Jix yalon tet ix María, xutx naj Jesús tu' jaxca ti': —Ilala, ja' jun unin ti', txequel xa yei, tol ec'al eb ket Israelal oj somcha el sc'ul yin. Pero ec'al pax eb oj swa'ne sbeybal yu. Ja' oj tx'oxon el oj, tzet utbil chi yun scolcha eb, pero ec'al eb oj intajnen el naj. ");
INSERT INTO knjNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Quey tu' oj yun xeclo el oj, tzet chi sna' jun jun ánima yin spixan. Jal jaachti' xin, ey jun c'ual oj oc pitz'an cus c'ulal yin ja pixan yu, jaxca junoj ch'en oj tejletoj bey ja pixan quey tu' oj ja yun ja waben sya'il, ẍi naj Simeón tu' tet María. ");
INSERT INTO knjNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ey pax jun ix ix yalomal el sk'ane Dios ey ec' titu'. Ana sbi ix. Scutz'in jun naj chi yij sbi Fanuel, yic'aal naj Aser. Caw ixnam xa ix. Jix ocle yetbi yet caw k'opo to ix tu'. Jujebne jabil jix yil-le sba ix yetoj yichamil catu' jix cam naj. ");
INSERT INTO knjNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Catu' jix can can ix xojli, ja' yet tu' ochenta y cuatro ya'bilal xa ix. Ja' c'al bey stemplo Dios ey c'al ec' ix, c'ualil c'al ak'balil, ja' c'al titu' jix ak'le servil Kaawil yu ix. Chi yijle nocha sba catu' chi txali. ");
INSERT INTO knjNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jix apni ix sc'atan José yetoj María yet jun txolan tu', catu' jix yalon yu diosalil ix tet Dios. Catu' jix yalon el sk'aneal Jesús ix xol jantaj eb chi echbanen sjul stiempoal oj colcha el conob Jerusalén tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ja' yet jix lawi sjijen eb jaxca yalon sley naj Kaawil yu eb unin chi ali, catu' jix paxtoj eb bey conob Nazaret junel xa bey yul yet Galilea. ");
INSERT INTO knjNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jal jun unin tu' xin, yel c'ulal jix ch'ib a oj. Jix yi'on c'al yip, c'al sjelanil. Jix yak'on c'al swatx' c'ulal Dios yiban. ");
INSERT INTO knjNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jun jun jabil chi bet ec' smam xutx Jesús bey Jerusalén, jix to eb yu ilo k'in pascua. ");
INSERT INTO knjNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lacaweb xa jabil sk'inal Jesús tu' yet jix bet yetoj eb yin sbabelal yu ilo k'in jaxca sbeybal eb. ");
INSERT INTO knjNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jix lawi c'al k'in tu', catu' jix paxtoj eb. Pero ja' naj Jesús tu', jix can can naj bey Jerusalén tu', pero man yotaj oj xutx c'al José tu' tol jix can can naj. ");
INSERT INTO knjNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ja' sna'on eb tol ey ec' naj yetoj eb ánima yaman spaxtoj yetoj eb. Yuxan, ja' yet jix ey c'u jix seyle ec' naj yu eb xol yican c'al xol eb yamigo. ");
INSERT INTO knjNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero ma txax naj yu eb. Yuxan jix meltzo pax eb yintaj junel xa, catu' jix bet seyle ec' naj yu eb bey Jerusalén tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Caabi tax tu', catu' jix ilcha naj yu eb yul stemplo Dios. Chotan ey naj xol eb cuywam yin sley Moisés. Chi able tet eb, catu' chi yak'on pax k'anlebal tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Caw chi q'uey a sc'ul eb chi aben yin tzet chi yal Jesús tu', yutol caw yotaj naj sic'lebil. Watx' c'al chi yute tak'woj sba tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ja' yet jix yilon smam xutx tu', tol ja' titu' ey ec' oj, caw jix q'uey a sc'ul eb yu. Yuxan jix yal xutx tu' tet naj jaxca ti': —Jaach wune', ¿tzet yuxan quey tu' cha wute ja ba e on? Ja mam c'al jainti', caw chach cu sey ec' yin cus c'ulal, ẍi ix tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","—Pero, ¿tzet yuxan chin je sey ec' oj? ¿Tumi man je yotaj oj tol sowalil chin wa'ne smulnail jin Mam an? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero ma na'cha el yu eb tzet jix yal tet eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jix lawi tu' xin, catu' jix paxtoj naj yetoj eb bey Nazaret tu'. Jijyom c'al jix yute sba tet eb jaxca c'al ta' sbeybal. Jix sc'uba wan ti' ix txutxe yin sna'bal, catu' jix sna'oteneni. ");
INSERT INTO knjNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jal naj Jesús tu' xin, ja'c'ala' ẍ'ib naj, ja'c'ala' ẍ'ib pax sna'bal naj. Caw chi tzala Dios yetoj, c'al chi tzala ánima pax yetoj. ");
INSERT INTO knjNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jolaneb xa jabil c'oli yak'on yaawil naj Tiberio bey Roma. Jaxa naj Poncio Pilato ey oc gobernador bey Judea. Jaxa naj Herodes ey oc gobernador bey Galilea. Ja' naj Felipe, yuẍtaj naj Herodes, ey oc gobernador bey jun lugar chi yij Iturea c'al bey Traconite. Jaxa naj Lisanias ey oc gobernador bey Abilinia. ");
INSERT INTO knjNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ja' yet jun tiempoal tu', ja' naj Anás yetoj naj Caifás ey oc eb yaawil oj yak'omal xaambal eb Israel tet Dios. Jaxa Juan sc'aal naj Zacarías xin, ja' bey cusiltaj tx'otx' ey ec' oj. Ja' yet chi ec' naj titu', jix yalon Dios tet naj tzet oj yal tet eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yuxan jix ec' naj bey masanil wan lugar scawilal ja' Jordán. Jix ec' yalon el xol-laj eb ánima, tol sowalil chi yak' bautizar sba eb yu xeclo el oj tol jix sna' sba sc'ul eb yin spenail, catu' jix ak'le miman c'ulal yiban spenail eb yin junelne yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jix yun jaxca tzet albil can yu jun ẍejab Dios chi yij sbi Isaías, jix yal naj Isaías jaxca ti': Ey jun mac txequel bey jun cusiltaj tx'otx'. Jaxca ti' oj yute yalon yet oj a yaw yin ipal. “Jaxca che yute je wa'nen be yet chi jul junoj yaaw, jaxca tu' che yute je wa'nen je beybal, yutol oj jul naj Kaawil. Je jichlonen el wan be bey oj ec' naj yaaw tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Masanil wan jolquiẍtaj, oj ak'le no oj, catu' oj pananboj el oj. Ja'c'ala' jun jun tzalan c'al jun jun wonan, oj k'ule pananboj. Masanil be cotxquiltaj, oj jichlonele el oj. Yetoj wan jomquiẍtaj, oj mujle oj, catu' oj pananboj. ");
INSERT INTO knjNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Catu' oj yilon masanil eb, tol ey jun colbanile chi yak' Dios,” ẍi bey jun cusiltaj tx'otx' tu', ẍi yul An Juun Tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ey eb ánima jix apni sc'atan naj Juan, yu yak'on bautizar sba eb, pero jix yal naj tet eb jaxca ti': —Jaexti', caw jelan jex jaxca no' laba. ¿Mac jix alon e ex, tol chi ske' je colon el je ba tet jun miman sya'tajil oj jul je yiban yu sjowal sc'ul Dios? ");
INSERT INTO knjNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ta oj je na' je ba yin je penail, sowalil watx' che yute je beybal, yet watx' chi txeclo el oj tol yel jix je na' je ba. Manchej je yal jaxca ti': “c'am tzet che na', yic'aal jon to naj Abraham,” man ojab je chi oj jaxca tu'. Yutol chi wal e ex an, ta chi yal sc'ul Dios, chi ske' yoc wan ch'en ti' yic'aal oj naj Abraham je q'uexel oj. ");
INSERT INTO knjNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ja' jun miman sya'tajil oj jul oj, laan jaxca junoj winaj listo xa ye yetoj yeche yich junoj te'. Masanil te' c'am swatx'il sat chi yak'a, chi tzoc' a oj, catu' chi sk'ojontoj yiban k'ak', ẍi naj Juan tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","—¿Tzet ch'un cu beybalnen jon xin? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—Jaex, ta ey caab oj je camiẍ, che yak' junoj tet junoj mac c'am yet, yetoj ta ey tzet che lo', che yak' nioj tet eb c'am yet, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ey pax jaywan eb tejom el tolabal jix apni sc'atan naj Juan tu', yu yak'on bautizar sba eb. Yet jix apni eb jix sk'anlen eb tet naj jaxca ti': —Jaach cuywawom, ¿tzet ch'un cu wa'nen cu beybal jon xin? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Ja' yet che tejon el tumin yin eb ánima, ja'ta'c'ala' jantaj yalon ley che tej el oj, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ey pax jaywan eb soldado jix apni sk'anlen tet naj jaxca ti': —Jal pax jaonti' jon, ¿tzet ch'un cu beybalnen jon xin? ẍi eb tet naj. —Manchej je xibte eb ánima. Manchej je na' a k'ane yiban eb, catu' che yi'on ec' tzettaj yetal tet eb. Ak' wej tzalaboj je c'ul yetoj je tool che yi' tu', ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ja' eb ánima ey ec' titu', chi yechbane yab eb, yutol chi sna' eb, tejan ja' naj Juan tu', Cristo. ");
INSERT INTO knjNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero jix yal naj tet masanil eb jaxca ti': —Jainti', yel chex wak' bautizar yetoj ja', pero ey jun mac txequel tol toj oj jul oj. Ja' oj jex ak'on bautizar yetoj Santo Espíritu, ma yetoj k'ak'. Ja' jun mac txequel oj jul tu', yel xa c'al miman yel oc apnoj wintaj an. Yuxan man jin moo oj woc yak'omal oj servil, cax c'al yin jin xuyon el x'anil xanab. ");
INSERT INTO knjNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ja' jun mac txequel chi wal tu', laan jaxca junoj mac txequel chi xeye strigo, yu yi'on can el sk'ail ixim xol sbak' ixim. Chi lawi xeyeni, catu' chi yi'ontoj strigo bey sc'uanbal, jal sk'ail ixim chi el can tu' xin, chi slan can toj yiban jun k'ak' c'am chi tani, ẍi naj Juan tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ec'al to c'al wan xa cuybanile jaxca wan ti' jix yal naj Juan tet eb ánima tu', yu yaben eb jun watx' k'ane ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yetoj pax oj jix ak'le tenchanele naj yaaw Herodes yu naj Juan, yutol jix i'le el ix Herodías, yistil yuẍtaj chi yij sbi Felipe yu naj Herodes. Pero man asanne oj jun tu' jix yun naj, pero ey to c'al wan xa spenail jix el yuneni. Yuxan jix tenchanele naj yu naj Juan. ");
INSERT INTO knjNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero ja' naj Herodes tu', c'am nioj jix sjije naj tzet jix yal naj Juan tu', c'al jix yunen xa c'al spenail yel miman, jix oc naj Juan tu' preso yu naj. ");
INSERT INTO knjNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ja' yet junel, yet c'am to chi oc naj Juan yul preso, lalan yak'le bautizar eb ánima jix apni sc'atan naj, catu' jix ak'le pax bautizar naj Jesús yu naj. Ja' yet lalan xali naj Jesús tu', catu' jix jajcha spuertail satcan. ");
INSERT INTO knjNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Catu' jix eyol Santo Espíritu yiban naj, laan yili jaxca junoj no' uch. Jix able yoc k'ane jix al-le eytej satcan, ẍi jaxca ti': —Jaach ton ti', jin c'aal jaach an, chach jin cam c'ulne an. Caw chin tzala ja wetoj an, ẍi. ");
INSERT INTO knjNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Treinta jabil xam naj Jesús, jix c'oli ẍa'on el yich smulna naj yin yet Dios. Ja' naj Jesús tu', sc'aal naj José chi sna' ánima. Ja' ton eb yichmam naj Jesús ti', Elí, ");
INSERT INTO knjNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat, Leví, Melqui, Jana, José, ");
INSERT INTO knjNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatías, Amós, Nahum, Esli, Nagai, ");
INSERT INTO knjNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maat, Matatías, Seméi, José, Judá, ");
INSERT INTO knjNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joana, Resa, Zorobabel, Saltiel, Neri, ");
INSERT INTO knjNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melqui, Adi, Cosam, Elmodam, Er, ");
INSERT INTO knjNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josué, Eliezer, Jorim, Matat, ");
INSERT INTO knjNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví, Simeón, Judá, José, Jonán, Eliaquim, ");
INSERT INTO knjNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea, Mainán, Matata, Natán, ");
INSERT INTO knjNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David, Isaí, Obed, Booz, Salmón, Naazón, ");
INSERT INTO knjNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab, Admin, Aram, Esrom, Fares, Judá, ");
INSERT INTO knjNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacob, Isaac, Abraham, Taré, Nacot, ");
INSERT INTO knjNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug, Ragau, Peleg, Heber, Sala, ");
INSERT INTO knjNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cainán, Arfaxad, Sem, Noé, Lamec, ");
INSERT INTO knjNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matusalén, Enoc, Jared, Mahalaleel, Cainán, ");
INSERT INTO knjNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enós, Set, Adán. Ja' naj Adán ti', ja' Dios jix wa'neni. ");
INSERT INTO knjNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ja' naj Jesús, ey oc Santo Espíritu yin naj sic'lebil. Jix meltzotej bey miman ja' Jordán. Jix i'letoj yu Santo Espíritu tu' bey jun cusiltaj tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cawinaj c'u jix bet ec' titu'. Jix yak'len naj diablo yijban naj yin spenail. C'am nioj tzet jix slo' yet ey ec' titu'. Jix tit swail naj sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yuxan jix yal naj diablo tu' tet naj jaxca ti': —Ta yel tol Sc'aal jaach Dios, al tet jun ch'en ti', tol chi oc lo'beal, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jix yalon Jesús tet naj: —Ja' yul An Juun Tz'ibebil can oj chi alon jaxca ti': “Man asanne oj yu lo'be yuxan iquis jon. Pero chi cu iquisbi pax ec' yu sk'ane Dios,” quey tu' yalon yul An Juun, ẍi Jesús tet naj diablo. ");
INSERT INTO knjNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jix lawi jun tu', catu' jix i'letoj Jesús yu naj bey jun miman wonan. Jix x'oxle masanil wan mimej conob yul yiban k'inal ti' tet Jesús yin jun txolan yu naj. ");
INSERT INTO knjNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Catu' jix yalon naj tet Jesús tu' jaxca ti': —Oj jaach waoc yaawil oj masanil wan mimej conob ti', catu' oj wak' e ach masanil sbe'omal. Ja' masanil wan ti', ey oc yul jin k'ab an, yuxan chi ske' wak'on tet mac chi yal jin c'ul. ");
INSERT INTO knjNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ta chach ey kaan jin sattaj an, catu' cha walon ja ba e in an, oj wak' masanil wan ti' e ach, ẍi naj diablo tet naj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Catu' jix yalon naj Jesús tu' tet naj jaxca ti': —Jaach Satanás, elan jin c'atan an. Yutol chi yal yul An Juun Tz'ibebil can jaxca ti': “Chex ey kaan sattaj Dios Kaawil. Asan Dios che yak' servil, ẍi yul An Juun,” ẍi Jesús tet naj diablo. ");
INSERT INTO knjNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jix lawi jun tu', catu' jix i'le pax toj Jesús yu naj diablo bey conob Jerusalén. Jix yi'on atoj naj bey ẍumuc stemplo Dios. Jix yalon naj tet Jesús jaxca ti': —Ta yel tol Sc'aal jaach Dios, k'oj eytoj ja ba sat tx'otx' tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yutol chi yal can yul An Juun Tz'ibebil can jaxca ti': Oj ẍejtej eb yángel Dios yu ja steyneni. ");
INSERT INTO knjNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Oj jaach ẍa' eb ja wey apnoj yetoj sk'ab, yet watx' man oj yasitoj ja wajan yin ch'en, ẍi yul An Juun tu', ẍi naj diablo tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jix yalon pax Jesús tet naj: —Pero chi yal pax yul An Juun Tz'ibebil can tu' jaxca ti': “Manchej ja wak'len ja wijban ja Dios, Kaawil,” ẍi yul An Juun tu', ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jix lawi jun tu', c'am xa junoj xa porobal jix na'cha yak'on naj diablo tu'. Yuxan jix sbej can naj jun tiempoal. ");
INSERT INTO knjNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jix lawi jun tu', catu' jix paxtoj Jesús bey Galilea, Caw ey c'al oc Santo Espíritu yetoj. Eyman jix abcha sk'umal Jesús bey wan lugar tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jix ec' cuywal bey wan snail sculto eb Israel. Masanil eb ánima jix alon naj watx'il. ");
INSERT INTO knjNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jix lawi jun tu', jix to Jesús. Jix apni bey Nazaret bey jix ch'ibi. Jaxa yet sc'ual xewilal eb Israel, jix oc yul snail sculto eb, jaxca ta' sbeybal. Jix a linan oj yu yawten a An Juun Tz'ibebil can oj. ");
INSERT INTO knjNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jix yak'on eb jun An Juun Tz'ibebil can tet naj, An Tz'ibebil yu jun ẍejab Dios chi yij sbi Isaías. Jix xuyontoj, catu' jix seyon eltej bey chi yal jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ey oc Yespíritu Kaawil win an, yutol ja' jix ak'on wopiso yin walon el watx' k'ane tet eb meba'. Jain jix jin chejletej yu wak'on smimanil sc'ul eb ey scus c'ulal. Chi walon pax tet eb jaxca tol preso yei, tzet utbil chi yun scolcha eb. Chin jajon sat eb c'am chi ske' yilwi. Ja' eb ey oc yalan eb yaaw pena, chin jaj can el eb an. ");
INSERT INTO knjNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Yetoj pax oj, yu walon can el oj tol jix jul stiempoal jun colbanile chi yak' Dios Kaawil, ẍi yul An Juun Tz'ibebil can ti', jix awtele yu naj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jix lawi tu' xin, catu' jix xulun pax can ey An naj. Catu' jix yaon pax toj tet jun mac txequel ey yopiso bey jun snail culto tu'. Jix ey chotan naj Jesús, catu' jix cuywa tet eb. Masanil jantaj eb ey octoj yul snail culto tu', jix oc t'anan yin naj. ");
INSERT INTO knjNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ja' yet jix ẍa'on el yich yaloni, jix yalon tet eb jaxca ti': —Ja' yet jun c'u ti', tol lalan yunen el je sattaj tzet chi yal An Juun Tz'ibebil can ti', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Masanil eb yaman titu' jix al-le naj watx'il yu eb. Jix q'uey a sc'ul eb sic'lebil, yutol caw watx' wan tzet jix yal tet eb. Pero ey eb jix alon jaxca ti': —Ja' jun winaj ti', asan sc'aal naj José ti', ẍi eb yin Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yuxan jix yal Jesús tet eb jaxca ti': —Wotaj tol oj je yal jun q'uetxan k'ane ti' e in an, “Jaach anwam, ante can ja ba yin sbabelal kil on,” tejan je chi. Tejan oj je yal pax jaxca ti': “Chi kab miman tzet jix el ja wunen bey Capernaum. Ute pax bey cu conob ti' kil on,” je chi e in an. ");
INSERT INTO knjNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Caw yel chi wal e ex, c'am junoj ẍejab Dios ey yel oc apnoj yul sat eb yet conob. ");
INSERT INTO knjNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Che na'tej sk'aneal naj Elías yet peyxa, tzet utbil jix yun tu'. Nan scan jabil ma yak' nab. Jix jul jun miman wail yiban masanil ánima. Ja' yet jun tiempoal tu', ec'al eb ix ket Israelal camnaj xa yichamil. ");
INSERT INTO knjNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero manaj tet eb ix jix chejletoj naj Elías colwa oj. Asan tet jun ix man Israel oj, jun ix a Sarepta scawilal conob Sidón, ja' tet ix tu' jix jul ec' colwa oj. ");
INSERT INTO knjNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na' wej pax tej sk'aneal jun xa ẍejab Dios chi yij sbi Eliseo. Ec'al eb ket Israelal jix mi'cha oc yu jun ya'bil chi k'a'toj ánima yu, jun chi yij sbi lepra. Pero c'am junoj eb jix wa'xi can sc'ul yu naj Eliseo tu'. Asan jun naj man Israel oj, Naamán sbi, a Siria naj, asan jun tu' jix wa'xi can sc'ul yu naj Eliseo tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ja' yet jix yaben eb ey octoj yul snail culto tu' wan ti', caw jix tit sjowal eb yin naj. ");
INSERT INTO knjNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yuxan jix a linan eb, jix i'letoj naj yu eb bey sti' conob tu'. Jix apni eb bey sjolom jun wonan spac'anil conob tu', catu' jix yochen eb jix stentoj sat pac'an tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ja' naj Jesús jix el can mocna xol eb, catu' jix toi. ");
INSERT INTO knjNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jix to Jesús bey conob Capernaum, yul yet Galilea. Jix c'oli scuyle eb ánima yet sc'ual xewilal eb Israel yu naj. ");
INSERT INTO knjNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jix q'uey a sc'ul eb yaben wan cuybanile tu', yutol ja' yet lalan sk'anabi, jix txeclo el oj, tol ak'bil yopiso naj yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ey jun winaj ey ec' bey snail sculto eb tu'. Ey oc jun pena espíritu yin. Jix a yaw jun pena espíritu tu' yin ipal, jix yalon jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús a Nazaret, elan cu c'atan, ¿tzet ja walon ja wet kin? ¿Jam yu jon ja wak'on lawoj el oj yuxan chach juli? Wotaj mac jaach txequel. Jaachti', sic'bil jaach el yu Dios, ẍi jun pena espíritu tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jix tzuwa naj yin jun pena espíritu tu': —Tz'in ja chi. Elan yin jun winaj ti', ẍi Jesús tet jun pena espíritu tu'. Eyman jix k'ojle ey naj sat tx'otx' yu jun pena espíritu, catu' jix el yin naj. C'am nioj tzet jix i'on naj. ");
INSERT INTO knjNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jix q'uey a sc'ul masanil eb jix iloni. Catu' jix yalon eb jaxca ti': —¿Tzet la ye wan k'ane jix yal ti'? Ja' jun winaj ti' caw ey yopiso, ey yip ẍejon el eb pena espíritu. Ilala, tol chi el yu naj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eyman jix abcha a sk'umal Jesús xol eb ánima bey wan lugar scawilal tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Catu' jix eltej Jesús yul snail sculto eb tu', catu' jix to bey sna naj Simón. Caw ya' ey ix sni' naj Simón tu' yu k'ak'al ya'bil. Yuxan jix sk'an favor eb tet Jesús yu ix. ");
INSERT INTO knjNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Catu' jix oc linan Jesús tu' sc'atan ix. Jix stenon oc tucan jun k'ak'al ya'bil tu'. Eyman jix sicbi sc'ul ix. Catu' jix a linan ix tu', jix ak'le servil eb yu ix. ");
INSERT INTO knjNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jaxa yet yey c'ualil xin, masanil eb mac txequel ey sya' ey yu yal c'al tzet ya'bilal jix yi'tej eb sc'atan Jesús. Jix batxbatoj sk'ab naj yiban jun jun eb. Catu' jix wa'xi can sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ec'al mac jix i'le can el pena espíritu yin yu naj. Chi a yaw eb pena espíritu tu', chi yalon eb jaxca ti': —Jaachti', Sc'aal jaach Dios, ẍi eb tet Jesús. Pero jix tenchanele eb yu Jesús. Ma cha'le k'anab eb, yutol yotaj eb tol ja' ton Cristo. ");
INSERT INTO knjNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jaxa yet jix sajbi el xin, jix to Jesús tu' xamlaj conob bey c'am ánima. Pero jix to eb ánima seyon ec' oj. Jix apni eb bey ey ec' naj tu', jix c'oli yoc tean eb yin naj tol c'am chi to naj. ");
INSERT INTO knjNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jix yalon naj tet eb jaxca ti': —Sowalil chin ec' wal can el watx' k'ane bey wan xa conob, yet watx' chi yab can oc eb tzet utbil oj yun yoc Dios yin Yaawil oj. Ja' ton yu jun ti' yuxan chejbil jin tej an, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yuxan jix ec' c'al Jesús yal can el sk'ane bey jun jun snail sculto eb yet Israelal bey yul-laj yet Galilea tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ja' yet junel jix to Jesús sti' ja' mar Genesaret. Ec'al mac jix syamba sba yin naj titu'. Caw chi switz'le oc sba eb yin naj, yutol chi yoche eb chi yab sk'ane Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jix yilon Jesús, ey caab barco ey ec' sti' ja' tu'. C'am yaaw te' ey octoj yul, yutol lalan x'a'on wan xim eb chi mitx'on pescado. ");
INSERT INTO knjNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yuxan jix octoj naj yul jun te' yet naj Simón. Catu' jix yalon tet naj, tol chi sjitztoj sba eb nioj xa bey naat yich ja'. Jix lawi tu' xin, jix ey chotan Jesús tu'. Ja' titu' jix cuywatej tet eb ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jix lawi scuywa tet eb xin, catu' jix yalon tet naj Simón tu' jaxca ti': —Cu jitz wej toj cu ba bey naat yich ja'. Ja' titu' oj je yay eytoj je txim mitx'bal pescado ti', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","—Mamin, masanil c'al ak'bal jix kak'le ma'i on, pero ma ki' on. Pero yutol cha wala, oj key eytoj cu txim ti' junel xa, ẍi naj Simón tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ja' yet jix yaon eytoj xim eb tu', man xa jantaj oj no' jix mi'chai. Jix c'oli snic'chatoj yul-laj sat xim eb tu' yu no'. ");
INSERT INTO knjNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jix yak'on sk'ab eb tet wan xa eb yetbi bey jun xa te' barco, yet watx' chi tit eb colwa stok'on atej eb, jix yak'on no te' barco tu' eb scaabil yu no'. Ian chi to te' yich ja' yu yalil no'. ");
INSERT INTO knjNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ja' yet jix yilon naj Simón Pedro jun tu', jix ey kaan sattaj Jesús. Jix yalon tet: —Mamin, c'am mi chach el jin c'atan an, yutol jainti', caw penawom jin an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Quey tu' jix yute yalon jaxca tu', yutol caw jix q'uey a sc'ul naj sic'lebil. Ja'c'ala' eb yetbi yul sbarco naj, caw jix q'uey a sc'ul eb yilon no' pescado tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yetoj pax naj Jacobo c'al naj Juan, eb naj sc'aal naj Zebedeo, eb yetbi naj Simón tu', caw jix q'uey pax a sc'ul eb yiloni. Jix yalon Jesús tet naj Simón jaxca ti': —Manchej jaach xiwi. Jaxca jix ja wute ja mitx'on no' pescado ti', jaxca tu', oj ja wute ja wi'ontej eb ánima e in an, ẍi Jesús tet naj Simón. ");
INSERT INTO knjNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jaxa yet jix apni eb sti' ja' yetoj te' barco tu' xin, jix sbejon can masanil settaj yetal eb. Catu' jix oc tzajan eb yintaj Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ja' yet junel, yet ey ec' Jesús bey jun conob, jix apni jun winaj scawilal Jesús. Caw ya' ey sic'lebil yu jun ya'bil chi k'a'toj ánima yu, lepra sbi. Ja' yet jix yilon yin Jesús naj, jix ey kaan oj, catu' jix ey noan naj sat tx'otx' sattaj Jesús. Jix oc tean naj yin. Jix yalon naj jaxca ti': —Mamin, ta chi yal ja c'ul, chi ske' chin ja wak'on wa'xoj can an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Catu' jix batxban oc sk'ab Jesús yiban naj tu': —Chi yal jin c'ul. Tol chach wak' can wa'xoj, ẍi Jesús tet naj. Jix lawi c'al yalon jun tu', catu' jix taj wan ya'bil tu' yin naj. ");
INSERT INTO knjNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Catu' jix cam yalon Jesús tet naj jaxca ti': —Manchej ja wal tet ánima. Asi' tx'ox ja ba tet naj yak'omal xaambal tet Dios, catu' cha wak'on ja sa'beal tet Dios, jaxca yalon can Moisés. Jaxca tu' oj yun xeclo el oj tol jix jaach wa'xi, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero tol jix el sk'umal Jesús tu' xol ánima. Yuxan ec'al eb jix syamba sba yin Jesús. Chi yoche pax eb chi wa'xi can sc'ul yin tzettaj ya'bilal chi i'on eb. ");
INSERT INTO knjNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero ja' naj Jesús, chi bet c'al bey c'am ánima. Ja' titu' jix bet txaloj. ");
INSERT INTO knjNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ja' yet jun c'ual, jix cuywa Jesús tet eb ánima. Ey wan eb naj fariseo chotan ey titu' yetoj wan eb cuywam yin sley Moisés. Ja' bey jun jun conob yul yet Galilea yetoj yul yet Judea jix tit eb. Ey pax eb jix tit bey Jerusalén. Caw jix x'ox el yipal Dios yin Jesús titu' yet jix yak'on wa'xoj sc'ul eb ya' ey. ");
INSERT INTO knjNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ja' yet lalan scuywa tu', jix apni jaywan winaj, yetbi oc eb jun winaj sicbinaj el smimanil. Batxbil oc yu eb sat batxbal. Chi yoche eb chi octoj yetoj naj yul na, catu' chi stelban ey eb sattaj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero ma ske' yoctoj eb yetoj naj yutol caw nonaj yul na tu' yu ánima. Yuxan jix atoj eb yiban ẍumuc spananil na. Catu' jix sjolontoj eb. Catu' jix yaon eytoj t'unon oj naj eb sat batxbal xol eb ánima. Jix ey apnoj naj sattaj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ja' yet jix yilon Jesús tol jix yaoc sc'ul eb yin, jix yalon Jesús tet naj sicbinaj el smimanil tu' jaxca ti': —Wuẍtaj, tol chi lawi can el ja penail, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ja' eb cuywam yin sley Moisés, c'al eb fariseo, jix sna' eb jaxca ti': “¿Mac txequel jun winaj ti', yuxan chi xem c'ajtza sc'ul Dios? ¿Tumi ey junoj mac chi ske' yak'on miman c'ulal yin cu penail? Asanne Dios,” ẍi eb yul sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero yotaj Jesús tzet lalan sna'on eb. Yuxan jix yal jaxca ti': —¿Tzet yuxan che na' wan ti' jaxca ti'? ");
INSERT INTO knjNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Beytet junoj yel subo yali che na'? Ta cu chi jaxca ti': “Tol jix lawi can ja penail,” ma ja', “aan waan oj, beyan”. ");
INSERT INTO knjNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ja' tinani', oj jin tx'ox el e ex, tol ja' jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, ey wip wak'on can lawoj spenail ánima yul yiban k'inal ti' an, ẍi Jesús tet eb. Jix lawi tu' xin, catu' jix yalon tet naj sicbinaj el smimanil tu' jaxca ti': —Chi wal e ach an, aan waan oj, I' a ja batxbanil ti', paxantoj bey ja na, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yet xa c'al jun txolan tu', jix a waan naj sattaj eb, jix yi'on a sbatxbal naj bey telan ey tu', catu' jix paxtoj naj bey sna. Lalan yalon watx' k'ane naj tet Dios yet lalan sbey naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yuxan caw jix q'uey a sc'ul masanil eb jix ilon tu', jix yalon pax watx' k'ane eb tet Dios tu'. Caw chi xiw pax eb. Yuxan jix yal eb jaxca ti': —Ja' wan tzet yetal lalan kilon wej yet jun c'u ti', c'am to bey chi kil jaxca ti', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jix lawi tu' xin, catu' jix to Jesús. Yet lalan sbeyi jix yilon yin jun tejom el tolabal, Leví sbi naj. Chotan ey naj bey chi tejwi el tolabal tet ánima. —Ocan jin cuywom oj an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jix a linan naj, catu' jix sbejon can masanil settaj yetal. Catu' jix ẍa'on el yich yec' c'al cuywoj yintaj Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ja' naj Leví tu', jix yak' wa'xoj jun miman lo'be bey sna, yet watx' chi low Jesús yetoj. Ec'al eb tejom el tolabal yetoj wan xa ánima jix oc chotan yin smeẍa naj yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero ja' eb fariseo xin, yetoj eb cuywam yin sley Moisés, pena tzet jix yal eb yin eb scuywom Jesús tu'. Jix yalon eb jaxca ti': —¿Tzet yuxan chex low yetoj eb tejom el tolabal c'al yetoj wan xa eb pena sbeybal ti'? ẍi eb tet eb cuywom. ");
INSERT INTO knjNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jix yalon Jesús jaxca ti': —C'am yopiso junoj anwam yu eb watx' sc'ul, asan eb ya' ey, ja' eb tu' ey yopiso yu. ");
INSERT INTO knjNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Man yu oj wawten eb watx' sbeybal an, yuxan jix jin jul an. Pero yu eb pena sbeybal, yet watx' chi sna' sba eb yin spenail, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jix lawi tu' xin, jix yalon eb tet Jesús jaxca ti': —Ja' eb scuywom naj Juan Bautista yetoj eb scuywom eb fariseo, ec'al el chi yijle nocha sba eb catu' chi txali eb. Pero ja' eb ja cuywom jaachti', ¿tzet yuxan, tu' c'al chi low eb catu' chi yuq'uen eb? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jix yalon Jesús tet eb jaxca ti': —K'inaloj ey junoj nupil chi oc tinani'. Ja' eb awtebil bey jun nupil tu', ¿tumi oj ske' tol man oj low eb yet ey ec' naj lalan snupi tu' yetoj eb? ");
INSERT INTO knjNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ja' yet man xa ey oj ec' naj, ja' tu' c'am xa chi low eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Catu' jix yalontej jun xa k'ane tet eb: —C'am junoj jon chi cu lot' el nioj yin junoj cu ac' pichil catu' chi kaon oc snipil oj junoj xil pichile. Ta ey bey quey tu' chi kute xin, chi ketne el an ac' tu'. Yetoj pax oj, man watx' oj yili an xil tu' yu an ac' snipil tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yetoj pax oj, c'am mac chi aon ey vino tol to chi wa'xi yul junoj icham net tz'um, yutol ja' yet chi ch'ib a jun vino tu', chi nic'chatoj no' net tz'um tu' yu. Catu' tu' c'al chi etex el vino tu', c'al no' tz'um tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yuxan, asan yul ac' tz'um chi ey wan vino tol to chi wa'xi tu', yet watx' c'am c'al junoj tu' c'al chi etex el oj. ");
INSERT INTO knjNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yetoj pax oj, ja' mac txequel jix uq'uen vino ey xa swa'xi, c'am chi yoche jun tol to chi wa'xi tu'. Catu' chi yalon jaxca ti': “Ja' wan peyxa tax a, yel watx',” ẍi eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ja' yet jun xewbal c'u yet eb Israel, jix ec' Jesús bey jun be xol wan ixim trigo yetoj eb scuywom. Ja' eb scuywom tu', jix yi' el jayeb sjolom ixim eb, catu' jix sbutxon eltej ixim eb, catu' chi sc'uxun eb. ");
INSERT INTO knjNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Catu' jix sk'anlen el wan eb fariseo tet eb jaxca ti': —¿Tzet yuxan che yun jun tzet yetal chi yal cu ley tol c'am chi ske' yet sc'ual xewilal? ẍi eb tet eb scuywom. ");
INSERT INTO knjNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Catu' jix yalon Jesús tet eb: —¿Tumi c'am to bey che yil tzet chi yal yul An Juun Tz'ibebil can oj, tzet jix yun naj David junel yet peyxa, yet jix tit swail yetoj eb yetbi naj? ");
INSERT INTO knjNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jix octoj eb yul Snail Sley Dios, jix yi'on a ixim pan asan Dios ey yet. Jix lo'on naj yetoj eb yetbi. Ja' wan pan tu', asan eb yak'omal xaambal tet Dios ey sleyal slo'oni, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Catu' jix yalon pax oj: —Jainti', chi ske' walon tzet chi ske' el kunen yet sc'ual xewilal, yutol Ak'bil Wopiso yu Dios xol eb ket animail, ẍi Jesús tet eb fariseo tu': ");
INSERT INTO knjNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ja' yet jun xa sc'ual xewilal, jix octoj Jesús yul jun snail sculto eb yet Israelal. Jix c'oli scuywa snan xol eb. Ey jun winaj sicbinaj el swatx' k'ab, ey ec' naj titu'. ");
INSERT INTO knjNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ja' eb cuywam yin sley Moisés yetoj eb fariseo, jix smaj eb yila ta oj wa'xoj can sk'ab naj tu' yu Jesús yet sc'ual xewilal tu'. Yutol chi yoche eb chi ilcha junoj tzet chi oc spenail oj Jesús, catu' chi buchwa eb yin. ");
INSERT INTO knjNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero yotaj xa Jesús tzet lalan sna'on oc eb yin. Yuxan jix yal tet naj sicbinaj el sk'ab tu' jaxca ti': —Titan jin c'atan an, catu' chach oc linan cu nan on, ẍi Jesús tet naj. Catu' jix a linan naj. ");
INSERT INTO knjNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jix lawi tu' xin, jix yalon Jesús tet eb jaxca ti': —Ey jun tzet yetal oj jin k'anle el e ex an. ¿Beytet junoj ey sleyal kunen yet sc'ual xewilal che na'? ¿Jam tzet watx' chi ske' el kuneni, ma ja' tzet pena? ¿Chim ske' kak'on can wa'xoj sc'ul junoj ya' ey, ma chi ske' kak'on can cam junoj ánima? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jix lawi tu', jix ec' t'anan oj Jesús xol eb joyan oc yin tu'. Jix yalon tet naj jaxca ti': —Bi eltoj ja k'ab, ẍi Jesús tet naj. Jix sbion eltoj sk'ab naj, catu' jix wa'xi can oj. ");
INSERT INTO knjNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero jix tit sjowal wan xa eb. Catu' jix slatinen el sba eb yu tzet oj yute Jesús eb. ");
INSERT INTO knjNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ja' yet jun tiempoal tu', jix to Jesús txaloj bey jun wonan. Jun ak'bal txa c'al jix yun tet Dios titu'. ");
INSERT INTO knjNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Jaxa yet jix k'inibi a yet jun xa c'ual, jix yawtentej eb scuywom tu' sc'atan. Catu' jix sic'on el lacawan xol eb. Catu' jix yaon oc yopiso eb tu' yu yoc eb ẍejab oj. ");
INSERT INTO knjNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ja' sbi eb ti': Simón, naj jix yij pax Pedro yu Jesús, yetoj jun yuẍtaj naj, Andrés sbi, yetoj Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO knjNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, ey jun xa chi yij sbi Jacobo, sc'aal naj Alfeo. Ey jun xa Simón sbi, yetbi sba yetoj eb Cananista yet yalantoj. ");
INSERT INTO knjNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ey jun chi yij sbi Judas, yuẍtaj Jacobo, yetoj pax Judas Iscariote, naj jix aon oc Jesús yul sk'ab camich. ");
INSERT INTO knjNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jix lawi tu' xin, catu' jix eytej Jesús tu' yetoj eb scuywom bey jun wonan tu'. Palan yeyol eb bey jun ac'al. Ec'al ánima jix tit bey wan conoblaj yul yet Judea. Jix apni eb sc'atan Jesús titu'. Ey eb jix tit bey conob Jerusalén. Ey pax eb jix tit bey sti'laj ja' mar, ja' ton bey conob Tiro yetoj bey conob Sidón. Jix apni eb yab tzet chi yal Jesús. Ey eb xin, yu yi'le can el junoj sya'ilal yin eb yu Jesús, yuxan jix apni eb. ");
INSERT INTO knjNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ey eb ey oc pena espíritu yin, jix wa'xi can sc'ul eb yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Masanil eb chi yoche chi oc mitx'an yin Jesús tu', yutol chi wa'xi can sc'ul masanil eb yu yipal Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jix ec' t'anan oj Jesús xol eb scuywom tu', catu' jix yalon tet eb jaxca ti': —Ja' jaex meba' jex ti', watx' je yet, yutol ey oc Dios je Yaawil oj. ");
INSERT INTO knjNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ja' jaex ey je wail ti', watx' je yet, yutol oj no can je c'ul. Ja' jaex chex ok' tinani', watx' je yet, yutol oj jex tzeewoj. ");
INSERT INTO knjNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Jin ya'il oj jain Ak'bil Wopiso yu Dios xol eb ket animail ti', oj chichon oc sc'ul eb ánima je yin, oj jex ujtele el xol eb, catu' oj jex buchle yu eb. Caw c'am swatx'il oj yal eb je yin jin ya'il oj an. Pero ja' yet quey tu' oj jex yute eb tu', caw watx' je yet. ");
INSERT INTO knjNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tzala jon nej yin sic'lebil, yutol ey tzet oj je cha' sq'uexel oj satcan. Jaxca chex utele ti' tinani', quey pax tu' jix utele eb ẍejab Dios yu eb ánima yet peyxa. ");
INSERT INTO knjNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero ja' jaex be'om jex, caw ok'bal jex c'ule, yutol xax je yil swatx'ilal, c'am xa tzet oj je cha' je sattajtoj. ");
INSERT INTO knjNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ja' jaex nonaj je c'ul tinani', caw ok'bal jex c'ule, yutol oj jul jun tiempoal oj je yab je yak'on wail. Ja' jaex chex tzee tinani', caw ok'bal jex c'ule, yutol oj jex ok' yu cus c'ulal. ");
INSERT INTO knjNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ja' yet watx' jex yalon eb ánima, caw ok'bal jex c'ule, yutol quey tu' jix utele eb jix tz'aj yal oc sba ẍejab oj Dios yu eb ánima yet peyxa tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Chi wal e ex mac jex lalan je yaben tzet chi wal an, cam c'ulne eb je cajat, ak' wej watx' c'ulal tet eb chi chichon oc sc'ul je yin. ");
INSERT INTO knjNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ja' eb chi k'anontej sjowal sc'ul Dios je yiban, ja' ojab swatx' c'ulal Dios che k'antej yiban eb. Chex txali yin eb chex buchoni. ");
INSERT INTO knjNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ta ey mac chi mak'ontoj jun pac' je ti', che jacbatoj jun pac' xa. Ta ey mac chi tok'on ec' ja chumpa, jaj can toj je camiẍ pax yetoj. ");
INSERT INTO knjNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yal c'al mac chi k'anon junoj tzet yetal e ex, ak' wej tet. Ja' eb chi i'on ec' junoj je tzet yetal, manchej je k'an meltzo tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Watx' ojab che yute je ba tet eb je yet animail, yutol chex tzalai yet watx' chi yute sba eb e ex. ");
INSERT INTO knjNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ta asanne eb chex cam c'ulneni, ta ja' c'al ch'an eb che cam c'ulne pax oj, ¿ta watx' jaxca tu' che na'? Quey pax tu' chi yun eb penawom. ");
INSERT INTO knjNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yetoj pax oj, ta asan tet eb watx' chi yute sba e ex, watx' che yute je ba, ¿ta watx' jaxca tu' che na' xin? Quey pax tu' chi yun eb penawom. ");
INSERT INTO knjNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ta asan mac tet chi ak'on meltzo je tzettaj yetal che na' yet chi xew smaaneni, ta asan tet che yak' maanil, ¿ta watx' jaxca tu' che na'? Chi yak' pax eb penawom junoj settaj yetal maanil tet eb yet penawomal, yutol chi sna' eb tol oj ẍa' eb junel xa. ");
INSERT INTO knjNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero jaexti' xin, cam c'ulne wej eb je cajat. Ak' wej c'al watx' c'ulal. Ja' yet che yak'on junoj tzet yetal maanil, c'am che na' tol oj je cha' junel xa. Ta che yun jaxca tu', caw miman tzet oj je cha' sq'uexel oj satcan, catu' chi txeclo pax el oj tol yuninal jex xa pax Dios miman yel oc apnoj. Ilala, chi x'ox swatx' c'ulal Dios tet eb penawom, eb c'am chi yal nioj yu diosalil yu tzet chi ẍa' eb tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ok' ojab je c'ul yin eb je yet animail, jaxca chi yun yok' sc'ul cu Mam Dios je yin. ");
INSERT INTO knjNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Manchej je na' oc yin junoj xa mac txequel, yet watx' man oj na'le oc je yin yu Dios. Man comon oj che yal tol ey spenail junoj mac txequel, yet watx' c'am chi yal Dios tol ey je penail pax oj. Jo' wej q'uey sjowal je c'ul yin je yet animail, catu' oj sjo'on q'uey sjowal sc'ul Dios je yiban. ");
INSERT INTO knjNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ak' wej tet je yet animail. Ta quey tu' oj je yute, oj yak' pax Dios e ex. Jaxca junoj tzet yetal tz'ajan chi yun yechelei, teq'ueq'ui chi noi, bululi chi yune', c'am xa chi ske' spixle sti' snetal, quey tu' oj yute yak'on Dios tzettaj yetal e ex. Jaxca che yute je yak'on tet eb je yet animail, quey tu' oj yute yak'on pax Dios e ex. ");
INSERT INTO knjNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","K'inaloj ta ey junoj mac c'am chi ske' yiloni, ta chi quetz'letoj yu junoj xa c'am chi ske' yiloni. Chi stok'letoj sba eb scawanil sat pac'an. ");
INSERT INTO knjNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","C'am junoj cuywom ec'ban yel oc apnoj yintaj scuywam. Pero ja' yet chi lawi scuywi, laan xa jaxca scuywam tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","K'inaloj ta junoj ja wet animail chi to sc'ail te' yul sat. Cha woche cha wi' eltej jun sc'ail te' tu', pero ey pax jun miman te' ey octoj yul ja sat. ");
INSERT INTO knjNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Cha wal tet, “wuẍtaj, chi ske' wi'on eltej jun sc'ail te' yul ja sat,” ja chi tet. ¿Pero tumi c'am cha wil jun miman te' yul ja sat? Ta quey tu' cha wute ja walon xin, caw caab sat jaach. Sowalil cha wi' can eltej jun miman te' yul ja sat babel, catu' chi ske' ja wi'on eltej jun sc'ail te' yul sat ja wet animail tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","K'inaloj ta ey te' te' watx', man pena oj sat chi yak'a. Ja'c'ala' pax te' pena, c'am pax sat te' watx' chi yak'a. ");
INSERT INTO knjNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yu sat jun jun te' chi yak'a, yuxan chi kotajne el tzet te'al te'. K'inaloj junoj te' q'uix tinani', man mansan oj sat chi yak'a. K'inaloj pax junoj ste'al tulus tinani', man tzoyol oj sat chi yak'a. ");
INSERT INTO knjNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ja' mac watx' sna'bal, watx' tzet chi yala, yutol asan tzet yetal watx' ey bey spixan eb. Jal pax eb pena sna'bal xin, pena tzet chi yal eb, yutol asan tzet yetal pena ey bey spixan eb. Yutol ja' tzet ey bey cu pixan, ja' chi kala. ");
INSERT INTO knjNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Tzet yuxan, “Mamin, Mamin” je chi e in an, pero c'am che jije pax tzet chi wal an? ");
INSERT INTO knjNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Oj waltej e ex tzet oj yun yel oc eb chi jijen tzet chi wal an, yet chi yaben eb. ");
INSERT INTO knjNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Laan oj yun yel oc eb jaxca junoj winaj chi swa'ne sna. Chi sculon tx'otx' masanta' c'al chi mitx'a ch'en ch'en, catu' chi yaon ey xe' sna tu'. Chi lawi swa'xi yu naj xin, chi c'oli yec' elom ja' yinlaj, chi a sjowal ja', chi smak'on oc sba ja' yin. Pero c'am c'al nioj chi bilwi jun na tu' yutol caw watx' ye xe' yiban ch'en tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero ja' eb c'am chi jijen pax tzet chi wal an, laan eb jaxca junoj mac txequel, tu' c'al chi ya a sna sat tx'otx'. C'am xe' chi ey xol tx'otx'. Chi lawi swa'xi tu', chi c'oli yec' elom ja' yinlaj jun na tu', chi a sjowal ja', chi smak'on oc sba ja' yin. Eyman chi telc'o jun na tu', catu' chi etextoj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ja' yet jix lawi sk'anab Jesús tet eb ánima, jix to bey Capernaum. ");
INSERT INTO knjNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ja' titu' ey jun naj scapitán eb soldado, a Roma naj. Ey jun smoso naj caw xaan yu naj sic'lebil. Pero ya' ey, tuxa chi cam naj. ");
INSERT INTO knjNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ja' yet jix able sk'umal Jesús, jix ẍejontoj jaywan eb winaj ey yopiso xol eb Israel. Jix bet sk'anon favor eb tet Jesús tu', tol chi to ak'le wa'xoj sc'ul naj smoso naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ja' yet jix apni eb sc'atan Jesús, jix oc tean eb yin Jesús, jix yalon eb tet naj jaxca ti': —Ja' jun naj capitán tu', smoo chach colwa tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yutol caw ey scam c'ulal naj kin, jaon Israel jon ti'. Jix yak' wa'xoj jun na naj bey chi kak' culto, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jix to Jesús yetoj eb. Pero txenxane yapni eb bey sna tu', jix ẍejon jaywan eb yamigo naj capitán tu' sc'atan Jesús tu'. Jix yalon eb jaxca ti' tet Jesús: —Ẍi naj e ach jaxca ti': “Mamin, manchej ja wetne ja ba ja jul jin c'atan an, yutol man jin moo oj chach octoj yul jin na. ");
INSERT INTO knjNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yuxan ma jin toj wal e ach yu naj jin moso ti'. Asanne ojab tol cha waltej tol chi wa'xi can naj, catu' chi wa'xi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ila jainti', ey eb waawil chin chejon an. Ja'c'ala' ey pax eb soldado chin cheja. Ta ey junoj mac chin cheja, chi c'al sjije stoi. Ta ey mac chi wawte, chi c'al sjije sjuli. Yetoj pax oj, ta ey tzet chin chej swa'ne junoj jin moso an, chi c'al sjije swa'neni. Yuxan, wotaj an, jaxca chi wute jin chejon eb tu', quey pax tu' chi ske' ja walon masanil tzet yetal jaachti',” ẍi naj capitán tu', ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ja' yet jix yaben Jesús jaxca tu', caw jix q'uey a sc'ul yabeni. Catu' jix oc t'anan yin eb ánima tzajan yintaj tu'. Jix yalon tet eb jaxca ti': —Caw yel chi wal e ex, c'am to junoj a Israel chi wil yaon oc sc'ul yin Dios jaxca jun winaj ti', ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ja' yet jix apni eb ẍejab bey sna tu' xin, jix yilon eb tol xax wa'xi sc'ul naj smoso naj tu' yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jix lawi tu' xin, jix to Jesús tu' bey jun conob Naín sbi yetoj eb scuywom. Ec'al ánima jix oc tzajan yintaj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ja' yet lalan yapni eb scawilal jun conob tu', jix yil eb tol ey jun camom lalan sto mujlei. Ec'al eb a conob titu' tzajan oc yintaj. Ja' naj jix cam tu', jun ch'an naj yu xutx, camnaj xa yichamil ix txutxe tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ja' yet jix yilon oc naj Kaawil yin ix txutxe tu', jix ok' sc'ul naj yin ix. —Manchej jaach ok'i, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Catu' jix sjitzontoj sba Jesús sc'atan sca'ail naj camom tu'. Jix oc mitx'an yin sbatxbanil naj tu'. Jix oc linan eb batxnen oc tu'. Catu' jix yalon Jesús tet naj camnaj xa tu' jaxca ti': —Cha ach'e, chi wal e ach, aan waan oj, ẍi Jesús tet naj camnaj xa tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Catu' jix a chotan naj camnaj tu'. Jix c'oli sk'anab a naj, catu' jix aletoj naj tet xutx yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ja' yet jix yilon eb ánima jun ti', caw jix xiw a eb smasanil. Jix yalon watx' k'ane tet Dios: —Ja' jun ẍejab Dios jix ẍejtej cu xol wej ti', caw miman yel oc apnoj, ẍi eb. Jix yalon pax eb jaxca ti': —Caw jix jul Dios colwa kin, jaon sconob Dios jon ti', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ja' jun tzet jix el yunen Jesús, eyman jix abcha yul-laj Judea tu', yetoj bey wan xa conoblaj scawilal tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ja' eb scuywom Juan Bautista jix bet alon tet naj, jantaj tzet jix el yunen Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yuxan jix yawtetej cawan eb scuywom. Catu' jix ẍejontoj eb sc'atan Jesús tu', yu sk'anlen eb ta ja' Jesús tu', ja' jun lalan yechbanen sjul eb ma ey jun xa chi yechbane sjul eb xin. ");
INSERT INTO knjNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yuxan, ja' yet jix apni eb sc'atan Jesús jix yalon eb jaxca ti' tet Jesús: —Ja' naj Juan Bautista jix cu chejontej e ach ti' on, yu cu k'anle e ach ta jaach Cristo jaach, ta jaach lalan jaach kechbanen ja jul on, ma ey junoj xa chi kechbane sjul on xin, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ja' yet jix sk'anlen eb tu', caw ey eb ya' ey yu yal c'al tzet sya'ilal, c'al eb ey oc pena espíritu yin jix wa'xi can sc'ul eb yu Jesús. Ec'al pax eb c'am chi ske' yilwani jix wa'xi can sat yu. ");
INSERT INTO knjNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yuxan jix yal naj Jesús tet eb ẍejab naj Juan tu' jaxca ti': —Paxan nej toj bey naj Juan tu'. Che yal tet naj tzetal jix je yabe, c'al tzetal jix je yil titi'. Che yal tet naj tol ey eb c'am ta' chi ilwi, pero jix ilwi can a eb tinani'. Yetoj pax eb coxo' jix bey a eb. Ja' eb ey oc lepra yin, jix wa'xi can eb, c'al eb c'am chi yabe, jix yab can a eb. Ey eb camnaj xa jix pitzc'u can a oj. Lalan yaben watx' k'ane yet colbanile eb meba'. ");
INSERT INTO knjNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Caw watx' yet eb c'am chi somcha can el sc'ul win an. Quey tu' che yute je yalon tet naj Juan tu' yet oj jex apnoj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ja' yet jix lawi spax can toj eb chejabwom tu', jix yalontej Jesús yu naj Juan tu' tet ánima jaxca ti': —Na' wej tej, tzet jix bet je yil bey cusiltaj tx'otx' tu'. ¿Jam junoj te' a chi bilwi yu ka'e' jix bet je yila? ");
INSERT INTO knjNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Tzet jix bet je yil xin? ¿Ma ja' junoj winaj watx' spichil jix bet je yila? Je yotaj tol ja' eb watx' spichil tu', c'al eb miman tzet yetal ey tet, ja' bey sna eb yaaw ey ec' eb. ");
INSERT INTO knjNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ta manaj wan tu' xin, ¿Tzet jix bet je yila? ¿Ma ja' junoj yalomal el sk'ane Dios jix bet je yila? Yalomal ton el sk'ane Dios jun jix bet je yil tu'. Yutol ja' naj Juan tu', yel miman yel oc apnoj, ");
INSERT INTO knjNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","yutol ja' ton sk'aneal naj Juan ti', yalnaj can Dios yul An Juun Tz'ibebil can oj, bey chi yal jaxca ti': Oj jin chejtej jun jin chejab, oj baboj to ja sattaj jaxca chi yun swa'nen junoj be, jaxca tu', oj yute swa'nen sbeybal eb ánima yu, yet c'am to chach juli, ẍi yul An Juun. ");
INSERT INTO knjNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Chi wal e ex tol ja' xol ánima yul yiban k'inal ti', c'am junoj mac txequel ec'ban yel oc apnoj yintaj Juan Bautista tu'. Pero ja' eb ey oc Dios Yaawil oj, yel ec'ban swatx'il yet eb yintaj naj Juan tu', cax c'al c'am yel oc apnoj eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ja' yet jix yaben eb ánima yetoj eb tejom el tumin tzet jix yala, jix yalon eb tol caw watx' Dios, yutol jix yak' ak'le bautizar sba eb yu naj Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Jal pax eb fariseo yetoj eb cuywam yin sley Moisés, ma ak'le bautizar eb yu naj Juan tu'. Jaxca ti' jix yute x'oxon el oj tol ja' tzet chi yoche Dios yin eb, c'am nioj yel oc apnoj yul sat eb. ");
INSERT INTO knjNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jix yalon naj Kaawil tet eb ánima ey ec' titu' jaxca ti': —Ja' eb ánima yet jun tiempoal ti', oj waltej e ex tzet utbil ye sna'bal eb. ");
INSERT INTO knjNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Laan eb jaxca unin tu' c'al chi ec'ab txombal. Ey la eb chi yal tet wanoj xa yet uninal jaxca ti': “na'ba c'al jix ketne cu ba cu sonle je yu, pero ma c'al jex canalwoj pax oj. Yetoj pax oj na'ba c'al jix cu bit'ne wan bit' caw cusiltaj xa c'al yoqui, pero ma c'al jex ok' pax ketoj,” ẍi eb. Jaxca eb unin c'am chi sajchi tu', quey tu' eb ánima chi wal ti' an. ");
INSERT INTO knjNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yutol beybalnebil yu naj Juan tol c'am chi lowi, c'am chi yuc' vino. Yuxan jaex che yala, tol ey jun pena espíritu chi etnen naj. ");
INSERT INTO knjNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ja' yet jix jin jul xin, jain Ak'bil Wopiso yu Dios xol eb ket animail ti'. Jainti' chin lowi, chi wuq'ue. Pero jaex che yal jaxca ti' win an: “Ja' naj Jesús tu', lo' c'al chi yoche chi yune', chi uc'wi pax vino. Yamigo sba naj yetoj eb tejom el tolabal, c'al yetoj wan xa eb pena sbeybal,” je chi win an. ");
INSERT INTO knjNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero ja' eb ey oc sjelanil Dios yin, chi txeclo el yin eb yu tzet chi el yuneni, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ja' yet junel, ey jun naj fariseo jix awten Jesús low bey sna. Jix lawi yapni, catu' jix ey chotan Jesús low yetoj naj. ");
INSERT INTO knjNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pero ey jun ix a conob titu' caw pena sbeybal. Jix yab sk'umal ix tol jix apni Jesús low bey sna naj fariseo tu'. Catu' jix to ix titu'. Jix yi'toj jun alabastro limeta nonaj yu jun ambal suk'uk'i xa c'al yec' sab. ");
INSERT INTO knjNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jix apni kaan ix scawilal Jesús. Jix c'oli yok' ix. Catu' jix x'a'on el yajan Jesús tu' yetoj yal sat ix. Jix lawi c'al tu' xin, jix sjo'on taj yajan naj yetoj xil ya' ix, catu' jix tz'uble el yajan Jesús yu ix. Jix stobon oc ix jun ambal suk'uk'i sab tu' yin yajan naj. ");
INSERT INTO knjNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ja' yet jix yilon naj fariseo jun tu', jix sna'on naj jaxca ti': “ta yel ẍejab Dios jun winaj ti', chim na'cha el yu tzet ixal jun chi mitx'on yajan ti'. Chim na'cha pax el yu naj tzet utbil ye oc ix, tol pena sbeybal ix ti',” ẍi naj yul sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Catu' jix yalon Jesús tu' tet naj jaxca ti': —Simón, ey nioj tzet chi woche chi wal e ach an, ẍi Jesús tet naj. —Ala jaach cuywam tzet chi yoche ja c'ul cha wal e in an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—K'inaloj ta ey cawanoj winaj ey sjec' tet spatrón tinani'. Ta quinientos quetzales sjec' junoj, jal junoj xa xin cincuenta quetzalne sjec'. ");
INSERT INTO knjNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero k'inaloj ta c'am bey chi ske' chi yi' ch'en eb. Catu' tu' c'al chi jo'le q'uey sjec' eb yiban yu naj. ¿Mac junoj yel chi cam el sc'ul yin naj spatrón tu' cha na'? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Ja' chin na' jainti' an, ja' naj yel miman sjec' chi jo'le q'uey yiban yu naj tu', ja' naj tu' yel miman chi cam c'ulnen naj, ẍi naj Simón tu' tet Jesús. —Yel ton cha wala, ja' ton naj, ẍi Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jix lawi tu' xin, jix oc t'anan Jesús yin ix tu', catu' jix yalon naj tet Simón tu' jaxca ti': —Ja' yet jix jin jul yul ja na ti', ma ja wak' nioj wa' x'a'il oj wajan an, pero jun ix ti', jix x'a' el wajan yetoj yal sat. Catu' jix sjo'on taj wajan ix yetoj xil ya'. ");
INSERT INTO knjNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma ja tz'ub el jin ti' yu ja tx'oxon el ja cam c'ulal. Pero jun ix ti', yechel tax jin jul titi', c'am c'al chi sbej tz'ubon el wajan an. ");
INSERT INTO knjNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","C'am nioj yanil jin jolom jix atoj. Pero jun ix ti', jix stob oc jun ambal suk'uk'i xa c'al sab yin wajan ti' an. ");
INSERT INTO knjNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yuxan chi wal e ach, caw miman scam c'ulal jun ix ti', yutol caw miman spenail jix jo'le q'uey yiban ix. Jal pax mac nian ch'an spenail chi jo'le q'uey yiban xin, nian ch'an scam c'ulal chi x'oxo, ẍi Jesús tet naj Simón tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jix lawi tu' xin, jix yalon Jesús tet ix jaxca ti': —Tol chi lawi can ja penail wu an, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Catu' jix c'oli yalon jaywan xa eb chotan ey yetoj Jesús tu' jaxca ti': —¿Bey jix tit oc yip jun winaj ti'? Ilala, chi ske' sjo'on can q'uey cu penail, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Catu' jix yalon tet ix tu' jaxca ti': —Jix jaach colchai, yutol jix ja waoc ja c'ul win an. Yuxan, paxan yin tzala c'ulal, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jix lawi tu' xin, ec'al wan conoblaj c'al wan aldealaj bey jix ec'ab Jesús. Yet jix ec' yalon can el sk'ane Dios xol-laj ánima, jix ec' yal can el watx' k'ane xol-laj eb, tzet utbil chi yun yoc Dios yin Yaawil oj eb. Ja' eb lacawan ẍejab jix ec' yetoj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ey wan eb ix i'bil el pena espíritu yin eb ix yu Jesús, c'al wan xa eb ix jix wa'xi can sc'ul yu. Ja' eb ix jix to yetoj naj. Ey oc María, chi yij pax sbi Magdalena xol eb. Ja' ix bey jix el can jujwan pena espíritu yin yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ey jun ix chi yij sbi Juana, ix yistil naj scaporal Herodes, chi yij sbi naj yin Chuza. Ey pax jun ix chi yij sbi Susana, yetoj jaywan xa eb ix chi colwa eb yin Jesús yetoj set yetal eb. ");
INSERT INTO knjNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Caw ey ánima jix tit bey jun jun conob yu yilon Jesús. Ja' yet jix syamban sba eb, jix yalontej Jesús jun k'aneal ti' tet eb, jix yalon jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Ey jun winaj jix to txi'o trigo. Ja' yet lalan txi'on ey ixim tu', catu' ey wan chi ey q'uey can yul be. Ja' ixim tu', tu' c'al jix tec'letoj ixim. Catu' jix ec' sic'le a ixim yu no' tz'quin. ");
INSERT INTO knjNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ey ixim xin, yibanlaj saam ch'en jix apni can ixim. Ja' yet jix aol ixim, eyman jix taj el oj, yutol man ch'acan oj tx'otx' tx'otx' yiban ch'en saam ch'en tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ey ixim jix apni can xol q'uix. Tu' c'al jix q'uey a ixim xol an yet jix ch'ib a an q'uix. ");
INSERT INTO knjNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ey pax ixim jix apni can bey yax tx'otx'. Ja' yet jix ch'ib a ixim, jix ch'ib a masanta' c'al ey sjolom ixim ciento sbak' jun jun, ẍi Jesús tet eb. Ja' yet jix lawi yalontej jun sk'aneal ti', catu' jix yalon yin ipal jaxca ti': —Ja' wan tzet che yab ti', na' wej tej sic'lebil, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jix sk'anlen el eb scuywom tu' tet Jesús, tzet yel oc apnoj jun k'aneal tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jix yalon tet eb jaxca ti': —Lalan x'oxon Dios e ex wan tzet c'am mac otajnen ti', yet watx' chi na'cha el je yu tzet utbil ye oc Dios yin Yaawil oj. Jal tet wan xa ánima xin, asan wan sk'aneal yet tx'oxbanile chi waltoj tet eb. Yuxan, cax c'al chi yil eb junoj tzet yetal, pero chi can can eb jaxca tol c'am tzet chi yil eb. Yetoj pax oj, cax c'al chi yab eb, pero c'am nioj chi na'cha el yu eb. ");
INSERT INTO knjNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Oj wal e ex tzet chi yal yel oc apnoj jun k'aneal jix wal ti' an. Ja' ixim jinat tu', yechel sk'ane Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ja' ixim jinat jix apni can oc yul be, yechel eb ánima chi xew yaben sk'ane Dios catu' chi jul naj diablo yin. Chi jul yi'on el sk'ane Dios naj yin spixan, yet watx' c'am chi yaoc sc'ul eb yin, catu' c'am chi colcha eb yu. ");
INSERT INTO knjNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ja' ixim jinat jix apni can oc yiban ch'en saam ch'en, yechel eb ánima chi cha'on aben sk'ane Dios yin tzala c'ulalil. Pero c'am stec'anil eb, txenne tiempo chi yaoc sc'ul eb yin. Yutol ja' yet chi jul junoj porobal yiban eb, yin jun txolan chi meltzo eb yintaj junel xa. ");
INSERT INTO knjNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ja' ixim jix apni can oc xol q'uix, yechel eb chi aben sk'ane Dios, pero ja' yet chi bey c'al toj tiempo, miman tzet chi sna' eb. Chi sna' eb sbe'omal. Chi sna' eb yet smimanil. Yu wan tu', chi etex el sna'bal eb. Laan chi yun yel oc eb jaxca ixim trigo c'am chi wa'xi sjolom. ");
INSERT INTO knjNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jal pax ixim jix ey q'uey bey yax tx'otx' xin, yechel eb chi cha'on aben sk'ane Dios yin masanil sc'ul. Junelne chi yaoc eb yin sc'ul. Tec'an chi yute sba eb. Yuxan laan eb jaxca ixim trigo ec'al sbak' chi yak'a. ");
INSERT INTO knjNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ja' yet chi kaon oc cu cantin, c'am chi cu noba oc junoj tzet yetal yiban, catu' c'am chi ka pax octoj yalan tx'at. Pero ja' yiban junoj tzet yetal naat ey a oj, ja' titu' chi cu batxba atoj, yet watx' chi yil yajan eb jantaj eb chi octoj yul na. ");
INSERT INTO knjNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jantaj tzet ewan c'uan ye tinani', oj txeclo c'al ta' a oj. Yetoj jantaj tzet c'ubabil el tinani', oj ak'le otajnele el oj, masanil oj abcha oj. ");
INSERT INTO knjNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yuxan chi cam je yaben tzet chi wal an. Yutol ja' mac chi yoche chi na'cha el yu, oj ak'le na'cha el yu eb. Jal eb c'am chi yoche chi na'cha el wan ti' yu xin, ja' nioj tzet ian chi na'cha el yu eb, oj i'le xa c'al ec' tet eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ja' ix xutx Jesús yetoj c'al eb yuẍtaj, jix apni eb bey ey ec' oj. Pero ma ske' yoctoj eb bey ey ec' naj tu', yutol witz'an yu ánima. ");
INSERT INTO knjNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yuxan, ey jun jix alon tet Jesús jaxca ti': —Jix jul ja txutx yetoj eb ja wuẍtaj sti' na. Tol ab chi yoche eb chi k'anab ja wetoj, ẍi eb, ẍi jun tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jix yalon Jesús tet eb ey ec' titu' jaxca ti': —Yal c'al mac chi aben sk'ane Dios, ta chi sjije, ja' ton eb tu' jaxca tol jin txutx ye, jaxca tol wuẍtaj ye, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ja' yet junel, jix oc Jesús yul jun barco yetoj eb scuywom. Catu' jix yalon tet eb jaxca ti': —Toon nej bey jun xa sk'axepal ja', ẍi Jesús tet eb. Catu' jix to eb. ");
INSERT INTO knjNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ja' yet lalan sto eb tu', jix wey a Jesús. Pero eyman jix jul jun ka'e' caw jow sic'lebil. Jix c'oli yak' pululoj ja'. Jix oc ja' yul te' yu. Ian jix pax ey te' yich ja'. ");
INSERT INTO knjNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jix stenon el sweyan Jesús eb: —Mamin, Mamin, tol chi cu pax ey yich ja', ẍi eb tet Jesús. Jix a linan naj tu'. Jix stenon oc tucan jun ka'e' tu', c'al ja' mar tu'. Catu' jix sjijen yoc tucan oj, tz'inini xa c'al. ");
INSERT INTO knjNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jix lawi tu' xin, jix yalon Jesús tet eb scuywom tu' jaxca ti': —¿Tzet yuxan c'am che yaoc je c'ul yin Dios? ẍi Jesús tet eb. Pero tu' c'al jix q'uey a sc'ul eb yu sic'lebil. Catu' jix yalon eb jaxca ti': —¿Tzet la ye jun winaj ti'? Ila chi yak' mandar ka'e' yetoj ja' mar, catu' chi sjijen tet, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jix lawi jun tu', jix ec' apnoj eb sk'axepal ja' bey yul yet Gadara, bey spac'anil Galilea. ");
INSERT INTO knjNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ja' yet jix apni Jesús sti' ja', ey jun winaj a conob titu' jix apni sc'atan Jesús, ey xa tiempo yoc wan pena espíritu yin. C'am xa chi yaoc spichil naj. C'am xa chi yal sc'ul chi ey ec' bey junoj na. Asan bey camposanto ey ec' oj. ");
INSERT INTO knjNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ja' yet jix yilon yin Jesús naj, jix ey kaan naj yajantaj naj. Catu' jix yalon Jesús tu' tet wan pena espíritu yin naj tu' tol chi el eb yin naj. Catu' jix a yaw naj, jix yalon naj jaxca ti': —Jaach Jesús, Sc'aal jaach Dios, yel xa c'al miman yel oc apnoj. ¿Tzet ja walon ja wet win an? Chin k'anon e ach, man chin ja wetne, ẍi naj tet Jesús tu'. Ec'al el chi mitx'a naj yu pena espíritu tu'. Yuxan chi pixle ey naj yetoj cadena yu ánima, chi oc ch'en yin yajan c'al yin sk'ab. Chi pix ey eb yet watx' c'am chi mak' cam sba naj. Pero chi c'al nic'chatoj wan cadena tu' yu naj. Chi i'le bey naj yu wan pena espíritu tu' bey cusiltaj tx'otx'laj. ");
INSERT INTO knjNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jix sk'anle Jesús tet naj jaxca ti': —¿Tzet ja bi? ẍi Jesús tet naj. —Legión jin bi, ẍi naj. Quey tu' jix yute yalon naj jaxca ti', yutol ec'al pena espíritu ey oc yin naj. ");
INSERT INTO knjNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Catu' jix sk'anon favor eb pena espíritu tet Jesús tol manchej aletoj eb bey xab c'am yich. ");
INSERT INTO knjNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ja' bey spac'anil jun witz' bey ey ec' eb titu', ey wan no' txitam lalan slowi. Yuxan jix sk'anon eb pena espíritu tu' tet Jesús, tol chi jajle can to eb yin no' txitam tu'. Jix jajle can toj eb yin no' yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yuxan jix el can eb yin jun naj tu'. Ja' yin no' txitam jix to can eb. Yuxan jix el no' sat pac'an tu', catu' jix ey apnoj no' xol ja' mar. Jix jik'wi eytoj masanil no' xol ja' tu', catu' jix cam no'. ");
INSERT INTO knjNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ja' yet jix yilon eb yilomal no' tu' tzet jix yun no', caw jix xiw can a eb sic'lebil. Jix to eb yalon el xol conob, c'al bey yinlaj conob tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yuxan jix tit ánima yilon jun tzet jix yun tu'. Ja' yet jix apni eb bey ey ec' Jesús tu', jix yilon eb, tol chotan ey naj bey jix el eb pena espíritu tu'. Ey xa oc spichil naj. Watx' xa sc'ul naj ey oc pena espíritu yin tu'. Yuxan jix xiw a eb sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ja' eb jix ilon jun tzet jix el yunen Jesús tu', ja' eb jix alon tet wan xa eb jix apni ilon tu', tzet jix yun swa'xi sc'ul naj bey jix el eb pena espíritu tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yuxan, ja' masanil ánima yul yet Gadara tu', jix sk'anle eb tet Jesús, tol chi sbos el sba naj yul slugar eb, yutol caw chi xiw eb. Catu' jix octoj naj yul te' barco tu' yu spaxtoj. ");
INSERT INTO knjNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ja' naj bey jix el can eb pena espíritu tu', jix sk'an oc tzajan sba naj yintaj Jesús. Pero ma cha'le toj naj. Jix yal Jesús tet naj jaxca ti', tol chi can naj bey jun lugar tu': ");
INSERT INTO knjNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Paxan bey ja na. Cha wala jantaj tzet jix el yunen Dios ja win, ẍi Jesús tet naj. Jix to can naj tu' xin. Jix yal naj tet masanil eb yul jun conob tu' tzet jix el yunen Jesús yin naj. ");
INSERT INTO knjNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yet jix pax ec' Jesús bey jun xa sk'axepal ja' bey jix tita. Ja' yet jix ec' apnoj tu', jix tzala masanil eb ánima titu' yutol caw echbanebil xa c'al Jesús yu eb. ");
INSERT INTO knjNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ey jun naj yaawil snail sculto eb Israel titu', Jairo sbi naj. Jix apni sc'atan Jesús, catu' jix ey kaan yajantaj. Jix sk'anon favor tet Jesús tu', tol chi to yetoj bey sna. ");
INSERT INTO knjNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yutol ja' jun q'uetxan scutz'in, tuxa chi cam ix. Ey mi lacaweb oj jabil sk'inal ix scutz'in naj tu'. Ja' yet jix to Jesús yetoj naj bey sna tu', ec'al ánima jix to yetoj. Chi switz'le xa c'al sba eb stobululoj yetoj. ");
INSERT INTO knjNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ja' xol eb ánima tu', ey jun ix ix ey xam lacaweb oj jabil ian c'al chi cam ix yu s'ilal ix chi eyi. Jix lawi el masanil settaj yetal ix tet eb anwam, pero c'am nioj jix wa'xi sc'ul ix yu eb. ");
INSERT INTO knjNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yuxan jix apni ix yintaj Jesús, jix oc mitx'an ix yin sti' spichil Jesús. Ja' yet jix oc mitx'an ix yin sti' spichil naj, catu' jix oc tucan yey s'ilal ix tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jix sk'anlen Jesús tet eb ánima tu' jaxca ti': —¿Mac txequel jun jix oc mitx'an sk'ab win an? ẍi Jesús. Pero jix yal masanil eb, tol c'am mac jix oc mitx'an sk'ab yin. Catu' jix yalon naj Pedro yetoj wan xa eb yet cuywomal tu' tet Jesús jaxca ti': —Wuẍtaj caw chi switz' sba ánima ja win yet chi cu beyi. Ec'al eb chi sten oc sba ja win, pero cha k'anlen pax oj: “¿Mac jix oc mitx'an sk'ab win an?” ja chi pax oj, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Catu' jix yalon Jesús tu': —Ey jun mac jix oc mitx'an win an. Wotaj an, jix wa'xi can sc'ul yu wip an, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ja' yet jix yilon ix ix tu', tol ma ske' yewban el sba ix xol ánima tu', caw jix bilwi a ix yu xiw c'ulal, jix apni ix sc'atan Jesús. Jix ey kaan ix yajantaj. Jix yalon el ix sattaj masanil eb ánima tu', tzet yuxan jix oc mitx'an ix yin Jesús. Jix yalon ix tzet jix yun swa'xi sc'ul ix. ");
INSERT INTO knjNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yuxan jix yal Jesús tet ix jaxca ti': —Txo ix, jix wa'xi can ja c'ul wu an, yutol jix ja waoc ja c'ul win an. Yuxan, paxan yin tzala c'ulal, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lalan to yalon Jesús tet ix jaxca tu', ey jun mac txequel speto bey sna naj Jairo tu', jix yalon tet naj jaxca ti': —Ja' ix ja cutz'in tu', jix cam ix. Tuxa c'al chi yetne sba naj cuywam ti' sto yiloni, ẍi eb tet naj Jairo tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero ja' yet jix yaben Jesús jun tu', jix yalon tet naj jaxca ti': —Manchej jaach ok'i. Asan tol cha waoc ja c'ul yin Dios, oj wa'xoj can sc'ul ix ja cutz'in tu', ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ja' yet jix apni eb bey sna naj, ma cha'le octoj eb ánima yu Jesús yul na tu'. Asanne Pedro, Jacobo c'al Juan yetoj smam xutx ix unin tu' jix ẍa' octoj Jesús tu' yetoj. ");
INSERT INTO knjNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tuxa c'al chi nilili ánima yok' yu ix. Catu' jix yalon Jesús tu' jaxca ti': —Manchej jex ok'i. Ja' ix unin ti', man camnaj oj ix, asan chi weyi, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero tu' c'al jix tzeewi a eb, yutol yotaj xa eb tol camnaj xa ix. ");
INSERT INTO knjNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jix lawi tu' xin, jix oc mitx'an Jesús yin sk'ab ix tu'. Catu' jix yalon naj yin ipal jaxca ti': —Txo k'opo, aan linan oj, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Eyman jix pitzc'u a ix. Jix a linan ix tu'. Catu' jix yalon Jesús tol chi ak'le slo'be ix. ");
INSERT INTO knjNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Caw jix q'uey a sc'ul smam xutx ix yet jix yilon eb. Jix yalon Jesús tet eb tu', tol c'am ojab junoj mac txequel bey chi yal eb tzet jix yun spitzc'u a ix. ");
INSERT INTO knjNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ja' yet junel, jix yawte oc joyan eb lacawan scuywom sc'atan Jesús. Jix ak'le yip eb. Catu' jix ak'le pax yopiso eb i'o can el pena espíritu yin ánima, c'al yak'on can wa'xoj sc'ul eb ánima ya' ey. ");
INSERT INTO knjNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jix ẍejontoj eb, yu ec' yalon can el eb tzet utbil chi yun yoc Dios Yaawil oj eb ánima, c'al ec' yak'le can wa'xoj sc'ul eb ya' ey yu eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ja' yet c'am to chi to eb, catu' jix yalon tet eb jaxca ti': —Manchej je yi' nioj yet je be. Manchej je yi' je k'ojoch, je pa, je lo'be, ma je tumin. Catu' je pichil asan jun jun ey oc je yu ti' che yi'toj. ");
INSERT INTO knjNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yal c'al tzet nail bey chex apni, ja' c'al titu' che yak' je posada masanta' c'al chex to bey junoj xa lugar. ");
INSERT INTO knjNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ta ey mac c'am chex cha'oni, chex el yul sconob eb tu'. Che tzic' can el spojojal je yajan yu je tx'oxon el oj tol c'am xa je yalon je yet yin eb, catu' chex toi, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jix lawi tu' xin, catu' jix to eb. Jix ec' eb bey jun jun aldea. Jix yal can el watx' k'ane yet colbanile eb. Jix wa'xi pax can sc'ul eb ya' ey bey jun jun lugar yu eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ja' naj Herodes, naj yaaw bey Galilea, jix yab sk'umal naj tzettaj yetal jix el yunen Jesús. Tu' c'al chi q'uey a sc'ul naj, yutol ey eb jix alon jaxca ti': “Ja' jun tu' chi el yunen wan tzet yetal tu', ja' naj Juan, jix pitzc'u a naj xol eb camnaj,” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ey pax eb chi aloni: “Ja' naj Elías chi jul x'ox ec' sba,” ẍi eb. Pero ey pax wan xa chi aloni tol ja' junoj xa eb ẍejab Dios peyxa jix pitzc'u a oj catu' chi jul x'ox ec' sba. ");
INSERT INTO knjNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Jix yalon naj Herodes tu' jaxca ti': —Pero jainti', jix wak' orden, catu' jix i'le el sjolom naj Juan tu'. Yuxan, ¿mac mi txequel jun caw chi yal el eb tu'? ẍi naj. Caw chi yoche naj Herodes tu' chi yil Jesús yetoj sat. ");
INSERT INTO knjNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ja' yet jix jul eb ẍejab Jesús yin ẍejbanil tu', jix c'oli yalon eb tet, tzettaj c'al jix el yunen jun jun eb. Catu' jix i'letoj eb yu Jesús. Jix apni eb xojli yetoj Jesús bey jun lugar scawilal conob Betsaida. ");
INSERT INTO knjNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero jix yab eb ánima tol chi to eb titu'. Yuxan, tzajan sto eb yintaj Jesús. Jix cha'le apnoj eb yu Jesús bey jix apni tu', catu' jix yalon xol eb tu' tzet oj yun yel oc eb chi oc Dios Yaawil oj. Jix yak'on pax can wa'xoj sc'ul eb ya' ey. ");
INSERT INTO knjNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ja' yet lalan xa yey c'u, jix apni eb lacawan scuywom sc'atan Jesús. Jix yalon eb tet Jesús jaxca ti': —Tejan watx' ta cha chejtoj eb ánima ti' bey wan aldea yetoj bey wan lugar cawil ti', yet watx' chi sman slow sba eb, catu' chi wey eb titu'. Yutol ja' bey ey jon ec' ti', cusiltaj tx'otx', ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jix yalon Jesús tet eb jaxca ti': —Ak' wej low eb jaexti', ẍi Jesús tet eb. —Pero asan ch'an joeb cu pan on i'bil yetoj cac'on pescado on. ¿Tumi chi to cu man yet eb ánima ti' on? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ey mi joeb oj mil sbisil eb winaj ey ec' titu'. Jix yalon Jesús tet eb scuywom tu' jaxca ti': —Al wej tet eb, ey ojab chotan eb yin bulquiltajil. Cincuentataj ojab sbisil jun jun bulan, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jaxca tu' jix yute eb. Ja' yet jix ey chotan masanil eb ánima tu', ");
INSERT INTO knjNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","jix yi'on a joeb ixim pan tu' naj Jesús, c'al cac'on no' pescado tu'. Jix a t'anan satcan, catu' jix yalon yu diosalil tet Dios yu, catu' jix spo'on ey oj. Catu' jix yak'on tet eb scuywom tu' yet chi spo'on ec' eb xol ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jix low masanil eb, jix cam sno sc'ul smasanil eb. Ja' yet jix lawi slow eb, lacaweb to xuc jix no can yu sobrail lo'be. ");
INSERT INTO knjNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ja' junel, ey ec' Jesús txaloj xojli yetoj eb scuywom. Jix sk'anlen tet eb jaxca ti': —¿Mac jin txequel yal eb ánima che yabe? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—Ey eb chi aloni tol ja' naj Juan Bautista jaach, yal eb. Ey pax eb chi aloni tol ja' naj Elías jaach, yal eb. Ey eb xin, tol ja' junoj xa eb ẍejab Dios peyxa, jix pitzc'u a xol eb camom, ẍi eb, ẍi eb cuywom tu' tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jal jaex pax oj, ¿mac jin txequel je yaloni? ẍi Jesús tet eb. Jix tak'wi naj Pedro tet Jesús jaxca ti': —Jaachti', Cu Cristoal jaach, Ak'bil ja Wopiso yu Dios, ẍi naj Pedro tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero jix cam yalon Jesús tet eb, tol c'am junoj mac txequel bey chi yal eb jun jix yal Pedro tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jix yalon pax tet eb jaxca ti': —Jainti', Ak'bil Wopiso yu Dios xol eb ket animail an, pero sowalil oj wil sya'ilal. Oj jin intajnele can el yu eb ichamtaj winaj ey yopiso, c'al yu eb yak'omal xaambal tet Dios yetoj yu eb cuywam yin sley Moisés. Oj jin yak' cam eb an, pero yoxial tu', oj jin pitzc'u pax a oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Catu' jix yalon tet masanil eb jaxca ti': —Ta ey mac txequel chi yoche chi ec' c'al cuywoj wintaj an, sowalil man xa ojab yetoj sba xojli. Yab ojab sya'il eb jin ya'il oj jainti' jun jun c'u an, jaxca tol chi locbale a eb yin culus. Ta bejan sc'ul eb jaxca tu', ec' ojab eb cuywoj wintaj an. ");
INSERT INTO knjNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yutol ja' eb c'am chi yoche chi cam bey yul yiban k'inal ti', chi sbej el eb jun k'inale tol ey c'al yin tobal k'inal. Jal pax eb bejan sc'ul scam jin ya'il oj an xin, ja' ton eb tu' oj cha'on k'inale tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","K'inaloj ta chi kak' ganar ki'on masanil tzet ey yul yiban k'inal ti', pero ta c'am pax scolbanil cu pixan, chi cu to can bey sya'tajilal yin junelne. ¿Tzet cu ganar jaxca tu' xin? ");
INSERT INTO knjNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ta ey mac chi q'uixwi a jin ya'il oj an, c'al yu jin k'ane an, oj jin q'uixwoj pax walon el eb an, jain Ak'bil Wopiso xol eb ket animail ti' an, yet oj jin jul wak'on Yaawil. Ja' yet tu' oj jin jul yetoj yipalil jin Mam an, c'al yetoj yipalil eb ángel. ");
INSERT INTO knjNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Caw yel chi wal e ex, ey wan jex titi', c'am to chex cami catu' oj je yiloni, tol ey oc Dios yin Yaawil oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jujubixi mi yal Jesús wan tu', jix to txaloj bey jun wonan. Jix yi'ontoj Pedro yetoj Jacobo c'al Juan yetoj. ");
INSERT INTO knjNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ja' yet lalan xali tu', jix q'uexmo yili Jesús, tx'oj xa jix yun yili sat. Ja' spichil, caw saj jix yun yili, tuxa c'al chi tzejeji. ");
INSERT INTO knjNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Eyman jix x'ox a sba cawan winaj, naj Moisés yetoj naj Elías. ");
INSERT INTO knjNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ey jun miman tzejejial jix majchen ey eb. Jix k'anab eb yetoj Jesús yu tzet oj yun scam naj bey Jerusalén. ");
INSERT INTO knjNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ja' naj Pedro yetoj eb yet cuywomal, cax c'al caw chi yal weyan sat eb, pero jix yilon pax sejejial a Jesús eb. Jix yilon pax eb cawan winaj ey ec' yetoj naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ja' yet lalan xa yel eb cawan tu' sc'atan Jesús, jix yalon Pedro tet Jesús tu' jaxca ti': “Wuẍtaj, caw watx' ket, yutol ey jon ec' titi'. Tejan watx' chi cu wa'ne oxeb oj pat, junoj ja wet, junoj yet Moisés, yetoj junoj yet Elías,” ẍi Pedro tet Jesús. Pero man yotaj oj tzet lalan yaloni. ");
INSERT INTO knjNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lalan to sk'anab Pedro tu', jix ey jotna jun asun yiban eb. Caw jix xiw a eb scuywom Jesús tu' xol asun. ");
INSERT INTO knjNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jix lawi tu' xin, catu' ey junoj mac jix alon xol jun asun tu' jaxca ti': —Ja' ton jun jin C'aal ti', sic'bil el wu an. Ab tzet chi yal naj, ẍi. ");
INSERT INTO knjNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jix lawi c'al yaben jun tu', catu' jix yilontej eb tol xojli xa Jesús ey ec' oj. Ja' eb cuywom tu', c'am junoj mac bey jix yal eb tzet jix yil eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ja' yet jun xa c'ual, yet jix eytej eb bey jun wonan tu', ec'al ánima jix apni sc'atan Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ja' xol ánima tu', ey jun winaj jix a yaw yin ipal tet naj jaxca ti': —Mamin, chin k'an favor e ach, c'am mi cha wil jun jin c'aal jin k'an an, yutol asan ch'an jun q'uetxan jin c'aal ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ey xa tiempo sc'oli yetnele yu jun pena espíritu ey oc yin. Chi swek' el yaw, chi tit snum sat. Chi el som sti' yu. Caw chi etnele yu sic'lebil. C'am chi jajle el yu. ");
INSERT INTO knjNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jix wak'le walon tet eb ja cuywom, tol chi yi' el jun pena espíritu ti' eb yin naj, pero ma ske' yu eb, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jix yalon Jesús tu' tet eb jaxca ti': —Jaexti', caw c'am che yaoc je c'ul yin Dios, caw caw je na'bal. Ilala ey xa tiempo c'al we ec' je yetoj. ¿Bak'in oj na'cha el je yu xin? ¿Jayel ta' xam el chin awtele ec' je yu? Catu' jix yalon tet naj: “Asi', i'tej naj ja c'aal tu' e in an,” ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pero ja' yet jix apni jun unin tu', jix k'ojle ey sat tx'otx' yu jun pena espíritu tu'. Caw jow jix yun stit sya'ilal naj tu'. Pero ja' naj Jesús, jix tzuwa yin jun pena espíritu tu', jix wa'xi can sc'ul naj unin tu', catu' jix ak'le can naj tet smam yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Masanil eb ánima titu', jix q'uey a sc'ul eb yiloni tol caw miman yip Dios. Ja' yet jix q'uey a sc'ul eb ánima tu' yilon tzet jix el yunen Jesús tu', jix yalon naj tet eb scuywom tu' jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Chi cam wal je yaben sic'lebil tzet oj wal e ex. Manchej q'ueytoj yul je c'ul. Yutol cax c'al Ak'bil Wopiso yu Dios xol eb ket animail an, pero oj jin ale oc yul sk'ab wan winaj, ẍi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero ja' eb scuywom tu', ma na'cha el yu eb, tzet jix yal tet eb tu', yutol ma ak'le na'cha el yu eb. Jix xiw eb sk'anlen pax tet Jesús tzet chi yal yel oc apnoj. ");
INSERT INTO knjNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jix c'oli steelen sba eb cuywom tu' yu mac junoj mac txequel yel miman yel oc apnoj xol eb, yutol jun jun c'al eb, chi sna' eb tol ja' eb yel miman yel oc apnoj xol yet cuywomal. ");
INSERT INTO knjNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero yotaj Jesús, tzet lalan sna'on eb. Yuxan jix yi'ontej jun unin sc'atan. ");
INSERT INTO knjNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jix yalon tet eb scuywom tu' jaxca ti': —Yal c'al mac chi cha'on junoj unin jaxca jun unin ti', yutol wet an, jaxca tol jain chin ẍa' eb an. Man asanne oj jin, chin ẍa' eb an. Chi ẍa' pax eb jun mac txequel jix jin chejontej an. Ja' mac yel xa c'al chi yi' ey sba je xol, ja' ton jun tu' yel xa c'al miman yel oc apnoj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jix yalon naj Juan tet Jesús jaxca ti': —Wuẍtaj, ey jun winaj jix kil on. Lalan yi'on el pena espíritu yin ánima yu ja wip. Pero jix cu ten oc tucan on, yutol man junne oj chi ec' ketoj, ẍi Juan tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jix yalon Jesús tu' jaxca ti': —C'am ojab che ten oc tucan naj, yutol ja' eb man ac'ul oj oc kin, ja' ketoj ey oc eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ja' yet tuxa chi apni stiempoal spax a Jesús satcan, jix tec'ba sba sto bey Jerusalén. ");
INSERT INTO knjNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ey wan eb ẍejab jix babi ẍejtoj. Jix apni eb bey jun aldea yul yet Samaria, yutol chi yoche eb chi swa'ne sposada yet chi apni, yuxan jix babi toj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ja' eb a Samaria tu', ma ak'le sposada yu eb, yutol yotaj eb tol lalan sto naj bey Jerusalén. ");
INSERT INTO knjNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ja' eb cawan scuywom tu', ja' ton Jacobo yetoj Juan, ja' yet jix yilon eb jaxca tu', jix yalon eb tet Jesús: —Wuẍtaj, ¿chim yal ja c'ul chi cu k'antej k'ak' bey satcan yiban eb, catu' chi lawi el eb? Quey tu' jix yun naj Elías yet peyxa, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jix oc t'anan Jesús yin eb. Jix tenchanele eb yu Jesús. Jix yalon jaxca ti': —Jaexti', c'am chi na'cha el je yu tzet na'baleal che k'anbalne yet che yalon jaxca tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ja' jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, man yu oj wak'on lawoj el ánima an, yuxan jix jin jul an, pero yu jin colon el eb an, ẍi Jesús tet eb. Catu' jix to eb bey jun xa aldea. ");
INSERT INTO knjNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ja' yet lalan sto eb yul be, ey jun winaj jix alon tet Jesús jaxca ti': —Mamin, yal c'al bey oj jaach toj, oj jin toj ja wetoj an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jix yalon Jesús tu' tet naj jaxca ti': —Ja' no' wax, ey sna ch'en no', c'al no' tz'iquin, ey sweyub no'. Pero jainti', cax c'al Ak'bil Wopiso yu Dios xol eb ket animail an, c'am nioj jin na bey chin weyi, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Catu' jix yalon tet jun xa jaxca ti': —Ec'an c'al cuywoj wintaj an, ẍi Jesús tet. Pero ẍi naj tet Jesús jaxca ti': —Mamin, ak' nioj xa jin permiso an, chi woche chin muj can toj jin mam an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—Ja' eb camnaj to el yul sat Dios, ja' eb chi ske' smujon can eb yet camnajil tu'. Pero jaachti', asi' al el tzet utbil ye oc Dios yin Yaawilal, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ey jun xa naj jix alon tet Jesús jaxca ti': —Mamin, chi woche chin ec' c'al cuywoj ja wintaj an, pero chi woche cha wak' jin permiso an, chin to wal to jin ba tet eb ey bey jin na yin sbabelal an, catu' oj jin toj ja wetoj an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero jix yal Jesús tet naj jaxca ti': —K'inaloj ta ey junoj winaj chi mulna yetoj wacax tinani', chi oc mitx'an yin smitx'banil ch'en k'ubal tx'otx' tocbil oc yu no', pero chi to pax t'anan naj yintaj. Ta ey mac quey tu' yak'on sna'bal, c'am nioj yopiso eb yin yoc ẍejab oj Dios, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jix lawi wan tu' xin, jix sic'on el jun xa setenta scuywom naj Kaawil. Jix ẍejon babojtoj eb. Catawan jix yun sto eb bey jun jun conob. Bey jun jun lugar bey oj ec' pax naj Kaawil tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ja' yet c'am to chi to eb, jix yalon tet eb jaxca ti': —Ja' eb ánima laan eb jaxca ixim trigo stiempoal xa sc'uplei. Caw yel, ec'al ton eb, pero jaywanne mac chi mulna xol eb. Yuxan, txalan nej tet naj a mulnail tu', yet watx' chi ẍejontej smulnawom yu yi'on a eb. ");
INSERT INTO knjNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Asi' wej xin, jaxca no' me' chi to xol no' oj, quey tu' chex wute waontoj an. ");
INSERT INTO knjNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Manchej je yi' je pa, je tumin, yetoj je xanab. Manchej jex oc linan k'anab yetoj junoj mac txequel yul-laj be. ");
INSERT INTO knjNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ja' yet chex apni bey jun jun na, ja' scawil sc'ul eb chi babi je yak'a. Che yalon tet eb jaxca ti': “Ey ojab watx' c'ulal snan xol eb yul jun na ti',” je chi. ");
INSERT INTO knjNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ta ey eb chi ochen watx' c'ulal titu', oj ak'le tet eb jaxca oj je yute je yalon tu'. Ta ey mac c'am chi ocheni, man oj ak'le tet eb jaxca che yute je yalon tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Asan bey junoj na che yak' je posada. Ja' tzet chi slo' eb, che lo' yetoj eb, yutol ja' mac chi mulnai, smoo ẍa'on stool. Manchej jex ec' txolol oj xol-laj na. ");
INSERT INTO knjNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ja' yet chex apni bey jun jun conob bey chex cha'lei, yal c'al tzet chi echbale eltej e ex, lo' wej. ");
INSERT INTO knjNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Che yak' can wa'xoj sc'ul eb ya' ey bey chex ec' c'al tu'. Catu' che yal tet eb, “Tuxa oj oc Dios yin Yaawil oj,” je chi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero ta ey junoj conob bey c'am jex cha'le xin, che yal yul scalleal jun conob tu' tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ja' spojojal jun je conob chi oc can yin kajan ti' on, chi cu tzic' can el on, yu cu tx'oxon el on, tol c'am xa kalon ket je yin on. Pero na'cha ojab el je yu, tuxa oj oc Dios yin Yaawilal,” je chi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Chi wal e ex, tol ja' yet oj jul jun c'ual yet chi sna' oc Dios yin ánima, yel xa c'al miman castigo oj ẍa' eb tu' yintaj eb a conob Sodoma. ");
INSERT INTO knjNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Chi wal e ex an, jex a Corazín, caw ok'bal jex c'ule. C'al jex a Betsaida, ok'bal jex pax c'ule. K'inaloj ta ja' bey Tiro yetoj bey Sidón jix yun wan milagro jix yun je xol ti'. Xax yaoc eb wan eel coẍtal spichil oj. Yetoj sti'k'ak'il taan xax yatoj eb yin sjolom, yu xeclonen el eb tol caw chi cus sc'ul eb yu spenail. ");
INSERT INTO knjNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ja' yet oj jul jun c'ual yet chi sna' oc Dios yin ánima, yel xa c'al miman sya'tajilal oj je cha' yintaj eb a Tiro c'al eb a Sidón. ");
INSERT INTO knjNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yetoj pax jex a Capernaum, che na' tol je moo je ya apnoj satcan, pero tol oj jex toj bey sya'tajilal, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jix yalon tet eb scuywom jaxca ti': —Ja' mac chi cha'on aben e ex, chi yal yel oc apnoj tol ja' e in chi ẍa' yab eb an. Jal pax eb chex intajnen el oj, chi yal yel oc apnoj tol jain chin yintajne el eb an. Ja' eb chin intajnen can el tu', chi yal yel oc apnoj tol ja' jun mac txequel jix jin chejontej, ja' lalan pax yintajnen el eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jix apni eb setenta chejabwom sc'atan Jesús yin tzala c'ulal junel xa. Jix yalon eb tet Jesús jaxca ti': —Wuẍtaj, ja' eb pena espíritu, jix sjije eb tzet jix kalon yet jix kawten ja bi, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jix yalon Jesús tet eb tu': —Jainti', jix wil tzet jix yun yeytej Satanás satcan, jix ey can jul yul yiban k'inal ti' jaxca chi yun ya letz'na yichcan. ");
INSERT INTO knjNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jainti', jix wak' je yip, catu' chi ske' chex oc linan yiban no' laba, c'al yiban no' sinam. Wu an, yuxan che yak' ganar scan yipalil naj ac'ul oc je yin yalan, catu' c'am junoj tzet chex etneni. ");
INSERT INTO knjNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Manchej jex tzala yutol chi sjije eb pena espíritu e ex. Pero tzalaan nej, yutol tz'ibebil je bi bey Dios, mac jex che yaoc je c'ul yin, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ja' yet jun tiempo tu', caw jix tzala a Jesús yu Santo Espíritu. Jix yalon jaxca ti': —Mamin, Yaaw jaach bey satcan yetoj bey yul yiban k'inal ti'. Chi wal watx' k'ane e ach an, yutol jix ja wewba el wan ti' tet eb jelan, c'al tet eb caw jelan yul sat yet animail. Jal eb c'am yel oc apnoj yul sat ánima xin, jix ja wak' yotajne el oj. Quey tu' jix ja wute jaxca tu', Mamin, yutol quey tu' jix ẍa' ja c'ul, ẍi Jesús tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jix yalon Jesús tet eb ánima ey ec' titu' jaxca ti': —Ja' jin Mam an, jix yak' masanil tzettaj yetal yul jin k'ab. C'am junoj mac txequel otajnen jin, jain C'aale jin ti'. Asan jin Mam tu' otajnen jin an. Yetoj pax oj, c'am mac comon c'al chi otajnen el jin Mam an. Asan jin Jain Sc'aal jin ti', wotaj an, yetoj pax eb mac tet chi yal jin c'ul chi wak' otajnele el oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jix lawi jun tu', jix ec' t'anan oj xol-laj eb scuywom, jix yalon tet eb xojli jaxca ti': —Caw watx' je yet yutol che yil jun tzet lalan je yilon ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yutol chi wal e ex, ec'al eb ẍejab Dios c'al eb yaaw yet peyxa, jix ochen jix ilon wan tzet che yil ti', pero ma yil eb. Yetoj pax oj, jix yoche eb jix yab wan lalan je yaben ti', pero ma yab eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jix lawi c'al jun tu', ey jun naj cuywam yin sley Moisés jix a linan oj. Jix yoche naj jix yak' porobal naj Jesús. Yuxan jix sk'anle naj tet Jesús jaxca ti': —Jaach cuywam, ¿tzet yetal sowalil chi wun an catu' oj jin cha'on jin k'inal tol ey c'al yin tobal k'inal? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","—¿Tzetal tz'ibebil can yul sley Moisés? ¿Tzet ẍi? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","—Chi yal jaxca ti': “C'am c'ulne wej Kaawil cu Diosal yin masanil je c'ul, yin masanil je pixan, yetoj masanil je yip, yin masanil je na'bal. Catu' che cam c'ulnen pax je yet animail jaxca che yute je cam c'ulnen je ba jun jun ex,” ẍi ley, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Watx' ton jix ja wute ja waloni, ta cha wun wan ti', oj ja cha' ja k'inal tol ey c'al yin tobal k'inal, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ja' naj tu', jix yoche naj jix x'oxo tol watx' sbeybal naj, yuxan jix yal pax naj tet Jesús jaxca ti': —¿Mac txequel eb wet animail chi al-le tu'? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jix yalon Jesús tu' jaxca ti': —Ja' yet junel, ey jun winaj lalan sto yul be chi tit bey Jerusalén catu' chi ey apnoj bey Jericó. Lalan sbey naj catu' jix eltej wan elk'om yin naj. Tz'ajan jix tok'le can ec' tet naj masanil settaj yetal naj, ja' spichil naj jix yi' el eb. Xew c'al smak'le naj yu eb, catu' jix to eb. Nianxane ma cam naj yu eb. ");
INSERT INTO knjNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Catu' ey jun naj yak'omal xaambal tet Dios jix ec' yul jun be tu', tu' c'al jix oc t'anan naj yin naj, catu' jix to naj. ");
INSERT INTO knjNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jix lawi tu' xin, ey jun xa naj yic'aal Leví jix ec' pax yul jun be tu'. Tu' c'al jix oc pax t'anan jun xa tu' yin naj catu' jix toi. ");
INSERT INTO knjNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero ey jun naj a Samaria lalan pax sbey yul jun be. Jix yilon naj tol telan ey naj yul be. Jix ok' sc'ul naj yin naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jix apni sc'atan naj, catu' jix yaon oc aceite olivo yetoj vino yanil oj bey jix yasitoj naj tu'. Catu' jix spichon naj yetoj k'ap. Jix lawi tu' xin, catu' jix slacon atoj naj yiban ẍe. Jix yi'on can toj bey jun posada. Caw jix scam c'ulnele naj sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ja' yet jun xa c'u, yet jix to naj a Samaria tu', jix yi' atej naj caab tumin, catu' jix yak'on can naj tet naj a posada tu'. Catu' jix yalon can naj tet naj jaxca ti': “Watx' cha wute ja teynen naj yasinajtoj ti' jin k'an an. Ta c'am chi yab nian tumin ti', oj ja wal e in an jantaj to jix ja q'uey el oj, catu' oj wak'on sq'uexel ja tumin yet oj jin jul pax jun el xa an,” ẍi naj tet naj a posada tu', ẍi Jesús yul jun sk'aneal ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","—Ja' tinani' xin, ey jun chin k'anle e ach. Ja' naj jix mak'le yu eb elk'om tu', “¿mac junoj eb oxwan tu' caw yel yet animail naj cha na'?” ẍi Jesús tet naj cuywam yin sley Moisés tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Ja' ton naj jix ok' sc'ul yin naj tu', ẍi naj tet Jesús. —Ja' toni, yuxan, asi' catu' cha wun jaxca jix yun jun naj tu', ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jix to c'al Jesús yul be tu'. Jix apni bey jun aldea tu'. Bey ey jun ix ix, Marta sbi. Jix cha'le apnoj Jesús yu ix bey sna. ");
INSERT INTO knjNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ey jun ix sno ix Marta tu', María sbi. Jix ey chotan ix yin sc'ul yajan Jesús, yu yaben ix tzet chi yala. ");
INSERT INTO knjNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero ja' ix Marta tu', caw c'am scolanil ix yu smulnail. Yuxan jix apni ix bey Jesús, catu' jix yalon ix tet Jesús jaxca ti': —Mamin, ¿tumi c'am cha wil nioj tol chi sbej can bulan mulnail ix jin no ti' e in jin txojli an? Al tet ix jin k'an an, tol chi colwa ix wetoj an, ẍi ix Marta tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jix yalon Jesús tu': —Marta, caw miman chach oc il. Catu' cha wak'on q'uey ja na'bal yu ec'al tzet cha wun tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero junne tzet caw sowalil chi wa'xi ja wu. Ja' ton jun swatx'ilal tu' chi yoche María ti'. Yuxan, c'am junoj mac txequel oj ske' yi'on ec' jun tu' tet ix, ẍi Jesús tet ix Marta. ");
INSERT INTO knjNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ja' yet junel, jix txali Jesús bey jun lugar. Ja' yet jix lawi xali, ey jun scuywom jix alon tet jaxca ti': —Wuẍtaj, ¿c'am mi cha cuyon yin txa, jaxca jix yute scuyon eb scuywom Juan? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jix yalon Jesús tet eb jaxca ti': —Ja' yet chex txali, quey ti' che yute je yalon jaxca ti': Mamin, tol ey jaach ec' bey satcan. Miman ojab yel oc apnoj ja bi. Titan ja wak' Yaawilal titi'. Jaxca ojab yunen tzet cha woche bey satcan tu', quey ojab tu' yunen sat tx'otx' ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ak' cu lo'be cu lo'on yet jun jun c'u on. ");
INSERT INTO knjNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ak' miman c'ulal kiban yu cu penail, jaxca chi kute kak'on miman c'ulal yiban eb ey tzet chi cu uteni. Manchej jon ja wak' ak'le porobal. Catu' chon ja colon pax el yul sk'ab spenail. ");
INSERT INTO knjNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jix lawi yalon Jesús wan ti' xin, jix yalon pax jaxca ti': —K'inaloj ta ey junoj jex chi jul junoj je yamigo je c'atan yet chuman ak'bal. Chi jul yalon e ex jaxca ti': “Jaach wamigo, ak' nioj lo'be jin q'uexa. ");
INSERT INTO knjNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yutol ey jun wamigo lalan to sjul ti', naat ta' speto. C'uxan c'am pax nioj tzet watx' wak'on tet,” ta ẍi chi jul je c'atan. ");
INSERT INTO knjNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","K'inaloj tu' c'al chex tak'wi pax eltoj tet naj jaxca ti': “Manchej jin ja wetne. Jix jin majche jin na an. Lalan xa jin wey yetoj eb wuninal sat tx'at. Yuxan c'am chi ske' chin a waan an wak'on tzet cha k'an e in ti' an,” k'inaloj je chi eltoj tet. ");
INSERT INTO knjNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jain chi wal e ex, cax c'al je yamigo, pero c'am chex a waan je yak'on tet yin eymanil. Pero ta ja'c'ala' c'al sk'anon e ex, tejan chex a waan je yak'on tet, yet watx' chi sbej yawi octoj e ex. Catu' che yak'on ja'ta'c'ala' jantaj tzet chi sk'an tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yuxan chi wal pax e ex: K'an wej, oj yak' Dios e ex. Sey wej, oj ilcha je yu. Awan nej octoj sti' puerta, oj jajle e ex. ");
INSERT INTO knjNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yutol ja' eb chi k'anoni, chi ẍa' eb. Ja' eb chi seyoni, chi ilcha yu eb. Yetoj pax eb chi awi octoj sti' puerta, chi jajle tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ja' jaex mame jex ti', ta chi sk'an je yuninal junoj lo'be e ex, ¿tumi ja' junoj ch'en che yak' tet? Ta ja' junoj pescado chi sk'an e ex, ¿tumi ja' junoj laba che yak' tet? ");
INSERT INTO knjNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ta ja' junoj jos chi sk'an e ex, ¿tumi ja' junoj no' sinam che yak' tet? ");
INSERT INTO knjNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ja' jaexti', cax c'al pena jex, pero je yotaj che yak' tzet yetal watx' tet je yuninal. Yel c'al chi yak' pax cu Mam ey ec' bey satcan, chi yak' Santo Espíritu tet eb chi k'anon tet, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ja' yet junel, ey jun naj ey oc pena espíritu yin. C'am nioj chi ske' sk'anab naj yu. Ja' Jesús, jix i'on el jun pena espíritu tu' yin naj. Ja' yet jix el yin naj, chi xa ske' sk'anab naj. Yuxan, ec'al eb ánima jix q'uey a sc'ul yu. ");
INSERT INTO knjNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero ey eb jix alon jaxca ti': —Ja' jun winaj ti', chi ton ske' yi'on el pena espíritu yin ánima yutol ja' naj Beelzebú, ja' ton naj yaawil eb pena espíritu tu' ey oc yetoj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ey wan eb xin, tol jix yoche eb jix yak' porobal Jesús. Yuxan jix sk'an eb yil junoj satcanil milagro tet Jesús yu x'oxon naj yil eb ta tol yel jix tit naj bey Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero yotaj xa Jesús tzet lalan sna'on eb. Yuxan jix yal tet eb jaxca ti': —K'inaloj ta ey junoj miman conob bey chi po'cha eb yaaw, catu' chi yak'len a jowal eb, chi lawi el jun conob tu'. K'inaloj ta ey junoj nail eb ánima chi po'cha yu jowal. Chi sajlemtoj jun nail eb ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Quey ton pax tu' Satanás, ta chi po'chatoj naj yetoj eb yet pena espíritu tu', ¿tumi chi can can naj yin yopiso? Chi wal wan ti' e ex, yutol ja' naj Beelzebú ey oc wetoj an je yaloni, catu' chi wi'on el eb yet pena espíritu. ");
INSERT INTO knjNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pero ta yel che yala, ¿Mac pax ey oc yetoj eb je cuywom yet chi i'le el eb pena espíritu yin ánima yu eb? Ila xin, man jichan oj je na'oni, yutol ja'c'al oc eb je cuywom tu' chi tx'oxon el oj tol man jichan oj je na'oni. ");
INSERT INTO knjNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jainti', asan yipal Dios chi wak'balne catu' chi wi'on el eb pena espíritu tu'. Yuxan, miman txequel tol jix ẍa' el yich yak'on Yaawil Dios je xol. ");
INSERT INTO knjNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","K'inaloj ta ey junoj winaj caw ey yip. Ey smitx'k'ab yet jowal, yet watx' chi ske' scolon sna. C'am tzet chi oqui yin settaj yetal tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero k'inaloj ta chi jul junoj xa max txequel yel ec'ban yip yintaj naj. Ta chi ak'cha ganar naj a na yu, chi yi' ec' masanil smitx'k'ab naj ey oc yip oj sc'ul tu'. Chi lawi jun tu', chi spo'on ec' masanil wan chi stok' ec' tet naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ja' eb man ey oj oc wetoj an, cajat oc eb win an. Ja' eb c'am chi yamban oc wetoj an, ja' ton eb chi ak'on sajlem can toj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","K'inaloj ta ey junoj pena espíritu chi el yin junoj ánima tinani'. Chi lawi tu' xin, chi ec' bey masanil tajin lugarlaj. Chi seyon ec' bey watx' chi xew nioj. Pero c'am chi ilcha bey watx' chi eyi. Yuxan chi sna' jaxca ti': “Oj jin meltzo bey ey jin ta' a bey jix jin tita,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ja' yet chi apni, chi yilon oc spixan naj tu', laan jaxca junoj na q'uisbil, caw watx' yili. ");
INSERT INTO knjNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yuxan chi to yi'tej jujwanoj xa yet pena espíritu ec'ban xa spenail yintaj. Catu' chi swa'nen xa c'al ey sba eb yin spixan naj. Yuxan, yel xa c'al pena chi yun yel oc naj yintaj yet sbabelal, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ja' yet lalan yalon Jesús wan tu', ey jun ix ix jix awi a xol eb ánima tu': —Caw watx' yet ix ix ey jaach yune', ix bey jix jaach txutxwi, ẍi ix tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jix yalon Jesús jaxca ti': —Yel xa c'al ec'ban swatx'il yet eb chi aben sk'ane Dios catu' chi sjijen eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Caw ec'al ánima jix oc joyan yin Jesús. Jix yalon tet eb jaxca ti': —Ja' eb ánima yet jun tiempoal ti', caw pena eb. Yutol tu' c'al chi sk'an junoj milagro eb yila, junoj chi tx'oxon yipal Dios. Pero asan jun milagro oj jin tx'ox yil eb. Ja' ton junoj jaxca jun jix x'oxon Dios yin jun ẍejab chi yij sbi Jonás. ");
INSERT INTO knjNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ja' naj Jonás tu', x'oxbanil el yipal Dios tet eb ánima a conob Nínive yet peyxa. Jaxca naj Jonás tu' quey jin ton tu', jain, Ak'bil Wopiso yu Dios xol eb ket animail ti' an. X'oxbanil el yipal Dios oj jin utele sattaj eb ánima yet jun tiempoal ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ja' yet oj jul sc'ual yet oj sna'on oc Dios yin eb ánima ti', ja' ix yaaw bey sur yet peyxa, oj a linan ix, catu' oj yalon a ix spenail eb ánima ti'. Yutol caw naat jix tit ix, jix jul ix yaben tet naj Salomón jantaj sjelanil. Jaxa tinani', ey jun mac txequel ec'ban yel oc apnoj yintaj Salomón tu', pero c'am chi jul eb ánima yab tzet chi yala. ");
INSERT INTO knjNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ja' eb ánima a Nínive yet peyxa tu' ja' yet jix ec' yalon el sk'ane Dios naj Jonás xol eb, caw jix sna' sba sc'ul eb. Jal tinani', ey jun mac txequel ec'ban yel oc apnoj yintaj naj Jonás tu', pero c'am chi sna' pax sba eb ánima ti' yin spenail. Yuxan, ja' yet oj jul sc'ual yet oj sna'on oc Dios yin eb ánima ti', oj a waan eb a Nínive, catu' oj yalon a spenail eb tinani'. ");
INSERT INTO knjNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ja' yet chi kaon oc cu tzejtebal, c'am bey chi katoj bey man txequel oj. C'am bey chi ka octoj yalan junoj caan te'. Pero ja' yiban junoj tzet yetal naat ey a oj, ja' tu' chi katoj, yet watx' chi tzejtenele eb ey octoj yul na yu. ");
INSERT INTO knjNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ja' sbak' cu sat, laan jaxca junoj tzejtebal yu cu mimanil. Yuxan, ta watx' tzet bey ey oc cu sat, saj k'inal jon toni, watx' chi el kunen yetoj cu mimanil. Pero ta jaex pena bey che yaoc je sat, chex can xol k'ej k'inal yu. ");
INSERT INTO knjNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Che yil c'al je ba xin, yet watx' ja' je tzejtebal manchej je q'uextoj yin k'ej k'inalil. ");
INSERT INTO knjNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ta saj k'inal ye masanil je mimanil, ta c'am nioj k'ej k'inal je yin, saj k'inal jex toni. Jaxca junoj tzejtebal chex tzejteneni, jaxca tu' chi yun sajbi el je na'bal, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ja' yet jix lawi yalon Jesús wan tu', ey jun naj fariseo jix i'ontoj naj low bey sna. Yuxan jix to Jesús bey sna naj tu'. Jix ey chotan low yetoj naj. ");
INSERT INTO knjNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ja' naj fariseo tu', jix q'uey a sc'ul yutol ma sajbane sk'ab Jesús jaxca sbeybal eb. ");
INSERT INTO knjNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jix yalon naj Kaawil tu' tet naj jaxca ti': —Jaex fariseo jex ti', caw saj che yute yinlaj je vaso c'al je plato. Pero ja' yin je na'bal, asan chichon c'ulal, yetoj wan xa tzet yetal man watx' oj ey oc oj. ");
INSERT INTO knjNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Caw c'am je na'bal, ¿tumi man je yotaj oj tol ja' jun mac txequel jix wa'nen wan tzet yetal chi kil yinlaj, ja' pax jix wa'nen wan tzet yetal c'am chi kil yul-laj? ");
INSERT INTO knjNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ta watx' che yun tet je yet animail, ta quey tu' che yute jaxca tu', oj sajboj el je pixan c'al je na'bal. Chi yal yel oc apnoj c'am xa tzet pena ey oc je yin. ");
INSERT INTO knjNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ok'bal jex c'ule jaex fariseo jex ti'. Che yak' sdiezmoal an alawen, yetoj an ruda. Tz'ajan xa c'al che yak' sdiezmoal masanil ita. Pero ja' je na'oni tol man sowalil oj watx' che yute je na'bal. Man sowalil oj che cam c'ulne Dios. Tol ja' wan ti' sowalil che yune', catu' c'am che bej can je yunen c'al ta' wan jix je yun tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ok'bal jex c'ule jaex fariseo jex ti'. Ja' bey snail culto, asan bey chi ey chotan eb mimej winaj che yoche chex ey chotan oj. Yetoj pax yet chex ec' yul-laj calle, che yoche xa c'al chi yi' ey sba eb ánima e ex. ");
INSERT INTO knjNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Caw ok'bal jex c'ule. Caw caab sat jex. Laan jex jaxca bey mujan junoj camnaj man xa txequel oj bey mujan. Chi ec' ánima yiban, pero man yotaj oj eb ta ey mac k'aẍnaj xa eytoj bey linan oc eb tu', ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jix lawi yalon jun tu', ey jun naj cuywam yin sley Moisés jix alon tet Jesús jaxca ti': —Jaach cuywam, ja' yet jix ja walon wan ti', jaonti', man watx' oj jix kabe, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jix yalon Jesús tu': —Ok'bal jex pax c'ule jaex cuywam jex yin sley Moisés ti'. Ja' wan je chejbanil, laan jaxca junoj ijatz c'am chi laccha a yu ánima. Tu' c'al che bulba a ijatz che yak'on yij eb ánima. Pero c'am chex oc mitx'an je t'unon a nioj yijatz eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Caw ok'bal jex c'ule, yutol chi bet cam je wa'ne spantion eb ẍejab Dios bey camposanto, eb mak'bil cam yu eb je yichmam yet peyxa. ");
INSERT INTO knjNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yuxan, ja' yet che yunen wan tu', lalan je tx'oxon el oj tol watx' jix yute sba eb je yichmam je na'oni. Yutol ja' ton eb mak'nen cam eb ẍejab Dios tu'. Jaex xa chex bet je tz'aj je wa'ne a pantion yiban eb. ");
INSERT INTO knjNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yuxan jix yal can Dios yetoj sjelanil jaxca ti': “Oj jin chejtoj wan eb oj alon el jin k'ane je nan je xol, yetoj wan xa eb jin chejab. Ey eb oj je mak' cam oj. Ey eb tu' c'al oj je yetne yetoj sya'tajilal,” ẍi Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yuxan, masanil eb ẍejab Dios mak'bil cam yet tax c'al jix el yich yul yiban k'inal ti', oj ak'le oc eb smul oj eb ánima yet jun tiempoal ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Masanil eb ẍejab Dios mak'bil xa cam oj, yet c'al jix mak'le cam naj Abel, masanta' c'al yet jix cam naj Zacarías. Jun jix cam snan xol smeẍail xaambal yetoj stemplo Dios. Pero jain chi wal e ex, masanil eb mak'bil cam tu', oj ak'le oc eb smul oj eb ánima yet jun tiempoal ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ok'bal jex c'ule jex cuywam yin sley Moisés, yutol yin junelne che yal tol je yopiso je cuyon eb ánima yin sk'ane Dios. Pero ilala, c'am pax che yaoc je na'bal yin sk'ane Dios tu'. Catu' eb chi yoche chi yaoc sc'ul yin, c'am che cha' pax yaoc sc'ul eb yin, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yet jix lawi yalon Jesús wan tu', jix tit sjowal eb cuywam yin sley Moisés yetoj eb fariseo tu' yin naj. Caw ey tzet yetal jix sk'anle eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jix yechbane eb yabeni, ta ey tzet pena oj yute yaloni, catu' chi buchwa eb yin. ");
INSERT INTO knjNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ja' yet junel, ec'al sbisil smilal eb ánima jix yamcha oc sc'atan Jesús. Chi stec'le xa c'al toj sba ánima yutol tuxa c'al chi nilili ec' eb. Jix yalon Jesús sbabelal tet eb scuywom jaxca ti': —Che yil c'al je ba yu yich span eb fariseo, ja' ton scaab satil eb. ");
INSERT INTO knjNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yutol masanil jantaj tzet majan ey tinani', oj txeclo a oj. Yetoj jantaj tzet ewan c'uan yei, oj ak'le otajnele el oj. ");
INSERT INTO knjNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yuxan, masanil tzet jix je yal yin ewantajil, oj yab masanil eb ánima. Yetoj masanil tzet jix je ewan alne yul je txiquin, oj al-le el xol ánima yul-laj calle. ");
INSERT INTO knjNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ja' jaex jex wamigo, chi wal e ex, manchej jex xiw tet eb chi ske' yak'on cam je mimanil ti', yutol ja' yet chi xew je cam yu eb, c'am junoj xa tzet chi ske' yunen eb je yin. ");
INSERT INTO knjNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero oj wal e ex, mac tet smoo chex xiwi. Ja' tet Dios ja' tu' chex xiwi, ja' yet chi xew slawi je yak'le cam yu, ey pax yipal jex yaontoj bey sya'tajilal. Ja' ton tet Dios smoo chex xiwi. ");
INSERT INTO knjNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ila no' ni'tej tz'iquin tinani', c'am yel oc apnoj no'. Joc'on no' chi ske' ki'on yin caab centavo mi. Pero ja' Dios, ilbil c'al no' masanil yu. ");
INSERT INTO knjNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jaexti', yel miman je yel oc apnoj yintaj no'. Ja' xil je jolom bisbil yu Dios. Yuxan, manchej jex xiwi. ");
INSERT INTO knjNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Chi wal e ex, yal c'al mac c'am chi q'uixwi yalon sattaj ánima tol wet an, jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, oj wal oc eb wetoj an sattaj eb yángel Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero ja' eb chi alon sattaj ánima tol man wetoj an, oj wal pax sattaj eb yángel Dios tol man wetoj pax eb an. ");
INSERT INTO knjNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yal c'al mac chi alon junoj tzet yetal win an, jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, ey to miman c'ulal yin. Pero ja' mac chi buchon naj Santo Espíritu, ja' jun tu' xin, c'am xa miman c'ulal yin. ");
INSERT INTO knjNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ja' yet oj jex i'letoj bey snail sculto eb ket Israelal, ma yet oj jex i'letoj sattaj eb yaaw, manchej je yi' bis c'ulal yu tzet oj je yute je pajtzen tet eb. Manchej je yi' bis c'ulal yu tzet oj je yala. ");
INSERT INTO knjNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yutol ja' yet oj jul stiempoal je yalon tu', ja' Santo Espíritu oj ak'on tzet watx' oj je yala, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ja' xol eb ánima tu', ey jun mac txequel jix alon tet Jesús jaxca ti': —Jaach cuywam, al tet jun wuẍtaj an, tol chi yak' nioj wet yin jantaj tzet jix can yu cu mam, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero jix yal Jesús tet naj jaxca ti': —Wuẍtaj, ¿mac jix ak'on wopiso woc je yilomal oj, catu' chex jin wa'nen el oj? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Catu' jix yalon Jesús tet eb ánima tu' jaxca ti': —Chi cam je yabeni, catu' che teynen c'al je ba. Yet watx' c'am junoj tzet yetal comon c'al che yoche oc oj. Man yu oj tol miman tzet ey jon, yuxan tzala c'ulal ket yul yiban k'inal ti', ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Catu' jix yalontej jun sk'aneal ti' tet eb: —Ja' yet junel, ey jun winaj caw be'om naj. Miman tzet awbil yu jix el sat x'otx'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yuxan, jix sna' naj jaxca ti': “¿Tzet la oj wute an? ¿Yutol c'am xa bey watx' oj jin c'uba tzet awbil wu oj wi' ti' an?” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Catu' jix sna'on pax naj jaxca ti': “A… tol oj wute jun ti' an. Oj jin xuy ey wan jin c'una ti' an, catu' oj jin wa'nen wanoj xa yel mimej oj wute an. Ja' tu' oj jin yamba tzet awbil wu ti' an, c'al masanil tzet yetal ey e in an. ");
INSERT INTO knjNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Oj lawoj tu', oj walon yetoj jin pixan jaxca ti' an: Ja' tinani' xin, miman tzet jix jin yamba, caw miman tiempo oj jin k'anbalne. Yuxan, chi ske' chin xew tinani', chi ske' chin lowi, chi wuq'ue jantaj c'al chi woche. Chi ske' wak'on tzalaboj jin c'ul an, jin chi catu' oj waloni,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero jix yal Dios tet naj jaxca ti': “Jaachti', Caw c'am nioj ja na'bal. Ja' yet jun ak'bal ti', oj jaach cam oj. Jal pax jantaj tzet oj ja yamba a tu', ¿mac oj i'on can cha na'?” ẍi Dios tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jaxca ton jun winaj tu', quey ton tu' oj yun yel oc eb lalan syamban sbe'omal yu yoc yetoj xojli, ta c'am pax tzet lalan syamban eb yin yet Dios, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jix lawi jun tu', jix yalon Jesús tet eb scuywom jaxca ti': —Chi wal e ex xin, manchej je yak' bis c'ulal yu tzet chi yun yec' tiempo je yu titi', yu tzet che lo'. Manchej je yak' bis c'ulal yu je pichil. ");
INSERT INTO knjNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ja' Dios chi ak'on cu cawil. Oj yak' pax tzet oj cu lo'. Ja' jix ak'on cu mimanil ti'. Oj yak' pax cu pichil, ¿ta man oj yak' che na'? ");
INSERT INTO knjNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pero ila tax no' jo tinani', c'am tzet awbil yu no', c'am nioj tzet chi sjatx'a no', catu' chi syamba no'. C'am sc'una no', c'am bey watx' chi sc'uban no' nioj tzet yetal. Pero ja' Dios chi ak'on masanil tzet chi slo' no'. Jaexti', yel miman je yel oc apnoj yintaj no' yul sat Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Ma ey junoj jex chi ske' je yaon oc junoj xa c'u yak'il oj je k'inal yu che yak' bis c'ulal yin? ");
INSERT INTO knjNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yuxan, ta c'am chi ske' je wa'nen wan ti', ¿tzet yuxan che yak' bis c'ulal yu wanoj xa tzet yetal xin? ");
INSERT INTO knjNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ila tzet chi yun ẍ'ib an xumac cultaj tinani'. Ja' an xumac tu', c'am chi mulna an, c'am chi ske' x'alwi an, pero chi wal e ex, ja' naj rey Salomón, cax c'al caw watx' yili naj yetoj spichil, pero ma apnoj yili jaxca an xumac te' tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ja' an xumac te' tu', watx' yili an tinani', pero yecal, chi tz'a' an yul horno. Cax c'al jaxca tu' chi lawi el an yu naj, pero ja' Dios chi ak'on swatx'il yili an tu'. Jaexti', yel xa c'al oj yak' je pichil. Pero ian c'am pax che yaoc je c'ul yin Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Manchej je na' caw miman xin. Manchej je yak' bis c'ulal yu tzet che lo', c'al yu tzet che yuq'ue. ");
INSERT INTO knjNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yutol ja' eb man otajnen oj Dios, asan yin wan tu', bey ey oc sna'bal eb. Pero cu Mam Dios yotaj xa tol chi oc pax yopiso wan tu' ku. ");
INSERT INTO knjNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yuxan ak' wej je yip je cha'on Dios je Yaawil oj. Ta che yun jaxca tu', oj ak'le masanil wan ti' e ex. ");
INSERT INTO knjNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jaexti', jaxca tol jin me' je yei. Manchej jex xiwi. Jaywanne jex toni, pero ja' cu Mam Dios chi yoche chi oc je Yaawil oj, yutol jaxca tu' jix el yin sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Txon wej can el masanil je tzettaj yetal, catu' che sa'ontoj stool tet eb meba'. Jaxca ton tu' oj je yute je wa'nen sca'ail je tumin c'am bak'in chi xilbi el oj. Ja' bey satcan oj je yamba wan jaxca je be'omal tu'. Ja' wan tu', c'am bak'in oj lawoj. C'am junoj elk'om oj ske' yapni yelk'anen titu'. Yetoj pax oj, c'am pax no' i oj oc yin titu'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yutol, ja' bey chi cu yamba cu be'omal, ja' tu' chi ka pax toj cu na'bal. ");
INSERT INTO knjNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Caw listo che yute je ba, jaxca junoj mac txequel ey oc spichil, tzejbil pax sejtebal catu' chi smajon sjul spatrón. ");
INSERT INTO knjNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","K'inaloj ey wan moso lalan yechbanen sjul spatrón jix bet bey junoj k'in nupil. Ja' yet chi apni naj bey sna, chi awi octoj yul sna, catu' listo ye eb sjajon yin eymanil. Jaxca chi yute yechbanen spatrón eb moso tu', quey tu' che yute je ba jaexti'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ja' eb smoso iquis to yet chi apni spatrón tu', caw watx' yet eb. Caw yel chi wal e ex, ja' naj patrón tu', eyman oj sq'uexel sba, jaxa yak'le low yu eb smoso tu'. Catu' oj yak'on servil eb naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Cax c'al chuman ak'bal, ma yet tuxa chi sajbi, yet chi apni, ta iquis to eb smoso tu' yet chi apni, caw watx' yet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Na'cha ojab el jun k'aneal ti' je yu. K'inaloj ey junoj elk'om chi oc elk'an yul sna junoj ánima. K'inaloj ta yotaj jantaj hora chi jul jun elk'om tu', listo c'al ye naj steyneni, catu' c'am chi ẍa' oc elk'om bey sna tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yuxan, quey jex ojab tu'. Listo che yute je ba je majoni. Yutol ja' yet jun tiempoal che na' tol c'am chin jul an, ja' tu' oj jin jul an, jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, ẍi Jesús tet eb scuywom tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jix sk'anle naj Pedro tet Jesús jaxca ti': —Wuẍtaj, ¿Asanne mi e on jix ja wal jun sk'aneal ti', ma yu masanil ánima ti', yuxan jix ja wala? ẍi naj Pedro. ");
INSERT INTO knjNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jix yalon Jesús tet eb jaxca ti': —K'inaloj ta ey junoj patrón tinani'. Ta ey junoj smoso jijyom catu' jelan pax oj, ja' ton jun tu' chi yaoc yopiso naj yiban masanil eb yu steynele eb masanil, c'al yu yak'le slo'be eb jun jun ta' el. ¿Pero mac txequel junoj eb moso tu' jijyom che na? ");
INSERT INTO knjNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ja' ton naj lalan smulna jaxca chi yoche sc'ul spatrón tu' yet oj jul oj. Caw watx' yet jun moso tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Caw yel chi wal e ex, oj ale oc naj moso tu' yaawil oj yiban jantaj tzet ey yul sk'ab yu naj patrón tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero k'inaloj ta jaxca ti' chi yun sna'on jun smoso tu' tol man to c'al oj jul spatrón tu'. Catu' chi c'oli smak'on eb yet mosoal, c'al eb ix criadaeal. Catu' asan c'al low chi yune', c'al uq'ue an. ");
INSERT INTO knjNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ja' yet jun c'ual man echbanebil oj sjul spatrón naj moso tu', ja' ton yet tu' oj jul naj. Junelne man yotaj oj naj ta ja' yet jun txolan tu' chi juli. Oj ak'le sya'ilal naj sic'lebil yu naj patrón tu'. Catu' oj ale can toj naj bey ey ec' wan eb ma yaoc sc'ul yin Dios yu naj patrón tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","K'inaloj ta ey junoj moso yotaj tzet chi yoche sc'ul spatrón chi swa'ne. Pero man listo oj chi yute sba, catu' c'am chi sjije tzet chi yal spatrón tu'. Ja' jun moso tu', caw miman sya'ilal oj ẍa'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero k'inaloj ta ey junoj xa moso man yotaj oj, catu' chi swa'nen wan tzet yetal tol smoo chi yij tz'um yu. Ja' jun tu', txenne tz'um oj yija. Ja' eb miman tzet ak'bil tet, miman tzet oj k'anle el tet eb. Yetoj eb miman tzet ak'bil yul sk'ab, sowalil miman pax tzet oj yak' eb. ");
INSERT INTO knjNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jainti', jix jin jul yu waon oc jun tzet yetal jaxca junoj k'ak' bey yul yiban k'inal ti'. Caw chi woche tol lalan xa snusle jun tzet yetal jaxca k'ak' tu' tinani'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ey jun miman sya'ilal oj jul wiban an, jaxca tol oj jin ak'le bautizar yetoj an. Caw ey jun jin miman cus c'ulal tinani', masanta' c'al oj yun jun tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ma yu wak'on watx' c'ulal yul yiban k'inal ti', yuxan jix jin jul an je na'oni? Caw yel c'amaj. Pero yu yoc po'lebail yu eb ánima, yuxan jix jin jul an. ");
INSERT INTO knjNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","K'inaloj ey jowanoj ánima bey jun na. Oxwan eb chi oc scajat wan cawan. Jaxa eb cawan chi oc scajat wan oxwan. Quey tu' oj yun eb ánima yet jun tiempoal lalan sjul ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ey mame oj oc scajat oj yuninal. Ey uninale oj oc scajat oj smam. Yetoj pax oj, ey eb txutxe oj oc scajat oj yune'. Ey yune' oj oc scajat oj xutx. Ey eb ix alibe oj oc scajat oj yalib, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jix yalon pax Jesús wan xa ti' tet ánima tu': —Ja' yet che yiloni, tol chi tit asun bey jun pac', che yala: “Tol oj yak' nab,” je chi. Yel ton che yala, chi yak' nab. ");
INSERT INTO knjNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yetoj pax yet chi tit ka'e' bey sur, che yal pax jaxca ti': “Ja' tinani', oj k'axna a oj,” je chi. Yel c'al che yala, tol oj k'axna a oj. ");
INSERT INTO knjNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pero jaexti', caw caab sat jex. Jelan jex ton je na'on el tzet oj jul yu wan che yil satcan tu', c'al sat tx'otx' ti'. Pero, ¿tzet yuxan c'am pax chi na'cha el je yu tzet utbil ye oc jun tiempoal ti' tinani'? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Tzet yuxan c'am che na' tzet yetal watx' yul sat Dios? ");
INSERT INTO knjNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","K'inaloj ta ey junoj mac txequel chach awten sattaj yaaw. Ja' ojab yet lalan ja to yul be yetoj, cha wak'on ja wip ja wa'nen ey yetoj, yet watx' c'am xa chach yi'toj sattaj yaaw tu'. Yutol ta chach apnoj sattaj yaaw tu', catu' chach yaon oc naj yul sk'ab eb policía. Catu' chach yi'ontoj eb preso. ");
INSERT INTO knjNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chi wal e ex, ma jex jajle el oj masanta' c'al tz'ajan che yak' can masanil je multa. ");
INSERT INTO knjNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ja' yet jun tiempoal tu', ey wan eb jix apni sc'atan Jesús. Jix yalontej eb sk'aneal tzet utbil jix yun yak'le cam wan eb a Galilea yu naj Pilato, yet lalan yak'on wan xaambal eb tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jix yalon Jesús tet eb tu' jaxca ti': —¿Tzet yuxan quey tu' jix utele eb a Galilea tu' che na'? ¿Yu mi tol yel xa c'al pena sbeybal eb yintaj yet conob tu'? ");
INSERT INTO knjNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jain chi wal e ex, c'amaj. Pero jaexti', ta c'am che na' je ba yin je penail, oj jex cam je masanil jaxca eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na' wej tej eb waxajlaonwan jix cam bey Siloé tu', yet jix ey q'uey jun na miman stel yiban eb. ¿Tzet yuxan quey tu' jix yun eb che na'? ¿Yu mi tol caw pena sbeybal eb yintaj eb yet a Jerusalén eb tu'? ");
INSERT INTO knjNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jain chi wal e ex, c'amaj. Pero jaexti', ta c'am che na' je ba yin je penail, oj jex cam je masanil jaxca eb tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Catu' jix yalontej Jesús tu' jun k'ane ti' tet eb: —Ja' junel ey jun winaj, ey jun ste'al higo awbil yu sat x'otx'. Jix to yiloni ta ey sat te'. Pero ja' yet jix apni tu', c'am junoj sat te' jix ilcha yu. ");
INSERT INTO knjNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jix yalon tet naj chi mulna sat x'otx' tu' jaxca ti': “Ilala, oxeb xa jabil c'al c'oli wilon jun te' ti' an. C'am c'al junoj sat chi wi' el an. Yuxan tzoc' a oj. Na'ba c'al majbil el tx'otx' ti' yu,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero jix yalon naj ilom mulnail tu' tet naj jaxca ti': “Patrón, c'am to chi cu tzoc' a te' yet jun jabil ti'. Oj wak'le jin k'uon c'uumboj tx'otx' yich, catu' oj waon oc yabonoal. ");
INSERT INTO knjNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ta oj satnoj, watx' ch'al tu'. Ta c'am chi satni xin, oj cu tzoc'on a jaxca cha wal tu',” ẍi naj tet spatrón. ");
INSERT INTO knjNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ja' yet jun sc'ual xewilal eb Israel jix octoj Jesús yul snail sculto eb yet Israelal. Jix c'oli scuywa snan xol eb. ");
INSERT INTO knjNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ey jun ix ix ey ec' titu', waxajlaoneb xa jabil ya' c'al ey yu jun pena espíritu. Eynaj can locan snan ix yu. C'am xa chi jichlo a linan ix. ");
INSERT INTO knjNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ja' yet jix yilon Jesús tol ey ec' ix, jix awteletej ix yu naj sc'atan. Jix yalon naj tet ix jaxca ti': —Txo ix, tol chach wa'xi yin jun ja ya'ilal ti' wu an, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Catu' jix sbatxban oc sk'ab Jesús yiban ix. Yet jun txolan tu', jix jichlo can snan ix. Jix c'oli yalon watx' k'ane ix tet Dios tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ja' naj yaawil snail culto tu', jix tit sjowal naj, yutol ja' yet sc'ual xewilal jix wa'xi can sc'ul ix yu Jesús tu'. Yuxan jix yal tet eb ánima yaman ec' tu' jaxca ti': —Wajebne c'u smoo cu mulna yul semana. Ja' yin wajeb c'ual tu', yal c'al tzet c'ualil chi ske' je yul je yak'on wa'xoj can je c'ul. Pero man smoo oj chi ak'le can wa'xoj je c'ul yet sc'ual xewilal ti', ẍi naj tet eb masanil. ");
INSERT INTO knjNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jix yalon naj Kaawil tu' tet naj jaxca ti': —Ja' jaachti', caw caab sat jaach. Ta ey junoj je wacax, ma junoj je burro pixbil oj yet sc'ual xewilal, ¿tumi c'am che jaj el oj catu' chi to je yak'on yuc' ja'? ");
INSERT INTO knjNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Jal jun ix ix ti', yic'aal naj Abraham ix. Waxajlaoneb xa jabil smitx' a ix yu Satanás, jaxca tol pixbil ix yu. ¿Tumi man smoo oj scolcha can el ix yin sya'ilal yet sc'ual xewilal ti' che na'? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ja' yet jix yalon Jesús jaxca tu', jix q'uixwi a masanil eb ac'ul oc yin naj. Pero masanil eb ánima xin, caw chi tzala eb yilon wan tzet jix el yunen Jesús tu', yutol caw miman yel oc apnoj naj yul sat ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jix yalon pax Jesús jaxca ti': —¿Tzet utbil chi yun ẍ'ib sbisil eb ánima chi oc Dios Yaawil oj che na'? Oj waltej jun k'ane ti' je yabe. ");
INSERT INTO knjNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ja' eb ánima tu', laan eb jaxca junoj jinat mostaza chi yaw junoj ánima sat x'otx'. Ja' jun jinat tu', chi aol oj, chi ch'ibi. Laan chi yun jaxca te' te' mimejtaj. Chi ch'ib te' masanta' c'al chi ske' swey no' tz'iquin xol sk'ablaj, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jix yalon pax Jesús jun xa ti': —Oj waltej jun xa k'aneal ti' e ex, tzet utbil chi yun ẍ'ib sbisil eb ánima chi oc Dios Yaawil oj. ");
INSERT INTO knjNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ja' jun tu', laan jaxca nioj yich pan chi yatoj ix ix xol junoj arroba harina. Yu nioj yich pan tu', chi ch'ib a masanil ixim, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ja' Jesús ja'c'ala' sbey to yul sbeal Jerusalén. Ey wan conoblaj c'al wan aldealaj bey jix ec' naj cuywal. ");
INSERT INTO knjNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ja' yet junel, ey jun mac txequel jix sk'anlen tet Jesús jaxca ti': —Mamin, ¿jaywanne mi eb oj colcha oj? ẍi naj tet Jesús. Jix yalon Jesús tet naj tu': ");
INSERT INTO knjNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Ak' wej je yip je yoc bey jun jaxca yali' puerta. Yutol chi wal e ex, ec'al eb chi yak'le yoqui, pero ma ske' yoc eb. ");
INSERT INTO knjNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yutol ja' Dios, laan jaxca junoj a na. Chi a waan oj, chi smajchen sna. Oj lawoj tu', jaxa jaex chex can linan sti' na tu', oj to je yak'le je yawi octoj jaxca ti': “Mamin, jajon octoj ja wetoj,” je chi tole. “Man wotaj oj jex, catu' man wotaj oj bey ey jex oc oj,” ẍi eltej oj tak'woj. ");
INSERT INTO knjNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Pero ila jix cu low ja wetoj. Jix jon ja cuy yul calle bey cu conob,” je chi oj je yalon tet. ");
INSERT INTO knjNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero oj tak'woj Dios e ex jaxca ti': “Jix wal e ex, tol man wotaj oj jex, catu' man wotaj oj bey ey ex oc oj. Elan nej je masanil jex che yun penail,” ẍi Dios e ex. ");
INSERT INTO knjNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ja' titu' caw oj mi'chcha je c'ul je yok'i. Yu oj je yila tol ey ec' Abraham, Isaac, yetoj Jacob c'al masanil eb ẍejab Dios ey ec' eb bey ey oc Dios yin Yaawil oj. Jal jex pax xin, sti'laj ey jex can el oj. ");
INSERT INTO knjNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ey eb oj tit bey jun jun lugar. Ey eb oj tit bey chi aol c'u, c'al bey chi to can c'u. Ey eb oj tit bey norte, c'al bey sur, catu' oj ey chotan eb low yin meẍa bey ey oc Dios Yaawil. ");
INSERT INTO knjNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ey mac c'am xa c'al nioj yel oc apnoj cu xol tinani'. Pero ja' yet jun tiempoal tu', oj oc eb yin yel miman yel oc apnoj titu'. Ey pax mac caw miman yel oc apnoj cu xol tinani'. Pero ja' yet jun tiempoal tu', oj oc pax eb yin c'am xa nioj yel oc apnoj titu', ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ja' yet jun c'ual tu', jix apni wan eb fariseo. Jix yalon eb tet Jesús jaxca ti': —Asi', elan bey jun lugar ti', yutol chi yoche naj Herodes chach yak' cam oj, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jix yalon Jesús tet eb jaxca ti': —Ja' jun winaj tu', caw jelan ton jaxca junoj no' wax. Asi', al tet naj jaxca ti': “Ilala, tinani' c'al yecal, chi wi' el eb pena espíritu yin eb ánima, catu' chi wak'on pax wa'xoj sc'ul eb ya' ey. Ja' yet caabe, chi lawi c'al can jin mulnail ti', je chi tet naj,” ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero jainti', oj jin bey c'al tinani', yecal c'al caabe. Yutol sowalil asan bey Jerusalén chi ak'le cam eb ẍejab Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Chi wal e ex ti' jex a Jerusalén, che mak' cam eb ẍejab Dios. Ja' wan xa eb chejbiltej yu Dios je xol, che k'ojch'enne eb. Ec'al el jix woche jix jex wawtetej jin c'atan an, jaxca junoj no' caẍlan chi sk'uttetej yune' catu' chi smooni, pero ma yal je c'ul. ");
INSERT INTO knjNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ab wej, ja' jun je conob tu', tz'inini oj yun can oj. Chi wal e ex, c'am xa bey oj je yil win an, masanta' yet oj je yalon jaxca ti': “Kal wej watx' k'ane tet jun chejbiltej yu naj Kaawil ti',” je chi, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ja' yet jun sc'ual xewilal eb Israel jix bet ec' Jesús low bey sna jun yaaw fariseo. C'uxan ey pax wan xa eb yet fariseoal chi majon yila. ");
INSERT INTO knjNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ey jun winaj jix mal a yu jun ya'bil, ey ec' naj sattaj Jesús titu'. ");
INSERT INTO knjNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jix yalon Jesús tet eb cuywam yin sley Moisés tu', c'al tet eb fariseo jaxca ti': —¿Ey mi sleyal chi kak' wa'xoj sc'ul junoj ya' ey yet sc'ual xewilal, ma c'amaj? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero tz'in xa c'al ẍi eb. Jix oc mitx'an Jesús yin naj ya' ey tu'. Jix yak'on can wa'xoj sc'ul naj. Jix yalon tet naj tol chi paxtoj naj. ");
INSERT INTO knjNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jix c'al lawi jun tu', jix yalon tet eb fariseo tu' jaxca ti': —K'inaloj ta ey junoj je burro, ma junoj je wacax chi to yul junoj jolan. Cax c'al sc'ual xewilal, ¿tumi c'am chi to je yi' atej yin eymanil? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pero ma xa na'cha spajtzen nioj eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ja' yet jix yilon Jesús, tzet jix yute sba eb awtebil low yetoj bey jun low tu', tzet utbil tol ja' bey chi ey chotan eb mimej winaj, ja' tu' chi ey chotan eb. Yuxan jix yal tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ta ey bey chex awtele bey junoj k'in nupil, manchej jex ey chotan bey chi ey chotan eb mimej winaj. Tala c'uxan ey junoj xa awtebil yel miman yel oc apnoj je yintaj chi apni. ");
INSERT INTO knjNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jaxa tala yalon naj awtene jex tu' e ex jaxca ti': “Elan yul jun ẍila ti', catu' cha wak'on tet naj ti',” ẍi tala jex utelei. Yuxan, sowalil ja' xol eb c'am nioj yel oc apnoj chex apni. Caw che yak' je q'uixwil oj. ");
INSERT INTO knjNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ja' yet chex awtele tu' xin, yel watx' ja' xol eb c'am yel oc apnoj chex apni chotan oj, yet watx' ja' yet chi jul ec' naj awtene jex tu', chi yal e ex jaxca ti': “Jaach wamigo, asi' eyan chotan bey chi ey chotan eb mimej winaj tu',” ẍi ojab e ex. Jaxca tu' xin, caw miman je yel oc apnoj yul sat eb ey oc je yetoj yin meẍa tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yal c'al mac chi yi' can a sba, oj i'le ey oj, c'am xa nioj yel oc apnoj yet tu'. Pero eb chi yi' ey sba, ja' eb oj i'le can a oj, ja' ton eb miman oj yun yel oc apnoj, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Catu' jix yalon tet naj awtenen tu' jaxca ti': —Ja' yet cha wa'nen miman oj lo'be, manchej ja wawte eb ja wamigo. Manchej ja wawte pax ja mam, c'al ja wuẍtaj, eb ja wican, yetoj eb ja vecino be'om. Yutol ja' eb tu', oj jaach yawte pax eb low yetoj. Jaxa ja cha'on pax sq'uexel ja wet tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero ja' yet cha cha'on junoj ja k'in, asan eb meba' cha wawte low ja wetoj, eb man tz'ajan oj smimanil, jaxca eb coxo', c'al eb c'am chi ske' yilwi. ");
INSERT INTO knjNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ta quey tu' oj ja wute jaxca tu', caw watx' ja wet ch'al tu', yutol ja' eb tu', c'am nioj sq'uexel oj ske' yak'on eb e ach. Pero ja' yet oj pitzc'u a eb watx' sbeybal, ja' yet tu' oj ja cha' spaj ja wet tu', ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ja' yet jix yaben jun naj ey oc yin te' meẍa tu' wan tu', jix yalon naj tet Jesús jaxca ti': —Caw watx' yet eb oj lo'on pan bey ey oc Dios yin Yaawil oj, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jix yalon Jesús jun xa k'ane ti': —Ja' junel, ey jun winaj ec'al ánima jix bet yawtetej low yetoj. ");
INSERT INTO knjNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ja' yet jix a apnoj stiempoal yoc jun lowo tu', jix ẍejontoj jun smoso sto yalon tet eb awtebil yu tu' jaxca ti': “Titan nej, jix apni stiempoal yoc lowo, jix swa'xi,” ẍi naj moso tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero jun jun c'al eb, jix yal eb tol ma ske' sto eb. Jix yalon naj babel jaxca ti': “Tol ey jun jin tx'otx' tol to jix jin mana, sowalil chin to wila. Cha wak' miman c'ulal win an, man oj jin toj an,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jix yalon jun xa jaxca ti': “Tol ey joeb moan jin mulnawom wacax jix jin mana. Sowalil oj jin toj wak' porobal eb, tzet utbil smulna eb. Cha wak' miman c'ulal win an,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jix yalon pax jun xa jaxca ti': “Tol to jix oc wetbi an. Yuxan ma ske' jin toi,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ja' yet jix jul naj moso tu', jix yalon naj tzet c'al jix yute tak'woj sba masanil eb tet. Yuxan caw jix tit sjowal naj patrón tu'. Jix yalon naj tet jun smoso tu' jaxca ti': “Asi' eyman yul-laj calle, c'al yul-laj sbeal jun conob ti'. Cha wi'tej eb meba', eb man tz'ajan oj smimanil, eb coxo', c'al eb c'am chi ske' yilwi,” ẍi naj tet smoso. ");
INSERT INTO knjNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jix lawi sbet ec' jun moso tu', jix yalon tet spatrón tu' jaxca ti': “Mamin, jix jin bet wi' eb jix ja wal tu', pero colan to c'al,” ẍi smoso naj tu' tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jix yalon naj patrón tu' tet naj jaxca ti' junel xa: “Ja' tinani', asi' bey wanoj xa calle sti'laj conob, c'al bey wanoj xa be titu'. Chach to ja wal tet eb ánima sowalil chi tit eb yet watx' oj no jin na ti' yu eb. ");
INSERT INTO knjNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chi wal e ach, c'am junoj eb babel awtebil wu tu' an, oj ske' slow bey jun miman lo'be ti',” ẍi naj patrón, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ja' yet junel, ec'al ánima jix oc tzajan yintaj Jesús. Yuxan jix meltzotoj jacan yin eb catu' jix yalon tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ta ey mac chi yoche chi oc cuywoj wintaj an, pero yel miman yel oc apnoj smam xutx wintaj sna'oni, ma yetbi, ma yuninal, yuẍtaj, yanab, ma sk'inal, ta quey tu' sna'on jaxca tu', tol yel miman yel oc apnoj wan ti' wintaj an. Ma ske' yec' c'al cuywoj wintaj an. ");
INSERT INTO knjNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ja' eb c'am chi yal sc'ul chi yil sya'ilal jin ya'il oj an, eb man bejan oj sc'ul yoc yin culus jin ya'il oj an, ma ske' yec' c'al cuywoj eb wintaj an. ");
INSERT INTO knjNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","K'inaloj ey junoj jex che yoche che wa'ne junoj je na mimantaj che yoche che yute. Ja' yet c'am to che mitx' oc je wa'neni, ¿tumi ta c'am che yi' je cuenta yin sbabelal jantaj tumin chi lawi yin, catu' che yiloni ta chi yab je tumin yu swa'xi jun na tu'? ");
INSERT INTO knjNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ta c'am che yi' je cuenta sbabelal, asanne mi yich chi ey can oj, catu' chi lawi je tumin je yu. Ja' eb chi iloni tol c'am chi lawi je yu, chex tzeele yu eb. ");
INSERT INTO knjNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Chi yalon eb je yin jaxca ti': “Ja' jun winaj ti', jix tz'aj ẍa' oc swa'nen jun na ti', pero ma wa'xoj yu,” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","¿K'inaloj ey junoj rey, chi to yak'le jowal yetoj junoj xa yet reyal, pero asan pax ch'an laoneb oj mil soldado chi yi'toj yetoj. Jal jun xa tu', ey pax junc'al oj mil eb i'bil oc yu. Ja' yet c'am to chi to jun txenne yet tu', tumi ta c'am chi cam sna'on sic'lebil ta oj yak' ganar yetoj eb soldado chi yi'toj tu'? ");
INSERT INTO knjNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ta c'am chi yak' ganar chi yabe, chi yatoj ẍejab bey jun xa rey tu' yet naat to ey. Tol chi sk'anle tzet utbil chi yun stan jun jowal tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yetoj pax oj, yal c'al mac txequel jex c'am chi yal je c'ul che bej can masanil tzettaj yetal ey e ex, ma ske' je yec' c'al cuywoj wintaj an, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ja' atz'am atz'am, watx' atz'am, ey yopiso atz'am. Pero k'inaloj ta chi q'uey sc'a'chi'al atz'am tu', ¿tzet to oj yun sc'a'chi'bi pax oj? ");
INSERT INTO knjNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","C'am xa yopiso. Cax c'al chi ale ey sat tx'otx', cax c'al chi to sc'alil oj abono, tutun c'am xa yopiso. Tuxa c'al chi k'ojle el oj. Ja' wan jix je yab ti', na' wej tej sic'lebil, yutol jaexti', laan jex jaxca atz'am, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Masanil eb tejom el tolabal c'al wan xa eb pena chi el yuneni, jix apni eb yaben sk'ane Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yuxan jix al-le sk'umal Jesús yu eb fariseo c'al eb cuywam yin sley Moisés, jix yalon eb jaxca ti': —Ja' jun winaj ti', chi c'al ẍa' eb pena chi el yunen sc'atan, catu' chi low pax yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Catu' jix yalontej Jesús jun k'ane ti', yet watx' chi na'cha el yu eb. Jix yalon jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—K'inaloj ta ey junoj winaj ey junoj ciento sme' catu' chi q'ueytoj junoj no'. C'am mi chi sbej can wan noventa y nueve no' naj bey ac'al tu' catu' chi to naj seyon ec' jun no' jix q'ueytoj tu', masanta' c'al chi ilcha no' yu naj. ");
INSERT INTO knjNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ja' yet chi txax no' tu' yu naj, chi yi'ontej naj yin tzala c'ulal. ");
INSERT INTO knjNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ja' yet chi apni bey sna xin, chi syamban oc jantaj eb swatx'il ánima naj c'al jantaj eb ey scawilal naj tu', catu' chi yalon naj tet eb jaxca ti': “Ja' no' jin me' jix q'ueytoj an, ja' tinani', jix txax no' wu an, yuxan, tzalan nej wetoj an,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Quey tu', k'inaloj ta ey noventa y nueve ánima watx' chi yute sba, man sowalil oj chi sna' sba sc'ul eb yin spenail sna'oni. C'am mac chi tzala sc'ul yu eb bey satcan tu'. Pero chi wal e ex an, ta ey junoj penawom chi sna' sba sc'ul catu' chi sq'uexponen sna'bal, ja' yu jun ánima tu' xin, tx'oj xa wal tzala c'ulal chi oc bey satcan yu eb ángel. ");
INSERT INTO knjNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ma k'inaloj tinani' ta ey junoj ix ix, ey laoneboj stumin, pero ta chi q'ueytoj junoj ch'en. Tumi c'am chi sejtene ix yul sna tu', chi c'oli sq'uison sna ix tu' yin c'uan c'ulal, catu' chi c'oli seyon ec' ch'en jix q'ueytoj tu' masanta' c'al chi ilcha ch'en yu ix. ");
INSERT INTO knjNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ja' yet chi txax ch'en tu' yu ix, chi syamban oc eb swatx'il ixal ix, c'al jantaj eb ix ey scawilal ix tu', catu' chi yalon ix tet eb jaxca ti': “Ja' ch'en jin tumin jix q'ueytoj an, ja' tinani' jix txax ch'en wu an, yuxan tzalan nej wetoj an.” ");
INSERT INTO knjNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Quey ton tu' chi yun yoc mimej tzala c'ulal bey satcan yu eb ángel, yet chi yilon eb sna'on sba junoj penawom yin spenail catu' chi sq'uexon sna'bal, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jix yalon pax Jesús tet eb jaxca ti': —Ey jun winaj ey cawan sc'aal. ");
INSERT INTO knjNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ja' naj tzunan unin jix yal tet smam: “Mamin, ak' jin tzetal beytet ta' oj wi' tu' an.” Ja' yet jix yak'on naj mame tu' set yetal tu' xin, ");
INSERT INTO knjNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","jix c'oli syamban a set yetal naj tu', catu' jix xonon el naj. Jix to naj bey jun conob caw naat. Ja' titu' jix sq'uey el stumin naj yin spenail. ");
INSERT INTO knjNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ja' yet xax q'uey el smasanil stumin naj tu', jix apni jun miman wail bey jun conob tu', catu' jix c'oli yoc naj yin cus c'ulal. ");
INSERT INTO knjNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Quey ton tu' jix yun sto seyon smulnail naj yintaj jun winaj yul conob tu', catu' jix chejletoj naj bey jun ac'al ilo txitam yu naj. ");
INSERT INTO knjNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jix yochen xa c'al naj slo'on sat te' te' naj chi slo' no' txitam tu', yutol caw chi nocha naj, pero c'am mac chi ak'on nioj slo'be naj. ");
INSERT INTO knjNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Quey to tu' jix yun sna'oni: “¿Tzet yuxan, quey tu' chi wute jin ba an? ¿Tumi jantaj eb naj smoso naj jin mam an, catu' chi yak' pax sobra lo'be tet eb naj? Jal jin pax an xin, chi wak' cam jin ba yu wail titi' an,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Oj jin paxtoj bey sna naj jin mam tu' an, catu' oj walon tet naj: “Mamin, jix oc jin mul tet Dios an, catu' jix oc pax jin mul e ach an. ");
INSERT INTO knjNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Man xa jin moo oj chin ja wal oc ja c'aal oj an, jaxca junoj ja moso chi wun oc an,” ẍi naj yin sna'bal. ");
INSERT INTO knjNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Catu' jix a linan naj, jix to bey smam tu' xin. Ey to wal yapni naj sc'atan smam tu', catu' jix yilontoj naj mame tol ja' sc'aal naj chi apni, eyman jix to naj ẍa'on sc'aal tu'. Jix oc lacan naj yin naj, catu' jix oc pax tz'uban naj yin sti' naj yu tzala c'ulal. ");
INSERT INTO knjNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ja' naj c'aale tu', jix yal naj tet smam jaxca ti': “Mamin, jix oc jin mul tet Dios an, catu' jix oc jin mul e ach an, catu' man xa jin moo oj chin ja wal oc ja c'aal oj an,” ẍi naj tet smam. ");
INSERT INTO knjNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ja' naj mame tu', jix yal naj tet eb moso ye yintaj jaxca ti': “Eyman, i' wej tej an pichile caw watx' yili, catu' che yaon oc an yin naj, catu' che yaon oc scolk'ab naj, catu' che yaon pax oc xanab naj. ");
INSERT INTO knjNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","I' wej pax tej no' wacax lo'tzebil, catu' che potx'on cam no', tol oj cu low wej, catu' oj oc sk'inal naj. ");
INSERT INTO knjNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yutol ja' jun jin c'aal ti', quichan tol camnaj xa ye naj, ja' tinani', jix pitzc'u a naj. Q'ueynaj ta' toj naj, pero ja' tinani', jix yak' jul sba naj,” ẍi naj mame tu'. Catu' jix oc sk'inal naj tu' xin. ");
INSERT INTO knjNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ja' yet jix apni naj tzunan unin tu' xin, c'am naj babel c'aale ey ec' oj yutol ey to naj mulnail. Ja' yet jix apni naj babel c'aale tu' scawilal na xin, jix yaben naj tol lalan yoc bit' c'al canal. ");
INSERT INTO knjNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jix yawtentej jun smoso smam naj tu', jix sk'anlen naj tet: “¿Tzet yuxan ey jun k'in ti'?” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jix tak'wi naj moso tu' tet naj, jix yalon naj jaxca ti': “Yu naj ja wuẍtaj jix juli, yuxan ey oc k'in ti'. Jix mak'le cam no' wacax lo'tzebil yu ja mam, yutol jix jul naj ja wuẍtaj tu' yin tzala c'ulal,” ẍi naj moso tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ja' naj babel c'aale tu' xin, jix tit sjowal naj sic'lebil. Ma ẍa' sc'ul naj yoctoj naj yul na yu sjowal sc'ul tu' xin, masanta' c'al jix eltej naj mame, jix jul smonten naj, yet watx' chi octoj yul na tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Catu' jix tak'wi naj tet smam jaxca ti': “Ilala, ey xa tiempo jaach c'oli wak'on servil an, catu' c'am bey pena chi wute jin ba e ach an. Jainti', caw jijyom jin c'al e ach an. Pero c'am junel oj cha wak' pax junoj yune' jin chiw jin chi' yetoj eb naj jin watx'il ánima an. ");
INSERT INTO knjNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Jal yet chi jul jun naj ja c'aal jix bet q'ueyon can el ja tumin yin spenail yetoj eb ix xec' ix ix, cha mak'on pax cam no' wacax lo'tzebil,” ẍi naj tet smam. ");
INSERT INTO knjNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Catu' jix yalon naj mame tu' tet naj jaxca ti': “Cha c'aal, jaachti', ey jaach c'al ta' ec' wetoj an. Ja' masanil jin tzet yetal an, ja wet c'al ta' ye wetoj an. ");
INSERT INTO knjNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ja' tinani' xin, smoo ton cu cha'on sk'inal naj ja wuẍtaj ti', c'al cu tzala yu naj, yutol ja' jun ja wuẍtaj ti', quichan tol camnaj xa ta' ye naj, ja' tinani', jaxca tol jix pitzc'u a naj. Q'ueynaj ta' toj naj pero ja' tinani', jix yak' jul sba naj,” ẍi naj mame tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jix yalon pax Jesús tet eb scuywom jaxca ti': —Ey jun naj be'om ey jun smaromo naj. Jix yabtej naj be'om, tol lalan sq'ueyle el stumin naj yu naj maromo tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ja' naj patrón tu', jix awteletej naj, catu' jix yalon tet naj jaxca ti': “Ey jun chi wab ja win an. Ja' tinani', sowalil cha wak' cuenta yu ja wopiso ti', c'am xa chi ske' chach mulna wintaj an. Man xa chach oc jin maromo oj an,” ẍi naj tet smaromo tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Catu' jix sna'on naj maromo tu' jaxca ti': “¿Tzet oj wun an? C'am xa jin mulnail an, pero c'am wip an jin k'uo tx'otx' an, catu' chin q'uixwi jin k'anon tumin an,” ẍi naj yul sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Catu' jix sna'on naj jaxca ti': “Wotaj tinani', tzet oj wun an, yu yet chi tan el wopiso an ey xa eb wamigo chin cha'on an,” ẍi naj yul sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jix c'oli yawten eb ey sjec' tet spatrón tu' yin jun jun tajil. Jix sk'anlen tet naj babel jix jul jaxca ti': “¿Jantaj ja jec' tet jin patrón?” ẍi naj tet. ");
INSERT INTO knjNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Cien barril aceite comer jin jec' tet naj,” ẍi naj. “Ta quey tu' ja jec' aceite tu' xin, ja' jun yuunal ja jec' ti'. Eyan chotan oj, wa'ne junoj xa, cincuentane cha wute ja tz'iben can oc yin,” ẍi naj maromo tu' tet. ");
INSERT INTO knjNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jix lawi c'al tu', catu' jix sk'anlen tet jun xa. “Jal jaach, jaachti', ¿jantaj ja jec'?” ẍi naj tet. “Jainti', cien quintal trigo jin jec' tet naj,” ẍi jun xa tu'. “Ta quey tu' xin, ja' yuunal ja jec' tu'. Ochenta quintalne chi yun ja tz'iben can oc yin,” ẍi naj tet. ");
INSERT INTO knjNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jix yalon naj patrón tu', tol jelan jun maromo tu' yin elk'an, yuxan ja' eb yul yiban k'inal ti', yel xa c'al jelan chi yute sba eb yin yul yet yintaj eb ey xa saj k'inalil Dios yin spixan. ");
INSERT INTO knjNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Chi wal e ex, ja' ch'en tumin, comon c'al chi to ch'en yin spenail. Pero ja' je yet jaexti' xin, yin ojab swatx'ilal che k'anbalne, yet watx' ey eb oj je yamigone je ba yetoj. Ta quey tu' che yute jaxca tu', ja' yet oj lawoj yoc yopiso jun ch'en tumin tu' je yu, Dios oj cha'on je yapni bey ey jun je na yin junelne. ");
INSERT INTO knjNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ja' eb watx' c'al chi yute sba yetoj nioj tzet yetal chi ak'le yul sk'ab, ta tol miman pax tzet chi ak'le yul sk'ab eb tu', watx' c'al chi yute pax sba eb yetoj. Jal eb pena chi yute sba yetoj nioj tzet yetal chi ak'le yul sk'ab eb tu' xin, yetoj pax oj, cax c'al miman tzet chi ak'le yul sk'ab eb, man c'al ta' watx' oj chi yute sba eb yetoj. ");
INSERT INTO knjNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yuxan, ta man watx' oj che yute je ba yetoj sbe'omal bey yul yiban k'inal ti', ¿tumi oj ak'le yul je k'ab ja' caw be'omal ey bey satcan, che na'? ");
INSERT INTO knjNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yetoj pax oj, ta man watx' oj che yute je ba yetoj tzet man je yetoj, ¿tumi ta chi ak'le yul je k'ab wan tzet yetal caw je yet ey bey satcan? ");
INSERT INTO knjNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","C'am junoj mac txequel chi ske' jun laan c'al yak'on servil cawan oj spatrón. Yutol ja' naj chi scajle sba yetoj junoj, catu' chi scam c'ulne sba pax yetoj junoj xa. Ey jun chi sjije naj tzet chi yala, catu' jun xa c'am yel oc apnoj yul sat naj. Yuxan c'am chi ske' jun laan je cam c'ulnen je yak'on servil Dios c'al je cam c'ulnen ch'en tumin, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ja' yet jix yaben eb fariseo tzettaj jix yal Jesús tu', tutun asan yin stumin eb ey oc sna'bal. Yuxan jix buchwa eb yin Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jix yalon naj tet eb jaxca ti': —Jaexti', asan sattaj eb ánima watx' che yute je ba. Pero yotaj Dios tzet utbil yili je pixan. Ja' wan tzet miman yel oc apnoj yul sat ánima, c'am chi ẍa' sc'ul Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ja' sley Moisés c'al tzet tz'ibebil can yu eb ẍejab Dios peyxa, jix oc yopiso masanta' c'al jix jul naj Juan Bautista. Jal tinani' xin, yet tax c'al jix jul naj Juan tu', jix el yich yal-le watx' k'ane tzet utbil chi yun yoc Dios yin Yaawil oj eb, catu' ec'al eb chi yak' yip yoc yin jun ey oc Yaawil tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pero yel xa c'al ya'taj stan el jun sletrail jun ley tu' yintaj tet stan el satcan c'al sat tx'otx' ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ta ey junoj winaj chi spo'le sba yetoj yetbi, catu' chi yi'on junoj xa ix, mul chi yun jun winaj tu' jaxca tu'. Ja'c'ala' junoj winaj chi i'on junoj ix ix chi spo'le sba yetoj yichamil, mul chi yun pax oj, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Catu' jix yalon Jesús jun xa k'aneal ti': —Ja' junel, ey jun winaj caw be'om. Ja' an pichile caw ey stool chi yaoc naj. Watx' c'al tzet chi slo' jun jun c'u. ");
INSERT INTO knjNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ey pax jun winaj chi yij Lázaro, caw meba' naj. Ey wan mimej ya'bil ey oc yin naj. Asan c'al sti' sna jun be'om tu' chi bet ey chotan naj. ");
INSERT INTO knjNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Chi yochen naj chi slo' sc'ail slo'be jun be'om tu' chi ey c'otlaboj yalan smeẍa. Ja' wan no' tx'i' chi jul ec' oj, ja' no' chi lek'on sat wan ya'bil ey oc yin naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jix jul sc'ual scam naj xin, jix i'letoj spixan naj yu eb ángel. Jix apni naj sc'atan naj Abraham bey jun lugar chi yij Watx'ilal. Ja'c'ala' jix jul pax sc'ual scam jun be'om tu'. Jix muji naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pero ja' spixan, ja' jix apni bey ey spixan eb camnaj. Ja' yet lalan yaben sya'il bey jix apni tu', jix a t'anan oj. Jix yilontoj cawan ánima naat. Ja' naj Abraham yetoj naj Lázaro ey ec' eb scawanil. ");
INSERT INTO knjNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jix a yaw naj tu', catu' jix yalon jaxca ti': “Mamin Abraham, c'am mi chi ok' ja c'ul win an. Cha chejtej naj Lázaro jin c'atan jin k'an an. Ya ojab eytoj yiximal sk'ab naj xol ja' chi jul yaon octoj naj yul jin ti' an, yutol ey jin ec' xol sya'tajil xol k'ak' ti' an,” ẍi naj be'om. ");
INSERT INTO knjNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Jix yalontej naj Abraham tu' tet naj jaxca ti': “Jaach wuẍtaj, na'tej caw watx' jix yun ja wec' yul yiban k'inal tu'. Jal pax naj Lázaro ti' xin, caw c'am nioj swatx'ilal jix yil naj. Jal tinani' xin, lalan ẍa'on smimanil sc'ul titi'. Jal jaach lalan ja waben sya'il tinani'. ");
INSERT INTO knjNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yetoj pax oj, ey jun miman jo'be naat yich snan cu xol wej. Yuxan, cax c'al ey eb ey ec' titi' chi yoche chi to e ex tu', c'am chi ske' sk'axpon eb. Yetoj jex pax oj, c'am chi ske' je k'axpon ec'tej titi',” ẍi naj Abraham tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ta quey tu' xin, Mamin Abraham, c'am mi cha chejtoj naj Lázaro tu' bey sna naj jin mam an, ");
INSERT INTO knjNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","bey ey ec' jowan wuẍtaj an. Chi to yalon yab eb, yet watx' c'am chi jul eb wetoj xol sya'ilal bey ey jin ec' ti' an,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Pero ja' eb ja wuẍtaj tu', ey ec' tzet jix s'ibe can Moisés c'al tzet jix s'ibe can eb ẍejab Dios tet eb. Yab ojab eb wan k'ane tz'ibebil can tu',” ẍi naj Abraham tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Yel ton Mamin Abraham, pero ta chi yil eb junoj mac txequel jix pitzc'u a xol eb camnaj, oj sna' sba sc'ul eb yin spenail,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ta c'am chi yab eb wan tzet tz'ibebil can yu Moisés tu', c'al wan tz'ibebil can yu eb ẍejab Dios tu', cax c'al ey junoj mac txequel chi pitzc'u a xol eb camnaj tu', ma c'al ta' yaoc eb yin sc'ul,” ẍi naj Abraham tu' tet naj, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jix yal Jesús tet eb scuywom jaxca ti': —Sowalil chi jul wan tzet yetal chi i'on etex el cu na'bal. Pero ok'bal c'ule eb chi ak'on etex el sna'bal yet animail. ");
INSERT INTO knjNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ta ey mac chi ak'on etex el sna'bal junoj unin, yel watx' yet ta chi pixle oc t'unan junoj miman ch'en yin snuk', catu' chi k'ojle eytoj xol ja' mar, yet watx' c'am to chi ak'le etex el sna'bal jun unin tu' yu, catu' oj ẍa'on spaj yu jun tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yu tu' xin, il wej c'al je ba. Ta ey junoj je yet animail chi oc spenail e ex, che tenchane yin spenail tu'. Ta chi sna' sba sc'ul, che yak' miman c'ulal yin junelne. ");
INSERT INTO knjNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Cax c'al chi oc spenail e ach jujeloj chi ec' c'u, ta chi bet sk'an miman c'ulal jujeloj e ach jaxca ti': “Man xa oj wun junel xa,” ta ẍi, sowalil che yak' miman c'ulal yin, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jix yal eb ẍejab naj Kaawil tet jaxca ti': —Chi cu k'an e ach, cha wak' kaoc cu c'ul yin Dios, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jix yalon Jesús tet eb jaxca ti': —Ta yel che yaoc Dios yin je c'ul, cax c'al nian ch'an che yute je yaon oc yin je c'ul jaxca junoj sbak' mostaza, oj ske' je yalon tet junoj mimej te' ti' jaxca ti': “I' atej ja ba yetoj c'al ja xe'. Asi' xol ja' mar, ja' ta' tu' chi to ja waw eytoj ja ba,” ta je chi tet, oj sjije tzet oj je yala. ");
INSERT INTO knjNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","K'inaloj ey junoj cu moso chi cu ak'on servil. K'inaloj ey ec' mulna yin ket, ma ilo no' me' ey ec' oj. Ja' yet chi jul pax naj, “Ocan, eyan chotan oj, lowan,” ¿tumi ta cu chi tet? ");
INSERT INTO knjNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","C'amaj, “Wa'ne tzet oj jin lo' an. Cha balon a sk'ab ja camiẍ, yajban chin lowi cha batxontej wan xa tzet chin lo' an. Oj to lawoj tu' catu' oj jaach low oj,” tejan cu chi tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Tumi ta chi kal pax yu diosalil tet jun cu moso tu' yu jix sjije yunen tzet jix kal tet tu'? C'amaj. ");
INSERT INTO knjNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jaxca ton junoj moso tu', quey jex ton tu' jaexti'. Ja' yet jix lawi je jijen masanil tzet chi chejle je jije yu Dios, smoo che yal jaxca ti': “Jaonti', cax c'al yak'omal jon servil Dios, caw c'am kel oc apnoj nioj, yutol asan tzet cu cuenta kunen jix kune,” je chi, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ja' yet lalan c'al sto Jesús yul sbeal Jerusalén, jix ec'toj naj bey smoon Samaria yetoj Galilea. ");
INSERT INTO knjNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ja' yet jix apni scawilal jun aldea, ey laonwan winaj ey ec' sti' be. Ya' ey eb yu jun ya'bil chi k'a'toj ánima yu, chi yij lepra. Yuxan jix apni eb scawilal Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jix a yaw eb yin ipal jaxca ti': —Jesús, c'am mi chi ok' ja c'ul kin, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ja' yet jix yilon Jesús yin eb naj, jix yalon jaxca ti': —Asi', tx'ox wej je ba tet eb yak'omal xaambal tet Dios, ẍi Jesús tet eb naj. Ja' yet lalan sto eb tu', jix el jun ya'bil yin eb slaonwanil. ");
INSERT INTO knjNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ey jun xol eb jix yila, tol jix el ya'bil yin, jix meltzo yin eymanil. Jix yalon watx' k'ane tet Dios yin ipal. ");
INSERT INTO knjNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jix apni sc'atan Jesús, jix ey kaan yajantaj. Jix ey noan oj, masanta' jix ey xa c'al pitxan sat tx'otx'. Jix yalon yu diosal tet Jesús. Ja' naj jix meltzo tu', a Samaria naj. ");
INSERT INTO knjNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jix yalon Jesús tet eb ey ec' titu' jaxca ti': —¿Tumi man laonwanoj eb jix wa'xi sc'ul? Jal pax balonwan xa eb tu', ¿beytu' ey oc eb? ");
INSERT INTO knjNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tol asan ch'an jun naj ti' jix meltzo yu yalon yu diosalil tet Dios. Pero ilala, man pax ket conob oj naj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Catu' jix yalon Jesús tet naj jaxca ti': —Aan linan oj, paxantoj. Tol jix wa'xi ja c'ul yutol jix ja waoc ja c'ul yin Dios, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ey wan eb fariseo jix sk'anlen tet Jesús jaxca ti': —¿Bak'in oj jul stiempoal oj swa'xi oc Dios Kaawil oj? ẍi eb tet Jesús. —Ja' yet oj oc Dios Kaawil oj, c'am chi ske' kilon yetoj cu sat. ");
INSERT INTO knjNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma ske' kalon jaxca ti': “Tol ja' titi', ma tol ja' titu',” man cu chi oj. Yutol ja' yin cu pixan jun jun jon ey oc Dios Kaawil oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Catu' jix yalon tet eb scuywom jaxca ti': —Ey jun tiempoal oj jul oj, catu' oj je yalon jaxca ti': “Tol oj wal chi jul jun Ak'bil Yopiso yu Dios xol eb ket animail junel xa, cax c'al jun ojab ch'an c'u,” je chi oj je yaloni. Pero man oj jul oj. ");
INSERT INTO knjNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ey eb oj alon e ex jaxca ti': “Tol ja' titi',” ma, “Tol ey ec' titu',” ẍi eb oj yalon eb. Pero manchej jex oc tzajan yintaj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yutol jaxca yet chi letz'lon c'u caw miman txequel, quey tu' oj yun jin jul yet jun c'ual jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an. ");
INSERT INTO knjNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero ja' tinani', sowalil oj wab sya'il sic'lebil. Oj jin intajnele el yu eb ánima yet jun tiempoal ti' an. ");
INSERT INTO knjNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ja' yet oj jin jul pax oj, jaxca tzet jix yun yul stiempoal naj Noé, quey tu' tzet oj yun eb yet oj jin jul tu' an. ");
INSERT INTO knjNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yutol ja' ánima yet jun tiempoal tu', tol chi low eb, chi yuc' ja' eb. Ey eb tol chi oc yetbi. Ey eb chi yatoj scutz'in alibeal. Toj chi sna' eb ta ey tzet oj jul yiban eb. Quey c'al tu' chi yun eb, masanta' c'al yet jix jul sc'ual yoctoj Noé yul te' arca. Jix jul jun miman nab tu', catu' jix cam masanil eb. ");
INSERT INTO knjNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ja'c'ala' pax yul stiempoal naj Lot. Toj ey pax tzet chi sna' ánima. Tol chi low pax eb c'al yuq'uen ja' eb. Chi manwi eb, chi txonwi eb. Chi awalwi eb. Chi swa'nen sna eb. ");
INSERT INTO knjNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero ja' yet jix eltej naj Lot bey conob Sodoma tu', jix eyol k'ak' yetoj wan ch'en coc' ch'en caj xininaj yili yu s'a'toj. Jaxca xa c'al yey nab, quey xa c'al tu' stit ch'en satcan tu'. Yuxan jix cam masanil ánima yu. ");
INSERT INTO knjNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jaxca jix yun yet jun tiempoal tu', quey tu' oj yun yet jun c'ual yet oj jin jul an, jain, Ak'bil Wopiso yu Dios xol eb ket animail an. ");
INSERT INTO knjNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ja' yet jun c'ual tu', ja' mac ey atoj ẍumuc spananil sna, cax c'al ey settaj yetal ey can yul na tu', manchej ec' je yi'toj. Yetoj eb eytoj bey smulnail, manchej jex to bey je na. ");
INSERT INTO knjNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Na' wej tej tzet jix tit yiban ix yistil naj Lot. ");
INSERT INTO knjNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ja' eb c'am chi yoche chi cami, chi sbej can jun k'inale eb tol ey c'al yin tobal k'inal. Jal pax eb bejan sc'ul scam jin ya'il oj an xin, ja' ton eb tu' oj i'on k'inale tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Chi wal e ex, k'inaloj ey cawanoj mac txequel chi wey sat x'at yet jun ak'bal tu', jun oj i'letoj, jun oj can oj. ");
INSERT INTO knjNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","K'inaloj ey cawanoj ix lalan scawni, jun oj i'letoj, jun oj can oj. ");
INSERT INTO knjNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","K'inaloj ta ey pax cawanoj winaj junne chi mulnai, jun oj i'letoj, jun oj can oj. Ja' wan oj i'letoj ja' ton eb ey oc sc'ul yin Dios, ẍi Jesús tet eb scuywom tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ja' yet jix yaben eb wan tu', jix sk'anlen eb tet jaxca ti': —Wuẍtaj, ¿Beytu' oj yun oc jaxca tu'? ẍi eb. —Yal c'al bey telan can junoj mimanile camnaj xa, ja' tu' chi syamba sba no' mij. Quey tu' oj yun je yotajne el oj yet oj je yilon jun lugar tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jix yaltej Jesús jun k'aneal ti' tet eb scuywom, yu yalon yab eb, tol watx' chi txali c'al eb tobal k'inal, catu' c'am chi isabi a eb. ");
INSERT INTO knjNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jix yalon tet eb jaxca ti': —Ja' junel, ey jun naj yaaw bey jun conob. C'am yel oc apnoj Dios yul sat naj. C'am pax yel oc apnoj eb yet animail naj yul sat. ");
INSERT INTO knjNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ja' bey jun conob tu', ey jun ix ix camnaj xa yichamil. Jun jun c'al c'u chi apni ix sattaj naj yaaw tu'. Chi apni yalon ix jaxca ti': “Ey jun ánima ac'ul oc win an. ¿C'am mi chin ja wa'ne el yetoj?” ẍi ix. ");
INSERT INTO knjNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pero c'am c'al chi yal sc'ul naj chi swa'ne jun jowal tu'. Yuxan, ja'c'ala' sjul ec' ix yalon sba. Pero niẍtejal jix sna'on naj jaxca ti': “Jainti', c'am yel oc apnoj Dios yul jin sat an. C'am pax yel oc apnoj junoj ánima yul jin sat an. ");
INSERT INTO knjNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pero ja' jun ix ix ti', jun jun c'al c'u jaxca ti' yul ec' ix jin c'atan an. Yuxan, oj jin wa'ne ye jun jowal ti' tet ix an. Ta c'amaj, ma xa techa ix wu an, ta ja'c'ala' sjul ec' ix jin c'atan an,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Quey tu' jix yute sna'on naj yaaw pena sna'bal tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Jal pax Dios, ¿ma yal sc'ul swa'ne el tzet chi jul yal eb sic'bil el yu tet yet c'ualil c'al ak'balil? ¿tumi miman tiempo oj ec' oj, catu' oj swa'ne el Dios tzet chi yoche eb tu'? ");
INSERT INTO knjNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Chi wal e ex, oj wa'nele el eb yu Dios yin eymanil. Pero ja' yet oj jin jul junel xa, jain, Ak'bil Wopiso yu Dios xol eb ket animail an, ¿ey mi c'al eb chi yaoc sc'ul yin Dios yul yiban k'inal ti'? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ja' jun xa sk'aneal ti', jix yaltej Jesús tet wan eb watx' sbeybal yaloni. Ja' eb tu', c'am swatx'il wanoj xa ánima yul sat eb. Yuxan jix yal Jesús tu' tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ey cawan winaj jix bet ec' txaloj bey stemplo Dios, fariseo jun, tejom el tolabal jun xa. ");
INSERT INTO knjNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ja' jun fariseo tu', linan a oj, catu' jix txali jaxca ti': “Jaach jin Diosal, chi wal yu diosal e ach an, yutol jainti', man laan oj jin jaxca wanoj xa ánima an. Ja' eb ánima tu', caw elk'om eb, man watx' oj sbeybal eb, chi mulwi eb. Yetoj pax jun naj tejom el tumin ti', yu wal dios yutol man laan oj jin yetoj naj an. ");
INSERT INTO knjNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yutol jainti', cael chi wijle nocha jin ba jun jun semana. Yetoj pax oj, chi wak' sdiezmoal masanil tzet chi wak' ganar,” ẍi naj chi tz'aj yalon naj tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ja' jun tejom el tumin tu', naat ta' linantej. Caw chi xiw sc'ul, ma a t'anan nioj satcan, tu' c'al jix mak' xam sc'ul yu scus c'ulal. Jix yaloni: “Jaach jin Diosal, c'am mi chi ok' nioj ja c'ul win an, caw penawom jin sic'lebil an,” ẍi naj tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Chi wal e ex, ja' naj tejom el tumin tu', yet xa c'al jun txolan tu', jix al-le naj watx'il yu Dios, yet c'am to chi paxtoj naj bey sna. Jal naj fariseo tu' xin, ma yal Dios tol watx' naj yul sat. Yutol ja' mac chi yi' a can sba, chi i'le eytej. Jal mac chi yi' ey sba, chi i'le a oj, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ey mac jix i'ontej wan unin sc'atan Jesús, yu yaon atoj sk'ab naj yiban sjolom eb. Pero ja' yet jix yilon eb scuywom jaxca tu', jix tenon oc tucan eb chi i'ontej eb unin tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jix yalon naj tet eb jaxca ti': —I' wej tej eb unin e in an. Manchej je tenoc tucan eb chi i'ontej eb unin. Yutol asan eb ey oc sna'bal yin Dios jaxca eb unin ey oc sna'bal yin smam xutx, asan eb ey yalon yet yoc Dios Yaawil oj. ");
INSERT INTO knjNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Caw yel chi wal e ex, ja' eb c'am chi cha'on Dios Yaawil oj jaxca chi yun sjijen eb unin tzet chi al-lei, c'am bak'in oj oc eb yul sk'ab Dios, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ey jun naj yaaw jix k'anlen tet Jesús jaxca ti': —Mamin, watx' jaach, yuxan chin k'anle e ach an, ¿tzet yetal sowalil chi wun an, catu' chi wi'on k'inale tol ey c'al yin tobal k'inal an? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","—¿Tzet yuxan chin ja wal watx'il? C'am junoj mac watx', asan Dios watx'. ");
INSERT INTO knjNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ja wotaj xa wan chejbanil chi alon jaxca ti': “Manchej oc ja mul yul sk'ab ja wetbi. Manchej jaach mak'wi cam ánima. Manchej jaach elk'anwi. Manchej ja na' a k'ane yin ja wet animail. Ey ojab yel oc apnoj ja mam ja txutx yul ja sat,” ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Yin tax jin yali'al jix c'oli c'al jin jijen masanil wan chejbanil ti', ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","—Pero ey jun sowalil to cha wune. Yuxan asi', txon can el masanil ja tzettaj yetal, catu' cha po'ontoj stool xol eb meba', yet watx' oj ja cha' ja be'omal bey satcan. Chi lawi jun tu', chach jul pax jin c'atan junel xa an, catu' chach ec' c'al cuywoj wintaj an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ja' yet jix yaben naj wan tu', caw jix cus a sc'ul naj, yutol caw be'om naj sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ja' yet jix yilon Jesús tol jix cus a naj, jix yalon jaxca ti': —Ja' eb be'om ti', caw ya'taj yoc Dios Yaawil oj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","K'inaloj junoj no' camello. ¿Tumi ta chi ec' el no' yul yixal junoj acuẍa? Yel xa c'al ya'taj yoc Dios Yaawil oj eb be'om tet yet chi ec' el no' yul yixal junoj acuẍa, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jix yalon eb jix yaben wan k'ane tu' jaxca ti': —Ta quey tu' jaxca tu' xin, ¿mac wal junoj chi ske' scolchai? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","—Ja' wan tzet c'am chi ske' yu ánima, ja' Dios chi ske' yu, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jix yalon naj Pedro tu' tet Jesús jaxca ti': —Wuẍtaj, jaonti', jix cu bej can masanil cu tzettaj yetal, catu' jix cu ec' c'al cuywoj ja wintaj, ¿tzet oj yun kel oc apnoj jaonti'? ẍi naj Pedro. ");
INSERT INTO knjNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jix yalon Jesús tet eb tu' jaxca ti': —Caw yel chi wal e ex, ja' eb chi sbej can sna, yistil, smam, xutx, yuẍtaj, yanab, yuninal, jin ya'il oj, catu' asan Dios chi yoche chi yak' servil. ");
INSERT INTO knjNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Yel xa c'al miman oj ẍa' eb yet jun tiempoal ti'. Jaxa yet jun tiempoal oj jul ya toj tu', ja' ta' tu', oj ẍa' eb sk'inal tol ey c'al yin tobal k'inal, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jix yawten eb lacawan scuywom Jesús tu' xojli. Jix yalon tet eb jaxca ti': —Ja' tinani', tol lalan cu to bey Jerusalén. Ja' tu' oj yun el masanil tzet tz'ibebil can yu eb ẍejab Dios peyxa, yet jix yalon can el jin k'aneal eb, jain, Ak'bil Wopiso yu Dios xol eb ket animail an. ");
INSERT INTO knjNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Catu' oj jin ale oc yul sk'ab eb man Israel oj. Oj jin sbuchon eb. Oj yalon eb tzet yetal pena win an. Catu' oj tz'ubloj oc eb win an. ");
INSERT INTO knjNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Oj jin smak'on pax eb. Oj lawoj tu', catu' oj jin yak'on cam eb. Pero yoxial tu', oj jin pitzc'u pax a oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero ma na'cha el nioj yu eb. Man yotaj oj eb nioj tzet chi yal yel oc apnoj wan jix yal tu', yuxan ma na'cha el yu eb. ");
INSERT INTO knjNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ja' yet lalan yapni Jesús bey conob Jericó, ey jun naj c'am chi ske' yilwi, chotan ey naj sti' be. Lalan sk'anon sa'beal tet ánima chi ec' yul be tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ja' yet jix yaben naj tol ec'al ánima chi bilwi yec' yul be tu', jix sk'anlen naj yabe, tzet yuxan ec'al eb chi eq'ui. ");
INSERT INTO knjNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jix al-le tet naj, tol ja' Jesús a Nazaret chi eq'ui. ");
INSERT INTO knjNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yuxan jix a yaw naj yin ipal jaxca ti': —Jesús, Yic'aal naj David, ¿c'am mi chi ok' ja c'ul win an? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ja' eb babel sattaj naj Jesús tu', jix tenchanele naj c'am chi ilwi tu' yu eb, yet watx' chi tz'ini naj. Pero ja' yet jix yaben naj jaxca tu', tol jix a sjowal yel yaw naj: —Mamin, Yic'aal naj David, ¿c'am mi chi ok' ja c'ul win an? ẍi naj junel xa. ");
INSERT INTO knjNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jix oc linan Jesús tu', jix yalon Jesús yu stit naj. Ja' yet jix apni naj sc'atan Jesús, jix sk'anlen tet naj jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Tzet cha woche chach wute an? ẍi Jesús tet naj. —Mamin, chi woche cha jaj jin sat ti' an, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Jajcha ojab can ja sat. Tol jix wa'xi, yutol jix ja waoc ja c'ul win an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ja' yet jun txolan tu', jix jajcha sat naj, jix yilon naj. Yuxan jix oc tzajan naj yintaj Jesús. Jix yalon watx' k'ane naj tet Dios. Yetoj pax masanil eb jix ilon jun tu', jix yal watx' k'ane eb tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jix apni Jesús bey conob Jericó. Catu' jix ec'ab yul conob tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ey jun winaj be'om titu', Zaqueo sbi naj. Yaaw tejom el tolabal bey jun conob tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ja' naj Zaqueo tu', caw chi yoche c'al chi yil yin Jesús, tzet utbil yili, pero c'am c'al chi ske' yiloni, yutol ec'al ánima chi to bululoj yin sc'ul naj yet chi beyi. Yetoj pax oj yu yali' stel naj Zaqueo tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yuxan jix babitoj naj sattaj catu' jix atoj sk'ab jun te' sicómoro sti' be tu', catu' oj yilon yin Jesús yet oj ec' yich tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ja' yet jix ec' el naj yich te' te' tu', jix atoj t'anan Jesús yin naj catu' jix awi atoj Jesús tet naj jaxca ti': —Zaqueo, eyantej eyman, yutol ja' bey ja na oj jin apnoj wak' jin posada, ẍi atoj Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jix yab c'al naj Zaqueo jun tu', catu' jix eytej yin eymanil. Catu' jix cha'le apnoj Jesús yin tzala c'ulalil bey sna. ");
INSERT INTO knjNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ja' yet jix yilon eb ánima jaxca tu', caw ey tzet chi yal eb yin Jesús tu', yutol jix apni yak' sposada bey sna jun pena sbeybal. ");
INSERT INTO knjNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Catu' jix a linan naj Zaqueo tu', catu' jix yalon tet naj Kaawil tu' jaxca ti': —Ja' tinani' Mamin, jantaj tzet ey e in an, snan c'al oj wak' tet eb meba'. Ta ey eb jix wetne an, ta ey eb jix welk'ane stumin eb an, canel oj yun wak'on sq'uexel tet eb an, ẍi naj Zaqueo tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jix yalon Jesús tu' jaxca ti': —Ja' tinani' jix jul scolbanil spixan eb bey jun na ti'. Ja' naj Zaqueo ti', caw yel yic'aal naj Abraham. ");
INSERT INTO knjNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Jainti' Ak'bil Wopiso yu Dios xol eb ket animail an, jix jin jul yu jin seyon eb q'ueynajtoj, catu' chi colon can el eb an, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ja' yet lalan yaben eb tzet chi yal Jesús, ey jun sk'aneal jix yaltej tet eb, yutol lalan yapni eb scawilal Jerusalén, catu' jix sna'on eb tol oj wa'xi oc naj Yaawil yul yiban k'inal ti' yu Dios yin eymanil. ");
INSERT INTO knjNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jix yalon Jesús tet eb jaxca ti': —Ja' junel ey jun winaj yic'aal eb naj yaaw. Jix awteletoj bey jun conob naat yu sto ẍa'on yopiso, catu' oj oc yaawil bey jun conob tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ja' yet c'am to chi toi, catu' jix yawten laonwan eb smoso. Ey wan ch'en tumin ey yip sat jix yak' can yul sk'ab jun jun eb. Laan c'al sbisil ch'en jix yak' can tet eb. Catu' jix yalon can tet eb jaxca ti': —Ak' wej negocio yetoj wan ch'en tumin ti' masanta' c'al chin juli, catu' che yak'on ch'en junel xa e in an, ẍi naj tet eb. Jix lawi c'al tu', jix to naj. ");
INSERT INTO knjNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero ja' eb yet conob caw chi chichon oc sc'ul eb yin. Yuxan tzajan sto cawan oxwan ẍejab eb yintaj. Jix bet yalon eb tet eb chi aon oc yopiso naj tu' jaxca ti': “Ja' jun winaj tu', caw c'am chi yal cu c'ul chi oc naj kaawil oj bey cu conob,” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero jix ak'le c'al ta' yopiso yoc yaawilal. Catu' jix jul ec' bey sconob. Jix yawten eb smoso bey jix yak' can ch'en tumin tu', yu yaben naj jantaj xa yune' ch'en jix yak' ganar jun jun eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yuxan jix jul jun babel moso, catu' jix yalon jaxca ti': “Patrón, ja' ch'en ja tumin, jix ja wak' can e in an, laoneb yune' ch'en jix yak' ganar,” ẍi naj tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jix yalon naj tu': “Watx' xin, jaachti' caw watx' xa wun e in an. Cax c'al txenne ch'an jix wak' yul ja k'ab, pero watx' c'al jix ja wute ja na'bal yetoj. Yuxan, tol chi waoc ja wopiso yaawil yiban laoneb conob,” ẍi naj tet smoso tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Catu' jix jul ec' jun xa smoso. Jix yalon naj tet spatrón tu' jaxca ti': “Patrón, ja' ch'en ja tumin jix ja wak' e in an, joeb xa sbisil yune' ch'en jix yak' ganar,” ẍi naj tet spatrón. ");
INSERT INTO knjNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yuxan jix yal pax naj patrón tu' tet naj jaxca ti': “Watx' xin, jaachti' oj wak' ja wopiso ja woc yaawil oj yiban joeboj conob,” ẍi naj patrón tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jix lawi tu' xin, jix jul jun xa naj moso. Jix yalon tet spatrón tu' jaxca ti': “Patrón, ja' ch'en ja tumin ti', c'ubabil ch'en wu yul jun jin tx'ambal an. ");
INSERT INTO knjNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Jainti', chin xiw e ach an, yutol wotaj caw ch'aan jaach. Yutol jaachti', tuxa c'al cha cha' tzet chi yak' ganar junoj xa ánima. Tuxa c'al cha jatx' a bey tzet awbil yu junoj xa,” ẍi naj tet spatrón. ");
INSERT INTO knjNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jix yalon naj patrón tet naj tu' jaxca ti': “Jaachti', moso jaach toni, pero pena jaach. Yu wan jix ja wal ti', oj jin na' oc ja win an. Ilala, ja wotaj xa tol ch'aan jin an. Tuxa c'al chin cha' tzet yetal chi yak' ganar wan xa ánima. Chin jatx'on a bey ma waw an. ");
INSERT INTO knjNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Tzet yuxan, ma ja watoj ch'en maanil tet junoj xa mac txequel, yet watx' chi yak' ganar nioj yune' ch'en? K'inaloj ta jix ja watoj ch'en maanil, ja' yet jix jin juli, jix jin cha'on yune' ch'en,” ẍi naj patrón tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Catu' jix yalon tet eb ey ec' yetoj tu' jaxca ti': “I' wej ec' ch'en tet naj. Che yak'on ch'en tet naj laoneb sbisil yune' ch'en jix yi' yu naj tu',” ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Pero patrón, ja' naj cha wal tol chi ak'le ch'en tet naj tu', ey xa laoneb yune' ch'en yet naj,” ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Pero chi wal e ex, ja' mac ey xa yet, oj ak'le c'al tet. Jal mac c'am yet, oj i'le ec' nioj tzet ey xa tet. ");
INSERT INTO knjNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ja' eb cajat oc win an, eb jix ochen tol ma jin oc yin wopiso ti' an, che to je yi' eb. Ja' yet chi jul eb, che yak'on cam eb jin sattaj,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jix lawi yalon Jesús jun sk'aneal tu', jix ẍa'on pax be sto bey Jerusalén yetoj eb scuywom. ");
INSERT INTO knjNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ja' yet jix apni eb scawilal conob Betfagé yetoj Betania, bey wonan Olivo, jix ẍejon baboj cawan eb scuywom. ");
INSERT INTO knjNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ja' yet c'am to chi to eb, catu' jix yalon tet eb jaxca ti': —Asi' wej bey jun aldea cu cawilal ti'. Ey jun no' burro oj ilcha je yu titu', txuan no'. C'am to junoj mac chi a yiban no'. Che ti el no', catu' che yi'ontej no' e in an. ");
INSERT INTO knjNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ta ey mac chi alon e ex jaxca ti': “¿Tzet yuxan che ti el no'?” ta ẍi, quey ti' che yun je yalon jaxca ti': “Tol ey tzet oj oc no' yu naj Kaawil,” je chi tet, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jix to eb cuywom tu'. Jix ilcha yu eb jaxca c'al jix yun yal-le tet eb yu Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ja' yet lalan stion el no' burro eb tu', jix apni wan yaaw no', catu' jix yalon tet eb jaxca ti': —¿Tzet yuxan che ti el no'? ẍi eb yaaw no' tu' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Tol ey tzet oj oc no' yu naj Kaawil, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Catu' jix yi'ontej no' eb bey Jesús tu'. Jix yatoj jun jun spichil eb sk'an oj yichin no', catu' jix ale atoj Jesús yiban no' yu eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ja' yet lalan xa sbeyi, catu' jix c'oli slitx'ban ey spichil eb sattaj yul be bey lalan sbey Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ja' yet lalan xa yapni bey spac'anil wonan Olivo tu', jix a yaw masanil eb scuywom yin ip yu tzala c'ulal. Jix c'oli yalon watx' k'ane eb tet Dios yu wan milagro jix yil eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jix yal eb jaxca ti': —Kal wej watx' k'ane tet naj cu Reyal jix chejletej yu Dios. Caw ey watx' c'ulal satcan, miman ojab yel oc apnoj cu Diosal, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pero ey wan eb fariseo ey ec' xol ánima tu'. Jix yal eb tet Jesús jaxca ti': —¿Tzet yuxan c'am cha tenchane wan ja cuywom ti'? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jix yalon Jesús tet eb jaxca ti': —Chi wal e ex, ta chi tz'ini ey eb, catu' c'am xa mac chi a yaw, ja' wan ch'en ti' oj a yaw, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ja' yet jix yilontoj conob Jerusalén Jesús yet jix apni scawilal, caw jix ok' yu. ");
INSERT INTO knjNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Catu' jix yalon jaxca ti': —Ja' yet jun c'u ti', jex a conob, tol oj wal tol jix na'cha je yu tzet utbil che yute je cha'on swatx' c'ulal Dios. Pero ja' tinani', c'am chi ske' sna'cha el je yu, yutol ewbabil xa el e ex. ");
INSERT INTO knjNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yuxan ey jun tiempoal oj jul oj. Ja' eb ac'ul oc yin jun conob ti', oj oc joyan eb, catu' oj yaon oc colal eb yinlaj, yet oj yak'len jowal eb yetoj tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Oj mak'le ey bulan masanil jun conob ti' sat tx'otx' yu eb. Oj smak'on cam eb ánima eb. Ja' ch'en latz'bil yin nail bey jun conob ti', oj ec' bulnaj masanil ch'en. Quey tu' oj yun can el oj, yutol ja' yet jun tiempoal ti', jix jul Dios jex scoloni, pero ma na'cha el je yu, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jix lawi jun tu' xin, jix octoj Jesús tu' yul stemplo Dios. Jix yujten eltej eb chi txonwi, c'al eb chi manwi. ");
INSERT INTO knjNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jix yalon tet eb jaxca ti': —Yalnaj can Dios yul An Juun Tz'ibebil can jaxca ti': “Ja' jin na an, yet c'al txa ye,” ẍi yul An Juun. Pero jaexti', jaxca junoj na ch'en bey chi yewba el sba eb elk'om, quey tu' che yute, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jun jun c'al c'u sbet ec' Jesús cuywa bey yul stemplo Dios tu'. Ja' eb yaaw yak'omal xaambal eb Israel tet Dios, yetoj eb cuywam yin sley Moisés, c'al eb yaaw conob tu', jix sey eb tzet chi yute yak'on cam naj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero ma na'cha tzet chi yute eb, yutol ey oc sc'ul masanil ánima yaben tzet chi yal Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ey jun c'ual jix cuywa Jesús xol eb ánima yul stemplo Dios. Jix c'oli yalon el watx' k'ane yet colbanile tet eb. Ja' eb yaaw yak'omal xaambal eb Israel tet Dios, yetoj eb cuywam yin sley Moisés, c'al eb ichamtaj winaj ey yopiso, jix apni eb sc'atan Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jix yalon eb jaxca ti': —Al e on tzet ja wopiso, yuxan cha wun wan ti'. ¿Mac txequel jix ak'on ja wopiso tu'? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","—Jainti', oj jin k'anle pax junoj tzet yetal e ex. Al wej e in an. ");
INSERT INTO knjNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Mac jix ak'on yopiso naj Juan yuxan jix yak' bautizar ánima? ¿Dios mi, ma ánima? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jix c'oli yal-len eb yabe xol eb yu tzet jix yal tu'. Jix yalon eb jaxca ti': —¿Tzet chi kute kalon wej tet? Ta chi kal wej, tol ja' Dios jix ak'on yopiso naj Juan tu', oj sk'anle e on jaxca ti': “¿Tzet yuxan c'am che ya pax oc yin je c'ul xin?” ẍi mi. ");
INSERT INTO knjNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero ta chi kala, tol ja' ánima jix ak'on yopiso tu', oj tit sjowal masanil ánima kin, catu' oj cu sk'ojch'enne cam eb. Yutol ja' naj Juan tu', ẍejab Dios ye yul sat eb masanil, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yuxan, jix yal eb tet Jesús tol man yotaj oj eb mac txequel jix ak'on yopiso naj Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jix yalon pax Jesús tet eb jaxca ti': —Ta quey tu' xin, man pax oj wal e ex mac jix ak'on wopiso wunen wan ti' an, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Catu' jix yalontej Jesús jun sk'aneal ti' tet eb ánima yaman ec' titu', jix yalon jaxca ti': —Ey jun winaj jix awon wan uva sat x'otx'. Ja' yet jix lawi yawon can oj, jix yaon can toj x'otx' tu' maanil yetoj c'al tzet awbil yu tu' tet wan eb mulnawom ánima. Jix el bey jun lugar tu'. Naatil jix bet ec' caan titu'. ");
INSERT INTO knjNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ja' yet jix a apnoj stiempoal syambale a an, jix ẍejontoj jun ẍejab naj a tx'otx' tu'. Jix bet sk'anon yuca' tzet awbil tu'. Pero tu' c'al jix bet yetne sba. Jix smak'on eb. Jix ujtele meltzo naj yu eb. C'am nioj yuca' tx'otx' jix yi' naj. ");
INSERT INTO knjNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yuxan jix ẍejtoj jun xa ẍejab naj a tx'otx' tu'. Pero tu' c'al pax jix bet yetne sba. Jix mak'le naj yu eb catu' jix yujten pax eb. Ja'c'ala' c'am nioj tzet jix ak'le tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jix lawi tu' xin, jix ẍejontoj jun xa. Jix apni c'al jun xa tu' sc'atan eb, jix smak'on eb, jix yasi, catu' jix sk'ojon can el eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Jix yalon naj a tx'otx' tu' jaxca ti': “¿Tzet la watx' chi wute an? Oj jin chejtoj jun jin c'aal, jun caw cam c'ulnebil wu an. Tejan oj xiw eb tet,” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero ja' yet jix il-le yapni naj c'aale tu', jix swa' alnen eb jaxca ti': “Ilala, tol ja' naj c'aale tu' chi juli. K'inaloj ta chi cam smam naj tinani', tu' c'al ta' ja' naj chi i'on can tx'otx' ti'. Kak' wej cam oj, yet watx' jaon xa chi ki' wej can tx'otx' ti',” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yuxan jix c'al apni naj sc'atan eb, jix sac'ontej eb. Jix yi'ontoj eb sti' el tx'otx' tx'otx' tu'. Ja' tu' jix bet smak' cam naj eb. Yuxan chin k'anle e ex, ¿tzet pax oj utele eb mulnawom tu' yu naj mame che na? ");
INSERT INTO knjNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ja' naj mame tu' oj toj catu' oj ak'le lawoj eb yu naj. Catu' oj yaon can toj x'otx' tu' maanil tet wanoj xa mac txequel, ẍi Jesús. Jix lawi yaben eb wan tu', catu' jix yalon eb jaxca ti': —¡Tol oj wal man jaxca oj tu' chi yute! ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero jix oc t'anan Jesús yin eb. Jix yalon jaxca ti': —Pero ¿tzet pax chi yal yel oc apnoj wan tz'ibebil can yul An Juun Tz'ibebil can che na'? bey chi yal jaxca ti': Ey jun ch'en ma oc yopiso yu eb wa'nem na. Ja' ton jun tu' yel miman yopiso jix oqui, ẍi yul An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yal c'al mac chi mak' ey sba yiban jun ch'en tu', coc' xa c'al chi yun sk'atoj. Jal mac txequel chi ey q'uey jun ch'en tu' yiban, coc' xa c'al chi yuntoj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ja' eb yaaw yak'omal xaambal eb Israel tet Dios, yetoj eb cuywam yin sley Moisés, jix yoche eb tol chi smitx' Jesús yin eymanil, yutol jix na'cha el yu eb, tol ja' tet eb jix al-le jun sk'aneal tu'. Pero jix xiw a eb tet ánima. ");
INSERT INTO knjNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yuxan jix ẍejtoj eb jaywan chejab sto smajon yila, ta ey bey oj oc smul Jesús. Ja' yet jix apni eb tu', watx' xa c'al chi slan yute sba eb yet watx' chi ey q'uey Jesús yin junoj k'anlebal yu eb, yutol chi yoche eb tol yin c'al tzet chi el yalon naj, ja' tu' chi ey q'uey naj, yet watx' chi i'letoj naj yu eb sattaj yaaw. ");
INSERT INTO knjNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jix slan yalon eb tet Jesús jaxca ti': —Jaach cuywam, kotaj sic'lebil tol tool c'al cha wute ja walon junoj tzet yetal, watx' pax ja cuywai. C'am junoj mac bey chach xiwi, yutol laan c'al yel oc apnoj jun jun mac txequel yul ja sat. Kotaj pax oj, ja' jun beybale chi ẍa' sc'ul Dios, ja' cha wak' cuyle yin yel. ");
INSERT INTO knjNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yuxan chi cu k'anle e ach, ja' ch'en tumin chi k'anle el kin yu naj yaaw a Roma, ¿ey mi sleyalil kak'on ch'en, ma c'amaj? ẍi eb tet. ");
INSERT INTO knjNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero yotaj xa Jesús tol man watx' oj tzet lalan sna'on oc eb yin naj. Yuxan jix yal tet eb jaxca ti': —¿Tzet yuxan chin je yak' porobal? ");
INSERT INTO knjNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tx'ox wej junoj ch'en tumin tu' wil an. ¿Mac txequel jun ey oc yechel sat yin ch'en ti'? ¿Mac txequel jun tz'ibebil oc sbi yin ch'en ti'? ẍi Jesús tet eb. —Yechel sat naj yaaw a Roma yetoj c'al sbi naj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yu tu', xin, ja' tzet yetal tol yet c'al ta' naj yaaw tu' yei, ak' wej tet naj. Pero ja' tzet yetal yet Dios, ak' wej pax tet, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ma yak' ganar eb yey q'uey yin junoj sk'ane naj sattaj eb ánima. Yuxan jix q'uey a sc'ul eb. C'am xa tzet jix yal eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ey wan eb saduceo jix apni sc'atan Jesús, eb chi aloni, tol man oj pitzc'u a eb camnaj. Jix yalon eb tet naj jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Jaach cuywam, ja' naj Moisés, jix tz'iben can jaxca ti': “K'inaloj ey junoj winaj chi cami, catu' chi can yistil pero c'am junoj yuninal chi el can oj. Sowalil junoj yuẍtaj naj chi i'on can ix, yet watx' chi el yuninal naj chi i'on can ix tu', jaxca tol yuninal naj camom tu' chi el yu yuẍtaj.” Quey tu' jix yute yalon can Moisés. ");
INSERT INTO knjNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ja' junel, ey jujwan winaj jix ec' cu xol ti', yuẍtaj c'al sba eb. Jix oc yetbi naj babel winaj. Pero jix cam naj, c'am c'al junoj yuninal naj jix el can oj. ");
INSERT INTO knjNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ja' naj tzunan yintaj naj babel tu' jix i'on can ix. Jix cam pax naj, ja'c'ala' c'am yuninal naj jix el can oj. ");
INSERT INTO knjNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jix lawi tu' xin, jix yi'on can a ix ix naj yet yox tu'. Ja'c'ala' c'al jix yun eb naj sjujwanil. Jix cam c'al toj eb naj, c'am c'al junoj eb naj jix el can junoj yuninal. ");
INSERT INTO knjNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jix lawi scamtoj eb naj xin, catu' jix cam pax ix ix tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ja' yet oj pitzc'u a eb camnaj tu', ¿mac txequel naj ey yistil ix sic'lebil? yutol jix yil-le ix yu eb naj jujwan tu', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jix yalon Jesús tu' tet eb saduceo tu' jaxca ti': —Ja' yul yiban k'inal ti', chi ton yil-le sba winaj yetoj ix. ");
INSERT INTO knjNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero ey jun xa lugar. Ja' eb oj pitzc'u a xol eb camnaj, eb smoo yapni titu', ma xa yil-le sba eb titu'. Ma xa ak'le cutz'ine yin alibeal. ");
INSERT INTO knjNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yutol ja' yet jun tiempoal tu', c'am xa bak'in oj cam eb. Laan xa oj yun eb jaxca eb ángel. Caw yuninal xa Dios eb, yutol oj ak'le pitzc'u a eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ja' naj Moisés, jix yak' can otajnele el oj, tzet utbil tol oj pitzc'u a eb camnaj, yet jix s'iben sk'aneal jun tiempoal yet jix yilon s'a' te' q'uix. Ja' tax yet tu' jix yalon can Dios jaxca ti': “Jain ton ti', Sdiosal jin naj Abraham, Sdiosal jin naj Isaac, Sdiosal jin pax naj Jacob,” ẍi Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yuxan, cax c'al camnaj xa eb, kotaj tol ja' Dios man Sdiosal oj eb camnaj, pero Sdiosal eb iquis. Ja' yul sat Dios, iquis ye eb ánima masanil, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yuxan, Jix yal wan eb cuywam yin sley Moisés tet Jesús jaxca ti': —Yel ton cha wal Mamin, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma xa stec'ban sba eb saduceo sk'anlen junoj xa tzet yetal tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jix yalon Jesús tet eb ey ec' titu' jaxca ti': —¿Tzet yuxan ey eb chi alon jaxca ti'? “Cristo, yic'aal naj David,” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pero ja' naj David jix yal can yul jun Salmo jaxca ti': Jix yal Dios tet naj Waawil: “Eyan chotan bey jin watx' k'ab. ");
INSERT INTO knjNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Masanta' oj can eb chi chichon oc sc'ul ja win yalan wu an,” ẍi Dios tet naj Waawil, ẍi David. ");
INSERT INTO knjNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Quey tu' jix yute yalon can David, ¿tzet utbil tol ja' Cristo, ey oc Yaawil oj? Yuxan, ¿tumi ja' Cristo yic'aal c'al naj David ye xin? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ja' yet lalan to yaben masanil eb ánima, jix yalon tet eb scuywom jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Che yil c'al je ba, yet watx' c'am chex etex el yu sbeybal eb cuywam yin sley Moisés. Yutol chi ẍa' sc'ul eb yec' yetoj wan an jojan pichile. Chi yoche eb tol tuxa c'al chi yi' ey sba ánima tet, yet chi ec' eb txombal. Chi yoche eb asan bey chi ey chotan eb mimej winaj yul snail sculto, ja' tu' chi ey chotan eb. Yetoj yet chi wa'xi wan lo'be caw watx', asan bey watx' chi yoche eb chi ey chotan oj. ");
INSERT INTO knjNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chi i'le ec' sna eb ix camnaj xa yichamil yu eb. Chi lawi jun tu', catu' miman chi yute yajan xa eb, tzet utbil oj chi sna' ánima tol c'am smul eb. Ja' eb tu' caw miman sya'tajil oj jul yiban eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ja' junel, ey ec' Jesús yul stemplo Dios. Jix yiloni, tzet c'al jix yute yaon eytoj stumin eb be'om yul jun cha'bal sa'beal tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jix yilon pax yapni jun ix meba' ix, camnaj xa yichamil. Jix yaon eytoj caab ch'en centavo ix. ");
INSERT INTO knjNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yuxan jix yal Jesús tet eb ey ec' yetoj jaxca ti': —Caw yel chi wal e ex, ja' jun ix camnaj xa yichamil ti', caw meba' ix. Pero ja' sa'beal ix tet Dios jix yak' tu', yel ec'ban yel oc apnoj yintaj yet masanil eb jix yak' yet. ");
INSERT INTO knjNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yutol jun jun eb, ja' ch'en jix yak' can sobra chi ya eytoj eb sa'beal oj tet Dios. Pero jun ix ix ti' xin, caw meba' ton ix. Tz'ajan jix ya eytoj masanil stumin ix sa'beal oj tet Dios. C'am xa tzet jix can tet ix, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ey wan eb lalan yalontej yu stemplo Dios tu', tzet utbil tol caw watx' yili, caw watx' scawxi yu ch'en ch'en ey oc yin, yetoj yu wan sa'beal ánima ey oc yin. Yuxan jix yaltej Jesús tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ja' wan lalan je yilon ti', oj ec' bulna masanil yet jun tiempoal oj jul oj. C'am junoj wan ch'en latz'bil a ti' oj can yiban yet ch'enal, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jix sk'anlen eb tet Jesús jaxca ti': —Wuẍtaj, ¿bak'in oj jul jun cha wal tu'? ¿Tzet yechelal oj x'ox Dios yet tuxa oj jul oj? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jix yalon tet eb jaxca ti': —Caw listo c'al che yute je ba, yet watx' c'am mac oj jex etnen oj. Yutol ec'al mac oj jul oj, oj tz'aj ya oc jin bi eb yin, “Jain ton Cristo jin an,” ẍi eb oj tz'aj yalon eb. “Tol jix jul slawubal yul yiban k'inal,” ẍi eb oj yalon pax eb. Pero manchej je yaoc yin je c'ul tzet oj yal eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Oj je yab sk'aneal wan mimej jowal, oj a waan eb comon ánima yin jowal yin eb yaaw. Manchej je xiw a oj. Yutol sowalil ja' wan ti' oj baboj ec' el oj. Pero man to oj lawoj ec' yul yiban k'inal ti' yet tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Oj smitx'le a sba mimej nación yin jowal. Yetoj wan tx'oj tx'oj mimej conobal, oj smitx'le pax a sba yin jowal. ");
INSERT INTO knjNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ec'al bey oj ec' mimej quixcab caw jow. Ec'al wan tzet yetal oj je yil satcan, caw oj xiw ánima yu. Oj x'oxon a sba wan yechel bey satcan tol caw miman yel oc apnoj tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero ja' yet c'am to chi jul wan tu', ey mac oj jex mitx'on oj, catu' oj yak'on eb pena c'ulalil je yin. Oj jex yi'toj eb bey snail sculto yu chi sna' oc eb je yin, catu' oj jex yaon oc eb preso. Oj jex yi'toj eb sattaj eb rey, c'al sattaj wan xa eb yaaw yu c'al che yaoc je c'ul win an. ");
INSERT INTO knjNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pero jaxca tu' oj ske' je yalon can el jin k'aneal tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sowalil ojab che yotajne el sbabelal, tol ma ske' je seyon tzet oj je yute je colon je ba yet oj jex apnoj sattaj eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yutol jain oj jin k'anab el je yin, catu' oj wak'on je jelanil. Yuxan, c'am junoj eb chi chichon oc sc'ul je yin tu' oj jex ak'on ganar. C'am junoj eb chi apni sjelanil jaxca jun oj wak' e ex an. ");
INSERT INTO knjNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ey jex ja' je mam je txutx, je yuẍtaj, je yican, je yamigo, ja' oj meltzo oc je yin. Ey jex oj jex mak'le cam yu eb. ");
INSERT INTO knjNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Jal masanil ánima xin, oj chichon oc sc'ul je yin, yutol ey oc je c'ul win an. ");
INSERT INTO knjNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero c'am junoj jex oj jex q'ueyle el oj, cax c'al junoj xil je jolom. ");
INSERT INTO knjNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ta tec'an c'al oj je yute je ba, oj je yak' ganar je cha'on je k'inal tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ja' yet oj je yiloni, tol jix joyle Jerusalén ti' yu eb soldado, na'cha ojab el je yu, tol tuxa oj lawoj. ");
INSERT INTO knjNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ja' eb ey ec' bey Judea ti', to ojab eb bey wonan. Ja' eb ey ec' bey Jerusalén ti', el ojab pax eb. Ja' eb chi ec' naatlaj, c'am ojab chi oc eb yul conob ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yutol ja' yet jun tiempoal tu' oj jul jun miman castigo. Ja' ton yet tu', oj yun jantaj tzet tz'ibebil can yul An Juun Tz'ibebil can oj. ");
INSERT INTO knjNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ja' eb ix mimejal xa ix yet jun tiempoal tu', c'al eb ix ey to yune' chi txutxwi, ok'bal c'ule eb ix yet oj eltoj eb ix tu'. Yutol caw miman castigo oj jul yiban eb ánima bey wan lugar ti'. Yutol oj tit sjowal sc'ul Dios yiban eb ket Israelal. ");
INSERT INTO knjNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ec'al eb oj cam can xol jowal tu'. Ec'al eb oj toj can preso, oj sajlem can toj eb bey conoblaj. Oj etex can ey Jerusalén ti' yu eb man Israel oj tu', masanta' c'al yet oj lawoj stiempoal yak'on eb yaawil, jaxca chi yoche Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ey wan yechel oj x'ox sba yin c'u, c'al yin xaaw, c'al yin weycan. Jal bey sat tx'otx' ti' xin, oj somcha el sc'ul ánima yu xiw c'ulal bey jun jun conob. Yutol oj a pulna ja' mar catu' oj awoj smak'on ey sba ja'. ");
INSERT INTO knjNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Oj sajboj el ánima yu xiw c'ulal, yet oj sna'ontej eb tzettaj yetal oj jul yul yiban k'inal ti'. Ja' wan tzet yetal ey yip bey satcan, oj tz'icotenele eb. ");
INSERT INTO knjNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Oj lawoj tu', catu' oj yilon eb ánima, oj jin eyol xol jun asun, jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an. Oj jin jul yetoj miman wip an, c'al jin miman tzejejial. ");
INSERT INTO knjNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ja' yet lalan xa sbey sjul wan tzet yetal jix wal ti' an, tzala jon nej. Chex a t'anan satcan, yutol tuxa oj jex colcha oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Catu' jix yalontej jun sk'aneal ti' tet eb: —Na' wej tej tzet utbil chi yun yak'on xaj te' higo c'al wan xa te' te' chi puj xaj. ");
INSERT INTO knjNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ja' yet chi uninbi xaj te', je yotaj xa tol tuxa chi jul nabil k'inal. ");
INSERT INTO knjNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yetoj pax oj, ja' yet oj je yilon sjul wan jix wal ti' an, na'cha ojab el je yu, tol tuxa chi wa'xi oc Dios Yaawil oj. ");
INSERT INTO knjNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Caw yel chi wal e ex, man oj cam wan ánima tu', masanta' c'al oj yun masanil wan jix wal ti' an. ");
INSERT INTO knjNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Oj lawoj el satcan c'al yul yiban k'inal ti', jal jin k'ane xin, man oj tan el tzet chi wal an. ");
INSERT INTO knjNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Che yil c'al je ba. Manchej je yak' cawxo el je ba yu k'in c'al yu uq'ueanil, ma yu junoj xa tzet yetal chex oc bis c'ulal yu bey yul yiban k'inal ti'. Ta c'amaj, ja' yet oj jul jun c'ual tu', man listo oj je yei. ");
INSERT INTO knjNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Jaxca junoj yal, quey tu' oj yun sjul yiban masanil ánima yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yuxan caw listo che yute je ba. Txalan nej c'al tobal k'inal, yet watx' oj ske' je colon je ba yalan wan tzet oj jul tu', catu' chex apni jin sattaj, jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jun jun c'al c'u jix cuywa Jesús yul stemplo Dios. Ja' yet ak'balil, ja' bey wonan Olivo chi bet wey oj. ");
INSERT INTO knjNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jun jun c'u, chi pet jul eb ánima yet sk'inibalil bey stemplo Dios, yu yaben tzet chi yal Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lalan xa sjul stiempoal sk'in pascua eb Israel, yet chi slo'on ixim pan eb c'am yich. ");
INSERT INTO knjNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jix seyon eb yaaw yak'omal xaambal eb Israel tet Dios c'al eb cuywam yin sley Moisés tzet utbil oj yute cam Jesús eb yin ewantajil, yutol chi xiw eb tet eb conob. ");
INSERT INTO knjNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ey jun chi yij Judas, chi yij pax Iscariote. Yetbi sba yetoj eb jusluc'wan jix ec' c'al cuywoj yintaj Jesús. Pero jix oc Satanás yin. ");
INSERT INTO knjNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuxan jix to k'anab yetoj eb yaaw yak'omal xaambal eb Israel tet Dios, yetoj eb yaaw bey templo. Jix bet naj yalon tet eb tzet oj yute yaon oc Jesús naj yul sk'ab eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jix tzala a eb sic'lebil. Catu' jix yak'on strato eb, tol oj yak' tumin eb tet Judas tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Catu' jix ẍa'on sc'ul naj tzet jix yal eb. Jix seyon tzet oj yute yak'on Jesús yul sk'ab eb yin ewantajil tu' yet c'am ánima ey ec' yetoj. ");
INSERT INTO knjNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ja' yet jix a apnoj stiempoal slo'on ixim pan eb c'am yich, yet chi yak'on cam no' sme' eb yet pascua, ");
INSERT INTO knjNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","jix yalon Jesús tet Pedro yetoj tet Juan jaxca ti': —Asi' wej wa'ne wej tzet oj cu lo' yet pascua, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—¿Beytu' cha woche chi cu wa'ne? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","—Ja' yet oj jex apnoj yul conob, ey jun winaj oj ilcha je yu. I'bil oc jun moc ja' yu, lalan sto bey sna. Chex oc tzajan yintaj naj masanta' c'al chex apni yetoj naj bey chi apni. ");
INSERT INTO knjNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Catu' oj je yalon tet naj a na tu' jaxca ti': “Tol quey ti' jix yute yalon naj cu cuywam ti': ¿Beytu' ey jun cuarto bey oj jin low yetoj eb jin cuywom an, yu cu na'ontej pascua ti'? je chi tet,” ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Catu' oj x'oxon jun miman cuarto e ex naat ey a oj, watx' xa ye. Ja' tu' che wa'ne tzet oj cu lo' tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jix to eb xin. Ja' yet jix apni eb, catu' jix yilon eb, caw yel ton chi yal Jesús tu'. Yuxan, ja' tu' jix swa'ne eb tzet oj lo'le yet pascua tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ja' yet jix a apnoj yorail, catu' jix apni Jesús yetoj wan xa eb scuywom. Catu' jix oc joyan eb yin meẍa low oj. ");
INSERT INTO knjNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Catu' jix yalon tet eb jaxca ti': —Caw chi yoche jin c'ul chin lo' yet jun pascua ti' je yetoj an, yajban c'am to chin cam an. ");
INSERT INTO knjNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yutol chi wal e ex, c'am xa bak'in oj jin low junoj xa pascua masanta' c'al oj oc jun yet oj wa'xoj oc Dios Yaawil oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Catu' jix yi'on a jun vaso. Jix yalon yu diosalil tet Dios yu. Catu' jix yalon tet eb jaxca ti': —Cha' wej jun ti'. Uc' wej. ");
INSERT INTO knjNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yutol chi wal e ex, c'am xa bak'in oj wuc' yal sat uva ti', masanta' c'al oj wa'xoj oc Dios Yaawil oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Catu' jix yi'on a jun pan. Jix yak'on yu diosalil yu. Jix spo'on ec' xol eb tu'. Catu' jix yalon tet eb: —Ja' ton jin mimanil oj ak'le je yu c'al ti'. Lo' wej, yu jin je na'ontej, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Quey pax tu' jix yute jun vaso, yet jix lawi slo'on ixim pan eb tu'. Jix yalon tet eb jaxca ti': —Ja' tzet ey ey yul jun vaso ti', jun strato Dios tol to chi yak' je yetoj. Yu jin chiq'uil, oj yun jun trato tu'. Ja' jin chiq'uil chi el je yu. ");
INSERT INTO knjNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ja' mac oj jin aon oc yul sk'ab eb tu', ey ec' yin meẍa ti' wetoj an. ");
INSERT INTO knjNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Jain Ak'bil Wopiso yu Dios xol eb ket animail ti' an, sowalil oj jin cam oj, jaxca sna'bal Dios. Pero ja' jun oj jin aon oc yul sk'ab camich tu' an, caw ok'bal c'ule naj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yuxan, jix sk'anle el eb yin jun junal tet Jesús, mac txequel jun oj aon oc yul sk'ab camich tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jix lawi jun tu', catu' jix steelen sba eb cuywom yu mac txequel junoj yel miman yel oc apnoj xol eb, yutol jun jun c'al mac txequel yel miman yel oc apnoj sna'oni. ");
INSERT INTO knjNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero jix yalon Jesús tet eb jaxca ti': —Ja' eb rey bey jun jun nación, caw yaaw ye eb. Yetoj eb yaaw, watx' eb yalon eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jaexti', manchej je yute je ba jaxca eb yaaw tu'. Ta e ex yel miman je yel oc apnoj je xol, i' wej eytej je ba jaxca junoj unin c'am yel oc apnoj. Yetoj pax oj, ta jaex yaaw je ye, ute wej je ba yin mosoal. ");
INSERT INTO knjNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","K'inaloj yet chi oc junoj lo'be tinani', ¿mac txequel junoj miman yel oc apnoj che na'? ¿Jam mac txequel chi ey chotan lowoj, ma ja' mac chi batxwi eltej lo'be? Ja' mac chi ey chotan low tu', yel miman yel oc apnoj. Pero jainti', moso we je xol jex wak'on servil. ");
INSERT INTO knjNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jaexti', jix je tec'ba je ba je ye ec' wetoj yet jix jul wan porobal wiban an. ");
INSERT INTO knjNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yuxan oj jex waoc yaawil, jaxca oj yun woc Yaawilal yu cu Mam Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yuxan oj ske' je low wetoj an yin jin meẍa bey ey jin oc Yaawil oj tu' an. Yetoj pax oj, oj jex ey chotan bey jun jun je despacho. Catu' oj je yak'on yaawilal yiban eb lacaweb bulan ket Israelal, ẍi Jesús tet eb scuywom tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jix yalon pax naj Kaawil jaxca ti': —Simón, Simón, ja' Satanás jix sk'an spermiso tet Dios yutol chi yoche naj chex yak' porobal, jaxca chi yun ixim trigo yet chi txeyele ixim. ");
INSERT INTO knjNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero caw jix jin k'anle tet Dios yet watx' c'am cha wi' el ja c'ul yin Dios. Ja' yet oj ja waon pax oc ja c'ul win junel xa an, ak' stec'anil sna'bal eb ja wuẍtaj, ẍi Jesús tet naj Pedro. ");
INSERT INTO knjNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yuxan jix yal pax naj Simón tu' tet Jesús jaxca ti': —Wuẍtaj, bejan jin c'ul woc preso ja wetoj an, cax c'al oj jin cam ja wetoj an, ẍi naj Pedro tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Pedro chi wal e ach, oxel xax jin ja wi' el ja win an, catu' oj ok' a no' caẍlan yet jun ak'balil ti', ẍi Jesús tet Pedro. ");
INSERT INTO knjNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jix yal Jesús tet eb scuywom jaxca ti': —Che na'tej yet jix jex jin chejontoj yet junel, c'am nioj je pa jix je yi', c'am je tz'um yet je tumin, c'am je xanab jix je yi'toj je toi. ¿Ey mi tzet c'am e ex? ẍi Jesús tet eb. —Tz'ajan c'al tzet ey e on, Wuẍtaj, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jal tinani' xin, ja' mac jex ey je morral, je tz'um yet je tumin, i' wej tej je yetoj. Ja' mac jex c'am je yespada, txon wej el je chumpa, catu' che manon je yet. ");
INSERT INTO knjNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yutol chi wal e ex, sowalil oj yun tzet albil can yul An Juun Tz'ibebil can oj, bey chi yal jaxca ti': “Jaxca tzet chi utele oc yiban eb pena sbeybal, quey tu' tzet oj ale oc yiban jun xa,” ẍi yul An Juun tu'. Masanil jin k'aneal tz'ibebil yul An Juun tu', sowalil oj yune', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jix yalon eb scuywom tu' tet jaxca ti': —Wuẍtaj, tol ey caab espada titi', ẍi eb tet Jesús. —K'ojbil caab ti', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jix eltej Jesús yul na, catu' jix to bey wonan Olivo tu' jaxca ta' sbeybal. Jix oc tzajan eb scuywom yintaj. ");
INSERT INTO knjNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jix c'al apni catu' jix yalon tet eb jaxca ti': —Txalan nej, yet watx' c'am chex ak'le porobal, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Catu' jix sboson el sba tet eb tu'. Jaxca ta' snaatil chi apni junoj ch'en sk'ojlei, quey tu' bey jix sbos el sba. Jix ey kaan titu', catu' jix txali. ");
INSERT INTO knjNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jix yal yin xa jaxca ti': —Mamin, ta chi el yin ja c'ul, cha tenel jun ya'ilal ti' wiban an, catu' c'am chi wab sya'il an. Pero man jaxca oj chi woche an, pero jaxca ojab cha woche, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jix lawi c'al jun tu', jix eyol jun ángel bey satcan, jix jul ak'le stec'anil yu. ");
INSERT INTO knjNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Caw jix oc pitz'an cus c'ulal yin sc'ul. Yuxan jix yi' atej sc'ul xali sic'lebil. Caw jix el ja' yin. Caw jix ey t'ulaboj ja' yin jaxca chic', quey tu' jix el yin, jix ey q'uey sat tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ja' yet jix lawi xali, catu' jix a linan oj. Jix meltzo bey jix ey can eb scuywom tu'. Ja' yet jix apni sc'atan eb, jix yiloni, tol chi wey eb. Jix tit sweyan eb yu cus c'ulal. ");
INSERT INTO knjNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yuxan, jix yal tet eb jaxca ti': —¿Tzet yuxan chex weyi? Aan nej waan oj. Txalan nej, yet watx' c'am chex ak'le porobal, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lalan to yalon Jesús tet eb jaxca tu', catu' jix apni bulna jun miman bulan ánima titu'. Ja' naj Judas, naj yetbi sba yetoj eb jusluc'wan, ja' naj jix babi sattaj eb. Eyman jix apni yin Jesús, yu s'ubon sti'. ");
INSERT INTO knjNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jix yalon Jesús tet naj jaxca ti': —Judas, ¿tumi jaxca ti' chin ja wute ja wak'on yul sk'ab camich, jain Ak'bil Wopiso yu Dios xol eb ket animail ti', yuxan cha tz'ub el jin ti' an? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ja' yet jix yilon eb ey ec' yetoj Jesús tu' tzet yetal lalan sjul yiban eb. Jix sk'anlen eb tet Jesús jaxca ti': —Wuẍtaj, ¿chim ske' cu xibtentoj eb yetoj kespada ti'? ẍi eb tet. ");
INSERT INTO knjNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yet jun txolan tu', ey jun scuywom tu' jix tz'oc'on el xiquin jun smoso naj yaawil yak'omal xaambal eb Israel tet Dios, c'uxan c'al ja' swatx' jix mitx' a yu. ");
INSERT INTO knjNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jix yalon Jesús tet eb scuywom tu' jaxca ti': —Bej wej, manchej je yute jaxca tu', ẍi tet eb. Catu' jix to mitx'an yin xiquin naj tu'. Jix oc can yu junel xa. ");
INSERT INTO knjNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ja' eb yaawil yak'omal xaambal eb Israel tet Dios, yetoj eb yaawil stemplo Dios c'al eb ichamtaj winaj ey yopiso, ja' eb jix apni smitx'on Jesús. Yuxan, jix yal Jesús tet eb jaxca ti': —¿Tzet utbil wili che yil an? ¿Tumi elk'om jin? yuxan chex jul win an yetoj espada c'al te'. ");
INSERT INTO knjNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ey jin c'al ec' je yetoj jun jun c'u yul stemplo Dios, pero ma jin je mitx' pax oj. Pero ja' ton yorail je yak'on je na'bal ti', yetoj naj yaawil k'ej k'inal, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jix lawi jun tu' xin, jix oc mitx'an eb yin Jesús. Jix yi'ontoj eb bey sna naj yaaw yak'omal xaambal eb Israel tet Dios. Jal pax naj Pedro xin, naat xa c'al tzajan sto naj. ");
INSERT INTO knjNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jix yaoc sk'ak' eb bey sti' na tu'. Jix ey chotan eb, catu' jix oc joyan eb yin k'ak'. Catu' jix apni naj Pedro, catu' jix ey chotan xol eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ey jun ix criada jix ilon oc yin naj Pedro yin eymanil yet chotan ey xol eb tu'. Jix oc t'anan ix yin, catu' jix yalon ix jaxca ti': —Ja' jun winaj ti', yetbi sba yetoj Jesús, ẍi ix. ");
INSERT INTO knjNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero ja' naj Pedro jix tak'wi: —Txo ix, man wotaj oj jun mac txequel cha wal tu', ẍi Pedro tet ix. ");
INSERT INTO knjNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Jun xa txolan tu', catu' jix il-le oc yin naj yu jun xa. Catu' jix yalon pax jaxca ti': —Jaachti', ja wetbi ja ba yetoj eb, ẍi naj tet Pedro. —C'amaj cha, man wetbi oj jin ba yetoj eb, ẍi naj Pedro tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jun xa mi wal hora yalon jun tu', jix yal xa c'al jun xa jaxca ti': —Ja' naj ti', caw yel yetbi sba yetoj naj jix i'le jul ti', yutol yet a Galilea sba naj yetoj eb, ẍi jun xa tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Caw yel cha, caw man wotaj oj tzet cha wal tu', ẍi Pedro tu' tet naj. Lalan to yaloni, jix ok' a no' caẍlan. ");
INSERT INTO knjNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jix meltzotoj jacan naj Kaawil yin naj Pedro tu'. Yuxan jix sna'tej tzet jix yal naj tet. Jaxca ti' jix yute yalon naj tet: “Oxel xax jin ja wi' el ja win an, oj ja waloni tol man ja wotaj oj jin an, catu' oj ok' a no' caẍlan yet jun ak'balil ti',” ẍi Jesús tet. ");
INSERT INTO knjNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Catu' jix eltoj naj xol eb tu'. Ja' yet jix lawi yeltoj, caw jix ok' a naj. ");
INSERT INTO knjNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ja' eb chi teynen Jesús, jix buchwa eb yin, catu' jix smak'on pax eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jix smajchen sat naj eb. Jix c'oli smak'ontoj sat eb. Catu' jix tz'aj sk'anlen tet jaxca ti': —Al e on, mac chach mak'on cha wabe, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jantaj tzet jix yal eb tet yin buchwal k'aneal. ");
INSERT INTO knjNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jaxa yet jix sajbi, jix syamba sba eb icham winaj ey yopiso xol eb Israel yetoj eb yaaw yak'omal xaambal eb Israel tet Dios, c'al eb cuywam yin sley Moisés. Jix yi'ontoj Jesús eb sattaj eb yaaw. Jix sk'anlen eb tet titu' jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Al e on, ¿tumi yel jaach Cristo jaach? ẍi eb tet. —Na'ba c'al chi wal e ex, toj oj je yaoc yin je c'ul. ");
INSERT INTO knjNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Yetoj pax oj, ta ey tzet chin k'anle el e ex, ¿tumi oj je yal e in an? ¿Tumi oj jin je jaj pax el an? ");
INSERT INTO knjNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero jainti', Ak'bil Wopiso yu Dios xol eb ket animail an, ja' tinani' oj jin apnoj chotan bey swatx' k'ab Dios, caw miman yip tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","—¿Tumi Sc'aal Jaach Dios ch'al tu'? ẍi eb tet. —Jainti', Sc'aal jin ton Dios jaxca je yalon ti', ẍi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Catu' jix yalon eb jaxca ti': —Tinani', man xa sowalil oj ey cu testigo. Ilala ja' caw chi alon yetoj sti', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jix a linan masanil eb tu', catu' jix i'letoj Jesús yu eb sattaj naj Pilato. ");
INSERT INTO knjNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Catu' jix c'oli sna'on a k'ane eb yiban. Jix yalon eb jaxca ti': —Jix kil on, ja' jun winaj ti', lalan yak'on somcha el sc'ul eb ket conob on. Jix yala tol c'am chi ske' kak'on ch'en tumin chi k'anle el yu naj yaaw a Roma. Catu' chi yalon pax oc sba Cristoal, chi yal yel oc apnoj, rey, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jix sk'anlen naj Pilato tu' tet jaxca ti': —Chin k'anle e ach, ¿Tumi sreyal jaach eb Israel tu'? ẍi naj tet Jesús. —Jaa', yel toni, quey ton tu' jaxca ja walon tu', ẍi naj tet naj Pilato. ");
INSERT INTO knjNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jix yalon Pilato tu' tet eb yaaw yak'omal xaambal eb Israel tet Dios yetoj eb ánima ey ec' titu' jaxca ti': —Ja' jun winaj ti', c'am nioj smul chi wabe, ẍi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero tol jix yi' atej sc'ul eb yalon junel xa jaxca ti': —Pero ja' jun winaj ti', masanil eb a Judea ti' lalan somcha el sc'ul eb yu stit sjowal yin gobierno yu wan cuybanile chi yak'a. Ja' tax bey Galilea jix el yich yalon wan cuybanile chi yal ti', masanta' c'al jix jul titi', ẍi eb tet Pilato. ");
INSERT INTO knjNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ja' yet jix yaben Pilato wan tu', jix sk'anlen tet eb, ta tol a Galilea Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ja' yet jix yabeni, tol a Galilea toni, yuxan jix yatoj tet Herodes, yutol ja' naj Herodes yaaw ye bey Galilea tu'. Ja' yet tu' ey ec' Herodes tu' ca-oxeb c'ual bey Jerusalén tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ja' yet jix yilon sjul Jesús sattaj, caw jix tzalai, yutol ey xa stiempoal yaben sk'umal Jesús tu'. Yuxan caw chi yoche chi k'anab nioj yetoj. Catu' chi yochen chi yil junoj milagro chi yune'. ");
INSERT INTO knjNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ec'al tzet jix sk'anle el tet Jesús tu', pero c'am c'al tzet jix spajtze. ");
INSERT INTO knjNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ja' eb yaaw yak'omal xaambal eb Israel tet Dios, jix apni eb yetoj eb cuywam yin sley Moisés. Yel c'ulal tol jix sna' a k'ane eb yiban naj. ");
INSERT INTO knjNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yuxan jix bawa a Herodes yetoj eb soldado yin Jesús tu'. Catu' jix buchwa eb yin naj sic'lebil. Jix tz'aj yaon oc jun pichile eb caw watx' yin naj, jaxca yet eb rey. Jix lawi jun tu' xin, catu' jix ale paxtoj bey Pilato tu' junel xa. ");
INSERT INTO knjNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ja' to yet jun c'ual tu', jix yamigone a sba naj Pilato tu' yetoj naj Herodes tu'. Yutol ja' yet yalantoj, scajat sba eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jix yal Pilato tol chi syamba oc sba eb yaaw yak'omal xaambal eb Israel tet Dios yetoj eb yaaw, c'al masanil ánima. ");
INSERT INTO knjNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Catu' jix yalon xol eb jaxca ti': —Ja' jun winaj jix je yi'tej e in ti' an, che yala tol chi somcha el eb ánima yu. Pero ilala je sattaj jix jin k'anle tet, c'am nioj smul chi txeclo el jaxca je yalon yin tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ja'c'ala' Herodes, c'am nioj mule jix ilcha el yin naj yu. Yuxan, jix ẍej pax tej cu c'atan junel xa. Yuxan c'am nioj smul smoo scam yu. ");
INSERT INTO knjNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yuxan tu' c'al oj wak' mak'le an, catu' oj jin jajon el oj, ẍi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ja' sley Pilato tu', tol chi sjaj el jun jun a presowom yet jun jun k'in pascua. ");
INSERT INTO knjNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ja' yet jix yaben ánima tol quey tu' oj yun naj, jix a yaw eb yin ipal jaxca ti': —Ja' jun winaj ti', cam ojabi. Ja' ojab naj Barrabás cha jaj el oj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ja' naj Barrabás tu', ey oc preso yutol locan xol eb jix yak'le jowal yetoj eb yaaw yul conob tu', catu' mak'om pax cam ánima naj. ");
INSERT INTO knjNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ja' naj Pilato tu', caw chi yoche chi sjaj el Jesús. Yuxan, quey tu' jix yute yalon tet eb ánima tu' junel xa. ");
INSERT INTO knjNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero ja' yet jix yaben eb jaxca tu', caw jix a yaw eb yalon jaxca ti': —Tol chi cam yin culus. Tol chi cam yin culus, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jix yalon naj Pilato tet eb yin yoxelal jaxca ti': —¿Tzet yu xin? ¿Tzet jix sey smulne che yila? Jainti', c'am nioj smul tol smoo scam yu chi wil an. Yuxan, tu' c'al oj wak' mak'le an, catu' oj jin jajon el an, ẍi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero tol caw jix yi' atej sc'ul eb. Jix a yaw eb sic'lebil, tzet utbil tol sowalil chi cam naj yin culus. Caw ip jix a yaw eb yetoj eb yaaw yak'omal xaambal eb tet Dios. Yuxan jix yak' c'al ta' ganar eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yuxan jix yal Pilato tu' jaxca ti': “Ske' ojab jaxca chi yoche eb tu'” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yuxan, ja' jun winaj locan xol jowal tu', jun mak'om cam ánima ey oc preso tu', ja' jix jajle el oj jaxca jix yute sk'anon eb tu'. Jal Jesús jix ale can toj yul sk'ab eb yu chi yun tzet yetal chi yoche eb chi yun yin tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ja' yet lalan yi'ontoj Jesús eb bey oj cam tu', ey jun winaj a Cirene chi yij Simón, lalan sjul naj, jix bet ec'ab naj naat, jix smitx'on a eb. Jix yak'on te' culus eb tu' yij naj. Catu' jix oc tzajan yintaj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ec'al pax ánima jix oc tzajan yintaj. Ec'al eb ix, chi el yaw yok' yin naj. ");
INSERT INTO knjNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jix meltzotoj jacan Jesús yin eb, catu' jix yalon jaxca ti': —Jex txo ix a Jerusalén, manchej jex ok' win an. Ok'an nej je yin. Ok'an nej yin eb je yune'. ");
INSERT INTO knjNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yutol ey jun tiempoal oj jul oj catu' oj je yalon jaxca ti': “Caw watx' yet eb ix c'am yune', c'al eb man unewom ix oj, yetoj eb ix c'am yune' chi yak' txutxwoj, watx' pax yet eb,” je chi oj je yaloni. ");
INSERT INTO knjNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ja' yet jun tiempoal tu', oj yal eb ánima yu wonanlaj jaxca ti': “Tol oj wal ey tzet utbil chi yun stit wejna wan wonan tu' kiban,” ẍi eb oj yalon eb. Oj yalon pax eb yu tzalanlaj: “Ey oj wal tzet utbil chi yun cu muji can yalan wan tzalan tu',” ẍi eb oj yalon eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jainti', jaxca tol yax te' jin an, ta chi yun eb jaxca ti' e in an, yutol c'am jin mul, yel xa c'al yel miman tzet oj yun eb je yin, yutol laan jex jaxca junoj te' te' caw tajin xa, yutol ey je mul yul sat eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ey cawan xa mac txequel ey smul jix i'letoj cam yetoj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jix apni eb bey jun lugar chi yij Calavera. Chi yal yel oc apnoj Calavera, “Sbajil Jolome.” Ja' tu' jix slocba a Jesús eb yin culus. Catu' jix slocban pax a cawan ey smul tu' eb. Jun bey swatx' k'ab Jesús, jun bey sq'uexan. ");
INSERT INTO knjNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ja' yet lalan slocbale a Jesús yu eb, catu' jix yalon jaxca ti': —Mamin ak' miman c'ulal yin eb, yutol man yotaj oj eb tzet chi yune', ẍi Jesús tet Dios. Jix c'oli yak'on suerte eb soldado yin spichil Jesús tu', catu' jix spo'on ec' an eb yin. ");
INSERT INTO knjNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ja' eb ánima, jix oc bulan eb yilon wan tzet yetal chi yun tu'. Jix c'oli sbuchwa eb yaaw yin Jesús tu'. Jix yalon eb jaxca ti': —Jix colcha wan ánima yu. Jal tinani', ta tol yel ja' Cristo ti', catu' ja' sic'bil el yu Dios, scol ojab sba kila, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ja'c'ala' eb soldado pax oj, caw chi buchwa atoj eb yin. Jix apni eb scawilal. Jix yak'on eb vinagre yuq'ue. ");
INSERT INTO knjNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jix yalon eb tet jaxca ti': —Ta tol yel sreyal jaach eb Israel, col ja ba kila, ẍi eb tet. ");
INSERT INTO knjNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ey jayeb k'ane ey oc sjolomtaj naj. Tz'ibebil oc yin sti' eb Griego, eb Romano, yetoj eb Israel ẍi jayeb k'ane tu' jaxca ti': “Ja' jun mac txequel ti', sreyal eb Israel,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ey jun eb naj locan a yetoj tu', jix buchwa yin, jix yalon jaxca ti': —Ta tol yel jaach Cristo jaach, col ja ba wil an. Chi lawi jun tu' chon ja colon pax ja wetoj, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jal jun xa naj yetbi tu', jix tenchaneni, jix yalon naj jaxca ti': —¿Tumi c'am chach xiw nioj tet Dios? Ilala, lalan kaben sya'il yetoj. ");
INSERT INTO knjNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Jaonti', cu moo kaben sya'il, yu cu tolanen el cu penail. Pero jun ti', c'am nioj tzet jix el yuneni, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Catu' jix yalon naj tet Jesús jaxca ti': —Jesús, tol oj wal chin ja na'tej yet oj jaach jul ja wak'on Yaawilal, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jix yalon Jesús tu' tet jaxca ti': —Caw yel chi wal e ach, yet jun c'u ti', oj jaach apnoj wetoj an bey jun lugar chi yij Watx'ilal, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ja' yet chuman xa c'u jix k'ejbi masanil yul yiban k'inal ti', masanta' c'al yet a las tres. ");
INSERT INTO knjNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jix k'ejol el c'u. Catu' jix tzilchatoj snan an k'ap ey oc smajil oj yul snan stemplo Dios. ");
INSERT INTO knjNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Catu' jix a yaw Jesús yin ipal jaxca ti': —Mamin, chi wak' can jin pixan yul ja k'ab, ẍi Jesús tet Dios. Yet jix lawi yalon jaxca tu', jix cami. ");
INSERT INTO knjNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ja' yet jix yilon naj scapitán eb soldado tzet jix yune', jix yal naj watx' k'ane tet Dios. Jix yalon naj jaxca ti': —Caw yel, ja' jun winaj ti', caw c'am spenail, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ja' masanil ánima chi matz'li, jix yil masanil eb tzet jix yune'. Ja' yet jix paxtoj eb, caw chi cus sc'ul eb sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ja' masanil eb jix otajnen Jesús c'al wan eb ix ix jix oc tzajan yintaj yet jix tit bey Galilea, naat jix can linan eb, catu' chi matz'litej eb. ");
INSERT INTO knjNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ey jun winaj chi yij José, a conob Arimatea yul yet Judea. Watx' sc'ul naj, catu' watx' pax sbeybal naj. Yaaw ye xol eb yet yaawil. ");
INSERT INTO knjNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ma yaoc sba yetoj eb yet jix yunen eb jaxca tu'. Yutol lalan yechbanen swa'xi oc Dios yak'on Yaawilal. ");
INSERT INTO knjNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jix octoj José tu' bey Pilato, jix bet sk'anon eytej smimanil Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Catu' jix bet yi'on eytej tu'. Catu' jix spichon oc yul jun sábana. Catu' jix bet yaon can octoj yul jun ch'en ch'en jolbil xa. C'am to junoj camom chi mujle yul jun jolan tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ja' yet jun c'ual tu' lalan xa c'al yey c'u, catu' sc'ual pax yak'on lista sba eb Israel yu tzet chi sk'an yu eb yet jun xa sc'ual xewilal tuxa oj jul oj. ");
INSERT INTO knjNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ja' eb ix jix oc tzajan yintaj naj bey Galilea tu', jix bet eb yil ch'en ch'en tu'. Jix bet yilon eb tzet utbil jix yun yale can octoj smimanil naj yul ch'en. ");
INSERT INTO knjNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Catu' jix paxtoj eb. Jix bet swa'nen wan ambal suk'uk'i sab eb, yetoj wan sak'al yel sab chi jo'le oc yin smimanil tu'. Ja' yet sc'ual xewilal tu', jix xew eb jaxca ta' yalon sley eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ja' yet lalan to sajbi yet domingo, jun babel c'u yul semana, jix to eb ix bey jix bet muji can octoj smimanil Jesús tu'. Jix yi'toj wan ambal suk'uk'i sab eb jix swa'ne eb ix tu'. Ey pax wan xa eb ix jix to yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ja' yet jix apni eb, jix yilon eb tol elnaj xa jun ch'en ey oc smajil bey jix muji Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jix octoj eb yul ch'en, catu' jix yilon eb, c'am xa smimanil naj Kaawil Jesús tu' ey ec' titu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Caw jix q'uey a sc'ul eb yiloni. Jix yilon eb ey ec' cawan ángel jaxca yili winaj, linan oc eb bey sc'atan eb. Chi tzejeji yili spichil eb ángel tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yuxan, caw chi xiw eb ix, catu' jix ey t'anan eb sat tx'otx'. Jix yalon eb ángel tu' tet eb ix jaxca ti': —¿Tzet yuxan ja' bey chi muji eb camnaj ti' che sey naj tol iquis xa? ");
INSERT INTO knjNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","C'am xa naj ey ec' titi'. Jix pitzc'u a naj. Na' wej tej tzet jix yal can e ex, yet ey ec' bey Galilea. ");
INSERT INTO knjNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Jix yal can oj tol ja' Ak'bil Yopiso yu Dios xol eb je yet animail, sowalil oj ak'le yul sk'ab eb penawom, catu' oj ale oc yin culus, jix yaloni. Ja' yet yoxial, catu' oj pitzc'u a oj, ẍi jix yalon can e ex, ẍi eb tet eb ix. ");
INSERT INTO knjNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Catu' jix sna'ontej eb ix tzet albil can tet eb yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Catu' jix paxtoj eb. Jix to yalon eb jun sk'aneal ti' tet eb jusluc'wan ẍejab Jesús, c'al tet masanil eb scuywom. ");
INSERT INTO knjNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ja' ix María Magdalena, Juana, yetoj María xutx Jacobo, ja' eb jix bet alon wan k'ane tu'. Ey pax wan xa eb ix ix ey ec' yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero ja' eb ẍejab tu', tu' c'al chi yal eb ix sna'on eb. Ma ẍa' eb yabe. ");
INSERT INTO knjNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero ja' naj Pedro, jix a linan naj. Jix yak'on ani sto bey ch'en ch'en tu'. Jix apni c'al catu' jix yilon octoj yul ch'en ch'en tu'. Asanxane an pichile ey can xojli. Catu' jix paxtej. Caw jix q'uey a sc'ul naj yin wan jix yil tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ja' yet jun c'ual tu', ey cawan eb scuywom lalan sto yul be chi apni Emaús. Ja' jun conob tu', ey mi oxeb oj legua snan xol yetoj Jerusalén. ");
INSERT INTO knjNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ja' yet lalan sbey eb tu', lalan yalon eb yu tzet jix yun tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ja' yet lalan c'al yalontenen wan tu' eb, jix apni Jesús sc'atan eb. Catu' junne xa c'al chi ec' eb yetoj naj. ");
INSERT INTO knjNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Chi moyi a sat eb yu, yet watx' c'am chi yotane el eb ta tol ja' naj. ");
INSERT INTO knjNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jix sk'anlen Jesús tet eb jaxca ti': —¿Tzet yetal che yala, yet chex bey ti'? ¿Tzet yuxan caw chex cusi? ẍi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jix tak'wi jun chi yij Cleofas tet naj: —Yotaj masanil ánima tzet jix yun bey Jerusalén yet cabi-oxi ti'. Jal jaach, ¿tumi c'am cha wab nioj? Pero ilala, jix jaach ec' pax titu', ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","¿Tzet jix yun titu' xin? ẍi Jesús tu' tet eb. —Ey jun a Nazaret, chi yij Jesús, caw ẍejab Dios ye naj. Ja' tzet jix el swa'neni c'al tzet jix el yaloni caw miman yel oc apnoj yul sat Dios yetoj yul sat eb ánima masanil. ");
INSERT INTO knjNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero ja' eb yaaw yak'omal xaambal tet Dios, yetoj eb yaaw ye cu xol jix aon oc yul sk'ab camich. Yuxan jix yaon oc yin culus. ");
INSERT INTO knjNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ja' ton jun tu' chi kaoc yip oj cu c'ul, tzet utbil tol oj cu colcha el jaon Israel jon ti' yu. Pero ja' tinani', oxi tax jix yun wan tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ey wan eb ix ketbi jon jix q'uey a cu c'ul yu, yet jix kaben on, ja' yet jix sajbi, jix bet yilon ch'en ch'en eb bey jix bet muji can octoj smimanil Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ja' yet jix yilon eb tol man xa ey oj ec' smimanil tu', jix to eb yalon e on, tzet utbil tol jaxca weyiche jix yute yilon wan ángel eb. Jix yalon eb ángel tu' tet eb, tol iquis naj. ");
INSERT INTO knjNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jix c'al lawi tu' xin, ey wan eb ketbi jix bet ilon oj. Jaxca c'al yalon eb ix ix tu', quey tu' jix yute yilon eb. Pero ma yil yin Jesús eb, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yuxan jix yal Jesús tet eb jaxca ti': —Jaexti', jaxca tol c'am nioj je na'bal. Caw c'am che yaoc yin je c'ul jantaj tzet albil can yu eb ẍejab Dios peyxa. ");
INSERT INTO knjNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ja' Cristo sowalil ton t'inan yaben sya'il wan tu' yet c'am to chi oc Yaawilal, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Catu' jix ẍa'on el yich yalon tet eb, beytaj c'al ey oc sk'aneal yul An Juun Tz'ibebil can oj. Jix ẍa'ontej yich yalon tzettaj tz'ibebil can yu naj Moisés. Jix yalon pax tej tzet tz'ibebil can yu eb ẍejab Dios peyxa. ");
INSERT INTO knjNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ja' yet jix apni eb bey jun conob bey lalan sto eb tu', ian palan c'al yec' el Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero jix yak'on yip eb smitx'on oc tucan oj. Jix yalon eb tet jaxca ti': —Canan ketoj, ilala, lalan yey c'u, lalan xa sk'ejbi, ẍi eb tet Jesús. Ja' yet jix octoj yul na tu', jix can titu' yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ja' yet jix ey chotan yin meẍa yetoj eb, jix yi'on a jun ixim pan, catu' jix yalon yu diosalil tet Dios yu. Catu' jix ẍi'on ec' xol eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ja' yet jix yun jun tu', jaxca tol jix jajcha sat eb. Catu' jix yilon oc eb, tol ja' Jesús. Pero jix yesnen q'uey sba. Jix yilontej eb, c'am xa mac txequel. ");
INSERT INTO knjNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Catu' jix yalon eb jaxca ti': —Yel toni, caw jix jul cu na'bal yet jix yalon e on yul be, yet jix yak'on na'cha el ku, tzettaj chi yal yul An Juun Tz'ibebil can oj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jix to xa c'al eb bey Jerusalén yet jun txolan tu', jix il-le yin eb jusluc'wan ẍejab Jesús titu' yu eb, yetoj wan xa eb yetbi eb. Yaman ec' eb titu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jix yalon eb tu' tet eb cawan tu' jaxca ti': —Caw yel jix pitzc'u a naj Kaawil junel xa. Jix x'ox sba tet naj Simón ti', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Catu' jix yalontej eb cawan tu' tzet jix yun eb yul-laj be. Jix yalon pax tej eb tzet jix yun sna'cha el Jesús yu eb, yet jix ẍi'on ec' ixim pan. ");
INSERT INTO knjNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lalan to yalon eb wan tu', jix yilontej eb, ey xa ec' Jesús snan xol eb. Catu' jix yalon jaxca ti': —Ey ojab watx' c'ulal snan je xol, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jal eb, tu' c'al chi xiw eb catu' caw chi q'uey a sc'ul eb. Ja' sna'on eb tol lab jun chi yil eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero jix yal tet eb jaxca ti': —¿Tzet yuxan tu' c'al chi somcha el je c'ul yet chin je yiloni? ¿Tzet yuxan ey je caab c'ulal win an? ");
INSERT INTO knjNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ilala, il wej jin k'ab c'al wajan ti' an. Jain toni, mitx' jin wej an. Chi cam je yoc t'anan win an. Ja' junoj lab, toj ey ẍi'beal, toj ey sbajil bey watx' chex oc mitx'an yin jaxca wet ti' an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jix lawi yalon jun tu', jix x'oxon sk'ab tet eb tu', c'al yajan. ");
INSERT INTO knjNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Cax c'al chi tzala a eb, pero ja'c'ala' ian ma yaoc eb yin sc'ul, yutol tu' c'al chi q'uey a sc'ul eb. Yuxan jix yal pax tet eb jaxca ti': —¿C'am mi nioj tzet watx' chin lo' titi'? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yuxan jix yak' nioj bolbil pescado eb tet, c'al nian yal awcab. ");
INSERT INTO knjNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jix ẍa'on tu' catu' jix slo'on sattaj eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yet jix lawi slo'oni, jix yalon pax tet eb jaxca ti': —Ja' tinani', jix yun jaxca jix yun walon e ex yet jix jin ec' je yetoj. Ilala, jix wal e ex tol sowalil oj yun jantaj tzet yetal tz'ibebil can wu an yul sley Moisés, yetoj tzet tz'ibebil can yu eb ẍejab Dios, yetoj wan chi alon win an yul libro Salmo, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Catu' jix yak'on jajcha sna'bal eb, yet watx' chi na'cha el yu eb, tzet tz'ibebil can yul An Juun Tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yuxan jix yal tet eb jaxca ti' junel xa: —Ja' yul An Juun Tz'ibebil can jin k'aneal, jain Cristo jin ti' an, tol sowalil oj jin cam oj, yoxial tu', catu' chin pitzc'u pax a xol eb camnaj. ");
INSERT INTO knjNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yetoj pax oj, sowalil oj al-le el jin k'aneal xol ánima bey jun jun nación. Oj al-le el xol eb tol sowalil chi sna' sba sc'ul eb yin spenail, yet watx' chi jo'le q'uey spenail eb tu' yiban. Ja' bey Jerusalén ti' oj baboj al-le el jin k'aneal, catu' oj sajlemtoj bey jun jun conob. ");
INSERT INTO knjNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jaexti', oj je yak' je ba testigoal yin wan ti'. ");
INSERT INTO knjNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yak'naj can Dios sti', tol ey jun oj eyol e ex. Ja' ton jun tu', oj toj jin chejab oj. Pero echbane wej bey Jerusalén ti', masanta' c'al che cha' je yip oj ale eytej satcan, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Catu' jix yi'ontoj eb scuywom bey scawilal conob Betania. Jix sq'uetxba a sk'ab titu', catu' jix sk'anon swatx' c'ulal Dios yiban eb. ");
INSERT INTO knjNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lalan to sk'anon swatx' c'ulal Dios tu', catu' jix i'le atoj satcan, catu' jix can can eb yu. ");
INSERT INTO knjNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jix lawi yi'on ey sba eb tet, catu' jix meltzo eb yin tzala c'ulalil bey Jerusalén. ");
INSERT INTO knjNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jun jun c'al c'u chi bet eb bey stemplo Dios. Jix bet yalon watx' k'ane eb tet Dios. Amén.");
INSERT INTO knjNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ja' yet c'am to yul yiban k'inal ti', ey xa c'al ta' ec' jun mac txequel chi yij Sk'ane Dios, catu' Dios toni. ");
INSERT INTO knjNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ja' yet yichbanil, yet c'am to chi ẍa' el yich Dios swa'nen jun yul yiban k'inal ti' ey xa c'al ta' ec' jun mac txequel tu' yetoj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ja' jun mac txequel tu', jix yak'balne Dios yin swa'nen masanil tzet yetal. Yuxan, ta manaj yu jun mac txequel tu', c'am mi tzet jix wa'nelei. ");
INSERT INTO knjNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ja' yu jun mac txequel tu', yuxan chi ki' cu k'inale cu masanil. Catu' ja' yu sk'inal jun mac txequel tu', yuxan ey pax saj k'inal yin cu pixan. ");
INSERT INTO knjNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ja' jun saj k'inal tu', saj k'inale c'al ye snan xol k'ej k'inal. C'am chi tan yu k'ej k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ey jun winaj chejbiltej yu Dios, Juan sbi. ");
INSERT INTO knjNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ja' jul yak'naj sba testigoal yin jun saj k'inal tu', yet watx' chi yab masanil ánima sk'aneal tu', catu' chi yaon oc sc'ul eb yin. ");
INSERT INTO knjNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Manaj naj Juan tu' jun saj k'inal tu'. Tu' c'al jul yak'naj sba testigoal yin. ");
INSERT INTO knjNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ey jun caw yel saj k'inal yet Dios jix jul bey yul yiban k'inal ti'. Ja' chi ak'on saj k'inal yin spixan masanil ánima. ");
INSERT INTO knjNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ja' jun chi yij Sk'ane Dios tu', julnaj ec' yul yiban k'inal ti'. Ja' jix wa'nen pax jun yul yiban k'inal ti'. Pero ja' yet julnaj eytej tu', ma na'cha el yu eb ánima ta tol ja'. ");
INSERT INTO knjNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Julnaj ec' xol masanil tzet wa'nebil yu, pero jaywanne eb yet conob jix cha'le naj yu. ");
INSERT INTO knjNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero ja' jantaj mac jix ẍa'oni, jantaj eb jix yaoc sc'ul yin, ja' chi aloni, tol ey yalon yet eb yoc eb yuninal oj Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ja' yet chi oc eb yuninal oj Dios, jaxca tol chi ali eb junel xa. Pero man jaxca oj chi yun yali junoj ánima. Man yin oj sna'bal junoj winaj chi tita, yuxan chi ali eb. Pero ja' Dios chi i'on oc eb yuninal oj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ja' jun chi ijon Sk'ane Dios tu', jix oc yin animail. Julnaj ec' cu xol ti' jun tiempoal. Ja' jun tu' caw yel. Miman swatx' c'ulal Dios jix jul x'ox e on. Jix kil yin, caw miman yel oc apnoj yutol asan ch'an jun q'uetxan Sc'aal Dios tu' chejbiltej yu Smam. ");
INSERT INTO knjNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ja' naj Juan jix alontej sk'aneal jun tu', jix yal jaxca ti': —Ja' ton jun ti' jix wal e ex, tol ey jun tzunan winaj ec'ban yopiso naj wintaj an, yutol ja' yet c'am to chin ali, ey xa c'al ta' ec' oj, ẍi naj Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jix yalon naj Juan jaxca ti', catu' miman swatx' c'ulal jix x'ox e on. Yutol, tz'ajaji c'al jix x'ox swatx' c'ulal ti' e on. ");
INSERT INTO knjNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ja' naj Moisés, jix ak'on can sley Dios e on, caw ya'taj sjijelei. Pero ja' naj Jesucristo, ja' swatx' c'ulal Dios jix x'ox e on. Jix yak'on pax jun cuybanile caw yel. ");
INSERT INTO knjNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","C'am junoj mac txequel jix ilon yin Dios junel oj. Pero ja' jun q'uetxan Sc'aal tu', ey c'al ta' ec' yetoj Smam tobal k'inal. Ja' jix ak'on kotajne el oj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ja' junel, ey wan eb Israel a conob Jerusalén, jix chejtoj jaywan eb yak'omal xaambal tet Dios yetoj jawan xa eb yic'aal naj Leví sc'atan naj Juan. Jix bet sk'anlen eb chejabwom tu' jaxca ti': ¿Tzet ja wopiso? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Catu' jix yalon naj Juan tu' yin yal c'al tzet jix sk'anlen eb tu'. Watx' c'al jix yute yalon tet eb jaxca ti': —Jainti', ma jin Cristo oj, jun echbanebil ku, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Catu' jix sk'anlen eb tet junel xa: —¿Tzet pax ja wopiso xin? ¿Ma jaachti' Elías jaach? jun chi jul sattaj jun Cristo, ẍi eb tet naj. C'amaj, ma jin naj, ẍi naj tet eb. —¿Ma jaachti' ẍejab jaach Dios, jun echbanebil sjul ku? ẍi eb tet naj. —C'amaj, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jix sk'anlen eb tet junel xa: —¿Tzet ja wopiso xin? Al e on tzet pax ja wopiso, yutol sowalil oj kal kapni tet eb jix cu chejontej. Al e on, ¿tzet ja wei? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yuxan jix yal tet eb jaxca ti': —Jain ton albil can jin k'aneal yu jun naj ẍejab Dios chi yij Isaías peyxa yet jix yal jaxca ti': “Ey jun winaj chi awi bey cusiltaj tx'otx',” catu' chi yalon jaxca ti': “Jaxca che yute je wa'nen be yet chi jul junoj yaaw, jaxca tu' che yute je wa'nen je beybal, yutol oj jul naj Kaawil,” ẍi can oj, ẍi naj Juan tu' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ja' eb jix apni sc'atan naj Juan tu', ja' eb fariseo jix chejon eb. ");
INSERT INTO knjNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Jix sk'anlen pax el eb jaxca ti': —¿Tzet yuxan cha wak' bautizar ánima, ta man Cristo oj jaach, ta man Elías oj jaach, ta man naj ẍejab Dios oj jaach, jun echbanebil ku? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yuxan jix yal naj Juan tu' tet eb jaxca ti': —Jainti', chi wak' bautizar ánima yetoj ja'. Pero ey jun cu xol, man je yotaj oj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ja' jun tu', tzunan chi tit wintaj an, pero caw miman yel oc apnoj wintaj an. Yuxan, man jin moo oj woc yak'omal oj servil, cax c'al yin jin xuyon el x'anil xanab yin yajan naj, ẍi naj Juan tu' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ja' bey sk'axepal ec' ja' miman Jordán, bey jun lugar chi yij Betábara, ja' tu' chi yak' bautizar eb ánima naj Juan tu'. Ja' titu' jix bet eb sk'anle el wan ti' tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yet yewial tu', jix yilon sjul naj Jesús naj Juan tu', yuxan jix yal jaxca ti': —Ilala. Ja' jun lalan sjul ti', jaxca yopiso junoj no' me' chi ak'le yin xaambalil, quey tu' yopiso naj yu Dios, yutol ja' chi jul yu yi'on el cu penail cu masanil bey yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ja' ton jun jix wal an yet jix walon jaxca ti': “Ey jun tzunantoj tit wintaj an, pero ec'ban yopiso naj wintaj an, yutol ja' yet c'am to chin ali, ey xa c'al ta' ec' oj,” jin chi, jix waloni. ");
INSERT INTO knjNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ma wotajne el oj, mac txequel jun tu', pero jix jin jul ak'o bautizar ánima yetoj ja', yet watx' oj na'cha el yu eb Israel, mac txequel jun tu', ẍi naj Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jix yalon pax naj Juan tu' jaxca ti': —Jix wil yeyol Santo Espíritu yiban naj jaxca junoj no' uch, catu' jix oc can yin. ");
INSERT INTO knjNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Man to wotaj oj mac txequel jun tu'. Pero ja' jun mac jix jin chejontej wak'on bautizar ánima yetoj ja', ja' jix alon e in jaxca ti': “Jaach oj ja wil yeyol Santo Espíritu yiban jun mac txequel, catu' oj oc can yin. Ja' ton jun tu' oj aon oc Santo Espíritu yin ánima jaxca tol oj ak'le bautizar eb yu,” ẍi e in an. ");
INSERT INTO knjNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jainti', jix wil jun tu'. Yuxan chi wak' testigoal jin ba yin, tzet utbil tol ja' Jesús ti', Sc'aal ton Dios, ẍi naj Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Scaabial tu', ey ec' naj Juan junel xa yetoj cawan eb scuywom. ");
INSERT INTO knjNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Catu' jix yilontoj, lalan yec'ab Jesús, yuxan jix yal naj jaxca ti': —Ilala. Ja' jun chi ec' tu', jaxca yopiso no' me' chi ak'le yin xaambal yu ánima, quey tu' yopiso naj yu Dios, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ja' yet jix yaben jun tu' eb scuywom naj Juan tu', jix tzajlo eb yintaj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Catu' jix meltzotoj jacan Jesús yintaj, jix yiloni tol tzajan oc eb yintaj. Jix yalon jaxca ti': —¿Tzet che yoche? ẍi naj tet eb. —Jaach cuywam, ¿beytu' ey jaach ey ec' oj? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Sebach wej, jul il wej, ẍi naj tet eb. Catu' jix to eb yetoj naj, jix bet yilon eb, beytu' ey oc ec' naj, catu' jix can eb yetoj naj yet jun yey c'ualil tu' yutol a las cuatro xa mi yet jix to eb. ");
INSERT INTO knjNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ja' cawan eb tu' jix yab eb tzet jix yal naj Juan, yuxan jix oc tzajan eb yintaj Jesús. Ey jun chi yij Andrés xol eb, yuẍtaj sba naj yetoj Simón Pedro. ");
INSERT INTO knjNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jix lawi c'al sk'anab Andrés tu' yetoj Jesús, jix to seyon ec' jun yuẍtaj tu', jix ilcha c'al yu, jix yalon tet jaxca ti': —Jix ilcha naj Mesías ku, ẍi naj tet naj Simón. Mesías chi yal yel oc apnoj Cristo, naj Ak'bil Yopiso yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yet xa c'al jun txolan tu', catu' jix yi'ontoj jun yuẍtaj naj tu' sc'atan Jesús. Jix oc t'anan Jesús yin naj Simón tu', catu' jix yalon tet naj jaxca ti': —Simón, sc'aal jaach naj Jonás, Cefas oj ja wij can a oj, ẍi Jesús tet naj. (Cefas laan yetoj Pedro, ma ch'en.) ");
INSERT INTO knjNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yoxial tu', jix yoche chi to Jesús bey tx'otx' Galilea. Catu' jix ẍa'len sba naj yetoj Felipe: —Ec'an c'al cuywoj wintaj an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ja' naj Felipe tu', a conob Betsaida naj. Quey pax tu' naj Andrés yetoj Pedro, junne sconob eb. ");
INSERT INTO knjNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ja' naj Felipe tu', jix bet naj seyon ec' naj Natanael. Jix c'al ilcha naj yu, catu' jix yalon tet naj jaxca ti': —Ey jun jix ilcha ku. Ja' ton jun tu' tz'ibebil can sk'aneal yu naj Moisés yul slibroal ley. Tz'ibebil pax can yu eb ẍejab Dios yet peyxa. Ja' ton Jesús, sc'aal naj José, a conob Nazaret, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Catu' jix yalon naj Natanael tu' tet naj jaxca ti': —¿Tumi ey junoj swatx'il chi tit bey Nazaret xin? ẍi naj tet. —Sebach, toon kila, ẍi Felipe tu' tet. ");
INSERT INTO knjNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Catu' jix yilontoj naj Jesús, tol lalan sjul naj Natanael sc'atan. Catu' jix yalon yin naj Natanael tu' jaxca ti': —Ja' jun chi jul ti', ja' caw a Israel naj yul sat Dios, c'am chi i'le eytej sat ánima, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yuxan, jix sk'anle Natanael tu' tet Jesús jaxca ti': —¿Tzet utbil jix jin ja wotanen el xin? ẍi naj. —¿Wotaj xa jaach yet c'am to chach awtele yu naj Felipe? Xax xaach wila yet ey jaach ec' yich jun te' higo, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Jaach cuywam, yel ton Sc'aal jaach Dios. Sreyal jaach eb ket conob Israel, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","—¿Asanne mi yu jix wal tol jix jaach wil yich te' higo, yuxan cha waoc ja c'ul win? Pero ey wan xa milagro oj ja wila, tol yel xa c'al miman yel oc apnoj, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jix yalon pax Jesús tet eb ey ec' yetoj tu' jaxca ti': —Caw yel chi wal e ex an, oj je yila, tol jajan spuertail satcan. Catu' oj je yilon spax a eb yángel Dios, catu' oj je yilon yeyol eb wiban, catu' oj je yilon ya pax toj eb, yutol Ak'bil Wopiso yu Dios xol eb ket animail, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Caabi lawi jun tu' xin, catu' jix oc jun nupil bey conob Caná, bey yul yet Galilea. Jix bet xutx naj Jesús bey jun nupil tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jix bet pax ec' Jesús yetoj eb scuywom, yutol awtebil eb. ");
INSERT INTO knjNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jix lawi a svino eb, yuxan jix yal xutx Jesús tu' tet naj jaxca ti': —Jix lawi svino eb, ẍi ix tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Catu' jix yalon Jesús tu' jaxca ti': —Chicay, ¿tzet yuxan ja' e in an cha wala? C'am to chi a apnoj stiempoal jin tx'oxon el wipal xol ánima, ẍi naj tet xutx. ");
INSERT INTO knjNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Catu' jix yalon xutx naj tu' tet eb chi ak'on servil tu' jaxca ti': —Ja' masanil tzet oj yal Jesús e ex, che jije c'al, ẍi ix tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ey wajeb ch'en k'uchbal yet c'al ta' ja' ja' ey ec' titu'. Chim to joeb oj, ma wajeb oj moc yul jun jun. Snetal ya' eb yet chi sajbane el settaj yetal eb jaxca ta' sbeybal eb Israel. ");
INSERT INTO knjNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Catu' jix yalon Jesús tet eb chi ak'on servil tu' jaxca ti': —Ak' wej no wan net ti', ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Catu' ja' yet jix noi, jix yalon Jesús tet eb jaxca ti': —Tinani' xin, letx wej atej nioj, catu' che yak'on tet naj chi ilon slo'oal jun nupil ti', ẍi Jesús tet eb. Catu' jix yak'on tet naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ja' yet jix yablen naj yuq'ueni, ey xa oc svinoal. Man yotaj oj naj beytu' jix tit jun vino tu'. Pero ja' eb chi ak'on servil tu', yotaj eb, yutol ja' eb jix letxon atej. Ja' naj chi ilon slo'oal jun nupil tu' jix awten naj chi nupi tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Jix yalon naj tet naj jaxca ti': —Ja' sbeybal ánima, tol ja' vino watx' yuc'lei, ja' chi yak' eb uc'le sbabelal. Tzunan xa chi ale eltoj svino eb ey wal chi yal yuq'ui. Pero jaach, jix ja wa'ne can jun vino watx' yuq'ui. Tzunan xa, xa wi'tej uc'le oj, ẍi naj chi ak'on cuenta masanil tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ja' bey conob Caná, yul yet Galilea, ja' tu' jix x'oxo jun milagro Jesús. Babel milagro jun jix x'ox tu'. Quey ton tu' jix yute x'oxon el oj tol miman yipal, catu' jix yaon oc sc'ul eb scuywom yin naj. ");
INSERT INTO knjNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jix lawi c'al tu', jix to Jesús bey conob Capernaum. Jix to xutx c'al eb yuẍtaj c'al eb scuywom. Jix ey ec' eb jayeb c'u titu'. ");
INSERT INTO knjNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Lalan xa sjul jun sk'in eb Israel chi yij pascua. Yuxan jix to Jesús bey Jerusalén. ");
INSERT INTO knjNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ja' titu' jix octoj yul stemplo Dios. Catu' jix yiloni, ey eb chi txonwi wacax. Ey eb chi txonwi me'. Ey eb chi txonwi uch. Ey eb xin, q'uexo tumin chi yune'. ");
INSERT INTO knjNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ja' yet jix yilon jaxca tu' xin, jix swa'nen jun tx'an tz'um yin eyman. Jix ujtele eltej masanil eb yul stemplo Dios tu', yetoj c'al no' me' tu', c'al no' wacax tu'. Jix lawi tu' xin, jix smak'on el tiẍna stumin eb q'uexom tumin tu' sat meẍa. Jix tenon pax a pac'laboj smeẍa eb. ");
INSERT INTO knjNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Catu' jix yalon tet eb chi txonwi uch tu' jaxca ti': —I' wej el wan tz'iquin ti'. Manchej je yute sna jin Mam ti' txombalil, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Catu' jix sna'ontej tzet albil can yul An Juun Tz'ibebil can yu eb scuywom tu', bey chi yal jaxca ti': “Caw pitz'an oc jin c'ul jin ya' ilnen ja templo ti',” ẍi yul An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Catu' jix yalon eb yaawil ye bey Judea tu' tet naj jaxca ti': —¿Tzet milagroal junoj cha tx'ox e on, yet watx' chi kotajne el tol ey ja walon ja wet ja wunen wan ti'? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yuxan jix yal naj tet eb jaxca ti': —Ta che yak' lawoj jun stemplo Dios ti', yin yox c'ual catu' chi a pax wu junel xa an, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Catu' jix yalon eb yaawil ye bey Judea tu' tet naj junel xa jaxca ti': —Ja' jun stemplo Dios ti', cuarenta y seis jabil jix yak' eb swa'neni, ¿Tumi ta chi wa'xi yin oxeb c'u ja wu? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ja' stemplo Dios chi yaltej sna'on eb. Pero tol ja' smimanil naj chi yal pax oj. ");
INSERT INTO knjNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yuxan, ja' yet jix pitzc'u a xol eb camnaj, ja' yet tu' jix sna'ontej eb scuywom tzet jix yala, catu' jix yaon oc eb yin sc'ul tzet tz'ibebil can yul An Juun tu', c'al tzet albil can tet eb yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ja' yet ey ec' Jesús bey Jerusalén yu k'in pascua tu', ec'al mac jix yaoc sc'ul yin naj, yutol jix yil eb wan milagro jix x'ox naj. ");
INSERT INTO knjNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ja' Jesús ma yaoc eb yip oj sc'ul, yutol yotaj xa sna'bal masanil ánima naj. ");
INSERT INTO knjNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Man sowalil oj ey mac chi alon tet naj yu tzet chi sna' junoj mac txequel. Yutol yotaj naj tzet chi ec' yul cu c'ul jun jun jon. ");
INSERT INTO knjNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ey jun naj fariseo Nicodemo sbi, yaaw ye naj snan xol eb yet Israelal, c'al snan xol eb yet yaawilal. ");
INSERT INTO knjNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ja' naj Nicodemo ti', jix apni naj sc'atan Jesús yet jun ak'balil. Jix yalon naj tet Jesús jaxca ti': —Jaach cuywam, kotaj on tol Dios jix jaach aontej yu cu cuyomal oj on. Yutol asan yetoj yipal Dios chi c'al ske' x'oxle milagro jaxca cha wun ti', ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Catu' jix yalon Jesús tet naj jaxca ti': —Caw yel chi wal e ach an, ja' mac txequel c'am chi ali el yet scaelal, ma ske' yoc yul sk'ab Dios, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Catu' jix sk'anlen pax naj Nicodemo tu': —Ja' junoj icham ánima xa, ¿tzet utbil chi yun yali el yet scaelal? ¿Tumi chi to ske' yoc yin xutx junel xa, catu' chi ali el junel xa? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Catu' jix tak'wi Jesús jaxca ti': —Caw yel chi wal e ach an, ja' mac c'am chi ali yu ja' c'al yu Yespíritu Dios, ma ske' yoc yul sk'ab Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ja' mac txequel chi ali el yin ánima, ánima toni, ja' pax mac txequel chi ali el yu Espíritu, chi oc can Yespíritu Dios yin. ");
INSERT INTO knjNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Manchej q'uey a ja c'ul yutol chi wal wan ti', tol sowalil chi ali el masanil ánima yin scaelal. ");
INSERT INTO knjNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ja' ka'e' chi to beytu' chi yal sc'ul chi to coj. Chi kab yeq'ui, pero man kotaj oj bey chi to oc oj. Quey ton tu' eb chi ali yu Yespíritu Dios, c'am chi kil yin Yespíritu tu', pero chi kil tzet chi yun kin, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Catu' jix sk'anlen naj Nicodemo tu' junel xa: —¿Tzet utbil oj yun wan ti'? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Catu' jix tak'wi naj Jesús jaxca ti': —¿Tumi man ja wotaj oj wan ti' xin? Pero cuywam jaach pax xol eb ket Israelal. ");
INSERT INTO knjNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Caw yel chi wal e ach an, ja' tzet kotaj, ja' chi kala. Ja' tzet chi kil yetoj cu sat, ja' chi kal pax oj. Pero ja' jaexti', c'am che cha' pax je yab tzet chi kal e ex. ");
INSERT INTO knjNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ta c'am che cha' pax je yab tzet chi wal e ex yu tzettaj yetal ey yul yiban k'inal ti', ¿tumi oj je cha' pax je yabe, ta ja' tzettaj yetal ey satcan chi waltej e ex? ");
INSERT INTO knjNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","C'am to junoj mac txequel chi bet ec' bey satcan. Jal jin xin, ja' tu' titnaj jin, yutol jain Ak'bil Wopiso xol eb ket animail yu Dios, a satcan jin. ");
INSERT INTO knjNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jainti', jain Ak'bil Wopiso yu Dios xol eb ket animail, pero jaxca jix yute st'unban a jun ch'en yechel laba naj Moisés bey cusiltaj tx'otx', quey tu' oj yun wa t'unan oj. ");
INSERT INTO knjNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Oj jin a t'unan oj, yet watx', ja' masanil mac txequel chin aon oc yin sc'ul c'am chi q'uey el oj, pero tol oj ẍa' sk'inal eb tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yu caw ey scam c'ulal Dios yin eb yul yiban k'inal ti', yuxan jix yatej jun q'uetxan Sc'aal. Ja' mac txequel chi yaoc sc'ul yin naj Sc'aal Dios tu', man oj q'uey el oj, ey sk'inal yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Jix yatej jun Sc'aal Dios yul yiban k'inal ti' yu scolcha can el ánima, man yu oj sq'ueyon can el eb. ");
INSERT INTO knjNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ja' mac chi yaoc sc'ul yin Sc'aal Dios tu', jajbil el oj. Pero ja' pax mac c'am chi yaoc sc'ul yin naj xin, majan eb yutol c'am chi yaoc sc'ul eb yin jun q'uetxan Sc'aal Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jainti', jix jin eyol yul yiban k'inal ti' yu wak'on saj k'inal yin spixan eb ánima. Pero ey eb c'am chi ochen jun saj k'inal ti'. Yuxan, oj c'al can can sya'ilal yiban eb. Asan k'ej k'inal chi yoche eb, yutol asan spenail chi el yunen eb. ");
INSERT INTO knjNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ja' masanil eb chi unen spenail, ma yoche jun saj k'inal ti' eb. C'am chi yal sc'ul eb chi ẍa', yutol chi xiw eb ta chi txeclo el wan tzet man watx' oj chi el yunen eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero ja' eb chi jijen jaxca yalon jun cuybanil ja' caw yel, chi ẍa' eb jun saj k'inal ti', yet watx' chi txeclo el oj tol ey oc Dios yetoj eb yin tzet chi yune', ẍi Jesús tet naj Nicodemo tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jix lawi tu' xin, catu' jix to Jesús yetoj eb scuywom tu' bey Judea, catu' jix ey ec' naj jayeb c'u yetoj eb titu'. Catu' jix yak'on bautizar ánima eb cuywom tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chi yak'on pax bautizar ánima naj Juan bey jun lugar chi yij Enón, bey scawilal Salim, yutol caw ey ja' titu'. Jix apni eb ánima sc'atan, jix apni eb yak' bautizar sba tet naj Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ja' yet c'am to chi ale oc naj Juan tu' yul preso, catu' jix yunen c'al wan tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ey jaywan eb scuywom naj Juan jix steele sba eb yetoj eb Israel, yu tzet chi yute sajbanen spixan ánima. ");
INSERT INTO knjNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yuxan, jix bet yal eb jaxca ti' tet naj Juan: —Jaach cuywam, ja' jun jix ec' ja wetoj bey sk'axepaltoj ja' Jordán, jun jix ja wal e on, ja' jun tu', lalan yak'on bautizar eb ánima tinani'. Caw ey eb lalan yapni sc'atan naj, ẍi eb tet naj Juan tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Catu' jix yalon naj tet eb jaxca ti': —C'am junoj mac txequel comon c'al chi oc yopiso, ta manaj Dios chi ak'on tet. ");
INSERT INTO knjNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jaexti', jix je yab walon an, tol ma jin Cristo oj an. Jainti', tu' c'al babel chejbil jin tej. ");
INSERT INTO knjNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","K'inaloj ey junoj nupil chi oc tinani', ja' naj chi nupi, chi yi' junoj ix naj. Ta ey junoj yamigo naj ey ec' yetoj, chi c'al yab naj masanil tzet chi yal naj. Caw chi tzala naj sic'lebil, chi yaben naj tzet chi yal naj chi nupi tu'. Quey ton tu', ch'un jin tzala tinani', yutol lalan yapni eb ánima sc'atan Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ja' naj Jesús tu', sowalil chi a c'al can yopiso naj. Jal jin xin, c'uan c'ulal chi tan can ey wopiso, ẍi naj Juan tet eb scuywom tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ja' jun mac txequel eynajtej satcan, Yaaw ye yiban masanil ánima. Jal jaon a yul yiban k'inal jon ti', ánima jon c'al el cu masanil. Asan yet yul yiban k'inal ti' chi kala. Pero ja' jun mac eynajtej satcan tu' xin, Yaaw ye kiban cu masanil. ");
INSERT INTO knjNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ja' tzet abbil yu, yetoj tzet ilbil yu, ja' chi yala, pero c'am wal mac chi cha'on pax yab tet. ");
INSERT INTO knjNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ta ey eb chi cha'on yab tet naj, chi yak' sba testigoal eb yin tzet utbil tol caw yel chi yal Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yutol ja' jun mac txequel tu', ja' Dios jix chejontej. Yuxan, ja' sk'ane Dios chi yala. Ja' bey jun tu', tz'ajaji chi yun yak'on Yespíritu Dios tet. ");
INSERT INTO knjNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Sc'aal cu Mam Dios jun tu', caw cam c'ulnebil yu. Yuxan, ja' Smam tu', jix aon oc masanil tzet yetal yul sk'ab yu yak'on cuenta. ");
INSERT INTO knjNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ja' mac chi yaoc sc'ul yin naj Sc'aal Dios tu', ey sk'inal tol ey c'al yin tobal k'inal. Pero ja' mac c'am chi yaoc sc'ul yin naj xin, ma ẍa' k'inale eb tol ey c'al yin tobal k'inal. Ja' ti' yet eb, tol chi eytej sjowal sc'ul Dios yiban eb. ");
INSERT INTO knjNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jix abcha sk'umal yu eb fariseo tol ec'ban xa sbisil eb scuywom Jesús yintaj eb yet naj Juan. Ec'ban pax eb jix yak' bautizar. ");
INSERT INTO knjNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Manaj Jesús tu' jix ak'on bautizar eb, ja' eb scuywom naj. ");
INSERT INTO knjNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ja' yet jix yaben Jesús tol jix yab eb fariseo jun tu' xin, jix el eb bey Judea tu', catu' jix to bey Galilea. ");
INSERT INTO knjNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sowalil ja' yul yet Samaria chi ec' eb yet chi to tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yuxan ja' yet ey to ec' Jesús yul yet Samaria tu' xin, jix apni eb scawilal jun conob chi yij Sicar. Ja' jun tx'otx' ak'bil can yu naj Jacob tet jun sc'aal chi yij José yet peyxa. ");
INSERT INTO knjNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ja' titu' ey jun c'op jotbil can yu naj Jacob tu'. Chuman mi c'u jix apni Jesús sti' jun c'op tu'. Yutol caw chi c'umbi naj yu sbeyi, yuxan jix ey chotan sti' ja' tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jal eb scuywom xin, jix to eb sman nioj lo'be yet chuman bey jun conob scawilal jun c'op tu'. Ja' yet xax to eb tu', jix apni jun ix ix a Samaria, jix apni yu yi'on atej ya'. Jix yalon Jesús tet ix jaxca ti': —Ak' nioj ja' ti' wuq'ue, ẍi naj tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Catu' jix yalon ix tet naj jaxca ti': —¿Tzet yuxan cha wal e in an, yutol jaachti' Israel jaach, catu' cha k'anon pax ja' e in an? ¿Tumi man ja wotaj oj tol a Samaria pax jin an? ẍi ix tet naj Jesús tu'. Quey tu' jix yute sk'anab sba ix tet naj, yutol ja' eb Israel, c'am chi ẍa'le sba yak'on eb yetoj eb a Samaria tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jix lawi tu' xin, catu' jix yalon Jesús tet ix jaxca ti': —Chin k'an nioj ja' wuc' e ach, pero man ja wotaj oj mac jin txequel. Man ja wotaj oj pax tzet chi yoche Dios chi yak'a. K'inaloj ta ja wotaj, chim ja k'an e in an, catu' chi wak'on jun ja' ja' chi ak'on k'inale e ach, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Catu' jix yalon ix jaxca ti': —Mamin, ¿toj ey ja net cha wak' i'on atej ja'? Caw naat ey eytoj ja'. ¿Beytu' ey jun ja' chi ak'on k'inale cha wal tu' xin? ");
INSERT INTO knjNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ja' kichmam Jacob, ja' jun ja' ti' jix yuc'balne yetoj c'al yuninal, c'al no' nok'. Ja' yet jix cam naj, jix can jun c'op ti' e on. ¿Toj yel xa c'al miman ja wel oc apnoj yintaj naj Jacob tu'? ẍi ix tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yuxan jix yal naj tet ix jaxca ti': —Yal c'al mac chi uq'uen jun ja' ti', chi tit stajinti'al junel xa. ");
INSERT INTO knjNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero ja' eb chi uq'uen jun ja' chi wak' an, c'am xa bak'in chi tit stajinti'al eb junel xa. Yutol ja' jun ja' chi wak' ti', chi el sne ja', catu' chi a wolna ja' bey spixan eb, catu' chi ak'le sk'inal eb ey c'al yin tobal k'inal yu jun ja' tu', ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Catu' jix yalon ix tet naj jaxca ti': —Mamin, ak' nioj ja' ja' cha wal tu' e in an, yet watx' c'am xa bak'in chi tit jin tajinti'al, catu' man xa sowalil oj chi jul wi' wet bey jun c'op ti' an, ẍi ix tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Asi', i'tej ja wichamil, catu' chex jul je cawanil titi', ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—C'am wichamil an, ẍi ix tet naj. —Yel ton cha wala, c'am ja wichamil tinani'. ");
INSERT INTO knjNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ec'naj jowan winaj ja c'atan. Ja' naj bey ey jaach ec' tinani', man caw ja wichamil oj naj. Yuxan, yel ton cha wala, c'am ja wichamil, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jix lawi c'al yaben ix tzet jix al-le tet, catu' jix yalon ix tet Jesús jaxca ti': —Mamin, ẍejab jaach Dios chi wil an. ");
INSERT INTO knjNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ja' eb kichmam, jaon a Samaria jon ti', ja' bey jun wonan ti' chi jul ki' ey cu ba tet Dios. Jal pax jaex a Israel jex ti' xin, ja' ta' c'al bey Jerusalén sowalil chex to je yi' ey je ba tet Dios je yala, ẍi ix. ");
INSERT INTO knjNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Catu' jix yalon Jesús tet ix ix tu' jaxca ti': —Ab tzet oj wal an, txo ix. Ey jun tiempoal oj jul oj, tol man xa ja' oj bey jun wonan ti' oj je yi' ey je ba tet cu Mam Dios. Man xa sowalil oj jex toj pax bey Jerusalén tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ja' jaex a Samaria jex ti', che yi' ey je ba tet Dios je yaloni, pero man je yotaj oj pax Dios tu'. Jal jaon Israel jon ti', caw kotaj cu Diosal bey chi ki' ey cu ba. Ja' cu xol chi eltej jun Colwawom. ");
INSERT INTO knjNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ey eb ja' tet cu Mam Dios chi yi' ey sba yin yel. Tinani' jix jul stiempoal yi'on ey sba eb yin yel yin spixan jun jun. Ja' cu Mam Dios, quey ton tu' chi yoche sc'ul chi yun yi'on ey sba eb ánima tet. ");
INSERT INTO knjNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ja' Dios Espíritu toni, yuxan ta ey mac chi yi' ey sba tet, sowalil chi yi' ey sba eb yin yel yin spixan eb, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Catu' jix yalon ix tet naj jaxca ti': —Jainti', wotaj an, ey jun naj Mesías, ja' ton naj Cristo oj jul oj. Ja' yet oj jul naj tu', jichan c'al oj yute yalon masanil tzet yetal, ẍi ix tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—¿Toj wal mac to txequel? jain ton lalan jin k'anab ja wetoj ti' an, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jix lawi yalon Jesús wan tu', catu' jix apni eb scuywom tu'. Caw jix q'uey a sc'ul eb yet jix yilon eb, tol chi k'anab Jesús yetoj jun ix ix. Pero c'am junoj eb jix k'anlen el tet naj tzet chi yoche sc'ul chi sk'anle el tet ix, ma tzet chi yal yetoj ix. ");
INSERT INTO knjNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jix lawi jun tu', catu' jix sbejon can smoc ix sti' ja' tu', catu' jix to ix yalon yab eb ánima yul conob tu' jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ey jun winaj, caw yotaj masanil tzet jix el wuneni. Jix yaltej masanil. Toon nej wetoj an, toon nej kila. Tejan ja' Cristo, ẍi ix tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yuxan, jix to eb a conob tu', bet yilon bey ey ec' Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ja' yet c'am to chi apni eb ánima tu' sc'atan naj, catu' jix yalon eb scuywom tu' tet naj jaxca ti': —Wuẍtaj, lowan nioj, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Catu' jix yalon Jesús tet eb jaxca ti': —Ey jin lo'be, pero man je yotaj oj jun lo'be tu', ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ja' yu tzet jix yal tu', yuxan jix c'oli sk'anlen ec' eb xol jaxca ti': —¿Ey mi mac jix jul ak'on can slo'be? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Catu' jix yalon naj tet eb: —Caw yochwan jin c'ul chi wun tzet chi yoche sc'ul naj mac chejnen jin tej, chin wa'ne el smulnail, wan jix yaoc yul jin k'ab. Ja' yet chi wunen jun tu', jaxca tol ja' chi oc jin lo'be oj. ");
INSERT INTO knjNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jaexti', caneb to xaaw catu' chi oc c'upo trigo je yaloni. Pero jain chi wal e ex an: “Ilala, jix jul stiempoal sc'uplei.” Ja' yu eb tol to oj jin cha'on oj, yuxan chi wal jaxca tu' an. ");
INSERT INTO knjNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ey eb ec'naj xa mulna xol eb, jaxca mac chi txi'wi trigo. Ey pax eb chi mulna xol eb jaxca mac chi c'upon a trigo, yet watx' chi ẍa' eb ánima ti' jun k'inale tol ey c'al yin tobal k'inal. Ja' eb chi mulna tu', oj ẍa' spaj jun smulnail eb tu', yet watx' jun laan c'al oj yun tzala a eb masanil. ");
INSERT INTO knjNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yuxan yel ton ta' chi al-le jun k'ane: “Ey eb chi txi'on ey trigo. Tx'oj pax eb chi c'upon a oj,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Chex jin chejtoj mulna xol ánima jaxca junoj c'upom a trigo. Pero manaj jex jix jex babi mulna xol eb jaxca junoj txi'om ey trigo. Jaexti', jaxca tol tu' xa c'al oj je c'up tzet awbil yu eb tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ja' bey jun conob yul yet Samaria tu', ec'al eb jix yaoc sc'ul yin Jesús, yutol jix yal jun ix tu' xol eb jaxca ti': “Yotaj naj masanil tzet jix el wuneni, jix yal e in masanil an,” ẍi ix tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yuxan jix sk'an favor eb tet Jesús tu', yet watx' chi can yetoj eb yul sconob tu'. Yuxan jix ey ec' caab c'u yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ec'al to c'al mac jix yaoc sc'ul yin naj yet jix yaben eb tzet jix yal naj. ");
INSERT INTO knjNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Catu' jix yalon eb tet ix ix tu' jaxca ti': —Ja' yet sbabelal, ja' yu tzet jix ja wal e on yuxan jix kaoc cu c'ul yin Jesús. Jal tinani' xin, ja' caw Jesús jix alon e on. Yuxan, caw chi kaoc cu c'ul yin tinani', caw kotaj xa sic'lebil, tol ja' Jesús ti', caw yel Cristo, ja' ton cu Colomal cu masanil jaon a yul yiban k'inal jon ti', ẍi eb tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jix lawi yec' caab c'u bey Samaria tu', catu' jix to Jesús tu' bey Galilea. ");
INSERT INTO knjNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ja' ton Jesús alnen can oj, tol c'am yel oc apnoj junoj ẍejab Dios yul sat eb yet conob. ");
INSERT INTO knjNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ja' yet jix apni eb bey Galilea tu', caw tzala c'ulal jix yun ẍa'le apnoj yu ánima, yutol ja' yet jix bet eb ilo k'in pascua bey Jerusalén, ja' titu' jix yil eb, tol caw ey tzet jix bet yun Jesús titu'. ");
INSERT INTO knjNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jix apni Jesús bey jun conob chi yij Caná, bey yul yet Galilea tu', bey jix oc ja' ja' yin vinoal yu naj. Catu' bey jun xa conob chi yij Capernaum. Ja' titu' ey jun naj yaaw caw ya' ey jun sc'aal naj. ");
INSERT INTO knjNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ja' yet jix yaben naj tu' tol ja' Jesús speto bey Judea, jix apni bey Galilea tu', jix bet sk'anon favor tet naj, tol chi to naj yetoj bey sna, yu sto yak'le wa'xoj sc'ul sc'aal naj yaaw tu', yutol ian chi cam el jun sc'aal naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Pero jix yal Jesús tet naj tu' jaxca ti': —Ta c'am che yil milagro, wan tzet chi tx'oxon el wopiso, toj che yaoc je c'ul win an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Catu' jix yalon naj yaaw tu' tet Jesús jaxca ti': —Mamin, toon wetoj an, yajban iquis to jun jin c'aal tu', Ta c'am chach toi, oj cam naj, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Paxan toj. Ja' naj ja c'aal tu', man oj cam naj tinani', ẍi Jesús tet naj. Jix yaoc yin sc'ul naj tzet jix yal Jesús tu' tet. Catu' jix meltzo naj bey sna. ");
INSERT INTO knjNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yul xa be jix ẍa'le sba yetoj eb smoso. Jix yalon eb tet naj jaxca ti': —Man oj cam naj ja c'aal tu', iquis naj, watx' xa sc'ul naj, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Catu' jix sk'anlen naj tet eb jaxca ti': —¿Jantaj hora jix oc tucna sya'il tu'? ẍi naj tet eb. —Ewi taxa. Yet tz'eymo c'u jix sicbi jun k'ak' tu' yin naj, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Catu' jix sna'ontej naj tu', tol caw tz'eymo pax c'u yet jix yalon Jesús tet naj jaxca ti': “Ja' naj ja c'aal tu', man oj cam naj tinani'.” Yuxan jix yaoc sc'ul naj yin Jesús c'al yetoj eb ey bey yul sna. ");
INSERT INTO knjNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ja' ton jun yet scaab milagro tx'oxbanil el yopiso ti'. Ja' yet jix bet bey Judea, catu' jix apni junel xa bey Galilea, catu' jix yuneni. ");
INSERT INTO knjNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jix lawi tu' xin, catu' jix to Jesús bey Jerusalén tu', jix to yilon jun sk'in eb Israel. ");
INSERT INTO knjNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ja' bey Jerusalén tu', ey jun ja' lean ey oj, Betesda sbi yin sti' eb Israel. Scawilal spuertail chi yij sbi Yet No' Me', ja' titu' ey jun ja' tu'. Ja' bey jun ja' tu', ey joeb pat c'am yichlaj. ");
INSERT INTO knjNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ec'al eb ya' ey telan octoj yul-laj wan pat tu'. Ey eb c'am chi ske' yilwi. Ey eb c'am chi ske' sbeyi. Ey pax eb sicbinaj el smimanil. Ey ec' eb yechbanen sbilwi sat jun ja' tu', ");
INSERT INTO knjNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","yutol ey tiempo chi jul eytej jun ángel bey jun ja' tu', catu' chi jul yak'on bilwoj ja' tu'. Asan mac babel chi eytoj xol ja' yet chi xew sbilwi ja' tu', asan jun tu' chi wa'xi can sc'ul, chi wa'xi yin yal c'al tzet ya'bilal. ");
INSERT INTO knjNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ey jun winaj, treinta y ocho jabil sya'bi ey oj, ey ec' titu'. ");
INSERT INTO knjNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jix yilon Jesús tol telan ey sat tx'otx'. Catu' jix yotajnen el oj tol naatil xa tiempo quey tu' ye naj. Yuxan jix sk'anle tet naj jaxca ti': —¿Chim ja woche chi wa'xi can ja c'ul? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Catu' jix tak'wi naj tu' jaxca ti': —Chi woche, Mamin, pero ja' yet chi bilwi sat ja' ja' ti', c'am mac chi ok' sc'ul win an, catu' chin yaon eytoj xol ja'. Jun jun el, ja' yet chi wak'len jin to xol ja', tx'oj c'al mac chi babi yeytoj jin sattaj, ẍi naj tet Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yuxan jix yal Jesús tet naj jaxca ti': —Aan waan oj, i' a ja weyub. Beyan, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Eyman jix wa'xi sc'ul jun winaj tu'. Jix yi'on a sweyub naj, jix c'oli sbeyi. Asan tol sc'ual xewilal eb Israel yet tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yuxan ey jaywan eb yaawil ye bey Judea tu' jix alon tet naj jix wa'xi can sc'ul tu' jaxca ti': —Ja' tinani', sc'ual xewilal. Caw c'am sleyal ja wijon a ja weyub ti', ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—Ja' jun jix ak'on wa'xoj jin c'ul, ja' jix alon e in jaxca ti': “I' a ja weyub, beyan,” ẍi e in an, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yuxan jix sk'anlen eb tet naj jaxca ti': —¿Mac txequel jun jix alon e ach tol cha wi' a ja weyub tu', catu' chach beyi? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero man yotaj oj naj tzet sbi jun jix ak'on wa'xoj sc'ul tu', yutol caw ey ánima ey ec' titu'. Yuxan ma il-le yin Jesús yu naj, yutol jix calchatoj xol eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ja' to yet junel xa jix yil-len el sba Jesús yetoj naj yul stemplo Dios, catu' jix yalon tet naj jaxca ti': —Ilabi. Ja' tinani' watx' xa ja c'ul. Man xa cha wun spenail, yet watx' c'am xa chi jul junoj yel miman sya'ilal ja wiban, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Catu' jix to naj yalon tet eb yaawil ye bey Judea tu', tzet utbil tol ja' Jesús jix ak'on wa'xoj sc'ul naj. ");
INSERT INTO knjNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yuxan, caw jix tit sjowal sc'ul eb yin Jesús tu'. Jix yak'le eb seyon tzet utbil chi yute yak'on cam naj eb yutol yet sc'ual xewilal jix yunen wan tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero jix yal Jesús tet eb yaawil ye bey Judea tu' jaxca ti': —Ja' naj jin Mam, c'am bey chi oc tucan smulnail. Yuxan ja'c'ala' chin mulna pax jainti' an, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ja' yet jix yalon Jesús jaxca tu', tol jix yoche xa c'al eb chi yak' cam oj, man asanne oj yu ma sjije sc'ual xewilal, pero yu pax jix laba sba yetoj Dios, yet jix yalon oc Dios tu' Smam oj. ");
INSERT INTO knjNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jix yalon pax Jesús tet eb jaxca ti': —Caw yel chi wal e ex an, jainti' Sc'aal jin Dios an, c'am tzet chi ske' wunen jin txojli. Asan tzet chi wil swa'nen jin Mam, asan chi wun an. Masanil tzet chi yun jin Mam tu', chi wun pax jainti' an. ");
INSERT INTO knjNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ja' jin Mam tu', chin scam c'ulne jain C'aale jin ti'. Masanil tzet chi el yuneni, chi x'ox e in an. Ey to wan xa tzet oj x'ox e in tol oj q'uey a je c'ul yet oj je yiloni. ");
INSERT INTO knjNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yutol ja' jin Mam tu', chi ske' yak'on pitzc'u a eb camnaj, catu' chi yak'on sk'inal eb. Quey jin pax tu', jain C'aale jin ti'. Ta ey eb chi woche chi wak' sk'inal, chi wak' an. ");
INSERT INTO knjNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","C'am junoj ánima chi na'le oc yin yu jin Mam. Pero jain C'aale jin ti', jain jix ak'le can wopiso jin na'on oc yin eb masanil. ");
INSERT INTO knjNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Jix yak' can wopiso jin Mam tu' jain C'aale jin ti' an, yet watx' laan wel oc apnoj yetoj jin Mam tu' yul sat masanil ánima. Ta ey mac c'am wel oc apnoj yul sat, c'am pax yel oc apnoj jin Mam yul sat, yutol ja' jix jin chejontej. ");
INSERT INTO knjNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Caw yel chi wal e ex, ja' mac chi aben jin k'ane, catu' chi yaon oc sc'ul yin jun mac jix jin chejontej, ja' ton eb chi yi' can sk'inal tol ey c'al yin tobal k'inal. Man xa oj toj eb bey sya'ilal, yutol jix colcha can el eb yul sk'ab camich, catu' jix ẍa'on can sk'inal eb tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Caw yel chi wal e ex an, ja' tinani', jix jul stiempoal yaben eb camnaj ya waw, jain Sc'aal jin Dios ti' an. Ja' eb chi jijeni, ja' ton eb oj ẍa' sk'inal tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yutol ja' jin Mam ey yopiso yak'on sk'inal ánima. Jix yak' pax can jun yopiso tu' e in jain C'aale jin ti'. Yuxan, jainti', chi ske' pax wak'on sk'inal eb. ");
INSERT INTO knjNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jix yak' pax can wopiso jin na'on oc yin masanil ánima, yutol jain tol Ak'bil Wopiso xol eb ket animail yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Manchej q'uey a je c'ul yu wan tzet chi wal e ex ti' an. Yutol ey jun tiempoal yet ya toj tu', oj yab eb mujan xa ya waw an. ");
INSERT INTO knjNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Catu' oj a waan eb camnaj tu'. Ja' eb watx' tzet jix el yunen yul yiban k'inal ti', oj pitzc'u a eb, catu' oj ẍa'on sk'inal eb tol ey c'al yin tobal k'inal. Jal eb c'am swatx'il jix el yuten sba xin, oj pitzc'u pax a eb, pero oj toj can eb bey sya'tajilal yin junelne. ");
INSERT INTO knjNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jainti', c'am junoj tzet yetal chi ske' wunen yul wet jin txojli an. Jaxca chi yute yalon jin Mam e in an, quey tu' ch'un jin na'on oc yin. Bey c'al ian ch'un jin na'on oc yin, yutol manaj tzet chi ẍa' jin c'ul chin sey an, pero ja' tzet chi ẍa' sc'ul mac jix jin chejontej, ja' ton jin Mam. Ja' tzet chi yoche jin Mam, ja' ton chi wun an. ");
INSERT INTO knjNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ta jain c'al chi wak' testigoal jin ba, yet chi walon tol ey wopiso, c'am yel oc apnoj tzet chi wal tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero ey jun xa chi yak' sba testigoal yin wopiso. Ja' jun tu' wotaj an, tol caw yel chi yala. ");
INSERT INTO knjNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jaexti', jix bet je yak' k'anlele el tet naj Juan tzet wopiso. Ja' tzet jix yal wu tu' an, yel c'al el oj. ");
INSERT INTO knjNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jainti', c'am chi waoc yip oj jin c'ul tzet chi yal ánima win an. Tu' c'al chin jej je na' tzet jix yal naj Juan e ex, yet watx' chex colchai. ");
INSERT INTO knjNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ja' naj Juan tu', laan jaxca junoj tzejtebal jow ẍaw yajan, yutol jix x'ox can el tzet ye oc Dios. Yuxan, jix jex tzala a jayeb c'u yetoj. ");
INSERT INTO knjNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero ey jun xa ec'ban yel oc apnoj yintaj naj Juan tu'. Ja' tzet chi el wunen an, ja' jin Mam jix ak'on e in an. Ja' ton wan tu' chi ak'on testigoal win an, tol ja' jin Mam tu' jix jin chejontej. ");
INSERT INTO knjNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yetoj pax jin Mam, naj jix jin chejontej tu', chi yak' sba testigoal win an. Jaexti', c'am junel oj jix je yab yul snuk' sk'anabi. C'am bey jix je yil yin Dios junel oj. ");
INSERT INTO knjNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","C'am che yaoc sk'ane yin je c'ul, yutol c'am che yaoc je c'ul win an, jain chejbil jin tej yu ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yel c'ulal ton che cuy An Juun Tz'ibebil can oj, yutol ja' je na'oni, tol ja' yin An oj ilcha je k'inal tol ey c'al yin tobal k'inal ta che jije. Pero ja' yul An Juun tu' chi yaltej jin k'aneal. ");
INSERT INTO knjNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Cax c'al chi yal jin k'aneal pero c'am chi yal je c'ul chex jul pax e in an yet che cha' je k'inal tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","C'am yel oc apnoj yul jin sat swatx'ilal chi yal eb ánima win an. ");
INSERT INTO knjNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Jaexti', wotaj je na'bal an, c'am che cam c'ulne Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Jainti', ja' jin Mam jix jin chejontej, pero c'am chin je cha'. Ta ey junoj xa mac txequel chi jul yul yet, ja' jun tu' bian, oj je cha'. ");
INSERT INTO knjNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ta jaex c'al oc che mimanne je ba jun jun jex, catu' c'am che yoche chex mimanbinele yu Dios ja' caw yel, ¿toj oj ske' je yaon oc yin je c'ul? ");
INSERT INTO knjNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Manchej je na' tol jain oj wal a je penail tet jin Mam. Ey jun xa oj alon a je penail tet, ja' ton naj Moisés, naj che tz'aj je yaoc yip oj je c'ul. ");
INSERT INTO knjNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","K'inaloj ta che yaoc yin je c'ul tzet tz'ibebil can yu naj Moisés tu', chim je yaoc je c'ul win an, yutol jix s'ibe can jin k'aneal. ");
INSERT INTO knjNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ta c'am che yaoc yin je c'ul tzet tz'ibebil can yu naj tu', ¿tzet utbil oj je yute je yaon oc yin je c'ul tzet chi wal e ex an? ẍi Jesús tet eb yaawil ye bey Judea tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jix lawi tu' xin, jix to Jesús tu' bey jun xa sk'axepal ja' mar Galilea. Chi yij pax ja' mar tu', Tiberias. ");
INSERT INTO knjNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ec'al ánima jix oc tzajan yintaj naj, yu jix yil wan milagro eb jix x'oxo yet jix yak'on wa'xoj can sc'ul eb ya' ey. ");
INSERT INTO knjNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ja' Jesús tu', jix to yetoj eb scuywom bey jun wonan, catu' jix ey chotan yetoj eb titu'. ");
INSERT INTO knjNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tuxa chi jul stiempoal sk'in pascua eb Israel yet tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jix yilon Jesús tol caw ey ánima chi apni sc'atan. Yuxan jix yal tet naj Felipe jaxca ti': —¿Beytu' oj cu man low wan ánima ti'? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pero tu' c'al jix k'anle jaxca tu', yet watx' chi yabe tzet oj yal naj Felipe tu' tet, yutol yotaj xa naj tzet oj yute. ");
INSERT INTO knjNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Catu' jix tak'wi Felipe tu' tet naj jaxca ti': —Cax c'al mi ey caab cien quetzal ¿toj oj yab yin eb, catu' chi yi'on nioj yet masanil eb? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pero ey jun xa scuywom Jesús chi yij Andrés, yuẍtaj sba yetoj Simón Pedro, jix yal tet Jesús jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ey jun naj unin ey ec' cu xol ti', ey joeb span cebada naj i'bil yetoj cac'on spescado. Pero ¿tumi oj yab nian ti' yin masanil ánima? Ila, tol caw ec'al eb, ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jix lawi jun tu' xin, catu' jix yalon Jesús tet eb scuywom tu': —Al wej tet eb ánima ti', tol chi ey chotan masanil eb, ẍi naj tet eb. Catu' jix sjijen eb yey chotan oj. Ey mi joeb oj mil winaj. Ja' jun lugar bey ey ec' eb tu', caw ey an ch'im. ");
INSERT INTO knjNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Catu' jix ẍa'on ec' ixim pan naj Jesús. Catu' jix yalon yu diosalil tet Dios yu ixim. Catu' jix spo'on ec' yin eb scuywom tu'. Jaxa eb cuywom, jix po'ontoj yin eb jix ey chotan tu'. Quey pax tu' jix yute yetoj no' pescado, jantaj c'al chi yoche sc'ul jun jun eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ja' yet jix xew slow eb sic'lebil, jix yalon Jesús tet eb scuywom jaxca ti': —Yamba wej a masanil ixim jix can ti', yet watx' c'am nioj ixim chi etaxtoj, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ja' yet jix lawi ec' yi'on a ixim eb, lacaweb to xuc jix no can yu sobrail ixim joeb pan cebada tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Masanil eb ánima jix ilon jun milagro jix x'ox Jesús, yuxan jix yal eb jaxca ti': —Ja' ton jun ẍejab Dios ti', tol echbanebil sjul ku bey yul yiban k'inal ti', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero yotaj xa Jesús tol chi yoche eb tol chi smitx'a, catu' chi yaon oc naj sreyal oj eb, Yuxan jix el xol eb, catu' jix to xojli bey jun wonan tu' junel xa. ");
INSERT INTO knjNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ja' yet lalan xa sk'ejbi, jix to eb scuywom Jesús tu' sti' ja' mar. ");
INSERT INTO knjNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jix octoj eb yul barco, Jichan jix yute ec'toj eb bey conob Capernaum ey ec' sti' ja' mar tu'. Caw k'ej taninaj xa yet jix to eb. Jal pax Jesús xin, c'am to chi apni sc'atan eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lalan sbey eb yiban ja' tu', catu' jix tit jun miman ka'e' caw jow. Catu' jix a pomna ja' mar tu', jix mak'le a yu jun miman ka'e'. ");
INSERT INTO knjNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ey xam nan oj scaab legua xa bey ey eb, catu' jix yilontej eb tol lalan yapni Jesús yintaj eb. Chi bey naj yiban ja' yetoj yajan. Yuxan, caw jix xiw a eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero jix yal naj tet eb jaxca ti': —Jain ton Jesús jin ti' an, manchej jex xiwi, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Catu' jix tzala a eb, jix ẍa'on octoj naj eb yetoj yul barco. Ja' yet lalan yoctoj naj yul barco tu' jix apnoj eb sk'axepal ja' mar bey lalan sto eb tu' yin jun mutzsatil. ");
INSERT INTO knjNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ey c'al ec' eb ánima tu' yet yewial bey sk'axepal ec' ja' mar tu'. Catu' jix sna'ontej eb tol jun ch'an te' barco tu' jix sk'axpon ec' oj. Jix yil eb tol asan ch'an eb scuywom Jesús jix to yul te'. Catu' ma octoj Jesús yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pero ey wan barco jix tit bey conob Tiberias, catu' jix apni eb scawilal jun lugar bey jix lo'le ixim pan yet jix yak'on yu diosalil naj Kaawil yu ixim. ");
INSERT INTO knjNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Catu' jix yilontej eb ánima tu', c'am xa Jesús ey ec' oj, catu' c'am pax eb scuywom xol eb. Catu' jix oc eb yul wan barco tu', catu' jix to eb seyon ec' naj bey conob Capernaum. ");
INSERT INTO knjNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ja' yet jix ec' apnoj eb ánima sk'axepal ec' ja' mar tu' xin, jix ilcha Jesús yu eb. Catu' jix sk'anlen eb tet naj jaxca ti': —Jaach Cuywam, ¿janic' jix jaach jul titi'? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Catu' jix yalon naj tet eb jaxca ti': —Caw yel chi wal e ex an, asan yu jix no je c'ul yu jix wak' pan je lo' tu', yuxan chin jul je seyon ec' oj. Man yu oj tol jix je yil wan milagro jix jin tx'ox an, catu' jix na'cha el je yu tzet yel oc apnoj wan milagro tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Man ojab yin tzet chi cu lo' che yaoc je na'bal je seyoni, yutol tu' c'al chi lawi el oj. Ey jun xa tzet yetal jaxca tzet chi cu lo' tu', pero c'am bak'in chi lawi. Ja' chi ak'on je k'inal tol ey c'al yin tobal k'inal. Yuxan, ja' ojab jun tu' che yi' atej je c'ul je seyoni. Jain oj wak' jun tu' e ex an, yutol Ak'bil Wopiso xol eb ket animail yu Dios, jix jin tx'ox el cu Mam Dios an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Catu' jix sk'anlen eb tet naj jaxca ti': —¿Tzet chi yun cu seyon ec' jun tzet chi yoche sc'ul Dios tu' on xin? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Catu' jix yalon Jesús tet eb jaxca ti': —Tol ja' jun ti' chi yoche Dios che yune', chi yoche tol che yaoc je c'ul win an, yutol ja' jix jin chejontej, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jix lawi yaben eb jun tu' xin, jix sk'anlen pax eb tet naj junel xa jaxca ti': —¿Tzet milagroal junoj cha tx'ox e on xin, catu' chi kaon oc cu c'ul ja win? ¿Tzet chi ske' ja wu? ");
INSERT INTO knjNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ja' eb kichmam, ey jun milagro ilbil yu eb yet peyxa tu', yet jix slo'on maná eb bey jun cusiltaj tx'otx' jaxca yalon yul An Juun Tz'ibebil can oj, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yuxan jix yal Jesús tet eb jaxca ti': —Caw yel chi wal e ex an, manaj Moisés jix ak'on jun satcanil lo'be tu' tet eb. Pero ja' jin Mam, ja' chi aontej jun ja' caw lo'be chi tit satcan tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yutol ja' jun lo'be chi wal tol chi yak' Dios ti', ja' bey satcan jix eytej. Ey eb bey yul yiban k'inal ti' oj ẍa' sk'inal eb tol ey c'al yin tobal k'inal yu, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Mamin, ak' c'al jun lo'be tu' e on tobal k'inal, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Catu' jix yalon tet eb jaxca ti': —Jainti', jaxca lo'be wei, yutol ak'om k'inale jin an, tol ey c'al yin tobal k'inal. Ja' eb chi jul e in an, c'am xa bak'in oj tit swail eb. Ja' eb chin aon oc yin sc'ul, c'am xa chi tit pax stajinti'al eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero jaxca ta' jix yun walon e ex an, cax c'al chin je yila, ¿toj oj je yaoc je c'ul win an? ");
INSERT INTO knjNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Masanil eb chi yak' cu Mam Dios e in an, oj jul eb e in ti'. Ja' eb chi jul e in ti' an, c'am junoj eb man oj jin cha'. ");
INSERT INTO knjNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jainti', jix jin tit satcan, ja' yochwan jun jix jin chejontej chi jul wun an. Man yu oj wunen wochwan yul wet jin txojli, yuxan jix jin tita. ");
INSERT INTO knjNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ja' jin Mam jix jin chejontej, chi yoche sc'ul c'am junoj mac xol eb chi yak' e in ti' an, oj q'uey can el oj. Chi yoche tol jain, oj wak' pitzc'u a eb yet slawub c'ual. ");
INSERT INTO knjNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ja' yochwan jin Mam tu', tol masanil mac chi aben jin k'aneal, catu' chin yaon oc eb yin sc'ul, chi ẍa' can sk'inal eb tol ey c'al yin tobal k'inal. Yuxan, jain, oj wak' pitzc'u pax a eb yet slawub c'ual tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ja' yet jix yaben a eb yaawil ye bey Judea wan tu', pena jix yal eb yin Jesús. Yutol jix yal Jesús jun ti': “Jain ton jaxca lo'be wei, bey satcan jix jin eytej,” ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Yuxan jix yal eb jaxca ti': —Ja' jun winaj ti', ja' ton naj Jesús, naj sc'aal naj José. Kotaj smam c'al xutx naj. Pero lalan yalon pax naj tol bey satcan jix eytej yaloni, ẍi eb yaawil ye bey Judea tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Catu' jix yalon Jesús tet eb jaxca ti': —Manchej jin je buchu. ");
INSERT INTO knjNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","C'am junoj mac tu' c'al chi yak' jul sba e in an, ta manaj jin Mam chi chejontej eb e in an. Ja' eb chi jul e in ti' an, oj wak' pitzc'u a eb yet slawub c'ual. ");
INSERT INTO knjNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ey jun xol eb ẍejab Dios jix tz'iben can ey jaxca ti': “Oj cuyle masanil ánima yu Dios,” ẍi can naj. Yuxan, masanil mac chi yaoc xiquin yaben tzet chi yal cu Mam Dios, ta chi na'cha el yu eb tzet chi yala, oj jul eb e in an. ");
INSERT INTO knjNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Man lalan oj walon an, ta tol ey junoj mac jix ilon yin cu Mam Dios. Asanne jain wotaj yili, yutol jix jin tit bey ey ec' oj. ");
INSERT INTO knjNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Caw yel chi wal e ex an, ja' mac chin aon oc yin sc'ul, ey sk'inal yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jainti', jaxca tol lo'be jin, yutol ak'om k'inale jin tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ja' eb kichmam, lo'bil maná yu eb bey cusiltaj tx'otx', pero jix cam eb masanil. ");
INSERT INTO knjNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jal pax mac chi lo'on jun lo'be jix eytej satcan ti' xin, c'am bak'in oj cam eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Jain ton jix jin eytej satcan tu', laan jin jaxca lo'be, yutol ak'om k'inale jin tol ey c'al yin tobal k'inal. Yuxan, ja' mac chi lo'on jun ti', iquis c'al eb tobal k'inal. Ja' jun tzet yetal laan jaxca lo'be chi wak' lo'le ti', ja' ton jin mimanil. Chi wak' an, yet watx' chi ske' yiquisbi c'al ec' masanil ánima yin tobal k'inal, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Catu' jix steelen a sba eb yaawil ye bey Judea tu' yin tzet jix yal tu', catu' jix yalon eb jaxca ti': —¿Tzet oj yun yak'on smimanil jun winaj ti' cu chi', chi sna'? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Catu' jix yalon Jesús tet eb: —Caw yel chi wal e ex an, ta c'am che chi' jin mimanil ti', catu' c'am che yuc' jin chiq'uil ti', jain Ak'bil Wopiso xol eb ket animail yu Dios, ma ske' je cha'on je k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yuxan, yal c'al mac oj chi'on jin mimanil ti', catu' oj yuq'uen pax jin chiq'uil ti', ey sk'inal eb yin tobal k'inal. Jain c'al oj wak' pitzc'u a eb yet slawub c'ual. ");
INSERT INTO knjNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yutol ja' jin mimanil ti', caw laan jaxca lo'be, c'al jin chiq'uil ti', laan jaxca tzet chi uc'lei. ");
INSERT INTO knjNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yal c'al mac oj ẍi'on jin mimanil ti', catu' oj yuq'uen pax jin chiq'uil ti', junxane chi yun can wetoj. Ey c'al ec' win an, catu' ey jin pax ec' yin. ");
INSERT INTO knjNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ja' cu Mam Dios iquis c'al naj yul yet. Ja' jix jin chejontej. Yu Dios, yuxan iquis jin pax oj. Yuxan, ja' mac chi chi'on jin mimanil ti', oj wak' sk'inal eb tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ja' jun jaxca lo'be jix eytej satcan chi waltej ti', ja' jun ti', man laan oj jaxca maná lo'bil yu eb kichmam yet peyxa. Caw miman jix slo' eb, pero ila tol jix cam pax eb. Pero ja' mac oj lo'on jun jaxca lo'be ti', oj ẍa' sk'inal eb tol ey c'al yin tobal k'inal, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ja' wan cuybanile ti', ja' bey snail sculto eb Israel bey conob Capernaum, ja' titu' albil yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ja' yet jix yaben eb scuywom wan k'ane tu', ec'al eb jix alon jaxca ti': —Caw pena jun chi yal ti'. ¿Mac oj ẍa' sc'ul yaben wan chi yal tu'? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pero yotaj xa Jesús tzet yetal lalan yalon eb, yuxan jix yal naj tet eb jaxca ti': —¿Tumi chi somcha el je na'bal yu wan k'ane chi wal ti' an? ");
INSERT INTO knjNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Jainti', Ak'bil Wopiso xol eb ket animail yu Dios. ¿Tzet je chi ta che yil yet oj jin pax a bey jix jin tit an? ");
INSERT INTO knjNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ja' Yespíritu Dios chi ak'on k'inale tol ey c'al yin tobal k'inal. Jal cu mimanil xin, c'am yopiso yin yak'on k'inale. Ja' wan k'ane chi wal e ex ti' an, caw yel yet Espíritu. Yuxan, ja' chi ske' yak'on je k'inal tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero ey jaywan jex c'am chin je yaoc yin je c'ul, ẍi Jesús tet eb scuywom tu'. Quey tu' jix yute yalon Jesús tet eb jaxca tu', yutol yotaj xa yet tax yichbanil mac txequel eb man t'inan oj yaon oc sc'ul yin. Yotaj pax naj mac txequel jun t'inan oj aon oc naj yul sk'ab camich. ");
INSERT INTO knjNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jix yalon pax naj jaxca ti': —Yutol ey jex c'am che yaoc je c'ul win an, yuxan jix wal e ex, tol c'am junoj mac tu' c'al chi yak' jul sba e in an, ta manaj jin Mam chi i'on jul oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yet tax c'al tu' xin, ec'al eb scuywom tu' jix meltzo yintaj junel xa. Ma xa c'al yal sc'ul eb jix tzajlo yintaj naj. ");
INSERT INTO knjNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yuxan, jix sk'anlen Jesús tet eb lacawan jaxca ti': —¿Jal jex, jaexti', ma che yoche chex meltzo je yintaj pax oj? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Yuxan jix tak'wi Simón Pedro tu' tet naj jaxca ti': —Wuẍtaj c'am junoj xa mac txequel bey oj cu oc tzajan oj. Yutol ja' yin wan k'ane cha wal e on ti', ja' tu' oj cu cha' cu k'inal tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Jaonti', tuxa jix jaach kaoc yin cu c'ul. Kotaj tol jaachti', Cristo jaach. Jaachti', Sc'aal jaach Dios iquis, ẍi naj Pedro tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Catu' jix yalon Jesús tet eb jaxca ti': —Jaex lacawan jex ti', jain jix jex jin sic' can el oj. Pero ey jun je xol tol ẍejab diablo yei, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yu naj Judas, sc'aal naj Simón Iscariote, yuxan quey tu' jix yala. Yutol ja' Judas tu' t'inan c'al ta' yale oc naj yul sk'ab camich yu. Pero tol pax yet cuywomal sba yetoj eb jusluc'wan tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jix lawi tu' xin, jix c'oli yec'ab Jesús yul-laj yet Galilea. Jal yul-laj yet Judea tu' xin, ma yal sc'ul jix eq'ui, yutol ja' eb yaawil ye bey Judea tu', jix ochen jix mak'on cam naj. ");
INSERT INTO knjNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pero c'uxan c'al tol lalan sjul pax jun sk'in eb Israel chi yij Sk'inal Patlaj. ");
INSERT INTO knjNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yuxan jix yal eb yuẍtaj Jesús tet jaxca ti': —Manchej jaach ey ec' titi'. Asi' bey Judea, yet watx' chi yil pax eb ja cuywom a lugar titu' wan milagro cha tx'oxo. ");
INSERT INTO knjNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ta ey junoj mac txequel chi yoche sc'ul chi otajnele el yu ánima, c'am junoj tzet yetal tol ja' bey ewantaj chi yune'. Yuxan, quey ojab tu' cha wute ja ba. Ta yel ey milagro chi el ja wuneni, sowalil cha tx'ox el ja ba sattaj ánima, ẍi eb tet. ");
INSERT INTO knjNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Quey tu' jix tz'aj yal eb yuẍtaj tu' tet, yutol c'am chi yaoc sc'ul eb yin naj. ");
INSERT INTO knjNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Catu' jix yalon Jesús tet eb jaxca ti': —Man to sc'ual oj jin tx'oxon el jin ba. Jal jex xin, yal c'al mi tzet c'ual chi ske' je na'oni. ");
INSERT INTO knjNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ja' eb je yet yul yiban k'inal ti', c'am chi ske' ẍichon oc sc'ul eb je yin. Pero ja' win chi chichon oc sc'ul eb, yutol chin tx'ox el oj tol pena sbeybal eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Asi' wej, tx'ox el je ba bey jun k'in tu' jaexti'. Jainti', c'am to chin toi, yutol man to sc'ual oj jin tx'oxon el jin ba, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Catu' jix can can bey Galilea tu' yet jix lawi yalon jaxca tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ja' yet xax to eb yuẍtaj tu' bey jun k'in tu', jix to Jesús pax oj, catu' yin ewantajil jix yun yapni. ");
INSERT INTO knjNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Caw jix seyle ec' naj yu eb yaawil ye bey Judea bey jun k'in tu': —¿Beytu' la ey jun winaj tu'? ẍi eb chi ec' eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Miman tzet chi al-le yin naj xol ánima titu'. Ey eb chi aloni: “Caw watx' jun winaj ti',” ẍi eb. Pero ey pax eb chi aloni: “C'amaj, pena, chi etnele eb ánima yu,” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ewantajil chi yal eb jaxca tu', yutol chi xiw eb, tala chi yab eb yaawil ye bey Judea tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Snan wal ey oc jun k'in tu', catu' jix oc Jesús yul stemplo Dios. Catu' jix c'oli scuywa xol ánima titu'. ");
INSERT INTO knjNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Caw jix q'uey a sc'ul eb Israel ey octoj yul tu' yabeni. Catu' jix yalon eb jaxca ti': —¿Tzet jix yute yotajnen el wan chi yal jun naj ti', tol pax man cuywinaj oj? ẍi xa c'al eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yuxan jix yal Jesús tet eb jaxca ti': —Ja' wan cuybanile chi wal e ex ti' an, man wetoj an. Yet naj mac jix jin chejontej. ");
INSERT INTO knjNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ta ey mac chi yal sc'ul chi yun yochwan Dios, oj na'cha el yu, tol yet Dios wan cuybanile ti', catu' man yul oj wet chi walon an. ");
INSERT INTO knjNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ja' mac tol yul c'al yet chi k'anabi, tol chi yi' can a sba, yet watx' miman xa c'al yel oc apnoj sna'oni. Pero jainti', chi woche tol ja' naj mac jix jin chejontej, ja' ojab naj miman yel oc apnoj yul je sat. Yuxan, caw yel chi wal an. C'am c'al lek'ti'al chi wun an. ");
INSERT INTO knjNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ak'bil can sley Dios e ex yu naj Moisés, pero ila, c'am junoj jex che jije tzet chi yal jun ley tu'. ¿Tzet yuxan che yoche chin je yak' cam oj? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Catu' jix tak'wi eb ánima bulan ec' titu' tet naj jaxca ti': —Jaachti', tejan ey junoj pena espíritu ey oc ja win. ¿Mac txequel junoj chi ochen chach yak' cam tu' cha wila? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yuxan jix yal pax naj tet eb jaxca ti': —Asan yu jun tzet jix el wunen yet sc'ual xewilal, yuxan caw jix q'uey a je c'ul yu. ");
INSERT INTO knjNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ja' tax eb kichmam yet peyxa, ja' tax eb jix i'on can el yich jun beybale chi yij circuncisión. Catu' ja' naj Moisés jix alon can tol sowalil chi cu beybalne jun tu'. Yuxan, cax c'al sc'ual xewilal, che yak' circuncidar eb unin chi ali, ");
INSERT INTO knjNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","yet watx' c'am che ten tzet chi yal sley Moisés tu', yuxan che yak' circuncidar eb unin yet sc'ual xewilal. ¿Tzet yuxan chi tit pax je jowal win an, yu jix wak' wa'xoj sc'ul naj tu' yet sc'ual xewilal? ");
INSERT INTO knjNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Man ojab comon oj che na' oc win an. Ta ey mac che na' oc yin, watx' ojab che yute je na'on oc yin, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yuxan ey jaywan eb a Jerusalén jix alon jaxca ti': —¿Tumi manaj jun winaj ti' chi seyle ec' yu eb chi ochen chi ak'on cam oj? ");
INSERT INTO knjNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pero tol ey ec' titi', lalan sk'anab cu xol. C'am c'al tzet chi al-le pax tet. Tejan jix yaoc sc'ul eb yaaw yin, tol ja' ton Cristo. ");
INSERT INTO knjNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ja' yet oj jul Cristo tu', c'am mac otajnen bey oj tit oc oj. Pero jun winaj ti', kotaj beytu' jix tita, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ja' yet jix yaben Jesús wan tu', lalan yak'on wan cuybanile snan xol eb ey octoj yul stemplo Dios tu', catu' jix yalon eltej xol eb jaxca ti': —Yel toni, je yotaj jin an, catu' je yotaj pax bey titnaj jin an. Pero man yul oj wet jix jin juli. Ja' naj ja' caw yel, ja' naj jix jin chejontej. Pero man je yotaj oj naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Jal jin xin, wotaj naj, yutol ja' titu' jix jin tit an. Ja' ton jix jin chejontej, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Lalan yalon wan ti', catu' ey eb jix ochen jix aon oc naj preso. Pero c'am junoj mac txequel jix oc lacan yin naj, yutol man to sc'ual oj scami. ");
INSERT INTO knjNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ec'al eb ánima jix yaoc sc'ul yin, catu' jix yalon eb jaxca ti': —Ja' yet oj jul naj Cristo, ¿tumi yel ec'ban milagro oj x'ox yintaj jun ti'? ẍi eb. Yuxan jix yaoc eb yin sc'ul tol ja' ton Cristo naj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ja' yet jix yaben eb fariseo tzet chi yal eb ánima yin Jesús tu', junne eb yetoj eb yaawil yak'omal xaambal eb Israel tet Dios, jix chejontoj eb policía steynemal templo yu sto tit Jesús preso yalon eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Catu' jix yalon Jesús tu' jaxca ti': —Jayeb xane c'ual ey jin ec' je yetoj. Oj lawoj tu' xin, oj jin pax a bey ey naj jix jin chejontej an. ");
INSERT INTO knjNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jaexti', oj to jin je sey ec' oj, pero ma xa jin ilcha je yu, yutol ma ske' je yapni bey oj jin apnoj tu', ẍi tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Catu' jix k'anab a eb Israel xol yet jaxca ti': —¿Bey la tu' oj toj jun ti', yuxan chi yala tol man oj ilcha ku, sna'oni? Toj ja' bey eb ket conob ey ec' xol eb griego. ¿Tumi ta chi yoche ja' titu' oj toj xol eb, catu' chi to cuywa xol eb griego tu', sna'oni? ");
INSERT INTO knjNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ila tol jix yal e on jaxca ti': “Jaexti', oj to jin je sey ec' oj, pero man xa oj jin ilcha je yu, yutol ma ske' je yapni bey oj jin apnoj tu',” ẍi naj e on. ¿Tzet la chi yal yel oc apnoj wan jix yal e on tu' tinani' xin? ẍi eb Israel tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ja' yet jun c'u yet chi lawi can el k'in, ec'al ánima jix yamchai. Yuxan ja' to yet slawub sc'ual k'in tu', jix a linan Jesús snan xol eb, catu' jix yalon yin ipal jaxca ti': —Ta e ex che yoche che cha' can k'inale tol ey c'al yin tobal k'inal, sebach wej e in an. Jaxca che yute che yuq'uen ja' ja' yu je tajinti'al, quey tu' oj je yute je cha'on jun k'inale tu' e in an. ");
INSERT INTO knjNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ta e ex che yaoc je c'ul win an, jaxca tol ey jun ja' ja' oj aol snuk' yin je pixan, catu' oj el sne. Ja' ton jun tu' oj ak'on je k'inal tol ey c'al yin tobal k'inal. Yutol jaxca tu' yalon can An Juun Tz'ibebil can oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Quey tu' jix yute yalon jaxca tu', yutol ja' eb chi yaoc sc'ul yin naj, chi ale oc naj Espíritu yin eb yu. Ja' yet jun tiempoal tu', c'am to chi ak'le Espíritu tet eb ánima, yutol c'am to chi pax a Jesús bey satcan. ");
INSERT INTO knjNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jix lawi c'al yaben eb ánima tu' tzet jix yal Jesús tu', catu' jix yalon eb jaxca ti': —Caw yel, ja' ton jun ẍejab Dios tol echbanebil sjul ku ti', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ey pax eb jix aloni: —Ja' jun ti', ja' ton naj Cristo, ẍi eb. Pero ey wan xa eb jix alon jaxca ti': —Ja' jun Cristo tu', ¿tumi a Galilea jaxca jun ti' che na'? ");
INSERT INTO knjNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Chi yal yul An Juun Tz'ibebil can oj, tol ja' jun Cristo tu', ja' bey conob Belén sowalil chi ali, bey ec'naj David yet peyxa, yutol yic'aal naj David, ẍi wan xa eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yuxan jix teele ton a sba eb ánima tu' yu c'al Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ey jaywan eb jix ochen jix aon oc naj preso, pero c'am junoj mac txequel jix oc lacan yin naj. ");
INSERT INTO knjNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Asan eb policía, eb steynemal stemplo Dios, jix paxtoj eb xojli bey eb fariseo, yetoj bey eb yaawil yak'omal xaambal eb Israel tet Dios, tutun ja' eb jix chejontoj eb. Catu' jix k'anlele el tet eb tu': —¿Tzet yuxan ma je yi'tej Jesús tu'? ẍi eb tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Pero c'am junoj mac txequel chi apni sk'anab jaxca jun tu', ẍi eb policía tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Catu' jix yalon eb fariseo tu' tet eb jaxca ti': —¿Tumi che yak' pax je ba etnele jaexti' xin? ");
INSERT INTO knjNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Ey mi junoj eb cu yaawil ti' chi yaoc sc'ul yin naj? Ja'c'ala' jaon fariseo jon ti', c'am junoj jon chi kaoc cu c'ul yin naj. ");
INSERT INTO knjNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Asan eb comon ánima, eb man yotaj oj nioj sley Moisés, asan eb chi yaoc sc'ul yin. Pero ey sjowal sc'ul Dios yiban eb, ẍi eb fariseo tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ey jun yet fariseoal eb tu' chi yij Nicodemo. Jun betnaj ec' k'anab yetoj Jesús yet ak'balil. Ja' jun tu' jix alon tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Ja' yalon cu ley, tol c'am sleyal chi kaoc sya'ilal yiban junoj mac txequel ta c'am chi kab tet tzet smul, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Yuxan jix yal eb tet naj jaxca ti': —¿Tumi a Galilea jaach yetoj jun winaj tu'? Il yul An Juun Tz'ibebil can oj, ja' titu' oj ja wila, tol c'am junoj ẍejab Dios chi tit bey Galilea, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Catu' jix pax can jun jun eb bey sna. ");
INSERT INTO knjNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jal pax Jesús tu' xin, jix to can bey wonan Olivalaj. ");
INSERT INTO knjNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ja' yet jix k'inibi a yet yewial tu', jix apni pax Jesús bey stemplo Dios junel xa. Ja' yet jix apni naj tu', masanil eb ánima ec' titu' jix yamcha oc sc'atan naj. Catu' jix ey chotan naj scuyon eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Catu' jix i'letej jun ix ix sc'atan naj yu eb cuywam yin sley Moisés tu' yetoj eb fariseo tu'. Lalan smulwi ix, catu' jix mi'cha el ix yu eb, jix i'letej ix sc'atan naj yu eb. Ja' sattaj masanil eb ánima jix oc linan jun ix tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Catu' jix yalon eb tet naj jaxca ti': —Jaach cuywam, ja' jun ix ti', lalan smulwi yet jix ilcha el ku on. ");
INSERT INTO knjNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ja' sley Moisés chi aloni, tol ja' eb ix ix quey tu' sbeybal jaxca ti', sowalil chi k'ojch'ennele can cam eb. Jal jaach, ¿tzet ja chi jaachti'? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pero tu' c'al jix tz'aj sk'anle eb jaxca tu', yu yak'le porobal naj yu eb, yutol chi yoche eb, tol chi ak'le queja naj yu eb. Ja' Jesús tu', tu' c'al jix ey noan oj, catu' jix tz'ibli ey yetoj yiximal sk'ab sat tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Catu' jix sk'anlen eb tet naj jaxca ti': —¿Tzet wal chi yun jun ti' xin? ẍi eb tet naj. Yuxan jix a linan naj, catu' jix yalon tet eb jaxca ti': —Ta ey junoj jex c'am nioj je penail, ja' ojab chi babi sk'ojon oc ch'en ch'en yin ix, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jix lawi yalon jaxca tu', jix ey pax noan junel xa. Catu' jix tz'ibli ey junel xa sat tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ja' yet jix yaben eb tzet jix yal tu', jix sna'on sba jun jun eb, tol ey spenail jun jun eb. Yuxan, jun jun ta' xa c'al jix yun spaxtoj eb. Ja' eb ichamtaj winaj jix babi cha'on el yich yeltoj, catu' tzajan yeltoj eb ach'e. Xojli xa c'al Jesús jix can bey linan oc ix ix tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Catu' jix a linan oj, catu' jix yiloni, xojli xa c'al ix ix tu' linan can oc oj, catu' jix yalon tet ix jaxca ti': —Txo ix, ¿beytu' ey eb chach ak'on queja tu'? ¿C'am mi junoj mac txequel jix ak'on queja ja win? ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—C'am mac txequel, Mamin, c'am junoj, ẍi ix. —Yetoj jin pax oj, man oj wak' queja ja win an. Asi' manchej xa ja sey ja mul junel xa, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Catu' jix yalon Jesús xol eb ánima tu' jaxca ti': —Jainti', jaxca saj k'inal we xol eb ket animail bey yul yiban k'inal ti'. Ja' mac chi oc jin cuywom oj an, oj wak' saj k'inal bey spixan. Yu jun saj k'inal tu', yuxan oj ẍa' sk'inal eb tol ey c'al yin tobal k'inal. Ma xa ec'ab eb xol k'ej k'inal, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Catu' jix yalon eb fariseo tu' tet naj jaxca ti': —Jaachti', yul c'al ja wet cha waloni tol ey ja wopiso. Yuxan c'am yel oc apnoj nioj ja wet cha wal tu', ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yuxan jix yal pax naj tet eb jaxca ti': —Cax c'al mi yul wet chi walon an, tol ey wopiso, pero caw yel chi wal an. Yutol jainti', caw wotaj bey jix jin tit an. Yetoj pax oj, wotaj bey oj jin toj an. Jaexti', man je yotaj oj bey titnaj jin an, catu' man pax je yotaj bey oj jin toj. ");
INSERT INTO knjNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jaexti', tu' c'al comon che na' oc yin junoj mac txequel yin eyman. Jainti', c'am mac chin na' oc yin. ");
INSERT INTO knjNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero k'inaloj ta ey mac chi woche chin na' oc yin, jichan c'al ch'un jin na'on oc yin. Yutol man jin txojli oj chin na'on oc yin. Junne ey jin Mam wetoj an, yutol ja' jix jin chejontej. ");
INSERT INTO knjNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ja' cu ley ey ec' yul cu k'ab chi aloni, ta tol ey cawan oj testigo laan c'al yaloni, sowalil chi cu cha' kab tzet chi yal eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pero ilabi, ey cawan mac chi yak' sba testigoal win an. Chi wak' jin ba testigoal win an. Testigo pax jin Mam wetoj an, yutol ja' chejnen jin tej, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—¿Pero beytu' ey ja Mam tu' xin? ẍi eb tet naj. Jix yalon Jesús tet eb jaxca ti': —Jaexti', man je yotaj oj mac jin txequel. Man je yotaj oj pax jin Mam tu' an. K'inaloj ta je yotaj mac jin txequel, je yotaj pax jin Mam tu', ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ja' yul stemplo Dios, bey scawilal cha'bal sa'beal tet Dios, ja' titu' jix yal Jesús wan ti'. Ja' titu' jix cuywa xol ánima. C'am junoj mac jix oc lacan yin, yutol c'am to chi jul sc'ual scami. ");
INSERT INTO knjNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jix yal Jesús tet eb junel xa jaxca ti': —Oj jin toj, jainti'. Oj to jin je sey ec' oj, pero xol je penail oj jex cam oj. Catu' ma ske' je yapni bey oj jin apnoj tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yuxan jix yal eb yaawil ye bey Judea tu' jaxca ti': —Tejan oj yak' cam sba yul yet, yuxan chi yala, tol ma ske' kapni bey oj apnoj tu', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Catu' jix yalon pax naj tet eb jaxca ti'. —Jaexti', a sat tx'otx' jex, yutol yet jex yul yiban k'inal ti'. Jainti', man yet oj jin jun yul yiban k'inal ti', yutol a satcan jin an. ");
INSERT INTO knjNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yuxan jix wal e ex an, tol xol je penail oj jex cam oj. Ta c'am che yaoc yin je c'ul, tol jain ton mac jix wute waloni, yin je mul oj jex cam oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Mac jaach txequel xin? ẍi pax eb tet naj. Catu' jix yalon jaxca ti': —Albil xa wu an yet tax yalantoj e ex, mac jin txequel. ");
INSERT INTO knjNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Caw ey tzetal chi ske' walon je yin, catu' chi ske' jin na'on oc je yin, pero asan tzet yalnaj e in yu mac jix jin chejontej, asan chi wal tet eb ánima yul yiban k'inal ti'. Caw yel tzet chi yala, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero ma na'cha el yu eb, tol ja' yin cu Mam Dios chi yala. ");
INSERT INTO knjNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yuxan jix yal pax naj tet eb jaxca ti': —Ja' to yet oj jin je t'unban a oj, catu' oj na'cha el je yu, tol jain ton Ak'bil Wopiso xol eb ket animail yu Dios. Catu' oj je yotajnen el oj, tol man yul oj wet chi wunen wan ti'. Asan wan cuybanile yalnaj jin Mam e in an chi wal an. ");
INSERT INTO knjNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ja' jun chejnen jin tej tu', ja' ey oc wetoj an. Ja' jin Mam tu', c'am chin sbej can jin txojli, yutol asan tzet chi ẍa' sc'ul, asan chi c'al wun an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ja' yet jix yalon naj wan ti', ec'al eb jix yaoc sc'ul yin. ");
INSERT INTO knjNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Catu' jix yalon Jesús tu' tet eb Israel jix yaoc sc'ul yin naj tu' jaxca ti': —Ta ey c'al oc je na'bal tobal k'inal yin tzet chi wal an, ja' caw jin cuywom jex ton sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Catu' oj je yotajnen el sk'ane Dios tol caw yel. Yu jun yel tu', oj jex jajcha el oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Catu' jix yalon pax eb tet naj jaxca ti': —Jaonti', yic'aal jon pax naj Abraham ja wetoj. C'am junel oj jix cu oc moso oj junoj ánima. ¿Yuxan, tzet yuxan cha wala, tol oj cu jajcha el oj? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","—Caw yel chi wal e ex an, yal c'al mac tol ja'c'ala' yunen spenail, caw ey oc eb yin yak'omal oj servil spenail tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","K'inaloj ey junoj mac txequel ey oc yak'omal oj servil junoj ánima tinani'. Ja' jun moso tu', ma ske' ye ec' yetoj jun ánima tu' junelne. Pero ja' junoj sc'aal junoj ánima tu', caw sc'aal ton junelne. ");
INSERT INTO knjNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yuxan, ta jain chex jin jaj el yin je penail, caw yel oj jex ton jajcha el oj, yutol Sc'aal jin Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jainti', wotaj toni, tol yic'aal jex naj Abraham wetoj an. Pero ila, che yoche chin je yak' pax cam oj, yutol ja' tzet chi wal e ex, c'am yel oc apnoj yul je sat. ");
INSERT INTO knjNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ja' tzet ilbil wu bey jin Mam, ja' chi wal e ex. Jaexti', tx'oj je mam. Ja' yochwan je mam tu' che yune', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Pero jaonti', yic'aal jon naj Abraham, ẍi eb tet Jesús. —Ta yel yic'aal jex naj Abraham tu'. Tzet yuxan c'am che yun tzet jix yun naj. ");
INSERT INTO knjNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Asan wan tzet yetal yel albil yu Dios e in an, chi wal e ex. Pero che yoche chin je yak' pax cam oj. Ja' naj Abraham tu', c'am junel oj quey tu' jix yute sba. ");
INSERT INTO knjNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jaexti', ja' tzet chi yun je mam, ja' che yun yetoj, ẍi Jesús tet eb. —Pero jaonti', man comon winaj jon. Junne cu Mam, ja' ton Dios, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Man yel oj tol ja' Dios je mam. Ta yel ja' Dios je Mam, ey je cam c'ulal win an, yutol ja' bey Dios jix jin tit an, catu' jix jin jul titi'. Man tu' c'al oj jix jin jul yul wet an, ja' Dios jix jin chejontej. ");
INSERT INTO knjNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tzet yuxan c'am chi na'cha el je yu tzet chi wal e ex ti' an? C'am chi na'cha el je yu, yutol c'am chi yal je c'ul che cha' je yab tzet chi wal ti' an. ");
INSERT INTO knjNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ja' je mam jaexti', ja' ton naj diablo. Yuxan, asan yin naj che yaoc je na'bal. Asan tzet chi yoche naj diablo che yune'. Mak'om cam ánima xa naj diablo yet tax jix wa'xi yul yiban k'inal ti'. C'am nioj yel oc apnoj junoj tzet yetal yel yu naj, yutol c'am junoj tzet yetal yel chi yala. Ja' yet chi yak'on junoj lek'ti'al, ja' bey sna'bal chi tita, yutol caw lek'ti' naj. Ja' ey yet masanil lek'ti'al. ");
INSERT INTO knjNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Jal jin xin, caw yel wan tzet yetal chi wal e ex an, pero c'am che cha' pax je yabe. ");
INSERT INTO knjNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Mac junoj jex chi ske' je tx'oxon oc nioj jin penail? Caw yel wan chi wal e ex ti' an, yuxan, ¿tzet yuxan c'am che cha' pax je yabe? ");
INSERT INTO knjNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ja' eb yet Dios, chi yak' xiquin eb tet sk'ane. Pero jaexti', ma jex yetoj Dios. Yuxan, c'am chi yal je c'ul che yak' je txiquin tet, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Catu' jix yalon pax eb yaawil ye bey Judea tu' tet naj jaxca ti': —Ila xin, yel chi kala. Tejan tol a Samaria jaach. Tejan ey junoj pena espíritu ey oc ja win, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—C'amaj, c'am junoj pena espíritu ey oc win an. Tol lalan jin jijen tzet chi yal jin Mam. Tu' c'al chex buchwa win. ");
INSERT INTO knjNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Jainti', c'am chi woche tol miman xa c'al wel oc apnoj. Pero ey jun mac txequel chi aloni tol miman wel oc apnoj yul sat. Ja' jun tu' oj alon oj mac txequel chi alon yin yel c'al mac txequel chi alon yin man yel oj. ");
INSERT INTO knjNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Caw yel chi wal e ex, ja' mac chi jijen tzet chi wal an, c'am bak'in oj cam eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","—Ja' tinani', caw kotaj sic'lebil tol ey junoj pena espíritu ey oc ja win. Ja' naj Abraham, yetoj c'al eb ẍejab Dios yet peyxa, jix cam masanil eb. Catu' cha walon pax oj: “Ta ey mac chi jijen tzet chi wal an, man oj cam eb,” ja chi to wal pax oj. ");
INSERT INTO knjNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Tumi yel ec'ban ja wopiso yintaj kichmam Abraham tu', c'al yintaj eb ẍejab Dios yet peyxa? Pero ilabi, jix cam pax eb tu'. ¿Mac jaach txequel ja na'on tinani'? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yuxan jix yal Jesús tet eb jaxca ti': —Ta yul c'al wet chi wi'on can a jin ba, c'am nioj wel oc apnoj. Ja' ton jin Mam chi aloni tol ey wel oc apnoj. Ja' ton jin Mam tu' che yal oc je Diosal oj. ");
INSERT INTO knjNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero cax c'al che yal oc je Diosal oj, man je yotaj oj naj. Jal jainti', caw wotaj Dios tu'. K'inaloj ta chi wal an, tol man wotaj oj Dios. Lek'ti' jin jaxca jex tu'. Pero caw yel wotaj Dios. Ja' tzet chi yala, chin jije. ");
INSERT INTO knjNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ja' kichmam Abraham, jix tzala a oj, yutol albil tet naj, tol oj yil jin juli. Jix ton yila, yuxan jix yak' tzala sc'ul naj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","—¿Tumi ilbil yin Abraham ja wu? Pero toj ey jaach xa pax junoj cincuenta jabil, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Caw yel chi wal e ex an, ja' yet c'am to chi ali naj Abraham tu', ey jin xa ec' jainti' an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jix lawi tu' xin, jix c'oli sic'on a ch'en eb, catu' jix yochen eb jix k'ojch'enne cam oj. Jix yewban el sba naj tet eb. Catu' jix eltej yul stemplo Dios tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ja' yet junel, yet lalan sbey Jesús yetoj eb scuywom, jix yilon jun winaj eb c'am chi ske' yilwi yet c'al ta' jix ali. ");
INSERT INTO knjNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Catu' jix sk'anlen eb cuywom tu' jaxca ti': —Jaach cuywam, ¿tzet yuxan c'am chi ske' yilwi jun winaj ti' yin tax yalubal? ¿Jam eb mame txutxe ey smul, ma ja' naj ey smul? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—Ja' jun winaj ti', man yu oj smul smam xutx, yuxan quey tu' yei. Man pax yu oj smul naj yuxan quey tu' yei. Pero tol chi yoche Dios chi x'ox junoj milagro yin naj, yuxan quey tu' yei. ");
INSERT INTO knjNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sowalil chi cu wa'ne smulnail naj jix jin chejontej, yajban ey to c'u. Yutol ja' yet oj ey to c'u, c'am xa mac chi ske' smulnai. ");
INSERT INTO knjNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yet ey jin to ec' yul yiban k'inal ti', jaxca saj k'inal oj eb ánima we an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jix lawi yalon wan ti', catu' jix tz'ubli ey sat tx'otx' tu'. Catu' jix swa'nen nian sok'om yetoj s'ub tu'. Catu' jix yaon oc yin sbak'sat naj c'am chi ske' yilwi tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jix lawi jun tu', jix yalon Jesús tet naj: —Asi' bey jun ja' chi yij Siloé. Ja' titu' oj ja tx'a' el ja sat, ẍi Jesús tet naj. (Siloé chi yal yel oc apnoj, chejbil ja'.) Jix lawi c'al tu', jix to naj x'a'on el sat bey ja' tu'. Catu' ja' yet jix meltzoi, chi xa ske' yilwi. ");
INSERT INTO knjNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ja' eb ey scawil-laj naj tu', c'al jantaj eb otajneni tol c'am c'al ta' chi ske' yilwani, jix yalon eb jaxca ti': —Ja' jun winaj ti', chi cu na' tol ja' jun chi ey chotan k'ano sa'beal, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Ja' ton naj, ẍi wan xa. Pero ey wan xa chi alon pax oj: —C'amaj. Manaj. Tu' c'al mi laan yili jun ti' yetoj naj c'am chi ske' yilwi tu', ẍi eb. Catu' jix yalon naj tu'. —Jain toni, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—¿Tzet jix yun sjajcha ja sat tu' xin? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Ja' jun chi yij Jesús jix ak'on jajcha can jin sat ti' an. Jix swa'ne nian sok'om. Jix yaon oc yin sbak' jin sat ti' an. Catu' jix yalon e in jaxca ti': “Asi' bey jun ja' chi yij Siloé. Asi' tx'a' el ja sat titu',” ẍi e in an. Jix jin to jin tx'a'on el jin sat tu'. Quey tu' jix yun sjajcha can jin sat ti', ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Beytu' ey jun winaj tu' tinani'? ẍi eb tet naj. —Man wotaj oj, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jix lawi tu', catu' jix i'letoj naj yu eb sc'atan eb fariseo tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sc'ual xewilal yet jix jajcha can sat naj yu nioj sok'om jix swa'ne Jesús yetoj s'ub. ");
INSERT INTO knjNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yu jun tu', yuxan jix sk'anle eb fariseo tu' tet naj jaxca ti': —¿Tzet jix yun sjajcha a ja sat tu' xin? ẍi eb. —Ja' Jesús jix aon oc nian sok'om yin sbak' jin sat ti' an. Catu' jix ẍejon jin tx'a' el oj. Yuxan watx' xa wilwi tinani', ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Catu' jix yalon jaywan eb fariseo tu' tet naj jaxca ti': —Ja' jun winaj jix jajon ja sat tu', man yetoj Dios, yutol c'am chi sjije yet sc'ual xewilal, ẍi eb. Pero ey jaywan xa jix alon jaxca ti': —Ja' Jesús tu', man penawom oj. Ja' junoj penawom, ¿tumi ta chi ske' x'oxon wanoj milagro jaxca wan chi x'ox ti'? ẍi eb. Yuxan caab tujan jix el oc eb ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yu jun tu', yuxan jix sk'anle eb junel xa tet naj chi xa ilwi tu' jaxca ti': —Jal jaach, jaachti', ¿tzet ja chi yu naj jix jajon ja sat tu'? ẍi eb tet naj. —Jainti', ẍejab Dios yei, jin na'oni, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero eb yaawil ye bey Judea tu', ma ẍa' eb yabe, ta tol, tol to jix ilwi a naj. Ja' sna'on eb, tol chi ilwi c'al ta' a. Yuxan jix awtele smam c'al xutx naj yu eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ja' tet eb jix sk'anle el eb jaxca ti': —¿Ja' naj ti', yel mi je yuninal, catu' yel mi tol c'am chi ilwi yin tax yalubal? Ta yel wan ti', ¿Tzet yuxan chi xa ilwi pax naj xin? ẍi eb tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Ja' ton naj, c'am c'al ta' chi ilwi yin tax yalubal. ");
INSERT INTO knjNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero man kotaj oj tzet jix yun sjajcha can sat. Man pax kotaj oj mac jix jajon can tet naj. Ilabi, ey xa ya'bilal naj. ¿Tzet yuxan manaj tet naj che k'anle je yabe? Oj ske' yalon e ex, tzet utbil jix yun sjajcha can sat tu', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jaxca tu' jix yute yalon eb, yutol caw chi xiw eb yu eb yaaw xol eb a Judea tu'. Yutol tuxa jix yal eb yaaw tu' jaxca ti': “Ta tol ey eb oj alon oj, tol ja' Jesús, ja' ton naj Cristo, ẍi, oj kujte eltoj eb yul snail culto ti',” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yu jun tu', yuxan asan c'al nian ti' jix yal smam c'al xutx naj tu': “Ilabi ey xa ya'bilal naj, ¿tzet yuxan manaj tet naj che k'anle je yabe?” ẍi c'al eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jix lawi tu' xin, jix awtele pax naj chi xa ilwi tu' yu eb junel xa, catu' jix yalon eb tet jaxca ti': —Caw yel cha wal sattaj Dios, yutol kotaj, caw penawom jun winaj tu', jun cha wal tol jix jajon ja sat tu', ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jix tak'wi naj jaxca ti': —Jainti', man wotaj oj ta penawom naj, ma c'amaj. C'am chi ske' waloni. Asan jun ti' wotaj an, tol ja' yet yalantoj, c'am chi ske' wilwi nioj, jal tinani', chi xa ske' wilwi, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—Pero, ¿tzet wal jix jaach yute xin? ¿Tzet jix yute sjajon ja sat ti'? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Jix wal e ex tzet jix yun sjajcha jin sat ti' an, pero c'am che cha' je yab tzet chi wal an. ¿Tzet yuxan che yoche chi wal pax e ex junel xa? ¿Tumi che yoche chex oc scuywom oj pax oj? ẍi naj tet eb yaawil ye bey Judea tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ja' yet jix yaben eb wan ti', catu' jix buchwa a eb yin naj, jix yalon eb jaxca ti': —Jaachti', scuywom jaach ton jun winaj tu'. Jal jon jaonti' xin, scuywom jon naj Moisés. ");
INSERT INTO knjNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kotaj, tol jix k'anab can Dios tet Moisés tu', pero ja' Jesús tu', man kotaj oj mac jix ak'on yopiso naj, ẍi eb yaawil ye bey Judea tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—¿E… tz'i xam wal bian? Jaexti', che yala, tol man je yotaj oj mac ak'bil yopiso. Pero ilabi, jix jajcha pax can jin sat ti' yu naj. ");
INSERT INTO knjNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kotaj, tol caw c'am chi able xa eb pena sbeybal yu Dios. Asan eb chi yi' ey sba tet, eb chi jijen tzet chi yala, asan eb tu' chi able xa yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","C'am to junoj chi kab sk'umal tol chi sjaj sat junoj mac c'am chi ske' yilwi yin tax yalubal. ");
INSERT INTO knjNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","K'inaloj ta man ẍejab oj Dios Jesús tu', c'am mi nioj tzet chi ske' yu, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","—Jaachti', yin spenail alinaj jaach, ¿tumi cha woche jaach oj jon ja cuyu? ẍi eb tet naj. Catu' jix ujtele eltej naj yul snail culto tu' yu eb, ma xa cha'le octoj naj xol eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jix yaben Jesucristo tol jix ujtele eltej naj jix jajcha can sat tu' bey yul snail culto tu' yu eb, yuxan ja' yet jix yil-len sba yetoj naj junel xa, jix yalon tet naj jaxca ti': —¿Chim ja waoc ja c'ul yin naj Sc'aal Dios? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Mamin, al e in an, mac txequel jun Sc'aal Dios tu', yet watx' chi waoc jin c'ul yin, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Ja wotaj xa mac txequel. Jain ton mac lalan jin k'anab ja wetoj ti', ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jix lawi yalon Jesús jaxca tu' xin, catu' jix ey kaan naj sattaj Jesús tu', catu' jix yalon naj tet Jesús jaxca ti': —Mamin, chi waoc jin c'ul ja win, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Catu' jix yalon Jesús tet naj tu': —Yu swa'xi el eb ánima wu an, yuxan jix jin jul bey yul yiban k'inal ti', yutol ey eb c'am chi ske' yilon set yetal yet Dios tinani'. Pero jaxca tol oj jajcha sat eb tu' wu an. Ey wan xa eb xin, caw chi ske' yilon set yetal yet Dios sna'oni, pero ja' eb tu', jaxca tol oj etex el sat eb wu an, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ja' yet jix yaben jaywan eb fariseo ey ec' titu' wan tu', jix yalon eb tet Jesús jaxca ti': —¿Tumi cha na', tol c'am chi ske' kilon yet Dios? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Ta chi na'cha el je yu tol c'am chi ske' je yilon yet Dios, c'am chi can je penail je yiban. Pero yutol che yala, tol chi ske' je yilon yet Dios tu', yuxan oj can je penail je yiban. ");
INSERT INTO knjNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","K'inaloj ey junoj colal no' me' bey chi octoj junoj winaj tinani'. Ta manaj bey sti' jun colal tu' chi octoj, pero tx'oj pax bey chi octoj, caw yel chi wal e ex, elk'om ton jun chi unen jaxca tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ja' pax mac ja' yul sti' colal chi octoj xin, ja' ton naj yilomal no' tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ja' naj weynem colal, ja' naj chi jajon sti' colal tet naj ilom me' tu'. Yotaj yilomal no' me' tu'. Yotaj sbi jun jun sme' naj ilom me' tu'. Ja' naj chi i'on eltej no'. ");
INSERT INTO knjNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Chi lawi yi'on eltej no' sme' naj, catu' chi babi naj sattaj no'. Chi oc tzajan no' yintaj naj, yutol k'eynaj xa no' yetoj naj. ");
INSERT INTO knjNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero k'inaloj ey junoj xa winaj man k'eynaj oj no' yetoj, man comon oj chi oc tzajan no' yintaj. Ta man k'eynaj oj no' yetoj, chi el no' tet, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jix yaltej jun k'aneal ti' Jesús tet eb, pero ma na'cha el yu eb tzet chi yal yel oc apnoj. ");
INSERT INTO knjNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Catu' jix yalon Jesús tet eb jaxca ti': —Caw yel chi wal e ex an, jaxca sti' colal bey chi octoj no' me', quey jin tu' an. ");
INSERT INTO knjNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ey eb babel julnaj jin sattaj, jix tz'aj yalon oc sba eb colwawomal. Jaxca junoj elk'om chi oc yul colal quey tu' masanil eb. Pero eb yet xa Dios, ma yaoc sc'ul eb yin eb. ");
INSERT INTO knjNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jainti', laan jin jaxca junoj sti' colal tu' an. Ja' eb chi octoj yul jun sti' colal tu', oj colcha eb. Jaxca junoj me' chi octoj, chi eltej yul scolal seyon low sba, quey tu' oj yun eb. ");
INSERT INTO knjNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ey eb jaxca junoj elk'om chi juli, chi yelk'anentoj catu' chi yak'on cam oj. Jal jin jainti', jix jin jul yu wak'on sk'inal eb tol ey c'al yin tobal k'inal, yet watx' caw miman swatx' c'ulal Dios oj ẍa' eb. ");
INSERT INTO knjNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jainti', laan jin jaxca junoj ilom me' caw watx', bejan sc'ul scam sq'uexel oj no', quey jin pax tu', jainti', bejan jin c'ul jin cam sq'uexel oj eb wet. ");
INSERT INTO knjNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ey bey tu' c'al chi maanele junoj mac txequel chi ilon no' me', pero man ja' caw ilom me' oj. Ja' yet chi yilon sjul no' oj, eyman chi sbej can bulan no' me' tu' xojli, catu' chi eli, yutol man yet oj no'. Chi lawi tu', catu' chi mi'cha can oc no' me' tu' yu no' oj tu', catu' chi yuchon can sajlem oj. ");
INSERT INTO knjNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ja' naj ilom me' tu', chi el naj, yutol asan yu stool sc'u naj yuxan chi ilwi me', man yu oj tol ey yel oc apnoj no' yul sat naj. ");
INSERT INTO knjNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Jainti', laan jin jaxca junoj ilom me' caw watx'. Ja' eb wet an, jaxca tol jin me' eb an. Otajbil jin yu jin Mam. Ja'c'ala' jin, wotaj jin Mam tu'. Jaxca wotajnen jin ba yetoj jin Mam tu', quey tu' wotajnen jin ba yetoj eb wet xa yei. Oj wak' cam jin ba sq'uexel oj eb wet tu' an. ");
INSERT INTO knjNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ey wan xa eb tol to oj yaoc sc'ul win an, asan tol man ket conob oj eb. Sowalil oj jin yamba oc eb. Oj sjijen eb e in an. Junxane bulan oj yun eb wet tu' masanil, yutol junne mac oj ilon eb. ");
INSERT INTO knjNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Chi cam el sc'ul jin Mam win an, yutol oj wak' jin ba cam oj, catu' oj jin pitzc'u pax a junel xa. ");
INSERT INTO knjNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Jainti', chi el yin jin c'ul wak'on cam jin ba. C'am mac chi ske' jin yak'on cam oj ta c'am chi yal jin c'ul. Ey wopiso wak'on cam jin ba. Ey pax wopiso wiquisbi a junel xa. Yutol quey tu' jix yute yak'on can jun chejbanil ti' jin Mam e in an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ja' yet jix yalon wan ti', jix steelen can a sba eb yaawil ye bey Judea tu' yu. Caab tujan jix yute can to sba eb junel xa. ");
INSERT INTO knjNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ey eb jix alon jaxca ti': —¿Tzet yuxan che yab tzet chi yal jun winaj ti'? Ila, tol ey oc pena espíritu yin naj. Cha'bil joybinaj sat yu, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero ey pax wan xa eb chi alon jaxca ti': —Ta ja' pena espíritu ey oc yin, ¿tumi ta chi ske' yalon jaxca ti': Tumi chi ske' sjajle sat junoj mac c'am chi ske' yilwi yu pena espíritu? ẍi wan xa eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ja' yet stiempoal xa nabil k'inal, jix cha'le sk'inal stemplo Dios bey Jerusalén. ");
INSERT INTO knjNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Lalan yec'ab Jesús bey templo tu', bey jun yamak'il chi yij yet Salomón. ");
INSERT INTO knjNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Catu' jix oc joyan eb yaawil ye bey Judea ey ec' titu' yin naj Jesús. Jix yalon eb jaxca ti': —¿Bak'in c'al oj ja bej can jun caab c'ulal tu'? Ta Cristo jaach, al e on tinani', ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Catu' jix tak'wi Jesús tet eb jaxca ti': —Xax wal e ex an, pero c'am che yaoc yin je c'ul. Ja' wan milagro chin tx'oxo, asan yu yopiso jin Mam yuxan chi ske' wu jin tx'oxoni. Catu' ja' ton wan tu' chi tx'oxon el oj mac jin txequel. ");
INSERT INTO knjNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero jaexti', caw c'am che yaoc yin je c'ul, yutol man wetoj je yei, jaxca ta' jix wal e ex junel an. ");
INSERT INTO knjNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ja' eb wet an, chi yaoc xiquin eb yin tzet chi wal an. Catu' wotaj eb an. Jaxca no' me' chi oc tzajan yintaj yilomal, quey tu' chi yun tzajlo eb wintaj an. ");
INSERT INTO knjNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jain, chi wak' sk'inal eb tol ey c'al yin tobal k'inal. Yuxan, c'am bak'in oj q'uey el eb. C'am junoj mac txequel chi ske' yi'on ec' eb yul jin k'ab. ");
INSERT INTO knjNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ja' jin Mam, ec'ban yel oc apnoj yintaj masanil, ja' jix ak'on e in an. C'am junoj mac txequel chi ske' yi'on ec' eb yul sk'ab jin Mam tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jainti', laan jin yetoj cu Mam Dios, yutol junne animail we yetoj, ẍi Jesús tet eb yaawil ye bey Judea tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yu jix yal jun tu', yuxan jix sic' a ch'en eb, catu' chi yoche eb jix k'ojch'ennen cam naj. ");
INSERT INTO knjNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero jix yal Jesús tet eb jaxca ti': —Caw ey tzet yetal watx' jix el wunen yu yipal jin Mam je nan je xol. ¿Beytet junoj wan tu', yuxan che yoche chin je k'ojch'enne cam an? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Man yu oj junoj watx' jix el ja wunen tu', yuxan chi koche chach cu k'oj cam on, pero asan yu cha buch Dios. Jaachti', comon ánima jaach, pero ila cha wal pax oc ja ba Diosal, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yuxan jix yal Jesús tet eb jaxca ti': —Ja' yul an ley ey ec' e on, quey tu' tz'ibebil can ey jaxca ti': “Jain chi wal an, tol dios jex jun jun jex,” ẍi can Dios yul An Juun. ");
INSERT INTO knjNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kotaj, ja' tzet tz'ibebil can yul An Juun tu', ma ske' tu' c'al oj cu tena. Ja' Dios jix alon can tet eb cha'nen can jun k'ane tu', tol dios eb. ");
INSERT INTO knjNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Jainti', Dios jix jin sic'on el oj, ja' jix jin chejontej yul yiban k'inal ti'. Yu jun tu' yuxan, ¿tzet yuxan che yala, tol chin buchwa yin Dios, yet chi waloni tol Sc'aal jin Dios? ");
INSERT INTO knjNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ta manaj tzet chi yun jin Mam tu' chi wun an, manchej je yaoc je c'ul win an. ");
INSERT INTO knjNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero jainti', lalan wunen tzet chi yun jin Mam tu'. Yuxan, cax c'al mi c'am che yaoc je c'ul yin tzet chi wal an, pero a wej oc je c'ul win yu wan tzet yetal chi wun tu'. Catu' oj na'cha el je yu, catu' oj je yaon oc yin je c'ul tol ey oc cu Mam Dios win, catu' ey jin pax oc yin, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yu jun tu' yuxan jix to yak'le eb smitx'on naj junel xa, pero jix scol sba naj yul sk'ab eb. ");
INSERT INTO knjNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jix lawi tu' xin, jix k'axpon ec'toj naj yul ja' miman Jordán. Catu' jix ec' naj bey yak'naj bautizar eb ánima naj Juan. ");
INSERT INTO knjNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ec'al eb ánima jix apni ilon naj. Catu' jix yalon eb jaxca ti': —Ja' naj Juan, c'am bey jix x'ox junoj milagro, pero masanil tzet jix yal yu Jesús ti', yel c'al ton masanil, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ec'al mac txequel jix yaoc sc'ul yin Jesús bey jun lugar tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ja' bey jun aldea chi yij Betania, ey jun winaj chi yij Lázaro. Ya' ey naj. Ey cawan yanab naj Lázaro tu', ey jun chi yij María, ey jun xa chi yij Marta. A Betania c'al eb yoxwanil. ");
INSERT INTO knjNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ja' ix María tu', ja' ton jun jix aon oc jun ambal suk'uk'i sab yin Jesús Kaawil, catu' jix sjo'on taj yajan Jesús ix yetoj xil ya'. Caw ya' ey naj Lázaro tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yuxan jix yatoj sti' eb ix anabe tu' tet Jesús. Jix yal eb ix jaxca ti': —Mamin, ja' naj cam c'ulnebil ja wu, caw ya' ey naj tinani', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ja' yet jix yaben Jesús tzet jix yaltoj eb ix, catu' jix yalon naj jaxca ti': —Ja' jun ya'bil tu', man oj cam naj yu yin junelne. Jix mi'cha naj yu jun ya'bil tu', yet watx' chi x'ox el sba Dios tol miman yel oc apnoj naj, c'al yu x'oxon pax el oj, tol miman wel oc apnoj jain C'aale jin ti' an, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Caw ey scam c'ulal Jesús yin naj Lázaro tu', c'al yin ix María yetoj ix Marta. ");
INSERT INTO knjNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero ja' yet jix yaben tol caw ya' ey naj, ma toj naj yin eymanil yiloni. Scaabial xa tu', catu' jix toi. ");
INSERT INTO knjNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ja' yet jix apni sc'ual sto tu', jix yalon tet eb scuywom jaxca ti': —Toon nej bey lugar yul yet Judea junel xa, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Catu' jix yalon eb tet naj: —Pero Wuẍtaj, jayeb jix to c'u yak'len eb yaawil ye bey Judea tu' jaach sk'ojch'ennen titu'. ¿Tumi cha woche chach to pax junel xa titu' tinani'? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jix yalon naj tet eb: —Kotaj, ey lacaweb hora yul jun jun c'u. Ta c'ualil chi cu ec'abi, man comon oj chi cu telc'oi, yutol saj k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero eb chi ec'ab yet ak'balil xin, comon c'al chi telc'o eb, yutol c'am saj k'inal eb, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jix lawi tu', jix yalon pax tej yu naj Lázaro: —Ja' naj kamigo tu', tol chi wey naj, pero oj jin toj jin ten el sweyan naj, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Pero Wuẍtaj, ta tol chi weyi, tejan oj wa'xoj sc'ul, ch'al tu', ẍi eb scuywom tu' tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ja' yet jix yalon Jesús tol chi wey naj Lázaro tu', ja' scamichal chi yala. Pero ja' sna'on eb xin, ja' caw weyan chi yune'. ");
INSERT INTO knjNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yu jun tu', yuxan jix yalon naj junel xa tet eb jaxca ti': —Jix cam naj Lázaro. ");
INSERT INTO knjNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tinani' caw chin tzala an, yutol c'am jin ey jin ec' titu' yet jix cami, yet watx' che yaoc je c'ul win. Tinani' toon nej kila, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ja' naj Tomás, naj chi yij pax Tioẍ, jix yal naj tet eb yet cuywomal tu' jaxca ti': —Toon nej pax oj, to kak' cu ba cam yetoj, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ja' yet jix apni eb xin, jix yaben eb, tol oxi tax jix muji naj Lázaro tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ja' scawilal Jerusalén, ey conob Betania tu', jaxca snan oj legua xol. ");
INSERT INTO knjNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yu jun tu', yuxan ec'al eb a Jerusalén jix bet miman c'ulnen ix María yetoj ix Marta, yu jun sno eb jix cam tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ja' yet jix yaben ix Marta tol lalan yapni Jesús bey sna eb, jix to ix ẍa'oni. Jal ix María xin, jix can can ix yul sna. ");
INSERT INTO knjNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jix yalon ix Marta tet Jesús tu' jaxca ti': —Mamin, ta ey jaach ec' titi', ma mi cam naj jin no tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero ja' tinani', wotaj an, yal c'al tzet oj ja k'an tet Dios, oj yak' e ach, ẍi ix tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Ja' naj ja no tu', oj pitzc'u a naj, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Yel toni, wotaj an. Ja' yet slawub c'ual, yet oj pitzc'u a eb camnaj, catu' oj pitzc'u a naj yetoj eb, ẍi ix tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Catu' jix yalon Jesús tet ix jaxca ti': —Jainti', ak'om jin pitzc'u a camnaj, a k'inale jin pax oj. Yal c'al mac txequel chin yaoc yin sc'ul, cax c'al mi oj cam oj, pero oj pitzc'u pax a oj. ");
INSERT INTO knjNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Masanil eb iquis to chin aon oc yin sc'ul, c'am bak'in oj cam eb, ¿Chim ja waoc jun ti' yin ja c'ul? ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Chi ton waoc yin jin c'ul, Mamin, tol jaachti' Cristo jaach, Sc'aal jaach Dios. Jaach ton ti' echbanebil ja wul yul yiban k'inal ti' ẍi ix tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jix lawi yalon ix Marta jaxca tu', jix pax toj ix. Jix to yawtentej sno ix. Yin ewantajil jix yun yalon ix tet sno tu' jaxca ti': —Jix jul naj Cuywam, chach yawte naj, ẍi ix. ");
INSERT INTO knjNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jix yab c'al ix María jaxca tu', catu' eyman jix a waan oj, catu' jix to ix bey ey ec' Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tutun c'am to chi oc Jesús tu' yul conob tu'. Ja' bey jix bet cha'le yu Marta, ja' tu' ey to ec' oj. ");
INSERT INTO knjNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pero ey ec' eb a Judea bey sna yetoj ix. Jix apni smiman c'ulnele ix yu eb. Ja' yet jix yilon eb, tol eyman jix a waan ix, catu' jix toi, eyman jix tzajlo eb yintaj ix, yutol ja' sna'on eb, tol ja' bey mujan naj sno tu' chi to ok' oj. ");
INSERT INTO knjNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ja' yet jix apni ix bey ey ec' Jesús tu', jix ey kaan ix sattaj naj. Catu' jix yalon ix tet naj jaxca ti': —Mamin, ta ey jaach ec' titi' ma mi cam naj jin no ti', ẍi ix tet. ");
INSERT INTO knjNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ja' yet jix yilon Jesús tol chi ok' ix, catu' chi ok' pax eb a Judea jix tzajlo yintaj ix tu', catu' jix cus pax a naj yetoj eb sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Catu' jix sk'anlen tet eb jaxca ti': —¿Beytu' jix je muj naj? ẍi naj tet eb. —Mamin, toon kila, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ja' yet tu' jix ok' naj Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Catu' jix yalon eb a Judea ey ec' yilon tu', jaxca ti': —Ilala, caw cam c'ulnebil naj yu naj, ẍi c'al eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ey pax eb jix alon jaxca ti': —Pero ja' Jesús ti', ja' jix jajon sat jun naj c'am chi ske' yilwi. ¿Tumi ma ske' yak'on jul sc'ul naj Lázaro ti', yet watx' c'am chi cami? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Caw jix tit pitz'na scus c'ulal Jesús yet jix apni bey mujan naj. Ja' yul jun ch'en jolbil, ja' titu' ey octoj smimanil naj. Patxan can oc jun xa ch'en smajil oj. ");
INSERT INTO knjNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—I' wej el ch'en smajil ti', ẍi Jesús. Jix yalon ix Marta, ix yanab naj Lázaro tu' jaxca ti': —Pero Mamin, oxi tax jix cam naj. Tejan ey xa sab naj tinani', ẍi ix tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—Jix wal e ach, ta tol chin ja waoc yin ja c'ul, oj ton ja wil yipal Dios, ẍi naj tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Catu' jix yi'on el smajil eb bey ey octoj naj tu'. Jix a t'anan Jesús satcan, jix yalon naj jaxca ti': —Mamin, yu wal dios e ach, jix ja wab tzet jix wal an. ");
INSERT INTO knjNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wotaj xa tol tobal k'inal cha wab c'al ta' tzet chi wal an. Pero ja' yu jantaj ánima bulan ec' titi', yuxan chi wal wan ti' e ach, yet watx' oj yaoc eb yin sc'ul tol jaach jix jin ja chejtej, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jix lawi yalon naj wan tu', catu' jix a yaw yin ipal jaxca ti': —Lázaro, elantej, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Catu' jix eltej naj camnaj tu'. Chulan oc wan k'ap yin yajan c'al yin sk'ab naj. Ey pax jun an xotan oc yalan sti'. Jix yal Jesús jaxca ti': —Xuy wej el wan k'ap ey oc yin naj tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Catu' ec'al eb a Judea ey ec' yetoj ix María tu', jix yil eb tzet c'al jix yun Jesús tu'. Yu jun tu', yuxan ec'al eb jix yaoc sc'ul yin. ");
INSERT INTO knjNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero ey wan xa eb jix bet alon yab eb fariseo, tzettaj jix yun Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Catu' jix slatinen el sba eb fariseo tu' yetoj eb yaawil yak'omal xaambal eb tet Dios, c'al eb mimej winaj chi ak'on cuenta conob. Catu' jix yalon eb jaxca ti': —¿Tzet chi kute jun winaj ti' che na'? Yutol caw ey wan milagro lalan x'oxon tinani'. ");
INSERT INTO knjNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ta tu' c'al oj kil oc naj tinani', masanil eb ket conob oj yaoc sc'ul eb yin. Ja' eb yaaw bey Roma, oj jul yuche jun stemplo Dios eb ti', catu' oj yak'on jowal eb yin eb ket conob masanil. Caw oj cu can yalan yu eb naj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero ey jun naj chi yij Caifás xol eb. Ja' jun tu' ey oc yaawil yak'omal xaambal eb tet Dios yet jun jabil tu'. Ja' jix alon tet eb jaxca ti': —Jaexti', caw c'am nioj tzet je yotaj. ");
INSERT INTO knjNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","C'am chi na'cha el je yu, tol yel watx' chi cu cani ta chi cam junoj winaj sq'uexel oj ánima masanil. Ta quey tu' chi yune', c'am chi lawi el eb ket conob masanil, ẍi naj Caifás tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pero ja' yet jix yalon wan k'ane tu', man yul oj yet jix yaloni, pero yutol yaawil yak'omal xaambal eb Israel tet Dios ye yet jun jabil tu', yu jun tu', yuxan jix ak'le yal yu Dios tol oj cam Jesús sq'uexel oj eb Israel masanil. ");
INSERT INTO knjNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Man asanne oj yu eb Israel tu', yuxan jix cami. Jix cam yu syamban oc jantaj eb yuninal Dios sajleminaj ye yul yiban k'inal ti', yet watx' junxane chi yun can eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yu jun tu', yuxan ja' yet jun c'ual tu', jix ẍa' el yich eb yaaw tu' seyon tzet utbil oj yute yak'on cam Jesús eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yu jun tu', yuxan c'am xa chi ec' Jesús snan xol eb a Judea tu'. Jix el bey jun lugar tu'. Catu' jix to bey jun conob chi yij Efraín sti'laj el jun cusiltaj tx'otx'. Ja' ta' titu' jix apni naj yetoj scuywom. ");
INSERT INTO knjNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ja' yet lalan xa sjul stiempoal jun sk'in eb Israel chi yij pascua, ec'al eb naat speto, catu' chi apni eb bey Jerusalén. C'am to chi oc k'in tu', catu' chi apni eb, yet watx' chi swa'ne sba eb jaxca ta' sbeybal. ");
INSERT INTO knjNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ja' yet ey ec' eb titu', caw jix seyle ec' Jesús yu eb, catu' ey eb jix alon yul stemplo Dios jaxca ti': —¿Tzet ẍi je c'ul? ¿Oj mi jul Jesús bey k'in ti', ma man oj jul che na'? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ja' yet tu' jix yi' eltej jun ley eb fariseo yetoj eb yaawil eb yak'omal xaambal eb Israel tet Dios tu'. Chi yal jun ley tu' jaxca ti': “Ta ey bey che yil yin Jesús, chi jul je yal titi',” ẍi. Quey tu' jix yun sajlem k'ane yu eb, yutol chi yoche eb chi yaoc naj preso. ");
INSERT INTO knjNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jobix oj toj yoc jun k'in pascua bey Jerusalén, jix apni Jesús bey Betania bey caan naj Lázaro, naj jix pitzc'u a yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ja' yet jix apni Jesús tu', jix oc jun miman lo' yu eb yu naj. Ja' jun Lázaro tu', jix low yetoj eb. Ja' ix Marta chi i'wi eltoj lo'be. ");
INSERT INTO knjNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jal ix María xin, i'bil oc snan litro ambal suk'uk'i sab yu ix, chi yij nardo. Ja' jun ambal tu' caw ey stool. Jix apni c'al ix bey Jesús, catu' jix sec'on oc ix yin yajan naj. Jix lawi c'al tu', jix sjo'ontaj ix yetoj xil. Jun txolan jix no el yul jun na tu' yu sab. ");
INSERT INTO knjNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ja' jun scuywom Jesús chi yij Judas, sc'aal Simón Iscariote, naj t'inan yaon oc Jesús yul sk'ab camich. Ja' jix alon jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Ja' jun ambal suk'uk'i sab ti', ey mi junoj oxeb cien quetzal stool. Tol oj wal jix cu txon el oj, catu' chi kak'on stool tet eb meba', ẍi naj, chi tz'aj yaloni. ");
INSERT INTO knjNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero tu' c'al chi tz'aj yala. Man yel oj tol chi ok' sc'ul naj yin eb meba'. Yutol c'ubam tumin yei, yu jun tu', yuxan ja' jix ochen jix tz'aj c'uba stool tu', catu' chi yi'on can el nioj yet yin ch'en, yutol elk'om naj. ");
INSERT INTO knjNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jix yalon Jesús tet naj jaxca ti': —Bej ja tzuon ix. Yutol ja' jun yambal ix suk'uk'i sab ti', jix sc'uba ec' ix, yu jin bonle yet sc'ual jin mujbanil. ");
INSERT INTO knjNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ja' eb meba' tu', ey c'al ec' eb je yetoj. Jal jin xin, man tobal k'inal oj ey jin ec' je yetoj, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ec'al eb Israel jix abeni, tol ey ec' Jesús bey Betania, yuxan jix to eb yila. Man asanne oj Jesús chi yoche chi yil eb. Pero chi yoche pax chi yil yin naj Lázaro eb, yutol jix pitzc'u a naj xol eb camnaj yu Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Yu spitzc'ubail naj Lázaro tu', yuxan ec'al eb Israel jix yaoc sc'ul yin Jesucristo. C'am xa chi yaoc sc'ul eb yin eb yak'omal xaambal eb Israel tet Dios. Yu jun tu', yuxan jix slatine el sba eb yaawil yak'omal xaambal eb tu', catu' chi yochen eb chi smak' cam naj Lázaro tu' pax oj. ");
INSERT INTO knjNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ec'al ánima jix apni bey Jerusalén yu sk'in pascua. Ja' yet jun c'ual tu', jix yaben eb tol lalan yapni Jesús titu'. ");
INSERT INTO knjNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yu jun tu', ec'al eb jix i'on el xaj te' ch'ib. Jix yi'ontoj eb, catu' jix to eb ẍa'on Jesús. Jix a yaw eb yin ipal, jix yalon eb jaxca ti': —Yu wal dios. Kal wej watx' k'ane tet jun chejbiltej yu Dios ti'. Kal wej watx' k'ane tet naj cu reyal jaon Israel jon ti', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jix ilcha jun no' burro yu Jesús tu'. Catu' jix a yiban no' jaxca tz'ibebil can yul An Juun bey chi yal jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jex a Sión, manchej jex xiwi. Il wej sjul je Reyal. Ey a yiban jun no' yune' burro, ẍi An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ja' yet jun c'u tu', ma na'cha el wan ti' yu eb scuywom Jesús. Ja' to yet jix i'le pax a Jesús tu' satcan, catu' jix sna'ontej eb, tol sk'aneal Jesús tz'ibebil can yul An Juun tu', jaxca c'al ye can tz'ibele can tu', quey tu' jix yun yel oc oj. ");
INSERT INTO knjNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ja' eb ey ec' yetoj Jesús, yet jix yawten eltej Lázaro bey mujan octoj, yet jix pitzc'u a oj, jix yal el tzet jix yil eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yu jun tu', yuxan jix to eb ánima tu', sto ẍa'on Jesús, yutol jix yab sk'aneal jun milagro jix yun naj. ");
INSERT INTO knjNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jix yalon eb fariseo jaxca ti': —Ja' tinani' c'am xa tzet watx' chi kune. Ilala, masanil ánima chi oc yetoj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ey wan eb griego jix apni bey Jerusalén bey k'in tu', yu yi'on ey sba eb tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ja' eb tu', jix apni eb sc'atan naj Felipe a Betsaida yul yet Galilea. Catu' jix yalon eb tet naj jaxca ti': —Cha wamigo, chi koche chi kil yin Jesús, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jix to naj Felipe yalon tet naj Andrés, catu' jix to eb scawanil yalon tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Catu' jix yalon Jesús tu' tet eb jaxca ti': —Jainti', Ak'bil Wopiso xol eb ket animail yu Dios, ja' tinani', lalan sjul yorail xeclo el oj, tol yel miman wel oc apnoj. ");
INSERT INTO knjNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Caw yel chi wal e ex, k'inaloj ey junoj ixim sbak' trigo chi can yiban tx'otx'. Tu' c'al chi can jaxca tu'. Ta chi mujlei, jaxca tol chi cami, pero chi a pax jul oj, miman xa sbak' chi yak'a. ");
INSERT INTO knjNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ja' mac asanne sk'inal ey yel oc apnoj yul sat, oj lawoj can el sk'inal tu'. Jal pax mac c'am yel oc apnoj sk'inal yul sat yul yiban k'inal ti' xin, ja' ton eb tu' oj ẍa' sk'inal tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ta ey mac chi ochen chin ak'on servil, tzajlo ojab wintaj an, yet watx' ja' bey ey jin ec' oj, ja' tu' oj ey pax ec' oj. Ta ey mac chin ak'on servil, ja' jin Mam oj pajtzen tet eb, miman oj yun yel oc eb, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ja' tinani', caw chi oc pitz'an cus c'ulal yin jin pixan. Pero, ¿tzet oj wute walon an? ¿Tumi oj wal tet Dios jaxca ti', “Mamin, col jin el yul sk'ab jun sya'ilal oj jul wiban ti' an,” tumi ta jin chi? Yutol yu ton jun ti', yuxan chin jul an. ");
INSERT INTO knjNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mamin, txeclo ojab el oj, tzet utbil tol miman ja wel oc apnoj, ẍi Jesús. Jix lawi tu' xin, jix yaben yoc jun k'ane eb bey satcan, jix yal jaxca ti'; Jix jin tx'oxlei, tol miman wel oc apnoj. Ja' tinani' xin, oj jin tx'ox junel xa, ẍi jun k'ane tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ja' eb ánima ey ec' titu', jix yab jun tu' eb, yuxan ey eb jix alon jaxca ti': —Tejan c'u jun jix bilwi tu', ẍi eb. Ey eb xin: —Tejan ángel junoj jix k'anab eytej tet Jesús ti', ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yu jun tu', yuxan jix yal Jesús tet eb jaxca ti': —Man wu oj, yuxan jix al-le eytej wan ti', pero tol je yu. ");
INSERT INTO knjNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ja' tinani', ja' eb ey yul yiban k'inal ti', oj na'le oc yin eb. Catu' oj jin k'ojon el jun chi ak'wi mandar yul yiban k'inal ti' yin yopiso. ");
INSERT INTO knjNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jal jainti' xin, ja' yet oj jin i'le a oj, oj wawtetej masanil ánima e in an, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jix yal naj jaxca tu', yu tzet utbil oj yun scami. ");
INSERT INTO knjNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Catu' jix yalon eb ánima tet naj jaxca ti': —Ja' yul an ley ey ec' e on, ja' tu' jix kab tzet utbil tol ja' jun Cristo, ey c'al ec' yin tobal k'inal. Yu jun tu', ¿tzet yuxan cha wala, tol ja' jun Ak'bil Yopiso yu Dios xol eb ket animail, sowalil oj i'le a oj? ¿Mac txequel jun Ak'bil Yopiso yu Dios cha wal tu'? ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Catu' jix yalon tet eb jaxca ti': —Jain chi wak' saj k'inal bey je pixan, jain ey jin ec' je nan je xol tinani', pero nianxane tiempo ey jin ec' oj. Caw che wa'ne je beybal, yajban tol ey jin to ec' jayeb oj xa c'ual je yetoj. Ta c'amaj, oj somcha el je c'ul. Jaxca junoj mac txequel chi bey xol k'ej k'inal, c'am chi ske' yilon bey chi toi, quey tu' oj yun je yel oc apnoj. ");
INSERT INTO knjNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jainti', laan jin jaxca saj k'inal an. Yu jun tu', yuxan a wej oc je c'ul win an, yajban tol ey jin to ec' je yetoj, catu' chi wak'on saj k'inal bey je pixan yin junelne, ẍi Jesús tet eb. Jix lawi c'al yalon wan ti', catu' jix eli. Jix yewba el sba tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Cax c'al ec'al milagro jix x'ox Jesús tet eb, pero toj wal yu jun tu' chi yaoc sc'ul eb yin naj. ");
INSERT INTO knjNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Quey ton tu' jix yun yel oc tzet albil can yu naj Isaías, ẍejab Dios, yet jix yalon can jaxca ti': Mamin, ¿mac wal junoj jix yaoc yin sc'ul tzet jix kala? Cax c'al jix ja tx'ox ja wipal tet eb, pero c'am eb jix yaoc sc'ul ja win, ẍi can Isaías tu' yul An Juun Tz'ibebil can oj. ");
INSERT INTO knjNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yuxan ma c'al ta' ske' yaon oc eb yin sc'ul. Ila, tol albil pax yu naj Isaías junel xa jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ja' Dios, jaxca tol ja' chi majchen sat eb, chi ak'on cawxo sna'bal eb, yet watx' jaxca tol c'am chi ilwi eb, catu' c'am chi na'cha el yu eb, yet watx' c'am xa chi ske' sq'uexon sna'bal eb. Yu jun tu', ja' Dios, ma yak' lawoj spenail eb, ẍi Isaías tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yalnaj can naj Isaías wan ti', yutol yilnaj swatx'il Jesús, yuxan ja' ton sk'aneal ti' albil can yul An Juun Tz'ibebil can oj. ");
INSERT INTO knjNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Cax c'al albil can jaxca tu', pero ey eb Israel tu' jix yaoc sc'ul yin Jesús. Man asanne oj eb comon ánima, pero ey pax eb yaaw, ec'al eb jix yaoc yin sc'ul. Asan tol c'am chi x'ox el sba eb, yutol chi xiw eb tet eb fariseo, yutol tala chi ujtele eltej eb yul snail sculto eb yu eb. ");
INSERT INTO knjNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jix yute sba eb jaxca tu', yutol chi yoche eb tol miman yel oc apnoj eb yul sat ánima. C'am chi sna' eb ta tol ey yel oc apnoj eb yul sat Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ja' naj Jesús, yin ipal jix k'anab eltej xol ánima jaxca ti': —Ja' eb chi yaoc sc'ul win an, man asanne oj win chi yaoc sc'ul eb. Chi ya pax oc sc'ul eb yin jin Mam jix jin chejontej. ");
INSERT INTO knjNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ja' eb chin aon oc yin sc'ul, lalan pax yaon oc jun mac jix jin chejontej eb yin sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Jainti', jix jin jul yu wak'on saj k'inal yin spixan eb ánima yul yiban k'inal ti', yet watx' ja' eb chi yaoc sc'ul win an, c'am xa k'ej k'inal yin spixan eb. ");
INSERT INTO knjNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ja' eb chi aben jin k'ane, ta c'am chi sjije eb, man jain oj, oj waoc sya'ilal eb. Yutol man yu oj waon oc sya'ilal ánima, yuxan jix jin jul yul yiban k'inal ti'. Pero yu jin colon el eb, yuxan jix jin jul an. ");
INSERT INTO knjNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ja' eb c'am wel oc apnoj yul sat, eb c'am chi sjije jin k'ane, ey xa jun tujan oj aon oc sya'ilal eb, ja' ton jin k'ane chi wal ti' an. Ja' jin k'ane ti', oj aon oc sya'ilal eb yet slawub c'ual. ");
INSERT INTO knjNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yutol man yul oj wet chin k'anab jin txojli. Ja' jin Mam, jun jix jin chejontej, ja' chi ak'on ẍejbanil e in tzet chi wal an. ");
INSERT INTO knjNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wotaj an, yu ẍejbanil tu', chi ske' ẍa'on can sk'inal eb tol ey c'al yin tobal k'inal ta chi yaoc eb yin sc'ul. Yu jun tu', jaxca jix yun yalon jin Mam e in an, quey tu' chi wute walon pax an, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yecal oj xa c'al k'in pascua, yotaj xa Jesús, tol jix jul stiempoal sbejon can jun yul yiban k'inal ti', catu' chi pax a bey cu Mam Dios. Caw ey scam c'ulal naj yin eb scuywom, eb ey to ey ec' yul yiban k'inal ti'. Ja' tinani' jix x'ox jantaj scam c'ulal yin eb. ");
INSERT INTO knjNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Tuxa jix oc naj diablo yin spixan naj Judas, sc'aal Simón Iscariote, tzet utbil tol ja' naj oj aon oc Jesús yul sk'ab camich. Pero ja' Jesús yotaj, tol ja' bey Dios titnaj, catu' ja'c'ala' titu' oj pax a oj. Yotaj, tol ja' cu Mam Dios jix ak'on masanil yipal yul sk'ab. Ja' yet lalan slow yetoj eb scuywom tu', jix a waan oj, jix yi'on el an spichil. Catu' jix spixon oc jun toalla yin snan. ");
INSERT INTO knjNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Catu' jix yaon ey ja' yul jun palangana. Jix x'a'on el yajan eb scuywom tu', jix sjo'on taj yetoj an toalla jix spix oc yin snan tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ja' yet ian tuxa oj tx'a' el yajan naj Simón Pedro jix yalon naj Pedro tu' tet naj jaxca ti': —Wuẍtaj, ¿tumi ian cha tx'a' el wajan ti' an ja waloni? ẍi naj tet. ");
INSERT INTO knjNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Ja' tinani', c'am chi na'cha el oj, tzet yetal chi wun ti'. Pero c'uan c'ulal oj na'cha el oj, ẍi Jesús tu' tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—C'am bak'in tol jaach, oj ja tx'a' el wajan ti' an, ẍi naj Pedro tu' tet Jesús. —Ta c'am cha wak' jin tx'a' el xin, c'am ja walon ja wet wetoj an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Ta quey tu' xin, Wuẍtaj, man ojab asanne oj wajan ti' cha tx'a' el oj, tx'a' pax jin k'ab ti', c'al jin jolom, ẍi naj Pedro tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Catu' jix yalon Jesús jaxca ti': —K'inaloj ey junoj mac tol to jix axni, man xa sowalil oj chi tx'a'le smimanil masanil. Asanxane yajan chi tx'a'lei, yutol ja' smimanil, saj xa yei. Jaexti' jaxca junoj jix axni tu', quey tu' je yei, yutol tuxa jix wa'xi je na'bal. Pero man je masanil oj jix wa'xi je na'bal, ẍi Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yotaj xa naj mac txequel oj aon oc yul sk'ab camich. Yu jun tu', yuxan jix yal jaxca ti': “Man je masanil oj jix wa'xi je na'bal,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ja' yet jix lawi x'a'le yajan eb tu', catu' jix yaon pax oc an spichil tu' junel xa. Catu' jix ey chotan yetoj eb, jix yalon tet eb jaxca ti': —¿Chim na'cha el je yu, tzet yuxan quey tu' chex wute an? ");
INSERT INTO knjNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jainti', chin je yal oc je Cuywam oj, catu' chin je yalon oc je Yaawil oj. Yel ton che yala. ");
INSERT INTO knjNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Je Cuywam jin toni. Je Yaawil jin toni. Pero ila jix jin tx'a' el je yajan ti'. Yu jun tu', smoo quey tu' che yute je ba pax oj. ");
INSERT INTO knjNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jix jin tx'ox jun ti' e ex, yet watx' jaxca chex wute wak'on servil ti' an, quey tu' che yute je yak'wi servil pax oj. ");
INSERT INTO knjNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Caw yel chi wal e ex an, c'am junoj moso ec'ban yintaj spatrón. Quey pax tu' eb ẍejab, c'am junoj mac ec'ban yintaj mac chi chejon eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ta chi na'cha el wan ti' je yu, catu' che jijeni, caw watx' je yet. ");
INSERT INTO knjNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Man je yu oj je masanil, yuxan chi wal jaxca ti', yutol wotaj an, mac jex sic'bil jex xa el wu. Pero sowalil oj yun c'al ta' tzet tz'ibebil can yul An Juun Tz'ibebil can oj bey chi yal jaxca ti': “Ja' jun chi low wetoj, ja' oj meltzo oc win an,” ẍi An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yin ey oj to chi walon can wan ti' e ex, yet watx', ja' yet oj jul wiban, catu' caw oj je yaon oc je c'ul win, tol jain ton Cristo jin an. ");
INSERT INTO knjNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Caw yel chi wal e ex an, ja' mac chi cha'on eb jin chejab, jain ton chin ẍa' eb an. Ja' eb chin cha'on tu', chi ẍa' pax eb mac jun jix jin chejtej, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ja' yet jix lawi yalon wan ti' Jesús, jix oc pitz'an cus c'ulal yin spixan, yuxan jix yal jaxca ti': —Caw yel chi wal e ex, ja' je xol, ey jun oj jin aon oc yul sk'ab camich, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Catu' jix c'oli yil-len oc sba eb scuywom tu', yutol man yotaj oj eb, mac jun chi yal tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ey jun cam c'ulnebil yu sic'lebil, chotan ey sc'atan naj yet lalan slow eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jix yak'on yechel Simón Pedro tet naj, yet watx' chi sk'anle tet Jesús tu', mac txequel jun chi yal tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yu jun tu' xin, yuxan jix sjitz xa c'al oc sba sc'atan naj. Jix sk'anlen tet: —Wuẍtaj, ¿mac txequel jun cha wal tu' tinani'? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Catu' jix yalon Jesús tu' tet naj jaxca ti': —Oj wak' chacboj nian pan ti', catu' oj wak'on tet, ja' ton jun tu', ẍi Jesús. Jix lawi yalon Jesús jaxca tu' xin, catu' jix yak'on chacboj nian pan tu', catu' jix yak'on tet naj Judas, naj sc'aal Simón Iscariote. ");
INSERT INTO knjNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jix lawi c'al ẍa'on nian pan tu' naj Judas tu', catu' jix oc Satanás yin naj, catu' jix yalon Jesús tu' tet naj jaxca ti': —Ja' tzet jix ja na'balne el ja wuneni, cha wun yin eymanil, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ja' eb chi low yin meẍa tu' yetoj, c'am junoj eb jix na'cha el yu, tzet yuxan quey tu' jix yal tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ja' naj Judas tu', c'ubom tumin ye xol eb. Yu jun tu', yuxan ey eb jix na'oni, tol chi chejletoj mano junoj tzet yetal bey k'in tu', ma xin ja' nioj tumin tu' chi chejle to yak' tet eb meba', sna'on eb. ");
INSERT INTO knjNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ja' naj Judas tu' xin, jix lawi c'al slo'on nian pan tu', jix el xol eb, yet k'ejbintajil xa. ");
INSERT INTO knjNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ja' yet jix eltoj Judas tu', jix yalon Jesús jaxca ti': —Ja' tinani', oj x'ox el oj, tol caw miman wel oc apnoj, jain Ak'bil Wopiso xol eb ket animail yu Dios, catu' oj jin tx'oxon pax el oj, tol miman yel oc apnoj Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ta chin tx'ox el oj, tol miman yel oc apnoj Dios, oj x'oxon pax el oj tol miman pax wel oc apnoj. ");
INSERT INTO knjNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Jex jin cam c'ulnebil, txenxane tiempoal ey jin ec' je yetoj. Oj jin je sey ec' oj, pero ma to ske' je yapni bey oj jin apnoj tu', jaxca tu' jix yun walon tet eb yaawil ye bey Judea. ");
INSERT INTO knjNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ey jun xa ac' chejbanil oj wal can e ex tinani', tol che cam c'ulne je ba jun jun jex. Jaxca chex wute jin cam c'ulneni, quey ojab tu' che yute je cam c'ulnen pax je ba. ");
INSERT INTO knjNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ta che cam c'ulne je ba jun jun jex, oj yotajne el masanil eb ánima, tol yel toni jin cuywom jex, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jix sk'anlen Simón Pedro tu' tet naj jaxca ti': —Wuẍtaj, ¿beytu' oj jaach toj xin? ẍi naj tet Jesús. —Ja' bey oj jin apnoj ma to ske' je to wetoj tinani' an. Ja' to yet oj jul sc'ual, oj ske' je to wetoj titu' an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—Pero Wuẍtaj, ¿tzet yuxan c'am chi ske' jin to ja wetoj eyman tinani' xin? Caw bejan jin c'ul wak'le cam oj, ẍi naj Pedro tu' tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—¿Yel mi bejan ja c'ul ja wak'le cam wu an? Caw yel chi wal e ach, oxel xax jin ja wi'on el ja win, catu' oj ok' a no' caẍlan yet jun ak'bal ti', oj ja waloni, tol ma jin ja wotaj oj, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jix yal Jesús tet eb scuywom jaxca ti': —Manchej somcha el je na'bal. A wej oc je c'ul yin Dios, catu' che yaon pax oc je c'ul win an. ");
INSERT INTO knjNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ja' bey sna naj jin Mam an, caw ey lugar bey chi cu eyi. Ta c'am tzet jaxca ti', ¿xax mi wal e ex an? Oj jin toj jin wa'ne je lugar bey oj jex a apnoj. ");
INSERT INTO knjNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Oj lawoj jin wa'nen je lugar tu', catu' oj jin jul pax junel xa. Catu' oj jex wi'ontoj wetoj an, yet watx' ja' bey ey jin ec' tu', ja' tu' oj jex ey ec' wetoj an. ");
INSERT INTO knjNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Jaexti', je yotaj xa bey chin to an, je yotaj pax sbeal bey chin to tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Catu' jix yalon naj Tomás tet naj jaxca ti': —Wuẍtaj, man kotaj oj, bey oj jaach toj tu'. ¿Tzet oj kute kotajnen el jun be tu'? ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jix yalon Jesús tet naj jaxca ti': —Ja' jun be chi wal ti', jain toni. Asan jin chi ske' jex wi'ontoj bey ey ec' cu Mam Dios. Jain ton yel jin, jain ton a k'inale in an. ");
INSERT INTO knjNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tol oj wal chin je yotajne el oj. Ta chin je yotajne el oj, oj je yotajne pax el jin Mam, jal tinani', je yotaj xa jin Mam tu', yutol tuxa jix je yil yin, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jix yalon Felipe tet naj jaxca ti': —Wuẍtaj, tx'ox ja Mam tu' kila, catu' c'am xa sowalil wanoj xa, ẍi naj Felipe tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jix tak'wi Jesús jaxca ti': —Felipe, miman xa tiempo ey jin ec' je yetoj. ¿Tumi c'am to cha wotajne el mac jin txequel xin? Ja' eb chin ilon an, lalan yilon eb yin cu Mam Dios. Yu jun tu', ¿tzet yuxan cha wal e in: “Tx'ox ja Mam tu' kila,” ja chi? ");
INSERT INTO knjNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Tumi c'am cha waoc yin ja c'ul tol ey jin oc yin cu Mam Dios, catu' ey pax oc naj win an? Ja' tzet chi wal an, man yul oj wet chi walon an. Pero tol ja' cu Mam Dios ey oc win an, ja' chi oc wetoj an. ");
INSERT INTO knjNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","A wej oc yin je c'ul, tol ey jin oc yin cu Mam Dios, catu' ey pax oc win. Ta c'am che yaoc je c'ul win yu tzet chi wal ti' an, a wej oc je c'ul win yu wan milagro chin tx'oxo. ");
INSERT INTO knjNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Caw yel chi wal e ex an, ja' mac chin aon oc yin sc'ul, oj yun eb wan chi wun ti' an. Tol tax ey wan tzet yetal ec'ban oj el yunen eb yintaj wan ti', yutol oj jin pax a bey ey ec' cu Mam Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yal c'al tzet oj je k'an tet Dios yin jin bi an, oj jin wa'ne el e ex. Oj jin wa'ne el jainti', tol Sc'aal jin Dios, yet watx' oj jin tx'ox el oj, tol caw miman yel oc apnoj cu Mam Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yal c'al tzet oj je k'an tet Dios yin jin bi, oj jin wa'ne el e ex an. ");
INSERT INTO knjNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ta chi cam el je c'ul win an, jije wej jin chejbanil an. ");
INSERT INTO knjNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Jainti' oj jin k'an tet cu Mam Dios, catu' oj jin chejontej jun xa mac oj colwa je yetoj, ja' ton Yespíritu caw yel. Ja' oj ey ec' je yetoj yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ja' eb yet yul yiban k'inal ti', ma ske' ẍa'on jun ti' eb, yutol c'am chi ske' yilon oc eb yin, man yotaj oj eb. Jal jex xin, je yotaj xa Yespíritu ti', yutol ey ec' je yetoj. Ja' oj ey ec' je yin yin junelne. ");
INSERT INTO knjNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Jainti', ma jex jin bej can je txojli, oj jin jul pax junel xa. ");
INSERT INTO knjNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Txenxane tiempo, catu', c'am xa bak'in oj yil eb ánima win an. Jal jex, jaexti' xin, oj jin je yil an. Yutol iquis jin c'al tobal k'inal, yu jun tu', yuxan iquis jex pax tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ja' yet jun c'ual yet oj oc Yespíritu tu' je yin, catu' oj na'cha el je yu, tol ey jin oc yin jin Mam, catu' ey oc naj win an. Catu' oj na'cha pax el je yu, tol ey jex oc win an, catu' ey jin pax oj je yin. ");
INSERT INTO knjNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ja' mac chi aben jin chejbanil, catu' chi sjijen pax oj, ja' ton eb tu' chi cam el sc'ul win an. Ja' eb chi cam el sc'ul win, ja' jin Mam oj cam c'ulnen eb. Yetoj jin pax oj, oj jin cam c'ulne pax eb. Catu' oj jin tx'oxon jin ba tet eb an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ey jun xa mac chi yij Judas, manaj naj Judas Iscariote, ja' jix alon tet Jesús jaxca ti': —Wuẍtaj, ¿tzet yuxan asanne e on oj ja tx'ox ja ba? ¿Tzet yuxan man oj ja tx'ox ja ba tet eb yet yul yiban k'inal ti'? ẍi naj tet Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Catu' jix yalon naj tet naj Judas tu' jaxca ti': —Ja' mac chin cam c'ulneni, chi sjije tzet chi wal an. Yuxan ja' jin Mam chi cam c'ulnen pax eb. Catu' oj cu ey ec' yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jal eb c'am chin cam c'ulneni, c'am chi sjije eb tzet chi wal an. Ja wan k'ane chi wal e ex ti' an, man wetoj an, yet cu Mam Dios, naj jix jin chejontej. ");
INSERT INTO knjNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Chi wal can wan ti' e ex, yajban tol ey jin to ec' je yetoj. ");
INSERT INTO knjNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ja' cu Mam Dios oj chejontej Yespíritu e ex jin q'uexel oj. Ja' ton oj colwa je yetoj. Oj jex scuy yin masanil tzet yetal. Oj sjej je na' jantaj tzet albil can e ex wu an. ");
INSERT INTO knjNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ja' tinani' xin, chex wa can oc yin watx' c'ulal. Ja' caw jin watx' c'ulal chi wak' can e ex. Manaj swatx' c'ulal eb yul yiban k'inal ti' chi wak' can e ex, man quey oj tu' wet chi wak' can e ex. Manchej je yak' bis c'ulal, catu' c'am chex xiwi. ");
INSERT INTO knjNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xax wal je yab an, tol oj jin pax a oj, pero oj jin jul pax oj, catu' oj jin ey ec' je yetoj. Ta yel chin je cam c'ulne, ta jaxca tu', smoo chex tzalabi yet che yabeni tol oj jin pax a bey cu Mam Dios. Yutol ec'ban naj wiban. ");
INSERT INTO knjNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yin ey oj to chi wal can wan ti' e ex, yet watx' ja' yet oj yunen tzet chi wal ti' an, catu' oj jin je yaon oc yin je c'ul. ");
INSERT INTO knjNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Man xa miman oj tzet chi wal can e ex an, yutol lalan sjul jun yaaw yul yiban k'inal ti'. Ja' jun tu' c'am yalon yet win. ");
INSERT INTO knjNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero chin jije ẍejbanil cu Mam Dios jix yal e in, yet watx' oj yotajne el eb ánima masanil, tol ey jin cam c'ulal yin naj. Ja' tinani' xin, aan linan oj, toon nej, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jix yalon Jesús tet eb scuywom jaxca ti': —Ja' jun xutxal uva chin tx'ox ti', tol quey jin pax tu'. Ja' jun winaj chi ilwi uva tu', ja' chi tx'oxon el yechel jin Mam. ");
INSERT INTO knjNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta ey junoj an ak'ile c'am chi satni, ja' chi i'on el oj. Ta ey an ak'ile watx' chi satni, chi yi'on el stajinal yak'il an yet watx' chi c'al satni. Jaxca chi yute swa'nen el an naj tu', quey tu' chi yun swa'nele el eb ey oc win yu jin Mam. ");
INSERT INTO knjNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jaexti', xax wa'xi oc je na'bal yu wan cuybanile albil can e ex wu ti' an. ");
INSERT INTO knjNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Eyan nej c'al ec' win an. Jain xa oj jin ey ec' je yin. Jaxca junoj yak'il an chi el yin xutxal, c'am xa chi ske' satni, quey pax tu' che yune', ta c'am chex ey c'al ec' win an. ");
INSERT INTO knjNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Jainti', jaxca xutxal uva, quey jin tu'. Jaex jaxca yak'il uva jex. Ja' mac ey c'al oc win an, ey jin pax oc yin. Ja' jun tu' miman sat chi yak'a, jaxca junoj te' miman sat chi yak'a. Ta c'am jin oc je yin, c'am nioj tzet chi ske' je yu je txojli. ");
INSERT INTO knjNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jal eb c'am chi ey c'al ec' win an xin, laan oj yun yel oc eb jaxca jun yak'il uva chi i'le el yin xutxal, catu' chi taj el oj, chi lawi tu', chi yambale a oj, catu' chi tz'a'i. ");
INSERT INTO knjNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ta chex ey c'al ec' win an, catu' ey c'al oc je c'ul yin jin k'ane, k'an wej tzet chi yoche je c'ul, oj ak'le e ex. ");
INSERT INTO knjNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ta miman je sat che yak'a, quey ton tu' oj je yute je tx'oxon el oj, tol miman yel oc apnoj jin Mam. Quey pax tu' oj je yute je tx'oxon el oj, tol jin cuywom jex an. ");
INSERT INTO knjNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jaxca chin yute scam c'ulnen cu Mam Dios, quey tu' chex wute jin cam c'ulnen pax oj. Yu jun tu', yuxan eyan nej c'al ec' yin jin cam c'ulal ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ta che jije jin chejbanil an, oj jex ey c'al ec' yin jin cam c'ulalil. Yutol quey tu' wak'on yetoj jin Mam, chin jije ẍejbanil. Yu jun tu', yuxan ey jin c'al ec' yin scam c'ulal naj. ");
INSERT INTO knjNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Chi wal can wan ti' e ex an, yet watx' jaxca ojab jin tzala an, quey ojab tu' je tzala pax oj, catu' chi tz'ajna xa c'al el je tzala c'ulal. ");
INSERT INTO knjNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ja' tinani', ey jun jin chejbanil oj wak' can e ex, tol che cam c'ulne je ba jun jun jex, jaxca chex wute jin cam c'ulnen an. ");
INSERT INTO knjNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ta ey junoj mac chi yak' sba cam yu junoj yamigo, c'am junoj xa mac ec'ban scam c'ulal yintaj jun mac txequel tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ta che jije jin chejbanil tu' jaexti', wamigo jex toni. ");
INSERT INTO knjNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ja' tinani', chi wal e ex, man xa yak'omal oj servil je ye e in an. Yutol ja' junoj yak'omal oj servil man yotaj oj tzet chi yun spatrón. Pero ja' tinani', wamigo jex, yutol masanil c'al tzet jix yal jin Mam e in, jix c'al wal el e ex an. ");
INSERT INTO knjNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Manaj jex jix jin je sic' el oj. Pero tol jain jix jex jin sic' el oj. Jix waon oc je yopiso jex jin chejon satnoj. Ja' je sat tu', oj ey ec' c'al yin tobal k'inal. Yu jun tu', yuxan jantaj c'al tzet oj je k'an tet cu Mam Dios oj yak' e ex yutol wet jex an. ");
INSERT INTO knjNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ja' ton jun chejbanil ti' chi wak' can e ex, tol che cam c'ulne je ba jun jun jex. ");
INSERT INTO knjNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ta ey eb yet yul yiban k'inal ti' chi chichon oc sc'ul je yin, otajne wej el oj, tol ja' win jix babi chichon oc sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","K'inaloj ta yet jex yul yiban k'inal ti' yetoj eb, tejan chex scam c'ulne eb, yutol je yetbi je ba yetoj eb. Pero ma jex xa yetoj yul yiban k'inal ti', yutol xax jex jin sic' el xol eb. Yu jun tu', yuxan chi chichon oc sc'ul eb je yin, yutol man xa je yetbi oj je ba yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Caw che na'tej jun k'ane jix wal e ex ti': “C'am junoj moso ec'ban yintaj spatrón,” jin chi e ex. Jaxca jix yun yoc eb ac'ulal win, quey tu' oj yun pax yoc eb ac'ulal je yin. Ta jix sjije eb tzet jix wal jainti' an, oj sjije pax eb tzet oj je yala. ");
INSERT INTO knjNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jin ya'il oj, catu' oj je yaben sya'il masanil wan ti' yu eb, yutol man yotaj oj eb jun jix jin chejontej. ");
INSERT INTO knjNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","K'inaloj ta ma jin jul wal tet eb, c'am mi spenail eb. Pero tinani', c'am xa bey watx' chi scol sba eb yu spenail. ");
INSERT INTO knjNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yutol ja' mac chi chichon oc sc'ul win, chi chichon pax oc sc'ul yin jin Mam. ");
INSERT INTO knjNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ja' wan milagro xin tx'ox el xol eb, c'am junoj xa chi ske' yunen jaxca tu'. K'inaloj ta c'am milagro tu' jix jin tx'oxo, c'am mi spenail eb. Jal tinani' xin, cax c'al mi jix yil wan tu' eb, pero ja'c'ala' c'al chichon oc sc'ul eb win, catu' chi chichon pax oc sc'ul eb yin jin Mam. ");
INSERT INTO knjNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero ja'c'ala' oj el yunen wan ti' eb, yet watx' chi yun tzet tz'ibebil can yul an ley bey chi tz'aj yaoc sc'ul eb, bey chi yal jaxca ti': “C'am jin penail tet eb, pero jix chichon oc sc'ul eb win,” ẍi yul An Juun Tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pero ey jun oj tit bey cu Mam Dios, ja' ton naj Espíritu caw yel. Oj jul oj, catu' oj colwa je yetoj. Jain oj toj jin chejtej. Ja' jun tu' oj yak' testigoal sba win an. ");
INSERT INTO knjNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ja'c'ala' jex pax oj, oj je yak' pax je ba testigoal win, yutol junne c'al jex wetoj yet tax c'al jix el yich jin mulnail ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Chi wal can wan ti' e ex an, yet watx' c'am chi somcha el je c'ul. ");
INSERT INTO knjNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yutol oj jex yujte eltej eb ket Israelal yul snail sculto eb. Tol tax ey jun tiempoal yel xa c'al oj jex ak'on cam oj, catu' ja' oj yute sna'on eb, tol ja' Dios lalan yak'on servil eb. ");
INSERT INTO knjNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Oj yun eb jaxca tu', yutol man yotaj oj jin Mam eb, catu' ma jin yotaj oj jin pax eb. ");
INSERT INTO knjNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Chi wal can wan ti' e ex, yet watx' ja' yet oj jul wan tiempoal tu', oj je na'tej, tol albil can e ex wu an. Ma wal wan ti' e ex yet yalantoj, yutol ey jin ec' je yetoj yet tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jal tinani' xin, oj jin pax a sc'atan naj jix jin chejontej. Pero c'am junoj jex che k'anle el e in, bey oj jin toj. ");
INSERT INTO knjNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ja' ti' je yet, tol chex cus a yu wan chi wal ti' an. ");
INSERT INTO knjNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero caw yel chi wal e ex an, ja' yu oj jin toj, yuxan caw watx' je yet. Ta c'am chin to an, c'am chi jul jun t'inan scolwa je yetoj tu'. Pero ja' yet oj jin toj, oj jin chejtej jun tu' e ex. ");
INSERT INTO knjNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ja' yet oj jul oj, oj ak'le yotajne el eb yet yul yiban k'inal ti', tol penawom eb. Oj ak'le yotajne el eb, tol jichan c'al jix wute jin ba, catu' oj yak' pax yotajne el eb, tol oj na'le oc yin eb yu Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Oj ak'le yotajne el eb tol penawom eb, ja' ton yu c'am chin yaoc eb yin sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Oj ak'le yotajne el eb, tol watx' c'al jix wute jin ba, yutol jainti', oj jin pax bey ey ec' cu Mam Dios. C'am xa bey oj je yil win titi'. ");
INSERT INTO knjNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Oj ak'le pax yotajne el eb, tol oj na'le oc yin eb yu Dios, yutol xax na'le oc yin jun yaaw yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ey to c'al tzet yetal chi yoche jin c'ul chi wal e ex an, pero ma to na'cha el je yu tinani'. ");
INSERT INTO knjNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ja' to yet oj jul Yespíritu Dios tol yel chi yala, ja' yet tu' oj na'cha el je yu, yutol man oj yal yul yet. Ja' masanil tzet oj al-le tet, ja' oj yala. Oj yal pax je yab tzet tol to oj jul oj. ");
INSERT INTO knjNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ja' oj tx'oxon el oj, tol miman wel oc apnoj. Masanil c'al tzet oj wal tet, oj yal e ex. ");
INSERT INTO knjNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wet c'al ye masanil tzet ey bey cu Mam Dios. Yu jun tu', chi wal e ex, masanil c'al tzet oj wal tet, oj yal e ex. ");
INSERT INTO knjNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Junxane txolan che yil oc win an, ja' yet jun xa txolan ma xa je yil win. Pero oj jin je yil yet caabe oxe, yutol oj jin pax a bey ey ec' cu Mam Dios, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jix lawi yalon jaxca tu' xin, jix c'oli yalon jaywan eb scuywom jaxca ti': —¿Tzet la chi yal yel oc apnoj wan chi yal e on ti'? Ila tol jix yala: “Junxane txolan che yil oc win tinani'. Ja' yet jun xa txolan ma xa je yil win, ja' to yet caabe oxe oj jin je yila,” Ila ẍi. Chi yalon pax oj: “Yutol oj jin pax a sc'atan cu Mam Dios,” ẍi e on. ");
INSERT INTO knjNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ja' jun chi yal ti', “junxane txolan” ¿tzet la wal chi yal yel oc apnoj wan ti'? Caw c'am chi na'cha el ku, tzet chi yala, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ja' Jesús xin, jix yotajne el oj, tol chi yoche eb chi sk'anle tet, tzet chi yal yel oc apnoj tzet jix yal tu'. Yu jun tu', yuxan jix yal tet eb jaxca ti': —Jix wal e ex: “Junxane txolan che yil oc win tinani'. Jal yet jun xa txolan, ma xa je yil win. Pero yet caabe oxe oj jin je yila,” jin chi e ex. ¿Tumi ja' tu' c'al wan jix wal e ex tu' che yalotene je xol? ");
INSERT INTO knjNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Caw yel chi wal e ex, oj jex cus oj, oj jex ok' oj. Jal eb yet yul yiban k'inal ti' xin, oj tzala eb. Oj jex ton cus oj, pero ja' jun je cus c'ulal tu', tzala c'ulal xa oj yute a sba. ");
INSERT INTO knjNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","K'inaloj junoj ix tinani', lalan yali yune'. Ya' ton chi yabe, yutol lalan yec' ya'. Pero ja' yet xax jul yune' tu', toj na'an to sya'ilal tu' yu, ja' ti' yet, caw chi tzalai, yutol xax jul jun unin yu yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jaxca ton junoj ix tu', quey tu' oj je yune'. Chex ton cus tinani'. Pero ja' yet oj jin je yilon yet junel xa tu', caw oj jex tzala a junel xa. Ja' jun je tzala c'ulal tu', c'am mac oj ske' yi'on ec' e ex. ");
INSERT INTO knjNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ja' yet jun c'ual tu', c'am xa tzet oj je k'anle el e in an. Caw yel chi wal e ex, masanil c'al tzet oj je k'an tet cu Mam Dios, oj yak' e ex yutol wet ex an. ");
INSERT INTO knjNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ja' tinani', c'am to tzet che k'an tet Dios yin jin bi. K'an wej, oj je cha'. Oj ak'le e ex, yet watx' oj tz'ajna el je tzala c'ulal. ");
INSERT INTO knjNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yin yechel k'ane jix yun walon wan cuybanile ti' e ex. Pero ey jun tiempoal oj jul oj, tol man xa quey oj tu' oj wute walon jaxca tu', yutol tool xa oj wute walon sk'aneal cu Mam Dios e ex. ");
INSERT INTO knjNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ja' to yet oj jul jun c'ual tu', oj je k'an tzet che yoche yin jin bi. Man lalan oj walon e ex, ta jain oj jin k'an tzettaj yetal tet cu Mam Dios je yu. ");
INSERT INTO knjNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ila, tol ja' caw naj chi cam el sc'ul je yin, yutol chin je cam c'ulne. Catu' che yaon oc yin je c'ul tol ja' tu' titnaj jin. ");
INSERT INTO knjNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yel, ja' sc'atan cu Mam Dios titnaj jin, catu' jix jin jul bey yul yiban k'inal ti', yuxan ja' tinani' xin, oj jin bej can yul yiban k'inal ti', catu' oj jin pax a bey ey ec' cu Mam Dios tu', ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Catu' jix yalon eb scuywom tu' tet naj jaxca ti': —Ja' tinani', watx' xa jix ja wute ja walon e on. Man xa yechel k'ane oj jix ja wute ja walon e on jaxca yet junel. ");
INSERT INTO knjNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ja' tinani', kotaj tol ja wotaj masanil tzet yetal. Man sowalil oj chi cu k'anle el e ach, catu' oj ja walon e on. Yu jun tu', yuxan chi kaoc yin cu c'ul tol ja' sc'atan Dios titnaj jaach, ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yuxan jix yal naj tet eb jaxca ti': —¿Chim je yaoc je c'ul win tinani'? ");
INSERT INTO knjNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pero lalan xa sjul tiempoal je sajlem can toj. Tx'oj tx'oj xa c'al bey oj jex toj can oj jun jun jex. Jal jin oj jin je bej jin can jin txojli. Pero man jin txojli oj, yutol ey ec' cu Mam Dios wetoj an. ");
INSERT INTO knjNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Jix wal masanil wan ti' e ex, yet watx' ey watx' c'ulal snan je xol yutol ey jin oc je yin. Ja' bey yul yiban k'inal ti', oj ton je yil sya'il. Pero tec'ba wej je ba, yutol ja' eb a yul yiban k'inal ti', xax can yalan wu an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jix lawi yalon wan tu' Jesús, jix a t'anan bey satcan. Catu' jix yalon jaxca ti': —Mamin, jix jul stiempoal ja tx'oxon yil eb tol miman wel oc apnoj jain ja C'aal jin ti'. Catu' oj jin tx'oxon pax el oj, tol caw miman ja wel oc apnoj. ");
INSERT INTO knjNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yutol jaach jix ja wak' wopiso yiban masanil ánima, yet watx' chi ske' wak'on k'inale tol ey c'al yin tobal k'inal tet eb jix ja wak' e in an. ");
INSERT INTO knjNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ta chach yotajne el eb tol asan jaach Dios jaach, catu' chin yotajnen el eb, jain Jesucristo jin ti' an, tol jain ton chejbil jin tej an, ja' ton yu jun tu', yuxan ey sk'inal eb tol ey c'al yin tobal k'inal. ");
INSERT INTO knjNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ja' yet ey jin ec' bey yul yiban k'inal ti', jix jin tx'ox el oj tol caw miman ja wel oc apnoj. Ja' jun mulanil ak'bil can wun ti', jix wa'xi wu. ");
INSERT INTO knjNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ja' yet c'am to chi wa'xi yul yiban k'inal ti', ey jin xa c'al ta' ec' ja wetoj bey xol cu watx'ilal. Jal tinani' xin, Mamin, cha' jin pax apnoj ja wetoj bey xol cu watx'ilal tu', jaxca c'al ta' we ec' ja wetoj. ");
INSERT INTO knjNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ja' eb jix ja sic' eltej xol eb yet yul yiban k'inal ti', catu' jix ja wak'on eb e in an, jix wak' yotajne el eb tzet utbil yoc ja na'bal. Ja' eb jix ja wak' e in tu', tu' c'al ta' ja wet c'al ta' eb. Jix sjije ja k'ane eb. ");
INSERT INTO knjNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ja' tinani', masanil c'al tzet ak'bil e in, yotaj eb, tol ja' e ach jix tita. ");
INSERT INTO knjNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ja' ja k'ane ak'bil e in tu', jix c'al wal tet eb, catu' jix yaon oc sc'ul eb yin. Yu jun tu', yuxan yotaj eb, tol yel toni ja' e ach tu' jix jin tita. Chi yaoc eb yin sc'ul, tol jaach jix jin ja chejtej. ");
INSERT INTO knjNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Yu jun tu' xin, chin txali yu eb. Jal eb yet yul yiban k'inal ti' xin, c'am chin txali yu eb. Asanne eb jix ja wak' e in an, asan eb tu' chin txali yu, yutol ja wet xa eb. ");
INSERT INTO knjNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Masanil c'al eb wet, ja wet xa pax eb. Ja'c'ala' pax eb ja wet, wet xa pax ye eb ja wetoj. Ja' ton eb tu' chi tx'oxon el oj tol caw miman wel oc apnoj. ");
INSERT INTO knjNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Txenxane tiempo ey jin ec' yul yiban k'inal ti', catu' chin pax a ja wetoj. Jal eb ti' xin, oj can eb nioj xa bey yul yiban k'inal ti'. Mamin, caw watx' ja na'bal. Ja' eb jix ja wak' e in ti', teyne eb yetoj ja wipal, yet watx' junxane ojab sna'bal eb jaxca wak'on ja wetoj. ");
INSERT INTO knjNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yet ey jin ec' yetoj eb bey yul yiban k'inal ti', jix jin teyne eb yetoj ja wipal. Ja' eb jix ja wak' e in an, jix ton jin teyne eb, yet watx' c'am tzet chi i'on eb. Yu jun tu', yuxan c'am junoj eb jix q'uey el oj. Pero asanne naj t'inan c'al ta' sq'uey el oj, yet watx' chi yun tzet tz'ibebil can yul An Juun. ");
INSERT INTO knjNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Oj jin pax a e ach tu' an. Yajban ey jin to ec' nioj xa yul yiban k'inal ti', chi wal can wan ti', yet watx' jaxca ojab jin tzala ti', quey ojab tu' chi yun tzala a eb sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Jix wal ja k'ane tet eb. Pero ja' eb ánima yet yul yiban k'inal ti', caw chi chichon oc sc'ul eb yin eb, yutol man xa yetoj yul yiban k'inal eb yetoj eb. Jaxca jin ton pax oj, ma jin xa yetoj yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Man lalan oj walon e ach, tol cha wi' el eb yul yiban k'inal ti' yin eymanil. Pero tol chin k'an e ach, tol cha teyne eb, yet watx' c'am eb chi etex el yu jun yel xa c'al pena. ");
INSERT INTO knjNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Jainti', ma jin yetoj yul yiban k'inal ti'. Ja'c'ala' pax eb, man yetoj yul yiban k'inal ti' eb. ");
INSERT INTO knjNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Cha wa'ne oc sna'bal eb yu ja k'ane tol yel chi yala. Asan ton ja k'ane tu' caw yel chi yala. ");
INSERT INTO knjNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jaxca jix jin ja wute ja chejontej xol ánima yul yiban k'inal ti', jaxca ton tu' jix wute jin chejon pax toj eb xol ánima tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yu swatx'il oj eb, yuxan chi wak' jin ba e ach, yet watx' chi oc eb ja wetoj sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Man asanne oj yu eb, chin txali, pero chin txali pax yu eb tol to oj yaoc sc'ul win yu tzettaj oj yal eb jin chejab ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Chin k'an e ach xin, tol junxane ojab chi yun sna'bal eb masanil. Mamin, junne we ja wetoj, junne pax ja we wetoj an. Tol oj wal jaxca ke tu', quey ojab tu' chi yun eb, junxane chi yun eb ketoj. Jaxca tu' xin, oj yaoc eb ánima bey yul yiban k'inal ti' yin sc'ul, tol jaach jix jin ja chejtej. ");
INSERT INTO knjNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ja' ja watx'ilal ak'bil can e in an, ja' jix wak' tet eb, yet watx' junxane chi yun can sna'bal eb, jaxca jin ja wetoj. ");
INSERT INTO knjNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jain, ey jin oc yin eb, jaach, ey jaach oc win an, yet watx' junxane oj yun sna'bal eb, catu' oj na'cha el yu eb ánima bey yul yiban k'inal, tol jaach jix jin ja chejtej. Oj yil eb, tol jaxca chin ja wute ja cam c'ulneni, jaxca tu' cha wute ja cam c'ulnen pax eb ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Mamin, ja' eb jix ja wak' e in tu' an, chi woche tol ja' bey oj jin ey ec' oj, ja' tu' chi ey pax ec' eb wetoj an, yet watx' oj yil eb swatx'ilal ak'bil e in an. Yutol cam c'ulnebil jin xa an, yet tax c'am to chi wa'xi yul yiban k'inal ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mamin, watx' ton ja na'bal. Ja' eb yet yul yiban k'inal ti', ma jaach yotaj oj eb. Jal jin jainti', wotaj jaach an. Jal eb ti' xin, yotaj xa eb, tol jaach jix jin ja chejtej. ");
INSERT INTO knjNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Jain jix wak' yotajne el eb, tzet utbil ja na'bal. Tol oj wak' c'al yotajne el eb, yet watx' jaxca chin ja wute ja cam c'ulneni, jaxca ojab tu' cha wute ja cam c'ulnen pax eb. Catu' chach oc caan yin eb yin junelne, ẍi Jesús tet cu Mam Dios. ");
INSERT INTO knjNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jix lawi yalon Jesús wan ti', catu' jix to yetoj eb scuywom tu'. Jix to yetoj eb bey sk'axepal jun jo'be chi yij Cedrón, bey ey wan te' awbeal te'. Ja' titu' jix apni eb xol te'. ");
INSERT INTO knjNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ja' naj Judas, naj t'inan yaon oc Jesús yul sk'ab camich, yotaj naj jun lugar tu', yutol ec'al el jix bet Jesús yetoj eb scuywom titu'. ");
INSERT INTO knjNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yu jun tu', yuxan jix to naj titu', yetoj jun bulan soldado, c'al wan eb steynemal stemplo Dios. Jix chejletoj yu eb yaawil yak'omal xaambal eb Israel tet Dios. C'al yetoj eb fariseo. Tzejbil oc sta eb, i'bil pax slámpara eb, catu' yetbi pax oc eb smitx'k'abil jowal, catu' jix apni eb. ");
INSERT INTO knjNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ja' Jesús xin, yotaj xa jantaj tzet t'inan oj jul yiban. Yu jun tu', yuxan jix eltej yu ẍa'on eb jix apni tu', jix sk'anlen tet eb jaxca ti': —¿Mac txequel che seya? ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ja' Jesús a Nazaret, ja' chi cu seya, ẍi eb tet naj. —Jain ton xin, ẍi Jesús tet eb. Yaman Judas yetoj eb, naj lalan yaon oc naj yul sk'ab camich. ");
INSERT INTO knjNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jix lawi c'al yalon Jesús tet eb jaxca tu', jix to tecton eb yintaj, jix to pac'na eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jix sk'anlen Jesús tet eb junel xa: —¿Mac txequel che sey xin? ẍi Jesús tet eb junel xa. —Ja' Jesús a Nazaret, ja' chi cu seya, ẍi eb tet naj junel xa. ");
INSERT INTO knjNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Pero jix wal e ex, tol jain toni. Ta jain chin je sey ec' oj, bej wej can el eb ey ec' wetoj ti' an, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jaxca ton tu' jix yun xin, yet watx' chi yun tzet jix yal Jesús yin eb scuywom, yet jix yalon jaxca ti': “Ja' eb jix ja wak' e in ti' an, c'am junoj eb jix q'uey can el oj,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jix yi'on atej yespada naj Simón Pedro yul s'umal tu', jix soc'on oc yin jun naj chi yij Malco, naj smoso naj yaawil yak'omal xaambal eb Israel tet Dios. Ja' xiquin naj bey swatx' jix el yu. ");
INSERT INTO knjNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Catu' jix yalon Jesús tet naj Pedro tu' jaxca ti': —A eytoj ja wespada yul s'umal. ¿Chim ja na' tol man oj wak' jin ba yul sk'ab jun sya'ilal chi sbej cu Mam Dios wiban ti' an? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jix mitx'le Jesús yu eb soldado c'al yu naj coronel yetoj eb policía a Judea tu', catu' jix c'al-le ey naj yu eb. ");
INSERT INTO knjNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Catu' jix i'letoj naj yu eb bey sna naj Anás, naj sni' naj Caifás. Ja' naj Caifás tu', yaawil yak'omal xaambal eb Israel tet Dios yet jun jabil tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ja' ton jix alon tet eb yaawil ye bey Judea tu', tol sowalil chi cam junoj mac txequel sq'uexel oj masanil ánima. ");
INSERT INTO knjNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ja' yet jix i'letoj Jesús yu eb, tzajan oc Simón Pedro yintaj, yetoj jun xa scuywom Jesús. Ja' jun xa scuywom tu', yotaj sba yetoj naj yaawil yak'omal xaambal eb Israel tet Dios. Yu jun tu', yuxan jix octoj naj yetoj Jesús bey yamak'il sna naj. ");
INSERT INTO knjNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Jal pax naj Pedro xin, jix can can sti' puerta. Ja' jun xa scuywom Jesús tu', jix elol bey linan can oc Pedro tu', catu' jix yalon tet ix ix teynem sti' na tu', tol chi octoj naj Pedro tu' yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Catu' jix yalon ix teynem sti' na tu' tet naj jaxca ti': —Jaachti', tejan scuywom jaach jun winaj jix mitx'le ti', ẍi ix tet Pedro tu'. —C'amaj. Man jin scuywom oj, ẍi naj, jix tz'aj yalon tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ja' yet jun tiempoal tu', stiempoal sic'. Yu jun tu', yuxan jix yaoc sk'ak' yetoj tzak'ak' eb, eb moso c'al eb policía. Catu' jix oc linan eb k'aẍnoj. Jix oc pax linan naj Pedro k'aẍnoj yetoj eb. ");
INSERT INTO knjNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ja' naj yaawil yak'omal xaambal eb Israel tet Dios, jix sk'anlen el tet Jesús jaxca ti': —¿Mac taj txequel eb ja cuywom? ¿Tzettaj cuybanile cha wak' scuy eb? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Catu' jix yalon Jesús tu' tet eb jaxca ti': —Ja' wan jin cuybanil ti', jix wal el xol eb ánima masanil. Masanil c'al tiempo chi wal el yul-laj snail cu culto, c'al yul stemplo Dios, c'al bey c'al chi syamba sba eb ket Israelal masanil. C'am junoj tzet yetal jix wal yin ewantajil. ");
INSERT INTO knjNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tzet yuxan ja' e in cha k'anle? K'anle tet eb jix aben walon eltej tu'. Yal ojab eb e ach, tzettaj ẍi wan jin cuybanil tu'. Yutol yotaj xa eb, tzettaj jix wal el oj, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jix lawi c'al yalon Jesús wan tu', catu' jix tzak'letoj sat Jesús tu' yu jun naj steynemal stemplo Dios ey ec' titu'. Catu' jix yalon naj tet Jesús jaxca ti': —¿Tzet yuxan quey tu' cha wute tak'woj ja ba tet naj yaawil yak'omal xaambal tet Dios? ẍi naj tet Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","—Ta ey tzet pena jix wal jix ja wabe, ala tzet yetal pena jix wal tu'. Pero ta watx' c'al jix wute k'anab jin ba tet, ¿tzet yuxan comon c'al chin ja mak'a? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jix lawi tu' xin, catu' jix ak'le i'letoj naj bey Caifás yu naj Anás tu', ja' ton naj yaawil yak'omal xaambal eb Israel tet Dios. Calbil c'al naj yet jix yi'ontoj eb. ");
INSERT INTO knjNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Linan c'al oc naj Pedro k'aẍnoj sti' k'ak' yetoj eb policía, catu' jix yalon eb tet jaxca ti': —Jaachti', tejan tol scuywom jaach Jesús, ẍi eb tet naj. Catu' jix yi'on el yin, catu' jix yalon jaxca ti': —C'amaj, ma jin scuywom oj, ẍi Pedro, jix tz'aj yaloni. ");
INSERT INTO knjNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jix lawi tu', ey jun smoso naj yaawil yak'omal xaambal eb Israel tet Dios, yican to sba yetoj naj tzoc'bil el xiquin yu naj Pedro tu'. Ja' naj jix alon tet Pedro tu' jaxca ti': —Jaachti', ¿tumi manaj jaach jix wil ja wec' yetoj Jesús bey xol-laj wan te' awbeal te'? ẍi naj tet naj Pedro tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Jix yi'on pax el naj Pedro tu' yin junel xa. Jix lawi c'al yalon jaxca tu', jix ok' a no' caẍlan. ");
INSERT INTO knjNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ja' yet jix sajbi a xin, catu' jix i'le eltej Jesús yu eb yul sna Caifás tu', catu' jix i'letoj naj yu eb bey sdespacho naj yaaw. Ja' sley eb a Judea tu', tol c'am chi ske' yoc eb yul sdespacho naj yaaw tu'. Ja' chi yute sna'on eb, tol chi tz'ilbi el eb yul sat Dios ta chi octoj eb. Catu' c'am xa chi ske' slow eb yet sk'in pascua chi jul tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yu jun tu', yuxan jix eltej naj yaaw tu' sti' sdespacho tu', ja' ton naj chi yij Pilato. Jix k'anab naj snan xol eb tu' jaxca ti': —¿Tzet smul jun winaj chi jul je yak' e in ti' an? ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Ta man pena oj jun winaj ti', ma ske' comon c'al oj ki'tej e ach, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yuxan jix yal Pilato jaxca ti': —I' wej toj naj jaexti'. Catu' che na'on oc yin naj jaexti' titu', yin ja'ta'c'ala' yalon je ley, ẍi Pilato tet eb. —Ja' jaon Israel jon ti', c'am chi ske' tol comon c'al chi kaoc camich yiban junoj mac txequel, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jaxca ton ti' jix yun yel can apnoj tzet jix yal Jesús, tzet utbil oj yun scami. ");
INSERT INTO knjNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jix pax oc Pilato tu' yul sdespacho tu', catu' jix awtele octoj Jesús tu' yu. Jix sk'anlen el tet naj jaxca ti': —¿Tumi jaachti', Sreyal jaach eb Israel? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","¿Yul c'al mi ja wet chi tita, yuxan cha k'anle el jun ti' e in an, ma ey mac jix alon e ach? ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—¿Tumi Israel jin cha wila? Ja' eb ja wet conob, c'al eb yaawil yak'omal xaambal eb tet Dios, ja' eb jix jaach jul aon oc yul jin k'ab. ¿Tzet jix ja sey ja mulne? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Jainti', manaj yul yiban k'inal ti' rey jin an. K'inaloj ta ja' yul yiban k'inal ti' rey jin an, chim a waan eb wak'omal servil yin jowal, yet watx' c'am chin ale oc yul sk'ab eb yaawil ye bey Judea, yuxan manaj titi', rey jin an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—¿Tumi caw yel rey jaach xin? ẍi Pilato tet Jesús. —Ja' toni, rey jin ton jaxca ja walon ti'. Jainti', chin jul ec' yul yiban k'inal ti', yu jul walon tzet yetal caw yel. Yu ch'an jun tu', yuxan jix jin ali. Masanil c'al eb yet xa jun k'ane yel, chi yak' xiquin eb tet tzet chi wal an, ẍi Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Catu' jix yalon Pilato tu' tet naj jaxca ti': —A… ¿tzet yetal jun yel cha wal tu'? ẍi Pilato tet Jesús. Jix lawi yalon jaxca tu' xin, catu' jix el pax tej sti' sdespacho bey ey ec' eb a Judea tu'. Jix yalon eltej xol eb tu' jaxca ti': —Ja' jun winaj ti', c'am nioj smul chi wil an. ");
INSERT INTO knjNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero ey jun je ley, tol ja' yet jun jun k'in pascua ti', che k'an jajcha junoj preso yei, catu' chin jajon el oj. Yu jun tu' xin, ¿c'am mi wal chi yal je c'ul ja' jun je reyal jaex Israel jex ti' chin jaj el tinani' yet jun jabil ti'? ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yu jun tu', jix a yaw eb masanil, jix yalon eb jaxca ti': —Ja' jun winaj ti', c'am chi koche. Ja' ojab naj Barrabás chi jajchai, ẍi eb tet Pilato. Pero elk'om naj Barrabás tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Catu' jix yi'ontoj Jesús naj Pilato tu', jix to yak'on mak'le oj. ");
INSERT INTO knjNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jix lawi tu', jix spatx'onen ey jun q'uix eb soldado tu'. Catu' jix yaon atoj eb yin sjolom scorona oj. Catu' jix yaon oc jun morado pichile eb yin naj. ");
INSERT INTO knjNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jix lawi tu', jix apni eb sc'atan, catu' jix c'oli tz'ajon yalon eb jaxca ti' tet naj: —Tzalaan jaach sreyal eb Israel, ẍi eb tet Jesús. Chi lawi tu', catu' jix mak'le naj yu eb. Jix yun masanil wan ti' yin naj yu chi buchwa eb yin. ");
INSERT INTO knjNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Catu' jix el pax toj Pilato sti' sdespacho bey ey ec' eb yaawil ye bey Judea tu'. Jix yalon pax eltej snan xol eb jaxca ti': —Ila, tol chi wi' eltej je yila. Catu' che yotajnen el oj, tol c'am nioj smul chi wil an, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Catu' jix eltej Jesús tu' sti' despacho tu'. Ey atoj jun q'uix tu' scorona oj yu eb. Ey oc an morado pichile tu' yu, jix yalon eltej Pilato snan xol eb jaxca ti': —Ila naj ti', ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ja' yet jix yilon eb yaawil yak'omal xaambal eb Israel tet Dios, yetoj c'al eb policía, tol chi elol sti' tu', jix a bulna eb yalon yin ipal jaxca ti': —A ojab locan yin culus. A ojab locan yin culus, ẍi eb. Catu' jix yalon Pilato tu' tet eb jaxca ti': —Yel watx' che yi'toj jaexti', catu' che locban a yin culus tu' je txojli. Jal jin an xin, c'am nioj smul chi wil an, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero jix yal pax eb tet naj jaxca ti': —Jaonti' ey cu ley, catu' ja'ta'c'ala' yalon cu ley tu', tol smoo chi cami, yutol jix yal oc sba Sc'aal oj Dios, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ja' yet jix yaben Pilato tu' jaxca tu', caw jix xiw a oj. ");
INSERT INTO knjNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yu jun tu' jix pax oc yul sdespacho tu' junel xa. Catu' jix sk'anlen el tet Jesús tu' jaxca ti': —¿Beytu' ta titnaj jaach xin? ẍi naj tet Jesús. Pero ma tak'woj Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yu jun tu', yuxan jix yal naj tet Jesús jaxca ti': —¿Tzet yuxan c'am chach tak'wi e in an? ¿Tumi man ja wotaj oj, tol ey wipal jaach jin locban a yin culus, catu' ey pax wipal jaach jin jajon el oj? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yuxan jix yal Jesús tet naj jaxca ti': —Yutol ja' Dios jix ak'on ja wopiso ti', ta c'amaj, caw c'am nioj ja walon ja wet win an. Yu jun tu', yuxan, ja' jun jix jin aon oc yul ja k'ab ti' an, ec'ban smul jun tu' ja wintaj, ẍi Jesús tu' tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ja' yet jix yaben jaxca tu' xin, jix sna'on naj tu', tzet utbil chi yute sjajon el Jesús tu'. Pero ja' eb yaawil ye bey Judea tu', jix a c'al bulna eb yalon yin ipal jaxca ti': —Ta cha jaj el oj, ac'ul jaach yin naj yaaw bey Roma, ch'al tu'. Ja' jun ti' jix yal oc sba reyal. Pero yal c'al mac chi alon jaxca tu', ac'ul oc yin naj yaaw bey Roma tu', ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ja' yet jix yaben naj jaxca tu', jix yak'on i'le eltej Jesús tu' yu bey ey ec' tu', catu' jix ey chotan bey chi na'le oc smul eb ánima tu'. Ja' jun lugar tu', Gabata sbi yin hebreo, sti' eb Israel. Chi yal yel oc apnoj, latz'bil ey ch'en. ");
INSERT INTO knjNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ja' yet jix ey chotan naj tu', tuxa chi oc chuman c'u. T'inan xa yoc sk'in pascua. Catu' jix yalon eltej snan xol eb a Judea tu' jaxca ti': —Il ton ab naj je reyal ti', ẍi eltej naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero jix a pax yaw eb yin ipal junel xa jaxca ti': —Cam ojabi, Cam ojabi. A ojab locan yin culus, ẍi eb. —¿Tumi oj jin locba a je reyal ti' yin culus, ch'al tu'? ẍi naj tet eb. Catu' jix tak'witoj eb yaawil yak'omal xaambal eb tet Dios jaxca ti': —Jaonti', asan naj yaaw bey Roma ey oc cu yaawil oj. C'am junoj xa, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","T'ey xin, jix ale oc Jesús tu' yul sk'ab eb, yu sto slocban a eb yin culus. Yu jun tu' xin, yuxan jix yi'toj eb. ");
INSERT INTO knjNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ja' Jesús xin, jix sjolomxic'netoj sculusal. Catu' jix i'letoj bey jun lugar chi yij Gólgota yin hebreo, tol chi yal yel oc apnoj: “Sbajil Jolome”. ");
INSERT INTO knjNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ja' tu' jix yaoc Jesús eb yin culus. Ey cawan xa mac jix a pax locan yin culus yetoj naj, jun bey jun jun pac'. Yuxan ja' snan xol sculusal eb tu' jix a locan naj yin culus tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jix yak'on tz'ibele oc jayeb k'ane naj Pilato sjolomtaj sculusal Jesús, tol chi yal jaxca ti': “Ja' ton Jesús a Nazaret ti', Sreyal eb Israel,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sti' conob ey jun lugar bey jix bet a t'unan tu'. Yu jun tu', yuxan ec'al eb Israel jix ilon tzet ẍi jayeb k'ane ey oc sjolomtaj sculusal tu'. Tz'ibebil oc yin sti' eb, c'al yin sti' eb Griego, c'al yin latin, sti' eb a Roma. ");
INSERT INTO knjNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yu jun tu', yuxan jix yal eb yaawil yak'omal xaambal eb Israel tet Dios tu' tet Pilato jaxca ti': —Tol oj wal manaj “Sreyal eb Israel” tu' jix ja wak' tz'ibele oc sjolomtaj te' culus tu'. Yel watx' quey ti' oj ja wute ja tz'iben jaxca ti': “Ja' naj ti', jix yal oc sba naj sreyal eb Israel,” ta ja chi, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ja' jayeb k'ane jix wak' tz'ibele oc ti', can ojab jaxca tu', ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jix lawi st'unban a Jesús eb soldado tu' xin, catu' jix yi'on a spichil eb tu'. Jix spo'on ec' eb. Caneb jix el oc an yu eb, yuxan jun jun c'al liman yet jun jun eb. Pero an pichile chi ya c'al ta' oc xin, junne c'al ye an, c'am bey tz'isbil. ");
INSERT INTO knjNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yu jun tu', yuxan jix yal eb jaxca ti': —Ja' jun ti' xin, manchej cu nic'toj an catu' chi cu po'on ec' an kin. Yel watx' chi kaoc suerte yin an, yal c'al mac ey suerte yi'oni, ẍi eb. Jaxca ton ti' jix yun yunen el tzet tz'ibebil can yul An Juun, bey chi yal jaxca ti': “Oj spo' ec' jin pichil eb yin, catu' oj yak'on suerte eb yin jun xa,” ẍi can yul An Juun tu'. Yu jun tu', yuxan quey tu' jix yute eb soldado tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ja' scawilal bey t'unan a Jesús tu', ey ec' xutx. Ey jun sno ix ec' yetoj, yetoj pax María, yistil Cleofas, c'al ix María Magdalena. ");
INSERT INTO knjNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ey pax jun scuywom Jesús ey ec' sc'atan xutx tu', jun scuywom caw cam c'ulnebil yu. Jix tit t'anan Jesús yin eb, catu' jix yalon tet xutx tu' jaxca ti': —Chicay, ja' jun ey ec' ja wetoj ti', jaxca ja wune' chi yun can oc oj, ẍi Jesús tet xutx. ");
INSERT INTO knjNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Catu' jix yalon tet jun scuywom tu' jaxca ti': —Ja' jin txutx ti', jaxca ojab ja txutx cha wute ja c'ul yin, ẍi Jesús tet naj. Yu jun tu' xin, yuxan ja' jun scuywom tu', ja' jix i'on can toj ix xutx Jesús tu' yetoj bey sna, catu' jix ey ec' ix yintaj. ");
INSERT INTO knjNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jix lawi tu' xin, yotaj xa Jesús, tol jix yun masanil tzet tz'ibebil can yin, yuxan jix yal jaxca ti': —Caw chi taj jin ti', ẍi Jesús. Jix yal jaxca tu', yu yunen el tzet tz'ibebil can yul An Juun Tz'ibebil can oj. ");
INSERT INTO knjNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ey jun vaso vinagre ey ec' titu', jix slaba eytoj jun chi sococqui eb xol. Ja' jix yaoc eb ẍumuc jun te' hisopo tu', jix yaon atoj eb yin sti' Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jix lawi tu', jix tz'uben el oj, catu' jix yalon jaxca ti': —Jix yi' sba masanil, ẍi Jesús. Jix lawi tu' xin, catu' jix ey nona oj catu' jix yak'on spixan yul sk'ab Dios, catu' jix cami. ");
INSERT INTO knjNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yecal oj xa c'al k'in pascua yet jun c'u tu', sc'ual xa xewilal pax oj. Ja' eb yaawil ye bey Judea, c'am chi yoche eb chi can smimanil eb yin culus tu'. Yutol ja' jun xa c'u lalan xa sjul tu', caw miman yel oc apnoj yul sat eb Israel. Yu jun tu', yuxan jix to eb sk'an favor tet Pilato, ta chi yak' mak'le po' sbajil spenec eb, yet watx' eyman chi eytej smimanil eb yin culus tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yu jun tu', yuxan jix to eb soldado bey t'unan a eb tu', catu' jix mak'le po' sbajil spenec eb t'unan a yetoj Jesús tu' yu eb. ");
INSERT INTO knjNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero ja' yet jix apni eb yin Jesús xin, jix yilon eb, tol camnaj xa. Yuxan ma xa mak'le po' sbajil spenec naj yu eb. ");
INSERT INTO knjNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero ey jun soldado jix tejon atoj slanza yin smotx Jesús. Eyman jix eltej chic' c'al ja'. ");
INSERT INTO knjNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jain Juan jin ti', caw jix wil wan ti'. Yu jun tu', yuxan chi wak' jin ba testigoal yin, yet watx' che yaoc yin je c'ul jaexti'. Ja' wan tzet chin tz'ibe can ti', caw yel. Jainti', wotaj, tol caw yel chi wal an. ");
INSERT INTO knjNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yu yunen el tzet tz'ibebil can yul An Juun, yuxan quey tu' jix yune', yutol chi yal yul An jaxca ti': “C'am junoj sbajil oj smak' po' eb,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Chi yalon pax jun xa ti' yul An Juun tu': “Ja eb jix tejon naj, oj yil oc eb yin,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ey jun winaj chi yij José, a conob Arimatea. Ja' jun winaj tu', scuywom Jesús, asan tol scuywom yin ewantajil, yutol caw chi xiwi, ta chi yab eb yaawil ye bey Judea. Ja' jix jul k'anon eytej smimanil Jesús yin culus tet naj Pilato, yet watx' chi smuj octoj. Jix ak'le tet yu Pilato tu', yuxan jix bet yi' eytej, catu' jix yi'ontoj. ");
INSERT INTO knjNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Jix apni pax Nicodemo titu', jix yi'tej oxeb arroba wan suk'uk'i sab chi yij mirra, calbil yetoj jun xa chi yij áloes. Ja' jun Nicodemo ti', ja' ton betnaj ec' k'anab yetoj Jesús yet ak'balil. ");
INSERT INTO knjNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jix yi'on a smimanil Jesús eb tu'. Catu' jix spichon oc wan mimej k'ab eb yin, jix yaon pax oc wan suk'uk'i sab tu' eb yin. Yutol quey tu' yoc sbeybal eb Israel tu' yet chi smujon scamom eb. ");
INSERT INTO knjNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ja' scawilal bey jix a locan Jesús tu' yin culus, ey wan awbeal te'. Ja' xol tu', ja tu' ey jun ch'en jolbil yul. C'am to junoj camom chi ec' yul jun ch'en tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yutol junxane txolan catu' chi ẍa'on el yich sc'ual xewilal eb Israel, yu jun tu', yuxan ja' yul jun ch'en tu' jix bet ya can octoj smimanil Jesús eb, catu' yu pax tol scawilal bey jix cam tu' ey jun ch'en tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ja' yet ey to sajbi yet domingo xin, jix to María Magdalena bey ey octoj smimanil Jesús tu'. Jix yilon yet jix apni, tol elnaj xa smajil ch'en ch'en tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yu jun tu', yuxan jix yak' ani smeltzotej, catu' jix apni sc'atan Simón Pedro. Ey pax ec' jun scuywom cam c'ulnebil yetoj Pedro tu', jix yalon ix tet eb jaxca ti': —Jix i'le eltej smimanil naj Kaawil bey jix ale can octoj. ¿Bey mi tu' jix i'letoj? ẍi ix tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jix yab c'al Pedro yetoj jun xa cuywom tu' xin, jix to eb yilon bey ch'en ch'en tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ani sto eb scawanil. Pero jix can can Pedro tu' yu jun xa tu', yuxan ja' jun xa cuywom tu' jix babi apni bey jun jolan tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jix octoj t'anan yul ch'en ch'en tu'. Jix yiloni, asanxane an k'ap jix pixle oc yin, lanan can ey oj. Ma octoj jun cuywom tu' yul ch'en. ");
INSERT INTO knjNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tzajan yapni Simón Pedro tu' yintaj. Jix apni c'al oc oj, jix octoj yul ch'en ch'en tu'. Ja' jix iloni, asanxane an k'ap tu' lanan can ey oj, ");
INSERT INTO knjNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","c'al an tx'ambale jix oc pixan yin sjolom Jesús tu' chulan can ey an, catu' naat ta c'otan can toj an. ");
INSERT INTO knjNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jix lawi tu', jix octoj jun xa cuywom jix babi apni oc tu'. Ja' to yet jix yilon jaxca tu', jix yaon oc yin sc'ul. ");
INSERT INTO knjNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","C'am to chi yaoc eb yin sc'ul, tol yel jix pitzc'u a Jesús. Yutol c'am chi na'cha el yu eb, tzet tz'ibebil can yul An Juun Tz'ibebil can oj, tzet utbil tol oj pitzc'u pax a Jesús xol eb camnaj. ");
INSERT INTO knjNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jix lawi yilon eb tu' xin, jix pax eb bey sna. ");
INSERT INTO knjNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Jal pax María Magdalena tu' xin, jix can can sc'atan jun ch'en tu'. Ma octoj ix yul ch'en. Tu' c'al jix octoj t'anan ix yul, catu' jix ok' a ix. ");
INSERT INTO knjNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Catu' jix yilon ix, ey octoj cawan ángel yul ch'en tu'. Caw saj spichil eb. Chotan ey eb bey jix ec'le smimanil Jesús tu', jun bey sjolomtaj, jun xa bey yajantaj. ");
INSERT INTO knjNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Catu' jix sk'anlen eltej eb tet ix jaxca ti': —Jaach ix, ¿tzet yuxan chach ok'i? ẍi eltej eb. —Chin ok'i, yutol jix i'letej smimanil naj Waawil titi'. ¿Bey mi tu' jix i'letoj? ẍi ix tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ja' to yet jix lawi yalon ix jaxca tu', jix meltzotoj t'anan ix yintaj. Catu' jix yilontej ix, tol ey ec' Jesús. Pero man yotaj oj ix, ta tol ja' naj. ");
INSERT INTO knjNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yuxan jix sk'anle el tet ix jaxca ti': —Jaach ix, ¿tzet yuxan chach ok'i? ¿Mac cha sey ec' oj? ẍi Jesús tet ix. Ja' sna'on ix, tol ja' naj ilom awbeal te' linan ec' titu'. Yuxan jix yal ix tet naj jaxca ti': —Jaach winaj, ta jaach jix jul ja wi' eltej smimanil Jesús tu', al e in an, bey jix bet ja wak' can oj, catu' chin to wi'on an, ẍi ix tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—María, ẍi Jesús tu' tet ix. Yu jun tu', yuxan jix meltzotoj t'anan ix yin naj. Jix sk'anab a ix yin hebreo tu' jaxca ti': —Raboni, ẍi ix. Chi yal yel oc apnoj, Cuywam. ");
INSERT INTO knjNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Catu' jix yalon Jesús tet ix jaxca ti': —Manchej jin ja mitx'a, yutol c'am to chin atoj bey ey ec' jin Mam. Pero asi', al tet eb wuẍtaj, c'al tet eb wanab masanil, tzet utbil tol oj jin pax a bey ey ec' jin Mam. Ja' jin Mam tu', je Mam pax wetoj an. Ja' jin Diosal tu', je Diosal pax wetoj an, ẍi Jesús tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yu jun tu', ja' María Magdalena tu', jix to yal tet eb scuywom Jesús tu' jaxca ti': —Caw jix wil yin naj Kaawil, ẍi ix tet eb. Catu' jix yalon pax ix tet eb tzet jix al-le yu naj tet ix. ");
INSERT INTO knjNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ja' c'al oc yet jun domingoal tu' yet k'ejbintajil, jix syamba sba eb scuywom Jesús. Caw canani ye smajil jun na bey yaman ec' eb tu' yu xiw c'ulalil eb tet eb yaawil ye bey Judea. Catu' jix yilontej eb, linan xa oc Jesús snan xol eb, catu' jix yalon tet eb jaxca ti': —Ey ojab watx' c'ulal snan je xol, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Catu' jix x'oxon yul sk'ab tet eb tu', c'al smotx bey jix to ch'en lanza. Ja' yet jix yilon eb scuywom tol ja' naj Kaawil, caw jix tzala a eb sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Catu' jix yalon naj tet eb junel xa jaxca ti': —Ey ojab watx' c'ulal snan je xol. Jaxca jix yun jin ẍejontej cu Mam Dios, quey tu' chi yun jex jin chejon pax toj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jix lawi yalon wan ti', catu' jix xuontoj ska'e' yiban eb tu'. Catu' jix yalon naj jaxca ti': —Cha' wej can naj Santo Espíritu. ");
INSERT INTO knjNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ta ey mac che yak' miman c'ulal yin spenail, oj yak' pax Dios miman c'ulal yiban eb. Ta ey mac c'am che yak' miman c'ulal yin spenail xin, oj can c'al ta' spenail eb tu' yiban, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ey jun yetbi eb scuywom Jesús chi yij Tomás, chi yij pax Tioẍ. C'am naj ey ec' yetoj eb yet jix il-le yin Jesús yu eb. ");
INSERT INTO knjNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yu jun tu', yuxan jix yal eb yet cuywomal tu' tet naj jaxca ti': —Jaonti', jix kil yin naj Kaawil, ẍi eb tet naj. —Ta c'am chi wil yechel ch'en lawuẍ yul sk'ab, catu' c'am chin jejtoj yiximal jin k'ab yul sjolanil ch'en tu', c'al jin jejontoj jin k'ab bey smotx ma waoc yin jin c'ul, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Waxajeb xa c'ual tu', catu' jix syamban pax oc sba eb junel xa bey yul jun na tu'. Ey ec' naj Tomás tu' yetoj eb yet tu'. Caw canani ye smajil jun na tu', pero jix yilontej eb, linan xa oc Jesús snan xol eb, catu' jix yalon tet eb jaxca ti': —Ey ojab watx' c'ulal snan je xol, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Catu' jix yalon tet naj Tomás tu' jaxca ti': —Il jin k'ab ti' an. Jejtoj yiximal ja k'ab yul sjolanil ti'. Catu' cha jejontoj pax ja k'ab bey sjolanil jin motx ti'. Manchej ja wak' caab c'ulal, pero aoc ja c'ul win an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Jix yalon Tomás tu' tet Jesús jaxca ti': —Jaach Waawil, jaach jin Diosal, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Catu' jix yalon Jesús tu' tet naj jaxca ti': —Tomás, jix ja waoc ja c'ul win an, yutol jix jin ja wil an. Ja' eb c'am chin ilon an, catu' chi yaon oc sc'ul eb win, yel xa c'al watx' yet eb, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ec'al to c'al milagro jix el yunen Jesús sattaj eb scuywom tu', pero ma tz'ibele can sk'aneal masanil yul jun libro ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Jix tz'ibele can wan ti', yet watx' che yaoc yin je c'ul, tol ja' Jesús naj Sc'aal Dios, ja' ton Cristo. Ta quey tu' oj je yute je yaon oc yin je c'ul, oj je cha' je k'inal tol ey c'al yin tobal k'inal tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jix lawi tu' xin, jix x'oxon a sba Jesús tet eb scuywom junel xa tu', yet ey ec' eb sti' ja' mar Tiberias. Tol jaxca ti' jix yun x'oxon a sba tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Junne c'al ey ec' Simón Pedro yetoj Tomás, naj chi yij Tioẍ, c'al Natanael a Caná yul yet Galilea. Ey pax ec' eb sc'aal Zebedeo, yetoj cawan xa yet cuywomal eb. ");
INSERT INTO knjNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Jix yalon Simón Pedro tet eb jaxca ti': —Toj jin mitx'o pescado, ẍi naj tet eb. —Oj jon toj ja wetoj, ẍi eb tet naj. Catu' jix to eb tu'. Jix oc eb yul jun barco. Pero ja' yet jun ak'bal tu', c'am junoj no' pescado jix yi' eb. ");
INSERT INTO knjNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ja' yet lalan xa sajbi, ey ec' Jesús sti' ja' mar tu'. Pero eb cuywom, c'am c'al chi yiltej eb ta ja' naj ey ec' sti' ja' tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jix yalon tet eb jaxca ti': —Jex wuẍtaj, ¿ey xam no' chi atej je yu? ẍi toj tet eb. —C'am tzet, c'am c'al junoj, ẍi eb tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—K'oj wej eytoj je txim bey je watx' k'ab. Ja' tu' oj je yi' je pescado tu', ẍi Jesús tet eb. Jix sjije eb tzet jix yal Jesús tu'. Ja' yet jix yak'len stok'on atej xim eb tu' xin, ma xa atej yu yalil no' pescado tu', yutol caw jix no sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Catu' jix yalon jun scuywom cam c'ulnebil yu Jesús tet Pedro jaxca ti': —Ja' naj Kaawil ey ec' ti', ẍi naj tet Pedro. Jix yab c'al Simón Pedro jaxca tu', jix yaon oc spichil tu', yutol asan c'al yet yul spichil ey oc oj. Catu' jix k'ojon el sba naj yul barco tu', catu' jix el sti' ja'. ");
INSERT INTO knjNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Caneb jix tom tx'anil chi bey eb yiban ja', catu' jix apni wan xa eb scuywom yul jun te' yali' barco tu'. Tok'bil oc xim eb, nonaj yu no' pescado tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Catu' jix eltej eb, jix yilon eb, tol ey jun k'ak' ey oc sti' ja' tu'. Batxan oc jun pescado yiban tzak'ak', catu' ey pax ey wan pan scawilal tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jix yalon Jesús tet eb jaxca ti': —I' wej tej jayc'on oj no pescado jix je mitx' tu', ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jix octoj Simón Pedro yul barco tu'. Jix tok'on el tx'an txim tu' sti' el ja'. Nonaj tx'an yu mimej pescado. Ciento cincuenta y tres no' yin masanil. Caw miman no' pero ma nic'chatoj tx'an txim tu' yu yalil no'. ");
INSERT INTO knjNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jix lawi tu' xin, jix yalon Jesús tu' tet eb jaxca ti': —Sebax wej low oj jon nej, ẍi Jesús tet eb. C'am junoj eb scuywom tu' jix k'anlen el tet naj jaxca ti': ¿Mac jaach txequel xin? Man ẍi oj eb, yutol yotaj xa eb, tol ja' naj Kaawil. ");
INSERT INTO knjNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Catu' jix sjitzontej sba Jesús sc'atan eb tu'. Catu' jix yi'on a ixim pan tu', jix c'oli spo'on ec' xol eb, catu' jix spo'on pax ec' no' pescado tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yet xa yoxelal jix x'oxon a sba Jesús tet eb scuywom ti', yet tax c'al jix pitzc'u a xol eb camnaj. ");
INSERT INTO knjNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jaxa yet jix lawi slow eb, jix yalon Jesús tet Simón Pedro jaxca ti': —Simón, sc'aal naj Jonás, chin k'anle e ach an, ¿yel xa c'al mi chin ja cam c'ulne yintaj wan ti'? ẍi Jesús tet naj. —Ja' ton Wuẍtaj. Ja wotaj xa, tol chach jin cam c'ulne, ẍi Pedro tu' tet naj. —Ta jaxca tu' xin, jaxca ojab junoj ilom yune' me', quey ojab tu' cha wute ja wilon eb wet xa an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jix lawi yalon wan ti', jix yalon junel xa jaxca ti' tet naj: —Simón, sc'aal naj Jonás. ¿Chim jin ja cam c'ulne? ẍi Jesús tet naj. —Ja' ton Wuẍtaj. Ja wotaj xa, tol chach jin cam c'ulne, ẍi Pedro tet Jesús. —Ta jaxca tu' xin, jaxca ojab junoj ilom me' quey ojab tu' cha wute ja wak'on cuenta eb wet xa an, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jix yalon pax yet yoxelal jaxca ti': —Simón, sc'aal naj Jonás, ¿Chim jin ja cam c'ulne? ẍi Jesús tet naj. Jix cus a sc'ul naj Pedro tu' bian, yutol yoxel xa c'al chi sk'anle Jesús tu' tet naj, ta chi cam el sc'ul yin Jesús tu', yuxan jix yal naj tet Jesús jaxca ti': —Wuẍtaj, ja wotaj xa ta' masanil. Ja wotaj tol chach jin cam c'ulne an, ẍi Pedro tet Jesús. —Ta jaxca ja walon tu', jaxca ojab junoj ilom me', jaxca ojab tu' cha wute ja wilon eb wet xa ye an. ");
INSERT INTO knjNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Caw yel chi wal e ach an, ja' yet ach'e jaach to, asan c'al cha waoc ja pichil catu' chach to c'al bey chi yal ja c'ul chach toi. Pero ja' yet oj jaach ichamboj, oj el jenan ja k'ab, catu' tx'oj xa mac oj c'alon ja nan, catu' oj jaach i'letoj bey c'am chi yal ja c'ul, ẍi Jesús tet naj. ");
INSERT INTO knjNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jix yal jaxca ti', yu tzet utbil oj yun scam Pedro tu', catu' oj x'oxon el oj tol caw miman yel oc apnoj Dios. Jix lawi tu', catu' jix yalon pax tet naj jaxca ti': —Ocan tzajan wintaj an, ẍi Jesús tet Pedro. ");
INSERT INTO knjNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Catu' jix to t'anan Pedro tu' yintaj, jix yiloni, tol ja' jun cuywom cam c'ulnebil yu Jesús tzajan oc yintaj eb. Jun jix sjitz oc sba sc'atan Jesús yet lalan slow eb yet junel, catu' jix sk'anlen el tet jaxca ti': “Wuẍtaj, ¿mac txequel oj jaach aon oc yul sk'ab camich?” ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ja' yet jix yilon Pedro jaxca ti', jix sk'anlen tet Jesús jaxca ti': —Wuẍtaj, ja' jun chi jul ti', ¿tzet oj yun pax scami? ẍi naj tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Catu' jix yalon Jesús tet naj jaxca ti': —Ta chi yal jin c'ul tol iquis to c'al jun ti', yet oj jin jul junel xa, c'am ja walon ja wet yin. Asan tol chach tzajlo wintaj jaachti' an, ẍi Jesús tet Pedro tu'. ");
INSERT INTO knjNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yu jun tu', jix el sk'umal xol eb creyente tol man oj cam jun cuywom tu'. Pero c'am tzet jix yal Jesús tu', ta man oj cam oj. Asan jix yal naj jaxca ti': “Ta chi yal jin c'ul iquis to c'al, yet oj jin jul junel xa, c'am ja walon ja wet yin,” ẍi. ");
INSERT INTO knjNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ja' ton jun scuywom ti' chi yak' sba testigoal yin wan ti', catu' jix tz'iben pax can oj. Jaonti', kotaj, tol caw yel wan jix tz'ibe can ti'. ");
INSERT INTO knjNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Miman to c'al wan xa tzet yetal jix el yunen Jesús. K'inaloj ta jun junal jix yun tz'ibele can sk'aneal, ja' chi wute jin na'oni, c'am chi yab yul yiban k'inal ti', bey chi ey an juun bey jix tz'ibele can sk'aneal tu'.");
INSERT INTO knjNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Wuẍtaj Teófilo, ja' yul jun an babel juun jix jin tz'ibetoj e ach an, jix waltoj jantaj tzet jix el yunen Jesús, c'al jantaj tzet jix yun scuywa tet eb ánima yet tax c'al jix ẍa'on el yich scuywai, ");
INSERT INTO knjNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","masanta' c'al jix jul sc'ual spax a satcan. Ja' yet c'am to chi pax a oj, jix yalon can wan xa chejbanil tet eb ẍejab, eb sic'bil el yu. Quey tu' jix yun yu naj Santo Espíritu. ");
INSERT INTO knjNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ja' yet jix ec'le yin camich, ec'al el to c'al jix x'ox sba tet eb ẍejab tu'. Cawinaj to c'u jix x'ox sba tet eb, tzet utbil tol caw yel jix pitzc'u a oj. Jix k'anab yetoj eb yin tzet utbil tol ja' Dios oj oc can yin Yaawil oj. ");
INSERT INTO knjNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ja' yet ey to ec' yetoj eb ẍejab tu', jix yalon tet eb jaxca ti': —Canan nej bey conob Jerusalén ti'. Echbane wej jun albil can e ex yu Dios, yet jix yak'on can sti', jaxca jix wute walon e ex an. ");
INSERT INTO knjNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yel toni, ja' naj Juan jix ak'wi bautizar yetoj ja', pero jayebxane c'u, catu' oj ak'le naj Santo Espíritu e ex, catu' jaxca tol oj jex ak'le bautizar yetoj, ẍi Jesús tet eb ẍejab. ");
INSERT INTO knjNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ja' yet ey to c'al ec' Jesús yetoj eb ẍejab, jix sk'anlen el eb tet jaxca ti': —Wuẍtaj, ¿jam tinani', oj ja col eb ket conob Israel, yet watx' junel xa chi kaoc kaawil yul ket? ẍi eb tet Jesús. ");
INSERT INTO knjNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jix yalon naj tet eb jaxca ti': —Ma ak'le je yotajne el sc'ual c'al stiempoal. Yutol ja' jun tiempoal tu', asan cu Mam Dios ey yalon yet yin bak'in oj oc jun yaawil tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero oj yak' yipal Dios e ex, yet oj je cha'on Santo Espíritu jun jun ex. Oj lawoj jun tu', catu' oj je yalon el jin k'aneal bey Jerusalén ti', yetoj bey masanil lugar Judea ti', c'al yul-laj yet Samaria, masanta' c'al bey chi lawi can apnoj yul yiban k'inal ti', oj je yal el oj, ẍi Jesús tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ja' yet jix lawi yalon Jesús wan ti', catu' jix i'le atoj satcan. Jix atoj t'anan eb yin, catu' jix q'uey to xol jun asun. Ma xa yil yin naj eb. ");
INSERT INTO knjNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ja' yet t'anan atoj eb satcan yet jix pax a Jesús tu', catu' jix yilon eb, linan xa oc cawan winaj sc'atan eb. Saj wejinaj xa c'al yili spichil eb. ");
INSERT INTO knjNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Jix yalon eb cawan tu' jaxca ti': —Jex a Galileail winaj, ¿tzet yuxan t'anan jex c'al atoj satcan? Ja' Jesús ti', jix i'le a je xol, catu' jix pax a satcan. Jaxca jix yun je yilon sto ti', quey tu' oj yun sjul pax oj, ẍi eb tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jix lawi c'al tu' xin, jix pax eytej eb scuywom tu' bey wonan Olivo tu'. Catu' jix meltzotej eb bey Jerusalén. Ja' jun wonan tu', ey mi snan oj legua xol yetoj Jerusalén. ");
INSERT INTO knjNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ja' yet jix apni eb yul conob tu', jix atoj eb yul can bey jun cuarto bey ey sposada Pedro, yetoj Jacobo, Juan, Andrés, c'al Felipe, Tomás, Bartolomé, Mateo, Jacobo yuninal naj Alfeo, yetoj Simón yetbi c'al el sba yetoj eb cananista yet yalantoj, ja' pax jun Judas yuẍtaj Jacobo. Ja' titu', junne ey sposada eb masanil. ");
INSERT INTO knjNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jun jun c'al c'u jix syamban sba eb masanil yu chi txali eb tet Dios. Ey eb ix chi txali yetoj eb. Ey ec' ix María yetoj eb, ix xutx naj Jesús. Ey pax ec' eb yuẍtaj Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ja' yet jun tiempoal tu', ey mi junoj ciento veinte eb creyente yaman oc oj. Catu' jix a linan naj Pedro snan xol eb, catu' jix yalon jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Jex wuẍtaj, jex wanab, sowalil ton jix yun tzet albil can yul An Juun Tz'ibebil can oj. Yutol ja' naj Santo Espíritu jix ak'on can s'ibe naj David yin naj Judas, ja' naj tx'oxwawom tet eb mitx'wawom yin Jesús. ");
INSERT INTO knjNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ja' naj Judas tu', ey oc cu tz'ajil oj yet yalantoj, junne kopiso yetoj. ");
INSERT INTO knjNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero jix ẍa' stumin yin jun tzet yetal pena jix el yuneni. Catu' jix smanon jun tx'otx' yetoj ch'en tumin tu'. Jix lawi tu' xin, jix tit q'uey pitxna oj. Catu' jix eltej secna yul sc'ul tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ja' eb a Jerusalén ti', masanil eb jix yab sk'umal jun ti'. Yuxan, jix yak' yij sbi jun tx'otx' eb tu' Acéldama yin sti' eb. Ja' chi yal yel oc apnoj, “X'otx'al Ẍiq'uil Ánima.” ");
INSERT INTO knjNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jaxca tu' jix yune', yutol chi yal jaxca ti' yul an Libro chi yij Salmos: Can ojab sna yin cusiltaj. C'am ojab mac chi ke ey titu', ẍi. Chi yalon pax jaxca ti': Oc ojab junoj xa mac txequel sq'uexel oj yin yopiso, ẍi yul An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Yuxan, sowalil chi cu sic' junoj mac chi oc sq'uexel oj naj. Catu' chi kaon oc yopiso yalon el oj tol yel jix pitzc'u a Jesús. Ja' jun mac txequel oj cu sic' el tu', sowalil ja' junoj ketbi c'al ta' cu ba yetoj, yet jix cu ec' yetoj naj Kaawil Jesús. Ja' jun mac txequel tu', ja' junoj ja' c'al jun ketoj yet tax c'al jix ak'le bautizar Jesús yu naj Juan, masanta' c'al jix i'le pax a satcan, ẍi naj Pedro tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yuxan ey cawan winaj jix satne oc eb, ja' ton Matías yetoj José jun chi yij pax Barsabás ma Justo. ");
INSERT INTO knjNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jix lawi jun tu', catu' jix txali eb masanil, jix yal eb yin xa tu' jaxca ti': —Mamin, ja wotaj xa tzet utbil yili cu na'bal cu masanil on. Yuxan, tx'ox e on, mac junoj oj ja sic' el xol cawan ti', ");
INSERT INTO knjNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","yet watx' chi oc yopiso, catu' chi oc ẍejab oj Jesucristo. Yutol jix i'le el Judas yin yopiso yu spenail. Catu' jix to can bey jun lugar bey smoo stoi, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jix lawi jun tu', catu' jix ale oc puesto yin eb scawanil. Jix txeclo eltej yu jun puesto tu', tol jix can yin naj Matías. Catu' jix oc can s'ajil oj eb jusluc'wan ẍejab Jesucristo tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ja' yet jix eyol sc'ual k'in Pentecostés junne jix syamba sba eb creyente masanil. ");
INSERT INTO knjNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Eyman jix yab yel yaw jun tzet yetal eb bey satcan, jaxca junoj ka'e' caw jow yeq'ui. Jix no el yul jun na bey yaman ec' eb tu' yu jun jaxca ka'e' tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ey wan tzet yetal jix yil eb jaxca xaj k'ak' jix pujtoj xol eb masanil. Catu' jix ey q'uey yiban jun jun eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jix jul oc Santo Espíritu tu' yin eb, jix k'anab eb yin wan tx'oj ti'eal, ja'ta'c'ala' tzet jix ak'le yal eb yu Santo Espíritu tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ja' yet jun tiempoal tu', ey eb Israel ey ec' bey Jerusalén tu', tx'oj tx'oj c'al lugaril bey jix tit eb yul yiban k'inal ti'. Ja' ton tet Dios chi yi' ey sba eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yet jix able tzet jix yun tu', ec'al ánima jix yamcha oc bey jun na tu'. Caw jix q'uey a sc'ul eb, yutol jix yable a eb tzet chi yal yin sti'. Ja' eb creyente tu', jix k'anab a eb yin sti' jun jun conobal. ");
INSERT INTO knjNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Caw jix q'uey a sc'ul eb. Jix oc t'anan eb, catu' jix yalon eb jaxca ti': —Ja' eb chi k'anab ti', a Galilea eb masanil. ");
INSERT INTO knjNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pero, ¿tzet yuxan chi kab pax tzet chi yal eb? Tol tx'oj tx'oj yel pax cu ti' jun jun jon. ");
INSERT INTO knjNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ja' cu xol ti', ey eb a Partia ey ec' oj. Ey eb a Media, ey eb a Elam, ey eb a Mesopotamia, ey eb a Judea, ey eb a Capadocia, ey eb a Ponto, c'al eb a Asia, ");
INSERT INTO knjNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ey eb a Frigia, c'al eb a Panfilia, c'al eb a Egipto. Ey pax eb a yul-laj yet Africa, bey scawilal Cirene. Ey pax wan eb a Roma titi'. Ey eb ket Israelal. Catu' ey pax eb man Israel oj, pero ocnaj xa eb yin cu cuybanil. ");
INSERT INTO knjNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ey mac xin, a Creta, yetoj eb a Arabia. Cu masanil c'al chi kab yalon wan ánima ti' cu ti' yin jun jun conobal. Chi yaltej eb masanil tzet jix el yunen Dios yetoj yipal, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tu' c'al jix q'uey a sc'ul masanil eb. Jix somcha el sc'ul eb, jix yalon eb jaxca ti': —¿Tzet la ye wan ti'? ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero ey wan xa eb xin, tol chi buchwa eb, catu' jix yalon eb jaxca ti': —Ja' wan eb ti', uq'uem an eb, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yuxan, jix a linan naj Pedro yetoj eb jusluc'wan yet chejabwomal. Jix k'anab snan xol eb conob yin ip jaxca ti': —Jaex ket Israel, c'al jantaj jex ey jex ec' bey conob Jerusalén ti', tol chi wak' je yotajne el tzet ye jun ti'. Ak' wej je txiquin tet tzet oj wal e ex an. ");
INSERT INTO knjNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","¿Tumi che na' tol uq'uem an jon on? C'amaj. Ila, tol to chi aol c'u. ");
INSERT INTO knjNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ja' naj Joel, jun ẍejab Dios yet peyxa, yin ey oj to jix yalon can sk'aneal jun tzet chi kun ti' yul An Juun Tz'ibebil can oj, yet chi yal jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Jix yalon Dios jaxca ti': Ja' yet oj jul slawubal tiempoal, oj waoc Wespíritu yin masanil ánima. Catu' oj yalon el eb c'aale c'al eb cutz'ine jin k'ane. Catu' oj jin tx'ox wan tzet yetal tet eb ach'e, jaxca tol oj sweyichene eb. Catu' oj jin k'anab yin weyicheal tet eb icham winaj. ");
INSERT INTO knjNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ja' yet jun tiempoal tu', oj waoc Wespíritu yin masanil eb chin ak'on servil, yin eb winaj, c'al yin eb ix. Catu' oj yalon el jin k'ane eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Oj jin tx'ox wan tzet yetal bey satcan, oj q'uey a sc'ul ánima yiloni. Yetoj pax bey yul yiban k'inal ti', oj jin tx'ox pax wan xa tzet chi tx'oxon el wipal an. Ja' wan tu', chic', yetoj k'ak', c'al jun miman muc' jaxca asun. ");
INSERT INTO knjNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Oj oc k'ej k'inal yin sat c'u. Jaxa xaaw, caj xa c'al oj yun el jaxca chic'. Tol oj yun wan ti' xin, yet c'am to chi jul sc'ual jin julbal, jain je Yaawil jin ti' an. Ja' jun c'ual tu' caw miman yel oc apnoj, oj q'uey a sc'ul ánima yet tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Jal eb chi awten jin bi an, jain je Yaawil jin ti' an, oj colcha el eb masanil wu an, ẍi Dios yul An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Jex wet Israelal, ak' wej oc je txiquin yin wan xa oj wal e ex ti' an. Jix x'oxon el yopiso Jesucristo e ex yu Dios, yet jix el yunen wan milagro, wan tzet yetal c'am bey chi kila, yetoj wan xa tzet chi tx'oxon el yipal. Ja' ton wan ti', jix el yunen Dios yetoj Jesucristo. Je yotaj xa wan ti'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero ja' Jesús tu', jix ale oc yul je k'ab, yutol jaxca tu' jix el yin sc'ul Dios. Yotaj xa Dios yet tax peyxa, tzet oj jul yiban Jesús tu'. Jaexti', jix je maane sk'ab eb penawom, yet jix je yak'on mi'cha oj, catu' jix je locban a yin culus. Quey tu' jix je yute je yak'on cam oj. ");
INSERT INTO knjNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero jix ak'le pitzc'u a yu Dios. Jix yak' ganar Jesús tu' spitzc'u a oj yutol c'am yalon yet camich tu' yin. ");
INSERT INTO knjNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yutol ja' naj David, yalnaj can sk'aneal Jesús, tol oj pitzc'u c'al ta' a oj. Chi yal can jaxca ti': Tobal k'inal wotaj an, tol ey oc naj Waawil wetoj an. Ey c'al ec' naj jin c'atan an, yet watx' c'am chi somcha el jin c'ul an. ");
INSERT INTO knjNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yuxan, caw chi tzala jin c'ul an. Chin k'anab yin tzala c'ulal an. Cax c'al oj cam jin mimanil ti' an, pero oj jaach waoc yip oj jin c'ul an. ");
INSERT INTO knjNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yutol ma ja bej can jin pixan xol eb camnaj. Man oj ja cha' k'a'toj jin mimanil an, jain cam c'ulnebil jin el ja wu jaachti' an. ");
INSERT INTO knjNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Jix ja wak' wotajne el beybale chi cu i'ontoj bey k'inale tol ey c'al yin tobal k'inal. Caw chin ja wak' tzalaboj yutol chin ec' ja wetoj an, ẍi naj David yul An Juun Tz'ibebil can tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Jex wet conob, caw miman txequel, tzet elnaj apnoj yu kichmam David tu'. Kotaj tol camnaj, catu' mujinaj pax oj. Ja' smujbanil bey mujan tu' txequel to c'al ye tinani'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero ja' naj David tu', ak'bil yopiso yalon yin ey oj to tzettaj yetal oj jul oj. Yotaj, tol caw yel, tol yak'naj can sti' Dios tet, tzet utbil tol ja' Cristo t'inan oj el can yic'aal oj, catu' chi oc can reyal, sq'uexel oj David tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Yin ey oj to jix yotajnen el David tu', tzet oj el oc apnoj Cristo. Yuxan, yalnaj can oj tol t'inan oj pitzc'u a Cristo tu'. Yalnaj pax can oj tzet utbil tol man oj bejle can spixan yu Dios xol eb camnaj. Catu' man oj cha'le k'a'toj smimanil pax oj. ");
INSERT INTO knjNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ja' Jesús tu', ja' Dios jix pitzc'unen a oj. Cu masanil, chi kak' cu ba testigoal yin jun ti', yutol jix kila. ");
INSERT INTO knjNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yetoj pax oj, jix i'le pax a satcan yu yipal Dios. Jix yak' Santo Espíritu cu Mam Dios tet, jaxca ta' jix yute yalon can sti'. Ja' Jesús jix aontej jun che yil ti', c'al jun che yab ti'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ja' naj David, ma toj naj satcan yetoj smimanil yuxan jix yal jaxca ti': Jix yal Dios Kaawil tet naj Waawil jaxca ti': “Eyan chotan bey jin watx' k'ab an, ");
INSERT INTO knjNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","masanta' c'al oj can eb ja cajat ja walan wu an,” ẍi Dios, ẍi naj David tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ja' Jesús ti', jix je yak' locbale a yin culus. Pero chi woche che yotajne el sic'lebil je masanil jex wet Israelal, tol jix oc Kaawil oj yu Dios, ja' jix ak'le yopiso yin Cristoal, ẍi Pedro tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ja' yet jix yaben eb Israel jun ti', caw jix oc pitz'an sya'il yin sc'ul eb, jix yalon eb tet Pedro yetoj tet wan xa eb ẍejab Jesucristo jaxca ti': —Jex ket conob, ¿tzet watx' chi kun tinani' che na'? ẍi eb tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Yuxan jix yal naj Pedro tet eb jaxca ti': —Na' wej je ba, catu' che yak'on bautizar je ba jun jun jex yin sbi Jesucristo, yet watx' chi i'le can el je penail. Catu' oj scaban ec' Santo Espíritu je yin jun jun jex. ");
INSERT INTO knjNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yutol quey tu' jix yute yak'on can sti' e ex c'al e on, c'al tet eb je yuninal, yetoj masanil tet jantaj eb ey naatlaj. Yutol ja' naj Kaawil, cu Diosal, chi yak' Yespíritu tet masanil mac chi yawte oc naj yetoj, ẍi naj Pedro tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ec'al to c'al tzet yetal jix yal tet eb, c'al jix ak'on sna' sba sc'ul eb. —Col wej je ba tet jun sya'ilal oj jul yiban eb penawom ti', ẍi naj Pedro tu' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yuxan, ey eb jix yaoc yin sc'ul tzet jix yal naj Pedro tu' tet eb. Yuxan jix yak' bautizar sba eb. Ja' eb jix oc creyenteal yet jun c'ual tu', ey mi oxeb oj mil eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Caw jix yaoc sc'ul eb yin wan cuybanile jix yal eb ẍejab Jesús. Junxane jix yute sna'bal eb masanil. Chi syamba c'al sba eb. Chi slo'on ixim pan eb, ixim sna'baniltej naj Kaawil, catu' chi txali c'al eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ja' eb ẍejab Jesús, ec'al milagro jix el x'oxon eb, yu x'oxon el yipal Dios eb. Yuxan jix xiw a masanil eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Masanil eb jix yaoc sc'ul yin Cristo, junxane jix yun can eb. Junxane pax jix yute settaj yetal eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ey eb chi xon el x'otx', c'al wanoj xa tzet yetal ey tet eb. Catu' chi spo'on ec' stool tu' eb xol-laj eb, ja'ta'c'ala' tzet sowalil bey jun jun eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jun jun c'al c'u chi syamba sba eb yul stemplo Dios. Chi syamba pax sba eb bey yul-laj na, catu' chi spo'on ec' pan eb xol-laj. Junxane chi yun slow eb yin tzala c'ulal. Caw ey oc watx' c'ulal yin eb. ");
INSERT INTO knjNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Catu' chi yalon watx' k'ane eb tet Dios. Caw chi tzala masanil ánima yetoj eb. Jaxca c'al ti', jix yun yak'le ch'ib sbisil eb yu naj Kaawil jun jun c'u yu eb t'inan xa ta' chi colchai. ");
INSERT INTO knjNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ja' yet junel, yet yey c'ualil xa, yaman sto naj Pedro yetoj naj Juan bey stemplo Dios, yutol quey tu' yorail xali eb Israel tu' titu'. ");
INSERT INTO knjNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ey jun winaj c'am chi ske' sbeyi yin tax c'al ta' yalubal. Jun jun c'al c'u chi bet batxle can bey sti' jun spuertail stemplo Dios chi yij Sak'al Yili, catu' chi sk'anon stumin tet eb ánima chi bet ec' bey templo tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ja' yet jix yilon naj yapni Pedro yetoj Juan bey templo tu', yet lalan yoctoj eb, jix sk'anon stumin naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Catu' jix oc t'anan Pedro yetoj Juan tu' yin naj: —Ocan t'anan kin on, ẍi Pedro tet naj. ");
INSERT INTO knjNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ja' yet jix oc t'anan naj yin eb tu', ja' sna'on naj, tol oj ak'le nioj stumin naj yu eb, sna'oni. ");
INSERT INTO knjNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero jix yal naj Pedro tu' tet naj jaxca ti': —Jainti', c'am jin tumin. Pero ey jun tzet ey e in an, oj wak' e ach an. Yu yipal Jesucristo a Nazaret, aan linan oj, beyan, ẍi naj Pedro tet naj. ");
INSERT INTO knjNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Catu' jix oc mitx'an naj Pedro yin swatx' k'ab naj, jix oc yip snuk' yajan naj scaabil. ");
INSERT INTO knjNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jix a jucna naj, catu' jix a linan naj, jix ẍa'on el yich sbey naj, catu' jix octoj naj yul stemplo Dios tu' yetoj eb. Chi a julna oj, chi beyi, catu' chi yalon swatx' k'ane tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Jix yil masanil ánima ey ec' titu' sbey naj. Jix yab pax eb yalon swatx' k'ane naj tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Yuxan, caw jix q'uey a sc'ul eb sic'lebil yu tzet jix yun swa'xi naj, yutol yotaj eb, tol jun jun c'al c'u chi ey chotan naj sti' jun spuertail templo chi yij Sak'al Yili, ja' tu' chi sk'an stumin naj tet ánima. ");
INSERT INTO knjNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ja' naj jix wa'xi can yajan tu', tzajan xa c'al yec' naj yintaj Pedro c'al Juan. Jal masanil ánima xin, tuxa c'al jix q'uey can a sc'ul eb. Yuxan jix syamba sba eb, catu' jix apni eb sc'atan eb, yet ey ec' bey jun miman na c'am yichlaj bey stemplo Dios chi yij sbi yet Salomón tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ja' yet jix yilon naj Pedro jaxca tu', jix yalon tet eb jaxca ti': —Jex wet Israelal, ¿tzet yuxan caw chi q'uey a je c'ul yu jun ti? ¿Tzet yuxan chi q'uey a je c'ul kin? ¿Tumi che na' tol yul ket, ma yu cu watx'il, yuxan jix bey can a jun winaj ti'? ");
INSERT INTO knjNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ja' cu Diosal, ja' c'al ton oc Sdiosal kichmam Abraham, yetoj Isaac, c'al Jacob. Yu Dios tu', yuxan, miman yel oc apnoj Jesús Sc'aal. Pero jaexti', jix je yaoc yul sk'ab eb yaaw. Ja' naj Pilato jix yoche naj jix sjaj el oj. Jaex xa ma yal je c'ul. ");
INSERT INTO knjNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ja' Jesús tu', yet c'al Dios yei. Caw jichan sbeybal. Pero jaexti', ma yal je c'ul jix jajle el oj. Jal jun mak'om cam ánima jix je k'an jajcha oj. ");
INSERT INTO knjNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yuxan, quey tu' jix je yute je yak'on mak'le cam naj a k'inale. Pero jix pitzc'unele a naj yu Dios xol eb camnaj. Caw chi kak' cu ba testigoal yin jun ti'. ");
INSERT INTO knjNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ja' naj che yil ti', je yotaj xa ta' naj. Ja' Jesús jix ak'on wa'xoj naj, yutol ja' yin chi kaoc cu c'ul. Yuxan jix wa'xi naj je sattaj je masanil. ");
INSERT INTO knjNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ja' tinani' xin, jex wet conob, wotaj an, tzet yuxan jix je yak' cam naj Jesús tu', yutol man je yotaj oj tzet yetal lalan je yuneni. Ja'c'ala' pax eb yaaw, man yotaj oj eb. ");
INSERT INTO knjNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero jaxca ton ti' jix yun yunen el yu Dios tzet albil can yu eb ẍejab yin ey oj to. Yutol yalnaj can eb, tzet utbil tol ja' Cristo, sowalil chi yab sya'il. ");
INSERT INTO knjNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yuxan, na' wej je ba. Q'uex wej je beybal, a wej oc je na'bal yin Dios, yet watx' chi jo'le q'uey je penail. Yuxan, ta chi kute jaxca tu', ey jun tiempoal oj jul oj catu' oj yak'on cu tzala c'ulal Dios Kaawil, jaon Israel jon ti'. ");
INSERT INTO knjNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ja' oj chejon paxtej Jesús yet scaelal, ja' ton Cristo. Ja' ton naj sic'bil xa el yu Dios yet tax peyxa yu chi oc cu Colomal oj. ");
INSERT INTO knjNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero ja' tinani', sowalil chi ey ec' Jesucristo satcan, masanta' c'al chi jul stiempoal sjul swa'nen oc masanil tzet yetal. Quey tu' jix yute yalon can Dios yin yak'balnen sti' eb ẍejab yet peyxa, eb tol yet c'al Dios yei. ");
INSERT INTO knjNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ja' naj Moisés jix alon can jaxca ti' tet eb kichmam: “Ja' naj Kaawil Dios oj sic'on el jun ẍejab snan xol eb ket conob, jaxca jix yun jin sic'le el jainti'. Caw che yak' je txiquin tet masanil tzet oj yal e ex. ");
INSERT INTO knjNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yutol yal c'al mac man oj yak' xiquin yaben tzet oj yal jun ẍejab Dios tu', oj q'ueyle can el xol eb ket conob,” ẍi can naj Moisés yul An Juun tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Masanil c'al eb ẍejab Dios ec'naj peyxa, eb jix ẍa' el yin naj Samuel, jix al-le can el sk'aneal jun tiempoal lalan yunen ti' yu eb. ");
INSERT INTO knjNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jaexti', yic'aal jex eb ẍejab Dios tu' ketoj. Yuxan, ja' yet jix yak'on can strato Dios yetoj eb kichmam tu', jix yak' pax can e on yetoj eb. Chi yal jun strato yak'naj can yetoj naj Abraham jaxca ti': “Yu ja yic'aal, yuxan oj wak' watx' c'ulal yin masanil eb ánima,” ẍi Dios tet naj. ");
INSERT INTO knjNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ja' yet jix sic'on el Sc'aal, ja' e on ti', jix babi ẍejtej, yet watx' chi yak' watx' c'ulal kiban, catu' chi cu bejon can cu penail jun jun jon, ẍi naj Pedro tet eb yet Israelal tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lalan sk'anab Pedro yetoj Juan snan xol ánima, catu' jix apni eb yak'omal xaambal eb Israel tet Dios yin eb, yetoj naj sat steynemal templo, c'al eb saduceo. ");
INSERT INTO knjNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Caw jix tit sjowal eb sic'lebil, yutol lalan scuywa Pedro yetoj Juan tu' xol ánima. C'uxan lalan yalon eb tol oj pitzc'u a eb camnaj, yutol quey tu' jix yun spitzc'u a Jesús. ");
INSERT INTO knjNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yuxan jix mitx'letej eb yu eb, catu' jix ale oc eb preso, yutol ya el xa, c'am xa c'u, yuxan jix can can eb yul preso jun ak'bal. ");
INSERT INTO knjNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ec'al eb jix yab sk'ane Dios tu'. Jix yaoc eb yin sc'ul, yuxan jix a can sbisil eb creyente tu'. Joeb mi mil sbisil eb winaj. ");
INSERT INTO knjNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ja' yet jun xa c'ual xin, jix syamba sba eb sat yaaw bey Jerusalén tu', yetoj eb ichamtaj winaj ey yopiso, c'al eb cuywam yin sley Moisés. ");
INSERT INTO knjNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Jix syamba sba eb yetoj jun naj yaawil yak'omal xaambal eb tet Dios, chi yij Anás, yetoj pax naj Caifás, yetoj naj Juan, c'al Alejandro, c'al masanil eb naj yic'aal naj yaawil yak'omal xaambal eb tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Catu' jix yak'on i'letoj Pedro c'al Juan sattaj eb, catu' jix apni eb snan xol eb. Jix sk'anlen el eb tet eb jaxca ti': —¿Beytu' jix je yi' jun je yopiso ti', yuxan che yun wan ti'? ¿Mac txequel jix ak'on je yip? ẍi eb tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pero tutun caw ey oc Santo Espíritu yin Pedro, yuxan jix yal jaxca ti': —Jex yaaw icham winaj Israel, c'al jex yaawil conob. ");
INSERT INTO knjNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Yak' sba tol che k'anle el e on, yu jun watx' c'ulalil jix kak' tet naj c'am ta' chi ske' sbey ti', tejan che yoche che yab tzet jix yun swa'xi can naj. ");
INSERT INTO knjNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yuxan oj kaltej jun ti' e ex, yet watx' chi yotajne el masanil eb ket Israelal. Ja' naj ey ec' je sattaj ti', asan yu yipal Jesucristo jix wa'xi naj. Ja' Jesucristo tu', ja' jix je yak' locbale a yin culus. Pero jix pitzc'unele a yu Dios xol eb camnaj. ");
INSERT INTO knjNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jaexti', laan jex jaxca junoj wa'nem na. Ja' naj Jesús, laan jaxca junoj ch'en ch'en c'am chi oc yopiso je yu, pero ja' jix oc yopiso jaxca ch'en yel miman yopiso. ");
INSERT INTO knjNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","C'am junoj xa mac chi ske' cu scoloni, yutol ja' bey yul yiban k'inal ti', c'am junoj mac txequel jix ak'le yopiso yu Dios yak'on colbanile, asan Jesús, ẍi naj Pedro. ");
INSERT INTO knjNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ja' yet jix yilon oc eb yaaw tu', tol caw tec'an chi yute sba Pedro yetoj Juan tu', sk'anabi, jix yilon pax eb tol man cuywinaj oj eb, pero jaxca tol comon ánima c'al eb, yuxan, caw jix q'uey a sc'ul eb yu eb. Catu' jix na'cha el yu eb tol jix ec' eb yetoj Jesús. ");
INSERT INTO knjNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Catu' linan oc naj jix wa'xi yajan tu' sc'atan eb. Yuxan, c'am xa junoj tzet jix ske' yaon oc eb yiban eb. ");
INSERT INTO knjNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yuxan jix yal eb tol chi i'le el Pedro yetoj Juan tu' xol eb, yajban chi k'anab eb xojli. ");
INSERT INTO knjNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Jix el c'al eb xol eb xin, jix yalon eb jaxca ti': —¿Tzet watx' chi kute eb scawanil chi cu na' wej xin? Yutol masanil eb a Jerusalén ti', yotaj jun milagro jix el yunen eb ti'. Yuxan, ja' tinani', c'am chi ske' kaloni, tol tu' c'al chi yal eb. ");
INSERT INTO knjNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ja' tinani' xin, manchej xa ojab sajlemtoj jun ti' xol ánima. Yuxan cu xibte wej eb, yet watx' c'am xa chi yal el sk'aneal Jesús eb tu' tet junoj xa mac txequel, ẍi eb yaaw tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jix lawi tu' xin, jix awtele eb yu eb yaaw tu'. Jix cam yalon eb tet eb, tol c'am xa bak'in chi yal eb nioj xa sk'aneal Jesús, catu' c'am xa chi cuywa eb tet eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero jix tak'wi Pedro yetoj Juan tu' tet eb jaxca ti': —Pero chi cam wal je na'oni. ¿Watx' mi yul sat Dios che na', ta ja' je yet chi cu jije, jal Dios c'am chi cu jije tzet chi yala? ");
INSERT INTO knjNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yuxan, tutun ma ske' cu bejon kalon el sk'aneal tzet jix kila, c'al tzet jix kabe, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yu tzet jix yal eb tu' xin, jix xibtele a eb yu eb. Catu' jix jajle el eb. C'am chi na'cha el yu eb tzet watx' bey chi can mitx'an eb, catu' jix ale oc sya'ilal eb yu eb, yutol masanil ánima chi yal watx' k'ane tet Dios yu jun tzet jix el yunen eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ja' naj jix wa'xi can yajan yu jun milagro tu', ec'ban xa cuarenta jabil naj. ");
INSERT INTO knjNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ja' yet jix jajcha Pedro yetoj Juan tu' xin, catu' jix to eb, catu' jix apni eb bey ey ec' wan xa yetbi eb. Jix yal eb tet eb masanil tzet jix al-le tet eb yu eb yaawil yak'omal xaambal eb Israel tet Dios, yetoj eb ichamtaj winaj ey yopiso. ");
INSERT INTO knjNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jix yab c'al eb yetbi eb tu' xin, catu' jix txali eb masanil tet Dios. Jix yal eb jaxca ti' yin xa eb: —Mamin, jaach jix ja wa'ne satcan, c'al tx'otx' tx'otx' ti', yetoj ja' mar, c'al masanil tzettaj yetal. ");
INSERT INTO knjNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jaach jix ja wak'balne Santo Espíritu, catu' jix jaach k'anab yin sti' ja chejab David, yet jix yalon can jaxca ti': ¿Tzet yuxan chi jowbi a eb ánima bey jun jun conob? ¿Tzet yuxan chi sna' eb wan tzet yetal c'am yel oc apnoj? ");
INSERT INTO knjNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Jix syamba oc sba eb rey yul yiban k'inal ti', catu' jix syamba oc sba eb yaaw masanil. Jix yamcha oc eb, catu' jix sk'umenlen sba eb yin cu Mam Dios, Kaawil, c'al yin naj Cristo sic'bil el yu Dios, ẍi yul An Juun Tz'ibebil can oj. ");
INSERT INTO knjNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Caw yel, ja' naj Herodes, yetoj naj Poncio Pilato, c'al eb man Israel oj, yetoj pax eb Israel, jix syamba oc sba eb yul conob ti', catu' jix k'anab el eb yin ja C'aal, asan jaach ja wet yei. Pero jaach jix ja wak' can yopiso. ");
INSERT INTO knjNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jix el yunen masanil tzet albil can yet peyxa. Yutol jix el yin ja c'ul tol jaxca tu' oj el yunen eb. ");
INSERT INTO knjNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Jal tinani' xin, Mamin, ila eb ti', caw chi tit sjowal eb kin. Yuxan, ak' cu tec'anil yet watx' c'am chi cu xiw kalon el ja k'ane, ila tol ja chejab jon. ");
INSERT INTO knjNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ak' ja wipal e on, yet watx' cha wak' can wa'xoj sc'ul eb ya' ey ku on. Jaach jix ja wun wan milagro jix x'oxon el ja wipal yin naj Jesús. Ja' Jesús tu', ja C'aal, asan jaach ja wet yei, ẍi eb tet Dios. ");
INSERT INTO knjNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ja' yet jix lawi xali eb tu', catu' jix tzicle jun na bey yaman ec' eb tu' yu Dios, catu' caw jix oc can Santo Espíritu yin masanil eb. Yuxan, caw ey stec'anil eb yalon el sk'ane Dios. ");
INSERT INTO knjNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jun laan xa c'al sna'bal eb creyente smasanil. Caw ey watx' c'ulal yin eb. C'am junoj mac txequel chi yal oc junoj tzet yetal yetoj xojli. Yutol junne c'al ye settaj yetal eb masanil. ");
INSERT INTO knjNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ja' eb ẍejab Jesús, caw tec'an c'al chi yute sba eb yalon el oj tzet utbil tol jix pitzc'u a naj Kaawil Jesús. Caw chi oc c'al Dios yetoj eb creyente smasanil. ");
INSERT INTO knjNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","C'am mac meba' xol eb, yutol masanil c'al mac ey x'otx', c'al sna, jix xon el oj, catu' jix yi'ontej stool tu', ");
INSERT INTO knjNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","catu' jix yak'on tet eb ẍejab Jesús tu'. Ja' eb chi po'on ec' xol eb creyente tu', ja'ta'c'ala' tzet sowalil chi oc yu jun jun eb. ");
INSERT INTO knjNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ey jun creyente chi yij José, jun jix oc can sbi Bernabé yu eb ẍejab Jesús tu'. Bernabé chi yal yel oc apnoj, “Miman C'ulnewom”. Ja' Bernabé tu', yic'aal naj Leví, a Chipre naj. ");
INSERT INTO knjNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ey jun x'otx' jix xon el oj, catu' jix jul yak'on stool tet eb ẍejab Jesús tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ey jun winaj chi yij Ananías. Safira sbi yistil. Ey jun x'otx' eb jix xon el oj. ");
INSERT INTO knjNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ja' yet jix ẍa'on stool x'otx' eb tu', jix yi'on can el nian yet yin, yuxan man xa tz'ajan oj jix yi' apnoj ch'en tet eb ẍejab Jesús tu'. Jal jix yute yalon tet eb, tol tz'ajan jix jul ch'en masanil. Yotaj pax ix istile tol man yel oj jun ti'. ");
INSERT INTO knjNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Jix yalon Pedro tet Ananías tu' jaxca ti': —Ananías, ¿tzet yuxan jix ja cha' oc diablo yin ja pixan, yuxan cha wak' lek'ti'al tet Santo Espíritu? Catu' jix ja mitx'on oc stool ja tx'otx' tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ja' yet c'am to cha txon el tx'otx', yel ja wet tx'otx'. Ja'c'ala' yet jix ja txon el tx'otx', ja wet pax stool tu'. Yuxan, ¿tzet yuxan jix ja na' jun tzet man watx' oj ti' jaxca ti'? Man ánima oj bey cha wak' lek'ti'al ti', pero ja' tet Dios cha wak' lek'ti'al, ẍi Pedro tet naj. ");
INSERT INTO knjNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ja' yet jix yaben wan ti' naj Ananías tu', jix telc'otoj naj catu' jix cami. Ja' masanil eb jix aben sk'umal jun tzet jix yun tu', caw jix xiw a eb sic'lebil. ");
INSERT INTO knjNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jix lawi tu', jix apni wan eb naj ach'e. Jix xoton oc jun k'ap eb yin smimanil naj Ananías tu', catu' jix bet smujon can naj eb. ");
INSERT INTO knjNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Oxeb xam hora scam naj, jix apni ix yistil naj tu', catu' jix octoj ix yul na. Man yotaj oj ix ta xax cam yichamil ix. ");
INSERT INTO knjNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jix sk'anlen Pedro tet ix jaxca ti': —¿Yel mi, tol jaxca ti' jix oc yin tx'otx' je tx'otx' jix je txono? ẍi naj tet ix. —Jaa', quey ton tu', ẍi ix tet naj. ");
INSERT INTO knjNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Catu' jix yalon Pedro tet ix jaxca ti': —¿Tzet yuxan jix je latine je ba, catu' che yak'on porobal Yespíritu naj Kaawil? Lalan sjul eb naj jix bet mujon can ja wichamil sti' na ti'. Catu' oj jaach yi' pax toj eb naj ti', ẍi naj tet ix. ");
INSERT INTO knjNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Catu' jix telc'otoj ix sattaj Pedro tu', catu' jix cam pax ix tu'. Ja' yet jix apni eb naj ach'e tu' xin, catu' jix yilon eb, camnaj xa ix. Catu' jix i'letoj smimanil ix yu eb naj tu', jix bet mujle can ix scawilal yichamil yu eb naj. ");
INSERT INTO knjNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yuxan jix jul jun miman xiw c'ulal yiban masanil eb creyente, c'al yiban masanil eb jix aben sk'umal tzet jix yun scam naj Ananías yetoj yistil. ");
INSERT INTO knjNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ja' eb ẍejab Jesús, ec'al milagro jix x'ox eb. Yel c'ulal tol jix x'ox el yipal Dios eb snan xol ánima. Ja' bey jun yamak'il stemplo Dios yul jun miman na c'am yich chi yij tol yet Salomón, ja' tu' chi syamba sba eb creyente tu' masanil. ");
INSERT INTO knjNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","C'am junoj eb man creyente oj chi stec'ba sba sto xol eb yet chi syamba sba eb tu'. Pero yotaj eb tol caw watx' eb creyente tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ec'al eb winaj, c'al eb ix chi yaoc sc'ul yin naj Kaawil. ");
INSERT INTO knjNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Catu' jix yi'on eltej sya' ey eb ánima yul-laj calle. Ey la mac satlaj tx'at, ey la mac xin, asan satlaj sweyub. Catu' chi yechbanen yec' Pedro eb scawilal tu', yet watx' cax c'al asan yenel naj chi ec' el yiban eb, catu' chi wa'xi can sc'ul eb. ");
INSERT INTO knjNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ec'al ánima jix tit bey conoblaj bey scawilal Jerusalén tu'. Ey eb ey sya' ey eb i'bil oc oj, c'al eb ey oc pena espíritu yin pax oj. Pero jix c'al wa'xi can sc'ul masanil eb. ");
INSERT INTO knjNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Catu' jix tit sjowal naj yaawil yak'omal xaambal eb Israel tet Dios tu' yu chichon c'ulal, yetoj jantaj eb yetbi masanil, ja' ton eb saduceo. ");
INSERT INTO knjNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yuxan jix yak' eb mitx'le eb ẍejab Jesús tu', catu' jix i'letoj eb preso yu eb. ");
INSERT INTO knjNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ja' yet ak'balil xin, ey jun yángel naj Kaawil jix jul jajon te' preso tu'. Jix i'le eltej eb yu, jix yalon tet eb jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Asi' wej, ocan nej linan yul stemplo Dios, catu' che yalon el sk'aneal jun k'inale jix ak'le e ex ti' tet masanil ánima, ẍi jun ángel tu' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yuxan, ja' yet lalan xa sajbi xin, jix to eb bey stemplo Dios tu', catu' jix c'oli scuywa eb yul tu'. Jix awtele eb sattaj eb yaawil eb Israel tu' yu naj yaawil yak'omal xaambal eb Israel tet Dios, c'al yu jantaj eb yetbi naj. Yuxan jix ẍejtoj jaywan eb policía eb yaaw tu', yu sto yi'le eltej eb yul preso tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero ja' yet jix apni eb bey preso tu', c'am xa mac ey octoj. Jix yil c'al eb tol c'am xa mac ey octoj, catu' jix to yalon eb. ");
INSERT INTO knjNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Jix yalon eb jaxca ti': —Jaonti', jix kil sic'lebil, caw c'anani ye te' preso tu'. Linan oc eb naj teynem preso bey sti' tu'. Pero ja' yet jix cu jajon te', catu' jix kiloni, tol c'am xa mac ey octoj, ẍi eb policía tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ja' yet jix yaben naj yaawil yak'omal xaambal eb Israel tet Dios, c'al eb yetbi, c'al naj sat steynemal stemplo Dios, caw jix q'uey a sc'ul eb sic'lebil. Ma na'cha el yu eb tzet ye oc oj. ");
INSERT INTO knjNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lalan to c'al jun tu', catu' jix apni jun winaj sc'atan eb, jix yal jaxca ti': —Ja' eb jix je yaoc preso, ey ec' eb yul stemplo Dios tinani'. Lalan scuywa eb snan xol ánima, ẍi naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jix to i'le eb yu naj sat steynemal stemplo Dios tu', yetoj eb policía. Pero man yin oj yax c'aynajil jix yun yi'letej eb yu eb, yutol chi xiw sk'ojch'ennele eb yu eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Jix apni c'al eb ẍejab Jesús tu' yu eb xin, jix i'letej eb sattaj eb yaaw tu'. Catu' jix al-le tet eb yu naj yaawil yak'omal xaambal eb Israel tet Dios jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Jix cam kalon e ex, tol c'am xa che yal el scuybanil Jesús ti'. ¿Tumi man oj je jije nioj xin? Ila tinani', jix sajlem jun je cuybanil ti' bey Jerusalén ti'. Tol che yoche che yatoj scamichal Jesús kiban, ẍi eb tet eb chejabwom tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Catu' jix tak'wi Pedro tu' yetoj wan xa ẍejab Jesús jaxca ti': —Sowalil ja' tzet chi yal Dios, ja' chi cu jije. Jal pax tzet chi yal ánima xin, ta c'am chi ẍa'le sba yetoj tzet chi yal Dios, c'am chi cu jije. ");
INSERT INTO knjNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jaexti', jix je yak' mak'le cam Jesús, yet jix je yak'on locbale a yin culus. Pero ja' Dios, ja' ton jun Dios bey jix yi' ey sba eb kichmam, ja' jix ak'on pitzc'u a xol eb camnaj. ");
INSERT INTO knjNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ja' jix ak'on yopiso, catu' jix yi'on pax a bey swatx' k'ab. Jix yaoc Kaawil oj, c'al cu Colomal oj, yuxan ja' Jesús tu' chi ak'on cu na' cu ba jaon Israel jon ti', yet watx' chi el can cu penail yu. ");
INSERT INTO knjNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jaonti', chi kak' cu ba testigoal yin wan chi kal e ex ti'. Ila pax naj Santo Espíritu, chi yak' sba naj testigoal yin ketoj. Chi yak' Dios Yespíritu ti' tet masanil mac chi jijen tzet chi yala, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ja' yet jix yaben wan ti' eb yaaw tu', caw jix tit sjowal sc'ul eb sic'lebil. Jix yochen xa c'al eb tzet chi yute yak'on cam eb yin eymanil. ");
INSERT INTO knjNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero ja' xol eb yaaw tu', ey jun naj fariseo chi yij Gamaliel. Cuywam naj yin sley Dios sic'lebil. Caw watx' naj yul sat ánima. Jix a linan naj snan xol eb, catu' jix yak'on chejle eltoj eb ẍejab Jesús tu' sti' na junoj txolan. ");
INSERT INTO knjNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ja' yet jix eltoj eb, catu' jix yalon jaxca ti': —Jex wet Israelal, chi cam je na'on sic'lebil, tzet oj je yute wan winaj ti'. ");
INSERT INTO knjNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ka wej toj cu na'bal yin naj chi yij Teudas peyxa. Tz'aj yalnaj oc sba yaawil xol ánima. Chi tz'ajna yala tol eyna yopiso. Ey mi caneboj ciento ánima jix cuywi yintaj. Ja' yet jix mak'le cam naj, jix sajlem can toj eb jix cuywi yintaj tu', jix tan ey jun yet eb tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ey xa ta' wal tu' ey jun xa naj chi yij Judas a Galilea. Jix tz'aj yal oc sba naj yaawil, yet jix i'le a sbisil eb ánima yu yaaw. Ec'al pax ánima jix cuywi yintaj jun xa naj tu'. Ja' yet jix mak'le cam naj, jix sajlem can toj masanil eb jix cuywi yintaj naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yuxan chi wal je yabe, cu bej wej ketnen eb naj ti', yil xa eb naj. Ta yet ánima jun bey ey oc eb ti', masanil c'al oj yak' lawoj ey sba. ");
INSERT INTO knjNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero ta yet Dios xin, ma ske' kak'on lawoj. Ey smey, ta yetoj Dios lalan kak'len jowal, ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jix ẍa' sc'ul eb yaaw tu' tzet jix yal naj Gamaliel tu'. Catu' jix awtele octoj eb ẍejab Jesús tu' yu eb, catu' jix yijon tz'um eb. Catu' jix al-le pax tet eb, tol manchej xa yal el sk'aneal Jesús eb. Jix lawi tu' xin, catu' jix jajle el eb. ");
INSERT INTO knjNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ja' yet jix eltej eb sattaj eb sat yaaw tu', caw chi tzala eb yutol jix yal sc'ul Dios tol yu c'al Jesús, yuxan chi yil sya'ilal eb. ");
INSERT INTO knjNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma sbej eb yalon el sk'aneal Jesucristo. Jun jun c'u jix ec' c'al yal eb bey stemplo Dios, c'al bey xol-laj na. ");
INSERT INTO knjNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ja' yet jun tiempoal tu', yel c'ulal tol jix ch'ib sbisil eb creyente. Pero ja' eb creyente chi k'anab yin griego, jix scajle a sba eb yetoj eb chi alon hebreo, yutol ja' yet chi ak'le low eb meba' jun jun c'u, man tz'ajan oj chi ak'le tet eb ix ix camnaj xa yichamil xol eb griego tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yuxan jix yambale oc masanil eb creyente yu eb lacawan ẍejab Jesús. Jix yalon eb tet jaxca ti': —Ian wal c'am xa cu tiempo kalon el sk'ane Dios, yutol asanxane lo'o ti' chi kak' cuenta. ");
INSERT INTO knjNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yuxan, jex wuẍtaj, che satne wej oj jujwanoj winaj cu xol ti', catu' che yaon oc yopiso eb yilon jun mulnail ti'. Jujwanoj tol watx' sbeybal, catu' chi na'cha el yet Dios yu eb, sowalil tol caw ey oc Santo Espíritu yin eb. ");
INSERT INTO knjNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jaonti' xin, oj cu oc c'al yin txa, catu' oj kalon el sk'ane Dios, ẍi eb lacawan tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Caw jix tzala a eb masanil yu jun k'ane tu', yuxan, ti'taj ey sbi eb jix sic' el eb ti': Esteban, jun naj caw ey oc sc'ul yin Dios sic'lebil, catu' caw ey oc Santo Espíritu yin, yetoj Felipe, Prócoro, Nicanor, Timón, Parmenas, c'al jun naj chi yij Nicolás a Antioquía. Ja' naj Nicolás ti', ocnaj xa ta' yin scuybanil eb Israel yet yalantoj. ");
INSERT INTO knjNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yet jix sic'le el eb, catu' jix i'letej eb sattaj eb ẍejab Jesús tu'. Jix txali eb. Catu' jix yaon oc sk'ab eb chejabwom tu' yiban sjolom eb. ");
INSERT INTO knjNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jix c'al sajlemtoj sk'ane Dios xol eb ánima. Yuxan jix c'al a sbisil eb creyente bey Jerusalén tu'. Ja' eb yak'omal xaambal eb Israel tet Dios, ec'al eb jix oc yin creyenteal. ");
INSERT INTO knjNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ja' naj Esteban, miman swatx' c'ulal Dios cha'bil yu. Caw chi oc c'al Dios yetoj. Yuxan, ec'al milagro jix el x'oxon naj xol eb ánima. ");
INSERT INTO knjNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero ey wan eb Israel chi syamba sba bey jun snail sculto jun bulan eb Israel chi yij: “Eb Yet Xa Sba.” Ey pax wan eb a conob Cirene, c'al wan eb a conob Alejandría, yetoj wan eb a Cilicia, c'al wan eb a Asia. Jix apni eb ti' sc'atan Esteban tu', jix c'oli steelen sba eb yetoj. ");
INSERT INTO knjNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero ma yak' ganar eb, yutol ja' sjelanil Santo Espíritu chi yak'balne naj yet chi k'anab naj tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jix c'al yil eb jaxca tu', catu' jix smanon jaywan lek'ti' testigo eb tu'. Jix yak'on sc'ul oj eb, yet watx' chi yal eb jaxca ti': —Jix kab buchwa Esteban ti' yin kichmam Moisés, c'al yin Dios, ẍina eb. ");
INSERT INTO knjNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Quey tu' jix yute yak'on a somna conob eb, yetoj eb ichamtaj winaj, c'al eb cuywam yin sley Moisés. Yuxan jix tit jucna eb yin Esteban tu', jix smitx'on ey naj eb. Jix yi'ontoj naj eb sattaj yaaw tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Jix lawi tu' xin, jix seyon jaywan xa mac chi aon oc tz'ajil k'ane eb yiban Esteban tu'. Jix apni c'al eb, jix yalon eb tet eb yaaw tu' jaxca ti': —Ja' Esteban ti', caw c'am chi sbej nioj sbuchwa yin stemplo Dios, pero tol yet c'al Dios yei. Catu' chi buchwa pax yin sley Moisés. ");
INSERT INTO knjNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jix kab yalon jaxca ti': “Ja' Jesús a Nazaret, oj yuch ey stemplo Dios. Oj sq'uexpone wan cu beybal ak'bil can e on yu Moisés.” Quey tu' jix yute yaloni, ẍi eb chi tz'aj yalon eb. ");
INSERT INTO knjNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Catu' jix oc t'anan eb yaaw yin Esteban tu', c'al jantaj masanil mac chotan ec' oj. Ja' yet jix oc t'anan eb yin sat, caw laan yili sat tu' jaxca junoj ángel. ");
INSERT INTO knjNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jix sk'anle el naj yaawil yak'omal xaambal eb Israel tet Dios tet naj Esteban jaxca ti': —¿Yel mi masanil wan ti'? ẍi tet naj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Jix yalon Esteban tu' jaxca ti': —Jex wet conob, jex ichamtaj winaj, ab wej. Ja' Dios caw miman yel oc apnoj. X'oxnaj a sba tet kichmam Abraham, yet ey ec' bey Mesopotamia, yet c'am to chi to scaba sba bey conob Harán. ");
INSERT INTO knjNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Yalnaj Dios tet jaxca ti': “Bej can ja tx'otx' ti', c'al jantaj ja wican, catu' chach to bey jun lugar tol oj jin tx'ox e ach an,” ẍi Dios tu' tet naj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ja' yet jix el bey slugar eb Caldeo bey ey ta' ec' tu', catu' ja' bey conob Harán, ja' tu' jix to naj scaba sba. Ja' yet jix cam smam xin, jix i'letej yu Dios bey jun lugar bey ey jon ec' ti'. ");
INSERT INTO knjNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero c'am nioj x'otx' jix ak'le yu Dios titi', tutun c'am nioj bey chi ey tec'an yajan. Asan xin, jix yak' sti' Dios tet. Jix yalon tet jaxca ti': “Oj wak' jun ja tx'otx'. Ja' yet oj jaach cam oj, oj can jun ja tx'otx' tu' yul sk'ab eb ja wic'aal,” ẍi Dios tu' tet naj. C'am to junoj yuninal yet jix yak'on can sti' Dios tet naj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jix yalon pax can Dios tet jaxca ti': “Ja' eb ja wic'aal, oj scaba sba eb bey junoj xa tx'oj conobal. Oj oc eb yak'omal oj servil yintaj eb tx'oj conobal tu'. Caneb ciento jabil oj yab sya'il eb yu eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero oj wa oc sya'ilal yiban eb tx'oj conobal bey oj oc eb yak'omal oj servil tu'. Oj lawoj tu', catu' oj el eb ja wic'aal tu' bey ey ec' eb yak'omal oj servil tu'. Catu' oj jin yak'on servil eb bey jun lugar ti',” ẍi Dios tet naj Abraham. ");
INSERT INTO knjNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yetoj pax oj, jix yak' pax can strato Dios tu' yetoj naj Abraham tu'. Yalnaj can Dios tu' tet, tol chi oc jun echele yin smimanil c'al yin eb yic'aal, yechel oj strato yetoj eb. Ja' jun echele tu', ja' ton chi ijon circuncisión. Yu tu' xin, ja' yet jix ali jun yuninal Abraham chi yij Isaac, sjujubix tax ali, catu' jix ak'le circuncidar yu Abraham tu'. Yetoj pax yet jix ali naj sc'aal Isaac chi yij Jacob, jix ak'le pax circuncidar yu Isaac tu'. Ja' naj Jacob tu', lacawan sc'aal naj alinaj. Jix yak' circuncidar eb slacawanil. Ja' eb lacawan tu', ja' ton eb kichmam jaon Israel jon ti'. ");
INSERT INTO knjNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ja' eb kichmam tu', ey jun yuẍtaj eb chi yij José. Ja' junel jix meltzo oc eb yuẍtaj ac'ulalil yin naj. Yuxan jix txonle el naj yu eb, catu' jix i'letoj naj bey conob Egipto. Pero ey c'al oc Dios yetoj naj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ja' jix colon el José tu' xol sya'tajilal ec'naj el yiban. Yak'naj sjelanil Dios tu' tet naj. Ocnaj Dios tu' yetoj, yet watx', watx' c'al chi el oc sattaj naj Faraón, naj sreyal Egipto. Yuxan, yanaj oc yopiso naj yaawilal bey Egipto tu', catu' jix yaon pax oc yaawilal bey sna. ");
INSERT INTO knjNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Pero ey jun tiempoal, julnaj jun miman wail yiban masanil eb a Egipto tu', c'al yiban eb a Canaán. Caw yabnaj sya'il eb yu jun wail tu'. Quey pax tu' eb kichmam a Canaán tu', caw c'am xa chi ilcha tzet chi slo' eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Catu' jix yaben Jacob tol ey ixim bey Egipto, catu' jix ẍejontoj eb sc'aal tu' titu'. Ja' eb sc'aal tu', ja' ton eb kichmam. Sbabel to eb jix toi. ");
INSERT INTO knjNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jaxa yet jix chejletoj eb yet scaelal xin, jix yak'on sba José yotajne el eb, tol yuẍtaj sba eb yetoj. Yuxan, quey tu' jix yute yotajnen can el Faraón mac txequel wan yet sconob José tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jix yak'on to tit smam naj José tu', ja' ton naj chi yij Jacob. Jix tit pax eb yuẍtaj, c'al yistil eb, yetoj c'al yuninal eb masanil, setenta y cinco sbisil eb yin masanil. ");
INSERT INTO knjNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yuxan, quey tu' jix yun yapni can oc Jacob tu' bey Egipto tu'. Ja' tu' jix cam naj. Ja' pax titu' jix cam eb kichmam. ");
INSERT INTO knjNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Catu' jix i'le paxtej smimanil eb bey conob Siquem, bey jix ale octoj yul jun ch'en jolbil. Ja' jun ch'en ch'en tu', ja' Abraham jix manon tet eb yuninal Hamor bey Siquem tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ja' yet lalan xa sjul stiempoal yunen tzet albil can tet Abraham yu Dios xin, caw jix ch'ib c'al sbisil eb yic'aal bey Egipto tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Niẍtejal jix oc jun rey bey Egipto tol man otajne oj sk'aneal José, yutol peyxa tax cam naj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ja' jun rey tu', caw jix etnele eb kichmam tu' yu. Caw jix yak' pena c'ulalil yin eb. Jix yal tet eb, tol sowalil chi k'oj el eb jantaj swinaj unin eb chi ali, yet watx' chi lawi el yic'aal eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ja' yet jun tiempoal ey smey tu', ja' tu' jix ali naj Moisés, unin tol caw watx' yili. Oxebne xaaw jix il-le ch'ib yu smam c'al xutx bey sna. ");
INSERT INTO knjNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jix lawi tu' xin, jix bejle can xojli yu eb. Pero jix bet ilchatej yu ix scutz'in naj rey tu', jix yi'ontoj ix bey sna, jix yilon ch'ib ix jaxca tol yune'. ");
INSERT INTO knjNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yuxan, ja' Moisés tu', jix cuywi yin masanil jantaj sjelanil eb a Egipto tu', yuxan caw jelan sk'anabi, c'al jelan swa'nen smasanil tzettaj yetal. ");
INSERT INTO knjNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ja' yet cawinaj xa jabil sk'inal naj, jix jul yin sna'bal to yilon eb yet conob, ja' ton eb ket Israelal. ");
INSERT INTO knjNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pero ja' yet jix apni tu' xin, jix yiloni, ey jun naj a Egipto, lalan yetnen jun naj yet conob Moisés tu', jix col-le el naj yu Moisés, jix ale ec' spaj yu naj Moisés tu' yin naj a Egipto tu', jix ak'le xa c'al cam yu naj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ja' jix sna'on Moisés tu', tol jix na'cha el yu eb yet conob, tzet utbil ja' jix chejle yu Dios yet chi scolon can el eb. Pero ma na'cha el yu eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yewial tu', jix yilon yin cawan xa yet conob. Lalan pax yak'len jowal eb. Jix yoche jix oc eb yin watx' c'ulalil, yuxan jix yal naj tet eb jaxca ti': “Jex wuẍtaj, ¿tzet yuxan che yak'le jowal? Ilala, je yet conob je ba,” ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ja' yet jix tenletoj Moisés yu naj yel c'ulal tol chi ak'wi jowal tu', jix yalon naj tet jaxca ti': “¿Mac jix jaach aon oc yaawil, yuxan chon ja wak' mandar? ");
INSERT INTO knjNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Tumi cha woche chin ja mak' cam jaxca jix ja wute naj a Egipto ewi?” ẍi naj tet. ");
INSERT INTO knjNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Jix yab c'al Moisés jaxca tu', catu' jix eli. Catu' jix to scaban sba xol eb tx'oj conobal a lugar bey Madián tu'. Ja' titu' alinaj cawan sc'aal naj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Cawinaj xa jabil yapni titu', catu' jix to bey wonan Sinaí, bey c'am ánima. Ey jun ángel jix x'ox a sba tet titu'. Xol xaj k'ak' jix x'ox a sba, bey chi chaw jun k'ak' yin te' q'uix. ");
INSERT INTO knjNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ja' yet jix yilontoj jun tu', caw jix q'uey a sc'ul naj yu. Catu' jix to naj yiloni. Jix yalon naj Kaawil tet jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Jain ton Sdiosal jin eb ja wichmam. Sdiosal jin Abraham, yetoj Isaac, c'al Jacob,” ẍi Dios tet naj. Catu' jix bilwi a Moisés tu' yu xiw c'ulal, catu' ma xa oc t'anan yin. ");
INSERT INTO knjNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jix yalon naj Kaawil junel xa tet jaxca ti': “I' eltej ja xanab, yutol jain ey jin ec' bey jun lugar bey ey jaach ec' ti'. ");
INSERT INTO knjNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ja' eb jin conob ey ec' bey Egipto, chi wila, tol caw lalan yilon sya'ilal eb titu'. Chi wabe, tol caw chi cajle eb yilon sya'ilal tu'. Yuxan, asi', jaach, oj jaach jin chejtoj bey Egipto tu',” ẍi Dios tet Moisés tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ja' yet yalantoj tu', yet jix apni naj bey eb yet conob tu', ma cha'le naj yu eb. Junelne tol c'am yel oc apnoj yul sat eb. Yuxan jix yal eb tet jaxca ti': “¿Mac jix jaach aon oc kaawil yuxan chon ja wak' mandar?” ẍi eb tet. Pero ja' Dios jix ak'on yopiso Moisés tu' yin yak'on cuenta eb. Catu' jix yak'balnen yopiso tu' yi'on eltej eb xol sya'ilal bey ey ec' eb yetnen sc'ul tu'. Ja' jun ángel jix x'ox a sba tet Moisés tu' yin te' q'uix, ja' jix oc yetoj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ja' Moisés, bet inen eltej eb ket conob bey Egipto tu' jix x'ox milagro bey jun ja' Cajin Mar sbi, c'al bey cusiltaj tx'otx'. ");
INSERT INTO knjNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ja' naj Moisés tu', jix alon tet eb ket a Israelal jaxca ti': “Dios oc sic'on el jun ẍejab Dios xol eb ket conob ti', jaxca jix yun jin sic'le el oj. Caw che yaoc je txiquin yin,” ẍi naj tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ja' Moisés tu', jix ec' snan xol ánima bey cusiltaj tx'otx'. Ey jun ángel ey ec' yetoj eb, jun k'anabnaj yetoj Moisés bey wonan Sinaí. Yet ey ec' eb kichmam yetoj. Ja' tet Moisés tu', yak'naj can Dios wan k'ane yet k'inale. Yuxan jix ak'le pax can e on. ");
INSERT INTO knjNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pero ja' eb kichmam tu', ma yal sc'ul eb chi sjije tzet jix yal Moisés tu'. Yuxan jix yintajne el eb, catu' jix yochen eb jix meltzo yintaj junel xa bey Egipto. ");
INSERT INTO knjNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jix yalon eb tet Aarón jaxca ti': “Wa'ne wanoj cu diosal, catu' chi babi cu sattaj, yutol ja' Moisés jix cu i'on eltej bey Egipto tu', man kotaj oj tzet chi i'on naj,” ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Catu' jix swa'nen yechel jun ach'e wacax eb tu', catu' jix yalon oc eb sdiosal oj. Jix yak'on cam wan no' nok' eb. Catu' jix yak'on eb yin xaambalil tet. Jix c'oli ẍa'on sk'inal eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yuxan jix yi' el sba Dios xol eb. Catu' jix bejle can eb xojli yu, yet watx' chi yi' ey sba eb tet weycan ey satcan. Jaxca ta' jix yute s'iben can jun ẍejab Dios, bey chi yal jaxca ti': Jex Israel, cawinaj jabil jix je yak' cam no' nok' yin xaambalil bey cusiltaj tx'otx'. Pero, ¿E in mi jix je yak' no' yin xaambalil tu'? ");
INSERT INTO knjNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","C'am nioj je xaambal tu' jix je yak' e in an. Pero tol ja' tet jun je diosal chi yij Moloc, jun che batx ec' oj, ja' tu' jix je yak'a, yetoj tet jun yechel weycan chi yij Renfán, ja' wan ti' jix je yal oc je diosal oj. Ja' tet wan yechel jix je wa'ne tu', ja' tu' che yi' ey je ba. Yuxan oj jex wi' el sat je tx'otx'al, catu' oj jex waon can toj sattajtoj Babilonia, ẍi Dios yul An Juun Tz'ibebil can oj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Pero ja' yet jix ec' eb kichmam bey jun cusiltaj tx'otx' tu', yetbi oc jun Snail Sley Dios eb yetoj. Jun wa'nebil can yu Moisés, jaxca jix yute yalon Dios tu' tet yet jix x'oxon jun echele tet. ");
INSERT INTO knjNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ja' jun Snail Sley Dios tu', niẍtejal jix can yul sk'ab wan xa eb kichmam. Ja' naj Josué jix i'ontoj yetoj eb tu' yet jix yi'on can x'otx' eb tx'oj conobal eb tu'. Ja' Dios jix i'on el wan tx'oj conobal tu' sat x'otx' eb tu'. Ja' jun Snail Sley Dios tu', yetbi c'al oc eb masanta' c'al jix oc naj David sreyal oj eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ja' naj David tu', caw jix tzala Dios yetoj. Yuxan jix yoche jix wa'ne snail Sdiosal Jacob, ja' cu Diosal pax oj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero ja' naj Salomón jix wa'nen jun snail Dios tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ja' Dios tu', caw miman yel oc apnoj, c'am sowalil junoj na wa'nebil yu ánima bey chi eq'ui. Jaxca tu' yalon can tet jun ẍejab peyxa, yet jix yalon can jaxca ti': ");
INSERT INTO knjNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ja' satcan, jin despacho yei. Ja' yul yiban k'inal, jaxca tol sbatxlubal wajan yei. Yuxan, jaexti', ¿tzet oj je yute je wa'nen junoj jin na? ¿Ey mi junoj lugar bey c'uxan chin xewi? ");
INSERT INTO knjNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yutol Jainti', jain jix jin wa'ne wan ti' yetoj jin k'ab, ẍi Dios yul An Juun. ");
INSERT INTO knjNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Pero jaexti', caw caw je na'bal. Laan je na'bal jaxca eb man otajnen nioj Dios. Caw c'am che yak' nioj je txiquin yin sk'ane Dios. Ja' ti' je yet, tol chex oc ac'ulal yin naj Santo Espíritu. Yuxan laan jex jaxca eb kichmam. ");
INSERT INTO knjNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ja' eb ẍejab Dios peyxa, masanil eb jix yab sya'il yu eb kichmam tu'. Ja' eb jix aloni, tol oj jul jun mac txequel jichan sbeybal. Pero jix ak'le cam eb yu eb. Ja' yet jix jul jun mac txequel tu' xin, jaex xa jix je yaoc yul sk'ab camich, catu' jix je yak'on cam oj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Cax c'al jix yak' wan ẍejbanil Dios eb ángel e ex, pero ma je jije, ẍi Esteban tu' tet eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ja' yet jix yaben wan ti' eb, caw jix sc'uxutene ye eb yet jix tit sjowal eb yin Esteban tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero ja' Esteban tu' xin, caw ey oc Santo Espíritu yin. Yuxan jix a t'anan satcan, jix yilon atoj sejejial Dios. Jix yiloni, linan oc Jesús bey swatx' k'ab Dios. ");
INSERT INTO knjNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Yuxan jix yal jaxca ti': —Ilala, jajan spuertail satcan chi wil an. Ey ec' naj Ak'bil Yopiso xol eb ket animail yu Dios chi wil bey swatx' k'ab Dios tu' an, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ja' yet jix yaben jun tu', jix a yaw jantaj eb bulan ec' titu' yin ipal. Jix smajchen xiquin eb. Catu' jix tit jucna eb yin naj, jix sic'ontej eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Catu' jix yi'ontoj naj eb sti' el conob tu'. Ja' eb jix oc testigoal yin Esteban tu', jix yi' el an jojan pichile chi yaoc yin spichil eb, catu' jix yak'on can an eb steyne jun naj chi yij Saulo, catu' jix mi'cha oc sk'ojch'ennen Esteban eb. ");
INSERT INTO knjNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ja' yet lalan sk'ojch'ennele yu eb tu' jix txali naj jaxca ti': —Wuẍtaj Jesús, cha' jin pixan an, ẍi naj. ");
INSERT INTO knjNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Catu' jix ey kaan oj, jix a yaw xali yin ipal jaxca ti': —Jaah Waawil, manchej ja watoj jun spenail eb ti' yiban eb, ẍi naj. Ja' yet jix yalon jaxca tu' xin, catu' jix cami. ");
INSERT INTO knjNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ja' naj Saulo, jix ẍa' sc'ul sk'ojch'ennele cam Esteban tu'. Ja' yet jun c'u tu', jix ẍa' el yich yac'ulnele eb creyente sic'lebil bey Jerusalén tu'. Yuxan jix el eb. Ey eb jix to bey wan conoblaj yul yet Judea, ey eb jix to yul-laj yet Samaria. Asanxane eb ẍejab Jesús jix can can bey Jerusalén tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ja' yet jix cam Esteban tu', jix i'letoj smimanil mujle yu wan winaj jijyom tet Dios. Caw chi ok' sc'ul eb yu jix cami. ");
INSERT INTO knjNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Jal pax Saulo xin, caw jix a can yak'on ac'ulal yin eb creyente. Jix octoj yul-laj na, catu' jix jutxwi eltej winaj c'al ix yul-laj na tu', catu' jix i'letoj eb preso yu. ");
INSERT INTO knjNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ja' yet jix eltej eb bey Jerusalén tu' xin, catu' jix sajlem can toj eb. Yal c'al bey jix apni eb, jix yal el sk'aneal colbanile eb. ");
INSERT INTO knjNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ja' naj Felipe, ja' bey conob Samaria jix apni, jix c'oli yalon el sk'aneal Cristo snan xol eb ánima titu'. ");
INSERT INTO knjNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jix c'al yak' xiquin eb ánima yin tzet jix yal tu'. Jix yilon pax wan milagro eb jix el x'oxoni. ");
INSERT INTO knjNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ja' bey conob tu', ec'al eb ánima ey oc pena espíritu yin, pero chi c'al el can yin eb yu naj Felipe tu'. Jix el yaw eb pena espíritu, catu' jix el eb. Ec'al mac sicbinaj el smimanil, c'al eb c'am chi ske' sbeyi, jix wa'xi can yu naj Felipe tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yu wan tzet jix yun tu' xin, caw jix tzala a eb ánima bey jun conob tu'. ");
INSERT INTO knjNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ey jun winaj chi yij sbi Simón titu'. Caw chi etnewi ánima, yutol chi yala, tol miman yel oc apnoj, catu' ey tzet chi ske' yu. ");
INSERT INTO knjNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Masanil eb ánima chi yaoc sc'ul yin naj, eb yeynajil c'al eb mimej winaj, catu' chi yalon eb jaxca ti': —Ja' naj Simón ti', caw yel ey yipal Dios yin naj, ẍi eb. ");
INSERT INTO knjNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Caw chi yaoc sc'ul eb yin naj, yutol peyxa tax jix c'oli yetnen ánima naj, catu' chi yaloni tol tz'ajan ton sc'ul naj. ");
INSERT INTO knjNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero ja' naj Felipe xin, jix alon el xol eb tzet utbil chi yun yoc Dios Yaawil oj eb. Jix yalon pax el sk'aneal Jesucristo snan xol eb. Yuxan, ey winaj, c'al ix jix yaoc sc'ul yin tzet jix yal naj tu', catu' jix yak'on bautizar sba eb. ");
INSERT INTO knjNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ja' pax naj Simón tu', jix yaoc naj yin sc'ul tzet jix yal Felipe tu', catu' jix yak'on bautizar sba. Catu' jix oc tzajan xa c'al yintaj naj Felipe. Ey wan milagro jix el x'oxon Felipe tu', tol caw miman yel oc apnoj. Caw jix q'uey a sc'ul naj Simón tu' yet jix yilon naj. ");
INSERT INTO knjNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ja' yet jix yaben eb ẍejab Jesucristo ey ec' bey Jerusalén, tol ey mac jix yaoc sc'ul yin sk'ane Dios bey Samaria tu', catu' jix chejletoj naj Pedro yetoj naj Juan yu wan xa eb. ");
INSERT INTO knjNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ja' yet jix apni eb, jix txali eb yu eb creyente titu', yet watx' chi ẍa' can Santo Espíritu eb. ");
INSERT INTO knjNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Yutol c'am to junoj eb chi cha'on Santo Espíritu titu'. Asan tu' c'al yin sbi naj Kaawil Jesús jix ak'le bautizar eb. ");
INSERT INTO knjNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jix sbatxba atoj sk'ab naj Pedro yetoj naj Juan yiban sjolom eb, catu' jix ẍa'on can Santo Espíritu eb. ");
INSERT INTO knjNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ja' yet jix yilon naj Simón tol yet jix yaon atoj sk'ab eb yiban sjolom eb creyente tu', catu' jix ẍa'on can Santo Espíritu eb,